﻿USE sofia;
DROP TABLE IF EXISTS sofia.bgs_vpl;
CREATE TABLE bgs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bgs_vpl WRITE;
INSERT INTO bgs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tô tigkanayan ka langun, igimu ka Manama tô langit asta tô tibuk banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ándà pa bónnóng asta dalám katô banuwa. Mangittáng tô kaluwagan katô dagat, asta inalayun igpabówwó tô Ugis Espiritu tun ta dagat. ");
INSERT INTO bgs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Igkagi tô Manama, na mà din, “Duwán kappawaan.” Purisu duwán dán kappawaan. ");
INSERT INTO bgs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Igkita ka Manama na madigár tô kappawaan, asta igássa din tô kappawaan tikud tun ta kangittángngan. ");
INSERT INTO bgs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tô kappawaan, tô gó é igngadanan din na álló. Tô kangittángngan, tô gó é igngadanan din na dukilám. Igdukilám asta igsállám. Tô gó ipángnga tô una álló. ");
INSERT INTO bgs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Igkagi tô Manama, na mà din, “Massa tô wayig tun datas ka tanà asta tô wayig tun ta bówwó ka tanà.” ");
INSERT INTO bgs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Purisu inému dán ni. Igássa ka Manama tô wayig, su duwán sagulapun tun datas ka tanà, asta duwán wayig tun ta bówwó ka tanà. ");
INSERT INTO bgs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tô dadan tun datas ka tanà, tô gó é igngadanan ka Manama na langit. Igdukilám asta igsállám. Tô gó ipángnga tô ikaduwa álló. ");
INSERT INTO bgs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Igkagi tô Manama, na mà din, “Malimud tô wayig tun ta bówwó ka tanà ébô duwán matákkang lugar.” Inému dán ni. ");
INSERT INTO bgs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tô matákkang lugar, tô gó é igngadanan ka Manama na tanà. Tô wayig na ilimud, tô gó é igngadanan din na dagat. Igkita ka Manama na madigár tô igimu din. ");
INSERT INTO bgs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Na, igkagi tô Manama, na mà din, “Duwán marapung klasi ka pamulanán tun ta tanà, asta marapung klasi ka kayu. Duwán buuy na duwán lisu ébô tumubù yan puman.” Inému dán ni. ");
INSERT INTO bgs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Purisu igtubù dán tô marapung klasi ka pamulanán na duwán lisu, asta marapung tô klasi ka kayu na duwán buuy. Igkita ka Manama na madigár tô igimu din. ");
INSERT INTO bgs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Igdukilám asta igsállám. Tô gó ipángnga tô ikatállu álló. ");
INSERT INTO bgs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Igkagi tô Manama, na mà din, “Duwán tun ta langit na giló ébô massa tô álló asta tô dukilám. Tô gó é pató ka mga timpo, mga bulan, mga álló, asta mga ámmé. ");
INSERT INTO bgs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Duwán tun ta langit na ágsánnang ébô mappawà tô tanà.” Inému dán ni. ");
INSERT INTO bgs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Purisu duwa tô dakál giló na igimu ka Manama. Álló tô ágsánnang ka álló, asta bulan tô giló ka dukilám. Igimu din pagsik tô mga karani. ");
INSERT INTO bgs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Tô gó é igtagù ka Manama tun ta langit ébô mappawà tô tanà. ");
INSERT INTO bgs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Tô gó é igsánnang ka álló asta igiló ka dukilám ébô massa tô kappawaan asta tô kangittángngan. Igkita ka Manama na madigár tô igimu din. ");
INSERT INTO bgs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Igdukilám asta igsállám. Tô gó ipángnga tô ikappat álló. ");
INSERT INTO bgs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Igkagi tô Manama, na mà din, “Duwán marapung klasi na manté tun ta wayig asta dagat, asta duwán marapung klasi na lumayang tun datas ka tanà.” ");
INSERT INTO bgs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Purisu igimu ka Manama tô langun ka magdakál mga mannanap ka dagat, langun klasi na ágkanté tun ta wayig asta dagat, asta langun klasi ka manuk na áglayang. Igkita ka Manama na madigár tô igimu din. ");
INSERT INTO bgs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Madigár tô igbággé ka Manama tun ta langun dan, asta igkagiyan din tô langun na ágkanté tun ta wayig asta dagat, na mà din, “Rubbad kó, asta parapung kó ébô mapánnù tô dagat ákniyu.” Igkagiyan din tô mga manuk na áglayang, na mà din, “Parapung kó tun ta kaluwagan ka banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Igdukilám asta igsállám. Tô gó ipángnga tô ikalima álló. ");
INSERT INTO bgs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Igkagi tô Manama, na mà din, “Duwán marapung klasi na manté tun ta tanà, mga mannanap ka kappawaan asta mga mannanap ka kabánnássan, agad magdakál asta marénták.” Inému dán ni. ");
INSERT INTO bgs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Purisu igimu ka Manama tô langun dan, asta igkita din na madigár tô igimu din. ");
INSERT INTO bgs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Na, igkagi tô Manama, na mà din, “Mimu ki ka manubù na iring áknita. Imun ta sikandan na pangulu katô langun na igimu ta, agad mga sáddà, mga manuk, asta langun mannanap, agad dakál asta délák.” ");
INSERT INTO bgs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Purisu igimu ka Manama tô manubù na iring kandin. Iring ka Manama tô manubù na igimu din. Igimu din sikandan na mama asta bayi. ");
INSERT INTO bgs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Madigár tô igbággé ka Manama tun kandan, asta igkagi sikandin, na mà din, “Parapung kó ébô duwán mga karubbadan yu na móddô tun ta kaluwagan ka banuwa asta mangulu kó kandan. Sikiyu tô mangulu katô mga sáddà, mga manuk, asta langun mannanap na manté nit bówwó ka tanà.” ");
INSERT INTO bgs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Igkagi tô Manama, na mà din, “Igbággé ku ákniyu tô langun pamulanán na duwán lisu nit bówwó ka tanà asta tô langun kayu na duwán buuy ébô duwán ágkakan yu. ");
INSERT INTO bgs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Igbággé ku tô langun ka madigár mga pamulanán tun ta mga mannanap ka kappawaan, mga manuk, asta mga mannanap ka kabánnássan ébô duwán ágkakan ka langun na manté nit bówwó ka tanà.” Inému dán ni. ");
INSERT INTO bgs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Igsállág tô Manama tun ta langun igimu din, asta igkita din na madigár tô igimu din. Igdukilám asta igsállám. Tô gó ipángnga tô ikannám ka álló. ");
INSERT INTO bgs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Na, ipángnga dán igimu ka Manama tô langit asta tô tibuk banuwa, asta tô langun-langun. ");
INSERT INTO bgs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tô ándà pa dunggù tô ikapittu álló, ipángnga dán tô langun na igimu ka Manama. Purisu tun ta ikapittu álló igpaginawa sikandin tikud tun ta lumu din. ");
INSERT INTO bgs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Igássa ka Manama tô ikapittu álló para kandin. Tô gó é álló na igpaginawa sikandin, su ipángnga dán tô iglumu din. ");
INSERT INTO bgs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Iring kani tô kému katô langit asta tibuk banuwa. Tô igimu katô Áglangngagán na Manama ni banuwa asta tô langit, ");
INSERT INTO bgs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ándà pa pamulanán nit tanà, asta ándà igtubù, su ándà pa pódani katô Áglangngagán na Manama ni tanà, asta ándà pa manubù na igkamát. ");
INSERT INTO bgs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Asal duwán wayig na igsánnáp tikud tun dalám ka tanà ébô malámmás tô kaluwagan ka tanà. ");
INSERT INTO bgs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Na, igkangé tô Áglangngagán na Manama katô barukbuk ka tanà, asta igimu din tô manubù. Pángnga igimu, igidupan din tô idung katô manubù ébô lumaginawa. Purisu duwán dán kantayan katô manubù. ");
INSERT INTO bgs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Na, igimu katô Áglangngagán na Manama tô kayun tun ta Eden dadan tun ta silatan, asta tô gó é igpóddóan din katô manubù na igimu din. ");
INSERT INTO bgs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Igpamula katô Áglangngagán na Manama tô marapung klasi ka kayu. Tuu madigár ágsállággán, asta madigár tô buuy. Duwa tô kayu na igpamula din tun ta tángngaan katô kayun. Tô gó é kayu na ágbággé ka kantayan na ándà ágtamanán asta tô kayu na ágbággé katô mga manubù ka kagpáttan ka ándin tô madigár asta ka ándin tô madat. ");
INSERT INTO bgs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Duwán wayig tun ta Eden na áglámmás ka tanà. Dadan tun ta ágbabà ka Eden, igpasuwayé tô wayig, asta inému na ulu ka áppat magdakál mga wayig. ");
INSERT INTO bgs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Pison tô ngadan katô una wayig, asta igarus tun ta tanà na igngadanan Habila na ágkakitaan ka bulawan. ");
INSERT INTO bgs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Madigár tô bulawan dutun, asta duwán dità ka kayu na pamammut, asta mahal mga batu na dakál é lagà. ");
INSERT INTO bgs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Gihon tô ngadan katô ikaduwa wayig, asta igarus tun ta tanà na igngadanan Cus. ");
INSERT INTO bgs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tigris tô ngadan katô ikatállu wayig, asta igarus dadan tun ta silatan ka tanà na igngadanan Asiria. Eufrates tô ngadan katô ikappat wayig. ");
INSERT INTO bgs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Igpóddô katô Áglangngagán na Manama tô manubù tun ta kayun ka Eden ébô dumóppón asta ébô tumómmóng sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Igtalan tô Áglangngagán na Manama kandin, na mà din, “Mému kannán nu tô buuy katô langun kayu tun ta kayun, ");
INSERT INTO bgs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","asal yaka ágkan katô buuy ka kayu na ágbággé ka kagpáttan ka ándin tô madigár asta ka ándin tô madat. Su atin ka kuman ka kanan, maté ka gó yan álló yan.” ");
INSERT INTO bgs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Igkagi tô Áglangngagán na Manama, na mà din, “Dì madigár ka sábbad dád é manubù. Purisu imun ku tô duma din na nángngà para kandin ébô duwán tumabang kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Na, tikud tun ta tanà igimu katô Áglangngagán na Manama tô langun mannanap asta mga manuk. Igpid ka Manama ni langun tun ta manubù ébô ngadanan din. Agad ándin tô igngadan din, tô dán gó é ngadan dan. ");
INSERT INTO bgs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Purisu igngadanan katô manubù tô langun mannanap ka kappawaan, mga manuk, asta mga mannanap ka kabánnássan, asal tun kandan ándà palang nángngà para kandin. ");
INSERT INTO bgs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Purisu igpatudug katô Áglangngagán na Manama tô manubù. Róggun igtudug sikandin, igkangé ka Manama tô gusuk, asta igsagpángngan din tô amù ka ákkud. ");
INSERT INTO bgs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tô igkangé dán katô Áglangngagán na Manama tô gusuk, igimu din tô bayi tikud tun ta gusuk, asta igpid din tô bayi tun ta mama. ");
INSERT INTO bgs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Igkagi tô mama, na mà din, “Na, duwán dán gó! Tikud tun ta tullan ku tô kandin tullan, asta tikud tun ta ákkud ku tô kandin ákkud. Ngadanan ku sikandin na bayi, su igkangé sikandin tikud tun ta mama.” ");
INSERT INTO bgs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Purisu tumanan tô mama katô ámmà din asta katô innà din, asta pasábbadé tô mama asta tô sawa din. Tô duwa dan mému dán sábbad. ");
INSERT INTO bgs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Agad iglawa-lawa tô mama asta tô bayi, asal ándà dan payyaé. ");
INSERT INTO bgs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na, tun ta langun mannanap na igimu katô Áglangngagán na Manama, tô áppuy tô tuu katig áglimbung. Iginsà tô áppuy katô bayi, na mà din, “Bánnal na igkagi tô Manama ákniyu na dì mému kannán yu tô buuy ka langun kayu kannun ta kayun?” ");
INSERT INTO bgs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Igtaba tô bayi, na mà din, “Mému ké kuman katô mga buuy ka kayu kannun ta kayun. ");
INSERT INTO bgs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Asal igkagi tô Manama na kailangan dì ké kuman katô buuy ka kayu tun ta tángngaan kani kayun, asta kailangan dì ké mawid kanan su maté ké.” ");
INSERT INTO bgs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Asal igkagi tô áppuy, na mà din, “Dì kó gó maté. ");
INSERT INTO bgs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tô gó é igkagi ka Manama su isóddóran din na atin ka kuman kó kanan, duwán kasóddóran yu asta mému kó na iring kandin, su duwán dán kagpáttan yu ka ándin tô madigár asta ka ándin tô madat.” ");
INSERT INTO bgs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Na, ikagpát tô bayi na madigár kannán tô buuy katô kayu, madigár ágsállággán, asta ágbággé ka kagpáttan. Purisu igkangé din tô buuy asta igkan din. Duwán pagsik igbággé din tun ta duma din, asta igkan sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tô ikakan dan dán, duwán dán kagpáttan dan, asta isóddóran dan na iglawa-lawa dan. Purisu igkangé dan tô mga daun ka kayu igera asta igimu dan na pagtambun katô lawa dan. ");
INSERT INTO bgs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Na, tô mapun dán, igdinág dan tô kapanó-panó katô Áglangngagán na Manama tun ta kayun. Purisu igállás dan tun ta kayun ébô dì dan kitanán katô Áglangngagán na Manama. ");
INSERT INTO bgs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Asal igtawar tô Áglangngagán na Manama katô mama, na mà din, “Ánda ka?” ");
INSERT INTO bgs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Igtaba sikandin, na mà din, “Igdinág ku sikuna tun ta kayun, asta imáddanganna su iglawa-lawa a. Purisu igállássa.” ");
INSERT INTO bgs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Iginsà tô Manama, na mà din, “Manan ka isóddóran nu na iglawa-lawa ka? Sadan tô igulit áknikó? Igkan ka katô buuy ka kayu na igkagi ku áknikó na dì mému kannán?” ");
INSERT INTO bgs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Igkagi tô mama, na mà din, “Tô bayi na igpaduma nu kanak, tô gó é igbággé katô buuy kanak. Purisu igkanna.” ");
INSERT INTO bgs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Iginsà tô Áglangngagán na Manama katô bayi, na mà din, “Manan ka iglumu nu ni?” Igtaba tô bayi, na mà din, “Tô áppuy tô iglimbung kanak. Purisu igkanna.” ");
INSERT INTO bgs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Na, igkagi tô Áglangngagán na Manama katô áppuy, na mà din, “Supakan ka tingód kani madat na iglumu nu. Tun ta langun mannanap, sikuna dád tô supakan iring kani. Tikud nigó, dumullug-dullug kad tun ta barukbuk ka tanà sippang ka maté ka. ");
INSERT INTO bgs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Sikuna asta tô bayi pósigé, asta pósigé tô áknikó mga karubbadan asta tô kandin mga karubbadan. Bunalán katô mga karubbadan din tô ulu nu, asta kagatán nu tô palu dan.” ");
INSERT INTO bgs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Igkagi tô Manama katô bayi, na mà din, “Dugangan ku tô kahirapan ka kapamasusu nu. Atin ka mamasusu ka, riyun nu tô masakit. Asal kadigárran ka gó katô duma nu, asta mangulu sikandin áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Igkagi tô Manama katô mama, na mà din, “Igpaminág ka gó katô sawa nu, asta igkan ka katô buuy ka kayu na igkagi ku áknikó na dì mému kannán. Purisu tingód áknikó imun ku na mahirap tô kalumu nu ka tanà. Kailangan lumumu ka gó sippang ka maté ka ébô duwán ágkakan nu. ");
INSERT INTO bgs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tumubù tô mga sigbát asta tô mga dugin tun ta tanà, asta mapirit ka kuman katô mga pamulanán tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Inalayun ka lumumu asta atingan ébô duwán ágkakan nu sippang ka lábbángngán ka tun ta tanà, su igimu ka tikud tun ta tanà, asta lumónód ka tun ta tanà.” ");
INSERT INTO bgs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Igngadanan i Adan tô sawa din na si Eva, su sikandin tô mému na innà katô langun ka manté mga manubù. ");
INSERT INTO bgs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Duwán mga umpak na igimu katô Áglangngagán na Manama tikud tun ta kindal ka mga mannanap, asta igbággé din ki Adan asta katô sawa din. ");
INSERT INTO bgs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Na, igkagi tô Áglangngagán na Manama, na mà din, “Tô mga manubù inému dán na iring áknita, su duwán dán kagpáttan dan tingód ka ándin tô madigár asta ka ándin tô madat. Dì mému mudù dan katô buuy tikud tun ta kayu na makabággé ka kantayan na ándà ágtamanán, su atin ka kannán dan, dì dan gó maté ka ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Purisu igpéwà katô Áglangngagán na Manama tô duwa manubù tikud tun ta kayun ka Eden. Igpalumu ka Manama si Adan katô tanà na igtikudan din. ");
INSERT INTO bgs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tô igpéwà dán ka Manama tô mga manubù tikud tun ta Eden, igpabanté din tô mga panaligan na ágngadanan kerubin dadan tun ta silatan katô kayun, asta igtagù ka Manama tô kampilan na ágrágrág asta ágbiring-biring ébô ándà palang manubù na makapadani tun ta kayu na ágbággé ka kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Na, igpalayuké si Adan asta tô sawa din, asta igmabáddás si Eva. Tô ipamasusu dán tô batà din, igkagi si Eva, na mà din, “Ukit ka tabang katô Áglangngagán, itanggap ku tô batà ku mama.” Purisu igngadanan din tô batà din ki Cain. ");
INSERT INTO bgs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Pángnga ipamasusu si Cain, ipamasusu puman tô adi din mama na si Abel. Tô igdakál dán tô duwa gabatà, si Abel tô ágdóppón ka mga karnero, asta si Cain tô ágkamát. ");
INSERT INTO bgs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Na, duwán álló na igpid i Cain tô mga buuy katô igpamula din ébô bággén din tun ta Áglangngagán, ");
INSERT INTO bgs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","asta si Abel tô igsalin katô madigár tambang kaké nati ka karnero din, igiyó din, asta igpid din tô tuu madigár ákkud ébô bággén din tun ta Manama. Igtanggap katô Áglangngagán tô igbággé i Abel. ");
INSERT INTO bgs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Asal ándà tanggapi ka Manama tô igbággé i Cain. Purisu tuu isókó si Cain, asta igtammud sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na, iginsà tô Áglangngagán ki Cain, na mà din, “Manan ka isókó ka? Manan ka igtammud ka? ");
INSERT INTO bgs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tumanggappa áknikó ka nángngà tô áglumun nu. Asal ka dì nángngà tô lumun nu, banté ka, su iring na ágbanganan ka katô salà ébô talun ka. Asal kailangan makapanalu ka katô salà.” ");
INSERT INTO bgs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Na, ándà kadugé, igkagi si Cain katô kataladi din na si Abel, na mà din, “Madun ki tun ta kinamát.” Tô igdunggù dan dán tun ta kinamát, igpadaniyan i Cain tô kataladi din, asta igmatayan din. ");
INSERT INTO bgs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Na, iginsà tô Áglangngagán ki Cain, na mà din, “Ánda tô kataladi nu na si Abel?” Igtaba si Cain, na mà din, “Taman. Ánnà a taradóppón katô kataladi ku.” ");
INSERT INTO bgs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Igkagi tô Áglangngagán, na mà din, “Manan ka iglumu nu ni madat? Iring na ágtawar kanak tô dipanug katô kataladi nu tikud tun ta tanà! ");
INSERT INTO bgs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tikud áknganni, supakan ku sikuna, asta ándà dán pulusán nu tun ta pamulanán tun ta tanà, su tanà tô igránnábban katô dipanug din. ");
INSERT INTO bgs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Atin ka kumamát ka, dì muuy tô pamulanán nu. Tikud áknganni, ándà dán óddóan nu, asta tumalap-talap ka nit banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Igkagi si Cain, na mà din, “Diya makatiis katô supak nu kanak. ");
INSERT INTO bgs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Péwaán ad ikuna nigó ébô diyad mamula, asta papanónnad ikuna tikud tun ta saruwan nu. Inalayunna tumalap-talap nit banuwa. Atin ka kitanánna ka duma mga manubù, matayanna.” ");
INSERT INTO bgs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Asal igkagi tô Áglangngagán kandin, na mà din, “Dì matuman yan, su atin ka duwán mimmaté áknikó, sulian asta supakan ku ka makapittu.” Purisu igpatówan katô Áglangngagán si Cain ébô dì matayan ka manubù na kumita kandin. ");
INSERT INTO bgs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Purisu igtanan si Cain katô Áglangngagán, asta igóddô sikandin tun ta lunsud ka Nod, dadan tun ta silatan ka Eden. ");
INSERT INTO bgs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Na, igpalayuké si Cain asta tô sawa din, asta duwán batà dan na ipamasusu na si Enoc. Ándà kadugé, igimu si Cain ka dakál lunsud, asta igngadanan din pagsik Enoc na magunawa katô ngadan ka batà din. ");
INSERT INTO bgs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Si Enoc tô ámmà i Irad. Si Irad tô ámmà i Mehujael. Si Mehujael tô ámmà i Metusael. Si Metusael tô ámmà i Lamec. ");
INSERT INTO bgs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Igduwé si Lamec. Si Ada tô ngadan katô una sawa din, asta si Sela tô ngadan katô ikaduwa sawa din. ");
INSERT INTO bgs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Si Ada tô innà i Jabal, asta si Jabal tô inému na kamónaan katô langun na igóddô tun ta mga tulda asta ágdóppón ka mga mannanap. ");
INSERT INTO bgs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Duwán adi i Jabal na si Jubal, asta sikandin tô inému na kamónaan katô langun manubù na katig ágpadaging ka alpa asta gidup ka plawta. ");
INSERT INTO bgs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si Sela tô innà i Tubal-Cain na taraimu ka talumbaga asta putó. Duwán tábbé i Tubal-Cain na si Naama. ");
INSERT INTO bgs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Igkagi si Lamec katô duwa sawa din, na mà din, “Ada asta Sela, paminág kó kanak, su duwán ulitán ku ákniyu. Igmatayan ku tô mallaki na igsuntuk asta igamù kanak. ");
INSERT INTO bgs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Atin ka makapittu tô kadattan ka supak na dumunggù tun ta manubù na mimmaté ki Cain, kapittuwan pittu (77) pa tô kadattan ka supak na dumunggù tun ta manubù na sumulì kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Na, pángnga inaté si Abel, igpalayuké si Adan asta tô sawa din, asta ipamasusu tô batà mama. Igkagi si Eva, na mà din, “Igbággayanna ka Manama kani batà na ikabullas ki Abel, su igmatayan i Cain.” Purisu igngadanan din tô batà din ki Set. ");
INSERT INTO bgs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Duwán batà mama na ipamasusu katô sawa i Set, asta igngadanan i Set tô batà din ki Enos. Na, tô gó tô timpo na igtigkané tô mga manubù na iggamit katô ngadan na Áglangngagán tun ta kapangadap dan katô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ni gó tô mga ngadan katô rubbad i Adan. Tô igimu ka Manama tô manubù, igimu din sikandin na iring kandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Igimu din tô manubù mama asta bayi. Madigár tô igbággé din kandan, asta igngadanan din sikandan na manubù. ");
INSERT INTO bgs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tô sábbad gatus tállu pulù (130) dán tô idad i Adan, ipamasusu tô batà din mama iring kandin. Igngadanan din tô batà din ki Set. ");
INSERT INTO bgs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Pángnga ipamasusu si Set, walu gatus (800) ámmé tô iglabé sippang ka inaté si Adan, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tô siyó gatus tállu pulù (930) dán tô idad i Adan, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tô sábbad gatus lima (105) dán tô idad i Set, ipamasusu tô batà din mama na si Enos. ");
INSERT INTO bgs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pángnga ipamasusu si Enos, walu gatus pittu (807) ámmé tô iglabé sippang ka inaté si Set, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tô siyó gatus sapulù duwa (912) dán tô idad i Set, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tô kasiyawan (90) dán tô idad i Enos, ipamasusu tô batà din mama na si Cainan. ");
INSERT INTO bgs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Pángnga ipamasusu si Cainan, walu gatus sapulù lima (815) ámmé tô iglabé sippang ka inaté si Enos, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tô siyó gatus lima (905) dán tô idad i Enos, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tô kapittuwan (70) dán tô idad i Cainan, ipamasusu tô batà din mama na si Mahalaleel. ");
INSERT INTO bgs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pángnga ipamasusu si Mahalaleel, walu gatus kappatan (840) ámmé tô iglabé sippang ka inaté si Cainan, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tô siyó gatus sapulù (910) dán tô idad i Cainan, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tô kannámman lima (65) dán tô idad i Mahalaleel, ipamasusu tô batà din mama na si Jared. ");
INSERT INTO bgs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Pángnga ipamasusu si Jared, walu gatus tállu pulù (830) ámmé tô iglabé sippang ka inaté si Mahalaleel, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tô walu gatus kasiyawan lima (895) dán tô idad i Mahalaleel, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tô sábbad gatus kannámman duwa (162) dán tô idad i Jared, ipamasusu tô batà din mama na si Enoc. ");
INSERT INTO bgs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Pángnga ipamasusu si Enoc, walu gatus ámmé (800) tô iglabé sippang ka inaté si Jared, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tô siyó gatus kannámman duwa (962) dán tô idad i Jared, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tô kannámman lima (65) dán tô idad i Enoc, ipamasusu tô batà din mama na si Metusela. ");
INSERT INTO bgs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Pángnga ipamasusu si Metusela, maggát igpamaké si Enoc katô Manama ka tállu gatus (300) ámmé. Duwán duma mga gabatà i Enoc na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Igdunggù dán tô idad din ka tállu gatus kannámman lima (365). ");
INSERT INTO bgs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inalayun maggát igpamaké si Enoc katô Manama sippang ka álló na inandà sikandin, su igbatun sikandin ka Manama tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tô sábbad gatus kawaluwan pittu (187) dán tô idad i Metusela, ipamasusu tô batà din mama na si Lamec. ");
INSERT INTO bgs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Pángnga ipamasusu si Lamec, pittu gatus kawaluwan duwa (782) ámmé tô iglabé sippang ka inaté si Metusela, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tô siyó gatus kannámman siyó (969) dán tô idad i Metusela, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tô sábbad gatus kawaluwan duwa (182) dán tô idad i Lamec, duwán batà din mama na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Igkagi sikandin, na mà din, “Ni gó tô manubù na papaginawa áknita tikud tun ta kahirapan ka lumu ta nit tanà tingód katô supak katô Áglangngagán.” Purisu igngadanan din tô batà din ki Noe. ");
INSERT INTO bgs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Pángnga ipamasusu si Noe, lima gatus kasiyawan lima (595) ámmé tô iglabé sippang ka inaté si Lamec, asta duwán duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tô pittu gatus kapittuwan pittu (777) dán tô idad i Lamec, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Pángnga ka lima gatus (500) tô idad i Noe, ipamasusu tô tállu gabatà din gamama na si Sem, si Ham, asta si Japet. ");
INSERT INTO bgs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Na, tô igmarapung dán tô mga manubù nit bówwó ka tanà, asta tô igmarapung dán tô mga gabayi na ipamasusu, ");
INSERT INTO bgs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","duwán mga sakup ka Manama na igkita na madigár tô bónnóng katô mga gabayi. Purisu igkalyagan dan tô mga gabayi na idigárran dan. ");
INSERT INTO bgs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na, igkagi tô Áglangngagán, na mà din, “Dì mému kanak ka manté tô mga manubù ka ándà ágtamanán, su manubù dan dád na ágkamaté. Tikud nigó, sippang dád man ka sábbad gatus duwa pulù (120) tô idad ka mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tô timpo sayyan asta tô mga ámmé na iglabé, duwán mga higante, su sikandan tô mga rubbad ka mga sakup ka Manama tikud tun ta langit na iglayuk katô mga gabayi nit banuwa. Magani asta ibantug dan sayyan. ");
INSERT INTO bgs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Igkita katô Áglangngagán na tuu madat tô áglumun katô mga manubù nit banuwa, asta inalayun madat tô panámdám dan asta tô kakalyag dan. ");
INSERT INTO bgs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Purisu igrákkád tô Áglangngagán tingód katô mga manubù na igimu din asta igpóddô din nit banuwa. Tuu iranu sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Purisu igkagi tô Áglangngagán, na mà din, “Iwaán ku tô mga manubù na igimu ku tikud tun ta bówwó ka tanà. Ipánnasán ku tô mga manubù, tô mga mannanap, asta tô mga manuk, su igrákkádda na igimu kandan.” ");
INSERT INTO bgs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Asal idayawan gó tô Áglangngagán tingód ki Noe. ");
INSERT INTO bgs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ni gó tô igulit tingód ki Noe. Tun ta langun manubù, si Noe dád tô igtanggap ka Manama na nángngà tun ta saruwan din, asta dì ágkabuyas sikandin. Igpadumaé si Noe asta tô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Tállu tô gabatà din gamama, na si Sem, si Ham, asta si Japet. ");
INSERT INTO bgs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Asal igkita ka Manama na ássa dád ki Noe, madat tô langun manubù nit banuwa, asta ipánnù tô kaluwagan ka banuwa ka samuk. ");
INSERT INTO bgs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Igsállág tô Manama tun ta banuwa, asta igkita din na madat tô langun manubù, su inalayun madat tô áglumun dan. ");
INSERT INTO bgs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Igkagi tô Manama ki Noe, na mà din, “Kakalyag ku na dadattan ku tô langun nit banuwa. Purisu ipánnasán ku tô langun manubù, su ipánnù dán tô kaluwagan ka banuwa katô madat mga áglumun dan. ");
INSERT INTO bgs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Purisu imu ka ka arka ka madigár klasi ka kayu ébô duwán sakayan nu. Imu nu tô mga kuwarto tun dalám katô arka, asta padákkátti nu ka ispalto tô tun dalám asta tô tun ta luwà ébô dì makahu tô wayig. ");
INSERT INTO bgs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Sábbad gatus tállu pulù tállu (133) metros tô kalaguyudan katô arka, duwa pulù duwa (22) metros tô kaluwagan, asta sapulù tállu (13) metros tô kallayatan. ");
INSERT INTO bgs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atáppi nu tô arka, asta imu nu tô gukitan ka karamag madani tun ta atáp na tángngà ka metro tô kallayat. Imu nu ka tállu andana tô tun dalám asta sábbad sállat tô tun ta kilidan. ");
INSERT INTO bgs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Palunupan ku ni tanà ka wayig ébô mapánnas tô langun áglaginawa. Maté tô langun nit banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Asal mimuwa ka kasabotan tun áknikó ébô manté ka. Ahu kó tun ta arka, sikuna, tô mga gabatà nu, tô sawa nu, asta tô mga ikóddô áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Pid nu tô sábbad mama asta sábbad bayi tikud tun ta tagsábbad-sábbad klasi ka mga mannanap asta mga manuk. Madun dan tun áknikó ébô manté. ");
INSERT INTO bgs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Pid nu pagsik tô marapung klasi ka makan ébô duwán ágkakan para ákniyu langun.” ");
INSERT INTO bgs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Na, igtuman i Noe tô langun sugù ka Manama kandin. ");
INSERT INTO bgs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Na, igkagi tô Áglangngagán ki Noe, na mà din, “Ahu ka asta tô pamilya nu tun ta arka, su agad marapung tô mga manubù áknganni, sikuna dád tô nángngà kannun ta saruwan ku. ");
INSERT INTO bgs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Pid nu tô tagpittu paris na mama asta bayi tikud tun ta tagsábbad-sábbad klasi ka mannanap na mému góbbón asta bággén kanak, asta pid nu tô tagsábbad paris na mama asta bayi tikud tun ta tagsábbad-sábbad klasi ka mannanap na dì mému góbbón asta bággén kanak. ");
INSERT INTO bgs_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Pid nu tô tagpittu paris na mama asta bayi tikud tun ta tagsábbad-sábbad klasi ka manuk ébô duwán puman rubbad katô langun nit bówwó ka tanà. ");
INSERT INTO bgs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Na, pángnga ka pittu álló, pódanán ku, asta dì tumikkas sippang ka kappatan (40) álló asta kappatan (40) dukilám ébô ipánnasán ku tô langun áglaginawa na igimu ku nit bówwó ka tanà.” ");
INSERT INTO bgs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Igtuman i Noe tô langun sugù katô Áglangngagán kandin. ");
INSERT INTO bgs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tô iglunupan ni banuwa, ánnám gatus (600) tô idad i Noe. ");
INSERT INTO bgs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Igsaké sikandin katô arka, asta igtákkás tô mga gabatà din, tô sawa din, asta tô mga ikóddô kandin ébô dì dan mapánnas ka lunup. ");
INSERT INTO bgs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ilimud tô tagsábbad paris na mama asta bayi tikud tun ta tagsábbad-sábbad klasi ka mga mannanap asta mga manuk, agad tô mému góbbón asta bággén tun ta Manama, asta tô dì mému góbbón. Igsadun tô langun tun ki Noe, asta igahu tun ta arka, iring katô igsugù ka Manama ki Noe. ");
INSERT INTO bgs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Pángnga ka pittu álló, igtigkané iglunupan tô banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tô ánnám gatus (600) tô idad i Noe, tun ta ikasapulù pittu (17) álló ka ikaduwa bulan katô ámmé, ipókéan tô langun sánnáp tun dalám ka dagat, asta ipókéan tô langun ágtikudan ka udan tun ta kawang-awangan. ");
INSERT INTO bgs_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Na, igudan ka kappatan (40) álló asta kappatan (40) dukilám. ");
INSERT INTO bgs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tô ándà pa lunupi tô tanà, taganà igahu si Noe tun ta arka asta tô mga gabatà din na si Sem, si Ham, asta si Japet, tô sawa i Noe, asta tô mga ikóddô kandin. ");
INSERT INTO bgs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Igahu tô langun klasi ka mannanap na magdakál asta marénták, asta langun klasi ka manuk. ");
INSERT INTO bgs_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Igsadun tô tagduwa-duwa katô mga klasi na áglaginawa, asta igahu dan tun ta arka tákkás ki Noe. ");
INSERT INTO bgs_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Duwán mama asta bayi, iring katô igsugù ka Manama ki Noe. Pángnga igahu dan, igsagpángngan katô Áglangngagán tô sállat katô arka. ");
INSERT INTO bgs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Dalám ka kappatan (40) álló asta kappatan (40) dukilám, inalayun igudan, asta igmadalám tô wayig sippang ka igkapó tô arka. ");
INSERT INTO bgs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Inalayun igmadalám tô wayig tun ta banuwa, asta igkapó-kapó tô arka tun ta bówwó ka wayig. ");
INSERT INTO bgs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Inalayun igmadalám tô wayig tun ta banuwa sippang ka iglunupan tô langun ka mallayat mga pabungan. ");
INSERT INTO bgs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Igmadalám tô wayig sippang ka pittu metros tô kadalámman tun ta bówwó ka mga pabungan. ");
INSERT INTO bgs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Purisu inaté tô langun tun ta bówwó ka tanà, agad mga manuk, mga mannanap, asta mga manubù. ");
INSERT INTO bgs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Inaté tô langun na áglaginawa nit bówwó ka tanà. ");
INSERT INTO bgs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Igipánnas ka Manama tô langun manubù, mga mannanap, asta mga manuk. Si Noe dád tô isamà, asta tô mga igduma kandin tun dalám katô arka. ");
INSERT INTO bgs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Sábbad gatus kaliman (150) álló tô kadugayan katô lunup. ");
INSERT INTO bgs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ándà kalingawi ka Manama si Noe asta tô langun mannanap na igduma kandin tun ta arka. Igpakaramagan ka Manama tô wayig, asta igtigkané dán tô wayig igdélák. ");
INSERT INTO bgs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Igdalangan ka Manama tô mga sánnáp tun dalám ka dagat asta tô mga ágtikudan ka udan tun ta kawang-awangan. Purisu igtikkas tô udan. ");
INSERT INTO bgs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tô iglabé dán tô sábbad gatus kaliman (150) álló, igdélák tô wayig. ");
INSERT INTO bgs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tô iglabé dán tô lima bulan, ikasapat tô arka tun ta Pabungan ka Ararat. ");
INSERT INTO bgs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Igpanayun igdélák tô wayig, asta pángnga ka duwa bulan ágtángngà, ikitaan tô bówwó ka mga pabungan. ");
INSERT INTO bgs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Pángnga ka kappatan (40) álló, igpókéan i Noe tô téwang katô arka, ");
INSERT INTO bgs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","asta igpaluwà din tô sábbad uwak. Asal ándà lónód tô uwak tun ta arka su inalayun iglayang-layang sippang ka matákkang tô tanà. ");
INSERT INTO bgs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Na, igpaluwà i Noe tô sábbad salapati ébô kasóddóran din ka matákkang dán tô tanà. ");
INSERT INTO bgs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Asal su iglunupan pa tô tanà, ándà kita tô salapati ka madigár apunan din. Purisu iglónód tô salapati tun ta arka. Igtapaya i Noe tô bállad din asta igpahu din tô salapati. ");
INSERT INTO bgs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Pángnga ka sábbad linggo, igpaluwà din puman tô salapati. ");
INSERT INTO bgs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tô igsalláp dán tô álló, iglónód tô salapati tun ki Noe, asta duwán mantu daun ka kayu olibo na igpid tun ta tuktuk din. Purisu isóddóran i Noe na igdélák dán tô wayig tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Na, igangat si Noe ka sábbad linggo, asta igpaluwà din puman tô salapati. Asal ándà dán lónód. ");
INSERT INTO bgs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na, tô ánnám gatus sábbad (601) tô idad i Noe, tun ta una álló ka una bulan ka ámmé, igdélák tô wayig tun ta tanà. Igkangé i Noe tô atáp katô arka ébô sumállág sikandin. Igkita din na itákkang dán sagpu tô bówwó ka tanà. ");
INSERT INTO bgs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tô iglabé tô duwa pa bulan, tuu itákkang tô tanà. ");
INSERT INTO bgs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Purisu igkagi tô Manama ki Noe, na mà din, ");
INSERT INTO bgs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Luwà kód tikud tun ta arka, agad tô sawa nu, tô mga gabatà nu, asta tô mga ikóddô áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Paluwà nu tô langun manuk asta mga mannanap na magdakál asta marénták ébô rumubbad dan asta kumarapung dan tun ta banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Purisu igluwà si Noe tikud tun ta arka na igtákkássan katô mga gabatà din, sawa din, asta mga ikóddô kandin. ");
INSERT INTO bgs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Igluwà tô tagsábbad-sábbad klasi ka mga mannanap na magdakál asta marénták, asta mga manuk. ");
INSERT INTO bgs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Na, iglimud i Noe tô mga batu ébô imun din tô ággóbbówanan ka mannanap na bággén tun ta Áglangngagán. Duwán igmatayan din tun ta tagsábbad-sábbad klasi ka mannanap asta manuk na mému góbbón asta bággén tun ta Manama, asta iggóbbó din. ");
INSERT INTO bgs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Tô ingadággan dán katô Áglangngagán tô mammut, idayawan sikandin, asta igpanámdám sikandin, na mà din, “Agad madat tô kakalyag ka mga manubù tikud tun ta kapamasusu kandan, asal diyad muman dumadat katô tanà tingód ka madat áglumun katô mga manubù. Diyad muman mipánnas katô langun manubù asta mga mannanap. ");
INSERT INTO bgs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Sippang ka duwán pa banuwa, inalayun duwán timpo para ka kapamula asta kakáttu, ágmagánnó asta ágménit, ágsánnang asta gudan, álló asta dukilám.” ");
INSERT INTO bgs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Madigár tô igbággé ka Manama ki Noe asta katô pamilya din, asta igkagi sikandin, na mà din, “Batà kód ka marapung ébô duwán mga rubbad yu na móddô tun ta kaluwagan ka banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tikud áknganni, kamáddangan ákniyu tô langun mannanap, mga manuk, asta mga sáddà. Imun ku sikiyu na pangulu katô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mému kannán yu tô mga mannanap asta tô mga pamulanán, su igbággé kud tô langun ákniyu para ágkakan. ");
INSERT INTO bgs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Asal sábbad dád tô dì mému kannán yu, tô gó ákkud na duwán pa dipanug, su duwán kantayan ukit ka dipanug. ");
INSERT INTO bgs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Dì mému ka duwán mimmaté. Atin ka duwán mannanap na mimmaté katô manubù, kailangan matayan. Atin ka duwán manubù na mimmaté katô duma manubù, kailangan matayan sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Igimu ka Manama tô manubù na iring kandin. Purisu kailangan matayan tô manubù na mimmaté katô duma manubù. ");
INSERT INTO bgs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Batà kód ka marapung ébô duwán mga rubbad yu na móddô tun ta kaluwagan ka banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Na, igkagi tô Manama ki Noe asta katô pamilya din, na mà din, ");
INSERT INTO bgs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Mimuwa ka kasabotan tun ákniyu asta tun ta mga rubbad yu, ");
INSERT INTO bgs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","asta tun ta langun manuk asta mga mannanap na igduma ákniyu tun ta arka. ");
INSERT INTO bgs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mimuwa ka kasabotan tun ákniyu. Tô langun na áglaginawa dì dán puman mapánnas ka lunup. Dì kud puman dadattan tô banuwa ukit ka lunup.” ");
INSERT INTO bgs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Igkagi tô Manama, na mà din, “Duwán pató na imun ku ébô kasóddóran yu na tumanán ku tô kasabotan ku tun ákniyu asta tun ta langun na áglaginawa nit banuwa sippang ka duwán pa mga manubù. ");
INSERT INTO bgs_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Taguán ku tô binangunan tun ta sagulapun. Tô gó é pató tingód ka kasabotan ku tun ta mga góddô nit banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Atin ka duwán sagulapun nit banuwa, asta makita tô binangunan tun ta sagulapun, ");
INSERT INTO bgs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kasampáttan ku tô kasabotan ku tun ákniyu asta tun ta langun na áglaginawa na dì dán móman mapánnas tô langun ukit ka lunup. ");
INSERT INTO bgs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Atin ka duwán binangunan tun ta sagulapun, kitanán ku, asta kasampáttan ku tô kasabotan ku na ándà ágtamanán tun ta langun na áglaginawa nit banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Igkagi tô Manama, na mà din, “Tô gó é pató tingód katô kasabotan ku tun ta langun na áglaginawa nit banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Tô mga gabatà i Noe na igluwà tikud tun ta arka, tô gó si Sem, si Ham, asta si Japet. (Si Ham tô ámmà i Canaan.) ");
INSERT INTO bgs_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tô tállu gabatà i Noe, tô gó é mga kamónaan katô langun manubù na góddô nit banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Na, igtigkané si Noe igkamát, asta igpamula sikandin ka paras. ");
INSERT INTO bgs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tô iginám din tô bino na igimu din tikud tun ta buuy ka paras, ilasing sikandin. Igdággà sikandin na ándà tambun katô lawa din tun dalám ka tulda na igóddóan din. ");
INSERT INTO bgs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Igsállág si Ham na ámmà i Canaan na ándà tambun katô lawa katô ámmà din. Igluwà sikandin asta igulit katô mga kataladi din. ");
INSERT INTO bgs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Purisu igkangé i Sem asta i Japet tô kisì ébô tambunan tô lawa din. Igawidan dan tô kisì tun ta bókkóg dan, asta igpanó ta bókkóg na igahu tun ta tulda din. Igtambunan dan tô lawa din, asal ándà dan sérê ébô dì dan kitanán tô lawa katô ámmà dan. ");
INSERT INTO bgs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tô ikaginónó dán si Noe tikud ka kalasingan din, isóddóran din tô iglumu i Ham kandin. ");
INSERT INTO bgs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Purisu igkagi sikandin, na mà din, “Supakan katô Manama si Canaan na batà i Ham. Imun sikandin na állang katô mga kataladi din. ");
INSERT INTO bgs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mólà pa ka madigár tô bággén katô Áglangngagán na Manama ki Sem, asta imun si Canaan na állang i Sem. ");
INSERT INTO bgs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mólà pa ka imun ka Manama na maluwag tô góddóan katô mga rubbad i Japet. Bággayan dan pagsik ka Manama katô madigár na bággén din tun ta mga rubbad i Sem. Asal imun tô mga rubbad i Canaan na állang katô mga rubbad i Japet.” ");
INSERT INTO bgs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pángnga katô lunup, tállu gatus kaliman (350) ámmé pa tô iglabé sippang ka inaté si Noe. ");
INSERT INTO bgs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tô siyó gatus kaliman (950) dán tô idad i Noe, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ni gó tô mga ngadan ka rubbad katô tállu gabatà i Noe, na si Sem, si Ham, asta si Japet, su duwán mga gabatà dan na ipamasusu pángnga katô lunup. ");
INSERT INTO bgs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Tô mga gabatà gamama i Japet, tô gó si Gomer, si Magog, si Madai, si Jaban, si Tubal, si Mesec, asta si Tiras. ");
INSERT INTO bgs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Tô mga gabatà i Gomer, tô gó si Askenas, si Rifat, asta si Togarma. ");
INSERT INTO bgs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Tô mga rubbad i Jaban, tô gó si Elisa, si Tarsis, asta tô mga taga Kiti asta tô mga taga Dodani. ");
INSERT INTO bgs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sikandan tô mga kamónaan katô langun manubù na góddô madani tun ta dagat asta tun ta mga purù. Tô gó é mga rubbad i Japet. Igóddô tô tagsábbad-sábbad grupo tun ta kandan banuwa, asta duwán kinagiyan ka tagsábbad-sábbad grupo. ");
INSERT INTO bgs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Tô mga gabatà gamama i Ham, tô gó si Cus, si Ehipto, si Put, asta si Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Tô mga gabatà gamama i Cus, tô gó si Seba, si Habila, si Sabata, si Raama, asta si Sabaca. Tô mga gabatà gamama i Raama, tô gó si Saba asta si Dadan. ");
INSERT INTO bgs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Duwán sábbad rubbad i Cus na igngadanan ki Nimrod, asta sikandin tô una manubù na inému ibantug tingód ka kagani din. ");
INSERT INTO bgs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Katig sikandin ágpanà ukit ka tabang katô Áglangngagán. Purisu ágkagi tô mga manubù, na mà dan, “Mólà pa ka imun ka katô Manama na katig ágpanà iring ki Nimrod.” ");
INSERT INTO bgs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Tô inému dán si Nimrod na harì, igpangulu sikandin katô mga lunsud ka Babel, Erac, asta Acad, na tállu lunsud tun ta Sinar. ");
INSERT INTO bgs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Tikud dutun, igsadun sikandin tun ta Asiria, asta igimu sikandin ka mga lunsud ka Ninibe, Rehobot-Ir, Cala, ");
INSERT INTO bgs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","asta Resen tun ta tángngaan ka Ninibe asta dakál lunsud na Cala. ");
INSERT INTO bgs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Si Ehipto tô kamónaan ka langun manubù na igóddô tun ta Lud, Anam, Laab, Neftu, ");
INSERT INTO bgs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fetrusim, Casluim, asta Caftor na kamónaan ka langun Filistihanon. ");
INSERT INTO bgs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Tô mga gabatà i Canaan, tô gó si Sidon na tambang kaké, asta si Het. ");
INSERT INTO bgs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Si Canaan tô kamónaan katô mga Jebusihanon, Amorihanon, Girgasihanon, ");
INSERT INTO bgs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hebihanon, Arkihanon, Sinaihanon, ");
INSERT INTO bgs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadihanon, Semarihanon, asta Hamatihanon. Italap tô tagsábbad-sábbad grupo ka mga rubbad i Canaan ");
INSERT INTO bgs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","sippang ka isakup dan tô kaluwagan ka banuwa tikud tun ta lunsud ka Sidon sippang tun ta lunsud ka Gerar na madani tun ta Gasa, asta isakup tô mga lunsud ka Sodoma, Gomora, Adma, asta Seboim madani tun ta Lasa. ");
INSERT INTO bgs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Tô gó é mga rubbad i Ham. Igóddô tô tagsábbad-sábbad grupo tun ta kandan mga banuwa, asta duwán kinagiyan ka tagsábbad-sábbad grupo. ");
INSERT INTO bgs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Si Sem na kaké i Japet, tô gó é kamónaan katô langun rubbad i Eber. ");
INSERT INTO bgs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Tô mga gabatà i Sem, tô gó si Elam, si Asur, si Arfacsad, si Lud, asta si Aram, asta tô gó tô mga ngadan ka rubbad dan. ");
INSERT INTO bgs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Tô mga gabatà i Aram, tô gó si Us, si Hul, si Geter, asta si Mes. ");
INSERT INTO bgs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arfacsad tô ámmà i Sela, asta si Sela tô ámmà i Eber. ");
INSERT INTO bgs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Duwa tô gabatà i Eber. Igngadanan tô kaké ki Peleg, su tô kapamasusu kandin, itángngà-tángngà tô langun manubù nit banuwa. Igngadanan tô adi din ki Joctan. ");
INSERT INTO bgs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Si Joctan tô kamónaan i Almodad, si Selap, si Hasarmabet, si Jera, ");
INSERT INTO bgs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","si Hadoram, si Usal, si Dicla, ");
INSERT INTO bgs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","si Obal, si Abimael, si Seba, ");
INSERT INTO bgs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","si Opir, si Habila, asta si Jobab. Mga gabatà i Joctan tô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Igóddô tô mga rubbad i Joctan tun ta tanà na tikud tun ta Mesa sippang tun ta Separ tun ta pabungan na dadan tun ta silatan. ");
INSERT INTO bgs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tô gó é mga rubbad i Sem. Igóddô tô tagsábbad-sábbad grupo dan tun ta kandan mga banuwa, asta duwán kinagiyan ka tagsábbad-sábbad grupo. ");
INSERT INTO bgs_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Tô gó tô mga rubbad katô mga gabatà i Noe, asta duwán mga grupo asta mga pamilya ka tagsábbad-sábbad kandan. Pángnga katô lunup, igtalap tô langun manubù tun ta tagsábbad-sábbad grupo ka banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sayyan, tô ándà pa katalap tô mga manubù, sábbad dád tô kinagiyan katô langun manubù nit banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tô igalin-alin dan dán, duwán igsadun dadan tun ta silatan, sippang ka igdunggù dan tun ta tanà na maluwag asta pattad tun ta Sinar, asta igóddô dan dutun. ");
INSERT INTO bgs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Igpatóngkóé sikandan, na mà dan, “Na, imun ta tô tisa asta patákkangán sippang ka kumatággas ébô duwán pagimu ta katô turi.” Purisu igimu dan tô mga tisa, asta igkangé dan tô ispalto para padákkát katô mga tisa ébô imun dan turi. ");
INSERT INTO bgs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na, igkagi sikandan, na mà dan, “Mimu ki ka lunsud asta sábbad turi sippang tun ta kawang-awangan ébô mabantug ki, asta dì ki matalap tun ta kaluwagan kani banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Na, igsadun tô Áglangngagán ébô kumita katô lunsud asta katô turi na igimu katô mga manubù. ");
INSERT INTO bgs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Igkagi tô Áglangngagán, na mà din, “Ágpasábbadé tô langun manubù, asta sábbad dád tô kinagiyan dan. Igtigkané dan igimu kani. Na, dì madugé, agad ándin tô kakalyag dan, tô gó é imun dan. ");
INSERT INTO bgs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Purisu madun ki tun kandan, asta palibugán ta tô kinagiyan dan ébô kumarapung tô mga kinagiyan, asta dì dan pagpátté.” ");
INSERT INTO bgs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tô gó igpatalap katô Áglangngagán tô langun dan tun ta kaluwagan ka banuwa, asta igsódô dan igimu katô lunsud dan. ");
INSERT INTO bgs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Purisu igngadanan tô lunsud na Babel, su igpalibug katô Áglangngagán tô kinagiyan ka mga manubù dutun. Purisu igpatalap katô Áglangngagán tô langun dan tun ta kaluwagan ka banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ni gó tô mga ngadan katô rubbad i Sem. Tô iglabé dán tô duwa ámmé pángnga katô lunup, igdunggù ka sábbad gatus (100) tô idad i Sem, asta ipamasusu tô batà din mama na si Arfacsad. ");
INSERT INTO bgs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Pángnga ipamasusu sikandin, lima gatus (500) ámmé tô iglabé sippang ka inaté si Sem, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tô tállu pulù lima (35) dán tô idad i Arfacsad, ipamasusu tô batà din mama na si Sela. ");
INSERT INTO bgs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Pángnga ipamasusu sikandin, áppat gatus tállu (403) ámmé tô iglabé sippang ka inaté si Arfacsad, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tô tállu pulù (30) dán tô idad i Sela, ipamasusu tô batà din mama na si Eber. ");
INSERT INTO bgs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Pángnga ipamasusu sikandin, áppat gatus tállu (403) ámmé tô iglabé sippang ka inaté si Sela, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Tô tállu pulù áppat (34) dán tô idad i Eber, ipamasusu tô batà din mama na si Peleg. ");
INSERT INTO bgs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pángnga ipamasusu sikandin, áppat gatus tállu pulù (430) ámmé tô iglabé sippang ka inaté si Eber, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Tô tállu pulù (30) dán tô idad i Peleg, ipamasusu tô batà din mama na si Reu. ");
INSERT INTO bgs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pángnga ipamasusu sikandin, duwa gatus siyó (209) ámmé tô iglabé sippang ka inaté si Peleg, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Tô tállu pulù duwa (32) dán tô idad i Reu, ipamasusu tô batà din mama na si Serug. ");
INSERT INTO bgs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Pángnga ipamasusu sikandin, duwa gatus pittu (207) ámmé tô iglabé sippang ka inaté si Reu, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tô tállu pulù (30) dán tô idad i Serug, ipamasusu tô batà din mama na si Nahor. ");
INSERT INTO bgs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Pángnga ipamasusu sikandin, duwa gatus (200) ámmé tô iglabé sippang ka inaté si Serug, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tô duwa pulù siyó (29) dán tô idad i Nahor, ipamasusu tô batà din mama na si Tera. ");
INSERT INTO bgs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Pángnga ipamasusu sikandin, sábbad gatus sapulù siyó (119) ámmé tô iglabé sippang ka inaté si Nahor, asta duwán pa duma mga gabatà din na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tô kapittuwan (70) dán tô idad i Tera, ipamasusu tô mga gabatà din gamama na si Abram, si Nahor, asta si Haran. ");
INSERT INTO bgs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ni gó tô mga ngadan katô rubbad i Tera. Si Tera tô ámmà i Abram, si Nahor, asta si Haran. Si Haran tô ámmà i Lot. ");
INSERT INTO bgs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tô ándà pa kamaté si Tera, inaté tô batà din na si Haran tun ta banuwa na ipamasusuwan din na lunsud ka Ur tun ta Caldea. ");
INSERT INTO bgs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Igkalyagan i Abram si Sarai, asta igkalyagan i Nahor si Melca na batà bayi katô kataladi din na inaté na si Haran. Duwán batà bayi i Haran na si Isca. ");
INSERT INTO bgs_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ándà batà i Sarai, su dì sikandin ágbatà. ");
INSERT INTO bgs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Igpid i Tera tô batà din na si Abram, asta tô ikóddô kandin na si Sarai na sawa i Abram, asta tô apù din na si Lot na batà i Haran. Igpanó dan tikud tun ta lunsud ka Ur tun ta Caldea, asta igsadun dan tun ta Canaan. Asal tô igdunggù dan tun ta lunsud ka Haran, igóddô dan dutun. ");
INSERT INTO bgs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Inaté si Tera tô duwa gatus lima (205) tô idad din. ");
INSERT INTO bgs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Na, igkagi tô Áglangngagán ki Abram, na mà din, “Iwà ka tikud tun ta tanà na igóddóan nu. Tanani nu tô mga gakád nu asta tô pamilya katô ámmà nu. Sadun ka tun ta banuwa na tádduán ku áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Marapung tô mga rubbad na bággén ku áknikó, asta mému sikandan na dakál grupo. Madigár tô bággén ku áknikó, asta imun ku na mabantug tô ngadan nu. Madigár tô bággén ku tun ta duma mga manubù ukit áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Madigár tô bággén ku tun ta langun manubù na mággé ka madigár tun áknikó. Asal dadattan ku tô langun manubù na dumadat áknikó. Ukit áknikó, madigár tô bággén ku tun ta langun manubù nit banuwa.” ");
INSERT INTO bgs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Purisu igtuman i Abram tô igsugù katô Áglangngagán kandin, asta igpanó sikandin na igtákkássan katô bataánnán din na si Lot. Tô igpanó si Abram tikud tun ta lunsud ka Haran, kapittuwan lima (75) tô idad din. ");
INSERT INTO bgs_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Igpid i Abram tô sawa din na si Sarai, asta si Lot, asta igpid din tô langun ka kaduwánnan din asta langun állang na igkangé din tun ta lunsud ka Haran, asta igpanó dan na igsadun tun ta Canaan. Tô igdunggù dan dán tun ta Canaan, ");
INSERT INTO bgs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","igpanayun si Abram sippang tun ta kayu ulayan ka More tun ta lunsud ka Sikem. Tô igdunggù si Abram tun ta Sikem, taganà duwán dán mga Canaanhon na igóddô dutun. ");
INSERT INTO bgs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Igpakita tô Áglangngagán ki Abram, asta igkagi sikandin, na mà din, “Ni gó tô banuwa na bággén ku tun ta rubbad nu.” Purisu igimu i Abram tô ággóbbówanan ka mannanap na bággén tun ta Áglangngagán na igpakita kandin. ");
INSERT INTO bgs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Pángnga igpakita tô Áglangngagán kandin, igalin si Abram tun ta pabunganán dadan tun ta silatan ka lunsud ka Betel. Tulda tô igóddóan din tun ta tángngaan ka lunsud ka Betel asta Ai. Dadan tun ta ágsalláppan tô lunsud ka Betel, asta dadan tun ta silatan tô lunsud ka Ai. Igimu din tô ággóbbówanan ka mannanap, asta igpangadap sikandin katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Na, inalayun igalin-alin si Abram sippang tun ta Negeb. ");
INSERT INTO bgs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Na, duwán ballus tun ta Canaan. Purisu igsadun si Abram tun ta Ehipto ébô móddô dan róggun, su dakál tô ballus. ");
INSERT INTO bgs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tô madani dan dán tun ta Ehipto, igkagi si Abram katô sawa din na si Sarai, na mà din, “Madigár gó é bónnóng nu! ");
INSERT INTO bgs_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Atin ka kumita tô mga taga Ehipto áknikó, manámdám dan na sikuna tô sawa ku. Purisu matayanna ikandan ébô agón ka. ");
INSERT INTO bgs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Purisu kagiyi nu sikandan na tábbé ku sikuna ébô diya matayan ikandan, asta madigár tô imun dan kanak tingód áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Na, tô igdunggù dan dán tun ta Ehipto, igkita tô mga taga Ehipto na madigár é bónnóng katô sawa i Abram. ");
INSERT INTO bgs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tô igkita tô mga opisyales ka harì kandin, igulitan dan tô harì na madigár é bónnóng katô bayi. Purisu igpóddô katô harì si Sarai tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Madigár tô igbággé katô harì ki Abram tingód ki Sarai. Igbággayan sikandin ka marapung mga karnero, mga kambing, mga baka, mga asno, mga állang, asta mga kamelyo. ");
INSERT INTO bgs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Asal su igpóddô katô harì si Sarai tun ta balé din, duwán madat bógók na igpapid katô Áglangngagán tun ta harì asta langun duma manubù na góddô tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Purisu igpatawar katô harì si Abram, asta igkagi sikandin, na mà din, “Manan ka madat tô igimu nu kanak? Manan ka ándà ka ulit kanak na sawa nu sikandin? ");
INSERT INTO bgs_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Manan ka igkagi ka na tábbé nu sikandin? Manan ka ignunug ka na imun ku sikandin na sawa ku? Na, ni dán ni sawa nu. Pid nu sikandin, asta panó kód!” ");
INSERT INTO bgs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Na, igsugù katô harì tô mga sundalo din, asta igpéwà dan si Abram, tô sawa din, asta tô langun katô kaduwánnan din tikud tun ta banuwa dan. ");
INSERT INTO bgs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Na, igpanó si Abram tikud tun ta Ehipto asta iglónód sikandin tun ta Negeb na sakup ka Canaan, asta igtákkás tô sawa din, asta igpid din tô langun katô kaduwánnan din. Igtákkás si Lot kandin. ");
INSERT INTO bgs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Tuu ágkaduwánnan si Abram, su duwán mga karnero din, mga kambing, mga baka, mga bulawan, asta mga mapputì bulawan. ");
INSERT INTO bgs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Tô igpanó si Abram tikud tun ta Negeb, igalin-alin sikandin sippang tun ta Betel. Igdunggù sikandin tun ta taganà góddóan din tun ta tángngaan ka Betel asta Ai. ");
INSERT INTO bgs_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tô gó tô taganà lugar na igimuwan din ka ággóbbówanan ka mannanap. Igpangadap puman sikandin katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na, igtákkás si Lot ki Abram, asta marapung pagsik tô pamilya din, mga állang, mga karnero, mga kambing, asta mga baka. ");
INSERT INTO bgs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Purisu atin ka pasábbadé dan, ánnà nángngà tô tanà na pasabsaban katô langun mannanap dan, su tuu marapung tô mga mannanap dan. ");
INSERT INTO bgs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Purisu igpamatayé tô mga taradóppón i Abram asta tô mga taradóppón i Lot. (Duwán mga Canaanhon asta Perisihanon na igóddô dutun.) ");
INSERT INTO bgs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Purisu igtóngkô si Abram ki Lot, na mà din, “Na, dì mému pamatayé tô mga taradóppón ta, su bataánnán ku sikuna. ");
INSERT INTO bgs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Purisu madigár ka passaé ki. Na, sállág nu tô kaluwagan kani tanà. Atin ka salinán nu tô tanà dadan tun ta ibang, malinna tun ta tanà dadan tun ta kawanan. Atin ka salinán nu tô tanà dadan tun ta kawanan, malinna tun ta tanà dadan tun ta ibang.” ");
INSERT INTO bgs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Purisu igsállág si Lot, asta igkita din na madigár tô kaluwagan katô tanà madani tun ta Wayig ka Jordan sippang tun ta lunsud ka Soar, su nángngà tô wayig para katô tanà iring katô tun ta kayun na igpamula katô Áglangngagán sayyan, asta iring katô tun ta Ehipto. (Inému ni tô ándà pa dadatti katô Áglangngagán tô mga lunsud ka Sodoma asta Gomora madani tun ta Wayig ka Jordan.) ");
INSERT INTO bgs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Purisu igsalin i Lot tô kaluwagan ka tanà madani tun ta Wayig ka Jordan, asta igalin sikandin dadan tun ta silatan. Purisu igpassaé dan. ");
INSERT INTO bgs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Igóddô pa si Abram tun ta Canaan, asal igalin si Lot tun ta mga lunsud madani tun ta Wayig ka Jordan, asta igóddô sikandin madani tun ta lunsud ka Sodoma. ");
INSERT INTO bgs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tuu madat tô áglumun katô mga taga Sodoma. Tuu dan masalà-salà tun ta saruwan katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tô igpanó dán si Lot, igkagi tô Áglangngagán ki Abram, na mà din, “Sállág ka tun ta kaluwagan kani tanà agad ánda tô kasállággan nu. ");
INSERT INTO bgs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tô kaluwagan kani tanà na kitanán nu, tô gó é bággén ku áknikó asta tun ta mga rubbad nu ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Imun ku na marapung tô mga rubbad nu sippang ka dì dan méyap, iring na mga barukbuk ka tanà. ");
INSERT INTO bgs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Purisu panó-panó ka tun ta kaluwagan kani banuwa, su bággén ku ni langun áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Purisu igalin si Abram, asta igóddô sikandin madani tun ta kayun ka mga ulayan i Mamre tun ta Hebron, asta igimu sikandin ka ággóbbówanan ka mannanap ébô mangadap sikandin katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Na, si Amrafel tô harì tun ta Sinar, si Arioc tô harì tun ta Elasar, si Cadorlahomor tô harì tun ta Elam, asta si Tadal tô harì tun ta Goyim. Róggun igharì dan, igpasábbadé dan áppat asta igsulung dan tô lima harì na si Bara na harì tun ta Sodoma, si Birsa na harì tun ta Gomora, si Sinab na harì tun ta Adma, si Semeber na harì tun ta Seboim, asta tô harì tun ta Bela na ássa ngadan ka Soar. ");
INSERT INTO bgs_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Igpasábbadé tô lima harì, asta iglimud dan tô langun sundalo dan madani tun ta kapattadan ka Sidim na inému dán áknganni na Ranó Ka Asin. ");
INSERT INTO bgs_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Taganà isakup tô lima harì tun ki Cadorlahomor ka sapulù duwa (12) ámmé. Asal tô ikasapulù tállu ámmé, igatu dan kandin. ");
INSERT INTO bgs_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tô ikasapulù áppat ámmé, igsulung si Cadorlahomor asta tô duma mga harì na igpasakup kandin. Igtalu dan tô langun Repaihanon tun ta Astarot-Carnaim. Igtalu dan tô mga Susihanon tun ta Ham, asta tô mga Emihanon tun ta kapattadan ka Kiriataim. ");
INSERT INTO bgs_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Igtalu dan tô langun Horihanon tun ta pabunganán na igóddóan dan tun ta Seir, asta iglupug dan sippang tun ta lunsud ka Elparan madani tun ta disyerto. ");
INSERT INTO bgs_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Iglónód dan tun ta lunsud ka Cades (Eumispat tô ássa ngadan din). Igtalu dan tô langun manubù na igóddô tun ta banuwa ka mga Amalekanhon, asta igtalu dan tô mga Amorihanon na igóddô tun ta Hasason Tamar. ");
INSERT INTO bgs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na, igpaglimud katô mga harì ka Sodoma, Gomora, Adma, Seboim, asta Belak tô mga sundalo dan. Igsadun dan tun ta kapattadan ka Sidim ébô matu dan ");
INSERT INTO bgs_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","katô mga sundalo katô áppat harì, na si Cadorlahomor na harì tun ta Elam, si Tadal na harì tun ta Goyim, si Amrafel na harì tun ta Sinar, asta si Arioc na harì tun ta Elasar. Lima tô mga harì na igsulung katô áppat mga harì. ");
INSERT INTO bgs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Tun ta Sidim, duwán marapung mga magdakál sábbáng na duwán ispalto na tuu ágdákkát. Tô italu tô harì ka Sodoma asta harì ka Gomora, igpalaguy tô mga sundalo dan, asta duwán tun kandan na idákkát tun ta ispalto su idabù dan tun ta mga sábbáng, asta igpalaguy tô duma mga sundalo tun ta pabunganán. ");
INSERT INTO bgs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Na, igkangé katô áppat harì tô langun ka kaduwánnan asta ágkakan tun ta mga lunsud ka Sodoma asta Gomora, asta igpanó dan. ");
INSERT INTO bgs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Su igóddô si Lot na bataánnán i Abram tun ta Sodoma, igámmát dan pagsik sikandin, igkangé dan tô kaduwánnan din, asta igpanó dan. ");
INSERT INTO bgs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Asal duwán sábbad manubù na ikaluwà asta igulit ki Abram na Hebreo. Tô timpo tô, igóddô si Abram madani tun ta kayun ka mga ulayan i Mamre na Amorihanon. Inalayun ágpatabangé si Abram, si Mamre, asta tô mga kataladi i Mamre na si Escol asta si Aner. ");
INSERT INTO bgs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tô ikasóddór si Abram na inammát tô bataánnán din, iglimud din tô langun állang din na katig ággamit ka laniban, na tállu gatus sapulù walu (318) tô langun dan, asta igagtà dan tô áppat harì sippang tun ta lunsud ka Dan. ");
INSERT INTO bgs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Igpagtángngà-tángngà i Abram tô mga állang din. Tô dukilám dán, igsulung dan, asta ikapanalu dan. Igagtà i Abram sikandan sippang tun ta lunsud ka Hoba dadan tun ta Damasco. ");
INSERT INTO bgs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ikangé i Abram tô langun ka kaduwánnan na igagó dan. Igpaluwà din pagsik tô bataánnán din na si Lot, asta igulì din tun ki Lot tô langun ka kaduwánnan na igagó tikud tun kandin. Igpaluwà din tô langun gabayi asta tô duma mga manubù na inammát. ");
INSERT INTO bgs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Tô igulì si Abram tikud tun ta kapanalu din ki Cadorlahomor asta duma mga harì, igsumar kandin tô harì ka Sodoma tun ta Kapattadan ka Sabec (igngadanan Kapattadan ka Harì). ");
INSERT INTO bgs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Igsumar ki Abram tô harì ka Salem na si Melkisedec. Sikandin tô pangulu na parì ka mga manubù na ágpamaké tun ta Manama na Mallayat ka Langun. Igpid din tô pan asta tô bino tun ki Abram. ");
INSERT INTO bgs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Igdasal sikandin ébô madigár tô bággén ka Manama ki Abram. Igkagi sikandin, na mà din, “Madigár tô bággén áknikó tikud tun ta Manama na Mallayat ka Langun na igimu ka langit asta tô tibuk banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Durungán tô Manama na Mallayat ka Langun, su igtabangan ka ikandin ébô makapanalu ka katô mga usig nu!” Na, igbággé i Abram kandin tô ikasapulù katô langun na ikangé din tikud tun ta áppat harì na igtalu din. ");
INSERT INTO bgs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Igkagi tô harì ka Sodoma ki Abram, na mà din, “Áknikó dán tô kadakállan katô kaduwánnan ku na ikangé nu tikud tun ta áppat harì na igagó tikud áknami. Mga sakup ku dád tô ulián nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Asal igkagi si Abram katô harì ka Sodoma, na mà din, “Duwán igtandô ku katô Áglangngagán na Manama na Mallayat ka Langun na igimu ka langit asta tibuk banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Igtandô a kandin na ándà palang kaduwánnan nu na kangén ku, agad sábbad sinulid, agad sábbad listun ka sandalyas. Ulián ku tô langun tun áknikó, su dì mému kumagi ka na miduwánnanna ukit áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ándà palang kangén ku, asal tô dád igkan katô mga állang ku tô mému bullasan nu. Asal mému ka duwán bággén nu katô mga manubù na igtabang kanak, na si Aner, si Escol, asta si Mamre.” ");
INSERT INTO bgs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Na, duwán álló na igpakita tô Áglangngagán ki Abram, asta igkagi sikandin, na mà din, “Abram, yaka ágkamáddangan. Sakán tô kumalasag áknikó ébô dì ka kadattan. Tuu dakál tô ágpulusán na bággén ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Asal igkagi si Abram, na mà din, “Áglangngagán na Manama na ágpangulu katô langun, ándà palang batà ku. Purisu ándà pulusán katô bággén nu kanak. Atin ka matéya, matigatun i Elieser na taga Damasco tô kaduwánnan ku. ");
INSERT INTO bgs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Su ándà batà na igbággé nu kanak, ka matéyad, állang ku dád tô makatigatun katô kaduwánnan ku.” ");
INSERT INTO bgs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Na, igkagi puman tô Áglangngagán kandin, na mà din, “Ánnà si Elieser tô makatigatun katô kaduwánnan nu, su áknikó batà mama tô makatigatun katô kaduwánnan nu.” ");
INSERT INTO bgs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Na, igpid ka Manama si Abram tun ta luwà ka tulda, asta igkagi sikandin, na mà din, “Langngag ka tun ta kawang-awangan. Iyap nu tô mga karani ka makéyap ka. Iring kanan mga karani tô karapungan ka mga rubbad nu.” ");
INSERT INTO bgs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Igpamaké si Abram katô Áglangngagán, asta igtanggap din si Abram na nángngà tun ta saruwan din. ");
INSERT INTO bgs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Igkagi tô Manama, na mà din, “Sakán tô Áglangngagán na igpid áknikó tikud tun ta Ur ka Caldea ébô bággén ku áknikó ni tanà ni asta matigatun nu.” ");
INSERT INTO bgs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Asal iginsà si Abram, na mà din, “Áglangngagán na Manama na ágpangulu katô langun, ándin tô pató na pakitanán nu kanak ébô kasóddóran ku na makatigatunna kanan?” ");
INSERT INTO bgs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Igkagi tô Manama, na mà din, “Pid nu dini kanak tô baka, kambing, asta karnero. Kailangan tállu ámmé tô idad dan. Pid nu dini kanak tô sábbad manatad asta salapati.” ");
INSERT INTO bgs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Purisu igpid i Abram tô langun tun ta saruwan ka Manama, asta igmatayan din. Igtángngà din tô lawa, igsánnar din na tagduwa-duwa, asta duwán állát tun ta tángngaan. Asal ándà din tángngai tô duwa manuk. ");
INSERT INTO bgs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Duwán dakál mga manuk ka kabánnássan na igapun tun ta igtángngà lawa katô mga mannanap, asal igbugó dan i Abram. ");
INSERT INTO bgs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tô igsalláp dán tô álló, tuu igpatudug ka Manama sikandin, asta tuu imáddangan sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Igkagi tô Áglangngagán kandin, na mà din, “Pasóddórán ku áknikó na móddô gó tô mga rubbad nu tun ta banuwa ka duma mga manubù. Kahirapan dan asta állangán dan katô duma mga manubù sippang ka áppat gatus (400) ámmé. ");
INSERT INTO bgs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Asal supakan ku tô mga manubù na mállang kandan, asta makaluwà dan na dakál tô piddán dan. ");
INSERT INTO bgs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Asal sikuna, tuu ka tumugál asta maté ka na duwán kasunayan nu sippang na lábbángngán ka. ");
INSERT INTO bgs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Móddô tô mga rubbad nu tun ta duma banuwa sippang ka lumabé tô ikappat na mga karubbadan patalundugé, asta makalónód dan kannun, su inalayun dugangan katô mga Amorihanon tô salà na áglumun dan sippang ka supakan ku sikandan.” ");
INSERT INTO bgs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tô igmangittáng dán, tigkô igkita i Abram tô baga na igábbál asta tô sulù na igrágrág. Igukit tun ta tángngaan katô lawa ka mga mannanap na igtángngà din. ");
INSERT INTO bgs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tô oras tô, igimu tô Áglangngagán ka kasabotan tun ki Abram, na mà din, “Bággén ku tun ta mga rubbad nu tô kaluwagan kani banuwa. Tikud tun ta Wayig ka Ehipto sippang tun ta dakál Wayig ka Eufrates, tô gó tô tanà na bággén ku kandan. ");
INSERT INTO bgs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Bággén ku kandan tô tanà na igóddóan katô mga grupo ka manubù na igngadanan Kenihanon, Kenisihanon, Cadmonihanon, ");
INSERT INTO bgs_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetihanon, Perisihanon, Repaihanon, ");
INSERT INTO bgs_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorihanon, Canaanhon, Girgasihanon, asta Jebusihanon.” ");
INSERT INTO bgs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Na, ándà palang batà i Sarai asta i Abram. Asal duwán állang bayi i Sarai na igngadanan ki Agar na taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Purisu igkagi si Sarai ki Abram, na mà din, “Ándà batà na igbággé katô Áglangngagán kanak. Purisu madigár ka lumayuk ka katô állang ku ébô duwán batà ku ukit kandin.” Ignunug si Abram katô igkagi i Sarai. ");
INSERT INTO bgs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Purisu igbággé i Sarai tô állang din ki Abram ébô imun din na sawa din. (Inému ni pángnga igóddô si Abram tun ta Canaan ka sapulù ámmé.) ");
INSERT INTO bgs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Igpalayuké dan asta igmabáddás si Agar. Tô ikasóddór dán si Agar na igmabáddás sikandin, ándà din respetowi si Sarai, asta igbuyas din. ");
INSERT INTO bgs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Purisu igkagi si Sarai ki Abram, na mà din, “Sikuna tô igtikudan ka salà na inému kanak! Sikuna tô igbággayan ku ki Agar, asta igmabáddás sikandin. Purisu ándà a respetowi ikandin. Isóddóran katô Áglangngagán na duwán salà nu kanak!” ");
INSERT INTO bgs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Igtaba si Abram, na mà din, “Na, áknikó állang sikandin. Agad ándin tô kakalyag nu na lumun kandin, mému kanak.” Na, tuu igirrayatan i Sarai si Agar. Purisu igpalaguy si Agar. ");
INSERT INTO bgs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Na, tô panaligan na Áglangngagán igpakita ki Agar tun ta disyerto madani tun ta sánnáp tun ta dalan na pasadun tun ta lunsud ka Sur. ");
INSERT INTO bgs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Igkagi tô Áglangngagán, na mà din, “Agar na állang i Sarai, ánda é igtikudan nu, asta ánda é sadunan nu?” Igtaba si Agar, na mà din, “Igpalaguyyad tikud tun ta amo ku na si Sarai.” ");
INSERT INTO bgs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Igkagi tô panaligan na Áglangngagán, na mà din, “Ulì ka tun kandin, asta tuman nu tô mga sugù din.” ");
INSERT INTO bgs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Igkagi pagsik tô panaligan na Áglangngagán, na mà din, “Imun ku na tuu marapung tô rubbad nu sippang ka dì dan méyap. ");
INSERT INTO bgs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Duwán batà mama na pamasusun nu, asta ngadanan nu sikandin ki Ismael, su igpaminág katô Áglangngagán tô ranginán nu. ");
INSERT INTO bgs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Imun tô batà nu na iring ka asno na méla, su ándà palang bánnalán din. Musig sikandin ka langun manubù, asta musig dan kandin. Dì sikandin móddô duma katô mga kataladi din.” ");
INSERT INTO bgs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Igkagi si Agar, na mà din, “Igkita kud gó tô Áglangngagán na igsállág kanak, asal ándà a kannê kamaté.” Igngadanan i Agar tô Manama na igpakita kandin na mà din, “Manama na ágsállág.” ");
INSERT INTO bgs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Purisu áknganni, tô sánnáp na igngadanan Beerla-hai-roi tun ta tángngaan ka lunsud ka Cades asta Bered. ");
INSERT INTO bgs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tô ipamasusu dán tô batà mama i Abram tikud ki Agar, igngadanan i Abram sikandin ki Ismael. ");
INSERT INTO bgs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Kawaluwan ánnám (86) tô idad i Abram tô ipamasusu si Ismael. ");
INSERT INTO bgs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Na, tô kasiyawan siyó (99) dán tô idad i Abram, igpakita tô Áglangngagán kandin, asta igkagi sikandin, na mà din, “Sakán tô Tuu Matulus Manama. Tuman nu tô kakalyag ku. Kailangan ándà salà nu tun ta saruwan ku. ");
INSERT INTO bgs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Imun ku tô kasabotan ku tun áknikó. Imun ku na tuu marapung tô mga rubbad nu.” ");
INSERT INTO bgs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Iglingkóód si Abram sippang ka ikadunggù tô ulu din tun ta tanà, asta igkagi tô Manama, na mà din, ");
INSERT INTO bgs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ni gó tô kasabotan ku tun áknikó. Imun ku sikuna na kamónaan ka marapung mga grupo. ");
INSERT INTO bgs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tikud áknganni, dì kad ngadanan ki Abram, asal ngadanan kad ki Abraham su imun ku sikuna na kamónaan ka marapung mga grupo. ");
INSERT INTO bgs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Imun ku na marapung tô mga rubbad nu, asta imun ku sikandan na marapung mga grupo, asta duwán tun kandan na imun na mga harì. ");
INSERT INTO bgs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Imun ku tô kasabotan tun áknikó asta tun ta mga rubbad nu ka ándà ágtamanán. Sakán tô Manama nu asta Manama katô mga rubbad nu. ");
INSERT INTO bgs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Tô kaluwagan ka banuwa ka Canaan na igóddóan nu, tô gó é bággén ku áknikó asta tun ta mga rubbad nu ébô matigatun yu ka ándà ágtamanán. Sakán tô Manama dan.” ");
INSERT INTO bgs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Igkagi tô Manama ki Abraham, na mà din, “Na, sikuna, duwán kailangan lumun nu asta langun rubbad nu ka ándà ágtamanán tingód katô kasabotan ku tun ákniyu. ");
INSERT INTO bgs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ni gó tô kasabotan ku na kailangan tumanán nu, agad sikuna asta tô tagsábbad-sábbad mga rubbad nu. Kailangan tupuwan tô langun gamama dini áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kailangan tupuwan kó, su tô gó é pató tingód katô kasabotan ku tun áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Tô mga rubbad nu, kailangan tupuwan tô langun gabatà dan gamama ka ikawalu álló tikud tun ta kapamasusu, agad tô tagsábbad-sábbad mga állang yu gamama, agad sadan é pamasusun tun ákniyu, agad sadan é bállin tun ta duma manubù. ");
INSERT INTO bgs_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kailangan tupuwan tô langun gamama, su ukit katô pató tun ta lawa yu, kasóddóran yu na ándà ágtamanán katô kasabotan ku tun ákniyu. ");
INSERT INTO bgs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Atin ka dì tupuwan tô mama, dì mému dumuma ákniyu, su dì sikandin mánnal katô kasabotan ku.” ");
INSERT INTO bgs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Igkagi tô Manama ki Abraham, na mà din, “Tikud áknganni, dì dán mému si Sarai tô ngadan katô sawa nu. Kailangan ngadanan nu sikandin ki Sara. ");
INSERT INTO bgs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Madigár tô bággén ku kandin, asta bággén ku áknikó tô batà mama na pamasusun din. Madigár tô bággén ku tun ta sawa nu, asta imun ku sikandin na kamónaan ka marapung mga grupo. Duwán gó mga rubbad din na imun harì.” ");
INSERT INTO bgs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iglingkóód si Abraham sippang ka ikadunggù tô ulu din tun ta tanà. Igngisi sikandin, su igpanámdám sikandin, na mà din, “Duwán kannê batà ku na pamasusun, agad tô idad ku dumunggù tun ta sábbad gatus (100)! Mamasusu kannê si Sara ka batà, agad tô idad din dumunggù tun ta kasiyawan (90)!” ");
INSERT INTO bgs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Igkagi si Abraham katô Manama, na mà din, “Kakalyag ku na si Ismael tô bággayan nu ka madigár!” ");
INSERT INTO bgs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Asal igkagi tô Manama, na mà din, “Tô sawa nu na si Sara mamasusu ka batà nu mama, asta ngadanan nu tô batà ki Isaac. Sikandin asta tô mga rubbad din tô katumanan katô kasabotan ku na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Igpaminág ku tô igpamuyù nu para ki Ismael. Purisu madigár tô bággén ku kandin. Bággén ku kandin tô marapung mga gabatà asta mga rubbad din. Imun ku sikandin na kamónaan ka sapulù duwa (12) ágpangulun, asta imun ku na dakál grupo tô mga rubbad din. ");
INSERT INTO bgs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Asal tô batà nu na si Isaac tô katumanan katô kasabotan ku tun áknikó. Pamasusun sikandin i Sara kani ámmé na dumunggù.” ");
INSERT INTO bgs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pángnga igpatóngkóé dan, igpanó tô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Na, tô álló tô, igbánnal si Abraham ka Manama, asta igtupuwan din tô batà din na si Ismael, asta tô langun ka duma mga sakup din gamama, agad tô mga állang din, tô mga ipamasusu tun kandin, asta tô igbálli din tun ta duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Kasiyawan siyó (99) tô idad i Abraham tô igtupuwan sikandin, ");
INSERT INTO bgs_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","asta sapulù tállu (13) tô idad katô batà din na si Ismael. ");
INSERT INTO bgs_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tô álló tô, igtupuwan si Abraham asta si Ismael, ");
INSERT INTO bgs_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","asta tô langun gamama na sakup i Abraham. ");
INSERT INTO bgs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Róggun igóddô si Abraham tun ta kayun ka mga ulayan i Mamre, igpakita tô Áglangngagán kandin. Tô ménit tô álló, igunsad si Abraham tun ta sállat ka tulda na igóddóan din. ");
INSERT INTO bgs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Igsállág sikandin, asta igkita din tô tállu manubù na igtindág tun ta luwà. Tô igkita din sikandan, igsékót sikandin igsumar kandan. Iglingkóód sikandin sippang ka ikadunggù tô ulu din tun ta tanà ébô tumanggap kandan. ");
INSERT INTO bgs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Igkagi sikandin, na mà din, “Sir, ádding kó dini kanak. Yakó áglabé. ");
INSERT INTO bgs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Piddan ku sikiyu ka wayig ébô muras kó katô paa yu, asta makapaginawa kó kannun ta siráb kani kayu. ");
INSERT INTO bgs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Pakannán ku sikiyu ébô kumabákkár kó ka dì kó pa manayun. Idayawanna su igdunggù kó, asta kakalyag ku na tumabangnga ákniyu.” Igkagi sikandan, na mà dan, “Mému áknami.” ");
INSERT INTO bgs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Igsékót si Abraham igahu tun ta tulda, asta igkagiyan din si Sara, na mà din, “Sékót ka! Angé nu tô sábbad sako ka tuu madigár harina, asta imu nu tô pan na pakannán kandan.” ");
INSERT INTO bgs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Igpalaguy si Abraham tun ta mga mannanap din, asta igsalin din tô tuu madigár nati ka baka. Igbággé din tun ta sábbad állang din ébô iyón din asta sékót lággaán. ");
INSERT INTO bgs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tô igtaganà dan tô langun, igpid i Abraham tô gatas na malassám, gatas na mammis, asta ákkud na igtug, asta igbuwat din tun kandan. Róggun igkan dan, igtindág sikandin madani tun ta siráb katô kayu. ");
INSERT INTO bgs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Iginsà dan kandin, na mà dan, “Ánda tô sawa nu na si Sara?” Igtaba si Abraham, na mà din, “Tun dalám katô tulda.” ");
INSERT INTO bgs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Igkagi tô Áglangngagán, na mà din, “Tô ámmé na dumunggù, lumónódda dini ákniyu, asta duwán batà mama na pamasusun katô sawa nu na si Sara.” Na, si Sara madani tun ta sállat tun ta bókkóg din, asta igpaminág sikandin katô igkagi dan. ");
INSERT INTO bgs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Tuu dán tugál si Abraham asta si Sara. Ándà bayi na mamasusu iring katô idad i Sara. ");
INSERT INTO bgs_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Purisu igngisi si Sara katô kandin sarili, asta igpanámdám sikandin, na mà din, “Tuuwad tugál, asta tuu dán tugál tô duma ku. Pamánnun ka kadunggù katô dayó dini kanak?” ");
INSERT INTO bgs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Na, iginsà tô Áglangngagán ki Abraham, na mà din, “Manan ka igngisi si Sara? Manan ka igkagi sikandin na pamánnun é kapamasusu din ka batà su tuu dán tugál sikandin? ");
INSERT INTO bgs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ándà palang na dì mému katô Áglangngagán! Tô ámmé na dumunggù, duwán batà mama na pamasusun i Sara.” ");
INSERT INTO bgs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Imáddangan si Sara. Purisu igbulaló sikandin asta igkagi, na mà din, “Ándà a ngisi.” Asal igkagi tô Áglangngagán, na mà din, “Bulaló yan. Bánnal na igngisi ka.” ");
INSERT INTO bgs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na, igpanó tô tállu manubù, asta igsadun dan tun ta pabungan ébô sumállág dan katô lunsud ka Sodoma. Igtákkás si Abraham kandan ébô tumáddù kandan ka dalan. ");
INSERT INTO bgs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Igpanámdám tô Áglangngagán, na mà din, “Dì ku állássán ki Abraham tô masig dán na lumun ku, ");
INSERT INTO bgs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","su mému na dakál grupo tô mga rubbad din, asta madigár tô bággén ku tun ta langun manubù ukit kandin. ");
INSERT INTO bgs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Igsalin ku sikandin ébô tuminurù sikandin katô mga gabatà din asta mga rubbad din na kailangan mánnal dan kanak asta lumun dan tô nángngà tun ta saruwan ku, ébô tumanán ku tô igtandô ku kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Na, igkagi tô Áglangngagán ki Abraham, na mà din, “Marapung tô igulit kanak na madat tô áglumun katô mga taga Sodoma asta taga Gomora. Tuu kun dakál tô salà dan. ");
INSERT INTO bgs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Purisu madunna ébô kasóddóran ku ka bánnal ó ánnà bánnal tô igdinág ku.” ");
INSERT INTO bgs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Na, igpanó tô duwa manubù, asta igpanayun dan tun ta Sodoma, asal igduma pa tô Áglangngagán tun ki Abraham. ");
INSERT INTO bgs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Igpadani si Abraham tun ta Áglangngagán, asta iginsà sikandin, na mà din, “Atin ka matayan nu tô madat mga manubù, matayan nu pagsik tô mga matalláng? ");
INSERT INTO bgs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Atin ka duwán kaliman (50) mga matalláng tun ta lunsud, dadattan nu tô langun tun ta lunsud? Duwán kédu nu katô langun tingód katô kaliman (50) mga matalláng? ");
INSERT INTO bgs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Panámdám ku na dì nu matayan tô mga matalláng apil katô madat mga manubù! Dì mému! Atin ka supakan nu tô madat mga manubù, dì nu apilán tô mga matalláng, su sikuna tô ágruud katô langun manubù, asta kailangan nángngà tô karuud nu.” ");
INSERT INTO bgs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Igtaba tô Áglangngagán, na mà din, “Atin ka kitanán ku tô kaliman (50) mga matalláng tun ta lunsud, dì ku dadattan tô lunsud.” ");
INSERT INTO bgs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Igkagi puman si Abraham, na mà din, “Sir, agad tuu ka mallayat ka tandingán kanak, asal pallayat nu tô ginawa nu kanak ka minsà a puman áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Atin ka duwán dád kappatan lima (45) mga matalláng, dadattan nu tô langun tun ta lunsud su ikulangan ka lima?” Igtaba tô Áglangngagán, na mà din, “Atin ka kitanán ku tô kappatan lima (45) mga matalláng, dì ku dadattan tô lunsud.” ");
INSERT INTO bgs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Igkagi puman si Abraham, na mà din, “Atin ka kappatan (40) dád tô kitanán nu?” Igtaba tô Áglangngagán, na mà din, “Atin ka duwán kappatan (40), dì ku dadattan.” ");
INSERT INTO bgs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Igkagi si Abraham, na mà din, “Sir, yaka ágkasókó kanak ka minsà a puman áknikó. Atin ka tállu pulù (30) dád tô kitanán nu?” Igtaba tô Áglangngagán, na mà din, “Atin ka tállu pulù (30) tô kitanán ku, dì ku dadattan.” ");
INSERT INTO bgs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Igkagi si Abraham, na mà din, “Sir, pallayat nu tô ginawa nu kanak ka minsà a puman áknikó. Atin ka duwa pulù (20) dád tô kitanán nu?” Igtaba tô Áglangngagán, na mà din, “Atin ka duwa pulù (20) tô kitanán ku, dì ku dadattan tô lunsud.” ");
INSERT INTO bgs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Igkagi si Abraham, na mà din, “Sir, yaka ágkasókó kanak, su ni gó é ágtamanán ka insà ku. Atin ka sapulù (10) dád tô kitanán nu?” Igtaba tô Áglangngagán, na mà din, “Atin ka duwán sapulù (10), dì ku dadattan.” ");
INSERT INTO bgs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Na, pángnga igpatóngkóé tô Áglangngagán asta si Abraham, igpanó tô Áglangngagán, asta igulì si Abraham. ");
INSERT INTO bgs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tô mapun dán, igdunggù tô duwa panaligan tun ta Sodoma. Si Lot igunsad tun ta plasa madani tun ta sállat katô lunsud. Tô igkita sikandin kandan, igtindág sikandin asta igsumar kandan. Iglingkóód sikandin sippang ka ikadunggù tô ulu din tun ta tanà, ");
INSERT INTO bgs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","asta igkagi sikandin, na mà din, “Sir, ádding kó tun ta balé ku. Urasi yu tô paa yu, asta dággà kód, su simag ka sállám mému manayun kó tun ta sadunan yu.” Asal igkagi sikandan, na mà dan, “Dì ké mádding tun ta balé nu. Dumággà kéd dini ta plasa.” ");
INSERT INTO bgs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Asal igpanayun ginggat si Lot sippang ka igtákkás dan kandin tun ta balé din. Igpému i Lot tô pan asta tô duma mga madigár ágkakan, asta igkan dan. ");
INSERT INTO bgs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tô ándà dan pa dággà tô dukilám, iglibutan tô balé katô langun gamama na taga Sodoma. Ilimud tô langun dan, agad mga mallaki asta mga tugál. ");
INSERT INTO bgs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Igtawar dan ki Lot, na mà dan, “Ánda tô duwa gamama na igdunggù géna dini áknikó? Paluwà nu sikandan ébô lumayuk ké kandan.” ");
INSERT INTO bgs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Igluwà si Lot tun ta balé din, asta igsagpángngan din tô sállat. ");
INSERT INTO bgs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Igkagi sikandin, na mà din, “Mga rarak ku, yakó áglumu katô madat. ");
INSERT INTO bgs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Asal duwán duwa gabatà ku daraga na ándà pa palang layuki. Paluwaán ku sikandan, asta mému lumun yu kandan tô agad ándin kakalyag yu. Asal yakó ágsamuk kani duwa gamama, su igpadággà ku sikandan dini kanak, asta kailangan dóppónan ku sikandan.” ");
INSERT INTO bgs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Asal igkagi sikandan, na mà dan, “Yaka gilabut áknami! Ánnà ka taga kannun. Purisu dì mému milabut ka katô lumun dé! Atin ka panámdám nu na madat tô lumun dé kandan, tuu pa madat tô lumun dé áknikó.” Igsullóy dan si Lot, asta igpadani dan tun ta sagpáng ka sállat ébô siraán dan. ");
INSERT INTO bgs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Asal igpókéan katô duwa panaligan tô sállat, igguyud dan si Lot tun dalám katô balé, asta igsagpángngan dan tô sállat. ");
INSERT INTO bgs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Na, igimu dan na bólóg tô langun gamama madani tun ta sállat ébô dì dan kumita katô sállat. ");
INSERT INTO bgs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Igkagi tô duwa panaligan ki Lot, na mà dan, “Atin ka duwán mga kadumaan nu dini, mga gabatà nu, ugang nu, ó duma mga sakup nu na igóddô dini ta lunsud, pid nu sikandan, asta panó kód, ");
INSERT INTO bgs_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","su dadattan déd ni lunsud ni. Idinág katô Áglangngagán na tuu madat tô áglumun dan. Purisu igpapid ké ikandin ébô dadattan dé tô langun.” ");
INSERT INTO bgs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Purisu igsékót si Lot igsadun tun ta duwa banà katô gabatà din gabayi, asta igkagi sikandin, na mà din, “Sékót kód panó tikud kannun, su dadattan dán katô Áglangngagán ni lunsud ni.” Asal kéman dan ka ágragórù dád sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tô sállám dán, igpapalaguy katô mga panaligan si Lot, na mà dan, “Sékót kad! Pid nu tô sawa nu asta tô duwa gabatà nu gabayi, asta palaguy kód ébô dì kó kasabban katô kadattan kani lunsud.” ");
INSERT INTO bgs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Agad igbaring-baring si Lot, asal inéduwan tô Áglangngagán kandan. Purisu igawidan katô duwa panaligan tô bállad i Lot, tô sawa din, asta tô duwa gabatà dan, asta igpid dan tun ta luwà katô lunsud. ");
INSERT INTO bgs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Igkagi tô panaligan kandan, na mà dan, “Palaguy kód! Yakó ágsérê! Yakó ágsódô kannun ta kapattadan, asal palaguy kó sippang tun ta pabunganán agó maté kó.” ");
INSERT INTO bgs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Asal igkagi si Lot, na mà din, “Sir, diya. ");
INSERT INTO bgs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Agad tuu madigár tô tabang yu kanak, asta igpaluwà a ikiyu tikud tun ta kadattan, asal kasabbanna su tuu madiyù tô pabunganán, asta matéya ka diya pa dumunggù. ");
INSERT INTO bgs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Na, duwán madani lunsud na mému sadunan ku, asta délák gó yan. Papalaguyya baling dutun. Tuu gó délák tô lunsud, asta diya maté dutun!” ");
INSERT INTO bgs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Igtaba tô panaligan, na mà din, “Mému malaguy ka dutun. Dì ku dadattan tô lunsud tô. ");
INSERT INTO bgs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Asal sékót kód palaguy, su ándà pa mému lumun ku sippang ka dumunggù kó.” Purisu igngadanan tô lunsud na Soar. ");
INSERT INTO bgs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tô duwán dán álló asta tô igdunggù dán si Lot tun ta Soar, ");
INSERT INTO bgs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","igdabù katô Áglangngagán tô asupri na igrágrág tikud tun ta kawang-awangan tun ta lunsud ka Sodoma asta Gomora. ");
INSERT INTO bgs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Purisu idattan tô duwa lunsud asta tô langun ka duma mga lunsud tun ta kapattadan. Inaté tô langun manubù, asta idattan tô langun ka pamulanán. ");
INSERT INTO bgs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Asal igsérê tô sawa i Lot tun ta lunsud na igtananan dan. Purisu ibaluy sikandin sumbál na asin. ");
INSERT INTO bgs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na, igsállám si Abraham tun ta lugar na igsadunan din tô igtóngkô tô Áglangngagán kandin. ");
INSERT INTO bgs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Igsállág sikandin tun ta Sodoma asta Gomora, asta tun ta kaluwagan katô kapattadan. Igkita din tô tuu dakál ábbál tikud tun ta tanà, iring na ábbál ka dakál ággóbbówanan. ");
INSERT INTO bgs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Agad igdadattan katô Manama tô mga lunsud tun ta kapattadan na igóddóan i Lot, asal ándà din kalingawi si Abraham, asta igpaluwà din si Lot ébô dì sikandin maté. ");
INSERT INTO bgs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Na, imáddangan si Lot ka móddô sikandin tun ta Soar. Purisu igalin sikandin asta tô duwa gabatà din gabayi tun ta pabunganán, asta igóddô dan tun ta takub. ");
INSERT INTO bgs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Duwán álló na igkagi tô batà din kaké tun ta adi din, na mà din, “Tugál dán tô ámmà ta, asta ándà palang mama nit banuwa na kumalyag áknita ébô duwán batà ta. ");
INSERT INTO bgs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Na, madigár ka lasingán ta tô ámmà ta asta lumayuk ki kandin ébô duwán batà ta ukit kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Purisu, tô dukilám dán, iglasing dan tô ámmà dan, asta iglayuk tô kaké kandin. Asal ándà kinanuwan i Lot katô iglumu katô batà din kandin, su tuu ilasing. ");
INSERT INTO bgs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tô sállám dán, igkagi tô kaké tun ta adi din, na mà din, “Sakán tô iglayuk katô ámmà ta géna dukilám. Na, madigár ka lasingán ta puman sikandin kani ka dukilám, asta sikuna tô lumayuk kandin ébô duwán batà ta ukit kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tô dukilám dán, iglasing dan puman tô ámmà dan, asta iglayuk tô adi kandin. Ándà kinanuwan din katô iglumu katô batà din kandin, su tuu ilasing. ");
INSERT INTO bgs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Purisu igmabáddás dán tô duwa gabatà i Lot ukit kandin. ");
INSERT INTO bgs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Duwán batà mama na ipamasusu tun ta kaké, asta igngadanan din ki Moab. Inému sikandin na kamónaan katô langun Moabihanon áknganni. ");
INSERT INTO bgs_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Duwán pagsik batà mama na ipamasusu tun ta adi, asta igngadanan din ki Benami. Inému sikandin na kamónaan katô langun Amonihanon áknganni. ");
INSERT INTO bgs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Na, igalin si Abraham tikud tun ta Mamre sippang tun ta Negeb, asta igóddô dan tun ta lunsud ka Gerar na tun ta tángngaan katô lunsud ka Cades asta Sur. ");
INSERT INTO bgs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Igulit si Abraham katô mga taga Gerar na tábbé din tô sawa din na si Sara. Purisu igpakangé si Sara katô harì ka Gerar na si Abimelec ébô mému na sawa din. ");
INSERT INTO bgs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Asal igpakita tô Manama ki Abimelec ukit ka tagénáp, asta igkagi sikandin, na mà din, “Maté ka gó su igkangé nu tô bayi na duwán duma.” ");
INSERT INTO bgs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Asal su ándà pa layuk si Abimelec ki Sara, igkagi sikandin, na mà din, “Áglangngagán, matayanna gó ikuna asta tô mga sakup ku agad ándà palang salà dé? ");
INSERT INTO bgs_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Si Abraham gó tô igulit kanak na tábbé din si Sara, asta igkagi tô bayi na talatábbé dan. Ándà palang madat kakalyag ku, asta ándà palang salà ku kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tun ta tagénáp i Abimelec, igkagi tô Manama kandin, na mà din, “Óó. Isóddóran ku na ándà madat kakalyag nu. Purisu igsapadan ku sikuna ébô dì ka makasalà kanak. Igdalangan ku tô kapadani nu kandin. ");
INSERT INTO bgs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Na, ulì nu tô bayi tun ta duma din. Propeta si Abraham, asta dumasal sikandin tingód áknikó ébô dì ka maté. Atin ka dì nu sikandin ulián, maté ka gó asta tô langun sakup nu.” ");
INSERT INTO bgs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Na, igsállám si Abimelec iglimud katô langun opisyales din, asta igulit sikandin kandan tingód katô langun tun ta tagénáp din. Purisu tuu dan imáddangan. ");
INSERT INTO bgs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Igpakangé i Abimelec si Abraham, asta igkagi sikandin, na mà din, “Madat tô iglumu nu áknami. Ándin tô salà na ilumu ku áknikó ébô papiddanna ikuna asta tô mga sakup ku katô kadattan? Iglumu nu kanak tô dì mému lumun. ");
INSERT INTO bgs_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ándin tô gunayan na iglumu nu ni?” ");
INSERT INTO bgs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Igtaba si Abraham, na mà din, “Tô panámdám ku na ándà palang manubù dini na duwán máddang tun ta Manama. Kéman ku na duwán mimmaté kanak ébô agón tô sawa ku. ");
INSERT INTO bgs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bánnal tô igkagi ku na tábbé ku sikandin, su batà katô ámmà ku sikandin, asal igpassaé tô innà dé. Purisu igkalyagan ku sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Dángngan tô igpéwà tô Manama kanak tikud tun ta lunsud na igóddóan katô ámmà ku, igkagiyan ku tô sawa ku, na mà ku, ‘Atin ka duwán kédu nu kanak, agad ánda é dungguan ta, ulit nu na talatábbé ki.’” ");
INSERT INTO bgs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Purisu igulì i Abimelec si Sara tun ki Abraham. Duwán igbággé din kandin na mga karnero, mga baka, asta mga állang. ");
INSERT INTO bgs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Igkagi si Abimelec, na mà din, “Sállág nu tô kaluwagan kani tanà ku. Óddô ka tun ta agad ánda na kakalyag nu.” ");
INSERT INTO bgs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Igkagi sikandin ki Sara, na mà din, “Sábbad mararan (1,000) abuk ka mapputì bulawan tô igbággé ku tun ta tábbé nu ébô kasóddóran katô langun sakup nu na ándà salà nu. Tô gó é pató na ándà dán salà nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Na, igdasal si Abraham tun ta Manama, asta inólian dán si Abimelec, tô sawa din, asta tô mga állang din gabayi ébô makabatà dan puman, ");
INSERT INTO bgs_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","su ándà batà tô sawa i Abimelec asta tô langun sakup din gabayi su igkangé i Abimelec tô sawa i Abraham na si Sara. ");
INSERT INTO bgs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Na, igtuman katô Áglangngagán tô igtandô din, asta madigár tô igbággé din ki Sara. ");
INSERT INTO bgs_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Igmabáddás sikandin, asta igpamasusu sikandin ka batà mama, agad tugál dán si Abraham. Ipamasusu tô batà tô álló na taganà igtandô katô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Igngadanan i Abraham tô batà din ki Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tô igdunggù dán tô ikawalu álló tikud tun ta kapamasusu ki Isaac, igtupuwan i Abraham sikandin, su tô gó tô igsugù ka Manama kandin. ");
INSERT INTO bgs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sábbad gatus (100) tô idad i Abraham tô kapamasusu ki Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Igkagi si Sara, na mà din, “Igbággayanna ka Manama ka dayó. Purisu igngisiya. Ngumisi tô langun katô makadinág tingód katô inému kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Igkagi si Sara, na mà din, “Dángngan, ándà palang manubù na makakagi ki Abraham na dumunggù tô álló na pasusun ku tô batà din. Agad tugál dán sikandin, asal igpamasusuwad gó katô batà din.” ");
INSERT INTO bgs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tô igdakál si Isaac, igdiyà dán sikandin, asta igimu i Abraham tô dakál pista tingód katô álló na igdiyà tô batà din. ");
INSERT INTO bgs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Asal si Ismael na ipamasusu ki Agar na taga Ehipto, inalayun sikandin igyamà-yamà katô batà i Sara na si Isaac. Tô igkita si Sara katô, ");
INSERT INTO bgs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","igkagi sikandin ki Abraham, na mà din, “Péwà nu tô állang nu asta tô batà din, su atin dumunggù tô álló na maté ka, dì mému kabággayan tô batà ka állang katô tángngà katô kaduwánnan nu, su bággén tô langun tun ta batà nu na si Isaac.” ");
INSERT INTO bgs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tuu iranu si Abraham, su batà din gó si Ismael. ");
INSERT INTO bgs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Asal igkagi tô Manama ki Abraham, na mà din, “Yaka ágkaranu tingód kanan batà nu asta állang nu na si Agar. Tuman nu tô igkagi i Sara áknikó, su ukit katô batà nu na si Isaac bággén ku áknikó tô mga karubbadan na igtandô ku áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Imun ku pagsik na dakál karubbadan tô mga rubbad katô batà ka állang nu, su batà nu sikandin.” ");
INSERT INTO bgs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Purisu igsállám si Abraham igbággé ka ágkakan asta ágdalámmanan na ipánnù ka wayig tun ki Agar ébô baban din. Igpapanó din si Agar asta tô batà din. Igsadun si Agar tun ta disyerto ka Berseba, asta igpanó-panó dan. ");
INSERT INTO bgs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tô inémmát tô wayig na igpid dan, itákkangan dan, asta igtananan i Agar tô batà din tun ta siráb ka mabbabà kayu. ");
INSERT INTO bgs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Igsadun si Agar tun tóna na mga sábbad gatus (100) metros é kadiyuan, asta igunsad sikandin. Igpanámdám sikandin, na mà din, “Dì mému ka kumita a na maté tô batà ku.” Róggun igunsad si Agar, igsággó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Igdinág ka Manama tô sággón din, asta igtawar tô panaligan ka Manama tikud tun ta langit, na mà din, “Agar, imánnu ka? Yaka ágkamáddangan. Igdinág ka Manama tô sággón katô batà nu. ");
INSERT INTO bgs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Na, sadun ka tun kandin, asta órór nu sikandin, su imun ku na dakál grupo tô mga karubbadan din.” ");
INSERT INTO bgs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Na, igpakita ka Manama tô balun tun ki Agar. Purisu igsadun sikandin tun ta balun, igipánnù din tô ágdalámmanan ka wayig, asta igpénám din tô batà din. ");
INSERT INTO bgs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Madigár tô tabang ka Manama katô batà. Sippang ka igdakál sikandin, igóddô tun ta disyerto ka Paran, asta tuu katig sikandin ágpanà. ");
INSERT INTO bgs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Tun ta Paran, igpakalyag katô innà din sikandin katô bayi na taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Na, tô timpo tô, si Abimelec asta si Picol na pangulu katô mga sundalo din igsadun tun ki Abraham. Igkagi si Abimelec, na mà din, “Isóddóran ku na agad ándin tô áglumun nu, inalayun ka ágtabangan katô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Purisu kakalyag ku na tumandô ka tun ta saruwan ka Manama na dì ka lumimbung kanak, mga gabatà ku, asta mga rubbad ku. Inalayun madigár tô iglumu ku áknikó. Purisu tandô ka na inalayun madigár tô lumun nu kanak asta katô mga sakup ku na góddô kannun ta banuwa na igóddóan nu.” ");
INSERT INTO bgs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Igkagi si Abraham, na mà din, “Tô gó é tandô ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Na, igulit si Abraham kandin na duwán balun na igagó katô mga állang i Abimelec. ");
INSERT INTO bgs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Igkagi si Abimelec, na mà din, “Ándà ku kasóddóri ka sadan tô igagó katô balun. Ándà a ikuna uliti, asta ándà ku yan kasóddóri sippang ni álló ni.” ");
INSERT INTO bgs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Na, duwán mga karnero asta mga baka na igbággé i Abraham ki Abimelec, asta igpasaboté dan. ");
INSERT INTO bgs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Igsalin si Abraham ka pittu nati bayi ka karnero tikud tun ta mga karnero din. ");
INSERT INTO bgs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Iginsà si Abimelec, na mà din, “Manan ka igsalin nu yan?” ");
INSERT INTO bgs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Igtaba si Abraham, na mà din, “Tanggap nu ni pittu nati ka karnero ébô mému pató na sakán tô igpakali kani balun ni.” ");
INSERT INTO bgs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Purisu igngadanan tô lugar na Berseba, su igpasaboté dan dutun. ");
INSERT INTO bgs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tô igpasaboté dán si Abraham asta si Abimelec, igulì si Abimelec asta si Picol tun ta banuwa katô mga Filistihanon. ");
INSERT INTO bgs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Igpamula si Abraham ka kayu tamarisko tun ta Berseba, asta igpangadap sikandin katô Áglangngagán na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Idugé si Abraham igóddô tun ta banuwa katô mga Filistihanon. ");
INSERT INTO bgs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Na, duwán álló na igkinnaman ka Manama tô kapamaké i Abraham kandin. Igtawar tô Manama, na mà din, “Abraham!” Igtaba si Abraham, na mà din, “Óó. Kannunna.” ");
INSERT INTO bgs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Igkagi tô Manama, na mà din, “Pid nu tô bugtung batà nu na si Isaac na tuu nu ágginawaan, asta sadun kó tun ta banuwa ka Moria. Tikáddág kó tun ta pabungan na tádduán ku áknikó. Matayi nu sikandin asta góbbó nu tô lawa din ébô bággén nu sikandin kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Purisu igsállám si Abraham, igpaningkayu, asta igruran din tun ta asno din. Igpatákkás din tô batà din na si Isaac asta tô duwa állang din, asta igpanó dan tun ta lugar na igpasadunan ka Manama kandin. ");
INSERT INTO bgs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Itálluwan dan igpanó, igkita i Abraham tô lugar tun ta madiyù. ");
INSERT INTO bgs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Igkagi si Abraham katô duwa állang din, na mà din, “Óddô kó dád kannun duma katô asno, su sakán asta ni batà ku tô manayun tun ta pabungan ébô mangadap ké katô Manama, asta lumónód ké dini ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Igpapid i Abraham tô pagsunnuk ki Isaac. Igpid i Abraham tô kutsilyo asta tô baga ka apuy, asta igpanayun dan. ");
INSERT INTO bgs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Igkagi si Isaac, na mà din, “Ámmà!” Igtaba si Abraham, na mà din, “Ándin?” Iginsà si Isaac, na mà din, “Duwán baga ka apuy asta pagsunnuk ta, asal ánda tô nati ka karnero na góbbón asta bággén tun ta Manama?” ");
INSERT INTO bgs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Igtaba si Abraham, na mà din, “Manama tô mággé áknita katô nati ka karnero na góbbón asta bággén kandin.” Na, igpanayun dan igpanó. ");
INSERT INTO bgs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tô igdunggù dan dán tun ta pabungan na igpasadunan ka Manama ki Abraham, igimu din tô ággóbbówanan ka mannanap na bággén tun ta Manama, asta igtagù din tô pagsunnuk tun ta bówwó. Igbagkás din tô batà din asta igtagù din tun ta bówwó katô pagsunnuk. ");
INSERT INTO bgs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Igkangé din tô kutsilyo ébô matayan din dán tô batà din. ");
INSERT INTO bgs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Asal tô panaligan na Áglangngagán igtawar kandin tikud tun ta langit, na mà din, “Abraham! Abraham!” Igtaba si Abraham, na mà din, “Óó. Kannunna.” ");
INSERT INTO bgs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Igkagi tô Áglangngagán, na mà din, “Yaka ágdadat kanan batà nu. Yaka nu ágmánnuwi. Isóddóran kud na tuu ka ágbánnal ka Manama, su agad tô bugtung batà nu, bággén nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Na, igkita i Abraham tô karnero na ikasanggat tô panga din tun ta sigbát na dugin. Tô gó é igkangé i Abraham, igmatayan din, asta iggóbbó din na igbullas katô batà din. ");
INSERT INTO bgs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Igngadanan i Abraham tô lugar na, “Áglangngagán tô Ágbággé.” Agad áknganni, duwán ágkagin na, “Tun ta pabungan katô Áglangngagán, duwán ágbággén din.” ");
INSERT INTO bgs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Igtawar puman tô panaligan na Áglangngagán ki Abraham tikud tun ta langit, na mà din, ");
INSERT INTO bgs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Matuman gó ni tandô katô Áglangngagán áknikó. Su igbánnal ka kanak, asta ándà nu tingátti tô bugtung batà nu, asal igbággé nu sikandin kanak, ");
INSERT INTO bgs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","madigár gó tô bággén ku áknikó, su imun ku na tuu marapung tô mga rubbad nu iring na karapungan katô mga karani tun ta langit, asta iring na karapungan katô mga baklayan tun ta dagat. Makapanalu tô mga rubbad nu katô mga lunsud ka usig dan. ");
INSERT INTO bgs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Madigár tô bággén ku tun ta langun manubù ka banuwa ukit katô mga rubbad nu. Tô gó é lumun ku, su igtuman nu tô igsugù ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Na, iglónód si Abraham asta si Isaac tun ta duwa állang, igulì dan langun, asta igóddô si Abraham tun ta Berseba. ");
INSERT INTO bgs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Na, ándà kadugé, igulitan si Abraham na duwán dán mga gabatà katô kataladi din na si Nahor, su igpamasusu tô ipag din na si Melca. ");
INSERT INTO bgs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Si Hus tô tambang kaké batà din, si Bus tô ikaduwa, si Camuel na ámmà i Aram, ");
INSERT INTO bgs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","si Cased, si Asau, si Feldas, si Jedaf, asta si Betuel. ");
INSERT INTO bgs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Si Betuel tô ámmà i Rebecca.) Tô gó é mga ngadan katô walu gabatà i Nahor na ipamasusu ki Melca na ipag i Abraham. ");
INSERT INTO bgs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Igngadanan ki Roma tô ikaduwa sawa i Nahor. Ipamasusu tun kandin si Teba, si Gaam, si Taas, asta si Maaca. ");
INSERT INTO bgs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Na, tô sábbad gatus duwa pulù pittu (127) tô idad i Sara, inaté sikandin ");
INSERT INTO bgs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","tun ta lunsud ka Hebron na sakup ka Canaan. Iranu asta igsággó si Abraham tingód katô kamatayan i Sara. ");
INSERT INTO bgs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Igtananan i Abraham tô inaté sawa din, igsadun sikandin tun ta mga Hetihanon, asta igkagi sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ánnà a taga kannun, su igalinna dád dini ákniyu. Málliya pád ka tanà dini ákniyu ébô duwán lábbángngan ku katô sawa ku na inaté.” ");
INSERT INTO bgs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Igkagi tô mga Hetihanon, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sir, paminág nu ni kagi dé. Isóddóran dé na sikuna tô ágkabantug pangulu na igsalin katô Áglangngagán. Mému lábbángngán nu tô sawa nu dini ta tuu madigár áglábbángnganan dé. Agad ándin lábbángngi tô salinán nu, kadayawan tô tigatun na mággé kanan áknikó ébô duwán lábbángngan nu kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Purisu iglingkóód si Abraham tun kandan, ");
INSERT INTO bgs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","asta igkagi sikandin, na mà din, “Su mému lábbángngán ku tô sawa ku dini, pamuyù yu ki Efron na batà i Sohar ");
INSERT INTO bgs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ébô barigyaán din kanak tô takub ka Macpela tun ta ligad katô kinamát din. Kagiyi yu sikandin na agad pira tô lagà katô takub, bággén ku kandin tun ta tubang yu ébô duwán lábbángngan ku.” ");
INSERT INTO bgs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Tô timpo tô, igunsad si Efron duma katô mga Hetihanon na ilimud tun ta sállat katô lunsud dan, asta igdinág katô langun tô igtaba din ki Abraham, na mà din, ");
INSERT INTO bgs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Sir, paminág nu ni kagi ku. Bággén ku gó áknikó tô tibuk katô kinamát ku asta tô takub din. Tun ta tubang kani langun kadumaan ku, bággén kud áknikó ébô duwán lábbángngan nu katô sawa nu.” ");
INSERT INTO bgs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Na, iglingkóód puman si Abraham tun ta mga Hetihanon, ");
INSERT INTO bgs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","asta igkagi sikandin ki Efron tun ta tubang katô langun dan, na mà din, “Paminág nu ni kagin ku. Bayadan ku áknikó tô kadakállan katô lagà katô kinamát nu. Tanggap nu tô bayad ku ébô duwán lábbángngan ku katô sawa ku.” ");
INSERT INTO bgs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Igkagi si Efron, na mà din, ");
INSERT INTO bgs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sir, paminág nu ni kagin ku. Agad áppat gatus (400) abuk na mapputì bulawan tô lagà katô kinamát, asal dì ku pabayadan áknikó, su rarak ku gó sikuna. Panayun nu lábbángngi tô sawa nu dutun.” ");
INSERT INTO bgs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ignunug si Abraham ki Efron tingód katô lagà na igdinág katô langun Hetihanon na ilimud. Purisu igpesar din tô áppat gatus (400) abuk na mapputì bulawan, iring katô ágpesaranan na gamitán katô mga negosyante, asta igbággé din ki Efron. ");
INSERT INTO bgs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Purisu si Abraham dán tô inému na tigatun katô kinamát i Efron tun ta Macpela dadan tun ta silatan ka lunsud ka Mamre. Igbayadan din tô tanà asta tô takub, asta tô langun kayun na isakup tun ta kaluwagan katô tanà. ");
INSERT INTO bgs_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Inému si Abraham na tigatun katô tanà tun ta tubang katô langun Hetihanon na ilimud tun ta plasa madani tun ta gahuwanan katô lunsud. ");
INSERT INTO bgs_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Na, iglábbáng i Abraham tô lawa katô sawa din na si Sara tun dalám katô takub ka Macpela madani tun ta lunsud ka Mamre tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Purisu inému si Abraham na tigatun katô tanà asta takub katô Hetihanon, asta inému na áglábbángnganan din. ");
INSERT INTO bgs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na, tuu dán tugál si Abraham, asta inalayun madigár tô igbággé katô Áglangngagán kandin. ");
INSERT INTO bgs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Duwán sábbad állang i Abraham na inému na amo katô duma mga állang asta igsarigan i Abraham katô langun ka kaduwánnan din. Igkagi si Abraham kandin, na mà din, “Dappán nu yan bállad nu nit bubun ku. ");
INSERT INTO bgs_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Tandô ka kanak ukit tun ta ngadan katô Áglangngagán na igimu katô langit asta banuwa ta. Tandô ka na dì nu pakalyagán tô batà ku katô bayi na Canaanhon. ");
INSERT INTO bgs_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Asal lónód ka tun ta tanà na igtikudan ku, asta salin nu tô bayi tikud tun ta mga gakád ku ébô duwán kalyagan katô batà ku na si Isaac.” ");
INSERT INTO bgs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Asal iginsà tô ágsarigan din, na mà din, “Pamánnun ku ka dì malyag tô bayi mákkás kanak ka mulì a dini? Piddán ku tô batà nu tun ta banuwa na igtikudan nu?” ");
INSERT INTO bgs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Igtaba si Abraham, na mà din, “Dì! Yaka ágpid katô batà ku dutun. ");
INSERT INTO bgs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Dángngan, tô Áglangngagán na Manama na góddô tun ta langit tô igpid kanak tikud tun ta mga gakád katô ámmà ku asta tikud tun ta banuwa na ipamasusuwan ku, asta igtandóanna ikandin na bággén din ni tanà ni tun ta mga rubbad ku. Pónan katô Áglangngagán tô panaligan din áknikó. Tumabang sikandin áknikó ébô makakangé ka katô bayi na kalyagan katô batà ku. ");
INSERT INTO bgs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Atin ka dì malyag tô bayi mákkás áknikó, mému dì nu tumanán tô tandô nu kanak. Asal yaka nu ágpiddi tô batà ku dutun.” ");
INSERT INTO bgs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Purisu igdappán katô ágsarigan tô bállad din tun ta bubun katô amo din na si Abraham, asta igtandô sikandin na tumanán din tô igsugù i Abraham kandin. ");
INSERT INTO bgs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Na, igkangé katô ágsarigan tô sapulù kamelyo katô amo din, asta igruran din tô marapung klasi ka madigár gasa. Igpanó sikandin igsadun tun ta lunsud na igóddóan katô kataladi i Abraham na si Nahor tun ta Mesopotamia. ");
INSERT INTO bgs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tô igdunggù dán sikandin, tuu dán mapun. Tô gó tô oras ka kakangé katô mga gabayi ka wayig. Igádding sikandin madani tun ta balun tun ta luwà katô lunsud, asta igpapaginawa din tô mga kamelyo din. ");
INSERT INTO bgs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Igdasal sikandin, na mà din, “Áglangngagán na Manama na ágpangadapán katô amo ku na si Abraham, tabangiya nigó ébô matuman tô sugù katô amo ku na si Abraham na ágginawaan nu. ");
INSERT INTO bgs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Na, igtindággad dini ta balun na ágkangayanan ka wayig katô mga daraga na góddô dini. ");
INSERT INTO bgs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kumagiya tun ta sábbad daraga, na, ‘Pénámma tun ta tibud nu.’ Atin ka tumaba sikandin, ‘Inám ka, asta mangéya ka wayig ébô makénám tô mga kamelyo nu,’ kasóddóran ku na sikandin tô igsalin nu ébô kalyagan i Isaac. Atin ka tumanán nu ni, kasóddóran ku na igpakita nu tô dakál ginawa nu katô amo ku.” ");
INSERT INTO bgs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Róggun ágdasal sikandin, igdunggù si Rebecca na batà bayi i Betuel. Igtiang sikandin ka tibud. Tô apù din mama si Nahor na kataladi i Abraham, asta si Melca tô apù din bayi. ");
INSERT INTO bgs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Daraga pa si Rebecca, asta tuu madigár tô bónnóng din. Ándà palang sikandin layuki ka mama. Igsadun sikandin tun ta balun, igkangé ka wayig, asta iglónód. ");
INSERT INTO bgs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Igsékót tô ágsarigan igsumar kandin, asta igkagi sikandin, na mà din, “Pénámma yan ta tibud nu.” ");
INSERT INTO bgs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Igkagi tô daraga, na mà din, “Óó, sir. Inám ka.” Sékót din igsánnar tô tibud na igtiang din, asta igpénám din sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Tô iginám dán sikandin, igkagi tô daraga, na mà din, “Mangéya pagsik ka wayig ébô makénám tô mga kamelyo nu sippang ka kólian tô tákkang dan.” ");
INSERT INTO bgs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Sékót din igbusbus tô wayig tun ta ginámmanan, asta igpalaguy sikandin tun ta balun asta igkangé puman ka wayig sippang ka inólian tô tákkang katô langun kamelyo. ");
INSERT INTO bgs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ándà kagi tô ágsarigan, asal igsállág dád sikandin katô áglumun katô daraga ébô kasóddóran din ka igtuman katô Áglangngagán tô kakalyag din. ");
INSERT INTO bgs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tô inólian dán tô tákkang katô mga kamelyo din, igbággé katô ágsarigan kandin tô bulawan arites na dakál é lagà para ka idung din, asta tô duwa magdakál pangkis bulawan para ka bállad din. ");
INSERT INTO bgs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Iginsà sikandin, na mà din, “Sadan tô ámmà nu? Duwán lugar tun ta balé din ébô dumággà ké?” ");
INSERT INTO bgs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Igtaba tô bayi, na mà din, “Si Betuel tô ámmà ku. Si Nahor tô ámmà din asta si Melca tô innà din.” ");
INSERT INTO bgs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Igkagi pagsik tô bayi, na mà din, “Dakál tô ragami na dággaan katô mga kamelyo nu asta dakál tô ágkakan dan tun áknami. Duwán gó lugar ébô dumággà kó.” ");
INSERT INTO bgs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Purisu iglingkóód tô ágsarigan, asta igdurung din tô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Igkagi sikandin, na mà din, “Durungán tô Áglangngagán na Manama na ágpangadapán katô amo ku na si Abraham, su ágkasarigan tô Áglangngagán, asta igtuman din tô tandô din katô amo ku. Purisu igtákkássanna ikandin ébô makadunggù a tun ta balé katô gakád katô amo ku.” ");
INSERT INTO bgs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Igpalaguy tô bayi igulì, asta igulit sikandin katô innà din asta katô mga kadumaan din tingód katô langun. ");
INSERT INTO bgs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Duwán kataladi mama i Rebecca na igngadanan ki Laban. Tô igkita dán si Laban katô arites asta pangkis katô tábbé din, asta tô igdinág sikandin tingód katô igkagi katô manubù na igdunggù, igsékót sikandin igsumar. Tô igdunggù si Laban tun ta balun, dutun pô gó tô ágsarigan i Abraham asta tô mga kamelyo din. ");
INSERT INTO bgs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Igkagi si Laban, na mà din, “Madigár gó tô igbággé katô Áglangngagán áknikó. Tákkás ka kanak tun ta balé. Yaka góddô kannun, su duwán lugar na igpataganà ku para áknikó, asta duwán lugar para katô mga kamelyo nu.” ");
INSERT INTO bgs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Purisu igsadun dan tun ta balé, igpapónóg dan tô igruran katô mga kamelyo, asta igpakan dan. Igkangé dan tô wayig ébô urasan tô paa katô ágsarigan i Abraham asta mga kadumaan din. ");
INSERT INTO bgs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Asal tô igsánnar dan tô ágkakan, igkagi tô ágsarigan, na mà din, “Diya pa kuman ka dì ku pa ulitán tô ágdantulán ku dini ákniyu.” Igkagi si Laban, na mà din, “Uliti ké.” ");
INSERT INTO bgs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Igkagi sikandin, na mà din, “Sakán tô ágsarigan i Abraham. ");
INSERT INTO bgs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tuu madigár tô igbággé katô Áglangngagán katô amo ku, asta inému dán ágpangulun asta ágkabantug manubù. Igbággayan sikandin katô Áglangngagán ka marapung mga karnero, mga kambing, mga baka, bulawan, mga állang, mga kamelyo, asta mga asno. ");
INSERT INTO bgs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Agad tugál dán tô sawa din na si Sara, asal igpamasusu ka batà mama na igbággayan i Abraham katô langun ka kaduwánnan din. ");
INSERT INTO bgs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Igtandô a katô amo ku na dì ku pakalyagán tô batà din katô bayi na Canaanhon. ");
INSERT INTO bgs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Asal igpalónódda ikandin tun ta mga gakád din, tun ta mga rubbad katô ámmà din. Igsugù a ébô pamasakán ku tô bayi na kalyagan katô batà din. ");
INSERT INTO bgs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Iginsà ku sikandin, na, ‘Pamánnun ku ka dì malyag tô bayi na mákkás kanak ka mulì a?’ ");
INSERT INTO bgs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Igtaba sikandin, ‘Duwán panaligan katô Áglangngagán na ágbánnalán ku na patákkássán din áknikó ébô matuman tô ágdantulán nu. Kailangan angén nu tô bayi na kalyagan katô batà ku tun ta mga gakád ku, tun ta mga rubbad katô ámmà ku. ");
INSERT INTO bgs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Atin ka madun ka tun ta mga gakád ku asta dì dan maminág áknikó asta dì dan patákkássán tô bayi, mému dì nu tumanán tô tandô nu kanak.’ ");
INSERT INTO bgs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Na, tô igdunggù a géna tun ta balun, igdasalla, na mà ku, ‘Áglangngagán na Manama na ágpangadapán katô amo ku na si Abraham, atin ka mému áknikó, patuman nu tô ágdantulán ku kannun. ");
INSERT INTO bgs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Na, igtindággad dini ta balun. Atin ka dumunggù tô daraga ébô mangé ka wayig, asta kumagiya kandin, na mà ku, “Pénámma yan ta tibud nu,” ");
INSERT INTO bgs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","atin ka tumaba sikandin, na mà din, “Inám ka, asta mangéya pagsik ka wayig para katô mga kamelyo nu,” madigár gó ka sikandin tô bayi na igsalin nu, Áglangngagán, ébô kalyagan katô batà katô amo ku.’ ");
INSERT INTO bgs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Na, róggun ágdasalla, igdunggù si Rebecca na igtiang ka tibud. Igsadun sikandin tun ta balun asta igkangé ka wayig. Igkagiya kandin, ‘Pénámma.’ ");
INSERT INTO bgs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Igsékót din igsánnar tô tibud na igtiang din, asta igkagi sikandin, ‘Óó. Inám ka, asta mangéya pagsik ka wayig para katô mga kamelyo nu.’ “Purisu iginámma, asta igpénám din pagsik tô mga kamelyo ku. ");
INSERT INTO bgs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Iginsà a kandin ka sadan tô ámmà din, asta igkagi sikandin, ‘Si Betuel tô ámmà ku. Si Nahor tô ámmà din, asta si Melca tô innà din.’ “Purisu igbággé ku kandin tô arites para ka idung din, asta tô duwa pangkis para ka bállad din. ");
INSERT INTO bgs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Iglingkóódda asta igpangadappa katô Áglangngagán. Igdurung ku sikandin na ágpangadapán katô amo ku na si Abraham, su igtákkássanna katô Áglangngagán ébô makadunggù a kannun asta mangéya katô bayi tikud tun ta rubbad katô kataladi katô amo ku ébô kalyagan katô batà din mama. ");
INSERT INTO bgs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Na, ulitiya ka kéduwan yu tô amo ku asta madigár tô lumun yu tingód kandin. Atin ka dì mému ákniyu, ulitiya ébô kasóddóran ku ka ándin tô lumun ku.” ");
INSERT INTO bgs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Igkagi si Laban asta si Betuel, na mà dan, “Igpasóddór dán katô Áglangngagán tô kakalyag din. Purisu dì mému méllé ké kandin. ");
INSERT INTO bgs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mému piddán nu si Rebecca ébô kalyagan katô batà katô amo nu, su tô gó tô igpasóddór katô Áglangngagán áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tô igdinág katô ágsarigan i Abraham tô igkagi dan, iglingkóód sikandin asta igdurung din tô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Igukar din tô mga gasa, mga umpak, mga bulawan, asta mga mapputì bulawan, asta igbággé din ki Rebecca. Duwán pagsik mga gasa na dakál é lagà na igbággé din katô kataladi asta innà katô bayi. ");
INSERT INTO bgs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Pángnga igbággé, igkan sikandin asta tô duma mga manubù na igtákkás kandin, asta igdággà dan. Tô sállám dán, igkagi tô ágsarigan, na mà din, “Atin ka mému ákniyu, pólì ad ikiyu tun ta amo ku.” ");
INSERT INTO bgs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Asal igtaba tô kataladi asta tô innà i Rebecca, na mà dan, “Madigár ka dì nu pô piddán sikandin sippang ka lumabé tô mga sapulù álló, yan pa mému kód panó.” ");
INSERT INTO bgs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Asal igkagi sikandin, na mà din, “Yakó ágbaring áknami, su igtuman dán katô Áglangngagán tô ágdantulán ku dini. Atin ka mému ákniyu, pólì ad gó tun ta amo ku.” ");
INSERT INTO bgs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Igkagi sikandan, na mà dan, “Tawarán dé si Rebecca, asta sikandin tô insaán dé ka ándin tô kakalyag din.” ");
INSERT INTO bgs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Purisu igtawar dan si Rebecca, asta iginsà dan kandin, na mà dan, “Ándin tô kakalyag nu? Tumákkás ka kandin nigó?” Igtaba sikandin, na mà din, “Óó, mákkássad kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Purisu igpatákkás dan si Rebecca katô ágsarigan i Abraham asta mga kadumaan din. Duwán tugál bayi na taganà igdóppón ki Rebecca na igtákkás kandin. ");
INSERT INTO bgs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Tô ándà dan pa panó, igdasalan dan pa si Rebecca na madigár tô bággén ka Manama kandin. Igkagi sikandan, na mà dan, “Tábbé dé, mólà pa ka mému ka na kamónaan ka mga mararan karubbadan nu. Mólà pa ka makapanalu tô mga rubbad nu tun ta langun lunsud ka mga usig dan!” ");
INSERT INTO bgs_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Na, igsaké si Rebecca asta tô duma mga gabayi katô mga kamelyo ébô tumákkás dan katô ágsarigan i Abraham. Igpanó tô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Na, igóddô si Isaac tun ta Negeb, asta mantu sikandin igulì tikud tun ta Beerla-hai-roi. ");
INSERT INTO bgs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tô igsalláp dán tô álló, igsadun sikandin tun ta kinamát din ébô manó-panó. Igsállág sikandin asta igkita din na duwán mga manubù na igdunggù na igsaké ka mga kamelyo. ");
INSERT INTO bgs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tô igkita si Rebecca ki Isaac, igpónóg sikandin tikud tun ta kamelyo, ");
INSERT INTO bgs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","asta iginsà sikandin katô ágsarigan, na mà din, “Sadan tô manubù tun ta kinamát na igsumar áknita?” Igtaba sikandin, na mà din, “Amo ku sikandin.” Purisu igtambunan i Rebecca tô báttuk din ukit ka respeto din. ");
INSERT INTO bgs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Na, igulit tô ágsarigan ki Isaac tingód katô langun na iglumu din. ");
INSERT INTO bgs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Igpid i Isaac si Rebecca tun dalám katô tulda na taganà igóddóan katô innà din na si Sara. Inému din si Rebecca na sawa din, asta tuu igginawaan i Isaac sikandin. Purisu inandà tô ranu i Isaac tingód katô innà din na inaté. ");
INSERT INTO bgs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Na, igkalyag puman si Abraham katô bayi na igngadanan ki Ketura. ");
INSERT INTO bgs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Tô mga gabatà gamama i Abraham na ipamasusu i Ketura, tô gó si Simran, si Jocsan, si Medan, si Midian, si Isbac, asta si Suas. ");
INSERT INTO bgs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Jocsan tô ámmà i Seba asta i Dedan. Tô mga rubbad i Dedan, tô gó é inému na mga Asurim, Letusim, asta Leumin. ");
INSERT INTO bgs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Tô mga gabatà gamama i Midian, tô gó si Epa, si Eper, si Hanoc, si Abida, asta si Eldaa. Mga rubbad i Ketura tô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Si Isaac tô igbággayan i Abraham katô langun kaduwánnan din. ");
INSERT INTO bgs_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Asal tô ándà pa kamaté si Abraham, duwán igbággé din tun ta mga gabatà katô duma mga sawa din. Igpapanó din sikandan igsadun tun ta silatan ébô makapadiyù dan tun ta batà din na si Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Tô sábbad gatus kapittuwan lima (175) tô idad i Abraham, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Tô inaté sikandin, tuu dán sikandin tugál asta madigár tô kóddô din. Ikatalundug sikandin katô mga kamónaan din na inaté. ");
INSERT INTO bgs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Tô lawa din iglábbáng katô gabatà din na si Isaac asta si Ismael tun ta takub ka Macpela tun ta tanà dadan tun ta silatan katô lunsud ka Mamre na taganà igtigatun i Efron na batà i Sohar na Hetihanon. ");
INSERT INTO bgs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Tô gó tô tanà na taganà igbayadan i Abraham katô mga Hetihanon. Tô gó é iglábbángngan i Abraham katô sawa din na si Sara. ");
INSERT INTO bgs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pángnga inaté si Abraham, madigár tô igbággé katô Manama tun ta batà i Abraham na si Isaac, asta igóddô sikandin madani tun ta Beerla-hai-roi. ");
INSERT INTO bgs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ni gó tô mga rubbad i Ismael na batà i Abraham na ipamasusu ki Agar na taga Ehipto na állang i Sara. ");
INSERT INTO bgs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ni gó tô ngadan katô mga gabatà i Ismael tikud tun ta tambang kaké sippang tun ta tambang adi. Si Neabiot tô kaké, si Kedar, si Adbeel, si Mibsam, ");
INSERT INTO bgs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","si Misma, si Duma, si Masa, ");
INSERT INTO bgs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","si Hadad, si Tema, si Jetur, si Napis, asta si Kedema. ");
INSERT INTO bgs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Tô gó é mga gabatà i Ismael, asta inému dan na mga ágpangulun katô sapulù duwa (12) grupo. Purisu tô gó tô igngadan katô mga lunsud na igóddóan dan. ");
INSERT INTO bgs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Tô sábbad gatus tállu pulù pittu (137) tô idad i Ismael, inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Igóddô tô mga rubbad i Ismael tun ta kaluwagan ka banuwa tikud tun ta lunsud ka Habila sippang tun ta Sur dadan tun ta silatan ka Ehipto tun ta Asiria. Igássa dan góddô tun ta duma mga rubbad i Abraham. ");
INSERT INTO bgs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ni gó tô tingód katô batà i Abraham na si Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kappatan (40) dán tô idad i Isaac tô igkalyag sikandin ki Rebecca na batà i Betuel na Arameanhon na góddô tun ta Mesopotamia. Si Rebecca tô tábbé i Laban na Arameanhon. ");
INSERT INTO bgs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Na, ándà palang batà i Rebecca. Purisu igdasal si Isaac tun ta Áglangngagán tingód katô sawa din. Igpaminág tô Áglangngagán katô igpamuyù din. Purisu igmabáddás si Rebecca. ");
INSERT INTO bgs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Duwán dáppi tun ta mabataan din, asta iring na ágpadatté dan tô ándà dan pa pamasusuwi. Igkagi si Rebecca, na mà din, “Manan ka ilumu ni kanak?” Purisu iginsà sikandin katô Áglangngagán tingód katô dáppi. ");
INSERT INTO bgs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Igkagi tô Áglangngagán, na mà din, “Tô dáppi tun ta mabataan nu, tô gó é mému na kamónaan katô duwa grupo. Dì dan pasábbadé. Mému na tuu mabákkár tô sábbad grupo, asta tô kaké batà mému na állang katô adi din.” ");
INSERT INTO bgs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Na, tô igdunggù dán tô álló ka kapamasusu, dáppi tô ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mallutù tô una iglássut asta bulbulán tô lawa din. Purisu igngadanan dan sikandin ki Esau. ");
INSERT INTO bgs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tô iglássut tô adi din, igawid sikandin katô palu katô kaké din. Purisu igngadanan sikandin ki Jacob. Kannámman (60) dán tô idad i Isaac tô kapamasusu kandan. ");
INSERT INTO bgs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tô igmallaki dán tô duwa dan, katig si Esau ágpangággut, asta inalayun sikandin ágtalap tun ta kabánnássan. Asal ágtónnók si Jacob, asta góddô sikandin tun ta tulda. ");
INSERT INTO bgs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Tuu igginawa si Isaac ki Esau, su kakalyag din kannán tô mga mannanap ka kabánnássan na ágkaggut i Esau. Asal tuu igginawa si Rebecca ki Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Duwán álló na iglággà si Jacob ka mallutù gulay. Igdunggù si Esau tikud tun ta kabánnássan, asta tuu ágballusán sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Igkagi sikandin ki Jacob, na mà din, “Bággayiya katô mallutù gulay, su tuuwa igballus!” (Purisu duwán duma ngadan i Esau na si Edom.) ");
INSERT INTO bgs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Igkagi si Jacob, na mà din, “Duwán bággén ku áknikó ka bággayanna ikuna katô ágpulusán na tanggapán nu ka maté tô ámmà ta, su sikuna tô tambang kaké batà din.” ");
INSERT INTO bgs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ignunug si Esau, na mà din, “Óó. Ándà palang pulusán ku ka matéya tingód kani ballus ku.” ");
INSERT INTO bgs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Igkagi si Jacob, na mà din, “Kailangan una ka pa tandô.” Purisu igtandô si Esau na bággén din ki Jacob tô ágpulusán na bággén katô ámmà dan tun ta tambang kaké batà din. ");
INSERT INTO bgs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Purisu duwán pan asta iglággà mallutù gulay na igbággé i Jacob ki Esau. Pángnga igkan asta iginám si Esau, igpanó sikandin. Tun ta panámdám din, iring na ándà lagà katô ágpulusán na bággén katô ámmà din tun ta tambang kaké batà din. ");
INSERT INTO bgs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Na, duwán puman ballus tun ta Canaan. Ássa tô ballus na igdunggù ki Abraham. Igsadun si Isaac tun ta banuwa i Abimelec na harì katô mga Filistihanon tun ta lunsud ka Gerar. ");
INSERT INTO bgs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tô gó é igsadunan din, su igpakita tô Áglangngagán ki Isaac, asta igkagi sikandin, na mà din, “Yaka ágsadun tun ta Ehipto. Óddô ka tun ta banuwa na tádduán ku áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Atin ka móddô ka dini, tumabangnga áknikó, asta madigár tô bággén ku áknikó. Tô kaluwagan kani banuwa tô bággén ku áknikó asta tun ta mga rubbad nu, su tumanán ku tô igtandô ku katô ámmà nu na si Abraham. ");
INSERT INTO bgs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Imun ku na tuu marapung tô mga rubbad nu, iring na karapungan katô mga karani tun ta langit. Bággén ku kandan tô kaluwagan kani banuwa. Madigár tô bággén ku tun ta langun manubù ka banuwa ukit katô mga rubbad nu. ");
INSERT INTO bgs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Tô gó é imun ku su igbánnal si Abraham kanak. Igbánnal sikandin katô langun sugù ku, mga kagi ku, asta mga igtinurù ku kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Purisu igóddô si Isaac tun ta Gerar. ");
INSERT INTO bgs_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Iginsà tô mga gamama na taga Gerar tingód katô sawa din, asta igtaba sikandin, na mà din, “Tábbé ku sikandin.” Ándà din uliti na taladuma dan, su imáddangan sikandin. Panámdám din na matayan sikandin katô mga gamama ébô agón dan si Rebecca, su tuu madigár tô bónnóng din. ");
INSERT INTO bgs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Tô itagad-tagad dán tô kóddô i Isaac tun ta Gerar, igsállág si Abimelec na harì katô mga Filistihanon, asta igkita din si Isaac asta si Rebecca na igpakápkáppé. ");
INSERT INTO bgs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Purisu igpatawar din si Isaac, asta igkagi sikandin, na mà din, “Sawa nu kannê sikandin. Manan ka igkagi ka na tábbé nu sikandin?” Igtaba si Isaac, na mà din, “Su panámdám ku na matayanna ka kumagiya na sawa ku sikandin.” ");
INSERT INTO bgs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Igkagi si Abimelec, na mà din, “Madat tô iglumu nu áknami, su atin ka duwán sakup ku na iglayuk katô sawa nu, dungguan ké ka supak ka Manama ukit áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Purisu igkagi si Abimelec katô langun sakup din, na mà din, “Atin ka duwán lumumu ka madat kani manubù ni asta sawa din, tô gó é matayan.” ");
INSERT INTO bgs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Tô ámmé tô, igpamula si Isaac tun ta Gerar, asta igkáttu sikandin ka ginatus-gatus, su madigár tô igbággé katô Áglangngagán kandin. ");
INSERT INTO bgs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Inalayun idugangan tô kaduwánnan din sippang ka tuu dán iduwánnan sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tuu marapung tô mga karnero, mga baka, asta mga állang din. Purisu isabuan tô mga Filistihanon kandin, ");
INSERT INTO bgs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","asta igtambunan dan tô langun balun na taganà igpakali katô ámmà din na si Abraham tô ándà pa sikandin kamaté. ");
INSERT INTO bgs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Na, igkagi si Abimelec ki Isaac, na mà din, “Iwà ka tikud dini áknami, su inému kad tuu mabákkár ka tandingán áknami.” ");
INSERT INTO bgs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Purisu igpanó si Isaac, igalin sikandin tun ta kapattadan ka Gerar, asta igóddô sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Igpakali din puman tô mga balun na taganà igpakali katô ámmà din, su igtambunan katô mga Filistihanon pángnga inaté si Abraham. Igngadanan i Isaac tô mga balun magunawa katô igngadan katô ámmà din. ");
INSERT INTO bgs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Igkali tô mga állang i Isaac ka mantu balun tun ta kapattadan, asta duwán wayig na igsánnáp. ");
INSERT INTO bgs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Asal igpapulé tô mga taradóppón na taga Gerar asta tô mga taradóppón i Isaac, asta igkagi tô mga taga Gerar, na mà dan, “Áknami ni wayig ni.” Purisu igngadanan i Isaac tô balun na Esec, su igpapulé dan. ");
INSERT INTO bgs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Na, igkali puman tô mga állang din ka ássa balun. Asal igapul puman tô taga Gerar kandan tingód katô balun. Purisu igngadanan i Isaac tô balun na Sitna. ");
INSERT INTO bgs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Na, igalin si Isaac, asta duwán ássa balun na igpakali din. Ándà dan dán apul. Purisu igngadanan din tô balun na Rehobut, su igkagi sikandin, na mà din, “Nángngà dán tô lugar na igbággé katô Áglangngagán áknita, asta madigár dán tô kóddô ta dini.” ");
INSERT INTO bgs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Igalin puman si Isaac, asta igsadun sikandin tun ta Berseba. ");
INSERT INTO bgs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tô dukilám dán, igpakita tô Áglangngagán kandin, asta igkagi sikandin, na mà din, “Sakán tô Manama na ágpangadapán katô ámmà nu na si Abraham. Yaka ágkamáddangan, su ágtákkássan ku sikuna. Madigár tô bággén ku áknikó, asta imun ku na tuu marapung tô mga rubbad nu, su tô gó é igtandô ku ki Abraham na igbánnal kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Igimu i Isaac tô ággóbbówanan ka mannanap na ágbággén tun ta Áglangngagán, asta igpangadap sikandin katô Áglangngagán. Igóddô si Isaac, asta igkali tô mga állang din ka balun. ");
INSERT INTO bgs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Na, igahà si Abimelec ki Isaac. Igdunggù sikandin tikud tun ta Gerar. Igpatákkás din tô tarausay na si Ahusa asta tô ágpangulun ka mga sundalo din na si Picol. ");
INSERT INTO bgs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Igkagi si Isaac, na mà din, “Dángngan isókówanna ikiyu, asta igpéwà a ikiyu. Purisu manan ka igsadun kó dini kanak?” ");
INSERT INTO bgs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Igtaba sikandan, na mà dan, “Igsadun ké dini su isóddóran dé na inalayun ka ágtabangan katô Áglangngagán. Purisu panámdám dé na madigár ka pasaboté ki. Kakalyag dé na tumandô ka áknami ");
INSERT INTO bgs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","na dì ka dumadat áknami, iring na ándà ké dadat áknikó. Madigár tô iglumu dé áknikó, asta masuné tô ginawa dé tô igpanó ka. Isóddóran dé na madigár tô ágbággén katô Áglangngagán áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Na, igpému i Isaac tô kalimudan, asta igkan dan asta iginám dan. ");
INSERT INTO bgs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tô sállám dán, igpasaboté dan, asta igpapanó dan i Isaac na masuné tô ginawa dan langun. ");
INSERT INTO bgs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tô álló tô, igdunggù tô mga állang i Isaac, asta igulit dan kandin tingód katô mantu balun na igkali dan. Igkagi sikandan, na mà dan, “Duwán gó wayig!” ");
INSERT INTO bgs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Purisu igngadanan i Isaac tô balun na Seba, asta sippang áknganni ágngadanan tô lunsud dutun na “Berseba.” ");
INSERT INTO bgs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Tô kappatan (40) dán tô idad i Esau, igkalyagan din si Judita na batà i Beeri na Hetihanon. Igkalyagan din si Basimat na batà i Elon na Hetihanon. ");
INSERT INTO bgs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Tuu iranu si Isaac asta si Rebecca tingód katô duwa ikóddô kandan. ");
INSERT INTO bgs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Na, tuu dán tugál si Isaac, asta dì dán ágkita. Igtawar din tô tambang kaké batà din na si Esau, na mà din, “Esau.” Igtaba si Esau, na mà din, “Kannunna, Ámmà.” ");
INSERT INTO bgs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Igkagi si Isaac, na mà din, “Tugállad, asta masiggad maté. ");
INSERT INTO bgs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Na, kangé nu tô panà nu, asta sadun ka tun ta kabánnássan ébô mangággut ka. ");
INSERT INTO bgs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Óméng ka katô ákkud na duwán madigár nanam iring katô tuu ku ágkadigárran ébô kannán ku tô diya pa maté, su dumasalla ébô madigár tô bággén katô Áglangngagán áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Róggun igkagi si Isaac ki Esau, igdinág i Rebecca tô igkagi din. Tô igpanó si Esau ébô mangággut, ");
INSERT INTO bgs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","igkagi si Rebecca katô batà din na si Jacob, na mà din, “Na, igdinág ku géna tô igkagi katô ámmà nu tun ta kaké nu na si Esau. ");
INSERT INTO bgs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Igkagi sikandin, ‘Pangággut ka asta óméng ka katô ákkud na duwán madigár nanam ébô kannán ku tô diya pa maté, su dumasalla ébô madigár tô bággén katô Áglangngagán áknikó.’ ");
INSERT INTO bgs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","“Na, bánnal nu ni sugù ku áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Sadun ka tun ta mga mannanap, kangé nu tô duwa malambù nati ka kambing, asta sakán tô móméng katô duwán madigár nanam iring katô tuu ágkadigárran katô ámmà nu. ");
INSERT INTO bgs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sikuna tô mid katô ágkakan tun ta ámmà nu ébô sikuna tô bággayan ka madigár ka dumasal sikandin ka dì pa maté.” ");
INSERT INTO bgs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Asal igkagi si Jacob katô innà din, na mà din, “Bulbulán si Esau, asal sakán ánnà bulbulán. ");
INSERT INTO bgs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Atin ka sapunna katô ámmà ku, kasóddóran din na iglimbungan ku sikandin. Purisu ándà ágpulusán na tanggapán ku, asal padungguanna baling ka kadattan.” ");
INSERT INTO bgs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Igkagi tô innà din, na mà din, “Atin ka dumunggù tô kadattan, sakán tô dungguan. Bánnal nu ni sugù ku! Kangé nud tô mga kambing!” ");
INSERT INTO bgs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Purisu igkangé i Jacob tô mga kambing asta igpid din tun ta innà din. Igóméng tô innà din katô duwán madigár nanam iring katô ágkadigárran i Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Igkangé i Rebecca tô madigár umpak i Esau na igtagù tun ta balé, asta igpómpak din ki Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Igtagù din tô kindal ka kambing tun ta bállad asta alig i Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Igbággé din ki Jacob tô madigár ágkakan asta tô pan na igimu din. ");
INSERT INTO bgs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Igsadun si Jacob tun ta ámmà din, asta igkagi sikandin, na mà din, “Ámmà.” Igkagi si Isaac, na mà din, “Óó, sadan ka batai?” ");
INSERT INTO bgs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Igtaba si Jacob, na mà din, “Sakán tô tambang kaké batà nu na si Esau. Igbánnal ku tô igsugù nu kanak. Ánnó ka, asta kan ka kani na igpid ku asta dasal ka ébô madigár tô bággén katô Áglangngagán kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Iginsà si Isaac, na mà din, “Esau, manan ka ándà ka kadugé katô kapangággut nu?” Igtaba si Jacob, na mà din, “Igtabanganna katô Áglangngagán na Manama na ágpangadapán nu.” ");
INSERT INTO bgs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Na, igkagi si Isaac ki Jacob, na mà din, “Padani ka kanak, su sumapuwa áknikó ébô kasóddóran ku na bánnal ka gó batà ku na si Esau.” ");
INSERT INTO bgs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Igpadani si Jacob katô ámmà din, asta igsapu si Isaac kandin. Igkagi si Isaac, na mà din, “Agad iring na kagi i Jacob tô kagi nu, asal iring na bállad i Esau tô bállad nu.” ");
INSERT INTO bgs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ándà din kilalayi si Jacob, su bulbulán tô bállad din iring na bállad i Esau. Purisu igdasal si Isaac ébô madigár tô bággén ka Manama kandin. ");
INSERT INTO bgs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Iginsà si Isaac, na mà din, “Bánnal na sikuna tô batà ku na si Esau?” Igtaba si Jacob, na mà din, “Óó.” ");
INSERT INTO bgs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Igkagi si Isaac, na mà din, “Bággayiya katô ágkakan. Kumanna, asta dumasalla ébô madigár tô bággén katô Áglangngagán áknikó.” Purisu igbággé i Jacob tô ágkakan tun kandin, asta igkan si Isaac. Igbággé i Jacob tô bino, asta iginám si Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Na, igkagi si Isaac, na mà din, “Esau, padani ka, asta adák ka kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Igpadani si Jacob asta igadák katô ámmà din. Tô ingadággan i Isaac tô umpak i Esau, igdasal sikandin. Igkagi sikandin, na mà din, “Madigár tô ngadág kani batà ku, iring katô ngadág ka tanà na igpalambù katô Áglangngagán! ");
INSERT INTO bgs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mólà pa ka bággayan ka katô Manama katô tanà na malambù asta inalayun ágkalámmás ka udan ébô dakál tô káttun nu, asta ébô dakál tô bino na imun nu. ");
INSERT INTO bgs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mólà pa ka marapung tô mga grupo na mému állang nu. Mólà pa ka marapung tô mga manubù na lumingkóód tun áknikó. Mólà pa ka mangulu ka tun ta langun kataladi nu. Mólà pa ka bánnalán ka katô langun gabatà katô innà nu. Supakan ka Manama tô langun manubù na dumadat áknikó, asal madigár tô bággén ka Manama tun ta langun manubù na mággé ka madigár tun áknikó!” ");
INSERT INTO bgs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Pángnga igdasal si Isaac asta róggun igpanó si Jacob, igdunggù si Esau tikud tun ta kapangággut din. ");
INSERT INTO bgs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Igóméng pagsik sikandin katô duwán madigár nanam, asta igpid din tun ta ámmà din. Igkagi si Esau, na mà din, “Ámmà, ánnó kad asta kan kad kani ágkakan na igpid ku ébô dumasal ka na madigár tô bággén katô Áglangngagán kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Iginsà si Isaac, na mà din, “Sadan ka batai?” Igtaba si Esau, na mà din, “Sakán gó tô tambang kaké batà nu na si Esau.” ");
INSERT INTO bgs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Na, tuu igkárkár si Isaac su isalábbuan. Iginsà sikandin, na mà din, “Atin ka sikuna si Esau, sadan tô igóméng katô ákkud géna asta igpakan kanak? Tô ándà ka pa dunggù, igkanna, asta igdasallad ébô madigár tô bággén ka Manama kandin, asta dì dán mému umanán ku.” ");
INSERT INTO bgs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tô igdinág dán si Esau katô igkagi katô ámmà din, tuu igsággó sikandin asta igdarawit. Igkagi sikandin, na mà din, “Ámmà, dasal ka ébô madigár pagsik tô bággén katô Manama kanak!” ");
INSERT INTO bgs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Asal igkagi si Isaac, na mà din, “Iglimbunganna katô adi nu, asta igagó din dán tô dasalán ku pád para áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Igkagi si Esau, na mà din, “Nángngà tô pagngadan ki Jacob, su makaduwa dán sikandin iglimbung kanak. Dángngan igagó sikandin katô ágpulusán na tanggapán katô tambang kaké batà nu ka maté ka, asta igagó din dán tô madigár na bággén pád ka Manama kanak. Asal duwán pa basì madigár na mému dasalán nu ébô bággén katô Manama kanak?” ");
INSERT INTO bgs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Igtaba si Isaac, na mà din, “Na, igdasallad ébô mému sikandin na pangulu nu, asta mému na mga állang din tô langun gakád din. Igdasallad tun ta Áglangngagán ébô dakál tô káttun din asta dakál tô bino din. Ándà dán palang madigár na dasalán ku ébô bággén katô Áglangngagán áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Igkagi si Esau, na mà din, “Ámmà, ándà dán ássa madigár na bággén ka Manama kanak? Ámmà, dasal ka ébô madigár pagsik tô bággén ka Manama kanak!” Asta igsággó si Esau. ");
INSERT INTO bgs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Na, igkagi si Isaac, na mà din, “Móddô ka tun ta tanà na ándà kalambuan asta ándà udan. ");
INSERT INTO bgs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kailangan gamitán nu tô laniban ébô duwán kantayan nu. Mému ka na állang katô adi nu. Asal ka matu ka kandin, makéwà ka tikud tun ta pagpangulu din áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Tuu isókó si Esau ki Jacob su igagó sikandin katô madigár na bággén kandin. Igplano si Esau, na mà din, “Dì madugé, maté dán tô ámmà ku. Atin ka mapángnga lábbángngán sikandin, matayan ku si Jacob.” ");
INSERT INTO bgs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Asal duwán igulit ki Rebecca tingód katô plano i Esau. Purisu igtawar din si Jacob, asta igkagi sikandin, na mà din, “Ágplano si Esau mimmaté áknikó ébô sulian ka. ");
INSERT INTO bgs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Purisu tuman nu ni sugù ku áknikó. Palaguy ka, asta sadun ka tun ta kataladi ku na si Laban tun ta Haran. ");
INSERT INTO bgs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Óddô ka tun kandin sippang ka mandà tô sókó katô kataladi nu. ");
INSERT INTO bgs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Atin ka kalingawan din dán tô iglumu nu kandin, pakangén ku sikuna ébô makólì ka dini. Kailangan miwà kad, su dì mému ka kamatayanna ka duwa gabatà ku dalám dád ka sábbad álló.” ");
INSERT INTO bgs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Igkagi si Rebecca ki Isaac, na mà din, “Tuu mahirap tô kóddô ku tingód katô mga ikóddô áknita na Hetihanon. Atin ka duwán Hetihanon na kalyagan i Jacob iring kani duwa sawa i Esau, tuu pa madigár ka matéyad!” ");
INSERT INTO bgs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Purisu igtawar si Isaac ki Jacob, asta igdasal sikandin ébô madigár tô bággén katô Manama kandin. Igkagi sikandin ki Jacob, na mà din, “Yaka ágkalyag ka bayi na Canaanhon. ");
INSERT INTO bgs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Sadun ka baling tun ta Mesopotamia tun ta pamilya katô apù nu na si Betuel. Madigár ka kalyagan nu tô batà katô amayánnán nu na si Laban. ");
INSERT INTO bgs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mólà pa ka madigár tô bággén katô Tuu Matulus Manama áknikó, asta imun din na marapung tô mga rubbad nu ébô mému ka na kamónaan katô marapung mga grupo ka manubù. ");
INSERT INTO bgs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Mólà pa ka tumanán katô Manama tô igtandô din ki Abraham ébô matigatun nu asta katô mga rubbad nu ni tanà na igóddóan ta, su ni gó tô tanà na igtandô ka Manama ki Abraham!” ");
INSERT INTO bgs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Na, igpapanó i Isaac si Jacob, asta igsadun sikandin tun ta Mesopotamia sippang tun ki Laban na batà i Betuel na Arameanhon. Si Laban tô kataladi i Rebecca na innà i Jacob asta i Esau. ");
INSERT INTO bgs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Na, igulitan si Esau na igdasal si Isaac ébô madigár tô bággén ka Manama ki Jacob asta igpasadun din si Jacob tun ta Mesopotamia ébô kumalyag sikandin. Igulitan si Esau na maggát igkagi si Isaac ki Jacob na dì mému kalyagan din tô bayi Canaanhon. ");
INSERT INTO bgs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ikasóddór si Esau na igtuman si Jacob katô ámmà asta innà din, asta igsadun sikandin tun ta Mesopotamia. ");
INSERT INTO bgs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Agad duwán dán duwa sawa i Esau, asal tô ikasóddór sikandin na ándà kadayawi tô ámmà din tingód katô mga gabayi na Canaanhon, ");
INSERT INTO bgs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","igsadun sikandin tun ta amayánnán din na si Ismael na batà i Abraham, asta igkalyagan din tô batà i Ismael na si Mahalat na adi i Neabiot. ");
INSERT INTO bgs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Tô igpanó si Jacob tikud tun ta Berseba, igsadun sikandin tun ta Haran. ");
INSERT INTO bgs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Asal idukilámman sikandin tun ta dalan. Purisu igdággà sikandin tun ta tanà ébô tumudug, asta batu tô iggulunan din. ");
INSERT INTO bgs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Igtagénáp sikandin. Igkita din tô tété na igpatindág tun ta tanà asta igdunggù tun ta langit. Marapung tô mga panaligan na ágpénék asta ágpónóg! ");
INSERT INTO bgs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Igkita din tô Áglangngagán na igtindág tun datas, asta igkagi sikandin ki Jacob, na mà din, “Sakán tô Áglangngagán na Manama na ágpangadapán katô apù nu na si Abraham, asta ámmà nu na si Isaac. Ni tanà na igdággaan nu, tô gó é bággén ku áknikó asta tun ta mga rubbad nu. ");
INSERT INTO bgs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Imun ku na marapung tô mga rubbad nu sippang ka dì dan méyap, iring na mga barukbuk ka tanà. Matalap tô mga rubbad nu tun ta kaluwagan kani banuwa agad ánda kitanán nu. Madigár tô bággén ku tun ta langun manubù nit banuwa ukit áknikó asta mga rubbad nu. ");
INSERT INTO bgs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na, dumuma a gó áknikó, asta dóppónan ku gó sikuna agad ánda é sadunan nu. Sakán tô pólì áknikó nit tanà ni, su inalayunna dumuma áknikó sippang ka tumanán ku tô langun katô igtandô ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Na, ikannó si Jacob, asta igkagi sikandin, na mà din, “Kannun gó tô Áglangngagán ta lugar ni, asal ándà ku kasóddóri.” ");
INSERT INTO bgs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Imáddangan sikandin, asta igkagi, na mà din, “Makamáddang ni lugar ni, su ni gó tô balé katô Manama! Kannun tô sállat tun ta langit!” ");
INSERT INTO bgs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tô sállám dán, igkangé i Jacob tô batu na iggulunan din, asta igpatindág din ébô imun din na kasampáttan batu. Igbusbusan din tô batu ka langis ka olibo, su igimu din na ágpangadapanan din katô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Igngadanan din tô lugar na Betel. Asal taganà igngadanan na Luz tô lugar tô. ");
INSERT INTO bgs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Igtandô si Jacob katô Manama, na mà din, “Atin dumuma ka asta ágbanté ka kanak tun ta panawan ku, asta mággé ka kanak ka ágkakan asta umpakán ");
INSERT INTO bgs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sippang mulì a tun ta balé katô ámmà ku na ándà makadadat kanak, sikuna na Áglangngagán tô inalayun ku gó pangadapán. ");
INSERT INTO bgs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ni batu na igpatindág ku imun ku na balé nu, asta bággén ku áknikó tô ikasapulù katô langun ka kaduwánnan na bággén nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Na, igpanayun si Jacob sippang ka igdunggù sikandin tun ta tanà na igóddóan katô mga manubù dadan tun ta silatan. ");
INSERT INTO bgs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Igkita din tô balun na madiyù tun ta lunsud, asta duwán tállu grupo ka mga karnero na igdággà madani tun ta balun. Ilimud tô mga karnero su minám dan. Asal duwán dakál batu na pagtambun katô balun. ");
INSERT INTO bgs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Atin ágkalimud dán tô langun karnero, áglilidán katô mga taradóppón tô batu tikud tun ta bóbbó katô balun, asta ágkangé dan ka wayig ébô minám tô mga karnero. Pángnga iginám, tambunan dan puman tô balun. ");
INSERT INTO bgs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Iginsà si Jacob katô mga taradóppón, na mà din, “Mga rarak ku, ánda kó tikud?” Igtaba sikandan, na mà dan, “Taga Haran ké.” ");
INSERT INTO bgs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Iginsà si Jacob, na mà din, “Igkilala kó ki Laban na apù i Nahor?” Igtaba sikandan, na mà dan, “Óó. Igkilala ké kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Iginsà si Jacob, na mà din, “Madigárrù tô kóddô din?” Igtaba sikandan, na mà dan, “Madigárrù. Na, yan dán gó tô batà din bayi na si Raquel na ágpid katô mga karnero!” ");
INSERT INTO bgs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Igkagi si Jacob, na mà din, “Na, mallayat pa tô álló. Ándà pa dunggù tô oras ka kalimud katô mga karnero. Madigár ka pénámmán yu tô mga karnero asta pasabsabán yu puman.” ");
INSERT INTO bgs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Igtaba sikandan, na mà dan, “Dì pa mému pénámmán dé tô mga karnero. Atin ka malimud dán tô langun, lilidán dé tô batu tikud tun ta bóbbó katô balun, asta pénámmán dé tô mga karnero.” ");
INSERT INTO bgs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Róggun ágkagi si Jacob kandan, igdunggù si Raquel na igpid katô mga karnero katô ámmà din, su sikandin tô taradóppón. ");
INSERT INTO bgs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tô igkita i Jacob si Raquel na ágpid katô mga karnero i Laban na amayánnán i Jacob, igsadun sikandin tun ta balun, iglilid din tô batu na igtambun katô balun, igkangé din tô wayig, asta igpénám din tô mga karnero katô amayánnán din. ");
INSERT INTO bgs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Igadák si Jacob ki Raquel asta igsággó tingód ka dayó din. ");
INSERT INTO bgs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Igkagi sikandin ki Raquel, na mà din, “Bataánnánna katô ámmà nu, su tábbé din si Rebecca tô innà ku.” Purisu igpalaguy si Raquel igulì, asta igulit sikandin katô ámmà din. ");
INSERT INTO bgs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tô ikasóddór si Laban na igdunggù tô bataánnán din na si Jacob, igsékót sikandin igsumar. Igkápkáppan din si Jacob, asta igadákkan din. Igpid din si Jacob tun ta balé din. Igulit si Jacob ki Laban tingód katô langun na ilumu. ");
INSERT INTO bgs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Igkagi si Laban, na mà din, “Bánnal gó na bataánnán ku sikuna!” Igóddô si Jacob tun ki Laban dalám ka sábbad bulan. ");
INSERT INTO bgs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Na, igkagi si Laban ki Jacob, na mà din, “Agad bataánnán ku sikuna, asal dì mému lumumu ka dini kanak na ándà tandan ku áknikó. Purisu ulitiya ka ándin tô tandan ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na, duwa tô gabatà daraga i Laban. Si Lea tô kaké, asta si Raquel tô adi. ");
INSERT INTO bgs_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Agad madigár ágsállággán tô mata i Lea, asal tuu pa madigár é lawa i Raquel, asta tuu madigár ágsállággán é bónnóng din. ");
INSERT INTO bgs_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Dakál gó tô ginawa i Jacob ki Raquel. Purisu igkagi sikandin, na mà din, “Lumumuwa dini áknikó ka pittu ámmé ka pakalyagan nu kanak tô batà nu adi na si Raquel.” ");
INSERT INTO bgs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Igkagi si Laban, na mà din, “Madigár gó ka sikuna tô pakalyagán ku kandin, su sikuna tô tuu madigár ka tandingán katô duma mga manubù na kumalyag pád kandin. Na, óddô ka dini, asta lumu ka dini kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Purisu iglumu si Jacob ka pittu ámmé ébô kalyagan din si Raquel. Asal tun ta panámdám i Jacob, iring na pira dád álló tô kadugayan, su tuu dakál tô ginawa din ki Raquel. ");
INSERT INTO bgs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tô iglabé dán tô pittu ámmé, igkagi si Jacob ki Laban, na mà din, “Na, bággé nu tô batà nu kanak ébô mému dán sawa ku, su ituman dán tô pittu ámmé.” ");
INSERT INTO bgs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Purisu igpému i Laban tô dakál kalimudan, asta igpalimud din tô langun manubù na igóddô dutun. ");
INSERT INTO bgs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Asal tô dukilám dán, ánnà si Raquel tô igpid i Laban tun ki Jacob, asal si Lea, asta sikandin tô iglayukan i Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Igbággé i Laban ki Lea tô állang din bayi na si Zilfa ébô tumabang kandin.) ");
INSERT INTO bgs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Na, tô sállám dán, igkita i Jacob na si Lea kannê tô iglayukan din. Purisu igésà sikandin katô ugang din, na mà din, “Madat ni iglumu nu kanak! Si Raquel tô igtandô nu kanak tingód katô lumu ku. Manan ka iglimbung ka kanak?” ");
INSERT INTO bgs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Igtaba si Laban, na mà din, “Duwán ágkémun dé na dì mému pakalyagan tô adi daraga ka dì pa unan pakalyagan tô kaké. ");
INSERT INTO bgs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Angat ka ka sábbad linggo sippang ka mapángnga tô kalimudan ka kasal nu ki Lea, asta bággén ku pagsik áknikó tô adi din na si Raquel. Asal kailangan lumumu ka puman kanak ka pittu pa ámmé.” ");
INSERT INTO bgs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Na, ignunug si Jacob. Tô ipángnga dán tô sábbad linggo katô kasal i Jacob ki Lea, igbággé i Laban tô batà din na si Raquel ki Jacob ébô mému na sawa din. ");
INSERT INTO bgs_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Igbággé i Laban ki Raquel tô állang din bayi na si Bilha ébô tumabang kandin.) ");
INSERT INTO bgs_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iglayuk pagsik si Jacob ki Raquel, asta dakál pa tô ginawa i Jacob ki Raquel ka tandingán ki Lea. Iglumu si Jacob tun ki Laban ka pittu pa ámmé. ");
INSERT INTO bgs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tô ikasóddór tô Áglangngagán na délák tô ginawa i Jacob ki Lea, igpabatà din si Lea, asal ándà palang batà i Raquel. ");
INSERT INTO bgs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Igmabáddás si Lea asta igpamasusu sikandin ka batà mama. Igkagi sikandin, na mà din, “Igkita katô Áglangngagán tô kahirapan ku. Na, ginawaannad pád katô duma ku.” Purisu igngadanan din tô batà din ki Ruben. ");
INSERT INTO bgs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Igmabáddás puman si Lea, asta igpamasusu puman sikandin ka batà mama. Igkagi sikandin, na mà din, “Igbággayanna puman katô Áglangngagán kani batà, su igdinág din na délák tô ginawa katô duma ku kanak.” Purisu igngadanan din tô batà din ki Simeon. ");
INSERT INTO bgs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Igmabáddás puman si Lea, asta igpamasusu puman sikandin ka batà mama. Igkagi sikandin, na mà din, “Ginawaannad basì katô duma ku, su igpamasusuwad kani tállu gabatà din gamama.” Purisu igngadanan din tô batà din ki Levi. ");
INSERT INTO bgs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Igmabáddás puman si Lea, asta igpamasusu puman sikandin ka batà mama. Igkagi sikandin, na mà din, “Durungán kud tô Áglangngagán.” Purisu igngadanan din tô batà din ki Juda. Pángnga igpamasusu si Lea ki Juda, ándà pa puman sikandin batà. ");
INSERT INTO bgs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Asal ándà palang batà na ipamasusu i Raquel. Purisu isabuan sikandin katô kaké din. Igkagi sikandin ki Jacob, na mà din, “Atin ka diya ikuna pabataán, matéya!” ");
INSERT INTO bgs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Isókó si Jacob ki Raquel, asta igkagi sikandin, na mà din, “Ánnà a Manama! Sikandin tô ándà pabatà áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Igkagi si Raquel, na mà din, “Bággén ku áknikó tô állang ku na si Bilha. Layuk ka kandin ébô duwán pamasusun din na mému mga gabatà ku ukit kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Purisu igbággé i Raquel tô állang din na si Bilha ki Jacob ébô imun na sawa din. Tô igpalayuké dan, ");
INSERT INTO bgs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","igmabáddás si Bilha, asta igpamasusu sikandin ka batà mama. ");
INSERT INTO bgs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Igkagi si Raquel, na mà din, “Inéduwan tô Manama kanak. Igpaminág sikandin katô igpamuyù ku, asta igbággayanna ikandin kani batà mama!” Purisu igngadanan i Raquel tô batà ki Dan. ");
INSERT INTO bgs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Igmabáddás puman si Bilha, asta igpamasusu sikandin katô ikaduwa batà din mama. ");
INSERT INTO bgs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Igkagi si Raquel, na mà din, “Sakán asta tô kaké ku, igpamatayé ké dángngan, asal áknganni italu kud sikandin.” Purisu igngadanan i Raquel tô batà ki Neftali. ");
INSERT INTO bgs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Na, tô ikapanámdám si Lea na ándà puman sikandin batà, igbággé din tô állang din na si Zilfa ki Jacob ébô mému na sawa din. ");
INSERT INTO bgs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Igmabáddás si Zilfa, asta igpamasusu sikandin ka batà mama. ");
INSERT INTO bgs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Igkagi si Lea, na mà din, “Igtabanganna katô Manama!” Purisu igngadanan i Lea tô batà ki Gad. ");
INSERT INTO bgs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Duwán ikaduwa batà mama i Jacob na igpamasusu ki Zilfa. ");
INSERT INTO bgs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Igkagi si Lea, na mà din, “Tuuwa idayawan! Kumagi dán tô duma mga gabayi na tuuwa idayawan.” Purisu igngadanan i Lea tô batà ki Aser. ");
INSERT INTO bgs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Na, tun ta timpo ka kakáttu ka trigo, igsadun si Ruben tun ta kinamát, asta igkita din tô mga sigbát na ágngadanan mandragora na ágkannán ka mga gabayi ébô matà dan. Igpid din tô mga mandragora tun ta innà din na si Lea. Igkagi si Raquel ki Lea, na mà din, “Bággayiya katô mga mandragora na igpid katô batà nu.” ");
INSERT INTO bgs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Igkagi si Lea, na mà din, “Igagó nu gó tô duma ku. Agón nud puman tô mga mandragora na igpid katô batà ku?” Igkagi si Raquel, na mà din, “Na, bággé nu kanak tô mga mandragora, asta sikuna tô palayukan ku ki Jacob kani ka dukilám.” ");
INSERT INTO bgs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Na, tô igsalláp dán tô álló, igulì si Jacob tikud tun ta kinamát. Igsumar si Lea kandin, asta igkagi sikandin, na mà din, “Kailangan lumayuk ka kanak ni dukilám, su duwán mga mandragora na igkita katô batà ku, asta tô gó tô igbayad ku ki Raquel ébô lumayuk ka kanak.” Purisu si Lea tô iglayukan i Jacob ka dukilám. ");
INSERT INTO bgs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Igpaminág ka Manama tô dasalán i Lea. Purisu igmabáddás sikandin, asta igpamasusu ka ikalima batà mama i Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Igkagi si Lea, na mà din, “Duwán ágpulusán na igbággé ka Manama kanak su igbággé ku tô állang ku ki Jacob ébô imun sawa din.” Purisu igngadanan i Lea tô batà din ki Isacar. ");
INSERT INTO bgs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Igmabáddás puman si Lea, asta igpamasusu sikandin ka ikannám batà mama i Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Igkagi si Lea, na mà din, “Tuu madigár tô igbággé katô Manama kanak. Purisu pabantugánna basì katô duma ku, su ánnám dán tô gabatà din gamama na igpamasusu ku.” Purisu igngadanan i Lea tô batà din ki Zabulon. ");
INSERT INTO bgs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Igpamasusu pagsik si Lea ka batà bayi, asta igngadanan din tô batà ki Dina. ");
INSERT INTO bgs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Inéduwan tô Manama ki Raquel, igpaminág ka Manama tô dasalán din, asta igpabatà ka Manama sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Igmabáddás si Raquel, asta igpamasusu ka batà mama. Igkagi sikandin, na mà din, “Igkangé dán katô Manama tô kayyaan ku. ");
INSERT INTO bgs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mólà pa ka dugangan katô Áglangngagán ni batà ku mama.” Purisu igngadanan i Raquel tô batà din ki Jose. ");
INSERT INTO bgs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Na, pángnga ipamasusu si Jose, igkagi si Jacob ki Laban, na mà din, “Kakalyag ku na mulì ad tun ta igpamasusuwan kanak. ");
INSERT INTO bgs_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Papanó kad kanak, tô mga sawa ku, asta tô mga gabatà ku, su sikandan gó tô bullas katô lumu ku para áknikó. Isóddóran nu na madigár tô igpulus nu ukit katô lumu ku para áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Igkagi si Laban, na mà din, “Atin ka duwán kédu nu kanak, óddô ka pa dini. Yaka pa ágpanó, su ukit katô salamangka isóddóran ku na madigár tô igbággé katô Áglangngagán kanak tingód katô kóddô nu dini. ");
INSERT INTO bgs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Agad ándin tô kakalyag nu, tô gó é tandan ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Igkagi si Jacob, na mà din, “Isóddóran nu na madigár tô kalumu ku para áknikó. Igmarapung dán tô mga mannanap nu su sakán tô igdóppón. ");
INSERT INTO bgs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Dángngan tô ándà a pa dunggù, délák dád tô kaduwánnan nu. Asal tuu kad iduwánnan áknganni, su madigár tô igbággé katô Áglangngagán áknikó ukit katô lumu ku. Purisu áknganni, kailangan duwán pulusán katô pamilya ku ukit katô lumu ku.” ");
INSERT INTO bgs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Iginsà si Laban, na mà din, “Ándin tô tandan ku áknikó?” Igtaba si Jacob, na mà din, “Yaka ágtandan kanak. Asal ka kakalyag nu na dóppónan ku pa tô áknikó mga mannanap, kailangan numunug ka kani kagin ku áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ni álló ni, tumalappa tun ta langun mannanap nu, asta kangén ku tô langun nati ka karnero na métám asta tô langun nati ka kambing na kabang. Tô gó tô nángngà tandan nu kanak. ");
INSERT INTO bgs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tun ta dumunggù álló, atin ka sumállág ka katô mga mannanap ku, atin ka kitanán nu tô mga kambing na ánnà kabang, asta tô mga karnero na ánnà métám, kasóddóran nu na igtakó ku yan áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ignunug si Laban, na mà din, “Óó! Tuman nu tô igkagi nu.” ");
INSERT INTO bgs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Asal tô álló tô, igkangé i Laban tô langun kambing na kabang asta tô ibaláttan ka mapputì agad mama ó bayi, asta tô langun karnero na métám. Igpadóppónan din katô mga gabatà din gamama. ");
INSERT INTO bgs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Igpid i Laban tô mga mannanap tun ta madiyù tanà na ágkadunggù ka tállu álló ágpanón, asta igdóppón si Jacob katô mga mannanap i Laban na isamà. ");
INSERT INTO bgs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Na, igkangé i Jacob tô mga panga ka kayu alamo, almendras, asta platano, asta igluwitan din, asal duwán állát-állát na ándà din luwiti ébô duwán mapputì kórét. ");
INSERT INTO bgs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Igbunsud din tô mga panga madani tun ta ginámmanan ka mga mannanap ébô kitanán dan ka minám dan, su tô iginám tô mga kambing, igpatampaké dan. ");
INSERT INTO bgs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tô igpatampaké tô mga mannanap madani tun ta panga na igkórétan, kabang tô mga nati na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Igássa i Jacob tô mga bayi na mga karnero asta mga kambing, asta igpatubang din katô mga mama na mga mannanap i Laban na kabang asta métám. Purisu igmarapung tô kandin mga mannanap, asta ándà din pasábbadi tun ta mga mannanap i Laban. ");
INSERT INTO bgs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Atin ka ágpatampaké tô mga mannanap na malambù, ágbunsudán i Jacob tô mga panga na igkórétan madani tun ta ginámmanan ébô kitanán dan. ");
INSERT INTO bgs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Asal ka magasà tô mga mannanap, dì din ágbunsudán tô mga panga. Purisu si Laban tô ikatigatun katô mga mannanap na magasà, asta si Jacob tô ikatigatun katô mga malambù. ");
INSERT INTO bgs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Purisu tuu iduwánnan si Jacob. Marapung tô mga mannanap, mga állang, mga kamelyo, asta mga asno na itigatun din. ");
INSERT INTO bgs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Na, ikadinág si Jacob katô igkagi katô mga gabatà gamama i Laban, na mà dan, “Igkangé i Jacob tô langun mannanap i Ámmà, su igtigatun dán i Jacob tô taganà igtigatun katô ámmà ta.” ");
INSERT INTO bgs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ikasóddór si Jacob na iring na ándà dán ginawa i Laban kandin ka tandingán katô dakál ginawa din dángngan. ");
INSERT INTO bgs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Na, igkagi tô Áglangngagán ki Jacob, na mà din, “Ulì kad tun ta tanà na igóddóan katô ámmà nu, apù nu, asta mga gakád nu. Tabangan ku gó sikuna.” ");
INSERT INTO bgs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Purisu igpatawar i Jacob si Raquel asta si Lea tun ta lugar na igdóppónan din ka mga mannanap ébô patóngkóé dan. ");
INSERT INTO bgs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Igkagi si Jacob kandan, na mà din, “Dángngan, dakál tô ginawa katô ámmà yu kanak. Asal áknganni, ándà dán ginawa din kanak. Asal inalayunna ágdumaan katô Manama na ágpangadapán katô ámmà ku. ");
INSERT INTO bgs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Isóddóran yu na igággár-ággárra iglumu para katô ámmà yu. ");
INSERT INTO bgs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Asal iglimbunganna ikandin, su makapira din uman-umani tô tandô din tingód ka tandan din kanak. Asal ukit katô tabang ka Manama, ándà a ikandin dadatti. ");
INSERT INTO bgs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tô igtandô tô ámmà yu kanak na langun kambing na kabang tô tandan din kanak, kabang tô langun na ipamasusu. Tô igtandô puman sikandin kanak na langun kambing na kórétán tô tandan din kanak, kórétán tô langun na ipamasusu. ");
INSERT INTO bgs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Purisu igkangé katô Manama tô mga mannanap tikud tun ta ámmà yu, asta igbággé din kanak. ");
INSERT INTO bgs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Dángngan tô timpo na igpatampaké tô mga kambing, igtagénáppa. Igkita ku na kórétán asta kabang tô langun kambing na mama na igtampak. ");
INSERT INTO bgs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Róggun igtagénáppa, igkagi tô panaligan ka Manama kanak, na mà din, ‘Jacob.’ Igtaba a, ‘Kannunna!’ ");
INSERT INTO bgs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Igkagi tô panaligan, ‘Sállág ka. Kórétán asta kabang dád tô langun kambing na mama na igtampak katô mga bayi. Imun ku na marapung tô mga mannanap nu, su igkita ku tô langun madat na iglumu i Laban áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Sakán tô Manama na igpakita áknikó dángngan tun ta Betel. Igimu nu tô kasampáttan batu na igbusbusan nu ka langis, asta igpasakup ka kanak. Na, panó kad! Ulì kad tun ta igpamasusuwan áknikó.’” ");
INSERT INTO bgs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Igkagi si Raquel asta si Lea, na mà dan, “Mému áknami, su ándà dán isamà na bággén áknami ka maté tô ámmà dé. ");
INSERT INTO bgs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tun ta panámdám din, iring ké na ánnà gabatà din, su igbarigyà ké ikandin iring na állang, asta inémmát dán tô igsablag nu kandin. ");
INSERT INTO bgs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tô langun ka kaduwánnan katô ámmà dé igkangé dán katô Manama asta igbággé din dán áknita asta tun ta mga gabatà ta. Purisu agad ándin tô igkagi katô Manama áknikó, tuman nu.” ");
INSERT INTO bgs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Purisu igpasaké i Jacob tô mga gabatà din asta tô mga sawa din tun ta mga kamelyo. ");
INSERT INTO bgs_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Igpóna din tô langun mannanap din, agad tô langun na itigatun din tun ta Mesopotamia. Igpanó sikandin igsadun tun ta tanà katô ámmà din na si Isaac tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tô igpanó dan, ándà si Laban, su igsadun sikandin tun ta mga karnero din na igpasabsab ébô buruwan din. Igtakó i Raquel tô mga ágmanaman tikud tun ta balé katô ámmà din, asta igpid din. ");
INSERT INTO bgs_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Iglimbung si Jacob ki Laban, su ándà din pasóddóri tingód katô kapanó dan. ");
INSERT INTO bgs_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Igpid i Jacob tô langun katô kaduwánnan din, asta igpalaguy sikandin. Igtalipag dan katô Wayig ka Eufrates, asta igsadun dan tun ta pabunganán ka Galaad. ");
INSERT INTO bgs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tô itálluwan dan dán, igulitan si Laban na igpalaguy dán si Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Purisu igpid i Laban tô mga gakád din, asta iglupug dan si Jacob. Tô iglabé dán tô pittu álló, isabban dan sikandin tun ta pabunganán ka Galaad. ");
INSERT INTO bgs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Asal tô ándà dan pa ikasab kandin, igpakita tô Manama ki Laban ka dukilám ukit ka tagénáp, asta igkagi sikandin, na mà din, “Piyà-piyà ka gó. Yaka ágkagi ka madat ki Jacob.” ");
INSERT INTO bgs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Na, igkampo si Jacob tun ta pabunganán ka Galaad. Tô ikasab si Laban asta tô mga kadumaan din ki Jacob, igkampo dan madani. ");
INSERT INTO bgs_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Igkagi si Laban ki Jacob, na mà din, “Madat tô iglumu nu. Iglimbung ka kanak, asta igpid nu tô mga gabatà ku iring na manubù na inammát ka mangayó. ");
INSERT INTO bgs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Manan ka igpalaguy ka? Manan ka iglimbung ka kanak? Atin ka igpasóddórra ikuna, papanón ku pád sikiyu na duwán dakál dayó asta kanta na tákkássan ka dagingán katô tamburin asta alpa. ");
INSERT INTO bgs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ándà a ikuna padákki katô mga apù ku asta mga gabatà ku. Tuu madat tô iglumu nu kanak. ");
INSERT INTO bgs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Agad mému dadattan ku sikuna, asal géna dukilám igkagiyanna katô Manama na ágpangadapán katô ámmà nu na dì mému kumagiya ka madat áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Isóddóran ku na duwán kakalyag nu na mulì ka tun ta ámmà nu. Asal manan ka igtakó nu tô mga ágmanaman tikud tun ta balé ku?” ");
INSERT INTO bgs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Igtaba si Jacob, na mà din, “Ándà a pasóddór áknikó su imáddanganna agó angén nu ni mga sawa ku. ");
INSERT INTO bgs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Asal tingód katô mga ágmanaman nu, atin ka kitanán nu tô igtakó katô, matayan sikandin. Na, tumandô a tun ta tubang kani mga gakád ta, atin ka duwán kaduwánnan nu na kitanán nu dini, mému piddán nu.” Asal ándà sóddór i Jacob na si Raquel tô igtakó katô mga ágmanaman i Laban. ");
INSERT INTO bgs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Purisu igpamasak si Laban tun ta tulda i Jacob, tun ta tulda i Lea, asta tun ta tulda katô duwa állang bayi, asal ándà palang igkita din. Igahu sikandin tun ta tulda i Raquel. ");
INSERT INTO bgs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Taganà igállás i Raquel tô mga ágmanaman tun ta siyà katô kamelyo din, asta igunsad sikandin tun ta bówwó. Agad igpamasak si Laban katô langun tun dalám ta tulda, asal ándà din kitayi. ");
INSERT INTO bgs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Igkagi si Raquel katô ámmà din, na mà din, “Ámmà, yaka ágkasókó kanak, asal diya tumindág su ágdipanugánna.” Purisu igpamasak si Laban, asal ándà din kitayi tô mga ágmanaman din. ");
INSERT INTO bgs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tuu isókó si Jacob, asta igsawé din si Laban, na mà din, “Ándin tô salà ku áknikó? Ándin tô sugù nu na iglapas ku? Iglupugga ikuna iring na tulisanna. ");
INSERT INTO bgs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Igahà nu tô langun kaduwánnan ku. Pakita nu kanak ka ándin tô igtakó ku tikud tun áknikó! Atin ka duwán igkita nu, pid nu dini ta tubang ta ébô ruudan ki katô mga gakád ta! ");
INSERT INTO bgs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Iglumuwa tun áknikó ka duwa pulù (20) ámmé. Róggun igdóppónan ku tô áknikó mga mannanap, ándà palang kapákkasi tô mga karnero nu asta tô mga kambing nu. Ándà karnero nu na igkan ku. ");
INSERT INTO bgs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Atin ka duwán igmatayan ka mga mannanap ka kabánnássan, ándà ku piddi tun áknikó, asal kanak mannanap tô igbullas ku katô inaté. Atin ka duwán igtakó agad álló ó dukilám, igpabayadan nu kanak. ");
INSERT INTO bgs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mahirap tô iglumu ku, su marikitta ágkélad ka álló, asta ágkagánnawanna ka dukilám. Inalayunna ágkapuló. ");
INSERT INTO bgs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tô gó tô inókitan ku dalám ka duwa pulù (20) ámmé tingód katô kalumu ku para áknikó. Sapulù áppat (14) ámmé tô kalumu ku áknikó su tô gó tô sablag ku katô duwa gabatà nu. Ánnám ámmé tô kalumu ku áknikó su tô gó tô bayad ku kani mga mannanap. Asal ikapira nu uman-umani tô tandô nu tingód ka tandan nu kanak. ");
INSERT INTO bgs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Asal igtabanganna katô Manama na ágpangadapán katô apù ku na si Abraham asta tô ámmà ku na si Isaac. Atin ka ándà a ikandin tabangi, igpéwà a ikuna na ándà palang ágpulusán ku. Asal igkita katô Manama tô kahirapan ku asta pagud ku. Purisu igsapadan ka ikandin géna dukilám.” ");
INSERT INTO bgs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Igkagi si Laban, na mà din, “Kanak gó gabatà tô mga sawa nu, asta kanak apù tô mga gabatà dan. Kanak ni mga mannanap ni. Agad ándin tô kitanán nu dini, kanak tô langun. Asal dì mému madat tô lumun ku tun ta mga gabatà ku asta tun ta mga apù ku. ");
INSERT INTO bgs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Madigár gó ka pasaboté ki. Madigár ka imun ta tô kasampáttan batu ébô dì ta kalingawan tô kasabotan ta.” ");
INSERT INTO bgs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Purisu igkangé i Jacob tô dakál batu, asta igpatindág din ébô mému kasampáttan batu. ");
INSERT INTO bgs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Igsugù din tô mga gakád din, na mà din, “Limud yu tô mga batu.” Purisu iglimud dan tô mga batu, asta igpagluntud-luntud dan. Igkan dan langun tun ta madani. ");
INSERT INTO bgs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Igngadanan i Laban tô kasampáttan batu na Jegar Sahaduta tun ta kinagiyan ka Aramea, asta igngadanan i Jacob tô kasampáttan batu na Galeed tun ta kinagiyan ka Hebreo. ");
INSERT INTO bgs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Igkagi si Laban, na mà din, “Ni mga batu na igpaglimud, tô gó é kasampáttan batu ébô dì ta kalingawan tô tandô ta.” Purisu igngadanan tô tanà na Galeed. ");
INSERT INTO bgs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Igngadanan tô tanà na Mispa, su igkagi si Laban ki Jacob, na mà din, “Atin ka pasuwayé ki tikud kannun, ágbanté tô Áglangngagán tun ta tángngaan ta ébô dì ki pasulungé, agad padiyué ki. ");
INSERT INTO bgs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Atin ka dadattan nu tô mga gabatà ku na mga sawa nu, asta kumalyag ka katô ássa bayi na ánnà batà ku, agad dì ku kasóddóran, asal kitanán ka katô Manama, asta supakan ka ikandin. ");
INSERT INTO bgs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ni dán tô mga batu na iglimud ku tun ta tángngaan ta, asta ni dán tô batu na igpatindág ku asta inému na kasampáttan batu. ");
INSERT INTO bgs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Igtagù ta ni kannun ébô dì ta kalingawan tô tandô ta na diya gó lumapas kani mga batu ni ébô dumadatta áknikó, asta dì ka gó lumapas kani mga batu ni ébô dumadat ka kanak. ");
INSERT INTO bgs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Atin ka dì ta tumanán ni tandô ta, supakan ki katô Manama na ágpangadapán katô apù nu na si Abraham asta apù ku na si Nahor.” Igtandô si Jacob ukit katô ngadan ka Manama na ágpangadapán katô ámmà din na si Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Igmatayan i Jacob tô mannanap. Iggóbbó din asta igbággé din tun ta Manama dutun ta pabungan. Igimu din tô pan, asta igpakan din tô mga gakád din. Pángnga igkan dan, igdággà dan tun ta pabunganán. ");
INSERT INTO bgs_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Tô sállám dán, igadák si Laban katô mga apù din asta tô mga gabatà din, asta igdasal sikandin ébô madigár tô bággén ka Manama kandan. Igpanó sikandin asta igulì. ");
INSERT INTO bgs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Na, tô igpanó si Jacob, duwán mga panaligan ka Manama na igsumar kandin tun ta dalan. ");
INSERT INTO bgs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Tô igkita si Jacob kandan, igkagi sikandin, na mà din, “Ni gó tô góddóan ka Manama!” Purisu igngadanan din tô lugar na Mahanaim. ");
INSERT INTO bgs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Na, duwán mga ágsuguánnán na igpóna i Jacob ébô sumumar katô kataladi din na si Esau tun ta tanà ka Edumea. ");
INSERT INTO bgs_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Igsugù si Jacob kandan, na mà din, “Ulit yu ni kagi ku tun ta kaké ku na si Esau. ‘Sakán si Jacob na tuu ágpabbabà tun áknikó. Agad idugéya igóddô tun ta amayánnán ta na si Laban, asal mulì ad gó puman. ");
INSERT INTO bgs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Marapung dán tô mga baka, tô mga asno, tô mga karnero, tô mga kambing, asta tô mga állang na itigatun ku. Ágpasóddórra áknikó tingód katô kadunggù ku, ébô mému pô mólì tô ginawa nu kanak.’” ");
INSERT INTO bgs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tô iglónód tô mga ágsuguánnán tun ki Jacob, igkagi sikandan, na mà dan, “Igsadun kéd tun ta kataladi nu na si Esau, asta igpanó dán sikandin ébô sumumar áknikó. Áppat gatus (400) tô mga manubù na igtákkás kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Purisu tuu imáddangan si Jacob, asta itanaan sikandin. Igtángngà din tô mga manubù na igtákkás kandin, asta igtángngà din tô mga karnero, tô mga kambing, tô mga baka, asta tô mga kamelyo din, ");
INSERT INTO bgs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","su igpanámdám sikandin, na mà din, “Atin ka dadattan i Esau tô una grupo, makaluwà tô tapuri grupo.” ");
INSERT INTO bgs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Na, igdasal si Jacob, na mà din, “Áglangngagán na ágpangadapán katô apù ku na si Abraham asta tô ámmà ku na si Isaac, Áglangngagán ku, sikuna tô igkagi kanak na mulì a tun ta igpamasusuwan kanak asta tun ta mga gakád ku. Igtandô ka na tumabang ka kanak. ");
INSERT INTO bgs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ánnà a nángngà para katô kédu nu kanak, asal tuu ka ágkasarigan asta igtuman nu gó tô tandô nu kanak. Tô igtalipagga kani Wayig ka Jordan dángngan tô igsadunna tun ki Laban, tukád ku dád tô igpid ku. Asal áknganni duwán dán duwa magdakál grupo na ágpiddán ku. ");
INSERT INTO bgs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tabangiya gó ébô diya dadattan katô kaké ku na si Esau. Ágkamáddanganna agó matayan ké langun ikandin, asta mapánnas tô langun sawa ku asta mga gabatà ku. ");
INSERT INTO bgs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Yaka nu ágkalingawi tô igtandô nu na madigár tô lumun nu kanak, asta imun nu marapung tô mga rubbad ku sippang ka dì dan méyap iring na karapungan katô mga baklayan tun ta dagat.” ");
INSERT INTO bgs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Na, igdággà si Jacob dutun. Igsalin din tô mga mannanap ébô duwán bággén din ki Esau. ");
INSERT INTO bgs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Duwa gatus (200) tô mga kambing bayi, duwa pulù (20) tô mga kambing mama, duwa gatus (200) tô mga karnero bayi, duwa pulù (20) tô mga karnero mama, ");
INSERT INTO bgs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tállu pulù (30) tô mga kamelyo bayi asta tô mga nati dan, kappatan (40) tô mga baka bayi, sapulù (10) tô mga baka mama, duwa pulù (20) tô mga asno bayi, asta sapulù (10) tô mga asno mama. ");
INSERT INTO bgs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Igpagtángngà-tángngà din tô langun dan, asta duwán állang na igpadóppón din tun ta tagsábbad-sábbad grupo. Igkagiyan din tô mga állang din, na mà din, “Pid yu tô mga mannanap tun tóna, asta kailangan duwán állát tun ta tagsábbad-sábbad grupo.” ");
INSERT INTO bgs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Igsugù si Jacob katô állang na igpóna din, na mà din, “Atin ka kitanán nu tô kataladi ku na si Esau, atin ka minsà sikandin ka sadan tô amo nu asta ánda é sadunan nu, asta sadan tô tigatun kani mga mannanap na igpid nu, ");
INSERT INTO bgs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","taba ka kandin, ‘Ni gó tô mga mannanap i Jacob na tuu ágpabbabà tun áknikó. Igpapid din ni ébô bággén áknikó. Tun pa sikandin ta tapuri.’” ");
INSERT INTO bgs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Magunawa gó pagsik tô igsugù i Jacob katô ikaduwa asta ikatállu manubù, asta tun ta langun manubù na igpid katô mga mannanap. Igkagi sikandin, na mà din, “Atin ka kumita kó kandin, magunawa tô kagin yu kandin. ");
INSERT INTO bgs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kailangan kumagi kó kandin, ‘Tun pa ta tapuri si Jacob na tuu ágpabbabà tun áknikó.’” Tô gó é igsugù din kandan, su igpanámdám sikandin, “Ukit kani bággén ku kandin, makóbì a kandin. Purisu atin ka pakitaé ké, pasinsiyaan din basì tô salà na iglumu ku kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Purisu igpóna i Jacob tô mga ágbággén din ki Esau, asal igdággà pa si Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Na, tô dukilám dán, igánnó si Jacob asta igpid din tô duwa sawa din, tô duwa állang dan, asta tô sapulù sábbad (11) mga gabatà din gamama, asta igpatalipag din sikandan tun ta Wayig ka Jordan tun ta Jaboc. ");
INSERT INTO bgs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Igpatalipag din pagsik tô langun mannanap na itigatun din. ");
INSERT INTO bgs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Si Jacob dád tô ándà talipag. Na, duwán manubù na igdunggù tun ki Jacob asta igpadumogé dan sippang ka sállám. ");
INSERT INTO bgs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tô ikasóddór tô manubù na dì ágkatalu si Jacob, igawidan din tô laluwadan ka bubun i Jacob ébô kaliusan. ");
INSERT INTO bgs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Igkagi tô manubù, na mà din, “Lángngaiyad, su masig dán ágkasállám.” Asal igkagi si Jacob, na mà din, “Diya gó lumángngà áknikó. Tandô ka pa na madigár tô bággén nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Iginsà tô manubù, na mà din, “Sadan tô ngadan nu?” Igtaba si Jacob, na mà din, “Sakán si Jacob.” ");
INSERT INTO bgs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Igkagi tô manubù, na mà din, “Tikud áknganni, dì kad ngadanan ki Jacob, asal ngadanan kad ki Israel, su igpadumogé kó katô Manama asta katô mga manubù, asta igpanalu ka.” ");
INSERT INTO bgs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iginsà si Jacob, na mà din, “Ulitiya. Sadan tô ngadan nu?” Igtaba tô manubù, na mà din, “Yaka ginsà ka sadan tô ngadan ku.” Na, madigár tô igbággé din ki Jacob, asta igpanó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Igngadanan i Jacob tô lugar na Peniel, su igkagi sikandin, na mà din, “Agad igkita ku tô bónnóng katô Manama, asal ándà a gó kamaté.” ");
INSERT INTO bgs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Tô duwán dán álló, igpanó si Jacob tikud tun ta Peniel. Igténgkà sikandin su ilius tô bubun din. ");
INSERT INTO bgs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Purisu agad áknganni, dì ágkannán katô mga rubbad i Israel tô ugat ka ákkud madani tun ta laluwadan ka bubun ka mannanap na giyón dan, su tô gó é igawidan katô Manama tun ta bubun i Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Na, igkita i Jacob si Esau tun ta madiyù asta tô áppat gatus (400) mga manubù na igtákkás kandin. Igpadóppón din si Lea, si Raquel, asta tô duwa állang dan katô mga gabatà dan. ");
INSERT INTO bgs_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Igpóna din tô duwa állang asta tô mga gabatà dan, igpatalundug din si Lea asta tô mga gabatà din, asta igpatapuri din si Raquel asta si Jose. ");
INSERT INTO bgs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Iguna si Jacob tun ta langun dan, asta makapittu sikandin iglingkóód tun ta tanà sippang ka igdunggù sikandin tun ta kaké din. ");
INSERT INTO bgs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Asal igpalaguy si Esau igsumar ki Jacob, igkápkáppan din tô adi din, asta igadákkan din. Igsággó tô duwa dan. ");
INSERT INTO bgs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tô igkita si Esau katô mga gabayi asta mga gabatà, iginsà sikandin, na mà din, “Sadan ni mga kadumaan nu?” Igtaba si Jacob, na mà din, “Ni gó tô mga gabatà na igbággé katô Manama kanak ukit katô kédu din.” ");
INSERT INTO bgs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Igpadani tô duwa állang asta tô mga gabatà dan, asta iglingkóód dan tun ki Esau. ");
INSERT INTO bgs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Igpadani si Lea asta tô mga gabatà din, asta iglingkóód dan. Tun ta tapuri katô langun, igpadani si Jose asta si Raquel, asta iglingkóód dan. ");
INSERT INTO bgs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iginsà si Esau, na mà din, “Manan ka igpid nu tô marapung mga mannanap na isumaran ku géna?” Igtaba si Jacob, na mà din, “Tô gó tô gasa ku áknikó ébô mólì tô ginawa nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Asal igkagi si Esau, na mà din, “Nángngà dán tô kanak mga mannanap. Yakad ágbággé kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Igkagi si Jacob, na mà din, “Bággén ku áknikó. Atin ka duwán ginawa nu kanak, tanggap nu ni gasa ku áknikó. Tô igkita ku tô bónnóng nu, iring na igkita ku tô bónnóng ka Manama. ");
INSERT INTO bgs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tanggap nu ni gasa ku, su madigár tô tabang ka Manama kanak, asta nángngà tô kaduwánnan ku.” Tuu igpirit i Jacob si Esau. Purisu igtanggap i Esau tô gasa. ");
INSERT INTO bgs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Igkagi si Esau, na mà din, “Na, panó kid. Padángngané kid.” ");
INSERT INTO bgs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Asal igkagi si Jacob, na mà din, “Isóddóran nu na marénták pa tô mga gabatà ku, asta duwán mga nati katô mga karnero asta mga baka ku. Atin ka pasigán tô kapanó dan ka sábbad álló, maté dan gó. ");
INSERT INTO bgs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mólà pa ka muna ka áknami su lumagénut ké dád na tumalundug áknikó ébô nángngà tô panawán dé, agad tô mga mannanap asta tô mga gabatà ku, sippang ka dumunggù ké tun áknikó tun ta Edumea.” ");
INSERT INTO bgs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Igkagi si Esau, na mà din, “Madigár ka tananan ku áknikó ni mga manubù ku ébô dumuma asta mullug dan ákniyu.” Asal igkagi si Jacob, na mà din, “Yakad kanan. Nángngà dán su madigár tô ginawa nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Purisu tô álló tô, igpanó si Esau asta igulì tun ta Edumea. ");
INSERT INTO bgs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Asal igsuwé baling si Jacob tun ta Sucot, asta igpému din tô balé na góddóan dan, asta tô mga rákkó asta tô mga koral para katô mga mannanap din. Purisu igngadanan tô lugar na Sucot. ");
INSERT INTO bgs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Na, tô igulì si Jacob tikud tun ta Mesopotamia, igdunggù sikandin tun ta lunsud ka Siquem tun ta Canaan na ándà ikadadat kandin. Igóddô sikandin madani tun ta lunsud ka Siquem. ");
INSERT INTO bgs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Igbayadan din tô tanà na igóddóan din. Sábbad gatus (100) abuk ka mapputì bulawan tô bayad din tun ta mga rubbad i Hamor na ámmà i Siquem. ");
INSERT INTO bgs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Igimu i Jacob tô ággóbbówanan ka mannanap na ágbággén tun ta Manama, asta igngadanan din tô El Elohe Israel. ");
INSERT INTO bgs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Na, si Dina tô batà daraga i Jacob ki Lea. Sábbad álló, igbisita si Dina tun ta mga daraga na igóddô tun ta lunsud. ");
INSERT INTO bgs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Na, si Siquem tô batà mama katô ágpangulun na si Hamor na Hebihanon. Tô igkita i Siquem si Dina, igawidan din, asta igpamókkós din. ");
INSERT INTO bgs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Idigárran si Siquem ki Dina, asta dakál tô ginawa din kandin. Purisu madigár tô igkagi din kandin. ");
INSERT INTO bgs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Igkagi si Siquem katô ámmà din, na mà din, “Bággé nu tô sablag tingód kani bayi ébô kalyagan ku.” ");
INSERT INTO bgs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Na, igdinág si Jacob tingód katô kapamókkós ki Dina, asal su igdóppón pa tô mga gabatà din gamama ka mga mannanap din tun ta madiyù, igtagnáp sikandin sippang ka igulì dan. ");
INSERT INTO bgs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Igsadun si Hamor na ámmà i Siquem tun ki Jacob ébô patóngkóé dan. ");
INSERT INTO bgs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tô igdunggù si Hamor, igdunggù pagsik tô mga gabatà i Jacob. Tô igdinág dan na igpamókkós si Dina, iranu dan asta tuu dan isókó, su tuu madat tô iglumu i Siquem tun ta pamilya i Israel. Dì mému tô iglumu din. ");
INSERT INTO bgs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Igkagi si Hamor kandan, na mà din, “Dakál gó tô ginawa katô batà ku na si Siquem tun ta batà nu na si Dina, asta kakalyag din na kumalyag kandin. Atin ka mému ákniyu, pakalyagan yu sikandin katô batà ku. ");
INSERT INTO bgs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Madigár ka pakalyagé tô mga gabatà ta. Kumalyag ké katô mga gabatà yu daraga, asta kumalyag kó katô mga gabatà dé daraga. ");
INSERT INTO bgs_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mému móddô kó dini áknami, agad ánda tô kadigárran yu. Mému numigosyo kó, asta makatigatun kó ka tanà.” ");
INSERT INTO bgs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Igkagi si Siquem katô ámmà asta mga kataladi i Dina, na mà din, “Atin ka kéduwan kó kanak asta mággé kó kanak kani bayi, agad ándin tô pamuyuán yu, bággén ku ákniyu. ");
INSERT INTO bgs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ulitiya ikiyu ka ándin tô sablag na bággén ku, su agad ándin tô pamuyuán yu, bággén ku ákniyu ébô mému sikandin na sawa ku.” ");
INSERT INTO bgs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tô igtaba tô mga gabatà i Jacob ki Siquem asta katô ámmà din na si Hamor, iglimbung dan kandan su igpamókkós i Siquem tô tábbé dan na si Dina. ");
INSERT INTO bgs_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Igkagi sikandan, na mà dan, “Dì mému pakalyagan tô tábbé dé tun ta manubù na ándà tupuwi, su kayyaan ké. ");
INSERT INTO bgs_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Asal ka patupu tô langun yu na mga gamama iring áknami, ");
INSERT INTO bgs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","mému kumalyag kó katô mga gabatà dé daraga, asta kumalyag ké katô mga gabatà yu daraga. Móddô ké dini ákniyu, asta mému ki sábbad grupo. ");
INSERT INTO bgs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Asal ka dì kó patupu, piddán dé tô tábbé dé asta panó ké.” ");
INSERT INTO bgs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Idayawan si Hamor asta tô batà din na si Siquem, asta ignunug dan. ");
INSERT INTO bgs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ándà baring-baring tô mallaki tingód katô katuman din, su dakál tô ginawa din katô batà bayi i Jacob. Si Siquem tô tuu ágkabantug tun ta langun kataladi din. ");
INSERT INTO bgs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Igtubang si Hamor asta si Siquem katô mga ágtugállán tun ta lunsud dan, asta igkagi sikandan, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Duwán kakalyag dan na pararaké ki. Madigár ka póddóán ta sikandan dini áknita, asta numigosyo dan, su duwán pa lugar kannun. Madigár ka kumalyag ki katô mga gabatà dan daraga, asta kumalyag dan katô mga gabatà ta daraga. ");
INSERT INTO bgs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Asal atin ka móddô dan dini áknita asta mému ki sábbad grupo, duwán kailangan lumun ta. Kailangan patupu tô langun ta na mga gamama iring kandan. ");
INSERT INTO bgs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Atin ka tô gó é lumun ta, makatigatun ki katô langun mannanap dan asta langun ka kaduwánnan dan. Purisu madigár ka tumanán ta tô kakalyag dan ébô móddô dan dini áknita.” ");
INSERT INTO bgs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Na, ignunug tô langun gamama, asta igpatupu dan. ");
INSERT INTO bgs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tô itálluwan dán, róggun ágkasakitan pa tô langun dan tingód ka kapatupu dan, igsadun tô duwa gabatà i Jacob na si Simeon asta si Levi na bánnal tábbé i Dina. Igpid dan tô kampilan, asta igsulung dan tô lunsud ka Siquem. Ándà palang manubù na igatu kandan. Purisu ipánnas tô langun gamama. ");
INSERT INTO bgs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Igmatayan dan si Hamor asta tô batà din na si Siquem. Igkangé dan si Dina tikud tun ta balé i Siquem, asta igulì dan. ");
INSERT INTO bgs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Igsadun tô langun gabatà gamama i Jacob, asta igkangé dan tô kaduwánnan katô mga inaté ébô makasulì dan tingód katô kapamókkós katô tábbé dan. ");
INSERT INTO bgs_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Igpid dan tô langun karnero, mga baka, asta mga asno, agad ándin tô duwán tun ta lunsud ka Siquem asta tun ta kaligadan din. ");
INSERT INTO bgs_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Igkangé dan tô langun na duwán lagà, asta igpid dan tô langun gabayi asta mga gabatà, asta tô langun kaduwánnan tun ta dalám katô mga balé. ");
INSERT INTO bgs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tô igulì dan dán, igkagi si Jacob ki Simeon asta ki Levi, na mà din, “Igpid yu tô samuk kanak ukit kani madat iglumu yu. Miringasa dán kanak tô mga Canaanhon asta tô mga Perisihanon na góddô dini. Ándà tuu karapungan ta. Atin ka palimudé dan ébô sumulung áknita, maté ki gó langun.” ");
INSERT INTO bgs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Igtaba sikandan, na mà dan, “Asal dì mému péringán din tô tábbé dé na madat bayi.” ");
INSERT INTO bgs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Na, igkagi tô Manama ki Jacob, na mà din, “Sadun ka tun ta Betel, asta óddô ka dutun. Imu nu tô ággóbbówanan ka mga mannanap ébô mangadap ka kanak, su sakán tô Manama na igpakita áknikó dángngan tô igpalaguy ka tikud tun ki Esau na kataladi nu.” ");
INSERT INTO bgs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Purisu igkagiyan i Jacob tô pamilya din asta tô mga sakup din, na mà din, “Iwà yu tô langun ágmanaman yu, tô ágpangadapán katô mga ándà ikasóddór katô Manama. Padigus kó, asta umpak kó katô malinis ébô dì kó maripà tun ta tubang ka Manama. ");
INSERT INTO bgs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Madun kid tun ta Betel, asta imun ku tô ággóbbówanan katô mga mannanap ébô mangadappa katô Manama. Tô idungguanna ka kahirapan dángngan, igtabanganna ikandin, asta inalayunna ágtákkássan agad ánda tô igsadunan ku.” ");
INSERT INTO bgs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Purisu igbággé dan ki Jacob tô langun ágmanaman dan apil tô mga igarites dan. Iglábbáng din tô langun tun ta siyung katô ulayan tun ta lunsud ka Siquem. ");
INSERT INTO bgs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tô igpanó si Jacob asta tô pamilya din, ándà manubù na iglupug kandan, su tingód katô Manama, tuu imáddangan tô langun manubù na igóddô tun ta mga lunsud na madani. ");
INSERT INTO bgs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Igsadun si Jacob tun ta Luz (na ássa ngadan din Betel) tun ta Canaan, asta langun manubù na igduma kandin. ");
INSERT INTO bgs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Igimu din tô ággóbbówanan ka mga mannanap, asta igngadanan din tô lugar na “El-Betel,” su igpakita tô Manama kandin tô igpalaguy sikandin dángngan tikud tun ta kataladi din. ");
INSERT INTO bgs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Inaté dutun si Debora na igdóppón ki Rebecca tikud pô tun ta kapamasusu kandin, asta iglábbáng tô lawa din tun ta siyung ka ulayan madani tun ta lunsud ka Betel. Purisu igngadanan tô lugar na Allon-bacuth. ");
INSERT INTO bgs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tô igulì si Jacob tikud tun ta Mesopotamia, igpakita puman tô Manama kandin, asta igtandô sikandin na madigár tô bággén din kandin. ");
INSERT INTO bgs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Igkagi tô Manama, na mà din, “Ngadanan ka ki Jacob, asal tikud ni, dì ka ngadanan ki Jacob, su ngadanan kad ki Israel.” Purisu igngadanan katô Manama sikandin ki Israel. ");
INSERT INTO bgs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Igkagi tô Manama, na mà din, “Sakán tô tuu matulus Manama. Batà kad ka marapung ébô duwán mga rubbad nu. Imun ku na marapung grupo tô mga rubbad nu, asta duwán tun kandan na imun na mga harì. ");
INSERT INTO bgs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tô kaluwagan kani tanà na igbággé ku ki Abraham asta ki Isaac, tô gó é bággén ku áknikó, asta bággén ku tun ta mga rubbad nu tun ta tapuri álló.” ");
INSERT INTO bgs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Pángnga igkagi tô Manama, igiwà sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Tun ta lugar na igtóngkóan katô Manama kandin, igpatindág i Jacob tô batu ébô imun din na kasampáttan batu. Igbusbusan din tô batu ka bino asta langis ka olibo, su igimu din na ágpangadapanan tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Tô lugar na igtóngkóan katô Manama kandin, tô gó tô igngadanan din na Betel. ");
INSERT INTO bgs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Na, igpanó si Jacob asta tô pamilya din tikud tun ta Betel. Tô ándà dan pa dunggù tun ta Efrata, igdunggù tô álló na mamasusu si Raquel, asta tuu ihirapan sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tô ágkahirapan sikandin, igkagi tô mabaliyan kandin, na mà din, “Yaka ágkamáddangan, su mama tô igpamasusu nu.” ");
INSERT INTO bgs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ibugtus tô ginawa din asta inaté sikandin. Tô ándà pa sikandin kamaté, igngadanan din tô batà din ki Benoni. Asal igngadanan i Jacob tô batà ki Benjamin. ");
INSERT INTO bgs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tô inaté si Raquel, iglábbáng dan tô lawa din madani tun ta dalan na gukitan tun ta lunsud ka Efrata. (Tô lunsud ka Efrata, tô gó é igngadanan Betlehem áknganni.) ");
INSERT INTO bgs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Igpatindág i Jacob tô dakál batu tun ta lábbáng din ébô duwán kasampáttan batu, asta tun ta lábbáng din ni sippang áknganni. ");
INSERT INTO bgs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Igpanó si Jacob asta tô pamilya din, asta igóddô dan tun ta baluy katô turi ka Eder. ");
INSERT INTO bgs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Róggun igóddô si Jacob tun ta Eder, iglayukan i Ruben tô sábbad sawa katô ámmà din na si Bilha, asta igdinág si Jacob tingód katô iglumu din. Sapulù duwa (12) tô mga gabatà gamama i Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Tô mga gabatà din gamama na ipamasusu ki Lea, tô gó si Ruben na tambang kaké batà i Jacob, si Simeon, si Levi, si Juda, si Isacar, asta si Zabulon. ");
INSERT INTO bgs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Tô mga gabatà gamama i Jacob na ipamasusu ki Raquel, tô gó si Jose asta si Benjamin. ");
INSERT INTO bgs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Tô mga gabatà din gamama na ipamasusu katô állang i Raquel na si Bilha, tô gó si Dan asta si Neftali. ");
INSERT INTO bgs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Tô mga gabatà gamama i Jacob na ipamasusu katô állang i Lea na si Zilfa, tô gó si Gad asta si Aser. Tô gó é mga gabatà gamama i Jacob na igpamasusu tun ta Mesopotamia. ");
INSERT INTO bgs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Na, igulì si Jacob tun ta ámmà din na si Isaac tun ta Mamre madani tun ta Hebron na taganà igóddóan i Abraham asta i Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Igdunggù ka sábbad gatus kawaluwan (180) tô idad i Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Tô inaté sikandin, tugál dán sikandin. Ibugtus tô ginawa din, asta ikatalundug sikandin katô mga kamónaan din na inaté. Tô lawa din iglábbáng katô mga gabatà din na si Esau asta si Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ni gó tô tingód katô mga rubbad i Esau na ássa ngadan din si Edom. ");
INSERT INTO bgs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Igkalyag si Esau ka tállu gabayi na Canaanhon na si Ada na batà i Elon na Hetihanon, si Oholibama na batà i Anas asta apù i Sibeon na Hebihanon, ");
INSERT INTO bgs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","asta si Basimat na batà i Ismael asta tábbé i Neabiot. ");
INSERT INTO bgs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Si Elifas tô batà i Esau ipamasusu ki Ada. Si Reuel tô batà din igpamasusu tun ki Basimat. ");
INSERT INTO bgs_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Duwán mga gabatà din na ipamasusu ki Oholibama na si Jeus, si Jalam, asta si Coras. Tô gó é mga gabatà i Esau na igpamasusu tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Igpid i Esau tô langun sawa din, mga gabatà din, asta mga sakup din, asta igpid dan tô langun mannanap din asta tô langun ka kaduwánnan din na ikangé din tun ta Canaan. Igpanó dan tikud tun ta kataladi din na si Jacob, asta igalin dan tun ta sábbad lugar na madiyù. ");
INSERT INTO bgs_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Igalin si Esau su atin ka pasábbadé dan, ánnà nángngà tô tanà na igkampowan dan ébô pasabsaban katô marapung mga mannanap dan. ");
INSERT INTO bgs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Purisu igóddô si Esau tun ta pabungan tun ta Edumea. ");
INSERT INTO bgs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ni gó tô mga rubbad i Esau na kamónaan katô mga manubù na igóddô tun ta pabunganán ka Edumea. ");
INSERT INTO bgs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Duwán batà din mama na si Elifas na ipamasusu ki Ada, asta si Reuel na ipamasusu ki Basimat. ");
INSERT INTO bgs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Tô mga gabatà gamama i Elifas, tô gó si Teman, si Omar, si Sefo, si Gatam, asta si Kenas. ");
INSERT INTO bgs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Duwán duma sawa i Elifas na si Timna, asta igpamasusu sikandin ki Amalec. Tô sawa i Esau na si Ada tô apù bayi katô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Tô mga gabatà gamama i Reuel, tô gó si Nahat, si Seras, si Samas, asta si Misas. Tô sawa i Esau na si Basimat tô apù bayi katô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Tô mga gabatà gamama i Esau na ipamasusu ki Oholibama na batà i Anas asta apù i Sibeon, tô gó si Jeus, si Jalam, asta si Coras. ");
INSERT INTO bgs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ni gó tô ngadan katô mga rubbad i Esau na inému mga ágpangulun. Tô mga gabatà i Elifas na tambang kaké batà i Esau inému mga ágpangulun, tô gó si Teman, si Omar, si Sefo, si Kenas, ");
INSERT INTO bgs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","si Coras, si Gatam, asta si Amalec. Tô gó é mga gabatà i Elifas na inému na mga ágpangulun tun ta Edumea, asta si Ada tô apù bayi katô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Tô mga gabatà i Reuel na batà i Esau na inému mga ágpangulun, tô gó si Nahat, si Seras, si Samas, asta si Misas. Tô gó é mga gabatà i Reuel na inému mga ágpangulun tun ta Edumea, asta si Basimat tô apù bayi katô langun dan. ");
INSERT INTO bgs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Tô mga gabatà i Esau na ipamasusu ki Oholibama na inému mga ágpangulun, tô gó si Jeus, si Jalam, asta si Coras. Tô gó é mga gabatà katô sawa i Esau na si Oholibama na batà i Anas na inému mga ágpangulun. ");
INSERT INTO bgs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Tô gó é mga rubbad i Esau na ássa ngadan din si Edom na inému mga ágpangulun. ");
INSERT INTO bgs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ni gó tô mga ngadan katô mga gabatà gamama i Seir na Horihanon, asta igóddô dan tun ta Edumea. Si Lotan, si Sobal, si Sibeon, si Anas, ");
INSERT INTO bgs_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","si Dison, si Eser, asta si Disan. Tô mga gabatà i Seir, tô gó é mga ágpangulun katô mga Horihanon na igóddô tun ta Edumea. ");
INSERT INTO bgs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Tô mga gabatà gamama i Lotan, tô gó si Hori asta si Heman. Si Timna tô tábbé i Lotan. ");
INSERT INTO bgs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Tô mga gabatà gamama i Sobal, tô gó si Alban, si Manahat, si Ebal, si Sefo, asta si Onam. ");
INSERT INTO bgs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Tô mga gabatà gamama i Sibeon, tô gó si Aias asta si Anas. Si Anas tô igkita katô ménit sánnáp tun ta disyerto tô igpasabsab din tô mga asno katô ámmà din. ");
INSERT INTO bgs_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Tô mga gabatà i Anas, tô gó é mama na si Dison, asta bayi na si Oholibama. ");
INSERT INTO bgs_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Tô mga gabatà gamama i Dison, tô gó si Hemdan, si Esban, si Etran, asta si Seran. ");
INSERT INTO bgs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Tô mga gabatà gamama i Eser, tô gó si Bilhan, si Saaban, asta si Acan. ");
INSERT INTO bgs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tô mga gabatà gamama i Disan, tô gó si Os asta si Aran. ");
INSERT INTO bgs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Tô mga ágpangulun katô mga Horihanon, tô gó si Lotan, si Sobal, si Sibeon, si Anas, ");
INSERT INTO bgs_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","si Dison, si Eser, asta si Disan. Tô gó é mga ágpangulun katô tagsábbad-sábbad grupo katô mga Horihanon na igóddô tun ta Seir. ");
INSERT INTO bgs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Ni gó tô mga ngadan katô harì na igpabullas-bullasé tô pagpangulu dan tun ta Edumea tô ándà pa harì na igpangulu katô mga rubbad i Israel. Si Belas na batà i Beor na taga Dinhaba. Si Jobab na batà i Seras na taga Bosra. Si Husan na taga Teman. Si Hadad na batà i Bedad na taga Abit. (Si Bedad tô ikatalu katô mga Midianhon tun ta tanà ka Moab.) Si Samla na taga Masreca. Si Saul na taga Rehobot tun ta Wayig ka Eufrates. Si Baal Hanan na batà i Acbor. Si Hadad na taga Pau. (Tô sawa din si Mehetabel na batà bayi i Matred asta apù i Mesahab.) ");
INSERT INTO bgs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ni gó tô mga ngadan katô mga rubbad i Esau na inému mga ágpangulun katô tagsábbad-sábbad grupo dan asta mga lunsud dan. Si Timna, si Albas, si Jetet, ");
INSERT INTO bgs_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","si Oholibama, si Elas, si Pinon, ");
INSERT INTO bgs_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","si Kenas, si Teman, si Mibsar, ");
INSERT INTO bgs_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","si Magdiel, asta si Iram. Tô gó é mga ágpangulun katô tagsábbad-sábbad lunsud tun ta Edumea. Si Edom (na ássa ngadan din si Esau) tô kamónaan katô langun manubù na ágngadanan na Edom. ");
INSERT INTO bgs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Igóddô si Jacob tun ta Canaan na igóddóan katô ámmà din. ");
INSERT INTO bgs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ni gó tô inému katô mga gabatà i Jacob. Na, tô sapulù pittu dán tô idad i Jose, igtabang sikandin katô mga kataladi din kaké na ágdóppón ka mga mannanap katô ámmà dan na si Jacob. Tô mga kataladi i Jose, tô gó tô mga gabatà gamama katô duma mga sawa katô ámmà din na si Bilha asta si Zilfa. Madat tô áglumun katô mga kataladi i Jose. Purisu igsadun si Jose tun ta ámmà din, asta igulit din kandin tô tingód kandan. ");
INSERT INTO bgs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Agad ágginawa si Jacob katô langun gabatà din, asal tuu pa dakál tô ginawa din ki Jose, su tugál dán si Jacob katô kapamasusu ki Jose. Purisu igpatábbir din tô mallayat umpak na madigár, asta igbággé din ki Jose. ");
INSERT INTO bgs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tô igkita tô mga kataladi i Jose na sikandin tô tuu pa ágginawaan katô ámmà dan, iringasa dan ki Jose, asta ándà palang madigár kagi dan kandin. ");
INSERT INTO bgs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Na, igtagénáp si Jose. Tô igulit din tô tagénáp tun ta mga kataladi din, tuu dan pa iringasa. ");
INSERT INTO bgs_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Igkagi si Jose, na mà din, “Paminág kó tingód katô tagénáp ku. ");
INSERT INTO bgs_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Igkáttu ki ka trigo tun ta kinamát, asta igbagkás ki katô kináttuwan ta. Ikatindág tô kanak binagkássan na iglibutan katô ákniyu mga binagkássan, asta iglangkáb tô ákniyu mga binagkássan tun ta kanak binagkássan.” ");
INSERT INTO bgs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Igkagi tô mga kataladi din, na mà dan, “Kéman nu ka imun ka harì dé! Kéman nu ka mangulu ka áknami!” Purisu igtuu pa tô ringasa dan kandin tingód katô tagénáp na igulit din kandan. ");
INSERT INTO bgs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Igtagénáp puman si Jose, asta igulit din tun ta mga kataladi din, na mà din, “Igtagénáppad puman, asta igkita ku tô álló, tô bulan, asta tô sapulù sábbad karani na iglangkáb dadan tun ta paa ku.” ");
INSERT INTO bgs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tô igulit si Jose katô ámmà din asta katô mga kataladi din, igsawé tô ámmà din kandin, na mà din, “Ándin man tô kóbadan katô tagénáp nu? Lumangkáb ké tun áknikó, agad sakán, tô innà nu, asta tô mga kataladi nu?” ");
INSERT INTO bgs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Isabuan tô mga kataladi din, asal inalayun igpanámdám tô ámmà din tingód katô kóbadan katô tagénáp. ");
INSERT INTO bgs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Na, sábbad álló, igpid tô mga kataladi i Jose ka mga mannanap katô ámmà dan tun ta Sikem ébô pasabsabán. ");
INSERT INTO bgs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Igkagi si Jacob tun ki Jose, na mà din, “Tô mga kataladi nu igsadun tun ta Sikem ébô pasabsab dan katô mga mannanap. Taganà kad, su palupugán ku sikuna tun kandan.” Igkagi si Jose, na mà din, “Ikataganà ad.” ");
INSERT INTO bgs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Igkagi tô ámmà din, na mà din, “Panó kad, asta sállág nu sikandan asta tô mga mannanap na ágdóppónan dan. Atin ka mapángnga, ulì ka dini ébô makasóddórra tingód kandan ka madigár.” Purisu igbánnal si Jose katô ámmà din, asta igpanó sikandin tikud tun ta Kapattadan ka Hebron. Tô igdunggù dán si Jose tun ta Sikem, ");
INSERT INTO bgs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","igpanó-panó sikandin ébô mamasak katô mga kataladi din. Duwán manubù na igkita kandin, asta iginsà ka ándin tô ágpamasakán din. ");
INSERT INTO bgs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Igtaba si Jose, na mà din, “Ágpamasakka katô mga kataladi ku. Ulitiya ka ánda é ágpasabsaban dan ka mga mannanap.” ");
INSERT INTO bgs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Igkagi tô manubù, na mà din, “Igpanó dan dán, asta igkagi dan na madun dan tun ta Dotan.” Purisu igtalundug si Jose kandan, asta igkita din tun ta Dotan. ");
INSERT INTO bgs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tô madiyù pô si Jose, igkilala dán katô mga kataladi din. Tô ándà pa dunggù tun kandan, igplano dan na matayan sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Igpatóngkóé sikandan, na mà dan, “Igsadun dán dini tô inalayun ágtagénáp. ");
INSERT INTO bgs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bé kód. Matayan ta sikandin, asta dabuán ta tun ta madalám balun. Kumagi ki na igmatayan ka magani mannanap ka kabánnássan. Na, ahaán ta ka matuman tô mga tagénáp din.” ");
INSERT INTO bgs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Asal tô igdinág i Ruben tô lumun dan, igtabangan din si Jose ukit kani kagi din, na mà din, “Madigár ka dì ta matayan. ");
INSERT INTO bgs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Yakó yu ágmatayi sikandin, asal nángngà ka dabuán ta dád tun ta madalám balun kannun ta disyerto. Tô gó tô maté sikandin asal ánnà ukit ka bállad ta.” Tô gó é igkagi i Ruben su kakalyag din na kangén din si Jose ébô ulián din tun ta ámmà dan. ");
INSERT INTO bgs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Na, tô igdunggù dán si Jose tun kandan, iglusut dan tô mallayat umpak din. ");
INSERT INTO bgs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Igpid dan sikandin tun ta madalám balun na itittian, asta igdabù dan dutun. ");
INSERT INTO bgs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Na, róggun igkan tô mga kataladi din, igkita dan tô mga Midianhon na rubbad i Ismael asta tô mga kamelyo na gukit tikud tun ta Galaad. Duwán igruran katô mga kamelyo na mga anag asta bawì na mammut na ágpiddán dan tun ta banuwa ka Ehipto ébô barigyaán. ");
INSERT INTO bgs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Purisu igkagi si Juda tun ta mga kataladi din, na mà din, “Atin ka matayan ta tô adi ta, asta bulunán ta, ándà pulusán ta. ");
INSERT INTO bgs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Asal madigár pa ka barigyaán ta sikandin tun ta mga rubbad i Ismael. Dì mému matayan ta, su kataladi ta sikandin tun ta ámmà ta.” Purisu ignunug tô mga kataladi din. ");
INSERT INTO bgs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tô ikadunggù dán tô mga Midianhon tun kandan, igkangé dan si Jose tikud tun ta balun, asta igbarigyà dan sikandin. Duwa pulù (20) abuk na mapputì bulawan tô bayad katô mga rubbad i Ismael kandin, asta igpid dan si Jose tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Na, tô iglónód si Ruben tun ta balun, igkita din na ándà dán taddô si Jose. Purisu igbissé din tô umpak din tingód ka ranu din. ");
INSERT INTO bgs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Igsadun si Ruben tun ta mga kataladi din, asta igkagi sikandin, na mà din, “Pamánnun ta? Su ándà dán taddô si Jose.” ");
INSERT INTO bgs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Purisu igiyó dan ka kambing, asta igarám dan tun ta dipanug tô mallayat umpak i Jose. ");
INSERT INTO bgs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Na, igpid dan tô umpak din tun ta ámmà dan, asta igkagi dan, na mà dan, “Ni gó tô ikita dé. Sállág nu ni ébô kasóddóran nu ka umpak katô batà nu.” ");
INSERT INTO bgs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Igkilala i Jacob na tô gó tô umpak i Jose, asta igkagi sikandin, na mà din, “Óó, kandin gó ni. Igmatayan basì ka magani mannanap ka kabánnássan, asta igkan tô lawa din.” ");
INSERT INTO bgs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Purisu igbissé i Jacob tô umpak din, asta igumpak sikandin katô óggét na gimun sako tingód ka ranu din. Idugé sikandin igranu tingód ka kamatayan katô batà din. ");
INSERT INTO bgs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ilimud tô langun gabatà din ébô dì maranu si Jacob, asal igéllé sikandin, na mà din, “Inalayunna ágranu tingód katô kamatayan katô batà ku sippang ka kumita a kandin tun ta góddóan ka mga manubù na inaté.” Purisu inalayun ágsággó si Jacob tingód katô batà din na si Jose. ");
INSERT INTO bgs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Asal si Jose dutun dán ta Ehipto, su igpid katô mga Midianhon, asta igbarigyà dan sikandin. Igbálli i Potifar na sábbad opisyales katô harì ka Ehipto, su si Potifar tô kapitan katô mga sundalo din. ");
INSERT INTO bgs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na, duwán álló na igtanan si Juda katô mga kataladi din, asta igóddô sikandin madani tun ki Hiras na taga Adulam. ");
INSERT INTO bgs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Duwán bayi na igkita i Juda na Canaanhon na batà i Suas, asta igkalyagan i Juda sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Igmabáddás tô sawa i Juda, duwán batà mama na ipamasusu, asta igngadanan i Juda ki Er. ");
INSERT INTO bgs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Igmabáddás puman tô sawa din, duwán batà mama na ipamasusu, asta igngadanan katô innà din ki Onan. ");
INSERT INTO bgs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Duwán puman batà mama na ipamasusu, asta igngadanan katô innà din ki Selas. Dutun dan ta Sesib tô kapamasusu ki Selas. ");
INSERT INTO bgs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Na, tô igdakál dán tô tambang kaké batà i Juda na si Er, igpakalyag din katô daraga na si Tamar. ");
INSERT INTO bgs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Madat tô áglumun i Er, asta dì ágkadayawan tô Áglangngagán tingód kandin. Purisu igmatayan katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Na, igkagi si Juda tun ki Onan, na mà din, “Kailangan lumayuk ka katô ipag nu na balu ébô matuman tô ágkémun ta tingód ka kataladi katô mama na inaté na ándà pa batà din, ébô mému batà katô inaté.” ");
INSERT INTO bgs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Asal isóddóran i Onan na tô batà na pamasusun katô ipag din dì mému na kandin batà, su imun yan batà katô kaké din na inaté. Purisu atin áglayuk sikandin katô ipag din na balu, inalayun din ágpaluwaán tô bánnì din ébô ándà rubbad katô kaké din na inaté. ");
INSERT INTO bgs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Asal dì ágkadayawan tô Áglangngagán tingód katô iglumu i Onan. Purisu igmatayan pagsik ka Manama sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Na, igkagi si Juda tun ta ikóddô kandin na si Tamar, na mà din, “Ulì kad, asta óddô ka tun ta balé katô ámmà nu róggun ándà pa duma nu sippang ka dumakál tô adi batà ku na si Selas.” Tô gó é igkagi i Juda, su imáddangan sikandin agó maté si Selas iring katô mga kataladi din kaké. Purisu igulì si Tamar tun ta balé katô ámmà din. ");
INSERT INTO bgs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Na, tô idugé dán, inaté tô sawa i Juda na batà bayi i Suas. Pángnga katô mga álló ka karanu i Juda, igsadun sikandin tun ta lunsud ka Timna su paburuwan din tô mga karnero. Igpatákkássé si Juda asta tô rarak din na si Hiras na taga Adulam. ");
INSERT INTO bgs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Na, igulitan si Tamar na igsadun tô ugang din tun ta Timna ébô paburuwan tô mga karnero. ");
INSERT INTO bgs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Purisu iglusut din tô umpak na gumpakán ka bayi balu, asta igumpak sikandin ka sábbad klasi. Igtambunan din tô báttuk din ébô dì sikandin kilalan. Igsadun sikandin tun ta dalan madani tun ta lunsud ka Enaim, asta igunsad sikandin tun ta ligad ka dalan, su tô gó é gukitanan ka mga manubù na ágsadun tun ta Timna. Agad igdakál dán si Selas, asal ándà dan pa pagkalyagi. ");
INSERT INTO bgs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Na, tô igkita si Juda ki Tamar, kéman din ka madat bayi, su igtambunan i Tamar tô báttuk din. ");
INSERT INTO bgs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ándà din kilalayi tô ikóddô kandin. Purisu igpadani si Juda tun kandin, asta igkagi sikandin, na mà din, “Atin ka mému, lumayukka áknikó.” Iginsà si Tamar, na mà din, “Atin ka lumayuk ka kanak, ándin tô bayad nu?” ");
INSERT INTO bgs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Igtaba si Juda, na mà din, “Papiddán ku áknikó tô nati ka kambing tikud tun ta mga mannanap ku.” Igkagi si Tamar, na mà din, “Duwán tananan nu kanak sippang ka papiddán nu tô kambing?” ");
INSERT INTO bgs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Iginsà si Juda, na mà din, “Ándin tô tananan ku áknikó?” Igtaba si Tamar, na mà din, “Tô paningsing nu na silyo apil tô tali din, asta tô tukád nu.” Purisu tô gó é igbággé i Juda ki Tamar. Igpalayuké dan asta igmabáddás si Tamar. ");
INSERT INTO bgs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Igulì si Tamar, asta igiwà din tô pagtambun din ka báttuk, asta igumpak puman sikandin ka umpak ka balu. ");
INSERT INTO bgs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Na, igsugù i Juda tô rarak din na si Hiras ébô piddán tô kambing tun ta bayi, asta kangén din tô igtananan din kandin. Asal ándà din kitayi tô bayi. ");
INSERT INTO bgs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Iginsà si Hiras katô mga manubù na igóddô tun ta Enaim, na mà din, “Ánda tô madat bayi na igunsad géna tun ta ligad ka dalan?” Igtaba sikandan, na mà dan, “Ándà palang madat bayi dini.” ");
INSERT INTO bgs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Purisu iglónód si Hiras tun ki Juda, asta igkagi sikandin, na mà din, “Ándà ku kitayi tô bayi. Igkagiyanna katô mga manubù dutun na ándà palang madat bayi dutun.” ");
INSERT INTO bgs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Igkagi si Juda, na mà din, “Tógón din. Kandin dán tô igtananan ku ébô dì kid kayyaan. Bággayan ku pád sikandin ka kambing, asal ándà nu sikandin kitayi.” ");
INSERT INTO bgs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Na, pángnga katô tállu bulan, igulitan si Juda, “Iring na madat bayi tô ikóddô áknikó na si Tamar, su igmabáddás dán sikandin.” Purisu igkagi si Juda, na mà din, “Pid yu sikandin, asta góbbó yu ébô maté!” ");
INSERT INTO bgs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tô igkangé dan si Tamar, duwán manubù na igpapid din ébô kumagi katô ugang din, na mà din, “Igmabáddássa ukit katô tigatun kani paningsing na silyo apil tô tali din, asta kani tukád. Ikasóddór ka basì ka sadan tô tigatun kani.” ");
INSERT INTO bgs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Igkilala i Juda, asta igkagi sikandin, na mà din, “Tuu madat tô iglumu ku tandingán katô iglumu din, su ándà ku sikandin pakalyagi katô batà ku na si Selas.” Ándà puman layuk si Juda ki Tamar. ");
INSERT INTO bgs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Na, tô igdunggù tô álló ka kapamasusu i Tamar, isóddóran din na dáppi tô pamasusun din. ");
INSERT INTO bgs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Róggun katô kapamasusu din, igluwà tô bállad katô sábbad batà. Igbagkássan katô taraawat tô bállad din ka sinulid na tuu mallutù, asta igkagi sikandin, na mà din, “Ni gó tô una iglássut!” ");
INSERT INTO bgs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Asal igpalónód katô batà tô bállad din tun dalám, asta tô dáppi din baling tô una iglássut. Purisu igkagi tô taraawat tun ta batà, na mà din, “Magani ka iglássut!” Purisu igngadanan sikandin ki Fares. ");
INSERT INTO bgs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ipamasusu pagsik tô dáppi din na igbagkássan tô bállad din ka sinulid na tuu mallutù. Igngadanan sikandin ki Seras. ");
INSERT INTO bgs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Na, si Jose igpid katô mga rubbad i Ismael tun ta Ehipto. Igbarigyà dan sikandin tun ki Potifar. Si Potifar tô sábbad opisyales katô harì ka Ehipto, asta sikandin tô kapitan ka mga sundalo katô harì. ");
INSERT INTO bgs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Igtabangan katô Áglangngagán si Jose. Purisu madigár tô langun na áglumun din. Igóddô si Jose tun ta balé katô amo din na taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Igkita i Potifar na igtabangan katô Áglangngagán si Jose, asta tingód katô tabang katô Áglangngagán, madigár tô langun na áglumun din. ");
INSERT INTO bgs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Idayawan si Potifar tingód ki Jose na ágsuguánnán din. Purisu igimu din si Jose na tarapid katô langun manubù tun ta balé din asta langun katô kaduwánnan din. ");
INSERT INTO bgs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Purisu tingód ki Jose, igtabangan katô Áglangngagán si Potifar, asta dakál tô igpulus din, agad tun ta balé din asta tun ta mga kinamát din. ");
INSERT INTO bgs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Igsarig i Potifar tô langun katô kaduwánnan din ki Jose, su róggun igpid si Jose, ándà ássa ágpanámdámmán i Potifar, kannà tô dád ágkakan din. Na, madigár tô bónnóng i Jose, asta mabákkár tô lawa din. ");
INSERT INTO bgs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Duwán álló na idigárran tô sawa i Potifar ki Jose, asta igkagi sikandin, na mà din, “Layuk ka kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Asal igéllé si Jose, asta igtaba sikandin, na mà din, “Ándà dán ássa ágpanámdámmán katô amo ku, su sakán é ágsarigan din. Igsarig din kanak tô langun katô kaduwánnan din. ");
INSERT INTO bgs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Magunawa tô kallayat ku katô kallayat din dini ta balé din. Igsarig din gó tô langun kanak, asal sikuna dád na sawa din tô ándà din sarigi kanak. Purisu dì mému lumumuwa ka madat iring katô kakalyag nu. Dì mému lumumuwa katô salà tun ta saruwan ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na, kada álló ginggat sikandin ki Jose ébô lumayuk kandin, asal ándà paminág si Jose katô kagi din. ");
INSERT INTO bgs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Na, sábbad álló, igahu si Jose tun ta balé, su duwán lumun din. Ándà ássa ágsuguánnán tun dalám ka balé. ");
INSERT INTO bgs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Purisu igawidan katô bayi tô umpak i Jose, asta igkagi sikandin, na mà din, “Layuk ka kanak.” Igsékót si Jose igluwà tikud tun ta balé, asta igpalaguy sikandin, asal itananan din tô umpak na igawidan katô bayi. ");
INSERT INTO bgs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Tô igkita katô sawa i Potifar na itananan i Jose tô umpak din asta igpalaguy sikandin tikud tun ta balé, ");
INSERT INTO bgs_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","igtawar din tô ássa mga ágsuguánnán, asta igkagi sikandin, na mà din, “Na, igpid katô duma ku dini tô Hebreo ébô mággé ka kayyà áknita. Igahu géna sikandin tun ta kuwarto ku ébô mamókkós pád kanak, asal igpagayissa. ");
INSERT INTO bgs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tô igpagayissa, itananan din tô umpak din dini kanak, igluwà sikandin tikud tun ta balé, asta igpalaguy.” ");
INSERT INTO bgs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Na, igtagù katô bayi tô umpak i Jose sippang ka igulì tô duma din. ");
INSERT INTO bgs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tô igulì dán si Potifar, magunawa tô igulit katô bayi, na mà din, “Tô Hebreo állang na igpid nu dini igahu géna kannun ta kuwarto ku ébô mamókkós pád kanak. ");
INSERT INTO bgs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Asal tô igpagayissa, itananan din tô umpak din dini kanak, igluwà sikandin tikud tun ta balé, asta igpalaguy.” ");
INSERT INTO bgs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Na, tô igdinág tô amo i Jose katô igulit katô sawa din na madat tô iglumu i Jose, isókó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Igpammát din si Jose, asta igpapriso din tun ta prisowan ka mga manubù na ágsupakan ka harì ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Asal igtabangan katô Áglangngagán si Jose, asta inalayun ágginawa tô Áglangngagán kandin. Idayawan tô taradóppón katô prisowan tingód ki Jose, ");
INSERT INTO bgs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","asta igimu din si Jose na tarapid katô langun manubù na igpriso. Si Jose tô ágsugù ka ándin tô áglumun tun dalám ka prisowan. ");
INSERT INTO bgs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ándà ássa ágpanámdámmán katô taradóppón ka prisowan tingód katô áglumun i Jose, su igtabangan katô Áglangngagán si Jose. Purisu madigár tô langun katô áglumun din. ");
INSERT INTO bgs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Na, duwán tarapid ka bino para katô harì ka Ehipto, asta duwán taraimu ka pan para katô harì. Duwán sábbad álló iglumu dan ka madat katô harì. ");
INSERT INTO bgs_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Isókó tô harì kandan. ");
INSERT INTO bgs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Purisu igpapriso din sikandan tun ta balé i Potifar na kapitan ka mga sundalo katô harì. Tô gó é igprisowan ki Jose. ");
INSERT INTO bgs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Igimu katô kapitan si Jose na tarabanté katô duwa manubù, asta idugé dan igpriso. ");
INSERT INTO bgs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Duwán sábbad dukilám na igtagénáp tô tarapid ka bino asta tô taraimu ka pan. Ánnà magunawa tô tagénáp dan, asta ánnà magunawa tô kóbadan katô tagénáp dan. ");
INSERT INTO bgs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tô sállám dán, igsadun si Jose tun kandan, asta igkita din na ágkasasó dan. ");
INSERT INTO bgs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Purisu iginsà si Jose, na mà din, “Manan ka ágkasasó kó?” ");
INSERT INTO bgs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Igtaba sikandan, na mà dan, “Igtagénáp ké, asta ándà manubù na makólit áknami ka ándin tô kóbadan.” Igkagi si Jose, na mà din, “Manama tô ágbággé ka kakatigan tun ta manubù ébô makólit katô kóbadan ka tagénáp. Ulit yu kanak tô tagénáp yu.” ");
INSERT INTO bgs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Purisu igulit tô tarapid ka bino tingód katô tagénáp din, na mà din, “Tô igtagénáppa, igkita ku tô butbut ka paras na ");
INSERT INTO bgs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","duwán tállu panga. Igdaun, igsábbung, igbuuy, asta ilutuan tô buuy. ");
INSERT INTO bgs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Igawidda katô kopa katô harì. Purisu igudù ku tô buuy ka paras, igkámmás ku tun ta kopa, asta igpid ku tun ta harì.” ");
INSERT INTO bgs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Igkagi si Jose, na mà din, “Ni gó tô kóbadan katô tagénáp nu. Tô tállu séngê, tô gó é tállu álló. ");
INSERT INTO bgs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tállu álló tikud áknganni, paluwaán ka katô harì tikud dini ta prisowan, asta palónódán ka puman ikandin tun ta taganà lumu nu. Mid ka puman ka bino para kandin, iring katô taganà lumu nu. ");
INSERT INTO bgs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Atin ka madigár dán tô kóddô nu, sampátta. Uliti nu tô harì tingód kanak ébô makaluwà a tikud dini ta prisowan, ");
INSERT INTO bgs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","su igpiritta igpid tikud tun ta madiyù banuwa dé na mga Hebreo. Agad ándà palang madat na iglumu ku, asal igpaprisowa dini ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Na, tô ikasóddór dán tô taraimu ka pan para katô harì na madigár tô kóbadan katô tagénáp katô tarapid ka bino, igkagi sikandin ki Jose, na mà din, “Duwán pagsik tagénáp ku. Duwán tállu digu na ipánnù ka pan na igsudù ku. ");
INSERT INTO bgs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tô ikabówwó digu duwán marapung klasi ka pan na ágpiddán ku tun ta harì, asal igkan katô mga manuk ta kayun.” ");
INSERT INTO bgs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Na, igkagi si Jose, na mà din, “Ni gó tô kóbadan katô tagénáp nu. Tô tállu digu, tô gó é tállu álló. ");
INSERT INTO bgs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tállu álló tikud áknganni, paluwaán ka katô harì tikud dini ta prisowan, asta patampáddán din tô alig nu! Pabitinán tô lawa nu tun ta kayu, asta tô ákkud nu kannán ka mga manuk ta kayun.” ");
INSERT INTO bgs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Na, ituman gó tô igkagi i Jose kandan, su pángnga katô tállu álló, igimu tô harì ka dakál kalimudan, su tô gó é álló din, asta iglimud din tô langun opisyales. Igpaluwà din tikud tun ta prisowan tô tarapid ka bino asta tô taraimu ka pan. Igpapid din sikandan tun ta tubang katô mga opisyales na ilimud. ");
INSERT INTO bgs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tô tarapid ka bino, tô gó é igpalónód katô harì tun ta taganà lumu din, asta sikandin tô igpid puman ka bino para kandin. ");
INSERT INTO bgs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Asal tô taraimu ka pan, tô gó é igpamatayan katô harì. Ituman tô langun katô igkagi i Jose kandan. ");
INSERT INTO bgs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Asal ándà ikasampát tô tarapid ka bino tingód ki Jose. Ilingawan din sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Na, tô iglabé dán tô duwa ámmé, igtagénáp tô harì ka Ehipto. Igtindág sikandin tun ta ligad katô Wayig ka Nilo. ");
INSERT INTO bgs_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tigkô dád igkita din tô pittu baka na tuu malambù asta madigár tô bónnóng. Igláttó tô mga baka tikud tun ta wayig, asta igsabsab ka sigbát tun ta ligad katô wayig. ");
INSERT INTO bgs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tigkô dád igkita din tô ássa pittu baka na igláttó tikud tun ta wayig, asal tuu magasà asta madat tô bónnóng. Igsadun tô mga baka tun ta ássa pittu baka na igtindág tun ta ligad katô wayig. ");
INSERT INTO bgs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Igkan katô mga magasà baka tô mga malambù baka. Pángnga igtagénáp tô harì, ikannó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Na, igtudug puman tô harì ka Ehipto, asta igtagénáp puman sikandin. Igkita din tô sábbad lábbut ka trigo na duwán pittu kanguy na tuu malambù asta madigár tô bónnóng. ");
INSERT INTO bgs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Igtubù tô ássa pittu kanguy na madat asta igkipás guné katô ménit karamag tikud tun ta silatan. ");
INSERT INTO bgs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Igkan katô mga kipás kanguy tô mga malambù kanguy. Pángnga igtagénáp tô harì, ikannó sikandin asta ikasóddór sikandin na tagénáp din dád. ");
INSERT INTO bgs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tô sállám dán, isasó tô harì. Purisu igpakangé din tô langun tarasalamangka asta tô duma mga katig manubù tun ta Ehipto. Igulit tô harì kandan tingód katô tagénáp din, asal ándà palang manubù na ikólit kandin ka ándin tô kóbadan. ");
INSERT INTO bgs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na, igkagi tô tarapid ka bino katô harì, na mà din, “Sir, kailangan mulitta nigó tingód katô madat na ilumu ku. ");
INSERT INTO bgs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Dángngan tô isókówanna ikuna, isókówan nu tô taraimu ka pan para áknikó. Igpapriso ké ikuna tun ta balé katô kapitan ka mga sundalo nu. ");
INSERT INTO bgs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Duwán sábbad dukilám na igtagénáp ké, asal ánnà magunawa tô kóbadan katô tagénáp dé. ");
INSERT INTO bgs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tun ta prisowan, duwán sábbad Hebreo na mallaki asta állang katô kapitan ka mga sundalo nu. Igulit ké kandin tingód katô tagénáp dé, asta igulit din áknami tô kóbadan. ");
INSERT INTO bgs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ituman tô langun ka igkagi din, su igpalónódda puman ikuna tun ta taganà lumu ku, asta igpamatayan nu tô taraimu ka pan.” ");
INSERT INTO bgs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Purisu igpakangé katô harì si Jose, asta sékót igpaluwà si Jose tikud tun ta prisowan. Igpaburu sikandin, igilis, asta igsadun tun ta harì. ");
INSERT INTO bgs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Igkagi tô harì ki Jose, na mà din, “Igtagénáppa, asta ándà manubù na ikólit kanak ka ándin tô kóbadan. Igulitanna na katig ka gubad ka tagénáp ka ulitán áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Igtaba si Jose, na mà din, “Sir, ánnà tikud tun kanak tô kakatigan, asal Manama dád tô pasóddór áknikó katô madigár kóbadan katô tagénáp nu.” ");
INSERT INTO bgs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Igkagi tô harì, na mà din, “Tun ta tagénáp ku, igtindágga tun ta ligad katô Wayig ka Nilo. ");
INSERT INTO bgs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tigkô dád igkita ku tô pittu baka na tuu malambù asta madigár tô bónnóng. Igláttó tô mga baka tikud tun ta wayig, asta igsabsab dan ka sigbát tun ta ligad katô wayig. ");
INSERT INTO bgs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tigkô dád igkita ku tô ássa pittu baka na igláttó tikud tun ta wayig, asal tuu magasà asta madat tô bónnóng. Ándà palang baka na igkita ku dini ta Ehipto na tuu gó magasà ka tandingán kani mga baka. ");
INSERT INTO bgs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Na, igkan katô mga magasà baka tô mga malambù baka. ");
INSERT INTO bgs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Agad igkan katô mga magasà tô mga malambù, asal iring na ándà palang igkan, su tuu gó magasà tô mga baka. Pángnga igtagénáppa, ikannówa. ");
INSERT INTO bgs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Na, igtagénáppa puman, asta igkita ku tô sábbad lábbut ka trigo na duwán pittu kanguy na tuu malambù, asta madigár tô bónnóng. ");
INSERT INTO bgs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Igtubù pagsik tô ássa pittu kanguy na madat asta igkipás katô ménit karamag tikud tun ta silatan. ");
INSERT INTO bgs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Igkan katô mga kipás kanguy tô mga malambù kanguy. Na, tô gó é tagénáp na igulit ku katô mga tarasalamangka, asal ándà palang manubù na ikólit kanak ka ándin tô kóbadan.” ");
INSERT INTO bgs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Igkagi si Jose, na mà din, “Sir, sábbad dád tô kóbadan katô duwa tagénáp nu. Igpasóddór katô Manama áknikó tingód katô lumun din. ");
INSERT INTO bgs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tô pittu baka na malambù, asta tô pittu kanguy ka trigo na malambù, tô gó é pittu ámmé. Sábbad dád tô kóbadan katô duwa tagénáp nu. ");
INSERT INTO bgs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tô pittu magasà baka, asta tô pittu kanguy na igkipás katô ménit karamag tikud tun ta silatan, tô gó é pittu ámmé na ballus. ");
INSERT INTO bgs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Bánnal tô igkagi ku géna. Igpasóddór ka Manama áknikó tingód katô lumun din. ");
INSERT INTO bgs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dalám ka pittu ámmé, tuu dakál tô káttun dini ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Asal pángnga katô pittu ámmé na madigár, dumunggù tô pittu ámmé na ballus, asta tô gó é makadadat kani langun dini ta Ehipto. Purisu kalingawan tô pittu ámmé na duwán dakál igkáttu. ");
INSERT INTO bgs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kalingawan gó tô madigár mga ámmé tingód katô kadattan ka ballus na dumunggù. ");
INSERT INTO bgs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Makaduwa ka igtagénáp ébô kasóddóran nu na tô gó é lumun katô Manama, asta tumanán din ka dì madugé.” ");
INSERT INTO bgs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Igkagi si Jose, na mà din, “Na, sir, madigár ka salinán nu tô sábbad manubù na duwán kakatigan, asta imun nu sikandin ágsarigan ka langun dini ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Madigár ka salinán nu tô duma mga opisyales tun ta tagsábbad-sábbad lunsud ébô limudán dan tô ikalima kináttuwan katô madigár trigo dalám ka pittu ámmé na duwán dakál káttun. ");
INSERT INTO bgs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kailangan limudán dan tô trigo dalám ka mga ámmé na duwán dakál káttun ébô taguán tun ta tagsábbad-sábbad lunsud, asta tómmóngan dan. ");
INSERT INTO bgs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tô taguán, tô gó é kannán katô mga manubù ka dumunggù tô pittu ámmé na ballus dini ta Ehipto, ébô dì maté tô mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Na, idayawan tô harì asta tô duma mga opisyales tingód katô igkagi i Jose. ");
INSERT INTO bgs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Igkagi tô harì kandan, na mà din, “Ándà duma manubù na kitanán ta na tuu pa madigár ka tandingán ki Jose, su ágdumaan sikandin ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Purisu igkagi tô harì ki Jose, na mà din, “Su sikuna tô igpasóddór ka Manama katô langun, ándà palang manubù na katig pa ka tandingán áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Imun ku sikuna na mallayat tun ta gobyerno. Agad ándin tô sugù nu, tô gó é kailangan bánnalán katô langun manubù. Sakán dád tô mallayat pa áknikó, su sakán tô harì.” ");
INSERT INTO bgs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Igkagi tô harì ki Jose, na mà din, “Imun ku sikuna gobernador dini ta kaluwagan ka banuwa ka Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Purisu iglusut katô harì tô paningsing din na pató katô pagpangulu din, asta igbággé din ki Jose. Igpómpak din si Jose katô mapputì óggét na tuu dakál é lagà, asta igpasalagbat din si Jose ka bulawan. ");
INSERT INTO bgs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Igpasaké din si Jose tun ta ikaduwa kalesa din, asta duwán mga manubù na igpóna din ki Jose ébô tumawar dan, na mà dan, “Lingkóód kó!” Tô gó inému si Jose gobernador tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Igkagi pagsik tô harì ki Jose, na mà din, “Agad sakán tô harì, ándà gó mému lumun dini ta kaluwagan ka Ehipto ka dì mukit áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Igbullasan katô harì tô ngadan i Jose, su igngadanan din si Jose ki Sapenat Panea. Igpakalyag din si Jose ki Asenat na batà i Potiferas. Si Potiferas tô tarapid katô mga manubù na ágpangadap ka álló tun ta lunsud ka On. Purisu inému si Jose na ágpangulun tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tô inému dán si Jose na opisyales katô harì ka Ehipto, tállu pulù (30) tô idad din. Igpanó si Jose tikud tun ta balé katô harì, asta igtalap sikandin tun ta langun lunsud tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Dalám katô pittu ámmé na madigár, dakál tô kináttuwan. ");
INSERT INTO bgs_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Igpalimud i Jose tô ikalima kináttuwan ka trigo, asta igpatagù din tun ta mga lunsud. Duwán igtagù tun ta tagsábbad-sábbad lunsud tikud tun ta mga kinamát na madani. ");
INSERT INTO bgs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tô kadakállan katô trigo na igtagù iring na karapungan katô mga baklayan tun ta dagat, su tuu dakál. Purisu igpasódô i Jose tô kéyap ka pira tô kadakállan katô trigo, su tuu dakál. ");
INSERT INTO bgs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tô ándà pa dunggù tô ballus, duwa é gabatà i Jose gamama na ipamasusu i Asenat na batà i Potiferas. ");
INSERT INTO bgs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Igngadanan din tô kaké ki Manases su igkagi si Jose, na mà din, “Igtabanganna katô Manama. Purisu ilingawan kud tô langun kahirapan na inókitan ku tun ta góddóan katô ámmà ku asta mga kataladi ku.” ");
INSERT INTO bgs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Igngadanan din tô adi ki Efraim, su igkagi si Jose, na mà din, “Igtabanganna katô Manama. Purisu tuuwa igbuuy nit banuwa na ihirapan ku.” ");
INSERT INTO bgs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Na, iglabé tô pittu ámmé na dakál tô kináttuwan katô mga taga Ehipto, ");
INSERT INTO bgs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","asta igdunggù tô pittu ámmé na ballus, iring katô taganà igkagi i Jose. Iballusan tô mga manubù tun ta langun banuwa, asal duwán trigo na itagù tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tô igballus dán tô mga taga Ehipto, igpamuyù dan ka trigo tun ta harì. Igkagi sikandin, na mà din, “Sadun kó tun ki Jose, asta tuman kó katô kagin din ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Igtuu tô ballus. Purisu igpapókéan i Jose tô langun balé na igtaguan katô trigo, asta igpabarigyà din tun ta mga taga Ehipto, su dakál tô ballus tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Marapung pagsik tô mga manubù na igsadun tun ta Ehipto tikud tun ta ássa mga banuwa ébô málli dan ka trigo tun ki Jose, su dakál tô ballus tun ta kaluwagan ka banuwa. ");
INSERT INTO bgs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Na, tô ikasóddór si Jacob na duwán trigo tun ta Ehipto, igkagi sikandin tun ta mga gabatà din, na mà din, “Manan ka góddô-óddô kó dád? ");
INSERT INTO bgs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Duwán kun trigo tun ta Ehipto. Purisu sadun kó, asta bálli kó ébô dì ki maté kani ballus.” ");
INSERT INTO bgs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Purisu igpanó tô sapulù kataladi kaké i Jose, asta igsadun dan tun ta Ehipto ébô málli ka trigo. ");
INSERT INTO bgs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Asal tô bánnal kataladi i Jose na si Benjamin, ándà din patákkássi, su ágkamáddangan si Jacob agó duwán madat na makadunggù ki Benjamin. ");
INSERT INTO bgs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Purisu igsadun tô mga gabatà i Jacob tun ta Ehipto, asta tô duma mga manubù na igpamasak ka trigo, su iballusan tô mga Canaanhon. ");
INSERT INTO bgs_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na, si Jose tô gobernador tun ta Ehipto, asta sikandin tô ágbarigyà ka trigo tun ta langun manubù. Purisu tô igdunggù tô mga kataladi i Jose tun ta Ehipto, igpadani dan tun kandin, asta iglingkóód dan sippang ka ikadunggù tô ulu dan tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Tô igkita i Jose tô mga kataladi din, igkilala din sikandan, asal mà kagi ándà kilala. Igkagi si Jose ka mabákkár, na mà din, “Ánda é igtikudan yu?” Igtaba sikandan, na mà dan, “Igtikud ké tun ta Canaan ébô málli ké ka trigo.” ");
INSERT INTO bgs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Agad igkilala i Jose tô mga kataladi din, asal ándà dan kilalayi na sikandin tô kataladi dan adi. ");
INSERT INTO bgs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Isampáttan i Jose tô tagénáp din dángngan tingód kandan, asta igkagi sikandin, na mà din, “Madat kó mga manubù! Igsadun kó dini ébô mahà kó katô kalómétan dé ébô makapanalu kó áknami.” ");
INSERT INTO bgs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Igtaba sikandan, na mà dan, “Sir, ánnà bánnal. Igsadun ké dini ébô málli ké ka trigo. ");
INSERT INTO bgs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mataladi tô langun dé. Tuu ké matalláng. Ándà ké sadun dini ébô mahà katô kalómétan yu.” ");
INSERT INTO bgs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Igkagi si Jose, na mà din, “Bulalón kó! Igsadun kó dini ébô mahà katô kalómétan dé ébô makapanalu kó áknami.” ");
INSERT INTO bgs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Igkagi sikandan, na mà dan, “Sir, sapulù duwa tô langun dé na mataladi, asta sábbad dád tô ámmà dé na góddô tun ta Canaan. Inaté tô sábbad kataladi dé, asta igpatanan tô tambang adi dé tun ta ámmà dé.” ");
INSERT INTO bgs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Asal igkagi si Jose, na mà din, “Bánnal tô igkagi ku géna. Igsadun kó dini ébô mahà kó katô kalómétan dé. ");
INSERT INTO bgs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Na, duwán lumun ku ébô kasóddóran ku ka bánnal tô igkagi yu. Ukit katô ngadan ka harì, kagin ku na dì kó makapanó tikud dini sippang ka makasadun dini tô adi yu. ");
INSERT INTO bgs_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pólián ku tô sábbad ákniyu ébô mangé kandin, asal paprison ku tô siyó sippang ka kasóddóran ku ka bánnal tô igkagi yu. Atin ka ánnà bánnal tô igkagi yu, kasóddóran ku na igsadun kó dini ébô mahà kó katô kalómétan dé.” ");
INSERT INTO bgs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Purisu igpapriso din sikandan ka tállu álló. ");
INSERT INTO bgs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Na, tô itálluwan dán, igkagi si Jose tun ta mga kataladi din, na mà din, “Atin ka mánnal kó kanak, dì kó matayan, su ágrespetowan ku tô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Atin ka matalláng kó, sábbad dád ákniyu tô paprison ku, asta makólì tô mga duma ébô mid ka trigo tun ta mga pamilya yu na ágkaballusan. ");
INSERT INTO bgs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Asal kailangan piddán yu dini kanak tô tambang adi yu ébô kasóddóran ku na bánnal tô igkagi yu, asta dì kó matayan.” Na, ignunug dan ki Jose. ");
INSERT INTO bgs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Igpatóngkóé sikandan, na mà dan, “Igdungguan kid kani kadattan tingód katô madat na iglumu ta katô kataladi ta dángngan. Tô igrangin sikandin áknita, agad igkita ta tô ranu din, asal ándà ta sikandin paminággi. Purisu igdungguan ki kani kadattan.” ");
INSERT INTO bgs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Igkagi si Ruben, na mà din, “Igkagiya ákniyu na dì mému dadattan yu sikandin, asal ándà kó paminág kanak. Purisu igsulian kid tingód katô kamatayan din.” ");
INSERT INTO bgs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Agad ikagpáttù si Jose katô langun na igkagi dan, asal ándà dan kasóddóri, su tô igtóngkô dan kandin, duwán tarasugpat na gubad katô kagi dan na Hebreo tun ki Jose. ");
INSERT INTO bgs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Na, igtanan si Jose kandan dógó su igsággó sikandin. Tô iglónód sikandin tun kandan, igsalin din si Simeon, asta igpabagkás din sikandin tun ta tubang dan. ");
INSERT INTO bgs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Na, igsugù i Jose tô ágsuguánnán din ébô ipánnuán ka trigo tô sako katô mga kataladi din, asta ulián din tô bayad dan tun dalám ka mga sako dan. Igpabággéyan din sikandan ka makan dan róggun ágpanó dan. Tô gó é iglumu i Jose kandan. ");
INSERT INTO bgs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Na, igruran tô mga kataladi i Jose katô mga sako ka trigo tun ta mga mannanap dan na asno, asta igpanó dan. ");
INSERT INTO bgs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tô dukilám dán, igádding dan ébô dumággà. Igukar tô sábbad kandan katô sako din ébô pakannán tô asno din. Igkita din tun dalám katô sako tô salapì na bayad din ka trigo. ");
INSERT INTO bgs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Purisu igtawar din tô mga kataladi din, na mà din, “Dini dalám kani sako tô salapì ku! Igulì kannê kanak.” Purisu tuu dan imáddangan, asta igpénsaé dan, na mà dan, “Ándin ni iglumu ka Manama áknita?” ");
INSERT INTO bgs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Tô igdunggù dan dán tun ta Canaan, igulit dan katô ámmà dan tô langun. ");
INSERT INTO bgs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Igkagi sikandan, na mà dan, “Igsawé tô gobernador ka Ehipto áknami, asta igkagi sikandin na igsadun ké ébô mahà ké katô kalómétan dan asta makapanalu ké kandan. ");
INSERT INTO bgs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Igtaba ké na ánnà bánnal, su matalláng ké. ");
INSERT INTO bgs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Igulit ké kandin na sapulù duwa tô langun dé na mga mataladi na gamama, asta sábbad dád tô ámmà dé. Mà dé inaté tô sábbad kataladi dé, asta igpatanan tô tambang adi dé tun ta ámmà dé tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Asal igkagi tô gobernador tun áknami, ‘Ni gó tô lumun ku ébô kasóddóran ku ka matalláng kó. Sábbad ákniyu tô paprison ku dini róggun mulì tô mga duma ébô mid ka trigo tun ta mga pamilya yu na ágkaballusan. ");
INSERT INTO bgs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Atin ka piddán yu dini kanak tô tambang adi yu, kasóddóran ku na ánnà kó madat mga manubù, asal matalláng kó. Paluwaán ku tô kataladi yu, asta mému kó málli dini ta Ehipto.’” ");
INSERT INTO bgs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na, tô igukar dan katô mga sako dan, igkita katô tagsábbad-sábbad kandan tô salapì na bayad dan katô trigo. Tô igkita dan dán katô salapì, imáddangan tô langun dan asta si Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Igkagi si Jacob, na mà din, “Ukit ákniyu, mandà tô langun gabatà ku. Ándà dán si Jose, ándà dán si Simeon, asta kakalyag yu na mandà si Benjamin dini kanak. Tuuwa igdungguan ka kahirapan.” ");
INSERT INTO bgs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Igkagi si Ruben tun ta ámmà din, na mà din, “Sarig nu si Benjamin kanak, asta ulián ku sikandin dini áknikó. Atin ka dì ku sikandin mólì dini áknikó, matayi nu tô duwa gabatà ku gamama.” ");
INSERT INTO bgs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Asal igkagi si Jacob, na mà din, “Dì mému tumákkás si Benjamin ákniyu, su inaté dán tô kaké din na si Jose, asta si Benjamin dád tô isamà. Tuuwad tugál. Mamánnuwa ka kadungguan sikandin ka madat tun ta dalan? Atin ka maté sikandin, matéya tingód katô ranu ku kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Na, igtuu pa tô ballus tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tô inémmát dán tô trigo na igkangé dan tun ta Ehipto, igkagi si Jacob tun ta mga gabatà din, na mà din, “Lónód kó tun ta Ehipto, asta bálli kó ka délák dád trigo para áknita.” ");
INSERT INTO bgs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Asal igtaba si Juda, na mà din, “Igkagi tô manubù na dì ké makalónód tun kandin ka dì mákkás tô tambang adi dé. ");
INSERT INTO bgs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Atin ka patákkássán nu si Benjamin, lumónód ké ébô málli ké ka trigo para áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Asal ka dì nu patákkássán, dì ké lumónód, su igkagi tô manubù na atin ka dì mákkás tô tambang adi dé, dì ké makalónód tun kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Igkagi si Jacob na duwán ássa ngadan din si Israel, na mà din, “Manan ka iglumu kó kanak ka madat ukit ka kólit yu katô manubù na duwán pa kataladi yu?” ");
INSERT INTO bgs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Igtaba sikandan, na mà dan, “Marag sikandin ginsà tingód áknita asta tingód ka pamilya ta. Iginsà sikandin, ‘Ándà pa kamaté tô ámmà yu? Duwán pa duma kataladi yu?’ Purisu igtaba ké katô mga insà din. Ándà ké panámdám na piritán ké ikandin na piddán tô kataladi dé tun kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Igkagi si Juda tun ta ámmà din, na mà din, “Sarig nu si Benjamin kanak ébô panó ké agó maté ki langun asta ni mga gabatà ukit kani ballus. ");
INSERT INTO bgs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Tumandô a áknikó na sakán tô tumómmóng kandin ébô ándà makamánnu kandin. Atin ka dì ku sikandin mólì dini áknikó, tô gó é salà ku áknikó sippang ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Atin ka ándà ké kabaring, ikaduwa kéd pád ikalónód.” ");
INSERT INTO bgs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Igkagi tô ámmà dan, na mà din, “Atin ka ágkailanganán, ni gó tô lumu yu. Pid yu tô mga madigár buuy tikud dini ébô duwán bággén yu katô gobernador, na délák bawì asta tánnáb, mga anag, mga pamammut, asta mga buuy ka kayu pistasiyo asta almendras. ");
INSERT INTO bgs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Pid yu tô duwa luppì ka salapì yu, su kailangan piddán yu puman tô salapì na inólì tun ta mga sako yu, su ilingawan dan basì. ");
INSERT INTO bgs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Pid yu pagsik tô kataladi yu, asta sékót kó lónód. ");
INSERT INTO bgs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mólà pa ka tabangan kó katô Manama ébô kéduwan tô manubù ákniyu, asta pólián din si Benjamin asta si Simeon. Na, tingód kanak, atin ka kamatayanna katô mga gabatà ku, tógón din.” ");
INSERT INTO bgs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Purisu igpid dan tô mga gasa asta tô duwa luppì katô salapì dan, asta igsadun dan tun ta Ehipto na igtákkássan i Benjamin. Tô igdunggù dan dán, igpanayun dan tun ki Jose. ");
INSERT INTO bgs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tô igkita dán si Jose na igtákkás si Benjamin kandan, igkagi sikandin tun ta ágsuguánnán din, na mà din, “Pid nu tô mga manubù tun ta balé ku. Iyó ka ka sábbad baka asta óméng ka ka ágkakan, su kuman dan duma kanak kani ka malássád álló.” ");
INSERT INTO bgs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Igbánnal tô ágsuguánnán, asta igpid din tô mga kataladi i Jose tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tô ikasóddór dan na balé i Jose tô sadunan dan, imáddangan dan, asta igpatóngkóé sikandan, na mà dan, “Pasadunán ki dutun su tingód katô salapì na inólì tun ta mga sako ta dángngan. Ámmáttán ki, agón tô mga asno ta, asta imun ki na mga állang din.” ");
INSERT INTO bgs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Purisu tô igdunggù dan tun ta tété katô balé, igkagi sikandan tun ta ágsuguánnán, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Sir, paminág ka áknami. Igsadun ké dini dángngan ébô málli ké ka trigo. ");
INSERT INTO bgs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tô igdággà kéd tun ta dalan tô igulì ké, igukar ké katô mga sako dé, asta igkita tô tagsábbad-sábbad áknami katô salapì tun ta bówwó ka trigo tun dalám ka mga sako. Ni tô kadakállan katô salapì na igpid dé puman ébô ulián dé. ");
INSERT INTO bgs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Igpid dé tô ássa salapì na bayad dé ka trigo. Ándà sóddór dé ka sadan tô igdalám katô salapì tun ta mga sako dé dángngan.” ");
INSERT INTO bgs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Igkagi tô ágsuguánnán, na mà din, “Yakó ágkasasó. Yakó ágkamáddangan. Tô Manama na ágpangadapán yu asta ágpangadapán katô ámmà yu, tô gó basì é igdalám ka salapì tun ta mga sako yu. Igtanggap ku tô pagbálli yu dángngan.” Na, igpid din si Simeon tun kandan. ");
INSERT INTO bgs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Igpahu din sikandan tun ta balé i Jose, asta igpid din tun kandan tô wayig ébô urasan dan tô mga paa dan. Igpakan din tô mga asno dan. ");
INSERT INTO bgs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Igukar dan tô mga gasa dan ki Jose ka dumunggù sikandin ka malássád álló, su igulitan dan na kuman dan tun kandin. ");
INSERT INTO bgs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tô igulì si Jose, igbággé dan kandin tô mga gasa na igpid dan, asta iglingkóód dan sippang ka ikadunggù tô ulu dan tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Iginsà si Jose kandan tingód katô kóddô dan. Iginsà sikandin, na mà din, “Mabákkár pa tô ámmà yu, tô tugál na igulit yu kanak dángngan? Manté pa sikandin?” ");
INSERT INTO bgs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Igtaba sikandan, na mà dan, “Sir, manté pô tô ámmà dé, asta mabákkár pa sikandin.” Na, iglingkóód dan, asta igrespetowan dan sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tô igkita dán si Jose katô adi din na si Benjamin, igkagi sikandin, na mà din, “Ni gó tô tambang adi yu na igulit yu kanak dángngan?” Igkagi si Jose tun ki Benjamin, na mà din, “Batà, mólà pa ka kéduwan tô Manama áknikó!” ");
INSERT INTO bgs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Na, masig dán pád ikasággó si Jose, su ágginawaan din tô adi din. Purisu sékót sikandin igsadun tun ta kuwarto din, asta igsággó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tô itagad-tagad dán, igdappug sikandin, asta iglónód tun ta mga kataladi din. Igpasarig din tô ginawa din, asta igpasánnar sikandin ka ágkakan. ");
INSERT INTO bgs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Igássa tô ágkannanan dan, su duwán lamisa para ki Jose, asta ássa tô lamisa para katô mga kataladi din. Ássa tô lamisa para katô mga taga Ehipto na igkan tun kandan, su tô mga taga Ehipto dì mému kuman duma katô mga Hebreo, su dì madigár tun kandan. ");
INSERT INTO bgs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Igpónsad i Jose tô tagsábbad-sábbad katô kataladi din tun ta tubang din, tikud tun ta kaké sippang tun ta adi. Tô igkita dan tô kapónsad din kandan, igpasállággé dan su isalábbuan dan. ");
INSERT INTO bgs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Igpabággé i Jose tô ágkakan tikud tun ta lamisa din tun ta mga kataladi din, asal makalima luppì tô ágkakan na igpabággé din tun ki Benjamin. Dakál tô iginám dan, asta idayawan dan. ");
INSERT INTO bgs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Na, igkagiyan i Jose tô ágsuguánnán din, na mà din, “Ipánnù nu tô mga sako dan ka trigo sippang ka maggán katô mga asno dan, asta dalám nu tô salapì na bayad dan tun ta sako katô tagsábbad-sábbad kandan. ");
INSERT INTO bgs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Dalám nu tô mapputì bulawan kopa ku tun ta sako katô tambang adi dan, asta tô bayad din ka trigo.” Purisu igbánnal tô ágsuguánnán katô igkagi i Jose. ");
INSERT INTO bgs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tô sállám dán, igpanó tô mga kataladi i Jose asta tô mga asno dan. ");
INSERT INTO bgs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tô ándà dan pa ikapanó ka madiyù tikud tun ta lunsud, igkagiyan i Jose tô ágsuguánnán din, na mà din, “Lupug nu sikandan. Atin ka kasabban nu, insà nu, ‘Manan ka madat tô iglumu yu katô manubù na iglumu ka madigár ákniyu? ");
INSERT INTO bgs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Manan ka igtakó yu tô mapputì bulawan kopa katô amo ku? Tô gó é ginámmanan din, asta ággamitán din ka ágsalamangka sikandin. Tuu madat tô iglumu yu.’” ");
INSERT INTO bgs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Na, tô ikasab dán tô ágsuguánnán, igkagiyan din sikandan katô igkagi i Jose. ");
INSERT INTO bgs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Asal igtaba sikandan, na mà dan, “Sir, manan ka ágpagtám ka áknami? Dì ké gó makalumu iring katô igkagi nu! ");
INSERT INTO bgs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Agad tô salapì na igkita dé tun ta mga sako dé tun ta Canaan, igulì dé áknikó. Purisu manan ka tumakó ké katô bulawan ó mapputì bulawan tikud tun ta balé katô amo nu? ");
INSERT INTO bgs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Sir, atin ka kitanán nu ka sadan tô igtakó kannun áknami, mému matayan nu sikandin, asta sikami mému na mga állang nu.” ");
INSERT INTO bgs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Igtaba tô ágsuguánnán, na mà din, “Madigár tô igkagi yu, asal tô manubù na igtakó katô kopa, tô dád gó é mému na állang, asta makólì tô mga duma.” ");
INSERT INTO bgs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Purisu sékót dan igpapónóg tô mga sako dan, asta igukar dan tô langun. ");
INSERT INTO bgs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Tuu igahà katô ágsuguánnán tô sako katô tagsábbad-sábbad kandan tikud tun ta kaké sippang tun ta adi, asta igkita din tô kopa tun ta sako i Benjamin. ");
INSERT INTO bgs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Purisu tô langun dan igbissé katô umpak dan tingód katô ranu dan. Igruran dan puman tô mga sako tun ta mga asno, asta iglónód dan tun ta lunsud. ");
INSERT INTO bgs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Tô igdunggù dán si Juda asta tô mga kataladi din tun ta balé i Jose, dutun pa sikandin. Iglingkóód tô langun dan sippang ka ikadunggù tô ulu dan tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Igkagi si Jose, na mà din, “Manan ka iglumu kó kani madat? Ándà basì sóddór yu na makémuwa makakita katô áglumun yu ukit ka salamangka.” ");
INSERT INTO bgs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Igtaba si Juda, na mà din, “Sir, ándin basì tô lumun dé? Ándà mataba dé áknikó. Igpasóddór dán ka Manama na ikasalà ké dángngan. Purisu tô langun dé mému na mga állang nu duma katô ikitaan nu katô kopa.” ");
INSERT INTO bgs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Asal igkagi si Jose, na mà din, “Dì! Dì mému! Tô manubù dád na ikitaan katô kopa tô mému na állang ku. Asal sikiyu na mga kataladi din, makólì kó tun ta ámmà yu.” ");
INSERT INTO bgs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Na, igpadani si Juda tun ki Jose, asta igkagi sikandin, na mà din, “Sir, atin ka mému áknikó, malyagga pád kumagi áknikó. Yaka ágkasókó kanak. Magunawa tô kallayatan katô kamanubuan nu asta tô kallayatan katô harì. ");
INSERT INTO bgs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Sir, dángngan iginsà ka áknami ka duwán pa ámmà dé asta mga kataladi dé. ");
INSERT INTO bgs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Igtaba ké na duwán pa ámmà dé na tugál, asta duwán pa adi dé na ipamasusu tun ta katugállan katô ámmà dé. Sikandin dád tô isamà katô duwa gabatà katô innà dan, su inaté tô kaké din. Tuu ágginawaan sikandin katô ámmà dé. ");
INSERT INTO bgs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Sir, igkagi ka áknami na kailangan piddán dé sikandin dini áknikó ébô kumita ka kandin. ");
INSERT INTO bgs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Igkagi ké áknikó na dì sikandin pakatanan katô ámmà dé su agó maté tô ámmà dé tingód ka ranu din. ");
INSERT INTO bgs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Asal igkagi ka na dì ké makalónód dini áknikó ka dì mákkás tô tambang adi dé. ");
INSERT INTO bgs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tô igulì ké tun ta ámmà dé, igulit ké kandin tingód katô igkagi nu áknami. ");
INSERT INTO bgs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Na, sábbad álló igkagi tô ámmà dé na kailangan lumónód ké dini ébô málli ka trigo. ");
INSERT INTO bgs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Asal igkagi ké na dì ké lumónód. Atin ka dì mákkás tô adi dé, dì ké makalónód dini. Asal ka mákkás sikandin, lumónód ké. ");
INSERT INTO bgs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Na, igkagi tô ámmà dé áknami, na mà din, ‘Isóddóran yu na duwa dád tô gabatà ku na ipamasusu katô sawa ku na si Raquel. ");
INSERT INTO bgs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Inatayannad katô sábbad. Igmatayan basì sikandin ka magani mannanap ka kabánnássan, asta ándà kud gó kitayi. ");
INSERT INTO bgs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Purisu atin piddán yu pagsik tô adi yu asta maté sikandin, matéya tingód ka ranu ku kandin, su tuuwad tugál.’ ");
INSERT INTO bgs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Purisu, sir, atin ka dì mákkás tô adi dé ka mulì ké, asta kasóddóran katô ámmà dé na ándà sikandin ikólì, maté sikandin, su tuu din ágginawaan ni batà din. Purisu ukit áknami, maté tô ámmà dé tingód ka ranu din. ");
INSERT INTO bgs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Sakán tô igtandô katô ámmà ku na bantéyan ku ni adi dé ébô ándà makamánnu kandin. Igkagiya na atin dì ku mólì mapid ni adi dé tun kandin, tô gó é salà ku kandin ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Purisu, sir, póddô ka kanak dini áknikó ébô imunna na állang na bullas kandin. Pólì nu sikandin asta tô duma mga kataladi din. ");
INSERT INTO bgs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Diya mulì tun ta ámmà ku ka dì mákkás tô adi dé. Diya malyag kumita katô kadattan na dumunggù tun ta ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Na, ándà ikatiis si Jose katô igriyu din tun ta tubang katô mga ágsuguánnán din. Purisu igpéwà din tô langun dan ébô ándà duma manubù tun dalám ka balé ka kapakilala din katô mga kataladi din. ");
INSERT INTO bgs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Su tuu igsággó si Jose, ikadinág tô mga taga Ehipto tun ta luwà katô balé, asta igulitan tô mga manubù tun ta balé katô harì. ");
INSERT INTO bgs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Igkagi si Jose tun ta mga kataladi din, na mà din, “Sakán si Jose! Manté pô tô ámmà ta?” Tô igdinág dán tô mga kataladi din katô kagi din, ándà dan ikataba kandin tingód katô máddang dan. ");
INSERT INTO bgs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Purisu igkagi si Jose, na mà din, “Padani kó dini kanak.” Tô igpadani dan dán tun kandin, igkagi si Jose, na mà din, “Sakán tô kataladi yu na si Jose na igbarigyà yu, asta igpidda dini ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na, yakó ágkasasó. Yakó ágkaranu tingód katô kabarigyà yu kanak, su igpóna a katô Manama dini ébô dì kó maté. ");
INSERT INTO bgs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Agad iglabé dán tô duwa ámmé katô ballus, asal lima pa ámmé na ándà káttun tun ta mga kinamát. ");
INSERT INTO bgs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Igpóna a katô Manama dini ébô makatabangnga ákniyu, su kakalyag din na dì kó maté ka ballus ébô manté kó asta tô mga rubbad yu. ");
INSERT INTO bgs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Purisu ánnà sikiyu tô igpapid kanak dini, asal Manama tô igpapid kanak dini. Igimuwa ikandin na mallayat katô mga opisyales katô harì. Sakán tô ágsugù katô langun opisyales katô harì, asta sakán tô pangulu dini ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Purisu sékót kód ulì tun ta ámmà ta, asta ulit kó kandin, ‘Ni gó tô igkagi katô batà nu na si Jose. Igpapanguluwad ka Manama dini ta kaluwagan ka Ehipto. Sékót kó sadun dini kanak. ");
INSERT INTO bgs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Póddóán ku sikiyu dini ta banuwa ka Gosen ébô madani kó langun dini kanak, agad sikuna, asta tô mga gabatà nu, tô mga apù nu, tô mga karnero, tô mga kambing, tô mga baka, asta tô langun katô kaduwánnan nu. ");
INSERT INTO bgs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Atin ka móddô kó dini ta Gosen, dóppónan ku sikiyu. Lima pa ámmé tô ballus, asta dì mému kahirapan ka, tô mga gabatà nu, asta tô mga mannanap nu.’” ");
INSERT INTO bgs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Igkagi si Jose, na mà din, “Na, tô langun yu mga kaké ku, asta sikuna Benjamin, ikakilala kód na bánnal sakán si Jose. ");
INSERT INTO bgs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Uliti yu tô ámmà ta tingód ka kallayatan katô kamanubuan ku dini ta Ehipto, asta tingód katô langun na igkita yu dini. Purisu sékót kód, asta pid yu sikandin dini.” ");
INSERT INTO bgs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Na, igkápkáp si Jose katô adi din na si Benjamin, asta igsággó sikandin. Tô igkápkáp si Benjamin ki Jose, igsággó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Igkápkáppan i Jose tô tagsábbad-sábbad kandan, igadákkan din sikandan, igsággó sikandin, asta igpatóngkóé dan. ");
INSERT INTO bgs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tô ikadinág dán tô harì na igdunggù tô mga kataladi i Jose, idayawan sikandin asta tô langun opisyales din. ");
INSERT INTO bgs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Igkagi tô harì ki Jose, na mà din, “Kagiyi nu tô mga kataladi nu na ruranan tô mga asno dan asta mulì dan tun ta Canaan ");
INSERT INTO bgs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ébô kangén dan tô ámmà yu asta tô mga pamilya dan, asta lumónód dan dini. Póddóán ku sikandan tun ta madigár tanà dini ta Ehipto, asta tuu madigár tô makan dan dini. ");
INSERT INTO bgs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Bággé nu pagsik kandan tô mga kareton tikud dini ébô duwán sakayan katô mga sawa dan asta mga gabatà dan. Kailangan piddán dan tô ámmà yu. ");
INSERT INTO bgs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kagiyi nu sikandan na kailangan dì dan ágkasasó tingód katô kaduwánnan dan na katananan tun ta Canaan, su bággayan dan katô tuu madigár dini ta banuwa ka Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Na, ignunug tô mga gabatà i Jacob. Duwán mga kareton na igbággé i Jose kandan magunawa katô sugù katô harì kandin, asta duwán igbággé din kandan na makan dan róggun ágpanó dan. ");
INSERT INTO bgs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Duwán madigár umpak na igbággé i Jose katô tagsábbad-sábbad kandan, asal si Benjamin tô igbággayan din ka tállu gatus (300) abuk ka mapputì bulawan asta lima tô umpak. ");
INSERT INTO bgs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Duwán igpapid i Jose tun ta ámmà din, sapulù asno na igruranan ka madigár klasi ka kaduwánnan tikud tun ta Ehipto, asta sapulù tô asno na igruranan ka trigo, pan, asta duma mga klasi ka makan ébô duwán kannán i Jacob róggun ágpanó dan. ");
INSERT INTO bgs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Na, igkagi si Jose tun ta mga kataladi din, na mà din, “Yakó ágpóiyé tun ta dalan.” Purisu igpapanó din sikandan. ");
INSERT INTO bgs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Igpanó dan tikud tun ta Ehipto, asta igulì dan tun ta ámmà dan na si Jacob tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Igkagi sikandan, na mà dan, “Manté pô si Jose! Sikandin tô ágpangulun katô langun tun ta kaluwagan ka Ehipto.” Tuu isalábbuan si Jacob, su ándà sikandin bánnal. ");
INSERT INTO bgs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Asal tô igulit dan kandin tingód katô langun na igkagi i Jose, asta tô igkita din tô mga kareton na igpapid i Jose ébô duwán sakayan din na madun tun ta Ehipto, inanté puman tô pusung din. ");
INSERT INTO bgs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Igkagi si Jacob, na mà din, “Nángngà dán. Isóddóran kud na manté pa tô batà ku na si Jose. Kailangan madunnad ébô kumita a kandin ka diya pa maté.” ");
INSERT INTO bgs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Na, igruran i Jacob tô langun katô kaduwánnan din, asta igpanó dan tikud tun ta Canaan. Tô igdunggù dan tun ta Berseba, duwán mga mannanap na igmatayan i Jacob, asta iggóbbó din ébô mangadap sikandin katô Manama iring na kapangadap katô ámmà din na si Isaac. ");
INSERT INTO bgs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Tô dukilám tô, igpakita tô Manama ki Jacob. Igtawar tô Manama, na mà din, “Jacob.” Igtaba si Jacob, na mà din, “Óó, kannunna.” ");
INSERT INTO bgs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Igkagi tô Manama, na mà din, “Sakán tô Manama. Sakán tô Manama katô ámmà nu sayyan. Yaka ágkamáddangan, asal sadun ka tun ta Ehipto, su tun ta Ehipto imun ku na tuu marapung tô mga rubbad nu. ");
INSERT INTO bgs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mákkássa ákniyu tun ta Ehipto, asta pólián ku pagsik tô mga rubbad nu dini ta Canaan. Atin ka maté ka, si Jose tô lumábbáng áknikó.” ");
INSERT INTO bgs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Na, igpanayun si Jacob tikud tun ta Berseba. Igpasaké katô mga gabatà din si Jacob tun ta kareton na igpapid katô harì. Igpasaké dan tô mga gabatà asta tô mga sawa dan. ");
INSERT INTO bgs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Igpid dan pagsik tô mga mannanap dan asta tô mga kaduwánnan dan tikud tun ta Canaan, asta igsadun dan tun ta Ehipto. Igtákkás ki Jacob tô langun rubbad din, ");
INSERT INTO bgs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","tô mga gabatà din gamama asta gabayi, asta tô mga apù din gamama asta gabayi. ");
INSERT INTO bgs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Na, ni gó tô mga ngadan katô mga rubbad i Jacob na igtákkás kandin tun ta Ehipto. Si Ruben tô kaké batà i Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Igtákkás si Ruben asta tô mga gabatà din gamama na si Hanoc, si Pallu, si Hesron, asta si Carmi. ");
INSERT INTO bgs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Si Simeon asta tô mga gabatà din gamama na si Jemuel, si Jamin, si Ohad, si Jakin, si Sohar, asta si Saul na batà ka bayi na Canaanhon. ");
INSERT INTO bgs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Si Levi asta tô mga gabatà din gamama na si Gerson, si Cohat, asta si Merari. ");
INSERT INTO bgs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Si Juda asta tô mga gabatà din gamama na si Selas, si Peres, asta si Seras. (Inaté tun ta Canaan tô duma gabatà i Juda na si Er asta si Onan.) Duwán gabatà gamama i Peres na si Hesron asta si Hamul. ");
INSERT INTO bgs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Si Isacar asta tô mga gabatà din gamama na si Tolas, si Puas, si Jasub, asta si Simron. ");
INSERT INTO bgs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Si Zabulon asta tô mga gabatà din gamama na si Sered, si Elon, asta si Jaleel. ");
INSERT INTO bgs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Tô gó é mga gabatà gamama i Jacob na ipamasusu i Lea tun ta Mesopotamia. Duwán pagsik batà dan bayi na si Dina. Tállu pulù tállu (33) tô mga rubbad i Jacob asta i Lea. ");
INSERT INTO bgs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Igtákkás si Gad asta tô mga gabatà din gamama na si Sifeon, si Hagi, si Suni, si Esbon, si Eri, si Arod, asta si Areli. ");
INSERT INTO bgs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Si Aser asta tô mga gabatà din gamama na si Imnas, si Iskas, si Isvi, si Berias, asta tô tábbé dan na si Sera. Duwán gabatà gamama i Berias na si Eber asta si Malkiel. ");
INSERT INTO bgs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tô gó é mga gabatà gamama i Jacob na ipamasusu i Zilfa na állang na igbággé i Laban katô batà din na si Lea. Sapulù ánnám (16) tô mga rubbad i Jacob asta i Zilfa. ");
INSERT INTO bgs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Duwa tô mga gabatà gamama i Jacob na ipamasusu katô sawa din na si Raquel, asta tô mga ngadan dan na si Jose asta si Benjamin. ");
INSERT INTO bgs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Duwa tô gabatà gamama i Jose na ipamasusu tun ta Ehipto, na si Manases asta si Efraim. Tô gó é gabatà i Jose asta i Asenat na batà i Potiferas na tarapid katô mga manubù na ágpangadap katô álló tun ta lunsud ka On. ");
INSERT INTO bgs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Duwán mga gabatà gamama i Benjamin na si Belas, si Betser, si Asbel, si Geras, si Naaman, si Ehi, si Ros, si Mufim, si Hufim, asta si Ared. ");
INSERT INTO bgs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tô gó é mga gabatà gamama i Jacob na ipamasusu i Raquel. Sapulù áppat (14) tô mga rubbad i Jacob asta i Raquel. ");
INSERT INTO bgs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Igtákkás si Dan asta tô batà din mama na si Husim. ");
INSERT INTO bgs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Si Neftali asta tô mga gabatà din gamama na si Jaseel, si Guni, si Jeser, asta si Selem. ");
INSERT INTO bgs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tô gó é mga gabatà gamama i Jacob na ipamasusu i Bilha na állang na igbággé i Laban katô batà din na si Raquel. Pittu tô mga rubbad i Jacob asta i Bilha. ");
INSERT INTO bgs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Kannámman ánnám (66) tô langun rubbad i Jacob na igsadun tun ta Ehipto. Ándà iyapi tô mga sawa katô mga gabatà din. ");
INSERT INTO bgs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Duwa tô gabatà i Jose na ipamasusu tun ta Ehipto. Purisu kapittuwan (70) tô langun dan tun ta pamilya i Jacob na igsadun tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Na, igpasadun i Jacob si Juda tun tóna dan ébô madun tun ki Jose, su kakalyag din na sumarán dan i Jose tun ta Gosen. Tô igdunggù dan dán tun ta banuwa ka Gosen, ");
INSERT INTO bgs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","igsaké si Jose katô kalesa din, asta igsadun sikandin tun ta Gosen ébô sumumar katô ámmà din. Tô igdunggù dán sikandin, tigkô dád igkápkáppan din tô ámmà din, asta idugé sikandin igsággó. ");
INSERT INTO bgs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Igkagi si Jacob ki Jose, na mà din, “Mému matéyad, su igkita ad áknikó, asta isóddóran kud na manté ka pa.” ");
INSERT INTO bgs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Na, igkagi si Jose tun ta mga kataladi din asta duma mga manubù tun ta pamilya katô ámmà din, na mà din, “Madunna tun ta harì ébô mulitta kandin na igdunggù dán tikud tun ta Canaan tô langun yu na mga kataladi ku asta tô duma mga manubù tun ta pamilya katô ámmà ku. ");
INSERT INTO bgs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mulitta kandin na taradóppón kó katô mga mannanap, asta igpid yu tô langun karnero yu, tô duma mga mannanap yu, asta tô langun katô kaduwánnan yu. ");
INSERT INTO bgs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Purisu atin ka tawarán kó katô harì, asta insaán kó ikandin ka ándin tô áglumun yu, ");
INSERT INTO bgs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","kailangan kumagi kó kandin na taradóppón kó tikud pô tun ta kadélákkan yu, magunawa katô áglumun katô mga kamónaan yu sayyan ébô póddóán kó ikandin tun ta Gosen.” Tô gó é igkagi i Jose kandan, su ágbuyasán katô mga taga Ehipto tô mga taradóppón ka mannanap. ");
INSERT INTO bgs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Na, igsalin i Jose tô lima kataladi din, asta igsadun dan tun ta harì. Igkagi si Jose, na mà din, “Igdunggù dán tô ámmà ku asta tô mga kataladi ku tikud tun ta Canaan na tákkás katô langun karnero dan, duma mga mannanap dan asta langun katô kaduwánnan dan. Dutun dan dán ta banuwa ka Gosen.” Na, igpakilala din tô lima kataladi din tun ta harì. ");
INSERT INTO bgs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Iginsà tô harì kandan, na mà din, “Ándin tô áglumun yu?” Igtaba sikandan, na mà dan, “Sir, taradóppón ké ka mga mannanap, magunawa katô áglumun katô mga kamónaan dé sayyan. ");
INSERT INTO bgs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Igsadun ké dini su tuu dakál tô ballus tun ta Canaan. Purisu ándà palang ágkakan katô mga mannanap dé. Atin ka mému áknikó, móddô ké tun ta banuwa ka Gosen.” ");
INSERT INTO bgs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Igkagi tô harì ki Jose, na mà din, “Madigár su igdunggù dán tô ámmà nu asta ni mga kataladi nu. ");
INSERT INTO bgs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Sikuna tô pangulu dini ta kaluwagan ka Ehipto. Póddô nu sikandan tun ta banuwa ka Gosen, su tô gó é tuu madigár tanà. Atin ka duwán mga manubù tun kandan na katig ágdóppón ka mannanap, imun nu sikandan na taradóppón katô mga mannanap ku.” ");
INSERT INTO bgs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Na, igpid i Jose tô ámmà din na si Jacob asta igpakilala din tun ta harì. Igdasal si Jacob ébô madigár tô bággén katô Manama tun ta harì. ");
INSERT INTO bgs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Iginsà tô harì kandin, na mà din, “Pira dán é idad nu?” ");
INSERT INTO bgs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Igtaba si Jacob, na mà din, “Sábbad gatus tállu pulù (130) tô idad ku. Mabbabà dád tô idad ku, asta mahirap tô kóddô ku. Ándà pa ráppà tô idad ku katô idad katô mga kamónaan ku.” ");
INSERT INTO bgs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Igdasal puman si Jacob ébô madigár tô bággén katô Manama tun ta harì, asta igpanó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Na, igpóddô i Jose tô ámmà din asta tô mga kataladi din tun ta Ehipto. Tuu madigár tô tanà na igbággé i Jose kandan madani tun ta lunsud ka Rameses, magunawa katô igkagi katô harì kandin. ");
INSERT INTO bgs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Duwán ágkakan na igbággé i Jose katô ámmà din, mga kataladi din, asta mga manubù tun ta pamilya katô ámmà din asta mga gabatà dan. ");
INSERT INTO bgs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tuu dakál tô ballus, asta ándà palang ágkakan agad ánda. Iballusan tô langun manubù tun ta Ehipto asta Canaan, su tuu dakál tô ballus. ");
INSERT INTO bgs_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Igbálli dan ka trigo tun ki Jose, asta igpid i Jose tô kadakállan katô salapì na bayad dan tun ta balé katô harì. ");
INSERT INTO bgs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tô inémmát tô kadakállan katô salapì tun ta kaluwagan ka Ehipto asta Canaan, igsadun tô mga taga Ehipto tun ki Jose, asta igkagi sikandan, na mà dan, “Bággéyi ké ka ágkakan dé, su masig kéd maté. Tabangi ké, su ándà dán trigo dé, asta inémmát dán tô salapì dé.” ");
INSERT INTO bgs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Igkagi si Jose, na mà din, “Atin ka inémmát dán tô salapì yu, pid yu dini tô mga mannanap yu, su tô gó é bullas yu katô trigo.” ");
INSERT INTO bgs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Purisu igpid dan tun ki Jose tô mga mannanap dan, agad tô mga kudà, tô mga karnero, tô mga kambing, tô mga baka, asta tô mga asno. Tô gó é bullas dan ka trigo tun ki Jose. Igbággé din tô trigo tun kandan na igbullasan dan katô langun mannanap dan dalám katô ámmé tô. ");
INSERT INTO bgs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tô iglabé dán tô sábbad ámmé, iglónód dan tun ki Jose, asta igkagi sikandan, na mà dan, “Sir, bánnal tô kagi dé áknikó na inémmát dán tô salapì dé, asta igtigatun nud tô langun mannanap dé. Ándà dán bággén dé áknikó su kinamát dé asta lawa dé dád man tô isamà. ");
INSERT INTO bgs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Atin ka dì ka tumabang áknami, maté ké, asta kadattan tô kinamát dé. Lawa asta kinamát dé tô bullas dé ka trigo. Mému imun kéd na mga állang katô harì, asta bággén dé tô tanà dé tun kandin. Asal bággéyi ké dád ka trigo ébô dì ké maté, asta ébô duwán pamulan dé tun ta kinamát.” ");
INSERT INTO bgs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Purisu igbálli i Jose tô kaluwagan ka tanà tun ta Ehipto para katô harì. Igbarigyà tô langun taga Ehipto katô mga tanà dan su tuu dakál tô ballus. Purisu inému tô harì na tigatun katô kaluwagan ka tanà. ");
INSERT INTO bgs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Inému na mga állang katô harì tô langun manubù tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Asal ándà bálliyi i Jose tô tanà na igtigatun katô mga tarapid ka simbaan tun ta Ehipto. Ándà dan barigyai tô tanà dan su ágbággayan dan katô harì ka makan, asta nángngà dád para kandan. ");
INSERT INTO bgs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Igkagi si Jose tun ta mga manubù, na mà din, “Igbálli kód katô harì, asta igbálli din tô tanà yu. Purisu bággén kud ákniyu tô similya na pamulan yu. ");
INSERT INTO bgs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Asal ka kumáttu kó, kailangan bággén yu tô ikalima kináttuwan tun ta harì. Ákniyu tô samà katô makáttu yu ébô duwán similya na pamulan yu, asta ébô duwán makan yu asta katô mga pamilya yu.” ");
INSERT INTO bgs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Igtaba sikandan, na mà dan, “Sir, tingód katô tabang nu áknami, dì kéd maté. Purisu atin ka mému áknikó, imu ké na mga taralumu katô harì.” ");
INSERT INTO bgs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Purisu igsugù si Jose tun ta mga taga Ehipto na kailangan bággén tun ta harì tô ikalima kináttuwan, asta tô gó é sugù na ágbánnalán katô mga manubù. Tanà dád katô mga tarapid ka simbaan dan tô ándà tigatuni katô harì. ");
INSERT INTO bgs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Igóddô tô mga rubbad i Israel tun ta banuwa ka Gosen na sakup ka Ehipto. Inému dakál tô kaduwánnan dan, asta tuu dan igrubbad. ");
INSERT INTO bgs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Igóddô si Jacob tun ta Ehipto ka sapulù pittu (17) ámmé sippang ka sábbad gatus kappatan pittu (147) tô idad din. ");
INSERT INTO bgs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Tô ikasóddór si Jacob na masig dán sikandin maté, igtawar din tô batà din na si Jose, asta igkagi sikandin, na mà din, “Atin ka mému áknikó, dappán nu yan bállad nu nit bubun ku ébô kasóddóran ku na tumanán nu ni panalan ku áknikó. Atin ka duwán kédu nu kanak, tandô ka na dì nu lábbángngán ni lawa ku kannun ta Ehipto, ");
INSERT INTO bgs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","su kakalyag ku na lábbángngán ni lawa ku tun ta lábbángnganan katô mga kamónaan ku. Atin ka matéya, pid nu ni lawa ku tikud dini ta Ehipto, asta lábbángnga tun ta iglábbángngan kandan.” Igkagi si Jose, na mà din, “Óó. Tumanán ku ni igpanalan nu kanak.” ");
INSERT INTO bgs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Igkagi si Jacob, na mà din, “Tandô ka kanak na tô gó é lumun nu.” Purisu igtandô si Jose. Igunduk si Jacob tun ta ágdággaan din, asta igpasalamat sikandin katô Manama. ");
INSERT INTO bgs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Na, duwán álló na igulitan si Jose na ibógókan tô ámmà din. Purisu igpid din tô duwa gabatà din na si Efraim asta si Manases, asta igsadun dan tun ki Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tô igulitan si Jacob na igdunggù dán tô batà din na si Jose, igmabákkár sikandin, asta igánnó tun ta ágdággaan din. ");
INSERT INTO bgs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Igkagi si Jacob tun ki Jose, na mà din, “Tô Tuu Matulus Manama igpakita kanak tun ta Luz sakup ka Canaan, asta madigár tô igtandô din kanak. ");
INSERT INTO bgs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Igkagi sikandin, ‘Marapung tô gabatà na bággén ku áknikó ébô kumarapung tô mga grupo ka rubbad nu. Tô tanà tun ta Canaan bággén ku tun ta mga rubbad nu ébô matigatun dan sippang ka ándà ágtamanán.’” ");
INSERT INTO bgs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Igkagi si Jacob, na mà din, “Tô duwa gabatà nu na ipamasusu dini ta Ehipto tô ándà a pa alin dini, tô gó é imun ku na mga gabatà ku. Imun ku na kanak gabatà si Efraim asta si Manases, magunawa katô bánnal gabatà ku si Ruben asta si Simeon. ");
INSERT INTO bgs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Atin ka matà ka pa, dì kud imun na mga gabatà ku tô mga gabatà nu, asal tingód katô tanà na tanggapán ka mga rubbad ku ka matéya, mému masakup dan katô grupo katô kaké dan na si Efraim asta si Manases. ");
INSERT INTO bgs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tô gó é lumun ku para kandan tingód ka dakál ginawa ku katô innà nu na si Raquel. Tô igulì a tikud tun ta Mesopotamia, tuuwa iranu su inaté si Raquel tun ta Canaan madani tun ta lunsud ka Efrata. Iglábbáng ku sikandin madani tun ta dalan na gukitan tun ta lunsud ka Efrata.” (Tô lunsud ka Efrata, tô gó é ágngadanan Betlehem áknganni.) ");
INSERT INTO bgs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Na, tô igkita si Jacob katô duwa gabatà i Jose, iginsà sikandin, na mà din, “Sadan ni mga mallaki ni?” ");
INSERT INTO bgs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Igtaba si Jose, na mà din, “Ámmà, ni gó tô duwa gabatà ku na igbággé ka Manama kanak kannun ta Ehipto.” Igkagi si Jacob, na mà din, “Papadani nu sikandan, su dumasalla ébô madigár tô bággén ka Manama kandan.” ");
INSERT INTO bgs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tabag bólóg dán si Jacob su tugál dán sikandin. Purisu dì dán tuu ágkita sikandin. Igpapadani i Jose tô gabatà din, asta igkápkáppan asta igadákkan i Jacob sikandan. ");
INSERT INTO bgs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Igkagi si Jacob tun ki Jose, na mà din, “Ándà a panámdám na kumita a pa áknikó, asal ukit ka tabang ka Manama kanak, ikakita a pa áknikó asta kani mga gabatà nu.” ");
INSERT INTO bgs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Na, igkangé i Jose tô gabatà din, asta iglangkáb sikandin tun ta tubang katô ámmà din sippang ka ikadunggù tô ulu din tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Igawidan i Jose tô duwa gabatà din na si Efraim dadan tun ta ibang i Jacob, asta si Manases dadan tun ta kawanan. Igpapadani din puman sikandan tun ki Jacob. ");
INSERT INTO bgs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Asal igpagsungkálli i Jacob tô bállad din, su bállad din dadan tun ta kawanan tô igpabówwó din katô ulu i Efraim, agad adi sikandin, asta bállad din dadan tun ta ibang tô igpabówwó din katô ulu katô kaké na si Manases. ");
INSERT INTO bgs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Na, igdasal si Jacob ébô madigár tô bággén ka Manama kandan, na mà din, “Manama, sikuna tô ágpangadapán katô mga kamónaan ku na si Abraham asta si Isaac. Sikuna tô inalayun ágdóppón kanak sippang áknganni. ");
INSERT INTO bgs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Tô panaligan nu tô igpaluwà kanak ébô ándà gó makadadat kanak. Mólà pa ka madigár tô bággén nu kani duwa mallaki. Mólà pa ka dì gó kalingawan tô ngadan ku asta tô ngadan katô mga kamónaan ku na si Abraham asta si Isaac ukit kani duwa apù ku. Mólà pa ka kumarapung tô mga gabatà dan asta tô mga rubbad dan.” ");
INSERT INTO bgs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Na, tô igkita i Jose na si Efraim tô igpabówwówan katô kawanan bállad katô ámmà din, dì mému kandin. Purisu igawidan din tô bállad katô ámmà din ébô alinán din tun ta ulu i Manases. ");
INSERT INTO bgs_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Igkagi si Jose, na mà din, “Ámmà, ánnà nángngà, su ni gó tô kaké. Ni gó tô kailangan pabówwówan nu katô kawanan bállad nu.” ");
INSERT INTO bgs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Asal igéllé si Jacob, asta igkagi sikandin, na mà din, “Isóddóran ku, Jose! Isóddóran ku! Mému mabantug pagsik tô mga rubbad i Manases, asal tuu pa mabantug si Efraim, su imun marapung mga grupo tô mga rubbad din.” ");
INSERT INTO bgs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Purisu madigár tô kadasal din tingód kandan dalám katô álló ka kakagi din kani, na mà din, “Ákniyu ngadan tô gamitán katô mga rubbad ku ka kumustan dan tô duma mga manubù, su kumagi dan, ‘Mólà pa ka madigár tô bággén ka Manama ákniyu, iring na ágbággén din ki Efraim asta ki Manases.’” Ukit kani kadasal din, igimu i Jacob si Efraim na tuu pa mabantug ka tandingán ki Manases. ");
INSERT INTO bgs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Na, igkagi si Jacob tun ki Jose, na mà din, “Na, masiggad maté, asal dóppónan ka katô Manama, asta pólián din tô mga rubbad ta tun ta tanà na igóddóan katô mga kamónaan ta sayyan. ");
INSERT INTO bgs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tingód katô tanà ku tun ta Sikem, ánnà mga kataladi nu tô bággayan ku, asal sikuna tô bággayan ku. Tô gó é malambù tanà na igagó ku katô mga Amorihanon tô kasulung ku kandan ukit ka kampilan asta panà ku.” ");
INSERT INTO bgs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Na, igtawar i Jacob tô langun gabatà din gamama, asta igkagi sikandin, na mà din, “Padani kód dini kanak, su mulittad ákniyu tingód katô dumunggù ákniyu tun ta tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mga gabatà ku, padani kód dini kanak. Paminág kó kanak. ");
INSERT INTO bgs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Sikuna Ruben tô panganayan ku, tô bákkár ku, asta tô una kakilalaan ka kasarig ku. Tun ta langun kani mga gabatà ku, sikuna tô tuu ágkabantug asta tuu ágrespetowan. ");
INSERT INTO bgs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Asal iring ka katô wayig na ágbahà, su dì ka pakapáttud katô kakalyag nu. Purisu mandà tô bantug nu, su igpayayyà ka kanak ukit ka kalayuk nu katô sábbad sawa ku! ");
INSERT INTO bgs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Si Simeon asta si Levi, magunawa kó duwa, su ágtagnus kó ka laniban ébô lumumu kó ka madat. ");
INSERT INTO bgs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Diya maminág katô kagi yu. Diya mákkás ákniyu. Ukit katô sókó yu, ágmaté kó. Ukit katô dì kó pakapáttud, ágpantigan yu tô mga baka. ");
INSERT INTO bgs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Supakan kó katô Manama tingód katô sókó yu, su tuu kó magani asta tuu kó makamáddang! Passa-assaé tô mga rubbad yu asta makatalap dan tun ta mga lunsud katô duma mga rubbad ku. ");
INSERT INTO bgs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Sikuna Juda tô durungán kani mga kataladi nu. Makapanalu ka katô mga usig nu. Purisu lumingkóód tô mga kataladi nu tun ta tubang nu. ");
INSERT INTO bgs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, magani ka iring katô mannanap na ágngadanan liyun na ágdawi katô ágkakan din, asta gulì tun ta góddóan din asta ágdággà. Ándà manubù na sumamuk áknikó. ");
INSERT INTO bgs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Si Juda tô mawid ka tukád ka harì, su manayun tô mga rubbad din mangulu sippang ka dumunggù tô bánnal harì na bánnalán katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ikáttán din tô nati ka asno tun ta séngê ka paras na duwán tuu madigár buuy. Makému sikandin lumaba katô umpak din tun ta támmák ka buuy ka paras na inému bino, su tuu marapung tô mga buuy ka paras din. ");
INSERT INTO bgs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Tô mga mata din tuu pa mallutù ka tandingán katô bino, asta tô ngipán din tuu pa mapputì ka tandingán katô gatas. ");
INSERT INTO bgs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Si Zabulon tô móddô madani tun ta dagat. Angklaan tô mga barko tun ta góddóan din. Makatigatun sikandin katô tanà sippang tun ta Sidon. ");
INSERT INTO bgs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Si Isacar tô iring na mabákkár asno na inalayun ágdággà madani tun ta piniddan din. ");
INSERT INTO bgs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Asal ka kumita sikandin na madigár tô lunsud asta madigár tô tanà dutun, tumiis sikandin ka kahirapan, asta mággár-ággár sikandin lumumu iring na állang. ");
INSERT INTO bgs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Madigár tô kapid i Dan katô mga sakup din, iring na duma mga grupo ka mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Si Dan tô iring na áppuy tun ta ligad ka dalan na tumungkà katô paa ka kudà ébô madabù tô manubù na igsaké. ");
INSERT INTO bgs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Áglangngagán ku, gimanan ku tô katábbus nu kanak. ");
INSERT INTO bgs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Si Gad tô sulungán ka mga mangayó, asal atuwan din sikandan, asta agtaán din. ");
INSERT INTO bgs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Madigár tô káttun tun ta mga kinamát i Aser. Madigár tô makan na kangén tun kandin iring na madigár ágkakan ka harì. ");
INSERT INTO bgs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Si Neftali tô iring na saladáng na dì ágkammát. Madigár tô bónnóng katô mga gabatà din. ");
INSERT INTO bgs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Si Jose tô iring na kayu na igpamula madani tun ta sánnáp. Marapung tô buuy din, asta makadunggù tô mga panga din tun ta ágbaluy ka koral. ");
INSERT INTO bgs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Duwán mga manubù na sumulung kandin asta manà kandin, asta mirrayat kandin. ");
INSERT INTO bgs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Asal masarig tô panà din, asta mabákkár tô braso din tingód katô tabang ka Matulus Manama na ágpangadapán ku. Manama tô dumóppón asta pabákkár ka mga rubbad kani batà ku. ");
INSERT INTO bgs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tô Manama na ágpangadapán ku, tô gó é tumabang ákniyu. Tô Manama na matulus, tô gó é mággé ákniyu ka madigár. Sikandin tô mággé ákniyu ka udan tikud tun ta langit, asta wayig na ágsánnáp tikud tun ta siráb ka tanà. Sikandin tô mággé ákniyu ka marapung mga mannanap asta marapung mga gabatà. ");
INSERT INTO bgs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Igbággayanna ka Manama ka madigár na tuu pa dakál ka tandingán katô mga pabungan, asta tuu pa dakál ka tandingán katô ágkáttun tun ta mga pabunganán na ándà ágtamanán. Jose, mólà pa ka bággayan ka ka Manama kani langun, su igsalin ka ikandin tun ta langun kataladi nu. ");
INSERT INTO bgs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Si Benjamin tô iring na magani mannanap ka kabánnássan na ágngadanan lobo, su ka sállám ágmaté sikandin ka mga usig din, asta ka mapun ágkangén din tô kaduwánnan dan.” ");
INSERT INTO bgs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tô gó é mga gabatà gamama i Jacob na inému sapulù duwa (12) grupo tun ta Israel, asta tô gó é igkagi katô ámmà dan tô igpanalan sikandin kandan. Nángngà tô igkagi din tun ta tagsábbad-sábbad kandan. ");
INSERT INTO bgs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Na, duwán igpanalan i Jacob katô mga gabatà din, na mà din, “Masiggad tumalundug katô mga kamónaan ku na inaté. Lábbángnga tun ta iglábbángngan katô mga kamónaan ku tun ta takub katô tanà na itigatun i Efron na Hetihanon ");
INSERT INTO bgs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","tun ta Macpela dadan tun ta silatan ka lunsud ka Mamre tun ta Canaan. Tô gó é takub asta tô tanà na igbálli i Abraham ki Efron ébô duwán lábbángnganan din. ");
INSERT INTO bgs_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Iglábbángngan ki Abraham asta katô sawa din na si Sara. Iglábbángngan ki Isaac asta katô sawa din na si Rebecca. Iglábbángngan ku ki Lea. ");
INSERT INTO bgs_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tô tanà asta tô takub igbálli tikud tun ta mga Hetihanon sayyan.” ");
INSERT INTO bgs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Pángnga igpanalan si Jacob katô mga gabatà din, igdággà sikandin, asta inaté. ");
INSERT INTO bgs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Na, igkápkáp si Jose katô ámmà din, asta igsággó asta igadákkan din é báttuk. ");
INSERT INTO bgs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Na, igkagi si Jose na pabalsamarán tô lawa katô ámmà din. ");
INSERT INTO bgs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dalám ka kappatan (40) álló tô kadugayan ka kabalsamar dan kandin yan pa ágkapángnga, su tô gó é kadugayan ka kabalsamar ka mga taga Ehipto. Igranu tô mga taga Ehipto ki Jacob dalám ka kapittuwan (70) álló. ");
INSERT INTO bgs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tô ipángnga tô ranu dan kandin, igkagi si Jose tun ta mga opisyales ka harì, na mà din, “Atin ka duwán kédu yu kanak, ulit yu ni kagi ku tun ta harì. ");
INSERT INTO bgs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tô ándà pa kamaté tô ámmà ku, igtandô a kandin na lábbángngán ku sikandin tun ta lábbángnganan na igtaganà din dán tun ta Canaan. Purisu ka mému áknikó, madunna ébô lábbángngán ku, asta mulì a dini.’” ");
INSERT INTO bgs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Igtaba tô harì, na mà din, “Óó. Pid nu asta lábbáng nu tô ámmà nu, su tô gó é igtandô nu kandin.” ");
INSERT INTO bgs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Purisu igpanó si Jose ébô lábbángngán din tô ámmà din tun ta Canaan. Igtákkássan sikandin katô langun opisyales katô harì, mga ágtugállán na ágsarigan katô harì, asta duma mga manubù na ágkangadanan tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Igtákkás pagsik tô langun katô pamilya i Jose, tô mga kataladi din, asta tô langun manubù tun ta pamilya katô ámmà din. Ándà patákkássi tô marénták mga gabatà, tô mga karnero, tô mga kambing, asta tô mga baka, asal igóddô dan tun ta banuwa ka Gosen. ");
INSERT INTO bgs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Igtákkás pagsik tô mga manubù na igsaké ka mga kalesa asta mga kudà. Tuu marapung tô mga manubù na igsadun tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Na, tô igdunggù dan tun ta garikanan tun ta Atad dipag ka Wayig ka Jordan, idugé dan igdarawit. Iranu si Jose katô ámmà din dalám ka pittu álló. ");
INSERT INTO bgs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tô igkita katô mga Canaanhon tô ranu dan tun ta Atad, igkagi sikandan, na mà dan, “Tuu iranu tô mga taga Ehipto!” Purisu igngadanan tô lugar na Abel Misraim ");
INSERT INTO bgs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Purisu igtuman katô mga gabatà i Jacob tô igpanalan din kandan. ");
INSERT INTO bgs_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Igpid dan tô lawa din tun ta Canaan, asta iglábbáng dan tun ta takub ka Macpela dadan tun ta silatan ka lunsud ka Mamre. Tô gó é takub asta tanà na igbálli i Abraham ki Efron na Hetihanon ébô duwán lábbángnganan din. ");
INSERT INTO bgs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pángnga iglábbáng si Jose katô ámmà din, igulì sikandin tun ta Ehipto na igtákkássan katô mga kataladi din asta langun katô duma mga manubù na igtákkás kandin. ");
INSERT INTO bgs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Na, su inaté dán si Jacob, igpatóngkóé tô mga kataladi i Jose, na mà dan, “Pamánnu ki ka kasókówan ki i Jose, asta ka sumulì sikandin áknita tingód katô madat na iglumu ta kandin?” ");
INSERT INTO bgs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Purisu igpólit dan tô kagi dan tun ki Jose, na mà dan, “Tô ándà pa kamaté tô ámmà ta, ");
INSERT INTO bgs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","igtalan sikandin na ulitan dé sikuna katô kagi din, na mà din, ‘Mólà pa ka pasinsiyaan nu tô mga kataladi nu na iglumu áknikó ka madat dángngan.’ Purisu pasinsiyayi ké na mga ágsuguánnán ka Manama na ágpangadapán katô ámmà ta.” Tô igdinág si Jose katô kagi dan, igsággó sikandin. ");
INSERT INTO bgs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Na, igsadun tô mga kataladi din tun kandin, asta iglingkóód dan. Igkagi sikandan, na mà dan, “Igsadun ké dini áknikó ébô mému ké na mga állang nu.” ");
INSERT INTO bgs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Asal igkagi si Jose, na mà din, “Yakó ágkamáddangan kanak. Ánnà sakán tô rumuud ákniyu, su Manama dád tô nángngà rumuud. ");
INSERT INTO bgs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Agad madat tô iglumu yu kanak, asal igimu yan katô Manama na madigár, su igimuwa ikandin na gobernador ébô marapung tô mga manubù na dì maté ka ballus. Purisu sippang áknganni, manté ki pô. ");
INSERT INTO bgs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Yakó ágkamáddangan, su sakán tô dumóppón ákniyu asta katô mga pamilya yu.” Madigár tô kagi din kandan ébô dì dan maranu. ");
INSERT INTO bgs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Igóddô pa tun ta Ehipto si Jose asta tô langun rubbad katô ámmà din. Ikadunggù ka sábbad gatus sapulù (110) tô idad din. ");
INSERT INTO bgs_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ikakita pô sikandin katô mga apù din ka abul, na mga apù i Efraim. Ikakita pô pagsik sikandin katô mga apù din ka abul, na mga gabatà i Makir na batà i Manases, asta igsipit din sikandan. ");
INSERT INTO bgs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Na, tô ándà pa kamaté si Jose, igkagi sikandin tun ta mga kataladi din, na mà din, “Masiggad gó maté, asal yakó ágkatanaan, su inalayun kó dóppónan ka Manama, asta piddán kó ikandin tikud kannun ta banuwa ni. Pólián kó ikandin tun ta Canaan na igtandô din katô mga kamónaan ta na si Abraham, si Isaac, asta si Jacob.” ");
INSERT INTO bgs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Na, igpatandô i Jose tô duma mga rubbad i Jacob, na mà din, “Tandô kó kanak na piddán yu tô mga tullan ku ka pólián kód katô Manama tun ta Canaan.” ");
INSERT INTO bgs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Purisu inaté si Jose tun ta Ehipto na sábbad gatus sapulù (110) tô idad din. Igpabalsamar dan tô lawa din, asta igtagù dan tun ta lungun.");
INSERT INTO bgs_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ni gó tô mga gabatà gamama i Jacob asta tô tagsábbad-sábbad pamilya dan na igtákkás kandin tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Si Ruben, si Simeon, si Levi, si Juda, ");
INSERT INTO bgs_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","si Isacar, si Zabulon, si Benjamin, ");
INSERT INTO bgs_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","si Dan, si Neftali, si Gad, asta si Aser. ");
INSERT INTO bgs_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Tô timpo tô, taganà dán si Jose dutun ta Ehipto. Tô langun kani mga gamama na rubbad i Jacob igdunggù ka kapittuwan (70). ");
INSERT INTO bgs_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Na, tô iglabé dán tô pira ámmé, inaté si Jose, tô mga kataladi din, asta tô langun manubù na manté tô timpo i Jose. ");
INSERT INTO bgs_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Asal marapung tô mga gabatà dan asta mga apù dan. Ándà kadugé, igmarapung tô mga rubbad i Israel, asta italap dan gó tun ta kaluwagan ka banuwa ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Na, duwán mantu harì tun ta Ehipto na ándà sóddór din tingód ki Jose. ");
INSERT INTO bgs_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Igkagi sikandin katô mga sakup din, na mà din, “Tuu marapung asta tuu pa mabákkár tô mga rubbad i Israel ka tandingán áknita. ");
INSERT INTO bgs_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Purisu kailangan mamasak ki ka kapókit ébô dì dan kumarapung, su atin ka duwán gira, malát dan tun ta mga usig ta, matu dan áknita, asta miwà dan tikud tun ta banuwa ta.” ");
INSERT INTO bgs_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Purisu igimu dan tô mga rubbad i Israel na iring na mga állang, asta duwán mga taga Ehipto na igimu na amo dan, su kakalyag dan na kahirapan tô mga rubbad i Israel ukit ka kalumu dan katô mabággat. Igpirit dan na igpému katô mga lunsud ka Pitom asta Rameses ébô duwán áglimudanan katô mga ágkakan para katô harì ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Agad tuu dan igpahirapan katô mga taga Ehipto, asal tuu gó igmarapung tô mga rubbad i Israel, asta italap dan tun ta Ehipto. Purisu ágkamáddangan tô mga taga Ehipto tingód katô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Purisu tuu dan igpahirapan tô kóddô katô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tuu dan gó igpahirapan su igpirit dan igpému ka mga materyales ka balé asta áglumu kada álló tun ta mga kinamát. Ándà kédu dan kandan. ");
INSERT INTO bgs_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Na, igkagiyan katô harì ka Ehipto si Sipra asta si Pua na mga mabaliyan katô mga gabayi ka Hebreo, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Atin ka gawat kó katô mga gabayi ka Hebreo, matayi yu tô mga gabatà gamama, asal yakó yu ágmatayi tô mga gabatà gabayi.” ");
INSERT INTO bgs_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Asal tuu ágkamáddangan tô mga mabaliyan tun ta Manama. Purisu ándà dan bánnali tô sugù katô harì. Ándà dan matayi tô mga gabatà gamama. ");
INSERT INTO bgs_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Na, igpatawar katô harì sikandan, asta iginsà, na mà din, “Manan man ka ándà yu bánnali tô sugù ku ákniyu na kailangan matayan yu tô mga gabatà gamama?” ");
INSERT INTO bgs_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Igtaba dan, na mà dan, “Sir, magani tô mga gabayi ka Hebreo, asta sékót dan gó ágpamasusu, su tô dì ké pa ágdunggù, áglássut dán tô gabatà dan. Dì dan ágkatággasan iring katô mga gabayi ka taga Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Tingód katô máddang ka mga mabaliyan tun ta Manama, inéduwan tô Manama kandan, asta igbággayan din sikandan ka mga pamilya. Purisu tô mga rubbad i Israel ágpanayun na ágrubbad, asta inalayun dan igmabákkár. ");
INSERT INTO bgs_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Na, igsugù katô harì tô langun sakup din, na mà din, “Antug yu tun ta Wayig ka Nilo tô langun gabatà gamama ka Hebreo na mantu ipamasusu, asal yakó yu gapili tô mga gabatà dan gabayi.” ");
INSERT INTO bgs_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Na, duwán sábbad mama asta sábbad bayi tun ta mga rubbad i Levi na igpakalyagé. ");
INSERT INTO bgs_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Igmabáddás tô bayi, asta igpamasusu ka mama. Igkita din na madigár é bónnóng katô batà, asta igállás din dalám ka tállu bulan. ");
INSERT INTO bgs_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Asal su dì dán gó mému állássán tô batà, igkangé katô innà din tô sábbad basket na igimu tikud tun banban na igtapóngan ka ispalto ébô dì makahu tô wayig. Igdalám din tô batà tun ta basket asta igpakapó tun ta ligad ka wayig na sigbáttán. ");
INSERT INTO bgs_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Igtindág tun ta madiyù puri tô tábbé katô batà ébô sumállág ka mamánnu tô batà. ");
INSERT INTO bgs_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ándà kadugé, igdunggù tô prinsesa tun ta wayig ébô madigus, róggun igpanó-panó tô mga ágsuguánnán din tun ta ligad katô wayig. Igkita katô prinsesa tô basket tun ta ligad ka wayig na sigbáttán, asta igsugù din tô ágsuguánnán din ébô kangén. ");
INSERT INTO bgs_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Igpókéan katô prinsesa tô basket asta igkita din tô batà. Igsággó tô batà, asta inéduwan tô prinsesa kandin. Igkagi sikandin, na mà din, “Hebreo ni batà ni.” ");
INSERT INTO bgs_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Na, igpadani tô tábbé katô batà, asta iginsà din tô prinsesa, na mà din, “Malyag ka na mangéya ka sábbad innà ka Hebreo ébô pasusun din ni batà para áknikó?” ");
INSERT INTO bgs_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Igtaba tô prinsesa, na mà din, “Óó. Kangé ka gó.” Purisu igpalaguy tô bayi, asta igkangé din tô innà katô batà. ");
INSERT INTO bgs_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Igkagi tô prinsesa kandin, na mà din, “Pid nu ni batà, asta pasusu nu sikandin. Tandanan ku sikuna.” Purisu igpid katô innà tô batà din, asta igpasusu din. ");
INSERT INTO bgs_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tô dakál dán puri tô batà, igpid katô innà din tun ta prinsesa, asta igimu katô prinsesa na kandin sarili batà. Igkagi sikandin, na mà din, “Igkangé ku sikandin tikud tun ta wayig.” Purisu igngadanan din tô batà ki Moises. ");
INSERT INTO bgs_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Na, tô iglabé tô pira ámmé asta dakál dán si Moises, duwán álló na igahà sikandin katô mga unawa din na Hebreo, asta igkita din na ágpiritán dan ágpalumun ka mabággat. Igkita din tô sábbad taga Ehipto na áglagpás katô sábbad Hebreo na állang. ");
INSERT INTO bgs_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Igsérê-sérê si Moises agó duwán kumita kandin, igmatayan din tô taga Ehipto, asta igtambunan din ka baklayan. ");
INSERT INTO bgs_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Pagkasimag, iglónód puman sikandin, asta igkita din tô duwa Hebreo na ágpamatayé. Igkagiyan din tô ikasalà, na mà din, “Manan ka áglagpássán nu tô unawa nu?” ");
INSERT INTO bgs_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Igtaba sikandin, na mà din, “Ándin é katundanan nu? Sadan tô igimu áknikó na mangulu asta rumuud áknami? Matayanna ikuna iring katô kamaté nu katô taga Ehipto bani?” Tuu imáddangan si Moises, su igpanámdám sikandin na ikasóddór kannê tô langun manubù tingód katô iglumu din. ");
INSERT INTO bgs_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Na, tô ikasóddór tô harì katô iglumu i Moises, kakalyag din na matayan si Moises. Asal igpalaguy si Moises tun ta Midian. Tô igdunggù dán si Moises tun ta Midian, igunsad sikandin madani tun ta sábbad balun. ");
INSERT INTO bgs_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Na, duwán parì ka Midian na si Jetro, asta duwán pittu gabatà din gabayi. Ágsadun tô mga gabayi tun ta balun ébô mangé ka wayig na inámmán katô mga karnero asta mga kambing katô ámmà dan. ");
INSERT INTO bgs_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Asal duwán ássa mga taradóppón ka karnero na ágdunggù, asta ágpéwaán dan tô mga gabayi asta tô mga mannanap dan. Asal igtabangan i Moises tô mga gabayi ébô dì dan péwaán, asta igkangé din tô wayig ébô minám tô mga mannanap dan. ");
INSERT INTO bgs_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Tô igulì dan tun ta ámmà dan na si Jetro, iginsà sikandin, na mà din, “Manan ka sékót kó ikólì?” ");
INSERT INTO bgs_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Igtaba dan, na mà dan, “Duwán sábbad taga Ehipto na igtabang áknami, asta ándà ké péwai katô ássa mga tarabanté ka karnero. Igkangé pô gó sikandin ka wayig para áknami, asta igpénám din tô mga mannanap dé.” ");
INSERT INTO bgs_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Iginsà tô ámmà dan, na mà din, “Ánda sikandin? Manan ka ándà yu gó patákkássi? Lónódi yu sikandin, asta pasadun yu dini ébô kuman sikandin duma áknita.” ");
INSERT INTO bgs_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ignunug si Moises, asta igtákkás kandan. Igóddô sikandin tun kandan, asta igpakalyagan i Jetro ki Moises tô batà din na si Sefora. ");
INSERT INTO bgs_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Na, igbatà si Sefora ka mama, asta igngadanan i Moises tô batà din ki Gerson, su mà din, “Ánnà a tigbanuwa kannun.” ");
INSERT INTO bgs_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Tô iglabé dán tô pira ámmé, inaté tô harì ka Ehipto. Asal tuu pô gó mappait tô kahirapan katô mga rubbad i Israel tingód ka kallang kandan. Igpédu-édu dan ka tabang ka Manama kandan. ");
INSERT INTO bgs_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Igpaminág tô Manama katô mga arangán dan, asta isampáttan din tô kasabotan din ki Abraham, ki Isaac, asta ki Jacob. ");
INSERT INTO bgs_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Igkita din na mappait tô minókitan katô mga rubbad i Israel, asta inéduwan sikandin kandan. ");
INSERT INTO bgs_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Na, igdóppón si Moises katô mga karnero asta mga kambing katô ugang din na si Jetro na parì tun ta Midian. Duwán sábbad álló na igpid din tô mga mannanap tun ta disyerto sippang tun ta Sinai na pabungan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Igpakita kandin tô panaligan na YAHWEH na Áglangngagán tun ta mabbabà kayu na ágrágrág. Isalábbuan si Moises su agad igrágrág tô mabbabà kayu, asal ándà kagóbbó. ");
INSERT INTO bgs_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Igpanámdám sikandin, na, “Manan ka ándà gó kagóbbó tô mabbabà kayu? Padaniyan ku, asta ahaán ku ni kasalábbuan ni.” ");
INSERT INTO bgs_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tô igkita tô YAHWEH na igpadani si Moises, igtawar sikandin tikud tun ta tángngaan katô mabbabà kayu, na mà din, “Moises, Moises!” Igtaba si Moises, na mà din, “Kannunna.” ");
INSERT INTO bgs_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Igkagi tô Manama, na mà din, “Yaka ágpadani. Lusut nu yan sandalyas nu, su ugis ni lugar na ágtindággan nu. ");
INSERT INTO bgs_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Sakán tô Manama na ágpangadapán katô mga kamónaan nu. Sakán tô ágpangadapán i Abraham, si Isaac, asta si Jacob.” Purisu igtambunan i Moises tô báttuk din su imáddangan sikandin agó kasállággan din tô Manama. ");
INSERT INTO bgs_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Igkagi tô Áglangngagán, na mà din, “Igkita ku na igpahirapan tô mga sakup ku tun ta Ehipto, asta igdinág ku tô karangin dan kanak tingód katô madat mga amo dan. Isóddóran ku tô katiis dan katô mga kahirapan. ");
INSERT INTO bgs_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Purisu igsunnadda ébô paluwaán kud sikandan tikud tun ta bállad katô mga taga Ehipto, asta péwaán kud sikandan tikud tun ta banuwa ka Ehipto. Piddán ku sikandan tun ta ássa banuwa na madigár gó asta tuu malambù. Bággén ku kandan tô kaluwagan katô banuwa na igóddóan katô mga Canaanhon, mga Hetihanon, mga Amorihanon, mga Perisihanon, mga Hebihanon, asta mga Jebusihanon. ");
INSERT INTO bgs_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Igdinág ku tô karangin katô mga rubbad i Israel, asta igkita ku na tuu dan igpahirapan katô mga taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Purisu papiddán ku sikuna tun ta harì ka Ehipto. Sikuna tô mid katô mga sakup ku na mga rubbad i Israel tikud tun ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Asal igkagi si Moises, na mà din, “Mabbabà é kamanubuan ku. Dì mému na sakán tô pasadunán nu tun ta harì ébô mid katô mga rubbad i Israel tikud tun ta Ehipto!” ");
INSERT INTO bgs_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Igkagi tô Manama, na mà din, “Tákkássan ku sikuna, asta pángnga péwaán ku sikiyu na mga rubbad i Israel tikud tun ta Ehipto, mangadap kó langun kanak nit pabungan ni. Ukit kani, kasóddóran nu na sakán tô igpapid áknikó.” ");
INSERT INTO bgs_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Asal igkagi si Moises tun ta Manama, na mà din, “Atin ka sadunan ku tô mga rubbad i Israel, asta kagiyan ku sikandan, na ‘Tô Manama na ágpangadapán katô mga kamónaan ta tô igpapid kanak dini ákniyu,’ dì dan mánnal kanak, su minsà sikandan na, ‘Sadan tô ngadan kani manama ni?’ Ándin é taba ku kandan?” ");
INSERT INTO bgs_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Igkagi tô Manama, na mà din, “Sakán gó tô sakán. Kagiyi nu tô mga rubbad i Israel, na ‘Tô ágpatawar katô sarili din na sakán, sikandin gó tô igpapid kanak dini ákniyu.’” ");
INSERT INTO bgs_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Na, igkagi puman tô Manama, na mà din, “Ni gó tô kagin nu tun ta mga rubbad i Israel, ‘Tô YAHWEH na Áglangngagán na Manama na ágpangadapán katô mga kamónaan yu sayyan na si Abraham, si Isaac, asta si Jacob, sikandin gó tô igpapid kanak dini ákniyu.’ Ni gó tô ngadan ku sippang ka ándà ágtamanán. Ni gó tô ngadan ku na kailangan gamitán katô langun rubbad yu ka dumasal dan kanak. ");
INSERT INTO bgs_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Saduni nu asta limud nu tô mga ágpangulun katô mga rubbad i Israel, asta kagiyi nu sikandan, ‘Tô YAHWEH na Áglangngagán na Manama na ágpangadapán katô kamónaan yu na si Abraham, si Isaac, asta si Jacob, tô gó tô igpakita kanak. Igkagi sikandin, na mà din: Isóddóran ku asta igkita ku tô mga madat na iglumu katô mga taga Ehipto ákniyu. ");
INSERT INTO bgs_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Tumandô a ákniyu na péwaán ku sikiyu tikud tun ta kahirapan yu tun ta Ehipto. Piddán ku sikiyu tun ta banuwa na igóddóan katô mga Canaanhon, mga Hetihanon, mga Amorihanon, mga Perisihanon, mga Hebihanon, asta mga Jebusihanon. Tuu gó malambù tô tanà dutun.’ ");
INSERT INTO bgs_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Maminág tô mga ágpangulun áknikó. Patákkás ka kandan tun ta harì ka Ehipto, asta kagiyi yu sikandin, na, ‘Igpakita áknami tô Áglangngagán na Manama na ágpangadapán katô mga Hebreo. Purisu pasadun ké tun ta disyerto tun ta kadiyuan na tállu álló panón ébô mággé ké katô kailangan bággén tun ta Áglangngagán na Manama dé.’ ");
INSERT INTO bgs_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Asal isóddóran ku na dì kó gó papanón katô harì ka Ehipto sippang ka kasóddóran din na tuuwa matulus. ");
INSERT INTO bgs_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Purisu gamitán ku tô katulusan ku, asta supakan ku tô mga taga Ehipto ukit katô mga kasalábbuan na lumun ku. Ukit katô lumun ku, papanón din sikiyu ébô miwà kó. ");
INSERT INTO bgs_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ukit katô lumun ku kandan, respetowan kó katô mga taga Ehipto. Purisu ka miwà kó, tuu dakál tô bággén dan ákniyu asta piddán yu. ");
INSERT INTO bgs_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tô tagsábbad-sábbad bayi na mga rubbad i Israel mamuyù katô mga simbalé dan na taga Ehipto asta tikud tun ta mga gabayi na góddô tun ta balé dan. Pamuyuán dan tô mga umpak, tô mga salagbat, tô mga pangkis, asta tô mga bulawan arites. Pómpak yu ni tun ta mga gabatà yu. Ukit katô kapamuyù yu kandan, piddán yu tô langun kaduwánnan katô mga taga Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Igtaba si Moises katô Áglangngagán, na mà din, “Asal dì mánnal tô mga rubbad i Israel kanak. Dì dan maminág katô kagin ku kandan, su kumagi dan, na, ‘Ándà gó pakita tô Áglangngagán áknikó,’” ");
INSERT INTO bgs_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Igkagi tô Áglangngagán, na mà din, “Ándin yan gawidan nu?” Igtaba si Moises, na mà din, “Tukád ku.” ");
INSERT INTO bgs_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Igkagi tô Áglangngagán, na mà din, “Dabù nu yan tun ta tanà.” Tô igdabù dán i Moises tô tukád din tun ta tanà, minému na áppuy, asta igpalaguy si Moises. ");
INSERT INTO bgs_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Na, igkagi tô Áglangngagán, na mà din, “Awidi nu yan ikug din.” Purisu igawidan i Moises tô ikug, asta inému dán puman na tukád. ");
INSERT INTO bgs_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Igkagi tô Áglangngagán, na mà din, “Lumu nu ni kasalábbuan ébô mánnal dan na igpakita áknikó tô Áglangngagán na Manama na ágpangadapán katô mga kamónaan dan na si Abraham, si Isaac, asta si Jacob.” ");
INSERT INTO bgs_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Na, igkagi puman tô Áglangngagán ki Moises, na mà din, “Dalám nu yan bállad nu yan ta umpak nu.” Igbánnal si Moises, asta tô igpaluwà din tô bállad din, isalábbuan sikandin su iglamputì dán tô bállad din ka téték. ");
INSERT INTO bgs_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Igkagi tô Áglangngagán, na mà din, “Dalám nu puman yan bállad nu yan ta umpak nu.” Igbánnal si Moises, asta tô igpaluwà din tô bállad din, isalábbuan gó sikandin, su minólian dán iring katô tibuk lawa din. ");
INSERT INTO bgs_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Igkagi tô Áglangngagán, na mà din, “Atin ka dì dan maminág áknikó asta ka dì dan mánnal tingód katô una kasalábbuan, mánnal dan kani ikaduwa kasalábbuan. ");
INSERT INTO bgs_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Asal ka dì dan mánnal kani duwa kasalábbuan, asta ka dì dan maminág katô ágkagin nu, kangé ka ka wayig ka Nilo, asta busbus nu tun ta tanà, su tô wayig mému na dipanug.” ");
INSERT INTO bgs_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Igkagi si Moises, na mà din, “Áglangngagán, ándà gó kakatigan ku na gulit-ulit, agad dángngan ó agad nigó ukit katô katóngkô nu kanak. Asal diya tuu pakabólós, asta ándà sóddór ku ka ándin tô madigár kagin ku.” ");
INSERT INTO bgs_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Asal igkagi tô Áglangngagán kandin, na mà din, “Sadan tô igimu katô mga manubù ébô makakagi dan? Sadan tô igimu katô mga manubù na ómmó, ó bingál, ó makakita, ó bólóg? Sakán dád na Áglangngagán tô makému! ");
INSERT INTO bgs_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Purisu panó ka, su tabangan ku sikuna ébô nángngà tô kakagi nu, asta ulitán ku áknikó ka ándin tô kagin nu.” ");
INSERT INTO bgs_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Asal igkagi si Moises, na mà din, “Áglangngagán, pasinsiyayiya. Atin ka mému, ássa dád tô suguán nu.” ");
INSERT INTO bgs_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Purisu isókó tô Áglangngagán ki Moises, asta igkagi sikandin, na mà din, “Duwán kataladi nu na si Aaron na Levita. Ikasóddórra na katig sikandin ágkagi-kagi. Igpanó dán sikandin ébô sumumar áknikó. Kadayawan sikandin ka kumita áknikó. ");
INSERT INTO bgs_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Sikandin dád tô pakagin nu katô kakalyag nu kagin. Tabangan ku sikiyu kumagi, asta kagiyan ku sikiyu ka ándin tô lumun yu. ");
INSERT INTO bgs_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Si Aaron tô taraulit katô kagi nu tun ta mga manubù. Méring ka na Manama tun ki Aaron, su mulit sikandin katô kagi nu, iring na propeta na gulit katô kagi ka Manama tun ta mga manubù. ");
INSERT INTO bgs_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Pid nu yan tukád nu, su yan gó tô gamitán nu ébô imun nu tô mga kasalábbuan.” ");
INSERT INTO bgs_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Na, iglónód si Moises tun ta ugang din na si Jetro, asta igkagi sikandin, na mà din, “Atin ka mému áknikó, lumónódda tun ta mga gakád ku tun ta Ehipto ébô kasóddóran ku ka manté pô sikandan.” Ignunug si Jetro, asta igkagi sikandin, na mà din, “Mólà pa ka madigár tô kapanó nu.” ");
INSERT INTO bgs_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Tô ándà pa panó si Moises tikud tun ta Midian, igkagi tô Áglangngagán kandin, na mà din, “Lónód ka tun ta Ehipto, su inaté dán tô langun manubù na malyag mimmaté áknikó.” ");
INSERT INTO bgs_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Purisu igpid i Moises tô sawa din asta tô mga gabatà din gamama, asta igpasaké din tun ta asno. Igsadun dan tun ta Ehipto. Igpid din tô tukád na igpapid ka Manama kandin. ");
INSERT INTO bgs_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Igkagi tô Áglangngagán ki Moises, na mà din, “Atin ka dumunggù kad tun ta Ehipto, imu nu gó tô mga kasalábbuan tun ta tubang katô harì ukit katô katulusan na igbággé ku áknikó. Asal patággasán ku tô ulu din ébô dì din péwaán tô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kagiyi nu tô harì, ‘Ni gó tô kagi katô Áglangngagán áknikó: Tô mga rubbad i Israel iring gó na sarili batà ku, iring na tambang kaké batà ku. ");
INSERT INTO bgs_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Igkagiyan ku sikuna na kailangan péwaán nu tô batà ku ébô mangadap sikandin kanak. Asal su igéllé ka, matayan ku tô tambang kaké batà nu mama.’” ");
INSERT INTO bgs_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Tô igdággà dan tun ta dalan, igpadani tô Áglangngagán tun ki Moises ébô matayan pád sikandin. ");
INSERT INTO bgs_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Asal igawid si Sefora ka matam batu, asta igtupuwan din tô batà din. Igpólét din tô kindal na igtampád tun ta pusù din. ");
INSERT INTO bgs_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Purisu ándà matayi katô Áglangngagán si Moises. Na, igkagi si Sefora ki Moises, na mà din, “Sikuna tô duma ku na igdaddasan ka dipanug!” Tô gó é igkagi din tingód katô katupu din katô batà din. ");
INSERT INTO bgs_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Na, igkagi tô Áglangngagán ki Aaron, na mà din, “Sadun ka tun ta disyerto, asta sumar nu si Moises.” Purisu igpanó si Aaron, asta igkita din si Moises tun ta Sinai na pabungan ka Manama. Tô igpakitaé dan, igadákkan din si Moises. ");
INSERT INTO bgs_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Igulitan i Moises si Aaron katô langun na igkagi katô Áglangngagán kandin tingód katô lumun din asta kagin din. Igulitan din tingód katô langun kasalábbuan na palumun katô Áglangngagán kandin. ");
INSERT INTO bgs_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Purisu igsadun si Moises asta si Aaron tun ta Ehipto, asta igpaglimud dan tô langun ágpangulun ka mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Igulit si Aaron kandan tingód katô langun na igkagi katô Áglangngagán ki Moises, asta igimu din tô langun kasalábbuan tun ta tubang dan. ");
INSERT INTO bgs_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Igbánnal dan na si Moises asta si Aaron tô igpapid katô Áglangngagán. Tô ikasóddór dan na inéduwan tô Áglangngagán katô mga rubbad i Israel, asta igkita tô Áglangngagán katô kahirapan dan, igunduk asta igpangadap dan. ");
INSERT INTO bgs_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Na, pángnga igpalimudé, igsadun si Moises asta si Aaron tun ta harì ka Ehipto, asta igkagi sikandan, na mà dan, “Ni gó tô kagi katô Áglangngagán na Manama na ágpangadapán katô mga rubbad i Israel: Péwà nud tô mga sakup ku ébô madun dan tun ta disyerto, su kailangan palimudé dan ébô pabantugánna ikandan.” ");
INSERT INTO bgs_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Asal igtaba tô harì, na mà din, “Sadan ni Áglangngagán? Manan ka kailangan bánnalán ku sikandin asta manan ka péwaán ku tô mga rubbad i Israel? Ándà a gó kilala kandin, asta dì ku gó péwaán tô mga rubbad i Israel.” ");
INSERT INTO bgs_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Na, igtaba si Moises asta si Aaron, na mà dan, “Igpakita áknami tô Manama na ágpangadapán katô mga Hebreo. Pasadun ké tun ta disyerto na ágkadunggù ka tállu álló ágpanón ébô mággé ké katô kailangan bággén tun ta Áglangngagán na Manama dé. Atin ka dì dé ni lumun, matayan ké ikandin ukit ka bógók ó gira.” ");
INSERT INTO bgs_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Igtaba tô harì, na mà din, “Yakó ágbaring katô mga manubù tun ta áglumun dan! Palónód yu tô langun állang tun ta mga áglumun dan! ");
INSERT INTO bgs_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Igmarapung dán gó ni mga manubù kannun ta Ehipto, asta pasódóán yu pád sikandan ébô dì dan lumumu!” ");
INSERT INTO bgs_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tô álló tô, igsugù katô harì tô mga ágsuguánnán din na taga Ehipto asta tô mga amo na mga rubbad i Israel, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Yakó ágbággé katô ragami tun ta mga manubù na ágbalát katô libutà asta ragami ébô duwán ágkagamit para gimun balé. Sikandan tô pakangén yu katô ragami. ");
INSERT INTO bgs_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Asal kailangan magunawa gó tô karapungan ka mga tisa na gimun dan. Yakó yu ágkulangi. Tukukán gó sikandan. Purisu ágrangin dan na péwaán ku sikandan ébô madun dan tun ta disyerto asta mággé dan tun ta manama dan. ");
INSERT INTO bgs_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Dugangi yu pa baling tô kailangan lumun dan ébô tuu dan ágkasasó tingód katô mga áglumun dan, asta dì dan dán maminág katô mga bulaló.” ");
INSERT INTO bgs_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Purisu igpanó tô mga ágsuguánnán din asta tô mga amo, asta igkagi sikandan katô mga rubbad i Israel, na mà dan, “Igsugù tô harì na dì kód bággayan ka ragami. ");
INSERT INTO bgs_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Sikiyu dán tô mangé katô ragami agad ánda, asal kailangan imun yu tô karapungan ka mga tisa na magunawa katô igimu yu tô iglabé.” ");
INSERT INTO bgs_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Purisu tô langun rubbad i Israel, igpanalap dan ka ragami tun ta kaluwagan ka banuwa ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Inalayun dan ágpiritán katô mga amo dan. Igkagi tô mga amo dan, na mà dan, “Imu yu tô karapungan ka mga tisa kada álló na magunawa katô igimu yu tô iglabé.” ");
INSERT INTO bgs_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Marag áglagpássán katô mga ágsuguánnán katô harì tô mga amo na rubbad i Israel. Ginsà dan, na mà dan, “Manan ka ándà kó ikému katô karapungan ka mga tisa ni álló ni na magunawa katô igimu yu tô iglabé?” ");
INSERT INTO bgs_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Na, tô mga amo na rubbad i Israel igsadun tun ta harì, asta igpédu-édu dan, na mà dan, “Sir, yaka ágpahirap áknami! ");
INSERT INTO bgs_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ándà dán ragami na ágbággén áknami, asal ágpémun ké pô gó katô karapungan ka mga tisa na magunawa katô igimu dé tô iglabé. Agad ándà salà dé, áglagpássán ké pô gó! Asal tô salà tun ta mga sakup nu.” ");
INSERT INTO bgs_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Asal igtaba tô harì, na mà din, “Tukukán kó gó! Ánnà kó malóggód áglumu! Purisu igpédu-édu kó na péwaán ku sikiyu ébô mággé kó tun ta Áglangngagán yu. ");
INSERT INTO bgs_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Lónód kó tun ta áglumun yu! Ándà ragami na bággén ákniyu, asal kailangan mimu kó katô karapungan ka mga tisa na magunawa katô igimu yu tô iglabé.” ");
INSERT INTO bgs_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Igkita tô mga amo ka mga rubbad i Israel na ándà gó mému dan ébô méwà tô kahirapan dan, su igsugù tô harì kandan na kailangan magunawa tô karapungan ka mga tisa na imun dan kada álló. ");
INSERT INTO bgs_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Tô igtananan dan tô harì, igsumar dan si Moises asta si Aaron na gangat kandan, ");
INSERT INTO bgs_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","asta igkagiyan dan, na mà dan, “Mólà pa ka kitanán pád katô Áglangngagán tô iglumu yu, asta supakan kó ikandin, su ukit ákniyu, miringasa tô harì asta tô mga opisyales din áknami. Igbággé yu kandan tô gunayan ébô matayan ké ikandan.” ");
INSERT INTO bgs_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Purisu igdasal dán puman si Moises tun ta Áglangngagán. Igkagi sikandin, na mà din, “Áglangngagán, manan ka igpadunggù nu ni kahirapan tun ta mga sakup nu? Manan ka igpapidda ikuna? ");
INSERT INTO bgs_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Su tikud gó katô katubang ku ka harì ébô ulitán ku tô kagi nu, igpahirapan din baling tô mga sakup nu, asta ándà palang tabang nu kandan!” ");
INSERT INTO bgs_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Asal igkagi tô Áglangngagán ki Moises, na mà din, “Dì madugé, kitanán nu tô lumun ku katô harì ka Ehipto. Atin kinnaman din tô katulusan ku, péwaán din tô mga sakup ku, asta piritán din gó sikandan ébô malaguy dan tikud tun ta banuwa din.” ");
INSERT INTO bgs_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Igkagi tô Manama ki Moises, na mà din, “Sakán tô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Igpakita a ki Abraham, ki Isaac, asta ki Jacob. Igpasóddór ku kandan na sakán tô Tuu Matulus Manama, asal ándà ku pasóddóri kandan tô ngadan ku na YAHWEH. ");
INSERT INTO bgs_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Igimu ku pagsik tô kasabotan tun kandan, su bággén ku kandan tô banuwa ka Canaan na igóddóan dan sayyan iring na mga bisita. ");
INSERT INTO bgs_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Igdinág ku tô mga arangán katô mga rubbad i Israel na igállang katô mga taga Ehipto, asta isampáttan ku tô kasabotan ku tun kandan. ");
INSERT INTO bgs_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Purisu ulit nu ni kagi ku tun ta mga rubbad i Israel, ‘Sakán tô Áglangngagán. Péwaán ku sikiyu tikud tun ta kallang ákniyu tun ta Ehipto. Ukit katô katulusan ku padungguan ku sikandan katô supak na makamáddang, asta tábbusán ku sikiyu. ");
INSERT INTO bgs_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Imun ku sikiyu na kanak mga manubù, asta mémuwa na Manama yu. Atin ka paluwaán ku sikiyu tikud tun ta kallang ákniyu tun ta Ehipto, kasóddóran yu na sakán tô Áglangngagán na Manama yu. ");
INSERT INTO bgs_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Piddán ku sikiyu tun ta banuwa na igtandô ku ki Abraham, ki Isaac, asta ki Jacob! Bággén ku ni banuwa ákniyu ébô matigatun yu. Sakán tô Áglangngagán.’” ");
INSERT INTO bgs_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Agad igulit ni i Moises tun ta mga rubbad i Israel, asal ándà dan paminág kandin, su inandaan dan dán ka gimanan tingód katô kahirapan ka kallang kandan. ");
INSERT INTO bgs_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Na, igkagi tô Áglangngagán ki Moises, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Lónód ka tun ta harì ka Ehipto, asta kagiyi nu sikandin na kailangan péwaán din tô mga rubbad i Israel tikud tun ta banuwa din.” ");
INSERT INTO bgs_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Asal igtaba si Moises, na mà din, “Atin ka dì maminág kanak tô mga rubbad i Israel, sobra pa na dì maminág tô harì, su diya tuu pakabólós ágkagi.” ");
INSERT INTO bgs_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Asal igsugù katô Áglangngagán si Moises asta si Aaron, na mà din, “Uliti yu tô mga rubbad i Israel asta tô harì na sikiyu tô igsugù ku ébô mid katô mga rubbad i Israel tikud tun ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ni gó tô mga kamónaan i Moises asta i Aaron. Si Ruben tô tambang kaké batà i Jacob. Duwán áppat gabatà din gamama, na si Hanoc, si Palu, si Hesron, asta si Carmi. Tô gó tô mga rubbad i Ruben. ");
INSERT INTO bgs_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Si Simeon duwán ánnám gabatà din gamama, na si Jemuel, si Jamin, si Ohad, si Jaquin, si Sohar, asta si Saul na batà katô bayi na Canaanhon. Tô gó tô mga rubbad i Simeon. ");
INSERT INTO bgs_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Si Levi duwán tállu gabatà din gamama, na si Gerson, si Cohat, asta si Merari. Igdunggù ka sábbad gatus tállu pulù pittu (137) tô idad i Levi. ");
INSERT INTO bgs_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Si Gerson duwán duwa gabatà din gamama, na si Libni asta si Simei. Marapung tô mga rubbad dan. ");
INSERT INTO bgs_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Si Cohat duwán áppat gabatà din gamama, na si Amram, si Isar, si Hebron, asta si Usiel. Igdunggù ka sábbad gatus tállu pulù tállu (133) tô idad i Cohat. ");
INSERT INTO bgs_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Si Merari duwán duwa gabatà din gamama, na si Mali asta si Musi. Tô gó tô mga rubbad i Levi. ");
INSERT INTO bgs_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Igkalyagan i Amram si Jocabed na tábbé katô ámmà din, asta igbatà si Jocabed ki Aaron asta ki Moises. Igdunggù ka sábbad gatus tállu pulù pittu (137) tô idad i Amram. ");
INSERT INTO bgs_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Si Isar duwán tállu gabatà din gamama, na si Core, si Nefeg, asta si Secri. ");
INSERT INTO bgs_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Si Usiel duwán tállu gabatà din gamama, na si Misael, si Elsafan, asta si Setri. ");
INSERT INTO bgs_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Igkalyagan i Aaron si Eliseba na batà i Aminadab asta tábbé i Nason. Igbatà sikandin ki Nadab, ki Abihu, ki Eleasar, asta ki Itamar. ");
INSERT INTO bgs_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Si Core duwán tállu gabatà din gamama, na si Aser, si Elcanas, asta si Abiasaf. Tô gó tô mga rubbad i Core. ");
INSERT INTO bgs_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleasar tô batà mama i Aaron. Igkalyagan din tô sábbad batà i Futiel, asta igbatà sikandin ki Pinehas. Ni gó tô mga kamónaan katô mga rubbad i Levi, asta mga pamilya dan. ");
INSERT INTO bgs_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Iglista tô ngadan i Moises asta i Aaron apil katô duma mga rubbad i Jacob. Sikandan tô igkagiyan katô Áglangngagán, na mà din, “Sikiyu tô mid katô mga rubbad i Israel tikud tun ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Si Moises asta si Aaron tô igkagi tun ta harì ébô péwaán din tô mga rubbad i Israel tikud tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Na, tô igtóngkô tô Áglangngagán ki Moises tun ta Ehipto, ");
INSERT INTO bgs_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","igkagi sikandin, na mà din, “Sakán tô Áglangngagán! Kagiyi nu tô harì ka Ehipto katô igkagi ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Asal igtaba si Moises, na mà din, “Su diya tuu pakabólós ágkagi, manan ka maminág tô harì kanak?” ");
INSERT INTO bgs_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Igkagi tô Áglangngagán ki Moises, na mà din, “Imun ku sikuna iring na Manama tun ta tubang katô harì ka Ehipto, asta imun ku tô kataladi nu si Aaron iring na propeta nu na kumagi tun ta harì. ");
INSERT INTO bgs_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kagiyi nu si Aaron katô langun na ágsuguán ku áknikó. Sikandin tô sumugù katô harì na kailangan péwaán din tô mga rubbad i Israel tikud tun ta banuwa din. ");
INSERT INTO bgs_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Asal patággasán ku tô ulu ka harì. Agad imun ku tô marapung mga kasalábbuan tun ta Ehipto, ");
INSERT INTO bgs_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","asal dì sikandin maminág áknikó. Purisu ukit katô katulusan ku, supakan ku tô mga taga Ehipto ukit ka marapung mga supak, asta sakán tô mid katô langun sakup ku tikud tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Atin ka pakitanán ku tô katulusan ku tun ta mga taga Ehipto, asta piddán ku tô mga rubbad i Israel tikud tun ta banuwa dan, kasóddóran dan na sakán tô Áglangngagán.” ");
INSERT INTO bgs_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Purisu igbánnal si Moises asta si Aaron katô igsugù ka Áglangngagán kandan. ");
INSERT INTO bgs_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tô igtubang si Moises asta si Aaron katô harì ka Ehipto, kawaluwan (80) tô idad i Moises, asta kawaluwan tállu (83) tô idad i Aaron. ");
INSERT INTO bgs_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Na, igkagi tô Áglangngagán ki Moises asta ki Aaron, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kumagi tô harì ka Ehipto ákniyu na kailangan duwán kasalábbuan na imun yu ébô kasóddóran din na igpapid kó ka Manama. Purisu kagiyi nu si Aaron na dabuán din tô tukád din tun ta tanà na tubang katô harì ébô mému na áppuy.” ");
INSERT INTO bgs_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Na, igsadun si Moises asta si Aaron tun ta harì, asta igimu dan tô kasalábbuan na igsugù katô Áglangngagán kandan. Igdabù i Aaron tô tukád din tun ta tanà na tubang katô harì asta mga opisyales din, asta inému na áppuy. ");
INSERT INTO bgs_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Na, igpatawar katô harì tô mapandé mga sakup din asta tô mga tarasalamangka, asta ukit katô mga salamangka dan igimu dan pagsik tô kasalábbuan na igimu i Aaron. ");
INSERT INTO bgs_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Igdabù dan tô kandan mga tukád tun ta tanà, asta inému na mga áppuy. Asal iglámmád katô tukád i Aaron tô kandan mga tukád. ");
INSERT INTO bgs_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Asal igmatággas tô ulu ka harì, asta igéllé sikandin na maminág ki Moises asta ki Aaron, magunawa katô taganà igkagi katô Áglangngagán kandan. ");
INSERT INTO bgs_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Tuu matággas tô ulu ka harì, asta dì din péwaán tô mga manubù. ");
INSERT INTO bgs_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Purisu simag ka sállám, atin ka madun tô harì tun ta Wayig ka Nilo, saduni nu sikandin. Pid nu tô tukád nu na inému áppuy, asta angati nu sikandin tun ta ligad katô wayig. ");
INSERT INTO bgs_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kagiyi nu sikandin, ‘Tô Áglangngagán na Manama na ágpangadapán katô mga Hebreo tô igpapid kanak dini áknikó ébô kagin ku áknikó na kailangan péwaán nu tô mga sakup din ébô mangadap dan kandin tun ta disyerto. Sippang áknganni igéllé ka asta ándà ka paminág kandin. ");
INSERT INTO bgs_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Na, igkagi katô Áglangngagán na duwán gó lumun din ébô kasóddóran nu na sikandin gó tô Áglangngagán. Gamitán ku ni tukád ku asta lagpássán ku ni Wayig ka Nilo ébô mému na dipanug. ");
INSERT INTO bgs_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Maté tô mga sáddà, asta kumawù ni wayig. Dì dán makénám tô mga taga Ehipto katô wayig tikud tun ta Nilo.’” ");
INSERT INTO bgs_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Na igkagi tô Áglangngagán ki Moises, na mà din, “Kagiyi nu si Aaron ébô tádduán din ka tukád tô langun wayig na garus tun ta Ehipto, agad tô tun ta mga kanal, tô tun ta mga basakán, asta tô tun ta mga lino. Mému dipanug tô wayig tun ta kaluwagan ka Ehipto, agad tô tun ta mga ágtaguanan na igimu ka kayu ó igimu ka batu.” ");
INSERT INTO bgs_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Purisu igbánnal si Moises asta si Aaron katô igsugù ka Áglangngagán kandan. Tun ta tubang katô harì asta mga opisyales din, igtáddù i Aaron tô tukád din, asta iglagpás din tô wayig. Inému na dipanug tô Wayig ka Nilo. ");
INSERT INTO bgs_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Inaté tô mga sáddà, asta igmawù tô wayig. Dì dán makénám tô mga taga Ehipto katô wayig. Inému tô wayig na dipanug tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Magunawa tô igimu katô mga tarasalamangka na taga Ehipto ukit katô kakatigan dan. Purisu matággas gó tô ulu ka harì. Ándà sikandin paminág ki Moises asta ki Aaron, magunawa katô taganà igkagi katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Igulì tô harì tun ta balé din, asta ándà din panámdámmi tô ilumu. ");
INSERT INTO bgs_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Igkali tô langun taga Ehipto tun ta ligad katô wayig ébô makakangé dan ka wayig na ginámmán, su dì gó ágkénám tô Wayig ka Nilo. ");
INSERT INTO bgs_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Iglabé tô pittu álló pángnga igimu ka Áglangngagán tô Wayig ka Nilo na dipanug. ");
INSERT INTO bgs_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Sadun ka tun ta harì ka Ehipto, asta kagiyi nu sikandin, ‘Ni gó tô igkagi katô Áglangngagán: Péwà nu tô mga sakup ku ébô mangadap dan kanak. ");
INSERT INTO bgs_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Asal ka méllé ka asta dì nu sikandan péwaán, ipánnuán ku gó tô kaluwagan ka Ehipto ka marapung mga bakbak. ");
INSERT INTO bgs_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mapánnù tô Wayig ka Nilo ka mga bakbak. Mahu tun ta balé nu, tun ta kuwarto nu, asta tun ta katri nu. Mahu tô mga bakbak tun ta mga balé katô mga opisyales nu, asta mga sakup nu. Mahu gó tô mga bakbak agad tun ta abu nu, asta tun ta ágmasaanan nu ka pan. ");
INSERT INTO bgs_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Láttuwan ka gó asta tô mga sakup nu, asta tô mga opisyales nu.’” ");
INSERT INTO bgs_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Igkagi tô Áglangngagán ki Moises, na mà din, “Kagiyi nu si Aaron na tádduán din ka tukád din tô mga wayig, tô mga kanal, asta tô mga ranó ébô lumuwà tô mga bakbak asta tumalap tun ta kaluwagan ka Ehipto!” ");
INSERT INTO bgs_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Purisu igbánnal si Aaron ki Moises, asta igluwà tô mga bakbak tikud tun ta wayig, asta igtalap tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Magunawa tô igimu katô mga tarasalamangka taga Ehipto ukit katô kakatigan dan, su igpaluwà dan tô mga bakbak tikud tun ta wayig. ");
INSERT INTO bgs_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Na, igpatawar katô harì si Moises asta si Aaron, asta igkagiyan din, na mà din, “Dasal kó tun ta Áglangngagán ébô iwaán din tô mga bakbak tikud kanak asta tikud tun ta mga sakup ku. Péwaán ku gó tô langun yu ébô mangadap kó katô Áglangngagán.” ");
INSERT INTO bgs_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Igtaba si Moises, na mà din, “Kagi ka dád ka kadángngan tô kadasal ku para áknikó, tô mga opisyales nu, asta tô mga sakup nu ébô méwà ni mga bakbak tikud tun ákniyu asta tun ta mga balé yu. Masamà dád tô mga bakbak na tun ta Wayig ka Nilo.” ");
INSERT INTO bgs_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Igtaba tô harì, na mà din, “Dasal ka para kanak simag.” Igkagi si Moises, na mà din, “Matuman tô kakalyag nu ébô kasóddóran nu na ándà ássa manama na duwán katulusan ka tandingán katô Áglangngagán na Manama dé. ");
INSERT INTO bgs_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Méwà tô mga bakbak tun ákniyu, tun ta mga balé yu, tun ta mga opisyales nu asta tun ta mga sakup nu. Masamà dád tô mga bakbak na tun ta Wayig ka Nilo.” ");
INSERT INTO bgs_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tô igluwà dán si Moises asta si Aaron tikud tun ta balé katô harì, igdasal si Moises tun ta Áglangngagán tingód katô mga bakbak na igpapid din. ");
INSERT INTO bgs_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Igtuman katô Áglangngagán tô igpamuyù i Moises, asta inaté tô mga bakbak tun dalám ta mga balé, tun ta luwà ka mga balé, asta tun ta mga kinamát. ");
INSERT INTO bgs_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Iglimud katô taga Ehipto tô inaté mga bakbak tun ta magdakál mga kalimud, asta igmawù tô tibuk Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Asal tô igkita katô harì na inaté dán tô mga bakbak, igpatággas din tô ulu din, asta ándà paminág ki Moises asta ki Aaron, magunawa katô taganà igkagi katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Kagiyi nu si Aaron na lagpássán din tô tanà ka tukád din ébô tô barukbuk mému na tagánnák tun ta kaluwagan ka Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Igbánnal dan katô igsugù katô Áglangngagán kandan. Tô iglagpás i Aaron tô tukád din tun ta tanà, ipánnù ka tagánnák tô mga taga Ehipto asta tô mga mannanap dan, su tô langun ka barukbuk tun ta Ehipto inému na mga tagánnák. ");
INSERT INTO bgs_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Igkinnam tô mga tarasalamangka na igimu ka mga tagánnák ukit katô mga kakatigan dan, asal ándà dan ikému. Ipánnù ka tagánnák tô mga manubù asta tô mga mannanap dan. ");
INSERT INTO bgs_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Igkagi tô mga tarasalamangka katô harì, na mà dan, “Manama tô igimu kani kasalábbuan.” Asal igmatággas gó tô ulu ka harì, asta ándà paminág ki Moises asta ki Aaron, magunawa katô taganà igkagi katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Simag ka tuu sállám, atin ka madun tô harì tun ta wayig, angati nu sikandin, asta kagiyi nu, ‘Ni gó tô igkagi katô Áglangngagán: Péwà nu tô mga sakup ku ébô mangadap dan kanak. ");
INSERT INTO bgs_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Atin ka méllé ka, papiddán ku tô marapung mga langó tun áknikó, tun ta mga opisyales nu, asta tun ta mga sakup nu. Mapánnù ka mga langó tô mga balé yu asta tô kaluwagan kani tanà. ");
INSERT INTO bgs_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Asal ássa tô lumun ku para katô mga rubbad i Israel, su ándà langó na papiddán ku tun ta Gosen na góddóan katô mga sakup ku, ébô makasóddór ka na sakán tô Áglangngagán agad kannun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ássan ku tô kanak mga sakup asta tô áknikó mga sakup. Mému ni na kasalábbuan simag.’” ");
INSERT INTO bgs_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Igimu ni katô Áglangngagán, asta igahu tô marapung mga langó tun ta balé katô harì, tun ta langun balé katô mga opisyales din, asta tun ta langun balé tun ta Ehipto. Idattan tô langun tun ta Ehipto tingód katô mga langó. ");
INSERT INTO bgs_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Na, igpatawar katô harì si Moises asta si Aaron, asta igkagiyan din, na mà din, “Panó kód gó. Bággé yu tô mga mannanap tun ta Manama yu kannun ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Igtaba si Moises, na mà din, “Dì mému ni, su miringasa tô mga taga Ehipto áknami ukit katô kabággé dé ka mga mannanap tun ta Áglangngagán na Manama dé. Purisu atin ka makakita dan katô kabággé dé, timbagán ké gó ikandan ka batu ébô maté ké. ");
INSERT INTO bgs_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kailangan madun ké tun ta disyerto na ágkadunggù ka tállu álló ágpanón ébô mággé ké katô kailangan bággén tun ta Áglangngagán na Manama dé, magunawa katô igsugù din áknami.” ");
INSERT INTO bgs_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Purisu igkagi tô harì, na mà din, “Atin ka dì kó madun tun ta madiyù, péwaán ku sikiyu ébô madun kó tun ta disyerto asta mággé kó katô kailangan bággén yu tun ta Áglangngagán na Manama yu. Asal dasal kó tun kandin para kanak.” ");
INSERT INTO bgs_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Igkagi si Moises, na mà din, “Manówad, asta dumasalla tun ta Áglangngagán ébô simag andaán din tô langó tun áknikó, tun ta mga opisyales nu, asta tun ta mga taga Ehipto. Asal yakó áglimbung puman áknami. Yaka nu ágbaringi tô mga rubbad i Israel, su kailangan mággé ké tun ta Áglangngagán dé.” ");
INSERT INTO bgs_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Igpanó si Moises asta igdasal sikandin tun ta Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Igtuman katô Áglangngagán tô igpamuyù i Moises, asta inéwà tô langun langó. Ándà palang langó na isamà. ");
INSERT INTO bgs_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Asal igpatággas puman tô harì ka ulu din, asta ándà din péwai tô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Saduni nu tô harì ka Ehipto, asta kagiyi nu sikandin, ‘Ni gó tô igkagi katô Áglangngagán na Manama na ágpangadapán katô mga Hebreo: Péwà nu tô mga sakup ku ébô mangadap dan kanak. ");
INSERT INTO bgs_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Atin ka méllé ka pa, asta dì nu puman péwaán, ");
INSERT INTO bgs_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","supakan ku sikuna ukit katô makamáddang bógók na dumunggù tun ta mga mannanap yu, tun ta mga kudà, mga asno, mga kamelyo, mga baka, mga karnero, asta mga kambing yu. ");
INSERT INTO bgs_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Asal ássan ku puman tô mga mannanap katô mga rubbad i Israel, su ándà palang mannanap dan na maté.’ ");
INSERT INTO bgs_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Na, igsalin katô Áglangngagán tô álló ébô tumanán din ni, su igkagi sikandin na imun din ni simag.” ");
INSERT INTO bgs_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Pagkasimag, igtuman katô Áglangngagán tô igkagi din, asta inaté tô langun mannanap ka mga taga Ehipto, asal tun ta mga mannanap katô mga rubbad i Israel, ándà palang inaté. ");
INSERT INTO bgs_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Duwán mga manubù na igsugù katô harì ébô kasóddóran din ka imánnu tô mga mannanap katô mga rubbad i Israel, asta igulitan dan sikandin na ándà gó palang inaté. Asal igmatággas gó puman tô ulu ka harì, asta ándà din gó péwai. ");
INSERT INTO bgs_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Na, igkagi tô Áglangngagán ki Moises asta ki Aaron, na mà din, “Kangé kó ka abu tikud tun ta ággóbbówanan. Tô gó é sabudán i Moises tun ta karamag na tubang katô harì. ");
INSERT INTO bgs_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Matalap ni iring na barukbuk tun ta kaluwagan ka Ehipto, asta pigsan tô mga manubù asta tô mga mannanap dan tingód katô barukbuk, asta mému ni na mga bakukang.” ");
INSERT INTO bgs_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Purisu igkangé dan tô abu tun ta ággóbbówanan, asta igtubang dan tô harì. Igsabud i Moises tun ta karamag, asta igpigsa tô mga taga Ehipto asta tô mga mannanap dan, asta inému na mga bakukang. ");
INSERT INTO bgs_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ándà ikatubang tô mga tarasalamangka ki Moises, su igpigsa dan, magunawa katô duma mga taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Asal igpatággas gó katô Áglangngagán tô ulu ka harì, asta ándà din paminággi si Moises asta si Aaron, magunawa katô taganà igkagi ka Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Simag ka tuu sállám, saduni nu tô harì, asta kagiyi nu sikandin, ‘Ni gó tô igkagi katô Áglangngagán na Manama na ágpangadapán katô mga Hebreo: Péwà nu tô mga sakup ku ébô mangadap dan kanak. ");
INSERT INTO bgs_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Atin méllé ka pa, papiddán ku tô mga supak tun áknikó, tun ta mga opisyales nu, asta tun ta mga sakup nu ébô kasóddóran nu na ándà ássa na magunawa kanak tun ta tibuk kani banuwa. ");
INSERT INTO bgs_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Atin ka ándà pa kédu ku ákniyu, igmatayan kud pád sikiyu langun. Mému ka papiddan ku sikiyu ka bógók ébô maté kó langun. ");
INSERT INTO bgs_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Asal ándà ku sikiyu matayi ébô kitanán yu tô katulusan ku, asta ébô pabantugánna ikiyu tun ta kaluwagan ka banuwa. ");
INSERT INTO bgs_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Asal ágpahirap ka pa katô mga sakup ku, asta ándà ka pa péwà kandan. ");
INSERT INTO bgs_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Purisu simag ka iring kani oras ni, padabuán ku tô magdakál mga ayis iring na mabággat mga batu. Ándà pa idabù iring kani tikud na duwán dán mga manubù na góddô tun ta Ehipto sippang áknganni. ");
INSERT INTO bgs_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Purisu sugù ka na kailangan pallungán tô langun mannanap asta tô mga taralumu tun ta kinamát, su madabù tô magdakál mga ayis iring na mabággat mga batu, asta maté gó tô mga manubù asta tô mga mannanap na itananan tun ta luwà ka balé.’” ");
INSERT INTO bgs_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Duwán mga opisyales na igbánnal katô igkagi ka Áglangngagán, asta igpasékót dan igpallung tô mga állang dan asta tô mga mannanap tun ta balé. ");
INSERT INTO bgs_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Asal tô duma mga opisyales na ándà bánnal katô igkagi ka Áglangngagán, itananan dan tô mga állang dan asta tô mga mannanap dan tun ta luwà ka balé. ");
INSERT INTO bgs_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Tayó nu tô bállad nu tun ta langit ébô madabù tô magdakál mga ayis tun ta kaluwagan ka Ehipto, agad tun ta mga manubù, tun ta mga mannanap, asta tun ta mga pamulanán tun ta kinamát.” ");
INSERT INTO bgs_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Purisu igtayó i Moises tô tukád din tun ta langit, asta igpakilat katô Áglangngagán, igpadabù din tô magdakál mga ayis, asta igkirám tun ta banuwa. Igpadabù katô Áglangngagán tô magdakál mga ayis iring na mabággat mga batu tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tuu mabákkár tô kadabù ka mga ayis, asta marag igkirám. Ándà gó palang inému iring kani tikud na duwán dán mga manubù na góddô tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tun ta kaluwagan ka Ehipto, isugatan ka mga ayis tô langun na ándà pallungi, agad tô mga manubù asta tô mga mannanap dan. Idattan gó puman tô langun pamulanán asta mga kayu. ");
INSERT INTO bgs_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tô banuwa ka Gosen na góddóan katô mga rubbad i Israel, tô dád gó tô lugar na ándà kadabui ka mga ayis. ");
INSERT INTO bgs_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Na, igpatawar katô harì si Moises asta si Aaron, asta igkagiyan din, na mà din, “Ikasalà a. Nángngà tô iglumu katô Áglangngagán. Ánnà nángngà tô iglumu ku asta katô mga sakup ku, su ándà ké péwà katô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Dasal kó tun ta Áglangngagán su dì ké pakatiis kani madat kilat asta ágkadabù na mga ayis. Péwaán kud gó sikiyu. Dì kéd lumiput ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Igkagi si Moises kandin, na mà din, “Atin ka panówad tikud tun ta lunsud, tayón ku tô bállad ku asta dumasalla tun ta Áglangngagán. Sumódô tô kilat asta tô mga ayis ágkadabù. Purisu kasóddóran nu na Áglangngagán tô tigatun kani tibuk banuwa. ");
INSERT INTO bgs_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Asal ikasóddórra na sikuna asta tô mga opisyales nu, ándà pô gó máddang yu katô Áglangngagán na Manama.” ");
INSERT INTO bgs_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Idattan tô sebada asta tô mga pamula na ágkangayan katô duru, su tô sebada malutù dán, asta ágbulak dán tô pamula na ágkangayan katô iring na duru. ");
INSERT INTO bgs_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Asal ándà kadatti tô trigo, su ándà pa tubù. ");
INSERT INTO bgs_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Na, igtananan i Moises tô harì, asta igpanó sikandin tikud tun ta lunsud. Tô igtayó si Moises katô bállad din asta igdasal sikandin tun ta Áglangngagán, igsódô tô kilat asta tô kadabù ka mga ayis. ");
INSERT INTO bgs_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tô igkita tô harì na igsódô dán tô udan, tô kadabù ka mga ayis, asta tô kirám, ikasalà dán puman sikandin asta tô mga opisyales din, ");
INSERT INTO bgs_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","su igpatággas din puman tô ulu din, asta ándà din péwai tô mga rubbad i Israel, magunawa katô taganà igkagi katô Áglangngagán ukit ki Moises. ");
INSERT INTO bgs_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Saduni nu tô harì ka Ehipto. Igpatággas ku tô ulu din asta tô ulu ka mga opisyales din ébô pakitanán ku tô katulusan ku kandan ukit kani mga kasalábbuan. ");
INSERT INTO bgs_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Atin ka matugál kód, kólitan yu tô mga gabatà yu asta tô mga apù yu tingód katô mga kasalábbuan na gimun ku ukit ka supak ku katô mga taga Ehipto ébô makasóddór kó langun na sakán gó tô Áglangngagán.” ");
INSERT INTO bgs_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Purisu igsadun si Moises asta si Aaron tun ta harì, asta igkagi sikandan kandin, na mà dan, “Ni gó tô igkagi katô Áglangngagán na Manama na ágpangadapán katô mga Hebreo: Manan ka ágpanayun ka géllé na pabbabà kanak? Péwà nud tô mga sakup ku ébô mangadap dan kanak! ");
INSERT INTO bgs_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Atin ka manayun ka méllé, banté ka gó, su simag papiddán ku tô mga apang tun ta banuwa nu. ");
INSERT INTO bgs_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tingód katô karapungan dan, katambunan tô bówwó ka tanà ébô dì yu gó kitanán tô tanà. Kannán dan tô langun na ándà kadatti katô kadabù ka mga ayis. Kannán dan tô langun kayu yu. ");
INSERT INTO bgs_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mapánnù tun ta mga balé nu na dakál é lagà, tun ta mga balé katô mga opisyales nu, asta tun ta mga balé katô langun sakup nu. Ándà gó palang kadattan iring kani tikud na duwán dán mga manubù na góddô tun ta Ehipto.” Na, igtananan i Moises tô harì. ");
INSERT INTO bgs_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Igkagi tô mga opisyales katô harì, na mà dan, “Manan ka ágpabayaán nu ni manubù na ágsamuk áknita? Péwà nud tô mga gamama ébô mangadap dan katô Áglangngagán na Manama dan! Ándà nu pa kasóddóri na idattan dán tô banuwa ka Ehipto?” ");
INSERT INTO bgs_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Purisu igpalónód katô harì si Moises asta si Aaron, asta igkagiyan din, na mà din, “Mému dán ka panó kód ébô mangadap kó katô Áglangngagán na Manama yu. Asal sadan tô manó?” ");
INSERT INTO bgs_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Igtaba si Moises, na mà din, “Manó ké langun, agad tô mga gabatà dé asta tô mga tugál. Piddán dé tô mga karnero dé, tô mga kambing dé, asta tô mga baka dé, su palimudé ké ébô pabantugán dé tô Áglangngagán.” ");
INSERT INTO bgs_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Igkagi tô harì, na mà din, “Atin ka piddán yu tô langun pamilya yu, kailangan tabangan kó katô Áglangngagán tingód katô lumun ku ákniyu, su dì mému piddán yu sikandan. Tuu dán matayyó na madat gó tô plano yu. ");
INSERT INTO bgs_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Dì mému kanak! Mga gamama dád tô makapanó ébô mangadap katô Áglangngagán, su tô gó é kakalyag yu.” Na, igpéwà dan tikud tun ta tubang katô harì. ");
INSERT INTO bgs_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Tayó nu tô bállad nu ébô dumunggù tô mga apang tun ta banuwa ka Ehipto. Matalap dan tô kaluwagan ka Ehipto, asta kannán tô langun pamulanán na ándà kadatti katô mga ayis.” ");
INSERT INTO bgs_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Purisu igtayó i Moises tô tukád din, asta igpapid katô Áglangngagán tô mabákkár karamag tikud tun ta silatan ka Ehipto igladé ka álló asta dukilám. Tô igsállám dán, duwán mga apang na igpid katô karamag. ");
INSERT INTO bgs_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Tuu marapung tô mga apang, asta igsunnad tun ta kaluwagan ka Ehipto. Ándà palang apang na ikadunggù iring kani tikud na duwán dán mga manubù na góddô tun ta Ehipto, asta ándà dán palang dumunggù iring kani. ");
INSERT INTO bgs_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Itambunan katô mga apang tô bówwó ka tanà tun ta kaluwagan ka Ehipto sippang igmétám tô tanà. Igkan dan tô langun pamulanán asta tô mga buuy ka kayu na ándà kadatti ukit ka kadabù ka mga ayis. Ándà gó palang malunnó daun na isamà tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Na, sékót igpatawar katô harì si Moises asta si Aaron, asta igkagiyan din, na mà din, “Bánnal na ikasalà a tun ta Áglangngagán na Manama yu asta tun ákniyu. ");
INSERT INTO bgs_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Pasinsiyayiya kani salà na ilumu ku nigó, asta dasal kó tun ta Áglangngagán na Manama yu ébô iwaán din ni tuu madat supak.” ");
INSERT INTO bgs_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Purisu igtananan i Moises tô harì, asta igdasal sikandin tun ta Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Purisu igpapid katô Áglangngagán tô mabákkár karamag na tikud tun ta salláppan, asta ipid tô mga apang tun ta Dagat na Mallutù. Ándà gó palang apang na isamà, agad sábbad, tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Asal igpatággas puman katô Áglangngagán tô ulu ka harì, asta ándà din péwai tô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Tayó nu tô bállad nu tun ta langit ébô dumunggù tô kangittángngan tun ta kaluwagan ka Ehipto. Tuu kumangittáng asta makamáddang.” ");
INSERT INTO bgs_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Purisu igtayó i Moises tô bállad din tun ta langit, asta igdunggù tô tuu kangittángngan tun ta kaluwagan ka Ehipto sippang tun ta ikatállu álló. ");
INSERT INTO bgs_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ándà pakitaé tô mga taga Ehipto, asta ándà dan luwà tikud tun ta mga balé dan dalám ka tállu álló. Asal mappawà tô tun ta góddóan katô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Igpatawar katô harì si Moises, asta igkagiyan din, na mà din, “Makapanó kód langun ébô mangadap kó katô Áglangngagán. Mému ka mákkás dán ákniyu tô mga gabayi asta tô mga gabatà yu. Asal tô dád mga karnero, tô mga kambing, asta tô mga baka tô tananan yu dini.” ");
INSERT INTO bgs_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Asal igtaba si Moises, na mà din, “Dì mému! Kailangan piddán dé pagsik tô mga mannanap na matayan asta góbbón ébô bággén dé tun ta Áglangngagán na Manama dé. ");
INSERT INTO bgs_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kailangan piddán dé tô langun mannanap dé. Dì mému ka duwán tananan, agad sábbad, ébô makasalin ké katô matayan dé asta bággén dé tun ta Áglangngagán na Manama dé. Dì ké pa makasóddór ka ándin mannanapi tô matayan dé sippang ka dumunggù ké.” ");
INSERT INTO bgs_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Asal igpatággas puman katô Áglangngagán tô ulu ka harì, asta ándà din péwai. ");
INSERT INTO bgs_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Igkagi tô harì ki Moises, na mà din, “Iwà ka kannun ta tubang ku, asta yakad gó ágpakita puman kanak, su atin ka kitanán ku puman sikuna, pamatayan ku.” ");
INSERT INTO bgs_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Igtaba si Moises, na mà din, “Matuman tô kakalyag nu! Dì kad puman kumita kanak.” ");
INSERT INTO bgs_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Papiddán ku tô sábbad pa supak tun ta harì ka Ehipto asta tun ta mga sakup din ébô péwaán kó ikandin. Atin ka péwaán kód, pamagaan kó gó ikandin ébô makéwà kó. ");
INSERT INTO bgs_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kagiyi nu tô mga rubbad i Israel ébô pamuyuán dan tô mga salagbat, tô mga pangkis, asta tô bulawan mga arites tun ta mga simbalé dan na taga Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Igimu ka Áglangngagán na kadayawan tô mga taga Ehipto tingód katô mga rubbad i Israel. Tô mga opisyales ka harì asta tô mga taga Ehipto igrespeto ki Moises na sábbad ágkabantug manubù tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Purisu igkagi si Moises katô harì, na mà din, “Ni gó tô igkagi ka Áglangngagán: Tángngà ka dukilám, panó-panówa tun ta kaluwagan ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Maté tô langun tambang kaké gabatà gamama dini ta Ehipto, agad tô tambang kaké batà mama katô harì na sumui kandin, asta tambang kaké batà mama katô állang din na ággiling dád ka trigo. Maté tô mga tambang kaké nati mama katô mga baka. ");
INSERT INTO bgs_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tuu gó mabákkár tô darawitán katô mga manubù tun ta kaluwagan ka Ehipto. Ándà gó palang darawitán iring kani tikud na duwán dán mga manubù na góddô tun ta Ehipto, asta ándà dán palang darawitán iring kani. ");
INSERT INTO bgs_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Asal tumagnáp gó tô tun ta mga rubbad i Israel, su agad tô mga asu dì mábbu katô mga manubù ó mga mannanap ébô kasóddóran nu gó na ássan katô Áglangngagán tô mga rubbad i Israel tun ta mga taga Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Igkagi si Moises, na mà din, “Tumubang tô langun opisyales nu kanak, asta lumingkóód dan. Pédu-édu dan na miwà a, asta patákkássán ku tô mga sakup ku. Atin ka matuman dán ni, miwà ad.” Tuu isókó si Moises, asta igtananan din tô harì. ");
INSERT INTO bgs_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ituman tô igkagi katô Áglangngagán ki Moises, na mà din, “Dì maminág tô harì áknikó ébô marapung tô mga kasalábbuan na imun ku tun ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Agad igimu si Moises asta si Aaron kani mga kasalábbuan tun ta tubang katô harì, asal igpatággas katô Áglangngagán tô ulu din ébô dì din péwaán tikud tun ta Ehipto tô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Na, igkagi tô Áglangngagán ki Moises asta ki Aaron dutun ta Ehipto, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Imun ni bulan ni na tagnà bulan ka ámmé para ákniyu. ");
INSERT INTO bgs_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Pasóddór yu tun ta langun rubbad i Israel na tun ta ikasapulù álló kani bulan ni, tô kada mama na duwán sawa kailangan sumalin ka nati ka karnero ó nati ka kambing na nángngà para kannán ka kandin pamilya. Sábbad mannanap tô iyón katô kada pamilya. ");
INSERT INTO bgs_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Atin ka délák dád tô pamilya, asta dì makémmát kuman ka sábbad mannanap, sábbad dád mannanap tô kannán katô duwa pamilya na ágpasimbalayé. Agad ándin tô lumun dan kailangan makanángngà katô karapungan dan asta kadakállan katô makan dan. ");
INSERT INTO bgs_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mému ka salinán yu tô karnero ó tô kambing, asal kailangan salinán yu tô mama na gidad ka sábbad ámmé, asta ándà gó depekto. ");
INSERT INTO bgs_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Iyó yu ni ka ágsalláp dán tô álló katô ikasapulù áppat álló kani bulan ni, su tô gó tô álló na padángngané tô langun pamilya katô mga rubbad i Israel na miyó katô mga mannanap na igsalin dan. ");
INSERT INTO bgs_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Atin ka iyón yu tô mannanap, pólét yu tô dipanug tun ta duwa ligad katô sállat asta dadan tun datas katô sállat katô mga balé na kannan yu katô mga mannanap. ");
INSERT INTO bgs_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Atin ka dukilám dán, ággang yu, asta kan yu duma katô pan na ándà pagpatubù asta katô mga gulay na mappait. ");
INSERT INTO bgs_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Yakó ágkan katô karne na igsabawan ó ándà ággangi. Ággang yu gó tô tibuk mannanap, agad tô ulu, tô paa, asta tô mga bituka. ");
INSERT INTO bgs_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kan yu tô tibuk lawa dalám ka dukilám. Yakó ágsamà, agad délák, sippang ka sállám. Atin ka duwán masamà na dì ágkémmát, góbbó yu. ");
INSERT INTO bgs_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Atin ka kuman kó, kailangan mangómpak kó ébô tumaganà kó na panó. Állán kó, sandalyas kó, asta awid kó katô tukád yu. Sékót kó kan. Ni gó tô lumun yu ka dukilám ka lumabéya na Áglangngagán yu. ");
INSERT INTO bgs_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Tô dukilám tô, madunna tun ta Ehipto, asta matayan ku tô langun tambang kaké mama, agad manubù ó mannanap. Sakán gó tô Áglangngagán, asta supakan ku tô langun ágmanaman na ágpangadapán tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tô dipanug na pólétán yu tun ta duwa ligad ka sállat, tô gó é pató tun ta mga balé na góddóan yu. Atin ka kitanán ku tô dipanug, labéyan kù sikiyu. Agad supakan ku tô mga taga Ehipto, asal dì kó kadattan. ");
INSERT INTO bgs_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Kailangan dì yu kalingawan ni álló ni sippang tun ta ándà ágtamanán. Kada ámmé, kailangan palimudé kó asta tô mga rubbad yu ébô pabantugánna ikiyu tingód katô iglumu ku para ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Dalám ka pittu álló, kan yu tô pan na ándà pagpatubù. Tun ta tagnà álló, iwà yu tô langun ka pagpatubù ka pan tikud tun ta mga balé yu, su atin ka duwán kuman katô pan na duwán pagpatubù tikud tun ta tagnà álló sippang tun ta ikapittu álló, kailangan péwaán yu sikandin tikud tun ta grupo yu na mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tun ta tagnà álló asta tun ta ikapittu álló, palimudé kó ébô mangadap kó kanak. Tô duwa álló tô, ándà palang lumun yu, asal makému kó móméng. ");
INSERT INTO bgs_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Imu kó gó kani Kalimudan Tingód Ka Pan Na Ándà Pagpatubù ébô dì yu kalingawan na ni álló ni tô kapid ku katô langun yu tikud tun ta Ehipto. Imu yu ni álló ni na kalimudan yu, agad sikiyu ó tô mga rubbad yu, kada ámmé sippang tun ta ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Tô tagnà bulan, tikud tun ta dukilám katô ikasapulù áppat (14) álló sippang ka dukilám katô ikaduwa pulù sábbad (21) álló, kailangan kannán yu tô pan na ándà pagpatubù. ");
INSERT INTO bgs_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Dalám ka pittu álló, kailangan ándà palang pagpatubù tun ta mga balé yu, su atin ka duwán kuman katô pan na duwán pagpatubù, agad rubbad i Israel ó ánnà, kailangan péwaán yu sikandin tikud tun ta grupo yu na mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Dalám ka pittu álló, yakó gó ágkan katô pan na duwán pagpatubù. Kan yu dád tô pan na ándà pagpatubù.” ");
INSERT INTO bgs_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Igpatawar i Moises tô langun katô ágpangulun ka mga rubbad i Israel, asta igkagiyan din, na mà din, “Kagiyi yu tô tagsábbad-sábbad pamilya na salinán dan tô nati ka karnero ó nati ka kambing, asta iyón dan tingód katô kalabé katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Salud yu tô dipanug tun ta palanggana. Tugsak yu tô panga ka isupu tun ta dipanug na igsalud tun ta palanggana, asta pólét yu tô dipanug tun ta duwa ligad katô sállat asta dadan tun datas katô sállat. Yakó ágluwà tikud tun ta balé yu sippang ka sállám, ");
INSERT INTO bgs_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","su panó-panó tô Áglangngagán tun ta kaluwagan ka Ehipto ébô matayan din tô mga taga Ehipto. Asal ka kitanán din tô dipanug tun ta duwa ligad katô sállat asta dadan tun datas katô sállat, lumabé sikandin. Dì din pahun tô taramaté na panaligan tun ta balé yu, asta dì matayan tô mga tambang kaké gabatà yu gamama. ");
INSERT INTO bgs_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Kada ámmé, kailangan bánnalán yu ni sugù, agad sikiyu asta tô mga rubbad yu sippang tun ta ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Atin ka dumunggù kó tun ta tanà na igtandô katô Áglangngagán na bággén din ákniyu, kailangan inalayun yu bánnalán ni sugù ni. ");
INSERT INTO bgs_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Atin ka minsà tô mga gabatà yu ka manan ka áglumun yu ni ágkémun ni, ");
INSERT INTO bgs_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","kagiyi yu sikandan na ni gó tô sugù tingód katô kalabé katô Áglangngagán, su iglabéyan din tô mga balé na góddóan katô mga rubbad i Israel tun ta Ehipto. Agad igmatayan din tô mga taga Ehipto, asal ándà ki ikandin matayi.” Na, tô igpaminág dan ni igkagi i Moises kandan, iglingkóód tô langun dan, asta igpangadap dan tun ta Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Igpampanó dan, asta igbánnal dan tô igsugù katô Áglangngagán ki Moises asta ki Aaron. ");
INSERT INTO bgs_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Tun ta tángngà ka dukilám, igmatayan katô Áglangngagán tô langun tambang kaké gabatà gamama tun ta kaluwagan ka Ehipto, agad tô tambang kaké batà mama katô harì na sumui kandin, agad tô mga tambang kaké gabatà gamama katô mga igpriso. Igmatayan din tô tambang kaké mama katô mga mannanap. ");
INSERT INTO bgs_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tô dukilám tô, ikannó tô harì, tô mga opisyales din, asta tô langun taga Ehipto. Igdarawit dan, su duwán inaté tun ta tagsábbad-sábbad balé. ");
INSERT INTO bgs_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tô dukilám tô, igpatawar katô harì si Moises asta si Aaron, asta igkagiyan din, na mà din, “Na, panó kód gó langun, asta iwà kód tikud dini áknami na mga taga Ehipto. Sadun kó asta pangadap kó katô Áglangngagán na Manama yu iring katô igkagi din ákniyu. ");
INSERT INTO bgs_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pid yu tô mga karnero yu, tô mga kambing yu, asta tô mga baka yu, asta panó kód! Dasal kó pagsik ébô madigár tô dumunggù kanak!” ");
INSERT INTO bgs_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Igpamagaan katô mga taga Ehipto tô mga rubbad i Israel na tumanan katô banuwa ka Ehipto. Igkagi sikandan, na mà dan, “Atin ka dì kó miwà, maté ké gó langun.” ");
INSERT INTO bgs_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Purisu igkangé katô mga rubbad i Israel tô mga palanggana na igdalámman ka harina na igmasa dan asal ándà pa tagui ka pagpatubù, igdalám dan ni tun ta umpak dan, igtángngás dan, asta igpid dan. ");
INSERT INTO bgs_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Igbánnal katô mga rubbad i Israel tô igkagi i Moises kandan, asta igpamuyù dan tô mga salagbat, tô mga paningsing, tô mga pangkis, tô bulawan mga arites, asta tô mga umpak tun ta mga simbalé dan na taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Igimu katô Áglangngagán na madigár tô panámdám katô mga taga Ehipto tingód katô mga rubbad i Israel, asta igbággé dan tô langun igpamuyù dan. Ukit ka kapamuyù katô mga rubbad i Israel, inémmát tô kaduwánnan katô mga taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Igpanó tô mga rubbad i Israel tikud tun ta Rameses, asta igsadun dan tun ta Sucot. Duwán mga ánnám gatus mararan (600,000) na mga gamama, asta ándà kéyap tô mga gabayi asta mga gabatà. Igpanóttanà dan. ");
INSERT INTO bgs_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Marapung pagsik tô ássa mga manubù na igtákkás kandan, asta marapung tô mga karnero, tô mga kambing, asta tô mga baka dan. ");
INSERT INTO bgs_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Atin ka ágsódô dan ébô kuman, ággamitán dan tô igmasa na ándà pagpatubù na igpid dan tikud tun ta Ehipto, asta áglutuán dan tô pan tun ta baga. Tô harina dan ándà tagui katô pagpatubù su sékót dan igpéwà tikud tun ta Ehipto, asta ándà timpo para taganaán tô ágkannán dan asta patubuán tô pan. ");
INSERT INTO bgs_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Igóddô tô mga rubbad i Israel tun ta Ehipto dalám ka áppat gatus tállu pulù (430) ámmé. ");
INSERT INTO bgs_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Tun ta tapuri gó álló katô áppat gatus tállu pulù (430) ámmé, igiwà tô mga sakup katô Áglangngagán tikud tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tô gó tô dukilám na igbanté tô Áglangngagán ébô piddán din tô mga sakup din tikud tun ta banuwa ka Ehipto. Purisu kailangan ágbanté tô mga rubbad i Israel ébô dì dan kalingawan tô iglumu katô Áglangngagán kandan, asta pabantugán dan sikandin kada ámmé sippang tun ta ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Na, igkagi tô Áglangngagán ki Moises asta ki Aaron, na mà din, “Ni gó tô mga sugù ku tingód katô Kalimudan Ka Kalabé. Dì mému kuman tô mga ánnà rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Asal atin ka igtupuwan tô mga állang na igbálli yu, mému makakan dan. ");
INSERT INTO bgs_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Dì makakan tô mga ágróggun na góddô, asta tô mga taralumu na ágtandanan. ");
INSERT INTO bgs_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Kailangan kannán ni mannanap tun ta balé na igággangan. Dì mému piddán yu ni tun ta luwà ka balé. Dì mému pantigán tô mga tullan. ");
INSERT INTO bgs_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kailangan padángngané tô langun rubbad i Israel tun ta Kalimudan Ka Kalabé. ");
INSERT INTO bgs_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Atin ka duwán ánnà mga rubbad i Israel na góddô duma ákniyu, asta malyag dan na mapil ákniyu ébô mamista katô Kalimudan Ka Kalabé, kailangan patupu tô langun gamama ébô makapil dan ákniyu. Makakan dan katô Kalimudan Ka Kalabé iring katô bánnal na mga rubbad i Israel. Asal dì gó makakan tô ándà tupuwi. ");
INSERT INTO bgs_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tô gó tô ágkémun na kailangan ágtumanán katô mga rubbad i Israel, asta tô ánnà mga rubbad i Israel na góddô tun ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Purisu igbánnal katô langun rubbad i Israel tô igsugù katô Áglangngagán ki Moises asta ki Aaron. ");
INSERT INTO bgs_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Tô gó tô álló na igpid katô Áglangngagán tô mga rubbad i Israel tikud tun ta banuwa ka Ehipto. Igpaglimud din sikandan tun ta tagsábbad-sábbad pamilya dan. ");
INSERT INTO bgs_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Na, igkagi tô Áglangngagán ki Moises, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Bággé yu kanak tô langun tambang kaké gabatà yu gamama asta tô tambang kaké nati mama katô mga mannanap yu, su kanak sikandan.” ");
INSERT INTO bgs_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Na, igkagi si Moises katô mga manubù, na mà din, “Kailangan dì yu kalingawan ni álló ni, su ni gó tô kéwà yu tikud tun ta Ehipto na lugar ka kallang ákniyu. Igpéwà kó katô Áglangngagán ukit katô makasalábbù katulusan din. (Yakó ágkan katô pan na duwán pagpatubù.) ");
INSERT INTO bgs_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ni álló ni tun ta tagnà bulan ka Abib tô kéwà yu tikud tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","“Purisu atin ka piddán kód katô Áglangngagán tun ta tanà na igóddóan katô mga Canaanhon, mga Hetihanon, mga Amorihanon, mga Hebihanon, asta mga Jebusihanon, kailangan palimudé kó gó ni bulan ni. Tô gó tô tanà na tuu malambù na igtandô katô Áglangngagán tun ta mga kamónaan yu na bággén din ákniyu. ");
INSERT INTO bgs_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Dalám ka pittu álló, kan yu tô pan na ándà pagpatubù. Tun ta ikapittu álló, palimudé kó ébô pabantugán yu tô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Dalám ka pittu álló, kan kó katô pan na ándà pagpatubù. Tun ta kaluwagan katô banuwa yu, kailangan ándà gó palang pagpatubù ó pan na duwán pagpatubù. ");
INSERT INTO bgs_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tô álló tô, pénagpát yu ni tun ta mga gabatà yu, na, ‘Gimun ni langun kani ébô kasampáttan tô igimu katô Áglangngagán para áknami tô igpéwà ké ikandin tikud tun ta banuwa ka Ehipto.’ ");
INSERT INTO bgs_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“Ni áglumun yu ni iring na pató tun ta bállad yu ó tun ta bukád yu. Ukit katô kapalimudé yu, dì yu ágkalingawan na kailangan ulit-ulitán yu tô mga sugù katô Áglangngagán, su sikandin tô igpéwà ákniyu tikud tun ta banuwa ka Ehipto ukit katô katulusan din. ");
INSERT INTO bgs_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Purisu palimudé kó kada ámmé tun ta timpo na igsalin katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Igtandô tô Áglangngagán na póddóán kó tun ta tanà na igóddóan katô mga Canaanhon. Atin ka póddóán kó dutun, ");
INSERT INTO bgs_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","bággé yu tun ta Áglangngagán tô mga tambang kaké gabatà yu gamama, asta tô tambang kaké nati mama katô mga mannanap yu, su tô Áglangngagán tô tigatun kandan. ");
INSERT INTO bgs_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Atin ka ágpamasusun tô tambang kaké nati mama katô asno yu, tábbus yu ka nati ka karnero. Asal ka dì yu tábbusán tô asno, kailangan táppuán yu tô alig din ébô maté. Kailangan tábbusán yu tô mga tambang kaké gabatà yu gamama. ");
INSERT INTO bgs_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Atin ka duwán álló na minsà tô gabatà yu na manan ka ágtábbusán yu tô tambang kaké, taba yu sikandan, ‘Igpéwà tô Áglangngagán áknami tikud tun ta banuwa ka Ehipto. Inallang ké, asal ikéwà ké ukit katô katulusan din. ");
INSERT INTO bgs_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tô igéllé tô harì na péwà áknami, igmatayan katô Áglangngagán tô mga tambang kaké gabatà gamama katô taga Ehipto, agad tô mga manubù asta tô mga mannanap. Purisu ágbággén ta tun ta Áglangngagán tô langun tambang kaké gabatà ta gamama asta tô mga tambang kaké nati mama katô mga mannanap. Asal ágtábbusán ta tô mga tambang kaké gabatà ta gamama.’ ");
INSERT INTO bgs_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ni ágkémun ta ni iring na pató tun ta bállad ta ó tun ta bukád ta, su igpéwà ké katô Áglangngagán tikud tun ta banuwa ka Ehipto ukit katô katulusan din.” ");
INSERT INTO bgs_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Tô igpéwà katô harì ka Ehipto tô mga rubbad i Israel, ándà dan pókiti katô Manama tun ta dalan tun ta tanà na igóddóan katô mga manubù na ágngadanan na Filistihanon, agad madani, su igkagi tô Manama, na mà din, “Atin ka dungguan tô mga rubbad i Israel ka gira, mapalin tô panámdám dan, asta lumónód dan tun ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Purisu igpid din sikandan na igukit tun ta disyerto dadan tun ta Dagat na Mallutù. Tô igiwà tô mga rubbad i Israel tikud tun ta Ehipto, igpid dan tô mga laniban dan agó duwán sumulung kandan. ");
INSERT INTO bgs_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Igpid i Moises tô mga tullan i Jose, su taganà igtandô tô mga rubbad i Israel ki Jose sayyan na tô gó é lumun dan. Tô ándà pa kamaté si Jose, igkagi sikandin, na mà din, “Atin ka péwaán kó katô Manama tikud tun ta Ehipto, pid yu tô mga tullan ku.” ");
INSERT INTO bgs_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tô igpanó dan tikud tun ta Sucot, igkampo dan tun ta Etam, tun ta ligad katô disyerto. ");
INSERT INTO bgs_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Igladé ka álló na iguna tô Áglangngagán kandan ukit katô sagulapun na iring na sumbál ébô kasóddóran dan ka ánda tô sadunan dan. Igladé ka dukilám na iguna sikandin kandan ukit ka apuy na iring na sumbál ébô tumaddó kandan. Purisu ikapanó dan agad álló asta dukilám. ");
INSERT INTO bgs_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Inalayun dan ágkitanán tô sagulapun ka álló, asta tô apuy ka dukilám. ");
INSERT INTO bgs_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Igkagi tô Áglangngagán ki Moises, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Kagiyi nu tô mga rubbad i Israel na sumuwé dan, asta póddô nu pa róggun sikandan madani tun ta Pihahirot tun ta tángngaan katô Migdol asta Dagat na Mallutù madani tun ta Baalsepon, ");
INSERT INTO bgs_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","su manámdám tô harì ka Ehipto na itadin kó, asta dì kó makaluwà tun ta disyerto. ");
INSERT INTO bgs_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Patággasán ku tô ulu ka harì, asta agtaán kó ikandin. Purisu pabantugánna ukit katô kapanaluwan ku katô harì asta katô mga sundalo din. Kasóddóran katô mga taga Ehipto na sakán tô Áglangngagán.” Igbánnal katô mga rubbad i Israel tô igsugù ka Manama kandan. ");
INSERT INTO bgs_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tô igulitan tô harì ka Ehipto na igiwà dán tô mga rubbad i Israel, ipalin tô panámdám din asta tô panámdám katô mga opisyales din tingód katô mga rubbad i Israel, asta igkagi sikandan, na mà dan, “Manan ka igpéwà ta gó tô mga rubbad i Israel? Ándà dán gó mga állang ta.” ");
INSERT INTO bgs_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Na, igtaganà katô harì tô kalesa din na para ka gira asta tô mga sundalo din. ");
INSERT INTO bgs_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Igpid din tô ánnám gatus (600) madigár kalesa asta tô duma pa mga kalesa na ágsakayan katô mga opisyales din. ");
INSERT INTO bgs_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Igpatággas katô Áglangngagán tô ulu ka harì, asta iglupug din tô mga rubbad i Israel na igiwà ukit katô kadóppón katô Áglangngagán kandan. ");
INSERT INTO bgs_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Iglupig tô langun sundalo katô harì ka Ehipto, agad tô mga igsaké ka kalesa, tô mga igsaké ka kudà, asta tô mga igpanóttanà. Inasabban dan tô mga rubbad i Israel na igkampo madani tun ta Pihahirot tun ta ligad katô Dagat na Mallutù. ");
INSERT INTO bgs_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Na, tô madani dán tô harì asta tô mga sundalo din, tuu imáddangan tô mga rubbad i Israel, asta igrangin dan katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Igkagi sikandan ki Moises, na mà dan, “Manan ka igpid ké ikuna ébô maté ké dini ta disyerto? Manan? Ándà dán gó lábbángngan áknami tun ta Ehipto? Sállág nu ka ándin tô inókitan dé! ");
INSERT INTO bgs_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Yaka nu ágkalingawi tô igkagi dé áknikó tô ándà ki pa panó na dungguan ki katô madat. Igkagiyan dé sikuna, na mà dé, ‘Pabayà kéd na pallang katô mga taga Ehipto.’ Madigár pa gó ka manayun ké móddô na állang ka tandingán katô maté ké tun ta disyerto.” ");
INSERT INTO bgs_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Igkagi si Moises katô mga manubù, na mà din, “Yakó ágkamáddangan! Pasarig yu tô panámdám yu, asta sállág yu tô lumun katô Áglangngagán ni álló ni ébô paluwaán kó ikandin. Tô mga taga Ehipto na ágkitanán yu, dì yud gó kitanán puman. ");
INSERT INTO bgs_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tô Áglangngagán tô manalu kandan, asta ándà dán lumun yu.” ");
INSERT INTO bgs_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Igkagi tô Áglangngagán ki Moises, na mà din, “Manan ka ágrangin ka kanak? Kagiyi nu tô mga rubbad i Israel na kailangan manayun dan tun tóna. ");
INSERT INTO bgs_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tayó nu tô tukád nu asta táddù nu tun ta dagat, asta matángngà tô dagat ébô makapanó tô mga rubbad i Israel tun ta matákkang tanà. ");
INSERT INTO bgs_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Patággasán ku tô ulu ka mga taga Ehipto ébô lupugán dan tô mga rubbad i Israel. Ukit kani, pabantugánna ukit katô kapanaluwan ku katô harì ka Ehipto asta tô langun sundalo din, agad tô mga igsaké ka kalesa asta tô mga igsaké ka kudà. ");
INSERT INTO bgs_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kasóddóran katô langun taga Ehipto na sakán tô Áglangngagán ukit ka igtalu ku tô harì dan, tô mga sundalo din na ágsaké ka mga kalesa, asta tô mga ágsaké ka mga kudà.” ");
INSERT INTO bgs_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Na, tô panaligan ka Manama na guna tun ta mga rubbad i Israel igalin dadan tun ta bókkóg dan. Tô sagulapun na iring na sumbál igalin dadan tun ta bókkóg dan. ");
INSERT INTO bgs_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Igsunnad tun ta tángngaan katô mga sundalo ka taga Ehipto asta mga rubbad i Israel. Tô dukilám dán, tô sagulapun na iring na sumbál inému na apuy na igbággé ka kappawaan tun ta mga rubbad i Israel. Asal tô sagulapun inému na mangittáng tun ta mga taga Ehipto, asta ándà dan ikapadani tun ta mga rubbad i Israel tô dukilám. ");
INSERT INTO bgs_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Na, igtayó i Moises tô bállad din, asta igtáddù din tun ta dagat. Igpapid katô Áglangngagán tô mabákkár karamag tikud tun ta silatan na igladé ka dukilám. Itángngà tô dagat, asta itákkang tô tanà tun ta tángngaan ka dagat. ");
INSERT INTO bgs_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Inému tô dagat na iring na duwa labat tun ta ibang asta tun ta kawanan dan, asta igukit tô mga rubbad i Israel tun ta matákkang tanà tun ta tángngaan katô dagat. ");
INSERT INTO bgs_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Iglupug tô mga taga Ehipto, agad tô langun sundalo na igsaké katô mga kalesa dan. Igitur dan katô igukitan katô mga rubbad i Israel tun ta tángngaan katô dagat. ");
INSERT INTO bgs_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Tô ándà pa kasállám, igsállág tô Áglangngagán katô mga sundalo tikud tun ta sumbál na apuy. Iglimáddang asta iglibug din sikandan. ");
INSERT INTO bgs_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ikasanggat tô mga ligid katô mga kalesa, asta ágkatággasan dan ágpapalaguy. Igpapagayisé tô mga taga Ehipto, na mà dan, “Miwà kid tikud kannun, su igdapit tô Áglangngagán kandan asta dì ki manalu kandan.” ");
INSERT INTO bgs_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Igkagi tô Áglangngagán ki Moises, na mà din, “Táddù nu puman yan bállad nu tun ta dagat ébô lumónód tô dagat asta katambunan tô mga taga Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Purisu igtáddù i Moises tô bállad din tun ta dagat, asta tô igsállám dán, iglónód tô dagat. Igkinnam tô mga taga Ehipto na malaguy, asal igpasabban katô Áglangngagán ka dagat. ");
INSERT INTO bgs_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Iglónód tô dagat, asta itambunan tô mga kalesa, tô mga ágsaké kani, asta tô langun sundalo katô harì na iglupug kandan sippang tun ta dagat. Ándà gó palang sábbad na isamà. ");
INSERT INTO bgs_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Asal inému tô dagat na iring na duwa labat tun ta ibang asta tun ta kawanan dan, asta igukit tô mga rubbad i Israel tun ta matákkang tanà tun ta tángngaan katô dagat. ");
INSERT INTO bgs_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tô gó tô kapaluwà katô Áglangngagán katô mga rubbad i Israel. Igkita dan tô mga inaté lawa katô taga Ehipto na inanud tun ta ligad ka dagat. ");
INSERT INTO bgs_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Tô igkita dan tô katulusan katô Áglangngagán na iggamit din ébô dì dan matalu katô mga taga Ehipto, igpangadap dan kandin. Igsarigan dan tô Áglangngagán asta tô ágsuguánnán din na si Moises. ");
INSERT INTO bgs_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Na, igkanta si Moises asta tô mga rubbad i Israel tun ta Áglangngagán. Igkanta dan kani, na mà dan, “Kantaan ku tô Áglangngagán, su tuu madigár tô kapanaluwan din. Igantug din tun ta dagat tô mga kudà asta tô mga igsaké kani. ");
INSERT INTO bgs_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Tô Áglangngagán tô masarig taradóppón kanak, asta ágkanta a tingód kandin. Sikandin gó tô igpaluwà kanak. Sikandin tô Manama na pangadapán ku, asta durungán ku sikandin. Sikandin tô Manama na ágpangadapán katô ámmà ku, asta pabantugán ku sikandin. ");
INSERT INTO bgs_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Magani tô Áglangngagán, asta YAHWEH tô ngadan din. ");
INSERT INTO bgs_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Igpangantug din tun ta dagat tô mga kalesa asta tô mga sundalo katô harì ka Ehipto. Ilánnád tô mga opisyales din tun ta Dagat na Mallutù. ");
INSERT INTO bgs_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Itambunan dan katô madalám dagat, asta ilánnád dan iring na batu tun ta kadalámman ka dagat. ");
INSERT INTO bgs_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Áglangngagán, tuu madigár tô katulusan nu. Ágrupákkán nu tô mga usig nu. ");
INSERT INTO bgs_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tuu madigár tô kapanaluwan nu, asta igtalu nu tô mga usig nu. Igpandà nu sikandan tingód katô sókó nu, iring na apuy na ággóbbó ka ragami. ");
INSERT INTO bgs_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Igidup ka, asta ilimud tô dagat. Igtindág tô dagat iring na labat. Igmatággas tô kadalámman katô dagat. ");
INSERT INTO bgs_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Igkagi tô usig nu, ‘Lupugán ku sikandan, kasabban ku, asta ámmáttán ku. Taladán ku tô mga kaduwánnan dan, asta sulian ku sikandan. Tagnusán ku tô kampilan ku, asta dadattan ku tô langun dan.’ ");
INSERT INTO bgs_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Asal igidup nu sikandan, asta itambunan dan ka dagat. Ilánnád dan tun ta kadalámman katô dagat iring na timággà. ");
INSERT INTO bgs_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Áglangngagán, ándà palang mga ágmanaman na magunawa áknikó! Ándà palang ugis na tuu madigár iring áknikó! Ándà palang ássa na duwán katulusan na ágkasalábbuan! ");
INSERT INTO bgs_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Iggamit nu tô bállad nu, asta iglámmád katô tanà tô mga usig dé. ");
INSERT INTO bgs_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ukit katô ginawa nu na ándà ágtamanán, igpid nu tô mga manubù na igtábbus nu. Ukit katô bákkár nu, igagak nu sikandan tun ta ugis góddóan nu. ");
INSERT INTO bgs_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ikadinág tô mga manubù tun ta duma mga banuwa, asta igkárkár dan tingód ka máddang dan. Tuu imáddangan tô mga Filistihanon. ");
INSERT INTO bgs_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Imáddangan tô mga ágpangulun tun ta Edumea. Igkárkár tô magani mga manubù tun ta Moab. Mataló tô langun na igóddô tun ta Canaan. ");
INSERT INTO bgs_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Imáddangan asta igkállas dan. Áglangngagán, su igkita dan tô matulus áglumun nu, igtagnáp dan iring na batu, sippang ka iglabé tô mga sakup nu, sippang ka iglabé tô mga manubù na igtábbus nu. ");
INSERT INTO bgs_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Piddán nu sikandan asta póddóán nu tun ta pabungan na igsalin nu. Tô gó tô lugar na igimu nu na góddóan nu, Áglangngagán, tun ta templo na igimu nu. ");
INSERT INTO bgs_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mangulu tô Áglangngagán sippang tun ta ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tô gó tô igkanta dan su igukit tô mga rubbad i Israel katô dagat tun ta matákkang tanà. Asal igpalónódan katô Áglangngagán ka dagat tô langun kudà katô harì ka Ehipto, tô mga kalesa asta tô mga sundalo na igsaké na iglupug kandan tun ta tángngaan ka dagat, asta ilánnád dan langun. ");
INSERT INTO bgs_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Na, propeta si Miriam na tábbé i Aaron asta i Moises. Igkangé din tô tamburin, asta igpatákkás din tô langun ka duma mga gabayi na igpadaging katô mga tamburin asta igsayó. ");
INSERT INTO bgs_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Igkanta si Miriam tun kandan, na mà din, “Kantayi yu tô Áglangngagán ta, su tuu madigár tô kapanaluwan din. Igantug din tun ta dagat tô mga kudà asta tô mga igsaké kani.” ");
INSERT INTO bgs_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Igpid i Moises tô mga rubbad i Israel, igpanó dan tikud tun ta Dagat na Mallutù, asta igsadun dan tun ta disyerto tun ta Sur. Itálluwan dan igpanó tun ta disyerto, asal ándà wayig na igkita dan. ");
INSERT INTO bgs_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Tô igdunggù dan tun ta Mara, agad duwán wayig, asal ándà dan ikénám su mappait. Purisu igngadanan ni na Mara. ");
INSERT INTO bgs_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Igburáng-buráng tô mga manubù ki Moises, asta iginsà sikandan, na mà dan, “Ándin tô inámmán ta?” ");
INSERT INTO bgs_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Purisu igrangin si Moises tun ta Áglangngagán, asta duwán kayu na igpakita katô Áglangngagán kandin. Tô igantug i Moises tô panga ka kayu tun ta wayig, inému tô wayig na madigár ginámmán. Na, dutun ta Mara duwán igsugù katô Áglangngagán kandan, asta igkinnaman din sikandan. ");
INSERT INTO bgs_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Igkagi tô Áglangngagán, na mà din, “Atin ka tuu kó maminág kanak, asta lumun yu tô nángngà tun ta saruwan ku, asta mánnal kó katô mga sugù ku, asta tumanán yu tô langun ka palumun ku ákniyu, dì ku sikiyu supakan katô mga bógók na igpapid ku tun ta mga taga Ehipto. Sakán tô Áglangngagán na ágtabang ákniyu ébô kólian tô mga bógók yu.” ");
INSERT INTO bgs_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Na, tô igpanó dan dán tikud tun ta Mara, igdunggù dan tun ta Elim na duwán sapulù duwa (12) mga sánnáp asta kapittuwan (70) mga kayu palmera. Igóddô dan róggun madani tun ta mga sánnáp. ");
INSERT INTO bgs_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Igpanó tô mga rubbad i Israel tikud tun ta Elim, asta igsadun dan tun ta Sin na disyerto tun ta tángngaan ka Elim asta Sinai. Tô igdunggù dan, iglabé tô sábbad bulan tikud tun ta kéwà dan tikud tun ta Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Tun ta disyerto, igburáng-buráng dan langun ki Moises asta ki Aaron. ");
INSERT INTO bgs_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Igkagi sikandan, na mà dan, “Tuu pa madigár ka igmatayan ké katô Áglangngagán tun ta Ehipto, su madigár é ágkakan dé dutun. Asal igpid ké ikiyu dini ta disyerto ébô maté ké langun ukit ka ballus.” ");
INSERT INTO bgs_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Dabuán ku tô pan para ákniyu tikud tun ta langit iring na udan. Kada álló kailangan lumimud tô mga manubù katô pan na nángngà para kannán dan dalám ka sábbad dád álló. Ukit kani, kinnaman ku sikandan ka mánnal dan katô mga sugù ku kandan. ");
INSERT INTO bgs_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Sugù yu sikandan na kailangan dublin tô pan na limudán dan tun ta ikannám álló kada linggo.” ");
INSERT INTO bgs_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Purisu igkagiyan i Moises asta i Aaron tô langun rubbad i Israel, na mà dan, “Kani ka ágsalláp dán tô álló, kasóddóran yu na tô Áglangngagán tô igpid ákniyu tikud tun ta Ehipto, ");
INSERT INTO bgs_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","su simag ka sállám, kitanán yu tô séllaán katô Áglangngagán. Igdinág din tô kaburáng-buráng yu tingód kandin. Bánnal na igburáng-buráng kó tingód katô Áglangngagán, ánnà tingód áknami.” ");
INSERT INTO bgs_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Igkagi si Moises, na mà din, “Tô Áglangngagán tô mággé ákniyu ka karne kada ágsalláp tô álló, asta mággé ákniyu ka pan kada sállám. Igpaminág sikandin katô kaburáng-buráng yu tingód kandin. Bánnal na igburáng-buráng kó ánnà tingód áknami, asal tingód katô Áglangngagán.” ");
INSERT INTO bgs_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Igkagi si Moises ki Aaron, na mà din, “Kagiyi nu tô mga manubù, na, ‘Padani kó tun ta saruwan katô Áglangngagán, su igpaminág din tô kaburáng-buráng yu.’” ");
INSERT INTO bgs_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Róggun igkagi si Aaron katô mga manubù, igsállág dan tun ta disyerto. Igkita dan tô séllaán katô Áglangngagán tun ta sagulapun na igtákkás kandan. ");
INSERT INTO bgs_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Igkagi tô Áglangngagán ki Moises, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Igdinág ku tô kaburáng-buráng katô mga sakup ku. Kagiyi nu sikandan na kani ka ágkasalláp dán, tanggapán dan tô karne, asta simag ka sállám, tanggapán dan tô pan na nángngà para kandan. Purisu kasóddóran dan na sakán tô Áglangngagán na Manama dan.” ");
INSERT INTO bgs_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Tô ágkasalláp dán tô álló, marapung tô mga pitó na igdunggù, asta igsunnad tô mga pitó tun ta kaluwagan katô kampo dan. Tô igsállám dán, duwán damur tun ta kampo dan. ");
INSERT INTO bgs_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Na, tô itákkang dán tô damur, duwán igkita dan na marénták, manipis asta mapputì tun ta kaluwagan ka tanà. ");
INSERT INTO bgs_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tô igkita dan, igpénsaé dan, na mà dan, “Ándin ni?” Igkagi si Moises kandan, na mà din, “Ni gó tô igbággé katô Áglangngagán ákniyu ébô kannán yu. ");
INSERT INTO bgs_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Igsugù tô Áglangngagán na kailangan limudán yu langun tô ágkailanganán yu. Limud kó ka duwa litro para katô tagsábbad-sábbad manubù tun ta pamilya yu.” ");
INSERT INTO bgs_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Purisu igbánnal tô mga rubbad i Israel. Duwán mga manubù na iglimud ka dakál, asta duwán mga manubù na iglimud ka délák dád. ");
INSERT INTO bgs_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Asal tô igtáppáng dan kani, tô iglimud ka dakál, ándà kasobrayi, asta tô iglimud ka délák, ándà kakulangi. Nángngà tô iglimud para katô tagsábbad-sábbad manubù. ");
INSERT INTO bgs_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Na, igkagi si Moises kandan, na mà din, “Yakó ágsamà para ka simag.” ");
INSERT INTO bgs_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Asal duwán gó mga manubù na ándà paminág ki Moises, asta duwán igsamà dan para ka simag. Asal tô sállám dán, igulád asta imawù. Purisu isókó si Moises kandan. ");
INSERT INTO bgs_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kada sállám iglimud tô tagsábbad-sábbad pamilya katô ágkailanganán dan. Asal tô igménit dán tô álló, itunó tô isamà tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Tun ta ikannám álló, iglimud dan tô dubli, su duwán áppat litro para katô tagsábbad-sábbad manubù. Purisu igsadun tô mga ágpangulun tun ki Moises, asta igulit dan kandin. ");
INSERT INTO bgs_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Igkagi si Moises, na mà din, “Simag tô ikapittu álló, asta igsugù tô Áglangngagán na tô ikapittu álló, tô gó é álló ka kapaginawa. Ándà ássa lumun ta kannà pangadapán ta sikandin. Purisu lutù yu asta óméng yu tô ágkadigárran yu, asta tagù yu tô samà para kannán yu ka simag.” ");
INSERT INTO bgs_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Purisu igtagù dan sippang simag, magunawa katô igsugù i Moises kandan. Pagkasimag, madigár pô tô igsamà dan, su ándà uláddi asta ándà kamawù. ");
INSERT INTO bgs_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Igkagi si Moises, na mà din, “Ni gó tô kannán yu ni álló ni, su ni gó tô álló ka kapaginawa ébô pabantugán ta tô Áglangngagán. Ándà ágkakan na kitanán yu tun ta tanà ni álló ni. ");
INSERT INTO bgs_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Limud yu tô ágkakan dalám ka ánnám dád álló, asal tô ikapittu álló tô álló ka kapaginawa ta. Ándà ágkakan na kitanán yu tun ta tanà.” ");
INSERT INTO bgs_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Na, agad tun ta ikapittu álló, duwán duma mga manubù na igpamasak katô ágkakan. Asal ándà gó igkita dan. ");
INSERT INTO bgs_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Igkagi tô Áglangngagán ki Moises, na mà din, “Manan ka ándà kó bánnal katô mga sugù ku asta mga kagi ku? ");
INSERT INTO bgs_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Manan ka ándà dan ikagpát na igsalinna katô ikapittu álló ébô paginawa dan? Tô gó tô gunayan na dubli tô ágkakan na ágbággén ákniyu tun ta ikannám álló ébô duwán nángngà para katô duwa álló. Dalám ka álló ka kapaginawa, kailangan tumónnók kó. Yakó áglimud katô ágkakan tun ta ikapittu álló.” ");
INSERT INTO bgs_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Purisu igpaginawa tô langun manubù tun ta ikapittu álló. ");
INSERT INTO bgs_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Igngadanan dan tô ágkakan na mana. Mapputì ni iring na marénták lisu, asta tô nanam iring katô pan na igbaláttan ka tánnáb. ");
INSERT INTO bgs_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Igkagi si Moises, na mà din, “Igsugù tô Áglangngagán na kailangan taguán ta tô duwa litro ka mana para katô mga rubbad ta ébô makita dan tô ágkakan na igbággé din áknita tun ta disyerto pángnga igpid sikandin áknita tikud tun ta banuwa ka Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Igkagiyan i Moises si Aaron, na mà din, “Kangé nu tô bangà, asta dalám nu tô duwa litro ka mana. Tagù nu ni tun ta saruwan katô Áglangngagán ébô duwán pa ágkakitaan para katô mga rubbad ta.” ");
INSERT INTO bgs_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Igbánnal si Aaron katô igsugù katô Áglangngagán ki Moises. Igtagù din ni bangà tun dalám katô kaban tingód katô kasabotan ka Manama kandan. ");
INSERT INTO bgs_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Mana tô igkan katô mga rubbad i Israel dalám ka kappatan (40) ámmé sippang ka igóddô dan tun ta banuwa ka Canaan. ");
INSERT INTO bgs_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Na, tô pagtáppáng na iggamit dan, duwán gó duwa litro. ");
INSERT INTO bgs_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Igiwà tô mga rubbad i Israel tun ta tanà na igngadanan Sin, asta igalin-alin dan igkampo tun ta igsuguan katô Áglangngagán kandan. Tô igdunggù dan tun ta Repidim, ándà wayig na igkita dan para inámmán dan. ");
INSERT INTO bgs_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Purisu igburáng-buráng dan dán puman, asta igkagi sikandan ki Moises, na mà dan, “Bággéyi ké ka wayig ébô duwán inámmán dé.” Igkagi si Moises kandan, na mà din, “Manan ka ágburáng-buráng kó kanak? Manan ka ágkinnaman yu gó tô Áglangngagán?” ");
INSERT INTO bgs_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Asal su tuu ágkatákkangan tô mga manubù, marag dan ágburáng-buráng ki Moises, asta igkagi sikandan, na mà dan, “Manan ka igpid ké ikuna tikud tun ta banuwa ka Ehipto? Malyag ka na maté ké ukit ka tákkang, agad tô mga gabatà dé asta tô mga mannanap dé?” ");
INSERT INTO bgs_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Na, igrangin si Moises katô Áglangngagán, asta igkagi sikandin, na mà din, “Pamánnun ku ni mga manubù? Masiggad ikandan timbagán ka batu ébô matéya.” ");
INSERT INTO bgs_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Igkagi tô Áglangngagán ki Moises, na mà din, “Pid nu tô tukád nu na iglagpás nu katô Wayig ka Nilo. Limud nu tô mga ágpangulun katô mga rubbad i Israel, asta sadun ka tun tóna kandan. ");
INSERT INTO bgs_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mangatta ákniyu tun ta dakál batu tun ta Sinai. Lagpás nu tô batu, asta marus tô wayig ébô duwán ginámman katô mga manubù.” Igbánnal i Moises tô igsugù kandin róggun ágsállág tô mga ágpangulun ka mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Igngadanan i Moises tô lugar na Masa asta Meriba, su igburáng-buráng tô mga manubù ki Moises, asta igkinnaman dan tô Áglangngagán ukit katô igkagi dan, na mà dan, “Dumóppón tô Áglangngagán áknita, ó dì?” ");
INSERT INTO bgs_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Na, tô igkampo tô mga rubbad i Israel tun ta Repidim, igsulung tô mga Amalekanhon kandan. ");
INSERT INTO bgs_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Igkagi si Moises ki Josue, na mà din, “Tawar nu tô mga manubù, asta atu kó katô mga Amalekanhon. Simag, tumindágga tun datas katô pabungan, asta mawidda katô tukád na igbággé ka Manama kanak.” ");
INSERT INTO bgs_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Purisu igbánnal si Josue katô igkagi i Moises kandin. Igpid din tô mga manubù ébô atuwan dan tô mga Amalekanhon. Igsadun si Moises, si Aaron, asta si Hur tun datas katô pabungan. ");
INSERT INTO bgs_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Róggun igtayó pa i Moises tô tukád din, igpanalu tô mga rubbad i Israel. Asal róggun igpasunnad din tô tukád din, igpanalu tô mga Amalekanhon. ");
INSERT INTO bgs_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Na, su ibállé dán tô mga bállad i Moises, igkangé si Aaron asta si Hur ka batu ébô munsad si Moises. Igtindág si Aaron asta si Hur tun ta kilidan din, asta igtayó dan tô mga bállad i Moises. Igpanayun dan igtayó kani sippang ka igsalláp tô álló. ");
INSERT INTO bgs_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Purisu tô langun Amalekanhon igipánnas i Josue asta tô mga kadumaan din. ");
INSERT INTO bgs_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Na, igkagi tô Áglangngagán ki Moises, na mà din, “Sulat nu ni tun ta libro, asta ulit nu ni ki Josue. Ipánnasán ku tô langun Amalekanhon ébô kalingawan sikandan ka ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Igimu i Moises tô góbbówanan katô ágbággén tun ta Manama, asta igngadanan din ni na “Tô Áglangngagán gó tô bandera ku.” ");
INSERT INTO bgs_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Igkagi sikandin, na mà din, “Igtayó tô bandera katô Áglangngagán! Purisu atuwan katô Áglangngagán tô mga Amalekanhon ka ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Na, si Jetro na ugang i Moises asta parì tun ta Midian, ikadinág sikandin tingód katô langun na iglumu ka Manama ki Moises asta katô mga rubbad i Israel. Ikadinág sikandin na igpéwà katô Áglangngagán sikandan tikud tun ta banuwa ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Purisu igsadun sikandin tun ki Moises. Igpid din si Sefora na sawa i Moises na taganà igpóddô i Moises tun ta Midian. ");
INSERT INTO bgs_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Igpid pagsik i Jetro tô duwa gabatà i Moises. Si Gerson tô ngadan katô tambang kaké batà din, su tô ipamasusu sikandin, igkagi si Moises, na mà din, “Ánnà a taga kannun.” ");
INSERT INTO bgs_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Si Elieser tô ngadan katô adi, su tô ipamasusu sikandin, igkagi si Moises, na mà din, “Igtabanganna katô Manama na ágpangadapán katô mga kamónaan ku, asta igpaluwà a tikud tun ta bállad katô harì ka Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Si Jetro, tô sawa i Moises, asta tô mga gabatà din igsadun tun ki Moises tun ta disyerto, su igóddô pa sikandin asta tô mga rubbad i Israel madani tun ta pabungan na igsunnadan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Duwán igulit ki Moises, na mà din, “Igdunggù dán tô ugang nu na si Jetro, tô sawa nu, asta tô duwa gabatà yu gamama.” ");
INSERT INTO bgs_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Purisu igsumar si Moises katô ugang din. Iglingkóód asta igadák si Moises kandin. Igpakumustaé dan, asta igahu dan tun ta tulda i Moises. ");
INSERT INTO bgs_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Igulitan i Moises sikandin tingód katô langun ka iglumu katô Áglangngagán katô harì ka Ehipto asta mga sakup din ébô tabangan tô mga rubbad i Israel. Igulitan din tingód ka mga kahirapan na inókitan dan tun ta dalan, asta tingód katô kapéwà katô Áglangngagán kandan. ");
INSERT INTO bgs_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Idayawan si Jetro tingód katô langun na iglumu katô Áglangngagán para katô mga rubbad i Israel ébô makaluwà dan tikud tun ta bállad katô mga taga Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Igkagi sikandin, na mà din, “Durungán tô Áglangngagán su igpaluwà kó ikandin tikud tun ta bállad katô harì ka Ehipto asta mga sakup din! ");
INSERT INTO bgs_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ikasóddórrad na tuu pa matulus tô Áglangngagán ka tandingán tun ta langun ka ássa mga ágmanaman, su igpaluwà din tô mga sakup din tikud tun ta bállad katô mga taga Ehipto na ágpallayat-layat asta ágpahirap kandan.” ");
INSERT INTO bgs_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Na, iggóbbó i Jetro tô mga mannanap na igbággé din katô Manama. Iglimud si Aaron asta tô mga ágpangulun katô mga rubbad i Israel, asta igkan dan duma ki Jetro tun ta saruwan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Pagkasimag, igusay i Moises tô mga manubù. Igsadun dan tun kandin tikud tun ta sállám sippang ka ágkasalláp dán tô álló. ");
INSERT INTO bgs_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Tô ikakita tô ugang i Moises katô langun ka áglumun i Moises, igkagi sikandin, na mà din, “Manan ka sikuna dád tô gusay katô langun manubù? Ánnà nángngà ni! Igangat dan katô kósay nu kandan tikud tun ta sállám sippang ka ágkasalláp tô álló!” ");
INSERT INTO bgs_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Igtaba si Moises, na mà din, “Gimun ku ni su ágsadun gó tô mga manubù dini kanak ébô makasóddór dan katô kakalyag ka Manama na bánnalán dan. ");
INSERT INTO bgs_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Atin ka ágpasamuké tô mga manubù, sakán tô rumuud kandan, asta gulitan ku sikandan ka ándin tô mga sugù asta kakalyag katô Manama.” ");
INSERT INTO bgs_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Igkagi tô ugang i Moises, na mà din, “Dì madigár ni áglumun nu! ");
INSERT INTO bgs_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Mabállé ka gó, asta mabállé tô mga manubù. Tuu gó mabággat ni ka sábbad nu dád! Dì mému ka sábbad nu dád tô musay. ");
INSERT INTO bgs_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Na, paminág ka kanak. Kagiyan ku sikuna ka ándin tô madigár lumun nu. Mólà pa ka tabangan ka katô Manama! Madigár ka sikuna tô taratapid para katô mga manubù tun ta saruwan ka Manama. Pid nu tun kandin tô mga problema dan. ");
INSERT INTO bgs_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Tinurù nu kandan ka ándin tô mga sugù asta kakalyag katô Manama. Pénagpát nu kandan ka ándin tô madigár ágkémun dan asta áglumun dan. ");
INSERT INTO bgs_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Asal salin nu tô ágkasarigan mga manubù na duwán kapandayan, tô mga ágrespeto katô Manama, asta tô dì ágkapid ka tandan. Imu nu sikandan na ágpangulun katô mga sábbad mararan (1,000) manubù, ágpangulun katô mga sábbad gatus (100) manubù, ágpangulun katô mga kaliman (50) manubù, asta ágpangulun katô mga sapulù (10) manubù. ");
INSERT INTO bgs_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Sikandan tô makatabang katô mga manubù ukit katô kósay dan. Atin ka duwán kaso na tuu mahirap, tô gó tô papiddán dan tun áknikó. Asal sikandan gó tô musay katô mga kaso na dì mabággat. Mému malumák tô mga áglumun nu, su makatabang dan áknikó. ");
INSERT INTO bgs_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Atin ka tumanán nu ni ágkagin ku, asta atin ka ni gó tô sugù ka Manama áknikó, makatiis ka, asta makólì ni mga manubù na masuné tô pusung dan.” ");
INSERT INTO bgs_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Igpaminág si Moises katô ugang din, asta igbánnal din tô igkagi kandin. ");
INSERT INTO bgs_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Igsalin i Moises tô mga manubù na duwán kapandayan tun ta langun rubbad i Israel, asta igimu din sikandan na ágpangulun katô mga manubù. Igimu din sikandan na ágpangulun katô mga sábbad mararan (1,000) manubù, ágpangulun katô mga sábbad gatus (100) manubù, ágpangulun katô mga kaliman (50) manubù, asta ágpangulun katô mga sapulù (10) manubù. ");
INSERT INTO bgs_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Inalayun dan gusay katô mga manubù. Igpapid dan tô mga kaso na tuu mahirap tun ki Moises, asal sikandan tô igusay katô mga kaso na dì mabággat. ");
INSERT INTO bgs_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Na, ándà kadugé, igtananan i Jetro si Moises, asta igulì tun ta kandin banuwa. ");
INSERT INTO bgs_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Na, tô iglabé tô duwa bulan ensakto tikud tun ta kéwà dan tikud tun ta banuwa ka Ehipto, igdunggù dan tun ta disyerto na igngadanan na Sinai. ");
INSERT INTO bgs_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Igpanó dan tikud tun ta Repidim, igsadun dan tun ta lindig katô pabungan ka Sinai, asta igkampo dan. ");
INSERT INTO bgs_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Na, igtikáddág si Moises tun ta pabungan ébô madani tun ta saruwan katô Manama. Igtawar tô Áglangngagán ki Moises tikud tun ta pabungan, na mà din, “Ni gó tô kagin ku katô mga rubbad i Israel, ");
INSERT INTO bgs_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Igkita yu tô iglumu ku tun ta mga taga Ehipto. Isóddóran yu na igpid ku sikiyu tun ta madani ku, iring katô kapid katô banug katô pispis din tun ta mga pakpak din. ");
INSERT INTO bgs_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Atin ka mánnal kó kanak asta tumuman kó katô kasabotan ku tun ákniyu, imun ku sikiyu na mga manubù na igsalin ku tun ta langun manubù, su sakán tô tigatun katô tibuk banuwa. ");
INSERT INTO bgs_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Imun ku sikiyu na kanak mga manubù tun ta pagpangulu ku ébô pabantugánna ikiyu tun ta langun banuwa. Na, ulit nu ni igkagi ku tun ta mga rubbad i Israel.’” ");
INSERT INTO bgs_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Purisu igtupang si Moises, iglimud din tô mga ágpangulun, asta igulitan din sikandan katô igkagi katô Áglangngagán kandin. ");
INSERT INTO bgs_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Igpadángngané dan langun igtaba, na mà dan, “Bánnalán dé tô langun sugù katô Áglangngagán.” Purisu igulit si Moises katô Áglangngagán ka ándin tô igtaba dan. ");
INSERT INTO bgs_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Igkagi tô Áglangngagán ki Moises, na mà din, “Madunna diyan áknikó ukit ka mangittáng sagulapun ébô makadinág tô mga manubù ka tumóngkô a áknikó. Purisu inalayun dan sumarig áknikó.” Igulitan i Moises tô Áglangngagán katô igkagi katô mga manubù. ");
INSERT INTO bgs_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Igkagi tô Áglangngagán ki Moises, na mà din, “Tupang ka tun ta mga manubù, asta ni álló ni asta simag, pataganà nu sikandan ébô mangadap dan kanak. Kailangan labaan dan tô umpak dan. ");
INSERT INTO bgs_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kailangan tumaganà dan ka dì pa dumunggù tô ikatállu álló, su sumunnadda tun ta pabungan ka Sinai róggun na sumállág tô langun dan. ");
INSERT INTO bgs_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pému nu tô mga pató tun ta lindig katô pabungan ébô dì lumapas tô mga manubù tun ta pabungan. Kagiyi nu sikandan na dì dan tumikáddág tun ta pabungan. Dì gó mému awidan dan tô lindig katô pabungan, su matayan gó tô dì mánnal. ");
INSERT INTO bgs_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Agad manubù asta mannanap, ka lumapas dan katô pató tun ta pabungan, kailangan timbagán dan ka batu ó panaán dan ébô maté, su dì mému awidan yu tô lumapas katô pató. Kailangan lumili tô mga manubù katô pabungan sippang ka idupán tô trumpeta. Atin ka dinággán dan tô trumpeta, kailangan malimud dan tun ta lindig katô pabungan.” ");
INSERT INTO bgs_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Na, igtupang si Moises katô pabungan, asta igpataganà din tô mga manubù ébô mangadap dan. Iglabaan dan tô mga umpak dan. ");
INSERT INTO bgs_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Igkagiyan i Moises sikandan, na mà din, “Taganà kó para katô ikatállu álló, asta yakó ágpalayuké.” ");
INSERT INTO bgs_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tô igsállám dán tô ikatállu álló, tuu igkilat asta igkirám tun ta pabungan. Igsunnad tô mangittáng sagulapun tun ta pabungan. Igdinág dan tô mabákkár dagingán katô trumpeta, asta igkárkár dan langun tingód ka máddang dan. ");
INSERT INTO bgs_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Igpid i Moises tô mga manubù tikud tun ta kampo dan ébô sumumar katô Manama. Igtindág dan tun ta lindig katô pabungan. ");
INSERT INTO bgs_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ándà kakitayi tô pabungan su isidalungan katô mangittáng ábbál, su igsunnad tô Áglangngagán na iring na bónnóng ka apuy. Ibatun tô ábbál iring na ábbál na ágtikud tun ta dakál ággóbbówanan. Tuu igkálláng-kálláng tô tibuk katô pabungan. ");
INSERT INTO bgs_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Tô tuu pa igmabákkár tô dagingán katô trumpeta, igkagi si Moises, asta mabákkár tô kataba katô Manama iring na dalágdág ka kilat. ");
INSERT INTO bgs_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Igsunnad tô Áglangngagán tun ta bówwó katô pabungan ka Sinai, asta igtawar din si Moises na madun tun datas ta pabungan. Purisu igtikáddág si Moises. ");
INSERT INTO bgs_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Igkagi tô Áglangngagán ki Moises, na mà din, “Tupang ka, asta sugù nu tô mga manubù ébô dì dan lumapas katô pató. Dì mému tumikáddág dan ébô sumállág dan kanak, su maté tô lumapas. ");
INSERT INTO bgs_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Agad tô mga parì na ágpadani kanak, kailangan palinis dan agó matayan ku sikandan.” ");
INSERT INTO bgs_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Igkagi si Moises katô Áglangngagán, na mà din, “Asal dì tumikáddág tô mga manubù, su taganà ka igkagi kandan na dì mému. Igkagi nu kanak na imun ku tô pató ébô dì makapadani tô mga manubù tun ta pabungan.” ");
INSERT INTO bgs_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Asal igkagi tô Áglangngagán, na mà din, “Tupang ka pa, asta tikáddág ka puman na tákkássan i Aaron. Asal yaka nu ágpalapasi tô mga parì asta tô duma mga manubù ébô tumikáddág dan agó supakan ku sikandan.” ");
INSERT INTO bgs_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Purisu igtupang si Moises tun ta mga manubù, asta igulitan din sikandan katô igkagi katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ni gó tô igkagi katô Manama tun ta mga manubù, na mà din, ");
INSERT INTO bgs_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Sakán tô Áglangngagán na Manama yu. Igpaluwà a ákniyu tikud tun ta kallang ákniyu tun ta banuwa ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Yakó ágpangadap katô ássa mga ágmanaman. Sakán dád gó tô pangadapán yu. ");
INSERT INTO bgs_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Yakó gimu katô ágmanaman iring na bónnóng ka agad ándin tun ta langit, tun ta banuwa, ó tun ta dalám ka dagat. ");
INSERT INTO bgs_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Yakó ágpangadap asta áglingkóód kanan, su sakán dád tô Áglangngagán na Manama yu. Diya pabayà katô mangadap katô ágmanaman. Supakan ku tô méllé kanak, asta supakan ku tô mga gabatà din asta mga rubbad din sippang tun ta apù ka abul. ");
INSERT INTO bgs_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Asal tô mga manubù na ágginawa kanak asta ágbánnal katô mga sugù ku, tô gó é inalayun ku ginawaan sippang tun ta mga mararan karubbadan. ");
INSERT INTO bgs_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Yakó ágtawang ágkagi tingód katô ngadan katô Áglangngagán na Manama yu, su supakan ku tô manubù na tumawang kumagi tingód katô ngadan ku. ");
INSERT INTO bgs_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Tuman yu tô ágkémun tingód katô álló ka kapaginawa, su tuu ugis tô álló ka kapaginawa. ");
INSERT INTO bgs_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Makalumu kó dalám ka ánnám álló. ");
INSERT INTO bgs_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Asal tô ikapittu álló, tô gó é álló ka kapaginawa yu ébô pangadapán yu tô Áglangngagán na Manama yu. Tun ta álló ka kapaginawa, yakó áglumu, agad sikiyu, tô mga gabatà yu, tô mga taratabang yu, tô mga mannanap yu, asta tô ássa mga manubù na góddô tun ákniyu. ");
INSERT INTO bgs_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Dalám ka ánnám álló, igimu ku tô langit, tô tanà, tô dagat asta tô langun-langun. Asal igpaginawa a tun ta ikapittu álló. Purisu igimu ku na madigár asta ugis tô álló ka kapaginawa. ");
INSERT INTO bgs_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Respetowi yu tô ákniyu ámmà asta innà ébô kumallayat tô kantayan yu diyan ta tanà na bággén ákniyu katô Áglangngagán na Manama yu. ");
INSERT INTO bgs_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Yakó ágmaté. ");
INSERT INTO bgs_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Yakó áglibug. ");
INSERT INTO bgs_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Yakó ágtakó. ");
INSERT INTO bgs_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Yakó ágtestigos ka bulaló tingód katô unawa yu. ");
INSERT INTO bgs_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Yakó ágkasabuan ka balé katô unawa yu manubù. Yakó ágkasabuan ka sawa katô unawa yu manubù, mga taratabang din, baka din ó asno din, ó agad ándin tô kaduwánnan katô unawa yu manubù.”");
INSERT INTO bgs_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Na, duwán sábbad álló igkagi tô Áglangngagán ki Jonas na batà i Amitai, na mà din, ");
INSERT INTO bgs_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Panó ka, sadun ka tun ta Ninibe tô dakál lunsud, asta sapadi nu tô mga taga Ninibe, su isóddóran ku na tuu dán madat tô áglumun dan.” ");
INSERT INTO bgs_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Asal ándà sadun si Jonas tun ta lunsud ka Ninibe. Igplano baling sikandin na madun tun ta banuwa ka Espanya ébô makapadiyù pád tikud tun ta Áglangngagán. Purisu igsadun sikandin tun ta Jopa, asta ikakita sikandin ka barko na madun tun ta Espanya. Na, igbággé din tô plite, asta igsaké sikandin duma katô mga taralumu tun ta barko, su kéman din ka makapadiyù tikud tun ta Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Asal tô tun dan dán ta dagat, igpapiddan dan katô Áglangngagán ka tuu mabákkár karamag asta magdakál mga balud, asta masig masirà tô barko. ");
INSERT INTO bgs_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Purisu imáddangan tuu tô mga taralumu. Igpédu-édu tô tagsábbad-sábbad tun ta kandan mga ágmanaman, asta igpangantug dan tô mga piniddan dan tun ta dagat ébô ágmagan tô barko asta dì malánnád. Asal si Jonas igdággà dutun ta sunu tun dalám katô barko, asta tuu italáp sikandin ka katudug. ");
INSERT INTO bgs_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Na, ikitaan sikandin katô kapitan ka barko, asta igkagi sikandin, na mà din, “Manan ka ágtudug ka dalám kani kadattan ta? Ánnó ka, asta pamuyù ka ka tabang katô áknikó manama agó kéduwan sikandin áknita ébô dì ki maté!” ");
INSERT INTO bgs_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Na, igpatóngkóé tô mga taralumu, na mà dan, “Bé kód! Rumipa ki ébô kasóddóran ta ka sadan tô gunayan kani kadattan.” Purisu igripa dan, asta tô ngadan i Jonas tô ipudutan. ");
INSERT INTO bgs_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Na, iginsà dan si Jonas, na mà dan, “Sikuna tô gunayan kani kadattan? Manan ka kannun ka? Ánda banuwayi é igtikudan nu? Ándin manubui é igtikudan nu?” ");
INSERT INTO bgs_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Igtaba si Jonas, “Sakán é sábbad Hebreo. Ágpangadapán ku tô Áglangngagán na Manama tun datas ta langit na igimu katô dagat asta katô tanà.” ");
INSERT INTO bgs_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Na, igulit si Jonas kandan na kéman din ka makapadiyù sikandin tikud tun ta Áglangngagán. Purisu tuu imáddangan sikandan, asta igkagi dan ki Jonas, “Makamáddang gó ni iglumu nu!” ");
INSERT INTO bgs_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Na, tuu dán ágdakál tô mga balud. Purisu igkagiyan dan si Jonas, na mà dan, “Mánnun dé sikuna ébô sumódô ni mabákkár karamag na ágpid kani magdakál balud?” ");
INSERT INTO bgs_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Igtaba si Jonas, na mà din, “Antugga tun ta dagat ébô sumódô tô magdakál balud, su isóddóran ku na sakán é gunayan kani dakál kadattan na igdunggù ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Na, ándà nunug tô mga taralumu, asal igággár-ággár dan baling ágbugsay sippang katô ágkému dan ébô mapid pád tô barko tun ta ligad ka dagat. Asal ándà dan ikému su tuu ágmabákkár tô karamag. ");
INSERT INTO bgs_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Purisu igpédu-édu dan katô Áglangngagán, na mà dan, “Áglangngagán, yaka ágsupak áknami tingód katô kamaté dé kani manubù ni, su sikuna, Áglangngagán, tô igpapid kani tingód ka kakalyag nu.” ");
INSERT INTO bgs_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Na, igánnat dan si Jonas. Igantug dan tun ta dagat. Igtigkarun dád igsódô tô magdakál balud. ");
INSERT INTO bgs_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Purisu tuu imáddangan tô mga taralumu tun ta Áglangngagán, asta igpangadap dan kandin ukit katô mannanap na igbággé asta iggóbbó dan tun ta saruwan din, asta duwán mga igtandô dan kandin. ");
INSERT INTO bgs_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Na, tô igantug si Jonas tun ta dagat, igpalámmád katô Áglangngagán ka tuu dakál sáddà. Dutun si Jonas ta gátták katô sáddà dalám ka tállu álló asta tállu dukilám. ");
INSERT INTO bgs_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Na, róggun si Jonas tun dalám katô gátták katô sáddà, igdasal sikandin tun ta Áglangngagán na Manama na ágpangadapán din, na mà din, ");
INSERT INTO bgs_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Áglangngagán, tô dutunna ta karasayan, igtawarra áknikó, asta igtaba ka kanak. Agad madaniya tun ta góddóan ka mga inaté, igpédu-éduwa tun áknikó, asta igpaminágga ikuna. ");
INSERT INTO bgs_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Igantugga ikuna tun ta madalám dagat, ilibutanna katô dagat, asta itambunanna katô mga magdakál balud na igpapid nu. ");
INSERT INTO bgs_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Igpanámdámma na igpapadiyù a ikuna, asta diya muman makasadun tun ta ugis templo nu. ");
INSERT INTO bgs_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Ilánnádda tun ta dagat, tuuwa itambunan katô dagat, asta itángngás ni ulu ku katô mga sigbát ka dagat. ");
INSERT INTO bgs_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ilánnádda sippang tun ta ágpónsadan katô mga pabungan tun dalám ka dagat. Tô milánnádda, duwán ikadalang kanak, asta kéman ku na diyad makaluwà. Asal Áglangngagán na Manama na ágpangadapán ku, igpid ka kanak na manté tikud tun ta kadalámman. ");
INSERT INTO bgs_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Áglangngagán, tô igriyuwa na masiggad maté, isampáttan ku sikuna. Purisu igdasalla áknikó asta igpaminág ka kanak tun ta ugis templo nu. ");
INSERT INTO bgs_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Na, tô mga manubù na ágpangadap katô mga ágmanaman na ándà ágpulusán, ágtanan dan áknikó na makatabang pád kandan. ");
INSERT INTO bgs_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Asal sakán, kumanta a asta dumurungnga áknikó. Mangadappa áknikó ukit ka mannanap na bággén ku áknikó asta góbbón. Tumanán ku tô mga igtandô ku áknikó. Áglangngagán, tikud tun áknikó tô kaluwaan!” ");
INSERT INTO bgs_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Na, igpapid katô Áglangngagán tô sáddà na luwaán si Jonas tun ta ligad ka dagat. ");
INSERT INTO bgs_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Na, igkagi puman tô Áglangngagán ki Jonas, na mà din, ");
INSERT INTO bgs_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Panó ka. Sadun ka tun ta Ninibe tô dakál lunsud, asta ulit-ulit nu tun ta mga manubù tô kagi ku na igsarig ku áknikó.” ");
INSERT INTO bgs_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Purisu igbánnal si Jonas katô Áglangngagán, asta igsadun sikandin tun ta Ninibe. Ni Ninibe tuu dakál lunsud, su mga tállu álló ágpanón yan pa makadunggù dutun ágbaluy. ");
INSERT INTO bgs_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Tô una álló katô kapanó i Jonas tun ta lunsud, igullaó sikandin, na mà din, “Kappatan dád man álló, dadattan dán ni lunsud ka Ninibe!” ");
INSERT INTO bgs_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Na, tô langun manubù na góddô tun ta Ninibe igbánnal katô Manama. Purisu tô langun manubù, tikud tun ta mallayat é kamanubuan sippang tun ta mabbabà é kamanubuan, igpuwasa asta igumpak dan katô óggét na gimun sako na pató katô karákkád dan. ");
INSERT INTO bgs_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Na, tô mikadinág tô harì ka Ninibe, igtananan din tô gunsadanan din, iglusut din tô kapa din, igumpak sikandin katô óggét na gimun sako, asta igunsad tun ta abu. ");
INSERT INTO bgs_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Na, igpapid din tô pasóddór tun ta mga manubù na góddô tun ta Ninibe, na mà din, “Ni gó tô sugù katô harì asta mga opisyales din, na dì mému kuman asta minám tô langun ka manubù, agad tô mga baka asta tô mga karnero. ");
INSERT INTO bgs_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Asal kailangan mumpak tô langun manubù katô óggét na gimun sako, asta tambunan tô langun baka asta mga karnero katô óggét na gimun sako. Tô langun manubù kailangan tuu pédu-édu dumasal tun ta Manama, asta sumugban katô madat áglumun dan asta katô kamaté dan ka manubù ");
INSERT INTO bgs_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","agó mapalin pa tô plano katô Manama. Mólà pa ka dì dán tuu masókó sikandin áknita, asta dì ki maté!” ");
INSERT INTO bgs_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Na, tô migkita ka Manama tô iglumu dan, asta tô igsugban sikandan katô mga madat áglumun dan, inéduwan tô Manama kandan, asta ándà din panayuni tô supak na papiddán din pád kandan. ");
INSERT INTO bgs_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Asal si Jonas tuu iranu tingód katô karákkád dan, asta isókó sikandin. ");
INSERT INTO bgs_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Purisu igdasal sikandin tun ta Áglangngagán, na mà din, “Áglangngagán, ituman dán tô igkagi ku tô dutunna pa ta banuwa ku, asta tô gó tô gunayan na sékótta igsuwé asta igsadunna pád tun ta Espanya! Su ikasóddórra na sikuna tô duwán dakál ginawa, asta médu-édu ka katô mga manubù. Mallayat é ginawa nu, asta tuu ka ágginawa, asta ikataganà ka ágpalin katô plano nu tingód katô supak nu. ");
INSERT INTO bgs_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Purisu angéyad, su madigár pa ka matéyad.” ");
INSERT INTO bgs_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Na, igtaba tô Áglangngagán, na mà din, “Dì nángngà na masókó ka.” ");
INSERT INTO bgs_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Na, igiwà si Jonas tikud tun ta Ninibe, igsadun dadan tun ta silatan katô lunsud, igimu din tô gállunganan din, asta igunsad sikandin róggun gangat ébô kitanán din ka mamánnu tô lunsud ka Ninibe. ");
INSERT INTO bgs_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Na, igpatubù katô Áglangngagán na Manama tô pamula ébô kallungan tô ulu i Jonas asta kumadigár tô ginawa din. Purisu tuu idayawan si Jonas tingód katô pamula. ");
INSERT INTO bgs_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Asal pagkasimag tô masig dán ágkasállám, igpakan ka Manama ka ulád tô butbut katô pamula. Purisu ilanás dán. ");
INSERT INTO bgs_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Tô igsilat dán tô álló, igpapid ka Manama tô ménit karamag tikud tun ta silatan, asta igmalómét si Jonas tingód katô sánnang na ikasugat katô ulu din. Purisu igkagi sikandin tun ta Manama, na mà din, “Madigár pa ka matéyad.” ");
INSERT INTO bgs_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Asal iginsà tô Manama kandin, na mà din, “Nángngà ka masókó ka tingód katô pamula?” Igtaba si Jonas, “Nángngà ka masókówa. Purisu kakalyag ku na matéyad.” ");
INSERT INTO bgs_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Na, igkagi tô Áglangngagán kandin, na mà din, “Ni pamula ni igtubù ka sábbad dád dukilám, na pagkasimag ilanás. Ándà nu imuwi ni. Ánnà sikuna tô igpatubù. Agad ándà kédu nu katô mga manubù tun ta Ninibe, asal iranu ka tingód kani pamula. ");
INSERT INTO bgs_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Na, tuuwa pa ágkéduwan katô mga manubù tun ta Ninibe na dakál lunsud, su sobra ka sábbad gatus duwa pulù mararan (120,000) tô mga gabatà dutun na ándà kinanuwan ka ándin é madigár asta madat, asta marapung tô mga baka asta tô mga karnero.”");
INSERT INTO bgs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ni gó tô mga ngadan katô mga kamónaan i Jesu-Cristo na rubbad i David. Si David tô rubbad i Abraham. ");
INSERT INTO bgs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham tô ámmà i Isaac. Si Isaac tô ámmà i Jacob. Si Jacob tô ámmà i Juda asta mga kataladi din gamama. ");
INSERT INTO bgs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda tô ámmà i Fares asta i Sara. Si Tamar tô innà dan. Si Fares tô ámmà i Esrom. Si Esrom tô ámmà i Aram. ");
INSERT INTO bgs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram tô ámmà i Aminadab. Si Aminadab tô ámmà i Naason. Si Naason tô ámmà i Salmon. ");
INSERT INTO bgs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon tô ámmà i Boos, asta si Rahab tô innà din. Si Boos tô ámmà i Obed, asta si Ruth tô innà din. Si Obed tô ámmà i Isai. ");
INSERT INTO bgs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Isai tô ámmà katô harì na si David. Si David tô ámmà i Solomon, asta innà din tô sawa dángngan i Urias. ");
INSERT INTO bgs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon tô ámmà i Roboam. Si Roboam tô ámmà i Abias. Si Abias tô ámmà i Asa. ");
INSERT INTO bgs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa tô ámmà i Josafat. Si Josafat tô ámmà i Joram. Si Joram tô ámmà i Usias. ");
INSERT INTO bgs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usias tô ámmà i Jotam. Si Jotam tô ámmà i Acas. Si Acas tô ámmà i Ezequias. ");
INSERT INTO bgs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezequias tô ámmà i Manases. Si Manases tô ámmà i Amon. Si Amon tô ámmà i Josias. ");
INSERT INTO bgs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias tô ámmà i Jeconias asta mga kataladi din gamama. Igámmát dan asta tô mga unawa dan na mga rubbad i Israel, asta igpid sikandan tun ta madiyù banuwa na ágngadanan Babilonia. ");
INSERT INTO bgs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Róggun igóddô dan tun ta Babilonia, si Jeconias tô ámmà i Salatiel. Si Salatiel tô ámmà i Sorobabel. ");
INSERT INTO bgs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sorobabel tô ámmà i Abiud. Si Abiud tô ámmà i Eliakim. Si Eliakim tô ámmà i Asor. ");
INSERT INTO bgs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor tô ámmà i Sadoc. Si Sadoc tô ámmà i Aquim. Si Aquim tô ámmà i Eliud. ");
INSERT INTO bgs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud tô ámmà i Eleasar. Si Eleasar tô ámmà i Matan. Si Matan tô ámmà i Jacob. ");
INSERT INTO bgs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob tô ámmà i Jose. Si Jose tô duma i Maria na innà i Jesus. Si Jesus tô ágtawarán Mesiyas. ");
INSERT INTO bgs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Purisu tikud tun ki Abraham sippang tun ki David, sapulù áppat (14) é karubbadan katô mga pamilya na igpatalundugé. Tikud tun ki David sippang tun ta kapid katô mga rubbad i Israel tun ta Babilonia, sapulù áppat (14) é karubbadan katô mga pamilya na igpatalundugé. Tikud tun ta kapid kandan tun ta Babilonia sippang tun ta kapamasusu katô Mesiyas, sapulù áppat (14) é karubbadan katô mga pamilya na igpatalundugé. ");
INSERT INTO bgs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na, ni gó tô gulitán tingód katô kapamasusu ki Jesu-Cristo. Si Maria tô innà din, asta duwán banà din na ágngadanan ki Jose. Tô ándà dan pa padumaé, igmabáddás si Maria ukit katô Ugis Espiritu. ");
INSERT INTO bgs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na, tô banà din na si Jose ágbánnal katô mga sugù ka Manama. Purisu tô ikasóddór sikandin na igmabáddás dán si Maria, igpanámdám sikandin na dì dán pakasal ki Maria. Tô kakalyag i Jose na pasugbané dan na ándà manubù na makasóddór ébô dì kayyaan si Maria. ");
INSERT INTO bgs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Asal róggun katô kapanámdám din, duwán panaligan katô Áglangngagán na igpakita kandin ukit ka tagénáp. Igkagi tô panaligan, na mà din, “Jose, rubbad i David, yaka ágkamáddangan na pakasal ki Maria, su igmabáddás sikandin ukit ka Ugis Espiritu. ");
INSERT INTO bgs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Duwán batà mama na pamasusun din, asta ngadanan nu tô batà ki Jesus, su sikandin tô tumábbus katô kandin mga manubù tikud tun ta salà.” ");
INSERT INTO bgs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Inému ni ébô matuman tô taganà igkagi katô Áglangngagán ukit katô propeta din sayyan, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Na, kumabáddás tô sábbad bayi na ándà pa kalayuki, asta mapamasusu tô batà mama na ngadanan ki Emmanuel.” (Tô kóbadan, “Tô Manama igduma áknita.”) ");
INSERT INTO bgs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tô igánnó dán si Jose, igbánnal sikandin katô igkagi ka panaligan katô Áglangngagán kandin, asta igpakasal sikandin ki Maria. ");
INSERT INTO bgs_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Asal ándà dan palayuké sippang ka ipamasusu dán tô batà. Igngadanan i Jose tô batà ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ipamasusu si Jesus tun ta lunsud ka Betlehem na sakup ka probinsya ka Judea dalám ka pagpangulu katô harì na si Herodes. Na, duwán mga manubù na igdunggù tun ta lunsud ka Jerusalem tikud tun ta madiyù banuwa tun ta silatan. Sikandan tô katig tingód katô pató na kakilalaan tun ta mga karani. ");
INSERT INTO bgs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Iginsà sikandan, na mà dan, “Ánda tô délák batà na mému Harì ka mga Judio? Tun ta góddóan dé tun ta silatan, igkita dé tô karani na pató tingód katô kapamasusu kandin. Igsadun ké dini ébô mangadap kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tô igdinág i Herodes na duwán mému harì na mullas kandin, itanaan sikandin asta tô langun taga Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Purisu igpalimud din tô langun ka mallayat ka mga pangulu ka templo asta mga taratinurù ka mga sugù i Moises. Iginsà sikandin ka ánda mapamasusu tô Mesiyas. ");
INSERT INTO bgs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Igtaba sikandan, na mà dan, “Tun ta Betlehem kannun ta probinsya ka Judea, su tô gó tô igsulat katô propeta ka Manama sayyan, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Sikiyu mga taga Betlehem, agad ibantug tô duma mga lunsud tun ta probinsya yu na Judea, asal tuu pa mabantug tô lunsud yu, su tikud tun ákniyu tô Áglangngagán na mangulu katô mga rubbad i Israel na igsalin ku.’” ");
INSERT INTO bgs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Purisu igpakangé i Herodes tô mga manubù na katig tingód katô pató na kakilalaan tun ta mga karani. Ilimud dan na ándà duma manubù na ikasóddór, asta iginsà si Herodes kandan na kadángngan dan igkita tô karani. ");
INSERT INTO bgs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Igkagiyan din sikandan, na mà din, “Sadun kó tun ta Betlehem, asta pamasak yu tô batà. Atin ka kitanán yu sikandin, lónód kó dini asta ulitiya ébô madunna pagsik, asta mangadappa kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Na, igpanó dan asta igkita dan puman tô karani na igkita dan dán tun ta silatan. Tô igkita dan dán tô karani, tuu dan idayawan, asta tô gó tô igtákkássan dan sippang ka igsódô tun datas katô balé na igóddóan i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tô igahu dan dán tun ta balé, igkita dan tô batà, asta tô innà din na si Maria. Iglingkóód dan, asta igpangadap dan katô batà. Igukar dan tô piniddan dan, na mga bulawan, mga pamammut na góbbón, asta mga bawì na ágngadanan mira. Igbággé dan tô langun tun ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na, igkagi tô Manama kandan ukit ka tagénáp na dì mému ka lumónód dan tun ki Herodes. Purisu tô igulì dan tun ta banuwa dan, igukit dan tun ta ássa dalan. ");
INSERT INTO bgs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na, tô igpanó dán tô katig mga manubù, duwán panaligan katô Áglangngagán na igpakita ki Jose ukit ka tagénáp. Igkagi tô panaligan, na mà din, “Ánnó ka. Pid nu tô batà asta tô innà din, asta palaguy kó tun ta banuwa ka Ehipto. Óddô kó tun sippang ka pólián ku sikiyu, su duwán mga sundalo na papiddán i Herodes ébô pamasakán tô batà asta matayan.” ");
INSERT INTO bgs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Purisu tô dukilám tô, igánnó si Jose, asta igpid din tô batà asta tô innà tun ta banuwa ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Igóddô dan tun sippang na inaté si Herodes. Inému ni ébô matuman tô igkagi katô Áglangngagán ukit katô propeta din sayyan, na mà din, “Pólián ku tô batà ku tikud tun ta Ehipto.” ");
INSERT INTO bgs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na, tô ikasóddór dán si Herodes na ándà lónód tô katig mga manubù tun kandin, tuu isókó sikandin. Purisu igsugù din tô mga sundalo tun ta lunsud ka Betlehem asta madani mga lunsud ébô matayan tô langun gabatà gamama tikud tun ta mantu igpamasusu sippang ka duwa ámmé, su tô gó é kadugéyan na igulit katô katig mga manubù tingód katô pató na kakilalaan tun ta mga karani. ");
INSERT INTO bgs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Inému ni ébô matuman tô igkagi katô propeta ka Manama sayyan na si Jeremias, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Duwán dinággán yu tun ta lunsud ka Rama. Sumággó asta dumarawit si Raquel, su maranu tingód ka mga gabatà din. Sumággó asta dì mórór su inandaan ka mga gabatà din.” ");
INSERT INTO bgs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na, tô inaté dán si Herodes, duwán panaligan katô Áglangngagán na igpakita ki Jose ukit ta tagénáp tun ta banuwa ka Ehipto. ");
INSERT INTO bgs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Igkagi tô panaligan, na mà din, “Ánnó ka. Pid nu tô batà asta tô innà din, asta ulì kó tun ta banuwa ka Israel, su inaté dán tô manubù na mimmaté pád katô batà.” ");
INSERT INTO bgs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Purisu igánnó si Jose, asta igpid din tô batà asta tô innà, asta igulì dan tun ta banuwa ka Israel. ");
INSERT INTO bgs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Asal ándà dan sadun tun ta probinsya ka Judea. Imáddangan si Jose su igdinág sikandin na igpangulu dán si Arquelao na bullas katô ámmà din na inaté na si Herodes. Igkagiyan ka Manama si Jose ukit ka tagénáp. Purisu igsadun dan tun ta probinsya ka Galilea. ");
INSERT INTO bgs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Igóddô dan tun ta lunsud ka Nazaret. Purisu ituman tô igkagi katô mga propeta ka Manama sayyan na si Jesus ngadanan na taga Nazaret. ");
INSERT INTO bgs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na, duwán álló na igsadun si Juan na Tarabunyag tun ta disyerto ka probinsya ka Judea. Igulit-ulit sikandin katô mga manubù na igsadun dutun kandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Rákkád kód, su masig dán mangulu tô Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na, duwán igsulat tingód ki Juan tun ta libro katô propeta sayyan na si Isaias, na mà din, “Duwán sábbad manubù na dinággán yu na gullaó tun ta disyerto, na mà din, ‘Taganà yu tô ukitanan katô Áglangngagán. Tullid yu tô dalan na ukitan din.’” ");
INSERT INTO bgs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na, tô umpak i Juan igabál tikud tun ta bulbul ka mannanap na kamelyo, asta tô állán din kindal ka mannanap. Tô ágkannán din mga apang asta tánnáb na ágkangén din tun ta disyerto. ");
INSERT INTO bgs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Marapung tô mga manubù tikud tun ta Jerusalem asta duma mga lunsud na sakup ka probinsya ka Judea asta madani tun ta Wayig ka Jordan na igsadun tun ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Igrákkád dan katô mga salà dan, asta igbunyagan din sikandan tun ta Wayig ka Jordan. ");
INSERT INTO bgs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na, tô igkita si Juan katô marapung mga Pariseo asta mga Saduseo na igsadun tun kandin ébô pabunyag dan, igkagi sikandin, na mà din, “Madat kó iring na mga áppuy! Manan ka pabunyag kó agad ándà kó rákkád? Kéman yu ka dì kó supakan ka Manama tun ta tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lumu yu tô nángngà tun ta saruwan ka Manama ébô kasóddóran na bánnal igrákkád kód asta igsódô kód áglumu ka salà. ");
INSERT INTO bgs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yakó ágpanámdám na dì kó supakan su sikiyu tô mga rubbad i Abraham. Kagiyan ku sikiyu, agad ni mga batu mému imun ka Manama na mga rubbad i Abraham na bullas ákniyu. ");
INSERT INTO bgs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Iring kó na kayu na masig dán pilén, su ágpilén asta ággóbbón tô langun kayu na ándà madigár buuy. ");
INSERT INTO bgs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ágbunyagga ákniyu ka wayig ébô kakitaan na igrákkád kó ka mga salà. Asal duwán pa dumunggù na tuu pa mallayat tô kamanubuan din ka tandingán kanak. Ánnà a nángngà na tumabang kandin agad midda dád ka sandalyas din. Sikandin tô munyag ákniyu ka Ugis Espiritu asta apuy. ");
INSERT INTO bgs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iring sikandin na manubù na ágpalayap ka trigo na igarik din, tipunán din, asta taguán din tun ta lukung. Asal tô uut asta uppis góbbón din tun ta apuy na dì ágkapadáng.” ");
INSERT INTO bgs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na, igpanó si Jesus tikud tun ta probinsya ka Galilea, asta igsadun sikandin tun ta Wayig ka Jordan ébô pabunyag ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Asal dì malyag si Juan munyag ki Jesus, su igkagi si Juan, na mà din, “Dì mému ka sakán tô munyag áknikó. Kailangan sikuna tô munyag kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Asal igkagi si Jesus, na mà din, “Bunyagiya gó, su kailangan tumuman ki katô langun kakalyag ka Manama.” Purisu ignunug si Juan, ");
INSERT INTO bgs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","asta igbunyagan din si Jesus. Tô igiwà si Jesus tikud tun ta wayig, ipókéan tô langit, asta igkita din tô Ugis Espiritu na igsunnad tun kandin na iring na salapati. ");
INSERT INTO bgs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Duwán kagi tikud tun ta langit, na mà din, “Ni gó ni kanak Batà na ágginawaan ku. Ágkadayawanna gó kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na, igpid katô Ugis Espiritu si Jesus tun ta disyerto ébô tintalán i Maibuyan. ");
INSERT INTO bgs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dalám ka kappatan (40) álló asta kappatan (40) dukilám, ándà palang igkan i Jesus. Purisu igballus sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Igpadani si Maibuyan kandin, asta igkagi sikandin, na mà din, “Atin ka sikuna tô Batà ka Manama, imu nu pan ni mga batu.” ");
INSERT INTO bgs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Asal igtaba si Jesus, na mà din, “Diya, su mà katô kagi ka Manama, “‘Ánnà dád ágkannán é ágkailanganán katô kantayan ka manubù, asal tuu ágkailanganán tô langun igkagi ka Manama.’” ");
INSERT INTO bgs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na, igpid i Maibuyan si Jesus tun ta Jerusalem, asta igpatindág din tun ta bówwó katô templo. ");
INSERT INTO bgs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Igkagi si Maibuyan, na mà din, “Na, atin ka sikuna tô Batà ka Manama, tuppas ka tun ta tanà. Dì ka mamánnu, su mà katô kagi ka Manama, “‘Papiddán katô Manama tô mga panaligan din ébô tumómmóng áknikó.’ ‘Sakámmán ka katô mga panaligan din ébô dì makadag tô paa nu tun ta mga batu.’” ");
INSERT INTO bgs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Asal igtaba si Jesus, na mà din, “Diya, su mà pagsik katô kagi ka Manama, “‘Yakó ágtintal katô Áglangngagán na Manama yu.’” ");
INSERT INTO bgs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na, igpid i Maibuyan si Jesus tun ta mallayat pabungan, asta igpakita din ki Jesus tô langun banuwa dini ta bówwó ka tanà asta tô kadigárran kani. ");
INSERT INTO bgs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Igkagi si Maibuyan, na mà din, “Atin ka lumingkóód ka asta mangadap ka kanak, bággén ku áknikó ni langun.” ");
INSERT INTO bgs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Asal igtaba si Jesus, na mà din, “Maibuyan, iwà ka! Diya, su mà katô kagi ka Manama, “‘Tô dád Áglangngagán na Manama tô kailangan ágpangadapán yu, asta sikandin dád tô kailangan bánnalán yu.’” ");
INSERT INTO bgs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Purisu igiwà si Maibuyan, asta igdunggù tô mga panaligan ka Manama na igtabang ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na, igpammát i Herodes si Juan na Tarabunyag, asta igpapriso din. Tô ikasóddór dán si Jesus, igulì sikandin tun ta probinsya ka Galilea. ");
INSERT INTO bgs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ándà sikandin óddô tun ta lunsud ka Nazaret, asal igallus sikandin tun ta lunsud ka Capernaum tun ta ligad ka ranó na dadan tun ta tanà ka mga rubbad i Zabulon asta mga rubbad i Neftali. ");
INSERT INTO bgs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Purisu ituman tô igkagi katô propeta ka Manama sayyan na si Isaias tingód katô kadunggù i Jesus na igpanunggiringan ka iló, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tô langun manubù na góddô tun ta tanà ka Zabulon asta Neftali, tun ta ligad ka ranó, tun ta dipag ka Wayig ka Jordan, asta tun ta Galilea na góddóan katô mga manubù na dì ágbánnal ka Manama, ");
INSERT INTO bgs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","agad iring na góddô dan tun ta kangittángngan, asal kitanán dan tô kappawaan. Agad góddô dan tun ta kangittángngan asta ágkamáddangan dan ka kamatayan, asal kataddawan dan.” ");
INSERT INTO bgs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na, igtigkané si Jesus igulit-ulit, asta igkagi sikandin, na mà din, “Rákkád kód, su masig dán mangulu tô Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Duwán sábbad álló, igpanó si Jesus tun ta ligad ka Ranó ka Galilea. Igkita din tô duwa mataladi gamama na si Simon na ágngadanan ki Pedro, asta si Andres. Igpamukut dan su taraággut dan ka sáddà. ");
INSERT INTO bgs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Igkagi si Jesus, na mà din, “Tákkás kó kanak, su tinuruan ku sikiyu na mággut ka mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tigkô dan igtananan tô mga pukut, asta igtákkás dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Igpanayun si Jesus igpanó, asta igkita din tô ássa mataladi gamama na si Santiago asta si Juan na duwa gabatà i Sebedeo. Tun dan ta barangé asta tô ámmà dan, su ágpiyà dan ka mga pukut. Igtawar dan i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tigkô dan igtananan tô barangé asta tô ámmà dan, asta igtákkás dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na, igsadun si Jesus tun ta langun lunsud tun ta kaluwagan ka probinsya ka Galilea, asta igulit-ulit sikandin tun ta mga simbaan ka Judio. Igtinurù sikandin ka Madigár Gulitán tingód katô pagpangulu ka Manama, asta igdappánnan din ka bállad tô langun manubù na ágkabógókan asta duwán kalómétan ébô kólian. ");
INSERT INTO bgs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Purisu ibantug sikandin tun ta kaluwagan ka Siria. Igpid tun kandin tô langun manubù na ágkabógókan, agad ándin klasiyi ka bógók, asta manubù na gahuwan ka madat espiritu, asta manubù na ágbabuyán, asta manubù na dì ágriyu é lawa. Igdappánnan din ka bállad din, asta inólian tô langun dan. ");
INSERT INTO bgs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tuu marapung tô mga manubù na igtákkás ki Jesus tikud tun ta probinsya ka Galilea, tikud tun ta Dekapolis, Jerusalem, probinsya ka Judea, asta tikud tun ta dipag ka Wayig ka Jordan. ");
INSERT INTO bgs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na, tô igkita i Jesus tô marapung manubù na ilimud, igtikáddág sikandin tun ta pabungan, asta igunsad sikandin. Igpadani tô langun manubù na igtinuruan din, ");
INSERT INTO bgs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","asta igtinurù si Jesus kandan, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kadayawan tô mga manubù na isóddóran dan na atin ka dì dan tabangan ka Manama, dì dan makému ka madigár. Kadayawan dan su mangulu tô Manama kandan. ");
INSERT INTO bgs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Kadayawan tô mga manubù na ágkaranu, su órórán dan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Kadayawan tô mga manubù na ágpabbabà-babà, su makatigatun dan katô banuwa na igtandô ka Manama kandan. ");
INSERT INTO bgs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Kadayawan tô mga manubù na malyag lumumu katô nángngà tun ta saruwan ka Manama, su tabangan dan ka Manama ébô matuman tô kakalyag dan. ");
INSERT INTO bgs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Kadayawan tô mga manubù na médu-édu, su duwán kédu ka Manama kandan. ");
INSERT INTO bgs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Kadayawan tô mga manubù na malinis é pusung, su kumita dan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Kadayawan tô mga manubù na gusay katô ágpasamuké ébô duwán kasunayan, su imun dan ka Manama na mga gabatà din. ");
INSERT INTO bgs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Kadayawan tô mga manubù na girrayatan tingód katô katuman dan katô kakalyag ka Manama, su sakupán dan tun ta pagpangulu katô Manama. ");
INSERT INTO bgs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kadayawan kó ka ágbuyas-buyasán kó, girrayatan kó asta góróm-órómán kó tingód katô katákkás yu kanak. ");
INSERT INTO bgs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Atin ka tô gó é dumunggù ákniyu, kailangan tuu kó kadayawan, su dakál tô pulusán na matanggap yu tun ta langit. Sampát yu na igirrayatan pagsik tô mga propeta ka Manama sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sikiyu na ágtákkás kanak, iring kó na asin nit banuwa. Asal atin ka mandà tô nanam katô asin, dì dán lumónód tô nanam. Ándà dán palang ágpulusán. Purisu antugán dán asta gittan-gittan ka mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Iring kó na sulù na ágbággé ka kappawaan tun ta langun manubù nit banuwa. Tô lunsud tun ta bówwó ka pabungan dì ágkallás. ");
INSERT INTO bgs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Atin ka ágrákkáttan é sulù, dì ágtambunan, asal ágsapatán ébô kataddawan tô langun manubù tun dalám ka balé. ");
INSERT INTO bgs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kailangan makéring kó na sulù na ágbággé ka kappawaan, su atin ka kumita tô duma mga manubù katô madigár áglumun yu, durungán dan tô Ámmà yu na Manama tun ta langit.” ");
INSERT INTO bgs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yakó ágpanámdám na igsadunna dini ébô pandaán ku tô mga sugù ka Manama asta tô mga kagi ka mga propeta ka Manama na igsulat sayyan. Asal igsadunna dini ébô tumanán ku ni. ");
INSERT INTO bgs_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Paminág yu ni kagin ku ákniyu. Róggun duwán pa langit asta tanà, ándà palang kórét tun ta mga sugù ka Manama na mandà, su matuman tô langun na igkagi din. ");
INSERT INTO bgs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Purisu atin ka méllé tô manubù ka sábbad sugù ka Manama asta tuminurù kani tun ta duma manubù, tuu mabbabà é kamanubuan din tun ta pagpangulu ka Manama. Asal atin ka mánnal tô manubù ka langun sugù ka Manama asta tuminurù ka duma manubù kani, tuu mabantug sikandin tun ta pagpangulu ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Purisu kumagiya ákniyu, atin ka malyag kó sakupán katô Manama tun ta pagpangulu din, kailangan tuu pa nángngà tô áglumun yu ka tandingán katô áglumun katô mga Pariseo asta mga taratinurù ka sugù.” ");
INSERT INTO bgs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Idinág yu na igsugù ka Manama ukit ki Moises tun ta mga kamónaan yu sayyan, na, ‘Yakó ágmaté, su kailangan supakan tô mimmaté.’ ");
INSERT INTO bgs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Asal kumagiya ákniyu, agad masókó dád tô manubù, kailangan supakan sikandin. Atin ka kumagi tô manubù ka madat tun ta kataladi din, kailangan piddán sikandin tun ta mallayat gusayanan. Atin ka kumagi tô manubù, ‘Ágkangulág ka!’ kailangan piddán sikandin tun ta ágsupakanan ka apuy. ");
INSERT INTO bgs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Purisu atin ka madun kó tun ta templo ébô mággé ka gasa yu tun ta Manama, asta kasampáttan yu na duwán manubù na isókó ákniyu tingód katô iglumu yu, ");
INSERT INTO bgs_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tanani yu pa tô gasa yu, asta sadun kó tun kandin ébô pólié kó. Atin ka pólié kód, mému kód lumónód tun ta templo asta mággé kód katô gasa yu tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Atin ka duwán manubù na dumimanda ákniyu, sékót kó pólié ka dì kó pa dumunggù tun ta ágruudanan, agó piddán kó tun ta huwes, bággén kó tun ta bállad ka polis, asta prison kó. ");
INSERT INTO bgs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Paminág yu ni kagin ku ákniyu. Atin ka prison kó, dì kó makaluwà sippang ka bayadan yu tô kadakállan katô kadattan na ilumu yu.” ");
INSERT INTO bgs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Idinág yu na igsugù tô Manama ukit ki Moises sayyan, na, ‘Yakó áglibug.’ ");
INSERT INTO bgs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Asal kumagiya ákniyu na agad makasállág dád tô mama katô bayi, asta madat tô kakalyag din, ikalibug dán sikandin tun ta pusung din. ");
INSERT INTO bgs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Purisu atin ka tô ágbaluy mata nu tô gunayan na makasalà ka, lássù nu asta antug nu, su tuu pa madigár ka mandà tô sábbad bahin katô lawa nu ka tandingán ka antugán tô tibuk lawa nu tun ta ágsupakanan. ");
INSERT INTO bgs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Atin ka tô bállad nu dadan ta kawanan tô gunayan na makasalà ka, tampád nu asta antug nu, su tuu pa madigár ka mandà tô sábbad bahin katô lawa nu ka tandingán ka makasadun tô tibuk lawa nu tun ta ágsupakanan.” ");
INSERT INTO bgs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Igsugù pagsik tô Manama ukit ki Moises sayyan na atin ka sumugban tô mama katô sawa din, kailangan duwán papeles na bággén din tingód katô pasugbané dan. ");
INSERT INTO bgs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Asal kumagiya ákniyu, atin ka sumugban tô mama katô sawa din na ándà libug, madat tô kasugban din, su ukit kandin makalibug tô sawa din ka kumalyag puman. Makalibug tô mama na kumalyag katô bayi na igsugbanan katô duma din.” ");
INSERT INTO bgs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Idinág yu pagsik na igsugù tô Manama ukit ki Moises tun ta mga kamónaan yu sayyan na dì mému ka dì tumanán tô tandô. Kailangan tumanán tô tandô na igsarig tun ta ngadan katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Asal kumagiya ákniyu, atin ka tumandô kó, yakó ágtandô ukit ka agad ándin. Yakó ágtandô ukit ka langit, su gunsadanan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yakó ágtandô ukit ka tanà, su iring na ágtindággan ka Manama. Yakó ágtandô ukit ka lunsud ka Jerusalem, su tô gó é góddóan katô Harì na mallayat ka langun. ");
INSERT INTO bgs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yakó ágkagi, na ‘agad matéya pa,’ su agad tô sábbad dád silag ka ulu yu, dì kó makapapputì ó makapamétám. ");
INSERT INTO bgs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Atin ka ágkasarigan tô kagi yu, nángngà ka kumagi kó dád, ‘Óó,’ ó ‘Dì.’ Atin ka pasarig kó pa katô tandô yu, tikud dán tun ki Maibuyan.” ");
INSERT INTO bgs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Idinág yu na igsugù tô Manama ukit ki Moises sayyan, na tô dumadat ka mata katô unawa din manubù, dadattan tô kandin mata. Asta tô dumadat ka ngipán katô unawa din manubù, dadattan tô kandin ngipán. ");
INSERT INTO bgs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Asal kumagiya ákniyu, atin ka duwán manubù na lumumu ka madat ákniyu, yakó áglumu ka madat kandin. Atin ka sampalán kó katô duma manubù tun ta pusángngi yu na dadan ta kawanan, pasampal yu pagsik tô pusángngi yu na dadan ta ibang. ");
INSERT INTO bgs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Atin ka duwán mid ákniyu tun ta huwes asta mangé ka kamisita yu, agad tô umpak yu bággé yu kandin. ");
INSERT INTO bgs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Atin ka duwán sundalo na ágpirit ákniyu na mid katô piniddan din tun ta kadiyù na sábbad kilometro, pid kó sippang ka duwa kilometro. ");
INSERT INTO bgs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bággéyi yu tô mamuyù, asta pabállás yu tô mállás.” ");
INSERT INTO bgs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Idinág yu na duwán ágtinuruán sayyan na kailangan ginawaan yu tô mga rarak yu, asta karingasayi yu tô mga usig yu. ");
INSERT INTO bgs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Asal kumagiya ákniyu, ginawayi yu tô mga usig yu, asta dasalan yu tô mga manubù na girrayat ákniyu. ");
INSERT INTO bgs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Atin ka ni gó tô áglumun yu, mému kó na bánnal na mga gabatà katô Ámmà yu na Manama tun ta langit, su ánnà dád tô mga madigár manubù tô ágpaséllaan din ka álló, asal tô mga madat pagsik. Ánnà dád tô mga ágbánnal katô mga sugù ka Manama tô igbággayan din ka udan, asal tô mga dì ágbánnal pagsik. ");
INSERT INTO bgs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yakó ágpanámdám na duwán pulusán yu tingód katô dakál ginawa yu tun ta mga ágginawa ákniyu, su agad tô mga taralimud ka buwis na ágbuyasán yu, ágginawa dan katô mga manubù na ágginawa kandan. ");
INSERT INTO bgs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Atin ka mga kataladi yu dád tô tagadán yu, ándà ilumu yu na madigár ka tandingán katô áglumun ka ássa mga manubù, su agad tô langun manubù na dì ágbánnal ka Manama, ágtabang dan ka mga kataladi dan. ");
INSERT INTO bgs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Purisu kailangan tuu nángngà tô áglumun yu iring katô tuu nángngà na áglumun katô Ámmà yu na Manama tun ta langit.” ");
INSERT INTO bgs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Banté kó! Yakó ágpasállág-sállág katô katabang yu ka mga unawa yu, su atin ka ágpasállág-sállág kó, ándà gó pulusán na tanggapán yu tikud tun ta Ámmà yu na Manama na góddô tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Purisu atin ka mággé kó tun ta ágkayu-ayuan, yakó gulit tun ta mga manubù ébô durungán kó ikandan, su tô gó é áglumun katô mga manubù na kéman dan ka nángngà tô áglumun dan tun ta saruwan ka Manama. Tô gó é áglumun dan tun ta mga simbaan ka Judio asta tun ta dalan ébô kitanán asta durungán dan ka duma mga manubù. Paminág yu ni kagin ku ákniyu. Duwán dán igpulus dan, asal ánnà tikud tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Atin ka mággé kó katô mga ágkayu-ayuan, yakó ágpasóddór agad tun ta rarak yu ");
INSERT INTO bgs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ébô ándà makasóddór tingód katô kabággé yu, asta duwán pulusán yu tikud tun ta Ámmà yu na Manama na ágkita katô áglumun yu na inallás.” ");
INSERT INTO bgs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Atin ka dumasal kó tun ta Manama, yakó giring katô mga manubù na kéman dan ka nángngà tô áglumun dan tun ta saruwan ka Manama, su ágkadigárran dan na ágdasal tun ta simbaan asta tun ta dalan ébô kitanán dan ka duma mga manubù. Paminág yu ni kagin ku ákniyu. Duwán dán igpulus dan, asal ánnà tikud tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Asal atin ka ágdasal kó, ahu kó tun ta kuwarto yu, sagpángngi yu tô sállat, asta dasal kó tun ta Ámmà yu na Manama na dì ágkitanán, asta duwán pulusán yu tikud tun ta Ámmà yu na Manama na ágkita katô áglumun yu na inallás. ");
INSERT INTO bgs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Atin ágdasal kó, yakó ágtawang ágkagi-kagi iring katô kadasal ka mga manubù na ándà sóddór ka bánnal Manama, su kéman dan ka maminág tô Manama kandan ka marapung tô ágkagin dan. ");
INSERT INTO bgs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yakó giring kandan, su isóddóran dán katô Ámmà yu na Manama ka ándin tô ágkailanganán yu agad ándà kó pa pamuyù tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iring kani é kadasal yu. ‘Ámmà tun datas ta langit, mólà pa ka pangadapán ka katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mólà pa ka mangulu ka tun ta langun manubù. Mólà pa ka matuman tô kakalyag nu kannun ta banuwa iring katô katuman ka kakalyag nu tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bággéyi ké ka ágkannán dé álló-álló. ");
INSERT INTO bgs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasinsiyayi ké na ikasalà áknikó, su ágpasinsiyaan dé tô langun manubù na ikasalà áknami. ");
INSERT INTO bgs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yaka ágpókit áknami tun ta pagtintal, asal papadiyù ké tikud tun ki Maibuyan.’ ");
INSERT INTO bgs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Atin ka ágpasinsiyaan yu tô duma manubù na ikasalà ákniyu, pasinsiyaan kó pagsik katô Ámmà yu na Manama. ");
INSERT INTO bgs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Atin ka dì yu pasinsiyaan tô duma manubù na ikasalà ákniyu, dì kó pagsik pasinsiyaan katô Ámmà yu na Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Atin ka ágpuwasa kó, yakó ágpasóddór ukit ka bónnóng yu iring katô áglumun ka mga manubù na kéman dan ka nángngà tô áglumun dan tun ta saruwan ka Manama. Gimun dan na madat tô bónnóng dan ébô kasóddóran na dì dan ágkan. Paminág yu ni kagin ku ákniyu. Duwán dán igpulus dan, asal ánnà tikud tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Asal atin ka ágpuwasa kó, suwat kó asta dappug kó ");
INSERT INTO bgs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ébô ándà makasóddór na dì kó ágkan. Asal makasóddór dád tô Ámmà yu na Manama na dì ágkitanán, asta duwán pulusán yu tikud tun ta Ámmà yu na ágkita katô áglumun yu na inallás.” ");
INSERT INTO bgs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yakó áglimud ka kaduwánnan dini ta banuwa, su ágdadattan ka mga ané, asta ágkararingán, asta ágtakón. ");
INSERT INTO bgs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Asal limud kó baling ka kaduwánnan tun ta langit, su ándà ané asta kararing na dumadat diyan, asta ándà takón na makahu. ");
INSERT INTO bgs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Agad ánda é limudan yu katô kaduwánnan yu, dutun pagsik tô pusung yu.” ");
INSERT INTO bgs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Sulù ka lawa tô mata. Purisu atin ka mappawà tô kasállág nu, kappawaan tô tibuk lawa nu. ");
INSERT INTO bgs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Asal ka mangittáng tô kasállág nu, kangittángngan tô tibuk lawa nu. Purisu atin ka mangittáng tô sulù tun ta lawa nu, tuu mangittáng tô kóddô nu!” ");
INSERT INTO bgs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ándà palang manubù na lumumu tun ta duwa amo. Atin ka dakál tô ginawa din tun ta sábbad, karingasaan din tô sábbad. Sábbad dád tô amo din na mému tákkássan din, asta tô sábbad dì din nunugan. Dì mému pagdángnganán tô kapamasak katô kaduwánnan asta katuman yu katô lumu ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Purisu kagiyan ku sikiyu, yakó ágkatanaan tingód katô kantayan yu ka ándin tô kannán yu asta tô inámmán yu. Yakó ágkatanaan tingód katô lawa yu ka ándin tô umpakán yu. Su tuu pa ágkailanganán tô kantayan ta ka tandingán katô ágkannán, asta tuu pa ágkailanganán tô lawa ta ka tandingán katô gumpakán. ");
INSERT INTO bgs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sállág yu tô mga manuk ta kayun. Dì dan ágpamula. Dì dan ágkáttu. Dì dan ágtagù ka ágkakan dan tun ta ágtaguanan. Asal inalayun dan ágbággayan katô Ámmà yu na Manama ka ágkakan. Su ágdóppónan ka Manama tô langun manuk ta kayun agad iring na ándà lagà dan, yakó ágkatanaan, su tô lagà yu tuu pa dakál ka tandingán katô langun manuk ta kayun. ");
INSERT INTO bgs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Agad katanaan kó, asal dì kasugpatan tô kantayan yu ukit katô tana yu. ");
INSERT INTO bgs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Yakó ágkatanaan tingód katô gumpakán yu. Panámdám yu tô mga bulak ka kabánnássan na inalayun ágtubù. Dì áglumu, asta dì pagsik gabál. ");
INSERT INTO bgs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Asal kagiyan ku sikiyu, agad madigár ágsállággán tô mga umpak i Harì Solomon sayyan, asal tuu pa madigár ágsállággán tô mga bulak ka kabánnássan. ");
INSERT INTO bgs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Délák tô kasarig yu ka Manama. Igimu din na madigár ágsállággán tô mga bulak ka kabánnássan na dì madugé góbbón. Purisu kasóddóran yu na bággayan kó ka Manama ka gumpakán yu. ");
INSERT INTO bgs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Yakó ágkatanaan tingód katô ágkannán yu, ginámmán yu, asta gumpakán yu. ");
INSERT INTO bgs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tô langun manubù na dì ágbánnal ka Manama, inalayun dan ágpamasakán ni langun. Isóddóran katô Ámmà yu na Manama tô mga ágkailanganán yu. ");
INSERT INTO bgs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Asal una yu pamasaki tô pagpangulu ka Manama asta tuman yu tô kakalyag din, asta bággayan kó pagsik ikandin katô mga ágkailanganán yu. ");
INSERT INTO bgs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Purisu yakó ágkatanaan ka ándin tô dumunggù ákniyu simag. Pabayà yu tô kahirapan yu simag, su nángngà tô kahirapan yu ni álló ni.” ");
INSERT INTO bgs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Yakó ágruud katô duma mga manubù ébô dì kó ruudan ka Manama, ");
INSERT INTO bgs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","su ruudan kó ka Manama na magunawa ka karuud yu katô duma mga manubù. Bággayan kó ka Manama na magunawa katô kabággé yu tun ta mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sékót yu ágkitanán tô pássák tun ta mata katô kataladi yu, asal ándà yu kasóddóri na duwán pássák na iring na batang tun ta ákniyu mata. ");
INSERT INTO bgs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Atin ka dì yu kitanán tô pássák na iring na batang tun ta ákniyu mata, dì kó makatabang mangé katô pássák tun ta mata katô kataladi yu. ");
INSERT INTO bgs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Kangé yu pa tô pássák na iring na batang tikud tun ta ákniyu mata, ébô matayyó dán tô kasállág yu na mangé katô pássák tun ta mata katô kataladi yu. ");
INSERT INTO bgs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yakó ágbággé katô tingód ka Manama tun ta mga asu agó kagatán kó. Yakó ágbággé katô perlas na dakál é lagà tun ta mga babuy agó gittan-gittan dan dád.” ");
INSERT INTO bgs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pamuyù kó inalayun tun ta Manama, asta bággayan kó ikandin. Pamasak kó inalayun tun kandin, asta kitanán yu. Tákták kó inalayun tun ta sállat, asta pókéan kó ikandin. ");
INSERT INTO bgs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Makatanggap tô langun manubù na ágpamuyù. Makakita tô langun manubù na ágpamasak. Pókéan tô langun manubù na ágtákták. ");
INSERT INTO bgs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sikiyu na mga ámmà, atin ka mamuyù tô batà yu ka pan, ánnà batu tô bággén yu kandin. ");
INSERT INTO bgs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Atin ka mamuyù tô batà yu ka sáddà, ánnà áppuy tô bággén yu kandin. ");
INSERT INTO bgs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na, sikiyu, agad duwán madat mga áglumun yu, asal inalayun madigár tô mga ágbággén yu tun ta mga gabatà yu. Na, tô Ámmà yu na Manama tun ta langit tuu pa mággé ka madigár tun ta langun manubù na ágpamuyù kandin! ");
INSERT INTO bgs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Agad ándin tô kakalyag yu na lumun katô duma mga manubù ákniyu, tô gó é kailangan lumun yu tun ta duma mga manubù. Atin ka malumu yu ni, tô gó tô katumanan katô langun sugù asta mga kagi katô mga propeta ka Manama na igsulat sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ahu kó tun ta sállat na maliggát, su maluwag tô sállat, asta maluwag tô dalan na pasadun tun ta ágsupakanan, asta marapung tô mga manubù na gukit. ");
INSERT INTO bgs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Asal maliggát tô sállat, asta maliggát tô dalan na pasadun tun ta kantayan na ándà ágtamanán, asta tagsábbadé dád tô mga manubù na gukit.” ");
INSERT INTO bgs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Banté kó ébô dì kó mapid katô mga manubù na mà kagi propeta. Tun ta luwà iring dan na karnero, asal tun dalám iring dan na magani lobo na ágdadat ka mga karnero. ");
INSERT INTO bgs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Atin ka ágkitanán yu tô áglumun ka mga propeta, ágkasóddóran yu ka mà kagi dan propeta. Ándà palang buuy ka paras na uduán tikud tun ta sigbát mayyà. Ándà buuy ka igera na uduán tikud tun ta sigbát talayid. ");
INSERT INTO bgs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tô áglumun ka mga manubù iring na buuy ka kayu. Tô madigár kayu ágbuuy ka madigár. Tô madat kayu ágbuuy ka madat. ");
INSERT INTO bgs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tô madigár kayu dì ágbuuy ka madat. Tô madat kayu dì pagsik ágbuuy ka madigár. ");
INSERT INTO bgs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tô langun ka kayu na ándà madigár buuy, tô gó é ágpilén asta ággóbbón. ");
INSERT INTO bgs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Purisu atin ka ágkitanán yu tô áglumun katô mga propeta, ágkasóddóran yu ka bánnal dan na mga propeta ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ánnà langun manubù na ágkagi na sakán tô Áglangngagán dan tô sakupán tun ta pagpangulu ka Manama, su sakupán dád tô mga manubù na ágtuman ka kakalyag katô Ámmà ku na Manama tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tun ta álló ruudan ku, marapung tô mga manubù na kumagi kanak, ‘Áglangngagán, pasakup ké, su igulit ké katô kagi ka Manama ukit katô ngadan nu, asta igpaluwà dé tô madat mga espiritu tikud tun ta mga manubù ukit katô ngadan nu, asta duwán mga kasalábbuan na iglumu dé ukit katô ngadan nu.’ ");
INSERT INTO bgs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Asal kumagiya kandan, na mà ku, ‘Ándà a kilala ákniyu. Iwà kó na áglumu ka madat.’” ");
INSERT INTO bgs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tô manubù na ágpaminág asta ágtuman kani mga ágkagin ku, iring sikandin katô mapandé manubù na igimu ka balé, asta igpatindág din tun ta bówwó ka batu. ");
INSERT INTO bgs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tô igudan, igbahà tô wayig asta idungguan tô balé din. Igdunggù tô mabákkár karamag, asal ándà kapilé tô balé din, su igpatindág tun ta bówwó ka batu. ");
INSERT INTO bgs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Na, tô manubù na ágpaminág kani mga ágtinuruán ku asal dì ágtuman, iring sikandin katô ágkatuluan manubù na igimu ka balé din tun ta bówwó ka baklayan. ");
INSERT INTO bgs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tô igudan, igbahà tô wayig. Igdunggù tô mabákkár karamag. Ipilé tô balé din asta idattan langun.” ");
INSERT INTO bgs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pángnga igtinurù si Jesus, isalábbuan tô langun manubù na igpaminág katô igtinurù din, ");
INSERT INTO bgs_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","su duwán katulusan katô katinurù i Jesus ánnà iring katô katinurù ka mga taratinurù ka sugù. ");
INSERT INTO bgs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na, tô igtupang dán si Jesus tikud tun ta pabungan, marapung tô mga manubù na igtákkás kandin. ");
INSERT INTO bgs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Duwán sábbad tétékán na igpadani tun ki Jesus. Iglingkóód sikandin asta igkagi, na mà din, “Áglangngagán, atin ka kakalyag nu, isóddóran ku na makólì ka kani bógók ku.” ");
INSERT INTO bgs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Igdappánnan i Jesus sikandin ka bállad, asta igkagi si Jesus, na mà din, “Malyagga. Kólian kad.” Tigkô dád inólian sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Igkagi si Jesus, na mà din, “Dì mému ka ulitan nu tô agad sadan manubui. Asal sadun ka tun ta pangulu ka templo, asta pakita nu yan lawa nu. Bággé nu tô manuk na góbbón tun ta saruwan ka Manama, su tô gó tô igsugù i Moises ébô makasóddór tô langun manubù na inólian kad.” ");
INSERT INTO bgs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na, tô igdunggù si Jesus tun ta Capernaum, duwán sábbad kapitan ka mga sundalo ka gobyerno ka Roma na igsumar kandin, asta igpamuyù sikandin ka tabang, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sir, ágkabógókan tô sábbad állang ku tun ta balé ku. Dì dán ágriyu é lawa din, asta masig dán maté.” ");
INSERT INTO bgs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Igkagi si Jesus, na mà din, “Madunna, asta dappánnan ku sikandin ka bállad ébô kólian.” ");
INSERT INTO bgs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Asal igkagi tô kapitan, na mà din, “Áglangngagán, atin ka mahu ka tun ta balé ku, kayyaanna su tuu mabbabà é kamanubuan ku ka tandingán áknikó. Asal nángngà ka kumagi ka dád na kólian tô állang ku, su kólian sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sakuppa katô manubù na ágsugù kanak, asta duwán mga sundalo na ágsuguán ku. Atin ka duwán sundalo na suguán ku, numunug sikandin kanak. Atin ka duwán sundalo na pakangén ku, numunug sikandin kanak. Atin ka duwán palumun ku katô állang ku, lumumu sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tô igdinág si Jesus katô kagi din, isalábbuan sikandin. Igkagi si Jesus tun ta mga manubù na igtákkás kandin, na mà din, “Paminág yu ni kagin ku ákniyu. Agad tun ta mga rubbad i Israel, ándà palang manubù na ikitaan ku na igsarig kanak iring katô kasarig kani ánnà Judio. ");
INSERT INTO bgs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Paminág yu ni kagin ku ákniyu. Tun ta álló ka pagpangulu ka Manama, marapung tô mga ánnà Judio manubù na dumunggù tikud tun ta langun banuwa, asta pasakupán dan tun ta dakál kalimudan tun ta pagpangulu ka Manama duma katô mga kamónaan yu na si Abraham, si Isaac, asta si Jacob. ");
INSERT INTO bgs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na, duwán mga Judio na giman ka sakupán dan, asal papiddán dan baling tun ta luwà tun ta kangittángngan ébô supakan. Dutun tuu dan sumággó asta kumurigát tô ngipán dan tingód katô kasakit dan.” ");
INSERT INTO bgs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Igkagi si Jesus katô kapitan, na mà din, “Ulì kad, su ituman dán tô igpamuyù nu ukit katô kasarig nu kanak.” Tô oras tô, tigkô dád inólian tô állang katô kapitan. ");
INSERT INTO bgs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na, igsadun si Jesus tun ta balé i Pedro, asta igkita din tô bayi na ugang i Pedro na igdággà su ágkalinturan. ");
INSERT INTO bgs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Igdappánnan i Jesus sikandin ka bállad, asta tigkô dád inólian. Igánnó sikandin asta igbuwat ka ágkannán ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tô ágsalláp dán tô álló, igpid katô mga manubù tun ki Jesus tô marapung na gahuwan ka madat espiritu, asta igpaluwà din tô mga madat espiritu ukit ka kagi din. Igdappánnan din ka bállad tô langun manubù na duwán ássa-ássa bógók, asta inólian dan. ");
INSERT INTO bgs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ukit katô iglumu i Jesus kandan, ituman tô igkagi katô propeta ka Manama sayyan na si Isaias, na mà din, “Sikandin tô mangé katô langun kalómétan ta, asta makólì katô langun bógók ta.” ");
INSERT INTO bgs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na, tô igkita si Jesus katô marapung manubù na iglibut kandin, igkagi sikandin katô mga disipulu din na tumalipag dan tun dipag ka ranó. ");
INSERT INTO bgs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na, duwán taratinurù ka sugù na igpadani tun ki Jesus. Igkagi sikandin, na mà din, “Sir, mákkássa áknikó agad mánda ka madun.” ");
INSERT INTO bgs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Asal igkagi si Jesus, na mà din, “Tô mga mannanap ka kabánnássan, duwán pa góddóan dan, asta tô mga manuk ta kayun, duwán pa gapunanan dan. Asal sakán na Igpamanubù, ándà palang góddóan ku na ágkadággaan.” ");
INSERT INTO bgs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Duwán ássa disipulu na igkagi, na mà din, “Áglangngagán, mákkássa áknikó, asal pólì a pa ébô lábbángngán ku tô ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Asal igkagi si Jesus, na mà din, “Tákkás kad kanak, su tô mga manubù na ándà kantayan, tô gó é lumábbáng katô mga kadumaan dan na inaté.” ");
INSERT INTO bgs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na, tô igsaké si Jesus tun ta barangé, igsaké pagsik tô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ándà kadugé, igdunggù tô mabákkár karamag. Tô barangé idalámman ka dakál wayig. Asal igtudug si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Purisu igpadani tô mga disipulu ki Jesus, asta igánnó dan sikandin, na mà dan, “Áglangngagán, malánnád kid.” ");
INSERT INTO bgs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Igkagi si Jesus, na mà din, “Manan ka ágkamáddangan kó? Délák é kasarig yu kanak!” Na, igánnó si Jesus, asta igpasódô din tô karamag asta tô mga balud, asta tigkô dád igtónnók tô mga balud katô ranó. ");
INSERT INTO bgs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Isalábbuan dan, asta igpatóngkóé sikandan, na mà dan, “Matulus gó kannê sikandin, su agad tô karamag asta tô mga balud ágbánnal kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na, igdunggù dan tun dipag ka ranó madani tun ta Gadara. Duwán duwa manubù na igahuwan ka madat espiritu, asta igsumar dan ki Jesus tikud tun ta mga áglábbángnganan. Tuu dan magani. Purisu ándà manubù na pakókit dutun. ");
INSERT INTO bgs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Igullaó dan, na mà dan, “Batà ka Manama, yaka ágsamuk áknami, su ándà pa dunggù tô álló ka supak nu áknami.” ");
INSERT INTO bgs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, marapung tô mga babuy na ágsukat tun tóna na dì madiyù. ");
INSERT INTO bgs_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Igpédu-édu tô madat mga espiritu, na mà dan, “Atin ka péwaán ké ikuna, pahu ké tun ta mga babuy.” ");
INSERT INTO bgs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Igkagi si Jesus, na mà din, “Tun kód.” Purisu igluwà tô madat mga espiritu tikud tun ta duwa manubù, asta igahu dan tun ta mga babuy. Igpalaguy tô langun babuy pasadun tun ta karaban tun ta ligad ka ranó, igtuppas dan, asta ilánnád tô langun. ");
INSERT INTO bgs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Igpalaguy tô mga taradóppón ka babuy, asta igsadun dan tun ta lunsud. Igulit dan tô langun na igkita dan asta tô ilumu tun ta duwa manubù na igahuwan katô madat mga espiritu. ");
INSERT INTO bgs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Purisu igsadun tô langun taga Gadara tun ki Jesus. Tô igkita dan dán kandin, igpédu-édu dan na miwà si Jesus tikud tun ta banuwa dan. ");
INSERT INTO bgs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Na, igsaké si Jesus katô barangé, asta igulì tun ta lunsud na igtikudan din. ");
INSERT INTO bgs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ándà kadugé, igdunggù tô mga manubù na igié ka kadumaan dan na dì ágriyu é lawa. Tô igkita si Jesus katô kasarig dan kandin, igkagi sikandin tun ta manubù na dì ágriyu é lawa, na mà din, “Rarak, pasarig nu tô pusung nu, su igpasinsiyaan dán tô mga salà nu.” ");
INSERT INTO bgs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na, duwán mga taratinurù ka sugù na igpanámdám, “Ánnà nángngà tô igkagi kani manubù ni su igpagunawa sikandin katô Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Asal isóddóran i Jesus tô panámdám dan, asta igkagi sikandin, na mà din, “Yakó ágpanámdám ka madat. ");
INSERT INTO bgs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Atin ka matággas tô katuman ka kagi, na, ‘Igpasinsiyaan dán tô mga salà nu,’ matággas pagsik tô katuman ka kagi, na, ‘Tindág ka asta panó ka.’ ");
INSERT INTO bgs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na, sakán tô Igpamanubù, asta pakitanán kud ákniyu na makémuwa makapasinsiya katô masalà-salà mga manubù nit banuwa.” Purisu igkagi si Jesus tun ta manubù na dì ágriyu é lawa, na mà din, “Tindág ka. Pid nu yan ágdággaan nu, asta ulì kad.” ");
INSERT INTO bgs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Purisu igtindág sikandin asta igulì. ");
INSERT INTO bgs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tô igkita tô langun manubù, imáddangan dan, asta igdurung dan tô Manama tingód katô katulusan na igbággé din tun ta mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na, tô igpanó si Jesus tikud dutun, igkita din tô sábbad taralimud ka buwis na ágngadanan ki Mateo na igunsad tun ta opisina din. Igkagi si Jesus tun kandin, na mà din, “Tákkás ka kanak.” Purisu igtindág si Mateo, asta igtákkás ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na, róggun igkan si Jesus tun ta balé i Mateo, igdunggù tô marapung mga taralimud ka buwis asta tô duma mga masalà-salà. Igunsad dan duma ki Jesus asta tô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tô igkita tô mga Pariseo ka sadan tô mga igduma ki Jesus, igkagi dan tun ta mga disipulu din, na mà dan, “Manan ka igkan tô taratinurù yu duma katô mga taralimud ka buwis asta duma mga manubù na masalà-salà?” ");
INSERT INTO bgs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tô igdinág si Jesus katô igkagi dan, igkagi sikandin, na mà din, “Tô manubù na ándà bógók, dì sikandin kailangan bawian ka doktor. Asal tô manubù na ágkabógókan, tô dád gó tô kailangan bawian ka doktor. ");
INSERT INTO bgs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kailangan panámdámmán yu ka ándin tô kóbadan kani kagi ka Manama, “‘Ánnà kabággé yu tô kakalyag ku, asal kakalyag ku na pédu-éduwé kó.’ Igsadunna dini ánnà ébô pamasakán ku tô mga manubù na ágbánnal katô mga sugù ka Manama, asal pamasakán ku tô mga masalà-salà.” ");
INSERT INTO bgs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na, igsadun tô mga disipulu i Juan na Tarabunyag tun ki Jesus, asta igkagi sikandan, na mà dan, “Inalayun ké ágpuwasa iring katô áglumun katô mga Pariseo. Manan ka dì ágpuwasa tô áknikó mga disipulu?” ");
INSERT INTO bgs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Igtaba si Jesus, na mà din, “Atin ka duwán kalimudan ka kasal, tô mga kadumaan katô mama na ágkasalán, dì dan ágkaranu róggun ka dutun pa tô mama na ágkasalán. Asal duwán álló na dumunggù na kangén tikud tun kandan tô mama na ágkasalán, asta tô gó é álló na muwasa dan.” ");
INSERT INTO bgs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Dì mému ka mantu óggét na ándà pa labayi tô pagtapóng katô tapé umpak, su kumáskás tô pagtapóng, asta dumakál pa tô bissé katô umpak. ");
INSERT INTO bgs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Atin ka dalámmán tô bino na mantu igimu tun ta ágtaguanan na igimu tikud tun ta kindal ka kambing, dì mému dalámman tô tapé dán iglanit, su atin ka murà tô bino, máttu tô ágtaguanan na tapé dán iglanit, kólaan tô bino, asta kadattan tô ágtaguanan. Asal kailangan dalámmán tô bino na mantu igimu tun ta ágtaguanan na mantu iglanit ébô dì kadattan.” ");
INSERT INTO bgs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na, róggun igtinurù si Jesus, duwán sábbad pangulu ka simbaan ka Judio na igdunggù. Iglingkóód sikandin tun ki Jesus, asta igkagi sikandin, na mà din, “Mantu pa minaté tô batà ku bayi. Sékót ka, asta dappánni nu ka bállad sikandin ébô manté puman.” ");
INSERT INTO bgs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Purisu igtindág si Jesus, asta igtákkás sikandin asta tô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na, duwán sábbad bayi na gagasan ka dipanug dalám ka sapulù duwa (12) dán ámmé. Igpadani sikandin tun ta bókkóg i Jesus, asta igawidan din dád tô ugpu katô umpak i Jesus, ");
INSERT INTO bgs_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","su taganà igpanámdám sikandin na kólian sikandin ka awidan din dád tô umpak i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Igsérê si Jesus, asta igkita din tô bayi. Igkagiyan i Jesus tô bayi, na mà din, “Pasarig nu tô pusung nu. Inólian kad ukit ka kasarig nu kanak.” Tigkô dád, inólian sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na, tô igdunggù si Jesus tun ta balé katô ágpangulun, igkita din tô mga manubù na gidup ka plawta tingód katô ranu dan, asta marapung tô ilimud mga manubù na ágsággó. ");
INSERT INTO bgs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Igkagi si Jesus, na mà din, “Luwà kó, su ándà kamaté tô batà. Igtudug dád sikandin.” Na, igngisiyan dan si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Asal igpaluwà i Jesus tô ilimud mga manubù asta igahu sikandin tun ta kuwarto. Igawidan din tô bállad katô batà, asta igánnó tô batà. ");
INSERT INTO bgs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ibantug tô kanté i Jesus katô batà tun ta kaluwagan katô probinsya. ");
INSERT INTO bgs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na, tô igpanó si Jesus, duwán duwa bólóg manubù na igtalundug kandin. Igullaó sikandan, na mà dan, “Rubbad i David, kéduwi ké.” ");
INSERT INTO bgs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tô igdunggù si Jesus tun ta balé, igpadani tô duwa bólóg tun kandin. Igkagi si Jesus, na mà din, “Ágbánnal kó na makémuwa makólì ákniyu?” Igtaba sikandan, na mà dan, “Óó, Áglangngagán. Ágbánnal ké.” ");
INSERT INTO bgs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na, igdappánnan i Jesus ka bállad din tô mata dan, asta igkagi sikandin, na mà din, “Kólian kó tingód katô kapamaké yu kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tigkô dan dád ikakita. Maggát igsapad si Jesus kandan, na mà din, “Kailangan ándà palang manubù na ulitan yu.” ");
INSERT INTO bgs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Asal igpanó dan asta igulit dan tun ta duma mga manubù. Purisu ibantug si Jesus tun ta kaluwagan katô probinsya. ");
INSERT INTO bgs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na, róggun igpanó tô duwa bólóg manubù na inólian, duwán sábbad ómmó manubù na igpid tun ki Jesus. Inómmó sikandin su igahuwan ka madat espiritu. ");
INSERT INTO bgs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Igpaluwà i Jesus tô madat espiritu, asta ikakagi dán tô manubù. Isalábbuan tô ilimud mga manubù, asta igkagi sikandan, na mà dan, “Ándà palang igkita ta na iring kani dini áknita na mga rubbad i Israel.” ");
INSERT INTO bgs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Asal igkagi tô mga Pariseo, na mà dan, “Ágpaluwà sikandin ka madat mga espiritu ukit katô pangulu ka mga madat espiritu.” ");
INSERT INTO bgs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na, igsadun si Jesus tun ta langun lunsud. Igtinurù sikandin tun ta mga simbaan ka Judio. Igulit-ulit din tô Madigár Gulitán tingód katô pagpangulu ka Manama. Igdappánnan din ka bállad tô langun manubù na ágkabógókan asta duwán kalómétan ébô kólian. ");
INSERT INTO bgs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tô igkita si Jesus katô marapung manubù na ilimud tun kandin, inéduwan sikandin kandan, su tuu dan ágkaranu asta makédu-édu. Iring dan katô itadin na mga karnero na ándà taradóppón. ");
INSERT INTO bgs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Purisu igkagi si Jesus tun ta mga disipulu din, na mà din, “Dakál tô ágkáttun, asal tagsábbadé dád tô tarakáttu. ");
INSERT INTO bgs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Purisu dasal kó tun ta Áglangngagán na tigatun ka kinamát ébô papid sikandin ka duma mga tarakáttu.” ");
INSERT INTO bgs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na, igsalin i Jesus tô sapulù duwa (12) disipulu din, asta igbággé din kandan tô katulusan ébô makapaluwà dan katô madat mga espiritu na igahu tun ta manubù, asta ébô makólì dan katô langun manubù na ágkabógókan asta duwán kalómétan. ");
INSERT INTO bgs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ni gó tô mga ngadan katô sapulù duwa (12) apostoles, si Simon na ágngadanan i Jesus ki Pedro, tô kataladi i Pedro na si Andres, tô duwa gabatà i Sebedeo na si Santiago asta si Juan, ");
INSERT INTO bgs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe, si Bartolome, si Tomas, si Mateo na taralimud ka buwis, si Santiago na batà i Alfeo, si Tadeo, ");
INSERT INTO bgs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon na magani, asta si Judas Iscariote na igpammát ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ni gó tô sapulù duwa (12) apostoles na igpapanó i Jesus, su igkagi sikandin kandan, na mà din, “Yakó ágsadun tun ta mga lunsud ka mga manubù na ánnà Judio, asta yakó ágsadun tun ta mga lunsud tun ta probinsya ka Samaria. ");
INSERT INTO bgs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Asal sadun kó dád tun ta mga rubbad i Israel na iring na mga karnero na itadin. ");
INSERT INTO bgs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Agad ánda tô sadunan yu, ulit-ulit kó na masig dán mangulu tô Manama. ");
INSERT INTO bgs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dappánni yu ka bállad tô mga ágkabógókan ébô kólian. Anté yu tô mga inaté. Dappánni yu ka bállad tô mga tétékán ébô kólian. Paluwà yu tô madat mga espiritu na igahu tun ta mga manubù. Ándà yu bayadi tô katulusan na igbággé ku ákniyu. Purisu yakó yu ágpabayadi tô mga manubù na tabangan yu. ");
INSERT INTO bgs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yakó ágpid ka salapì. ");
INSERT INTO bgs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yakó ágpid ka kabir, umpak na gilisan, sandalyas ó tukád, su tô manubù na áglumu kailangan bággayan katô ágkailanganán din. ");
INSERT INTO bgs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Atin ka ágdunggù kó tun ta lunsud ó duma banuwa, insà kó ka sadan tô madigár manubù na óddóan yu. Óddô kó tun ta balé din sippang tun ta álló ka kapanó yu tun ta duma mga lunsud. ");
INSERT INTO bgs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Atin ka ágdunggù kó tun ta balé, una yu kagiyi tun ta mga tigbalé, na mà yu, ‘Mólà pa ka duwán kasunayan yu.’ ");
INSERT INTO bgs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Atin ka tanggapán kó katô mga tigbalé, bággayan dan ka Manama ka kasunayan. Asal atin ka dì kó tanggapán katô mga tigbalé, pamuyù yu tun ta Manama na angén din tô kasunayan na bággén yu pád tun kandan. ");
INSERT INTO bgs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Atin ka dì kó tanggapán katô mga manubù, asta dì dan paminággán tô ágtinuruán yu, ka panó kó tikud tun ta balé dan asta lunsud dan, padpad yu tô barukbuk tikud tun ta paa yu ébô kasóddóran dan na duwán sókó ka Manama kandan. ");
INSERT INTO bgs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Paminág yu ni kagin ku ákniyu. Tun ta álló na rumuud tô Manama, agad supakan din tô mga taga Sodoma asta tô mga taga Gomora tingód ka mga salà dan, asal tuu pa madat tô supak din katô mga manubù tun ta lunsud na dì tumanggap ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Na, tun ta pasadunan ku ákniyu, banté kó katô madat mga manubù, su iring kó na mga karnero na ágbanganan katô mannanap ka kabánnássan na ágngadanan lobo. Purisu kailangan tuu kó mapandé, asta kailangan ándà palang madat lumun yu. ");
INSERT INTO bgs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Banté kó katô madat mga manubù na mid ákniyu tun ta mga huwes, asta palagpássán kó ikandan tun ta mga simbaan ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tingód katô kapasakup yu kanak, piddán kó tun ta tubang katô mga gobernador asta mga harì ébô mulit kó tingód kanak tun kandan asta tun ta langun manubù na ánnà Judio. ");
INSERT INTO bgs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Atin ka piddán kó tun ta mga manubù na rumuud ákniyu, yakó ágkatanaan tingód katô taba asta kagin yu kandan, su tô álló tô, bággayan kó katô Ugis Espiritu ka kakatigan ébô makataba kó kandan. ");
INSERT INTO bgs_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ánnà tikud tun ákniyu tô kagin yu, su tô Ugis Espiritu na papiddán ka Manama na Ámmà yu tô kumagi ukit ákniyu. ");
INSERT INTO bgs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Duwán mga manubù na pammát katô mga kataladi dan ébô matayan. Duwán mga ámmà na pamaté katô mga gabatà dan. Duwán mga gabatà na musig katô ámmà asta innà dan, asta pamatayan dan. ");
INSERT INTO bgs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Karingasaan kó katô karapungan ka mga manubù tingód katô kapasakup yu kanak. Asal matábbus tô manubù na makatiis katô langun kahirapan. ");
INSERT INTO bgs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Atin ka girrayatan kó tun ta sábbad lunsud, palaguy kó asta sadun kó tun ta ássa lunsud. Paminág yu ni kagin ku ákniyu. Tô dì pa mapángnga tô katinurù yu tun ta langun lunsud tun ta Israel, dumunggù a na Igpamanubù. ");
INSERT INTO bgs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ándà estudyante na mallayat pa katô kandin taratinurù. Ándà pagsik állang na mallayat pa katô kandin amo. ");
INSERT INTO bgs_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Purisu nángngà ka makéring tô estudyante katô kandin taratinurù, asta nángngà ka makéring tô állang katô amo din. Atin ka igngadanan katô mga manubù tô Áglangngagán yu ki Belsebul, tuu pa madat tô ngadanán dan ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Purisu yakó ágkamáddangan katô mga manubù, su ándà palang gállássán áknganni na dì pakitanán tun ta tapuri álló, asta ándà ágbulunán áknganni na dì pasóddórán tun ta tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Agad ándin tô igkagi ku ákniyu ka dukilám, tô gó é kailangan pasóddórán yu ka álló. Agad ándin tô igtinurù ku ákniyu na sikiyu dád, tô gó é kailangan ulit-ulitán yu tun ta duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yakó ágkamáddangan katô mga manubù na makamaté katô lawa yu, su dì dan kamatayan tô gimukud yu. Asal kamáddangi yu baling tô Manama, su sikandin tô mému ágpasadun katô gimukud asta lawa ka manubù tun ta ágsupakanan. ");
INSERT INTO bgs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Agad délák é lagà katô duwa manuk ta kayun na ágbállin yu, asal ándà palang manuk ta kayun na madabù tun ta tanà ka ánnà kakalyag katô Ámmà yu na Manama. ");
INSERT INTO bgs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Agad tô silag katô ulu yu inéyap dán ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Purisu yakó ágkamáddangan, su tô lagà yu tuu pa dakál ka tandingán katô marapung mga manuk ta kayun.” ");
INSERT INTO bgs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tô manubù na kumagi tun ta duma mga manubù na igpasakup sikandin kanak, kumagiya pagsik tun ta saruwan katô Ámmà ku tun datas ta langit na sikandin tô sakup ku. ");
INSERT INTO bgs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Asal tô manubù na mulun kanak tun ta duma mga manubù, bulunán ku pagsik sikandin tun ta saruwan katô Ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yakó ágpanámdám na igsadunna dini ta banuwa ébô duwán kasunayan ka manubù, asal ágpósigé tô mga manubù tingód kanak. ");
INSERT INTO bgs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tingód ka kasadun ku dini, pósigé tô mga gabatà gamama katô mga ámmà dan, pósigé tô mga gabatà gabayi katô mga innà dan, asta pósigé tô mga ikóddô katô mga ugang dan. ");
INSERT INTO bgs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tô mga usig ka manubù tikudù tun ta kandin pamilya. ");
INSERT INTO bgs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Atin ka dakál tô ginawa ka manubù kanak asal tuu pa dakál tô ginawa din tun ta ámmà asta innà din, dì mému pasakup kanak. Atin ka dakál tô ginawa katô manubù kanak asal tuu pa dakál tô ginawa din tun ta mga gabatà din, dì mému pasakup kanak. ");
INSERT INTO bgs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tô manubù na máddang matayan tingód katô kapasakup din kanak, dì ku sakupán. ");
INSERT INTO bgs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tô manubù na áglággád katô kantayan din, kandaan sikandin ka kantayan na ándà ágtamanán. Asal tô manubù na mákkás kanak agad matayan, matanggap din tô kantayan na ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tô manubù na ágtanggap ákniyu, ukit kani ágtanggapánna ikandin. Tô manubù na ágtanggap kanak, ágtanggapán din tô Ámmà ku na igpapid kanak. ");
INSERT INTO bgs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tô manubù na ágtanggap ka propeta ka Manama tingód katô kólit din ka kagi ka Manama, duwán pulusán na bággén ka Manama kandin na magunawa katô pulusán na bággén din tun ta propeta. Tô manubù na ágtanggap ka unawa din na ágbánnal katô mga sugù ka Manama, duwán pulusán na bággén ka Manama kandin na magunawa katô pulusán na bággén din tun ta manubù na ágbánnal katô mga sugù ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Paminág yu ni kagi ku ákniyu. Atin ka ágkatákkangan tô ágpabbabà manubù na ágpasakup kanak, asta duwán manubù na mággé ka wayig kandin tingód katô kapasakup din kanak, duwán pulusán na bággén ka Manama kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tô igtinurù dán si Jesus katô sapulù duwa (12) disipulu din, igsadun sikandin tun ta mga lunsud na madani ébô mulit-ulit katô mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, róggun igpriso si Juan na Tarabunyag, igulitan sikandin tingód katô iglumu katô Mesiyas. Purisu igpasadun i Juan tô mga disipulu din tun ki Jesus ébô minsà, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Sikuna tô bánnal igpapid ka Manama, ó duwán pa ássa na gangatan dé?” ");
INSERT INTO bgs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Igtaba si Jesus tun ta mga disipulu i Juan, na mà din, “Ulì kód, asta uliti yu si Juan tingód katô langun na igdinág yu asta igkita yu kanak. ");
INSERT INTO bgs_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Duwán mga bólóg na ikakita dán. Duwán mga kapig na ikapanó dán. Duwán mga tétékán na inólian dán. Duwán mga bingál na ikadinág dán. Duwán mga inaté manubù na inanté dán. Duwán mga ágkayu-ayuan na igulit-ulitan dán katô Madigár Gulitán. ");
INSERT INTO bgs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Uliti yu sikandin na kadayawan tô mga manubù na dì ágduwa-duwa tingód kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Róggun igpanó tô mga manubù na igulì tun ki Juan, igkagi si Jesus tun ta ilimud mga manubù tingód ki Juan, na mà din, “Na, tô igsadun kó tun ta disyerto, ándà yu pamasaki tô manubù na iring ka banban na ágkálláng-kállángngán ka karamag. ");
INSERT INTO bgs_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ándà yu pamasaki tô manubù na gumpak ka dakál é lagà, su tô gó é góddô tun ta palasyo ka harì. ");
INSERT INTO bgs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Asal ni gó tô ágpamasakán yu. Igsadun kó tun ta disyerto ébô kitanán yu tô propeta ka Manama. Paminág yu ni kagin ku ákniyu. Tuu pa mallayat tô kamanubuan i Juan ka tandingán katô langun propeta ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Igtuman din ni tandô na igsulat tun ta kagi ka Manama, “Na, duwán manubù na papiddán ku muna áknikó ébô pataganaán tô langun manubù katô kadunggù nu.” ");
INSERT INTO bgs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Tô kamanubuan i Juan na Tarabunyag tuu pa mallayat ka tandingán katô langun manubù. Asal tô manubù na tuu mabbabà é kamanubuan tun ta pagpangulu ka Manama, tô gó é tuu pa mallayat ka tandingán ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Tô ándà pa tinurù si Juan na Tarabunyag, inalayun gulit tô mga propeta ka Manama asta igsulat si Moises na duwán álló na tumigkané tô Manama mangulu. Agad tikud tun ta katigkanayan katô katinurù i Juan sippang áknganni, duwán kakalyag katô mga manubù na pasakup tun ta pagpangulu ka Manama, asta marapung tô mga manubù na mirit pád magó katô pagpangulu ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Atin ka mánnal kó kanak, kasóddóran yu na si Juan tô igtuman katô igtandô dan na duwán dumunggù na iring katô propeta ka Manama sayyan na si Elias. ");
INSERT INTO bgs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Purisu kailangan maminág kó kanak ébô makagpát kó. ");
INSERT INTO bgs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Na, ulitán ku ákniyu tô tingód ka ágkéringan katô mga manubù áknganni. Iring sikandan na mga gabatà na gunsad tun ta plasa na ágkalingánnan asta ágpatawaré dan, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Igidup ké ka lantuy ébô sumayó kó, asal ándà kó sayó. Igkanta ké tingód katô kamatayan, asal ándà kó sággó.’ ");
INSERT INTO bgs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iring kandan tô mga manubù áknganni, su si Juan na Tarabunyag inalayun ágpuwasa, asta dì gó ginám. Purisu ágkagi dan na igahuwan sikandin ka madat espiritu. ");
INSERT INTO bgs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Asal sakán na Igpamanubù, ágkanna asta ginámma. Purisu ágkagi sikandan na áglólóbanna, sunnudda ginám, asta ágrarakán ku tô mga taralimud ka buwis asta tô duma mga manubù na masalà-salà! Asal ukit katô áglumun ka Manama, ágkasóddóran na nángngà tô kapandayan din.” ");
INSERT INTO bgs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na, igsawé i Jesus tô langun manubù na góddô tun ta mga lunsud na igimuwan din katô marapung mga kasalábbuan, su ándà dan rákkád ka mga salà dan. ");
INSERT INTO bgs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Igkagi sikandin, na mà din, “Makédu-édu kó na mga taga Corasin, asta makédu-édu kó na mga taga Betsaida, su ándà kó rákkád! Atin ka igimu tô mga kasalábbuan tun ta mga taga Tiro asta mga taga Sidon sayyan iring katô mga kasalábbuan na igimu ku dini ákniyu, igumpak dan pád katô óggét na gimun sako, asta igtagù dan pád ka abu tun ta ulu dan ébô pakitanán dan na igrákkád dan dán. ");
INSERT INTO bgs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Purisu kagiyan ku sikiyu, tun ta álló na rumuud tô Manama, agad supakan din tô mga taga Tiro asta tô mga taga Sidon tingód ka mga salà dan, asal tuu pa madat tô supak din ákniyu. ");
INSERT INTO bgs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sikiyu na mga taga Capernaum, kéman yu ka pabantugán kó sippang tun ta langit, asal dabuán kó baling tun ta góddóan katô mga inaté. Atin ka igimu tô mga kasalábbuan tun ta mga taga Sodoma sayyan iring katô mga kasalábbuan na igimu ku dini ákniyu, igrákkád dan pád, asta ándà pád kadatti tô lunsud dan. ");
INSERT INTO bgs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Purisu kagiyan ku sikiyu, tun ta álló na rumuud tô Manama, agad supakan din tô mga taga Sodoma tingód ka mga salà dan, asal tuu pa madat tô supak din ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na, tô oras tô, igdasal si Jesus, na mà din, “Ámmà, Áglangngagán katô langun tun ta langit asta dini ta banuwa, ágpasalamatta áknikó, su ándà nu pasóddóri ni kabánnalan tun ta mga manubù na kéman dan ka mapandé asta dakál é isóddóran, asal igpasóddór nud ni kabánnalan tun ta mga manubù na mabbabà dád é kamanubuan. ");
INSERT INTO bgs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Durungán ku sikuna, Ámmà, su tikud tun ta madigár kakalyag nu.” ");
INSERT INTO bgs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Igkagi si Jesus, na mà din, “Igsarig katô Ámmà ku tô langun dini kanak. Tô Ámmà ku dád tô ikasóddór kanak, su sakán tô Batà din. Sakán dád tô ikasóddór tingód katô Ámmà ku, asta tô langun manubù na ágsalinán ku ébô makasóddór tingód katô Ámmà ku. ");
INSERT INTO bgs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tô langun yu na ágmalómét tingód katô kapid yu katô kahirapan tun ta pusung yu, padani kó dini kanak, su iwaán ku tô kalómétan yu ébô makapaginawa kó. ");
INSERT INTO bgs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tiang yu tô papiddán ku ákniyu iring na yugo. Iring kó kanak, su mabbabà tô kamanubuan ku, asta makapaginawa kó. ");
INSERT INTO bgs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Madigár tô papiddán ku ákniyu, asta magan tô patiangán ku ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na, tô timpo tô, dalám katô álló ka kapaginawa ka mga Judio, igukit si Jesus asta tô mga disipulu din tun ta ligad ka kinamát na igparámmasan ka trigo. Igballus tô mga disipulu din. Purisu igbagtì dan tô mga kanguy ka trigo, asta igkan dan. ");
INSERT INTO bgs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tô igkita tô mga Pariseo, igkagi sikandan tun ki Jesus, na mà dan, “Ku! Iglapas tô mga disipulu nu katô sugù, su dì mému kumáttu dalám ka álló ka kapaginawa.” ");
INSERT INTO bgs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Igkagi si Jesus, na mà din, “Ilingawan yu basì ka ándin tô igsulat tun ta kagi ka Manama tingód katô iglumu i David sayyan. Igballus sikandin asta tô mga kadumaan din. ");
INSERT INTO bgs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Purisu igahu sikandin tun ta balé ka Manama, asta igkan din tô pan na igbággé tun ta Manama. Duwán pan na igbággé din tun ta mga kadumaan din. Agad tô mga pangulu ka templo dád tô mému kuman katô pan, asal ándà ikasalà si David. ");
INSERT INTO bgs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ilingawan yu basì na duwán igsulat i Moises na iglapas tô mga pangulu ka templo katô sugù tingód ka álló ka kapaginawa ukit ka kalumu dan, asal ándà dan ikasalà. ");
INSERT INTO bgs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Paminág yu ni kagin ku ákniyu. Agad mallayat tô templo, asal duwán dán igdunggù dini ákniyu na tuu pa mallayat ka tandingán katô templo. ");
INSERT INTO bgs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mà katô kagi ka Manama, “‘Ánnà tô ágbággén yu tô kakalyag ku, asal kakalyag ku na pédu-éduwé kó.’ Atin ka ikagpát kó kanan, dì kó pád sumawé katô mga disipulu ku na ándà lapas ka mga sugù. ");
INSERT INTO bgs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sakán na Igpamanubù tô mému kumagi ka ándin tô nángngà lumun ka mga manubù dalám ka álló ka kapaginawa.” ");
INSERT INTO bgs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na, igpanó si Jesus, asta igsadun sikandin tun ta simbaan ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Duwán sábbad manubù na igkángkáng é bállad. Duwán ássa mga manubù na ágparimuya asta ágpamasak ka dimanda dan tingód ki Jesus. Purisu iginsà sikandan, na mà dan, “Atin ka duwán dumappán ka bállad katô ágkabógókan ébô kólian dalám ka álló ka kapaginawa, makalapas sikandin ka sugù ka Manama?” ");
INSERT INTO bgs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Igkagi si Jesus tun kandan, na mà din, “Atin ka duwán karnero yu na madabù tun ta madalám bóbbó dalám ka álló ka kapaginawa, sadan tun ákniyu tô dì tumabang katô karnero ébô makaluwà? ");
INSERT INTO bgs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tô lagà ka manubù tuu pa dakál ka tandingán katô karnero! Purisu dì makalapas tô manubù ka sugù ka Manama tingód katô katabang din katô unawa din dalám ka álló ka kapaginawa.” ");
INSERT INTO bgs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na, igkagi si Jesus tun ta manubù na igkángkáng é bállad, na mà din, “Káttáng nu yan bállad nu.” Tô igkáttáng din, inólian dán, asta magunawa dán katô ágbaluy. ");
INSERT INTO bgs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Asal igluwà tô mga Pariseo tikud tun ta simbaan, asta igpatóngkóé dan ka ándin tô lumun dan ébô matayan dan si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na, tô ikasóddór si Jesus na madat tô plano katô mga Pariseo, igpanó sikandin. Marapung tô mga manubù na igtákkás kandin. Igdappánnan din ka bállad tô langun na ágkabógókan ébô kólian. ");
INSERT INTO bgs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Igsapad sikandin na kailangan ándà palang manubù na ulitan dan tingód kandin ");
INSERT INTO bgs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ébô matuman tô igkagi katô propeta ka Manama sayyan na si Isaias, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ni gó tô igsalin ku ébô papiddán tun ákniyu. Sikandin tô ágginawaan ku asta tô dayó ku. Bággén ku tô Ugis Espiritu na móddô tun kandin. Pasóddórán din na ukit kandin, imun nángngà tô langun manubù tun ta saruwan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dì sikandin mullaó, dì sikandin mapul, asta dì sikandin madinág tun ta mga dalan. ");
INSERT INTO bgs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dì din gésaan tô mga malómét, asta dì din ágkasókówan tô ándà bákkár sippang ka kasóddóran katô langun na nángngà tô áglumun din, ");
INSERT INTO bgs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","asta sikandin tô ágsarigan katô mga manubù tun ta langun banuwa.” ");
INSERT INTO bgs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na, duwán sábbad manubù na bólóg asta inómmó su igahuwan ka madat espiritu. Igpid sikandin tun ki Jesus. Igpaluwà i Jesus tô madat espiritu na igahu kandin, asta ikakagi sikandin asta ikakita dán. ");
INSERT INTO bgs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Isalábbuan tô langun manubù asta igpatóngkóé dan, na mà dan, “Sikandin basì tô sábbad rubbad i David.” ");
INSERT INTO bgs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tô igdinág tô mga Pariseo na igpaluwà i Jesus tô madat espiritu, igkagi sikandan, na mà dan, “Ágpaluwà sikandin katô mga madat espiritu ukit katô pangulu ka madat mga espiritu na si Belsebul.” ");
INSERT INTO bgs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Isóddóran i Jesus na madat tô panámdám dan. Purisu igkagi sikandin, na mà din, “Atin ka ágpamatayé tô mga sakup ka sábbad pangulu, dì madugé mandà tô pagpangulu din. Atin ka ágpamatayé tô mga sakup ka sábbad lunsud, asta ágpamatayé tô sábbad pamilya, dì madugé padiyaé dan. ");
INSERT INTO bgs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Purisu atin ka ágpaluwà si Maibuyan katô mga sakup din, mandà tô pagpangulu din, su imun din na usig tô mga sakup din. ");
INSERT INTO bgs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Atin ka sawén yu ni kapaluwà ku katô madat mga espiritu ukit ki Belsebul, ágsawén yu tô ákniyu mga disipulu, su ágpaluwà dan ka madat mga espiritu. Purisu sikandan tô ágpasóddór na ánnà nángngà tô kasawé yu kanak. ");
INSERT INTO bgs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Atin ka ágpaluwà a katô madat mga espiritu ukit katô Ugis Espiritu ka Manama, igdunggù dán gó dini ákniyu tô pagpangulu ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Atin ka mabákkár tô manubù, dì kahuwan tô balé din asta dì kangén tô kaduwánnan din. Asal atin ka dumunggù tô ássa manubù na tuu pa mabákkár ka tandingán kandin, tô gó é makabagkás katô tigatun ka balé asta makakangé katô langun tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tô langun manubù na dì ágtákkás kanak, tô gó é gusig kanak, asta tô langun manubù na dì áglimud ka mga manubù dini kanak, tô gó é ágpéwà ka mga manubù tikud dini kanak. ");
INSERT INTO bgs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Purisu paminág yu ni kagin ku ákniyu. Tô manubù na masalà-salà asta ágkagi ka madat tingód ka manubù, atin ka rumákkád sikandin, mému kapasinsiyaan ka Manama. Asal tô manubù na ágkagi ka madat tingód katô Ugis Espiritu, dì gó sikandin kapasinsiyaan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tô manubù na ágkagi ka madat tingód kanak na Igpamanubù, atin ka rumákkád sikandin, mému kapasinsiyaan ka Manama. Asal tô manubù na ágkagi ka madat tingód katô Ugis Espiritu, dì gó sikandin kapasinsiyaan, agad áknganni ó tun ta tapuri álló.” ");
INSERT INTO bgs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Atin ka madigár tô kayu, madigár tô buuy din. Atin ka madat tô kayu, madat tô buuy din. Atin ka ágkitanán ta tô buuy, kasóddóran ta ka madigár ó madat tô kayu. ");
INSERT INTO bgs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Madat kó iring na mga áppuy! Ándà palang madigár ágkagin yu, su madat tô tun ta dalám katô pusung yu. Atin ka ágkagi tô manubù, ágpasóddórán din tô tun ta dalám katô pusung din. ");
INSERT INTO bgs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Atin ka madigár tô ágkémun katô manubù, madigár tô ágkagin din. Atin ka madat tô ágkémun katô manubù, madat tô ágkagin din. ");
INSERT INTO bgs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Paminág yu ni kagin ku ákniyu. Atin ka dumunggù tô álló na rumuud tô Manama, supakan din tô langun manubù na igkagi ka mga ándà ágpulusán. ");
INSERT INTO bgs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tô ágkagin yu áknganni, tô gó é gamitán ka ruudan kó ka Manama tun ta kapasóddór din ka nángngà ó ánnà nángngà tô igkagi yu.” ");
INSERT INTO bgs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na, igkagi tô mga Pariseo asta tô mga taratinurù ka sugù, na mà dan, “Sir, pakita ké katô kasalábbuan ébô kasóddóran dé na igpapid ka katô Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Asal igtaba si Jesus, na mà din, “Tô mga malyag na duwán kasalábbuan na pakitanán kandan, tô gó é mga madat asta igtayyug ka Manama. Asal sábbad dád tô kasalábbuan na pakitanán kandan na iring katô ilumu tun ta propeta ka Manama sayyan na si Jonas. ");
INSERT INTO bgs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Su itálluwan si Jonas tun ta dalám ka gátták katô dakál sáddà, sakán pagsik na Igpamanubù, katálluwanna tun ta dalám ka tanà. ");
INSERT INTO bgs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tun ta álló na rumuud tô Manama, tumindág tô mga taga Ninibe, asta kumagi dan na kailangan supakan kó su ándà kó rákkád katô mga salà yu. Su tô igdinág tô mga taga Ninibe katô igulit-ulit i Jonas, igrákkád dan. Na, duwán dán igdunggù dini ákniyu na tuu pa mallayat tô kamanubuan din ka tandingán ki Jonas. ");
INSERT INTO bgs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tun ta álló na rumuud tô Manama, tumindág tô rayna na igpangulu tun ta Siba sayyan, asta kumagi sikandin na kailangan supakan kó su ándà kó paminág kanak. Agad madiyù tô góddóan katô rayna, asal igsadun sikandin tun ki Solomon ébô maminág dád katô kapandayan na ágtinuruán i Solomon. Na, duwán dán igdunggù dini ákniyu na tuu pa mallayat tô kamanubuan din ka tandingán ki Solomon.” ");
INSERT INTO bgs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Na, atin ka duwán madat espiritu na paluwaán tikud tun ta manubù, ágpanó-panó tô madat espiritu tun ta disyerto ébô mamasak sikandin ka madigár óddóan din. Atin ka ándà ágkitanán din, ");
INSERT INTO bgs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kumagi sikandin, na mà din, ‘Lumónódda tun ta manubù na taganà igahuwan ku.’ Purisu lumónód tô madat espiritu tun kandin, asta kitanán din na madigár dán tô manubù na taganà din igahuwan, iring na malinis asta matémmós balé. ");
INSERT INTO bgs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Purisu kangén katô madat espiritu tô ássa pittu madat espiritu na tuu pa madat ka tandingán kandin. Madun dan langun tun ta manubù, asta mahu dan tun kandin. Purisu tuu pa madat tô dungguán kani manubù ni. Na, madat pagsik tô dungguán katô langun manubù áknganni na madat tô áglumun dan.” ");
INSERT INTO bgs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na, róggun ágtinurù si Jesus, igdunggù tô innà asta tô mga kataladi din. Igtindág dan tun ta luwà katô balé, su kakalyag dan na tumóngkô kandin. ");
INSERT INTO bgs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Duwán sábbad manubù na igkagi ki Jesus, na mà din, “Tun ta luwà tô innà nu asta tô mga kataladi nu. Kakalyag dan kun na tumóngkô áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Asal igkagi si Jesus tun kandin, na mà din, “Kagin ku áknikó ka sadan tô innà ku asta tô mga kataladi ku!” ");
INSERT INTO bgs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na, igtáddù i Jesus tô mga disipulu din, asta igkagi sikandin, na mà din, “Ni gó tô innà ku asta tô mga kataladi ku. ");
INSERT INTO bgs_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tô mga manubù na ágbánnal ka kagi katô Ámmà ku tun ta langit, sikandan tô mému na innà ku asta mga kataladi ku na gamama asta gabayi.” ");
INSERT INTO bgs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na, tô álló tô, igluwà si Jesus tikud tun ta balé, igsadun sikandin tun ta ligad ka ranó, asta igunsad dutun. ");
INSERT INTO bgs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Asal su iglibutan sikandin katô marapung manubù, igsaké sikandin tun ta barangé na igpundowan asta igunsad ébô tuminurù. Igtindág tô langun manubù tun ta ligad ka ranó ébô maminág kandin. ");
INSERT INTO bgs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Marapung tô kabánnalan na igtinurù din kandan ukit ka panunggiringan. Igkagi si Jesus, na mà din, “Duwán sábbad manubù na igsadun tun ta kinamát ébô sumabud ka bánnì. ");
INSERT INTO bgs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tô igsabud sikandin, duwán isabud tun ta dalan, asta igtuktuk katô mga manuk ta kayun. ");
INSERT INTO bgs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Duwán ássa bánnì na isabud tun ta batun tanà. Sékót igtubù, su ánnà madalám tô tanà. ");
INSERT INTO bgs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tô igménit dán tô álló, ilanás asta inaté, su ándà tuu ikaramut. ");
INSERT INTO bgs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Duwán ássa bánnì na isabud tun ta tángngaan katô dugin sigbát. Asal itambunan katô dugin sigbát tô pamula, asta inaté. ");
INSERT INTO bgs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Asal duwán bánnì na isabud tun ta malambù tanà. Tô gó tô madigár é tubù na igbuuy ka ginatus-gatus, ó kannámman (60), ó tállu pulù (30).” ");
INSERT INTO bgs_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Igkagi si Jesus, na mà din, “Purisu kailangan maminág kó kanak ébô makagpát kó.” ");
INSERT INTO bgs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na, igpadani tô mga disipulu i Jesus tun kandin, asta iginsà sikandan, na mà dan, “Manan ka ukit ka mga panunggiringan tô katinurù nu katô mga manubù?” ");
INSERT INTO bgs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Igtaba si Jesus, na mà din, “Sikiyu tô igpakitaan ka Manama katô kabánnalan na ándà din pasóddóri dángngan tingód katô pagpangulu din. Asal ándà din pakitayi tô duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tô manubù na ágbánnal katô kabánnalan, tô gó é dugangan katô kabánnalan ébô tuu pa dakál. Asal tô manubù na dì ágbánnal katô kabánnalan, tô gó é kangayan katô kabánnalan. ");
INSERT INTO bgs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Purisu ukit dád tun ta mga panunggiringan tô katinurù ku katô duma mga manubù su agad sumállág dan, dì dan makakita katô kóbadan. Agad maminág dan, dì dan makagpát katô kabánnalan. ");
INSERT INTO bgs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Purisu ituman tô igulit katô propeta ka Manama sayyan na si Isaias, “‘Agad tuu kó gó maminág, dì kó makagpát. Agad tuu kó gó sumállág, dì kó makagpát, ");
INSERT INTO bgs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","su igpatággas kani mga manubù tô ulu dan agó makagpát dan. Igsagpángngan dan tô talinga dan agó duminág dan ka kabánnalan. Iglipáddáng dan tô mata dan agó kumita dan ka kóbadan ka kagi ku kandan. Ándà kakalyag dan na padani kanak ébô tabangan ku sikandan.’ ");
INSERT INTO bgs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Asal sikiyu, ágkadayawan kó, su ikakita kód asta ikadinág kód katô kabánnalan. ");
INSERT INTO bgs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Paminág yu ni kagin ku ákniyu. Tô marapung mga propeta ka Manama sayyan asta tô duma mga manubù na igbánnal katô mga sugù ka Manama, agad malyag dan na kumita katô igkita yu, asal ándà dan ikakita. Agad malyag dan maminág katô igdinág yu, asal ándà dan ikadinág.” ");
INSERT INTO bgs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na, paminág kód ka kóbadan katô panunggiringan tingód katô manubù na igsabud ka bánnì. ");
INSERT INTO bgs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tô bánnì na isabud tun ta dalan, iring katô manubù na ágpaminág tingód katô pagpangulu ka Manama, asal dì sikandin pakagpát. Ágsadunan i Maibuyan ébô agón din tô kagi ka Manama na igdinág din. ");
INSERT INTO bgs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tô bánnì na isabud tun ta batun, iring katô manubù na ágpaminág ka kagi ka Manama, asta ágtanggap sikandin na duwán dayó din. ");
INSERT INTO bgs_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Asal ka kahirapan asta kérrayatan sikandin tingód ka kabánnal din katô kagi ka Manama, sékót ágkandà tô kabánnal din, su iring sikandin katô pamulanán na ándà tuu ramut. ");
INSERT INTO bgs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na, tô bánnì na isabud tun ta tángngaan ka dugin sigbát, iring katô manubù na ágpaminág katô kagi ka Manama na igtinurù. Asal talun sikandin katô sasó tingód ka kantayan asta kakalyag din na kaduwánnan. Purisu ándà ágpulusán din katô kagi ka Manama na igdinág din. ");
INSERT INTO bgs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na, tô bánnì na isabud tun ta malambù tanà, iring katô manubù na ágpaminág katô kagi ka Manama, asta makagpát. Duwán gó ágpulusán din iring katô madigár é tubù na igbuuy ka ginatus-gatus, ó kannámman (60) ó tállu pulù (30).” ");
INSERT INTO bgs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na, igtinurù si Jesus kani panunggiringan, na mà din, “Iring kani tô pagpangulu ka Manama. Duwán manubù na igsabud katô madigár klasi ka bánnì ka trigo tun ta kinamát din. ");
INSERT INTO bgs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Asal róggun igtudug tô mga manubù, duwán usig na igsadun tun ta kinamát din, igsabud din tô bánnì ka sigbát, asta igulì. ");
INSERT INTO bgs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Igpadángngané igtubù tô trigo asta tô sigbát. Tô igkanguy dán tô trigo, ikitaan tô sigbát. ");
INSERT INTO bgs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Igsadun tô mga állang tun ta amo dan, asta iginsà dan, ‘Tuu madigár tô bánnì na igsabud ta tun ta kinamát nu. Asal ánda tikud tô sigbát?’ ");
INSERT INTO bgs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Igtaba tô tigatun, ‘Tô gó é igsabud katô usig ku.’ Iginsà dan, ‘Malyag ka na béttódán dé tô sigbát?’ ");
INSERT INTO bgs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Asal igkagi sikandin, ‘Yakó pa ágbéttód katô sigbát agó mabéttód pagsik tô trigo na igpamula ta. ");
INSERT INTO bgs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabayà yu sippang ka dumakál. Atin ka dumunggù tô álló ka kakáttu, suguán ku tô mga manubù na upusán dan pa béttódán tô sigbát asta bagkássán dan ébô góbbón. Asal káttun dan tô trigo, asta taguán dan tun ta lukung.’” ");
INSERT INTO bgs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na, igtinurù si Jesus kani panunggiringan, na mà din, “Tô pagpangulu ka Manama iring na lisu ka mustasa na igpamula ka manubù tun ta kinamát din. ");
INSERT INTO bgs_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Agad tuu pa délák tô lisu ka mustasa ka tandingán katô mga duma lisu, asal ka tumubù, mému dakál pa ka tandingán ka langun ka duma mga pamula. Mému dakál iring na kayu. Purisu ágsalagan katô mga manuk ta kayun.” ");
INSERT INTO bgs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na, igtinurù si Jesus kani panunggiringan, na mà din, “Tô pagpangulu ka Manama iring katô pagpatubù ka pan, su atin ka baláttán tun ta dakál harina, tumubù tô langun harina na igmasa.” ");
INSERT INTO bgs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tô gó é igtinurù i Jesus katô ilimud mga manubù ukit tun ta panunggiringan tingód katô pagpangulu ka Manama. Igpókit din tun ta panunggiringan tô langun igtinurù din kandan. ");
INSERT INTO bgs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Purisu ituman tô kagi katô propeta ka Manama sayyan, na mà din, “Tuminurù a katô mga manubù ukit ka panunggiringan. Ulitán ku kandan tô ándà ku pasóddóri tikud tun ta katigkanayan kani banuwa.” ");
INSERT INTO bgs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na, igpanó si Jesus tikud tun ta mga manubù na ilimud, asta igahu sikandin tun ta balé. Igtákkás tô mga disipulu din, asta igpédu-édu dan, na mà dan, “Uliti ké ka ándin tô kóbadan katô panunggiringan tingód katô sigbát na igtubù tun ta kinamát.” ");
INSERT INTO bgs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Igkagi si Jesus, na mà din, “Tô igsabud ka madigár bánnì, sakán gó na Igpamanubù. ");
INSERT INTO bgs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tô kinamát, ni gó banuwa. Tô madigár bánnì, tô gó tô mga manubù na igpasakup tun ta pagpangulu ka Manama. Asal tô sigbát, tô gó tô mga sakup i Maibuyan. ");
INSERT INTO bgs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tô usig na igsabud katô sigbát, tô gó si Maibuyan. Tô kóbadan katô kakáttu, tô gó tô ágtamanán kani banuwa, asta tô mga tarakáttu, tô gó tô mga panaligan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tô kalimud asta kagóbbó dan katô sigbát, iring katô malumu tun ta ágtamanán kani banuwa. ");
INSERT INTO bgs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sakán na Igpamanubù tô sumugù katô mga panaligan ka Manama ébô linisan ni banuwa na ágpanguluwan ku, su limudán dan tô langun manubù na ágtintal ka duma manubù asta áglumu ka madat. ");
INSERT INTO bgs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Antugán katô mga panaligan ka Manama tô langun dan tun ta apuy na ágsupakanan. Tuu dan sumággó dutun, asta kumurigát tô ngipán dan tingód katô kasakit dan. ");
INSERT INTO bgs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Asal tô mga manubù na ágbánnal katô mga sugù ka Manama miló iring katô sánnang ka álló kannun ta banuwa, asta ágpanguluwan dan katô kandan Ámmà na Manama. Purisu kailangan maminág kó kanak ébô makagpát kó.” ");
INSERT INTO bgs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Iring pagsik kani tô pagpangulu ka Manama. Duwán bulawan na idugé dán iglábbáng tun ta tanà. Na, duwán manubù na ikakita katô bulawan. Idayawan sikandin, asal igtambunan din puman, asta igulì sikandin. Igbarigyà din tô langun kaduwánnan din asta igbálli din tô tanà.” ");
INSERT INTO bgs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Iring pagsik kani tô pagpangulu ka Manama. Duwán negosyante na ágpamasak ka madigár klasi ka perlas. ");
INSERT INTO bgs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na, duwán perlas na igkita din na tuu dakál é lagà. Igulì sikandin, asta igbarigyà din tô langun kaduwánnan din, asta igbálli din tô perlas.” ");
INSERT INTO bgs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Iring pagsik kani tô pagpangulu ka Manama. Duwán pukut na igdabù tun ta ranó, asta marapung tô mga klasi ka sáddà na ikahu. ");
INSERT INTO bgs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tô igmarapung dán tô sáddà, igguyud katô mga taraággut tun ta ligad ka ranó ébô kangén dan tô sáddà. Igtagù dan tô mga madigár klasi tun ta mga basket, asal igantug dan tô mga madat. ");
INSERT INTO bgs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iring kanan tô malumu tun ta ágtamanán kani banuwa. Ássan katô mga panaligan ka Manama tô mga manubù na madat asta tô mga manubù na ágbánnal katô mga sugù ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Antugán dan tô madat mga manubù tun ta apuy na ágsupakanan. Tuu dan sumággó dutun, asta kumurigát tô ngipán dan tingód katô kasakit dan.” ");
INSERT INTO bgs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na, iginsà si Jesus katô mga disipulu din, na mà din, “Inagpáttan yu tô langun igtinurù ku?” Igtaba sikandan, na mà dan, “Óó. Inagpáttan dé.” ");
INSERT INTO bgs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Purisu igkagi si Jesus, na mà din, “Atin ka duwán taratinurù na duwán kakatigan din tingód katô kagi ka Manama na taganà dán igsulat, asta miring sikandin katô mantu katinurù ku tingód katô pagpangulu ka Manama, iring sikandin katô tigatun ka balé na duwán dakál kaduwánnan na inalayun din ággamitán, agad tapé dán ó mantu.” ");
INSERT INTO bgs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Na, pángnga igtinurù si Jesus katô langun kani mga panunggiringan, igpanó sikandin, ");
INSERT INTO bgs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","asta igulì tun ta kandin banuwa. Igtinurù sikandin tun ta simbaan ka Judio. Tuu isalábbuan tô mga manubù dutun, asta igkagi dan, na mà dan, “Ánda igkangé ni manubù ni katô kapandayan din? Ánda é igkangayan din kani katulusan ébô makalumu kani mga kasalábbuan? ");
INSERT INTO bgs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Su batà dád katô taraimu ka balé sikandin, asta tô innà din si Maria. Tô mga kataladi din na si Santiago, si Jose, si Simon, asta si Judas. ");
INSERT INTO bgs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tô mga tábbé din pagsik góddô dini áknita. Ánda é igkangayan din kani langun áglumun din?” ");
INSERT INTO bgs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Purisu ándà dan bánnal kandin. Asal igkagi si Jesus tun kandan, na mà din, “Agad ágtanggapán tô propeta ka Manama tun ta ássa lunsud, asal dì sikandin ágtanggapán katô mga manubù tun ta kandin banuwa asta tun ta pamilya din.” ");
INSERT INTO bgs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Purisu tagsábbadé dád tô mga kasalábbuan na iglumu i Jesus dutun, asta ándà dan tanggap kandin. ");
INSERT INTO bgs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na, si Herodes tô igpangulu tun ta Galilea, asta igulitan sikandin tingód katô áglumun i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Igkagi sikandin tun ta mga opisyales din, na mà din, “Sikandin gó si Juan na Tarabunyag na inanté puman. Purisu duwán katulusan din ébô imun din ni mga kasalábbuan.” ");
INSERT INTO bgs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tô gó é igkagi i Herodes, su dángngan igpammát din si Juan, igpabagkás din é bállad, asta igpapriso din. Tô gó é iglumu i Herodes ki Juan ébô kadayawan tô ipag din na si Herodias na igagó din tikud tun ta kataladi din na si Felipe. ");
INSERT INTO bgs_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tô igagó si Herodes katô ipag din, igkagi si Juan kandin, na mà din, “Iglapas ka katô sugù ka Manama, su igagó nu tô ipag nu.” ");
INSERT INTO bgs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na, tô kakalyag i Herodes na pamatayan din si Juan, asal ándà din panayuni. Imáddangan sikandin agó masókó tô langun manubù kandin, su igpanámdám dan na propeta ka Manama si Juan. ");
INSERT INTO bgs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na, igimu si Herodes ka kalimudan tingód katô álló din, asta igsayó tô batà daraga i Herodias ébô kadayawan tô mga manubù na ilimud. Idayawan si Herodes. ");
INSERT INTO bgs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Purisu igtandô sikandin na bággén din tun ta daraga tô agad ándin é pamuyuán din. ");
INSERT INTO bgs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Igbánnal tô daraga katô igkagi katô innà din, asta igkagi sikandin, na mà din, “Bággé nu kanak tô ulu i Juan na Tarabunyag na taguán tun ta dakál pinggan.” ");
INSERT INTO bgs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Iranu si Herodes. Asal tingód katô tandô din, asta agó buyasán sikandin katô mga manubù na ilimud, igtuman din tô igpamuyù katô daraga. ");
INSERT INTO bgs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Purisu igpatampád i Herodes tô alig i Juan tun ta prisowan. ");
INSERT INTO bgs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Igtagù tô ulu i Juan tun ta dakál pinggan, igbággé tun ta daraga, asta igpid din tun ta innà din. ");
INSERT INTO bgs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Igsadun tô mga disipulu i Juan tun ta prisowan, igkangé dan tô lawa din, asta iglábbáng dan. Igsadun dan tun ki Jesus, asta igulit dan kandin tingód katô kamatayan i Juan. ");
INSERT INTO bgs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na, tô igdinág si Jesus tingód katô kamatayan i Juan, igpanó sikandin tikud dutun. Igsaké sikandin ka barangé, asta igsadun tun ta lugar na ándà manubù. Asal tô ikasóddór tô langun manubù ka ánda é igsadunan i Jesus, igpanóttanà dan tikud tun ta mga lunsud asta igsadun dan tun ta igsadunan i Jesus ");
INSERT INTO bgs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tô igpónóg si Jesus, igkita din tô marapung manubù na igangat kandin. Inéduwan sikandin kandan, asta igdappánnan din ka bállad tô langun na ágkabógókan, asta inólian dan. ");
INSERT INTO bgs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tô mapun dán, igpadani tô mga disipulu i Jesus tun kandin, asta igkagi sikandan, na mà dan, “Ándà mga manubù na góddô kannun, asta masig dán dumukilám. Purisu papanó nu tô langun manubù tun ta mga lunsud ébô málli ka makan dan.” ");
INSERT INTO bgs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Igkagi si Jesus, na mà din, “Dì dán kailangan na manó dan. Sikiyu é mággé ka makan dan.” ");
INSERT INTO bgs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Igkagi sikandan, na mà dan, “Asal lima dád abuk ni pan ta, asta duwa dád abuk ni sáddà ta.” ");
INSERT INTO bgs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Igkagi si Jesus, na mà din, “Pid yu dini kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na, igpónsad i Jesus tô langun manubù tun ta sigbáttán tanà. Igkangé din tô lima abuk pan asta tô duwa abuk sáddà. Iglangngag sikandin tun ta langit, asta igpasalamat tun ta Manama. Igtáppik-táppik din tô pan, asta igbággé din tun ta mga disipulu din ébô taladán dan tun ta mga manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ikakan tô langun manubù, asta ibássug dan. Duwán pa sapulù duwa (12) magdakál basket na ipánnù katô isamà na iglimud katô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mga lima mararan (5,000) tô mga gamama na ikakan, asta ándà iyapi tô mga gabayi asta tô mga gabatà. ");
INSERT INTO bgs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Na, igpóna i Jesus tô mga disipulu din igsaké ka barangé ébô tumalipag dan katô ranó róggun ágpólián din tô langun manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tô igpanó dan dán, igtikáddág si Jesus tun ta pabungan ébô dumasal na sábbad din dád. Tô ágkasalláp dán tô álló, tun pô ta pabungan si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Asal madiyù dán tô barangé su tun dán ta tángngaan katô ranó. Tuu dan ihirapan, su idungguan dan ka magdakál balud, asta ikasumar dan ka mabákkár karamag. ");
INSERT INTO bgs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na, tô masig dán igsállám, igsadun si Jesus tun kandan, asta igpanó sikandin tun ta bówwó katô ranó. ");
INSERT INTO bgs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tô igkita dan na igpanó sikandin tun ta bówwó katô ranó, tuu dan imáddangan. Tingód katô máddang dan, igullaó sikandan, na mà dan, “Gimukud!” ");
INSERT INTO bgs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Asal tigkô dád igkagi si Jesus kandan, na mà din, “Pasarig yu tô pusung yu, su sakán ni. Yakó ágkamáddangan.” ");
INSERT INTO bgs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Igkagi si Pedro, na mà din, “Áglangngagán, atin ka bánnal na sikuna yan, papanówa nit bówwó ka ranó ébô makasadunna diyan áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Igkagi si Jesus, na mà din, “Sadun ka dini.” Purisu igpónóg si Pedro tikud tun ta barangé, asta igpanó tun ta bówwó ka ranó ébô madun tun ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Asal tô igriyu din tô mabákkár karamag, imáddangan sikandin asta masig pád ilánnád. Igtawar sikandin, na mà din, “Áglangngagán, tabangiya.” ");
INSERT INTO bgs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sékót si Jesus igawid kandin, asta igkagi, na mà din, “Délák tô kasarig nu kanak. Yaka ágduwa-duwa.” ");
INSERT INTO bgs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tô igsaké dan tun ta barangé, igsódô dán tô karamag. ");
INSERT INTO bgs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iglingkóód tô mga disipulu tun ki Jesus, igpangadap dan kandin, asta igkagi sikandan, na mà dan, “Sikuna tô bánnal Batà ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na, tô igtalipag dan katô ranó, igdunggù dan tun ta Genesaret. ");
INSERT INTO bgs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Igkilala tô mga taga Genesaret ki Jesus. Purisu igpakangé dan tô langun ágkabógókan tikud tun ta mga banuwa na madani. ");
INSERT INTO bgs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Igpédu-édu dan ki Jesus ka mému mawid dan katô ugpu ka umpak din, asta inólian tô langun dan na ikawid. ");
INSERT INTO bgs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na, duwán mga Pariseo asta mga taratinurù ka sugù na igsadun tun ki Jesus tikud tun ta Jerusalem. Iginsà dan kandin, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Manan ka dì ágbánnal tô mga disipulu nu katô ágkémun ka mga kamónaan ta? Atin ka ágkan dan, dì dan ágdamù.” ");
INSERT INTO bgs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Igkagi si Jesus, na mà din, “Áglapas kó katô mga sugù ka Manama ukit ka kabánnal yu katô ágkémun ka mga kamónaan yu. ");
INSERT INTO bgs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Igsugù tô Manama, ‘Respetowi yu tô ákniyu ámmà asta innà.’ Igsugù pagsik sikandin, ‘Kailangan matayan tô manubù na ágkagi ka madat tun ta ámmà ó innà din.’ ");
INSERT INTO bgs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Asal ágtinurù kó na mému ka dì tumabang tô manubù katô ámmà ó innà din ka kumagi dád, ‘Tô bággén ku pád ákniyu igbággé kud tun ta Manama.’ ");
INSERT INTO bgs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Asal ukit ka kabánnal yu kani ágkémun, géllé kó katô sugù ka Manama na kailangan tabangan yu tô ámmà asta innà yu. ");
INSERT INTO bgs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama! Sikiyu tô igtádduan kani kagi ka Manama na igulit i Isaias sayyan, ");
INSERT INTO bgs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Ágkagi tô mga manubù na ágpangadap dan kanak, asal madiyù tô pusung dan kanak. ");
INSERT INTO bgs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dì nángngà tô kapangadap dan kanak, su igimu dan iring na tinurù ka Manama tô mga ágtinuruán ka manubù.’” ");
INSERT INTO bgs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na, marapung tô mga manubù na ilimud dutun, asta igtawar si Jesus kandan ébô madani dan tun kandin. Igkagi sikandin, na mà din, “Paminág kó kanak ébô makagpát kó. ");
INSERT INTO bgs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ánnà tô ágkakan na mahu tun ta babbà tô makaripà ka manubù, asal tô madat mga kagi na ágluwà tikud tun ta babbà din tô makaripà ka manubù tun ta saruwan ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na, igpadani tô mga disipulu i Jesus tun kandin, asta igkagi dan, na mà dan, “Miringasa tô mga Pariseo tingód katô igkagi nu géna.” ");
INSERT INTO bgs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Igkagi si Jesus, na mà din, “Péwaán tô langun dan, su béttódán tikud tun ta kinamát tô langun pamula na ándà pamulayi katô Ámmà ku na góddô tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Liliyi yu tô mga Pariseo. Iring dan na bólóg na gagak. Atin ka magak tô bólóg katô ássa bólóg, madabù tô duwa dan tun ta madalám bóbbó.” ");
INSERT INTO bgs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Igkagi si Pedro, na mà din, “Uliti ké ka ándin é kóbadan katô panunggiringan na igtinurù nu géna.” ");
INSERT INTO bgs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Igkagi si Jesus, na mà din, “Isalábbuanna su iring kó na mga manubù na dì pakagpát. ");
INSERT INTO bgs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Agad ándin tô ágkakan na pahun tun ta babbà ka manubù, tô gó é manayun tun ta gátták, asta lumuwà tikud tun ta lawa. ");
INSERT INTO bgs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Asal tô kagi na lumuwà tikud tun ta babbà ka manubù, tikud tun ta pusung din, asta tô gó é makaripà kandin. ");
INSERT INTO bgs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tô pusung tô ágtikudan katô madat mga panámdám, ágmaté, áglibug, ágtakó, ágtestigos ka bulaló, asta ágkagi ka madat tingód ka duma manubù. ");
INSERT INTO bgs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Karipaan tô manubù ukit kani langun. Asal dì karipaan tô manubù na ágkan ka dì ágdamù.” ");
INSERT INTO bgs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Igpanó si Jesus, asta igsadun sikandin tun ta probinsya na madani tun ta lunsud ka Tiro asta Sidon. ");
INSERT INTO bgs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Duwán sábbad bayi na igóddô dutun na ánnà Judio, su Canaanhon tô mga kamónaan din. Igsadun sikandin tun ki Jesus, asta igtawar, na mà din, “Sir, rubbad i David, kéduwiya, su ágkatuuwan ni batà ku bayi na gahuwan ka madat espiritu.” ");
INSERT INTO bgs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Asal ándà taba si Jesus kandin. Purisu igpadani tô mga disipulu i Jesus tun kandin, asta igkagi sikandan, na mà dan, “Péwà nu yan bayi, su ágtákkás sikandin áknita, asta tuu gótép.” ");
INSERT INTO bgs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Igkagi si Jesus, na mà din, “Igpapidda ébô tabangan ku dád tô mga rubbad i Israel na iring na mga karnero na itadin.” ");
INSERT INTO bgs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na, igpadani tô bayi tun ki Jesus, iglingkóód asta igkagi sikandin, na mà din, “Sir, tabangiya.” ");
INSERT INTO bgs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Igkagi si Jesus, na mà din, “Asal duwán ágkagin na dì mému ka kangén tô ágkakan ka mga gabatà ébô pakannán ka mga asu.” ");
INSERT INTO bgs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Igkagi tô bayi, na mà din, “Sir, bánnal tô igkagi nu. Asal tô mga asu mému kuman katô mumu na ágkadabù tikud tun ta lamisa katô amo.” ");
INSERT INTO bgs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Igkagi si Jesus katô bayi, na mà din, “Dakál tô kasarig nu kanak! Tumanán ku tô kakalyag nu.” Tigkô dád igmadigár tô batà din tô oras tô. ");
INSERT INTO bgs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na, igpanó si Jesus, asta igukit sikandin tun ta ligad ka Ranó ka Galilea. Igtikáddág sikandin tun ta madani pabungan asta igunsad sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Marapung tô mga manubù na igsadun tun kandin, asta igpid dan tô duma mga manubù na duwán ássa-ássa bógók. Duwán mga kapig, mga pantig, mga bólóg, mga ómmó, asta marapung tô duma na mga ágkabógókan. Igpid dan madani tun ki Jesus. Igdappánnan din ka bállad sikandan, asta inólian dan. ");
INSERT INTO bgs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Isalábbuan tô langun manubù, su igkita dan na ikakagi tô mga ómmó, inólian tô mga pantig, ikapanó tô mga kapig, asta ikakita tô mga bólóg. Purisu igdurung dan tô Manama na ágpangadapán katô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na, igtawar i Jesus tô mga disipulu din, asta igkagi sikandin, na mà din, “Inéduwanna kani mga manubù, su itálluwan dan dán na ágtákkás kanak, asta ándà dán ágkannán dan. Dì mému ka pólián ku sikandan na ágballusán agó kagáttasan dan tun ta dalan.” ");
INSERT INTO bgs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Igkagi tô mga disipulu din, na mà dan, “Ándà góddô kannun, asta ándà palang kangayan ta ka makan para kandan, su tuu dan marapung.” ");
INSERT INTO bgs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iginsà si Jesus, na mà din, “Pira abuk tô pan tun ákniyu?” Igtaba sikandan, na mà dan, “Pittu abuk pan, asta pira dád abuk marénták sáddà.” ");
INSERT INTO bgs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na, igpónsad i Jesus tô langun manubù tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Igkangé din tô pittu abuk pan asta tô sáddà, asta igpasalamatan din tun ta Manama. Igtáppik-táppik din tô pan asta tô sáddà, igbággé din tun ta mga disipulu din, asta igtalad dan tun ta mga manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ikakan tô langun manubù, asta ibássug dan. Iglimud dan tô isamà, asta pittu tô magdakál basket na ipánnù. ");
INSERT INTO bgs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mga áppat mararan (4,000) tô mga gamama na ikakan, asta ándà iyapi tô mga gabayi asta tô mga gabatà. ");
INSERT INTO bgs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Igpólì i Jesus tô langun dan, igsaké sikandin ka barangé, asta igsadun sikandin tun ta probinsya na madani tun ta Magadan. ");
INSERT INTO bgs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na, duwán mga Pariseo asta mga Saduseo na igpadani tun ki Jesus ébô kuminnam kandin. Purisu igpamuyù dan na pakitanán din tô kasalábbuan tikud tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Igkagi si Jesus, na mà din, “Atin ka ágmallutù tô langit ka ágsalláp tô álló, kasóddóran yu na dì mudan simag. ");
INSERT INTO bgs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Atin ka mallutù asta mangittáng tô sagulapun ka ágsilat tô álló, kasóddóran yu na mudan. Agad ágkakilalaan yu tô gahaanan tun ta langit, asal ándà yu kagpátti tô mga kakilalaan áknganni. ");
INSERT INTO bgs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kakalyag yu na pakitanán ku ákniyu tô kasalábbuan su madat kó asta igtayyug kó katô Manama. Asal sábbad dád é kasalábbuan na pakitanán ákniyu na iring katô ilumu ki Jonas.” Na, igpanó si Jesus tikud tun kandan. ");
INSERT INTO bgs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na, tô igtalipag tô mga disipulu i Jesus katô ranó, ándà pan na igpid dan, su ilingawan dan tô tánnó dan. ");
INSERT INTO bgs_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Igkagi si Jesus, na mà din, “Banté kó katô pagpatubù ka pan katô mga Pariseo asta mga Saduseo.” ");
INSERT INTO bgs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Igpatóngkóé tô mga disipulu din, na mà dan, “Tô gó é igkagi din su ándà pan na igpid ta.” ");
INSERT INTO bgs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Asal isóddóran i Jesus ka ándin tô panámdám dan. Purisu igkagi sikandin, na mà din, “Délák tô kasarig yu kanak. Ándà kó pa ikagpát. Purisu ágpatóngkóé kó na ándà pan na igpid yu. ");
INSERT INTO bgs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Isalábbuanna ákniyu, su ándà kó pa ikasóddór ka ándin tô mému lumun ku. Iring na ilingawan yud tô igpakan ku tô lima mararan (5,000) manubù katô lima abuk pan, asta marapung tô magdakál basket na igipánnù yu katô isamà. ");
INSERT INTO bgs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Iring na ilingawan yu tô igpakan ku tô áppat mararan (4,000) manubù katô pittu abuk pan, asta marapung tô magdakál basket na igipánnù yu katô isamà. ");
INSERT INTO bgs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Asal isalábbuanna su ándà kó pa ikagpát na ánnà pan tô kóbadan katô igkagi ku géna. Kailangan banté kó katô pagpatubù ka pan katô mga Pariseo asta mga Saduseo.” ");
INSERT INTO bgs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na, ikagpát dan na ánnà pagpatubù ka pan tô bantéyan dan, asal kailangan bantéyan dan tô ágtinuruán katô mga Pariseo asta mga Saduseo. ");
INSERT INTO bgs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na, igsadun si Jesus madani tun ta lunsud ka Cesarea Filipos. Iginsà sikandin katô mga disipulu din, na mà din, “Ándin tô ágkagin ka mga manubù tingód kanak na Igpamanubù? Sadanna kun?” ");
INSERT INTO bgs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Igtaba sikandan, na mà dan, “Duwán mga manubù na ágkagi na sikuna si Juan na Tarabunyag. Duwán ássa mga manubù na ágkagi na sikuna si Elias. Duwán ássa ágkagi na sikuna si Jeremias ó sábbad propeta ka Manama sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iginsà si Jesus, na mà din, “Asal ándin é ákniyu panámdám tingód kanak? Sadanna?” ");
INSERT INTO bgs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Igtaba si Simon Pedro, na mà din, “Sikuna tô Mesiyas. Sikuna tô Batà katô manté Manama na ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Igkagi si Jesus, na mà din, “Simon, batà i Jonas, duwán dayó nu! Ánnà manubù tô igpasóddór áknikó na sakán tô Batà ka Manama, asal Ámmà ku tun ta langit tô igpasóddór kanan áknikó. ");
INSERT INTO bgs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Purisu kagin ku áknikó, sikuna si Pedro, asta ni gó tô batu na patindággan ku katô mga ágpampamaké. Dì dan talun ka katulusan ka kamatayan. ");
INSERT INTO bgs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bággén ku áknikó tô susì katô pagpangulu ka Manama. Tô dian nu dini ta banuwa, tô gó é dian katô Manama na góddô tun ta langit, asta tô nunugan nu dini ta banuwa, tô gó é nunugan katô Manama na góddô tun ta langit.” ");
INSERT INTO bgs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na, maggát igsapad si Jesus na kailangan dì dan mulit tun ta duma mga manubù na sikandin tô Mesiyas. ");
INSERT INTO bgs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tikud katô álló tô, igulit si Jesus tun ta mga disipulu din ka ándin tô matuman dumunggù tun kandin. Kailangan madun sikandin tun ta Jerusalem, asta pahirapan sikandin katô mga ágtugállán ka Judio, mallayat ka mga pangulu ka templo asta mga taratinurù ka sugù. Matuman sikandin matayan, asal manté puman sikandin tun ta ikatállu álló. ");
INSERT INTO bgs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na, igpadani si Pedro tun ki Jesus, asta igsapadan din, na mà din, “Áglangngagán, mólà pa ka dì malumu diyan áknikó! Dì pád gó matuman.” ");
INSERT INTO bgs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Asal igbariring si Jesus tun ki Pedro, asta igkagiyan din, na mà din, “Iwà ka, Maibuyan! su sumapad ka pád kanak. Ánnà tikud tun ta Manama tô kakalyag nu, asal tikud dád tun ta panámdám nu.” ");
INSERT INTO bgs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na, igkagi si Jesus katô mga disipulu din, na mà din, “Tô manubù na mákkás kanak, kailangan dì sikandin mákkás ka kakalyag ka pusung din, asal kailangan tumiis sikandin ka kahirapan agad matayan sikandin, asta kailangan mákkás kanak. ");
INSERT INTO bgs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tô manubù na áglággád katô kantayan din, kandaan sikandin katô kantayan na ándà ágtamanán. Asal ka mému ka matayan tô manubù tingód katô katákkás din kanak, matanggap din tô kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Atin ka makatigatun tô manubù kani tibuk banuwa, asal kandaan sikandin katô kantayan, ándà palang pulusán din, su ándà bullas katô kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sakán tô Igpamanubù, asta lumónódda dini na tákkássan katô mga panaligan asta séllaán katô Ámmà ku. Atin ka lumónódda, sumulì a katô langun manubù tingód katô iglumu dan. ");
INSERT INTO bgs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Paminág yu ni kagin ku ákniyu. Duwán dini ákniyu na dì maté sippang ka kumita dan katô katigkanayan ka pagpangulu ku na Igpamanubù.” ");
INSERT INTO bgs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na, pángnga ka ánnám álló, igpatákkás i Jesus si Pedro, si Santiago, asta si Juan na adi i Santiago. Igtikáddág dan tun ta mallayat pabungan na ándà palang manubù. ");
INSERT INTO bgs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Róggun igsállág dan ki Jesus, ipalin tô bónnóng din na iring na sánnang ka álló. Ágséllà ka kapputian tô langun katô umpak din. ");
INSERT INTO bgs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tigkô dan dád igkita si Moises asta si Elias na igtóngkô ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Igkagi si Pedro ki Jesus, na mà din, “Áglangngagán, madigár su dini ké. Atin ka mému áknikó, mimuwa dini ka tállu rákkó, sábbad para áknikó, sábbad para ki Moises, asta sábbad para ki Elias.” ");
INSERT INTO bgs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Róggun na igkagi si Pedro, tigkô dád duwán ágséllà sagulapun na ikatambun kandan. Igdinág dan tô kagi ka Manama tikud tun ta sagulapun, na mà din, “Ni gó ni kanak Batà na ágginawaan ku, asta tuuwa idayawan kandin. Paminág yu sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tô igdinág tô tállu disipulu, iglangkáb dan asta tuu dan imáddangan. ");
INSERT INTO bgs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Asal igpadani si Jesus tun kandan, igawidan din, asta igkagi sikandin, na mà din, “Tindág kó. Yakó ágkamáddangan.” ");
INSERT INTO bgs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tô iglangngag dan, igkita dan si Jesus na sábbad din dád man. ");
INSERT INTO bgs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na, róggun igtupang dan tikud tun ta pabungan, igkagi si Jesus tun kandan, na mà din, “Yakó gulit tingód katô igkita yu róggun ándà a pa kanté puman na Igpamanubù.” ");
INSERT INTO bgs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na, iginsà tô mga disipulu din, na mà dan, “Manan ka ágtinurù tô mga taratinurù ka sugù na kailangan lumónód si Elias tô dì pa dumunggù tô Mesiyas?” ");
INSERT INTO bgs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Igtaba si Jesus, na mà din, “Bánnal na dumunggù pa si Elias, su sikandin tô tumaganà katô langun. ");
INSERT INTO bgs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Asal mulitta ákniyu na igdunggù dán sikandin, asal ándà sikandin kilalayi ka mga manubù. Asal igtuman dan tô madat kakalyag dan kandin. Iring pagsik kanan, pahirapanna na Igpamanubù ukit ka lumun dan kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Purisu ikagpát tô mga disipulu din na si Juan na Tarabunyag tô igtuman katô tandô tingód katô kadunggù i Elias. ");
INSERT INTO bgs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tô igdunggù dan tun ta marapung manubù na igangat kandan, duwán sábbad mama na igpadani tun ki Jesus. Iglingkóód sikandin, asta igkagi, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Áglangngagán, kéduwi nu ni batà ku mama, su ágtuyù-tuyù sikandin, asta ágkahirapan. Marag sikandin ágkabantang tun ta apuy asta tun ta wayig. ");
INSERT INTO bgs_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Igpid ku sikandin tun ta mga disipulu nu ébô kólian sikandin, asal ándà dan ikému.” ");
INSERT INTO bgs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Igkagi si Jesus, na mà din, “Sikiyu mga manubù áknganni, dì kó ágsarig kanak, asta madat tô panámdám yu. Dì dán madugé na dumuma a ákniyu, asal kailangan tumiissa pa. Na, pid yu dini kanak tô batà.” ");
INSERT INTO bgs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na, igsapadan i Jesus tô madat espiritu, asta igluwà tikud tun ta batà. Tigkô inólian sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na, igpadani tô mga disipulu i Jesus tun kandin na ándà duma manubù, asta iginsà sikandan, na mà dan, “Manan ka ándà ké ikapaluwà katô madat espiritu?” ");
INSERT INTO bgs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Igkagi si Jesus, na mà din, “Su délák pa tô kasarig yu kanak. Paminág yu ni kagin ku ákniyu. Atin ka duwán kasarig yu kanak iring dád na délák lisu ka mustasa, makakagi kó tun ta pabungan, na mà yu, ‘Alin ka dutun.’ Purisu malin tô pabungan. Ándà palang na dì yu mému. ");
INSERT INTO bgs_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Asal paluwaán ni klasi ka madat espiritu ukit dád ka kadasal asta kapuwasa.” ");
INSERT INTO bgs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na, tô ilimud dán tô mga disipulu i Jesus tun ta probinsya ka Galilea, igkagi si Jesus, na mà din, “Matuman ni dumunggù kanak na Igpamanubù. Kailangan bággénna tun ta bállad katô duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Matayanna ikandan, asta mantéya puman tun ta ikatállu álló.” Purisu tuu dan iranu. ");
INSERT INTO bgs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tô igdunggù dan tun ta lunsud ka Capernaum, duwán mga taralimud ka buwis para katô templo. Iginsà dan ki Pedro, na mà dan, “Ágbayad tô pangulu yu ka buwis para katô templo?” ");
INSERT INTO bgs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Igtaba si Pedro, na mà din, “Óó.” Tô igulì dán si Pedro tun ta balé, tô ándà pa kagi sikandin, igkagi si Jesus ki Pedro, na mà din, “Simon, duwán insà ku áknikó. Sadan tô mga manubù na kailangan mayad ka buwis tun ta harì? Tô kandin pamilya, ó tô ássa mga manubù?” ");
INSERT INTO bgs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Igtaba si Pedro, na mà din, “Tô ássa mga manubù.” Igkagi si Jesus, na mà din, “Purisu dì ágbayad tô kandin pamilya. ");
INSERT INTO bgs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Asal ébô dì maringasa tô mga taralimud ka buwis áknita, sadun ka tun ta ranó, asta pamunuwit ka. Duwán salapì na kitanán nu tun ta babbà katô tagnà sáddà na maggut nu. Nángngà tô salapì para bággén ta tun ta templo. Angé nu, asta bággé nu tun ta mga taralimud ka buwis.” ");
INSERT INTO bgs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na, ándà kadugé, igpadani tô mga disipulu i Jesus tun kandin, asta iginsà sikandan, na mà dan, “Sadan tô mallayat é kamanubuan tun ta pagpangulu ka Manama?” ");
INSERT INTO bgs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Purisu igtawar i Jesus tô sábbad batà, asta igpatindág din tun ta tángngaan dan. ");
INSERT INTO bgs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Atin ka malyag kó sakupán katô Manama tun ta pagpangulu din, kailangan pamantun yu tô panámdám yu asta makéring kó na mga gabatà, ");
INSERT INTO bgs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","su tô manubù na ágpabbabà ka kamanubuan na iring katô kapabbabà kani batà, tô gó é tuu mallayat tun ta pagpangulu ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Atin ka ágtanggap kó katô sábbad batà tingód katô kapasakup yu kanak, iring na ágtanggapánna ikiyu.” ");
INSERT INTO bgs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Atin ka duwán makandà ka kapamaké katô agad sábbad kani mga marénták gabatà, tuu pa madigár ka ikáttán tô alig din tun ta dakál batu, asta antugán sikandin tun ta dagat. ");
INSERT INTO bgs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Makédu-édu tô mga manubù nit banuwa su duwán pakatintal! Ándà makalili katô pagtintal, asal makédu-édu tô manubù na mému gunayan ka pagtintal katô duma manubù! ");
INSERT INTO bgs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Atin ka tô bállad nu ó paa nu tô gunayan na makasalà ka, tampád nu asta antug nu, su tuu pa madigár agad sábbad dád tô bállad ó paa nu na duwán kantayan nu na ándà ágtamanán ka tandingán ka antugán tô tibuk lawa nu tun ta apuy na dì gó mapadáng ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Atin ka tô mata nu tô gunayan na makasalà ka, lássù nu asta antug nu, su tuu pa madigár agad mandà tô sábbad mata nu na duwán kantayan nu na ándà ágtamanán ka tandingán ka duwán duwa mata nu asta antugán tô tibuk lawa nu tun ta ágsupakanan ka apuy.” ");
INSERT INTO bgs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Yakó ágbuyas katô sábbad sakup ku na mabbabà é kamanubuan iring katô kapabbabà kani batà, su kagin ku ákniyu na ágbantéyan dan katô mga panaligan ka Manama na inalayun ágtubang katô Ámmà ku tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Igsadunna na Igpamanubù dini ta banuwa ébô tumábbussa katô mga manubù na itadin tingód ka mga salà dan. ");
INSERT INTO bgs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Panámdám yu ni. Tô manubù na duwán sábbad gatus (100) karnero din, atin ka sábbad tô matadin, tananan din tô kasiyawan siyó (99) tun ta pabungan ébô pamasakán din tô sábbad karnero na itadin. ");
INSERT INTO bgs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Paminág yu ni kagin ku ákniyu. Atin ka kitanán din dán, tuu pa dakál tô dayó din ka tandingán katô dayó din tingód katô kasiyawan siyó (99) na ándà katadin. ");
INSERT INTO bgs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iring kani tô riyun katô Ámmà ku tun ta langit, su dì gó mému kandin ka mandà tô sábbad sakup din.” ");
INSERT INTO bgs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na, atin ka duwán kataladi nu na makalumu ka salà tun áknikó, sadun ka tun kandin na ándà ássa manubù, asta sapadi nu sikandin tingód katô salà na iglumu din. Atin ka maminág sikandin katô kagi nu, mapalónód nu sikandin tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Atin ka dì sikandin maminág katô kagi nu, patákkás nu tô sábbad ó duwa manubù, asta lónód kó tun kandin, ébô duwán duwa ó tállu testigos na maminág katô tinóngkóan yu. ");
INSERT INTO bgs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Atin ka diyù gó sikandin maminág kandan, ulit yu tun ta mga ágpampamaké. Atin ka diyù gó sikandin maminág kandan, yakó ágtagad kandin, asal panámdám yu na iring sikandin na ánnà Judio asta iring na taralimud ka buwis.” ");
INSERT INTO bgs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na, paminág yu ni kagin ku ákniyu. Tô dian yu dini ta banuwa, tô gó é dian katô Manama na góddô tun ta langit, asta tô nunugan yu dini ta banuwa, tô gó é nunugan katô Manama na góddô tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Paminág yu ni kagin ku ákniyu. Atin ka duwán duwa manubù nit banuwa na pasábbadé tun ta kadasal, bággén katô Ámmà ku tun ta langit tô ágpamuyuán dan. ");
INSERT INTO bgs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Su agad ánda ágpalimudé tô duwa ó tállu manubù ébô mangadap kanak, dutunna duma kandan.” ");
INSERT INTO bgs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na, igpadani si Pedro tun ki Jesus, asta iginsà sikandin, na mà din, “Áglangngagán, atin duwán kataladi ku na marag áglumu ka salà kanak, makapira tô kapasinsiya ku kandin? Nángngà tô makapittu?” ");
INSERT INTO bgs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Igkagi si Jesus, na mà din, “Ánnà nángngà ka makapittu dád, su agad luppián din tô kapittuwan (70) ka makapittu, kailangan pasinsiyaan nu sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iring kani tô pagpangulu ka Manama. Duwán harì na igpanámdám na sumukut sikandin katô utang ka mga opisyales din. ");
INSERT INTO bgs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tô igtigkané sikandin, duwán sábbad opisyales na igpatawar din na tuu dakál tô utang din, su mga mararan tô salapì na utang din. ");
INSERT INTO bgs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Asal dì sikandin pakabayad. Purisu igkagi tô harì na kailangan imun sikandin na állang, apil tô sawa din asta tô mga gabatà din, asta barigyaán tô langun ka kaduwánnan dan ébô kabayadan tô utang din. ");
INSERT INTO bgs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Asal iglingkóód tô manubù, asta igpédu-édu, na mà din, ‘Sir, angat ka pa, su bayadan ku tô langun katô utang ku áknikó.’ ");
INSERT INTO bgs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Purisu igpandà katô harì tô utang katô manubù tingód katô kédu din, asta igpólì din. ");
INSERT INTO bgs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tô igpanó tô manubù, igkita din tun ta dalan tô ássa opisyales na duwán délák utang kandin. Tigkô din dád igpákkál tô alig katô manubù, asta igkagi sikandin, ‘Bayadi nud tô utang nu kanak.’ ");
INSERT INTO bgs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Purisu iglingkóód tô ássa opisyales, asta igpédu-édu, na mà din, ‘Angat ka pa, su bayadan ku tô langun katô utang ku áknikó.’ ");
INSERT INTO bgs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Asal ándà kédu din, asta igpapriso din sikandin sippang ka kabayadan tô utang din. ");
INSERT INTO bgs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na, tô ikasóddór tô mga ássa opisyales din, tuu iranu tô pusung dan. Purisu igsadun dan tun ta harì, asta igulit dan tingód katô langun na ilumu. ");
INSERT INTO bgs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Purisu igpakangé katô harì tô una opisyales, asta igkagi sikandin, ‘Madat ka manubù! Tô igpédu-édu ka kanak, igpandà ku tô langun ka utang nu. ");
INSERT INTO bgs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Su inéduwanna áknikó, kailangan médu-édu ka katô unawa nu na opisyales.’ ");
INSERT INTO bgs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tuu isókówan katô harì sikandin, asta igpapriso din ébô supakan sippang ka kabayadan tô langun katô utang din.” ");
INSERT INTO bgs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Igkagi si Jesus, “Atin ka dì kó ágpasinsiya katô kataladi yu tikud tun ta tibuk pusung yu, magunawa pagsik tô lumun katô Ámmà ku tun ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na, pángnga igtinurù si Jesus kani langun, igiwà sikandin tikud tun ta probinsya ka Galilea, asta igukit sikandin tun dipag ka Wayig ka Jordan sippang tun ta probinsya ka Judea. ");
INSERT INTO bgs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Marapung tô mga manubù na igtalundug kandin, asta igdappánnan din ka bállad tô langun na ágkabógókan, asta inólian. ");
INSERT INTO bgs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Duwán mga Pariseo na igpadani tun ki Jesus ébô kuminnam kandin. Iginsà sikandan, na mà dan, “Mému ka sumugban tô manubù katô sawa din agad ándà madat na iglumu din?” ");
INSERT INTO bgs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Igtaba si Jesus, na mà din, “Ándà yu basì basayi tô kagi ka Manama na igsulat. Tô igimu tô Manama katô manubù sayyan, igimu din sikandan na mama asta bayi. ");
INSERT INTO bgs_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Igkagi tô Manama, “‘Purisu tumanan tô mama katô ámmà din asta katô innà din, asta pasábbadé tô mama asta tô sawa din. Tô duwa dan mému dán sábbad.’ ");
INSERT INTO bgs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Purisu ánnà dan dán duwa, su inému dan dán sábbad. Na, su igimu dan ka Manama na sábbad, dì mému na pagsugbanán ka manubù.” ");
INSERT INTO bgs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iginsà sikandan, na mà dan, “Atin ka dì mému, manan ka igsugù si Moises sayyan na kailangan duwán papeles na bággén katô mama tun ta sawa din tingód katô kasugban din kandin, asta mému din péwaán?” ");
INSERT INTO bgs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Igkagi si Jesus, na mà din, “Igsugù si Moises na mému kó sumugban katô sawa yu, su isóddóran din na tuu matággas tô ulu yu. Asal tô igimu tô Manama katô manubù sayyan, dì mému pasugbané. ");
INSERT INTO bgs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Purisu kagiyan ku sikiyu, atin ka sumugban tô mama katô sawa din na ándà libug, asta kumalyag sikandin katô ássa bayi, makalibug sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Igkagi tô mga disipulu din, na mà dan, “Atin ka tô gó é malumu, tuu pa madigár ka dì dán kumalyag tô mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Asal igkagi si Jesus, na mà din, “Ánnà langun manubù tô dì gó kumalyag, asal makatiis dád tô mga manubù na ágtabangan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Duwán mga imanubù na dì kumalyag. Duwán mga duma na dì kumalyag su taganà ikapunan dan. Duwán mga duma na dì kumalyag su duwán lumun dan tingód katô pagpangulu ka Manama. Purisu tô makatanggap na dì dan kumalyag, dì dan gó kumalyag.” ");
INSERT INTO bgs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na, duwán mga manubù na igpid ka marénták mga gabatà dan tun ki Jesus ébô dappánnan din ka bállad asta dasalan din. Asal igsapadan dan katô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Igkagi si Jesus, na mà din, “Pabayà yu yan mga gabatà ébô makapadani dan dini kanak. Yakó ágsapad kandan, su tô mga manubù na ágsarig ka Manama iring katô kasarig ka mga gabatà tun ta ámmà asta innà dan, tô gó é panguluwan ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tô igdappán dán si Jesus ka bállad tun kandan asta igdasal, igpanó sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na, duwán sábbad manubù na igpadani tun ki Jesus, asta iginsà, na mà din, “Sir, ándin tô madigár lumun ku ébô makatanggappa ka kantayan na ándà ágtamanán?” ");
INSERT INTO bgs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Igkagi si Jesus, na mà din, “Isalábbuanna su iginsà ka kanak tingód katô madigár. Sábbad dád tô tuu madigár, tô dád Manama. Atin ka malyag ka tumanggap ka kantayan na ándà ágtamanán, kailangan mánnal ka katô mga sugù ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iginsà tô manubù, na mà din, “Ándin mga sugui?” Igkagi si Jesus, na mà din, “Yakó ágmaté. Yakó áglibug. Yakó ágtakó. Yakó ágtestigos ka bulaló tingód katô unawa yu. ");
INSERT INTO bgs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Respetowi yu tô ákniyu ámmà asta innà. Ginawayi yu tô unawa yu na iring katô kaginawa yu katô ákniyu sarili.” ");
INSERT INTO bgs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Igkagi tô manubù, na mà din, “Igbánnalla katô langun. Ándin tô ándà ku pa lumuwi?” ");
INSERT INTO bgs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Igkagi si Jesus, na mà din, “Atin duwán kakalyag nu na tuu nángngà tô áglumun nu, ulì ka, asta barigyà nu tô langun kaduwánnan nu. Tukid nu bággéyi tô salapì nu tun ta mga manubù na ágkayu-ayuan. Atin ka tô gó é lumun nu, duwán pulusán nu tun ta langit. Na, lónód ka, asta tákkás ka kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tô igdinág katô manubù tô igkagi i Jesus, igpanó sikandin na iranu, su dakál tô kaduwánnan din. ");
INSERT INTO bgs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na, igkagi si Jesus katô mga disipulu din, na mà din, “Paminág yu ni kagin ku ákniyu. Mahirap tô kapasakup ka ágkaduwánnan manubù tun ta pagpangulu katô Manama. ");
INSERT INTO bgs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kumagiya pagsik ákniyu na agad mahirap tô dakál mannanap na ágngadanan kamelyo na mukit tun ta bóbbó ka simat, asal tuu pa mahirap tô kapasakup katô ágkaduwánnan manubù tun ta pagpangulu ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tô igdinág katô mga disipulu tô igkagi din, tuu dan isalábbuan, asta igkagi sikandan, na mà dan, “Purisu ándà palang manubù na makaluwà tikud tun ta supak ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Asal igsállág si Jesus tun kandan asta igkagi sikandin, na mà din, “Dì gó ni malumu ka manubù, asal malumu ka Manama tô langun.” ");
INSERT INTO bgs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Igkagi si Pedro, na mà din, “Sikami, igtananan déd tô langun katô kaduwánnan dé ébô mákkás ké áknikó. Ándin tô matanggap dé?” ");
INSERT INTO bgs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Tun ta mantu banuwa na imun ka Manama, munsadda na Igpamanubù tun ta madigár gunsadanan ku. Sikiyu na igtákkás kanak, munsad kó pagsik tun ta sapulù duwa (12) gunsadanan ka harì, asta mangulu kó katô sapulù duwa (12) grupo katô mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tô manubù na igtanan katô kaduwánnan din, mga kataladi din, ámmà din, innà din, mga gabatà din, asta kinamát din ébô pasakup kanak, tô gó tô makatanggap ka kadigárran na ginatus-gatus na dakál pa ka tandingán katô igtananan din, asta bággayan sikandin katô kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Marapung tô mga manubù na ikóna áknganni makatapuri baling tun ta tapuri álló. Tô mga manubù na ikatapuri áknganni makóna baling tun ta tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iring kani tô pagpangulu ka Manama. Duwán sábbad manubù na duwán tanà na igpamulaan din ka paras. Igsállám tô tigatun igpamasak ka mga manubù na lumumu tun ta kinamát din. ");
INSERT INTO bgs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Igpasábbadé dan na bággén din kandan tô sábbad salapì denario, su ni tô nángngà tandan ka sábbad álló. Igpapid din sikandan tun ta kinamát, asta iglumu dan. ");
INSERT INTO bgs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tô alas nuybe dán, igpamasak puman sikandin ka mga manubù na lumumu. Duwán mga manubù na igkita din tun ta plasa na ánda áglumun dan. ");
INSERT INTO bgs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Purisu igkagi sikandin, ‘Atin ka lumumu kó tun ta kinamát ku, nángngà tô tandan ku ákniyu.’ Purisu igsadun dan pagsik, asta iglumu dan. ");
INSERT INTO bgs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Igpamasak puman sikandin ka mga manubù tô alas dusi asta tô alas tres ka mapun, asta magunawa tô igkagi din kandan. ");
INSERT INTO bgs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Masig dán alas singko ka mapun, igkita din tô duma mga manubù na ánda áglumun dan. Iginsà sikandin, ‘Manan ka ándà palang áglumun yu ni álló ni?’ ");
INSERT INTO bgs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Igtaba dan, ‘Su ándà manubù na igpalumu áknami.’ Igkagi sikandin, ‘Lumu kó pagsik tun ta kinamát ku.’ ");
INSERT INTO bgs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Na, tô igsalláp dán tô álló, igkagi tô tigatun tun ta állang na ágsarigan din, ‘Tawar nu tô langun manubù na iglumu, asta bággé nu kandan tô tandan. Una nu tô mga manubù na tapuri iglumu, asta yan pa tô mga manubù na una iglumu.’ ");
INSERT INTO bgs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tô igtandan sikandin katô mga manubù na igtigkané ka alas singko ka mapun, sábbad denario tô salapì na igtandan din tingód ka sábbad álló tun ta tagsábbad-sábbad kandan. ");
INSERT INTO bgs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Purisu tô ándà pa tandani tô mga manubù na iglumu tikud ka sállám, igpanámdám dan na tuu pa dakál tô tandanán din kandan. Asal sábbad pagsik denario tô salapì na igtandan din tingód ka sábbad álló tun ta tagsábbad-sábbad kandan. ");
INSERT INTO bgs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tô igtanggap dan katô salapì, igpaburáng-burángngé dan tingód katô tigatun ka paras. ");
INSERT INTO bgs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Igkagi dan, ‘Tô mga ikatapuri, sábbad dád oras tô kalumu dan, asal tikud ka sállám tô áknami kalumu, asta inélad ké ka álló. Manan ka magunawa tô igtandan nu áknami langun?’ ");
INSERT INTO bgs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Igkagi tô tigatun tun ta sábbad kandan, ‘Rarak ku, ándà a limbung áknikó, su sábbad denario tô salapì na ignunugan nu na tandan ku áknikó. ");
INSERT INTO bgs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Purisu pid nu tô salapì na igtandan ku áknikó, asta ulì kad. Kakalyag ku na magunawa tô bággén ku tun ta langun yu. ");
INSERT INTO bgs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Atin ka malyagga mággé ka salapì ku tun ta manubù na salinán ku, ándà basì makasapad kanak. Isabuan ka basì su madigár tô iglumu ku kandan.’” ");
INSERT INTO bgs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Igkagi si Jesus, na mà din, “Purisu tô mga manubù na ikatapuri áknganni makóna baling tun ta tapuri álló. Tô mga manubù na ikóna áknganni makatapuri baling tun ta tapuri álló.” ");
INSERT INTO bgs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na, róggun igpanó si Jesus tun ta Jerusalem, igpid din tô sapulù duwa (12) disipulu din tun ta ándà mga manubù, asta igkagi sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Na, madun kid tun ta Jerusalem. Sakán na Igpamanubù tô bággén tun ta bállad katô mallayat ka mga pangulu ka templo asta mga taratinurù ka sugù. Pasábbadé dan kumagi na kailangan matayanna. ");
INSERT INTO bgs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bággénna ikandan tun ta bállad ka mga manubù na ánnà Judio. Ngisiyanna ikandan, lagpássánna, asta pansalanna tun ta krus. Asal mantéya puman tun ta ikatállu álló.” ");
INSERT INTO bgs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na, igsadun tun ki Jesus tô sawa i Sebedeo asta tô duwa gabatà din na si Santiago asta si Juan. Iglingkóód sikandin tun ki Jesus su duwán ágpamuyuán din. ");
INSERT INTO bgs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iginsà si Jesus, na mà din, “Ándin tô kakalyag nu kanak?” Igkagi sikandin, na mà din, “Tun ta pagpangulu nu, pónsad nu tô duwa gabatà ku madani tun áknikó, na sábbad dadan ta kawanan nu, asta sábbad dadan ta ibang nu.” ");
INSERT INTO bgs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Asal igkagi si Jesus, na mà din, “Ándà yu kasóddóri ka ándin tô igpamuyù yu. Makatiis kó katô kahirapan iring katô kahirapan na masig dán dumunggù kanak?” Igtaba sikandan, na mà dan, “Óó, makatiis ké.” ");
INSERT INTO bgs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Igkagi si Jesus, na mà din, “Matuman na dungguan kó gó katô kahirapan iring katô kahirapan na dumunggù kanak, asal diya makatandô ákniyu ka makónsad kó madani tun kanak, su munsad madani kanak tô mga manubù na igsalin katô Ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na, tô igdinág tô sapulù (10) disipulu ka ándin tô igkagi dan ki Jesus, isókó dan ki Santiago asta ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Purisu igpaglimud i Jesus tô langun dan, asta igkagi sikandin, na mà din, “Isóddóran yud na tun ta mga manubù na ánnà Judio, inalayun ágsugù tô mga ágpangulun katô mga sakup dan. Inalayun ágsugù-sugù tô mallayat mga manubù katô mga ágpanguluwan dan. ");
INSERT INTO bgs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Asal dì mému ka makéring kó kandan. Su tô manubù tun ákniyu na imun mallayat é kamanubuan, tô gó tô kailangan imun na ágsuguánnán yu. ");
INSERT INTO bgs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Asta tô manubù na imun pangulu yu, tô gó tô kailangan mému na állang yu. ");
INSERT INTO bgs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Méring sikandin kanak na Igpamanubù, su igsadunna dini ánnà ébô tabanganna katô mga manubù, asal igsadunna dini ébô tumabangnga katô mga manubù. Ikataganà ad na matayan ébô tábbusán ku tô marapung manubù.” ");
INSERT INTO bgs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na, tô igpanó dan tikud tun ta Jerico, tuu marapung tô mga manubù na igtalundug ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Duwán duwa bólóg na igunsad tun ta ligad ka dalan. Tô igdinág dan na si Jesus tô iglabé, igullaó sikandan, na mà dan, “Rubbad i David, kéduwi ké!” ");
INSERT INTO bgs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Igsapadan dan katô mga manubù, asta igkagi dan na kailangan dì dan mótép. Asal igrayan dan baling gullaó, na mà dan, “Áglangngagán, rubbad i David, kéduwi ké!” ");
INSERT INTO bgs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Purisu igsódô si Jesus, asta igtawar kandan, na mà din, “Ándin tô kakalyag yu na lumun ku para ákniyu?” ");
INSERT INTO bgs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Igtaba tô duwa bólóg, na mà dan, “Áglangngagán, malyag ké makakita.” ");
INSERT INTO bgs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Inéduwan si Jesus kandan, asta igdappánnan din ka bállad tô mata dan. Tigkô dan dád ikakita, asta igtalundug dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na, tô igsadun dan tun ta Jerusalem, igdunggù dan tun ta lunsud ka Betpahe na tun ta Pabungan ka Olibo. Igpóna i Jesus tô duwa disipulu din, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Una kó tun ta lunsud, asta kitanán yu tô asno asta nati. Igikát tô asno, asal akas yu, asta pid yu dini kanak. ");
INSERT INTO bgs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Atin ka duwán manubù na minsà ákniyu ka manan ka igakas yu, kagiyi yu na kailangan sakayan katô Áglangngagán yu, asta sékót din papiddán ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ilumu ni ébô matuman ni igkagi katô propeta ka Manama sayyan, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Uliti nu tô langun taga Sion, ‘Na, dumunggù dán tô harì yu, asta mabbabà tô kamanubuan din, su ágsaké ka nati ka asno.’” ");
INSERT INTO bgs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Igpanó tô duwa disipulu din, asta igtuman dan tô igsugù i Jesus kandan. ");
INSERT INTO bgs_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Igpid dan tô asno asta tô nati tun ki Jesus. Tô mga umpak dan igampas dan tun ta bókkóg katô nati, asta igsaké si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Igsánnar katô karapungan ka mga manubù tô umpak dan tun ta dalan na ukitan din. Igtampád katô mga manubù tô mga daun ka palmera asta igsánnar dan tun ta dalan. ");
INSERT INTO bgs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Igullaó tô langun manubù na igtákkás ki Jesus, agad tô ikóna asta tô ikatalundug, na mà dan, “Durungán ta ni rubbad i David! Durungán ta ni igpapid katô Áglangngagán! Durungán ta tô Manama tun ta langit!” ");
INSERT INTO bgs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tô igdunggù si Jesus tun ta Jerusalem, isalábbuan tô langun manubù. Igpénsaé sikandan, na mà dan, “Sadan sikandin?” ");
INSERT INTO bgs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Igtaba tô mga manubù na igtákkás ki Jesus, na mà dan, “Sikandin si Jesus na propeta ka Manama tikud tun ta lunsud ka Nazaret na sakup ka probinsya ka Galilea.” ");
INSERT INTO bgs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na, igsadun si Jesus tun ta templo, asta igabug din tô langun manubù na ágbálli asta ágbarigyà tun ta plasa ka templo. Igbantang din tô mga lamisa katô mga manubù na ágbullas ka salapì, asta igbantang din tô gunsadanan katô mga manubù na ágbarigyà ka salapati na ágbággén tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Igkagi sikandin, na mà din, “Mà katô kagi ka Manama, “‘Tô balé ku, tô gó é ágdasalanan.’ Asal igimu yud ni na gállássanan ka mga tulisan.” ");
INSERT INTO bgs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Igpadani tun ki Jesus tô mga bólóg asta tô mga kapig, asta igdappánnan dan i Jesus ka bállad, asta inólian dan tun ta templo. ");
INSERT INTO bgs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Asal isókó tô mallayat ka mga pangulu ka templo asta tô mga taratinurù ka sugù, su igkita dan tô mga kasalábbuan na iglumu i Jesus, asta igdinág dan tô mga gabatà na igpanggullaó tun ta templo, na mà dan, “Durungán ni rubbad i David!” ");
INSERT INTO bgs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Purisu iginsà dan ki Jesus, na mà dan, “Igpaminág nu tô kagi dan?” Igtaba si Jesus, na mà din, “Óó. Ándà yu basì basayi ni kagi ka Manama, na mà din, “‘Agad tô mga marénták gabatà igtinuruan nu ébô dumurung áknikó.’” ");
INSERT INTO bgs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na, igpanó si Jesus tikud tun kandan, igsadun sikandin tun ta lunsud ka Betania, asta igdággà sikandin dutun. ");
INSERT INTO bgs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tô sállám dán, róggun iglónód si Jesus tun ta Jerusalem, igballus sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Igkita din tô kayu igera tun ta ligad ka dalan, asta igpadani sikandin ébô mamasak ka buuy. Asal ándà palang buuy na igkita din, su marag dád daun. Purisu igkagi sikandin tun ta kayu, na mà din, “Tikud áknganni, dì dán gó makabuuy ni kayu ni!” Tô dád gó, igangu tô kayu. ");
INSERT INTO bgs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tô ikakita tô mga disipulu din, isalábbuan dan gó, asta igkagi sikandan, na mà dan, “Sékót igangu tô kayu igera.” ");
INSERT INTO bgs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Atin ka sumarig kó katô Manama, asta dì kó ágduwa-duwa, makému kó katô mga kasalábbuan iring katô iglumu ku kani kayu igera, asta mga kasalábbuan na tuu pa matulus. Atin ka kumagi kó kani pabungan na malin tun ta dagat, mému ni. ");
INSERT INTO bgs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Agad ándin tô pamuyuán yu katô Manama ukit ka kadasal, matanggap yu ka mánnal kó kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na, igsadun si Jesus tun ta templo, asta igtinurù sikandin. Ándà kadugé, duwán mallayat ka mga pangulu ka templo asta mga ágtugállán ka Judio na igpadani tun kandin. Iginsà sikandan, na mà dan, “Sadan tô igtikudan katô langun na áglumun nu? Sadan tô igpapid áknikó?” ");
INSERT INTO bgs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Igtaba si Jesus, na mà din, “Duwán pagsik insà ku ákniyu. Atin ka makataba kó, mulitta ákniyu ka sadan tô igpapid kanak. ");
INSERT INTO bgs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, sadan tô igpapid ki Juan na munyag? Tô Manama, ó tô manubù?” Purisu igpatóngkóé dan ka ándin tô madigár taba dan kandin, na mà dan, “Atin ka tumaba ki na Manama tô igpapid ki Juan, insaán ki ikandin na manan ka ándà ki bánnal ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Asal atin ka tumaba ki na manubù tô igpapid ki Juan, kamáddangan ki kani mga manubù na ilimud, su ágpanámdám dan na bánnal propeta ka Manama si Juan.” ");
INSERT INTO bgs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Purisu igtaba sikandan ki Jesus, na mà dan, “Ándà dé kasóddóri.” Igkagi si Jesus, na mà din, “Su ándà kó taba katô insà ku, diya pagsik mulit ákniyu ka sadan tô igpapid kanak na lumumuwa katô áglumun ku.” ");
INSERT INTO bgs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Panámdám yu ni. Duwán manubù na duwán duwa gabatà din gamama. Igkagi sikandin tun ta batà din kaké, ‘Batà, lumu ka tun ta kinamát ni álló ni.’ ");
INSERT INTO bgs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Igkagi tô batà din, ‘Diya.’ Asal ándà kadugé, ipalin tô panámdám din, asta igsadun sikandin tun ta kinamát asta iglumu. ");
INSERT INTO bgs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Igsadun pagsik tô ámmà tun ta batà din adi, asta magunawa tô igkagi din kandin. Igkagi tô adi, ‘Óó, ámmà. Madunna.’ Asal ándà sikandin sadun. ");
INSERT INTO bgs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na, ulitiya ikiyu. Sadan batai tô igbánnal katô ámmà din?” Igtaba sikandan, na mà dan, “Tô batà din kaké.” Igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Duwán masalà-salà mga manubù na makóna ákniyu masakup tun ta pagpangulu ka Manama iring katô mga taralimud ka buwis asta madat mga gabayi. ");
INSERT INTO bgs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tô igtinurù si Juan na kailangan rumákkád kó katô salà ébô tanggapán kó ka Manama, ándà kó bánnal kandin. Asal marapung baling tô mga taralimud ka buwis asta madat mga gabayi na igbánnal kandin. Agad igkita yu ni, asal ándà kó rákkád, asta ándà kó bánnal kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Igkagi si Jesus kandan, na mà din, “Paminág yu ni panunggiringan. Duwán sábbad manubù na duwán tanà na igpamulaan din ka paras. Igkoralan din ni, asta igimu din tô garikanan ka buuy ka paras. Igpatindág din tô balé na ágtómmónganan. Igpadóppónan din tô kinamát katô ássa mga taralumu ka tanà, asta igsadun sikandin tun ta madiyù banuwa. ");
INSERT INTO bgs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tô igdunggù tô timpo na matássan dán tô buuy katô paras, duwán mga állang na igpapid katô tigatun ébô mangé katô buuy na kandin bahin. ");
INSERT INTO bgs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tô igdunggù dán tô mga állang din tun ta kinamát, duwán iglagpás katô mga taradóppón, duwán igmatayan dan, asta duwán igtimbag dan ka batu. ");
INSERT INTO bgs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Marapung pa puman tô ássa mga állang na igpapid din tun kandan. Asal magunawa tô madat na iglumu katô mga taradóppón tun kandan. ");
INSERT INTO bgs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Purisu igpapid din tô batà din, su tô panámdám din na bánnalán dan tô kandin batà. ");
INSERT INTO bgs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tô igkita tô mga taradóppón katô batà din, igpatóngkóé dan, na mà dan, ‘Ni gó tô makatigatun kani tanà ka maté tô ámmà din. Na, matayan ta sikandin ébô sikita tô makatigatun kani tanà.’ ");
INSERT INTO bgs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Purisu igámmát dan sikandin, igguyud dan tun ta luwà katô kinamát, asta igmatayan dan. ");
INSERT INTO bgs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na, ulitiya ikiyu. Atin lumónód tô tigatun katô kinamát, ándin tô lumun din tun ta mga manubù na igpadóppón din?” ");
INSERT INTO bgs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Igtaba sikandan, na mà dan, “Ándà kédu din katô madat mga manubù, asal matayan din sikandan, asta padóppónan din katô ássa mga manubù na mággé ka bahin tun kandin ámmé-ámmé.” ");
INSERT INTO bgs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Igkagi si Jesus, na mà din, “Iring na ándà kó gó basa kani kagi ka Manama, na mà din, “‘Duwán sábbad batu na igantug katô mga gimu ka balé, su kéman dan ka ánda ágpulusán. Asal ándà dan kasóddóri na tô gó tô batu na tuu ágkailanganán katô balé. Madigár ni iglumu katô Áglangngagán, asta durungán ta sikandin.’” ");
INSERT INTO bgs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Igkagi si Jesus, na mà din, “Purisu kagin ku ákniyu, dì kó sakupán ka Manama tun ta pagpangulu din, asal sakupán din tô ássa mga manubù na mánnal katô kakalyag din. ");
INSERT INTO bgs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Atin ka madabù tô manubù nit batu ni, katáppù-táppuan sikandin. Asal ka kadabuan tô manubù katô batu, maróddóg sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na, tô igdinág tô mallayat ka mga pangulu ka templo asta tô mga Pariseo katô kagi i Jesus, isóddóran dan na sikandan tô isugatan katô panunggiringan na igulit din. ");
INSERT INTO bgs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Purisu kakalyag dan dán gó na ámmáttán si Jesus. Asal ándà dan ikému, su imáddangan dan katô mga manubù na ágpaminág ki Jesus, su ágbánnal tô mga manubù na propeta ka Manama si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Igtinurù puman si Jesus kandan ukit kani panunggiringan, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Iring kani tô pagpangulu ka Manama. Duwán sábbad harì na igimu ka dakál kalimudan su kasalán tô batà din mama. ");
INSERT INTO bgs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Igsugù din tô mga állang din ébô ulitan tô langun manubù na ágpasakupán din. Asal igéllé tô langun. ");
INSERT INTO bgs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Purisu igsugù katô harì tô ássa mga állang din ébô ulitan tô mga ágpasakupán din, ‘Na, igtaganà dán tô langun. Igiyó dán tô mga baka asta tô mga igpalambù nati, asta igtaganà dán tô ágkannán. Sadun kód dini ta ágkasalan.’ ");
INSERT INTO bgs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Asal ándà dan bánnal. Tô sábbad igsadun tun ta kandin kinamát, asta duwán igsadun tun ta kandin tindaan. ");
INSERT INTO bgs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Duwán mga manubù na igámmát, igirrayat asta igmaté katô mga állang din. ");
INSERT INTO bgs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Purisu tuu isókó tô harì, asta igpapid din tô mga sundalo din ébô matayan sikandan asta góbbón tô lunsud dan. ");
INSERT INTO bgs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na, igkagi tô harì tun ta mga állang din, ‘Igtaganà dán tô ágkannán, asal dì ku gó pakannán tô mga manubù na tagnà igkagiyan ku. ");
INSERT INTO bgs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Purisu sadun kó tun ta mga dalan na marapung gukit, asta piddán yu tô langun manubù na kasumaran yu.’ ");
INSERT INTO bgs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Purisu igsadun tô mga állang din tun ta mga dalan, asta igpatákkás dan tô langun manubù na igsumar dan, agad madigár ó madat. Purisu ipánnù tô ágkasalan su marapung tô mga manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Na, ándà kadugé, igahu tô harì ébô tanggapán din tô mga manubù na ilimud tun ta ágkasalan. Igkita din tô sábbad manubù na ándà umpak iring katô gumpakán ka mga manubù na madun tun ta ágkasalan. ");
INSERT INTO bgs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Purisu iginsà tô harì kandin, ‘Rarak, manan ka dini ka na ándà umpak nu iring katô gumpakán ka mga manubù na madun tun ta ágkasalan?’ Asal ándà palang igtaba din. ");
INSERT INTO bgs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Purisu igkagi tô harì tun ta mga állang din, ‘Bagkás yu tô bállad din asta tô paa din, asta antug yu sikandin tun ta luwà tun ta kangittángngan ébô supakan. Tuu sumággó tô mga manubù dutun, asta kumurigát tô ngipán dan tingód katô kasakit dan.’” ");
INSERT INTO bgs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na, igkagi si Jesus, na mà din, “Tuu marapung tô mga manubù na ágtawarán ka Manama, asal tagsábbadé dád tô masakup.” ");
INSERT INTO bgs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na, igpalimudé tô mga Pariseo, asta igplano dan ka ándin tô insaán dan ki Jesus ébô duwán madimanda dan ukit katô taba din. ");
INSERT INTO bgs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Purisu duwán mga disipulu dan asta mga igpasakup tun ki Herodes na igpapid dan tun ki Jesus. Igkagi dan kandin, na mà dan, “Sir, isóddóran dé na ágkasarigan ka, asta ágtinurù ka katô kabánnalan tingód ka kakalyag ka Manama. Dì ka ágkapid ka panámdám ka mga manubù agad ándin tô bónnóng dan. ");
INSERT INTO bgs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Purisu uliti ké ka ándin tô panámdám nu. Atin ka mayad ké ka buwis tun ta emperador ka Roma, lumapas ké ka mga sugù ka Manama? Mému bayadan, ó dì mému?” ");
INSERT INTO bgs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Asal isóddóran i Jesus na madat tô kakalyag dan kandin. Purisu igkagi sikandin, na mà din, “Kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Manan ka kuminnam kó kanak? ");
INSERT INTO bgs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakita yu kanak tô salapì na bayad yu katô buwis.” Igpakita dan kandin tô salapì. ");
INSERT INTO bgs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iginsà si Jesus, na mà din, “Sadan bónnóng asta ngadan tô igtagù nit salapì?” ");
INSERT INTO bgs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Igtaba sikandan, na mà dan, “Tô emperador ka Roma.” Igkagi si Jesus, na mà din, “Purisu bággé yu tun ta emperador tô nángngà bággén yu tun ta emperador, asta bággé yu tun ta Manama tô nángngà bággén yu tun ta Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tô igdinág dan katô kagi din, isalábbuan dan, asta igpanó dan tikud tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ándà kadugé, duwán mga Saduseo na igpadani tun ki Jesus. Tô gó tô mga manubù na ágtinurù na dì manté puman tô mga manubù na inaté dán. Iginsà dan ki Jesus, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sir, igsugù si Moises áknita tingód katô lumun katô mga mataladi gamama. Atin ka maté tô mama na ándà pa batà katô sawa din, tô kataladi din kailangan kumalyag katô sawa katô inaté, na ipag din na ibalu, ébô ukit kandin duwán mému batà para katô kataladi din na inaté. ");
INSERT INTO bgs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, duwán pittu mataladi gamama sayyan. Igkalyag tô kaké dan, asal inaté sikandin na ándà pa batà din. Purisu tô ikaduwa kataladi igkalyag katô bayi, ");
INSERT INTO bgs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","asal magunawa tô inému tun kandin asta tun ta ikatállu sippang tun ta ikapittu. Tô tagsábbad-sábbad katô pittu mataladi na igkalyag katô bayi, inaté dan langun na ándà palang batà dan. ");
INSERT INTO bgs_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tun ta katapuriyan, inaté tô bayi. ");
INSERT INTO bgs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, ulit nu áknami. Atin ka manté puman tô mga manubù, sadan tun ta pittu mataladi tô bánnal duma katô bayi? Su igkalyag tô langun dan kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Igtaba si Jesus, na mà din, “Duwán sayup yu, su ándà yu kagpátti tô kagi ka Manama na igsulat, asta ándà yu kasóddóri ka ándin tô lumun ka Manama ukit katô katulusan din. ");
INSERT INTO bgs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tun ta kanté puman ka Manama katô mga manubù, dì dan dán pakalyagé, su iring dan dán katô mga panaligan ka Manama tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tingód katô kanté ka Manama ka mga manubù, iring na ándà kó gó basa kani kagi ka Manama ákniyu, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“‘Sakán tô Manama na ágpangadapán i Abraham, i Isaac, asta i Jacob.’ Dì ágpangadap ka Manama tô mga manubù na ándà kantayan, asal tô mga manubù na duwán kantayan, tô gó tô ágpangadap ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tô igdinág tô ilimud mga manubù kani igtinurù din, tuu isalábbuan tô langun dan. ");
INSERT INTO bgs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na, tô igdinág tô mga Pariseo na ándà ikataba tô mga Saduseo ki Jesus, igpalimudé dan puman asta igpadani dan tun ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Duwán sábbad tun kandan na katig ágtinurù katô mga sugù. Kakalyag din na kuminnam sikandin minsà ki Jesus. Purisu iginsà sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Sir, tun ta langun sugù ka Manama ukit ki Moises, ándin sugui tô tuu ágkailanganán?” ");
INSERT INTO bgs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Igkagi si Jesus, na mà din, “‘Ginawayi yu tô Áglangngagán na Manama yu tikud tun ta tibuk pusung yu, tikud tun ta tibuk kantayan yu, asta tikud tun ta tibuk panámdám yu.’ ");
INSERT INTO bgs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tô gó tô sugù na tuu ágkailanganán katô langun. ");
INSERT INTO bgs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na, ni gó tô sugù na ikatalundug katô tagnà. ‘Ginawayi yu tô unawa yu na iring katô kaginawa yu katô ákniyu sarili.’ ");
INSERT INTO bgs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Atin ka ágbánnalán yu ni duwa sugù ni, ágbánnalán yu tô langun sugù ka Manama asta mga kagi ka propeta ka Manama na igsulat sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tô ándà pa panó tô mga Pariseo, iginsà si Jesus kandan, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ándin tô panámdám yu tingód katô Mesiyas? Sadan tô kamónaan din?” Igtaba sikandan, na mà dan, “Rubbad i David tô Mesiyas.” ");
INSERT INTO bgs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Igkagi si Jesus, na mà din, “Atin ka bánnal yan, manan ka igpakagi katô Ugis Espiritu si David na ágtawarán din na Áglangngagán din tô Mesiyas? Igsulat i David ni kagi ni, ");
INSERT INTO bgs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Igkagi tô Manama tun ta Áglangngagán ku: Unsad ka kannun ta kawanan ku sippang ka manaluwa katô mga usig nu, asta pabánnalán ku sikandan áknikó.’ ");
INSERT INTO bgs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Purisu su si David tô igkagi na Áglangngagán din tô Mesiyas, pamánnun na tô Mesiyas tô rubbad i David?” ");
INSERT INTO bgs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Asal ándà palang manubù na ikataba ki Jesus. Tikud katô álló tô, ándà palang manubù na igkinnam iginsà kandin. ");
INSERT INTO bgs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na, igtinurù si Jesus katô mga ilimud manubù asta mga disipulu din. Igkagi sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tô mga taratinurù ka sugù asta tô mga Pariseo, sikandan tô igsarigan na pénagpát katô mga sugù ka Manama ukit ki Moises. ");
INSERT INTO bgs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Purisu kailangan mánnal kó katô langun gulit-ulitán dan. Asal yakó giring katô áglumun dan, su dì dan ágbánnal katô mga sugù na gulit-ulitán dan. ");
INSERT INTO bgs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iring dan katô mga manubù na ágpirit ka duma manubù na tumiang katô tuu mabággat asta mahirap ágpiddán, asal ándà palang tabang dan kandan. ");
INSERT INTO bgs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ágpadadurungán dan tô langun ka áglumun dan. Gimun dan tuu dakál tô ágtaguanan ka kagi ka Manama na ágpiddán dan, asta ágpallayatán dan tô ugpu katô umpak dan. ");
INSERT INTO bgs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Malyag dan munsad tun ta lugar na igpantaganà katô mga manubù na mallayat é kamanubuan tun ta dakál kalimudan, asta tun ta madigár gunsadanan tun ta mga simbaan ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Malyag dan respetowan katô duma mga manubù tun ta plasa, asta tawarán dan na rabbi. ");
INSERT INTO bgs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Asal dì mému ka tawarán kó na rabbi, su sábbad dád tô Taratinurù yu, asta mataladi kó langun. ");
INSERT INTO bgs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dì mému ka pabantugán yu tô duma mga manubù nit banuwa ukit katô katawar yu kandan na ámmà, su sábbad dád gó tô Ámmà yu na Manama tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dì pagsik mému ka tawarán kó amo, su sábbad dád tô Amo yu na Mesiyas. ");
INSERT INTO bgs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tô manubù tun ákniyu na mallayat é kamanubuan, tô gó tô kailangan imun iring na ágsuguánnán yu. ");
INSERT INTO bgs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Atin ka ágpallayat tô manubù ka kamanubuan din, imun sikandin na mabbabà. Atin ka ágpabbabà tô manubù ka kamanubuan din, imun sikandin na mallayat.” ");
INSERT INTO bgs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Sikiyu mga Pariseo asta mga taratinurù ka sugù, kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Makédu-édu kó! su ágdalangan yu tô mga manubù na pasakup tun ta pagpangulu ka Manama. Madat su ándà kó pasakup tun kandin, asal tuu pa madat su ágdalangan yu tô mga manubù na pasakup. ");
INSERT INTO bgs_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Sikiyu mga Pariseo asta mga taratinurù ka sugù, kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Makédu-édu kó su gagó kó ka kaduwánnan katô mga gabayi balu. Ágtambunan yu tô madat linumuwan yu ukit katô mallayat mga kadasal. Purisu tuu madat tô supak na padungguán ka Manama ákniyu. ");
INSERT INTO bgs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Sikiyu mga Pariseo asta mga taratinurù ka sugù, kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Makédu-édu kó su ágtalap-talap kó tun ta madiyù ébô sakupán yu tô sábbad dád manubù, asta ukit ka katinurù yu kandin, duwa luppì tô kadattan din ka tandingán ákniyu na makapid kandin tun ta ágsupakanan! ");
INSERT INTO bgs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Makédu-édu kó, su iring kó na bólóg na gagak ka duma manubù. Ágkagi kó na atin ka tumandô tô manubù ukit dád kani templo, mému ka dì din tumanán tô tandô. Asal ágkagi kó pagsik, atin ka tumandô tô manubù ukit katô bulawan na igpadákkát kani templo, kailangan tumanán din gó tô tandô. ");
INSERT INTO bgs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Iring kó na bólóg! Ánnà nángngà tô panámdám yu. Tuu pa ugis tô templo ka tandingán katô bulawan na igpadákkát kani templo, su ágkému ugis tô bulawan tingód katô kógisan kani templo. ");
INSERT INTO bgs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ágkagi kó na atin ka tumandô tô manubù ukit katô ággóbbówanan ka mannanap tun ta saruwan ka Manama, mému ka dì din tumanán tô tandô. Asal ágkagi kó pagsik na atin ka tumandô tô manubù ukit ka mannanap na góbbón tun ta saruwan ka Manama, kailangan tumanán din gó tô tandô. ");
INSERT INTO bgs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Iring kó na bólóg! Tuu pa ugis tô ággóbbówanan ka tandingán katô mga mannanap na ággóbbón dutun, su ágkému ugis tô mannanap na ággóbbón tun ta saruwan ka Manama tingód katô kógisan katô ággóbbówanan. ");
INSERT INTO bgs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Purisu atin ka tumandô tô manubù ukit katô ággóbbówanan, tumandô sikandin ukit katô mannanap na ággóbbón dutun. ");
INSERT INTO bgs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Atin ka tumandô tô manubù ukit katô templo, tumandô sikandin ukit katô Manama na góddô tun ta templo. ");
INSERT INTO bgs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Atin ka tumandô tô manubù ukit katô langit, tumandô sikandin ukit katô Manama asta katô gunsadanan din. ");
INSERT INTO bgs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Sikiyu mga Pariseo asta mga taratinurù ka sugù, kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Makédu-édu kó su agad ágbággén yu tun ta Manama tô ikasapulù katô langun pamulanán yu agad mga anag, asal ándà yu bánnali tô mga sugù ka Manama na tuu ágkailanganán, tô tingód katô nángngà lumun yu tun ta mga manubù, asta kédu yu, asta kasarig yu ka Manama! Nángngà tô kabággé yu katô ikasapulù, asal yakó ágsódô katô mga ágkailanganán na nángngà yu áglumun. ");
INSERT INTO bgs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Iring kó na bólóg na gagak ka duma manubù! Ágkangén yu tô délák ulád tikud tun ta wayig na ginámmán yu, asal áglámmáddán yu tô dakál kamelyo. ");
INSERT INTO bgs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Sikiyu mga Pariseo asta mga taratinurù ka sugù, kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Makédu-édu kó su iring kó na mga baso asta mga pinggan na igurasan dád tô tun ta luwà ukit katô mga áglumun ó ágkémun yu, asal maripà tô tun dalám, su tuu madat tô áglumun yu, asta tagawán kó! ");
INSERT INTO bgs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sikiyu mga Pariseo, iring kó na bólóg! Kailangan una yu urasi tô tun dalám ka baso asta pinggan ébô malinis pagsik tô tun ta luwà. ");
INSERT INTO bgs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Sikiyu mga Pariseo asta mga taratinurù ka sugù, kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Makédu-édu kó su iring kó na pantyun na igpinturaan ka mapputì. Agad madigár ágsállággan tô tun ta luwà, asal tô tun dalám tuu mawù asta marag mga tullan. ");
INSERT INTO bgs_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sikiyu pagsik, atin ka ágsállággán kó katô duma mga manubù, iring na ágbánnal kó katô mga sugù ka Manama. Asal tô tun dalám ka pusung yu, ipánnuan kó katô madat, asta kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Sikiyu mga Pariseo asta mga taratinurù ka sugù, kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Makédu-édu kó su gimun yu tô mga pantyun para katô mga propeta, asta ágpiyà-piyaan yu tô mga monomento katô mga manubù sayyan na igbánnal katô mga sugù ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ágkagi kó na atin ka imanubù kó duma katô mga kamónaan yu sayyan, dì kó pád mimmaté katô mga propeta ka Manama iring katô iglumu dan. ");
INSERT INTO bgs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Asal ukit katô kagi yu na sikiyu tô mga rubbad katô manubù na igmaté katô mga propeta ka Manama, ágpasóddór kó na iring kó kandan. ");
INSERT INTO bgs_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Purisu makéring kó katô mga kamónaan yu ébô tumanán yu tô madat na ándà dan tumani. ");
INSERT INTO bgs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Madat kó iring na mga áppuy. Dì kó gó makaluwà tikud tun ta supak ka Manama tun ta ágsupakanan. ");
INSERT INTO bgs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Purisu pasadunán ku tun ákniyu tô mga propeta ku, tô mga manubù na ikasóddór ka kagi ku, asta tô mga manubù na tuminurù ákniyu, asal duwán tun kandan na matayan ukit ka kapansal yu tun ta krus. Duwán lagpássán yu tun ta mga simbaan, asta irrayatan yu agad ánda é sadunan dan. ");
INSERT INTO bgs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Purisu supakan kó gó katô Manama tingód ka kamatayan katô langun manubù na igbánnal katô mga sugù din, tikud katô kamaté ki Abel na ándà salà, sippang katô kamaté ki Zacarias na batà i Baraquias na igmatayan yu tun ta tángngaan katô templo asta katô ággóbbówanan ka mga mannanap. ");
INSERT INTO bgs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Paminág yu ni kagin ku ákniyu na mga manubù áknganni. Supakan kó katô Manama tingód katô kamatayan dan.” ");
INSERT INTO bgs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Makédu-édu kó na mga taga Jerusalem! Inalayun yu ágmatayan tô langun propeta ka Manama, asta ágtimbagán yu ka batu ébô maté tô langun manubù na igpapid ka Manama dini ákniyu! Inalayunna lumimud pád ákniyu ébô dumóppónna, iring na marán na áglangkáb katô mga piyak din. Asal dì kó malyag! ");
INSERT INTO bgs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Purisu iring kó na igtananan balé na ándà dalám. ");
INSERT INTO bgs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Paminág yu ni kagin ku ákniyu. Dì kó kumita puman kanak sippang ka kumagi kó, ‘Durungán ta sikandin na igpasadun katô Áglangngagán na Manama ta dini áknita.’” ");
INSERT INTO bgs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na, tô igpanó si Jesus tikud tun ta templo, igpadani tô mga disipulu din, asta igpakita dan kandin tô mga ássa-ássa balé tun ta templo na madigár ágsállággán. ");
INSERT INTO bgs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Asal igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Ni mga ássa-ássa balé tun ta templo na ágsállággán yu, dadattan tô langun, asta ándà palang sábbad batu na masamà tun ta bówwó katô ássa batu.” ");
INSERT INTO bgs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na, igsadun si Jesus tun ta Pabungan ka Olibo, asta igunsad sikandin. Igpadani tô mga disipulu din tun kandin tun ta ándà mga manubù, asta igkagi sikandan, na mà dan, “Uliti ké. Kadángngan matuman tô igulit nu? Ándin tô kakilalaan na masig kad lumónód asta masig dán tô ágtamanán kani banuwa?” ");
INSERT INTO bgs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Igkagi si Jesus, na mà din, “Banté kó ébô dì kó mapid, ");
INSERT INTO bgs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","su marapung tô mga manubù na mid ka ngadan ku, su mà kagi dan Mesiyas, asta marapung tô mga manubù na mapid asta mákkás kandan. ");
INSERT INTO bgs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Atin ka ágkadinággan yu na duwán mga gira tun ta madani asta tun ta madiyù, yakó ágkamáddangan kanan. Kailangan matuman pa yan, asal ánnà pa yan tô ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Su marapung tô mga banuwa na pagiraé, asta sumulung tô mga sakup ka sábbad harì katô mga sakup ka ássa harì. Duwán ballus asta mga linug tun ta kaluwagan kani banuwa. ");
INSERT INTO bgs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ni gó tô tigkanayan katô kahirapan na dumunggù. ");
INSERT INTO bgs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Paruudan kó ébô irrayatan kó asta matayan kó. Karingasaan kó katô mga manubù tun ta langun banuwa tingód katô kapasakup yu kanak. ");
INSERT INTO bgs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Marapung tô mga manubù na sumungkù katô kasarig dan kanak. Pammáttán dan tô unawa dan, asta paringasaé dan. ");
INSERT INTO bgs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Marapung tô mà kagi mga propeta ka Manama, asta marapung tô mapid dan. ");
INSERT INTO bgs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tuu madat tô áglumun ka mga manubù. Purisu mandà tô ginawa katô karapungan. ");
INSERT INTO bgs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Asal matábbus tô manubù na makatiis katô langun kahirapan. ");
INSERT INTO bgs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tô dì pa dumunggù tô ágtamanán, ulit-ulitán pa ni Madigár Gulitán tingód katô pagpangulu ka Manama tun ta kaluwagan kani banuwa ébô makasóddór tô langun manubù.” ");
INSERT INTO bgs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na, atin ka kitanán yu tô ágkaringasaan ka Manama na igtindág tun ta templo iring katô igsulat katô propeta ka Manama sayyan na si Daniel (kailangan makagpát tô manubù na masa kani), ");
INSERT INTO bgs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kailangan malaguy tô langun taga Judea, asta madun dan tun ta pabunganán. ");
INSERT INTO bgs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tô mga manubù na tun ta luwà katô balé dì mému makahu ébô mangé ka kaduwánnan. ");
INSERT INTO bgs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tô mga manubù na áglumu tun ta kinamát dì mému makólì ébô mangé ka gilisan dan. ");
INSERT INTO bgs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Makédu-édu tô mga gabayi na mabáddás ó ágpasusu tô álló tô! ");
INSERT INTO bgs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dasal kó tun ta Manama ébô ánnà magánnó timpo ó álló ka kapaginawa ka malaguy kó. ");
INSERT INTO bgs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tuu madat tô kahirapan na dumunggù. Ándà palang kahirapan na tuu pa madat tikud tun ta katigkanayan kani banuwa sippang áknganni, asta ándà palang kahirapan na dumunggù na tuu pa madat ka tandingán kani. ");
INSERT INTO bgs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Atin ka dì pabbabaán ka Manama tô kadugayan katô kahirapan, maté tô langun manubù. Asal tingód katô mga manubù na igsalin ka Manama, pabbabaán din tô kadugayan. ");
INSERT INTO bgs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Purisu atin ka duwán kumagi ákniyu, ‘Na, dini dán tô Mesiyas!’ ó duwán kumagi, ‘Taddô tô Mesiyas!’ yakó ágbánnal kandan. ");
INSERT INTO bgs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Su duwán mga manubù na mà kagi Mesiyas asta mà kagi propeta ka Manama. Lumun dan tô mga pató asta mga kasalábbuan ébô mapid pád tô mga manubù na igsalin ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na, banté kó, su taganà a igulit ákniyu. ");
INSERT INTO bgs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Purisu atin ka duwán kumagi ákniyu, ‘Na, tun ta disyerto tô Mesiyas,’ yakó ágsadun. Atin ka duwán kumagi, ‘Na, tun dalám ka balé sikandin,’ yakó gó ágbánnal. ");
INSERT INTO bgs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Matayyó tô kalónód ku na Igpamanubù iring na kirám na ágséllà tun ta kaluwagan ka langit, asta kitanán katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Atin ágkitanán yu tô mga ilimud uwak, kasóddóran yu na duwán inaté lawa dutun.” ");
INSERT INTO bgs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Atin ka mapángnga ni kahirapan, kumangittáng tô álló asta dì miló tô bulan. Mómpad tô mga karani asta makálláng tô langun tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pakitanán ku tô kakilalaan tun ta langit ka masiggad lumónód na Igpamanubù. Rumanu tô langun manubù nit banuwa su kitanán dan tô kadunggù ku tun ta mga sagulapun tikud tun ta langit, su lumónódda na Igpamanubù na tákkássan katô katulusan ku asta katô tuu séllaán ku. ");
INSERT INTO bgs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pédupán ku tô trumpeta, papiddán ku tô mga panaligan ka Manama, asta limudán dan tô langun manubù na igsalin ku tikud tun ta kaluwagan kani banuwa.” ");
INSERT INTO bgs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na, paminág kó kani panunggiringan tingód katô kayu igera. Atin ka kitanán yu tô kayu na gugbus asta ágdaun, kasóddóran yu na masig dán dumunggù tô ágsánnang timpo. ");
INSERT INTO bgs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Purisu atin ka kitanán yu tô katumanan katô igkagi ku ákniyu, kasóddóran yu na masiggad lumónód. ");
INSERT INTO bgs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Paminág yu ni kagin ku ákniyu. Tô dì pa maté tô mga manubù áknganni, matuman pa ni langun. ");
INSERT INTO bgs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mandà gó tô langit asta ni tanà, asal dì gó mandà tô mga kagi ku, asal matuman gó.” ");
INSERT INTO bgs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Asal ándà palang manubù na ikasóddór ka ándin állawi ó urasi tô kalónód ku. Ándà pagsik ikasóddór tô mga panaligan ka Manama tun ta langit. Agad sakán na Batà ka Manama, ándà a ikasóddór, su Ámmà ku dád tô ikasóddór. ");
INSERT INTO bgs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tun ta kalónód ku na Igpamanubù, marapung tô mga manubù na dì makataganà ka kadunggù ku, iring katô mga manubù sayyan na ándà paminág ki Noe. ");
INSERT INTO bgs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Inalayun ágkan tô mga manubù sayyan, ginám dan, asta ágpakalyagé dan, sippang na igdunggù tô álló na igahu dán si Noe asta tô pamilya din tun ta arka. ");
INSERT INTO bgs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Asal ándà ikasóddór tô mga manubù ka ándin tô dumunggù sippang ka ipánnas dan inaté su iglunupan tô tanà, asta ilánnád dan langun. Tô kalónód ku na Igpamanubù iring katô álló sayyan. ");
INSERT INTO bgs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Duwán duwa gamama na áglumu tun ta kinamát, angén tô sábbad, asta katananan tô sábbad. ");
INSERT INTO bgs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duwán duwa gabayi na ággiling, angén tô sábbad, asta katananan tô sábbad. ");
INSERT INTO bgs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Purisu taganà kó, su ándà yu kasóddóri ka kadángnganna dumunggù na Áglangngagán yu. ");
INSERT INTO bgs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Panámdám yu ni. Atin ka kasóddóran katô tigatun ka balé ka kadángngan dumunggù tô takón, makataganà sikandin, asta dì katakawan tô balé din. ");
INSERT INTO bgs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Purisu kailangan tumaganà kó gó, su dumunggù a na Igpamanubù katô oras na ándà yu panámdámmi.” ");
INSERT INTO bgs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Tô állang na ágkasarigan asta katig, tô gó é imun katô amo din na tarapid ka langun ka duma mga állang tun ta balé din ébô mággé kandan ka ágkannán kada álló. ");
INSERT INTO bgs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Atin ka inalayun ágtuman tô állang katô igpalumu katô amo din, kadayawan sikandin ka dumunggù tô amo din. ");
INSERT INTO bgs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Paminág yu ni kagin ku ákniyu. Atin ka tô gó é áglumun katô állang, imun sikandin na tarapid ka langun tun ta balé katô amo din. ");
INSERT INTO bgs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Asal ágpanámdám tô madat állang na madugé pa tô kadunggù katô amo din, ");
INSERT INTO bgs_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","asta áglagpássán din tô duma mga állang na gamama asta gabayi, asta inalayun sikandin ágkan asta ginám ágdángngan katô mga tuu ágpangginám, ");
INSERT INTO bgs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","dumunggù tô amo din katô álló na ándà din panámdámmi asta tô oras na ándà din kasóddóri. ");
INSERT INTO bgs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Purisu supakan sikandin katô amo din, asta papiddán tun ta mga manubù na kéman dan ka nángngà tô áglumun. Tuu sumággó tô mga manubù dutun, asta kumurigát tô ngipán dan tingód katô kasakit dan.” ");
INSERT INTO bgs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Iring kani tô katigkanayan katô pagpangulu ka Manama. Duwán sapulù (10) mga daraga na igsumar katô mama na ágkasalán. Tô tagsábbad-sábbad kandan igpid ka sulù. ");
INSERT INTO bgs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima tô mga daraga na mapandé, asta lima tô mga daraga na ágkatuluan. ");
INSERT INTO bgs_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tô lima mga daraga na ágkatuluan igpid ka sulù, asal ándà langis na igpid dan ébô dalámmán dan tun ta sulù ka kémmáttan dan. ");
INSERT INTO bgs_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Asal tô lima mga daraga na mapandé igpid katô sulù asta langis na dalámmán dan puman. ");
INSERT INTO bgs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Idugé na ándà dunggù tô mama na ágkasalán. Purisu itudugan tô langun daraga asta ináknákkan dan. ");
INSERT INTO bgs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tô tángngà dán ka dukilám, igdinág dan tô manubù na igkagi, na mà din, ‘Na, igdunggù dán tô ágkasalán! Sékót kó sumar kandin.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Purisu igánnó tô langun daraga, asta igpiyaan dan tô mitsa katô sulù dan. ");
INSERT INTO bgs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Igkagi tô lima mga daraga na ágkatuluan tun ta lima mga daraga na mapandé, na mà dan, ‘Bággéyi ké ka langis, su masig dán mapadáng ni sulù dé.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Asal igkagi tô lima mga daraga na mapandé, ‘Dì ké mággé agó dì makanángngà ni langis na igpid dé. Madigár pa ka madun kó tun ta tindaan ébô málli kó.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Purisu igsadun dan tun ta tindaan ébô málli dan. Róggun katô kapanó dan, igdunggù tô mama na ágkasalán. Igtákkás tô langun daraga na ikataganà, asta igsadun dan tun ta ágkasalan. Tô igahu dan dán tun ta balé, igsagpángngan dán tô sállat. ");
INSERT INTO bgs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Tô itagad-tagad dán, igdunggù tô lima mga daraga tikud tun ta tindaan, igtawar dan tikud tun ta luwà katô balé, na mà dan, ‘Sir, abriyi ké pa.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Asal igtaba tô ágkasalán, na mà din, ‘Paminág yu ni kagin ku ákniyu. Ándà a kilala ákniyu.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Purisu kailangan inalayun kó tumaganà, su ándà yu kasóddóri ka ándin állawi ó urasi tô kalónód ku.” ");
INSERT INTO bgs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Iring kani tô pagpangulu ka Manama. Duwán sábbad manubù na igsadun tun ta madiyù banuwa. Tô ándà pa sikandin panó, igpatawar din tô mga állang din, asta igsarigan din sikandan ka salapì din. ");
INSERT INTO bgs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Duwán igbággé din tun ta tagsábbad-sábbad kandan na nángngà dád katô kakatigan dan. Lima abuk bulawan tô igbággé din tun ta sábbad állang, duwa abuk bulawan tô igbággé din tun ta ikaduwa állang, sábbad abuk bulawan tô igbággé din tun ta ikatállu állang, asta igpanó sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na, tô állang na igbággayan katô lima abuk bulawan, ignegosyo din, asta duwán lima abuk bulawan na iganansya din. ");
INSERT INTO bgs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tô állang na igbággayan katô duwa abuk bulawan, duwán pagsik duwa abuk na iganansya din. ");
INSERT INTO bgs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Asal tô állang na igbággayan din katô sábbad abuk bulawan, igkali sikandin tun ta tanà, asta iglábbáng din tô bulawan na igbággé kandin. ");
INSERT INTO bgs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Na, tô idugé dán, igulì tô amo dan, asta igtawar din tô tállu állang na igbággayan din ka bulawan ébô kasóddóran din ka duwán iganansya dan. ");
INSERT INTO bgs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tô igpadani tô állang na igbággayan katô lima abuk bulawan, igpid din tô igbággé kandin asta tô lima abuk bulawan na iganansya din. Igkagi sikandin, ‘Sir, lima abuk bulawan tô igbággé nu kanak, asta duwán dán lima abuk bulawan na iganansya ku.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Igkagi tô amo din, ‘Madigár tô iglumu nu. Madigár ka manubù asta ágkasarigan ka. Agad délák tô igbággé ku áknikó, ágkasarigan ka. Purisu dakál tô sarigán ku áknikó. Kadayawan ka iring katô dayó ku.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Igpadani pagsik tô állang na igbággayan ka duwa abuk bulawan, asta igkagi sikandin, ‘Sir, duwa abuk bulawan tô igbággé nu kanak, asta duwán dán duwa abuk bulawan na iganansya ku.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Igkagi tô amo din, ‘Madigár tô iglumu nu. Madigár ka manubù asta ágkasarigan ka. Agad délák tô igbággé ku áknikó, ágkasarigan ka. Purisu dakál tô sarigán ku áknikó. Kadayawan ka iring katô dayó ku.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Igpadani pagsik tô állang na igbággayan din ka sábbad abuk bulawan, asta igkagi sikandin, ‘Sir, isóddóran ku na magani ka manubù, su ágkáttun nu tô igpamula ka duma mga manubù, asta ágtaguán nu tun ta lukung nu tô trigo na igpalayapan ka duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Purisu imáddanganna áknikó asta iglábbáng ku tô bulawan nu tun ta tanà. Ulián kud áknikó ni sábbad abuk bulawan na igbággé nu kanak.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Igkagi tô amo din, ‘Tukukán ka, asta madat tô iglumu nu! Igkagi ka na ágkáttun ku tô igpamula ka duma mga manubù, asta ágtaguán ku tun ta lukung ku tô trigo na igpalayapan ka duma mga manubù. Su isóddóran nu yan, ");
INSERT INTO bgs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","madigár pád ka igtagù nu tô bulawan ku tun ta bangko ébô matanggap ku pád na duwán dán tubù tô igdunggù a.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Purisu igkagi sikandin tun ta duma mga állang, na mà din, ‘Kangé yu tô sábbad abuk bulawan na igbággé ku kandin, asta bággé yu tun ta állang na duwán sapulù (10) abuk bulawan. ");
INSERT INTO bgs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Su tô manubù na duwán kandin, bággayan sikandin katô tuu pa dakál katô ágkailanganán din. Asal tô manubù na ándà kandin, kangayan sikandin katô langun tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, ni madat manubù, pid yu sikandin tun ta luwà tun ta kangittángngan ébô supakan. Tuu sumággó tô mga manubù dutun, asta kumurigát tô ngipán dan tingód katô kasakit dan.’” ");
INSERT INTO bgs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Tô álló na lumónódda na Igpamanubù, tákkássanna katô langun panaligan ka Manama asta katô séllaán ku. Munsadda tun ta madigár gunsadanan ka pagpangulu. ");
INSERT INTO bgs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tô langun manubù tikud tun ta kaluwagan ka banuwa malimud tun ta saruwan ku, asta passan ku sikandan iring na áglumun katô taradóppón ka karnero ka ágpassan din tô mga karnero asta tô mga kambing, ");
INSERT INTO bgs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","su áglimudán din tô mga karnero na dadan ta kawanan din, asal áglimudán din tô mga kambing na dadan ta ibang din. ");
INSERT INTO bgs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Iring kani tô lumun ku ka rumuudda, su kumagiya katô mga manubù na dadan ta kawanan ku, ‘Tákkás kó kanak, su duwán kadayawan yu na igbággé katô Ámmà ku na Manama, su tumigkanéyad mangulu ákniyu iring katô plano katô Ámmà ku para ákniyu tô ándà pa imuwi ni banuwa. ");
INSERT INTO bgs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tô igballussa, igpakanna ikiyu. Tô itákkanganna, igpénámma ikiyu. Agad ándà a ikiyu kilalayi tô kadunggù ku tun ákniyu, asal igpóddô a ikiyu tun ta balé yu. ");
INSERT INTO bgs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tô ándà umpak ku, duwán igbággé yu kanak. Tô ibógókanna, igdóppónanna ikiyu. Tô igprisowa, igahà a ikiyu.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na, minsà tô mga igbánnal katô mga sugù ka Manama na dadan ta kawanan ku, na mà dan, ‘Sir, kadángngan ka iballusan, asta igpakan dé sikuna? Kadángngan ka itákkangan, asta igpénám dé sikuna? ");
INSERT INTO bgs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kadángngan ka dunggù na ándà dé sikuna kilalayi, asta igpóddô dé sikuna tun ta balé dé? Kadángngan na ándà umpak nu, asta igbággayan dé sikuna? ");
INSERT INTO bgs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kadángngan ka ibógókan ó igpriso, asta igahà ké áknikó?’ ");
INSERT INTO bgs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tumaba a, ‘Paminág yu ni kagin ku ákniyu. Ukit ka kalumu yu kani tun ta agad sábbad dád kataladi ku na mabbabà é kamanubuan, iring na iglumu yu ni kanak.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Na, kumagiya katô mga manubù na dadan ta ibang ku, ‘Kailangan supakan kó. Iwà kó tikud dini kanak. Sadun kó tun ta apuy na dì gó mapadáng ka ándà ágtamanán, su tô gó tô igtaganà ka Manama ébô duwán antugan din ki Maibuyan asta langun panaligan din. ");
INSERT INTO bgs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tô igballussa, ándà a ikiyu pakanni. Tô itákkanganna, ándà a ikiyu pénámmi. ");
INSERT INTO bgs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tô igdunggù a tun ákniyu, ándà a ikiyu póddói tun ta balé yu. Tô ándà umpak ku, ándà a ikiyu bággéyi. Tô ibógókanna, ó igprisowa, ándà a ikiyu dóppóni.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Minsà dan pagsik, ‘Sir, kadángngan ké kita áknikó na igballus ka, itákkangan ka, ándà góddóan nu, ándà umpak nu, ibógókan ka, ó igpriso ka, asal ándà ké tabang áknikó?’ ");
INSERT INTO bgs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tumaba a, ‘Paminág yu ni kagin ku ákniyu. Su ándà kó tabang katô sábbad dád kadumaan ku na mabbabà é kamanubuan, iring na ándà kó tabang kanak.’ ");
INSERT INTO bgs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Purisu pasadunán dan tun ta ágsupakanan na ándà ágtamanán. Asal tô mga manubù na igbánnal katô mga sugù ka Manama, bággayan dan ka kantayan na ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tô igtinurù si Jesus kani langun, igkagi sikandin tun ta mga disipulu din, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Isóddóran yu na duwa pa álló tô kadunggù katô Kalimudan Ka Kalabé, asta bággénna na Igpamanubù tun ta bállad ka mga manubù na mansal kanak tun ta krus.” ");
INSERT INTO bgs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na, ilimud tô mallayat ka mga pangulu ka templo asta tô mga ágtugállán ka Judio tun ta balé katô tuu mallayat ka pangulu dan na si Caifas. ");
INSERT INTO bgs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Igplano dan na ámmáttán si Jesus na ándà duma manubù na makasóddór ébô matayan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Igkagi sikandan, na mà dan, “Kailangan dì ta sikandin pammáttán dalám ka kalimudan agó sumamuk tô langun manubù na inalayun ágpaminág kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na, róggun dutun si Jesus ta lunsud ka Betania, igsadun sikandin tun ta balé i Simon na inólian katô bógók din na téték. ");
INSERT INTO bgs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Róggun igkan dan, duwán bayi na igpid ka pamammut na dakál é lagà asta igdalám tun ta katiyà na alabastro. Igpadani tô bayi tun ki Jesus, asta igbusbus din tô pamammut tun ta ulu i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na, tô igkita tô mga disipulu i Jesus katô iglumu katô bayi, isókó dan, asta igkagi sikandan, na mà dan, “Inólaan tô pamammut. ");
INSERT INTO bgs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Madigár pád ka barigyaán ka dakál lagà asta bággén tun ta mga ágkayu-ayuan.” ");
INSERT INTO bgs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Asal isóddóran i Jesus, asta igkagi sikandin, na mà din, “Pabayà yu ni bayi, su madigár tô iglumu din kanak. ");
INSERT INTO bgs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Inalayun duwán mga ágkayu-ayuan na mému yu tabangan. Asal diya móddô dini ákniyu ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ukit katô kabusbus din ka pamammut kani lawa ku, igpataganà a ikandin para katô kalábbáng kanak. ");
INSERT INTO bgs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Paminág yu ni kagin ku ákniyu. Agad ánda é gulit-ulitan katô Madigár Gulitán tun ta kaluwagan kani banuwa, ulitán tô iglumu din kanak. Dì sikandin kalingawan.” ");
INSERT INTO bgs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na, duwán sábbad tun ta sapulù duwa (12) disipulu i Jesus na ágngadanan ki Judas Iscariote. Igsadun sikandin tun ta mallayat ka mga pangulu ka templo, ");
INSERT INTO bgs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","asta igkagi sikandin, na mà din, “Atin ka pammáttán ku sikandin, ándin é bággén yu kanak?” Purisu igbággé dan kandin tô tállu pulù (30) abuk mapputì bulawan. ");
INSERT INTO bgs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tikud katô oras tô, igangat si Judas ka madigár timpo ébô pammáttán din si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na, igdunggù tô tagnà álló ka kalimudan na ágkan tô mga Judio katô Pan Na Ándà Pagpatubù. Igpadani tô mga disipulu i Jesus tun kandin, asta iginsà sikandan, na mà dan, “Ánda táppad tô kakalyag nu na taganaan dé katô kannan katô Kalimudan Ka Kalabé?” ");
INSERT INTO bgs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Igtaba si Jesus, na mà din, “Sadun kó tun ta sábbad manubù tun ta Jerusalem, asta kagiyi yu sikandin, ‘Igkagi tô Taratinurù na igdunggù dán tô oras na igsalin para kandin. Kuman sikandin katô Kalimudan Ka Kalabé nit balé nu na duma áknami na mga disipulu din.’” ");
INSERT INTO bgs_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na, igbánnal tô mga disipulu din, asta igtaganà dan dutun tô ágkannán para katô Kalimudan Ka Kalabé. ");
INSERT INTO bgs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tô ágsalláp dán tô álló, igkan si Jesus asta tô sapulù duwa (12) disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Róggun ágkan dan, igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Duwán sábbad ákniyu na pammát kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Purisu tuu iranu tô pusung dan, asta iginsà tô tagsábbad-sábbad kandan, na mà dan, “Áglangngagán, sakán?” ");
INSERT INTO bgs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Igtaba si Jesus, na mà din, “Pammát kanak tô ágtugán kanak. ");
INSERT INTO bgs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Matéya na Igpamanubù, su tô gó é igsulat sayyan tingód kanak. Asal makédu-édu tô manubù na pammát kanak! Tuu pa madigár kandin ka ándà kamanubù.” ");
INSERT INTO bgs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iginsà tô pammát kandin na si Judas, na mà din, “Sir, sakán?” Igtaba si Jesus, na mà din, “Sikuna tô igkagi kanan.” ");
INSERT INTO bgs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na, róggun ágkan dan, igkangé si Jesus ka pan, igpasalamat sikandin tun ta Manama, igtáppik-táppik din tô pan, asta igbággé din tun ta mga disipulu din. Igkagi sikandin, na mà din, “Tanggap yu ni pan asta kan yu, su ni gó ni lawa ku.” ");
INSERT INTO bgs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Igkangé din pagsik tô kopa, igpasalamat sikandin tun ta Manama, asta igpénám din kandan. Igkagi sikandin, na mà din, “Inám kó langun kani, ");
INSERT INTO bgs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","su ni ginámmán ni tô dipanug ku na ulaán ébô kapasinsiyaan tô mga salà katô marapung manubù. Ni gó tô ágpasóddór na duwán kapókit ka Manama dutun ta mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kagin ku ákniyu, diyad muman minám kani ginámmán ta sippang ka minám ki katô mantu bino tun ta pagpangulu katô Ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na, igkanta dan tingód katô kadurung dan ka Manama, asta igsadun dan tun ta Pabungan ka Olibo. ");
INSERT INTO bgs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na, igkagi si Jesus tun ta mga disipulu din, na mà din, “Kani ka dukilám, tumanan tô langun yu kanak tingód katô kahirapan na dumunggù kanak, su mà katô kagi ka Manama, “‘Pamatayan ku tô taradóppón, asta pasállabé tô mga karnero na igdóppónan din.’ ");
INSERT INTO bgs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Asal pángnga ka mantéya puman, muna a ákniyu tun ta Galilea.” ");
INSERT INTO bgs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Igkagi si Pedro ki Jesus, na mà din, “Agad tumanan tô langun dan, asal diya gó tumanan áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Igkagi si Jesus, na mà din, “Paminág nu ni kagin ku áknikó. Kani ka dukilám ka dì pa mukkarà tô manuk, makatállu ka mulun kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Igkagi si Pedro, na mà din, “Agad matayanna duma áknikó, asal diya mulun áknikó.” Magunawa tô igkagi katô langun disipulu. ");
INSERT INTO bgs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na, igsadun si Jesus asta tô mga disipulu din tun ta lugar na ágngadanan Getsemane. Igkagi si Jesus tun ta mga disipulu din, na mà din, “Unsad kó kannun róggun madunna taddô ébô dumasalla.” ");
INSERT INTO bgs_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Igpatákkás din si Pedro asta tô duwa gabatà i Sebedeo. Tuu iranu si Jesus, asta mabággat tô pusung din. ");
INSERT INTO bgs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Igkagi sikandin, na mà din, “Tuu iranu ni pusung ku, iring na matéya. Kannun kó dád, asal yakó ágtudug.” ");
INSERT INTO bgs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na, igpanayun si Jesus tun tóna na dì madiyù, iglangkáb sikandin, asta igdasal, na mà din, “Ámmà, atin ka mému áknikó, yaka ágpókit kanak tun ta kahirapan na masig dán dumunggù. Asal tuman nu tô áknikó kakalyag, ánnà tô kanak kakalyag.” ");
INSERT INTO bgs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tô iglónód si Jesus tun ta mga disipulu din, igpantudug dan. Igánnó din sikandan, asta igkagi sikandin ki Pedro, na mà din, “Isalábbuanna su ándà ka ikatiis ka sábbad dád oras. ");
INSERT INTO bgs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yakó ágtudug, asal dasal kó ébô dì kó matalu ka pagtintal. Tuu madigár tô kakalyag ka pusung yu, asal malómét tô lawa yu.” ");
INSERT INTO bgs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Igpanó puman si Jesus tun tóna, asta igdasal sikandin, na mà din, “Ámmà, atin ka kailangan mukitta tun ta kahirapan na masig dán dumunggù, kakalyag ku na tô áknikó kakalyag é matuman.” ");
INSERT INTO bgs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iglónód puman si Jesus tun ta mga disipulu din, asta igkita din sikandan na igpantudug, su ágkatudugan dan. ");
INSERT INTO bgs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Purisu igpanó puman si Jesus, asta igdasal sikandin ka ikatállu. Magunawa tô dasalán din. ");
INSERT INTO bgs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na, iglónód sikandin tun ta mga disipulu din, asta igkagi sikandin, na mà din, “Isalábbuanna su igpantudug kó puman asta igpaginawa kó. Na, igdunggù dán tô oras na pammáttánna na Igpamanubù, su bággénna tun ta bállad katô mga manubù na masalà-salà. ");
INSERT INTO bgs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tindág kód su panó kid. Igdunggù dán tô manubù na pammát kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Róggun igkagi si Jesus, igdunggù si Judas na sábbad katô sapulù duwa (12) disipulu. Tuu marapung tô mga manubù na igtákkás kandin, asta igpid dan ka mga kampilan asta mga paglagpás. Igpapid dan katô mallayat ka mga pangulu ka templo asta mga ágtugállán ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Taganà igpasóddór i Judas tô kakilalaan tun kandan, su igkagi sikandin, na mà din, “Tô manubù na adákkan ku, tô gó é ágpamasakán yu. Ámmát yu sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tô igdunggù si Judas, sékót igpadani sikandin tun ki Jesus, asta igkagi sikandin, na mà din, “Sir, madigár dukilám!” Asta igadák sikandin ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Igkagi si Jesus tun kandin, na mà din, “Rarak, manan ka igsadun ka dini?” Purisu igpadani tô duma mga manubù, asta igámmát dan si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na, duwán sábbad disipulu na igtákkás ki Jesus na igtagnus katô kampilan din, igtigbas din tô állang katô tuu mallayat ka pangulu ka templo, asta ipangul tô talinga din. ");
INSERT INTO bgs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Asal igsapadan i Jesus sikandin, na mà din, “Ulì nu tô kampilan tun ta rumà. Tô manubù na gumamit ka kampilan, tô gó é matayan ka kampilan. ");
INSERT INTO bgs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ándà nu basì kasóddóri ni. Atin ka dumasalla tun ta Ámmà ku, mému papiddán din tô sobra pa katô sapulù duwa (12) magdakál grupo ka mga panaligan din ébô tumabang kanak. ");
INSERT INTO bgs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Asal atin ka tabanganna ikandan, dì dán matuman tô kagi ka Manama na igsulat sayyan na matumanna dungguan ka kahirapan.” ");
INSERT INTO bgs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na, igkagi si Jesus tun ta mga manubù, na mà din, “Manan ka mámmát kó kanak ukit ka mga kampilan asta mga paglagpás? Ánnà a tulisan. Álló-álló ágtinurù a tun ta plasa ka templo, asal ándà a ikiyu ámmátti. ");
INSERT INTO bgs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Asal inému ni langun ébô matuman tô kagi ka Manama na igsulat katô mga propeta din sayyan tingód kanak.” Na, tô langun disipulu i Jesus igtanan kandin, asta igpalaguy dan. ");
INSERT INTO bgs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na, tô mga manubù na igámmát ki Jesus igpid kandin tun ta balé katô tuu mallayat ka pangulu ka templo na si Caifas. Taganà igpalimudé tô mga taratinurù ka sugù asta tô mga ágtugállán ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Igtalundug si Pedro, asal igpadiyù dád sikandin sippang ka igdunggù dan tun ta luwà ka balé katô tuu mallayat ka pangulu ka templo. Igunsad si Pedro duma katô mga tarabanté ka templo ébô kasállággan din ka ándin é lumun dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na, tô mallayat ka mga pangulu ka templo asta tô langun ágpangulun ka templo, igpamasak ka mga testigos na mulaló tingód ki Jesus ébô duwán gunayan na matayan dan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Asal ándà dan kanángngai katô igulit dan tingód kandin, agad marapung tô mga igtestigos ka bulaló. Tô itagad-tagad dán, duwán duwa manubù na igpadani tun kandan, ");
INSERT INTO bgs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","asta igkagi sikandan, na mà dan, “Igdinág dé tô igkagi din, na mà din, ‘Makémuwa dumadat kani templo ka Manama, asta patindággán ku puman dalám ka tállu álló.’” ");
INSERT INTO bgs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Igtindág tô tuu mallayat ka pangulu ka templo, asta iginsà sikandin, na mà din, “Ándin é taba nu? Bánnal tô igkagi kani mga manubù?” ");
INSERT INTO bgs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Asal ándà gó taba si Jesus. Purisu igkagi tô tuu mallayat ka pangulu ka templo, na mà din, “Maggátta ágkagi áknikó ukit ka ngadan ka manté Manama na kailangan mulit ka katô kabánnalan. Uliti ké ka sikuna tô Mesiyas na Batà ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Igkagi si Jesus, na mà din, “Bánnal tô igkagi nu. Ulitán ku ákniyu, duwán álló na kumita kó kanak na Igpamanubù na gunsad dadan tun ta kawanan katô Matulus Manama ébô manguluwa duma kandin. Tákkássanna katô mga sagulapun tun ta langit.” ");
INSERT INTO bgs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Purisu igbissé katô tuu mallayat ka pangulu ka templo tô kapa din tingód ka sókó din, asta igkagi sikandin, na mà din, “Igpagunawa sikandin katô Manama. Ándà dán kailangan na ulitan ki pa ka duma manubù tingód kandin. Igdinág tad na igpagunawa sikandin katô Manama. ");
INSERT INTO bgs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, ándin é ruud yu tingód kandin?” Igtaba sikandan, na mà dan, “Kailangan matayan sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na, igilábban dan tô báttuk din, igsuntuk dan sikandin, asta duwán igsampal kandin. ");
INSERT INTO bgs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Igkagi sikandan, na mà dan, “Na, atin ka bánnal na sikuna tô Mesiyas, uliti ké ka sadan tô igsuntuk áknikó!” ");
INSERT INTO bgs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na, igunsad si Pedro tun ta luwà katô balé. Duwán sábbad állang bayi na igpadani tun kandin, asta igkagi sikandin, na mà din, “Sikuna pagsik tô kadumaan i Jesus na taga Galilea.” ");
INSERT INTO bgs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Asal igbulun si Pedro na igdinág katô langun manubù, na mà din, “Ándà sóddór ku tingód katô igkagi nu.” ");
INSERT INTO bgs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na, tô igalin si Pedro madani tun ta sállat, duwán ássa állang bayi na igkita kandin, asta igkagi tô bayi tun ta duma mga manubù, na mà din, “Ni manubù ni kadumaan i Jesus na taga Nazaret.” ");
INSERT INTO bgs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Asal igbulun dán puman si Pedro, asta igkagi sikandin, na mà din, “Ándà a kilala kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ándà kadugé, duwán puman mga manubù na igpadani tun ki Pedro, asta igkagi sikandan, na mà dan, “Bánnal gó sikuna tô sábbad kadumaan i Jesus, su ágkilalan na iring kandin tô kakagi nu.” ");
INSERT INTO bgs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Asal igsapà gó si Pedro, na mà din, “Agad matéya pa, ándà ku gó kilalayi tô manubù tô.” Tigkô dád igukkarà tô manuk. ");
INSERT INTO bgs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Purisu isampáttan i Pedro tô taganà igkagi i Jesus na mulun sikandin ki Jesus ka makatállu ka dì pa mukkarà tô manuk. Na, igluwà si Pedro, asta tuu gó igsággó. ");
INSERT INTO bgs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na, tuu pô sállám, igpalimudé tô langun ka mallayat ka mga pangulu ka templo asta tô mga ágtugállán ka Judio. Igpatóngkóé dan ka ándin é dimanda dan tun ta gobyerno tingód ki Jesus ébô matayan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Igbagkás dan tô bállad i Jesus, asta igpid dan sikandin tun ta gobernador na si Pilato. ");
INSERT INTO bgs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na, si Judas na igpammát ki Jesus, tô ikasóddór sikandin na igruudan si Jesus na matayan, iranu sikandin tingód katô iglumu din. Igulì din tô tállu pulù (30) abuk mapputì bulawan tun ta mallayat ka mga pangulu ka templo asta mga ágtugállán ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Igkagi sikandin, na mà din, “Duwán salà ku, su igpammát ku tô manubù na ándà palang salà.” Asal igkagi sikandan, na mà dan, “Ándà labut dé kanan! Áknikó salà!” ");
INSERT INTO bgs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Purisu igantug din tô mga abuk mapputì bulawan tun ta dalám ka templo, igpanó sikandin, asta igpangarát na igirát katô alig din. ");
INSERT INTO bgs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Igpamudut katô mallayat ka mga pangulu ka templo tô mga abuk mapputì bulawan na igantug i Judas, asta igkagi sikandan, na mà dan, “Atin ka taguán ta ni mapputì bulawan tun ta ágtaguanan ka salapì ka templo, makalapas ki ka sugù, su ni gó é bayad ka kamatayan katô sábbad manubù.” ");
INSERT INTO bgs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Purisu igpasábbadé dan, asta tô gó é bayad dan katô tanà katô taraimu ka kudán ébô duwán áglábbángnganan ka mga manubù na ánnà taga Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Purisu ágngadanan tô “Tanà Ka Dipanug” sippang áknganni. ");
INSERT INTO bgs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Purisu ituman tô igkagi katô propeta ka Manama sayyan na si Jeremias, na mà din, “Tállu pulù (30) abuk mapputì bulawan tô lagà din na igsábbadan katô pira mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tô gó é bayad dan katô tanà katô taraimu ka kudán, su tô gó é igsugù katô Áglangngagán kanak.” ");
INSERT INTO bgs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na, tô igpid dan ki Jesus tun ta gobernador, iginsà tô gobernador, na mà din, “Sikuna tô Harì ka mga Judio?” Igkagi si Jesus, na mà din, “Óó. Bánnal tô igkagi nu.” ");
INSERT INTO bgs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tô igdimanda tô mallayat ka mga pangulu ka templo asta tô mga ágtugállán ka Judio tingód ki Jesus, ándà gó taba si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Purisu igkagi si Pilato, na mà din, “Marapung tô igkagi dan tingód áknikó. Ándà taba nu kandan?” ");
INSERT INTO bgs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Asal ándà gó taba si Jesus. Purisu tuu isalábbuan tô gobernador. ");
INSERT INTO bgs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, kada ámmé dalám ka Kalimudan Ka Kalabé, duwán ágkémun katô gobernador na ágpaluwaán din tô sábbad manubù na igpriso, agad sadan tô salinán katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na, duwán madat manubù na igpriso na tuu ibantug na ágngadanan ki Barabas. ");
INSERT INTO bgs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Purisu tô ilimud tô marapung manubù, iginsà si Pilato, na mà din, “Sadan tô kakalyag yu na paluwaán ku? Si Barabas ó si Jesus na ágtawarán na Mesiyas?” ");
INSERT INTO bgs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tô gó é igkagi i Pilato, su isóddóran din na igpammát tô mga pangulu ka templo ki Jesus su gingà dan dád kandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Róggun igunsad si Pilato tun ta ágruudanan, duwán manubù na igpapid katô sawa din ébô ulitán tô kagi din, na mà din, “Yaka gilabut katô manubù na ándà salà, su tuuwa isamuk tingód kandin ukit ka tagénáp ku géna dukilám.” ");
INSERT INTO bgs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na, tô mallayat ka mga pangulu ka templo asta tô mga ágtugállán ka Judio inalayun igsutsut katô ilimud mga manubù ébô paluwaán si Barabas asta pamatayan si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ándà kadugé, iginsà puman tô gobernador, na mà din, “Sadan tô kakalyag yu na paluwaán ku?” Igtaba sikandan, na mà dan, “Si Barabas.” ");
INSERT INTO bgs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Iginsà si Pilato, na mà din, “Pamánnun ku si Jesus na ágtawarán Mesiyas?” Igtaba tô langun dan, na mà dan, “Pansalan sikandin tun ta krus!” ");
INSERT INTO bgs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iginsà si Pilato, na mà din, “Manan? Ándin é iglumu din na madat?” Asal igtuu baling igmabákkár tô ullaón dan, na mà dan, “Pansalan sikandin tun ta krus!” ");
INSERT INTO bgs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na, isóddóran dán i Pilato na ándà dán mému din kandan, asta masig dan dán sumamuk. Purisu igkangé sikandin ka wayig, asta igdamù sikandin róggun igsállág dan kandin. Igkagi sikandin, na mà din, “Ándà labut ku ka kamatayan kani manubù ni. Ákniyu kakalyag ni.” ");
INSERT INTO bgs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Igkagi tô langun manubù, na mà dan, “Mému supakan ké katô Manama asta tô mga rubbad dé tingód katô kamatayan din!” ");
INSERT INTO bgs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Purisu igpaluwà i Pilato si Barabas tikud tun ta prisowan. Igpalagpás din si Jesus, asta igbággé din tun ta mga sundalo din ébô pansalan tun ta krus. ");
INSERT INTO bgs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na, igpid katô mga sundalo si Jesus tun dalám ka balé katô gobernador, asta iglimud dan tô langun ka kadumaan dan na mga sundalo. ");
INSERT INTO bgs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iglusutan dan si Jesus ka umpak, asta igumpakan dan sikandin ka mallutù kapa. ");
INSERT INTO bgs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Igpákkù dan tô dugin balagán, asta tô gó é igkorona dan tun ta ulu din. Duwán iring na balakayu na igpawidan dan kandin iring na tukád ka harì. Iglingkóód dan asta mà kagi ágtanggap dan ka harì. Igkagi sikandan, na mà dan, “Durungán ka na Harì ka mga Judio!” ");
INSERT INTO bgs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Igilábban dan sikandin. Igkangé dan tô iring na balakayu tikud tun kandin, asta iglagpás dan tô ulu din. ");
INSERT INTO bgs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pángnga igbuyas-buyas dan kandin, iglusut dan tô mallutù kapa tikud tun kandin, asta igpómpak dan puman ki Jesus tô kandin umpak. Igpid dan sikandin tikud tun ta balé katô gobernador ébô pansalan tun ta krus. ");
INSERT INTO bgs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tô igluwà dan tikud tun ta Jerusalem, ikitaan ka mga sundalo tô sábbad taga Cirene na ágngadanan ki Simon. Igpirit dan sikandin igpatiang katô krus na pansalan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Igsadun dan tun ta lugar na ágngadanan Golgota. (Tô kóbadan, “Bóngó-bóngó.”) ");
INSERT INTO bgs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Igbággé dan ki Jesus tô bino na igbaláttan ka mappait bawì. Tô igkinnam sikandin, ándà din panayuni inámmi. ");
INSERT INTO bgs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Igpansalan katô mga sundalo si Jesus tun ta krus. Igtalad-talad dan tô umpak din ukit ka ripa. ");
INSERT INTO bgs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Igunsad dan, asta igbanté dan kandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Duwán igsulat na igpatagù tun datas ka ulu din tingód katô dimanda kandin, na ágkabasa, “SI JESUS NA HARÌ KA MGA JUDIO.” ");
INSERT INTO bgs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Madani tun ki Jesus, duwán duwa tulisan na igpansalan tun ta duwa krus, tô sábbad dadan tun ta ibang din asta tô sábbad dadan tun ta kawanan din. ");
INSERT INTO bgs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tô mga manubù na iglabé dutun, igkiring-kiring dan na igbuyas-buyas kandin, ");
INSERT INTO bgs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","asta igkagi sikandan, na mà dan, “Atin ka sikuna tô makému dumadat katô balé ka Manama, asta patindággán nu puman dalám ka tállu álló, tabangi nu tô áknikó sarili ébô dì ka maté! Atin ka bánnal ka Batà ka Manama, pónóg ka tikud dun ta krus.” ");
INSERT INTO bgs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iring pagsik kanan tô kabuyas-buyas katô mallayat ka mga pangulu ka templo, mga taratinurù ka sugù, asta mga ágtugállán ka Judio. Igkagi sikandan, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Igtabangan din tô duma mga manubù ébô dì maté. Asal dì sikandin makatabang katô kandin sarili ébô dì sikandin maté. Sikandin kun tô Harì ka mga rubbad i Israel. Atin ka makapónóg sikandin tikud dun ta krus, mamaké ki kandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Manama kun tô ágsarigan din. Atin ka duwán kakalyag ka Manama kandin, tumabang tô Manama kandin, su igkagi sikandin, ‘Batà a katô Manama.’” ");
INSERT INTO bgs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iring pagsik kanan tô kabuyas-buyas katô duwa tulisan na igpansalan tun ta krus duma kandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na, tô malássád dán tô álló, igmangittáng tô kaluwagan kani banuwa dalám ka tállu oras. ");
INSERT INTO bgs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tô alas tres ka mapun, igullaó si Jesus ka mabákkár tun ta kagi ka Hebreo, na mà din, “Eli, Eli, lama sabaktani?” Tô kóbadan, “Manama ku, Manama ku, manan ka igpabayà a ikuna?” ");
INSERT INTO bgs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tô igdinág tô duma mga manubù kandin, igkagi sikandan, na mà dan, “Igtawar sikandin ki Elias na propeta ka Manama sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Duwán sábbad manubù na igpalaguy, igkangé ka espungha, asta igarám tun ta bino na igbaláttan ka wayig. Igtakós din tun ta iring na balakayu asta igpadatas tun ta babbà i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Asal igkagi tô duma mga manubù, na mà dan, “Pabayà nu sikandin, su sállággán ta ka dumunggù si Elias ébô tumabang kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na, igullaó puman si Jesus ka mabákkár, igsarig din tô espiritu din tun ta Ámmà din asta inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tigkô dád itángngà tô tabir tun ta tángngaan katô templo. Itángngà tikud tun datas sippang tun ta asag. Iglinug, asta itábbag tô magdakál mga batu. ");
INSERT INTO bgs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ipókéan tô mga lábbáng, asta inanté puman tô marapung manubù na igbánnal ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Igluwà dan tikud tun ta mga lábbáng dan. Pángnga inanté puman si Jesus, igsadun tô mga inanté tun ta Jerusalem, asta marapung tô mga manubù na ikakita kandan. ");
INSERT INTO bgs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, tô mga sundalo asta tô kapitan na igbanté ki Jesus, tô igriyu dan katô linug asta igkita dan tô ilumu, igkállas dan asta igkagi sikandan, na mà dan, “Bánnal gó na Batà sikandin ka Manama!” ");
INSERT INTO bgs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Marapung tô mga gabayi tun ta madiyù puri na ikakita pagsik katô ilumu. Sikandan tô taganà igtákkás ki Jesus tikud tun ta Galilea asta igtabang kandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tô mga igapil kandan si Maria na taga Magdala, tô sangé din si Maria na innà katô mallaki na si Santiago asta si Jose, asta tô sawa i Sebedeo. ");
INSERT INTO bgs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tô mapun dán, igdunggù tô ágkaduwánnan na ágngadanan ki Jose na taga Arimatea na igpamaké ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Igsadun si Jose tun ki Pilato, asta igpamuyù din tô lawa i Jesus ébô lábbángngán din. Igkagi si Pilato na bággén tô lawa kandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na, igkangé i Jose tô lawa i Jesus tikud tun ta krus, asta igtángngás din katô mantu mapputì óggét. ");
INSERT INTO bgs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Duwán lábbáng na mantu igpému i Jose para kandin tun ta pangpang, asta tô gó tô iglábbángngan din katô lawa i Jesus. Iglilid din tô dakál batu na pagsagpáng katô lábbáng, asta igpanó sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Igunsad si Maria na taga Magdala asta tô sangé din tun ta tubang katô lábbáng. ");
INSERT INTO bgs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagkasimag, dalám ka álló ka kapaginawa, igsadun tun ki Pilato tô mga Pariseo asta tô mallayat ka mga pangulu ka templo. ");
INSERT INTO bgs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Igkagi sikandan, na mà dan, “Sir, duwán isampáttan dé. Tô ándà pa kamaté tô manubù na mà kagi Mesiyas, igkagi sikandin na manté puman tun ta ikatállu álló. ");
INSERT INTO bgs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Purisu madigár ka pabantéyan nu tô iglábbángngan kandin ka mga sundalo dalám ka tállu álló agó takón katô mga disipulu din tô lawa din asta mulit dan na inanté dán sikandin. Atin ka makalimbung dan na mà kagi inanté sikandin, tuu pa madat ka tandingán katô una kalimbung din.” ");
INSERT INTO bgs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Purisu igkagi si Pilato, na mà din, “Óó. Patákkás yu tô mga sundalo, asta tuu yu pabantéyi tô iglábbángngan kandin.” ");
INSERT INTO bgs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Purisu igsadun dan tun ta lábbáng, asta igtaguan dan ka pató tô dakál batu na igsagpáng ébô ándà makahu. Igpabantéyan dan katô mga sundalo. ");
INSERT INTO bgs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na, pángnga katô álló ka kapaginawa, tô ándà pa silat tô álló ka sállám ka Linggo, igsadun si Maria na taga Magdala asta tô sangé din tun ta iglábbángngan ki Jesus ébô mahà. ");
INSERT INTO bgs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tigkô dád tuu iglinug, su duwán panaligan katô Áglangngagán na igpónóg tikud tun ta langit, iglilid din tô dakál batu na igsagpáng katô lábbáng, asta igunsadan din. ");
INSERT INTO bgs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tuu pakasirang tô bónnóng din iring na kirám, asta tuu mapputì tô umpak din. ");
INSERT INTO bgs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Igkárkár tô mga sundalo na igbanté tingód katô máddang dan, asta ibantang dan tun ta tanà iring na inaté. ");
INSERT INTO bgs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Igkagi tô panaligan tun ta mga gabayi, na mà din, “Yakó ágkamáddangan. Isóddóran ku na ágpamasakán yu si Jesus na igpansalan tun ta krus. ");
INSERT INTO bgs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ándà dini sikandin su inanté dán puman. Tô gó é igkagi din dángngan. Padani kó asta sállág yu ni igpadággaan kandin. ");
INSERT INTO bgs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, sékót kó tun ta mga disipulu din, asta uliti yu sikandan na inanté dán sikandin. Muna sikandin kandan tun ta probinsya ka Galilea. Kitanán dan sikandin dutun. Yakó yu ágkalingawi ni igkagi ku ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Purisu sékót dan igpanó tikud tun ta lábbáng. Agad imáddangan dan, asal idayawan dan. Igpalaguy dan ébô mulit dan katô mga disipulu i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tigkô dád igpakita si Jesus kandan tun ta dalan, asta igkagi sikandin, na mà din, “Madigár sállám!” Igpadani dan tun ki Jesus, igawidan dan tô paa din, asta igpangadap dan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Igkagi si Jesus, na mà din, “Yakó ágkamáddangan. Sadun kó tun ta mga kataladi ku, asta kagiyi yu sikandan na madun dan tun ta Galilea, su kitanánna ikandan dutun.” ");
INSERT INTO bgs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na, róggun igpanó tô mga gabayi, igsadun tun ta Jerusalem tô mga sundalo na igbanté katô lábbáng. Igulit dan katô mallayat ka mga pangulu ka templo tingód katô langun na ilumu. ");
INSERT INTO bgs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Purisu igpalimudé dan asta tô mga ágtugállán ka Judio, asta igpatóngkóé dan. Dakál tô salapì na igbággé dan tun ta mga sundalo, ");
INSERT INTO bgs_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asta igkagi sikandan, na mà dan, “Ulit kó katô duma mga manubù na róggun ágtudug kó tô dukilám, igsadun tô mga disipulu din asta igtakó dan tô lawa din. ");
INSERT INTO bgs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Atin ka makasóddór tô gobernador, sikami tô tumóngkô kandin ébô ándà madat na makadunggù ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Purisu igtanggap katô mga sundalo tô salapì, asta igbánnal dan katô igkagi kandan. Tô gó tô gulit-ulitán katô mga Judio sippang áknganni. ");
INSERT INTO bgs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na, igsadun tô sapulù sábbad (11) disipulu i Jesus tun ta Galilea sippang tun ta pabungan na igpasadunan i Jesus kandan. ");
INSERT INTO bgs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tô igkita dan kandin, igpangadap dan kandin. Asal ágduwa-duwa tô mga duma ka bánnal gó si Jesus tô igkita dan. ");
INSERT INTO bgs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Igpadani si Jesus tun kandan, asta igkagi sikandin, na mà din, “Igpapanguluwad katô langun tun ta langit asta dini ta banuwa. ");
INSERT INTO bgs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Purisu sadun kó asta imu yu na mga disipulu tô mga manubù tun ta langun banuwa. Bunyagi yu sikandan ukit ka ngadan katô Ámmà na Manama, katô Batà, asta katô Ugis Espiritu. ");
INSERT INTO bgs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tinurui yu sikandan na kailangan tumuman dan katô langun igkagi ku ákniyu. Yakó yu ágkalingawi na inalayunna dumuma ákniyu sippang tun ta ágtamanán kani banuwa.”");
INSERT INTO bgs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ni gó tô katigkanayan katô Madigár Gulitán tingód ki Jesu-Cristo na Batà ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na, igsulat katô propeta sayyan na si Isaias tô kagi ka Manama, na mà din, “Duwán sábbad manubù na papiddán ku muna áknikó ébô taganaán tô ukitan nu. ");
INSERT INTO bgs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mabákkár tô kóllaó din tun ta disyerto, ‘Taganà yu tô ukitanan katô Áglangngagán. Tullid yu tô dalan na ukitan din.’” ");
INSERT INTO bgs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na, si Juan na Tarabunyag tô igsadun tun ta disyerto asta igulit-ulit sikandin na kailangan rumákkád tô mga manubù ka mga salà dan asta bunyagan dan ébô pasinsiyaan dan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Marapung tô mga manubù tikud tun ta mga lunsud na sakup ka probinsya ka Judea asta tikud tun ta lunsud ka Jerusalem na igsadun tun ki Juan ébô maminág kandin. Igrákkád dan katô mga salà dan, asta igbunyagan din sikandan tun ta Wayig ka Jordan. ");
INSERT INTO bgs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na, tô umpak i Juan igabál tikud tun ta bulbul ka mannanap na kamelyo, asta tô állán din kindal ka mannanap. Ágkannán din tô mga apang asta tánnáb na ágkangén din tun ta disyerto. ");
INSERT INTO bgs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Igulit-ulit sikandin, na mà din, “Duwán pa dumunggù na tuu pa mallayat tô kamanubuan din ka tandingán kanak. Purisu ánnà nángngà agad lumingkóódda ébô lumusut dád katô sandalyas din. ");
INSERT INTO bgs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sakán ágbunyag dád ákniyu ka wayig. Asal sikandin tô munyag ákniyu ka Ugis Espiritu.” ");
INSERT INTO bgs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na, ándà kadugé, igpanó si Jesus tikud tun ta lunsud ka Nazaret na sakup ka probinsya ka Galilea, igsadun sikandin tun ta Wayig ka Jordan, asta igpabunyag ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tô igiwà si Jesus tikud tun ta wayig, tigkô dád igkita din tô langit na ipókéan asta igsunnad tô Ugis Espiritu tun kandin na iring na salapati. ");
INSERT INTO bgs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Duwán kagi tikud tun ta langit, na mà din, “Sikuna tô kanak Batà na ágginawaan ku. Ágkadayawanna gó áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na, tigkô dád igpid katô Ugis Espiritu si Jesus tun ta disyerto. ");
INSERT INTO bgs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Dalám ka kappatan (40) álló, igóddô sikandin tun ta disyerto asta igtintal i Maibuyan. Duwán magani mga mannanap ka kabánnássan dutun, asta duwán mga panaligan ka Manama na igtabang ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, pángnga igpriso si Juan na Tarabunyag, igsadun si Jesus tun ta probinsya ka Galilea, asta igulit-ulit sikandin katô Madigár Gulitán tikud tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Igkagi sikandin, na mà din, “Ituman dán tô álló na taganà igtandô, asta masig dán mangulu tô Manama. Purisu rákkád kó ka mga salà yu, asta bánnal kó katô Madigár Gulitán.” ");
INSERT INTO bgs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na, róggun igpanó si Jesus tun ta ligad ka Ranó ka Galilea, igkita din tô duwa mataladi gamama na si Simon asta tô adi din na si Andres. Igpamukut dan su taraággut dan ka sáddà. ");
INSERT INTO bgs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Igkagi si Jesus tun kandan, na mà din, “Tákkás kó kanak, su tinuruan ku sikiyu na mággut ka mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tigkô dan igtananan tô mga pukut, asta igtákkás dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Igpanayun si Jesus igpanó tun ta ágkónaan, asta igkita din si Santiago asta tô adi din na si Juan na duwa gabatà i Sebedeo. Tun dan ta barangé, su ágpiyà dan ka mga pukut. ");
INSERT INTO bgs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tigkô dád, igtawar dan i Jesus. Igtananan dan tô ámmà dan tun ta barangé asta tô mga taralumu din, asta igtákkás dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na, igsadun si Jesus asta tô mga disipulu din tun ta lunsud ka Capernaum. Tô álló ka kapaginawa ka mga Judio, igsadun si Jesus tun ta simbaan dan, asta igtinurù sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Isalábbuan tô langun manubù na igpaminág katô igtinurù din, su duwán katulusan katô katinurù i Jesus na ánnà iring katô katinurù ka mga taratinurù ka sugù. ");
INSERT INTO bgs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na, tun ta simbaan dan, tigkô dád duwán sábbad manubù na igahuwan ka madat espiritu. ");
INSERT INTO bgs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Igullaó sikandin, na mà din, “Jesus taga Nazaret, ándà labut nu áknami. Supakan ké ikuna? Isóddóran ku ka sadan ka. Sikuna tô ugis Batà ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Asal igsapadan i Jesus tô madat espiritu, na mà din, “Yaka gótép! Luwà ka tikud tun kandin!” ");
INSERT INTO bgs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na, igpatuyù-tuyù katô madat espiritu tô manubù, igullaó sikandin, asta igluwà tikud tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na, isalábbuan tô langun manubù, asta igpénsaé sikandan, na mà dan, “Ándin ni? Mantu ni ágtinuruán? Su ágsuguán din tô madat mga espiritu, asta ágnunug dan kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Purisu ibantug si Jesus tun ta kaluwagan ka probinsya ka Galilea. ");
INSERT INTO bgs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na, tigkô igpanó si Jesus tikud tun ta simbaan ka Judio, asta igsadun sikandin tun ta balé i Simon asta i Andres. Igtákkás pagsik si Santiago asta si Juan. ");
INSERT INTO bgs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na, tô timpo tô, ágkalinturan tô bayi na ugang i Simon, asta tigkô igulitan dan si Jesus tingód kandin. ");
INSERT INTO bgs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Purisu igsadun si Jesus tun kandin, igawidan i Jesus tô bállad din, asta igpatindág din. Tigkô dád inólian sikandin asta igbuwat ka ágkannán kandan. ");
INSERT INTO bgs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tô igsalláp dán tô álló, igpid katô mga manubù tô langun ágkabógókan asta igahuwan ka madat espiritu. ");
INSERT INTO bgs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ilimud tô langun taga Capernaum tun ta tubang katô balé. ");
INSERT INTO bgs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Igdappánnan i Jesus ka bállad din tô marapung manubù na duwán ássa-ássa bógók, asta inólian dan. Marapung tô madat mga espiritu na igpaluwà din, asal igsapadan din sikandan ébô dì dan pakakagi, su isóddóran dan ka sadan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na, pagkasimag, tô ándà pa silat tô álló, igánnó si Jesus, asta igsadun sikandin tun ta lugar na ándà manubù ébô dumasal. ");
INSERT INTO bgs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Igpamasak sikandin i Simon asta katô mga kadumaan din. ");
INSERT INTO bgs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tô igkita dan kandin, igkagi sikandan, na mà dan, “Tô langun igpamasak áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Asal igkagi si Jesus, na mà din, “Madun ki tun ta ássa mga lunsud ébô mulit-ulitta pagsik dutun, su tô gó tô gunayan ku na igsadunna kannun ta banuwa.” ");
INSERT INTO bgs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na, igsadun si Jesus tun ta langun lunsud tun ta kaluwagan ka probinsya ka Galilea, asta igulit-ulit sikandin tun ta mga simbaan ka Judio. Igpaluwà din tô madat mga espiritu tikud tun ta mga manubù na igahuwan. ");
INSERT INTO bgs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na, duwán sábbad tétékán na igpadani tun ki Jesus. Iglingkóód sikandin, igpédu-édu asta igkagi, na mà din, “Atin ka kakalyag nu, isóddóran ku na makólì ka kani bógók ku.” ");
INSERT INTO bgs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Inéduwan si Jesus kandin, asta igdappánnan din ka bállad sikandin, asta igkagi si Jesus, na mà din, “Malyagga. Kólian kad.” ");
INSERT INTO bgs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tigkô dád inólian sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Maggát igsapad si Jesus kandin, na mà din, “Dì mému ka ulitan nu tô agad sadan manubui. Asal sadun ka tun ta pangulu ka templo, asta pakita nu yan lawa nu. Bággé nu tô manuk na góbbón tun ta saruwan ka Manama, su tô gó tô igsugù i Moises ébô makasóddór tô langun manubù na inólian kad.” Igpapanó i Jesus sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Asal tô kapanó din, marapung tô mga manubù na igulitan din tingód katô iglumu i Jesus kandin. Purisu dì pakókit si Jesus tun ta mga lunsud na pakita katô mga manubù agó marapung tô mga malimud. Asal igóddô si Jesus tun ta madiyù ka lunsud, asta marapung tô mga manubù na igsadun tun kandin tikud tun ta langun lunsud. ");
INSERT INTO bgs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na, itagad-tagad dán, igulì si Jesus tun ta Capernaum, asta duwán mga manubù na igdinág na igóddô sikandin tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Purisu marapung tô mga manubù na ilimud tun ta luwà katô balé, asta igpaliggátté dan madani tun ta sállat tun ta luwà. Róggun igulit-ulit si Jesus katô kagi ka Manama kandan, ");
INSERT INTO bgs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","igdunggù tô áppat manubù na igié ka kadumaan dan na dì ágriyu é lawa. ");
INSERT INTO bgs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ándà dan ikapadani tun ki Jesus su tuu marapung tô mga manubù na ilimud. Purisu igpénék dan tun ta pattad atáp katô balé. Igbóbbówan dan tô atáp tun ta táppad i Jesus. Igtuntun dan tô ágdággaan katô manubù na dì ágriyu é lawa. ");
INSERT INTO bgs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tô igkita si Jesus katô kasarig dan kandin, igkagi sikandin tun ta manubù na dì ágriyu é lawa, na mà din, “Igpasinsiyaan dán tô mga salà nu.” ");
INSERT INTO bgs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, duwán mga taratinurù ka sugù na igunsad dutun, asta igpanámdám dan, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ánnà nángngà tô igkagi kani manubù ni! Igpagunawa sikandin katô Manama, su Manama dád tô makapasinsiya ka mga salà.” ");
INSERT INTO bgs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na, tigkô isóddóran i Jesus tô panámdám dan, asta igkagi sikandin, na mà din, “Yakó ágpanámdám iring kanan. ");
INSERT INTO bgs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Atin ka matággas tô pagtuman ka kagi tun ta manubù na dì ágriyu é lawa, na, ‘Igpasinsiyaan dán tô mga salà nu,’ matággas pagsik tô pagtuman ka kagi, na, ‘Tindág ka, pid nu yan ágdággaan nu, asta panó ka.’ ");
INSERT INTO bgs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Asal su sakán tô Igpamanubù, pakitanán ku ákniyu na duwán igpapid kanak ébô makapasinsiya a katô masalà-salà mga manubù dini ta banuwa.” Purisu igkagi si Jesus tun ta manubù na dì ágriyu é lawa, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tindág ka. Pid nu yan ágdággaan nu, asta ulì kad.” ");
INSERT INTO bgs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Purisu igtindág sikandin, tigkô din dád igpid tô igdággaan din, asta igulì róggun na ágsállág tô langun manubù. Purisu isalábbuan dan, asta igdurung dan tô Manama, na mà dan, “Ándà palang igkita ta iring kani!” ");
INSERT INTO bgs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na, igsadun puman si Jesus tun ta ligad ka Ranó ka Galilea. Ilimud tô langun manubù tun kandin, asta igtinurù sikandin kandan. ");
INSERT INTO bgs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tô igpanó si Jesus, igkita din tô sábbad taralimud ka buwis na ágngadanan ki Levi na batà i Alfeo na igunsad tun ta opisina din. Igkagi si Jesus tun kandin, na mà din, “Tákkás ka kanak.” Purisu igtindág si Levi, asta igtákkás ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na, róggun igkan si Jesus asta tô mga disipulu din tun ta balé i Levi, igkan pagsik tô marapung mga taralimud ka buwis asta duma mga manubù na masalà-salà, su marapung dan na igtákkás ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Duwán mga taratinurù ka sugù na sakup ka mga Pariseo. Tô igkita dan na igkan si Jesus na igduma katô mga taralimud ka buwis asta duma mga manubù na masalà-salà, igkagi sikandan tun ta mga disipulu din, na mà dan, “Manan ka igkan sikandin duma katô mga taralimud ka buwis asta katô duma mga manubù na masalà-salà?” ");
INSERT INTO bgs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tô igdinág si Jesus katô igkagi dan, igkagi sikandin, na mà din, “Tô manubù na ándà bógók, dì sikandin kailangan bawian ka doktor. Asal tô manubù na ágkabógókan, tô dád gó tô kailangan bawian ka doktor. Igsadunna dini ánnà ébô pamasakán ku tô mga manubù na ágbánnal katô mga sugù ka Manama, asal pamasakán ku tô mga masalà-salà.” ");
INSERT INTO bgs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na, inalayun ágpuwasa tô mga disipulu i Juan, asta ágpuwasa tô mga Pariseo. Duwán mga manubù na igpadani tun ki Jesus, asta igkagi sikandan, na mà dan, “Ágpuwasa tô mga disipulu i Juan, asta ágpuwasa tô mga disipulu katô Pariseo. Manan ka dì ágpuwasa tô áknikó mga disipulu?” ");
INSERT INTO bgs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Igkagi si Jesus, na mà din, “Atin ka duwán kalimudan ka kasal, tô mga kadumaan katô mama na ágkasalán, dì dan ágkaranu róggun ka dutun pa tô mama na ágkasalán. ");
INSERT INTO bgs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Asal duwán álló na dumunggù na kangén tikud tun kandan tô mama na ágkasalán, asta tô gó é álló na muwasa dan.” ");
INSERT INTO bgs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Igkagi si Jesus, na mà din, “Dì mému ka mantu óggét na ándà pa labayi tô pagtapóng katô tapé umpak. Atin ka tô gó é lumun, kumáskás tô pagtapóng, asta dumakál pa tô bissé katô umpak. ");
INSERT INTO bgs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Atin ka dalámmán tô bino na mantu igimu tun ta ágtaguanan na igimu tikud tun ta kindal ka kambing, dì mému dalámman tô tapé dán iglanit. Su atin ka tô gó é lumun, murà tô bino, máttu tô ágtaguanan, kólaan tô bino, asta kadattan tô ágtaguanan. Asal kailangan dalámmán tô bino na mantu igimu tun ta ágtaguanan na mantu iglanit.” ");
INSERT INTO bgs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na, dalám katô álló ka kapaginawa ka mga Judio, igukit si Jesus asta tô mga disipulu din tun ta ligad ka kinamát na igparámmasan ka trigo. Igbagtì katô mga disipulu din tô mga kanguy ka trigo. ");
INSERT INTO bgs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Purisu igkagi tô mga Pariseo tun ki Jesus, na mà dan, “Ku! Iglapas tô mga disipulu nu katô sugù, su dì mému kumáttu dalám ka álló ka kapaginawa.” ");
INSERT INTO bgs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Igkagi si Jesus, na mà din, “Ilingawan yu basì ka ándin tô igsulat tun ta kagi ka Manama tingód katô iglumu i David sayyan. Igballus sikandin asta tô mga kadumaan din, su ándà palang ágkannán dan. Tô timpo tô, si Abiatar tô tuu mallayat ka pangulu ka templo. ");
INSERT INTO bgs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Igahu si David tun ta balé ka Manama, asta igkan din tô pan na igbággé tun ta Manama. Duwán pagsik pan na igbággé din tun ta mga kadumaan din. Agad tô mga pangulu ka templo dád tô mému kuman katô pan, asal ándà ikasalà si David.” ");
INSERT INTO bgs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Igkagi si Jesus, na mà din, “Igimu ka Manama tô mga manubù ánnà para katô álló ka kapaginawa, asal igimu din tô álló ka kapaginawa para katô kadigárran ka mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Purisu sakán na Igpamanubù tô mému kumagi ka ándin tô nángngà lumun ka mga manubù dalám ka álló ka kapaginawa.” ");
INSERT INTO bgs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na, igsadun si Jesus tun ta simbaan ka Judio. Duwán sábbad manubù dutun na igkángkáng é bállad. ");
INSERT INTO bgs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Duwán mga Pariseo dutun na ágpamasak ka dimanda dan tingód ki Jesus. Purisu marag dan igsállág ka dumappán si Jesus kandin ébô kólian dalám ka álló ka kapaginawa. ");
INSERT INTO bgs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Igkagi si Jesus tun ta manubù na igkángkáng é bállad, na mà din, “Tindág ka dini madani kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na, igkagi si Jesus tun ta mga Pariseo, na mà din, “Tingód ka mga sugù ka Manama, ándin tô mému lumun ta dalám ka álló ka kapaginawa? Lumun ta tô madigár, ó lumun ta tô madat? Tabangan ta tô manubù, ó matayan ta tô manubù?” Asal ándà palang igtaba dan. ");
INSERT INTO bgs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na, igsállág i Jesus tô langun manubù. Isókó sikandin asta iranu tingód ka katággasan katô ulu dan. Igkagi sikandin tun ta manubù na igkángkáng é bállad, na mà din, “Káttáng nu yan bállad nu.” Igkáttáng din, asta inólian. ");
INSERT INTO bgs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Asal igluwà tô mga Pariseo tikud tun ta simbaan, asta tigkô dád igpatóngkóé dan asta tô mga manubù na igpasakup ki Herodes ka ándin tô lumun dan ébô matayan dan si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na, igpanó si Jesus asta tô mga disipulu din, asta igsadun dan tun ta ligad ka ranó. Marapung tô mga manubù na igtákkás kandan tikud tun ta probinsya ka Galilea asta probinsya ka Judea, ");
INSERT INTO bgs_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","asta mga taga Jerusalem, asta tikud tun ta probinsya ka Edumea, asta tikud tun ta dipag ka Wayig ka Jordan, asta marapung tikud tun ta madani katô lunsud ka Tiro asta Sidon. Tô igdinág dan tingód katô mga kasalábbuan na iglumu i Jesus, igsadun dan tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Igkagiyan i Jesus tô mga disipulu din na taganaán dan tô barangé na sakayan din ébô dì sikandin ágkaliggát katô mga manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Marapung tô mga manubù na igdappánnan din ka bállad ébô kólian. Purisu marapung tô mga ágkabógókan na igpadani tun kandin ébô makawid kandin asta kólian dan. ");
INSERT INTO bgs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Igsadun tun kandin tô mga manubù na igahuwan ka madat espiritu. Tô igkita dan kandin, iglangkáb dan tun ta saruwan din asta igullaó sikandan, na mà dan, “Sikuna tô bánnal Batà ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Asal maggát igsapad si Jesus na kailangan ándà palang manubù na ulitan dan tingód kandin. ");
INSERT INTO bgs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na, igtikáddág si Jesus tun ta pabungan, asta igtawar din tô mga manubù na igsalin din, asta igsadun dan tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Duwán sapulù duwa (12) disipulu na igsalin din ébô inalayun mákkás kandin. Tô gó tô mga igpapid din ébô mulit-ulit katô Madigár Gulitán, ");
INSERT INTO bgs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","asta igbággé din kandan tô katulusan ébô makapaluwà dan katô madat mga espiritu na igahu tun ta manubù. ");
INSERT INTO bgs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ni gó tô mga ngadan katô igsalin din, si Simon na ágngadanan i Jesus ki Pedro, ");
INSERT INTO bgs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tô duwa gabatà i Sebedeo na si Santiago asta si Juan na ágngadanan i Jesus ki Boanerges. (Tô kóbadan, “dì mataló.”) ");
INSERT INTO bgs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Igsalin din pagsik si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago na batà i Alfeo, si Tadeo, si Simon na magani, ");
INSERT INTO bgs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","asta si Judas Iscariote na igpammát ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na, igulì si Jesus, asta marapung tô mga manubù na ilimud puman tun kandin. Purisu si Jesus asta tô mga disipulu din ándà dán oras dan para kuman. ");
INSERT INTO bgs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tô igdinág tô mga pamilya i Jesus, igsadun dan tun kandin ébô kangén sikandin, su ágkagi tô mga manubù na ágkangulág sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Duwán mga taratinurù ka sugù na igdunggù tikud tun ta Jerusalem, asta igkagi dan tingód ki Jesus, na mà dan, “Igahuwan sikandin katô pangulu ka madat mga espiritu na si Belsebul. Ukit katô katulusan i Maibuyan makapaluwà sikandin ka madat mga espiritu tikud tun ta manubù.” ");
INSERT INTO bgs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Asal igtawar si Jesus kandan, asta igtinurù sikandin kandan ukit kani panunggiringan, na mà din, “Dì gó ágpéwà si Maibuyan katô mga sakup din tikud tun ta manubù. ");
INSERT INTO bgs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Atin ka ágpamatayé tô mga sakup ka sábbad pangulu, dì madugé mandà tô pagpangulu din. ");
INSERT INTO bgs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Atin ka ágpamatayé tô sábbad pamilya, dì madugé padiyaé dan. ");
INSERT INTO bgs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Atin ka sumulung si Maibuyan katô kandin mga sakup, dì manayun tô pagpangulu din su mandà gó ni. ");
INSERT INTO bgs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Atin ka mabákkár tô manubù, dì kahuwan tô balé din asta dì kangén tô kaduwánnan din. Asal atin ka dumunggù tô ássa manubù na tuu pa mabákkár ka tandingán kandin, tô gó é makabagkás katô tigatun ka balé asta makakangé katô langun tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Paminág yu ni kagin ku ákniyu. Tô manubù na masalà-salà, atin ka rumákkád sikandin, mému kapasinsiyaan ka Manama, agad kumagi sikandin ka madat tingód katô Manama. ");
INSERT INTO bgs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Asal tô manubù na ágkagi ka madat tingód katô Ugis Espiritu, tô gó tô salà na dì gó kapasinsiyaan.” ");
INSERT INTO bgs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tô gó é igkagi i Jesus tun ta mga taratinurù ka sugù, su igkagi sikandan na igahuwan sikandin ka madat espiritu. ");
INSERT INTO bgs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na, igdunggù tô innà i Jesus asta tô mga kataladi din. Igtindág sikandan tun ta luwà ka balé, asta duwán igpatawar dan kandin. ");
INSERT INTO bgs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Marapung tô mga manubù na igunsad madani tun ki Jesus, asta duwán igkagi kandin, na mà dan, “Tun ta luwà tô innà nu asta tô mga kataladi nu. Kakalyag dan kun na tumóngkô áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Asal igkagi si Jesus, na mà din, “Kagin ku ákniyu ka sadan tô innà ku asta tô mga kataladi ku.” ");
INSERT INTO bgs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na, igsállág si Jesus tun ta langun manubù na igunsad na iglibut kandin, asta igkagi sikandin, na mà din, “Ni gó tô innà ku asta tô mga kataladi ku! ");
INSERT INTO bgs_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tô mga manubù na ágbánnal ka kagi katô Manama, sikandan tô mému na innà ku asta mga kataladi ku na gamama asta gabayi.” ");
INSERT INTO bgs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na, duwán álló na igtinurù puman si Jesus tun ta ligad ka ranó. Su iglibutan sikandin katô marapung manubù, igsaké sikandin tun ta barangé na igpundowan tun ta ranó ébô tuminurù. Igtindág tô langun manubù tun ta ligad ka ranó ébô maminág kandin. ");
INSERT INTO bgs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Marapung tô kabánnalan na igtinurù din kandan ukit ka panunggiringan. Tô igtinurù si Jesus, igkagi sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Paminág kó kanak! Duwán sábbad manubù na igsadun tun ta kinamát din ébô sumabud ka bánnì. ");
INSERT INTO bgs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tô igsabud din tô bánnì, duwán isabud tun ta dalan, asta igtuktuk katô mga manuk ta kayun. ");
INSERT INTO bgs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Duwán ássa bánnì na isabud tun ta batun na délák dád tô tanà. Sékót igtubù, su ánnà madalám tô tanà. ");
INSERT INTO bgs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tô igménit dán tô álló, ilanás asta inaté, su ándà tuu ikaramut. ");
INSERT INTO bgs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Duwán ássa bánnì na isabud tun ta tángngaan katô dugin sigbát. Asal itambunan katô dugin sigbát tô pamula, asta inaté. Purisu ándà ikabuuy. ");
INSERT INTO bgs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Asal duwán bánnì na isabud tun ta malambù tanà. Tô gó tô madigár é tubù. Igdakál asta igbuuy ka tállu pulù (30), ó kannámman (60), ó ginatus-gatus.” ");
INSERT INTO bgs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Igkagi si Jesus, na mà din, “Purisu kailangan maminág kó ébô makagpát kó.” ");
INSERT INTO bgs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na, tô igpanó dán tô karapungan ka mga manubù, duwán mga kadumaan katô sapulù duwa (12) disipulu i Jesus na iginsà kandin tingód katô mga panunggiringan na igtinurù din. ");
INSERT INTO bgs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Igkagi si Jesus, na mà din, “Sikiyu tô igpakitaan ka Manama katô kabánnalan na ándà din pasóddóri dángngan tingód katô pagpangulu din. Asal ukit dád tun ta mga panunggiringan tô katinurù ku katô duma mga manubù ");
INSERT INTO bgs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ébô agad sumállág dan, dì dan makakita katô kóbadan. Agad maminág dan, dì dan makagpát katô kabánnalan agó rumákkád dan asta pasinsiyaan dan.” ");
INSERT INTO bgs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na, igkagi si Jesus, na mà din, “Atin ka ándà kó ikagpát kani panunggiringan, dì kó makagpát katô langun panunggiringan na ágtinuruán ku. ");
INSERT INTO bgs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tô manubù na igsabud ka bánnì, iring sikandin katô manubù na ágtinurù ka kagi ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tô bánnì na isabud tun ta dalan, iring katô mga manubù na ágpaminág ka kagi ka Manama, asal tigkô dád ágsadunan i Maibuyan ébô agón din tô kagi ka Manama na igdinág dan. ");
INSERT INTO bgs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tô bánnì na isabud tun ta batun, iring katô mga manubù na ágpaminág ka kagi ka Manama, asta sékót dan ágtanggap na duwán dayó dan. ");
INSERT INTO bgs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Asal ka kahirapan asta kérrayatan dan tingód ka kabánnal dan katô kagi ka Manama, sékót ágkandà tô kabánnal dan, su iring dan katô pamulanán na ándà tuu ramut. ");
INSERT INTO bgs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na, tô bánnì na isabud tun ta tángngaan ka dugin sigbát, iring katô mga manubù na ágpaminág katô kagi ka Manama na igtinurù. ");
INSERT INTO bgs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Asal talun dan katô sasó tingód ka kantayan dan, katô kakalyag dan na kaduwánnan, asta ássa mga kakalyag dan. Purisu ándà ágpulusán dan katô kagi ka Manama na igdinág dan. ");
INSERT INTO bgs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Asal tô bánnì na isabud tun ta malambù tanà, iring katô mga manubù na ágpaminág katô kagi ka Manama, asta ágbánnal dan. Duwán gó ágpulusán dan iring katô madigár é tubù na igbuuy ka tállu pulù (30), ó kannámman (60), ó ginatus-gatus.” ");
INSERT INTO bgs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na, igkagi si Jesus, na mà din, “Atin ka ágrákkáttan é sulù, dì ágtambunan, asta dì taguán tun ta siráb ka katri. Asal madigár ka ágsapatán. ");
INSERT INTO bgs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na, ándà palang gállássán áknganni na dì pakitanán tun ta tapuri álló. Ándà pagsik ágbulunán áknganni na dì pasóddórán tun ta tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kailangan maminág kó ébô makagpát kó.” ");
INSERT INTO bgs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Igkagi si Jesus, na mà din, “Kailangan bánnalán yu tô igdinág yu. Atin ka mággár-ággár kó tumuman katô igdinág yu, dakál tô kagpáttan yu, asta dugangan ka Manama tô inagpáttan yu. ");
INSERT INTO bgs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tô manubù na ágbánnal katô kabánnalan, tô gó é dugangan katô kabánnalan ébô tuu pa dakál. Asal tô manubù na dì ágbánnal katô kabánnalan, tô gó é kangayan katô kabánnalan.” ");
INSERT INTO bgs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na, igkagi si Jesus, na mà din, “Iring kani tô pagpangulu ka Manama. Atin ka sumabud tô manubù ka bánnì tun ta kinamát din, ");
INSERT INTO bgs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ándà tana din tingód ka karáttáb katô bánnì agad álló asta dukilám, su manayun tumubù asta dumakál tô igsabud din agad ándà din kagpátti tô tingód ka karáttáb katô bánnì. ");
INSERT INTO bgs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Inalayun tumubù tô sabudán tun ta tanà, su muna dumakál, asta dumaun, asta muuy. ");
INSERT INTO bgs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Atin ka malutù dán tô buuy, káttun ka manubù, su igdunggù dán tô álló ka kakáttu.” ");
INSERT INTO bgs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na, igkagi si Jesus, na mà din, “Mulittad ákniyu tingód ka pagpangulu ka Manama ukit kani panunggiringan. ");
INSERT INTO bgs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tuu délák tô lisu ka mustasa na ágpamulan ka manubù tun ta kinamát din. Agad tuu pa délák tô lisu ka mustasa ka tandingán katô langun ka duma mga lisu, ");
INSERT INTO bgs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","asal ka mapamula dán, ágtubù asta ágkému na tuu pa dakál ka tandingán ka langun ka duma mga pamula. Magdakál tô mga panga, asta ágsalagan katô mga manuk ta kayun.” ");
INSERT INTO bgs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Igtinurù si Jesus kandan ukit tun ta marapung mga panunggiringan iring kani sippang dád katô ágkagpáttan dan. ");
INSERT INTO bgs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Igpókit din tun ta panunggiringan tô langun katinurù din kandan. Asal ka ándà ássa manubù, igulit sikandin tun ta mga disipulu din ka ándin tô kóbadan katô langun panunggiringan. ");
INSERT INTO bgs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na, tô dukilám dán, igkagi si Jesus tun ta mga disipulu din, na mà din, “Tumalipag ki tun dipag ka ranó.” ");
INSERT INTO bgs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Purisu igtananan katô mga disipulu tô langun manubù na ilimud, asta igsaké dan katô barangé na taganà igsakayan i Jesus. Duwán duma mga barangé na igdángngan kandan. ");
INSERT INTO bgs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ándà kadugé, igdunggù tô mabákkár karamag. Tô barangé idalámman ka wayig. ");
INSERT INTO bgs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Asal tun ta ulin ka barangé si Jesus asta igtudug tun ta gulunan. Igánnó dan sikandin, asta igkagi sikandan, na mà dan, “Sir, tabangi ké, su malánnád kid.” ");
INSERT INTO bgs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Igánnó si Jesus, asta igpasódô din tô karamag. Igkagi sikandin tun ta mga balud, na mà din, “Sódô! Tónnók kó!” Purisu igsódô tô karamag, asta igtónnók tô mga balud katô ranó. ");
INSERT INTO bgs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Igkagi si Jesus, na mà din, “Yakó ágkamáddangan. Délák tô kasarig yu kanak!” ");
INSERT INTO bgs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tuu dan isalábbuan, asta igpatóngkóé sikandan, na mà dan, “Matulus gó kannê sikandin, su agad tô karamag asta tô mga balud ágbánnal kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na, igdunggù dan tun dipag ka ranó madani tun ta Gerasa. ");
INSERT INTO bgs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tô igpónóg si Jesus, duwán manubù na igahuwan ka madat espiritu na igsumar kandin na tikud tun ta mga takub na áglábbángnganan, ");
INSERT INTO bgs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","su tô gó é góddóan din. Ándà manubù na makabagkás kandin, agad duwán kadina, ");
INSERT INTO bgs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","su marag sikandin ágbagkássán ka kadina, asta gikáttan, asal marag din ágbugtusán tô kadina, asta ágdadattan din tô pagikát kandin. Ándà palang manubù na makawid kandin. ");
INSERT INTO bgs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Agad álló asta dukilám, góddô sikandin tun ta mga takub na áglábbángnganan asta tun ta pabunganán. Marag sikandin gullaó asta gamù-amuán din tô lawa din ka batu. ");
INSERT INTO bgs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tô igkita sikandin ki Jesus tun ta madiyù, igpalaguy sikandin na igsumar ki Jesus, asta iglingkóód. ");
INSERT INTO bgs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Igullaó tô manubù, na mà din, “Jesus, Batà ka Manama na Tuu Mallayat, yaka ágsamuk kanak! Ágpédu-éduwa áknikó tun ta saruwan ka Manama, yaka ágsamuk kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tô gó é igkagi katô madat espiritu, su taganà igkagi si Jesus kandin, na mà din, “Sikuna madat espiritu, luwà ka tikud tun kandin!” ");
INSERT INTO bgs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iginsà si Jesus, na mà din, “Sadan é ngadan nu?” Igtaba sikandin, na mà din, “Mararan, su marapung ké.” ");
INSERT INTO bgs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tuu igpédu-édu tô madat espiritu ki Jesus na dì dan pád suguán tun ta madiyù banuwa. ");
INSERT INTO bgs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tuu marapung tô mga babuy na ágsukat tun ta karaban pabunganán na dì madiyù. ");
INSERT INTO bgs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Purisu igpédu-édu tô madat mga espiritu ki Jesus, na mà dan, “Sugù ké tun ta mga babuy. Pahu ké tun kandan.” ");
INSERT INTO bgs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na, ignunug si Jesus. Purisu igluwà tô madat mga espiritu tikud tun ta manubù, asta igahu tun ta mga babuy. Igpalaguy tô langun babuy tun ta karaban, asta igtuppas dan tun ta ranó. Ilánnád tô langun dan na mga duwa mararan (2,000). ");
INSERT INTO bgs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Igpalaguy tô mga taradóppón katô mga babuy, asta igulit dan tô langun tun ta lunsud asta tun ta madani mga banuwa. Purisu igsadun tô mga manubù ébô kitanán dan tô ilumu. ");
INSERT INTO bgs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Igsadun dan tun ki Jesus, asta igkita dan tô manubù na igpaluwaan ka madat mga espiritu. Igunsad sikandin na igumpak dán, asta madigár dán tô panámdám din. Purisu imáddangan dan. ");
INSERT INTO bgs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Igulit tô mga manubù na ikakita tingód katô ilumu tun ta manubù asta tun ta mga babuy. ");
INSERT INTO bgs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Purisu igpédu-édu dan na miwà si Jesus tikud tun ta banuwa dan. ");
INSERT INTO bgs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Róggun igsaké si Jesus tun ta barangé, tô manubù na igpaluwaan ka madat mga espiritu igpédu-édu na mákkás pád sikandin ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Asal ándà nunug si Jesus, su igkagi sikandin, na mà din, “Ulì kad tun ta mga kadumaan nu, asta ulit nu kandan tô tingód katô madigár na iglumu katô Áglangngagán áknikó, asta tingód ka kédu din áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Purisu igpanó sikandin, asta igulitan din tô langun manubù tun ta sapulù (10) mga lunsud na sakup ka Dekapolis tingód katô madigár na iglumu i Jesus kandin. Purisu isalábbuan tô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na, tô igdunggù si Jesus tun dipag ka ranó, tuu marapung tô mga manubù na iglibut kandin tun ta ligad ka ranó. ");
INSERT INTO bgs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Igdunggù tô sábbad pangulu ka simbaan ka Judio na ágngadanan ki Jairo. Tô igpadani sikandin tun ki Jesus, iglingkóód sikandin, ");
INSERT INTO bgs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","asta igpédu-édu, na mà din, “Masig dán maté tô délák batà ku bayi. Sékót ka, asta dappánni nu ka bállad sikandin ébô manté.” ");
INSERT INTO bgs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Purisu igtákkás si Jesus kandin. Tuu marapung tô mga manubù na igtákkás ki Jesus, asta igpaliggátté dan na igarurung kandin. ");
INSERT INTO bgs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na, duwán sábbad bayi na gagasan ka dipanug dalám ka sapulù duwa (12) dán ámmé. ");
INSERT INTO bgs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Agad igbawian sikandin ka marapung mga doktor, asta inémmát tô langun salapì din, asal ándà sikandin kólii. Igtuu baling tô bógók din. ");
INSERT INTO bgs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Igdinág sikandin tingód ki Jesus. Purisu igládlád sikandin tun ta mga manubù ébô makapadani tun ta bókkóg i Jesus, su taganà igpanámdám sikandin, “Atin ka awidan ku dád tô umpak din, kólianna.” Purisu igawidan din tô umpak i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tigkô dád igsódô tô dipanug din, asta igriyu sikandin na inólian dán tô bógók din. ");
INSERT INTO bgs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tô igriyu si Jesus na duwán katulusan na igluwà tikud tun kandin, igsérê sikandin tun ta mga manubù na igtákkás kandin, asta iginsà sikandin, na mà din, “Sadan é igawid kani umpak ku?” ");
INSERT INTO bgs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Igkagi tô mga disipulu din, na mà dan, “Marapung tô mga manubù na igliggát áknikó. Manan ka ginsà ka ka sadan é igawid áknikó?” ");
INSERT INTO bgs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Asal igsérê-sérê pô gó si Jesus ébô kitanán din ka sadan tô igawid kandin. ");
INSERT INTO bgs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na, tô ikasóddór tô bayi na inólian dán sikandin, agad igkárkár sikandin tingód ka máddang din, igpadani sikandin tun ki Jesus, asta iglingkóód tun ta saruwan din. Igulit din tô langun na iglumu din. ");
INSERT INTO bgs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na, igkagi si Jesus katô bayi, na mà din, “Inólian kad ukit ka kasarig nu kanak. Ulì kad na duwán kasunayan. Ándà dán bógók nu.” ");
INSERT INTO bgs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Róggun igkagi pa si Jesus tun ta bayi, duwán mga manubù na igdunggù tikud tun ta balé i Jairo, asta igkagi sikandan ki Jairo, na mà dan, “Yaka ágpapanayun katô Taratinurù tun ta balé nu, su inaté dán tô batà nu.” ");
INSERT INTO bgs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Asal ándà paminággi i Jesus tô igkagi dan. Igkagi baling sikandin ki Jairo, na mà din, “Yaka ágkaranu! Bánnal ka dád kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ándà ássa manubù na igpatákkás i Jesus tun ta balé, asal si Pedro dád, si Santiago, asta tô adi i Santiago na si Juan. ");
INSERT INTO bgs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tô igdunggù dan tun ta balé i Jairo, igkita i Jesus tô mga manubù na ágkasamuk, ágsággó, asta gullaó tingód katô ranu dan. ");
INSERT INTO bgs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tô igahu si Jesus tun ta balé, igkagi sikandin, na mà din, “Yakó gótép. Yakó ágsággó. Ándà kamaté tô batà. Igtudug dád sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na, igngisiyan dan si Jesus. Asal igpéwà din tô langun dan, asta igahu sikandin tun ta kuwarto. Igpatákkás din dád tô mga disipulu din asta tô ámmà asta tô innà katô batà. ");
INSERT INTO bgs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Igawidan din tô bállad katô batà, asta igkagi sikandin, na mà din, “Talita kumi.” (Tô kóbadan, “Sumuddù, ánnó ka.”) ");
INSERT INTO bgs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tigkô dád igánnó tô batà, asta igpanó-panó, su sapulù duwa (12) tô idad din. Tuu isalábbuan tô ámmà asta tô innà katô batà. ");
INSERT INTO bgs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Asal maggát igsapad si Jesus kandan na ándà palang manubù na mému ulitan dan tingód katô ilumu. Igkagi si Jesus na pakannán dan tô batà. ");
INSERT INTO bgs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na, igpanó si Jesus, asta igulì tun ta kandin banuwa. Igtákkás tô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tô álló ka kapaginawa, igtinurù si Jesus tun ta simbaan ka Judio. Isalábbuan tô marapung manubù tingód katô igdinág dan. Purisu iginsà sikandan, na mà dan, “Ánda igkangé ni manubù ni kani ágtinuruán din? Ánda é igkangayan din kani kapandayan? Manan ka pakalumu sikandin kani mga kasalábbuan? ");
INSERT INTO bgs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Su taraimu dád ka balé sikandin, asta tô innà din si Maria. Tô mga kataladi din na si Santiago, si Jose, si Judas, asta si Simon. Tô mga tábbé din pagsik góddô dini áknita.” Purisu ándà dan tanggap kandin. ");
INSERT INTO bgs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na, igkagi si Jesus tun kandan, na mà din, “Agad ágtanggapán tô propeta ka Manama tun ta ássa banuwa, asal dì ágtanggapán katô mga manubù tun ta kandin banuwa, tun ta mga gakád din asta pamilya din.” ");
INSERT INTO bgs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Isalábbuan si Jesus su ándà dan bánnal kandin. Purisu tagsábbadé dád tô mga kasalábbuan na iglumu din dutun. Tagsábbadé dád tô mga manubù na igdappánnan din ka bállad asta inólian. Na, igsadun si Jesus tun ta mga lunsud, asta igtinurù sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na, igpaglimud din tô sapulù duwa (12) disipulu. Igbággayan din sikandan ka katulusan ébô makapaluwà dan ka madat espiritu tikud tun ta manubù, asta igpasadun din sikandan na tagduwa-duwa tun ta ássa mga lunsud. ");
INSERT INTO bgs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tô ándà dan pa panó, duwán igtalan din kandan na tukád dád tô mému piddán dan. Asal dì dan mid ka makan, kabir, ó salapì. ");
INSERT INTO bgs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mému ka ágsandalyas dan, asal dì dan mid ka umpak na gilisan. ");
INSERT INTO bgs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Igkagi si Jesus kandan, na mà din, “Atin ka ágdunggù kó tun ta balé, óddô kó dutun sippang tun ta álló ka kapanó yu tun ta ássa lunsud. ");
INSERT INTO bgs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Atin ka dì kó tanggapán katô mga manubù, asta dì dan paminággán tô ágtinuruán yu, ka panó kó tikud tun kandan, padpad yu tô barukbuk tikud tun ta paa yu ébô kasóddóran dan na duwán sókó ka Manama kandan.” ");
INSERT INTO bgs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Purisu igpanó dan, asta igulit-ulit dan na kailangan rumákkád tô langun manubù katô mga salà dan. ");
INSERT INTO bgs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Marapung tô madat mga espiritu na igpaluwà dan tikud tun ta manubù, asta marapung tô mga ágkabógókan na igpatalluan dan ka langis ka olibo, asta inólian dan. ");
INSERT INTO bgs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na, igulitan tô harì na si Herodes tingód katô áglumun i Jesus, su ágkabantug dán sikandin. Duwán mga manubù na ágkagi, na mà dan, “Sikandin basì si Juan na Tarabunyag na inanté puman. Purisu duwán katulusan din ébô imun din ni mga kasalábbuan.” ");
INSERT INTO bgs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Asal duwán mga manubù na ágkagi, na mà dan, “Sikandin si Elias na propeta sayyan.” Duwán ássa mga manubù na ágkagi, na mà dan, “Propeta gó sikandin, iring katô mga propeta sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Asal tô igdinág si Herodes tingód katô áglumun i Jesus, igkagi sikandin, na mà din, “Inanté puman si Juan na igpatampáddan ku ka alig.” ");
INSERT INTO bgs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tô gó é igkagi i Herodes, su dángngan igpammát din si Juan, asta igpapriso din. Tô gó é iglumu i Herodes ki Juan ébô kadayawan tô ipag din na si Herodias na igagó din tikud tun ta kataladi din na si Felipe. ");
INSERT INTO bgs_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Su tô igagó si Herodes katô ipag din, igkagi si Juan ki Herodes, na mà din, “Iglapas ka katô sugù ka Manama, su igagó nu tô ipag nu.” ");
INSERT INTO bgs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Purisu isókó si Herodias ki Juan, asta kakalyag din na pamatayan si Juan. Asal ándà ikému, ");
INSERT INTO bgs_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","su ágkamáddangan si Herodes ki Juan. Isóddóran din na madigár manubù si Juan tun ta saruwan ka Manama, asta ándà salà din. Purisu igpabantéyan din si Juan. Atin ka ágtóngkô si Herodes ki Juan, agad ágkalibug si Herodes, ágkadayawan sikandin ágpaminág ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na, igimu si Herodes ka kalimudan tingód katô álló din, asta igpalimud din tô langun opisyales, tô mga kapitan ka sundalo, asta tô ágkaduwánnan mga manubù tun ta Galilea. Tô gó é madigár timpo na igangatan i Herodias ébô pamatayan din si Juan. ");
INSERT INTO bgs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tô igsayó tô batà daraga i Herodias, idayawan si Herodes asta tô mga manubù na ilimud. Purisu igkagi si Herodes tun kandin, na mà din, “Agad ándin tô kakalyag nu, pamuyù nu, su bággén ku gó áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Igtandô si Herodes tun kandin, na mà din, “Agad ándin tô pamuyuán nu, tô gó é bággén ku áknikó, agad katángngà katô ágpanguluwan ku.” ");
INSERT INTO bgs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na, igluwà tô daraga, asta iginsà sikandin katô innà din, na mà din, “Ándin tô pamuyuán ku?” Igkagi si Herodias, na mà din, “Pamuyù nu tô ulu i Juan na Tarabunyag.” ");
INSERT INTO bgs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na, sékót iglónód tô daraga tun ki Herodes, asta igpamuyù, na mà din, “Tô kakalyag ku sékót bággé nu kanak tô ulu i Juan na Tarabunyag tun ta dakál pinggan.” ");
INSERT INTO bgs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tuu iranu si Herodes. Asal tingód katô tandô din, asta agó buyasán sikandin katô mga manubù na ilimud, ándà din élléyi tô daraga. ");
INSERT INTO bgs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Purisu tigkô dád igsugù i Herodes tô sundalo ébô pakangén tô ulu i Juan. Igsadun tô sundalo tun ta prisowan, asta igtampád din tô alig i Juan. ");
INSERT INTO bgs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Igtagù tô ulu i Juan tun ta dakál pinggan, igbággé tun ta daraga, asta igpid din tun ta innà din. ");
INSERT INTO bgs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tô igdinág tô mga disipulu i Juan na igmatayan sikandin, igsadun dan tun ta prisowan, igkangé dan tô lawa din, asta iglábbáng dan. ");
INSERT INTO bgs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na, tô igulì tô mga apostoles tun ki Jesus, igulit dan kandin tingód katô langun iglumu dan asta igtinurù dan. ");
INSERT INTO bgs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Igkagi si Jesus kandan, na mà din, “Patákkássé ki tun ta lugar na ándà manubù ébô makapaginawa kó dógó.” Tô gó tô igkagi din kandan su marapung tô mga manubù na marag ágsadun tun kandin, asta ándà dán timpo dan agad ágkan. ");
INSERT INTO bgs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Purisu igsaké dan ka barangé, asta igsadun dan tun ta lugar na ándà manubù. ");
INSERT INTO bgs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Asal marapung tô mga manubù na igkita katô kapanó dan, asta isóddóran dan ka sadan sikandan. Purisu igpanó dan tikud tun ta marapung mga lunsud, igpampalaguy dan, asta ikóna dan igdunggù tun ta sadunan ka barangé. ");
INSERT INTO bgs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tô igpónóg si Jesus, igkita din tô marapung manubù na igangat kandin. Inéduwan sikandin kandan, su iring dan katô itadin na mga karnero na ándà taradóppón, asta marapung tô igtinurù i Jesus kandan. ");
INSERT INTO bgs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tô mapun dán, igpadani tô mga disipulu i Jesus tun kandin, asta igkagi sikandan, na mà dan, “Ándà mga manubù na góddô kannun, asta masig dán dumukilám. ");
INSERT INTO bgs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Purisu papanó nu tô langun manubù tun ta mga lunsud asta madani mga banuwa ébô málli dan ka makan.” ");
INSERT INTO bgs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Asal igkagi si Jesus, na mà din, “Sikiyu é mággé ka makan kandan.” Igkagi sikandan, na mà dan, “Agad málli ké ka pan na bayadan ka mga duwa gatus (200) salapì denario, dì nángngà para pakannán dé kandan.” ");
INSERT INTO bgs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Igkagi si Jesus, na mà din, “Pira abuk tô pan tun ákniyu? Ahà yu.” Tô igahà dan, igkagi sikandan, na mà dan, “Lima abuk pan, asta duwa abuk sáddà.” ");
INSERT INTO bgs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na, igpónsad i Jesus tô langun manubù tun ta sigbáttán tanà. ");
INSERT INTO bgs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Purisu duwán igunsad na mga tagsábbad gatus manubù, asta duwán igunsad na mga tagkaliman é manubù. ");
INSERT INTO bgs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Igkangé i Jesus tô lima abuk pan asta tô duwa abuk sáddà. Iglangngag sikandin tun ta langit, asta igpasalamat tun ta Manama. Igtáppik-táppik din tô pan, asta igbággé din tun ta mga disipulu din ébô taladán dan tun ta mga manubù na ilimud. Igtalad din tô duwa abuk sáddà para katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ikakan tô langun manubù, asta ibássug dan. ");
INSERT INTO bgs_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Duwán pa sapulù duwa (12) magdakál basket na ipánnù katô isamà pan asta sáddà na iglimud katô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mga lima mararan (5,000) tô mga gamama na ikakan. ");
INSERT INTO bgs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tigkô dád igpóna i Jesus tô mga disipulu din na igsaké ka barangé ébô tumalipag dan katô ranó sippang tun ta Betsaida, róggun ágpólián din tô langun manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tô igpanó dan dán, igtikáddág si Jesus tun ta pabungan ébô dumasal. ");
INSERT INTO bgs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tô igsalláp dán tô álló, tô barangé tun dán ta tángngaan katô ranó, asal tun pô ta pabungan si Jesus na sábbad din dád. ");
INSERT INTO bgs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Igkita din na tuu ihirapan tô pagbugsay dan, su ikasumar dan ka mabákkár karamag. Na, tô masig dán igsállám, igsadun si Jesus tun kandan. Igpanó sikandin tun ta bówwó ka ranó. Iring na lumabé pád sikandin, ");
INSERT INTO bgs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","asal tô igkita dan na igpanó sikandin tun ta bówwó ka ranó, kéman dan ka gimukud, asta igullaó sikandan. ");
INSERT INTO bgs_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Igkita tô langun dan kandin, asta tuu dan imáddangan. Asal tigkô dád igkagi si Jesus tun kandan, na mà din, “Pasarig yu tô pusung yu, su sakán ni. Yakó ágkamáddangan.” ");
INSERT INTO bgs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na, igsaké si Jesus tun ta barangé dan, asta igsódô tô mabákkár karamag. Tuu dan isalábbuan, ");
INSERT INTO bgs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","su agad igkita dan tô kasalábbuan na iglumu i Jesus tingód ka pan, asal ándà dan ikagpát tingód katô katulusan din, su matággas tô ulu dan. ");
INSERT INTO bgs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na, tô igtalipag dan katô ranó, igdunggù dan tun ta Genesaret asta igpundo tô barangé. ");
INSERT INTO bgs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tô igpónóg dan, sékót ikakilala tô mga manubù ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Purisu igpampalaguy dan igkangé tô mga ágkabógókan tikud tun ta madani mga banuwa. Igié dan tô mga ágkabógókan, asta igpid dan tun ta lugar na idinággan dan na dutun si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Agad tun ta lunsud asta tun ta madiyù, agad ánda é ágsadunan i Jesus, igpadággà dan tô mga ágkabógókan tun ta plasa, asta igpédu-édu dan ki Jesus ka mému mawid dád tô mga ágkabógókan katô ugpu ka umpak din, asta inólian tô langun dan na ikawid. ");
INSERT INTO bgs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na, duwán mga Pariseo asta mga taratinurù ka sugù na igsadun tun ki Jesus tikud tun ta Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Igkita dan na igkan tô mga disipulu i Jesus na ándà dan damù. ");
INSERT INTO bgs_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Dì mému su tô ágkémun katô Pariseo asta langun Judio, marag dan ágdamù ka dì dan pa kuman, su inalayun dan ágbánnalán tô ágkémun na igtinurù ka mga kamónaan dan. ");
INSERT INTO bgs_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Atin ka gulì dan tikud tun ta palingki, ágdamù dan ka dì dan pa kuman. Marapung pagsik tô duma mga ágkémun na ágtumanán dan tingód ka kóras ka mga baso, mga kaldero, asta mga burunsi kasangkapan.) ");
INSERT INTO bgs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iginsà tô mga Pariseo asta tô mga taratinurù ka sugù, na mà dan, “Manan ka dì ágbánnal tô mga disipulu nu katô ágkémun ka mga kamónaan ta? Su atin ka ágkan dan, dì dan ágdamù.” ");
INSERT INTO bgs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Igkagi si Jesus, na mà din, “Kéman yu ka nángngà tô áglumun yu tun ta saruwan ka Manama. Sikiyu tô igtádduan kani kagi ka Manama na igsulat i Isaias sayyan, “‘Ágkagi tô mga manubù na ágpangadap dan kanak, asal madiyù tô pusung dan kanak. ");
INSERT INTO bgs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dì nángngà tô kapangadap dan kanak, su tô mga ágtinuruán ka manubù, tô gó tô igimu dan iring na ágtinuruán katô Manama.’ ");
INSERT INTO bgs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ágpabayaán yu tô mga sugù ka Manama, asta marag yu ágbánnalán tô mga ágkémun ka manubù.” ");
INSERT INTO bgs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Igkagi si Jesus tun kandan, na mà din, “Géllé kó katô mga sugù ka Manama ébô tumanán yu tô mga ágkémun yu! ");
INSERT INTO bgs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Igsugù tô Manama ukit ki Moises, na, ‘Respetowi yu tô ákniyu ámmà asta innà.’ Igsugù pagsik sikandin, na, ‘Kailangan matayan tô manubù na ágkagi ka madat tun ta ámmà ó innà din.’ ");
INSERT INTO bgs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Asal ágtinurù kó na mému ka dì tumabang tô manubù katô ámmà asta innà din ka kumagi dád, ‘Tô bággén ku pád ákniyu igbággé kud tun ta Manama.’ ");
INSERT INTO bgs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Purisu dì mému ákniyu na tabangan din tô ámmà asta tô innà din. ");
INSERT INTO bgs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ukit ka kabánnal yu kani ágkémun, géllé kó katô sugù ka Manama na kailangan tabangan yu tô ámmà asta innà yu. Marapung pa tô madat mga ágkémun yu iring kani.” ");
INSERT INTO bgs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na, marapung tô mga manubù na ilimud dutun, asta igtawar puman si Jesus kandan ébô madani dan tun kandin. Igkagi sikandin, na mà din, “Paminág kó langun kanak ébô makagpát kó. ");
INSERT INTO bgs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ánnà tô ágkakan na gahu tun ta babbà tô makaripà ka manubù tun ta saruwan ka Manama. Asal tô madat mga kagi na ágluwà tikud tun ta babbà din tô makaripà ka manubù tun ta saruwan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kailangan maminág kó ébô makagpát kó.” ");
INSERT INTO bgs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Na, igtanan si Jesus katô mga manubù na ilimud, asta igahu sikandin tun ta balé. Iginsà tô mga disipulu din tingód katô panunggiringan na igtinurù din. ");
INSERT INTO bgs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Igkagi si Jesus, na mà din, “Isalábbuanna su iring kó pagsik na mga manubù na dì pakagpát. Agad ándin tô ágkakan na pahun tun ta babbà ka manubù, dì ni makému kandin na maripà. ");
INSERT INTO bgs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dì manayun tô ágkakan tun ta pusung ka manubù, asal tun ta gátták, asta lumuwà tikud tun ta lawa.” Ukit kani kagi i Jesus, igpénagpát din na mému kannán tô agad ándin klasiyi ka ágkakan. ");
INSERT INTO bgs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Igkagi si Jesus, “Tô ágtikud tun ta pusung ka manubù, tô gó é makému kandin na maripà. ");
INSERT INTO bgs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pusung tô ágtikudan katô madat panámdám, paglibug, katakó, kamaté, ");
INSERT INTO bgs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kéngà, kalumu ka madat, kalimbung, kalumu ka ándà kayyà, sabù, kabuyas, kapadadurung, asta talis. ");
INSERT INTO bgs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tikud tun dalám ta pusung tô langun kani mga madat, asta kumaripà tô manubù tun ta saruwan ka Manama ukit kani langun.” ");
INSERT INTO bgs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na, igpanó si Jesus, asta igsadun sikandin tun ta probinsya na madani tun ta lunsud ka Tiro asta Sidon. Igóddô sikandin tun ta sábbad balé, asta kakalyag din na ándà pád manubù na makasóddór ka ánda sikandin, asal ándà ikallás. ");
INSERT INTO bgs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tigkô dád igdinág tô sábbad bayi na igdunggù si Jesus. Igahuwan tô batà din bayi ka madat espiritu. Purisu igsadun tô innà tun ki Jesus, asta iglingkóód tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ánnà sikandin Judio, su Griego tô mga kamónaan din, asta Fenicia na sakup ka probinsya ka Siria tô igpamasusuwan kandin. Igpédu-édu sikandin ébô paluwaán i Jesus tô madat espiritu tikud tun ta batà din. ");
INSERT INTO bgs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Asal igkagi si Jesus, na mà din, “Duwán ágkagin na kailangan unan pakannán tô mga gabatà, su dì mému ka kangén tô ágkannán ka mga gabatà ébô pakannán ka mga asu.” ");
INSERT INTO bgs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Igkagi tô bayi, na mà din, “Sir, bánnal tô igkagi nu. Asal agad tô mga asu tun ta siráb ka lamisa ágkan katô mumu na ágkadabù ka mga gabatà.” ");
INSERT INTO bgs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Igkagi si Jesus, na mà din, “Nángngà tô igkagi nu. Purisu mému mulì kad. Igluwà dán tô madat espiritu tikud tun ta batà nu.” ");
INSERT INTO bgs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na, igulì tô bayi, asta igkita din tô batà din na igdággà, asta ándà dán madat espiritu tun kandin. ");
INSERT INTO bgs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na, igpanó si Jesus tikud tun ta banuwa ka Tiro. Igukit sikandin tun ta lunsud ka Sidon asta madani tun ta banuwa ka Dekapolis sippang ka igdunggù tun ta Ranó ka Galilea. ");
INSERT INTO bgs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Duwán manubù na igpid tun kandin na bingál asta ómmó. Igpédu-édu tô mga kadumaan din na dappánnan i Jesus sikandin ka bállad. ");
INSERT INTO bgs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Purisu igpid i Jesus sikandin tun ta ándà mga manubù, asta igkórékór din ka tintudù din tô talinga katô bingál. Igiláb si Jesus asta igpólétan din ka ngingi tô dilà katô manubù. ");
INSERT INTO bgs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iglangngag si Jesus tun ta langit, igpanagkuy tingód ka kédu din, asta igkagi sikandin, na mà din, “Efata.” Tô kóbadan, “Mapókê kad.” ");
INSERT INTO bgs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tigkô dád, ikadinág tô manubù, inólian tô kalanggát din, asta ikabólós dán sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Asal igsapad si Jesus kandan na kailangan dì dan mulit katô duma mga manubù tingód katô ilumu. Agad maggát igsapad sikandin kandan, asal tuu dan pa igulit tun ta duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tuu dan isalábbuan, asta igkagi sikandan, na mà dan, “Tuu madigár tô langun iglumu din. Agad tô bingál igpadinág din, asta tô ómmó igpakagi din.” ");
INSERT INTO bgs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na, pángnga ka pira álló, tuu marapung tô mga manubù na ilimud puman ki Jesus. Tô inémmát tô ágkakan dan, igtawar i Jesus tô mga disipulu din, asta igkagi sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Inéduwanna kani mga manubù, su itálluwan dan dán na ágtákkás kanak, asta ándà dán ágkannán dan. ");
INSERT INTO bgs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Dì mému ka pólián ku sikandan na ágballusán agó kagáttasan dan tun ta dalan, su duwán mga manubù na tikud tun ta madiyù mga banuwa.” ");
INSERT INTO bgs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Igkagi tô mga disipulu din, na mà dan, “Ándà góddô kannun, asta ándà palang kangayan ta ka makan para kandan.” ");
INSERT INTO bgs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iginsà si Jesus, na mà din, “Pira abuk tô pan tun ákniyu?” Igtaba sikandan, na mà dan, “Pittu abuk.” ");
INSERT INTO bgs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na, igpónsad i Jesus tô langun manubù tun ta tanà. Igkangé din tô pittu abuk pan, asta igpasalamatan din tun ta Manama. Igtáppik-táppik din tô mga pan, asta igbággé din tun ta mga disipulu din ébô taladán dan tun ta mga manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Duwán pira dád abuk marénták sáddà dan. Igpasalamatan i Jesus tun ta Manama, asta igpatalad din pagsik tun ta mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ikakan tô langun manubù, asta ibássug dan. Iglimud dan tô isamà, asta pittu tô magdakál basket na ipánnù. ");
INSERT INTO bgs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mga áppat mararan (4,000) tô mga gamama na ikakan. ");
INSERT INTO bgs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na, tô igpólì i Jesus tô langun dan, igsaké sikandin ka barangé duma katô mga disipulu din, asta igsadun dan tun ta probinsya na madani tun ta Dalmanuta. ");
INSERT INTO bgs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na, duwán mga Pariseo na igpadani tun ki Jesus. Igapul dan kandin, su kakalyag dan na kuminnam dan pád kandin. Purisu igpamuyù dan na pakitanán din tô kasalábbuan tikud tun ta Manama. ");
INSERT INTO bgs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tuu igpanagkuy si Jesus tingód ka ranu din, asta igkagi sikandin, na mà din, “Manan ka ágpamuyù kó ka kasalábbuan? Paminág yu ni kagin ku ákniyu. Ándà palang kasalábbuan na pakitanán ka Manama ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na, igtananan i Jesus tô mga Pariseo. Igsaké puman sikandin ka barangé ébô tumalipag katô ranó. ");
INSERT INTO bgs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na, tô igtalipag dan katô ranó, ándà pan na igpid katô mga disipulu i Jesus, su ilingawan dan tô tánnó dan, asta sábbad dád abuk pan tô tun ta barangé. ");
INSERT INTO bgs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Igkagi si Jesus kandan, na mà din, “Banté kó katô pagpatubù ka pan katô mga Pariseo asta katô pagpatubù ka pan i Herodes.” ");
INSERT INTO bgs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Igpatóngkóé tô mga disipulu din, na mà dan, “Tô gó é igkagi din su ándà pan na igpid ta.” ");
INSERT INTO bgs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Asal isóddóran i Jesus ka ándin tô panámdám dan. Purisu igkagi sikandin, na mà din, “Yakó ágpatóngkóé su ándà pan na igpid yu. Isalábbuanna ákniyu, su ándà kó pa ikagpát. Matággas tô mga ulu yu. ");
INSERT INTO bgs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Agad duwán mata yu, ándà kó pa kita katô kabánnalan. Agad duwán talinga yu, ándà kó pa paminág. Iring na ilingawan yu tô iglumu ku. ");
INSERT INTO bgs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tô igpakan ku tô lima mararan (5,000) manubù ka lima abuk pan, pira é magdakál basket na igipánnù yu katô isamà?” Igtaba sikandan, na mà dan, “Sapulù duwa (12).” ");
INSERT INTO bgs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Iginsà puman si Jesus, na mà din, “Tô igpakan ku tô áppat mararan (4,000) manubù ka pittu abuk pan, pira é magdakál basket na igipánnù yu katô isamà?” Igtaba sikandan, na mà dan, “Pittu.” ");
INSERT INTO bgs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Igkagi si Jesus, na mà din, “Ándà kó pa kannê ikagpát?” ");
INSERT INTO bgs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na, igsadun si Jesus asta tô mga disipulu din tun ta Betsaida. Duwán mga manubù na igpid ka bólóg tun ki Jesus, asta igpédu-édu dan na dappánnan din sikandin ka bállad ébô makakita. ");
INSERT INTO bgs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Igawidan i Jesus tô bállad katô bólóg, asta igagak din tun ta luwà ka lunsud. Igilábban i Jesus tô mata katô bólóg, igdappánnan din, asta iginsà, na mà din, “Duwán dán igkita nu?” ");
INSERT INTO bgs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Igsállág tô manubù, asta igkagi sikandin, na mà din, “Igkita ku tô mga manubù, asal tô bónnóng dan iring na mga kayu na ágpanó-panó.” ");
INSERT INTO bgs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Igdappánnan puman i Jesus tô mata din, asta tô igsállág sikandin, ikakita sikandin asta matayyó dán tô langun. ");
INSERT INTO bgs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na, igpólì i Jesus sikandin, na mà din, “Yaka gukit tun ta lunsud.” ");
INSERT INTO bgs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na, igpanayun si Jesus asta tô mga disipulu din, asta igsadun dan tun ta mga lunsud na sakup ka Cesarea Filipos. Róggun igpanó dan, iginsà si Jesus kandan, na mà din, “Ándin tô ágkagin ka mga manubù tingód kanak? Sadanna kun?” ");
INSERT INTO bgs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Igtaba sikandan, na mà dan, “Duwán mga manubù na ágkagi na sikuna si Juan na Tarabunyag. Duwán ássa mga manubù na ágkagi na sikuna si Elias. Duwán ássa ágkagi na sikuna tô sábbad propeta ka Manama sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iginsà si Jesus, na mà din, “Asal ándin é ákniyu panámdám tingód kanak? Sadanna?” Igtaba si Pedro, na mà din, “Sikuna tô Mesiyas.” ");
INSERT INTO bgs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Igsapad si Jesus na kailangan dì dan mulit tingód kandin tun ta duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na, igulit si Jesus tun ta mga disipulu din ka ándin tô matuman dumunggù tun kandin na Igpamanubù. Pahirapan sikandin, asta élléyan sikandin katô mga ágtugállán ka Judio, mallayat ka mga pangulu ka templo, asta mga taratinurù ka sugù. Matayan sikandin asta manté puman tun ta ikatállu álló. ");
INSERT INTO bgs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Matayyó tô igkagi din kandan. Na, igpadani si Pedro ki Jesus, asta igtigkané pád sikandin igsapad ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Asal igbariring si Jesus, igsállág sikandin tun ta mga disipulu din, asta igsapadan din si Pedro, na mà din, “Iwà ka, Maibuyan! su ánnà tikud tun ta Manama tô kakalyag nu, asal tikud dád tun ta panámdám nu.” ");
INSERT INTO bgs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na, igpalimud i Jesus tô mga disipulu din asta tô langun manubù na ilimud. Igkagi sikandin, na mà din, “Tô manubù na tumákkás kanak, kailangan dì sikandin mákkás ka kakalyag ka pusung din, asal kailangan tumiis sikandin ka kahirapan agad matayan sikandin, asta kailangan tumákkás kanak. ");
INSERT INTO bgs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tô manubù na áglággád katô kantayan din, kandaan sikandin katô kantayan na ándà ágtamanán. Asal ka mému ka matayan tô manubù tingód katô katákkás din kanak asta tingód katô katinurù din ka Madigár Gulitán tingód kanak, matanggap din tô kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Atin ka makatigatun tô manubù kani tibuk banuwa, asal kandaan sikandin katô kantayan, ándà palang pulusán din, ");
INSERT INTO bgs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","su ándà bullas katô kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Atin ka ágkayyaan tô manubù tingód kanak asta tingód katô igtinurù ku tun ta tubang katô mga manubù áknganni na masalà-salà asta ágtayyug ka Manama, kayyaanna pagsik tingód kandin tun ta álló ka lumónódda na Igpamanubù na duwán séllaán katô Ámmà ku, asta tákkássanna ka mga panaligan ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Duwán dini ákniyu na dì maté sippang ka kumita dan katô pagpangulu ka Manama na matulus.” ");
INSERT INTO bgs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na, pángnga ka ánnám álló, igpatákkás i Jesus si Pedro, si Santiago, asta si Juan. Igtikáddág dan tun ta mallayat pabungan na ándà palang manubù. Róggun igsállág dan ki Jesus, tigkô dád ipalin tô bónnóng din. ");
INSERT INTO bgs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Igséllà asta igmapputì tô umpak din. Ándà gó manubù nit banuwa na makapapputì ka umpak iring katô kapputì katô umpak din. ");
INSERT INTO bgs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tigkô dád igkita dan si Elias asta si Moises na igtóngkô ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Igkagi si Pedro ki Jesus, na mà din, “Sir, madigár su dini ké. Mimu ké dini ka tállu rákkó, sábbad para áknikó, sábbad para ki Moises, asta sábbad para ki Elias.” ");
INSERT INTO bgs_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Agad tô gó é igkagi i Pedro, asal ándà din kagpátti tô igkagi din, su tuu dan igkállas. ");
INSERT INTO bgs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tigkô dád duwán sagulapun na ikatambun kandan, asta igdinág dan tô kagi ka Manama tikud tun ta sagulapun, na mà din, “Ni gó ni kanak Batà na ágginawaan ku. Paminág yu sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tigkô dád tô igsállág dan, igkita dan si Jesus na sábbad din dád man. ");
INSERT INTO bgs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na, róggun igtupang dan tikud tun ta pabungan, igsapad si Jesus kandan na dì mému ulitan dan tô duma manubù tingód katô igkita dan róggun ándà pa kanté puman sikandin na Igpamanubù. ");
INSERT INTO bgs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Purisu igbánnal dan katô igkagi din kandan, asal ka sikandan dád, marag dan ágpénsaé ka ándin tô kóbadan katô igkagi din na manté puman sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na, iginsà dan kandin, na mà dan, “Manan ka ágtinurù tô mga taratinurù ka sugù na kailangan lumónód si Elias tô dì pa dumunggù tô Mesiyas?” ");
INSERT INTO bgs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Igtaba si Jesus, na mà din, “Bánnal na dumunggù pa si Elias ébô tumaganà katô langun. Asal kumagiya ákniyu na igdunggù dán sikandin, asta madat tô iglumu katô duma mga manubù kandin, su tô gó é igsulat tingód kandin sayyan. Mà katô kagi ka Manama tingód kanak na Igpamanubù, na kahirapanna asta ngisiyanna.” ");
INSERT INTO bgs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tô igdunggù dan tun ta duma mga disipulu i Jesus, igkita dan na tuu marapung tô mga manubù na ilimud tun kandan, asta duwán mga taratinurù ka sugù na igapul kandan. ");
INSERT INTO bgs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tô igkita tô mga manubù ki Jesus, tigkô dád isalábbuan dan. Igpalaguy dan igsumar ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iginsà si Jesus katô mga manubù, na mà din, “Ándin tô igapulan yu katô mga disipulu ku?” ");
INSERT INTO bgs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Igtaba tô sábbad manubù, na mà din, “Sir, igpid ku tô batà ku dini áknikó, su igahuwan sikandin ka madat espiritu na igpómmó kandin. ");
INSERT INTO bgs_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Atin ka gahuwan sikandin, ágkabantang, ágburà tô babbà din, ágkurigát tô ngipán din, asta ágtuyù-tuyù sikandin. Igpédu-éduwa tun ta mga disipulu nu na paluwaán dan tô madat espiritu na igahu kandin, asal ándà dan ikému.” ");
INSERT INTO bgs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Igkagi si Jesus, na mà din, “Sikiyu mga manubù áknganni, dì kó ágsarig kanak. Dì dán madugé na dumuma a ákniyu, asal kailangan tumiissa pa. Na, pid yu dini kanak tô batà.” ");
INSERT INTO bgs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na, igpid dan tô batà tun ki Jesus. Tô igkita tô madat espiritu ki Jesus, igpatuyù-tuyù katô madat espiritu tô batà, igpabantang asta igpatalilid sikandin, asta igburà tô babbà din. ");
INSERT INTO bgs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iginsà si Jesus katô ámmà, na mà din, “Kadángngan ni igtigkané?” Igtaba tô ámmà din, na mà din, “Tikud pô tun ta kadélákkan din. ");
INSERT INTO bgs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Marag sikandin ágpabantangán katô madat espiritu tun ta apuy asta tun ta wayig ébô matayan sikandin. Atin ka makému ka, kéduwi ké, asta tabangi ké.” ");
INSERT INTO bgs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Igkagi si Jesus, na mà din, “Manan ka ágkagi ka na, ‘Atin ka makému ka’? Ándà palang na dì imun ka Manama para katô manubù na mamaké kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tigkô dád igullaó tô ámmà ka mabákkár, na mà din, “Ágpamakéya! Pabákkár nu tô kapamaké ku!” ");
INSERT INTO bgs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tô igkita si Jesus na tuu pa marapung tô mga manubù na ilimud, igsapadan din tô madat espiritu, na mà din, “Sikuna na madat espiritu na igpómmó asta igpabingál kani batà, igsugù ku sikuna, luwà kad tikud tun kandin, asta yakad gó áglónód tun kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na, igullaó pa tô madat espiritu, tuu din igpatuyù-tuyù tô batà, asta igluwà. Iring na inaté tô batà. Purisu igkagi tô karapungan ka mga manubù, na mà dan, “Inaté dán sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Asal igawidan i Jesus tô bállad katô batà, asta igpatindág din. Purisu ikatindág tô batà. ");
INSERT INTO bgs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na, tô igahu si Jesus tun ta balé, iginsà tô mga disipulu din na ándà duma manubù, na mà dan, “Manan ka ándà ké ikapaluwà katô madat espiritu?” ");
INSERT INTO bgs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Igkagi si Jesus, na mà din, “Paluwaán ni klasi ka madat espiritu ukit dád ka kadasal.” ");
INSERT INTO bgs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na, igpanó si Jesus asta tô mga disipulu din, asta igukit dan tun ta probinsya ka Galilea. Tô kakalyag i Jesus na ándà manubù na makasóddór ka ánda sikandin, ");
INSERT INTO bgs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","su igtinurù sikandin katô mga disipulu din, na mà din, “Matuman ni dumunggù kanak na Igpamanubù. Kailangan bággénna tun ta bállad katô duma mga manubù, asta matayanna ikandan. Pángnga ka kamatayan ku, mantéya puman tun ta ikatállu álló.” ");
INSERT INTO bgs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Asal ándà gó kagpátti katô mga disipulu din tô kóbadan katô igkagi din. Ándà dan insà kandin, su ágkamáddangan dan. ");
INSERT INTO bgs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na, igdunggù si Jesus asta tô mga disipulu din tun ta Capernaum. Tô igahu dan tun ta balé, iginsà si Jesus kandan, na mà din, “Ándin tô igapulan yu róggun ágpanó kó tun ta dalan?” ");
INSERT INTO bgs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Asal ándà palang taba dan, su igpapulé dan tingód ka sadan tun kandan tô tuu mallayat. ");
INSERT INTO bgs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Purisu igunsad si Jesus, igpaglimud din tô sapulù duwa (12) disipulu din, asta igkagi sikandin, na mà din, “Tô manubù na imun mallayat é kamanubuan, tô gó é kailangan pabbabà-babà katô kamanubuan din tun ta langun manubù, asta kailangan imun sikandin na ágsuguánnán ka langun.” ");
INSERT INTO bgs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na, igtawar i Jesus tô sábbad batà, asta igpatindág din tun ta tángngaan dan. Igsipit din tô batà, asta igkagi sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Atin ka ágtanggap kó katô sábbad batà iring kani batà tingód ka kapasakup yu kanak, iring na ágtanggapánna ikiyu. Tô manubù na ágtanggap kanak, ágtanggapán din tô igpapid kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na, igkagi si Juan tun ki Jesus, na mà din, “Sir, duwán sábbad manubù na igkita dé na igpaluwà ka madat mga espiritu ukit ka kagamit din katô ngadan nu. Asal igsapadan dé sikandin su ánnà kadumaan ta.” ");
INSERT INTO bgs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Asal igkagi si Jesus, na mà din, “Yakó ágsapad kandin, su tô manubù na makému ka kasalábbuan ukit ka kagamit din katô ngadan ku, dì sékót sikandin kumagi ka madat tingód kanak. ");
INSERT INTO bgs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mga kadumaan ta tô mga manubù na ánnà usig ta. ");
INSERT INTO bgs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Paminág yu ni kagin ku ákniyu. Tô manubù na pénám ákniyu ka sábbad baso ka wayig tingód katô kapasakup yu kanak na Mesiyas, duwán gó pulusán din tikud tun ta Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Atin ka duwán makandà ka kapamaké katô agad sábbad kani mga marénták gabatà, tuu pa madigár ka ikáttán tô alig din tun ta dakál batu, asta lánnáddán sikandin tun ta dagat. ");
INSERT INTO bgs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Atin ka tô bállad nu tô gunayan na makasalà ka, tampád nu asta antug nu, su tuu pa madigár agad sábbad dád tô bállad nu na duwán kantayan nu na ándà ágtamanán ka tandingán ka antugán tô tibuk lawa nu tun ta ágsupakanan na duwán apuy na dì gó mapadáng ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Atin ka tô paa nu tô gunayan na makasalà ka, tampád nu asta antug nu, su tuu pa madigár agad sábbad dád tô paa nu na duwán kantayan nu na ándà ágtamanán ka tandingán ka antugán tô tibuk lawa nu tun ta ágsupakanan. ");
INSERT INTO bgs_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Atin ka tô mata nu tô gunayan na makasalà ka, lássù nu asta antug nu, su tuu pa madigár agad mandà tô sábbad mata nu na duwán kantayan nu na ándà ágtamanán ka tandingán ka duwán duwa mata nu asta antugán tô tibuk lawa nu tun ta ágsupakanan. ");
INSERT INTO bgs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Dì gó maté tô mga ulád na ágkan katô lawa dan dutun, asta dì gó mapadáng tô apuy, ");
INSERT INTO bgs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","su linisan tô langun manubù ukit ka apuy. ");
INSERT INTO bgs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Na, madigár tô asin, asal atin ka mandà tô nanam katô asin, dì dán lumónód tô nanam. Padigárré kó ébô makéring kó katô madigár klasi ka asin na dì mandà tô nanam.” ");
INSERT INTO bgs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na, igpanó si Jesus, asta igsadun sikandin tun ta probinsya ka Judea tun dipag ka Wayig ka Jordan. Marapung puman tô mga manubù na ilimud tun kandin, asta igtinurù sikandin kandan, su tô gó é inayadan din áglumun. ");
INSERT INTO bgs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Duwán mga Pariseo na igpadani tun ki Jesus ébô kuminnam kandin. Iginsà sikandan, na mà dan, “Mému ka sumugban tô manubù katô sawa din?” ");
INSERT INTO bgs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Igtaba si Jesus, na mà din, “Ándin tô igsugù i Moises tingód ka ágpasugbané?” ");
INSERT INTO bgs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Igkagi sikandan, na mà dan, “Igsugù si Moises sayyan na kailangan duwán papeles na bággén katô mama tun ta sawa din tingód katô kasugban din kandin, asta mému din péwaán.” ");
INSERT INTO bgs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Asal igkagi si Jesus, na mà din, “Tô gó é igsugù i Moises su isóddóran din na tuu matággas tô ulu yu. ");
INSERT INTO bgs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Asal tô igimu tô Manama katô manubù sayyan, igimu din sikandan na mama asta bayi. ");
INSERT INTO bgs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Igkagi sikandin, ‘Purisu tumanan tô mama katô ámmà din asta katô innà din, asta pasábbadé tô mama asta tô sawa din. ");
INSERT INTO bgs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tô duwa dan mému dán sábbad.’ Purisu ánnà dan dán duwa, su inému dan dán sábbad. ");
INSERT INTO bgs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na, su igimu dan ka Manama na sábbad, dì mému na pagsugbanán ka manubù.” ");
INSERT INTO bgs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tô igahu si Jesus tun ta balé, iginsà puman tô mga disipulu din tingód ka ágpasugbané. ");
INSERT INTO bgs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Igkagi si Jesus, na mà din, “Atin ka sumugban tô mama katô sawa din asta kumalyag sikandin katô ássa bayi, makalibug sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Atin ka sumugban tô bayi katô duma din asta kumalyag katô ássa mama, makalibug sikandin.” ");
INSERT INTO bgs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na, duwán mga manubù na igpid ka marénták mga gabatà dan tun ki Jesus ébô dappánnan din asta dasalan din. Asal igsapadan dan katô mga disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tô igkita si Jesus katô kasapad dan, isókó sikandin, asta igkagi, na mà din, “Pabayà yu yan mga gabatà ébô makapadani dan dini kanak. Yakó ágsapad kandan, su tô mga manubù na ágsarig ka Manama iring katô kasarig ka mga gabatà tun ta ámmà asta innà dan, tô gó é panguluwan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Paminág yu ni kagin ku ákniyu. Atin ka dì sumarig tô manubù tun ta Manama iring katô kasarig ka mga gabatà tun ta ámmà asta innà dan, dì sikandin sakupán ka Manama tun ta pagpangulu din.” ");
INSERT INTO bgs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na, igsipit i Jesus tô mga gabatà, igdappánnan din sikandan ka bállad, asta igdasalan din. ");
INSERT INTO bgs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na, tô igpanó si Jesus tikud dutun, duwán sábbad manubù na igpalaguy tun kandin, iglingkóód, asta iginsà, na mà din, “Sir, madigár ka taratinurù. Ándin tô kailangan lumun ku ébô makatanggappa ka kantayan na ándà ágtamanán?” ");
INSERT INTO bgs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Igkagi si Jesus, na mà din, “Isalábbuanna su igkagi ka na madigárra. Sábbad dád tô tuu madigár, tô dád Manama. ");
INSERT INTO bgs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Isóddóran nu tô mga sugù ka Manama. Yakó ágmaté. Yakó áglibug. Yakó ágtakó. Yakó ágtestigos ka bulaló tingód katô unawa yu. Yakó áglimbung. Respetowi yu tô ákniyu ámmà asta innà.” ");
INSERT INTO bgs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Igtaba tô manubù, na mà din, “Sir, igbánnalla katô langun tikud pô tô délákka pa.” ");
INSERT INTO bgs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Igsállág si Jesus tun kandin, asta dakál tô ginawa din kandin. Igkagi si Jesus, na mà din, “Sábbad dád tô kailangan lumun nu. Ulì ka, asta barigyà nu tô langun kaduwánnan nu. Tukid nu bággéyi tô salapì nu tun ta mga manubù na ágkayù-ayuan. Atin ka tô gó é lumun nu, duwán pulusán nu tun ta langit. Na, lónód ka, asta tákkás ka kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tô igdinág tô manubù katô igkagi i Jesus, igtammud sikandin, asta igpanó na iranu, su dakál tô kaduwánnan din. ");
INSERT INTO bgs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na, igsérê-sérê si Jesus tun ta mga disipulu din, asta igkagi sikandin, na mà din, “Mahirap tô kapasakup ka ágkaduwánnan manubù tun ta pagpangulu katô Manama!” ");
INSERT INTO bgs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Isalábbuan tô mga disipulu din tingód katô igkagi din. Asal igkagi puman si Jesus, na mà din, “Tuu mahirap tô kapasakup ka manubù tun ta pagpangulu ka Manama! ");
INSERT INTO bgs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Agad mahirap tô dakál mannanap na ágngadanan kamelyo na mukit tun ta bóbbó ka simat, asal tuu pa mahirap tô kapasakup katô ágkaduwánnan manubù tun ta pagpangulu ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na, tuu dan isalábbuan, asta igkagi sikandan, na mà dan, “Purisu ándà palang manubù na makaluwà tikud tun ta supak ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Igsállág si Jesus tun kandan asta igkagi sikandin, na mà din, “Dì gó ni malumu ka manubù, asal malumu ka Manama, su tô langun malumu ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Igkagi si Pedro, na mà din, “Sikami, igtananan déd tô langun katô kaduwánnan dé ébô mákkás ké áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Tô manubù na igtanan katô kaduwánnan din, mga kataladi din, innà din, ámmà din, mga gabatà din, asta kinamát din ébô pasakup kanak asta ébô tuminurù katô Madigár Gulitán, ");
INSERT INTO bgs_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tô gó tô makatanggap ka kadigárran áknganni na ginatus-gatus na dakál pa ka tandingán katô igtananan din. Su bággayan sikandin ka mga kaduwánnan, mga kataladi, mga innà, mga gabatà, asta mga kinamát. Agad girrayatan sikandin áknganni, asal tun ta tapuri álló bággayan sikandin ka kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Marapung tô mga manubù na ikóna áknganni makatapuri baling tun ta tapuri álló. Tô mga manubù na ikatapuri áknganni makóna baling tun ta tapuri álló.” ");
INSERT INTO bgs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na, tô igpanó si Jesus tun ta Jerusalem, sikandin tô iguna tun ta dalan. Isalábbuan tô mga disipulu din, asta imáddangan tô mga manubù na ikatalundug. Igpaglimud i Jesus tô sapulù duwa (12) disipulu din, asta igulit sikandin ka ándin tô dumunggù tun kandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Na, madun kid tun ta Jerusalem. Sakán na Igpamanubù tô bággén tun ta bállad katô mallayat ka mga pangulu ka templo asta mga taratinurù ka sugù. Pasábbadé dan kumagi na kailangan matayanna. Bággénna ikandan tun ta bállad ka mga manubù na ánnà Judio. ");
INSERT INTO bgs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ngisiyanna ikandan, ilábbanna, lagpássánna, asta matayanna. Asal mantéya puman tun ta ikatállu álló.” ");
INSERT INTO bgs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na, igsadun tun ki Jesus tô duwa gabatà i Sebedeo na si Santiago asta si Juan. Igkagi sikandan, na mà dan, “Sir, kakalyag dé na lumun nu para áknami tô pamuyuán dé áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Igkagi si Jesus, na mà din, “Ándin tô kakalyag yu na lumun ku para ákniyu?” ");
INSERT INTO bgs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Igkagi sikandan, na mà dan, “Tun ta pagpangulu nu, pónsad ké madani tun áknikó, na sábbad dadan ta kawanan nu, asta sábbad dadan ta ibang nu.” ");
INSERT INTO bgs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Asal igkagi si Jesus, na mà din, “Ándà yu kasóddóri ka ándin tô igpamuyù yu. Makatiis kó katô kahirapan iring katô kahirapan na masig dán dumunggù kanak? Makatiis kó katô ranu iring katô ranu na masig dán dumunggù kanak?” ");
INSERT INTO bgs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Igtaba sikandan, na mà dan, “Óó, makatiis ké.” Igkagi si Jesus, na mà din, “Matuman na dungguan kó gó katô kahirapan na dumunggù kanak, asta dungguan kó gó katô ranu na dumunggù kanak. ");
INSERT INTO bgs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Asal diya makatandô ákniyu ka makónsad kó madani kanak, su munsad madani kanak tô mga manubù na taganà dán igsalin.” ");
INSERT INTO bgs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na, tô igdinág tô sapulù (10) disipulu ka ándin tô igkagi dan tun ki Jesus, isókó dan ki Santiago asta ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Purisu igpaglimud i Jesus tô langun dan, asta igkagi sikandin, na mà din, “Isóddóran yud na tun ta mga manubù na ánnà Judio, inalayun ágsugù tô mga ágpangulun katô mga sakup dan. Inalayun ágsugù-sugù tô mallayat mga manubù katô mga ágpanguluwan dan. ");
INSERT INTO bgs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Asal dì mému ka makéring kó kandan. Su tô manubù tun ákniyu na imun mallayat é kamanubuan, tô gó é kailangan imun na ágsuguánnán yu. ");
INSERT INTO bgs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Asta tô manubù na imun pangulu yu, tô gó é kailangan mému na állang katô langun. ");
INSERT INTO bgs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Méring sikandin kanak na Igpamanubù, su igsadunna dini ánnà ébô tabanganna katô manubù, asal igsadunna dini ébô tumabangnga katô mga manubù. Ikataganà ad na matayan ébô tábbusán ku tô marapung manubù.” ");
INSERT INTO bgs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na, igukit si Jesus asta tô mga disipulu din tun ta lunsud ka Jerico, asta tuu marapung tô mga manubù na igtákkás kandan. Tô igpanó dan tikud tun ta Jerico, duwán bólóg na igunsad tun ta ligad ka dalan asta ágpamuyù. Ágngadanan sikandin ki Bartimeo na batà i Timeo. ");
INSERT INTO bgs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tô igdinág sikandin na si Jesus na taga Nazaret tô iglabé, igullaó sikandin, na mà din, “Jesus, rubbad i David, kéduwiya!” ");
INSERT INTO bgs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Marapung tô manubù na igsapad kandin, asta igkagi dan na kailangan dì sikandin mótép. Asal ágrayan baling sikandin gullaó, na mà din, “Rubbad i David, kéduwiya!” ");
INSERT INTO bgs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Purisu igsódô si Jesus, asta igkagi sikandin, na mà din, “Angé yu sikandin.” Purisu igkangé dan sikandin, na mà dan, “Pasarig ka katô pusung nu. Tindág ka, su igpakangé ka ikandin.” ");
INSERT INTO bgs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Igtananan din tô kisì din, sékót sikandin igtindág, asta igpadani tun ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Igkagi si Jesus tun kandin, na mà din, “Ándin tô kakalyag nu na lumun ku para áknikó?” Igkagi tô bólóg, na mà din, “Sir, malyagga makakita.” ");
INSERT INTO bgs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Igkagi si Jesus, na mà din, “Mému mulì ka. Inólian kad su igsarig ka kanak.” Tigkô dád ikakita dán sikandin, asta igtalundug sikandin ki Jesus tun ta dalan. ");
INSERT INTO bgs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na, tô igsadun dan tun ta Jerusalem, igpadani dan tun ta mga lunsud ka Betpahe asta Betania na tun ta Pabungan ka Olibo. Igpóna i Jesus tô duwa disipulu din, na mà din, ");
INSERT INTO bgs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Una kó tun ta lunsud. Ka dumunggù kó, kitanán yu tô nati ka asno na ándà pa kinnami sakayi ka manubù. Igikát tô nati, asal akas yu, asta pid yu dini kanak. ");
INSERT INTO bgs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Atin ka duwán manubù na minsà ákniyu ka manan ka igakas yu, kagiyi yu na kailangan sakayan katô Áglangngagán, asta sékót din pólián.” ");
INSERT INTO bgs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na, igpanó dan, asta igkita dan tô asno na igikát tun ta luwà ka sállat ka balé madani tun ta dalan, asta igakas dan. ");
INSERT INTO bgs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Iginsà tô mga manubù na ágtindág dutun, na mà dan, “Manan ka igakas yu tô nati?” ");
INSERT INTO bgs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Igulit tô duwa disipulu tingód katô igkagi i Jesus kandan, asta ignunug dan. ");
INSERT INTO bgs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na, igpid dan tô nati tun ki Jesus, igampas dan tô mga umpak dan tun ta bókkóg katô nati, asta igsaké si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Igsánnar katô marapung manubù tô mga umpak dan tun ta dalan na ukitan din. Igtampád katô duma mga manubù tô mga daun ka palmera asta igsánnar dan tun ta dalan. ");
INSERT INTO bgs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Igullaó tô langun manubù na igtákkás ki Jesus, agad tô ikóna asta tô ikatalundug, na mà dan, “Durungán ta tô Áglangngagán! Durungán ta ni igpapid katô Áglangngagán! ");
INSERT INTO bgs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Madigár tô pagpangulu din na iring katô pagpangulu katô kamónaan ta sayyan na si David. Durungán ta tô Manama tun ta langit!” ");
INSERT INTO bgs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na, igdunggù si Jesus tun ta Jerusalem, asta igpanayun sikandin tun ta templo. Tô igsállág din tô langun, igsadun sikandin asta tô sapulù duwa (12) disipulu din tun ta Betania, su masig dán ágsalláp tô álló. ");
INSERT INTO bgs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tô sállám dán, róggun igpanó dan tikud tun ta Betania, igballus si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tun ta madiyù, igkita din tô kayu igera na daunán, asta igsadun sikandin ébô mamasak ka buuy. Tô igdunggù sikandin, marag dád daun tô igkita din, su ándà pa dunggù tô timpo katô kabuuy ka igera. ");
INSERT INTO bgs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Igkagi sikandin tun ta kayu, na mà din, “Tikud áknganni, ándà dán manubù na makakan ka buuy kani kayu ni.” Igdinág katô mga disipulu tô igkagi din. ");
INSERT INTO bgs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tô igdunggù dan tun ta Jerusalem, igsadun si Jesus tun ta templo, asta igabug din tô langun manubù na ágbarigyà asta ágbayad tun ta plasa ka templo. Igbantang din tô mga lamisa katô mga manubù na ágbullas ka salapì, asta igbantang din tô gunsadanan katô mga manubù na ágbarigyà ka salapati. ");
INSERT INTO bgs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Igsapadan din tô langun manubù na igpid ka kaduwánnan dan na gukit tun ta plasa ka templo. ");
INSERT INTO bgs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na, igtinurù sikandin, na mà din, “Mà katô kagi ka Manama, “‘Tô balé ku, tô gó é ágdasalanan katô langun manubù.’ Asal igimu yud ni na gállássanan ka mga tulisan.” ");
INSERT INTO bgs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tô igdinág tô mallayat ka mga pangulu ka templo asta katô mga taratinurù ka sugù katô igkagi i Jesus, igplano dan na matayan dan sikandin. Imáddangan dan ki Jesus, su isalábbuan tô langun manubù tingód katô ágtinuruán din. ");
INSERT INTO bgs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tô igsalláp dán tô álló, igpanó si Jesus asta tô mga disipulu din tikud tun ta Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tô sállám dán, iglabé si Jesus asta tô mga disipulu din katô kayu igera, asta igkita dan na igangu dán agad tun ta dalid. ");
INSERT INTO bgs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ikasampát si Pedro, asta igkagi sikandin tun ki Jesus, na mà din, “Sir, sállág nu! Igangu dán tô kayu igera na igkagiyan nu bani.” ");
INSERT INTO bgs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Igkagi si Jesus, na mà din, “Kailangan sumarig kó ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Paminág yu ni kagin ku ákniyu. Atin ka kumagi tô manubù kani pabungan na makangé asta malin tun ta dagat, ka dì ágduwa-duwa tô pusung din, asal ágbánnal sikandin na matuman tô kagi din, matuman gó malumu. ");
INSERT INTO bgs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Purisu kumagiya ákniyu, atin ka ágdasal kó katô Manama, asta duwán pamuyuán yu, bánnal kó na matanggap yu, asta matuman para ákniyu. ");
INSERT INTO bgs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Atin ka ágdasal kó, ka duwán duma manubù na ándà yu pa pasinsiyayi, pasinsiyayi yu gó sikandin ébô pasinsiyaan kó katô Ámmà yu na Manama tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Atin ka dì yu pasinsiyaan tô duma manubù, dì kó pasinsiyaan katô Ámmà yu na Manama tun ta langit.” ");
INSERT INTO bgs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na, igsadun puman si Jesus asta tô mga disipulu din tun ta Jerusalem. Róggun ágpanó-panó si Jesus tun ta plasa katô templo, igpadani tun ki Jesus tô mallayat ka mga pangulu ka templo, tô mga taratinurù ka sugù, asta tô mga ágtugállán ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iginsà sikandan, na mà dan, “Sadan é igtikudan katô langun na áglumun nu? Sadan tô igpapid áknikó?” ");
INSERT INTO bgs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Igkagi si Jesus, na mà din, “Duwán insà ku ákniyu. Atin ka makataba kó, mulitta ákniyu ka sadan tô igpapid kanak. ");
INSERT INTO bgs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na, sadan tô igpapid ki Juan na munyag? Tô Manama, ó tô manubù? Taba kó kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Purisu igpatóngkóé dan ka ándin tô madigár taba dan kandin, na mà dan, “Atin ka tumaba ki na Manama tô igpapid ki Juan, insaán ki ikandin na manan ka ándà ki bánnal ki Juan. ");
INSERT INTO bgs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Asal dì ki tumaba na manubù tô igpapid ki Juan.” Tô gó é igkagi dan su imáddangan dan katô mga manubù na ilimud, su ágpanámdám tô langun na bánnal propeta ka Manama si Juan. ");
INSERT INTO bgs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Purisu igtaba dan ki Jesus, na mà dan, “Ándà dé kasóddóri.” Igkagi si Jesus, na mà din, “Su ándà kó taba katô insà ku, diya pagsik mulit ákniyu ka sadan tô igpapid kanak na lumumuwa katô áglumun ku.” ");
INSERT INTO bgs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na, igulit i Jesus ni mga panunggiringan tun kandan, na mà din, “Duwán sábbad manubù na duwán tanà na igpamulaan din ka paras. Igkoralan din ni, asta igimu din tô garikanan ka buuy ka paras. Igpatindág din tô balé na ágtómmónganan. Igpadóppónan din tô kinamát katô ássa mga taralumu ka tanà, asta igsadun sikandin tun ta madiyù banuwa. ");
INSERT INTO bgs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tô igdunggù tô timpo na matássan dán tô buuy katô paras, duwán sábbad állang na igpapid katô tigatun tun ta mga taradóppón ébô mangé katô buuy na kandin bahin. ");
INSERT INTO bgs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Asal igámmát dan tô állang, iglagpás dan, asta igpólì dan na ándà palang piniddan din. ");
INSERT INTO bgs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Duwán ássa állang na igpapid katô tigatun, asal iglagpás dan tô ulu din, asta igpayayyà dan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Duwán ássa állang na igpapid katô tigatun, asal igmatayan dan. Marapung pa tô ássa mga állang na igpapid din tun kandan, asal duwán iglagpás dan, asta duwán igmatayan dan. ");
INSERT INTO bgs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na, tun ta katapuriyan, igpapid din tô kandin batà na ágginawaan din, su panámdám din na bánnalán dan tô kandin batà. ");
INSERT INTO bgs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Asal igpatóngkóé tô mga taradóppón, na mà dan, ‘Ni gó é makatigatun kani tanà ka maté tô ámmà din. Na, matayan ta sikandin ébô sikita tô makatigatun kani tanà.’ ");
INSERT INTO bgs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Purisu igámmát dan sikandin, igmatayan dan, asta igguyud dan tô lawa din tun ta luwà katô kinamát.” ");
INSERT INTO bgs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Igkagi si Jesus, “Na, kagin ku ákniyu ka ándin tô lumun katô tigatun kandan. Madun sikandin, matayan din tô madat mga taradóppón, asta padóppónan din katô ássa mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Igkagi si Jesus, na mà din, “Iring na ándà kó gó basa kani kagi ka Manama, na mà din, “‘Duwán sábbad batu na igantug katô mga gimu ka balé, su kéman dan ka ándà ágpulusán. Asal ándà dan kasóddóri na tô gó tô batu na tuu ágkailanganán katô balé. ");
INSERT INTO bgs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Madigár ni iglumu katô Áglangngagán, asta durungán ta sikandin.’” ");
INSERT INTO bgs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na, tô igdinág dan katô igkagi i Jesus, isóddóran dan na sikandan tô isugatan katô panunggiringan na igulit din. Purisu ámmáttán dan pád sikandin, asal ándà dan ikému, su imáddangan dan katô mga manubù na ágpaminág ki Jesus. Purisu igtananan dan sikandin, asta igpanó dan. ");
INSERT INTO bgs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na, duwán mga Pariseo asta mga sakup i Herodes na igpapid katô mga ágtugállán ka simbaan ka Judio tun ki Jesus. Ágpamasak dan ka dimanda dan ukit katô ágkagin din. ");
INSERT INTO bgs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tô igdunggù dan tun ki Jesus, igkagi sikandan, na mà dan, “Sir, isóddóran dé na ágkasarigan ka, asta dì ka ágkapid ka panámdám ka mga manubù, su agad ándin tô bónnóng ka manubù, bánnal tô ágtinuruán nu tingód katô kakalyag ka Manama. Na, uliti ké. Atin ka mayad ké ka buwis tun ta emperador ka Roma, lumapas ké ka mga sugù ka Manama? Kailangan mayad ké, ó dì?” ");
INSERT INTO bgs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Asal isóddóran i Jesus na ánnà nángngà tô kakalyag dan tun ta saruwan ka Manama. Purisu igkagi sikandin, na mà din, “Manan ka kuminnam kó kanak? Pakita yu kanak tô salapì na bayad yu katô buwis ébô sállággán ku.” ");
INSERT INTO bgs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Igpakita dan kandin tô salapì. Iginsà si Jesus, na mà din, “Sadan bónnóng asta ngadan tô igtagù nit salapì?” Igtaba sikandan, na mà dan, “Tô emperador ka Roma.” ");
INSERT INTO bgs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Igkagi si Jesus, na mà din, “Bággé yu tun ta emperador tô nángngà bággén yu tun ta emperador, asta bággé yu tun ta Manama tô nángngà bággén yu tun ta Manama.” Purisu isalábbuan dan gó kandin. ");
INSERT INTO bgs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na, duwán mga Saduseo na igpadani tun ki Jesus. Tô gó tô mga manubù na ágtinurù na dì manté puman tô mga manubù na inaté dán. Iginsà dan ki Jesus, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Sir, igsugù si Moises áknita tingód katô lumun katô mga mataladi gamama. Atin ka maté tô mama na ándà pa batà katô sawa din, tô kataladi din kailangan kumalyag katô sawa katô inaté, na ipag din na ibalu, ébô ukit kandin duwán mému batà para katô kataladi din na inaté. ");
INSERT INTO bgs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na, duwán pittu mataladi gamama. Igkalyag tô kaké dan, asta inaté sikandin na ándà pa batà din. ");
INSERT INTO bgs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Purisu tô ikaduwa kataladi igkalyag katô bayi, asal inaté sikandin na ándà pa batà din. Magunawa tô inému tun ta ikatállu mama ");
INSERT INTO bgs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","sippang tun ta ikapittu, su tô tagsábbad-sábbad katô pittu mataladi na igkalyag katô bayi inaté langun na ándà palang batà dan. Tun ta katapuriyan, inaté pagsik tô bayi. ");
INSERT INTO bgs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, ulit nu áknami. Atin ka manté puman tô mga manubù, sadan tun ta pittu mataladi tô bánnal duma katô bayi? Su igkalyag tô pittu dan kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Igkagi si Jesus, na mà din, “Duwán sayup yu, su ándà yu kagpátti tô kagi ka Manama na igsulat, asta ándà yu kasóddóri ka ándin tô lumun ka Manama ukit katô katulusan din. ");
INSERT INTO bgs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ka antén puman ka Manama tô mga manubù, dì dan dán pakalyagé, su iring dan dán katô mga panaligan ka Manama tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tingód katô kanté puman ka Manama ka mga manubù, iring na ándà kó gó basa tun ta libro na igsulat i Moises tingód ka igpakita tô Manama kandin tun ta mabbabà kayu na igrágrág. Igkagi tô Manama kandin, na mà din, “‘Sakán tô Manama na ágpangadapán i Abraham, i Isaac, asta i Jacob.’ ");
INSERT INTO bgs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dì ágpangadap ka Manama tô mga manubù na ándà kantayan, asal tô mga manubù na duwán kantayan, tô gó tô ágpangadap ka Manama. Purisu ánnà nángngà tô kénagpát yu.” ");
INSERT INTO bgs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na, igpadani tô sábbad taratinurù ka sugù, asta igdinág din tô tinóngkóan dan. Tô ikasóddór sikandin na madigár tô igtaba i Jesus kandan, iginsà sikandin, na mà din, “Tun ta langun sugù, ándin sugui é una na ágkailanganán?” ");
INSERT INTO bgs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Igkagi si Jesus, na mà din, “Ni gó tô sugù na una na ágkailanganán. “‘Tô langun yu mga rubbad i Israel, paminág kó kanak. Tingód katô Áglangngagán na Manama ta, tô dád gó tô Manama. ");
INSERT INTO bgs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ginawayi yu tô Áglangngagán na Manama yu tikud tun ta tibuk pusung yu, tikud tun ta tibuk kantayan yu, tikud tun ta tibuk panámdám yu, asta tikud tun ta tibuk bákkár yu.’ ");
INSERT INTO bgs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ni gó tô sugù na ikatalundug katô tagnà, ‘Ginawayi yu tô unawa yu na iring katô kaginawa yu katô ákniyu sarili.’ Ándà dán ássa sugù na tuu pa ágkailanganán ka tandingán katô duwa sugù.” ");
INSERT INTO bgs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Igkagi tô taratinurù, na mà din, “Sir, nángngà tô igkagi nu na tô dád gó tô Manama, asta ándà dán ássa. ");
INSERT INTO bgs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Asta kailangan ginawaan ta sikandin tikud tun ta tibuk pusung ta, tikud tun ta tibuk panámdám ta, asta tikud tun ta tibuk bákkár ta, asta kailangan ginawaan ta tô unawa ta na iring katô kaginawa ta katô áknita sarili. Tô gó tô tuu pa ágkailanganán ka tandingán katô paggóbbó ta katô mga mannanap na bággén tun ta Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tô ikasóddór si Jesus na mapandé tô taba din, igkagi sikandin, na mà din, “Masig kad masakup tun ta pagpangulu ka Manama.” Tikud katô álló tô, ándà palang manubù na igkinnam iginsà kandin. ");
INSERT INTO bgs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na, róggun igtinurù si Jesus tun ta templo, igkagi sikandin, na mà din, “Tô mga taratinurù ka sugù ágtinurù na rubbad i David tô Mesiyas. ");
INSERT INTO bgs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Asal si David tô igpasulat katô Ugis Espiritu kani kagi, “‘Igkagi tô Manama tun ta Áglangngagán ku: Unsad ka kannun ta kawanan ku sippang ka manaluwa katô mga usig nu.’ ");
INSERT INTO bgs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Purisu su si David tô igkagi na Áglangngagán din tô Mesiyas, pamánnun na tô Mesiyas tô rubbad i David?” Na, idayawan tô langun manubù na igpaminág ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tô igtinurù si Jesus, igkagi sikandin, na mà din, “Banté kó katô mga taratinurù ka sugù. Atin ka ágpanó-panó dan, gumpak dan ka kapa, asta malyag dan respetowan katô duma mga manubù tun ta plasa. ");
INSERT INTO bgs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Malyag dan munsad tun ta madigár gunsadanan tun ta mga simbaan ka Judio. Malyag dan munsad tun ta igpantaganà katô mga manubù na mallayat é kamanubuan tun ta dakál kalimudan. ");
INSERT INTO bgs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sikandan tô gagó ka kaduwánnan katô mga gabayi balu. Ágtambunan dan tô madat linumuwan dan ukit katô mallayat mga kadasal. Purisu tuu madat tô supak na padungguán ka Manama kandan.” ");
INSERT INTO bgs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na, igunsad si Jesus tun ta tubang katô ágtaguanan ka salapì na ágbággén tun ta Manama tun ta templo. Igparimuya sikandin katô mga manubù na ágdabù ka salapì. Marapung tô mga ágkaduwánnan na ágdabù ka dakál salapì. ");
INSERT INTO bgs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na, igdunggù tô sábbad ágkayù-ayuan bayi balu, asta igdabù sikandin ka duwa dád kadakù na délák é lagà. ");
INSERT INTO bgs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Igtawar i Jesus tô mga disipulu din, asta igkagi sikandin, na mà din, “Paminág yu ni kagin ku ákniyu. Tuu pa dakál tô igbággé katô bayi balu ka tandingán katô igbággé katô langun dan tun ta templo. ");
INSERT INTO bgs_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Su tô dád sobra tô igbággé katô langun dan, asal tô bayi balu, agad ágkayù-ayuan sikandin, igbággé din tô langun ka salapì din, asta ándà palang isamà tun kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na, tô igpanó si Jesus tikud tun ta templo, igkagi tô sábbad disipulu din, na mà din, “Sir, sállág nu, su madigár ágsállággán ni mga batu na iglabat, asta madigár ágsállággán tô mga ássa-ássa balé!” ");
INSERT INTO bgs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Igkagi si Jesus kandin, na mà din, “Ni mga ássa-ássa balé tun ta templo na ágsállággán yu, dadattan tô langun, asta ándà palang sábbad batu masamà tun ta bówwó katô ássa batu.” ");
INSERT INTO bgs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na, igsadun dan tun ta Pabungan ka Olibo na ikatubang katô templo. Igunsad si Jesus, asta igpadani tun kandin si Pedro, si Santiago, si Juan, asta si Andres na ándà duma manubù. Iginsà sikandan, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Uliti ké. Kadángngan matuman tô igulit nu? Ándin tô kakilalaan na masig dán matuman tô langun kani?” ");
INSERT INTO bgs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Igkagi si Jesus, na mà din, “Banté kó ébô dì kó mapid. ");
INSERT INTO bgs_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Marapung tô mga manubù na mid ka ngadan ku, su mà kagi dan Mesiyas, asta marapung tô mga manubù na mapid asta mákkás kandan. ");
INSERT INTO bgs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Atin ka ágkadinággan yu na duwán mga gira tun ta madani asta tun ta madiyù, yakó ágkamáddangan. Kailangan matuman pa yan, asal ánnà pa yan tô ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Su marapung tô mga banuwa na pagiraé, asta sumulung tô mga sakup ka sábbad harì katô mga sakup ka ássa harì. Duwán mga linug tun ta kaluwagan kani banuwa, asta duwán ballus. Ni gó tô katigkanayan katô kahirapan na dumunggù. ");
INSERT INTO bgs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Purisu banté kó, su paruudan kó, asta palagpássán kó tun ta mga simbaan ka Judio. Piddán kó tun ta tubang ka mga gobernador asta mga harì tingód katô kapasakup yu kanak ébô mulit kó kandan tingód kanak. ");
INSERT INTO bgs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tô dì pa dumunggù tô ágtamanán, ulit-ulitán pa ni Madigár Gulitán ébô makasóddór tô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Atin ka piddán kó tun ta mga manubù na rumuud ákniyu, yakó ágkatanaan tingód katô kagin yu kandan, su tô oras tô, bággayan kó ka kakatigan ébô makataba kó kandan, su ánnà tikud tun ákniyu tô kagin yu, asal tikud tun ta Ugis Espiritu. ");
INSERT INTO bgs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Duwán mga manubù na pammát katô mga kataladi dan ébô matayan. Duwán mga ámmà na pamaté katô mga gabatà dan. Duwán mga gabatà na musig katô ámmà asta innà dan, asta pamatayan dan. ");
INSERT INTO bgs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Karingasaan kó katô langun manubù tingód katô kapasakup yu kanak. Asal matábbus tô manubù na makatiis katô langun kahirapan.” ");
INSERT INTO bgs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Na, atin ka kitanán yu tô ágkaringasaan ka Manama na igtindág tun ta dì nángngà tindággan (kailangan makagpát tô manubù na masa kani), kailangan malaguy tô langun taga Judea, asta madun dan tun ta pabunganán. ");
INSERT INTO bgs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tô mga manubù na tun ta luwà katô balé dì mému makahu ébô mangé ka kaduwánnan. ");
INSERT INTO bgs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tô mga manubù na áglumu tun ta kinamát dì mému makólì ébô mangé ka gilisan dan. ");
INSERT INTO bgs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Makédu-édu tô mga gabayi na mabáddás ó ágpasusu tô álló tô! ");
INSERT INTO bgs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dasal kó tun ta Manama ébô ánnà magánnó timpo tô kapalaguy yu. ");
INSERT INTO bgs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tuu madat tô kahirapan na dumunggù. Ándà palang kahirapan na tuu pa madat tikud tun ta katigkanayan kani banuwa sippang áknganni, asta ándà palang kahirapan na dumunggù na tuu pa madat ka tandingán kani. ");
INSERT INTO bgs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Atin ka dì pabbabaán katô Áglangngagán tô kadugayan katô kahirapan, maté tô langun manubù. Asal tingód katô mga manubù na igsalin ka Manama, pabbabaán din tô kadugayan. ");
INSERT INTO bgs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Purisu atin ka duwán kumagi ákniyu, ‘Na, dini dán tô Mesiyas!’ ó duwán kumagi, ‘Taddô tô Mesiyas!’ yakó ágbánnal kandan. ");
INSERT INTO bgs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Su duwán mga manubù na mà kagi Mesiyas asta mà kagi propeta ka Manama. Lumun dan tô mga pató asta mga kasalábbuan ébô mapid pád tô mga manubù na igsalin ka Manama. ");
INSERT INTO bgs_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Purisu banté kó, su taganà a igulit ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Atin ka mapángnga ni kahirapan, kumangittáng tô álló asta dì miló tô bulan. ");
INSERT INTO bgs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mómpad tô mga karani asta makálláng tô langun tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kitanán katô langun manubù tô kadunggù ku tun ta sagulapun, su lumónódda na Igpamanubù na tákkássan katô katulusan ku asta katô tuu séllaán ku. ");
INSERT INTO bgs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Papiddán ku tô mga panaligan ku na lumimud katô langun manubù na igsalin ku tikud tun ta kaluwagan kani banuwa, agad ánda é góddóan dan.” ");
INSERT INTO bgs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Na, paminág kó kani panunggiringan tingód katô kayu igera. Atin ka kitanán yu tô kayu na gugbus asta ágdaun, kasóddóran yu na masig dán dumunggù tô ágsánnang timpo. ");
INSERT INTO bgs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Purisu atin ka kitanán yu tô katumanan katô igkagi ku ákniyu, kasóddóran yu na masiggad lumónód. ");
INSERT INTO bgs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Paminág yu ni kagin ku ákniyu. Tô dì pa maté tô mga manubù áknganni, matuman pa ni langun. ");
INSERT INTO bgs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mandà gó tô langit asta ni tanà, asal dì gó mandà tô langun ka kagi ku.” ");
INSERT INTO bgs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Asal ándà palang manubù na ikasóddór ka ándin állawi ó urasi tô kalónód ku. Ándà pagsik ikasóddór tô mga panaligan ka Manama tun ta langit. Agad sakán na Batà ka Manama, ándà a ikasóddór, su Ámmà ku dád tô ikasóddór. ");
INSERT INTO bgs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Purisu taganà kó, su ándà yu kasóddóri ka kadángngan dumunggù a. ");
INSERT INTO bgs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tô kalónód ku iring na manubù na madun tun ta madiyù banuwa. Tô dì pa panó, duwán talan din tun ta langun ágsuguánnán din, su duwán lumun ka tagsábbad-sábbad kandan sippang ka mulì sikandin. Suguán din tô manubù na ágbanté tun ta sállat ka balé din, na mà din, ‘Banté ka!’ ");
INSERT INTO bgs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Purisu taganà kó, su ándà yu kasóddóri ka kadángnganna dumunggù na iring ka tigatun ka balé, agó kasalláp ka álló, ó tángngà ka dukilám, ó masig dán ágkasállám, ó sállám. Purisu taganà kó, ");
INSERT INTO bgs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","agó tigkô lumónódda asta kitanán ku sikiyu na ágtudug. ");
INSERT INTO bgs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tô igkagi ku ákniyu, tô gó tô ágkagin ku tun ta langun manubù, na, taganà kó.” ");
INSERT INTO bgs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na, duwa pa álló tô kadunggù katô Kalimudan Ka Kalabé asta tô kakan katô mga Judio ka Pan Na Ándà Pagpatubù. Ágplano tô mallayat ka mga pangulu ka templo asta tô mga taratinurù ka sugù tingód katô lumun dan ébô ámmáttán dan si Jesus na ándà duma manubù na makasóddór ébô matayan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Su igkagi sikandan, na mà dan, “Dì ta sikandin pammáttán dalám ka kalimudan agó sumamuk tô langun manubù na inalayun ágpaminág kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, róggun dutun si Jesus ta lunsud ka Betania, igsadun sikandin tun ta balé i Simon na inólian katô bógók din na téték. Róggun igkan dan, duwán bayi na igpid ka pamammut na dakál é lagà na igimu tikud ka nardo asta igdalám tun ta katiyà na alabastro. Igpadani tô bayi tun ki Jesus, igpássà din tô katiyà, asta igbusbus din tô pamammut tun ta ulu i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na, duwán mga manubù na isókó, asta igpanámdám sikandan, na mà dan, “Inólaan tô pamammut. ");
INSERT INTO bgs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Madigár pád ka barigyaán ka sobra ka tállu gatus (300) abuk ka salapì denario asta bággén tun ta mga ágkayù-ayuan.” Purisu igbuyas dan tô bayi. ");
INSERT INTO bgs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Asal igkagi si Jesus, na mà din, “Pabayà yu ni bayi. Yakó ágbuyas kandin. Madigár tô iglumu din kanak. ");
INSERT INTO bgs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Inalayun duwán mga ágkayù-ayuan na mému yu tabangan. Agad kadángngan na duwán kakalyag yu, mému kó makatabang kandan. Asal diya móddô dini ákniyu ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iglumu kani bayi tô nángngà lumun din. Ukit ka kabusbus din katô pamammut, igtaganà din ni lawa ku para katô kalábbáng kanak. ");
INSERT INTO bgs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Paminág yu ni kagin ku ákniyu. Agad ánda é gulit-ulitan katô Madigár Gulitán tun ta kaluwagan kani banuwa, ulitán tô iglumu din kanak. Dì sikandin kalingawan.” ");
INSERT INTO bgs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na, duwán sábbad tun ta sapulù duwa (12) disipulu i Jesus na ágngadanan ki Judas Iscariote. Igsadun sikandin tun ta mallayat ka mga pangulu ka templo ébô tumóngkô kandan tingód ka kapammát din ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tô igdinág dan katô kagi din, idayawan dan, asta igtandô dan na duwán salapì na bággén dan tun kandin. Purisu igangat si Judas ka madigár timpo ébô pammáttán din si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na, igdunggù tô tagnà álló ka kalimudan na ágkan tô mga Judio ka Pan Na Ándà Pagpatubù. Tô gó tô álló na giyón dan tô nati ka karnero na ágsáddaán dan dalám katô Kalimudan Ka Kalabé. Na, igpadani tô mga disipulu i Jesus tun kandin, asta iginsà sikandan, na mà dan, “Ánda táppad tô kakalyag nu na taganaan dé katô kannan katô Kalimudan Ka Kalabé?” ");
INSERT INTO bgs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Purisu igsugù din tô duwa disipulu din, na mà din, “Sadun kó tun ta Jerusalem, asta sumarán yu tô sábbad mama na igtiang ka bangà na ipánnù ka wayig. Tákkás kó kandin. ");
INSERT INTO bgs_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tô igahu sikandin tun ta balé, uliti yu tô tigatun katô balé, ‘Iginsà tô Taratinurù ka ánda táppad tô kannan din katô Kalimudan Ka Kalabé na duma áknami na mga disipulu din.’ ");
INSERT INTO bgs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pakitanán din ákniyu tô dakál kuwarto tun datas ka balé na igtaganà dán. Tô gó é taganaan yu katô ágkannán ta.” ");
INSERT INTO bgs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Purisu igpanó tô duwa disipulu din, asta igsadun dan tun ta Jerusalem. Igkita dan tô kuwarto na iring katô igulit i Jesus kandan, asta igtaganà dan tô langun para katô Kalimudan Ka Kalabé. ");
INSERT INTO bgs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tô igsalláp dán tô álló, igsadun si Jesus asta tô sapulù duwa (12) disipulu din. ");
INSERT INTO bgs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Róggun ágkan dan, igkagi si Jesus, na mà din, “Paminág yu ni kagin ku ákniyu. Duwán sábbad ákniyu na pammát kanak. Sikandin tô sábbad na ágkan duma kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Purisu tuu iranu tô pusung dan, asta iginsà tô tagsábbad kandan, na mà dan, “Sakán?” ");
INSERT INTO bgs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Igkagi si Jesus, na mà din, “Sikandin tô sábbad tun ta sapulù duwa (12) ákniyu. Sikandin tô sábbad na ágtugán kanak. ");
INSERT INTO bgs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Matéya na Igpamanubù, su tô gó é igsulat sayyan tingód kanak. Asal makédu-édu tô manubù na pammát kanak! Tuu pa madigár kandin ka ándà kamanubù.” ");
INSERT INTO bgs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na, róggun ágkan dan, igkangé i Jesus tô pan, igpasalamat sikandin tun ta Manama, igtáppik-táppik din tô pan, asta igbággé din tun kandan. Igkagi sikandin, na mà din, “Tanggap yu ni pan, su ni gó ni lawa ku.” ");
INSERT INTO bgs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Igkangé din pagsik tô kopa, igpasalamat sikandin, igpénám din kandan, asta iginám dan langun. ");
INSERT INTO bgs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Igkagi si Jesus, na mà din, “Ni ginámmán ni tô dipanug ku na ulaán para katô marapung manubù. Ni gó tô ágpasóddór na duwán kapókit ka Manama dutun ta mga manubù. ");
INSERT INTO bgs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Paminág yu ni kagin ku ákniyu. Diyad muman minám kani ginámmán ta sippang ka minámma katô mantu bino tun ta pagpangulu katô Manama.” ");
INSERT INTO bgs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na, igkanta dan tingód katô pagdurung dan ka Manama, asta igsadun dan tun ta Pabungan ka Olibo. ");
INSERT INTO bgs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na, igkagi si Jesus tun ta mga disipulu din, na mà din, “Kani ka dukilám, tumanan tô langun yu kanak, su mà katô kagi ka Manama, “‘Pamatayan ku tô taradóppón, asta pasállabé tô mga karnero na igdóppónan din.’ ");
INSERT INTO bgs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Asal pángnga ka mantéya puman, muna a ákniyu tun ta Galilea.” ");
INSERT INTO bgs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Igkagi si Pedro ki Jesus, na mà din, “Agad tumanan tô langun dan, asal diya gó tumanan áknikó.” ");
INSERT INTO bgs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Igkagi si Jesus, na mà din, “Paminág nu ni kagin ku áknikó. Kani ka dukilám ka dì pa makaduwa tô manuk mukkarà, makatállu ka mulun kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Asal maggát igkagi si Pedro, na mà din, “Agad matayanna duma áknikó, asal diya mulun áknikó.” Magunawa tô igkagi katô langun dan. ");
INSERT INTO bgs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na, igsadun dan tun ta lugar na ágngadanan Getsemane. Igkagi si Jesus tun ta mga disipulu din, na mà din, “Unsad kó kannun róggun dumasalla.” ");
INSERT INTO bgs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Igpatákkás din si Pedro, si Santiago, asta si Juan. Tuu iranu si Jesus, mabággat tô pusung din, ");
INSERT INTO bgs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","asta igkagi sikandin, na mà din, “Tuu iranu ni pusung ku, iring na matéya. Kannun kó dád, asal yakó ágtudug.” ");
INSERT INTO bgs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na, igpanayun si Jesus tun tóna na dì madiyù, iglangkáb sikandin tun ta tanà, asta igdasal. Igpédu-édu sikandin na atin ka mému, dì pád sikandin pókitán tun ta kahirapan na masig dán dumunggù kandin. ");
INSERT INTO bgs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Igdasal sikandin, na mà din, “Ámmà, malumu nu tô langun. Yaka ágpókit kanak tun ta kahirapan na masig dán dumunggù. Asal tuman nu tô áknikó kakalyag, ánnà tô kanak kakalyag.” ");
INSERT INTO bgs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tô iglónód si Jesus tun ta mga disipulu din, igpantudug dan. Igánnó din sikandan, asta igkagi sikandin ki Pedro, na mà din, “Simon, manan ka igtudug ka? Isalábbuanna su ándà ka ikatiis ka sábbad dád oras. ");
INSERT INTO bgs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yakó ágtudug, asal dasal kó ébô dì kó matalu ka pagtintal. Tuu madigár tô kakalyag ka pusung yu, asal malómét tô lawa yu.” ");
INSERT INTO bgs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Igpanó puman si Jesus tun tóna, asta igdasal sikandin. Magunawa tô igpamuyù din. ");
INSERT INTO bgs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iglónód puman si Jesus tun ta mga disipulu din, asta igkita din sikandan na igpantudug, su tuu dan ágkatudugan. Ándà dan kasóddóri ka ándin tô taban dan kandin. ");
INSERT INTO bgs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na, iglónód si Jesus tun kandan ka ikatállu, asta igkagi sikandin, na mà din, “Isalábbuanna su igpantudug kó puman asta igpaginawa kó. Na, nángngà dán! Igdunggù dán tô oras na pammáttánna na Igpamanubù. Bággénna tun ta bállad katô mga manubù na masalà-salà. ");
INSERT INTO bgs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tindág kód su panó kid! Igdunggù dán tô manubù na pammát kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Róggun igkagi si Jesus, igdunggù si Judas na sábbad katô sapulù duwa (12) disipulu. Marapung tô mga manubù na igtákkás kandin, asta igpid dan ka mga kampilan asta mga paglagpás. Igsugù dan katô mallayat ka mga pangulu ka templo, mga taratinurù ka sugù, asta mga ágtugállán ka Judio. ");
INSERT INTO bgs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Taganà igpasóddór i Judas tô kakilalaan tun kandan, su igkagi sikandin, na mà din, “Tô manubù na adákkan ku, tô gó tô ágpamasakán yu. Ámmát yu asta bantayi yu tô kapid yu kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Purisu sékót igpadani si Judas ki Jesus, asta igkagi sikandin, na mà din, “Sir!” Asta igadák sikandin ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Purisu igámmát katô duma mga manubù si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Asal duwán sábbad kadumaan i Jesus na igtagnus katô kampilan din, igtigbas din tô állang katô tuu mallayat ka pangulu ka templo, asta ipangul tô talinga din. ");
INSERT INTO bgs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na, igkagi si Jesus kandan, na mà din, “Manan ka mámmát kó kanak ukit ka mga kampilan asta mga paglagpás? Ánnà a tulisan. ");
INSERT INTO bgs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Álló-álló ágtinurù a tun ta plasa ka templo, asta diyan kó pagsik, asal ándà a ikiyu ámmátti. Asal kailangan matuman tô kagi ka Manama na igsulat tingód kanak.” ");
INSERT INTO bgs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na, tô langun disipulu i Jesus igtanan kandin, asta igpalaguy dan. ");
INSERT INTO bgs_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Duwán sábbad mallaki na igtalundug ki Jesus, asta igpanapis dád sikandin ka mapputì óggét. Igámmát katô mga sundalo sikandin, ");
INSERT INTO bgs_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","asal igtananan din tô tapis na igawidan dan, asta igpalaguy na ándà palang umpak din. ");
INSERT INTO bgs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na, igpid dan si Jesus tun ta balé katô tuu mallayat ka pangulu ka templo. Taganà igpalimudé tô mallayat ka mga pangulu ka templo, tô mga ágtugállán ka Judio, asta tô mga taratinurù ka sugù. ");
INSERT INTO bgs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Igtalundug si Pedro, asal igpadiyù dád sikandin sippang ka igdunggù dan tun ta luwà ka balé katô tuu mallayat ka pangulu ka templo. Igunsad si Pedro duma katô mga tarabanté ka templo, asta iginadang sikandin tun ta apuy dan. ");
INSERT INTO bgs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na, tô mallayat ka mga pangulu ka templo asta tô langun ágtugállán ka templo igpamasak ka mga testigos na mulaló tingód ki Jesus ébô duwán gunayan katô kamaté dan kandin. Asal ándà ikita dan. ");
INSERT INTO bgs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Agad marapung tô mga manubù na igtestigos ka bulaló tingód kandin, asal ánnà magunawa tô igulit dan. ");
INSERT INTO bgs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Duwán mga manubù na igtestigos ka bulaló tingód kandin, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Igdinág dé tô igkagi din, na mà din, ‘Makémuwa dumadat kani templo na igimu ka manubù, asta dalám ka tállu álló, patindággán ku tô ássa na dì imun ka manubù.’” ");
INSERT INTO bgs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Agad tô gó é igulit dan tingód kandin, asal ánnà magunawa tô igulit dan. ");
INSERT INTO bgs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Igtindág tô tuu mallayat ka pangulu ka templo tun ta tángngaán dan, asta iginsà sikandin ki Jesus, na mà din, “Ándin é taba nu? Bánnal tô igkagi kani mga manubù?” ");
INSERT INTO bgs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Asal ándà gó taba si Jesus. Iginsà tô tuu mallayat ka pangulu ka templo, na mà din, “Sikuna gó tô Mesiyas na Batà ka Manama?” ");
INSERT INTO bgs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Igkagi si Jesus, na mà din, “Sakán gó, asta kumita kó kanak na Igpamanubù na gunsad dadan tun ta kawanan katô Matulus Manama ébô manguluwa duma kandin. Tákkássanna katô mga sagulapun tun ta langit.” ");
INSERT INTO bgs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Purisu igbissé katô tuu mallayat ka pangulu ka templo tô umpak din tingód ka sókó din, asta igkagi sikandin, na mà din, “Ándà dán kailangan na ulitan ki pa ka duma manubù tingód kandin. ");
INSERT INTO bgs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Igdinág tad na igpagunawa sikandin katô Manama. Na, ándin é ruud yu tingód kandin?” Igkagi tô langun dan na kailangan matayan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na, duwán pira na igiláb kandin, igbagkássan dan tô mata din, igsuntuk dan, asta igkagi sikandan, na mà dan, “Na, uliti ké ka sadan tô igsuntuk áknikó!” Igsuntuk kandin tô mga tarabanté ka templo. ");
INSERT INTO bgs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Róggun dutun si Pedro ta luwà ka balé, duwán sábbad bayi na állang katô tuu mallayat ka pangulu ka templo na igukit dutun. ");
INSERT INTO bgs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tô igkita sikandin ki Pedro na ginadang tun ta apuy, igsállág sikandin ki Pedro asta igkagi sikandin, na mà din, “Sikuna pagsik tô kadumaan i Jesus na taga Nazaret.” ");
INSERT INTO bgs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Asal igbulun si Pedro, na mà din, “Ándà ku kagpátti. Ándà sóddór ku tingód katô igkagi nu.” Na, igalin si Pedro madani tun ta sállat asta igukkarà tô manuk. ");
INSERT INTO bgs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Igkita tô bayi ki Pedro, asta igkagi puman sikandin tun ta duma mga manubù, na mà din, “Ni manubù ni sábbad disipulu din.” ");
INSERT INTO bgs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Asal igbulun puman si Pedro. Ándà kadugé, duwán puman duma mga manubù na igkagi ki Pedro, na mà dan, “Bánnal gó sikuna tô sábbad kadumaan din, su taga Galilea ka.” ");
INSERT INTO bgs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Asal igsapà gó si Pedro, asta igkagi sikandin, na mà din, “Agad matéya pa, ándà ku gó kilalayi tô manubù na ágkagin yu.” ");
INSERT INTO bgs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tigkô dád igukkarà tô manuk ka ikaduwa. Purisu isampáttan i Pedro tô taganà igkagi i Jesus na makatállu sikandin mulun ki Jesus ka dì pa mukkarà tô manuk ka makaduwa. Na, tuu gó igsággó sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na, tuu pô sállám, igpatóngkóé tô langun ka mallayat ka mga pangulu ka templo, tô mga ágtugállán ka Judio, asta tô mga taratinurù ka sugù. Igbagkás dan tô bállad i Jesus, asta igpid dan sikandin tun ki Pilato. ");
INSERT INTO bgs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Iginsà si Pilato ki Jesus, na mà din, “Sikuna tô Harì ka mga Judio?” Igtaba si Jesus, na mà din, “Óó. Bánnal tô igkagi nu.” ");
INSERT INTO bgs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na, marapung tô dimanda katô mallayat ka mga pangulu ka templo tingód ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Igkagi si Pilato, na mà din, “Marapung tô dimanda dan tingód áknikó. Ándà mataba nu kandan?” ");
INSERT INTO bgs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Asal ándà gó taba si Jesus. Purisu isalábbuan si Pilato. ");
INSERT INTO bgs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, kada ámmé dalám ka Kalimudan Ka Kalabé, duwán ágkémun katô gobernador na ágpaluwaán din tô sábbad manubù na igpriso, agad sadan tô salinán katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na, duwán mga igpriso su igatu dan ka gobyerno asta duwán igmatayan dan. Duwán sábbad tun kandan na ágngadanan ki Barabas. ");
INSERT INTO bgs_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Marapung tô mga manubù na igpadani tun ki Pilato, asta igpamuyù dan na paluwaán din tô igpriso, su tô gó é ágkémun din. ");
INSERT INTO bgs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Purisu iginsà si Pilato, na mà din, “Kakalyag yu na paluwaán ku tô Harì ka mga Judio?” ");
INSERT INTO bgs_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tô gó é igkagi i Pilato, su isóddóran din na igpammát tô mallayat ka mga pangulu ka templo ki Jesus su gingà dan dád kandin. ");
INSERT INTO bgs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Asal tô mallayat ka mga pangulu ka templo igsutsut katô ilimud mga manubù ébô paluwaán din baling si Barabas. ");
INSERT INTO bgs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iginsà puman si Pilato, na mà din, “Pamánnun ku tô manubù na ágtawarán yu na Harì ka mga Judio?” ");
INSERT INTO bgs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Igullaó puman sikandan, na mà dan, “Papansali nu sikandin tun ta krus!” ");
INSERT INTO bgs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Iginsà si Pilato, na mà din, “Manan? Ándin é iglumu din na madat?” Asal igtuu baling igmabákkár tô kóllaó dan, na mà dan, “Pamatayi nu sikandin! Papansali nu sikandin tun ta krus!” ");
INSERT INTO bgs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Purisu igpaluwà i Pilato si Barabas tikud tun ta prisowan, su kakalyag din na kadayawan tô marapung manubù. Igpalagpás din si Jesus, asta igbággé din tun ta mga sundalo ébô pansalan tun ta krus. ");
INSERT INTO bgs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na, igpid katô mga sundalo si Jesus tun dalám ka balé katô gobernador, asta iglimud dan tô langun kadumaan dan na mga sundalo. ");
INSERT INTO bgs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Igumpakan dan sikandin ka mallutù umpak iring katô gumpakán ka harì. Igpákkù dan tô dugin balagán, asta tô gó é igkorona dan tun ta ulu din. ");
INSERT INTO bgs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mà kagi ágtanggap dan ka harì, na mà dan, “Durungán ka na Harì ka mga Judio!” ");
INSERT INTO bgs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iglagpás dan tô ulu din ka balakayu, asta igilábban dan sikandin. Iglingkóód dan tun ta saruwan din iring na karespeto dan ka harì. ");
INSERT INTO bgs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pángnga igbuyas-buyas dan kandin, iglusut dan tô mallutù umpak tikud tun kandin, asta igpómpak dan puman ki Jesus tô kandin umpak. Igpid dan sikandin ébô pansalan tun ta krus. ");
INSERT INTO bgs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na, duwán sábbad taga Cirene na ágngadanan ki Simon na ámmà i Alejandro asta i Rufo. Mantu sikandin igdunggù tikud tun ta kinamát. Igpirit dan sikandin igpatiang katô krus na pansalan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Igpid dan si Jesus tun ta lugar na ágngadanan Golgota. (Tô kóbadan, “Bóngó-bóngó.”) ");
INSERT INTO bgs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Igbággé dan ki Jesus tô bino na igbaláttan ka bawì na ágngadanan mira, asal ándà din inámmi. ");
INSERT INTO bgs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Igpansalan katô mga sundalo si Jesus tun ta krus. Igtalad-talad dan tô umpak din ukit ka ripa ébô kasóddóran dan ka ándin tô piddán katô tagsábbad-sábbad kandan. ");
INSERT INTO bgs_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tô mga alas nuybe ka sállám, igpansalan dan sikandin tun ta krus. ");
INSERT INTO bgs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Duwán igsulat tingód katô dimanda kandin, na ágkabasa, “TÔ HARÌ KA MGA JUDIO.” ");
INSERT INTO bgs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Madani tun ki Jesus, duwán duwa tulisan na igpansalan tun ta duwa krus, tô sábbad dadan tun ta ibang din asta tô sábbad dadan tun ta kawanan din. ");
INSERT INTO bgs_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Purisu ituman tô kagi ka Manama na igsulat sayyan, “Péringán sikandin katô mga masalà-salà.” ");
INSERT INTO bgs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tô mga manubù na iglabé dutun, igkiring-kiring dan na igbuyas-buyas kandin, asta igkagi sikandan, na mà dan, “Atin ka sikuna tô makému dumadat katô balé ka Manama, asta patindággán nu puman dalám ka tállu álló, ");
INSERT INTO bgs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","tabangi nu tô áknikó sarili, asta pónóg ka tikud dun ta krus!” ");
INSERT INTO bgs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Igbuyas-buyas pagsik tô mallayat ka mga pangulu ka templo asta tô mga taratinurù ka sugù. Igkagi sikandan, na mà dan, “Igtabangan din tô duma mga manubù ébô dì dan maté. Asal dì sikandin makatabang katô kandin sarili ébô dì maté. ");
INSERT INTO bgs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mólà pa ka mónóg tô Mesiyas na Harì ka mga rubbad i Israel tikud tun ta krus ébô kitanán ta asta mamaké ki kandin.” Igbuyas-buyas pagsik tô duwa manubù na igpansalan tun ta krus duma kandin. ");
INSERT INTO bgs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na, tô malássád dán tô álló, igmangittáng tô kaluwagan kani banuwa dalám ka tállu oras. ");
INSERT INTO bgs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tô mga alas tres dán ka mapun, igullaó si Jesus, na mà din, “Eloi, Eloi, lama sabaktani?” Tô kóbadan, “Manama ku, Manama ku, manan ka igpabayà a ikuna?” ");
INSERT INTO bgs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tô igdinág tô duma mga manubù kandin, igkagi sikandan, na mà dan, “Na, igtawar sikandin ki Elias na propeta ka Manama sayyan.” ");
INSERT INTO bgs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Duwán sábbad manubù na igpalaguy, igkangé ka espungha, asta igarám tun ta bino na igbaláttan ka wayig. Igtakós din tun ta balakayu asta igpadatas tun ta babbà i Jesus. Duwán igkagi, na mà din, “Pabayà nu sikandin, su sállággán ta ka dumunggù si Elias ébô mangé kandin.” ");
INSERT INTO bgs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Igullaó si Jesus, asta inaté sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tigkô dád itángngà tô tabir tun ta tángngaan katô templo. Itángngà tikud tun datas sippang tun ta asag. ");
INSERT INTO bgs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na, duwán kapitan ka mga sundalo na igtubang ki Jesus. Tô igkita sikandin katô kamatayan i Jesus, igkagi sikandin, na mà din, “Bánnal gó na Batà sikandin ka Manama!” ");
INSERT INTO bgs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Duwán pagsik mga gabayi tun ta madiyù puri na ikakita katô ilumu. Tô mga igapil kandan si Maria na taga Magdala, si Salome, asta si Maria na innà katô mallaki na si Santiago asta si Jose. ");
INSERT INTO bgs_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sikandan tô taganà igtákkás ki Jesus dutun ta probinsya ka Galilea asta igtabang kandin. Duwán pagsik marapung duma mga gabayi na igtákkás ki Jesus sippang tun ta Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Na, tô mapun dán, igdunggù si Jose na taga Arimatea. Sikandin tô sábbad igrespetowan membro ka ágruudanan, asta giman sikandin katô pagpangulu ka Manama. Tô ándà pa dunggù tô álló ka kapaginawa, igpabákkár din tô pusung din, igsadun tun ki Pilato, asta igpamuyù din tô lawa i Jesus ébô lábbángngán din. ");
INSERT INTO bgs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tô igdinág si Pilato na inaté dán si Jesus, isalábbuan sikandin. Purisu igpakangé din tô kapitan ka sundalo, asta iginsà ka inaté dán si Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tô igulit tô kapitan na inaté dán gó, ignunug si Pilato na mému kangén i Jose tô lawa. ");
INSERT INTO bgs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Purisu igbálli si Jose ka mapputì óggét, igkangé din tô lawa i Jesus tikud tun ta krus, asta igtángngás din katô mapputì óggét. Iglábbáng din tun ta lábbáng na igpému tun ta pangpang. Iglilid din tô dakál batu na pagsagpáng katô lábbáng. ");
INSERT INTO bgs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Si Maria na taga Magdala asta tô sangé din si Maria na innà i Jose tô igkita katô iglábbángngan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na, pángnga katô álló ka kapaginawa, igpatákkássé si Maria na taga Magdala, asta tô sangé din si Maria na innà i Santiago, asta si Salome. Igbálli dan ka pamammut ébô duwán busbusán dan tun ta lawa i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tô álló ka Linggo, igsállám dan igsadun tun ta lábbáng. ");
INSERT INTO bgs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tô ándà dan pa dunggù, igpénsaé sikandan, na mà dan, “Sadan tô lumilid katô batu na igsagpáng katô lábbáng ébô makahu ki?” ");
INSERT INTO bgs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na, tô igsállág dan, igkita dan na taganà dán ililid tô batu na igsagpáng. Tuu dakál tô batu. ");
INSERT INTO bgs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tô igahu dan tun ta lábbáng, igkita dan tô mallaki na igunsad dadan tun ta kawanan asta igumpak ka kapa na tuu mapputì. Imáddangan tô mga gabayi. ");
INSERT INTO bgs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na, igkagi sikandin, na mà din, “Yakó ágkamáddangan. Isóddóran ku na igpamasak kó ki Jesus na taga Nazaret na igpansalan tun ta krus. Ándà dini su inanté dán puman sikandin. Sállág yu ni igpadággaan kandin. ");
INSERT INTO bgs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Asal panó kó asta uliti yu tô mga disipulu din asta si Pedro na ikóna dán si Jesus igsadun tun ta probinsya ka Galilea. Kitanán yu sikandin dutun, su tô gó é igkagi din ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Purisu igluwà dan tikud tun ta lábbáng, asta igpalaguy dan, su igkárkár dan asta isalábbuan dan. Ándà palang manubù na igulitan dan su imáddangan dan. ");
INSERT INTO bgs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, tô inanté puman si Jesus tô tuu sállám ka Linggo, si Maria na taganà igpaluwaan ka pittu madat espiritu tô una igpakitaan i Jesus. ");
INSERT INTO bgs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Igsadun si Maria tun ta mga disipulu i Jesus na iranu asta igsággó, asta igulit sikandin tingód katô igkita din. ");
INSERT INTO bgs_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tô igdinág dan na inanté puman si Jesus asta igkita si Maria kandin, ándà dan bánnal. ");
INSERT INTO bgs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na, tô igpanó tô duwa disipulu tun ta pabunganán, igpakita si Jesus tun kandan, asal ipalin tô bónnóng din. ");
INSERT INTO bgs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iglónód dan tun ta Jerusalem, asta igulit dan katô duma mga disipulu din, asal ándà dan bánnal kandan. ");
INSERT INTO bgs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na, igpakita si Jesus tun ta sapulù sábbad (11) mga disipulu din róggun igkan dan. Igsawé si Jesus kandan su ándà dan bánnal asta matággas tô ulu dan, su ándà dan bánnal katô mga manubù na ikakita kandin pángnga inanté puman sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na, igkagi si Jesus, na mà din, “Sadun kód tun ta kaluwagan kani banuwa, asta ulit-ulit yu tô Madigár Gulitán tingód kanak tun ta langun manubù. ");
INSERT INTO bgs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tô manubù na mamaké asta pabunyag, tábbusán sikandin tikud tun ta salà. Asal tô manubù na dì mamaké, supakan sikandin. ");
INSERT INTO bgs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ni gó tô mga kasalábbuan na lumun katô mga manubù na ágpamaké kanak. Paluwà dan katô madat mga espiritu tikud tun ta manubù ukit ka ngadan ku. Kumagi dan ka ássa-ássa mga kinagiyan. ");
INSERT INTO bgs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Atin ka makawid dan ka áppuy, atin ka makénám dan ka pakélu, dì dan mamánnu. Atin ka dappánnan dan tô mga ágkabógókan, kólian gó sikandan.” ");
INSERT INTO bgs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Na, pángnga igkagi tô Áglangngagán na si Jesus kandan, ibatun sikandin tun ta langit, asta igunsad dadan tun ta kawanan katô Manama. ");
INSERT INTO bgs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na, igpanó tô mga disipulu i Jesus tikud tun ta Jerusalem, asta igulit-ulit dan katô kagi ka Manama tun ta kaluwagan ka banuwa, agad ánda é igsadunan dan. Igtabangan dan katô Áglangngagán, asta igpasóddór din na bánnal tô igtinurù dan ukit katô mga kasalábbuan na iglumu dan. Matuman ni!");
INSERT INTO bgs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Madigár rarak ku Teofilo: Marapung dán tô mga manubù na igsulat tingód katô inému dini áknita. ");
INSERT INTO bgs_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tô igsulat dan, tô gó é igulit katô mga manubù na igkita katô langun linumuwan i Jesus tikud tun ta katigkanayan, asta igulit-ulit dan áknami tô kagi katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Madigár rarak ku, igahà ku tô langun linumuwan din tikud tun ta katigkanayan. Purisu igpanámdámma na kailangan tapidán ku asta sulatán ku tô langun para áknikó ");
INSERT INTO bgs_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ébô kasóddóran nu na bánnal gó tô mga igtinurù áknikó. ");
INSERT INTO bgs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dángngan, dalám katô igharì si Herodes tun ta probinsya ka Judea, duwán sábbad pangulu ka templo na ágngadanan ki Zacarias. Sikandin tô sábbad pangulu ka templo na sakup ka grupo i Abias. Duwán sawa i Zacarias na ágngadanan ki Elisabet na sábbad rubbad i Aaron na pangulu ka templo sayyan. ");
INSERT INTO bgs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Idayawan tô Manama kandan duwa, su nángngà tô áglumun dan tun ta saruwan ka Manama. Ágbánnal dan katô langun sugù katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ándà palang batà dan, su dì ágbatà si Elisabet, asta tugál dan dán duwa. ");
INSERT INTO bgs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Duwán sábbad álló na iglumu si Zacarias tun ta templo, su tô gó tô mga álló ka kalumu katô grupo na isakupan din tun ta templo. ");
INSERT INTO bgs_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tô ágkémun katô mga pangulu ka templo, igripa dan ka sadan tun kandan tô gumóbbó ka pamammut, asta si Zacarias tô isalin ukit ka ripa. Purisu igahu sikandin tun ta templo katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Róggun na ággóbbó sikandin katô pamammut tun dalám, marapung tô mga manubù na ágdasal tun ta luwà. ");
INSERT INTO bgs_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Duwán sábbad panaligan katô Áglangngagán na igpakita ki Zacarias tun ta ággóbbówanan katô pamammut dadan tun ta kawanan. ");
INSERT INTO bgs_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tô igkita si Zacarias katô panaligan, igkállas sikandin, asta imáddangan. ");
INSERT INTO bgs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Asal igkagi tô panaligan, na mà din, “Zacarias, yaka ágkamáddangan. Igdinág dán ka Manama tô áknikó dasalán, su duwán batà nu mama na pamasusun katô sawa nu na si Elisabet. Kailangan ngadanan nu sikandin ki Juan. ");
INSERT INTO bgs_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tuu ka gó kadayawan, asta marapung tô mga manubù na kadayawan tingód katô kapamasusu kandin, ");
INSERT INTO bgs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","su imun sikandin mabantug tun ta saruwan katô Áglangngagán. Dì gó minám sikandin ka bino ó agad ándin tô ginámmán na pakalasing. Agad tô dì pa sikandin mapamasusu, kapánnuan sikandin katô Ugis Espiritu. ");
INSERT INTO bgs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ukit kandin, marapung tô mga rubbad i Israel na lumónód tun ta Áglangngagán dan na Manama. ");
INSERT INTO bgs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Muna sikandin katô Áglangngagán, asta duwán katulusan din ébô mulit-ulit ka kagi katô Áglangngagán iring ki Elias na propeta katô Áglangngagán sayyan. Ukit kandin, duwán kasunayan katô mga ámmà asta gabatà, asta tô mga manubù na dì ágbánnal ka Manama, palónódán tô panámdám dan tun ta katallángngan ébô makataganà dan ka kadunggù katô Áglangngagán.” ");
INSERT INTO bgs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Igkagi si Zacarias tun ta panaligan, na mà din, “Pamánnun ku ka kasóddór tô katumanan kani ágkagin nu kanak? Su tugállad, asta tugál dán tô sawa ku.” ");
INSERT INTO bgs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Igtaba tô panaligan, “Sakán si Gabriel, asta inalayunna ágtindág tun ta saruwan ka Manama. Igpapidda ikandin dini áknikó ébô pasóddórán ni madigár gulitán áknikó. ");
INSERT INTO bgs_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na, tikud áknganni, mómmó ka, su ándà ka bánnal katô igkagi ku áknikó. Dì ka makakagi sippang ka dumunggù tô álló na matuman ni igkagi ku, su matuman gó ni tun ta nángngà álló.” ");
INSERT INTO bgs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na, tô mga manubù tun ta plasa katô templo, igangat dan katô kaluwà i Zacarias, asta isalábbuan dan su idugé sikandin tun dalám. ");
INSERT INTO bgs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tô igluwà sikandin tikud tun ta templo, dì dán sikandin pakakagi. Purisu isóddóran dan na duwán igpakita katô Manama kandin tun dalám katô templo. Asal marag dád sikandin ágsingyas ukit ka bállad din, su inómmó dán. ");
INSERT INTO bgs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pángnga iglumu si Zacarias tun ta templo, igulì sikandin tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ándà kadugé, igmabáddás tô sawa i Zacarias na si Elisabet. Dalám ka lima bulan, ándà sikandin luwà tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Igkagi sikandin, na mà din, “Inéduwan gó tô Áglangngagán kanak. Igkangé din dán dini kanak tô kayyaan ku, su sippang áknganni ándà a ikabatà.” ");
INSERT INTO bgs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tô ánnám dán bulan tô gátták i Elisabet, igpapid ka Manama tô panaligan din na si Gabriel tun ta lunsud ka Nazaret na sakup ka probinsya ka Galilea. ");
INSERT INTO bgs_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Duwán sábbad bayi na ándà pa kalayuki na ágngadanan ki Maria. Duwán banà din na ágngadanan ki Jose na sábbad rubbad i Harì David sayyan. ");
INSERT INTO bgs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tô igdunggù si Gabriel tun ki Maria, igkagi sikandin, na mà din, “Kadayawan ka! Ágkéduwan tô Áglangngagán áknikó, asta ágtákkássan ka ikandin!” ");
INSERT INTO bgs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Isalábbuan si Maria tingód katô igkagi katô panaligan. Igpanámdám sikandin ka ándin tô kóbadan kani. ");
INSERT INTO bgs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Igkagi tô panaligan, na mà din, “Maria, yaka ágkamáddangan, su inéduwan tô Manama áknikó. ");
INSERT INTO bgs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kumabáddás ka, asta duwán batà mama na pamasusun nu, asta ngadanan nu tô batà ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mabantug sikandin, asta tawarán sikandin na Batà ka Manama na Tuu Mallayat. Imun katô Áglangngagán na Manama sikandin na harì iring katô kamónaan din sayyan na si David. ");
INSERT INTO bgs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mangulu sikandin katô langun rubbad i Jacob sippang ka ándà ágtamanán. Ándà dán ágtamanán katô pagpangulu din.” ");
INSERT INTO bgs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Igkagi si Maria tun ta panaligan, na mà din, “Ándà pa duma ku. Purisu pamánnun na mému ni?” ");
INSERT INTO bgs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Igtaba tô panaligan, na mà din, “Sunnadan ka katô Ugis Espiritu, asta tabangan ka ukit katô katulusan ka Manama na Tuu Mallayat. Purisu tô batà na pamasusun nu, ándà salà din, asta tawarán sikandin na Batà ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na, paminág ka kanak. Tô gakád nu na si Elisabet, agad isóddóran ka mga duma na dì sikandin matà su tugál dán sikandin, asal igmabáddás dán sikandin ka ánnám bulan, ");
INSERT INTO bgs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","su ágkému katô Manama tô langun.” ");
INSERT INTO bgs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Igkagi si Maria, na mà din, “Inalayunna ágbánnal katô Áglangngagán. Mólà pa na matuman dini kanak tô igkagi nu.” Na, igiwà tô panaligan. ");
INSERT INTO bgs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ándà kadugé, sékót si Maria igsadun tun ta pabungan sippang tun ta sábbad lunsud na sakup ka probinsya ka Judea. ");
INSERT INTO bgs_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Igahu si Maria tun ta balé i Zacarias, asta igpangumusta sikandin ki Elisabet. ");
INSERT INTO bgs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tô igdinág si Elisabet katô kapangumusta i Maria, igkálláng-kálláng tô batà tun dalám katô gátták din, asta ipánnuan si Elisabet katô Ugis Espiritu. ");
INSERT INTO bgs_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Purisu igkagi si Elisabet ka mabákkár, na mà din, “Tun ta langun gabayi, inéduwan tô Manama áknikó ka tandingán kandan, asta inéduwan tô Manama katô pamasusun nu! ");
INSERT INTO bgs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Dakál gó tô dayó ku su igahà a katô innà katô Áglangngagán ku. ");
INSERT INTO bgs_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tô igdinágga katô kapangumusta nu, agad tô batà tun dalám katô gátták ku idayawan asta igkálláng-kálláng. ");
INSERT INTO bgs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ágkadayawan ka su igbánnal ka na tumanán katô Áglangngagán tô igkagi din áknikó.” ");
INSERT INTO bgs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na, igkagi si Maria, na mà din, “Ágdurungán ku tô Áglangngagán, ");
INSERT INTO bgs_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","asta idayawanna tingód katô Manama na Taratábbus ku, ");
INSERT INTO bgs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","su agad mabbabà dád tô kamanubuan ku, asal isampáttanna katô Manama. Purisu tikud áknganni, kumagi tô langun manubù na ágkéduwan tô Manama kanak, ");
INSERT INTO bgs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","su madigár tô mga kasalábbuan na iglumu katô matulus Manama kanak, asta ugis gó sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tikud tun ta katigkanayan, ágpanayun tô kédu katô Manama tun ta langun ka karubbadan na ágpangadap asta ágbánnal kandin. ");
INSERT INTO bgs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ágpasóddórán din na matulus sikandin ukit katô mga áglumun din. Ágpéwaán din tô mga manubù na ágpallayat-layat katô sarili dan. ");
INSERT INTO bgs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Giwaán din tô mga pangulu tikud tun ta gunsadanan dan, asta gimun din na mallayat tô kamanubuan katô mga ágpabbabà. ");
INSERT INTO bgs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tô mga manubù na ágpamballusán, gimássugán din ka kadigárran. Asal tô mga ágkaduwánnan manubù ágpéwaán din na ándà ágkapid. ");
INSERT INTO bgs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sikita na mga rubbad i Israel na ágbánnal kandin tô igtabangan din. Ándà din kalingawi tô tandô din na kéduwan sikandin kandan, ");
INSERT INTO bgs_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","su igtandóan ka Manama si Abraham asta tô mga rubbad din na kéduwan sikandin kandan sippang ka ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na, igóddô si Maria tun ki Elisabet dalám ka mga tállu bulan, asta igulì sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na, igdunggù tô álló ka kapamasusu i Elisabet, asta batà mama tô ipamasusu din. ");
INSERT INTO bgs_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Igdinág tô mga simbalé din asta tô mga gakád din na tuu inéduwan tô Áglangngagán kandin, asta idayawan dan pagsik. ");
INSERT INTO bgs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na, tun ta ikawalu álló tikud tun ta kapamasusu katô batà, igpalimudé tô mga simbalé din asta tô mga gakád din ébô tupuwan asta ngadanan tô batà. Kakalyag dan na ngadanan sikandin ki Zacarias na magunawa ka ngadan katô ámmà din. ");
INSERT INTO bgs_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Asal igkagi si Elisabet, na mà din, “Dì mému yan, su kailangan Juan tô ngadanán kandin.” ");
INSERT INTO bgs_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Igkagi sikandan ki Elisabet, “Asal ándà gó kaditaan yu na duwán ngadan iring kanan.” ");
INSERT INTO bgs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na, igsingyas dan ki Zacarias ka ándin tô ngadan na inalyagan din. ");
INSERT INTO bgs_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Igsingyas sikandin na bággayan ka ágsulatan, asta igsulat din ni kagi, “Si Juan tô ngadanán kandin.” Isalábbuan dan gó langun. ");
INSERT INTO bgs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tigkô ikakagi dán si Zacarias, asta igdurung din tô Manama. ");
INSERT INTO bgs_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Igkállas tô langun simbalé dan, asta italap tô tingód kani langun ilumu tun ta kaluwagan ka pabunganán tun ta probinsya ka Judea. ");
INSERT INTO bgs_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ikapanámdám tô langun na ikadinág tingód kani, asta igpénsaé dan, na mà dan, “Ándin basì tô dungguán kani batà?” Su duwán gó katulusan katô Áglangngagán tun kandin. ");
INSERT INTO bgs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na, si Zacarias ipánnuan katô Ugis Espiritu, asta igpakagi ka Manama sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Durungán ta tô Áglangngagán na Manama na ágsarigan katô langun rubbad i Israel, su igpakita sikandin áknita ébô tábbusán ki ikandin na mga sakup din. ");
INSERT INTO bgs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Duwán papiddán katô matulus Manama ébô tumábbus áknita tikud tun ta salà. Sikandin tô sábbad rubbad i David na ágbánnal katô Manama sayyan. ");
INSERT INTO bgs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ni gó é igtandô ka Manama sayyan ukit ka mga propeta na igbánnal kandin, su igkagi sikandin ");
INSERT INTO bgs_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","na tabangan ki ikandin ébô makaluwà ki tikud tun ta bállad katô mga usig ta asta tikud tun ta mga manubù na ágkaringasa áknita. ");
INSERT INTO bgs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Igtandô katô Manama na kéduwan din tô mga kamónaan ta, asta ándà din kalingawi tô kasabotan din. ");
INSERT INTO bgs_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Igtandô din tun ta kamónaan ta na si Abraham ");
INSERT INTO bgs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na paluwaán ki ikandin tikud tun ta bállad katô mga usig ta ébô mangadap ki kandin na ándà máddang ta. ");
INSERT INTO bgs_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kakalyag ka Manama na ándà salà ta, asta nángngà tô áglumun ta tun ta saruwan din ka ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Na, sikuna na batà ku, tawarán ka na propeta ka Manama na Tuu Mallayat. Muna ka katô Áglangngagán ébô taganaán nu tô mga manubù tingód ka kadunggù katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Sikuna tô pasóddór tun ta mga sakup din na matábbus dan ukit katô kapasinsiya din katô mga salà dan. ");
INSERT INTO bgs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tingód katô kédu asta ginawa ka Manama, dumunggù tô papiddán din tikud tun ta langit iring katô kasilat ka álló ébô tábbusán ki ikandin. ");
INSERT INTO bgs_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Suméllà sikandin dini áknita na góddô tun ta kangittángngan asta imáddangan katô kamatayan, ébô pakitanán ki ikandin katô gukitan na ágsadun tun ta kasunayan.” ");
INSERT INTO bgs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na, igdakál si Juan, asta ágkasarigan sikandin. Igóddô sikandin tun ta disyerto sippang katô álló na igpakita sikandin tun ta mga rubbad i Israel. ");
INSERT INTO bgs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na, dalám katô si Augusto tô emperador tun ta Roma, duwán sugù din na kailangan palistan tô ngadan katô langun manubù na isakup katô gobyerno ka Roma. ");
INSERT INTO bgs_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ni gó tô una kapalista ka ngadan dalám katô si Cirenio tô gobernador tun ta Siria. ");
INSERT INTO bgs_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Purisu igpansadun tô langun manubù tun ta lunsud katô kamónaan dan ébô palistan tô ngadan dan. ");
INSERT INTO bgs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tô gó tô gunayan na igpanó si Jose tikud tun ta lunsud ka Nazaret na sakup ka probinsya ka Galilea, asta igsadun sikandin tun ta probinsya ka Judea sippang tun ta lunsud ka Betlehem, su Betlehem tô lunsud na igtikudan katô kamónaan din na si Harì David sayyan. ");
INSERT INTO bgs_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Igpid i Jose tô banà din na si Maria na mabáddás dán ébô palistan tô ngadan dan. ");
INSERT INTO bgs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na, róggun dutun dan, igdunggù tô álló na mamasusu dán si Maria. ");
INSERT INTO bgs_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Igbatà sikandin katô tambang kaké batà din na mama. Igtángngás i Maria tô batà ka óggét, asta igpadággà din tun ta ágkannanan ka mannanap, su ándà lugar para kandan tun ta balé na ágdungguanan. ");
INSERT INTO bgs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, madani tun ta lunsud ka Betlehem, duwán mga taradóppón ka karnero na igladé ka dukilám igdóppón ka mga karnero dan tun ta sigbáttán tanà. ");
INSERT INTO bgs_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tigkô duwán sábbad panaligan katô Áglangngagán na igpakita kandan. Igséllaan tô mga taradóppón katô séllaán katô Áglangngagán, asta tuu dan gó imáddangan. ");
INSERT INTO bgs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Asal igkagi tô panaligan, na mà din, “Yakó ágkamáddangan! Duwán madigár gulitán ku ákniyu na makabággé ka dayó tun ta langun manubù. ");
INSERT INTO bgs_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ni dukilám ni, tun ta lunsud na igtikudan i Harì David sayyan, ipamasusu tô ákniyu Taratábbus. Sikandin tô Mesiyas na Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni gó tô kakilalaan ébô kasóddóran yu na bánnal ni igulit ku ákniyu. Kitanán yu tô batà na igtángngás ka óggét, asta igpadággà tun ta ágkannanan ka mga mannanap.” ");
INSERT INTO bgs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tigkô dád igláttó tô marapung mga panaligan tikud tun ta langit na igduma katô tagnà, asta igdurung dan katô Manama, na mà dan, ");
INSERT INTO bgs_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Durungán tô Manama tun datas ta langit. Duwán kasunayan tun ta mga manubù na makadayó ka Manama dini ta banuwa!” ");
INSERT INTO bgs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tô igulì dán tô mga panaligan tun ta langit, igpatóngkóé tô mga taradóppón ka karnero, na mà dan, “Madun ki tun ta Betlehem ébô kitanán ta tô ilumu na igpasóddór katô Áglangngagán áknita.” ");
INSERT INTO bgs_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Purisu sékót dan igsadun tun ta Betlehem. Igkita dan si Maria asta si Jose, asta igkita dan tô batà na igpadággà tun ta ágkannanan ka mannanap. ");
INSERT INTO bgs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tô igkita dan katô batà, igulit dan tô igkagi katô panaligan kandan tingód katô batà. ");
INSERT INTO bgs_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Isalábbuan gó tô langun manubù na igdinág katô igulit katô mga taradóppón. ");
INSERT INTO bgs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tô langun katô igdinág asta igkita i Maria igtagù din tun ta pusung din, asta inalayun din ágpanámdámmán. ");
INSERT INTO bgs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Igulì tô mga taradóppón na ágpabantug asta ágdurung katô Manama tingód katô langun na igdinág asta igkita dan, su bánnal tô igulit katô panaligan kandan. ");
INSERT INTO bgs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tun ta ikawalu álló tikud tun ta kapamasusu katô batà, igtupuwan sikandin, asta igngadanan ki Jesus, su tô gó tô ngadan na igkagi katô panaligan ki Maria tô ándà pa sikandin mabáddás. ");
INSERT INTO bgs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na, igdunggù tô álló na igsadun si Jose asta si Maria tun ta Jerusalem ébô mánnal katô sugù i Moises tingód ka mantu igpamasusu. Igpid dan tô batà ébô bággén tun ta Áglangngagán, ");
INSERT INTO bgs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","su duwán sugù katô Áglangngagán na kailangan bággén tun ta Áglangngagán tô langun ka panganayan mga gabatà gamama. ");
INSERT INTO bgs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Igsadun si Jose asta si Maria tun ta templo ébô góbbón dan tun ta saruwan katô Áglangngagán tô duwa manatad ó duwa salapati na marénták pa, su tô gó tô igsugù katô Áglangngagán tingód ka mantu igpamasusu. ");
INSERT INTO bgs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, duwán sábbad taga Jerusalem na ágngadanan ki Simeon. Nángngà tô áglumun din tun ta saruwan ka Manama, asta ágbánnal sikandin ka Manama. Inalayun sikandin giman katô álló na paluwaán ka Manama tô mga rubbad i Israel. Inalayun sikandin ipánnuan katô Ugis Espiritu. ");
INSERT INTO bgs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Taganà igpasóddór katô Ugis Espiritu na dì pa maté sikandin sippang ka kitanán din tô Mesiyas na papiddán katô Áglangngagán. ");
INSERT INTO bgs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na, tô álló tô, igpid katô Ugis Espiritu si Simeon tun ta templo. Tô igpid tô ámmà asta tô innà ki Jesus tun ta templo ébô tumanán dan tô sugù ka Manama, ");
INSERT INTO bgs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","igsipit i Simeon tô batà, asta igpasalamat sikandin ka Manama, na mà din, ");
INSERT INTO bgs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Áglangngagán ku, ituman dán tô igtandô nu kanak. Purisu mému dán ka matéya na duwán kasunayan. ");
INSERT INTO bgs_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Igkita kud tô igpapid nu ébô tumábbus áknami tikud tun ta salà dé. ");
INSERT INTO bgs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sikandin tô igtaganà nu tun ta tubang katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iring sikandin katô sulù, su pakitanán din tô kakalyag nu tun ta langun manubù na ánnà Judio, asta ukit kandin pabantugán ké na mga rubbad i Israel na igsalin nu.” ");
INSERT INTO bgs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na, isalábbuan tô ámmà asta tô innà katô igkagi i Simeon tingód katô batà. ");
INSERT INTO bgs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Igdasal si Simeon na tabangan dan ka Manama, asta igkagiyan din si Maria, na mà din, “Na, ni batà nu tô igsalin ka Manama ébô ássan din tô mga rubbad i Israel. Su marapung tô méllé kandin, asta supakan dan katô Manama. Asal marapung tô kadayawan tingód kandin, asta makaluwà dan tikud tun ta supak ka Manama, ");
INSERT INTO bgs_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","su ukit kani batà ni, pasóddórán tô panámdám katô marapung manubù. Agad sikuna, iring na kótángngan tô áknikó pusung.” ");
INSERT INTO bgs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tun ta templo, duwán sábbad bayi na ágngadanan ki Ana na propeta ka Manama. Si Panuel tô ngadan katô ámmà din na sakup katô grupo i Aser na kamónaan dan. Duwán duma i Ana, asal pittu dád ámmé tô kapadumaé dan, asta ibalu sikandin. Tugál dán sikandin, ");
INSERT INTO bgs_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","su kawaluwan áppat (84) dán é idad din. Marag sikandin ágsadun tun ta templo, su álló asta dukilám ágpangadap sikandin katô Manama, ágpuwasa, asta ágdasal. ");
INSERT INTO bgs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Róggun na igkagi pa si Simeon ki Maria, igpadani si Ana tun kandan, asta igpasalamat sikandin tun ta Manama. Igulit sikandin tingód ki Jesus tun ta langun manubù na gangat katô papiddán ka Manama ébô tumábbus katô mga taga Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na, tô igtuman dán i Jose asta i Maria tô langun sugù katô Áglangngagán tingód ka batà na mantu igpamasusu, igulì dan tun ta lunsud ka Nazaret na sakup ka probinsya ka Galilea. ");
INSERT INTO bgs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Igdakál si Jesus, igmabákkár tô lawa din, asta duwán kapandayan din, su inéduwan tô Manama kandin. ");
INSERT INTO bgs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na, kada ámmé, ágsadun tô ámmà asta tô innà i Jesus tun ta Jerusalem ébô mapil dan katô Kalimudan Ka Kalabé. ");
INSERT INTO bgs_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tô sapulù duwa (12) dán é idad i Jesus, igsadun dan tun ta Jerusalem ébô mapil dan, su tô gó tô ágkémun dan. ");
INSERT INTO bgs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tô ipángnga dán tô kalimudan, igtigkané dan igulì tun ta Nazaret. Asal si Jesus igpatanan pa tun ta Jerusalem. Tô ámmà asta tô innà din ándà ikasóddór, ");
INSERT INTO bgs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","su kéman dan ka igtákkás sikandin katô mga kadumaan dan tun ta dalan. Igladé dan ka álló igpanó. Tô mapun dán, igpamasak dan si Jesus tun ta mga kaditaan dan asta tun ta duma mga manubù na ágpanó tun ta dalan. ");
INSERT INTO bgs_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tô ikasóddór dan na ándà ikatákkás si Jesus kandan, iglónód dan tun ta Jerusalem ébô pamasakán sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tun ta ikatállu álló, igkita dan si Jesus tun ta templo. Igunsad sikandin duma katô mga taratinurù, ágpaminág sikandin, asta ginsà kandan. ");
INSERT INTO bgs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Isalábbuan tô langun na ikadinág kandin tingód katô kapandayan din asta mga taba din. ");
INSERT INTO bgs_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tô igkita tô ámmà asta tô innà din kandin, isalábbuan dan. Igkagi tô innà din, na mà din, “Ánnà nángngà tô iglumu nu áknami. Igpamasak ké áknikó su tuu ké itanaan.” ");
INSERT INTO bgs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Igtaba si Jesus, na mà din, “Isalábbuanna su igpamasak kó kanak. Nángngà pád na kasóddóran yu na kannunna ta balé katô Ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Asal ándà dan kagpátti tô igkagi i Jesus kandan. ");
INSERT INTO bgs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Igtákkás si Jesus kandan, igulì dan tun ta Nazaret, asta ágbánnal sikandin kandan. Tô langun katô igdinág asta igkita i Maria igtagù din tun ta pusung din. ");
INSERT INTO bgs_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ágkadugangan pô gó tô kapandayan i Jesus, asta ágpanayun sikandin ágdakál. Ágkadayawan tô Manama asta tô mga manubù tingód kandin. ");
INSERT INTO bgs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na, tun ta ikasapulù lima ámmé na si Tiberio tô emperador tun ta Roma, si Poncio Pilato tô gobernador tun ta Judea, si Herodes tô pangulu tun ta Galilea, tô kataladi din na si Felipe tô pangulu tun ta Iturea asta Trakonite, si Lisanias tô pangulu tun ta Abilena, ");
INSERT INTO bgs_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","asta si Anas asta si Caifas tô mga tuu mallayat ka pangulu katô templo. Na, róggun na igóddô si Juan na batà i Zacarias tun ta disyerto, igkagi tô Manama kandin. ");
INSERT INTO bgs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na, igsadun si Juan tun ta langun banuwa madani tun ta Wayig ka Jordan. Igulit-ulit sikandin na kailangan rumákkád tô mga manubù asta bunyagan dan ébô pasinsiyaan ka Manama tô mga salà dan. ");
INSERT INTO bgs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na, mà katô kagi ka Manama tingód ki Juan tun ta libro katô propeta na si Isaias, “Duwán sábbad manubù na dinággán yu na gullaó tun ta disyerto, na mà din, ‘Taganà yu tô ukitanan katô Áglangngagán. Tullid yu tô dalan na ukitan din.’ ");
INSERT INTO bgs_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tambunan tô langun banád, asta pattadán tô langun pabungan. Tullidán tô béngkóg dalan, asta piyaan tô dalan na marapung mga sábbáng asta batun. ");
INSERT INTO bgs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kitanán katô langun tô katábbus ka Manama katô mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, marapung tô mga manubù na igsadun tun ki Juan ébô pabunyag kandin. Igkagi si Juan kandan, na mà din, “Madat kó iring na mga áppuy! Manan ka pabunyag kó agad ándà kó rákkád? Kéman yu ka dì kó supakan ka Manama ka tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lumu yu tô nángngà tun ta saruwan ka Manama ébô kasóddóran na bánnal igtanan kód asta igsódô kód áglumu ka salà. Yakó ágpanámdám na dì kó supakan su sikiyu tô mga rubbad i Abraham. Kagiyan ku sikiyu na agad ni mga batu mému imun ka Manama na mga rubbad i Abraham na bullas ákniyu. ");
INSERT INTO bgs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Iring kó na kayu na masig dán pilén, su ágpilén asta ággóbbón tô langun kayu na ándà madigár buuy.” ");
INSERT INTO bgs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iginsà tô ilimud mga manubù ki Juan, na mà dan, “Ándin tô kailangan lumun dé?” ");
INSERT INTO bgs_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Igtaba si Juan, na mà din, “Atin ka duwán duwa umpak yu, bággé yu tô sábbad tun ta manubù na ándà palang gumpakán. Atin ka duwán ágkakan yu, bággéyi yu tô manubù na ándà palang ágkakan.” ");
INSERT INTO bgs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Duwán pagsik mga taralimud ka buwis na igsadun tun ki Juan ébô pabunyag dan kandin. Igkagi sikandan, na mà dan, “Sir, ándin tô kailangan lumun dé?” ");
INSERT INTO bgs_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Igtaba si Juan, na mà din, “Yakó ágpamuyù ka buwis na sobra katô sugù ka gobyerno.” ");
INSERT INTO bgs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Duwán pagsik mga sundalo na iginsà kandin, na mà dan, “Na, sikami, ándin é kailangan lumun dé?” Igtaba si Juan, na mà din, “Yakó ágpirit katô manubù ébô bággayan kó ka salapì. Yakó ágdimanda ukit ka bulaló ébô bággayan kó ka salapì. Asal agad ándin é tandan katô gobyerno para ákniyu, kailangan kanángngaan kó.” ");
INSERT INTO bgs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na, tô igdinág tô mga manubù ki Juan, igpanámdám dan na si Juan dán gó tô Mesiyas na gangatan dan. ");
INSERT INTO bgs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Asal igkagi si Juan, na mà din, “Ágbunyagga ákniyu ka wayig. Asal duwán pa dumunggù na tuu pa mallayat tô kamanubuan din ka tandingán kanak. Ánnà a nángngà na tumabang kandin agad lumusutta dád katô sandalyas din. Sikandin tô munyag ákniyu katô Ugis Espiritu asta apuy. ");
INSERT INTO bgs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iring sikandin na manubù na ágpalayap ka trigo na igarik din, tipunán din, asta taguán din tun ta lukung. Asal tô uut asta uppis góbbón din tun ta apuy na dì ágkapadáng.” ");
INSERT INTO bgs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Igulit-ulit i Juan tô Madigár Gulitán tun ta langun manubù, asta igkagiyan din sikandan na kailangan bánnalán dan tô ágtinuruán din. ");
INSERT INTO bgs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na, si Herodes tô pangulu tun ta Galilea. Asal igsapadan i Juan sikandin, su igagó din tô ipag din na si Herodias, asta marapung pa tô madat mga linumuwan din. ");
INSERT INTO bgs_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tun ta katapuriyan, igdugangan pô gó i Herodes tô mga salà din su igpapriso din si Juan. ");
INSERT INTO bgs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na, tô ándà pa prisowi si Juan, duwán álló na igbunyag sikandin katô langun manubù, asta igpabunyag pagsik si Jesus. Róggun na igdasal si Jesus, ipókéan tô langit, ");
INSERT INTO bgs_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","asta igsunnad tô Ugis Espiritu tun kandin na iring na bónnóng ka salapati. Duwán kagi tikud tun ta langit, na mà din, “Sikuna tô kanak Batà na ágginawaan ku. Ágkadayawanna gó áknikó.” ");
INSERT INTO bgs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tô igtigkané si Jesus igtinurù, mga tállu pulù (30) é idad din. Kéman katô langun manubù na batà i Jose si Jesus. Si Jose tô batà i Heli. ");
INSERT INTO bgs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli tô batà i Matat. Si Matat tô batà i Levi. Si Levi tô batà i Melki. Si Melki tô batà i Jana. Si Jana tô batà i Jose. ");
INSERT INTO bgs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose tô batà i Matatias. Si Matatias tô batà i Amos. Si Amos tô batà i Nahum. Si Nahum tô batà i Esli. Si Esli tô batà i Nagai. ");
INSERT INTO bgs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai tô batà i Maat. Si Maat tô batà i Matatias. Si Matatias tô batà i Semei. Si Semei tô batà i Jose. Si Jose tô batà i Joda. ");
INSERT INTO bgs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda tô batà i Joana. Si Joana tô batà i Resa. Si Resa tô batà i Sorobabel. Si Sorobabel tô batà i Salatiel. Si Salatiel tô batà i Neri. ");
INSERT INTO bgs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri tô batà i Melki. Si Melki tô batà i Addi. Si Addi tô batà i Cosam. Si Cosam tô batà i Elmodam. Si Elmodam tô batà i Er. ");
INSERT INTO bgs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er tô batà i Josue. Si Josue tô batà i Eliezer. Si Eliezer tô batà i Jorim. Si Jorim tô batà i Matat. Si Matat tô batà i Levi. ");
INSERT INTO bgs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi tô batà i Simeon. Si Simeon tô batà i Juda. Si Juda tô batà i Jose. Si Jose tô batà i Jonan. Si Jonan tô batà i Eliakim. ");
INSERT INTO bgs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim tô batà i Melea. Si Melea tô batà i Mainan. Si Mainan tô batà i Matata. Si Matata tô batà i Natan. Si Natan tô batà i David. ");
INSERT INTO bgs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David tô batà i Isai. Si Isai tô batà i Obed. Si Obed tô batà i Boos. Si Boos tô batà i Salmon. Si Salmon tô batà i Naason. ");
INSERT INTO bgs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason tô batà i Aminadab. Si Aminadab tô batà i Aram. Si Aram tô batà i Arni. Si Arni tô batà i Esrom. Si Esrom tô batà i Fares. Si Fares tô batà i Juda. ");
INSERT INTO bgs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda tô batà i Jacob. Si Jacob tô batà i Isaac. Si Isaac tô batà i Abraham. Si Abraham tô batà i Tare. Si Tare tô batà i Nakor. ");
INSERT INTO bgs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nakor tô batà i Serug. Si Serug tô batà i Ragau. Si Ragau tô batà i Peleg. Si Peleg tô batà i Eber. Si Eber tô batà i Sala. ");
INSERT INTO bgs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala tô batà i Cainan. Si Cainan tô batà i Arfaxad. Si Arfaxad tô batà i Sem. Si Sem tô batà i Noe. Si Noe tô batà i Lamec. ");
INSERT INTO bgs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec tô batà i Metusela. Si Metusela tô batà i Enoc. Si Enoc tô batà i Jared. Si Jared tô batà i Mahalaleel. Si Mahalaleel tô batà i Cainan. ");
INSERT INTO bgs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan tô batà i Enos. Si Enos tô batà i Set. Si Set tô batà i Adan. Si Adan tô batà ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na, ipánnuan katô Ugis Espiritu si Jesus, asta igpanó sikandin tikud tun ta Wayig ka Jordan. Igpid sikandin katô Ugis Espiritu tun ta disyerto ");
INSERT INTO bgs_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","asta igtintal i Maibuyan dalám ka kappatan (40) álló. Dalám katô mga álló tô, ándà palang igkan i Jesus. Purisu igballus sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Igkagi si Maibuyan, na mà din, “Atin ka sikuna tô Batà ka Manama, imu nu pan ni mga batu.” ");
INSERT INTO bgs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Asal igtaba si Jesus, na mà din, “Diya, su mà katô kagi ka Manama, “‘Ánnà dád ágkannán é ágkailanganán katô kantayan ka manubù.’” ");
INSERT INTO bgs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na, igpid i Maibuyan si Jesus tun ta mallayat pabungan. Ándà kadugé, igpakita din ki Jesus tô langun lugar dini ta tibuk banuwa. ");
INSERT INTO bgs_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Igkagi si Maibuyan, na mà din, “Bággén ku áknikó tô pagpangulu asta tô sélaán kani langun banuwa, su igbággé kanak, asta makabággéya tun ta agad sadan tô salinán ku. ");
INSERT INTO bgs_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Atin ka mangadap ka kanak, bággén ku áknikó tô langun kani.” ");
INSERT INTO bgs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Asal igtaba si Jesus, na mà din, “Diya, su mà katô kagi ka Manama, “‘Tô dád Áglangngagán na Manama tô kailangan ágpangadapán yu, asta sikandin dád tô kailangan bánnalán yu.’” ");
INSERT INTO bgs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na, igpid i Maibuyan si Jesus tun ta Jerusalem, asta igpatindág din tun ta bówwó katô templo. Igkagi si Maibuyan, na mà din, “Na, atin ka sikuna tô Batà ka Manama, tuppas ka tun ta tanà. ");
INSERT INTO bgs_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dì ka mamánnu, su mà katô kagi ka Manama, “‘Papiddán katô Manama tô mga panaligan din ébô tumómmóng áknikó.’ ");
INSERT INTO bgs_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Sakámmán ka katô mga panaligan din ébô dì makadag tô paa nu tun ta mga batu.’” ");
INSERT INTO bgs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Asal igtaba si Jesus, na mà din, “Diya, su mà katô kagi ka Manama, “‘Yakó ágtintal katô Áglangngagán na Manama yu.’” ");
INSERT INTO bgs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na, pángnga igtintal i Maibuyan si Jesus ukit ka marapung kapókit, igiwà sikandin, asta igangat ka ássa álló. ");
INSERT INTO bgs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na, ipánnuan si Jesus ka katulusan katô Ugis Espiritu, asta igsadun sikandin tun ta probinsya ka Galilea. Ándà kadugé, ibantug sikandin tun ta mga kaligadan banuwa. ");
INSERT INTO bgs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Igtinurù sikandin tun ta mga simbaan ka Judio, asta ágpabantugán sikandin katô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na, igsadun si Jesus tun ta lunsud ka Nazaret na igdakállan din. Tô álló ka kapaginawa, igsadun sikandin tun ta simbaan ka Judio, su tô gó é ágkémun din. Igtindág sikandin ébô masa katô kagi ka Manama na igsulat. ");
INSERT INTO bgs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Igbággé dan kandin tô igsulat i Isaias na propeta sayyan. Igbákka i Jesus, igkita din ni kagi ni, asta igbasa din, na mà din, ");
INSERT INTO bgs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ipánnuannad katô Ugis Espiritu katô Áglangngagán, su igsalinna ikandin ébô mulit-ulitta katô Madigár Gulitán tun ta mga manubù na ágkayù-ayuan. Igpapidda ikandin dini ákniyu ébô mulit-ulitta tun ta mga igpriso na paluwaán dan dán. Igpapidda dini ákniyu ébô mulit-ulitta tun ta mga bólóg na makakita dan dán. Igpapidda ikandin dini ákniyu ébô tabangan ku tô langun manubù na ágkahirapan, ");
INSERT INTO bgs_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","asta pasóddórán ku na igdunggù dán tô álló na pakitanán katô Áglangngagán tô kédu din.” ");
INSERT INTO bgs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na, iglulun i Jesus tô ágbasaan na igbasa din, asta igulì din tun ta opisyales ka simbaan. Igunsad si Jesus ébô tuminurù, asta igsállág tô langun manubù kandin. ");
INSERT INTO bgs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Igtigkané si Jesus igkagi, na mà din, “Ni álló ni, ituman dán tô kagi ka Manama na igbasa ku asta igdinág yu.” ");
INSERT INTO bgs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Igdurung si Jesus katô langun manubù, asta isalábbuan dan katô madigár kagi din, su kéman dan ka batà i Jose si Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Igkagi si Jesus, na mà din, “Kakalyag yu na ulitán kanak tô igkagi tun ta panunggiringan, na, ‘Atin ka doktor ka, bawii nu tô áknikó lawa.’ Kagin yu pád kanak ni, ‘Lumu nu puman dini ta lunsud ta tô kasalábbuan, iring katô iglumu nu tun ta lunsud ka Capernaum.’ ");
INSERT INTO bgs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Asal paminág yu ni kagin ku ákniyu. Dì ágtanggapán tô propeta tun ta kandin lunsud. ");
INSERT INTO bgs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kagin ku ákniyu, na dalám katô igulit si Elias sayyan ka kagi ka Manama, duwán tuu dakál ballus tun ta langun banuwa na igóddóan katô mga kamónaan ta, asta ándà pódani katô Manama dalám ka tállu ámmé ágtángngà. Agad marapung tô mga gabayi balu na ágkahirapan tun ta mga rubbad i Israel, ");
INSERT INTO bgs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","asal ánnà sikandan tô igpasadunan ka Manama ki Elias, su igpasadun din si Elias tun ta Sarepta na sakup ka Sidon ébô tabangan tô sábbad bayi balu na ánnà Judio. ");
INSERT INTO bgs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Iring kani tô inému sayyan dalám katô kólit-ólit i Eliseo ka kagi ka Manama. Agad marapung tô mga tétékán tun ta mga rubbad i Israel, asal ánnà sikandan tô inólian, su inólian dád tô ánnà Judio na si Naaman na sakup ka Siria.” ");
INSERT INTO bgs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na, tô mga Judio na ilimud tun ta simbaan, isókó dan katô igkagi i Jesus na ágkéduwan tô Manama katô mga manubù na ánnà Judio. ");
INSERT INTO bgs_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Igtindág dan langun, asta igpéwà dan si Jesus tikud tun ta lunsud dan. Tô lunsud dan tun datas ka pabungan, asta igpid dan si Jesus tun ta pangpang, ébô dabuán dan pád. ");
INSERT INTO bgs_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Asal igukit dád si Jesus tun ta tángngaan katô mga manubù na ilimud, asta igpadiyù sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na, igsadun si Jesus tun ta lunsud ka Capernaum na sakup ka probinsya ka Galilea. Tô álló ka kapaginawa, igtinurù sikandin tun ta simbaan ka Judio. ");
INSERT INTO bgs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Isalábbuan gó tô langun manubù na igpaminág kandin, su duwán katulusan katô katinurù din. ");
INSERT INTO bgs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na, tun ta simbaan dan, duwán sábbad manubù na igahuwan ka madat espiritu. Igullaó sikandin ka mabákkár, na mà din, ");
INSERT INTO bgs_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus taga Nazaret, ándà labut nu áknami! Supakan ké ikuna? Isóddóran ku ka sadan ka. Sikuna tô ugis Batà ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Asal igsapadan i Jesus tô madat espiritu, na mà din, “Yaka gótép! Luwà ka tikud tun kandin!” Na, igbuntug katô madat espiritu tô manubù tun ta saruwan dan, asta igluwà tun kandin, asal ándà din pasakiti tô manubù. ");
INSERT INTO bgs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na, isalábbuan tô langun manubù, asta igpatóngkóé sikandan, na mà dan, “Makasalábbù tô katinurù din, su ukit katô katulusan din, ágsuguán din tô madat mga espiritu, asta ágluwà dan.” ");
INSERT INTO bgs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na, ibantug si Jesus tun ta kaluwagan ka probinsya. ");
INSERT INTO bgs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na, igpanó si Jesus tikud tun ta simbaan ka Judio, asta igsadun sikandin tun ta balé i Simon na ágngadanan din ki Pedro. Tuu ágkalinturan tô bayi na ugang i Pedro, asta igpédu-édu dan na tabangan i Jesus sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na, igtindág si Jesus madani kandin, asta igsapadan din tô kénit ka lawa katô ugang i Pedro. Tigkô dád inólian sikandin. Igánnó sikandin asta igbuwat ka ágkannán kandan. ");
INSERT INTO bgs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tô igsalláp dán tô álló, igpid katô mga manubù tun ki Jesus tô langun kadumaan dan na duwán ássa-ássa mga bógók. Igtukid i Jesus igdappánnan tô langun dan, asta inólian dan. ");
INSERT INTO bgs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Igpid pagsik tun ki Jesus tô marapung manubù na igahuwan ka madat espiritu. Na, róggun igluwà tô madat mga espiritu, igullaó sikandan, na mà dan, “Sikuna tô Batà ka Manama!” Asal igsapadan i Jesus sikandan ébô dì dan pakakagi, su isóddóran dan na sikandin tô Mesiyas. ");
INSERT INTO bgs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na, pagkasimag, igpanó si Jesus, asta igsadun sikandin tun ta lugar na ándà manubù. Asal igpamasak tô marapung manubù kandin. Tô igkita dan kandin, igpédu-édu dan na dì pád panó sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Asal igkagi si Jesus, na mà din, “Kailangan madunna tun ta ássa mga lunsud ébô mulit-ulitta pagsik kandan katô Madigár Gulitán tingód ka pagpangulu ka Manama, su tô gó tô gunayan ku na igsadunna nit banuwa.” ");
INSERT INTO bgs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na, igulit-ulit si Jesus tun ta mga simbaan dan tun ta kaluwagan ka Judea. ");
INSERT INTO bgs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na, duwán sábbad álló, igtindág si Jesus tun ta ligad ka ranó na ágngadanan Genesaret. Igpaliggátté tô langun manubù na garurung madani tun ki Jesus, su kakalyag dan na maminág katô kagi ka Manama na ágtinuruán din. ");
INSERT INTO bgs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Duwán duwa barangé na igkita din tun ta ligad ka ranó na igtananan katô mga taraággut ka sáddà, su iguras dan ka pukut. ");
INSERT INTO bgs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Igsaké si Jesus tun ta barangé i Simon, asta igkagi si Jesus na ássudán i Simon tô barangé ébô kumapó madani tun ta ligad. Igunsad si Jesus tun ta barangé, asta igtinurù sikandin katô mga manubù tun ta baklayanán. ");
INSERT INTO bgs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pángnga igtinurù si Jesus, igkagiyan din si Simon, na mà din, “Pasadun nu ni barangé nu tun ta tángngaan ka ranó, asta dabù yu tô pukut ébô duwán maggut yu.” ");
INSERT INTO bgs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Asal igtaba si Simon, na mà din, “Áglangngagán, igladé ké ka dukilám igdabù ka pukut, asal ándà palang inaggut dé! Asal su sikuna tô ágsugù kanak, dumabù a ka pukut.” ");
INSERT INTO bgs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Igdabù dan tô pukut, asta ikaggut dan ka marapung mga sáddà. Na, su masig pád mabissé tô pukut dan, ");
INSERT INTO bgs_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","iginggat dan tô mga kadumaan dan tun ta ássa barangé ébô tumabang kandan. Tô igdunggù dan, igruran dan tô sáddà tun ta duwa barangé. Purisu masig pád malánnád tô duwa barangé. ");
INSERT INTO bgs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na, tô igkita si Simon Pedro na tuu dakál tô inaggut dan, iglingkóód sikandin tun ta saruwan i Jesus, asta igkagi sikandin, na mà din, “Áglangngagán, padiyù ka kanak, su masalà-salà a.” ");
INSERT INTO bgs_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tô gó tô igkagi din su isalábbuan gó sikandin asta tô mga kadumaan din tingód katô tuu marapung mga sáddà na inaggut dan. ");
INSERT INTO bgs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Isalábbuan pagsik tô mga kadumaan din tun ta duma barangé na si Santiago asta si Juan na duwa gabatà i Sebedeo. Igkagi si Jesus ki Simon, na mà din, “Yaka ágkamáddangan. Tikud áknganni, ánnà dán sáddà tô ággután nu, asal mga manubù tô ággután nu.” ");
INSERT INTO bgs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tô igpaligad dan tô mga barangé dan, igtananan dan tô langun, asta igtákkás dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Róggun na igukit si Jesus tun ta sábbad lunsud, isumaran din tô manubù na ipánnù tô lawa din ka téték. Tô igkita sikandin ki Jesus, igpadani sikandin asta iglangkáb. Igpédu-édu sikandin, na mà din, “Áglangngagán, atin ka kakalyag nu, isóddóran ku na makólì ka kani bógók ku.” ");
INSERT INTO bgs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Igdappánnan i Jesus sikandin ka bállad, asta igkagi si Jesus, na mà din, “Malyagga. Kólian kad.” Tigkô dád inólian sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Maggát igsapad si Jesus kandin na dì mému ulitan din tô agad sadan manubui. Igkagi si Jesus, na mà din, “Sadun ka tun ta pangulu ka templo, asta pakita nu yan lawa nu. Bággé nu tô manuk na góbbón tun ta saruwan ka Manama, su tô gó tô igsugù i Moises ébô makasóddór tô langun manubù na inólian kad.” ");
INSERT INTO bgs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Agad tô gó tô igsugù din, asal tuu pô gó italap tô bantug i Jesus. Purisu tuu pa marapung tô mga manubù na ilimud ébô maminág katô ágtinuruán din, asta ébô kólian tô mga bógók dan. ");
INSERT INTO bgs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Asal si Jesus igsadun tun ta disyerto ébô dumasal. ");
INSERT INTO bgs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na, sábbad álló, róggun igtinurù si Jesus, duwán mga Pariseo asta mga taratinurù ka sugù na igunsad madani tun kandin. Igtikud dan tun ta marapung mga lunsud tun ta probinsya ka Galilea asta Judea, asta duwán igtikud tun ta lunsud ka Jerusalem. Duwán katulusan i Jesus tikud tun ta Áglangngagán ébô makólì sikandin katô mga ágkabógókan. ");
INSERT INTO bgs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ándà kadugé, igdunggù tô mga manubù na igié ka kadumaan dan na dì ágriyu é lawa. Kakalyag dan na mapid dan sikandin tun dalám katô balé ébô padággaán tun ta saruwan i Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Asal su marapung tô mga manubù na ilimud, ándà gó gukitan dan na pasadun tun dalám. Purisu igpénék dan tun ta pattad atáp katô balé, asta igbóbbówan dan tô atáp. Igtuntun dan tô dì ágriyu é lawa apil tô ágdággaan din tun ta saruwan i Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tô igkita si Jesus katô kasarig dan kandin, igkagi sikandin, na mà din, “Rarak, igpasinsiyaan dán tô mga salà nu.” ");
INSERT INTO bgs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Asal duwán mga Pariseo asta mga taratinurù ka sugù na igpanámdám, “Ánnà nángngà tô igkagi kani manubù ni. Igpagunawa sikandin katô Manama, su Manama dád tô makapasinsiya ka mga salà.” ");
INSERT INTO bgs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Asal isóddóran i Jesus tô panámdám dan, asta igkagi sikandin, na mà din, “Yakó ágpanámdám iring kanan. ");
INSERT INTO bgs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Atin ka matággas tô pagtuman ka kagi tun ta manubù, na, ‘Igpasinsiyaan dán tô mga salà nu,’ matággas pagsik tô pagtuman ka kagi, na, ‘Tindág ka asta panó ka.’ ");
INSERT INTO bgs_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na, sakán tô Igpamanubù, asta pakitanán kud ákniyu na makémuwa makapasinsiya katô masalà-salà mga manubù nit banuwa.” Purisu igkagi si Jesus tun ta manubù na dì ágriyu é lawa, na mà din, “Tindág ka. Pid nu yan ágdággaan nu, asta ulì kad.” ");
INSERT INTO bgs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na, róggun igsállág tô langun manubù katô manubù na dì ágriyu é lawa, tigkô dád igtindág sikandin, igpid din tô ágdággaan din, asta igulì sikandin na ágdurung katô Manama. ");
INSERT INTO bgs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Isalábbuan gó tô langun manubù, asta igdurung dan tô Manama. Tuu dan isalábbuan, asta igpatóngkóé sikandan, na mà dan, “Makasalábbù tô igkita ta ni álló ni.” ");
INSERT INTO bgs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Na, tô igpanó si Jesus, igkita din tô sábbad taralimud ka buwis na ágngadanan ki Levi na igunsad tun ta opisina din. Igkagi si Jesus tun kandin, na mà din, “Tákkás ka kanak.” ");
INSERT INTO bgs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Purisu igtindág si Levi, igtananan din tô langun, asta igtákkás ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na, igimu si Levi ka dakál kalimudan tun ta balé din para ki Jesus. Marapung tô mga taralimud ka buwis asta tô duma mga manubù na igkan duma kandan. ");
INSERT INTO bgs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Duwán mga Pariseo asta taratinurù ka sugù na igóróm-óróm katô mga disipulu i Jesus, asta iginsà, na mà dan, “Manan ka igkan kó duma katô mga taralimud ka buwis asta duma mga manubù na masalà-salà?” ");
INSERT INTO bgs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Igtaba si Jesus, na mà din, “Tô manubù na ándà bógók, dì sikandin kailangan bawian ka doktor. Asal tô manubù na ágkabógókan, tô dád gó tô kailangan bawian ka doktor. ");
INSERT INTO bgs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Igsadunna dini ánnà ébô pamasakán ku tô mga manubù na ágbánnal katô mga sugù ka Manama, asal pamasakán ku tô mga masalà-salà ébô rumákkád dan.” ");
INSERT INTO bgs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na, igkagi tô mga manubù ki Jesus, na mà dan, “Marag ágpuwasa asta ágdasal tô mga disipulu i Juan asta tô mga disipulu katô Pariseo. Manan ka marag ágkan asta ginám tô áknikó mga disipulu?” ");
INSERT INTO bgs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Igtaba si Jesus, na mà din, “Atin ka duwán kalimudan ka kasal, tô mga kadumaan katô mama na ágkasalán, dì dan ágkaranu róggun ka dutun pa tô mama na ágkasalán. ");
INSERT INTO bgs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Asal duwán álló na dumunggù na kangén tikud tun kandan tô mama na ágkasalán, asta tô gó é álló ka muwasa dan.” ");
INSERT INTO bgs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Igulit si Jesus kani panunggiringan, na mà din, “Ándà missé ka mantu óggét ébô tapóngán tun ta tapé umpak, su atin ka tô gó é lumun, kadattan tô mantu óggét, asta dì magunawa tô bónnóng katô umpak na tapóngan din. ");
INSERT INTO bgs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Atin ka dalámmán tô bino na mantu igimu tun ta ágtaguanan na igimu tikud tun ta kindal ka kambing, dì mému dalámman tô tapé dán iglanit. Su atin ka tô gó é lumun, máttu tô ágtaguanan, kólaan tô bino, asta kadattan tô ágtaguanan. ");
INSERT INTO bgs_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kailangan dalámmán tô bino na mantu igimu tun ta ágtaguanan na mantu iglanit.” ");
INSERT INTO bgs_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Igulit i Jesus tô sábbad panunggiringan, na mà din, “Atin ka inayadan ka manubù tô tapé bino, dì sikandin ágkadigárran katô mantu bino, su tuu pa madigár para kandin tô tapé.” ");
INSERT INTO bgs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na, duwán sábbad álló ka kapaginawa ka mga Judio, igukit si Jesus asta tô mga disipulu din tun ta ligad ka kinamát na igparámmasan ka trigo. Igbagtì katô mga disipulu din tô mga kanguy ka trigo, igkusu dan, asta igkan dan. ");
INSERT INTO bgs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Asal duwán mga Pariseo na igkagi ki Jesus, na mà dan, “Manan ka áglumun yu tô dì mému lumun dalám katô álló ka kapaginawa?” ");
INSERT INTO bgs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Igtaba si Jesus, na mà din, “Ilingawan yu basì ka ándin tô igsulat tun ta kagi ka Manama tingód katô iglumu i David sayyan. Igballus sikandin asta tô mga kadumaan din. ");
INSERT INTO bgs_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Igahu si David tun ta balé ka Manama, igkangé asta igkan din tô pan na igbággé tun ta Manama. Duwán pagsik pan na igbággé din tun ta mga kadumaan din. Agad tô dád mga pangulu ka templo tô mému kuman katô pan, asal ándà ikasalà si David.” ");
INSERT INTO bgs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Igkagi si Jesus, na mà din, “Sakán na Igpamanubù tô mému kumagi ka ándin tô nángngà lumun ka mga manubù dalám ka álló ka kapaginawa.” ");
INSERT INTO bgs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na, duwán ássa álló ka kapaginawa na igsadun si Jesus tun ta simbaan ka Judio asta igtinurù. Duwán sábbad manubù dutun na igkángkáng é bállad dadan ta kawanan. ");
INSERT INTO bgs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Duwán mga taratinurù ka sugù asta mga Pariseo dutun na ágpamasak ka dimanda dan tingód ki Jesus. Purisu marag dan igsállág ka dumappán si Jesus katô mga ágkabógókan ébô kólian dalám katô álló ka kapaginawa. ");
INSERT INTO bgs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Asal isóddóran i Jesus ka ándin tô ágpanámdámmán dan, asta igkagi sikandin tun ta manubù na igkángkáng é bállad, na mà din, “Tindág ka dini madani kanak.” Na, igsadun tô manubù tun ki Jesus, asta igtindág madani tun kandin. ");
INSERT INTO bgs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Igkagi si Jesus tun ta mga taratinurù ka sugù asta mga Pariseo, na mà din, “Duwán insà ku ákniyu. Tingód ka mga sugù ka Manama, ándin tô mému lumun ta dalám ka álló ka kapaginawa? Lumun ta tô madigár, ó lumun ta tô madat? Tabangan ta tô manubù, ó matayan ta tô manubù?” ");
INSERT INTO bgs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na, igsállág i Jesus tô langun manubù, asta igkagi sikandin tun ta manubù na igkángkáng é bállad, na mà din, “Káttáng nu yan bállad nu.” Igkáttáng din tô bállad din, asta inólian. ");
INSERT INTO bgs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Asal tuu isókó tô mga Pariseo asta tô mga taratinurù ka sugù. Purisu igpatóngkóé dan ka ándin tô lumun dan ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na, tô timpo tô, igtikáddág si Jesus tun ta pabungan ébô dumasal, asta igdasal sikandin dutun igladé ka dukilám. ");
INSERT INTO bgs_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tô sállám dán, iglimud din tô langun disipulu din, asta igsalin din tô sapulù duwa (12) na ágngadanan din na mga apostoles. ");
INSERT INTO bgs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ni gó tô mga ngadan dan. Si Simon na ágngadanan i Jesus ki Pedro, tô kataladi i Simon na si Andres, si Santiago, si Juan, si Felipe, si Bartolome, ");
INSERT INTO bgs_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, si Santiago na batà i Alfeo, si Simon na igatu katô gobyerno ka Roma dángngan, ");
INSERT INTO bgs_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas na batà katô sangé i Santiago, asta tô sangé din si Judas Iscariote na igpammát ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na, igtupang si Jesus asta tô mga apostoles, asta igsódô dan tun ta kapattadan. Duwán marapung mga disipulu din, asta marapung tô mga manubù na tikud tun ta langun lunsud na sakup ka probinsya ka Judea, asta tikud tun ta lunsud ka Jerusalem, asta tikud tun ta lunsud ka Tiro asta Sidon na madani tun ta dagat. Ilimud tô langun ébô maminág katô ágtinuruán i Jesus, asta ébô kólian tô mga bógók dan. ");
INSERT INTO bgs_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Igsadun tun kandin tô mga manubù na igahuwan ka madat mga espiritu, asta igpaluwà din tô madat mga espiritu tikud tun kandan. ");
INSERT INTO bgs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Igággár-ággár tô langun manubù na makawid ki Jesus, su duwán katulusan din na makólì kandan langun. ");
INSERT INTO bgs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na, igsállág si Jesus tun ta mga disipulu din, asta igkagi sikandin, na mà din, “Kadayawan kó na mga ágkayù-ayuan, su mangulu tô Manama ákniyu. ");
INSERT INTO bgs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Kadayawan kó na mga ágpamballusán áknganni, su imássugán kó. “Kadayawan kó na mga ágsággó áknganni, su ngumisi kó. ");
INSERT INTO bgs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Kadayawan kó ka ágkasókówan kó, asta ágpéwaán kó, asta ágbuyas-buyasán kó, asta girrayatan kó katô duma mga manubù tingód katô kapasakup yu kanak na Igpamanubù! ");
INSERT INTO bgs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kailangan tuu kó kadayawan tô álló tô, su dakál tô pulusán na matanggap yu tun ta langit. Sampát yu na igirrayatan pagsik katô mga kamónaan dan tô mga propeta ka Manama sayyan. ");
INSERT INTO bgs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Asal makédu-édu kó na mga ágkaduwánnan, su itanggap yud tô ákniyu dayó. ");
INSERT INTO bgs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Makédu-édu kó na ibássug áknganni, su dumunggù tô álló na ballusán kó. “Makédu-édu kó na ágngisi áknganni, su dumunggù tô álló na rumanu asta sumággó kó. ");
INSERT INTO bgs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Makédu-édu kó na ágdurungán katô langun manubù, su tô kandan mga kamónaan igdurung pagsik katô mga mà kagi propeta sayyan.” ");
INSERT INTO bgs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Asal ni gó tô kagin ku ákniyu na ágpaminág kanak. Ginawayi yu tô mga usig yu, asta lumuwi yu ka madigár tô mga manubù na ágkaringasa ákniyu. ");
INSERT INTO bgs_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pamuyù yu tô kédu ka Manama para katô mga manubù na ágtulád ákniyu. Dasali yu tô manubù na girrayat ákniyu. ");
INSERT INTO bgs_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Atin ka sampalán kó tun ta pusángngi yu, pasampal yu pagsik tô ágbaluy. Atin ka duwán ágkangé ka kamisita yu, bággé yu pagsik tô umpak yu kandin. ");
INSERT INTO bgs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bággéyi yu tô mamuyù. Atin duwán ágkangé katô mga kaduwánnan yu, yakó yu ágkangayi. ");
INSERT INTO bgs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Agad ándin tô kakalyag yu na lumun katô duma mga manubù ákniyu, tô gó é kailangan lumun yu tun ta duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Atin ka ginawaan yu dád tô mga manubù na ágginawa ákniyu, dì kó madurung, su agad tô mga masalà-salà ágginawa katô mga masalà-salà na ágginawa kandan. ");
INSERT INTO bgs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Atin ka lumuwan yu dád ka madigár tô mga manubù na áglumu ka madigár tun ákniyu, dì kó madurung, su tô gó tô áglumun katô mga masalà-salà. ");
INSERT INTO bgs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Atin ka pabállássán yu dád tô mga makabullas, dì kó madurung, su agad tô mga masalà-salà ágpabállás tun ta mga masalà-salà na makabullas. ");
INSERT INTO bgs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Asal ginawayi yu tô mga usig yu, asta lumu yu tô madigár tun kandan. Pabállás kó asta yakó gangat na bullasan, su dakál tô pulusán na matanggap yu, asta makéring kó katô Manama na Tuu Mallayat, su madigár tô áglumun din agad tun ta mga manubù na madat asta dì ágpasalamat. ");
INSERT INTO bgs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Purisu kailangan médu-édu kó iring katô Ámmà yu na Manama na médu-édu.” ");
INSERT INTO bgs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yakó ágruud katô mga unawa yu na manubù, asta dì kó ruudan ka Manama. Yakó ágkagi na supakan tô mga unawa yu, asta dì kó supakan ka Manama. Pasinsiyayi yu tô mga ikasalà ákniyu, asta pasinsiyaan kó ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bággé kó, asta bággayan kó ka Manama. Tuu dakál tô bággén din ákniyu, su dasákkán, ipánnuán, asta palimpópón ébô tuu dakál tô matanggap yu. Bággayan kó ka Manama na magunawa ka kabággé yu tun ta mga unawa yu.” ");
INSERT INTO bgs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na, igulit pagsik si Jesus kani panunggiringan, na mà din, “Dì mému ka magak tô bólóg katô ássa bólóg, su madabù tô duwa dan tun ta madalám bóbbó. ");
INSERT INTO bgs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ándà estudyante na mallayat pa katô kandin taratinurù. Asal atin ka madigár tô késtudyo din, makéring tô estudyante katô kandin taratinurù. ");
INSERT INTO bgs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Sékót yu ágkitanán tô pássák tun ta mata ka kataladi yu asal ándà yu kasóddóri na duwán pássák na iring na batang tun ta ákniyu mata. ");
INSERT INTO bgs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Atin ka dì yu kitanán tô pássák na iring na batang tun ta ákniyu mata, dì kó makatabang mangé katô pássák tun ta mata katô kataladi yu. Kéman yu ka ándà salà yu. Kangé yu pa tô pássák na iring na batang tikud tun ta ákniyu mata ébô matayyó dán tô kasállág yu na mangé katô pássák tun ta mata katô kataladi yu.” ");
INSERT INTO bgs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Tô áglumun ka mga manubù iring na buuy ka kayu. Tô madigár kayu dì ágbuuy ka madat. Tô madat kayu dì ágbuuy ka madigár. ");
INSERT INTO bgs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Atin ka ágkitanán tô buuy ka kayu, kasóddóran ka ándin kayuwi. Ándà buuy ka igera na uduán tikud tun ta sigbát na mayyà. Ándà pagsik buuy ka paras na uduán tikud tun ta sigbát na talayid. ");
INSERT INTO bgs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iring kanan tô manubù. Atin ka madigár tô tun dalám ka manubù, madigár tô áglumun din. Atin ka madat tô tun dalám ka manubù, madat tô áglumun din. Atin ka ágkagi tô manubù, ágpasóddórán din tô dalám katô pusung din.” ");
INSERT INTO bgs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Atin ka dì kó ágbánnal katô sugù ku ákniyu, dì mému ka kumagi kó na sakán tô Áglangngagán yu. ");
INSERT INTO bgs_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ulitán ku ákniyu tô tingód katô manubù na ágpadani kanak na ágpaminág asta ágtuman kani mga ágkagin ku. ");
INSERT INTO bgs_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iring sikandin katô manubù na igimu ka balé. Igkali sikandin tun ta madalám, asta igpatindág din tô balé tun ta batu. Tô igbahà tô wayig, idungguan tô balé din. Asal ándà kakálláng tô balé, su tuu masarig tô pónsadanan. ");
INSERT INTO bgs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Asal tô manubù na ágpaminág kani mga ágkagin ku asal dì ágtuman, iring sikandin katô manubù na igimu ka balé din tun ta bówwó ka tanà na ándà masarig pónsadanan. Tô igbahà tô wayig, tigkô ibantang tô balé, asta idattan langun.” ");
INSERT INTO bgs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na, pángnga igtinurù si Jesus kani langun tun ta ilimud mga manubù, igsadun sikandin tun ta lunsud ka Capernaum. ");
INSERT INTO bgs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Duwán sábbad kapitan ka mga sundalo ka gobyerno ka Roma, asta duwán sábbad állang din na ágginawaan din na ibógókan asta masig dán maté. ");
INSERT INTO bgs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tô igdinág tô kapitan tingód ki Jesus, igpasadun din tô mga ágtugállán ka Judio tun ki Jesus ébô pédu-édu kandin na madun tun ta balé din asta dappánnan tô állang din ébô kólian. ");
INSERT INTO bgs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tô igdunggù dan tun ki Jesus, igpédu-édu dan kandin, na mà dan, “Atin mému, tabangi nu tô kapitan, su madigár sikandin manubù, ");
INSERT INTO bgs_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","su dakál tô ginawa din áknita na mga Judio, asta sikandin tô igpému katô simbaan dé.” ");
INSERT INTO bgs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Purisu igtákkás si Jesus kandan. Tô masig dan dán dumunggù tun ta balé katô kapitan, duwán mga rarak katô kapitan na igpasadun din tun ki Jesus. Igulit dan ni mga igkagi katô kapitan, na mà dan, “Áglangngagán, pabayà kad kanak. Diya pahu áknikó tun ta balé ku, su tuu mabbabà tô kamanubuan ku ka tandingán áknikó. ");
INSERT INTO bgs_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ándà kaganiyan ku. Purisu ándà a sadun tun áknikó. Mému ka kumagi ka dád na kólian tô állang ku, asta kólian sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sakuppa katô mga manubù na ágsugù kanak, asta duwán mga sundalo na ágsuguán ku. Atin ka duwán sundalo na suguán ku, numunug sikandin kanak. Atin ka duwán sundalo na pakangén ku, numunug sikandin kanak. Atin ka duwán palumun ku katô állang ku, lumumu sikandin.” ");
INSERT INTO bgs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tô igdinág si Jesus katô igkagi ka kapitan na igulit dan, isalábbuan sikandin. Igbariring si Jesus tun ta mga manubù na igtákkás kandin, asta igkagi sikandin, na mà din, “Kagin ku ákniyu, agad tun ta mga rubbad i Israel, ándà palang manubù na ikitaan ku na igsarig kanak iring katô kasarig kani ánnà Judio.” ");
INSERT INTO bgs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tô igulì tô mga manubù tun ta balé katô kapitan, igkita dan tô állang na inólian dán. ");
INSERT INTO bgs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na, ándà kadugé, igsadun si Jesus tun ta lunsud ka Nain. Igtákkás pagsik tô mga disipulu din asta tô marapung manubù. ");
INSERT INTO bgs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tô madani dan dán tun ta lunsud, igkita dan tô mga manubù na gié ka inaté ébô lábbángngán dan. Bugtung batà mama tô inaté, asta ándà dán ámmà din. Marapung tô mga manubù na igtákkás tun ta lábbángngan katô batà. ");
INSERT INTO bgs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tô igkita tô Áglangngagán katô innà katô inaté, inéduwan sikandin, asta igkagi, na mà din, “Yaka ágsággó.” ");
INSERT INTO bgs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Igpadani si Jesus, igawidan din tô igpadággaan katô inaté, asta igsódô tô mga manubù na igié. Igkagi si Jesus tun ta manubù na inaté, na mà din, “Ánnó ka.” ");
INSERT INTO bgs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Igánnó tô batà, asta ikakagi dán sikandin. Igbággé i Jesus tô batà tun ta innà din. ");
INSERT INTO bgs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Imáddangan asta isalábbuan tô langun dan, asta igdurung dan tô Manama, na mà dan, “Duwán matulus propeta ka Manama na igdunggù áknita! Igpakita dán tô Manama áknita na mga sakup din!” ");
INSERT INTO bgs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Italap tô bantug i Jesus tun ta kaluwagan ka probinsya ka Judea asta tun ta kaligadan. ");
INSERT INTO bgs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na, tô mga disipulu i Juan na Tarabunyag igulit kandin tingód katô iglumu i Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Purisu igtawar i Juan tô duwa disipulu din, asta igpasadun din sikandan tun ta Áglangngagán ébô minsà dan, na, “Sikuna tô bánnal igpapid ka Manama, ó duwán pa ássa na gangatan dé?” ");
INSERT INTO bgs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tô igdunggù tô mga manubù na igpasadun i Juan tun ki Jesus, igkagi sikandan, na mà dan, “Igpasadun ké i Juan dini áknikó ébô minsà ké ka sikuna tô bánnal igpapid ka Manama, ó duwán pa ássa na gangatan dé.” ");
INSERT INTO bgs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dalám katô álló tô, igdappánnan i Jesus tô marapung mga ágkabógókan ébô kólian, asta igpaluwà din tô madat mga espiritu tikud tun ta mga manubù na igahuwan. Igdappánnan din tô mga bólóg, asta ikakita dan. ");
INSERT INTO bgs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Igtaba si Jesus tun ta mga igpapid i Juan, na mà din, “Ulì kód, asta uliti yu si Juan tingód katô langun na igkita yu asta igdinág yu kanak. Duwán mga bólóg na ikakita dán. Duwán mga kapig na ikapanó dán. Duwán mga tétékán na inólian dán. Duwán mga bingál na ikadinág dán. Duwán mga inaté manubù na inanté dán. Duwán mga ágkayu-ayuan na igulit-ulitan dán katô Madigár Gulitán. ");
INSERT INTO bgs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Uliti yu sikandin na kadayawan tô mga manubù na dì ágduwa-duwa tingód kanak.” ");
INSERT INTO bgs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tô igpanó tô mga manubù na igpapid i Juan, igkagi si Jesus tun ta ilimud mga manubù tingód ki Juan, na mà din, “Na, tô igsadun kó tun ta disyerto, ándà yu pamasaki tô manubù na iring ka banban na ágkálláng-kállángngán ka karamag. ");
INSERT INTO bgs_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ándà yu pamasaki tô manubù na gumpak ka dakál é lagà, su tô mga gumpak ka madigár asta madigár é kóddô, tô gó tô góddô tun ta palasyo ka harì. ");
INSERT INTO bgs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Asal ni gó tô ágpamasakán yu. Igsadun kó tun ta disyerto ébô kitanán yu tô propeta ka Manama. Paminág yu ni kagin ku ákniyu. Tuu pa mallayat tô kamanubuan i Juan ka tandingán katô langun propeta ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Igtuman din ni tandô na igsulat tun ta kagi ka Manama, “‘Na, duwán manubù na papiddán ku muna áknikó ébô pataganaán tô langun manubù katô kadunggù nu.’” ");
INSERT INTO bgs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Paminág yu ni kagin ku ákniyu. Tô kamanubuan i Juan tuu pa mallayat ka tandingán katô langun manubù. Asal tô manubù na tuu mabbabà tun ta pagpangulu ka Manama, tô gó é tuu pa mallayat ka tandingán ki Juan.” ");
INSERT INTO bgs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tô igdinág dan katô igkagi din, tô langun manubù asta tô mga taralimud ka buwis igkagi na nángngà tô iglumu katô Manama, su taganà igpabunyag dan ki Juan. ");
INSERT INTO bgs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Asal tô mga Pariseo asta tô mga taratinurù ka sugù, igéllé dan katô kakalyag ka Manama, su ándà dan pabunyag ki Juan. ");
INSERT INTO bgs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Igkagi si Jesus, na mà din, “Na, ulitán ku ákniyu tô tingód ka mga manubù áknganni. Ni gó tô ágkéringan dan. ");
INSERT INTO bgs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iring sikandan na mga gabatà na gunsad tun ta plasa na ágkalingánnan asta ágpatawaré dan, na mà dan, ‘Igidup ké ka lantuy ébô sumayó kó, asal ándà kó sayó. Igkanta ké tingód katô kamatayan, asal ándà kó sággó.’ ");
INSERT INTO bgs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iring kandan tô mga manubù áknganni, su si Juan na Tarabunyag inalayun ágpuwasa, asta dì gó ginám ka bino. Purisu ágkagi kó na igahuwan sikandin ka madat espiritu. ");
INSERT INTO bgs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Asal sakán na Igpamanubù, ágkanna asta ginámma. Purisu ágkagi kó na áglólóbanna, sunnudda ginám, asta ágrarakán ku tô mga taralimud ka buwis asta tô duma mga manubù na masalà-salà! ");
INSERT INTO bgs_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Asal ukit katô langun na áglumun ka Manama, ágkasóddóran na nángngà tô kapandayan din.” ");
INSERT INTO bgs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Duwán sábbad Pariseo na igpakan ki Jesus. Purisu igsadun si Jesus tun ta balé din, asta igkan sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, duwán sábbad bayi na góddô tun ta lunsud, asta ibantug sikandin na masalà-salà. Tô igdinág sikandin na igkan si Jesus tun ta balé katô Pariseo, igpid din tô pamammut na igdalám tun ta katiyà ka alabastro. ");
INSERT INTO bgs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Igtindág sikandin tun ta táppad katô paa i Jesus. Igsággó sikandin, igpatallù din tô luhà din tun ta paa i Jesus, asta igpunasan din tô paa i Jesus katô ulu din. Marag din gadákkan tô paa i Jesus, asta igbusbusan din katô pamammut. ");
INSERT INTO bgs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na, tô Pariseo na igpakan ki Jesus, tô igkita sikandin katô iglumu katô bayi, igpanámdám sikandin, na, “Atin ka bánnal propeta ni manubù ni, kasóddóran din gó na masalà-salà ni bayi na igawid kandin.” ");
INSERT INTO bgs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Igkagi si Jesus tun ta Pariseo, na mà din, “Simon, duwán kagin ku áknikó.” Igtaba si Simon, na mà din, “Sir, ándin é kagin nu kanak?” ");
INSERT INTO bgs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Igkagi si Jesus, na mà din, “Duwán duwa manubù na igbállás ka salapì tun ta tarapabállás. Tô sábbad igbállás ka lima gatus (500) abuk ka salapì. Tô ássa manubù igbállás ka kaliman (50) abuk ka salapì. ");
INSERT INTO bgs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Su ándà ikabullas tô duwa dan katô salapì na igbállássan dan, igpandà katô tarapabállás tô utang katô duwa dan. Na, tun ta duwa dan, sadan tô duwán tuu dakál ginawa tun ta tarapabállás?” ");
INSERT INTO bgs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Igtaba si Simon, na mà din, “Sikandin basì na tuu dakál tô utang na igpandà.” Igkagi si Jesus, na mà din, “Nángngà tô taba nu.” ");
INSERT INTO bgs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na, igsérê si Jesus tun ta bayi, asta igkagi sikandin ki Simon, na mà din, “Sállág nu ni bayi ni. Tô igdunggù a kannun ta balé nu, ándà wayig na igpid nu ébô urasán kani paa ku. Asal ni bayi ni, iglámmás din tô paa ku ka luhà din, asta igpunasan din katô ulu din. ");
INSERT INTO bgs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ándà ka adák kanak. Asal ni bayi ni, ándà sikandin sódô na gadák ka paa ku tikud tun ta igahuwa kani balé nu. ");
INSERT INTO bgs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ándà ka tagù ka langis ka olibo nit ulu ku. Asal ni bayi ni, igbusbus din nit paa ku tô pamammut na dakál é lagà. ");
INSERT INTO bgs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Purisu kagiyan ku sikuna, igpasinsiyaan dán ka Manama tô salà din agad marapung, su dakál tô ginawa kani bayi. Asal tô manubù na délák tô salà din na igpasinsiyaan ka Manama, délák tô ginawa din tun ta Manama.” ");
INSERT INTO bgs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Igkagi si Jesus tun ta bayi, na mà din, “Igpasinsiyaan dán tô mga salà nu.” ");
INSERT INTO bgs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Purisu igpatóngkóé tô mga manubù na igkan duma ki Jesus, na mà dan, “Ánnà nángngà tô igkagi kani manubù ni, su Manama dád tô makapasinsiya ka mga salà.” ");
INSERT INTO bgs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na, igkagi si Jesus tun ta bayi, na mà din, “Igtábbus kad ukit katô kasarig nu. Ulì kad na duwán kasunayan.” ");
INSERT INTO bgs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na, ándà kadugé, igpanayun si Jesus, asta igsadunan din tô ássa mga lunsud asta mga banuwa. Igulit-ulit din tô Madigár Gulitán tingód ka pagpangulu ka Manama. Igtákkás tô sapulù duwa (12) disipulu din. ");
INSERT INTO bgs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Igtákkás pagsik tô mga gabayi na inólian asta igpaluwaan din ka madat espiritu. Sikandan si Maria na ágngadanan na taga Magdala na igpaluwaan ka pittu madat espiritu, ");
INSERT INTO bgs_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","asta si Juana na sawa i Cusa na sábbad opisyales i Herodes, asta si Susana, asta marapung tô ássa mga gabayi. Ni mga gabayi igbággé ka salapì tun ki Jesus asta mga disipulu din ébô duwán magasto dan. ");
INSERT INTO bgs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tô ilimud tô marapung manubù tikud tun ta langun lunsud, igulit si Jesus kani panunggiringan, na mà din, ");
INSERT INTO bgs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Duwán sábbad manubù na igsadun tun ta kinamát ébô sumabud ka bánnì. Tô igsabud sikandin, duwán isabud tun ta dalan, asal igittan ka mga manubù, asta igtuktuk katô mga manuk ta kayun. ");
INSERT INTO bgs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Duwán ássa bánnì na isabud tun ta batun tanà. Tô igtubù, ándà kadugé ilanás asta inaté, su ándà man wayig katô tanà. ");
INSERT INTO bgs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Duwán ássa bánnì na isabud tun ta tángngaan katô dugin sigbát. Igtubù tô bánnì, asal itambunan katô dugin sigbát tô pamula. ");
INSERT INTO bgs_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Asal duwán bánnì na isabud tun ta malambù tanà. Tô gó tô madigár é tubù na igbuuy ka ginatus-gatus.” Na, igkagi si Jesus ka mabákkár, na mà din, “Purisu kailangan maminág kó kanak ébô makagpát kó.” ");
INSERT INTO bgs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na, iginsà tô mga disipulu i Jesus ka ándin tô kóbadan kani panunggiringan. ");
INSERT INTO bgs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Igtaba si Jesus, na mà din, “Sikiyu tô igpakitaan ka Manama katô kabánnalan na ándà din pasóddóri dángngan tingód katô pagpangulu din. Asal ukit dád tun ta mga panunggiringan tô katinurù ku katô duma mga manubù ébô agad sumállág dan, dì dan makakita katô kóbadan. Agad maminág dan, dì dan makagpát katô kabánnalan.” ");
INSERT INTO bgs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ni gó tô kóbadan katô panunggiringan na igulit ku ákniyu. Tô bánnì na igsabud, tô gó é kagi ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tô bánnì na isabud tun ta dalan, iring katô mga manubù na ágpaminág ka kagi ka Manama. Na, ágsadunan i Maibuyan ébô agón din tô kagi ka Manama na igdinág dan ébô dì dan mánnal, asta dì dan matábbus. ");
INSERT INTO bgs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na, tô bánnì na isabud tun ta batun, iring katô mga manubù na ágpaminág ka kagi ka Manama, asta ágtanggap dan na duwán dayó dan. Asal dì ágkadugé tô kabánnal dan. Atin ka tintalán dan, ágkandà dán tô kabánnal dan, su iring dan katô pamulanán na ándà tuu ramut. ");
INSERT INTO bgs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na, tô bánnì na isabud tun ta tángngaan ka dugin sigbát, iring katô mga manubù na ágpaminág katô kagi ka Manama na igtinurù. Asal dì dan makapanayun su talun dan katô sasó dan, kakalyag dan tô kaduwánnan, asta kadayawan kani banuwa. Purisu ándà ágpulusán dan katô kagi ka Manama na igdinág dan. ");
INSERT INTO bgs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na, tô bánnì na isabud tun ta malambù tanà, iring katô mga manubù na ágpaminág katô kagi ka Manama, asta ágtaguán dan tun ta pusung dan, su ágkasarigan asta madigár sikandan. Sikandan tô ágtiis ka kahirapan sippang ka duwán ágpulusán dan.” ");
INSERT INTO bgs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Na, atin ka ágrákkáttan é sulù, dì ágtambunan, asta dì taguán tun ta siráb ka katri. Asal ágsapatán ébô kataddawan tô langun manubù na mahu tun ta balé. ");
INSERT INTO bgs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ándà palang gállássán áknganni na dì pakitanán tun ta tapuri álló. Ándà pagsik ágbulunán áknganni na dì kasóddóran tun ta tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Purisu kailangan bánnalán yu tô igdinág yu, su tô manubù na ágbánnal katô kabánnalan, tô gó é dugangan katô kabánnalan. Asal tô manubù na dì ágbánnal katô kabánnalan, tô gó é kangayan katô kabánnalan na igpanámdám din na duwán tun kandin.” ");
INSERT INTO bgs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na, igdunggù tô innà i Jesus asta tô mga kataladi din, asal ándà dan ikapadani tun kandin su marapung tô mga manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Duwán igkagi ki Jesus, na mà din, “Tun ta luwà tô innà nu asta tô mga kataladi nu. Kakalyag dan kun na kumita áknikó.” ");
INSERT INTO bgs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Asal igkagi si Jesus tun ta mga manubù, na mà din, “Tô mga manubù na ágpaminág asta ágbánnal katô kagi ka Manama, tô gó tô innà ku asta tô mga kataladi ku.” ");
INSERT INTO bgs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na, sábbad álló, igsaké si Jesus asta tô mga disipulu din ka barangé, asta igkagi si Jesus kandan, na mà din, “Tumalipag ki tun dipag ka ranó.” Purisu igtalipag dan. ");
INSERT INTO bgs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Róggun na igtalipag dan, igtudug si Jesus. Ándà kadugé, igdunggù tô mabákkár karamag. Tô barangé idalámman ka wayig, asta masig dán malánnád. ");
INSERT INTO bgs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Igpadani tô mga disipulu ki Jesus, asta igánnó dan sikandin, na mà dan, “Áglangngagán, Áglangngagán, malánnád kid!” Igánnó si Jesus, asta igpasódô din tô karamag asta tô magdakál mga balud. Purisu igsódô asta igtónnók. ");
INSERT INTO bgs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Igkagi si Jesus, na mà din, “Délák tô kasarig yu kanak.” Asal imáddangan dan, isalábbuan dan, asta igpatóngkóé sikandan, na mà dan, “Matulus gó kannê sikandin, su agad tô karamag asta tô mga balud ágbánnal kandin.” ");
INSERT INTO bgs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na, igdunggù dan madani tun ta Gerasa na tun ta dipag katô probinsya ka Galilea. ");
INSERT INTO bgs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tô igpónóg si Jesus, duwán sábbad taga Gerasa na igsumar kandin na igahuwan ka madat espiritu. Idugé sikandin ándà pangómpak, asta dì góddô tun ta balé, asal góddô tun ta mga lábbáng. ");
INSERT INTO bgs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tô igkita sikandin ki Jesus, igullaó sikandin, iglingkóód tun ta saruwan i Jesus, asta igkagi sikandin ka mabákkár, na mà din, “Jesus, Batà ka Manama na Tuu Mallayat, yaka ágsamuk kanak.” ");
INSERT INTO bgs_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tô gó é igkagi katô madat espiritu, su taganà igsugù si Jesus na lumuwà tô madat espiritu tikud tun ta manubù. Marag gahuwan sikandin ka madat espiritu. Ágbagkássán sikandin ka kadina, gikáttan, asta inalayun ágbantéyan. Asal ágbugtusán din tô pagbagkás kandin, asta ágpiddán sikandin katô madat espiritu tun ta disyerto. ");
INSERT INTO bgs_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na, iginsà si Jesus kandin, na mà din, “Sadan é ngadan nu?” Igtaba sikandin, na mà din, “Mga mararan.” Tô gó tô igtaba din su marapung tô madat mga espiritu na igahu kandin. ");
INSERT INTO bgs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ágpédu-édu tô madat mga espiritu ki Jesus na dì dan pád suguán ikandin tun ta siráb ka tanà. ");
INSERT INTO bgs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na, tuu marapung tô mga babuy na ágsukat tun ta karaban ka pabunganán na dì madiyù, asta igpédu-édu tô madat mga espiritu ki Jesus na pahun sikandan tun ta mga babuy. Na, ignunug si Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Purisu igluwà tô madat mga espiritu tikud tun ta manubù, asta igahu dan tun ta mga babuy. Igpalaguy tô langun babuy tun ta karaban, igtuppas dan tun ta ranó, asta ilánnád. ");
INSERT INTO bgs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na, tô igkita tô mga taradóppón katô ilumu, igpalaguy dan, asta igulit dan tun ta lunsud asta tun ta madani mga banuwa. ");
INSERT INTO bgs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Purisu igsadun tô mga manubù ébô kitanán dan tô ilumu. Igsadun dan tun ki Jesus, asta igkita dan tô manubù na igpaluwaan ka madat mga espiritu. Igunsad sikandin madani tun ta paa i Jesus, igumpak dán, asta madigár dán tô panámdám din. Purisu imáddangan dan. ");
INSERT INTO bgs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tô mga manubù na ikakita igulit tingód katô kapaluwà i Jesus ka madat mga espiritu tikud tun ta manubù. ");
INSERT INTO bgs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Purisu igpédu-édu tô langun taga Gerasa na miwà si Jesus tikud tun ta banuwa dan, su tuu dan imáddangan. Purisu igsaké si Jesus tun ta barangé, asta igulì. ");
INSERT INTO bgs_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Asal tô ándà dan pa panó, tô manubù na igluwaan ka mga madat espiritu igpédu-édu na mákkás pád sikandin ki Jesus. Asal ándà nunug si Jesus, su igkagi sikandin, na mà din, ");
INSERT INTO bgs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ulì kad, asta ulit nu tô tingód katô madigár na iglumu ka Manama áknikó.” Purisu igpanó sikandin, asta igulitan din tô langun manubù tun ta lunsud tingód katô madigár na iglumu i Jesus kandin. ");
INSERT INTO bgs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na, tô igdunggù si Jesus tun dipag katô ranó, marapung tô mga manubù na igsumar, su igangat dan kandin. ");
INSERT INTO bgs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na, duwán sábbad pangulu ka simbaan ka Judio na ágngadanan ki Jairo na igpadani tun ki Jesus. Iglingkóód sikandin, asta igpédu-édu na madun si Jesus tun ta balé din, ");
INSERT INTO bgs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","su masig dán maté tô batà din bayi. Tô gó é bugtung batà din na mga sapulù duwa (12) é idad. Tô igtákkás si Jesus kandin, marapung tô mga manubù na igpaliggátté na igarurung kandin. ");
INSERT INTO bgs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na, duwán sábbad bayi na gagasan ka dipanug dalám ka sapulù duwa (12) dán ámmé, asta ándà palang ikólì kandin. ");
INSERT INTO bgs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Igpadani sikandin tun ta bókkóg i Jesus, asta igawidan din dád tô ugpu katô umpak i Jesus. Tigkô dád igsódô tô dipanug din. ");
INSERT INTO bgs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na, iginsà si Jesus, na mà din, “Sadan é igawid kanak?” Igpanguntaman tô langun. Na, igkagi si Pedro, na mà din, “Áglangngagán, tuu marapung tô mga manubù na igpaliggátté asta igarurung áknikó!” ");
INSERT INTO bgs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Asal igkagi si Jesus, na mà din, “Duwán igawid kanak, su igriyuwa na duwán katulusan na igluwà tikud dini kanak.” ");
INSERT INTO bgs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na, tô ikasóddór tô bayi na dì mabulun tô iglumu din, igpadani sikandin tun ki Jesus. Igkárkár sikandin tingód katô máddang din, iglingkóód sikandin tun ta saruwan i Jesus, asta igulit din tô gunayan katô pagawid din kandin. Igdinág tô langun manubù na tigkô dád inólian tô bógók din. ");
INSERT INTO bgs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Igkagi si Jesus katô bayi, na mà din, “Inólian kad ukit ka kasarig nu kanak. Ulì kad na duwán kasunayan.” ");
INSERT INTO bgs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Róggun na igkagi pa si Jesus tun ta bayi, duwán sábbad manubù na igdunggù tikud tun ta balé i Jairo, asta igkagi sikandin ki Jairo, na mà din, “Yakad ágpapanayun katô Taratinurù tun ta balé nu, su inaté dán tô batà nu.” ");
INSERT INTO bgs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Asal tô igdinág si Jesus katô kagi din, igkagi sikandin ki Jairo, na mà din, “Yaka ágkaranu! Bánnal ka dád kanak, asta kólian tô batà nu.” ");
INSERT INTO bgs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tô igdunggù dan tun ta balé i Jairo, ándà duma manubù na igpatákkás i Jesus tun dalám, asal si Pedro dád, si Juan, si Santiago, asta tô ámmà asta tô innà katô batà. ");
INSERT INTO bgs_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ágsággó asta gullaó tô langun manubù, asal igkagi si Jesus, na mà din, “Yakó ágsággó, su ándà kamaté ni batà. Igtudug dád sikandin.” ");
INSERT INTO bgs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na, igngisiyan dan si Jesus, su isóddóran dan na inaté dán tô batà. ");
INSERT INTO bgs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Asal igawidan i Jesus tô bállad katô batà, asta igkagi sikandin, na mà din, “Sumuddù, tindág ka!” ");
INSERT INTO bgs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na, iglónód tô gimukud din, asta igtindág tô batà. Na, igsugù si Jesus na pakannán tô batà. ");
INSERT INTO bgs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Isalábbuan tô ámmà asta tô innà katô batà. Asal maggát igsapad si Jesus kandan na ándà palang manubù na mému ulitan dan tingód katô ilumu. ");
INSERT INTO bgs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na, iglimud i Jesus tô sapulù duwa (12) apostoles, igbággayan din sikandan ka katulusan ébô makapaluwà dan ka mga madat espiritu tikud tun ta manubù, asta ébô makólì dan ka mga ágkabógókan. ");
INSERT INTO bgs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Igpapanó dan ikandin ébô mulit-ulit dan tingód ka pagpangulu ka Manama, asta ébô dappánnan dan tô mga ágkabógókan ébô kólian. ");
INSERT INTO bgs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Igkagi sikandin tun kandan, na mà din, “Yakó ágpid ka kaduwánnan yu, agad tukád, kabir, ágkakan asta salapì. Yakó ágpid ka umpak na gilisan. ");
INSERT INTO bgs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Atin ka ágdunggù kó tun ta balé, óddô kó dutun sippang ka panó kó tun ta ássa lunsud. ");
INSERT INTO bgs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Atin ka dì kó tanggapán katô mga manubù, ka panó kó tikud tun ta lunsud dan, padpad yu tô barukbuk tikud tun ta paa yu ébô kasóddóran dan na duwán sókó ka Manama kandan.” ");
INSERT INTO bgs_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na, igpanó dan asta igsadun dan tun ta mga lunsud. Igulit-ulit dan katô Madigár Gulitán asta igdappánnan dan tô mga ágkabógókan ébô kólian. ");
INSERT INTO bgs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na, si Herodes tô igpangulu tun ta Galilea. Tô igdinág sikandin tingód katô áglumun i Jesus, ágduwa-duwa tô panámdám din, su duwán mga manubù na ágkagi na sikandin si Juan na Tarabunyag na inanté puman. ");
INSERT INTO bgs_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Duwán duma mga manubù na ágkagi na sikandin si Elias na inanté puman, asta duwán duma ágkagi na sikandin tô sábbad propeta sayyan na inanté puman. ");
INSERT INTO bgs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Igkagi si Herodes, na mà din, “Si Juan tô igpatampáddan ku ka alig. Purisu sadan ni manubù ni na igdinág ku?” Na, kakalyag i Herodes na kumita sikandin ki Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na, tô igulì tô mga apostoles tun ki Jesus, igulit dan kandin tingód katô langun iglumu dan. Igpatákkás i Jesus sikandan, igtananan dan tô duma mga manubù, asta igsadun dan tun ta lunsud na ágngadanan Betsaida. ");
INSERT INTO bgs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Asal tô ikasóddór tô langun manubù ka ánda é igsadunan i Jesus, igtalundug dan kandin. Igtanggap si Jesus kandan, asta igulit sikandin kandan tingód katô pagpangulu ka Manama. Igdappánnan din tô langun ágkabógókan, asta inólian dan. ");
INSERT INTO bgs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tô mapun dán, igpadani tô sapulù duwa (12) disipulu tun ki Jesus, asta igkagi sikandan, na mà dan, “Papanó nu tô langun manubù tun ta mga lunsud asta tun ta kaligadan dan ébô duwán kadággaan dan, asta ébô málli dan ka makan, su ándà mga manubù na góddô kannun.” ");
INSERT INTO bgs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Asal igkagi si Jesus, na mà din, “Sikiyu é mággé ka makan dan.” Igkagi sikandan, na mà dan, “Asal lima dád abuk ni pan ta, asta duwa dád abuk ni sáddà ta. Panó ké ébô málli ka pan para katô langun?” ");
INSERT INTO bgs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mga lima mararan (5,000) tô mga gamama na ilimud. Igkagi si Jesus tun ta mga disipulu din, na mà din, “Pónsad yu tô mga manubù na tagkaliman tô sábbad grupo.” ");
INSERT INTO bgs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Igbánnal tô mga disipulu din, asta igpónsad dan tô langun. ");
INSERT INTO bgs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Igkangé i Jesus tô lima abuk pan asta tô duwa abuk sáddà. Iglangngag sikandin tun ta langit, asta igpasalamat tun ta Manama. Igtáppik-táppik din tô pan asta tô sáddà, asta igbággé din tun ta mga disipulu din ébô taladán dan tun ta mga manubù na ilimud. ");
INSERT INTO bgs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ikakan tô langun manubù, asta ibássug dan. Iglimud katô mga disipulu din tô pan asta sáddà na isamà, asta duwán sapulù duwa (12) magdakál baskit na ipánnù. ");
INSERT INTO bgs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na, sábbad álló, igdasal si Jesus na sábbad din dád, asta madani tun kandin tô mga disipulu din. Iginsà si Jesus kandan, na mà din, “Ándin tô ágkagin ka mga manubù tingód kanak? Sadanna kun?” ");
INSERT INTO bgs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Igtaba sikandan, na mà dan, “Duwán mga manubù na ágkagi na sikuna si Juan na Tarabunyag. Duwán ássa mga manubù na ágkagi na sikuna si Elias. Duwán ássa na ágkagi na sikuna tô sábbad propeta ka Manama sayyan na inanté puman.” ");
INSERT INTO bgs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iginsà si Jesus, na mà din, “Asal ándin é ákniyu panámdám tingód kanak? Sadanna?” Igtaba si Pedro, na mà din, “Sikuna tô Mesiyas na igpapid ka Manama dini áknami.” ");
INSERT INTO bgs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Asal maggát igsapad si Jesus na kailangan dì dan mulit kani tun ta duma mga manubù. ");
INSERT INTO bgs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Igkagi si Jesus, na mà din, “Pahirapanna na Igpamanubù, asta élléyanna katô mga ágtugállán ka Judio, mallayat ka mga pangulu ka templo, asta mga taratinurù ka sugù. Matayanna, asta mantéya puman tun ta ikatállu álló.” ");
INSERT INTO bgs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na, igkagi si Jesus tun ta langun na igpaminág kandin, na mà din, “Tô manubù na mákkás kanak, kailangan dian din tô kakalyag ka pusung din, tumiis sikandin ka kahirapan tukid ka álló agad matayan sikandin, na mákkás kanak. ");
INSERT INTO bgs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tô manubù na áglággád katô kantayan din, kandaan sikandin katô kantayan na ándà ágtamanán. Asal ka mému ka matayan tô manubù tingód katô katákkás din kanak, matanggap din tô kantayan na ándà ágtamanán. ");
INSERT INTO bgs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Atin ka makatigatun tô manubù kani tibuk banuwa, asal kandaan sikandin katô kantayan, ándà palang pulusán din. ");
INSERT INTO bgs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Atin ka ágkayyaan tô manubù tingód kanak asta tingód katô igtinurù ku, kayyaanna tingód kandin tun ta álló ka lumónódda na Igpamanubù na duwán séllaán ku, asta séllaán katô Ámmà ku asta mga panaligan din. ");
INSERT INTO bgs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Asal paminág yu ni kagin ku ákniyu. Duwán dini ákniyu na dì maté sippang ka kumita dan katô pagpangulu ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na, pángnga ka mga walu álló tikud tun ta igkagi i Jesus ni langun, igpatákkás din si Pedro, si Juan, asta si Santiago. Igtikáddág dan tun ta pabungan ébô dumasal sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Róggun na igdasal si Jesus, ipalin tô bónnóng din, asta igséllà ka kapputian tô umpak din. ");
INSERT INTO bgs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tigkô dád duwán duwa manubù na igtóngkô ki Jesus, na si Moises asta si Elias ");
INSERT INTO bgs_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","na duwán séllaán dan. Igpatóngkóé tô tállu dan tingód ka kamatayan i Jesus na matuman kandin tun ta Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na, ináknákkan si Pedro asta tô duwa kadumaan din. Tô igánnó dan, igkita dan tô séllaán i Jesus asta tô duwa manubù na igtindág madani tun kandin. ");
INSERT INTO bgs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Róggun na igpanó si Moises asta si Elias, igkagi si Pedro ki Jesus, na mà din, “Áglangngagán, madigár su dini ké. Mimu ké dini ka tállu rákkó, sábbad para áknikó, sábbad para ki Moises, asta sábbad para ki Elias.” Agad tô gó é igkagi i Pedro, asal ándà din kagpátti tô igkagi din. ");
INSERT INTO bgs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Róggun na igkagi si Pedro, igdunggù tô sagulapun na ikatambun kandan. Tô isidalungan dan katô sagulapun, imáddangan dan. ");
INSERT INTO bgs_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Igdinág dan tô kagi ka Manama tikud tun ta sagulapun, na mà din, “Ni gó ni kanak Batà na igsalin ku. Paminág yu sikandin!” ");
INSERT INTO bgs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na, pángnga igkagi tô Manama, igkita dan si Jesus na sábbad din dád. Tô timpo tô, ándà igulitan dan tingód katô igkita dan. ");
INSERT INTO bgs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na, pagkasimag, tô igtupang si Jesus asta tô tállu disipulu din tikud tun ta pabungan, isumaran dan ka marapung manubù. ");
INSERT INTO bgs_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na, duwán sábbad manubù na igtawar ki Jesus, na mà din, “Sir, kéduwi nu ni batà ku, su sikandin tô bugtung batà ku. ");
INSERT INTO bgs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Marag sikandin gahuwan ka madat espiritu, gullaó sikandin, ágtuyù-tuyù sippang ka ágburà tô babbà din asta girrayatan sikandin. Mahirap paluwaán tô madat espiritu tikud tun kandin. ");
INSERT INTO bgs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Igpédu-éduwa katô mga disipulu nu na paluwaán dan tô madat espiritu na igahu kandin, asal ándà dan ikému.” ");
INSERT INTO bgs_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Igtaba si Jesus, na mà din, “Sikiyu mga manubù áknganni, dì kó ágsarig kanak, asta madat tô panámdám yu. Dì dán madugé na dumuma a ákniyu, asal kailangan tumiissa pa. Na, pid nu dini tô batà nu.” ");
INSERT INTO bgs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Róggun na igsadun tô batà tun ki Jesus, igpabuntug katô madat espiritu tô batà, asta igpatuyù-tuyù sikandin. Asal igsapadan i Jesus tô madat espiritu. Purisu inólian tô batà, asta igpid i Jesus tun ta ámmà din. ");
INSERT INTO bgs_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tuu isalábbuan tô langun manubù tingód katô katulusan ka Manama. Róggun na isalábbuan tô langun manubù tingód katô mga iglumu i Jesus, igkagi sikandin tun ta mga disipulu din, na mà din, ");
INSERT INTO bgs_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kailangan paminággán yu ni kagin ku ákniyu. Matuman ni dumunggù kanak na Igpamanubù. Kailangan bággénna tun ta bállad katô duma mga manubù.” ");
INSERT INTO bgs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Asal ándà gó kagpátti katô mga disipulu din tô kóbadan katô igkagi din, su ándà pasóddóri kandan ébô dì dan kagpáttan. Ándà dan insà kandin tingód katô igkagi din, su ágkamáddangan dan. ");
INSERT INTO bgs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na, igpapulé tô mga disipulu i Jesus tingód ka sadan tun kandan tô tuu mallayat é kamanubuan. ");
INSERT INTO bgs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Asal isóddóran i Jesus tô ágpanámdámmán dan. Purisu igtawar din tô sábbad batà, asta igpatindág din madani tun kandin. ");
INSERT INTO bgs_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Igkagi si Jesus, na mà din, “Atin ka ágtanggap kó kani sábbad batà tingód ka kapasakup yu kanak, iring na ágtanggapánna ikiyu. Tô manubù na ágtanggap kanak, ágtanggapán din tô igpapid kanak, su tun ta langun yu, tô manubù na tuu mabbabà é kamanubuan, sikandin tô tuu mallayat.” ");
INSERT INTO bgs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Na, igkagi si Juan, na mà din, “Áglangngagán, duwán sábbad manubù na igkita dé na igpaluwà ka madat mga espiritu ukit ka kagamit din katô ngadan nu. Asal igsapadan dé sikandin su ánnà kadumaan ta.” ");
INSERT INTO bgs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Asal igkagi si Jesus, na mà din, “Yakó ágsapad kandin, su kadumaan yu tô mga manubù na ánnà usig yu.” ");
INSERT INTO bgs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na, tô masig dán dumunggù tô álló na mulì si Jesus tun ta langit, igplano sikandin na madun tun ta Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Duwán mga manubù na igpóna i Jesus. Igpanó dan, asta igsadun dan tun ta sábbad lunsud na sakup ka Samaria ébô tumaganà dan katô balé na áddingan din. ");
INSERT INTO bgs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ánnà Judio tô mga manubù na góddô dutun. Purisu ándà dan tanggapi si Jesus, su isóddóran dan na madun sikandin tun ta Jerusalem. ");
INSERT INTO bgs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tô ikasóddór si Santiago asta si Juan na dì dan tanggapán katô mga taga Samaria, igkagi sikandan, na mà dan, “Áglangngagán, kakalyag nu na padabuan dé ka apuy tikud tun ta langit ébô mapánnas dan?” ");
INSERT INTO bgs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Asal igsérê si Jesus, asta igsapadan din sikandan. ");
INSERT INTO bgs_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na, igpanayun dan tun ta ássa lunsud. ");
INSERT INTO bgs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Róggun na ágpanó dan, duwán sábbad manubù na igkagi ki Jesus, na mà din, “Mákkássa áknikó agad ánda ka madun.” ");
INSERT INTO bgs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Asal igkagi si Jesus, na mà din, “Tô mga mannanap ka kabánnássan, duwán pa góddóan dan, asta tô mga manuk ka kayun, duwán pa gapunanan dan. Asal sakán na Igpamanubù, ándà palang góddóan ku na ágkadággaan.” ");
INSERT INTO bgs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Igkagi si Jesus tun ta ássa manubù, na mà din, “Tákkás ka kanak.” Asal igtaba sikandin, na mà din, “Áglangngagán, mákkássa áknikó, asal pólì a pa ébô lábbángngán ku tô ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Asal igkagi si Jesus, na mà din, “Tô mga manubù na ándà kantayan na ándà ágtamanán, tô gó é lumábbáng katô mga kadumaan dan na inaté. Asal sikuna na duwán kantayan na ándà ágtamanán, kailangan mulit-ulit ka tingód katô pagpangulu ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Duwán ássa manubù na igkagi ki Jesus, na mà din, “Áglangngagán, mákkássa áknikó. Asal mulì a pa ébô pasóddórán ku tô pamilya ku.” ");
INSERT INTO bgs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Igkagi si Jesus, na mà din, “Yaka giring katô manubù na ágdaru na inalayun ágsérê, su tô manubù na ágduwa-duwa na mákkás kanak, dì sikandin masakup tun ta pagpangulu ka Manama.” ");
INSERT INTO bgs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na, igsalin katô Áglangngagán tô kapittuwan duwa (72) manubù, asta igpóna din sikandan na tagduwa-duwa ébô madun dan tun ta langun lunsud asta mga lugar na sadunan din. ");
INSERT INTO bgs_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Igkagi si Jesus kandan, na mà din, “Dakál tô ágkáttun, asal tagsábbadé dád tô tarakáttu. Purisu dasal kó tun ta Áglangngagán na tigatun ka kinamát ébô papid sikandin ka duma mga tarakáttu. ");
INSERT INTO bgs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, panó kó. Banté kó katô madat mga manubù, su iring kó na mga karnero na ágbanganan katô mannanap ka kabánnássan na ágngadanan lobo. ");
INSERT INTO bgs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yakó ágpid ka salapì, kabir, asta sandalyas. Yakó ágtóngkô-tóngkô katô mga manubù na ágkitanán yu tun ta dalan ébô dì kó ágkabaring. ");
INSERT INTO bgs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Atin ka ágdunggù kó tun ta balé, una yu kagiyi, na mà yu, ‘Mólà pa ka duwán kasunayan yu!’ ");
INSERT INTO bgs_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Atin ka masuné tô tigbalé, bággayan sikandin ka Manama ka kasunayan. Asal atin ka ánnà masuné tô tigbalé, pamuyù yu tun ta Manama na angén din tô kasunayan na bággén yu pád tun kandin. ");
INSERT INTO bgs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Agad ándin tô pakannán dan ákniyu, tô dád gó é kannán yu asta inámmán yu, su tô manubù na áglumu kailangan tandanan. Yakó galin-alin tun ta duma balé, asal óddô kó tun ta sábbad dád balé. ");
INSERT INTO bgs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Atin ka ágdunggù kó tun ta lunsud asta ágtanggapán kó ikandan, agad ándin tô pakannán dan ákniyu, tô dád gó é kannán yu. ");
INSERT INTO bgs_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dappánni yu ka bállad tô mga ágkabógókan ébô kólian. Kagiyi yu sikandan, na, ‘Masig dán mangulu tô Manama ákniyu.’ ");
INSERT INTO bgs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Atin ka ágdunggù kó tun ta lunsud asta dì kó ikandan tanggapán, panó kó tun ta dalan, asta kagiyi yu tô mga tigbalé, na mà yu, ");
INSERT INTO bgs_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Agad tô barukbuk nit banuwa yu na igdákkát kannun ta paa dé padpadán dé ébô kasóddóran yu na duwán sókó ka Manama ákniyu. Pénagpáttán dé sikiyu na masig dán mangulu tô Manama.’ ");
INSERT INTO bgs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kagiyan ku sikiyu na supakan ka Manama tô mga taga Sodoma tun ta tapuri álló tingód katô salà dan, asal tuu pa madat tô supak ka Manama katô mga manubù tun ta lunsud na dì tumanggap ákniyu.” ");
INSERT INTO bgs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Makédu-édu kó na mga taga Corasin! asta makédu-édu kó na mga taga Betsaida! su ándà kó rákkád. Atin ka igimu tô kasalábbuan tun ta mga taga Tiro asta mga taga Sidon sayyan iring katô mga kasalábbuan na igimu ku dini ákniyu, igumpak dan pád katô óggét na gimun sako, asta igtagù dan pád ka abu tun ta ulu dan ébô pakitanán dan na igrákkád dan dán. ");
INSERT INTO bgs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tun ta álló ka rumuud tô Manama, agad supakan din tô mga taga Tiro asta tô mga taga Sidon, asal tuu pa madat tô supak din ákniyu. ");
INSERT INTO bgs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sikiyu mga taga Capernaum, kéman yu ka pabantugán kó sippang tun ta langit, asal dabuán kó baling tun ta góddóan ka mga inaté.” ");
INSERT INTO bgs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Igkagi si Jesus tun ta mga disipulu din, na mà din, “Tô manubù na maminág ákniyu, ukit kani ágpaminággánna ikandin. Tô manubù na méllé ákniyu, méllé kanak. Tô manubù na méllé kanak, méllé katô igpapid kanak.” ");
INSERT INTO bgs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na, tô igulì tô kapittuwan duwa (72) na igpóna i Jesus, idayawan dan, asta igkagi sikandan, na mà dan, “Áglangngagán, agad tô madat mga espiritu ignunug áknami ukit ka kagamit dé katô ngadan nu!” ");
INSERT INTO bgs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Igkagi si Jesus, na mà din, “Bánnal, su igkita ku si Maibuyan na iring na kirám na idabù tikud tun ta langit. ");
INSERT INTO bgs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yakó yu ágkalingawi ni. Igpapid ku sikiyu ébô manalu kó ka katulusan katô usig ka Manama. Agad makagit kó ka áppuy asta mananipit, asal ándà palang makadadat ákniyu. ");
INSERT INTO bgs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na, agad ikapanalu kó ka madat mga espiritu, ánnà ni tô kadayawan yu. Asal kailangan kadayawan kó su igsulat dán tô ngadan yu tun ta langit.” ");
INSERT INTO bgs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na, tô oras tô, dakál tô dayó na igbággé katô Ugis Espiritu ki Jesus, asta igdasal sikandin, na mà din, “Ámmà na Áglangngagán katô langun tun ta langit asta dini ta banuwa, ágpasalamatta áknikó, su ándà nu pasóddóri ni kabánnalan tun ta mga manubù na kéman dan ka mapandé asta dakál é isóddóran, asal igpasóddór nud ni kabánnalan tun ta mga manubù na mabbabà é kamanubuan. Durungán ku sikuna, Ámmà, su tikud tun ta madigár kakalyag nu.” ");
INSERT INTO bgs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Igkagi si Jesus, na mà din, “Igsarig katô Ámmà ku tô langun dini kanak. Tô Ámmà ku dád tô ikasóddór kanak, su sakán tô Batà din. Sakán dád tô ikasóddór katô Ámmà ku, asta tô langun manubù na ágsalinán ku ébô makasóddór tingód katô Ámmà ku.” ");
INSERT INTO bgs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na, igkagi si Jesus tun ta mga disipulu din na ándà ássa manubù, na mà din, “Ágkadayawan kó su ikakita kód katô kabánnalan! ");
INSERT INTO bgs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kagiyan ku sikiyu na tô marapung mga propeta ka Manama asta tô mga harì sayyan, agad malyag dan na kumita katô igkita yu, asal ándà dan ikakita. Agad malyag dan na maminág katô igdinág yu, asal ándà dan ikadinág.” ");
INSERT INTO bgs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na, igtindág tô sábbad taratinurù katô mga sugù. Kakalyag din na kuminnam minsà ki Jesus. Purisu iginsà sikandin, na mà din, “Sir, ándin tô kailangan lumun ku ébô makatanggappa ka kantayan na ándà ágtamanán?” ");
INSERT INTO bgs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Igkagi si Jesus, na mà din, “Ándin tô igsulat tun ta mga sugù ka Manama? Ándin tô igbasa nu?” ");
INSERT INTO bgs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Igtaba tô manubù, na mà din, “‘Ginawayi yu tô Áglangngagán na Manama yu tikud tun ta tibuk pusung yu, tikud tun ta tibuk kantayan yu, tikud tun ta tibuk panámdám yu, asta tikud tun ta tibuk bákkár yu. Ginawayi yu tô unawa yu na iring katô kaginawa yu katô ákniyu sarili.’” ");
INSERT INTO bgs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Igkagi si Jesus, na mà din, “Nángngà tô igtaba nu. Lumu nu yan ébô makatanggap ka katô kantayan na ándà ágtamanán.” ");
INSERT INTO bgs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Asal kakalyag katô manubù na pasóddórán din na nángngà tô áglumun din tun ta saruwan ka Manama. Purisu iginsà sikandin, na mà din, “Sadan tô unawa ku?” ");
INSERT INTO bgs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Igtaba si Jesus, na mà din, “Duwán sábbad Judio na igpanó tikud tun ta Jerusalem, asta igsadun tun ta Jerico. Na, isabban sikandin ka mga tulisan. Igadólan dan, igpakuy dan, asta igtananan dan sikandin na ágkamaté-maté dán. ");
INSERT INTO bgs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na, igdunggù tô sábbad pangulu ka templo ka Judio. Asal tô igkita din tô manubù na inamù, iglili sikandin tun ta ágbaluy. ");
INSERT INTO bgs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na, igdunggù pagsik tô sábbad Judio na sakup ka grupo i Levi. Asal tô igkita din tô manubù na inamù, iglili sikandin tun ta ágbaluy. ");
INSERT INTO bgs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na, duwán sábbad taga Samaria na igdunggù tun ta Judio na inamù. Tô igkita sikandin katô inamù, inéduwan sikandin. ");
INSERT INTO bgs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Igpadaniyan din, igbawian din tô amù katô Judio ka langis ka olibo asta bino, asta igbagkássan din. Igpasaké din tô Judio tun ta asno din, asta igpid din tun ta balé na ágdungguanan, asta igdóppónan din. ");
INSERT INTO bgs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagkasimag, igbággé din tô duwa abuk salapì tun ta tigatun katô balé, asta igkagi sikandin, na mà din, ‘Dóppóni nu sikandin. Atin ka duwán kulang, bayadan ku ka lumónódda.’ ");
INSERT INTO bgs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Na, ándin tô panámdám nu? Tun ta tállu manubù na igkita katô isabban ka mga tulisan, sadan tun kandan tô igpakita na unawa din?” ");
INSERT INTO bgs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Igtaba tô taratinurù, na mà din, “Tô taga Samaria na inéduwan asta igtabang kandin.” Igkagi si Jesus, na mà din, “Purisu kailangan tô gó pagsik tô lumun nu.” ");
INSERT INTO bgs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na, tô igpanó dan, igukit dan tun ta sábbad lunsud. Duwán sábbad bayi na ágngadanan ki Marta na igpadding ki Jesus tun ta balé din. ");
INSERT INTO bgs_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Duwán adi din na si Maria na igunsad madani tun ta paa katô Áglangngagán ébô maminág katô ágtinuruán i Jesus. ");
INSERT INTO bgs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Asal si Marta, ágkasasó tô panámdám din tingód katô marapung mga áglumun din. Purisu igpadani si Marta tun ki Jesus, asta igkagi sikandin, na mà din, “Áglangngagán, sábbad ku dád tô góméng, su dì ágtabang ni adi ku. Atin ka duwán kédu nu kanak, kagiyi nu sikandin ébô tumabang kanak.” ");
INSERT INTO bgs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Asal igtaba tô Áglangngagán, na mà din, “Marta, Marta, tuu ka ágkatanaan tingód katô mga áglumun nu. ");
INSERT INTO bgs_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sábbad dád tô ágkailanganán. Tô gó tô madigár na igsalin i Maria, asta dì ni makangé tikud tun kandin.” ");
INSERT INTO bgs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na, sábbad álló na igdasal si Jesus tun ta sábbad lugar. Pángnga katô kadasal din, duwán sábbad disipulu din na igkagi, “Áglangngagán, tinurui ké ágdasal iring katô igtinurù i Juan na Tarabunyag katô mga disipulu din.” ");
INSERT INTO bgs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Igkagi si Jesus, na mà din, “Iring kani é kadasal yu. ‘Ámmà, mólà pa ka pangadapán ka katô langun manubù. Mólà pa ka mangulu ka tun ta langun manubù. ");
INSERT INTO bgs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bággéyi ké ka ágkannán dé álló-álló. ");
INSERT INTO bgs_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasinsiyayi ké na ikasalà áknikó, su ágpasinsiyaan dé tô langun manubù na ikasalà áknami. Yaka ágpókit áknami tun ta pagkinnam.’” ");
INSERT INTO bgs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Igkagi si Jesus kandan, na mà din, “Atin ka madun ka tun ta balé katô rarak nu, agad tángngà ka dukilám, ébô mállás ka tállu abuk pan, kumagi ka kandin, na, ");
INSERT INTO bgs_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Duwán rarak ku na mantu igdunggù, asta ándà pakannán ku kandin.’ ");
INSERT INTO bgs_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tumaba tô tun dalám, na mà din, ‘Yaka ágsamuk kanak. Igsagpángngan dán tô sállat, asta ágdággà ad asta ni mga gabatà ku. Diyad makannó ébô mággé áknikó.’ ");
INSERT INTO bgs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na, kumagiya ákniyu, agad dì pád sikandin mánnó ébô tumabang katô rarak din, ka dì sumungkù tô manubù na mamuyù, kailangan mánnó sikandin ébô bággén tô agad ándin é ágpamuyuán din. ");
INSERT INTO bgs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Purisu kumagiya ákniyu, pamuyù kó inalayun tun ta Manama, asta bággayan kó ikandin. Pamasak kó inalayun tun kandin, asta kitanán yu. Tákták kó inalayun tun ta sállat, asta pókéan kó ikandin. ");
INSERT INTO bgs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Makatanggap tô langun manubù na ágpamuyù. Makakita tô langun manubù na ágpamasak. Pókéan tô langun manubù na ágtákták. ");
INSERT INTO bgs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sikiyu na mga ámmà, atin ka mamuyù tô batà yu ka sáddà, ánnà áppuy tô bággén yu kandin. ");
INSERT INTO bgs_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Atin ka mamuyù tô batà yu ka tállug, ánnà mananipit tô bággén yu kandin. ");
INSERT INTO bgs_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na, sikiyu, agad duwán madat mga áglumun yu, asal inalayun madigár tô mga ágbággén yu tun ta mga gabatà yu. Na, tô Ámmà yu na Manama tun ta langit tuu pa mággé katô Ugis Espiritu tun ta langun manubù na ágpamuyù kandin!” ");
INSERT INTO bgs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na, duwán madat espiritu na igpaluwà i Jesus tikud tun ta sábbad manubù na inómmó, ikakagi tô manubù, asta isalábbuan tô langun manubù. ");
INSERT INTO bgs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Asal duwán mga manubù na igkagi, na mà dan, “Ágpaluwà sikandin katô madat mga espiritu ukit katô pangulu ka madat mga espiritu na si Belsebul.” ");
INSERT INTO bgs_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Duwán ássa mga manubù na igpamuyù ki Jesus na pakitanán din kandan tô kasalábbuan tikud tun ta langit ébô kasóddóran dan na sikandin tô bánnal igpapid ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Asal isóddóran i Jesus na madat tô panámdám dan. Purisu igkagi sikandin, na mà din, “Atin ka ágpamatayé tô mga sakup ka sábbad pangulu, dì madugé mandà tô pagpangulu din. Atin ka ágpamatayé tô sábbad pamilya, dì madugé padiyaé dan. ");
INSERT INTO bgs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Purisu atin ka ágpaluwà si Maibuyan katô mga sakup din, mandà tô pagpangulu din, su imun din na usig tô mga sakup din. Ágkagi kó na ágpaluwà a katô madat mga espiritu su igsugù a i Belsebul. ");
INSERT INTO bgs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Atin ka ágsawén yu ni kapaluwà ku katô madat mga espiritu su ágpanámdám kó na igsugù a i Belsebul, ágsawén yu tô ákniyu mga disipulu, su ágpaluwà dan pagsik ka madat mga espiritu. Purisu sikandan tô ágpasóddór na ánnà nángngà tô kasawé yu kanak. ");
INSERT INTO bgs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Atin ka ágpaluwà a katô madat mga espiritu ukit katô katulusan ka Manama, igdunggù dán gó dini ákniyu tô pagpangulu ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Atin ka ágtómmóng tô mabákkár manubù katô balé din asta duwán laniban din, dì magó tô kaduwánnan din. ");
INSERT INTO bgs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Asal atin ka dumunggù tô ássa manubù na tuu pa mabákkár ka tandingán kandin, tô gó tô sumulung asta makapanalu katô tigbalé, makagó katô langun laniban na ágsarigan din, asta tumalad-talad katô inagó din. ");
INSERT INTO bgs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tô langun manubù na dì ágtákkás kanak, tô gó é gusig kanak, asta tô langun manubù na dì áglimud ka mga manubù dini kanak, tô gó é ágpéwà ka mga manubù tikud dini kanak.” ");
INSERT INTO bgs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Na, atin ka duwán madat espiritu na paluwaán tun ta manubù, ágpanó-panó tô madat espiritu tun ta disyerto ébô mamasak sikandin ka madigár óddóan din. Atin ka ándà kitanán din, kumagi sikandin, na mà din, ‘Lumónódda tun ta manubù na taganà igahuwan ku.’ ");
INSERT INTO bgs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Purisu lumónód tô madat espiritu tun kandin, asta kitanán din na madigár dán tô manubù na taganà din igahuwan, iring na malinis asta matémmós balé. ");
INSERT INTO bgs_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Purisu kangén katô madat espiritu tô ássa pittu madat espiritu na tuu pa madat ka tandingán kandin. Madun dan langun tun ta manubù, asta mahu dan tun kandin. Purisu tuu pa madat tô dungguán kani manubù ni.” ");
INSERT INTO bgs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na, róggun ágtinurù si Jesus, duwán sábbad bayi na igtawar kandin, na mà din, “Duwán dayó katô innà nu na igpamasusu asta igpasusu áknikó!” ");
INSERT INTO bgs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Asal igtaba si Jesus, na mà din, “Asal duwán dayó katô langun manubù na ágpaminág asta ágtuman katô kagi ka Manama!” ");
INSERT INTO bgs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tô marapung dán tô mga manubù na ilimud tun ki Jesus, igkagi sikandin, na mà din, “Madat tô kakalyag katô mga manubù áknganni, su kakalyag dan na pakitanán ku tô kasalábbuan kandan. Asal sábbad dád tô kasalábbuan na pakitanán ka Manama kandan na iring katô iglumu din ki Jonas sayyan. ");
INSERT INTO bgs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ukit katô ilumu ki Jonas, ikasóddór tô mga taga Ninibe na Manama tô igpapid kandin. Iring pagsik kani, ukit katô malumu kanak, kasóddóran katô mga manubù áknganni na Manama tô igpapid kanak na Igpamanubù. ");
INSERT INTO bgs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Tun ta álló ka rumuud tô Manama, tumindág tô rayna na igpangulu tun ta Siba sayyan, asta kumagi sikandin na kailangan supakan kó su ándà kó paminág kanak. Agad madiyù tô góddóan katô rayna, asal igsadun sikandin tun ki Solomon ébô maminág dád katô kapandayan na ágtinuruán i Solomon. Na, duwán dán igdunggù dini ákniyu na tuu pa mallayat tô kamanubuan din ka tandingán ki Solomon. ");
INSERT INTO bgs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tun ta álló ka rumuud tô Manama, tumindág tô mga taga Ninibe, asta kumagi dan na kailangan supakan kó su ándà kó rákkád ka mga salà yu. Su tô igdinág tô mga taga Ninibe katô igulit-ulit i Jonas, igrákkád dan. Na, duwán dán igdunggù dini ákniyu na tuu pa mallayat tô kamanubuan din ka tandingán ki Jonas.” ");
INSERT INTO bgs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Atin ka ágrákkáttan é sulù, dì gállássán, asta dì ágtambunan, asal ágsapatán ébô kataddawan tô langun manubù na mahu tun ta balé. ");
INSERT INTO bgs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sulù ka lawa tô mata. Purisu atin ka mappawà tô kasállág nu, kappawaan tô tibuk lawa nu. Asal ka mangittáng tô kasállág nu, kangittángngan tô tibuk lawa nu. ");
INSERT INTO bgs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Purisu banté ka ébô dì kumangittáng tô sulù tun ta lawa nu. ");
INSERT INTO bgs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Atin ka kappawaan tô tibuk lawa nu, asta ándà palang kangittángngan, mappawà dán tô langun, iring na sulù na ágséllà tun áknikó.” ");
INSERT INTO bgs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Na, pángnga igtinurù si Jesus, duwán sábbad sakup ka mga Pariseo na igpakan kandin. Purisu igahu si Jesus tun ta balé katô Pariseo, asta igkan dan. ");
INSERT INTO bgs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Isalábbuan tô Pariseo, su dì giring si Jesus katô ágkémun ka mga Judio tingód ka kadamù ka dì pa kuman. ");
INSERT INTO bgs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Asal igkagi tô Áglangngagán, na mà din, “Sikiyu mga Pariseo, iring kó na mga baso asta mga linipung na igurasan dád tô tun ta luwà, asal maripà tô tun dalám, su tuu madat tô áglumun yu, asta tagawán kó. ");
INSERT INTO bgs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ánnà nángngà tô panámdám yu! Ánnà dád tô tun ta luwà katô lawa yu tô igimu ka Manama, asal igimu din pagsik tô tun dalám. ");
INSERT INTO bgs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kailangan tikud tun ta kédu yu tô kabággé yu tun ta manubù na ágkahirapan, asta ukit katô kédu yu, madigár tô langun áglumun yu. ");
INSERT INTO bgs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Asal makédu-édu kó na mga Pariseo! su agad ágbággén yu tun ta Manama tô ikasapulù katô langun ka pamulanán yu agad mga anag, asal ándà yu bánnali tô tuu ágkailanganán, tingód katô nángngà lumun yu tun ta mga unawa yu, asta ándà yu ginawayi tô Manama. Nángngà tô kabággé yu katô ikasapulù, asal yakó ágsódô katô mga ágkailanganán na nángngà lumun yu. ");
INSERT INTO bgs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Makédu-édu kó na mga Pariseo! su malyag kó munsad tun ta madigár gunsadanan tun ta mga simbaan ka Judio, asta malyag kó respetowan katô duma mga manubù tun ta plasa. ");
INSERT INTO bgs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Makédu-édu kó! su iring kó na mga lábbáng na ággittan katô mga manubù na gukit su dì ágkakilalaan.” ");
INSERT INTO bgs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Duwán sábbad taratinurù ka sugù na igkagi ki Jesus, na mà din, “Sir, ukit ka igkagi nu katô mga Pariseo, igbuyas ké pagsik ikuna.” ");
INSERT INTO bgs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Igkagi si Jesus, na mà din, “Makédu-édu kó pagsik na mga taratinurù ka sugù! su iring kó katô manubù na ágpirit ka duma manubù na tumiang katô tuu mabággat asta mahirap ágpiddán, asal dì kó gó gawid katô piniddan ébô tumabang kandan. ");
INSERT INTO bgs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Makédu-édu kó! su gimun yu tô mga pantyun para katô mga propeta na igmatayan katô ákniyu kamónaan. ");
INSERT INTO bgs_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ukit ka kému yu katô mga pantyun dan, ágpasóddórán yu na ágnunug kó katô iglumu katô kamónaan yu. Kamónaan yu tô igmaté katô mga propeta, asta sikiyu tô gimu katô mga pantyun dan. ");
INSERT INTO bgs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Purisu igkagi tô Manama ukit katô kapandayan din, na mà din, ‘Papiddán ku tô mga propeta asta tô mga apostoles tun kandan. Asal duwán matayan dan asta duwán irrayatan dan.’ ");
INSERT INTO bgs_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Purisu supakan ka Manama tô mga manubù áknganni tingód ka kamatayan katô mga propeta din, tikud tun ta katigkanayan ka banuwa sippang áknganni, ");
INSERT INTO bgs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tikud katô kamaté ki Abel sippang katô kamaté ki Zacarias na igmatayan yu tun ta tángngaan katô ággóbbówanan ka mga mannanap asta katô templo. Paminág yu ni kagin ku ákniyu na mga manubù áknganni. Supakan kó katô Manama tingód katô kamatayan dan. ");
INSERT INTO bgs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Makédu-édu kó na mga taratinurù ka sugù! su iring kó na manubù na igállás ka susì ka balé ébô ándà manubù na makahu, su agad sikiyu, ándà kó ahu, asta igbalabagan yu tô mga manubù na mahu pád.” ");
INSERT INTO bgs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na, róggun igpanó si Jesus tikud tun ta balé, tô mga Pariseo asta tô mga taratinurù ka sugù, igirrayat dan kandin asta maggát dan igággut-ággut kandin, ");
INSERT INTO bgs_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","su ágbangan dan ka ándin tô ágpangkagin din ébô duwán dimanda dan. ");
INSERT INTO bgs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na, dalám ka igtinurù si Jesus, mga mararan tô mga manubù na ilimud sippang ka igpagitté dan. Una igkagi si Jesus tun ta mga disipulu din, na mà din, “Banté kó katô pagpatubù ka pan katô mga Pariseo. Kéman dan ka nángngà tô áglumun dan tun ta saruwan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ándà palang gállássán áknganni na dì pakitanán tun ta tapuri álló. Ándà ágbulunán áknganni na dì pasóddórán tun ta tapuri álló. ");
INSERT INTO bgs_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Purisu agad ándin tô igkagi yu ka dukilám, tô gó é paminággán ka álló. Agad ándin tô igtinurù yu na sikiyu dád, tô gó é ullaón tun ta langun manubù.” ");
INSERT INTO bgs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mga rarak ku, kagiyan ku sikiyu, yakó ágkamáddangan katô mga manubù na makamaté katô lawa yu, asta ándà dán ássa na malumu dan ákniyu. ");
INSERT INTO bgs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Asal kagiyan ku sikiyu, kamáddangi yu baling tô Manama, su pángnga matayan din tô mga manubù, duwán katulusan din ébô sumugù kandan tun ta ágsupakanan. Kagiyan ku sikiyu, kamáddangi yu tô Manama! ");
INSERT INTO bgs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Agad délák é lagà katô lima manuk ta kayun na ágbállin yu, asal ándà palang manuk ta kayun na ágkalingawan katô Manama. ");
INSERT INTO bgs_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Agad tô silag katô ulu yu inéyap dán ka Manama. Purisu yakó ágkamáddangan, su tô lagà yu tuu pa dakál ka tandingán katô marapung mga manuk ta kayun.” ");
INSERT INTO bgs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Na, kagiyan ku sikiyu na tô manubù na kumagi tun ta duma mga manubù na igpasakup sikandin kanak na Igpamanubù, kumagiya pagsik tun ta saruwan katô mga panaligan ka Manama na sikandin tô sakup ku. ");
INSERT INTO bgs_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Asal tô manubù na mulun kanak tun ta duma mga manubù, bulunán ku sikandin tun ta saruwan katô mga panaligan ka Manama. ");
INSERT INTO bgs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Tô manubù na ágkagi ka madat tingód kanak na Igpamanubù, atin ka rumákkád sikandin, mému kapasinsiyaan ka Manama. Asal tô manubù na ágkagi ka madat tingód katô Ugis Espiritu, dì gó sikandin kapasinsiyaan. ");
INSERT INTO bgs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Atin ka ruudan kó katô mga pangulu ka simbaan ka Judio asta mga opisyales ka gobyerno tingód katô katákkás yu kanak, yakó ágkatanaan tingód katô taba yu asta katô kagin yu kandan, ");
INSERT INTO bgs_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","su tô álló tô, tinuruan kó katô Ugis Espiritu ka ándin tô kailangan kagin yu kandan.” ");
INSERT INTO bgs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na, tun ta mga manubù na ilimud, duwán sábbad manubù na igkagi ki Jesus, na mà din, “Sir, kagiyi nu tô kaké ku ébô bággén din kanak tô katángngà katô kaduwánnan na igtananan katô ámmà dé na inaté.” ");
INSERT INTO bgs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Asal igtaba si Jesus, na mà din, “Ánnà a huwes na tumángngà katô ákniyu kaduwánnan.” ");
INSERT INTO bgs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Igkagi si Jesus tun ta mga manubù na ilimud, na mà din, “Banté kó. Yakó ágkasabuan, su agad dakál ó délák tô kaduwánnan ka manubù, tô bánnal kantayan din ánnà ukit katô kaduwánnan.” ");
INSERT INTO bgs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na, igulit si Jesus ka panunggiringan, na mà din, “Duwán sábbad ágkaduwánnan na ikakáttu ka tuu dakál. ");
INSERT INTO bgs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Igpanámdám sikandin, ‘Ánnà nángngà tô ágtaguanan ku katô kináttuwan. Pamánnun ku? ");
INSERT INTO bgs_vpl VALUE