﻿USE sofia;
DROP TABLE IF EXISTS sofia.bgg_vpl;
CREATE TABLE bgg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bgg_vpl WRITE;
INSERT INTO bgg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hì ne Isu Masi pha blangthek, Dawid ro riingthek, hanyie yi Abraham ro riingthek, ithek ro sasab ro boh phabi. ");
INSERT INTO bgg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Abraham re-è yie dang ne Dawid Saja khama blangthek um pha ne ichiih luii shii zey muii ro: Abraham, Ishak, Jakhob, Juda chiih-è airo khuiinothek, ji pha idoh Pherez nane Zera (ithek amuii ne Thamar ro), Hezron, Ram, Aminadab, Nasa, Salmon, Boaz (ai amuii ne Rahab ro), Obed (Ithek ro amuii ne Ruth ro), Jese nane Dawid Saja. ");
INSERT INTO bgg_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Dawid Saja sieng pha ishak re-è yie dang ne Israel pha bran shii Babylon hà zum ne noh dun pha blangthek de ichiih luii shii zey muii ro: Dawid, Solomon (airo amuii ne Uria yiy ne raijong noh pha bimi ji ro), Rehoboam, Abija, Asa, Zehoshaphath, Zehoram, Uzia, Zotham, Ahaz, Hezekhia, Manase, Amon, Josia nane Jehoiachin nane airo khuiinothek. ");
INSERT INTO bgg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Babylon hà zum ne rai marui pha ishak è yie dang ne Isu giak pha ishak thogdang pha blangthek ne ichiih luii shii zey muii ro: Jehoiachin, Shealhthiel, Zerubabel, Abiud, Eliakhim, Azor, Zadokh. Achim, Eluid, Eliazer, Muthan, Jakhob nane Joseph, hanyie è Isu giak pha amuii Mery shii yiy pha bufuii ji ro. Hanyie shii Masaiya rone ho muii pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ji-è, chiihphado Abraham è Dawid Saja thogdang pha blang ne snawi um ro, chiih-è, Dawid pha ishak è Babylon hà zum ne raidun pha ishak thogdang pha blangthek ne snawi um ro. Babylon è yie dang ne Isu Masi giak pha blangthek de snawi um ro. ");
INSERT INTO bgg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hì ne Isu Masi khi-èrek ne giak pha ji ro. Ai amuii Mery ne Joseph è shadiiegang rekjong ne ruii pha bimi ro. Jishii, ai ne ayiy-agey ba pha ibi shii ai ne Ragung So è ani wiig yi pha doh. ");
INSERT INTO bgg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph ne idang giang sieng ne rai pha bran ro, jiè ai ne Mery shii ug ne che pha saro, nyieliieshii ai è Mery shii hong ne biwo rek yi pha ayang ro. ");
INSERT INTO bgg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ai è ji è now ramuii shii, Ithong pha hamangkhliie jia ai ibang shii dongkhlei ruii ne aishii yao, “Dawid riing è giak pha Joseph, Mery shii na yiy rek ne noh pha arum chid rabo, ai ani ji ne Ragung So re-è wiig yi ro. ");
INSERT INTO bgg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ai è ani bufuii jia giak ruii phro, na ne ji pha ani shii Isu beng bo, nyieliieshii, ai è awai branthek shii awaithek layog è ragia rek phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Thuh hìthek rey ruii pha ji è Ithong è awai chaigthek è khi-èrek ne yao yi pha jithek zab rey sharuii pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ayiy-agey ba pha miliao bimi jia è ani wiig ne dufuii jia giak ruii phro, ai ibeng ne Imanuel beng ruii phro” (Jipha miyaosiu ne, Hamangkhung-aphuii ne gethek rog shii um ro). ");
INSERT INTO bgg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ji-è Joseph sieng srane Ithong pha hamangkhliie è khi-èrek ne yao pha duiine Mery shii awai yiy rek noh. ");
INSERT INTO bgg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jishii, ji pha ani agiak sapho ne ai è ji pha Mery rog shii ò amen ro. Chiih-è Joseph è aishii Isu rone beng. ");
INSERT INTO bgg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Isu ne Juda pha Bethlehem thawun shii Herod è saja khoh ne rai ramuii shii giak. Khthiie ji pha idoh shii, giak branthek hanyie yi dadiangthek gayiig rek pho, bichiu è Jerusalem hà wuii thog ");
INSERT INTO bgg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ne sai, “Jewthek pha saja rek ruii pha ani giak pha ji ne khi hà lei? Gathek è airo dadiang ne bichiu è ichiih shii chuang thog pha doh dun ro, jiè gathek de aishii misiasia pha ichiih shii wuii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herod saja è ji pha chiang yoi mage shii duhug rey dun, chiih-è Jerusalem hà rai pho de zab duhug rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod è khama jia pha boh phabithek nane Iphey yua pha masdothek um pho shii male ho srane sai, “Masi ne khi hà giak pha um ga?” ");
INSERT INTO bgg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Ji ne Juda pha thawun Bethlehem hà giak ruii phro,” Ithek è chang. Hì ne nyieliieshii chaigthek è zey ro: ");
INSERT INTO bgg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Juda pha soh Bethlehem, hà chiih-è Juda hà khama boh rajan um pha ji re-è chiih-è ìu rey sapho nyie chiang oi ro; nyieliieshii na è dumuii jia wuii ruii phro hanyie è guro branthek Israel pho shii gayiig rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ji-è, Herod saja ne bichiu è wuii pho shii ug srane male ho srane ne dadiang dong pha isbang ishak ji nathek è thieg. ");
INSERT INTO bgg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jipha idoh ai è nathek bichiu è wuii pho shii hì pha muyuathek rog shii Bethlehem thoh ge: “Wuii srane ji pha ani shii gayiig ne sow bo, nathek è aishii doh mage shii, gu shii de thieg yi bo, jiè gu de aishii wuii srane misiasia mua.” ");
INSERT INTO bgg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Chiih-è ithek ne dun dun. Din ne nathek bichiu hà doh pha dadiang ji ne dinne doh din. Ithek ji doh mage shii, ithek ne khama sang dun, ithek ne bajo lised dun! Ji ne ithek è ibi wuii ne ani um pha lakhung shii thung dun. ");
INSERT INTO bgg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ithek è ji pha ani giak pha hò bucho khud ne ani yi awai amuii Mery rog shii iang pha doh mage shii, ithek ne lagiung niing srane aishii misiasia. Ithek è awaithek ro san, bisikho nane remnow pha mana chiih-è lasen yi ji pha ani shii phi marui. ");
INSERT INTO bgg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jipha idoh ithek ne gai lumuii è dong ne awaithek soh hà dun dun. Nyieliieshii, Hamangkhung-aphuii è ithek shii Herod shii idoh adun rabo ne ibang shii bang ne phriie. ");
INSERT INTO bgg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ithek dun ched pha idoh shii, Ithong pha hamangkhliie è Joseph ibang shii yao, “Herod ne ani ji ua pha sow ramuii ro, ani nane ai amuii shii noh ne Egyph thiig hà yo ne rai mage bo, nashii aho sbo ne thiisa rai bo.” ");
INSERT INTO bgg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph sieng srane ji pha ani nane ai amuii shii noh srane habiu dang shii Egyph thiig hà yodun. ");
INSERT INTO bgg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ai è thiichiih shii Herod a-iy ba sapho thogdang pha rai marui. Hìthek rey pha ji è Ithong è khi-èrek ne chaig pho è yaojong pha ji izai rey yi pha ji rek ro, “Gune gu dufuii shii Egyph è ho jong ro.” ");
INSERT INTO bgg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod è bichiu re-è wuii pha biwenthek è aishii khinrin marui pha ji thieg ne bajo lijieg dun. Ji-è ai ne awai branthek shii yung ne Bethlehem nane thiichiih nui shii um pha thiig pha aniphiing dam nyi è luii ne khama jia um pho shii zab ua muii bo ne yung. Dadiang dong pha ishak pha chiang è ai ne biwenthek è nyie ìd pha ji pha ishak pha sasab rek ne hì pha blia rek. ");
INSERT INTO bgg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hì duiine chaig Jerimia è yao marui pha ji ne izai rey dun ro: ");
INSERT INTO bgg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama shii roh pha jia yoi ramuii ro, khewegkho ne cho ramuii ro. Rakhel ne awai ani chiang cho pha yoi muii ro; Ai ne cho pha ne them pha anuii phi ro, nyieliieshii ithek ne zab iy dun ro.” ");
INSERT INTO bgg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod iy dun pha idoh re-è Ithong pha hamangkhliie è Egyph hà Joseph ibang shii bang, ");
INSERT INTO bgg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ne yao, “Sieng srane ani nane ai muii shii noh ne Israel pha soh hà dun din mage bo, nyieliieshii, ani ji ua pha bidiang pha bran ji ne iyjong dun ro.” ");
INSERT INTO bgg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ji-è Joseph ne sieng srane ji pha ani nane ai amuii shii noh ne Israel pha soh hà dun thog. ");
INSERT INTO bgg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jishii, Joseph è Arkhelaus, Herod pha dufuii è Herod chiang Juda shii saja khoh muii rone yoi mage ne rum srane thiichiih adun. Ai ibang shii yua din mage ne jiè ai ne Galili pha soh hà dun dun. ");
INSERT INTO bgg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chiih-è Nazareth beng pha thawun shii hò rung ne raidun. Ji ne chaigthek è khi-èrek ne yao marui pha ji izai rey dun ro: “Ai ne Nazareth pho rone ho ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jipha ishak shii Jon Khowa phi pha bran de Juda pha balimuang shii wuii thog ne jao ne yua, ");
INSERT INTO bgg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nawaithek layogthek re-è khid mage bo, ai è yao, nyieliieshii, hamangkhung pha Sajathua ne inui sha ro!” ");
INSERT INTO bgg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon Khowa pha bran ji ne Aijaya chaig è khi-èrek ne yao marui pha ji ro, “Bran jia ne balimuang hà ziak muii ro, ‘Ithong wuii ruii pha lumuii saro iang bo; ai lua pha lumuii miang rab phi bo!’” ");
INSERT INTO bgg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ne ùd pha iman è rab pha yung guii ne rai ro; ai ne sukhug pha rathang re-è awai rinyi shii riieng ne rai ro; chiih-è ai michie ne muroma nane chimudkho ro. ");
INSERT INTO bgg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem pha branthek de Juda soh pho thek de, chiih-è Jordan khoboh moe shii rai pho thek de aishii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ithek è layog arek sha phro è yao phi ne ai è ithek shii Jordan kho shii Khowo phi. ");
INSERT INTO bgg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon è bajo Pharisithek nane Sadusithek de khowo yi pha wuiiramuii pha ji riig mage shii, ai è ithek shii yao, Nathek phamthek—Nathek ne Hamangkhung-aphuii è lakhung re-è thoh pha lago ji re-è ruang yo bone nathek shii hanyie miyao lei? ");
INSERT INTO bgg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nathek de nawaithek layog re-è idoh khed rone doh yi pha jithek rek mage bo. ");
INSERT INTO bgg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nathek de Abraham pha riing re-è giak rone yao ne ji pha lago re-è yo pha anow chid rabo. Gu nathek shii yao. Hamangkhung-aphuii è hìthek pha lubaothek re-è de Abraham pha blang nyarab mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Thabiu ne hingmuiithek pha iriingthek shii jog pha khriig rek ne ruiijong ro; iwoi wie awoi pha hingmuiithek ne zab chiieg ne bai shii fen muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Gu è nathek shii kho re-è khowo phi srane nathek ne layog khid rone doh yi, jishii gu idoh shii wuiiramuii pha bran ji re-è nathek shii Ragung So nane bai è khowo phi ruii phro. Ai ne gu re-è de boh ro; gu ne ai lakhiathek than sbo de asi ro. ");
INSERT INTO bgg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ai ne igam shii isug re-è yoyo rek pha dasai ne awai rog shii um ro, ai è awairo phiug shii awai haphuii hà khrab, jishii ai è isug shii ne khuchung de a-iy pha bai shii ziao ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jipha ishak shii Isu de ai re-è khowo yie pha Galili è thog srane Jordan hà Jon shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jishii Jon è ai khani lai yi pha bidiang. “Gu ne na re-è Khowo yie pha um habuii shii,” Jon è yao, “Chiih-è thuh nane gushii wuii ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jishii Isu è aishii yao, “Thuh shii hì è rey yi bo. Chiih-è hì duiine gethek ne Hamangkhung-aphuii è chiid pha ji zab rek mua.” Ji-è Jon è nuii. ");
INSERT INTO bgg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Khthiie Isu Khowo yieched ne, ai yi kho è fuang khia. Chiihphado hamangkhung ne aishii hongphi. Chiih-è ai è riig shii Hamangkhung-aphuii ro Ragung ne khu-atham duiine thazam khey ne ai lakhung shii jo. ");
INSERT INTO bgg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chiihphado gow yi hamangkhung re-è yao, “Hì ne guro bushun Dufuii ro, hanyie shii gu è nyu pha ji ro.” ");
INSERT INTO bgg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chiihphado Ibuii è chuajan yi pha Ragung è Isu shii balimuang hà noh dun. ");
INSERT INTO bgg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sawi Inaithek nane ibiuthek nyie de achie pha rai ne, Isu ne chi-iyiy dun. ");
INSERT INTO bgg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chiihphado Ibuii è aishii wuii srane yao, “Na Hamangkhung-aphuii pha Dufuii arone, hì pha lubao shii yung srane iweb rey yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jishii Isu è chang, “Jigigam shii yao, ‘Tharothamang ne iweb ji è asieng bie, jishii Hamangkhung-aphuii ro zab miyaothek pha miyaogam de chiid ro.’” ");
INSERT INTO bgg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chiihphado Ibuii è Isu shii So Rajan pha Jerusalem hà noh dun, aishii Misiahò pha zab è giu shii riu yi, ");
INSERT INTO bgg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","chiih-è aishii yao, “Na Hamangkhung-aphuii pha Dufuii arone, nawai shii buzam chiih mage bo,” Jigigam shii yao, Hamangkhung-aphuii è na chiang shii awai hamangkhliiethek shii yung ruii phro, ithek è nashii awaithek wadthek è khoh ruii phro, jiè naro laikham shii de lubaothek shii akham yi phro. ");
INSERT INTO bgg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isu è chang, “Jishii jigigam shii de yao, ‘Nawai Hamangkhung-aphuii Ithong shii achai rabo.’” ");
INSERT INTO bgg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chiihphado ibuii è Isu shii bajo giu phiing hà noh srane ithek ro bajobohthek nane sohjambling pha zab nuruiithek riig yi. ");
INSERT INTO bgg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ibuii è yao, “Na è gu shii lagiungniing ne misiasia arone.” “Zab hìthek gu na shii phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chiihphado Isu è chang, “Dun dun bo, Sakhathong! Jigigam shii yao, ‘Nawai Ithong, Hamangkhung-aphuii shii ilab rek ne misiasia bie bo!’” ");
INSERT INTO bgg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chiihphado ibuii è Isu shii thoh marui; chiih-è hamangkhliiethek wuii srane aishii nong phi. ");
INSERT INTO bgg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Isu è Jon ne phatheg hà chab muii rone yoi mage shii, ai Galili hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ai Nazareth hà arai, jimagunde, Zebulun nane Naphthali pha soh Galili khabang pha Khaphernaum thawun hà rai pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ji ne chaig Aijaya miyao marui pha ji izai rey yi pha rek ro: ");
INSERT INTO bgg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun pha soh nane Naphthali pha soh, khamuii pha lumuii hà, gai ithua pha Jordan pha, Gaibranthek pha soh, Galili! ");
INSERT INTO bgg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Igiia hà rai pha bran de bajoboh muchuang ji doh ruii phro. Hanyie yi iy pha igiia soh shii rai pho shii ne muchuang khilieng ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jipha ishak è Isu awai mua ji jao ne yua: “Nawaithek layog re-è khed bo, nyieliieshii hamangkhung pha Sajathua ne inui sha ro!” ");
INSERT INTO bgg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Isu è Galili pha khabang ring shii lua mage shii, ai è ù uapho khuiinothek nyi shii doh, Simon (Phithar rone ho) chiih-è ai ikhuii Andrew yi, chiug re-è ù zum ramuii. ");
INSERT INTO bgg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Isu è ithek shii yao, “Gu rog shii wuii bo, gu è nasa shii bran zum pha yua phi pha ro.” ");
INSERT INTO bgg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Khthiie isa de awai sa ro chiugthek thiichiih thoh marui srane ai idoh wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ai ji è wuii dun shii Zebedi ro dufuiithek Jems nane Jon khuiinothek nyi shii doh. Ai de run shii awaisa aphuii Zebedi rog shii chiugthek saro ne rai iang. Isu è ithek shii de ho, ");
INSERT INTO bgg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","chiih-è khthiie ithek de awaisa ro run nane aphuii shii thoh marui, chiih-è ai rog shii wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isu è zab pha Galili hà wuii ne, Jewish misiahòthek shii yua, Sajathua pha chiang re-è Mua Wie ji yao, ne hanyie shii miiriie nane radthek um pha bran shii gang rek phi. ");
INSERT INTO bgg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ji è rek phi pha airo muathek chiang ne Syria pha zab soh shii yoi dun. Ji-è hanyie radpho, zab pha miiriie è diigpho nane nyie arek muluii pho shii: Ibuiithek um pha bran; chiih-è lai khi-ègthek, chiih-è siugpho zab aishii nohthog, chiih-è ai è ithek shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galili re-è chiih-è thawunthek sua re-è, chiih-è Jerusalem, Juda, Jordan pha gai soh phothek de bajo ibrogthek de idoh luagieng. ");
INSERT INTO bgg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Isu è ibrogthek shii riig srane phiingduii hà wuii dun, thiisa hà ai ne dug dun. Ai samoythek ne aishii shan ne khrab dun, ");
INSERT INTO bgg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","chiih-è ai jao ne ithek shii yua: ");
INSERT INTO bgg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hanyie è ithek ne ragung shii dusho rone thieg pho ne sang ruii phro; hamangkhung pha Sajathua ne ithek ro rey ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Hanyie è duhug rek pho ne sang ro; Hamangkhung-aphuii è nathek shii ne ichad phi ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hanyie jum pho ne sang ruii phro; nathek shii ne Hamangkhung-aphuii è nyie sbang rek pha ji choi ruii phro! ");
INSERT INTO bgg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hanyie è Hamangkhung-aphuii è chiid pha zab re-è boh yang pha ji rek pho ne sang ruii phro; “Hamangkhung-aphuii è chodang pha ley phi ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Hanyie è gai shii bushun rek pho ne sang ruii phro; Hamangkhung-aphuii è nathek shii bushun rek ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Hanyie lubu igang um pho ne sang ruii phro; nathek ne Hamangkhung-aphuii shii doh ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Hanyie è liijiing pha blia rek pho ne sang ruii phro; Hamangkhung-aphuii è nathek shii de awai ani rone ho ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Hanyie è Hamangkhung-aphuii è nyie chiid pha ji rek pha chiang re-è diigkhui pho ne sang ruii phro; hamangkhung pha Sajathua ne nathek ro rey ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nathek hanyie shii bran è makhakriing ne nathek shii diigkhui phi chiih-è zab awie pha khlamthek shuang yao ruii mage shii nathek ne sang ro; nyieliieshii nathek ne guro samoythek ro.” ");
INSERT INTO bgg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ji-è sang ne lised bo, chiih-è bajoboh lasen ne hamangkhung hà nathek shii ruiijong phi ro. Ji duiine nathek è ibi sieng pha chaigthek shii de ithek è diigkhui rek. ");
INSERT INTO bgg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nathek ne zab tharothamang ro log pha suruii duiine ro; Jishii, suruii phieng ji shan dun arone, suruii phieng rab din pha lumuii ne oi sha ro. Ji ne blia adunmey pha rey ruii phro, ji è hì ne fen muii srane branthek è dia ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nathek ne zab pha sohjambling pha muchuang duiine ro. Phiingduii shii rung pha rajan ne a-ug mua. ");
INSERT INTO bgg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hanyie magunde muchuangthek pha ichuang ne sugong bucho shii aruii phro; ji pha chiang shii ai è ichuang shii ne bunthruak hà ruii ne, hanyie hò shii doh yi ne zab shii chuangphi ro. ");
INSERT INTO bgg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ji duiine nathek ro muchuang de branthek ibi shii chuang phi chid phro, jiè nathek ne nathek è rek pha wie bliathek riig srane hamangkhung hà nathek aphuii shii chiong ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gu ne Moses ro Iphey nane chaigthek ro muyuathek shii chui pha wuii rone anow rabo. Gu ne nathek rog shii chui pha awuii ro, jishii nathek muyuathek shii izai rey yi pha wuii ro. ");
INSERT INTO bgg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nowkhlei hamangkhung nane sohnyiak nya-um ba shii ne Iphey shii zab zey ne um pha igam ìu è ìu jia de chiih-è ji pha manathek ajong shii ne nathek rog shii ruang arek mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ji-è chiihphado, hanyie è ìu è ìu muyungthek anuii ji duiine gaithek shii yua pha anuii pha rek pho ne, hamangkhung pha Sajathua shii de zab è ìu rey dun phro. Chiih-è hanyie è Iphey ji nuii ne gai shii de ji duiine yua pho shii ne hamangkhung Sajathua shii boh rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gu nathek shii yao, chiihphado, ithek ne Iphey yua pha masdothek nane pharisithek è Hamangkhung-aphuii è nyie chiid pha ji rek phi pha ji re-è izai migi rek arone, hamangkhung pha Sajathua shii akhud mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nathek ne yoijong branthek è buyo yao pha ji ne, ‘Sgoh arek rabo, hanyie magunde ji rek pho shii ne chua ruii phro, limiang shii jong han chid phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jishii thuh gu è nathek shii yao: Nathek è nawaithek khuiino shii lijieg noh arone chai ruii phro, nathek è nawaithek khuiino shii adunmey ro è yao arone!’ Limiang moe hà noh ruii phro, chiih-è nathek è nawaithek khuiino shii gun-achid pha bran bi-ìe rone yao arone ithek shii de thumuluii pha bai hà dun pha buii ro. ");
INSERT INTO bgg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ji-è khuchung magunde nathek è Hamangkhung-aphuii sraibao shii lasen zid pha rek ramuii shii nathek ikhuii shii nyie shuang um bamuii rone nowkhlei arone, ");
INSERT INTO bgg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nawaithek ro lasen ji yi thiichiih sraibao ibi shii ruii srane, khthiie wuii ne nawaithek ikhuii rog shii liijiing rek bi rai bo, chiih-è chiihphado idoh wuii ne nathek ro lasen ji Hamangkhung-aphuii shii phi bo. ");
INSERT INTO bgg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yang ne nathek shii hanyie magunde na shuang rek ne limiang moe hà noh dun arone nawaithek rek mua pha ji rek srane chua bsa hà anow ba pha ibi shii lumuii hà nawaithek miyao ò rai pha rek bo. Ji asi shii ne ai è nathek shii chua pho hà noh srane, chiih-è chua pho è magashaig shii phi mua, chiih-è magashaig thek è phatheg hà chab mua. ");
INSERT INTO bgg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gu nathek shii yao, nathek è zab bang aphi sbo shii ne nathek ne sa phatheg hà raidun phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nathek de yoi hì ne yaojong, ‘Siulao arek rabo.’ ");
INSERT INTO bgg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jishii thuh gu nathek shii yao: Hanyie è hò-amuii shii awie pha riig srane bimi ji shii ong arone ai lubu iliing shii hò-amuii rog siulao rekjong ro. ");
INSERT INTO bgg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ji-è nathek phazoi pha mieg è nathek shii layog riig noh arone, khia srane fen muii bo! Naro siu zab shii thumuluii pha bai hà fen yi pha ji re-è ne siu pha ibam jia oidun pha ji wieliak phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nathek ro phazoi wad è nathek shii layog rek noh arone, laig srane fen muii bo! Nathek ro zab siu shii thumuluii hà dun yi pha rek pha ji re-è ne wad jia oi pha ji wieliak ba phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hì de yao jong, hanyiejia è awai yiy shii che shii bimi shii ne che pha siog zey ne phi bo. ");
INSERT INTO bgg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jishii gu è nathek shii yao: Gey è awai yiy shii che arone, bimi yi siulao pha nyie ichiig oi pha aishii che muii arone, chiih-è ji pha bimi è gai shii gey magunde siulao ne ai è rek yi ro; chiih-è bimi ji è hanyie shii gey ji pha bufuii de siulao rek ro. ");
INSERT INTO bgg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nathek de buyo pha branthek miyao marui ji yoi jong, ‘nawaithek sbang achui rabo, jishii nathek è Ithong shii rek phi pha nyie surua thak pha ji rek bo.’ ");
INSERT INTO bgg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jishii thuh gu è nathek shii yao: Nathek è sbang rek shii surua athak rabo. Hamangkhung pha de surua athak rabo, nyieliieshii jine Hamangkhung-aphuii ro biang ro; ");
INSERT INTO bgg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","sohnyiak pha de athak rabo, nyieliieshii ji pha sohnyiak de airo lai thung pha ithua ro; Jerusalem è de athak rabo, nyieliieshii ji de boh Saja ro rajan ro.” ");
INSERT INTO bgg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nawaithek khrug pha de surua athak rabo, nyieliieshii nathek ne nawaithek khaziang jia shii de imo dinne isei arab mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Oh arone oh rone yao bo, Asi arone asi rone yao bie bo—Hì è muna yao arone Awie Jia è thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nathek è hì yao pha ji ne yoijong, mieg chiang mieg yie bo, chiih-è shinyin chiang shinyin yie bo. ");
INSERT INTO bgg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jishii thuh gu nathek shii yao: “Hanyie magunde nashii ichiig rek noh pha ji shii idoh arog rabo. Hanyiejia è na phazoi pha mizia hà phey arone, aishii ne naro phawig pha mizia shii de phey yi bo. ");
INSERT INTO bgg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chiih-è hanyie è nathek phadiig shii riao pha limiang moe hà noh dun arone, nathek rugud de aishii nya riao yi bo. ");
INSERT INTO bgg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Hanyie è nathek shii ai miihan han ne labiang jia thog pha bangchiie lua yi pha noh dun arone, labiang nyi thog pha han phi bo. ");
INSERT INTO bgg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hanyiejia magunde nathek shii nyie magunde lia ruii arone, aishii ne phi muii bo; hanyiejia è nyie chui yang ne de, aishii chui phi bo. ");
INSERT INTO bgg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nathek ne yoi hì ne yaojong pha ji ne, ‘nawai ijakthek shii miie mage bo, nawaithek mak shii khiijai mage bo.’ ");
INSERT INTO bgg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jishii gu nathek shii yao: nawaithek ro shuangthek shii miie srane nathek shii hanyie è diigkhui pho shii sia bo, ");
INSERT INTO bgg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","jiè ne nathek ne hamangkhung pha Aphuii anithek rey mua ruii phro. Nyieliieshii ai è hasiang ne awie pha nane wie branthek shii chuang phi, chiih-è hanyie wie rek ne de hanyie è awie pha rek ne de haphie phi. ");
INSERT INTO bgg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nathek è nawaithek miie pha ji shii miie bie arone nyie rek ne Hamangkhung-aphuii è nathek shii lasen phi chid phlei? Muthan mijin thanpho rangde ji rek! ");
INSERT INTO bgg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chiih-è nathek ne nawaithek ijakthek shii yao bie arone nathek è nyie rek ge lei? Jine migi arek pho de ji rek. ");
INSERT INTO bgg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hamangkhung hà Aphuii ne zab shii khriig rek pha duiine—Nathek ne khriig rek bo. ");
INSERT INTO bgg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nowbthan bo, nathek è rek pha giang blia ne branthek shii doh yi pha hong ne arek rabo. Nathek ji è hong ne rek arone, hamangkhung hà Aphuii re-è nyie de lasen amua ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ji-è khuchung magunde nathek è dusho bran shii nyiemagunde phi mage shii, Lawasdaithek è misiasia pha hòthek nane lumuiithek shii rek pha duiine, doh yi pha arek chid rabo. Nathek ne jithek rek pha ji re-è branthek è nathek shii chiong yi pha ji rek ro.” Gu è nathek shii yao: Ithek ne awaithek è rek pha chiang ne lasen ley mua jong ro. ");
INSERT INTO bgg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Khuchung magunde nathek è dushothek shii nong phi arone, nathek ne nawaithek ijakthek shii de ji athieg yi rabo. ");
INSERT INTO bgg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chiihphado hì ne ug pha miyao ro. Chiih-è na è nyie ug ne rek pha ji ne na Aphuii, hanyie è riig srane lasen phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nathek è sia mage shii, lawasdaithek duiine asia rabo! Ithek ne misiasia pha hòthek nane lumuii pha iring hà riu ne sia pha ji ne miie, jiè zab ne nathek shii doh mua. Gu è nathek shii yao: ‘Ithek ne zab ley mua ro.’ ");
INSERT INTO bgg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jishii nathek è sia mage shii, nawaithek ùgud hà dun ne, habin bin muii bo, chiih-è nawaithek Aphuii shii sia mage bo, hanyie ne adoh ro. Chiih-è Aphuii hanyie ne nathek è ug ne nyie rek pha ji riig srane, nathek shii lasen phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nathek è sia mage shii, migi-arekpho è rek pha duiine, asi pha miyaogamthek ayao rabo, nyieliieshii ithek bajo phiang sia pha ji è ithek shii ne hamangkhung-aphuiithek è ithek misia yoi phi rone now ro. ");
INSERT INTO bgg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ithek duiine arek rabo. Nathek pha Aphuii è nathek nyie chiid pha ji è nathek è aishii alia ba pha ibi shii thiegjong ro. ");
INSERT INTO bgg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hì ne, chiihphado, Nathek khi-èrek ne sia chiid pha ji ro: <Hamangkhung pha gathek Aphuii: Naro ibeng So ne ilab rey bo; ");
INSERT INTO bgg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","naro Sajathua ne thog yi bo; hamangkhung hà um pha naro yang ji ne ichiih sohnyiak shii de rey yi bo. ");
INSERT INTO bgg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sudoh inai gathek chiid pha michie ji phi bo. ");
INSERT INTO bgg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gathek shii ithek è rek pha ichiigthek shii khungphi pha duiine, gathek è rek pha ichiigthek shii de khung phi bo. ");
INSERT INTO bgg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gathek shii buii achai yi rabo, chiih-è, gathek shii Awie Jia è ragia rek phi bo.> ");
INSERT INTO bgg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nathek è gai è nathek shii rek pha ichiigthek shii khung phi arone, hamangkhung hà um pha Aphuii de nathek shii de khung phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jishii nathek è gai shii akhung phi arone, nathek Aphuii de nathek ichiigthek shii de akhung phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Chiih-è nathek minyie nyie shii, lawasdaithek duiine nathek mizia shii duhug rek ne adoh yi rabo. Ithek ne ji è rek pha ji è branthek è nathek ne minyie nyie ramuii rone thieg yi pha ji rek ro. Gu è nathek shii izai yao, ithek ne awaithek è rek pha lasen ley muajong ro. ");
INSERT INTO bgg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Khuchung magunde nathek è minyie nyie pha wuii shii mieg mi ne khaziangthek chug ne wuii bo, ");
INSERT INTO bgg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","jiè gai branthek è nathek ne minyie nyie ramuii rone athieg phro—nathek Aphuii, hanyie ne adoh pha ji, ne thieg bie ro. Chiih-è nathek Aphuii, hanyie nathek ro ug ne rek pha ji riig ne nathek shii lasen phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Khi hà phu-ungthek nane thakhsem è chie pha nane riaopho è chuakbraig ne godun pha sohnyiak shii nawai bangnuruii khrab ne aruii rabo. ");
INSERT INTO bgg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ji pha chiang è ne nawai shii hamangkhung hà nuruii khrab mage bo, thiisa hà ne phu-ung nane thagsemthek de achie mua phro, chiih-è riaophothek de riao ne ayie mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nyieliieshii, nathek ro nuruii khi hà um pha ji hà nathek lubu de idang sha hà um ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mieg ne siu pha muchuang duiine ro. Nathek mieg wie arone, nathek siu shii de muchuang è ley ruii phro; ");
INSERT INTO bgg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jishii nathek ro mieg awie arone, nathek siuthek de igiia hà rey ruii phro. Ji-è, nathek shii muchuang um pha ji igiia arone, ji pha igiia um pha ji ne buii rey dun!” ");
INSERT INTO bgg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hanyie magunde ithong nyi ro khiao arey mua phro; ai ne jia shii ne khiijai chiih-è, gai shii miie; ai ne jia shii ilab rek ruii phro, jia shii ibid arek phro. Ji-è nathek de Hamangkhung-aphuii nane bang pha blia ne ò shii arek mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ji-è, hìthek ne gu è nathek shii yao pha ji ro; nathek è ichiih sieng ne rai shii nyie chie niing, dinne, nathek siu shii yung guii pha ji now ne samdiig arek chid rabo. Michie re-è ne sieng pha ji boh ba asi bey? Yung ji è de siu ji boh asi bey? ");
INSERT INTO bgg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Fuiithek shii riig mage bo: ithek è iriie de ahai, yamiing de achiig, iwoi de thazan hà akhrab jimagunde hamangkhung pha Aphuii è ithek shii phi ne gayiig rek ro! Nathek ne jithek pha fuii è de bajo boh branthek asi bey? ");
INSERT INTO bgg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nathek ji pha chiang shii samdiig ne ìujia phiang sieng ne rai mua bey? ");
INSERT INTO bgg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yung chiang è nyie rek ne samdiig phlei? Jabiing pha ibuathek sieng pha ji shii riig mage bo; ithek ne blia de arek, awaithek guii pha yungthek de arab ro. ");
INSERT INTO bgg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jishii, gu è nathek shii yao, Solomon Saja de awairo bajo nuruii um magunde ibuathek re-è jia duiine khie pha yungthek aguii mua ro. ");
INSERT INTO bgg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sudoh ichiih um pha saing ne, thimiang ne oi phro, ji ne bai shii fu ruii phro—Jipha jabiing pha saing shii ne Hamangkhung-aphuii è guii phi ro. Ji re-è de bajo wie nathek shii nyie rek ne aguii phi phlei? Nathek ro migi ìujia ro! ");
INSERT INTO bgg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ji-è guro michie ne khi è mua ruii phlei? Dinne guro niing pha khi re-è thog ruii phlei? Chiih-è nyie guii chid? Ji now ne samdiig arek chid rabo. ");
INSERT INTO bgg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Migi oi pho ne zab hì pha chiang è idang samdiig ro.) Naro hamangkhung pha Aphuii è nathek è hìthek pha manathek chiid pha ji ne thiegjong ro. ");
INSERT INTO bgg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hìthek now pha chiang shii ne Hamangkhung-aphuii pha Sajathua nane nathek è ai nyie chiid pha ji samdiig bo, ji è rek arone ai è gai zab manathek de phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ji-è, thimiang pha chiang now ne samdiig arek chiid rabo, thimiang pha samdiig ji ne thimiang hà awailum ne cho pha samdiigthek um ruii phro, inai jiajia pha diigthek ne um ro. Ichiih shii ne jijia inai pha samdiigthek yie ne achodo chid rabo. ");
INSERT INTO bgg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Gaithek shii achua rabo, jiè Hamangkhung-aphuii de nathek shii achua ruii phro, ");
INSERT INTO bgg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Hamangkhung-aphuii de nathek shii ithek è gai shii chua pha duiine chua ruii phro. Chiih-è, ai è nathek shii de ithek è khi pha Iphey yie ne chua pha duiine ji pha Iphey yie ne chua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chiihphado, nathek ne nyie rek ne nawaithek mieg shii hingbang um pha ji ariig pha nawaithek khuiithek pha mieg shii ididuii iphen um pha ji hìog ne yao phlei? ");
INSERT INTO bgg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nawaithek mieg rangde hingbang um shii khi-èrek ne nawai ikhuii ro iphen khia phi pha yao mua phlei? ");
INSERT INTO bgg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Lawasdai nathek! Igobi nawaithek mieg è hingbang ji khia bi bo, chiihphado nawaithek khuiithek ro iphen khia pha mieg sang doh mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nyie so um pha ji ne choi shii aphi rabo—Ithek è nathek shii idoh jo ruii phro. Mukho khie ne wak moe shii afen rabo—Ithek è ji pha mukho shii ne ithek lai lui hà dia ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lia bo, choi ruii phro, sow bo, nathek ne doh ruii phro, chokh bo, nathek shii habin hong ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nyieliieshii, hanyie è lia arone phi ruii phro, hanyie è sow arone doh ruii phro, hanyie è chokh arone aishii habin hong ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nawaithek dufuii è iweb lia shii lubao phi pha aphuii ne nathek duchoi hanyie um lei? ");
INSERT INTO bgg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Chiih-è, ai è ù lia shii nathek ne pham phi habey? ");
INSERT INTO bgg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Awie pha aphuii nathek ne nawaithek anithek shii wie phi pha ji shii thieg ro. Chiihphado ji re-è de hamangkhung hà Aphuii ne nathek è aishii lia pha wie manathek ji phi pha ji ne khama muna thieg ro! ");
INSERT INTO bgg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nathek è ithek shii khi-èrek yie pha now pha duiine ithek rog shii nathek è rek bo: Moses ro Iphey nane chaigthek muyua marui pha ji ne hì ro. ");
INSERT INTO bgg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Khog gak ji è iliing khud bo, nyieliieshii thumuluii pha gak ne sey ro chiih-è ji pha lumuii è dumuii rek pha ji ne ihiìa ro, chiih-è hanyie ji hà lua pho ne bajo ro. ");
INSERT INTO bgg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jishii chai pha gak ne khog ro, ji ne bajo diig hà dumuii re, chiih-è thiisa hà ne bran ìujia doh ro. ");
INSERT INTO bgg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Biidiie pha chaigthek re-è ragia rek iang bo, ithek ne fuang hà ne shiishai duiine mia ne nathek shii wuii ruii phro, Jishii izai bucho hà ne ithek ne shaliiethek duiine ro. ");
INSERT INTO bgg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nathek ne ithek è nyie rek pha ji è thieg ruii phro. Migem muiithek è angurthek awoi ruii phro, chiih-è migemgmuii è de hingiphemthek awoi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hingmuii phia ne iwoi wie woi ruii phro, jimagunde zia pha hingmuii ne wie awoi mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hing phia ne iwoi awie pha awoi ruii phro, chiih-è zia pha hingmuii ne iwoi wie awoi phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iwoi wie awoi pha zab hingmuii ne chiieg srane bai hà fen ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ji-è chiihphado nathek ne biidiie pha chaigthek è nyie rek pha ji è thieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Hanyie è gu shii Ithong, Ithong, rone ho pho zabjia ne hamangkhung pha Sajathua hà akhud mua ruii phro, jimagunde hanyie è hamangkhung hà Aphuii è ithek shii nyie rek bo è yang pha ji rek pho è khud bie ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chua pha Inai thog ruii shii, bajo è gu shii yao ruii phro, Ithong, Ithong! ‘Na ibeng è gathek de Hamangkhung-aphuii pha mua ji yao phi, na ibeng è gathek de ibuiithek shii khia ne bajo buangthek rek phi!’ ");
INSERT INTO bgg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chiihphado gu nathek shii yao ruii, ‘gu khuchung de nathek shii athieg, Nathek awie pha branthek, gu è dundun bo!’ ");
INSERT INTO bgg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ji-è chiihphado, hanyie è gu miyaogamthek yoi ne nuii pho ne khua bran hanyie è awai hò lubao lakhung shii rung pha ji duiine ro. ");
INSERT INTO bgg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Haphie phie mage ne, khobohthek lakhung shii khed mage ne, chiih-è hasam gidieg boh sam ne ji pha hò shii reng mage ro, jimagunde ji ne achuak ro, nyieliieshii ji ne lubao lakhung shii rung ro.” ");
INSERT INTO bgg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Jishii, hanyie è gu miyaogamthek ji yoi srane anuii pho ne bi-ìe hanyie è awai hò balimuang shii rung pha ji duiine ro. ");
INSERT INTO bgg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Haphie phie ne khoboh khed mage ne, ji pha hò shii hasam gidieg boh sam ne ji pha hò reng mage shii, chiih-è chuakdun. Chiih-è ji ne buii è chuakdun ro!” ");
INSERT INTO bgg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Isu è jithek yao ched dang shii, ibrog ne ai miyao ji è wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ai ne Iphey yua pha masdothek duiine asi ro, ji phachiang shii, riichai rog shii yua dun ro. ");
INSERT INTO bgg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Isu yi phiingduii è thazam dun thog shii, bajo ibrogthek ai rog shii luagieng. ");
INSERT INTO bgg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chiihphado hìa è riie pha ji aishii wuii ne, lagiung niing srane yao, “Masdo! Na è rek pha yang arone, gu shii so nyarab mua phi phro.” ");
INSERT INTO bgg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isu è awai wad phia srane aishii khoh. “Gu è rek phi pha yang muii ro” Ai è yao! “So rey bo!” Khthiie ji pha bran ne gang dun. ");
INSERT INTO bgg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chiihphado Isu aishii yao, “Yoi bo! Hanyie shii de ayao rabo, jimagunde miang phabi hà wuii srane aishii riig yi bo, chiihphado na wie rey ge rone zab shii khagi rek ne, Moses muyung pha khlem ji zid phi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Isu è Khaphernaum hà khud mage shii, Roman pha dumuii jia è aishii si srane nong phi pha khung ne yao: ");
INSERT INTO bgg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Masdo, guro khiao rad ne hò hà biang shii thieng ne, asid mua dang pha bajo diig muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Gu ne aishii wuii srane gang phi ruii phro,” Isu è yao. ");
INSERT INTO bgg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Oh asi masdo! Jipha dumuii è Isu shii chang, yung bie bo, gu nashii gu hò hà wuii yi sbo de asi ro, chiih-è gu khiao ne wie rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Gu è lakhung shii de boh dumuii riichai um ro, chiih-è gu bucho shii siphahithek um ro. Gu è hanyie shii yung wuii bo! Chiih-è wuii; chiih-è, hanyie jia shii thawuii! Bo è yung chiih-è ai thawuii, chiih-è gu è gui khiao shii yung, hì rek bo! Chiih-è ai rek phi.” ");
INSERT INTO bgg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Isu è ji yoi mage shii, ai ne anomuluii pha rey ne ai rog shii luagieng pha branthek shii yao. Gu è nathek shii yao, gu è Israel hà hì duii pha migi adoh ba ro. ");
INSERT INTO bgg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gu è izai yao, bajo thek ne bichiu nane hakhoi è wuii srane Abraham, Isakh nane Jackhob rog shii hamangkhung pha Sajathua pha michie shii dug ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jishii, hanyie nathek ne Sajathua hà um pho shii ne igiia hà fen ruii phro, thiisa hà ithek ne shiinyinthek khriieg ne cho ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chiihphado Isu è dumuii shii yao. “Hò dun sha bo, chiih-è na è nyie migi rek pha ji ne nashii rek ruii phro.” Chiih-è ji pha ishak shii dumuii ro khiao ne gang dun. ");
INSERT INTO bgg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Isu è Phithar hò hà wuii dun, chiih-è thiisa hà ai è Phithar ro khiing ne hakhangzia ne rad ne rai iang pha doh. ");
INSERT INTO bgg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ai è ai wad kho, ji pha hakhang zia pha ji ne thoh dun, chiih-è sieng srane chie niing. ");
INSERT INTO bgg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Habjuang rey mage shii, branthek è hanyie shii ibuiithek um pha ithek bajo shii Isu hà noh ne wuii thog, Isu è awie pha ragungthek shii miyaogam rog shii khia ne hanyie radpho shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ai ji rek pha ji è Aijaya chaig è yao marui pha ji ne izai rey yi, “Ai ne gethek ro radthek shii awai yi ne miiriiethek han phi.” ");
INSERT INTO bgg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Isu è ibrog ne aishii shan dun pha ji doh mage shii, ai è awai samoythek shii khabang pha yoyo ithua hà dun bo è yung. ");
INSERT INTO bgg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Iphey yua pha masdo aishii wuii thog. “Masdo” Ai è yao, “Na khi hà wuii magunde gune narog wuii pha ideb ro.” ");
INSERT INTO bgg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isu è aishii yao, “Shaliiethek shii ne ichothek um, chiih-è fuiithek shii ne irung um, jimagunde, Bran Dufuii shii ne thieng ne thung pha ithua de oi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Gaibran, hanyie yi samoy ro, ai è yao “Masdo, igobi gu shii gui aphuii shii wieng pha dun yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Gu rog shii luagieng bo,” Isu è chang, “chiih-è awaithek iy-iy è awai iy pha ji shii wieng yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Isu run shii in dun, chiih-è awai samoythek rog shii wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Humblo shii hasam boh sam ne khabang shii reng mage, chiih-è run ne buii è zem sha pha rey dun, jimagunde Isu men dun. ");
INSERT INTO bgg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Samoythek è aishii wuii srane aishii chun. “Ithong wo gathek shii ragia rek phi bo!” Ithek è yao. “Gathek ne iy sha bsa ro!” ");
INSERT INTO bgg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Nathek ne nyama nyie rek ne rum phlei? Isu è chang, nathek shii ne migi ìujia bie ara ro!” Chiihphado ai sieng srane ji pha hasamthek nane gasauthek shii yung ne them yi. Chiih-è thiisa hà ne boh them dun. ");
INSERT INTO bgg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Zab ne wiengphleg dun. “Hì ne khi-èrek pha bran ga?” Ithek è yao. “Hasamthek nane gasauthek rangde ai miyao nuii dun ro!” ");
INSERT INTO bgg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Isu è khabang khlei pha ithua Gadara soh hà wuii thog mage shii, bran nyi ne wiengmuang è wuii ruii pha ai è si iang. Jipha branthek ne ibuiithek um srane bajo buii ro jiè hanyie de ji pha lumuii hà lua pha chua oi. ");
INSERT INTO bgg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Khthiie ithek è ziak, “Gathek rog shii na nyie yang lei? Hamangkhung-aphuii pha Dufuii! Na ne gathek shii khriig pha ishak ibi hà lago phi pha wuii ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Thiichiih è muna ruang asi pha ji shii wak brog ram ne um. ");
INSERT INTO bgg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ji-è, ji pha ibuiithek Isu shii khung ne yao, “Na è gathek shii khia pha rek arone, gathek shii ji pha wak brog hà thoh ge bo!” ");
INSERT INTO bgg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Dun bo” Isu è ithek shii yao; jiè ithek thoh srane wakthek hà dun dun. Zab ibrog ne sak miang hà ran srane khabang shii wo ne zem dun. ");
INSERT INTO bgg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wakthek gayiig pha bran ji è ran srane thawun hà wuii dun, ibuiithek rog pha branthek shii nyie rek phi zab phaluii yao mage. ");
INSERT INTO bgg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ji-è, ji pha thawun pha branthek Isu shii si pha wuii dun; chiih-è ithek è aishii doh mage shii, ithek soh shii thoh ne dun bo ne khung ne yao. ");
INSERT INTO bgg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Isu run shii in srane khabang pha thrang awairo thawun hà idoh dundun, ");
INSERT INTO bgg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Thiisa hà giak bran è slemriie pha bran jia shii awai biang rog shii thieng ne noh thog. Isu è ithek ro migi um pha ji riig mage shii, ai è slemriie pha bran ji shii yao, “lububo rek bo, gu dufuii! Na layogthek ne khungjong phi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chiihphado Iphey yua pha masdothek è awaithek chung yao rai, “Hì pha bran ne makhakriing yao ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Isu ne ithek munow rai pha ji thieg, jiè ai yao, nathek ne nyie rek ne awie pha thek now phlei? ");
INSERT INTO bgg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Naro layogthek ne khung jong phi ro è yao pha ji wie ba asi jai ne lua mage bo è yao pha ji wie bey? ");
INSERT INTO bgg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gu nathek shii khagi rek, chiihphado, ji pha Bran Dufuii shii ne ichiih sohnyiak shii layog khung phi pha riichai um ro. Ji-è ai è slemriie pha bran shii yao, jai ne, nawai lawio chiing ne, chiih-è hò dun bo! ");
INSERT INTO bgg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jipha bran jai fad srane awai hò hà dun dun. ");
INSERT INTO bgg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bran è ji doh mage shii, ithek ne zab rum dun, chiih-è bran shii de riichai phi pha chiang è Hamangkhung-aphuii shii chiong bo. ");
INSERT INTO bgg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Isu è ji pha ithua thoh marui ne ai ibi lua shii, Methiu, beng pha mijin than pha ji awai ophis shii dug ne rai iang pha doh, ai è aishii yao “Gu idoh shii luagieng bo.” Methiu jai fad srane ai idoh luagieng. ");
INSERT INTO bgg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Isu è Methiu hò hà michie chie ramuii shii, gai mijin thanphothek nane ìu riingthek de wuii thog srane Isu nane ai samoythek rog shii thiibliie hà dug gieng. ");
INSERT INTO bgg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Giak Pharisithek è ji riig srane ai samoythek shii sai, Nyie rek ne masdo ne hì è rek pha branthek rog shii chiegieng phlei? ");
INSERT INTO bgg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Isu è ithek shii yoi srane chang, “Branthek hanyie gang pho ne mapho achid phro, chiih-è radpho è chiid bie phro. ");
INSERT INTO bgg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dun srane jigigam shii nyie yao pha miyaosiu shii ji sow bo: Gu ne bushun chid phro, miiram ua ne khlem pha ji ne achid ro! Gu ne ilab rek pha bran shii ho pha awuii ro, jishii ìu riingthek shii ho pha wuii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chiihphado Jon khowo ro samoythek Isu shii wuii thog, ne sai, “Gathek nane Pharisithek ne idang minyie nyie” Jishii naro samoythek khuchung de minyie anyie ji ne nyie lei? ");
INSERT INTO bgg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isu è chang, phiyiy shii wuii pha biwenthek yi phiyiybufuii ithek rog um ba shii ne duhug rek phrone luthong bey? Khuchungde asi phro! Jishii phiyiybufuiii ithek noh dun pha inai thog ruii phro, chiihphado ithek minyie nyie ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hanyie è de rugud hèg shii yung iwo ithileg miak ne aphiug ruii phro, nyieliieshii, yung thilek iwo ji è re srane rugud ne lahuhuak icho rey dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dinne Hanyie è de phuii nyiu shii chabjong pha phuii sukhug shii achab phro, nyieliieshii ji pha sukhug pha biia ne chuidun phro, chiih-è phuii ne noidun chiih-è phuii sukhug ne awie pha reydun phro. “Jipha chiang shii phuii nyiu shii ne phuii sukhug iwo hà chab chiid phro.” Chiih-è isa ne wie ruiidun phro. ");
INSERT INTO bgg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Isu è ji yao ramuii shii, Jewish pha dumuii è aishii wuii thog ne lagiungniing, srane yao, “Gu ro dimi ne iyjong dun ro, Jishii, thawuii srane nawai wad è aishii khoh mage bo chiih-è ai ne sieng ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ji-è Isu jai srane ai idoh luagieng, chiih-è airo samoythek de ai rog shii wuii gieng. ");
INSERT INTO bgg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Idam snanyi è diig rek ne grab noi ne riie pha hò-amuii jia è idoh wuii srane Isu yung jiu shii khoh mage. ");
INSERT INTO bgg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ai è awai shii yao, “Gu è airo yung shii khoh bie nede, gu ne gang rey dun phro.” ");
INSERT INTO bgg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isu è idoh rai ne hò-amuii shii riig, srane yao, lububo rek bo, “Gu dimi wo! Naro migi ji è nawai shii wie rek ge ro.” “Ji è yao pha ishak shii hò-amuii ji ne wie rey dun.” ");
INSERT INTO bgg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chiihphado Isu ne dumuii hò hà wuii dun. Iy pha ben khuang pho nane branthek choh ne rai iang pha doh mage shii, ");
INSERT INTO bgg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ai è yao, zab ne fuang dun mage bo! “Bimi ne a-iy ba ro—Ai ne men bie ro!” Chiihphado ithek zab aishii siak. ");
INSERT INTO bgg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Khthiie dang shii branthek fuang dun ched mage shii Isu è bimi ji pha ùgud hà wuii srane bimi ji pha wad shii chaing mage, chiih-è bimi ji de sieng khlei ruii. ");
INSERT INTO bgg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mua ji ne zab pha soh shii yoi thogdun. ");
INSERT INTO bgg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Isu è ji pha ithua thoh marui, chiih-è ai luaramuii shii miegthi pha bran nyi è jao ne ai idoh luagieng, “Gasa shii bushun rek phi bo, Dawid pha dufuii wo!” Ithek è ziak. ");
INSERT INTO bgg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Isu è hò bucho khud mage shii, miegthi pha bran nyi aishii wuii thog, chiih-è ai è ithek shii sai, “Gu è nasa shii gang rek ruii phrone nasa migi rek ne bey?” “Oh masdo” Isa è chang. ");
INSERT INTO bgg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","“Chiihphado Isu ne ithek mieg shii khoh srane yao, nasa è migi rek pha ji è hì è rey mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chiih-è ithek ro mieg ne dinne wie rey ge. “Isu è isa shii gang è yao, ji ne hanyie shii ayao rabo.” ");
INSERT INTO bgg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jishii ithek ne dun srane Isu chiang pha mua ne zab soh hà yao phi. ");
INSERT INTO bgg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Branthek dun dun shii, giak bran è Isu hà hanyie miyao ayao mua pha bran noh thog ruii, nyieliieshii aishii ibuii um. ");
INSERT INTO bgg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jishii, khthiie dang shii ibuii fuang khia mage ne, bran ji ne jao ne yao, zab pha branthek ne wieng dun, “Gathek è hì duiine rek pha blia ne Israel hà de khuchung de adoh ba ro!” ziak ne yao. ");
INSERT INTO bgg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jishii Pharisithek è chang, “Hì ne ibuiithek shii gieng pha sakhathong è Isu shii blu phi ara ro.” ");
INSERT INTO bgg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Isu è thawunthek nane thiigthek hà shan ne lua. Ai è Jewthek misiahòthek shii wuii ne yua, Sajathua chiang pha Mua Wie ji yua, chiih-è, miiriie nane radthek pha branthek shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ai ibrog ji doh mage shii, ai lubu hà ithek shii bushun now dun, nyieliieshii, ithek ne samdiig nane nong-oi pha rey dun. Brogpho oi pha shiishai duiine rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ji-è ai è ne awai samoythek shii yao, “Yamiing ne bajo um habuii shii, raig riug pho ne ìujia bie ro.” ");
INSERT INTO bgg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ji è yamiing pha blia pho shii thoh ruii pha. “Yamiing pha muspho shii sia mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Isu è awai samoy snanyi shii ò ho srane ibuii ragungthek khia pha nane ichua miiriie nane radthek shii gang phi pha riichai phi. ");
INSERT INTO bgg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hì ne guaphasamoythek snanyi pha ibeng ro: igobi Simon (Phithar ro è ho), chiih-è ai ikhuii Andrew; Zebedi pha dufuii Jems nane ai ikhuii Jon; ");
INSERT INTO bgg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philiph nane Bartholomew; Thomas nane mijin thanpha Methiu; Alphayus pha dufuii Jems nane Thadaeus; ");
INSERT INTO bgg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Soh shii miie pha Simon nane Isu shii zum yi pha Judas Iskharioth ithek ro. ");
INSERT INTO bgg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isu è ji pha samoy snanyi shii miyao yua ne fuang thoh ge: Gai bran pha soh shii nane Samaria thawunthek shii awuii rabo. ");
INSERT INTO bgg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jiphachiang shii, nathek ne Israel pha bran, ro shiishai san dun pha thiig shii wuii bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wuii srane yua bo, hamangkhung pha Sajathua ne inui sha ro! ");
INSERT INTO bgg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Radpho shii gang phi bo, iypho shii chai hà yi bo, hìariie è radpho shii gang phi bo, chiih-è, ibuiithek shii khia phi bo. Nathek è igong aphi pha mua, jiè nathek ne gai shii igong ayie pha phi muii bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nathek ne san liiman nane thama pha bangthek ahan rabo. ");
INSERT INTO bgg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lumuii hà lua shii chayem pha biia de ayie rabo, chiih-è, lai ne gua pha phadiig nane lakhiathek nane thagin de ahan rabo. Bliaphothek è nyie chiid pha ji shii ne phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nathek è thawun nane thiig hà wuii mage shii, nathek shii wie ho pha yang pho shii sow bo. Chiih-è, nathek è ji pha ithua adung sapho shii ne ai rog shii rai bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Khuchung, nathek è hò iliing hà wuii shii, yao bo, liijiing ne nathek rog shii um bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jipha hò bran è nathek shii wie ho arone, nathek pha liijiing nane salamthek ne rai yi bo; chiih-è, ithek è nathek shii wie aho arone, chiihphado nawaithek ro salamthek ji idoh yi bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chiih-è, giak hò hà nane thawun hà nathek shii wie aho arone, chiihphado ji pha ithua thoh srane nawaithek laikham pha nyiakphlab kham ne thoh marui bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gu è nathek shii izai yao, Chua pha inai shii Hamangkhung-aphuii è ji pha thiigthek è ne Sodom nane Gomorah pha branthek shii lamuna bushun rek ruii phro! ");
INSERT INTO bgg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yoi bo! Gu è nathek shii shiishai duiine choishaluii um pha duchoi shii thoh ramuii ro. Nathek ne pham duiine briak rek ne, pharo duiine zum rek bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Riig bthan bo. Hanyie è nathek shii zum ne limiang moe hà noh dun ne chiih-è nathek shii ne misiahòthek hà chia ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gu chiang è nathek shii chua pha bohkhohphothek nane sajathek moe noh ruii phro, chiih-è Mua Wie ji nathek shii nane gai bran shii yao bo. ");
INSERT INTO bgg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Khuchung ithek è nathek shii noh ne chuajan noh shii, na khi-èrek ne yao chiih-è nyie yao chid pha ji shii samdiig arek chid rabo; ishak thog mage shii, nathek nyie yao pha ji ne phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nathek è nyie yao pha miyaogamthek jine nathek re-è asi phro; jithek ne Aphuii pha ragung è nathek è yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Branthek awaithek khuiino shii ua muii pha ithek shii phi muii phro chiih-è Aphuii è awaithek aniphiing shii duiine rek phro, Aniphiing de awaithek pha Aphuii-amuii shii gidieg rek ne iy yi pha phi muii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Zab è nathek shii gu chiang è khiijai ruii phro, Jishii, hanyie è iidohhè thog pha kho pho ne ragia rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ithek shii thawun jia hà diigkhui ruii shii, gai hà yo marui bo. Gu è nathek shii izai yang dang. “Bran dufuii awuii sapho shii ne Israel pha zab thawun blia ne ajong ba phro.” ");
INSERT INTO bgg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Samoy ne awai masdo è boh asi ro; khiao ne awai Ithong è boh asi ro. ");
INSERT INTO bgg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ji-è, samoy ne Masdo duiine rek pha ji ne chodang pha rek bo, khiao de awai Ithong duiine rek bo. Haliingpha khrug shii Ibuii rone ho arone, ji pha haliingpho branthek shii bajo buii ibeng ho phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ji-è branthek shii arumchid rabo. Thuh shii nyie kheb pha ji ne hong ruii phro, chiih-è ug pha ji ne thieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gu è igiia shii nyie yao pha ji ne inai shii yao din bo, chiih-è nathek è nyie ug ne yoi pha ji hòthek lakhung è yao dun. ");
INSERT INTO bgg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hanyie è siu shii ua ne jimagunde ragung shii a-ua mua pho shii arum rabo; ji pha chiang shii, Hamangkhung-aphuii shii rum bo, hanyie ne siu nane ragung shii thumuluii hà mua maphi phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nathek sikhi jia è fuiishiiraithek nyi nyapheg mua phro, thuh de Jishii, Aphuii è achid sapho ne ji pha fuiishiirai jia de nyiak shii achiih mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nathek shii de, ji duiine nathek khrug shii um pha khaziangthek de zab tham ne ruiijong ro. ");
INSERT INTO bgg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ji-è, arum chid rabo; nathek ne ji pha fuiishiiraithek è de bajo igong pha branthek ro!” ");
INSERT INTO bgg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hanyie è ithek ne gu è rey phrone hong yao arone, hamangkhung pha Aphuii moe shii gu è ji duiine rek phi pha ro. ");
INSERT INTO bgg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jishii, hanyie gu shii hong ne snai arone, aishii de gu hamangkhung pha Aphuii moe shii snai ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Gu è ichiih sohjambling shii liijiing yie ne wuii pha ji anow rabo. Asi, gu ne liijiing yie ne wuii pha asi ro, jishii khamriie yi ne wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gu ne dufuii è aphuii shii mak rek yi pha ji rab wuii phro, dimi è amuii shii mak rek yi, shami è khiing shii mak rek yi pha ji rab pha wuii. ");
INSERT INTO bgg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Naro bajo awie pha mak ne nawai haliing è rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Hanyie gu shii è de muna awaithek aphuii dinne amuii shii miie pho ne” Guro samoythek rek pha adunmey phro; hanyie è awaithek dufuii dimi shii gu è de muna miie pho ne guro samoythek rek pha adunmey phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hanyie è awai bai ji han ne gu idoh aluagieng pho ne guro samoythek rek pha adunmey phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hanyie è awai siu sieng pha ragia rek arone, mua ruii phro; Jishii hanyie gu chiang è awai chai shii mua muii arone mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Hanyie è nathek shii wie ho ai ne gu shii de wie ho ruii ro, chiih-è hanyie gu shii wie ho pho ne gu shii thoh ge pha ji shii wie ho ro. ");
INSERT INTO bgg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hanyie è Hamangkhung-aphuii pha muapho shii wie ho, nyieliieshii ai ne Hamangkhung-aphuii pha muapho ro, nathek shii mua pha lasen ne aishii de mua ruii phro. Chiih-è hanyie è bran wie shii wieho nyieliieshii ai de wie, aishii de ithek lasen ji mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nathek de hì izai thieg mage bo, nyieliieshii ai ne guro samoy rone hanyie è guro ìu samoythek jia shii de kho choi phi ne niing yi, hamblo shii lasen mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Isu è awai samoythek snanyi shii jithek yua ched mage shii, ai ji pha ithua thoh ne thiichiih inui pha thawun shii yua ne yao pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon khowo pha phatheg hà Isu è rek ramuii pha jithek yoi mage shii, ai è gai samoythek aishii thoh ge, ");
INSERT INTO bgg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Gathek shii yao bo, ithek è Isu shii sai, na ne Jon è yao pha jia wuii ruii phro è yao marui pha ji bey? Din ne gathek ne gai wuii ruii pha ji shii khan habey?” ");
INSERT INTO bgg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isu è chang, “Idoh dun srane nathek è nyie yoi nyie doh pha ji Jon shii yao phi bo: ");
INSERT INTO bgg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Miegthi de mieg doh mua ro; laikhi-èg de lua mua ro; hanyie thek hìa miiriiethek è diig rek ne radpho shii de sang rab ge ro; khohphang de yoi dun ro, chiih-è iypho de chai hà yi din phiro; chiih-è, Mua wie ne dusho pho shii de yua dun ro. ");
INSERT INTO bgg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hanyie è gu shii izai now pho ne khama sang pha um phro!” ");
INSERT INTO bgg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon ro samoythek è thoh ne dun dun shii, Isu è ibrog shii ai chiang yao: “Nathek è balimuang hà Jon shii wuii dun shii, nathek nyie riig pha luthong phlei?” Hasam shii saing irab mia pha ji riig wuii ne bey? ");
INSERT INTO bgg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nathek ne nyie riig pha wuii dun phlei? Bran yi yungthek ichia guii pha ji riig wuii ne bey? Bran hanyie ne ji duiine guii pho ne boh hòthek hà rai phro! ");
INSERT INTO bgg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Gu shii yao riig bo, nathek nyie riig pha wuii dun phlei? Chaig shii bey? Ji ne izai ro, Jishii nathek è chaig è de boh shii doh marui. ");
INSERT INTO bgg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon ne jigigam shii yao marui pha jia ji ro; Hamangkhung-aphuii è yao: “Gune gui muapho nathek ibi hà thoh srane nathek lumuii rab iang yi; ");
INSERT INTO bgg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","gu nathek shii yao Jon ne hanyie è idang sieng ne rai pho è de boh ba ro. Jishii hanyie yi hamangkhung pha Sajathua shii ìujia um nede ai ne Jon è boh ba ro. ");
INSERT INTO bgg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon è awai mua yua pha ishak è yie dang ne sudoh thog dang pha hamangkhung pha Sajathua ne bajo diig è mak jo muii ro. Chiih-è bangchiie pha bran è zum pha bidiang mua ro.” ");
INSERT INTO bgg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jon pha ishak è chiih-è zab pha chaigthek nane Iphey yua pha masdo è yie dang ne Sajathua chiang shii yaojong ro; ");
INSERT INTO bgg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jishii, nathek è ithek mua ji yoi yang arone, Jon ne Elija ro, hanyie wuii ruii pha ji shii ne chaigjong ro. ");
INSERT INTO bgg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nathek shii khohthek um arone, chiihphado, yoi mage bo! ");
INSERT INTO bgg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Thuh, gu ne duchung pha branthek shii khi-èrek ò pha lei?” Ithek ne aniphiing duiine bajarai hà dug ne rai muii ro. Ibrog jia è gai shii ziak, ");
INSERT INTO bgg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Gathek è phiyiy thiibiing boi shii, nathek è asiu phi! Gathek è phiyiy ibai bai habuii shii, jimagunde nathek è achoh phi ro!> ");
INSERT INTO bgg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon wuii thog shii, ai è minyie nyie ne phuii de aniing, chiih-è zab yao, aishii ne ibuii um ro, ");
INSERT INTO bgg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jishii, Bran dufuii wuii thog shii ai ne chie ne niing, chiih-è yao, hì pha bran shii Riig mage bo! Ai ne sgow ne niingpho ro, mijin thanphothek nane iriing ìu pho thek pha ijak ro! “Hamangkhung-aphuii khani ne blia è izai chak rone doh yi.” ");
INSERT INTO bgg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Isu è thawunthek pha branthek shii awairo bajo buangthek rek phi shii ithek ne awaithek layog è akhid phi ne, jiè Isu è ji pha thawunpho shii giung: ");
INSERT INTO bgg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Chorijin! Nathek shii khama diig ro, nathek khama diig ro, Bethsaida! Buangthek yi nathek shii rek phi pha ji ne Thaire nane Sidon shii rek phi arone, branthek ne khuchung è de awaithek layogthek è thadoh khidjong rone doh yi pha thiilo guii ne siphie shun ne raijong ro! ");
INSERT INTO bgg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gu nathek shii yao chua pha inai shii Hamangkhung-aphuii è bushun yi nathek è muna ne Thaire nane Sidon shii doh yi phro. ");
INSERT INTO bgg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Chiih-è nathek shii, Khaphernaum! Nathek ne nawaithek shii hamangkhung hà chiing pha yang muii bey? Nathek shii ne buzam Thumluii hà fen ruii phro! Buangthek ne Sodom hà rek phi arone, sudoh thog pha idang now ne rai dun iwa! ");
INSERT INTO bgg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nathek è ìd mua chua pha inai shii ne Hamangkhung-aphuii è ithek shii ne “Sodom pho shii muna bushun rek ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jipha ishak shii Isu è yao, “Aphuii, hamangkhung nane sohnyiak pha Ithong! Gu Nashii laso phi, nyieliieshii na è khua pho è ug ne ruii pha ji a-ìd pho shii doh yi. ");
INSERT INTO bgg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ji chak, Aphuii! Hì ne na è yang pha ji rey yi ro. ");
INSERT INTO bgg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Gu Aphuii è gu shii zab manathek phi jong ro. Hanyie è dufuii shii athieg ro, Aphuii jijia è thieg bie ro, chiih-è hanyie de Aphuii shii athieg ro, dufuii ne thieg hanyie è dong yi pha gua ne ruii pha ji è thieg bie ro. ");
INSERT INTO bgg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gu shii wuii bo, hanyie zab yi miihanthek ley han ne jid dun pho, nane gu shii wuii mage bo! Gu è nathek shii thung phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Guro jakhokh ji yi ne nawai lakhung shii ruii bo chiih-è gu è nui bo, nyieliieshii gu ragung shii neb nane jum; chiih-è nathek de thung pha mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gu è nathek shii phi ruii pha jakhokh ne wie bie ro, gu miihan phi pha ji ne thoh bie ro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ìujia ishak idoh shii, Isu è Jewthek Thung pha inai shii phiug raig è dong ne lua ramuii. Ai ro samoythek ne chi-iy, jiè ithek ne phiug nyiu ji jao ne chiig ne igam ji chie. ");
INSERT INTO bgg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pharisithek è ji doh ne Isu shii yao, “Riig mage bo, na samoythek è Thung pha Inai hì è rek pha ji è gethek Iphey shii gidieg rek muii ro!” ");
INSERT INTO bgg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Isu è ithek shii yao din, “Nathek de Dawid nane ai branthek è chi-iyiy shii nyie rek pha jigigam ji ne atham riig bey? ");
INSERT INTO bgg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawid nane ai branthek ne Hamangkhung-aphuii hò bucho shii wuii srane Hamangkhung-aphuii ro hò shii zid pha iwebthek chie pha phi. Ji ne Iphey shii gidieg ro, nyieliieshii, ji pha iweb ne phabithek chie mua bie ro. ");
INSERT INTO bgg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chiih-è, zab Thung pha inai shii phabithek è Misiahò hà wuii srane Thung pha inai Iphey ji chui maphi nede ithek shii ichiig aphi rone nathek ne Moses ro Iphey ji atham bey. ");
INSERT INTO bgg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gu è nathek shii yao, Misiahò hì è de boh jia ichiih nyiemagunde um ba ro. ");
INSERT INTO bgg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jigigam shii zey ne um ro, ‘miiram khlemthek pha ji asi jishii gu ne bushun ji chiid ro, nathek è hì pha miyao ne nyie yao phlei ne wie gua dun arone’ nathek de hanyie ichiig oi pha branthek shii anin iwa; ");
INSERT INTO bgg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","nyieliieshii, bran dufuii hì ne Thung pha inai pha Ithong de ro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Isu è ji pha ithua thoh marui ne Jewthek misiahò hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Thiichiih shii wad shii slemriie pha bran jia um iang. Giak branthek ne Isu awai mirek pha ichiig nin pha branthek khan ne um. Ji-è, ithek ne Isu shii sai, “Thung pha inai shii gang phi pha ji ne Iphey pha shuang asi bey?” ");
INSERT INTO bgg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Isu è ithek shii yao din, “Nathek de Thung pha inai shii nawaithek shiishai jia yi nyahiung hà chiihdun arone, ji pha shiishai shii khoh ne fuang akhia phi ne bey? ");
INSERT INTO bgg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ji-è, bran ne shiishai ji è de bajo boh ro! Gethek Iphey ne Thung pha Inai shii branthek shii nyanong mua.” ");
INSERT INTO bgg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ji è yao ched dang Isu è wad slemriie riie pha bran ji shii yao, “Na wad phiang phia mage bo.” Ai è de wad phia mage shii ji pha slemriie pha ji ne gai pha wad duiine wie rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ji è rek pha doh mage ne Pharisithek ne dun dun chiih-è Isu shii ua pha phak rai. ");
INSERT INTO bgg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Isu è khinrin ne aishii gidieg rek pha ji yoi mage shii, ji pha ithua thoh ne dun dun; chiih-è bran ibrogthek de ai idoh luagieng. Ai è zab radthek shii gang phi srane ");
INSERT INTO bgg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","gaithek shii ai chiang ji ayao rabo ne yung. ");
INSERT INTO bgg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ai è jithek rek phi pha ji è Hamangkhung-aphuii è Aijaya chaig è yao marui pha miyao ji izai rey yi pha ji rek ro: ");
INSERT INTO bgg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ichiih hì ne gu mugua ne ruii pha khiao ji ro, hanyie shii gu ne bajo bushun rek ne bajo nyu pha ji ro. Gu ne gui ragung ai lakhung shii phi, chiih-è ai ne Sohthek shii guro chua miyao yao phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ai ne akhiinaing noh chiih-è, aziak noh phro, chiih-è, lumuii hà òh-òh aziak phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ai ne khi-èg shii de ajo phro, dinne ichuang shii de a-ua phro. Ai ne izai ji ayang sapho shii ai ne athodang pha rek ne rai phi phro, ");
INSERT INTO bgg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","chiih-è zab branthek ne ai lakhung shii luthong ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chiihphado shii giak branthek è Isu hà ibuii um ne miegthi nane miyao ayao mua pha bran jia noh ne wuii thog ruii. Isu è ji pha bran shii gang phi, Ji-è ai ne miyao yao muadun chiih-è, mieg de doh muadun. ");
INSERT INTO bgg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Thiichiih pha ibrogthek ne Isu è nyie rek pha ji riig ne zab wieng dun. Ithek è sai, “Hì ne Dawid pha Dufuii rey mua ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pharisithek è ji yoi mage shii, ithek è chang, “Ai è ibuiithek shii khia bie phi, nyieliieshii ithek ro bohkhoh pha Sakhathong è aishii blu phi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Isu ne ithek è nyie now pha ji thieg, jiè ai ithek shii yao, “Khi pha soh magunde yoh che ne ibrog nyi rek ne yo che ne awaithek chung gui rai pho ne muna phiang arai mua phro.” Chiih-è, khi pha thawun nane haliingpho yi ibrog yoh che srane awaithek chung gui rai pho ne muadun phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ji-è ibrog jia gai Sakhathong pha Sajathua shii mak rek rai arone, hì pha miyaosiu è ne ibrog che jong chiih-è jog mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nathek è yao nyieliieshii gushii ne Sakhathong è ji rek pha blu phi ne ibuiithek khia yi, wie. Chiihphado, naro samoythek shii ibuii khia pha blu hanyie miphi lei? Naro samoythek awaithek è rek pha ji è ithek ne asi pha rek rone khagi rek. ");
INSERT INTO bgg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Asi, hì ne sakhathong asi ro, jimagunde Hamangkhung-aphuii pha ragung ro, hanyie è gu shii blu phi ne ibuiithek khia yi, ji è ne Hamangkhung-aphuii pha Sajathua ne nathek lakhung shii wuii rone khagi rek phi. ");
INSERT INTO bgg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Hanyie è de bran gang ro hò chuak ne aishii nyie um pha ji ayie mua phro, igobi bran biigang shii joi bi chid: Chiihphado ai ne hò goh mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Hanyie thek guro asi pho ne gu shii izai gidieg rek noh phro; hanyie è gu rog shii anong pho ne khrab pha ji è izai dayiingdayang rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chiih-è jiè gu nathek shii yao branthek shii layog nane buii yao pha jithek shii nya khung phi phro; Jishii hanyie è Ragung So shii buii yao pha ji shii ne khuchung de akhung phi phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hanyie è Bran Dufuii shii gidieg rek pha ji ne nya khung phi phro; Jishii, hanyie è Ragung So shii gidieg rek pha ji shii ne khuchung de akhung phi phro—Sudoh nane idang gu de. ");
INSERT INTO bgg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Iwoi wie woi yi pha ne nathek shii hingmuii gang um chid phro; nashii hingmuii jia um arone, nashii ne iwoi de awie pha um ruii phro. Hingmuii ne iwoi khie woi ruii pha ji è thieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Phamthek nathek! Awie pha nathek ne khi-èrek ne miyao wie ji yao mua dun ga? Sem ne lubu è nyie now pha ji yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bran wie è nyie wie mana ruii pha jithek khia ne wie phi ruii phro. Awie pha bran ne awie pha mana ruii pha jithek khia ne phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nathek ne izai now ne rai iang bo! Chua pha ishak thog ruii shii nathek è khama jia pha adunmey pha miyaogam yao muii pha igam tham ne phi chid phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nawaithek miyaogam yao pha ji è nathek shii chua ruii phro—Nathek yi ichiig um ba oi ba ji yaothiak phi pha ro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chiihphado shii giak Iphey yua pha masdothek nane Pharisithek è yao ruii, “Masdo, gathek ne na mirek pha buang pha blia riig yang muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“Duchung pha branthek ne khama awie nane Hamangkhung-aphuii shii athieg pha branthek ara!” Isu è yao. “Nathek è gu shii buang pha blia rek phi bo ne lia ne bey? Asi! Nathek shii Jona chaig mirek marui pha buang pha blia ji phi bie phro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona è ù boh bucho shii inai da-um nane ibiu da-um rai dun pha duiine Bran Dufuii de inai da-um nane ibiu da-um sohnyiak bucho hà rai dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Chua pha inai shii ne Ninewe branthek riu srane nathek shii nin ruii phro, nyieliieshii nathek ne Jona è mua yao mage pha ji yoi ne awaithek layogthek khid jong ro; chiih-è, gu è nathek shii yao, ichiih shii ne Jona è de boh jia um ro. ");
INSERT INTO bgg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chua pha inaithek shii Sheba sajamuii de riu srane nathek shii nin ruii phro, nyieliieshii ai de bajo ruang pha soh è wuii ne Solomon Saja ro khua muyua ji yoi marui ro. Chiih-è gu ne nathek shii izai yao ichiih shii Solomon è de boh jia um ro! ");
INSERT INTO bgg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Khuchung magunde awie pha ragung bran è khia ne dun dun shii, ithek soh igoh shii lua srane thung pha ithua sow.” Ithek jia de adoh sharuii arone, ");
INSERT INTO bgg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ai ne awai shii yao, “Gu ne gui hò hà idoh dun pha ro.” Ji-è ai ne idoh hò dun srane riig ne isoloi; so nane zab khriig rek ne ruii iang pha doh. ");
INSERT INTO bgg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chiihphado ai ne fuang wuii srane ai rog shii awai è de bajo buii ragung miley yi, ne ithek dun srane thiichiih rai ruii phro. Ji-è rey ched mage shii, ji pha bran ne igobi è de awiedang pha rey ruii phro. Duchung awie pha branthek shii de hì duiine ro. ");
INSERT INTO bgg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Isu è branthek shii miyao yao bamuii shii ai amuii nane ai ikhuiithek thiichiih wuii thog. Ithek ne fuang hà riu srane, aishii shii mulo pha sai. ");
INSERT INTO bgg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ji-è thiichiih pha bran jia è aishii yao, “Riig bo, na amuii nane na khuiino ne fuang hà riu muii ro, chiih-è ithek ne narog shii mulo yang muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Isu è chang, “Hanyie ne gu amuii lei? Hanyie ne gu khuiinothek?” ");
INSERT INTO bgg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chiihphado ai è awai samoythek shii hìog ne yao, “Riig bo, ichiih ne gu amuii nane gu khuiinothek um ro! ");
INSERT INTO bgg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hanyie è hamangkhung hà um pha gu Aphuii è aishii nyie rek phi bo yang pha ji rek phi pho ne gu khuiinothek, gu bumuiithek chiih-è gu amuii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jipha inai shii Isu è hò thoh marui ne khabang ring hà wuii dun, thiisa hà ai dug srane yua. ");
INSERT INTO bgg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ibrog khrab dun pha ji ne bajo boh habuii ne ai run hà dun ne raidun chiih-è branthek ne bajo leyphiing dun pha ji è ai ne run hà in srane thog dun. Ji shii ibrog yi iring hà riu. ");
INSERT INTO bgg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ai è najangthek è ithek shii bajo manathek è yuaphi. “Luang jia bran jia yi iriie wey pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ai è raig shii iriie yi dayiingdayang rek marui, giak yi lumuii hà chiih dun, chiih-è fuiithek wuii srane zab chiing ne chie muii. ");
INSERT INTO bgg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Giak yi lubao sarong shii chiih dun, ji ne nyiak ìujia bie habuii ne, iriie ji khthiie sieng thog, nyieliieshii nyiak ne muna jam oi ro. ");
INSERT INTO bgg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jishii hasiang thog mage shii, misieng nyiu ne shud dun; chiih-è nyieliieshii iriing ijam dab pha acho, jiè misieng ne khthiie gowdun. ");
INSERT INTO bgg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Giak iriie ne migem biing shii chiih dun. Jipha misieng ne siang jimagunde shii ne giao dun. ");
INSERT INTO bgg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jishii giak iriiethek yi nyiak wie shii chiihdun, chiih-è misiengthek ne iwoi woi: giak ne biiriie wieng jia thog pha iwoithek woi, giak ne biiriie sariig thog pha, chiih-è giak ne biiriie sa-uom thog pha woi ruii.” ");
INSERT INTO bgg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Isu è yao ched, chiihphado “Nathek shii yoi pha khohthek um arone yoi bo!” ");
INSERT INTO bgg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chiihphado samoythek è Isu shii wuii srane aishii sai, “Na ne branthek shii yua shii nyie rek ne najang è yua phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Isu è chang, “Hamangkhung pha Sajathua pha miyao ug ne ruii pha ji è nathek shii phijong ro. Jishii ithek shii asi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Hanyie shii ìujia um pho shii ne muna phi ruii phro, jiè aishii ne chodang pha um ruii phro; jimagunde hanyie shii nyie oi pho shii ne ìujia um ne de yie dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gu è najangthek è yao pha chiang ji ne ithek shii riig yi, jimagunde adoh phi; chiih-è ithek ne yoi, jimagunde ithek ne ayoi chiih-è agao phi ro. ");
INSERT INTO bgg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ji-è Aijaya chaig è ithek shii yao marui ro; Hì pha branthek ne yoi pha ne yoi, jimagunde de agao phi ro; ithek ne riig pha ne riig, jimagunde adoh phi ro, ");
INSERT INTO bgg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","nyieliieshii, ithek khanithek ne blan ro, chiih-è ithek ne awaithek khohthek ne chiieg muii Chiih-è awaithek mieg ne siiemuii ro. Asi arone, ithek mieg de doh ruii, ithek khoh de yoi ruii phro, chiih-è, ithek khanithek de gao ruii phro. Chiih-è, ithek de gu shii khid ruii, Hamangkhung-aphuii shii yao chiih-è gu ne ithek nyagang mua. ");
INSERT INTO bgg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nathek ne khama wie ro! Nathek miegthek ne doh dun ro, chiih-è nathek khow ne yoi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gu è nathek shii izai yao, chaigthek nane Hamangkhung-aphuii pha branthek è ithek duiine bajo doh pha now shii jimagunde adoh mua phi. Nathek è nyie yoi pha ji yoi pha now shii ayoi phi. ");
INSERT INTO bgg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yoi bo, chiihphado wey pha najang pha miyaosiu ne yoi mage bo; ");
INSERT INTO bgg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hanyie è Sajathua pha mua ji yoi ne agao pho ne iriiethek ne lumuii shii chiih pha ji duiine ro. Awie pha jia è wuii srane ithek shii nyie wey pha ji ne zab riao ne yiedun; ");
INSERT INTO bgg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","chiih-è, lubao sarong shii chiih pha iriiethek ji ne hanyie thek è mua ji bajo wie lised ne khthiie yoi dun. ");
INSERT INTO bgg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jishii, hì ne ithek bucho hà akhud mua, chiih-è ishak phiang thog pha arai mua. Ji-è ji pha mua chiang è diig nane diigchiao thog mage shii, ithek ne khthiie thoh muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Migembiing shii chiih pha iriie ne hì ro, hanyie thek è mua ji yoi, jimagunde ichiih pha chai chiang shii samdiig srane bukho rek pha ji miie ne mua shii giao dun, chiih-è ithek ne iwoi awoi mua. ");
INSERT INTO bgg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Chiih-è nyiak wie shii chiih pha iriie ne hì duiine ro, hanyie è mua ji yoi ne guadun: ithek ne iwoi woi ruii, “giak ne biiriie wieng jia thog pha woi ruii, giak ne biiriie sariig thog pha, giak ne biiriie sa-uom thog pha woi ruii.” ");
INSERT INTO bgg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Isu è ithek shii gai najang yao, “Hamangkhung pha Sajathua hì duiine ro” bran jia è awai raig shii iriie wie hai marui. ");
INSERT INTO bgg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Biu jia, zab men ched dun shii, mak è wuii srane phiug duchoi shii saingthek wey marui ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Misiengthek yi sieng ne igam jao ne rey ramuii shii, chiihphado saingthek sieng mage. ");
INSERT INTO bgg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jipha khiao è dun srane masdo shii yao, “masdo!” Na ne nawai raig shii ne iriie wie ji hai marui, saingthek ne khi-è thog ruii phlei? ");
INSERT INTO bgg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Hì ne giak shuang pho miihai iwa!” Ai è chang. Na ne gathek shii wuii ne sieg muii bo ne yang bey, “ithek è chang? ");
INSERT INTO bgg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Asi, ai è chang, nyieliieshii, nathek è saing ji sieg mage shii ithek rog pha phiugthek de siegdun phro. ");
INSERT INTO bgg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ji-è phiug nane saing shii ne yamiing rey pha ishak thog dang pha ò sieng yi bo. Chiihphado gu yamiing rekpho shii yao ne igobi ji pha saingthek sieg yi pha ro, ithek shii pho ne bai hà ziao muii, chiih-è phiug shii khrab srane gu haphuii shii chab muii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Isu è ithek shii gai najang è yao: “Hamangkhung pha Sajathua ne hì duiine ro! Bran jia è danaro iriie yie srane awai raig shii wey. ");
INSERT INTO bgg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hì ne zab pha iriiethek è ìu ro, jimagunde ji sieng mage shii, hì ne zab pha misieng è boh rey dun. Hì ne hingmuii rey, jiè fuiithek wuii ne ji pha idiphak shii irungthek rok.” ");
INSERT INTO bgg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Isu è gai najang è yao bamuii: “Hamangkhung pha Sajathua ne ji duiine ro! Hò-amuii è phiia yie srane siiriie sawi muhab shii abog sapho shii ne lua ne raidun.” ");
INSERT INTO bgg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Isu è ibrogthek shii hìthek zab yao pha ne najang yao; ai ithek shii najang è ayao pha ne nyie de ayao phi. ");
INSERT INTO bgg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ai è ji è rek pha ji è chaig è nyie yao marui pha jithek izai rey yi, “Gu è nathek shii yao ruii shii, najang yao ruii phro; Gu ne nathek shii sohjambling zen pha ishak è athieg pha miyaothek yao ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Isu è bran ibrogthek shii thoh marui ne iliing hà dun dun, ai samoythek è aishii wuii srane yao, “Saing raig pha najang chiang ji nyie yao phlei ne gathek shii yao riig bo.” ");
INSERT INTO bgg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isu è chang, “Bran hanyie è iriie hai marui pha ji ne Bran Dufuii ji ro; ");
INSERT INTO bgg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Raig ji ne sohjambling ro; iriie wie ji ne hanyie Sajathua pha bran ithek ro ro. Saingthek ne hanyie awie pha jia jithek ro, ");
INSERT INTO bgg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","chiih-è hanyie è saingthek hai pha mak ji ne ibuii ji ro. Yamiing jong pha ishak ji ro, chiih-è, yamiing pha bliapho ne hamangkhliie ro. ");
INSERT INTO bgg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Saingthek shii khrab ne bai hà fu muii pha duiine, jong pha ishak shii de ji duiine rey ruii phro; ");
INSERT INTO bgg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bran Dufuii è airo Sajathua è fuang pho hanyie è branthek shii layog rek yi ne chiih-è hanyie è awie pha blia rek pho shii khrab pha thoh ge. ");
INSERT INTO bgg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ithek shii bai hòi boh shii fen muii phro, ithek ne choh ne sinyin khriig ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Chiihphado Hamangkhung-aphuii pha branthek ne Aphuii Sajathua hà hasiang duiine chuang ruii phro. Hanyie thek khohthek um pho ne yoi mage bo! ");
INSERT INTO bgg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Hamangkhung pha Sajathua ne hì duiine ro.” Bran jia è raig shii nuruii ug ne ruii pha ji doh. Ai è dinne chaig, chiih-è bajo sang ne dun ne awaishii nyie um pha manathek zab chongjai rek muii srane ji pha idoh wuii srane ji pha raig pheg. ");
INSERT INTO bgg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Hamangkhung pha Sajathua ne hì duiine ro, bran jia è wie rishang sow.” ");
INSERT INTO bgg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ai è igong um pha rishang jia doh mage shii, ai ne dun srane awai shii nyie um pha ji liu srane ji pha rishang shii pheg ro. ");
INSERT INTO bgg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hamangkhung pha Sajathua ne hì duiine ro, giak ù ua pho è kho shii chiug mua ne ichua ichua ù zum. ");
INSERT INTO bgg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jipha chiug ley mage shii, ithek iring shii khia srane dug ne ù gua: wie ji ne sikhen hà chab muii chiih-è wie pha ji shii ne awie pha ji è gua ne fen muii, ");
INSERT INTO bgg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","hì ne jong pha ishak shii hì duiine rey ruii phro: “hamangkhliiethek wuii srane awie pha branthek shii wie pha branthek duchoi è khrab muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chiih-è ithek shii ne bai hang shii fen muii phro, thiisa hà ithek ne choh ne shinyin khriieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Nathek ne hì pha miyao ji gaojong bey?” Isu è ithek shii sai. “Um,” ithek è chang. ");
INSERT INTO bgg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ji-è, ai è chang, “chiihphado, hì pha miyaosiu ne Iphey yua pha masdo hanyie è hamangkhung pha Sajathua pha samoy rey dun pho ne, hò muspho hanyie è awai haphuii è iwo nane ihèg manathek yi pha ji duiine ro.” ");
INSERT INTO bgg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Isu è najang jithek yao ched dang shii, ai è ji pha ithua thoh muii. ");
INSERT INTO bgg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chiih-è awai hò hà idoh dun. Ai è Jewthek misiahò shii yuaphi. Chiih-è hanyie è aishii yoi pho ne wieng dun. “Aishii hì pha khani khi è mua phlei?” Ithek è yao. “Chiih-è hì pha buangthek nyie lei?” ");
INSERT INTO bgg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ai ne zao rek pha dufuii ji asi bey? Ai amuii ne Mery ji asi bey? Ai khuiithek ne Jems, Joseph, Simon nane Judas thek asi bey? ");
INSERT INTO bgg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ai bumuiithek ne ichiih shii rai pha jithek asi bey? Ai ne ji pha manathek ne khi è mua dun phlei? ");
INSERT INTO bgg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chiih-è ithek è aishii snai muii. Isu è ithek shii yao, “Chaig shii ne gai pha ithua thek hà ilab rek phi phro, chiih-è, awai hò pha bajarai nane awai haliingthek è ilab arek phi phro.” ");
INSERT INTO bgg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nyieliieshii, ithek ne aishii lubu è migi arek phi. Ji-è, thiichiih shii ai è buangthek pha blia bajo arek phi. ");
INSERT INTO bgg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Herod è Galili shii khohthek ne rai pha ishak shii, Isu chiang shii yoi, ");
INSERT INTO bgg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Ai ne izai Jon khowo, hanyie ne chai idoh thog dinne bey,” Ai è awai dumuiithek shii yao. “Ji-è ai ne ji pha blu um ne buangthek rek ara ro.” ");
INSERT INTO bgg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod è Jon shii zum pha yungjong. Chiih-è Ai è shiirnai phang srane phatheg chab muii ro. Ai jithek rek pha ji ne ai ikhuii ro Philiph pha yiy Herodias pha chiang ro. ");
INSERT INTO bgg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nyieliieshii, Jon è Herod shii yao, “Herodias shii yiy rek pha ji è adunmey phro!” ");
INSERT INTO bgg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod è Jon shii ua muii pha now, jinagunde ai Jewishthek bran è rum nyieliieshii, Jewish thek è Jon ne chaig rone yao dun. ");
INSERT INTO bgg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod giak pha inai shii Herodias pha dimi è zab pha ibrog moe shii gasiu siu phi. Herod ne sang dun. ");
INSERT INTO bgg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ji-è, ai è dimi shii sbang rek, “ai è surua thak Na è nyie lia pha ji phi ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ai amuii pha miyao nuii ne ai è aishii lia, “Gu shii Jon khrug ne ichiih shiikhiia shii giong ne phi mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Saja ne zo dun, jimagunde nyieliieshii ai è awai è biwenthek moe shii sbang rek pha ji è ai è bimi è lia pha ji rek phi. ");
INSERT INTO bgg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ji-è, Jon khrug ne phatheg bucho hà tham yi. ");
INSERT INTO bgg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Khrug ji ne shiikhiia shii giong srane bimi shii phi muii, ai è amuii shii yie ne phi muii. ");
INSERT INTO bgg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon pha samoythek wuii thog, ai siu shii han dun, chiih-è wieng muii; chiihphado ithek ne wuii srane Isu shii yao phi. ");
INSERT INTO bgg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Isu è Jon chiang muathek yoi mage shii, ai run shii in srane awailum liijiing ithua hà wuii dun. Branthek de ji pha chiang yoi, jiè ithek awaithek thawunthek thoh srane ai idoh lai è luagieng. ");
INSERT INTO bgg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Isu run è fuang lung ne, ai boh ibrog riig mage shii, ai lubu ne nathek shii bushun now dun, chiih-è hanyie radpho shii ai è gang phi. ");
INSERT INTO bgg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jipha habjuang airo samoythek wuii thog srane yao, “Gethek ne bajo chia sha dun ro, chiih-è ichiih pha ithua ne liijiing ro. Branthek shii thiigthek hà thoh ne awai chie pha pheg yi haro!” ");
INSERT INTO bgg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ithek shii athoh ge rabo, Isu è chang, “ithek shii nawaithek è chie pha phi mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Ichiih gethek shii ne iweb guii nane ù nyi um bie ro, ithek è chang.” ");
INSERT INTO bgg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Isu è ithek shii yao din, “Jithek ne ichiih gu moe shii yie mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ai è branthek shii saing lakhung shii dug pha yung; chiiphado ai è iweb guii nane ù nyi ji yie srane hamangkhung hà hù ne riig ne, Hamangkhung-aphuii shii laso phi. Ai è iweb ji phed srane samoythek shii phi. Chiih-è samoythek è branthek shii phi. ");
INSERT INTO bgg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Zab branthek è lumuiidang pha chie. Chiihphado nyie khe pha ji yi siridthek snanyi ley chiing. ");
INSERT INTO bgg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hanyie chie pho ne hò-aphuii ne itham guii ro chiih-è hò-amuii nane aniphiing shii ne atham ro. ");
INSERT INTO bgg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chiihphado Isu è samoythek shii run shii in yi srane ibi khabang thrang pha ithua wuii yi. ");
INSERT INTO bgg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Branthek dun ge pha idoh, ai awailum ne phiingduii hà sia pha wuii dun. Habjuang rey mage shii, Isu ne thiisa ji rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jipha ishak shii ne run ne khabang è ruang rey dun. Khasua è laluadun, nyieliieshii hasam ibi è sam ruii. ");
INSERT INTO bgg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hamiang riang uom nane riig rey pha ishak shii Isu è kho lakhung è lua ne samoythek moe shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ithek è aishii kho lakhung shii lua pha doh mage shii, ithek ne rum dun, “Hì ne ibuii ro.” Ithek è yao, chiih-è rum ne ziak. ");
INSERT INTO bgg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Isu è ithek shii jog yao mage, “Lububo rek bo!” Ai è yao, “Hì ne gu ro, nathek ne arum rabo!” ");
INSERT INTO bgg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chiihphado Phithar è de yao, Ithong wo! Ji ne izai na chak arone, gu shii de kho lakhung shii lua ne na hà wuii yi bo. ");
INSERT INTO bgg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Thawuii bo!” Isu è chang, ji-è, Phithar de run è fuang lung srane jao ne kho lakhung shii lua ne Isu shii wuii. ");
INSERT INTO bgg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Jishii ai hasam gang ji riig ne ai ne rum chiih-è kho shii zem pha rekdun. “Phithar è ziak ne yao,” “Ithong wo gu shii ragia rek phi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Isu è jog aishii wuii srane aishii kho ne yao, “Nashii ne migi ìujia um ara? Na ne nyie rek pha than phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Isa nyi manyie run bucho shii in ne chiih-è hasam de them dun. ");
INSERT INTO bgg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chiiphado run shii um pha samoythek è Isu shii misiasia, “Na ne izai Hamangkhung-aphuii pha dufuii chak ro!” ithek è ziak. ");
INSERT INTO bgg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ithek ne khabang ji hiìa ne Genesareth pha soh hà wuii thog, ");
INSERT INTO bgg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Thiichiih pha branthek è Isu shii thieg. Ji-è ithek è zab soh pha radpho thoh ge srane ithek shii Isu hà noh thog ruii. ");
INSERT INTO bgg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ithek è aishii khung ne yao, “Hanyie radpho ne naro rugud ijiu shii khoh yi bo,” zab hanyie è khoh pho ne gang dun ro. ");
INSERT INTO bgg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chiihphado giak Pharisithek nane Iphey yua pha masdo Jerusalem è Isu shii wuii ne aishii sai, ");
INSERT INTO bgg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nyie rek ne naro samoythek ne gathek ro blangthek muyua marui anuii pha rek phlei? Ithek ne michie chie pha ibi shii wadthek wie è achun pha chie!” ");
INSERT INTO bgg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Isu è chang, “Chiih-è nyie rek ne nathek ne Hamangkhung-aphuii muyung anuii pha nawaithek muyua ji nuii ne rai?” ");
INSERT INTO bgg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Hamangkhung-aphuii è yao, nawai aphuii amuii shii ilab rek bo, chiih-è hanyie magunde awairo aphuii amuii shii muchocho arone aishii ne ua muii bo. ");
INSERT INTO bgg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hanyie bran shii awai aphuii amuii nong mua sbo nyie magunde um shii, jimagunde ai è yao hì ne Hamangkhung-aphuii ro ro. Nathek ne yua, ");
INSERT INTO bgg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ai ne awai aphuii shii ilab arek chid phro. Ji duiine nathek ne nawaithek muyua chiang ji nuii yi pha Hamangkhung-aphuii muyua ji shii thoh muii. ");
INSERT INTO bgg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Lawasdai nathek! Aijaya è khi-èrek ne nathek chiang chaig pha ji ne dunmey dang ro! ");
INSERT INTO bgg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Hamangkhung-aphuii è yao, Hì thek pha bran ne gu shii awaithek ro miyaogamthek è ilab rek. Jimagunde izai nathek lubu shii ne gu è bajo ruang um ro. ");
INSERT INTO bgg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hì ne ithek è gu shii misiasia pha ji è adunmey ro, nyieliieshii, ithek ne bran murab pha Iphey shii guro Iphey duiine yua phro! ");
INSERT INTO bgg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chiihphado Isu è ibrogthek shii ho srane ithek shii yao, “Yoi ne gua bo!” ");
INSERT INTO bgg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bran sem è bucho dun pha ji ne bran shii zea arab ro; “ji pha chiang shii nyie fuang khia pha ji è aishii zea rab ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chiihphado samoythek è aishii wuii srane yao, “Pharisithek è de na miyao ji yoi ne lubu hà lijieg dun pha ji nawai de thieg chak bey?” ");
INSERT INTO bgg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Isu è ithek shii chang ne yao din, “Hamangkhung hà Aphuii miihai asi pha misieng ne sieg ne fen muii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Ithek shii now ne arum chid rabo! ithek ne miegthi pho ro miegthi pha dumuiithek ro; khuchung magunde miegthi pha bran jia è miegthi pha bran gai shii chaing ne lua noh arone nyimanyi nyahiung hà chiih dun phro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phithar è yao ruii, “Hì yao pha ji ne yao phi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isu è ithek shii yao, “Nathek thuh de gaithek è de khua asi ara. ");
INSERT INTO bgg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nathek ne agao ba bey? Nyie magunde bran sem bucho dun pha ji è lui hà dun srane siu è khia dun. ");
INSERT INTO bgg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jishii, nyie sem è fuang khia ruii pha ji ne lubu è khia ruii phro. Jithek è bran shii zea rab ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ai lubu è awie pha munowthek khia ruii phro, ji pha munow è aishii sgoh, siulao pha, biwo blia rek pha, mugoh pha, khlam yao pha, gai shii buii rek pha, ");
INSERT INTO bgg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hì thek pha manathek bran shii zea rab phro. Jimagunde nathek miyao duiine wad achun pha michie chie pha ji è bran shii zea arab phro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Isu ne ji pha ithua thoh marui ne Thaire nane Sidon pha rajan pha soh hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Thiichiih rai pha Gananithek hò-amuii jia è aishii wuii thog ruii, “Dawid pha Dufuii!” Ai è choh ne yao. “Gu shii bushun now phi bo! Masdo gu dimi ne ibuii um chiih-è awie dang pha rai muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jishii Isu ne ji pha hò-amuii shii nyie miyaogam ayao, airo samoythek è aishii wuii srane khung ne yao, “Jipha hò-amuii shii dun gey bo! Ai ne gethek idoh lua ne bajo roh ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isu è ithek shii chang ne yao, “gu shii ne Israel pha shiishai san dun pha ji so pha thoh bie ro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ji è yao mage shii ji pha hò-amuii è Isu lai moe shii bam srane yao, “Masdo gusa shii nong phi bo!” ");
INSERT INTO bgg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Isu è chang, “Aniphiing ro michie ne yie srane choi shii fen ne phi mua pha ji adunmey phro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Jine izai ro, masdo,” ai è chang! “Jishii, choi de Ithong chie ne thiibliie è chiih dun pha ji è nya chie mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ji-è, Isu ne aishii chang ne yao, “Na ne migi bajo um pha hò-amuii ro! Na è nyie yang pha ji ne na shii rek ruii phi phro.” Ji è yao dang shii bimi ji ne gang dun. ");
INSERT INTO bgg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Isu è thiichiih thoh ne Galili pha khabang ring è wuii dun. Ai è phiingduii jia shii khrog ne dug dun. ");
INSERT INTO bgg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Boh ibrogthek è ai moe shii, lai alua mua pho, miegthi pho, lai khi-èg pho, ayao mua pho, chiih-è, gai radpho shii noh ne Isu lai shii ruii phi ne, ai è ithek shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bi-ìethek de yao din, laikhi-èg de wiedun, lai alua mua pho de lua mua dun, miegthi pho mieg doh dun pha ji doh mage ne zab thiichiih um pha branthek wiengphleg ne Israel pha Hamangkhung-aphuii shii chiong. ");
INSERT INTO bgg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isu è awai samoythek shii ho srane yao, “Gu ne ichiih pha branthek shii bajo bushun now muii ro, nyieliieshii, ithek de gu rog shii inai da-um rey sha pha rai gieng dun ro, thuh shii ithek shii chie pha nyie de oi sha ro. Gu ne nathek shii nyie de achie yi pha dun ge pha anow ro, yang ne ithek ne lumuii hà chi-iy ne thud pha de um phro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Samoythek è Isu shii sai, “Gethek ne khi-èrek ne ichiih balimuang shii um pha ibrog shii phi ne chie mua mage phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isu è ithek shii sai, “Nathek shii iweb khama um ga?” Ithek è chang, “Iweb miley chiih-è ù ìujia um bie ro.” ");
INSERT INTO bgg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Isu è ji pha ibrogthek shii nyaliag shii dug pha yung. ");
INSERT INTO bgg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chiihphado ai è iweb miley nane ù jithek chiing srane Hamangkhung-aphuii shii laso phi srane phed ne samoythek shii phi, samoythek è branthek shii phi ne chie yi. ");
INSERT INTO bgg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ithek zab è ji lumuii dang pha chie. Chiih-è led marui pha ji ne samoythek è sirid miley chiing. ");
INSERT INTO bgg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Thiichiih um shii chie pha branthek ne itham Sawi um dun ro, hò-amuii nane aniphiing shii atham ro. ");
INSERT INTO bgg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chiihphado Isu è branthek shii dun ge yi, awai de run in srane Magadan pha soh hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Giak Pharisithek nane Sadusithek Isu shii chai pha aishii wuii thog, “Ji-è Hamangkhung-aphuii è aishii khagi rek rone doh yi pha, ithek è aishii buang rek bo ne lia.” ");
INSERT INTO bgg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jishii Isu chang, “khuchung magunde hasiang yem ramuii shii nathek è yao, gethek shii inai ne wie è rey pha um ro, nyieliieshii, hamang ne shaig ro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chiih-è hamiang riang nathek ne yao ruii, “Hì ne haphie phie pha rek muii ro, nyieliieshii, hamang ne shaig nane igiia ro. Nathek è hamang hà riig ne nyathieg mua, jishii nathek ne hì pha ishak pha cheb chiang shii ayao mua ro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Duchung pha branthek ne khama pha awie nane Hamangkhung-aphuii shii athieg dang ara! Nathek è gu shii buang ji lia ne bey? Asi! Nathek shii ne Jona ro buang ji ne phijong pha ji bie ro! Ji-è ithek aishii thoh marui ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Samoythek khabang è hiìa ne kho thrang wuii thog mage shii, ithek ne iweb yie pha blengdun. ");
INSERT INTO bgg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Isu è ithek shii yao, “gayiig bo” “Pharisithek nane Sadusithek phiia pha gidieg è ragia rek bo.” ");
INSERT INTO bgg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ithek awaithek chung jao ne yao rai, “Ai è hì yao pha ji è, nyieliieshii gethek è iweb bia ne ayie pha ji ara ro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Isu ithek nyie yao pha ji thieg, jiè ai è ithek shii sai, nathek ne iweb ayie pha chiang è nyie rek ne yao rai phlei? Nathek shii migi ìujia um ro! ");
INSERT INTO bgg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nathek ne thuh de agao bey, gu è iweb guii phed ne itham guii branthek shii chie noh pha ji ne nathek anow bey? Nathek è sirid khama iweb chab phlei? ");
INSERT INTO bgg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chiih-è, itham wi shii phi ne chie yi pha iweb miley jine nyie lei? Nathek è srid khama chab phlei? ");
INSERT INTO bgg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ji ne gu ne iweb chiang ne ayao rone nathek ne khi è agao lei? Pharisithek nane Sadusithek pha phiia è nawaithek shii ragia rek bo. ");
INSERT INTO bgg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chiihphado samoythek è gao ai ne ithek iweb shii phiia lua pha chiang awaithek shii ragia rek bo ne phriie pha asi jimagunde Pharisithek nane Sadusithek pha muyua ji è ro. ");
INSERT INTO bgg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Isu ne Khaisaria Philiphi pha inui soh hà wuii dun, thiichiih shii Isu è awai samoythek shii sai, “Branthek è Bran Dufuii shii hanyie rone è yao lei?” ");
INSERT INTO bgg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Giak è ne Jon khowo rone yao,” nathek è chang, giakthek è Elija rone è yao, “giak è Jerimia nane gai chaig rone yao ro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Nathek khi è now lei? Ai ithek shii sai. Nathek gushii hanyie ro è yao phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Phithar è chang, “Na ne Masi ro, chiih-è isieng Hamangkhung-aphuii pha Dufuii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Nashii ne wie ro, Jon pha dufuii Simon!” Isu è chang, Hì pha izai ne bran è thog pha asi ro, jimagunde hì ne na shii guro hamangkhung pha Aphuii è miang phi ro. ");
INSERT INTO bgg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ji è gu ne na shii yao, Phithar: na ne lubao ro, chiih-è hì pha lubao phing shii gu ne gui ro charch rung ruii phro, chiih-è iy pha ji shii ayang mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gune nathek shii hamangkhung pha Sajathua pha ziuwad phi ne ruii phro; “Na è sohnyiak shii nyie lem pha ji è hamangkhung hà de lem ruii phro, chiih-è, na è sohkhung shii nyie rek yi pha ji è hamangkhung hà de phi ne rek yi phro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","“Ai è awai samoythek shii ai ne Masi rone hanyie shii de ayao rabo è gak marui.” ");
INSERT INTO bgg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jipha ishak è ne Isu ne awai samoythek shii hong ne yao phi, “Gu ne Jerusalem hà wuii chid phro, thiisa hà wuii srane dukhothek boh phabithek, Iphey yua pho masdothek, wad re-è bajo diigchiao mua ruii phro. Gu shii ua muii phro, jimagunde gune da-um shii idoh hòi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phithar è Isu shii thekhlei hà noh srane giung. Phithar è yao, “Ithong wo! Na shii ne hì è rek pha ji ne Hamangkhung-aphuii è khuchung de arey yi phro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Isu è shan srane riig ne Phithar shii yao, “Sakhathong! Gu moe è ruang dun dun bo! Na ne gu lumuii shii gak pha rek ramuii ro, nyieliieshii, na miyao hìthek ne Hamangkhung-aphuii è thog ruii pha asi ro, hì ne bran munow ne yao ro.” ");
INSERT INTO bgg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chiih-è, Isu è awai samoythek shii yao din, “Hanyie è gu rog lua pha now arone, ai ne awaishii bia chid phro,” chiih-è, awairo bai ji han ne idoh lua chid phro. ");
INSERT INTO bgg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nyieliieshii, hanyie awai chai shii ragia rek pha now arone, ji pha chai ne san dun phro. Jishii, hanyie chai ne gu chiang è san yi arone, aishii mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bran hanyie zab sohjambling mua srane awai chai san muii pha ji è aishii nyie magunde phua pha um bey? Ai ne nyie de amua phro, san dun pha chai ji mua din pha nathek shii nyie phi pha de oi ro. ");
INSERT INTO bgg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nyieliieshii, Bran Dufuii ne awai Aphuii pha biisiie shii hamangkhliie rog shii wuii ruii phro, chiih-è ai zab shii ithek blia ji duiine lasen phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Gu è nathek shii izai yao dang phro, ichiih um pha giak branthek ne Bran Dufuii ji saja duiine wuii din ruii pha adoh sapho shii ne a-iy phro.” ");
INSERT INTO bgg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dariig pha idoh Isu è Phithar nane khuiinothek nyi Jems nane Jon de noh srane phiing giu jia hà wuii dun, thiisa hà ne awaithek ji bie ro ");
INSERT INTO bgg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ithek è riig dang phiichiih shii Isu ne laidun: Ai mizia ne hasiang duiine khliengchuang pha doh ruii. Chiih-è, airo yung ne khijen imo ne wud dun. ");
INSERT INTO bgg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chiihphado ji pha samoy uom è Moses nane Elija ne Isu rog mulo pha doh. ");
INSERT INTO bgg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Phithar è ji doh ne Isu shii yao, “Ithong wo! Gathek ne ichiih um iang pha ji ne bajo wie ara! Na è yang arone, gu ne ichiih shii haliig uom rab phi; jia ne na ro; jia ne Moses ro, jia ne Elija ro.” ");
INSERT INTO bgg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ai è yao ramuii shii khliengchuang pha sakhamiing è ithek shii thab ne jiangdun, chiih-è ji pha sakhamiing è goh jia è yao ruii, “Hì ne guro bushun pha Dufuii ro, aishii ne gu bajo sang muii ro, ai miyao yoi bo!” ");
INSERT INTO bgg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Samoythek è ji è goh yoi mage shii, ithek ne bajo rum dun ne awaithek miziathek ne nyiak hà jiingdun. ");
INSERT INTO bgg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Isu è ithek moe shii dun thog srane awai wad è khoh, “Arum chid rabo, jai sha mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ji-è, ithek è hù ne riig shii thiichiih shii hanyie de oi pha Isu awai jijia um bie. ");
INSERT INTO bgg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ithek phiing ji è thazam dun thog shii, Isu è samoythek shii gak ne yao, “Nathek è nyie doh pha ji ne Bran Dufuii iy ne dinne ahòi sapho shii ne hanyie shii de ayao bi rabo.” ");
INSERT INTO bgg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chiihphado samoythek è Isu shii sai, “Nyierek ne Iphey yua pha masdothek è Elija ne igobi wuii ruii phro è yao phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isu è ithek shii chang, “Ji ne izai chak ro, Elija ne ibi wuii ruii ro, ai ne zab khriig saro iang phro. ");
INSERT INTO bgg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jishii gu ne nathek shii yao Elija ne wuii thog jong ro, branthek è aishii athieg phi ro, aishii ne nathek è khi è yang pha ji rek phi ro. Aishii duiine Bran Dufuii shii de buii rek ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chiihphado samoythek de ji pha miyao ne Jon Khowo pha chiang è yao ramuii rone gao dun. ");
INSERT INTO bgg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ithek è bran ibrog um pha ji shii thog din shii, bran jia è Isu shii wuii srane lagiungniing, ");
INSERT INTO bgg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ne yao, “Masdo! Gu dufuii shii bushun now phi bo! Aishii ne siug pha miiriie um ro. Jipha miiriie è bajo sam srane aishii bai kho hà blebbleb chiih yi ro. ");
INSERT INTO bgg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gu è na samoythek shii noh ne wuii shii, ithek è aishii gang arek mua phi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Isu è chang, “Nathek ne migi oì pho nane adunmey pha bran ara! Gu ne nathek rog shii khama chia ne rai gieng phlei? Gu ne nathek rog shii khama khan dam? Jipha bufuii ne ichiih gu moe shii noh mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isu è ibuii ragung shii giung mage, ibuii ragung de bufuii ji è fuang khiadun. Chiih-è ji pha ishak dang shii bufuii ji de gangdun. ");
INSERT INTO bgg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ji-è, samoythek ne Isu shii ug ne wuii srane sai, “Gathek ne nyie rek ne ibuii ragung ji agieng mua lei?” ");
INSERT INTO bgg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Isu è chang, “Hì ne nyieliieshii nathek migi ne acho ba ne ji mirey ro. Gu è nathek shii izai yao dang phro, nathek migi ne danaro pha iriie jia duiine um arone, ithek è phiingduii hì shii thiisa hà dun bo è yao nede ji ne nyadun dun phro. Nathek ne nyie magunde nyarek mua phro!” ");
INSERT INTO bgg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jishii hì è rek ne khia mua pha ji è misia nane minyie è rek mua bie phro; gai è ne arek mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Samoythek è zab Galili shii khrab ne dun thog mage shii, Isu è ithek shii yao, “Bran Dufuii shii ne branthek shii phi pha rek mua phro, ");
INSERT INTO bgg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ithek è aishii ne ua mua phro; Jishii da-um pha idoh shii ai ne chai hòi ruii phro.” Samoythek ne bajo zodun. ");
INSERT INTO bgg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Isu nane airo samoythek Khaphernaum shii wuii thog mage shii, Misiahò pha mijin thanpho è Phithar shii wuii ne sai, “Na ro masdo de Misiahò pha mijin phi chak ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Phithar è chang, “Than chak.” Phithar è hò bucho wuii thog mage shii, Isu è ibi yaodun, “Simon, na ro munow ne nyie ga? Hanyie è soh pha sajathek blia rek ne chiih-è mijin phi phlei? Soh pho mijin ba asi pha gai sohphothek mijin ba?” ");
INSERT INTO bgg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phithar è chang, “Ji ne gai sohphothek mijin ro.” Isu è chang, “Wie ro,” Jipha miyaosiu è gethek sohphothek ne athan chid. ");
INSERT INTO bgg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jishii, gethek ne hì pha bran shii lijieg yi pha ayang ro. Ji-è khabang shii wuii srane akhiiriie ria mage bo. Naro akhiiriie shii igobi fog ruii pha ù yie ne chiih-è ai sem shii sikhi jia doh ruii ne gu chiang nane na chiang pha Misiahò pha mijin ji cho yi phro. Yie srane gethek ro muthanthek mijin ishak shii phi. ");
INSERT INTO bgg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jipha ishak shii samoythek è Isu shii wuii ne sai, “Hanyie ne hamangkhung pha Sajathua shii boh um ga?” ");
INSERT INTO bgg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ji-è, Isu è ani shii ho, ne ithek ibi shii riu yi, ");
INSERT INTO bgg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ne yao,” “Gu ne nathek shii yao nathek ne aniphiing duiine arey sapho shii ne hamangkhung Sajathua shii akhud mua phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hamangkhung pha Sajathua shii zab è boh rey pha ne hanyie è awaishii jum rek ne hì pha ani duiine rey yi pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chiih-è, hanyie è gu ibeng è ani jia shii wieho arone, gu shii de wieho ro. ");
INSERT INTO bgg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Hanyie magunde, nathek è gu shii migi rek pha ji shii ìujia de san yi, ji pha bran shii ne rathok yua shii phang srane khamuii jam hà zem yi pha ji wie liag phro.” ");
INSERT INTO bgg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sohjambling ne bajo diig um phro, nyieliieshii, thiichiih ne branthek ro migi san pha manathek um ro! Jithek ne idang rey ruii phro—Jishii hanyie chiang è ji rey yi pho shii ne bajo buii rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nawaithek wad nane lai è nathek è migi shii san yi arone, jithek ne tham ne fen muii bo! Ji ne wad nyi nane lai nyi um ne idang pha bai hà fen yi pha ji è ne wad lai jia oi pha chai sieng pha ithua hà khud pha ji wie liak phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nawaithek mieg è nawaithek migi shii san noh arone, ji pha mieg ne yog srane fen muii bo. Mieg nyi um srane thumuluii pha bai hà fen yi pha ji è ne mieg jia oi pha idang pha chai ithua hà khud pha ji wie liak phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Riig bo nathek ne ìuthek shii de snai arek rabo. Gu è nathek shii yao phro, aniphiing pha hamangkhliie ne idang hamangkhung pha Aphuii moe shii rai muiiro. ");
INSERT INTO bgg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nyieliieshii, Bran Dufuii ne san dun pha jithek shii ragia rek pha wuii. ");
INSERT INTO bgg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Hanyie shii shiishai weing jia um pha bran ne shiishai jia san dun shii nyie rek phi phro inow ga?” Ai ne sadigey è digey jithek shii phiingduii shii saing chie yi pha thoh marui srane san dun pha shiishai jia shii sow pha wuii dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gu è nathek shii yao dang phro, ai è ji doh mage shii ai ne asan pha shiishai sadige è dige um pha ji è de bajo muna sandun pha jia ji shii sang ba phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ji duiine nathek ro hamangkhung hà Aphuii ne ididuii jia de san yi pha ayang ro. ");
INSERT INTO bgg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nathek khuiino è na shii gidieg shii layog rek arone, aishii wuii srane ai mirek pha ichiig ji riig yi bo. Jishii ug ne nawaisa chung rek bo. Ai è na shii nuii phi arone, na è na khuiino shii yang ne idoh nohge ro. ");
INSERT INTO bgg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jishii ai è na shii ayoi arone, na rog shii gai jia nyi noh bo, Ji-è jigigam shii yao pha duiine nyi è muna pha khagi ji è zab ichiig ne ji chak rone rek yi bo. ");
INSERT INTO bgg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chiih-è ai è nathek shii ayoi phi arone, chiihphado zab pha jithek ne charch hà yao muii bo. Idohhè shii, ai è charch shii ayoi arone, aishii ne migi arek pho nane mijin than pho duiine noh bo. ");
INSERT INTO bgg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ji-è, gu ne nathek zab shii yao, “Nathek è sohnyiak shii nyie gak muii pha ji è hamangkhung hà de gak ruii phro, chiih-è, nathek è sohnyiak shii nyie rek yi pha ji è hamangkhung hà de rek yi phro.” ");
INSERT INTO bgg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Gu ne nathek shii dinne yao phro: khuchung magunde nasa è sohnyiak shii lubu ò rek srane nyie chiang shii sia arone, ji ne hamangkhung pha gu Aphuii è nasa shii rek ruii phi phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“Chiih-è gu ibeng è bran nyi uom ò khrab pha ji shii ne, gu ne nathek rog um gieng ro.” ");
INSERT INTO bgg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chiihphado Phithar Isu shii wuii srane sai, “Ithong wo!” Gu ikhuii è athodang pha gu shii layog rek muii arone, gu ne aishii khama chiieng khung phi chid phiiga? Milechiieng khung phi habey? ");
INSERT INTO bgg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isu è chang, “Miley chiieng duii jia asi pha, jishii samiley chiieng pha mileychiieng khungphi chid phro.” ");
INSERT INTO bgg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nyieliieshii, hamangkhung pha Sajathua ne hì duiine ro. Luangjia ishak shii saja jia è awai khiaothek muruii pha sasab rek pha phak. ");
INSERT INTO bgg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ai è ji sasab reg ne riig shii khiao jia ne bang itham phi pha um. ");
INSERT INTO bgg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Khiao shii ne ji pha muruii phi mua sbo acho ro, jiè airo muruii ji phi mua yi pha Saja è awaishii, ai yiy, ai anithek chiih-è, aishii nyie um pha jithek rog khiao rek pha chong liu muii bo ne yung. ");
INSERT INTO bgg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Khiao ji è saja ji pha lai moe shii wuii srane lagiung niing ne yao, “Gu shii ìujia khan bi bo, gu ne nashii zab rang din pha ro.” ");
INSERT INTO bgg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Saja ji è aishii bushun now ne ai muruiithek ne ayie pha tho muii ne dun ge yi. ");
INSERT INTO bgg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Chiihphado è ji pha bran de awai khiao ijiiak hanyie shii bang mua pha um pha ji shii lia pha wuii dun. Ai è awai ijak ji shii zum srane bang chiie dun pha ji phi bone khang. Ai è yao, “Na è gu bang chiie dun pha ji jog phi mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ijak khiao ji è aishii khung ne yao, “Gu rog shii jum rek bo! Gu è nashii bang ji zab rang din phro!” ");
INSERT INTO bgg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jishii ai è anuii, ji pha chiang shii, airo muruii idoh aphi sapho shii ne aishii ne phatheg hà chabmuii. ");
INSERT INTO bgg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ji è rek pha ji ne gai khiaothek è doh mage ne bajo zo ne wuii srane saja ji shii zab yao phi. ");
INSERT INTO bgg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jipha saja è khiao ji shii ho srane giung, “Adunmey pha khiao! Na è gu shii khung ne lia pha ji è gu ne guro zab bang ji ne ayie pha thojong. ");
INSERT INTO bgg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gu è khi-èrek ne nashii bushun rek pha duiine na de nawai khiao ijakthek shii bushun rek chid phro. ");
INSERT INTO bgg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ji-è, ji pha saja ne bajo lijieg dun, ai muruii ji aphi sapho shii ne lago phi pha phatheg hà chab muii.” ");
INSERT INTO bgg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Isu è yao ched, “Ji duiine ithek è nawaithek khuiino shii lubu akhung phi arone Hamangkhung hà um pha gu Aphuii de, ji duiine ithek shii khuiino ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Isu è ji nyayao ched dang shii, ai Galili thoh marui ne Juda pha sohthug, Jordan khabang thrang hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bran ibrogthek idoh luagieng, Isu è thiichiih shii branthek shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Giak Pharisithek ne Isu moe shii wuii thog srane aishii musai sai ne ibong shii phang yi pha bidiang, “Gey è awai lum ne ichiig phi srane awai yiy shii che muii pha ji ne Iphey shii rek yi ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Isu è chang, “Jao pha ji è Rabpho è bran shii bufuii bimi rab phrone yao pha jigigam ji atham ba bey?” ");
INSERT INTO bgg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chiih-è Hamangkhung-aphuii è yao, “Hì pha chiang è bufuii ne awai aphuii amuii thoh marui ne awai yiy rog shii dog dun phro, chiih-è isa ne ò rey dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ji-è, ithek ne nyi asi pha jia ro. Ji-è, bran ne Hamangkhung-aphuii è dog phi pha ji ache rabo.” ");
INSERT INTO bgg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pharisithek è aishii sai, “chiihphado, Moses pha Iphey shii gey è che pha siog zey ne awai yiy shii che muii bo è nyie rek ne yao phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isu è chang, “Moses è nawaithek yiy shii che pha yung pha ji ne nyieliieshii nathek shii yua pha ne bajo diig ro, Jishii, rab pha ishak shii ne ji duiine asi ro. ");
INSERT INTO bgg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Gu ne nathek shii izai yao dang phro, chiihphado, bran è awai yiy shii siulao arek pha gai chiang è che muii arone, ai è gai bimi yiy din magunde, ji pha gey ne siulao rey dun phro.” ");
INSERT INTO bgg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ai samoythek è aishii yao, “Gey nane yiy duchoi pha miyao ne hì arone, ayiy-agey chid pha ji wie liag ba phro.” ");
INSERT INTO bgg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Isu è chang, “Hì pha muyua ne zab shii adunmey phro. Jishii Hamangkhung-aphuii è hanyie shii phi jipho ro bie phro. ");
INSERT INTO bgg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Branthek ne ayiy-agey rai pha miyao ne bajo yoyo chiang um dun ro, giak ne ayiy-agey pha giakdun; chiih-è giak ne branthek è de rab yi, giak ne hamangkhung pha Sajathua pha chiang è ayiy-agey rai ro. Hì pha muyua ne hanyie è nuii pho ne ji rek yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Giak bran è aniphiing shii wad khoh ne sia yi pha Isu shii noh ne wuii thog, Jishii, samoythek è ji pha branthek shii giung. ");
INSERT INTO bgg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Isu è yao, “Aniphiing shii agak pha gu hà wuii yi bo, nyieliieshii, hamangkhung pha Sajathua ne hìthek duiine rekpho ro ro.” ");
INSERT INTO bgg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ai è ithek lakhung shii wadthek ruii srane dundun. ");
INSERT INTO bgg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Luang jia shii, bran jia Isu shii wuii, “Masdo,” Ai è sai, “Gu ne idang pha chai mua pha nyie wie blia rek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Na ne nyie yi wie rone sai phlei?” Isu è chang. Thiichiih shii nyie wie ne jia bie ro. Idang pha chai shii khud pha yang arone muyungthek nuii bo. ");
INSERT INTO bgg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ai è sai, “Nyie muyungthek lei?” Isu è chang, “Sgoh arek rabo, siulao arek rabo, mugo agow rabo, chiih-è khlam anin rabo, ");
INSERT INTO bgg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","chiih-è, nawai aphuii amuii shii ilab rek bo, nawai hadung-haluii shii nawai shii duiine bushun rek bo.” ");
INSERT INTO bgg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Filiao ji è chang, “Gu ne ji pha zab muyungthek nuiijong ro. Gu ne gai ne nyie rek chid ba pha um ga?” ");
INSERT INTO bgg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isu è aishii yao din, “Na ne nawai shii isiie bajowie rek pha yang arone, dun srane nawai shii um pha ji chong rek srane bang jithek yi dushothek shii phi muii bo, chiih-è nane hamangkhung hà bajo bukho rey ruii phro; chiihphado thawuii ne gu idoh luagieng bo.” ");
INSERT INTO bgg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Filiao è ji yoi mage shii, zo ne dundun, nyieliieshii ai ne bajo bukho ro. ");
INSERT INTO bgg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chiihphado Isu è awai samoythek shii yao, “Gu ne nathek shii yao: bukho branthek ne hamangkhung pha Sajathua hà khud pha ji shii ne bajo diig ro. ");
INSERT INTO bgg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gu è dinne yao, ùd è simen cho shii khud pha ji shii ne bukho bran è Hamangkhung-aphuii pha Sajathua shii khud pha ji muna diig ba ro.” ");
INSERT INTO bgg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Samoythek è ji yoi mage shii, zab wieng dun. Chiihphado hanyie ne ragia rey mua phlei? Ithek è sai. ");
INSERT INTO bgg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isu è ithek shii miang riig srane yao, “Hì ne bran è arek mua phro, jimagunde Hamangkhung-aphuii ne zab rek mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chiihphado Phithar è yao mage, “Riig bo,” Ai è yao, “gathek ne zab thoh muii ne na idoh luagieng. Gathek shii ne nyie mua ruii phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isu è ithek shii yao, “Gu ne nathek shii izai yao Bran Dufuii ji è ishak iwo shii saja biang hà dug mage shii, Israel pha iiriing snanyi shii bohkhoh pha guro samoythek snanyi ithek ne bukho biang shii dug ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chiih-è, hanyie è awai khuiinothek, bumuiithek, aphuii, amuii nane anithek, raigthek gu chiang è thoh muii pho ne wieng chiieng mua ruii phro, chiih-è, idang pha chai phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jishii, thuh bajo hanyie thek ne ibi um pho ne idoh rey ruii phro, chiih-è, bajo hanyie thek thuh shii idoh um pho ne ibi rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hamangkhung pha Sajathua ne hì duiine ro, luangjia shii bran jia è hamiang riang ai raig shii blia rek pha nung pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ai è ithek shii idang inai jia shii riinang ne liiman sikhi jia phi pha nuii, chiih-è ithek shii ai raig hà blia rek pha thoh ge. ");
INSERT INTO bgg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ai è hamiang dige rey pha ishak shii bajarai ithua hà wuii dun, chiih-è bran giak ne nyie blia arek pha riu pha doh. ");
INSERT INTO bgg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ji-è, ai ne ithek shii yao, “Nathek ne wuii srane raig rek bo, chiih-è gu ne nathek shii riinang wie phi pha ro.” ");
INSERT INTO bgg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ji-è, ithek wuii dun. Chiihphado snanyi ishak shii nane dinne uom ishak shii ai è ji duiine rek. ");
INSERT INTO bgg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Guii ishak nyarey sha pha rey mage shii ai ne bajarai ithua hà wuii dun, chiih-è thiichiih shii giak branthek ne blia oi pha riu ne rai bamuii pha doh. Ai è ithek shii de yao, nathek ne ichiih shii zab inai ne thaluii nyie rek pha rai phlei? ");
INSERT INTO bgg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Asi, gathek shii ne hanyie è de riinang hà anoh phi ro. Ai è ithek shii yao, “Wie, nathek de raig hà wuii srane raig rek bo.” Ai è ithek shii yao. ");
INSERT INTO bgg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Habjuang rey mage shii, raig muspho è awai khoboi shii yao, ‘iidohhè è nung pha brapho è yie dang ne igobi è brapho pha bliapho shii ho ne riinang phi mage bo.’” ");
INSERT INTO bgg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hanyie è ishak guii è rek phothek shii liiman sikhi jia phi. ");
INSERT INTO bgg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ji-è, igobi brapho shii phi shapha thog mage shii ithek ne ji è huak pha phi ruii phrone now habuii shii ithek shii de liiman sikhi jia jia phi bie. ");
INSERT INTO bgg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ithek è awaithek bang yie srane mushiiyluwoi ne gidieg yao ne raig muspho shii wuii ne sai. ");
INSERT INTO bgg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hìthek pha bran ne hanyie iidohhè brapho ne ishak jia thog pha rek bie ro, ithek è yao gathek ne inai biak dang pha hasiang è de shud ne raig rek—thuh na ne gathek shii phi pha duiine ithek shii de ò phi ro! ");
INSERT INTO bgg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yoi bo, Ijakthek, muspho è ithek è jia shii yao, “Gu ne nathek shii akhinrin ro! Nathek zab shii inai jia pha riinang ne liiman sikhi jia phi pha yao phro. ");
INSERT INTO bgg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nawaithek ro riinang ji yie ne hò dun bo. Gu ne iidohhè brapho shii de nathek shii khama phi pha ji phi pha yang muii ro. ");
INSERT INTO bgg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gu ne gui bang ji shii gui è nyie rek yang pha ji rek pha ne rangsua asi bey? Din ne gu è zab shii ò rek pha ji è nathek ne miegriie rek ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Isu è yao ched, “Hanyiethek ne idoh um pho ne ibi rey dun phro, chiih-è, hanyiethek ne ibi um pho ne idoh rey ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Isu è Jerusalem wuiiramuii shii, ithek wuiiramuii shii ai è awai samoy snanyi shii thekhlei pha ithua hà noh srane ug ne yao. ");
INSERT INTO bgg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yoi bo! Ai è ithek shii yao, gethek ne Jerusalem hà wuiiramuii ro, thiisa hà ne Bran Dufuii shii boh phabithek nane Iphey yua pha masdothek shii phi muii phro. Ithek è aishii ua muii pha nin muii phro, ");
INSERT INTO bgg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chiih-è, gai branthek wad shii phi muii phro, hanyie è aishii ne makhakriing ne aishii zuang ne bai hà zun ne ua muii phro; jimagunde ai ne da-uom shii idoh hòi ne chai shii sieng ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chiihphado Zebedi ai yiy de awai dufuii nyi rog Isu shii wuii srane bam, chiih-è haro rek phi bone aishii lia ro. ");
INSERT INTO bgg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Isu è aishii sai, “Na ne nyie chiid muii ga?” Ai è chang, “Na ne guro dufuii nyi hì shii ne na è saja rey mage shii na phazoi nane na phawig shii dug yi pha rone sbang rek bo.” ");
INSERT INTO bgg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na ne nawai è nyie lia pha ji ne athieg pha lia ara, Isu è dufuiithek shii chang. Nathek de gu è diig gog niing ruii pha ji nyaniing mua ne bey? Niing mua, ithek è chang. ");
INSERT INTO bgg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Isu è ithek shii yao, “Zai nathek de guro gog duhug ji ne nyaniing mua phro,” “Jimagunde gu ne nasa shii guro phazoi nane phawig shii dug yi pha ji ne rangsua oi ro. Hì pha ithua ne guro Aphuii è hanyie shii saro phi jithek ro ro.” ");
INSERT INTO bgg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gai samoythek sua è ji pha chiang yoi mage shii, ithek ne khuiino nyi shii lijieg dun. ");
INSERT INTO bgg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ji-è, Isu ne ithek shii ò ho srane yao, “Gai Bran pha bohkhoh phothek ne ithek shii blu rek ruii phro, chiih-è, dumuiithek shii Sajathuathek um ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Chiih, ithek chung ne hì duiine rek pha ji ne adunmey phro. Nathek hanyie è boh rek pha yang arone, ai ne gai khiao rek bi chid phro; ");
INSERT INTO bgg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chiih-è, nathek hanyie è ibi rey yi pha yang arone, ai ne khiao rek bi chid phro, ");
INSERT INTO bgg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bran Dufuii ne aishii blia rek yi pha awuii ro, jishii bajo branthek shii blia rek ne awai chai phi srane pheg wuii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Isu nane samoythek è Jerikho thoh ne dun ramuii shii bran ibrog de ithek idoh shii luagieng. ");
INSERT INTO bgg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Miegthi pha bran nyi ne lumuii shii dug ne yoi shii Isu ne thiichiih shii dong ne luaramuii pha yoi mage ne ithek jao ne ziak, “Dawid Saja pha Dufuii wo! Gasa shii bushun rek phi bo!” Masdo! ");
INSERT INTO bgg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ibrog è ithek shii aro yi pha giung, jimagunde ithek ne lamuna gang ziak, “Dawid Saja pha Dufuii wo! Masdo! Gasa shii bushun now phi bo!” ");
INSERT INTO bgg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Isu è thiichiih thung srane isa shii ho. “Gu è nasa shii nyie rek phi bone yang ga?” Ai è isa shii sai. ");
INSERT INTO bgg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Isa è chang, “Masdo! Gasa ne gasa mieg ji doh din yi pha rek phi bo yang ro!” ");
INSERT INTO bgg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Isu è isa shii bushun rek srane isa mieg shii khoh phi; khthiie isa ne doh mua dun, chiih-è isa de ai idoh luagieng. ");
INSERT INTO bgg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Isu nane ai samoythek ne Jerusalem moe shii wuii thog, ithek ne Bethphach ithua Sumarothek Phiing shii wuii thog. Thiichiih shii Isu è awai samoy nyi shii hì pha miyao rog ");
INSERT INTO bgg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","shii ibi hà thoh ge: Ithek è ibi hà um pha thiig hà wuii dun bo: “Chiih-è thiisa hà nasa è awai iduii rog phiing ne ruii iang pha bambao doh ruii phro. Ji sey srane gu hà noh ruii bo. ");
INSERT INTO bgg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Chiih-è hanyie è nyie yao ruii arone, aishii yao bo, ‘Masdo è chiid muii ro’; chiih-è chiihphado ai è nasa shii bambao jithek jog phi ne thoh ge phro.” ");
INSERT INTO bgg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hì thek rey ruii pha ne chaig miyao ji izai rey yi phro: ");
INSERT INTO bgg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jion rajan shii yao bo, Riig bo, nathek saja ne nathek shii wuiiramuii ro! Ai ne bajo jum rek ne bambao lakhung shii in ne wuiiramuii chiih-è bambaoduii pha bambao lakhung shii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ji-è, samoy de wuii dun, chiih-è, Isu è ithek shii khi-èrek bo è yao pha ji rek. ");
INSERT INTO bgg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ithek è bambao nane bambaoduii ji noh thog ruii. Ithek è awaithek yungthek gophi, Isu de ji pha lakhung shii in dun. ");
INSERT INTO bgg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Boh bran ibrogthek è ai lumuii shii awaithek yung wiao phi, giak è hingmuii irab che ne wiao phi. ");
INSERT INTO bgg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bran ibrog ne Isu ro ibi idoh shii luagieng, chiih-è, Isu idoh shii lua pho è jao ne ziak, “Dawid Saja pha Dufuii shii chiong bo! Hanyie yi Ithong ibeng è wuii pha ji shii ne Hamangkhung-aphuii è khirzey phi ro! Hamangkhung-aphuii shii chiong bo!” ");
INSERT INTO bgg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Isu è Jerusalem shii khud mage shii, ji pha rajan shii bajo pho ne sam diig ne sai. “Ai ne hanyie ga?” Branthek è sai. ");
INSERT INTO bgg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Hì ne Galili pha Nazareth chaig Isu ji ro!” Bran ibrog è chang. ");
INSERT INTO bgg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Isu ne Misiahò hà wuii srane hanyie thek è thiichiih shii chongjai rekpho shii fuang gieng muii. Ai è bang giong pha thiibliiethek nane pharo chong rek pha murothek reng ne fen maphi. ");
INSERT INTO bgg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Chiih-è ithek shii yao, “Hamangkhung-aphuii è yao pha jigigam shii zey ne um ro, ‘guro Misiahò ne misiasia pha hò ro.’ Jishii ithek è mugo pho ug pha ithua rab muii ro!” ");
INSERT INTO bgg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Miegthi pho nane laikhi-èg pho è Misiahò hà ai moe shii wuii thog ruii. Ai è ithek shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Boh phabithek nane Iphey yua pha masdothek ne ai è wiengphleg pha bliathek nane aniphiing è Misiahò shii Dawid Saja Dufuii boh rone è yao ramuii pha ji doh ne bajo lijieg dun. ");
INSERT INTO bgg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ji-è, ithek ne Isu shii sai, “Na de ithek è nyie yao ramuii pha ji yoi chak bey?” Isu è chang, “Gu de yoi chak ro.” “Nathek ne hì pha jigigam ji atham riig bey? Nathek ne aniphiing nane aniphiing shii wie è chiong pha yua jong.” ");
INSERT INTO bgg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Isu è ithek shii thoh marui ne Bethany rajan hà wuii thog ne ji pha habiu thiichiih men marui. ");
INSERT INTO bgg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jipha thimiang riang duiine shii Isu è rajan hà wuiiramuii shii, Isu ne chi-iy ruii. ");
INSERT INTO bgg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ai è iphem hingmuii jia lumuii moe shii um pha doh ne ji pha iphem hingmuii shii wuii dun, jimagunde ji shii nyie de oi pha irabthek um bie iang, ji-è, ai ne hingmuii ji shii yao, “Na ne khuchung de iwoi awoi sha phro!” Ji è yaodang pha ji shii ji pha iphem hingmuii ne gow dun. ");
INSERT INTO bgg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Samoythek è ji doh mage ne zab wiengphleg dun. Ithek è sai, “Khi è rek ne ji pha iphem hingmuii ne ribjia gow dun phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isu è chang, “Gu ne nathek yao, nathek ne migi now ne ìujia de athan arone, nathek de gu è hì pha iphem hingmuii shii rek pha duiine nyarek mua phro. Hì jia asi pha yi nathek ne hì pha phiing shii nyayao mua.” “Hùg ne khamuii hà chiih dun bo è yao ne de ji nyarey dun. ");
INSERT INTO bgg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nathek è migi now arone, nawaithek è sia ne nyie lia pha ji phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Isu idoh Misiahò shii thog srane jao ne yao; chiih-è ai è yua pha duiine, boh phabithek nane dukhothek aishii wuii srane sai, “Na shii nyie rangsua um ne hìthek rek phlei? Na shii ne hìthek rek pha rangsua ne hanyie è phi lei?” ");
INSERT INTO bgg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isu è ithek shii chang, “Gu de nathek shii musai jia sai phro, nathek è gu musai ji chang phi arone, Gu de nathek shii hìthek rek pha rangsua ne khi è mua pha ji yao phi phro. ");
INSERT INTO bgg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon è khowo phi pha rangsua ne khi è thog phlei? Ji ne Hamangkhung-aphuii re-è phi nebey asi pha yi tharothamang re-è phi ne bey?” Ithek ne awaithek chung jao ne khiinaing rai, gethek ne khi è yao sha pha lei? Gethek è Hamangkhung-aphuii re-è phi rone chang arone, ai ne gethek shii yao ruii phro, “Ji arone, nathek ne Jon shii nyie rek ne migi anow ga? ");
INSERT INTO bgg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jimagunde, gethek ne tharothamang re-è phi rone yao arone, branthek è gethek shii nyie rek pha ji rum muii ro, nyieliieshii, branthek ne Jon ne chaig rone thieg noh dun ro.” ");
INSERT INTO bgg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ji-è, ithek è Isu shii chang, “Gathek ne athieg ro!” Chiih-è ai de ithek shii yao, “Gu de nathek shii hìthek rek pha rangsua khi-è mua pha ji ayao phi.” ");
INSERT INTO bgg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Thuh, shii nathek ne nyie now ga? Luangjia shii bran jia shii dufuii nyi um. Aphuii è Dufuii chai shii wuii srane yao, gu Dufuii! Sudoh inai na raig hà wuii srane blia rek mage bo. ");
INSERT INTO bgg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dufuii chai ji è chang, “Gu ne arek yang ro! Jishii, idoh awai lubu lai ne raig rek pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chiihphado, aphuii ji-è, dufuii jia shii wuii srane ji è rek ne yao, dufuii jiè chang, ‘Oh, Masdo’ rone chang jishii ai ne raig rek pha awuii. ");
INSERT INTO bgg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Isa nyi hanyie è awai aphuii è yang pha ji rek phi lei?” Ithek è chang, “Dufuii chai,” ji è rek phi ro. Ji-è, Isu ithek shii yao, gu ne nathek shii yao: mijin thanpho nane siulao rek pho ne Hamangkhung-aphuii pha Sajathua shii nathek ibi dun ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon khowo phi pha ji è nathek shii lumuii izai ji yao habuii shii nathek è aishii migi anow phi; Jishii, mijin thanphothek nane siulao pho è aishii migi now dun. Nathek hì doh pha rangde nawaithek khani lai ne aishii migi anow ro. ");
INSERT INTO bgg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Isu è yao, “Gai najang de nuii mage bo.” Luangjia shii sohmuspho è awai raig shii angurgmuiithek hai ne muthua gun srane angur phuii rey yi pha angur chui pha icho jia jog, chiih-è, ji khan pha haliig jia rung. Chiih-è, ai è raig rekpho shii chei marui ne thoh ne awai lumuii hà luadun. ");
INSERT INTO bgg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Angur ji khrab pha ishak thog ruii shii, ai è awai khiaothek shii raigkhan pho shii awai chiang yie pha thoh ge. ");
INSERT INTO bgg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yamiing khanpho è ai khiaothek shii zum srane giak shii ne zuang muii, jia shii ua muii, jia shii lubao chao maphi. ");
INSERT INTO bgg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jipha idoh è bran è gai khiaothek ibi è de bajo khiao shii thoh ge, jithek shii de raig khan pho è ibi pho thek duiine rek phi. ");
INSERT INTO bgg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Idohhè awai dufuii shii ithek hà thoh ge. Ai è yao, Zai ithek ne guro dufuii shii ne ilab rek. ");
INSERT INTO bgg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Jishii, raig cheipho è dufuii shii doh mage shii, ithek ne awaithek chung yao rai, hì ne muspho ro dufuii ji ro. Thawuii bo, cho gethek ne aishii ua muii haro, chiih-è airo nuruii ne gethek mua ruii phro! ");
INSERT INTO bgg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ji-è, ithek ne aishii zum srane raig ji è fuang fen muii ne chiih-è ua maphi. ");
INSERT INTO bgg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Isu è ithek shii sai, “Jipha raig muspho thog ruii shii, ji pha muspho è jithek pha raig cheipho shii nyie rek ruii phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ithek è Isu shii chang, “Jipha muspho è ithek shii ua mua ne ji pha angur raig ne fuang pha raigkhanpho shii phi muii phro, ji ne ishak thog shii gui mathang khriig phi pha gai raigkhan pho so ne khan yi phro.” ");
INSERT INTO bgg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isu è ithek shii yao, Nathek ne jigigam shii nyie yao pha ji atham bey? Rungpho è lubao shii Adunmey rone snai muii pha ji ne zab è de bajo miigak lubao rey dun ro. Hì ne Ithong è rek phi ro; Hì ne khama khie doh pha blia ro! ");
INSERT INTO bgg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Isu è yao din, “Ji-è, gune nathek shii yao phro,” “Hamangkhung-aphuii ro Sajathua ne nathek è riao srane hanyie bran è iwoithek wie woi pha ji shii phi muii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hanyie è ji pha lubao lakhung shii chiih arone, ji pha lubao è aishii ne dum dum khiia thiak dun phro; chiih-è, hanyie lakhung shii ji pha lubao chiih ruii nede, ji pha bran ne lubao ji è doh ne nyiak phlab rey dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Boh phabithek nane Pharisithek ne Isu è najangthek yao pha ji ne ithek chiang yao phrone thieg dun. ");
INSERT INTO bgg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ji-è, ithek ne Isu shii zum pha rek, Jishii, Isu ne chaig rone now pha bran ibrog um pha ji shii rum dun. ");
INSERT INTO bgg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Isu è dinne najangthek è branthek shii yao. ");
INSERT INTO bgg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Hamangkhung pha Sajathua ne hì duiine ro: Luang jia shii, saja jia è awuii dufuii pha phiyiy michie saro phi. ");
INSERT INTO bgg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ai è awai khiaothek shii phiyiy hà wuii yi pha biwenthek ho pha thoh ge, jimagunde ithek ne awuii yang phi. ");
INSERT INTO bgg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ji-è, ai è gai khiaothek shii hì pha mua rog biwenthek hà thoh ge: Thuh shii gu michie ne ideb sha ro; Guro rawoithek nane igong um pha suwuiiduiithek ua jong muii ro, chiih-è zab ne ideb sha ro. Phiyiy pha michie shii wuii mage bo! ");
INSERT INTO bgg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jishii, ho pha biwenthek ne ji anuii pha awaithek pha chongjai hà wuii dun; jia yi awai raig hà wuii marui, gai jia è awai chongjai hà wuii marui, ");
INSERT INTO bgg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","giak è ai khiao shii zum srane zuang ne ua muii. ");
INSERT INTO bgg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jipha saja ne bajo lijieg dun, ji-è, ai ne awai siphahithek thoh ne hanyiethek è rek jipho shii ua ne ithek rajanthek de zab ziao muii. ");
INSERT INTO bgg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chiihphado, ai è awai khiaothek shii ho srane ithek shii yao, guro phiyiy michie ne ideb sha ro, jishii gu è ho pha bran ji shii phi mua sapho asi ro; ");
INSERT INTO bgg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","thuh shii boh lumuiithek hà wuii ne khama pha bran ithek è doh pha ji shii ho mage. ");
INSERT INTO bgg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ji-è, khiaothek è fuang wuii srane lumuiithek hà khama pha bran doh muii pha ji, wie awie miapho shii khrab ne, chiih-è, phiyiy hò shii bran è zab ley ched dun. ");
INSERT INTO bgg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Saja ji è bucho wuii ne biwenthek ji shii riig ne, chiih-è ai ne bran jia ne phiyiy yungthek aguii pha doh ro. ");
INSERT INTO bgg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Saja ji è sai, “Gu ijak wo! Na ne phiyiy yung aguii pha ichiih shii nyie rek ne wuii phlei?” Jishii bran ji è nyie de ayao phi. ");
INSERT INTO bgg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chiihphado Saja ji è awai khiaothek shii yao, “Aishii ne lai nane wad joi mua bo, chiih-è fuang pha igiia hà fen muii bo. Thiisa hà ai ne choh ne shinyin khriieg ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Isu è yao ched, “Bajo shii ho, jimagunde gua pha ji ne ìujia bie ro.” ");
INSERT INTO bgg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pharisithek dun srane musaithek rog Isu shii phang pha phak rai. ");
INSERT INTO bgg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ji-è ithek è awaithek ro samoythek nane Herod ro branthek shii ai hà thoh ge. “Masdo,” ithek è yao, “Gathek ne thieg nane izai yao. Na ne Hamangkhung-aphuii ro yang pha izai ji yua phi, gai munow shii ne nyie de samadiig ro, nyieliieshii nane gaithek shii boh ìu ariig ro. ");
INSERT INTO bgg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gathek shii yao bo, chiihphado, nane nyie now ga? Roman saja shii mijin than pha ji ne gethek Iphey shii gidieg ba, asi ba?” ");
INSERT INTO bgg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Isu, ithek ro awie pha muphak ji thieg, chiihphado ai yao, “Nathek lawasdai! Nathek gushii nyie um ne ibongbong phlei? ");
INSERT INTO bgg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mijin shii phi pha sikhi ji gushii riig yi bo!” Ithek è sikhi ji aishii yi ne phi, ");
INSERT INTO bgg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","chiih-è ithek shii sai, “Hìthek ne hanyie mizia nane ibeng lei?” ");
INSERT INTO bgg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ithek è chang. “Bisiu ro.” Ji-è Isu è ithek shii yao, “Wie, chiihphado, nyie Bisiu ro ji Bisiu shii phi mage bo, chiih-è nyie Hamangkhung-aphuii ro ji ne Hamangkhung-aphuii shii phi mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ithek ji yoi mage shii, ithek ne wiengphleg dun; chiih-è ithek aishii thoh marui ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jipha ò inai shii giak Sadusithek Isu shii wuii ne iy pha bran ne ahòi din phrone yao. ");
INSERT INTO bgg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Masdo,” ithek è yao, “Moses è yao hò-aphuii hanyie è ani agiak pha iy dun arone, awai khuiino misiungmuii shii yiy chid srane ani giak pha ji ne iy dun pha hò-aphuii ro ani rey bo. ");
INSERT INTO bgg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Thuh shii, khuiino miley ichiih shii rai. Abam ji è yiy srane ani oi pha iy dun, jiè misiungmuii jine ikhuii shii thoh marui. ");
INSERT INTO bgg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ji duiine din pha ikhuii shii de irey, chiih-è uom pha khuiino shii irey, chiih-è mileynoi pha khuiino shii de irey dun. ");
INSERT INTO bgg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Idohhè shii zab irey dun. Jipha hò-amuii de iy dun. ");
INSERT INTO bgg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Thuh shii, iy pha ji è chai hòi inai shii, ai ne hanyie yiy rey phlei? Ithek zab è aishii yiy.” ");
INSERT INTO bgg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isu è ithek shii chang, “Nathek ne khama adunmey pho ro nyieliieshii ithek ne jigigam nane Hamangkhung-aphuii ro blu athieg ara ro. ");
INSERT INTO bgg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chiih-è iy pha ji chai sieng mage shii, ithek ne hamangkhliiethek duiine chiih-è ayiy rai phro. ");
INSERT INTO bgg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Thuh shii, iy pha ji chai sieng ruii pha chiang shii: Hamangkhung-aphuii è ithek shii nyie yao pha ji ne nathek atham riig bey? Ai è yao, ");
INSERT INTO bgg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Gu ne Abraham ro Hamangkhung-aphuii, Isakh ro Hamangkhung-aphuii, chiih-è Jakhob ro Hamangkhung-aphuii ro.’ Ai ne isieng Hamangkhung-aphuii ro, chiih-è iy pha Hamangkhung-aphuii ro asi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iphiing è ji yoi mage shii, nathek ne ai muyua jishii wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Isu è Sadusithek shii aro yiedang pha rek muii rone pharisithek è yoi mage shii, nathek ò wuii, ");
INSERT INTO bgg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","chiih-è nathek è jia, Iphey yua pha Masdo jia yi, musai rog aishii phang yi pha bidiang. ");
INSERT INTO bgg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Masdo,” Ai è sai, “Iphey shii zab è boh muyung nyie lei?” ");
INSERT INTO bgg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isu è chang, nawai Ithong Hamangkhung-aphuii shii nawai lubu è miie bo, nawairo zab ragung rog è miie bo, chiih-è nawairo zab khani rog è miie bo. ");
INSERT INTO bgg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jine zab è boh nane zab è mugak muyung ro. ");
INSERT INTO bgg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Din pha zab è boh muyung hì ro: Nawai shii miie pha duiine nawai hadung-haluii pho shii miie bo. ");
INSERT INTO bgg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses ro Iphey nane chaigthek muyua jine hì pha muyung nyi è luthong phro. ");
INSERT INTO bgg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Giak Pharisithek ò shii khrab mage shii, Isu è ithek shii sai, ");
INSERT INTO bgg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Masi chiang shii nathek nyie now lei? Ai ne hanyie ro riing lei?” “Ai ne Dawid ro riing ro,” ithek è chang. ");
INSERT INTO bgg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Chiihphado, nyie,” Isu è sai, Dawid shii Ithong ho phane Dawid shii ragung è thoh ne bey? Dawid è yao, ");
INSERT INTO bgg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ithong è gu Ithong shii yao: Gu è na shuangthek shii naro lai iliing hà aruii sapho shii ne Ichiih gu phazoi shii dug bo. ");
INSERT INTO bgg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Chiihphado, Dawid è aishii ‘Ithong,’ rone ho arone, nyie khi-èrek Masaiya ne airo riing rey mua phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hanyie jia è de Isu musai ji achang mua, chiih-è ji pha idoh è hanyie de aishii musaisai pha lubu boh arek mua. ");
INSERT INTO bgg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","BH Chiihphado Isu è bran ibrog nane awai samoythek shii yao, ");
INSERT INTO bgg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Iphey yua pha masdothek nane pharisithek ne Moses pha Iphey yua ne rai pha riichai phi ne ruii ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ji-è, nathek ne ithek muyua jithek nuii ne rek bo; Jishii, ithek mirek jithek nui ne arek rabo, jimagunde, ithek ne nyie yua pha ji ne awaithek ne arek ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ithek ne branthek pha phadung shii miihan ahan mua pha han yi srane awaithek ne wad ìujia de miihan shii khoh ne anong gieng ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ithek ne awaithek shii branthek shii doh yi pha rek ne rai ro. Ithek ne awaithek shii doh yi pha yung shii jigigam zey ne khrug nane phaliing shii miak phro! ithek ro yung khama boh ji doh yi! Chiih-è ithek ro rugud pha mirgong ji bajo phiang guii rone riig yi! ");
INSERT INTO bgg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ithek ne michie chie pha ishak shii de ithua wie gua ne dug, Jewthek misiahòthek shii de ong ne ruii pha biangthek shii dug; ");
INSERT INTO bgg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ithek ne branthek è ithek shii bajaraithek hà ilab phi ne masdo rone ho pha ji wie now. ");
INSERT INTO bgg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nawaithek chung ne Masdo Nyieliieshii ithek ne khuiinothek ro chiih-è ithek masdo ne jia bie ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chiih-è, ithek ne ichiih sohnyiak shii hanyie shii de aphuii aho rabo, nyieliieshii, nathek ro Aphuii ne hamang pha Aphuii jia bie ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chiih-è, nawaithek chung dumuii de aho rabo, nyieliieshii, ithek ne ò bie ro, chiih-è, nathek pha dumuii ne Masi bie ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nathek duchoi shii hanyie ne zab è boh rek pha now arone, zab ro khiao rek bi bo. ");
INSERT INTO bgg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hanyie è awaishii boh rek ne rai arone aishii ne ìu rey yi phro, chiih-è, hanyie ne ìu rek ne rai arone, aishii ne boh rey yi phro. ");
INSERT INTO bgg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Iphey yua pha masdothek nane Pharisithek wo! Nathek shii ne khama buii thog ruii ro, Lawasdai nathek wo! Nathek è hamangkhung pha Sajathua pha habin ne branthek pha mizia shii kheb muii ro. Chiih-è, nawaithek de ji pha bucho shii akhud, branthek shii de ji pha bucho shii akhud yi. ");
INSERT INTO bgg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Iphey yua pha masdothek nane Pharisithek wo! Nathek ne khama buii mua ruii phro! Lawasdai pho nathek wo! Nathek ne misiungthek shii lai dia ne ithek hò wuii srane ithek manathek riao ne yie maphi ro. Ji è rek nede ithek ne bajo phiang sia pha doh yi ro. Jiphachiang è ithek shii ne zab è awie lago phi ruii phro! ");
INSERT INTO bgg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Iphey yua pha masdothek nane Pharisithek! Lawasdai nathek! Nathek shii khama buii thog ruii phro! Nathek è jia shii yang ne noh pha, khamuiithek hiìa ne zab pha thiigthek hà wuii phro, chiih-è nathek è ji rek mua dun nede, nawai è ji pha bran shii nawaithek rog shii thumuluii hà dun sbo dinne de nyichiieng rek yi ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Miegthi dumuii nathek wo! Nathek ne khama buii mua ruii phro. Nathek è yua ne rai,” Hanyie è Misiahò pha ibeng è surua thak arone ai ne ji pha surua è achun din phro, jimagunde hanyie è Misiahò san ibeng è surua thak arone ji pha surua è awaishii chun din phro. ");
INSERT INTO bgg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Miegthi bi-ìe nathek! Khi pha muna yi bajo so ba ga? San ba asi pha san shii so pha Misiahò ji bey? ");
INSERT INTO bgg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nathek è hì de yau ne ruii ro, “Hanyie è sraibao pha ithua pha ibeng è surua thak arone, ai ne ji pha surua è achun din phro; Jishii, ai è sraibao pha ithua shii zud pha lasen ibeng è surua thak arone, ai ne ji pha surua è chun din phro.” ");
INSERT INTO bgg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nathek ne khama pha miegthi pho ga? Khi pha muna yi bajo chid pha muna ga? Sraibao shii zid pha lasen ba bey? Asi pha yi lasen shii so rab pha sraibao ji bey? ");
INSERT INTO bgg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ji-è, khuchung magunde, bran jia è sraibao pha ibeng è surua thak arone, ai ne sraibao pha ithua phi pha lasen ibeng è de surua thakjong ro; ");
INSERT INTO bgg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","chiih-è, khuchung magunde ai è Misiahò pha ibeng è surua thak arone, ai ne thiichiih rai pha Hamangkhung-aphuii ibeng è surua thakjong ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chiih-è, khuchung magunde giak è hamangkhung pha ibeng è surua thak arone, ai ne Hamangkhung-aphuii hanyie è ji pha biang boh pha dug pha ibeng è de surua thak ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Iphey yua pha masdothek nane Pharisithek! Lawasdaithek wo! Nathek shii khama buii thog ruii pha um ro! Nathek ne iwoikhabua, phadina, buzo, wieng ji è biiriie sua yie ne Hamangkhung-aphuii shii phi magunde ithek ne Iphey shii bajo chid pha muyua, ji ne wie che pha, bushun rek pha, isiie rek pha muyuathek rone anuii ro. Ji-è ithek ne gai shii de asnai pha nyi-minyie shii nui ne rek chid phro. ");
INSERT INTO bgg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Miegthi dumuiithek wo! Nathek ne nawaithek gog è mujo chiing muii, jishii nathek ne yua phiang suduii shii ne min muii! ");
INSERT INTO bgg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nathek shii ne khama diig phro, Iphey yua pha masdothek nane Pharisithek wo! Lawasdai nathek! Nathek ne nawaithek gogthek nane shiikhiiathek ne fuang hà sud, jimagunde iliing hà ne mak rek pha nane iwed è ley ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Miegthi Pharisithek wo! Gog bucho hà nyie um pha ji sud bi bo, chiihphado fuang pha ji è nyasow dun phro! ");
INSERT INTO bgg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nathek shii ne khama diig thog ruii phro! Iphey yua pha masdothek nane Pharisithek wo! Lawasdai nathek wo! Nathek ne wieng shii chun shun pha duiine ro, fuang hà ne bajo khie doh jimagunde iliing hà ne izaingthek nane ishongthek um ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ji duiine, fuang hà nathek ne zab shii wie dong phi, Jishii iliing hà ne ley Lawasdai nane layogthek um ro. ");
INSERT INTO bgg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Khinyama diig thog ruii phro! Iphey yua pha masdothek nane Pharisithek wo! Lawasdai pho nathek wo! Nathek ne chaigthek shii wiengthek khie rab phi, chiih-è, hanyie è wie sieng pho shii now yi pha wieng shii wie midong shii chia ne rab phi; ");
INSERT INTO bgg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","chiih-è, ithek ne yao, gathek de guithek blangthek sieng pha ishak shii sieng arone gathek ne ithek duiine chaigthek shii a-ua phro. ");
INSERT INTO bgg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nathek ne nawaithek shii chaigthek shii ua pho pha riingthek rone nuii muii ro! ");
INSERT INTO bgg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chiihphado nawaithek blangthek mujau marui pha ji jong pha rek bo! ");
INSERT INTO bgg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nathek phamthek nane phamthek pha anithek wo! Nathek ne thumuluii dun yi pha nin pha ji è khi-èrek ne yo mua pha luthong phlei? ");
INSERT INTO bgg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ji-è gu ne nathek shii yao dang phro, gu è nathek shii chaigthek nane khua pha bran nane masdothek thoh ruii phro; nathek è ithek giak shii ua muii phro, giak shii zun muii phro, chiih-è, giak shii Jewthek misiahòthek shii zuang srane nathek shii thawun hà gieng muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jiphachiang è ichiig oi pha Abel shii ua muii pha ji yie ne nathek è Berachiah pha dufuii Zekharia hanyie shii Misiahò nane sraibao pha duchoi shii ua muii nathek ne khama sgoh rek pha ji ne lago ne nathek lakhung shii chiih ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gu ne nathek shii izai yao dang phro: jithek sgow pha zab lago ne duchung pha branthek lakhung shii chiih ruii phro! ");
INSERT INTO bgg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem, Jerusalem! Nathek è chaigthek ua muii chiih-è Hamangkhung-aphuii è nathek shii thoh pha muapho shii de lubao chao nyia muii! Khemuii è awai iduiithek shii awai iyig hà phiig pha duiine gu khama chiieng gu ne nathek branthek shii gu wad è giak phi pha yang, Jishii nathek gu shii arek yi ro! ");
INSERT INTO bgg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ji-è, nathek ro Misiahò thoh muii ne isoloi rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Thuh è thiwing, gu nathek shii izai yao phro: Hanyie yi Ithong ibeng è wuii pho aishii ne Hamangkhung-aphuii è khirzey phi bo, ji ayao sapho shii ne sudoh nathek ne gu shii khuchung de adoh phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Isu è Misiahò ji thoh ne dundun, airo samoythek aishii wuii thog ne Misiahò ji shii riig yi. ");
INSERT INTO bgg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ai è yao, “Ji chak ro, nathek ne zab hì shii wie riig bo. Gu ne nathek shii hì yao: lubao jia de ichiih pha ithua shii khim ne arai phro; jithek zab shii ne buzam chiih ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Isu è sumaro phiing shii dugdun, airo samoythek ne ug ne aishii wuii thog ruii. Ithek è sai, “Gathek shii yao phi bo, hìthek ne khuchung rey ruii phlei, chiih-è, hì ne na wuii ruii pha ishak nane idam jong sha rone doh yi pha nyie rey ruii phlei.” ");
INSERT INTO bgg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isu è chang, nawaithek shii ragia rek bo. Chiih-è nathek shii hanyie è de khinrin arek yi rabo. ");
INSERT INTO bgg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bajo branthek ne gu chiang è wuii ne yao phro, gu ne Masi ji ro! Chiih-è ithek bajo bran shii khinrin ruii. ");
INSERT INTO bgg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nathek è inui shii makthek rek pha gow yoi ruii phro, chiih-è ruang hà makthek rey pha muathek yoi ruii phro; jimagunde diig anow chid rabo. Jithek ne rey chid phro, Jishii ji pha miyaosiu è ne jong pha ishak thog ruii rone ayao ro. ");
INSERT INTO bgg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sohnyiak chung ne mak rek rai phro, chiih-è, Sajathua chung de mak jo rai phro. Jipha ishak shii ne zab hà nokhoniisai nane sajidthek de sham ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jithek ne ani giak pha igobi pha miiriie duiine ro. ");
INSERT INTO bgg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jipha idoh è de ithek shii zum ne lago phi srane ua muii pha phi muii phro. Zab branthek gu chiang è nathek shii khiijai ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bajo branthek è ji pha ishak shii awaithek migi ji thoh muii phro. Ithek ne awaithek chung khinrin, chiih-è, awaithek chung khiijai rai phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Khlam pha chaigthek bajo khia khlei ne branthek shii khinrin ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hì duiine awie pha ji shiiy ruii ne branthek ro miie ne chiie rek muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jishii, hanyie è iidohhè thog dang pha rai pho ne ragia rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sajathua pha Mua Wie hì ne zab sohkhung pha zab branthek khagi rek yi pha yua phro: chiih-è jong pha ishak thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Chaig Daniel miyao yao ithek ne Zianakhuruii midong doh ruii phro. Ji ne ithua so shii riu ruii phro.” (Tham pho shii zey bo: hì pha miyaosiu ne wie thieg yi ro!) ");
INSERT INTO bgg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Chiihphado hanyie Juda shii um pho ne phiingthek hà ran ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bran hanyie yi shaphiing hà um iang pha ji è hò è awai manathek yie pha de thazam alung rabo. ");
INSERT INTO bgg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bran hanyie ne raig hà um iang pha ji è hò dun ne awai yungthek yie pha awuii rabo. ");
INSERT INTO bgg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jithek pha ishak shii ne ani wiig pha nane ani ìu um pha hò-amuiithek ne khama diig rey ruii phro! ");
INSERT INTO bgg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nathek ne hakhangshak shii chiih-è Jewish Thung pha Inai ayao ched sapho Hamangkhung-aphuii shii sia mage bo. ");
INSERT INTO bgg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jipha diig ishak ne soh jao pha è yie dang ne sudoh thog dang pha diig reyjong pha ji è de awiedang pha diig ji thog ruii phro. Ji duiine dinne khuchung de arey phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jishii, Hamangkhung-aphuii è ji pha inaithek ne dum rekjong ro. Jipha inai dum arek arone hanyie de asieng mua phro. Ji ne nyieliieshii gua pha awai branthek chiang è Hamangkhung-aphuii è ji pha inai ne dum rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Chiihphado, hanyie è nathek shii yao” Riig mage bo, ichiih shii Masi um ro chiih-è thiisa hà ai um rone yao ruii magunde ji migi arek rabo. ");
INSERT INTO bgg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chiih-è biidiie Masithek nane biidiie chaigthek dong ruii phro; rek mua arone, ithek ne boh buangthek nane wieng pha blia rek ne Hamangkhung-aphuii mugua pha bran shii khinrin ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yoi bo! Gu nathek shii hì ne ishak athog ba pha ibi shii yao. ");
INSERT INTO bgg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Din ne, bran è nathek shii yao ruii, riig bo, ai ne bali shii um ro—Thiisa awuii rabo; dinne ithek yao ruii, riig bo, ai ne ichiih hà ug muii ro—Migi arek rabo. ");
INSERT INTO bgg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chiih-è haliao yi zab hamang pha bichiu è hayang thog dang pha bliak pha duiine Bran Dufuii wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Khi hà siu iy um, ji hà ne biichiing khrab ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Khthiie jithek pha diig inai idoh, hasiang ne igiia rey dun, habie ne achuang sha phro, chiih-è dadiang ne hamangkhung re-è chiih dun phro, chiih-è hamangkhung pha bluthek ne awai ithua è gieng muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bran Dufuii pha cheb ne hamang hà dong ruii phro; chiih-è Bran Dufuii yi hamangkhung pha sakhamiingthek è blu nane bajoboh biisiie rog shii wuii ruii shii zab pha sohnyiak pha zab branthek ne ji riig ne cho ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chiih-è ben rone, ai ne awairo hamangkhliiethek shii sohnyiak pha ijiu wi shii thoh ne, ithek è ai mugua pha bran shii ne soh jia jong pha ji è gai soh thog pha khrab ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Iphem hingmuii è nathek shii muyua yua yi bo. Idiphakthek yi irey nane inyiu rey mage shii, chiih-è jao ne irab rey khlei ruii shii, nathek ne haluadam ne inui rone thieg. ");
INSERT INTO bgg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ji duiine, nathek è jithek zab riig mage shii, jao sha pha ishak ne deb rey ne inui sha rone nathek ne thieg. ");
INSERT INTO bgg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Now bo thuh shii sieng pha branthek iy pha ibi shii jithek zab rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hamangkhung nane sohnyiak ne san dun phro, jimagunde gu miyaogamthek ne khuchung de asan phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hanyie è de athieg phro, khi-èrek ne, khuchung inai nane ishak thog ruii—Hamangkhliie de athieg dinne Dufuii è de athieg mua phro, Aphuii ji jia è thieg bie ro. ");
INSERT INTO bgg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bran Dufuii wuii ruii pha ji ne Noah pha ishak shii nyie rey pha ji duiine ro. ");
INSERT INTO bgg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Khokhed pha inai ibi shii branthek ne chie niing ne rai, hò-aphuii hò-amuii ne yiygey rai, Noah yi run hà khrog pha inai thog pha; ");
INSERT INTO bgg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Khokhed ne zab shii shaodun pha ji thog dang pha nyie rey pha ji ne thuh de nathek ne athan ba ro. Ji-è Bran Dufuii wuii shii de ji duiine rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jipha ishak shii ne bran nyi ne raig shii blia ò rek phro: jia shii ne noh dun, gai shii ne thoh marui. ");
INSERT INTO bgg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hò-amuii nyi ne rathak ò shii shui rai: jia shii ne noh dun, gai shii ne thoh marui. ");
INSERT INTO bgg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nawai shii gayiig rek bo, jiè nyieliieshii nathek ne nawaithek Ithong khuchung pha inai wuii ruii pha ji ne athieg phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hò muspho è mugopho khuchung wuii ruii pha ishak thieg arone, nane nyayao mua ai ne sieng ne rai srane hò ji ne mugopho è agow yi phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ji-è chiihphado, nathek de idang saro ne rai bo, nyieliieshii Bran Dufuii ne nathek è aishii aluthong pha ishak shii wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Hanyie, chiihphado hì ne izai nane khua khiao bey? Hì ne jia ro ai masdo è gai khiaothek shii dumuii phi shii nathek ro michie yi khriig ishak shii phi yi pha. ");
INSERT INTO bgg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ai hò dun shii ai ji è rek ne rai pha Muspho è doh arone ji pha khiao shii ne khama sang ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Zai, Gu nathek shii yao, muspho è ji pha khiao shii ne awairo zab nuruiithek pha dumuii rab muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jishii ai ne awie pha khiao arone, ai è awai shii yao muspho wuii pha ne ishak bajo athog sha ruii. ");
INSERT INTO bgg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chiih-è ai ne awai ijak khiaothek shii jao ne zuang ne gui ne phuiithiig pho rog chie niing. ");
INSERT INTO bgg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Chiihphado ji pha khiao ro muspho yi khiao è aishii aluthong inai nane ai athieg pha ishak shii idoh dun ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Muspho è aishii zuang srane aishii ne lawasdaithek rog shii phi muii. Thiisa hà ai ne cho ne shiinyieng khriieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Jipha ishak shii hamangkhung pha Sajathua ne hì duiine phro. Luangjia hò-amuii miliao sua hanyie è awaithek ro ichuangthek pha thiiliie yi ne phiyiybufuii shii si pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ithek è guii yi bi-ìe, chiih-è guii yi khua ro. ");
INSERT INTO bgg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bi-ìethek yi awaithek ro ichuangthek ne yi jishii awaithek ro yo thiiliie ne ayie ro, ");
INSERT INTO bgg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","jishii khuathek ne awaithek ichuangthek pha thiiliie ne chab pha ji shii ley chab ne yi. ");
INSERT INTO bgg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Phiyiybufuii ne chia ne wuii thog, jiè hò-amuiithek ne jiing ne men dun. ");
INSERT INTO bgg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Hì ne habiu duchoi reyjong mage shii, ziak mage, ‘Ichiih ne phiyiybufuii um ro! Thawuii ne aishii si bo!’ ");
INSERT INTO bgg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hò-amuii sua sieng srane awaithek ro muchuangthek rab. ");
INSERT INTO bgg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chiihphado bi-ìe jithek è khuapho shii yao, nathek ro thiiliie gathek shii de ìujia phi bo, nyieliieshii gathek ichuangthek ne nyia sha pha rek ro. ");
INSERT INTO bgg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Asi, zai, khuathek è chang, ‘ichiih ne nathek nane gathek shii achoh phro. Nawaithek ne haphuii hà wuii ne pheg mage bo.’ ");
INSERT INTO bgg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ji-è bi-ìe hò-amuiithek ne thiiliie pheg pha wuii dun; chiih-è ithek wuii dun shii, phiyiybufuii thog. Ithek guii hanyie è saro ne wuii pho ne ai rog phiyiy pha michie hà wuii gieng, chiih-è habin ne kheb dun. ");
INSERT INTO bgg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Idoh shii gai hò-amuiithek de thog. ‘Masdo! Gathek shii de iliing wuii yi bo!’ ithek ne ho. ");
INSERT INTO bgg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Zai asi! Gu nathek shii athieg ro, Phiyiybufuii ji è chang.” ");
INSERT INTO bgg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chiih-è Isu è yao ched, nawaithek shii ragia rek bo, chiihphado nyieliieshii nathek ji pha inai nane ji pha ishak shii athieg phro. ");
INSERT INTO bgg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jipha ishak shii hamangkhung pha Sajathua ne ji duiine phro. Luangjia bran hanyie yi awai hò thoh ne awai lumuii hà lua sha pha rek shii; ai è awai khiaothek shii ho srane nuruii shii dumuii phi marui. ");
INSERT INTO bgg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ai è zab shii khi-èrek mua pha ji phi marui: ai è jia shii san sikhi itham guii phi, din pha jishii itham nyi, chiih-è din pha jishii itham jia phi. Chiihphado ai ne awai lumuii hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Khiao hanyie è itham guii sikhi mua pha ji ne wuii srane blia rek ne dinne itham guii wiangphi. ");
INSERT INTO bgg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ji duiine khiao hanyie è itham nyi sikhi mua pha ji itham nyi wiangphi. ");
INSERT INTO bgg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jishii khiao hanyie è itham jia sikhi mua pha ji è wuii srane nyiak shii icho jog ne awai muspho ro bang ne ug muii. ");
INSERT INTO bgg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bajo ishak pha idoh khiaothek ro muspho yi idoh dun thog ne ithek rog shii sasab rek rai. ");
INSERT INTO bgg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Khiao hanyie è itham guii sikhi mua pha ji è wuii srane chiih-è yo itham guii ji de phimuii. Na è gu shii ne itham sikhi phi, Masdo, ai è yao. Riig bo! Ichiih yo itham guii ji gu miwiang phi ro. ");
INSERT INTO bgg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wie rek, nane wie nane isiie khiao! Ai muspho è yao. Na ne sasab nane bang ìujia shii isiie rek, jiè gu ne nashii muna blia shii dumuii rek yi pha ro. Thawuii ne guro sang shii yigieng bo! ");
INSERT INTO bgg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chiihphado khiao hanyie shii itham nyi sikhi phi pha ji è wuii srane yao, na è gushii itham nyi sikhi phi, masdo. Riig bo! Ichiih pha yo itham nyi sikhi ji gu wiang ro. ");
INSERT INTO bgg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wie rek, na wie nane isiie khiao! Muspho è yao. Na ne sasab nane bang ìujia shii isiie rek, jiè gu ne nashii blia muna shii dumuii ruii phro. Thawuii ne guro sang shii yigieng bo! ");
INSERT INTO bgg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Chiihphado khiao hanyie è itham jia sikhi mua pha ji è wuii srane yao, Masdo, gune thieg nane bran sua; nane na è ahai pha ji yamiing shii de chiig, chiih-è nane na è ahai pha ji hà de iriie khrab. ");
INSERT INTO bgg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gu ne rumdun, jiè gu è wuii srane naro bang yi nyiak hà ugmuii. Riig bo! Ichiih ne naro ji um ro. ");
INSERT INTO bgg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Na ne awie nane shkhadajo pha khiao ro! Airo muspho è yao. Na ne thieg, gu ne khi hà yamiing ahai ji hà chiig, chiih-è khi hà igam ashiiy ji hà chiing ne bey? ");
INSERT INTO bgg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wie, chiihphado, nane gu bang ne bang chab bsa hà chab phi chid, chiih-è gu idoh dun din shii gui bang zab chodo ne idoh mua din. ");
INSERT INTO bgg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Thuh, bang ai è yi srane hanyie shii itham sua sikhi um pha ji shii phi muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chiih-è zab pha bran hanyie shii ìu um, aishii ne muna phi din, chiih-è aishii ne cho sapho um ruii; jishii hanyie shii nyie de oi dangpho shii ne ìujia um pha ji de yi muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ji-è ji pha adunmey pha khiao—aishii ne fuang pha igiia hà fen muii bo; thiisa hà ai ne cho ne shinyin khriieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Bran Dufuii yi Saja duiine wuii ruii shii chiih-è zab hamangkhliiethek ne ai rog shii phro, ai ne awai biisiie biang shii dug ruii phro, ");
INSERT INTO bgg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chiih-è zab sohthek pha branthek ne ai ibi shii khrab ruii phro. Chiihphado ai è ithek shii ibrog nyi shii chemuii phro, brogpho è Shiishai shii siphinthek è chemuii pha duiine phro. ");
INSERT INTO bgg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ai è giang bran shii ne awai phazoi hà ruii chiih-è gaithek shii ne phawig hà ruii muii phro. ");
INSERT INTO bgg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chiihphado Saja è awairo phazoi pha bran shii yao ruii phro, thawuii bo, nathek shii ne gu Aphuii è khirzey phi ro! Thawuii ne nyie yi soh rab pha ji è nathek shii saro phi pha Sajathua ji shii ong bo. ");
INSERT INTO bgg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gu chi-iyiy shii nathek è chie pha phi, gu gahang-hang shii nathek è gu shii niing pha phi; gu ne biwen shii nathek è gu shii ne nawaithek hòthek hà ho phi. ");
INSERT INTO bgg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Gu ne ikhilen shii nathek è gu shii guii phi; gu rad shii nathek è gu shii gayiig phi, phatheg hà um shii nathek è gu shii si wuii. ");
INSERT INTO bgg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Giangthek è ne aishii chang ruii, khuchung, Ithong, gathek ne na chi-iyiy shii chie pha phi phlei? Din ne gahang-hang shii niing pha phi phlei? ");
INSERT INTO bgg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Khuchung gathek ne na biwen shii hò hà ho phlei, din ne ikhilen shii na shii guii phi phlei? ");
INSERT INTO bgg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Khuchung shii gathek ne na rad ne phatheg hà rai pha ji doh ne wuii phlei? ");
INSERT INTO bgg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Saja è chang ruii, gu nathek shii yao, nathek è khuchung magunde guro dusho khuiinothek jia shii nong rek phi arone na è gushii rek phi ro. ");
INSERT INTO bgg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Chiihphado ai è awai phawig pha bran shii yao ruii, gu è dun dun bo, ithek zab ne Hamangkhung-aphuii ro thamiie pha iliing shii ro! Ibuii nane airo hamangkhliie shii saro pha idang pha bai shii fen muii phro! ");
INSERT INTO bgg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gu chi-iyiy shii nathek è achie yi, gahang-hang shii nathek è gu shii niing pha aphi; ");
INSERT INTO bgg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gu ne biwen shii nathek è nawaithek hò hà aho, ikhilen shii nathek è yung aguii phi; gu rad shii chiih-è phatheg hà chab shii nathek è gu shii gayiig arek phi. ");
INSERT INTO bgg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chiihphado ithek è aishii chang ruii, khuchung, Ithong, gathek è na chi-iyiy chiih-è gahanghang chiih-è biwen chiih-è ikhilen, chiih-è rad chiih-è phatheg hà doh phliie chiih-è na shii anong phi bey? ");
INSERT INTO bgg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Saja è chang ruii, gu nathek shii yao, nathek è dushoduii jia shii anong phi, jiè nathek è gu shii de anongphi. ");
INSERT INTO bgg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chiihphado jine idang pha lago thog ruii phro, Jishii giangthek ne idang pha chai hà dun ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Isu è jithek yua ched dang shii, Isu è awai samoythek shii yao. ");
INSERT INTO bgg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nathek ne thieg, “Danyi pha idoh shii, ne Hiìadun pha idoh ro, chiih-è, Bran Dufuii shii bai shii zun pha phi muii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ji-è, boh phabithek nane dukhothek ne Khaiaphas boh phabithek ro boh hò shii ò si rai. ");
INSERT INTO bgg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chiih-è, Isu shii ug ne zum srane ua mua pha phak rai. ");
INSERT INTO bgg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ithek è yao, “Gethek ne hì ne sai pha idoh shii arek pha um ro, branthek ne shuang rek ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Isu yi Bethany hà hìariie pha Simon hò shii um. ");
INSERT INTO bgg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Isu è michie chie ramuii shii, hò-amuii jia ne bajo igong chiid pha rem now pha ji jariie shii chab ne wuii thog. Ai è ai khrug shii thoi phi. ");
INSERT INTO bgg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Samoythek è ji doh mage ne lijieg dun. Ithek è yao, “Hìthek ne thaluii nyie rek muii phlei? ");
INSERT INTO bgg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hì pha rem now pha ji ne igong bajo shii chongliu srane ji pha bang ne dusho shii phi muii arone wie phro!” ");
INSERT INTO bgg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Isu è ithek miyao rai ji thieg ne, jiè ithek shii yao, nathek ne hì pha hò-amuii shii nyie um ne diig phi phlei? Hì ne ai è gu shii wie jia nane khie pha blia rek phi ro. ");
INSERT INTO bgg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Dusho ne nathek rog shii idang um gieng phro, Jishii, nathek ne gu rog shii idang oi gieng phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ai è nyie rek pha ji ne gu siu shii sumaro thoi phi ne gu wieng pha ji khriig rekjong phi ro. ");
INSERT INTO bgg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Thuh shii, gu ne nathek shii izai yao dang phro, “Sohjambling shii hanyie magunde hì pha mua yao shii ai mirek phi pha ji de aishii nowkhlei pha yao ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chiihphado Samoy snanyi è jia—Judas Iskharioth beng phaji yi boh phabithek shii wuii ne sai, ");
INSERT INTO bgg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","chiih-è sai, gu è Isu shii zum yi arone, nathek ne gu shii nyie phi phlei? Ithek è liiman sikhi sa-uom tham ne aishii phi. ");
INSERT INTO bgg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chiihphado è Judas ne Isu shii ithek shii zum ne phi pha chua wie mua yi pha riig ne rai. ");
INSERT INTO bgg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Igobi pha, Hiìadun pha ji shii phiia ajiie pha iweb chie shii, samoythek è Isu shii wuii srane sai, gathek shii naro Hiìadun pha ji chie pha iweb ne khi hà wuii srane saro pha yang lei? ");
INSERT INTO bgg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“Ai è ithek shii yao, Jipha rajan hà bran jia shii wuii” srane “aishii yao mage bo: masdo è yao ramuii ro; guro ishak ne thog sha ro; gu nane guro samoythek è Hiìadun pha ji ne na hò shii sai pha ro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Samoythek è Isu è khi è yao pha ji rek ne Hiìadun pha michie sai pha saro phi. ");
INSERT INTO bgg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Habjuang rey mage shii, Isu nane Samoy snanyi ne chie pha dug. ");
INSERT INTO bgg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chie pha ishak shii Isu è Yao, “Gu ne nathek shii yao, nathek è jia ne gu shii zum yi phro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Samoythek ne bajo zo ne aishii jia jia rek ne sai ruii, izai “Ithong wo! Ji ne gu asi bey?” ");
INSERT INTO bgg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Isu è chang, “Hanyie è ichiih gu rog shii awai iweb jo gieng pha jia è gu shii zum yi phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jigigam shii yao pha duiine Bran Dufuii ne iy dun phro, Jishii, Bran dufuii shii zum yi pha bran ji shii ne khama buii thog ruii phro! Jipha bran ne agiak liag arone wie liag phro!” ");
INSERT INTO bgg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zum yi, pha Judas è yao ruii. “Zai Masdo, ji ne gu shii yao pha asi bey?” Ai è sai. Isu è chang, “Nawai è yaodun ro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ithek è chie ramuii shii, Isu è iweb idum chiing srane laso phi pha sia srane phed ne awai samoythek shii phi. Ai è yao, “Hì choi ne chie mage bo; hì ne guro siu ji ro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chiih-è, ai è gog ji chiing srane Hamangkhung-aphuii shii laso phi ne ithek shii phi. Ai è yao, ");
INSERT INTO bgg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Hì ne gu ifai ro, hanyie Hamangkhung-aphuii è shiinyie nab phi pha ji ro, chiih-è gu ifai è noi ne layogthek shii khung phi phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gu ne nathek shii yao, gu ne hì pha phuii ne Aphuii pha Sajathua pha inai shii phuii iwo aniing ba sapho shii ne dinne khuchung de aniing din sha phro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chiihphado ithek ne ibai bai ne sumaro phiing hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chiihphado Isu è ithek shii yao, sudoh ibiu dang shii ithek zab yo ne gu shii ji thoh marui phro, ji rey pha ji è jigigam shii yao pha duiine ro, Hamangkhung-aphuii ne brogpho shii ua muii phro, chiih-è shiishai ibrog ji ne dayiingdayang dun dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jishii, Gu ne chai shii hòi din mage shii gu ne ithek ibi shii Galili hà wuii dun phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phithar è yao srane Isu shii yao, “zab è na shii thoh marui magunde gu ne na shii khuchung de athodang phro!” ");
INSERT INTO bgg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isu è Phithar shii yao, “Gu ne na shii izai yao dang phro, Khephuii a-ìo ba pha ibi shii na è gu shii athieg rone uom chiieng yao bi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Phithar è chang, “Gu ne narog iy pha um dun nede gu ne hì è rek ne khuchung de ayao phro!” Gai samoythek de ji è yao gieng. ");
INSERT INTO bgg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chiihphado Isu ne awai samoythek rog shii Gethsemane beng pha ithua hà wuii dun, chiih-è, ai è ithek shii yao, “Gu è sia pha wuii dun shii nathek ne ichiih shii rai iang bo.” ");
INSERT INTO bgg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ai è Phithar nane Zebedi pha dufuii nyi shii noh ne wuii dun. Thiisa hà aishii bajo duhug nane diig now pha ishak thogruii. ");
INSERT INTO bgg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Chiih-è ai è ithek shii yao, “Guro lubu pha bajo duhug ne gune choi muii ro. Ichiih shii rai ne gu rog shii athodang pha sieng ne rai bo.” ");
INSERT INTO bgg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ai ne ìujia thithe wuii srane awai mizia ne nyiak hà bam ne sia, “Gu Aphuii wo! Rek mua arone diig rek pha gog hì chiing maphi bo! Jishii gu munow ji asi pha yi nawai munow ji rek bo.” ");
INSERT INTO bgg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chiihphado ai samoy uom shii idoh dun ne riig shii samoy uom ne men dun pha doh ruii; chiih-è ai è Phithar shii yao, “Nathek uom ne ishak jia thog bie pha de gu rog riig ne arai mua bey? ");
INSERT INTO bgg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wie riig bo, chiih-è, chuajan hà achiih yi pha sia mage bo. Ragung è ne rek yang habuii shii, siu è arek mua phi ro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Isu ne din ne de wuii dinne sia, “Gu Aphuii wo! Diig pha gog hì ne gu è aniing sapho shii ne achiing mua phi arone nawai munow ji rek mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ai è idoh dun thog shii samoythek ne men ne um iang; ithek ne awaithek mieg ayang mua pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Din ne Isu è ithek shii thoh marui srane wuii dinne uom chiieng rey sha pha ibi pha miyaogamthek duiine yao ne sia. ");
INSERT INTO bgg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chiih-è, ai è samoythek shii dun ne yao, “Nathek ne thuh de men nane thung ne rai ba mua bey? Riig mage bo! Bran Dufuii shii zum ne layogpho ro blu shii phi muii pha ishak thog sharuii ro. ");
INSERT INTO bgg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sieng sha mage bo, cho gethek dun sha rai. Riig bo, gu shii zum yi pha bran um ro!” ");
INSERT INTO bgg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Isu ji è yao ramuii shii samoy snanyi shii um pha Judas thiichiih wuii thog. Ai rog shii boh phabithek nane dukhothek mutho pha bran ibrog ne migiang rog khamriie nane muchangthek han ne wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zum yi pha bran è branthek shii phrai ne yao ruii, “gu è khi pha bran shii khichiug pha ji ne nathek chiid pha ji ro, aishii zum bo!” ");
INSERT INTO bgg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas è Isu shii miang wuii srane, Masdo! Na rog shii “liijiing um bo è yao srane aishii khichiug phi.” ");
INSERT INTO bgg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isu è chang, “Gu ijak wo! Na ne ichiih nyie rek pha um phaji ne jog rek mage?” Ji è yao ched dang mage shii ithek è Isu shii zum ne phang muii. ");
INSERT INTO bgg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Isu rog um pha bran jia è awai khamriie khia srane Boh Phabi pha khiao jia ro khoh wiagthiak maphi. ");
INSERT INTO bgg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","“Nawai khamriie ne irung shii chab din muii bo, zab hanyie è khamriie khia pho ne khamriie è iy ruii phro, Isu è aishii yao. ");
INSERT INTO bgg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na ne athieg bey? Gu ne Aphuii shii nong yi pha nya ho mua phro, ai è khthiie snanyi armingthek hamangkhliie nyathoh phi phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jishii ji rek arone, jigigam shii nyie rey pha yao pha ji ne khi-èrek ne izai rey mage phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chiihphado Isu è bran ibrogthek shii yao, “Nathek ne gu ne Iphey shii adunmey pha blia rek pha duiine gu shii sudoh zum pha ji è khamriie nane miichangthek han ne wuii chid ne bey? Inai tham ne gu ne nathek moe shii Misiahò hà yua ne rai habuii shii nathek è gu shii azum. ");
INSERT INTO bgg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jishii, hìthek rek pha ji è chaigthek è jigigam shii zey marui pha jithek izai rey yi pha ji rek phro.” Ji è yao ched dang shii samoythek ne aishii thoh marui ne zab yodun. ");
INSERT INTO bgg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hanyie è Isu shii zum pho è Isu shii ji hà ne Khaiaphas hò hà noh dun Iphey yua pha masdothek nane dukhothek ò khrab ne dug. ");
INSERT INTO bgg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Phithar de ruang è ug ne Kho Phabi biang thog dang pha luagieng. Ai de biang bucho wuii srane khi-èrek ruii pha jithek riig pha sandrithek rog wuii ne dug gieng. ");
INSERT INTO bgg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Boh Phabithek nane zab pha limiangthek è Isu shii nin ne ua muii pha lumuii so; ");
INSERT INTO bgg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jishii Bran bajo è wuii ne khlam ne yao magunde ithek è nyie amua phi. Idohhè shii bran nyi è riu ");
INSERT INTO bgg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","srane yao, “Hì pha bran è yao muii ro, ‘gune Hamangkhung-aphuii pha Misiahò ji ne chuak ne da-um shii idoh nya rung din phi phro.’” ");
INSERT INTO bgg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Boh phabi ji è riu srane Isu shii yao, “Na shii nin pha miyao ji chang pha nyie miyao oi bey?” ");
INSERT INTO bgg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jishii Isu è arodang pha raidun. Jipha idoh è ji pha boh phabi è aishii yao din, “Isieng rai pha Hamangkhung-aphuii ibeng gu nashii surua phi phro: Na ne Masi, Hamangkhung-aphuii pha Dufuii arone, gathek shii izai yao mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isu è ai chang, “Nawai è yao dun ro. Jishii, gune nathek shii izai yao dang phro: sudoh pha ishak è thiwing ne nathek è Bran Dufuii ne Bohblu pha phazoi moe shii dug ne hamangkhung pha sakhamiing lakhung shii wuii ruii pha doh phro!” ");
INSERT INTO bgg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ji è yao mage shii ji pha Boh phabi ne airo yungthek shii ji srane yao, hì ne Hamangkhung-aphuii biwo ro! Gethek ne gai nyie miyao doh pha achid sha phro! Nawaithek è de ai ro makhakriing pha miyao ji yoi jong! ");
INSERT INTO bgg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nathek ne nyie now muii ga? Ithek è chang, ai ne ichiig ro, jiè ai ne iy chid phro. ");
INSERT INTO bgg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ji-è, ithek è ai mizia shii chan cho srane aishii zuang; chiih-è, hanyie thek è aishii phey pho è yao, ");
INSERT INTO bgg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Hì ne na shii hanyie muzuang ley ne, gathek shii chaig, Masaiya, yao riig bo!” ");
INSERT INTO bgg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phithar ne fuang sibiang ji pha fuang shii dug ne rai shii Kho Phabi pha khiaomuii jia wuii srane aishii sai, “Na de Galili pha Isu rog um gieng pha bran ji ro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Jishii, ai è branthek moe shii khlam ne yao. Ai è chang, “Nathek ne nyie yao ramuii pha ji ne gu ne agao phi ro,” ");
INSERT INTO bgg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","chiih-è, ji pha sibiang shii khud muii pha ji è fuang khiadun. Gai khiaomuii è de aishii doh mage shii thiichiih um pha branthek shii yao, “Ai de Nazareth pha Isu rog shii um pha ji ro.” ");
INSERT INTO bgg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Phithar è dinne snai ne chang, “Gu ne surua thak ne yao dang phro, ji pha bran shii gu ne athieg dang ro!” ");
INSERT INTO bgg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jipha ìujia idoh shii thiichiih riu ne rai pha branthek è Phithar shii wuii thog. Ithek è aishii yao, “Na de ithek pha è jia ro. Nawai è nyie khi è yao pha ji è ìd dun ro!” ");
INSERT INTO bgg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Phithar è yao din, “Gu ne surua thak ne yao dang phro, gu ne izai yao ramuii ro! Gu è khlam yao arone, Hamangkhung-aphuii è gu shii lago phi ruii phro. Gune ji pha bran shii athieg chak ro!” Ji è yao ched dang shii khephuii è ìo ruii, ");
INSERT INTO bgg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","chiih-è, Phithar è de Isu è nyie yao pha ji nowkhlei ruii: “Khe a-ìo ba pha ibi shii na ne gu shii athieg rone uom chiieng snai ruii phro.” Ai è fuang dun srane khiwegkho ne cho. ");
INSERT INTO bgg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hamiang riang shii boh phabithek nane dukhothek è Isu shii ua muii airo gidieg phak rai. ");
INSERT INTO bgg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ithek è aishii shiirnaithek è joi ne noh srane Roman pha badri Philath shii phi muii. ");
INSERT INTO bgg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zum yi pha Judas è Isu shii nin muii pha yoi mage shii, lubukhid ne liiman sikhithek sa-uom ji idoh yie srane boh phabithek nane dukhothek shii phi muii. ");
INSERT INTO bgg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Gu è ichiig oi pha bran shii zum yi pha ji è layog rekjong muii ro!” Ai è yao. “Gathek ne ji pha chiang shii nyie rek ne gayiig chid phlei?” Ithek è chang. “Hì ne nawai blia ro!” ");
INSERT INTO bgg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas è sikhithek thiichiih Misiahò shii fen marui ne dun dun; chiihphado dun srane zun ne iy dun. ");
INSERT INTO bgg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Boh phabithek è sikhithek chiing srane yao, “Hì ne ifai pha bang ro, chiih-è hì ne Misiahò pha bang rog shii ruii pha ji ne gethek Iphey shii gidieg rey dun phro.” ");
INSERT INTO bgg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bajo nung rai ne ithek è ji pha bangthek è fuang pha branthek shii wieng pha, Jarai rab pha raig jia pheg pha phak rai. ");
INSERT INTO bgg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ji buii ne thuh pha inai shii ji pha raig ne “Ifai pha Raig” Rone beng ne ruii. ");
INSERT INTO bgg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chiihphado chaig Jerimia miyao marui pha ji izai reythog: “Ithek è liiman sikhithek sa-uom, Israel pha branthek è aishii phi pha nuiirai pha bang ji yie, ");
INSERT INTO bgg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ne Ithong è gu shii yung pha duiine ji pha bang è jarai rab pha raig pheg muii.” ");
INSERT INTO bgg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Isu ne hanyie è aishii musai sai pha Roman Badri moe shii riu. “Na ne Jewthek pha saja bey?” Ai è sai. “Nawai è yao muii ro,” Isu è chang. ");
INSERT INTO bgg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jishii ai è boh phabithek nane dukhothek pha chiang ne nyie de achang phi. ");
INSERT INTO bgg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ji-è, Philath è aishii yao, “Na ne ithek è nashii they ramuii pha jithek ayoi bey?” ");
INSERT INTO bgg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jishii Isu è miyaogam jia de chang pha anuii phi, ji è rek pha ji è Badri ne bajo anomuluii pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hiìadun pha Sai pha ji shii ne Roman badri ne lajia ne idang ibrog è lia pha phathegpho jia shii thoh phi. ");
INSERT INTO bgg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jipha ishak shii zab è thieg pha phathegpho Isu Barabas beng pha ji de um ro. ");
INSERT INTO bgg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ji-è ibrog khrab thog mage shii, Philath è ithek shii sai, “Nathek è gu ne hanyie shii thoh yi pha yang lei? Isu Barabas shii thoh pha ba asi pha Masi beng pha Isu shii thoh haba?” ");
INSERT INTO bgg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jewishthek pha riichai è Isu shii ne aishii phi muii rone wie è thieg nyieliieshii ithek ne miegriie ro. ");
INSERT INTO bgg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Philath è chua pha hò shii dug bamuii shii, ai yiy è aishii mua jia thoh ge: “Ichiig oi pha bran rog shii nyie de arek rabo, nyieliieshii, dibiu gu ibang shii ai chiang pha sasab ne bajo diig rek pha bang muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Boh phabithek nane dukhothek è ibrog shii nyu ne Philath shii Barabas shii thoh ne Isu shii ua mua pha lia yi. ");
INSERT INTO bgg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jishii, Philath bran ibrog thek shii sai, “Nathek è nyi hì è, gu ithek pha hanyie shii thoh yi pha now phlei?” Ithek è chang, “Barabas!” ");
INSERT INTO bgg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philath è ithek shii sai din, “Masi beng pha Isu shii gu è nyie rek pha lei?” “Aishii ne bai hà zun muii bo!” ithek è chang. ");
INSERT INTO bgg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jishii Philath è sai din, “Ai è nyie suruii rek muii ga?” Ji-è ithek ne bajo boh boh rek ne ziak, “Aishii ne bai shii zun muii bo!” ");
INSERT INTO bgg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Philath è nyieliieshii ò ji athem pha um rone doh mage shii, ai è kho yi srane, ibrog moe shii wad chun, chiih-è yao, “Hì pha Bran iy pha gaja ne gu asi phro! Hì ne nawaithek mirek ro!” ");
INSERT INTO bgg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Zab ibrog è chang, “Ai iy pha gaja gathek nane gathek pha aniphiing shii chiih yi bo!” ");
INSERT INTO bgg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Philath è Barabas shii nathek shii thoh muii; chiih-è, ai è Isu shii zuang yi ne aishii bai hà zun yi pha phi muii. ");
INSERT INTO bgg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Philath pha siphahithek è Isu shii Badri boh hò bucho noh dun srane zab iphiing ai moe shii khrab thog ruii. ");
INSERT INTO bgg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ithek è airo yungthek than maphi ne gai yung shaig jia guii phi. ");
INSERT INTO bgg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chiih-è, ithek è migem phang è rago jia rab ne ai khrug shii thung phi, chiih-è ai phazoi shii thagin jia khoh yi; ji è rek srane ai ibi shii bam ne aishii siakjo noh. Ithek è aishii yao, “Jewthek pha saja phiang sieng bo!” ");
INSERT INTO bgg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ithek è aishii chan cho ne muchang yie srane ai khrug shii thab. ");
INSERT INTO bgg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ithek è ai siakjo pha jong mage shii ithek è yung shaig ji than din srane awai yung ji guii din phi. Ji è rek ched ne ithek è aishii bai shii zun pha noh dun. ");
INSERT INTO bgg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ithek è fuang wuiiramuii shii Simon beng pha bran Syrene è wuii ruii pha jia shii si iang. Ji-è, siphaihithek è aishii de Isu bai ji bangchiie nuang ba yi. ");
INSERT INTO bgg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ithek ne “Golgotha beng pha ithua shii wuii thog, ji pha Golgotha pha miyaosiu ne gadong um pha ithua rone è yao pha ro.” ");
INSERT INTO bgg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Thiichiih shii ithek è Isu shii ikhow lao pha phuii phi, jishii ai è chai mage shii ji aniing. ");
INSERT INTO bgg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ithek aishii bai hà zun maphi ne ai yungthek ne miiran riig ne awaithek chung thang rai. ");
INSERT INTO bgg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jipha idoh è ithek de thiichiih riu ne riig ne rai. ");
INSERT INTO bgg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Isu khrug lakhung shii “Hì ne Jewthek pha saja Isu ji rone” ithek è aishii shuang rek ji zey ne miak phi. ");
INSERT INTO bgg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chiih-è, ithek è Isu rog shii awie pha bran nyi shii bai hà zun muii. Jia ne ai phazoi moe shii, jia ne ai phawig moe shii. ");
INSERT INTO bgg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Thiichiih è dong ne lua pho thek è awaithek khrug hù ne Isu shii awie dang pha siakjo ne riig. ");
INSERT INTO bgg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Na ne Misiahò ji mua srane da-um shii nyarung din phrone yao! Na ne Hamangkhung-aphuii pha Dufuii chak arone, nawai shii de ragia rek mage ne bai ji è thazam lung ne dun mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ji duiine phabi boh thek nane Iphey yua pha Masdothek nane dukhothek de aishii siakjo phi: ");
INSERT INTO bgg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ai è gai shii ne ragia rek habuii shii awai shii ne ragia arek mua ara! Ai ne Israel pha saja ji asi bey? Thuh ai è bai è thazam lung ne dun mua arone gathek de aishii migi rek pha ro! ");
INSERT INTO bgg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ai ne Hamangkhung-aphuii shii luthong ne awai shii Hamangkhung-aphuii pha Dufuii rone è yao mua ro. Ji izai arone, Hamangkhung-aphuii è aishii ragia rek pha now bey ne cho gethek de riig sharai!” ");
INSERT INTO bgg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ai rog bai shii zun gieng pha awie bran è aishii ji duiine siakjo dun. ");
INSERT INTO bgg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hanai duchoi rey pha ishak shii zab soh shii igiia rey ne thab dun, ji pha igiia ne ishak uom thog dang pha thab dun. ");
INSERT INTO bgg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Habjuang ishak uom rey ramuii shii Isu è boh ziak, “Eli, Eli, lama sabakhthani?” Jipha miyaosiu ne, “Guro Hamangkhung-aphuii! Guro Hamangkhung-aphuii! Na ne gu shii nyie rek ne thoh muii phlei?” ");
INSERT INTO bgg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Thiichiih riu pha giak branthek è yao, “Ai ne Elija shii ho ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ithek è jia è ran srane yung neb jia yie srane phuii bisieng shii wo ne muchang shii jiang ne aishii phi ne niing yi pha rek. ");
INSERT INTO bgg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jishii gaithek è yao, “Khan bi, Elija è wuii ne aishii ragia rek phi pha ji riig bi bo!” ");
INSERT INTO bgg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Isu è dinne boh ziak ne idoh hè pha misey sey marui. ");
INSERT INTO bgg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Misiahò shii theg pha yung de ijuang è yie dang ne ikhiing thog dang pha zedun. Sohnyiak de shamdun, shakthek de chuidun, ");
INSERT INTO bgg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","wiengthek de hong dun, chiih-è, Hamangkhung-aphuii pha branthek iy dun pho thek de hòi ne chai sieng. ");
INSERT INTO bgg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ithek de wieng ji thoh muii ne, ithek Isu iy ne hòi din pha idoh è ithek de Rajan So hà wuii dun. Thiisa hà ithek shii bran bajo è doh. ");
INSERT INTO bgg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Arming pha dumuii nane siphaihithek hanyie è Isu shii riig ne rai pho è sajiid sham pha nane nyie thek rey pha doh ne zab rum ne yao, “Ai ne izai Hamangkhung-aphuii pha Aphuii ro Dufuii chak ara!” ");
INSERT INTO bgg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Thiichiih shii bajo hò-amuiithek um, ithek ne ruang è riig ne rai. Hanyie yi Galili è Isu shii nong phi pha wuii gieng pho ro. ");
INSERT INTO bgg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ithek ne Mery Magdalene, Jems nane Joseph pha amuii Mery, nane Zebedi pha yiy ji ro. ");
INSERT INTO bgg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Habjuang rey mage shii, Arimathea è bukho bran jia wuii thog ruii; ai beng ne Joseph ro, chiih-è, ai de Isu ro samoy jia ro. ");
INSERT INTO bgg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ai è Philath moe shii wuii srane Isu siu ji lia. Philath è Joseph shii siu ji phi ge pha yung. ");
INSERT INTO bgg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ji è, Joseph è ji yie srane, yung iwo jia è jiang phi, ");
INSERT INTO bgg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","chiih-è, awai wieng shii wieng muii, ji pha ne shakgang shii inai ìujia pha ibi shii jog pha wieng ji ro. Ai è ji pha wieng habin shii lubao boh jia è kheb marui ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mery Magdalene nane gai Mery yi wieng ji hà dug. ");
INSERT INTO bgg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jipha thimiang ne Jew Thung pha Inai ro, boh phabithek nane Pharisithek Philath shii wuii ne si ");
INSERT INTO bgg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","srane yao, “Masdo, gathek ne khlam ji a-iy ba pha ibi shii yao pha miyao ji ne now muii ro, ai è yao, ‘Gu ne da-um shii hòi din ruii phro.’ ");
INSERT INTO bgg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ji è ji pha inai thog dang pha wieng ji shii ne wie thiigang pha yung mage bo, ji arone, ai samoythek wuii ne ai siu ji agow mua phro, chiih-è branthek shii ai ne iy pha è hòi din rone ayao mua phro. Hì pha khlam ne igobi pha è de bajo awie pha rey ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philath è ithek shii yao, “Thiigangpho yie ne, wuii ne nawaithek è khi-èrek mua pha ji rek ne khan yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ji è ithek de thiichiih thoh ne wieng hà wuii dun srane wieng ji ahong yi pha lubao shii wie bin ne sandrithek shii khan ne rai yi ne dundun. ");
INSERT INTO bgg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jew Thung pha Inai idoh, Deobari hamiang hasiang chiu mage shii, Mery Magdalene nane gai Mery ne wieng ji riig pha wuii dun, ");
INSERT INTO bgg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Humblo thiichiih shii sajid boh jia sham ruii; Ithong pha hamangkhliie jia hamangkhung re-è thiichiih shii wuii thog ne, lubao ji hong ne thiichiih shii dug dun. ");
INSERT INTO bgg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ai ro dong pha ji ne muchuang duiine ro, chiih-è airo yungthek ne hayun duiine imo ro. ");
INSERT INTO bgg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sandrithek ne rum ne sham ne iy pha branthek duiine rey dun. ");
INSERT INTO bgg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hamangkhliie ji è hò-amuii shii yao. “Nathek ne arum rabo,” Ai è yao, “Gu ne thieg muii ro nasa ne hanyie shii bai hà zun ne ua muii pha Isu shii sow ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ai ne ichiih shii oi ro; ai ne awai yao pha duiine hòi jong ro. Ichiih aishii ruii pha ji shii wuii ne riig bo. ");
INSERT INTO bgg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Thuh shii jog dun ne, ai samoythek shii yao bo, chiih-è ai ne iy pha ji è hòi ro, thiisa hà ai ne ithek ibi hà Galili hà dun ramuii ro; thiisa hà nathek ne aishii doh ruii phro! Chiih-è gu nathek shii nyie yao pha ji now bo.” ");
INSERT INTO bgg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ji-è, ithek de wieng ji jog thoh ne dun shii, rum pha de rum ne sang pha ji è ran srane ai samoythek shii yao. ");
INSERT INTO bgg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Humblo shii Isu è ithek shii si ne yao, “Liijiing nathek rog shii um bo.” Ithek è ai moe shii wuii srane ai lai shii khoh srane aishii misiasia. ");
INSERT INTO bgg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Isu è ithek shii yao, “Nathek ne arum rabo. Dun ne gu khuiinothek shii Galili hà wuii iang pha yao mage bo, thiisa hà ithek è gu shii doh ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hò-amuiithek ne awaithek lumuii hà dun ramuii shii, thiichiih wieng thiigang pha giak sandrithek de idoh rajan hà dun srane boh phabi shii nyie rey pha ji zab yao phi. ");
INSERT INTO bgg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Boh phabithek è dukhothek shii si srane nung rai; ithek è sandrithek shii bang bajo phi ");
INSERT INTO bgg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","srane yao, “Nathek ne hì è yao chid phro, airo samoythek è gathek men pha habiu shii wuii ne ai siu ji gow ne yie dun. ");
INSERT INTO bgg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Badri è ji yao ruii arone, ithek mirek asi rone gathek è aishii nya-nyiu ne yao phi phro, ji-è, nathek ne arum rabo.” ");
INSERT INTO bgg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sandrithek è bang ji yie srane ithek shii nyie rek bo è yao pha ji rek phi. Chiih-è ji pha mua ne ji pha idoh è yie dang ne sudoh thog pha Jewishthek ro mua ji duiine shiiydun ro. ");
INSERT INTO bgg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Samoy snajia thek ne Isu awai è wuii bo ne è yao marui pha Galili phiingduii hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ithek è aishii doh mage shii ithek è aishii misiasia. Giak è than pho de um, ");
INSERT INTO bgg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Isu è ithek moe inui wuii srane ithek shii yao, “Gu shii ne hamangkhung hà nane sohnyiak pha riichai phi jong ro. ");
INSERT INTO bgg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ji-è, wuii srane zab pha ithua hà zab branthek shii gu samoy rab phi bo: ithek shii Aphuii ibeng è, Dufuii ibeng, chiih-è Ragung So ibeng è khowo phi bo, ");
INSERT INTO bgg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","chiih-è, gu è nathek shii yungjong pha jithek zab shii nuii yi pha yua phi bo. Gu ne nathek rog shii iidohhè thog pha um ruii phro.”");
INSERT INTO bgg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hì pha Mua Wie ne Hamangkhung-aphuii pha Dufuii Isu Masi chiang ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hì ne Aijaya chaig è zey pha ji duiine jao ne re ramuii ro: “Hamangkhung-aphuii è yao, naro lumuii hong yi pha, ‘gune guro muapho na è ibi thoh ruii phro.’ ");
INSERT INTO bgg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bijiujia ne balimuang hà ziak ne rai ro, Ithong wuii pha lumuii ne khriig rab ne rai iang bo, ai lua pha lumuii ne miang rab iang bo!” ");
INSERT INTO bgg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chiih-è Jon ne balimuang hà khia, khowo phi ne yua. Ai è branthek shii yao, “Nawaithek layogthek re-è idoh khid srane khowo yi mage bo,” “chiih-è Hamangkhung-aphuii è nathek ro layog shii khung phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea pho thek chiih-è zab Jerusalem pha rajan pho thek de Jon shii riig pha chiih-è ai miyao yoi pha wuii thog. Hanyie è layog arek sha pha rone yao pho shii ai è Jordan kho shii khowo phi. ");
INSERT INTO bgg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ne ùd pha iman è rab pha yungthek guii, ai rinyie shii ne shukhug pha rathang ring ro. Ai ne muroma chiih-è jabiing chumud chie ne rai ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon è branthek shii yao, gu è de bajo boh rek pha gai jia wuiiramuii ro. Ai ne bajoboh ro, gu ne airo khiao duiine bam ne ai lakhia ithang de athan mua phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gu ne nathek shii kho è khowo phi bie, jishii, ai ne nathek shii Hamangkhung-aphuii ro Ragung So è khowo phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Achia dang pha idoh shii, Isu ne Nazareth beng pha ithua è Galili thiig hà wuii thog srane Jordan kho shii Jon wad re-è khowo yi. ");
INSERT INTO bgg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Isu è khowo yi srane fuang khia mage shii, hamangkhung ne hong pha doh, chiih-è, Ragung ne fuii pharo duiine thazam aishii khey thog. ");
INSERT INTO bgg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chiih-è hamangkhung è goh jia yao ruii, “Na ne guro bushun pha Dufuii ro, na shii gu ne bajo miie ro.” ");
INSERT INTO bgg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jipha Hamangkhung-aphuii pha Ragung è Isu shii balimuang hà noh dun. ");
INSERT INTO bgg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Thiisa hà aishii ne, Sakhathong è inai sawi chuajan ne rai dun ro. Ai ne balimuang pha miiramthek rog shii rai ne de, jishii hamangkhliie è aishii nong phi ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon zum ne phatheg chab pha iidohhè, Isu ne Galili thiig hà dun thog din ro, thiisa hà ai ne Hamangkhung-aphuii pha Mua Wie ji yao ne rai: ");
INSERT INTO bgg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Hamangkhung-aphuii pha Sajathua ishak ji thog sha ruii ro, ji-è, nathek ne layog arek sha pha thadoh khid ne Mua Wie hì shii migi rek mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ji è yao srane Isu è Galili beng pha khabang iring hà wuii thog mage shii, Isu è ù ua pha nyi shii doh. Simon chiih-è ikhuii Andrew ne chiug mua ne rai pha doh ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isu è isa shii yao, “Thawuii ne gu rog shii luagieng bo, chiih-è nasa shii sudoh è thiwing branthek shii zum pha yua phi pha ro.” ");
INSERT INTO bgg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Khthiie ithek ne awaithek ro chiug thoh srane ai rog shii luagieng. ");
INSERT INTO bgg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ìujia thithe hà lua mage shii Isu è Zebedi pha dufuii Jems chiih-è Jon ne awai sa run shii chiug mua pha saro ne rai iang pha doh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Isu è isa shii doh ne ho mage shii, isa de awai sa aphuii Zebedi shii run lakhung pha branthek rog shii thoh marui ne Isu rog shii luagieng dun. ");
INSERT INTO bgg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Isu nane samoythek ne Khaphernaum beng pha thawun hà wuii dun. Chiihphado thimiang Jewthek Thung pha Inai shii, Isu ne Misiahò hà wuii srane ithek shii yua. ");
INSERT INTO bgg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ithek ne Isu muyua ji nuii ne zab wiengphleg dun, nyieliieshii, Isu ne Iphey yua pha masdo duiine asi pha riichai um ne yua dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hamblo shii awie pha ragung è jiang pha jia è Hamangkhung-aphuii ro Misiahò shii wuii thog srane ziak ne yao, ");
INSERT INTO bgg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Na ne gu rog shii nyie blia um lei? Nazareth pha Isu, na ne gu shii diig phi pha wuii ne bey? Na ne hanyie lei? Ji gune thieg muii ro, nane Hamangkhung-aphuii pha So muapho ro.” ");
INSERT INTO bgg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ji-è rek mage shii, Isu è giung ne yao, “Airo pha bucho è fuang khia mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ji è yao mage shii, ibuii ragung ne sham ne khrif srane ziak ne ji pha bucho è fuang khia dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wiengphleg pha blia rek mage ne ithek ne awaithek chung yao rai, Hì pha muyua ne nyie lei? Hì ne miyao iwo yua ne bey? Aishii ne riichai um ara ro, ibuii ragungthek de ai miyao nuii dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Isu è rek pha blia miyao jine ne rib jia shii Galili thiig hà yoi thog dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Isu ne Jems chiih-è Jon, chiih-è gai samoythek rog shii Jewthek ro Jewthek misiahò thoh srane Simon chiih-è Andrew hò hà wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Thiisa hà Simon ro khiing ne hakhang zia ne rad muii. Isu è thiichiih shii thog dang mage shii ithek è aishii yao. ");
INSERT INTO bgg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Isu ne ai moe shii wuii srane aishii wad è sasey è chaing srane riu yi. Ji è rek mage shii hakhang zia pha ji ne gang re dun ro. Chiihphado ai ne ithek shii chie niing pha rab ne phi. ");
INSERT INTO bgg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jipha habjuang hasiang yem ched pha idoh shii ithek è radpho shii chiih-è ibuiithek ragung è jiang pho thek shii Isu moe hà noh ne wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chiih-è, thiigpho de zab habin moe shii wuii thog ne riig. ");
INSERT INTO bgg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Thiichiih shii Isu è ithek shii yoyo pha miiriie è rad pho thek shii gang rek phi, chiih-è, ibuiithek ragung shii de zab khia phi. Isu è ibuiithek ragung thek shii aro yi ro, nyieliieshii ibuii ragungthek ne Isu ne hanyieliie shii thiegjong ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jipha thimiang pha hamiang riang shii Isu ne sieng srane liijiing ithua hà sia pha wuii dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ji è wuii pha idoh shii, Simon chiih-è gaithek de aishii so pha wuii dun. Ithek è ai thog mage shii, ");
INSERT INTO bgg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ithek è aishii yao, ithek ne na shii sow ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ji è yao magunde, Isu è ithek shii yao din, “Gethek ne zab pha gai thiigthek hà de wuii chid phro. Chiih-è gune è rek ne yua chid phro, nyieliie shii, gune ichiih shii hì è rek pha ji wuii ro.” ");
INSERT INTO bgg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ji-è, Isu ne Galili pha ithua hà lua srane Jewthek ro Jewthek misiahò shii yua ne zab pha ibuiithek shii de khia phi. ");
INSERT INTO bgg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Awiedang pha hìa è rad pha jia yi Isu moe shii wuii thog ne yao, na è wie rek pha now arone, hì pha hìa riie pha ji ne wie nyarek mua phi. ");
INSERT INTO bgg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Isu è bushun now ne awai wad è aishii khoh srane yao, “Gune wie rek phi pha yang muii ro.” Ji-è, Isu è yao, wie re mage bo, ");
INSERT INTO bgg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ji è yao mage shii ji pha hìa ne wie redun. ");
INSERT INTO bgg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ji è rek pha idoh shii Isu è aishii gang è yao srane thoh ge: ");
INSERT INTO bgg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Chiih-è hì pha blia rek phi pha ji ne hanyie shii de ayao rabo. Ji è rek pha chiang ne chiih-è Moses è phi pha jigigam duiine khlem yi srane miiriie ji wie re pha chiang è phabi moe shii wuii ne khlem jithek zid mage bo. Ji è rek arone, ithek è na miiriie ne wie redun rone nyathieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Isu è ji è yao magunde, ithek ji yao rone yao muii. Ji è rek mage shii ithek ne Isu moe shii bajo wuii thog, ji-è, ai ne ithek ro thiig jishii awuii mua din pha re dun. Ji è re mage ne Isu ne liijiing um pha ithua hà ug ne rai dun ro. Ji hà ug ne rai magunde, ithek ne athodang pha ai moe shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Isu ne inai ìujia idoh, Khaphernaum beng pha thiig hà awai hò shii dun thog din ne ji pha muathek shii yoi dun. ");
INSERT INTO bgg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ji è yoi mage ne ithek bajo wuii thog mage ne hò iliing hà ithua oi sha chiih-è habin moe shii de dug pha biang de oi dang pha re dun. Ai è ithek shii Hamangkhung-aphuii miyao ji yua. ");
INSERT INTO bgg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bran wi è slemriie pha ji shii oh srane Isu moe hà nohthog. ");
INSERT INTO bgg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bran bajo um pha ji è ithek wi ne Isu moe shii noh ne awuii mua ro. Ji-è, ithek ne Isu khrug lakhung pha hò mugoh ji hong srane aishii lawiao rog shii Isu ibi shii zun mage. ");
INSERT INTO bgg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bran wi ji è bajo migi rek pha doh mage ne Isu è slemriie ne rad pha ji shii yao, gu ani wo! Na layog ne gu è khungjong phi ro. ");
INSERT INTO bgg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ji è yao magunde, Iphey yua pha masdothek è awaithek lubu hà ug ne now, ");
INSERT INTO bgg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","nyie khi-èrek ne ai ne hì è rek ne yao mua phlei? Hì ne makhakriing rek pha miyao ro, nyieliieshii, layog shii khung mua phi phane Hamangkhung-aphuii bie ro. ");
INSERT INTO bgg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ithek è nyie now pha ji ne Isu ne ibi thieg dun ro. Ji-è, Isu è din ne ithek shii yao, nyie rek ne nathek ne ji è now phlei? ");
INSERT INTO bgg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Slem riie pha ji shii hì è sai pha, naro layogthek ne khung jong phi ro è yao pha ji wie bey, asi pha jiie srane nawai lawio chiing ne lua mage bo è yao muii pha ji ne wie bey? ");
INSERT INTO bgg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bran Dufuii hìne sohnyiak shii layog khung phi pha riichai um ara rone izai doh yi ro, gu nathek shii khagi rek ruii phro. Ji-è ai è slem rad pha ji shii yao, ");
INSERT INTO bgg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Gu na shii yao, sieng srane nawai lawio ji chiing ne nawai hò hà dun mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ithek è riig dang pha ji shii, ai ne sieng ne awai lawio chiing srane awai hò hà dun dun ro. Ji è rek mage shii, ithek ne rum ne Hamangkhung-aphuii shii yao, na shii laso ro! “Hì è rek pha blia ne gathek khuchung de adoh ba ro.” ");
INSERT INTO bgg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Isu è dinne Galili pha khabang iring shii wuii thog mage shii ibrogthek ne Isu moe shii wuii thog. Ji-è, thiichiih shii Isu è ithek shii yua pha jao din. ");
INSERT INTO bgg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ji è rek ched ne Isu lua ramuii shii, mijin than pha jia awai mijin than pha ophis shii dug ne rai pha doh, ji pha Lewi ne Alphayus pha dufuii ro. Isu è aishii ho, “Na de gu rog shii luagieng bo.” Ji è yao mage ne ji pha bran è jiie srane Isu rog shii luagieng ro. ");
INSERT INTO bgg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ji è rek ched pha idoh shii Isu è ji pha Lewi pha hò hà wuii srane michie chie ramuii shii gai mijin than pha layog pho thek de Isu nane ai samoythek rog shii wuii ne thiibliie shii dug srane michie chie gieng. ");
INSERT INTO bgg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iphey yua pha Pharisithek è Isu ne layog pho chiih-è mijin than pho rog shii michie chie pha doh mage ne ithek è Isu pha samoythek shii sai, nyie rek ne ai ne ji è rek pha thek rog shii michie chie gieng phlei? ");
INSERT INTO bgg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Isu è ithek miyao ji yoi ne chang, hanyie arad pho ne ma pho shii achid phro, jishii, hanyie thek yi radpho ne, mapho shii chiid ruii phro, Gune ilab pho shii ho pha awuii ro, jishii gune layogthek shii ho pha wuii phro. ");
INSERT INTO bgg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sai pha inai jia shii Jon khowo phi pha samoythek chiih-è Pharisithek ne minyie nyi ne rai habuii ne, ithek è Isu shii wuii srane sai, “Jon chiih-è Pharisithek pha samoythek ne minyie nyi habuii shii na samoythek ne nyie rek ne minyie anyie ga?” ");
INSERT INTO bgg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isu è chang, nathek ne inow bey, phiyiy shii wuii pha biwenthek ne michie achie pha nyadun ge ne bey? Khuchung de ji arek phro! Phiyiy pha bufuii um shii ne ithek ne anyie chid. ");
INSERT INTO bgg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Jishii, ji pha idoh thog ramuii ro, phiyiy pha bufuii ne ithek rog è ruang noh dun phro. Chiihphado ithek ne minyienyie ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hanyie è de yung thileg iwo jine phadiig hèg shii miak ne aphiog phro. Nyieliieshii yung thileg iwo ji è ri srane phadiig hèg jine boh ji dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hanyie è de jariie hèg shii ne phuii nyiu giog ne achab phro, nyieliieshii phuii nyiu bow mage ne ji pha jariie ne chui srane phuii ne zab noi dun phro. Ji-è phuii nyiu ne jariie iwo shii chab chid. ");
INSERT INTO bgg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jewish Thung pha Inai shii, Isu chiih-è ai samoythek ne phiug raig è dong srane lua ramuii shii, ithek è phiug iwoi ji chiig mage. ");
INSERT INTO bgg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ji-è Pharisithek è Isu shii yao, “Riig mage, naro samoythek è Jew Thung pha Inai shii hì rek phane gethek ro Iphey shii gidieg rek ro!” ");
INSERT INTO bgg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Isu è ithek shii chang ne sai, “Nathek ne atham riig bey? Dawid Saja ai chi-iyiy mage shii nyie rek phlei? ");
INSERT INTO bgg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ai è Hamangkhung-aphuii pha hò hà wuii srane Hamangkhung-aphuii shii zid pha iweb ji chie maphi, ai ji è rek pha idoh ne Abiathar Phabi giu de um ro. Gathek ro Iphey ji riig arone, ji pha iweb ne phabithek è chie mua bie, jishii, Dawid Saja è chie srane awaithek shii de phi ne chie yi.” ");
INSERT INTO bgg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Isu è miyao jong srane, “Jewthek Thung pha Inai ne bran shii wie re yi pha chiang è rab phi ro, Jewthek Thung pha Inai pha chiang è bran arab ro. ");
INSERT INTO bgg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ji-è, Bran Dufuii ne Jewthek Thung pha Inai ro Ithong de ro.” ");
INSERT INTO bgg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ji-è rek ched mage shii, Isu ne Jewthek misiahò hà idoh dun shii, thiisa hà wad shii slemriie pha jia um. ");
INSERT INTO bgg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Thiisa hà giak thek è Isu shii ichiig they pha khan ne rai iang ro. Ji-è, ithek ne Isu moe shii wuii ne, Jewthek Thung pha Inai shii gang rek phi bey ne, ji riig pha khan ne rai. ");
INSERT INTO bgg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Isu è wad shii slemriie pha jishii yao, “Gu moe shii wuii mage bo!” Ji è yao ched ne, Isu è ithek shii sai, ");
INSERT INTO bgg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jew Thung pha Inai gethek thiigpha Iphey è gethek shii nyie rek bo ne zey lei? Nong phi pha zey bey? Asi buii rek phi bo è zey bey? Chiih-è branthek ro chai shii ragia rek phi ne bey? Asi pha chai shii mua muii ne bey? Ji è sai mage ne, ji pha branthek ne nyie de ayao muluii pha re dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Isu è ithek ne lubu siie now ne rai pha thieg ne bajo zo dun, ji-è, ai ne lijieg srane ithek shii shan srane riig mage ne wad zi ne rad pha ji shii yao, “Na wad ne gu shii phia mage bo,” ai è wad phia mage shii, ji pha wad ne gang re dun. ");
INSERT INTO bgg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ji è re mage ne ji pha Pharisithek ne Jewthek misiahò ji thoh srane Herod ro branthek rog shii dug srane Isu shii ua pha phak rai. ");
INSERT INTO bgg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Isu chiih-è ai samoythek ne Galili pha khabang iring è luaramuii shii, ibrogthek de ithek rog shii luagieng. Jipha branthek ne Galili, Judea, ");
INSERT INTO bgg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumia thiig hà rai pho, Jordan ithua: bichiu hà rai pho, Thaire chiih-è Sidon pha rajan hà rai pho ro. Ithek zab è Isu moe shii wuii thog, nyieliieshii ithek è Isu è rek pha blia jithek yoi dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Isu ne thiichiih shii Ibrog ne bajo iphiing um pha ji è Isu ne awai samoythek shii run jia shii khriig sow ne ruii iang pha yung, nyieliieshii ji pha ibrogthek è Isu shii wuii srane ziig mage inow ne yung. ");
INSERT INTO bgg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Isu è bajo branthek shii gang rek phi, jiè hanyie rad aishii khoh pha aishii reng ne ai moe shii wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chiih-è, khuchung magunde aishii, ibuii ragungthek è jiang pha è Isu shii doh ne, Isu ibi shii thud srane ziak ne yao, nane Hamangkhung-aphuii pha Dufuii ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ji-è Isu è ibuii ragung shii giung, hì pha miyao ne hanyie shii de ayao dang rabo. ");
INSERT INTO bgg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ji è rek pha idoh shii, Isu ne phiing hà wuii srane ai è chiid pho thek shii awai moe hà ho, chiih-è ithek de ai moe shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Thiichiih shii, Isu è snanyi shii awai guaphasamoy rek pha gua. Ithek shii Isu è samoy rone beng ne ruii. Isu è yao, “Gune nathek shii gu rog luagieng pha gua ro. Ji-è gune ithek shii de gu miyao ji yao pha gai hà de wuii yi pha ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nathek shii ibuii ragungthek khia pha riichai um ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ai samoy snanyi ne Simon (Isu è aishii Phithar beng ne ruii phro); ");
INSERT INTO bgg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems nane ai ikhuii Jon, Zebedi pha dufuii (Isu è isa shii Boanerges beng ne ruii, ji pha ibeng ne hakhliing pha bran rone ibeng phi). ");
INSERT INTO bgg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philiph, Bortholomeu, Methiu. Thomas, Jems Alphayus pha dufuii, Thadaeu, Simon thiig shii dumuii rek pha ji ro, ");
INSERT INTO bgg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Chiih-è, Judas Iskharioth hanyie è Isu shii zum yi pha samoy ji ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ji è rek pha idoh è, Isu ne dinne hò hà dun thog, dinne ji è rek pha ibrog boh è wuii thog mage ne Isu chiih-è airo samoythek ne michie chie pha de ajo dang pha re dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ai haliingpho è ji yoi mage ne Isu shii idoh noh pha wuii thog dun. Nyieliieshii, ithek è bajo yao ramuii, Ai ne biu dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalem è wuii pha Iphey yua pha masdothek è yao, “Aishii ne sakhathong um ro, ji pha sakhathong ne ibuii boh ji ro, jiè ai ne ibuii shii fuang khia yi pha blu phi ro.” ");
INSERT INTO bgg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ji-è Isu ithek shii ho srane ithek shii najang è shan ne yao phro: Khi è rek ne sakhathong è sakhathong shii khia mua mage phlei? ");
INSERT INTO bgg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Soh chung gui rai ne che dun arone, ji pha thiig ne idang adung mua pha rai dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Haliing chung adung pha gui rai arone, ji pha haliing ne idang adung pha che dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ji-è sakhathong pha sajathua pho chung de gui rai arone, ji pha sakhathong thek de adung rai phro, chiih-è ji pha sajathua ne idang arai mua phro. ");
INSERT INTO bgg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Hanyie de gang bran shii zum ne ajoi sapho shii ne, ji pha gang hò hà mogo agow mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Gu nathek shii izai yao phro, branthek pha zab layogthek, chiih-è khama pha Hamangkhung-aphuii shii buii yao pha thek ne nyakhung phi phro. ");
INSERT INTO bgg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jishii, hanyie è Ragung gang shii awie pha gidieg rek pho shii ne khuchung de akhung phi phro. Nyieliieshii, ai ne idang rai pha layog rek phro. ");
INSERT INTO bgg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Isu ji yao pha ne, ithek è aishii ne ibuii ragung um rone yao phi ne ji miyao phi ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ji è re pha idoh è, Isu pha amuii chiih-è ikhuiithek wuii thog ruii phro. Ithek ne sibiang hà riu srane Isu shii si pha rone mua thoh ge phro. ");
INSERT INTO bgg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Isu moe shii dug pha ibrogthek è Isu shii yao, riig mage bo! Na amuii chiih-è na khuiinothek chiih-è na bumuiithek ne na shii si pha sibiang hà riu ne khan ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Isu è ithek shii chang, “Hanyie ne gu amuii lei? Hanyie ne gu ikhuii lei?” ");
INSERT INTO bgg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Isu è khama jia ai moe shii dug pho shii riig srane yao, “Riig mage bo, gu amuii ne hìthek ro, chiih-è gu khuiinothek hì ro. ");
INSERT INTO bgg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gu amuiithek, gu khuiinothek chiih-è gu bumuii ne hanyiethek è Hamangkhung-aphuii è nyie chiid pha ji rek pho ji ro.” ");
INSERT INTO bgg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Dinne Isu è Galili pha khabang iring hà rai srane yua ramuii shii, ai moe shii boh ibrogthek wuii thog ne shan ne ley mage ne ai ne run jia shii khrog ne in dun ro. Run jine kho è fuang hà um, chiih-è ithek ne kho iring shii riu yi. ");
INSERT INTO bgg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chiihphado ai è najang è shan ne miyaothek yua ne ithek shii yao: ");
INSERT INTO bgg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yoi mage bo! Luangjia shii bran jia è miiriie jiie pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ai è ji pha miiriie ne raig shii jiie mage shii, giak ne lumuii hà chiih dun. Jipha miiriie ne fuiithek è wuii srane zab chiing ne chie muii. ");
INSERT INTO bgg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Giak miiriie ne lubao surong pha nyak shii chiih dun. Jipha miiriie ne khthiie sieng shii. Thiisa hà nyak ne jam asi pha ji è ");
INSERT INTO bgg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","hasiang siang mage shii, misieng ne zab goh ne iy dun; nyieliieshii, ji pha misieng ne iriing jam adab mua pha ji è iy dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Giak miiriie ne migem um pha jabiing hà chiih dun ro, ji pha miiriie ne siengthog mage shii, migem muiithek yang ne sieng dun pha ji è iwoi awoi mua pha re dun. ");
INSERT INTO bgg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Chiih-è giak miiriie ne nyiak wie hà chiih ne, ji pha miiriie ne wie sieng ne, iwoi wie woithog ruii, giak ne phriie sa-uom woithog ruii, giak ne briie sariig woithog ruii phro, chiih-è, giak ne briie wiengjia woi thog ro.” ");
INSERT INTO bgg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Din ne Isu è yao, “Hanyie shii yoi pha khohthek um arone, yoi mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Isu yi awai ji shii, ai miyao yoi pho thek chiih-è samoythek è aishii wuii srane najang shan ne yao pha miyao siu ji sai, ");
INSERT INTO bgg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Isu è ithek shii chang, “Nathek shii ne Hamangkhung-aphuii ro Sajathua pha miyao ug ne ruii pha ji phijong ro.” Jishii fuang hà riu pha yogai ne najang pha miyao siu ji nuii phro, ");
INSERT INTO bgg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ji-è, Ithek ne riig phane riig shii, Thuh de adoh ro; ithek ne yoi phane yoi shii, thuh de agao ro. Chiih-è ithek ne ji rek arone, ithek ne Hamangkhung-aphuii shii khid phro, chiih-è, Hamangkhung-aphuii è ithek layogthek shii de khung phi ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chiih-è Isu ithek shii sai, nathek hì pha najang shan ne yao pha miyao agao ba bey? Chiihphado, nyie khi-èrek ne gai pha najang è shan ne yao pha miyao ji ithek thieg mua yi phlei? ");
INSERT INTO bgg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jipha miiriie jiie pha ne Hamangkhung-aphuii pha mua ji jiie ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Giak ne lumuii shii chiih pha miiriie ne ji duiine ro, ithek ne jipha mua nuii ched dang shii ibuii è wuii srane jipha mua ne ithek è yie dun. ");
INSERT INTO bgg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Giak bran ne lubao lakhung shii chiih pha miiriie duiine ro. Mua jine ithek bajo lised rek ne nuii gieng phro. ");
INSERT INTO bgg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jishii, ji pha mua ne ithek lubu iliing hà athog ba shii, mua phi pha chiang è, ithek shii diigchiaothek thog mage shii ithek ne jithek shii zab thoh din muii ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Giak branthek ne migem biing hà jiie pha miiriie duiine ro. Ithek ne ji pha mua ne nuii habuii shii, ");
INSERT INTO bgg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Jishii awaithek sieng pha chiang è rum ne, bukho re yi pha miie ne, ichua ichua chiid pha ji thek è ji pha mua shii ne yang dun ne sennyia muii srane ji pha mua ne iwoi awoi mua pha iy dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jishii, giak miiriie ne nyiak wie hà chiih pha duiine ro. Ithek ne mua ji nuii srane lubu hà ruii, chiih-è, iwoithek de wie woi ruii phro. Giak ne briie sa-uom woi ruii phro, giak ne briie so-riig woi ruii phro, chiih-è giak ne briie wieng jia thog pha woi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Isu è dinne yao din, “Hanyie è ichuang yie srane shiikhiiakhjam chiih-è biang bucho hà ruii ne bey? Jine ithek è bunthruak lakhung hà aruii ne bey? ");
INSERT INTO bgg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nyie ug ne ruii pha ji ne fuang khia yi phro, nyie thieg ne ruii pha ji ne hong yi ruii. ");
INSERT INTO bgg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nathek shii khohthek um arone yoi mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Isu è de ithek shii yao, “Nathek è nyie yoi pha ji shii isiie rek mage bo, nathek è ithek shii khi-èrek ne chua pha ji duiine, Hamangkhung-aphuii è de nathek shii ji duiine chua ruii phro, jishii, ai ne jiè de boh huak ne chua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bran hanyie shii um iang phane, aishii dinne de bajo phi ruii phro, chiih-è, hanyie shii oi iang pha ji shii ne, aishii ìujia um iang pha ji de yie dun phro.” ");
INSERT INTO bgg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Isu dinne yao, Hamangkhung-aphuii pha Sajathua ne hì duiine ro, bran jia è awai raig shii iriie jiie marui. ");
INSERT INTO bgg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ai ne habiu shii men dun, chiih-è inai shii ne lakhung sieng, chiih-è iriie jithek ne awailum ne sieng khlei ruii, jishii, ji pha iriie ne khi-èrek ne sieng ruii pha ji ne thuh de athieg mua ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jine nyiak è rek ne sieng yi srane iwoithek de woi ruii phro; igobi ne iliung liung srane irab nyiu ne sieng bi ruii phro, chiih-è, imabuiithek bua ne iwoi woi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iwoi jithek men pha ishak thog mage shii, ji pha bran è awairo barai rog shii riug pha jao, nyieliieshii yamiing pha ishak ne thog ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Isu è sai, “Hamangkhung-aphuii pha Sajathua ne imia rone gethek ne yao nyie rek ne yao phlei?” Isu è sai. Nathek shii nyie najang è yi ne yao pha lei? ");
INSERT INTO bgg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hì ne ji duiine ro, bran jia è sohjambling shii zab è ididuii thanaro iriie ji yi srane raig shii jiie pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ji è jiie marui pha idoh è ji pha misieng ne zab è de boh re ne sieng mage shii ji pha idiphak pha ilem shii fuiithek wuii ne irungthek rak ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Isu è branthek shii awai bajo najang è hì duiine awai mua ji yua; ai ne ithek shii khama gao mua pha rek ne yao phi ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ai ne khuchung magunde najang è ayao phane nyie de ayao dang ro, jishii ai ne awai samoy rog shii ji pha najang pha miyao siuthek ne wie rek ne yao phi ne gao yi ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jipha habjuang shii, Isu è awai samoythek shii yao, “Cho gethek ne khabang iring thrang hà wuii sha rai haro.” ");
INSERT INTO bgg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ji-è ithek ne run moe pha ibrogthek shii thoh marui ne Isu injong pha run shii khud ne in dun, jiè rek pha ji shii gai runthek de bajo um ro. ");
INSERT INTO bgg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Humblo shii hasam boh sam mage, chiih-è khasao ne run lakhung shii jao thog. ");
INSERT INTO bgg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Isu ne run pha idoh hà dun srane awai khrug shii tharo rone athan dang pha men dun. Samoythek è Isu shii chun ne ho, “Masdo, gathek iy sha pha rek muii pha ji ne na athieg bey?” ");
INSERT INTO bgg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Isu è jai srane ji pha hasam nane khasao shii yung, ji è giung dang shii ji pha hasam ne them dun. Thiichiih ne bajo liijiing rey dun. ");
INSERT INTO bgg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chiihphado, Isu è awai samoy shii yao, “Nathek ne nyie rek ne rum phlei? Thuh de nathek ne migi oi ba bey?” ");
INSERT INTO bgg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jishii ithek ne Isu blia ji doh mage ne bajo rum dun chiih-è awaithek chung yao rai, “Hì ne hanyie lei? Hasam nane khajaothek de ai miyao nuii dun ro!” ");
INSERT INTO bgg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Isu nane ai samoythek ne dinne Gerasa pha soh thug um pha Galili khabang iring pha ithua shii thog dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Thiichiih thog ne Isu run è fuang nya lung dang shii, thiichiih pha wieng muang hà rai pha bran jia si iang. Jipha bran shii ne awie ragung è jiang ne um. ");
INSERT INTO bgg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ai ne idang wieng muang hà rai, hanyie de aishii zum ne chiih-è ajoi mua ro, ");
INSERT INTO bgg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","aishii shiirnai thang è lai wad joi magunde, shiirnai ne biethiak ne lai è dia srane dumrim rek muii. Ai ne bajo gang pha ji è hanyie de aishii azum mua ro. ");
INSERT INTO bgg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Inai de, habiu de, ai ne wieng pha duchoi shii lua ne rai, chiih-è phiingthek hà shan ne lua srane ziak ne awai shii lubao è giao. ");
INSERT INTO bgg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ai è Isu wuii ruii pha doh mage ne, Isu moe shii ran srane bam ne khung srane gang goh è yao, ");
INSERT INTO bgg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Zab è giu pha Hamangkhung-aphuii ro Dufuii, Isu! Na ne gu shii nyie blia um ga? Hamangkhung-aphuii chiang è na gu shii diig aphi rabo!” ");
INSERT INTO bgg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ai è ji yao ruii pha ji ne nyieliieshii Isu è ji pha awie ragung shii fuang khia mage bo è yao. ");
INSERT INTO bgg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ji-è, Isu de aishii sai, “Na beng nyie beng phlei!” Jipha bran è Isu shii chang, “Gu beng ne ibrog ro, nyieliieshii, gu iliing shii awie ragung ne bajo um ro.” ");
INSERT INTO bgg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ji è chang srane ai è Isu shii khung ne yao, awie ragung shii ji pha thiig è ruang athoh ge rabo. ");
INSERT INTO bgg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Thiichiih inui pha phiing shii wak brogpho è wak ibrog jia ram ne rai iang pha doh. ");
INSERT INTO bgg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Awie ragung è Isu shii khung srane yao, “Gathek shii ne ji pha wak ibrogthek bucho shii thoh mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ji è yao mage ne, Isu è jithek pha awie ragung shii ji pha wak ibrog shii thoh ge. Jipha itham nyi um pha wak ibrog ne khabang hà rei ne ran srane khabang hà biung ne zem dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wak brogpho è jithek re pha doh mage ne ran srane thiigpho chiih-è raigpho shii de zab yao mage, ji è yao mage ne ithek de nyie re dun pha ji riig pha thiichiih shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ithek è Isu moe shii wuii thog mage shii bajo ibuii ibrog è jiang pha bran jine yung wie guii srane khani wie re ne Isu moe shii dug ne rai pha doh, jiè ithek ne ji riig srane rum dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hanyie thek è ibuiithek jiang pha chiih-è wak ibrogthek shii nyie rek phi pha ji raigpho è ithek shii yao iang. ");
INSERT INTO bgg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ji-è, thiichiih pha ithek è Isu shii wad khung srane ji pha ithua thoh ne dun bo ne yao. ");
INSERT INTO bgg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Isu è run iliing hà khud ramuii shii ibuiithek è jiang pha bran ji de Isu shii yao, “Gu shii de nathek rog shii dun gieng yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ji è yao magunde, Isu è aishii yao din, “Asi, nane idoh nawai hò hà dun srane nawai haliing pho shii Hamangkhung-aphuii è na shii khama bushun rek phi pha ji yao mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ji è yao mage ne ji pha bran ne dun srane thiig sua shan ne lua srane Isu è nyie rek phi pha jithek shii zab yao phi. Ji yoi ne ithek de zab wieng dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Isu è khabang khlei pha ithua hà wuii din mage shii, thiisa hà de bran bajo wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus chiih-è thiigpho Jewthek ro Jewthek misiahò pha dumuiithek Isu moe shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jairus è Isu shii doh mage ne khungdang ne yao, “Gu dimi duiine bajo rad muii ro, na ne wuii srane wad è aishii kho phi bo, chiihphado, ai ne gang dinne sieng ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ji è yao mage ne Isu è ji pha bran rog shii wuii dun. Gai thek de Isu rog shii bajo wuii gieng pha ji è Isu moe shii ne zab ley dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Thiisa hà dam snanyi è grab rek ne rad pha bimi jia um iang, ");
INSERT INTO bgg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jipha bimi ne bajo maphothek shii wuii ne riig yi ne de, chiih-è bajo bang phi ne mathek rek ne de awie phi. Ai ne wie re khlei pha asi pha bajo muna rad khlei dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Isu è rek pha bliathek yoi mage ne bimi jine ibrog um pha Isu moe shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Awai è awai shii yao, “Gu è ai yung shii kho mage arone, gu ne gang re ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bimi jiè Isu yung shii kho mage shii, ai grab rek pha ji ne them dun. Ji-è ai ne awaishii than ruii, ai rad ne diig rek pha ji ne them dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Isu è ai ro gang yi pha blu ne khia dun rone thieg, jiè Isu ne ithek shii shan ne riig srane sai, gu yung shii hanyie mukho mage lei? ");
INSERT INTO bgg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ai samoythek è chang, “Nyama pha bran na moe shii ley dun pha ji ne nawai de thieg; jiè na ne nyie rek ne sai phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ji è yao magunde, Isu ne ithek shii athodang pha ai yung shii hanyie mukho ji sow ne riig dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Bimi ji è aishii nyie rek phi pha ji now ne sham ne rum srane Isu lai luii shii wuii ne lagiung niing ne khung ne izai yao. ");
INSERT INTO bgg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Isu è ji pha bimi shii yao, “Gu dimi, naro migi è naro rad pha ji ne gang jong ro, jiè nane sang ne dun bo. Na è diig ne rad pha ji de gang dun bo.” ");
INSERT INTO bgg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Isu è jithek pha miyao yao ramuii shii, Jairuis hò è muaphothek wuii thog srane Jairus shii yao, “Na dimi ne iy jong dun ro, nyie rek ne Masdo shii nyama diig phi phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Isu è ithek nyie yao pha ji ayoi pha rek srane, Jairus shii yao, “Na ne arum chid rabo, migi now mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ji è yao srane Isu è gaithek shii anoh pha, Phithar, Jems chiih-è ikhuii Jon shii noh srane thiisa hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ithek Jairus hò hà thog shii, Isu è yoi, ithek ne anomuluii pha ziak ne cho ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Isu-è iliing hà wuii srane ithek shii yao, “Nathek ne nyie rek ne anomuluii pha rey phlei? Chiih-è nathek nyie rek muii ne choh phlei? Ani ne a-iy ba ro, ai ne men bie ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ji è yao mage ne ithek ne Isu shii siak, jiè Isu ne ithek shii fuang hà thoh maruii srane ani ji pha aphuii chiih-è amuii chiih-è awai samoy uom shii noh ne ani men pha ùgud bucho hà khud dun. ");
INSERT INTO bgg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ai è bimi shii awai wad è giak srane yao, “Thalitha, khoum” jine “Bimi duii rone ho pha ji ro, gu è na shii sieng mage bo è yao ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bimi ji è siengfad srane lua mage, (ai yi dam snanyi rey sha pha bimi ro), ji è rek mage shii, thiichiih um pho thek ne ji riig ne wiengdun. ");
INSERT INTO bgg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jishii, Isu è ithek shii ji pha miyao ne hanyie shii de ayao rabo ne yao srane yung ne ji pha bimi shii chie pha phi ne chie yi pha yung phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ji è rek marui ne Isu ne ji pha ithua thoh srane awai samoythek shii noh ne awai thiig pha hò hà dun marui. ");
INSERT INTO bgg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jewthek Thung pha Inai shii, ai è Hamangkhung-aphuii ro Jewthek misiahò hà wuii srane jao ne yua. Ai miyao nuii pho thek de bajo um, ithek ji pha miyao yoi mage ne, zab wiengphleg dun. Ithek è awaithek chung sai rai, “Ai ne buangthek ne khi-è ìd ne yao dun phlei? Aishii ne khi-èrek pha khani zen ne ruii phlei?” “Ai ne hìthek wieng pha blia ne khi re-è mua phlei? ");
INSERT INTO bgg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hì pha bufuii ne Mery pha dufuii chiih-è Jems, Joseph, Judas chiih-è Simon thek pha khuiino, zao rab ne rai pha ji asi bey? Ai bumuii ne ichiih shii rai pha ji asi bey?” Ji è yao srane thiichiih pho thek è aishii snai mua phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Isu è ithek shii yao, “chaig pho shii ne awai hò, awai thiig, awai bran, awai haliing pho thek è wie anow phro, jishii gai thek ne aishii wie now ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ji-è ai ne thiichiih shii nyie bliathek de arek mua phi, wad riie ne rad pho shii kho ne gang phi bie marui. ");
INSERT INTO bgg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ai ne bajo buangthek arek mua, nyieliieshii, ithek è aishii migi arek phi ro. Chiihphado Isu è thiichiih inui shii um pha thiigthek hà wuii srane ithek shii miyao ji yua ne rai phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ai è awai samoy snanyi thek shii ho srane nyi nyi rek ne thiig jithek hà thoh ge phro. Ai è ithek shii ibuii ragung thek shii khia pha riichai phi srane thoh ge. ");
INSERT INTO bgg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Chiih-è ithek shii yao, “Nathek rog shii thagin yi bie ne nyie de ayie chiid rabo, iweb, bang chab pha shukhug biia, chiih-è, michie pheg ne chie pha bang thek de ayie chiid pha lua bo. ");
INSERT INTO bgg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lakhia ne khia bo, jishii, lai ne guii pha phadiigthek ne ahan chid rabo.” ");
INSERT INTO bgg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ai è dinne ithek shii yao, “Hanyie è, ithek shii wie ho ne hò hà rai yi arone, nathek ne ji pha thiig athoh sapho shii ne ji pha hò shii rai bo. ");
INSERT INTO bgg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Chiih-è nathek ne khi pha thiig shii wuii thog shii, ji pha thiigpho è nathek miyao nuii ne ithek shii ho ne arai yi arone, ithek ne ji pha thiig thoh ne dun juang shii, nawai thek lakhia pha nyiakphlab thiichiih kham ne fen srane dun marui bo. Ji rek phane ithek shii diig thog yi pha phriie marui phro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ji è yung ched ne ai samoythek è thiigthek hà miyao ji yua ne ithek layog rek pha ji è thadoh dun yi pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ithek è ibuii ragung jiang pho thek shii khia phi, chiih-è, rad pho thek shii de thiiliie è shun srane gang phi phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ji è rek ched mage shii Herod Saja è jithek rek pha zab yoi dun, nyieliieshii, Isu pha beng ne bajo boh re dun. Chiih-è giak è shii yao shii, “Ai ne khowo phi pha Jon ji idoh hòi ne dun thog din ara! Ji-è aishii ne buangthek rek pha blu de um ro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Giak è yao, “Ai ne Elija ro.” Giak ne, “Ai ne buyo pha chaig pho duiine ro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod Saja è ji pha miyao nuii srane yao, “Ai ne khowo phi pha Jon ji bey! Ai khrug shii ne tham jong muii bidey ne, dinne ai ne hòi dinne bey!” ");
INSERT INTO bgg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod awai è yung ne Jon shii zum ne, shiirnai rek ne phang ne phatheg iliing hà chab muii phro. Ji è rek phane Herodias muyung ne rek yi ro, ai ne ikhuii Philiph pha yiy shii Herod awai yi din dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon è Herod Saja shii athodang pha yao ne rai, “Na ne nawai khuii pha yiy ji yi phane Iphey shii zen oi ro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ji è yao pha idoh è Herodia Sajamuii (Herod pha yiy) ne bajo lijieg srane Jon shii ua yang pha now, jishii, thaluii shii ne a-ua mua phi, nyieliieshii Herod Saja um niing ro. ");
INSERT INTO bgg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod Saja ne Jon shii bajo rum, nyieliieshii, Herod Saja è Jon ne bajo wie chiih-è bajo gang bran rone thieg dun. Ji-è ai ne Jon shii wie gayiig ne ruii, ai ne Jon miyaothek è lubu shii liijiing oi magunde, ji pha miyaothek ne bajo wie now ne nuii ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ji è rek magunde, Herodia Sajamuii è inai jia shii zo mua ne, ji pha inai ne Herod Saja giak pha inai ro, Herod Saja è dumuii boh pho, shii è arming pha boh thek chiih-è Galili thiig pha wegthek shii ho ne michie phi ramuii shii, ");
INSERT INTO bgg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia dimi è iliing hà wuii ne gasiu siu srane Herod Saja chiih-è ai biwenthek shii bajo lubo rek phi, ji-è, Herod Saja è awai dimi shii sai, “Na ne nyie chiid pha now lei? Chiih-è nane gu shii nyie lia magunde, gu ne nyaphi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ai è surua thok srane yao, “Na è nyie lia magunde, gu, na shii ji phi ruii phro, guro Sajathua ji khuyo lia na de nyaphi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dimi ji è fuang hà wuii srane ai amuii Herodia shii sai, “Gu ne nyie lia chiid phlei?” Ai amuii è yao, “Khowo phi pha Jon ro khrug lia mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ji-è ai dimi ne khthiie iliing wuii din srane Herod Saja shii lia, “Gu ne na shii Jon khrug lia phro, Jon khowo phi pha khrug tham ne phandua shii giong ne thuh shii phi-dang mage bo.” ");
INSERT INTO bgg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jipha miyao è Herod Saja ne bajo zo dun, jishii ai dimi shii agak mua, nyieliieshii, ai è biwenthek moe shii surua thak jong muii ro. ");
INSERT INTO bgg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ji-è ai ne Jon khrug tham pha awai sandrithek shii thoh ge phro. Ji è yung mage ne ji pha sandri thek ne phatheg duchoi hà wuii srane Jon ro khrug tham mey phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chiih-è ji pha Jon khrug ne phandua lakhung shii giong srane awai dimi shii phi ro, ai dimi ji è choi srane ai amuii shii yi ne phi din phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon pha samoy pho è ji pha mua yoi mage ne wuii srane iy pha siu ji yi ne wieng mua phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ji phado samoythek ne Isu shii dun thog srane ithek è nyie thek rek ne yua marui pha jithek yao phi. ");
INSERT INTO bgg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Thiichiih shii de ithek è Isu chiih-è ai samoythek shii chie pha de uhug oi dang pha wuii ruii mage. Ji-è Isu ne awai samoythek shii yao, “Cho! Gethek ne liijiing pha ithua hà dun sharai haro, chiihphado gethek de ìujia ne thung pha mua ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ji-è ithek ne liijiing um pha ithua hà thog yi pha run shii in ne wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ji è rek magunde, Isu chiih-è samoythek ne ithek moe è yo pha rek muii rone ibi than dun, chiih-è, Isu ne hanyie ga ji thieg muii pha ji è, ithek ne gai thiig è dong ne lua pha lumuii è ran srane Isu chiih-è ai samoythek wuii thog pha ibi hà rai iang phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Isu run è fuang lung mage shii, thiichiih shii bajo ibrog um iang mage ne ai lubu ne iy dang pha bushun now dun phro, nyieliieshii, ithek ne brogpho oi pha shiishai duiine um iang, jiè ai ne, ithek shii bajo miyao jao ne yua. ");
INSERT INTO bgg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ji è rek ne rai shii, bajo chia dun pha ji è habjuang re sha pha rek mage ne, ai samoythek è ai moe shii wuii srane yao, “Gethek ne bajo chia jong dun ro, ichiih shii ne thiigthek de inui oi pha ithua ro. ");
INSERT INTO bgg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ithek shii thoh sha mage bo, chiihphado, awaithek è thiigthek chiih-è raighò sow srane awai thek chie niing pha nya pheg mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Isu è yao, “Nathek ne ithek shii chie pha phi mage bo.” Ithek è Isu shii sai, “Gathek è bajarai hà wuii srane liiman simedthek wieng nyi pha iweb pheg ne phi ne chie yi pha yang bey?” ");
INSERT INTO bgg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ji-è Isu ne ithek shii sai, “Nathek shii khama iweb um lei ne riig mage bo.” Samoythek è ithek shii sai nathek shii iweb khama um lei, ithek è yao gathek shii ne iweb guii chiih-è ù nyi um bie ro. Ji-è ithek è Isu shii yao, “Iweb guii chiih-è ù nyi um ro.” ");
INSERT INTO bgg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ji è yao mage ne Isu è awai samoythek shii yung, “zab thek shii ibrog yo rek ne saing lakhung shii dug yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ji-è ithek ne ibrog yo rek srane dug iang yi, giak ibrog shii ne wieng jia, chiih-è giak ibrog shii ne saguii rek srane dug dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chiih-è, Isu è iweb guii chiih-è ù nyi ji yi srane hamangkhung hà mau ne Hamangkhung-aphuii shii laso phi. Chiih-è, iweb ji chiing ne phed srane awai samoythek shii phi ne ithek shii thang yi. Chiih-è, ù shii de thang yi. ");
INSERT INTO bgg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ji-è ithek ne lumuii dang pha chie dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chiihphado samoythek ne led pha iweb chiih-è ùthek sirid snanyi ley dang pha khrab gieng phro. ");
INSERT INTO bgg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Thiichiih chie noh pho ne itham guii ro. ");
INSERT INTO bgg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Luangjia shii, Isu è thiichiih wuii pha ibrogthek dun ge yi shii, awai samoythek shii de run shii in ne Bethsaida pha khabang thrang hà wuii iang pha thoh ge. ");
INSERT INTO bgg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ithek shii wie dun bo ne yao ched shii Isu awai de phiing hà sia pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jipha habjuang re mage shii, run ne khabang pha duchoi hà thog ne um dun, Isu ne awai ji khabang thrang hà rai ramuii shii, ");
INSERT INTO bgg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Isu è awai samoythek shii run iliing hà bajo diigchiao rek ramuii pha doh ruii, nyieliieshii, Hasamkhanoi khed ramuii pha ji è ithek run ne shao thiwie pha rek dun. Ji-è Isu ne hamiang riang shii kho lakhung è lua ne samoythek moe hà wuii ruii, ");
INSERT INTO bgg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Isu ithek moe thog pha re ramuii shii Isu è kho lakhung shii lua mage ne ithek ne zab rum ne ziak ne yao, “Ai ne ibuii ro!” ");
INSERT INTO bgg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ithek è aishii doh mage ne zab rum dun phro. Isu è ithek shii yao, “Arum chiid pha lubu boh now mage bo! Hì ne gu ro!” ");
INSERT INTO bgg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ji è yao srane awai de samoythek rog run shii in mage shii Hasam de awai lum ne them dun. Ji è rek mage ne samoythek ne zab wiengphleg ne wieng dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nyieliieshii ithek ne Isu è itham guii bran shii iweb chiih-è ù phi ne chie yi pha miyao siu ne agao mua pha diig ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ithek ne khabang ji hiìa ne Genesareth beng pha soh shii wuii thog, thiichiih shii ithek è run ne phang ne ruii marui srane lung dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ithek ne run è nyalung dang shii, ithek è Isu shii ibi thieg dun. ");
INSERT INTO bgg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ji è ithek ne thiig hà ran srane zab shii yao iang, chiih-è, khama rad pho um phane Isu khi shii um pha ji shii noh ne wuii thog srane biang shii thieng yi. ");
INSERT INTO bgg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Isu è khama pha thiig raig chiih-è bajarai hà wuii thog nede, ithek è khama rad pho um pha chiih-è chongjai rek pha ithua shii noh srane ai yung shii ìujia magunde khoh yi pha ithek shii khung ne lia phro. Hanyie è ai yung khoh mua pho ne zab gang dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pharisithek chiih-è Iphey yua pha masdothek ne Jerusalem è wuii srane Isu moe shii khrab ne riu thog ruii. ");
INSERT INTO bgg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ithek è ai samoythek ne Iphey shii zen pha duiine arek pha, wad achun pha michie chie pha doh ruii. ");
INSERT INTO bgg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Nyieliieshii, Pharisithek chiih-è Jewthek ne riingthek è zen pha Iphey ji rek ne rai. Ithek ne wad achun bi sapho ne michie achie. ");
INSERT INTO bgg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chiih-è, bajarai è yi pha nyie magunde asud sapho shii ne achie bi pha rai. Chiih-è, gai khama pha Iphey awaithek pha riingthek muyua marui jithek ne athoh dang pha rek ne rai, jithek pha Iphey ne gog, jarai, blow, skhong chiih-è biangthek sud pha Iphey ji ro.) ");
INSERT INTO bgg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ji-è Pharisithek chiih-è Iphey yua pha masdothek è Isu shii sai, “Na thek ne nyi rek ne boyo riingthek mizen marui pha Iphey ji anuii pha rek phlei? Iphey ji nuii ne wad chun ne chie pha asi pha wad zia è michie chie khlei ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Isu è ithek shii chang, Aijaya è chaig ne nathek shii lawasdai ro è zey pha ji izai chak ara ro! Ai è zeyjong pha ji duiine: Hì pha branthek è Hamangkhung-aphuii shii yao, gathek ne miyaogamthek rog na shii ilab rek, jishii, ithek ro lubu ne gu è bajo ruang ro. ");
INSERT INTO bgg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ithek è gu shii sia pha ji ne thaluii ro, nyieliieshii, ithek è, jine, Hamangkhung-aphuii pha Iphey shii yua pha khalo shii, ithek ne bran murab pha Iphey ji yi Hamangkhung-aphuii murab rone yua ne rai ro! ");
INSERT INTO bgg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nathek ne Hamangkhung-aphuii pha muyungthek ne the hà ruii muii srane bran muyua pha jithek rek ne rai phro.” ");
INSERT INTO bgg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Isu è athodang pha yao ramuii shii, “Nawai thek è Iphey shii nyieliieshii Hamangkhung-aphuii ro Iphey shii snai yi pha rek phro.” ");
INSERT INTO bgg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses muyung pha Iphey ne, nawaithek pha aphuii chiih-è amuii shii ilab rek bo, chiih-è, hanyie è aphuii amuii shii awie pha yao arone, aishii ne ua muii bo. ");
INSERT INTO bgg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jishii, ithek ne, nawaithek pha aphuii-amuii shii anong phi pha ithek ne jine Hamangkhung-aphuii rone yao phro, ");
INSERT INTO bgg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ji-è thuh shii ne nathek è awaithek aphuii-amuii shii anong yi ara ro. ");
INSERT INTO bgg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hì duiine, ithek muyua hì dun thog pha hìne Hamangkhung-aphuii pha miyaogam shii snai yi phro. Ji asi bie pha ji duiine ithek è gai bliathek de bajo rek ne rai. ");
INSERT INTO bgg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Din ne Isu è ibrogthek shii ho din srane yao, nathek de gu miyao nuii ne ìd mage bo. ");
INSERT INTO bgg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nyie magunde, fuang è bucho dun phane Iphey shii zea azen ro. Zia rab phane bucho è fuang khia ruii pha ji è zea rab ruii phro.  ");
INSERT INTO bgg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nathek shii nuii pha khoh um arone, nuii mage bo. ");
INSERT INTO bgg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Isu ibrog jiè thoh srane hò hà dun thog shii, samoythek è aishii sai, najang yao pha ji gathek ne a-ìd mua ro, gathek shii yao riig bo, ");
INSERT INTO bgg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Nathek ne athieg bey? Nathek ne gai è de bajo athieg dang pho ro! Isu è ithek shii yao, ichiih shii ne bran bucho è zea re phro, fuang è zia are mua phro. ");
INSERT INTO bgg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nyieliieshii, jithek ne lubu hà adun pha luii bucho hà dun srane fuang khia din dun phro.” Isu è yao pha ji ne, zab pha michie ne nyachie mua phrone yao ro. ");
INSERT INTO bgg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ai è yao din, “Bran è fuang nyie khia ruii pha ji è zea rab ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chiih-è lubu iliing hà awie pha now pha ji ne fuang de khia ruii phro. Jithek è biwo re pha lumuii hà noh dun phro, jithek ne mugo pha, ua, sugoh rek pha ro, ");
INSERT INTO bgg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","siulao rai pha, hanyie shii now bie pha chiih-è, biidiie yao pha, wie è arek pha gidieg rek pha, gai shii buii yao pha, nyigodog, minyiagachi, chiih-è bi-ìe blia rek pha miyao ro. ");
INSERT INTO bgg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hì-thek zab awie pha muna ne lubu iliing è khia khlei ne ji shii zea rab phro.” ");
INSERT INTO bgg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ji è yao ched ne Isu è ithek shii thoh marui srane Thaire beng pha rajan moe hà wuii dun. Ji hà wuii thog mage shii ai ne hò jia shii khud srane ithek è athieg yi pha ug ne rai dun. Ji è rai dun magunde, ai ne thiichiih shii ug ne arai mua. ");
INSERT INTO bgg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ibuii ragung jiang pha bimi jia pha amuii è Isu wuii thog pha ji yoi mage ne khthiie wuii srane Isu lai luii shii bam ne yao. ");
INSERT INTO bgg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jipha hò-amuii ne Jew asi ro, ai ne Phoenikhia du-ùa Syria pha thiig hà giak pha bimi ro. Ai è Isu shii wad khung ne yao, “Gu dimi shii ibuii ragung è jiang pha ji ne na ne khia maphi bo.” ");
INSERT INTO bgg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Isu è chang, “Igo bi ani phiing shii yem ne chie yi bo. Aniphiing pha michie yi srane choi shii yem muii pha ji dunmey ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ai è Isu shii chang, “Masdo” “Na miyao jine izai chak ro, jishii aniphiing pha michie thiibliie è nyiak hà chiih dun pha ji ne choi de nyachie mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ji-è, Isu è aishii yao, “Na ne khthiie hò dun din mage bo, hì pha miyao chiang è, na dimi pha ibuii ragung jine khia jong ne rai iang pha doh ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ji è yao mage ne ji pha hò-amuii ne hò dun ne riig shii, ibuii ragung ne izai ai dimi è khia jong dun pha doh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ji è rek ched marui ne Isu ne Thaire thiig shii thoh din marui ne Sidon pha thiig è dong srane Galili khabang iring shii wuii thog. Chiih-è sua thawunthek rone beng pha ithua è dong ne lua. ");
INSERT INTO bgg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ji hà lua shii giak thek è bi-ìe jia noh ne wuii thog ruii. Ithek è aishii wad è khoh pha Isu shii khung ne yao. ");
INSERT INTO bgg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ji-è Isu ne ji pha bran shii awai ji noh dun srane awai wad è khohthek shii khoh srane chan cho phi, chiih-è, ji pha bran ri shii de khoh mage. ");
INSERT INTO bgg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ji è rek srane Isu è hamangkhung hà riig srane lubu è wie now srane ji pha bran shii yao, “Ephphatha,” Hì ne hong mage bo! Iyao pha miyao siu ji ro. ");
INSERT INTO bgg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ji è rekdang pha ji shii ji pha bran ro ikhuii è yoi dang dun, chiih-è, ai sem gliog pha de wie re dang ne agliog pha yao dun. ");
INSERT INTO bgg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ji è rek ched pha idoh è Isu ne thiichiih um pho thek shii ji rek pha ji ne hanyie shii de ayao dang yi pha rek phro. Isu è khama nyuak doh ne ruii, ji è de muna ithek ne yao maphi. ");
INSERT INTO bgg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hanyie thek è jithek rek pha ji yoi mage ne zab ne bajo nyu-dang dun ro. Ithek ne awaithek chung yao rai, “Ai ne hì thek rek phane khi-è mua dun phlei? Ai ne khoh ayoi pho shii de yoi yi dun, sem ayao mua pho de yao mua yi dun!” ");
INSERT INTO bgg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Din shii de ithek ne Isu miyao nuii pha bajo wuii thog ne rai dun. Chiihphado thiichiih shii ithek chie pha nyie de oi, jiè Isu ne samoythek shii ho srane yao, ");
INSERT INTO bgg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gu ne hìthek pho shii bajo bushun now mua ro, nyieliieshii ithek de gu rog shii rai ne inai da-uom re sharo, jiè chie pha nyie de oi pha re dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Gu è ithek shii nyie magunde aphi achie yi pha lui isloi hò dun din gey arone, yang ne lumuii hà chi-iy ne khrisiang ne re mage phro, nyieliieshii giak ne bajo ruang è wuii pha de um phro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ai samoythek è sai, “Ichiih balimuang shii ne ithek nyama shii chie yi pha michie ne khi-è yi mage phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isu è sai, “Nathek shii iweb khama um lei?” Ithek è yao, “Sudoh ne iweb miley um bie ro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ai è ithek shii nyiaklieg shii dug pha yung. Chiih-è iweb miley ji yi srane Hamangkhung-aphuii shii laso phi, chiih-è iweb ji phed srane awai samoythek shii phi ne zab shii thang yi. Samoythek de ji è rek phi. ");
INSERT INTO bgg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chiih-è, ithek shii ù de ìujia um bie. Isu è ji de yi srane Hamangkhung-aphuii shii laso phi srane, awai samoythek shii phi ne thang yi. ");
INSERT INTO bgg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Itham wi branthek de lumuiidang pha iweb chiih-è ù chie phro, chiih-è, ikhe de sirid miley ley um ba dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ji è rek ched ne Isu è ithek shii dun ge yi, khthiie ithek ne run jia mua srane ai samoythek rog shii in ne Dalmanutha pha thiig hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Inai jia shii de Pharisithek ne wuii srane Isu shii khnaing, nyieliieshii, ithek è aishii chai pha now. Ithek è chai hì ne Hamangkhung-aphuii è chua phi rone doh yi pha Pharisithek è aishii buang pha blia rek mage bo è yung. ");
INSERT INTO bgg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ji è yung magunde, Isu è lubu iliing hà zud ne khran srane ithek shii yao, “Thuh pha branthek ne nyie now ne wieng rek yi pha yao phlei? Gu nathek shii izai yao phro, hì è rek pha blia ne gu nathek shii aphi phro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ai è ithek shii thiichiih thoh marui srane run hà in dinne, khabang thrang pha ithua hà dun marui. ");
INSERT INTO bgg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Samoythek ne run hà iweb de dau ne chie pha ne bia ne ayie pha wuii dun. Thiichiih shii iweb ne jia um dang bie. ");
INSERT INTO bgg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ji è rek srane Isu è ithek shii phriie ne yao, “Pharisithek phiia nane Herod pha phiia è nathek ne gayiig ne rai iang bo.” ");
INSERT INTO bgg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ithek ne awaithek chung yao rai, “Ai è hì yao pha ne gethek è iweb ayie pha chiang è yao phro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Isu è, ithek nyie yao ramuii pha jine thiegjong muii ne ithek shii sai, “Nathek ne iweb oi pha chiang è nyie yao rai phlei? Nathek ne thuh de athieg agao ba bey? Nathek khani ne thuh de adau ba bey? ");
INSERT INTO bgg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nathek mieg ne um shii ariig lie ara? Nathek khoh ne um shii ayoi lie ba ara? Nathek ne anow bey? ");
INSERT INTO bgg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gu è iweb guii um iang pha ji shii phed srane itham guii pha branthek shii phi ne chie noh chiih-è nathek led pha iweb ne khama ley sirid chiing phlei?” Ithek è chang, “Snanyi iweb sirid chang ro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ai è ithek shii sai din, “Chiihphado ithek de gu è iweb miley phed ne itham wi shii phi ne chie yi pha ji è led pha sirid khama ley pha chang gieng phlei?” “Ithek è chang, sirid miley led phro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Din ne de ithek shii sai din, “Nathek ne thuh de agao ba bey?” ");
INSERT INTO bgg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ithek ne Bethsaida hà wuii thog shii, ithek è miegthi pha jia ne Isu moe shii noh srane Isu shii khung ne yao, “ìujia khoh mage bo” ");
INSERT INTO bgg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Isu è miegthi pha bran wad chaing srane thiichiih pha thiig è fuang noh srane ai mieg shii chan cho srane wad è khoh ne aishii sai, “Na mieg ne doh sha bey?” ");
INSERT INTO bgg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chiihphado hù ne riig srane yao, “Oh, gune branthek shii doh sha ruii ro, jishii ithek ne hingmuii duiine lua pha doh muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Isu è dinne ai mieg shii wad è khoh, chiihphado ai mieg ne idoh thog din ruii ne ai mieg ne wuangwuang doh din dun. ");
INSERT INTO bgg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chiihphado Isu è, aishii yao, “Hò hà dun bo chiih-è ji pha thiig hà dinne awuii sha rabo.” ");
INSERT INTO bgg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chiihphado è Isu chiih-è ai samoythek ne ji pha ithua thoh srane Khaesarea Philiphi beng pha thiig moe hà wuii dun. Lumuii hà lua ramuii shii, Isu è ithek shii sai, “Nathek de yao riig bo, ithek è, gu shii hanyie rone yao lei?” ");
INSERT INTO bgg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ithek è chang, “Giak è na shii ne Jon khowo phi pha ji rone yao muii ro, chiih-è, giak ne, na shii ne Elija rone yao muii ro, chiih-è, giak ne, na shii ne chaig rone yao muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ai è ithek shii sai din, “Jishii ithek ne gu hanyie leine now ga?” Phithar è chang, “Na ne Masi ro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ji-è, Isu ne ithek shii yung, “Gu chiang pha miyao ne hanyie shii de ayao rabo.” ");
INSERT INTO bgg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chiihphado shii Isu è awai samoythek shii yua pha jao din phro, “Bran Dufuii ne bajo riie ne chiih-è dukhothek è de, Phabi boh thek è de, chiih-è, Iphey pha masdothek è de snai muii phro. Aishii ne ithek è ua muii phro, jishii, ai ne iy ne da-uom shii chai hòi din ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hì pha miyao ne Isu è ithek shii sang yao dang phro, ji-è, Phithar è de thekhlei hà noh srane aishii jao ne giung. ");
INSERT INTO bgg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jishii Isu è idoh awai samoy shii rei ne riig srane, Phithar shii giung, “Na gu moe è ruang dun mage bo, ibuii,” Ai è yao. “Na munowthek ne Hamangkhung-aphuii è asi ro jishii na munow jine bran è ro!” ");
INSERT INTO bgg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chiihphado Isu è ibrogthek shii chiih-è awai samoythek shii awai hà ho, “Hanyiemagunde gu rog shii wuii arone, ai ne awai shii bia bi srane, awai bai han ne, gu rog shii wuii gieng bo. ");
INSERT INTO bgg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chiih-è hanyie è awai chai shii ragia rek yang pha now arone awai chai ne mua ruii phro, jishii hanyie magunde awai chai gu chiang shii chiih-è mua yao pha chiang è iy arone jine ragia re phro. ");
INSERT INTO bgg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bran hanyie è de sohjambling pha zab mua srane jishii awai chai shii mua muii arone nyie magunde mua bey? Amua phro! ");
INSERT INTO bgg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hì ne bajo chia dun phro, ithek shii ne Hamangkhung-aphuii è chai pheg pha igong phi pha de siok pha oi ro. ");
INSERT INTO bgg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Branthek è awie pha inai chiih-è biidiie pha hamangkhung aphuii ro yua pha inai shii gu muyua shii chiih-è gu shii wo arone, Bran Dufuii yi awai Aphuii ro biisiie ro gang hamangkhliie rog wuii ruii shii ithek shii de wo phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chiih-è de ai yao ramuii, “Gu nathek shii yao, ichiih um pha giak branthek weg are ba shii Sajathua pha Hamangkhung-aphuii ne awai blu rog shii wuii ruii pha ji doh ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dariig pha idoh shii Isu è awai rog shii Phithar, Jems, chiih-è Jon, chiih-è ithek shii laziung phiing giu hà awai ji bsa hà noh dun. Ithek è aishii riig ramuii shii, Isu ne lai dun ro, ");
INSERT INTO bgg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","chiih-è, airo yung ne imo re srane khlieng chuang ne ichiih sohjambling pho ne hanyie de acham mua sapho rey dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chiihphado shii samoy uom è Elija chiih-è Moses ne Isu rog shii mulo pha doh ro. ");
INSERT INTO bgg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phithar è Isu shii yao, “Masdo, gethek ne ichiih shii um pha ji ne bajo wie ro! Gethek ne ichiih shii haliig uom rab ne, jia yi na shii rab phi, jia yi Moses shii rab phi, chiih-è jia yi Elija shii rab phi haro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ai nane gai ijakthek rum ne nyie yao chiid pha ji ne athieg ro. ");
INSERT INTO bgg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chiihphado è sakhamiing thab srane chiih-è ragia rog shii cheg dun phro, chiih-è goh yi sakhamiing è yoi ruii phro, “Hì ne guro bushun pha Dufuii ro, chiih-è aishii nuii bo.” ");
INSERT INTO bgg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ithek è khthiie shan ne riig shii, jishii nyie de adoh pha, Isu um pha doh bie phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ithek Phiing è thazam nya dun thog shii, Isu è ithek shii yung, “Sudoh shii nathek è nyie doh pha ji ne bran Dufuii ji iy ne ahòi sapho shii ne, nathek ne hanyie shii de ayao rabo.” ");
INSERT INTO bgg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ithek è ai muyung ji nuii ne rai, jishii awaithek chung ji pha miyao jao ne mulo rai, “Hì ne iy pha ji è nyie khi-èrek ne hòi din phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chiih-è ithek è Isu shii sai, “Nyie rek ne Iphey yua pho masdothek è Elija ne ibi wuii ruii phro è yao phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Isu è ithek shii chang pha ji ne, Elija ne zai zab khriig rek pha chiang shii ibi wuii ro. Thuh jigigam shii nyie rek ne Bran Dufuii ne bajo diig re ne snai muii phlei? ");
INSERT INTO bgg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jine gu nathek shii yao phro, “Elija wuii thog jong ne chiih-è, branthek è aishii nyie rek yang pha ji rek phro, jigigam è de ai chiang shii yao phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ithek è gai samoythek rog shii dog mage shii, ithek è bran ibrogthek ne chiih-è Iphey yua pha masdo giak ne ithek rog shii khnaing noh phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Branthek è Isu shii doh mage shii, ithek ne bajo nyu ne, chiih-è aishii ran sra ilab phi. ");
INSERT INTO bgg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Isu è awai samoythek shii sai, “Jiphachiang è nathek nyie khnaing rai phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bran jia yi ibrog re-è chang, “Masdo, gune guro dufuii na shii noh phro, nyieliieshii aishii ne ibuii ragung um ne ayao mua ro. ");
INSERT INTO bgg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ibuii ragung, aishii bangchiie rek mage shii ai ne nyiak hà thud ne, chiih-è ai sem è imamiung khia ne, chiih-è shiinyin de khreig srane, zab gangwieng ne rai dun phro, gu è na samoythek shii ibuii ragung khia phi bo è yao shii ithek ne akhia mua phi ro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Isu è ithek shii yao, “Nathek ne migi anow pho bey? Gune nathek rog shii khama phiang rai mua gieng phlei? Gune nathek rog shii khama phiang zud mua phlei? Jipha bufuii shii gu moe hà noh mage bo!” ");
INSERT INTO bgg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ithek è aishii Isu moe hà noh. Ragung è khthiie Isu shii doh mage ne ai è bufuii shii ne sham ba yi, chiihphado nyiak shii fen srane shan ne sem è imamiung khia phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isu è ai aphuii shii sai. “Ai è rek pha ji ne khama re lei?” Ai è chang, “Ai mirek hì ne ìu è rek ro. ");
INSERT INTO bgg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Idang aishii ne ibuii ragung è bai hà chiih-è kho hà fen ne ua muii pha rek phro. Na è rek mua arone! Gathek shii bushun rek ne chiih-è gathek nong phi bo.” ");
INSERT INTO bgg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Um, Isu è yao, “Nathek è nawaithek shii rek mua arone! Bran hanyie shii migi um pho ne zab nya re mua ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ai aphuii è khthiie ziak srane yao, “Gune migi um ro, jishii akhriig ba ro, muna um yi pha gu shii nung phi bo!” ");
INSERT INTO bgg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Isu è riig shii bran ibrogthek ne ai moe shii nui wuiiramuii, jiè ai è awie pha ragung shii yung mage. Ai è yao, “Khohphang chiih-è sem ayao mua pha ragung wo! Gu nathek shii yung phro bufuii è fuang khia srane, chiih-è, dinne bufuii shii awuii dang sha rabo!” ");
INSERT INTO bgg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ragung è ziak mage, bufuii jine awie dang pha thud sra driiedriie sham ne chiih-è fuang khia dun. Bufuii jine bi-iy duiine doh dun ro, chiih-è zab è yao, “Hì pha bufuii ne iy dun ro!” ");
INSERT INTO bgg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jishii Isu è bufuii shii sieng yi pha awai wad è khoh srane ne noh ne nong phi phro. Chiih-è ai ne riu mua dun. ");
INSERT INTO bgg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Isu è hò bucho hà wuii dun pha idoh shii, ai samoythek è aishii ug ne sai, “Nyie rek ne gathek è ragung shii akhia mua lei?” ");
INSERT INTO bgg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Isu è chang; Hì è rek ne fuang khia pha ne misia è rek-mua bie phro, gai è rek mua pha nyie de oi ro. ");
INSERT INTO bgg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Isu na awai samoythek thiichiih pha ithua thoh srane Galili è wuii dun. Isu è ai khi hà um lei ne athieg yi pha now phro, ");
INSERT INTO bgg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nyieliieshii ai ne awai samoythek shii yua ramuii: “Bran Dufuii shii ne zum ne hanyie è aishii ua ji pha bran wad shii phi muii phro. Da-uom pha idoh shii hòi din phro, ai ne chai shii sieng din ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ji è yao magunde, samoythek è ji pha miyao ne agao pha rek ne rai dun, chiih-è, dinne sai pha de rum dun. ");
INSERT INTO bgg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Din ne ithek Khaphernaum hà thog srane hò iliing hà khud ne dug shii, Isu è awai samoythek shii sai, “Nathek lumuii hà nyie chiang è khnaing rai phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ji sai magunde, ithek ne nyie de achang phi, nyieliieshii ithek ne lumuii hà zab è hanyie boh um lei ne sai srane khnaing rai phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Isu è dug srane awai samoy snanyi shii ho srane yao, “Hanyie yi zab è bajo mugak rek yang arone, ai ne zab è ìu rek ne gai khiao rek bi bo.” ");
INSERT INTO bgg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ji è yao srane, ani jia shii ho srane ithek moe shii noh ne riu yi. Chiih-è ani-shii wad è giak srane yao, ");
INSERT INTO bgg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hanyie magunde, gu beng è hì pha ani shii ho arone, ai ne gu shii de ho ruii phro, chiih-è, hanyie è gu shii ho arone, ai ne hanyie è gu shii thoh ge pha ji shii de ho phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon è aishii yao, “Masdo, na beng è ibuii ragung khia ne gieng pha bran jia doh ro, jishii, gathek è aishii gak ne thoh marui phro, nyieliieshii, ai ne gethek rog pha bran asi ro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Isu è ithek shii yao, “Aishii agak chid rabo” nyieliieshii, hanyie gu beng è buang ji rek phi pha ne, dinne gu shii awie pha miyao ayao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hanyie è gethek shii buii arek pha bran ne gethek ro ro. ");
INSERT INTO bgg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Gu ne, nathek shii izai yao dang phro, “Hanyie magunde ithek shii gu chiang è kho magunde phi ne niing yi arone, aishii de ji pha lasen ne mua ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Hanyie magunde, ichiig oi pha branthek shii mua yi arone, ji pha bran shii ne yua shii rathak boh bang srane khamuii hà fen muii pha ji wie ba phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ji-è ithek wad è migi shii la-ìu-ìu rey yi arone, ji pha wad ne thamthiak muii, ");
INSERT INTO bgg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","wad nyi um ne thumuluii hà, idang bai shud ne rai pha ithua hà dun pha ji shii ne wad oi pha chai hà dun pha ji wie phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chiih-è, nathek lai è ithek migi shii san pha rek ruii arone, ji pha lai shii ne thamthiak ne fen muii bo.  ");
INSERT INTO bgg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nyieliieshii, lai nyi um srane thumuluii hà fen yi pha ji è ne, lai oi pha chai hà khud pha ji wie ba phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chiih-è, nathek mieg è nathek migi shii la-ìu-ìu rek noh arone, ji pha mieg ne yog muii bo. Nyieliieshii, mieg nyi um srane thumuluii hà fen yi pha ji re-è ne mieg jia oi ne Hamangkhung-aphuii pha Sajathua pha ithua hà khud muii pha ji wie liak phro, ");
INSERT INTO bgg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nyieliieshii, bsa thumuluii pha phuyunthek ne khuchung de a-iy phro, chiih-è, shud pha bai ji de khuchung de anyia phro. ");
INSERT INTO bgg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Nyieliieshii, zab pha branthek shii khlem pha ji shii suruii lao srane gang rek pha duiine bai è shud ne sang ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Suruii ne wie ro; jishii ji pha suruii yi aphieng pha re dun arone, dinne ji pha suruii ne khi-èrek ne phieng rab mua phlei? “Ji-è suruii phieng duiine nawaithek chung de wie rek ne rai bo, chiih-è, nawaithek chung de liijiing rek ne rai bo.” ");
INSERT INTO bgg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chiihphado è Isu ne ji pha ithua thoh srane Judea pha du-ua hà wuii dun, chiih-è, Jordan pha gashad hiìa ne wuiidun. Thiichiih shii de bran ibrogthek khrab ne wuii thog din ruii, jishii ai è nathek shii idang yao pha duiine yua din phi. ");
INSERT INTO bgg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Thiichiih shii giak Pharisithek ne ai moe shii wuii thog srane, aishii chai pha bidiang ne sai, “Gathek shii yao riig bo, gethek Iphey shii ne, gey è awai yiy shii nyache mua phrone um bey?” ");
INSERT INTO bgg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Isu è ithek shii de miyao jia sai din srane chang, “Moses è nathek shii nyie Iphey phi marui phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ithek è aishii chang, “Moses è ne hì è zen marui phro, gey è yiy shii che yang pha now arone, che pha jigigam zey srane yiy shii thoh ge bo.” ");
INSERT INTO bgg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Isu è ithek shii yao, “Moses è hì pha Iphey ne nathek chiang zey ro, nyieliieshii, ithek shii yua pha ne bajo diig ro. ");
INSERT INTO bgg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jishii jigigam shii zey pha duiine, soh rab pha inai shii Hamangkhung-aphuii è bufuii chiih-è bimi rab ne ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Jiphachiang è bufuii ne awai amuii nane aphuii shii thoh marui ne yiy rog dog ne rai dun phro, ");
INSERT INTO bgg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","chiih-è, isa ne siu jia re dun phro.’ Ji-è, isa ne bran nyi asi pha, jia re dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ji-è, branthek ne Hamangkhung-aphuii è miak phi pha ji ne yo arek mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ithek è awaithek hò iliing hà dun thog din mage shii, samoythek è Isu shii ji pha miyao sai din. ");
INSERT INTO bgg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ai è ithek shii yao, “Gey è yiy shii thoh srane gai shii yi din arone, din pha yiy ji chiang è layog re dun phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ji duiine, yiy de gey shii thoh srane gai shii gey dun arone, ai ne din pha gey chiang è layog re dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Branthek è aniphiing shii wad khoh ne khirzey phi yi pha Isu moe hà noh thog ruii phro, jishii, samoy è branthek shii giung. ");
INSERT INTO bgg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Isu è ji rek pha doh mage ne, lijieg srane awai samoythek shii yao, aniphiing shii gu moe hà wuii yi bo, ithek shii agak rabo, nyieliieshii, Hamangkhung-aphuii ro Sajathua ne ithek duiine pho thek ro ro. ");
INSERT INTO bgg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gu è nathek shii izai yao phro, “Hanyie è aniphiing duiine Hamangkhung-aphuii Sajathua achoi sapho shii ne khuchung de ji pha ithua adun mua phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chiihphado shii ai è aniphiing shii awai wad è giak srane zab shii wad chaing ne khirzey phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Isu yi awai mirek ji duiine jao ramuii shii, bran jia è ran srane ai ibi shii lagiung niing ne chiih-è aishii sai, “Wie Masdo, gu ne idang pha chai mua pha nyie rek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Isu è aishii sai, “Na ne nyie rek ne gu shii wie rone ho phlei?” Hanyie de wie oi ro, wie ne Hamangkhung-aphuii bie ro. ");
INSERT INTO bgg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na ne muyungthek ne thieg: bran shii ne sgoh arek rabo, chiih-è, siulao arek rabo chiih-è, mugo agow rabo; chiih-è, gai bran chiang shii biidiie akhlam rabo; chiih-è gai ro mana shii biidiie khlam ne ayie rabo Chiih-è aphuii nane amuii shii ilab rek bo. ");
INSERT INTO bgg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bran ji è yao, “Masdo” “Hì pha muyungthek ne gu ne filiao ba è nuii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isu è aishii miang riig srane aishii miie ne yao, “Din ne mana jia chiid dang pha um ba ro. Dun srane na shii nyie um pha ji liu srane bang yi dushothek shii phi muii bo, chiih-è nane hamang-khung hà bukho re ruii phro; chiihphado è na gu rog shii lua gieng bo.” ");
INSERT INTO bgg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jipha bran è ji yoi mage shii, ai mizia ne miung srane, chiih-è ai ne duhug è rey dun, nyieliieshii ai ne bajo bukho ro. ");
INSERT INTO bgg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Isu è awai samoythek shii shan srane riig ne chiih-è ithek shii yao, “Bukho branthek ne Hamangkhung-aphuii ro Sajathua shii khud phane bajo diig ro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jipha miyaogamthek re-è samoythek ne wiengphleg dun, jishii, Isu è nyayao lumao dun ro, gu aniphiing wo, Hamangkhung-aphuii Sajathua shii khud phane bajo diig ro! ");
INSERT INTO bgg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bukhothek ne Hamangkhung-aphuii pha Sajathua re pha ji shii ne yuaphiang sthuh simen cho è khud pha ji wie ba ro. ");
INSERT INTO bgg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hì è ne samoythek ne zab bajo wieng ne awaithek chung sai rai, “Chiihphado hanyie shii ragia re phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isu è ithek shii miang riig srane chang, “Hì ne branthek è are mua phro, jishii, Hamangkhung-aphuii è ne re muii ruii phro. Hamangkhung-aphuii è ne zab nya re muii ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chiihphado Phithar è yao mage, “Riig mage bo! Gathek ne zab thoh muii srane narog shii lua giang.” ");
INSERT INTO bgg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Um,” Isu è ithek shii yao, “Gu è nathek shii yao, hanyie magunde mua chiang è hò dinne khuiino dinne bumuii dinne aphuii ne amuii dinne ani dinne raig thoh arone, ");
INSERT INTO bgg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ai ne hì pha ishak shii de bajo mua ruii phro. Aishii ne hòthek, khuiino thek, bumuiithek, amuiithek anithek chiih-è raigthek ne wieng chiieng mua din ruii phro, chiih-è diigchiao de mua ruii phro; chiih-è din pha damzi thog shii ai ne idang pha chai mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jishii thuh ne hanyie giu ithua shii um pho ne luii ithua hà re ruii phro, chiih-è thuh bajo hanyie yi luii ithua hà um pho ne giu ithua hà re ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Isu chiih-è ai samoythek è Jerusalem hà wuii pha lumuii è lua ramuii shii. Isu ne ithek è ibi lua ramuii shii, samoythek ne samdiig dun ro; chiih-è, branthek hanyie è ai idoh luagiengpho thek ne zab rum dun phro. Din ne de Isu ne samoy snanyi shii yoh ithua hà noh srane aishii nyie re ruii pha jithek yao phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ai è ithek shii yao, “Yoi bo, gethek ne Jerusalem hà wuiiramuii ro, thiisa hà Bran Dufuii shii ne zum srane Phabi wegthek shii chiih-è Iphey yua pha masdothek shii phi muii phro. Ithek è aishii iy yi pha the srane migi arek pho shii phi ruii phro, ");
INSERT INTO bgg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ithek è aishii makhakriing ne chan cho ne, chia ne, chiih-è ua muii phro; jishii ai ne inai da-uom shii ne chai hà hòi din ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chiihphado è Zebedi pha dufuii, Jems chiih-è Jon è Isu moe shii wuii srane yao, “Masdo, nyie magunde gasa shii rek phi bo è now ro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Isu è isa shii sai, “jine nyie lei?” ");
INSERT INTO bgg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ai è chang, “Na è nawai bran shii khoh mage shii, gasa shii de narog dug yi bo è now ro, jia shii na phazoi hà, jia shii na phawig hà dug yi bo.” ");
INSERT INTO bgg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Isu è isa shii yao, “Nasa nyie lia pha ji ne nasa ne athieg mua ro. Nasa de gu è niing pha gog riie ji nyaniing mua ne bey? Chiih-è gu miyi pha khowo riie duiine nasa de khowo riie nyayie mua ne bey?” ");
INSERT INTO bgg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ai è chang, “Gasa de nyayie mau.” Isu è isa shii yao, izai nasa de gu è niing pha gog riie de nyaniing mua phro, chiih-è gu miyi pha khowo riie de nyawo mua phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jishii, nasa shii gu phawig chiih-è phazoi hà dug yi pha rangsua ne gu shii oi ro. Hì pha ithua ne Hamangkhung-aphuii è hanyie shii rab ne ruii phi pha ji shii phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gai samoythek sua è ji yoi mage shii, ithek ne Jems chiih-è Jon shii lijieg dun. ");
INSERT INTO bgg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chiih-è Isu ithek zab shii ò ho srane yao, “Nathek ne ji pha bran shii thieg, hanyie shii ithek shii blu rek pha migi-arekpho ro bohkhohthek phi muii phro, chiih-è dumuiithek shii ne zab riichai um ro. ");
INSERT INTO bgg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Hì è rek pha ji ne ithek duchoi shii arek rabo. Nathek è hanyie magunde boh rek yang pha now arone, ai ne gai ro khiao rek bi bo; ");
INSERT INTO bgg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","chiih-è nathek è hanyie magunde ibi re yang pha now arone, ai ne zab pha khiao rek bi phi bo. ");
INSERT INTO bgg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bran Dufuii rang de blia rek yi pha awuii ro; ai ne ithek shii nong phi pha wuii phro, ai ne awai chai phi srane bran bajo shii thoh phi pha wuii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ithek ne Jerikho hà wuii thog ne Isu è samoythek nane bran ibrog rog shii jipha ithua è fuang thoh ne wuiiramuii shii, Thimaeyus pha dufuii Barthimaeus miegthi pha nane chayem jia lumuii shii dug ne rai iang doh ro. ");
INSERT INTO bgg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jipha bran è jine Isu Nazareth rone yoi mage shii, Isu shii ziak ne ho, “Isu, Dawid Saja pha Dufuii wo! Gu shii de bushun now phi bo!” ");
INSERT INTO bgg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Branthek è aishii aro rabo ne bajo giung. Jishii, ai ne din è de gang ziak ne ho mage, “Dawid pha Dufuii wo! Gu shii bushun noh bo!” ");
INSERT INTO bgg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Isu è khan srane yao, “Aishii ho mage bo.” Ji-è, ithek è miegthi pha bran jishii ho ne yao, “Sang srane jai ne wuii mage bo, Isu è na shii ho muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ji è yao mage ne ai ne awai yung de fen marui srane ran ne Isu moe hà wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isu è aishii sai, “Gune na shii nyie rek phi bo è yang lei?” miegthi pha ji è yao. “Masdo, gu ne dinne mieg doh mua yi pha yang ro.” ");
INSERT INTO bgg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Isu è aishii yao, “Dun mage bo, nawai migi ji è nawai shii gang rek jong phi ro.” Ji è yao mage shii ai ne mieg doh dun ro. Ji-è, chiihphado ai de Isu rog shii lumuii hà luagieng. ");
INSERT INTO bgg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Isu chiih-è ai samoythek ne Jerusalem hà wuiiramuii shii, Bethphach chiih-è Bethany beng pha thawun ne ithek è nui bie ro, ithek ne Sumaro um pha phiing hà wuii srane Isu è samoy nyi shii yung ne ibi thoh ge, ");
INSERT INTO bgg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Isu è isa shii yung ne ibi thoh ge, “Thrang ibi pha thiig hà wuii srane ji pha thiig hà nasa ne khuchung de bran è a-in dang ba pha bambao jia doh ruii phro. Ji shii sey srane ichiih shii now ruii bo. ");
INSERT INTO bgg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ji è rek shii branthek è sai ruii arone, ithek shii yao mage bo, hìne Masdo è chiid muii ro, hìne jog idoh thoh din ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Isu è ji yao ched ne ji pha samoy nyi ne wuii dun. Thiisa hà wuii thog mage shii Isu è nyie ro è yao pha duiine bambaoduii jia ne hò habin shii phang srane ruii iang pha doh. Samoy nyi è ji pha bambaoduii shii sey ramuii shii ");
INSERT INTO bgg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","thiichiih riu pha branthek è isa shii giung, nasa ne hì pha bambao phang ne ruii pha ji nyie rek pha sey ramuii lei? ");
INSERT INTO bgg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ai è ithek shii Isu è khi-èrek ne yua pha ji yao ne chang. Ji nuii ne ji pha branthek è isa shii ji pha bambao now ne dun ge. ");
INSERT INTO bgg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Samoy nyi è ji pha bambao shii ne Isu moe shii noh ne dun thog ruii. Thiichiih noh thog shii ithek è yung thek yie ne bambao lakhung shii go phi shii Isu ne ji pha lakhung hà in dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Branthek è awaithek yung thek hun srane Isu wuii pha lumuii shii wio phi, chiih-è, bran giakthek è de iphang che srane Isu wuii pha lumuii shii wiao phi. ");
INSERT INTO bgg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ibi idoh luagieng pha branthek è ziak ne yao, “Hamangkhung-aphuii! Na ne bajo wie ro, hanyie Hamangkhung-aphuii pha ibeng è wuii pha bran jishii ne khirzey phi ara. ");
INSERT INTO bgg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hamangkhung-aphuii è Aphuii saja Dawid aphuii pha Sajathua pha ji shii ne khirzey phi phro, Hamangkhung-aphuii na ne bajo wie ro!” ");
INSERT INTO bgg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Isu Jerusalem hà wuii thog ne Hamangkhung-aphuii ro Misiahò hà wuii srane zab shan ne riig marui ne Isu chiih-è ai samoythek ne habjuang re dun pha ji è Bethany beng pha ji shii wuii dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jipha thimiang shii, Isu nane ai samoythek ne Bethany è wuiiramuii shii Isu ne bajo chi-iy-iy dun. ");
INSERT INTO bgg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ithek ne ìujia ruang ba shii Isu è irab bajo um pha Iphem hingmuii jia doh mage, ji-è, Isu ne ji pha Iphem hingmuii shii iwoi sow pha wuii dun. Ji-è rek magunde, ji pha Iphem ne iwoi awoi ro, nyieliieshii, ji pha hingmuii ne iwoi woi pha ishak are ba ro. ");
INSERT INTO bgg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ji-è, Isu ne ji pha Iphem hingmuii shii thamiie, “Sudoh è thiwing ne na iwoi ne hanyie è de achie mua phro!” Ji è yao phane samoythek de yoi. ");
INSERT INTO bgg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Isu nane ai samoythek ne Jerusalem hà wuii thog mage shii, Isu ne Hamangkhung-aphuii ro Misiahò hà wuii srane chongjai rek pha branthek shii giung ne gieng muii srane bang zia rai pha thiibliiethek shii de phun ne fen ne chiih-è branthek hanyie è pharo ruii ne chong rek pha muro thek shii srobro rek ne fen maphi. ");
INSERT INTO bgg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Chiihphado shii, Isu è branthek shii Hamangkhung-aphuii Misiahò shii chongjai rek pha manathek shii hanyie shii de ayie yi ro. ");
INSERT INTO bgg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chiih-è, branthek shii yao: “Hamangkhung-aphuii ro jigigam ne hì è zey ne um ro, gu Misiahò ne zab pha branthek è sia pha hò ro, jishii, ithek è ji pha Hamangkhung-aphuii ro Misiahò ne mugo pho si pha hò rab ne ruii mua ro.” ");
INSERT INTO bgg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Boh phabithek chiih-è Iphey yua pha masdothek è ji pha miyao yoi mage ne, ithek ne Isu shii ua pha noh, chiihphado è aishii ua pha lumuii sow ne rai. Phabi nane Iphey yua pha masdothek ne Isu shii rum, nyieliieshii bajo branthek ne ai muyua jishii bajo sangdun ro. ");
INSERT INTO bgg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ji è re ched ne habjuang re sha mage ne Isu chiih-è ai samoythek ne ji pha rajan thoh srane dun din phro. ");
INSERT INTO bgg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Din pha thimiang riang, Isu nane ai samoythek ne ji pha lumuii è lua din mage shii, ji pha iphem hingmuii ne iriing è yi dang ne zab goh ne um iang pha doh phro. ");
INSERT INTO bgg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Diyu nyie re pha ji Phithar ne nowluii srane Isu shii yao, “Masdo, riig mage bo, hì pha iphem hingmuii ne na è thamiie marui pha ji è iy dun ro.” ");
INSERT INTO bgg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Isu è ithek shii yao, Hamangkhung-aphuii shii migi rek mage bo. ");
INSERT INTO bgg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gu nathek shii izai yao dang phro, hanyie è lubu è migi now srane hì pha phiing shii hùg srane khamuii hà fen bo ne yao na de, jine re dun phro. Jishii, ithek è nyie yao pha ji shii migi now chid phro, chiihphado, re ruii phro, chiih-è ji re pha rek phi phro. ");
INSERT INTO bgg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jiphachiang è gu nathek shii izai yao dang phro, “khuchung magunde, nathek migi è Hamangkhung-aphuii shii sia srane nyie lia magunde, nathek jine mua jong rone migi rek bo, chiihphado, nathek è nyie lia pha ji ne phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Nathek jai srane Hamangkhung-aphuii shii sia pha saro arone, misia sia pha ishak shii nathek shii hanyie magunde gidieg rek ne de aishii khung phi bi bo, chiihphado nathek ro asi pha blia rek pha ji de Hamangkhung-aphuii è khung phi phro. ");
INSERT INTO bgg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Isu chiih-è ai samoythek dinne Jerusalem shii wuii thog shii, Isu ne Hamangkhung-aphuii ro Misiahò hà wuii ne lua ramuii shii Phabi dukhothek chiih-è Iphey yua pha masdothek chiih-è wegthek è Isu moe shii wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chiih-è, aishii sai, “Hì pha blia rek mua pha riichai ne na shii hanyie miphi lei chiih-è hanyie miyao ne rek yi lei?” ");
INSERT INTO bgg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Isu è ithek shii chang ne yao, “Gu de nathek shii musai jia sai phro, gu musai ji nathek de chang mua arone gu de nathek shii hì pha riichai ne hanyie miphi pha ji yao phro.” ");
INSERT INTO bgg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gu shii de yao mage bo, “Jon è branthek shii khowo phi pha riichai hanyie miphi lei? Jine Hamangkhung-aphuii miphi bey? Asi pha jine bran phi bey?” ");
INSERT INTO bgg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ji sai mage ne ji pha branthek ne awaithek chung khnaing rai srane Isu musai ji chang pha nung rai dun. Ithek ne awaithek chung yao rai, khi-èrek ne chang sha rai phlei? Gethek è hì ne Hamangkhung-aphuii miphi rone chang arone, ai ne gethek shii yao din ruii phro, ji-arone nathek ne Jon shii nyie rek ne izai anow ga? ");
INSERT INTO bgg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Chiih-è, hì ne bran miphi rone yao arone, branthek è gethek shii gui noh phro. Ji-è ithek ne rum ne ayao mua pha re dun, nyieliieshii branthek ne Jon ne chaig rone thieg jong dun. ");
INSERT INTO bgg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ji-è, ji pha branthek ne Isu shii athieg rone chang thog ruii. Ji-è Isu de ithek shii yao, “Chiihphado gu de nathek shii hì pha riichai è gu shii blia rek pha hanyie miphi ji gu de ayao phro.” ");
INSERT INTO bgg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Isu è ithek shii najang shan ne yao: Luangjia shii bran jia è angur raig hai, chiih-è raig shii shan ne muthua thua srane, angur shii chab ne chui ne ikho rey pha nyahiung chog, chiih-è riigpho shii rai yi pha haliig giu jia rab phro. Chiihphado è angur raig cheipho shii phi srane hò thoh marui ne lua dun. ");
INSERT INTO bgg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Angur khrab pha ishak thog mage shii, cheipho è awai mathang yamiing yi pha ai è awai khiao shii thoh ge phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Raig cheipho è khiao ji shii zum srane zuang mage, chiih-è nyie de aphi pha idoh thoh din ge. ");
INSERT INTO bgg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chiihphado shii muspho è khiao gai shii thoh ge; raig cheipho è aishii de khrug lakhung shii zuang srane biwo rek ne thoh ge. ");
INSERT INTO bgg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jipha muspho è dinne gai khiao thoh ge, chiih-è aishii de ua muii phro; chiih-è ithek gai shii duiine bajo awie pha rek phro, chiih-è giak shii zuang ne giak shii ne ua muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Idoh noi shii jia led dang bie ne thoh ge pha ji ne awai è miie pha awairo dufuii ro, ai è awai dufuii shii cheipho hà thoh ge, ai è yao, gune luthong phro ithek ne gu dufuii shii ne ilab phi phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Jishii cheipho è awaithek chung yao rai, hì ne muspho ro dufuii ro. Thawuii ne ua rai haro, chiih-è ai ro nuruii thek ne gethek ro rey phro! ");
INSERT INTO bgg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ji-è, ithek ne dufuii shii zum srane ua ne chiih-è cheipho è ai siu shii angur raig è fuang fen muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Isu è sai, “Chiihphado shii, muspho è cheipho shii nyie rek phlei?” Ai ne wuii ne ua srane raig gai cheipho shii phi muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nathek de hì pha jigigam atham bey? Rungpho è lubao awie rone snai muii pha ji shii ne zab è de mugak re dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jine Ithong mirek ro, jine bajo wie pha mieg shii ro. ");
INSERT INTO bgg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jewish dumuiithek ne Isu shii zum pha bidiang phro, nyieliieshii ithek ne thieg ai miyao najang shan ne ithek gidieg shii yao phrone thieg, jishii ithek ne ibrogthek rum, jiè ithek aishii thoh marui ne rek dun. ");
INSERT INTO bgg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pharisithek chiih-è Herod pha branthek yi Isu hà thoh ge srane musai rog shii chua phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ithek aishii wuii srane sai, “Masdo, gathek ne thieg nane izai yao phro, nane branthek è nyie now na de sam-adiig pha yao phro, branthek ro ilab shii de nyie ilab aphi pha rek ro. Jishii branthek shii Hamangkhung-aphuii muyang pha chiang shii nane izai yao phro, Gathek shii yua riig bo Romanthek saja dumuii shii mijin phi pha ji ne gethek Iphey shii buii bey? Gathek ne ithek shii nyaphi ne ba asi aphi chiid haba?” ");
INSERT INTO bgg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jishii Isu è ithek ro khua ji è riig srane chang, “Nathek nyie rek ne gu shii chua pha bidiang phlei? Bang shikhi jia yi mage bo, chiih-è gu riig-riig haro.” ");
INSERT INTO bgg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ithek è aishii jia yi ne phi, chiih-è ai è sai, “Hanyie mizia chiih-è hanyie ibeng lei.” Ithek è chang, “Hì ne Roman thek saja dumuii ro ro.” ");
INSERT INTO bgg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Isu è ithek shii yao, “Chiihphado, hì ne wie ro, nyie yi saja dumuii è re pha ji ne saja dumuii shii phi muii bo, chiih-è nyie yi Hamangkhung-aphuii è re pha ji ne Hamangkhung-aphuii shii phi muii bo.” Chiih-è ithek ne Isu shii wiengphleg dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chiihphado shii Sadusithek hanyie è iy pha ji è ahòi phrone yao phothek ne Isu moe shii wuii srane yao, ");
INSERT INTO bgg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Masdo, Moses è hì pha Iphey ne gathek shii zey phi phro: Bran jia è yiy yi ne, ani agiak pha iy dun, ai ikhuii è ji pha misiung shii yiy ne ani giak arone, ji pha ani ne iy dun pha ro nyare yi bo. ");
INSERT INTO bgg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Luangjia shii khuiino miley um; zab è khoh ji è yiy yi srane ani agiak pha iy dun. ");
INSERT INTO bgg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chiihphado shii din pha ikhuii ji è de ji pha hò-amuii shii yiy, chiih-è ai de ani agiak pha iy dun. Uomchiieng pha khuii shii de ithek shii nyie re pha ji duiine re phro, ");
INSERT INTO bgg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","chiih-è chiihphado shii gai thek, zab khuiino miley è ji pha hò-amuii shii yiy srane ani agiak pha iy dun. Zab pha idoh shii ji pha hò-amuii de iy dun. ");
INSERT INTO bgg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chiihphado shii, iy pho yi zab hòi pha Inai sieng mage shii, ithek miley è yiy pha hò-amuii ji ne, hanyie ro yiy re phlei? ");
INSERT INTO bgg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isu è ithek shii chang, “Nathek ne asi pha branthek ara! Nyieliieshii nathek ne hì pha Hamangkhung-aphuii ro jigigam chiih-è ai riichai shii athieg mua phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iy pho thek hòi din mage shii, ithek ne, hamangkhliie duiine re ne hamangkhung hà ne yiy ayiy phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iy pho ne hòi ruii phro, ithek ne jabiing hòi pha Moses ro Jigigam ji shii atham bey? Thiichiih shii zey phro Hamangkhung-aphuii è Moses shii yao, ‘Gune Abraham ro Hamangkhung-aphuii ro, Isakh ro Hamangkhung-aphuii ro, chiih-è Jakhob ro Hamangkhung-aphuii ro’ Ai è ji yao shii ne bajo idam ibi hà ithek ne iy jong ro. ");
INSERT INTO bgg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hamangkhung-aphuii ne branthek ro Hamangkhung-aphuii ro, jiè hanyie iy dun magunde thuh de isieng ba ro, jishii iy pho ro asi ro. Nathek ne zab adunmey pha now ro!” ");
INSERT INTO bgg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Thiichiih shii um pha Iphey yua pha masdo jia è ithek mulo ramuii pha yoi. Ai è Isu yi Sadusithek shii ne wie è chang pha doh, jiè ai ne Isu shii musai sai: “Nyie muyung ne zab è de mugak ba lei?” ");
INSERT INTO bgg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isu è aishii chang, “Zab è mugak muyung ne hì ro, ‘Israel pho! yoi mage bo, gethek ro Ithong Hamangkhung-aphuii ne jia bie ro. ");
INSERT INTO bgg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nawai Hamangkhung-aphuii shii nawai lubu è, nawaithek ragung è, nawaithek khani è, nawaithek chua rog shii è miie mage bo.’ ");
INSERT INTO bgg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chiih-è nyichiieng pha mugak muyung ne hì ro: ‘Nawaithek ro hadung-haluii pho shii de nawaithek chung miie rai pha duiine miie bo.’ Thiichiih è ne nyi ji è boh gai mugak muyung oi sha ro.” ");
INSERT INTO bgg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iphey yua pha masdo ji è Isu shii yao, masdo! “Wie ro, hì ne izai chak ro, na è yao pha ji ne, Ithong ne Hamangkhung-aphuii bie ro, chiih-è, gai Hamangkhung-aphuii ne oi ro, jishii ai jia bie ro” ");
INSERT INTO bgg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chiih-è branthek ne Hamangkhung-aphuii shii awaithek lubu è awaithek khani è awaithek chua è miie chiid phro, chiih-è awaithek shii miie pha duiine hadung-haluii pho shii de miie chiid phro. Hì pha muyung nyi nuii ne rek pha ne miiram ua ne Hamangkhung-aphuii shii khlem ne zid phi pha ji è de bajo boh muyung ba ro. ");
INSERT INTO bgg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isu è nuii shii ji pha bran miyao ne wie ro, “Na ne Hamangkhung-aphuii ro Sajathua è muna ruang asi sha phro.” Ji è yao ched mage ne zab ne rum ne Isu shii musai asai mua. ");
INSERT INTO bgg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isu ne Hamangkhung-aphuii ro Misiahò shii miyao yua ne rai srane branthek shii musai jia sai ruii, nyie khi-èrek ne Iphey yua pha masdothek ne Masi ne Dawid Saja pha riing rone yao mua phlei? ");
INSERT INTO bgg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawid shii Hamangkhung-aphuii ro Ragung è yao yi phro: Ithong è gu Ithong shii yao; Gu è na shuangthek shii gu lai luii aruii sapho ne Na ne guro phazoi pha riichai ithua shii dug bo. ");
INSERT INTO bgg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawid awai de aishii ne Ithong rone ho, jiè nyie khi-èrek ne Masi ne Dawid ro riing re mage phlei? Bran ibrogthek ne Isu miyao ji sang ne nuiiramuii ro. ");
INSERT INTO bgg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Isu è ithek shii yua, ai è yao, “Iphey yua pha masdothek è ragia rek ne rai bo, ithek ne yung phiang rog shii lua ne branthek shii riig yi pha bajarai ithua hà ilab phi yi pha rek phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Misiahò hà wuii ne de ithek ne mugak biang shii ong ne chiih-è michie-chie pha ithua shii biang wie shii ong ne dug phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ithek ne misiung thek phua yi srane chiih-è ithek hò de rio maphi, chiih-è ithek ne branthek wie rone riig yi pha misia de phiang sia phro. Ithek zab shii ne bajo awie pha re ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Isu yi Hamangkhung-aphuii ro Misiahò pha mizid gam moe shii dug ne rai ramuii shii, ai è bukho branthek ne bajo bang zid pha doh ruii; ");
INSERT INTO bgg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","chiihphado shii dusho misiungmuii jia wuii ne bang ìujia chab phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ji è doh mage ne Isu è awai samoythek shii awai moe shii ho srane yao, “Gune nathek shii izai yao dang phro, hì pha dusho misiung ne mizid pha gam ne bran shii gai re-è ne zab è de bajo muna zid phro. ");
INSERT INTO bgg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gai thek ne awaithek shii nyie um pha ji è ìujia yi srane zid bie phro, jishii ai ne dusho magunde awaishii nyie um thith pha ji yi srane zab zid muii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Isu ne Hamangkhung-aphuii ro Misiahò ji thoh srane dun ramuii shii, ai samoy jia è aishii yao, “Masdo, hì pha lubao chiih-è hòthek ne bajo khie doh muii ro.” ");
INSERT INTO bgg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isu è aishii chang ne yao, “Nathek ne hì pha boh lubao hò ne riig iang bo! Doh jia shii ne hì pha hòthek pha lubaothek ne jia de khim ne arai mua pha zab chuak dun phro.” ");
INSERT INTO bgg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Isu ne ji pha Hamangkhung-aphuii ro Misiahò pha khlei pha sumaro phiing shii dug ne rai shii, Phithar, Jems, Jon chiih-è Andrew ne aishii ug ne wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ithek è aishii yao, “Gathek shii yao phi bo, ji pha inai ne khuchung thog ruii phlei? Chiih-è, ji pha inai thog sha ruii rone thieg yi pha gathek è nyie doh shii ji pha inai ne re phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isu è ithek shii yao, nathek ne nowbthan ne rai iang bo, chiih-è branthek è ithek shii akhin-aring yi rabo. ");
INSERT INTO bgg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bajo branthek è ithek shii yao ruii phro, gune ji pha Masi ro! Bran bajo thek ne gu beng è yi ne khinrin ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Chiih-è, nathek ne mak thek inui thog pha yoi mage shii, chiih-è mak ruang hà thog pha mua yoi mage shii, nathek ne aram chid rabo. Jithek ne izai re ruii phro, jishii, jine jong pha ishak thog sha rone asi ro. ");
INSERT INTO bgg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Du-ùa chung de gui rai ruii phro; zab ithua thek chung de gui ruii phro, thiichiih shii zab hà sajid sham ne, chiih-è zab pha chieniing pha thek oi pha diig re ruii phro. Jithek ne hò-amuii thek è ani giak pha ibi shii riie pha duiine diig ruii ro. ");
INSERT INTO bgg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nathek ne nawaithek shii nowbthan srane bujuii ne rai iang bo. Nathek shii de zum ne limiang hò hà noh srane Jewthek misiahòthek shii zuang ruii phro; nyieliieshii gu shii nuii pha chiang è nathek shii ne dumuiithek chiih-è saja thek moe shii noh ne ithek ro migi chiang ji yao yi phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ai ne zab pha ibi shii guro miyao wie hìne zab branthek shii chiih-è zab pha du-ùathek shii yao ched bi phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Khuchung magunde, nathek shii zum srane limiang moe shii noh dun shii, nathek ne khi-èrek ne yao sha phlei! Inow ne arum chid rabo; nyieliieshii, ji pha idoh shii ne nathek shii yao mua pha lumuii phi ruii phro; nathek è nyie yao pha miyaogam ne ithek miyao pha asi phro, ji ne Hamangkhung-aphuii Ragung è yao gieng phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Khuiino chung magunde, zum srane ua yi pha phi muii phro, aphuii è ani shii de ji è rek ruii phro, aniphiingthek de awaithek pha aphuii amuii shii ji è rek ne ua muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Zab branthek ithek shii gu chiang è snai ne chiih-è ariig yang pha rek ruii phro, nyieliieshii ithek è gu shii migi rek phro. Jishii, hanyie è awai migi shii zab pha inai thog dang pha rek pho ne ragia re ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nathek ne doh ruii phro, akhie dang pha ibuii jia yi khi hà ai arai pha ji shii riu ruii phro.” Thampho ne hì thieg bo: Hì pha miyao ne nyie yao pha ji ne thieg pha bidiang bo. Chiihphado shii hanyie ne Judea pha ithua hà um lei ne ithek ne phiingthek hà ran dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bran hanyie yi awai hòzak hà um pho ne buzam awai hò iliing hà dun ne mana yi pha ishak amua rabo. ");
INSERT INTO bgg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bran hanyie ne raig hà um pho ne awaithek yung yi pha idoh hò hà adun rabo. ");
INSERT INTO bgg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hò-amuii hanyie ani wiig ne chiih-è ani ìu um pho ne ji pha inai shii ne bajo diig phro! ");
INSERT INTO bgg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jipha ishak ne hakhanshak shii are yi pha Hamangkhung-aphuii shii sia bo! ");
INSERT INTO bgg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Hì thek pha diig inai ne, Hamangkhung-aphuii è igobi sohjambling rab dang pha ishak è yi ne thuh thog pha hanyie è athieg ba pha awie dang pha diig ji thog ruii phro. Ji re pha idoh shii ji duiine mia pha diig ne dinne are phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jishii Hamangkhung-aphuii è diig pha inai shii ne la-ìu-ìu rek phi phro; ai è ji arek arone, hanyie de asieng mua phro. Jimagunde awai è gua pha branthek chiang shii inai la-ìu-ìu rek phi phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chiihphado è, hanyie magunde nathek shii yao, riig bo, ichiih shii ne Masi um ro! Din ne, riig bo, the jine Masi rone yao na de! Jishii aishii migi arek rabo. ");
INSERT INTO bgg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Biidiie pha Masi chiih-è biidiie pha chaigthek ne khia ruii phro. Ithek ne are mua pha bliathek rek ne chiih-è buangthek ji rek ne, chiih-è rek mua arone, Hamangkhung-aphuii è gua pha branthek shii khinrin pha nyiu phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gu miyao pha miyao chiang hì ne nawaithek shii ragia rek ne chiih-è saro bo. ");
INSERT INTO bgg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Diig pha ishak inai pha idoh ne inai ne igiia re dun phro, chiih-è habie de achuang pha re dun phro, ");
INSERT INTO bgg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dadiangthek de hamangkhung è thazam chiih ruii phro, chiih-è hamangkhung pha riichaithek de sham ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chiihphado Bran Dufuii khia ne, biisiie nane boh blu rog shii sakhamiing shii wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ai è hamangkhliiethek shii soh pha iring wi shii thog pha thoh srane sohnyiak iring jia pha iring è jia pha iring thog pha ithek shii Hamangkhung-aphuii mugua pha bran shii khrab yi phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Jipha Iphem hingmuii è nathek shii ìd yi phro. Ji pha iphem hingmuii ro idiphak ire re ne chiih-è jum re mage shii irab jao ne nyu ruii phro. Nathek ne thieg phro halua idam ne inui re sharuii rone. ");
INSERT INTO bgg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ji duiine, nathek è ji re pha doh mage shii, nathek ne thieg, jao pha ishak inui sha ro. ");
INSERT INTO bgg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Now bo, hìthek re mage shii ichiih um pha ithek giak bran ne isieng ba phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hamangkhung chiih-è sohnyiak ne san dun phro, jishii gu miyaogamthek ne khuchung de asan phro.” ");
INSERT INTO bgg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Jishii hì pha inai chiih-è ishak thog pha ji ne hanyie de athieg mua phro Hamangkhliiethek de chiih-è Dufuii de athieg mua phro; ji pha inai thog ruii pha ne Hamangkhung-aphuii awai è thieg bie ro. ");
INSERT INTO bgg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wie riig srane nowbthan ne rai iang bo, chiih-è ji pha inai thog ruii phane nathek athieg phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jipha inai ne ji duiine phro, Bran jia hanyie è awai khiaothek shii dumuii phi srane chiih-è zab pha khiao shii nyie rek chid pha ji yao ne chiih-è hò khan pha bran shii hò wie riig bo è yao ne awai hò thoh marui ne wuiidun. ");
INSERT INTO bgg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chiihphado è, nowbthan bo, nyieliieshii hò pha muspho ne khuchung thog ruii pha ji ne nathek ne athieg phro yangne ne ai ne habjuang shii dun ruii pha de um phro, yangne ai ne habiu duchoi shii de dun ruii pha de um phro, dinne, yangne ai ne hasiang asiang ba ibi shii thog ruii pha de um phro, yangne ai ne hasieng sieng pha idoh shii thog ruii pha de um phro. ");
INSERT INTO bgg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ai ne hamblo shii dun thog mage shii nathek ne amen iang rabo. ");
INSERT INTO bgg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chiihphado, gu nathek shii nyie yao pha ji ne, gu zab shii yao ne: nowbthan ne rai iang bo ne yao phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hì ne buii Hiìadun Sai pha chiih-è Phiia ajiie pha Iweb chie muii pha danyi ibi shii ro. Boh phabithek chiih-è Iphey yua pha masdothek è ug ne Isu shii zum pha rek phro, chiih-è ua pha rek phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ithek è yao rai, “Gethek ne sai pha inai shii arek haro dinne ji è rek mage shii branthek è gethek shii gui noh mage phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jipha ishak Isu ne Bethany pha ithua hà Simon ro hò shii ro, chiih-è ji pha bran ne bajo awie pha hìa è rei phro. Isu chie ramuii shii, hò-amuii jia ne igang iwoi è rab pha bajo rem noh pha thiiliie sasia chiih-è bajo igong um pha yi ne wuii thog ruii phro. Jipha hò-amuii è sasia ji chui srane bajo rem noh pha thiiliie ne Isu khrug shii shun phi. ");
INSERT INTO bgg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Giak branthek è aishii riig ne bajo lijieg ne awaithek chung yao rai, “Nyie rek ne nyama igong um pha chiih-è bajo rem noh pha thiiliie ne aishii shun ne mua muii phlei? ");
INSERT INTO bgg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jipha bajo rem noh pha thiiliie ne hò-amuii è liu arone idam jia pha riinang mua ne ji pha bang ne dushothek shii phi liak pha ji wie phro!” Chiih-è ithek è hò-amuii ji shii awie dang pha giung phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jishii Isu è yao, aishii ji thoh muii bo, nyie rek ne nathek ne aishii afak-afi rek phlei? Ai ne gu shii bajo wie chiih-è khie blia rekramuii ro. ");
INSERT INTO bgg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dusho bran ne nathek rog shii idang um ruii phro, nathek ne ithek shii khuchung magunde yang shii nya nong phi bo. Jishii gune idang nathek rog shii oi phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ai è nyie rek mua pha ji rek phi phro; ai è gu siu bajo rem noh pha thiiliie shun phi ne ibi shii gu wieng pha ishak khriig rek phi. ");
INSERT INTO bgg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Thuh, gune nathek shii izai yao dang phro: Zab pha sohjambling shii guro Mua Wie ji yua mage shii, ai è nyie rek phi pha ji ne, aishii nowkhlei yi pha yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chiihphado, samoy snanyi è jia Judas Iskharioth yi boh phabithek shii wuii ne Isu shii khi-èrek ne zum pha ji ithek shii nung gieng. ");
INSERT INTO bgg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ai miyao ji nuii ne phabithek ne nyu dun, chiih-è aishii bang phi pha sbang rek. Ji-è Judas nyie khi-èrek ne Isu shii chua wie mua ne ithek wad shii zum yi pha jao ne sow phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Phiia ajiie ba pha iweb Sai pha michie chie pha igobi inai shii, Hiìadun pha michie shii shiishaithek ua shii, samoythek è Isu shii sai, “Gathek shii khihà wuii ne naro buii Hiìadun pha michie ji khriig rek iang bo è yang lei?” ");
INSERT INTO bgg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chiihphado Isu è samoy nyi shii muyung rog shii thoh ge: Rajan hà wuii ne, chiih-è nasa ne kho jariie han pha bran jia si ruii phro, nasa ne ji pha bran rog shii luagieng ne ");
INSERT INTO bgg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ai khi pha hò shii khud dun pha hò muspho shii yao bo, Masdo è yao muii ro, gu samoy chiih-è gu dug ne Hiìadun pha michie chie pha ùgud ne khi hà lei? ");
INSERT INTO bgg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chiihphado ai è ithek shii ne bajo bo lakhung ikhuno pha ùgud jishii chie pha zab saro ne ruii pha doh ruii phro. Nathek ne thiisa hà michie saro iang bo. ");
INSERT INTO bgg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Samoythek è thoh srane, rajan hà wuii thog, chiih-è Isu è ithek shii nyie khi-è yao pha ji duiine zab saro ne um iang pha doh phro; chiih-è nathek è Hiìadun pha ji Sai pha michie saro phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Habjuang re sha shii, Isu awairo snanyi samoythek rog shii ji pha ithua hà wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ithek è thiibliie hà chie pha dug shii, Isu è ithek-shii yao, “Gu nathek shii yao phro, ichiih gu rog shii chie gieng pha samoy jia è gu shii guro mak pho shii phi muii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ji-è yao mage ne, samoythek ne zo ne jia pha idoh shii jia è aishii sai, “Ji ne izai gu asi bey?” ");
INSERT INTO bgg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Isu è ithek shii chang, “Ai ne samoy snanyi è jia ji phro, hanyie è airo iweb yi guro shiikhiia rog shii wo gieng phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bran Dufuii ne jigigam shii zey ne um pha ji duiine iy ruii phro. Jishii, hanyie è Bran Dufuii shii guro makpho shii phi pha jine khama awie dang pha re ruii phro. Ji pha bran shii ne khuchung de agiak arone ji wie ba phro!” ");
INSERT INTO bgg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ithek ne chie pha dug mage shii, Isu è iweb jia chiing srane Hamangkhung-aphuii shii sia ne Laso phi ne chiih-è ji srane iweb awai samoythek shii phi. Ai è yao, “Choi mage bo, hìne guro siu ro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chiihphado ai è gog shii chiing srane Hamangkhung-aphuii shii Laso phi ne ithek wad shii phi; chiih-è ithek zab ji pha gog è niing phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Isu è ithek shii yao, “Hì ne guro ifai ro! Guro hì pha ifai ne bame branthek shii thoi phi phro, guro ifai ne Hamangkhung-aphuii awai shiinyie shii ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gune nathek shii yao phro, “Gu ne hì pha angurphuii ji Hamangkhung-aphuii ro Sajathua pha phuii iwo ji aniing sapho shii khuchung de aniing phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chiihphado ithek sthun bai srane Sumaromuang pha Phiing hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Isu è ithek shii yao, “Nathek ne gu shii thoh srane yo dun phro, Jigigam shii yao, ‘Hamangkhung-aphuii è brogpho shii ne ua muii phro, chiih-è ai shiishaithek ne dayiingdayang re dun phro.’ ");
INSERT INTO bgg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jishii gune dinne chai sieng shii, gune ithek ibi shii Galili hà wuii ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phithar è Isu shii chang, “Gai è na shii thoh marui ne de gu ne khuchung de na shii athoh phro!” ");
INSERT INTO bgg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Isu è Phithar shii yao, “Gu na shii yao, sudoh biu khephuii nyichiieng ìo pha ibi shii nane gu shii athieg ro è uomchiieng yao ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Phithar ne din è de lahuhuak gang chang, “Gune narog shii iy magunde gune ji è ayao phro!” Chiih-è, zab samoythek è de ji-duiine yao phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ithek ne Gethsemani ho muii pha ithua shii wuii thog srane Isu è awai samoythek shii yao, “Gu siaramuii shii nathek ichiih dug bo” ");
INSERT INTO bgg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ai è Phithar, Jems, chiih-è Jon shii awai rog shii noh dun. Aishii ne duhug chiih-è diig thog mage phro, ");
INSERT INTO bgg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chiih-è, ai è samoythek shii yao, “Gu lubu pha zo jine bajo boh è gu shii ne achiih iy bsa hà re dun ro. Ji-è nathek ne ichiih rai ne, chiih-è amen pha khriig rek iang bo.” ");
INSERT INTO bgg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ai ithek è ìujia ruang wuii srane nyialieg hà phieng srane sia, na è re muii arone, aishii ne riie pha ishak ji è awuii yi rabo. ");
INSERT INTO bgg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ai è sia “Aphuii” “Gu Aphuii! Na shii ne zab re mua ruii phro. Hì pha riie gog ne gu è yi muii bo. Thuh de gu è nyie yang pha ji asi ro, jishii na è nyie yang pha ji è ro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chiihphado ai è idoh dun ne riig shii samoy uom ne men iang pha doh phro. Ai è Phithar shii yao. Simon Phithar nane men muii bey? Ishak jia de sieng ne arai mua bey? ");
INSERT INTO bgg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chiih-è ai è ithek shii yao, “Khriig rek, chiih-è chuajan hà achiih yi pha sia mage bo. Chiih-è ragung ne rek yang, jishii siu ne zia ro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ai din ne wuii dun srane ibi hà yao pha miyaogam ji yao ne sia. ");
INSERT INTO bgg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chiihphado ai idoh awai samoythek hà dun shii ithek ne men pha doh iang; ithek ne mieg de ayang mua. Chiih-è aishii nyie yao chiid pha ji ne ithek ne athieg mua ro. ");
INSERT INTO bgg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ai Uomchiieng idoh dun thog shii, ai è samoythek shii yao, “Nathek ne thuh de men ne chiih-è thung bamuii bey? Khriig sha! Riig bo, ishak ne wuiiruii ro ‘Bran Dufuii shii ne layogthek bran pha blu pho wad shii phi muii phro.’ ");
INSERT INTO bgg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cho! Sieng srane dun ne, riig mage bo, hanyie gu shii khinrin pha bran ji ne ichiih um ro!” ");
INSERT INTO bgg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Isu nyayao bamuii shii, boh Phabithek chiih-è Iphey yua pha masdothek nane dukhothek è thoh ge pha ibrogthek dog ne chiih-è muchang chiih-è khamriiethek yi ne wuii pha ithek rog shii samoy snanyi è jia Judas de wuii thog. ");
INSERT INTO bgg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas è bran ibrogthek shii phriie jong phi phro: “Gu è bran hanyie shii lab phi ne khichiug pha ji ne nathek chiid pha ji ro. Aishii zum srane chui zoi muii bo.” ");
INSERT INTO bgg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Achia dang pha Judas wuii thog ruii, Ai è Isu shii wuii srane yao “Masdo!” Chiih-è aishii khichiug. ");
INSERT INTO bgg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ji-è ithek ne aishii zum srane chuh kho muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jishii thiichiih riu pho jia è ai khamriie khiasrid srane kho Phabi ro khiao pha khoh wiegthiak muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chiihphado Isu è yao srane ithek shii yao, nathek ne gu shii mugohpho duiine zum pha khamriiethek chiih-è muchiingbang rog shii wuii ne bey? ");
INSERT INTO bgg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gune idang ithek rog shii Hamangkhung-aphuii ro Misiahò hà yua shii, gu shii ne nathek è azum. Jishii hì ne jigigam zab re pha rek phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chiihphado ai samoythek ne aishii thoh marui srane yoh dun. ");
INSERT INTO bgg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bran filiao jia ribiu guii srane ai idoh gieng srane ai rog lua shii, ithek è aishii de zum pha bidiang phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jishii ai è yung thiichiih thoh marui srane ikhilen yoh dun. ");
INSERT INTO bgg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chiihphado, Isu shii ne boh Phabi, thiig pha dukhothek chiih-è Iphey yua pha masdothek wuii khrab pha hò hà noh dun. ");
INSERT INTO bgg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phithar de ruang è lua srane, kho Phabi hò sibiang shii thog. Thiichiih shii ai de hò riig pha khiaothek rog shii bai ang ne awai shii lua rek ne rai. ");
INSERT INTO bgg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Boh phabithek chiih-è zab limiangthek è Isu shii ua pha ichiig khagi sow shii, jishii ithek ne nyie de adoh mua ro. ");
INSERT INTO bgg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Khagi pho è de bajo Isu chiang shii biidiie yao, jishii ithek miyao jine a-ò ro. ");
INSERT INTO bgg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Chiihphado de giak bran è jai srane Isu mak shii khlam ne yao phro, ");
INSERT INTO bgg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Gathek è ai è hì è yao pha yoi phro, gune bran murab pha Misiahò hì ne chuak muii srane da-uom pha idoh shii ne bran murab asi pha jia rung ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jishii ithek miyao pha phaluii jine a-ò phi ro. ");
INSERT INTO bgg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kho Phabi jia è aishii ithek zab pha moe shii riu iang yi srane Isu shii musai sai, “Ithek è na shii nin ne the pha ji ne, na shii ne muchang oi bey?” ");
INSERT INTO bgg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jishii Isu è aro pha rai ne, chiih-è nyie jia de miyaogam ayao ro. Din ne Kho Phabi è aishii sai, “Na ne Hamangkhung-aphuii ro khirzey dufuii Masi ji bey?” ");
INSERT INTO bgg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isu è chang, “Gune ji chak ro, nathek de doh ruii phro Bran Dufuii ne Bohblu Hamangkhung-aphuii ro phazoi shii dug ne, chiih-è Hamangkhung è sakhamiing rog shii wuii ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kho Phabi è ai ro yung ji srane yao, gathek ne dinne muna khagi achid sha phro yao! ");
INSERT INTO bgg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ai ne Hamangkhung-aphuii shii makhakriing pha miyao jine ithek de yoi phro, jiè ithek muphak ne nyie lei? Ithek zab ne aishii mak rek phro, ai ne ichiig um ro jiè ai ne iy chid phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Thiichiih pha giak bran è Isu shii chan cho mage, chiih-è ithek è aishii mieg pho srane zuang. Chiih-è ithek è yao, “Na shii hanyie muzuang lei ne ìd riig bo!” Chiih-è, ragia rek pho è aishii noh srane phey mage phro. ");
INSERT INTO bgg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kho Phabi ro khiaomuii ji wuii thog shii Phithar yi bsa hò sbiang shii nyarai ba muii ro. ");
INSERT INTO bgg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ai è Phithar yi bai ang ne rai iang pha doh shii, ai Phithar shii miang riig srane yao, Na de Nazareth pha Isu rog pha bran bidey ne. ");
INSERT INTO bgg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jishii Phithar è aishii yao “Hì pha miyao ne izai asi ro, gune aishii athieg ro, ai è chang, na è nyie yao ramuii pha ji ne gune agao mua ro,” chiih-è ai sbiang pha muthua è fuang nyakhia dang shii, khephuii è ìo mage. ");
INSERT INTO bgg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jipha khiaomuii ji è aishii thiichiih doh srane riu pho shii jao ne yao din, “Ai de ithek è ne jia ro!” ");
INSERT INTO bgg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Jishii Phithar è dinne hì ne izai asi rone yao. Ìujia pha idoh shii ai è Phithar shii ai moe riu ne rai pha ji è dinne Phithar shii de, “Na ne ithek rog pha bran asi rone biidiie ayao mua phro, nyieliieshii na de, Galili pha bran ro.” ");
INSERT INTO bgg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chiihphado Phithar è yao, “Gu surua thak ne izai yao phro! Gu miyao ji izai asi arone Hamangkhung-aphuii ne gu shii ne lago phi phro! Chiih-è na è yao muii pha bran chiang shii gu athieg ro!” ");
INSERT INTO bgg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chiihphado dang shii khephuii è nyichiieng ìo mage phro, chiih-è Phithar ne Isu è aishii yao khe nyichiieng ìo pha ibi shii na è gu shii uomchiieng khlam ne a-ìd rone yao phrone aishii yao pha ji nowkhlei mage ne, chiih-è ai ne azud mua pha cho dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hamiang riang shii boh Phabithek è thiig pha dukhothek chiih-è Iphey yua pha masdothek chiih-è zab limiangthek ne khthiie si srane phak rai. Ithek è Isu shii shiirnai è zoi srane Philathus moe hà noh ne, ai wad shii phi muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Philathus è Isu shii sai, “Na ne Jewthek pha saja bey?” Isu è aishii chang, “Na è nyie yao pha ji ne, ji chak ro.” ");
INSERT INTO bgg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jipha boh phabithek ne Isu shii bajo ichua yao ne nin dun. ");
INSERT INTO bgg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ji-è, Philathus ne aishii sai din, “Na ne chang pha nyie oi bey? Nuii bo, branthek è na shii awie pha nin pha ji ne ayoi bey?” ");
INSERT INTO bgg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ji è yao magunde, Isu ne miyaogam jia de ayao phi, ji è Philathus de wiengphleg dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Idang Hiìadun pha ji Sai pha itho shii ne Philathus è phatheg shii chab pha hanyie shii magunde bran jia shii branthek è lia pha ji thoh muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jipha ishak shii Barabas beng pha bran jia yi phatheg hà chab muii phro, nyieliieshii ai è giak thek gak pha ji shii, gui ne bran ua muii pha chiang è phatheg hà chab muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bran ibrog è Philathus shii khrab thog ne idang rek pha duiine phathegpho jia shii thoh bo è yao, ");
INSERT INTO bgg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philathus è ithek shii sai, “Gu shii nathek ne Jewthek pha saja shii se ne thoh bo ne yang bey?” ");
INSERT INTO bgg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Philathus ne thieg muii, boh phabithek è Isu shii miegriie ne zum srane ai wad shii phi muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jishii boh phabithek è ibrogthek shii nyiu ne yao srane Isu chiang shii, Barabas shii ichad thoh phi bo è Philath shii yao ba yi phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philathus è ibrog shii sai, chiihphado gune nathek è Jewthek pha saja rone ho pha bran shii ne nyie rek bo è now lei? ");
INSERT INTO bgg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ithek è idoh ziak, “Aishii ne bai shii zun muii bo!” ");
INSERT INTO bgg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philathus è sai, “Jishii ai ne nyie ichiig rek phlei?” Ithek ne dinne de gang ziak, “Aishii ne bai shii zun muii bo!” ");
INSERT INTO bgg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philathus è bran ibrogthek wie than yi pha Barabas shii ithek chiang è thaluii thoh mage phro. Chiihphado ai è Roman siphahithek shii phi ne Isu shii chia yi srane chiih-è bai hà zun ne ua yi pha phi muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Siphahithek è Isu shii badri ro ithua pha muthua iliing hà noh srane, gai ijakthek shii de ò ho phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ithek è Isu shii yung phiang ishaig guii phi srane migem è rab pha rago ai khrug shii khak phi phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ithek è wad khung ne aishii yao, “Jewthek pha saja phiang sieng bo!” ");
INSERT INTO bgg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ithek è ai khrug shii muchang è thab srane, chiih-è ithek è aishii chan è cho phro, chiih-è, ithek lagiung niing srane aishii chiing phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ithek è aishii makhakriing ched mage shii, ithek è yung phiang than srane awairo yung idoh guii phi phro. Chiihphado ithek è aishii bai hà zun ne ua pha noh dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lumuii hà ithek è Simon beng pha bran shii si, ai yi soh è rajan hà wuiiramuii shii, siphahithek è aishii de Isu ro bai nuang pha bangchiie rek phro. (Simon ne Syrene pha bran ro, chiih-è ai ne Alezandar chiih-è Rufus ro Aphuii ro). ");
INSERT INTO bgg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ithek è Isu shii Golgotha beng pha ithua hà noh dun phro, hì pha miyao ne gadong ithua rone yao phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Thiisa hà ithek è Isu shii riie pha ji them yi pha angurphuii shii myrrh lao ne phi pha bidiang shii, jishii Isu è niing pha anuii phi ro. ");
INSERT INTO bgg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chiihphado ithek è Isu shii sharo rek ne phey srane zun muii phro, chiih-è airo yung yi awaithek chung thang rai phro, chiih-è airo yung idum ji ne hanyie muii lei ne miiran riig ro. ");
INSERT INTO bgg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hamiang ishak dige shii, ithek è Isu shii zun muii phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ai khrug lakhung shii hì the pha miyao ji zey phro: “Jewthek pha saja ro.” ");
INSERT INTO bgg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ithek è mugopho nyi shii de Isu rog shii zun muii phro, jia shii Isu phawig hà, chiih-è jia shii Isu phazoi hà. ");
INSERT INTO bgg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jigigam shii nyie yao pha ji ne hì re dun phro, Branthek è Iphey anuii pho mirek shii rek pha duiine aishii de rek phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lumuii shii lua ramuii pha branthek è khrug sid srane Isu shii gang è makhakriing phro: “Ua! Na ne Hamangkhung-aphuii ro Misiahò shii chuak srane da-uom shii rung din phi pha rek bidey ne! ");
INSERT INTO bgg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Thuh shii thazam wuii srane nawai shii bai è ragia rek bo!” ");
INSERT INTO bgg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ji duiine, boh Phabithek chiih-è Iphey yua pha masdothek de Isu shii makhakriing srane awaithek chung yao rai, “Ai ne gai thek shii ne ragia rek phi, jishii ai ne awaishii ragia arek-mua ara! ");
INSERT INTO bgg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cho Masi shii riig srane, Israel pha saja ne, thuh shii bai è thazam wuii mage arone, chiih-è gathek de aishii migi rek pha ro!” Chiih-è bran nyi hanyie shii yi Isu rog shii zun muii pha bran è de aishii makhakriing phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hanai duchoi shii zab pha soh ne igiia è chiieg dun phro, ji pha igiia ne ishak uom re dang dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ishak uom shii Isu è gang è ziak mage phro, “Eloi, Eloi, lama sabakhthani?” Hì pha miyao siu ne, “Hamangkhung-aphuii, Hamangkhung-aphuii, nane gu shii nyie rek ne ji thoh muiii phlei?” ");
INSERT INTO bgg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Thiichiih um pha giak branthek è ai miyao ji sang ayoi pha nuii srane chiih-è yao, “Yoi bo, ai ne Elija shii ho ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Thiichiih um pha bran jia è ijuang shii rui duiine rek pha yung è jiang pha muchang phiang rog shii ran srane, phuii chiieng shii wo srane Isu ro sem shii wang ne yao, “Khan rai! Elija è wuii srane aishii bai è thazam noh phi pha de um phro, cho riig haro!” ");
INSERT INTO bgg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gang è ziak srane Isu iy dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hamangkhung-aphuii ro Misiahò shii zun ne ruii pha yung de ijuang è yie ne ikhiing thog pha ji dun ro. ");
INSERT INTO bgg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Arming dumuiithek thiichiih shii hanyie bai ibi shii riu pho ne Isu nyie khi-èrek ne iy dun pha ji doh phro. “Hì pha bran ne izai Hamangkhung-aphuii ro Dufuii chak ro!” Ai è yao. ");
INSERT INTO bgg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Giak hò-amuiithek thiisa ìujia ruang è riig ne rai phro. Ithek ne Mery Magdalene, ikhuii Jems chiih-è Joseph, ro amuii Mery chiih-è salomethek ro. ");
INSERT INTO bgg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ithek ne Isu Galili hà ba shii ai rog luagieng ne nong phi pha branthek ro. Jerusalem è Isu rog shii wuii gieng pha gai hò-amuii de thiichiih shii bajo um phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Habjuang re mage shii, Joseph Arimathea wuii thog ruii phro. Ai ne limiangthek shii de ilab um pha bran ro. Chiih-è, Hamangkhung-aphuii ro Sajathua ji thog ruii phrone khan ne rai pha bran ji ro. Hì pha inai ne (Jew Thung pha Inai saro pha ibi shii ro), jiè Joseph arum pha Philathus shii wuii srane Isu siu ji lia phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philathus è Isu iy jong dun pha mua yoi mage ne wieng dun phro. Ai è awai arming dumuii shii ho ne sai, “Isu iy pha ji ne ishak phiang re sha bey?” ");
INSERT INTO bgg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Dumuiithek è yao pha idoh, Philathus è Joseph shii yao Isu ro siu ji nya yi dun bo. ");
INSERT INTO bgg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph è jiang yung pheg srane, siu shii thazam yi ne yung è jiang srane sak è chog pha wieng rab pha ji shii yi ne ruii muii phro. Chiihphado wieng cho shii bajo lubao boh thud ne kheb marui phro. ");
INSERT INTO bgg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Chiih-è Mery Magdalene chiih-è Joseph ro amuii Mery de Isu siu-iy ji khi hà wieng lei ne sow ne riig wuii phro. ");
INSERT INTO bgg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jew Thung pha Inai jong pha idoh shii, Mery Magdalene, Jems pha amuii Mery, Salome ithek è Isu ro siu shii shun pha thiiliie pheg srane Isu siu-iy shii shun pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Deobari pha hamiang riang hasiang siang mage shii ithek ne wieng hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Lumuii hà lua ramuii shii, ithek ne awaithek chung yao rai, wieng kheb pha lubao ji ne hanyie è hong phi pha lei? (Hì ne bajo boh pha lubao ro.) Ji iyao ne wuii thog mage shii, ithek è riig shii ji pha lubao ne idoh thud ne um iang pha doh. ");
INSERT INTO bgg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ji-è ithek ne wieng bucho hà wuii dun, bucho hà wuii thog mage shii, ithek è filiao bran jia ne yung phiang imo guii srane phazoi hà dug ne rai pha doh phro. Ji doh mage shii ithek ne wiengphleg dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jipha bran è yao, “Awiengphleg chid rabo, gu ne thieg, nathek ne Nazareth pha Isu bai shii zun ne ua mua pha ji sow wuii phro. Ai ne ichiih shii oi ro, ai ne chai shii hòijong dun ro, riig bo, ai ruii pha ithua shii nyie de oi ro. ");
INSERT INTO bgg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ji-è nathek ne dun srane Isu ro samoythek chiih-è Phithar shii mua yao mage bo: Isu ne nathek ibi shii Galili hà thog phro, ai è khi-èrek ne yao marui pha ji duiine thiisa hà ithek ne aishii si.” ");
INSERT INTO bgg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ithek ne zab sham ne rum chiih-è rumdun ne dun dun, chiih-è ithek ne rum ne ji pha miyaothek hanyie shii de ayao mua pha rai dun.  ");
INSERT INTO bgg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Isu chai hòi din pha idoh Deubari hamiang shii Mery Magdalene shii igobi dong, hanyie shii Isu è ibuii ragung miley khia phi pha Mery Magdalene shii si pha wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mery Magdalene è Isu ro ijakthek zo ne choh ne rai pho moe shii wuii srane yao. ");
INSERT INTO bgg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ai è ithek shii yao Isu ne isieng ro chiih-è gune doh ro, jishii ithek ne ai miyao jishii migi arek ro. ");
INSERT INTO bgg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jipha idoh, awai samoy nyi soh pha ithua lumuii è lua ramuii shii Isu ne gai mia ne isa shii dong ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ji-è isa ne thadoh dun thog ne, Isu ro gai samoythek shii yao, jishii ithek è isa shii migi arek ro. ");
INSERT INTO bgg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ji-è rek ched pha idoh shii, Isu ne awai samoy snajia yi michie chie ramuii shii dong thog ruii phro. Isu è ji pha samoythek shii giung, nyieliieshii nathek ne aishii isieng dohjong pha branthek miyao ji ne lawasdai è migi arek ro. ");
INSERT INTO bgg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Isu è ithek shii yao, zab pha sohjambling hà wuii mage srane zab branthek shii gu Muawie hì yao mage bo. ");
INSERT INTO bgg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hanyie è migi now ne gu beng è khowo yi pho ne lago è ragia re ruii phro; chiih-è, hanyie thek è migi arek pho ne layog the ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gu shii migi now pho ne gu beng è buangthek de rek mua phro; chiih-è, gu beng è awie pha ibuii ragung shii de khia mua phi phro; chiih-è, ithek ne nyuak iwo yao ruii phro; ");
INSERT INTO bgg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","chiih-è, pham chong magunde, miiriin chie na de, ithek ne nyie de achun phi phro; chiih-è ithek wad ne radshopho shii khoh ne sia phi magunde gang ruii phro. ");
INSERT INTO bgg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chiihphado Ithong Isu è ithek shii yao ched ne aishii ne Hamangkhung hà noh dun phro. Thiisa hà Hamangkhung-aphuii phazoi moe shii dug dun phro. ");
INSERT INTO bgg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ji-è samoythek ne zab pha ithua hà wuii srane Mua Wie ji yua ne lua, ji-è, Ithong è ithek rog shii rek gieng phro. Ji-è Mua Wie chiih-è buangthek rek pha ji ne izai chak rone khagi re dun ro. {9} Hò-amuii ne Phithar nane airo ijak shii wuii dun chiih-è ithek è nyie yao pha sasab ji yi dum jia yao. {10} Jipha idoh shii, Isu awai è awairo samoythek shii bichiu è nugo thogdang pha wuii yi srane idang rai mua pha giawo ji shiiy yi.");
INSERT INTO bgg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bushun Theophilus: Bran bajo è gathek duchoi shii nyie rey pha miyaothek ji zey ne phi. ");
INSERT INTO bgg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ithek è hì zey pha ne, gathek è nyie yao pha ji ne igobi è hanyie è blia doh ne rai pho è mua ji gathek shii yao phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Chiih-è naro ilab, nyieliieshii igobi è nyie zey pha ji ne wie è tham phro. Ji è gu de na shii khriig rek yi pha chiang jia zey pha now muii ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Gu hì rek pha ne nathek shii nyie yoijong pha ji izai thieg pha rek phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea pha Herod saja sieng pha ishak shii, phabi wie rek pha Abija blang Zekharia beng pha phabi jia de um. Ai yiy beng ne Elizabeth ro; ai yi ji de phabithek haliing è giak pha bimi ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ai ne Hamangkhung-aphuii mieg moe shii wie sieng ne rai. Chiih-è Ithong pha Iphey nane muyungthek nuii ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aishii ani azen, nyieliiene Elizabeth ne ani azen phi, chiih-è Elizabeth nane Zekharia bajo weg reyjong ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nai jia Zekharia yi awai Misiahò shii idang rek pha duiine awai phabi blia rek ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Phabithek è rek pha thiig pha Iphey duiine, sraibao shii bisi ziao pha miiran ne ai beng shii khia dun. Ji è ai misiahò iliing hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ai è bisi ziao pha ishak shii bran ibrogthek ne fuang hà sia ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hamangkhliie jia è bisi ziao pha sraibao shii ai phazoi moe shii wuii ruii. ");
INSERT INTO bgg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zekharia è aishii doh mage shii, ai ne bizieng srane rum dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ji shii hamangkhliie è aishii yao, Zekharia, na ne arum chid rabo! Hamangkhung-aphuii è na misia yoijong ro, chiih-è na yi Elizabeth è de dufuii jia giak ruii phro, na ne aishii Jon beng bo. ");
INSERT INTO bgg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nathek ne khama lised nane sang ruii phro, chiih-è ai giak mage shii gai branthek de bajo sang ruii phro! ");
INSERT INTO bgg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ai ne Ithong mieg moe shii bajo boh bran rey ruii phro. Chiih-è ai ne phuii wegthek de aniing phi phro. Nyagiak dang pha idoh aishii ne Ragung So è ley dun phro, ");
INSERT INTO bgg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Chiih-è Israel pha bajo branthek shii awaithek pha Ithong Hamangkhung-aphuii moe shii idoh noh din ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ai ne chaig Elija duiine giang now ne bajo boh riichai Ithong awai pha ibi shii wuii dun phro, ai è aphuii nane aniphiing shii de òjia shii khrab din phi phro; ai è miyao anuii ne chun phothek shii dun giang noh pha lumuii hà idoh rai din yi phro; ai è Ithong pha branthek shii saro phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekharia è hamangkhliie shii yao, “Hì thek rey pha gu ne khi è thieg ruii phlei? Gu ne weg sha dun ro; Chiih-è gu yiy de weg rey sha dun ro.” ");
INSERT INTO bgg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hamangkhliie shii ji è chang, gu ne Gabyiel ro, “Gu ne hanyie è na shii hì thek pha miyao nane mua wie hì yao yi pha thoh pha Hamangkhung-aphuii rog riu muii ro, ");
INSERT INTO bgg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","hì ne ishak khriig rey shii ne izai rey ruii phro, jimagunde na ne hì pha guro mua ji izai anow. Na è migi arek pha ji è na ne miyao de ayao mua phro; nane sudoh è thiwing gu è sbang rek ne ruii pha izai arey sapho shii ne nane bi-ìe rey ne rai dun phro.” ");
INSERT INTO bgg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ji è rek pha ishak shii, branthek Zekharia shii khan ne rai. Chiih-è ai Misiahò hà nyama ishak nyie rek ne rai ara inow ne branthek munowthiig dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ai fuang khia mage shii, ai ithek shii nyie de miyaogam ayao mua, chiih-è ithek ne thieg ai ne Misiahò hà ibang bang ara, ai nyie de miyaogam jia de ayao muluii pha rey srane jimagunde ai è ithek shii wad è phrai ne yao. ");
INSERT INTO bgg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ji è rek pha ishak shii Misiahò hà airo bliajong sha shii Zecharia awai hò hà idoh dun marui. ");
INSERT INTO bgg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ìujia pha idoh shii ai yi Elizabeth ne ani wiig, ji è habie guii thogdang pha ji pha hò shii athoh. ");
INSERT INTO bgg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabeth è yao. Idohòi shii Ithong è gu shii nong phi, “Ai è gu ro biwo ji ruang rek phi!” ");
INSERT INTO bgg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elezabeth yi ani wiig ne habie riig rey shii Hamangkhung-aphuii è hamangkhliie Gabyiel shii Galili pha bajarai hà Nazareth beng pha ithua hà thoh ge ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ai è ji pha mua yi Joseph è yie pha ro è gang pha bimi jishii yao, ai ne Dawid Saja pha riing ro, ji pha bimi beng yi Mery ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hamangkhliie shii è bimi jishii wuii thog srane yao, liijiing ne narog shii um ro! Ithong ne narog shii um ro chiih-è bajo boh khirzey ne na shii phi ro! ");
INSERT INTO bgg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mery yi hamangkhliie pha mua ji è bajo diig than dun, chiih-è Mery ne ai miyaogamthek ne nyie ga inow ne wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hamangkhliie è aishii yao, “Mery; arum chid rabo. Hamangkhung-aphuii è na shii bushun rek ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na ne ani wiig ruii phro chiih-è dufuii giak ruii phro, chiih-è na aishii Isu beng bo. ");
INSERT INTO bgg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ai ne bajo boh phro Chiih-è aishii ne bajo giu pha Hamangkhung-aphuii Dufuii rone ho ruii phro. Ithong Hamangkhung-aphuii è aishii ne awai blang Dawid mirek pha ji duiine saja rab phi phro, ");
INSERT INTO bgg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Chiih-è ai ne Jakhob pha riingthek shii idang pha saja rey ne rai ruii phro, airo boh riichai ne khuchung de ajong phro!” ");
INSERT INTO bgg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mery è hamangkhliie shii yao, “Gu ne giang bimi ro, ji è, nyie khi-èrek ne hì rey mua phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hamangkhliie è chang, “Ragung so de na shii wuii ruii phro, chiih-è Hamangkhung-aphuii ro blu de na lakhung shii thog ruii phro. Ji pha chiang è hì pha ani So shii ne Hamangkhung-aphuii ro dufuii rone ho phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nawairo siang Elizabeth shii no mage bo. Ai è de yao gu ne ani agiak mua sha phro, jimagunde de ai ne bajo miriang habuii shii ani wiig ne habie riig rey sha ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ji-è Hamangkhung-aphuii è arek mua pha nyie de oi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mery è yao: “Gu ne Ithong pha khiao ro, Na è gu shii nyie yao pha ji rey yi bo.” Chiih-è hamangkhliie è aishii thoh marui ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Achia dang pha idoh shii Mery è saro srane Judea soh pha phiingduii hà riie ne jog wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ai è Zekharia hò hà wuii srane Elizabeth shii salam phi. ");
INSERT INTO bgg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth è Mery è khung ne yao pha ji nyayoi dang mage shii, ani yi ai lui iliing hà sid, chiih-è Elizabeth ne Ragung So è ley dun, ");
INSERT INTO bgg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chiih-è goh gang è yao, “Na ne zab pha hò-amuii è de bajo khirzey um ro, chiih-è na giak pha ani ji de bajo khirzey um ro! ");
INSERT INTO bgg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ithong pha amuii ne gu shii wuii ruii ne hì thek ne gu shii nyie rek ne rey ruii phlei? ");
INSERT INTO bgg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gu è na è khung ne yao pha ji nyayoi dang mage shii, gu iliing shii um pha arone chiung ne sang dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ithong pha mua ji ne na shii izai rey ruii phrone yao pha ji shii migi rek pha ji è khama sang phro!” ");
INSERT INTO bgg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mery è yao, “Gu lubu è Ithong shii laso phi muii ro; ");
INSERT INTO bgg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Gu luruak ne . lised mua ro nyieliieshii Hamangkhung-aphuii ne garo ragia ro, ");
INSERT INTO bgg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nyieliieshii gu shii ne awairo zum khiao duii rone inow phi ro! Ji è sudoh è thiwing branthek gu shii sang pha ro è ho ruii phro, ");
INSERT INTO bgg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nyieliieshii boh muna ne bajo blu Hamangkhung-aphuii pha è gu shii rek phi. Ai beng ne So ro; ");
INSERT INTO bgg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hanyie thek è aishii lab rek arone ithek shii ne blang thog dang pha ai bushun doh yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ai awairo blu wad ji è phia srane ithek miphia nane muphak rai jithek ne zab dayiingdayang rek muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ai è blu sajathek shii ithek ro ithua è thazam khia muii phro, chiih-è are-ahopho shii laziung chiing phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ai è chi-iyiy pho shii ne wie muna phi ge phro, chiih-è bukhothek shii ne wad isloi thoh ge phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ai ne gethek achinmoithek shii sbang rek pha ji ne zab rek phi ro, chiih-è awai khiao Israel shii nong gieng pha wuii phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ai ne idang athodang pha Abraham nane zab airo riingthek shii nowkhlei ro!” ");
INSERT INTO bgg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mery ne Elizabeth rog shii habie uom thog pha rai marui ne awai hò hà dun din dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth yi ani giak pha ishak rey mage shii, ai è ani yi dufuii jia giak khlei. ");
INSERT INTO bgg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ai ro hadung-haluii nane siangthek è, aishii Ithong è khama buang pha blia wie rek pha ji yoi srane, ithek de zab ai rog shii lubo rek gieng. ");
INSERT INTO bgg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ani ji yi damiley rey sha mage shii, ithek è aishii migiangkheg pha noh ne wuii dun, chiih-è ithek è ani beng yi ai aphuii beng Zekharia duiine beng pha saro. ");
INSERT INTO bgg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ji shii ai amuii è yao, “Asi! Ai beng ne Jon ruii chid phro.” ");
INSERT INTO bgg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ithek è aishii yao, “Jishii hì pha ibeng ne na siang hanyie shii de abeng ro!” ");
INSERT INTO bgg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ji è ithek è iphuii shii wad è khoh srane sai, hì pha bufuii beng ne nyie ruii pha now lei? ");
INSERT INTO bgg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zekharia è ithek shii zey pha lubao ithileg jia lia srane zey phi, “Hì pha ani beng ne Jon ro.” Ji è ithek ne zab wiengphleg dun! ");
INSERT INTO bgg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ji è rek dang pha ji shii Zekharia de miyao yao mua dinne ai Hamangkhung-aphuii shii laso phi pha jao. ");
INSERT INTO bgg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ji-è rek mage shii hadung-haluii pho ne zab rum dun, chiih-è ji pha mua ne zab phiingduii um pha Judea soh hà yoi thog dun. ");
INSERT INTO bgg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hanyie è ji yoi mage shii ji now srane sai, “Ji pha ani ne nyie rey pha um ga?” Hì ne izai ro Ithong pha blu ne ai rog shii um ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon ai aphuii Zekharia yi Ragung So è ley ne, chiih-è Hamangkhung-aphuii mua yao: ");
INSERT INTO bgg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cho gethek ne Ithong, Israel pha Hamangkhung-aphuii shii laso phi sha rai haro! Ai ne awai bran shii nong phi pha chiih-è sey ne noh phi pha wuii ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ai è gethek shii awai khiao Dawid pha riing è blu Ragia rek pha jia phijong ro. ");
INSERT INTO bgg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ai è buyo è awairo so chaigpho ji è sbang rekjong ro ");
INSERT INTO bgg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ji è ai ne gethek mak pho è, chiih-è hanyie è gethek shii snai pho pha blu è de ragia rek phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ai è yao ai gethek pha achinmoithek shii bushun rek phi phro, chiih-è awai shiinyie ug pha ji de athoh pha nowphi phro, ");
INSERT INTO bgg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Wie rek ne gethek ro blang Abraham shii shurua thak, ai è gethek shii gethek pha mak pho è ragia rek phi pha sbang rekjong phi ro, chiih-è gethek shii arum dang pha ai blia rek pha phijong ro, ");
INSERT INTO bgg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ji-è gethek sieng pha ishak shii, ai moe shii idang so nane gieng sieng ne rai chid phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Gu ani, nane, Bajo Giu Hamangkhung-aphuii pha chaig rone è ho ruii phro. Na ne Ithong pha ibi wuii srane airo lumuii rab iang phro, ");
INSERT INTO bgg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nawai branthek shii yao bo nawaithek layog khungjong arone ragia rey phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gethek Hamangkhung-aphuii ne bushun nane jum ro, ai è ichuang phi ne giawo gethek lakhung shii thog yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Chiih-è ai è igiia hà iy ne rai pho shii de hamangkhung è khilieng phi ruii phro, liijiing pha lumuii hà de gethek shii gayiig noh phro.” ");
INSERT INTO bgg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ji pha ani ne sieng ne siu nane ragung ne gang rey dun ro, ai ne Israel pha bran moe khia pha nai athog sapho shii ne balimuang hà rai phro. ");
INSERT INTO bgg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ji pha ishak shii Bisiu Augusthus è Roman bukho boh thiig shii bran ibeng zey pha yung. ");
INSERT INTO bgg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Igobi ji è rek ne bran tham ramuii pha ishak shii, Khuirinius yi Syria pha badri ro. ");
INSERT INTO bgg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Zab pha branthek wuii srane awaithek ibeng zey pha awaithek thawun hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph de Galili pha Nazareth thawun è Judea pha Bethlehem thawun, Dawid saja giak pha ji hà wuii dun. Joseph thiisa hà wuii pha ji ne, nyieliieshii ai de Dawid saja pha riing è giak pha ji muwuii ro. ");
INSERT INTO bgg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ai de awai è gang pha Mery rog shii ibeng zey pha wuii dun, ai ne ani wiigjong ro, ");
INSERT INTO bgg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chiih-è ithek Bethlehem hà ba shii, aishii ani giak pha ishak thog dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ai è dufuii giak bi, chiih-è aishii yung è jiang srane rogo hà chab ne ruii, thiisa hà ne ai rai pha ùgud de oi ro. ");
INSERT INTO bgg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ji pha soh iring jia hà de brogphothek de nyaliak shii habiu hà de awaithek shiishai riig ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ithong pha hamangkhliie è ithek moe shii dong khlei ruii, chiih-è Ithong pha biisiie ithek lakhung shii chuang khlei ruii. Ithek ne bajo sham ne rum dun, ");
INSERT INTO bgg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ji shii hamangkhliie shii è ithek shii yao, “Arum chid rabo! Nathek shii phi pha gu ichiih mua wie rog shii um ro. Gu ne ichiih shii zab pha branthek shii boh lubo phi pha ji yao pha wuii phro. ");
INSERT INTO bgg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sudoh pha sud shii Dawid saja pha thiig shii, nathek shii ragia rek phi pha Ithong Masi giakjong ro! ");
INSERT INTO bgg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ji thieg yi pha ne, ithek è ani jia yung shii jiang ne rogo iliing shii thieng ne rai pha doh ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hamblo shii hamangkhung pha boh arming hamangkhliie rog shii wuii thog srane, Hamangkhung-aphuii shii lasothek bai phi: ");
INSERT INTO bgg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Zab è giu pha Hamangkhung-aphuii shii hamangkhung hà biisiie rey bo, sohnyiak hà na è hanyie shii sang pha ji shii de liijiing phi bo!” ");
INSERT INTO bgg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hamangkhliie shii ithek è idoh hamangkhung hà dun marui shii, brogpho awaithek chung yao rai, “Cho gethek de Bethlehem hà wuii srane Ithong è gethek shii yao pha duiine ji rey dun pha ji riig rai.” ");
INSERT INTO bgg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ji è ithek khthiie wuii dun ne Mery nane Joseph shii doh chiih-è ani yi rogo iliing shii thieng ne um pha doh. ");
INSERT INTO bgg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Brogphothek è aishii doh mage shii, hamangkhliie shii è ani chiang shii nyie yao pha ji yao phi. ");
INSERT INTO bgg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Zab pha branthek de brogphothek miyao ji yoi ne wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mery è jithek pha zab miyao now srane lubu iliing hà wie now din. ");
INSERT INTO bgg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Brogphothek ne hamangkhliie shii è yao pha ji duiine yoi ne doh pha ji è Hamangkhung-aphuii shii laso bai ne idoh dun din dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Damiley pha idoh shii, ani ro migiangkheg pha ishak thog mage shii, aishii Isu beng, nyieliieshii ani awiig ba pha ibi shii hamangkhliie shii è yaojong. ");
INSERT INTO bgg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Joseph nane Mery shii Moses mizen marui pha Iphey duiine muhui ne sai pha ishak thog mage shii, ithek è aishii Jerusalem hà noh ne Ithong ibi shii phi. ");
INSERT INTO bgg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ithong ro Iphey shii zey pha duiine, zab è igobi bufuii giak pha ani ne Ithong shii phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ithek de Ithong ro Iphey miichiid duiine pharo nyi chiih-è khu-atham ichiung nyi yie srane zidphi. ");
INSERT INTO bgg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ji pha idoh shii thiisa hà Simeon beng pha bran jia Jerusalem shii rai. Ai ne bajo wie nane Hamangkhung-aphuii shii rum ne rai pha bran ro, chiih-è Israel shii ragia rek phi pha ji shii khan ne rai phro. Ragung So de ai rog shii um. ");
INSERT INTO bgg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chiih-è aishii ne yaojong ro ai ne Ithong sbang rek pha Masi shii adoh sapho shii ne na a-iy phro. ");
INSERT INTO bgg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Luruak è Simeon shii Misiahò hà noh ne wuii dun, ji è Iphey shii nyie khi-èrek chid pha ji rek pha ai aphuii ai amuii è Isu shii de Misiahò hà noh ne wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon è ani ji wad shii giak srane Hamangkhung-aphuii shii laso phi. ");
INSERT INTO bgg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ithong wo, na è nawai sbang ji rek phi, chiih-è na nawai khiao shii liijiing è dun yi bo. ");
INSERT INTO bgg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gui mieg è naro giawo ne doh ge ro. ");
INSERT INTO bgg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Na è zab pha branthek miie shii rab ne ruiiphi, ");
INSERT INTO bgg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na ne muchuang de gaibranthek shii de na è yang pha ji re-è chuang phi, chiih-è nawairo Israel pha branthek shii de biisiie rek phi. ");
INSERT INTO bgg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon è ai pha miyao yao mage ne, ani pha iphuii imuii ne wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ji è rek magunde Simeon è ithek shii khirzey phi ne, ai amuii, Mery shii yao, “Hì pha arone Hamangkhung-aphuii è Israel phothek buii rek pha nane giawo rek phi pha guajong ro. Ai ne Hamangkhung-aphuii è cheb jia mua mage ne bajo branthek è aishii gidieg rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chiih-è ithek è ug ne now pha ji dong yi srane. Chiih-è duhug ne, khamriie chieg duiine na lubu shii giao ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Asher pha jad Phanuel idimi Ana beng pha chaig weg jia um. Ai ne gey dun ne idam miley rey ba bie shii ai ne idam samiliao è wi reyjong dun. Ai ne Misiahò shii athodang; ai ne hanai nane habiu de Hamangkhung-aphuii shii minyie nane misia sia. ");
INSERT INTO bgg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ji pha ishak shii ai de thiichiih wuii thog srane Hamangkhung-aphuii shii laso phi chiih-è khuchung Hamangkhung-aphuii è Jerusalem shii chie phi phro è khan pha branthek shii ani chiang ji yao phi. ");
INSERT INTO bgg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ithong pha Iphey shii nyie khi-èrek chid pha ji duiine rek ched marui srane, ithek idoh Galili pha Nazareth awairo thawun awaithek hò shii thog ro. ");
INSERT INTO bgg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ani yi lasieng ne bugang rey mage srane aishii ne khani de ley um, chiih-è Hamangkhung-aphuii ro khirzeythek de ai lakhung shii um. ");
INSERT INTO bgg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Dam tham ne Hiiadun pha ji Sai pha inai shii Isu iphuii-imuii ne Jerusalem hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Isu ne dam snanyi rey mage shii ithek ne idang duiine buii hiia dun pha ji sai pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sai pha jijong ched mage shii ithek ne idoh hò dun pha jao shii, Bufuii Isu ne Jerusalem hà rai dun. Ji-è rek pha ji yi iphuii imuii yi athieg; ");
INSERT INTO bgg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iphuii imuii è now shii ai ne branthek rog shii rek ruii ara, jishii ithek ne hamiang è habzuang thog pha lua srane aishii thiichiih ijak nane siangthek rog shii um inow ne soh, ");
INSERT INTO bgg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ithek è aishii adoh phi, ji è ithek ne aishii soh pha Jerusalem hà idoh wuii din dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Da-uom rey pha idoh shii aishii ne Misiahò hà Jewish masdothek rog shii dug ne, ithek miyao ji nuii srane musai sai ne rai iang pha doh ruii. ");
INSERT INTO bgg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ai miigao ne chang pha ji yoi ramuii phothek ne zab wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iphuii-imuii de ai ji è rek ramuii pha ji riig srane, “Nowbuang dun, chiih-è imuii è idufuii shii yao, gu dufuii na è gasa shii diig nyie rek phlei? Na aphuii gasha ne munow thiig srane rum ne na shii soh.” ");
INSERT INTO bgg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ai è isa shii chang, “Nasa gu shii nyie rek ne sow phlei? Nasa ne athieg bey gu ne gui ro aphuii hò shii um chid phro?” ");
INSERT INTO bgg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ithek ne ai miichang ji ne agao ro. ");
INSERT INTO bgg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ji è Isu ne ithek ro miyao nuii srane ithek rog shii Nazareth hà idoh dun din gieng. Ai amuii è ji è rek pha jithek zab lubu iliing hà now ne ruii. ");
INSERT INTO bgg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hamangkhung-aphuii nane branthek pha haro mua ne. Isu ro siu nane khani ne boh sieng dun. ");
INSERT INTO bgg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Thiberius è Bisiu rek ne idam snaguii rey shii; Phonthius Philath yi Judea pha badri ro, chiih-è Galili thiig pha saja yi Herod ro, chiih-è ji pha soh Ithurea nane Thrachonithis pha saja yi Herod ikhuii Philiph ro; Chiih-è Abilene pha saja yi Lysanias ro, ");
INSERT INTO bgg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chiih-è Anas nane Khaiaphas yi Kho Phabithek ro. Ji pha ishak shii Hamangkhung-aphuii miyaogam yi balimuang hà Zekharia dufuii Jon shii thog. ");
INSERT INTO bgg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ji-è Jon ne Jordan Khamuii ring pha zab soh è dong ne lua srane yao; nathek layog è khid ne khowo yi bo, “Chiihphado Hamangkhung-aphuii è ithek layog de khung phi phro.” ");
INSERT INTO bgg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nyieliieshii hì pha miyao ne Aijaya jigigam shii zey ne um ro: “Bran jia balimuang shii ziak ramuii ro: ‘Ithong pha lumuii khriig rek ramuii ro; Ai lua pha lumuii miang rab ramuii ro! ");
INSERT INTO bgg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Zab pha gaphiek um ne de lim dun phro, Zab pha phiingduii nane phiingthek lieg rab muii phro. Zab pha lumuii khi-èg um ne de miang rab dun ro, Chiih-è khama pha lumuii sua um magunde neb rabjong ro. ");
INSERT INTO bgg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Zab pha branthek de Hamangkhung-aphuii ro giawo doh ruii phro!’ ” ");
INSERT INTO bgg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bran brogthek ne Jon è Khowo phi yi pha wuii thog mage shii. Ai è ithek shii yao, “Pham nathek!” “Hamangkhung-aphuii muthoh pha lago ji è nathek ne yoh mua phrone, nathek shii hanyie miyao lei? ");
INSERT INTO bgg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ji-è nathek ne layog è idoh khid rone doh yi pha bliathek rek mage bo. Chiih-è ithek ne Abraham ne ithek blang rone jao ne ayao chid rabo. Gu nathek shii izai yaodang phro, Hamangkhung-aphuii è hì pha lubao yi srane Abraham ro riingthek nyarab mua phro! ");
INSERT INTO bgg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Thabiu ne hing iriingthek shii che pha khriig rek ne ruiijong ro, iwoi wie awoi pha hingmuii shii ne zab che ne bai shii fen muii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Branthek è aishii sai, “Ji arone, gathek ne nyie rek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ai è chang, “Hanyie shii magunde phadiig nyie um arone jia yi oi pho shii phi bo, chiih-è hanyie shii magunde michie um arone gai shii de thang bo.” ");
INSERT INTO bgg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mijin thanphothek de khowo yi pha wuii thog, chiih-è ithek è aishii sai, “Masdo, gathek ne nyie rek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ai è ithek shii yao, “Nathek shii chua mua pha ji è huak pha athan rabo.” ");
INSERT INTO bgg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Siphahithek è de aishii sai, “Gathek chiang shii de nyie ga? Gathek ne nyie rek chid phlei?” Ai è ithek shii yao, “Hanyie shii magunde bangchiie bang ayie rabo chiih-è gai shii biidiie athe rabo. Nawai shii nyie mua pha ji shii liingsed bo.” ");
INSERT INTO bgg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Branthek è luthong pha ji ne boh rey ruii, chiih-è ithek ne Jon ne yang ne Masi ne bey rone inow. ");
INSERT INTO bgg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ji è Jon è zab shii yao, “Gu ne nathek shii kho è khowo phi bie, jishii gu è de bajo boh bran jia wuiiramuii ro. Gu ne ai lakhia thang de se mua sbo asi ro. Ai è nathek shii Ragung So nane bai è khowo phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Chiih-è awai rog shii de dasai um ro, doh jia ai ne phiug shii sai srane igam shii yoi rek srane awai haphuii hà chab ne ruii phro, chiih-è isug shii ne khuchunde anyia pha bai hà fen muii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bajo gai pha lumuii è rek srane Jon branthek shii Mua Wie ji yao, chiih-è ithek shii awaithek lumuii è lai bo ne khung ne yao. ");
INSERT INTO bgg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ji shii Jon è Herod badri shii giung, nyieliieshii ai è ikhuii ro yiy Herodia shii yie, chiih-è gai awie pha bliathek bajo rek. ");
INSERT INTO bgg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ji-è Herod ne din de buii rek ne Jon shii phatheg hà chab muii. ");
INSERT INTO bgg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Zab pha branthek Khowo yie ched pha idoh shii, Isu è de Khowo yie. Chiih-è ai siaramuii shii, Hamangkhung de hong ruii, ");
INSERT INTO bgg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chiih-è Ragung So de thazam ai siu lakhung shii pha ro duiine wuii thog. Chiih-è Hamangkhung è yao ruii, “Na ne guro miie pha dufuii ro. Chiih-è gu ne na shii sang muii ro.” ");
INSERT INTO bgg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Isu è awai blia jao pha ishak shii, ai ne dam sa-uom reyjong dun. Ji shii branthek è aishii ne Heli pha dufuii Joseph ro dufuii ro inow bie, ");
INSERT INTO bgg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","chiih-è Melchi ne Mathath ro dufuii, chiih-è Mathath ne Lewi ro dufuii, chiih-è Lewi ne Melchi ro dufuii, chiih-è Melchi ne Janai ro dufuii, chiih-è Janai ne Joseph ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","chiih-è Joseph ne Mathathias ro dufuii, chiih-è Mathathias ne Amos ro dufuii, chiih-è Amos ne Nahum ro dufuii, chiih-è Nahum ne Esli ro dufuii, chiih-è Esli ne Nagai ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","chiih-è Nagai ne Math ro dufuii, chiih-è Math ne Mathathias ro dufuii, chiih-è Mathathias ne Semein ro dufuii, chiih-è Semein ne Josekh ro dufuii, chiih-è Josekh ne Joda ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","chiih-è Hoda ne Jaonan ro dufuii, chiih-è Jaonan Reso ro dufuii, chiih-è Reso ne Zerubabel ro dufuii, chiih-è Zerubabel ne Shealthiel ro dufuii, chiih-è Shealthiel ne Neri ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","chiih-è Neru ne Melkhi ro dufuii, chiih-è Neru ne Adi ro dufuii, chiih-è Adi ne Khosam ro dufuii, chiih-è Khosam ne Elmadam ro dufuii, chiih-è Elmadam ne Er ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","chiih-è Er ne Joshua ro dufuii, chiih-è Jousua ne Eliezer ro dufuii, chiih-è Eliezer ne Jorim dufuii, chiih-è Jorim Mathath dufuii, chiih-è Mathath ne Lewi dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","chiih-è Lewi ne Simeon ro dufuii, chiih-è Simeon ne Juda ro dufuii, chiih-è Juda ne Joseph ro dufuii, chiih-è Joseph ne Jonam ro dufuii, chiih-è Jonam ne Eliakhim ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","chiih-è Eliakhim ne Malea ro dufuii, chiih-è Malea ne Mena ro dufuii, chiih-è Mena ne Mathatha ro dufuii, chiih-è Mathatha ne Nathan ro dufuii, chiih-è Nathan Dawid ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","chiih-è Dawid ne Jese ro dufuii, chiih-è Jese ne Obed ro dufuii, chiih-è Obed ne Boaz ro dufuii chiih-è Boaz ne Salmon ro dufuii, chiih-è Salmon ne Nohshon ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","chiih-è Nahshon ne Aminadab ro dufuii, chiih-è Aminadab ne Admin ro dufuii, chiih-è Admin ne Arni ro dufuii, chiih-è Arni ne Hezron ro dufuii, chiih-è Hezron ne Pherez ro dufuii, chiih-è Pherez ne Juda ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","chiih-è Judah ne Jakhob ro dufuii, chiih-è Jakhob ne Isakh ro dufuii, chiih-è Isakh ne Abraham ro dufuii, chiih-è Abraham ro dufuii, chiih-è Therah ro dufuii, chiih-è Nahor ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","chiih-è Serug ro dufuii, chiih-è Serug ne Reu ro dufuii, chiih-è Reu ne Pheleg ro dufuii, chiih-è Pheleg ne Eber ro dufuii, chiih-è Eber ne Shelah ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","chiih-è Shelah ne Khainan ro dufuii, chiih-è Khainan ne Arphazad ro dufuii, chiih-è Arphazad ne Shem ro dufuii, chiih-è Shem ne Naoh ro dufuii, chiih-è Naoh ne Lamekh ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","chiih-è Lamekh ne Methuselah ro dufuii, chiih-è Methuselah ne Enokh ro dufuii, chiih-e Enokh ne Jared ro dufuii, chiih-è Jared ne Mahalalel ro dufuii, chiih-è Mahalalel ne Khenan ro dufuii, ");
INSERT INTO bgg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","chiih-è Khenan ne Enosh ro dufuii, chiih-è Enosh ne Seth ro dufuii, chiih-è Seth ne Adam ro dufuii, chiih-è Adam ne Hamangkhung-aphuii ro dufuii. ");
INSERT INTO bgg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isu Jordan è idoh dun ramuii shii Ragung So è ley srane Ragung è aishii balimuang, ");
INSERT INTO bgg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","hà now ne inai sawi thog pha Ibuii è aishii bajo chuajan phi. Ji pha ishak shii ai nyie de achie dang, jijong mage shii, ai de chi-iy iy. ");
INSERT INTO bgg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibuii è aishii yao, “Na Hamangkhung-aphuii pha dufuii chak arone, hì pha lubao shii yung ne iweb rey yi mage bo.” ");
INSERT INTO bgg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isu è chang, “Jigigam shii izey ro, ‘Bran ne iweb ji è sieng ne arai bie phro.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ji pha idoh shii de ibuii è aishii lakhung hà noh srane din pha zab sohjambling khoh pha ji riig yi. ");
INSERT INTO bgg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ibuii è aishii yao, “Gu na shii hì thek pha zab blu nane zab nuruii na shii phi ruii phro, hì zab ne ithek è gu wad shii phijong ro, chiih-è hanyie shii gua ne ruii pha ji shii nyaphi mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na è gu shii sia arone hì thek zab ne naro rey phro.” ");
INSERT INTO bgg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isu è aishii chang, “Jigigam shii è yao ro, ‘Nawairo Ithong Hamangkhung-aphuii shii sia bie bo chiih-è airo blia rek bie bo!’ ” ");
INSERT INTO bgg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ji pha idoh è de ibuii è Isu shii Jerusalem pha Misiahò zab è lakhung pha ithua hà riu yi srane, aishii yao, “Na Hamangkhung-aphuii pha dufuii chak arone ichiih-è buzam nawai è lung mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jigigam shii è yao ro, Hamangkhung-aphuii è awai hamangkhliie yung srane na shii gayiig rek phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hì de yao, ‘Ithek è na shii awaithek wad è khoh srane na lai de labao rangde akhiia yi phro.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isu è chang, “Jigigam shii yao ro, ‘Nawai Ithong Hamangkhung-aphuii shii achai rabo.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ibuii è Isu shii chuajan phi ched ne, ishak ìujia thog pha aishii thoh ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ji pha idoh Isu ne Galili hà idoh dun din, chiih-è Ragung So pha blu de ai rog shii um. Ai mua ji ne ji pha soh hà zab yoi dun. ");
INSERT INTO bgg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ai è Jewthek misiahòthek hà de yua, chiih-è zab pha bran è de aishii laso phi. ");
INSERT INTO bgg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ji è Isu ne awai giak ne sieng pha Nazareth hà wuii dun, idang duiine Jewish Thung pha Inai shii ai de Jewthek misiahò hà wuii dun. Ai è riu srane jigigam ji tham, ");
INSERT INTO bgg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chiih-è ai wad shii chaig Aijaya jigigam ji phi, ai è jigigam ji hong shii hì izey pha ji doh ruii, ");
INSERT INTO bgg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ithong Ragung ne gu lakhung shii um ro, nyieliieshii ai è dusho shii mua wie yua yi pha gu shii gua ro. Gu shii ne phatheg hà chab ne um pho shii de khia yi pha, chiih-è miegthi pho shii doh din yi pha chiih-è bajo diigkhui muii pho shii de yong ne noh pha yao pha thoh ge ro. ");
INSERT INTO bgg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Chiih-è Ithong è awai branthek shii ragia rek pha ishak thog sha ro è yao pha thoh ge ro.” ");
INSERT INTO bgg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Isu è siog ji nim srane, ilkhi rek muii pha wad shii idoh phi srane dug din, Jewthek misiahò zab branthek ne aishii athodang pha riig ne rai, ");
INSERT INTO bgg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ji è ai è ithek shii yao, “Sudoh ichiih tham pha jigigam itho ji ne ithek yoi pha chiang è zab izai rey ge ro.” ");
INSERT INTO bgg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ithek è ai è yao pha miyaogam wie ji wie nuii ne wiengphleg dun. Ithek è yao, “Ai ne Joseph ro dufuii asi bey?” ");
INSERT INTO bgg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ai è ithek shii yao, “Gune izai thieg chak ro, nathek ne hì pha najang yao pha ji ne gu shii yao phro, ‘Ma pha bran na nawai shii gang phi riig bo.’ Nathek è Khaphernaum hà rek pha yoi pha ji duiine ichiih gui hò thiig shii de rek yi pha yao phro.” ");
INSERT INTO bgg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Isu è ithek shii yao din, “Gu nathek shii hì yao, chaig shii ne awai hò nane thiig shii wie aho ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gu shii yoi mage bo, hì ne chaigthek ro Elija sieng pha ishak shii Israel hà misiung bajo um, ji pha ishak shii haphie aphie pha idam uom è khuyo thog dang pha zab soh shii diigchiao thog. ");
INSERT INTO bgg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Jishii Elija ne Israel hà hanyie shii de athoh ge ro, jishii Sidon pha soh Zarephath hà rai pha misiung shii thoh bi ge. ");
INSERT INTO bgg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chiih-è Elija chaig pha ishak shii de Israel hà rai pha branthek de thiig ne awie dang pha hìa è rad pha thiisa hà bajo um; jimagunde zab pha bran ne wie arey, jishii Syrian pha Naman jia miwie bie ro.” ");
INSERT INTO bgg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Misiahò shii branthek è ji è yao pha ji yoi srane bajo lijieg dun. ");
INSERT INTO bgg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chiih-è ithek jai fad srane Isu shii reng ne fuang thawun hà noh srane, awaithek thiig rab pha phiingduii giu hà noh dun. Ithek è ji pha phiingduii è buzam reng pha rek, ");
INSERT INTO bgg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ai è bran ibrog duchoi è lua srane awai lumuii hà dun marui. ");
INSERT INTO bgg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ji-è Isu Khaphernaum pha thiig Galili hà wuii dun, thiisa hà Jewish Thung pha Inai shii ai è branthek shii yua. ");
INSERT INTO bgg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ithek ai muyua ji nuii srane wiengphleg dun, nyieliieshii ai ne bajo riichai um ne yao dun. ");
INSERT INTO bgg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Misiahò shii awie pha ibuii ragung um pha bran jia um, ai è goh gang è ziak ne yao, ");
INSERT INTO bgg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah! Na ne gathek shii nyie chid pha um ga, Nazareth pha Isu? Na ichiih shii buii rek pha wuii ne bey? Gu ne thieg na hanyie ga, nane Hamangkhung-aphuii pha So mua yao.” ");
INSERT INTO bgg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Isu è ragung shii giung, “Aro rabo chiih-è bran ji è fuang khia bo!” Ibuii ji yi ji pha bran shii buzam nyiak hà ai moe shii thud yi srane aishii nyie de buii arekdang pha khia ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Branthek ne zab wiengphleg srane awaithek chung yao rai, “Hì ne khi-èrek pha miyaogamthek lei? Riichai nane blu um ne hì pha bran è awie pha ragung shii giung, chiih-è ithek de fuang khia dun!” ");
INSERT INTO bgg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chiih-è Isu ro mua ji ne zab ji pha thiig hà yoidun. ");
INSERT INTO bgg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Isu è Jewthek misiahò ji thoh marui srane Simon hò hà wuii dun. Simon ro khiing ne bajo hakhangzia ne rad ji è ithek è Isu shii ji pha hò-amuii chiang yao iang. ");
INSERT INTO bgg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ai è wuii srane hò-amuii biang moe shii riu ne hakhang jishii khia bo è giung. Ji-è giung shii hakhangzia pha ji de hò-amuii è khia dun, chiih-è ai khthiie sieng srane ithek shii chie niing pha rab phi. ");
INSERT INTO bgg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hasiang yem ched shii ijakthek è ichua ichua pha miiriie um pha ijakthek shii Isu moe hà noh thog ruii, Ai è zab shii wad ruii srane ithek shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ji-è rek mage shii bajo ibuiithek de bran è khia srane ziak ne yao, “Na ne Hamangkhung-aphuii ro dufuii chak ro!” Isu è ibuiithek shii giung ne, ayaodang yi, nyieliieshii ithek ne thieg Isu ne Masi chak ro. ");
INSERT INTO bgg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hanaithung pha ishak shii Isu è thiig thoh ne liijiing ithua hà wuii dun. Branthek è jao ne aishii sow, chiih-è ithek è aishii doh mage shii, branthek è aishii ithek è thoh ne adun yi pha bidiang. ");
INSERT INTO bgg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ji shii ai è ithek shii yao, “Gu ne Hamangkhung-aphuii pha Sajathua pha Mua Wie ji ne gai bajaraithek hà de yao chid phro, nyieliieshii gu shii Hamangkhung-aphuii è ji è rek pha thoh ge ro.” ");
INSERT INTO bgg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ji-è ai ne ji pha soh Jewish misiahò shii wuii ne yua. ");
INSERT INTO bgg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nai jia Isu yi Genesareth pha khabang ring shii riu ramuii shii branthek è Hamangkhung-aphuii ro miyaogam nuii pha ai moe shii zab reng ne wuii thog. ");
INSERT INTO bgg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ai è run nyi yi kho ring pha lakhung shii yie ne ruii pha doh; jishii ù ua pho è jithek thoh marui ne chiugthek bsang ramuii shii, ");
INSERT INTO bgg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Isu è Simon ro run lakhung shii khurog srane, aishii yao, run jishii kho ring ji è thithe hà nyong yi pha yao. Isu è run iliing shii dug srane bran ibrogthek shii yua. ");
INSERT INTO bgg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ai è yao ched mage shii, ai è Simon shii yao, “Naro run thithe khajam hà yie srane, chiih-è na nane naro ijak yi naro chiug è ù zum pha mua mage bo.” ");
INSERT INTO bgg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon è chang, “Masdo, gathek è zab habiu chiug mua shii, jia de azum mua ro. Ji shii na è yao muii arone, gu è chiug nyamuii riig.” ");
INSERT INTO bgg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ithek è chiug mua mage shii, ù yi bajo phieng srane chiug de ji pha rek dun. ");
INSERT INTO bgg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ji è ithek gai pha run hà awaithek ijakthek shii wuii ne ithek shii nong gieng bo è leb ne ho. Ithek è wuii srane run nyi shii ù ley chab ched shii run yi kho iliing hà zem pha rek. ");
INSERT INTO bgg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Phithar è nyie rey pha ji riig srane, Isu lagiung moe shii bam srane yao, “Ithong, Na gu moe è dun bo! Gu ne bajo layog bran ro!” ");
INSERT INTO bgg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Awaithek muzum pha ù ji è ai nane ai rog pha branthek ne zab wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ji duiine Simon ro ijak Jems nane Zebedi pha dufuii Jon de wiengphleg dun. Isu è Simon shii yao, “Arum chid rabo; sudoh è thiwing nane branthek shii zum ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ithek è run shii kho ring lakhung hà yie ne, zab manathek thoh marui ne, Isu rog shii luagieng. ");
INSERT INTO bgg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Luang jia Isu yi gai pha thiig hà rairamuii shii, thiichiih shii buii saduii rek ne rad pha bran de jia um. Ai è Isu shii doh mage ne, awailum ne buzam bam srane Isu shii khung ne yao, “Masdo, na è rek yang arone, na è gu shii so nyarek mua phi phro!” ");
INSERT INTO bgg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isu è awai wad phia srane, chiih-è aishii khoh srane. Chang, “Gu è rek pha now ro. So rey dun bo!” Ji è yaodang pha ji shii Miiriie ji de bran è thoh dun. ");
INSERT INTO bgg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Isu è aishii yao, “Hì pha miyao yi hanyie shii de ayao rabo, jimagunde phabi shii miang wuii ne nawai shii doh yi bo, chiih-è zab pha moe shii wie ge rone doh yi bo, chiih-è Moses muyung pha duiine mizid zid phi bo.” ");
INSERT INTO bgg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ji shii din è de Isu ro mua ji ne lahuak bajo yoi khlei dun, chiih-è bran ibrogthek aishii nuii pha nane miiriiethek gang yi pha aishii wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ji shii ai ne liijiing um pha ithua hà sia pha dun dun. ");
INSERT INTO bgg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nai jia Isu yua ramuii shii, Galili, Judea chiih-è Jerusalem pha thiigthek è wuii pha Pharisithek nane Iphey yua pha masdothek de thiichiih shii dug gieng. Radphothek shii gang rek phi pha Ithong pha blu ne Isu shii um gieng. ");
INSERT INTO bgg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Giak branthek è slem è riie pha bran jia shii lawiao rog shii han ne wuii thog ruii, chiih-è ithek è bidiang ne hò bucho hà noh ne Isu ibi shii ruii pha rek. ");
INSERT INTO bgg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jimagunde bran bajo um pha ji è, lumuii amua phi ne ithek è aishii Isu moe shii noh ne awuii mua, ji è ithek zak lakhung hà noh srane saphai hong ne, awai lawiao rog shii buzam bran ibrog um pha duchoi Isu ibi shii ziin phi. ");
INSERT INTO bgg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Isu è ithek shii bajo migi um pha ji doh mage ne, ai è bran jishii yao, gu ijak “Naro layog ne khungjong phi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ji è yao pha ji nuii srane Iphey yao pha masdo nane Pharisithek awaithek chung yao rai, “Makhak-riing yao pha bran hì ne hanyie ga? Layog khung phi pha ne Hamangkhung-aphuii jia bie ro!” ");
INSERT INTO bgg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Isu è ithek munow jithek thieg srane ithek shii yao, “Nathek ne hì nyie rek ne now phlei? ");
INSERT INTO bgg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hì è rek ne yao pha ji ne wie ba bey? Na layogthek ne khungjong phi ro è yao pha ji wie ba asi pha nawai lawiao chiing ne jai ne lua mage bo è yao pha ji wie bey? ");
INSERT INTO bgg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gu ne nathek shii Bran Dufuii ne sohnyiak shii layog khung phi pha riichai um pha doh yi.” Ji è ai ne slemriie pha bran jishii yao, “Gu na shii yao, jai srane, nawai lawiao chiing ne hò hà dun shabo!” ");
INSERT INTO bgg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ji pha bran è zab pha bran moe è khthiie jaifad srane, thiichiih wiao pha lawiao yie ne awai hò hà dun srane Hamangkhung-aphuii shii laso phi. ");
INSERT INTO bgg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Thiichiih um pha branthek zab wiengphleg ne rum ne Hamangkhung-aphuii shii laso phi ne yao, “Sudoh gathek ne khuchung de adoh ba pha blia de doh ge ro!” ");
INSERT INTO bgg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ji pha idoh, Isu fuang hà wuii dun shii, mijin than pha Lewi beng pha jia yi awai ophis shii dug ne rai pha doh. Isu è aishii yao, “Gu rog shii luagieng bo.” ");
INSERT INTO bgg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi è jaifad srane, zab thoh marui ne, ai rog shii luagieng. ");
INSERT INTO bgg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ji pha ido Lewi è Isu shii chie noh pha ai hò shii michie boh jia saro, chiih-è ji pha biwenthek ne bajo mijin thanphothek nane Gaibranthek ro, ");
INSERT INTO bgg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","giak Pharisithek nane ithek ro Iphey yua pho masdothek è, Isu ro samoythek shii yao, “Nathek ne mijin thanphothek rog nane gai riingthek rog shii nyie rek ne chie niing phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isu è ithek shii chang, “Bran hanyie arad arone ma pho achid phro, jimagunde hanyie rad pho ne ma pho chid phro. ");
INSERT INTO bgg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Gu ne ichiih shii ilab um pha branthek shii ho pha awuii ro, jimagunde layogthek shii ho pha wuii phro!” ");
INSERT INTO bgg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Giak branthek è Isu shii yao, “Jon ro samoythek ne blebbleb minyie nyie ne sia phi, chiih-è Pharisithek ro samoythek de ji duiine rek, jishii naro samoythek ne chie niing ne rai.” ");
INSERT INTO bgg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isu è chang, “Phiyiy pha bufuii nya um ba shii ne biwenthek shii michie achie yi pha dun ge pha ji wie nabey? Ji ne awie phro! ");
INSERT INTO bgg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ji shii doh jia ne ji è rek pha inai thog ruii phro phie pha bufuii ne noh dun phro, ji pha ido è, ithek ne minyie nyie ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Isu è ithek shii hì pha najang de yao, hanyie magunde yung wo è ithileg ji srane yung ihèg shii miak ne aphiog phro, ai ji è rek arone, airo yung wo ji ne ji dun phro, chiih-è iwo nane ihèg ji a-ò rai phro. ");
INSERT INTO bgg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hanyie è de jariie ihèg shii phuii nyu giog ne achab phro, nyieliiene phuii nyu ji muna rey mage shii ji pha jariie ne chui srane phuii ne zab noi dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ji-è phuii nyu ne jariie iwo shii chab chid phro. ");
INSERT INTO bgg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chiih-è phuii weg ji niing pha idoh shii ne hanyie de phuii nyu ji aniing yang phro. Ai ne yao phro, iweg ji ne wie ba ro. ");
INSERT INTO bgg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jewish Thung pha Inai shii Isu yi phiug raig è dong srane luaramuii shii. Airo samoy pho è raig pha iwoi ji pho srane wad shii nan ne chie. ");
INSERT INTO bgg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Giak Pharisithek è sai, ithek ne Iphey shii arek rabo ne zen pha duiine Jewish Thung pha Inai shii hì thek ne nyie rek phlei? ");
INSERT INTO bgg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isu è ithek shii chang, “Nathek ne Dawid nane ai branthek chi-iyiy mage shii nyie rek pha ji atham ba bey? ");
INSERT INTO bgg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ai è Hamangkhung-aphuii hò hà wuii srane, Hamangkhung-aphuii shii zud pha iweb ji yie srane chie, chiih-è awai bran shii de phi ne chie yi. Thiichiih shii zud pha iweb ne phabi michie mua bie ro, gai hanyie è ji chie pha ne Iphey shii chun pha rek phro.” ");
INSERT INTO bgg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chiih-è Isu ne iidohhè yao, “Bran Dufuii ne Jewish Thung pha Inai pha Ithong ro.” ");
INSERT INTO bgg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dinpha Jewish Thung pha Inai shii Isu Jewthek misiahò hà wuii srane ithek shii yua. Thiisa hà wad phazoy shii slemriie pha bran de jia um. ");
INSERT INTO bgg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Giak Iphey yua pha masdothek nane giak Pharisithek ne Isu è chun pha blia rek muii rone nin yang mage ne Jewish Thung pha Inai shii gang phi bey ne wie riig ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ji shii Isu è ithek munow jithek thieg mage ne bran jishii yao, “Jai srane ibi hà wuii mage bo.” Ji pha bran ji è jai srane thiichiih shii riu. ");
INSERT INTO bgg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chiihphado Isu è aishii yao, “Gu na shii sai, Jewish Thung pha Inai gethek Iphey shii nyie rek pha zen ga? Nong phi pha ji bey? Asi pha chun phi ji bey? Bran shii ragia rek phi pha ji bey? Asi pha chun phi pha ji bey?” ");
INSERT INTO bgg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ai è ithek shii zab shan ne riig srane ji pha bran shii yao, “Naro wad phia mage bo.” Ai è ji è rek, chiih-è ai wad de wie rey dun. ");
INSERT INTO bgg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ithek ne ji riig srane bajo lijieg ne Isu shii nyie rek sha pha fuang hà dun ne awaithek chung nung rai. ");
INSERT INTO bgg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ji pha ishak shii Isu yi phiingduii hà sia pha wuii ne thiisa hà ji pha habiu zab Hamangkhung-aphuii shii sia ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hanai rey mage shii ai è awai samoythek shii awai moe hà ho srane snanyi shii gua, ai è ithek shii guaphasamoythek ro è beng ne ruii: ");
INSERT INTO bgg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ithek ne Simon (hanyie shii ai è Phithar ro è de beng) chiih-è ikhuii Andrew shii; Jems nane Jon, Philiph nane Bartholomew, ");
INSERT INTO bgg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Methiu nane Thomas, Alphayus pha dufuii Jems, chiih-è Simon (hanyie shii thiig moe pha bran rone ho muii pha ji), ");
INSERT INTO bgg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jems pha dufuii Judas, chiih-è Judas Iskharioth hanyie è khlam rek pha ji thek ro. ");
INSERT INTO bgg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Isu yi awairo guaphasamoythek rog phiing è thazam dun thog shii, ai yi ilieg pha ithua shii samoythek ibrog rog shii awairo boh pha samoythek rog shii riu, ji pha branthek ne Judea pho chiih-è Jerusalem pho chiih-è Thaire nane Sidon pha khamuii ring pha rajan phothek ro; ");
INSERT INTO bgg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ithek ne airo miyao yoi pha chiih-è awaithek ro miiriie ji wie rek yi pha wuii phro. Chiih-è ibuii ragung è diig phi phothek de thiichiih wuii ne gang dun. ");
INSERT INTO bgg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Zab pha branthek è aishii khoh pha bidiang, nyieliieshii ai blu fuang khia ne ithek shii gang rek yi pha rek. ");
INSERT INTO bgg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Isu è awai samoythek shii riig srane yao pha, Dusho nathek shii sang um ro, Hamangkhung-aphuii pha Sajathua ne nathek ro ro! ");
INSERT INTO bgg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sang bo nathek ne thiih shii chi-iyiy pho ne, Nathek shii ley phi! Nathek thiih shii cho pho ne; Nathek ne siak ruii phro! ");
INSERT INTO bgg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nyieliieshii Bran Dufuii chiang è nathek shii bran è amiie ruii arone, chiih-è nathek shii snai ruii arone, chiih-è nathek shii makhakriing rek ruii arone, chiih-è nathek shii awie rone yao ruii arone ithek ne sang mage bo! ");
INSERT INTO bgg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lised boh ji rey mage shii, lubo ji shii siu bo, nyieliieshii Hamangkhung hà boh lasen ne na shii ruii phi ro. Ithek blang è chaigthek shii de ji duiine rek ro. ");
INSERT INTO bgg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jishii thiih shii bukho shak pho ne khama thiig rey ruii phro; nawaithek wie sieng pha ne siengjong ro! ");
INSERT INTO bgg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Thiih ley um pho nathek shii ne khama thiig rey ruii phro; Nathek ne chi-iyiy ruii phro! “Thiih shii siak pho nathek ne khama diig phro; Nathek ne duhug rek ne choh ruii phro! ");
INSERT INTO bgg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Thiih shii branthek è nathek shii wie yao ruii arone khama thiig ruii phro; ithek ro blangthek de ji duiine khlam pha chaigpho miyao chiang è yao ruii. ");
INSERT INTO bgg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Jishii gu miyao nuii pho ithek shii yao phro: nawai shuangthek shii miie mage bo, na shii awie pha rek pho shii wie rek mage bo, ");
INSERT INTO bgg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Hanyie è ithek shii muchocho arone, ithek shii khirzey phi bo, chiih-è hanyie è nathek shii gidieg rek arone ithek chiang sia phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chiih-è hanyie magunde na mizia jia shii phey arone, dinne de naro yoh pha mizia hà de choi bo; chiih-è naro rugud gaithek yie dun arone naro phadiig de yie yi bo. ");
INSERT INTO bgg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hanyie è na shii nyie lia magunde aishii phi bo, chiih-è hanyie è naro nyie yie dun magunde idoh phi pha alia rabo. ");
INSERT INTO bgg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na è gaithek shii nawai shii khi-èrek yi pha now pha duiine ithek shii de ji rek phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nathek shii hanyie è miie jishii nathek è miie bie arone? Khi-èrek ne nathek shii khirzey mua mage phlei? Layog phothek rang de ithek shii miie pho shii ne ithek de miie phi. ");
INSERT INTO bgg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chiih-è hanyie nathek è ithek shii wie rek jishii wie rek bie arone, nathek ne khi-èrek ne khirzey mua mage phlei? Jine layogphothek rang de rek! ");
INSERT INTO bgg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chiih-è ithek hanyie è idoh mua pha luthong ne jishii chei bie phi arone, khi-èrek ne khirzey mua mage phlei? Nyieliieshii layog pho rang de layog phothek shii chei ne idoh yi din! ");
INSERT INTO bgg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Asi! Nawaithek mak shii miie bo chiih-è ithek shii wie rek bo; chei phi srane, idoh mua pha aluthong rabo. Chiihphado nathek shii ne boh lasen um ruii phro, chiih-è nathek ne bajo giu pha Hamangkhung-aphuii pha dufuii rey ruii phro. Ai ne laso aphi pho shii nane layog phothek lakhung shii wie phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nawaithek Aphuii è bushun rek pha duiine bajo bushun rek bo. ");
INSERT INTO bgg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Gaithek shii achua rabo, ji arone Hamangkhung-aphuii è de nathek shii de achua phro, chiih-è khi shii athe rabo, ji arone nathek shii de Hamangkhung-aphuii è athe ruii phro; gai shii khung phi bo, ji arone Hamangkhung-aphuii è na shii de khung phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gai shii phi bo, ji arone Hamangkhung-aphuii è na shii de phi ruii phro. Hì ne izai chak ro, na shii ne briie ley pha mua ruii phro, na è nyakhoh mua ne khuchung de amuii ba pha nong ji ne na laluii shii thoi ruii phro, na è gai shii chua pha briie ji è, Hamangkhung-aphuii è na shii de chua ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Isu è ithek shii hì pha najang è yao: “Miegthipho è miegthi shii noh ne alua mua phro; ai è noh ne lua magunde nyimanyi nyahiung hà chiih dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Samoythek ne masdo è boh asi ro, jishii samoythek è zab dab ched mage ne, masdo duiine nyarey mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Na nawai mieg shii iphen han srane, nawai khuii ro iphen ji riig ne nyie rek ne yao phlei? ");
INSERT INTO bgg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nawai iphen aphan bi pha nyie khi-èrek ne nawai khuiinothek shii yao phiilei? Gu khuiinothek wo! Na mieg shii iphen um pha ji ne gu shii phan yi bo. Lawasdai nathek! Igobi nane nawai mieg pha iphen ji phan bi bo, chiih-è na ne wie riig mua srane, nawai khuiinothek ro mieg iphen de wie doh ne nyaphan mua phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Hingmuii wie ne awie pha iwoi awoi phro, ji duiine hingmuii awie pha è de iwoi wie awoi phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Zab pha hingmuii ne iwoi woi ruii pha ji è thieg ruii phro; na ne khuchung magunde migem biing è iphem apho phro, chiih-è khuchung magunde migem biing è angur awoi phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bran wie ne lubu liing hà de wie khrab ne fuang hà dun ne wie khia ruii phro; bran awie pho ne lubu liing hà awie pha khrab ne fuang hà de awie pha khia ruii phro. Ji-è lubu hà nyie now lei ne sem hà è de ji yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Gu è nyie yao pha ji ne thuh de arek ba pha rek srane, nathek gu shii ‘Ithong’ Ithong ro è yao ne nyie rek pha ho phlei? ");
INSERT INTO bgg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hanyie è gu shii wuii srane gu miyaogamthek nuii ne lubu hà ruii arone ai ne hanyie ga gu nathek shii doh yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ai ne hanyie è sak shii icho chog ne awai hò rung pha sarong zieg pha duiine ro, khamuii è khed ne jao magunde ji pha hò ne asid phro, nyieliieshii hì ne chuh rung dun. ");
INSERT INTO bgg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jishii hanyie è gu miyaogamthek nuii srane jishii alua pho ne hanyie è awai hò rung shii sarong wie azieg pha rung pha duiine ro; khokhed ne ji pha hò shii jao mage shii hò ji ne jog chuak dun, ji è chuak mage ne zab è de awiedang pha chuakbraig dun.” ");
INSERT INTO bgg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Isu è branthek shii jithek zab yao ched maruii shii, awai ne Khaphernaum hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roman dumuii è bajo bushun rek pha airo khiao jia um; ji pha bran ye rad ne iy sha pha rek. ");
INSERT INTO bgg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dumuii è Isu ro mua ji yoi mage ne, ai è Jewish dukhothek shii ai khiao jishii gang phi pha ho pha thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ithek è Isu shii wuii srane wie khung ne yao, “Ji pha bran ne izai naro nong chid pha um ro. ");
INSERT INTO bgg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ai ne gathek bran shii miie chiih-è ai awai è gathek shii Jewthek misiahò de rung phi phro.” ");
INSERT INTO bgg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ji-è Isu de ithek rog shii wuii gieng. Ai ji pha hò è ruang asi ba shii dumuii ji awai ijakthek shii thoh ne aishii yao yi, “Masdo, nawai shii diig arek chid rabo, Na gu hò shii wuii mua pha ne gu shii ne chua oi ro. ");
INSERT INTO bgg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ji è gu de na shii wuii mua sapho asi ro, nane yao bie mage bo, ji arone guro khiao ji ne gang dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gu, è de dumuiithek boh iliing shii pha bran ro, chiih-è gu iliing shii de sandrithek um ro. Gu è jia shii ‘Wuii’ bo è yung arone, ai de wuii dun phro! Chiih-è gai shii, ‘Thawuii!’ bo è yao arone ai de thawuii phro; chiih-è gu gui khiao, ‘Shii hì rek!’ bo è yao arone ai ne rek phi.” ");
INSERT INTO bgg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Isu è ai miyao ji nuii srane wiengphleg ne idoh rei srane ai rog shii lua pha iphiingthek shii yao, “Gu nathek shii yao, hì duiine pha migi ne thiih de adoh ba ro, chiih-è Israel shii magunde adoh ba ro!” ");
INSERT INTO bgg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Muapho idoh dumuii hò hà dun shii airo khiao yi gang iang pha doh. ");
INSERT INTO bgg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Achiadang pha idoh shii Isu ne samoythek nane bran ibrog dog srane ithek shii gang rek yi ne Nain beng pha thiig hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ai ne thiig pha gak hà nyathog dang shii, ithek bran iy jia han srane fuang hà noh ne wuiiramuii pha doh. Ji pha bran iy yi misiungmuii ro dufuii ji jia ji ro, chiih-è thiig pha bran ibrog de ji pha hò-amuii rog shii wuii gieng. ");
INSERT INTO bgg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ithong è hò-amuii shii ji è rey ramuii pha ji riig srane, ai lubu yi ji pha hò-amuii shii bajo bushun now dun, Ji è ai è hò-amuii shii yao, “Acho rabo.” ");
INSERT INTO bgg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chiihphado ai è wuii srane bran iy han pha ji shii khoh mage, ji è han pha branthek de thung dun. Jishii Isu è yao, gu na shii yaodang phro, “Filiao bufuii! Sieng mage bo.” ");
INSERT INTO bgg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iyjong pha bran ji è siangfad ne dug srane miyao jao ne yao, chiih-è ji pha bran shii Isu è imuii shii idoh phi din. ");
INSERT INTO bgg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ji è rek pha ji riig srane zab branthek yi rum ne Hamangkhung-aphuii shii chiong, “Ithek è yao; gethek duchoi shii chaigphuii boh jia khia thog ro! Hamangkhung-aphuii ne awai bran shii ragia rek pha wuii thog ro!” ");
INSERT INTO bgg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hì pha Isu pha mua ji yi zab pha soh pha ithua iring hà de zab yoi dun. ");
INSERT INTO bgg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jishii Jon ro samoythek è jithek pha miyao aishii yao ched shii, ai è bijiu nyi shii ho, ");
INSERT INTO bgg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Chiih-è Ithong shii sai pha isa shii thoh ge, “Chiih-è Jon è wuiiramuii ro è yao pha ji bey? Asi pha gathek ne gai shii luthong chid habey?” ");
INSERT INTO bgg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ai è Isu shii wuii thog mage shii, isa è yao, “Jon Khowo è gathek shii hì è yao ne sai pha thoh ge ro, Na ne Jon è wuiiramuii ro è yao pha ji na bey? Asi pha gathek ne gai shii luthong habey.” ");
INSERT INTO bgg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ji pha ishak shii Isu è branthek ro rad pha, miiriie thek nane awie pha ragungthek shii gang phi, chiih-è miegthi pha branthek shii de doh din yi. ");
INSERT INTO bgg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ai è Jon ro muapho shii chang, “Nasa nyie doh nyie yoi pha ji ne, idoh dun srane ne Jon shii yao bo: Miegthi pho de doh dun ro, chiih-è lai khi-èg lua ge ro, chiih-è hanyie yi awie pha diig rek ne hìa rad pha bran de so rab ge ro, chiih-è khohphang pho de yoi ge ro, chiih-è iy pho de hòi dinro, chiih-è Mua Wie ne dushothek shii yao dun ro. ");
INSERT INTO bgg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Gu shii khlam rone anow pho ne bajo sang dun ro!” ");
INSERT INTO bgg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chiihphado Jon ro muaphothek è thoh marui srane dun din shii, Isu è bran ibrog shii ai chiang ji jao ne yao: “Nathek è balimuang shii Jon hà wuii shii, nyie shii luthong ne wuii phlei? Nathek yi hasam è saing rab yi thenia thania pha ji riig wuii ne bey? ");
INSERT INTO bgg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nathek fuang hà nyie riig pha wuii phlei? Bran yi wie yung guii pha ji riig wuii ne bey? Bran hanyie è ji duiine guii ne sang ne rai pho ne saja hò hà doh ruii phro! ");
INSERT INTO bgg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gu shii yao riig bo, nathek fuang hà wuii srane nyie riig wuii phlei? Chaigthek shii riig wuii ne bey? Ji ne izai chak ro, jimagunde ithek ne chaig è de bajo boh jia doh yi. ");
INSERT INTO bgg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jigigam shii yao pha ji ne Jon ji chak ro, ‘Hamangkhung-aphuii è yao, gu ne gui mua pho shii naro lumuii hong yi pha na ibi thoh ge phro.’ ");
INSERT INTO bgg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Isu è yao,” Gu è nathek shii zai yaodang phro, “Jishii idang rai pha bran è de Jon boh ba ro. Jishii Hamangkhung-aphuii pha Sajathua shii ìu um ne de ai ne Jon è de boh ba phro.” ");
INSERT INTO bgg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Zab pha branthek è aishii yoi, ithek nane mijin thanphothek dungdang ne Hamangkhung-aphuii ro giang nak ne, ithek de Jon ro khowo yie. ");
INSERT INTO bgg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jishii Pharisithek nane Iphey yua pha masdothek è Hamangkhung-aphuii munow pha miyao ji snai srane Jon ro khowo de ayie. ");
INSERT INTO bgg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Isu è yao din, “Chiihphado duchung pha branthek shii, khi-èrek ne chua ne yao sha phlei? Ithek ne khi-èrek pha duiine lei? ");
INSERT INTO bgg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ithek ne bajarai pha ithua shii dug ne rai pha aniphiing duiine ro. Gai ibrog è gai shii ziak srane yao, ‘Gathek ne phiyiy pha ben nathek shii khuang phi, jishii nathek è asiu! Gathek è bi-iy ibai bai shii ithek è achoh phi!’ ");
INSERT INTO bgg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon Khowo phi pha ji wuii thog ne, chiih-è ai ne minyie nyie srane phuii de aniing, chiih-è ithek è yao, ‘Ai iliing shii ne ibuii um ro!’ ");
INSERT INTO bgg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bran Dufuii yi wuii thog mage ne, chiih-è chie niing shii, ithek è yao, ‘Hì pha bran shii riig bo! Ai ne sugow ne chie niing pha jia ara, chiih-è ai ne mijin than phothek nane layogthek pha ijak ro è yao!’ ");
INSERT INTO bgg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hamangkhung-aphuii pha khani è, hanyie è nuii lei ne ji ne izai chak rone doh yi phro.” ");
INSERT INTO bgg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisi jia è Isu shii ai hò hà michie chie pha ho, ji è Isu yi ji pha Pharisi hò hà wuii srane michie chie sha pha dug. ");
INSERT INTO bgg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ji pha thawun shii layog rek ne sieng pha hò-amuii de jia rai. Ai è Isu ne Pharisithek hò hà michie chieramuii pha yoi, ji è ai ne rem no pha (alabasther) sumaro ley jariie yie ne wuii thog ne, ");
INSERT INTO bgg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Isu idoh shii riu srane, cho ne awai mieg kho è ai lai shii sad phi. Chiihphado è awai khaziang è ai lai shii go rek phi ne, ai lai shii khichiug ne, chiih-è sumaro rek ne aishii shun phi. ");
INSERT INTO bgg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharisithek è ji doh srane, awai shii yao, “Hì pha bran ne izai chaigphuii arone, aishii kho pha hò-amuii ji ne hanyie ga ai ne nyathieg mua phro, chiih-è hì pha hò-amuii yi khi-èrek ne layog è sieng ne rai ji de ai nyathieg mua phro!” ");
INSERT INTO bgg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Isu gang è aishii yao, “Simon, gu na shii nyie magunde yao pha um ro.” “Simon è chang, Masdo, Yao mage bo.” ");
INSERT INTO bgg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Isu è jao ne yao, “Buyo buyo shii bran nyi è bang chei pho è bang chei phi, jia è aishii liiman pha sikhi wieng guii chei, chiih-è bran yoh jia ji è saguii chei. ");
INSERT INTO bgg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jishii isa è hanyie de idoh arang mua, jimagunde ai è isa ro muruii shii alia pha thoh muii, ji arone, aishii hanyie è bajo miie ruii phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Simon è chang,” “Gu munow arone, hanyie shii bajo bang yi pha um shii idoh alia pha thoh muii pha ji è bajo wie now phro.” Isu è yao, “Na miyao ji ne izai chak ro.” ");
INSERT INTO bgg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jishii ai è hò-amuii jishii rei srane riig ne Simon shii yao, “Na hì pha hò-amuii shii doh ramuii bey? Gu ne na hò hà wuii shii, na è gu lai sud pha kho de aphi, Jishii ai è awai miegkho è gu lai sud phi srane awai khaziang rek ne sad ne go phi. ");
INSERT INTO bgg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na è gu shii ne khichiug srane wie aho ro, jimagunde gu nyawuii thog dang ne ai gu lai shii athodang pha khichiug bamuii ro. ");
INSERT INTO bgg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na è gu khrug shii sumaro yow è ashun phi, jimagunde ai è gu lai shii wie now pha thiiliie è shun phi. ");
INSERT INTO bgg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ji è, gu na shii yao, airo bajo miie pha ji è airo layogthek ne khungjong ge ro è doh yi ro. Jishii layog ìujia khung bie pha ne, airo miie pha de ìujia bie rone doh yi phro.” ");
INSERT INTO bgg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chiihphado Isu hò-amuii shii yao, “Na layog khungjong phi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Gaithek thiibliie shii dug pho è awaithek chung yao rai, “Layog shii rang de khung phi pha hì ne hanyie ga?” ");
INSERT INTO bgg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jishii Isu è hò-amuii shii yao, “Naro migi è na shii ragia rek ge ro; na ne liijiing è dun bo.” ");
INSERT INTO bgg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ìujia pha ishak idoh shii Isu è bajarai nane thiig ji hà lua srane, Hamangkhung-aphuii pha Sajathua pha mua wie ji yao. Samoy snanyi de ai rog shii wuii gieng. ");
INSERT INTO bgg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Chiih-è hanyie shii awie pha ragung nane miiriie è wie rek phi pha hò-amuiithek de ai rog shii um: Mery (hanyie shii Magdalene rone ho), aishii è ibuii ragung de miley dukho fuang khia phi pha ji ro; ");
INSERT INTO bgg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, ai igey Chuza yi Herod ophis pha dumuii; chiih-è Susana, chiih-è gai pha hò-amuiithek awaithek miwiang è Isu nane samoypho shii nong phi. ");
INSERT INTO bgg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Branthek yi thawun nane ji pha idoh gai athodang pha Isu shii wuii; chiih-è branthek yi wuii thog srane bajo iphiing khrab mage shii, Isu è hì pha najang yao: ");
INSERT INTO bgg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Luang jia thiisa hà bran jia um ai yi iriie jiie wuii pha fuang hà wuii dun, ai è iriie yi raig shii jiie marui, giak iriie yi lumuii ring hà chiih dun, ji pha iriie shii ne thum dun, chiih-è fuii è chong ne chie muii. ");
INSERT INTO bgg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chiih-è giak miiriie yi labao surong pha ithua hà chiih dun, chiih-è iphiu sieng thog mage shii goh dun, nyieliieshii nyiak yi liing asi. ");
INSERT INTO bgg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Giak miiriie yi migem biing hà chiih dun, iphiu ne sieng shii chiih-è aishii lam dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Chiih-è giak miiriie yi nyiak wie shii chiih pha ji è; iphiu sieng srane iwoi de wie woi ruii, iwoi jia jia shii wieng thog pha woi.” Chiih-è iidohhè Isu è yao, chiihphado, yoi mage bo, nathek shii khohthek um arone. ");
INSERT INTO bgg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Awairo samoythek è Isu shii sai hì pha najang è shan ne yao pha miyaosiu nyie lei? ");
INSERT INTO bgg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chiih-è ai ithek shii chang, nyieliieshii Hamangkhung-aphuii ro Sajathua pha khani ug ne ruii pha ji ne nathek shii phijong ro, chiih-è gaithek shii ne najang è shan ne yao chid phro, nyieliieshii ithek ne riig pha ne riig shii adoh, chiih-è yoi phane yoi shii agao. ");
INSERT INTO bgg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hì pha najang pha miyao ne hì ro: Miiriie ne Hamangkhung pha miyaogam ro. ");
INSERT INTO bgg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Miiriie lumuii shii chiih phro è yao pha ji ne hì ro, hanyie è ji ne nuii phane nuii shii; Jimagunde Sakhathong è wuii srane ithek lubu è yie ne dun marui, nyieliieshii migi nane ragia ithek shii arey yi pha rek phro. ");
INSERT INTO bgg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Iriie yi sak lakhung shii chiih phro è yao pha ji ne hì ro, hanyie è mua ji yi nuii srane lised ne yie dun. Jishii ithek iliing shii akhud phi; ithek ne ìujia pha migi now bie ne jimagunde thiig pha ishak thog mage shii ithek ne thoh muii. ");
INSERT INTO bgg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Iriie yi migem biing hà chiih phro è yao pha ji ne hì ro, hanyie è mua ne nuii, jimagunde diig now pha ji è chiih-è bokho rek pha now pha ji è chiih-è awai shii wie sieng pha now pha ji è aishii ne lam dun ro. Chiih-è ai iwoi ne khuchunde amen mua ro. ");
INSERT INTO bgg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Iiriiethek nyiak wie shii chiih pha miyao ji ne hì ro, hanyie thek è mua ji wie nuii ne lubu iliing hà ruii ne, chiih-è ithek iwoi yi awai muspho shii ne zud ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hanyie magunde ichuang shii siikhiiakhjam è phieng ne aruii ro, chiih-è biang iliing hà de aruii ro. Jishii ichuang yi iliing wuii pho shii sang doh yi pha bunthruak lakhung hà ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nyie ug ne ruii magunde fuang hà doh yi phro, chiih-è nyie magunde cheg ne ruii pha ji ne ichuang hà yi ne doh dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chiihphado, ithek khi è nuii pha ji ne “Wie gayiig bo; nyieliieshii hanyie shii ìujia um pho shii ne dinne muna phi din ruii phro, jimagunde hanyie shii nyie de oi dang magunde aishii nyie um pha ji de yie muii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Isu ro amuii nane ikhuiithek aishii wuii thog, Jishii ithek è Isu rog shii athog mua gieng, nyieliieshii bran iphiing um. ");
INSERT INTO bgg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bijiu jia è Isu shii yao. “Na amuii nane na khuiithek ne na shii riig yang ne sibiang hà riu ne khan muii ro.” ");
INSERT INTO bgg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Isu è ithek zab shii yao, gu amuii nane gu khuiithek ne ji ro, hanyie è Hamangkhung-aphuii pha miyaogam ji nuii srane rek pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nai jia Isu è awai samoythek rog shii run lakhung hà in srane ithek shii yao, “Cho gethek khabang thrang pha ithua hà wuii sharai haro.” Ji è ithek ne jao ne wuii dun, ");
INSERT INTO bgg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ithek run bucho hà ba shii, Isu ne men dun hamblo shii hasam gashau jia khed thog ruii, chiih-è run ne kho è jao ne ley ramuii, ji è ithek ne zab bajo diig rey dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Samoythek è wuii srane Isu shii chun ne yao, “Masdo, Masdo, gathek ne iy sha pha rek ro!” Isu è sieng srane hasam gashau shii giung mage shii, ithek de chiih them dang dun, chiih-è thiichiih shii liijiing rey dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chiihphado ai è awai samoythek shii yao, “Nathek ro migi ne khiisa lei?” Jishii ithek ne wiengphleg ne rum dun, chiih-è awaithek chung yao rai, “Hì pha bran ne hanyie ga? Ai è hasamkhanoi shii de giung mage ne ithek de aishii nuii dang dun!” ");
INSERT INTO bgg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Isu nane ai samoythek run è in srane khabang thrang Galili pha soh Gerasa hà wuii thog. ");
INSERT INTO bgg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Isu run è khabang ring hà lung shii, ibuii ragung um pha thawun pha bran jia aishii si, nai bajo è ji pha bran ne yung de aguii pha chiih-è hò hà de arai phi, jimagunde ai ne idang wem muang hà rai. ");
INSERT INTO bgg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ai è Isu shii doh mage shii, goh gang è choh srane ai lai shii awailum ne bam srane ziak ne yao, “Hamangkhung-aphuii pha Bajo Giu pha Dufuii Isu!” Na gu è nyie chid pha um lei? Gu na shii khung ne yao phro, gu shii lago aphi rabo ");
INSERT INTO bgg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ai è hì yao pha ji ne nyieliieshii Isu è ibuii ragung shii ai bucho è fuang khia mage bo è giung. Aishii ne ibuii ragung è blebbleb thoh dun, chiih-è ai wad nane lai shii shiirnai rek ne joi srane phatheg hà chab ne ruii magunde ai è shiirnai ji biathiak srane ibuii è balimuang hà noh ne dun marui. ");
INSERT INTO bgg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isu è aishii sai, “Na beng nyie ga?” Ai è chang, gu beng ne 'Mob' \", ro, nyieliieshii bajo ibuii yi aishii khuddun. ");
INSERT INTO bgg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ibuiithek ji è Isu shii khung srane yao gathek shii jam nyahiung bucho hà athoh rabo. ");
INSERT INTO bgg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Thiisa phiingduii moe shii wak brog bajo um iang, ji è gathek shii ne Wakthek iliing shii thoh ge bo è yao ne ibuiithek è Isu shii khung ne yao, chiih ithek shii ai è ji hà thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ithek ji pha bran è khia srane wak brogthek shii khud dun. Zab pha wak brogthek ne phiingduii è buzam ran srane khabang shii wo ne iy dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wak brog shii gayiig rek ne rai pha bran ji è nyie rey pha ji doh srane, ji è ai ne bajarai nane raig shii ran srane jithek pha mua yao mage. ");
INSERT INTO bgg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Branthek è nyie rey pha ji riig wuii dun, chiih-è ithek Isu shii wuii thog mage shii, ibuii fuang khia dun pha bran ji yi khani wie rey srane yung guii ne Isu lai moe shii dug ne rai pha doh, chiih-è ithek ne zab rum dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hanyie ji doh pho è branthek shii yao hì pha bran ne khi-èrek ne wie rey ge ara. ");
INSERT INTO bgg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chiihphado ji pha soh pha branthek è Isu shii thiichiih-è dun bo è yao, nyieliieshii ithek ne bajo sham ne rum dun. Ji-è Isu run hà in ne dun din dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ibuii khia dun pha bran ji è khung ne Isu shii yao, “Gu shii de narog wuii noh bo.” Jishii Isu è yung srane aishii thoh ge, ");
INSERT INTO bgg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Idoh dun srane nawai hò hà Hamangkhung-aphuii è na shii nyie rek phi pha ji yao bo. Ji pha bran è zab pha thawun hà wuii srane, Isu è aishii nyie rek phi pha ji yao. ");
INSERT INTO bgg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Isu khabang ring pha gai ithua shii idoh thog mage ne, branthek aishii wie è ho, nyieliieshii zab ithek ne aishii khan ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chiihphado è Jairus beng pha bran jia de thiichiih wuii thog; ai ne thiisa pha Jewthek misiahò pha dumuii ro. Ai awailum ne buzam Isu lai shii bam srane aishii khung ne ai hò hà wuii bo è yao, ");
INSERT INTO bgg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","nyieliieshii airo idimi dam snanyi rey sha pha ji ne iy pha rek. Isu ai rog shii wuiiramuii shii ai mai pha zab ithua shii bran iphiing khrab thog dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ithek duchoi shii hò-amuii jia yi grab rek ne diig ne rai pha dam snanyi rey sha; ai è awai shii nyie um pha ji zab mahpho shii phi srane wie rey yi pha rek shii, Jishii hanyi è de aishii wie arek mua. ");
INSERT INTO bgg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ai è ibrog shii Isu idoh wuii srane airo rugud jiu shii khoh mage, chiih-è airo grab noi pha ji ne limdang dun. ");
INSERT INTO bgg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Isu è ithek shii sai, “Gu shii hanyie mukhoh lei?” Zab è yao, gathek ne akhoh ro, chiih-è Phithar è yao, hanyie de akhoh ro, “Masdo, bran ibrog zab ne na shii gung ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jishii Isu è yao, “Hanyie lei jia ne gu shii khoh ro, gu ne thieg, blu ne gu è fuang khia dun ro.” ");
INSERT INTO bgg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hò-amuii ji è shii riig shii aishii ne thieg dun, ji è ai ne sham srane wuii ne awailum ne Isu lai shii bam. Ai è nyie rek ne khoh chiih-è khi-èrek ne khthiie wie dun pha ji thiichiih ai ibi shii um phothek moe Isu shii yao. ");
INSERT INTO bgg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Isu è hò-amuii jishii yao, “Gu dimi, nawairo migi è na shii wie rek ge ro, liingsed ne dun bo.” ");
INSERT INTO bgg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Isu ji yao ramuii shii, mua yao pha bran jia dumuii hò è wuii thog. Ai è Jairus shii yao, “Naro dimi ne iy dun ro. Masdo shii dinne muna diig aphi chid rabo.” ");
INSERT INTO bgg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jishii Isu è nuii srane Jairus shii yao, “Arum rabo; migi now bie bo, chiih-è na dimi ne wie rey phro.” ");
INSERT INTO bgg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ai è hò hà wuii thog mage shii, ai è Phithar, Jon, nane James chiih-è ani ro aphuii amuii shii noh ne iliing hà wuii srane gai hanyie shii ai rog shii awuii noh. ");
INSERT INTO bgg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Thiichiih shii um pha branthek è ani chiang shii choh ramuii, Isu è yao, “Achoh rabo, ani ne a-iy ro ai ne men bamuii ro!” ");
INSERT INTO bgg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ithek è aishii siak, nyieliieshii ithek ne thieg ai ne iyjong ro. ");
INSERT INTO bgg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jishii Isu è aishii awai wad shii giak srane ho mage, “Sieng mage bo, gu ani!” ");
INSERT INTO bgg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ai ro chai ne khid din srane thiichiih shii siangfad mage, chiih-è aishii chie pha nyie magunde phi mage bo è yao ne Isu è ithek shii yung. ");
INSERT INTO bgg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ai ro aphuii amuii ne wiengphleg dun, Jishii Isu è nathek shii yung, ithek shii nyie rey pha ji ne hanyie shii de ayao rabo. ");
INSERT INTO bgg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isu è snanyi samoythek shii ò ho srane ithek shii ibuii shii khia pha nane miiriie shii gang phi pha blu nane riichai phi. ");
INSERT INTO bgg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Chiihphado ai è ithek shii Hamangkhung-aphuii pha Sajathua ji yua pha nane radpho shii gang rek pha thoh ge, ");
INSERT INTO bgg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","chiihphado ithek shii yao, “lumuii hà ithek nyie de ayie rabo: Thagieng de ayie, biiathek de ayie, michie de ayie, bang de ayie, chiih-è phadiig lai de ayiedang rabo. ");
INSERT INTO bgg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nathek shii khihà wie ho ruii, ji pha hò shii athoh sapho shii ne ithua jia shii rai bo; ");
INSERT INTO bgg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Khihà magunde branthek è nathek shii wie aho arone, ji pha thawun thoh muii srane nathek lai pha nyiakphlab ji yi kham marui bo, ji ne ithek shii phriie phro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Samoythek è thiichiih shii thoh marui srane thiigthek hà lua ne Mua Wie jithek yao ne zab pha branthek shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod yi Galili shii bohkhoh pha ji ro, jithek rey pha ji zab yoi srane wiengphleg dun, nyieliiene giak branthek è yao Jon Khowo ne idoh hòi ne thog ro. ");
INSERT INTO bgg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gaithek è yao shii Elija ne dinne dong ro, chiih-è gaithek è yao buyo pha chaigthek ne idoh hòi ne thog dinro. ");
INSERT INTO bgg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod è yao, “Jon ro khrug ne gu è tham sbang yi phro; jimagunde hì è yoi ramuii pha bran ji ne hanyie ga?” Chiih-è ai ne Isu shii riig pha bidiang. ");
INSERT INTO bgg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Guaphasamoythek è idoh dun thog srane ithek è nyie rek marui pha ji zab Isu shii yao. Ai è ithek shii awai rog noh srane Bethsaida pha thawun shii wuii thog. ");
INSERT INTO bgg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ibrogthek è ji yoi srane ithek de ai rog shii luagieng. Ai è ithek shii wie ho srane, Hamangkhung-aphuii pha Sajathua ji yao srane hanyie è chid pho shii gang phi. ");
INSERT INTO bgg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hasieng yi jao ne yem sha pha rek shii, airo snanyi Samoythek è aishii wuii srane yao, “Branthek shii thoh ge bo, nyieliieshii ithek ne nyawuii mua ne thiigthek nane raigthek shii shan ne michie nane men pha ithua nya doh mua phro, nyieliieshii hì pha ithua ne hanyie de oi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jishii Isu è ithek shii yao, “Nawaithek è ithek shii chie pha phi bo.” Ithek è chang, “Gathek zab shii ne iweb guii nane ù nyi um bie ro, na è gathek shii hì pha ibrogthek zab pha michie pheg wuii bo è now bey?” ");
INSERT INTO bgg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Thiichiih shii ne itham guii thog pha bran um.) Isu è awai samoythek shii yao, “ithek shii ibrog jia jia shii saguii rek ne dug yi bo.” ");
INSERT INTO bgg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chiihphado shii samoythek è ji è rek phi, ");
INSERT INTO bgg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Isu è iweb guii nane ù nyi shii yi srane, Hamangkhung hà riig ne Hamangkhung-aphuii shii laso phi srane phed, chiih-è awai samoythek shii phi ne branthek shii thang ba yi. ");
INSERT INTO bgg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ithek zab cho pha chie ched mage shii, chiih-è nyie khe pha ji ne samoythek è sirid snanyi chiing. ");
INSERT INTO bgg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nai jia Isu è awai ji siaramuii shii, samoythek aishii wuii thog ruii. Isu è ithek shii sai, “Branthek è gu shii hanyie ro è yao lei?” ");
INSERT INTO bgg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ithek è chang. “Giak branthek è na shii ne Jon Khowo ro è yao.” Giak è na shii ne Elija ro è yao, “Giak è na shii ne buyo pha chaig jia ne hòi ne thog din ro è yao.” ");
INSERT INTO bgg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Isu è ithek shii sai. “Chiihphado nathek ne gu shii hanyie ro è now ga?” Phithar è chang, “Na ne Hamangkhung-aphuii pha Masi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chiihphado Isu è ithek shii phriie ne giung srane yao, hì pha miyao ne hanyie shii de ayaodang rabo. ");
INSERT INTO bgg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ai è de ithek shii yao, “Bran Dufuii ne bajo diig rek srane dukhothek, boh phabithek nane Iphey yua pha masdothek è de snai muii phro. Aishii ne ua muii phro, jimagunde ai ne da-uom pha idoh shii ne hòi din ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chiih-è ai zabithek shii yao, hanyie de gu rog shii wuii pha now arone, ai ne awai shii bia chid phro, chiih-è zab pha inai shii awairo bai ji han srane gu rog shii luagieng bo. ");
INSERT INTO bgg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hanyie è nawai sieng pha ji shii ragia rek pha now arone awairo chai ne san dun phro, jimagunde de hanyie è gu chiang è awai shii san muii arone ai ne ragia rey ruii. ");
INSERT INTO bgg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ai è sohjambling shii mua srane awai shii san muii arone nyie phua mage phlei? Khuchung magunde arey phro. ");
INSERT INTO bgg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bran hanyie yi gu shii wo srane gu miyao wo arone, Bran Dufuii de awairo biisiie è wuii ruii shii chiih-è Aphuii pha biisiie nane so hamangkhliiethek pha boh lubo è wuii ruii shii aishii de wo ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gu nathek shii izai yaodang phro, ichiih um pha giak branthek de Hamangkhung-aphuii pha Sajathua ji adoh sapho shii ne a-iy ba phro. ");
INSERT INTO bgg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Damiley pha idoh shii ai è jithek yao, Isu è Phithar, nane Jon, chiih-è Jems shii ai è noh srane phiingduii lakhung hà sia pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ai yi siaramuii shii, ai mizia ne yoh lai khlei dun, chiih-è airo yung de khlieng mo chuang dun. ");
INSERT INTO bgg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hamblo shii bran nyi yi ai rog shii mulo pha doh. Ai ne Moses nane Elija ro. ");
INSERT INTO bgg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hamangkhung pha biisiie è doh yi srane ai ne Jerusalem hà iy ne Hamangkhung-aphuii ro munow ji zab rek pha Isu shii muloramuii. ");
INSERT INTO bgg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phithar nane ai ijakthek yi men dun jimagunde ithek siangfad srane Isu shii riig shii biisiie nane bran nyi yi ai rog shii riu ne um pha doh. ");
INSERT INTO bgg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bran nyi ji è Isu shii thoh marui ne dun din dun shii, Phithar è aishii yao, “Masdo, Gethek ichiih shii um pha ji ne khama wie ro, gethek ne ichiih shii haliig thek uom rab pha ro, jia yi na shii, jia yi Moses shii, chiih-è jia yi Elija shii.” (Ai è de ji yi izai athieg mua ai è nyie yao pha ji ne.) ");
INSERT INTO bgg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ai ji è yao ramuii shii, sakhamiing thab srane ithek ragia rog shii chiieg muii; chiih-è sakhamiing è aishii thab mage ne airo samoythek ne rum dun. ");
INSERT INTO bgg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Goh jia yi sakhamiing è yao ruii, “Hì ne guro Dufuii ro, gu mugua ne ruii ro, ji è aishii nuii bo!” ");
INSERT INTO bgg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Goh ji aro pha rey dun shii, thiisa hà Isu awai ji jia um bie. Samoythek è jithek zab aro pha rai muii srane, chiih-è ji pha ishak shii ithek è nyie doh pha ji hanyie shii de ayao. ");
INSERT INTO bgg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ji pha thimiang ne Isu nane airo samoy uom yi phiing lakhung è thazam wuii thog shii, bran boh ibrogthek è Isu nane ithek shii si. ");
INSERT INTO bgg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bran jia yi ibrog è ziak mage, “Masdo! Gu na shii khung dang phro, gu dufuii shii riig mage bo guro dufuii ji jia bie ro!” ");
INSERT INTO bgg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ibuii ragung è aishii khud srane hamblo shii ziak ne awailum ne chiih srane chiihphado sem è imamiung khia; aishii ne bajo duhug phi ne ruii srane diig yi. ");
INSERT INTO bgg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Gu è na samoythek shii khia phi bo è khung ne yao shii, jishii ithek è ne akhia mua phi ro. ");
INSERT INTO bgg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Isu è chang, “Nathek ne migi arek pho nane ichiig pha branthek ara! Gu nathek rog shii khama rai dam mage phlei?” Gu khama chiieng nathek shii zud dam phi phlei? Jishii ai è bran jishii yao, “Na dufuii shii tha hà yie mage bo.” ");
INSERT INTO bgg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bufuii ji yi wuii mage shii, ibuii è aishii jog thoh srane aishii ne nyiak lakhung hà thud pha yi. Isu è ibuii ragung shii giung mage shii, ji pha bufuii ne gang rey dun, chiih-è ai aphuii shii idoh phi din muii. ");
INSERT INTO bgg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Zab pha branthek Hamangkhung-aphuii pha gang blu ji riig srane wiengphleg dun. Awai samoythek shii yao, branthek è Isu mirek pha jithek zab riig srane wiengphleg bamuii ro. ");
INSERT INTO bgg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Gu è nathek shii nyie yao pha rek pha ji ne abia rabo! Bran Dufuii shii ne bran blu shii phi muii ro. ");
INSERT INTO bgg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jishii samoythek è ji pha miyao ne agao mua, hì pha miyao yi ithek agao yi pha ithek è ug muii, chiih-è ithek ne rum srane hì pha miyao chiang asai mua. ");
INSERT INTO bgg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hanyie yi zab è boh ga è sai ne samoythek awaithek chung khnaing rai. ");
INSERT INTO bgg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Isu è ithek nyie now pha ji ne thieg srane, ji è ai è ani jia yi srane awai moe shii riu ba yi, ");
INSERT INTO bgg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Chiih-è ithek shii yao, “Hanyie magunde hì pha ani shii gu beng è wie ho arone, ai gu shii de wie ho phro, chiih-è hanyie è gu shii wie ho arone, gu shii thoh ge pha ji shii de wie ho ro. Ji è nathek duchoi shii hanyie ai yi zab ìu ga ai ne zab è boh ro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon è Isu shii yao, “Masdo, gathek è bran de na beng è ibuiithek khiaramuii pha doh ro, chiih-è gathek è arek rabo è gak marui, nyieliieshii ai ne gethek rog pha bran asi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Aishii gak pha abidiang rabo,” Isu è Jon nane gai samoythek shii de yao, “Nyieliieshii hanyie è na shii gidieg arek pho ne nathek bran ro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Isu shii hamangkhung hà noh sha pha nui thog mage shii, Jerusalem hà wuii dang pha awai khani shii phak. ");
INSERT INTO bgg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ai è muaphothek shii awai ibi shii thoh srane Samaria thiig hà wuii ne zab khriig rek yi. ");
INSERT INTO bgg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jishii thiisa pha branthek è aishii wie aho, nyieliieshii ithek ne thieg ai ne Jerusalem hà wuii bie. ");
INSERT INTO bgg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Airo samoythek Jems nane Jon è ji riig srane, ithek è yao, “Ithong, na ne ichid bey Hamangkhung è bai shii ho srane ithek shii hùb yi mage habey?” ");
INSERT INTO bgg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Isu è idoh rei srane ithek shii giung. ");
INSERT INTO bgg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chiihphado Isu nane samoythek gai thiig hà wuii marui. ");
INSERT INTO bgg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ithek yi awaithek lumuii hà luaramuii shii, bran jia è Isu shii yao, “Na khi hà lua magunde gu narog shii lua gieng pha ro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isu è aishii yao, “Shaliiethek de icho um, chiih-è fuiithek shii de irungthek um, jimagunde Bran Dufuii shii ne thieng ne thung pha ithua de oi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Isu è gai bran jishii yao, “Gu rog shii luagieng bo,” jimagunde ji pha bran è yao. “Masdo, igobi gu shii hò hà idoh dun yi ne gu aphuii shii wieng bi yi bo.” ");
INSERT INTO bgg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Isu è chang, “Iy-iy shii awai iy-iy è wieng yi bo. Na ne wuii srane Hamangkhung-aphuii ro Sajathua ji yua bi bo.” ");
INSERT INTO bgg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bran jia è de Isu shii yao, “Gu de nathek rog shii luagieng pha ro, Masdo; jimagunde igobi gu shii hò hà gui haliing pho shii de wie rai bo è yao pha thoh ge bo.” ");
INSERT INTO bgg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Isu è aishii yao, “Hanyie magunde raig woi pha jakhokh shii wad kho srane idoh hà rai ne riig pho ne Hamangkhung-aphuii pha Sajathua jishii gu ne chid phro.” ");
INSERT INTO bgg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jithek pha idoh shii Ithong è bran samiley nyi shii gua srane bijiu nyi nyi rek ne ai ibi shii awai wuii pha rek pha thawun nane ithua shii thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ai è ithek shii yao, yamiing ne bajo um ro, jishii khrab pha brapho ne ìujia bie ro. Ji-è yamiing khrab pha thoh ge bo è yamiing pha muspho shii sia mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wuii mage bo, gu ne nathek shii shiishaithek duiine shaluiithek duchoi shii thoh ge phro. ");
INSERT INTO bgg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Chiih-è nathek bang chab pha biia, chiih-è chayem pha buii, chiih-è lakhia de ayie rabo, chiih-è lumuii hà hanyie shii magunde wad khung ne yao pha athung rabo. ");
INSERT INTO bgg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Khuchung magungde ithek hò jia shii khud dun arone igobi shii ji pha hò shii ne liijiing um bo è yao bi bo. ");
INSERT INTO bgg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chiih-è thiisa liijiing um pha bran murai arone nathek liijiing khung ne phi pha ji ai rog shii rai dun phro; ji oi arone nathek shii gu miphi pha liijiing ji idoh yie din bo. ");
INSERT INTO bgg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chiih-è nathek ji pha hò shii rai bo, chiih-è ithek è nathek shii nyie phi pha ji chie ne niing ne rai bo, nyieliiene blia rek pho shii ne awai blia pha riinang phi ruii phro. Hò hò lai ne alua rabo. ");
INSERT INTO bgg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chiih-è khuchung magunde ithek bajarai jia hà wuii dun shii ithek è nathek shii wie ho ne nyie phi pha ji chie mage bo, ");
INSERT INTO bgg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ji pha rajan hà rad pho shii gang phi bo, chiih-è thiisa pha branthek shii yao bo; Hamangkhung-aphuii pha Sajathua pha ishak ne nathek shii nui thog sha ruii ro. ");
INSERT INTO bgg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Khuchung magunde bajarai jia hà wuii thog shii nathek shii wie aho arone nathek ne lumuii hà khia srane yao mage bo, ");
INSERT INTO bgg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Chiih-è nawaithek bajarai pha nyiakphlab nathek lai shii mieg ne kham pha ji de nawaithek shii mak rek phro, Jishii nowbthan mage bo Hamangkhung-aphuii Sajathua pha ne ithek moe thog sha ruii ro! ");
INSERT INTO bgg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gu nathek shii yao, chua pha inai shii ne Hamangkhung-aphuii bushun ne ji pha thawun è wie ne Sodom pha thiig shii bajo rek phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Khorazin nane Bethsaida! Hì è rek pha hì ne nathek shii khama duhug rey dun phro, ithek shii rek phi pha buangthek ne Thaire nane Sidon hà rek phi arone ithek khuchung mujo thulo yung guii srane siphie shun ne awaithek layog è thadoh khidjong ro è doh yijong iwa. ");
INSERT INTO bgg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chua pha inai shii Hamangkhung-aphuii è ne ithek è de huak pha bushun ne Thaire nane Sidon shii phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Chiih-è Khaphernaum pho nathek, nathek ne Hamangkhung hà chiing yi pha now ne bey? Nathek ne thumluii hà fen muii phro! ");
INSERT INTO bgg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Isu è awai samoythek shii yao, hanyie è ithek shii nuii pho ne, gu shii de nuii, hanyie è ithek shii snai arone gu shii de snai phro, chiih-è hanyie è gu shii snai arone gu shii thoh ge pha ji shii snai phro. ");
INSERT INTO bgg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Samiley è nyi jithek yi bajo lubo srane idoh dun thog. “Chiih-è ithek è Ithong shii yao, ibuiithek de na beng è yung mage shii nuii dang dun!” ");
INSERT INTO bgg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Isu è ithek shii chang, “Sakhathong ne hamangkhung è haliao duiine bliak ne chiih pha doh muii ro. ");
INSERT INTO bgg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yoi mage bo, gu è nathek shii riichai phi ro, ji è ithek phamthek, nane ragungphiethek lakhung shii de nyalua mua phro, chiih-è shuang pha bluthek è de nyayang mua phro, chiih-è ithek shii nyie è achun phro. ");
INSERT INTO bgg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jishii ibuii ragungthek è ithek miyao nuii rone asang chid rabo; ithek beng hamangkhung pha siog hà zey ne um rone jishii sang bo.” ");
INSERT INTO bgg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ji pha ishak shii Isu yi Ragung So è ley srane lubo ne yao, Aphuii, Ithong hamangkhung nane sohnyiak pha! Gu na shii laso phi, nyieliieshii na è khani pho nane ìd pho è ug ne ruii pha ji ne adab pho shii phi. Aphuii, hì ne na è nyie khi-èrek chid pha ji rey ro. ");
INSERT INTO bgg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Gu Aphuii è zab manathek gu shii phijong ro. Chiih-è Dufuii shii hanyie de athieg ro Aphuii mithieg bie ro, chiih-è Aphuii shii de hanyie de athieg Dufuii mithieg bie ro, chiih-è ai è hanyie shii dong phi pha ne Dufuii è gua ne ruii.” ");
INSERT INTO bgg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chiihphado Isu è idoh rei srane samoythek shii ug ne yao, “Nathek hì pha muna riig ramuii pha hì ne nathek shii ne khama pha khirzey um ro! ");
INSERT INTO bgg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gu nathek shii yao phro chaigthek nane sajathek de nathek è doh pha ji ithek de riig yang jishii ithek ne ariig mua, chiih-è nathek nyie yoi pha ji ne ithek de yoi yang pha now ne de ithek ayoi mua.” ");
INSERT INTO bgg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iphey yao pha masdo jia wuii srane Isu shii ichiig sow pha bidiang. Ai è sai, “Masdo,” “Gu idang pha chai mua pha nyie rek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Isu è aishii chang, “Jigigam shii nyie ro è yao lei? Chiih-è na ithek shii khi-èrek ne yua ne yao phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ji pha bran è chang, “Hamangkhung-aphuii Ithong shii lubu è miie bo, chiih-è zab nawai ragung è, chiih-è zab pha nawai chua è, chiih-è zab pha nawai khani è; chiih-è ‘nawai shii miie rek pha duiine na hadung-haluii pho shii de miie rek bo.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isu è ji pha bran jishii chang; “Na ne izai chak ro,” chiih-è “Na de ji duiine rek arone na ne sieng ne rai phro.” ");
INSERT INTO bgg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jishii Iphey yao pha masdo a-ìd pha duiine rek srane, Isu shii sai, “Gu hadung-haluii pho hanyie lei?” ");
INSERT INTO bgg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isu è chang, luang jia bran jia yi Jerusalem è buzam Jerikho hà wuiiramuii shii mugo pho è aishii zum srane ai manathek zab pha riao srane ikhlen rek ne iytho dang pha zuang ne thoh marui. ");
INSERT INTO bgg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ji-è rek pha ishak shii phabi de ji pha lumuii è luaramuii; jimagunde ai è ji pha bran shii doh mage ne, ai è ai moe pha yoh lumuii è lua marui. ");
INSERT INTO bgg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ji duiine lewi jia de ji pha lumuii è luaramuii shii ji pha bran shii riig srane, chiih-è yoh pha ithua è lua marui. ");
INSERT INTO bgg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Jishii Samarithan jia de ji pha lumuii è lua ne ji pha bran moe shii wuii thog, chiih-è ai è aishii riig mage shii, ai lubu ne bushun now dun. ");
INSERT INTO bgg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ai è ji pha bran shii wuii srane thiiliie nane phuii è airo saduii shii shun srane yung rek ne jiang phi; chiihphado è ji pha bran shii awai bambao lakhung hà gow srane thung pha hò hà noh ne, aishii ragia rek phi. ");
INSERT INTO bgg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Din pha inai shii ji pha bran è liiman pha simed nyi yie srane hò khan pha bran jishii phi marui srane yao. Aishii wie khagi rek bo ai è hò khan pha ji shii yao, chiih-è gu idoh hì pha lumuii hà de ruii shii, na è aishii khama pha phi pha ji gu na shii idoh phi din pha ro. ");
INSERT INTO bgg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Idohhè shii Isu è sai, “Na miigao è, ithek uom è hanyie yi mugo bran è zum ne ua mua pha airo hadung-haluii pho duiine hanyie munong phi lei?” ");
INSERT INTO bgg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iphey yao pha masdo è chang, “hanyie è aishii bushun rek phi pha ji ro.” Isu è chang, “Chiihphado, na de, ji duiine rek bo.” ");
INSERT INTO bgg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Isu nane awai samoythek awaithek lumuii è lua ne ji pha thiig hà thog shii, hò-amuii Martha beng pha bimi ji è aishii hò hà wieho. ");
INSERT INTO bgg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aishii de Mery beng pha bumuii jia um, hanyie Ithong lai luii shii dug ne miyao nuii pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha yi airo blia rek ba pha um pha ji è bajo diig now srane, ai è wuii thog srane yao, “Ithong na ne agayiig bey gu bumuii è zab pha blia ne gu rek bo ne ruii muii ro? Aishii yao ne gu rog shii nong gieng yi bo!” ");
INSERT INTO bgg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ithong è aishii chang, “Martha, Martha! Na ne bajo shii monowthiig ne diig now ara ro, ");
INSERT INTO bgg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jishii jia hì ne mugak ro, Mery ne awairo zab è izai ji guajong ro, chiih-è hì ne ai ji è hanyie de ariao mua phro.” ");
INSERT INTO bgg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nai jia Isu yi ithua jia shii misia sia. Ai misia sia ched shii, samoy jia è aishii yao, “Ithong, Jon è awai samoythek shii yua pha duiine, gathek shii de misia sia pha yua bo.” ");
INSERT INTO bgg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isu è ithek shii yao, khuchung magunde nathek sia arone yao bo, Aphuii: Naro so ibeng ne ilab rey bo, chiih-è naro Sajathua ne thog bo. ");
INSERT INTO bgg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gathek shii chid pha michie inai tham ne phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gathek layog shii khung phi bo, gathek de ithek asi pha rek pha ji shii khung phi ro. Chiih-è gathek shii nang chua pha aphi rabo. ");
INSERT INTO bgg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Isu awai samoythek shii yao, yangne nathek hanyie magunde jia è habiu duchoi hà wuii srane nawai ijak shii yao, gu ijak, iweb uom chei phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gu ro ijak jia thiih shii gu hò hà wuii thog ro, chiih-è aishii chie yi pha gu shii ne nyie de oi ro! ");
INSERT INTO bgg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chiih-è yang ne na ijak è hò iliing è chang mage, gu shii afak-afi arek rabo! Gu ro hò ne binjong muii ro, chiih-è gu ro ani nane gu ne biang hà sha ro. Gu asieng mua sha phro chiih-è gu na shii nyie de aphi mua phro, ");
INSERT INTO bgg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wie, nyie chiihphado? Gu na shii yao na ijak sieng ne na shii iweb aphi magunde na è awo dang pha lia ne rai arone, ji è ai sieng srane na nyie chid pha ji nyaphi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chiih-è gu nathek shii yao: lia bo, ji arone na mua ruii phro; sow bo ji arone doh ruii phro; habin shii chokh bo ji arone na shii hong ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chiih-è hanyie è lia jishii ne phi ruii phro, chiih-è hanyie è sow ji pha bran shii ne doh ruii phro; chok bo, chiih-è habin na shii hong phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Dufuii è ù lia shii pham phi pha aphuii ne nathek è hanyie ga? ");
INSERT INTO bgg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Chiih-è ai kheri lia shii ragungphie phi ne bey? ");
INSERT INTO bgg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nathek awie pho rang de, nawaithek ani shii nyie khi-èrek wie phi chid phro è thieg. Aishii lia pho ne Hamangkhung Aphuii è ji è de muna Ragung So phi ruii phro! ");
INSERT INTO bgg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isu è miyao ayao mua pha ibuii shii gieng; Chiihphado è ibuii fuang hà khia mage shii, ji pha bran ne jao ne yao mua. Ji-è thiichiih pha bran ibrogthek de wiengphleg dun, ");
INSERT INTO bgg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jishii thiichiih pha giak branthek è yao, “Hì ne Sakhathong ara, ai ne ibuii pha dumuii ara, hanyie è aishii blu phi ne gieng yi pha ji ara.” ");
INSERT INTO bgg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Giak è Isu shii ichiig sow pha now, ji è hì thek ne Hamangkhung-aphuii è rey pha blia chak rone gathek shii wiengphleg pha khagi rek bo. ");
INSERT INTO bgg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jishii Isu è ithek nyie now pha ji thieg srane, ai è ithek shii yao, hanyie soh shii ibrog yoh che rai ne gidieg rek arone ji pha thiig ne idang rey ne arai mua phro; chiih-è haliing chung mak rek rai arone ji de yoh rey dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ji-è ibuii awaithek chung zab riichai shii ibrog rek ne gui rai arone, nyie khi-èrek ne hì rai mua phlei? Nathek ne yao, gu è ibuii khia pha hì ne Sakhathong è gu shii blu phi ne ji mikhia ro è yao. ");
INSERT INTO bgg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chiihphado gu ibuii shii fuang hà ji è rek ne gieng arone, nathek samoy pho yi khi-èrek ne gieng phlei? Chiih-è nawai samoy pho è hì asi ro è nya doh yi ro! ");
INSERT INTO bgg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Asi gu è Hamangkhung-aphuii blu è ibuii shii gieng shii, hì è ne nathek shii doh yi phro Hamangkhung-aphuii Sajathua ne ithek shii wuiijong ro. ");
INSERT INTO bgg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Bran bgang jia yi, awai rog shii migiang khriig rek srane, awai hò khan ne rai arone, ai hò shii nyie um pha ji ragia rey phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jishii ai è muna bran biigang jia è aishii mak jo srane ai è yang mua arone, muspho è luthong muii pha migiang jithek ne ai è zab han srane awaithek chung ai è nyie goh pha ji thang rai phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hanyie magunde gu rog shii asi pho ne izai gu shii gidieg rek ara ro; chiih-è hanyie yi gu rog shii nong ne akhrab gieng arone ai ne izai dayiingdayang rek ara. ");
INSERT INTO bgg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Khuchung magungde ibuii ragung yi bran è fuang khia srane, igoh soh lakhung shii lua srane thung pha ithua so. Jishii jia de adoh sha arone. Awai è awai shii yao, ‘Gu ne gui hò hà idoh dun din sha pha ro.’ ");
INSERT INTO bgg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ji-è ai idoh dun srane riig shii hò ne so nane khriig um iang. ");
INSERT INTO bgg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chiihphado ai ne fuang hà wuii srane dinne yoh miley awai è de awiedang pha ragung noh ruii, chiih-è ithek ji hà dun srane rai gieng. Ji è jithek rek ched ne, ji pha bran ne igobi è de lahuak awie pha rey dun.” ");
INSERT INTO bgg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Isu è jithek yao ramuii shii, bran iphiing iliing è hò-amuii jia è aishii yao, “na shii giak ne na shii ram pha hò-amuii ne bajo khirzey ro!” ");
INSERT INTO bgg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jishii Isu è chang, “Ji-è ne, hanyie è Hamangkhung-aphuii miyaogam yoi ne nuii pho ne khama sang ro!” ");
INSERT INTO bgg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bran brog yi Isu moe khrab ramuii shii, ai è yao, duchung pha branthek ne bajo awiedang ara! Jona ne ithek ne buang pha blia nak ne rai. Jishii Jona ro buang pha blia ji doh bie yi ne gai ne ithek shii adoh yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ji duiine chaig Jona ne Ninewe pha cheb ro, ji è Bran Dufuii ne duchung pha branthek ro cheb ro. ");
INSERT INTO bgg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Chiih-è chua pha inai shii sajamuii Sheba è riu ne ithek shii nin ruii phro, nyieliieshii ai ne Saja Solomon ro muyua wie ji nuii awai soh pha zab lumuii è wuii phro; ji è gu ithek shii yao ichiih shii ne nyie magunde um pha ji ne Solomon è de boh um ba ro. ");
INSERT INTO bgg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Che pha idoh shii ne Ninewe pha branthek è riu ne ithek shii the ruii phro, nyieliieshii ithek ne Jona muyua ji nuii srane awaithek layog è khidjong ro: Chiih-è gu ithek shii yao ichiih shii ne nyie magunde um pha ji ne Jona è de boh um ba ro! ");
INSERT INTO bgg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Khuchung magungde muchuang yi siikhiiakhjam bucho hà chab ne ug srane aruii; ji pha chiang shii muchuang ne bunthruak lakhung shii ruii ro, nyieliieshii hacho wuii pha branthek shii sang doh yi chid. ");
INSERT INTO bgg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nathek mieg yi siu pha muchuang duiine ro. Nathek mieg yi sang doh shii, nathek siu shii de ley muchuang um ro; jimagunde nathek mieg yi awie arone, nathek siu de zab igiia ro. ");
INSERT INTO bgg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chiihphado khriig rab bo, nathek shii um pha muchuang ji igiia arey yi rabo! ");
INSERT INTO bgg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nathek siu shii muchuang ley um arone, nathek ne igiia rog oi sha phro, ji è zab sang rey dun, muchuang yi na lakhung shii khilieng mage shii na shii de chuang dun. ");
INSERT INTO bgg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Isu ji è yao ched dang shii, Pharisithek è aishii ithek rog shii michie chie pha ho; ji è ai ne iliing hà wuii srane michie chie pha dug. ");
INSERT INTO bgg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisithek è Isu ne wad achun pha michie chie pha ji riig ne wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ji-è Ithong è ithek shii yao, chiihphado, duchung pha Pharisithek nathek ne gog nane shiikhiia shii ne fuang è wie shud bie ara, jimagunde nathek ne iliing shii ne ley awie pha nane lijieg um ro. ");
INSERT INTO bgg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bi-ìethek! Hamangkhung-aphuii è fuang shii rab bie ne iliing shii arab bey? ");
INSERT INTO bgg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jishii nathek ro shiikhiia nane gog shii nyie um pha ji ne dushothek shii phi bo, chiih-è nathek shii zab so rey phro. ");
INSERT INTO bgg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pharisithek nathek ne khama diig phro! Nathek ne marey pha ishak shii, buzo nane phadina ne jia sua Hamangkhung-aphuii shii phi, jishii nathek ne izai nane Hamangkhung-aphuii shii miie rek pha jithek shii ne snai muii. Gai shii asnai pha, hì ne nathek dab bo. ");
INSERT INTO bgg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pharisithek nathek ne khama diig phro! Nathek ne Jewthek misiahò hà de ithua wie shii ong ne bajarai hà de ithek shii wad khung ne ilab phi bo è now.” ");
INSERT INTO bgg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nathek shii ne khama diig phro! Nathek ne branthek cheb arek ba pha hanyie è athieg wieng lakhung shii lua pha duiine ro. ");
INSERT INTO bgg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ji-è yao ramuii shii Iphey yao pha masdo jia è Isu shii yao, “Masdo, na nyie yao pha ji ne, na ne gathek shii makhakriing ara!” ");
INSERT INTO bgg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Isu è chang, Iphey yao pho nathek shii de khama diig phro! Nyieliieshii nathek ne branthek phadung shii ithek è ahan mua pha miihan han yi, jishii nawaithek ne ragia rek gieng pha ji pha mahan shii wad rang de akhoh gieng. ");
INSERT INTO bgg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nathek shii de khama diig phro! Nyieliieshii nathek è nawaithek riing mu-ua pha chaigthek shii ne wieng de bajo wie rab phi. ");
INSERT INTO bgg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nawaithek ne thieg, nathek riing è nyie suruii rek pha ji de nathek è khriig now, nathek è chaigthek shii ua muii chiih-è nathek è ithek ro wieng rab phi. ");
INSERT INTO bgg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hì pha chiang è Hamangkhung-aphuii khani è yao, Gu chaigthek nane muaphothek shii thoh ge, ithek è giak shii ua srane, chiih-è giak shii diigchiao phi. ");
INSERT INTO bgg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sohjambling rab dang pha ishak è yie ne chaigthek shii ua pha chiang è duchung pha bran nathek shii lago phi ruii phro, ");
INSERT INTO bgg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel shii ua pha ji è yi ne sraibao nane So Ithua pha duchoi shii ua muii pha Zekharia ishak thog dang pha. Gu nathek shii yao, nathek chiang ne duchung pha bran nathek lago phi pha ro! ");
INSERT INTO bgg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Iphey yao pho nathek ne khama diig phro! Nathek ne khani hò pha habin hong pha ziu ne yie ne ruii; chiih-è nawaithek de iliing hà ne awuii, chiih-è ithek ne gai iliing hà wuii pha bidiang pho shii de gak muii. ");
INSERT INTO bgg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Isu è ji pha ithua thoh marui srane dun shii, Iphey yao pha masdo nane Pharisithek è aishii bajo awie dang pha rek srane, bajo manathek pha miyao sai. ");
INSERT INTO bgg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ai ne suruii yao gua ino ne ithek è ichiig sow ne aishii zum pha bidiang. ");
INSERT INTO bgg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Itham bran yi òjia shii khrab thog mage shii, ithek ne awaithek chung thum rai dun. Jishii igobi Isu è awai samoy shii yao, Pharisithek ro awie pha muphak ji è nawaithek shii ragia rek bo, gu è yao pha miyao jine ithek ro lubo siie ro. ");
INSERT INTO bgg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nyie magunde cheg ne ruii pha ji ne acheg mua phro, chiih-è nyie magunde ug ne ruii pha ji ne thieg dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chiihphado, nyie magunde na è igiia hà yao ji ne isang moe hà yoi dun phro, chiih-è nyie magunde na è ùgud bin srane ji hà suak ne yao magunde hò lakhung pha zak hà ziak dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Gu ijakthek, gu nathek shii yao, hanyie è na siu shii ua bie pha ji shii ne arum rabo jimagunde dinne nyie de buii arek mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gu nathek shii riig yi hanyie shii rum chid: ua pha idoh, hanyie, shii thumluii hà fen pha blu um pha, Hamangkhung-aphuii shii rum bo. Gu shii migi now bo, nathek rum chid pha ne ai jia ro! ");
INSERT INTO bgg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Adili nyi shii fuiisrai guii aliu bey? Thiih rang de Hamangkhung-aphuii è fuiisrai jia shii ableng ba ro.” ");
INSERT INTO bgg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nathek khrug pha khaziang rang de zab tham ne ruii phro, ji è nathek ne arum chid rabo. Nathek ne fuii è de bajo igong ro! ");
INSERT INTO bgg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gu ithek shii ji yao hanyie magunde bran moe shii yaodang arone ai ne gu rog è chak ara, ji duiine Bran Dufuii de aishii Hamangkhung-aphuii hamangkhliie moe shii è rek phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jishii hanyie è branthek moe shii gu shii snai arone, Bran Dufuii è de Hamangkhung-aphuii hamangkhliie moe shii aishii de snai ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Hanyie jia è de Bran Dufuii shii buii miyaogam yao magunde nya khung phi phro; jimagunde hanyie è Ragung So shii buii yao arone, khuchung de akhung phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Khuchung magungde ithek è nathek shii Jewthek misiahò hà nane bohkhoh pha badri, hà noh pha bidiang magunde, nawaithek shii ragia khi-èrek chid chiih-è nathek nyie yao chid pha ji ne munow adiig chid rabo. ");
INSERT INTO bgg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ji è rek pha ishak shii nathek nyie yao chid pha ji ne Ragung So è nyayua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bran jia yi ibrog iliing è Isu shii yao, “Masdo” Gu khuii shii yao ne aphuii mutho marui pha nuruii ji gu shii thang sha noh bo. ");
INSERT INTO bgg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Isu è aishii chang, “Gu ijak, na sa duchoi shii nuruii thang pha chiih-è che phi pha rangsua ne gu shii hanyie miphi lei?” ");
INSERT INTO bgg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chiih-è ai zab thek shii yao, nowbthan ne zab pha giichak pha ji è nawaithek shii ragia rek bo; nyieliieshii bran ro izai chai ne awai mana nane bukho è arab ro. Ai khama pha bukho magunde nyie achun phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chiihphado Isu ji pha najang è shan ne yao: Luang jia bukho bran jia ro soh shii wie iwoi rey. ");
INSERT INTO bgg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ai jao ne awailum ne now, gu shii ne iwoithek ruii pha ithua de oi, ji è gu ne nyie rek sha? ");
INSERT INTO bgg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hì ne gu nyie rek sha; ai è awai shii yao, gu ne thazan yi chuak ne boh jia rung din srane, garo nying nane zab pha mana yi jishii chab ne ruii chid. ");
INSERT INTO bgg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chiihphado gu ne gui shii yao, khirzey bran! Na shii ne idam bajo thog pha nyie chid pha de zab mana na shii um, ji è nane bajo idam liijiing è sieng ne, chie ne, niing ne, lubo rek phro! ");
INSERT INTO bgg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Jishii Hamangkhung-aphuii è aishii yao, na ne bi-ìe ro! Hì pha habiu shii na ne nawai sieng pha ji ne thoh chid phro; ji è na è nawai shii ruii pha mana hì thek ne hanyie mua phlei? ");
INSERT INTO bgg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chiihphado Isu è yao, “Ji duiine ji pha bran de awai shii bajo bukho rab ne ruii jishii Hamangkhung-aphuii mieg moe hà ne bukho asi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chiihphado Isu è awai samoythek shii yao, chiih-è gu nathek shii yao nathek sieng ne rai pha michie chid pha chiih-è nathek siu shii guii pha yungthek shii sam diig anow chid rabo. ");
INSERT INTO bgg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Chai ne michie re-è de bajo mugak ba ro, chiih-è siu ne yung è de bajo mugak ba ro. ");
INSERT INTO bgg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Amiiethek shii riig mage bo: Ithek ne iriiethek de ahai chiih-è yamiing de akhrab; ithek shii chab ne ruii pha ùgud nane thazan de oi; jishii Hamangkhung-aphuii è ithek shii phi! Nathek ne fuii è de bajo mugak ba ro! ");
INSERT INTO bgg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ji è nathek ne hì thek samdiig srane nawai sieng pha phiang nyarek mua ne bey! ");
INSERT INTO bgg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nathek ne ididuii shii rang de khriig arek mua shii, nyie um ne nathek gai muna shii sam diig phlei? ");
INSERT INTO bgg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Riig mage bo nyie khi-èrek ne jabiing pha ibuathek rang sieng khlei: ithek ne blia de arek chiih-è awaithek ro yung de arab. Ji-è gu nathek shii yao saja Solomon ro khama pha nuruii pha yung khie um magunde jishii ibuathek nyama khie oi ro. ");
INSERT INTO bgg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hì ne saing shii yung guii phi pha Hamangkuhng-aphuii ro hì pha saing ne sudoh ichiih shii um chiih-è thimiang ne shong ne, siphie bai hà fu muii. Ji-è ai ne ithek zab shii ai è de lahuak ne yung aguii phi habey? Nathek shii ne migi ìu um bie ara. ");
INSERT INTO bgg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ji-è nathek ne idang ne nyie chie nyie niing pha jithek shii sam adiig chid rabo. ");
INSERT INTO bgg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Ichiih sohjambling phothek Hamangkhung-aphuii shii athieg pho ne hì pha mana shii munowthiig.) Nathek aphuii ne nathek hì è chid phro è thieg phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ji phachiang è, airo Sajathua pha ji shii sam diig now bo, chiih-è ai ne na shii jithek phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Arum chid rabo, guro ìu ibrog, nathek Aphuii è nyu ne Sajathua ne nathek shii phi ro. ");
INSERT INTO bgg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nathek shii nuruii um pha ji zab liu srane ji pha bang yi dusho shii phi bo. Khuchung magunde amua pha nuruii baneb jia nawai shii khriig rab ne ruii bo, chiih-è naro nuruii ne Hamangkhung hà khrab ne ruii bo, thiisa hà nathek è de ìu arek phro, nyieliieshii mugo phothek de ayie mua phro, chiih-è dakhyem è de awie pha arek mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Khi hà nathek ro nuruii um lei ne nathek ro lubu de idang ji hà um phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Hanyie magunde wuii ruii shii blia rek pha yung guii ne chiih-è naro ichuangthek chuang ne ruii bo. ");
INSERT INTO bgg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Khiao duiine awai ithong shii phi pha michie è khuchung idoh dun ruii pha ji khan ne habin chokh ruii shii wuii srane khthiie habin hong phi. ");
INSERT INTO bgg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Khinyama sang phro ithek shii Ithong è idoh dun ne riig shii khiao ithek ne khriig sieng ne rek iang pha doh yi ne! Gu ithek shii yao, ai è awai shungkho than srane ithek shii dug yi pha yao phro, chiih-è ithek shii chie yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Habiu pha duchoi magunde chiih-è idoh hà dun magunde khriig rek iang pha doh arone khama sang phro! ");
INSERT INTO bgg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chiih-è nathek hì de khriig thieg bo, mugo pho khuchung wuii ruii pha ishak ji yi hò muspho è thieg arone, ai ne mugo pho shii awai hò amua yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chiih-è ithek, wie, è saro iang bo, nyieliieshii ithek è aishii aluthong pha ishak shii Bran Dufuii ne wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phithar è sai, “Ithong, hì pha najang yi gathek shii thoh ne yao ne ba, chiih-è zab shii yao ne bey?” ");
INSERT INTO bgg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ithong è chang, chiihphado, hanyie, yi wie nane izai khiao ga? Ai ne chiihphado awai ithong è aishii dumuii rek ne, hò gayiig pha chiih-è gai khiao ithek chiang pha michie khriig ishak shii dong phi. ");
INSERT INTO bgg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ithong hò hà dun thog ne riig shii ji duiine rek iang pha doh arone ji pha khiao shii ne bajo sang ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ji-è, gu nathek shii yao, ji è rek pha khiao shii ne ithong è awai nuruii shii dumuii rab ne ruii muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jishii ji pha khiao ji è awai shii yao, airo ithong ne idoh dun pha bajo chia iwa inow srane gai khiao hò-aphuii thek shii nane hò-amuii thek shii zuang srane niing thiig ne rai arone, ");
INSERT INTO bgg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","chiihphado khiaothek è aishii aluthong pha chiih-è ji pha ishak ithek è a-ìd shii nai jia Ithong idoh de thog srane, ji pha khiao jishii ne dumdum tham srane miyao anuii pha rek pho rog shii fen mua. ");
INSERT INTO bgg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Khiaothek shii masdo è nyie rek bo ino pha ji ìd pho ne awaithek shii khriig arek phi arone, jishii ne ithek rog shii bajo zuang phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jishii ithong è nyie chiid pha ji khiao hanyie è athieg ba arone, chiih-è thuh midijia zuang sapho rek magunde ìu zuang bie yi pha ro. Bajo phi ne ruii pha bran shii bajo chid din ruii phro, bajo phi ne ruii pho shii bajo lia ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Gu thiwing ne sohnyiak shii bai fuii wuii phro, chiih-è gu miiyang ji ne hùb pha jao ro! ");
INSERT INTO bgg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gu shii khowo mua ba pha um, chiih-è gu ji ajong sapho shii ne khama diig shii ro! ");
INSERT INTO bgg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gu ichiih sohjambling shii liijiing phi wuii phro ithek inow ne bey? Asi, liijiing asi, gu che pha wuii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sudoh è thiwing haliing shii bran guii yi che ruii phro, bran uom è bran nyie shii gidieg rek ruii phro chiih-è nyi è uom shii gidieg rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aphuii è dufuii shii gidieg rek ruii phro, chiih-è dufuii è aphuii shii gidieg rek ruii phro; amuii è dimi shii, chiih-è dimi è amuii shii gidieg rek ruii phro; khiing è icho shii chiih-è icho è khiing shii gidieg rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Isu è branthek shii de yao, “Nathek sakhamiing shii hanaiyem bsa è rek ruii pha doh mage shii, nathek ji riig srane yao haphie phie sharuii ro è yao shii haphie phie ruii. ");
INSERT INTO bgg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chiih-è nathek khuchung magunde hanai chiu è hasam sam ruii pha than mage shii nathek è yao ijieg rey sha ruii ro, chiih-è ji rey. ");
INSERT INTO bgg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lawasdai! Nathek sohnyiak nane hamangkhung shii rang thieg mua shii; ji arone nyie rek ne nathek duchung shii ishak ji agao mua lei? ");
INSERT INTO bgg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nathek nawaithek shii izai ji rek pha nyie rek ne achua lei? ");
INSERT INTO bgg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yang ne ithek shii nawaithek gidieg è gui rai pha miyao yie ne wuii ruii arone nawaithek rek mua pha ji rek srane chua bsa hà anow ba pha ibi shii lumuii hà nawaithek miyao ò rai pha rek bo. Ji asi shii ne ai è na thek shii chua pho hà noh srane, chiih-è chua pho è siphahi shii phi mua, chiih-è siphahi thek è phatheg hà chab muii. ");
INSERT INTO bgg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gu nathek shii yao, nathek è bang aphi sapho shii ne na ne thiisa phatheg hà rai dun phro.” ");
INSERT INTO bgg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ji pha ishak shii giak bran thiisa hà um pho è Isu shii yao Galilean phothek è Hamangkhung-aphuii shii mizid zid pha ishak shii Philath è ithek shii ua muii. ");
INSERT INTO bgg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Isu è ithek shii chang, nyieliieshii Galileanthek shii ji è rek ne ua muii shii, nathek è inow ne doh bey? Nathek ne gai Galileanthek è de bajo awie pha layog rek ro? ");
INSERT INTO bgg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Khuchung magunde de asi phro! Chiih-è gu nathek shii yao phro nawaithek layog è idoh akhid arone, nathek shii rek pha duiine nathek de zab iy ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloam shii miyao heg cho srane bran snamileo iy dun pho jishii nyie khi-èrek now lei? Nathek ne inow bey? Nathek ne Jerusalem pha zab pha bran è buii ro inow bey? ");
INSERT INTO bgg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Khuchung magunde asi ro! Gu nathek shii yaodang phro nsthek è nawaithek layog è akhid sapho shii ne, ithek shii rek pha duiine nathek zab iy ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chiihphado shii Isu è ithek shii hì pha najang yao: Luang jia shii bran jia è hing muii shii awai raig shii hai. Ai wuii srane ji pha hing muii shii riig shii nyie de awoi iang. ");
INSERT INTO bgg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jishii ai è awai raig riig pha bran jishii yao, riig mage bo, gu dam uom è hì pha hing muii shii iphem iwoi sow wuii shii igam jia de adoh ro, aishii chiiegmuii bo! Nyie rek ne nyiak shii thaluii sieng ne rai yi phlei? ");
INSERT INTO bgg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jishii raig riig pho è chang Masdo, brai yi bo dinne idam jia gu hì pha hing khiing shii wie jam chog srane rawo phi pha ro. ");
INSERT INTO bgg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chiihphado è hì pha hing muii è iwoi wie woi ruii arone wie ro; ji asi arone, na nya chieg muii bo. ");
INSERT INTO bgg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jewish Thung pha Inai jia shii Isu è jewish misiahò hà yao ramuii. ");
INSERT INTO bgg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hò-amuii jia yi awie pha ragung thoh ne dam snamiliao mucho è rad ne ai yi bam srane khuchung de miang arek mua. ");
INSERT INTO bgg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isu è aishii doh mage ne, ai è aishii ho, Hò-amuii, nane nawai murad ji è wie rey saro! ");
INSERT INTO bgg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ai è awai wad ai lakhung ruii mage shii, ai yi khthiie laziung miang riu srane Hamangkhung-aphuii shii laso phi. ");
INSERT INTO bgg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jewis misiahò pha dumuii ji è Isu ne Jewish Thung pha Inai shii gang phi pha ji riig srane lijieg, ji è ai è yao srane branthek shii yao, “Gethek shii ne blia rek pha dariig um ro; ji è ji pha naishii wuii ne gang nya rek phi bo, jimagunde Jewish Thung pha Inai shii arek rabo!” ");
INSERT INTO bgg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ithong è ithek shii chang, “Lawasdai ithek! Nathek è hanyie magunde nawaithek rawoi nane bambao shii Jewish Thung pha Inai shii de kho niing yi pha se ne anow bey? ");
INSERT INTO bgg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Thiihchiih shii um pha ji ne Abraham pha riing ro, ibuii è aishii ne dam snamileo è phang ne ruii mua; ji è aishii ne thung pha inai idoh shii gang arek mua ne bey?” ");
INSERT INTO bgg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ai muchang ji è airo shuang pho ne awailum ne biwo rey dun, ji pha ishak shii branthek ne Isu mirek pha buang pha blia jishii riig ne sang dun. ");
INSERT INTO bgg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Isu è sai, “Hamangkhung-aphuii pha Sajathua pha ji ne khi duiine lei? Gu ne nyie è aishii doh ne yao sha pha lei? ");
INSERT INTO bgg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hì ne ji duiine ro. Bran jia è danaro iriie yie srane raig shii wey pha duiine ro. Misieng yi sieng srane hing rey, chiih-è fuiithek de airo idiphak shii irung rak phro.” ");
INSERT INTO bgg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Din ne Isu è sai, Hamangkhung-aphuii pha Sajathua shii gu nyie khi-èrek doh ne yao sha pha lei? ");
INSERT INTO bgg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hì ne ji duiine ro. Hò-amuii jia è phiia yi srane jariie boh miihab shii lao shii zab phiia rey dun. ");
INSERT INTO bgg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Isu thiigthek shii nane thawunthek duchoi è wuii srane branthek shii yao ne Jerusalem hà rai ne wuii pha saro. ");
INSERT INTO bgg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bran jia è aishii sai, “Masdo, bran ìu shii ragia rey bie habey?” Isu è ithek shii chang, ");
INSERT INTO bgg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nathek ne wie rek srane habin khog ji è lua pha rek bo, nyieliieshii bajo branthek ne iliing hà wuii pha bidiang dang ruii phro, jimagunde awuii mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hò pha Ithong è jai srane habin bin muii phro; chiihphado nathek è fuang hà riu srane habin shii chokh ne yao ruii phro, ‘Masdo!’ Gathek shii de hò hong phi bo, ai è nathek shii chang ruii, ‘Gu nathek shii athieg ro nathek ne khi è wuii rai lei ne!’ ");
INSERT INTO bgg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chiihphado nathek è chang ruii, ‘gathek è de narog shii chie niing gieng phro; na è gathek thawun shii gathek shii yua ro!’ ");
INSERT INTO bgg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jishii de dinne ai yao ruii, gu ne athieg ro nathek khi-è wuii rai lei ne. Ichiih gu è dun bo, zab awie pha bran nathek. ");
INSERT INTO bgg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nathek shii ne fuang hà fen mage shii nathek ne Abraham, Isakh, Jakhob, chiih-è zab pha chaigthek shii Hamangkhung-aphuii pha Sajathua pha ji hà doh mage shii nathek ne khama choh srane nawaithek snying khriig ruii phro! ");
INSERT INTO bgg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Branthek ne bichiu nane niigo, chiih-è hakhoi nane hayang è wuii srane Hamangkhung-aphuii pha Sajathua shii dug ne michie chie ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chiihphado è thiih shii hanyie yi idoh lei ne ji ne ibi rey phro, chiih-è thiih shii hanyie yi ibi lei ne ji ne idoh rey ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ji-èrek pha ishak shii giak Pharisithek è Isu shii wuii srane aishii yao, “Na ne ichiih-è gai ithua hà dun marui bo, nyieliieshii Herod è na shii ne ua pha rek muii ro.” ");
INSERT INTO bgg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Isu è ithek shii chang, wuii srane ji pha sulgud shii yao mage bo: Gu ibuiithek shii fuang khia ne sudoh nane thimiang shii gang rek ba phi phro, chiih-è da-uom shii gui bliajong ba phro: ");
INSERT INTO bgg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sudoh, thimiang, chiih-è budoh shii de gu ne lua ba pha um ro; chaig shii ne Jerusalem è gai ithua hà ua pha ji ne arey mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem, Jerusalem! Nathek ne chaigthek shii de ua muii, chiih-è Hamangkhung-aphuii è thoh ge pha muaphothek shii de nathek è lubao chao! Gu khama ishak nathek shii de khemuii è awai aniphiing shii iyig iliing hà khrab ne ruii pha duiine nathek ro zab pha bran shii de gui wad ruii ne gung phi pha now shii, jimagunde nathek è gu shii arek yi. ");
INSERT INTO bgg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chiih-è nathek ro Misiahò ne isloi rey dun phro. Gu nathek shii yao, hanyie yi Ithong beng wuii pho ne Hamangkhung pha khirzey phi bo è yao pha ishak athog sapho shii ne nathek gu shii dinne khuchung de adoh phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Luang jia Jewsih Thung pha inai shii Isu michie chie pha Pharisithek pha dumuii jia hò hà wuii dun; branthek è Isu shii bajo wie è riig ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lai wad phieng ne rad pha bran jia Isu shii wuii thog, ");
INSERT INTO bgg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","chiih-è Isu è Pharisithek shii nane Iphey pha masdothek shii sai, “Jewish thung pha nai shii gethek Iphey shii wie nyarek mua ne ba asi arek mua ne bey?” ");
INSERT INTO bgg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jishii ithek è nyie de ayao, Isu è ji pha bran jishii noh srane aishii gang phi, chiih-è aishii thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chiihphado è ai ithek shii yao, “Nathek de nawaithek dufuii magunde chiih-è nathek rawoi magunde Jewish Thung pha Inai shii khabiing hà chiih dun arone nathek khthiie fuang akhia phi habey?” ");
INSERT INTO bgg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jishii ithek è ji è sai pha ji shii nyie de achang muluii. ");
INSERT INTO bgg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Isu è riig shii giak biwenthek ne ithua wie shii gua ne dug, ji è ai ji pha najang è nathek zab shii yao: ");
INSERT INTO bgg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","khuchung magungde ithek è nathek shii phiyiy pha michie shii ho ruii arone nathek ithua wie hà gua ne adug bi rabo. Nathek è de bajo mugak pha bran shii de ho pha de um phro, ");
INSERT INTO bgg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","chiih-è nathek shii ho pha bran è wuii srane yao ruii, hì pha ithua hì ne aishii dug yi bo! Chiihphado ji è yao shii nathek ne bajo wo srane zab è ìu pha ithua shii dug chid pha rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ji-è khuchung magunde nathek shii ho ruii arone, wuii srane zab è idoh pha ithua shii dug bi bo, ji arone nathek shii ho pha muspho è nathek shii yao ruii, “Gu ijakthek isa lakhung pha ithua wie hà wuii ne dug bo. Chiihphado nathek shii zab pha biwen moe shii ilab rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hanyie magunde awai shii boh rab arone, jishii ne ìu rab ruii phro, chiih-è hanyie magunde ìu rab ne rai arone, jishii ne boh rab phi phro.” ");
INSERT INTO bgg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chiihphado è Isu è aishii ho pha ji shii yao, “khuchung magunde na è luthua nane michie phi shii, nawaithek ro khuiinothek ijak, siang, hadung-haluii pha bukhothek shii aho rabo ithek de na shii idoh ho dinne phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Khuchung magungde michie phi arone, dusho, khu-òg, laikhi-èg nane miegthi thek shii phi bo, ");
INSERT INTO bgg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","chiih-è ithek shii khirzey mua ruii phro, nyieliieshii ithek ne na shii idoh aphi mua din phro. Bran Wie è iy ne hòi pha naishii Hamangkhung-aphuii è idoh phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bran jia yi thiibliie shii dug srane ji pha miyao ji nuii ramuii shii, ai è Isu shii yao, “Hamangkhung-aphuii pha Sajathua pha michie shii dug pho ne khama sang phro!” ");
INSERT INTO bgg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Isu è ji pha bran jishii yao, “Bran jia è michie bajo boh phi ramuii shii ai è bran bajothek shii ho. ");
INSERT INTO bgg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Michie chie pha ishak rey mage shii, zab khriig rey sha rone biwenthek shii, ‘Thawuii sha bo, è ho pha awai khiaothek shii thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jishii ithek zab jao ne jia pha idoh shii jia è wad khung ne yao, igobi pha ji è khiao jishii yao gu ne raig phegjong muii ro, chiih-è gu ne wuii srane raig ji riig pha um ro; chiih-è gu è khung hì nuii dang bo.’ ");
INSERT INTO bgg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gai jia è de yao, gu è de rawoi idiib guii phegjong muii ro ji è gu ne ithek shii fuang gieng pha ithek shii khi-èrek ne woi pha ji yua pha um ro; gu è khung ji nuii dang phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gai jia è de yao, gu ne yiy iwo yie dang ba phro, chiih-è ji pha chiang è gu de awuii mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Khiao ji è idoh dun srane zab awai ithong shii yao. Ithong ji è bajo lijieg srane awai khiao jishii yao, ‘khthiie thawun pha lumuii nane ikhi-èg hà wuii srane dusho shii, phadung khbam shii, miegthi nane laikhi-ègthek shii ho ne noh ruii bo.’ ");
INSERT INTO bgg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Achia dang shii khiao ji è yao, na muyung ji duiine gu è noh thog ro, jimagunde thiisa hà ne ùgud oi sha ro. ");
INSERT INTO bgg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ji-è dinne ithong è khiao jishii yao, ‘Hò ji ley rey yi pha soh pha zab lumuii hà wuii srane branthek shii ho mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gu nathek shii zab yao ji è rek ne ho phothek shii ne hanyie jia shii de gu michie achai yi phro!’ ” ");
INSERT INTO bgg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Luang jia shii ibrog branthek è Isu rog shii lua gieng ramuii shii, ai è idoh rei sra ne ithek shii yao, ");
INSERT INTO bgg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","hanyie magunde gu shii wuii pho ne gu è de bajo awai aphuii amuii, yiy duii, khuiinothek, bumuii nane awai shii miie ne rai pho ne guro samoy arey mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hanyie è magunde ithek è jia yi awairo bai han ne chiihphado gu shii awuii sapho shii ne guro samoy arey mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hanyie è magunde hò boh rung pha now arone arung ba pha ibi shii dug srane hì pha blia hì ne khama igong, chiih-è hì pha bang è siog gua asiok gua ji now phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ai khriig arek mua arone chog ched magunde hò arung mua phro; chiih-è zab nyie rey pha ji ne branthek è aishii riig srane siak phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ithek è yao ruii phro! Hì pha bran è jao phane jao shii ajong mua ara. ");
INSERT INTO bgg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Itham ichiig bran um pha saja rog shii itham sua bran um pha saja è mak rek pha wuii arone igobi shii wie dug srane mak rek pha khriig siog pha chua um a-um ji wie phak phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Arey mua arone gai saja awuii ba pha ibi shii awai muaphothek shii thoh ge ne liijiing rek pha miyao ò rai. ");
INSERT INTO bgg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ji duiine, Isu è yao, Hanyie magunde nawaithek shii nyie um pha ji athoh sapho shii ne guro samoy arey muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Suruii ne wie ro, jimagunde airo rem ji shand dun arone, dinne suruii rem arab mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Hì ne nyiak shii de awie chiih-è rawo shii de awie; hì shii ne fen mua. Ji-è, nathek shii nuii pha khohthek um arone, nuii mage bo! ");
INSERT INTO bgg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Luang jia bajo mijin thanpho nane layog branthek Isu miyao ji nuii pha wuii thog, ");
INSERT INTO bgg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisithek nane Iphey yao pha masdothek jao ne mushiiy, “Hì pha bran ne riing ìuthek shii de wie ho chiih-è ithek rog shii de chie!” ");
INSERT INTO bgg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Isu è ji pha najang è ithek shii yao: ");
INSERT INTO bgg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nathek è hanyie shii magunde wieng jia shiishai um shii, chiih-è jia yi san dun arone ai nyie khi-èrek phlei? Ai ne gai sadigey è digey shii ne ilieg hà thoh marui srane jia san dun pha ji shii adoh sapho shii ne sow ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ai è doh mage shii, ai ne bajo sang srane ai è awai baphig shii nuang ");
INSERT INTO bgg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","chiih-è idoh han ne hò hà dun. Chiihphado ai è awai ijak nane awai hadung-haluii pho shii ò ho srane ithek shii yao, gu ne bajo sang ro gu ro san dun pha shiishai ji doh ge ro. Cho gethek ne lubo rek sharai haro! ");
INSERT INTO bgg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ji duiine gu nathek shii yao, hanyie jia magunde layog è khid arone sadige è dige ilab rai pho hanyie yi akhid chid pha ji è de huak ne Hamangkhung è ne aishii bajo lubo phro. ");
INSERT INTO bgg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Din ne hò-amuii jia shii hayang sikhi sua um shii, airo hayang sikhi jia yi san dun arone ai nyie khi-èrek phlei? Ai ne muchuang ichuang srane awai hò shii sasriing rek ne big ne adoh sapho shii ne zab pha ithua shii wie è soh phro. ");
INSERT INTO bgg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ai è doh mage shii, ai ne awai ijak nane hadung-haluii pho shii ò ho ne yao, gu ne bajo sang sha ro gu ro sikhi san dun pha ji ne doh ge ro. Cho gethek ne lubo rek sharai haro. ");
INSERT INTO bgg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gu nathek shii yao, ji duiine, hanyie magunde zea layog è khid arone Hamangkhung-aphuii pha hamangkhliie è aishii huak ne sang ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isu è yao din ramuii, “Luang jia thiisa hà bran jia dufuii nyi um. ");
INSERT INTO bgg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iduno ji è aphuii shii yao, ‘Gu chiang pha nuruii thuh gui shii phi sha bo.’ Ji-è ji pha bran ji è nuruii yi ai dufuii nyi pha duchoi shii dong phi. ");
INSERT INTO bgg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Iù jia pha inai idoh shii ai dufuii iduno ji è awairo nuruii yi liu srane hò thoh marui ne bang rog shii rek dun. Ai gai ruang pha soh hà wuii srane, airo bang ne thaluii rek ne rai bsa hà mua marui. ");
INSERT INTO bgg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aishii nyie um pha ji zabjong ched shii, chiihphado è ji pha soh hà diigchiao thog mage, chiih-è aishii ne nyie de aled dang pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ji è ai ne blia rek sha pha thiig pha bran jia shii wuii thog, bran ji è wakthek riig yi pha raig hà thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ai awai è ino gu ne wakthek chie pha skhong pha mabin ji è lui nyalumuii mua, jimagunde de aishii hanyie è de chie pha aphi. ");
INSERT INTO bgg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Idohhè shii awai khani shii now srane yao, ‘zab pha gu aphuii ro braphothek ne khama chie mua pha ji chie, chiih-è ichiih shii gu ne chi-iyiy ne iy sha pha rek ro! ");
INSERT INTO bgg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gu ne jai srane gui aphuii shii dun ne yao pha ro, aphuii, gu è Hamangkhung-aphuii nane na shii buii rek muii ro. ");
INSERT INTO bgg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gu ne dinne na ro dufuii yao mua sapho ne asi ro; gu shii de naro riinang pha bliapho jia duiine ruii bo.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ji-è ai jai fad srane jao ne idoh awai aphuii hò hà dun din. “Ai ne hò è ruang ba shii, ai aphuii è aishii doh mage ne; iphuii lubu ne bajo bushun now dun, chiih-è ai ran srane, awai wad è dufuii shii giak srane, chiih-è khichiug. ");
INSERT INTO bgg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dufuii ji è yao ‘Aphuii, gu-è Hamangkhung-aphuii nane na shii buii layog rek muii. Gu shii ne na dufuii yao mua pha ne asi ro.’ ");
INSERT INTO bgg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‘Jishii aphuii è awai khiao shii khthiie ho srane!’ Ai è yao! yung wie yie srane aishii guii phi bo. Ai wad bieng shii giinad nad phi srane lai shii e lakhia khia phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chiihphado è igong swuii jia yie ne ua mage bo, chiih-è gethek ne michie rog shii luboh rek sha rai haro! ");
INSERT INTO bgg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hì pha gu ro dufuii ne iy dun shii, jimagunde ai ne hòi din ge ro; ai ne san dun shii, jimagunde thuh ai ne doh ge ro. Chiih-è ithek ne lubo rek pha jao. ");
INSERT INTO bgg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ji-è rek ramuii pha ishak shii dufuii kho ji yi raig hà. Ai raig è iidoh dun ne, hò hà thog ramuii shii, ai è benkhuang pha nane gasiu siu pha yoi. ");
INSERT INTO bgg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ji-è ai è awai khiao jia shii ho srane shii sai, nyie rey ramuii lei? ");
INSERT INTO bgg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Khiao ji è chang’ na ikhuii ne iidoh dun thog ro, ‘chiih-è na aphuii è Igong swuii de jia ua phro, nyieliieshii ai aphuii è aishii ne wie ne mua ge.’ ");
INSERT INTO bgg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ai ro ibam ji è bajo lijieg srane hò bucho hà de adun pha rai muii; ji è ai aphuii è fuang hà wuii srane khung ne hacho hà dun bo è yao. ");
INSERT INTO bgg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jishii ai è aphuii shii chang, ‘riig mage bo, gu ne nyama idam shii khiao duiine naro blia rek phi, chiih-è gu na muyungthek shii anuii pha de arek. Na è gu shii nyie phi ga? Gu ijakthek rog shii michie chie pha sphin jia rang de aphi! ");
INSERT INTO bgg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jishii hì pha naro dufuii è naro nuruii zab siulao bimi shii mua marui, chiih-è ai iidoh hò hà thog mage shii, na è Igong swuii aishii ua ne phi’ ");
INSERT INTO bgg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Iphuii è chang, gu Dufuii ‘na ne idang ichiih gu rog shii rai, chiih-è gu shii nyie um pha ji ne zab naro ro. ");
INSERT INTO bgg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jishii gethek ne lubo rek ne sang chid phro, nyieliieshii na khuii ne iy dun shii, jimagunde thiih shii ai ne sieng ro; ai ne san dun shii, jimagunde thiih shii ai ne doh ge ro.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isu è awai samoythek shii yao, Luang jia shii thiisa hà bukho bran jia shii airo nuruii riig pha khiao jia um. Chiih-è bukho bran jishii yao naro khiao ne bang ne zab mua ramuii ro, ");
INSERT INTO bgg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ji è aishii iliing hà ho srane yao, na chiang gu è yoi ramuii pha ji nyie lei? Na wad shii ruii yi pha zab nuruiithek gui shii iidoh sasab phi din sha bo, nyieliieshii nane dinne khiao rek mua sapho asi sha ro. ");
INSERT INTO bgg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Khiao ji è awai shii yao, gu ithong è gu shii ne blia è khia muii sha pha rek, gu ne nyie khi-èrek sha gua? Gu ne nyiak hiungthek chog mua sapho gang de oi, chiih-è gu ne chayem than pha de wo muii. ");
INSERT INTO bgg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Thiihchiih gu ne thieg sha ge gu ne nyie rek chid! Ji-è gu ro blia yie dun pha iidoh shii gu shii hanyie è ai hò hà ho arone, gu ne jishii ijak rek pha ro. ");
INSERT INTO bgg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ji-è ai ithong shii muruii um pha zab branthek shii ho. Ai è Igobi jia shii sai. Na è guro ithong shii khama muruii phi pha um ba lei? ");
INSERT INTO bgg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ai è chang, sumaro thiiliie yow biig wieng jia phi pha um ba ro. Khiao ji è aishii yao; ichiih shii naro sasab um ro, dug srane nawai siog shii saguii zey mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chiihphado è de ai gai jia shii de sai, chiih-è naro khama phi ba pha um lei? Ai è de chang, phiug thulo itham jia muruii phi pha um ro. Khiao i ji è aishii yao: Naro sasab ichiih shii um ro, wem miliao zey mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ji è rek pha chiang shii ithong è khlam pha khiao è khua rek pha ji shii laso phi; nyieliieshii ichiih sohjambling pha branthek ne awaithek blia shii rey yi pha ne sang hà rai phothek è ne khua ba ro. ");
INSERT INTO bgg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Chiih-è de Isu è yao, ji è gu nathek shii yao: Nathek sohjambling pha nuruii rog shii nawaithek ijak rab bo, ji è na shii khia muii magunde, na shii idang pha hò hà wie ho ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Hanyie magunde ìujia nyie shii migi um arone, ai ne boh shii de migi um ruii phro; hanyie magunde ìujia shii khlam rek arone, ai ne boh shii de khlam rek phro. ");
INSERT INTO bgg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chiihphado è, ithek soh pha nuruii shii rang de isiie è akhoh mua arone, nyie khi-èrek ne ithek shii izai pha nuruii shii khoh yi phlei? ");
INSERT INTO bgg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chiih-è na ne gai ro nyie um pha ji shii rang de isiie arey mua arone, na shii nyie um pha ji ne hanyie è phi mage phlei? ");
INSERT INTO bgg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Khiao jia è ithong nyi ro blia arek mua phro; ai ne jia shii miie arone jia shii ne amiie phro; ai ne jia shii isiie rek ne jia shii ne isiie arek phro. Nathek ne Hamangkhung-aphuii pha blia nane bang pha blia shii ò arek mua phro.” ");
INSERT INTO bgg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisithek è ji zab yoi mage shii, ithek è Isu shii siakjo mage, nyieliieshii ithek ne bang shii miie. ");
INSERT INTO bgg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isu è ithek shii yao, nathek ne jia ro bran mieg moe shii ne izai chak ro è doh yi, jimagunde Hamangkhung-aphuii ne nathek lubu ne thieg ro. Nathek shii branthek miphi pha boh phua pha ji ne Hamangkhung-aphuii moe shii ne nyie de aphua phro. ");
INSERT INTO bgg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses ro Iphey nane chaigthek mizey ji ne Jon Khowo phi pha ishak shii chun ge ro, ji è mujo Hamangkhung-aphuii pha Sajathua pha Mua Wie ji yao ramuii ro, chiih-è zab gang è ji pha bucho shii khud ramuii.” ");
INSERT INTO bgg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jishii Hamangkhung nane sohnyiak san dun magunde, Iphey pha ìu miyao ji ne san pha ne diig phro. ");
INSERT INTO bgg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Bran hanyie magunde awai yiy shii thoh srane gai hò-amuii shii yie arone ai ne siulao rek phro; Chiih-è hò-aphuii è de gey thoh muii pha hò-amuii shii yie arone ai de siulao rek phro. ");
INSERT INTO bgg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Luang jia thiisa hà bukho bran jia yi yung de bajo igong um pha yungthek guii srane nai tham ne bajo sang ne rai.” ");
INSERT INTO bgg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Thiisa hà Lazaras beng pha hìa è kheg muii pha dusho bran de jia um, aishii ji pha bukho bran habin moe shii noh ne ruii, ");
INSERT INTO bgg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","bukho thiibliie lakhung è idum chiih ruii pha ji chie pha luthong, choi rang de ai hìa jishii liak wuii. ");
INSERT INTO bgg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Dusho bran ji iy dun shii chiih-è hamangkhliiethek è noh srane Hamangkhung hà Abraham laluii shii dug ba yi. Bukho bran ji de iy ne wieng muii, ");
INSERT INTO bgg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","chiih-è thumuluii ai ne bajo riie pha thumluii bucho hà, ai è laziung hà riig shii bajo ruang hà lazaras yi Abraham laluii shii um pha doh. ");
INSERT INTO bgg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ji-è ai è ho mage, Aphuii Abraham! Gu shii de bushun rek bo chiih-è Lazaras shii thoh ge srane ai wad jiu è kho shii wo srane gu ri shii chen ne chei rek yi bo, nyieliieshii gu ne hì pha bai è bajo shud muii ro! ");
INSERT INTO bgg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Jishii Abraham è yao, ‘Now mage bo’ Gu dufuii, na sieng pha iidoh shii ne zab pha wie muna ne na shii phijong ro, ji pha ishak shii awie pha muna ne zab Lazaras shii phi. Jishii ai ne thuh shii ichiih lubo rek ramuii ro, nane hì pha ishak shii riie ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jithek rey magunde, thiisa hà gethek duchoi shii ne Jam ihiung um ro, ji è hanyie è thawin hiia ne isa wuii yang magunde awuii mua phro, ji è gathek è thiwing ithek moe hà wuii yang magunde awuii mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bukho bran ji è yao, chiihphado gu na shii wadkhung, aphuii Abraham, Lazarus shii gu khi hà guro khuiino guii um pha guro aphuii hò hà thoh ge bo. ");
INSERT INTO bgg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aishii wuii ge yi ne ithek shii phriie srane, hì è diig ne riie pha ithua shii adun yi rabo. ");
INSERT INTO bgg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham è yao, naro khuiinothek shii ne Moses nane chaigphothek phriie phro; ji è na khuiinothek ne ithek è nyie yao pha ji nuii yi bo. ");
INSERT INTO bgg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bukho bran ji è chang, ‘Ji è ne acho ba ro, aphuii Abraham! Jishii i-iy è hòi srane ithek shii wuii arone, chiihphado ithek ne awai mirek pha layog è khid ruii phro.’ ");
INSERT INTO bgg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jishii Abraham è yao, ‘Ithek è Moses nane chaigphothek shii rang de anuii arone, ithek ne iy ne hòi ne wuii pha ji shii de anuii phro.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isu è awai samoythek shii yao, “Branthek ne layog rey pha miyao ne idang yao, jimagunde hanyie è ithek shii ji rey yi pha ne khama diig phro! ");
INSERT INTO bgg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hanyie magunde ìujia shii awie pha layog rek arone, ji liak shii ne yua shii rathak boh jia phang srane khamuii bucho hà wo muii pha ji wie liak ro. ");
INSERT INTO bgg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ji-è na nyie rek pha ji riig mage bo! “Na khuiino è layogthek rek arone giung bo, chiih-è ai layog è iidoh khid arone, aishii khung phi bo. ");
INSERT INTO bgg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ai è inai jia shii miley chiieng layog rek magunde, ai è na shii nyawuii khi ne yao, gu ne layog è khid din pha ro è yao arone, na aishii khung phi bo.” ");
INSERT INTO bgg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Guaphasamoythek è Ithong shii yao, “Gathek ro migi shii boh rab phi bo.” ");
INSERT INTO bgg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ithong è chang, nathek shii danaro iriie nyama de boh migi um arone nathek hì pha mulbery hingmuii shiide nyayao mua phro nawailum iriing è hug dang ne khamuii bucho hà dun ne sieng ne rai bo! chiih-è ji de ai nyanuii phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Yangne hanyie magunde ithek ro khiao jia yi raig chog ne shiishai riig. Ai yi raig è dun thog mage shii, ithek è aishii khthiie hì pha michie chie sha bo è yao habey?” ");
INSERT INTO bgg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Khuchung magunde de ayao phro! Ji phachiang shii, na è aishii yao, guro michie saro sha phi bo, chiihphado è gu achie aniing ched sapho shii ne na nawairo yung wie guii srane gu shii ragia rek bo; chiihphado è na de chie bo. ");
INSERT INTO bgg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Khiao è khama pha blia rek magunde airo muyung nuii rone aishii laso aphi phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hì duiine na shii de ro; nathek shii nyie yung pha ji zab ji rek ched bie arone, yao bo, gu ne thaluii pha khiao ro; chiih-è gu ne nyie yung pha blia ji rek bie phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Isu awai yi Jerusalem hà rai ne wuiiramuii shii, ai è Samaria nane Galili pha sohthug è dong ne lua. ");
INSERT INTO bgg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ai yi thiig è wuiiramuii shii awiedang hìa è riie pha bran sua shii si. Ithek yi ai è ìujia ruang hà riu ne um, ");
INSERT INTO bgg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","chiih-è ziak mage, “Isu! Masdo! Gathek shii de bushun rek bo!” ");
INSERT INTO bgg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Isu è ithek shii riig srane ithek shii yao, “Nathek phabi shii wuii srane riig yi bo.” Lumuii hà ithek shii so rab phi ro. ");
INSERT INTO bgg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ithek jia è riig shii ai ne gang rey sha, ai iidoh dun srane goh gang è ziak ne Hamangkhung-aphuii shii laso phi. ");
INSERT INTO bgg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ai awailum ne buzam Isu lai shii bam srane aishii laso phi. Ji pha bran yi Samarithan ro. ");
INSERT INTO bgg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Isu è yao, “Bran sua ne gang reyjong pha ji è; digey ne khi hà lei? ");
INSERT INTO bgg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nyie um ne hì pha fuang pha bran awai ji jia iidoh wuii srane Hamangkhung-aphuii shii laso phi phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chiih-è Isu aishii yao, “Jai srane dun mage bo; nawai migi è na shii wie rek phi ro.” ");
INSERT INTO bgg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Giak Pharisithek è Isu shii sai Hamangkhung-aphuii pha Sajathua ji ne khuchung thog ruii phlei. Ai è ithek shii chang, “Hamangkhung-aphuii pha riichai ne doh yi ne awuii phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hanyie jia è de ayao mua phro, riig bo, hì ne ichiih um ro! Chiih-è, hì ne thiisa hà um ro; nyieliieshii Hamangkhung-aphuii pha Sajathua ne nathek duchoi shii um ro.” ");
INSERT INTO bgg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chiihphado ai è awai samoythek shii yao, “Ai thog ruii phro” Nathek è Bran Dufuii wuii pha naishii ne luang jia riig yang phro, jishii ithek adoh phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Thiihchiih shii ithek è nathek shii yao ruii phro thiisa hà riig mage bo! chiih-è riig mage bo! Ichiih shii! Jishii nathek wuii srane ariig rabo. ");
INSERT INTO bgg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hamangkhung è haliao jia bliak ne soh iring jia è gai iring jia shii thog pha chuang ruii phro, Bran Dufuii ro inai de ji pha iidoh duiine phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jishii ai ne igobi ji pha inai shii bajo diig rek srane branthek è aishii ne snai muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noah pha ishak ji duiine yi Bran Dufuii pha inaithek de rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noah yi run bucho hà akhud sapho shii ne branthek chie niing ne yiy gey ne rai, chiih-è kho khed thog srane zab shii ua muii. ");
INSERT INTO bgg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hì ne Loth pha iidoh shii duiine phro. Zab pha branthek chie niing ne, chiih-è pheg liu ne, hai rung ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ji pha ishak shii loth Sodom è khia dun shii, Hamangkhung è bai nane arem pha now pha chiih srane zab branthek shii hùb ne ua muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hì nyie khi-èrek rey pha ji ne Bran Dufuii dong mage shii de rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ji pha naishii hanyie magunde hò pha zak lakhung hà um iang arone nawaithek mana yi pha buzam alung rabo; ji duiine hanyie magunde raig hà um arone iidoh hò hà adun rabo! ");
INSERT INTO bgg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loth ro yiy shii now mage bo! ");
INSERT INTO bgg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Hanyie magunde awai chai shii ragia rek pha bidiang arone ai ne iy phro; hanyie magunde awai chai shii mua muii arone ragia rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Gu nathek shii yao, ji pha habiu shii, bijiu nyi biang jia shii ò men magunde: jia shii ne chiing ne noh dun phro, Gai shii ne thiihchiih thoh marui phro. ");
INSERT INTO bgg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Hò-amuii nyi yi phiug ò sui ne rai magunde: Jia shii ne chiing ne noh dun phro, gai jia shii ne iidoh thoh marui phro.” ");
INSERT INTO bgg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Samoythek è aishii sai, “Ithong ji ne khi hà lei?” Isu è chang, “Khi hà bran iy um lei ne, ji hà biichiingthek de um ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chiihphado Isu è ji pha najang è awai samoythek shii idang sia ne lubu ìu arek rabo ne yuaphi. ");
INSERT INTO bgg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Thawun jia shii Hamangkhung-aphuii shii de arum chiih-è bran shii de ilab aphi pha chua pha jia um. ");
INSERT INTO bgg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chiih-è ji pha thawun shii misiungmuii de jia rai, ai è aishii nyawuii lumua ne khung ne yao, guro rangsua jishii gu mak pha gidieg è ragia rek phi bo! ");
INSERT INTO bgg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nai phrak jia ne chua pha bran ji è ji pha blia rek pha anuii phi, iidohhè shii awailum ne yao, gu Hamangkhung-aphuii shii arum magunde chiih-è bran shii lab arek magunde, ");
INSERT INTO bgg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nyieliieshii thiih thog pha hì pha misiungmuii è gu shii diig phi muii, gu airo rangsua ji awai mua yi pha riig chid phi phro. Gu ji arek phi shii ne, ai nyawuii lumua ne iidohhè gu shii jid yi phro! ");
INSERT INTO bgg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chiih-è de Ithong è yao, nuii bo awie pha chua pha bran ji è nyie yao. ");
INSERT INTO bgg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ji-è hanyie è aishii nong lia srane hanai nane habiu choh srane lia arone, Hamangkhung-aphuii è awai nyu pha bran shii aphi ne bey? Aishii nong rek phi pha ne chia ne bey? ");
INSERT INTO bgg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Gu nathek shii yao, ai ne awai nyu pha ji shii ne khthiie chua ne rek phi phro. Jishii Bran Dufuii sohnyiak hà wuii shii migi doh ne bey? ");
INSERT INTO bgg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Isu hì pha najang yi hanyie è awai shii ne wie ro è yao, chiih-è gaithek shii ne awie ro è yao ne snai ji pha bran shii yao. ");
INSERT INTO bgg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Luang jia shii bran nyie yi Misiahò hà sia pha wuii dun: jia yi Pharisi, chiih-è gai yi mijin thanpho pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisi ji è riu srane awai lubu shii sia, gu na shii laso phi, Hamangkhung-aphuii, ji è gu ne agiichak ro, anuii pha de arek, chiih-è ithek gai duiine siulao de arek, gu na shii laso phi, nyieliieshii gu ne mijin thanpho duiine de asi ro. ");
INSERT INTO bgg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gu ne habda jia shii danyi minyie nyie phro, chiih-è gu miwiang pha zab ji è de na shii jiasua phi ro. ");
INSERT INTO bgg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jishii mijin thanpho pha ji è ruang hà riu srane mizia Hamangkhung hà de ahù dang pha awai lubutho shii phe srane yao, Hamangkhung-aphuii layog gu shii de bushun rek bo! ");
INSERT INTO bgg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Isu è yao, gu nathek shii yao, “Ai nyi è hò dun shii Pharisi shii asi pha, mijin thanpho pha ji ne Hamangkhung-aphuii rog shii rangsua rey dun. Ji-è hanyie magunde awai shii boh rek arone aishii ne ìu rey ruii phro, chiih-è hanyie magunde awai shii ìu rek arone aishii boh rab ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Giak branthek è aniphiing lakhung shii wad ruii ne khirzey phi yi pha Isu shii noh thog. Samoythek è ithek mirek ji riig srane ithek shii giung, ");
INSERT INTO bgg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jishii Isu è aniphiing shii awai moe hà ho srane ithek shii yao, aniphiing shii gu hà wuii yi bo, chiih-è ithek shii agak rabo, nyieliieshii Hamangkhung-aphuii pha boh Sajathua pha ji ne hì è rek pho ro ro. ");
INSERT INTO bgg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Hì now mage bo! Hanyie-magunde Hamangkhung-aphuii pha boh Sajathua pha ji shii aniphiing duiine acho arone ji pha iliing akhud mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jewish pha dumuii jia è Isu shii sai, “Wie Masdo, khuchunde a-iy pha chai mua pha gu nyie rek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isu è aishii yao, “Gu shii nyie re ne wie ro è ho phlei?” Hanyie de wie asi ro, wie ne Hamangkhung-aphuii jia bey ro. ");
INSERT INTO bgg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na ne muyungthek thieg, siulao arek rabo; khishii a-ua rabo; mugo agow rabo; chiih-è hanyie shii de biidiie athe rabo; chiih-è aphuii amuii shii ilab rekbo. ");
INSERT INTO bgg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bran ji è chang, “Gu ne filiao mujo è hì thek pha miyao ne nuii ne lua phro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Isu è jithek yoi ne, ai è aishii yao, “Thiih de nane blia jia rek chid ba pha um ro. Na shii um pha jithek zab liu srane bang yi dushothek shii phi muii bo, chiih-è na gu rog shii luagieng bo; ji arone nane Hamangkhung hà bajo bukho rey ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jishii ji pha bran è ji pha miyao yoi mage ne, ai ne bajo duhug rey dun, nyieliieshii ai ne bajo bukho. ");
INSERT INTO bgg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ai bajo duhug rek pha ji Isu è riig srane yao, “Bukho branthek ne Hamangkhung-aphuii pha Sajathua ji hà khud pha ne khama nang ro! ");
INSERT INTO bgg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bukho branthek è Hamangkhung-aphuii pha Sajathua hà khud pha ji shii ne ùd è simen cho shii khud pha ji wie liak ba ro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ai miyao nuii pha branthek è aishii sai, “Chiihphado, hanyie shii ragia rey phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isu è chang, “Bran è nyie arey mua pha ji ne Hamangkhung-aphuii è nya rey mua phro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phithar è yao, riig mage bo! gathek ne hòthek thoh srane na iidoh shii lua gieng. ");
INSERT INTO bgg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Isu è ithek shii yao, gu nathek shii izai yao, hanyie magunde hò, yiy khuiino, aphuii, amuii, ani thoh srane Hamangkhung-aphuii pha Sajathua pha ji shii sow arone ");
INSERT INTO bgg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","duchung pha idam shii de bajo mua ne dinne thog ruii pha idam shii de idang pha chai mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isu è awairo snanyi samoythek shii yoh pha ithua hà noh srane ithek shii yao, “Yoi mage bo! Gethek ne Jerusalem hà wuii sha pha ro, thiisa hà chaigthek è Bran Dufuii chiang shii zey pha ji ne zab izai rey phro. ");
INSERT INTO bgg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aishii ne gai branthek wad shii phi muii chiih-è ai mirek ji nui ne, chiih-è aishii chan cho phro. ");
INSERT INTO bgg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ithek è aishii zuang srane ua muii phro, chiih-è da-uom pha iidoh shii ne chai hòi din phro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jishii samoythek è ai nyie yao pha ji yi nyie de athieg mua; miyaogamthek sbang ne ithek è ug dun, ji è Isu è nyie yao pha ji agao muii gieng. ");
INSERT INTO bgg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Isu yi Jerikho hà wuiiramuii shii, lumuii hà miegthi jia chayem than ne rai iang. ");
INSERT INTO bgg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ibrogthek yi ai è rek dun pha yoi srane, ai è sai, “Hì nyielei?” ");
INSERT INTO bgg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ithek è aishii yao, “Nazareth pha Isu rek ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chiih-è ai choh srane yao, “Isu, Dawid pha dufuii! gu shii de bushun rek bo!” ");
INSERT INTO bgg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Thiichiih ibi shii um pha branthek è aishii giung srane aishii yao aro dang rabo, jimagunde ai è dinne de ji è lahuak bo ziak ne yao, “Dawid pha dufuii! Gu shii bushun rek bo!” ");
INSERT INTO bgg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ji-è Isu thiihchiih riu srane yung, ji pha miegthi shii gu moe hà now mage bo. Ai yi nui hà wuii thog mage shii, Isu è aishii sai, ");
INSERT INTO bgg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Gu è na shii nyie rek phi bo è now lei?” Ai è chang, “Masdo,” “Gu dinne doh pha now ro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Isu è aishii yao, “Chiihphado doh mage bo! Nawai migi è na shii wie rek ge ro.” ");
INSERT INTO bgg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Thiihchiih shii ai ne doh muii dang dun, chiih-è ai ne Isu rog shii lua gieng srane Hamangkhung-aphuii shii laso phi. Ibrogthek è ji riig srane ithek de zab Hamangkhung-aphuii shii laso phi. ");
INSERT INTO bgg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isu yi Jerikho è dong ne wuiiramuii shii. ");
INSERT INTO bgg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Thiisa hà Zakhaeus beng pha mijin thanpho pha boh bukho jia um. ");
INSERT INTO bgg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ai è Isu hanyie lei ne riig pha bidiang, jimagunde ai ne bran dum buii ne Isu shii ariig mua, nyieliieshii bajo ibrog um. ");
INSERT INTO bgg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ai yi ji pha lumuii è dong ne wuiiramuii rone, ji è ai ne Isu shii riig pha ibrog è ibi hà ran srane sykhamor hingmuii shii wiu. ");
INSERT INTO bgg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Isu è ji pha ithua shii wuii thog mage shii, ai laziung riig srane Zakhaeus shii yao, “Khthiie buzam hà lung bo, Zakhaeus, nyieliieshii, sudoh gu ne na hò shii rai pha ro.” ");
INSERT INTO bgg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakhaeus è khthiie nyiak hà lung srane bajo lubo ne aishii wie ho. ");
INSERT INTO bgg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Zab pha branthek è ji riig srane jao ne mushiiy, “Hì pha bran ne biwen rek ne layogthek hò shii wuii dun ara!” ");
INSERT INTO bgg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakhaeus è riu srane Ithong shii yao, “Yoi bo, Masdo! Gu shii nyie um pha ji ne khoyo yie srane gu dushothek shii phi muii pha ro, chiih-è gu hanyie shii magunde nyie khlam ne yie magunde gu iidoh wirang rek ne rang din pha ro.” ");
INSERT INTO bgg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Isu è aishii yao, “Sudoh ichiih pha hò shii idang pha giawo thog ro, hì pha bran ai de, Abraham pha riing ro, ");
INSERT INTO bgg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bran Dufuii ne shand dun pha ji shii sow pha nane ragia rek wuii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Branthek yi nyanuii bamuii shii, Isu è athodang pha ji pha najang è dinne ithek shii yao. Ai yi Jerusalem hà thog sharuii, ithek è now shii Hamangkhung-aphuii pha Sajathua ji ne thog sha ruii ro. ");
INSERT INTO bgg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ji-è ai è yao, luang jia shii bran boh rek pha jia yi gai ruang pha soh hà saja rey ne iidoh hò hà dun din pha phak. ");
INSERT INTO bgg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ai awuii ba pha ibi shii, awai khiao suathek shii ho srane san sikhi ji jia phi srane ithek shii yao, riig bo gu wuii dun pha ishak shii nathek hì pha rog shii Khinyama wiang mua pha ji wiang iang bo. ");
INSERT INTO bgg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Thiih shii awai thiig pha branthek è aishii amiie sha, ji è iidoh aishii yao pha ithek è muaphothek shii thoh ge, gathek ne hì pha bran shii gathek saja rek pha achid sha ro. ");
INSERT INTO bgg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ji pha bran ne saja rek marui srane iidoh dun thog din. Ai è khthiie awai khiao shii yung srane ai moe shii wuii mage bone yao, nyieliieshii ithek è khama wiang lei ne ji riig pha ho ro. ");
INSERT INTO bgg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Igobi shii jia è wuii thog srane yao, ‘Masdo, gu è na miphi pha san sikhi jia rog shii sua wiang doh ge ro.’ ");
INSERT INTO bgg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ai è yao, wie rek ge ro ‘Na ne khiao wie ro! nane ìu blia shii rangde bajo isiie rek phi, ji è gu na shii rajan sua shii dumuii khoh yi pha ro.’ ");
INSERT INTO bgg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Din ne khiao jia è de wuii thog srane yao, ‘Masdo, gu è na miphi pha san sikhi jia rog shii guii wiang doh phi ro.’ ");
INSERT INTO bgg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jishii de ai è yao, na shii de rajan guii shii dumuii rek yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Gai khiao jia è de wuii thog srane yao, ‘Masdo, naro san sikhi ne ichiih um ro; gu è yung thilek è pham srane ug ne ruii phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gu ne na shii rum, nyieliieshii nane bajo nang bran ro. Na ne naro asi pha ji de na è yie muii, chiih-è na è ahai magunde na è riug ne yie muii.’ ");
INSERT INTO bgg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ai è aishii yao, nane awie pha khiao ro! Gu ne nawai sem pha miyaogamthek ji è nawai shii the ruii phro! Gu ne nang ro è nane thieg, chiih-è gu ro asi magunde gu è yie muii, gu miihai asi magunde gu è riug maphi. ");
INSERT INTO bgg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chiihphado na gu ro bang shii nyie rek ne beng hà achab aruii phi lei? Chiihphado gu iidoh dun thog shii gu ne ji pha rog shii phua mua ne iidoh nya yie din. ");
INSERT INTO bgg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chiihphado shii ai è hanyie thiichiih riu ne um phothek shii yao, ‘San sikhi ai è yie srane hanyie shii sikhi sua um pha ji shii phi muii bo.’ ");
INSERT INTO bgg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jishii ithek è aishii yao, ‘Masdo, aishii ne sikhi sua umjong ro!’ ");
INSERT INTO bgg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ai è chang, gu nathek shii yao ‘Hanyie shii um magunde aishii ne dinne phi din ruii phro, jimagunde hanyie shii oi magunde aishii ìujia um pha ji de yie din muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Thuh shii, hanyie guro mak phothek è gu shii ithek saja rey bo è achid pho shii de gu moe shii noh srane zab ua muii bo!’ ” ");
INSERT INTO bgg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Isu è ji yao ched pha iidoh shii Isu yi ithek ibi Jerusalem hà wuiiramuii. ");
INSERT INTO bgg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ai è sumaro pha phiing Bethphach nane Bethany hà wuii thog mage shii, ai è samoy nyi shii yung srane ibi thoh ge: ");
INSERT INTO bgg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ibi pha thiig hà wuii mage bo chiih-è iliing hà wuii thog shii, thiisa hà hanyie de a-in ba pha bambao jia phang ne um pha doh ruii phro. Ji pha bambao shii sey ne isa yie ruii bo. ");
INSERT INTO bgg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nathek shii hanyie magunde ji pha bambao shii nyie rek pha sey phlei ne sai ruii arone nathek è aishii yao bo, hì ne Masdo è chid muii ro. ");
INSERT INTO bgg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ithek thiisa hà wuii dun shii Isu è nyie khi-èrek yao lei ne ji duiine mua. ");
INSERT INTO bgg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ithek yi bambao phang ne um pha ji sey ramuii shii, ji pha muspho è ithek shii sai nathek ji nyie rek pha sey phlei? ");
INSERT INTO bgg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ithek è chang, “Ithong è chid muii ro,” ");
INSERT INTO bgg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chiih-è ithek è bambao shii Isu hà noh ne dun thog. Chiihphado shii ithek ro yung bambao lakhung shii gow srane Isu shii in pha nong ba yi. ");
INSERT INTO bgg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ai è lakhung shii in mage shii, ithek è ibi lumuii hà yung wiao phi iang. ");
INSERT INTO bgg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ai Jerusalem hà sumaro um pha phiing buzam hà wuii pha lumuii shii thog mage shii, ai samoythek è zab blia bohthek doh pha ji è Hamangkhung-aphuii laso phi ne chiih-è aishii goh boh è ziak srane chiong phi: ");
INSERT INTO bgg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Hamangkhung-aphuii hanyie yi Ithong beng è wuii pho shii ne khirzey phi bo! Hamangkhung hà liijiing nane Hamangkhung-aphuii ro biisiie rey bo!” ");
INSERT INTO bgg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chiihphado shii ibrog è giak Pharisithek è Isu shii yao. “Masdo,” ithek è yao, “Naro samoy shii aro rabo è yung mage bo!” ");
INSERT INTO bgg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Isu è chang, “Gu nathek shii yao phro ithek è aro pha rai arone, lubaothek awailum ne jao ne ziak ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ai ji pha rajan moe hà wuii thog mage shii, chiih-è ai ji pha rajan shii riig srane choh, ");
INSERT INTO bgg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ne yao, nathek sudoh shii liijiing ne khama mugak ji thieg arone! Jishii thuh shii nathek ne ariig mua sha phro! ");
INSERT INTO bgg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nathek gidiegpho è nathek shii zab pha ithua gung srane nathek lumuii shii de zab bin maphi pha ishak de thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ithek è nathek shii zab mua muii phro chiih-è branthek è nathek ro chan muthua shii de chuakbraig srane ji pha ithua shii lubao jia de aruii phro, nyieliieshii Hamangkhung-aphuii è ithek shii ragia rek wuii shii ithek è ishak athieg! ");
INSERT INTO bgg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chiihphado è Isu Misiahò iliing hà wuii srane chong rek pho shii fuang hà gieng mage, ");
INSERT INTO bgg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ithek shii yao, “Hamangkhung-aphuii miyao ji ne ichiih jigigam shii zey ne um ro, Guro Misiahò ji ne sia pha hò ro è yao phro. Jishii ithek è mugothek ug ne rai pha hò rab muii!” ");
INSERT INTO bgg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nai tham ne Misiahò shii yua, phabi wegthek, Iphey yao pha masdothek, chiih-è dumuii branthek è aishii ua pha now, ");
INSERT INTO bgg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jishii ithek è aishii ji è rek pha nyie lumuii adoh phi, nyieliieshii zab bran è miyaogam jia de amuii yi pha airo miyao ji isiie è yoi. ");
INSERT INTO bgg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nai jia Isu yi Misiahò shii yua srane Mua Wie yao ramuii shii, boh phabi nane Iphey yao pha masdothek nane dukhothek branthek sha hà ò shii wuii thog ruii ");
INSERT INTO bgg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","chiih-è ithek è aishii yao, “Gathek shii yao riig, na shii hì pha blia rek pha rangsua hanyie miphi lei?” ");
INSERT INTO bgg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Isu è ithek shii chang, “Gu de nathek shii mushai sai riig. Yao riig, ");
INSERT INTO bgg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon Khowo phi pha rangsua ne Hamangkhung-aphuii è wuii ne ba asi pha bran è wuii ne ba?” ");
INSERT INTO bgg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Awaithek chung jao ne khnaing rai, gethek nyie khi-èrek chang sharai pha lei? Gethek è ai ne Hamangkhung-aphuii è wuii phro è yao arone, ai ne gethek shii yao din ruii, nyie rek ne, ji arone, ithek Jon shii migi arek lei? ");
INSERT INTO bgg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jishii Jon ne bran è wuii phro è yao arone ichiih um pha bran phiing è gethek shii ne labao rek ne chao phro, nyieliieshii ithek ne Jon shii ne chaig ro è thieg. ");
INSERT INTO bgg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jishii ithek è chang, gathek ne athieg ro Jon ro rangsua ne khi è thog. ");
INSERT INTO bgg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chiih-è Isu è de ithek shii chang, ji arone, gu de nathek shii ayao phro, Gu è hì pha blia nyie rangsua è rek pha ji. ");
INSERT INTO bgg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chiihphado shii Isu è branthek shii ji pha najang ji yao: Luang jia shii bran jia è raig shii angur hai srane, chiih-è raig rek pha gai bran shii raig chui marui srane ruang hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Angurthek khrab pha ishak thog mage shii ai è awai khiao jia shii raig chei phi pho shii airo mathang yamiing yie pha thoh ge. Jishii raig chei pho è khiao jishii ne zuang srane nyie de aphi pha iidoh thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ji-è gai khiao jia shii thoh ge; jimagunde raig chei phothek è aishii zuang srane, chiih-è biwo yao srane aishii de isloi iidoh hà thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chiihphado shii dinne awai khiao yoh jiashii de thoh bage ba, chiih-è raig chei pha bran è aishii de bajo zuang srane, chiih-è fuang hà fenmuii. ");
INSERT INTO bgg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Chiihphado, angur raig muspho è yao, gu nyie khi-èrek sha phaga? Gu gui ro bushun dufuii shii thoh sha ge phro; ji arone ithek aishii ne ilab phi rek! ");
INSERT INTO bgg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jishii raig chei pho è aishii riig mage ne awaithek chung yao rai, hì ne raig ithong pha dufuii ro. Ji-è cho gethek ne aishii ua muii haro, chiih-è airo nuruii ne gethek ro rey phro! ");
INSERT INTO bgg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ji-è ithek aishii angur raig è fuang hà noh srane aishii ua muii. Isu è sai, ji è rek mage shii ji pha raig muspho è raig chei phothek shii nyie rek phlei? ");
INSERT INTO bgg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Ai ne wuii srane ji pha branthek shii ua muii phro, chiih-è angur raig yi gai raig chei phothek wad shii phi muii phro.” Ithek è ji yoi mage shii, ithek è yao, “Ji duiine arey dang rabo!” ");
INSERT INTO bgg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Isu è ithek shii riig srane sai, “Chiihphado, hì pha jigigam ne nyie zey phlei? ‘Rung phothek è lubao shii awie ro è snai muii pha ji ne dinne zab è bajo mugak lubao rey din.’ ");
INSERT INTO bgg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hanyie magunde ji pha lubao lakhung shii chiih arone ismed rey dun phro; chiih-è ji pha lubao è hanyie lakhung shii chiih magunde, aishii ihab rey dang pha chao dun phro.” ");
INSERT INTO bgg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iphey yao pha masdothek nane boh phabithek Isu è ji pha miyao ne ithek shii gidieg rek ne yao phrone thieg ne ji pha ithua shii zum pha bidiang, jimagunde ithek ne branthek shii rum. ");
INSERT INTO bgg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ji-è ithek ne jo mua pha ji riig ne rai. Ithek è giak branthek shii Lugu phi ne ithek shii bran isiie rone doh yi, chiih-è ithek è jithek shii Isu shii mushai sai ne ichag sow pha thoh ge, ji è ithek è aishii ne Roman Badri pha blu nane riichai shii phi muii pha rek. ");
INSERT INTO bgg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ji pha bujuiiphothek è Isu shii yao, “Masdo, gathek ne thieg na è nyie yua nyie yao pha ji ne izai chak ro, chiih-è gathek ne thieg nane bran boh ìu um ne de achua, jimagunde nane Hamangkhung-aphuii è branthek shii nyie chid pha izai ji yua. ");
INSERT INTO bgg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gathek shii yao riig bo, gathek è Roman Bisiu shii mijin phi pha ji ne Iphey shii zen ne ba, asi azen ba?” ");
INSERT INTO bgg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jishii Isu è ithek mirek pha ichiig jishii wie riig srane ithek shii yao, ");
INSERT INTO bgg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Gu shii liiman pha sikhi jia riig yi mage. Hì shii hanyie midong nane hanyie beng zey ne um lei? Ithek è chang, hì ne Bisiu beng zey ne um ro. ");
INSERT INTO bgg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ji-è Isu è yao, “Chiihphado, wie, nyie yi Bisiu ro awai shii phi bo, chiih-è nyie yi Hamangkhung-aphuii ro awai shii phi bo.” ");
INSERT INTO bgg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Thiihchiih branthek ibi shii aishii azum mua, ji è ithek aro dang pha rai srane, Isu muchang ji nuii ne wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chiihphado bran yi iy ne ahòi din phro è yao pha ji shii izai anow pha giak Sadusithek wuii thog srane Isu shii yao, ");
INSERT INTO bgg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Masdo, Moses è hì è yao ne gathek shii zey ne zen marui: bran jia iy dun shii ai yiy yi ani agiak ba pha thoh marui arone, ji pha misiungmuii shii ne ji pha bran ikhuii è yie ne ani nya giak mua phro ji pha arone iy dun pha bran pha ani rey phro. ");
INSERT INTO bgg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Luang jia ithek khuiino miley um shii; zab è dukho ji è yiy yie srane ani agiak ba pha iydun, ");
INSERT INTO bgg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","chiihphado è ji pha hò-amuii shii sulong nyi pha ikhuii è ji pha hò-amuii shii yie din, ");
INSERT INTO bgg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","chiih-è dinne uom pha ji è de ji è rek, ji duiine zab khuiino miley shii de ji è rey dun ne ithek ne ani agiak pha iy dun, ");
INSERT INTO bgg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","iidohhè shii ji pha hò-amuii de iy dun. ");
INSERT INTO bgg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ji-è iy ne hòi din pha inai thog mage shii, ithek miley è yiejong pha hò-amuii ji ne hanyie ro yiy rey phlei? ");
INSERT INTO bgg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isu è ithek shii chang, “Sieng pha ishak shii ne hò-aphuii hò-amuii ne ayiy agey rai phro, ");
INSERT INTO bgg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jishii giong hò-aphuii hò-amuii dinne thog pha ishak shii iyjong hòi din mage shii ne ayie agey sharai phro. ");
INSERT INTO bgg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ithek ne hamangkhliie duiine rey dun phro chiih-è khuchung de a-iy mua phro. Ithek ne Hamangkhung-aphuii pha dufuii rey sha phro, nyieliieshii ithek ne iy pha ji è hòijong ge ro. ");
INSERT INTO bgg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Chiih-è iy ne hòi din phro è Moses è wie doh yijong ro, jigigam shii de zey ne um ro ai è baihang pha jabiing shii Ithong pha miyao ne Abraham pha Hamangkhung-aphuii, Isakh pha Hamangkhung-aphuii, chiih-è Jakhob pha Hamangkhung-aphuii, shii yao. ");
INSERT INTO bgg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ai ne sieng pha Hamangkhung-aphuii ro, iy pha asi ro, ai pha chiang è zab sieng mua phro.” ");
INSERT INTO bgg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iphey yao masdo giak è yao, “Masdo, wie chang ro!” ");
INSERT INTO bgg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ji è ithek ne aishii dinne miyao asai mua. ");
INSERT INTO bgg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Isu è ithek shii sai, hì ne nyie khi-èrek ne Masi ne Dawid riing ro è yao mua phlei? ");
INSERT INTO bgg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawid awai è sthun jigigam shii yao, Ithong è gui Ithong shii yao: Gui phazoi shii dug bo. ");
INSERT INTO bgg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Gu è na mak pho shii na lai iliing hà aruii sapho shii ne. ");
INSERT INTO bgg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawid è aishii Ithong ro ho; chiihphado, khi-èrek ne Masi ne Dawid ro riing rey phlei? ");
INSERT INTO bgg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Branthek zab aishii yoi ramuii shii, Isu è awai samoythek shii yao, ");
INSERT INTO bgg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Iphey yua pha Masdothek è nowbthan ne rai bo, ithek ne yung phiang guii srane lua yang bie ne bajarai hà ithek shii khung ne ilab phi pha ji shii bajo miie; chiih-è Jewish misiahòthek hà de ithua wie gua ne dug, chiih-è michie chie pha ishak shii de ithua wie shii gua ne dug. ");
INSERT INTO bgg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hanyie thek ne misiungthek è phua srane ithek hò shii riao maphi, chiih-è briig yi pha misiathek de bajo phiang sia! Ithek shii ne zab awiedang pha lago phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Isu è shan ne riig ramuii shii bukho branthek de Jewthek misiahò pha mizid japho ji shii lasen chabramuii pha doh, ");
INSERT INTO bgg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ai è bajo dusho misiungmuii de thama sikhi ididuii nyi chabramuii pha doh. ");
INSERT INTO bgg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ai è yao, gu nathek shii yao phro, ithek gai è de ji pha dusho misiungmuii è bajo chab ba ro. ");
INSERT INTO bgg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ithek miphi pha ji ne awaithek bukho rey ched ne khe pha ji è phi phro; jimagunde ai ne dusho magunde awai shii nyie um pha ji zab phi muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Giak samoythek è Misiahò pha chiang ji yao ramuii, hì pha wie pha lubao nane Hamangkhung-aphuii shii lasen zud pha ji ne khama khie dohramuii ro. Isu è yao. ");
INSERT INTO bgg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Zab pha nathek dohramuii pha ji ne doh jia ichiih pha ithua shii iphen jia rang de aled pha ishak thog ruii phro; zab shii buzam chuak dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ithek è sai, Masdo, “Hì ne khuchung rey ruii phlei? Chiih-è ji pha ishak thog sha ro è nyie khi-èrek ne doh yi phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isu è yao, “Nowbthan ne rai bo; nathek shii akhlam yi rabo. Gu beng è bajo branthek wuii ruii srane yao phro, gu ne ai ro! Chiih-è, Ai ne thog ro, jimagunde ithek miyao anuii rabo. ");
INSERT INTO bgg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Chiih-è mak rek rai ne gui rai dun pha yoi magunde nathek arum chid rabo, jithek ne igobi rey ruii pha chak ro, jimagunde jithek è jong pha ishak arey pha ro.” ");
INSERT INTO bgg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ai è yao ramuii, thiigpho chung de mak rek rai phro; zab riichai pho awaithek chung de mak rek rai phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jishii, sajiib de awiedang pha sam ruii phro, chiih-è chie niing pha oi pha rey ruii phro, chiih-è muathek thog ruii phro, chiih-è hamang è de khuchung de adoh ba pha nane rum pha blia doh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Hì thek rey pha ibi shii, gu chiang è nathek shii zum srane diig phi ruii phro; Nathek shii Jewthek misiahò hà miyao che ne sai ruii phro chiih-è phatheg hà de chab muii phro; nathek shii sajathek nane bohkhohphothek ibi shii noh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jine Mua Wie yao ithek ro pha chua ro. ");
INSERT INTO bgg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nawaithek khani shii khriig rek bi ne nawaithek shii khi-èrek ne ragia rek chid pha ji ne munow athiig chid rabo, ");
INSERT INTO bgg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nyieliieshii gu naro mak phothek è achang mua dang pha miyaogamthek nane khani phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nathek shii ne nawaithek aphuii amuii, nawaithek khuiinothek, nawaithek siangthangthek, chiih-è nawaithek ijakthek shii phi muii phro; chiih-è nathek giak shii ne ua muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gu chiang è nathek shii khiijai pha rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jishii nathek ro khrug è khaziang iphen jia de ashan yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chuh è riu bo, ji arone nathek ne ragia rek mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nathek Jerusalem shii armingthek shand ne riu pha doh arone nathek ne thieg bo Jerusalem ne jog chuak dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chiihphado è Judea shii um phothek ne phiingduii hà yoh chid phro, chiih-è hanyie rajan shii um phothek ne ji pha rajan ji thoh chid phro, chiih-è hanyie yi soh è fuang hà um pho ne ji pha rajan iliing hà awuii rabo. ");
INSERT INTO bgg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ji ne lago pha inaithek ro, jigigam shii nyie zey pha ji ne izai rey yi phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ji pha inai shii ne lui shii ani wiig pha hò-amuii nane ani ìu um pha amuiithek ne khama diig rey ruii phro! Chiih-è soh lakhung shii diig thog ruii phro, chiih-è Hamangkhung-aphuii ro lago ne jipha branthek shii thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Giak shii ne khamriie è ua muii phro, chiih-è giak shii ne zum srane phatheg hà chab ne zab pha soh hà noh dun phro; chiih-è nathek ishak athog sapho shii ne Jerusalem hà Hamangkhung-aphuii shii athieg pha branthek lai iliing hà ruii muii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Thiisa hà hasiang, habie nane dadiang de khuchung de arey pha ji rey dun phro. Ichiih sohnyiak pha zab soh ne nyie arek muluii pha khamuiiboh munoi ji è de rum dum phro, chiih-è khamuiiboh mujiiao ji de boh boh rey dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chiih-è ithek è rum srane sohnyiak shii diig thog ruii pha miyao ji khan srane iytho rey dun phro, hamangkhung pha bluthek pha ithek ro blia de sid dun phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chiihphado Bran Dufuii ne bajoboh blu nane biisiie rog sakhamiing è wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jithek pha ishak jao ne rey mage shii ithek jaifad srane khrug laziung hù bo, nyieliieshii ithek giawo ne nui sha ro. ");
INSERT INTO bgg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chiihphado Isu è ithek shii ji pha najang è yao, Iphem hingmuii shii nane gai pha hingmuiithek shii now mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nathek è ithek irab jao ne nyiu pha doh mage shii haluadam ne nui rey sha rone ithek ne thieg. ");
INSERT INTO bgg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ji duiine, nathek è ji rey pha doh mage shii nathek de thieg iang bo, Hamangkhung-aphuii ro Sajathua ji ne nui thog sha ruii ro. ");
INSERT INTO bgg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Now bo, hì thek pha zab miyao ne arey sapho shii ne ichiih rai pha branthek a-iy ba phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hamang nane sohnyiak ne san dun phro, jimagunde gu miyaogamthek ne khuchung de ashan phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nawaithek shii nowbthan ne rai bo, ithek bajo chie niing pha nane hì pha shud nawaithek sieng pha muno diig ne bajo ong ne aruii rabo, chiih-è ji pha ishak ne nathek shii zum pha ji ne hamblo è thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hì è rek phane zab pha sohnyiak pha branthek shii thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nowbthan ne idang sia ne chuh rey ne nyie rey ramuii pha ji è nathek yi ragia rek ne Bran Dufuii ibi shii riu mua pha rek bo. ");
INSERT INTO bgg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Isu è ji pha inai ishak phi srane Misiahò shii yua, chiih-è habuzuang rey mage shii ji pha habiu shii sumaro phiing hà rai pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hamiang rey mage shii branthek Misiahò hà airo miyaogam ji yoi pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sai ne Phiia ajiie pha Iweb chie pha ishak nui thog shii, nyie yi Hiiadun pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Khophabi nane Iphey yua pha masdothek ne branthek shii rum, chiih-è ithek ne ug ne Isu shii ua muii pha lumuii mua bidiang. ");
INSERT INTO bgg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chiihphado sakhathong è Judas iliing shii khud, snanyi Samoythek è jia shii hanyie shii Iskharioth ro è beng muii pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ji-è Judas yi boh phabi shii nane misiahò khan pha dumuiithek shii wuii srane Isu shii nyie khi-èrek ne zum mua ne ithek shii phi mua pha ji yao. ");
INSERT INTO bgg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ithek ne sang ne aishii bang phi pha ro è yao. ");
INSERT INTO bgg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas è ji nuii srane jao ne soh, chiih-è branthek è athieg yi pha chua wie shii Isu shii zum ne ithek shii phi pha rek. ");
INSERT INTO bgg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sai ne Phiia ajiie pha iweb chie pha inai thog mage shii Hiìadun pha ji shii chie pha shiishaiduiithek ua. ");
INSERT INTO bgg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Isu è Phithar nane Jon shii airo Hiìadun pha michie ji khriig rek iang bo è yung ne thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ithek è aishii sai, na è gathek shii khi hà khriig rek bo è yang lei? ");
INSERT INTO bgg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ai è chang, nathek rajan iliing hà wuii thog shii, hò-aphuii jia kho jariie han pha si ruii phro. Ai khi pha hò shii khud lei ne ai iidoh shii khud gieng bo. ");
INSERT INTO bgg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chiih-è hò muspho jishii sai bo, Masdo è yao muii ro, ithong nane samoythek Hiìadun pha michie chie pha ùgud khi hà lei? ");
INSERT INTO bgg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ai è nathek shii lakhung pha iiguno hà boh wie ùgud jia doh yi phro, thiisa hà zab khriig rek ne ruii pha mua phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Isu è ithek shii nyie khi-èrek yao lei ne ji duiine doh chiih-è ithek Hiìadun pha michie deb rek iang. ");
INSERT INTO bgg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ishak thog mage shii, Isu è awai rog shii boh pha samoythek noh ne thiibliie shii dug. ");
INSERT INTO bgg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ai è ithek shii yao, guro diig rey pha ishak athog ba pha ibi shii gu ithek rog shii dug ne Hiìadun pha ji chie pha now ro! ");
INSERT INTO bgg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ji-è gu nathek shii yao, Hamangkhung-aphuii ro Sajathua pha miyao ji izai arey sapho shii ne gu dinne achie phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chiihphado Isu è gog ji chiing srane, Hamangkhung-aphuii shii laso phi ne chiih-è yao, “Hì pha gog yie srane nawaithek chung thang ne niing bo. ");
INSERT INTO bgg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gu nathek shii yao phro Hamangkhung-aphuii pha Sajathua pha ji athog sapho shii ne gu hì pha phuii aniing phro.” ");
INSERT INTO bgg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chiihphado ai è iweb dum jia chiing srane Hamangkhung-aphuii shii laso phi ne ji srane, ithek shii phi ne yao, “Nathek shii phi pha iweb hì ne guro siu ro. Gu shii now pha hì rek bo.” ");
INSERT INTO bgg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ji duiine iweb pha ido shii ai è ithek shii gog phi ne yao, nathek shii thoi ramuii pha hì pha gog ne Hamangkhung-aphuii ro iwo shiinyie shii guro ifai è cheb rek ne phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Jishii riig bo! Hanyie è gu shii zum yi pha rek pha ji ne ichiih gu rog thiibliie shii dug ne um ro! ");
INSERT INTO bgg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bran Dufuii ne Hamangkhung-aphuii è yang pha duiine iy phro, jimagunde gu shii zum pho ne khama diig rey ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chiihphado awaithek chung jao ne sai rai, hì è rek ramuii pha ji ne hanyie lei? ");
INSERT INTO bgg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chiih-è ithek duchoi shii hanyie boh lei ne sai srane awaithek chung khnaing rai. ");
INSERT INTO bgg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Isu è ithek shii yao, Hamangkhung-aphuii shii athieg pha sajathek ne branthek lakhung shii blu rek, chiih-è bohkhohphothek è yao gathek ne branthek pha ijak ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jishii hì duiine nathek ne arek rabo; ji è nathek duchoi shii hanyie boh ji ne zab è ìu rey ruii phro, chiih-è dumuii ne khiao rey phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Chiih-è boh ne hanyie ga, chie ne dug pha ji boh ba, chiih-è michie phi pha ji boh ba? Dug pha jia ji boh ro. Jishii gu ne ithek duchoi shii khiao duiine ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nathek de gu diigchiao rek shii gu rog shii um gieng; ");
INSERT INTO bgg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chiih-è gu aphuii è gu shii bohkhoh pha rangsua phi pha duiine, nathek shii de gu è ji duii pha rangsua phi phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nathek de guro Sajathua hà guro thiibliie shii chie niing ne rai ruii phro, chiih-è nathek ne biangthek shii dug srane Israel pha snanyi jadthek shii bohkhoh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon! Yoi mage bo! raigpho è phiug shii igam è isug shii yoh rek pha duiine ithek shii wie è awie pha ji è yoh rek pha Sakhathong è rangsua muajong ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jishii Simon, naro migi è achiih yi pha, gu na shii siajong phi ro, chiih-è na ne gu shii iidoh khid shii na nawai khuiinothek shii migi chuh rek noh bo. ");
INSERT INTO bgg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Phithar è chang, “Ithong, gu de narog shii phatheg hà wuii ne narog shii iy gieng pha deb ro!” ");
INSERT INTO bgg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isu è yao, gu na shii yao, Phithar, “Khe a-ìo ba pha ibi shii na è gu shii athieg ro è uom chiing yao ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chiihphado Isu è awai samoythek shii sai, gu è nathek shii biia, baneb nane lakhia ayie yi pha thoh ge pha ishak shii ithek asiok pha rey ne bey? Ithek è chang, gathek shii nyie de diig arey ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Jishii thiih” shii ne, Isu è yao, hanyie shii biia nane baneb um phothek yie ruii bo; chiih-è hanyie shii khamriie oi arone nawaithek yung liu srane muduii pheg ne yie ne wuii bo. ");
INSERT INTO bgg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ji-è gu nathek shii yao, jigigam shii yao pha duiine, aishii ne mugo pho rog shii luajong muii ro. Gu shii nyie yao pha ji ne izai rey phro, nyieliieshii jigigam shii zey pha ji ne izai thog ruii ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Samoy jia è yao, riig mage bo Ithong! Ichiih shii khamriiethek nyi um ro, ai è chang, ji nyia ne khriig sha phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Isu ji pha rajan shii thoh srane idang awai mirek pha ji duiine sumaro phiing hà wuii dun, chiih-è samoythek de ai rog shii wuii gieng. ");
INSERT INTO bgg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ithek ji pha ithua hà thog mage shii, ai è ithek shii yao, “Nathek shii chuajan hà achiih yi pha sia bo.” ");
INSERT INTO bgg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chiihphado è ai ithek è lubao fen shii nyathog mua sapho ruang hà wuii srane lagiung niing ne sia. ");
INSERT INTO bgg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ai è yao, “Aphuii,” Na è yang arone hì pha diig gog ne gu è yie muii bo. Jishii gu miiyang è asi ro, na miiyang ji rey bo. ");
INSERT INTO bgg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hamangkhliie shii jia è wuii thog srane aishii chuh rek phi. ");
INSERT INTO bgg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Din ne de ai lubu bajo diig now srane bajo gang è siaramuii shii; airo hanyua ne ifai chen pha duiine nyiak lakhung shii chenramuii ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ai sia ched srane iidoh dun shii, airo samoythek yi duhug rek srane men pha doh. ");
INSERT INTO bgg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ai è ithek shii yao, nathek nyie rek ne men phlei? Nathek sieng srane chuajan hà achiih yi pha sia mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Isu ji yao ramuii shii snanyi Samoythek è jia Judas beng muii pha ji è bran iphiing shii noh srane, Isu shii wuii ne ai mizia shii khichiug. ");
INSERT INTO bgg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jishii Isu è yao, “Judas, nane mizia khichiug srane Bran Dufuii shii zum ne bey?” ");
INSERT INTO bgg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hanyie ai rog shii um pha samoythek è nyie reyramuii pha ji riig srane, ithek è Isu shii sai, “Ithong khamriiethek rek ne ithek shii che mage habey?” ");
INSERT INTO bgg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chiih-è samoy jia è Kho Phabi pha khiao jia shii airo phazoi pha kho hab chie mage. ");
INSERT INTO bgg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jishii Isu è yao, “Ji khriig sha phro!” Ai è ji pha bran kho shii khoh srane gang phi. ");
INSERT INTO bgg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chiihphado Isu è boh phabi shii chiih-è Jewthek misiahò ragia rek pha dukhothek nane ragia rekpho nane kho thiihchiih aishii sow pha wuiiphothek shii sai, nathek gu shii mugo pho ro è now srane khamriiethek nane muchang yie ne wuii ne bey? ");
INSERT INTO bgg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gu ne idang nathek rog Misiahò shii rai, jishii nathek è gu shii zum pha abidiang. Igiia pha blu è bokho mage shii, jishii nathek ishak ne hì bey? ");
INSERT INTO bgg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ithek è Isu shii zum srane kho phabithek hò hà noh dun shii Phithar de ruang è ai iidoh luagieng. ");
INSERT INTO bgg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sibiang pha duchoi shii bai fu srane ithek ang ne rairamuii shii Phithar de ithek rog shii bai anggieng. ");
INSERT INTO bgg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Khiao bimi jia è ai thiihchiih shii ithek rog shii dug ne rai pha doh mage shii ai è wie riig srane yao, hì pha bran de Isu rog shii um phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Jishii Phithar è asi ro è yao, “Hò-amuii jishii yao, gu ne aishii athieg ro!” ");
INSERT INTO bgg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Iùjia pha iidoh shii bran jia è Phithar shii riig srane yao, “Na de ai rog shii um phade ne!” Jishii Phithar è ji pha bran shii chang, “gu asi ro!” ");
INSERT INTO bgg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chiih-è ishak jia rey pha iidoh shii gai bran jia è de sriid è yao, hì pha bran de izai Isu rog shii um chak ro, nyieliieshii ai de Galili ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jishii Phithar è ji pha bran shii chang, na nyie yao ramuii pha ji ne gu athieg ro! Ai ji nya yao ramuii shii khthiie khe de èo dang phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ithong è Phithar shii rei srane wie riig mage shii, Phithar shii Ithong è aishii sudoh biu khe phuii a-ìo ba pha ibi shii na gu shii uomchiieng athieg ro è yao ruii phro è yao pha ji now khlei. ");
INSERT INTO bgg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Phithar fuang hà wuii srane bajo khiwegkho ne cho. ");
INSERT INTO bgg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Isu shii ragia rek pha bran ji è aishii zuang srane ai mirek jithek nui. ");
INSERT INTO bgg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ithek è ai mieg shii chiieg srane aishii sai, na shii hanyie muzuang lei? Than riig bo! ");
INSERT INTO bgg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ithek è aishii bajo makhakriing yao. ");
INSERT INTO bgg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hamiang rey mage shii, dukhothek, boh phabithek nane Iphey yua pha masdothek ò si, chiih-è Isu shii limiang moe hà noh. ");
INSERT INTO bgg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ithek è yao, “Gathek shii yao riig bo,” Na ne Masi bey? Ai è chang, gu è nathek shii yao magunde, nathek è gu shii migi anow phro; ");
INSERT INTO bgg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Chiih-è gu ithek shii musai sai magunde nathek gu shii achang phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Jishii sudoh è thiwing Bran Dufuii ne Hamangkhung-aphuii ro Bohblu pha ji pha phazoi shii dug ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ithek zab è aishii yao, “Chiihphado, na ne Hamangkhung-aphuii ro Dufuii bey?” Ai è ithek shii chang, nathek è yao arone gu ne ji chak ro. ");
INSERT INTO bgg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chiih-è ithek è yao, “Gathek ne na chiang shii dinne a-ìd chid sha, ai è nyie yao pha ji ne gathek è yoi jong.” ");
INSERT INTO bgg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Zab pha ibrog è jai srane Isu shii Philath ibi hà noh ne, ");
INSERT INTO bgg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ithek è jao ne aishii the, hì pha bran è gathek bran shii asi pha lumuii hà noh ne Bisiuthek shii de mijin athan chid rabo è yao phro chiih-è awai shii Masi, saja ro è yao pha chiang è zum phro. ");
INSERT INTO bgg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philath è aishii sai, “Na ne Jewthek pha saja bey?” Na è ji è yao arone gu ne ji chak ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chiihphado Philath è boh phabi nane bran ibrogthek shii yao, gu ne hì pha bran shii the mua pha nyie ichiig adoh phi ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jishii ithek bajo sriid è yao, ai awairo muyua ji è zab pha Judea pha branthek shii srobro rek. Ai Galili hà jao srane thuh shii ichiih de wuii thog sha dun ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Philath è ji yoi srane, ai è sai, “Hì pha bran yi Galilean chak bey?” ");
INSERT INTO bgg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ithek è Isu ne Herod è bohkhoh pha ithua pha ro è thieg mage shii, ithek è aishii Herod hà thoh ge, ji pha ishak shii awai de Jerusalem shii um. ");
INSERT INTO bgg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod è Isu shii riig mage shii bajo sang, nyieliieshii ai è ai chiang yoi srane ai Isu shii bajo inai è riig yang. Ai ne luthong ne Isu ro buang pha blia riig yang. ");
INSERT INTO bgg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ji-è Herod è Isu shii mushai bajo sai, jimagunde Isu è nyie de achang phi. ");
INSERT INTO bgg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kho phabi nane Iphey yua pha masdothek è dinne sriid rek srane Isu shii gidieg rek ne gang è the. ");
INSERT INTO bgg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod nane airo siphahithek è Isu makhakriing srane the yao; chiihphado ithek è aishii yung wie guii phi srane iidoh Philath shii thoh ge. ");
INSERT INTO bgg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ji pha iidoh shii Philath nane Herod de ijak rey khlei dun; ji pha inai ibi shii awaisa chung de shuang ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philath è kho phabi shii, dumuiithek shii nane branthek shii ò shii ho, ");
INSERT INTO bgg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","chiih-è ithek shii yao, “Ai è branthek shii asi pha lumuii shii noh ne lua phro è yao ne ithek è hì pha bran shii gu hà noh thog. Thiih, ichiih shii nawaithek de gu moe shii gu è aishii bujuii shii, chiih-è ithek è aishii the pha ji è ne ichiig adoh phi ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod è de aishii nyie ichiig adoh phi, ji è ai ne iidoh gathek shii thoh ge. Hì pha bran shii iy yi sapho nyie ichiig oi ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ji-è gu aishii zuang srane dun ge yi pha ro.” ");
INSERT INTO bgg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hiìadun pha ishak shii idang Philath è ithek ro phatheg pha bran jia shii thoh. ");
INSERT INTO bgg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Zab pha ibrogthek è gang ziak, “Aishii ne ua muii bo è yao! Chiih-è Barabas shii thoh ne gathek shii phi bo!” ( ");
INSERT INTO bgg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas shii phatheg hà chab pha ji ne ai è rajan shii awie pha blia rek chiih-è bran shii ua, ji è aishii ne phatheg hà chab phro.) ");
INSERT INTO bgg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Philath è Isu shii sey ne thoh yang srane ji è branthek shii wie è yao. ");
INSERT INTO bgg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Jishii de ithek è iidoh ziak dinne yao, “Aishii zun muii bo! Aishii zun muii bo!” ");
INSERT INTO bgg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philath è ithek shii uomchiieng yao sha, jimagunde ai ne nyie buii blia rek mua lei? Gu ne aishii ua sapho nyie ichiig adoh phi ro! Gu aishii zuang srane thoh mua pha ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Jishii ithek è bajo gang è ziak srane yao, Isu shii ne zun chid phro. Chiih-è iidohhè ithek miziak ji ne yang ge. ");
INSERT INTO bgg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ji-è Philath è ithek è Isu shii zun bo è lia pha ji shii ruii mua. ");
INSERT INTO bgg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ai è ithek chid pha bran jishii sey ne thoh phi hanyie è buii rek srane bran shii ua mua pha chiang è phatheg shii chab mua, chiih-è ai è nawaithek nyie rek yang pha ji rek bo è yao srane Isu shii ithek wad shii phi mua. ");
INSERT INTO bgg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Siphahithek è Isu shii noh ramuii shii, Simon beng pha Khyren soh pha rajan è wuii ramuii shii ithek è aishii si. Ithek è zum srane aishii de bai ji han yi ne Isu iidoh shii lua ba yi. ");
INSERT INTO bgg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bran iphiingthek de ai iidoh shii luagieng, ithek duchoi è giak hò-amuii è Isu shii bushun now srane cho ne luagieng. ");
INSERT INTO bgg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Isu è iidoh rai srane ithek shii yao, “Jerusalem pha hò-amuiithek! Nathek gu chiang è achoh chid rabo, jimagunde nawaithek shii nane nawaithek aniphiingthek shii choh bo. ");
INSERT INTO bgg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Irek pha inai thog ruii phro branthek è yao ruii, ‘Hanyie hò-amuii è khuchunde ani oi pho ne, hanyie shii khuchunde ani agiak pho ne, chiih-è khuchunde ani niu awang pho ne khama khirzey ro!’ ");
INSERT INTO bgg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ji pha ishak shii ne branthek è phiingthek shii yao ruii phro, ‘Gu lakhung shii chiih mage bo!’ Chiih-è phiingduiithek shii de yao gu shii ‘Ug phi bo!’ ");
INSERT INTO bgg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hing isieng ba shii rang de hìthek rey hing gow dun pha ishak rey mage ne nyie rey phlei?” ");
INSERT INTO bgg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Gai bran layog rek pha nyi shii de Isu rog shii ua pha noh dun. ");
INSERT INTO bgg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ithek Gadong rone beng pha ithua shii thog mage shii, ithek è Isu shii thiihchiih zun muii, chiih-è layog rek pha bran nyi shii de jia shii ai phazoi hà zun chiih-è jia shii ai phawik hà zun muii. ");
INSERT INTO bgg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Isu è yao, “ithek shii khung phi bo, Aphuii, ithek nyie rekramuii pha ji ne ithek ne athieg ro.” Ithek è siok fen srane airo yung yi awaithek chung thang rai. ");
INSERT INTO bgg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bran thek thiichiih riu ne Jewish dumuii thek è aishii biwo rek pha ji riigramuii, “Ai è gai shii ragia rek phi; ai ne Hamangkhung-aphuii mugua pha Masi chak arone awai shii ragia rek yi bo!” ");
INSERT INTO bgg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Siphahi jia de aishii biwo rek: ai è de wuii srane aishii igong thoh pha phuii wang, ");
INSERT INTO bgg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","chiih-è yao, “Na ne Jewthek pha saja chak arone nawai shii de ragia rek riig bo!” ");
INSERT INTO bgg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ai lakhung shii hì pha miyaogam zey ne um ro: “Hì ne Jewthek pha saja ro.” ");
INSERT INTO bgg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Thiichiih zun pha Layog rek pha bran jia de aishii biwo bajo rek ne yao: na Masi asi bey? Nawai shii de ragia rek bo chiih-è gasa shii de ragia rek mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gai jia ji è aishii giung, “Na ne Hamangkhung-aphuii shii arum bey? Na shii de ai mirek ji duiine mua ne bey. ");
INSERT INTO bgg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Giisa shii mua pha ji ne rangsua chak ro, nyieliieshii giisha nyi mua ne sapho ichiig rek pha ji mua phro; jimagunde ai ne nyie ichiig de arek.” ");
INSERT INTO bgg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chiih-è ai Isu shii yao, “Isu na Saja rey mage, gu shii de now bo!” ");
INSERT INTO bgg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isu è aishii yao, gu na shii sbang rek phro sudoh na de Hamangkhung hà gu rog shii um ruii phro. ");
INSERT INTO bgg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Hì rek pha ishak yi snanyi è uom ishak thog dang pha hasieng asiang pha soh zab biak rey dun; chiih-è Misiahò shii rang pha yungshaig ji de nyi rang ji dun. ");
INSERT INTO bgg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Isu goh gang è yao, “Aphuii wo! Gu ragung na wad shii ruii phro!” Ai ji è yao srane iy dun. ");
INSERT INTO bgg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Arming dumuii è nyie rey pha ji jithek riig srane Hamangkhung-aphuii shii chiong srane, yao, ai ne izai bran wie chak ara ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Branthek thiihchiih shii nyie rey pha ji riig pha khrab thog mage shii jithek doh srane ithek duhug rek ne awaithek lubutho phey ne iidoh hò hà dun dun. ");
INSERT INTO bgg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Khinyama phothek è Isu shii thieg, chiih-è Galili pha hò-amuii hanyie è Isu rog shii luagieng pha ji lua dang ne, ithek de ìujia ruang shii riu ne riig ramuii. ");
INSERT INTO bgg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Thiisa Judea pha Arimathea thawun pha bran Joseph beng pha jia um. Ai yi wie nane ilab um pha bran ro, hanyie è Hamangkhung-aphuii ro Sajathua wuii ruii pha ji khan ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ai ne limiang pha de dumuii ro, ai ne ithek munung nane ithek blia shii de anuii phi. ");
INSERT INTO bgg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ai è Philath moe shii wuii srane Isu ro siu iy ji lia. ");
INSERT INTO bgg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chiihphado ai è siu iy ji thazam yie srane yung wie è jiang srane, sak gang è chog ne hanyie de aruii ba pha wieng jishii ruii. ");
INSERT INTO bgg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hì yi sugrubari inai shii ro, chiih-è Jewish Thung pha Inai yi jao sha pha rek ro. ");
INSERT INTO bgg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galili pha hò-amuii hanyie è Isu rog shii luagieng pha ji de wieng shii Isu ro siu iy ji khi-èrek ne ruii lei ne riig pha Joseph rog shii wuii gieng. ");
INSERT INTO bgg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chiihphado è ithek iidoh hò hà dun srane wie no pha nane siie yie ne siu iy jishii shun phi pha saro. Jewish Thung pha Inai shii Iphey shii yao pha duiine ithek thung ne rai. ");
INSERT INTO bgg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Deobari pha hamiang bajo riang hò-amuiiphiingthek è saro pha sei nane wie no pha ji yie srane wieng hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ithek shii riig shii wieng cho ji bin pha lubao ne hong dun pha doh. ");
INSERT INTO bgg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ji-è ithek iliing hà wuii srane riig shii; jimagunde ithek Ithong Isu ro siu iy ji adoh. ");
INSERT INTO bgg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ithek ne thiihchiih shii ji riig srane ayaomuluii ne riu ramuii shii, hamblo è bran nyi yi yung imo chuang srane ithek moe shii riu thog mage. ");
INSERT INTO bgg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bajo rum srane, hò-amuiithek è nyiak lakhung shii bam, bran ji è ithek shii yao, “Nyie rek ne nathek ne bran sieng shii iydun rone sow phlei? ");
INSERT INTO bgg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ai ne ichiih shii oi ro; ai ne hòijong ro. Ai ne Galili hà ba shii ithek shii nyie yao pha ji now mage bo. ");
INSERT INTO bgg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Bran Dufuii shii ne zum srane layog bran shii phi ne bai shii zun muii phro, chiih-è da-uom shii ne hòi din phro.’ ” ");
INSERT INTO bgg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chiihphado shii hò-amuiithek è ji pha miyao now, ");
INSERT INTO bgg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","wieng è iidoh dun ne, jithek pha miyaogamthek ji zab samoy snajia shii nane gaithek shii de yao. ");
INSERT INTO bgg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ji pha hò-amuii thek yi Mery Magdalene, Joana, Jems amuii Mery; ithek nane gai hò-amuiithek rog pha ji è boh pha samoythek shii yao. ");
INSERT INTO bgg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jishii samoythek è hò-amuiiphiingthek miyao ji yi thaluii ro è now, chiih-è ithek shii migi arek. ");
INSERT INTO bgg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jishii Phithar è jai srane wieng hà ran dun; ai jiing ne riig shii aishii jiang pha yung ji ne um, jimagunde gai ne nyie de oi. Chiihphado ai iidoh hò hà dun srane nyie rey dun ro è wiengphleg dun. ");
INSERT INTO bgg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ji pha ishak shii Isu ro samoy nyi yi Jerusalem è snajia labiang è ruang Emaus hà wuiiramuii shii, ");
INSERT INTO bgg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","chiih-è isa chung jithek rey pha miyao ji yao ramuii. ");
INSERT INTO bgg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ai è yao ne muloramuii shii, Isu yi wuii thog srane isa rog shii luagieng; ");
INSERT INTO bgg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ai è aishii doh, jimagunde de isa è aishii athieg mua. ");
INSERT INTO bgg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Isu è isa shii yao. “Nawai sa ji lua srane, nyie mulo raimuii lei?” Ai thiichiih shii mizia duhug rey srane riu dun. ");
INSERT INTO bgg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Khleophas, beng pha jia ji è, aishii sai, “Na ne ichiih Jerusalem shii biwen wuii ne bey, ìujia pha nai ibi nyie rey pha ji ne na athieg ba bey?” ");
INSERT INTO bgg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ai è sai, “Nyie rey phiiga?” Ithek è chang, Nazareth pha Isu shii rey pha ji ro. Ji pha bran ji ne chaig ro, ai nyie yao pha nane nyie rek pha ji ne bohblu um rone Hamangkhung-aphuii nane branthek è de yoi. ");
INSERT INTO bgg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gathek ro boh phabi nane bohkhoh phothek è aishii ne zum ne ua muii pha phi muii, chiih-è aishii ne bai shii zun muii phro ");
INSERT INTO bgg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Chiih-è gathek muluthong ne ai ne jia phro Israel shii lam phi pha ji ne! Hì thek zab rey pha ne sudoh da-uom rey sha ro. ");
INSERT INTO bgg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gathek ibrog pha giak hò-amuiithek è ithek buzam wieng hà wuii dun shii, gathek shii de wieng ba yi, ");
INSERT INTO bgg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jishii airo siu iy adoh. Ithek iidoh dun srane yao ithek è ibang shii hamangkhliie shii doh phro, hanyie è yao ai ne isieng ro. ");
INSERT INTO bgg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Gathek è giak ibrogthek è wieng hà wuii srane hò-amuiithek miyao ji duiine riig shii, jimagunde ithek è aishii adoh phi. ");
INSERT INTO bgg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chiihphado Isu è ithek shii yao, “Nathek ne khama bi-ìe ro, ithek ne chaigthek miyao jishii zab migi rek pha khama rasey ara ro! ");
INSERT INTO bgg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Masi ne diig rek srane awairo biisiie shii khud pha mugak asi bey?” ");
INSERT INTO bgg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chiih-è Moses mizey pha jigigam ji è jao ne chaigthek mizey pha jigigam ji è yie srane awai shii khi è yao ne zey ne um pha miyao Isu è ithek shii isiie è yua. ");
INSERT INTO bgg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ithek wuiiramuii pha thiig ji nui thog mage shii, Isu yi ai è ibi wuii pha now; ");
INSERT INTO bgg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Jishii isa è aishii gak srane, yao, “Ga sa rog shii rai bo, inai jong ne igiia rey shii pha rek ro.” Ji-è ai iliing khud srane isa rog shii raigieng. ");
INSERT INTO bgg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ai de chie pha isa rog shii duggieng srane iweb yie khirzey sia; chiiphado è ai iweb ji srane ithek shii de phi. ");
INSERT INTO bgg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chiihphado è isa mieg de hong srane Isu shii thieg ge, jimagunde ai ne ithek mieg è ruang rek muii. ");
INSERT INTO bgg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ithek chung yao rai, ai è lumuii hà gethek shii jigigam ji wie è yua srane yao shii bai duiine gethek shii ahang bey? ");
INSERT INTO bgg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ai jai srane Jerusalem hà iidoh dun din shii, thiisa hà samoy snajiathek yi ò khrab ne gai rog shii um iang ");
INSERT INTO bgg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","chiih-è yao, “Ithong ne izai hòi dinro! Ai ne Simon shii doh yi!” ");
INSERT INTO bgg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chiih-è isa nyi è lumuii hà nyie rey pha ji nane iweb chie shii khi-èrek ne Ithong shii thieg pha jithek ithek shii wie è yao. ");
INSERT INTO bgg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ji pha bran nyi è jithek yao ramuii shii, hamblo è Ithong awai yi ithek shii riu thog srane ithek shii yao, “Liijiing ne nathek rog shii um bo.” ");
INSERT INTO bgg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ithek ne rum dun srane, inow ithek ne bi-iy riigramuii. ");
INSERT INTO bgg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jishii ai è ithek shii yao, nathek nyie rek ne sham ne rum phlei? Nyie rek ne nathek khani shii è rek ne now phlei? ");
INSERT INTO bgg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Guro wad nane lai shii riig mage bo, hì ne gui chak ro, gu shii hìog srane riig bo, ji arone nathek thieg ruii phro, bi-iy shii ne ibey nane izaing oi phro, jishii nathek riig bo gu shii ne um ro. ");
INSERT INTO bgg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ai hì è yao srane ithek shii awai wad nane lai shii riig ba yi. ");
INSERT INTO bgg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jimagunde ithek è migi arek mua, ithek ne bajo lubo ne wiengphleg dun shii; ai è ithek shii sai, “Ichiih nathek shii nyie magunde chie pha um bey?” ");
INSERT INTO bgg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ithek è aishii ù dau jia phi, ");
INSERT INTO bgg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ai è yie srane ithek moe shii chie. ");
INSERT INTO bgg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chiihphado ai è ithek shii yao, “Hì thek zab miyao ne gu nathek rog um ba shii yao mujo phro: Gu chiang shii Moses pha Iphey shii chaigthek è zey pha ji nane suthun shii zey pha ji ne izai rey ro.” ");
INSERT INTO bgg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chiihphado shii ai è ithek shii jigigam pha miyao ji gao yi pha khani hong phi, ");
INSERT INTO bgg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","chiih-è ithek shii yao, “Hì ne nyie zey ga: Masi ne diig rek srane iy ne da-uom shii hòi din phro, ");
INSERT INTO bgg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ai ibeng pha mua ji è lubukhied pha nane layog è khung phi pha Jerusalem è jao ne zab riing pha shii yao chid phro. ");
INSERT INTO bgg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nathek ne hì pha miyao khagiphothek ro. ");
INSERT INTO bgg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chiih-è gu aphuii è gu shii nyie sbang rek pha ji ne gu nathek shii thohge phro. Jishii lakhung è thazam nathek lakhung shii blu athog sapho shii ne rajan shii khan bo.” ");
INSERT INTO bgg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chiihphado shii ai è rajan thoh marui srane Bethany hà noh dun, ai wad laziung phia srane ithek shii khirzey phi. ");
INSERT INTO bgg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ai ithek shii khirzey phiramuii shii, chiih-è aishii ithek è che srane aishii Hamangkhung hà noh dun. ");
INSERT INTO bgg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ithek aishii sia srane bajo lubo rek ne Jerusalem hà iidoh dun din dun. ");
INSERT INTO bgg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chiih-è Misiahò shii awaithek ro zab ishak yi Hamangkhung-aphuii shii laso phi.");
INSERT INTO bgg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Soh rab pha ibi shii ne, Miyaogam ne umjong ro; ai ne Hamangkhung-aphuii rog shii um, chiih-è miyao ne Hamangkhung-aphuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Chiih-è Miyaogam ne igobi è Hamangkhung-aphuii rog shii um phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hamangkhung-aphuii è zab pha mana ne ai chiang è rab phro; jiè nyie um pha ji ne ai murab pha rangsua asi pha jia de oi dang phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ji-è Miyaogam ne sieng pha ithua ro, chiih-è sieng pha ithua ji è bran shii muchuang phi. ");
INSERT INTO bgg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chiih-è muchuang è igiia shii khlieng phi, chiih-è igiia ne khuchung de aishii a-ua mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hamangkhung-aphuii è awairo muapho shii thoh ge, ji pha bran beng ne Jon ro, ");
INSERT INTO bgg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hanyie yi bran shii muchuang chiang yua phi pha ji ro, jiè zab pha bran ai miyao ji nuii srane migi rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Awai sbang ne muchuang asi ro, ai ne muchuang chiang pha miyao ji yao pha wuii phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hì ne izai pha muchuang ro— muchuang sohjambling shii wuii srane bran shii chuang phi phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Miyaogam yi sohjambling shii um phro, chiih-è miyao ji è Hamangkhung-aphuii è sohjambling shii rab phro, jishii thuh de sohjambling pho ne aishii athieg ba ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ai ne awairo soh hà wuii shii, jishii awairo bran è aishii aho ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Chiih-è hanyie magungde aishii ho ne migi rek arone, aishii ne Hamangkhung-aphuii ro ani rey yi pha ai è rangsua phi phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ithek ne bran pha aphuii è giak pha duiine asi ro, Hamangkhung-aphuii ne nathek ro Aphuii ro; ");
INSERT INTO bgg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Miyaogam è bran rey srane bajo bushun nane izai rek ne gethek rog shii rai gieng, gethek è airo biisiie riig, airo biisiie ne Aphuii ro Dufuii iphen ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon è choh srane ai chiang ji yao phro, hì ne ji ro, gu è nathek shii yao pha ji ne, ai ne gu è iidoh wuii ruii phro, jishii ai ne gu è de boh ba ro, nyieliieshii ai ne gu agiak ba pha ibi è um ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ai ro ley bushun ne gethek zab shii khirzey phi phro, chiih-è gethek shii airo khirzey jia jia shii phi. ");
INSERT INTO bgg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hamangkhung-aphuii Iphey ne Moses è phi phro, jishii izai nane bushun ne Isu Masi è phi thog phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hanyiejia de Hamangkhung-aphuii shii adoh ba ro. Hanyie yi Hamangkhung-aphuii duii pha Hamangkhung-aphuii Dufuii iphen ji è doh bie ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","“Na ne hanyie lei?” Ne sai pha Jewish riichai è Jerusalem pha phabi nane liwithek shii Jon moe hà thohge. ");
INSERT INTO bgg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon è aishii chang pha agak pha jishii sang gang è chang: “Gu ne Masi asi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Ithek è sai. Chiihphado na ne hanyie lei?” “Na ne Elija bey?” Jishii Jon è chang, gu ne Elija de asi ro. Chiih-è dinne ai è sai. Chiihphado nane Chaig ji bey? “Ji de ai è chang, gune ji de asi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chiihphado ai è aishii yao, “Na gathek shii yao riig bo na ne hanyie lei?” Nyieliieshii na è nawai shii nyie ro è yao lei? Nashii sai yi pha gathek shii thohge pho shii gathek de nyayao mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon è aishii chang, Aijaya chaig pha è yie ne gune balimuang jabiing hà è Ithong lua pha lumuii miang rek iang bo è yao ne ziak pha goh ji ro! ");
INSERT INTO bgg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pharisithek è hanyie shii thoh ge pha muaphothek re-è, ");
INSERT INTO bgg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","dinne Jon shii sai, “Na ne Masi de asi, chiih-è Elija de asi, chiih-è ji pha Chaig de asi, chiihphado na nyie rek pha khowo phi phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon è chang, “Gune kho è khowo phi bie phro, jishii nathek ne athieg ba ichiih gethek duchoi shii um pha ji ne. ");
INSERT INTO bgg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ai ne gu è iidoh wuii ruii phro jishii gune airo lakhia thang de asey mua phro.” ");
INSERT INTO bgg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hì pha miyao yi Bethany pha hayang ithua Jordan khamuii hà Jon è khowo phiramuii shii rey phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ji è rek ched pha thimiang shii Jon è Isu yi aishii wuii pha ji doh, ichiih shii ne hanyie sohjambling pha layog shii so rek phi pha Hamangkhung-aphuii pha shiishaiduii um ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hì pha bran ne gu iidoh wuii ruii phrone gu è nathek shii yao pha ji ro, jimagungde gu è de ai boh ba ro, nyieliieshii gu giak pha ibi shii ai ne umjong ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Gu ne ai hanyie rai lei ne athieg ba ro, jishii gune kho è khowo phi pha wuii bie ne ai chiang shii Israel pha bran shii thieg yi pha rek phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Chiih-è Jon è ji pha miyao ji yao: Gu è ragung yi khua-atham mia srane hamangkhung è thazam khe srane ai lakhung shii jo pha doh phro. ");
INSERT INTO bgg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gune thuh de ai ne jia chak rone athieg mua ba ro, jishii hanyie è gu shii kho è khowo phi bo è thoh ge pha Hamangkhung-aphuii è iyao phro, nane ragung yi bran lakhung shii wuii ne jo pha doh ruii phro, ai ne Ragung So è khowo phi phrone yao pha ji ne airo. ");
INSERT INTO bgg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jon è yao, “Gu ne aishii doh, chiih-è gu nathek shii yao phro, ai ne Hamangkhung aphuii ro Dufuii chak ro.” ");
INSERT INTO bgg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ji pha thimiang inai shii Jon yi dinne awairo samoy nyi rog shii riu ne rai ramuii shii, ");
INSERT INTO bgg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ai è Isu luaramuii pha ji doh srane. “Ai è yao, the jine Hamangkhung aphuii ro shiishai ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chiihphado samoy nyi è ai miyao ji yoi srane Isu rog luagieng. ");
INSERT INTO bgg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isu è isa yi ai iidoh shii lua pha ji riig srane iidoh riie ne riig ne sai, isa nyie riig ramuii lai?” Ai è chang, “Na khi hà rai phlei Rabi” (Hì pha miyaogam yi “Masdo” ro è yao.) ");
INSERT INTO bgg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ai è chang, Chiihphado thawuii srane riig bo. (Ji è rek pha ji ne habjuang ishak wi rey shii ro). Ji-è ai de ai rog shii wuii srane ai khi hà rai pha ji riig, ne ji pha inai ne ai rog shii rai marui ");
INSERT INTO bgg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ai è jia yi Andrew Simon Phithar ro ikhuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ai è ibam Simon shii nya si dang mage shii ai è Simon shii yao, Gathek è Masi shii doh phro. (Hì pha miyaogam pha miyaosiu ne Masi rone yao ro.) ");
INSERT INTO bgg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chiihphado ai è Simon shii Isu hà noh ne wuii dun. Isu è aishii riig srane ne yao, na ne Jon ro dufuii Simon beng ro, jishii na shii ne Khephas ho ro. (Hì pha miyao yi Phithar shii sak ro è yao pha ji duiine ro). ");
INSERT INTO bgg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ji pha thimiang duiine Isu Galili hà wuii pha phak ramuii. Ai è Philiph shii sai srane yao, “Na gu rog shii wuii gieng bo” ");
INSERT INTO bgg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Philiph yi Andrew nane Phithar rai muii pha thawun Bethsaida pha ro.) ");
INSERT INTO bgg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philiph è Nathanael shii sai srane yao, gathek ne aishii mua jong ro, ai chiang shii Iphey pha siog shii Moses è zey ne um pha duiine, chiih-è chaigphothek è de zey jong. Ji ai ne Nazareth pha Joseph ro Dufuii ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Nathanael è aishii sai. Nazareth è de blia wie nyarey mua ne bey?” Philiph è chang thawuii ne riig bo. ");
INSERT INTO bgg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Isu è Nathanael yi ai moe hà wuiiramuii pha ji riig srane yao, ichiih shii de izai pha Israelthek um ro; aishii ne nyie de biidiie oi dang ro! ");
INSERT INTO bgg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael è Isu shii sai nathek khi-èrek ne gu shii thieg phlei? Isu è aishii chang, Philiph è na shii aho ba pha ibi ithek iphem muii iliing hà rai ramuii shii doh jong ro. ");
INSERT INTO bgg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael è chang, “Masdo” Na ne Hamangkhung-aphuii ro Dufuii ro! Chiih-è na ne Israel pha Saja ro! ");
INSERT INTO bgg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chiihphado Isu è aishii sai, gu è nathek shii iphem muii bucho hà doh phro è yao pha miyao pha chiang ne nathek migi now bey? Jishii gu na shii yao ithek hì è de dinne bajo boh blia doh ba ruii phro! ");
INSERT INTO bgg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chiih-è ai è ithek shii yao, gu na shii izai yao: Nathek ne hamang hong pha doh srane Bran Dufuii lakhung shii Hamangkhung-aphuii pha hamangkhliie laziung dun ne thazam wuii pha de doh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nai danyi pha iidoh shii Galili pha Khana thawun pha shii phiyiy rey ramuii. Thiisa hà Isu ro amuii de um, ");
INSERT INTO bgg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","chiih-è Isu nane airo samoythek shii de phiyiy hà ho. ");
INSERT INTO bgg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chiih-è phuii phi ched srane, Isu ro amuii è yao, ithek shii ne phuii aled sha ro. ");
INSERT INTO bgg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Isu è chang, “Nathek ne gu shii ayao chid rabo gune nyie rek chid,” “Guro ishak ne thuh de athog ba ro.” ");
INSERT INTO bgg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chiihphado Isu ro amuii è airo khiaothek shii yao, “Ai è nyie yung pha ji ne rek phi bo.” ");
INSERT INTO bgg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Thiisa hà Jew so shud pha jariie ruii pha duiine, thiichiih shii lubao pha kho jariie riig um ro, ji pha jariie ji jia shii ne wieng jia jog nya zan mua pha um. ");
INSERT INTO bgg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Isu è awai samoythek shii yao, “Hì pha jariie shii kho ley zan mage bo” Ai è zab pha jariie shii kho ley phrid dang pha zan, ");
INSERT INTO bgg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","chiih-è aishii yao, kho giak yi fuang hà thoi srane michie pha ilkhi bran shii phi mage bo. Ai è kho ji yi, ");
INSERT INTO bgg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ji-è rek ne yie shii michie rek pha ilkhi jiè chai ne riig shii, kho jine phuii rey dun. Jimagungde ai hì pha phuii khi è khia thog phaji ne athieg (jishii ji pha phuii khi è khia pha ji ne kho chau pha khiao ne thieg); jiè ai è phiyiy bufuii shii noh ");
INSERT INTO bgg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","srane yao, igobi shii zab ne phuii wie phi ne niing, chiih-è biwen è lumuii niing ched pha iidoh shii phuii bsieng ji phi, jishii na ne phuii wie ne thuh de ruii bamuii ro! ");
INSERT INTO bgg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Isu è hì pha igobi buang ne Galili pha gaithek shii rek srane, airo biisiie doh yi, chiih-è airo samoy de aishii migi now. ");
INSERT INTO bgg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ji-è rek ched pha iidoh shii, Isu nane airo amuii, chiih-è airo ikhuii chiih-è airo samoy Khaphernaum hà wuii srane thiisa hà dajiadanyie rai dun. ");
INSERT INTO bgg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hiìadun pha ji Sai pha ishak rey ramuii shii, Isu Jerusalem hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Thiisa Hamangkhung-aphuii Misiahò hà suwuii, shiishai, pharothek, chiih-è bang zia ne thiibliie shii dug ne um iang pha doh. ");
INSERT INTO bgg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ji-è ai ne ithang è rab srane Misiahò pha suwuii shiishai pharo nane thiibliie shii phung srane bang smed dayiingdayang rek maphi ");
INSERT INTO bgg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Chiih-è pharothek liu pha bran shii de yao ichiih è yie srane dun bo, guro Aphuii hò ne chongjai rek pha hò arab ro. ");
INSERT INTO bgg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Airo samoythek è jigigam shii zey ne um pha ji shii nowkhlei, “Naro hò shii gu è sai pha ji ne, Oh Hamangkhung-aphuii gu shii ne bai duiine hang muii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chiih-è Jewthek pha dumuii è musai rog shii aishii yao, ithek shii hì rek pha rangsua um rone yao pha nathek gathek shii nyie buang rek ne doh mua yi phlei? ");
INSERT INTO bgg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isu è yao, hì pha Misiahò shii chuak bo chiih-è gu da-uom shii nyarung din mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hì pha Hamangkhung-aphuii Misiahò rung pha ne sawi è riig idam chia chiih-è na ne da-uom shii nyarung mua ne bey? ");
INSERT INTO bgg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jishii Isu è yao pha Hamangkhung-aphuii Misiahò jine awai siu shii yao phro. ");
INSERT INTO bgg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ji-è ai iy ne hòi mage shii airo samoythek è ji pha miyao nowkhlei, chiih-è ai ji pha jigigam ji now srane Isu è nyie yao pha ji migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hiìadun pha ishak shii Isu ne Jerusalem hà um shii bran è airo buangthek rek pha ji riig srane ai è aishii bajo è migi now. ");
INSERT INTO bgg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jishii Isu awai de ithek shii migi anow, nyieliieshii ai ne ithek ro zab lubu ne thiegjong. ");
INSERT INTO bgg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Thiichiih shii ai chiang shii nyie de ayao, nyieliieshii ai ne ai lubu ne ìd jong. ");
INSERT INTO bgg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Thiichiih shii Pharisithek pha ibrog pha ro Jewthek dumuii Nekhodemus beng pha jia um. ");
INSERT INTO bgg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Habjuang jia shii Nekhodemus è Isu hà wuii srane yao, “Rabi, gathek è na shii thieg jong, chiih-è na shii ne Hamangkhung-aphuii muthoh ge pha masdo ro. Nyieliieshii Hamangkhung-aphuii nathek rog shii oi arone nathek mirek pha buang hì ne arek mua.” ");
INSERT INTO bgg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isu è chang, “Gu nathek shii izai yao: Nathek dinne iwo è agiak sapho shii ne Hamangkhung-aphuii ro Sajathua adoh mua phro.” ");
INSERT INTO bgg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nekhodemus è sai, “Bran weg rey ne dinne khi-èrek ne giak mua mage phlei? Chiih-è dinne amuii lui hà khud ne dinne agiak muii phro!” ");
INSERT INTO bgg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","“Din ne Isu è chang, gu na shii izai yao,” Hanyie magunde kho nane Ragung è agiak sapho shii ne Hamangkhung-aphuii pha Sajathua shii akhud mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bran siu è giak pho ne siu rey phro, chiih-è Ragung è giak pho ne Ragung rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gu è nathek shii dinne iwo giak chid phro è yao pha ji ne nathek awiengphleg chid rabo. ");
INSERT INTO bgg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hasam yi khi hà sam yang pha ji hà sam phro, chiih-è nathek ai è ro pha ji ne yoi, jimagungde khi è thog chiih-è khi hà dun pha ji ne nathek ne athieg ro, jiè hanyie yi Ragung è giak ji duiine ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Nekhodemus è sai, hì khi-èrek mua mage phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isu è chang, nane Israel pha boh masdo ro, jirang de a-ìd ba bey? ");
INSERT INTO bgg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ji-è gu na shii izai phosro gu nyie thieg ji yao chiih-è nyie doh lei ne ji yao, jishii na ne gu miyao ne anuii. ");
INSERT INTO bgg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nathek ne gu è sohjambling pha miyao yao pha rang de nathek è migi arek, jiè Hamangkhung pha miyao yao arone nathek ne khi-èrek ne migi rek mage phlei? ");
INSERT INTO bgg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Chiih-è hanyie magungde hamangkhung hà adun ba ro, hamangkhung hà wuii phane Bran Dufuii hamangkhung è thazam wuii pha ji bie ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Chiih-è Moses è jabiing hà pham shii lakhung hà khurog yi pha duiine, Bran Dufuii shii de lakhung hà khurog yi phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ji-è hanyie magungde aishii migi rek arone idang pha chai muii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Chiih-è Hamangkhung-aphuii è sohjambling shii bajo miie rek ne awairo Dufuii iphen jia ji de phi muii, jiè hanyie magungde aishii migi rek arone ji pho ne khuchung de a-iy phro, jishii idang pha chai mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hamangkhung-aphuii è dufuii shii sohjambling pho shii the yi pha athoh ge ro, jimagungde ragia rek yi pha thoh ge. ");
INSERT INTO bgg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ji-è hanyie è Dufuii shii migi rek arone jishii ne achua ruii phro, chiih-è hanyie è aishii migi arek pho shii ne chua jong ro, nyieliieshii ai è Hamangkhung-aphuii ro Dufuii iphen shii migi arek. ");
INSERT INTO bgg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chua pha ji ne hì duiine ro, nyieliieshii muchuang sohjambling hà wuii thog shii, jishii bran è muchuang è ne igiia shii bushun rek, nyieliieshii ithek blia ne awie jiè ithek ne igiia shii miie. ");
INSERT INTO bgg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Hanyie magungde awie pha blia rek pho ne muchuang shii khiijai ruii phro, chiih-è muchuang hà de awuii phi phro, nyieliieshii ai mirek pha awie blia shii atho yi pha rek. ");
INSERT INTO bgg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jishii hanyie è izai è thok pha ji shii rek pho ne, muchuang hà wuii ruii phro, nyieliieshii ji pha muchuang è ne ithek è rek pha ji ne Hamangkhung-aphuii shii nuii chak rone doh yi phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chiihphado è Isu nane awairo samoy Judea du-uà hà wuii srane, thiisa hà dajiadanyi khowo phi ne rai. ");
INSERT INTO bgg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ji pha ishak Jon de Salim è lumuii ruang asi pha Aenon shii khowo phiramuii, nyieliieshii ji pha ithua shii kho bajo um. Chiih-è bran de aishii wuii srane khowo yie. ");
INSERT INTO bgg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Hì pha miyao yi Jon shii phatheg hà achab ba pha ibi shii ro.) ");
INSERT INTO bgg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon ro samoythek è Jew rog shii Sang shud pha zen pha miyao re-è khnaing rai. ");
INSERT INTO bgg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ji-è ai ne Jon shii wuii srane yao, “Masdo, nathek è yao muii pha bran na rog shii um pha bran ne hayang pha Jordan pha thrang um pha ji na ne thieg chak bey? Ai ne thuh shii khowo phiramuii ro, bran de ai hà wuiiramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon è chang, Hamangkhung-aphuii è aphi sapho shii ne hanyie shii magungde nyie de oi phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nawai ne gu è nyie yao pha ji yao pha khagi ro, gune Masi asi ro, jimagungde ai è gu shii ne ai è ibi thoh ge ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hanyie shii phiyiy bufuii um, ai ne phiyiy bimi pha ro, jishii phiyiy bufuii ro ijak ne hanyie è riu ne nuii shii phiyiy bufuii gow yoi mage shii bajo sang ruii phro: Hì duiine gu è sang pha ji ne zab rey ge ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gune ne ìu rey chid chiih-è ai ne bajo boh rey chid phro. ");
INSERT INTO bgg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hanyie yi lakhung è wuii lei ai ne zab è boh ro, chiih-è hanyie yi sohnyiak pha arone, ai ne sohnyiak pha miyao yao ruii phro, jimagungde lakhung è wuii pha ne zab è giu um ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Chiih-è ai ne nyie doh ne nyie yoi pha ji yao shii, jimagungde hanyie è airo mua ji ayoi phi ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jishii hanyie è ai mua ji yoi arone ai ne Hamangkhung-aphuii è izai rone yaothiakjong ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jishii hanyie shii Hamangkhung-aphuii è thoh ge pha ne Hamangkhung-aphuii pha miyaogamthek yao ruii phro, nyieliieshii Hamangkhung-aphuii è awai Ragung aishii zab ley phi srane thoh ge ro. ");
INSERT INTO bgg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aphuii è awai Dufuii shii bajo miie rek jiè zab airo blu shii phi muii. ");
INSERT INTO bgg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ji-è hanyie yi Dufuii shii migi rek arone, ai ne idang pha chai um ruii phro, chiih-è hanyie yi bran Dufuii shii migi arek arone ai ne chai amua ruii phro, jishii aishii ne Hamangkhung-aphuii ro lago mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pharisithek è yoi, Isu ne Jon è de yang ne bajo Khowo phiramuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Zai, Isu è ne hanyie shii de khowo aphi ro, airo samoythek è phi bie ro.) ");
INSERT INTO bgg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nyie yao phaji ne Isu yoi mage shii, ai Judea thoh srane iidoh Galili hà dun din marui; ");
INSERT INTO bgg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ji duiine ai de Samaria è dong ne dun pha rey. ");
INSERT INTO bgg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chiih-è ai Samaria pha thiig Sykhar beng pha ithua Jakhob è awai dufuii Joseph shii phi pha raig è lumuii ruang asi pha ji hà wuii thog. ");
INSERT INTO bgg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jakhob ro khabang de thiichiih shii um iang, chiih-è Isu lua srane jid ne thiichiih khabang shii dugdun, ji è rek shii hanai duchoi rey sha. ");
INSERT INTO bgg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samarithan pha hò-amuii jia kho chau pha wuii thog shii, Isu è ji pha hò-amuii ji shii yao, “Gu shii de kho niing pha phi bo.” ");
INSERT INTO bgg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ji pha ishak shii airo samoythek yi michie pheg pha bajarai hà wuii dun.) ");
INSERT INTO bgg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Chiih-è hò-amuii è chang, na ne Jew ro, chiih-è gune Samarithan ro—ji-è na ne gu shii kho niing pha khi è lia mage phlei? (Nyieliishii Jew ne Samarithan è giong pha shiikhiia nane gog shii agiong ro) ");
INSERT INTO bgg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isu è chang, “Hamangkhung-aphuii è nyie phi pha ji na ne ìd arone, na shii kho lia pha ji ne hanyie na ne thieg ne, aishii na ne lia ruii phro, chiih-è ai è na shii chai phi pha kho phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hò-amuii è aishii yao, “Masdo,” Na shii ne kho chao pha sikhen de oi, chiih-è khabang de bajo bucho hà. Ji-è na ne chai phi pha kho khi è mua mage phlei? ");
INSERT INTO bgg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Hì pha khabang ne gathek ro blang Jakhob è phi marui ro; ai nane airo dufuii chiih-è airo miiram de ji pha khabang è niing ro. Chiih-è na ne Jakhob è de boh ba rone yao ne bey? ");
INSERT INTO bgg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isu è chang, “Hanyie magungde hì pha kho niing arone dinne gahang-ahang sha phro.” ");
INSERT INTO bgg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jishii gu è phi pha kho yi hanyie è niing ai ne dinne gakhang-ahang phro. Gu è aishii phi pha kho jine gasuang duiine noi ruii phro, ji pha kho niing arone khuchung de gahang-ahang pha aishii ne idang pha chai phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chiih-è ji pha hò-amuii è chang, “Masdo,” Chiihphado ji pha kho gu shii de phi bo! Chiih-è khuchung de gahang-ahang sha phro, chiih-è dinne ichiih shii kho han phade awuii sha chid phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Isu è hò-amuii jishii yao, “Chiihphado na gey shii noh srane iidoh wuii din ruii bo.” ");
INSERT INTO bgg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ai è chang, “Gune thuh de gey oi ba ro.” Isu è hò-amuii jishii yao, na è gey oi ba rone yao pha ji ne izai chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Na ne bran guii shii geyjong ro, chiih-è thuh shii na rog shii um pha bran ji de na ro izai gey asi ro, jiè na miyao ji ne izai chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hò-amuii è yao, “Masdo” gu riig shii na ne chaig ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Guro Samarithan blangthek è ne Hamangkhung-aphuii yi phiing shii sia, jimagungde Jewthek nathek miyao ne Hamangkhung-aphuii shii sia pha ithua ne Jerusalem shii ro è yao. ");
INSERT INTO bgg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isu è Hò-amuii shii yao, na ne gu shii migi now bo, doh jia shii ji è rek pha ishak thog ruii phro, bran ne phiing lakhung shii de Aphuii shii asia chid phro, chiih-è Jerusalem shii de asia chid phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samarithan nathek è sia pha jishii ne nathek è athieg, chiih-è Jewthek gathek è sia pha ji shii ne gathek è thieg, nyieliieshii giawo rey phane gathek Jewthek è thog ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jishii ishak de thog sha ruii ro, chiih-è thuh shii de ji rek pha ishak ne umjong ro, chiih-è bran ne Hamangkhung-aphuii pha ragung pha blu izai Aphuii shii sia mage shii, ai nyie khi è chid pha ji izai misia ji aishii zid ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hamangkhung-aphuii ne Ragung ro, chiih-è Ragung pha blu è bran ne ai duiine izai è sia mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chiih-è hò-amuii jiè aishii yao, “Gu ne thieg Masi ne wuii ruii, chiih-è ai wuii thog srane zab miyao yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Isu è chang, gu na rog shii muloramuii pha ji ne ji ro.” ");
INSERT INTO bgg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ji-è rekramuii shii Isu ro samoythek iidoh dun thog, chiih-è Isu yi hò-amuii rog shii mulo pha ji riig srane bajo wiengphleg dun. Jishii ithek è, na nyie chid phlei? “Hanyie de hò-amuii shii nyie de ayao,” “Chiih-è ithek nyie rek ne hì pha hò-amuii rog shii mulo phlei ne de asai ro?” ");
INSERT INTO bgg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chiihphado hò-amuii jiè awairo kho jariie thiichiih thoh marui srane iidoh thawun hà dun ne bran shii yao, ");
INSERT INTO bgg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Thawuii ne ji pha bran shii riig bo, gu è nyie rek pha ji ne, ai è zab yao ro. Yang ne Masi ne ai asi bey? ");
INSERT INTO bgg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ji-è ai thawun shii thoh srane Isu hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hanai duchoi rey mage shii samoythek è Isu shii khung ne yao, Masdo, nyie magunde chie bo! ");
INSERT INTO bgg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jishii ai è chang, “Gu shii ne ji rek pha michie um ro, nathek ne athieg ba ro.” ");
INSERT INTO bgg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ji-è samoythek è awaithek chung yao rai, “Aishii gai è michie yi rey ne bey?” ");
INSERT INTO bgg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isu è aishii chang, “Gu michie ne ji ro,” hanyie è gu shii thoh ge pha airo miyao nuii ne lua, chiih-è ai è phi pha blia ji zab rek phi pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nathek ne hì è yao? Raig pha ishak ne habie wi um ba ro. Jishii gu nathek shii yao, raig shii wie è riig mage bo, yamiing chiig pha ishak reyjong sha ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ji-è yamiing chiig pho ne riinang mua ne idang pha chai iwoi chiig ruii phro, nyieliieshii raig hai pha Ithong nane raig chiig pha bran ne bajo ò shii sang ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hì è yao pha miyao ne izai chak ro, bran jia yi hai, chiih-è gai bran yi chiig. ");
INSERT INTO bgg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Gu è nathek shii khi hà blia arek pha gai è rek pha raig shii yamiing chiig pha thoh ge ruii phro ro, nyieliieshii nathek ne gai è blia rek pha raig è de phua yi. ");
INSERT INTO bgg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samarithan thawun pha bajo bran è Isu shii migi rek, nyieliieshii hò-amuii ji è yao, Isu è gu è rek pha ji zab yao. ");
INSERT INTO bgg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ji-è Samarithanthek è Isu shii wuii ne khung srane ai rog shii rai bo è yao, jiè Isu ai rog shii inai danyi rai. ");
INSERT INTO bgg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Isu mua ji è dinne branthek de aishii migi rek, ");
INSERT INTO bgg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chiih-è bran è ji pha hò-amuii jishii yao na miyao ji jia è migi now bie pha asi ro, nyieliieshii gathek è de ai miyao ji yoijong ro, chiih-è gathek ne thieg jong hì ai ne sohjambling shii ragia rek pha izai ji chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Thiisa hà danyi rai marui pha iidoh, Isu yi ithek shii thoh maruii srane Galili hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Awai è yao, “Chaigthek shii ne awai soh hà ne khuchung magunde ilab aphi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ai Galili hà thog mage shii, Galili pho è ilab rek ne ho iang, nyieliieshii Hiìadun Sai pha ishak shii Jerusalem hà ai è rek pha blia wie ji ithek è riig. ");
INSERT INTO bgg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chiihphado ai è kho è phuii rab muii pha ithua Galili pha thawun Khana shii iidoh wuii thog mage shii, thiisa hà Khaphernaum pha badri pha dumuii jia ro ani rad ne um iang. ");
INSERT INTO bgg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ai è Isu yi Judea è Galili hà wuii thog pha yoi mage shii, Isu shii wuii thog srane yao, Khaphernaum hà wuii ne gu dufuii shii gang rek phi bo, nyieliieshii ai ne iy sha pha rek muii ro. ");
INSERT INTO bgg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Isu è aishii yao, “Na ne buangthek pha blia ariig sapho shii ne migi arek ro.” ");
INSERT INTO bgg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ophis pha dumuii jiè chang, “Masdo,” gu dufuii a-iy ba pha ibi shii gu rog wuii gieng bo. ");
INSERT INTO bgg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isu è aishii yao, dun sha bo, “Na ro dufuii ne wie rey ge ro!” Chiihphado ji pha bran è Isu miyaogamthek ji migi now srane dun dun. ");
INSERT INTO bgg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ji-è rek ne ai dunramuii shii airo khiaothek si ne mua yao iang, “Naro dufuii ne wiejong sha ro!” ");
INSERT INTO bgg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chiih-è ji pha bran è aishii sai nyie ishak shii gu dufuii ne wie rey ge phlei? Chiihphado ai è chang, “Diyu ishak jia rey shii airo khrug rak pha ji ne wie rey ge ro.” ");
INSERT INTO bgg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chiihphado ai aphuii è nowkhlei, ji pha ishak ne diyu Isu è airo dufuii wie rey sha ro è yao pha ishak ji ro. “Ji-è ai nane airo hòpho zab migi rek dun.” ");
INSERT INTO bgg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea è Galili hà wuii pha iidoh Isu è buang pha blia yi nyi chiieng rek sha ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ji-è rey ched pha iidoh shii, Isu de Jerusalem hà giang sai pha ji shii wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chiih-è Jerusalem pha Shiishai Gak moe shii khabang rog shii sibiang guii rab ne um, chiih-è Hebrew è jishii bethzatha ro è yao. ");
INSERT INTO bgg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chiih-è Miegthi pha, lai aluii mua pha nane slemriie ne rai pha ji de sibiang shii bajo thieng ne rai. ");
INSERT INTO bgg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ithek ne kho sid pha ji khan ne rai, nyieliieshii ai ne Hamangkhungkhliie wuii ne kho shii nai pha ji khan ne rai. Kho ji nai mage shii hanyie yi igobi lung arone aishii ne nyie miiriie um magungde gang rey dun ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chiih-è dam sa-uom è miliao è rad pha bran jia de um. ");
INSERT INTO bgg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Isu è ai thiichiih shii um pha ji riig srane, chiih-è bajo idam è rad pha ji thieg srane; ai è ji pha bran shii sai, “Na wie rey pha now bey?” ");
INSERT INTO bgg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ji pha rad pha bran ji è yao, “Masdo, gu shii ne hanyie è de khabang ji nai mage shii wo phi pha oi ro, jiè kho ji nai pha ishak shii gu de wo pha rek riig shii, gu è ne ithek bi wo dun ro.” ");
INSERT INTO bgg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Isu è aishii yao, “Jai srane, Nawai lawiao chiing ne lua mage bo.” ");
INSERT INTO bgg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Khthiie ji pha bran ji gang rey srane, awai lawiao han srane jao ne lua. Ji-è rek pha inai shii yi Jew Thung pha inai ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ji-è Jewthek pha dumuii è gang rey pha bran ji shii yao, “Hì ne Jew Thung pha inai ro, hì pha inai shii na nawai lawio han phaji ne gathek Iphey shii gidieg rek ro.” ");
INSERT INTO bgg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ai è aishii chang, “Bran hanyie è gu shii gang rek phi pha ji è yao gui lawiao han ne lua bo è yung ro.” ");
INSERT INTO bgg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ai è ji pha bran jishii yao, “Hì rek bo è yung pha bran ji hanyie lei?” ");
INSERT INTO bgg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jishii wie rey pha bran jiè Isu shii athieg, nyieliieshii ji pha ithua shii bran iphiing um, chiih-è Isu ne ji pha ithua è khia jong dun. ");
INSERT INTO bgg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Doh aishii Isu è Misiahò hà si ne, Isu è aishii yao, yoi mage, na ne gang rey sha, jiè sudoh è thiwing na ne dinne layog arek sha rabo, yangne na shii din hì de lamuna awie pha rey mage phro. ");
INSERT INTO bgg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chiihphado ji pha bran è Jewthek dumuii shii wuii srane yao, gu shii gang rek pha bran ne Isu ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ithek è Isu shii riig ramuii, nyieliieshii ai è wie rek phi pha ne Jew Thung pha inai shii ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Isu è aishii chang, “Gu Aphuii ne idang blia rek phro, chiih-è gu de ai blia rek chid phro.” ");
INSERT INTO bgg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hì è yao pha ji è Jew ro dumuii è dinne Isu shii lamuna ua pha surui, nyieliieshii ai è Jew Thung pha inai pha Iphey ji chui bie pha asi pha, Hamangkhung-aphuii shii de awai Aphuii ro è yao, chiih-è dinne awaishii de Hamangkhung-aphuii è ò rab. ");
INSERT INTO bgg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ji-è Isu è aishii chang, gu nathek shii izai yao: Dufuii yi awai lum ne nyie de arek mua phro, ai ne Aphuii nyie rek pha ji riig srane rek bie phro, chiih-è Aphuii è nyie rek Dufuii de ji rek bie. ");
INSERT INTO bgg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aphuii è Dufuii shii miie rek ne, jiè Aphuii nyie rek pha ji ne Dufuii shii de doh yi phro, chiih-è dinne bajo boh doh ba yi phro, jiè nathek ne wiengphleg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aphuii è iyjong pho shii de hòi din srane chai phi pha ji duiine Dufuii de hanyie shii chid jishii hòi din yi pha ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aphuii è hanyie shii de achua phro, ai è chua pha ne awai Dufuii shii zab rangsua phijong ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ji-è zab è Aphuii shii ilab rek pha duiine Dufuii shii de ilab rek ruii phro. Chiih-è hanyie è Dufuii shii ilab arek arone aishii thoh ge pha Aphuii shii de ilab arek ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Gu nathek shii izai yao, hanyie è gu miyaogamthek yoi ne chiih-è gu shii thoh ge pha jishii de migi rek arone, aishii idang pha chai um ruii phro. Aishii ne achua ruii phro, jimagungde iy pha ji è hòi ne chai hà muajong ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ji-è gu nathek shii izai yao, ji rek pha ishak thog ruii phro, chiih-è ishak ne thogjong ro, chiih-è iy pha ne Hamangkhung-aphuii ro Dufuii gow yoi ruii phro, chiih-è hanyie è yoi jine chai hà thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aphuii awai yi chai phi pha ithua duiine, Dufuii de chai phi pha ithua rab phro. ");
INSERT INTO bgg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chiih-è ai è Dufuii shii gua pha rangsua phi ro, nyieliieshii ai ne Bran Dufuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hì pha miyao è awiengphleg chid rabo; nyieliieshii hì rek pha ishak de thog ruii phro, iyjong pho de ai muro yoi ruii phro ");
INSERT INTO bgg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","chiih-è ithek ro wieng è de wuii ruii phro: Chiih-è hanyie yi wie blia rek ne hòi pho ne sieng ne rai ruii phro, chiih-è hanyie yi layog rek ne hòi pho ne nin ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Gune gui riichai è nyie de arek mua phro; Hamangkhung-aphuii è nyie yao pha ji chua bie ro, jiè gu muchua ne izai ro, nyieliieshii gui è nyie rek yang pha ji ne gu asurui ro, jiè gu shii thoh ge pha ai nyie khi è now pha ji rek bie. ");
INSERT INTO bgg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Guro miyao yi gui è khagi yao arone, gu è nyie yao pha ji ne izai rone anow phro, ");
INSERT INTO bgg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","jishii guro miyao shii khagi yao pha ne yoh jia um ro, chiih-è gune thieg gu chiang shii nyie yao pha ji ai ne izai chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jon ne jia ro, nathek hanyie è aishii muaphothek thoh ge, ai è izai pha chiang shii yao. ");
INSERT INTO bgg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hì ne gu shii bran khagi achid phrone anow ro, gu è hì yao bie pha ji ne nathek de ragia rey bo. ");
INSERT INTO bgg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ne muchuang duiine ro, chiih-è hang ne khlieng, chiih-è nathek de phrak jia shii ne airo muchuang jishii ne wie than. ");
INSERT INTO bgg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jishii gune Jon è phi pha khagi è de boh khagi gui phi ruii phro, chiih-è gu nyie rek pha ji ne Aphuii è gu shii rek yi pha ji ro, hì è gu shii yao yi gu shii ne ai è thoh ge ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chiih-è gu shii thoh ge pha Aphuii ji è de guro yao phi, jishii nathek è ne ai miyao de ayoi, chiih-è airo mizia de adoh ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Chiih-è airo mua shii de nathek lubu hà aruii, jiè nathek aishii thoh ge pha jishii de migi arek. ");
INSERT INTO bgg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nathek ne jigigam shii ne tham bo, nyieliieshii nathek aishii ne idang pha chai um ro è now, chiih-è hì pha jigigam è de gu chiang shii yao. ");
INSERT INTO bgg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Thuh de nathek chai mua yi pha gu shii wuii pha ayang ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Gu ne bran è chiong pha ji asow ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jishii nathek ne khi-èrek pha bran gune thieg, chiih-è gune thieg nathek lubu shii ne Hamangkhung-aphuii pha miie oi ro. ");
INSERT INTO bgg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Gu ne gui Aphuii ro riichai rog shii wuii ruii phro, jishii nathek è gu shii achoi, chiih-è bran awai riichai rog shii wuii arone nathek aishii choi iwa. ");
INSERT INTO bgg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nathek ne gai è chiong mua pha now, jishii nathek ne iphen Hamangkhung-aphuii è chiong jishii ne yang pha abidiang ro. Chiihphado ji è rek arone gu shii khi-èrek ne migi rek mage phlei? ");
INSERT INTO bgg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Hì anow rabo, gune gu Aphuii ibi shii nathek shii nin wuii, chiih-è nathek shii nin pha ji ne Moses ro, nyieliieshii nathek è aishii bajo luthong phro ");
INSERT INTO bgg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nathek ne izai è Moses shii migi rek arone, nathek gu shii de migi rek, nyieliieshii ai è gu chiang shii zey. ");
INSERT INTO bgg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jishii nathek ai mizey jishii migi arek arone, nyie khi-èrek ne ithek gu miyao shii de migi rek mage phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ji pha iidoh shii, Isu Galili pha khabang hiia ne wuii dun (ji pha khabang ne Thiberias ro è de yao). ");
INSERT INTO bgg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jishii ai è bran rad pha ji shii buangthek pha blia rek ne gang phi pha ji riig srane bran ibrog ai rog shii luagieng. ");
INSERT INTO bgg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Isu phiing lakhung hà wuii srane awai samoythek rog shii dug. ");
INSERT INTO bgg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chiih-è ji pha ishak shii yi Hiìadun Sai pha ishak nui sha ro, ");
INSERT INTO bgg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Isu è shan ne riig khlei shii bran brog yi ai moe hà wuiiramuii pha doh, ji è ai Philiph shii sai, nyama pha bran shii chie pha michie khi è pheg mua phlei? ");
INSERT INTO bgg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Nyieliieshii ai è ji sai pha ji ne Philiph shii chai pha sai). Awai ne thieg jong ai ne nyie reg chid. ");
INSERT INTO bgg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ji pha iidoh Philiph è yao, nathek shii Ìujia chie pha iweb zab shii cho phane liiman sikhi wem nyi è huak ne pheg chid phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chiih-è airo yoh samoy jia, Simon Phithar beng mua pha ai khuii Andrew è yao, ");
INSERT INTO bgg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ichiih bufuii jia shii iweb guii nane ù nyi um ro. Jishii ji pha iweb nane ù è zab shii achie cho phro.” ");
INSERT INTO bgg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ji pha iidoh Isu è ithek shii yao, ithek shii dug yi mage bo. (Chiih-è thiichiih shii saing ire de bajo um.) Ji-è aishii ji pha lakhung shii dug, thiichiih shii bran itham guii um ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chiihphado shii Isu è iweb ji yi srane Hamangkhung-aphuii shii laso phi srane aishii thang, ji duiine uà jide yi srane ithek shii thang, Chiih-è ithek khama chie mua pha ji chie, chiih-è zab pha bran lumuii chie ched. ");
INSERT INTO bgg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ai è awai samoy shii yao, “Ikhe pha iweb ji khrab bo; nyieliieshii iweb amua yi rabo. ");
INSERT INTO bgg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chiihphado nathek è branthek chie ched pha iidoh shii iweb guii è ikhe pha idum-iriim yi sirid snanyi ley pha chiing. ");
INSERT INTO bgg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chiih-è Isu mirek pha buang pha blia rek pha ji riig srane, thiichiih shii um pha bran ji è yao, izai hì ne Chaig ichiih sohjambling shii wuiiramuii pha ji ro!” ");
INSERT INTO bgg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Isu è thieg ai ne aishii zum srane bangchiie airo Saja rab pha rek, jiè ai dinne phiing hà wuii din marui. ");
INSERT INTO bgg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Habjuang rey mage shii, Isu ro samoy ne buzam khabang hà wuii dun, ");
INSERT INTO bgg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chiih-è run shii in srane iidoh khabang thrang Khaphernaum hà dun din shii habjuang rey dun, jishii Isu de ai hà athog ba. ");
INSERT INTO bgg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ji è rekramuii shii hasam boh sam thog srane kho jishii sam ne jaw mage. ");
INSERT INTO bgg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chiih-è samoy run shii in srane guii riig labiang thog pha ran shii, Isu yi kho lakhung è lua srane ithek hà rai ne wuii ruii, ithek ji riig srane rum dun. ");
INSERT INTO bgg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Isu è aishii yao, “Arum chid rabo, hì ne gu ro!” ");
INSERT INTO bgg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chiihphado ai è Isu shii sang ne run lakhung hà dug noh, chiih-è run yi khthiie ai khi hà wuiiramuii pha soh hà thogdun. ");
INSERT INTO bgg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ji pha thimiang duiine khabang ring shii rai pha bran brog è riig shii thiisa hà ne run ne ji jia bie. Chiih-è ai ne thieg Isu ne samoythek rog shii awuii gieng, chiih-è samoythek de aishii thoh marui ne wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chiihphado shii Thiberias è ran pha run yi thiichiih Ithong è laso phi srane bran brog shii iweb chie noh pha iring ji pha moe shii ran thog. ");
INSERT INTO bgg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bran brog è riig shii Isu ne thiichiih shii oi, chiih-è airo samoythek de thiichiih shii oi, ji è ithek de ji pha run è in srane Isu shii sow pha Khaphernaum hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chiihphado è khabang thrang hà Isu shii doh srane, ithek è aishii sai, “Masdo, na ne isa hà khuchung wuii phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isu è aishii chang, gu nathek shii izai yao dang phro: Nyieliishii nathek è gu shii sow pha ji ne nathek ne thuh de buangthek pha blia ji doh ne sow pha asi ro jimagungde nathek ne iweb chie pha nane nathek shii nyie chid pha ji mua dun pha ji musow ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Awie pha rey pha michie pha blia arek rabo, ji pha chiang shii ne, idang chai um pha michie pha blia rek bo. Chiih-è ji pha michie ne Bran Dufuii è nathek shii phi ruii phro. Nyieliieshii Hamangkhung-aphuii pha Aphuii è, ai lakhung shii cheb che ne bah jong ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ji-è ai è aishii sai, “Gathek è Hamangkhung-aphuii munow pha blia jine khi-èrek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isu è aishii chang, “Hamangkhung-aphuii è nyie now pha ji ne hì ro, nathek ai mutho ge pha ji shii migi rek bo.” ");
INSERT INTO bgg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ithek è chang, chiihphado gathek è aishii migi rek pha ithek è gathek shii buang pha blia nyie rek ne doh noh phlei? Na è nyie rek ge phlei? ");
INSERT INTO bgg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jigigam shii yao pha duiine gathek blangthek è balimuang shii Hamangkhung è chiih pha mana chie pha ji duiine ai de gathek shii hamangkhung è iweb phi ruii habey? ");
INSERT INTO bgg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Isu è yao, “Gu nathek shii izai yao dang phro,” “Mosses è phi pha iweb jine hamangkhung pha asi ro; hamangkhung è gu Aphuii è phi pha iweb jine isbang ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hamangkhung-aphuii è phi pha iweb ji hamangkhung è wuii jong ne sohjambling shii chai phi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ithek è aishii lia, “Masdo” Ji pha iweb ne gathek shii idang pha phi bo. ");
INSERT INTO bgg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isu è chang, “Gu ne chai pha iweb ro.” Ji-è hanyie gu shii wuii ruii pho ne khuchung de chi-iya-iy phro; chiih-è hanyie gu shii migi rek pho ne khuchung de gahang-ahang phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ji-è gu nathek shii yao dang phro, nathek ne gu shii doh phro, jimagunde nathek gu shii migi arek phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Zab hanyie magungde Aphuii è gu shii phi pha ji ne gu shii wuii ruii phro, jiè hanyie gu shii wuii ruii pho ne gu aishii khuchung de akhia phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nyieliieshii Gune Hamangkhung è thazam wuii pha ne guilum ne asi ro, jimagungde hanyie è gu shii thoh ge pha ai è yang pha ji rek pha wuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Chiih-è hanyie gu shii thoh ge pha ai è yang pha ji ro, ai è gu shii nyie phi pha jiè jia de asan yi bo ne now ro, jishii gune iidohhè pha inai shii ai zab shii chai hòi yi chid phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chiih-è gu Aphuii nyie now pha ji ne hì ro hanyie è Dufuii shii riig ne migi rek pho ne idang pha chai mua ruii phro. Chiih-è iidohhè pha inai shii gune aishii hòi ne sieng din yi pha ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chiih-è bran è ai chiang shii yao ramua, nyieliieshii ai è yao, “Gu ne Hamangkhung è thazam wuii pha iweb ro.” ");
INSERT INTO bgg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ji-è ithek yao, “Hì pha bran hì ne Joseph ro dufuii Isu ji asi bey? Chiih-è gathek ne airo aphuii amuii shii de thieg, jimagungde ai ne khi-èrek ne hamangkhung è wuii phrone yao mua phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Isu è chang, nathek ne nawaithek chung amulo chid rabo. ");
INSERT INTO bgg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hanyie magungde aphuii è gu moe shii anoh sapho shii ne ai ne gu moe shii awuii mua phro. Chiih-è gune aishii iidohhè pha inai shii hòi din yi phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chaigthek è de zey, Zab shii Hamangkhung-aphuii è yua ruii phro. Chiih-è hanyie magunde aphuii miyao yoi ne thieg pho ne gu hà wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hì pha miyao ne hanyie è aphuii shii adoh ro; jishii hanyie yi Hamangkhung-aphuii ro lei ne, ji jia ai è aphuii shii doh phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gu nathek shii izai yao dang phro: Hanyie è migi rek arone idang sieng pha chai mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Gune chai pha iweb ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Naro blangthek ne balimuang shii manna chie, jimagungde ai ne iy dun. ");
INSERT INTO bgg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jishii Hamangkhung è thog pha iweb ji ne zai hanyie è chie pho ne a-iy phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Gune Hamangkhung è wuii thog pha isieng iweb ro. Ji-è hanyie magung de ji pha iweb chie arone idang sieng ne rai ruii phro. Chiih-è gu miphi pha iweb ji ne gu siu ro, gu è ji phi pha ji ne sohjambling pho de sieng mua pha phi phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hì pha miyao è awaithek chung khnaing ne lijieg rai ne sai. Hì pha bran ne khi-èrek ne awai siu shii phi ne chie mua yi phlei? ");
INSERT INTO bgg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isu è aishii yao, gu nathek shii izai yao dang phro: nathek è bran Dufuii ro siu nane ifai achie aniing sapho shii ne ithek shii chai oi phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hanyie è guro siu nane ifai chie niing arone idang sieng pha chai um ruii phro, chiih gu aishii ne iidohhè pha inai shii hòi yi phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ji-è guro siu ne michie isbang ji ro, chiih-è guro ifai jine niing pha isbang ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hanyie è guro siu nane ifai chie niing ne gu rog shii rai pho ne, gu de ai rog shii rai gieng phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Isieng Aphuii è gu shii thoh ge, ji è ai chiang gu de sieng mua phro, ji duiine hanyie è gu shii chie pho ne gu chiang è sieng ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ji-è Hamangkhung è thazam wuii ruii pha iweb ne hì ro; chiih-è hì pha iweb ne ithek blangthek è chie marui srane iy dun pha ji-duiine asi ro. Hanyie magungde hì pha iweb chie arone idang sieng ne rai ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ji pha miyao ne Isu è Khaphernaum pha Jewthek misiahò shii yua pha ji yao phro. ");
INSERT INTO bgg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Airo samoythek è de ji pha miyao ji nuii srane yao, “Hì pha miyao ne bajo diig ro. Chiih-è hì pha miyao ne hanyie nuii mua phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hanyie è aishii ayao magunde ithek ji pha miyao è khnaing ramuii pha ji ne Isu è thieg, ithek shii yao, “Nathek hì pha miyao ne hìnya shii thoh muii pha now bey?” ");
INSERT INTO bgg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chiihphado nathek ne Bran Dufuii shii ai igobi khi hà um pha ji hà dun din pha ji doh arone nyie rey phlei? ");
INSERT INTO bgg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Chai phi pha ji ne Hamangkhung-aphuii ro ragung ro; Chiih-è tharomang blu ne idang blia adunmey phro. Chiih-è gu nathek shii yao pha miyaogamthek jine Hamangkhung-aphuii ro chai sieng pha Ragung ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jishii nathek giak ne thuh de migi arek ba ro, (Chiih-è Isu ne igobi è migi arek phrone chiih-è hanyie è aishii zum yi pha bran shii ne thieg muii ro.) ");
INSERT INTO bgg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chiih-è ai è yao, “Hì pha chiang è gu ithek shii yao dang phro, aphuii è abo sapho shii ne hanyie de gu shii awuii mua phro.” ");
INSERT INTO bgg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nyieliieshii ji pha chiang è Isu ro samoy ne iidoh khid srane hanyie de ai rog shii alua. ");
INSERT INTO bgg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ai è awairo suanyi samoythek shii sai, “Nathek gu shii thoh ne dun pha now bey?” ");
INSERT INTO bgg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Phithar è aishii chang, “Ithong, gathek hanyie shii dun mage phlei? Nyieliieshii idang pha chai phi pha miyaogamthek ne na shii um bie ro. ");
INSERT INTO bgg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Thuh shii gathek ne migi rek chiih-è gathek ne thieg na ne Hamangkhung-aphuii è thoh ge pha So Jia ji ro.” ");
INSERT INTO bgg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Isu è aishii chang, “Gu nathek suanyi shii agua bey? Jimagunde ithek è bran jia ne ibuii ro!” ");
INSERT INTO bgg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ai ne Simon Iskharioth pha dufuii ji pha chiang shii yao phro, Judas de samoythek snanyi è jia magungde aishii zum yi phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ji pha iidoh shii Isu Galili hà lua ne rai; ai Judea hà alua yang, nyieliieshii thiisa hà ne Jewthek pha dumuii è aishii ua pha suruii ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Haliigthek Sai pha ishak de nui rey sa, ");
INSERT INTO bgg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","jiè Isu ai khuii è aishii yao, “Hì pha ithua thoh srane Judea hà wuii bo, chiihphado nathek ro samoythek ne nathek è rek pha ji doh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ai è awai mirek ji gai shii wie thieg pha now arone hanyie de a-ug mua phro, ithek è hì pha blia rek muii rone zab sohjambling pho na shii thieg yi bo!” ( ");
INSERT INTO bgg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ji pha shud shii ne airo ai khuiinothek è de aishii migi arek ba ro.) ");
INSERT INTO bgg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Isu è aishii yao, “Guro isbang ishak ne thuh de athog ba ro. Nyie ishak magunde nathek rone rangsua ro. ");
INSERT INTO bgg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Sohjambling pho è ithek shii a khiijai phro, jimagungde ai è gu shii ne khiijai ruii phro, nyieliieshii gune athodang pha ithek mirek pha lumuii awie ro è yao phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Na ne ji pha Sai pha ji shii wuii bo. Gune ji pha Sai pha ji shii awuii ro, nyieliieshii guro rangsua ishak ne athog ba ro.” ");
INSERT INTO bgg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ai ji è yao srane ne thiichiih Galili shii raidun. ");
INSERT INTO bgg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ai khuiino yi Haliig Sai pha ji hà wuii dun pha iidoh shii, Isu de wuii dun; jimagungde ai yi miang awuii pha ug ne wuii. ");
INSERT INTO bgg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jew pha dumuii è Haliig Sai pha ji shii, aishii sow ne sai, “Ai ne khi hà lai?” ");
INSERT INTO bgg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Thiichiih iphiing brog shii bran è ai chaing suak ne yao ramuii, giak è yao, “Ai ne bran wie ro,” asi chiih-è giak è yao, “Ai ne bran shii asi pha lumuii hà lua noh ro.” ");
INSERT INTO bgg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jishii hanyie de fuang hà ayao mua, nyieliieshii ithek de Jewthek pha dumuii è bajo rum. ");
INSERT INTO bgg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sai pha ji yi khuyo jong sha pha rek shii, Isu è Hamangkhung-aphuii ro Misiahò hà wuii srane jao ne yua ramuii. ");
INSERT INTO bgg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jewthek pha dumuii è ji yoi srane wiengphleg ne yao, “Hì pha bran ne nyie de adab habuii shii khi-èrek ne nyama thieg dun phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Isu è aishii chang, “Gu è nyie yua ramuii pha ji ne gui ro asi ro, jimagungde hì ne gu shii thoh ge pha Hamangkhung-aphuii ro ro. ");
INSERT INTO bgg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ji-è hanyie maungde Hamangkhung-aphuii munow ji rek arone, hì pha miyao ne Hamangkhung-aphuii è yao bey ne asi pha gui lum ne yao bey ne ji thieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bran hanyie yi awai riichai è yao pha ji ne awai shii biisiie shii phua pha bidiang ro. Chiih-è hanyie è ai mutho ge pha izai jishii biisiie phi arone, ai ne giang ro, chiih-è aishii ne buii oi ro. ");
INSERT INTO bgg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nathek shii Moses è Iphey aphi bey? Jishii nathek è hanyie de airo Iphey jine anuii. Ji è nathek ne gu shii ua pha nyie um ne suruii phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Na shii ne ibuii um ara!” Bran brog è aishii chang, nathek shii ne ua pha hanyie mirek lei? ");
INSERT INTO bgg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isu è aishii chang, “Gu è buang pha blia jia rek bie shii nathek ne wiengphleg dun.” ");
INSERT INTO bgg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses è nathek ro aniphiing pha migiangkheg bo è yung, (jimagunde ji pha Iphey ne Moses ro asi, jine nathek ro blangthek mujao bi ro.) Ji-è nathek ne Jew Thung pha inai shii de aniphiing ro migiangkheg phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jew Thung pha inai shii bufuii ro migiangkheg arone Moses ro Iphey ji achui, jimagungde gu è Jew Thung pha inai shii bran jia shii wie gang rek phi shii ithek nyie rek ne lijieg phlei? ");
INSERT INTO bgg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nathek ne lakhung hà riig ne achua rabo, jishii bucho pha izai ji riig ne chua bo. ");
INSERT INTO bgg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem pha giak bran è yao, “Hì pha bran hì ne rangsuathek è ua pha suruii ramuii pha ji asi bey? ");
INSERT INTO bgg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Riig mage bo! Ai ne bran moe shii yao ramuii ro, ithek è aishii nyie de gidieg ayao ro. Chiih-è ithek de ai ne Masi chak rone thiegjong ne bey? ");
INSERT INTO bgg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Jishii Masi wuii ruii shii ne ai khi è wuii ruii pha ji ne hanyie de athieg phro. Chiih-è gethek ne zab thieg ai khi-è wuii pha ji ne.” ");
INSERT INTO bgg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Isu yi Hamangkhung-aphuii ro Misiahò hà yua ramuii shii, ai è gang ziak ne yao, gune khi è wuii ruii pha ji ne nathek thieg ne bey? Gune gui riichai è awuii ro. Nyieliieshii hanyie è gu shii thoh ge pha ji ne izai chak ro, chiih-è aishii ne nathek athieg mua phro, ");
INSERT INTO bgg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","jimagungde gune aishii thieg, nyieliieshii gu shii ne ai muthoh ge ro, “Ji-è gune ai è wuii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chiihphado ai yao ramuii pha ishak shii ai è aishii zum pha rek, jimagungde ai hanyie è de aishii azum, nyieliieshii airo ishak ne arey ba. ");
INSERT INTO bgg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jishii thiichiih pha iphiing è bajo bran è aishii migi rek srane yao, “Masi wuii ruii shii ai ne hì pha bran mirek pha buangthek pha blia ji è de bajo rek ba ruii habey?” ");
INSERT INTO bgg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisithek è iphiing iliing shii Isu chiang suak ne yao ramuii pha ji yoi srane, ithek nane boh phabithek è aishii zum pha sandri shii thoh ge. ");
INSERT INTO bgg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Isu è yao, gune ichiih nathek rog shii Ìujia rai bie, chiih-è gune gu shii thoh ge pha ji hà dun din phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nathek ne gu shii sow ruii phro, jimagungde nathek gu shii adoh mua sha phro, nyieliieshii gu khi hà rai pha ji ne nathek ne awuii mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jewish dumuii awaithek chung yao rai, “Gethek adoh mua pha khi pha ithua hà dun pha yao phlei? Ai ne gethek ro bran rai pha Grekh rajanthek hà dun ne Grekh shii yua habey? ");
INSERT INTO bgg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ai è yao, gethek ne aishii sow magungde aishii adoh phro, chiih-è ai khi hà rai pha ji ne gethek ne awuii mua phro. Hì pha miyao ji ne nyie yao phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sai pha iidohhè pha miigak inai shii Isu è thiichiih riu srane ziak ne yao, hanyie yi gahanghang arone gu shii wuii srane niing bo. ");
INSERT INTO bgg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jigigam shii zey ne um, hanyie è gu shii migi rek arone, chai kho phi pha khaduii ne ai lubu bucho è noi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Isu è ji yao pha ji ne Ragung chiang pha miyao yao, hanyie magungde aishii migi rek arone aishii ne mua ruii phro. Ji pha ishak shii ne Ragung ne aphi ba ro, nyieliieshii Isu ne iy ne biisiie shii ahòi ba ro. ");
INSERT INTO bgg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ai miyao ji nuii srane bran ibrog shii um pha giak è yao, “Hì pha bran hì ne izai chaig chak ara!” ");
INSERT INTO bgg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Giak è yao, “Ai ne Masi ro!” Jishii giak è yao, Masi ne Galili è awuii ruii phro! ");
INSERT INTO bgg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jigigam shii yao ne um ro Masi ne Saja Dawid ro riing è rey ruii phro, chiih-è ai ne Dawid rai mua pha Bethlehem thawun shii giak ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ji-è ithek ne Isu chiang shii ibrog è chedun phro. ");
INSERT INTO bgg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Giak bran è ai zum pha now, jimagunde hanyie è de aishii azum mua ro. ");
INSERT INTO bgg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sandri è iidoh dun thog shii, phabi boh nane Pharisithek è aishii sai, “Nyie rek ne aishii anoh lei?” ");
INSERT INTO bgg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sandri è aishii chang, “Hanyie è de ji pha bran duiine ayao mua ro” ");
INSERT INTO bgg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisithek è aishii sai, ithek shii de bajo bi-ìe rab muii ne bey? ");
INSERT INTO bgg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nathek è dumuii nane Pharisithek jia de aishii migi now pha doh bey? ");
INSERT INTO bgg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ji pha iphiing è Moses ro Iphey ne athieg, jiè ithek ne Hamangkhung-aphuii ro mucho nud dun ro! ");
INSERT INTO bgg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dohbi Isu shii si wuii pha Pharisithek pha bran Nekhodemus de thiichiih um. Ai è gai shii yao, ");
INSERT INTO bgg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Gethek Iphey shii yao pha duiine, ai nyie yao pha ji anuii pha chiih-è ai nyie rek pha aishii riig pha aishii nin mua.” ");
INSERT INTO bgg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ai è chang “Zai chak ro,” “Na de Galili pha bey? Nathek de jigigam shii tham ne riig bo, chiihphado ithek ìd ruii, riig hanyie de Galili è awuii ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Chiihphado, zab pha bran awai hò hà dun ched dun, chiih-è Isu yi sumaro pha phiing hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ji pha thimiang pha hamiang shii ai iidoh Hamangkhung-aphuii Misiahò hà wuii dun. Zab branthek ne aishii shan ne khrab, chiih-è ai de dug srane ithek shii jao ne yua. ");
INSERT INTO bgg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iphey yua pha Masdo nane Pharisithek è hò-amuii jia shii siulua pha doh ne zum ne thiichiih noh ne ai moe shii riu ba yi. ");
INSERT INTO bgg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ai è Isu shii yao, “Masdo,” Gathek è hì pha hò-amuii shii siulua rek pha ishak shii zum phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses è phi pha gethek ro Iphey shii de yung hì è rek pha hò-amuii shii ne lubao rek ne chao ne ua chid phro, Thuh na ne nyie yao phlei? ");
INSERT INTO bgg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aishii nin mua pha ithek è aishii ichiig sow srane yao. Jishii Isu è nyak hà bam srane awai wad bieng rek ne zey. ");
INSERT INTO bgg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Thiichiih shii riu pho è aishii musai sai, jishii ai è miang riu srane ithek shii yao, “Ichiih shii ithek è khuchung de layog arek ba pha um arone igobi ai è hò-amuii shii lubao rek ne chao bo. ");
INSERT INTO bgg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chiihphado dinne ai buzam bam srane nyak shii zey. ");
INSERT INTO bgg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ithek ji pha miyao yoi srane weg è yi ne filiao de ji jia rek ne Isu shii thoh ne dun ched dun, Jishii ji pha hò-amuii yi Isu moe shii nyariu bamuii. ");
INSERT INTO bgg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ai è miang riu srane ji pha hò-amuii shii yao, ai ne giisa hà lai? Ichiih na shii nin pho ne hanyie de aled sha bey?” ");
INSERT INTO bgg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ji pha hò-amuii è chang, Masdo hanyie de oi ro. “Chiihphado Isu è yao ji-arone wie ro,” Gu de nathek shii anin phro. Jishii na de dun bo chiih-è dinne hì è rek pha layog arek sha rabo. ");
INSERT INTO bgg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isu è Pharisithek shii yao din. Ai è yao, “Gune sohjambling pha muchuang ro,” Ji-è hanyie è gu rog shii luagieng arone ai ne ji pha chai muchuang mua ruii phro, chiih-è ai ne khuchung de igiia hà alua din sha phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisithek è aishii yao, na ne thuh shii nawai haro han ne yao ara, ithek è nyie yao pha miyao jine nyie arey ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Asi, Isu è aishii chang, gui è gui chiang haro yao magungde, gu miyao jine izai chak ro, nyieliieshii gune khi è wuii chiih-è gu khi hà dun din ramuii pha ji ne gui thieg chak ro. Nathek ne gu khi è wuii pha ji nane gu khi hà dun ramuii pha ji ne athieg ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nathek ne gang tharothamang lumuii duiine chua ara, chiih-è gune hanyie shii de achua phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jishii gu è chua magunde gu ne izai chua ruii phro, nyieliieshii hì pha blia hì ne gui jijia asi ro, chiih-è gu shii thoh ge pha Aphuii de gu rog shii um ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nawaithek ro Iphey shii de zey ne um, khuchung magungde bran nyi è khagi rek arone isa è nyie yao pha ji ne izai rey dun phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Gune gui khagi rek phro, chiih-è gu shii thoh ge pha gu Aphuii de gu chiang shii khagi rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ithek è aishii sai, na Aphuii ne giisa lei? Ai è ithek shii chang nathek gu shii de athieg ba ro chiih-è nathek gu Aphuii shii de athieg mua ba ro. Nathek è gu shii thieg arone gu Aphuii shii de thieg jong phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isu è Hamangkhung-aphuii ro Misiahò hà yua shii bang zid pha japhothek ruii pha ùgud ji hà yao phro. Chiih-è thiichiih shii hanyie è de aishii azum, nyieliieshii airo ishak ne athog ba. ");
INSERT INTO bgg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Din ne Isu è aishii yao, “Gune dun dun phro; nathek ne gu shii sow ruii phro, jimagungde nathek ne nawai layog hà iy dun phro. Nathek ne gu khi hà dun pha ji hà ne adun mua phro.” ");
INSERT INTO bgg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ji-è Jewthek pha rangsuathek è yao, “Ai è gethek shii ne ai khi hà dun pha ji shii ne adun mua phrone yao dun, jine awai è awaishii ua pha miyao bey?” ");
INSERT INTO bgg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Isu è chang, Nathek ne ichiih sohjambling luii pha ro, jimagungde gune lakhung è wuii pha ro, chiih-è nathek ne sohjambling pha ro, jimagungde gune sohjambling pha asi ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ji-è gu nathek shii yao nathek ne Nawai layog è iy ruii phro. Chiih-è nathek ne Gune hanyie gu ji rone migi anow arone Nawai layog è iy ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ai è aishii sai, “Na ne hanyie lai?” Isu è chang gune igobi è yaojong pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gu ithek shii bajo yao pha de um ro, chiih-è gune ithek shii bajo nin pha miyao de um ro. Gu shii thoh ge pha ji ai ne izai chak ro, gune sohjambling shii nyie yao pha ji ne ai è yoi ne yao bie phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ithek è Isu ne Aphuii pha miyao yao muii rone agao ba ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ji-è ai ithek shii yao, na è Bran Dufuii shii lakhung chiing mage shii, ithek de gune ji ro thieg ruii phro; chiihphado gune gui blu è nyie arek rone thieg ruii phro, jishii gune gu Aphuii nyie yua pha ji rek bie phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chiihphado hanyie gu shii thoh ge pha ji ne gu rog shii um ro; ai ne gu shii ji atho marui phro, nyieliieshii ai è nyie wie now pha ji ne gu è idang rek phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bajo bran è Isu miyao yoi ne migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ji-è Isu hanyie è aishii migi now pho shii yao, na gu miyao ji nuii arone, ithek ne gu ro izai samoythek chak ro; ");
INSERT INTO bgg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na ne izai shii thieg iwa, chiih-è izai ji è ithek shii sey ne thoh phi phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ithek è aishii chang, “Gathek ne Abraham pha riingthek ro,” “Ji-è gathek ne khuchung de gairo khiao arek ba ro, chiihphado khiao akhui phrone yao pha miyao ne nyie yao phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isu è aishii chang, gu nathek shii izai yao dang phro: hanyie è layog rek pho ne layog pha khiao reyjong dun ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Khiao ne haliing jia shii idang arai phro, jimagungde dufuii ne idang haliing hà rai phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dufuii è nathek shii khiao rek pha ji è lam mua arone izai è nathek ichad ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gune ithek shii thieg ithek ne Abraham ro riingthek chak ro, jimagungde ithek ne gu shii ua pha suruii ramuii ro, nyieliieshii ithek ne gu miyao ji anuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Gune Aphuii chiang è nyie gu shii doh yi pha ji yao bie phro, Chiih-è nathek ne nawaithek Aphuii è nyie yao pha ji rek ara. ");
INSERT INTO bgg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ithek è aishii chang, “Abraham ne gathek ro aphuii ro.” “Isu è aishii chang, nathek ne Abraham ro izai ani chak arone,” na de ai mirek ji duiine rek phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Zab gu è nyie rek pha ji ne gune Hamangkhung-aphuii è nyie izai yoi pha ji nathek shii de yao pha rek phro. Jishii nathek ne gu shii ne ua pha suruii muii ro, Abraham ne ji arek marui ro! ");
INSERT INTO bgg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Na ne nawaithek Aphuii è rek marui pha ji duiine rek ara ro. Chiih-è gune airo izai dufuii chak ro. “Ai è chang gu Aphuii ne Hamangkhung-aphuii awai bie ro.” ");
INSERT INTO bgg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isu è ithek shii yao, Hamangkhung-aphuii ne izai nathek ro Aphuii chak arone, nathek ne gu shii miie phro, nyieliieshii gune Hamangkhung-aphuii è wuii phro, chiih-è thuh gune ichiih shii um ro. Chiih-è gune gui lum ne awuii ro, jishii gu shii ne ai mutho ge ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Na ne guro miyao nyie rek ne agao lei? Nyieliieshii ithek ne guro mua ji zud ne ayoi mua ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Na ne nawairo aphuii ibuii pha ani ro, chiih-è ithek ne nawairo aphuii munow ji rek ara ro. Chiih-è ai ne igobi è sgohpho ro chiih-è ai ne izai hà khuchung de alua ro, nyieliieshii aishii ne izai de oi ro. Ithek khlam shii, ai ne awai lum ne rek bie phro, nyieliieshii ai ne khlam pho ro, chiih-è ai ne khlam pha aphuii. ");
INSERT INTO bgg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jishii gune nathek izai yao dang phro, jiè nathek ne gu shii migi arek ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nathek hanyie è gune layog rek rone khagi rek mua ne bey? Gune izai yao shii, ithek ne gu shii nyie rek ne migi anow lai? ");
INSERT INTO bgg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hanyie yi Hamangkhung-aphuii è wuii pha ji ne Hamangkhung-aphuii ro miyaogamthek nuii phro. Nathek ne Hamangkhung-aphuii è asi ara ro, chiih-è jiè ithek ne anuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ithek è Isu shii sai, “Na ne Samarithan rone chiih-è na shii ne ibuii um rone gathek shii yao pha rangsua oi bey?” ");
INSERT INTO bgg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isu è ithek shii chang “Gu shii ne ibuii oi ro,” “Chiih-è gune Aphuii shii ilab rek phi” Jishii ithek ne gu shii ne ilab arek phi. ");
INSERT INTO bgg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Gu ne gui shii ilab rek pha asow ro, jimagungde lasa hà jia um ro ai ne ilab chid phro chiih-è gu haro rek ne chua phi ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gune ithek shii izai yao dang phro: Hanyie è gu muyua ji nuii pho ne khuchung de a-iy phro. ");
INSERT INTO bgg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ai è aishii yao, “Gathek ne thieg jong na shii ne ibuii um! Abraham de iyjong, chiih-è chaig pho de iyjong, Jishii ithek è yao hanyie è ithek muyua nuii arone khuchung de a-iy phro.” ");
INSERT INTO bgg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gathek ro aphuii Abraham ne iyjong dun, chiih-è na ne Abraham è de bo rone ayao mua phro, chiih-è chaig pho de iyjong dun, jiè nawaishii hanyie ro è now phlei? ");
INSERT INTO bgg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isu è aishii chang, “Gu è gui shii ilab phi arone, ji pha ilab ne nyie adunmey phro. Nathek è Nawai Hamangkhung-aphuii ro è yao mua ne gu shii ilab phi muii pha Aphuii ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Na ne aishii athieg ba ro, jimagungde gune aishii thieg ro, gu de aishii athieg ro è yao arone ithek duiine khlam thek rey dun phro, jimagungde gune aishii thieg, chiih-è gune ai miyaogam nuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nathek ro aphuii Abraham de gu wuii ruii pha ishak riig ne lubo rek ne rai iang phro; ai è doh mage shii bajo sang rek. ");
INSERT INTO bgg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ai è aishii yao, na ne idam saguii de arey ba shii na ne Abraham shii doh ne bey?” ");
INSERT INTO bgg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isu è aishii chang, “Gu nathek shii izai yao dang phro,” “Gu ne Abraham agiak ba pha ibi è gu ro.” ");
INSERT INTO bgg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chiihphado ai è lubao chiing srane aishii chao pha rek, jimagungde ai è ug srane Hamangkhung-aphuii Misiahò thoh ne dun marui. ");
INSERT INTO bgg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Isu yi luaramuii shii nyagiak dang ne imiegthi pha bran jia doh. ");
INSERT INTO bgg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ai samoy è sai, “Masdo, nyagiak dang ne ai miegthi hì ne hanyie layog mutho lei? Chiih-è hì pha miiriie ne awai layog mutho bey asi pha ai aphuii-amuii layog mutho bey?” ");
INSERT INTO bgg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isu è aishii chang, airo imiegthi hì ne awai layog è de asi ro chiih-è ai aphuii-amuii pha layog de asi ro. Airo imiegthi hì ne Hamangkhung-aphuii ro blu aishii blia rek rone doh yi pha ji mirey ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gu shii thoh ge pha airo blia ne inai nya um ba shii gethek ne atho pha rek chid phro, chiih-è hanyie de blia arek mua pha habiu ne thog sharuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Gu ichiih sohjambling shii um ba shii ne gune sohjambling pha muchuang ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ai ji è yao pha iidoh shii, Isu è nyiak shii chan cho srane nyiakphlab ji shii nog ne ji pha bran mieg shii sun ");
INSERT INTO bgg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ne yao, “Wuii srane nawai mizia Siloam khabang shii mi mage bo.” (Hì pha ibeng yi “Tho” ge phro). Ji pha bran è wuii srane mieg mi ne iidoh dun shii mieg jine doh ne dun thog ruii. ");
INSERT INTO bgg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chiihphado è ai hadung-haluii pho è bai doh shii ai chayem thang ne lua pha ishak shii riig pha bran è sai, “hì pha bran hì ne chayem than ne dug ne rai pha ji asi bey?” ");
INSERT INTO bgg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Giak bran è yao, “ai ne ji chak ro,” jimagungde giak è yao, “ai ne ji asi ro, ai ne ji duiine mia bie ro.” Ji-è ji pha bran awai è yao, “gune ji pha bran chak ro.” ");
INSERT INTO bgg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ji pha bran ji è aishii sai, “Khi-èrek ne doh mua ge phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ai è chang, “Isu beng pha bran jia è nyiak nog ne, gu miegthi shii sun phi ne gu shii Siloam pha khabang shii wuii ne mizia mi mage bo è yao. Ji-è gune wuii srane ne mi mage shii gune doh mua dun.” ");
INSERT INTO bgg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ai è aishii sai, “ithek ne khi hà lai?” “Ai è chang,” gune athieg ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chiihphado shii ai è mieg doh mua pha bran jishii Pharisithek hà noh dun. ");
INSERT INTO bgg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Isu è ai miegthi shii nyiak sun ne wie rek phi pha ji yi Jew Thung pha inai shii ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chiihphado, Pharisithek è ji pha bran jishii sai din naro miegthi jine khi-èrek ne doh ge phlei? Ai è aishii chang, “Ai è gu miegthi lakhung shii nyiak rek ne sun phi; chiih-è gu mieg mi shii gune doh khlei dun.” ");
INSERT INTO bgg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Giak Pharisithek è yao, “Hì pha blia rek pha bran hì ne Hamangkhung-aphuii è asi phro, nyieliieshii ai è Jew Thung pha inai pha Iphey ji anuii.” Jishii giak è yao, “Layogpho jia ne khi-èrek ne hì è rek pha buangthek pha rek mua mage phlei?” Chiih-è ai munow jine che dun. ");
INSERT INTO bgg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ji-è Pharisithek è ji pha bran jishii sai din, “Na è yao naro miegthi ne ai mirek ne gang phi, chiih-è na ne aishii nyie now lai?” chiihphado è bran ji è chang, “Ai ne chaig ro.” ");
INSERT INTO bgg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pharisithek è ai ne miegthi è giak phrone airo aphuii-amuiithek shii aho sapho shii ne migi arek. ");
INSERT INTO bgg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chiih-è ithek sai, “hì pha bran ne naro dufuii bey? Nathek ne ai ne miegthi è giak phrone yao, chiihphado thuh ai ne khi-èrek ne doh mua phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ai aphuii amuii è yao hì ne gasa ro dufuii chak ro, chiih-è ai ne nyagiak dang ne miegthi chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jishii gathek ne athieg ai ne thuh shii khi-èrek ne doh mua lai, chiih-è ai miegthi shii de gang hanyie mirek phi pha ji shii de gathek ne athieg ro, jiè awaishii sai mage bo, ai ne boh rey sha ro, chiih-è ai awai è nyachang mua sha phro. ");
INSERT INTO bgg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ai aphuii amuii è iyao pha miyao ji ne nyieliieshii ai è Jew ro blu shii rum ne yao, nyieliieshii ithek ò jia rek iang srane hanyie è Isu ne Masi migi rek pho shii ne Jewthek misiahò è khia muii pha rek. ");
INSERT INTO bgg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ji-è awaishii sai bo ne ai aphuii ai amuii è yao ai ne bo rey sha ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chiih-è dinne de aishii ho srane sai, Hamangkhung-aphuii shii biidiie akhlam pha izai yao bo, nyieliieshii gathek ne thieg ithek shii gang rek phi pha bran ji ne layogpho ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Ji pha bran è chang, gune athieg ro ai ne layogpho rai bey asi rai bey,” “Chiih-è gune thieg: Gune miegthi chak chiih-è thuh ne doh sha ge ro.” ");
INSERT INTO bgg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Ithek è aishii sai, ai è na shii nyie khi-èrek gang phi phlei?” “Chiih-è na ro miegthi ji ne ai è khi-èrek ne gang rek phi phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ai è chang “Gu è nathek shii yaojong phro,” “Jishii gu miyao ne anuii. Nyie rek ne dinne nuii yang phlei? Na de airo samoythek pho rey yang bey?” ");
INSERT INTO bgg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ithek è aishii makhakriing srane yao, na de ji pha ijak iwa; jishii gathek ne Moses ro samoythek ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gu ne thieg Hamangkhung-aphuii è Moses shii ne miyao yao, chiih-è ji pha bran ne khi è wuii rai lei ne gathek ne Ìujia de athieg ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ji pha bran è chang, jine anomuluii pha ro! Chiih-è nathek ne ai khi è wuii ji de athieg. Jishii ai è gu shii miegthi doh mua pha gang phi ro! ");
INSERT INTO bgg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gu ne thieg Hamangkhung-aphuii ne layogphothek shii anuii jimagungde hanyie è Hamangkhung-aphuii pha miyao ji nuii ne lua pho ne Hamangkhung-aphuii de aishii ilab phi ro chiih-è ai è aishii nyie rek yang pha ji rek phi ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sohjambling nyajao dang ne miegthi giak pha ji shii gang rek phi pha ayoi ba ro. ");
INSERT INTO bgg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ji pha bran yi Hamangkhung-aphuii è awuii sapho shii hì pha blia arek mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ai è chang, nathek ne layog è giak ne sieng pha bran, “Chiih-è na ne gathek shii yua pha bidiang ne bey?” Chiih-è ithek è aishii Jewthek misiahò fuang khia muii. ");
INSERT INTO bgg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nyie rey pha ji yi Isu è yoi mage shii, ai è bran shii doh srane aishii sai, “Na de Bran Dufuii shii migi now bey?” ");
INSERT INTO bgg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bran ji è chang, “Masdo, ji ai ne hanyie lei, jiè gu shii yao riig bo, chiihphado gu de aishii migi rek mua!” ");
INSERT INTO bgg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Isu è aishii yao, “Nathek ne aishii doh jong ro, ai ne na rog shii yao ramuii pha jia ji ro.” ");
INSERT INTO bgg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bran ji è yao, “Ithong! Gune migi now phro iyao” Srane Isu moe shii bam ne khung dun. ");
INSERT INTO bgg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Isu è yao, gune ichiih sohjambling shii chua pha wuii phro, jiè miegthi pho ne doh ruii phro, chiih-è mieg wie pho ne ithi rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Thiichiih ai rog shii um pha giak Pharisithek è ji yao pha ji yoi srane aishii sai, “Na miyao jine gathek shii miegthi rone yao pha ji asi bey?” ");
INSERT INTO bgg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isu è chang, nathek ne miegthi arone nathek ne ichiig arey phro, na è mieg doh rone gathek shii yao mage pha ji è nathek ne thuh de ichiig um ba ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Isu è yao, gu nathek shii izai yao dang phro: Bran hanyie yi shiishai ruii pha muthua pha gak è awuii pha gai muthua è khurog ne wuii pho ne mugo nane riao pha bran ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bran hanyie magungde shiishai muthua gak è wuii ruii pho ne shiishai brogpho ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chiih-è gak khan pho è aishii gak hong phi srane; awai shiishai shii ibeng è ho mage shii shiishai è muspho ro gow gao dun ne, muspho è jishii fuang hà lua noh phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ai è fuang hà noh mage shii, awai yi ibi hà lua, chiih-è shiishai ne ai iidoh hà luagieng, nyieliieshii shiishai è ai gow gao phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ai ne gai pha bran rog shii alua pha ai ne ji pha bran è ruang ran marui phro, nyieliieshii ai ne ji pha bran gow ne agao ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isu è ji pha najang è yao shii, ji pha miyao jine nyie yao pha ji ne ithek è agao mua. ");
INSERT INTO bgg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ji-è Isu è yao, gu nathek shii izai yao phro: Gune shiishai gak ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Chiih-è gu è ibi gai khama wuii pho ne mugo nane riaopho ro, jimagungde shiishai è de ai miyao anuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Gune gak ro, hanyie gu è khud ne iliing wuii ruii arone ji pho ne ragia rey ruii phro. Ai ne iliing gu shii wuii ne chiih-è fuang wuii srane saing rey chie ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mugopho ne mugo go pha nane ua pha chiih-è srobro rek pha wuii phro. Gu è wuii pha ji ne nathek shii bajo ley chai mua yi pha wuii phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Gune wie shiishai brogpho ro, hanyie è shiishai chiang shii iy yang pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Riinang rek bie ne shiishai pha shiishai brogpho ne, shaliie wuii ruii pha doh mage shii shiishai thoh maruii srane rum ne ran dun phro; jiè shaliie è shiishai shii thak ne dayiingdayang rek ne ruii mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Riinang pha shiishai brogpho ne ran marui phro, nyieliieshii ai ne riinang pha bran bie ro chiih-è shiishai shii wie ariig ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Gune wie brogpho ro, chiih-è Aphuii de gu shii thieg, chiih-è gu de Aphuii shii thieg, ji duiine gu è gui shiishai shii thieg chiih-è shiishai de gu shii thieg. Chiih-è gune shiishai chiang shii de nya-iy yang phi phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ichiih rugo shii oi pha guro shiishai ne thiisa hà shiishai gaithek de um ba ro. Gune aishii de noh chid phro; ithek de guro gow yoi ruii phro, chiih-è ithek ibrog shii de brogpho jia pha shiishai brog pha shiishai rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Aphuii è gu shii miie, nyieliieshii gune gui chai de phi yang phro jiè gune iidoh mua din ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hanyie magungde guro chai ariao mua phro. Gune guilum ne phi mua phro chiih-è gu shii ne phi pha rangsua de gui shii um ro. Chiih-è ji iidoh yi din pha rangsua de gui shii um ro. Hì ne gu Aphuii è gu shii yung ne rek yi ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ji pha miyaogamthek ji nuii srane thiichiih pha branthek ne dinne yo chedun. ");
INSERT INTO bgg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bajo giak bran è yao, “Aishii ne ibuii um ro! Ai ne ibiu ro! Nyie rek ne nathek ai miyao nuii phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jishii giak è yao, “Ibuii um pha bran ne ji è rek pha miyao ayao mua phro! Nyie khi-èrek ne ibuii è miegthi bran shii mieg doh mua yi phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hakhangshak rey sha shii, Jerusalem hà Hamangkhung-aphuii Misiahò khud pha sai ramuii. ");
INSERT INTO bgg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Isu yi Hamangkhung-aphuii Misiahò hà Solomon ro ithua sibiang shii luaramuii. ");
INSERT INTO bgg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Thiichiih shii bran wuii khrab thog ne aishii sai, “Na ne dinne de gathek shii khinyma nowdak ne rai ba yi habey? Gathek shii sang yao mage bo: Na ne Masi bey?” ");
INSERT INTO bgg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Isu è chang, “Gu è nathek shii khuchung mujo yaojong ro, jimagungde nathek ne migi anow. Chiih-è nyie blia yi gu è rek pha ji ne Hamangkhung-aphuii pha riichai è gu chiang shii khagi yao ro; ");
INSERT INTO bgg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jishii nathek ne migi anow phro, jiè nathek ne guro shiishai asi ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Guro shiishai ne guro gow yoi, chiih-è gune aishii de thieg, chiih-è ai ne gu rog luagieng phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gune ithek shii idang pha chai phi ruii phro, chiih-è ai ne khuchung de a-iy phro. Hanyie magungde ithek shii gu è ariao mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Guro aphuii è gu shii nyie phi pha ji ne zab è de boh ro, chiih-è hanyie magungde aphuii è wie gayiig pha ji ne ariao mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aphuii nane gune jia bie ro.” ");
INSERT INTO bgg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chiihphado bran è aishii chao pha lubao chiing. ");
INSERT INTO bgg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Isu è aishii yao, “Aphuii è gu shii rek bo ne phi pha blia wie ne gu è nathek ibi rek phi; chiih-è nyie blia re-è nathek gu shii lubao è chao pha now phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ithek è chang, “Gathek de naro blia wie jiè ne na shii lubu achau mayang, jimagungde na è Hamangkhung-aphuii shii biwo yao, na ne bran bie jishii nawaishii Hamangkhung-aphuii rab ro!” ");
INSERT INTO bgg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isu è chang, Hamangkhung-aphuii è nathek ne biidiie pha hamangkhung-aphuiithek rone yao pha ji ne nathek ro Iphey shii de zey ne um ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Gu ne thieg, Jigi shii yao pha ji ne idang pha izai chak ro; chiih-è hanyie shii airo mua phi jong pha bran shii ne Hamangkhung-aphuii è chad rone ho ro. ");
INSERT INTO bgg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gu shii ne Hamangkhung-aphuii è gua srane sohjambling shii thoh ge. Nyie khi-èrek ne, nathek ne gu è Hamangkhung-aphuii ro Dufuii rone yao pha ji ne biwo yao phrone yao ne bey? ");
INSERT INTO bgg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Gune Hamangkhung-aphuii è yang pha blia ji arek arone, gu shii migi arek rabo. ");
INSERT INTO bgg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jishii gu ai è yang pha ji shii rek magunde nathek gu shii migi anow ro, nathek ne gu è rek pha ji è aphuii gu shii um rone chiih-è gune aphuii rog shii um rone nathek ne gu blia shii ìujia ne migi rek miidang bo. ");
INSERT INTO bgg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ithek è aishii dinne zum pha rek shii, jishii Isu ithek wad è thua mua ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chiihphado Isu Jordan pha khamuii thrang hà Jon è khowo phi muii pha ithua shii dun ne thiichiih shii rai. ");
INSERT INTO bgg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Aishii bran bajo wuii thog srane yao. “Jon è ne buangthek pha blia ne arek, jimagungde ai è hì pha bran chiang shii nyie yao pha ji ne izai chak ro.” ");
INSERT INTO bgg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chiih-è thiichiih shii bran è de aishii bajo migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lazaras beng pha bran jia Bethany hà rai muii pha ji yi rad. Ji pha thawun Bethany ne Mery nane ai khuii Martha rai muii pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Ji pha Mery beng pha ji ne rem no pha ji è Ithong lai shii shun srane khajiang rek ne sad phi pha ji ro; chiih-è rad pha ji ne ai buphuii Lazaras ji ro.) ");
INSERT INTO bgg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazaras ro amuii è Isu shii mua thoh ge, “Ithong, naro bushun ijak ne rad muii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Isu è ji yoi mage shii, ai è yao, “Lazaras murad jine iy sapho asi ro; hì rey pha ji ne Hamangkhung-aphuii shii biisiie doh yi pha ji rey ro. Hì pha blia è Hamangkhung-aphuii pha Dufuii shii bo biisiie mua ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Isu è Martha nane ikhuii chiih-è Lazaras shii miie rek. ");
INSERT INTO bgg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ai ne Lazaras rad pha mua ji yoi magungde ai ne thiisa hà danyi rai din marui. ");
INSERT INTO bgg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chiihphado è ai è awai samoy shii yao, “Cho gethek ne Judea hà iidoh dun sha rai haro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chiihphado shii samoy è yao, “Masdo,” “Ìujia inai pha ibi shii ai è nathek shii lubao rek ne chao pha rek; jimagunde thiisa hà dun din pha phak ne bey?” ");
INSERT INTO bgg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isu è chang, “Nathek jia shii ishak snanyi oi chak bey? Ji-è hanyie magunde hanai bo hà lua arone khuchung de akham phro, chiih-è ai ne sohjambling pha muchuang ji doh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jishii ai ne habiu hà lua arone kham dun phro, nyieliieshii aishii ne muchuang oi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Isu è ji è yao srane dinne yao, “Gu ijak Lazaras ne men dun ro, jimagungde gune wuii srane aishii sieng din yi pha ro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Samoythek è chang, Ithong, “Ai men mua arone, ai ne wie rey din ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ji ne Isu è Lazaras iy dun pha ji yao, jimagungde ithek mugao yi izai men pha ji gao. ");
INSERT INTO bgg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Isu è ithek shii wie yao, Lazaras ne iyjong dun ro, ");
INSERT INTO bgg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","jishii gu nathek chiang gune bajo sang ro jiè gune ai rog shii oi ro, jiè nathek ne migi now ruii phro. Ji-è cho gethek ne aishii wuii sha rai haro. ");
INSERT INTO bgg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas (Iwen rone ho muii pha ji) è awai ijak samoythek shii yao, “Cho gethek de zab Masdo rog shii wuii sha rai, chiihphado gethek de ai rog shii nya-iy mua gieng!” ");
INSERT INTO bgg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Isu sha hà wuii thog shii, ai è Lazaras iy ne wieng pha dawi rey sha pha doh. ");
INSERT INTO bgg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany yi Jerusalem è labiang uom athog ro, ");
INSERT INTO bgg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Judeanthek Lazaras iy muii pha bumuii Martha nane Mery shii lumuii hà azo yi pha rek phi pha wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martha è Isu wuiiramuii pha yoi mage shii, ai Isu shii si pha fuang hà wuii dun, jimagungde Mery ne hò iliing hà rai iang. ");
INSERT INTO bgg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha è Isu shii yao, “Ithong, na ne ichiih shii um iang arone, guro buphuii ne a-iy ba iwa! ");
INSERT INTO bgg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jishii gune thieg thuh shii magungde na è Hamangkhung-aphuii shii ai chiang nyie lia magungde ai ne na shii phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Isu è Martha shii yao, “Naro buphuii ne dinne hòi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ai è chang, “Gune thieg,” “Ai ne iidohhè pha inai shii ne dinne chai hòi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isu è Martha shii yao, gune hòi pha ji nane chai ji ro. Hanyie è gu shii migi rek arone ai ne iy dun magungde ai ne sieng din ruii phro; ");
INSERT INTO bgg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","chiih-è hanyie gu rog rai ne gu shii migi now arone khuchung de a-iy phro. Nathek de jishii migi now bey? ");
INSERT INTO bgg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ai-è chang, Ithong! “Ji chak ro.” “Gune na shii migi rek phro na ne Masi ro, Hamangkhung-aphuii pha Dufuii hanyie è ichiih sohjambling shii wuiiramuii pha ji ro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha è ji yao ched pha iidoh shii, iidoh wuii ne ai ikhuii Mery shii de ug ne ho srane yao, “Masdo ne ichiih shii um ro,” “Chiih-è ai è na shii sai ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mery è ji yoi mage shii, jai srane aishii si pha khthiie fuang hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Isu ne ji pha thiig shii athog ba, ai ne Martha è wuii si pha ithua shii ba.) ");
INSERT INTO bgg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mery fuang hà khia mage shii aishii nong gieng pha bran de Mery rog fuang khia gieng. Ithek è now shii ai ne wieng hà choh wuii ara è now ro. ");
INSERT INTO bgg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mery Isu moe shii wuii thog srane, Isu shii nyadoh dang shii, ai è Isu lai moe shii bam yao, “Ithong,” “Nathek ichiih shii um arone, gu buphuii ne a-iy ba iwa!” ");
INSERT INTO bgg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Isu è ai cho pha doh, chiih-è aishii riig shii ai rog shii um pha bran de cho ramuii; jiè ai lubu shii thoh ne ai de bajo zodun. ");
INSERT INTO bgg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ai è ithek shii sai, “Nathek è aishii khi hà wieng muii phlei?” Ithek è chang, “Ithong, thawuii ne riig bo.” ");
INSERT INTO bgg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Isu è cho. ");
INSERT INTO bgg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bran è yao, “Riig mage bo ai ne aishii bajo miie rek ara!” ");
INSERT INTO bgg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jishii giak bran è yao, “Ai ne miegthi pha bran shii Miegthi yi bey? Ai ne Lazaras shii a-iy yi pha de arek mua bey?” ");
INSERT INTO bgg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Din ne, Isu bajo zo srane wieng hà wuii dun, ji pha wieng pha wog icho shii ne lubao kheb ne um. ");
INSERT INTO bgg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Isu è yung, “lubao ji hong mage bo!” Iy dun pha bran pha bumuii Martha è chang, “Ithong, thiisa hà ne bajo shong now ruii phro. Ai wieng pha ne dawi rey sha ro!” ");
INSERT INTO bgg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Isu è aishii yao, “Na ne migi rek arone na ne Hamangkhung-aphuii pha biisiie doh ruii phrone gu è na shii ayao ba bey?” ");
INSERT INTO bgg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ai è lubao shii ne reng mage. Isu è laziung hù ne yao, Aphuii, “Gune na shii laso phi, nyieliieshii na è gu shii nuii phi. ");
INSERT INTO bgg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Gune thieg nathek ne idang gu shii nuii phi, Jishii gune ichiih pha bran chiang yao phro chiih-è gu shii de na mutho rone ithek de migi rek ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ji pha iidoh shii, ai è gang è ziak srane ho, “Lazaras, fuang hà khia mage bo!” ");
INSERT INTO bgg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ai è fuang khia ruii shii, ai wad ai lai ai mizia shii wieng pha yung è jiang ne um. Isu è aishii yao, “Aishii sey mage bo,” “Chiih-è dun yi bo.” ");
INSERT INTO bgg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mery shii wuii pha bran bajo è Isu mirek ji doh ne, ithek aishii migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Jishii giak bran è Pharisithek rog khid din srane, Isu mirek pha miyao ji yao. ");
INSERT INTO bgg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ji-è Pharisithek nane boh phabithek laimiang shii si srane yao, “Gathek nyie khi-èrek sha pha lei? Riig mage bo hì pha bajo buangthek pha blia hì pha bran mirek ro! ");
INSERT INTO bgg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Gethek è aishii ji riig ne thoh muii arone, zab pha bran ne aishii migi rek dun phro, chiih-è Roman pha riichaithek ne gethek shii buii blia rek srane Misiahò nane gethek bran shii ne mua maphi phro!” ");
INSERT INTO bgg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ithek è jia, ji pha idam shii Kho Phabi Khaiphas beng pha è yao, na ne khama pha bi-ìe ro! ");
INSERT INTO bgg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na hì anow bey na shii ne hì wie liak phro gai pha bran chiih-è, zab pha bran shii mua liak shii ne bran jia iy liak ji wie ba phro. ");
INSERT INTO bgg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hì pha miyao yi ai è awai lum ne ayao; nyieliieshii, ji pha idam shii ai yi Kho Phabi, awai è riig Isu ne Jew pha bran chiang è iy ruii phro, ");
INSERT INTO bgg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Chiih-è Jew shii asi bie pha, jimagungde Hamangkhung-aphuii pha bran shii dayiingdayang rek muii pha siu shii de dinne ò shii khrab pha ro. ");
INSERT INTO bgg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ji pha iidoh è Jewish pha riichaithek è Isu shii ua pha nyuak rek. ");
INSERT INTO bgg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ji-è Isu Judea hà ug ne lua, chiih-è ji pha ithua thoh marui srane balimuang moe Ephraim beng pha thawun hà dun srane, thiisa hà samoy rog hà raidun. ");
INSERT INTO bgg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chiih-è Hiìadun Sai pha ishak nui rey sha mage shii, branthek soh re-è Jerusalem hà wuii ne Sai pha ibi shii zen pha muhui sang rekwuii phro. ");
INSERT INTO bgg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ai yi Isu shii riig ramuii, chiih-è ai Misiahò shii khrab, ai è awaithek chung sai rai, “Na nyie ro è now lei? Zai ai ne Sai pha inai shii awuii ruii habey? Asi ai wuii ruii habey?” ");
INSERT INTO bgg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Phabi bohthek nane Pharisithek è yung srane ruii hanyie magungde Isu khi hà um pha ji thieg arone, gathek shii phosro bo, jiè ithek ne aishii zum mua yi pha ji rek. ");
INSERT INTO bgg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Hiìadun pha dariig ibi, Isu Bethany hà, ai è iy dun pha bran shii hòi phi pha, Lazaras hò hà wuii. ");
INSERT INTO bgg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Thiisa hà ithek è Isu shii michie saro phi, chiih-è Martha yi michie chog pha nong gieng; chiih-è Lazaras ai de Isu rog thiibliie shii dug gieng. ");
INSERT INTO bgg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chiihphado shii Mery è bajo igong rek pha chiih-è bajo rem now pha thiiliie, sasia khuyo jia yie srane, Isu laishii shunphi, chiih-è awai khaziang rek ne shadphi. Hò iliing shii ne sumaro ji è zab noh dun. ");
INSERT INTO bgg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Isu ro samoy è jia, aishii zum pha rek muii pha Judas Iskharioth ji è yao, ");
INSERT INTO bgg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nyie rek ne hì pha sumaro yi wieng uom liiman bang shii liu ne, bang yi dusho shii aphi lei?” ");
INSERT INTO bgg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ai è hì yao pha ji ne dusho shii wie rek rone ayao ro, jimagungde ai ne mugo ro. Ai ne bang biia han srane ji è awaishii nong din phro. ");
INSERT INTO bgg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jishii Isu è yao, “Bimi shii awai ji thoh muii bo! Ai ne gu shii wieng pha inai ji rek ne rai yi bo. ");
INSERT INTO bgg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na shii ne idang dusho bran um ruii phro, jimagungde ai ne idang gu rog shii oi phro.” ");
INSERT INTO bgg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Isu ne Bethany hà um rone bran bajo è yoi, jiè ithek ne sha hà wuii dun, jimagungde ai ne Isu shii riig bie pha asi pha iy dun pha jishii Isu è hòi din phi pha, Lazaras shii de riig pha wuii. ");
INSERT INTO bgg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ji-è boh phabithek è Lazaras shii de bajo ua pha phak, ");
INSERT INTO bgg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nyieliieshii ai chiang è bajo Jewthek è ithek shii snai srane Isu shii migi rekdun. ");
INSERT INTO bgg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Din pha inai shii Hiìadun Sai pha ji shii wuii pha bajo bran è yoi, Isu yi Jerusalem hà wuiiramuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ji-è ithek ne iphang yi ne fuang hà aishii si pha wuii dun, chiih-è ziak srane Hamangkhung-aphuii shii “Chiong, Hamangkhung-aphuii aishii ne khirzey phi bo! hanyie Ithong beng è wuii, chiih-è Hamangkhung-aphuii Israel pha Saja shii de khirzey phi bo!” ");
INSERT INTO bgg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jigi shii yao pha duiine, Isu è bambao jia doh ne jishii in srane wuii, ");
INSERT INTO bgg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Arum chid rabo, Zion rajan phothek!” bambao ipheang è in ne, Nathek Saja ichiih wuii sha ruii ro. ");
INSERT INTO bgg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ji pha ishak shii airo samoythek è agao, chiihphado è Isu biisiie shii hòi mage shii, jigigam shii yao pha ji aishii yao ara ithek è now. ");
INSERT INTO bgg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Chiih-è Isu rog shii um pha bran è Isu è Lazaras shii iy ne wieng bucho è hòi din yi pha miyao ji chiih-è nyie rey pha ji phosro. ");
INSERT INTO bgg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ji-è ai ne aishii si wuii, nyieliieshii ai ne ji pha buang rek pha yoi. ");
INSERT INTO bgg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ji-è Pharisithek è gai jia shii yao, “Nathek riig mage bo! Gathek rone nyie de zab arey ro! Riigbo, sohjambling pha zab ne aishii luagieng dun ro!” ");
INSERT INTO bgg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sai pha ishak shii Jerusalem hà wuii pha giak Grekhthek de um. ");
INSERT INTO bgg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ithek Philiph shii wuii sra (ai ne thiisa Bethsaida è Galili) ne yao, “Masdo, gathek Isu shii riig yang muii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philiph è Andrew shii wuii srane yao, chiihphado shii bran nyi wuii srane Isu shii yao. ");
INSERT INTO bgg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Isu è isa shii chang, “Bran dufuii ne boh biisiie mua pha ishak ne thog sha ro. ");
INSERT INTO bgg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gu nathek shii zai yao: Igam yi nyiak hà chiih ne Ai a-iy sapho shii ne igam jia rai phro, chiih-è nyiak hà wieng ne ai iy mage shii, dinne bajo igam rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hanyie è awai chai shii miie pho ne mua ruii phro, chiihphado hanyie è ichiih sohjambling shii awai chai shii mua arone ai ne khuchung de a-iy pha sieng pha ji mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hanyie gu shii nong pha yang arone gu iidoh shii luagieng bo, nyieliieshii gu khi hà um lei ne guro khiao de ji hà um ruii phro. Chiih-è hanyie è gu shii nong lei ne gu Aphuii è de aishii ilab rek phi. ");
INSERT INTO bgg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Thuh guro lubu ne diig rey dun—Chiih-è gune nyie yao sha pha lei? Gu è yao, Aphuii, hì pha ishak ne gu shii athog yie habey? Jimagungde jiè gune wuii—Ji-è gune airo diig pha ishak shii wuii mua. ");
INSERT INTO bgg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aphuii, na beng pha biisiie yi bo!” Chiihphado hamangkhung è yao, “Gu è airo biisiie yijong ro, chiih-è de dinne gu rek ba pha ro.” ");
INSERT INTO bgg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","“Chiihphado thiichiih shii iphiing riu pha bran è de yoi, chiihphado giak è yao hì ne hakhliing ro, chiih-è gai è yao hì ne hamangkhliie aishii yao ro!” ");
INSERT INTO bgg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jishii Isu è ithek shii yao, hì yao pha goh hì ne gu chiang asi ro, jishii nathek chiang shii yao ro. ");
INSERT INTO bgg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Thuh ne ichiih sohjambling shii chua pha ishak ro; chiih-è ichiih sohjambling pha khohpho shii ne zab fen ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","“Gu shii sohnyiak è chang mage shii, gu zab gui moe hà rai pha ro.” ( ");
INSERT INTO bgg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hì è yao pha ji ne ai khi-è diig rek ne iy pha mua ji yao.) ");
INSERT INTO bgg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bran iphiing è chang, “Gathek ro Iphey shii ne gathek shii yao Masi ne khuchung de a-iy pha sieng ne rai phro. Chiih-è, khi-èrek, mua ne bran dufuii shii lakhung chang pha nathek yao phlei? Ji pha bran dufuii ne hanyie lei?” ");
INSERT INTO bgg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Isu è chang, muchuang ne nathek duchoi shii inai ìujia rai bie ruii phro. Ji-è nathek shii muchuang nyaum shii nawaithek athodang pha blia rek bo; jiè igiia ne nathek duchoi hà athog yi rabo, chiih-è hanyie jia è igiia shii luapho ne khi hà luaramuii pha ji athieg ro; chiih-è hanyie yi igiia shii lua arone ai ne khi hà wuiiramuii pha ji athieg phro. ");
INSERT INTO bgg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Muchuang nathek duchoi um ba shii nathek ne muchuang shii migi rek bo, ji-arone nathek ne isang pha bran rey ruii phro. Isu è ji yao pha iidoh shii, ai dun marui srane ai adoh yi pha ug ne rai muii. ");
INSERT INTO bgg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Chiih-è ai è ji buangthek ithek moe shii rek magungde ithek è aishii migi arek, ");
INSERT INTO bgg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ji-è chaig pha Aijaya è nyie yao pha ji ne izai rey ro: “Ithong, gathek miyao pha mua ji ne hanyie è migi rek phlei?” Chiih-è “Ithong, ro blu ne hanyie doh phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ji-è ithek ne migi arek mua ro, nyieliieshii Aijaya è din yao, ");
INSERT INTO bgg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Hamangkhung-aphuii è ithek ro miegthek ne kheb muii, chiih-è ithek ro khani ne bin muii, jiè ithek mieg ne ariig mua, chiih-è ithek ro khani ne agao mua, chiih-è ithek ne gu hà akhid ro, Hamangkhung-aphuii è yao, gune ithek shii wie rek phi pha.” ");
INSERT INTO bgg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aijaya è hì pha miyao yi Isu ro, biisiie riig srane ai pha miyao ji yao. ");
INSERT INTO bgg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jishii, Jewthek pha dumuii de Isu shii migi rek; jishii nyieliieshii Pharisithek è aishii Jewthek misiahò è khia ge è now ne rum ne lakhung è ayao. ");
INSERT INTO bgg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ithek ne Hamangkhung-aphuii è rek phi pha ji re-è ne tharothamang mirek phi pha ji shii miie ro. ");
INSERT INTO bgg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Isu è ziak ne yao, “Hanyie gu shii migi rek gu jia shii migi arek jimagungde gu shii thoh ge pha aishii de migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hanyie gu shii doh gu shii thoh ge pha ji shii de doh ro. ");
INSERT INTO bgg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Gune sohjambling shii muchuang rey ne wuii ruii phro, ji è hanyie magungde gu shii migi rek arone, ai ne dinne igiia hà arai sha phro. ");
INSERT INTO bgg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Chiih-è hanyie magungde gu miyao yoi ne anuii magungde gu aishii achua ruii phro. Gu ne ichiih sohjambling shii chua pha awuii ro, jimagungde gune ragia rek pha wuii. ");
INSERT INTO bgg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hanyie è gu shii snai ne gu mua ji anuii pha rek arone aishii chua pha ne jijia bie ro. Gu miyao pha miyaogamthek ai iidoh pha inai shii chua ruii phro! ");
INSERT INTO bgg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hì ne izai ro, nyieliieshii gu miyao hì ne gui muyung ne ayao ro, jimagungde gu shii thoh ge pha Aphuii è gu shii nyie khi è yao chid pha ji yung phro. ");
INSERT INTO bgg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Chiih-è gune thieg hì è yung pha hì ne idang pha chai phi ro. Chiih-è gune nyie yao, pha hì ne Hamangkhung-aphuii è gu shii nyie yao yi pha ji yao phro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hiìadun Sai pha inai ibi shii, Isu ne thieg ai ne sohjambling shii thoh marui srane Aphuii shii dun pha ishak rey sha. Ai è awairo sohjambling pha bran shii ne idang miie rek, chiih-è ai ne iidohhè thog magungde ithek shii bajo miie rek. ");
INSERT INTO bgg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Isu nane airo samoy yi michie ji hà um shii, Isu shii zum pha now pha ji ne ibuii è khuchung mujo Simon Iskharioth ro dufuii Judas lubu iliing hà khudjong. ");
INSERT INTO bgg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isu ne thieg Hamangkung-aphuii blu ne zab aishii phi ne ruii; chiih-è ai ne thieg ai ne Hamangkhung-aphuii è wuii jiè ai ne Hamangkhung-aphuii hà dun pha ro. ");
INSERT INTO bgg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chiihphado shii ai thiibliie è jai srane awai yung yi ne radang rek ne awai rinyie shii riing. ");
INSERT INTO bgg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chiihphado shii ai è kharhai shii kho thoi srane awai samoythek lai shii jao ne shudphi srane awai rinyie shii riing pha yung thileg ji rek ne sadphi. ");
INSERT INTO bgg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chiih-è ai Simon Phithar shii wuii thog mage shii, ai è Isu shii yao, “Ithong, na ne gathek lai shud phi pha rek ne bey?” ");
INSERT INTO bgg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Isu è chang, “Nathek ne athieg phro thuh shii gu nyie rekramuii pha ji ne, jimagungde doh hà nathek thieg ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Phithar è yao, “Asi khuchung magunde gu ro lai ashud rabo!” Isu è chang, “Gu nathek ro lai ashud phi arone,” “Na ne gu ro idang pha samoythek arey mua phro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Phithar è chang, “Ithong, chiihphado gu lai jia shii ashud bie pha, gu wad nane gu khrug shii de zab shudphi bo!” ");
INSERT INTO bgg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isu è yao, “Hanyie è sudjong pho ne zab so sha ro chiih-è awaithek lai sud bie srane asud sha chid phro, chiih-è nathek zab ne so sha ro. Bijiu jia ne sang asi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Isu ne khuchung muzo thieg jong hanyie è aishii zum pha rek pha ji ne; ji ne ai nyie um ne yao, “Nyieliieshii bran jia ne zea ro jishii gai zab ne so ro.”) ");
INSERT INTO bgg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chiihphado shii Isu è airo lai shud ched shii, ai è awai yung guii srane awai thiibliie ji hà khid din. Ai è sai, “Thuh shii nathek ne thieg bey gu nyie rek phi pha ji ne?” ");
INSERT INTO bgg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nathek è gu shii Masdo nane Ithong ro ho, jimagungde nathek munow ji ne izai chak ro, nyieliieshii gune ji chak ro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nathek Masdo nane Ithong gu è nathek lai shudphi jiè nathek de Nawaithek lai shud rai bo. ");
INSERT INTO bgg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gu è nathek shii thieg yi pha ji rek chak, nyieliieshii gu è thuh shii nyie khi-èrek phi pha ji ne, nathek de rek mua. ");
INSERT INTO bgg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gu nathek shii izai yao: Khiao ne Ithong è boh asi ro, chiih-è muaphothek ne hanyie è aishii thoh ge pha ji è boh asi ro. ");
INSERT INTO bgg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nathek ne thuh shii hì pha isbang thieg ne, ji duiine rek arone nathek ne khama sang ruii phro! ");
INSERT INTO bgg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Chiih-è gu nathek zab chiang shii ayao ro; jimagungde gui è gua pha ji gune thieg ro. Jimagungde jigigam shii nyie yao pha ji ne izai rey pha, ‘Gu rog shii michie thang ne chie gieng pha bran ji ne gu shii gidieg rek din ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Thuh shii gu hì arey pha ibi shii yao, jiè khuchung magunde ji rey mage shii, nathek ne gu ji chak ro è migi rek ruii phro.’ ");
INSERT INTO bgg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gu ne nathek shii izai yao: Hanyie gu è thoh ge pha ji shii choi arone gu shii de choi ro; chiih-è hanyie gu shii choi arone gu shii thoh ge pha ji shii de choi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Isu è ji yao ched pha iidoh shii, ai lubu iliing è diig now srane yao. “Gu nathek shii izai yao phro: Nathek è bran jia ne gu shii liu ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chiihphado è samoythek awai chung riig srane, ai è nyie yao pha ji nuii ne zab anomuluii pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Isu ro samoythek è, ai è miie rek muii pha jia ji ai moe shii dug. ");
INSERT INTO bgg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Phithar è aishii phrai srane sai, “Ji pha bran ji ne hanyie shii yao phlei ne sai bo.” ");
INSERT INTO bgg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chiih-è samoy ji Isu moe nui hà wuii srane sai “Ithong ji pha bran ji hanyie lei?” ");
INSERT INTO bgg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isu è chang, “Gu è iweb ji shii jo srane hanyie shii phi ruii, ji pha bran ne airo.” Ai è iweb khuyo ji yie ne, jo srane, Simon Iskharioth ro dufuii Judas shii phi. ");
INSERT INTO bgg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas è iweb ji nya choi dang mage shii, ai iliing shii sakhathong khuddun. Isu è aishii yao, “Na nyie rek pha ji ne khthiie rek mage bo!” ");
INSERT INTO bgg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Thiibliie shii dug pho Isu è aishii nyie yao pha ji ne hanyie de khthiie agao ro. ");
INSERT INTO bgg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ne bang biia pha dumuii bran ro, giak samoythek è yao Isu è aishii sai pha inai shii nyie ched pha ji pheg pha thoh ge iwa, chiih-è yang ne dusho shii phi pha thoh ge phro. ");
INSERT INTO bgg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas è iweb ji choi srane khthiie fuang hà wuii dun, ji ne habiu shii ro. ");
INSERT INTO bgg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas fuang wuii dun pha iidoh shii, Isu è yao, Bran Dufuii ro biisiie ne reyge ro; chiih-è ai chiang è Hamangkhung-aphuii ro biisiie ne reyge ro. ");
INSERT INTO bgg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chiih-è ai chiang è Hamangkhung-aphuii ro biisiie rey ge arone, Hamangkhung-aphuii shii de bran Dufuii pha biisiie chiang è doh yi phro, chiih-è ai ne khthiie rek phi phro. ");
INSERT INTO bgg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Gu ani, gune nathek rog shii inai bajo arai sha ro. Na gu shii so ruii phro; gu è Jewish riichaithek shii yao pha duiine gu thuh nathek shii de yao, “Gu khi hà dun pha ji hà ne nathek awuii mua sha phro.” ");
INSERT INTO bgg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ji-è gu ne nathek shii iwo muyung phi pha ro: Nawaithek chung miie rek rai bo. Gu è nathek shii miie pha duiine, chiih-è nawaithek chung de miie rai bo. ");
INSERT INTO bgg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chiih-è nawaithek chung miie arone, nathek ne gu ro samoy ro è zab thieg ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Phithar è aishii sai, “Ithong na khi hà dun sha phlei?” “Isu è chang; gu dun pha ithua ji hà ne nathek ne thuh shii ne alua mua gieng phro,” Jmagungde doh è nathek de lua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phithar è sai, Ithong, thuh shii gu nyie rek ne na rog shii alua mua phlei? Chiih-è gune na rog shii iy pha de nya saro mua phro! ");
INSERT INTO bgg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Isu è chang, na ne izai gu rog shii iy pha nya saro gieng ne bey? Gu nathek shii izai yao: Khey a-èo ba pha ibi shii na ne gu shii athieg ro è ne uom chiieng yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Isu è aishii yao, na lubu shii samdiig nane duhug arek ched rabo, Hamangkhung-aphuii shii migi rek mage bo, chiih-è gu shii de migi rek mage bo. ");
INSERT INTO bgg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Thiisa hà Aphuii hò shii ne ùgudthek bajo um ro, chiih-è gune thiisa hà dun srane nathek ro ithua saro iang pha ro. Thiisa ithua oi arone gu nathek shii ayao phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chiih-è dun srane nathek ro ithua saro marui ne, gu iidoh wuii din ne nathek shii gui rog shii noh pha ro, chiih-è gu khi hà rai lei ne nathek de ji hà rai ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","“Gu ne khi pha ithua hà noh dun ramuii pha lumuii ne nathek ne thieg.” ");
INSERT INTO bgg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas è aishii yao, “Ithong, gune athieg na khi hà dun jiè gathek ne khi-èrek ne ji hà wuii pha lumuii thieg phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isu è chang, “Gu ne lumuii, chiih-è izai, chiih-è sieng pha ne gu ro, gu è asi sapho shii ne hanyie magungde Aphuii shii awuii mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ai è aishii yao, thuh shii nathek ne gu shii thieg arone, nathek ne gu Aphuii shii de thieg ruii phro, chiih-è thuh è thiwing nathek è aishii thieg ne nathek ne aishii doh jong ro.” ");
INSERT INTO bgg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philiph è aishii yao, “Ithong, gathek shii de ji pha Aphuii riig noh bo; ji nyama gathek chid muii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isu è chang, “Gu nyama pha inai nathek rog shii um; jimagungde nathek ne gu shii athieg ba bey, Philiph?” Chiih-è hanyie gu shii doh jong, ai ne Aphuii shii de doh jong ro. Chiih-è, nyie rek ne gathek shii Aphuii doh noh bo è yao phlei? ");
INSERT INTO bgg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nathek ne migi arek bey, Philiph, gune Aphuii rog shii um, chiih-è Aphuii ne gu rog shii um? Isu è awai samoythek shii yao, gu miyaogamthek na shii yao pha ji ne, gu è ayao ro, chiih-è gu shii um pha Aphuii ji ne awai blia rek ro. ");
INSERT INTO bgg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gu ne Aphuii shii um rone chiih-è Aphuii ne gu shii um rone gu hì è yao pha ji ne migi rek bo. Ji asi arone, gu mirek phi pha chiang ji è migi rek bo. ");
INSERT INTO bgg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gu nathek shii izai yao: Hanyie gu shii migi rek arone gu nyie rek pha ji ne ai de rek mua, chiih-è ai ne jiè de huak ne rek mua ruii phro, nyieliieshii gune Aphuii shii dun sha. ");
INSERT INTO bgg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chiih-è nathek gu beng shii nyie lia pha ji ne gu nathek shii rek phi, ");
INSERT INTO bgg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Chiih-è Dufuii chiang è Aphuii ro biisiie doh mua. Nathek gu beng è nyie lia magunde, gu rek phi pha ro. ");
INSERT INTO bgg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nathek gu shii miie arone, nathek guro muyung ji nuii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Gu è Aphuii shii lia, chiih-è ai è nathek shii yo nongpho phi ruii phro, chiih-è ai ne idang nathek rog shii rai ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ai ne Hamangkhung-aphuii ro izai ji doh noh pha Ragung ro, sohjambling de aishii achoi mua, nyieliieshii ne aishii ariig athieg mua phro, jishii nahek ne aishii thieg, nyieliieshii ai ne nathek rog shii rai phro chiih-è nathek iliing hà rog rai jong. ");
INSERT INTO bgg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Khuchungde gu dun shii, nathek ji atho marui phro; gu ne iidoh wuii din ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Iùjia ishak pha iidoh shii sohjambling pho ne gu shii adoh mua sha phro, jimagungde nathek ne gu shii nyariig mua; nyieliieshii gune isieng ro, chiih-è nathek de sieng ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ishak thog mage shii, nathek ne thieg ruii phro, gune Aphuii rog shii um ro, chiih-è gu nathek rog shii um pha duiine, nathek ne gu rog shii um phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Hanyie è guro muyung shii choi ne nuii pho ne gu shii miie rek chak ro. Hanyie è gu shii miie rek arone gu aphuii è aishii miie rek ruii phro; chiih-è gu de aishii miie rek srane gui shii ai lakhung shii thoh phi phro.” ");
INSERT INTO bgg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas è (Judas Iskharaiod asi) yao, “Ithong, chiih-è nawaishii zab sohjambling pho shii asi pha gathek lakhung shii khi-èrek ne thoh ruii phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isu è aishii chang, hanyie chai gu shii miie rek pho ne gu miyao ji nuii phro. Chiih-è gu Aphuii ne aishii miie rek ruii phro, chiih-è gu aphuii na ne gune ai rog shii rai ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hanyie è gu shii miie arek pho ne gu muyua ji de anuii phro. Chiih-è gu nathek nuii pha muyua ji ne gu ro asi ro, ji pha muyua ji ne hanyie è gu shii thoh ge pha Aphuii è thog phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Hì pha miyao ji ne gu nathek rog shii nya um pha shii yao phro.” ");
INSERT INTO bgg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gu beng shii aphuii è thoh ge pha nongpho, Ragung So, na shii zab yua ne now phi phro, gu è nathek shii yao pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Liijiing ne gu nathek shii thoh marui; gu è nathek shii phi pha lubo ji gui ro ro.” Sohjambling pho nathek shii phi pha ji ne gu nathek shii aphi phro. Chiih-è diig now ne duhug arek chid rabo, chiih-è arum ched rabo. ");
INSERT INTO bgg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gu è nathek shii yao pha ji ne na ne nuii, “Gu ne thoh ne dun sha, jimagungde gu iidoh nathek shii wuii din ruii phro.” Na gu shii miie rek chak arone gu aphuii hà dun shii ne na lised ruii phro; chiih-è aphuii ne gu è boh ro. ");
INSERT INTO bgg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Thuh shii hì arey ba pha ibi shii gu nthek shii yao. Chiih-è hì rey mage shii, nathek gu shii migi rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gu nathek rog shii bajo amulo mua sha phro, nyieliieshii sohjambling shii boh rek pho ne wuii sha ruii ro. Ithek ne gu lakhung rangsua oi phro, ");
INSERT INTO bgg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Jishii sohjambling pho ne thieg chid phro gune Aphuii shii miie rek, nyieliieshii ai mizen ji ne gu è zab rek phi. Thawuii ne, cho hì pha ithua è dun sha rai haro. ");
INSERT INTO bgg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Gu ne izai iphang ro, chiih-è riigpho ne gu Aphuii ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ai è Iwoi wie awoi pha ji shii ne zab hìdmuii, chiih-è iwoi wie pha idiphak shii ne bsang phi, jiè hì ne sang rey ne iwoi wie woi ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gu muyua phi pha miyao jiè nathek shii ne sang rab jong ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nathek ne gu shii ò rey ne rai bo, chiih-è gu de nathek rog shii ò rey ne rai pha ro. Chiih-è idiphak ji awailum ne iwoi awoi mua phro ai ne iphang shii ò rai arone iwoi woi mua bie phro; jiduii ne nathek de gu rog ò arai sapho shii ne nathek de iwoi awoi mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Gu ne iphang ro, chiih-è idiphak ne nathek ro, hanyie gu shii ò rai arone, gu de aishii ò rai ruii phro, chiih-è ai ne iwoi bajo woi mua ruii phro; ji è gu è asi shii ne nathek nyie de arek mua phro. ");
INSERT INTO bgg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hanyie è gu shii ò arai arone idiphak duiine fuang hà fen srane, chiih-è gow dun; chiih-è idiphak shii khrab srane bai shii fuii muii phro, chiih-è hùb dun phro. ");
INSERT INTO bgg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nathek de gu rog shii ò rai ne, chiih-è gu miyaogamthek de nathek shii ò ne rai arone, nathek nyie ched pha ji lia magunde, nathek shii mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Gu Aphuii pha biisiie ne nathek è iwoi bajo woi pha ji re-è doh yi ro; jiè nathek ne gu ro samoythek rey ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Gu nathek shii miie ro, aphuii è gu shii miie rek pha duiine, chiih-è nathek guro miie rek pha ji shii ò ne rai bo. ");
INSERT INTO bgg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Gu è Aphuii muyungthek ji nuii srane airo miie shii ò ne rai pha duiine, nathek de gu muyung ji nuii srane, gu ne airo miie shii rai ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Gu nathek shii hì yao pha ji ne gu ro lubo yi nathek rog shii rai yi, chiih-è nathek ro lubo de zab rey mua.” ");
INSERT INTO bgg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gu muyung ne hì ro: Gu è nathek shii miie rek pha duiine, nawaithek chung de miie rek bo. ");
INSERT INTO bgg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hanyie è awai ijak chiang shii iy phi pha ji è ne boh miie oi sha ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Chiih-è nathek ne gu ijak ro nathek ne gu è zen pha ji nuii arone, ");
INSERT INTO bgg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gu nathek shii dinne khiao anow sha phro, nyieliieshii Ithong è rek pha ji ne khiao è athieg ro, jiè gu nathek shii ijak ro è ho sha pha ro, nyieliieshii gu Aphuii è nyie nuii pha ji ne zab nathek shii yao ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nathek è gu shii agua ro, jimagungde gu è nathek shii gua srane nathek shii iwoi woi yi pha bow phro, chiih-è nathek ro iwoi ne idang rey ne rai bo. Chiih-è Aphuii shii nathek è gu beng shii nyie lia pha ji ne Aphuii è nathek shii phi. ");
INSERT INTO bgg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ji-è, gu nathek shii nyie khi è muyung phi pha ji duiine, nawaithek chung miie rek rai bo. ");
INSERT INTO bgg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ichiih pha sohjambling pho è nathek shii khiijai rek ruii arone, nathek ne è now bo ithek ne gu shii gidieg rek bi phro.” ");
INSERT INTO bgg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nathek de sohjambling pha arone, sohjambling pho ne nathek shii awaithek ro duiine miie rek ruii phro. Jishii gu è nathek shii sohjambling è gua jong ro, nathek ne sohjambling re-è asi sha ro, jiè nyieliieshii ne sohjambling pho è nathek shii gidieg rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Ji-è gu è nyie yao pha ji ne nowkhlei bo; khiao ne awai Ithong è ne boh asi phro.” Chiih-è bran è gu shii diig rek arone, nathek shii de bajo diigchio rek ruii phro; chiih-è ai gu miyao pha miyao ji nuii arone, ithek de nathek shii bajo nuii phi phro. ");
INSERT INTO bgg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jishii ithek è nathek shii irek pha ji ne nyieliieshii nathek ne guro habuii ne ji rek ro, nyieliieshii ithek ne gu shii thoh ge pha ji ne athieg ba ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Gu è awuii ne ithek shii ayao arone ithek shii ne layog athe, jiè thuh shii ithek ichiih pha layog ji è yo pha lumuii oi ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hanyie è gu shii khiijai rek arone gu Aphuii shii de khiijai ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hanyie è de arek pha blia ji gu è ithek duchoi shii arek phi arone, ithek ne ichiig layog ji ne oi pha habuii shii, ji gu è nyie rek pha ji ne ithek è dohjong, chiih-è ithek è aphuii nane gu shii khiijai rek. ");
INSERT INTO bgg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hì ne nyie um rey pha ne Iphey shii nyie zey ne um pha ji ne zab izai rey pha ji rek ro: Jimagungde ithek è gu shii khiijai pha ne nyie ichiig de oi ro. ");
INSERT INTO bgg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nongpho ne wuii ruii—Jine Ragung ro, hanyie yi Hamangkhung-aphuii chiang shii izai dong pha chiih-è hanyie ne Aphuii re-è wuii ro. Gu ne gu Aphuii re-è aishii nathek hà thoh ge srane ai ne gu chiang shii yao ruii phro ");
INSERT INTO bgg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chiih-è nathek zab de gu chiang yao ruii phro, nyieliieshii nathek ne igobi re-è gu rog shii um ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Gu nathek shii hì è yao pha ji ne, nyieliieshii nathek migi ji atho yi pha ji yao.” ");
INSERT INTO bgg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nathek shii Jewthek misiahò è khia mua phro, jimagungde ji re-è rek pha ishak thog ruii phro, ithek è nathek shii ua srane hì è now phro ithek mirek ji ne Hamangkhung-aphuii ro blia ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bran è nathek shii ji rek pha ji ne, nyieliieshii ithek ne Aphuii nane gu shii ne a-ìd ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jishii gu è nathek shii hì yao pha ji ne, nathek shii ji è rek pha airo ishak thog mage shii, gu è nathek shii nyie yao pha nathek ji now ruii phro. “Gu nathek rog ba shii hì pha miyao hì igobi hà ayao ro— Nyieliieshii gu ne nathek rog shii um ro” ");
INSERT INTO bgg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jishii thuh gu shii hanyie è thoh ge ai hà dun sha pha ro, na khi hà dun sha pha lei ne nathek è hanyie de gu shii asiie sha phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jishii thuh gu nathek shii hì yao phro, nathek lubu ne ley duhug ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jishii gu nathek shii izai yao: Gu ichiih è dun liak shii ne nathek shii wie ro, chiih-è gu ichiih re-è adun arone, nongpho ji ne nathek shii awuii ruii phro. Jimagungde gu dun arone, gu è aishii nathek hà thoh ge pha ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ai wuii ruii shii, ai è ichiih sohjambling pha branthek ne layog miyao ji nane rangsua miyao ji chiih-è Hamangkhung-aphuii ro gua pha miyao shii ne bia dun rone khagi rek ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aishii layog ro è yao pha miyao ji ne, nyieliieshii ai ne gu shii migi arek; ");
INSERT INTO bgg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ithek ne niye izai chiang shii ichiig ro, nyieliieshii gune Aphuii shii dun sha, chiih-è gu shii ariig mua sha ruii phro; ");
INSERT INTO bgg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chiih-è chua pha ji shii de ichiig rey dun ro, nyieliieshii ichiih sohjambling shii bohkhothek è khuchung muzo aishii guajong ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Gu nathek shii yao pha ne bajo um shii, jimagungde thuh shii nathek ne azud mua ro, ");
INSERT INTO bgg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","khuchung magunde ragung wuii ruii shii Hamangkhung-aphuii pha chiang izai miyao ji yao ruii phro, ai è nathek zab pha izai hà noh ruii phro, ai ne awai pha rangsua è ayao ro, jimagungde ai ne nyie ai è yoi pha ji chiih-è nyie rey ruii pha ji nathek shii yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Chiih-è ai ne gu shii biisiie phi ruii phro, nyieliieshii gu è nyie yao pha ji yie srane nathek shii yao pha um ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gu Aphuii shii um pha ji ne zab guro ro; jiè gu hì yao phro chiih-è gu è nyie yao pha ji yie srane Ragung re-è nathek shii yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Iùjia pha iidoh shii nathek ne gu shii adoh sha ruii phro, chiih-è ìujia pha iidoh shii nathek gu shii doh ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Giak samoythek è awaithek chung sai rai, “Hì pha miyaosiu ne nyie ga?” Ai è gethek shii yao ìujia ishak pha iidoh shii gethek ne aishii adoh ruii phro è yao, chiih-è ìujia pha iidoh shii gethek aishii doh; chiih-è ai hì de yao, “Nyieliieshii gune Aphuii shii dun sha.” ");
INSERT INTO bgg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Iùjia pha iidoh pha miyao ji nyie yao phlei? Chiih-è ai nyie yao pha ji gethek ne athieg! ");
INSERT INTO bgg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isu è thieg jong nathek ne aishii sai pha now, jiè ai è ithek shii yao, “Gu è yao, ìujia pha iidoh shii nathek gu shii adoh sha ruii phro, chiih-è ìujia pha iidoh ishak nathek gu shii doh ruii phro. Nawaithek chung hì pha miyao chiang è sai rai ne bey?” ");
INSERT INTO bgg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gu nathek shii izai yao: Nathek ne duhug rek ne choh ruii phro, jimagungde sohjambling pho ne sang ruii phro, nathek ne duhug rek ruii phro, jimagungde nathek duhug ji ne sang bsa hà khid ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hò-amuii ne ani giak pha rey mage shii, ai bajo duhug rek nyieliieshii airo diig rey pha ne ishak thog sha; jimagunde ai ani giak mage shii, ai ne awairo riie pha ji bia dun, ai ne sang nyieliieshii ani jia ne sohjambling shii giak ge. ");
INSERT INTO bgg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ji duiine nathek rog shii de um phro, thuh shii nathek ne duhug, jimagungde gu ne nathek shii dinne riig ruii phro, chiih-è nathek lubu ne sang pha ji re-è zan ruii phro, chiih-è ji pha sang pha ji ne nathek è hanyie de ariao mua. ");
INSERT INTO bgg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Gu nathek shii izai yao” “Gu beng è nathek Aphuii shii nyie lia pha ji ne phi ruii phro.” Ji pha inai thog mage shii nathek ne gu shii nyie alia ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Thuh thog pha nathek è gu beng shii nyie de alia ba ro, lia bo chiih-è na mua ruii phro, chiihphado nathek ro sang ne zab rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gu è nathek shii hìthek yao pha ne shan ne yao, jimagungde ji re-è rek pha ishak thog ruii phro gu ne nathek shii shan ne ayao sha ruii phro. Jishii miang è Aphuii chiang shii yao sha ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ji pha inai thog mage shii, nathek aishii gu beng è lia ruii phro; jimagungde gu nathek haro è aishii lia phi pha gu ayao, ");
INSERT INTO bgg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","nyieliieshii Aphuii awai è nathek shii miie ro. Ai è nathek shii miie rek nyieliieshii nathek gu shii miie chiih-è gune Aphuii è wuii phrone migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gu ne Aphuii è wuii thog, gu ichiih sohjambling shii wuii; jiè gune ichiih sohjambling hì thoh marui srane gui Aphuii shii dun sha pha ro.” ");
INSERT INTO bgg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chiihphado ai samoythek è aishii yao, “Thuh shii na è nyie de ashan pha miang è yao. ");
INSERT INTO bgg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gathek ne thieg sha ge ro nane zab thieg; na shii ne gai è nyie sai chid pha oi sha ro, jiè nane Hamangkhung-aphuii è wuii chak phrone gathek shii migi rab phi bo.” ");
INSERT INTO bgg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isu è ithek shii chang, thuh shii ne nathek migi rey sha bey? ");
INSERT INTO bgg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Hì è rek pha ishak thog ruii phro, chiih-è thogjong ro, nathek ne dayiingdayang rey ne hanyie hanyie hò hà dundun phro, chiih-è nathek zab ne gu shii ji thoh muii phro. Jimagungde izai shii gune gui ji asi phro, nyieliieshii Aphuii ne gu rog shii um ro. ");
INSERT INTO bgg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Gu nathek shii hì yao pha ji ne nyieliieshii nathek gu rog shii rai srane liijiing mua bo. Sohjambling pho è nathek shii diig rek ruii phro. Jishii lubu chuh rek bo! Gu è sohjambling yang ge ro!” ");
INSERT INTO bgg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chiihphado Isu ji yao ched shii, ai Hamangkhung hà riig srane yao, “Aphuii ishak ne thog sha, na dufuii shii biisiie ji phi sha bo, ji arone Dufuii de na shii biisiie ji phi mua.” ");
INSERT INTO bgg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na è aishii zab pha bran lakhung shii riichaithek phi, jiè ai ne idang pha chai aishii phi pha nathek zab shii phi mua. ");
INSERT INTO bgg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Chiih-è idang pha chai hi ro na izai Hamangkhung-aphuii nane na è hanyie shii thoh ge pha Isu Masi shii ìd pha ji ro, chiih-è hanyie è aishii thoh ge pha Isu Masi shii thieg ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gu è naro biisiie ne sohnyiak shii doh noh jong ro, chiih-è na è gu shii phi pha blia ji ne zab rekjong ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aphuii! Sohkhung arab ba pha ibi shii guro biisiie ji thuh na um ba shii gu shii phi bo. ");
INSERT INTO bgg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Na è sohjambling è hanyie gu shii phi pho ithek na shii thieg yi. Ithek ne naro ro, chiih-è na è ithek shii ne gu shii phimuii. Ithek è na miyaogam nuii, ");
INSERT INTO bgg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chiih-è thuh shii zab na miphi ji ne na è thog rone ithek è thiegjong ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gu è ithek shii mua phi pha ji ne na miphi ro, chiih-è ithek è choi ne; ithek ne thieg hì ne izai chak chiih-è gu ne na è wuii ro, chiih-è ithek ne migi rek gu shii ne na muthoh ge chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Gu è ithek shii sia phi. Jimagungde gu sohjambling pho shii sia phane athieg ro jimagungde na è gu shii phi pha ithek shii sia.” ");
INSERT INTO bgg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Zab gu shii um pha ji ne naro ro, chiih-è zab shii um pha ji ne guro ro; chiih-è guro biisiie ne ithek re-è khlieng ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Thuh shii gu na hà wuii sha ruii ro; gu ne sohjambling shii arai sha phro, jimagungde ithek ne ichiih sohjambling shii ro. So Aphuii! Gu shii phi muii pha ibeng, na ibeng pha blu è ithek shii ragia ruii bo, chiih-è ginyi jia rek pha duiine ithek shii de jia rek yi bo. ");
INSERT INTO bgg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Gu ithek rog um pha ishak shii, gu è ithek shii na è gu shii phi pha ibeng naro blu ibeng è ithek shii ragia rek phi, gu è ithek shii ragia rek phi, chiih-è jia de asan yi ro, hanyie shii san yi pha ji musan bie ro nyieliieshii jigigam shii izai rey yi ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Chiih-è thuh gu na shii dun ramuii ro, chiih-è ichiih sohjambling shii gu hìthek zab yao pha ji ne ithek ro lubu shii ne guro zab lubo ji rek yi ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gu è ithek shii ne naro mua ji phijong, chiih-è sohjambling è amiie, nyieliieshii gu ichiih sohjambling pha asi pha duiine, ithek de sohjambling pha asi ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gu è na shii ithek shii sohjambling è fuang yie bo è ayao ro, jimagungde gu na shii lia phro ithek shii ne sakhathong re-è ragia ruii phi bo. ");
INSERT INTO bgg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gu ne sohjambling pha asi pha duiine, ithek de sohjambling pha asi ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Izai pha miyaosiu ji re-è ithek shii nawailum ne so rek muii bo; naro miyaogam ne izai chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na è gu shii sohjambling hà thoh ge pha duiine, gu è ithek shii sohjambling hà thoh ge ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chiih-è ithek chiang gu guishii na shii so rek mua, ji duiine ithek zab de na shii, izai è so rek mua. ");
INSERT INTO bgg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Gu ithek shii asia doh bie ro, jimagungde hanyie thek airo mua ji nuii ne gu shii migi rek pha ji shii de sia phi ro. ");
INSERT INTO bgg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Gu è ithek ne jia shii rey bo ne sia. Aphuii! Na gu shii um chiih-è na gu shii um pha duiine ithek ne ginyi shii um bo. Chiih-è ithek ne jia um ne, jiè sohjambling hà na è gu shii thoh ge phrone migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na è gu shii phi pha biisiie ji gu è ithek shii phi, na nane gu jia rek pha duiine ithek de jia rey bo: ");
INSERT INTO bgg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Gu ithek shii chiih-è na gu shii ro, jiè ithek ne zab ò jia shii rek mua, jiè ne sohjambling ithek ne thieg mua gu shii ne na muthoh ge chiih-è na gu shii miie pha duiine ithek shii de miie. ");
INSERT INTO bgg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Aphuii! Na è ithek shii ne gu shii phi, chiih-è gu khi hà um ithek shii de gu rog shii um bo è yang muii ro, jiè biisiie na è gu shii phi guro biisiie yi ithek riig mua; chiih-è sohjambling rab pha ibi è na gu shii miie. ");
INSERT INTO bgg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Giang Aphuii! sohjambling na shii athieg ro, jimagungde gu na shii thieg, ji è thieg yi gu shii na muthoh ge. ");
INSERT INTO bgg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Gu è ithek shii na shii thieg yi pha rab, chiih-è ne athodang pha ro, chiih-è naro miie gu shii um pha ji ne ithek shii de um, chiih-è gu de ithek shii um mua ro.” ");
INSERT INTO bgg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Isu è ji è sia ched pha iidoh, Awai samoythek rog Khidron khaphieg thrang hà wuii thog. Thiisa pha ithua shii ne razim um, chiih-è Isu nane airo samoythek ji pha iliing hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, zum pha, de thieg ji pha ithua khi hà, nyieliieshii Isu ne idang ishak thiisa hà awai samoythek shii si. ");
INSERT INTO bgg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ji-è Judas ji pha razim shii wuii srane, ibrog Roman siphahithek, chiih-è Misiahò pha sandrithek shii boh phabithek nane Pharisithek è thoh ge; ithek ne migiang chiih-è bai chuangthek nane muchuangthek yi srane wuii. ");
INSERT INTO bgg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Isu ne awaishii ji rey ramuii pha ji ne zab thieg, jimagunde ai è ibi wuii srane ithek shii sai, “Nathek ne hanyie shii sow phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ithek è chang, “Nazareth pha Isu shii sow phro. Ai è yao, ji ne gu ro.” Judas, zum yi muii pha, de ithek rog shii riu ne um. ");
INSERT INTO bgg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Isu è ithek shii yao mage shii, “Gu ne ji ro,” Ithek iidoh dan srane niak hà chiihdun. ");
INSERT INTO bgg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jishii Isu dinne ithek shii sai, “Nathek è sow muii pha ji ne hanyie lei?” “Nazareth pha Isu shii sow phro,” Ithek è yao. ");
INSERT INTO bgg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Gu nathek shii khuchung mujo yaojong ji ne gu ro.” Isu è yao, “Chiihphado, nathek ne gu shii sow chak arone, nathek gai shii dun yi bo.” ");
INSERT INTO bgg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ai è ji yao pha ji ne jiè ai nyie yao pha ji ne izai rey yi: “Aphuii, na è ithek gu shii phi pha ji è nyie jia de asan yi ro.”) ");
INSERT INTO bgg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Phithar, hanyie shii khamriie um, khia srane Boh Phabithek ro khiao airo phazoi pha khoh laigthiak muii. Ji pha khiao beng yi Malchus ro. ");
INSERT INTO bgg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Isu è Phithar shii yao, “Nawai khamriie yi iidoh awai ithua shii ruii bo! Gu shii ne Aphuii è phi pha diig gog ji ne aniing yi phrone nane è now bey?” ");
INSERT INTO bgg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","“Chiihphado è Roman pha siphahithek nane yung pha ophispho chiih-è Jewthek pha sandrithek è Isu shii zum, aishii phang muii,” ");
INSERT INTO bgg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chiih-è Khaiphas ro ikham Anas hà noh bi dun, nyieliieshii Khaiaphas ai ne ji pha idam shii zab è Kho Phabi ro. ");
INSERT INTO bgg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hì ne Khaiaphas ro hanyie è zab pha bran chiang shii bran jia iy pha ji ne wieliak phro Jewish pha riichaithek shii yua. ");
INSERT INTO bgg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","“Simon Phithar nane gai samoy de Isu iidoh luagieng, chiih-è gai samoythek è ne Boh Phabithek shii wie thieg, jiè ithek de Isu rog shii Kho Phabi hò sibiang shii wuii dun.” ");
INSERT INTO bgg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ji pha ishak shii Phithar yi sibiang pha muthua hà riu ramuii ro. Chiihphado gai samoy jia de iidoh wuii dun, muthua shii bimi shii yao, chiih-è Phithar shii iliing hà noh thog. ");
INSERT INTO bgg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Muthua shii riu pha bimi ji è Phithar shii yao, na de ji pha bran ro samoy è jia asi bey? Phithar è chang, “Asi” “Gune ji asi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ji rey ramuii shii bajo chiie, jiè khiaothek nane sandrithek è bajuang bai rab srane ithek zab thiichiih shii ang ne, awaithek shii lua rab, jiè Phithar de ithek rog shii wuii srane ithek rog shii riu ne, awaishii lua rab. ");
INSERT INTO bgg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kho Phabi è Isu shii samoythek chiang nane ai muyua pha chiang Isu shii musai sai. ");
INSERT INTO bgg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isu è chang, “Gu è ne idang zab shii hong ne yao; gu muyua ne khi hà zab bran ò wuii pha zab Jewthek misiahò shii nane Misiahò shii yua, gu ne khuchung magunde ug ne ayao.” ");
INSERT INTO bgg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nyie, chiihphado, nathek gu shii musai sai phlei? Gu shii nuii pha bran shii musai sai bo. Ithek shii sai bo, gu è ithek shii nyie yao— ithek ne thieg gu è nyie yao. ");
INSERT INTO bgg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Isu è ji yao ramuii shii, sandri jia è aishii phey srane yao, “Khinyama chua è na Kho Phabi shii ji yao phlei!” ");
INSERT INTO bgg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Isu è aishii chang, “Gu è nyie magungde asi pha yao arone, ichiih um pha zab shii yao bo ji ne nyie. Jishii gu è nyie yao pha ji ne gu izai yao arone, na gu shii nyie rek ne phey phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chiihphado Anas aishii ne, joi bamuii shii Kho Phabi Khaiaphas hà thoh ge. ");
INSERT INTO bgg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Phithar awai shii lua ne thiisa hà riu bamuii. Ji-è gai è aishii yao, “Na de ji pha bran ro samoythek è jia asi bey?” “Jimagungde Phithar è Snai, Yao,” “Asi, gu asi ro,” Ai è yao. ");
INSERT INTO bgg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kho Phabi jia ro khiaothek shii Phithar è khoh laig muii pha airo siangthang pha bran ji è yao, “Gu è na shii razim hà ariig bey?” ");
INSERT INTO bgg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Din ne Phithar è aishii Snai “asi” iyao shii khey ìoh. ");
INSERT INTO bgg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hamiang riang Isu shii Khaiaphas hò è badri ro hòboh hà noh dun. Jimagungde Jewthek pha riichaithek ne hòboh iliing hà awuii, nyieliieshii ithek ne awaithek shii so ruii pha now, jiè ithek ne Hiiadun pha michie nya chie mua. ");
INSERT INTO bgg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ji-è Philath fuang hà aishii wuii srane sai, “Nathek hì pha bran shii nyie nin phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ithek è chang, “Ai nyie suruii oi arone gathek ne na hà anoh iwa.” ");
INSERT INTO bgg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Philath è aishii yao, “Ji-è nawaithek aishii noh srane nawaithek ro Iphey ji duiine rek pha bidiang bo.” Ithek è chang, gathek shii ne hanyie shii de ua pha yung ne oi ro, ");
INSERT INTO bgg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Hì è rey pha ji ne Isu ro miyao ne izai rey yi, airo miyaogam ji ai khi-èrek iy pha ji ne zab doh yi.) ");
INSERT INTO bgg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philath awai ithua hà iidoh dun din srane Isu shii ho. Chiih-è ai è sai, “Na ne Jewthek pha saja bey?” ");
INSERT INTO bgg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isu è chang, “hì pha musai yi nawai lum ne sai ne ba asi pha gu chiang yi gai è na shii yao ne ba?” ");
INSERT INTO bgg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philath è chang, “Na ne gu shii Jewthek ro è now bey? Hì ne nawai bran chiih-è kho phabi è gu wad shii phi muii ro. Na è nyie rek phlei?” ");
INSERT INTO bgg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isu è yao, “Gu ro Sajathua ne ichiih sohjambling pha asi ro; chiih-è guro Sajathua ne ichiih sohjambling pha arone,” Guro samoythek è Jewthek pha riichaithek shii aphi yi gui shii pha mak rek noh, guro Sajathua ne ichiih sohjambling shii asi ro! ");
INSERT INTO bgg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Philath è aishii sai, “Ji arone nane saja bey?” Isu è chang, na è gu shii saja ro è yao arone ji ro. Gu ne giak ne sohjambling shii wuii pha ji ne airo nyie izai chiang ji yao pha wuii ro. Hanyie ne izai è wuii arone gu shii yoi. ");
INSERT INTO bgg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philath è sai, “Iizai ji ne nyieliieshii?” Chiihphado Philath fuang hà dun din srane bran shii yao, “Gu ne aishii ua muii pha yaothiak pha chiang nyie de adoh phi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Jishii nathek ro mizen duiine Hiìadun pha inai shii gu shii phatheg bran jia shii idang khia ne thoh. Ji-è nathek ne gu shii nawaithek ro Jewthek Saja shii thoh muii bo è now bey? ");
INSERT INTO bgg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ithek è aishii ziak srane chang, “Asi, aishii asi! Gathek ne Barabas shii chid pha ro” (Barabas ne sgoh pha bran ro.) ");
INSERT INTO bgg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chiihphado Philath è Isu shii noh srane aishii zuang. ");
INSERT INTO bgg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Chiih-è sandrithek è migem idiphak è rab pha rago ai khrug shii khakphi, chiihphado iphi yung de guiiphi ");
INSERT INTO bgg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chiih-è aishii wuii srane yao, “Jewthek pha Saja phiang sieng ne rai bo!” Chiih-è ithek è wuii srane aishii phey. ");
INSERT INTO bgg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jishii dinne Philath fuang hà wuii sra ne ithek shii yao, “Riig bo, gu è aishii nathek hà noh ne riig yi gune aishii iy pha nin sapho nyie de atho phi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ji-è Isu ro khrug shii mikhimthek pha rago khak srane, iphi yung de guii phi srane fuang hà wuii thog. Chiih-è Philath è ithek shii yao, “Riig bo! Hì pha bran ne ichiih shii um ro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","“Chiihphado è boh phabithek nane Misiahò pha sandrithek aishii ji riig srane, ithek è ziak, aishii bai zun muii bo! Aishii bai zun mua bo!” Philath è ithek shii yao, “Nawaithek è aishii noh srane, Nawaithek bai shii zun muii bo. Gu ne aishii iy pha nin sapho chiang nyie atho phi ro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chiihphado shii iphiing è iidoh chang din, “Gathek Iphey shii yao ai ne iy sapho ro, nyieliieshii ai ne awai shii yao ai ne Hamangkhung-aphuii pha Dufuii rone yao” ");
INSERT INTO bgg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Philath è ji yoimage shii, ai ne din ne de muna rumdun. ");
INSERT INTO bgg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chiih-è ai dinne awairo bohhò hà iidoh dun srane Isu shii sai, “Na khi è wuii phlei?” Jimagungde Isu è achang. ");
INSERT INTO bgg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Philath è aishii yao, “Na gu shii ayao habey? Now bo, gu na shii thoh pha riichai de um chiih-è bai shii zun pha riichai de um ro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isu è chang, “Na è gu lakhung shii riichai rek pha ji ne nyieliieshii Hamangkhung-aphuii è na shii phi. Ji-è bran hanyie è gu shii na wad shii phi muii pha ji ne awie pha layog ichiig shii phi muii.” ");
INSERT INTO bgg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Philath è ji yoi shii, ai è Isu shii thoh muii pha bidiang ne lumuii sow, jimagungde ibrog è iidoh ziak din, “Na è aishii thoh muii arone, ji pha miyaosiu è na ne Bisiu ro ijak asi ara, chiih-è hanyie magunde saja rone yao arone ai ne Bisiu shii gidieg Ichiig rek ra!” ");
INSERT INTO bgg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philath è ji pha miyaogamthek yoi mage shii, ai è Isu shii fuang hà noh srane chuathek Ithua rone ho muii pha ithua shii dug. “Lubao è rab pha ithua” Shii noh srane dug ba yi. (Hebrew è Gabatha ro è yao). ");
INSERT INTO bgg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hì ne Hiìadun pha inai ibi pha inai duchoi shii ro, Philath è bran shii yao, “Nathek ro saja ne ichiih shii um ro!” ");
INSERT INTO bgg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jishii ai è iidoh ziak srane yao, “Aishii ua muii bo! Aishii ua muii bo! Chiih-è aishii bai hà zan muii bo!” Philath è ithek shii sai, “Nathek nawaithek ro Saja shii ne, gu shii bai zan muii bo è now bey?” Chiihphado shii boh phabithek è chang, “Gathek shii saja um bie pha ji ne Bisiu ji ro!” ");
INSERT INTO bgg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chiihphado Philath è Isu shii ithek shii phi srane bai shii zun yi. “Ji-è ithek Isu shii noh dun.” ");
INSERT INTO bgg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ai awairo bai han srane fuang wuii dun, chiih-è Gadongzaing rone beng muii pha ithua shii thog (Hebrew è ji pha ithua shii Golgatha, ro è yao) ");
INSERT INTO bgg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Thiisa ithek è aishii bai hà zun muii; chiih-è thiichiih shii ithek è gai bran nyi shii de ai moe shii bai hà zun muii, jia shii ai phawig pha bai hà zun chiih-è jia shii airo phazoi pha bai hà zun muii. ");
INSERT INTO bgg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","“Philath è zey srane ai zun pha bai shii miak phi.” Jewthek pha Saja, Nazareth pha “Isu,” ");
INSERT INTO bgg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bajo bran è tham, nyieliieshii Isu bai hà zun pha ithua ji yi rajan è muna ruang asi ro; chiih-è ji thiichiih shii nyie zey pha ji ne Hebriu, lathin chiih-è Grekh ro. ");
INSERT INTO bgg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Boh phabithek è Philath shii yao, “Jewthek pha Saja ro è azey rabo,” ji phachiang, “Hì pha bran è yao, gu ne Jewthek pha Saja ro yao pha ji zey bo.” ");
INSERT INTO bgg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Philath è chang, “Gu è nyie khi è zey pha ji ne zey ne um yi bo.” ");
INSERT INTO bgg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Isu shii bai hà zun ched pha iidoh shii sandri è Isu ro yung yi srane iliang wi ji srane zab pha sandrithek shii jia jia phi, chiih-è ai lakhung è yi ne lui thog pha wad è phuii pha phadiig phiang ji de yi. ");
INSERT INTO bgg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jishii sandrithek è yao rai, “Cho hì pha yung yi aji pha; hanyie shii mua lei ne siog shii zey srane fen ne chiing rai haro. Hì è rey pha ji ne jigigam shii nyie zey ne um pha ji izai rey yi pha ji rek ro” “Ithek è gu yung shii siog fen ne riig, chiih-è gu yung shii liug.” Chiih-è sandri è de ji è rek. ");
INSERT INTO bgg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Airo amuii, ro ikhuii, Khlophas ro yiy Mery Magdalene yi Isu shii zun pha bai moe shii riu. ");
INSERT INTO bgg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Isu è awai amuii nane awai samoy hanyie shii ai è miie pha ji yi thiichiih shii riu pha doh; jiè ai è awai amuii shii yao, “Hì ne naro Dufuii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chiihphado è awai samoy shii yao, “Hì ne nathek ro amuii ro. Ji pha iidoh è samoy è ji pha hò-amuii shii noh srane awai hò shii rai noh ro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","“Zab pha blia rey sha pha ji ne Isu è thieg; jigigam shii nyie zey ne um pha ji ne izai rey ro, ai è yao, gu gahanghang muii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Thiichiih shii awie pha phuii dieg ley jia um, jimagungde ithek è jog rek ne lao ne, yung è jiang pha muchang shii mam srane ai sem shii ruii phi. ");
INSERT INTO bgg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Isu è ji pha phuii bisieng ji niing srane yao, “Hì ne jong sha ro!” Chiihphado è ai khrug jiing srane iy dun. ");
INSERT INTO bgg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chiihphado shii Jewish pha riichaithek è zun muii pha bran ro lai jo pha Philath shii lia. Chiih-è siu ji bai è thazam yi pha lia. Ithek è ji khung pha ji ne nyieliieshii sugrubari ro, chiih-è ji pha thimiang shii ne Jewthek Thung pha Inai pha inai ro chiih-è Jewthek Thung pha Inai pha ji ne bajo so ro. ");
INSERT INTO bgg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Isu moe shii zun muii pha bran nyi ro yi sandrithek è wuii srane laithek thab bi muii. ");
INSERT INTO bgg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jishii ithek Isu ro lai de thab pha wuii shii, ithek è adoh ba pha ibi shii iyjong dun pha doh, jiè ithek è airo laishii ne athab. ");
INSERT INTO bgg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sandri jia è awai jiong rek ne Isu siu shii giao mage shii ifai nane kho noi khlei ruii. ( ");
INSERT INTO bgg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bran jia è ji è rek pha ji riig srane yao, ithek de aishii migi rek bo. Ai è nyie yao pha ji ne izai yao chak ro; chiih-è ai è thieg yi ai izai yao chak.) ");
INSERT INTO bgg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ji ne ai ne izaing jia rang de ajo, nyieliieshii jigigam shii nyie zey pha ji izai rey yi ro. ");
INSERT INTO bgg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","“Chiih-è gai shii jigigam de yao, ithek è hanyie shii giao pha ji ne, bran ne aishii riig ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ji-è rek ched pha iidoh shii, Arimathea thawun hà rai pha Joseph, è Philath shii Isu ro siu ji lia wuii. (Joseph de Isu ro samoy ro, jimagunde ai ne ug, nyieliieshii Jewish pha riichaithek shii rum.) Philath è Joseph shii yao, na ai siu iy ji nya yi bo, jiè Joseph Isu ro siu iy ji yi pha wuii. ");
INSERT INTO bgg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nekhodemus, hanyie yi igobi pha habiu Isu shii riig wuii, Joseph rog shii wuii ne, Myre nane aloes lao pha chun sa-uom yie, wuii thog. ");
INSERT INTO bgg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chiih-è bran nyi è Isu ro siu ji yi srane yung imo rek ne jiang ne chiih-è miinow rek ne shun ne Jewish Iphey è zen pha ji duiine rek ne wieng muii pha sharo haro. ");
INSERT INTO bgg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Thiichiih Isu shii iy yi muii pha ithua shii razim jia um chiih-è thiichiih shii hanyie de awieng ba pha wieng iwo jia um. ");
INSERT INTO bgg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hì ne Jewthek Thung pha Inai ibi shii ro, chiih-è wieng ne nui shii ro, jiè ithek è Isu ro siu ji thiichiih shii ruii maruii. ");
INSERT INTO bgg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Deobari pha inai hamiang shii, la igiia ba shii, Mery Magdalene è wieng shii wuii srane riig khlei shii wieng cho shii kheb pha lubao ne hòg ne um. ");
INSERT INTO bgg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chiih-è Simon Phithar nane gai samoy hanyie shii Isu miie rek muii pha samoy shii ran srane yao, “Ithong shii ne ithek è wieng è noh dun ro, chiih-è aishii khi hà ruii rai lei ne, gathek ne athieg mua ro!” ");
INSERT INTO bgg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chiih-è Phithar nane gai samoy de wieng hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chiih-è bijiu nyi yi ran srane, jimagunde gai samoy yi Phithar è chiang ran srane wieng shii thog bi. ");
INSERT INTO bgg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jishii ai iliing hà awuii ba shii, ai è jiing srane ne riig shii aishii jiang pha yung imo ji ne doh. ");
INSERT INTO bgg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Idoh shii Simon Phithar de wuii thog, chiih-è ai de miang wieng hà wuii dun, ai de thiichiih shii yung imo um pha ji doh. ");
INSERT INTO bgg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chiih-è Isu ro khrug shii jiang pha yung ji yi siu shii jiang muii pha rog shii um pha adoh. Jimagunde awai yo è jiang dun. ");
INSERT INTO bgg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chiihphado è wieng ibi wuii thog pha gai samoy, de iliing hà wuii srane, aishii riig ne migi rek. ");
INSERT INTO bgg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Jishii ai ne thuh de iy ne hòi din phro è yao pha ji ne athieg ba ro.) ");
INSERT INTO bgg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chiihphado samoythek iidoh hò hà dun din marui. ");
INSERT INTO bgg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mery yi wieng moe shii cho srane riu ne rai ramuii shii, ai nya cho ba muii shii, ai è wieng shii bam srane riig shii ");
INSERT INTO bgg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","hamangkhliie nyi yi yung imo guii srane, Isu ro siu iy ruii pha ji shii jia yi ai khrug moe hà chiih-è jia yi ai lai moe hà riu ne rai. ");
INSERT INTO bgg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","“Ai è hò-amuii ji de sai, nyie rek ne cho phlei?” “Hò-amuii jiè chang, ai è guro Ithong ne noh dun ro, chiih-è gune athieg ro ai è khi hà noh dun rai lei ne!” ");
INSERT INTO bgg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ji-è yao ched pha iidoh shii ai rei ne riig shii Isu thiisa hà riu ne um; jimagungde ai ne ji Isu ro è athieg mua. ");
INSERT INTO bgg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Isu è hò-amuii ji shii de sai, hò-amuii nathek nyie rek muii ne cho phlei? Chiih-è ithek so ramuii pha ji ne hanyie lei?” Hò-amuii jiè now shii ai ne razim muspho ara è now, jiè hò-amuii jiè yao, “Nathek aishii è yi dun arone Masdo, gu shii yao bo nathek è khi hà han ne ruii muii, ji arone gu ne wuii srane aishii yi din pha ro.” ");
INSERT INTO bgg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Isu è hò-amuii ji shii yao, “Mery!” Ai è aishii rei srane Hebriu nyuak è yao, “Robboni” (Hì è yao pha ji ne “Masdo” ro è yao). ");
INSERT INTO bgg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jishii Isu è hò-amuii shii yao, “Gu shii akhoh rabo,” “Nyieliieshii gu thuh de iidoh lakhung hà Aphuii shii awuii ba ro. Jimagungde gu khuiithek shii wuii srane yao bo, gu ne gui Aphuii nathek ro chiih-è guro Hamangkhung-aphuii chiih-è nathek ro Hamangkhung-aphuii shii khid ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","“Ji-è Mery magdalene è wuii srane samoythek shii yao, ai è Ithong shii doh ne ai è aishii nyie yao pha ji ne nathek shii yao phro.” ");
INSERT INTO bgg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ji-è iy pha ji yi Deobari habjuang shii ro, chiih-è samoy ò jia shii khrab srane habin bin ne rai ramuii, nyieliieshii ithek ne Jewish pha riichaithek shii bajo rum. Chiihphado ji è rekramuii shii Isu ai moe shii wuii thog ne riu mage. Ai è yao, “liijiing ne nathek rog shii um ro.” ");
INSERT INTO bgg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ji-è yao ched pha iidoh shii, ai è awai wad chiih-è awai siu ithek shii riig ba yi. Chiih-è samoy è Ithong shii riig srane sang dun. ");
INSERT INTO bgg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Isu è dinne aishii yao, “liijiing ne nathek rog shii umbo, nyieliieshii gu shii ne aphuii muthoh ge ro, jiè gu nathek shii de thoh ge ro.” ");
INSERT INTO bgg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chiih-è ai ithek shii misey rek ne thud srane ithek shii yao, “Ragung so shii nathek yi bo. ");
INSERT INTO bgg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Chiih-è nathek è bran ro layog khung phi arone, nathek ro layog khung ge ro; chiih-è nathek gairo layog de akhung phi arone, ai è de nathek ro layog akhung phi phro.” ");
INSERT INTO bgg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Snanyi è bijiu jia Thomas (Iwen ro è ho) yi Isu wuii marui pha ishak shii ai yi thiichiih shii oi iang. ");
INSERT INTO bgg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chiih-è gai samoy è aishii yao, “Gathek è Ithong shii doh jong ro!” Thomas è aishii yao, “Gu ai wad shii sharo rek ne phey muii pha icho shii gu wadbieng rek ne hìog ne chiih-è siu shii wad è awiang ne ariig sapho shii ne gune migi anow phro.” ");
INSERT INTO bgg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Damiley pha iidoh shii dinne samoy habin bin muii ne rai ramuii shii, Thomas de ai rog shii um. Habin ne bin muii, jimagunde Isu ai moe shii wuii srane riu ne aishii yao, “liijiing ne nathek rog shii um bo.” ");
INSERT INTO bgg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chiih-è ai Thomas shii yao, “Na wad bieng ichiih shii ruii mage bo, chiih-è gu wad shii riig mage bo; chiih-è nawai wad miang rek srane guro siu riie shii wiang mage bo, chiih-è athan pha, migi rek mage bo!” ");
INSERT INTO bgg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chiihphado è Thomas è chang, “Gu Ithong chiih-è gu ro Hamangkhung-aphuii!” ");
INSERT INTO bgg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isu è aishii yao, “Nyieliieshii na è gu riigjong pha ji re-è migi rek ne bey? Jimagungde hanyie è gu shii ariig pha migi rek arone ai ne bajo sang ruii phro!” ");
INSERT INTO bgg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Awai samoy um pha ji shii Isu è bajo buangthek pha blia rek phi pha ji ne bajo ne ichiih siog shii azey ro. ");
INSERT INTO bgg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Chiih-è ichiih shii zey pha ji ne nyieliieshii Isu ne Masi chak ro, chiih-è Hamangkhung-aphuii ro dufuii ro è migi rek yi pha, chiih-è nathek ro migi aishii rek pha jiè nathek ne chai mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ji-è rek pha iidoh shii, Thiberias pha khabang shii Isu awai samoythek shii dong thog. Ji hi è rey phro. ");
INSERT INTO bgg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Phithar, Thomas (iwen ro è ho muii pha ji), Nathanael (jia yi Galili Khana pha ro), Zebedi ro dufuiithek, chiih-è Isu ro gai samoy nyi ò shii um. ");
INSERT INTO bgg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Phithar è gai shii yao, “Gu ne ù ua sha wuii pha ro.” “Ithek è aishii yao,” Gathek de nathek rog shii wuii gieng pha ro. Ji-è yao rai srane ai run shii in ne wuii dun, jimagungde ai ji pha habiu shii nyie jia rang de azum mua. ");
INSERT INTO bgg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hasieng siang mage shii, Isu yi kho ring shii wuii ne riu, jishii samoy è ai ne Isu ro è athieg mua ro. ");
INSERT INTO bgg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chiihphado è ai è ithek shii sai, “filiaothek bran nathek nyie magungde zum mua bey?” Ai è chang, “Nyie de amua ro.” ");
INSERT INTO bgg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Ai è ithek shii yao,” Nathek ro chiug run pha phazoi hà moa mage bo, ji arone ù mua ruii phro. Ji-è ai è chiug moa mage shii thado ari mua din, nyieliieshii chiug shii ne ù bajo um dun. ");
INSERT INTO bgg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chiih-è Isu è miie rek muii pha samoy è Phithar shii yao, “Hì ne Ithong chak ro!” Phithar è Ithong chak ro è yoi mage ne, ai awai yung fiie srane (awai yung than muii) chiih-è kho iliing hà lung dun. ");
INSERT INTO bgg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chiihphado è gai samoy de run è iring hà wuii srane chiug ley ù ji ri gieng, nyieliieshii ai yi ji pha soh è giia wieng jia nyama pha de asi pha ji um iang. ");
INSERT INTO bgg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ai è kho ring hà yie thog mage shii ai è bai fu ne ù chiih-è iweb ziao ne ruii pha doh. ");
INSERT INTO bgg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chiihphado he Isu aishii yao, “Bsa hà nathek muzum pha giak ù thayi mage bo.” ");
INSERT INTO bgg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon è wuii srane chiug ley ù ji khia wuii, jimagungde ù yi wieng jia è saguii è uom um, jimagungde bajo ù tho magunde chiug ne ìujia rang de aji dang. ");
INSERT INTO bgg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Isu è aishii yao, “Nathek de thawuii ne chie bo.” Jishii samoy è hanyie de aishii asai mua, “Nathek hanyie lei?” Nyieliieshii ai ne thieg, ai ne Ithong chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chiihphado shii Isu è wuii srane, iweb phi chiih-è ù de phi. ");
INSERT INTO bgg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Isu è jiè rek ne awai samoy shii dong thog ruii pha ji yi iy ne hòi din pha iidoh shii uomchiieng pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ai chie ched pha iidoh shii, Isu è Simon Phithar shii yao, “Jon ro dufuii Simon, na ne gu shii gai è rek pha ji è de muna gu shii miie rek ne bey?” Ai è chang, “Oh Ithong,” “Na ne thieg gu è na shii miie rek.” Isu è aishii yao, “Gu ro shiishaiduii shii wie riig bo.” ");
INSERT INTO bgg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Din ne Isu è aishii yao, “Jon ro dufuii Simon, na ne gu shii miie rek ne bey?” “Ai è chang, Oh, Ithong.” “Na ne thieg gu ne na shii bushun rek.” Isu è aishii yao, “Ji arone guro shiishai shii wie riig bo.” ");
INSERT INTO bgg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Uomchiieng Isu è aishii sai sha, “Jon ro dufuii Simon, na ne gu shii miie rek ne bey?” Jimagungde Phithar de duhug rey sha dun nyieliieshii uomchiieng aishii sai sha dun, “Na ne gu shii miie rek ne bey?” Ji-è ai yao, “Ithong chiih-è zab thieg; gune na shii miie rek!” Isu è aishii yao, “Guro shiishai shii wie riig bo.” ");
INSERT INTO bgg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gu na shii izai yao: Na filiao ba shii na khi hà wuii yang pha ji hà saro bo, jimagungde na weg rey mage shii wad phiang rek srane na è awuii yang bsa hà wuii noh phro. ");
INSERT INTO bgg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Isu è hì iyao pha ji ne, Phithar iy srane Hamangkhung pha aphuii ro biisiie rek mua ruii pha ji yao phro.) Chiihphado shii Isu è aishii yao, “Gurog iidoh shii luagieng bo!” ");
INSERT INTO bgg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phithar è iidoh rei srane riig shii, Isu è miie rek muii pha—Gai samoy jia Isu rog shii michie chie pha dug muii pha ji è sai “Ithong, Na shii zum yi pha rek pha ji ne hanyie lei?” Ji è sai muii pha ji doh. ");
INSERT INTO bgg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phithar è aishii riig srane, ai è Isu shii sai, “Ithong hì pha bran shii nyie khi-èrek pha lei?” ");
INSERT INTO bgg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isu è aishii chang, “Gu din wuii ruii pha ji thog pha sieng ne rai yi arone na shii nyie rey muii ga? Gurog iidoh lua bo!” ");
INSERT INTO bgg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ji-è ji pha phosro ji ne zab pha Isu ro samoy shii thog dun, hì pha samoy ne a-iy phro. Jishii Isu è ne ai a-iy phro è ayao; “Ai è yao,” Gu awuii sapho shii gu nathek shii rai yi pha now arone, “Ji ne nathek shii nyie ga?” ");
INSERT INTO bgg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ji-è yao ne, ji yao pha ji chiih-è ji zey pha ji pha samoy jia ro; chiih-è gathek ne thieg ai nyie yao pha ji ne izai chak ro. ");
INSERT INTO bgg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Din ne de Isu è rek pha blia ne bajo um ba, ji zab jijia zey arone hì chiih pha siog ne ichiih sohjambling shii ruii pha ithua oi phro.");
INSERT INTO bgg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Gu ijak Theophilus: Igobi pha guro jigigam ne Isu è awai bliathek rek ne jao pha inai ji nane awai miyao yua pha inai ji jao pha ji è ");
INSERT INTO bgg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","yiedang ne awai yi hamangkhung dun din dun pha inai thog dang pha jigigam ji zey ne um ro. Isu awai è guaphasamoy shii ai hamangkhung adun ba pha ibi shii Ragung So um ne yua marui. ");
INSERT INTO bgg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ai iy ched ne inai sawi liing shii hanyie è migi anow pho shii bajo si noh srane ai ne hòi din rone doh yi. Ji pha branthek de aishii si srane ai rog shii Hamangkhung-aphuii pha Sajathua chiang pha miyaothek de yao ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chiih-è ithek ò rai ramuii shii, Isu è ithek shii hì pha muyung phi: “Jerusalem thoh ne khi hà de awuii dang rabo, jimagunde gu Aphuii miyao marui pha lasen ji mua yi pha khan ne rai iang bo. ");
INSERT INTO bgg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon è nathek shii kho è khowo phi magunde, ìujia pha inai idoh è, nathek shii Ragung So è wo ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Guaphasamoy ne Isu rog si mage shii samoythek è Isu shii sai, “Ithong, na è sudoh phashud shii Sajathua pha ji ne Israelthek shii idoh phi din habey?” ");
INSERT INTO bgg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Isu è ithek shii yao, “Ji pha inai ne gu Aphuii awai riichai è dashab rek ne ruiijong ro, ji-è, ji pha inai ne khuchung thog ruii phane nathek ne athieg chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jimagunde, khuchung shii nathek è Ragung So mua ruii arone nathek ne blu um ne gu shii izai rone yao pha Jerusalem shii, Judea pho shii nane Samaria pho shii, chiih è zab pha sohnyiak pho shii khagi rek ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ji è yao ched marui ne samoythek riigdang pha ji shii Isu ne hamangkhung hà riie ne dun dun. Chiih è, Isu shii ne sakhmiing jiang ne sand dun. ");
INSERT INTO bgg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Samoythek è athodang pha hamangkhung hà hùii ne riig ramuii shii bran nyi ne yung imo guii srane hamblo shii ithek moe riu khlei ruii ");
INSERT INTO bgg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","srane yao, “Galileanthek, nyie rek ne thuh de nathek ne ichiih shii riu srane hamangkhung hà hùii ne riig ne rai phlei? Hì pha Isu ne khi è rek ne hamangkhung hà dun dun pha ji duiine dinne thadoh wuii din ruii pha doh ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ji è yao pha yoi marui ne guaphasamoy ne Somarothek Phiing ji thoh marui srane Jerusalem, thiig bow è ìujia ruang pha ithua hà dun thog din. ");
INSERT INTO bgg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ithek rajan hà thog dang shii ithek ne awaithek rai pha ùgud hà dun dun. Ithek ne, Phithar, Jon, Jems nane Andrew, Philiph nane Thomas, Bartholomew nane Methiu, Jems Alphayus pha dufuii, Simon, thiig shii ilkhi rek pha, chiih è Judas Jems pha dufuii. ");
INSERT INTO bgg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ithek ne athodang pha khrab srane hò-amuiithek nane Isu pha amuii Mery nane Isu pha ikhuiithek rog shii sia ne rai gieng. ");
INSERT INTO bgg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Inai ìujia rey pha idoh shii hanyie thek è Isu shii migiphothek ne weingjia è ichiig branthek maley dug shii, Phithar è jai srane yao, ");
INSERT INTO bgg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Gu ijakthek wo,” Ai è yao, “Jigigam shii nyie zey pha ji ne izai rey ruii phro, nyieliieshii Dawid Saja shii Ragung So è Isu shii zum yi pha Judas chiang chaig ne zey, ne ruii pha ji ne izai reyjong ro. ");
INSERT INTO bgg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas de gethek rog shii um pha bran ro. Ai de gethek rog shii blia rek gieng pha gua pha bran ro.” ( ");
INSERT INTO bgg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Bang rog shii Judas ne awie pha blia rek ne raig pheg ne ruii. Ji pha raig shii awai zun ne iy dun srane iy pha siu de zab shongphleg ne chiih dun. ");
INSERT INTO bgg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ji è rek ne iy pha mua ne Jerusalem phothek de yoi dun. Ji-è ji pha raig ne awaithek pha nyuak è Akheldama beng ne ruii. Ji pha ibeng ne “Ifai pha raig rone beng ne ruii ro.”) ");
INSERT INTO bgg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sthun siog shii zey ne um, “Yangne ai hò ne suloi rey dun phro; yangne ji pha hò shii ne hanyie de arai phi phro.” Chiih è, hì de zey ne um ro, Yangne bran gai è ai blia rek maphi phro. ");
INSERT INTO bgg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ji zey pha duiine ai chiang è bran jia Isu hòi din pha miyao yao ne lua pha gethek rog shii dog gieng chid phro. Ai ne gethek rog shii um gieng ne Isu è gethek rog luagieng pha zab khagi pha è jia gua chid phro. Ai ne Jon è khowo phi pha mua yao pha è yie dang ne Isu shii hamangkhung noh dun pha thek thieg pha bran gua chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ji yao ched ne ithek è Joseph, hanyie shii ithek è Barsabas rone ho, chiih è shak shii, Justhus de ho pha bran nane Mathias rone ho pha bran nyi shii gua phi. ");
INSERT INTO bgg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ji è gua ched srane ithek è Ithong shii sia ne sai, na ne branthek pha munow zab thieg pha Aphuii ro, ji-è, gathek shii yua phi bo, hanyie yi Judas è thoh marui ne awai ithua shii dun dun pha ithua shii gua ne samoy rek yi pha um ga? Ji è sia ched srane ithek è miiran riig shii, ji pha miiran ne Mathias pha ibeng khia khlei ruii, ");
INSERT INTO bgg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ji-è, ithek è Mathias shii Judas pha ithua shii guaphasamoy snajia rog shii gua ne ruii phi. ");
INSERT INTO bgg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","“Phenthekhos thogmage shii, migipho ne ithua jia shii khrab srane rai iang.” ");
INSERT INTO bgg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hamblo shii, hamang è thiichiih shii hasam sam pha duiine boh rone ithek rai iang pha hò jishii ne zab ley dun. ");
INSERT INTO bgg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ji è rek mage ne miyaogam ne bai duiine kheythog srane thiichiih shii um pha branthek shii jiang thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ithek ne Ragung So è zab than dun srane gai bran pha miyaogamthek de yao thog ruii. Ji ne Ragung So pha blu miyao yao yi. ");
INSERT INTO bgg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ithek ne Jerusalem hà rai pha Jewthek ro, hanyie thek yi giang rek ne rai pha bran ro, chiih è zab soh pha sohjambling è wuii thog pha branthek ro. ");
INSERT INTO bgg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Roh pha ji yoi mage ne bajo branthek wuii thog ruii, ithek ne bajo wiengphleg dun, nyieliieshii, ithek è hanyie thiichiih wuii thog pha branthek pha nyuakthek yao pha yoi ruii. ");
INSERT INTO bgg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Anomuluii pha wiengphleg dang ne ziak srane yao rai, “Hì pha branthek ne Galilean pha duiine yao ramuii ro, ");
INSERT INTO bgg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ji ne khi è rek ne, Ithek ne gethek thiig pha nyuakthek yao ramuii pha yoi dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Gethek ne Pharthia, Media nane Elam; Mesophothamia; Judea nane khaphadosia, Phonthus nane Asia, ");
INSERT INTO bgg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","chiih è, Phrygia nane Phamphylia, chiih è, Egyph nane libya pha thiig duchoi Syrene ithua moe pha thiig pho ro. Gethek giak ne Rom pho ro, ");
INSERT INTO bgg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jewthek nane Gaibranthek, hanyiethek yi Judaism shii dun pho, chiih è giak ne Khrede nane Arabia pho, jimagunde, gethek zab è gathek pha nyuak è Hamangkhung-aphuii è bajo boh bliathek rek phi phajithek yao pha yoi ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Buang ne anomuluii pha awaithek chung sai rai, “Hì ne nyie rey phiiga?” ");
INSERT INTO bgg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jimagunde giak è ne migiphothek shii siakjo srane yao, “Hì thek pha branthek ne phuii niing ne thiig ara ro!” ");
INSERT INTO bgg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jishii, Phithar ne guaphasamoy snajia rog shii jao srane branthek shii ziak ne yao mage: “Jerusalem shii rai pho gu ijak Jewthek wo! Gu miyao hì nuii mage bo! Hì ne nyie rey pha ji nathek shii yao riig haro.” ");
INSERT INTO bgg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nathek munow duiine hìthek pha branthek phuii athiig ro, nyieliieshii thuh ne hamiang ishak dige ba ro. ");
INSERT INTO bgg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hìthek rey phane Joel chaig pha bran miyao ji duiine ro: ");
INSERT INTO bgg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Hamangkhung-aphuii è yao” Ishak jong sha pha rey shii gu è nyie rek phi pha um ga gu è zab bran shii Ragung phi ruii phro. Na dufuii, dimithek de gu mua hì yao ruii phro; na filiaothek de chaig ruii phro, chiih è, wegthek de ibangthek bang ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gu khiaothek, nane gu kheaomuiithek, gu è Ragung phi ruii ne gu mua hì yao ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gune hamang luii hà de buangthek pha bliathek rek ruii phro, sohnyiak bucho hà de anomuluii pha blia rek phi phro. Thiichiih shii ne ifai, ne, bai hòi ne bai mukham de bo thab ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ithong pha boh nane lubo inai thog ba, pha ibi shii ne hanai de giia rey ruii phro, habie de ifai duiine shaig rey ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ji pha ishak shii ne, Hanyie è Ithong shii nong rek yi pha ho arone, aishii ne ragia rek phi phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hì pha miyaogamthek yoi mage bo, gu ijak Israelith pho wo! Nazareth pha Isu ne riichai so um pha bran rone doh pha ne Hamangkhung-aphuii è buangthek nane anomuluii pha bliathek rek pha è doh dun ro. Hìthek rey pha ne nawaithek duchoi shii rey pha ji è nawaithek de thiegjong. ");
INSERT INTO bgg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hamangkhung-aphuii pha munow duiine Isu shii ne nathek shii phi srane layog pha branthek pha muyung ji nuii ne zun ne ua maphi ro. ");
INSERT INTO bgg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jimagunde Hamangkhung-aphuii è Isu shii awai blu è hòi din yi dun ro, nyieliieshii, iy pha riichai ne Isu shii phatheg rek ne achab mua phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nyieliiene, Dawid è ai chiang yao jong ro, Gu è, Hamangkhung-aphuii ne, gu ibi shii idang um pha doh jong ro, Ai ne gu moe shii um pha ji è gune diig arey phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ji-è, gune bajo sang pha è ley dun ro, gu miyaogamthek ne jong pha lubo yao dun ro. Chiih-è gune, iy pha bran habuii shii, dinne sieng pha luthong mua din ro, ");
INSERT INTO bgg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nyieliieshii, na è gu shii iy pha sohjambling hà athoh phro; Na è nawai khiao isiie shii wieng shii ashong yi phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Na è gu shii ne idang chai um pha lumuii doh yi jong ro, Na gu rog shii um pha ji è gune bajo sang din ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Gu ijakthek wo! Yoi bo, gune nathek shii bajo thieg pha gethek blang Dawid Saja. Ai iy dun ne wieng pha wieng de sudoh ichiih shii um ba ro. ");
INSERT INTO bgg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ai ne chaig pha bran ro, chiih è, Hamangkhung-aphuii è ai rog shii sbang rek pha ji ne thieg muii ro: Hamangkhung-aphuii è Dawid riing è saja rek pha sbang jia rek marui, na riing è Dawid duiine Saja jia khia khlei ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawid Saja ne Hamangkhung-aphuii mirek jithek doh marui, jiè ai è Isu Masi hòi din pha miyao ji yao marui, Aishii ne iy pha sohjambling ji è ajoi mua ro; Ai iy pha siu ne wieng bucho shii ashong dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Hamangkhung-aphuii è Isu ne hòi din phi, ji pha blia ne gethek è khagi rek jong dun. ");
INSERT INTO bgg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aishii ne Hamangkhung-aphuii, awai Aphuii è hòi din yi ne awai phawig moe shii dug yi jong ro, jiè ai ne Aphuii è khi è rek ne sbang ruii pha duiine Ragung So mua dun ro. Nathek è nyie doh ne yoi pha ji ne ai lasen ro, ai è gethek shii thoi phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Hì ne Dawid Saja è hamangkhung dun ne rek pha asi pha yi ai è yao, Ithong è gu Ithong shii yao: Gu phawig moe shii dug bo! ");
INSERT INTO bgg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Gu è naro suang pho shii na lai luii shii arek sapho shii ne gu phawig moe shii dug ne rai yi phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Israel pha branthek wo! Hì ne thieg mage bo, nathek è zun ne ua pha Isu hì ne Hamangkhung-aphuii è gethek Ithong nane Masi rab phi ro.” ");
INSERT INTO bgg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Branthek è ji yao pha yoi ne zab diig now srane Phithar nane gai guaphasamoy shii wuii ne sai, “Khuiinothek wo! Ji arone, gathek ne nyie rek chid phiiga?” ");
INSERT INTO bgg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phithar è ithek shii yao, “Nathek de nawaithek layog rek pha blia ji thoh srane Isu Masi beng è khowo yi bo! Chiihphado, nathek layog de khung phi srane Hamangkhung-aphuii pha lasen Ragung So mua ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nyieliieshii, Hamangkhung-aphuii pha sbang ne nathek shii de, chiih-è nathek pha aniphiing shii de, chiih è, bajo ruang phothek shii de, hanyie shii Hamangkhung-aphuii è awai rog shii rai pha ho pho shii de rek ne ruiijong ro.” ");
INSERT INTO bgg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Phithar è branthek shii bajo gai miyaogamthek è de yie ne yua, “Layog rek pho shii diig thog ruii pha ji è nawaithek shii ragia rek iang bo!” ");
INSERT INTO bgg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ji è yao mage shii, bran giak è ne ji pha mua ne izai now gieng ne khowo phi yi, chiih è, ji phado shii itham uom pha branthek de ji pha ibrog shii dog gieng dun. ");
INSERT INTO bgg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ithek ne ishak phi ne guaphasamoy miyao nuii. Chiih-è, ò si rai pha wuii gieng srane sia pha michiethek thang ne chie srane sia ne rai gieng. ");
INSERT INTO bgg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Guaphasamoy è bajo wieng pha bliathek nane anomuluii pha bliathek rek mage ne branthek ne zab rum dun. ");
INSERT INTO bgg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Migipho ne awaithek chung shii athohdang pha ò wuii srane sia ne awaithek shii nyie um pha ji awaithek chung thang rai. ");
INSERT INTO bgg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Awaithek pha nuruii, soh raig um pha thek chong liu srane bang jithek ne khinyama jia chid pha ji thang rai. ");
INSERT INTO bgg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inai tham ne ithek ne Misiahò hà ò si rai, chiih è, awai hò hà jum rek ne sang ne michiethek chie ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hamangkhung-aphuii shii laso phi ne awaithek chung de wie now pha ji lubo rek rai. Ji pha Ithong è inai tham ne hanyie ragia rey jong pho ne ithek rog dog phi. ");
INSERT INTO bgg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Inai jia pha habjuang ishak uom shii, Phithar nane Jon ne Misiahò hà sia pha ishak shii wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Thiichiih shii bajo khie gak jia um pha moe shii giak dang pha è laikhi-èg pha bran jia idang thiichiih shii noh ne dug yi srane Misiahò bucho wuii pha branthek shii bang lia pha khan ne rai pha jia um iang. ");
INSERT INTO bgg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ji pha bran è Phithar nane Jon shii iliing wuiiramuii pha doh mage ne bang phi bo ne lia. ");
INSERT INTO bgg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ithek ne aishii miang è riig chiih-è Phithar è aishii yao, “Gasa shii riig mage bo!” ");
INSERT INTO bgg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ji-è, ji pha bran ne bang ìujia mua pha luthong ne isa shii riig. ");
INSERT INTO bgg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ji è riig magungde Phithar è aishii yao, “Gu shii ne bang ìujia de oi ro, jimagunde, gu shii nyie um pha ji na shii phi ruii phro: Nazareth pha Isu Masi beng è gu na shii yung phro, na ne jai srane lua mage bo!” ");
INSERT INTO bgg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ji è yung srane Phithar è phawig wad è nong ne aishii chaing ne riu yi. Ji è yao dang pha ji shii ji pha bran pha lai nane laikhimiegthek ne gang rey dang dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ai ne biung srane awai lai è riu mage ne shan ne lua mua dun. Ji è rey ched mage ne ji pha bran de ithek rog shii Misiahò hà wuii gieng ne lua ne, biung ne Hamangkhung-aphuii shii laso phi. ");
INSERT INTO bgg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Branthek è ai ne lua ne Hamangkhung-aphuii shii laso phi pha doh, ");
INSERT INTO bgg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ai ji è rek pha ji ne thiichiih pha branthek è doh ne thieg srane, ai ne bajo khie pha gak shii um pha chayem bran rone ithek è thieg dun ne aishii nyie rey pha ji riig ne zab wiengphleg dun ne anomuluii pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bran ji è Phithar nane Jon shii kho ne Solomon è rab pha ithua shii riu mage shii, branthek ne wiengphleg ne ithek moe shii riig pha ran thog. ");
INSERT INTO bgg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phithar è branthek shii doh mage ne branthek shii yao, gu ijakthek wo! Nathek ne nyie rek ne wiengphleg dun phlei? Chiih è, nyie rek ne gathek shii mieg rua riig phlei? Nathek ne hì pha bran lua mua phi phane gathek è chid pha blu um ne rek mua è now bey? ");
INSERT INTO bgg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham ro Hamangkhung-aphuii, Isakh nane Jakhob gethek ro blang Hamangkhung-aphuii è awai khiao Isu shii hì so biisiie phi ne ruiijong ro. Jimagunde, nathek è aishii ne thiig pha riichaithek wad shii phi muii, chiih-è, nathek è aishii athieg rone Philathus moe shii de snai srane Philathus è aishii doh pha rek de adoh yi ro. ");
INSERT INTO bgg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ai ne so nane wie pha bran habuii shii, nathek è aishii snai muii, nathek è ai chiang shii branthek uapho pha bran ji shii haro han ne Philathus shii lia ne thoh yi. ");
INSERT INTO bgg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hanyie è chai shii dumuii rek pha bran shii ne nathek è ua muii. Jimagunde, Hamangkhung-aphuii è aishii hòi din yi. Gathek ne ji pha blia pha khagi ro. ");
INSERT INTO bgg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ji pha ibeng è sudoh hì pha blu phi ne laikhi-èg pha bran hì ne gang dun ro. Nathek è nyie riig ne thieg phane ai beng shii izai now ne ji mirey ro; Hì ne Isu shii migi now mage ne ji mugang yi ro, Ji ne nawaithek de nyariig mua phro. ");
INSERT INTO bgg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ji-è, gu khuiinothek wo! Gune thieg muii ro nathek nane nathek pha ilkhi rek phothek è Isu shii nyie rek pha ji ne athieg pha rek muii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Buyo shii Hamangkhung-aphuii è zab chaig phothek shii yao jong ne ruii, Masi ne diig rek chid phro, ji izai rey yi pha ai è ji rek phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nathek de zo srane Hamangkhung-aphuii shii khid din mage bo, chiihphado, nathek ro layogthek de khung phi phro. ");
INSERT INTO bgg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nathek de ji rek arone, Ragung So pha ishak ne Ithong è thog ruii phro, chiih è, ai è Isu shii doh ruii phro. Ai ne Masi ro! Ai ne nathek chiang gua jong ne ruii ro. ");
INSERT INTO bgg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ji è, Hamangkhung-aphuii è buyo buyo shii rai pha awai chaig gang pho shii yao marui pha duiine, ai ne ichiih soh khung shii zab wo rey ne athog ba sapho shii ne hamangkhung hà rai chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses è yao marui, Ithong, nathek pha Hamangkhung-aphuii è gu shii khi-è rek ne thoh pha ji duiine nathek shii awai chaig jia doh ruii phro, ai ne nawaithek pha bran phro. Nathek ne ai è nyie yao phajithek zab nuii ne rek yi pha yao phro. ");
INSERT INTO bgg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Hanyie thek è ji pha chaig miyao anuii pho ne Hamangkhung-aphuii pha branthek è yo che ne iy yi phro. ");
INSERT INTO bgg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Chiih è zab pha chaigpho è yao muii ro, chiih-è Samuel è lua ne, chiih-è hanyie ai è idoh wuii phothek è de sudoh nyie rey pha ji yao ro. ");
INSERT INTO bgg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hamangkhung-aphuii è chaigpho shii yao ne sbang phi phane nathek chiang phi phro, chiih-è, nathek è nawaithek pha riingthek shii Hamangkhung-aphuii shii zen pha shiinyie ji sudoh thang jong ro. Ai è Abraham shii yao pha duiine, “Gu ne, na riingthek è, sohnyiak pha branthek shii, khirzey phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ji-è, Hamangkhung-aphuii ne gua pha awai khiao jia doh bi ne nathek shii khirzey phi yi srane naithek shii nawaithek layog lumuii è thadoh dun yi phro.” ");
INSERT INTO bgg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Phithar nane Jon ne branthek shii jithek yao ramuii shii, phabithek, Misiahò pha sandrithek pha ilkhi pha ophispho nane Sadusithek wuii thog. ");
INSERT INTO bgg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ithek ne guaphasamoy nyi è Isu ne iy ne hòi din phro izey pha ji duiine hòi jong ro è yao ne yua pha ji doh ne bajo lubu hòi ne lijieg dun. ");
INSERT INTO bgg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ji-è, ithek ne ithek shii zum srane hamiang arey ba sapho ne phatheg hà chab ne ruii muii. Nyieliieshii, ji pha doh ne biak jong dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ji è rek magungde, khinyama pha bran è ji pha mua yoi pho ne ji migi now dun, ji è, ji pha idoh shii branthek ne itham guii huak ne um dun. ");
INSERT INTO bgg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ji pha thimiang duii shii, Jewish pha dumuiithek, dukhothek nane Ipheythek yua pho Jerusalem shii khrab ne wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ithek ne Kho Phabi Anas nane khaiaphas, Jon, Alezendar, chiih-è Kho Phabi pha gai haliingpho shii si pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ithek è guaphasamoy shii limiang moe shii riu yi srane sai, Nasa ne hì rek phane khi-è mua phlei? Khi-è rek pha riichai mua ne um lei? Chiih è, hanyie beng è yie ne ji rek mua phiiga? ");
INSERT INTO bgg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Phithar è Ragung So mua ne ithek shii chang, branthek shii dumuiithek nane dukhothek wo: ");
INSERT INTO bgg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nathek è gathek shii sudoh hì pha laikhi-èg pha bran shii khi-è rek ne gang phi pha blia wie pha chiang è miyao sai arone, ");
INSERT INTO bgg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nathek de sudoh shii thieg dang bo, chiih-è, Israel pho de sudoh shii thieg dang bo, hì pha bran ne gang ne riu mua pha ne Nazareth pha Isu Masi, hanyie shii nathek è zun ne ua maphi habuii shii Hamangkhung-aphuii è hòi din yi pha ibeng re-è rey ro. ");
INSERT INTO bgg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Isu è jigigam shii zey pha duiine ro, “Khi pha lubao shii chan hò khimphothek è snai muii pha ji ne bajo chid pha lubao rey dun ro.” ");
INSERT INTO bgg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Giawo ne awaiji shii um bie ro; Hamangkhung-aphuii è gethek shii ragia rek pha ichiih sohjambling shii hanyie shii de aphi ne aruii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Thiichiih um pha limiangthek ne Phithar nane Jon è chua mua ne yao pha ji doh mage ne bajo wiengphleg dun, nyieliieshii, ithek ne jigi azey pha bran ro. Ithek è ithek ne Isu rog shii rai gieng pha bran rone thieg dun. ");
INSERT INTO bgg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jimagunde, ithek shii nyie de ayao mua pha rai dun, nyieliieshii, gang pha bran ji ne isa rog shii riu ne rai ne um iang. ");
INSERT INTO bgg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ji-è, ithek è isa shii ji pha limiang ùgud thoh ne fuang wuii ge srane awaithek chung phak ne sai rai, ");
INSERT INTO bgg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Gethek ne hì pha bran nyi shii ne nyie rek sha pha um ga?” “Jerusalem pha zab branthek è bajo wiengphleg pha blia hì ne isa mirek rone thiegjong dun ro, gethek ne hì pha blia ne asi rone ayao mua phro. ");
INSERT INTO bgg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jishii, hì pha mua ne hanyie de ayoi yi pha gethek ne isa shii Isu beng è khuchung magungde ayao yi pha gak ne ruii pha um ro.” ");
INSERT INTO bgg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ji è phak ched ne ithek è isa shii thadoh ho din srane yao, khuchung magungde nathek ne Isu beng yao ne ayua dang rabo. ");
INSERT INTO bgg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ji è gak magungde, Phithar nane Jon è ithek shii chang, “Nathek ne nawaithek lubu shii nowbthan ne chua mage bo, Hamangkhung-aphuii moe shii nyie miyao ji ne izai bey? Nathek miyao ji nuii ne rek shii wie pha um bey? Asi, Hamangkhung-aphuii miyao ji nuii ne rek shii wie pha um bey? ");
INSERT INTO bgg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ji è, gathek ne gui thek è nyie doh, nyie yoi phajithek ayao pha arai mua phro.” ");
INSERT INTO bgg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jithek nuii srane limiangthek è ithek shii wie phriie srane sey ne thoh ge. Limiangthek ne isa shii lago ne aphi mua pha um, nyieliieshii, branthek ne Hamangkhung-aphuii è nyie rek phi phajithek shii bajo sang ne Hamangkhung-aphuii shii laso phi dun. ");
INSERT INTO bgg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hanyie shii wieng dang pha gang phi pha bran ji ne idam sawi sieng jong ro. ");
INSERT INTO bgg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Phithar nane Jon ne sey ne thoh dang shii, awaisa pha ijakthek rai pha ithua hà dun thog srane boh phabithek nane thiig pha dukhothek è nyie yao phajithek yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ithek è jithek yoi mage ne awaithek chung khrab srane Hamangkhung-aphuii shii sia: hamangkhung, sohnyiak, kho nane thiichiih shii nyie um phajithek rab pha Masdo wo! ");
INSERT INTO bgg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ragung So è gathek blang pha Dawid, nawai khiao è yao ne ruii, ai Gaibranthek ne nyie rek ne lijieg phlei? Nyie rek ne branthek awaithek shii adunmey pha rek phlei? ");
INSERT INTO bgg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sohnyiak pha Sajathek ne awaithek saro ne nung rai dun, chiih è, bohkhohphothek ne awaithek chung khrab srane Ithong nane airo Masi shii gidieg rek noh. ");
INSERT INTO bgg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ji duiine Herod nane Phonthius Philath ne Gaibranthek nane Israel pho rog shii dog srane Isu shii, na ro khiao so, hanyie shii na è Masi rab pha ji shii gidieg rek dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ithek ne ò khrab srane nawai riichai nane nawai è khi-è rey pha phak jong pha ji rek pha surui ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ji-è, Ithong wo! Ithek è phriie pha ji riig srane, nawai khiao gathek shii na mua ji yao pha lububo phi bo. ");
INSERT INTO bgg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","“Nawai wad yie srane nawai khiao so Isu beng è rad pho shii gang yi pha, anomuluiithek pha nane buangthek pha bliathek rek mua yi pha chua phi mage bo.” ");
INSERT INTO bgg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ithek è ji sia pha jong ched mage shii ithek dug ne sia pha ithua ne sham dang dun, ithek zab ne Ragung So è ley dun, chiih-è jao ne boh now ne Hamangkhung-aphuii pha mua ji yao dun. ");
INSERT INTO bgg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ji pha migipho ne ò jia now ne rai bie dun. Zab è awaithek khinyama pha nuruii um ne de awaithek hanyie hanyie ro ayao dang pha awaithek chung thang rai. ");
INSERT INTO bgg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ji pha guaphasamoy ne bohblu um dang ne Isu hòi din pha mua ji yao ne rai phi ne Hamangkhung-aphuii è ithek shii bajo khirzey phi dun. ");
INSERT INTO bgg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ji pha phrag shii ne nyie de chid phane oi sha, hanyie shii raig um ne de, hò um ne de zab chong rek ne khinyama pha bang mua pha ji ne thiichiih yi ne phi. ");
INSERT INTO bgg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Chiih è, jithek ne guaphasamoy shii zid phi; ji pha bang ne samoythek è awaithek shii nyie khi è chid pha ji riig srane thang rai. ");
INSERT INTO bgg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chiih è jine Joseph ro, hanyie yi Khaiphrus hà giak pha Lewithe ro guaphasamoy è Barnabas beng pha jia ro, (ji pha ibeng ne “Hanyie è luthong phi pha bran rone ibeng pha bran ro”), ");
INSERT INTO bgg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Awai raig ithua chong rek muii srane bang mua pha ji ne guaphasamoy shii phi muii. ");
INSERT INTO bgg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jishii, thiichiih shii Ananias beng pha bran jia de awai yiy Saphira rog shii awai ro nuruii chong rek muii. ");
INSERT INTO bgg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jishii, awai yiy rog shii phak srane ji pha bang ne giak ne ug ne ruii marui ne guaphasamoy shii phi thog. ");
INSERT INTO bgg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ji è rek shii Phithar è sai, “Ananias, na ne nyie rek ne Sakhathong è yang yi ne na nuruii è mua pha bang khuyo ug srane Ragung So moe shii khlam phlei? ");
INSERT INTO bgg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ji pha nuruii ne chong arek ba pha ibi de nawai ro chag, chiih-è, chong rek ched ne mua pha bang de nawai ro chag ro. Na ne ji nyie now ne rek phlei? Na ne bran shii khlam pha asi pha yi Hamangkhung-aphuii shii khlam ro.” ");
INSERT INTO bgg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias è ji è yao pha nya yoi dang mage shii thud ne iy dun; chiih-è, thiichiih um phothek de ji yoi ne rum dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Filiaothek wuii srane iy pha siu shii yung jiang srane fuang noh ne wieng muii. ");
INSERT INTO bgg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ji è rey ched ne ishak uom pha idoh è nyie rey dun pha ji athieg pha ai yiy de thiichiih wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phithar è aishii de sai, “Na ne gu shii izai yao mage bo, hì pha bang ne na gey nasa è chong rek ne nyie mua pha ji chag bey?” Ai è chang, “Hì ne ji chag bie ro,” “Zab pha bang ne hìnyia jia bie ro.” ");
INSERT INTO bgg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ji è, Phithar ne aishii yao din, “Na gey nasa ne nyie rek ne Ithong pha Ragung shii chai ne riig phlei? Na gey shii wieng pho ne thuh de habin shii thog ne riu ba muii ro, ithek è na shii de wieng pha noh dun phro!” ");
INSERT INTO bgg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ji è yao dang pha ji shii ai de Phithar lai luii shii thud ne iy dun. Filiaothek è biisa wuii srane ai iy dun pha ji de doh mage ne fuang noh ne ai gey moe shii chog ne wieng muii. ");
INSERT INTO bgg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ji è rey pha mua yoi mage ne chiihphado shii charchthek hanyie è ji doh pho ne bajo rum ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Guaphasamoythek buangthek nane anomuluiithek dang pha bliathek ne branthek moe shii bajo rek ruii. Migiphothek ne Solomon murung marui pha hò bucho hà si ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Branthek è ithek chiang khinyama dog yao mua magungde, fuang pha bran brog ne hanyie de ithek rog shii adog mua gieng. ");
INSERT INTO bgg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jimagunde, inai tham ne bran bajo bajo dog dun bajo hò-aphuii, hò-amuii hanyie thek è Ithong shii Migiphothek mudog gieng. ");
INSERT INTO bgg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Guaphasamoy è nyie thek rek pha ji doh ne branthek ne Phithar lua mage shii Phithar pha ragia è doh yi pha rad pho shii noh srane lumuii hà lawiao wiao ne thiang yi. ");
INSERT INTO bgg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem bajarai pha bran brogthek de bran rad pho nane ibuii ragung è jiang pho shii noh ne bajo wuii thog ruii. Ithek de gang dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ji è rek mage ne, boh phabi jia nane airo ijakthek, Sadusithek pha ijakthek è guaphasamoy shii bajo miegriie dun; ji-è, ithek ne diig phi pha nung ne yao rai. ");
INSERT INTO bgg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ithek è guaphasamoythek shii zum srane phatheg chab muii. ");
INSERT INTO bgg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Jimagunde, ji pha ibiu shii Ithong pha Hamangkhung pha hamangkhliie thek phatheg ji pha habin hong phi ne guaphasamoythek shii fuang dun yi pha rek phi ne yao, ");
INSERT INTO bgg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Fuang dun mage ne Misiahò hà wuii srane hì pha iwo chai mua pha ji branthek shii yao mage bo.” ");
INSERT INTO bgg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Guaphasamoythek de ji nuii ne dun dun. Chiih è, hamiang hanai chiu shii, Misiahò hà wuii srane yua din. Kho Phabi nane ai ijakthek è Jewish pha dukhothek shii limiang jung yi pha ho ne maley rek. Maley rek ched ne ithek è ji pha phatheg bucho shii chab pha guaphasamoythek shii ithek moe shii noh mage bo ne yung ne thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Jimagunde, phatheg pha sandrithek è thiisa thogmage shii guaphasamoythek ne phatheg bucho hà um iang pha adoh. Ji è ithek ne limiang shii idoh dun din srane phosro, ");
INSERT INTO bgg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Gathek ne phatheg pha moe thog shii, phatheg pha habin ne chuh è bin ne um iang. Thiichiih pha sandrithek wie riu ne um iang ro. Jimagunde, gathek è habin hong ne bucho wuii thog ne riig shii hanyie de bucho shii oi iang ro!” ");
INSERT INTO bgg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Boh phabithek nane phatheg pha sandri pha ophispho è ji yoi mage ne guaphasamoythek ne nyie rey dun lei è now ne anomuluii pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ji è rek shii bran jia wuii thog srane ithek shii yao, “Hanyie shii nathek è zum srane phatheg chab muii pha ji ne Misiahò hà branthek shii yua din ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ji è, ophispho jia è awai bran pho noh ne guaphasamoythek shii idoh noh thog din. Ithek è guaphasamoythek shii bangchiie è anoh mua, nyieliieshii branthek bajo um dun pha ji è yang ne branthek è ithek shii lubao chao mage è now dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ithek è guaphasamoythek shii bucho hà noh srane limiang moe shii riu ba yi, chiih-è, Kho Phabi è ithek shii sai, ");
INSERT INTO bgg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Gathek è nathek shii ji pha bran beng yao ne ayua rabo phriie ne ruiijong habuii shii, riig mage bo, nathek è nyie rek din phiiga! Nathek ne Jerusalem pho shii mua hì zab yao muii ro, chiih-è nathek ne ai iy pha gaja ne gathek shii the yang muii bey!” ");
INSERT INTO bgg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phithar nane gai guaphasamoythek è chang, “Bran miyao asi pha yi Hamangkhung-aphuii miyao nuii chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nathek è sharo è hing bai shii phey srane zun ne ua muii pha Isu shii gethek pha blangthek pha Hamangkhung-aphuii è hòi din phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Hamangkhung-aphuii è aishii hòi din phi srane awai phawig moe shii dumuii nane ragia rek pha bran rab ne ruii ro, nyieliieshii, Israel pho shii awaithek layog lumuii è thadoh riie ne dun yi ne layog khung phi phro. ");
INSERT INTO bgg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Gethek ne jithek rey phane riig pho ro, gathek nane Ragung So, hanyie thek ne Hamangkhung-aphuii pha lasen ne hanyie è ai miyao nuii phi phajithek ne ji rey pha miyao thieg mua ro.” ");
INSERT INTO bgg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Limiangthek è ji chang pha yoi mage ne bajo lijieg srane guaphasamoythek shii ua muii pha now. ");
INSERT INTO bgg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jimagunde, branthek è bajo wie now pha, Gamaliel beng ne Iphey yua pha bran jia thiichiih pha limiang duchoi shii jai mage, ai è guaphasamoythek shii fuang noh bi bo è yung. ");
INSERT INTO bgg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Chiih è, limiang shii yao, “Gu ijak Israel pho wo! Nathek ne hìthek pha bran shii nyie rek pha now pha ji ne wie nowbthan ne rek bo. ");
INSERT INTO bgg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nathek de now luii bey! Buyo shii Theudas beng pha bran jia khia khlei ne awaishii bajo boh pha bran ro è yao, chiih-è, branthek de ai rog shii wieng wi dog gieng. Jimagunde aishii ne ua muii, airo samoythek de zab yo dun ne ai mulua pha lumuii ji sand dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ji phadoh è de Galili pha Judas yi sathang tham pha ishak shii khia srane bajo branthek de ai rog shii dog gieng dun, jimagunde, aishii de ua maphi, airo samoythek de zab yo dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ji-è, gang nathek shii yao phro, hì è rek pha miyao shii ne hìthek pha bran shii diig phi pha anow rabo. Ithek shii thoh muii bo! Ithek mirek ji yi bran munow pha è dong arone, awailum ne nya sand dun phro, ");
INSERT INTO bgg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Jimagunde, hì ne Hamangkhung-aphuii è dun ruii arone, nathek ne ithek shii ayang mua phro. Nathek ne nawaithek shii Hamangkhung-aphuii rog shii gidieg suang rek pha nyadoh ruii phro!” Limiang è Gamaliel pha miyao nuiidun. ");
INSERT INTO bgg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Guaphasamoythek shii iliing ho srane chia ne zuang bi ne Isu beng ayao yi sha pha phriie ne thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Guaphasamoythek ne limiang thoh ne fuang dun thog shii bajo sang dun, nyieliieshii, Isu chiang è diig rek phane Hamangkhung-aphuii è ithek ne bajo san dun. ");
INSERT INTO bgg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Inai tham ne Misiahò nane branthek hò bucho hà de ithek ne athodang pha Isu Masi pha Mua Wie ji yao yua ne rai dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ìujia idoh shii, samoythek ne bajo rey ne dog mage shii Grekh yao pho Jewthek nane buyo è Jewthek yao ne ruii pho chung gui rai dun. Grekh yao pho Jewthek è yao, ithek misiungthek shii ne miithan ne athang pha snai muii ro. ");
INSERT INTO bgg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ji è yao mage ne, guaphasamoythek snanyi è zab migiphothek shii ho ne maley jung srane yao, “Gethek ne Hamangkhung-aphuii miyaogam ji snai srane bang kho phane awie ro. ");
INSERT INTO bgg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ji-è, khuiinothek wo! Nathek ne hanyie shii Ragung So um ne wie thieg pho shii ilkhi rab pha mile gua srane ji pha blia rek yi pha phi mage bo. ");
INSERT INTO bgg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Gethek ne, gethek shii sia pha nane miyao yua pha blia shii ishak zab phi ne rek chid phro.” ");
INSERT INTO bgg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ji pha bran brogthek ne guaphasamoythek muyua ji wie than ne ji rek yi pha ilkhithek gua ne ruii phi. Jithek ne Sthephen, hanyie shii bajo migi nane Ragung So um pha bran, chiih-è, philiph, Phrochorus, Nikhanor, Thimon, Pharmenas nane Nikholaus Anthioch pha Gaibran, hanyie è Isu shii migi anow ba pha ibi shii Judaism shii migi now pha bran ro. ");
INSERT INTO bgg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ji pha bran mile shii guaphasamoythek moe shii noh thog ruii, ji-è, guaphasamoythek è ithek khrug lakhung shii wadthek khoh ne sia ne thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ji è rek ne Hamangkhung-aphuii miyaogam ne athodang pha shiie thog dun. Jerusalem shii samoythek ne bajo dog thog dun, chiih-è, Phabithek de migi now thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sthephen ne, Hamangkhung-aphuii è khirzey bajo phi ne blu ley um srane boh buangthek ne anomuluiithek pha bliathek ne branthek duchoi shii rek. ");
INSERT INTO bgg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ji è rek ne rai magungde, thiichiih shii Jewthek misiahò pha sey ne thoh pha branthek è aishii gidieg rek noh dun (hì ne ho pha duiine). Ithek ne Syrene nane Alezendria pha Jewthek ro. Ithek nane Khilisia, Asia ithua hà rai pha Jewthek è wuii srane Sthephen shii khnaing noh. ");
INSERT INTO bgg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ji è khnaing noh magungde, Ragung è Sthephen shii yao, ley pha khani phi ne yao yi. Ji è, idang ai è yao shii ithek ne asi rone anin mua phi. ");
INSERT INTO bgg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ji-è, ithek ne Gaibranthek shii lasen phi srane aishii layog nin yi, “Gathek è ai ne Moses nane Hamangkhung-aphuii shii adunmey pha miyao yao ne rai pha yoi muii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ji è rek ne ithek è branthek shii, thiig pha dukhothek shii, chiih-è, Iphey yua pho shii bajo hòi ne lijieg ba yi, ji-è, ithek ne Sthephen shii zum srane limiang moe shii noh thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Thiichiih shii, ithek è giak branthek shii ho srane khlam yao ne aishii nin yi. Ji pha branthek è khlam ne yao, “Hì pha bran ne idang Hamangkhung-aphuii Misiahò pha Iphey nane Moses pha Iphey ji shii adunmey pha miyao yao ne rai muii ro. ");
INSERT INTO bgg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gathek è ai è Nazareth pha Isu ne Hamangkhung-aphuii Misiahò hì ne chuak srane, Moses è nyie zen marui pha Ipheythek ne zab laimuii phrone yao pha yoi muii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Limiang moe shii dug pha branthek pha mieg ne Sthephen shii athodang pha isiie riig mage shii ai mizia ne hamangkhliie pha mizia duiine doh dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kho Phabi jia è Sthephen shii sai, “Hì ne izai chak bey?” ");
INSERT INTO bgg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sthephen è chang, “Aphuiithek nane khuiinothek wo! Gu miyao hì nuii bi bo! Buyo shii gethek blang pha Abraham è Haran soh hà rai pha adun ba shii Hamangkhung-aphuii pha biisiie ne” Mesophothamia ithua shii khia khlei ne aishii yao, ");
INSERT INTO bgg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“nawai haliing pho nane thiig soh thoh marui ne gu è na shii khi pha soh hà yao phi pha ji shii dun ne rai bo.” ");
INSERT INTO bgg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ji è yao mage ne ai è awai thiig soh thoh marui ne Haran hà rai pha dun dun. Abraham pha aphuii iy ched ne Hamangkhung-aphuii è aishii ji pha soh thoh ne dun din yi srane sudoh nathek rai ramuii pha ji rey yi phro. ");
INSERT INTO bgg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Hamangkhung-aphuii è Abraham shii ji pha thiig shii dun thog magungde ji pha soh ne ìujia de aishii phi ne aruii. Jimagunde Hamangkhung-aphuii è aishii nane ai riingthek shii phi pha sbang rek ne ruii phi. Ji pha sbang rek pha idoh shii ne Abraham shii ani oi pha idoh shii rek phro. ");
INSERT INTO bgg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Hì ne Hamangkhung-aphuii è aishii yao pha miyao ro: Na blangthek ne gai soh hà rai ruii phro, thiisa hà ithek ne khiao rek ne awie dang pha khui yi pha idam wieng wi thog pha rek ne rai dun phro. ");
INSERT INTO bgg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jimagunde, jithek pho shii de guro chua ruii phro, “Ji-è, na blangthek ne ji pha soh è fuang khia ne dun srane hì pha ithua shii gu shii sia din ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ji è yao ched ne Hamangkhung-aphuii è Abraham shii shiinyie duiine doh yi pha miagiangkheg ne rai bo ne zen marui. Ji-è, Abraham ne Isakh shii giak ne damiley thogmage shii miagiangkheg phi, Isakh de Jakhob shii miagiangkheg phi, Jakhob de awai dufuii snanyi shii miagiangkheg phi. Jithek ne gethek pha blangthek mirek ne rai dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jakhob pha dufuii gaithek ne awaithek khuii Joseph shii gidieg rek ne Egyph hà khiao rek yi pha chong rek muii. Jishii, Hamangkhung-aphuii ne ai rog shii um dun pha ji è ");
INSERT INTO bgg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","khinyama pha diig thog ruii ne de aishii ne diig ji è ragia rek phi. Joseph ne Egyph pha Saja moe shii noh thog magungde, Hamangkhung-aphuii è aishii bajo wie than pha nane wie yaolie pha khani phi ne yao yi. Ji-è, saja ji ne Joseph nane ai sathiing shii Egyph pha badri rab ne ruii dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ji è rek shii, doh jia shii Egyph nane Khanon soh hà nokhonosai rey bajo diig thog dun. Chiih è bajo diigchio rey dun, ji nokhonosai rey mage shii gethek pha blangthek ne chie pha nyie de oi pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Thiisa hà wuii phane Jakhob è Egyph hà nyin bajo um rone yoi mage shii, awai dufuii, gethek pha blangthek shii nyin yie pha thoh ge. Jithek wuii phane igobi ba ro. ");
INSERT INTO bgg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Din ne wuii phane, Joseph è awai khuiinothek shii ai ne ithek khuii Joseph rone yao mage ne Egyph pha Saja de Joseph pha haliing pho shii thieg dun, ");
INSERT INTO bgg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ji-è, Joseph è awai aphuii Jakhob shii awai haliing pho, bran samiley è guii shii Egyph hà wuii ruii bo è yao ne mua thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ji è ho mage ne, Jakhob è Egyph soh hà wuii ne rai dun ne awai nane awai dufuiithek thiichiih shii iy dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ithek iy pha siuthek ne Shechem beng pha ithua, Abraham è Hamor pha haliing è bang phi ne pheg pha wieng ithua hà wieng muii. ");
INSERT INTO bgg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Hamangkhung-aphuii è Abraham shii sbang rek pha ji izai rey sha pha idoh thog mage shii Egyph thiig hà gethek bran ne bajo rey ne sieng dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ji è rey mage shii Joseph shii athieg pha Saja jia è Egyph thiig shii bohkhoh pha rey ruii. ");
INSERT INTO bgg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ai è gethek pha blangthek shii gidieg rek ne bajo buii phi ne rai noh. Gethek blangthek pha anithek shii de hò è fuang khia muii srane iy yi. ");
INSERT INTO bgg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ji è rek pha ishak shii Moses ne bajo khie ani rey ne giak thog ruii. Aishii ne imuii è habie uom thog pha hò bucho shii ug ne ram phi. ");
INSERT INTO bgg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chiih è, aishii hò è fuang khia ne fen muii shii Egyph pha saja pha dimi è awai dufuii rab srane sieng yi. ");
INSERT INTO bgg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Aishii ne Egyph pha miyaogamthek zab yua ne sieng noh pha ji è ai ne khani, nyie blia magungde bajo boh rek pha bran rey ne sieng dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses ne idam sawi rey ne sieng mage shii, ai è awai ijak Israelthek shii gai è diig phi pha ji thieg yi pha lumuii sow ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ji è sow ne rai shii, ai è Egyph pha bran jia ne Israelith jia shii thaluii buii rek ne rai iang pha doh ruii, ji è, ai ne wuii srane aishii nong ne Egyphthek shii idoh rog wuii ne ua maphi. ( ");
INSERT INTO bgg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ai è ji rek phane è now ne rek phro, yang ne awai branthek è gua ruii phro, aishii ne Hamangkhung-aphuii è ithek shii diig rek ne rai pha ji è fuang khia yi pha blia boh phro, jishii ithek ne ji agao ro.) ");
INSERT INTO bgg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ji pha thimiang duiine è rey mage shii, ai è Israelith pha bran nyi ne awaisa chung gui rai pha doh ruii, ji-è, ai ne isa shii agui yi pha wuii srane yua, gu ijak Israelith nyi wo! Nasa ne nyie rek muii ne hì iguii rai phlei? ");
INSERT INTO bgg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jishii, hanyie è gai jia shii thaluii diig phiramuii pha ji è Moses shii reng srane sai, “Nashii ne gu shii chua pha bohkhoh hanyie miirab ne phi lei?” ");
INSERT INTO bgg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Na ne diyo shii Egyph bran shii ua pha duiine gu shii de ua pha now bey? ");
INSERT INTO bgg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ji yao pha yoi mage ne Moses ne Egyph thiig thoh ne yo srane Midian soh hà rai dun. Thiisa hà aishii dufuii nyi giak ruii. ");
INSERT INTO bgg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Dam sawi hiìa mage shii, hamangkhliie jia è Moses shii Sinai pha phiing boh moe pha jabiingsing shii bai boh jia hòi ne si phi. ");
INSERT INTO bgg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ne ji doh mage ne bajo wieng dun, ji magungde, ai è ji wie doh yi pha nui wuii. Ji è wuii mage shii ai è Ithong miyaogam yoi ruii: ");
INSERT INTO bgg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Gune nathek blangthek, Abraham, Isakh, nane Jakhob pha Hamangkhung-aphuii ro.’ Ji è yao mage ne Moses ne bajo sham ne ariig mua pha rum dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ithong è aishii yao, ‘Na lakhia than mage bo, na khishii riu pha ithua ne ithua so ro. ");
INSERT INTO bgg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gu è gu branthek ne Egyph thiig hà bajo duhug rek ne rai pha doh muii ro. Gune ithek muchohthek jithek yoi mage ne ithek shii duhug ji è ruang rey yi pha wuii phro. Na ne gu moe shii wuii mage bo; gu na shii Egyph thiig hà wuii yi pha thoh ge pha ro.’ ");
INSERT INTO bgg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses ne, Israel pho è snai pha bran ji ro. ‘Branthek è gethek shii che phi pha bohkhoh bow phane aishii hanyie è bow lei?’ Isai pha bran ji ro. Ai ne Hamangkhung-aphuii è branthek shii khohthek bow srane bai hòi pha jabiingsing shii khia pha hamangkhliie pha nong pha yie srane branthek shii duhug rek ne rai pha ji è fuang khia phi pha bran ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ai è branthek shii Egyph thiig è fuang khia noh, Egyph thiig nane khamuii shaig, chiih-è, balimuang hà idam sawi thog dang pha buangthek pha bliathek rek phro. ");
INSERT INTO bgg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses ne ji pha bran ro, hanyie è Israel pho shii yao, ‘Gu shii khi-è rek ne thoh pha duiine Hamangkhung-aphuii è chaig phuii jia thoh ruii phro, ai ne nawaithek haliing pha bran phro.’ ");
INSERT INTO bgg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ai ne balimuang hà Israel pho rog shii rai pha bran ji ro, ai ne gethek blangthek rog nane Sinai Phiing boh shii hamangkhung pha hamangkhliie rog shii yao pha bran ji ro. Ai è Hamangkhung-aphuii pha sieng pha mua mua ne sudoh gethek shii thog yi pha bran ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Jishii, gethek pha blangthek è ai miyao anuii pha rai dun. Aishii reng muii srane Egyph hà dun din pha now din. ");
INSERT INTO bgg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ji è now ne ithek è Aron shii yao, ‘Cho! Gethek ne gai pha hamangkhung-aphuii rab srane gethek shii lumuii wie noh yi pha um. Nyieliieshii, gethek ne gethek shii Egyph è fuang khia ne dun noh pha Moses ne nyie rey dun pha ji ne athieg mua shaphi ro!’ ");
INSERT INTO bgg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ji è yung ne ithek è suwuiiduii mia pha jangbang jia rab srane muramthek ua ne zid phi ne ithek è nyie rab pha ji bajo wie doh yi pha sai ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ji è chaig pha jigigam shii zey pha duiine Hamangkhung-aphuii ne ithek è ruang dun dun ro. Ithek ne hamang pha dadiangthek shii sia ne rai dun: “Israel pha branthek wo! Balimuang hà idam sawi thog dang pha muramthek ua ne zid pha ji ne gu shii zid pha asi ro.” ");
INSERT INTO bgg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ji ne nawaithek miihan pha jangbang Molekh ro, chiih-è, Rephan jangbang mia pha jangbang, ithek pha dadiang jangbang ro; ithek ne nathek è sia pha jangbang rab pha ji ro. Ji-è, Gune nathek shii Babylon thiig è ruang thog dang khia muii phro. ");
INSERT INTO bgg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Gethek pha blangthek ne balimuang shii Hamangkhung-aphuii um pha shiinyie Haliig um phro. Ji pha haliig ne Moses shii khi è yung pha ji rab ne ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ji pha shiinyie haliig ne gethek pha blangthek è awaithek aphuiithek è khi è rek ne mua lei ne ji athodang pha awaithek rog han ne Joshua rog shii Hamangkhung-aphuii è khi pha soh branthek shii fuang khia muii ne phi pha soh hà khud dun. Chiih-è ji ne thiisa hà Dawid sieng pha idoh thog dang pha raidun. ");
INSERT INTO bgg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawid è Hamangkhung-aphuii haro han phi ne Hamangkhung-aphuii shii Jakhob pha Hamangkhung-aphuii rai yi pha ithua rab pha jia lia, ");
INSERT INTO bgg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Jishii, ji pha hò ne Solomon murung mua bie. ");
INSERT INTO bgg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ji è rung phi magungde; bajo giu hà rai pha Hamangkhung-aphuii ne bran miirab phi pha hò ji shii arai phi. Chaigthek miyao duiine, ");
INSERT INTO bgg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Hamangkhung ne gu dug pha ithua ro, chiih-è, Sohnyiak ne gu lai è thum pha ithua ro.” Na ne gu shii nyie khi-è rek pha hò rung phi pha now ga? Gu rai pha ithua ne khi hà um ga? ");
INSERT INTO bgg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hìthek ne zab gu miirab phi jithek asi bey? ");
INSERT INTO bgg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sthephen è athodang pha yao, “Nathek ne khinyama jia lawasdai pha bran lei?” “Nathek ne khinyama shii um phlei? Nathek ne Hamangkhung-aphuii pha mua ji nuii pha khoh ne khinyama jia khophang um ga? Nathek ne nawaithek pha blangthek duiine ara! Nathek de Ragung So shii snai mua ara! ");
INSERT INTO bgg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Buyo shii de chaig shii nathek pha riingthek è diig phi ne aruii bey? Ithek è Hamangkhung-aphuii pha muaphothek hanyie è giang khiao jia wuii ruii pha mua yao phajithek shii ua maphi ro. Sdoh de ithek ne aishii layog nin srane ua maphi ro. ");
INSERT INTO bgg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nathek ne Hamangkhung-aphuii pha Iphey yi hamangkhliiethek shii phi ne thoh ge ne mua habuii shii, nathek ne ji ne anuii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Limiang brogthek è Sthephen miyao ji nuii ne bajo lijieg ne sinyinthek thak dun. ");
INSERT INTO bgg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ji è rek magungde, Sthephen ne Ragung So è ley dun srane hamangkhung hà hùii ne riig mage shii Hamangkhung-aphuii pha biisiie doh ruii, chiih-è, Isu ne ai phawig moe shii riu ne rai iang pha doh ruii. ");
INSERT INTO bgg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ai è yao, “Riig mage bo! Gune hamangkhung hong pha doh muii ro, chiih-è, Bran Dufuii ji ne Hamangkhung-aphuii pha phawig moe shii riu ne rai pha doh muii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ji è yao mage shii thiichiih um pha limiangthek ne ziak ne choh srane awaithek khohthek wad è cheg muii. Chiih-è, zab branthek ai moe shii ran ruii. ");
INSERT INTO bgg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Aishii ji pha thiig è fuang fen srane lubao è chao mage. Ji riig pho è ithek yung ji yie srane Saul beng pha bufuii filiao jia shii phi ne riig yi. ");
INSERT INTO bgg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ithek ne lubao athodang pha chao mage ne Sthephen ne Ithong shii ziak ne ho, “Ithong Isu, gu Ragung yie muii bo!” ");
INSERT INTO bgg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ai è bam srane ziak ne yao, “Ithong! Hì pha layog ne ithek shii gidieg arey yi rabo!” Ai è ji yao srane iy dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ji ua muii phane Saul è de nuii. Ji pha inai è Jerusalem pha charchphothek ne diig phi pha ji è bajo duhug rek ne rai dun. Thiichiih guaphasamoy shii thoh marui ne charch pha migiphothek ne zab rum ne Judea nane Samaria soh ithua hà yo ched dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Thiichiih shii giak bran è bajo migi now pho um ne Sthephen siu ji yie srane wieng phi ne bajo zo ne choh. ");
INSERT INTO bgg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ji è rek magungde, Saul ne charchthek shii buii rek pha lumuii sow ne rai. Ai ne hò-hò hà wuii srane migipho, hò-aphuii um ne de, hò-amuii um ne de zab shii fuang khia srane phatheg chab maphi. ");
INSERT INTO bgg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Khinyama jia pha migipho ne yoh yoh che dun pha ji è sohsoh hà wuii dun srane ji pha mua yao ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philiph ne Samaria pha rajan boh hà wuii dun srane Masi pha Mua ji thiichiih pha branthek shii yao. ");
INSERT INTO bgg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Thiisa pha bran brogthek de ai miyao pha mua nane buangthek pha bliathek rek pha doh mage ne ai moe shii wuii srane bajo nuii gieng. ");
INSERT INTO bgg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ibuii ragungthek de zab gang ziak ne bran bucho è fuang khia dun, chiih-è, Slem riie pha branthek nane lai wad khi-èk pha branthek de gang dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ji-è, ji pha rajan shii ne bajo boh lubo thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Simon beng pha bran jia de thiichiih shii rai ne um iang. Ai de awai misia è Samarithan pho shii anomuluii pha bliathek rek ne yao, ai de bajo boh pha bran ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ji è rek mage ne ji pha rajan pha zab limiang bran brogthek ne aishii wie nuii ne ai rog shii rai dun. Ithek è yao, “Ai ne Hamangkhung-aphuii pha blu è thieg ro, ‘Bajo bohblu um rone thieg pha ji ro.’” ");
INSERT INTO bgg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ithek ne aishii nyie rek ne wie now dun, nyieliieshii, ai ne thiichiih shii bajo ibi è awai jadu è bajo wieng pha bliathek rek ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ji è rek ne rai magungde, branthek è Philiph è Hamangkhung-aphuii pha Sajathua pha mua wie nane Isu Masi pha mua ji yao mage shii ithek ne migi now magey shii, hò-aphuii um ne de, hò-amuii um ne de, zab khowo yie dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon awai de ji pha mua izai now ne khowo yie srane Philiph rog rai gieng. Ai ne Philiph rog shii rai gieng shii Philiph mirek pha buangthek pha bliathek doh mage ne awai de bajo wieng dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalem pha guaphasamoy è Samaria pho de Hamangkhung-aphuii pha miyaogam ji shii migi now pha yoi mage shii ithek è Phithar nane Jon shii thiisa thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ai è thiisa hà thogmage shii, isa ne migiphothek shii Ragung So mua yi pha sia phi. ");
INSERT INTO bgg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nyieliieshii, ithek ne Ithong Isu beng è khowo yie bie ne Ragung So amua ba pha rai ro. ");
INSERT INTO bgg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ji-è, Phithar nane Jon è awai so wad ithek Khurug shii kho srane sia mage shii ithek de Ragung So mua dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon è guaphasamoy ne migipho shii wad kho ne sia phi shii Ragung So ne migipho shii phi pha doh dun. Ji-è, ai de bang yie srane Phithar nane Jon shii zud ne yao, ");
INSERT INTO bgg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","chiih-è yao, “Gu shii de hì pha blu phi mage bo, ji arone, gu de hanyie shii wad khoh mage shii ai de Ragung So mua ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jishii, Phithar è aishii chang din, “na nane naro bang hì ne thumuluii hà dun dun bo, Na ne Hamangkhung-aphuii pha lasen ne bang è pheg mua pha now bey! ");
INSERT INTO bgg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Na ne gathek rog shii nyie blia rek pha oi ro, nyieliieshii, na ne Hamangkhung-aphuii mieg moe shii giang adoh phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hì è rek ne buii now pha è idoh riie srane Ithong shii sia mage bo, ji-arone, Ithong è ji è now pha layog è khung phi phro. ");
INSERT INTO bgg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gu è na ne bajo miegriie ne layog pha phatheg pho rone doh muii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon è Phithar nane Jon shii yao, “Nasa è nyie yao pha ji è gu shii achun yi pha nasa ne Ithong shii sia mage bo.” ");
INSERT INTO bgg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ithek ne awai sai shii Ithong è nyie rek phi phajithek yao phi, chiih-è Mua Wie de yao marui srane Phithar nane Jon ne Jerusalem hà dun din dun.Tthek ne lumuii hà dun ramuii shii lumuii pha Samaria thiigthek hà de Mua Wie ji yao marui. ");
INSERT INTO bgg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ithong pha hamangkhliie è philiph shii yao, “Saro srane Jerusalem è Gaza dong pha hayang lumuii hà wuii mage bo.” (Ji pha lumuii ne thuh ne hanyie de alua sha ro.) ");
INSERT INTO bgg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ji è yao mage ne Philiph ne saro ne wuii dun. Ji è wuiiramuii shii Ethiophian, hanyie yi Ethiophia pha bisiumuii pha bang kho yi pha dumuii jia de Jerusalem hà Hamangkhung-aphuii shii misia sia ched ne awai sthuh garuii shii in srane Ethiophia dun din ramuii pha doh ruii. Awaiji buiine chaigpho Aijaya mizey pha jigigam ji tham pha doh iang. ");
INSERT INTO bgg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ragung So è Philiph shii yao, “Wuii srane ji pha miihan han pha sthuh moe shii luagieng bo.” ");
INSERT INTO bgg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philiph è ran srane ji pha dumuii moe shii wuiithogmage shii ji pha dumuii ne Aijaya chaig mizey marui pha jigigam ji tham pha yoi ruii. Philiph è aishii sai mage, “Na ne nawai è nyie tham pha ji ne gao chak bey?” ");
INSERT INTO bgg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ji pha dumuii è chang, “Hanyie è gu shii ayao phi arone, khi è rek ne gao mua phlei?” Ji è yao srane ji pha bran è Philiph shii sthuh lakhung khrog ne in yi. ");
INSERT INTO bgg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ai mutham pha Aijaya jigigam ne: “Ai ne ua ne zid pha shiishai duiine ro, ai ne imanthek guii phi shii aro pha shiishaiduii duiine ro. Ai ne miyaogam jia de ayao dang phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Aishii ne biwo rek muii ro, wie chua pha miyao de aishii khiijai. Hanyie de ai riing pha chiang shii ayao mua ro nyieliieshii ichiih sohnyiak shii ai chai pha ishak ne jong dun ro.” ");
INSERT INTO bgg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ji pha dumuii è Philiph shii yao, “Gu shii yao phi bo, hì pha miyao ne chaigpho è hanyie shii yao phlei? Hì ne awaishii yao nebey? Asi pha gai bran shii yao nebey?” ");
INSERT INTO bgg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ji-è, Philiph è aishii ji pha jigigam è jao srane Isu pha Mua Wie ji de yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ji è yao ne lumuii hà luaramuii shii ithek ne kho um pha ithua jia shii thog ruii. Dumuii ji è Philiph shii yao, ichiih ne kho um haga! Gu shii nyie rek ne khowo aphi ba lei? ");
INSERT INTO bgg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philiph è aishii yao, “na è nawai è izai now dun arone, gu de na shii khowo phi phro.” Ai è chang, gune Isu Masi ne Hamangkhung-aphuii pha Dufuii rone migi now chak ro. ");
INSERT INTO bgg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ji pha dumuii è Sthuii shii gak ne riu yi srane kho moe hà wuii thog ne Philiph è aishii khowo phi. ");
INSERT INTO bgg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ai kho è fuang khia dang shii Ragung So è Philiph shii noh dun. Ji pha dumuii ne Philiph shii dinne athodang pha noh dun. Jimagunde, ai ne bajo sang ne hò hà dun-dun. ");
INSERT INTO bgg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philiph ne awaishii Azothus ithua hà thog ne rai pha doh dun. Ji-è, ai ne Khaesarea hà wuii dun. Lumuii hà khinyama jia pha bajaraithek um pha ji shii Mua Wie ji yao marui. ");
INSERT INTO bgg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ji è rekramuii shii, Saul ne Ithong shii migipho shii ua pha noh. Ai ne Kho Phabi shii wuii dun ne ");
INSERT INTO bgg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damaskhus pha Jewish misiahòthek shii wuii thog shii aishii thieg yi pha jigigam jia lia. Nyieliieshii, thiisa hà Ithong lumuii shii lua ne migipho doh arone, hò-aphuii hò-amuii um ne de zab zum srane idoh Jerusalem hà noh pha now ne lia. ");
INSERT INTO bgg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ji-è, Saul ne Damaskhus pha rajan moe shii wuii thog mage shii, hamblo shii Hamang è Haliao jia ai moe shii bliak ruii. ");
INSERT INTO bgg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ai ne ji bliak pha doh mage ne nyiak hà thud dun. Thiichiih shii ai è miyaogam jia rone aishii yao pha yoi ruii, “Saul, Saul! Na ne nyie rek ne gu shii diig phi phlei?” ");
INSERT INTO bgg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul è sai din, “Ithong, na ne hanyie lei?” Ji pha goh ro pha ji è yao, “Gune Isu ro, hanyie shii na ne diig phiramuii pha ji ro.” ");
INSERT INTO bgg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Jishii, jai srane ji pha rajan hà wuii mage bo, thiisa hà na ne nyie rek chid pha ji ne na shii yao phi phro.” ");
INSERT INTO bgg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saul rog wuii gieng pha branthek ne dong ne goh jia de ayao dang pha rai dun. Ithek de ji pha miyaogam ne yoi habuii shii, hanyie miyao ruii ji ne adoh phi. ");
INSERT INTO bgg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul ne nyiak è sieng srane awai mieg yang ne riig mage shii mieg ne adoh pha rey dun. Ji-è, ai rog wuii gieng pha branthek è wad chaing srane Damaskhus hà noh dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Inai da-uom thog dang pha ai ne Miegthi ne rai dun; ji pha da-uom liing shii ai è nyie de achie aniing dang pha rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Thiisa Damaskhus hà Ananias beng pha migipho jia um iang. Ai ne Ithong è miyao jia yao ne ho pha ibang jia bang ruii, “Ananias!” Ai è chang, “Ithong, gune ichiih shii um ro.” ");
INSERT INTO bgg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ithong è aishii yao, “Saro srane miang Judas pha hò liing hà wuii mage ne Tharsus è wuii thog pha Sual beng pha bran um bey ne sai mage bo. Ai de sia mage shii ibang jia bang ramuii ro, ");
INSERT INTO bgg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ananias beng pha bran jia è de aishii wad kho ne sia phi shii mieg doh din yi ne pha ibang bang ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias è chang, “Ithong wo! Ji pha bran è Jerusalem pha naro branthek shii bajo diig phi phane branthek è gu shii yao jong ro. ");
INSERT INTO bgg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ai ne ichiih Damaskhus hà wuii phane boh phabithek è blu rek pha jigigam yie ne na shii misia sia pho shii zum pha wuii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ithong è aishii yao din, “Wuii mage bo, nyieliieshii, aishii ne gu è gu blia rek pha, gu beng ne Gaibranthek nane sajathek, chiih-è, Israel phothek shii thieg yi pha gua jong ro. ");
INSERT INTO bgg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aishii gu chiang è diig rek chid pha miyao ne gu è aishii doh yi phro.” ");
INSERT INTO bgg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ji-è, Ananias ne wuii srane ji pha hò shii khud srane Saul shii wad kho ne khirzey phi. Ai è Saul shii Yao, “Gu khuii Saul wo! Ithong Isu awai mutho ge ro. Hanyie è na shii ichiih wuii pha lumuii hà si pha ji ro. Ai è gu shii thoge phane na mieg ne doh din yi pha thoh pha nane na shii Ragung So mua yi pha thoh ge ro.” ");
INSERT INTO bgg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ji è rek dang shii Saul mieg è ù khug duiine jia chiih dun ne mieg ne sang doh din ruii. Ji-è ai ne jai srane khowo yie mua. ");
INSERT INTO bgg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Khowo yie ched ne michie chie mage shii awai siu shii gang thog din ruii pha than. Saul ne Damaskhus hà migipho rog inai ìujia rai marui. ");
INSERT INTO bgg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ai ne Jewthek misiahòthek hà wuii dang srane Isu ne Hamangkhung-aphuii pha dufuii ji ro è yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Branthek ne ai miyao ji yoi ne bajo anomuluii pha rey ne awaithek chung yao rai, “Hì pha bran ne Jerusalem hà Isu shii sia pho shii ua ne rai pha ji asi bey? Ai ne ichiih shii wuii phade ji pha branthek shii zum ne Bohphabi shii noh ruii pha wuii pha ji asi bey?” ");
INSERT INTO bgg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Jishii, Saul pha miyao ne bajo blu um ne yao dun pha ji è Isu ne Masi ji rone izai ìd yi ne Damaskhus hà rai pha Jewthek ne aishii nyie achang mua pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ji è rek ne inai bajo rai mage shii, Jewthek ne maley dug srane Saul shii ua pha phak rai. ");
INSERT INTO bgg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Jishii, ithek muphak ji ne gai bran è aishii yao phi. Inai habiu rey dun ne de ithek ne athodang pha ji pha rajan gak shii aishii zum ne ua pha khan ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jishii, habiu jia shii Saul pha samoythek è aishii noh ne sirid bucho chab muii srane muthua è dun ge yi. ");
INSERT INTO bgg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul ne Jerusalem hà dun srane samoythek rog dog pha rek. Ji è rek magunde, samoythek ne ai de samoy rey dun rone izai anow pha yi aishii riig ne zab rum dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Jishii, Barnabas è wuii srane aishii guaphasamoy moe shii noh thog ruii. Ai è ithek shii, Ithong è khi è rek ne miyaogam rone yao pha ji zab yao phi. Ji jia asi pha yi ai è khi è rek ne boh noh srane Damaskhus hà Isu beng è yao marui phajithek de yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sual è ithek rog shii rai srane Jerusalem pha ithuathek hà wuii srane Ithong beng è bajo boh rek ne yao ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ai è Grekh yao pha Jewthek shii de yao ne khnaing noh shii ithek è aishii ua pha rek dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Migipho è ji thieg mage ne Sual shii Khaesarea hà noh srane Tharsus hà thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ji è rek pha idoh shii ne Judea, Galili nane Samaria pha charchthek ne liijiing um dun. Ragung So è ithek shii chuh rek phi ne ithek rog shii bajo migiphothek rey ne dog dun ne Ithong shii bajo ilab rek ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phithar ne ithuathek hà lua ne rai. Ishak jia shii ai ne Hamangkhung-aphuii pha branthek shii thiisa pha Lyda hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Thiisa hà ai è Aeneas, slemriie ne idam mileo rey sha pha biang shii thiang ne rai pha bran jia doh ruii. ");
INSERT INTO bgg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phithar è ji pha bran shii yao, “Aeneas, Isu Masi è na shii gang phi ro. Jai srane nawai lawio jiang ne dun mage bo.” Ji è yao dang shii, Aeneas ne jai mua dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lyda nane Sharon hà rai pha branthek de aishii riig ne Ithong shii migi now dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopha thiig hà Thabitha beng pha hò-amuii jia de Migi now ne um. (Grekh è ai ibeng ne Dorkhas ne “Dichiih rone ho”) ai ne idang branthek shii wie rek ne dushothek nong phi ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Doh jia shii ne, ji pha hò-amuii ne rad ne iy dun. Ai ro iy pha siu ne branthek è kho è sud phi srane lakhung pha ùgud hà ruii muii. ");
INSERT INTO bgg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ji pha Jopha ne Lyda è bajo ruang asi pha ji è migipho è Phithar ne Lyda hà um rone yoi mage shii, ithek è bran nyi shii mua yua ne thoh ge, “Na ne gathek moe shii jog wuii mage bo.” ");
INSERT INTO bgg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ji è, Phithar ne saro srane ithek shii wuii dun. Ai ne thiisa wuii thog shii, aishii ne ji pha ùgud hà noh dun. Ji pha ùgud hà wuii thog shii misiungmuiithek è ai moe wuii ne Dorkhas è awai a-iy ba shii rab marui pha phadiig nane yugudthek ro! Hiòg ne riig yi srane choh. ");
INSERT INTO bgg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phithar è ithek shii zab fuang dun yi srane bam ne sia phi; chiih-è, iy pha siu shii riig srane ho, “Thabitha, siang mage bo!” Thabitha è mieg yang ne riig mage shii, Phithar um iang pha doh ruii. Ji-è, Thabitha de sieng ne dug mage. ");
INSERT INTO bgg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Phithar è Thabitha shii wad chaing ne riu yi srane migipho nane misiungmuiithek shii bucho ho ne hòi din pha ji riig yi. ");
INSERT INTO bgg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ji pha mua ne zab Jopha ithua hà yoi dun. Ji-è, branthek Ithong shii migi now dun. ");
INSERT INTO bgg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phithar ne Jopha hà sukhug rab ne rai pha bran Simon pha hò shii inai bajo thog pha rai marui. ");
INSERT INTO bgg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Thiisa hà Khornelius beng pha bran jia Khaesarea hà um. Hanyie shii ne Roman arming regimen pha dumuii rone ho pha “Ji ne Ithalian Regimen ro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ai ne bajo giang rek ne rai pha bran ro; ai nane ai pha haliing phothek ne Hamangkhung-aphuii shii misia sia ne rai pha haliing ro. Ai ne Jewish pha dusho branthek shii bajo nong phi ne Hamangkhung-aphuii shii athodang pha sia ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Inai jia pha habjuang ishak uom rey shii ai è ibang jia bang ruii, ai è ji pha ibang shii doh, Hamangkhung-aphuii pha hamangkhliie jia wuii srane aishii yao, “Khornelius!” ");
INSERT INTO bgg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ai è hamangkhliie shii wie riig mage ne rum ne sai, “Masdo! Hì ne nyie ga?” Hamangkhliie è aishii yao, “Hamangkhung-aphuii è na misia nane na è branthek shii bushun rek pha blia jithek bajo wie than ne na shii chang phi pha rekramuii ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Na, ne nawai bran shii thoh ne Jopha hà um pha Simon Phithar beng pha bran shii wuii yi bo. ");
INSERT INTO bgg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ai ne sukhug rab pha Simon hò shii biwen rek ne rai muii ro. Ji pha ithua ne khamuii ring hà ro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ji è yao ched marui ne hamangkhliie ne dun din dun. Khornelius è awai khiao nyi nane giang rek pha awai siphahi wie jia shii ho. ");
INSERT INTO bgg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ai è ithek shii nyie rey dun pha ji yao srane Jopha hà wuii ge. ");
INSERT INTO bgg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ji pha thimiang duiine rey mage shii ithek ne Jopha moe thog pha wuiiramuii shii, Phithar ne hanai duchoi pha ishak shii ji pha hò shaphiing lakhung hà sia pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ai ne chi-iyiy ne nyie magungde chie yang dun, jishii, michie ne wo jao ne dao ramuii; jishii ai de ibang jia bang ruii. ");
INSERT INTO bgg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ai è Hamangkhung hong srane bajo boh pha yung thilek jia Hamangkhung è thazam riu srane sohnyiak pha iring wi hà jo pha doh ruii. ");
INSERT INTO bgg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ji pha bucho shii jabiing nane hò pha muramthek, lia ne lua pha muramthek, jabiing pha fuiithek um pha doh ruii, ");
INSERT INTO bgg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","chiih è, goh jia rone yao ruii, “Phithar! Sieng srane hìthek ua ne chie mage bo!” ");
INSERT INTO bgg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Jishii, Phithar è yao din, “Ithong wo! Gune achie ro, gune khuchung de achie lo pha zea achie ba riig ro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Goh è aishii yao din ruii, “Hamangkhung-aphuii è so rone yao phajithek ne zea rone anin din rabo.” ");
INSERT INTO bgg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ji è rey phane uomchiieng rey yi srane manathek ne Hamangkhung hà yie din dun. ");
INSERT INTO bgg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phithar ne ji pha ibang ne nyie bang rone! è now ne anomuluii pha rai ramuii shii, Khornelius mutho ge pha branthek è Simon hò thieg ne ji pha hò gak shii wuii thog ne riu ne rai ruii. ");
INSERT INTO bgg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ithek è hò pho shii fuang ho srane sai “Ichiih shii Simon Phithar beng pha biwen jia um bey?” ");
INSERT INTO bgg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ji è rek magungde, Phithar ne awai ibang ji gao yi pha now ne rai ramuii shii, Ragung è aishii yao, “Nuii mage bo! Bsa hà bran uom ne na shii sow ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ji-è, na ne saro srane buzam hà dun mage bo, na ne ithek rog shii awuii yang pha arek rabo, nyieliieshii, ithek shii gu mutho ge ro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ji è yao mage ne Phithar de buzam dun srane ji pha branthek shii yao, “Nathek è sow pha bran ne gu ro. Nathek ne nyie rek pha wuii phlei?” ");
INSERT INTO bgg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ithek è chang, “Gathek shii ne Khornelius dumuii mutho ge ro, ai ne Hamangkhung-aphuii shii sia ne bajo wie pha bran ro, chiih-è, Jewishthek de aishii bajo ilab phi pha bran ro. Hamangkhliie è aishii yao ne na shii awai hò hà ho yi pha thoh ge phro. Nyieliieshii, ai de na miyao nuii mua gieng pha yang dun ro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ji-è, Phithar ne ithek shii bucho ho srane ji pha ibiu thiichiih shii men bo è yao. Ji pha thimiang duiine rey mage shii Phithar è saro srane ithek rog shii wuii gieng; chiih-è Jopha pha migipho giak de ithek rog shii wuii gieng. ");
INSERT INTO bgg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ji pha inai shii ithek ne Khornelius è awai branthek nane nui ijakthek rog khan ne rai iang pha Khaesarea ithua shii wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phithar è bucho khud pha rekramuii shii Khornelius è wuii ne khung ne ai lai moe shii bam. ");
INSERT INTO bgg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Jishii, Phithar è aishii jai yi srane yao, “Gu de bran bie ro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phithar è Khornelius shii athodang pha yao ne hò bucho wuii mage shii branthek de bajo khrab ne rai iang pha doh ruii ne athodang pha yao. ");
INSERT INTO bgg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Phithar è ithek shii yao, “Nathek de thieg iwa! Jew jia shii awai giang rek pha chiang è Gaibranthek rog shii wuii ne arai yi ro.” Jimagunde, Hamangkhung-aphuii è gu shii ne nyie shii magungde zea azen rone è yao ruii pha doh yi ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ji-è, na è gu shii ho pha bran thoh ge shii, gu de nyie de ayao dang pha wuii gieng phro. Gu na shii sai phro, “Na ne nyie rek pha gu shii ho phlei?” ");
INSERT INTO bgg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Khornelius è yao, “Gune inai uom pha ishak ibi hà gui hò shii habjuang rey pha ishak shii sia ne rai ramuii shii, hamblo shii bran jia ne yung khlieng chuang pha jia guii srane gu ibi shii riu ne yao pha doh ruii ");
INSERT INTO bgg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","chiih-è yao: ‘Khornelius! Hamangkhung-aphuii è na misia nane na mirek pha bushun bliathek yoi ne doh dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ji-è, na ne Jopha hà branthek thoh ne Simon Phithar beng pha bran ji shii ho mage bo, ai ne Jopha pha khamuii ring pha ithua hà.’ Sukhug rab pha Simon hò shii biwen wuii ne rai muii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ji-è, gune na shii ho pha bran thoh ge ro. Na de gu mua ji nuii ne ichiih shii bajo wie wuii thog ruii ro. “Gethek ne Hamangkhung-aphuii moe shii Ithong è na shii nyie yao yi pha ji nuii pha khan ne rai ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Phithar è jao ne yao, “Gune, sudoh shii gao sha ro, Hamangkhung-aphuii ne zab branthek shii ò wie rek ne ruii ara. ");
INSERT INTO bgg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Hanyie è aishii sia, chiih-è, giang bliathek rek arone, aishii dun mey ro, ji pha bran ne khi pha iriing è giak ruii ne de ji ariig pha wie rek dun ara. ");
INSERT INTO bgg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nathek de thieg iwa! Ai è Israel pho shii mua thoh phane Isu Masi, zab pha Ithong pha, Liijiing pha Mua Wie ji yao bo ne thoh pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nawaithek de thieg iwa! Galili hà è jao dang ne Jon è khowo yie yi pha yao pha mua thog dang pha Israel pha soh shii bajo boh bliathek thieg iwa. ");
INSERT INTO bgg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nathek de Nazareth pha Isu shii Hamangkhung-aphuii è khi-è rek ne Ragung So nane blu phi pha ji thieg iwa. Ai ne soh soh hà wuii srane wie bliathek rek phi ne ibuii ragung pha blu è jiang pho shii gang phi, nyieliieshii, Hamangkhung-aphuii ai rog shii um dun. ");
INSERT INTO bgg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Gathek ne Israel pha soh nane Jerusalem shii ai mirek marui pha bliathek ne doh gieng phro. Branthek è aishii sharo phey srane bai shii zun ne ua muii ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jishii, Hamangkhung-aphuii è aishii inai da-uom shii idoh hòi din yi ne doh yi ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ji è rek magungde, ai ne zab bran shii asi pha, hanyie shii ai riig pho shii ne Hamangkhung-aphuii è gua jong pha branthek shii si yi phro, ji ne gathek ro, hanyie è ai rog shii ai hòi din pha idoh shii chie niing gieng pho ro. ");
INSERT INTO bgg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ai è gathek shii hì pha muawie ne branthek shii yao bo ne yung marui. Chiih è, Hamangkhung-aphuii è aishii iy ne sieng yi pha chua pha gua ne ruii pha ji rone thieg yi pha rek bo ne yung marui. ");
INSERT INTO bgg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Zab chaigpho è de ai chiang yao jong marui ro, hanyie è aishii migi noh arone, ai beng pha blu è ai layog ne khung phi phro.” ");
INSERT INTO bgg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Phithar è ji yao ramuii shii, Ragung So ne thiichiih ai moe nuii rai pho lakhung shii wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jopha è Phithar rog wuii gieng pha Jewish migipho ne Hamangkhung-aphuii è Gaibranthek shii de awai lasen Ragung So thoi phi pha ji doh ne bajo anomuluii pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nyieliieshii, ithek è khuchung de ayoi ba pha nyuak yao ne Hamangkhung-aphuii shii bajo laso phi pha doh dun. Phithar è ithek shii yao, ");
INSERT INTO bgg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Gethek duiine ithek de Ragung So mua ge ro. Ji è rek mage ne Phithar è sai, ithek shii kho è khowo ayie yi pha hanyie gak mua phlei?” ");
INSERT INTO bgg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ji è sai srane ai è ji pha branthek shii Isu Masi beng è khowo yie yi. Ji è rek phi ne branthek è aishii ithek rog shii inai ìujia rai gieng pha yao. ");
INSERT INTO bgg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Judea soh hà rai pha guaphasamoy nane gai migiphothek è Gaibranthek de Hamangkhung-aphuii pha miyaogam mua dun ro è yoi. ");
INSERT INTO bgg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Phithar è Jerusalem hà dun thog shii, Gaibranthek shii miagiangkheg shii wie now pho è aishii gidieg rek ne yao, ");
INSERT INTO bgg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Na ne migiang alaig pha Gaibranthek hò shii biwen rek ne rai marui. Chiih è, ithek rog shii chie niing marui ara!” ");
INSERT INTO bgg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ji-è Phithar ne ithek shii thiisa hà ibi è jao ne nyie rey dun phajithek zab yao phi: ");
INSERT INTO bgg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Gune Jopha pha rajan hà sia ramuii shii, ibang jia bang ruii” Hamangkhung pha iring wi è thazam riie ne yung thilek jia ichiih soh shii chiih thog pha doh ruii. Ji ne gu moe shii chiih ne khak dun pha doh ruii. ");
INSERT INTO bgg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gu è ji pha bucho shii wie riig mage shii, hò nane jabiing pha muramthek, lia ne lua pha muramthek, jabiing pha fuiithek doh ruii. ");
INSERT INTO bgg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ji è riig mage shii gu è miyaogam jia yoi ruii, Phithar, sieng mage ne hìthek ua ne chie mage bo! ");
INSERT INTO bgg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ji è yao magungde, gu è yao din, Ithong wo! Gune achie ro, Iphey shii izea zen pha khuchung de gu sem è amin ba riig ro. ");
INSERT INTO bgg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Din ne Hamangkhung è yao din ruii, Hamangkhung-aphuii è so zen jong phi phane zea rone anin din rabo. ");
INSERT INTO bgg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ji rey phane, uomchiieng rey srane zab pha manathek Hamangkhung hà yie din dun. ");
INSERT INTO bgg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ji è rey ched dang shii Khaesarea è thoh pha bran uom ne gu rai pha hò shii wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ragung è gu shii akhiijai pha ithek rog shii wuii gieng pha yao ruii. Ichiih um pha gu ijak migi noh pho riig de gu rog shii Khaesarea hà wuii gieng ne Khornelius hò shii ò wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ai è gathek shii, khi è rek ne Hamangkhung-aphuii pha hamangkhliie jia è ai hò moe shii riu ne yao pha ji yao phi, Jopha hà bran Tho ne Simon Phithar beng pha bran shii sow yi bo. ");
INSERT INTO bgg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","“Ai ne na nane na ro haliing pho shii ragia rey pha miyaogamthek yao phi phro!” ");
INSERT INTO bgg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ji duiine gu è jao ne yao ramuii shii, igobi gethek shii phi pha duiine ithek shii de Ragung So phi pha doh ruii. ");
INSERT INTO bgg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ji è rek mage ne gune Ithong muyung pha miyao ji nowkhlei ruii: Jon ne kho è khowo phi bie phro, jishii, jimagunde nathek shii ne Ragung So è khowo mua ruii phro! ");
INSERT INTO bgg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hì è rek phane izai chak ro, Hamangkhung-aphuii ne Gaibranthek shii de gethek è Ithong Isu Masi shii migi now mage ne lasen mua pha ji duiine ò rek ne mua dun ro; ji arone, Hamangkhung-aphuii shii gak mua pha bran ne! Gune hanyie ga. ");
INSERT INTO bgg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ithek è ji yoi mage ne Phithar shii makhak-riing arek sha pha Hamangkhung-aphuii shii laso phi ne yao, “Ji arone, Hamangkhung-aphuii è Gaibranthek shii de awaithek layog è thado riie ne dun yi srane idang sieng pha chua phi ara!” ");
INSERT INTO bgg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Migipho hanyiethek è Sthephen shii ua ne diig phi pha bliathek è rum ne phoenisia, Khyphrus nane Anthioch hà yo ne rai dun pho è mua ji Jewthek shii yao ne rai bie. ");
INSERT INTO bgg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jishii, giak migiphothek ne Khyphrus nane Khyrene è Anthioch hà wuii srane Gaibranthek shii de Ithong Isu pha Mua Wie ji yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ithong pha blu ne ithek rog shii um gieng ne bran bajothek de migi now gieng srane Ithong shii dun ruii. ");
INSERT INTO bgg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ji pha mua ne Jerusalem pha charch hà yoi thogmage ne Jerusalem pho è Barnabas shii Anthioch hà thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ai è thiisa thog ne Hamangkhung-aphuii è ithek shii khinyama khirzey phi ne ruii pha ji riig srane bajo sang ne ithek shii yao, Ithong shii nawaithek è isiie nane izai now ne rai bo. ");
INSERT INTO bgg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ne bajo wie pha bran ro. Ragung So è ley ne migi now pha bran ro. Ithong shii bajo branthek migi now yi pha bran ro. ");
INSERT INTO bgg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ji è yua marui ne Barnabas ne Tharsus hà Saul shii riig pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ai è Saul shii doh mage ne, ai è Saul shii Anthioch hà noh ne wuii noh ne ji pha idam ne Anthioch charch pha branthek shii si ne yua ne rai. Masipho rone beng phane Anthioch charch shii beng ne jao bi. ");
INSERT INTO bgg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ji pha ishak shii Jerusalem è chaig phothek de Anthioch shii wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ji pha chaig phuii jia ne Agbus beng ro. Ai ne Luruak pha blu è riu srane yao, “Ichiih sohnyiak shii bajo chi-iy pha thog ramuii ro” (Ji pha diig cheo ne Khlaudius bisiu sieng pha ishak shii thog dun ro). ");
INSERT INTO bgg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Samoythek è awaithek chung nung ne bang khinyama than mua pha ji than ne Judea hà rai pha migipho shii ren ge. ");
INSERT INTO bgg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ithek è ji è than srane bang ji ne Judea pha charch pha dukhothek shii Barnabas nane Saul wad è ren ge. ");
INSERT INTO bgg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ji pha ishak shii ne Herod Saja ne charch pha migipho shii diig phi. ");
INSERT INTO bgg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ai è Jems, Jon pha ikhuii shii khamriie è wieg ne ua muii. ");
INSERT INTO bgg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ai è ji è rek phane Jewthek shii sang pha blia rek phi pha ji è, ai ne ibi wuii srane Phithar shii zum iang. (Ji rek pha ishak ne sai ne phiia ajiie pha iweb chie pha inai shii rek phro.) ");
INSERT INTO bgg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Phithar shii zum ched srane phatheg hà chab muii. Thiisa hà aishii ne ibrog wi rek ne wi wi dog pha Sandrithek shii phi ne riig yi. Herod è aishii ne Hiia dun pha ji sai inai shii limiangthek moe shii miyao sai pha noh. ");
INSERT INTO bgg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ji-è, Phithar shii ne phatheg hà chab ne ruii muii, jimagunde, charch pha branthek è snak rek ne Hamangkhung-aphuii shii sia mage. ");
INSERT INTO bgg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod è branthek moe shii anoh ba pha ibi pha habiu shii, Phithar ne Sandri nyi duchoi shii men ne rai ramuii shii, aishii ne shiirnai nyi è joi srane Sandrithek de phatheg pha habin shii riu ne riig ba yi. ");
INSERT INTO bgg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Hamblo shii, Ithong pha khliie jia è thiichiih phatheg pha ùgud shii khlieng chuang ne riu thogmage. Ji pha hamangkhliie è Phithar phaliing shii chong ne ho ne yao, “Khthiie sieng mage bo!” Ji è yao dang pha ji shii shiirnai ne Phithar wadthek è awailum ne sey ne chiih dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Hamangkhliie è yao, “Nawai rathang ring ne lakhiathek khia mage bo.” Phithar de ji rek phi. Chiih è, hamangkhliie è yao din, “Nawai yung guii ne gu rog shii dun gieng bo.” ");
INSERT INTO bgg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phithar de ai rog shii phatheg è fuang dun gieng, nyie de athieg pha rek gieng. Jimagunde, yangne hamangkhliie shii ji mirek ne izai phro è now ne rek gieng. Jithek rek phane ai ne ibang bang ramuii ro è now ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ai ne igobi pha Sandrithek Chiih è dinpha Sandri hà thog dun. Chiih è ji pha idoh pha gak shii chiih-è, idohhè ne ji pha rajan hà khud pha gak moe shii thog dun. Ji pha gak ne awailum ne hong phi. Ai ne fuang hà dun srane buzam pha lumuii jia hà luaramuii shii, ji pha hamangkhliie ne hamblo shii Phithar shii ji thoh marui ne sand dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ji è rey pha idoh Phithar è ai rog shii nyie rey dun pha ji than mage ne yao, “Gune thiegsha ro, hìthek ne izai ro! Ithong è awai hamangkhliie shii thoh ne gu shii Herod Saja pha blu nane Jewishthek pha bran è nyie now ne rek pha ji è thiigang phi ro.” ");
INSERT INTO bgg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ji pha ishak than mage ne ai ne Mery, Jon Marg pha Amuii pha hò, bran brog khrab ne sia ne rai iang pha hò hà wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Phithar è habin shii phey ne ho mage shii, Rhoda beng pha khiao jia wuii thog ne chang ruii. ");
INSERT INTO bgg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ai è Phithar pha goh yoi mage ne bajo sang ne hò ahong bi phi pha iliing ran srane yao, Phithar ne fuang hà riu ne um ro. ");
INSERT INTO bgg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ithek è aishii yao, “Na ne ibiu ara!” Jimagunde, ai è ithek shii hì ne izai rone athodang pha yao. Ji-è, ithek de aishii chang, “Ji ne ai ro hamanglhliie ro.” ");
INSERT INTO bgg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ji è rek ne rai magungde, Phithar è athodang pha habin phey ne ho. Idohhè shii ithek è habin ji hong ne riig mage shii, ithek è Phithar shii doh mage ne bajo wieng dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ai è ithek shii aro yi pha wad è phriie ne yao. Chiih è, Ithong è aishii khi è rek ne phatheg bucho è fuang noh phi phajithek zab yao phi. “Hì pha miyao ne Jems nane zab pha migipho shii de yao mage bo!” Ji-è yao marui ne ai ne ji pha ithua thoh marui ne gai ithua hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ji pha thimiang riang rey din mage shii, thiisa hà Phithar shii nyie rey dun phlei è now ne zab Sandrithek ne bajo anomuluii pha rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod Saja è aishii sow yi pha yung, jishii, ithek è aishii adoh mua phi. Ji-è, Herod ne Sandrithek shii miyao sai srane ua muii pha yao. Ji è rek ched marui ne Herod ne Judea thoh srane Khaesarea hà inai ìujia rai pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod Saja ne Thyre nane Sidon pha branthek shii bajo lijieg dun. Ithek ne ò dog srane aishii riig pha wuii dun. Igobi shii ithek ne Blasthus, hanyie yi bohkhoh hò pha dumuii shii wuii srane ithek shii nong phi ne yao. Ji phado è ithek ne Herod Saja shii wuii srane liijiing rek phi pha lia, nyieliieshii, ithek soh shii ne chie niing phane ji pha Saja soh è yie bie phro. ");
INSERT INTO bgg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Gua pha inai shii Herod ne awai bohkhoh sungkho guii srane awai bohkhoh biang shii dug ne branthek shii miyao jia yao. ");
INSERT INTO bgg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Branthek ziak ne yao, “Hì ne bran miyao asi pha jangbang miyao ro!” ");
INSERT INTO bgg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ji è rek dang pha ji shii, Ithong pha jishii è Herod shii thab ne thud yi, nyieliieshii, ai ne Hamangkhung-aphuii shii ilab aphi. Ai ne phuyunthek è chie ne iy dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ji è rek pha ishak shii de Hamangkhung-aphuii pha miyaogam ne athodang pha soh soh hà yoi ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas nane Saul de awai sa shii boh pha bliathek rek ched marui ne Jon Marg shii noh ne Jerusalem è idoh dun thog din. ");
INSERT INTO bgg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anthioch pha charch hà de giak chaigthek nane masdothek um iang: Ithek ne Barnabas, Simeon (Isiie beng pha), Khyrene pha Lusius, Manaen (hanyie shii Badri Herod rog shii noh pha bran) nane Saul ro. ");
INSERT INTO bgg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ithek ne Hamangkhung-aphuii pha blia rek ne minyie nyie ne rai shii, Ragung So è ithek shii yao, “Gu blia rek pha Barnabas nane Saul hanyie shii gu è ho pha ji shii gua ne yo che mage bo.” ");
INSERT INTO bgg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ithek è minyie nyie ne sia srane awaithek wad isa khrug shii khirzey phi ne thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ragung So è wuii yi pha ji è Barnabas nane Saul ne Seleusia hà wuii thog srane dinne Khyphrus pha gachung rai ne run è in ne wuii din dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ithek ne Salamis hà thogmage shii, isa è Hamangkhung-aphuii miyaogam ji Jewthek misiahò shii yao phi. Jon Marg de isa bliathek rek nong gieng ne um iang. ");
INSERT INTO bgg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ithek ne Phaphos pha kho gachungthek dong ne wuii din shii, ithek è Bar-Jesus beng pha jadu rek pha bran, hanyie è awaishii chaigpho rone yao pha bran jia si ruii. ");
INSERT INTO bgg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ai ne ji pha gachung pha badri Sergius Phaulus, hanyie yi bajo khani um pha bran ijak ro. Ji pha badri è Barnabas nane Saul shii awai moe shii ho. Nyieliieshii, ai de Hamangkhung-aphuii pha miyaogam ji nuii pha now. ");
INSERT INTO bgg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jishii, isa shii ne Jadupho Elymas (Hì ne Grekh è beng pha ibeng ro) hanyie è badri ji shii migi now pha ji è ruang rek ne isa shii gidieg rek now. ");
INSERT INTO bgg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saul ne Phaul de beng shii Ragung So è ley dun rone thieg muii pha ji è gidieg rek now pha jaduphuii shii wie riig srane yao, ");
INSERT INTO bgg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ibuii dufuii! Na ne zab wiethek pha suang ro, chiih-è, na ne zab khlam rek pha ji ro! Nane Ithong pha izai ji idang khlam rek ne rai pharek pha ji ro! ");
INSERT INTO bgg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ithong pha wad na shii kho ruii phro; na ne hanai pha muchuang ne inai ìujia thog pha adoh phro.” Ji è yao dang pha ji shii, Elymas pha mieg kham shii ne igiia è cheg dun. Ji è rey mage ne aishii chaing ne lua noh pha bran sow. ");
INSERT INTO bgg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Badri è jithek rey pha doh mage ne bajo migi now dun. Nyieliieshii ai ne Ithong pha miyao ji yua pha ji è bajo anomuluii pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phaul nane ai ijakthek ne Phaphos è Pherga pha phamphylia rajan shii run è in ne wuii thog ruii shii, thiichiih shii Jon Marg è ithek shii thoh marui ne Jerusalem hà dun din dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ithek ne Pherga è de wuii dinne Anthioch pha Phisidia hà wuii thog srane Jewish Thung pha Inai shii ithek ne Jewthek misiahò hà wuii srane dug dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses pha Iphey nane chaigpho mizey marui pha jigigam jithek tham ched shii Jewthek misiahò pha dumuii è mua jia thoh: “Khuiinothek wo! Nathek shii mua nane chua gang pha miyao yao pha um arone, branthek shii yao mage bo.” ");
INSERT INTO bgg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phaul è jai srane wad è phriie ne jao pha yao: “Gu ijak Israelthek nane zab pha Gaibranthek wo!” Hanyie è Hamangkhung-aphuii shii sia pho wo! Gu miyao hì nuii mage bo! ");
INSERT INTO bgg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel pha bran ro Hamangkhung-aphuii gethek blangthek shii gua ne chiih-è gu Egyph hà fuang pha bran duiine rai pha ishak shii boh soh pha bajo bran rab jong ro. Hamangkhung-aphuii pha blu è ithek shii Egyph è de fuang khia ne noh phi ro, ");
INSERT INTO bgg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Chiih è, idam sawi thog dang pha ai ne zud ne ithek rog shii balimuang hà rai gieng. ");
INSERT INTO bgg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ai è Khanon pha soh mile pho shii mua ne awai branthek shii ji pha soh pha Ithong rab ne ruii phi. ");
INSERT INTO bgg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Hìthek zab rey phane idam wieng wi è saguii (450) chia dun ro. “Hì pha idoh è ai ne chaig Samuel sieng pha doh thog dang pha chua ne rai gieng. ");
INSERT INTO bgg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chiih è, ithek è saja zen yi pha lia mage shii, Hamangkhung-aphuii è Khish pha dufuii, Benjamin pha jad è giak pha Sual shii ithek saja rey ne idam sawi khoh yi. ");
INSERT INTO bgg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Hamangkhung-aphuii è aishii thoh din srane Dawid shii saja rab din phi. Hì ne ai chiang è Hamangkhung-aphuii miyao: ‘Gune Jese pha dufuii Dawid ne gu è chid pha bran ji doh muii ro, gu è nyie rek bo ne phi pha ji rek phi pha bran jia ji ro.’ ");
INSERT INTO bgg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Hì ne Isu ro, Dawid pha riing, hanyie shii Hamangkhung-aphuii è Israel pha branthek shii ragia rek ne sbang rek phi pha bran ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Isu è awai blia arek ba pha ibi shii, Jon è Israel pha branthek shii awaithek layog è idoh khid mage bo ne khowo yie mage pha yua ne rai iang. ");
INSERT INTO bgg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Chiih è, Jon è awai bliathek rek ched sha pha rey mage shii, branthek shii sai, ‘Nathek ne gu shii hanyie rone now lei? Gune nathek è khan pha bran ji asi ro. Jishii, nuii mage bo! Ai ne gu idoh shii wuiiramuii ro, gune ai lakhia de ai lai è athan mua phi phro.’ ");
INSERT INTO bgg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Gu ijak Israelthek wo, Abraham pha riingthek nane zab pha Gaibranthek ichiih shii hanyie è Hamangkhung-aphuii shii sia phothek: Giawo hì mua ne gethek chiang thoh dun ro! ");
INSERT INTO bgg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem shii rai pho nane thiichiih shii dumuii rek phothek ne ai ne giawo rek pha ji rone athieg ro, chiih-è, ithek ne chaigthek pha miyaogamthek ne Jewish Thung pha Inai shii idang tham ne rai magungde jithek pha miyao agao ro. Jishii, ithek è Isu shii layog nin ne chaigthek miyaogamthek ji izai rey yi dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ithek è Isu shii ua mua pha nyie ichiig chun pha adoh habuii shii ithek è Philath shii aishii ua yi pha lia. ");
INSERT INTO bgg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jigigam shii zey pha duiine ithek è zab rek ched pha idoh shii ithek è bai è thazam khia srane lubao cho pha wieng shii wieng muii. ");
INSERT INTO bgg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jishii, Hamangkhung-aphuii è aishii hòi din yi srane ");
INSERT INTO bgg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","bajo inai thog dang pha hanyiethek ne ai rog shii Galili è Jerusalem thog pha luagieng pho shii dong ne doh yi. Ithek ne sudoh Israel pho shii khagi re mua ro. ");
INSERT INTO bgg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Gathek de ichiih shii ji pha Mua Wie yie ne wuii ro: Hamangkhung-aphuii è gethek pha blangthek shii rek pha rone sbang rek marui pha ji sudoh Isu hòi din yi ne ithek riingthek è gethek shii rek jong phi ro. Sthun shii zey pha duiine, “Na ne guro Dufuii ro; sudoh gune na Aphuii rey jong ro.” ");
INSERT INTO bgg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Hì ne Hamangkhung-aphuii miyao ro, ai ne iy pha è de hòi dinne airo iy pha siu ne wieng shii ashong phro: “Gu è Dawid shii sbang rek pha ji duiine Gune na shii giang pha nane izai khirzey jithek phi ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gai shii de zey pha duiine, “Na ne nawai khiao isiie shii khuchung magungde wieng shii shong pha aphi phro.” ");
INSERT INTO bgg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dawid ne awai ishak shii Hamangkhung-aphuii pha bliathek rek marui ne iy dun. Ai iy ne awai blangthek rog shii wieng phi, chiih-è, airo iy pha siu ne wieng shii shong dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jishii, Hanyie shii Hamangkhung-aphuii è hòi din yi pha ji shii ji arey ro. ");
INSERT INTO bgg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Gu ijak Israel thek wo! Isu è gethek layogthek khung pha mua ne nathek shii yao ro; chiih-è, hanyie aishii migipho ne Moses pha Iphey è de layog ruang arek mua phi pha layogthek ruang rek phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Chaigthek miyao ji nathek shii arey yi pha nowbthan ne rai bo: ");
INSERT INTO bgg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Lawasdai pho wo! Anomuluii pha iy dun bo!” “Sudoh gu è nyie rekramuii pha ji ne hanyie bran è nathek shii yao magungde nathek ne migi anow ro!” ");
INSERT INTO bgg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Phaul nane Barnabas ne Jewthek misiahò ji thoh ne dun ramuii shii, branthek è isa shii din pha Jewish Thung pha Inai shii wuii ne ji pha miyaothek wie yao din bo ne ho gieng. ");
INSERT INTO bgg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Branthek è maley ji thoh ne dun ched shii, Phaul nane Barnabas rog de Jewthek nane Judaism hà lai dun pha Gaibranthek de luagieng. Guaphasamoy è ithek shii yao marui, chiih-è, ithek shii Hamangkhung-aphuii pha bushun shii athodang pha sieng ne rai bo ne yao marui. ");
INSERT INTO bgg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Din pha Jewish Thung pha Inai shii zab branthek ne bajrai jia shii Ithong pha miyaogam nuii pha wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Jewthek è ji pha bran brog um pha doh mage ne mieg riie srane aishii khnaing ne makhak-riing rek noh. ");
INSERT INTO bgg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jishii, Phaul nane Barnabas è gang rek ne yao din “Hamangkhung-aphuii pha miyaogam ne igobi nathek shii yao bi chid phro.” Jishii, nathek è hì ne snai muii ne nawaithek shii idang chai rey pha ji shii wie anow phi pha ji è gathek ne nathek shii thoh marui ne Gaibranthek shii wuii dun phro. ");
INSERT INTO bgg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Hamangkhung-aphuii è gethek shii hì pha Iphey phi ne ruii: “Gu è na shii ne Gaibranthek pha muchuang rab jong ro” “Ji-è, sohjambling pho de zab ragia nyarey mua phro.” ");
INSERT INTO bgg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Gaibranthek è ji yoi mage shii bajo sang ne Ithong pha miyaogam ji shii bajo laso phi; chiih-è, hanyie shii idang sieng pha migipho rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ithong pha miyaogam ne ji pha ithua shii de zab yoi ched dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Jishii, Jewthek è ji pha rajan shii kho pha hò-aphuiithek nane hò-amuiithek, hanyiethek ne giangthek shii hòi ne lijieg yi. Ithek è Phaul nane Barnabas shii diig phi srane ithek ithua ji è fuang khia maphi. ");
INSERT INTO bgg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Guaphasamoythek è awaithek lai pha nyiakphlab kham srane ithek shii gidieg rek marui ne Ikhonium hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Anthioch shii migiphothek ne bajo lubo nane Ragung So um dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikhonium hà de ji è rey dun: Phaul nane Barnabas ne Jewthek misiahò hà wuii srane bajo boh ji yao mage ne Jewthek nane Gaibranthek de bajo migipho rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ji è rey magungde, Jewthek, hanyie è migi anow pho ne, Gaibranthek shii hòi noh ne migipho shii buii rek dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Guaphasamoy ne thiichiih shii inai bajo rai marui ne ithek è Ithong pha miyao ne bajo gang è yao ne, hanyie ai pha bushun ne izai rone doh yi pha ithek shii blu phi ne buangthek nane anomuluiithek pha bliathek rek mua pha blu phi ne doh yi. ");
INSERT INTO bgg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ji pha rajan pho ne che dun: Giak ne Jewthek rog dog dun, giak ne guaphasamoy rog dog dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Chiih è, giak Gaibranthek nane Jewthek ne ilkhi rek pho rog shii dog srane guaphasamoy shii buii rek ne lubao chao pha nung rai. ");
INSERT INTO bgg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Guaphasamoy è ji thieg mage ne ithek ne Lysthra nane Derbe pha rajan pha Lykhoania ithua nane thiichiih nui um pha soh hà yo dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Thiisa hà de ithek è Mua Wie ji yua marui. ");
INSERT INTO bgg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lysthra hà giak dang bchiih è alua mua pha laikhi-èk bran jia um iang. ");
INSERT INTO bgg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ai de thiichiih shii Phaul miyaogamthek ji nuii ne dug ne rai gieng. Phaul è ji doh mage ne aishii gang mua phi pha izai rek, ji-è, Phaul è aishii wie riig ");
INSERT INTO bgg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","srane gang rek ne yao, “Nawai lai è miang riu mage bo!” Ji pha bran de luang jia biung srane jao ne lua dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bran brog è Phaul è nyie rek phi pha ji doh mage ne Lykhanaonian nyuak è ziak ne yao, “hamangkhung-aphuii ne bran rey srane ichiih gethek shii wuii thog ro!” ");
INSERT INTO bgg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ithek è Barnabas shii Zeus beng ne ruii, chiih-è, Phaul ne Hermes beng ne ruii, nyieliieshii Phaul ne miyao yao pha kho ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Misiahò ne ji pha bajrai pha fuang hà um pha jangbang Jew pha phabi è zid pha suwuiiphuii nane awaithek ibuathek yie ne gak shii wuii thog ruii. Nyieliieshii, ithek ne guaphasamoy shii khlem pha now dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Barnabas nane Phaul è ithek ne isa shii nyie rek phi sha pha surui ramuii pha ji yoi mage ne awai sa yung ji srane bran brog duchoi hà ran srane ziak ne yao, ");
INSERT INTO bgg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nathek ne gasa shii nyie rek pha saro phlei? Gasa de bran bie ro. Gasa ne ichiih ithek shii sohnyiak pha thaluii è rai ne isieng Hamangkhung-aphuii, hanyie è hamangkhung hì, soh hì, khamuii hìthek, chiih-è zab zen phi pha ji shii dun din yi pha Mua Wie ji yao pha wuii bie phro. ");
INSERT INTO bgg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Buyo shii ne, ai è awai branthek shii awaithek lumuii shii lua yi dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Jishii, ai-è, ai um rone doh yi pha wie bliathek rek phi: Ai ne hamang è haphie de ishak shii phie yi, chiih-è, misiengthek de ishak shii sieng yi, ai è ithek shii chie pha phi srane sang pha phi ne ruii.” ");
INSERT INTO bgg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jithek pha miyaogamthek è guaphasamoy ne branthek shii suwuii ua ne azid yi pha rek ne gak mua bie. ");
INSERT INTO bgg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Giak Jewthek ne Anthioch pha Phisidia nane Ikhonium è de thiichiih wuii thog mage; ithek ne bran brog yi awaithek hà yang srane Phaul shii lubao chao srane ji pha bajrai è fuang hà khia muii, nyieliieshii ithek è ai ne iyjong dun ara è now ne fen muii. ");
INSERT INTO bgg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ji è rek magungde, migiphothek è ai moe shii shan ne riu mage shii ai ne sieng din srane ji pha bajrai hà dun din dun. Ji pha thimiang duiine è rey mage shii ai nane Barnabas ne Derbe hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Phaul nane Barnabas è Derbe hà Mua Wie ji yao mage ne bajo samoythek mua dun. Ji è rek ched marui ne isa ne Lysthra, Ikhonium nane Anthioch pha Phisidia hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ai è migiphothek shii chuh rek phi ne chiih-è ithek shii lububo rek phi ne migi now ne izai now ne athoh pha rai yi pha yao phi. Ai è yao, “Gethek ne Hamangkhung-aphuii pha zab riichai hà khud phane bajo diig hà chid phro.” ");
INSERT INTO bgg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ai è khinyama pha charchthek um pha shii ne charch pha dukhothek ne sia ne minyie de nyie srane hanyie shii isiie now pho shii Ithong pha blia rek yi pha boh ne thoh marui. ");
INSERT INTO bgg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Phisidia pha soh dong ne wuii ched marui ne isa ne Phamphylia hà wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Thiisa hà isa è ji pha mua ne Pherga hà yao marui srane Athalia hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chiih è, isa ne thiisa è de dinne run shii in ne Anthioch hà, khi hà ithek è Hamangkhung-aphuii pha bushun è blia phi pha ji rek ched yi pha ithua hà dun thog din. ");
INSERT INTO bgg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ai Anthioch dun thogmage shii, isa è charch pha branthek shii khrab ne Hamangkhung-aphuii è isa rog shii nyie rek gieng nane khi-è rek ne Gaibranthek de migi now yi pha lumuii hong phajithek yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chiih è, isa de thiichiih shii migipho rog shii inai bajo rai marui. ");
INSERT INTO bgg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Judea è Anthioch shii wuii ruii pha bran giak è migiphothek shii yua, “Moses mizen marui pha Iphey duiine migiang-akheg sapho shii ne nathek ne ragia arey phro.” ");
INSERT INTO bgg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Phaul nane Barnabas ne ji pha chiang è ithek rog shii bajo khnaing noh, ji pha chiang ithek ne Phaul nane Barnabas chiih-è, Anthioch shii um pha Gaibranthek de ji pha miyao che ne riig yi pha Jerusalem hà rai pha guaphasamoy nane dukhothek shii wuii ge pha nung rai. ");
INSERT INTO bgg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Charch phothek è ithek shii ji hà wuii pha thoh ge, ji è wuii dun shii, Phoenisia nane Samaria hà de Gaibranthek shii de khi-è rek ne Hamangkhung-aphuii shii migi now dun pha ji phosro phi; ji pha mua è migipho shii bajo sang thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ithek è Jerusalem hà wuiithogmage shii, ithek è Hamangkhung-aphuii è khi-è rek ne ithek rog shii blia rek phi pha ji yao phi pha charch pho, guaphasamoy, nane dukhothek è wie wuii yi, chiih-è ithek è yao. ");
INSERT INTO bgg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Jishii, giak migipho, hanyiethek ne Pharisithek rog dog dun pho è wuii srane yao, “Gaibranthek de miagiangkheg chid ne Moses pha Iphey ji nuii ne rai pha yao chid phro.” ");
INSERT INTO bgg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Guaphasamoy nane dukhothek ò maley jung srane ji pha miyao ji che ne yao. ");
INSERT INTO bgg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bajo phiang khnaing rai pha idoh è Phithar è jai srane yao, “Gu khuiinothek wo! Nawaithek de thieg iwa, gu shii de Hamangkhung-aphuii è buyo è nathek duchoi Gaibranthek è ashii Mua Wie hì yao phi pha gua ne ruii phro. Ji-è, ithek de yoi ne migi now dun phro. ");
INSERT INTO bgg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Chiih è, Hamangkhung-aphuii, hanyie è branthek muno thieg pha ji è Gaibranthek shii de gua ne gethek shii phi pha duiine Ragung So phi ne ruiijong ro. ");
INSERT INTO bgg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ai è gethek nane ithek duchoi shii nyie yoi pha rabjong ro; ai è ithek layogthek shii de khung jong phi ro, nyieliieshii, ithek de aishii migi now dun. ");
INSERT INTO bgg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ji-è, nathek ne nyie rek ne Hamangkhung-aphuii è chai yi ne migipho shii khuchung de gethek nane gethek riingthek è de ahan mua pha diig phi ne han yi pha now nebey? ");
INSERT INTO bgg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Asi! Gethek è migi now mage shii Ithong Isu pha bushun è ithek shii mua dun pha duiine gethek shii de ragia rey dun ro.” ");
INSERT INTO bgg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Barnabas nane Phaul è Hamangkhung-aphuii è buangthek nane anomuluii pha bliathek ne Gaibranthek shii rek phi pha phosro ji yao pha yoi ne zab aro pha rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ithek è ji yao ched mage shii, Jems de yao ruii: “Gu khuiinothek wo! Gu miyao de nuii mage bo!” ");
INSERT INTO bgg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Khi è rek ne Hamangkhung-aphuii è igobi Gaibranthek shii de awai branthek duchoi è yie srane khagi rek phi pha ji Simon è yao jong pha duiine izai chak ro. ");
INSERT INTO bgg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Chaigphothek miyaogamthek ne hìthek shii izai dunmey ro. Jigigam shii zey pha duiine ro, ");
INSERT INTO bgg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Ithong è yao muii ro, hì phado è gune wuii din ruii phro,” Chiih-è Dawid khoh pha riichai ne rab din phi phro. Gune chui dun pha ji ne rab phi ne gang rek din phi phro. ");
INSERT INTO bgg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ji-è, khinyama pha branthek um phane gu shii wuii ruii phro, Gaibranthek, hanyie shii gu è ho pho ne guro bran ro. ");
INSERT INTO bgg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","“Ji-è, Ithong è yao, buyo shii ai miirab ne hì thieg yi phane hì ro.” ");
INSERT INTO bgg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jems è athodang pha yao, “Hì ne gu munow ro, gethek ne Gaibranthek de hanyie Hamangkhung-aphuii shii idoh dun din ramuii pho shii diig aphi chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Hì è rek pha chiang ne, gethek ne ithek shii jangbang shii zud ne izea nin jong pha khinyama chie pha um phajithek achie yi pha, chiih-è, siulao rek pha ji è ruang rai yi pha, chiih-è, yua rib ne ua pha ibey nane ifai achie yi pha jigigam jia zey ne thoh chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nyieliieshii, Moses pha Iphey ne Jewthek misiahòthek shii Jewish Thung pha Inai shii buyo è tham ne rai ramuii ro, chiih-è, ai miyaogamthek ne khinyama bajrai um pha jihà de yao ne rai jong ro.” ");
INSERT INTO bgg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ji-è, guaphasamoy nane dukhothek è charch pho rog dog srane giak bran shii gua srane Anthioch hà Phaul nane Barnabas rog shii thoh ge pha nung rai. Ithek è hanyie shii migipho è bajo ilab phi pha bran nyi, Judas Barsabas beng pha nane Silas shii gua ");
INSERT INTO bgg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","srane ithek shii zey pha jigigam ji phi ne thoh ge: “Gathek ne guaphasamoy nane dukhothek è hanyie Anthioch, nathek pha khuiinothek è, Syria nane Khilisia hà rai pha Gaibranthek pha è giak pha khuiinothek shii salam yao ne thoh ge ro. ");
INSERT INTO bgg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Gathek è yoi muii ro, gathek è che ne wuii dun pha giak bran è ithek shii ithek miyao è diig nane duhug rek yi dun ro; ithek shii ne gathek muyung asi ro. ");
INSERT INTO bgg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ji-è, gathek ne ò si rai srane zab è nung ne giak muaphothek shii gua ne ithek shii thoh ge ro. Ithek ne gethek wie ijak Barnabas nane Phaul wuii pha ro ");
INSERT INTO bgg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","hanyiethek è awaisa chai ne Ithong Isu Masi pha blia shii iy dang yi pha phi muii pha rog shii wuii ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gathek è nathek shii Judas nane Silas shii thoh ne yao yi, hanyie è nathek shii jigigam shii zey pha duiine yao ruii ro. ");
INSERT INTO bgg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ragung So nane gathek zab ne nathek shii gai miihan ahan yi pha zey pha Ipheythek phi bie phro: ");
INSERT INTO bgg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Jangbangthek shii zud pha michie achie rabo; chiih-è ifai de achie rabo, chiih-è yua rib ne ua pha ibey de achie rabo; siulao pha lumuii è ruang rai bo; nathek è ji pha Ipheythek shii wie nuii ne rek ne rai arone, nathek ne wie rey ruii phro. Hì nawaithek wie pha ji ro.” ");
INSERT INTO bgg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ji pha hamangkhliiethek ne thoh ne Anthioch hà wuii thog dun. Thiisa hà zab migipho khrab pha ji shii ji pha jigigam ithek shii phi. ");
INSERT INTO bgg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Branthek è ji tham mage shii, ji pha boh rek yi pha mua è ithek shii bajo sang yi ro. ");
INSERT INTO bgg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas nane Silas, hanyie ne chaigpho rone ho pha nyi è de ithek shii bajo ishak thog dang pha yao ne lububo rek phi ne chiih-è gang rek phi. ");
INSERT INTO bgg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Thiisa hà ìujia ishak thog pha rai marui ne migipho è isa shii liijiing rek srane thoge ne hanyie è ithek pha ji hà thog din. ");
INSERT INTO bgg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Jishii, Silas ne thiichiih rai pha phak dun. ");
INSERT INTO bgg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Phaul nane Barnabas de Anthioch hà ishak ìujia thog pha rai marui srane Gaibranthek shii de Ithong pha miyaogam ji yua ne yao marui. ");
INSERT INTO bgg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ishak ìujia rey pha idoh shii Phaul è Barnabas shii yao, “Cho ginyi ne idoh dun srane ginyi è khinyama pha bajaraithek shii dong ne miyaogam yao ne yua marui pha khuiinothek shii wuii dinne riig sharai, chiih-è, ithek ne khi-è rek ne sieng ramuii ga ji riig wuii sharai haro.” ");
INSERT INTO bgg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas ne Jon Marg shii de isa rog shii noh rui pha now, ");
INSERT INTO bgg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","jimagunde, Phaul ne ji rek phane wie anow, nyieliieshii, ai ne isa rog shii blia ajong ched ba shii Phamphylia hà isa shii thoh marui ne idoh dun din dun. ");
INSERT INTO bgg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ji è rek mage shii, thiichiih shii isa chung khnaing riie ne che dun: Barnabas è Jon Marg shii noh ne Khyphrus hà rai ne run shii in ne dun dun, ");
INSERT INTO bgg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Phaul de Silas shii gua srane ji pha ithua thoh marui ne dun dun, migipho è Ithong pha bushun lia srane thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ai ne Syria nane Khilisia dong ne lua srane charchthek shii gang rek marui. ");
INSERT INTO bgg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phaul ne Derbe nane Lysthra, ji hà Masipho pha Thimothy beng pha bran jia um iang pha ithua hà luajong. Ai amuii ne migipho pha bran ro, chiih-è, Jewish è giak pha bran, iphuii ne Grekh pha bran ro. ");
INSERT INTO bgg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lysthra nane Ikhonium pha migipho ne Thimothi shii bajo wie chiong. ");
INSERT INTO bgg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phaul è Thimothi shii ai rog noh rui pha now ne ai è aishii miagiangkheg phi. Ai è ji rek phi phane, nyieliieshii, jithek hà rai pha Jewthek ne Thimothi iphuii ne Grekh rone thieg dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ithek jithek pha bajrai dong ne lua srane migipho shii Jerusalem shii guaphasamoy nane dukhothek è nung ne Iphey rab pha ji yao phi, chiih-è, ithek shii ji pha Iphey nuii ne rai pha yao marui. ");
INSERT INTO bgg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ji-è, charchthek ne migi now phane bajo gang rey dun, chiih-è, migipho de inai tham ne bajo rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ithek ne Phrygia nane Galathia pha ithuathek è lua ne rai dun, nyieliieshii, Ragung So è ithek shii Asia du-ùa pha mua ayao yi. ");
INSERT INTO bgg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ithek è Mysia pha sohthug thogmage shii, ithek è Bithynia du-ùa hà wuii dun pha saro shii, Isu ro Ragung è ithek shii awuii yi. ");
INSERT INTO bgg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ji-è, ithek ne ji nuii ne Mysia hà dong srane Throas hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ji pha habiu dang shii, Phaul è ibang jia bang ruii, Mesidonia pha bran jia è riu srane aishii khung ne yao ruii, “Mesidonia hà wuii srane gathek shii de nong rek phi bo!” ");
INSERT INTO bgg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Phaul è ji pha ibang nyabang ched dang shii Mesidonia hà wuii pha surui dun, nyieliieshii, gathek è nung jong ro, Hamangkhung-aphuii è gathek shii thiisa hà ji pha branthek shii de Mua Wie ji yao yi pha ho phro. ");
INSERT INTO bgg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Gathek ne Throas è run shii in ne Samothrase hà thog dang pha miang wuii dun. Chiih è, ji pha thimiang duiine Neapholis hà thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Thiisa è de gathek ne Philiphi pha soh khung ithua è Mesidonia pha rajan pha jila, hì ne Roman pho rai pha ithua hà wuii thog dun. Gathek ne thiichiih shii de inai bajo rai marui. ");
INSERT INTO bgg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jewish Thung pha Inai shii gathek ne ji pha rajan è fuang khia ne kho ring hà wuii dun, gathek è hì è now ne wuii dun, thiisa hà Jewthek khrab ne sia pha ithua um iwa. Gathek è dug srane thiichiih wuii pha hò-amuii phiing shii de mulo marui. ");
INSERT INTO bgg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Thiichiih shii hò-amuii jia nuii gieng phane Thyathira pha Lydia, yung chong rek pha hò-amuii ji ro. Ai ne Hamangkhung-aphuii shii sia ne rai pha hò-amuii ro, ji-è, Hamangkhung-aphuii è aishii hong phi ne Phaul è nyie yao ramuii pha ji wie nuii yi. ");
INSERT INTO bgg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ai nane ai haliing phothek khowo yie ched mage shii ai è gathek shii awai hò hà ho, “Nathek è gu shii de Ithong pha izai migi now pha bran è now arone, thawuii ne gu hò shii rai mage bo.” Chiih-è ai è gathek shii khung ne wuii yi. ");
INSERT INTO bgg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Inai jia shii gathek ne sia pha ithua shii wuii thog mage shii, gathek è ibuii ragung um ne phariang pha miyao yao pha khiao jia si ruii. Ai ne phariang pha miyao yao ne Ithongthek shii bang bajo wiang phi. ");
INSERT INTO bgg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ai de Phaul nane gathek rog shii luagieng ne ziak ne yao, “Hìthek pha bran ne bajo giu pha Hamangkhung-aphuii pha khiaothek ro! Ithek nathek shii nathek khi è rek ne ragia mua ruii pha ji yao ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ai è ji è rek ne rai phane inai bajo rey sha dun, Phaul è zo ne idoh riie srane ji pha ragung shii giung ne yao, “Isu Masi beng è na shii giung dang phro, ji pha bimi è na ne fuang khia mage bo!” Ji è giung dang pha ji shii ji pha ragung de fuang khia dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ji pha kheao è ji pha Ithong è ithek bang rab pha jo oi pha rey dun pha thieg mage shii, ithek è Phaul nane Silas shii zum srane branthek um pha ithua shii blu rek pho shii phi muii. ");
INSERT INTO bgg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ithek è Roman pha dumuii moe shii noh srane yao, “Hìthek pha bran ne Jewthek ro, ithek è gethek pha rajan shii diig rekramuii ro. ");
INSERT INTO bgg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ithek è Iphey yua pha ji ne gethek Iphey ji shii adunmey pha yua ramuii ro, gethek ne Roman pha branthek ro, ji è gethek ne ji pha Iphey ne ayie mua phro.” ");
INSERT INTO bgg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ji è rek mage ne bran brogthek de dog srane Phaul nane Silas shii mak rek gieng. Chiih è, ji pha dumuii è Phaul nane Silas ro yung ji srane zuang yi pha yung. ");
INSERT INTO bgg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bajo awie dang pha zuang ched ne isa shii phatheg bucho hà chab muii srane phatheg pha dumuii ji shii wie thiigang ne ruii bo ne yung ge. ");
INSERT INTO bgg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ji yung pha yoi mage ne ji pha phatheg pha dumuii è isa shii bucho dang pha phatheg hà chab srane isa lai ne hingbang boh nyi duchoi shii phang ne ruii muii. ");
INSERT INTO bgg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ji pha habiu duchoi shii Phaul nane Silas ne Hamangkhung-aphuii shii sia ne ibai bai ne rai, chiih-è phatheg phothek de isa ibai ji nuii ne rai ramuii shii, ");
INSERT INTO bgg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hamblo shii, thiichiih shii boh sajiid jia sham ruii ne phatheg pha sarongthek de zab sham dang dun. Ji è rek dang pha ji shii ji pha phatheg pha habinthek de awailum ne hong dun, ithek shii joi pha shiirnaithek de awailum ne sey ne chiih dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Phatheg pha dumuii ji de than ne sieng mage shii, phatheg pho pha habinthek ne hong ne um iang pha doh ruii, ai è now, phatheg pho ne zab yo dun ara! Ji-è ai ne awai khamriie phiang khia srane awaishii ua pha rek. ");
INSERT INTO bgg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Jishii Phaul è gang ziak ne yao mage, “Nawaishii diig aphi chid rabo! Gathek ne zab ichiih shii um ro!” ");
INSERT INTO bgg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Phatheg pha dumuii ji è bai chuang pha yung mage ne bucho hà ran srane Phaul nane Silas lai moe shii sham ne chiih ne khung phi. ");
INSERT INTO bgg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ji phado è ai è ithek shii fuang dun yi srane sai, “Masdothek wo! Gu de ragia rey pha nyie rek chid phlei?” ");
INSERT INTO bgg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ai è chang, “Ithong Isu shii migi now mage bo, ji-arone na nane nawai haliing pho de ragia rey ruii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ai è ai nane ai haliing phothek shii de Ithong pha miyaogam yua phi. ");
INSERT INTO bgg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ji pha habiu dang shii ji pha phatheg pha dumuii ji è isa shii noh ne isa saduii ji shud phi; ji è rek ched ne ai nane awai haliing phothek de khowo yie dang gieng. ");
INSERT INTO bgg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ji è rek ched ne ai è Phaul nane Silas shii awai hò hà noh srane michie phi ne chie yi. Ai nane ai haliing phothek ne bajo sang dun, nyieliieshii ithek de sudoh è Hamangkhung-aphuii shii migi now mua dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ji pha thimiang duiine è rey shii Roman pha blu rek pho è magashaig ophispho rog shii, “ithek shii thoh ge bo” è yao ne mua thoh ruii. ");
INSERT INTO bgg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ji-è, ji pha phatheg pha dumuii ji è Phaul shii yao, “Blu rek pho è nasa shii thoh ne dun yi pha mua thoh ro. Ji è nasa ne ichiih thoh ne liijiing rek ne dun shabo.” ");
INSERT INTO bgg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ji è yao phi magungde, Phaul è ji pha magashaig ophisphothek shii yao din, “Gathek shii nyie ichiig nane suruii adoh habuii shii ithek è gasa shii branthek moe shii zuang, chiih-è gasa de Roman pha bran habuii shii ithek è gasa shii phatheg hà fen muii. Ji-è, ithek ne gasa shii bran athieg yi pha ug ne thoh pha rek ara. Hì è rek phane arey phro! Roman pha ophispho awaithek ichiih wuii srane gasa shii thoh yi chid phro.” ");
INSERT INTO bgg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ji pha Magashaig ophisphothek è ji pha miyaogamthek yi Roman pha dumuii shii phosro din phi; ithek è Phaul nane Silas ne Roman pha bran rone yoi mage ne bajo rum dun. ");
INSERT INTO bgg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ji è ithek ne thiisa hà wuii srane isa shii khung ne isa shii phatheg è fuang khia ne ji pha rajan thoh ne dun pha yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Phaul nane Silas è ji pha phatheg è fuang khia ne Lydia pha hò hà dun dun. Thiichiih shii isa è migipho shii si srane boh noh yi pha miyaogamthek yao marui ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phaul nane Silas ne Amphipholis nane Apholonia è dong ne lua srane Jewthek misiahò jia um pha Thesalonikha hà wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Idang duiine Phaul è Jewthek misiahò hà wuii dun. Thiisa hà de Jewish Thung pha Inai uomchiieng rey srane branthek rog yao rai ne ");
INSERT INTO bgg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","jigigam ji pha miyao yao phi ne Masaiya ne diig rek chid phro, chiih-è, iy pha è de hòi din phro. Phaul è ithek shii ziak ne yao, “Gu è nyie yao pha Isu hì ne Masaiya ji yao.” ");
INSERT INTO bgg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ithek de Phaul miyao ji nuii ne Phaul nane Silas rog dog gieng; ji-è, ilkhi rek pha hò-amuiithek nane Grekh pha bajo ibrog hanyie è Hamangkhung-aphuii shii sia ne rai pho de ithek rog dog gieng. ");
INSERT INTO bgg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ji è rek magungde, Jewthek ne miegriie mage ne bran buiithek shii lumuii è khrab srane gidieg rek pha dog yi. Ithek ne zab rajan pho shii srobro ziak srane Jasan rone beng pha hò shii jo ne buii rek ne, Phaul nane Silas shii sow ne fuang hà branthek moe shii ri ne noh pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Jishii, ithek è Phaul nane Silas shii adoh phi, ji è ithek ne Jasan nane migi now pha gaithek shii zum ne ji pha rajan pha blu rek pho shii noh srane ziak ne yao, “Hìthek bran ne zab pha ithua shii diig phi muii ro! Chiih è, sudoh ichiih gethek rajan shii wuii thog ro, ");
INSERT INTO bgg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","chiih-è, Jasan è jithek pha bran shii awai hò shii rai yi ro. Ithek è Bisiu pha Ipheythek chui yi srane gai saja jia um rone yao muii ro, ji pha saja ne Isu beng rone yao ro.” ");
INSERT INTO bgg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ji pha miyaogamthek yao mage ne bran brog nane ji pha rajan shii blu rek pho ne bajo lijieg dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ji pha blu rek pho è Jasan nane gaithek shii awaithek shii thoh ne dun yi pha bang phi yi pha rek muii. ");
INSERT INTO bgg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ji pha habiu thog dang shii migiphothek è Phaul nane Silas shii Berea hà thoh ge. Ai è thiisa hà wuii thog srane Jewthek misiahò hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Thiisa pha branthek ne Thesalonikha è de bajo lubo hong pha branthek ara, ithek ne ji pha mua shii bajo wie nuii dun, chiih-è, inai tham ne jigigam de tham ne Phaul miyao ji izai bey ne riig ne rai gieng. ");
INSERT INTO bgg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bajo Grekh branthek è migi now gieng, chiih-è, bajo nuruii shak pha Grekh hò-amuii phiing nane hò-aphuiiphiingthek de migi now gieng. ");
INSERT INTO bgg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Jishii, Thesalonikha pha Jewthek è Phaul ne Berea hà de Hamangkhung-aphuii pha miyaogam yua ramuii è yoi mage ne ithek è thiisa de wuii srane branthek khrab srane mak rek noh. ");
INSERT INTO bgg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ji è rek mage ne migipho è Phaul shii khamuii ring hà riie ne dun ge; ji è dun ge magungde, Silas nane Thimothi ne Berea hà rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Branthek hanyie Phaul shii noh ne Athens thog dang pha wuii gieng pho shii Phaul è Berea hà thoh dinne mua jia yao yi ne Silas nane Thimothi de jog jog ai rog shii dog gieng bo. ");
INSERT INTO bgg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phaul è Athens hà Silas nane Thimothi shii khan ne rai ramuii shii, ji pha rajan shii bajo jangbang pha jangbang um pha ji doh mage ne Phaul ne bajo zo dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ji-è, ai ne Jewthek misiahò hà Jewthek nane Gaibranthek hanyie è Hamangkhung-aphuii shii sia ne rai pho rog yao ne rai, chiih-è, limiangthek pha ithua shii de bran hanyiethek è ji dong ne lua ruii pho shii de inai tham ne yao ne rai noh. ");
INSERT INTO bgg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ephikhurean nane Sthoikh pha masdothek de ai rog shii khnaing noh. Thiichiih um pha bran giak è de aishii sai, “Bi-iy hì nyie arey pha yao ne doh yi pha bidiang phlei?” Gaithek è de chang din, “Ai ne gai thiigpho pha hamangkhung-aphuii chiang yao ramuii pha duiine ro.” Ithek è ji yao phane nyieliieshii, Phaul è Isu nane Isu hòi pha miyao ji yao mage ne yao dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ji-è, ithek ne Phaul shii noh srane ji pha rajan pha limiang Areophagus moe shii noh thog srane yao, “Gathek de na muyua pha miyao wo ji nyie lai ne ìd pha now muii ro, ");
INSERT INTO bgg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","gethek è noh pha miyao giak ne khuchung de ayoi ba pha miyao yao pha yoi muii ro, ji pha miyao ne nyie yao phiiga, ji gathek de ìd pha yang muii ro.” ( ");
INSERT INTO bgg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Athens hà rai pha branthek nane gai thiig phothek um phothek ne awaithek ishakthek ne thiichiih phi ne miyao wo ji nuii ne rai pha rek yang dun.) ");
INSERT INTO bgg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Phaul è ji pha rajan pha limiang duchoi shii riu srane yao mage, “Gu è nathek Athenthek ne bajo giang rek pha doh muii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ji-è, gune nathek rajan hì shan ne lua srane ithek sia pha ithuathek riig mage shii, gu è nathek sia pha lubao jia shii hì è zey ne um iang pha doh ruii ro, “A-ìd pha jangbang shii nathek è hanyie shii sia pha ji ro.” Ji ne nathek è a-ìd magungde gu è nathek shii sudoh shii yua pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Hamangkhung-aphuii ne hanyie è sohjambling nane sohkhung shii um pha zab shii rab pha, hì ne Hamangkhung nane sohnyiak pha Ithong ro, ai ne wad miirab pha Misiahòthek shii ne arai phi phro. ");
INSERT INTO bgg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Chiih è, ai ne gethek blia rek pha ji ne ai è chid phane nyie de aphi mua phro, nyieliieshii, awai è sieng pha chai nane sieng pha misey phi ne hanyie shii nyie chid pha jithek phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ai è bran jia è zab branthek shii sohnyiak khungthek shii sieng ne rai yi pha rab phi. Awai è ibi shii ishak nane khi hà rai pha ithuathek ne khriig rab ne ruiijong ro. ");
INSERT INTO bgg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ai è jithek rek phane ithek è aishii riig din yi pha rek phi ro. Chiih è, ithek è aishii khi è now lei ne ji idoh yi pha rek phi ro. Jimagunde Hamangkhung-aphuii ne gethek è ruang asi ro; ");
INSERT INTO bgg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","giak è yao pha duiine ro, “Aishii gethek sieng ne, lua ne, zen phro.” Hì ne nathek pha sthun shii zey pha duiine ro, “Gethek de ai aniphiing ro.” ");
INSERT INTO bgg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Gethek de Hamangkhung-aphuii pha ani phiing habuii ne, gethek ne anoh chid rabo ai ne san liiman nane bran miirab pha lubao pha jangbangthek duiine ro. ");
INSERT INTO bgg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Branthek è Hamangkhung-aphuii shii adoh pha ishak ai è de branthek shii ariig phi, jishii ai è zab pha branthek shii awaithek buii rek pha lumuiithek è thado riie ne dun sha bo è yung ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ai è awai mugua ne ruii pha bran ji è ichiih sohjambling hì shii wie awie pho shii chua pha dashab rek ne ruiijong ro. “Ai è ji pha miyao ne zab pha bran è izai rone thieg yi phane ji pha bran shii hòi din yi jong ro!” ");
INSERT INTO bgg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Phaul è hòi din pha miyao yao pha ji nuii ne bran giak ne aishii siakjo, jishii, giak bran è yao, “Gathek ne na miyao ji dinne yao din phi pha now muii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ji-è, Phaul ne limiang jung pha ithua ji thoh ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Giak bran de ai rog dog ne migi now dun. Ithek ne Dionysius, limiang shii um pha sathiing jia; chiih-è, Damaris beng pha hò-amuii jia de, chiih-è Gaibranthek de dog gieng dun. ");
INSERT INTO bgg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ji pha idoh è Phaul ne Athens shii thoh marui ne Khorinth hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Thiisa hà ai ne Phonthus hà giak pha, Akhuila beng pha Jew bran jia si ruii. Ji pha bran ne doh ìujia pha ibi shii, awai yiy Phrisila rog shii Ithaly è dun thog pha bran ro. Ji è dun thog phane Khlaudius Bisiu è Jewthek shii Rom thoh ne dun bo ne è yung mage ne ji mudun thog ro. Phaul è ithek shii riig pha wuii dun, ");
INSERT INTO bgg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","chiih-è ithek rog shii rai ne bliathek rek gieng, nyieliieshii, ai de ithek duiine yung haliig rung srane awaithek chie pha pheg ne chie ne rai pha bran ro. ");
INSERT INTO bgg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Phaul ne Jewthek misiahò hà idang Jewish Thung pha Inai shii wuii srane yao ne rai, chiih-è, Jewthek nane Grekhthek shii ai miyao ji izai now yi pha rek ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas nane Thimothi de Mesidonia è dun thogmage shii Phaul ne awai ishak ne mua ji yao pha zab phi muii. Jewthek shii yao, Isu ne Masi ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ithek ji yoi ne aishii anuii pha rek ne awie pha yao mage ne, ai ne awai yung pha phlab ji sham srane yao, “Nathek sand dun arone, ji ne nawaithek shii the din bo! Ji rey pha gaja ne gu ashi phro. Sudoh è thiwing gune Gaibranthek shii wuii dun phro.” ");
INSERT INTO bgg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ji-è, ai ne ji pha ithua thoh marui ne hanyie è Hamangkhung-aphuii shii sia pha bran, Thaidius Justhus beng pha gai bran hò hà dun ne rai dun. Ai hò ne Jewthek misiahò pha khliie shii um. ");
INSERT INTO bgg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Khrisphus, hanyie yi Jewthek misiahò pha bohkhoh è de Ithong ji shii awai haliing pho è now dang ne migi now dun. Chiih-è Khorinth pha bran gaithek de ji pha mua yoi ne migi noh srane khowo yie gieng. ");
INSERT INTO bgg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Biu jia shii Phaul è ibang jia bang ruii, ji pha ibang shii Ithong è Phaul shii yao, “Arum chid rabo, agak pha athodang pha yao ne rai bo, ");
INSERT INTO bgg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nyieliieshii, gune na rog shii um gieng ro. Hanyie de na shii achun mua phro, nyieliieshii, ichiih pha rajan hà de gu branthek um iang ro.” ");
INSERT INTO bgg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ji-è, Phaul ne thiichiih pha ithua shii idam jia è khuyo thog dang pha Hamangkhung-aphuii miyaogam ji yao ne rai marui. ");
INSERT INTO bgg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio shii Akhaya pha Roman badri rab mage shii, Jewthek è ò dog srane Phaul shii zum ne che pha hò shii noh dun. ");
INSERT INTO bgg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ithek è yao, “Hì pha bran ne branthek shii nyu ne Hamangkhung-aphuii shii sia yi pha rek muii ro. Hì ne gethek Iphey shii adunmey pha miyao ro!” ");
INSERT INTO bgg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phaul è yao sha pha rek shii, Galio è Jewthek shii yao, “Hì ne suruii nane buii rek pha miyao arone gu è nathek miyao de boh noh ne nyarekphi phro, ");
INSERT INTO bgg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","jishii, hìthek ne miyaogamthek nane ibeng chiang è khnaing bie pha miyao arone chiih-è nawaithek Iphey bie arone, ji ne nawaithek chung ligiang rai bo. Gune hì è rek pha miyao che pho asi ro!” ");
INSERT INTO bgg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ji-è, ai ne ithek shii che pha hò è fuang gieng muii. ");
INSERT INTO bgg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ithek è Sosthenes, Jewthek misiahò pha chua ophis pho shii zum srane zuang, jishii Galio è nyie de arek. ");
INSERT INTO bgg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phaul ne migiphothek rog shii Khorinth hà inai bajo rai marui ne Phrisila nane Akhuila rog Syria hà riie ne in ne wuii dun. Ji hà wuii pha a-ìd ba pha ibi Khenchreae shii ai è ibi hà surua thak muii pha ji è khaziang khua muii. ");
INSERT INTO bgg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ithek ne Iphisus hà thog dun. Thiichiih Phaul è Phrisila nane Akhuila shii thoh marui ne ai ne Jewthek misiahò hà wuii dun srane Jewthek rog shii khnaing noh. ");
INSERT INTO bgg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Branthek è aishii bajo rai ba bo ne yao magungde ai ne ithua arai mua. ");
INSERT INTO bgg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ji phachiang ai ne branthek shii ji pha ithua athoh ba shii yao, “Hamangkhung-aphuii è wuii din yi arone gune nathek shii wuii din ruii phro.” Ji è yao marui ne ai ne Iphisus è de run shii in ne dun din dun. ");
INSERT INTO bgg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ai è Khaesarea thogmage shii, ai ne Jerusalem hà wuii srane charch pho shii salam yao marui, chiie-è Anthioch dun din dun. ");
INSERT INTO bgg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Thiichiih shii inai ìujia rai marui ne ji pha ithua thoh marui ne Galathia nane Phrygia pha ithuathek hà lua srane migipho shii bo lubo rek phi. ");
INSERT INTO bgg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ji pha ishak shii Alezendria hà giak pha Apholos beng pha Jew jia de Iphisus hà wuii thog ruii. Ai ne miyao bajo lie ne yao pha nane jigigam ji bajo thieg pha bran ro. ");
INSERT INTO bgg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aishii ne Ithong pha Lumuii dun pha ji yua jong pha ji è ai ne Isu chiang pha miyao ji ne bajo sang ne yao ne yua phi. Jimagunde ai ne Jon khowo yie pha ji thieg bie. ");
INSERT INTO bgg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ai ne Jewthek misiahò hà bajo gang rek ne yao. Phrisila nane Akhuila è ji yoi mage shii, aishii hò hà noh srane Hamangkhung-aphuii pha lumuii dunmey pha ji wie yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apholos è Akhaya wuii pha rek dun. Ji è Iphisus pha migipho è aishii nong ne aishii wie wuii yi pha jigigam jia zey ne thoh gieng. Ai è thiisa thog mage shii Hamangkhung-aphuii pha bushun è migipho shii bajo nong phi. ");
INSERT INTO bgg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jigigam shii zey ne um pha duiine Isu ne Masi rone gang khnaing mage ne Jewthek pha limiangthek moe shii ai yang dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apholos ne Khorinth hà ba shii, Phaul ne zab du-ùa dong ne lua srane Iphisus hà wuii thog dun. Thiisa hà ai è giak samoythek shii si ne ");
INSERT INTO bgg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ithek shii sai, “Nathek è migipho rey mage shii nathek de Ragung So mua jong bey?” Ithek è chang din, “Gathek ne Ragung So um rone de ayoi ba ro.” ");
INSERT INTO bgg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Phaul è ithek shii sai din, “Chiihphado, nathek ne khi-è rek pha khowo yie phlei?” Ithek è chang din, “Jon pha khowo yie phro.” ");
INSERT INTO bgg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phaul è yao din, “Jon pha khowo yie phane branthek shii layog è thadoh khid yi pha ro, jimagunde Israel pha branthek shii yao, ai idoh è wuiiramuii pha ji shii migi now bo, ji ne Isu ro.” ");
INSERT INTO bgg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ithek è ji yoi mage ne Ithong Isu beng è khowo yie. ");
INSERT INTO bgg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Phaul è awai wad ithek khrug shii khoh phi shii, Ragung So è ithek lakhung de ley dun, ji-è, ithek de khuchung de ayoi ba pha miyaogamthek yao ne Hamangkhung-aphuii pha mua de yao ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ji pha bran brog ne ithek snanyi pha bran brog ro. ");
INSERT INTO bgg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phaul ne Jewthek misiahò hà wuii srane branthek shii habie uom thog dang pha gang rek ne yao. Ithek rog shii athodang pha khnaing srane ithek de Hamangkhung-aphuii pha Sajathua pha ji shii izai now yi pha yao ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Jishii, giak branthek ne lawasdai rek ne ji izai anow pha rek srane bran brog moe shii Ithong pha Lumuii dun pha shii buii yao ne rai dun. Ji è rek mage ne Phaul è migipho shii awai rog noh srane ji pha ithua thoh ne dun dun. Miyao jung pha Thyranus hò hà dun srane inai tham ne ji pha miyao yao ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ji rek phane idam nyi rey dang pha rek ne rai dun. Ji-è, Asia du-ùa shii rai pho khinyama jia pha Jewthek nane Gaibranthek um pho de Ithong ji pha miyaogam yoi dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Hamangkhung-aphuii ne Phaul è khuchung de adoh dang ba pha buangthek pha bliathek rek ne rai dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ai kho pha yung thileg nane rinyie shii riing pha rathang rang de rad pho shii yie ne sud phi arone ithek miiriiethek ne zab pha khia dun, chiih-è, ibuii ragungthek de fuang khia dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ji è rek shii, thiichiih lua ne rai ne ibuii ragung khia pha giak Jewthek de Ithong Isu pha ibeng yao srane ibuii ragung shii khia pha rek riig. Ithek è ibuii ragungthek shii yung phro, “Gu è na shii, Phaul è yao pha Isu beng è fuang khia bo ne yung phro.” ");
INSERT INTO bgg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jewish pha boh phabi pha dufuii mile Skhewa hèg è jithek rek ne rai. ");
INSERT INTO bgg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Jishii, ibuii ragung è ithek shii yao din, “Gu de Isu shii thieg muii ro, chiih-è Phaul shii de thieg muii ro; jishii, nathek ne hanyie ga?” ");
INSERT INTO bgg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ibuii ragung um pha bran ji è ithek shii awie dang pha jo ne ji pha bran yang dun. Ithek ne ji pha hò è yo ne ran dun. Saduii de thoh, chiih-è, yungthek zab jithiak maphi. ");
INSERT INTO bgg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Iphisus hà rai pha Jewthek nane Gaibranthek è ji pha mua yoi mage shii bajo rum ne Ithong Isu pha ibeng shii bajo boh ilab phi. ");
INSERT INTO bgg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Migiphothek è de bajo wuii srane limiangthek moe shii awaithek nyie rek mua pha ji yao ne thieg yi. ");
INSERT INTO bgg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Jadu rek pho bajothek de awaithek jigithek yie srane zab bai shii ziao muii. Ithek è ji pha igong tham ne riig shii ji pha igong ne liiman shikhi itham saguii thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ji pha duiine Ithong pha miyaogam ne bajo blu um ne athodang pha zab pha ithua shii gang yoi thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ji è rey ched pha idoh shii Phaul è Mesidonia nane Akhaya è dong ne Jerusalem hà de wuii pha now. Ai è yao din, “Thiisa wuii thog ne de gune Rom de riig pha wuii chid phro.” ");
INSERT INTO bgg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ji-è, ai ne awai brapho nyi Thimothi nane Erasthus shii Mesidonia hà wuii ge, ji è thoh srane awai ne Asia du-ùa hà ishak bajo rai din marui. ");
INSERT INTO bgg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ji pha ishak shii Iphisus hà ne Ithong pha Lumuii chiang è bajo diig thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Liiman rab pha bran Demethrius beng pha bran jia ne misia hò pha jangbang Ardemis pha Ithong rab srane chong rek ne rai shii, ai chong ji ne blia rek pho shii bajo phua mua dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ji-è, ai è ji rab pho nane gaithek ji è rab phothek shii ò khrab ne ho srane yao, “Branthek wo, nawaithek de thieg iwa! Gathek bukho rey phane hì pha blia è rey ro. ");
INSERT INTO bgg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Jimagunde, thuh ichiih shii nawaithek de doh ne yoi iwa! Hì pha Phaul ne nyie rekramuii ga? Ai ne bran miirab pha hamangkhung-aphuii ne hamangkhung-aphuii asi rog è yao ne ai è Iphisus nane Asia pha zab du-ùa pha branthek nyiu ne ai miyao nuii dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hì è rey phane buii rey pha um ro, hì ne gethek chung pha ibeng ne ìu rey dun pha um ro. Ji duiine jia ashi pha yi sia pha jangbang Ardemis pha ibeng ne oi pha rey dun phro, airo boh ne ìu rey dun phro. Ji pha jangbang shii ne Asia shii rai pha zab branthek nane zab sohjambling shii rai pha branthek è sia ne rai.” ");
INSERT INTO bgg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Branthek è ji pha miyaogamthek yoi mage ne bajo lijieg ne ziak, “Ardemis ne Iphisus pha bajo boh ro!” ");
INSERT INTO bgg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ji pha mua ne ji pha rajan shii zab yoi thog dun. Mesidonia pha bran nyi, Gaius nane Aristharkhus Phaul rog luagieng pho shii zum ne bran ithua ugud hà noh dun. ");
INSERT INTO bgg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phaul awai de ji pha bran brog ibi shii wuii pha rek shii migipho è gak ne awuii yi. ");
INSERT INTO bgg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ai ro giak ijakthek ji pha ithua pha bukhothek pho è de aishii ji pha bran ithua ùgud shii awuii dang rabo ne mua khung ne thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ji pha maley ne bajo buii gui dun: nyieliieshii, giak branthek ne gai jia yao ne ziak, giak è yi gai yao ne ziak, nyieliieshii giak ne thiichiih shii limiang jung pha ji de agao pha wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Giak bran è ji rey pha gaja ne Alezendar rone è yao ne giak Jewishthek è aishii branthek pha ibi shii wuii yi. Ji è wuii thog mage ne ai è branthek shii Alezendar wad è hìog ne aro yi pha rek srane ai è haro rek ne yao pha saro. ");
INSERT INTO bgg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Jishii, thiichiih um pha branthek è ai de Jew rone thieg mage ne ishak nyi thog dang pha ziak ne rai, “Ardemis ne Iphisus pha bajo boh ro!” ");
INSERT INTO bgg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Idohhè shii thiichiih rajan pha boh jia è ji hòi pha ji ìu rek mua ge. Ai è yao, “Gu ijak Iphisithek wo! Zab branthek è thieg chak ro, Ardemis ne Iphisus pha boh nane hamangkhung è chiih pha lubao riie ruii pha misia hò chak ro. ");
INSERT INTO bgg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hanyie de hìthek pha miyao ne asnai mua phro. Ji-è, nathek de lijieg ne ro srane adunmey pha arek rabo. ");
INSERT INTO bgg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hì pha bran nyi è Misiahò pha nyie de agow, chiih-è, gethek pha hamangkhung-aphuii shii buii nyie de ayao ro. ");
INSERT INTO bgg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demethrius nane ai bliaphothek è hanyie shii magungde gidieg nin pha um arone, gethek shii ji che pha riichai um ro, chiih-è, ji chua pha idang inai hò um ro; thiisa hà ne ilkhi nya rek mua. ");
INSERT INTO bgg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Jishii, ji è bajo boh rek pha noh arone, zab dun mey pha limiang jung srane yao rai haga. ");
INSERT INTO bgg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Sudoh shii nyie rey pha buii hì ne gethek shii de bajo awie pha nin thog ruii phro. Hì pha srobrone nyi chiang de oi ro, chiih-è, ji è gethek ne wie chiang ayao mua phro.” ");
INSERT INTO bgg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ji è yao ched ne ai è ji pha limiang jung phane jong pha dun ge. ");
INSERT INTO bgg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Buii gui pha ji them ched ne Phaul è migipho shii ò khrab ne ho ne boh rek ne wad è phriie ne miyaogamthek yao marui. Ji è rek ched ne ai ne ji pha ithua thoh ne Mesidonia hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ai è zab pha ithua è dong ne lua srane branthek shii boh rek yi pha bajo muathek yao marui. Ji pha idoh è ai ne Akhaya hà wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Thiichiih shii ai ne habie uom rai marui. Ai ne Syria hà wuii sha pha saro ramuii shii ai è Jewthek è aishii diig phi pha nung ramuii rone thieg dun. Ji-è, ai ne Mesidonia è dong ne dun din pha phak. ");
INSERT INTO bgg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Berea hà rai pha Phyrhus pha dufuii Sophather de ai rog shii wuii gieng; ji duiine Thesalonikha hà rai pha Aristharkhus nane Sekhundus; Derbe è de Gaius; Asia pha du-ùa è de Thychikhus nane Throphimus; Thimothi de. ");
INSERT INTO bgg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ithek de Throas hà ibi wuii ne gathek shii khan ne rai iang. ");
INSERT INTO bgg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Gathek de Philiphi è sai ne phiia ajiie pha iweb chie ched ne in ne daguii shii ithek rog Throas shii dog gieng. Thiichiih shii gathek ne damiley rai marui. ");
INSERT INTO bgg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sonibari inai shii gathek ne michie chie pha ò khrab. Phaul è branthek shii habiu duchoi thog dang pha miyao yao ne rai gieng, nyieliieshii, ji pha thimiang duiine è rey mage shii ai ne ithek shii thoh ne dun sha pha rey ramuii. ");
INSERT INTO bgg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bajo muchuang ùgud pha lakhungthek hà hang ne maley dug ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ji è yao ramuii shii Euthykhus beng pha bran jia de haziingcho shii dug ne nuii gieng. Phaul è athodang pha yao ne rai mage ne Euthykhus ne miyem hùghùg ne rai. Idohhè shii ai ne men liak mage ne ji pha hò ùgud uom pha lakhung è nyiak thog dang pha chiih dun. Ithek è ran srane aishii chiing mage shii ai ne iyjong dun. ");
INSERT INTO bgg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ji è rek magungde, Phaul è thazam wuii srane aishii giak mage ne yao, “Arum chid rabo, ai ne a-iy ba ro!” ");
INSERT INTO bgg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ji è yao ched marui ne lakhung pha hògud hà dun din srane iweb phed ne chie. Ithek rog shii hanai chiu thog dang pha miyao yao marui ne Phaul è ji pha ithua thoh ne dun dun. ");
INSERT INTO bgg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ithek è ji pha filiao bran shii hòi din mage ne bajo sang dun. ");
INSERT INTO bgg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Gathek ne run è in ne Asos hà ibi wuii iang, thiisa è gathek ne Phaul shii de noh ne in yi ne wuii dun. Ai è gathek shii ibi yao ne ruiijong, nyieliieshii, ai ne soh è luaramuii pha ji è yao ne ruii. ");
INSERT INTO bgg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ai è gathek shii Asos hà si mage shii, gathek è aishii de noh srane Michiyoylene hà wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Gathek ne thiichiih è de run shii in ne ji pha thimiang duiine è rey shii, Chios wuii thog dun. Inai jia pha idoh è gathek ne Samos shii wuii thog dun. Ji pha idoh pha inai shii gathek ne Michiyous wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Phaul ne Iphisus dong ne in ne wuii pha now. Nyieliieshii, Asia du-ùa shii ishak ajong yi pha noh ne rek. Ai ne jog jog Jerusalem hà thog yi pha rek. Jog thog mua arone, inai Saguii shii sai pha idoh shii Jerusalem hà thog pha now ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Michiyous hà Phaul è Iphisus shii mua jia thoh ge, Charch pha dukhothek shii aishii si iang bo. ");
INSERT INTO bgg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ithek è ai moe shii wuiithogmage shii, ai è ithek shii yao, “Nawaithek de thieg iwa, gu è nathek rog shii khi-è rek ne ishak zab phi ne rai gieng pha ji, Asia du-ùa shii nyathog dang pha idoh è yie dang ne sudoh thog pha. ");
INSERT INTO bgg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Bajo jum rek ne bajo miegkho noi srane Ithong pha khiao duiine bliathek rek marui, ji pha doh ne bajo diig thog dun nyieliieshii, Jewthek è mak rek noh. ");
INSERT INTO bgg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nathek de thieg iwa! Gune nathek shii nong pha miyao ne branthek pha moe shii, chiih-è, hò hò shii ayao pha athoh marui ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jewthek shii de, Gaibranthek shii de gu è phriie ne yao marui, ithek ne awaithek pha layogthek è Hamangkhung-aphuii shii rai ne Ithong Isu shii migi now bo. ");
INSERT INTO bgg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Chiih-è sudoh de Ragung So pha miyao nuii ne Jerusalem hà wuiiramuii ro, thiisa hà nyie rey pha ji athieg pha wuiiramuii ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Gune rajanthek hà Ragung So è phatheg nane diig ne gu khan muii ro è phriie pha ji thieg bie ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Jishii, gune gui sieng pha chai ne boh anow; gune Ithong Isu è phi ne rek yi pha blia ji rek ched bi pha noh ro, ji pha blia ne Hamangkhung-aphuii pha bushun pha Mua Wie ji yao pha ji ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Gu ne nathek duchoi shii wuii ne Hamangkhung-aphuii pha zab riichai khoh pha mua yao jong ro. Ji-è, sudoh è thiwing ne nathek ne gu shii khuchung de adoh din sha phro. ");
INSERT INTO bgg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ji-è, gune sudoh nathek shii izai surua thak ne yao dang phro: Nathek duchoi shii hanyie magungde san dun arone, ji ne gu gaja asi phro. ");
INSERT INTO bgg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nyieliieshii, gu è Hamangkhung-aphuii pha miyao dun pha miyao ayao pha athoh marui ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ji-è, nawaithek shii riigbthan ne rai iang bo, chiih-è, Ragung So è boh marui pha shiishai brog shii de wie riig ne rai iang bo. Hamangkhung-aphuii pha charch pha brogpho rek ne rai bo, ji ne awai ro ro, Ai è awai dufuii khlem ne iy yi pha è rab ne ruii ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Gune thieg muii ro, gu dundun pha idoh è shii nyigodogthek ne nathek duchoi shii wuii srane ji pha shiishaithek ne achie yi phro. ");
INSERT INTO bgg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nawaithek duchoi è giak bran ne migiphothek shii khlam yao ne noh dun pha ishak thog ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ji-è, ji nowbthan ne rai bo, gune gu miegkhothek hanai habiu noi ne nathek shii idam uom yua ne rai noh jong ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ji-è gune nathek shii Hamangkhung-aphuii pha wad nane bushun pha mua shii boh marui ro, ji-arone, nathek shii de gang sieng pha rab phro, chiih-è, Hamangkhung-aphuii è awai branthek shii phi pha khirzey ji phi ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Gune hanyiethek pha san liiman nane yungthek achid ro. ");
INSERT INTO bgg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nawaithek è de thieg iwa! Gune gui wad è bliathek rek ne gui branphiingthek nane gui chid pha manathek phi phro. ");
INSERT INTO bgg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Gu è bajo diig bliathek rek ne nathek de ziapho shii hì è rek ne nong bo ne doh yi, Ithong Isu awai miyao marui pha miyaogamthek ji nowkhlei bo, ‘Ji ne yie pha ji è de phi pha ji bajo lubo um ba ro.’” ");
INSERT INTO bgg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Phaul è ji yao ched dang shii ai è ithek rog shii bam ne sia marui. ");
INSERT INTO bgg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ithek è bajo choh ne aishii giak srane ai mizia shii khichiug ne wie dun ge. ");
INSERT INTO bgg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ithek ne bajo zo dun, nyieliieshii, ai è yao marui: ithek ne aishii khuchung de adoh din sha. Ji-è, ithek de ai rog shii run um pha ithua thog pha wuii gieng. ");
INSERT INTO bgg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Gathek è ithek shii salam yao marui ne ji pha ithua thoh ne wuii dun. Thiisa è gathek ne miang in ne Khos hà wuii thog dun; ji pha thimiang duiine è rey mage shii gathek ne Rhodes hà thog dun. Thiisa è de gathek ne Phathara hà wuii din dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Thiichiih shii gathek è Phoenikha ran pha run jia doh, ji è gathek ne thiichiih in ne wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Gathek ne Khyphrus doh muii pha ithua hà thog dun. Ji-è, gathek ne dinne hayang hà riie ne Syria hà wuii din dun. Gathek ne run pha manathek khiang sha pha Thyre pha khamuii ring shii wuii thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Thiichiih shii de gathek è migi now pha bran si ne ithek rog shii damiley thog pha rai marui. Thiichiih shii Ragung pha blu è Phaul shii Jerusalem awuii rabo ne yao ruii. ");
INSERT INTO bgg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Jishii, gathek thiichiih rai pha ishak jong sha pha rai mage ne gathek è ithek shii thoh marui ne guithek lumuii hà wuii dun. Ithek de awaithek yiy nane aniphiing de noh ne gathek rog shii khamuii ring thog dang pha wuii gieng. Gathek è bam ne sia marui. ");
INSERT INTO bgg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ji-è sia ched ne gathek è ithek shii salam yao marui ne gathek de run bucho shii in dun, ithek de awaithek hò hà dun din dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Gathek ne athodang pha guithek kho lumuii Thyre è Phtholemais wuii thog dun. Thiichiih shii de gathek è migipho shii khung rai ne ithek rog shii inai jia rai marui. ");
INSERT INTO bgg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ji phado è gathek ne ji pha ithua de thoh dinne wuii srane Khaesarea hà wuii thog dun. Thiichiih shii gathek è Gachem Philiph pha hò shii rai marui. Ai ne Jerusalem shii brapho miley gua ne ruii pha è jia ro. ");
INSERT INTO bgg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Aishii gey adun ba pha dimi wi Hamangkhung-aphuii pha mua yao ne rai pha um iang. ");
INSERT INTO bgg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Gathek ne thiichiih shii inai bajo rai ramuii shii Agubus beng pha chaigphuii jia de Judea è wuii thog ruii. ");
INSERT INTO bgg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ai ne gathek moe shii wuii srane Phaul rathang yie ne awai lai nane wad shii phang srane yao, “Hì ne Ragung So è khi è yao pha ji ro: Rathang hì pha muspho shii ne Jerusalem hà Jewthek è hì duiine phang ne Gaibranthek shii phi muii phro.” ");
INSERT INTO bgg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Gathek è ji è yao pha yoi mage ne gethek nane gaithek è Phaul shii Jerusalem hà awuii yi pha khung ne yao. ");
INSERT INTO bgg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ji è yao magungde, Phaul è ithek shii yao, “Nathek ne nyie rek phlei? Hì è rek ne choh phane gu lubu chuimuii ne bey? Gune Jerusalem hà phang pha jia asi pha yi Ithong Isu chiang è iy pha de nya rek mua phro.” ");
INSERT INTO bgg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Gathek è aishii anyiu mua, ji-è, gathek ne agak pha sang yao din, “Yang ne hì ne Ithong pha munow ji rey yi bo.” ");
INSERT INTO bgg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Gathek è thiichiih shii ishak ìujia rai marui ne Jerusalem hà wuii pha saro. ");
INSERT INTO bgg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Khaesarea pha giak samoythek de gathek rog wuii gieng. Ithek è gathek shii khyphrus pha Manasan, bajo inai ibi è migi now pha bran rey pha hò shii rai pha noh dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Gathek è Jerusalem wuiithogmage shii, migipho è gathek shii lua wieho ne wuii yi. ");
INSERT INTO bgg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ji pha thimiang duiine Phaul ne Jems shii si pha wuii dun; thiisa hà charch pha zab dukhothek de um iang. ");
INSERT INTO bgg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phaul è ithek shii salam yao, Phaul è ithek shii Hamangkhung-aphuii è Gaibranthek shii ai blia è nyiethek rek pha ji zab phosro phi. ");
INSERT INTO bgg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ji yao pha nuii ne ithek è Hamangkhung-aphuii shii chiong phi. Ji phado è Phaul shii de yao, “Gathek pha khuii Phaul wo! Nawai de riig muii ro, itham pha Jewthek ne migipho rey ne Iphey shii khinyama jam now dun ro. ");
INSERT INTO bgg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Jimagunde ithek è gathek shii, na è Gaibranthek sohthek hà rai pha Jewthek shii Moses pha Iphey duiine awaithek aniphiing migiangkheg chid pha nane mizenthek anuii chid rabo è yua phrone yao ramuii ro. ");
INSERT INTO bgg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ithek ne na wuiiramuii rone izai thiegjong ro, gethek ne nyie khi è rek sha pha lei? ");
INSERT INTO bgg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Na ne gathek noh pha ji rek bo. Thiichiih shii bran wi è surua thak ne um ro. ");
INSERT INTO bgg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Na ne ithek rog shii wuii gieng srane ithek shii muhui hui yi pha è nung phi mage bo, ji-arone, ithek ne awaithek khaziang nyakhua mua phro. Ji è rek arone, zab na chiang yao pha jithek ne izai asi rone nya thieg ruii phro, chiih-è, nawai de Moses pha Iphey shii zen pha ji rek ne rai pha doh ruii phro. ");
INSERT INTO bgg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Jishii, Gaibranthek hanyie è migi now jong pho ne gethek è jigigam zey ne thoh pha nung rai jong ro: ithek ne jangbang shii zud pha nyie de achie dang rabo; ifai nane yua rib ne ua pha ibey achie rabo; chiih-è, ithek ne siulao pha biwo è ruang rai bo.” ");
INSERT INTO bgg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ji-è, Phaul è ji pha thimiang duiine è rey mage shii, ji pha bran wi shii noh ne ithek shii muhui hui ne rek phi. Ji è rek ched marui ne ai ne Misiahò hà wuii srane ji pha muhui hui ched pha inai khinyama chia pha um lei ne ji yao pha siog phi wuii. Idohhè pha inai shii ne ithek wi chiang è khlem ne zud phi chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ji è rek ne rai magungde, inai damiley jong sha pha rai ramuii shii, Asia pha du-ùa è wuii thog pha giak Jewthek è Phaul ne Misiahò hà um iang pha doh ruii. Ji-è, ithek è branthek shii khrab ne lijieg yi ne Phaul shii zum dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ithek è ziak ne yao, “Israel pha bran de wo! Nong phi bo! Hì pha bran ne khi khi hà wuii magungde Israel pha branthek shii gidieg yua muii ro, chiih-è, Moses mizen marui pha Iphey nane hì pha Misiahò shii jia rek ne yua ramuii ro. Thuh shii de ai è Gaibranthek noh ne Misiahò hì shii ithua so shii zea rekramuii ro!” ( ");
INSERT INTO bgg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ithek è ji è yao phane, nyieliieshii, ithek è Iphisus pha Throphimus de Phaul rog shii ji pha rajan shii um gieng. Aishii ne Misiahò shii Phaul miinoh ne wuii gieng ara è now ne yao dun.) ");
INSERT INTO bgg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ji pha anomuluii pha miyao è ji pha rajan pha zab ithua shii yoi ne branthek ne ran srane Phaul shii zum srane ji pha Misiahò è fuang khia maphi. Ji è rek dang mage ne ji pha Misiahò pha habin de kheb dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ji pha bran brogthek è Phaul shii ua mua pha rek, jimagunde, Jerusalem shii bajo buii rey ramuii rone ji pha phosrone Roman arming yungpho shii thoh ge. ");
INSERT INTO bgg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ji nya yoi dang shii, ji pha yungpho è awai ophisphothek nane siphahithek noh ne ji pha bran brog um pha ithua shii wuii thog ruii. Branthek è ai nane ai siphahithek shii doh mage ne Phaul shii azuang din pha ruii muii. ");
INSERT INTO bgg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ji pha yungpho è Phaul moe shii wuii srane Phaul shii zum, chiih-è Phaul shii shiirnai nyi è joi pha yung. Ji è rek ched ne ai è sai, “Hì ne hanyie ga? Chiih-è ai è nyie rek muii ga?” ");
INSERT INTO bgg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ji pha bran giak è gai yao ne ziak, giak è gai yao ne ziak. Thiichiih shii wieng phleg pha miyao yao dun ne yungpho ji ne nyie rey dun pha isiie athieg mua phi, ji-è, ai è branthek shii yung ne Phaul shii siphahithek rai pha hò hà noh yi. ");
INSERT INTO bgg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ithek de Phaul rog ukhno thog pha wuii gieng, chiih-è siphahithek è Phaul shii chaing ne noh chid pha rey dun, nyieliieshii, bran brogthek ne bajo buii rey dun. ");
INSERT INTO bgg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ithek ne ai idoh shii wuii gieng srane aishii ua muii pha ziak ne yao, “Aishii ne ua muii bo!” ");
INSERT INTO bgg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Siphahithek è Phaul shii arming rai pha hò shii noh sha pha saro shii, Phaul è yungpho ji shii yao: “Gune na shii miyao jia nya yao mua nebey?” Ji pha yungpho è sai, “Na de Grekh nya yao mua nebey? ");
INSERT INTO bgg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Na ne Egyph pha bran asi bey? Buyo shii hanyiethek srobro shii buii mak rek pho rab ne itham wi shii jabiing hà noh dunpha bran ji asi bey?” ");
INSERT INTO bgg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Phaul è chang, “Gune Jew ro, gune Tharsus hà Khilisia shii giak pha Jew ro, gune bajo boh pha rajan shii rai pha bran ro. Gu shii de branthek shii yao yi pha phi bo.” ");
INSERT INTO bgg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ji-è ji pha yungpho è Phaul shii yao pha ishak phi, ji è, Phaul ne datham shii riu srane branthek shii aro yi pha wad è kho ne yao. Ithek è aro sha pha rey mage shii Phaul è ithek shii Hebriu pha miyaogam è yao phi: ");
INSERT INTO bgg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Gu ijak Jewthek wo! Gu è nathek moe shii gui chiang haro yao pha ji nuii mage bo!” ");
INSERT INTO bgg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ithek è ai ne Hebriu è yao ruii pha ji yoi mage ne bajo arodang pha rai dun, jiè Phaul ne wiwi yao lumao dun: ");
INSERT INTO bgg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Gune Jew ro, gune Tharsus hà Khilisia pha ithua shii giak pha bran ro, jimagunde, gune ichiih Jerusalem hà Gamaliel pha jigigampho rek ne sieng pha bran ro. Gu de gethek riing mizen marui pha bajo giang pha Iphey ji pha muyua mua jong ne sudoh ichiih um pha nathek duiine Hamangkhung-aphuii shii phi jong ro. ");
INSERT INTO bgg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Gu de bran hanyie è hì pha lumuii shii lua pha branthek shii iy dang pha diig cheo phi jong ro. Gu è hò-aphuii, hò-amuiithek shii zum ne phatheg chab jong muii ro. ");
INSERT INTO bgg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hì pha miyao ne Kho Phabi nane Limiangthek è gu miyao ramuii hì izai chak rone nyayao ruii phro. Gu è Damaskhus pha Jew ijakthek shii zey pha jigigam mua dun pha ji è gune thiisa hà ithek shii zum ne shiirnai è zoi ne Jerusalem noh srane diigkhui pha wuii dun. ");
INSERT INTO bgg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Gune Damaskhus pha moe wuii thog ramuii shii, hanai duchoi pha ishak liing shii gu moe shii hamangkhung è hamblo shii haliao jia bliak thogruii. ");
INSERT INTO bgg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Gune nyiak shii thud dun shii, goh è gu shii yao pha miyaogam jia yoi ruii, ‘Saul, Saul! Na ne nyie rek ne gu shii diig phi phlei?’ ");
INSERT INTO bgg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Gu è sai din, ‘Ithong na ne hanyie ga?’ Ai è yao din, ‘Gune Nazareth pha Isu ro, na è hanyie shii diig phi pha ji ro.’ ");
INSERT INTO bgg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Gu rog shii um pha branthek de ji pha haliao bliak pha ji ne doh gieng shii hanyie è gu shii yao pha miyaogam ji ne ayoi gieng. ");
INSERT INTO bgg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Gu è sai din, ‘Ithong wo, ji-arone, gune nyie rek chid pha um lei?’ Ji pha Ithong è gu shii yao din, ‘Sieng ne Damaskhus hà wuii mage bo, thiisa hà na shii Hamangkhung-aphuii è nyie rek bo ne boh ne ruii pha ji zab yao phi phro.’ ");
INSERT INTO bgg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Haliao bliak pha ji è gune Miegthi pha rey dun. Ji-è gu rog wuii gieng phothek è gu shii wad chaing ne Damaskhus hà wuii thog yi. ");
INSERT INTO bgg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ji pha rajan shii Ananias beng pha bran jia ne giang rek ne Iphey ji nuii ne thiichiih rai pha Jewish è bajo ilab phi pha jia um iang. ");
INSERT INTO bgg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ai è gu shii wuii srane gu moe shii riu ne yao, ‘Gu ai khuiino Saul, dinne mieg doh din bo!’ Ji è yao dang pha ji shii gu mieg ne doh din ruii ne gu è aishii riig. ");
INSERT INTO bgg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ai è yao, ‘Gethek riing pha Hamangkhung-aphuii è na shii ai munow ji thieg bo ne gua jong ro, airo giang khiao ji thieg yi pha, chiih-è, aiwairo miyaogam ji yoi yi pha gua ne ruiijong ro. ");
INSERT INTO bgg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ji-è, na de branthek shii ai chiang è nyie doh ne yoi pha ji yao chid phro. ");
INSERT INTO bgg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ji-è, nane ichiih shii nyie rek ne chia ne khan phlei? Sieng ne khowo yie mage srane nawai layog ji sud yi pha aishii sia mage bo.’ ");
INSERT INTO bgg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Gune Jerusalem dun dinne Misiahò shii sia ramuii shii, gu è ibang jia bang ruii, ");
INSERT INTO bgg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ji pha ibang shii gu è Ithong shii doh ne ji pha Ithong è gu shii yao ramuii pha bang ruii, ‘Jog rek ne Jerusalem thoh ne dun dun bo, nyieliieshii, ichiih pha branthek ne na è gu chiang è nyie yao pha ji ne anuii phi phro.’ ");
INSERT INTO bgg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Gu è chang, ‘Ithong, ithek ne bajo wie thieg iwa, gune Jewthek misiahò hà wuii srane hanyiethek na shii migipho shii zum ne zuang pha bran ro. ");
INSERT INTO bgg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Chiih è, na khagi Sthephen uaphothek pha idoh shii de gu de thiichiih um ne aishii ua bo è yao ne gu è de ua pho pha yungthek shii khagi rek gieng.’ ");
INSERT INTO bgg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ithong è gu shii yao, ‘Gune na shii ruang hà gai Gaibranthek shii wuii ge phro.’” ");
INSERT INTO bgg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Branthek ne Phaul è ji yao ched dang pha nuii ne rai dun; jimagunde, ji yao ched mage ne ji pha branthek ne bajo gang rek ne ziak ne yao, “Aishii noh srane ua muii bo! Ai ne sieng ne rai phane adunmey pha um ro!” ");
INSERT INTO bgg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ithek ne awaithek yungthek fi srane nyiak phlab hum srane hasam shii fen ne ziak ne yao. ");
INSERT INTO bgg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Roman pha yungpho è awai branthek yung ne Phaul shii arming rai pha hò hà noh yi srane nyie rek ne Jewthek è aishii gidieg rek ne ziak pha ji thieg yi pha zuang pha yung. ");
INSERT INTO bgg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Zuang pha ji joi ched magungde, Phaul è thiichiih riu pha ophispho shii sai, “Hì è rek ne Roman pha bran, hanyie è nyie suruii arek pha shii zuang pha ji Iphey shii dun mey bey!” ");
INSERT INTO bgg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ji pha ophispho è ji yoi mage ne ai ne Roman pha yungpho shii wuii dun srane yao, “Nane nyie rekramuii ga? Ai de Roman pha bran ro!” ");
INSERT INTO bgg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ji-è, ji pha yungpho boh è Phaul shii wuii srane sai, “Gu shii yao mage bo, na de Roman pha bran bey?” Phaul è chang, “Ji chak ro.” ");
INSERT INTO bgg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ji pha yungpho boh è yao, “Gune Roman pha bran rey yi phane bajo bang phi ne rey ro.” Jimagunde, Phaul è yao, “Gune giak dang pha ji è Roman pha bran ro.” ");
INSERT INTO bgg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ji è yao dang pha ji shii, Phaul shii miyao sai pha noh pha branthek ne idoh dun din dun; chiih-è ji pha yungpho boh de Phaul ne Roman pha bran rone thieg mage ne Phaul shii shiirnai è joi pha ji bajo rum din dun. ");
INSERT INTO bgg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Jewthek ne nyie chiang è Phaul shii buii nin pha ji thieg yi pha ji pha yungpho boh è ji pha thimiang duiine è rey mage shii, shiirnai sey srane noh dun, phabi khothek nane limiangthek shii maley dug yi pha yung. Ji è rek srane ai è Phaul shii ithek ibi shii riu ba yi. ");
INSERT INTO bgg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phaul è limiangthek shii wie riig srane yao, “Gu ijak Israelpho wo! Gune sudoh thog dang pha Hamangkhung-aphuii shii so now ne rai.” ");
INSERT INTO bgg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananias beng pha Kho Phabi jia è Phaul moe shii riu pho shii Phaul sem shii phey yi pha yung. ");
INSERT INTO bgg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Phaul è yao din, “Lakhung chuang pho nathek shii de Hamangkhung-aphuii è chua din ruii phro! Nathek ne Iphey shii zen pha duiine gu shii nin pha thiichiih shii dug ramuii ro, jimagunde, nathek ne gu shii phey yi pha yung ramuii ne Iphey zen pha ji chui muii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Phaul moe shii dug pha bran jia è yao, “Na ne Hamangkhung-aphuii pha Kho Phabi shii biwo yao ramuii ro!” ");
INSERT INTO bgg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Phaul è chang din, “Gu ijak Israel pho wo! Ai ne boh phabi rone gune athieg ro. Jigigam shii ne hì è zey ne um ro, ‘Nathek ne bohkhoh pho shii buii ayao rabo.’” ");
INSERT INTO bgg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Phaul è Sadusithek pha ibrog jia nane Pharisithek pha ibrogthek um iang pha doh mage ne ithek shii limiangthek moe shii ho ne wuii yi ne yao, “Gu ijak Israelthek wo! Gu de Pharisis ro, gu de Pharisis pha dufuii ro. Sudoh gune ichiih shii chua phane iy ne hòi din pha miyao shii luthong pha chiang è rey dun ro!” ");
INSERT INTO bgg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ai è ji nya yao dang mage shii, Pharisithek nane Sadusithek ne awaithek chung gui rai ne yoh yoh che dun. ( ");
INSERT INTO bgg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nyieliieshii, Sadusithek è yao, iyphothek ne khuchung de ahoì din phro, chiih-è hamangkhliiethek nane Ragung ne oi ro; jishii Pharisithek ne ji ne um rone migi now ne rai.) ");
INSERT INTO bgg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Thiichiih ziak ne yua pha ne bajo bajo boh rey ruii, Pharisithek rog dog pho giak Iphey yua pha masdothek è riu srane gang ziak ne yao: “Gathek ne hì pha bran shii nyie chun pha lumuii adoh phi ro! Aishii ne hamangkhliie nane Ragung è izai yao chak ro!” ");
INSERT INTO bgg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ji pha khnaing pha ne bajo boh boh hòi mage ne Phaul shii noh pha yungpho ne yang ne Phaul shii branthek è ua ne dum dum rek mua phade um è now ne bajo rum dun. Ji è ji pha dumuii è awai siphahithek shii wuii ne Phaul shii branthek pha duchoi è arming rai pha hò idoh noh din pha yung. ");
INSERT INTO bgg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ji pha habiu shii Ithong è Phaul moe shii riu srane yao, “Nane arum ched rabo! Na ne ichiih Jerusalem shii gu chiang è yao jong phi ro, hì duiine Rom hà de yao mage bo.” ");
INSERT INTO bgg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ji pha thimiang riang duiine è rey mage shii Jewthek è ò wuii si srane nung rai. Ithek è thiichiih shii surua thak rai, Phaul shii a-ua shapho ne ithek ne nyie de achie aniing dang phro. ");
INSERT INTO bgg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ji pha munung nung rai phothek ne bran sawi huak pha um. ");
INSERT INTO bgg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ithek è boh phabi nane dukhothek shii wuii srane yao, “Gathek è surua thak jong ro, gathek ne Phaul shii a-ua shapho shii ne nyie de achie dang bi phro. ");
INSERT INTO bgg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ji-è, na nane limiangthek ne Roman yungpho shii Phaul shii miyaogam sai ba pha um rone khlam ne thazam thoh ge pha yung bo. Ji è rek shii gathek ne ai ichiih athog ba shii ua mua pha saro iang phro.” ");
INSERT INTO bgg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ji è yao pha ji ne Phaul ro bumuii pha dufuii ji è yoi mage ne phatheg hà Phaul shii wuii ne yao phi. ");
INSERT INTO bgg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ji nuii ne Phaul è thiichiih um pha arming rai pha hò pha ophispho ho srane yao, “Hì pha bufuiiduii shii boh yungpho shii noh ne wuii mage bo; ai ne dumuiiboh è siphahi pha kho shii miyao jia yao pha um ro.” ");
INSERT INTO bgg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Arming rai pha hò ophispho ji è aishii noh ne wuii srane yungpho shii yao, “Phaul è gu shii ho ne hì pha bufuiiduii shii na moe shii noh ne wuii mage bo è yao dun ro, nyieliieshii, ai ne na shii miyao jia yao pha um ro.” ");
INSERT INTO bgg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ji pha yungpho è aishii wad è chaing srane dug yi srane sai, “Na ne gu shii nyie yao pha um ga?” ");
INSERT INTO bgg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ai è yao, “Jew pha riichaithek ne thimiang ne na shii Phaul shii bsa hà limiangthek moe shii noh dinne miyao sai ne wie thieg yi pha rone è khlam ne lia pha nung jong ro. ");
INSERT INTO bgg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Jishii na ne ithek miyao anuii rabo, nyieliieshii, ithek ne sawi è de huak dang pha branthek ug ne Phaul shii khan ne rai iang phro. Ithek ne Phaul shii a-ua shapho shii ne nyie de achie aniing dang phro è yao ne surua thak jong ro. Ithek ji rek pha surui jong ro chiih-è naro muphak ji khan ramuii ro.” ");
INSERT INTO bgg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ji pha yungpho è aishii yao, “Na è hì pha mua gu shii phosro jong rone hanyie shii de ayao dang rabo,” È yao ne aishii thoh ne dun ge. ");
INSERT INTO bgg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ji pha idoh è ji pha yungpho è ophispho nyi shii ho ne yao, “Khaesarea wuii pha siphahi wieng nyi, sthuh pho samiley nane jiong han pho wieng nyi khrab srane sudoh biu pha dige ishak dang shii wuii pha saro bo. ");
INSERT INTO bgg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Phaul shii sthuh phi ne in yi srane Felikhs Badri shii wie wuii thog yi bo.” ");
INSERT INTO bgg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ji è yao ched ne ji pha yungpho è jigigam jia zey ne thoh ge: ");
INSERT INTO bgg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Khlaudius Lysias è bajo thieg pha badri Felikhs shii wie khung bi. ");
INSERT INTO bgg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jewthek è hì pha bran shii zum ne ua pha rekramuii shii, ai ne Roman pha bran rone thieg mage ne gu è siphahithek rog shii wuii srane aishii ragia rek phi ro. ");
INSERT INTO bgg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Gune ithek è aishii nyie chiang è layog nin pha ji thieg yi pha aishii limiang moe shii noh ne sai riig shii de ");
INSERT INTO bgg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Gune, aishii, ai iy yi pha nane phatheg chab chid pha blia rek pha adoh phi ro. Aishii nin phane awaithek Iphey zen pha ji è sai ne rek pha miyao bie ro. ");
INSERT INTO bgg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Aishii mak pha khinrin um rone mua yoi mage ne gu è aishii na shii wuii ge pha phak ne wuii ge ro. Gu è aishii ninphothek shii yao jong ro, miyao nin pha ji ne na moe shii che phi phro.” ");
INSERT INTO bgg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Siphahithek è jithek pha muyung rek ne wuii dun. Ithek è Phaul shii ji pha habiu dang shii khinyama ruang noh mua pha noh ne Anthiphathris hà thog dun. ");
INSERT INTO bgg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ji pha thimiang duiine rey mage shii lai lua pha siphahithek è sthuh pho shii Phaul rog wuii ge ne awaithek ne awaithek rai pha ithua hà idoh khid din dun. ");
INSERT INTO bgg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ithek Phaul shii Khaesarea hà noh thog srane jigigam ji badri shii phi srane Phaul de ai wad shii boh ne thoh marui. ");
INSERT INTO bgg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34",