﻿USE sofia;
DROP TABLE IF EXISTS sofia.bgc_vpl;
CREATE TABLE bgc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bgc_vpl WRITE;
INSERT INTO bgc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ये यीशु मसीह के पूर्वजां के नाम सै। वो राजा दाऊद का वंशज था, अर राजा दाऊद अब्राहम का वंशज था। ");
INSERT INTO bgc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहम का बेट्टा इसहाक था, अर इसहाक का बेट्टा याकूब था, फेर याकूब तै यहूदा अर उसके भाईयाँ का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा के बेट्टे फिरिस अर जोरह थे। (फिरिस अर जोरह की माँ का नाम तामार था।) फिरिस का बेट्टा हिस्रोन था। हिस्रोन का बेट्टा एराम था, ");
INSERT INTO bgc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","एराम का बेट्टा अम्मीनादाब था। अम्मीनादाब तै नहशोन, अर नहशोन तै सलमोन का जन्म होया, ");
INSERT INTO bgc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन का बेट्टा बोआज था। (बोआज की माँ का नाम राहाब था।) बोआज अर रुत तै ओबेद का जन्म होया, अर ओबेद का बेट्टा यिशै था। ");
INSERT INTO bgc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","अर यिशै का बेट्टा राजा दाऊद था। (राजा सुलैमान दाऊद का बेट्टा था।) जो उस बिरबान्नी तै जन्मा था जो पैहले उरिय्याह की घरआळी थी, ");
INSERT INTO bgc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलैमान का बेट्टा रहबाम था। अर रहबाम का बेट्टा अबिय्याह था। अर अबिय्याह तै आसा का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसा का बेट्टा यहोशाफात था। फेर यहोशाफात तै योराम अर योराम तै उज्जियाह का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्जियाह का बेट्टा योताम था अर योताम, आहाज का। फेर आहाज तै हिजकिय्याह का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकिय्याह तै मनश्शिह का जन्म होया। मनश्शिह का बेट्टा आमोन था, अर आमोन तै योशिय्याह का जन्म होया।। ");
INSERT INTO bgc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","फेर इस्राएल के माणसां नै कैदी बणाकै बेबीलोन देश ले जाण के बखत योशिय्याह तै यकुन्याह, अर उसके भाईयाँ का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबीलोन देश म्ह पोहचाये जाये पाच्छै यकुन्याह तै शालतियेल का जन्म होया, फेर शालतियेल तै जरुब्बाबिल का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरुब्बाबिल तै अबीहूद का जन्म होया, अबीहूद तै एलयाकीम का अर एलयाकीम तै अजोर का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर का बेट्टा सदोक था। सदोक तै अखीम अर अखीम तै इलीहूद का जन्म होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","इलीहूद का बेट्टा इलियाजार था। अर इलियाजार मत्तान का। मत्तान का बेट्टा याकूब था। ");
INSERT INTO bgc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","अर याकूब तै यूसुफ का जन्म होया, जो मरियम का धणी था। अर मरियम तै यीशु जो मसीह कुह्वावै सै, पैदा होया। ");
INSERT INTO bgc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","इस तरियां अब्राहम तै दाऊद तक चौदहा पीढ़ी होई, अर दाऊद तै लेकै इस्राएलियाँ नै कैदी बणाकै बेबीलोन देश भेज्जे जाण तक चौदहा पीढ़ी, अर इस्राएलियाँ कैदी बणाकै बेबीलोन देश म्ह भेज्जे जाण कै बखत तै मसीह तक चौदहा पीढ़ी और होई। ");
INSERT INTO bgc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीशु मसीह का जन्म इस तरियां होया, कै जिब उसकी माँ मरियम की सगाई यूसुफ कै गैल होग्यी, तो उनका ब्याह होण तै पैहल्याए बेरा पाट्या के वा पवित्र आत्मा की शक्ति तै गर्भवती सै। ");
INSERT INTO bgc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","पर उसका धणी यूसुफ जो एक धर्मी माणस था, उसनै बदनाम न्ही करणा चाहवै था, इस खात्तर उस ताहीं चुपके तै छोड़ण का विचार करया। ");
INSERT INTO bgc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जिब वो इन बात्तां नै सोच्चै ए था तो परमेसवर का सुर्गदूत उसनै सपनै म्ह आकै कहण लाग्या, “हे यूसुफ! दाऊद के वंशज, तू अपणी घरआळी मरियम नै अपणे उरै ल्याण तै ना डरै, क्यूँके जो उसकी कोख म्ह सै, वो पवित्र आत्मा की ओड़ तै सै। ");
INSERT INTO bgc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","वो बेट्टा जाम्यैगी अर तू उसका नाम यीशु धरिये, क्यूँके वो अपणे माणसां का उनकै पापां तै उद्धार करैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","यो सारा इस खात्तर होया के जो वचन प्रभु नै यशायाह नबी कै जरिये कह्या था, वो पूरा हो ");
INSERT INTO bgc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","देक्खो एक कुँवारी गर्भवती होगी अर एक छोरा जण्येगी, अर उसका नाम इम्मानुएल धरया जावैगा, जिसका मतलब सै “परमेसवर म्हारै गैल सै।” ");
INSERT INTO bgc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","फेर यूसुफ नींद तै जाग कै परमेसवर कै सुर्गदूत के हुकम कै मुताबिक मरियम नै अपणी घरआळी बणाकै अपणे याड़ै ले आया। ");
INSERT INTO bgc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","अर जिब ताहीं उसनै छोरा ना जण्या जिब तक यूसुफ उसकै धोरै न्ही गया अर उसनै बाळक का नाम यीशु धरया। ");
INSERT INTO bgc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","हेरोदेस राजा जिब यहूदिया परदेस पै राज करण लागरया था, तो उस परदेस के बैतलहम नगर म्ह यीशु का जन्म होया। तो थोड़े बखत बाद कई विद्वान जो तारां का ज्ञान राक्खै थे, पूरब तै यरुशलेम नगर म्ह आये। ");
INSERT INTO bgc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","वो आकै बुझ्झण लाग्गे, यहूदियाँ का राजा जिसका जन्म होया सै, वो कित्त सै? हमनै पूरब दिशा म्ह उसका तारा देख्या सै, जो उसके जन्म के बारें म्ह बतावै सै, इस करकै हम उसकी आराधना करण आये सां। ");
INSERT INTO bgc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","यो सुणकै हेरोदेस राजा अर उसकै गैल यरुशलेम नगर के सारे लोग चिन्ता करण लाग्गै। ");
INSERT INTO bgc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","फेर उसनै माणसां के सारे प्रधान याजकां अर शास्त्रियाँ ताहीं कठ्ठा करकै उनतै बुझ्झया, के पवित्र ग्रन्थ के कहवै सै? “मसीह का जन्म कित्त होणा चाहिये?” ");
INSERT INTO bgc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","उननै उस ताहीं कह्या, “यहूदिया परदेस के बैतलहम नगर म्ह,” क्यूँके नबियाँ कै जरिये योए पवित्र ग्रन्थ म्ह लिख्या गया सै: ");
INSERT INTO bgc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“हे बैतलहम नगर, तू जो यहूदा कै परदेस म्ह सै, तू किसे भी ढाळ तै यहूदा कै अधिकारियां म्ह सारा तै छोट्टा कोन्या। क्यूँके तेरे म्ह तै एक राजा लिकड़ैगा, जो मेरी प्रजा इस्राएल की रुखाळी करैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","हेरोदेस जाणणा चाहवै था के उस बाळक की उम्र कितनी सै, इस करकै उसनै तारां का ज्ञान राक्खण आळा ताहीं लुह्क्मा बुलाकै उनतै बुझ्झया के तारा ठीक किस बखत दिख्या था। ");
INSERT INTO bgc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","अर राजा नै यो कहकै उन ताहीं बैतलहम नगर भेज्जा, “जाओ, उस बाळक कै बारें म्ह ठीक-ठाक बेरा पाड़ो, अर जिब वो मिल ज्या तो मन्नै खबर द्यो, ताके मै भी आणकै उसकी आराधना करुँ।” ");
INSERT INTO bgc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","वे राजा की बात सुणकै चले गए, अर जो तारा उननै पूरब दिशा म्ह देख्या था, वो उनकै आग्गै-आग्गै चाल्या। अर जड़ै बाळक था, उस घर कै उप्पर जाकै रुक ग्या। ");
INSERT INTO bgc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","उस तारे नै देखकै वे घणे आनन्दित होए, जो उस घर के उप्पर रुक ग्या था। ");
INSERT INTO bgc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","उननै उस घर म्ह जाकै उस बाळक ताहीं उसकी माँ मरियम कै गैल देख्या, अर झुककै बाळक की आराधना करी, अर अपणा-अपणा झोळा खोल कै उस ताहीं सोन्ना, लोबान, अर गन्धरस की भेट चढ़ाई। ");
INSERT INTO bgc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","फेर सपनै म्ह परमेसवर नै या चेतावनी दी के हेरोदेस राजा कै धोरै फेर ना जाइयो, वे राजा ताहीं बिना बताये दुसरे राह तै अपणे देश म्ह चले ग्ये। ");
INSERT INTO bgc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","विद्वानां कै चले जाणकै बाद परमेसवर कै एक सुर्गदूत नै सपनै म्ह आकै यूसुफ तै कह्या, “उठ! उस बाळक नै अर उसकी माँ नै लेकै मिस्र देश म्ह भाग ज्या। अर जिब ताहीं मै तेरे तै ना कहूँ, जिब ताहीं ओड़ैए रहिये। क्यूँके हेरोदेस राजा इस बाळक नै टोह्कै उस ताहीं उसनै मरवाणा चाहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","फेर वो रात नै ए उठकै बाळक अर उसकी माँ नै लेकै मिस्र देश नै चाल पड्या। ");
INSERT INTO bgc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","अर हेरोदेस राजा कै मरण तक ओड़ैए रह्या। ताके वो वचन जो प्रभु नै होशे नबी कै जरिये कह्या था वो पूरा हो “मन्नै अपणे बेट्टै ताहीं मिस्र देश तै बुलाया।” ");
INSERT INTO bgc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जिब हेरोदेस राजा नै यो देख्या, के विद्वानां नै उसकै गैल धोक्खा करया सै, फेर वो छो म्ह भरग्या। उसनै सैनिकां ताहीं भेजकै विद्वानां कै जरिये ठीक-ठाक बताये होड़ बखत कै मुताबिक बैतलहम नगर अर उसकै लोवै-धोवै की जगहांया के सारे छोरयां ताहीं जो दो साल के या उसतै छोट्टे थे, वे सब मरवा दिए। ");
INSERT INTO bgc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","फेर जो वचन यिर्मयाह नबी कै जरिये कह्या ग्या था, वो पूरा होया, ");
INSERT INTO bgc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह नगर म्ह एक रोण की आवाज सुणाई देई, रोणा अर घणाए बिलाप। राहेल अपणे बाळकां कै खात्तर रोवै थी, अर चुप न्ही होणा चाहवै थी, क्यूँके वे इब मरगे थे।” ");
INSERT INTO bgc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","हेरोदेस राजा कै मरण कै पाच्छै, परमेसवर का सुर्गदूत मिस्र देश म्ह यूसुफ तै सपनै म्ह बोल्या, ");
INSERT INTO bgc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ, बाळक अर उसकी माँ नै लेकै इस्राएल कै देश म्ह चल्या ज्या, क्यूँके हेरोदेस राजा अर उसके माणस जो बाळक नै मारणा चाहवै थे, वे मर लिये सै।” ");
INSERT INTO bgc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","यूसुफ नींद तै जाज्ञा, अर बाळक अर उसकी माँ नै गेल्या लेकै इस्राएल देश म्ह बोहड़ आया। ");
INSERT INTO bgc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पर या सुणकै के अरखिलाउस अपणे पिता हेरोदेस राजा की जगहां यहूदिया परदेस पै राज करै सै, ओड़ै जाण तै डरग्या। फेर सपनै म्ह परमेसवर की ओड़ तै चेतावनी पाकै गलील परदेस म्ह चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अर नासरत नाम कै नगर म्ह जा बस्या, ताके वो वचन पूरा हो, जो नबियाँ कै जरिये यीशु के बारें कह्या गया था: “वो नासरी कुह्वावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","उन दिनां म्ह यूहन्ना बपतिस्मा देण आळा आकै यहूदिया परदेस के जंगल-बियाबान म्ह यो प्रचार करण लाग्या: ");
INSERT INTO bgc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“पाप करणा छोड़ द्यो, क्यूँके सुर्ग का राज्य धोरै आ लिया सै।” ");
INSERT INTO bgc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","यो वोए सै, जिसका जिक्र यशायाह नबी कै जरिये करया गया: “जंगल-बियाबान म्ह तै ए कोए रुक्का देवै सै, के प्रभु का राह तैयार करो अर उसकी सड़क सीध्धी करो।” ");
INSERT INTO bgc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्ना ऊँट के रुए के लत्ते पहरणीया अर अपणी कड़ म्ह चमड़े की पेट्टी-बाँधे रहवै था। उसका खाणपान टिड्डियाँ अर शहद था। ");
INSERT INTO bgc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","फेर यरुशलेम नगर अर सारे यहूदिया परदेस अर यरदन नदी कै लोवै-धोवै की सारी जगहां के माणस उसकै धोरै आ ग्ये। ");
INSERT INTO bgc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","उन सारया नै अपणे-अपणे पापां नै मानकै यरदन नदी म्ह उसतै बपतिस्मा लिया। ");
INSERT INTO bgc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जिब उसनै घणे सारे फरीसियाँ अर सदूकियाँ ताहीं अपणे धोरै बपतिस्मा लेण खात्तर आन्दे देख्या, तो बोल्या, “हे साँप के सप्पोलों जिसे माणसों, थम नरक की सजा तै किस ढाळ बचोगे? ");
INSERT INTO bgc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","इस खात्तर जै थमनै सच म्ह पाप करणा छोड़ दिया सै तो यो दिखाण खात्तर भले काम तो करो। ");
INSERT INTO bgc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","अर अपणे-अपणे मन म्ह न्यू मतना सोच्चो के म्हारा पिता अब्राहम सै। क्यूँके मै थमनै कहूँ सूं के परमेसवर इन पत्थरां तै अब्राहम कै खात्तर ऊलाद पैदा कर सकै सै। ");
INSERT INTO bgc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","इब कुहाड़ा दरखतां की जड़ पै धरया सै, इस करकै जो-जो दरखत बढ़िया फळ न्ही ल्यांदा, वो काट्या अर आग म्ह झोक्या जावैगा। इसका मतलब यो सै परमेसवर उन सारया नै दण्ड देवैगा जो पाप करणा न्ही छोड़ते। ");
INSERT INTO bgc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“मै तो थमनै पाणी तै, पापां ताहीं छोड़ण का बपतिस्मा देऊ सूं, पर जो मेरै पाच्छै आवैगा, वो मेरै तै भी शक्तिशाली सै। मै उसकी जूत्ती ठाण जोग्गा भी कोनी। वो थमनै पवित्र आत्मा अर आग तै बपतिस्मा देवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","उसका छाज उसकै हाथ म्ह सै, अर वो अपणा खलिहाण आच्छी तरियां साफ करैगा, अर अपणे नाज नै अपणे कोठार (गोदाम) म्ह कठ्ठा करैगा, पर भुरळी ताहीं उस आग म्ह जळावैगा जो कदे बुझै कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","उस बखत यीशु गलील परदेस तै यरदन नदी कै कन्ठारे यूहन्ना कै धोरै उसतै बपतिस्मा लेण आया। ");
INSERT INTO bgc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पर या कहकै यूहन्ना उसनै रोक्कण लाग्या, “कै मन्नै तो तेरे हाथ तै बपतिस्मा लेण की जरूरत सै, अर तू मेरै धोरै आया सै?” ");
INSERT INTO bgc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यीशु नै उसतै जवाब दिया, “कै इब तो योए होण दे, क्यूँ कै हमनै इस्से तरियां तै सारी धार्मिकता पूरी करणा ठीक सै।” फेर उसनै उसकी बात मान ली। ");
INSERT INTO bgc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","अर यीशु बपतिस्मा लेकै जिब पाणी तै उप्पर आया, अर अकास खुलग्या, अर उसनै परमेसवर की पवित्र आत्मा ताहीं कबूतर की तरियां उतरते अर अपणे उप्पर आन्दे देख्या। ");
INSERT INTO bgc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अर देक्खो, परमेसवर सुर्ग म्ह तै बोल्या, “कै यो मेरा प्यारा बेट्टा सै, जिसतै मै भोत घणा राज्जी सूं।” ");
INSERT INTO bgc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","बपतिस्मे के बाद पवित्र आत्मा यीशु नै जंगल-बियाबान म्ह लेग्या, ताके शैतान उस ताहीं परखै। ");
INSERT INTO bgc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","वो चाळीस दिन अर चाळीस रात, बिना खाए पिए रह्या, फेर उसनै भूख लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","फेर शैतान नै धोरै आणकै उसतै कह्या, “जै तू परमेसवर का बेट्टा सै, तो कहकै साबित करदे, के ये पत्थर रोट्टी बण जावै, ताके तू इननै खा सकै।” ");
INSERT INTO bgc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीशु नै जवाब दिया: “पवित्र ग्रन्थ म्ह लिख्या सै, ‘माणस सिर्फ रोट्टी तै ए न्ही, पर परमेसवर के हरेक वचन तै जो उसनै मान्नै सै, जिन्दा रह्वैगा।’” ");
INSERT INTO bgc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","फेर शैतान उसनै पवित्र नगर यरुशलेम म्ह लेग्या अर मन्दर की चोट्टी पै खड्या कर दिया। ");
INSERT INTO bgc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","अर उसतै बोल्या, “जै तू परमेसवर का बेट्टा सै, तो अपणे-आपनै तळै गेर कै साबित कर। क्यूँके पवित्र ग्रन्थ म्ह लिख्या सै: वो तेरे बाबत अपणे सुर्गदूत्तां नै हुकम देगा, अर वे तन्नै हाथों हाथ उठा लेवैगें कदे इसा ना हो के तेरे पायां म्ह पत्थर तै ठेस लाग्गै।” ");
INSERT INTO bgc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीशु नै उसतै कह्या, “यो भी पवित्र ग्रन्थ म्ह लिख्या सै, के ‘तू अपणे प्रभु परमेसवर नै ना परखै।’” ");
INSERT INTO bgc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","फेर शैतान उसनै घणे ऊँच्चे पहाड़ पै लेग्या अर सारी दुनिया का राजपाट अर उसकी शानों-शोकत दिखाकै, ");
INSERT INTO bgc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","उसतै बोल्या, “जै तू झुककै मेरी भगति करै, तो मै सारा किमे तन्नै दे दियुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","फेर यीशु उसतै बोल्या, “हे शैतान दूर हो ज्या, पवित्र ग्रन्थ म्ह लिख्या सै: तू प्रभु अपणे परमेसवर की भगति कर, अर सिर्फ उस्से की सेवा करया कर।” ");
INSERT INTO bgc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","फेर शैतान उसकै धोरै तै चल्या ग्या, अर देख्ये, सुर्गदूत आणकै उसकी सेवा करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जिब उसनै न्यू सुण्या के यूहन्ना कैदी बणा लिया सै, तो वो यहूदिया परदेस तै लिकड़कै गलील परदेस म्ह चल्या ग्या। ");
INSERT INTO bgc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","अर फेर वो गलील परदेस के नासरत नगर नै छोड़कै कफरनहूम नगर म्ह, जो गलील समुन्दर कै किनारे था, कफरनहूम उस क्षेत्र म्ह गलील के समुन्दरी तट पै था, जड़ै जबूलून अर नप्ताली के गोत्र के माणस रहवै थे। ");
INSERT INTO bgc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ताके जो यशायाह नबी कै जरिये कह्या गया था, वो पूरा हो ");
INSERT INTO bgc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबूलून अर नप्ताली जात्ति कै परदेस, गलील समुन्दर कै किनारे यरदन नदी के पार, गलील परदेस म्ह रहण आळे गैर यहूदी माणस” ");
INSERT INTO bgc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","“जो माणस अन्धकार म्ह जीण लागरे थे, उननै तेज चान्दणा देख्या। वे उस जगहां म्ह जीण लागरे थे, जित्त हर घड़ी मौत का खतरा था, उनपै चान्दणा चमक्या।” ");
INSERT INTO bgc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","उस बखत तै यीशु नै प्रचार करणा अर कहणा शरु करया, “पाप करणा छोड़ द्यो, क्यूँके सुर्ग का राज्य धोरै आया सै।” ");
INSERT INTO bgc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","गलील परदेस म्ह गलील समुन्दर कै किनारे घूमदे होए उसनै दो भाईयाँ ताहीं शमौन जो पतरस कुह्वावै सै, अर उसके भाई अन्द्रियास ताहीं समुन्दर म्ह जाळ गेरते देख्या, क्यूँके वे मछवारे थे। ");
INSERT INTO bgc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","यीशु नै उनतै कह्या, “मेरै पाच्छै आओ, मै थमनै माणसां ताहीं कठ्ठे करण आळे बणाऊँगा ताके वो मेरे चेल्लें बणे।” ");
INSERT INTO bgc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","वे जिब्बे जाळां नै छोड़कै उसके चेल्लें बणण खात्तर उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ओड़ तै आग्गै चालकै, यीशु नै दो और भाईयाँ ताहीं यानी जब्दी के बेट्टे याकूब अर उसकै भाई यूहन्ना ताहीं देख्या। वे अपणे पिता जब्दी कै गैल किस्ती पै अपणे जाळां ताहीं ठीक करै थे। यीशु नै उन ताहीं भी बुला लिया। ");
INSERT INTO bgc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","वे जिब्बे किस्ती अर अपणे पिता नै छोड़कै उसके चेल्लें बणण खात्तर उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यीशु सारे गलील परदेस म्ह फिरता होया उनकै आराधनालयाँ म्ह उपदेश सुणान्दा, अर राज्य का सुसमाचार सुणान्दा अर माणसां की हरेक ढाळ की बीमारी अर कमजोरियाँ नै दूर करदा रह्या। ");
INSERT INTO bgc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","अर सारे सीरिया परदेस म्ह उसका यश फैलग्या, अर माणस सारे बिमारां नै, जो कई ढाळ की बिमारियाँ अर दुखां तै जकड़े होए थे, जिन म्ह भुंडी आत्मा थी, अर मिर्घी आळे अर लकवे के रोग्गी नै उसकै धोरै ल्याए उसनै उन ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","अर गलील परदेस, दिकापुलिस नगर, यरुशलेम नगर, यहूदिया परदेस अर यरदन नदी कै पार तै भीड़ की भीड़ उसकै पाच्छै हो ली ");
INSERT INTO bgc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","यीशु उस भीड़ नै देखकै पहाड़ पै चला ग्या, अर जब बैठग्या तो उसके चेल्लें उसकै धोरै आए। ");
INSERT INTO bgc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","अर वो अपणी ऊँच्ची आवाज म्ह उननै या शिक्षा देण लाग्या: ");
INSERT INTO bgc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“धन्य सै वे, जो या जाणे सै के उननै परमेसवर की जरूरत सै, क्यूँके सुर्ग का राज्य उननै का सै। ");
INSERT INTO bgc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","धन्य सै वे, जो शोक करै सै, क्यूँके वे परमेसवर तै शांति पावैगें। ");
INSERT INTO bgc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","धन्य सै वे, जो नम्र सै, क्यूँके वे परमेसवर के जरिये धरती के हकदार होंगे। ");
INSERT INTO bgc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धन्य सै वे, जो धार्मिकता का जीवन जीण खात्तर भूखे अर तिसाए सै, क्यूँके वे परमेसवर के जरिये छिकाए जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","धन्य सै वे, जो दया करण आळे सै, क्यूँके परमेसवर भी उनपै दया करैगा। ");
INSERT INTO bgc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","धन्य सै वे, जिनके मन शुद्ध सै, क्यूँके वे परमेसवर नै देखैगें। ");
INSERT INTO bgc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","धन्य सै वे, जो मेल कराण आळे सै, क्यूँके वे परमेसवर के बेट्टा-बेट्टी कुह्वावैगें। ");
INSERT INTO bgc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धन्य सै वे, जो धार्मिकता के कारण सताए जावै सै, क्यूँके सुर्ग का राज्य उन्हे का सै।” ");
INSERT INTO bgc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“धन्य सों थम, जिब माणस मेरै कारण थारी बुराई करै सतावै अर झूठ बोल-बोलकै थारे बिरोध म्ह सारी तरियां की बुरी बात फैलावै, क्यूँके थम मेरे चेल्लें सों। ");
INSERT INTO bgc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","फेर खुश अर मग्न होइयो, क्यूँके थारे खात्तर सुर्ग म्ह बड्ड़ा ईनाम सै। इस करकै के उननै उन नबियाँ ताहीं भी इस्से ढाळ सताया था, जो थारे तै भी भोत पैहल्या थे।” ");
INSERT INTO bgc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“थम धरती पै लोग्गां खात्तर नूण की तरियां सों, पर जै नूण का सुवाद जान्दा रहवै, तो वो किस चीज तै नमकीन करया जावैगा? फेर वो किसे काम का न्ही, सिर्फ इसकै के बाहर फेक्या ज्या अर माणसां के पैरां तळै चिकल्या ज्या।” ");
INSERT INTO bgc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“थम दुनिया के लोग्गां खात्तर चाँदणा की तरियां सों। जो नगर पहाड़ पै बस रह्या सै वो लुह्क न्ही सकदा। ");
INSERT INTO bgc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","अर माणस दीवा जळा कै बरतन कै तळै न्ही पर टांडी पै धरै सै, फेर उसतै घर के सारे माणसां ताहीं चान्दणा ज्या सै। ");
INSERT INTO bgc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","उस्से तरियां थारा चान्दणा माणसां के स्याम्ही चमकै के वे थारे भले काम्मां नै देखकै थारे पिता की, जो सुर्ग म्ह सै बड़ाई करै।” ");
INSERT INTO bgc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“या ना समझो, के मै मूसा के नियम-कायदा या नबियाँ के लेख नै मिटाण आया सूं, मिटाण न्ही, पर पूरा करण आया सूं। ");
INSERT INTO bgc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","क्यूँके मै थमनै सच कहूँ सूं, के जब ताहीं धरती अर अकास सै, जद ताहीं नियम-कायदा म्ह लिखी हरेक छोट्टी तै छोट्टी बात पूरी होए बिना न्ही रहवैगी। ");
INSERT INTO bgc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","इस करकै जो कोए इन छोट्टे तै छोट्टे हुकम म्ह तै किसे एक नै भी न्ही मानता, अर दुसरे माणसां नै भी उसाए सिखावै, वो सुर्ग के राज्य म्ह सारा तै छोट्टा कुह्वावैगा, पर जो कोए उन सारे हुकमां पै चाल्लैगा अर उननै सिखावैगा, वोए सुर्ग राज्य म्ह महान् कुह्वावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","क्यूँके मै थमनै कहूँ सूं, के जै थारा आत्मिक जीवन शास्त्रियाँ अर फरीसियाँ के आत्मिक जीवन तै बढ़कै न्ही हो, तो थम सुर्ग के राज्य म्ह कदे बड़ न्ही पाओगें।” ");
INSERT INTO bgc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“थमनै सुण्या होगा, के थारे पूर्वजां तै कह्या, गया था के ‘खून ना करियो’, अर ‘जो कोए खून करैगा वो कचेह्ड़ी म्ह दण्ड के लायक होगा।’ ");
INSERT INTO bgc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पर मै थमनै या कहूँ सूं, के जो कोए अपणे भाई पै गुस्सा करैगा, वो कचेह्ड़ी म्ह दण्ड के लायक होगा, अर जो कोए अपणे भाई नै निकम्मा कहवैगा वो बड्डी सभा म्ह दण्ड के लायक होगा, अर जो कोए कहवै ‘अरै बेकूफ’ वो नरक की आग के दण्ड के लायक होगा।” ");
INSERT INTO bgc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“इस करकै जै तू अपणा चढ़ावा मन्दर म्ह वेदी पै चढ़ावै, अर ओड़ै तू याद करै, के तेरे भाई के मन म्ह तेरे खात्तर किमे बिरोध सै, ");
INSERT INTO bgc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","तो तू अपणा चढ़ावा ओड़ैए वेदी कै धोरै छोड़दे, अर ज्याकै अपणे भाई तै मेळ-मिलाप कर अर फेर आकै अपणा चढ़ावा चढ़ा।” ");
INSERT INTO bgc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“जिब तक तू अपणे बैरी के गेल्या राह म्ह सै, तो उसतै जिब्बे मेळ-मिलाप करले, कदे इसा ना हो के बैरी तन्नै न्यायाधीश के हवालै, अर न्यायाधीश तन्नै सिपाही के हवालै करदे, अर तू जेळ म्ह गेर दिया जावै। ");
INSERT INTO bgc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मै तन्नै सच कहूँ सूं के जिब ताहीं तू पाई-पाई न्ही भरदे जद ताहीं जेळ तै छुटण न्ही पावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“थमनै परमेसवर का हुकम सुण्या होगा के कह्या गया था, ‘जारी ना करियो।’ ");
INSERT INTO bgc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पर मै थमनै न्यू कहूँ सूं, के जो कोए किसे बिरबान्नी पै भुंडी निगांह गेरै वो अपणे मन म्ह उसतै जारी करग्या। ");
INSERT INTO bgc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","जै तेरी सोळी आँख तेरे तै पाप करवावै सै, तो उसनै लिकाड़ के फेंक दे, क्यूँके तेरे खात्तर योए ठीक सै के तेरे अंगा म्ह तै एक नाश हो ज्या अर तेरी सारी देह नरक म्ह ना गेरी जावै। ");
INSERT INTO bgc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","जै तेरा सोळा हाथ तेरे तै पाप करवावै सै, तो उसनै काट के फेंक दे, क्यूँके तेरे खात्तर योए आच्छा सै के तेरे बाक्की अंगा म्ह तै एक नाश हो जावै अर तेरी सारी देह नरक म्ह न्ही गेरी जावै।” ");
INSERT INTO bgc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“यो भी कह्या गया था, ‘जो कोए अपणी घरआळी नै तलाक देणा चाहवै, तो उसनै तलाकनामा दे।’ ");
INSERT INTO bgc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पर मै थमनै यो कहूँ सूं के जो कोए अपणी घरआळी नै जारी कै सिवा किसे और कारण तै तलाक दे, तो वो उसतै जारी करवावै सै। अर जो कोए उस छोड्डी होई तै ब्याह करै, वो जारी करै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“फेर थमनै सुण्या होगा के थारे पूर्वजां तै कह्या गया था, ‘झूठ्ठी कसम ना खाईयों, पर प्रभु के खात्तर अपणी कसम नै पूरी करियो।’ ");
INSERT INTO bgc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पर मै थमनै या कहूँ सूं के कदे कसम ना खाईयों, ना तो सुर्ग की, क्यूँके वो परमेसवर का सिंहासन सै। ");
INSERT INTO bgc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ना धरती की, क्यूँके वा उसकै पैरां की पिड्ढी सै, ना यरुशलेम नगर की, क्यूँके वो महाराजा का नगर सै। ");
INSERT INTO bgc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","अपणे सिर की भी कसम ना खाईयों क्यूँके तू एक बाळ नै भी ना तो धोळा, अर ना काळा कर सकै सै। ");
INSERT INTO bgc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","पर थारी बात ‘हाँ’ की हाँ, या ‘ना’ की ना हो, क्यूँके जो किमे इसतै घणा होवै सै वो शैतान की ओड़ तै होवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“थमनै नियम-कायदा म्ह सुण्या होगा के कह्या था, आँख कै बदले आँख, अर दाँत कै बदले दाँत। ");
INSERT INTO bgc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पर मै थमनै कहूँ सूं के बुरे माणस तै झगड़ा मोल ना लियो, पर जो कोए तेरे सोळे गाल पै थप्पड़ मारै उस कान्ही दुसरा भी फेर दे। ");
INSERT INTO bgc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","जै कोए तेरे पै दाब देकै तेरा कुड़ता लेणा चाहवै, तो उसनै अंगोच्छा भी दे दे। ");
INSERT INTO bgc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","जै कोए अधिकारी तन्नै एक कोस मुफ्त म्ह ले जावै, तो उसकै गेल्या दो कोस चल्या ज्या। ");
INSERT INTO bgc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जो कोए तेरे तै माँग्गै, उसनै दे, अर जो कोए तेरे तै उधार लेणा चाहवै, उसतै मुँह ना मोड़।” ");
INSERT INTO bgc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“थमनै नियम-कायदा म्ह सुण्या होगा के कह्या गया था, अपणे पड़ोसी तै प्यार राखिये, अर अपणे बैरी तै बैर। ");
INSERT INTO bgc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पर मै थमनै कहूँ सूं के अपणे बैरियाँ तै प्यार राक्खों अर अपणे सतावण आळे के खात्तर प्रार्थना करो, ");
INSERT INTO bgc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","जिसतै थम अपणे सुर्गीय पिता की सिध्द ऊलाद मान्ने जाओगे। क्यूँके वो भले अर बुरे लोग्गां पै अपणा सूरज उगाया करै सै, अर धर्मी अर अधर्मी लोग्गां पै मिह बरसावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","क्यूँके जै थम अपणे प्यार करण आळा तै ए प्यार करो सों, तो कौण सा बड़ा काम करो सों? के चुंगी लेण आळे भी इसाए न्ही करदे? ");
INSERT INTO bgc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","जै थम अपणे भाईयाँ नै ए नमस्कार करो, तो कौण्सा बड्ड़ा काम करो सों? के गैर यहूदी भी इसाए न्ही करदे? ");
INSERT INTO bgc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","इस करकै जरूरी सै के थम भी सिध्द बणो, जिसा थारा सुर्गीय पिता सिध्द सै।” ");
INSERT INTO bgc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“चौक्कस रहो! थम माणसां नै दिखाण कै खात्तर धर्म के काम ना करो, न्ही तो अपणे सुर्गीय पिता तै कुछ भी ईनाम न्ही पाओगे।” ");
INSERT INTO bgc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“इस करकै जिब तू दान करै, तो अपणे आग्गै ढिंडोरा ना पिटवाईये, जिसा कपटी, आराधनालयाँ अर गळियाँ म्ह करै सै, ताके माणस उनकी बड़ाई करै। मै थारे ताहीं साच्ची कहूँ सूं के उननै अपणा ईनाम माणसां की बड़ाई के रूप म्ह पा लिया। ");
INSERT INTO bgc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पर जिब तू दान करै, तो उसका किसे और नै बेरा न्ही पाटणा चाहिए। ");
INSERT INTO bgc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताके तेरा दान छिप्या रहवै, अर जिब तेरा पिता जो गुप्त म्ह देक्खै सै, तन्नै ईनाम देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“जिब तू प्रार्थना करै, तो कपटियाँ के तरियां ना हो, क्यूँके माणसां नै दिखाण खात्तर आराधनालयाँ म्ह अर सड़कां कै मोड़ां पै खड़े होकै प्रार्थना करणा उननै आच्छा लाग्गै सै। मै थमनै साच्ची कहूँ सूं के उननै अपणा ईनाम माणसां की बड़ाई के रूप म्ह पा लिया। ");
INSERT INTO bgc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पर जिब तू प्रार्थना करै, तो अपणी कोठड़ी म्ह जा, अर किवाड़ बन्द करकै अपणे पिता तै, जो गुप्त म्ह सै उसतै प्रार्थना कर। जद तेरा पिता, जो तेरे लुह्क कै करे होए काम्मां नै देक्खै सै, तो तन्नै उनका ईनाम देवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","प्रार्थना करदे बखत दुसरी जात्तां की तरियां बडबडाइये ना, क्यूँके वे समझै सै के उनकै एक बात के बार-बार बोल्लण तै उनकी सुणी जावैगी। ");
INSERT INTO bgc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","इस करकै थम उनकी तरियां ना बणो, क्यूँके थारा पिता थारे माँगण तै पैहल्याए जाणै सै के थारी के-के जरूरत सै। ");
INSERT INTO bgc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","इस करकै थम इस तरियां तै प्रार्थना करया करो ‘हे म्हारे पिता, तू जो सुर्ग म्ह सै, तेरा नाम पवित्र मान्या जावै।’ ");
INSERT INTO bgc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","‘तेरा राज्य आवै। तेरी इच्छा जिसी सुर्ग म्ह पूरी होवै सै, उसी धरती पै भी हो।’ ");
INSERT INTO bgc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‘म्हारे दिन भर की रोटी आज हमनै दे।’ ");
INSERT INTO bgc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","‘अर जिस तरियां हमनै अपणे कसूरवारां ताहीं माफ करया सै, उस्से तरियां तू भी म्हारे कसूरां नै माफ करदे।’ ");
INSERT INTO bgc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","‘अर म्हारे ताहीं परखै ना, पर बुराई तै बचा, (क्यूँके राज्य, वीरता अर महिमा सदा तेरे ए सै।’ आमीन।) ");
INSERT INTO bgc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“इस करकै जै थम माणसां के कसूर माफ करोगे, तो थारा सुर्गीय पिता भी थमनै माफ करैगा। ");
INSERT INTO bgc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","अर जै थम माणसां के कसूरां नै माफ न्ही करोगे, तो थारा पिता भी थारे कसूर माफ न्ही करैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“जिब थम ब्रत करो, तो कपटियाँ की तरियां थारे मुँह पै उदासी छाई ना रहवै, क्यूँके वे अपणा मुँह बणाई राक्खै सै, ताके माणस उननै ब्रती जाणै। मै थमनै साच्ची कहूँ सूं के वे अपणा ईनाम माणसां की बड़ाई के रूप म्ह पा चुके। ");
INSERT INTO bgc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पर जिब तू ब्रत करै तो अपणे सिर पै तेल लगा अर मुँह धो, ");
INSERT INTO bgc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ताके माणस न्ही पर तेरा पिता तन्नै ब्रती जाणै। तेरा पिता जो तेरे उस गुप्त म्ह करे होए ब्रत नै देक्खै सै, तो तन्नै उनका ईनाम देगा।” ");
INSERT INTO bgc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“अपणे खात्तर धरती पै धन कठ्ठा ना करो, जड़ै कीड़ा अर काई नाश करै सै, अर जड़ै चोर सेंध लगावै अर चोरै सै। ");
INSERT INTO bgc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","पर अपणे खात्तर सुर्ग म्ह धन कठ्ठा करो, जड़ै ना तो कीड़ा अर ना काई नाश करै सै, अर जड़ै चोर ना सेंध लगावै अर ना चोरै सै। ");
INSERT INTO bgc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","क्यूँके जड़ै तेरा धन सै उड़ै तेरा मन भी लाग्या रहवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“देह का दीवा आँख सै इस करकै जै तेरी नजर सही सै तो तेरी सारी देह भी चाँदणे म्ह सै। ");
INSERT INTO bgc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","पर जै तेरी नजर खराब सै तो तेरी सारी देह भी अन्धेरे म्ह सै, इस कारण जो तू सोच्चै सै के मै चाँदणे म्ह सूं, पर वो अन्धेरा हो, तो सोचकै देख वो अन्धेरा कितना बड्ड़ा होगा!” ");
INSERT INTO bgc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“कोए माणस दो मालिकां की सेवा एक बखत पै न्ही कर सकदा, क्यूँके वो एक तै बैर अर दुसरे तै प्यार राक्खैगा, या एक तै मिल्या रहवैगा अर दुसरे नै छोट्टा जाणैगा। थम परमेसवर अर धन दोनुआ की सेवा न्ही कर सकदे। ");
INSERT INTO bgc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“इस करकै मै थमनै कहूँ सूं के अपणे जीवन के खात्तर या चिंता ना करियो के हम के खावांगें अर के पीवागें, अर ना अपणी देह के खात्तर के पैहरागें। के जीवन खाणे तै, के देह लत्यां तै बढ़कै कोन्या? ");
INSERT INTO bgc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","अकास के पंछियाँ नै देक्खों! वे ना बोवै सै, ना काटै सै, अर ना कुठले (गोदाम) म्ह कठ्ठा करै सै, फेर भी थारा सुर्गीय पिता उन ताहीं खुवावै सै। के थम पंछियाँ तै घणे कीमती कोनी? ");
INSERT INTO bgc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","थारे म्ह कौण सै, जो चिंता करकै अपणी उम्र म्ह एक पल भी बढ़ा सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“अर लत्यां के खात्तर क्यूँ चिंता करो सों? जंगळी फूल्लां पै ध्यान करो के वे किस तरियां बढ़ै सै, वे ना तो मेहनत करै सै, ना लत्तें बणावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","तोभी मै थारे तै कहूँ सूं के राजा सुलैमान भी, अपणे सारे शानों-शोकत म्ह उन म्ह तै किसे के समान लत्ते पैहरे होए कोनी था। ");
INSERT INTO bgc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","इस करकै जिब परमेसवर मैदान की घास नै इसी सुन्दरता देवै सै, जो आज सै अर काल बाड़ म्ह झोक्की जावैगी, तो हे बिश्वास म्ह कमजोर माणसों, वो थारी चिन्ता क्यूँ न्ही करैगा?” ");
INSERT INTO bgc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“इस करकै थम चिंता करकै न्यू ना कहियो के हम के खावांगें, या के पीवागें, या के पैहरागें? ");
INSERT INTO bgc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","क्यूँके गैर यहूदी इन सारी चिज्जां की टोह् म्ह रहवै सै, पर थारा सुर्गीय पिता जाणै सै के थमनै इन सारी चिज्जां की जरूरत सै, इस करकै चिन्ता ना करो। ");
INSERT INTO bgc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","इस करकै पैहल्या थम परमेसवर के राज्य की खोज करो अर पवित्र जीवन जिओ, तो ये सारी चीज भी थमनै अपणे-आप मिल ज्यागीं। ");
INSERT INTO bgc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","इस करकै कांल की चिंता ना करो, क्यूँके कांल का दिन अपणी चिंता आप कर लेवैगा, आज कै खात्तर आज का ए दुख भतेरा सै।” ");
INSERT INTO bgc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“दुसरयां पै दोष ना लाओ न्ही तो लोग थारे पै भी दोष लगावैंगे। ");
INSERT INTO bgc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","क्यूँके जिस तरियां थम दुसरयां पै दोष लगाओ सों, उस्से तरियां परमेसवर भी थारे पै दोष लगावैगा, जिस तरियां तै थम दुसरयां का न्याय करो सों, उस्से तरियां थारा भी न्याय करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“तू क्यूँ अपणे भाई की आँख कै तिन्कै जिसी छोट्टी सी बुराई नै देक्खै सै, अर अपणी आँख म्ह लठ जिसी बड़ी बुराई तन्नै कोनी दिखदी?” ");
INSERT INTO bgc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जिब तेरी-ए आँख म्ह लठ सै, तो तू अपणे भाई तै किस तरियां कहवै सै, “ल्या मै तेरी आँख तै तिन्का लिकाड़ द्यु।” ");
INSERT INTO bgc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","इस करकै हे कपटी, पैहल्या अपणे जीवन की बड़ी बुराई नै दूर कर फेर तू अपणे भाई नै आच्छी दाऊँ बुराई तै बचा सकैगा। ");
INSERT INTO bgc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“उन माणसां ताहीं परमेसवर का वचन ना सुणाओ जो उस ताहीं सुणणा न्ही चाहन्दे। जै तू इसा करै सै तो पवित्र चीज कुत्याँ कै आग्गै अर मोत्ती सूअरां के आग्गै फैक्कण की ढाळ होगा, इसा न्ही हो के वे उननै पैरां तळै चिकलै अर उल्टके थमनै पाड़ले।” ");
INSERT INTO bgc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“परमेसवर तै माँग्गो, तो वो थमनै देवैगा, टोव्होगें तो थम पाओगे, खटखटाओ, तो थारे खात्तर खोल्या जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","क्यूँके जो कोए माँग्गै सै, उसनै मिलै सै, अर जो टोह्वैं सै, वो पावै सै, अर जो खटखटावै सै, उसकै खात्तर खोल्या जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“थारे म्ह तै इसा कौण माणस सै, के जै उसका बेट्टा रोट्टी माँग्गै, तो वो उसनै पत्थर देवै? ");
INSERT INTO bgc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","या मच्छी माँग्गै, तो उसनै साँप देवै? ");
INSERT INTO bgc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","इस करकै जिब थम बुरे होकै, अपणे बाळकां नै आच्छी चीज देणा जाणो सों, तो थारा सुर्गीय पिता अपणे माँगण आळा नै आच्छी चीज क्यूँ न्ही देवैगा? ");
INSERT INTO bgc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","इस कारण जो किमे थम चाहो सों के माणस थारे गेल्या करै, थम भी उनकै गेल्या उसाए करो, क्यूँके नियम-कायदे अर नबियाँ की शिक्षा याए सै।” ");
INSERT INTO bgc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“थम परमेसवर के राज्य म्ह भीड़ै फाटक तै ए दाखल हो सको सों, क्यूँके चौड़ा सै वो फाटक अर सीध्धा सै वो रास्ता जो नाश नै पोहच्यै सै, अर घणेए सै जो उस म्ह दाखल होवै सै। ");
INSERT INTO bgc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","क्यूँके भीड़ा सै वो फाटक अर मुश्किल सै वो राह जो अनन्त जीवन की ओड़ पुह्चावै सै, अर भोत थोड़े सै वे लोग जो उसनै पावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“झूठ्ठे नबियाँ तै चौक्कस रहो, जो भेड्डां के भेष म्ह थारे धोरै आवै सै, पर भित्तर तै वे पाडण आळे भेड़िये सै। ");
INSERT INTO bgc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","उनकै काम्मां तै ए थम उन ताहीं पिच्छाण ल्योगे। के माणस झाड़ियाँ तै अंगूर, या झाड़ बोझड़े तै अंजीर तोड़ै सै? ");
INSERT INTO bgc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","इस तरियां हरेक आच्छा दरखत आच्छा फळ ल्यावै सै अर निकम्मा दरखत बुरा फळ ल्यावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","आच्छा दरखत बुरा फळ न्ही ल्या सकदा, अर ना निकम्मा दरखत आच्छा फळ ल्या सकै सै। ");
INSERT INTO bgc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जो-जो दरखत आच्छा फळ न्ही ल्यान्दा, वो काट्या अर आग म्ह गेरया ज्या सै, उस्से तरियां झूठ्ठे नबियाँ कै गैल भी इसाए होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","झूठ्ठे नबियाँ नै उनके काम्मां तै थम उन ताहीं पिच्छाण ल्योगे।” ");
INSERT INTO bgc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“जो मेरै तै, ‘हे प्रभु! हे प्रभु!’ कहवै सै, उन म्ह तै हर एक सुर्ग के राज्य म्ह दाखल न्ही होगा, पर वोए दाखल होगा जो मेरै सुर्गीय पिता की मर्जी पै चाल्लै सै। ");
INSERT INTO bgc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","न्याय के दिन घणखरे-ए माणस मेरै तै कहवैगें, ‘हे प्रभु, हे प्रभु, के हमनै तेरे नाम तै भविष्यवाणी न्ही करी, के हमनै तेरे नाम तै ओपरी आत्मायाँ ताहीं न्ही लिकाड्या, अर तेरे नाम तै घणेए अचम्भे के काम न्ही करे?’ ");
INSERT INTO bgc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","फेर मै उनतै खुलकै कह दियुँगा, मन्नै थारे ताहीं कदे न्ही अपणाया। हे भुन्डे़ काम करण आळो, मेरै धोरै तै चले जाओ।” ");
INSERT INTO bgc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“इस करकै जो कोए मेरी इन बात्तां नै सुणकै उननै मान्नै सै, वो उस अकलमंद माणस की ढाळ होगा जिसनै अपणे घर की नीम चट्टान पै धरी। ");
INSERT INTO bgc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","अर मिह बरसया, बाढ़ आयी, आँधी आई, अर उस घर तै टकराई, फेर भी वो कोनी गिरया, क्यूँके उसकी नीम चट्टान पै धरी ग्यी थी। ");
INSERT INTO bgc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","पर जो कोए मेरी ये बात सुणै सै अर उनपै न्ही चाल्दा, वो उस बेकूफ माणस की ढाळ सै, जिसनै अपणे घर की नीम बाळूरेत पै धरी। ");
INSERT INTO bgc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","अर मिह बरसया, बाढ़ आयी, आँधी चाल्ली, अर उस घर तै टकराई अर पड़कै उसका सत्यानाश होग्या।” ");
INSERT INTO bgc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जिब यीशु नै ये बात कह ली, तो इसा होया के भीड़ उसके उपदेश तै हैरान होगी, ");
INSERT INTO bgc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","क्यूँके वो उन ताहीं शास्त्रियाँ की तरियां न्ही पर अधिकार कै गैल उननै उपदेश देवै था। ");
INSERT INTO bgc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जिब यीशु उस पहाड़ तै उतरा, तो एक बड्डी भीड़ उसके पाच्छै हो ली। ");
INSERT INTO bgc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","अर, एक कोढ़ी नै धोरै आकै उस ताहीं नमस्कार करया अर कह्या, “हे प्रभु, जै तू चाहवै, तो मन्नै ठीक कर सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीशु नै हाथ बढ़ाकै उस ताहीं छुआ, अर कह्या, “मै चाहूँ सूं, के तू इस बीमारी तै ठीक हो ज्या।” अर वो जिब्बे कोढ़ तै ठीक होग्या। ");
INSERT INTO bgc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीशु नै उसतै कह्या, “देख किसे तै ना कहिये, पर जाकै अपणे-आपनै याजक ताहीं दिखा अर अपणे कोढ़ तै ठीक होण कै बारै म्ह जो कुछ मूसा नबी नै जो पवित्र ग्रन्थ म्ह चढ़ावा बताया सै उसनै चढ़ा, के माणसां खात्तर या गवाही हो, के तू ठीक होग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जिब यीशु कफरनहूम नगर म्ह आया तो एक सूबेदार नै धोरै आकै उसतै बिनती करी, ");
INSERT INTO bgc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“हे प्रभु, मेरा नौक्कर लकवे के रोग तै घणा दुखी होरया सै।” ");
INSERT INTO bgc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","यीशु नै उस ताहीं कह्या, “मै आकै उसनै ठीक करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सूबेदार नै जवाब दिया, “हे प्रभु, मै इस लायक कोनी के तू मेरे घरां आवै, पर सिर्फ मुँह तै कह दे तो मेरा नौक्कर ठीक हो ज्यागा। ");
INSERT INTO bgc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","क्यूँके मै जाणु सूं, के मै भी किसी के आदेशां का पालन करुँ सूं, अर सिपाही मेरै आदेशां का पालन करै सै। जिब मै एक तै कहूँ सूं, जा, तो वो जावै सै, अर दुसरे तै कहूँ, आ, तो वो आवै सै, अर अपणे नौक्कर तै कहूँ सूं, यो कर, तो वो करै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","यो सुणकै यीशु कै अचम्भा होया, अर जो लोग उसकै पाच्छै आवै थे उनतै कह्या, “मै थमनै साच्ची कहूँ सूं के मन्नै इस्राएल देश म्ह भी इसा बिश्वास न्ही देख्या, जिसा इस सूबेदार का सै। ");
INSERT INTO bgc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","अर मै थमनै कहूँ सूं के पूरब अर पच्छिम तै घणेए गैर यहूदी आवैगें अर भोज म्ह अब्राहम अर इसहाक अर याकूब के गेल्या सुर्ग के राज्य म्ह बैठैगें। ");
INSERT INTO bgc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पर राज्य की ऊलाद (यहूदी लोग) बाहर अन्धेरे म्ह गेर दिये जावैंगे उड़ै रोणा अर दाँत पिसणा होगा।” ");
INSERT INTO bgc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","जिब यीशु नै सूबेदार तै कह्या, “घर चला जा, जिसा तेरा बिश्वास सै, उसाए तेरे खात्तर होगा।” अर उसका नौक्कर उस्से बखत ठीक होग्या। ");
INSERT INTO bgc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","यीशु जिब पतरस के घरां आया, तो उसनै उसकी सास्सू ताहीं बुखार म्ह पड्या देख्या। ");
INSERT INTO bgc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","उसनै उसका हाथ पकड्या अर उसका बुखार उतर ग्या, अर वा उठकै उसकी सेवा-पाणी करण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","जिब साँझ होई फेर माणस उसके धोरै घणेए माणसां नै ल्याए जिन म्ह ओपरी आत्मा थी अर यीशु नै उन आत्मायाँ ताहीं अपणे वचन तै लिकाड़ दिया, अर सारे बिमारां ताहीं ठीक कर दिया। ");
INSERT INTO bgc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ताके जो वचन यशायाह नबी के जरिये कह्या गया था वो पूरा हो “उसनै खुद ए म्हारी कमजोरी ले ली अर म्हारी बीमारी उठा ली।” ");
INSERT INTO bgc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीशु नै जिब अपणे चौगरदू एक भीड़ देक्खी तो अपणे चेल्यां ताहीं गलील समुन्दर के परली ओड़ जाण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","यीशु अर उसके चेल्लें किस्ती की ओड़ जाण लागरे थे, तो एक शास्त्री नै धोरै आकै उसतै कह्या, “हे गुरु, जड़ै किते तू जावैगा, मै तेरे पाच्छै हो ल्यूँगा, क्यूँके मै तेरा चेल्ला बणणा चाहूँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीशु नै उसतै कह्या, “लोमड़ियां की घुरखाण अर अकास के पंछियाँ के बसेरे हो सै, पर मुझ माणस के बेट्टै खात्तर सिर छिपाण की भी जगहां कोनी सै।” ");
INSERT INTO bgc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","एक और चेल्लै नै उसतै कह्या, “हे प्रभु, पैहले मन्नै घर जाणदे, मै अपणे पिता के मरण कै बाद उस ताहीं दफना के आऊँगा, फेर तेरा चेल्ला बणुगाँ।” ");
INSERT INTO bgc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीशु नै उसतै कह्या, “तू मेरै पाच्छै हो ले, अर मेरा चेल्ला बण जा अर जो आत्मिक रूप तै मर चुके सै, उननै मुर्दे दफणाण दे।” ");
INSERT INTO bgc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जिब यीशु किस्ती पै चढ्या, तो उसके चेल्लें उसकै पाच्छै हो लिए। ");
INSERT INTO bgc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","अर देक्खो, समुन्दर म्ह एक इसा बड्ड़ा अन्धोड़ उठ्या के किस्ती झाल्लां तै ढक्ण लाग्गी, अर वो सोण लाग रह्या था। ");
INSERT INTO bgc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","फेर चेल्यां नै धोरै आकै उस ताहीं जगाया अर कह्या, “हे प्रभु, हमनै बचा, हम डूबके मरण आळे सां।” ");
INSERT INTO bgc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","यीशु नै उनतै कह्या, “हे बिश्वास म्ह कमजोर माणसों, क्यूँ डरो सों?” फेर उसनै उठकै आँधी अर पाणी ताहीं धमकाया, अर सब शान्त होग्या। ");
INSERT INTO bgc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","अर वे अचम्भा करकै कहण लाग्ये, “यो किसा माणस सै के आँधी अर पाणी भी उसका हुकम मान्नैं सै।” ");
INSERT INTO bgc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जिब यीशु गलील समुन्दर कै परली ओड़ गदरेनियां के देश म्ह पुँह्चा, तो दो माणस जिन म्ह ओपरी आत्मा थी कब्रिस्तान म्ह तै लिकड़कै उसनै मिले। वे इतने डरावणे थे के कोए उस रास्ते तै जा न्ही सकै था। ");
INSERT INTO bgc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","दोन्नु माणसां नै किल्की मारकै कह्या, “हे परमेसवर के बेट्टे, म्हारा तेरे तै के काम? के तू बखत तै पैहल्या हमनै दुख देण आड़ै आया सै?” ");
INSERT INTO bgc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","उनतै थोड़ी सी दूर पै घणेए सूअरां का टोळ चरै था। ");
INSERT INTO bgc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ओपरी आत्मायाँ नै उसतै या कहकै बिनती करी के, “जै तू हमनै लिकाड़ै सै, तो सूअरां के टोळ म्ह भेजदे।” ");
INSERT INTO bgc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","उसनै उन ताहीं कह्या, “जाओ!” अर वे ज्या के सूअरां म्ह बैठगी अर देक्खो, सारा टोळ ढळान पै तै झपटकै पाणी म्ह ज्या पड्या, अर डूब मरया। ");
INSERT INTO bgc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","उनके पाळी भाज्ये, अर नगर म्ह जाकै ये सारी बात अर जिन म्ह ओपरी आत्मा थी उनका सारा हाल कह सुणाया। ");
INSERT INTO bgc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","फेर सारे नगर के माणस यीशु तै फेटण नै लिक्ड़ाए, अर उस ताहीं देख के बिनती करी के म्हारी सीमा तै बाहर चल्या ज्या। ");
INSERT INTO bgc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","फेर यीशु किस्ती म्ह चढ़कै उस पार गया, अर बोहड़कै अपणे नगर म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","अर देक्खो, कई माणस लकवे के एक मरीज नै खाट पै लिटा के उसकै धोरै ल्याए। यीशु नै उनका बिश्वास देखकै, उस लकवे के मरीज तै कह्या, “हे बेट्टे, धीर बाँध, मन्नै तेरे पाप माफ कर दिये।” ");
INSERT INTO bgc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","इसपै कई शास्त्रियाँ नै सोच्या, “यो तो परमेसवर की बुराई करै सै” ");
INSERT INTO bgc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीशु नै उनकै मन की बात जाणकै कह्या, “थम माणस अपणे-अपणे मन म्ह बुरा विचार क्यूँ आण देओ सों? ");
INSERT INTO bgc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","आसान के सै? यो कहणा, ‘तेरे पाप माफ होए’, या यो कहणा, ‘उठ अर हाँड-फिर।’ ");
INSERT INTO bgc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पर इस करकै के थम जाण ल्यो के मुझ माणस के बेट्टै नै धरती पै पाप माफ करण का हक सै।” फेर उसनै लकवे के मरीज तै कह्या, “उठ, अपणे बिस्तर ठाकै, अपणे घरां चल्या जा।” ");
INSERT INTO bgc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","वो उठकै अपणे घरां चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","माणस यो देखकै डरगे अर परमेसवर की बड़ाई करण लाग्ये जिसनै माणस ताहीं इसा हक दिया सै। ");
INSERT INTO bgc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ओड़ै तै आग्गै बढ़ के यीशु नै मत्ती नाम के एक आदमी ताहीं चुंगी की चौकी पै बेठ्या देख्या, अर उसतै कह्या, “मेरा चेल्ला बणण खात्तर मेरै पाच्छै हो ले।” अर वो उठकै उसकै पाच्छै हो लिया। ");
INSERT INTO bgc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","जिब वो अर उसकै चेल्लें मत्ती के घर म्ह खाणा खाण खात्तर बेठ्ठे तो भोत-से चुंगी लेण आळे अर जिननै लोग पापी कहवै सै वे आकै उनकै गेल्या खाणा खाण बेठ्ठे। ");
INSERT INTO bgc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","या देखकै फरीसियाँ नै उसकै चेल्यां ताहीं कह्या, “थारा गुरु चुंगी लेण आळे अर पापी माणसां गेल्या क्यूँ खावै-पीवै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","या सुणकै यीशु नै उनतै कह्या, “वैद आच्छे-बिच्छयां खात्तर कोनी पर बिमारां खात्तर जरूरी सै। ");
INSERT INTO bgc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","इस करकै थम जाओ अर समझ ल्यो के पवित्र ग्रन्थ के इस वचन का मतलब के सै: ‘मै बलिदान न्ही पर दया चाहूँ सूं।’ क्यूँके जो अपणे-आपनै धर्मी कहवै मै उननै न्ही, पर जो अपणे-आपनै पापी कहवै सै उननै बुलाण आया सूं।” ");
INSERT INTO bgc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","फेर बपतिस्मा देण आळे यूहन्ना के चेल्यां नै धोरै आणकै कह्या, “के कारण सै के हम अर फरीसी इतने ब्रत करा सां, पर तेरे चेल्लें ब्रत न्ही करदे?” ");
INSERT INTO bgc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीशु नै उनतै कह्या, “के बराती, जिब ताहीं बन्दड़ा उसके गेल्या सै, शोक मना सकै सै? पर वे दिन आवैगें जिब बन्दड़ा उनतै न्यारा करया जावैगा, उस बखत वे ब्रत करैगें।” ");
INSERT INTO bgc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“नये लत्यां की थेग्ळी पुराणे लत्यां पै कोए न्ही लगान्दा, क्यूँके वा थेग्ळी लत्ते तै और भी लत्ता खुस्का दे सै, अर वो और भी घणा पाट ज्या सै। ");
INSERT INTO bgc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अर माणस नया अंगूर का रस पुराणी मश्क म्ह न्ही भरदे, क्यूँके इसा करण तै मश्क पाट ज्या सै, अर अंगूर का रस खिंड ज्या सै, अर मश्क फूट ज्या सै, पर नया अंगूर का रस नई मशकां म्ह भरा जावै सै तब वे दोनु बचे रहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","वो उनतै ये बात कहण ए लागरया था, के जिब्बे आराधनालयाँ कै सरदारां म्ह तै एक याईर नाम के आदमी नै आकै उस ताहीं नमस्कार करया अर कह्या, “मेरी बेट्टी इब्बे मरी सै, पर तू चाल के अपणा हाथ उसपै धरै, तो वा जिन्दा हो ज्यागी।” ");
INSERT INTO bgc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीशु उठकै अपणे चेल्यां समेत उसके पाच्छै हो लिया। ");
INSERT INTO bgc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","अर देक्खो, एक बिरबान्नी नै जिसकै बारहां साल तै लहू बहण की बीमारी थी, पाच्छै तै आकै उसकै लत्ते के कोणे ताहीं छू लिया। ");
INSERT INTO bgc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","क्यूँके वा अपणे मन म्ह कहवै थी, “जै मै उसकै लत्ते नै छू ल्यूँगी तो ठीक हो जाऊँगी।” ");
INSERT INTO bgc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीशु नै घूमकै उस ताहीं देख्या अर कह्या, “बेट्टी धीरज राख, तेरे बिश्वास नै तेरे ताहीं ठीक करया सै।” अर वा बिरबान्नी उस्से बखत ठीक होगी। ");
INSERT INTO bgc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जिब यीशु याईर कै घर म्ह पुँह्चा अर बाँसली बजाण आळे अर भीड़ नै रोळा मचांदे देख्या, ");
INSERT INTO bgc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","फेर कह्या, “हट जाओ, छोरी मरी कोनी, पर सोवै सै।” इसपै वे उसका मजाक उड़ाण लाग्ये। ");
INSERT INTO bgc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पर जिब भीड़ लिकाड़ दी, तो उसनै भित्तर ज्या के उस छोरी का हाथ पकड्या, अर वा जी उठी। ");
INSERT INTO bgc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","अर इस बात का जिक्र सारे देश म्ह फैलग्या। ");
INSERT INTO bgc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जिब यीशु ओड़ै तै आग्गै बढ़ा, तो दो आन्धे उसकै पाच्छै या कहन्दे होए चाल्ले, “हे दाऊद की ऊलाद, म्हारै पै दया कर!” ");
INSERT INTO bgc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जिब वो घर म्ह पुह्चा, तो वे आन्धे उसके धोरै आये, अर यीशु नै उनतै कह्या, “के थमनै बिश्वास सै के मै थमनै चंगा कर सकू सूं?” उननै उसतै कह्या, “हाँ प्रभु!” ");
INSERT INTO bgc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","फेर उसनै उनकी आँखां कै हाथ लगाकै कह्या, “थारे बिश्वास के मुताबिक थम चंगे होजाओ।” ");
INSERT INTO bgc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अर वे जिब्बे देक्खण लाग्गे। यीशु नै उनतै समझां के कह्या, “सावधान, किसे ताहीं या बात ना बताइयो, के मन्नै थारे खात्तर के करया सै।” ");
INSERT INTO bgc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पर उननै मिलकै सारे देश म्ह उसका नाम फैला दिया। ");
INSERT INTO bgc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जिब वे दोन्नु आन्धे बारणै जाण लागरे थे, तो देक्खो, कई माणस एक गूँगे नै उसके धोरै ल्याए जिसम्ह ओपरी आत्मा थी, जो उसनै बोल्लण कोनी देवै थी। ");
INSERT INTO bgc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","अर जिब यीशु नै ओपरी आत्मा लिकाड़ दी, तो गूँगा बोलण लाग्या। इसपै भीड़ नै अचम्भा करकै कह्या, “इस्राएल म्ह इसा कदे न्ही देख्या गया।” ");
INSERT INTO bgc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पर फरीसियाँ नै कह्या, “ओपरी आत्मायाँ के सरदार इस ताहीं शक्ति देवै सै, इस करकै यो ओपरी आत्मायाँ नै लिकाड़ै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीशु अर उसके चेल्लें सारे नगरां अर गाम्मां म्ह फिरता होया अर उनकै आराधनालयाँ म्ह उपदेश सुणान्दा, अर परमेसवर के राज्य का सुसमाचार सुणादा, अर हरेक ढाळ की बीमारी अर कमजोरियाँ नै दूर करदा रह्या। ");
INSERT INTO bgc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जिब उसनै भीड़ देखी तो उसनै माणसां पै तरस आया, क्यूँके वे उन भेड्या की तरियां थे, जिनका कोए पाळी ना हो, वे बेचैन अर भटके होए से थे। ");
INSERT INTO bgc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","फेर उसनै अपणे चेल्यां तै कह्या, “पके होए खेत्तां की तरियां लोग तो भोत सै जो परमेसवर के वचन नै सुणणा चाहवै सै, पर फसल काट्टण आळे की तरियां लोग कम सै जो जाकै परमेसवर का वचन सुणावै। ");
INSERT INTO bgc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","इस करकै खेत के माल्लिक यानी परमेसवर तै बिनती करो, के वो और लोग्गां नै भेज्जै, ताके परमेसवर का वचन भोत सारे लोग्गां ताहीं सुणावै।” ");
INSERT INTO bgc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","फेर यीशु नै अपणे बारहां चेल्यां ताहीं धोरै बुलाकै, उन ताहीं ओपरी आत्मायाँ पै हक दिया के उननै लिकाड़ै अर सारी ढाळ की बिमारियाँ अर सारी ढाळ की कमजोरियाँ नै ठीक करै। ");
INSERT INTO bgc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","इन बारहां प्रेरितां के नाम ये सै: पैहल्या शमौन, जो पतरस कुह्वावै सै, अर उसका भाई अन्द्रियास, जब्दी का बेट्टा याकूब, अर उसका भाई यूहन्ना, ");
INSERT INTO bgc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस, अर बरतुल्मै, थोमा, अर चुंगी लेण आळा मत्ती, हलफई का बेट्टा याकूब, अर तद्दै, ");
INSERT INTO bgc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","शमौन जेलोतेस, अर यहूदा इस्करियोती जिसनै वो पकड़वा भी दिया। ");
INSERT INTO bgc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","इन बारहां चेल्यां ताहीं यीशु नै यो हुकम देकै भेज्या: “गैर यहूदी लोग्गां कान्ही ना ज्याइयो, अर सामरियाँ के किसे नगर म्ह दाखल ना होइये। ");
INSERT INTO bgc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","पर इस्राएल के कुण्बे की ए खुई होड़ी भेड्डां के धोरै जाईये। ");
INSERT INTO bgc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","अर चालते-चालते यो प्रचार करो: सुर्ग का राज्य धोरै आ ग्या। ");
INSERT INTO bgc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बिमारां नै ठीक करो, मरै होए नै जीवाओ, कोढ़ियाँ नै शुद्ध करो, ओपरी आत्मायाँ नै लिकाड़ो। थमनै मुफ्त लिया सै मुफ्त द्यो।” ");
INSERT INTO bgc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“अपणे अंगोच्छां म्ह ना तो सोन्ना, ना चाँदी, अर ना ताम्बे के सिक्के राखियो। ");
INSERT INTO bgc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","रास्ते खात्तर ना झोळी लियो, ना दो कुड़ते, ना जूत्ते अर ना लाठ्ठी लियो, क्यूँके मजदूर नै उसका खाणा मिलणा चाहिए। ");
INSERT INTO bgc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","जिस किसे नगर या गाम म्ह जाओ, तो बेरा पाड़ो के कुण लायक सै। अर जिब ताहीं उड़ै तै ना लिकड़ो, उस्से के गेल्या रहों। ");
INSERT INTO bgc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","घर म्ह बढ़ते आणी उसनै आशीर्वाद दिए। ");
INSERT INTO bgc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","जै उस घर के माणस लायक होंगे तो थारा आशीर्वाद उनपै पुहँचगा, पर जै वे लायक ना हों तो थारा आशीर्वाद थारे धोरै उल्टा ए आ ज्यागा। ");
INSERT INTO bgc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जो कोए थमनै न्ही अपणावै अर थारी बात ना सुणै, उस घर या उस नगर तै लिकड़दे आणी अपणे पैरां की धूळ झाड़ लियो। ");
INSERT INTO bgc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मै थमनै सच्ची कहूँ सूं के न्याय के दिन उस नगर की हालत तै सदोम अर अमोरा के नगर की हालत घणी सहण जोग्गी होवैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“देक्खो, मै थमनै भेड्डां की तरियां भेड़ियाँ के बिचाल्ये भेज्जू सूं, इस करकै साँपां की तरियां अकलमंद अर कबूतरां की तरियां भोळे बणो। ");
INSERT INTO bgc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","पर माणसां तै चौक्कस रहों, क्यूँके वे थमनै बड़े आराधनालयाँ म्ह सौपैगें, अर अपणी सभा म्ह थारे कोड़े मारैगें। ");
INSERT INTO bgc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","थम मेरै खात्तर राज्यपालों अर राजयां के स्याम्ही अर गैर यहूदी लोग्गां म्ह भेज्जे जाओगें। ताके थम मेरे बारें म्ह गवाही दे सको ");
INSERT INTO bgc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जिब वे थमनै पकड़वावैगें तो या फिक्र ना करियो के हम किस तरियां तै या के कहवागें, क्यूँके जो किमे थारे ताहीं कहणा होगा, वो उस्से बखत थारे ताहीं बता दिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","क्यूँके बोलण आळे थम न्ही सों, पर थारे सुर्गीय पिता का आत्मा थारे म्ह बोल्लै सै। ");
INSERT INTO bgc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","भाई, भाई नै अर पिता बेट्टे नै, मारण खात्तर सौंप देंगें, अर बाळक अपणे माँ बाप के बिरोध म्ह खड़े होकै उन ताहीं मरवा देवैगें। ");
INSERT INTO bgc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मेरै नाम के कारण सारे माणस थारे तै बैर करैगें, पर जो अन्त ताहीं धीरज धरैगा उस्से का उद्धार होगा। ");
INSERT INTO bgc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जिब वे थमनै नगर म्ह सतावै, तो दुसरे म्ह भाग ज्याइयो। मै थमनै सच कहूँ सूं, थम इस्राएल के सारे नगरां म्ह न्ही घूम सकोगें के मै माणस का बेट्टा आ जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“चेल्ला अपणे गुरु तै बड्ड़ा न्ही होंदा, अर ना नौक्कर अपणे माल्लिक तै। ");
INSERT INTO bgc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेल्लै का गुरु के, अर नौक्कर का माल्लिक के बराबर होणा ए भोत सै। जिब उननै घर के माल्लिक तै शैतान कह्या तो उसके घरआळां नै के कुछ न्ही कहवैगें!” ");
INSERT INTO bgc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“इस करकै माणसां तै ना डरो, क्यूँके कुछ ढकया कोनी, जो उजागर न्ही करया जावैगा, अर ना कुछ लुहक्या सै जिसका बेरा न्ही पटै। ");
INSERT INTO bgc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","जो मै थारे तै अन्धेरे म्ह कहूँ सूं, उसनै थम चाँदणे म्ह कहो, अर जो कान्नो-कान सुणो सों, उसनै छात्तां पै चढ़ के प्रचार करो। ");
INSERT INTO bgc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","जो देह नै घात करै सै, पर आत्मा नै घात न्ही कर सकदे, उनतै ना डरियो, पर उस परमेसवर तै डरो जो आत्मा अर देह दोनुआ नै नरक म्ह गेरकै नाश कर सकै सै। ");
INSERT INTO bgc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","छोट्टी चिड़ियाँ दो पिस्या की बिकै सै, जो ना कै बराबर सै तोभी जै वो धरती पै पड़कै मरै सै तो पिता परमेसवर नै उसका भी बेरा सै क्यूँके पिता परमेसवर सब कुछ जाणण आळा सै। ");
INSERT INTO bgc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","थारे सिर के बाळ भी सारे गिणे होड़े सै। ");
INSERT INTO bgc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","इस करकै डरो मतना, थम घणी गौरैयाँ (एक छोट्टी चिड़ियाँ) तै बढ़कै सो।” ");
INSERT INTO bgc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जो कोए माणसां कै स्याम्ही मन्नै मान लेवैगा, उसनै मै भी अपणे सुर्गीय पिता के स्याम्ही मान ल्यूँगा। ");
INSERT INTO bgc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पर जो माणसां कै स्याम्ही मेरै बारै म्ह इन्कार करैगा, उसनै मै भी अपणे सुर्गीय पिता के स्याम्ही इन्कार करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“यो ना समझो के मै धरती पै माणसां का मिलाप करवाण आया सूं, मै मिलाप करवाण न्ही, पर न्यारे करण आया सूं। ");
INSERT INTO bgc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मै तो आया सूं, ताके माणस नै उसके पिता तै, अर बेट्टी नै उसकी माँ तै, अर बहू नै उसकी सास तै न्यारा कर द्यु।” ");
INSERT INTO bgc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","“माणस के बैरी उसके घर के ए लोग होंगे।” ");
INSERT INTO bgc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जो अपणे माँ-बाप नै मेरै तै घणा प्यारा मान्नै सै, वो मेरा चेल्ला बणण कै लायक कोनी, अर जो बेट्टा या बेट्टी नै मेरै तै घणा प्यारा मान्नै सै, वो मेरै लायक कोनी। ");
INSERT INTO bgc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","अर जो अपणा दुखां का क्रूस लेकै मेरै पाच्छै न्ही चाल्लै वो मेरै लायक कोनी। ");
INSERT INTO bgc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जो अपणी जान बचावै सै, वो उसनै खोवैगा, अर जो मेरै कारण अपणी जान खोवैगा, वो उसनै पावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जो थमनै अपणावै सै, वो मन्नै अपणावै सै, अर जो मन्नै अपणावै सै, वो उस परमेसवर नै अपणावै सै, जिसनै मेरे ताहीं भेज्या सै। ");
INSERT INTO bgc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जो नबियाँ नै नबी जाण के अपणावै, वो नबियाँ के जिसा फळ पावैगा, जिसा नबी नै मिलै सै, अर जो धर्मी नै धर्मी जाण के अपणावै, वो धर्मी के जिसा फळ पावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जो कोए मेरे इन चेल्यां म्ह तै एक नै भी मेरा चेल्यां जाण के सिर्फ एक कटोरा ठंडा पाणी पियावैगा, मै थमनै सच कहूँ सूं, वो किसे तरियां भी अपणा फळ न्ही खोवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","अपणे बारहां चेल्यां ताहीं इस तरियां समझाण कै बाद यीशु ओड़ै तै चाल पड्या, अर गलील परदेस के नगरां म्ह उपदेश अर प्रचार करदा घूमता रह्या। ");
INSERT INTO bgc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","यूहन्ना नै जेळ म्ह मसीह के काम्मां की खबर सुणी अर अपणे चेल्यां ताहीं यीशु तै न्यू बुझ्झण भेज्या, ");
INSERT INTO bgc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","अर उसतै कह्या, “के आण आळा वो मसीहा जिसका वादा परमेसवर नै करया था, तू ए सै, या हम किसे और की बाट देक्खां?” ");
INSERT INTO bgc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीशु नै जवाब दिया, “जो कुछ थम सुणो सो अर देक्खो सो, यो सारा जाकै यूहन्ना ताहीं कह द्यो, ");
INSERT INTO bgc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","के आन्धे देक्खैं सै अर लंगड़े चाल्लै-फिरै सै, कोढ़ी ठीक करे जावै सै अर बहरे सुणै सै, मुर्दे जिन्दे करे जावै सै, अर कंगालां ताहीं सुसमाचार सुणाया जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","अर धन्य सै वे, जो मेरै पै शक न्ही करते, अर बिश्वास करणा न्ही छोड़ते।” ");
INSERT INTO bgc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जिब यूहन्ना के चेल्लें ओड़ै तै जाण लागरे थे तो यीशु भीड़ म्ह माणसां तै यूहन्ना कै बारै म्ह कहण लागग्या, “थम जंगल-बियाबान म्ह के देखण गये थे? के हवा म्ह हाल्दे होए सरकंड्या नै? ");
INSERT INTO bgc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","तो फेर थम के देखण गये थे? के सुथरे लत्ते पहरे होड़ माणस ताहीं? देक्खो, जो सुथरे लत्ते पहरै सै, वे राजघरां म्ह रहवैं सै। ");
INSERT INTO bgc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","तो फेर क्यांतै गये थे? के किसे नबी नै देखण ताहीं? हाँ, मै थमनै कहूँ सूं, बल्के नबी तै भी बड़े नै।” ");
INSERT INTO bgc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","यूहन्ना वोए सै जिसकै बारै म्ह पवित्र ग्रन्थ म्ह लिख्या सै: के “‘देख, मै अपणे दूत ताहीं तेरे आग्गै भेज्जू सूं जो तेरे आग्गै तेरा रास्ता त्यार करैगा।’” ");
INSERT INTO bgc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मै थमनै कहूँ सूं के जो बिरबानियाँ तै जणे सै, उन म्ह तै यूहन्ना बपतिस्मा देणआळे तै बड्ड़ा कोए न्ही होया, पर जो सुर्ग कै राज्य म्ह छोट्टे तै भी छोट्टा सै वो उसतै बड्ड़ा सै। ");
INSERT INTO bgc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","यूहन्ना बपतिस्मा देण आळे के दिनां तै इब ताहीं सुर्ग का राज्य बलपूर्वक बढ़ण लाग रहया सै, अर बिरोधी लोग उसनै रोकण की कोशिश करण लागरे सै। ");
INSERT INTO bgc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","यूहन्ना के आण तक सारे नबी अर मूसा के नियम-कायदा म्ह, सुर्ग के राज्य की भविष्यवाणी करी गई। ");
INSERT INTO bgc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","जै थम सच म्ह भविष्यवाणीयाँ पै बिश्वास करो सों, तो सुणो यूहन्ना ए वो एलिय्याह सै जो दोबारा आण आळा था। ");
INSERT INTO bgc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जिसके कान हों, वो ध्यान तै सुण ले। ");
INSERT INTO bgc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“मै आज की पीढ़ी के माणसां की बराबरी किसतै करुँ? वे उन बाळकां की ढाळ सै, जो बजारां म्ह बेठ्ठे होए एक-दुसरे तै रुक्के मारकै शिकायत करै सै:” ");
INSERT INTO bgc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“हमनै थारे खात्तर बाँसली बजाई, अर थम कोनी नाच्चे, हमनै बिलाप करया, अर थमनै छात्त्ती कोनी पिट्टी।” ");
INSERT INTO bgc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“इस्से तरियां यूहन्ना बपतिस्मा देण आळा ना रोट्टी खाया करदा अर ना अंगूर का रस पिया करदा, अर थम कहो सो, ‘उस म्ह ओपरी आत्मा सै।’ ");
INSERT INTO bgc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","मुझ माणस के बेट्टे का खाण-पान और माणसां की तरियां साद्दा ए सै, लखाओ, थमनै मेरे ताहीं पेट्टू अर पियक्कड़ माणस, चुंगी लेणिये का अर पापियाँ का साथी घोषित कर दिया! पर ज्ञान अपणे काम्मां म्ह सच्चा ठहराया गया सै।” ");
INSERT INTO bgc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","फेर यीशु उन नगरां ताहीं उल्हाणा देण लाग्या, जिन म्ह उसनै घणे सामर्थ के काम करे थे, क्यूँके उननै पाप करणा न्ही छोड्या अर ना ए परमेसवर के राह पै चाल्लै। ");
INSERT INTO bgc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“धिक्कार सै थारे पै खुराजिन नगर के माणसों! धिक्कार सै थारे पै बैतसैदा नगर के माणसों! जो सामर्थ के काम थारे म्ह करे गये, जै वे सूर अर सैदा नगरां म्ह करे जान्दे, तो टाट ओढ़ कै, अर राख म्ह बैठकै वे कदे के पाप करणा छोड़ देन्दे। ");
INSERT INTO bgc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","पर मै थमनै कहूँ सूं के न्याय कै दिन थारी हालत तै सूर अर सैदा नगरां की हालत घणी सहण जोग्गी होवैगी। ");
INSERT INTO bgc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","हे कफरनहूम नगर के माणसों, थम के सोच्चों सों, के थम सुर्ग ताहीं ऊँच्चे करे जाओगें? थम तो अधोलोक तक नीच्चै जाओगें, जो सामर्थ के काम थारे म्ह करे गये सै, जै सदोम नगर म्ह करे जान्दे, तो वो आज ताहीं बण्या रहन्दा। ");
INSERT INTO bgc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पर मै थमनै कहूँ सूं के न्याय के दिन तेरी हालत तै सदोम नगर की हालत घणी सहण जोग्गी होवैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","उस्से बखत यीशु नै कह्या, “हे पिता, सुर्ग अर धरती के प्रभु, मै तेरा शुक्रियादा करुँ सूं के तन्नै इन बात्तां ताहीं ज्ञानियाँ अर समझदार माणसां तै ल्कोए राख्या, अर बाळकां ताहीं दिखा दिया सै। ");
INSERT INTO bgc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हाँ, हे पिता, क्यूँके तन्नै योए भाया।” ");
INSERT INTO bgc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“मेरे पिता नै मेरै ताहीं सब कुछ सौप्या सै, अर कोए बेट्टै ताहीं कोनी जाण्दा, सिर्फ पिता के अलावा, अर कोए पिता ताहीं कोनी जाण्दा, सिर्फ बेट्टे के अलावा, अर हरेक वो माणस जो परम पिता नै जाणे सै, जिसकै खात्तर बेट्टे नै उस ताहीं जाहिर करणा चाह्या सै।” ");
INSERT INTO bgc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“हे सारे मेहनत करण आळो अर बोझ तै दबे होड़े माणसों, मेरै धोरै आओ, मै थमनै सुख-चैन दियुँगा। ");
INSERT INTO bgc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मेरा जूआ अपणे उप्पर ठा ल्यो, अर मेरै तै सीखो, क्यूँके मै नरम अर मन का दीन सूं: अर थम अपणे मन म्ह सुख-चैन पाओगे। ");
INSERT INTO bgc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","क्यूँके मेरा जूआ सोखा अर मेरा बोझ हल्का सै” ");
INSERT INTO bgc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","तकरीबन उस्से बखत आराम कै दिन यीशु चेल्यां कै गैल खेत्तां म्ह तै होकै जाण लागरया था, अर उसके चेल्यां नै भूख लाग्गी तो वे गेहूँ की बालें तोड़-तोड़कै खाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरीसियाँ नै न्यू देखकै उसतै बोल्ले, “देख, तेरे चेल्लें वो काम करै सै, जो नियम-कायदा के मुताबिक आराम कै दिन करणा ठीक कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","यीशु नै उनतै कह्या, “के थमनै पवित्र ग्रन्थ म्ह यो न्ही पढ़्या, के दाऊद अर उसके साथियाँ नै जिब वे भूक्खे होए तो के करया था? ");
INSERT INTO bgc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","वो किस तरियां परमेसवर कै घर म्ह गया, अर भेंट की रोट्टी खाई, जिनका खाणा ना तो उस ताहीं अर ना उसके साथियाँ ताहीं पर सिर्फ याजकां ताहीं सही था? ");
INSERT INTO bgc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","यो थमनै नियम-कायदा म्ह न्ही पढ़्या के आराम कै दिन मन्दर के याजक ए आराम कै दिन की विधि ताहीं तोड़ै सै फेर भी उन ताहीं कोए कुछ न्ही कहन्दा? ");
INSERT INTO bgc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पर मै थमनै कहूँ सूं के उरै वो सै जो मन्दर तै भी बड्ड़ा सै। ");
INSERT INTO bgc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","जै थम पवित्र ग्रन्थ म्ह जो लिख्या सै, उसका मतलब जाणदे के, ‘मै बलिदान न्ही पर दया चाहूँ सूं।’ तो थम बेकसूर ताहीं कसूरवार कोनी ठहरान्दे। ");
INSERT INTO bgc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","मै माणस का बेट्टा तो आराम कै दिन का भी प्रभु सूं।” ");
INSERT INTO bgc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ओड़ै तै चालकै वो उनके आराधनालय म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ओड़ै एक माणस था, जिसका हाथ सूखरया था। फरीसी लोग्गां नै यीशु पै दोष लाण खात्तर उसतै बुझ्झया, “मूसा के नियम-कायदा कै मुताबिक आराम कै दिन ठीक करणा सही सै?” ");
INSERT INTO bgc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","यीशु नै उनतै कह्या, “थारे म्ह तै इसा कौण सै जिसकी एक ए भेड़ हो, अर वा आराम कै दिन खडहे म्ह पड़ जावै, तो वो उस ताहीं पकड़कै न्ही काड्डै? ");
INSERT INTO bgc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","फेर माणस तो भेड़ तै भोत घणे खास सै! ज्यांतै आराम कै दिन भलाई करणा ठीक सै, जिसा के माणसां नै चंगा करणा।” ");
INSERT INTO bgc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","फेर यीशु नै उस माणस तै कह्या, “अपणा हाथ बढ़ा।” उसनै बढ़ाया, अर वो दुसरे हाथ की तरियां ठीक होग्या। ");
INSERT INTO bgc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","फेर फरीसियाँ नै बाहरणै जाकै उसकै बिरोध म्ह सलाह करी के उसका नाश किस तरियां करया जावै। ");
INSERT INTO bgc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","न्यू जाणकै यीशु ओड़ै तै चल्या गया। अर घणे माणस उसकै पाच्छै हो लिए, अर उसनै सारया ताहीं ठीक करया, ");
INSERT INTO bgc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","अर उन ताहीं चेतावनी दी, के मेरै बारै म्ह किसे तै ना कहियो के मै कौण सूं। ");
INSERT INTO bgc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ताके जो वचन यशायाह नबी कै जरिये कह्या गया था, वो पूरा हो ");
INSERT INTO bgc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“देक्खो, यो मेरा सेवक सै, जिस ताहीं मन्नै चुण्या सै, मेरा प्यारा, जिसतै मेरा मन राज्जी सै, मै अपणा आत्मा उसपै तारुगाँ, अर योए दुसरी जात्तां नै न्याय की खबर देवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","“वो ना माणसां के गैल झगड़ा करैगा, अर ना किल्की मारैगा, ना बजारां म्ह उसका कोए शब्द सुणैगा। ");
INSERT INTO bgc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","“वो कुचले होए सरकण्डे की समान कमजोर माणसां ताहीं कोनी लताड़ैगा, अर बुझते होए दीवे के समान, माणस मरता हो तो वो उसनै न्ही मारैगा, वो जिब ताहीं डटया रह्वैगा जिब ताहीं न्याय ना दुवा दे। ");
INSERT INTO bgc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","“अर दुसरी जात उसकै नाम पै आस राक्खैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","फेर माणस एक आन्धे-गूँगे नै जिसम्ह ओपरी आत्मा थी, जो उसनै देखण अर बोल्लण कोनी देवै थी, उसकै धोरै ल्याए, अर उसनै उस ताहीं ठीक करया, अर वो गूँगा बोलण अर देखण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","इसपै सारे माणस अचम्भा करकै कहण लाग्गे, “यो के दाऊद की ऊलाद सै!” ");
INSERT INTO bgc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","पर फरीसियाँ नै न्यू सुणकै कह्या, “यो तो ओपरी आत्मायाँ के सरदार शैतान की मदद तै ओपरी आत्मायाँ नै लिकाड़ै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","उसनै उनकै मन की बात जाणकै उनतै कह्या, “जिस किसे राज म्ह फूट होवै सै, वो उजड़ जावै सै, अर कोए नगर या घराना जिसम्ह फूट होवै सै, बण्या कोनी रहवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अर जै शैतान ए शैतान नै काड्डै, तो वो अपणा ए बिरोधी बणग्या, फेर उसका राज किस तरियां बण्या रहवैगा? ");
INSERT INTO bgc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","भला, जै मै शैतान की मदद तै ओपरी आत्मायाँ नै काढ्ढू सूं, तो थारी पीढ़ी किसकी मदद तै काड्डै सै? इस करकै वैए थारा न्याय करैगें। ");
INSERT INTO bgc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","पर जै मै परमेसवर के आत्मा की मदद तै ओपरी आत्मायाँ नै काढ्ढू सूं, तो परमेसवर का राज्य थारे धोरै आण पोंहच्या सै।” ");
INSERT INTO bgc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“या किस तरियां कोए माणस किसे ठाड्डे माणस कै घर म्ह बड़कै उसका माळ लूट सकै सै जिब ताहीं के पैहल्या उस ठाड्डे ताहीं ना जुड़ ले? जिब वो उसका घर लूट लेवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जो मेरै गेल्या न्ही वो मेरै बिरोध म्ह सै, अर जो मेरै गेल्या न्ही कठ्ठा करदा, वो खिंडावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ज्यांतै मै थारे तै कहूँ सूं के माणस का सारे ढाळ का पाप अर बुराई माफ करी जावैगी, पर पवित्र आत्मा की बुराई माफ कोनी करी जावैगी। ");
INSERT INTO bgc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जो कोए माणस के बेट्टे कै बिरोध म्ह कोए बात कहवैगा, उसका यो कसूर माफ करया जावैगा, पर जो कोए पवित्र आत्मा कै बिरोध म्ह कुछ कहवैगा, उसका कसूर ना तो इस लोक म्ह अर ना परलोक म्ह माफ करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“दरखत अपणे फळ तै ए पिच्छाणा जावै सै, जै दरखत नै बढ़िया कहो, तो उसकै फळ नै भी बढ़िया कहो, या दरखत नै निकम्मा कहो, तो उसकै फळ नै भी निकम्मा कहो। ");
INSERT INTO bgc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","हे साँप के सप्पोलों जिसे माणसों, थम भुन्डे़ होकै किस तरियां बढ़िया बात कह सको सो? क्यूँके जो मन म्ह भरया सै, वोए मुँह पै आवै सै। ");
INSERT INTO bgc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","भला माणस अपणे मन के भले भण्डार तै भली बात लिकाड़ै सै, अर बुरा माणस अपणे मन के बुरे भण्डार तै बुराई की बात काढै सै। ");
INSERT INTO bgc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","अर मै थारे तै कहूँ सूं के जो-जो निकम्मी बात माणस कहवैगें, न्याय कै दिन वे हरेक उस बात का लेखा देवैगें। ");
INSERT INTO bgc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","क्यूँके तू अपणी बात्तां कै कारण बेकसूर, अर अपणी बात्तां ए कै कारण कसूरवार ठहराया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","इसपै कुछ शास्त्रियाँ अर फरीसियाँ नै उसतै कह्या, “हे गुरु, हम तेरे तै एक चिन्ह-चमत्कार देखणा चाहवां सा।” ");
INSERT INTO bgc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","उसनै उन ताहीं जवाब दिया, “इस युग के बुरे अर जार माणस निशान्नी टोह्वैं सै, पर योना नबी की निशान्नी नै छोड़ कोए और निशान्नी उन ताहीं कोनी दी जावैगी। ");
INSERT INTO bgc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","जिस तरियां योना नबी तीन रात अर तीन दिन बड़ी मछली कै पेट म्ह रहया, उस्से तरियां ए मै माणस का बेट्टा तीन रात अर तीन दिन धरती कै भीत्त्तर रहूँगा। ");
INSERT INTO bgc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","निनवे नगर के माणस न्याय कै दिन इस युग के माणसां कै गेल्या उठकै उन ताहीं कसूरवार ठहरावैगें, क्यूँके उननै योना नबी का प्रचार सुणकै अपणे पापां ताहीं स्वीकार किया, अर देक्खो, उरै वो सै जो योना नबी तै भी बड्ड़ा सै। ");
INSERT INTO bgc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","दक्षिण देश की राणी न्याय कै दिन इस युग के माणसां कै गेल्या उठकै उन ताहीं कसूरवार ठहरावैगी, क्यूँके वा राजा सुलैमान का ज्ञान सुणण कै खात्तर धरती कै दुसरे सिरे तै आई, अर देक्खो, उरै वो सै जो सुलैमान तै भी बड्ड़ा सै।” ");
INSERT INTO bgc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“जिब ओपरी आत्मा माणस म्ह तै लिकड़कै जावै सै, तो सूक्खी जगहां म्ह आराम टोह्न्दी फिरै सै, अर पांदी कोनी। ");
INSERT INTO bgc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","फेर कहवै सै, ‘मै उस्से माणस म्ह जड़ै तै लिकड़ी थी बोहड़ जाऊँगी।’ अर आकै उस माणस नै घर जिसा झाड़ा-बुहारा अर सजा-धज्या पावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","फेर वा ओपरी आत्मा जाकै अपणे तै और भुंडी सात आत्मायाँ नै अपणे गेल्या ले आवै सै, अर वे उस माणस म्ह बड़कै ओड़ै वास करै सै, अर उस माणस की पाच्छली हालत पैहल्या तै भी भुंडी हो जावै सै। इस युग के बुरे माणसां की हालत भी इसीए होवैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","जिब वो भीड़ तै बात करण ए लागरया था, तब उसकी माँ अर उसके भाई बाहरणै खड़े थे अर उसतै बात करणा चाहवै थे। ");
INSERT INTO bgc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","किसे नै उसतै कह्या, “देख, तेरी माँ अर तेरे भाई बाहरणै खड़े सै, अर तेरे तै बात करणा चाहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","या सुणकै यीशु नै कहण आळे ताहीं जवाब दिया, “कौण सै मेरी माँ? अर कौण सै मेरे भाई?” ");
INSERT INTO bgc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","अर अपणे चेल्यां कान्ही अपणा हाथ बढ़ाकै कह्या, “देक्खो, मेरी माँ अर मेरे भाई ये सै। ");
INSERT INTO bgc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","क्यूँके जो कोए मेरे सुर्गीय पिता की इच्छा पै चाल्लै वोए मेरा भाई, मेरी बेब्बे अर मेरी माँ सै।” ");
INSERT INTO bgc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","उस्से दिन यीशु घर तै लिकड़कै गलील समुन्दर कै किनारे जा बेठ्या। ");
INSERT INTO bgc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","अर उसकै धोरै इसी भीड़ कठ्ठी होई के वो किस्ती पै चढ़ग्या, अर सारी भीड़ किनारे पै खड़ी रही। ");
INSERT INTO bgc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","अर उसनै उनतै उदाहरणां म्ह घणीए बात कही “एक किसान बीज बोण लिकड़या। ");
INSERT INTO bgc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","बोंदे बखत कुछ बीज राही कै किनारे पड़े अर पंछियाँ नै आकै उन ताहीं चुग लिया। ");
INSERT INTO bgc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","कुछ बीज पथरीली धरती पै पड़े, जड़ै उनताही घणी माट्टी ना मिली अर डून्घी माट्टी ना मिलण कै कारण वे तोळाए जामगे। ");
INSERT INTO bgc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पर सूरज लिकड़णै पै वे जळगे, अर जड़ ना पकड़ण कै कारण सुखगे। ");
INSERT INTO bgc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कुछ बीज झाड़ियाँ म्ह पड़े, अर झाड़ियाँ नै बढ़कै उन ताहीं दाब लिया। ");
INSERT INTO bgc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","पर कुछ बीज आच्छी धरती पै पड़े, कोए सौ गुणा, कोए साठ गुणा, अर कोए तीस गुणा फळ ल्याए। ");
INSERT INTO bgc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जिसके कान हों, वो ध्यान तै सुण ले।” ");
INSERT INTO bgc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","चेल्यां नै धोरै आकै उसतै कह्या, “तू माणसां तै उदाहरणां म्ह क्यांतै बात करै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","उसनै जवाब दिया, “थारे ताहीं सुर्ग के राज्य के भेद की समझ दे राक्खी सै, पर उन ताहीं न्ही। ");
INSERT INTO bgc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","क्यूँके जिसकै धोरै सै, उसतै और दिया जावैगा, अर उसकै धोरै घणा हो जावैगा, पर जिसकै धोरै कुछ न्ही सै, उसतै जो कुछ उसकै धोरै सै, वो भी ले लिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","मै उनतै उदाहरणां म्ह ज्यांतै बात करुँ सूं, के वे देखदे होए कोनी देखदे अर सुणदे होए कोनी सुणदे, अर न्ही समझदे।” ");
INSERT INTO bgc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“उनकै बाबत यशायाह नबी की या भविष्यवाणी पूरी होवै सै: ‘थम सुणोगे, पर समझोगे कोनी, अर देक्खोगे, पर थमनै कोनी सूझैगा।’” ");
INSERT INTO bgc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","“क्यूँके इन माणसां का मन मोट्टा होग्या सै, अर वे कान्ना तै ऊँच्चा सुणै सै, अर उननै अपणी आँख मूंद ली सै, कदे इसा ना हो के वे आँखां तै देक्खै, अर कान्ना तै सुणै अर मन तै समझै, अर पलट जावै, अर मै उननै ठीक करुँ।” ");
INSERT INTO bgc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","पर धन्य सै थारी आँख, क्यूँके वे देक्खै सै, अर थारे कान क्यूँके वे सुणै सै। ");
INSERT INTO bgc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","मै थमनै साच्ची कहूँ सूं के घणखरे नबियाँ नै अर धर्मियाँ नै चाह्या के जो बात थम देक्खो सो, देक्खै, पर न्ही देख पाए, अर जो बात थम सुणो सो, सुणै, पर न्ही सुण पाए। ");
INSERT INTO bgc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“इब थम बोण आळे के उदाहरण का मतलब सुणो ");
INSERT INTO bgc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जो कोए राज्य का वचन सुणकै कोनी समझदा, यो वोए सै जो राही कै किनारे बोया गया था, उस ताहीं दुष्ट आकै खोस ले जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","अर जो पथरीली धरती पै बोया गया सै, यो वो माणस सै, जो वचन सुणकै जिब्बे खुशी कै गेल्या मान लेवै सै। ");
INSERT INTO bgc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पर अपणे म्ह जड़ न्ही पकड़ण कै कारण वो माड़े से दिन का सै, अर जिब वचन कै कारण क्ळेश या संकट आवै सै, तो जिब्बे ठोक्कर खावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जो झाड़ियाँ म्ह बोया गया, यो वो सै, जो वचन ताहीं सुणै सै, पर इस दुनिया की फिक्र अर धन का धोक्खा वचन नै दाबै सै, अर वो फळ कोनी ल्यांदा। ");
INSERT INTO bgc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","जो आच्छी धरती पै बोया गया, यो वो सै, जो वचन ताहीं सुणकै समझै सै, अर फळ ल्यावै सै, कोए सौ गुणा, कोए साठ गुणा, अर कोए तीस गुणा।” ");
INSERT INTO bgc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीशु नै उन ताहीं एक और उदाहरण दिया: “सुर्ग का राज उस किसान जिसा सै जिसनै अपणे खेत मै बढ़िया बीज बोया। ");
INSERT INTO bgc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पर जिब माणस सोवै थे तो उसका बैरी आकै गेहूँ कै बिचाळै जंगळी बीज बोकै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जिब अंकुर लिकड़े अर बाल लाग्गी, तो जंगळी दाण्या के पौधे भी दिखण लाग्गे।” ");
INSERT INTO bgc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“इसपै घरेलू नौकरां नै आकै उसतै कह्या, ‘हे माल्लिक, के तन्नै अपणे खेत म्ह बढ़िया बीज कोनी बोया था? फेर जंगळी दाण्या के पौधे उस म्ह कित्त तै आए?’” ");
INSERT INTO bgc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“उसनै उनतै कह्या, ‘यो किसे बैरी का काम सै।’ नौकरां नै कह्या, ‘के तेरी मर्जी सै के हम जाकै उन जंगळी पौधां नै कठ्ठे करा?’” ");
INSERT INTO bgc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“उसनै कह्या, ‘ना, इसा ना हो के जंगळी दाण्या के पौधे कठ्ठे करदे हाण थम उनकै गेल्या गेहूँ नै भी पाड़ ल्यो। ");
INSERT INTO bgc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","लामणी तक दोनुआ नै एक सेत्ती बधण द्यो, अर लामणी के बखत मै काटण आळा तै कहूँगा के पैहल्या जंगळी दाण्या के पौधे कठ्ठे करकै बाळण खात्तर उनके भरोट्टे जुड़ ल्यो, अर गेहूँ ताहीं मेरै खत्ते म्ह कठ्ठा करो’।” ");
INSERT INTO bgc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","उसनै उन ताहीं एक और उदाहरण दिया: “सुर्ग का राज राई कै एक दाणै की ढाळ सै, जिस ताहीं किसे माणस नै लेकै अपणे खेत म्ह बो दिया। ");
INSERT INTO bgc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","वो सारे बीज्जां तै छोट्टा तो होवै सै पर जिब बध जावै सै फेर सारे साग-पात तै बड्ड़ा होवै सै, अर इसा दरखत हो जावै सै के अकास के पंछी आकै उसकी डाळियाँ पै बसेरा करै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","उसनै एक और उदाहरण उन ताहीं सुणाया “सुर्ग का राज खमीर की ढाळ सै, जिस ताहीं किसे बिरबान्नी नै लेकै तीन पसेरी (पन्द्रह किलो) चून म्ह रळाया अर होन्दे-होन्दे वो सारा चून खमीर बणग्या।” ");
INSERT INTO bgc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ये सारी बात यीशु नै उदाहरणां म्ह माणसां तै सिखाई, अर इस तरियां की शिक्षा देण खात्तर वो उदाहरणां का ए इस्तमाल करया करदा। ");
INSERT INTO bgc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","के जो वचन नबी कै जरिये कह्या गया था, वो पूरा होवै: “मै उदाहरण कहण नै अपणा मुँह खोल्लूँगा, मै उन बात्तां नै जो दुनिया की शरुआत तै लुक्ही होई सै, जाहिर करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","फेर वो भीड़ नै छोड़कै घरां आया, अर उसके चेल्यां नै उसकै धोरै आकै कह्या, “खेत म्ह जंगळी दाणै का उदाहरण म्हारै ताहीं समझा दे।” ");
INSERT INTO bgc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","यीशु नै उन ताहीं जवाब दिया, “बढ़िया बीज का बोण आळा, मै माणस का बेट्टा सूं। ");
INSERT INTO bgc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","खेत दुनिया के लोग सै, बढ़िया बीज राज्य की ऊलाद, अर जंगळी बीज शैतान की ऊलाद सै। ");
INSERT INTO bgc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","जिस बैरी नै उन ताहीं बोया वो शैतान सै। लामणी दुनिया का खात्मा सै, अर काटण आळे सुर्गदूत सै।” ");
INSERT INTO bgc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","आखर म्ह जिस तरियां जंगळी पौधे कठ्ठे करे जावै अर बाळे जा सै उस्से तरियां दुनिया का खात्मा होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मै माणस का बेट्टा अपणे सुर्गदूत्तां नै भेज्जूँगा, अर वे उसकै राज्य म्ह तै सारे जो खुद पाप करै सै अर दुसरयां नै पाप करण खात्तर उकसावै सै, अर भुन्डे़ काम करणीया नै कठ्ठे करैगें। ");
INSERT INTO bgc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","अर उननै आग कै कुण्ड म्ह गेरैगें, जड़ै रोणा, अर दाँत पिसणा होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","उस बखत धर्मी लोग अपणे पिता कै राज्य म्ह सूरज की ढाळ चमकैगें। जिसके कान हों, वो ध्यान तै सुण ले। ");
INSERT INTO bgc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","सुर्ग का राज्य खेत म्ह लुह्के होड़ धन की ढाळ सै, जिस ताहीं किसे माणस नै पाया अर लह्को दिया, अर खुशी के मारे अपणा सारा कुछ बेच दिया अर उस खेत ताहीं मोल ले लिया। ");
INSERT INTO bgc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","फेर सुर्ग का राज्य एक व्यापारी की तरियां सै जो आच्छे मोतियाँ की टोह् म्ह था। ");
INSERT INTO bgc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जिब उसनै एक घणा महँगा मोत्ती मिल्या तो उसनै जाकै अपणा सारा कुछ बेच दिया अर उस ताहीं मोल ले लिया। ");
INSERT INTO bgc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","फेर उसनै कह्या, सुर्ग का राज्य उस मछली के बड़े जाळ की ढाळ सै जो समुन्दर म्ह गेरया जावै, अर हरेक ढाळ की मच्छी ताहीं समेट ल्यावै। ");
INSERT INTO bgc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","अर जिब जाळ भरग्या, तो मछुआरे उस ताहीं किनारे पै खींच ल्यावै, अर बैठकै बढ़िया-बढ़िया मच्छी तो बासणा म्ह कठ्ठी करी अर बेकार बगा दी। ");
INSERT INTO bgc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","दुनिया के अन्त म्ह इस तरियां ए होवैगा। सुर्गदूत आकै दुष्ट लोग्गां नै धर्मियाँ तै न्यारे करैगें, ");
INSERT INTO bgc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","अर सुर्गदूत, दुष्ट लोग्गां नै आग कै कुण्ड म्ह गेरैगें। जड़ै रोणा, अर दाँत पिसणा होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“के थमनै ये सारी बात समझी?” उननै उसतै कह्या, “हाँ।” ");
INSERT INTO bgc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","यीशु नै उनतै कह्या, “इस करकै हरेक शास्त्री जो सुर्ग कै राज्य का चेल्ला बण्या सै, उस घरवासे की तरियां सै जो अपणे भण्डार तै नयी अर पुराणी चीज काड्डै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जिब यीशु नै ये सारे उदाहरण कह लिये, तो ओड़ै तै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","अर अपणे नगर नासरत म्ह आकै उनकै आराधनालय म्ह उननै इसा उपदेश देण लागग्या के वे हैरान होकै कहण लाग्ये, “इसनै यो ज्ञान अर सामर्थ के काम कित्त तै मिले? ");
INSERT INTO bgc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","के यो खात्त्ती का छोरा कोनी? अर के इसकी माँ का नाम मरियम अर इसके भाईयाँ का नाम याकूब, यूसुफ, शमौन अर यहूदा कोनी? ");
INSERT INTO bgc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","अर के इसकी सारी बेब्बे म्हारै बिचाळै कोनी रह्न्दी? फेर इसनै यो सारा कित्त तै मिल्या?” ");
INSERT INTO bgc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","इस तरियां उननै उसकै कारण ठोक्कर खाई, पर यीशु नै उनतै कह्या, “नबी का अपणे गाम अर घर नै छोड़ और किते निरादर कोनी होन्दा।” ");
INSERT INTO bgc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","अर उसनै ओड़ै उनके अबिश्वास कै कारण घणे चमत्कार के काम न्ही करै। ");
INSERT INTO bgc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","उस बखत चौथाई देश के गलील परदेस के राजा हेरोदेस नै यीशु का जिक्र सुण्या, ");
INSERT INTO bgc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","अर उसनै अपणे नौकरां तै कह्या, “यो यूहन्ना बपतिस्मा देण आळा सै! वो मरे होया म्ह तै जिन्दा उठ्या सै, इस्से करकै उसतै ये सामर्थ के काम दिक्खै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","यूहन्ना ताहीं पकड़कै बाँधया अर जेळ म्ह गेर दिया था। क्यूँके हेरोदेस नै अपणे भाई फिलिप्पुस के जिन्दा रहन्दे उसकी घरआळी हेरोदियास ताहीं अपणे धोरै राखली थी, ");
INSERT INTO bgc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","क्यूँके यूहन्ना नै उसतै कह्या था के इस ताहीं राखणा मूसा के नियम-कायदा कै मुताबिक तेरे खात्तर ठीक कोनी। ");
INSERT INTO bgc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ज्यांतै वो उसनै मारणा चाहवै था, पर माणसां तै डरै था क्यूँके वे यूहन्ना नै नबी मान्नै थे। ");
INSERT INTO bgc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पर जिब हेरोदेस का जन्म दिन आया, तो हेरोदियास की बेट्टी नै त्यौहार म्ह नाच दिखाकै हेरोदेस ताहीं राज्जी करया। ");
INSERT INTO bgc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","इसपै उसनै कसम खाकै वचन भर लिया, “जो कुछ तू माँगैगी, मै तन्नै दियुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","वा अपणी माँ कै उकसाण तै बोल्ली, “यूहन्ना बपतिस्मा देण आळे का सिर थाळ म्ह उरै मन्नै मँगवा दे।” ");
INSERT INTO bgc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","राजा घणा दुखी होया, पर अपणी कसम, अर गेल्या बैठण आळा कै कारण, हुकम दिया के दे दिया जावै। ");
INSERT INTO bgc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","अर उसनै जेळ म्ह सैनिकां ताहीं भेजकै यूहन्ना का सिर कटवा दिया। ");
INSERT INTO bgc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","अर उसका सिर थाळ म्ह ल्याया गया अर छोरी ताहीं दिया गया, जिस ताहीं वा अपणी माँ धोरै लेगी। ");
INSERT INTO bgc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","फेर यूहन्ना के चेल्लें आए अर उसकी लाश ताहीं ले जाकै गाड़ दिया, अर जाकै यीशु ताहीं खबर दी। ");
INSERT INTO bgc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जिब यीशु नै सुण्या, तो वो किस्ती पै चढ़कै ओड़ै तै किसे सुनसान जगहां ताहीं, एकान्त म्ह चल्या गया। माणस न्यू सुणकै नगर-नगर तै पांए-पाँ उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","यीशु किनारे पै पुहुचा तो एक बड्डी भीड़ देक्खी अर उनपै तरस खाया, अर उनके बिमारां ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जिब साँझ होई तो उसकै चेल्यां नै उसकै धोरै आकै कह्या, “या सुनसान जगहां सै, अर वार होरी सै, माणसां ताहीं बिदा करया जावै के वे बस्तियाँ म्ह जाकै अपणे खात्तर खाणा मोल लियावै।” ");
INSERT INTO bgc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","पर यीशु नै उनतै कह्या, “उनका जाणा जरूरी कोनी! थमे इन्नै खाण नै द्यो।” ");
INSERT INTO bgc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","उननै यीशु तै कह्या, “उरै म्हारै धोरै पाँच रोट्टी अर दो मच्छियाँ नै छोड़कै और कुछ कोनी सै।” ");
INSERT INTO bgc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","यीशु बोल्या, “उन ताहीं उरै मेरै धोरै लियाओ।” ");
INSERT INTO bgc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","फेर यीशु नै माणसां ताहीं घास पै बैठण खात्तर कह्या, अर उन पाँच रोट्टी अर दो मच्छियाँ ताहीं लिया; सुर्ग कान्ही लखाकै खाणे खात्तर परमेसवर का धन्यवाद करया अर रोट्टी तोड़-तोड़कै चेल्यां ताहीं दी, अर चेल्यां नै माणसां ताहीं। ");
INSERT INTO bgc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","जिब सारे खाकै छिकगे, तो चेल्यां नै बचे होए टुकड्या तै भरी होई बारहां टोकरी ठाई। ");
INSERT INTO bgc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","अर खाण आळे लुगाईयाँ अर बाळकां नै छोड़कै, पाँच हजार माणसां कै करीबन थे। ");
INSERT INTO bgc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","फेर उसनै जिब्बे अपणे चेल्यां ताहीं किस्ती पै चढ़ण कै खात्तर मजबूर करया के वे उसतै पैहल्या पार चले जावै, जिब ताहीं वो अपणे माणसां ताहीं बिदा करै। ");
INSERT INTO bgc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","वो माणसां ताहीं बिदा करकै, प्रार्थना करण खात्तर उनतै अलग होकै पहाड़ पै चल्या गया; अर साँझ ताहीं वो ओड़ै एक्ला था। ");
INSERT INTO bgc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तब तक किस्ती समुन्दर कै किनारे तै भोत दूर जा ली थी अर झाल्लां तै थपेड़े खाकै डगमगाण लागरी थी, क्यूँके हवा स्याम्ही की थी। ");
INSERT INTO bgc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","यीशु सबेरै तीन बजे कै लोवै-धोवै यीशु समुन्दर पै चाल्दे होए उनकै धोरै आया। ");
INSERT INTO bgc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","चेल्लें उस ताहीं समुन्दर पै चाल्दे होए देखकै घबरागे। अर बोल्ले, “यो भूत सै!” अर भय के मारे किल्की मारण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","फेर यीशु नै जिब्बे उनतै बात करी अर बोल्या, “होसला राक्खो! मै सूं, डरो मतना!” ");
INSERT INTO bgc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस नै उसतै जवाब दिया, “हे प्रभु, जै तू ए सै, तो मन्नै अपणे धोरै पाणी पै चालकै आण का हुकम दे।” ");
INSERT INTO bgc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","यीशु बोल्या, “आ!” फेर पतरस किस्ती पै तै उतरकै यीशु कै धोरै जाण ताहीं पाणी पै चाल्लण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पर हवा नै देखकै डरग्या, अर जिब डूब्बण लाग्या तो किल्की मारकै बोल्या, “हे प्रभु, मन्नै बचा!” ");
INSERT INTO bgc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीशु नै जिब्बे हाथ बढ़ाकै थाम लिया अर उसतै बोल्या, “हे अल्पबिश्वासी, तन्नै क्यांतै शक करया?” ");
INSERT INTO bgc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जिब वे किस्ती पै चढ़गे, तो हवा थमगी। ");
INSERT INTO bgc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","इस घटना नै देखकै उसके चेल्यां नै जो किस्ती पै थे, उसकी बड़ाई करकै कह्या, “साच्चए, तू परमेसवर का बेट्टा सै।” ");
INSERT INTO bgc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","वे गलील समुन्दर पार करकै गन्नेसरत परदेस म्ह पोहचे। ");
INSERT INTO bgc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ओड़ै के माणसां नै उस ताहीं पिच्छाण लिया अर लोवै-धोवै के सारे देश म्ह खबर भेज दी, अर सारे बिमारां नै उसकै धोरै ल्याए। ");
INSERT INTO bgc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","अर उसतै बिनती करण लाग्गै के वे उननै अपणे लत्ते कै पल्ले तै ए छू लेण दे अर जितन्या नै उस ताहीं छुआ वे ठीक होगे। ");
INSERT INTO bgc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","फेर यरुशलेम नगर तै कुछ फरीसी अर शास्त्री यीशु कै धोरै आकै बोल्ले, ");
INSERT INTO bgc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“तेरे चेल्लें बुजुर्गां के रीति-रिवाजां ताहीं क्यांतै टाळै सै, क्यूँ बिना हाथ धोए रोट्टी खावै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","उसनै उन ताहीं जवाब दिया, “थम भी अपणी रीति-रिवाज कै कारण क्यांतै परमेसवर का हुकम टाळौ सो? ");
INSERT INTO bgc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","क्यूँके परमेसवर नै कह्या, ‘अपणे माँ-बाप की इज्जत कर, अर जो कोए माँ-बाप नै भुंडा बोल्लै, वो मार दिया जावै।’ ");
INSERT INTO bgc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पर थम कहो सो के जै कोए अपणे माँ-बाप तै कहवै, ‘जो कुछ मन्नै थारे ताहीं अपणी सम्पत्ति म्ह तै देणा था, वो मन्नै परमेसवर ताहीं अर्पण ताहीं कर दिया’, ");
INSERT INTO bgc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","तो वो पिता का आदर ना करै, इस तरियां थमनै अपणी रीत-रिवाजां कै कारण परमेसवर का वचन टाळ दिया। ");
INSERT INTO bgc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","हे कपटियों, यशायाह नबी नै थारे बारै म्ह या भविष्यवाणी ठीक करी सै” ");
INSERT INTO bgc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ये माणस होठ्ठां तै तो मेरा आदर करै सै, पर उनका मन मेरै तै दूर रहवै सै। ");
INSERT INTO bgc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“अर वे खांम-खा मेरी भगति करै सै, क्यूँके माणसां के तरीक्यां नै धर्म उपदेश करकै सिखावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","फेर उसनै माणसां ताहीं अपणे धोरै बुलाकै उनतै कह्या, “सुणो, अर समझो ");
INSERT INTO bgc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जो मुँह म्ह जावै सै, वो माणस नै अशुद्ध कोनी करदा, पर जो मुँह तै लिकड़ै सै, वोए माणस नै अशुद्ध करै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","फेर चेल्यां नै आकै उसतै कह्या, “के तन्नै बेरा सै के फरीसियाँ नै यो वचन सुणकै ठोक्कर खाई?” ");
INSERT INTO bgc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","उसनै जवाब दिया, “हरेक पौधा जो मेरै सुर्गीय पिता नै न्ही लगाया, उखाड़ा जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","उन ताहीं जाण द्यो; वे आन्धे राह बताणीये सै अर आन्धा जै आन्धे नै राह दिखावै, तो दोन्नु ए खड्डे म्ह गिरैगें।” ");
INSERT INTO bgc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","न्यू सुणकै पतरस नै उसतै कह्या, “यो उदाहरण म्हारै ताहीं समझा दे।” ");
INSERT INTO bgc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","यीशु नै उनतै कह्या, “के थम भी इब ताहीं नासमझ सो? ");
INSERT INTO bgc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","के थमनै न्ही बेरा के जो कुछ मुँह म्ह जावै वो पेट म्ह पड़ै सै, अर संडास कै जरिये लिकड़ जावै सै? ");
INSERT INTO bgc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पर जो कुछ मुँह तै लिकड़ै सै, वो मन तै लिकड़ै सै, अर वोए माणस ताहीं अशुद्ध करै सै। ");
INSERT INTO bgc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","क्यूँके भुन्डे़ विचार, हत्या, जारी, बिगान्नी बिरबान्नी धोरै जाणा, चोरी, झूठ्ठी गवाही अर बुराई मन तै ए लिकड़ै सै। ");
INSERT INTO bgc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","येए सै जो माणस नै अशुद्ध करै सै, पर हाथ बिना धोए रोट्टी खाणा माणस नै अशुद्ध कोनी करदा।” ");
INSERT INTO bgc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","यीशु ओड़ै तै लिकड़कै, सूर अर सैदा के परदेसां कान्ही चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","उस परदेस तै एक कनानी बिरबान्नी लिकड़ी, अर किल्की मारकै कहण लाग्गी, “हे प्रभु! दाऊद की ऊलाद, मेरै पै दया कर! मेरी बेट्टी ताहीं ओपरी आत्मा घणी सतावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पर यीशु नै उसतै कुछ जवाब कोनी दिया। फेर उसके चेल्यां नै आकै उसतै बिनती करी, “इस ताहीं बिदा करो, क्यूँके वा म्हारै पाच्छै रुक्के मारदी आवण लागरी सै।” ");
INSERT INTO bgc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","यीशु नै जवाब दिया, “इस्राएल कै कुण्बे की खोई होड़ भेड्डां नै छोड़ मै किसे कै धोरै कोनी भेज्या गया।” ");
INSERT INTO bgc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पर वा आई, अर यीशु ताहीं प्रणाम करकै कहण लाग्गी, “हे प्रभु, मेरी मदद कर।” ");
INSERT INTO bgc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","यीशु नै जवाब दिया, “छोरयां की रोट्टी लेकै कुत्त्या कै आग्गै गेरणा ठीक कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","उसनै कह्या, “साच्ची सै प्रभु, पर कुत्ते भी तो मेज कै तळै बाळकां की रोट्टी के टुकड़े खा लेवैं सै।” ");
INSERT INTO bgc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","इसपै यीशु नै उस ताहीं जवाब दिया, “हे नारी, तेरा बिश्वास पक्का सै। जिसा तू चाहवै सै, तेरे खात्तर उसाए हो।” अर उसकी बेट्टी उस्से घड़ी तै चंगी होग्यी। ");
INSERT INTO bgc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीशु ओड़ै तै गलील समुन्दर कै धोरै आया, अर पहाड़ पै चढ़कै बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","फेर भीड़ की भीड़ उसकै धोरै आई। वे अपणे गेल्या लंगड़ा नै, आन्धा नै, टुंडयाँ नै, गूंगया नै अर दुसरे घणेए माणसां नै उसकै धोरै ल्याए, अर उन ताहीं उसके पायां म्ह गेर दिया, अर उसनै उन ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जिब माणसां नै देख्या के गूँगे बोल्लै सै, अर टुंडे चंगे होवै सै, अर लंगड़े चाल्लै सै, अर आन्धे देक्खै सै तो हैरान होकै इस्राएल के परमेसवर की बड़ाई करी। ");
INSERT INTO bgc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीशु नै अपणे चेल्यां ताहीं बुलाया अर कह्या, “मन्नै इस भीड़ पै तरस आवै सै, क्यूँके वे तीन दिनां तै मेरै गेल्या सै अर उनकै धोरै कुछ खाण नै भी कोनी। मै उननै भूक्खा बिदा करणा न्ही चाह्न्दा, कदे इसा ना हो राह म्ह थक हार कै बेहोस हो जावै।” ");
INSERT INTO bgc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","चेल्यां नै उसतै कह्या, “हमनै इस बण म्ह कित्त तै इतनी रोट्टी मिलैगी के हम इतनी बड्डी भीड़ ताहीं छिकावा?” ");
INSERT INTO bgc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीशु नै उनतै बुझ्झया, “थारे धोरै कितनी रोट्टी सै?” उननै कह्या, “सात, अर माड़ी-सी छोट्टी मच्छी।” ");
INSERT INTO bgc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","फेर उसनै माणसां ताहीं धरती पै बैठण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","अर उन सात रोट्टी अर मच्छियाँ ताहीं लिया, परमेसवर का धन्यवाद करकै तोड्या, अर अपणे चेल्यां ताहीं देन्दा गया, चेल्लें माणसां ताहीं। ");
INSERT INTO bgc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","इस तरियां सारे खाकै छिकगे अर चेल्यां नै बचे होड़ टुकड्या तै सात टोकरे ठाए। ");
INSERT INTO bgc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","खाण आळे बिरबानियाँ अर बाळकां नै छोड़कै चार हजार माणस थे। ");
INSERT INTO bgc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","जिब वो भीड़ नै बिदया करकै किस्ती म्ह चढ़ग्या अर मगदन देश की सीमा म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","फरीसियाँ अर सदूकियाँ नै धोरै आकै उस ताहीं परखण कै खात्तर उसतै कह्या, “हमनै सुर्ग की कोए निशान्नी दिखा।” ");
INSERT INTO bgc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","उसनै उन ताहीं जवाब दिया, “साँझ नै थम कहो सो, ‘मौसम खुला रहवैगा, क्यांतैके अकास लाल सै’, ");
INSERT INTO bgc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","अर तड़कैए नै कहो सो, ‘आज आँधी आवैगी, क्यूँके अकास लाल अर धूळ-भरया सै।’ थम अकास के लछण देखकै उसका भेद बता सको सो, पर आज कै बखत म्ह जो होण लाग रह्य सै उसनै देखकै भेद क्यूँ न्ही बता सकदे? ");
INSERT INTO bgc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","इस युग के बुरे अर जार माणस चिन्ह-चमत्कार टोह्वैं सै, पर योना नबी के चिन्ह-चमत्कार नै छोड़ उन ताहीं और कोए चिन्ह-चमत्कार कोनी दिया जावैगा।” अर वो उननै छोड़कै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","चेल्लें समुन्दर कै परली ओड़ पोहचे, पर वे रोट्टी लेणा भूलगे थे। ");
INSERT INTO bgc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीशु नै उनकी कपट रूपी शिक्षा के बारें म्ह उनतै कह्या, “देक्खो, फरीसियाँ अर सदूकियाँ कै खमीर तै चौकन्ने रहियो।” ");
INSERT INTO bgc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","वे आप्पस म्ह विचार करण लाग्गे, “हम रोट्टी कोनी ल्याए ज्यांतै वो इस तरियां कहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","न्यू जाणकै यीशु नै उनतै कह्या, “हे अल्प बिश्वासियों, थम क्यांतै विचार करो सो के म्हारै धोरै रोट्टी कोनी सै? ");
INSERT INTO bgc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","के थम इब ताहीं न्ही समझे? के थमनै उन पाँच हजार की पाँच रोट्टी याद कोनी, अर ना यो के थमनै कितनी टोकरियाँ ठाई थी? ");
INSERT INTO bgc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","अर उन चार हजार की सात रोट्टी, अर ना यो के थमनै कितने टोकरे ठाए थे? ");
INSERT INTO bgc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","थम क्यांतै न्ही समझदे के मन्नै थारे तै रोटियाँ कै बाबत न्ही कह्या, पर यो के फरीसियाँ अर सदूकियाँ के खमीर तै चौकन्ने रहियो।” ");
INSERT INTO bgc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","फेर उनकै समझ म्ह आया के उसनै रोट्टी कै खमीर तै न्ही, पर फरीसियाँ अर सदूकियाँ की शिक्षा तै चौकन्ने रहण नै कह्या था। ");
INSERT INTO bgc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","यीशु कैसरिया फिलिप्पी के परदेस म्ह आया, अर अपणे चेल्यां तै बुझ्झण लाग्या, “लोग मुझ माणस कै बेट्टे नै के कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","वे बोल्ले, “कुछ तो यूहन्ना बपतिस्मा देण आळा कहवै सै, अर कुछ एलिय्याह, अर कुछ यिर्मयाह या नबियाँ म्ह तै कोए एक कहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","उसनै उनतै कह्या, “पर थम मन्नै के कहो सो?” ");
INSERT INTO bgc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","शमौन पतरस नै जवाब दिया, “तू जिन्दे परमेसवर का बेट्टा मसीह सै।” ");
INSERT INTO bgc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीशु नै उस ताहीं जवाब दिया, “हे शमौन, योना के बेट्टे, तू धन्य सै; क्यूँके माँस अर लहू नै न्ही, पर मेरै पिता नै जो सुर्ग म्ह सै, या बात तेरे पै जाहिर करी सै। ");
INSERT INTO bgc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","अर मै भी तेरे तै कहूँ सूं के तू पतरस सै, अर मै इस पत्थर पै अपणी कलीसिया बणाऊँगा, अर अधोलोक के फाटक उसपै हावी कोनी होवैगें। ");
INSERT INTO bgc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मै तन्नै सुर्ग के राज्य की ताळी दियुँगा जो कुछ तू धरती पै बांधैगा, वो सुर्ग म्ह बंधैगा; अर जो तू धरती पै खोलैगा, वो सुर्ग म्ह खुलैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","फेर उसनै चेल्यां ताहीं चिताया के किसे तै ना कहियो के मै मसीह सूं। ");
INSERT INTO bgc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","उस बखत तै यीशु अपणे चेल्यां तै बताण लाग्या, “जरूरी सै के मै यरुशलेम म्ह जाऊँ अर यहूदी अगुवें, प्रधान याजकां, शास्त्रियाँ के हाथ्थां तै घणा दुख ठाऊँ; अर मार दिया जाऊँ; अर तीसरे दिन जी उठूँ।” ");
INSERT INTO bgc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","इसपै पतरस उसनै न्यारा ले जाकै झिड़कण लाग्या, “हे प्रभु, परमेसवर इसा ना करै! तेरे गेल्या इसा कदे ना होवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","उसनै पलटकै पतरस तै कह्या, “हे शैतान, मेरै स्याम्ही तै दूर हो! तू मेरै खात्तर ठोक्कर का कारण सै; क्यांतैके तू परमेसवर की बात्तां पै न्ही, पर माणसां की बात्तां पै मन लगावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","फेर यीशु नै अपणे चेल्यां तै कह्या, “जो कोए मेरा चेल्ला बणणा चाहवै, वो अपणी ए इच्छा पूरी ना करै बल्के अपणे दुखां का क्रूस ठाकै, मेरै पाच्छै हो लेवै। ");
INSERT INTO bgc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","क्यूँके जो अपणी जान बचाणा चाहवैगा, वो उसनै खोवैगा; अर जो कोए मेरै खात्तर जान खोवैगा, वो उसनै पावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","जै माणस सारी दुनिया नै पा लेवै, अर अपणी जान का नुकसान ठावै, तो उसनै के फायदा होगा? या माणस अपणी जान कै बदले के देवैगा? ");
INSERT INTO bgc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","मै माणस का बेट्टा अपणे सुर्गदूत्तां कै गेल्या अपणे पिता की महिमा म्ह आऊँगा, अर उस बखत ‘मै हरेक नै उसकै काम्मां कै मुताबिक प्रतिफळ देऊँगा।’ ");
INSERT INTO bgc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“मै थारे तै साच्ची कहूँ सूं जो आड़ै खड़े सै उन म्ह तै कुछ इसे सै के जिब तक वे मुझ माणस के बेट्टे नै उसके राज्य म्ह आन्दे होए ना देख लेगें तब ताहीं मौत उननै छू भी न्ही पावैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छ: दिनां पाच्छै यीशु नै पतरस अर याकूब अर उसके भाई यूहन्ना ताहीं गेल्या लिया, अर उन ताहीं एक्ले म्ह किसे ऊँच्चे पहाड़ पै लेग्या। ");
INSERT INTO bgc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ओड़ै उनकै स्याम्ही उसका रूप म्ह बदलाव होया, अर उसका मुँह सूरज की ढाळ चमक्या अर उसके लत्ते चाँदणे की ढाळ धोळे होग्ये। ");
INSERT INTO bgc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","अर मूसा नबी अर एलिय्याह उसकै गेल्या बात करदे होड़ दिक्खे। ");
INSERT INTO bgc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","इसपै पतरस नै यीशु तै कह्या, “हे प्रभु, म्हारा उरै रहणा ठीक सै। जै तेरी मर्जी हो तो मै उरै तीन मण्डप बणाऊँ, एक तेरे खात्तर, एक मूसा नबी खात्तर, एक एलिय्याह नबी खात्तर।” ");
INSERT INTO bgc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","वो बोल्लणए लागरया था के एक चमकदा होया बादळ उनपै छाग्या, अर उस बादळ म्ह तै या वाणी लिकड़ी, “यो मेरा प्यारा बेट्टा सै, जिसतै मै राज्जी सूं: इसकी सुणो।” ");
INSERT INTO bgc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","चेल्लें न्यू सुणकै मुँह कै बळ गिरगे अर घणे डरगे। ");
INSERT INTO bgc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","यीशु नै धोरै आकै उन ताहीं छुया, अर बोल्या, “उठो, डरो मतना।” ");
INSERT INTO bgc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","फेर उननै अपणी निगांह करी अर यीशु नै छोड़ और किसे ताहीं कोनी देख्या। ");
INSERT INTO bgc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जिब वे पहाड़ पै तै उतरण लागरे थे, तो यीशु नै उनतै यो हुकम दिया, “जिब ताहीं मै माणस का बेट्टा मरे होया म्ह तै जिन्दा न्ही हो जाऊँगा, तब ताहीं जो कुछ थमनै देख्या सै किसे तै ना कहियो।” ");
INSERT INTO bgc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","इसपै उसके चेल्यां नै उसतै बुझ्झया, “फेर शास्त्री क्यांतै कहवै सै के एलिय्याह का पैहल्या आणा जरूरी सै।” ");
INSERT INTO bgc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","उसनै जवाब दिया, “एलिय्याह जरुर आवैगा, अर सारा कुछ सुधरैगा। ");
INSERT INTO bgc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पर मै थमनै कहूँ सूं के एलिय्याह आ लिया, अर माणसां नै उस ताहीं न्ही पिच्छाणा, पर जिसा चाह्या उसाए उसकै गेल्या करया। इस तरियां तै मै माणस का बेट्टा भी उनकै हाथ्थां तै दुख ठाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","फेर चेल्यां नै समझया के उसनै म्हारै तै यूहन्ना बपतिस्मा देणीये कै बाबत कह्या सै। ");
INSERT INTO bgc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","जिब वो भीड़ कै धोरै पोहचे, तो एक माणस उसकै धोरै आया, अर गोड्डे टेक कै कहण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“हे प्रभु, मेरे बेट्टे पै दया कर! क्यूँके उस ताहीं मिर्घी आवै सै, अर वो घणा दुख ठावै सै; अर बार-बार आग म्ह अर बार-बार पाणी म्ह पड़ ज्या सै। ");
INSERT INTO bgc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","अर मै उसनै तेरे चेल्यां धोरै ल्याया था, पर वे उसनै ठीक कोनी कर सके।” ");
INSERT INTO bgc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","यीशु नै जवाब दिया, “हे अबिश्वासी अर जिद्दी माणसों, मै कद ताहीं थारे गेल्या रहूँगा? कद ताहीं थारी सहूँगा? उसनै उरै मेरै धोरै ल्याओ।” ");
INSERT INTO bgc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","फेर यीशु नै ओपरी आत्मा ताहीं धमकाया, वा उस म्ह तै लिकड़ग्यी अर छोरा उस्से बखत ठीक होग्या। ");
INSERT INTO bgc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","फेर चेल्यां नै एक्ले म्ह यीशु कै धोरै आकै कह्या, “हम उसनै क्यांतै न्ही काढ सके?” ");
INSERT INTO bgc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","उसनै उनतै कह्या, “अपणे बिश्वास की कमी कै कारण, क्यूँके मै थमनै साच्ची कहूँ सूं, जै थारा बिश्वास राई कै दाणै कै बराबर भी हो, तो इस पहाड़ तै कह सकोगे, ‘उरै तै सरककै ओड़ै चल्या जा’, तो वो चल्या जावैगा, अर कोए बात थारे खात्तर मुश्किल कोनी होवैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(पर या जात बिना प्रार्थना अर ब्रत कै कोनी लिकड़दी।) ");
INSERT INTO bgc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जिब वे गलील परदेस म्ह थे, तो यीशु नै उनतै कह्या, “मै माणस का बेट्टा माणसां के हाथ्थां म्ह पकड़वाया जाऊँगा। ");
INSERT INTO bgc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","वे मन्नै मार देवैगें, अर मै तीसरे दिन जिन्दा हो जाऊँगा।” इसपै वे घणे उदास होए। ");
INSERT INTO bgc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जिब वे कफरनहूम पोहचे, तो मन्दर का कर लेण आळा नै पतरस कै धोरै आणकै बुझ्झया, “के थारा गुरु, मन्दर का कर कोनी देंदा?” ");
INSERT INTO bgc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","उसनै कह्या, “हाँ, देवै सै।” जिब वो घरां आया, तो यीशु नै उसकै बुझ्झण तै पैहल्याए उसतै कह्या, “हे शमौन, तू के सोच्चै सै? धरती के राजा चुंगी किन तै लेवै सै? अपणे बेट्याँ तै या बिगान्याँ तै?” ");
INSERT INTO bgc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरस नै उसतै कह्या “बिगान्याँ तै।” यीशु नै उसतै कह्या “तो बेट्टे बचगे। ");
INSERT INTO bgc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","तोभी इस खात्तर के हम उननै ठोक्कर ना खुवावा, तू झील कै किनारे जाकै कांडा गेर, अर जो मच्छी पैहले लिकड़ै, उसनै ले, उसका मुँह खोल्लण पै तेरे ताहीं एक सिक्का (जिसकी किम्मत चार दिन की मजदूरी के बराबर हो सै) मिलैगा, उस्से नै लेकै मेरै अर अपणे बदले म्ह दे दिये।” ");
INSERT INTO bgc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","उस घड़ी चेल्लें यीशु कै धोरै आकै बुझ्झण लाग्गे, “सुर्ग कै राज्य म्ह बड्ड़ा कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","इसपै उसनै एक बाळक ताहीं धोरै बुलाकै उनकै बिचाळै खड्या करया, ");
INSERT INTO bgc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","अर कह्या, “मै थमनै सच कहूँ सूं के जिब ताहीं थम न्ही बदलो अर बाळकां की ढाळ नम्र न्ही बणो, थम सुर्ग कै राज्य म्ह बड़ न्ही सकदे। ");
INSERT INTO bgc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जो कोए अपणे-आपनै इस बाळक की ढाळ छोट्टा करैगा, वो सुर्ग कै राज्य म्ह बड्ड़ा होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","अर जो कोए मेरै नाम तै एक इसे बाळक ताहीं अपणावै सै वो मन्नै अपणावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","पर जो कोए इन छोट्या बाळकां समान जो मेरै पै बिश्वास करै सै, किसे तै भी पाप करवावै, तो उसकै खात्तर भला योए सै के एक बड्डी चाक्की का पाट उसकै गळ म्ह लटकाया जावै, अर वो डून्घा समुन्दर म्ह डबोया जान्दा। ");
INSERT INTO bgc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ठोकरां कै कारण दुनिया पै हाय! ठोकरां का लागणा जरूरी सै; पर धिक्कार सै उस माणस पै जिसकै जरिये ठोक्कर लाग्गै सै। ");
INSERT INTO bgc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","जै तेरा हाथ या तेरा पैर तेरे तै पाप करवावै सै, तो उसनै काटकै बगा दे, टुंडा या लंगड़ा होकै जीवन म्ह दाखल होणा इसतै भला सै के दो हाथ या दो पैर रहंदे होए तू अनन्त आग म्ह गेरया जावै। ");
INSERT INTO bgc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","जै तेरी आँख तेरे तै पाप करवावै सै, तो उस ताहीं लिकाड़कै फैक दे, काणा होकै अनन्त जीवन म्ह बड़णा तेरे खात्तर भला सै, ना के दो आँख रहंदे होए तू नरक की आग म्ह गेरया जावै। ");
INSERT INTO bgc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","देक्खो, थम इन छोट्या म्ह तै किसे नै तुच्छ ना जाणीयो, क्यूँके मै थमनै कहूँ सूं के सुर्ग म्ह उनके सुर्गदूत मेरे सुर्गीय पिता की मौजूदगी म्ह सदा रहवै सै। ");
INSERT INTO bgc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(क्यूँके मै माणस का बेट्टा खोये होया नै बचाण आया सूं।) ");
INSERT INTO bgc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","थारा इसके बारें म्ह के विचार सै? जै किसे माणस की सौ भेड़ हों, अर उन म्ह तै एक भटक जावै, तो के वो निन्यानवे ताहीं छोड़कै, अर पहाड़ां पै जाकै, उस भटकी होई नै कोनी टोहवैगा? ");
INSERT INTO bgc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","अर जै इसा हो के उसनै पावै, तो मै थमनै साच्ची कहूँ सूं, के वो उन निन्यानवे भेड्डां कै खात्तर जो भटकी कोनी थी, इतणा आनन्द कोनी करैगा जितना के इस भेड़ कै खात्तर करैगा। ");
INSERT INTO bgc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","इस्से ढाळ थारे पिता की जो सुर्ग म्ह सै या मर्जी कोनी के इन छोट्यां म्ह तै एक भी नाश हो। ");
INSERT INTO bgc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“जै तेरा बिश्वासी भाई तेरे खिलाफ कसूर करै, तो जा अर एक्ले म्ह बतळा कै उसनै समझा, जै वो तेरी सुणकै पछतावै तो तन्नै अपणे भाई ताहीं पा लिया। ");
INSERT INTO bgc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","जै वो तेरी न्ही सुणै, तो एक या दो जन नै अपणे गेल्या और ले जा, क्यूँके मूसा नबी के नियम-कायदा के मुताबिक ‘हरेक बात दो या तीन तै ज्यादा गवाह के स्याम्ही सच साबित हो जावै।’ ");
INSERT INTO bgc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","जै वो उनकी भी न्ही मान्नै, तो कलीसिया तै कह दे, पर जै वो कलीसिया की भी कोनी मान्नै तो तू यो समझ ले के वो गैर यहूदी अर चुंगी लेण आळे जिसा सै।” ");
INSERT INTO bgc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“मै थमनै साच्ची कहूँ सूं, जो कुछ थम धरती पै बांधोगे, वो सुर्ग म्ह बंधैगा अर जो कुछ थम धरती पै खोल्लोगे, वो सुर्ग म्ह खुलैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“फेर मै थमनै कहूँ सूं, जै थारे म्ह तै दो जणे धरती पै किसे बात कै खात्तर एक मन होकै बिनती करै, तो वा मेरे पिता की ओड़ तै जो सुर्ग म्ह सै, उनकै खात्तर हो जावैगी। ");
INSERT INTO bgc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","क्यूँके जड़ै दो या तीन मेरै नाम पै कठ्ठे होवै सै, ओड़ै मै उनकै बिचाळै म्ह होऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","जिब पतरस नै धोरै आकै उसतै कह्या, “हे प्रभु, जै मेरा भाई कसूर करदा रहवै, तो मै कितनी बार उस ताहीं माफ करुँ? के सात बार?” ");
INSERT INTO bgc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीशु नै उसतै कह्या, “मै तेरे तै यो न्ही कहन्दा के सात बार, बल्के सात बार के सत्तर गुणा तक माफ करिये।” ");
INSERT INTO bgc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“इस करकै सुर्ग के राज्य की तुलना इस उदाहरण तै करी जा सकै सै, किसे राजा नै अपणे नौकरां का लेक्खा (ब्यौरा) लेणा चाह्या। ");
INSERT INTO bgc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जिब वो लेक्खा लेण लाग्या, तो एक जणा उसकै स्याम्ही ल्याया गया जो दस हजार तोड़े का कर्जवान था। ");
INSERT INTO bgc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","जिब के चुकता करण नै उसकै धोरै कुछ कोनी था, तो उसकै माल्लिक नै कह्या, ‘यो अर इसकी घरआळी अर बाळ-बच्चे अर जो कुछ इसका सै सारा बेच्या जावै, अर कर्ज चुकता करया जावै।’” ");
INSERT INTO bgc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“इसपै उस नौक्कर नै उसके पायां म्ह पड़कै उस ताहीं कह्या, ‘हे राजा धीरज धर, मै सारा कुछ भर दियुँगा।’ ");
INSERT INTO bgc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","इसपै राजा नै तरस खाकै उस नौक्कर ताहीं छोड़ दिया, अर उसका कर्जा भी माफ कर दिया।” ");
INSERT INTO bgc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“पर जिब वो नौक्कर बाहरणै लिकड़या, तो उसके साथ के नौकरां म्ह तै एक उसतै मिल्या जो उसके सौ दीनार (100 दिन की मजदूरी) का कर्जदार था; उसनै पकड़कै उसका गळा घोट्या अर कह्या, ‘जो कुछ मेरा तेरे पै कर्ज सै भर दे।’” ");
INSERT INTO bgc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“इसपै उसका साथ का नौक्कर पायां म्ह पड़कै उसतै बिनती करण लाग्या, ‘धीरज धर, मै सारा कुछ भर दियुँगा।’” ");
INSERT INTO bgc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","वो न्ही मान्या, पर जाकै उस ताहीं जेळ म्ह गेर दिया के जिब ताहीं कर्जा ना भर दे, तब तक ओड़ैए रहवै। ");
INSERT INTO bgc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","उसके गेल्या के नौक्कर यो जो होया था देखकै घणे उदास होए, अर जाकै अपणे राजा ताहीं पूरा हाल बता दिया। ");
INSERT INTO bgc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“फेर राजा नै उस ताहीं बुलाकै उसतै कह्या, ‘हे दुष्ट नौक्कर, तन्नै जो मेरै तै बिनती करी, तो मन्नै तेरा वो सारा कर्जा माफ कर दिया। ");
INSERT INTO bgc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ज्यांतै जिस ढाळ मन्नै तेरे पै दया करी, उस्से तरियां के तन्नै भी अपणे साथ के नौक्कर पै दया न्ही करणी चाहिये थी?’ ");
INSERT INTO bgc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","अर उसकै माल्लिक नै छो म्ह आकै उस ताहीं दण्ड देणआळे के हाथ्थां म्ह सौप दिया, के जिब ताहीं वो सारा कर्जा भर न्ही देवै, तब तक उनकै हाथ्थां म्ह रहवै। ");
INSERT INTO bgc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“इस्से ढाळ जै थारे म्ह तै अपणे भाई नै ना माफ करै तो मेरा पिता जो सुर्ग म्ह सै थारे तै उसाए करैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","जिब यीशु नै ये बात कह ली, तो गलील परदेस तै चल्या गया; अर यरदन नदी कै परली ओड़ यहूदिया परदेस म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","फेर बड्डी भीड़ उसकै पाच्छै हो ली, अर उसनै ओड़ै उन ताहीं चंगा करया। ");
INSERT INTO bgc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","फेर फरीसी उसनै परखण खात्तर धोरै आकै बोल्ले, “के किसे भी कारण तै अपणी घरआळी ताहीं छोड़णा ठीक सै?” ");
INSERT INTO bgc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","उसनै जवाब दिया, “के थमनै न्ही पढ़्या के जिसनै उन ताहीं बणाया, उसनै शरुआत तै नर अर नारी बणाकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","इस कारण माणस अपणे माँ-बाप तै न्यारा होकै अपणी घरआळी कै गेल्या रहवैगा अर वे दोन्नु एकए तन होवैगें? ");
INSERT INTO bgc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","इस करकै इब वे दो न्ही, पर एक तन सै। इस करकै जिन ताहीं परमेसवर नै जोड़या सै, उन ताहीं माणस न्यारा ना करै।” ");
INSERT INTO bgc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","उननै उसतै कह्या, “फेर मूसा नबी नै यो क्यातै ठहराया के तलाक देकै उस ताहीं छोड़दे?” ");
INSERT INTO bgc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","उसनै उनतै कह्या, “मूसा नबी नै थारे मन की कठोरता कै कारण थारे तै अपणी-अपणी घरआळी ताहीं छोड़ देण का हुकम दिया, पर शरुआत म्ह इसा कोनी था। ");
INSERT INTO bgc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","अर मै थमनै कहूँ सूं, के जो कोए जारी नै छोड़कै और किसे कारण तै अपणी घरआळी नै छोड़कै दुसरा ब्याह करै, वो जारी करै सै, जो उस छोड्डी होई तै ब्याह करै, वो भी जारी करै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेल्यां नै यीशु तै कह्या, “जै माणस का बिरबान्नी कै गेल्या इसा सम्बन्ध सै, तो ब्याह करणा आच्छा कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","यीशु नै उनतै कह्या, “हरेक कोए इन उपदेशां पै चाल न्ही सकदे, सिर्फ वे जिन ताहीं या शक्ति देई गई सै। ");
INSERT INTO bgc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","क्यूँके कुछ नपुंसक इसे सै, जो माँ के पेट या गर्भ ए तै इसे जन्मे; अर कुछ नपुंसक इसे सै, जिन ताहीं माणस नै नपुंसक बणाया; अर कुछ नपुंसक इसे सै, जिन नै सुर्ग कै राज्य कै खात्तर खुद ताहीं नपुंसक बणाया सै। जो इस बात ताहीं समझ सकै सै, वे समझ ले।” ");
INSERT INTO bgc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","फेर माणस बाळकां नै उसकै धोरै ल्याए, के वो उनकै उप्पर हाथ धरै अर प्रार्थना करै; पर चेल्यां नै उन ताहीं धमकाया। ");
INSERT INTO bgc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीशु नै कह्या, “बाळकां नै मेरै धोरै आण द्यो, अर उन ताहीं मना मतना करो, क्यूँके सुर्ग का राज्य इसाए का सै।” ");
INSERT INTO bgc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","अर वो उनपै हाथ धरकै ओड़ै तै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","एक माणस यीशु कै धोरै आया अर उसतै कह्या, “हे गुरु, मै कौण सा भला काम करुँ के अनन्त जीवन पाऊँ?” ");
INSERT INTO bgc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीशु नै उसतै कह्या, “तू मेरै तै भलाई कै बाबत क्यातै बुझ्झै सै? भला तो एकैए सै, पर जै तू जीवन म्ह दाखल होणा चाहवै सै, तो हुकमां नै मान्या कर।” ");
INSERT INTO bgc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","उसनै यीशु तै कह्या, “कौण-से हुकम?” यीशु बोल्या, “खून ना करियो, जारी ना करियो, चोरी ना करियो, झूठ्ठी गवाही ना दियो, ");
INSERT INTO bgc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अपणे माँ-बाप का आदर करियो, अर अपणे पडौसी तै अपणे जिसा प्यार राखियो।” ");
INSERT INTO bgc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","उस जवान नै उसतै कह्या, “इन सारया ताहीं तो मन्नै मान्या सै, इब मन्नै किस बात की कमी सै?” ");
INSERT INTO bgc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीशु नै उसतै कह्या, “जै तू सिध्द होणा चाहवै सै तो जा, अपणा सारा माळ बेचकै कंगालां ताहीं दे, अर तन्नै सुर्ग म्ह धन मिलैगा; अर आकै मेरा चेल्ला बणण खात्तर मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","पर वो जवान या बात सुणकै उदास होकै चल्या गया, क्यूँके वो घणा साहूकार था। ");
INSERT INTO bgc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","फेर यीशु नै अपणे चेल्यां तै कह्या, “मै थमनै साच्ची कहूँ सूं के साहूकार का सुर्ग के राज्य म्ह बड़णा ओक्खा सै। ");
INSERT INTO bgc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","थारे ताहीं फेर कहूँ सूं के जिस तरियां तै ऊँट का सूई कै मोरै म्ह तै लिकड़णा आसान हो सकै सै। पर परमेसवर के राज्य म्ह साहूकार का बड़णा भोत मुश्किल सै।” ");
INSERT INTO bgc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","न्यू सुणकै चेल्यां नै हैरान होकै कह्या, “फेर किसका उद्धार हो सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीशु नै उनकी ओड़ लखाकै कह्या, “माणसां तै तो यो कोनी हो सकदा, पर परमेसवर तै सारा कुछ हो सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","इसपै पतरस नै उसतै कह्या, “देख, हम तो सारा कुछ छोड़कै तेरे पाच्छै हो लिए सा: तो हमनै के मिलैगा?” ");
INSERT INTO bgc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीशु नै उनतै कह्या, “मै थमनै साच्ची कहूँ सूं के नयी सृष्टि म्ह जिब माणस का बेट्टा अपणी महिमा के सिंहासन पै बैठैगा, तो थम भी जो मेरै पाच्छै हो लिए सो, बारहां सिंहासनां पै बैठकै इस्राएल के बारहां गोत्रां का न्याय करोगे। ");
INSERT INTO bgc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अर जिस किसे नै घर, या भाई-भाण, या माँ-बाप, या बाळ-बच्चे, या खेत्तां ताहीं मेरै नाम कै खात्तर छोड़ दिया सै, उस ताहीं सौ गुणा मिलैगा, अर वो अनन्त जीवन का हकदार होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पर भोत-से जो पैहले सै, पाच्छले होंगे; अर जो पाच्छले सै, पैहले होंगे।” ");
INSERT INTO bgc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","यीशु नै अपणे चेल्यां ताहीं सिखाण खात्तर एक और उदाहरण दिया, “सुर्ग का राज्य किसे घर के माल्लिक की ढाळ सै, जो तड़कैए लिकड़या के अपणे अंगूर के बाग म्ह मजदूरां नै लावै। ");
INSERT INTO bgc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","वो मजदूरां नै एक दीनार (एक दिन की मजदूरी) रोज की दिहाड़ी पै ल्याया अर उननै अपणे अंगूर के बाग म्ह भेज्या।” ");
INSERT INTO bgc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“फेर सबेरै के नौ बजे पाच्छै उसनै लिकड़कै और माणसां ताहीं बजार म्ह खड़े देख्या, ");
INSERT INTO bgc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","अर उसनै कह्या, ‘थम भी अंगूर के बाग म्ह जाओ, अर मै एक दिन की जो भी मजदूरी थारी बणै सै वा थमनै दियुँगा।’ अर वे भी काम पै चले गये। ");
INSERT INTO bgc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","फेर उसनै बारहां बजे अर तीन बजे कै लोवै लिकड़कै उस्से तरियां करया। ");
INSERT INTO bgc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","तकरीबन पाँच बजे फेर वो अपणे घर तै गया अर उसनै फेर कई माणसां ताहीं ओड़ै खड़े देख्या, अर उसनै कह्या, ‘थम क्यांतै सारे दिन उरै बेकार खड़े रहों सों?’ उननै उसतै कह्या, ‘ज्यांतै के किसे नै म्हारै ताहीं मजदूरी पै कोनी लगाया।’” ");
INSERT INTO bgc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“उसनै उनतै कह्या, ‘थम भी मेरे अंगूर के बाग म्ह काम करण खात्तर जाओ।’” ");
INSERT INTO bgc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“साँझ नै अंगूर के बाग के माल्लिक नै अपणे भण्डारी तै कह्या, ‘मजदूरां ताहीं बुलाकै पाच्छल्यां तै लेकै पैहल्या ताहीं उननै मजदूरी दे-दे।’” ");
INSERT INTO bgc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“जो पाँच बजे लगाये थे, उन ताहीं एक-एक दीनार (एक दिन की मजदूरी) मिल्या। ");
INSERT INTO bgc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","जो पैहल्या आये उननै यो सोच्या के म्हारै ताहीं घणा मिलैगा, पर उननै भी एक-एक दीनार (एक दिन की मजदूरी) ए मिल्या। ");
INSERT INTO bgc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","मजदूरी तो उननै ले ली पर वे अंगूर के बाग के माल्लिक पै बिरड़ाकै कहण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘जो पाच्छै लाग्गे थे, उननै बस एक घंटा काम करया, अर तन्नै म्हारै ताहीं भी उतनाए दिया जितना उन ताहीं, जिब के हमनै दिन-भर बोझ ठाया अर घाम सहया?’” ");
INSERT INTO bgc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“बाग के माल्लिक नै उन म्ह तै एक ताहीं जवाब दिया, ‘हे दोस्त, मन्नै तेरे गैल कोए अन्याय कोनी करया। के तन्नै ए मेरै तै एक दीनार (एक दिन की मजदूरी) कोनी तय करया था? ");
INSERT INTO bgc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","जो तेरा सै, ठा ले अर चल्या जा; मेरी मर्जी, के जितना तन्नै दियुँ उतनाए इस पाच्छले ताहीं भी दियुँ। ");
INSERT INTO bgc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","के यो ठीक कोनी के मै अपणे धन का जो चाहूँ वो करुँ? के मेरै भले होण कै कारण तू कड़वी नजर तै देक्खै सै?’” ");
INSERT INTO bgc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“इस तरियां तै जो पाच्छले सै, वे पैहले होंगे, जो पैहले सै, पाच्छले होवैगें।” ");
INSERT INTO bgc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","जब यीशु अपणे बारहां चेल्यां गैल यरुशलेम नगर म्ह जाण लागरया था तो उन ताहीं एकान्त म्ह लेग्या, अर राह म्ह चालते-चालते उनतै बोल्या, ");
INSERT INTO bgc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“देक्खो, हम यरुशलेम नगर म्ह जावां सा; अर मै माणस का बेट्टा प्रधान याजकां अर शास्त्रियाँ कै हाथ्थां पकड़वाया जाऊँगा, वे मेरे खात्तर मौत की सजा तय करैगें। ");
INSERT INTO bgc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","अर मेरे ताहीं गैर यहूदियाँ कै हाथ्थां म्ह सौपैगें, वे मेरा मजाक उड़ावैगें, कोड़े मारैगें, क्रूस पै चढ़ावैगें, अर मै तीसरे दिन जिन्दा हो जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","फेर जब्दी कै बेट्याँ की माँ नै, अपणे बेट्याँ कै गेल्या यीशु कै धोरै आकै प्रणाम करया, अर उसतै कुछ माँगण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","यीशु नै उसतै कह्या, “तू के चाहवै सै?” वा यीशु तै बोल्ली, “मन्नै वचन दे, के मेरे ये दो बेट्टे तेरे राज्य म्ह एक तेरे सोळे अर दुसरा तेरे ओळै कान्ही बेठ्ठै।” ");
INSERT INTO bgc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीशु नै जवाब दिया, “थमनै न्ही बेरा के थम के माँग्गो सों। जो दुख का कटोरा मै पीण पै सूं, के थम वो दुख का कटोरा पी सको सो?” उननै उस ताहीं कह्या, “पी सकां सा।” ");
INSERT INTO bgc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","उसनै उनतै कह्या, “थम मेरे दुख का कटोरा तो पी ल्योगे, पर अपणे सोळे अर ओळै कान्ही किसे ताहीं बिठाणा मेरा काम कोनी, पर जिनकै खात्तर मेरै पिता की ओड़ तै त्यार करया गया, उननै ए खात्तर सै।” ");
INSERT INTO bgc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","न्यू सुणकै दसो चेल्लें उन दोन्नु भाईयाँ पै छो करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","यीशु नै उन ताहीं धोरै बुलाकै कह्या, “थम जाणो सो के गैर यहूदियाँ के हाकिम उनपै राज करै सै; अर जो बड़े सै, वे उनपै हक जमावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पर थारे म्ह इसा कोनी होवैगा; जो कोए थारे म्ह बड्ड़ा होणा चाहवै, वो थारा सेवक बणै, ");
INSERT INTO bgc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","अर जो थारे म्ह प्रधान होणा चाहवैं, वो दास बणै, ");
INSERT INTO bgc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","जिसा के मै माणस का बेट्टा, ज्यांतै कोनी आया के मेरी सेवा-पाणी करी जावै, पर ज्यांतै आया के खुद सेवा-पाणी करुँ, अर घणखरयां के छुटकारै कै खात्तर अपणी जान देऊँ।” ");
INSERT INTO bgc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जिब वे यरीहो नगर तै लिकड़ै थे, तो एक बड्डी भीड़ यीशु कै पाच्छै हो ली। ");
INSERT INTO bgc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अर दो आन्धे, जो सड़क कै किनारे बेठ्ठे थे, न्यू सुणकै के यीशु जाण लागरया सै, रुक्का मारकै कहण लाग्गे, “हे प्रभु, हे दाऊद की ऊलाद, म्हारै पै दया कर।” ");
INSERT INTO bgc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","माणसां नै उन ताहीं धमकाया के बोल-बाल्ले रहवै; पर वे और भी रुक्के मारकै बोल्ले, “हे प्रभु, दाऊद की ऊलाद, म्हारै पै दया कर।” ");
INSERT INTO bgc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","फेर यीशु नै खड़े होकै, उन ताहीं बुलाया अर कह्या, “थम के चाहवो सो के मै थारे खात्तर करुँ?” ");
INSERT INTO bgc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","उननै उसतै कह्या, “हे प्रभु, योए के हम देक्खण लाग जावां।” ");
INSERT INTO bgc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीशु नै तरस खाकै उनकी आँखां पै हाथ लगाया, अर वे जिब्बे देखण लाग्गै; अर उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","जिब वे यरुशलेम नगर कै लोवै पोहचे अर जैतून पहाड़ पै बैतफगे गाम कै धोरै आये, तो यीशु नै दो चेल्यां ताहीं न्यू कहकै भेज्या, ");
INSERT INTO bgc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“स्याम्ही कै गाम म्ह जाओ। ओड़ै पोहोचदये एक गधी बंधी होई, अर उसकै गेल्या बच्चा थमनै मिलैगा। उननै खोल कै मेरै धोरै ल्याओ। ");
INSERT INTO bgc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","जै थारे तै कोए कुछ कहवै, तो कहियो के प्रभु नै इसकी जरूरत सै, अर वो तोळा उसनै भेज देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","यो ज्यांतै होया के जो वचन नबी के जरिये कह्या गया था, वो पूरा हो ");
INSERT INTO bgc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“यरुशलेम के लोग्गां तै कहो, ‘देख, थारा राजा थारे धोरै आवै सै; वो नम्र सै, अर गधे पै बेठ्या सै; बल्के गधी के बच्चे पै।’” ");
INSERT INTO bgc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेल्यां नै जाकै, जिसा यीशु नै उनतै कह्या था, उस्से तरियां करया। ");
INSERT INTO bgc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","अर गधी अर बच्चे ताहीं ल्याकै, उसपै अपणे लत्ते गेरे, अर वो उसपै बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","फेर घणखरे माणसां नै अपणे लत्ते राह म्ह बिछाये, अर माणसां नै दरखतां तै डाळियाँ काटकै राह म्ह बिछाई। ");
INSERT INTO bgc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","जो भीड़ आग्गै-आग्गै अर पाच्छै-पाच्छै चाल्ली आवै थी, रुक्के मार-मारकै कहवै थी, “दाऊद की ऊलाद ताहीं होशाना, धन्य सै वो जो प्रभु के नाम तै आवै सै, अकास म्ह होशाना।” ");
INSERT INTO bgc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जिब वो यरुशलेम म्ह बड़या, तो सारे नगर म्ह खलबल्ली माचगी, अर माणस कहण लाग्गे, “यो कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","माणसां नै कह्या, “यो गलील परदेस के नासरत नगर का नबी यीशु सै।” ");
INSERT INTO bgc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीशु नै परमेसवर कै मन्दर म्ह जाकै उन सारया ताहीं, जो मन्दर म्ह लेण-देण कररे थे, काढ दिया, अर सर्राफां (पईसा का लेण देण करण आळे) के पीढ़े अर कबूतर बेचणीयाँ की चौकियाँ उल्ट दी; ");
INSERT INTO bgc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अर उनतै कह्या, “लिख्या सै, ‘मेरा घर प्रार्थना का घर कुह्वावैगा’; पर थम उसनै डाकुवां की गुफा बणाओ सो।” ");
INSERT INTO bgc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","फेर आन्धे अर लंगड़े, मन्दर म्ह उसकै धोरै आये, अर उसनै उन ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","पर जिब प्रधान याजकां अर शास्त्रियाँ नै इन अनोक्खे काम्मां ताहीं, जो उसनै करे, अर छोरयां ताहीं मन्दर म्ह दाऊद की ऊलाद ताहीं होशाना रुक्के मारदे देख्या, तो वे छो म्ह भरगे, ");
INSERT INTO bgc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","अर उसतै कहण लाग्गे, “के तू सुणै सै के ये के कहवै सै?” यीशु नै उनतै कह्या, “हाँ; के थमनै यो कदे कोनी पढ्या: ‘बाळकां अर दूध पीन्दे बच्चां कै मुँह तै तन्नै घणी जै-जै कार कराई?’” ");
INSERT INTO bgc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","फेर वो उननै छोड़कै नगर कै बाहरणै आकै बैतनिय्याह गाम म्ह गया अर ओड़ै रात बिताई। ");
INSERT INTO bgc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","तड़कैए जिब वो नगर नै बोहड़ण लागरया था तो उसनै भूख लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","सड़क कै किनारे अंजीर का एक दरखत देखकै वो उसकै धोरै गया, अर पत्त्या नै छोड़ उस म्ह और कुछ ना पाकै उसतै कह्या, “इब तै तेरे म्ह फेर कदे फळ कोनी लाग्गै।” अर अंजीर का दरखत जिब्बे सूखग्या। ");
INSERT INTO bgc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","न्यू देखकै चेल्यां नै हैरानी होई अर उननै कह्या, “यो अंजीर का दरखत जिब्बे किस तरियां सूखग्या?” ");
INSERT INTO bgc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीशु नै उन ताहीं जवाब दिया, “मै थमनै साच्ची कहूँ सूं, जै थम बिश्वास राक्खो अर शक ना करो, तो ना केवल यो करोगे जो इस अंजीर कै दरखत गेल्या करया गया सै, पर जै इस पहाड़ नै कहोगे, ‘उखड़ जा, अर समुन्दर म्ह जा पड़’, तो यो भी हो जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","अर जो कुछ थम प्रार्थना म्ह बिश्वास तै माँगोगे वो सारा थमनै मिलैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","वो मन्दर जाकै उपदेश देवै था, तो प्रधान याजकां अर यहूदी अगुवां नै उसकै धोरै आकै बुझ्झया, “तू ये काम किसकै हक तै करै सै? अर तेरे ताहीं यो हक किसनै दिया सै?” ");
INSERT INTO bgc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीशु नै उनतै जवाब दिया, “मै भी थारे तै एक बात बुझ्झु सूं; जै वो मन्नै बताओगे, तो मै भी थमनै बताऊँगा के ये काम किस हक तै करुँ सूं;। ");
INSERT INTO bgc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्ना का बपतिस्मा कित्त तै था? सुर्ग की ओड़ तै या माणसां की ओड़ तै?” फेर वे आप्पस म्ह बहस करण लाग्गे, “जै हम कह्वां ‘सुर्ग की ओड़ तै’ तो वो म्हारै तै कहवैगा, ‘फेर थमनै उसका बिश्वास क्यांतै न्ही करया?’ ");
INSERT INTO bgc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","अर जै कह्वां ‘माणसां की ओड़ तै’ तो हमनै भीड़ का डर सै, क्यूँके वे सारे यूहन्ना ताहीं नबी मान्नै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","फेर उननै यीशु ताहीं जवाब दिया, “हमनै न्ही बेरा।” यीशु नै भी उनतै कह्या, “तो मै भी थमनै कोनी बतान्दा के ये काम किस हक तै करुँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“आच्छा बताओ थम इस बारें म्ह के कहो सो? के किसे माणस कै दो बेट्टे थे; उसनै पैहले कै धोरै जाकै कह्या, ‘हे बेट्टे, आज अंगूर के बाग म्ह काम कर।’” ");
INSERT INTO bgc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“पर बेट्टे नै जवाब दिया, ‘मै कोनी जान्दा’, पर कुछ बखत के बाद अपणे दिए होए जवाब पै उसनै भोत पछतावा होया अर वो चल्या गया।” ");
INSERT INTO bgc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“फेर पिता नै दुसरे कै धोरै जाकै न्यूए कह्या, उसनै जवाब दिया, ‘जी हाँ जाऊँ सूं’, पर कोनी गया।” ");
INSERT INTO bgc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“इन दोनुवां म्ह तै किसनै पिता की मर्जी पूरी करी?” उननै कह्या, “पैहले नै।” यीशु नै उनतै कह्या, “मै थारे तै साच्ची कहूँ सूं के चुंगी लेण आळे अर बेश्याएँ थारे तै पैहल्या परमेसवर के राज्य म्ह दाखल हो जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","यो मै इस खात्तर कहूँ सूं क्यूँके यूहन्ना बपतिस्मा देण आळा धर्म की राह दिखान्दे होए थारे धोरै आया, अर थमनै उसका बिश्वास कोनी करया; पर चुंगी लेण आळे अर बेश्यायाँ नै उसका बिश्वास करया अर थमनै न्यू देखकै भी पाप करणा कोनी छोड्या अर ना ए उसका बिश्वास करया।” ");
INSERT INTO bgc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","एक और उदाहरण सुणो एक घर का माल्लिक था, जिसनै अंगूर का बाग लगाया, अर उसकै चौगरदे नै बाड़ा बाँधया, अर रस का कुण्ड खोद्या, अर रुखाळ खात्तर एक मचान बणाया; अर किसानां ताहीं उसका ठेक्का देकै परदेस चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जिब फळ का बखत लोवै आया, तो उसनै अपणे नौकरां ताहीं उसका फळां का हिस्सा लेण नै किसानां धोरै भेज्या। ");
INSERT INTO bgc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पर किसानां नै उसके नौकरां ताहीं पकड़कै, किसे ताहीं छेत्या, अर किसे ताहीं मार दिया, अर किसे पै पत्थर बरसाए। ");
INSERT INTO bgc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","फेर उसनै पैहल्या तै घणे और नौकरां ताहीं भेज्या, अर उननै भी उस्से तरियां करया। ");
INSERT INTO bgc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आखर म्ह उसनै अपणे बेट्टे ताहीं उनकै धोरै न्यू सोचकै भेज्या के वे मेरै बेट्टे की इज्जत करैगें ");
INSERT INTO bgc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“पर किसानां नै बेट्टे ताहीं देखकै आप्पस म्ह कह्या, ‘यो तो वारिस सै, आओ, इसनै मार देवा अर इसकी विरासत ले लेवां।’” ");
INSERT INTO bgc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","अर उननै उस ताहीं पकड्या अर अंगूर के बाग तै बाहरणै काढकै मार दिया। ");
INSERT INTO bgc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“इस करकै जिब अंगूर के बाग का माल्लिक आवैगा, तो उन किसानां कै गेल्या के करैगा?” ");
INSERT INTO bgc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","उननै उसतै कह्या, “वो उन भुन्डे़ माणसां का भुंडी ढाळ नाश करैगा; अर अंगूर के बाग का ठेका दुसरे किसानां ताहीं देवैगा, जो बखत पै उस ताहीं फळ दिया करैगें।” ");
INSERT INTO bgc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीशु नै उनतै कह्या, “के थमनै कदे भी पवित्र ग्रन्थ म्ह यो कोनी पढ्या: ‘जिस पत्थर ताहीं राजमिस्त्रियाँ नै बेकार ठहराया था, वोए कुणे के सिरे का पत्थर होग्या? यो प्रभु की ओड़ तै होया, अर म्हारी निगांह म्ह अनोक्खा सै।’” ");
INSERT INTO bgc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ज्यांतै मै थमनै कहूँ सूं के परमेसवर का राज्य थारे तै ले लिया जावैगा अर इसी जात ताहीं दिया जावैगा, जो उसका आच्छा फळ ल्यावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","जो इस पत्थर पै पड़ैगा, वो चकणाचूर हो जावैगा; अर जिसपै वो पड़ैगा, उसनै पिस देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","प्रधान याजक अर फरीसी उसके उदाहरणां नै सुणकै समझगे, के वो उनकै बाबत कहवै सै। ");
INSERT INTO bgc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","अर उननै उस ताहीं पकड़णा चाह्या, पर माणसां तै डरगे क्यूँके वे उसनै नबी मान्नै थे। ");
INSERT INTO bgc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","इसपै यीशु फेर उनतै उदाहरणां म्ह कहण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“सुर्ग का राज्य उस राजा की ढाळ सै, जिसनै अपणे बेट्टे का ब्याह करया। ");
INSERT INTO bgc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","अर उसनै अपणे नौकरां ताहीं भेज्या, के न्योंदे होड़ माणसां ताहीं ब्याह के जिमणे म्ह बुलावै; पर उननै आणा न्ही चाह्या।” ");
INSERT INTO bgc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“फेर उसनै और नौकरां ताहीं न्यू कहकै भेज्या, ‘न्योंदे होड़ माणसां ताहीं कहो देक्खों, मन्नै भोज त्यार कर लिया सै, अर मेरे बळध अर पळे होड़ डान्गर काट लिये सै: सारा कुछ त्यार सै; ब्याह के जिमणे म्ह आओ।’” ");
INSERT INTO bgc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पर वे बेपरवाह होकै चले गये, कोए अपणे खेत्तां म्ह, कोए अपणे धन्धे पै। ");
INSERT INTO bgc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","और कई माणसां नै तो राजा के नौकरां ताहीं पकड़कै उनकी बेजती करी अर उन ताहीं मार दिया। ");
INSERT INTO bgc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","जिब राजा नै यो सुण्या तो छो म्ह भरग्या, अर अपणी पलटन भेजकै उन हत्यारा का नाश करया, अर उनके नगर फूँक दिए। ");
INSERT INTO bgc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","फेर राजा नै अपणे नौकरां तै कह्या, ब्याह का भोज तो त्यार सै, पर के न्योंदे होड़ माणस इस जोग्गे कोनी ठहरे। ");
INSERT INTO bgc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","इस करकै चौराहयाँ पै जाओ, अर जितने माणस थमनै मिलै, सारया ताहीं ब्याह कै भोज म्ह बुला ल्याओ। ");
INSERT INTO bgc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","इस तरियां उसके नौकरां नै सड़कां पै जाकै के भुन्डे़, के आच्छे, जितने मिले सारया ताहीं कठ्ठा करया; ब्याह का घर मेहमानां तै भरग्या। ");
INSERT INTO bgc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","जिब राजा मेहमानां नै देखण भीत्त्तर आया, तो उसनै ओड़ै एक माणस ताहीं देख्या, जो ब्याह आळे लत्ते कोनी पहररया था। ");
INSERT INTO bgc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","उसनै उसतै बुझ्झया, हे दोस्त, तू ब्याह म्ह पैहरे जाण आळे लत्ते पहरे बिना उरै क्यातै आ ग्या। उसका मुँह बन्द होग्या। ");
INSERT INTO bgc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","फेर राजा नै नौकरां तै कह्या, इसके हाथ-पैर जुड़कै उस ताहीं बाहरणै अन्धेरे म्ह गेर द्यो, ओड़ै रोणा, अर दाँत पिसणा होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“क्यूँके बुलाये होड़ तो घणे सै पर चुणे होए कम सै।” ");
INSERT INTO bgc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","फेर फरीसियाँ नै आकै आप्पस म्ह विचार करया, के उसनै किस ढाळ बात्तां म्ह फसावा। ");
INSERT INTO bgc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","इस तरियां उननै अपणे चेल्यां ताहीं हेरोदेस राजा के समर्थकां कै गेल्या उसकै धोरै न्यू कहण नै भेज्या, “हे गुरु, हमनै बेरा सै, के तू साच्चा सै, अर परमेसवर की राह सच्चाई तै सिखावै सै; अर किसे की परवाह कोनी करदा, क्यूँके तू माणसां का मुँह देखकै बात कोनी करदा। ");
INSERT INTO bgc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","इस करकै हमनै बता तन्नै के समझ आवै सै? कैसर तै चुंगी देणा ठीक सै के न्ही।” ");
INSERT INTO bgc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीशु नै उनका कपट जाणकै कह्या, “हे कपटियों, मन्नै क्यांतै परखो सो? ");
INSERT INTO bgc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","कर का सिक्का मेरै ताहीं दिखाओ।” फेर उसकै धोरै एक दीनार (एक दिन की मजदूरी) लियाये। ");
INSERT INTO bgc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","उसनै उनतै कह्या, “या छाप अर नाम किसका सै?” ");
INSERT INTO bgc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","उननै उसतै कह्या, “कैसर का।” फेर उसनै उनतै कह्या, “जो कैसर का सै, वो कैसर ताहीं; अर जो परमेसवर का सै, वो परमेसवर ताहीं द्यो।” ");
INSERT INTO bgc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","न्यू सुणकै उननै हैरानी होई, उस ताहीं छोड़कै चले ग्ये। ");
INSERT INTO bgc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","उस्से दिन सदूकी जो कहवै सै के मरे होया का दुबारा जिन्दा उठणा सै ए कोनी, उसकै धोरै आये अर उसतै बुझ्झया, ");
INSERT INTO bgc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“हे गुरु, मूसा नबी नै कह्या था के जै कोए माणस बेऊलादा मर जावै, तो उसका भाई उसकी घरआळी तै ब्याह करकै अपणे भाई कै खात्तर पीढ़ी पैदा करै। ");
INSERT INTO bgc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","इब म्हारै उरै सात भाई थे; पैहल्ड़ा ब्याह करकै मरग्या, अर ऊलाद ना होण कै कारण अपणी घरआळी अपणे भाई कै खात्तर छोड़ ग्या। ");
INSERT INTO bgc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","इस्से तरियां दुसरे अर तीसरे नै भी करया, अर सातुवां तक योए होया। ");
INSERT INTO bgc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","सारया पाच्छै वा बिरबान्नी भी मरगी। ");
INSERT INTO bgc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","आखर म्ह जिन्दा होण पै वा सातुवां म्ह तै किसकी घरआळी होवैगी? क्यूँके वा सारया की घरआळी बण ली थी।” ");
INSERT INTO bgc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीशु नै उनतै जवाब दिया, “थारी गलती या सै के थम पवित्र ग्रन्थ अर परमेसवर की सामर्थ नै न्ही जाणते। ");
INSERT INTO bgc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","क्यूँके मरकै जिन्दा हो जाणकै बाद ब्याह शादी कोनी होन्दी, पर सुर्ग म्ह परमेसवर के सुर्गदूत्तां की ढाळ होवैगें। ");
INSERT INTO bgc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","पर मरकै जिन्दा हो जाणकै बाबत के थमनै यो वचन कोनी पढ़्या जो परमेसवर नै थारे तै कह्या ");
INSERT INTO bgc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘मै अब्राहम का परमेसवर, अर इसहाक का परमेसवर, याकूब का परमेसवर सूं’? वो मरे होया का न्ही, पर जिन्दा का परमेसवर सै।” ");
INSERT INTO bgc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","न्यू सुणकै माणस उसके उपदेश तै हैरान होए। ");
INSERT INTO bgc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जिब फरीसियाँ नै सुण्या के यीशु नै सदूकियाँ का मुँह बन्द कर दिया, तो वे कठ्ठे होए। ");
INSERT INTO bgc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","शास्त्री समाज के माणसां म्ह तै एक नै उस ताहीं परखण कै खात्तर उसतै बुझ्झया, ");
INSERT INTO bgc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“हे गुरु, नियम-कायदा म्ह कौण सा हुकम बड्ड़ा सै?” ");
INSERT INTO bgc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","यीशु नै उसतै कह्या, “तू परमेसवर अपणे प्रभु तै अपणे पूरे मन अर अपणे सारे प्राण अर अपणी सारी बुद्धि के साथ प्यार राख। ");
INSERT INTO bgc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","पैहला अर बड्ड़ा हुकम तो योए सै। ");
INSERT INTO bgc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","अर उस्से जिसा यो दुसरा भी सै के तू अपणे पड़ोसी तै अपणे जिसा प्यार राख। ");
INSERT INTO bgc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ये दो हुकम सारे नियम-कायदे अर नबियाँ का निचोड़ (आधार) सै।” ");
INSERT INTO bgc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जिब फरीसी कठ्ठे थे, तो यीशु नै उनतै बुझया, ");
INSERT INTO bgc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसीह कै बारै म्ह थम के सोच्चो सो? वो किसका बेट्टा सै?” उननै यीशु तै कह्या, “दाऊद का।” ");
INSERT INTO bgc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","यीशु नै उनतै बुझया, “तो दाऊद आत्मा म्ह होकै उसनै प्रभु क्यांतै कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘प्रभु नै, मेरै प्रभु तै कह्या, मेरै सोळे कान्ही बैठ, जिब ताहीं के मै तेरे बैरियाँ ताहीं तेरे पायां म्ह ना झुका दियुँ।’” ");
INSERT INTO bgc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“भला, जिब दाऊद उसनै प्रभु कहवै सै, तो वो उसका बेट्टा किस ढाळ होया?” ");
INSERT INTO bgc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","उसके जवाब म्ह कोए भी एक बात न्ही कह सक्या। पर उस दिन तै दुबारै उसतै कीमे और बुझ्झण की हिम्मत कोनी करी। ");
INSERT INTO bgc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","फेर यीशु नै भीड़ तै अर अपणे चेल्यां ताहीं कह्या, ");
INSERT INTO bgc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“शास्त्री अर फरीसी माणसां नै मूसा नबी के नियम-कायदे सिखाण का हक सै; ");
INSERT INTO bgc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ज्यांतै वे थारे तै जो कुछ कहवै वो करियो अर मानिये, पर उन जिसे काम ना करियो; क्यूँके वे सिखावै तो सै पर खुद करदे कोनी। ");
INSERT INTO bgc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","वे थारे पै कई नियम लाग्गू करै सै जिसका पालन करणा ओक्खा सै, वे माणसां नै उनपै चाल्लण खात्तर मजबूर करै सै; पर वे खुद अपणे नियमां नै कोनी मानते।” ");
INSERT INTO bgc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","वे अपणे सारे काम माणसां ताहीं दिखाण कै खात्तर करै सै: वे अपणे ताबिजां नै चौड़ा करै सै जिनपै वे पवित्र ग्रंथ के वचन लिखकै शरीर पै बाँधले सै, अर अपणे लत्यां की झाल्लर बधावै सै, ताके लोग उननै धर्मी समझै। ");
INSERT INTO bgc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","भोज म्ह खास-खास जगहां, अर आराधनालयाँ के खास-खास जगहां बैठणा, ");
INSERT INTO bgc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","बजारां म्ह नमस्कार, अर माणसां म्ह गुरु कुह्वाणा उननै भावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पर थम गुरु ना कुह्वाणा, क्यूँके थारा एके गुरु सै, अर थम सारे भाई-भाण के समान सों। ");
INSERT INTO bgc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","धरती पै किसे नै अपणा पिता ना कहियो, क्यूँके थारा एके आत्मिक पिता सै, जो सुर्ग म्ह सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","अर स्वामी भी ना कुह्वाणा, क्यूँके थारा एके माल्लिक सै, यानिके मसीह। ");
INSERT INTO bgc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जो थारे म्ह बड्ड़ा हो, वो थारा सेवक या नौक्कर बणै। ");
INSERT INTO bgc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जो कोए अपणे-आपनै बड्ड़ा बणावैगा, वो छोट्टा करया जावैगा: अर जो कोए अपणे-आपनै छोट्टा बणावैगा, वो बड्ड़ा करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","हे कपटी शास्त्रियो अर फरीसियों, थारे पै धिक्कार सै! थम माणसां कै खात्तर सुर्ग राज्य का बारणा बन्द करो सो, ना तो थम खुद उस म्ह दाखल होवो सो अर ना उस म्ह दाखल होण आळा नै दाखल होण द्यो सो। ");
INSERT INTO bgc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(हे कपटी शास्त्रियो अर फरीसियों, थारे पै धिक्कार सै! थम बिधवा के घरां नै खा जाओ सो, अर अपणे-आपनै धर्मी दिखाण खात्तर घणी वार ताहीं प्रार्थना करदे रहो सो: ज्यांतै थारे ताहीं परमेसवर की ओड़ तै घणा दण्ड मिलैगा।) ");
INSERT INTO bgc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","हे कपटी शास्त्रियो अर फरीसियों, थारे पै धिक्कार सै! थम एक माणस ताहीं अपणे पंथ म्ह ल्याण कै खात्तर दूर-दूर ताहीं हान्डो सो, अर जिब वो पंथ म्ह आ जावै सै, तो खुद तो नरक म्ह जाओ सों पर दुसरयां नै अपणे तै दुगणा नरक जाण का भाग्गी बणा द्यो सो। ");
INSERT INTO bgc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","हे आन्धे अगुवों, थारे पै धिक्कार सै! थम जो या शिक्षा द्यो सो, के जै कोए मन्दर की सूह खावै तो किमे न्ही, पर जै कोए मन्दर कै सोन्ने की सूह खावै तो उसतै बन्द जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","हे बेअक्लो अर आंध्यो, कौण बड्ड़ा सै; मन्दर का सोन्ना या वो मन्दर जिसनै उस सोन्ने ताहीं पवित्र बणाया सै? ");
INSERT INTO bgc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","थम यो भी सिखाओ सो के जै कोए वेदी की सूह खावै तो किमे न्ही, पर जो भेंट उसपै सै, जै कोए उसकी कसम खावै तो बन्द जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","हे आंध्यो, कौण बड्ड़ा सै; भेंट या वेदी जिसम्ह भेंट पवित्र होवै सै? ");
INSERT INTO bgc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","इस करकै जो वेदी की कसम खावै सै, वो उसकी अर जो कुछ उसपै सै, उसकी भी कसम खावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","जो मन्दर की कसम खावै सै, वो परमेसवर जो उस म्ह रहवै सै, उसकी भी कसम खावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","जो सुर्ग की कसम खावै सै, वो परमेसवर कै सिंहासन की अर उसपै बैठण आळे की भी कसम खावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","हे कपटी शास्त्रियो अर फरीसियों, थारे पै धिक्कार सै! थम पुदीने, सौंफ, जीरै का दसमां हिस्सा तो द्यो सो, पर थमनै नियम-कायदा की गहरी बात्तां ताहीं यानिके न्याय, दया, अर वफादारी का तिरस्कार करो सों; थमनै दसमां हिस्सा भी देणा चाहिये पर उन खास बात्तां नै भी नजरअंदाज ना करो। ");
INSERT INTO bgc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","हे आन्धे अगुवों, थम छोट्टे-छोट्टे नियमां का पालन करण का तो भोत ध्यान राक्खों सों, जिस तरियां पाणी म्ह तै माच्छर ताहीं तो छाण ल्यो सो, पर परमेसवर के खास हुकम का पालन कोनी करते, जो ऊँट नै निगळ जाणकै समान सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","हे कपटी शास्त्रियो अर फरीसियों, थारे पै धिक्कार सै! क्यूँके थम लालची अर स्वार्थी सों, पर थम अपणे-आपनै पवित्र राक्खण का ढोंग करो सों, इस खात्तर थम उन कटोरे अर थाळी के समान सों जो उप्पर तै तो साफ सै पर भित्तर तै वे गन्दे सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","हे आन्धे फरीसियों, पैहल्या माणस नै लूटणा बन्द करो जिब्बे थम धर्म के काम का पालन कर पाओगे अर फेर थम उस कटोरे अर थाळी के समान होवैगें जो भीत्त्तर बाहर तै भी साफ हों सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","हे कपटी शास्त्रियो अर फरीसियों, थारे पै धिक्कार सै! थम चुन्ने फिरी होई कब्रां के जिसे सो जो उप्पर तै तो सुथरी दिक्खै सै, पर भीत्त्तर मुर्दां की हाड्डियाँ अर सारे ढाळ की गन्दगी तै ठुकी होई सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","इस्से तरियां तै थम भी उप्पर तै माणसां ताहीं धर्मी दिक्खो सो, पर भीत्त्तर अधर्म अर कपट तै भरे सो। ");
INSERT INTO bgc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","हे कपटी शास्त्रियो अर फरीसियों, थारे पै धिक्कार सै! थम उन नबियाँ की कब्र समारो सो अर धर्मियाँ की कब्र सजाओ सो, जिन ताहीं थारे पूर्वजां नै मारा था। ");
INSERT INTO bgc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“अर कहो सो, ‘जै हम अपणे बाप-दाद्यां के दिनां म्ह होन्दे तो नबियाँ की हत्या म्ह उनके साझ्झी कोनी होन्दे।’ ");
INSERT INTO bgc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","इसतै तो थम अपणे आप ए या गवाही द्यो सो के थम नबियाँ के हत्यारां के वंशज सो। ");
INSERT INTO bgc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ठीक सै थम अपणे पूर्वजां कै पाप का घड़ा भरते जाओ।” ");
INSERT INTO bgc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","हे साँप के सप्पोलों जिसे माणसों, थम नरक की सजा तै किस ढाळ बचोगे? ");
INSERT INTO bgc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","इस करकै देक्खो, मै थारे धोरै नबियाँ अर समझदार अर शास्त्रियाँ ताहीं भेज्जू सूं, अर थम उन म्ह तै कुछां नै मार द्योगे अर क्रूस पै चढ़ावोगे, अर कुछां नै अपणे आराधनालयाँ म्ह कोड़े मारोगे अर एक नगर तै दुसरे नगर ताहीं भजांदे फिरोगे। ");
INSERT INTO bgc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","जिसतै धर्मी हाबिल तै लेकै बिरिक्याह के बेट्टे जकर्याह तक, जिस ताहीं थमनै मन्दर अर वेदी कै बिचाळै मार दिया था, जितने भी धर्मी माणसां ताहीं मारया सै, वो सारा दण्ड थारे सिर पै पड़ैगा। ");
INSERT INTO bgc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मै थमनै सच कहूँ सूं, ये सब का दण्ड इस पीढ़ी के माणसां नै भुगतणा पड़ैगा। ");
INSERT INTO bgc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“हे यरुशलेम नगर के लोगों, हे यरुशलेम नगर के लोगों! थम नबियाँ नै मार देओ सो, अर जो थारे धोरै भेज्जै गए, उनपै पत्थर बरसाओ सो। कितनी ए बर मन्नै चाह्या के जिस ढाळ मुर्गी अपणे बच्चां ताहीं अपणे पाक्खां कै तळै छुपा ले सै, उस्से तरियां ए मै भी थारे बाळकां नै कठ्ठा कर ल्यूँ, पर थमनै कोनी चाह्या। ");
INSERT INTO bgc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देक्खो, थारा घर थारे खात्तर उजाड़ छोड्या जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","क्यूँके मै थमनै साच्ची कहूँ सूं के इब तै जिब ताहीं थम न्ही कहोगे, ‘धन्य सै वो, जो प्रभु कै नाम तै आवै सै’ तब तक थम मन्नै फेर दुबारै कदे कोनी देक्खोगे।” ");
INSERT INTO bgc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जिब यीशु मन्दर तै लिकड़कै जाण लागरया था, तो उसके चेल्लें उस ताहीं मन्दर की बणावट दिखाण कै खात्तर उसकै धोरै आये। ");
INSERT INTO bgc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","यीशु नै उनतै कह्या, “के थम ये सारी इमारत न्ही देखते? मै थमनै साच्ची कहूँ सूं, उरै पत्थर पै पत्थर भी कोनी रहवैगा, जो गेरया ना जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जिब यीशु जैतून कै पहाड़ पै बेठ्या था, तो चेल्यां नै एक्ले म्ह उसकै धोरै आकै कह्या, “हमनै बता, ये बात कद होवैगीं? तेरे आण का अर दुनिया कै अन्त की के निशान्नी होवैगी?” ");
INSERT INTO bgc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीशु नै उन ताहीं जवाब दिया, “चौकन्ने रहियो! कोए थमनै भकाण न्ही पावै, ");
INSERT INTO bgc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","क्यूँके घणखरे इसे होवैगें जो मेरै नाम तै आकै कहवैगें, मै मसीह सूं, अर घणाए ताहीं भकावैगें। ");
INSERT INTO bgc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","थम रोळे अर लड़ाईया का जिक्र सुणोगे, तो घबराईयो ना क्यूँके इनका होणा जरूरी सै, पर उस बखत खात्मा कोनी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","क्यूँके जात पै जात, अर राज्य पै राज्य चढ़ाई करैगा, अर जगहां-जगहां अकाळ पड़ैंगें, अर हाल्लण आवैगें। ");
INSERT INTO bgc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ये सारी बात दुखां की शरुआत होवैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","फेर माणस क्ळेश देण कै खात्तर थमनै पकड़वावैगें, अर थमनै मार देवैगें, अर मेरै नाम कै कारण सारी जात्तां के माणस थारे तै बैर राक्खैगें, क्यूँके थम मेरे पै बिश्वास करो सों। ");
INSERT INTO bgc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","फेर घणखरे मेरे पै बिश्वास करणा छोड़ देंगें, अर एक-दुसरे नै पकड़वावैगें, अर एक-दुसरे तै बैर राक्खैगें। ");
INSERT INTO bgc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","घणखरे झूठ्ठे नबी आवैगें, अर घणाए ताहीं भकावैगें। ");
INSERT INTO bgc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","अधर्म कै बढ़ण तै वे एक-दुसरे तै प्यार करणा छोड़ देंगे, ");
INSERT INTO bgc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पर जो अन्त ताहीं मेरे पै बिश्वास राक्खैगा, उस्से ताहीं बचाया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","अर परमेसवर के राज्य का यो सुसमाचार सारी दुनिया म्ह प्रचार करया जावैगा, ताके सारी जात्तां नै इस ताहीं स्वीकार करण का मौक्का मिलै, ताके थम मेरे गवाह होओ, फेर दुनिया का अन्त आ जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","इस करकै जिब थम उस उजाड़ण आळी घृणित चीज ताहीं जिसका जिक्र दानिय्येल नबी कै जरिये होया था, पवित्र जगहां पै खड़े देक्खो (जो पढ़ै, वो समझै), ");
INSERT INTO bgc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","फेर जो यहूदिया परदेस म्ह हो, वे पहाड़ां पै भाज जावै। ");
INSERT INTO bgc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जो छात पै हो, वो अपणे घर म्ह तै समान लेण नै तळै न्ही उतरै, ");
INSERT INTO bgc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","अर जो खेत म्ह हो, वो अपणा लत्ता लेण नै पाच्छै न्ही बोहड़ैं। ");
INSERT INTO bgc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","उन दिनां म्ह जो गर्भवती अर दूध पिलान्दी बिरबान्नी होवैगीं, उनकै खात्तर भागणा भी मुश्किल होगा! ");
INSERT INTO bgc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","प्रार्थना करया करो के थमनै जाड्डे म्ह या आराम कै दिन भाजणा ना पड़ै। ");
INSERT INTO bgc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","क्यूँके उस बखत इसा भारया क्ळेश होवैगा, जिसा दुनिया की शरुआत तै ना इब ताहीं होया ना कदे होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“अर जै वे दिन घटाए न्ही जान्दे तो कोए प्राणी कोनी बचदा, पर छाँटे होया कै कारण वे दिन घटाए जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","उस बखत जै कोए थमनै कहवै, ‘देक्खो, मसीह उरै सै!’ या ‘ओड़ै सै!’ तो बिश्वास ना” करियो। ");
INSERT INTO bgc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","क्यूँके झूठ्ठे मसीह अर झूठ्ठे नबी उठ खड़े होवैगें, अर बड़े-बड़े चमत्कार, अर अनोक्खे काम दिखावैगें के जै हो सक्या तो छाँटे होया ताहीं भी भका देवैगें। ");
INSERT INTO bgc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देक्खो, मन्नै पैहल्याए थारे तै यो सारा कुछ कह दिया सै। ");
INSERT INTO bgc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“इस करकै जै वे थारे तै कहवै, ‘देक्खो, वो बण म्ह सै’, तो बाहरणै ना लिकड़यो; या ‘देक्खो, वो कोठड़ी म्ह सै’, तो बिश्वास ना करियो। ");
INSERT INTO bgc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","क्यूँके जिस तरियां बिजळी पूरब तै लिकड़कै पश्चिम ताहीं चमकै सै, उस्से तरियां मुझ माणस के बेट्टे का भी आणा होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","जड़ै लाश हो, उड़ैए चील कठ्ठे होवैगें।” ");
INSERT INTO bgc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","उन दिनां के क्ळेश कै पाच्छै जिब्बे सूरज अन्धेरै म्ह हो जावैगा, चाँद का चाँदणा जान्दा रहवैगा, अर तारे अकास तै तळै पड़ैंगें, अर अकास की शक्तियाँ हलाई जावैंगी। ");
INSERT INTO bgc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","फेर माणस के बेट्टे का निशान अकास म्ह दिखैगा, अर फेर धरती के सारे खानदान्ना के माणस छात्त्ती पिटैगें; अर माणस के बेट्टे ताहीं बड्डी सामर्थ अर महिमा कै गेल्या अकास के बादळां पै आन्दे देक्खोगे। ");
INSERT INTO bgc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","वो तुरही की तेज आवाज कै गेल्या अपणे सुर्गदूत्तां नै खन्दावैगा, अर वे अकास के इस सिरे तै उस सिरे ताहीं, च्यारु दिशायां तै उसके चुणे होया नै कठ्ठे करैगें। ");
INSERT INTO bgc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","अंजीर के दरखत तै यो उदाहरण सीक्खो: जिब उसकी डाळी कोमल हो जावै अर पत्ते लिकड़ण लाग ज्या सै, तो थम जाण ल्यो के गर्मी का बखत लोवै सै। ");
INSERT INTO bgc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","इस्से तरियां तै जिब थम इन सारी बात्तां नै देक्खो, तो जाण ल्यो के वो लोवै सै, बल्के दरबाजे पै सै। ");
INSERT INTO bgc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","मै थमनै साच्ची कहूँ सूं के जिब ताहीं ये सारी बात पूरी ना हो लेवै, जद ताहीं इस पीढ़ी का अन्त कोनी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","धरती अर अकास टळ जावैंगे, पर मेरी बात कदे न्ही टळैगी। ");
INSERT INTO bgc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“उस दिन अर उस बखत कै बारै म्ह कोए न्ही जाण्दा, ना सुर्गदूत अर ना बेट्टा, पर सिर्फ पिता। ");
INSERT INTO bgc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जिसा पूर्वज नूह के दिनां होया था, उस्से तरियां ए माणस के बेट्टे का आणा होगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","क्यूँके जिस तरियां बाढ़ तै पैहले के दिनां म्ह, जिस दिन ताहीं नूह जहाज पै न्ही चढ़या, उस दिन ताहीं माणस खावै-पीवै थे, अर उन म्ह ब्याह होवै थे। ");
INSERT INTO bgc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","अर जिब ताहीं बाढ़ आकै उन सारया ताहीं बहा न्ही लेग्या, जद ताहीं उननै किमे बेरा न्ही पाट्या; इस्से तरियां ए मुझ माणस के बेट्टे का आणा भी होगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","उस बखत दो जणे खेत म्ह होंगे, एक ठाया जावैगा अर दुसरा छोड़ दिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दो बिरबान्नी एक साथ चाक्की पीसदी होवैगी, एक ठा ली जावैगी अर दुसरी छोड़ दी जावैगी।” ");
INSERT INTO bgc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","इस करकै जागदे रहो, क्यूँके थमनै न्ही बेरा के थारा प्रभु किस दिन आवैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पर न्यू जाण ल्यो के जै घर का माल्लिक नै बेरा हो के चोर किस घड़ी आवैगा तो जागदा रहन्दा, अर अपणे घर म्ह सेंध लागण न्ही देन्दा। ");
INSERT INTO bgc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ज्यांतै थम भी त्यार रहो, क्यूँके जिस घड़ी कै बारै म्ह थम सोचदे भी कोनी, उस्से घड़ी मै माणस का बेट्टा आ जाऊँगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“आखर म्ह वो बिश्वास जोग्गा अर अकलमंद दास कौण सै, जिस ताहीं माल्लिक नै अपणे नौक्कर-चाकरां पर सरदार ठहराया के बखत पै उननै खाणा देवै? ");
INSERT INTO bgc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","धन्य सै वो नौक्कर, जिस ताहीं उसका माल्लिक आकै इसाए करदा पावै। ");
INSERT INTO bgc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मै थमनै साच्ची कहूँ सूं, वो उसनै अपणी सारी धन-सम्पत्ति का माल्लिक बणावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","पर जै वो दुष्ट दास सोच्चण लाग्गै के मेरै माल्लिक कै आण म्ह वार सै, ");
INSERT INTO bgc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","अर अपणे साथी नौकरां नै पिट्टण लाग्गै, अर शराबियाँ कै गेल्या खावै-पीवै। ");
INSERT INTO bgc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","तो उस नौक्कर का माल्लिक उस दिन बोहड़ैगा, जिब वो उसकी बाट ना देख्दा हो, अर इसे बखत म्ह आवैगा जिसका उसनै ना बेरा हो, ");
INSERT INTO bgc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","जिब वो उसनै भारी सजा देगा उसकी गिणती कपटियाँ कै म्ह गिणी जावैगी: ओड़ै रोणा अर दाँत पिसणा होगा।” ");
INSERT INTO bgc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","यीशु नै अपणे चेल्यां ताहीं एक और उदाहरण देकै कह्या, “सुर्ग का राज्य उन दस कुँवारियाँ के जिसा होगा जो अपणी मशाल लेकै बन्दड़े तै फेटण लिकड़ी। ");
INSERT INTO bgc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","उन म्ह पाँच बेअक्ल अर पाँच समझदार थी। ");
INSERT INTO bgc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","बेअक्ली कुवारियाँ नै अपणी मशाल तो ली, पर अपणे गेल्या फालतू तेल न्ही लिया; ");
INSERT INTO bgc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पर समझदारां नै अपणी मशालां कै गेल्या अपणी कुप्पियाँ म्ह तेल भी भर लिया। ");
INSERT INTO bgc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जिब बन्दड़े कै आण म्ह वार होई, तो वे सारी ऊँघण लाग्गी अर सोगी।” ");
INSERT INTO bgc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“आध्धी रात नै धूम माच्ची: ‘देक्खो, बन्दड़ा आण लागरया सै! उसतै फेटण नै चाल्लों।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“फेर वे सारी कुँवारियाँ उठकै अपणी मशाल ठीक करण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","अर बेअक्लियाँ नै समझदारां तै कह्या, ‘अपणे तेल म्ह तै कुछ हमनै भी द्यो, क्यूँके म्हारी मशाल बुझ्झण लागरी सै।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“पर समझदारां नै जवाब दिया, ‘कदे यो म्हारै अर थारे खात्तर पूरा ना पड़ै; भला तो योए सै के थम बेचणीयाँ कै धोरै जाकै अपणे खात्तर मोल लियाओ।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जिब वे मोल लेण नै जावै थी तो बन्दड़ा आण पोंहच्या, अर जो त्यार थी, वे उसकै गेल्या ब्याह कै घर म्ह चली गई अर बारणा मूंद दिया गया। ");
INSERT INTO bgc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“इसकै पाच्छै वे दुसरी कुँवारियाँ भी बोहड़कै आई अर बन्दड़े तै कहण लाग्गी, ‘हे माल्लिक, हे माल्लिक, म्हारै खात्तर किवाड़ खोल दे।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“उसनै जवाब दिया, ‘मै थारे ताहीं साच्ची कहूँ सूं, मै थमनै कोनी जाण्दा।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","इस करकै चोक्कने रहो, क्यूँके मेरे आण के उस दिन नै थम कोनी जाणते, ना उस घड़ी नै जिस दिन म्ह आऊँगा। ");
INSERT INTO bgc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","सुर्ग का राज्य उस माणस के उदाहरण के समान भी सै, जिसनै परदेस जान्दे बखत अपणे नौकरां ताहीं बुलाकै अपणी कुछ सम्पत्ति उन ताहीं सौप दी, ताके वे व्यापर करकै घणा धन जोड़ ले। ");
INSERT INTO bgc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","उसनै एक तै पाँच तोड़े (1 तोड़ा 15 साल की मजदूरी के बराबर सै), दुसरे ताहीं दो, अर तीसरे ताहीं एक; यानिके हरेक नै उसकी काबिलियत कै मुताबिक दिया, अर फेर परदेस चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","फेर, जिस ताहीं पाँच तोड़े मिले थे, उसनै जिब्बे जाकै उनतै लेण-देण करया, अर पाँच तोड़े और कमाए। ");
INSERT INTO bgc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","इस्से तरियां तै जिस ताहीं दो मिले थे, उसनै भी दो और कमाए। ");
INSERT INTO bgc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पर जिस ताहीं एक मिल्या था, उसनै जाकै माट्टी खोद्दी, अर अपणे माल्लिक का धन लह्को दिया। ");
INSERT INTO bgc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","घणे दिनां पाच्छै उन नौकरां का माल्लिक आया, अर उनतै हिसाब लेण लाग्या, के उननै उन पईसा तै के कुछ करया। ");
INSERT INTO bgc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जिसनै पाँच तोड़े मिले थे, उसनै पाँच तोड़े और ल्याकै कह्या, हे माल्लिक, तन्नै मेरै ताहीं पाँच तोड़े सौप्पे थे, लखा, मन्नै ये पाँच तोड़े और कमाए सै। ");
INSERT INTO bgc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","उसकै माल्लिक नै उसतै कह्या, शाबाश, हे भरोस्से के लायक आच्छे नौक्कर, तू थोड़े-से धन म्ह भी भरोसमंद लिकड़या, मै तन्नै घणी चिज्जां का अधिकारी बणाऊँगा। अपणे माल्लिक कै आनन्द म्ह साझ्झी हो। ");
INSERT INTO bgc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","फेर जिस ताहीं दो तोड़े मिले थे, उसनै भी आकै कह्या, हे माल्लिक, तन्नै मेरै ताहीं दो तोड़े सौप्पे थे, देख, मन्नै दो तोड़े और कमाए सै। ");
INSERT INTO bgc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","उसकै माल्लिक नै उसतै कह्या, शाबाश, हे भरोस्से के लायक आच्छे नौक्कर, तू थोड़े म्ह भी भरोसमंद लिकड़या; मै तन्नै घणी चिज्जां का अधिकारी बणाऊँगा। अपणे माल्लिक कै आनन्द म्ह साझ्झी हो। ");
INSERT INTO bgc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","फेर जिस ताहीं एक तोड़ा मिल्या था, उसनै आकै कह्या, हे माल्लिक, मै तन्नै जाणु था, के तू इसा माणस सै: जित्त किते तू बीज न्ही बोन्दा ओड़ै फसल काट्टै सै, अर जित्त न्ही खिंडान्दा ओड़ै तै कठ्ठा करै सै। ");
INSERT INTO bgc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","जै मै तेरा तोड़ा खो देता तो तू मन्नै दण्ड देता, ज्यांतै मै डरग्या अर जाकै तेरा तोड़ा माट्टी म्ह दबा दिया। देख, जो तेरा सै, वो यो सै। ");
INSERT INTO bgc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","उसकै माल्लिक नै उस ताहीं जवाब दिया, हे दुष्ट अर आलसी नौक्कर, जिब तन्नै न्यू बेरा था के जित्त मन्नै बीज न्ही बोया ओड़ै तै फसल काट्टू सूं, अर जित्त मन्नै न्ही खिंडाया ओड़ै तै कठ्ठा करुँ सूं; ");
INSERT INTO bgc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","जै तन्नै बेरा था के मै इसा सूं, तो तू मेरा धन सर्राफां नै ए दे देंदा, फेर मै आकै अपणा धन ब्याज सुधां ले लेन्दा। ");
INSERT INTO bgc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","माल्लिक नै अपणे नौकरां तै कह्या, ज्यातै वो तोड़ा उसतै ले ल्यो, अर जिसकै धोरै दस तोड़े सै उसनै दे द्यो। ");
INSERT INTO bgc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","क्यूँके जिस किसे धोरै सै, उस ताहीं और दिया जावैगा; अर उसकै धोरै घणा हो जावैगा: पर जिसकै धोरै न्ही सै, उसतै वो भी जो उसकै धोरै सै, ले लिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","इस निकम्मे नौक्कर नै बाहर अन्धेरै म्ह गेर द्यो, जित्त रोणा अर दाँत पिसणा होगा। ");
INSERT INTO bgc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","जिब मै माणस का बेट्टा अपणी महिमा म्ह आऊँगा अर सारे सुर्गदूत मेरे गेल्या आवैगें, तो मै अपणी महिमा कै सिंहासन पै बैठ्ठुंगा। ");
INSERT INTO bgc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","अर सारी जात मेरे स्याम्ही कठ्ठी करी जावैगी; अर जिस ढाळ पाळी भेड्डां नै बकरियाँ तै न्यारी कर देवै सै, उस्से तरियां मै उननै एक-दुसरे तै न्यारा करुँगा। ");
INSERT INTO bgc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","मै भेड्डां नै अपणी सोळी ओड़ अर बकरियाँ नै ओळी ओड़ खड्या करुँगा। ");
INSERT INTO bgc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“फेर मै राजा अपणी सोळी ओड़ आळा नै कहूँगा, ‘हे मेरे पिता के धन्य माणसों, आओ, उस राज्य के हकदार हो जाओ, जो दुनिया की शरुआत तै थारे खात्तर त्यार करया गया सै। ");
INSERT INTO bgc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","क्यूँके जिब मै भूक्खा था, तो थमनै मेरै ताहीं खाण नै दिया; मै तिसाया था, तो थमनै मेरै ताहीं पाणी पिलाया; मै परदेशी था, तो थमनै मेरै ताहीं अपणे घरां ठहराया; ");
INSERT INTO bgc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","मै उघाड़ा था, तो थमनै मेरै ताहीं लत्ते पिहराए; मै बीमार था, तो थमनै मेरा बेरा लिया, मै जेळ म्ह था, तो थम मेरै तै मिलण आये।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“फेर धर्मी उस ताहीं जवाब देवैगें, ‘हे प्रभु, हमनै कद तेरे ताहीं भूक्खा देख्या अर खुवाया? या कद तिसाया देख्या अर पाणी पिलाया? ");
INSERT INTO bgc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हमनै कद तेरे ताहीं परदेशी देख्या अर अपणे घरां ठहराया? या उघाड़ा देख्या अर लत्ते पिहराये? ");
INSERT INTO bgc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","हमनै कद तेरे ताहीं बीमार या जेळ म्ह देख्या अर तेरा बेरा लेण आये?’” ");
INSERT INTO bgc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“फेर मै राजा उननै जवाब देऊँगा, ‘मै थमनै साच्ची कहूँ सूं के थमनै जो मेरे इन छोट्या तै छोट्टे बिश्वासी भाईयाँ म्ह तै किसे एक कै गेल्या करया, वो मेरै ए गेल्या करया।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“फेर मै ओळै कान्ही आळा ताहीं कहूँगा, ‘हे श्रापित माणसों, मेरै स्याम्ही तै उस अनन्त आग म्ह चले जाओ, जो परमेसवर नै शैतान अर उसके दूत्तां खात्तर त्यार करी सै। ");
INSERT INTO bgc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","क्यूँके मै जिब भूक्खा था, तो थमनै मेरै ताहीं खाण नै कोनी दिया; मै तिसाया था, तो थमनै मेरै ताहीं पाणी कोनी पियाया; मै जिब परदेशी था, तो थमनै मेरै ताहीं अपणे घरां कोनी ठहराया; ");
INSERT INTO bgc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मै नंगा था, तो थमनै मेरै ताहीं लत्ते कोनी पिहराए; मै जिब बीमार था, तो थमनै मेरा बेरा कोनी लिया, मै जेळ म्ह था, तो थम मेरै तै मिलण कोनी आये।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“फेर वे जवाब देवैगें, ‘हे प्रभु, हमनै तेरे ताहीं कद भूक्खा, या तिसाया, या परदेशी, या उघाड़ा, या बीमार, या जेळ म्ह देख्या, अर तेरी सेवा-पाणी न्ही करी?’” ");
INSERT INTO bgc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“फेर मै उननै जवाब देऊँगा, ‘मै थमनै साच्ची कहूँ सूं के थमनै जो मेरे इन छोट्या तै छोट्या म्ह तै किसे एक कै गेल्या न्ही करया, वो मेरै गेल्या भी न्ही करया।’” ");
INSERT INTO bgc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“अर अधर्मी जन अनन्त दण्ड भोगैगें पर धर्मी जन अनन्त जीवन म्ह दाखल होंगे।” ");
INSERT INTO bgc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जिब यीशु नै ये सारी बात कह ली तो अपणे चेल्यां तै कहण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“थमनै बेरा सै के दो दिनां पाच्छै फसह का त्यौहार सै, अर मै माणस का बेट्टा क्रूस पै चढ़ाण कै खात्तर पकड़वाया जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","फेर प्रधान याजक अर प्रजा के यहूदी अगुवें, काइफा नामक महायाजक कै आँगण म्ह कठ्ठे होए, ");
INSERT INTO bgc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","अर आप्पस म्ह विचार करण लाग्गे के यीशु ताहीं धोक्खे तै पकड़कै मार देवा। ");
INSERT INTO bgc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पर वे कहवै थे, “त्यौहार कै बखत न्ही, कदे इसा ना हो के माणसां म्ह रोळा माच ज्या।” ");
INSERT INTO bgc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जिब यीशु बैतनिय्याह गाम म्ह शमौन कोढ़ी कै घरां था, ");
INSERT INTO bgc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","तो एक बिरबान्नी संगमरमर कै बरतन म्ह महँगा खसबूदार तेल लेकै उसकै धोरै आई, अर जिब वो खाणा खाण नै बेठ्या था तो उसकै सिर पै उंडेल दिया। ");
INSERT INTO bgc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","न्यू देखकै उसके चेल्लें खीजकै अर कहण लाग्गे, “इसका क्यांतै नाश करया गया? ");
INSERT INTO bgc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","इस ताहीं तो बढ़िया दाम्मां पै बेचकै कंगालां म्ह बांडया जा सकै था।” ");
INSERT INTO bgc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","न्यू जाणकै यीशु नै उनतै कह्या, “बिरबान्नी नै क्यांतै सताओ सो? उसनै मेरै गेल्या भलाई करी सै। ");
INSERT INTO bgc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","कंगाल तो थारे गेल्या सारी हाण रहवै सै, पर मै थारे गेल्या सारी हाण कोनी रहूँगा। ");
INSERT INTO bgc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","उसनै मेरी देह पै जो यो महँगा खसबूदार तेल उंडेला सै, वो मेरे गाड़े जाणकै खात्तर करया सै। ");
INSERT INTO bgc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","मै थमनै साच्ची कहूँ सूं, के सारे दुनिया म्ह जित्त किते भी यो सुसमाचार प्रचार करया जावैगा, ओड़ै उसकै इस काम का जिक्र भी उसकी याद म्ह करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","फेर यहूदा इस्करियोती नै, जो बारहां चेल्यां म्ह तै एक था, प्रधान याजकां कै धोरै जाकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“जै मै यीशु नै थारे हाथ्थां म्ह पकड़वा दियुँ, तो मन्नै के द्योगे?” उननै तीस चाँदी के सिक्के तौलकै दे दिये। ");
INSERT INTO bgc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","अर वो उस्से बखत तै यीशु नै पकड़वाण का मौक्का टोह्ण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","अखमीरी रोट्टी कै त्यौहार कै पैहल्ड़े दिन, चेल्लें यीशु कै धोरै आकै बुझ्झण लाग्गे, “तू कित्त चाहवै सै के हम तेरे खात्तर फसह खाण की त्यारी करा?” ");
INSERT INTO bgc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","यीशु बोल्या, “नगर म्ह फलाणा माणस नै जाकै उसतै कहो, ‘गुरु कहवै सै के मेरा बखत लोवै सै। मै अपणे चेल्यां कै गेल्या तेरे उरै फसह का त्यौहार बणाऊँगा’।” ");
INSERT INTO bgc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","आखर चेल्यां नै यीशु का हुकम मान्या अर फसह का भोज त्यार करया। ");
INSERT INTO bgc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जिब साँझ होई तो यीशु बारहां चेल्यां कै गेल्या खाणा खाण कै खात्तर बेठ्या। ");
INSERT INTO bgc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जिब वे खाण लागरे थे तो यीशु नै कह्या, “मै थमनै साच्ची कहूँ सूं के थारे म्ह तै एक मन्नै धोक्खा देकै पकड़वावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","इसपै चेल्लें घणे उदास होए, अर हरेक उसतै बुझ्झण लाग्या, “हे गुरु, के वो मै सूं?” ");
INSERT INTO bgc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","यीशु नै जवाब दिया, “जिसनै मेरै गेल्या थाळी म्ह हाथ घाल्या सै, वोए मन्नै पकड़वावैगा। ");
INSERT INTO bgc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मै माणस का बेट्टा तो जिसा मेरे बारै म्ह लिख्या सै, अर जावै ए सै; पर उस माणस पै धिक्कार सै जिसकै जरिये मै माणस का बेट्टा पकड़वाया जाऊँगा: जै उस माणस का जन्म ए न्ही होंदा, तो उसकै खात्तर भला होंदा।” ");
INSERT INTO bgc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","फेर यीशु कै पकड़वाण आळे यहूदा नै कह्या, “हे गुरु, के वो मै सूं?” यीशु उसतै बोल्या, “तन्नै कह लिया।” ");
INSERT INTO bgc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जिब वे फसह खाण लागरे थे, तो यीशु नै रोट्टी ली, अर आशीष माँगकै तोड़ी, अर चेल्यां ताहीं देकै कह्या, “ल्यो, खाओ; या मेरी देह सै।” ");
INSERT INTO bgc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","फेर यीशु नै अपणा कटोरा लेकै परमेसवर का धन्यवाद करया, अर उन ताहीं देकै कह्या, “थम सारे इस म्ह तै पियो, ");
INSERT INTO bgc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","क्यूँके यो करार का मेरा वो लहू सै, जो घणखरयां कै खात्तर पापां की माफी कै खात्तर बहाया जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","मै थमनै साच्ची कहूँ सूं के अंगूर का यो रस उस दिन ताहीं कदे न्ही पिऊँगा, जिब थारे गेल्या अपणे पिता कै राज्य म्ह नया न्ही पीऊँ।” ");
INSERT INTO bgc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","फेर वे भजन गाकै जैतून कै पहाड़ पै गए। ");
INSERT INTO bgc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","फेर यीशु नै उनतै कह्या, “थम आज ए रात नै मेरै बाबत ठोक्कर खाओगे, क्यूँके लिख्या सै: ‘मै पाळी नै मारूँगा, अर टोळ की भेड़ तित्तर-बितर हो जावैंगी।’” ");
INSERT INTO bgc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“पर मै अपणे जिन्दा उठण कै बाद थारे तै पैहल्या गलील परदेस म्ह मिलूगाँ।” ");
INSERT INTO bgc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","इसपै पतरस नै उसतै कह्या, “जै सारे छोड़ै तो छोड़ै, पर मै तेरा साथ कदे न्ही छोड़ूँगा।” ");
INSERT INTO bgc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीशु नै उसतै कह्या, “मै तेरे तै सच कहूँ सूं के आज ए रात नै मुर्गे के बाँग देण तै पैहल्या, तू तीन बर मेरै बारै म्ह मुकरैगा।” ");
INSERT INTO bgc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरस नै उसतै कह्या, “जै मन्नै तेरे गेल्या मरणा भी पड़ै, तोभी मै तेरा इन्कार कदे कोनी करुँगा।” इस्से तरियां और सारे चेल्यां नै भी न्यूए कह्या। ");
INSERT INTO bgc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","फेर यीशु अपणे चेल्यां कै गेल्या गतसमनी नामक एक जगहां म्ह आया अर अपणे चेल्यां तै कहण लाग्या, “उरैए बेठ्ठे रहियो, जिब ताहीं मै ओड़ै प्रार्थना करुँ।” ");
INSERT INTO bgc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","वो पतरस अर जब्दी के दोन्नु बेट्टा नै गेल्या लेग्या, अर उदास अर कांल होण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","फेर उसनै उनतै कह्या, “मेरा मन घणा उदास सै, उरै ताहीं के मेरा जी लिकड़ण नै होरया सै। थम उरै ठहरो अर जागदे रहो।” ");
INSERT INTO bgc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","फेर वो माड़ा और आग्गै सरक कै मुँह कै बळ गिरया, अर या प्रार्थना करण लाग्या, “हे मेरे पिता, जै हो सकै तो यो दुख का कटोरा मेरै तै टळ जावै, तोभी जिसा मै चाहूँ सूं इसा न्ही, पर जिसा तू चाहवै सै उस्से तरियां ए होवै।” ");
INSERT INTO bgc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","फेर उसनै चेल्यां कै धोरै आकै उन ताहीं सोन्दे पाया अर पतरस तै कह्या, “के थम मेरै गेल्या एक घड़ी भी कोनी जाग सके? ");
INSERT INTO bgc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागदे रहो, अर प्रार्थना करदे रहो के थम परखे ना जाओ, आत्मा तो त्यार सै पर देह कमजोर सै।” ");
INSERT INTO bgc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","फेर उसनै दुसरी बार जाकै या प्रार्थना करी, “हे मेरे पिता, जै यो मेरै पिए बिना न्ही हट सकदा, तो तेरी मर्जी पूरी हो।” ");
INSERT INTO bgc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","फेर उसनै आकै उन ताहीं फेर सोन्दे पाया, क्यूँके उनकी आँखां म्ह नींद भरी थी। ");
INSERT INTO bgc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","उननै छोड़कै वो फेर चल्या गया, अर उन्हे शब्दां म्ह फेर तीसरी बार प्रार्थना करी। ");
INSERT INTO bgc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","फेर उसनै चेल्यां कै धोरै आकै उनतै कह्या, “इब सोन्दे रहो, अर आराम करो: देक्खो, बखत आण पोंहच्या सै, अर मै माणस का बेट्टा पापियाँ के हाथ्थां पकड़वाया जाऊँगा। ");
INSERT INTO bgc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठो, चाल्लां; देक्खो, मेरा पकड़ाण आळा धोरै आण पोंहच्या सै।” ");
INSERT INTO bgc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","वो न्यू कहण ए लागरया था के यहूदा जो बारहां चेल्यां म्ह तै एक था आया, अर उसकै गेल्या प्रधान याजकां अर यहूदी अगुवां की ओड़ तै बड्डी भीड़, तलवार अर लाठ्ठी लिये होए, आई। ");
INSERT INTO bgc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","यीशु कै पकड़वाण आळे यहूदा नै उन ताहीं यो इशारा दिया था: “जिस ताहीं मै चूम ल्यूँ वोए सै; उस ताहीं पकड़ लियो।” ");
INSERT INTO bgc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","अर जिब्बे यीशु कै धोरै आकै कह्या, “हे गुरु, नमस्कार!” अर उस ताहीं घणा चुम्या। ");
INSERT INTO bgc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीशु नै उसतै कह्या, “हे दोस्त, जिस काम कै खात्तर तू आया सै, उसनै करले।” फेर उननै धोरै आकै यीशु पै हाथ गेरया अर उस ताहीं पकड़ लिया। ");
INSERT INTO bgc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","यीशु के साथियाँ म्ह तै एक नै हाथ बढ़ाकै अपणी तलवार खींच ली अर महायाजक के नौक्कर पै चलाकै उसका कान उड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","फेर यीशु नै उसतै कह्या, “अपणी तलवार म्यान म्ह धर ले क्यूँके जो तलवार चलावै सै वे सारे तलवार तै नाश करे जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","के तन्नै न्ही बेरा के मै अपणे पिता तै बिनती कर सकूँ सूं, अर वो सुर्गदूत्तां की बारहां पलटन तै घणे मेरै धोरै इब्बे हाजर कर देवैगा? ");
INSERT INTO bgc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पर पवित्र ग्रन्थ की ये बात के इसाए होणा जरूरी सै, किस ढाळ पूरी होवैगी?” ");
INSERT INTO bgc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","उस बखत यीशु नै भीड़ तै कह्या, “के थम तलवार अर लाठ्ठी लेकै मन्नै डाकू की ढाळ पकड़ण कै खात्तर लिकड़े सो? मै हरेक दिन मन्दर म्ह बैठकै उपदेश दिया करुँ था, अर थमनै मेरै ताहीं कोनी पकड्या। ");
INSERT INTO bgc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","पर यो सारा ज्यांतै होया सै के नबियाँ के वचन पूरे होवै।” फेर सारे चेल्लें उसनै छोड़कै भाजगे। ");
INSERT INTO bgc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","फेर यीशु के पकड़ण आळे उस ताहीं काइफा नामक महायाजक कै धोरै लेगे, जित्त शास्त्री अर यहूदी अगुवें कठ्ठे होए थे। ");
INSERT INTO bgc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","पतरस दूर ए दूर उसकै पाच्छै-पाच्छै महायाजक कै आँगण ताहीं गया, अर भीत्त्तर जाकै अन्त देखण नै सिपाहियाँ कै गेल्या बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","सारे प्रधान याजक अर यहूदी अगुवां की सभा यीशु नै मारण कै खात्तर उसकै बिरोध म्ह झूठ्ठी गवाही की टोह् म्ह थे, ");
INSERT INTO bgc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पर घणखरे झूठ्ठे गवाह कै आण पै भी कोनी पाई। आखर म्ह दो जणे आये, ");
INSERT INTO bgc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","अर बोल्ले, “इसनै कह्या सै के मै परमेसवर कै मन्दर नै गेर सकूँ सूं अर उस ताहीं तीन दिन म्ह बणा सकूँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","फेर महायाजक नै खड़े होकै यीशु तै कह्या, “के तू कोए जवाब न्ही देंदा? ये माणस तेरे बिरोध म्ह के गवाही देवै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पर यीशु बोल-बाल्ला रहया। फेर महायाजक नै उसतै कह्या, “मै तन्नै जिन्दे परमेसवर की कसम दियुँ सूं के जै तू परमेसवर का बेट्टा मसीह सै, तो म्हारै ताहीं कह दे।” ");
INSERT INTO bgc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीशु नै उसतै कह्या, “तन्नै आप ए कह दिया; बल्के मै तेरे तै यो भी कहूँ सूं के इब तै थम मुझ माणस के बेट्टे नै सब तै सर्वशक्तिमान की सोळी ओड़ बेठ्ठे, अर अकास के बादळां पै आन्दे देक्खोगे।” ");
INSERT INTO bgc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","फेर महायाजक नै अपणे लत्ते पाड़कै कह्या, “इसनै परमेसवर की बुराई करी सै, इब हमनै गवाह की के जरूरत? देक्खो, थमनै इब्बे या बुराई सुणी सै! ");
INSERT INTO bgc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","थम के सोच्चो सो?” उननै जवाब दिया, “यो मारण जोग्गा सै।” ");
INSERT INTO bgc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","फेर उननै उसकै मुँह पै थुक्या अर उसकै घुस्से मारे, दुसरयां नै थप्पड़ मारकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“हे मसीह, म्हारै तै भविष्यवाणी करकै कह के किसनै तेरे ताहीं मारया?” ");
INSERT INTO bgc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस बाहरणै आँगण म्ह बेठ्या था के एक नौकराणी उसकै धोरै आई अर बोल्ली, “तू भी तो गलीलवासी यीशु कै गेल्या था।” ");
INSERT INTO bgc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","उसनै सारया कै स्याम्ही यो कहकै नाट्या, “मन्नै न्ही बेरा तू के कहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","जिब वो बाहरणै देहळियाँ म्ह गया, तो दुसरी नौकराणी उसनै देखकै उनतै जो ओड़ै थे कह्या, “यो भी तो यीशु नासरी कै गेल्या था।” ");
INSERT INTO bgc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","वो कसम खाकै फेर नाट्या: “मै उस माणस नै कोनी जाण्दा।” ");
INSERT INTO bgc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","माड़ी बार पाच्छै माणसां नै जो ओड़ै खड़े थे, पतरस कै धोरै आकै उसतै कह्या, “साच्चए तू भी उन म्ह तै एक सै, क्यूँके तेरी बोल्ली तेरा भेद खोल्लै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","फेर वो धिक्कारण अर कसम खाण लाग्या: “मै उस माणस नै कोनी जाण्दा।” जिब्बे मुर्गे नै बाँग देई। ");
INSERT INTO bgc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","जिब पतरस नै यीशु की कही होई बात याद आई “मुर्गे कै बाँग देण तै पैहल्या तीन बर तू मेरा इन्कार करैगा।” अर वो बारणै ज्याकै फूट-फूटकै रोण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","तड़कै ए तड़कै सारे प्रधान याजकां अर यहूदी अगुवां नै यीशु ताहीं मारण की सलाह करी। ");
INSERT INTO bgc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","उननै यीशु ताहीं बाँधया अर ले जाकै पिलातुस राज्यपाल कै हाथ्थां म्ह सौप दिया। ");
INSERT INTO bgc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जिब उसकै पकड़वाण आळे यहूदा नै अहसास होया के यीशु ताहीं मौत की सजा सुणाई गई सै तो वो पसताया अर वे तीस चाँदी के सिक्के प्रधान याजकां अर यहूदी अगुवां ताहीं बोहड़ाया ");
INSERT INTO bgc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","अर कह्या, “मन्नै बेकसूर माणस ताहीं मारण कै खात्तर पकड़वाकै पाप करया सै।” उननै कह्या, “हमनै के मतलब? तू ए जाणै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","फेर वो उन सिक्का नै मन्दर के आँगण म्ह बगाकै बाहरणै चल्या गया, अर जाकै अपणे-आप ताहीं फाँसी लगा ली। ");
INSERT INTO bgc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","प्रधान याजकां नै उन सिक्का ताहीं लेकै कह्या, “म्हारे नियम-कायदे इस बात की इजाजत कोनी देंदा के हम इन सिक्कयां नै मन्दर के खजान्ने म्ह धरा, क्यूँके इसका इस्तमाल किसे ताहीं मारवाण खात्तर करया गया सै, या लहू की किम्मत सै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","आखर म्ह उननै सलाह करकै उन सिक्कयां तै परदेशियाँ के गाड्डे जाणकै खात्तर कुम्हार का खेत मोल ले लिया। ");
INSERT INTO bgc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","इस कारण वो खेत आज ताहीं लहू का खेत कुह्वावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ताके जो वचन यिर्मयाह नबी कै जरिये कह्या गया था वो पूरा होया: “उननै वे तीस सिक्के यानिके उस ठहराए होए मोल ताहीं (जिस ताहीं इस्राएल की ऊलाद म्ह तै कितन्याँ नै ठहराया था) ले लिया, ");
INSERT INTO bgc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","अर जिस तरियां प्रभु नै मेरै ताहीं हुकम दिया था, उस्से तरियां ए उननै कुम्हार के खेत नै खरीदण खात्तर उसका इस्तमाल करया।” ");
INSERT INTO bgc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","जिब यीशु राज्यपाल कै स्याम्ही खड्या था तो राज्यपाल नै उसतै बुझ्झया, “के तू यहूदियाँ का राजा सै?” यीशु नै उसतै कह्या, “तू आप ए कहण लागरया सै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","जिब प्रधान याजक अर यहूदी अगुवें उसपै इल्जाम लावै थे, तो उसनै कुछ जवाब कोनी दिया। ");
INSERT INTO bgc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","इसपै पिलातुस नै उसतै कह्या, “के तू न्ही सुणदा के ये तेरे बिरोध म्ह कितनी गवाही देवै सै?” ");
INSERT INTO bgc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","पर उसनै उस ताहीं एक बात का भी जवाब कोनी दिया, उरै ताहीं के राज्यपाल ताहीं घणी हैरानी होई। ");
INSERT INTO bgc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","राज्यपाल का यो रिवाज था के उस त्यौहार म्ह माणसां कै खात्तर किसे एक कैदी नै जिसनै वे चाहवै थे, रिहा कर देवै था। ");
INSERT INTO bgc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","उस बखत उनकै उरै बरअब्बा नाम का एक मान्या होड़ कैदी था। ");
INSERT INTO bgc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","आखर जिब वो कठ्ठे होए, तो पिलातुस नै उनतै कह्या, “थम किसनै चाहो सो के मै थारे खात्तर रिहा करुँ? बरअब्बा ताहीं, या यीशु ताहीं जो मसीह कुह्वावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","क्यूँके उसनै बेरा था के उननै उस ताहीं जळण तै पकड़वाया था। ");
INSERT INTO bgc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जिब वो न्याय की गद्दी पै बेठ्या होया था तो उसकी घरआळी नै उस ताहीं कुहवां भेज्या, “तू उस धर्मी कै मामलै म्ह हाथ ना गेरिये, क्यूँके मन्नै आज सपनै म्ह उसकै कारण घणा दुख ठाया सै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","प्रधान याजकां अर यहूदी अगुवां नै माणसां ताहीं उकसाया के वे बरअब्बा नै माँग ले, अर यीशु का नाश करावै। ");
INSERT INTO bgc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","राज्यपाल नै उसतै बुझ्झया, “इन दोनुआ म्ह तै किसनै चाहो सो के मै थारे खात्तर छोड़ दियुँ?” उननै कह्या, “बरअब्बा ताहीं।” ");
INSERT INTO bgc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातुस नै उनतै कह्या, “फेर यीशु ताहीं, जो मसीह कुह्वावै सै, के करुँ?” सारया नै उसतै कह्या, “यीशु क्रूस पै चढ़ाया जावै!” ");
INSERT INTO bgc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","हाकिम नै कह्या, “क्यांतै, उसनै के बुरा करया सै?” पर वे और भी रुक्के मारण लाग्गे, “वो क्रूस पै चढ़ाया जावै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जिब पिलातुस नै देख्या के किमे न्ही बण पडरया पर उल्टा दंगा बढ़दा जावै सै, तो उसनै पाणी लेकै भीड़ कै स्याम्ही अपणे हाथ धोए अर कह्या, “मै इस धर्मी कै लहू तै बेकसूर सूं: थमे जाणो।” ");
INSERT INTO bgc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","सारे माणसां नै जवाब दिया, “इसकी मौत के जिम्मेदार हम अर म्हारी ऊलाद होवांगे!” ");
INSERT INTO bgc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","इसपै उसनै बरअब्बा ताहीं उनकै खात्तर रिहा कर दिया, अर यीशु कै कोड़े लगवाकै सौप दिया, के क्रूस पै चढ़ाया जावै। ");
INSERT INTO bgc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","फेर राज्यपाल के सिपाहियाँ नै यीशु ताहीं किले म्ह ले जाकै सारी पलटन उसकै चौगरदे नै कठ्ठी करी, ");
INSERT INTO bgc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","अर उसके लत्ते तारकै उस ताहीं लाल रंग का चोग्गा पिहराया, ");
INSERT INTO bgc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","अर काण्डयाँ का ताज गुन्दकै उसकै सिर पै धरया, अर उसकै सोळे हाथ्थां म्ह सरकण्डा दिया अर उसकै आग्गै गोड्डे टेक कै उसका मखौल उड़ाण लाग्गे अर कह्या, “हे यहूदिया परदेस के राजा, नमस्कार!” ");
INSERT INTO bgc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","अर उसपै थुक्या; अर वोए सरकण्डा लेकै उसकै सिर पै मारण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","जिब उननै उसका मखौल कर लिया, तो वो चोग्गा उसपै तै तारकै फेर उस्से के लत्ते उस ताहीं पिहराए, अर क्रूस पै चढ़ाण कै खात्तर ले चाल्ले। ");
INSERT INTO bgc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","बाहरणै जान्दे होए, उन ताहीं शमौन नाम का एक कुरेनी माणस मिल्या। उननै उस ताहीं बेकार म्ह पकड्या के उसका क्रूस ठाकै ले चाल्लै। ");
INSERT INTO bgc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","उस जगहां पै पोहचे जो “खोपड़ी” यानी इब्रानी भाषा म्ह “गुलगुता” कुह्वावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","उननै सिरका मिल्या होड़ अंगूर का रस उस ताहीं पीण नै दिया, पर उसनै चाखकै पीणा न्ही चाह्या। ");
INSERT INTO bgc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","फेर उननै उस ताहीं क्रूस पै चढ़ाया, अर पर्ची गेर कै उसके लत्ते बांड लिये, ");
INSERT INTO bgc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","अर ओड़ै बैठकै उसका पैहरा देण लागगे। ");
INSERT INTO bgc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","अर उसका दोषपत्र लिखकै उसकै सिर पै लगाया, के, “यो यहूदियाँ का राजा यीशु सै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","फेर उसकै गेल्या दो डाकू एक सोळी ओड़ अर एक ओळी ओड़, क्रूस पै चढ़ाए गए। ");
INSERT INTO bgc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","राह म्ह आण-जाण आळे सिर हला-हलाकै उसकी बेजती करै थे, ");
INSERT INTO bgc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","अर वे कहवै थे, “हे मन्दर नै ढाण आळे अर तीन दिनां म्ह बणाण आळे, अपणे-आपनै तो बचा! जै तू परमेसवर का बेट्टा सै, तो क्रूस पै तै उतर आ।” ");
INSERT INTO bgc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","इस्से तरियां तै प्रधान याजक भी शास्त्रियाँ अर यहूदी अगुवां सुधा मजाक करकै कहवै थे, ");
INSERT INTO bgc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“इसनै औरां ताहीं बचाया, अर अपणे-आपनै न्ही बचा सकदा। यो तो ‘इस्राएल का राजा’ सै। इब क्रूस पै तै उतर आवै तो हम उसपै बिश्वास करां। ");
INSERT INTO bgc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","उसनै परमेसवर पै भरोस्सा राख्या सै; जै वो इसनै चाहवै सै, तो इब इसनै छुड़ा लेवै, क्यूँके इसनै कह्या था, ‘मै परमेसवर का बेट्टा सूं’।” ");
INSERT INTO bgc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","इस्से ढाळ डाक्कू भी जो उसकै गेल्या क्रूस पै चढ़ाए गए थे, उसकी बेजती करै थे। ");
INSERT INTO bgc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","दोफारी तै लेकै तीन बजे ताहीं उस सारे देश म्ह अँधेरा छाया रहया। ");
INSERT INTO bgc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तीसरे पहर कै लोवै यीशु नै जोर तै बोल्या, “एली, एली, लमा शबक्तनी?” यानिके “हे मेरे परमेसवर, हे मेरे परमेसवर, तन्नै मेरै ताहीं क्यांतै छोड़ दिया?” ");
INSERT INTO bgc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","जो उड़ै खड़े थे, कितन्याँ नै न्यू सुणकै कह्या, “वो तो एलिय्याह ताहीं बुलावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","उन म्ह तै एक जिब्बे भाज्या, अर स्पंज (फोम) लेकै सिरके म्ह ड्बोया, अर सरकण्डे पै धरकै उस ताहीं चुसाया। ");
INSERT INTO bgc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","औरां नै कह्या, “रहज्या, देक्खो एलिय्याह उसनै बचाण आवै सै के न्ही।” ");
INSERT INTO bgc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","फेर यीशु नै जोर तै किल्की मारकै जी दे दिया। ");
INSERT INTO bgc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","अर देक्खो, मन्दर का पड़दा उप्पर तै तळै ताहीं पाटकै दो टुकड़े होग्या अर धरती काम्बगी चट्टान तड़कगी, ");
INSERT INTO bgc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","अर कब्रे खुलगी, अर मरे होड़ भोत-से पवित्र माणस जो पैहले मुर्दे थे वे जिन्दा होग्ये, ");
INSERT INTO bgc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","अर उसकै जिन्दा होण कै पाच्छै वे कब्रां म्ह तै लिकड़कै पवित्र नगर म्ह गए अर घणाए ताहीं दिक्खे। ");
INSERT INTO bgc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","फेर सूबेदार अर जो उसकै गेल्या पैहरा दे रे थे, हाल्लण अर जो कुछ होया था उस ताहीं देखकै घणे डरगे अर कह्या, “साच्चए यो परमेसवर का बेट्टा था।” ");
INSERT INTO bgc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ओड़ै घणखरी बिरबान्नी जो गलील परदेस तै यीशु की सेवा कर दी होई उसकै गेल्या आई थी, दूर तै देक्खै थी। ");
INSERT INTO bgc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","उन म्ह मरियम मगदलीनी, अर याकूब अर योसेस की माँ मरियम, अर जब्दी के बेट्याँ की माँ थी। ");
INSERT INTO bgc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","जिब साँझ होई तो यूसुफ नामका अरिमतिया गाम का एक साहूकार माणस, जो खुदे यीशु का चेल्ला था। ");
INSERT INTO bgc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","उसनै पिलातुस धोरै जाकै यीशु की लाश माँगी। इस करकै पिलातुस नै यीशु की लाश देण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफ नै यीशु की लाश ली, उस ताहीं धोळी चाद्दर म्ह लपेट्या, ");
INSERT INTO bgc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","अर उस ताहीं अपणी नई कब्र म्ह धरया, जो उसनै चट्टान म्ह खुदवाई थी, अर कब्र के बारणै पै एक बड्ड़ा पत्थर गिरड़ा कै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मगदलीनी अर दुसरी मरियम ओड़ैए कब्र कै स्याम्ही बेठ्ठी थी। ");
INSERT INTO bgc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","आगला दिन आराम का दिन था, उस दिन प्रधान याजकां अर फरीसियाँ नै पिलातुस कै धोरै कठ्ठे होकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“हे महाराज, म्हारै ताहीं याद सै के उस धोक्खेबाज नै जिब वो जिन्दा था, तो उसनै न्यू कह्या था, ‘मै मरण के तीन दिन पाच्छै जिन्दा हो जाऊँगा।’ ");
INSERT INTO bgc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","इस करकै हुकम दे के तीसरे दिन ताहीं कब्र की रुखाळी सावधानी तै करी जावै, इसा ना हो के उसके चेल्लें आकै उसकी लाश नै चुरा ले जावै, अर माणसां तै कहण लाग्गै, ‘वो मरे होया म्ह तै जिन्दा होग्या सै।’ फेर पाच्छला धोक्खा पैहल्ड़े तै भी बड्ड़ा होगा।” (पैहला धोक्खा के वो खुद नै परमेसवर का बेट्टा बतावै सै, दुसरा यो के इब वो तीसरे दिन मरे होया मै तै जी उठ्ठुँगा) ");
INSERT INTO bgc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“पिलातुस नै उनतै कह्या, ‘थारे धोरै पहरेदार तो सै जाओ, अपणी समझकै मुताबिक कब्र की रुखाळी करो’। ");
INSERT INTO bgc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","आखर वे पैहरेदारां नै गैल लेकै ग्ये, अर कब्र के पत्थर पै मोंहर लगाकै कब्र की रुखाळी करी।” ");
INSERT INTO bgc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","आराम कै दुसरे दिन पाच्छै, हफ्तै कै पैहल्ड़े दिन, तड़कै ए तड़कै मगदला कस्बे की मरियम अर दुसरी मरियम कब्र नै देखण आई। ");
INSERT INTO bgc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","अर देक्खो, एक बड्ड़ा हाल्लण आया, क्यूँके प्रभु का सुर्गदूत सुर्ग तै उतरया अर धोरै आकै उसनै पत्थर ताहीं गिरड़या दिया, अर उसपै बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","उसका रूप बिजळी बरगा था अर उसके लत्ते पाळे की ढाळ धोळे थे। ");
INSERT INTO bgc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","उसकै डर तै पहरेदार काम्बगें, अर मुर्दे की ढाळ होग्ये। ");
INSERT INTO bgc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","सुर्गदूत नै बिरबानियाँ ताहीं कह्या, “मतना डरो, मन्नै बेरा सै के थम यीशु नै जो क्रूस पै चढ़ाया गया था, टोह्वो सो। ");
INSERT INTO bgc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","वो उरै न्ही सै, पर अपणे वचन कै मुताबिक जिन्दा होग्या सै। आओ, या जगहां देक्खो, जित्त प्रभु राख्या गया था, ");
INSERT INTO bgc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अर तावळे जाकै उसके चेल्यां ताहीं कहो के वो मरे होया म्ह तै जिन्दा होग्या सै, अर वो थारे तै पैहल्या गलील परदेस म्ह जावै सै, उड़ै उसका दर्शन पाओगे! देक्खो, मन्नै थारे तै कह दिया।” ");
INSERT INTO bgc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","वे भय अर घणी खुशी कै गेल्या कब्र तै तावळी बोहड़कै उसके चेल्यां ताहीं खबर देण नै भाज्जी गई। ");
INSERT INTO bgc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","फेर यीशु उन ताहीं मिल्या। अर कह्या, “सुखी रहो।” उननै धोरै आकै अर उसके पाँ पकड़कै उस ताहीं प्रणाम करया। ");
INSERT INTO bgc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","फेर यीशु नै उनतै कह्या, “मतना डरो; मेरे चेल्यां तै जाकै कहो के गलील परदेस म्ह चले जावै, उड़ै वो मन्नै देखैगें।” ");
INSERT INTO bgc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","जिब वे चेल्यां ताहीं या खबर देण जाण लागरी थी। तो पैहरेदारां म्ह तै, जो कब्र की रुखाळी करै थे, उन म्ह तै कईयाँ नै नगर म्ह आकै सारा हाल प्रधान याजकां तै कह सुणाया। ");
INSERT INTO bgc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","फेर उननै यहूदी अगुवां कै गेल्या कठ्ठे होकै सलाह करी अर सिपाहियाँ ताहीं घणाए धन देकै हुकम दिया, ");
INSERT INTO bgc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“के माणसां तै न्यू कहियो के जिब हम रात नै सोण लागरे थे, तो उसके चेल्लें आकै उसकी लाश नै चुरा लेगे। ");
INSERT INTO bgc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","जै थारे सोण की खबर राज्यपाल कै कान्नां ताहीं पोहोचैगी, तो हम उसनै समझा लेवैगें अर थमनै जोखिम तै बचा लेवांगें।” ");
INSERT INTO bgc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","आखर उननै रपिये लेकै जिसे सिखाए गये थे, उस्से तरियां ए करया। या बात आज ताहीं यहूदी माणसां म्ह मान्नी जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ग्यारहां चेल्लें गलील परदेस म्ह उस पहाड़ पै गये, जिस ताहीं यीशु नै उन ताहीं बताया था। ");
INSERT INTO bgc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","उननै उसका दर्शन पाकै उस ताहीं प्रणाम करया, पर कईयाँ नै शक होया के यीशु जिन्दा होग्या सै। ");
INSERT INTO bgc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","यीशु नै उनकै धोरै आकै कह्या, “सुर्ग अर धरती का सारा हक मेरै ताहीं दिया गया सै। ");
INSERT INTO bgc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","इस करकै थम जाओ, सारी जात्तां के माणसां ताहीं चेल्ला बणाओ; अर उननै पिता, पुत्र अर पवित्र आत्मा कै नाम तै बपतिस्मा द्यो, ");
INSERT INTO bgc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","अर उननै सारी बात जो मन्नै थारे ताहीं हुकम दिया सै, मानना सिखाओ: अर देक्खो मै दुनिया कै अंत तक सदा थारे गैल रहूँगा।”");
INSERT INTO bgc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","यो सुसमाचार यीशु मसीह के बारें म्ह सै। जो परमेसवर का बेट्टा सै। अर इसकी शरुआत इस तरियां होई ");
INSERT INTO bgc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जिसा के यशायाह नबी की किताब म्ह परमेसवर नै अपणे बेट्टे ताहीं कह्या सै: “देख, मै अपणे दूत नै तेरे आग्गै भेज्जू सूं, जो तेरे खात्तर लोग्गां नै तैयार करैगा। ");
INSERT INTO bgc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","जंगल-बियाबान म्ह एक रुक्का मारणीये का बोल सुणाई देवै सै के प्रभु के आण खात्तर अपणे-आपनै तैयार करो।” ");
INSERT INTO bgc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","वो दूत यूहन्ना था, जो जंगल-बियाबान म्ह कहवै था, “पाप करणा छोड़ द्यो अर बपतिस्मा ल्यो परमेसवर थारे पाप माफ कर देगा।” ");
INSERT INTO bgc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","सारे यहूदिया परदेस के, अर यरुशलेम नगर के सारे बासिन्दे लिकड़कै उसकै धोरै गए, अर अपणे पापां नै मानकै यरदन नदी म्ह उसतै बपतिस्मा लिया। ");
INSERT INTO bgc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्ना ऊँट के रुए के लत्ते पहरे, अर अपणी कड़ म्ह चमड़े की पेट्टी बाँधे रहवै था, अर टिड्डियाँ अर शहद खाया करै था। ");
INSERT INTO bgc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","अर न्यू प्रचार करै था, “मेरे पाच्छै वो आण आळा सै, जो मेरै तै शक्तिशाली सै, मै इस लायक कोनी के झुककै उसके जूत्याँ के फित्ते खोल्लूं। ");
INSERT INTO bgc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मन्नै तो थारे ताहीं पाणी तै बपतिस्मा दिया सै पर वो थमनै पवित्र आत्मा तै बपतिस्मा देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","उन दिनां म्ह यीशु नै गलील परदेस कै नासरत नगर तै होकै, यरदन नदी म्ह यूहन्ना तै बपतिस्मा लिया। ");
INSERT INTO bgc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","अर जिब वो पाणी म्ह तै लिकड़कै उप्पर आया, तो जिब्बे उसनै अकास ताहीं खुल्दे अर पवित्र आत्मा ताहीं कबूतर की तरियां अपणे उप्पर आन्दे देख्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","अर परमेसवर सुर्ग म्ह तै बोल्या, “तू मेरा प्यारा बेट्टा सै, तेरे तै मै राज्जी सूं।” ");
INSERT INTO bgc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","फेर पवित्र आत्मा नै जिब्बे उस ताहीं जंगल-बियाबान कान्ही भेज्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","जंगल-बियाबान म्ह चाळीस दिन ताहीं शैतान उस ताहीं परखता रहया, अर वो जंगल-बियाबान म्ह पशुआं कै गेल्या रह्या, अर सुर्गदूत उसकी सेवा करदे रहे। ");
INSERT INTO bgc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","यूहन्ना कै पकड़े जाणकै कुछ बखत पाच्छै, यीशु नै गलील परदेस म्ह आकै परमेसवर कै राज्य का सुसमाचार प्रचार करया, ");
INSERT INTO bgc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","अर कह्या, “बखत पूरा होया सै, अर परमेसवर का राज्य धोरै आरया सै; पाप करणा छोड़ द्यो, अर परमेसवर के सुसमाचार पै बिश्वास करो।” ");
INSERT INTO bgc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","गलील परदेस म्ह गलील समुन्दर कै किनारे जान्दे होड़, उसनै शमौन अर उसके भाई अन्द्रियास ताहीं समुन्दर म्ह जाळ गेर दे देख्या; क्यूँके वे मछवारे थे। ");
INSERT INTO bgc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","यीशु नै उनतै कह्या, “मेरै पाच्छै आओ, मै थमनै माणसां ताहीं कठ्ठे करण आळे बणाऊँगा ताके वो मेरे चेल्लें बणे।” ");
INSERT INTO bgc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","वे जिब्बे जाळां नै छोड़कै उसके चेल्लें बणण खात्तर उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","थोड़ा आग्गै चालकै, उसनै जब्दी के बेट्टे याकूब अर उसकै भाई यूहन्ना ताहीं, किस्ती पै जाळां ताहीं ठीक करदे देख्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","उसनै जिब्बे उन ताहीं बुलाया; अर वे अपणे पिता जब्दी ताहीं मजदूरां कै गेल्या किस्ती पै छोड़कै, उसके चेल्लें बणण खात्तर उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","जिब यीशु अर उसके चेल्लें कफरनहूम नगर म्ह आए, अर वो जिब्बे आराम कै दिन आराधनालय म्ह जाकै उपदेश देण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","अर माणस उसके उपदेश तै हैरान होगे; क्यूँके वो उननै शास्त्रियाँ की ढाळ न्ही, पर अधिकार तै उपदेश देवै था। ");
INSERT INTO bgc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","उस्से बखत, उनकै आराधनालय म्ह एक माणस था, जिसम्ह ओपरी आत्मा थी। ");
INSERT INTO bgc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","उसनै रुक्का मारकै कह्या, “हे नासरत के यीशु, हमनै तेरे तै के काम? के तू म्हारा नाश करण नै आया सै? मै तन्नै जांणु सूं, तू कौण सै? तू परमेसवर की ओड़ तै भेज्या होया पवित्र मसीह सै!” ");
INSERT INTO bgc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","यीशु नै उसतै धमकाकै कह्या, “चुपचाप रहै, अर इस माणस म्ह तै लिकड़ जा।” ");
INSERT INTO bgc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","फेर ओपरी आत्मा ऊँच्ची आवाज म्ह किल्की मारकै उस म्ह तै लिकड़गी। ");
INSERT INTO bgc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","इस बात पै सारे माणस अचम्भा करदे होए आप्पस म्ह बहस करण लाग्गे, “या के बात सै? यो तो कोए नया-ए उपदेश सै! वो हक कै गेल्या ओपरी आत्मायाँ नै भी हुकम देवै सै, अर वे उसका हुकम मान्नै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","अर उसका नाम जिब्बे गलील के पूरे परदेस म्ह हरेक जगहां फैलग्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","यीशु अर उसके सारे चेल्लें जिब्बे आराधनालय म्ह तै लिकड़कै, याकूब अर यूहन्ना कै गेल्या शमौन अर अन्द्रियास कै घरां आये। ");
INSERT INTO bgc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","शमौन की सास्सू कै बुखार चढ़रया था, अर उसके चेल्यां नै जिब्बे उसकै बाबत यीशु ताहीं बताया। ");
INSERT INTO bgc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","फेर यीशु नै धोरै जाकै उसका हाथ पकड़कै उस ताहीं ठाया, अर उसका बुखार उतर ग्या, अर वा उनकी सेवा-पाणी करण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","साँझ कै बखत जिब सूरज डूबग्या तो माणस सारे बिमारां ताहीं अर उननै, जीनम्ह ओपरी आत्मा थी, यीशु कै धोरै ल्याए। ");
INSERT INTO bgc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","अर साब्ता नगर दरबाजे पै कठ्ठा होया। ");
INSERT INTO bgc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","उसनै घणखरयां ताहीं जो कई ढाळ की बिमारियाँ तै दुखी थे, ठीक करया, घणखरी ओपरी आत्मायाँ ताहीं काढ्या, अर ओपरी आत्मायाँ ताहीं बोल्लण कोनी दिया, क्यूँके वे उसनै पिच्छाणै थी, के यीशु परमेसवर की ओड़ तै भेज्या होया मसीह सै। ");
INSERT INTO bgc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","तड़कैए दिन लिकड़ण तै पैहल्या, यीशु शमौन के घर तै उठकै लिकड़या, अर एक बियाबान जगहां म्ह गया अर उड़ै प्रार्थना करण लागग्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","फेर शमौन अर उसके साथी उसकी टोह् म्ह गए। ");
INSERT INTO bgc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","जिब वो मिल्या, तो उस ताहीं कह्या, “सारे नगर के माणस तन्नै टोहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","उसनै उनतै कह्या, “आओ; हम और किते लोवै-धोवै की बस्तियों म्ह जावां, के मै उड़ै भी प्रचार करुँ, क्यूँके मै इसे खात्तर आया सूं।” ");
INSERT INTO bgc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","अर वो सारे गलील परदेस म्ह उनके आराधनालयाँ म्ह जा-जाकै उन ताहीं उपदेश सुणान्दा अर ओपरी आत्मायाँ ताहीं लिकाड़दा रह्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","एक कोढ़ी उसकै धोरै आया, उसतै बिनती करी, अर उसकै आग्गै गोड्डे टेककै उस ताहीं कह्या, “जै तू चाहवै तो मन्नै ठीक कर सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","उसनै उसपै तरस खाकै हाथ बढ़ाकै, अर उस ताहीं छू कै कह्या, “मै चाहूँ सूं, के तू इस बीमारी तै ठीक हो ज्या।” ");
INSERT INTO bgc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","अर जिब्बे उसका कोढ़ जान्दा रह्या, अर वो ठीक होग्या। ");
INSERT INTO bgc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","फेर उसनै उस ताहीं चेतावनी देकै जिब्बे बिदा करया, ");
INSERT INTO bgc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","अर उसतै कह्या, “लखा, किसे तै कुछ मतना कहिये, पर जाकै अपणे-आपनै याजक ताहीं दिखा, अर अपणे कोढ़ तै ठीक होण कै बारै म्ह जो कुछ मूसा नबी नै जो पवित्र ग्रन्थ म्ह चढ़ावा बताया सै उसनै चढ़ा, के माणसां खात्तर या गवाही हो, के तू ठीक होग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पर वो बाहरणै जाकै इस बात का घणा प्रचार करण अर याड़ै ताहीं फैलाण लागग्या के यीशु दुबारै सरेआम नगर म्ह कोनी जा सक्या, पर बाहरणै सुनसान स्थानां म्ह रह्या, अर चौगरदे तै माणस उसकै धोरै आन्दे रहे। ");
INSERT INTO bgc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","थोड़े दिनां पाच्छै यीशु फेर कफरनहूम नगर म्ह आया, अर माणसां नै सुण्या के वो घर म्ह सै। ");
INSERT INTO bgc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","फेर इतने माणस कठ्ठे होए के दरबाजे धोरै भी जगहां कोनी थी, अर वो उननै परमेसवर के वचन सुणाण लागरया था। ");
INSERT INTO bgc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","अर चार माणस एक लकवे कै मरीज ताहीं बिस्तर पै लिटाकै उसकै धोरै ल्याए। ");
INSERT INTO bgc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","पर जिब वे भीड़ कै कारण उसकै धोरै कोनी पोहच सके, तो उननै उस छात ताहीं जिसकै तळै यीशु था, खोल दिया; तो उस बिस्तर समेत जिसपै वो लकवे का मरीज लेट्या था, नीच्चै उतार दिया। ");
INSERT INTO bgc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","यीशु नै उनका बिश्वास देखकै उस लकवे के मरीज ताहीं कह्या, “हे बेट्टे, मन्नै तेरे पाप माफ कर दिये।” ");
INSERT INTO bgc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","फेर घणे शास्त्री जो उड़ै बेठ्ठे थे, अपणे-अपणे मन म्ह सोच्चण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“यो माणस न्यू क्यांतै कहवै सै? यो तो परमेसवर की बुराई करै सै! परमेसवर नै छोड़कै और कौण पाप माफ कर सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","यीशु नै जिब्बे अपणे मन म्ह जाण लिया के वे अपणे-अपणे मन म्ह इसा विचार क्यांतै करण लागरे सै? अर उनतै कह्या, “थम अपणे-अपणे मन म्ह यो विचार क्यूँ करण लागरे सो? ");
INSERT INTO bgc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","आसान के सै? के लकवे कै मरीज ताहीं यो कहणा के तेरे पाप माफ होए, या फेर यो कहणा के उठ अपणा बिस्तर ठाकै हाँड-फिर? ");
INSERT INTO bgc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पर जिसतै थम जाण ल्यो के मुझ माणस कै बेट्टे नै धरती पै पाप माफ करण का भी हक सै।” उसनै उस लकवे कै मरीज ताहीं कह्या, ");
INSERT INTO bgc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मै तेरे तै कहूँ सूं, उठ, अपणे बिस्तर ठाकै अपणे घरां चल्या जा।” ");
INSERT INTO bgc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","वो उठ्या अर जिब्बे बिस्तर ठाकै उसकै स्याम्ही तै लिकड़ग्या; इसपै सारे हैरान होगे, अर परमेसवर की बड़ाई करकै कहण लाग्गे, “हमनै इसा पैहल्या कदे कोनी देख्या।” ");
INSERT INTO bgc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","यीशु दुबारा लिकड़कै गलील समुन्दर कै किनारे गया, अर सारी भीड़ उसकै धोरै आई, अर वो उननै उपदेश देण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","जान्दे होए उसनै हलफई के बेट्टे लेवी जिसका नाम मत्ती था, चुंगी की चौकी पै बेठ्ठे देख्या, अर उसतै कह्या, “मेरा चेल्ला बणण खात्तर मेरै पाच्छै हो ले।” अर वो उठकै उसकै पाच्छै हो लिया। ");
INSERT INTO bgc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","जिब वो मत्ती के घर म्ह खाणा खाण बेठ्या, तो घणेए चुंगी लेण आळे अर जिननै लोग पापी कहवै थे, यीशु अर उसकै चेल्यां गेल्या खाणा खाण बेठ्ठे; क्यूँके वे घणे सारे थे, अर उसकै साथ हो लिए थे। ");
INSERT INTO bgc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","शास्त्रियाँ अर फरीसियाँ नै न्यू देखकै के वो तो पापी अर चुंगी लेण आळा गेल्या खाणा खावै सै, उसके चेल्यां ताहीं कह्या, “वो तो चुंगी लेण आळे अर जिननै लोग पापी कहवै सै, उनकै गेल्या खावै-पीवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","यीशु नै या सुणकै उनतै कह्या, “आच्छे-बिच्छयां नै वैद की जरूरत कोनी, पर बिमारां नै सै: जो अपणे-आपनै धर्मी कहवै सै, मै उननै न्ही, पर जो अपणे-आपनै पापी कहवै सै उननै बुलाण आया सूं।” ");
INSERT INTO bgc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यूहन्ना के चेल्लें, अर फरीसी ब्रत करया करै थे, तो उननै आकै उसतै कह्या, “यूहन्ना के चेल्लें अर फरीसियाँ के चेल्लें ब्रत क्यांतै करै सै, पर तेरे चेल्लें ब्रत न्ही राखदे?” ");
INSERT INTO bgc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीशु नै उनतै कह्या, “जिब ताहीं बन्दड़ा बरातियाँ कै गेल्या सै, के वे ब्रत राख सकै सै? आखर जिब ताहीं बन्दड़ा उनकै गेल्या सै, जद ताहीं वे ब्रत कोनी कर सकदे। ");
INSERT INTO bgc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पर वे दिन भी आवैगें जिब बन्दड़ा उनतै न्यारा करया जावैगा; उस बखत वे ब्रत करैगें। ");
INSERT INTO bgc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“नये लत्यां की थेग्ळी पुराणे लत्यां पै कोए न्ही लगान्दा, न्ही तो वा थेग्ळी उस म्ह तै खुस्का लेवैगी, यानिके नया, पुराणे तै, अर वो पैहल्या तै घणा पाट जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नये अंगूर के रस ताहीं पुराणी मशकां म्ह कोए कोनी राखदा, न्ही तो अंगूर का रस मशकां नै पाड़ देवैगा, अर अंगूर का रस अर मशक दोनुआ का नाश हो जावैगा, पर नया अंगूर का रस नई मशकां म्ह भरया जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","न्यू होया के आराम कै दिन यीशु चेल्यां कै गैल खेत्तां म्ह तै होकै जाण लागरया था, अर उसके चेल्लें चाल्दे होए गेहूँ की बाल तोड़ण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तो फरीसियाँ नै उस ताहीं कह्या, “देख, ये आराम कै दिन वो काम क्यांतै करै सै? जो नियम-कायदा के खिलाफ सै।” ");
INSERT INTO bgc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","यीशु नै उनतै कह्या, “के थमनै पवित्र ग्रन्थ म्ह यो न्ही पढ़्या के जिब म्हारे पूर्वज दाऊद नै जरूरत होई, अर जिब वो अर उसके साथी भूक्खे होए, फेर उसनै के करया था? ");
INSERT INTO bgc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","उसनै किस ढाळ अबियातार महायाजक कै बखत, परमेसवर कै घर म्ह जाकै भेंट की रोट्टी खाई, जिनका खाणा याजकां नै छोड़ और किसे कै खात्तर खाणा ठीक कोनी, अर अपणे साथियाँ ताहीं भी दी?” ");
INSERT INTO bgc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","फेर उसनै उन ताहीं कह्या, “आराम का दिन माणस खात्तर बणाया गया सै, ना के माणस आराम कै दिन के खात्तर। ");
INSERT INTO bgc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","इस करकै मै माणस का बेट्टा आराम कै दिन का भी माल्लिक सूं।” ");
INSERT INTO bgc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","यीशु फेर आराम कै दिन आराधनालय म्ह गया; उड़ै एक माणस था जिसका हाथ सूखरया था, ");
INSERT INTO bgc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","अर फरीसी यीशु पै दोष लाण खात्तर उसकी टाह म्ह थे के देक्खै, वो आराम कै दिन उसनै ठीक करै सै के न्ही। ");
INSERT INTO bgc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","उसनै सूखे हाथ आळे माणस तै कह्या, “बीच म्ह खड्या होज्या” ");
INSERT INTO bgc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","अर उनतै कह्या, “के मूसा के नियम-कायदा कै मुताबिक आराम कै दिन भला करणा ठीक सै या बुरा करणा, जान बचाणा या मारणा?” पर वे बोल-बाल्ले रहे। ");
INSERT INTO bgc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","फेर उसनै उनकै मन की कठोरता तै काल होकै, उन ताहीं छो तै चोगरदेनै देख्या, अर उस माणस ताहीं कह्या, “अपणा हाथ बढ़ा।” उसनै बढ़ाया, अर उसका हाथ ठीक हो गया। ");
INSERT INTO bgc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","फेर फरीसी बाहरणै जाकै जिब्बे हेरोदेस राजा के समर्थकां कै गेल्या उसकै बिरोध म्ह सलाह करण लाग्गे के उसका नाश किस तरियां करया जावै। ");
INSERT INTO bgc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","यीशु अपणे चेल्यां गेल्या गलील समुन्दर कान्ही चल्या गया: अर गलील तै एक बड्डी भीड़ उसकै पाच्छै हो ली; ");
INSERT INTO bgc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","अर यहूदिया नगर, अर यरुशलेम नगर, अर इदूमिया परदेस, अर यरदन नदी के परली ओड़, अर सूर अर सैदा नगर के लोवै-धोवै तै एक बड्डी भीड़ न्यू सुणकै के वो किसे अचम्भे आळे काम करै सै, उसनै देक्खण आई। ");
INSERT INTO bgc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","यीशु नै अपणे चेल्यां तै कह्या, “भीड़ की बजह तै एक छोट्टी किस्ती मेरै खात्तर त्यार राखियों ताके वे मन्नै दाब न्ही सकै।” ");
INSERT INTO bgc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","क्यूँके उसनै घणखरयां ताहीं ठीक करया था, इस करकै जितने माणस बीमार थे, उस ताहीं छूण खात्तर उसपै पड़ण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","जिन म्ह ओपरी आत्मा भी जिब उस ताहीं देक्खै थी, तो उसकै स्याम्ही गिर ज्या थी, अर किल्की मारकै कहवै थी, तू परमेसवर का बेट्टा सै। ");
INSERT INTO bgc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","अर उसनै ओपरी आत्मायाँ ताहीं चेतावनी देकै कह्या के मेरै बारै म्ह किसे तै ना कहियो के मै कौण सूं। ");
INSERT INTO bgc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","फेर यीशु पहाड़ पै चढ़ग्या, अर जिन नै वो चाहवै था उन ताहीं अपणे धोरै बुलाया; अर वे उसकै धोरै आए। ");
INSERT INTO bgc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","फेर उसनै उन म्ह तै बारहा चेल्यां ताहीं नियुक्त करया के वे उसकै गेल्या-गेल्या रहवै, अर वो उननै भेज्जै के वे प्रचार करै, ");
INSERT INTO bgc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","अर ओपरी आत्मा ताहीं काढ़ण का हक राक्खै। ");
INSERT INTO bgc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","वे बारहा चेल्लें ये सै: “शमौन जिसका नाम उसनै पतरस धरया, ");
INSERT INTO bgc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","अर जब्दी का बेट्टा याकूब अर याकूब का भाई यूहन्ना, जिसका नाम उसनै बुअनरगिस यानिके ‘गरजण का बेट्टा’ धरया।” ");
INSERT INTO bgc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अर अन्द्रियास, अर फिलिप्पुस, अर बरतुल्मै, अर मत्ती, अर थोमा, अर हलफई का बेट्टा याकूब, अर तद्दै, अर शमौन कनानी, ");
INSERT INTO bgc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","अर यहूदा इस्करियोती जिसनै उस ताहीं पकड़वा भी दिया था। ");
INSERT INTO bgc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","फेर यीशु घरां आया; अर इसी भीड़ कठ्ठी होई, के यीशु अर उसके चेल्यां पै रोट्टी भी कोनी खाई गई। ");
INSERT INTO bgc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जिब उसके कुण्बा आळा न्यू सुण्या, तो वे उस ताहीं घरां ले जाण खात्तर लिकड़े; क्यूँके वे कहवै थे, “के उसका दिमाग ठिकाणै कोनी सै” ");
INSERT INTO bgc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","शास्त्री भी जो यरुशलेम नगर तै आये थे, वे कहवै थे, “उस म्ह शैतान सै,” अर न्यू भी के “वो ओपरी आत्मायाँ के सरदार शैतान की मदद तै ओपरी आत्मायाँ नै लिकाड़ै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ज्यातै यीशु उननै धोरै बुलाकै उदाहरणां म्ह कहण लाग्या, “शैतान क्यूँकर ओपरी आत्मायाँ नै काढ सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","जै किसे राज्य म्ह फूट पड़ै, तो वो राज्य किस तरियां टिक्या रह सकै सै? ");
INSERT INTO bgc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अर जै किसे घर म्ह फूट पड़ै, तो वो घर क्यूँकर डटया रह सकैगा? ");
INSERT INTO bgc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","इस करकै जै शैतान खुद का ए बिरोधी होकै अपणे म्ह फूट गेरै, तो वो किस तरियां बण्या रहै सकै सै? उसका तो नाश हो जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“पर कोए माणस किसे ठाड्डे माणस कै घर म्ह बड़कै उसका माळ कोनी लूट सकदा, जिब तक के पैहल्या उस ठाड्डे माणस ताहीं ना जुड़ ले; जिब वो उसके घर नै लूट लेवैगा। ");
INSERT INTO bgc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","मै थमनै साच्ची-साच कहूँ सूं के माणसां के सारे पाप अर बुराई जो वे करै सै, माफ करे जावैंगे, ");
INSERT INTO bgc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पर जो कोए पवित्र आत्मा कै बिरोध म्ह बुराई करै सै, वो कदे माफ कोनी करया जावैगा: बल्के वो अनन्त पाप का कसूरवार बण ज्यागा।” ");
INSERT INTO bgc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","क्यूँके वे न्यू कहवै थे के उस म्ह ओपरी आत्मा सै। ");
INSERT INTO bgc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","फेर यीशु की माँ अर उसके भाई आए, अर बाहरणै खड़े होकै उस ताहीं बुलावा भेज्या। ");
INSERT INTO bgc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","भीड़ उसकै लोवै-धोवै बेठ्ठी थी, अर उननै उसतै कह्या, “देख, तेरी माँ अर तेरे भाई बाहरणै तन्नै टोहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","यीशु नै उनतै जवाब दिया, “मेरी माँ अर मेरे भाई कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","अर जो उसकै लोवै-धोवै बेठ्ठे थे, उनपै निगांह करकै कह्या, “देक्खों, मेरी माँ अर मेरे भाई ये सै। ");
INSERT INTO bgc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","क्यूँके जो कोए परमेसवर की इच्छा पै चाल्लै, वोए मेरा भाई, मेरी बेब्बे, अर मेरी माँ सै।” ");
INSERT INTO bgc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","यीशु फेर गलील समुन्दर कै किनारे उपदेश देण लागग्या: अर इसी बड्डी भीड़ उसकै धोरै कठ्ठी होगी के वो समुन्दर म्ह एक किस्ती पै चढ़कै बैठग्या, अर सारी भीड़ जमीन पै समुन्दर कै किनारे खड़ी रही। ");
INSERT INTO bgc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","अर वो उननै उदाहरणां म्ह घणीए बात सिखाण लाग्या, अर अपणे उपदेश म्ह उन ताहीं कह्या, ");
INSERT INTO bgc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“सुणो! एक किसान बीज बोण लिकड़या। ");
INSERT INTO bgc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","बोंदे बखत कुछ राही कै किनारे पड़े, अर पंछियाँ नै आकै उन ताहीं चुग लिया। ");
INSERT INTO bgc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","कुछ पथरीली धरती पै पड़े जड़ै उसनै घणी माट्टी ना मिली, अर ढुंघी माट्टी ना मिलण कै कारण तोळाए उग्या, ");
INSERT INTO bgc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","अर जिब सूरज लिकड़या तो जळगे, अर जड़ ना पकड़ण कै कारण सुखगे। ");
INSERT INTO bgc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","कुछ झाड़ियाँ म्ह पड़े, अर झाड़ियाँ नै आग्गै बढ़कै उन ताहीं दाब दिया, अर वो फळ कोनी ल्याये। ");
INSERT INTO bgc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पर कुछ आच्छी धरती पै पड़े, अर वो उग्या अर बढ़कै फळ ल्याये; अर कोए तीस गुणा, कोए साठ गुणा अर कोए सौ गुणा फळ ल्याया।” ");
INSERT INTO bgc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","फेर उसनै कह्या, “जिसके कान हों, वो ध्यान तै सुण ले।” ");
INSERT INTO bgc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जिब यीशु एक्ला रहग्या, तो उसके साथियाँ नै उन बारहां चेल्यां सुधा उसतै इन उदाहरणां कै बारै म्ह बुझ्झया। ");
INSERT INTO bgc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","उसनै उनतै कह्या, “थारे ताहीं तो परमेसवर कै राज्य के भेद की समझ दे राक्खी सै, पर बाहर आळा खात्तर सारी बात उदाहरणां म्ह होवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","इस करकै के “वे देखदे होए देक्खै पर उननै दिखाई ना देवै अर सुणदे होए सुणै भी पर ना समझै; इसा ना हो के वे पाप करणा छोड़दे, अर वे माफ करे जावै।” ");
INSERT INTO bgc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","फेर यीशु नै उनतै कह्या, “के थम यो उदाहरण कोनी समझे? तो फेर और सारे उदाहरणां नै किस तरियां समझोगे? ");
INSERT INTO bgc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","किसान जो बीज बोण आळा सै वो वचन बोण आळे कै समान सै। ");
INSERT INTO bgc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","राही कै किनारे गिरे बीज उन माणसां की तरियां सै जो वचन सुणै सै, तो शैतान जिब्बे आकै वचन नै जो उन म्ह बोया गया था, ठा ले जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","उस्से तरियां-ए जो पथरीली धरती पै बीज गिरे सै, ये वे सै जो वचन सुणकै जिब्बे खुश होकै अपणा लेवैं सै। ");
INSERT INTO bgc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पर उनकै भीत्त्तर जड़ न्ही पकड़ण कै कारण थोड़े-से दिनां कै खात्तर रहै सै; इसकै बाद जिब वचन कै कारण उनपै क्ळेश या संकट आवै सै, तो वे जिब्बे ठोक्कर खा जावै सै। ");
INSERT INTO bgc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","जो झाड़ियाँ म्ह बीज गिरे ये वे सै जिन नै वचन सुण्या, ");
INSERT INTO bgc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","अर दुनिया की फिक्र, अर धन का धोक्खा, अर दुसरी चिज्जां का लालच म्ह पड़कै वचन नै दाब देवै सै अर वो फळदा कोनी। ");
INSERT INTO bgc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","अर जो आच्छी धरती पै बीज गिरे, ये वे सै जो वचन सुणकै अपणा लेवैं सै अर फळ ल्यावै सै, कोए तीस गुणा, कोए साठ गुणा अर कोए सौ गुणा।” ");
INSERT INTO bgc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","यीशु नै उनतै एक और उदाहरण दिया, “के दीवै नै इस खात्तर कोनी जळान्दे, के उसनै बरतन या खाट कै तळै धर देवां? पर इस खात्तर के टांडी पै धरया जावै? ");
INSERT INTO bgc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","इसा कुछ भी न्ही जो लुक्या हो, अर खोल्या न्ही जावैगा अर ना कुछ गुप्त सै, जिसके बारें म्ह बेरा ना लाग्गै। ");
INSERT INTO bgc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","जै किसे के कान हों, तो ध्यान तै सुण ले।” ");
INSERT INTO bgc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","फेर उसनै उनतै कह्या, “चौक्कस रहियो की के सुणो सो। जिस नाप तै थम नाप्पो सों उस्से नाप तै थारे खात्तर भी नाप्या जावैगा। अर थारे ताहीं घणा दिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","क्यूँके जिसकै धोरै सै, उस ताहीं दिया जावैगा, अर जिसकै धोरै न्ही सै, उसतै वो भी जो उसकै धोरै सै, ले लिया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","फेर यीशु नै उन ताहीं एक और उदाहरण दिया, “परमेसवर का राज्य इसा सै, जिसा कोए माणस धरती पै बीज छिडकै सै, ");
INSERT INTO bgc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","अर रात नै सोग्या अर सबेरै जाग ग्या, अर वो बीज इसा उगै अर बधै सै के उसनै बेराए कोनी लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","धरती खुद-बै-खुद फळ लावै सै, पैहल्या अंकुर, फेर बाल, अर फेर बाल म्ह त्यार दाणा। ");
INSERT INTO bgc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पर जिब दाणा पक जावै सै, फेर वो जिब्बे दांती लावै सै, क्यूँके लामणी का बखत आण पोहचा सै।” ");
INSERT INTO bgc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","फेर यीशु नै उन ताहीं एक और उदाहरण दिया, “हम परमेसवर के राज्य की बराबरी किसतै करां अर किस उदाहरण तै उसका खुलास्सा करां? ");
INSERT INTO bgc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","वो राई कै दाणै की ढाळ सै: जिब धरती म्ह बोया जावै सै तो धरती कै सारे बीज्जां तै छोट्टा होवै सै, ");
INSERT INTO bgc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","पर जिब बोया गया, तो जामकै सारे सागपात तै बड्ड़ा हो जावै सै, अर उसकी इतनी बड्डी डाळी लिकड़ै सै के अकास के पंछी उसकी छाया तळै बसेरा कर सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","यीशु उन ताहीं इस तरियां कै घणे उदाहरण दे-देकै उनकी समझकै मुताबिक वचन सुणावै था, ");
INSERT INTO bgc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","अर इस तरियां की शिक्षा देण खात्तर वो उदाहरणां का ए इस्तमाल करया करदा; पर एक्ले म्ह वो अपणे चेल्यां ताहीं सारी बात्तां का मतलब बतावै था। ");
INSERT INTO bgc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","उस्से दिन जिब साँझ होई, तो यीशु नै चेल्यां तै कह्या, “आओ, हम समुन्दर के परली ओड़ चाल्लां।” ");
INSERT INTO bgc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","अर वे भीड़ नै छोड़कै जिसा वो था, उसाए उस ताहीं किस्ती पै गेल्या ले चाल्ले; अर उसकै गेल्या और भी किस्ती थी। ");
INSERT INTO bgc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","फेर बड़ीए आँधी आई, अर पाणी की झाल किस्ती कै उरै ताहीं लाग्गी के वा पाणी तै भरण नै होगी। ");
INSERT INTO bgc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","पर यीशु पाच्छले हिस्से म्ह गद्दी लगाई सोण लाग रह्या था। फेर उननै उस ताहीं जगाकै उसतै कह्या, “हे गुरु, के तन्नै चिन्ता कोनी के हम डूबके मरण आळे सां?” ");
INSERT INTO bgc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","फेर उसनै उठकै आँधी ताहीं धमकाया, अर पाणी की झाल तै कह्या, “शांत रहै, थम ज्या।” अर आँधी थमगी अर पूरी तरियां शान्ति छागी। ");
INSERT INTO bgc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","उसनै उनतै कह्या, “थम क्यूँ डरो सों? के थमनै इब ताहीं बिश्वास कोनी?” ");
INSERT INTO bgc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","वे घणे डरगे, अर आप्पस म्ह बोल्ले, “यो कौण सै के आँधी अर पाणी की झाल भी उसका हुकम मान्नैं सै?” ");
INSERT INTO bgc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","यीशु अर उसके चेल्लें गलील समुन्दर कै परली ओड़ गिरासेनियों कै परदेस म्ह पोहचे, ");
INSERT INTO bgc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","जिब यीशु किस्ती पै तै उतरया तो जिब्बे एक माणस जिसम्ह ओपरी आत्मा थी, कब्रिस्तान म्ह तै लिकड़कै उसतै मिल्या। ");
INSERT INTO bgc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","वो कब्रिस्तान म्ह रह्या करै था अर कोए उस ताहीं बेल्लां तै भी कोनी जुड़ सकै था, ");
INSERT INTO bgc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","क्यूँके वो घणीए बर बेड़ियाँ अर बेल्लां तै जुड्यां गया था, पर उसनै बेल्लां ताहीं तोड़ दिया था अर बेड़ियाँ के टुकड़े-टुकड़े कर दिये थे, अर कोए उस ताहीं बस म्ह कोनी कर सकै था। ");
INSERT INTO bgc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","वो सारीहाण रात-दिन कब्रिस्तानां अर पहाड़ां म्ह किल्की मारदा अर खुद नै पत्थरां तै जख्मी करै था। ");
INSERT INTO bgc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","वो यीशु नै दूर तै ए देखकै भाजकै आया, उसके पायां म्ह पड़कै घुटने टेक दिए, ");
INSERT INTO bgc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","अर जोर तै किल्की मारकै कह्या, “हे यीशु, परमप्रधान परमेसवर के बेट्टे, मन्नै तेरे तै के काम? मै तन्नै परमेसवर की कसम दियुँ सूं के मन्नै काल ना करै।” ");
INSERT INTO bgc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","क्यूँके उसनै उसतै कह्या था, “हे ओपरी आत्मा, इस माणस म्ह तै लिकड़ आ!” ");
INSERT INTO bgc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","यीशु नै उसतै बुझ्झया, “तेरा के नाम सै?” उसनै उस ताहीं कह्या, “मेरा नाम सेना सै, क्यूँके हम घणे सां।” ");
INSERT INTO bgc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","अर उसनै यीशु तै घणी बिनती करी, “के हमनै इस परदेस तै बाहरणै ना खन्दावै।” ");
INSERT INTO bgc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","उड़ै पहाड़ पै सूअरां का एक बड्ड़ा टोळ चरै था। ");
INSERT INTO bgc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ओपरी आत्मायाँ नै यीशु तै बिनती करकै कह्या, “हमनै उन सूअरां म्ह भेजदे के हम उनकै भीत्त्तर समा जावां।” ");
INSERT INTO bgc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","यीशु नै उन ताहीं हुकम दिया अर ओपरी आत्मा लिकड़कै सूअरां कै भीत्त्तर समागी अर टोळ, जो कोए दो हजार का था, ढळान पै तै झपटकै गलील समुन्दर म्ह पड़कै डूब मरया। ");
INSERT INTO bgc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","उनके पाळीयाँ नै जो डरे होए थे, भाजकै कस्बे अर गाम्मां म्ह खबर सुणाई, अर जो होया था, माणस उस ताहीं देक्खण आए। ");
INSERT INTO bgc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","अर यीशु कै धोरै आकै वे उस ताहीं जिसम्ह ओपरी आत्मा थी, यानिके जिस म्ह सेना बड़री थी, लत्ते पहरे अर सोध्दी म्ह बेठ्ठे देख्या। ");
INSERT INTO bgc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","अर देखण आळा नै उसका, जिसम्ह ओपरी आत्मा थी, अर सूअरां का पूरा किस्सा उन ताहीं कह सुणाया। ");
INSERT INTO bgc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","फेर वे उसतै बिनती करकै कहण लाग्गे के म्हारी सीमा तै लिकड़ज्या। ");
INSERT INTO bgc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","जिब यीशु किस्ती पै चढ़ण लागग्या, तो वो जिस म्ह पैहल्या ओपरी आत्मा थी, उसतै बिनती करण लाग्या, के “मन्नै अपणे गेल्या रहण दे।” ");
INSERT INTO bgc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पर यीशु नै उस ताहीं मंजूरी कोनी देई, अर उसतै बोल्या, “अपणे घरां जाकै अपणे माणसां नै बता, के तेरे पै दया करकै प्रभु नै तेरे खात्तर किसे बड़े-बड़े काम करे सै।” ");
INSERT INTO bgc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","वो जाकै दिकापुलिस नगर म्ह इस बात का प्रचार करण लाग्या, के यीशु नै मेरै खात्तर किस ढाळ के बड़े काम करे; अर जिसनै भी यो सुण्या वे सारे अचम्भा करण लाग्गै। ");
INSERT INTO bgc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जिब यीशु किस्ती तै दुसरे किनारे पै गया, तो एक बड्डी भीड़ उसकै धोरै कठ्ठी होगी; वो गलील समुन्दर का किनारा था। ");
INSERT INTO bgc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","आराधनालयाँ कै सरदारां म्ह तै एक याईर नाम का आदमी आया, अर उसनै देखकै उसकै पायां के म्ह पड़ग्या, ");
INSERT INTO bgc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","अर न्यू कहकै उस ताहीं बिनती करी, “मेरी छोट्टी छोरी मरण नै होरी सै: तू आकै उसपै हाथ धरदे, तो वा ठीक होकै जिन्दा हो जावै।” ");
INSERT INTO bgc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","फेर वो उसकै गेल्या चाल्या; अर बड्डी भीड़ उसकै पाच्छै हो ली, याड़ै ताहीं के माणस उसपै पड़ण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","एक बिरबान्नी थी, जिसकै बारहा साल तै लहू बहण की बीमारी थी। ");
INSERT INTO bgc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","उसनै घणे डाक्टरां तै ईलाज करवा कै भी बड़ा दुख ठाया, अर उसनै अपणा सारा रपियाँ खर्च कै भी कोए फायदा कोनी होया, पर उसकी बीमारी और भी घणी बढ़गी थी। ");
INSERT INTO bgc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","वा बिरबान्नी यो सुणकै, यीशु माणसां नै ठीक करै सै भीड़ म्ह उसकै पाच्छै तै आई अर उसकै लत्ते ताहीं छू लिया, ");
INSERT INTO bgc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","अर वा या भी कहवै थी, “जै मै उसकै लत्ते नै छू ल्यूँगी, तो ठीक हो जाऊँगी।” ");
INSERT INTO bgc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","अर जिब्बे उसका लहू बहणा बन्द हो गया, अर उसनै अपणे देह म्ह बेरा लागग्या के मै उस बीमारी तै चंगी होगी सूं। ");
INSERT INTO bgc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीशु नै जिब्बे खुद तै बेरा पाटग्या के मेरै म्ह तै सामर्थ लिकड़ी सै, अर भीड़ कै पाच्छै फिरकै बुझ्झया, “मेरे लत्ते किसनै छुए?” ");
INSERT INTO bgc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","उसके चेल्यां नै उसतै कह्या, “तू देक्खै सै के भीड़ तेरपै गिरण-पड़ण लागरी सै, अर तू पूच्छै सै के किसनै मेरै ताहीं छुया?” ");
INSERT INTO bgc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","फेर उसनै उस ताहीं देखण खात्तर जिसनै यो काम करया था, चोगरदेनै निगांह घुमाई। ");
INSERT INTO bgc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","फेर वा बिरबान्नी न्यू जाणकै के मेरी किसी भलाई होई सै, डरगी अर काम्बदी होई आई, अर उसकै पायां म्ह पड़कै उस ताहीं सारा हाल सच-सच कह दिया। ");
INSERT INTO bgc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","यीशु नै उसतै कह्या, “बेट्टी, तेरे बिश्वास नै तेरे ताहीं ठीक करया सै, खुशी-खुशी जा, अर अपणी इस बीमारी तै ठीक रह।” ");
INSERT INTO bgc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","यीशु न्यू कहवै था के आराधनालय कै सरदार याईर कै घर तै माणसां नै आकै कह्या, “तेरी छोरी तो मर ली सै, इब गुरु नै क्यांतै कांल करै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","जो बात वे कहरे थे, उस ताहीं यीशु नै बेगौरी करकै, आराधनालय कै सरदार तै कह्या, “मतना डरै, सिर्फ बिश्वास राख।” ");
INSERT INTO bgc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","अर उसनै पतरस अर याकूब अर उसकै भाई यूहन्ना नै छोड़, किसे दुसरे ताहीं अपणे गेल्या आण ना दिया। ");
INSERT INTO bgc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","आराधनालय कै सरदार कै घर म्ह पोहचकै, उसनै माणसां ताहीं घणे रोन्दे अर किल्की मारदे देख्या। ");
INSERT INTO bgc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","फेर उसनै भीत्त्तर जाकै उनतै कह्या, “थम क्यांतै रोळा मचाओ अर रोओ सो, छोरी मरी कोनी, पर सोवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","वे उसका मजाक उड़ाण लाग्गे, पर उसनै सारया ताहीं बाहर लिकाड़कै छोरी कै माँ-बाप अर अपणे चेल्यां कै गेल्या भीत्त्तर गया, जित्त छोरी पड़ी थी। ");
INSERT INTO bgc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","अर छोरी का हाथ पकड़कै उसतै कह्या, “तलिता कूमी!” जिसका मतलब सै, “हे छोरी, मै तेरे तै कहूँ सूं, उठ!” ");
INSERT INTO bgc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","अर वा छोरी जो बारहा साल की थी, जिब्बे उठकै चाल्लण-फिरण लाग्गी; अर इसपै माणस घणे हैरान होगे। ");
INSERT INTO bgc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","फेर उसनै उन ताहीं चेतावनी देकै हुकम दिया के इस बात का किसे नै भी बेरा ना पाट्टण दियो अर कह्या, “इसनै कुछ खाण नै द्यो।” ");
INSERT INTO bgc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","कफरनहूम नगर तै लिकड़कै यीशु अपणे नासरत नगर म्ह आया, अर उसके चेल्लें भी उसकै पाच्छै गए। ");
INSERT INTO bgc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","आराम कै दिन वो आराधनालय म्ह उपदेश देण लागग्या, अर घणखरे माणसां नै सुणकै अचम्भा करया अर कहण लाग्गे, “इसनै इतनी बात कड़ै तै आगी?” यो कौण सा ज्ञान सै जो उस ताहीं दिया होया सै? किस ढाळ के सामर्थ के काम उसकै हाथ्थां तै दिक्खै सै? ");
INSERT INTO bgc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","के यो वोए खात्त्ती कोनी, जो मरियम का छोरा, अर याकूब, योसेस, यहूदा, अर शमौन का भाई सै? के उसकी सारी बेब्बे याड़ै म्हारै बिचाळै कोनी रह्न्दी? इस करकै उननै उसका बिश्वास कोनी करा। ");
INSERT INTO bgc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीशु नै उनतै कह्या, “नबी का अपणे गाम, अपणे कुण्बे, अर अपणे घर नै छोड़कै और किते भी निरादर कोनी होन्दा।” ");
INSERT INTO bgc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","वो उड़ै कोए चमत्कार के काम न्ही कर सक्या, सिर्फ थोड़े-से बिमारां पै हाथ धरकै उन ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","अर यीशु नै उनकै अबिश्वास पै हैरानी होई अर चौगरदे के गाम्मां म्ह उपदेश सुणान्दा हांडया। ");
INSERT INTO bgc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","यीशु नै बारहां चेल्यां ताहीं अपणे धोरै बुलाया अर उननै ओपरी आत्मायाँ पै हक दिया अर उननै दो-दो करकै भेजण लागग्या;। ");
INSERT INTO bgc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","उसनै चेल्यां ताहीं हुकम दिया, “रास्ते खात्तर लाठ्ठी नै छोड़ और कुछ ना लियो, ना तो रोट्टी, ना झोळी, ना बटुए म्ह पईसे, ");
INSERT INTO bgc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","जूत्ते तो पैहरियो पर पैहरण खात्तर दो कुड़ते ना लियो।” ");
INSERT INTO bgc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","अर यीशु नै चेल्यां ताहीं कह्या, “जित्त किते थम जिस घर म्ह जाओ, तो जिब ताहीं उड़ै तै बिदा ना होइयो तब तक उस्से घर म्ह ठहरे रहो। ");
INSERT INTO bgc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जिस जगहां के माणस थमनै न्ही अपणावै अर थारी न्ही सुणै, उड़ै तै चाल्दे-ए अपणे ताल्वां की धूळ झाड़ दियो के या उनकै बिरुध्द गवाही होवै।” ");
INSERT INTO bgc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","फेर चेल्यां नै जाकै प्रचार करया के पाप करणा छोड़ द्यो, ");
INSERT INTO bgc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","अर घणीए ओपरी आत्मा ताहीं काढ्या, अर घणे बिमारां पै तेल मळ कै उन ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","राजा हेरोदेस नै भी यीशु का जिक्र सुण्या, क्यूँके उसका नाम फैलग्या था, अर उसनै कह्या, के “यूहन्ना बपतिस्मा देण आळा मरया होया म्ह तै जिन्दा होया सै, इस्से करकै उसतै ये सामर्थ के काम होवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","दुसरे माणसां नै कह्या, “यो एलिय्याह सै।” पर कुछ दुसरयां नै कह्या, “वो एक नबी सै पुराणे नबियाँ म्ह तै किसे कै बरगा।” ");
INSERT INTO bgc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","हेरोदेस नै न्यू सुणकै कह्या, “जिस यूहन्ना का सिर मन्नै कटवाया था, वोए जिन्दा होया सै।” ");
INSERT INTO bgc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","हेरोदेस नै अपणे भाई फिलिप्पुस की घरआळी हेरोदियास कै कारण, जिसतै उसनै ब्याह कर लिया था, माणसां ताहीं भेजकै यूहन्ना ताहीं पकड़वाकै जेळ म्ह गेर दिया था। ");
INSERT INTO bgc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","क्यूँके यूहन्ना नै हेरोदेस तै कह्या था, “अपणे भाई की घरआळी ताहीं राखणा मूसा के नियम-कायदा कै मुताबिक तेरे खात्तर ठीक कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","इस करकै हेरोदियास यूहन्ना तै बैर राख्या करै थी अर वा चाहवै थी के उसनै मरवा देवै, पर इसा हो न्ही सक्या, ");
INSERT INTO bgc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","क्यूँके हेरोदेस यूहन्ना नै धर्मी अर पवित्र माणस जाणकै उसतै डरै था, अर उसका बचाव करै था, अर उसकी बात सुणकै घणा घबरावै था, फेर भी उसकी बात्तां नै आनन्द तै सुणै था। ");
INSERT INTO bgc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","आखिरकार एक इसा मौक्का आया, जिब हेरोदेस नै अपणे जन्म दिन पै अपणे प्रधानां, सेनापतियाँ, अर गलील कै बड़े माणसां कै खात्तर जीमणा करया। ");
INSERT INTO bgc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","तो हेरोदियास की बेट्टी भीत्त्तर आई, अर नाचकै हेरोदेस ताहीं अर उसकै गेल्या बैठण आळा ताहीं राज्जी करया। फेर राजा नै छोरी तै कह्या, “तू जो चाहवै मेरै तै माँग ले, मै तन्नै वोए दियुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","हेरोदेस नै कसम खाई, “मै अपणा आध्धा राज्य तक जो कुछ तू मेरै तै माँगैगी मै तन्नै दियुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","उसनै बाहरणै जाकै अपणी माँ तै बुझया, “मै के माँग्गू?” वा बोल्ली, “यूहन्ना बपतिस्मा देण आळे का सिर।” ");
INSERT INTO bgc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","वा जिब्बे राजा धोरै भीत्त्तर आई अर उसतै बिनती करी, “मै चाहूँ सूं के तू इब्बे यूहन्ना बपतिस्मा देण आळे का सिर एक थाळ म्ह मन्नै मँगवा दे।” ");
INSERT INTO bgc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","फेर राजा घणा दुखी होया, पर अपणी कसम कै कारण अर गेल्या बैठण आळा कै कारण उस ताहीं टाळणा कोनी चाह्या। ");
INSERT INTO bgc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","आखर म्ह राजा नै जिब्बे एक सिपाही ताहीं हुकम देकै भेज्या के उसका सिर काट ल्यावै। ");
INSERT INTO bgc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","उसनै जेळखान्ने म्ह जाकै उसका सिर काट्या, अर एक थाळ म्ह धरकै ल्याया अर छोरी ताहीं दिया, अर छोरी नै अपणी माँ तै दिया। ");
INSERT INTO bgc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","न्यू सुणकै यूहन्ना के चेल्लें आए, अर उसकी लाश नै लेगे अर कब्र म्ह धर दी। ");
INSERT INTO bgc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","चेल्लें बोहड़कै यीशु कै धोरै आये, जो कुछ उननै करया अर सिखाया था, सब कुछ उस ताहीं बता दिया। ");
INSERT INTO bgc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","यीशु नै चेल्यां तै कह्या, “आओ हम किसे एकान्त जगहां म्ह चालकै माड़ा आराम करां।” क्यूँके घणे माणस आवै-जावै थे, अर उननै खाण का मौक्का भी कोनी मिलै था। ");
INSERT INTO bgc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ज्यांतै वे किस्ती पै चढ़कै सुनसान जगहां म्ह न्यारे चले गए। ");
INSERT INTO bgc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","घणा नै यीशु अर उसके चेल्यां ताहीं जान्दे देखकै पिछाण लिया, अर सारे नगरां तै कठ्ठे होकै उड़ै पांए-पाँ भाज लिए अर उनतै पैहल्या जा पोहचे। ");
INSERT INTO bgc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","उसनै उतरकै बड्डी भीड़ देक्खी, अर उनपै तरस खाया, क्यूँके वे उन भेड्या की तरियां थे, जिनका कोए रुखाळा ना हो; अर वो उननै घणीए बात सिखाण लागग्या। ");
INSERT INTO bgc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जिब दिन घणा ढळग्या, तो उसके चेल्लें उसकै धोरै आकै कहण लागगे, “या सुनसान जगहां सै, अर दिन घणा ढळग्या सै। ");
INSERT INTO bgc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","उननै बिदा करकै चौगरदेकै गाम्मां अर बस्तियाँ म्ह जाकै, अपणे खाण खात्तर कुछ मोल लियावै।” ");
INSERT INTO bgc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","यीशु नै जवाब दिया, “थमे उननै खाण नै द्यो।” चेल्यां नै उस ताहीं कह्या, “के हम दो सौ दीनार (200 दिन की मजदूरी) की रोट्टी मोल ल्यावां, अर उननै खुआवां?” ");
INSERT INTO bgc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","यीशु नै उन ताहीं कह्या, “जाकै देक्खो थारे धोरै कितनी रोट्टी सै?” उननै कह्या, “पाँच रोट्टी अर दो मच्छी भी।” ");
INSERT INTO bgc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","फेर यीशु नै उन ताहीं हुकम दिया के सारया नै हरी घास पै टोळ म्ह बिठा द्यो। ");
INSERT INTO bgc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","वे सौ-सौ अर पचास-पचास करकै टोळ म्ह बैठगें। ");
INSERT INTO bgc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","यीशु नै उन पाँच रोट्टी अर दो मच्छियाँ ताहीं लिया, अर सुर्ग कै कान्ही लखाकै परमेसवर का धन्यवाद करया, अर रोट्टी तोड़-तोड़कै चेल्यां ताहीं देन्दा गया के वे माणसां ताहीं बांडै, अर वे दो मच्छियाँ भी उन सारया म्ह बांड दी। ");
INSERT INTO bgc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","सारे खाकै धापगे, ");
INSERT INTO bgc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","अर उननै टुकड्या अर मच्छियाँ तै भरी होई बारहा टोकरियाँ ठाई। ");
INSERT INTO bgc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","जिन नै रोट्टी खाई, वे पाँच हजार आदमी थे। ");
INSERT INTO bgc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","फेर यीशु नै जिब्बे अपणे चेल्यां ताहीं किस्ती पै चढ़ण कै खात्तर मजबूर करया, ताके वे उसतै पैहल्या उस पार बैतसैदा नगर म्ह चले जावै, जिब तक के वो माणसां ताहीं बिदा करै। ");
INSERT INTO bgc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","चेल्यां नै बिदा करकै यीशु पहाड़ पै प्रार्थना करण खात्तर गया। ");
INSERT INTO bgc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","जिब साँझ होई, तो किस्ती समुन्दर कै बिचाळै थी, अर यीशु एक्ला किनारे पै था। ");
INSERT INTO bgc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","जिब उसनै देख्या के वे किस्ती चलाणा म्ह घणी मेहनत करण लागरे सै, क्यूँके हवा उनके स्याम्ही की थी, तो सबेरै तीन बजे कै लोवै-धोवै यीशु समुन्दर पै चाल्दे होए उनकै धोरै आया; अर उनतै आग्गै लिकड़ जाणा चाहवै था। ");
INSERT INTO bgc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पर चेल्यां नै उस ताहीं समुन्दर पै चाल्दे देखकै समझया के भूत सै, अर किल्की मारण लाग्गे; ");
INSERT INTO bgc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","क्यूँके सारे उसनै देखकै घबरागे थे। पर उसनै जिब्बे उनतै बात करी अर कह्या, “होसला राक्खो, मै सूं; डरो मतना!” ");
INSERT INTO bgc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","फेर वो उनकै धोरै किस्ती पै आया, अर हवा थमगी: अर वे घणा अचम्भा करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","चेल्लें उस रोट्टी की घटना के बारै म्ह कोनी समझै थे, क्यूँके उनके दिल कठोर होरे थे। ");
INSERT INTO bgc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","वे गलील समुन्दर पार करकै गन्नेसरत परदेस म्ह पोहचे, अर किस्ती घाट पै लाई। ");
INSERT INTO bgc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","जिब यीशु किस्ती पै तै उतरया तो माणसां नै उस ताहीं पिच्छाण लिया, ");
INSERT INTO bgc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","लोवै-धोवै कै सारे नगर म्ह भाज्जे-भाज्जे, अर बिमारां नै खाट्टां पै लादकै, जित्त-जित्त खबर मिली के यीशु ओड़ै सै, उड़ै-उड़ै लिए हान्डे। ");
INSERT INTO bgc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","अर जित्त किते भी वो गाम्मां, नगरां, या बस्तियाँ म्ह जावै था, माणस बिमारां नै बजारां म्ह धरकै उसतै बिनती करै थे के वो उननै अपणे लत्ते कै पल्ले तै ए छू लेण दे: अर जितने उसनै छुवै थे, सारे ठीक हो जावै थे। ");
INSERT INTO bgc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","एक दिन कुछ फरीसी अर शास्त्री जो यरुशलेम नगर तै आए थे, यीशु कै धोरै कठ्ठे होए, ");
INSERT INTO bgc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","अर उननै उसके कुछ चेल्यां ताहीं बिना सुच्चे होए यानिके बिना हाथ धोए रोट्टी खांदे देख्या। ");
INSERT INTO bgc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","क्यूँके फरीसी अर सारे यहूदी, बड़े बुजुर्गां के रीति-रिवाजां पै चाल्लै सै अर जिब ताहीं ठीक ढाळ हाथ न्ही धो लेंदे जद ताहीं कोनी खान्दे। ");
INSERT INTO bgc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","अर बजार तै आकै, जिब तक के अपणे हाथ न्ही धो लेते, जद ताहीं रोट्टी कोनी खान्दे; और घणीए बात सै, जो उनके रीति-रिवाजां का हिस्सा सै, जिस तरियां कटोरे, अर लोट्टे, अर ताम्बे के बरतनां ताहीं धोणा मान्जणा। ");
INSERT INTO bgc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","इस करकै उन फरीसियाँ अर शास्त्रियाँ नै यीशु तै बुझ्झया, “तेरे चेल्लें क्यांतै बड़े बुजुर्गां के रीति-रिवाजां पै कोनी चाल्दे, अर बिना हाथ धोए रोट्टी खावै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","यीशु नै फरीसियाँ अर शास्त्रियाँ ताहीं कह्या, “यशायाह नबी नै थम कपटियाँ कै बारै म्ह घणी ठीक भविष्यवाणी करी; जिसा लिख्या सै: ‘ये माणस होठ्ठां तै तो मेरा आदर करै सै पर उनका मन मेरै तै दूर रहवै सै। ");
INSERT INTO bgc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","वे खामखां मेरी पूजा करै सै, क्यूँके माणसां कै हुकमां नै धर्म का उपदेश करकै सिखावै सै।’” ");
INSERT INTO bgc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“क्यूँके थम परमेसवर कै हुकम नै टाळकै माणसां कै रिवाजां ताहीं मान्नो सो।” ");
INSERT INTO bgc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","उसनै उन ताहीं कह्या, “थम अपणे रिवाजां नै मानण कै खात्तर परमेसवर का हुकम कितनी बढ़िया ढाळ टाळ द्यो सो। ");
INSERT INTO bgc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","क्यूँके मूसा नबी नै कह्या सै, ‘अपणे माँ-बाप की इज्जत कर’ अर ‘जो कोए अपणे माँ-बाप नै भुंडा बोल्लै, वो जरुर मारया जावै।’ ");
INSERT INTO bgc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","पर थम कहो सो के जै कोए अपणे माँ-बाप तै कहवै, ‘जो कुछ मन्नै थारे ताहीं अपणी सम्पत्ति म्ह तै देणा था, वो मन्नै परमेसवर ताहीं अर्पण कर दिया।’ ");
INSERT INTO bgc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","तो थम उननै उसके माँ बाप की कुछ भी सेवा करण न्ही देन्दे। ");
INSERT INTO bgc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","इस तरियां थम अपणी रीत-रिवाजां तै, जिन ताहीं थमनै ठहराया सै, परमेसवर का वचन टाळ द्यो सो; अर इसे-इसे घणखरे काम करो सो।” ");
INSERT INTO bgc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","फेर यीशु नै माणसां ताहीं अपणे धोरै बुलाकै कह्या, “थम सारे मेरी सुणो, अर समझो। ");
INSERT INTO bgc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","इसी कोए चीज कोनी जो माणस म्ह बाहर तै बड़कै उस ताहीं अशुद्ध करै; पर जो चीज माणस कै भीत्त्तर तै लिकड़ै सै, वैए उस ताहीं अशुद्ध करै सै। ");
INSERT INTO bgc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(जै किसे के कान हो तो वो ध्यान तै सुण ले।)” ");
INSERT INTO bgc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जिब यीशु भीड़ नै छोड़कै घरां आया, तो उसके चेल्यां नै इस उदाहरण कै बारै म्ह उसतै बुझ्झया। ");
INSERT INTO bgc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","यीशु नै उनतै कह्या, “के थम भी इसे नासमझ सो? के थमनै न्ही बेरा के जो चीज बाहर तै माणस कै भीत्त्तर जावै सै वा उसनै अशुद्ध कोनी कर सकदी? ");
INSERT INTO bgc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","क्यूँके वा उसकै मन म्ह न्ही, पर पेट म्ह जावै सै, अर संडास म्ह लिकड़ जावै सै?” न्यू कहकै उसनै सारी खाणे की चिज्जां ताहीं शुद्ध ठहराया। ");
INSERT INTO bgc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","फेर उसनै कह्या, “जो माणस म्ह तै लिकड़ै सै, वोए माणस नै अशुद्ध करै सै। ");
INSERT INTO bgc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","क्यूँके भीत्त्तर तै, यानिके माणस कै मन तै, भुन्डे़-भुन्डे़ ख्याल, जारी, चोरी, हत्या, बिगान्नी बिरबान्नी कै धोरै जाणा, ");
INSERT INTO bgc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","लोभ, दुष्टता, छळ, लुचपण, जलन, बुराई, घमण्ड, अर बेअक्ली लिकड़ै सै। ");
INSERT INTO bgc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ये सारी भुंडी बात भीत्त्तर तै ए लिकड़ै सै अर माणस नै अशुद्ध करै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","फेर यीशु ओड़ै तै उठकै सूर अर सैदा के परदेस म्ह आया; जित्त एक घर म्ह गया अर वो चाहवै था ताके किसे नै उनके बारें म्ह बेरा न्ही लाग्गै, पर वो लुह्क न्ही सक्या। ");
INSERT INTO bgc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","अर जिब्बे एक बिरबान्नी जिसकी छोट्टी छोरी म्ह ओपरी आत्मा थी, उसका जिक्र सुणकै आई, अर उसकै पायां म्ह पड़गी। ");
INSERT INTO bgc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","वा सुरुफिनिकी परदेस के यूनानी जात की थी। बिरबान्नी नै उसतै बिनती करी के मेरी छोरी म्ह तै ओपरी आत्मा लिकाड़ दे। ");
INSERT INTO bgc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","उसनै उसतै कह्या, “पैहल्या मेरे बच्चें जो यहूदी सै उननै खा लेण दे, क्यूँके बाळकां की रोट्टी लेकै कुत्याँ कै आग्गै गेरणा ठीक कोनी।” (यहूदी दुसरी जात के माणसां नै कुत्याँ कै समान समझै थे) ");
INSERT INTO bgc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","उसनै उस ताहीं जवाब दिया, “साच्ची सै प्रभु; पर कुत्ते भी तो मेज कै तळै बाळकां की रोट्टी के टुकड़े खा लेवैं सै।” ");
INSERT INTO bgc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीशु नै उसतै कह्या, “तेरी बात सुणकै तेरे बिश्वास का बेरा पाट्टै सै इस कारण चली जा; ओपरी आत्मा तेरी छोरी म्ह तै लिकड़ग्यी सै।” ");
INSERT INTO bgc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","उसनै अपणे घरां आकै देख्या के छोरी खाट पै पड़ी सै, अर ओपरी आत्मा लिकड़ग्यी सै। ");
INSERT INTO bgc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","फेर यीशु सूर अर सैदा के परदेसां तै लिकड़कै दिकापुलिस नगर तै होंदा होड़ गलील समुन्दर पै पोंहच्या। ");
INSERT INTO bgc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","तो आदमियाँ नै एक बैहरै ताहीं जो हाकळा भी था, उसकै धोरै आकै उसतै बिनती करी के अपणा हाथ उसपै धरै। ");
INSERT INTO bgc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","फेर यीशु उसनै भीड़ तै न्यारा लेग्या, अपणी आन्गळी उसकै कान्ना म्ह घाल्ली, अर अपणी आन्गळी पै थूककै उसकी जीभ ताहीं छुया; ");
INSERT INTO bgc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","अर सुर्ग कान्ही देखकै आह भरी, अर उसतै कह्या, “इप्फत्तह!” यानिके “खुल ज्या!” ");
INSERT INTO bgc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","वो सही तरियां सुणण, अर वो सुथरी-ढाळ बोल्लण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","फेर उसनै उन ताहीं चिताया कह्या के किसे तै ना कहियो; पर जितना यीशु नै उन ताहीं बताया उतनाए वे और प्रचार करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","वे घणे हैरान होकै कहण लाग्गे, “उसनै जो कुछ करया सारा ठीक करया सै; वो बैहरया नै सुणण की, गूँगा नै बोल्लण की ताकत देवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","एक दिन जिब भीड़ कठ्ठी होई, अर उनकै धोरै इब कुछ खाण नै कोनी बचा था, तो यीशु नै अपणे चेल्यां ताहीं धोरै बुलाकै उनतै कह्या, ");
INSERT INTO bgc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“मन्नै इस भीड़ पै तरस आवै सै, क्यूँके ये तीन दिनां तै बराबर मेरै गेल्या सै, अर इब उनकै धोरै कुछ खाण नै भी कोनी बचा। ");
INSERT INTO bgc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","जै मै उननै भूक्खा घरां भेज द्यु, तो राह म्ह थक हार कै बेहोस हो ज्यांगें; क्यूँके इन म्ह तै कई लोग दूर तै आरे सै।” ");
INSERT INTO bgc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","उसकै चेल्यां नै जवाब दिया, “उरै जंगल-बियाबान म्ह इतनी रोट्टी कोए कित्त तै ल्यावै के वे छिक्क ज्या?” ");
INSERT INTO bgc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","यीशु नै उनतै बुझ्झया, “थारे धोरै कितनी रोट्टी सै?” उननै कह्या, “सात।” ");
INSERT INTO bgc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","फेर उसनै माणसां ताहीं धरती पै बैठण का हुकम दिया, अर वे सात रोट्टी ली अर परमेसवर का धन्यवाद करकै तोड़ी, अर अपणे चेल्यां नै देन्दा गया, अर उननै वे रोटी माणसां कै आग्गै परोस दी। ");
INSERT INTO bgc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","उनकै धोरै माड़ी-सी छोट्टी मच्छियाँ भी थी; उसनै परमेसवर का धन्यवाद करकै उन ताहीं माणसां कै आग्गै धरण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","वे खाकै छिकगे अर चेल्यां नै बचे होड़ टुकड्या के सात टोकरे भरकै ठाए। ");
INSERT INTO bgc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","अर सारे लोग चार हजार कै करीबन थे; फेर यीशु नै उन ताहीं भेज दिया, ");
INSERT INTO bgc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","अर वो जिब्बे अपणे चेल्यां कै गेल्या किस्ती म्ह चढ़कै दलमनूता परदेस नै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","जब फरीसियाँ नै देख्या कै यीशु दलमनूता परदेस म्ह आ ग्या तो वे उसतै बहस करण लाग्गे, अर यो परखण खात्तर के परमेसवर नै यीशु ताहीं भेज्या सै, उसतै कोए सुर्गीय चिन्ह-चमत्कार की माँग करी। ");
INSERT INTO bgc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","यीशु नै अपणी आत्मा म्ह आह भरकै कह्या, “इस बखत के माणस क्यांतै चिन्ह-चमत्कार टोह्वैं सै? मै थमनै साच्ची-साच कहूँ सूं, के इस बखत के माणसां नै कोए चिन्ह-चमत्कार कोनी दिया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","अर वो उननै छोड़कै फेर किस्ती पै चढ़ग्या अर गलील समुन्दर के परली ओड़ चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","चेल्लें रोट्टी लेणा भूलगे थे, पर किस्ती म्ह उनकै धोरै सिर्फ एक-ए रोट्टी थी। ");
INSERT INTO bgc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","यीशु नै उनकी कपट रूपी शिक्षा के बारें म्ह चिताया, “लखाओ, फरीसियाँ अर हेरोदेस के खमीर तै चौकन्ने रहो।” ");
INSERT INTO bgc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","वे आप्पस म्ह विचार करकै कहण लाग्गे, “म्हारै धोरै तो रोट्टी सै कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","न्यू जाणकै यीशु नै उनतै कह्या, “थम क्यांतै आप्पस म्ह यो विचार कररे सो के म्हारै धोरै रोट्टी कोनी? के इब ताहीं थम न्ही जाणे अर न्ही समझे? के थारा मन कठोर होग्या सै? ");
INSERT INTO bgc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","के आँख होते होए भी कोनी देखदे, अर कान होते होए भी कोनी सुणदे? के थारे याद कोनी। ");
INSERT INTO bgc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","के जिब मन्नै पाँच हजार माणसां कै खात्तर पाँच रोट्टी तोड़ी थी तो थमनै बचे होड़ टुकड्या के कितने टोकरे भरकै ठाए थे, उननै उसतै कह्या, बारहा टोकरे।” ");
INSERT INTO bgc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“अर जिब चार हजार माणसां कै खात्तर सात रोट्टी थी तो थमनै बचे होड़ टुकड्या के कितने टोकरे भरकै ठाए थे?” उननै उसतै कह्या, “सात टोकरे।” ");
INSERT INTO bgc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","उसनै उनतै कह्या, “के थम इब ताहीं न्ही समझदे?” ");
INSERT INTO bgc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","यीशु अर उसके चेल्लें बैतसैदा कस्बे म्ह आए; अर आदमी एक आन्धे नै उसकै धोरै लियाये अर उसतै बिनती करी के उसनै छुवै। ");
INSERT INTO bgc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","वो उस आन्धे का हाथ पकड़कै गाम तै बाहरणै लेग्या, अर अपणी आंगळी पै थूककै उसकी आँखां पै हाथ धरते होए उसतै बुझ्झया, “के तू कुछ देक्खै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","उसनै निगांह ठाकै कह्या, “मै माणसां नै देक्खूँ सूं; वे मन्नै चाल्दे होए दरख्तां की ढाळ दिक्खै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","फेर उसनै दुबारा उसकी आँखां पै हाथ धरे, अर आन्धे नै ध्यान तै देख्या। वो ठीक होग्या, अर सारा कुछ सुथरी-ढाळ देक्खण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","उसनै उस ताहीं न्यू कहकै घरां भेज्या, “इस गाम म्ह भी ना जाईये।” ");
INSERT INTO bgc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","यीशु अर उसकै चेल्लें कैसरिया फिलिप्पी परदेस के गाम्मां म्ह चले गये। राह म्ह उसनै अपणे चेल्यां तै बुझ्झया, “माणस मन्नै के कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","उननै जवाब दिया, “यूहन्ना बपतिस्मा देण आळा, पर कोए एलिय्याह अर कोए-कोए तो उसनै पुराणे नबियाँ म्ह तै एक सै भी कहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","उसनै उनतै बुझ्झया, “पर थम मन्नै के कहो सो?” पतरस नै जवाब दिया, “तू मसीह सै।” ");
INSERT INTO bgc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","फेर उसनै उन ताहीं समझाकै कह्या के मेरै बारै म्ह यो किसे तै ना कहियो। ");
INSERT INTO bgc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","फेर यीशु चेल्यां नै सिखाण लाग्या के माणस कै बेट्टे (उसनै अपणे बारें म्ह कह्या था) खात्तर जरूरी सै के वो घणा दुख ठावै, यहूदी अगुवें, प्रधान याजकां, अर शास्त्री उसनै तुच्छ समझकै मार देवैं, अर वो तीसरे दिन म्ह जिन्दा हो जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","उसनै या बात उनतै साफ-साफ कह दी। इसपै पतरस उसनै न्यारा ले जाकै झिड़कण लाग्या, क्यूँके उसनै सोच्या के मसीह मर न्ही सकदा। ");
INSERT INTO bgc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","पर यीशु नै पलटकै अपणे चेल्यां कान्ही देख्या, अर पतरस तै झिड़ककै कह्या, “हे शैतान, मेरै स्याम्ही तै दूर हो; क्यूँके तू परमेसवर की बात्तां पै न्ही, पर माणसां की बात्तां पै मन लगावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","यीशु नै भीड़ ताहीं अपणे चेल्यां सुधा बुलाकै कह्या, “जो कोए मेरा चेल्ला बणणा चाहवै, वो अपणी ए इच्छा पूरी ना करै बल्के अपणे दुखां का क्रूस ठाकै, मेरै पाच्छै हो लेवै। ");
INSERT INTO bgc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","क्यूँके जो कोए अपणी जान बचाणा चाहवै वो अनन्त काल खात्तर गवावैगा, पर जो कोए मेरै अर सुसमाचार खात्तर अपणी जान गवावैगा, वो उसनै अनन्त काल खात्तर बचावैगा। ");
INSERT INTO bgc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","जै माणस सारी दुनिया की चिज्जां नै पा लेवै अर फेर भी अनन्त जीवन नै न्ही पा सकै, तो उसतै के फैयदा होगा? ");
INSERT INTO bgc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","कोए भी माणस अनन्त जीवन की तुलना दुनिया की किसी भी चीज तै न्ही कर सकता? ");
INSERT INTO bgc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जो कोए इस जार अर पापी युग कै बिचाळै मेरै तै अर मेरे वचन तै इन्कार करैगा, तो मै माणस का बेट्टा भी जिब पवित्र सुर्गदूत्तां कै गेल्या अपणे पिता की महिमा सुधा आऊँगा, तो मै भी उसतै इन्कार करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","यीशु नै उनतै कह्या, “मै थारे तै साच्ची कहूँ सूं के जो उरै खड़े सै, उन म्ह तै कई इसे माणस सै, के जिब ताहीं परमेसवर के राज्य नै सामर्थ सुधा आन्दा होया न्ही देख लेवैंगे, जद तक न्ही मरैंगे।” ");
INSERT INTO bgc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","छ: दिनां पाच्छै यीशु नै पतरस अर याकूब अर यूहन्ना ताहीं गेल्या लिया, अर एकान्त म्ह किसे ऊँच्चे पहाड़ पै लेग्या। ओड़ै उनकै स्याम्ही उसका रूप बदल ग्या, ");
INSERT INTO bgc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","अर उसके लत्ते इसे चमकण लाग्गे उरै ताहीं जमा धोळाधप होया, के धरती पै कोए धोब्बी भी उसा धोळा न्ही लिकाड़ सकदा। ");
INSERT INTO bgc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","अर उननै मूसा नबी कै गेल्या एलिय्याह नबी दिख्या; वे यीशु कै गेल्या बात करै थे। ");
INSERT INTO bgc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","इसपै पतरस नै यीशु तै कह्या, “हे गुरु, म्हारा उरै रहणा ठीक सै: इस करकै हम तीन मण्डप बणावा; एक तेरे खात्तर, एक मूसा नबी खात्तर, एक एलिय्याह नबी खात्तर।” ");
INSERT INTO bgc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","क्यूँके उसनै कोनी बेरा था, के वो के जवाब देवै, ज्यांतै के वे घणे डरगे थे। ");
INSERT INTO bgc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","फेर एक बादळ उनपै छाग्या, अर उस बादळ म्ह तै परमेसवर नै कह्या, “यो मेरा प्यारा बेट्टा सै, इसकी सुणो।” ");
INSERT INTO bgc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","फेर उननै चाणचक चौगरदेकै निगांह घुमाई, अर यीशु नै छोड़ अपणे गेल्या और किसे ताहीं कोनी देख्या। ");
INSERT INTO bgc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","पहाड़ तै उतरदी आणी यीशु नै उन ताहीं हुकम दिया के जिब ताहीं मै माणस का बेट्टा मरे होया म्ह तै जिन्दा न्ही हो जाऊँगा, तब तक जो कुछ थमनै देख्या सै वो किसे तै ना कहियो। ");
INSERT INTO bgc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","चेल्यां नै या बात अपणे मन म्ह ए राक्खी, अर आप्पस म्ह बहस करण लाग्गे, के “मरे होया म्ह तै जी उठण का के मतलब हो सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","अर उननै उसतै बुझ्झया, “शास्त्री क्यांतै कहवै सै के एलिय्याह नबी का पैहल्या आणा जरूरी सै?” ");
INSERT INTO bgc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","यीशु नै उन ताहीं जवाब दिया, “यो सच सै एलिय्याह नबी पैहल्या आकै सारा कुछ सुधारैगा, पर मेरे बारें म्ह पवित्र ग्रन्थ म्ह यो क्यांतै लिख्या सै के वो घणा दुख ठावैगा, अर तुच्छ गिण्या जावैगा? ");
INSERT INTO bgc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पर मै थमनै कहूँ सूं के एलिय्याह नबी तो (जो यूहन्ना सै) आ लिया, अर जिसा के उसकै बारें म्ह पवित्र ग्रन्थ म्ह लिख्या सै, उननै जो कुछ चाह्या उसकै गेल्या करया।” ");
INSERT INTO bgc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","यीशु अर उसके तीन चेल्लें दुसरयां चेल्यां कै धोरै आये, तो देख्या के उनकै चौगरदे नै घणी भीड़ लागरी सै अर शास्त्री उनकै गेल्या बहस कररे सै। ");
INSERT INTO bgc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","यीशु ताहीं देखदे ए सारे घणे हैरान होण लाग्गे, अर उननै यीशु कान्ही भाजकै उसतै नमस्कार करया। ");
INSERT INTO bgc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","यीशु नै उनतै बुझ्झया, “थम इनतै के बहस कररे सो?” ");
INSERT INTO bgc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","भीड़ म्ह तै एक नै उसतै जवाब दिया, “हे गुरु, मै अपणे बेट्टे ताहीं जिसम्ह ओपरी आत्मा सै, जो उसनै बोल्लण कोनी देती। मै उस ताहीं तेरे धोरै ल्याया था। ");
INSERT INTO bgc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","जित्त किते ओपरी आत्मा उसनै पकड़ै सै, उड़ैए पटक देवै सै: अर वो मुँह म्ह तै झाग भर लावै सै, अर दाँत पिसदा, अर सुखदा जावै सै। मन्नै तेरे चेल्यां तै कह्या के वे ओपरी आत्मा नै काढ देवै, पर वे काढ न्ही सके।” ");
INSERT INTO bgc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","न्यू सुणकै यीशु नै उनतै जवाब देकै कह्या, “हे अबिश्वासी माणसों, मै कद ताहीं थारे गेल्या रहूँगा? अर कद ताहीं थारी सहूँगा? बाळक नै मेरै धोरै ल्याओ।” ");
INSERT INTO bgc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","फेर वे बाळक नै यीशु कै धोरै लियाये: अर जिब ओपरी आत्मा नै यीशु ताहीं देख्या, तो उस ओपरी आत्मा नै जिब्बे उस ताहीं मरोड्या, अर वो धरती पै पड़ग्या, अर मुँह तै झाग बगान्दे होए लोट्टण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","यीशु नै उसकै पिता तै बुझ्झया, “इसकी या हालत कद तै सै?” उसनै कह्या, “बाळकपण तै। ");
INSERT INTO bgc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","उसनै इस ताहीं नाश करण खात्तर कदे आग अर कदे पाणी म्ह गेरया, पर जै तू कुछ कर सकै, तो म्हारै पै तरस खाकै म्हारा भला कर।” ");
INSERT INTO bgc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीशु नै उसतै कह्या, “या के बात होई! जै तू कर सकै सै? बिश्वास करण आळा खात्तर सारा कुछ हो सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","बाळक कै पिता नै जिब्बे जोर तै कह्या, “हे प्रभु, मै बिश्वास करुँ सूं, मेरै अबिश्वास का उपाय कर।” ");
INSERT INTO bgc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जिब यीशु नै देख्या के माणस भाजकै भीड़ लावै सै, तो उस ओपरी आत्मा ताहीं न्यू कहकै धमकाया, “हे गूँगी अर बैहरी करण आळी ओपरी आत्मा, मै तन्नै हुकम दियुँ सूं, उस म्ह तै लिकड़ आ, अर उस म्ह फेर कदे ना बड़ीये।” ");
INSERT INTO bgc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","फेर वा किल्की मारकै अर उस ताहीं घणा मरोड़कै, लिकड़ आई; अर बाळक मरया होया-सा होग्या, उरै ताहीं के घणे आदमी कहण लाग्गे के वो मरग्या। ");
INSERT INTO bgc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पर यीशु नै उसका हाथ पकड़कै उस ताहीं ठाया, अर वो खड्या होग्या। ");
INSERT INTO bgc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जिब वो घरां आया, तो उसके चेल्यां नै एक्ले म्ह उसतै बुझ्झया, “हम उस ताहीं क्यांतै न्ही काढ सके?” ");
INSERT INTO bgc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","उसनै उनतै कह्या, “या जात, बिना प्रार्थना किसे और उपाय तै कोनी लिकड़ सकदी।” ");
INSERT INTO bgc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","फेर यीशु अर उसके चेल्यां नै ओड़ै तै लिकड़कै, गलील परदेस का राह लिया। यीशु न्ही चाहवै था के कोए उननै जाणै, क्यूँके वो अपणे चेल्यां ताहीं सिखाणा चाहवै था ");
INSERT INTO bgc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","यीशु उपदेश देन्दा अर अपणे बारै म्ह चेल्यां तै कहवै था, मै “माणस का बेट्टा माणसां कै हाथ्थां म्ह पकड़वाया जाऊँगा, अर वे मन्नै मार देवैगें, अर मै मरण कै तीसरे दिन जिन्दा हो जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पर या बात उनकी समझ म्ह कोनी आई, अर वे उसतै बुझ्झण तै डरै थे। ");
INSERT INTO bgc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","यीशु अर उसके चेल्लें कफरनहूम कस्बे म्ह आये; अर घर म्ह आकै उसनै चेल्यां तै बुझ्झया, “राह म्ह थम किस बात पै बहस कररे थे?” ");
INSERT INTO bgc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","वे बोल-बाल्ले रहे, क्यूँके राह म्ह उननै आप्पस म्ह या बहस करी थी के म्हारै म्ह तै बड्ड़ा कौण सै। ");
INSERT INTO bgc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","फेर यीशु नै बैठकै बारहा चेल्यां ताहीं बुलाया अर उनतै कह्या, “जै कोए बड्ड़ा होणा चाहवै, तो सारया तै छोट्टा अर सारया का सेवक बणै।” ");
INSERT INTO bgc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","अर उसनै एक बाळक लेकै उनकै बिचाळै खड्या करया अर उस ताहीं गोद्दी म्ह लेकै उन ताहीं कह्या, ");
INSERT INTO bgc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जो कोए मेरै नाम तै इसे बाळकां म्ह तै किसे एक नै भी अपणावै सै, वो मन्नै अपणावै सै; अर जो कोए मन्नै अपणावै सै, वो मन्नै न्ही, बल्के मेरै भेजण आळे नै अपणावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","यूहन्ना नै यीशु ताहीं कह्या, “हे गुरु, हमनै एक माणस ताहीं तेरे नाम तै ओपरी आत्मा नै लिकाड़दे देख्या अर हम उसनै मना करण लाग्गे, क्यूँके वो म्हारी तरियां तेरा चेल्ला न्ही था।” ");
INSERT INTO bgc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","उसनै कह्या, “उस ताहीं मना मत करो; क्यूँके इसा कोए न्ही जो मेरै नाम तै अदभुत काम करै, अर दुसरे पल मेरी बुराई करै ");
INSERT INTO bgc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","क्यूँके जो म्हारै बिरोध म्ह न्ही, वो म्हारै कान्ही सै। ");
INSERT INTO bgc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जै कोए एक कटोरा पाणी भी थमनै ज्यांतै प्यावै के थम मसीह के सो तो मै थमनै सच कहूँ सूं के वो अपणा ईनाम किसे तरियां भी न्ही खोवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","पर जो कोए इन छोट्टे बाळकां कै समान जो मेरै पै बिश्वास करै सै, किसे तै भी पाप करवावै तो उसकै खात्तर भला योए सै के एक बड्डी चाक्की का पाट उसकै गळ म्ह लटकाया जावै अर वो समुंदर म्ह गेरया जावै। ");
INSERT INTO bgc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","जै तेरा हाथ तेरे तै पाप करवावै तो उसनै काट दे। टुंडा होकै अनन्त जीवन म्ह बड़णा तेरे खात्तर भला सै इसके बजाये के दो हाथ रहंदे होए नरक की आग म्ह गेरया जावै जो कदे न्ही बुझै। ");
INSERT INTO bgc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(जड़ै उनका कीड़ा कोनी मरदा अर आग कोनी बुझदी।) ");
INSERT INTO bgc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","जै तेरा पैर तेरे तै पाप करवावै तो उसनै काट दे। लंगड़ा होकै अनन्त जीवन म्ह बड़णा तेरे खात्तर भला सै इसके बजाये के दो पैर रहंदे होए नरक की आग म्ह गेरया जावै। ");
INSERT INTO bgc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(जड़ै उनका कीड़ा कोनी मरदा अर आग कोनी बुझदी।) ");
INSERT INTO bgc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","जै तेरी आँख तेरे तै पाप करवावै तो उसनै लिकाड़ दे। काणा होकै परमेसवर कै राज्य म्ह बड़णा तेरे खात्तर भला सै के दो आँख रहंदे होए तू नरक म्ह गेरया जावै। ");
INSERT INTO bgc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“जड़ै उनका कीड़ा कोनी मरदा अर आग कोनी बुझदी।” ");
INSERT INTO bgc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","हरेक माणस आग तै शुद्ध करया जावैगा, जिस तरियां बलिदान नूण तै शुद्ध करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“नूण एक जरूरत की चीज सै, पर जै नूण का सुवाद जान्दा रहवै तो उसनै किस तरियां नमकीन करोगे? अपणे म्ह नूण जिसा गुण राक्खो, अर आप्पस म्ह मेळ-मिलाप तै रहो।” ");
INSERT INTO bgc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","यीशु ओड़ै तै उठकै यहूदिया नगर की सीमा नै पार करकै, यरदन नदी कै परली ओड़ आया। भीड़ उसकै धोरै कठ्ठी होग्यी, अर अपणी रीत कै मुताबिक उननै दुबारै उपदेश देण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","फेर फरीसियाँ नै यीशु कै धोरै आकै उस ताहीं परखण खात्तर उसतै बुझ्झया, “के यो ठीक सै के माणस अपणी घरआळी नै छोड्डै?” ");
INSERT INTO bgc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","यीशु नै उनतै पूच्छया, “मूसा नबी नै थारे ताहीं के हुकम दिया सै?” ");
INSERT INTO bgc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","उननै कह्या, “मूसा नबी नै तो तलाकनामा देकै अर छोड़ण का हुकम दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यीशु नै उनतै कह्या, “थारे मन की कठोरता कै कारण उसनै थारे खात्तर यो हुकम लिख्या।” ");
INSERT INTO bgc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“पर सृष्टि की शरुआत तै परमेसवर नै नर अर नारी करकै उन ताहीं बणाया सै। ");
INSERT INTO bgc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","इस कारण माणस अपणे माँ-बाप तै न्यारा होकै अपणी घरआळी गेल्या रहवैगा, ");
INSERT INTO bgc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","अर वे दोन्नु कठ्ठे रहवैंगे; ज्यांतै के वे इब दो न्ही पर एक तन सै। ");
INSERT INTO bgc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","इस करकै जिस ताहीं परमेसवर नै जोड़या सै उस ताहीं माणस न्यारा ना करै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","जब वे दोबारा घरां आये, तो चेल्यां नै तलाक कै बारें म्ह उसतै फेर बुझ्झया। ");
INSERT INTO bgc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","यीशु नै उनतै कह्या, “जो कोए अपणी घरआळी नै छोड़कै दुसरी तै ब्याह करै तो वो उस पैहल्ड़ी कै बिरोध म्ह जारी करै सै; ");
INSERT INTO bgc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","अर जै घरआळी अपणे धणी नै छोड़कै दुसरे तै ब्याह करै तो वा जारी करै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","फेर माणस अपणे बाळकां नै उसकै धोरै ल्याण लाग्गे के वो उनपै हाथ धरै, पर चेल्यां नै उन ताहीं धमकाया। ");
INSERT INTO bgc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीशु नै न्यू देख छो म्ह होकै कह्या, “बाळकां नै मेरै धोरै आण द्यो अर उननै मना मतना करो, क्यूँके परमेसवर का राज्य बाळकां के समान सै। ");
INSERT INTO bgc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मै थमनै सच कहूँ सूं के जो कोए परमेसवर के राज्य नै बाळक की तरियां न्ही अपणावै, वो उस म्ह कदे न्ही बड़ण पावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","अर उसनै उन ताहीं गोद्दी म्ह लिया, अर उनपै हाथ धरकै उन ताहीं आशीर्वाद दिया। ");
INSERT INTO bgc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","जिब यीशु अर उसके चेल्लें यरुशलेम की ओड़ जाण लागरे थे, तो एक माणस उसकै धोरै भाज्दा होया आया, अर उसकै आग्गै घुटने टेक कै उसतै बुझ्झया, “हे उत्तम गुरु, अनन्त जीवन का हकदार होण खात्तर मै के करुँ?” ");
INSERT INTO bgc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीशु नै उसतै कह्या, “तू मन्नै उत्तम क्यांतै कहवै सै? परमेसवर नै छोड़कै कोए उत्तम कोनी। ");
INSERT INTO bgc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तन्नै हुकमां का तो बेराए सै: ‘खून न्ही करणा, जारी न्ही करणा, चोरी न्ही करणा, झूठ्ठी गवाही न्ही देणा, छळ न्ही करणा, अपणे माँ-बाप का आदर करणा।’” ");
INSERT INTO bgc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","उसनै यीशु तै कह्या, “हे गुरु, इन सारया नै मै बाळकपण तै मानता आऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","यीशु नै उसपै निगांह करकै उसतै प्यार करया, अर उसतै कह्या, “तेरे म्ह एक बात की कमी सै। जा, जो कुछ तेरा सै उसनै बेचकै कंगालां ताहीं दे, अर तन्नै सुर्ग म्ह धन मिलैगा, अर आकै मेरा चेल्ला बणण खात्तर मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","इस बात तै उसकै मुँह पै उदासी छाग्यी, अर वो दुखी होंदा होया चल्या गया, क्यूँके वो घणा साहूकार था। ");
INSERT INTO bgc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","यीशु नै चौगरदेकै देखकै अपणे चेल्यां तै कह्या, “साहूकारां का परमेसवर कै राज्य म्ह दाखल होणा कितना ओक्खा सै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","चेल्लें उसकी बात तै हैरान होए। इसपै यीशु नै उनतै दुबारै कह्या, “हे बाळकों, जो धन पै भरोस्सा राक्खै सै, उनकै खात्तर परमेसवर कै राज्य म्ह बड़णा कितना ओक्खा सै! ");
INSERT INTO bgc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ऊँट का सूई कै छेद म्ह तै लिकड़णा आसान हो सकै सै। पर परमेसवर के राज्य म्ह साहूकार का बड़णा भोत मुश्किल सै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","वे घणेए हैरान होकै आप्पस म्ह कहण लाग्गे, “तो फेर किसका उद्धार हो सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीशु नै उनकी ओड़ देखकै कह्या, “माणसां तै तो यो न्ही हो सकदा, पर परमेसवर तै हो सकै सै; क्यूँके परमेसवर खात्तर कुछ भी मुश्किल कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस उसतै कहण लाग्या, “देख, हम तो सब कुछ छोड़कै तेरे चेल्लें बणगे सा।” ");
INSERT INTO bgc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीशु नै कह्या, “मै थमनै साच्ची-साच कहूँ सूं के इसा कोए कोनी, जिसनै मेरै अर मेरै सुसमाचार कै खात्तर घर, भाण-भाई, माँ-बाप, बाळ-बच्चे या जमीन-जायदाद ताहीं छोड़ दिया हो, ");
INSERT INTO bgc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","अर इब इस युग म्ह सताव के बदले म्ह घर, भाण-भाई, माँ-बाप या बाळ-बच्चे अर जमीन-जायदाद का सौ गुणा पर आण आळे बखत म्ह अनन्त जीवन पावैगा। ");
INSERT INTO bgc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","पर घणखरे जो पैहले सै, पाच्छले होंगे; अर जो पाच्छले सै, वे पैहले होंगे।” ");
INSERT INTO bgc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","वे यरुशलेम नगर म्ह जान्दे होए राह म्ह थे, अर यीशु उनकै आग्गै-आग्गै जाण लाग रहया था: चेल्लें हैरान थे अर जो चेल्यां कै गैल-गैल चाल्लै थे, वे डररे थे। फेर वो उन बारहां चेल्यां नै न्यारा ले ज्याकै उनतै ये बात कह्ण लाग्या, जो उसकै गेल्या होण आळा था, ");
INSERT INTO bgc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“देक्खो, हम यरुशलेम नगर म्ह जावां सा, अर मै माणस का बेट्टा प्रधान याजकां अर शास्त्रियाँ कै हाथ्थां पकड़वाया जाऊँगा, अर वे मन्नै मारण खात्तर गैर यहूदियाँ कै हाथ्थां म्ह सौपैगें। ");
INSERT INTO bgc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","वे मेरा मजाक उड़ावैगें, मेरै पै थूकैगें, मेरै कोरड़े मारैगें अर मन्नै मार देवैगें, अर तीसरे दिन मै जिन्दा हो जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","कुछ दिनां बाद जब्दी के दोन्नु बेट्टे याकूब अर यूहन्ना नै यीशु कै धोरै आकै कह्या, “हे गुरु, हम चाहवां सां के जो कुछ हम तेरे तै माँग्गा, वो तू म्हारै खात्तर करै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","यीशु नै उनतै कह्या, “थम के चाहो सो के थारे खात्तर करुँ?” ");
INSERT INTO bgc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","उननै यीशु तै कह्या, “हमनै यो हक दे, के तेरी महिमा म्ह म्हारै म्ह तै एक तेरे सोळे अर दुसरा तेरे ओळै कान्ही बेठ्ठै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीशु नै उनतै कह्या, “थम न्ही जाणदे के थम के माँग्गो सो? अर जो दुख का कटोरा मै पीण पै सूं, के थम पी सको सो? अर जो मौत का बपतिस्मा मै लेण पै सूं, के थम ले सको सो?” ");
INSERT INTO bgc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","उननै यीशु तै कह्या, “हम कर सका सां।” यीशु नै उनतै कह्या, “जो दुख का कटोरा मै पीण पै सूं, थम पी ल्योगे; अर जो बपतिस्मा मै लेण पै सूं, उसनै ले भी ल्योगे। ");
INSERT INTO bgc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","पर जिन खात्तर वा जगहां त्यार करी गई सै, उन ताहीं छोड़ और किसे नै अपणी सोळी अर अपणी ओळी ओड़ बिठाणा मेरा काम कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","न्यू सुणकै बाकी दस चेल्लें याकूब अर यूहन्ना तै चिड़गे। ");
INSERT INTO bgc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","तो यीशु नै उन ताहीं धोरै बुलाकै उनतै कह्या, “थमनै बेरा सै के जो गैर यहूदियाँ के हाकिम समझे जावै सै, वे उनपै राज करै सै; अर उन म्ह जो बड़े सै, उनपै हक जमावैं सै। ");
INSERT INTO bgc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पर थारे म्ह इसा न्ही होणा चाहिये, बल्के जो कोए थारे म्ह बड्ड़ा होणा चाहवैं वो थारा सेवक बणै; ");
INSERT INTO bgc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","अर जो थारे म्ह प्रधान होणा चाहवैं, वो सारया का दास बणै। ");
INSERT INTO bgc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","क्यूँके मै माणस का बेट्टा ज्यांतै कोनी आया के अपणी सेवा-पाणी करवाऊँ, पर ज्यांतै आया के खुद सेवा-पाणी करुँ, अर घणखरयां के छुटकारै कै खात्तर अपणी जान देऊँ।” ");
INSERT INTO bgc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","यीशु अर उसके चेल्लें यरुशलेम नगर जाते बखत यरीहो नगर म्ह आये, अर जिब वो अर उसके चेल्लें, अर एक बड्डी भीड़ यरीहो नगर तै लिकड़ै जाण लागरी थी, तो सड़क कै किनारे एक आन्धा भिखारी बेठ्या था, जो तिमाई का बेट्टा बरतिमाई था, ");
INSERT INTO bgc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","उसनै न्यू सुणकै के नासरत का यीशु उरै सै, रुक्के मार-मारकै कहण लाग्या, “हे दाऊद की ऊलाद, यीशु मेरै पै दया कर!” ");
INSERT INTO bgc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","घणाए नै उस ताहीं धमकाया के बोल-बाल्ला रह, पर वो और भी रुक्के मारण लाग्या, “हे दाऊद की ऊलाद, मेरै पै दया कर!” ");
INSERT INTO bgc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","फेर यीशु नै ठहरकै कह्या, “उस ताहीं बुलाओ।” अर आदमियाँ नै उस आन्धे ताहीं बुलाकै उसतै कह्या, “धीरज धर! उठ! यीशु तन्नै बुलावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","वो अपणा चोगा बगाकै तोळा उठ्या, अर यीशु कै धोरै आया। ");
INSERT INTO bgc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","इसपै यीशु नै उसतै कह्या, “तू के चाहवै सै के मै तेरे खात्तर करुँ?” आन्धे नै उसतै कह्या, “हे गुरु, योए के मै देक्खण लाग्गू।” ");
INSERT INTO bgc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीशु नै उसतै कह्या, “चल्या जा, तेरे बिश्वास नै तेरे ताहीं ठीक करया सै।” वो जिब्बे देखण लाग्या, अर राह म्ह उसकै पाच्छै हो लिया। ");
INSERT INTO bgc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जिब यीशु अर उसके चेल्लें यरुशलेम नगर कै लोवै, जैतून पहाड़ पै बैतफगे अर बैतनिय्याह गाम कै धोरै आये तो उसनै अपणे चेल्यां म्ह तै दोयां ताहीं न्यू कहकै भेज्या, ");
INSERT INTO bgc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“स्याम्ही कै गाम म्ह जाओ, अर उस म्ह पोहचदे एक गधी का बच्चा, बन्धया होया थमनै मिलैगा। जिसकी सवारी किसे नै इब ताहीं न्ही करी सै, उसनै खोल ल्याओ। ");
INSERT INTO bgc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","जै थारे तै कोए बुझ्झै, यो के करो सो? तो कहियो, ‘प्रभु नै इसकी जरूरत सै, अर वो तोळा उसनै भेज देवैगा।’” ");
INSERT INTO bgc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","चेल्यां नै जाकै उस गधी के बच्चे ताहीं बाहरणै दरबाजे कै धोरै आँगण म्ह बन्धया होया पाया, अर खोल्लण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","उन म्ह तै जो ओड़ै खड़े थे, कई कहण लाग्गे, “यो के करो सो, गधी कै बच्चे नै क्यांतै खोल्लो सो?” ");
INSERT INTO bgc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","जिसा यीशु नै कह्या था, उस्से तरियां उननै कह दिया; फेर माणसां नै उन ताहीं जाण दिया। ");
INSERT INTO bgc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","चेल्यां नै गधी कै बच्चे ताहीं यीशु कै धोरै ल्याकै उसपै अपणे लत्ते बिछाये अर वो उसपै बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","फेर घणखरे माणसां नै अपणे लत्ते राह म्ह बिछाये अर औरां नै खेत्तां म्ह तै डालियाँ काटकै फैला दी। ");
INSERT INTO bgc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","जो उसकै आग्गै-आग्गै अर पाच्छै-पाच्छै चाल्लै थे, रुक्के मार-मारकै कहन्दे जावै थे, “होशाना!” “धन्य सै वो जो प्रभु कै नाम तै आवै सै!” ");
INSERT INTO bgc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","म्हारै पिता दाऊद का राज्य जो आवै सै; “धन्य सै! अकास म्ह होशाना!” ");
INSERT INTO bgc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","यीशु यरुशलेम नगर पोहचकै मन्दर म्ह आया, अर चौगरदे की सारी चिज्जां नै देखकै बारहां चेल्यां कै गेल्या बैतनिय्याह गाम म्ह गया, क्यूँके साँझ होग्यी थी। ");
INSERT INTO bgc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","आगले दिन सबेरै जिब यीशु अर उसके चेल्लें बैतनिय्याह गाम तै लिकड़े तो यीशु नै भूख लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","यीशु दूर तै अंजीर का हरा दरखत देखकै उसकै धोरै गया के, के बेरा उस म्ह कुछ पा ज्या: पर पत्त्या नै छोड़कै उस म्ह कुछ न्ही पाया; क्यूँके फळ लाग्गण का बखत कोनी था। ");
INSERT INTO bgc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","यीशु नै उस दरखत ताहीं देखकै उस ताहीं कह्या, “आज कै पाच्छै कोए तेरा फळ न्ही खावैगा!” अर उसकै चेल्लें सुणण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","फेर यीशु अर उसके चेल्लें यरुशलेम म्ह आये, अर वो मन्दर म्ह गया; अर ओड़ै जो व्यापार करै थे उननै बाहरणै लिकाड़ण लाग्या, सर्राफां (पईसा का लेण देण करण आळे) के पीढ़े अर कबूतर बेचणीयाँ की चौकियाँ उल्ट दी, ");
INSERT INTO bgc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","अर मन्दर म्ह किसे ताहीं भी व्यापार करण खात्तर आण-जाण कोनी दिया। ");
INSERT INTO bgc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","अर उपदेश देकै उनतै कह्या, “के पवित्र ग्रन्थ म्ह यो न्ही लिख्या सै, के मेरा घर सारी जात्तां कै खात्तर प्रार्थना का घर कुह्वावैगा? पर थमनै इस ताहीं डाकुआं की गुफा बणा दी सै।” ");
INSERT INTO bgc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","या घटना सुणकै सारे प्रधान याजक अर शास्त्री लोग उसनै मारण का मौक्का टोह्ण लाग्गे; पर वे भीड़ तै डरै थे, क्यूँके सारे माणस उसकै उपदेश तै भोत परभाबित होवै थे। ");
INSERT INTO bgc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","अर उस दिन साँझ होन्दे यीशु अर उसके चेल्लें रात काट्टण खात्तर यरुशलेम नगर तै बाहरणै चले गये। ");
INSERT INTO bgc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","फेर तड़कैए नै जिब यीशु अर उसके चेल्लें ओड़ै कै जावै थे तो उननै उस अंजीर कै दरखत ताहीं जड़ तै ए सूख्या होया देख्या। ");
INSERT INTO bgc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरस नै वा बात याद आई, अर उसनै उसतै कह्या, “हे गुरु, देख! यो अंजीर का दरखत जिस ताहीं तन्नै श्राप दिया था, वो सूख ग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीशु नै उस ताहीं जवाब दिया, “परमेसवर पै बिश्वास राक्खो। ");
INSERT INTO bgc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मै थमनै साच्ची कहूँ सूं के जो कोए इस पहाड़ नै कहवै, ‘तू उखड़ जा, अर समुन्दर म्ह जा पड़,’ अर अपणे मन म्ह शक ना करै, बल्के बिश्वास करै के जो कहूँ सूं वो हो जावैगा, तो उसकै खात्तर वोए होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ज्यांतै मै थमनै कहूँ सूं के जो कुछ थम प्रार्थना करकै माँग्गो, तो बिश्वास कर ल्यो के थमनै मिलग्या, अर थारे खात्तर हो जावैगा। ");
INSERT INTO bgc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","अर जिब कदे थम प्रार्थना खात्तर खड़े होओ, तो जै थारे मन म्ह किसे कै बिरोध म्ह कुछ हो, तो उसनै माफ करो: ज्यांतै के थारा सुर्गीय पिता भी थारे अपराध माफ करै। ");
INSERT INTO bgc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","अर जै थम माफ ना करो तो थारा पिता भी जो सुर्ग म्ह सै, थारा कसूर माफ कोनी करैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","यीशु अर उसके चेल्लें फेर यरुशलेम म्ह आये, अर जिब वो मन्दर म्ह टहलरया था तो सारे प्रधान याजक अर शास्त्री अर यहूदी अगुवें उसकै धोरै आकै बुझ्झण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“तू ये काम किस हक तै करै सै? अर यो हक तेरे ताहीं किसनै दिया सै के तू ये काम करै?” ");
INSERT INTO bgc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","यीशु नै उनतै कह्या, “मै भी थारे तै एक बात बुझ्झु सूं; मन्नै जवाब दियो तो मै थमनै बताऊँगा के ये काम किस हक तै करुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्ना ताहीं बपतिस्मा देण का हक परमेसवर की ओड़ तै था या माणसां की ओड़ तै था? मन्नै जवाब द्यो।” ");
INSERT INTO bgc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","फेर वे आप्पस म्ह बहस करण लाग्गे के जै हम कह्वां, परमेसवर की ओड़ तै, तो वो कहवैगा, फेर थमनै बिश्वास क्यांतै न्ही करया? ");
INSERT INTO bgc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","अर जै हम कह्वां, माणसां की ओड़ तै, तो माणसां की भीड़ का डर सै, क्यूँके सारे जाणै सै के यूहन्ना साच्चीये नबी था। ");
INSERT INTO bgc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","उननै यीशु ताहीं जवाब दिया, “हमनै न्ही बेरा।” यीशु नै उनतै कह्या, “मै भी थारे तै कोनी बतान्दा के ये काम किस हक तै करुँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","यीशु उदाहरणां म्ह उनतै बात करण लाग्या: “किसे माणस नै अंगूर का बाग लगाया, अर उसकै चौगरदे नै बाड़ा बाँधया, अर रस का कुण्ड खोद्या, अर रुखाळ खात्तर एक मचान बणाया; अर किसानां ताहीं उसका ठेक्का देकै परदेस चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","फेर फळ तोड़ण का बखत लोवै आया, तो बाग के माल्लिक नै अपणे नौक्कर ताहीं उसका फळ लेण नै किसानां धोरै भेज्या के किसानां तै अंगूर के बाग के फळां का हिस्सा लेवै। ");
INSERT INTO bgc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पर किसानां नै उस नौक्कर ताहीं पकड़कै छेत्या अर खाल्ली हाथ भेज दिया। ");
INSERT INTO bgc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","फेर उसनै एक और नौक्कर ताहीं उनकै धोरै भेज्या; उननै उसकी बेजती करी उसका सिर फोड़ दिया अर। ");
INSERT INTO bgc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","फेर उस माल्लिक नै एक और ताहीं भेज्या; उननै उस नौक्कर ताहीं भी मार दिया। फेर उसनै और घणाए ताहीं भेज्या; उन म्ह तै उननै कुछ तो छेत्ते अर कुछ मार दिये।” ");
INSERT INTO bgc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“इब माल्लिक कै धोरै एकैए आदमी रहग्या जो उसका प्यारा बेट्टा था; आखर म्ह उसनै अपणे बेट्टे ताहीं भी उनकै धोरै न्यू सोचकै भेज्या के वे मेरै बेट्टे की इज्जत तो जरुर करैगें।” ");
INSERT INTO bgc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पर उन किसानां नै आप्पस म्ह कह्या, “योए तो वारिस सै; आओ, हम इसनै मार द्या, फेर यो अंगूर का बाग म्हारा हो जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","अर उननै उस ताहीं पकड़कै मार दिया, अर अंगूर के बाग तै बाहरणै बगा दिया। ");
INSERT INTO bgc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","इस करकै अंगूर के बाग का माल्लिक के करैगा? वो आकै उन किसानां का नाश करैगा, अर अंगूर के बाग का ठेक्का दुसरे किसानां नै दे देवैगा। ");
INSERT INTO bgc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","के थमनै पवित्र ग्रन्थ म्ह यो वचन कोनी पढ्या: जिस पत्थर ताहीं राजमिस्त्रियाँ नै बेकार बताया था, वोए कोणे का खास पत्थर होग्या; ");
INSERT INTO bgc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","यो प्रभु की ओड़ तै होया, अर यो म्हारे खात्तर अनोक्खा सै! ");
INSERT INTO bgc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","फेर यहूदियाँ के प्रधान नै उस ताहीं पकड़णा चाह्या; क्यूँके वे समझगे थे, के उसनै म्हारै बिरोध म्ह यो उदाहरण कह्या सै: पर वे माणसां तै डरगे, अर उसनै छोड़कै चले गये। ");
INSERT INTO bgc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","फेर यहूदियाँ के प्रधान नै यीशु ताहीं बात्तां म्ह उलझाण खात्तर कुछ फरीसियाँ अर हेरोदेस राजा के समर्थकां ताहीं उसकै धोरै भेज्या। ");
INSERT INTO bgc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","उननै आकै यीशु तै कह्या, “हे गुरु, हमनै बेरा सै, के तू साच्चा सै, अर किसे की परवाह न्ही करदा, क्यूँके तू माणसां का मुँह देखकै बात कोनी करदा, पर परमेसवर की बातें सच्चाई तै सिखावै सै। तो के कैसर ताहीं कर देणा ठीक सै या कोनी? ");
INSERT INTO bgc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","हम देवां, या न्ही देवां?” उसनै उनका कपट जाणकै उनतै कह्या, “मन्नै क्यांतै परखो सो? एक दीनार (एक दिन की मजदूरी) मेरै धोरै ल्याओ, के मै उसनै देक्खूँ।” ");
INSERT INTO bgc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","वे लियाए, अर उसनै उनतै कह्या, “या छाप अर नाम किसका सै?” उननै कह्या, “कैसर का।” ");
INSERT INTO bgc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","यीशु नै उनतै कह्या, “जो कैसर का सै वो कैसर ताहीं, अर जो परमेसवर का सै परमेसवर ताहीं द्यो।” फेर वे उसपै घणे हैरान होण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","फेर सदूकी लोग भी, जो कहवै सै के मरे होए जिन्दा होए न्ही सकदे; उसकै धोरै आकै उसतै बुझ्झया, ");
INSERT INTO bgc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“हे गुरु, मूसा नबी नै म्हारै खात्तर पवित्र ग्रन्थ म्ह लिख्या सै के जै किसे का भाई बेऊलादा मर जावै अर उसकी घरआळी रह जावै, तो उसका भाई उसकी घरआळी तै ब्याह कर लेवै अर अपणे भाई खात्तर पीढ़ी पैदा करै। ");
INSERT INTO bgc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","उदाहरण के तौर पै सात भाई थे। पैहल्ड़ा भाई ब्याह करकै बेऊलादा मरग्या। ");
INSERT INTO bgc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","फेर दुसरे भाई नै उसकी बिरबान्नी तै ब्याह कर लिया अर वो भी बेऊलादा मरग्या; अर उस्से तरियां तीसरे नै भी करया। ");
INSERT INTO bgc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","अर सातुवां कै ऊलाद कोनी होई। सारया पाच्छै वा बिरबान्नी भी मरगी। ");
INSERT INTO bgc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","आखर म्ह जिन्दा होण पै वा उन म्ह तै किसकी घरआळी होवैगी? क्यूँके वा सातुवां की घरआळी हो ली थी।” ");
INSERT INTO bgc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीशु नै उनतै कह्या, “थारी गलती या सै के थम पवित्र ग्रन्थ अर परमेसवर की सामर्थ नै न्ही जाणते। ");
INSERT INTO bgc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","क्यूँके जी उठण कै बाद ब्याह शादी कोनी होन्दी, पर सुर्ग म्ह वो परमेसवर के सुर्गदूत्तां की ढाळ होवैगें। ");
INSERT INTO bgc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरे होया कै जिन्दा होण कै बारें म्ह के थमनै मूसा नबी की किताब म्ह जळती होई झाड़ी की कथा म्ह कोनी पढ़्या के परमेसवर नै उसतै कह्या, ‘मै अब्राहम का परमेसवर, अर इसहाक का परमेसवर, अर याकूब का परमेसवर सूं’? ");
INSERT INTO bgc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","परमेसवर मरे होया का न्ही बल्के जिन्दयां का परमेसवर सै; थम बड्डी भूल म्ह पड़े सो।” ");
INSERT INTO bgc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","शास्त्री समाज के माणसां म्ह तै एक नै आकै उन ताहीं बहस करदे सुण्या, अर न्यू जाणकै उसनै उन ताहीं ठीक ढाळ तै जवाब दिया, अर उसतै बुझ्झया, “सारया तै खास हुकम कौण सा सै?” ");
INSERT INTO bgc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीशु नै उस ताहीं जवाब दिया, “सारे हुकमां म्ह तै यो खास सै: ‘हे इस्राएल के माणसों सुणो! प्रभु म्हारा परमेसवर सिर्फ एक ही प्रभु सै, ");
INSERT INTO bgc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","अर तू प्रभु अपणे परमेसवर तै अपणे सारे मन तै, अर अपणे सारे प्राण तै, अर अपणी सारी समझ तै, अर अपणी सारी शक्ति तै प्यार राखणा।’ ");
INSERT INTO bgc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","अर दुसरा यो सै, ‘तू अपणे पड़ोसी तै अपणे जिसा प्यार राखणा।’ इसतै बड्ड़ा और कोए हुकम कोनी।” ");
INSERT INTO bgc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","शास्त्री नै उसतै कह्या, “हे गुरु, जमा ठीक! तन्नै साच्ची कही के परमेसवर एक-ए सै, अर उस ताहीं छोड़कै और कोए कोनी। ");
INSERT INTO bgc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","अर उसतै सारे मन तै, अर सारे प्राण तै, अर सारी समझ तै, अर सारी शक्ति तै प्यार राखणा; अर पड़ोसी तै अपणे जिसा प्यार राखणा, ये दोन्नु हुकम होमबलियाँ अर बलिदानां तै बाध सै।” ");
INSERT INTO bgc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","जिब यीशु नै देख्या के उसनै समझदारी तै जवाब दिया, तो उसतै कह्या, “तू परमेसवर कै राज्य तै दूर कोनी।” अर किसे नै फेर उसतै बुझ्झण की हिम्मत कोनी होई। ");
INSERT INTO bgc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","फेर यीशु नै मन्दर म्ह उपदेश देन्दे होए न्यू कह्या, “शास्त्री क्यूँ कहवै सै के मसीह दाऊद का बेट्टा सै? ");
INSERT INTO bgc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","क्यूँके दाऊद नै खुद ए पवित्र आत्मा म्ह होकै कह्या सै, ‘परमेसवर यहोवा नै मेरै प्रभु तै कह्या, “मेरै सोळी ओड़ बैठ, जिब ताहीं के मै तेरे बैरियाँ नै हरा कै, तेरे पायां की चौक्की न्ही बणा दियुँ।”’ ");
INSERT INTO bgc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“दाऊद तो खुद ए उसनै प्रभु कहवै सै, फेर वो उसका बेट्टा किस ढाळ होया?” अर भीड़ के माणस उसकी राज्जी होकै सुणै थे। ");
INSERT INTO bgc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","यीशु नै अपणे उपदेश म्ह उनतै कह्या, “शास्त्रियाँ तै चौकन्ने रहियो, जो लाम्बे-लाम्बे चोगे पहरे होड़ हाँडै अर बजारां म्ह नमस्कार चाहवैं सै, ");
INSERT INTO bgc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","अर आराधनालयाँ म्ह खास-खास जगहां बैठणा, जिम्मण म्ह खास-खास जगहां भी चाहवैं सै। ");
INSERT INTO bgc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","वे बिधवायाँ के घर खा जावै सै अर दिखाण खात्तर घणी वार ताहीं प्रार्थना करदे रहवै सै। ये घणा दण्ड पावैगें।” ");
INSERT INTO bgc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","यीशु मन्दर कै भण्डार कै स्याम्ही बैठकै देक्खै था के आदमी मन्दर कै दानपात्र म्ह किस तरियां पईसे घालैं सै; अर घणखरे साहूकारां नै घणाए कुछ घाल्या। ");
INSERT INTO bgc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","इतनै म्ह एक कंगाल बिधवा नै आकै दो दमड़ी घाल्लीं। (जो एक धेले कै बराबर होवै सै) ");
INSERT INTO bgc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","फेर उसनै अपणे चेल्यां ताहीं धोरै बुलाकै कह्या, “मै थमनै सच कहूँ सूं के मन्दर कै दानपात्र म्ह घाल्लण आळा म्ह तै इस कंगाल बिधवा नै सारया तै बाध घाल्या सै; ");
INSERT INTO bgc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","क्यूँके सारया नै अपणे धन की बढ़दी म्ह तै घाल्या सै, पर इसनै अपणी घटदी म्ह तै जो उसकै धोरै जीवन चलाण खात्तर था, वो सारा घाल दिया।” ");
INSERT INTO bgc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जिब यीशु मन्दर तै लिकड़ै था, तो उसकै चेल्यां म्ह तै एक नै उसतै कह्या, “हे गुरु, लखा, किसे बड़े-बड़े पत्थरां तै बणाये होए किसे सुथरे भवन सै!” ");
INSERT INTO bgc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीशु नै उनतै कह्या, “के थम ये बड़े-बड़े पत्थरां के भवन देक्खो सो: पर उरै एक पत्थर भी कोनी बचैगा जो गेरया न्ही जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","जिब यीशु मन्दर कै स्याम्ही जैतून कै पहाड़ पै बेठ्या था, तो पतरस, याकूब, यूहन्ना अर अन्द्रियास नै न्यारे जाकै उसतै बुझ्झया, ");
INSERT INTO bgc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“हमनै बता के ये बात कद होवैगी? अर जिब ये सारी बात पूरी होण पै होवैगी उस बखत की के निशान्नी होवैगी?” ");
INSERT INTO bgc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","यीशु उनतै कहण लाग्या, “चौकन्ने रहियो के कोए थमनै भकावै न्ही। ");
INSERT INTO bgc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","क्यूँके घणखरे मेरै नाम तै आकै कहवैगें, ‘मै मसीह सूं!’ अर घणाए नै भकावैगें। ");
INSERT INTO bgc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जिब थम रोळे, अर लड़ाईया का जिक्र सुणो, तो घबराईयो ना; क्यूँके इनका होणा जरूरी सै, पर उस बखत खात्मा कोनी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","क्यूँके जात पै जात, राज्य पै राज्य चढ़ाई करैगा। भोत सारी जगहां पै हाल्लण आवैगें, अर अकाळ पड़ैंगें, ये तो दुखां की शरुआत ए होवैगी।” ");
INSERT INTO bgc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“पर थम अपणे बारै म्ह चौकन्ने रहो; क्यूँके माणस थारे ताहीं बड्डी सभा म्ह सौपैगें अर थम आराधनालयों म्ह छितोगे, अर मेरै कारण हाकिमां अर राजां कै आग्गै खड़े करे जाओगे, ताके थम मेरे बारें म्ह गवाही दे सको। ");
INSERT INTO bgc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","पर जरूरी सै के पैहल्या सुसमाचार सारी जात्तां म्ह प्रचार करया जावै। ");
INSERT INTO bgc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","जिब वे थमनै ले जाकै सौपैगें, तो पैहल्या तै फिक्र ना करियो इब हम के कहवागें; पर जो कुछ थमनै उस बखत बताया जावै वोए कहियो; क्यूँके बोल्लण आळे थम कोनी सो, पर पवित्र आत्मा सै।” ");
INSERT INTO bgc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“भाई नै भाई, पिता नै बेट्टा मारण खात्तर सौंप देंगें, अर बाळक माँ-बाप कै बिरोध म्ह खड़े होकै उन ताहीं मरवा देवैगें। ");
INSERT INTO bgc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","अर मेरै नाम कै कारण सारे माणस थारे तै बैर करैगें; पर जो आखर ताहीं धीरज धरैगा, उस्से का उद्धार होवैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(पढ़ण आळा इस बात नै समझ लेवै) “जिस दिन थम मन्दर म्ह उस उजाड़ण आळी घृणित चीज नै खड़े देक्खो, जिस ताहीं मन्दर म्ह न्ही होणा चाहिये, तब जो यहूदिया परदेस म्ह हो वे पहाड़ां पै भाज जावै; ");
INSERT INTO bgc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जो छात पै हो, वो घर म्ह कुछ लेण खात्तर भीत्त्तर ना जावै, ");
INSERT INTO bgc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","अर जो खेत म्ह हो, वो अपणे लत्तें लेण खात्तर घर नै ना बोहड़ैं। ");
INSERT INTO bgc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","उन दिनां म्ह जो गर्भवती अर दूध पिलान्दी बिरबान्नी होवैगीं, उनकै खात्तर भागणा भी मुश्किल होगा! ");
INSERT INTO bgc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","अर प्रार्थना करया करो के यो जाड्यां म्ह न्ही हो। ");
INSERT INTO bgc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","क्यूँके वे दिन इसे क्ळेश के होवैगें के सृष्टि की शरुआत तै, जो परमेसवर नै रचाई सै, इब ताहीं ना तो होए अर ना फेर कदे होवैगें।” ");
INSERT INTO bgc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अर जै प्रभु उन दिनां नै न्ही घटान्दा, तो कोए जीव भी कोनी बचदा; पर उन छाँटे होया कै कारण जिन ताहीं उसनै छाट्या सै, उन दिनां ताहीं घटाया। ");
INSERT INTO bgc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","उस बखत जै कोए थमनै कहवै, देक्खो, मसीह उरै सै, या देक्खो, ओड़ै सै, तो बिश्वास ना करियो; ");
INSERT INTO bgc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","क्यूँके झूठ्ठे मसीह अर झूठ्ठे नबी उठ खड़े होवैगें, अर बड़े-बड़े चमत्कार अर अनोक्खे काम दिखावैगें के जै हो सक्या तो छाँटे होया ताहीं भी भका देवैगें। ");
INSERT INTO bgc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","पर थम चौकन्ने रहियो; देक्खो, मन्नै थारे तै सारी बात बखत तै पैहल्याए बता दी सै। ");
INSERT INTO bgc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","उन दिनां म्ह, उस क्ळेश कै पाच्छै सूरज अन्धेरा हो जावैगा, अर चाँद चाँदणा कोनी देवैगा; ");
INSERT INTO bgc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","अर अकास के तारे पड़ण लागैगें; अर अकास की शक्तियाँ हलाई जावैंगी। ");
INSERT INTO bgc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","फेर मुझ माणस कै बेट्टे नै बड्डी सामर्थ अर महिमा कै गेल्या सब लोग बादळां पै आन्दे देक्खैंगे। ");
INSERT INTO bgc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","उस बखत मै अपणे सुर्गदूत्तां नै भेजकै, धरती कै इस सिरे तै अकास कै उस सिरे ताहीं, च्यारु दिशायां तै अपणे चुणे होए माणसां नै कठ्ठा करुँगा। ");
INSERT INTO bgc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","अंजीर के दरखत तै यो उदाहरण सीक्खो: जिब उसकी डाळी कोमल हो जावै, अर पत्ते लिकड़ण लागैं सै; तो थम जाण ल्यो सो के गर्मी का बखत लोवै सै। ");
INSERT INTO bgc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","इस्से तरियां जिब थम इन बात्तां नै होन्दे देक्खो, तो जाण ल्यो के वो भोत तावळा आण आळा सै। ");
INSERT INTO bgc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","मै थमनै साच्ची कहूँ सूं के जिब ताहीं ये बात न्ही हो लेन्दी, जद ताहीं ये पीढ़ी खतम न्ही होवैंगी। ");
INSERT INTO bgc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","धरती अर अकास टळ जावैंगे, पर मेरी बात कदे न्ही टळैगी। ");
INSERT INTO bgc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“उस दिन या उस बखत कै बारै म्ह कोए न्ही जाण्दा, ना सुर्गदूत अर ना बेट्टा; पर सिर्फ पिता जाणै सै। ");
INSERT INTO bgc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","लखाओ, जागदे अर प्रार्थना करदे रहो; क्यूँके थमनै न्ही बेरा के वो बखत कद आवैगा। ");
INSERT INTO bgc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","मेरे आण का बखत उस माणस के समान सै, जो परदेस जान्दे बखत अपणा घर छोड़ जावै, अर अपणे नौकरां ताहीं हक देवै, अर हरेक नै उसका काम बता देवै, अर पहरेदार ताहीं जागदे रहण का हुकम देवै। ");
INSERT INTO bgc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“इस करकै जागदे रहो, क्यूँके थमनै न्ही बेरा के घर का माल्लिक कद आवैगा, साँझ नै या आध्धी रात नै, या मुर्गे के बाँग देण के बखत या तड़कै ए तड़कै नै। ");
INSERT INTO bgc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","इसा ना हो के वो चाणचक आकै थमनै सोंदे पावै। ");
INSERT INTO bgc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","अर जो मै थमनै कहूँ सूं, वोए सारया नै कहूँ सूं: जागदे रहो!” ");
INSERT INTO bgc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दो दिनां पाच्छै फसह अर अखमीरी रोट्टी का त्यौहार होण आळा था। प्रधान याजक अर शास्त्री इस बात की टाह म्ह थे के यीशु ताहीं किस ढाळ कपट तै पकड़कै मार देवै; ");
INSERT INTO bgc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पर वे कहवै थे, “त्यौहार कै दिन न्ही, कदे इसा ना हो के माणसां म्ह रोळा माच्चै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जिब यीशु बैतनिय्याह नगर म्ह आया, ओड़ै यीशु शमौन नाम के माणस जो कोढ़ तै ठीक होया था, उसके घरां खाणा खाण बेठ्या, तो एक बिरबान्नी संगमरमर कै बरतन म्ह जटामांसी का शुद्ध महँगा खसबूदार तेल लेकै आई, अर बरतन तोड़कै महँगा खसबूदार तेल उसकै सिर पै उंडेल दिया। ");
INSERT INTO bgc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","पर उन म्ह तै कई माणस अपणे मन म्ह बड़बड़ाने लाग्गे, “इस महँगे खसबूदार तेल का क्यांतै सत्यानाश कर दिया? ");
INSERT INTO bgc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","क्यूँके यो महँगा खसबूदार तेल तो तीन सौ दीनार (तीन सौ दिन की मजदूरी) तै भी घणी किम्मत पै बेचकै कंगालां म्ह बांडया जा सकै था।” अर उस बिरबान्नी ताहीं झिड़कण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यीशु नै कह्या, “उस ताहीं छोड़ द्यो; उसनै क्यांतै सताओ सो? उसनै मेरै गेल्या भलाई करी सै। ");
INSERT INTO bgc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","कंगाल थारे गेल्या सारी हाण रहवै सै, अर थम जिब चाहो जद उनतै भलाई कर सको सो; पर मै थारे गेल्या सारी हाण कोनी रहूँगा। ");
INSERT INTO bgc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","जो कुछ वा कर सकी, उसनै करया; उसनै मेरै गाड्डे जाण की त्यारी म्ह पैहला ए महँगा खसबूदार तेल मेरी देह पै उंडेला सै। ");
INSERT INTO bgc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मै थमनै साच्ची कहूँ सूं के सारे दुनिया म्ह जित्त किते भी सुसमाचार प्रचार करया जावैगा, जो उसनै करया वो सदा याद करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","फेर यहूदा इस्करियोती जो बारहा चेल्यां म्ह तै एक था, प्रधान याजकां कै धोरै गया के यीशु ताहीं उनके हाथ पकड़वा देवै। ");
INSERT INTO bgc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","वे न्यू सुणकै राज्जी होगे, अर उस ताहीं रपिये देण खात्तर मानगे; अर वो मौक्का टोह्ण लाग्या के उस ताहीं किसे ढाळ पकड़वाया जावै। ");
INSERT INTO bgc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अखमीरी रोट्टी कै त्यौहार कै पैहल्ड़े दिन, जिसम्ह वे फसह खात्तर मेम्‍ने का बलिदान करै थे, उसके चेल्यां नै उसतै बुझ्झया, “तू कित्त जाणा चाहवै सै के हम जाकै तेरे खात्तर फसह भोज की त्यारी करा?” ");
INSERT INTO bgc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","उसनै अपणे चेल्यां म्ह तै दो ताहीं न्यू कहकै भेज्या, “यरुशलेम नगर म्ह जाओ, अर एक माणस पाणी का पैंढ़ा ठाए होए थमनै मिलैगा, उसकै पाच्छै हो लियो; ");
INSERT INTO bgc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","अर वो जिस घर म्ह जावै, उस घर कै माल्लिक ताहीं कहियो, ‘गुरु कहवै सै के बैठक कित्त सै? जिसम्ह मै अपणे चेल्यां गेल्या फसह भोज खाऊँ।’ ");
INSERT INTO bgc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","वो थमनै एक सजी-सजाई, अर त्यार करी होड़ बड़ी अटारी दिखा देवैगा, ओड़ै म्हारै खात्तर त्यारी करो।” ");
INSERT INTO bgc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","चेल्लें लिकड़कै नगर म्ह आये, अर जिसा यीशु नै उनतै कह्या था, उस्से तरियां पाया; अर फसह का भोज त्यार करया। ");
INSERT INTO bgc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जिब साँझ होई, तो यीशु बारहा चेल्यां कै गेल्या आया। ");
INSERT INTO bgc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","जिब वे बेठ्ठे खाणा खावै थे, तो यीशु नै कह्या, “मै थमनै साच्ची कहूँ सूं के थारे म्ह तै एक, जो मेरै गेल्या खाणा खाण लागरया सै, वो मन्नै धोक्खा देकै पकड़वावैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","उनपै उदासी छाग्यी अर वे एक-एक करकै उसतै कहण लाग्गे, “के वो मै सूं?” ");
INSERT INTO bgc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","उसनै उनतै कह्या, “वो बारहां चेल्यां म्ह तै एक सै, जो मेरै गेल्या थाळी म्ह हाथ घालै सै। ");
INSERT INTO bgc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","क्यूँके मै माणस का बेट्टा तो, जिसा मेरे बारै म्ह पवित्र ग्रन्थ म्ह लिख्या सै; मेरा मर जाणा तो पक्का सै, पर उस माणस पै धिक्कार सै जिसकै जरिये मै माणस का बेट्टा पकड़वाया जाऊँगा! जै उस माणस का जन्म ए न्ही होंदा, तो उसकै खात्तर भला होंदा।” ");
INSERT INTO bgc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","जिब वे खाण ए लागरे थे, उसनै रोट्टी लेकै परमेसवर का धन्यवाद करया, अर आशीष माँगकै तोड़ी, अर उन ताहीं दी, अर कह्या, “ल्यो, या मेरी देह सै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","फेर यीशु नै अंगूर के रस का कटोरा लेकै परमेसवर का धन्यवाद करया, अर उन ताहीं दिया; अर उन सारया नै उस म्ह तै पिया। ");
INSERT INTO bgc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","अर उसनै उनतै कह्या, “यो अंगूर का रस मेरे लहू नै दर्शावै सै, जिसका करार परमेसवर नै लोग्गां तै करया जो घणाए खात्तर बहाया जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“थमनै साच्ची कहूँ सूं, के अंगूर के रस नै मै इब तै इसनै उस दिन तक न्ही पिऊँगा, जिब ताहीं परमेसवर के राज्य म्ह थारे गेल्या नया रस न्ही पीऊँ।” ");
INSERT INTO bgc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","फेर वे भजन गाकै बाहरणै जैतून कै पहाड़ पै गए। ");
INSERT INTO bgc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","जिब यीशु अर उसके चेल्लें राह म्ह थे, तो उसनै उनतै कह्या, “थम सारे मेरा साथ छोड़कै चले जाओगे,” “क्यूँके पवित्र ग्रन्थ म्ह लिख्या सै:” मै रुखाळे नै मारूँगा, अर झुण्ड की सारी भेड़ तित्तर-बितर हो जावैगी। ");
INSERT INTO bgc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","पर मै अपणे जी उठण कै बाद थारे तै पैहल्या गलील परदेस म्ह मिलूगाँ। ");
INSERT INTO bgc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पतरस नै उसतै कह्या, “जै सारे छोड़ै तो छोड़ै, पर मै तेरा साथ कदे न्ही छोड़ूँगा।” ");
INSERT INTO bgc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीशु नै उसतै कह्या, “मै तेरे तै सच कहूँ सूं आज ए इस्से रात नै मुर्गे के दो बर बाँग देण तै पैहल्या, तू तीन बर मेरै बारै म्ह मुकरैगा।” ");
INSERT INTO bgc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पर उसनै और भी पक्के बिश्वास तै कह्या, “जै मन्नै तेरे गेल्या मरणा भी पड़ै, तोभी मै तेरा इन्कार कदे कोनी करुँगा।” इस्से तरियां और सारया चेल्यां नै भी कह्या। ");
INSERT INTO bgc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","फेर यीशु अर उसके चेल्लें गतसमनी नामक बाग म्ह एक जगहां म्ह आए, अर उसनै अपणे चेल्यां तै कह्या, “उरै बेठ्ठे रहो, जिब ताहीं मै प्रार्थना करुँ।” ");
INSERT INTO bgc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","अर वो पतरस, याकूब अर यूहन्ना ताहीं अपणे गेल्या लेग्या; अर घणाए कांल अर दुखी होण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","अर उनतै कह्या, “मेरा मन घणा उदास सै, उरै ताहीं के मै मरण पै सूं: थम उरै ठहरो, अर जागदे रहो।” ");
INSERT INTO bgc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","फेर वो माड़ा आग्गै सरक्या अर धरती पै पड़कै प्रार्थना करण लाग्या के जै हो सकै तो या मुसीबत की घड़ी मेरै पै तै टळ जावै, ");
INSERT INTO bgc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","अर कह्या, “हे अब्बा, हे पिता, तू सारा कुछ कर सकै सै; इस दुख का कटोरे ताहीं मेरै धोरै तै हटा ले: तोभी जिसा मै चाहूँ सूं उसा न्ही, पर जो तू चाहवै सै वोए हो।” ");
INSERT INTO bgc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","फेर यीशु आया अर चेल्यां ताहीं सोन्दे पाकै पतरस तै कह्या, “हे शमौन, तू सोवै सै? के तू एक घड़ी भी कोनी जाग सक्या? ");
INSERT INTO bgc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जागदे रहो अर प्रार्थना करदे रहो के थम इम्तिहान म्ह ना पड़ो। इस म्ह कोए शक कोनी के आत्मा तो त्यार सै, पर देह कमजोर सै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","अर यीशु फेर चल्या गया अर दोबारा भी वाए प्रार्थना करी। ");
INSERT INTO bgc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","फेर आकै उन ताहीं सोन्दे पाया, क्यूँके चेल्यां की आँख नींद तै भरी थी; अर न्ही जाणै थे, के उसनै के जवाब देवै। ");
INSERT INTO bgc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","फेर तीसरी बर आकै उनतै कह्या, “थम इब भी सोण लागरे सोण सों? बखत आ लिया; देक्खो, मै माणस का बेट्टा पापियाँ के हाथ्थां पकड़वाया जाऊँ सूं। ");
INSERT INTO bgc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठो, चाल्लां! लखाओ, मेरा पकड़वाण आळा लोवै आण पोंहच्या सै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","यीशु न्यू कहण ए लागरया था के यहूदा जो बारहा चेल्यां म्ह तै एक था, अपणे गेल्या प्रधान याजकां अर शास्त्रियाँ अर यहूदी अगुवां की ओड़ तै एक बड्डी भीड़ लेकै जिब्बे आण पोंहच्या, जो तलवार अर लाठ्ठी लेरे थे। ");
INSERT INTO bgc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","यीशु कै पकड़वाण आळे नै उन ताहीं यो इशारा दिया था के जिस ताहीं मै चुमूँ वोए यीशु होगा, उस ताहीं पकड़कै सावधानी तै ले जाईयो। ");
INSERT INTO bgc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","वो आया, अर जिब्बे उसकै धोरै जाकै बोल्या, “हे गुरु!” अर उस ताहीं चुम्या। ");
INSERT INTO bgc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","फेर उननै उसपै हाथ गेर कै उस ताहीं पकड़ लिया। ");
INSERT INTO bgc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","उन बारहा चेल्यां म्ह जो धोरै खड़े थे, एक नै तलवार खिंचकै महायाजक के नौक्कर पै चलाई, अर उसका कान उड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीशु नै उनतै कह्या, “के थम डाकू जाणकै मन्नै पकड़ण कै खात्तर तलवार अर लाठ्ठी लेकै लिकड़े सो? ");
INSERT INTO bgc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मै तो हरेक दिन मन्दर म्ह थारे गेल्या रहकै उपदेश दिया करुँ था, अर जिब थमनै मेरै ताहीं कोनी पकड्या: पर न्यू ज्यांतै होया सै के पवित्र ग्रन्थ म्ह लिखी बात पूरी होवै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","यो सब देखकै सारे चेल्लें उसनै छोड़कै भाजगे। ");
INSERT INTO bgc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","एक जवान अपणी उघाड़ी देह पै चाद्दर ओढ़े होड़ उसकै पाच्छै हो लिया, अर माणसां नै उस ताहीं पकड्या। ");
INSERT INTO bgc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पर वो चाद्दर छोड़कै उघाड़ा भाजग्या। ");
INSERT INTO bgc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","फेर वे यीशु ताहीं महायाजक कै धोरै लेगे, अर सारे प्रधान याजक, यहूदी अगुवें अर शास्त्री उसकै ओड़ै कठ्ठे होगे। ");
INSERT INTO bgc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस दूर ए दूर उसकै पाच्छै-पाच्छै महायाजक कै आँगण कै भीत्त्तर ताहीं गया, अर सिपाहियाँ कै गेल्या बैठकै आग पै सीकण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","प्रधान याजक अर यहूदी अगुवां की सभा यीशु ताहीं मारण कै खात्तर उसकै बिरोध म्ह गवाही की टोह् म्ह थे, पर कोन्या मिली। ");
INSERT INTO bgc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","क्यूँके घणखरे उसकै बिरोध म्ह झूठ्ठी गवाही देवै थे, पर उनकी गवाही एक सी कोनी थी। ");
INSERT INTO bgc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","फेर कुछ माणसां नै उठकै यीशु कै बिरोध म्ह या झूठ्ठी गवाही दी, ");
INSERT INTO bgc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“हमनै इस ताहीं कहन्दे सुण्या सै, ‘मै इस हाथ कै बणाए होड़ मन्दर नै गेर दियुँगा, अर तीन दिन म्ह दुसरा बणाऊँगा, जो हाथ्थां तै न्ही बण्या हो।’” ");
INSERT INTO bgc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","इस बात म्ह भी उनकी गवाही एक सी कोनी लिकड़ी। ");
INSERT INTO bgc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","फेर महायाजक नै बिचाळै खड़े होकै यीशु तै बुझ्झया, “तू कोए जवाब न्ही देंदा? ये माणस तेरे बिरोध म्ह के गवाही देवैं सै?” ");
INSERT INTO bgc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","पर वो बोल-बाल्ला रहया, अर कुछ जवाब न्ही दिया। महायाजक नै उसतै दुबारा बुझ्झया, “के तू ए परम धन्य परमेसवर का बेट्टा मसीह सै?” ");
INSERT INTO bgc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीशु नै कह्या, “हाँ मै ए सूं: अर थम मुझ माणस के बेट्टे ताहीं सर्वशक्तिमान परमेसवर की सोळी ओड़ बेठ्ठे, अर अकास के बादळां कै गेल्या आन्दे देक्खोगे।” ");
INSERT INTO bgc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","फेर महायाजक नै अपणे लत्ते पाड़कै कह्या, “इब हमनै गवाह की और के जरूरत सै?” ");
INSERT INTO bgc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","थमनै या बुराई सुणी। थारी के राय सै? उन सारया नै कह्या के यो मारण कै जोग्गा सै। ");
INSERT INTO bgc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","फेर कई तो उसपै थूकते, अर कई उसका मुँह ढकते होए, कई उसकै घुस्से मारते होए उसतै कहण लाग्गे, जै तू नबी सै, “तो भविष्यवाणी कर!” के तेरे कौण मारै सै, अर सिपाहियाँ नै उस ताहीं पकड़कै थप्पड़ मारे। ");
INSERT INTO bgc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जिब पतरस तळै आँगण म्ह था, तो महायाजक की नौकराणियाँ म्ह तै एक उड़ै आई, ");
INSERT INTO bgc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","अर पतरस ताहीं आग सिक्दे देखकै उस ताहीं गौर तै देख्या अर कहण लाग्गी, “तू भी तो उस नासरत के यीशु कै गेल्या था।” ");
INSERT INTO bgc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","पतरस मुकरग्या, अर बोल्या, “मै ना ए जाण्दा अर ना ए समझू सूं के तू के कहवै सै।” फेर वो बाहरणै देहळीया म्ह गया; अर मुर्गे नै बाँग दी। ");
INSERT INTO bgc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","वा नौकराणी उसनै ओड़ै देखकै उनतै जो धोरै खड़े थे, दुबारा कहण लाग्गी, “यो उन म्ह तै एक सै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पर वो फेर मुकरग्या। माड़ी बार पाच्छै उननै जो धोरै खड़े थे फेर पतरस ताहीं कह्या, “पक्का तू उन म्ह तै एक सै, क्यूँके तू गलीली भी सै।” ");
INSERT INTO bgc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","फेर वो धिक्कारण अर कसम खाण लाग्या, “मै उस माणस नै, जिसका थम जिक्र करो सो, कोनी जाण्दा।” ");
INSERT INTO bgc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","फेर जिब्बे दुसरी बार मुर्गे नै बाँग देई। पतरस ताहीं वाए बात जो यीशु नै उसतै कही थी याद आई “मुर्गे कै दो बर बाँग देण तै पैहल्या तू तीन बार मेरा इन्कार करैगा।” अर वो इस बात नै सोचकै फूट-फूटकै रोण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","सबेरा होन्दे जिब्बे सारे प्रधान याजकां, यहूदी अगुवां अर शास्त्रियाँ नै बल्के यहूदी अगुवां की सभा नै सलाह करकै यीशु ताहीं बंधवाया, अर उस ताहीं ले जाकै यहूदिया परदेस के हाकिम पिलातुस कै हाथ्थां म्ह सौप दिया। ");
INSERT INTO bgc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातुस नै यीशु तै बुझ्झया, “के तू यहूदियाँ का राजा सै?” उसनै उस ताहीं जवाब दिया, “तू आप ए कहण लागरया सै।” ");
INSERT INTO bgc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","प्रधान याजक यीशु पै घणी बात्तां के इल्जाम लावै थे। ");
INSERT INTO bgc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुस नै उसतै फेर बुझ्झया, “के तू कुछ जवाब कोनी देंदा, लखा, ये तेरे पै कितनी बात्तां के इल्जाम लावै सै?” ");
INSERT INTO bgc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","यीशु नै फेर कुछ जवाब कोनी दिया; उरै ताहीं के पिलातुस नै घणी हैरानी होई। ");
INSERT INTO bgc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","पिलातुस उस त्यौहार म्ह किसे एक कैदी नै जिसनै वे चाहवै थे, उन माणसां खात्तर छोड़ दिया करै था। ");
INSERT INTO bgc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","बरअब्बा नाम का एक माणस उन रोळे करणीया गेल्या कैदी था, जिन नै रोळे म्ह खून करया था। ");
INSERT INTO bgc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","अर भीड़ पिलातुस कै धोरै जाकै उसतै बिनती करण लाग्गी, के जिसा तू म्हारै खात्तर करदा आया सै उस्से तरियां कर। ");
INSERT INTO bgc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलातुस नै उन ताहीं जवाब दिया, “थम के चाह्वो, के मै थारे खात्तर यहूदियाँ के राजा नै छोड़ दियुँ?” ");
INSERT INTO bgc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","क्यूँके पिलातुस जाणै था के प्रधान याजकां नै यीशु ताहीं चाल तै पकड़वाया था। ");
INSERT INTO bgc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पर प्रधान याजकां नै माणसां ताहीं उकसाया के वो यीशु की जगहां बरअब्बा नै छोड़ दे। ");
INSERT INTO bgc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","न्यू सुण पिलातुस नै उनतै फेर बुझ्झया, “तो जिसनै थम यहूदियाँ का राजा कहो सो, उसका मै के करुँ?” ");
INSERT INTO bgc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","वे फेर रुक्के मारण लाग्गे, “उसनै क्रूस पै चढ़ा द्यो!” ");
INSERT INTO bgc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातुस नै उनतै फेर कह्या, “क्यांतै उसनै के बुरा करया सै?” पर वे और भी रुक्के मारण लाग्गे, “उसनै क्रूस पै चढ़ा द्यो!” ");
INSERT INTO bgc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","फेर पिलातुस नै भीड़ ताहीं राज्जी करण की चाहन्ना तै, बरअब्बा ताहीं उनकै खात्तर छोड़ दिया, अर यीशु कै कोरड़े लगवाकै सिपाहियाँ के हाथ म्ह सौप दिया के क्रूस पै चढ़ाया जावै। ");
INSERT INTO bgc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","यीशु ताहीं सिपाही किले कै भीत्त्तर कै आँगण म्ह ले गये जो प्रिटोरियुम कुह्वावै सै, अर सारी पलटन ताहीं बुला ल्याए। ");
INSERT INTO bgc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","फेर सिपाहियाँ नै उसका मजाक उड़ाण खात्तर उस ताहीं बैंजनी लत्ते पिहराए अर काण्डयाँ का मुकुट गूँथकै उसकै सिर पै धरया, ");
INSERT INTO bgc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","अर न्यू कहकै उस ताहीं नमस्कार करण लाग्गे, “हे यहूदियों के राजा, नमस्कार!” ");
INSERT INTO bgc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","वे उसकै सिर पै सरकण्डे मारदे, अर उसपै थूकदे, अर गोड्डे टेक कै उसनै प्रणाम करदे रहे। ");
INSERT INTO bgc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","जिब उननै उसका मजाक उड़ा लिया, तो उसपै तै बैंजनी लत्ते उतारकै उस्से के लत्ते पिहराए; अर फेर उस ताहीं क्रूस पै चढ़ाण कै खात्तर बाहरणै ले गये। ");
INSERT INTO bgc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","सिकन्दर अर रूफुस का पिता शमौन, जो कुरेन परदेस का बसिन्दा था, वो यरुशलेम की ओड़ आण लागरया था; उननै उस ताहीं बेकार म्ह पकड्या ताके यीशु का क्रूस ठाकै ले चाल्लै। ");
INSERT INTO bgc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","वे यीशु ताहीं गुलगुता नामक जगहां पै लियाए, जिसका मतलब खोपड़ी की जगहां सै। ");
INSERT INTO bgc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ओड़ै उस ताहीं सिरका मिल्या होड़ अंगूर का रस देण लाग्गे, पर उसनै कोनी लिया। ");
INSERT INTO bgc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","फेर उननै उस ताहीं क्रूस पै चढ़ाया अर उसकै लत्यां पै पर्ची गेर कै, के किसनै के मिलै, उननै बांड लिये। ");
INSERT INTO bgc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","अर सबेरै के नौ बजे थे, जिब उननै यीशु ताहीं क्रूस पै चढ़ाया। ");
INSERT INTO bgc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","अर उसका दोषपत्र लिखकै क्रूस कै उप्पर लगा दिया के “यहूदियाँ का राजा।” ");
INSERT INTO bgc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","उननै उसकै गेल्या दो डाकू, एक उसकी सोळी अर एक उसकी ओळी ओड़ क्रूस पै चढ़ा दिये। ");
INSERT INTO bgc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(तब पवित्र ग्रन्थ का वो वचन के वो अपराधियाँ गेल्या गिण्या गया, पूरा होया।) ");
INSERT INTO bgc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","अर राह म्ह जाण आळे सिर हला-हल्लाकै अर न्यू कहकै उसकी बेजती करै थे, “वाह! मन्दर के गेरण आळे, अर तीन दिन म्ह बणाण आळे! ");
INSERT INTO bgc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","क्रूस पै तै उतरकै अपणे-आपनै बचाले।” ");
INSERT INTO bgc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","इस्से तरियां तै प्रधान याजक भी, शास्त्रियाँ सुधा, आप्पस म्ह मजाक करकै कहवै थे, “इसनै औरां ताहीं बचाया, पर अपणे-आपनै न्ही बचा सकदा। ");
INSERT INTO bgc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इस्राएल का राजा, मसीह, इब क्रूस पै तै उतर आ, के हम देखकै बिश्वास करया।” अर जो डाकू उसकै गेल्या क्रूस पै चढ़ाए गए थे, वे भी उसकी बेजती करै थे। ");
INSERT INTO bgc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","दोफारी होण पै सारे देश म्ह अँधेरा छाग्या, अर तीन बजे ताहीं रहया। ");
INSERT INTO bgc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","तीन बजे यीशु नै बड़े जोर तै रुक्के मारकै कह्या, “इलोई, इलोई, लमा शबक्तनी?” जिसका मतलब यो सै, “हे मेरे परमेसवर, हे मेरे परमेसवर, तन्नै मेरै ताहीं क्यांतै छोड़ दिया?” ");
INSERT INTO bgc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","जो धोरै खड़े थे, उन म्ह तै कितन्याँ नै न्यू सुणकै कह्या, “लखाओ, वो एलिय्याह ताहीं बुलावै सै।” ");
INSERT INTO bgc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","अर एक नै भाजकै फोम ताहीं सिरके म्ह ड्बोया, अर सरकण्डे पै धरकै उस ताहीं चुसाया अर कह्या, “ठैहर जाओ, देक्खां, एलिय्याह उस ताहीं उतारण खात्तर आवै सै के न्ही।” ");
INSERT INTO bgc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","फेर यीशु नै बड़े जोर तै किल्की मारकै जी दे दिया। ");
INSERT INTO bgc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","अर मन्दर का पड़दा उप्पर तै तळै ताहीं पाटकै दो टुकड़े होग्या। ");
INSERT INTO bgc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","जो सूबेदार उसकै स्याम्ही खड्या था, जिब उस ताहीं इस ढाळ किल्की मारकै जी देन्दे देख्या, तो उसनै कह्या, “साच्चए यो माणस, परमेसवर का बेट्टा था!” ");
INSERT INTO bgc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","कई बिरबान्नी भी दूर तै देक्खै थी: उन म्ह मरियम मगदलीनी, छोट्टे याकूब अर योसेस की माँ मरियम, अर सलोमी थी। ");
INSERT INTO bgc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जिब यीशु गलील परदेस म्ह था, तो ये जनानियाँ जो यीशु की चेल्ली थी, वो उसकी सेवा-पाणी करया करै थी; अर घणखरी बिरबान्नी भी थी, जो उसकै गेल्या यरुशलेम नगर तै आई थी। ");
INSERT INTO bgc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","यो आराम कै दिन का एक दिन पैहले की तैयारी का दिन था, अर इब साँझ हो गयी थी। ");
INSERT INTO bgc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतिया गाम का बासिन्दा यूसुफ आया, जो बड्डी सभा का खास माणस था अर खुद भी परमेसवर कै राज्य की बाट देक्खै था। वो हिम्मत करकै पिलातुस कै धोरै गया अर यीशु की लाश माँगी। ");
INSERT INTO bgc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातुस नै हैरानी होई के वो इतनी तावळी मरग्या, उसनै सूबेदार ताहीं बुलाकै बुझ्झया, “के उस ताहीं मरे होए वार होई सै?” ");
INSERT INTO bgc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","जिब उसनै सूबेदार कै जरिये हालत जाण ली, तो लाश यूसुफ ताहीं दुवा दी। ");
INSERT INTO bgc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","फेर उसनै मलमल की एक चाद्दर मोल ली, अर लाश ताहीं उतारकै उस चाद्दर म्ह लपेटा, अर एक कब्र म्ह जो चट्टान म्ह खोद राक्खी थी धरया, अर कब्र कै बारणै पै एक पत्थर गिरड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मगदलीनी अर योसेस की माँ मरियम देक्खै थी के वो कित्त धरया गया सै। ");
INSERT INTO bgc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जिब आराम का दिन बीतग्या, तो मरियम मगदलीनी, अर याकूब की माँ मरियम, अर सलोमी नै खसबूदार चीज मोल ली, ताके आकै यीशु की लाश पै मळै। ");
INSERT INTO bgc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","हफ्तै के पैहल्ड़े दिन तड़कै ए तड़कै सूरज लिकड़ाए था, वे कब्र पै आई, ");
INSERT INTO bgc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","अर आप्पस म्ह कहवै थी, “म्हारै खात्तर कब्र के दरबाजे पै तै पत्थर कौण गिरड़ावैगा?” ");
INSERT INTO bgc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","जिब उननै कब्र की ओड़ निगांह करी, तो देख्या के पत्थर गिरड़या होया सै! यो घणाए बड्ड़ा था। ");
INSERT INTO bgc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","कब्र कै भीत्त्तर जाकै उननै एक जवान ताहीं धोळे लत्ते पहरे होड़ सोळी ओड़ बेठ्ठे देख्या, अर उननै घणी हैरान होई। ");
INSERT INTO bgc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","उसनै उनतै कह्या, “हैरान मतना होवो, थम यीशु नासरी नै टोह्वो सो, जो क्रूस पै चढ़ाया गया था, वो जिन्दा होग्या सै, अर उरै कोनी; लखाओ, याए वा जगहां सै, जित्त उननै यीशु की लाश ताहीं धरया था। ");
INSERT INTO bgc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","पर थम जाओ, अर उसके चेल्यां अर पतरस ताहीं कहो के वो थारे तै पैहल्या गलील परदेस म्ह जावैगा। जिसा के उसनै थारे तै कह्या था, थम ओड़ैए उसनै देक्खोगे।” ");
INSERT INTO bgc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","अर वे लिकड़कै कब्र तै बाहर भाजग्यी; क्यूँके वे काम्बगी अर उनकै घबराट होगी थी; अर उननै किसे तै कुछ न्ही कह्या, क्यूँके वे डरै थी। ");
INSERT INTO bgc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हफ्तै के पैहल्ड़े दिन सबेर होन्दे यीशु जिन्दा होकै पैहलम-पैहल्या मरियम मगदलीनी ताहीं जिसम्ह तै उसनै सात ओपरी आत्मा काड्डी थी, दिख्या। ");
INSERT INTO bgc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","उसनै जाकै यीशु के साथियाँ ताहीं खबर दी, जो दुख म्ह डूबरे थे, अर रोवै थे। ");
INSERT INTO bgc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","उननै न्यू सुणकै के वो जिन्दा सै, अर मरियम मगदलीनी नै उस ताहीं देख्या सै, उसकी बात का बिश्वास कोनी करा। ");
INSERT INTO bgc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","इसकै बाद यीशु दुसरे रूप म्ह उन म्ह तै दो चेल्यां ताहीं दिख्या, जिब वे गाम कान्ही जावै थे। ");
INSERT INTO bgc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","उननै भी यरुशलेम नगर तै बोहड़कै दुसरयां ताहीं इस बारें म्ह खबर दी, पर उननै उनका भी बिश्वास कोनी करया। ");
INSERT INTO bgc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","पाच्छै यीशु उन ग्यारहां चेल्यां ताहीं भी दिखया, जिब वे खाणा खाण बेठ्ठे थे, अर उनकै अबिश्वास अर मन की कठोरता पै उल्हाणा दिया, क्यूँके जिन नै उसकै जिन्दा होण कै पाच्छै उस ताहीं देख्या था, चेल्यां नै उनका भी बिश्वास कोनी करया था। ");
INSERT INTO bgc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","अर यीशु नै उनतै कह्या, “थम सारी दुनिया म्ह जाकै सारी सृष्टि के माणसां ताहीं सुसमाचार प्रचार करो। ");
INSERT INTO bgc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जो बिश्वास करै अर बपतिस्मा लेवै उस्से का उद्धार होवैगा, पर जो बिश्वास कोनी करैगा वो कसूरवार ठहराया जावैगा; ");
INSERT INTO bgc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","बिश्वास करण आळा म्ह या निशान्नी होवैगी के वे मेरै नाम तै ओपरी आत्मायाँ नै काड्डैगें, नई-नई भाषा बोल्लैगें, ");
INSERT INTO bgc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","साँप नै हाथ्थां म्ह ठा लेवैगें, अर जै वे गलती तै जहर भी पी जावै तोभी उनका कुछ न्ही बिगड़ैगा; वे बिमारां पै हाथ धरैगें, अर वे चंगे हो जावैंगे।” ");
INSERT INTO bgc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","फेर प्रभु यीशु उनतै बात करण कै पाच्छै सुर्ग पै ठा लिया गया, अर परमेसवर कै सोळी ओड़ बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","अर उननै लिकड़कै हरेक जगहां प्रचार करया, अर प्रभु उनकै गेल्या काम करदा रहया, अर उन निशान्नी कै जरिये जो गैल-गैल होवै थे, अर साबित करदा रहया के वचन सच्चा सै। आमीन।");
INSERT INTO bgc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","हे जनाब थियुफिलुस, घणखरयां माणसां नै म्हारै बिचाळै घटी बात्तां का ब्यौरा लिखण की कोशिश करी सै। ");
INSERT INTO bgc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","शरुआत तै ए जो यीशु मसीह की सेवकाई म्ह साथ थे अर वे बाद म्ह वचन के सेवक बणगे, उननै ए आँखां देक्खी बात म्हारे ताहीं बताई। ");
INSERT INTO bgc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","इस करकै हे जनाब थियुफिलुस, मन्नै भी यो ठीक लाग्या के उन सारी बात्तां का सारा हाल शरु तै आच्छी दाहूं परख कै, उननै तेरे खात्तर क्रमानुसार लिखूँ ");
INSERT INTO bgc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","के तू या जाण ले के वो बात जिनकी तन्नै शिक्षा पाई सै, वो सच्ची सै। ");
INSERT INTO bgc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया परदेस कै राजा हेरोदेस कै बखत म्ह अबिय्याह कै टोळ म्ह जकरयाह नाम का एक याजक था, अर उसकी घरआळी का नाम एलीशिबा था, अर दोन्नु हारुन की पीढ़ी के थे। ");
INSERT INTO bgc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","वे दोन्नु परमेसवर कै स्याम्ही धर्मी थे, अर प्रभु कै सारे हुकम अर नियमां पै बेखोट चालण आळे थे। ");
INSERT INTO bgc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","पर उनकै कोए भी ऊलाद कोनी थी, क्यूँके एलीशिबा बाँझ थी, अर वे दोन्नु ए बूढ़े थे। ");
INSERT INTO bgc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","एक दिन मन्दर म्ह जिब याजक के काम की बारी जकरयाह के टोळ की आई, तो वो परमेसवर कै स्याम्ही पूजा करण खात्तर ओड़ै मौजूद था, ");
INSERT INTO bgc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","तो याजकां की रीत कै मुताबिक उसकै नाम की चिट्ठी लिकड़ी के प्रभु कै मन्दर म्ह जाकै धूप जळावै। ");
INSERT INTO bgc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","धूप जळाण कै बखत माणसां की भीड़ बाहरणै आँगण म्ह प्रार्थना करै थी। ");
INSERT INTO bgc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","उस बखत प्रभु का एक सुर्गदूत धूप की वेदी कै सोळी ओड़ खड्या दिख्या। ");
INSERT INTO bgc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","जकरयाह देखकै घबराग्या अर घणा डरग्या। ");
INSERT INTO bgc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पर सुर्गदूत उसतै बोल्या, “हे जकरयाह, डरै ना, क्यूँके परमेसवर नै तेरी प्रार्थना सुणली सै, अर तेरी घरआळी एलीशिबा तेरे खात्तर एक बेट्टा जाम्मैगी, अर तू उसका नाम यूहन्ना धरिये। ");
INSERT INTO bgc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","वो तेरे ताहीं तो आनन्द अर खुशी देवैएगा, साथ म्ह भोत-से माणस भी उसकै जन्म तै राज्जी होवैगें। ");
INSERT INTO bgc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","क्यूँके वो प्रभु कै स्याम्ही घणा महान् होगा, अर उस ताहीं कदे भी मदिरा, नशीली चीज न्ही पीणी सै, अर अपणी माँ की कोख तै ए पवित्र आत्मा तै भर ज्यागा। ");
INSERT INTO bgc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","अर इस्राएल के भोत-से माणसां के मन प्रभु परमेसवर की ओड़ मोड़ देवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","यूहन्ना एलिय्याह नबी की आत्मा अर सामर्थ म्ह भरा होगा, अर वो परमेसवर के राह नै तैयार करैगा, वो माँ-बाप का मन बाळकां की ओड़ मोड़ देवैगा। हुकम ना मानण आळे अधर्मियाँ की सोच नै धर्मियाँ की सोच म्ह बदल देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकरयाह नै सुर्गदूत तै बुझया, “इस बात का मै किस तरियां बिश्वास करुँ? के यो म्हारे गैल होवैगा, क्यूँके मै तो बूढ़ा सूं, अर मेरी घरआळी भी बूढ़ी होरी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","सुर्गदूत नै उसतै जवाब दिया, “मै जिब्राईल सूं, जो परमेसवर कै आग्गै खड्या रहूँ सूं, अर मै तेरे तै बात करण अर सुसमाचार देण खात्तर भेज्या सूं। ");
INSERT INTO bgc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","अर देख जिब ताहीं ये बात पूरी ना हो लेंगी, तू गूँगा रहवैगा अर बोल न्ही पावैगा क्यूँके तन्नै मेरी बात्तां का बिश्वास न्ही करया, जो अपणे बखत पै पूरी होंगी।” ");
INSERT INTO bgc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","बाहर जकरयाह की बाट देक्खण आळे माणस अचम्भे म्ह पड़गे, कै उसनै मन्दर म्ह इतनी वार क्यूँ लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जिब वो बाहर आया, तो उन ताहीं बोल न्ही पाया आखर वो जाणगे कै उसनै मन्दर म्ह कोए दर्शन पाया सै, अर वो उन ताहीं इशारे करदा रह्या, अर गूँगा होग्या। ");
INSERT INTO bgc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जिब उसकी याजकीय सेवा कै दिन पूरे होए, तो वो यरुशलेम नगर नै छोड़ अपणे घरां चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","कई दिनां पाच्छै उसकी घरआळी एलीशिबा गर्भवती होग्यी, अर पाँच महिन्ने तैई अपणे-आप ताहीं ल्हकोए राख्या, ");
INSERT INTO bgc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","उसनै अपणे-आप तै कह्या, प्रभु नै इन दिनां म्ह दया की मेहर करकै मेरै खात्तर इसा करया सै, “के माणसां के बीच म्ह मेरा अपमान दूर हो।” ");
INSERT INTO bgc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","एलीशिबा कै छठा महिन्ना चढ़ रह्या था, परमेसवर की ओड़ तै जिब्राईल सुर्गदूत, गलील परदेस कै नासरत नगर म्ह, ");
INSERT INTO bgc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","एक कुँवारी कै धोरै भेज्या जिसकी सगाई यूसुफ नाम कै दाऊद कै घराने कै एक माणस तै होई थी, उस कुँवारी का नाम मरियम था। ");
INSERT INTO bgc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","जिब्राईल सुर्गदूत नै उसके धोरै आकै कह्या, “आनन्द अर जयजयकार तेरी हो तेरे पै ईश्‍वर का अनुग्रह होया सै! प्रभु तेरे गेल्या सै!” ");
INSERT INTO bgc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","मरियम या बात सुणकै भोत घबरा ग्यी, अर सोच म्ह पड़गी कै इन बात्तां का के मतलब हो सकै सै? ");
INSERT INTO bgc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","सुर्गदूत नै उसतै कह्या, “हे मरियम, डरै ना, क्यूँके परमेसवर का अनुग्रह तेरे पै होया सै। ");
INSERT INTO bgc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","अर देख, तू गर्भवती होगी, अर तेरे एक छोरा पैदा होगा, तू उसका नाम यीशु धरिये। ");
INSERT INTO bgc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","वो महान् होगा अर परमप्रधान का बेट्टा कुह्वावैगा, अर प्रभु परमेसवर उसकै पूर्वज दाऊद का सिंहासन उसनै देवैगा, ");
INSERT INTO bgc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","अर वो इस्राएल कै घराने पै सदा राज करैगा, अर उसकै राज्य का अंत न्ही होगा।” ");
INSERT INTO bgc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम नै सुर्गदूत तै कह्या, “यो किस तरियां होगा। मै तो कुँवारी सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","सुर्गदूत नै उस ताहीं जवाब दिया, “पवित्र आत्मा तेरे पै आवैगा अर परमप्रधान की सामर्थ तेरे पै छाया करैगी, इस खात्तर वो जो बाळक पैदा होण आळा सै, पवित्र अर परमेसवर का बेट्टा कुह्वावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अर सुण, तेरी रिस्तेदार जो एलीशिबा सै उसकै भी बुढ़ापे म्ह बेट्टा होण आळा सै, जो बाँझ कुह्वावै थी यो उसका, छठा महिन्ना सै। ");
INSERT INTO bgc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","क्यूँके परमेसवर खात्तर कुछ भी मुश्किल कोनी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियम नै कह्या, “देख, मै प्रभु की दास्सी सूं, मेरै तै तेरे कहैए वचन कै मुताबिक हो।” फेर सुर्गदूत उसके धोरै तै चल्या ग्या। ");
INSERT INTO bgc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","कई दिनां बाद मरियम ताव्ली तैयार होकै पहाड़ी परदेस के यहूदा नगर म्ह ग्यी, ");
INSERT INTO bgc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","अर जकरयाह कै घर म्ह जाकै एलीशिबा ताहीं नमस्कार करया। ");
INSERT INTO bgc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ज्योए एलीशिबा नै मरियम का नमस्कार सुण्या, त्योंए बाळक उसके पेट म्ह उछळ्या, अर एलीशिबा पवित्र आत्मा तै भरगी। ");
INSERT INTO bgc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","अर उसनै ऊँच्ची आवाज म्ह बोलकै कह्या, “तू बिरबानियाँ म्ह धन्य सै, अर तेरी कोख का फळ धन्य सै! ");
INSERT INTO bgc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","मै खुशनसीब सूं जो प्रभु की माँ मेरै धोरै मिलण खात्तर आई? ");
INSERT INTO bgc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","देख, ज्योए तेरे नमस्कार का बोल मेरै कान्ना म्ह पड्या, त्योंए बाळक मेरै पेट म्ह खुशी तै उछळ पड्या। ");
INSERT INTO bgc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","धन्य सै तू क्यूँके तन्नै बिश्वास करया कै जो बात प्रभु नै तेरे ताहीं कही, वे पूरी होई!” ");
INSERT INTO bgc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","फेर मरियम नै कह्या, “मेरा जी प्रभु की बड़ाई करै सै ");
INSERT INTO bgc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","अर मेरी आत्मा मेरै उद्धार करण आळे परमेसवर तै खुश होई,” ");
INSERT INTO bgc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","“क्यूँके उसनै अपणी दास्सी की लाचारी पै निगांह करी सै, इस खात्तर देक्खो, इब तै सारे युग-युग कै माणस मन्नै धन्य कहवैगें,” ");
INSERT INTO bgc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","“क्यूँके उस शक्तिशाली नै मेरै खात्तर बड़े-बड़े काम करै सै। उसका नाम पवित्र सै,” ");
INSERT INTO bgc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","“अर उसकी दया उनपै, जो उसतै डरै सै, पीढ़ी तै पीढ़ी बणी रहवैं सै।” ");
INSERT INTO bgc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","“उसनै अपणी शक्ति तै बड़े-बड़े काम करै सै, अर जो अपणे-आप म्ह घमण्ड करै थे, उन ताहीं तित्तर-बितर कर दिया।” ");
INSERT INTO bgc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“उसनै शासकां ताहीं उनकै सिंहासनां पै तै गिरा दिया, अर नम्र लोग्गां ताहीं ऊँच्चा उठा दिया।” ");
INSERT INTO bgc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","“उसनै भूख्या ताहीं बढ़िया चिज्जां तै छिकाया सै, अर साहूकारां ताहीं खाल्ली हाथ भेज दिया।” ");
INSERT INTO bgc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","“उसनै अपणे सेवक इस्राएल ताहीं सम्भाल लिया, ताके अपणी उस दया नै याद करै,” ");
INSERT INTO bgc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","“जो उसनै अब्राहम अर उसकी पीढ़ी पै सदा खात्तर दया करण का वादा करया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम करीब तीन महिन्ने उसकै गेल्या रहकै उल्टी अपणे घरां चली ग्यी। ");
INSERT INTO bgc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","फेर एलीशिबा कै दिन पूरे होए अर उसनै बेट्टा जाम्या। ");
INSERT INTO bgc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","उसके पड़ोसी अर रिश्तेदारां नै या सुणकै के प्रभु नै उसपै बड़ी दया करी सै, उसकै गेल्या खुशी मनाई, ");
INSERT INTO bgc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","आठवे दिन वे बाळक का खतना करण ताहीं आये, अर उसका नाम उसकै पिता के नाम पै जकरयाह धरणा चाहवै थे। ");
INSERT INTO bgc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","इस पर उसकी माँ एलीशिबा नै जवाब दिया, “ना, इसका नाम यूहन्ना धरो।” ");
INSERT INTO bgc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","उननै उस ताहीं कह्या, “तेरे रिश्तेदारा म्ह किसे का यो नाम न्ही सै!” ");
INSERT INTO bgc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","फेर उसकै पिता तै इशारा करकै पूच्छया कै तू उसका नाम कै धरणा चाहवै सै? ");
INSERT INTO bgc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","उसनै लिखण की पट्टी पै लिख दिया, “उसका नाम यूहन्ना सै,” अर सारा नै अचम्भा होया। ");
INSERT INTO bgc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","फेर उसकी आवाज बोहड़ आई, अर वो बोल्लण अर परमेसवर का धन्यवाद करण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","उसके लोवै-धोरै कै सब रहण आळे डरगे, अर उन सारी बात्तां की चर्चा यहूदिया परदेस कै सारे पहाड़ी देश म्ह फैलगी, ");
INSERT INTO bgc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","अर सब सुणण आळा नै अपणे-अपणे मन म्ह विचार करकै कह्या, “यो बाळक किसा होगा?” क्यूँके प्रभु की शक्ति उसकै साथ सै। ");
INSERT INTO bgc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","उसका पिता जकरयाह पवित्र आत्मा तै भरग्या, अर भविष्यवाणी करण लाग्या: ");
INSERT INTO bgc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“प्रभु इस्राएल का परमेसवर धन्य सै, क्यूँके उसनै अपणे माणसां पै निगांह करी अर उनका उद्धार करया सै, ");
INSERT INTO bgc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","अर अपणे दास दाऊद कै घराने म्ह म्हारै खात्तर एक शक्तिशाली उद्धारकर्ता ताहीं भेज्या सै, ");
INSERT INTO bgc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(भोत पैहले प्रभु नै अपणे पवित्र नबियाँ कै जरिये यो कह्या था) ");
INSERT INTO bgc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","के वो हमनै दुश्मनां तै बचावैगा अर मेरे तै नफरत करण आळे की ताकत तै भी हमनै बचावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","उसनै कह्या, के वो म्हारै पूर्वजां पै दया करैगा अर अपणे पवित्र करार नै याद राक्खैगा, ");
INSERT INTO bgc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","अर वो करार जो उसनै म्हारै पूर्वज अब्राहम तै करया था, ");
INSERT INTO bgc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","उसनै वादा करया सै, के वो म्हारे दुश्मनां कै हाथ तै हमनै छुड़ावैगा, ");
INSERT INTO bgc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ताके जिन्दगी भर उसकै आग्गै पवित्रता अर धार्मिकता तै बिना डरें उसकी सेवा कर सकां। ");
INSERT INTO bgc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","हे मेरे बेट्टे, तू परमप्रधान का नबी कुह्वावैगा, क्यूँके तू प्रभु का रास्ता त्यार करण कै खात्तर आग्गै-आग्गै चाल्लैगा, ");
INSERT INTO bgc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","तू उसकै माणसां नै उद्धार का ज्ञान देगा, जो पापां की माफी तै मिलै सै। ");
INSERT INTO bgc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","यो म्हारे परमेसवर की उस बड़ी दया तै होगा। जिस तरियां सूरज चमकै सै, उसी तरियां मसीहा भी सुर्ग तै म्हारे धोरै आवैगा ");
INSERT INTO bgc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ताके अन्धेरे अर मौत की छाया म्ह बैठण आळा नै रोशनी दे, वा रोशनी सही राह पै चाल्लण म्ह म्हारी मदद करैगी।” ");
INSERT INTO bgc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","अर बाळक यूहन्ना देह अर आत्मा म्ह मजबूत होन्दा गया, अर इस्राएल के माणसां पै जाहिर होण तै पैहले वो जंगल-बियाबान म्ह रह्या। ");
INSERT INTO bgc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","उन दिनां म्ह औगुस्तुस कैसर की कान्ही तै हुकम लिकड़या के, सारे रोमी साम्राज्य कै माणसां की जनगणना करकै उनके नाम लिक्खे जावै। ");
INSERT INTO bgc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(या पैहली नाम लिखाई उस बखत होई, जिब क्‍विरिनियुस सीरिया परदेस कै इलाके का राज्यपाल था)। ");
INSERT INTO bgc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","सारे माणस नाम लिखाण कै खात्तर अपणे-अपणे पुश्तैनी नगर म्ह गए। ");
INSERT INTO bgc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","आखर यूसुफ भी इस करकै के वो भी दाऊद कै कुण्बे अर पीढ़ी का था, गलील परदेस कै नासरत नगर तै गया, यहूदिया परदेस म्ह दाऊद कै बैतलहम नगर म्ह आया, ");
INSERT INTO bgc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ताके अपणी मंगेतर मरियम कै गेल्या जो गर्भवती थी, उस जनगणना म्ह नाम लिखवावै। ");
INSERT INTO bgc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","उनकै बैतलहम नगर रहन्दे होए उसके जाम्मण के दिन पूरे होए, ");
INSERT INTO bgc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","अर मरियम नै अपणा जेट्ठा छोरा जाम्या अर उस ताहीं लत्ते म्ह लपेटकै खोर म्ह धरया, क्यूँके उनकै खात्तर सराये म्ह जगहां कोनी थी। ");
INSERT INTO bgc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","अर उस देश म्ह कई पाळी थे, जो रात नै मदानां म्ह रहकै अपणी भेड्डां के टोळ की रुखाळ करै थे। ");
INSERT INTO bgc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","अर उस्से रात नै प्रभु का एक सुर्गदूत उनकै धोरै आण खड्या होया, अर प्रभु का प्रताप उसकै उप्पर चमक्या, अर वे घणे डरगे। ");
INSERT INTO bgc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","सुर्गदूत नै उनतै कह्या, “मतना डरो, क्यूँके देक्खों, मै थमनै घणी खुशी की खबर सुणाऊँ सूं, जो सारे माणसां खात्तर होगी, ");
INSERT INTO bgc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","आज दाऊद कै नगर बैतलहम म्ह थारे खात्तर एक उद्धारकर्ता जाम्या सै, अर योए मसीह प्रभु सै। ");
INSERT INTO bgc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","अर उसकी थारे खात्तर या निशान्नी होगी के थम एक बाळक नै लत्ते म्ह लिपट्या होड़ अर खोर म्ह लेट्या होड़ पाओगे।” ");
INSERT INTO bgc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","फेर चाणचक उस सुर्गदूत गेल्या सुर्गदूत्तां का एक टोळ परमेसवर की भगति करदे होए अर न्यू कहन्दे दिख्या, ");
INSERT INTO bgc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“अकास म्ह परमेसवर की महिमा अर धरती पै उन माणसां म्ह जिनतै वो राज्जी सै, शान्ति हो।” ");
INSERT INTO bgc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जिब सुर्गदूत उसकै धोरै तै सुर्ग म्ह चले गए, तो पाळीयाँ नै आप्पस म्ह कह्या, “आओ, हम बैतलहम नगर जाकै या बात जो होई सै, अर जो प्रभु नै म्हारै ताहीं बताई सै, देक्खां।” ");
INSERT INTO bgc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","अर उननै जिब्बे जाकै मरियम अर यूसुफ ताहीं अर खोर म्ह उस बाळक ताहीं लेट्या देख्या। ");
INSERT INTO bgc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","जिब पाळीयाँ नै बाळक ताहीं देख्या तो उननै वे सारी बात जो सुर्गदूत नै इस बाळक कै बाबत उनतै कही थी, यूसुफ अर मरियम ताहीं बताई। ");
INSERT INTO bgc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","अर पाळीयाँ की ये बात सुणकै सारे सुणण आळा नै अचम्भा करया। ");
INSERT INTO bgc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","पर मरियम ये बात अपणे मन म्ह धरकै सोचदी रई। ");
INSERT INTO bgc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","अर जिसा पाळीयाँ ताहीं सुर्गदूत्तां नै कह्या था, सब कुछ उसाए सुणकै अर देखकै, वे परमेसवर की महिमा अर जय-जयकार करदे होए बोहड़गे। ");
INSERT INTO bgc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","जिब आठ दिन पूरे होए अर उसकै खतने का बखत आया, तो उसका नाम यीशु धरया गया, अर यो नाम सुर्गदूत के जरिये, मरियम के गर्भ म्ह आण तै पैहल्या बताया गया था। ");
INSERT INTO bgc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","जिब मूसा नबी कै नियम-कायदा कै मुताबिक मरियम अर यूसुफ कै सूंच्चे होण के दिन पूरे होए, तो वे दोन्नु यीशु नै यरुशलेम नगर के मन्दर म्ह लेगे के प्रभु कै स्याम्ही ल्याए, ");
INSERT INTO bgc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(जिसा के प्रभु के नियम-कायदा म्ह लिख्या होड़ सै: हरेक जेट्ठा बेट्टा प्रभु कै खात्तर पवित्र ठहरैगा।) ");
INSERT INTO bgc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","अर प्रभु कै नियम-कायदा कै वचन कै मुताबिक “एक कबूतर या मोड्डी कै दो बच्चे ल्याकै बलि करै।” ");
INSERT INTO bgc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","उस बखत यरुशलेम नगर म्ह शमौन नाम का एक माणस था। वो धर्मी अर परमेसवर का भगत था, अर वो मसीह की बाट देखण लागरया था, ताके इस्राएल के माणसां नै शान्ति मिलै अर पवित्र आत्मा उसपै था। ");
INSERT INTO bgc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","अर पवित्र आत्मा के जरिये उसपै जाहिर होया था के जिब तक वो प्रभु के मसीह नै देख न्ही लेगा, जद ताहीं मौत नै कोनी देक्खैगा। ");
INSERT INTO bgc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","शमौन आत्मा की अगुवाई तै मन्दर म्ह आया, अर जिब माँ-बाप उस बाळक यीशु ताहीं भीत्त्तर ल्याए, ताके उसकै खात्तर नियम-कायदा के रिवाज कै मुताबिक करै, ");
INSERT INTO bgc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","फेर उसनै बाळक यीशु ताहीं अपणी गोद्दी म्ह लिया अर परमेसवर का धन्यवाद करकै कह्या ");
INSERT INTO bgc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“हे प्रभु माल्लिक, इब तू अपणे दास नै अपणे वचन कै मुताबिक शान्ति तै इब मर जाणदे, ");
INSERT INTO bgc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","क्यूँके मेरी आँखां नै उद्धारकर्ता ताहीं देख लिया सै, ");
INSERT INTO bgc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जिस ताहीं तन्नै सारे देशां के माणसां कै स्याम्ही भेज्या सै, ");
INSERT INTO bgc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ताके वो गैर यहूदियाँ ताहीं चाँदणा देण कै खात्तर उजाळा, अर तेरे अपणे माणस इस्राएल की महिमा हो।” ");
INSERT INTO bgc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","यीशु के माँ-बाप इन बात्तां तै, जो शमौन नै यीशु कै बारें म्ह कही थी, सुणकै अचम्भा करै थे। ");
INSERT INTO bgc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","फेर शमौन नै उन ताहीं आशीर्वाद देकै, उसकी माँ मरियम तै कह्या, “देख, यो बाळक इस्राएल म्ह भोत-से माणसां के पतन अर उत्थान का कारण बणैगा, अर या निशान्नी के रूप म्ह परमेसवर की ओड़ तै भेज्या होया सै, अर भोत सारे लोग उसकै बिरुध बोल्लैगें। ");
INSERT INTO bgc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","इसका नतिज्जा यो होगा के भोत सारे मनां के विचार जाहिर हो जावैंगे, अर एक भोत बड़ा दुख तेरे पै आवैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","अशेर कै गोत म्ह तै हन्नाह नामक फनूएल की बेट्टी एक नबी थी। वा घणी बूढ़ी थी, अर ब्याह होण कै सात साल पाच्छै उसका धणी गुजर ग्या। ");
INSERT INTO bgc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","वा चौरासी साल तै बिधवा थी: अर मन्दर म्ह जाणा कोनी छोड्या करै थी, पर ब्रत अर प्रार्थना कर-करकै रात-दिन भगति करया करै थी। ");
INSERT INTO bgc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","जिब यूसुफ, मरियम अर बाळक यीशु, मन्दर म्ह थे, तो हन्नाह उनकै धोरै आई अर परमेसवर का धन्यवाद करण लाग्गी, अर उसनै उन सारया ताहीं इस बाळक यीशु के बारें म्ह बताया, जो यरुशलेम कै छुटकारै की बाट देक्खै थे। ");
INSERT INTO bgc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","यहूदी नियम-कायदा नै पूरा करण कै बाद यूसुफ अर मरियम गलील परदेस के नासरत नगर म्ह अपणे घरां बोहड़ आये। ");
INSERT INTO bgc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","अर बाळक यीशु बढ़दा, अर मजबूत होन्दा, अर बुद्धि तै भरपूर होंदा गया, अर परमेसवर का अनुग्रह उसपै था। ");
INSERT INTO bgc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","यीशु के माँ-बाप हरेक साल फसह कै त्यौहार म्ह यरुशलेम जाया करै थे। ");
INSERT INTO bgc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जिब यीशु बारहां साल का होया, तो वे त्यौहार की रीति कै मुताबिक यरुशलेम नगर म्ह गए। ");
INSERT INTO bgc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","जिब यीशु के माँ-बाप त्यौहार मनाकै अपणे घरां बोहड़ण लागरे थे, तो बाळक यीशु यरुशलेम म्ह रहग्या, अर इसका उसकै माँ-बाप नै कोनी बेरा था। ");
INSERT INTO bgc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","वे न्यू समझकै के वो दुसरे मुसाफिरां कै गेल्या होगा, एक दिन का सफर पार करगे: अर उस ताहीं अपणे कुण्बे आळा म्ह अर जाण-पिच्छाण आळा म्ह टोह्ण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","पर जिब कोनी मिल्या, टोन्दे-टोन्दे यरुशलेम म्ह दुबारै बोहड़गे, ");
INSERT INTO bgc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","अर तीन दिन कै पाच्छै उननै वो मन्दर के आँगण म्ह उपदेशकां कै बिचाळै बेठ्ठे, उनकी सुणदे अर उनतै सवाल बुझते पाया। ");
INSERT INTO bgc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","जितने उसकी सुणै थे, वे सारे उसकी समझ अर उसके जवाब तै हैरान थे। ");
INSERT INTO bgc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","फेर उसके माँ-बाप उस ताहीं देखकै हैरान होए अर उसकी माँ नै उसतै कह्या, “हे बेट्टे, तन्नै म्हारै गेल्या इसा बरताव क्यातै करया? देख, तेरा बाप अर मै तन्नै ढूँढ़-ढूँढ़के परेशान होरे थे?” ");
INSERT INTO bgc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","उसनै उनतै कह्या, “थम मन्नै क्यातै टोह्वो सो? के बेरा कोनी मन्नै मेरे पिता कै घरां होणा जरूरी सै?” ");
INSERT INTO bgc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पर जो बात उसनै उनतै कही, उननै कोनी समझया। ");
INSERT INTO bgc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","फेर वो उनकै गेल्या गया, अर नासरत म्ह आया, अर उनकै बस म्ह रह्या, अर उसकी माँ नै ये सारी बात अपणे मन म्ह राक्खी। ");
INSERT INTO bgc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","अर यीशु समझ अर कद-काट्ठी म्ह, अर परमेसवर अर माणसां कै अनुग्रह म्ह बढ़दा गया। ");
INSERT INTO bgc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","जिब रोम साम्राज्य म्ह तिबिरियुस कैसर राजा बण्या तो उसके पंद्रहवें साल म्ह जिब चौथाई देश म्ह पुन्तियुस पिलातुस यहूदिया परदेस का राज्यपाल था, अर हेरोदेस गलील परदेस म्ह इतूरैया अर त्रखोनितिस परदेस म्ह उसका भाई फिलिप्पुस राज करै था, अर अबिलेने परदेस म्ह लिसानियास राज करै था ");
INSERT INTO bgc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","अर जिब हन्ना अर कैफा महायाजक थे, उस बखत परमेसवर का वचन जंगल-बियाबान म्ह जकरयाह के बेट्टे यूहन्ना के धोरै पोंहच्या। ");
INSERT INTO bgc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","यूहन्ना यरदन नदी कै लोवै-धोवै के साब्ते परदेस म्ह जाकै, पापां की माफी का प्रचार करण लागग्या, के पाप करणा छोड़ द्यो अर बपतिस्मा ल्यो। ");
INSERT INTO bgc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जिसा यशायाह नबी के कहे होए वचनां की किताब म्ह लिख्या सै: “जंगल-बियाबान म्ह एक रुक्के मारणीये का वचन होरया सै के, प्रभु की राही त्यार करो, उसकी सड़क सीध्धी बणाओ। ");
INSERT INTO bgc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","हरेक घाटी भर दी जावैगी, अर हरेक पहाड़ अर टिल्ला तळै करया जावैगा, अर जो टेढ़ा सै सीध्धा, अर जो ऊँच्चा नीच्चा सै वो बरोब्बर राह बणैगा। ");
INSERT INTO bgc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","अर हरेक माणस परमेसवर के उद्धार नै देक्खैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जो भीड़ की भीड़ उसतै बपतिस्मा लेण नै लिकड़ के आवै थी, उनतै यूहन्ना कहवै था, “हे साँप के सप्पोलों जिसे माणसों, थारे तै कौण बताग्या के परमेसवर के आण आळे छो तै भाग्गो। ");
INSERT INTO bgc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","इस खात्तर जै थमनै सच म्ह पाप करणा छोड़ दिया सै तो यो दिखाण खात्तर भले काम तो करो, अर अपणे-अपणे मन म्ह न्यू मतना सोच्चो के हम अब्राहम के वंश तै सां, क्यूँके मै थमनै कहूँ सूं के परमेसवर इन पत्थरां तै भी अब्राहम कै खात्तर ऊलाद पैदा कर सकै सै। ");
INSERT INTO bgc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","इब कुहाड़ा दरखतां की जड़ पै धरया सै, इस करकै जो-जो दरखत बढ़िया फळ न्ही ल्यांदा, वो काट्या अर आग म्ह झोक्या जावैगा।” इसका मतलब यो सै परमेसवर उन सारया नै दण्ड देवैगा जो पाप करणा न्ही छोड़ते। ");
INSERT INTO bgc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","फेर माणसां नै उसतै बुझया, “तो हम परमेसवर के दण्ड तै बचण खात्तर के करा?” ");
INSERT INTO bgc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","उसनै जवाब दिया, “जिसकै धोरै दो कुड़ते हों, वो उसकै गेल्या जिसकै धोरै न्ही सै उसकै गैल बांड ल्यो अर जिसकै धोरै खाणा हो, वो भी न्यूए करै।” ");
INSERT INTO bgc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","चुंगी लेण आळे भी बपतिस्मा लेण आए, अर उसतै बुझया, “हे गुरु, हम के करा?” ");
INSERT INTO bgc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","उसनै उनतै कह्या, “ईमानदार रहों अर जितना रोमी सरकार नै कर तय करया सै, उसतै ज्यादा ना लियो।” ");
INSERT INTO bgc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","कुछ सिपाहियाँ नै भी उसतै बुझया, “हम के करा?” उसनै उनतै कह्या, “किसे पै जुल्म करकै पईसे ना लियो, अर ना झूठ्ठा इल्जाम लाइयो, अर अपणी तन्खा पै संतोष करियो।” ");
INSERT INTO bgc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जिब माणस मसीहा की आस लगाये होए थे, अर सारे अपणे-अपणे मन म्ह यूहन्ना के बाबत विचार कररे थे, के योए मसीह तो न्ही सै। ");
INSERT INTO bgc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","तो यूहन्ना नै उन सारया तै कह्या, “मै तो थमनै पाणी तै बपतिस्मा दियुँ सूं, पर वो आण आळा सै, जो मेरै तै घणा शक्तिशाली सै, मै तो इस लायक भी कोनी के उसके जूत्याँ के फित्ते खोल सकूँ, वो थमनै पवित्र आत्मा अर आग तै बपतिस्मा देवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","उसका छाज, उसकै हाथ म्ह सै, अर वो अपणा खलिहाण आच्छी तरियां साफ करैगा, अर नाज नै अपणे कोठार (गोदाम) म्ह कठ्ठा करैगा, पर भुरळी ताहीं उस आग म्ह जळावैगा जो कदे बुझै कोनी।” ");
INSERT INTO bgc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","आखर वो घणीए शिक्षा दे-देकै माणसां तै सुसमाचार सुणान्दा रह्या। ");
INSERT INTO bgc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","पर जिब उसनै चौथाई देश म्ह गलील परदेस के राजा हेरोदेस तै उसके भाई फिलिप्पुस की घरआळी हेरोदियास कै बाबत अर सारे बुरे काम्मां कै बाबत जो उसनै करे थे, उल्हाणा दिया, ");
INSERT INTO bgc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","तो हेरोदेस नै उन सारया तै बढ़कै यो बुरा काम भी करया के यूहन्ना ताहीं जेळ म्ह गेर दिया। ");
INSERT INTO bgc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","जिब सारे माणसां नै बपतिस्मा लिया अर यीशु भी बपतिस्मा लेकै प्रार्थना कर रह्या था, तो अकास खुलग्या, ");
INSERT INTO bgc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","अर पवित्र आत्मा शारीरिक रूप म्ह कबूतर की तरियां उसपै उतरया, अर परमेसवर सुर्ग म्ह तै बोल्या “तू मेरा प्यारा बेट्टा सै, मै तेरतै राज्जी सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","जिब यीशु खुद उपदेश देण लागग्या, तो करीबन तीस साल की उम्र का था अर (जिसा समझा जावै सै) यीशु यूसुफ का बेट्टा था, अर यूसुफ एली का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","अर एली मत्तात का बेट्टा था, अर मत्तात लेवी का बेट्टा था, अर लेवी मलकी का बेट्टा था, अर मलकी यन्ना का बेट्टा था, अर यन्ना यूसुफ का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","अर यूसुफ मत्तित्याह का बेट्टा था, अर मत्तित्याह आमोस का बेट्टा था, अर आमोस नहूम का बेट्टा था, अर नहूम असल्याह का बेट्टा था, अर असल्याह नोगह का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","अर नोगह मात का बेट्टा था, अर मात मत्तित्याह का बेट्टा था, अर मत्तित्याह शिमी का बेट्टा था, अर शिमी योसेख का बेट्टा था, अर योसेख योदाह का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","अर योदाह यूहन्ना का बेट्टा था, अर यूहन्ना रेसा का बेट्टा था, अर रेसा जरुब्बाबिल का बेट्टा था, अर जरुब्बाबिल शालतियेल का बेट्टा था, अर शालतियेल नेरी का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","अर नेरी मलकी का बेट्टा था, अर मलकी अद्दी का बेट्टा था, अर अद्दी कोसाम का बेट्टा था, अर कोसाम इलमोदाम का बेट्टा था, अर इलमोदाम एर का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","अर एर येशू का बेट्टा था, अर येशू इलाजार का बेट्टा था, अर इलाजार योरीम का बेट्टा था, अर योरीम मत्तात का बेट्टा था, अर मत्तात लेवी का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","अर लेवी शमौन का बेट्टा था, अर शमौन यहूदा का बेट्टा था, अर यहूदा यूसुफ का बेट्टा था, अर यूसुफ योनान का बेट्टा था, अर योनान इलयाकीम का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","अर इलयाकीम मलेआह का बेट्टा था, अर मलेआह मिन्नाह का बेट्टा था, अर मिन्नाह मत्तता का बेट्टा था, अर मत्तता नातान का बेट्टा था, अर नातान दाऊद का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","अर दाऊद यिशै का बेट्टा था, अर यिशै ओबेद का बेट्टा था, अर ओबेद बोआज का बेट्टा था, अर बोआज सलमोन का बेट्टा था, अर सलमोन नहशोन का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","अर नहशोन अम्मीनादाब का बेट्टा था, अर अम्मीनादाब अरनी का बेट्टा था, अर अरनी हिस्रोन का बेट्टा था, अर हिस्रोन फिरिस का बेट्टा था, अर फिरिस यहूदा का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","अर यहूदा याकूब का बेट्टा था, अर याकूब इसहाक का बेट्टा था, अर इसहाक अब्राहम का बेट्टा था, अर अब्राहम तिरह का बेट्टा था, अर तिरह नाहोर का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","अर नाहोर सरूग का बेट्टा था, अर सरूग रऊ का बेट्टा था, अर रऊ फिलिग का बेट्टा था, अर फिलिग एबिर का बेट्टा था, अर एबिर शिलह का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","अर शिलह केनान का बेट्टा था, अर केनान अरफक्षद का बेट्टा था, अर अरफक्षद शेम का बेट्टा था, अर शेम नूह का बेट्टा था, अर नूह लिमिक का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","अर लिमिक मथूशिलह का बेट्टा था, अर मथूशिलह हनोक का बेट्टा था, अर हनोक यिरिद का बेट्टा था, अर यिरिद महललेल का बेट्टा था, अर महललेल केनान का बेट्टा था, ");
INSERT INTO bgc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","अर केनान एनोश का बेट्टा था, अर एनोश शेत का बेट्टा था, अर शेत आदम का बेट्टा था, अर आदम परमेसवर का बेट्टा था। ");
INSERT INTO bgc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","फेर यीशु पवित्र आत्मा तै भरया होया, यरदन नदी तै बोहड़या, अर चाळीस दिन ताहीं पवित्र आत्मा कै सिखाण तै जंगल-बियाबान म्ह हाण्डदा रहया, ");
INSERT INTO bgc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","उन चाळीस दिनां म्ह शैतान उस ताहीं परखता रहया। उन दिनां म्ह उसनै कुछ न्ही खाया, अर जिब वे दिन पूरे होए, तो उसनै भूख लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","फेर शैतान नै उसतै कह्या, “जै तू परमेसवर का बेट्टा सै, तो साबित करदे, अर इस पत्थर तै कह, के रोट्टी बण जावै, ताके तू इननै खा सकै।” ");
INSERT INTO bgc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","यीशु नै उस ताहीं जवाब दिया, “पवित्र ग्रन्थ म्ह लिख्या सै: ‘माणस सिर्फ रोट्टी तै जिन्दा कोनी रहन्दा।’” ");
INSERT INTO bgc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","फेर शैतान उसनै घणे ऊँच्चे पहाड़ पै लेग्या अर उस ताहीं माड़ी वार म्ह दुनिया के राज्य दिखाए, ");
INSERT INTO bgc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","अर उसतै बोल्या, “मै यो सारा हक, अर उसकी शानों-शोकत तन्नै दियुँगा, क्यूँके वो मेरैतै सौंप्या गया सै: अर जिसनै चाहूँ उसनै दे दियुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","इस करकै जै तू मेरी भगति करै, तो यो सब कुछ तेरा हो ज्यागा।” ");
INSERT INTO bgc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीशु नै उस ताहीं जवाब दिया, “लिख्या सै: ‘तू प्रभु अपणे परमेसवर की भगति कर, अर सिर्फ उस्से की भगति कर।’” ");
INSERT INTO bgc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","फेर उसनै उस ताहीं पवित्र नगर यरुशलेम म्ह ले जाकै मन्दर की चोट्टी पै खड्या करया अर उसतै बोल्या, “जै तू परमेसवर का बेट्टा सै, तो अपणे-आपनै उरै तै तळै गेर दे अर अपणे-आपनै साबित करदे।” ");
INSERT INTO bgc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“क्यूँके पवित्र ग्रन्थ म्ह लिख्या सै: ‘वो तेरे बाबत अपणे सुर्गदूत्तां नै हुकम देवैगा, के वे तेरी रुखाळी करै,’” ");
INSERT INTO bgc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“अर वे तन्नै हाथों-हाथ उठा लेवैगें, इसा ना हो के तेरे पायां म्ह पत्थर तै ठेस लाग्गै।” ");
INSERT INTO bgc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीशु नै उस ताहीं जवाब दिया, “पवित्र ग्रन्थ म्ह यो भी लिख्या सै: ‘तू प्रभु अपणे परमेसवर नै ना परखै।’” ");
INSERT INTO bgc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जिब शैतान उस ताहीं परख कै हार लिया, तो कुछ बखत खात्तर उसकै धोरै तै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","फेर यीशु पवित्र आत्मा की सामर्थ तै भरया होड़ गलील परदेस बोहड़या, अर उसकी चर्चा लोवै-धोवै के सारे देशां म्ह फैलगी। ");
INSERT INTO bgc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","वो उनके आराधनालयाँ म्ह उपदेश सुणान्दा रह्या, अर सारे उसकी बड़ाई करै थे। ");
INSERT INTO bgc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","फेर यीशु नासरत नगर म्ह आया, जड़ै पाळा-पोस्या गया था, अर अपणी रीति कै मुताबिक आराम कै दिन आराधनालय म्ह जाकै पवित्रग्रन्थ पढ़ण कै खात्तर खड्या होया। ");
INSERT INTO bgc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","यशायाह नबी की किताब उस ताहीं दी गई, अर उसनै किताब खोल कै, वा जगहां लिकाड़ी जड़ै लिख्या था: ");
INSERT INTO bgc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभु का आत्मा मेरै पै सै, इस करकै के उसनै कंगालां ताहीं सुसमाचार सुणाण कै खात्तर मेरा अभिषेक करया सै, अर मेरै ताहीं इस करकै भेज्या सै के कैदियाँ नै छुड़ाण का अर आंध्याँ नै देखण जोग्गा बणाण की खुशी की खबर का प्रचार करुँ अर कुचले होया नै छुड़ाऊँ, ");
INSERT INTO bgc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","अर प्रभु कै राज्जी रहण कै साल का प्रचार करुँ।” ");
INSERT INTO bgc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","फेर यीशु नै किताब बन्द करकै सेवक कै हाथ्थां म्ह दे दी अर बैठग्या, अर आराधनालय के सारे माणसां की निगांह उसपै थी। ");
INSERT INTO bgc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","फेर वो उनतै कहण लागग्या, “आज ए यो पवित्र ग्रन्थ म्ह लिख्या होड़ वचन थारे स्याम्ही पूरा होया।” ");
INSERT INTO bgc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","सारया नै उस ताहीं सराहया, अर जो अनुग्रह की बात उसकै मुँह तै लिकड़ै थी, उनतै हैरान होए, अर कहण लाग्गे, “के यो यूसुफ का छोरा कोनी?” ");
INSERT INTO bgc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","उसनै उनतै कह्या, “थम मेरै पै या कहावत जरुर कहोगे के ‘हे वैद्य, खुद नै ठीक कर! जो कुछ हमनै सुण्या के कफरनहूम नगर म्ह करया गया सै, उसनै उरै खुद कै नगर म्ह भी कर।’” ");
INSERT INTO bgc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","अर उसनै कह्या, “मै थमनै सच-सच कहूँ सूं कोए नबी अपणे गाम म्ह आदर-मान कोनी पान्दा। ");
INSERT INTO bgc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","मेरी सुणो, के एलिय्याह नबी कै दिनां म्ह जिब साढ़े तीन साल ताहीं अकास तै बारिस न्ही होई, उरै ताहीं के सारे देश म्ह बड्ड़ा अकाळ पड्या, तो इस्राएल देश म्ह घणीए बिधवा थी। ");
INSERT INTO bgc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पर एलिय्याह उन म्ह तै किसे कै धोरै कोनी भेज्या गया, सिर्फ सैदा परदेस कै सारफत नगर म्ह एक बिधवा कै धोरै। ");
INSERT INTO bgc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अर एलीशा नबी कै बखत इस्राएल देश म्ह घणे कोढ़ी थे, पर सीरिया परदेस का सेनापति नामान नामक कोढ़ी नै छोड़कै उन म्ह तै कोए शुद्ध कोनी करया गया।” ");
INSERT INTO bgc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ये बात सुणद-ए जितने आराधनालय म्ह थे, सारया कै छो उठग्या, ");
INSERT INTO bgc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","अर उठकै उस ताहीं नगर तै बाहरणै लिकाड़या, अर जिस पहाड़ पै उनका नगर बसरया था, उसकी चोट्टी पै ले चाल्ले, ताके उसनै उड़ै तै तळै गेरकै मार दें। ");
INSERT INTO bgc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पर यीशु उनकै बिचाळै तै लिकड़कै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","फेर वो गलील परदेस कै कफरनहूम नगर म्ह गया, अर आराम कै दिन माणसां ताहीं उपदेश देवै था। ");
INSERT INTO bgc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","वे उसके उपदेश तै हैरान होगे क्यूँके उसका वचन हक सुधां था। ");
INSERT INTO bgc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","आराधनालय म्ह एक माणस था, जिस म्ह ओपरी आत्मा थी, उसनै जोर तै किल्की मारी, ");
INSERT INTO bgc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“हे नासरत के यीशु, हमनै तेरे तै के काम? के तू म्हारा नाश करण नै आया सै? मै तन्नै जांणु सूं, तू कौण सै? तू परमेसवर की ओड़ तै भेज्या होया पवित्र मसीह सै!” ");
INSERT INTO bgc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीशु नै उसतै धमकाकै कह्या, “चुपचाप रहै, अर इस माणस म्ह तै लिकड़ जा!” फेर ओपरी आत्मा उसनै बिचाळै पटककै बिना नुकसान करे उस म्ह तै लिकड़गी ");
INSERT INTO bgc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","इसपै सारे हैरान होए, अर वे आप्पस म्ह बतळाण लाग्गे, “यो किसा वचन सै? क्यूँके वो हक अर सामर्थ कै गेल्या ओपरी आत्मायाँ नै हुकम देवै सै, अर वे लिकड़ जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","इस करकै चौगरदे नै हरेक जगहां उसका जिक्र होण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","यीशु आराधनालय म्ह तै उठकै शमौन कै घरां गया। शमौन की सास्सू कै बुखार चढ़रया था, अर उननै उस खात्तर उसतै बिनती करी। ");
INSERT INTO bgc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","उसनै उसकै धोरै खड्या होकै बुखार ताहीं धमकाया अर बुखार उतर गया, अर वो जिब्बे उठकै उनकी सेवा-पाणी करण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","सूरज डूबदे बखत, जिन-जिनकै उरै माणस कई ढाळ की बिमारियाँ म्ह पड़े होए थे, वे सारे उननै उसकै धोरै ल्याए, अर उसनै एक-एक पै हाथ धरकै उन ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","अर ओपरी आत्मा भी किल्की मारदी अर न्यू कहन्दी होई के, “तू परमेसवर का बेट्टा सै” घणखरया म्ह तै लिकड़गी। पर वो उननै धमकांदा अर बोल्लण न्ही देवै था, क्यूँके वे जाणै थी के यीशु ए परमेसवर की ओड़ तै भेज्या होया मसीह सै। ");
INSERT INTO bgc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","जिब सबेरै होई तो यीशु लिकड़कै एक बियाबान जगहां म्ह गया, अर भीड़ की भीड़ उसनै टोह्न्दी होई उसकै धोरै आई, अर उसनै रोकण लाग्गी के वो उनकै धोरै तै न्ही जावै। ");
INSERT INTO bgc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पर उसनै उनतै कह्या, “मन्नै दुसरे नगरां म्ह भी परमेसवर कै राज्य का सुसमाचार सुणाणा जरूरी सै, क्यूँके मै इसे खात्तर भेज्या गया सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अर वो गलील परदेस के आराधनालयाँ म्ह उपदेश सुणान्दा रह्या। ");
INSERT INTO bgc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","जिब यीशु गन्नेसरत की झील कै किनारे पै खड्या था, तो भीड़ परमेसवर का वचन सुणण कै खात्तर उस ताहीं घेरे खड़ी थी, तो इसा होया ");
INSERT INTO bgc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","के उसनै झील कै किनारे दो किस्ती लाग्गी होड़ देक्खी, अर मछुआरे उनपै तै उतरकै मच्छियाँ के जाळ नै धोवै थे। ");
INSERT INTO bgc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","उन किस्तियाँ म्ह तै एक पै, जो शमौन की थी, चढ़कै यीशु नै उसतै बिनती करी के किनारे तै माड़ा सा डिगा ले चाल्लै। फेर वो किस्ती पै बैठकै माणसां नै उपदेश देण लागग्या। ");
INSERT INTO bgc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","जिब यीशु नै माणसां तै ये बात कर ली, तो शमौन तै बोल्या, “डुंघ्घे म्ह ले चाल, अर मच्छी पकड़ण खात्तर अपणा जाळ गेर।” ");
INSERT INTO bgc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","शमौन नै उसतै जवाब दिया, “हे गुरु, हमनै सारी रात मेहनत करी अर कुछ न्ही मिल्या, फेरभी तेरे कहण तै जाळ गेरूँगा।” ");
INSERT INTO bgc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जिब पतरस अर उसके साथियाँ नै इसा करया, तो घणी मच्छी घेर ल्याए, अर उनके जाळ पाट्टण नै होण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","इस करकै उननै दुसरी किस्ती म्ह बेठ्ठे अपणे साथियाँ ताहीं भी इशारा करकै मदद खात्तर बुलाया, वे आ ग्ये अर उननै आकै दोन्नु किस्ती उरै ताहीं भर ली के डूबण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","न्यू देखकै शमौन पतरस यीशु कै पायां म्ह पड़ग्या, अर बोल्या, “हे प्रभु, मेरै धोरै तै जा, क्यूँके मै पापी माणस सूं!” ");
INSERT INTO bgc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","क्यूँके इतनी मच्छियाँ कै पकड़े जाण तै उसनै अर उसके साथियाँ नै घणा अचम्भा होया, ");
INSERT INTO bgc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","अर उस्से तरियां जब्दी के बेट्टे याकूब अर यूहन्ना नै भी, जो शमौन के दुसरे साथी थे, अचम्भा होया। फेर यीशु नै शमौन तै कह्या, “मतना डरो, इब तै मै थमनै माणसां ताहीं कठ्ठे करण आळे बणाऊँगा ताके वो मेरे चेल्लें बणे।” ");
INSERT INTO bgc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","अर वे किस्तियाँ नै किनारे पै लियाए अर वे जिब्बे सब कुछ छोड़कै उसके चेल्लें बणण खात्तर उसकै पाच्छै हो लिये।। ");
INSERT INTO bgc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जिब वो किसे नगर म्ह था, तो उड़ै कोढ़ तै भरया होया एक माणस आया, अर उसनै यीशु ताहीं देखकै अर मोध्धा पड़कै बिनती करी, “हे प्रभु, जै तू चाहवै तो मन्नै ठीक कर सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","उसनै हाथ बढ़ाकै उस ताहीं छुया अर बोल्या, “मै चाहूँ सूं, तू इस बीमारी तै ठीक हो ज्या।” अर उसका कोढ़ जिब्बे जान्दा रह्या। ");
INSERT INTO bgc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","फेर उसनै उस ताहीं समझाकै कह्या, “किसे तै ना कहिए, पर जाकै अपणे-आपनै याजक ताहीं दिखा, अर अपणे कोढ़ तै ठीक होण कै बारै म्ह जो कुछ मूसा नबी नै जो पवित्र ग्रन्थ म्ह चढ़ावा बताया सै उसनै चढ़ा, के माणसां खात्तर या गवाही हो, के तू ठीक होग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","पर यीशु का जिक्र हरेक जगहां फैल्दा गया, अर भीड़ की भीड़ उसकी सुणण कै खात्तर अर अपणी बिमारियाँ तै ठीक होण कै खात्तर कठ्ठी होई। ");
INSERT INTO bgc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पर वो सुनसान जगहां म्ह न्यारा जाकै प्रार्थना करया करै था। ");
INSERT INTO bgc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","एक दिन इसा होया के यीशु उपदेश देण लागरया था अर ठीक करण खात्तर प्रभु की सामर्थ उसकै गेल्या थी, अर फरीसी अर शास्त्री उड़ैए बेठ्ठे थे, जो गलील अर यहूदिया परदेस कै हरेक गाम अर यरुशलेम नगर तै आए थे। ");
INSERT INTO bgc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","उस बखत कई माणस एक माणस नै जो लकवे का बीमार था, खाट पै ल्याए, अर वे उसनै भीत्त्तर ले जाण अर यीशु कै स्याम्ही धरण का जुगाड़ टोह्ण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","पर जिब भीड़ कै कारण उसनै भीत्त्तर कोनी ले जा सके तो उननै छात पै चढ़कै अर टाट्टी हटाकै, उस ताहीं बिस्तर समेत बिचाळै यीशु कै स्याम्ही उतार दिया। ");
INSERT INTO bgc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","उसनै उनका बिश्वास देखकै उसतै बोल्या, “हे भाई, मन्नै तेरे पाप माफ कर दिये।” ");
INSERT INTO bgc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","फेर शास्त्री अर फरीसी बहस करण लाग्गे, “यो कौण सै जो परमेसवर की बुराई करै सै? परमेसवर नै छोड़ और कौण पाप माफ कर सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","यीशु नै उनकै मन की बात जाणकै, उनतै कह्या, “थम अपणे मन म्ह क्यूँ विवाद करण लागरे सो की मै परमेसवर की बुराई करुँ सूं? ");
INSERT INTO bgc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","आसान के सै? के यो कहणा के ‘तेरे पाप माफ होए’, या यो कहणा के ‘उठ अर हाँड-फिर’? ");
INSERT INTO bgc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पर इस करकै के थम जाणो, के मुझ माणस कै बेट्टे नै धरती पै पाप माफ करण का भी हक सै।” उसनै उस लकवे के मरीज तै कह्या, “मै तेरे तै कहूँ सूं के अपणे बिस्तर ठाकै अपणे घरां चल्या जा।” ");
INSERT INTO bgc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","वो जिब्बे उनकै स्याम्ही उठ्या, अर जिस खाट पै पड्या था उसनै ठाकै, परमेसवर की बड़ाई करदा होया अपणे घरां चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","फेर सारे हैरान होए अर परमेसवर की बड़ाई करण लाग्गे अर घणे डरकै बोल्ले, “आज हमनै अनोक्खी बात देक्खी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","इसकै बाद यीशु बाहरणै गया अर लेवी नाम के एक चुंगी लेण आळे ताहीं चौकी पै बेठ्ठे देख्या, अर उसतै बोल्या, “मेरा चेल्ला बणण खात्तर मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","फेर वो सारा कुछ छोड़कै उसकै पाच्छै हो लिया। ");
INSERT INTO bgc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","फेर लेवी नै अपणे घरां उसकै खात्तर बड्ड़ा जिम्मण का न्योंदा दिया, अर चुंगी लेण आळे अर दुसरे माणसां की जो उसकै गेल्या खाणा खाण नै बेठ्ठे थे, एक बड्डी भीड़ थी। ");
INSERT INTO bgc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","इसपै फरीसी अर उनके शास्त्री उसके चेल्यां तै न्यू कहकै बिरड़ाण लाग्गे, “थम चुंगी लेण आळे अर जिननै लोग पापी कहवै सै, उनकै गेल्या खाओ-पीओ सो?” ");
INSERT INTO bgc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीशु नै उनतै जवाब दिया, “वैद आच्छे-बिच्छयां खात्तर कोनी, पर बिमारां खात्तर जरूरी सै। ");
INSERT INTO bgc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","मै धर्मियाँ नै न्ही, पर पापियाँ नै मन पलटन कै खात्तर बुलाण आया सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","उननै उसतै कह्या, “यूहन्ना के चेल्लें तो बराबर ब्रत अर प्रार्थना करया करै सै अर उस्से तरियां फरीसियाँ के चेल्लें भी, पर तेरे चेल्लें तो खावै-पीवै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीशु नै उनतै कह्या, “के थम बरातियाँ तै, जिब्बताहीं बन्दड़ा उनकै गेल्या रहवैं, ब्रत करा सको सो?” ");
INSERT INTO bgc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","“पर वे दिन भी आवैगें, जिब बन्दड़ा न्यारा करया जावैगा, फेर वे उन दिनां म्ह ब्रत करैगें।” ");
INSERT INTO bgc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","यीशु नै एक और उदाहरण दिया, “कोए माणस नये लत्यां म्ह तै पाड़कै पुराणे लत्यां पै थेग्ळी न्ही लगान्दा, न्ही तो नया पाट ज्यागा अर वा थेग्ळी पुराणे पै मेळ भी न्ही खावैगी। ");
INSERT INTO bgc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","अर कोए नया अंगूर का रस पुराणी मश्क म्ह न्ही भरदा, न्ही तो नया अंगूर का रस पुराणी मशकां नै पाड़कै बह ज्यागा, अर मश्क फूट ज्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","पर नया अंगूर का रस नई मशकां म्ह भरणा चाहिए। ");
INSERT INTO bgc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोए माणस पुराणा अंगूर का रस पीकै नया अंगूर का रस कोनी चाह्न्दा क्यूँके वो कहवै सै, के पुराणा-ए बढ़िया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","फेर आराम कै दिन यीशु चेल्यां कै गैल खेत्तां म्ह तै होकै जाण लागरया था, अर उसके चेल्लें गेहूँ की बालें तोड़-तोड़कै अर हाथ्थां तै मसळ-मसळ कै खाण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","फेर फरीसियाँ म्ह तै कुछ कहण लाग्गे, “थम यो काम क्यांतै करो सो जो आराम कै दिन करणा ठीक कोनी?” ");
INSERT INTO bgc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीशु नै उनतै जवाब दिया, “के थमनै पवित्र ग्रन्थ म्ह यो न्ही पढ़्या के दाऊद नै, जिब वो अर उसके साथी भूक्खे थे तो के करया? ");
INSERT INTO bgc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","वो किस तरियां परमेसवर कै घर म्ह गया, अर भेंट की रोट्टी खाई, जिनका खाणा याजकां नै छोड़ और किसे खात्तर ठीक कोनी, अर अपणे साथियाँ ताहीं भी दी?” ");
INSERT INTO bgc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","अर उसनै उनतै कह्या, “मै माणस का बेट्टा आराम कै दिन का भी प्रभु सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","इसा होया के किसे और आराम कै दिन वो आराधनालय म्ह जाकै उपदेश देण लाग्या, अर उड़ै एक माणस था जिसका सोळा हाथ सूखरया था। ");
INSERT INTO bgc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","शास्त्री अर फरीसी यीशु पै दोष लाण के मौक्कै की टाह म्ह थे के देक्खै वो आराम कै दिन ठीक करै सै के न्ही। ");
INSERT INTO bgc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","पर वो उनकी सोच जाणै था, इस करकै उसनै सूखे हाथ आळे माणस कह्या, “उठ, बिचाळै खड्या होज्या।” वो उठ खड्या होया। ");
INSERT INTO bgc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","यीशु नै उनतै कह्या, “मै थारे तै बुझ्झु सूं के मूसा के नियम-कायदा कै मुताबिक आराम कै दिन के ठीक सै, भला करणा या बुरा करणा, जान बचाणा या नाश करणा?” ");
INSERT INTO bgc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","फेर उसनै चोगरदेनै उन सारया कान्ही देखकै उस सूखे हाथ आळे माणस तै बोल्या, “अपणा हाथ बढ़ा।” उसनै न्यूए करया, अर उसका हाथ दुबारा ठीक होग्या। ");
INSERT INTO bgc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","पर वे फरीसी अर शास्त्री आप्पे तै बाहर होकै आप्पस म्ह बहस करण लाग्गे के हम यीशु कै गैल के करा? ");
INSERT INTO bgc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","उन दिनां म्ह यीशु पहाड़ पै प्रार्थना करण लागग्या, अर परमेसवर तै प्रार्थना करण म्ह सारी रात बिताई। ");
INSERT INTO bgc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जिब दिन लिकड़या तो उसनै अपणे चेल्यां ताहीं बुलाकै उन म्ह तै बारहां छाँट लिए, अर उन ताहीं प्रेरित कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","अर वे ये सै: शमौन जिसका नाम उसनै पतरस भी धरया, अर उसका भाई अन्द्रियास, अर याकूब, अर यूहन्ना, अर फिलिप्पुस, अर बरतुल्मै, ");
INSERT INTO bgc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","अर मत्ती, अर थोमा, अर हलफई का बेट्टा याकूब, अर शमौन जो जेलोतेस कुह्वावै सै, ");
INSERT INTO bgc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","अर याकूब का बेट्टा यहूदा, अर यहूदा इस्करियोती जो उसका पकड़वाण आळा बण्या। ");
INSERT INTO bgc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","फेर यीशु उनकै गेल्या उतरकै चौरस जगहां म्ह खड्या होया, अर उसके चेल्यां की बड्डी भीड़, अर सारे यहूदिया परदेस अर यरुशलेम नगर, सूर अर सैदा नगर के समुन्दर कै किनारे तै घणे माणस, ");
INSERT INTO bgc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","जो उसकी सुणण अर अपणी बिमारियाँ तै चंगे होण खात्तर उसकै धोरै आए थे, उड़ै थे, अर ओपरी आत्मा तै सताए होए भी ठीक करे जावै थे। ");
INSERT INTO bgc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सारे उसनै छूणा चाहवै थे, क्यूँके उस म्ह तै सामर्थ लिकड़कै सारया नै ठीक करै थी। ");
INSERT INTO bgc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","फेर यीशु नै अपणे चेल्यां कान्ही देखकै कह्या, “धन्य सो थम जो दीन सो, क्यूँके परमेसवर का राज्य थारा सै।” ");
INSERT INTO bgc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","धन्य सो थम जो इब भूक्खे सो, क्यूँके थम परमेसवर के जरिये छिकाए जाओगे। धन्य सो थम जो इब रोओ सो, क्यूँके हांसोगे। ");
INSERT INTO bgc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","धन्य सो थम जिब मुझ माणस कै बेट्टे कै बाबत माणस थारे तै बैर करैगें, अर थमनै लिकाड़ देवैगें, अर थारी बुराई करैगें, अर थारा नाम बुरा जाणकै काट देवैगें। ");
INSERT INTO bgc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","उस दिन आनन्द तै उछळियो, क्यूँके लखाओ, थारे खात्तर सुर्ग म्ह बड्ड़ा ईनाम सै, उनके पूर्वजां नै भी नबियाँ कै गेल्या भी इसाए करया करै थे। ");
INSERT INTO bgc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","पर धिक्कार सै थारे पै! जो साहूकार सो, क्यूँके थमनै अपणे सारे सुख भोग चुके सों। ");
INSERT INTO bgc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","धिक्कार सै थारे पै! जो छिकरे सो, क्यूँके भूक्खे होओगे। धिक्कार सै थारे पै! जो इब हाँस्सो सो, क्यूँके थम बिलख-बिलख कै रोओगे। ");
INSERT INTO bgc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“धिक्कार सै थारे पै! जिब सारे माणस थारे ताहीं आच्छा कहवै, क्यूँके थारे पूर्वज भी झूठ्ठे नबियाँ कै गेल्या भी इसाए करै थे।” ");
INSERT INTO bgc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“पर मै थम सुणण आळा तै कहूँ सूं, के अपणे बैरियाँ तै प्यार राक्खो, जो थारे तै बैर करै, उनका भला करो। ");
INSERT INTO bgc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जो थमनै श्राप देवै, उननै आशीष दो, जो थारी बेजती करै, उनकै खात्तर प्रार्थना करो। ");
INSERT INTO bgc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जो तेरे एक गाल पै थप्पड़ मारै उसकी ओड़ दुसरा भी फेर दे, अर जो तेरी धोत्ती खोस ले, उसनै कुड़ता लेण तै भी मना मत करो। ");
INSERT INTO bgc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जो कोए तेरे तै माँग्गै, उसनै दे, अर जो तेरी चीज खोस ले, उसतै माँग्गै ना। ");
INSERT INTO bgc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","जिसा थम चाहो सो के माणस थारे गेल्या करै, थम भी उनकै गेल्या उसाए करो।” ");
INSERT INTO bgc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“जै थम अपणे प्यार करण आळा तै ए प्यार करो, तो उसका के फायदा? क्यूँके पापी भी अपणे प्यार करण आळा कै गेल्या प्यार करै सै। ");
INSERT INTO bgc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","जै थम अपणे भलाई करण आळा ए गेल्या भलाई करो सों, तो थारी के बड़ाई? क्यूँके पापी भी इसाए करै सै। ");
INSERT INTO bgc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","जै थम उननै ए उधार द्यो सो जिनतै थमनै दुबारै मिल जाण की आस हो सै, तो कौण सी बड़ी बात सै? क्यूँके पापी, पापियाँ नै उधार देवै सै, के उतनाए दुबारै पावै। ");
INSERT INTO bgc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","बल्के अपणे बैरी तै प्यार करो, अर भलाई करो, अर दुबारै मिलण की उम्मीद राखकै उधार ना द्यो, तो थारे खात्तर बड्ड़ा ईनाम होवैगा, अर थम परमप्रधान की ऊलाद मान्ने जाओगे, क्यूँके परमेसवर का धन्यवाद ना करण आळा अर बुरे माणस पै भी दया करै सै। ");
INSERT INTO bgc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","जिसा थारा पिता दयालु सै, उस्से ए ढाळ थम भी दयालु बणो।” ");
INSERT INTO bgc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“दोष ना लाओ, तो थारे पै भी दोष न्ही लगाया जावैगा। कसूरवार ना ठहराओ, तो थमनै भी कोए कसूरवार कोनी ठहरावैगा। माफ कर द्यो, तो थम भी माफ करे जाओगे। ");
INSERT INTO bgc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","दिया करो तो थारे ताहीं भी दिया जावैगा। माणस पूरा नाप दबा दबाकै अर हला-हलाकै अर उभरदा होया थारी गोद्दी म्ह घाल्लैगें, क्यूँके जिस नाप तै थम नाप्पो सों, उस्से नाप तै थारे खात्तर भी नाप्या जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","फेर उसनै उनतै एक उदाहरण कह्या, “के आन्धा, आन्धे नै राह बता सकै सै? के दोन्नु खड्डे म्ह कोनी गिरैगें?” ");
INSERT INTO bgc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","चेल्ला अपणे गुरु तै बड्ड़ा न्ही, पर जो कोए आच्छा सीखा होगा, वो अपणे गुरु के ढाळ होगा। ");
INSERT INTO bgc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“तू क्यूँ अपणे भाई की आँख कै तिन्कै जिसी छोट्टी सी बुराई नै देख्ये सै, अर अपणी आँख म्ह लठ जिसी बड़ी बुराई तन्नै कोनी दिखदी?” ");
INSERT INTO bgc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","जिब तू अपणी ए आँख का लठ कोनी देख्दा, तो अपणे भाई तै किस तरियां कह सकै सै, “हे भाई, आ मै तेरी आँख म्ह तै तिन्का लिकाड़ द्यु?” हे कपटी, पैहल्या अपणी जीवन की बुराई दूर कर फेर तू अपणे भाई नै आच्छी दाऊँ बुराई तै बचा सकैगा। ");
INSERT INTO bgc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“कोए आच्छा दरखत कोनी जो बेकार फळ ल्यावै, अर ना तो कोए बेकार दरखत सै जो आच्छा फळ ल्यावै। ");
INSERT INTO bgc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","हरेक दरखत अपणे फळ तै पिच्छाणा जावै सै, क्यूँके माणस झाड़ियाँ तै अंजीर कोनी तोड़दे अर ना बड़बेरी तै अंगूर। ");
INSERT INTO bgc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","भला माणस अपणे मन के भले भण्डार तै भली बात लिकाड़ै सै, अर बुरा माणस अपणे मन के बुरे भण्डार तै बुराई की बात लिकाड़ै सै, क्यूँके जो मन म्ह भरया सै वोए उसकी जुबान पै आवै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“जिब थम मेरा कहणा न्ही मान्दे तो क्यातै मन्नै ‘हे प्रभु, हे प्रभु’ कहो सो? ");
INSERT INTO bgc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जो कोए मेरै धोरै आवै सै अर मेरी बात्तां नै सुणकै उननै मान्नै सै, मै थमनै बताऊँ सूं के वो किसकी तरियां सै: ");
INSERT INTO bgc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","वो उस माणस की ढाळ सै, जिसनै घर बणादें बखत धरती डून्घी खोदकै चट्टान पर नीम बणाई, अर जिब बाढ़ आई तो धारा उस घर पै लाग्गी पर उसनै हला न्ही सकी, क्यूँके वो पक्का बणरया था। ");
INSERT INTO bgc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","पर जो सुणकै कोनी मान्दा वो उस माणस की ढाळ सै, जिसनै माट्टी पै बिना नीम घर बणाया, जिब उसपै धारा लाग्गी तो वो जिब्बे पड़ग्या अर पड़कै उसका सत्यानाश होग्या।” ");
INSERT INTO bgc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जिब उसनै माणसां तै ये सारी बात कह दी, तो कफरनहूम नगर म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","उड़ै किसे सूबेदार का एक नौक्कर जो उसका प्यारा था, बीमारी तै मरण पै था। ");
INSERT INTO bgc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","उसनै यीशु का जिक्र सुणकै यहूदिया परदेस के कई यहूदी अगुवां ताहीं उसतै या बिनती करण नै उसकै धोरै भेज्या के आकै मेरै नौक्कर नै ठीक करै। ");
INSERT INTO bgc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","वे यीशु कै धोरै आए, अर उसतै घणी बिनती करकै कहण लाग्गे, “वो इस जोग्गा सै के तू उसकै खात्तर न्यू करै, ");
INSERT INTO bgc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","क्यूँके वो म्हारी जात तै प्यार राक्खै सै, अर उस्से नै म्हारे आराधनालय ताहीं बणवाया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीशु उनकै गेल्या गया, पर जिब वो घर तै माड़ी-सी दूर था, तो सूबेदार नै उसके धोरै कई साथियाँ तै न्यू कहवां भेज्या, “हे प्रभु, कांल ना होवै, क्यूँके मै इस लायक कोनी के तू मेरी छात कै तळै आवै। ");
INSERT INTO bgc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","इसे करकै मन्नै खुद ताहीं इस लायक भी कोनी समझा के तेरे धोरै आऊँ, पर सिर्फ मुँह तै कह दे तो मेरा नौक्कर ठीक हो ज्यागा। ");
INSERT INTO bgc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","क्यूँके मै जाणु सूं, के मै भी किसी के आदेशां का पालन करुँ सूं, अर सिपाही मेरै आदेशां का पालन करै सै। जिब मै एक तै कहूँ सूं, जा, तो वो जावै सै, अर दुसरे तै, आ, तो वो आवै सै, अर अपणे नौक्कर तै कहूँ सूं, यो कर, तो वो करै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","यो सुणकै यीशु कै अचम्भा होया अर उसनै मुँह फेरकै उस भीड़ तै जो उसकै गेल्या आवै थी, कह्या, “मै थमनै कहूँ सूं के मन्नै इस्राएल म्ह भी इसा बिश्वास न्ही देख्या।” ");
INSERT INTO bgc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","फेर भेज्जे होए वे माणस जिब घरां बोहड़े तो उननै उस नौक्कर ताहीं निरोग्गी पाया। ");
INSERT INTO bgc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","थोड़े दिनां पाच्छै यीशु नाईन नाम के एक नगर म्ह गया, अर उसके चेल्लें अर बड्डी भीड़ उसकै गेल्या जाण लागरी थी। ");
INSERT INTO bgc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जिब वो नगर कै फाटक कै धोरै पोंहच्या, तो लखाओ, माणस एक मुरदे नै बाहरणै लेकै जावै थे, जो अपणी माँ का एक्ला बेट्टा था, अर वा बिधवा थी, अर नगर के घणखरे माणस उसकै गेल्या थे। ");
INSERT INTO bgc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","बिधवा ताहीं देखकै प्रभु नै उसपै तरस आया, अर उसतै कह्या, “मतना रोवै।” ");
INSERT INTO bgc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","फेर यीशु नै धोरै आकै अर्थी ताहीं छुया, अर अर्थी ठाण आळे ठैहरगे। फेर यीशु नै कह्या, “हे जवान, मै तन्नै कहूँ सूं, उठ!” ");
INSERT INTO bgc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","फेर वो मुर्दा उठ बेठ्या, बोल्लण लाग्या। उसनै उस ताहीं उसकी माँ तै सौंप दिया। ");
INSERT INTO bgc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","इस घटना तै सारे डरगे, अर वे परमेसवर की बड़ाई करकै कहण लाग्गे, “म्हारे बिचाळै एक बड्ड़ा नबी आया सै, अर परमेसवर नै अपणे माणसां पै दया की निगांह करी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","अर उसकै बारै म्ह या बात सारे यहूदिया परदेस अर लोवै-धोवै के सारे परदेसां म्ह फैलगी। ");
INSERT INTO bgc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","यूहन्ना ताहीं उसके चेल्यां नै इन बात्तां की खबर दी। ");
INSERT INTO bgc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","फेर यूहन्ना नै अपणे चेल्यां म्ह तै दोयां ताहीं बुलाकै प्रभु कै धोरै न्यू बुझ्झण खात्तर भेज्या, “के आण आळा तूए सै, या हम किसे और की बाट देक्खां?” ");
INSERT INTO bgc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","उननै उसकै धोरै आकै कह्या, “यूहन्ना बपतिस्मा देणआळे नै म्हारै ताहीं तेरे धोरै न्यू बुझ्झण नै भेज्या सै, के आण आळा वो मसीहा जिसका वादा परमेसवर नै करया था, तू ए सै, या हम किसे और की बाट देक्खां?” ");
INSERT INTO bgc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","उस्से बखत उसनै घणाए ताहीं बिमारियाँ, अर कांल्ली, अर ओपरी आत्मायाँ तै छुटाया, अर घणाए की आँख खोल दी, ");
INSERT INTO bgc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","अर उसनै उनतै कह्या, “जो कुछ थमनै देख्या अर सुण्या सै, जाकै यूहन्ना ताहीं कह द्यो, के आन्धे देक्खैं सै, लंगड़े चाल्लै-फिरै सै, कोढ़ी शुद्ध करे जावै सै, बहरे सुणै सै, मुर्दे जिन्दे करे जावै सै, अर कंगालां ताहीं सुसमाचार सुणाया जावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","धन्य सै वे जो मेरै पै शक न्ही करते, अर बिश्वास करणा न्ही छोड़दे।” ");
INSERT INTO bgc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","जिब यूहन्ना के भेज्जे होड़ माणस चले गये तो यीशु यूहन्ना कै बारै म्ह माणसां तै कहण लागग्या, “थम जंगल-बियाबान म्ह के देखण गये थे? के हवा म्ह हाल्दे होए सरकंडे नै?” ");
INSERT INTO bgc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","तो फेर थम बण म्ह के देखण गये थे? के कोमल लत्ते पहरे होए माणस नै? लखाओ, जो चमकदे लत्ते पहरै अर असो-आराम म्ह रहवैं सै, वे राजघरां म्ह रहवैं सै। ");
INSERT INTO bgc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","तो फेर थम बण म्ह के देखण गये थे? के किसे नबी नै? हाँ, मै थमनै कहूँ सूं, बल्के नबी तै भी बड़े नै। ");
INSERT INTO bgc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","यो वोए सै, जिसकै बारै म्ह लिख्या सै: लखा, “मै अपणे दूत नै तेरे आग्गै-आग्गै भेज्जू सूं, जो तेरे आग्गै तेरी राही सीध्धी करैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“मै थमनै कहूँ सूं के जो बिरबानियाँ तै जणे सै, उन म्ह तै यूहन्ना बपतिस्मा देणआळे तै बड्ड़ा कोए न्ही पर जो परमेसवर कै राज्य म्ह छोट्टे तै छोट्टा सै, वो उसतै भी बड्ड़ा सै।” ");
INSERT INTO bgc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","फेर हरेक किसे नै, उरै ताहीं के चुंगी लेण आळे माणसां नै भी यूहन्ना की बात सुणकै उसतै बपतिस्मा लेकै यो मान लिया के परमेसवर ए धर्मी सै। ");
INSERT INTO bgc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","पर फरीसियाँ अर शास्त्रियाँ नै यूहन्ना तै बपतिस्मा कोनी लेकै परमेसवर कै मनसां ताहीं अपणे बारै म्ह टाळ दिया। ");
INSERT INTO bgc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“पर मै इस युग कै माणसां की बराबरी किसतै करुँ के वे किसकी ढाळ सै?” ");
INSERT INTO bgc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","वे उन बाळकां की ढाळ सै जो बजारां म्ह बेठ्ठे होए एक-दुसरे तै रुक्के मारकै शिकायत करै सै, हमनै थारे खात्तर बाँसली बजाई, अर थम कोनी नाच्चे, हमनै बिलाप करया, अर थम कोनी रोए! ");
INSERT INTO bgc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","क्यूँके यूहन्ना बपतिस्मा देण आळा ना रोट्टी खाया होया करदा अर ना अंगूर का रस पिया होया करदा, अर थम कहो सो, उस म्ह ओपरी आत्मा सै। ");
INSERT INTO bgc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मुझ माणस के बेट्टे का खाण-पान और माणसां की तरियां साद्दा ए सै, लखाओ, थमनै मेरे ताहीं पेट्टू अर पियक्कड़ माणस, चुंगी लेणिये का अर पापियाँ का साथी घोषित कर दिया। ");
INSERT INTO bgc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पर ज्ञान अपणे काम्मां म्ह सच्चा ठहराया गया सै। ");
INSERT INTO bgc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","फेर किसे फरीसी नै उसतै बिनती करी के वो उसकै गेल्या खाणा खावै, आखर वो उस फरीसी कै घरां जाकै खाणा खाण बेठ्या। ");
INSERT INTO bgc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","उस नगर की एक पापण बिरबान्नी न्यू जाणकै के यीशु फरीसी कै घर म्ह खाणा खाण बेठ्या सै, संगमरमर कै बरतन म्ह महँगा खसबूदार तेल ल्याई, ");
INSERT INTO bgc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","अर उसकै पायां कै धोरै, पाच्छै खड़ी होकै, रोंदी होई उसकै पायां नै आसूआं तै भेण लाग्गी अर अपणे सिर कै बाळां तै पूंझण लाग्गी, अर उसके पायां नै बार-बार चूमकै उनपै महँगा खसबूदार तेल मळ्या। ");
INSERT INTO bgc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","न्यू देखकै शमौन फरीसी जिसनै यीशु ताहीं बुलाया था, अपणे मन म्ह सोच्चण लागग्या, “जै यो नबी होन्दा तो जाण जान्दा के या जो उसनै छूण लागरी सै, वा कौण अर किसी बिरबान्नी सै, क्यूँके वा तो पापण सै।” ");
INSERT INTO bgc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","यीशु नै उसके मन के विचार जाणकै उस ताहीं उदाहरण म्ह कह्या, “हे शमौन, मन्नै तेरे तै कुछ कहणा सै।” वो बोल्या, “हे गुरु, कह।” ");
INSERT INTO bgc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","यीशु नै एक और उदाहरण दिया, “किसे साहूकार के दो देणदार थे, एक पाँच सौ अर दुसरा पचास दीनार (50 दिन की मजदूरी) का देणदार था। ");
INSERT INTO bgc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","जिब उनकै धोरै चुकाण नै कुछ न्ही रह्या तो उसनै दोनुआ का कर्ज माफ कर दिया। इस करकै उन दोन्नु माणसां म्ह तै कौण उसतै घणा प्यार राक्खैगा?” ");
INSERT INTO bgc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","शमौन नै जवाब दिया, “मेरी समझ म्ह वो माणस, जिसका घणा कर्जा माफ होया।” यीशु नै उसतै कह्या, “तन्नै ठीक कह्या सै।” ");
INSERT INTO bgc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","अर उस बिरबान्नी कान्ही पलटकै उसनै शमौन तै कह्या, “तन्नै देख्या सै के इस बिरबान्नी नै के करया सै? मै तेरे घरां आया पर तन्नै मेरे पैर धोण नै पाणी भी कोनी दिया, पर इसनै मेरे पैर आँसुआँ तै भेये अर अपणे बाळां तै पूंजे। ");
INSERT INTO bgc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तन्नै मेरै ताहीं चुम्या न्ही, पर जिब तै मै आया सूं जिब्बे तै इसनै मेरे पायां ताहीं चुमना न्ही छोड्या। ");
INSERT INTO bgc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तन्नै मेरे सिर पै तेल कोनी मळ्या, पर इसनै मेरे पायां पै इत्र मळ्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","इस करकै मै तन्नै कहूँ सूं के इसनै कई पाप करे थे, जो माफ होगे, क्यूँके इसनै मेरे तै घणा प्यार करया सै, पर जिसका पाप कम माफ होया सै, वो कम प्यार करै था।” ");
INSERT INTO bgc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","अर उसनै बिरबान्नी तै कह्या, “तेरे पाप माफ होए।” ");
INSERT INTO bgc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","फेर जो माणस उसकै गेल्या खाणा खाण नै बेठ्ठे थे, वे अपणे-अपणे मन म्ह सोच्चण लाग्गे, “यो के परमेसवर सै, जो पापां नै भी माफ कर सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पर उसनै उस बिरबान्नी ताहीं कह्या, “परमेसवर नै तेरे ताहीं बचाया सै, क्यूँके तन्नै मेरे पै बिश्वास करया सै, खुश होकै चली जा।” ");
INSERT INTO bgc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","इसकै बाद यीशु नगर-नगर अर गाम-गाम्मां म्ह प्रचार करदा होया, अर परमेसवर कै राज्य का सुसमाचार सुणादा होया हांडण लाग्या, अर वे बारहां चेल्लें उसकै गेल्या थे, ");
INSERT INTO bgc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","अर कुछ बिरबान्नी भी थी जो ओपरी आत्मायाँ तै अर बिमारियाँ तै छुटाई गई थी, अर वे ये सै: मरियम जो मगदलीनी कुह्वावै थी, जिसम्ह तै सात ओपरी आत्मा लिकड़ी थी, ");
INSERT INTO bgc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","अर हेरोदेस राजा के भण्डारी खुजा की घरआळी योअन्ना, अर सूंसन्नाह, अर घणखरी दुसरी बिरबान्नी। ये अपणे धन तै यीशु अर उसके चेल्यां की सेवा-पाणी करै थी। ");
INSERT INTO bgc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","जिब बड्डी भीड़ कठ्ठी होई अर नगर-नगर के माणस उसकै धोरै चालकै आवै थे, तो उसनै उदाहरण म्ह कह्या ");
INSERT INTO bgc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“एक किसान बीज बोण लिकड़या। बोंदे होए कुछ बीज राही कै किनारे पड़े, अर रोंद्या गया, अर अकास के पंछियाँ नै उस ताहीं चुग लिया। ");
INSERT INTO bgc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","कुछ बीज चट्टान पै पड्या, अर जामग्या, पर नमी ना मिलण कै कारण सूख ग्या। ");
INSERT INTO bgc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कुछ झाड़ियाँ कै बिचाळै पड्या, अर झाड़ियाँ नै गेलै-गेलै बढ़कै उस ताहीं दबा लिया। ");
INSERT INTO bgc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","कुछ आच्छी धरती पै पड्या, अर उगकै सौ गुणा फळ ल्याया।” न्यू कहकै वो जोर तै बोल्या, “जिसके कान हो वो ध्यान तै सुण ले।” ");
INSERT INTO bgc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","उसके चेल्यां नै उसतै बुझ्झया के इस उदाहरण का के मतलब सै? ");
INSERT INTO bgc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","उसनै कह्या, “थारे ताहीं परमेसवर कै राज्य के भेद की समझ दे राक्खी सै, पर औरां नै उदाहरणां म्ह सुणाया जावै सै, इस करकै के ‘वे देखदे होए भी कोनी देक्खै, अर सुणदे होए भी कोनी समझै।’” ");
INSERT INTO bgc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","उदाहरण का मतलब यो सै: बीज परमेसवर का वचन सै ");
INSERT INTO bgc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","राही कै किनारे के वे सै, जिन नै सुण्या, फेर शैतान आकै उनकै मन म्ह तै वचन ठा ले जावै सै के कदे इसा ना हो के वे बिश्वास करकै उद्धार पावै। ");
INSERT INTO bgc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","चट्टान पै के वे सै, के जिब सुणै सै, तो खुश होकै वचन नै अपणावै सै, पर जड़ कोनी पकड़दे वे माड़ी वार ताहीं बिश्वास राक्खैं सै अर मुसीबत कै बखत बहक जावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जो झाड़ियाँ म्ह पड्या, यो वे सै जो सुणै सै, पर आग्गै जाकै फिक्र, अर धन, अर जिन्दगी के ऐसो-आराम म्ह फँस जावै सै अर उनका फळ कोनी पकदा। ");
INSERT INTO bgc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","पर आच्छी धरती के वे सै, जो वचन सुणकै भले अर आच्छे मन तै साम्ये राक्खैं सै, अर धीरज तै फळ ल्यावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“कोए दीवा जळा कै बरतन तै कोनी ढकदा, अर ना खाट तळै धरै सै, पर टांडी पै धरै सै ताके भीत्त्तर आण आळे नै चाँदणा मिलै। ");
INSERT INTO bgc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","कुछ लुहक्या कोनी जो दिखाया कोनी जावै, अर ना किमे लुहक्या सै जिसका बेरा न्ही पटै। ");
INSERT INTO bgc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ज्यांतै चौक्कस रहो के थम किस तरियां सुणो सो? क्यूँके जिसकै धोरै सै उसतै दिया जावैगा, अर जिसकै धोरै न्ही सै उसतै वो भी ले लिया जावैगा, जिसनै वो अपणा समझै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","यीशु की माँ अर उसके भाई उसकै धोरै आए, पर भीड़ कै कारण उसतै मिल न्ही सके ");
INSERT INTO bgc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","उसतै कह्या गया, “तेरी माँ अर तेरे भाई बाहरणै खड़े होए, तेरे तै मिलणा चाहवैं सै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","यीशु नै इसकै जवाब म्ह उनतै कह्या, “मेरी माँ अर मेरे भाई येए सै, जो परमेसवर का वचन सुणै अर मान्नैं सै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","फेर एक दिन वो अर उसके चेल्लें किस्ती पै चढ़े, अर उसनै उनतै कह्या, “आओ, समुन्दर के परली ओड़ चाल्लां।” आखर उननै किस्ती खोल दी। ");
INSERT INTO bgc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","पर जिब किस्ती चालरी थी, तो वो सोग्या अर समुन्दर पै आँधी आगी, अर किस्ती पाणी तै भरण लाग्गी अर वे खतरे म्ह थे। ");
INSERT INTO bgc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","फेर उननै धोरै आकै उस ताहीं जगाया, अर कह्या, “हे माल्लिक! हे माल्लिक! हम डूबके मरण आळे सां।” फेर उसनै उठकै आँधी ताहीं अर पाणी की झाल्लां ताहीं धमकाया अर वे थमगे अर शान्ति होई। ");
INSERT INTO bgc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","फेर उसनै उनतै कह्या, “थारा बिश्वास कित्त था?” पर वे डरगे अर हैरान होकै आप्पस म्ह कहण लाग्गे, “यो कौण सै जो आँधी अर पाणी नै भी हुकम देवै सै, अर वे उसकी मान्नैं सै?” ");
INSERT INTO bgc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","फेर वे गिरासेनियों कै देश म्ह पोहचे, जो उस पार गलील समुन्दर कै स्याम्ही सै। ");
INSERT INTO bgc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","जिब वो किनारे पै उतरया तो उस नगर का एक माणस उसतै मिल्या जिसम्ह ओपरी आत्मा थी। वो घणे दिनां तै उघाड़ा था अर ना घरां रहवैं था बल्के कब्रिस्तान म्ह रह्या करै था। ");
INSERT INTO bgc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","वो यीशु नै देखकै जोर तै किल्की मारकै उसकै स्याम्ही पड़कै जोर तै बोल्या, “हे परमप्रधान परमेसवर के बेट्टे यीशु! मन्नै तेरे तै के काम? मै तेरे तै बिनती करुँ सूं, मन्नै काल ना करै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","क्यूँके वो उस ओपरी आत्मा ताहीं उस माणस म्ह तै लिकड़ण का हुकम देवै था, इस करकै के वो उसपै बार-बार हावी होवै थी। ऊतो माणस उसनै साँकळां अर बेलां तै जुड़ै थे फेरभी वो बन्धनां नै तोड़ देवै था, अर ओपरी आत्मा उसनै बण म्ह भजाए फिरै थी। ");
INSERT INTO bgc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीशु नै उसतै बुझ्झया, “तेरा के नाम सै?” उसनै कह्या, “सेना,” क्यूँके घणीए ओपरी आत्मा उस म्ह रहवैं थी। ");
INSERT INTO bgc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","उननै यीशु बिनती करी के हमनै अथाह कुण्ड म्ह जाण का हुकम ना देवै। ");
INSERT INTO bgc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","उड़ै पहाड़ पै सूअरां का एक बड्ड़ा टोळ चरै था, इस करकै उननै उसतै बिनती करी के हमनै उन म्ह बैठणे दे। उसनै उन ताहीं जाण दिया। ");
INSERT INTO bgc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","फेर ओपरी आत्मा उस माणस म्ह तै लिकड़कै सूअरां म्ह जा पड़ी अर वो टोळ ढळान पै तै झपटकै गलील समुन्दर म्ह जा पड्या अर डूब मरया। ");
INSERT INTO bgc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","पाळी यो जो होया था देखकै भाज्ये, अर नगर म्ह अर गाम्मां म्ह जाकै उसकी खबर दी। ");
INSERT INTO bgc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","माणस जो होया था उसनै देखण नै लिकड़े, अर यीशु कै धोरै आकै जिस माणस तै ओपरी आत्मा लिकड़ी थी, उसनै यीशु के पायां कै धोरै लत्ते पहरे अर सोध्दी म्ह बेठ्ठे देखकै डरगे, ");
INSERT INTO bgc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","अर देखण आळा नै उन ताहीं बताया के वो ओपरी आत्मायाँ का कांल करया होड़ माणस किस तरियां ठीक होया। ");
INSERT INTO bgc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","फेर गिरासेनियों कै लोवै-धोवै के सारे माणसां नै यीशु तै बिनती करी के म्हारै उरै तै चल्या जा, क्यूँके वे घणे डरगे थे। आखर म्ह वो किस्ती पै चढ़कै बोहड़ आया। ");
INSERT INTO bgc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जिस माणस म्ह ओपरी आत्मा लिकड़ी थी वो उसतै बिनती करण लाग्या के मन्नै अपणे गेल्या रहण दे, पर यीशु नै उस ताहीं बिदा करकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“अपणे घरां बोहड़ जा अर माणसां तै बता के परमेसवर नै तेरे खात्तर किसे बड़े-बड़े काम करे सै।” वो जाकै सारे नगर म्ह प्रचार करण लाग्या के यीशु नै मेरै खात्तर किसे बड़े-बड़े काम करे। ");
INSERT INTO bgc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जिब यीशु बोहड़या तो माणस उसतै राज्जी होकै मिले, क्यूँके वे सारे उसकी बाट देक्खै थे। ");
INSERT INTO bgc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","इतनै म्ह याईर नाम का एक माणस आया, जो आराधनालय का सरदार था, अर यीशु कै पायां म्ह पड़कै उसतै बिनती करण लागग्या के मेरै घरां चाल, ");
INSERT INTO bgc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","क्यूँके उसकी बारहां साल की एकलौती बेट्टी थी, अर वा मरण नै होरी थी। जिब वो जाण लागरया था, जद माणस उसपै पड़ण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","एक बिरबान्नी नै जिसकै बारहां साल तै लहू बहण की बीमारी थी, अर जो अपणी सारी कमाई डाक्टरां कै पाच्छै बरतगी थी, फेरभी किसे कै हाथ तै चंगी कोनी हो सकी थी, ");
INSERT INTO bgc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","पाच्छै तै आकै उसकै लत्ते ताहीं छुया, अर जिब्बे उसका लहू बहणा बन्द होगा। ");
INSERT INTO bgc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","इसपै यीशु नै कह्या, “मेरैताहीं किसनै छुया?” जिब सारे नाट्टण लाग्गे, तो पतरस अर उसके साथियाँ नै कह्या, “हे माल्लिक, तन्नै तो भीड़ दबाण लागरी सै अर तेरे पै पड़ण लागरी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","पर यीशु नै कह्या, “किसे नै मेरै ताहीं छुआ सै, क्यूँके मन्नै बेरा पाटग्या के मेरै म्ह तै सामर्थ लिकड़ी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जिब बिरबान्नी नै देख्या के मै लुह्क कोनी सकदी, फेर काम्बदी होई आई अर उसकै पायां पै पड़कै सारे माणसां कै स्याम्ही बताया के उसनै किस कारण उस ताहीं छुया, अर किस तरियां जिब्बे चंगी होई। ");
INSERT INTO bgc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","उसनै उसतै कह्या, “बेट्टी, तेरे बिश्वास नै तेरे ताहीं ठीक करया सै, खुशी-खुशी चली जा।” ");
INSERT INTO bgc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","वो न्यू कहवै था के किसे नै आराधनालय कै सरदार याईर कै उरै तै आकै कह्या, “तेरी छोरी मर ली सै: गुरु नै कांल ना करै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","यीशु नै न्यू सुणकै उसतै जवाब दिया, “मतना डरै, सिर्फ बिश्वास राख, तो वा बच जावैगी।” ");
INSERT INTO bgc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","घर म्ह आकै उसनै पतरस, यूहन्ना, याकूब, अर छोरी के माँ-बाप नै छोड़ दुसरे किसे नै अपणे गेल्या भीत्त्तर कोनी आण दिया। ");
INSERT INTO bgc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सारे उसकै बाबत रोण-पिट्टण लागरे थे, पर उसनै कह्या, “रोओ मतना, वा मरी कोनी पर सोवै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","वे न्यू जाणकै के वा मरगी सै उसका मजाक उड़ाण लाग्ये। ");
INSERT INTO bgc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पर उसनै उसका हाथ पकड्या, अर रुक्का मारकै कह्या, “हे छोरी, उठ!” ");
INSERT INTO bgc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","फेर उसका जी बोहड़ आया अर वा जिब्बे उठ बेठ्ठी। फेर उसनै हुकम दिया के उसनै कुछ खाण नै द्यो। ");
INSERT INTO bgc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","उसकै माँ-बाप हैरान होए, पर उसनै उन ताहीं चिताया के यो जो होया सै किसे तै ना कहियो। ");
INSERT INTO bgc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","फेर उसनै अपणे बारहां चेल्यां ताहीं बुलाकै उननै सारी ओपरी आत्मायाँ अर बिमारियाँ ताहीं दूर करण की सामर्थ अर हक दिया, ");
INSERT INTO bgc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","अर उननै परमेसवर कै राज्य का प्रचार करण अर बिमारां ताहीं आच्छा करण खात्तर भेज्या। ");
INSERT INTO bgc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","उसनै उनतै कह्या, “राह खात्तर कुछ ना लियो, ना तो लाठ्ठी, ना झोळी, ना रोट्टी, ना रपिये अर ना दो-दो कुड़ते। ");
INSERT INTO bgc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जिस किसे घर म्ह उतरो, उड़ैए रहो, अर उड़ैए तै बिदा होइयो। ");
INSERT INTO bgc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","जो कोए थमनै न्ही अपणावै, उस नगर तै जान्दे होए अपणे पायां की धूळ झाड़ दियो के उनपै गवाही होवै।” ");
INSERT INTO bgc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","आखर म्ह वे लिकड़कै गाम-गाम सुसमाचार सुणान्दे, अर हरेक माणसां नै ठीक करदे होए हांडदे रहे। ");
INSERT INTO bgc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","चौथाई देश के गलील परदेस का राजा हेरोदेस यो सारा सुणकै घबराग्या, क्यूँके कईयाँ नै कह्या, के यूहन्ना मरे होया म्ह तै जिन्दा होया सै, ");
INSERT INTO bgc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","अर कईयाँ नै न्यू कह्या के एलिय्याह दिख्या सै, अर औरां नै न्यू के पुराणे नबियाँ म्ह तै कोए जिन्दा होया सै। ");
INSERT INTO bgc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","पर हेरोदेस नै कह्या, “यूहन्ना का तो मन्नै सिर कटवाया, इब यो कौण सै जिसकै बाबत इसी बात सुणु सूं?” अर उसनै उस ताहीं देखण की चाहन्ना करी। ");
INSERT INTO bgc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","फेर प्रेरितां नै बोहड़कै जो कुछ उननै करया था, उस ताहीं बता दिया, अर वो उननै न्यारे करकै बैतसैदा नामक नगर म्ह लेग्या। ");
INSERT INTO bgc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","न्यू जाणकै भीड़ उसकै पाच्छै हो ली, अर वो राज्जी होकै उनतै मिल्या, अर उनतै परमेसवर कै राज्य की बात करण लाग्या, अर जो चंगे होणा चाहवै थे उन ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जिब दिन छिपण लाग्या तो बारहां नै आकै उसतै कह्या, “भीड़ नै जाणदे के चौगरदे के गाम्मां अर बस्तियाँ म्ह जाकै ठहरै अर खाणे का जुगाड़ करै, क्यूँके हम उरै बियाबान जगहां म्ह सां।” ");
INSERT INTO bgc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","यीशु नै उनतै कह्या, “थमे उननै खाण नै द्यो।” उननै कह्या, “म्हारै धोरै पाँच रोट्टी अर दो मच्छियाँ नै छोड़कै और कुछ कोनी, पर हाँ, जै हम जाकै इन सारया खात्तर खाणा मोल ल्यावां, फेर हो सकै सै।” वे माणस तो पाँच हजार माणसां कै करीबन थे। ");
INSERT INTO bgc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","फेर उसनै अपणे चेल्यां तै कह्या, “उननै पचास-पचास करकै लैणपतार म्ह बिठा द्यो।” ");
INSERT INTO bgc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","उननै न्यूए करया, अर सारया ताहीं बिठा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","फेर यीशु नै वे पाँच रोट्टी अर दो मच्छियाँ ली, सुर्ग कान्ही लखाकै परमेसवर का धन्यवाद करया, अर रोट्टी तोड़-तोड़कै चेल्यां ताहीं देंदा गया के माणसां ताहीं बांडै। ");
INSERT INTO bgc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","फेर सारे खाकै छिकगे, अर चेल्यां नै बचे होड़ टुकड्या तै भरी होई बारहां टोकरी ठाई। ");
INSERT INTO bgc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","जिब वो एक्ले म्ह प्रार्थना करै था अर चेल्लें उसकै गेल्या थे, तो उसनै उनतै बुझ्झया, “माणस मन्नै के कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","उननै जवाब दिया, “यूहन्ना बपतिस्मा देण आळा, अर कोए एलिय्याह, अर कोए यो के पुराणे नबियाँ म्ह तै कोए जिन्दा होया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","उसनै उनतै बुझ्झया, “पर थम मन्नै के कहो सो?” पतरस नै जवाब दिया, “परमेसवर का मसीह।” ");
INSERT INTO bgc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","फेर उसनै उनतै चिताकै कह्या के यो किसे तै ना कहियो।। ");
INSERT INTO bgc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","फेर उसनै कह्या, “मुझ माणस कै बेट्टे खात्तर जरूरी सै के मै घणा दुख ठाऊँ, अर यहूदी अगुवें, प्रधान याजक अर शास्त्री मन्नै तुच्छ समझकै मार देवै, अर मै तीसरे दिन जिन्दा हो जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","उसनै सारया तै कह्या, “जो कोए मेरै मेरा चेल्ला बणणा चाहवै, वो अपणी ए इच्छा पूरी ना करै बल्के हरेक दिन अपणे दुखां का क्रूस ठाकै, मेरै पाच्छै हो लेवै। ");
INSERT INTO bgc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","क्यूँके जो कोए अपणी जान बचाणा चाहवैगा वो उसनै खोवैगा, पर जो कोए मेरी खात्तर अपणी जान खोवैगा वोए उसनै बचावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","जै माणस सारी दुनिया नै पा लेवै अर अपणी जान खो दे या उसका नुकसान ठावै, तो उसनै के फायदा? ");
INSERT INTO bgc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जो कोए मेरै तै अर मेरी बात्तां तै सरमावैगा, मै माणस का बेट्टा भी, जिब अपणी अर अपणे पिता की अर पवित्र सुर्गदूत्तां की महिमा सुधां आऊँगा, तो उसतै सरमावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“मै थमनै साच्ची कहूँ सूं, के जो याड़ै खड़े सै, उन म्ह तै कुछ इसे सै के जिब ताहीं परमेसवर का राज्य ना देख लेवैं, जद ताहीं मौत उननै कदे छू भी न्ही पावैगी।” ");
INSERT INTO bgc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","इन बात्तां कै कोए आठ दिनां पाच्छै वो पतरस, यूहन्ना अर याकूब नै गेल्या लेकै प्रार्थना करण खात्तर पहाड़ पै गया। ");
INSERT INTO bgc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","जिब वो प्रार्थना करै था, तो उसके मुँह का रूप बदल ग्या, अर उसके लत्ते धोळे होकै चमकण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","अर लखाओ, मूसा नबी अर एलिय्याह नबी ये दो माणस उसकै गेल्या बतळावै थे। ");
INSERT INTO bgc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ये महिमा सुधां दिक्खे अर यीशु के मरण का जिक्र करै थे, जो यरुशलेम म्ह होण आळा था। ");
INSERT INTO bgc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस अर उसके साथी नींद म्ह होरे थे, अर जिब ठीक तरियां सोध्दी म्ह आए, तो उसकी महिमा अर उन दो माणसां नै, जो उसकै गेल्या खड़े थे, देख्या। ");
INSERT INTO bgc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","जिब वे उसकै धोरै तै जाण लाग्गे, तो पतरस नै यीशु तै कह्या, “हे माल्लिक, म्हारा उरै रहणा भला सै: आखर म्ह हम तीन मण्डप बणावा, एक तेरे खात्तर, एक मूसा नबी खात्तर, एक एलिय्याह नबी कै खात्तर।” उसनै बेरा कोनी था के कह के रह्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","वो न्यू कहवैए था के एक बाद्दळ आकै उनपै छाग्या, अर जिब वे उस बाद्दळ तै घिरण लाग्गे तो वे डरगे। ");
INSERT INTO bgc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","फेर उस बाद्दळ म्ह तै या वाणी लिकड़ी, “यो मेरा बेट्टा अर मेरा चुण्या होया सै, इसकी सुणो।” ");
INSERT INTO bgc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","या आवाज होन्दे यीशु एक्ला होग्या, अर वे बोल-बाल्ले रहे, अर जो कुछ देख्या था उसकी कोए बात उन दिनां म्ह किसे तै न्ही कही। ");
INSERT INTO bgc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","दुसरे दिन जिब वो पहाड़ तै उतरया तो एक बड्डी भीड़ उसतै आ मिली। ");
INSERT INTO bgc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","अर लखाओ, भीड़ म्ह तै एक माणस नै किल्की मारकै कह्या, “हे गुरु, मै तेरे तै बिनती करुँ सूं के मेरे बेट्टे पै दया की निगांह फेर दे, क्यूँके वो मेरा एक्ला बेट्टा सै। ");
INSERT INTO bgc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","अर दे, एक भुंडी ओपरी आत्मा उसनै पकड़ै थी, अर वो चाणचक किल्की मारै था, अर वा उसनै इसा मरोड़ै थी के वो मुँह म्ह तै झाग भर लावै सै, उसनै रोंदकै घणी मुश्किल तै छोड्डै थी। ");
INSERT INTO bgc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","मन्नै तेरे चेल्यां तै बिनती करी के उसनै लिकाड़ै, पर वे कोनी काढ सके।” ");
INSERT INTO bgc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","यीशु नै जवाब दिया, “हे अबिश्वासी अर जिद्दी माणसों, मै कद ताहीं थारे गेल्या रहूँगा अर थारी सहूँगा? अपणे बेट्टे नै उरै लिया।” ");
INSERT INTO bgc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","जिब वो आवै था तो ओपरी आत्मा नै उस ताहीं पटककै मरोड्या, पर यीशु नै उस ओपरी आत्मा ताहीं धमकाया अर छोरे ताहीं ठीक करकै पिता तै थमा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","फेर सारे माणस परमेसवर कै घणे सामर्थ तै हैरान होए। पर जिब सारे माणस उन सारे काम्मां तै जो वो करै था, हक्के-बक्के थे, तो उसनै अपणे चेल्यां तै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“थम इन बात्तां पै गौर करो, क्यूँके मै माणस का बेट्टा माणसां कै हाथ्थां म्ह पकड़वाया जाण पै सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पर वे इस बात नै कोनी समझै थे, अर या बात उनतै लुक्ही रही के उननै उसका बेरा न्ही पाट्टै, अर वे इस बात कै बारै म्ह उसतै बुझ्झण तै डरै थे। ");
INSERT INTO bgc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","फेर उन म्ह या बहस होण लाग्गी के म्हारै तै बड्ड़ा कौण सै। ");
INSERT INTO bgc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","पर यीशु नै उनकै मन के विचारां ताहीं पढ़ लिया, अर एक बाळक नै लेकै अपणे धोरै खड्या करया, ");
INSERT INTO bgc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","अर उनतै कह्या, “जो कोए मेरै नाम तै इस बाळक नै अपणावै सै, वो मन्नै अपणावै सै, अर जो कोए मन्नै अपणावै सै, वो मेरै भेजण आळे नै भी अपणावै सै, क्यूँके जो थारे म्ह सारया म्ह छोट्टे तै छोट्टा सै, वोए बड्ड़ा सै।” ");
INSERT INTO bgc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","फेर यूहन्ना नै कह्या, “हे स्वामी, हमनै एक माणस ताहीं तेरे नाम तै ओपरी आत्मा लिकाड़दे देख्या, अर हमनै उसतै मना करया, क्यूँके वो म्हारी तरियां तेरा चेल्ला न्ही था।” ");
INSERT INTO bgc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","यीशु नै उसतै कह्या, “उसनै नाट्टो ना, क्यूँके जो थारे बिरोध म्ह न्ही, वो थारे कान्ही सै।” ");
INSERT INTO bgc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जिब उसके उप्पर ठाए जाण के दिन पूरे होण पै थे, तो उसनै यरुशलेम जाण का विचार पक्का करया। ");
INSERT INTO bgc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","उसनै अपणे आग्गै दूत भेज्जै। वे सामरियाँ कै एक गाम म्ह गए ताके उसकै खात्तर जगहां त्यार करै। ");
INSERT INTO bgc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पर उन माणसां नै उस ताहीं उतरण कोनी दिया, क्यूँके वो यरुशलेम जावै था। ");
INSERT INTO bgc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","न्यू देखकै उसके चेल्लें याकूब अर यूहन्ना नै कह्या, “हे प्रभु, तू के चाहवै सै के हम हुकम देवां, के अकास तै आग गिरकै उननै भस्म करदे?” ");
INSERT INTO bgc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","पर उसनै बोहड़कै उन ताहीं धमकाया (अर कह्या, “थम न्ही जाणदे के थम किसी आत्मा के सो। क्यूँके माणस का बेट्टा लोग्गां नै जान तै मारण कोनी आया, बल्के उननै बचाण आया सै।”) ");
INSERT INTO bgc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","अर वे किसे दुसरे गाम म्ह चले गये। ");
INSERT INTO bgc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","जिब वे राह म्ह जावै थे, तो किसे नै उसतै कह्या, “जित्त-जित्त तू जावैगा, मै तेरे पाच्छै हो ल्यूँगा।” ");
INSERT INTO bgc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीशु नै उसतै कह्या, “लोमड़ियां की घुरखाण अर अकास के पंछियाँ के बसेरे हो सै, पर माणस के बेट्टे खात्तर सिर छिपाण की भी जगहां कोनी।” ");
INSERT INTO bgc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","उसनै दुसरे तै कह्या, “मेरै पाच्छै हो ले।” उसनै कह्या, “हे प्रभु, पैहले मन्नै घर जाणदे, मै अपणे पिता के मरण कै बाद उस ताहीं दफना के आऊँगा, फेर तेरा चेल्ला बणुगाँ।” ");
INSERT INTO bgc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","उसनै उसतै कह्या, “जो आत्मिक रूप तै मर चुके सै, उननै मुर्दे दफणाण दे। पर तू जाकै परमेसवर कै राज्य की कथा सुणा।” ");
INSERT INTO bgc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","एक और नै भी कह्या, “हे प्रभु, मै तेरे पाच्छै हो लूँगा, पर पैहल्या मन्नै जाणदे के अपणे घर के माणसां तै बिदा ले आऊँ।” ");
INSERT INTO bgc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीशु नै उसतै कह्या, “जो कोए अपणा हाथ हळ पै धरकै पाच्छै देक्खै सै, वो परमेसवर के राज्य कै जोग्गा कोनी।” ");
INSERT INTO bgc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","इन बात्तां कै बाद प्रभु यीशु नै सत्तर और चेल्लें तैयार करे, अर जिस-जिस गाम अर जगहां पै वो खुद जाण आळा था, उड़ै उननै दो-दो करकै अपणे आग्गै भेज्या। ");
INSERT INTO bgc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","उसनै अपणे चेल्यां तै कह्या, “पके होए खेत्तां की तरियां लोग तो भोत सै जो परमेसवर के वचन नै सुणणा अर समझणा चाहवै सै। पर फसल काट्टण आळे थोड़े लोग सै, जो उन ताहीं जाकै परमेसवर का वचन सुणा अर समझा सकै। इस करकै खेत के माल्लिक यानी परमेसवर तै बिनती करो, के वो और लोग्गां नै भेज्जै, ताके परमेसवर का वचन सारे लोग्गां तक पोहच सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जाओ, देक्खों, मै थमनै भेड्डां की तरियां भेड़ियाँ के बिचाल्ये भेज्जू सूं। ");
INSERT INTO bgc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","इस करकै ना बटुआ, ना झोळी, ना जूत्ते ल्यो, अर ना राह म्ह किसे तै नमस्कार करो। ");
INSERT INTO bgc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जिस किसे घर म्ह जाओ, पैहले कहो, इस घर का कल्याण हो। ");
INSERT INTO bgc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","जै उड़ै कोए कल्याण कै जोग्गा होगा, तो थारा कल्याण उसपै थमैगा, न्ही तो थारे धोरै उल्टा ए आ ज्यागा। ");
INSERT INTO bgc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","उस्से घर म्ह रहो, अर जो कुछ उनतै मिलै, वोए खाओ-पीओ, क्यूँके मजदूर नै अपणी मजदूरी मिलणी चाहिए, घर-घर न्ही हांडणा। ");
INSERT INTO bgc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","जिस नगर मै जाओ, अर उड़ै के माणस थमनै उतारै, तो जो कुछ थारे स्याम्ही धरया जावै वोए खाओ। ");
INSERT INTO bgc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","उड़ै के बिमारां नै ठीक करो अर उनतै कहो, परमेसवर का राज्य थारे धोरै आण पोंहच्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","पर जिस नगर म्ह जाओ, अर उड़ै कै माणस थमनै न्ही अपणावै, तो उनके बजारां म्ह जाकै कहो, ");
INSERT INTO bgc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","थारे नगर की धूळ भी, जो म्हारे पायां म्ह लाग्गी सै, हम थारे स्याम्ही झाड़ देवां सां, फेरभी न्यू जाण ल्यो के परमेसवर का राज्य थारे धोरै आण पोंहच्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","मै थमनै कहूँ सूं, “के उस दिन उस नगर की हालत तै सदोम नगर की हालत घणी सहण जोग्गी होवैगी।” ");
INSERT INTO bgc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“धिक्कार सै थारे पै खुराजिन नगर के माणसों! धिक्कार सै थारे पै बैतसैदा नगर के माणसों! जो सामर्थ के काम थारे म्ह करे गये, जै वे सूर अर सैदा नगर म्ह करे जान्दे, तो टाट ओढ़ कै, अर राख म्ह बैठकै वे कदे के पाप करणा छोड़ देन्दे। ");
INSERT INTO bgc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","पर न्याय कै दिन थारी हालत तै सूर अर सैदा नगर की हालत घणी सहण जोग्गी होवैगी। ");
INSERT INTO bgc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","अर हे कफरनहूम नगर, तू के सोच्चै सै, के तू सुर्ग ताहीं ऊँच्चा करया जावैगा? तू तो अधोलोक तक नीच्चै जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“जो थारी सुणै सै, वो मेरी सुणै सै, अर जो थमनै तुच्छ समझै सै, वो मन्नै तुच्छ समझै सै, अर जो मन्नै तुच्छ समझै सै, वो मेरे भेजण आळे ताहीं तुच्छ समझै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","वे सत्तर चेल्लें राज्जी होन्दे होए बोहड़े अर बोल्ले, “हे प्रभु, तेरे नाम तै ओपरी आत्मा भी म्हारा कहणा मान्नै थी।” ");
INSERT INTO bgc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","यीशु नै उनतै कह्या, “जिब थम ओपरी आत्मायाँ नै लिकाड़ो थे तो मन्नै शैतान ताहीं सुर्ग तै बिजळी की तरियां पड़ता होया देख्या। ");
INSERT INTO bgc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","लखाओ, मन्नै थारे ताहीं साँपां अर बिच्छुआं ताहीं पायां तळै रोंदण का, अर बैरी की सारी सामर्थ पै हक दिया सै, अर किसे चीज तै थमनै कुछ नुकसान कोनी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","फेरभी इतने राज्जी मतना होवो के आत्मा थारा कहणा मान्नै सै, पर इसतै राज्जी होवो थारे नाम सुर्ग पै लिक्खे सै।” ");
INSERT INTO bgc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","उस्से बखत यीशु पवित्र आत्मा म्ह होकै खुशी तै भरग्या, अर कह्या, “हे पिता, सुर्ग अर धरती के प्रभु, मै तेरा शुक्रियादा करुँ सूं, के तन्नै इन बात्तां ताहीं ज्ञानियाँ अर समझदारां तै ल्कोए राख्या, अर बाळकां ताहीं दिखा दिया सै।” हाँ, हे पिता, क्यूँके तन्नै योए भाया। ");
INSERT INTO bgc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","मेरे पिता नै मेरै ताहीं सब कुछ सौप दिया सै, अर किसे नै न्ही बेरा के बेट्टा कौण सै, सिवा पिता के, अर पिता कौण सै न्यू भी किसे नै कोनी बेरा सिवाए बेट्टे कै, अर वो जिसपै बेट्टा उस ताहीं जाहिर करणा चाहवै। ");
INSERT INTO bgc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","फेर चेल्यां की ओड़ बोहड़कै एक्ले म्ह बोल्या, “धन्य सै वे आँख, जो ये बात जो थम देक्खो सो। ");
INSERT INTO bgc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","क्यूँके मै थमनै कहूँ सूं के घणखरे नबियाँ अर राजयां नै चाह्या के जो बात थम देक्खो सो, देक्खै, पर न्ही देक्खी, अर जो बात थम सुणो सो, सुणै पर न्ही सुणी।” ");
INSERT INTO bgc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","एक दिन यीशु माणसां नै उपदेश देण लागरया था, तो एक शास्त्री उठ्या अर न्यू कहकै उस ताहीं परखण लाग्या, “हे गुरु, अनन्त जीवन का वारिस होण खात्तर मै के करुँ?” ");
INSERT INTO bgc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीशु नै उसतै कह्या, “नियम-कायदा म्ह के लिख्या सै? अर तू उसनै किस तरियां समझै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","उसनै जवाब दिया, “तू प्रभु, अपणे परमेसवर तै अपणे सारे मन, अपणे पूरे प्राण अर अपणे सारी शक्ति अर अपणी सारी बुद्धि कै गेल्या प्यार राख, अर अपणे पड़ोसी तै अपणे जिसा प्यार राख।” ");
INSERT INTO bgc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","यीशु नै उसतै कह्या, “तन्नै ठीक कह्या, न्यूए करिये जिब्बे तू अनन्त जीवन पावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पर उसनै खुद ताहीं धर्मी जाहिर करण की इच्छा तै यीशु तै बुझ्झया, “तो मेरा पड़ोसी कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीशु नै एक कहाँनी बताकै जवाब दिया, “एक माणस यरुशलेम नगर तै यरीहो नगर म्ह जावै था, के डाकुआं नै घेर कै, उसका सब कुछ खोस कै, उस ताहीं नंगा कर दिया, अर पिट-छेतकै उस ताहीं अधमरा छोड़कै चले गये। ");
INSERT INTO bgc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","अर इसा होया के उस्से राही तै एक यहूदी याजक जावै था, पर उसनै उस ताहीं देखकै उसकी मदद कोनी करी अर चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","इस्से ढाळ एक लेवी उस जगहां पै आया, उसनै भी उसकी मदद कोनी करी, अर वो चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","फेर सामरी गाम का एक राहगीर ओड़ै तै लिकड़या, अर उस माणस ताहीं देखकै उसपै तरस खाया। ");
INSERT INTO bgc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","उसनै उसकै धोरै आकै उसके घायाँ पै तेल अर अंगूर का रस गेर कै पट्टी बाँध्धी, अर अपणे गधे पै चढ़ाकै सराय म्ह लेग्या, अर उसकी सेवा-पाणी करी। ");
INSERT INTO bgc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दुसरे दिन उसनै दो दीनार (दो दिन की मजदूरी) काढ कै सराय कै माल्लिक तै दिये, अर कह्या, इसकी सेवा-पाणी करिये, अर जो कुछ तेरा और लाग्गैगा, वो मै बोहड़दा होया भर द्युगां।” ");
INSERT INTO bgc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","यीशु नै उस ताहीं कह्या, “इब यो बता तेरी समझ तै जिस माणस ताहीं डाकुआं नै घायल करा था, उन तीनां म्ह तै उस माणस का सच्चा पड़ोसी कौण था?” ");
INSERT INTO bgc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","उसनै कह्या, “वोए जिसनै उसपै दया करी।” यीशु नै उसतै कह्या, “जा, तू भी न्यूए करया कर।” ");
INSERT INTO bgc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","जिब यीशु अर उसके चेल्लें जावै थे तो वो एक गाम म्ह गया, अर मार्था नाम की एक बिरबान्नी नै बड़ी उदारता तै उसका आदर-सत्कार करया। ");
INSERT INTO bgc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","मरियम नाम की उसकी एक बेब्बे थी। वा प्रभु कै पायां म्ह बैठकै उसका वचन सुणै थी। ");
INSERT INTO bgc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पर मार्था सेवा-पाणी करदे-करदे परेशान होगी, अर उसकै धोरै आकै कहण लाग्गी, “हे प्रभु, के तन्नै कुछ भी फिक्र कोनी के मेरी बेब्बे नै सारा काम का बोझ मेरै पै गेर दिया सै? इस करकै उसतै कह के मेरी मदद करै।” ");
INSERT INTO bgc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभु यीशु मसीह नै मार्था तै जवाब दिया, “मार्था, हे मार्था, तू घणी बात्तां खात्तर फिक्र करै, अर परेशान हो ज्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","पर एक बात जरुर सै, अर उस बढ़िया हिस्से ताहीं मरियम नै छाँट लिया सै जो उसतै खोस्या कोनी जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","यीशु किसे जगहां प्रार्थना करण लागरया था। जिब उसनै प्रार्थना कर ली, तो उसके चेल्यां म्ह तै एक नै उसतै कह्या, “हे प्रभु, जिस तरियां यूहन्ना नै अपणे चेल्यां ताहीं प्रार्थना करणी सिखाई उस्से तरियां ए तू भी हमनै सीखा दे।” ");
INSERT INTO bgc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","उसनै उनतै कह्या, “जिब थम प्रार्थना करो, तो कहो, ‘हे पिता, तेरा नाम पवित्र मान्या जावै, तेरा राज्य आवै, ");
INSERT INTO bgc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","म्हारी दिन भर की रोट्टी हरेक दिन हमनै दिया कर, ");
INSERT INTO bgc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","अर म्हारे पापां नै माफ कर, क्यूँके हम भी अपणे हरेक कसूरवार ताहीं माफ करां सां, अर म्हारे ताहीं परखै ना।’” ");
INSERT INTO bgc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","फेर यीशु नै चेल्यां तै कह्या, “मान ल्यो थारा एक दोस्त सै, अर थम आध्धी रात नै उसकै धोरै ज्याकै उसतै बिनती करो, ‘हे दोस्त, मन्नै तीन रोट्टी दे। ");
INSERT INTO bgc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","क्यूँके मेरा एक दोस्त सफर करकै मेरै धोरै आया सै, अर उस ताहीं खुआण खात्तर मेरै धोरै कुछ भी कोनी।’ ");
INSERT INTO bgc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","अर वो भीत्त्तर तै थमनै जवाब देवै सै, मन्नै दुखी ना करै, इब तो मन्नै कुवाड़ मूंद राक्खे सै अर मेरे बाळक मेरै धोरै बिछाणा पै सै, इस करकै मै उठकै तन्नै कुछ भी न्ही दे सकदा? ");
INSERT INTO bgc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","मै थमनै कहूँ सूं, हालाकि वो माणस उस ताहीं रोट्टी ना भी देणा चाहवै, तोभी दोस्त होण के नाते वो जरुर उठैगा, अर दोस्त के बार-बार बिनती करण पै, उसकी जरूरत के मुताबिक उस ताहीं जरुर देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","अर मै थारैतै कहूँ सूं, के माँग्गो तो थमनै दिया जावैगा, टोव्होगें, तो थम पाओगे, खटखटाओ, तो थारे खात्तर खोल्या जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","क्यूँके जो कोए माँग्गै सै, उसनै मिलै सै, अर जो टोह्वैं सै, वो पावै सै, अर खटखटावै सै, उसकै खात्तर खोल्या जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","थारे म्ह तै इसा कौण पिता होगा, के जिब उसका बेट्टा रोट्टी माँग्गै, तो उसनै पत्थर देवै, या मच्छी माँग्गै, तो बदले म्ह उसनै साँप देवै? ");
INSERT INTO bgc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","या अंडा माँग्गै तो उसनै बिच्छु दे? ");
INSERT INTO bgc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","इस करकै जिब थम बुरे होकै, अपणे बाळकां नै आच्छी चीज देणा जाणो सों, तो थारा सुर्गीय पिता अपणे माँगण आळा नै पवित्र आत्मा क्यूँ न्ही देवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","फेर यीशु नै एक गूँगा माणस म्ह तै ओपरी आत्मा ताहीं लिकाड़या। जिब ओपरी आत्मा लिकड़गी तो गूँगा बोलण लागग्या, अर माणसां कै अचम्भा होया। ");
INSERT INTO bgc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पर उन म्ह तै कुछ नै कह्या, “यो तो ओपरी आत्मायाँ के प्रधान शैतान की मदद तै ओपरी आत्मायाँ नै लिकाड़ै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","औरां नै उस ताहीं परखण कै खात्तर उसतै अकास की एक निशान्नी माँगी। ");
INSERT INTO bgc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पर उसनै उनकै मन की बात जाणकै, उनतै कह्या, “जिस-जिस राज्य म्ह फूट आवै सै, वो राज्य उजड़ जावै सै, अर जिस घर म्ह फूट होवै सै, वो नाश हो जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","जै शैतान खुद का बिरोधी हो जावै, तो उसका राज्य किस तरियां बण्या रहवैगा? क्यूँके थम मेरै बाबत कहो सो के यो शैतान की मदद तै ओपरी आत्मायाँ नै काड्डै सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","भला जै मै शैतान की मदद तै ओपरी आत्मायाँ नै काढ्ढू सूं, तो थारी ऊलाद किसकी मदद तै काड्डै सै? इस करकै वैए थारा न्याय करैगें। ");
INSERT INTO bgc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पर जै मै परमेसवर के सामर्थ तै ओपरी आत्मायाँ नै काढ्ढू सूं, तो परमेसवर का राज्य थारे धोरै आण पोंहच्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","जिब ठाड्डा माणस हथियार लिये होए अपणे घर की रुखाळी करै सै, तो उसका धन बचा रहवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पर जिब उसतै बाध कोए और ठाड्डा धावा बोलकै उसनै जीत लेवै सै, तो उसकै वे राछ जिनपै उसका बिश्वास था, खोस लेवै सै अर उसका धन लूटकै बांड देवै सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जो मेरै गेल्या न्ही वो मेरै बिरोध म्ह सै, अर जो मेरै गेल्या न्ही कठ्ठा करदा, वो खिंडावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“जिब ओपरी आत्मा माणस म्ह तै लिकड़कै जावै सै, तो सूक्खी जगहां म्ह आराम टोह्न्दी फिरै सै, अर वा पांदी कोनी। फेर वा कहवै सै, ‘मै उस्से माणस म्ह जड़ै तै लिकड़ी थी बोहड़ जाऊँगी।’ अर आकै उस माणस नै घर जिसा झाड़ा-बुहारा अर सजा-धज्या पावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","अर आकै उसनै झाड़ा-बुहारा अर सजा-धज्या पावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","फेर वा ओपरी आत्मा जाकै अपणे तै भुंडी सात और आत्मायाँ नै अपणे गेल्या ले आवै सै, अर वे उस म्ह बड़कै वास करै सै, अर उस माणस की पाच्छली हालत पैहल्या तै भी भुंडी हो जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","जिब यीशु ये बात कहवै था तो भीड़ म्ह तै किसे बिरबान्नी नै जोर तै बोलकै कह्या, “धन्य सै वो बिरबान्नी जिस तू जन्मा अर उसका तन्नै दूध पिया।” ");
INSERT INTO bgc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","उसनै कह्या, “हाँ, पर धन्य वे सै, जो परमेसवर का वचन सुणै अर मान्नै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जिब बड्डी भीड़ कठ्ठी होंदी जावै थी तो वो कहण लाग्या, “इस युग के माणस बुरे सै, वे चिन्ह-चमत्कार टोह्वैं सै, पर योना नबी के चिन्ह-चमत्कार नै छोड़कै उन ताहीं कोए और चिन्ह-चमत्कार कोनी दिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जिसा योना नबी निनवे के आदमियाँ खात्तर निशान्नी ठहरी, उस्से तरियां मै माणस का बेट्टा भी इस युग के आदमियाँ कै खात्तर ठहरूँगा। ");
INSERT INTO bgc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","दक्षिण देश की राणी न्याय कै दिन इस बखत के माणसां कै गेल्या उठकै उन ताहीं कसूरवार ठैहरावैगी, क्यूँके वा राजा सुलैमान का ज्ञान सुणण खात्तर धरती कै सिरे तै आई, अर देक्खों, उरै वो सै जो राजा सुलैमान तै भी बड्ड़ा सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","निनवे नगर के माणस न्याय कै दिन इस युग कै माणसां कै गेल्या उठकै, उन ताहीं कसूरवार ठैहरावैगें, क्यूँके उननै योना नबी का प्रचार सुणकै अपणे पापां ताहीं स्वीकार करया, अर देक्खो, उरै वो सै जो योना नबी तै भी बड्ड़ा सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कोए माणस दीवा जळा कै बरतन कै तळै न्ही धरदा, पर टांडी पै धरै सै के भीत्त्तर आण आळा नै चाँदणा मिलै। ");
INSERT INTO bgc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","देह का दीवा आँख सै, इस करकै जिब तेरी निगांह आच्छी सै तो तेरी सारी देह भी उजाळा होगा। पर जिब तेरी आँख ठीक कोनी सै तो तेरी सारी देह भी अँधेरे म्ह सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","इस करकै चौकन्ने रहो के जो चाँदणा थारे म्ह सै वो अँधेरा ना हो जावै। ");
INSERT INTO bgc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","इस करकै जै तेरी देह म्ह चाँदणा हो अर उसका कोए हिस्सा अन्धेरे म्ह ना रहवैं तो सारा का सारा इसा चाँदणा होगा, जिसा उस बखत होवै सै जिब दीवा अपणी चमक तै थारे ताहीं चाँदणा देवै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","जिब वो बात करै था तो किसे फरीसी नै उसतै बिनती करी के मेरै उरै आकै खाणा खाईयों। वो भीत्त्तर जाकै खाणा खाण नै बेठ्या। ");
INSERT INTO bgc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी नै न्यू देखकै हैरानी होई के उसनै खाणा खाण तै पैहल्या हाथ कोनी धोए। ");
INSERT INTO bgc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","प्रभु नै उसके मन के विचारां ताहीं पढ़कै उसतै कह्या, “हे फरीसियों, थम कटोरे अर थाळी नै उप्पर-उप्पर तै तो माँजो सो, पर थारे भीत्त्तर अन्धेर अर बुराई भरी सै। ");
INSERT INTO bgc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","हे बेअक्लो! जिसनै बाहरणै का हिस्सा बणाया, के उसनै भीत्त्तर का हिस्सा कोनी बणाया? ");
INSERT INTO bgc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","पर हाँ, भीत्त्तर आळी चिज्जां नै दान कर द्यो, तो देक्खो, सारा कुछ थारे खात्तर पवित्र हो जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","पर हे फरीसियों, थारे पै धिक्कार सै! थम पुदीने अर सुदाब का अर कई तरियां के साग-पात का दसमां हिस्सा द्यो सो, पर न्याय ताहीं अर परमेसवर कै प्यार ताहीं टाळ द्यो सो, आच्छा तो था के इन्नै भी करदे रहन्दे अर उननै भी कोनी छोड़दे। ");
INSERT INTO bgc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","हे फरीसियों, थारे पै धिक्कार सै! थम आराधनालयाँ म्ह खास-खास आसन नै चाहो सो अर बजारां म्ह नमस्कार चाहो सो। ");
INSERT INTO bgc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“धिक्कार सै थारे पै! क्यूँके थम उन लुक्ही होई कब्रां की तरियां सो, जिनपै माणस चाल्लै सै पर कोनी जाणदे।” ");
INSERT INTO bgc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","फेर एक शास्त्री नै उसतै जवाब दिया, “हे गुरु, इन बात्तां नै कहकै तू म्हारी बुराई करै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","पर यीशु नै जवाब दिया, “हे शास्त्रियो थारे पै धिक्कार सै! थम नियम-कायदा का इसा बोझ जिनका ठाणा ओक्खा सै, माणसां पै लाद्दो सो, पर थम खुद उनकी मदद खात्तर उस बोझ नै अपणी आन्गळी तै भी कोनी छुन्दे।” ");
INSERT INTO bgc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“धिक्कार सै थारे पै! थम उन नबियाँ की कब्र बणाओ सो, जिन ताहीं थारे पूर्वजां नै मार दिया था।” ");
INSERT INTO bgc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","आखर म्ह थम गवाह सो, अर अपणे पूर्वजां कै काम्मां तै रजामंद सो, क्यूँके उननै उन ताहीं मार दिया अर थम उनकी कब्र बणाओ सो। ");
INSERT INTO bgc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","इस करकै परमेसवर की समझ नै भी कह्या सै, “के मै उनकै धोरै नबियाँ अर प्रेरितां नै भेज्जूंगी, अर वे उन म्ह तै कईयाँ नै मार देंगे, अर कईयाँ नै दुखी करैगें।” ");
INSERT INTO bgc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ताके जित्त नबियाँ का लहू दुनिया की शरुआत तै बहाया गया सै, सारया का ब्यौरा इस युग के माणसां तै लिया जावै, ");
INSERT INTO bgc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","हाबिल की हत्या तै लेकै जकर्याह की हत्या ताहीं, जो वेदी अर मन्दर कै बिचाळै मारया गया। मै थारे तै सच कहूँ सूं, इन सारया का ब्यौरा इस्से बखत के माणसां तै लिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“धिक्कार सै थम शास्त्रियाँ पै! थमनै ज्ञान की ताळी तो ले ली, पर थम खुद कोनी दाखल होए, अर दाखल होण आळे ताहीं भी रोक द्यो सो।” ");
INSERT INTO bgc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जिब वो उड़ै तै लिकड़या, तो शास्त्री अर फरीसी भुण्डी तरियां उसकै पाच्छै पड़गे अर छेड़ण लाग्गे के वो घणखरी बात्तां का जिक्र करै, ");
INSERT INTO bgc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","अर ताक म्ह लाग्गे रहे के उसकै मुँह तै कही होई कोए बात पकड़ै। ");
INSERT INTO bgc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","इतनै म्ह जिब हजारां की भीड़ लाग्गी, उरै ताहीं के वे एक-दुसरे पै पड़ण लाग्गे थे, तो यीशु नै सारया तै पैहल्या अपणे चेल्यां तै यो कह्या, “फरीसियाँ कै कपट रूपी खमीर तै चौकन्ने रहो। ");
INSERT INTO bgc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","कुछ ढकया कोनी, जो उघाड़या न्ही जावैगा, ना कुछ लुहक्या सै, जिसका बेरा न्ही पटै। ");
INSERT INTO bgc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","इस करकै जो कुछ थमनै अन्धेरे म्ह कह्या सै, वो उजाळै म्ह सुण्या जावैगा, अर जो थमनै कोठड़ियाँ म्ह चुपके-चुपके कह्या सै, वो छात पै तै प्रचार करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“मै थारे तै जो मेरे साथी सो कहूँ सूं, के जो देह नै घात करै सै पर उसतै ज्यादा और कुछ न्ही कर सकदे, उनतै ना डरियो। ");
INSERT INTO bgc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मै थमनै समझाऊँ सूं के थमनै किसतै डरणा चाहिये, घात करण कै बाद, जिस ताहीं नरक म्ह गेरण का हक सै, उस्से तै डरियो। हाँ, मै थारे तै कहूँ सूं उस्से तै डरियो। ");
INSERT INTO bgc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","के दो पिस्या की पाँच गौरैयाँ (एक छोट्टी चिड़ियाँ) न्ही बिकदी? फेरभी परमेसवर उन म्ह तै एक नै भी कोनी भुल्दा। ");
INSERT INTO bgc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","थारे सिर के एक-एक बाळ भी गिणे होड़े सै, इस करकै डरो मतना, थम घणी गौरैयाँ तै बढ़कै सो।” ");
INSERT INTO bgc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“मै थारे तै कहूँ सूं जो कोए माणसां कै स्याम्ही मन्नै मान लेवैगा, उसनै मै माणस का बेट्टा भी परमेसवर कै सुर्गदूत्तां कै स्याम्ही मान लेऊँगा। ");
INSERT INTO bgc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पर जो माणसां कै स्याम्ही मेरा इन्कार करैगा, उसका भी परमेसवर कै सुर्गदूत्तां कै स्याम्ही इन्कार करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","जो कोए मुझ माणस कै बेट्टे कै बिरोध म्ह कोए बात कहवै, उसका वो कसूर माफ कर दिया जावैगा, पर जो पवित्र आत्मा की बुराई करै, उसका वो कसूर माफ कोनी करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","जिब माणस थमनै आराधनालयाँ अर हाकिमां अर अधिकारियां कै स्याम्ही ल्यावै, तो फिक्र ना करियो के हम किस तरियां तै, या के जवाब देवां, या के कहवागें। ");
INSERT INTO bgc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","क्यूँके पवित्र आत्मा उस्से बखत थमनै सीखा देगा के, के कहणा चाहिये। ");
INSERT INTO bgc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","फेर भीड़ म्ह तै एक नै यीशु तै कह्या, “हे गुरु, मेरे भाई तै कह के बाप कै जमीन-जायदाद नै मेरै गेल्या बांड लेवै।” ");
INSERT INTO bgc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","उसनै उसतै कह्या, “हे भले माणस, किसनै मेरै ताहीं थारा जमीन-जायदाद बटवारा करण आळा न्यायी बणा दिया सै?” ");
INSERT INTO bgc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","अर यीशु नै उनतै कह्या, “चौकन्ने रहो, अर सारी तरियां कै लोभ-लालच तै खुद नै बचाकै राक्खो, क्यूँके किसे का जीवन उसकै घणी जमीन-जायदाद तै कोनी होंदा।” ");
INSERT INTO bgc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","यीशु नै उनतै एक उदाहरण देकै कह्या, “किसे साहूकार की धरती म्ह घणी पैदावार होई।” ");
INSERT INTO bgc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","फेर वो अपणे मन म्ह विचार करण लाग्या, मै के करुँ? क्यूँके मेरै धोरै जगहां कोनी जित्त अपणी उपज वैगरा धरुँ। ");
INSERT INTO bgc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","अर उसनै कह्या, मै न्यू करुँगा मै अपणे नाज के गोदाम नै तोड़कै, उनतै नाज के और बड़े गोदाम बणाऊँगा, अर उड़ै अपणा सारा नाज अर धन धरुँगा, ");
INSERT INTO bgc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","अर अपणे-आप तै कहूँगा, के तेरे धोरै घणे साल खात्तर घणा धन धरया सै, चैन कर, खा, पी, मौज कर। ");
INSERT INTO bgc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पर परमेसवर नै उसतै कह्या, हे बेकूफ, तू इस्से रात मर जावैगा, फेर जो कुछ तन्नै कठ्ठा करया सै, वो किसका होगा? ");
INSERT INTO bgc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“इस्से तरियां वो माणस भी सै, जो अपणे खात्तर धन कठ्ठा करै सै, पर परमेसवर की निगांह म्ह साहूकार कोनी।” ");
INSERT INTO bgc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","फेर यीशु नै अपणे चेल्यां तै कह्या, “इस करकै मै थमनै कहूँ सूं, अपणे जीवन के खात्तर या चिंता ना करो के हम के खावांगें, ना अपणी देह की के, के पैहरागें। ");
INSERT INTO bgc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","क्यूँके जीवन खाणे तै बढ़कै सै, अर देह लत्यां तै बढ़कै सै। ");
INSERT INTO bgc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","काग्गां पै ध्यान द्यो, वे ना बोवै सै, ना काटै सै, अर ना उनके भण्डार अर गोदाम होवै सै, फेरभी परमेसवर उननै पाळै सै। थारी किम्मत पंछियाँ तै बाध सै।” ");
INSERT INTO bgc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","थारे म्ह तै इसा कौण सै, जो चिंता करण तै अपणी उम्र का एक पल भी बढ़ा सकै सै? ");
INSERT INTO bgc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","इस करकै जै थम अपणी जिन्दगी म्ह छोट्टे-छोट्टे काम भी न्ही कर सकदे, तो जिन्दगी की बड़ी-बड़ी बात्तां खात्तर क्यातै फिक्र करो सो? ");
INSERT INTO bgc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“जंगळी फूल्लां पै ध्यान करो, के वे किस तरियां बढ़ै सै, वे मेहनत करकै अपणे खात्तर लत्तें कोनी बणाते। तोभी मै थारे तै कहूँ सूं, के राजा सुलैमान भी, अपणे सारे शानों-शोकत म्ह, उन म्ह तै, किसे के समान लत्ते पैहरे होए कोनी था। ");
INSERT INTO bgc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","इस करकै जै परमेसवर मैदान की घास नै, जो आज सै अर काल बाड़ म्ह झोक्की जावैगी, इसे लत्तें पहरावै सै, तो हे बिश्वास म्ह कमजोर माणसों, वो थारी चिन्ता क्यूँ न्ही करैगा? ");
INSERT INTO bgc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","अर थम इस बात की टोह् म्ह ना रहो के, के खावांगें अर के पीवागें, अर शक ना करो। ");
INSERT INTO bgc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","क्यूँके परमेसवर ताहीं ना जाणण आळे लोग, इन सारी चिज्जां की टोह् म्ह रहवै सै: पर थारा सुर्गीय पिता जाणै सै, के थमनै इन चिज्जां की जरूरत सै। ");
INSERT INTO bgc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","पर परमेसवर कै राज्य की खोज करो तो ये चीज भी थमनै मिल ज्यागीं।” ");
INSERT INTO bgc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“हे छोट्टे टोळ, मतना डरै, क्यूँके थारे सुर्गीय पिता नै न्यू भाया सै, के थमनै अपणा राज्य देवै। ");
INSERT INTO bgc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अपणा धन बेचकै दान कर द्यो, अर अपणे खात्तर इसे बटुए बणाओ, जो पुराणे कोनी होन्दे, यानिके परमेसवर नै खुश करण आळे भले काम करकै सुर्ग म्ह इसा धन कठ्ठा करो जो खतम कोनी होन्दा, अर जिसकै धोरै चोर कोनी जान्दा, अर कीड़ा कोनी बिगाड़दा। ");
INSERT INTO bgc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","क्यूँके जड़ै थारा धन सै, उड़ै थारा मन भी लाग्या रहवैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“हमेशा परमेसवर के काम्मां खात्तर तैयार रहों, अर थम प्रभु के आण खात्तर, दीवे जळा कै तैयार रहों, ");
INSERT INTO bgc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","अर थम उन माणसां कै बरगे बणो, जो अपणे माल्लिक की बाट देखते रहवै सै, के वो ब्याह तै कद बोहड़ैगा, ताके जिब आकै दरबाजा खटखटावै, तो जिब्बे उसकै खात्तर खोल द्यो। ");
INSERT INTO bgc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","धन्य सै वे नौक्कर जो माल्लिक के बोहड़ण की बाट देखते होए तैयार रहवै सै, मै थमनै साच्ची कहूँ सूं, के माल्लिक भी खुद एक नौक्कर की तरियां उन ताहीं खाणा खुआण खात्तर बिठावैगा, अर खुद उनकी सेवा-पाणी करैगा। ");
INSERT INTO bgc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","जै वो आध्धी रात नै या उसकै बाद आकै उन ताहीं तैयार पावै, तो वे नौक्कर धन्य सै। ");
INSERT INTO bgc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","पर न्यू जाण ल्यो, के जै घर का माल्लिक नै बेरा हो, के चोर ठीक किस घड़ी आवैगा तो वो तैयार रहन्दा, अर अपणे घर म्ह चोरी न्ही होण देन्दा। ");
INSERT INTO bgc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","थम भी मेरे बोहड़ के आण खात्तर तैयार रहो, क्यूँके जिस घड़ी कै बारै म्ह थम सोचदे भी कोनी, उस्से घड़ी मै माणस का बेट्टा सुर्ग तै आ जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","फेर पतरस बोल्या, “हे प्रभु, के यो उदाहरण तन्नै म्हारै खात्तर दिया से या सारया खात्तर दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभु नै जवाब दिया, “वो बिश्वास जोग्गा अर अकलमंद भण्डारी कौण सै, जिसका माल्लिक उस ताहीं नौक्कर-चाकरां पै सरदार ठैहरावै, के उननै बखत पै खाणा देवै।” ");
INSERT INTO bgc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","धन्य सै वो नौक्कर, जिस ताहीं उसका माल्लिक आकै इसाए करदा पावै। ");
INSERT INTO bgc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","मै थमनै साच्ची कहूँ सूं, वो उस ताहीं अपणी सारी धन-सम्पत्ति का माल्लिक बणावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पर जै वो नौक्कर सोच्चण लाग्गै के मेरा माल्लिक आण म्ह वार कर रह्या सै, उसके साथ के नौक्कर नौकराणियाँ ताहीं मारण लागज्या अर खाण-पीण अर दारूबाज होण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तो उस नौक्कर का माल्लिक इसे दिन आवैगा, जिब वो उसकी बाट देख्दा ना हो, अर इसे बखत म्ह आवैगा जिसका उसनै ना बेरा हो, अर उसनै भारी सजा देकै उसकी गिणती बिश्वास लायक माणसां म्ह कोनी करी जावैगी। ");
INSERT INTO bgc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","वो नौक्कर घणा छितैगा, जो अपणे माल्लिक की मर्जी जाणै था, अर तैयार न्ही रह्या अर ना उसकी मर्जी कै मुताबिक चाल्या। ");
INSERT INTO bgc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पर हरेक वो नौक्कर जो अपणे माल्लिक की मर्जी नै कोनी जाणै, फेर इसा काम करै सै जो मार खाण के लायक सै, वो कम छितैगा। इस करकै जिस ताहीं घणा दिया गया सै, उसतै घणा माँगया जावैगा, अर जिस ताहीं घणा सौप्या सै, उसतै घणा लिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“मै धरती पै आग लाण नै आया सूं, अर कितना आच्छा होन्दा, के या इस्से बखत सुलग जान्दी! ");
INSERT INTO bgc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मन्नै तो एक बड़ी भारी बिप्दा का बपतिस्मा लेणा सै, अर जिब ताहीं वो ना हो ले जद ताहीं मै इस्से बिप्दा म्ह रहूँगा! ");
INSERT INTO bgc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","के थम समझो सो के मै धरती पै मिलाप करवाण आया सूं? मै थमनै कहूँ सूं, ना, बल्के न्यारे करण आया सूं। ");
INSERT INTO bgc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","क्यूँके इब तै एक घर म्ह पाँच माणस आप्पस म्ह बिरोध राक्खैगें, तीन जन जो मेरे पै बिश्वास न्ही करते, वो उन दो जन का बिरोध्द करैगें जो मेरे पै बिश्वास राक्खै सै। ");
INSERT INTO bgc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","पिता बेट्टे तै, अर बेट्टा बाप तै बिरोध राक्खैगा, माँ बेट्टी तै, अर बेट्टी माँ तै, सास्सू बहू तै, अर बहू सास्सू तै बिरोध राक्खैगी।” ");
INSERT INTO bgc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","यीशु नै भीड़ तै कह्या, “जिब थम बाद्दळ नै पश्चिम तै उठदे देक्खो सो, तो जिब्बे कहो सो के मिह आवैगा, अर न्यूए होवै सै, ");
INSERT INTO bgc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","अर जिब दक्षिणी हवा चाल्दी देक्खो सो, तो कहो सो के बड़ी गर्मी पड़ैगी, अर न्यूए हो सै। ");
INSERT INTO bgc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","हे कपटियों! थम धरती अर अकास कै रूप-रंग म्ह भेद जाण सको सो, पर परमेसवर जो इस युग म्ह करण लागरया सै उसका भेद क्यातै न्ही जाणदे? ");
INSERT INTO bgc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“थम खुद फैसला क्यातै कोनी कर लेंदे के ठीक सै?” ");
INSERT INTO bgc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जिब तू अपणे बैरी कै गेल्या हाकिम कै धोरै जावै सै, तो राही म्ह उसतै छुटण की कोशिश करले, इसा ना हो के वो तन्नै न्यायाधीश कै धोरै घसीट कै ले जावै, अर न्यायाधीश तन्नै सिपाही के हवालै करदे अर सिपाही तन्नै जेळ म्ह गेर दे। ");
INSERT INTO bgc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मै तेरे तै कहूँ सूं के जिब ताहीं तू पाई-पाई न्ही भर देवैगा, तब तक जेळ तै छुटण न्ही पावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","उस बखत कुछ माणस आण पोहचे, अर यीशु तै उन गलीली माणसां का जिक्र करण लाग्गे, जिन ताहीं पिलातुस नै मन्दर म्ह बलिदान करते बखत मार दिया था, अर उनका ए लहू बलिदान की भेट तै मिला दिया था। ");
INSERT INTO bgc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","न्यू सुणकै उसनै उनतै जवाब म्ह कह्या, “के थम समझो सो के ये गलीली माणस और बाकी सारे गलीलवासियाँ तै घणे पापी थे के उनपै इसी बिप्दा आण पड़ी? ");
INSERT INTO bgc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","मै थमनै कहूँ सूं के ना, पर जै थम पाप करणा न्ही छोड़ोगे तो थम भी इस्से तरियां नाश होओगे। ");
INSERT INTO bgc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","अर थम के सोच्चों सों, के उन अठारह माणसां के बारें म्ह जिनपै शीलोह का गुम्मट पड्या, अर वे दब कै मरगे: यरुशलेम के दुसरे सारे बासिन्दयां तै घणे अपराधी थे? ");
INSERT INTO bgc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","मै थमनै कहूँ सूं, के जै थम पाप करणा न्ही छोड़ोगे तो थम भी इस्से तरियां नाश होओगे।” ");
INSERT INTO bgc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","फेर यीशु नै यो उदाहरण भी देकै कह्या, “किसे अंगूर के बाग म्ह अंजीर का दरखत लागरया था। वो उस म्ह फळ टोह्ण आया, पर कोनी मिल्या। ");
INSERT INTO bgc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","फेर उसनै बाग कै रुखाळै तै कह्या, लखा, तीन साल तै म्ह इस अंजीर कै दरखत पै फळ टोह्ण आऊँ सूं, पर कोनी पान्दा। इसनै काट बगा के यो धरती नै भी क्यूँ रुंधै।” ");
INSERT INTO bgc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","उसनै उसतै जवाब दिया, “हे माल्लिक, इस साल और रहण दे के मै इसकै चौगरदेकै माट्टी खोदकै खाद गेरू। ");
INSERT INTO bgc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","जै आगले साल इसकै फळ आ ग्या तो ठीक, न्ही तो इसनै कटवा दियो।” ");
INSERT INTO bgc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","आराम कै दिन यीशु एक आराधनालय म्ह उपदेश देवै था। ");
INSERT INTO bgc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","उड़ै एक बिरबान्नी थी जिसम्ह अठारह साल तै एक कमजोर करण आळी ओपरी आत्मा थी, अर वा कुबड़ी होगी थी अर किसे तरियां भी सीध्धी कोनी हो सकै थी। ");
INSERT INTO bgc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीशु नै उस ताहीं देखकै बुलाया अर कह्या, “हे नारी, तू अपणे इस रोग तै मुक्त होगी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","फेर उसनै उसपै हाथ धरया, अर वा जिब्बे सीध्धी होगी अर परमेसवर की बड़ाई करण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","इस करकै के यीशु नै आराम कै दिन उस ताहीं ठीक करया था, आराधनालय का सरदार चिड़ कै माणसां तै कहण लाग्या, “काम करण के छ: दिन सै, उन ए दिनां म्ह आकै अपणे रोग ठीक कराओ, पर आराम कै दिन न्ही।” ");
INSERT INTO bgc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","न्यू सुणकै प्रभु यीशु नै जवाब दिया, “हे कपटियों, के आराम कै दिन थारे म्ह तै हरेक अपणे बळध या गधे नै थान म्ह तै खोल कै पाणी पियाण कोनी ले जान्दा? ");
INSERT INTO bgc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","तो के या बिरबान्नी जो अब्राहम की पीढ़ी सै, जिस ताहीं शैतान नै अठारह साल तै जुड़ राख्या था, के इस ताहीं आराम कै दिन इसके बन्धन तै मुक्त करणा न्ही चाहिये था?” ");
INSERT INTO bgc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","जिब यीशु नै ये बात कही, तो उसके सारे बिरोधी शर्मिन्दा होगे, अर साब्ती भीड़ उन महान् काम्मां तै जो वो करै था, राज्जी होई। ");
INSERT INTO bgc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","फेर यीशु नै कह्या, “परमेसवर का राज्य किस जिसा सै? अर मै उसका उदाहरण किसतै द्यु? ");
INSERT INTO bgc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","वो राई कै दाणै की ढाळ सै, जिस ताहीं किसे माणस नै लेकै अपणे बाग म्ह बोया: अर वो बढ़कै दरखत बणग्या, अर अकास के पंछियाँ नै उसकी डाळियाँ पै बसेरा करया।” ");
INSERT INTO bgc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","यीशु नै दुबारै कह्या, “मै परमेसवर के राज्य का उदाहरण किसतै द्यु? ");
INSERT INTO bgc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","वो खमीर की ढाळ सै, जिस ताहीं किसे बिरबान्नी नै लेकै तीन पसेरी (पन्द्रह किलो) चून म्ह रळाया, अर होन्दे-होन्दे सारा चून खमीर बणग्या।” ");
INSERT INTO bgc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","यीशु अर उसके चेल्लें नगर-नगर, अर गाम-गाम होकै उपदेश देन्दे होए यरुशलेम नगर की ओड़ जावै थे, ");
INSERT INTO bgc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","तो किसे नै उसतै बुझ्झया, “हे प्रभु, के थोड़े ए माणसां का उद्धार होगा?” यीशु नै उनतै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“भीड़ै दरबाजे तै बड़ण की कोशिश करो, क्यूँके मै थमनै कहूँ सूं के घणखरे उस म्ह बड़णा चाहवैगें, अर कोनी बड़ सकैगें। ");
INSERT INTO bgc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","क्यूँके परमेसवर जो घर का माल्लिक सै उठकै दरबाजा भेड़ देगा, अर थम बाहरणै खड़े होए खटखटाकै कहण लागो, हे प्रभु, म्हारै खात्तर दरबाजा खोल दे, अर वो जवाब देवै, मै थमनै कोनी जाण्दा, थम कित्त के सो?” ");
INSERT INTO bgc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","फेर थम कहण लागोगे, हमनै तेरे स्याम्ही खाया-पिया अर तन्नै म्हारे बजारां म्ह उपदेश दिया। ");
INSERT INTO bgc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","पर वो कहवैगा, मै थमनै कहूँ चुक्या सूं, मै कोनी जाण्दा, थम कित्त के सो। हे भुन्डे़ काम करण आळो, थम सारे मेरै तै दूर रहो। ");
INSERT INTO bgc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","जिब अब्राहम अर इसहाक अर याकूब अर सारे नबियाँ ताहीं परमेसवर राज्य म्ह बेठ्ठे, अर खुद नै बाहरणै लिकाड़े होए देक्खोगे, “उड़ै रोणा अर दाँत पिसणा होगा। ");
INSERT INTO bgc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","पूरी दुनिया के माणस आकै परमेसवर कै राज्य के भोज म्ह शामिल होवैंगे। ");
INSERT INTO bgc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","अर सच्चाई या सै के जो पाच्छले सै वे पैहले होंगे, अर जो पैहले सै वे पाच्छले होंगे।” ");
INSERT INTO bgc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","उस्से बखत कुछ फरीसियाँ नै आकै यीशु तै कह्या, “उरै तै लिकड़ज्या, क्यूँके हेरोदेस तन्नै मार देणा चाहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","यीशु नै उनतै कह्या, “जाकै उस लोमड़ी तै कह द्यो के लखा, मै आज अर काल ओपरी आत्मायाँ नै काढ्ढू सूं अर बिमारां नै ठीक करुँ सूं, अर तीसरे दिन अपणा काम पूरा करुँगा। ");
INSERT INTO bgc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","फेर भी यो जरूरी सै के मै आज, काल अर परसो सफर करुँ, क्यूँके हो न्ही सकदा के कोए नबी यरुशलेम नगर कै बाहरणै मारया जावै। ");
INSERT INTO bgc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“हे यरुशलेम के माणसों! हे यरुशलेम के माणसों! तन्नै भोत-से नबियाँ ताहीं मारया सै, जो भोत पैहले रहवै थे, अर उन माणसां ताहीं भी पत्थरां तै मार दिया जिन ताहीं थारे धोरै भेज्जे थे। कितनी ए बर मन्नै न्यू चाह्या के जिस ढाळ मुर्गी अपणे बच्चां नै अपणे पाक्खां तळै कठ्ठे करै सै, उस्से तरियां ए मै भी तेरे बाळकां नै कठ्ठा करुँ, पर थमनै न्यू न्ही चाह्या। ");
INSERT INTO bgc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","देक्खो, थारा घर थारे खात्तर उजाड़ छोड्या जावै सै, मै थमनै कहूँ सूं: जिब ताहीं थम न्ही कहोगे, ‘धन्य सै वो, जो प्रभु कै नाम तै आवै सै,’ ‘जद ताहीं थम मन्नै दुबारै कदे न्ही देक्खोगे।’” ");
INSERT INTO bgc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","एक खास मौक्कै पै जिब मसीह आराम कै दिन फरीसियाँ के सरदारां म्ह तै किसे कै घरां रोट्टी खाण नै गया, अर वे सारे उननै घणी उत्सुकता तै देखण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","उड़ै एक माणस था, जिसम्ह जलोदर की बीमारी थी। ");
INSERT INTO bgc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","इसपै यीशु नै शास्त्रियाँ अर फरीसियाँ तै कह्या, “के नियम-कायदा के मुताबिक आराम कै दिन आच्छा करणा ठीक सै या न्ही?” ");
INSERT INTO bgc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","पर वे बोल-बाल्ले रहे। फेर यीशु नै उस रोगी पै हाथ धरकै उस ताहीं ठीक करकै, उस ताहीं बिदा कर दिया। ");
INSERT INTO bgc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","अर उनतै कह्या, “थारे म्ह तै इसा कौण सै, के जै थारा बेट्टा या बळध कुएँ म्ह आराम कै दिन पड़ज्या अर वो उसनै जिब्बे बाहरणै कोनी लिकड़ै?” ");
INSERT INTO bgc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","वे इन बात्तां का कुछ जवाब कोनी दे पाए। ");
INSERT INTO bgc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","जिब यीशु नै देख्या के न्योंदे होए माणस किस तरियां खास-खास जगहां छाँट लेवैं सै तो एक उदाहरण देकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“जिब कोए तन्नै ब्याह म्ह बुलावै, तो खास माणसां की जगहां पै न्ही बैठणा, कदे इसा ना हो के उसनै तेरे तै भी बड़े ताहीं न्योंद राख्या हो, ");
INSERT INTO bgc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","अर जिसनै तेरे ताहीं अर उस ताहीं दोनुआ ताहीं न्योंदा दिया सै, आकै कहवै, ‘इसनै जगहां दे,’ अर फेर तन्नै शर्मिन्दा होकै सारया तै पाच्छै बैठणा पड़ै। ");
INSERT INTO bgc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","पर जिब तू न्योंदा जावै तो सारया तै पाच्छली जगहां बैठ के जिब वो, जिसनै तेरे ताहीं न्योंदा सै आवै, तन्नै कहवै, ‘हे दोस्त, आग्गै बढ़कै बैठ,’ फेर तेरे गेल्या बैठण आळा कै स्याम्ही तेरी बड़ाई होवैगी। ");
INSERT INTO bgc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","क्यूँके जो कोए अपणे-आपनै बड्ड़ा बणावैगा, वो छोट्टा करया जावैगा, अर जो कोए अपणे-आपनै छोट्टा बणावैगा, वो बड्ड़ा करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","फेर यीशु नै फिरीसी तै जिसनै उसका न्योंदा दिया था उसतै कह्या, “जिब तू दिन का या रात का भोज करै, तो अपणे साथियाँ या भाईयाँ या कुण्बे या साहूकार पड़ोसियाँ नै ना न्योंद, कदे इसा ना हो के वे भी तन्नै न्योंदा देवै, अर तेरा बदला हो जावै। ");
INSERT INTO bgc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","पर जिब तू भोज करै तो कंगाल, टुंडे, लंगड़े अर आंध्याँ नै न्योंद। ");
INSERT INTO bgc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तब तू धन्य होवैगा, क्यूँके उन माणसां कै धोरै बदले म्ह देण खात्तर कुछ कोनी, परमेसवर तन्नै उस काम का बदला धर्मियाँ कै जिन्दा होण के बाद देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","यीशु कै गेल्या खाणा खाण आळा म्ह तै एक नै ये बात सुणकै उसतै कह्या, “धन्य सै वो जो परमेसवर के राज्य म्ह भोज खावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","यीशु नै उसतै कह्या, “किसे माणस नै बड्ड़ा भोज करया अर घणा ताहीं न्योंदा। ");
INSERT INTO bgc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जिब खाणा त्यार होग्या तो उसनै अपणे नौक्कर कै हाथ न्योंदे होए माणसां ताहीं कहवां भेज्या, ‘आओ, इब खाणा त्यार सै।’” ");
INSERT INTO bgc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“पर वे सारे के सारे माफी माँगण लाग्गे। पैहल्ड़े नै उसतै कह्या, ‘मन्नै खेत मोल लिया सै, अर जरूरी सै के उसनै देक्खूँ, मै तेरे तै बिनती करुँ सूं मन्नै माफ करदे।’” ");
INSERT INTO bgc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दुसरे नै कह्या, “मन्नै पाँच जोड़े बळध मोल लिए सै, उननै परखण जाऊँ सूं, मै तेरे तै बिनती करुँ सूं, मन्नै माफ करदे।” ");
INSERT INTO bgc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","एक और नै कह्या, “मन्नै ब्याह करया सै, इस करकै मै न्ही आ सकदा।” ");
INSERT INTO bgc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","उस नौक्कर नै आकै अपणे माल्लिक ताहीं ये बात कह सुणाई। फेर घर कै माल्लिक नै खुन्दक म्ह आकै, अपणे नौक्कर तै कह्या, “नगर के बजारां अर गळियाँ म्ह इब्बे जाकै कन्गालाँ नै, टुंड्यां नै, लंगड्यां नै, अर आंध्याँ नै उरै लेकै आओ।” ");
INSERT INTO bgc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","नौक्कर नै दुबारै कह्या, “हे माल्लिक, जिस ढाळ तन्नै कह्या था, उस्से तरियां ए करया गया सै, अर फेर भी जगहां सै।” ");
INSERT INTO bgc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","माल्लिक नै नौक्कर तै कह्या, “सड़कां पै अर बाड़या की कान्ही जा अर माणसां नै मजबूर करकै लिया ताके मेरा घर भरज्या। ");
INSERT INTO bgc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","क्यूँके मै थमनै कहूँ सूं के उन पैहले बुलाए होड़ माणसां म्ह तै कोए मेरै खाणे नै कोनी चाखैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","जिब बड्डी भीड़ यीशु कै गेल्या जावै थी, तो उसनै बोहड़कै उनतै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","जै कोए मेरा चेल्ला बणणा चाहवै सै, अर अपणे माँ-बाप अर घरआळी अर बाळकां नै अर भाईयाँ नै अर भाणां नै बल्के अपणे जीवन नै भी मेरे तै ज्यादा प्यार करै सै, तो वो मेरा चेल्ला न्ही हो सकदा। ");
INSERT INTO bgc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","अर जो कोए अपणे दुखां का क्रूस ना ठावै, अर मेरै पाच्छै न्ही आवै, वो भी मेरा चेल्ला कोनी हो सकदा। ");
INSERT INTO bgc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","उदाहरण के तौर पै “थारे म्ह तै कौण सै जो घर बणाणा चाह्न्दा हो, अर पैहल्या बैठकै खर्चा न्ही फैळावै के पूरा करण की गुंजास मेरै धोरै सै के न्ही? ");
INSERT INTO bgc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","जै वो आस ना होया करदा हो, तो जिब वो नीम धर ले पर काम पूरा ना कर पावै, तो सारे देक्खण आळे न्यू कहकै उसका मखौल उड़ावैंगे, ");
INSERT INTO bgc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘के यो माणस बणाण तो लाग्या पर पूरा कोनी कर पाया?’” ");
INSERT INTO bgc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","या कौण इसा राजा सै जो दुसरे राजा तै युध्द करण जान्दा हो, अर जो विचार करले के जो बीस हजार सैनिक लेकै मेरै पै चढ़या आवै सै, के मै दस हजार सैनिक लेकै उसका सामना कर सकूँ सूं के न्ही? ");
INSERT INTO bgc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","न्ही तो उसके दूर रहन्दे होए वो दूत्तां नै भेजकै उसतै मिलाप करणा चाहवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","इस्से ढाळ थारे म्ह तै कोए अपणा सारा कुछ त्याग न्ही देवै, वो मेरा चेल्ला कोनी हो सकदा। ");
INSERT INTO bgc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“नूण तो बढ़िया सै, पर जै नूण का सुवाद जान्दा रहवै, तो वो किस चीज तै नमकीन करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","वो ना तो धरती कै अर ना खाद कै खात्तर काम म्ह आवै सै: उसनै तो माणस बाहरणै बगा देवै सै। जिसके कान हों वो ध्यान तै सुण ले।” ");
INSERT INTO bgc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","सारे चुंगी लेण आळे अर पापी माणस, यीशु कै धोरै आया करै थे ताके उसकी सुणै। ");
INSERT INTO bgc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","पर फरीसी अर शास्त्री बरड़ाकै कहण लाग्गे, “यो तो पापियाँ तै मिलै सै अर उनकै गेल्या खावै भी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","फेर उसनै उनतै यो उदाहरण कह्या ");
INSERT INTO bgc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“थारे म्ह तै कौण सै जिसकी सौ भेड़ हों, अर उन म्ह तै एक खुज्या, तो निन्यानमै नै बण म्ह छोड़कै, उस खुई होड़ नै जिब ताहीं पा न्ही लेन्दी टोह्न्दा ना रहवैं? ");
INSERT INTO bgc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","अर जिब पा ज्या सै, फेर वो घणा राज्जी होकै उस ताहीं कंधे पै ठा लेवै सै, ");
INSERT INTO bgc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","अर अपणे घरां आकै साथियाँ अर पड़ोसियाँ नै कठ्ठा करकै कहवै सै, ‘मेरै गेल्या खुशी मनाओ, क्यूँके मेरी खुई होड़ भेड़ पागी सै।’ ");
INSERT INTO bgc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मै थमनै कहूँ सूं, के इस्से तरियां तै पापां नै छोड़ण आळे एक पापी खात्तर उन निन्यानबे धर्मियाँ की तुलना म्ह सुर्ग म्ह इसतै भी घणा आनन्द मनाया जावै सै, जिननै पापां की माफी माँगण की जरूरत कोनी।” ");
INSERT INTO bgc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","यीशु नै एक और उदाहरण दिया “के कौण इसी बिरबान्नी होगी जिसकै धोरै दस सिक्के हों, अर उन म्ह तै एक खुज्या, तो वा दीवा बाळ कै अर घर झाड़-बुहारकै, जिब ताहीं पा न्ही जावै जी लाकै टोह्न्दी ना रहवैं? ");
INSERT INTO bgc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","अर जिब पा ज्या सै, तो वा अपणी सहेलियाँ अर पड़ोसणां नै कठ्ठा करकै कहवै सै, ‘मेरै गेल्या खुशी मनाओ, क्यूँके मेरा खुया होया सिक्का पाग्या सै।’ ");
INSERT INTO bgc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","मै थमनै कहूँ सूं के इस्से ढाळ जिब कोए माणस अपणे पापां नै छोड़कै परमेसवर की राह पै चाल्लणा शरु करै सै तो उसके खात्तर भी, परमेसवर के सुर्गदूत्तां कै स्याम्ही उतणा ए आनन्द मनाया जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","फेर यीशु नै एक और उदाहरण देकै कह्या, “किसे माणस के दो बेट्टे थे। ");
INSERT INTO bgc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","उन म्ह तै छोट्ळै नै पिता तै कह्या, हे पिता, सम्पत्ति म्ह तै जो मेरा बांडै आवै सै वो मन्नै इब्बे दे द्यो। इस करकै पिता नै उन ताहीं अपणी सम्पत्ति का बंडवारा कर दिया। ");
INSERT INTO bgc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","घणे दिन कोनी बीते थे के छोट्टा बेट्टा सारा कुछ कठ्ठा करकै दूर देश म्ह चल्या गया, अर उड़ै बुरे काम्मां म्ह अपणा धन उड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जिब वो सारा कुछ खर्च कर ग्या, तो उस देश म्ह भारया अकाळ पड्या, अर वो कंगाल होग्या, अर उसकै धोरै खाण नै कुछ भी न्ही रह्या। ");
INSERT INTO bgc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","इस करकै वो उस देश के बाशिंद्यां म्ह तै एक कै धोरै काम करण खात्तर, अर उसनै उस ताहीं अपणे खेत्तां म्ह सूअर चराण खात्तर भेज्या। ");
INSERT INTO bgc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","वो भोत भूक्खा था अर वो चाहवै था के उन फळियाँ म्ह तै जिन नै सूअर खावै थे, अपणा पेट भरै, अर उस ताहीं कोए कुछ कोनी देवै था। ");
INSERT INTO bgc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","जिब छोट्टे बेट्टे के होश ठिकाणै आये अर अपणे-आप तै कहण लाग्या, मेरै पिता कै धोरै इसे भोत मजदूर सै जिनकै खाणा खाण कै बाद भी घणाए बच जावै सै, पर मै उरै भूक्खा मरण लाग रह्या सूं। ");
INSERT INTO bgc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","इस करकै मै इब उठकै अपणे पिता धोरै जाऊँगा अर उसतै कहूँगा के पिता जी, मन्नै परमेसवर जो सुर्ग म्ह सै, उसके अर तेरे बिरोध म्ह पाप करया सै। ");
INSERT INTO bgc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","इब इस जोग्गा कोनी रह्या के तेरा बेट्टा कुह्वाऊँ, मन्नै अपणे एक मजदूर की ढाळ राख ले।” ");
INSERT INTO bgc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“पर वो उस देश नै छोड़ के अपणे बाप कै घर की ओड़ चाल्या, वो इब्बे कुछ ए दूर था के उसकै बाप नै उस ताहीं देख्या उसपै तरस आया, अर भाजकै अपणे बेट्टे ताहीं छात्त्ती कै लगाकै, उस ताहीं चुम्ता रह्या। ");
INSERT INTO bgc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","बेट्टे नै उसतै कह्या, पिता जी, मन्नै परमेसवर जो सुर्ग म्ह सै, उसके अर तेरे बिरोध म्ह पाप करया सै, अर इब इस जोग्गा कोनी रह्या के तेरा बेट्टा कुह्वाऊँ। ");
INSERT INTO bgc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","पर बाप नै अपणे नौकरां तै कह्या, ‘ताव्ळ करकै सुथरे-सुथरे लत्ते लिकाड़कै उसनै पिहराओ, अर उसकै हाथ्थां म्ह गुठ्ठी, अर पायां म्ह जूत्ती पहराओ, ");
INSERT INTO bgc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","अर बढ़िया भोज तैयार करो ताके हम खावां अर खुशी मनावां। ");
INSERT INTO bgc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","क्यूँके मेरा यो बेट्टा मरग्या था, दुबारै जीग्या सै: खुग्या था अर इब पाग्या सै।’ अर वे खुशी मनाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","पर उसका जेट्ठा बेट्टा खेत म्ह काम करण लागरया था। जिब वो आन्दे होए घर कै धोरै पोंहच्या, तो उसनै गाण-बजाण अर नाचण का बोल सुण्या। ");
INSERT INTO bgc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","आखर म्ह उसनै एक नौक्कर बुलाकै बुझ्झया, यो के होण लाग रह्या सै? ");
INSERT INTO bgc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","उसनै उस ताहीं कह्या, तेरा भाई बोहड़ आया सै, अर तेरे बाप नै बढ़िया भोज तैयार करवाया सै, इस करकै के वो ठीक-ठाक घरा आ ग्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","न्यू सुणकै वो छो तै भरग्या अर भीत्त्तर जाणा कोनी चाह्या, पर उसका बाप बाहरणै आकै उसनै मनाण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","उसनै बाप तै कह्या, ‘देख, मै इतने साल तै तेरी सेवा-पाणी कर रह्या सूं, अर कदे भी तेरा हुकम कोनी टाळया, फेरभी तन्नै मेरै ताहीं कदे भी कोए बढ़िया चीज कोनी दी, ताके मै अपणे साथियाँ गेल्या आनन्द कर सकूँ। ");
INSERT INTO bgc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पर जिब तेरा यो बेट्टा आया, जिसनै तेरी सम्पत्ति अयाशियाँ म्ह उड़ा दी सै, तो उसकै खात्तर तन्नै बढ़िया भोज तैयार करया।’ ");
INSERT INTO bgc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","उसकै बाप नै उसतै कह्या, मेरे बेट्टे, तू सारी हाण मेरै गेल्या सै, अर जो कुछ मेरा सै वो सारा तेराए सै। ");
INSERT INTO bgc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पर इब आनन्द अर मगन होणा चाहिये क्यूँके यो तेरा भाई जो मरे होए माणसां की तरियां था दुबारा जी ग्या सै, खुग्या था, इब पाग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","फेर यीशु नै चेल्यां ताहीं एक और उदाहरण देकै कह्या, “किसे साहूकार का एक भण्डारी था, अर लोग्गां नै उसकै स्याम्ही उसपै यो इल्जाम लाया के वो तेरा सारा धन उड़ा देवै सै। ");
INSERT INTO bgc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","आखर म्ह उसनै अपणे भण्डारी ताहीं बुलाकै कह्या, ‘यो के सै मै तेरे बाबत के सुणु सूं?’ अपणे भण्डारीपण का हिसाब दे, क्यूँके तू आग्गै तै भण्डारी कोनी रह सकदा।” ");
INSERT INTO bgc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","फेर भण्डारी सोच्चण लाग्या, इब मै के करुँ? क्यूँके मेरा माल्लिक इब भण्डारी का काम मेरै तै खोस्सै सै। माट्टी खोदण का काम मेरै तै होवै कोनी, अर भीख माँगदे होए मन्नै शर्म आवैगी। ");
INSERT INTO bgc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","मै जाण ग्या के मै के करुँ, ताके मै जिब भण्डारी कै काम तै हटाया जाऊँ तो माणस मन्नै अपणे घरां म्ह ले लेवै। ");
INSERT INTO bgc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","फेर उसनै अपणे माल्लिक के देणदारां ताहीं एक-एक करकै बुलाया अर पैहल्या तै बुझ्झया, “तेरे उप्पर मेरै माल्लिक का कितना कर्जा सै?” ");
INSERT INTO bgc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","उसनै कह्या, “सौ मण तेल,” फेर उसनै उसतै कह्या, “अपणा खात्ता अर बही ले अर बैठकै तावळा पचास लिख दे।” ");
INSERT INTO bgc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","फेर उसनै दुसरे तै बुझ्झया, “तेरे पै कितना कर्जा सै?” दुसरे नै कह्या, सौ मण गेहूँ, फेर उसनै उसतै कह्या, “अपणा खात्ता अर बही लेकै अर बैठकै अस्सी लिख दे।” ");
INSERT INTO bgc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","माल्लिक नै उस अधर्मी भण्डारी ताहीं सराहया के उसनै कितनी चतुराई तै काम करया सै। क्यूँके इस दुनिया के माणस अपणे बखत के माणसां के गेल्या व्यवहार म्ह चाँदणे के माणसां तै घणे चलाक सै। ");
INSERT INTO bgc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","अर मै थमनै कहूँ सूं के दुनिया की धन-दौलत तै भले काम करकै अपणे खात्तर साथी बणा ल्यो, ताके जिब वो धन दौलत न्ही रहवैं तो अनन्त काल के घर म्ह थारे स्वागत हो। ");
INSERT INTO bgc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","वे लोग जो थोड़े-तै भी थोड़े म्ह भी बिश्वास जोग्गे सै, वे घणे म्ह भी बिश्वास जोग्गे होंगे, जो थोड़े-तै भी थोड़े म्ह बेईमान सै, वो घणा म्ह भी बेईमान होंगे। ");
INSERT INTO bgc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","इस करकै जिब थम संसारिक धन म्ह बिश्वास जोग्गा न्ही ठहरे, तो साच्चा धन थमनै कौण देवैगा? ");
INSERT INTO bgc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","अर जै थम संसारिक धन-दौलत न इस्तमाल करण म्ह भरोस्सेमंद न्ही ठहरे, तो परमेसवर थमनै सुर्गीय धन क्यूँ देवैगा? ");
INSERT INTO bgc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कोए नौक्कर दो मालिकां की सेवा एक बखत पै न्ही कर सकदा, क्यूँके वो एक तै बैर अर दुसरे तै प्यार राक्खैगा, या एक तै मिल्या रहवैगा अर दुसरे नै छोट्टा जाणैगा। थम परमेसवर अर धन दोनुआ की सेवा न्ही कर सकदे।” ");
INSERT INTO bgc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरीसी जो लोभ्भी थे, ये सारी बात सुणकै, मखौल करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीशु नै उनतै कह्या, “थम तो माणसां कै स्याम्ही खुद नै धर्मी ठहराओ सो, पर परमेसवर थारे मन नै जाणै सै, क्यूँके जो चीज माणसां की निगांह म्ह महान् सै, वा परमेसवर कै लोवै घृणित सै।” ");
INSERT INTO bgc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","जब तक यूहन्ना आया, जिब ताहीं मूसा के नियम-कायदे अर नबी का प्रभाव माणसां पै रह्या। उस बखत तै परमेसवर के राज्य का सुसमाचार सुणाया जाण लागरया सै, अर हरेक उस म्ह तेज्जी तै इसकी ओड़ खिचे आण लागरे सै। ");
INSERT INTO bgc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","अकास अर धरती का टळ जाणा आसान सै, पर नियम-कायदा की हर छोट्टी बात भी पूरी होकै रहवैगी। ");
INSERT INTO bgc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","उदाहरण के तौर पै “जो कोए अपणी घरआळी नै छोड़कै दुसरी तै ब्याह करै सै, वो जारी करै सै, अर जो कोए इसी छोड्डी होई बिरबान्नी तै ब्याह करै सै, वो भी जारी करै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","फेर यीशु नै कह्या, “एक साहूकार माणस था जो बैंजनी अर मलमल के महँगे लत्ते पहरदा अर हरेक दिन ऐसो-आराम तै अर मौज तै रहवैं था। ");
INSERT INTO bgc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","लाजर नाम का एक कंगाल जिसकै घा: होरे थे उसकी देहळी पै छोड़ दिया जावै था। ");
INSERT INTO bgc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","अर वो चाहवै था, के साहूकार के मेज की जूठण तै अपणा पेट भरै, उरै ताहीं के कुत्ते भी आकै उसके घा: नै चाट्या करै थे।” ");
INSERT INTO bgc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","इसा होया के वो कंगाल मरग्या, अर सुर्गदूत्तां नै उस ताहीं लेकै अब्राहम की गोद म्ह पोंहच्या। वो साहूकार भी मारया अर गाड्या गया, ");
INSERT INTO bgc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","साहूकार नरक म्ह गेरया गया, अर नरक की ताड़ना तै दर्द म्ह पड़े होए अपणी निगांह ठाई, दूर तै ए अब्राहम के साथ लाजर ताहीं देख्या। ");
INSERT INTO bgc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","फेर उसनै रुक्का मारकै कह्या, हे पिता अब्राहम, मेरै पै दया करकै लाजर नै भेजदे, ताके वो अपणी आन्गळी का कुणा पाणी म्ह डबोकै मेरी जीभ नै शीळी करै, क्यूँके मै इस आग तै तड़फूं सूं। ");
INSERT INTO bgc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“पर अब्राहम बोल्या, ‘हे बेट्टे, याद कर, के तन्नै अपणी जिन्दगी म्ह बढ़िया तै बढ़िया चीज ले ली सै’, अर उस्से तरियां लाजर नै तुच्छ चीज, पर इब वो उरै सुख अर शान्ति पा रह्या सै, अर तू तड़फ रह्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","इन सबके अलावा म्हारै अर तेरे बिचाळै एक बड़ी खाई ठहराई गई सै, के जो उरै तै तेरी ओड़ आणा चाहवै, वे ना जा सकै, अर ना कोए उड़ै इस पास्सै म्हारै धोरै आ सकै।” ");
INSERT INTO bgc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","साहूकार बोल्या, तो हे पिता, मै तेरे तै बिनती करुँ सूं, के उस ताहीं मेरै बाप कै घरां भेज, ");
INSERT INTO bgc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","क्यूँके मेरे पाँच भाई सै, वो उनकै स्याम्ही इन बात्तां की गवाही दे, इसा ना हो के वे भी दुख की जगहां म्ह आवै। ");
INSERT INTO bgc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहम नै उसतै कह्या, उनकै धोरै तो मूसा के नियम-कायदे, नबी अर नबियाँ की किताब सै, वे उनकी सुणै। ");
INSERT INTO bgc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","साहूकार बोल्या, “न्ही, पिता अब्राहम, पर जै कोए मरे होया म्ह तै उनकै धोरै जावै, तो वे पाप करणा छोड़ देंगे।” ");
INSERT INTO bgc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","अब्राहम नै उसतै कह्या, “जिब वे मूसा नबी अर नबियाँ की न्ही सुणदे, तो जै मरे होया म्ह तै कोए जी भी जा, तोभी उसकी कोनी मान्नैगें।” ");
INSERT INTO bgc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","फेर यीशु नै अपणे चेल्यां तै कह्या, “हो न्ही सकदा के ठोक्कर ना लाग्गै, पर धिक्कार सै, उस माणस पै जिसकै बाबत ठोक्कर लाग्गै सै। ");
INSERT INTO bgc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","पर जो कोए इन छोट्या बाळकां समान जो मेरै पै बिश्वास करै सै, किसे तै भी पाप करवावै तो उसकै खात्तर भला योए सै के एक बड्डी चाक्की का पाट उसकै गळ म्ह लटकाया जावै अर वो समुंदर म्ह गेरया जावै।” ");
INSERT INTO bgc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","सावधान रहों, “जै तेरा बिश्वासी भाई पाप करै तो उसनै समझा, अर जै पछतावै तो उसनै माफ करदे। ");
INSERT INTO bgc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","जै हरेक दिन वो तेरे बिरुध्द म्ह सात बार भी पाप करै, अर सात्तु बार तेरे धोरै आकै कहवै, मै पछताऊँ सूं, तो उसनै माफ करदे।” ");
INSERT INTO bgc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","फेर प्रेरितां नै प्रभु यीशु तै बिनती करी, “के म्हारे बिश्वास नै बढ़ा।” ");
INSERT INTO bgc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभु बोल्या, “जै थमनै राई कै दाणै बराबर भी बिश्वास होन्दा, तो थम इस शहतूत कै दरखत नै कहन्दे के जड़ तै उखड़कै समुन्दर म्ह जा लाग, तो वो थारी मान लेन्दा।” ");
INSERT INTO bgc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","फेर यीशु नै कह्या, “मान ल्यो थारे म्ह तै किसे कै धोरै एक नौक्कर सै जो नौक्कर हळ चलान्दा या भेड़ चरान्दा हो, अर जिब वो खेत तै बोहड़ आवै, तो के थम उसतै कहोंगे, ‘आकै मेरे गैल खाणा खाण बैठ ज्या?’ ");
INSERT INTO bgc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","पर इसके बजाये के वो अपणे नौक्कर न्यू कोनी कहवैगा, ‘मेरे खात्तर खाणा त्यार कर, अर मेरे ताहीं खाणा परोसण खात्तर तैयार हो ज्या, जिब ताहीं मै खाऊँ पीऊँ तब ताहीं मेरी सेवा-पाणी कर, इसकै पाच्छै तू भी खा-पी लिये?’ ");
INSERT INTO bgc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","के वो उस नौक्कर का श्यान मान्नैगा के उसनै वैए काम करे जिसका हुकम दिया सै? ");
INSERT INTO bgc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","इस्से तरियां तै थम भी जिब उन सारे काम्मां नै कर ल्यो जिसका हुकम थारे ताहीं दिया गया सै, तो उस ताहीं कर लेण के बाद थमनै कहणा चाहिये, ‘हम नौक्कर सां, हम किसे बड़ाई के हकदार कोनी हमनै तो बस अपणा फर्ज निभाया सै।’” ");
INSERT INTO bgc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","फेर जिब यीशु यरुशलेम जाण लागरया था तो सामरिया अर गलील परदेस कै बिचाळै की सीमा तै होन्दा होया लिकड्या। ");
INSERT INTO bgc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","तो गाम म्ह बड़दे बखत उसनै दस कोढ़ी मिले वे दूर खड़े थे। ");
INSERT INTO bgc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","वे जोर तै रुक्का मारकै बोल्ले, “हे यीशु, हे माल्लिक, म्हारै पै दया कर!” ");
INSERT INTO bgc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीशु नै उन कान्ही लखाकै कह्या, “यरुशलेम के मन्दर म्ह जाओ, अर खुद नै याजकां ताहीं दिखाओ, ताके वो भी देक्खै के थम ठीक होए सों के न्ही।” अर जान्दे ए जान्दे वे कोढ़ तै मुक्त होग्ये। ");
INSERT INTO bgc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","फेर उन म्ह तै एक न्यू देखकै के मै ठीक होग्या सूं, जोर-जोर तै परमेसवर की बड़ाई करदा होया यीशु कै धोरै बोहड़या, ");
INSERT INTO bgc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","अर यीशु कै पायां पै मुँह कै बळ पड़कै उसका धन्यवाद करण लाग्या, अर वो सामरी था। ");
INSERT INTO bgc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","इसपै यीशु नै कह्या, “के दस कोढ़ी चंगे न्ही होए, तो फेर नौ कित्त सै? ");
INSERT INTO bgc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","के गैर यहूदी नै छोड़ कोए और न्ही लिकड़या जो परमेसवर की बड़ाई करदा?” ");
INSERT INTO bgc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","फेर उसनै उस ताहीं कह्या, “उठकै चल्या जा, तन्नै बिश्वास करया इस खात्तर तू ठीक होग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","फेर फरीसियाँ नै यीशु तै बुझ्झया के परमेसवर का राज्य कद आवैगा, तो उसनै उनतै जवाब दिया, “परमेसवर का राज्य इस ढाळ आवैगा के थम उसनै अपणी आँखां तै न्ही देख सकदे। ");
INSERT INTO bgc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","अर ना ए माणस इसके बारें म्ह न्यू कह सकैगे, देक्खों यो सै परमेसवर का राज्य। क्यूँके परमेसवर का राज्य थारे बिचाळै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","फेर यीशु नै चेल्यां तै कह्या, “वो दिन आवैगा, जिब थम उस दिन नै देखणा चाहोंगे जिब मै माणस का बेट्टा बोहड़ के आऊँगा पर थम उस दिन नै देख न्ही पाओगे।” ");
INSERT INTO bgc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","माणस थारे तै कहवैगें, लखाओ, “मसीहा उड़ै सै!” या लखाओ, “वो आड़ै सै!” पर थम यो सुणकै चले ना जाइयो, अर ना उनकै पाच्छै लागियो। ");
INSERT INTO bgc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","क्यूँके जिस तरियां बिजळी अकास कै एक छोर तै कोंध कै अकास कै दुसरे छोर ताहीं चमकै सै, उस्से तरियां मै माणस का बेट्टा भी अपणे दिनां म्ह जाहिर होऊँगा। ");
INSERT INTO bgc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पर पैहल्या जरूरी सै के मै घणा दुख ठावै, अर इस युग कै माणस मेरे ताहीं नकार देंगें। ");
INSERT INTO bgc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जिसा पूर्वज नूह के दिनां म्ह होया था, उस्से तरियां मुझ माणस के बेट्टे के दिनां म्ह भी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जिस दिन तक नूह जहाज म्ह न्ही चढ़या, उस दिन तक माणस खावै-पीवै थे, अर उन म्ह ब्याह होवै थे। फेर बाढ़ नै उन सारया का नाश करया। ");
INSERT INTO bgc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ठीक याए हालात लूत कै दिनां म्ह होई थी, जिब वो सदोम नगर म्ह रहवै था। माणस खावै-पीवै, लेणा-देणा करदे, दरखत लगान्दे अर घर चिणैं थे, ");
INSERT INTO bgc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पर जिस दिन लूत सदोम तै लिकड़या, उस दिन आग अर गन्धक अकास तै बरसी सारे नगर के माणसां ताहीं नाश कर दिया। ");
INSERT INTO bgc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","यो उस दिन की तरियां होगा जिब मै माणस का बेट्टा बिना बताये आ जाऊँगा। ");
INSERT INTO bgc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“उस दिन जो छात पै हो, अर उसका समान घर म्ह हो, अर वो उसनै लेण खात्तर तळै न्ही उतरैं, अर उस्से तरियां जो खेत्तां म्ह हो, वो पाच्छै न्ही बोहड़ैं। ");
INSERT INTO bgc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","याद राखियों लूत की घरआळी कै गैल के होया था! ");
INSERT INTO bgc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जो कोए अपणी जान बचाणा चाहवै, वो उसनै खोवैगा, अर जो कोए उसनै खोवै वो उसनै जिन्दा राक्खैगा। ");
INSERT INTO bgc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मै थमनै कहूँ सूं, उस रात नै दो माणस एक खाट पै होंगे, एक ठाया जावैगा अर दुसरा छोड़ दिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दो बिरबान्नी एक साथ चाक्की पीसदी होवैगी, एक ठा ली जावैगी अर दुसरी छोड़ दी जावैगी। ");
INSERT INTO bgc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(दो जणे खेत म्ह होंगे, एक ठाया जावैगा अर दुसरा छोड्या जावैगा।)” ");
INSERT INTO bgc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","न्यू सुण उननै उसतै बुझ्झया, “हे प्रभु, यो कित्त होवैगा?” यीशु नै उनतै कह्या, “जड़ै लाश हो सै, उड़ैए चील कठ्ठे होवै सै, उस्से तरियां यो हरेक कोए जाण लेवैगा के यो कित्त होगा।” ");
INSERT INTO bgc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","फेर यीशु नै अपणे चेल्यां तै इसकै बाबत कह्या, के रोज प्रार्थना करणी चाहिये अर हिम्मत न्ही हारनी चाहिये, उनतै यो उदाहरण दिया, ");
INSERT INTO bgc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“किसे नगर म्ह एक न्यायाधीश रहवैं था, जो ना परमेसवर तै डरै था अर ना किसे माणस की परवाह करया करै था। ");
INSERT INTO bgc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","उस्से नगर म्ह एक बिधवा भी रहवैं थी, जो उसकै धोरै आ-आकै कह्या करै थी, मेरा न्याय चुकाकै मन्नै बैरी तै बचा।” ");
INSERT INTO bgc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","कुछ बखत ताहीं तो वो कोनी मान्या पर आखर म्ह मन म्ह सोचकै बोल्या, “ऊंतो मै परमेसवर तै कोनी डरदा, अर ना माणसां की कुछ परवाह करुँ सूं, ");
INSERT INTO bgc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","फेरभी या बिधवा मन्नै कांल राक्खै सै, इस करकै मै उसका न्याय चूकाऊँगा, कदे इसा ना हो के घड़ी-घड़ी आकै आखर म्ह मेरी नास्सा म्ह दम करदे।” ");
INSERT INTO bgc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","प्रभु यीशु नै कह्या, “सुणो, इस अधर्मी न्यायाधीश नै देख के सीखों। ");
INSERT INTO bgc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","के परमेसवर अपणे चुणे होया का न्याय कोनी करैगा, जो दिन-रात उसके नाम की दुहाई देंदे रहवैं सै? के वो उनकी मदद करण म्ह वार लगावैगा? ");
INSERT INTO bgc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","मै थमनै कहूँ सूं, वो जिब्बे उनका न्याय करैगा। फेर भी मै माणस का बेट्टा जिब आऊँगा, तो के मै धरती पै मेरे पै बिश्वास करणीया नै पाऊँगा?” ");
INSERT INTO bgc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","यीशु नै उन माणसां तै यो उदाहरण दिया, जो अपणे बारें म्ह यो सोच्चै थे, के हम धर्मी सां, अर दुसरयां नै नकारै थे। ");
INSERT INTO bgc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“दो माणस मन्दर म्ह प्रार्थना करण नै गए, एक फरीसी था अर दुसरा चुंगी लेण आळा, ");
INSERT INTO bgc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी खड्या होकै अपणे मन म्ह न्यू प्रार्थना करण लाग्या, हे परमेसवर, मै तेरा धन्यवाद करुँ सूं के मै और माणसां की तरियां अन्धेर करण आळा, जुल्मी, अर जार कोनी, अर ना इस चुंगी लेण आळे की तरियां सूं। ");
INSERT INTO bgc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मै हफ्तै म्ह दो बर ब्रत राक्खूँ सूं, मै अपणी सारी आमदणी का दसमां हिस्सा भी तेरे ताहीं देऊँ द्यु सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","पर चुंगी लेण आळे नै दूर खड़े होकै, सुर्ग कै कान्ही निगांह ठाणा भी कोनी चाह्या, बल्के दुखी होकै अपणी छात्त्ती पीट-पीटकै कह्या, “हे परमेसवर, मुझ पापी पै दया कर!” ");
INSERT INTO bgc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“बिश्वास करो वास्तव म्ह योए चुंगी लेण आळा माणस (परमेसवर की ओड़ तै) धर्मी ठहराया जाकै घरां गया, ना के वो फरीसी माणस। क्यूँके जो कोए अपणे-आपनै बड्ड़ा बणावैगा, वो छोट्टा करया जावैगा, अर जो कोए अपणे-आपनै छोट्टा बणावैगा, वो बड्ड़ा करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","फेर माणस अपणे बाळकां नै भी उसकै धोरै ल्याण लाग्गे के वो उनपै हाथ धरै, पर चेल्यां नै देख उन ताहीं धमकाया। ");
INSERT INTO bgc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","यीशु नै बाळकां ताहीं धोरै बुलाकै कह्या, “बाळकां नै मेरै धोरै आण द्यो अर उननै रोक्को मतना: क्यूँके परमेसवर का राज्य इसाए का सै। ");
INSERT INTO bgc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मै थमनै सच कहूँ सूं के जो कोए परमेसवर कै राज्य नै बाळक की तरियां कोनी अपणावै वो उस म्ह कदे न्ही बड़ सकदा।” ");
INSERT INTO bgc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","किसे सरदार नै उसतै बुझ्झया, “हे उत्तम गुरु, अनन्त जीवन का हकदार होण खात्तर मै के करुँ?” ");
INSERT INTO bgc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीशु नै उसतै कह्या, “तू मन्नै उत्तम क्यांतै कहवै सै? कोए उत्तम कोनी, सिर्फ एक, यानिके परमेसवर। ");
INSERT INTO bgc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तन्नै हुकमां का तो बेराए सै: ‘जारी ना करिये, खून ना करिये, अर चोरी ना करिये, अर झूठ्ठी गवाही ना दियो, अपणे माँ-बाप का आदर करियो।’” ");
INSERT INTO bgc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","उसनै कह्या, “मै तो इन सारया नै बाळकपण तै ए मान्दा आऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","न्यू सुणकै यीशु नै उसतै कह्या, “तेरे म्ह इब भी एक बात की कमी सै, अपणा सब कुछ बेचकै कंगालां ताहीं बांड दे, अर तन्नै सुर्ग म्ह धन मिलैगा, अर आकै मेरा चेल्ला बणण खात्तर मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","वो न्यू सुणकै घणा उदास होया, क्यूँके वो घणा साहूकार था। ");
INSERT INTO bgc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीशु नै उस ताहीं देखकै कह्या, “साहूकारां का परमेसवर कै राज्य म्ह बड़णा कितना ओक्खा सै। ");
INSERT INTO bgc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","जिस तरियां तै ऊँट का सूई कै मोरै म्ह तै लिकड़णा मुश्किल सै। उस्से तरियां परमेसवर के राज्य साहूकार का बड़णा भी मुश्किल सै।” ");
INSERT INTO bgc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","इसपै सुणण आळा नै कह्या, “तो फेर किसका उद्धार हो सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","उसनै कह्या, “जो माणसां तै न्ही हो सकदा वो परमेसवर तै हो सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","पतरस नै कह्या, “लखा, हम तो घर-बार छोड़कै तेरे पाच्छै हो लिये सां।” ");
INSERT INTO bgc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","उसनै उनतै कह्या, “मै थमनै साच्ची-साच कहूँ सूं के इसा कोए कोनी जिसनै परमेसवर के राज्य कै खात्तर घर, या घरआळी, भाई, या माँ-बाप, या बाळ-बच्चे ताहीं छोड़ दिया हो, ");
INSERT INTO bgc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","अर इस बखत कई गुणा घणा न्ही पावै अर परलोक म्ह अनन्त जीवन।” ");
INSERT INTO bgc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","फेर उसनै बारहां चेल्यां ताहीं गैल लेकै उनतै कह्या, “देक्खो, हम यरुशलेम नगर म्ह जावां सां, अर जितनी बात मुझ माणस कै बेट्टे खात्तर नबियाँ नै लिक्खी होई सै, वे सारी पूरी होवैगी। ");
INSERT INTO bgc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","क्यूँके मै गैर यहूदियाँ कै हाथ्थां म्ह सौप्या जाऊँगा, अर मेरा मजाक उड़ावैगें, मेरी बेजती करैंगें, अर मेरे पै थूकैगें, ");
INSERT INTO bgc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","अर मेरै कोड़े मारैगें, अर मन्नै छेतैगें अर मार देवैगें, अर मै तीसरे दिन जिन्दा हो जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","पर उननै इन बात्तां म्ह तै कोए बात न्ही समझी, अर या बात उनतै लुक्ही रही, अर जो कह्या गया था वो उनकी समझ कोनी आया। ");
INSERT INTO bgc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जिब वो यरीहो नगर कै लोवै पोंहच्या, तो एक आन्धा सड़क कै किनारे बेठ्या होया भीख माँगण लागरया था। ");
INSERT INTO bgc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","वो भीड़ कै चाल्लण की आवाज सुणकै बुझण लाग्या, “यो के होरया सै?” ");
INSERT INTO bgc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","उननै उसतै बताया, “यीशु नासरी जाण लागरया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","फेर उसनै रुक्का मारकै कह्या, “हे यीशु, दाऊद की ऊलाद, मेरै पै दया कर!” ");
INSERT INTO bgc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","जो आग्गै-आग्गै जाण लागरे थे, वे उसनै धमकाण लाग्ये के बोल-बाल्ला रहै, पर वो और भी रुक्का मारण लाग्या, “हे दाऊद की ऊलाद, मेरै पै दया कर!” ");
INSERT INTO bgc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","फेर यीशु नै खड़े होकै हुकम दिया के उसनै मेरै धोरै ल्याओ, अर जिब वो धोरै आया तो उसनै उसतै बुझ्झया, ");
INSERT INTO bgc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“तू के चाहवै सै के मै तेरे खात्तर करुँ?” उसनै कह्या, “हे प्रभु, योए के मै देक्खण लाग्गू।” ");
INSERT INTO bgc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीशु नै उसतै कह्या, “देक्खण लाग, तेरे बिश्वास नै तेरे ताहीं ठीक करया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","फेर वो जिब्बे देखण लाग्या अर परमेसवर की बड़ाई करदा होया उसकै पाच्छै हो लिया, अर सारे आदमियाँ नै देखकै परमेसवर की जै-जै कार करी। ");
INSERT INTO bgc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यीशु यरीहो नगर म्ह बड़ण लागरया था। ");
INSERT INTO bgc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ओड़ै जक्कई नाम का एक माणस था जो चुंगी लेण आळा का सरदार, अर साहूकार था। ");
INSERT INTO bgc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","वो यीशु नै देखणा चाहवै था के वो कौण सै। पर भीड़ कै कारण देख न्ही सकै था, क्यूँके वो बोन्ना था। ");
INSERT INTO bgc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","फेर उस ताहीं देक्खण खात्तर वो आग्गै भाजकै गुलर कै दरखत पै चढ़ग्या, क्यूँके यीशु नासरी उस्से राह तै जाण आळा था। ");
INSERT INTO bgc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जिब यीशु नासरी उसकै धोरै आया, तो उप्पर लखाकै उसनै कह्या, “हे जक्कई, तोळा उतरया, क्यूँके आज मन्नै तेरे घरां जरुर रहणा सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","वो दरखत तै उतरकै राज्जी होकै यीशु नै अपणे घरां लेग्या। ");
INSERT INTO bgc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","न्यू देखकै सारे माणस बरड़ाण लाग्गे, “वो तो एक पापी माणस कै घरां रुकरया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जिब यीशु जक्कई के घर खाणा खाण लागरया था तो जक्कई नै खड़े होकै प्रभु तै कह्या, “हे प्रभु यीशु, देख, मै अपणी आध्धी सम्पत्ति कंगालां नै द्यु सूं, अर किसे का कुछ भी जुल्म करकै ले लिया सै तो उस ताहीं चौगुणा बोहड़ा द्यु सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","फेर यीशु नै उसतै कह्या, “आज इस घर के माणसां पै उद्धार आया सै, इस करकै के यो भी अब्राहम के वंश तै सै। ");
INSERT INTO bgc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","मै माणस का बेट्टा खोए होया नै टोह्ण अर उनका उद्धार करण आया सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जिब वे ये बात सुणै थे, तो यीशु नै एक उदाहरण देकै कह्या, इस करकै के वो यरुशलेम कै धोरै था, अर वे समझै थे के परमेसवर का राज्य इब्बे जाहिर होण आळा सै। ");
INSERT INTO bgc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","आखर उसनै कह्या, “एक साहूकार माणस दूर देश तै चल्या के राजपद पाकै बोहड़ै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","उसनै अपणे नौकरां म्ह तै दस ताहीं बुलाकै उन ताहीं दस मोंहर दी अर उनतै कह्या, “मेरै बोहड़ण ताहीं लेण-देण करियो।” ");
INSERT INTO bgc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","पर उसकै नगर के बासिन्दे उसतै बैर राक्खै थे, अर उसकै पाच्छै दूत्तां तै कुह्वा भेज्या, “हम न्ही चाह्न्दे के यो म्हारै पै राज करै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“जिब माल्लिक राजपद पाकै बोहड़या, तो इसा होया के उसनै अपणे नौकरां ताहीं जिन ताहीं रपिये दिये थे, अपणे धोरै बुलाया ताके बेरा करै के उननै लेण-देण म्ह के-के कमाया।” ");
INSERT INTO bgc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","फेर पैहल्ड़े नै आकै कह्या, “हे माल्लिक, तेरी मोंहर तै दस और मोंहर कमाई सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","उसनै उसतै कह्या, “शाबाश, हे आच्छे नौक्कर! तू घणेए थोड़े म्ह भरोसमंद लिकड़या इब दस नगरां का हक राख।” ");
INSERT INTO bgc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दुसरे नौक्कर नै आकै कह्या, “हे माल्लिक, तेरी मोंहर तै पाँच और मोंहर कमाई सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","माल्लिक नै उसतै कह्या, “तू भी पाँच नगरां पै हाकिम होज्या।” ");
INSERT INTO bgc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तीसरे नौक्कर नै आकै कह्या, “हे माल्लिक, देख, तेरी मोंहर या सै: जिस ताहीं मन्नै अंगोच्छे म्ह जुड़ राक्खी थी। ");
INSERT INTO bgc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","क्यूँके मै तेरे तै डरुँ था, इस करकै के तू कठोर माणस सै: जो तन्नै न्ही धरया उसनै ठा ले सै, अर जो तन्नै न्ही बोया, उस ताहीं काट्टै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","माल्लिक नै उसतै कह्या, “हे दुष्ट नौक्कर, मै तेरैए मुँह तै तन्नै कसूरवार ठहराऊँ सूं। जिब तन्नै मेरा बेरा सै के करड़ा माणस सूं, जो मन्नै न्ही धरया उसनै ठा ल्यु सूं, अर जो मन्नै न्ही बोया, उस ताहीं काट्टू सूं, ");
INSERT INTO bgc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तो तन्नै मेरे रपिये सर्राफां कै धोरै क्यातै कोनी धरे के मै आकै ब्याज सुधां ले लेन्दा?” ");
INSERT INTO bgc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","अर जो माणस धोरै खड़े थे, उसनै उनतै कह्या, “वा मोंहर उसतै ले ल्यो, अर जिसकै धोरै दस मोंहर सै उसनै दे द्यो।” ");
INSERT INTO bgc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","उननै उसतै कह्या, “हे माल्लिक, उसकै धोरै दस मोंहर तो सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“मै थमनै कहूँ सूं के जिसकै धोरै सै, उस ताहीं दिया जावैगा, अर जिसकै धोरै न्ही सै, उसतै वो भी जो उसकै धोरै सै ले लिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पर मेरे उन बैरियाँ ताहीं जो न्ही चाहवैं थे के मै उनपै राज करुँ, उन ताहीं उरै ल्याकै मेरै स्याम्ही घात करो।” ");
INSERT INTO bgc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ये बात कहकै यीशु यरुशलेम नगर कै कान्ही चेल्यां कै आग्गै-आग्गै चाल्या। ");
INSERT INTO bgc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","जिब वो जैतून नामक पहाड़ पै बैतफगे अर बैतनिय्याह गाम कै धोरै पोंहच्या, तो उसनै अपणे चेल्यां म्ह तै दोयां ताहीं न्यू कहकै भेज्या, ");
INSERT INTO bgc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“स्याम्ही के गाम म्ह जाओ, अर उस म्ह पोहोचदये एक गधी का बच्चा जिसपै कोए कदे न्ही बेठ्या हो, बन्धया होड़ थमनै मिलैगा, उसनै खोल कै लियाओ। ");
INSERT INTO bgc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","जै थारे तै कोए बुझ्झै के क्यातै खोल्लो सो, तो कहियो के प्रभु नै इसकी जरूरत सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जो भेज्जै गए थे, उननै जाकै जिसा यीशु नै कह्या था, उस्से तरियां पाया। ");
INSERT INTO bgc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जिब वे गधी कै बच्चे नै खोल्लै रहे थे, तो उसके मालिकां नै उनतै बुझ्झया, “इस बच्चे नै क्यांतै खोल्लो सो?” ");
INSERT INTO bgc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","चेल्यां नै कह्या, “प्रभु नै इस ताहीं काम म्ह ल्याणा सै।” ");
INSERT INTO bgc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","वे उसनै यीशु कै धोरै लियाए, अर अपणे लत्ते उस गधी के बच्चे पै गेरकै यीशु ताहीं उसपै बिठा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","जिब वो जाण लागरया था, तो वे अपणे लत्ते राह म्ह बिछान्दे जावै थे। ");
INSERT INTO bgc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","यरुशलेम नगर कै धोरै आन्दे होए जिब यीशु जैतून पहाड़ की ढलाण पै पोंहच्या, तो चेल्यां का सारा टोळ उन सारे सामर्थ के काम्मां कै कारण जो उननै देक्खे थे, राज्जी होकै जोर तै परमेसवर की जय-जयकार करण लाग्गे ");
INSERT INTO bgc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“धन्य सै वो राजा, जो प्रभु कै नाम तै आवै सै! सुर्ग म्ह शान्ति अर अकास मण्डप म्ह महिमा हो!” ");
INSERT INTO bgc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","फेर भीड़ म्ह तै कुछ फरीसी यीशु तै कहण लाग्गे, “हे गुरु, इस बात के कारण अपणे चेल्यां नै धमका।” ");
INSERT INTO bgc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","उसनै जवाब दिया, “मै थमनै कहूँ सूं, जै ये बोल-बाल्ले रहे तो स्तुति इन पत्थरां तै लिकड़ण लाग्गैगी।” ");
INSERT INTO bgc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","जिब यीशु यरुशलेम नगर कै धोरै आया तो नगर नै देखकै माणसां खात्तर रोया ");
INSERT INTO bgc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","अर बोल्या, “कितना भला होन्दा के तू, हाँ, तू ए आज इतणाए समझ लेन्दा की परमेसवर के साथ शान्ति का के मतलब सै, पर यो तेरे तै लह्को के राख्या गया सै। ");
INSERT INTO bgc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","क्यूँके वे दिन तेरे म्ह आवैगें के तेरे बैरी मोर्चा बाँधकै तन्नै घेर लेवैगें, अर चौगरदे तै तन्नै दबावैंगें ताके थारा राह बन्द होज्या, ");
INSERT INTO bgc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","अर तेरा बैरी तन्नै अर तेरे बाळकां ताहीं जो तेरे म्ह सै, माट्टी म्ह मिलावैंगें, अर तेरे म्ह पत्थर पै पत्थर भी कोनी रहवैगा, जो गेरया ना जावैगा, क्यूँके तन्नै उस मौक्कै ताहीं जिब तेरे पै दया की निगांह होई थी तो तन्नै कोनी पिच्छाणा।” ");
INSERT INTO bgc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","फेर वो मन्दर म्ह जाकै समान बेचण आळा ताहीं बाहरणै लिकाड़ण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","अर उनतै कह्या, “पवित्र शास्त्र म्ह लिख्या सै, ‘मेरा घर प्रार्थना का घर होगा,’ पर थमनै इस ताहीं डाकुआं की गुफा बणा दिया।” ");
INSERT INTO bgc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","वो हरेक दिन मन्दर म्ह उपदेश दिया करै था, अर प्रधान याजक अर शास्त्री अर माणसां के मुखिया उसका नाश करण का मौक्का टोह्वैं थे। ");
INSERT INTO bgc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","पर कोए जुगाड़ कोनी काढ सकै थे, के यो किस तरियां करा, क्यूँके सारे माणस घणे चाह तै उसकी सुणै थे। ");
INSERT INTO bgc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक दिन इसा होया के जिब यीशु मसीह मन्दर म्ह माणसां नै उपदेश देवै था अर सुसमाचार सुणावै था, तो प्रधान याजक अर शास्त्री, यहूदी अगुवां कै गेल्या धोरै आकै खड़े होए, ");
INSERT INTO bgc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","अर कहण लाग्गे, “म्हारै ताहीं बता, तू इन काम्मां नै किसकै हक तै करै सै, अर वो कौण सै जिसनै तेरे ताहीं यो हक दिया सै?” ");
INSERT INTO bgc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","उसनै उनतै कह्या, “मै भी थारे तै एक बात बुझ्झु सूं, मन्नै बताओ। ");
INSERT INTO bgc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्ना का बपतिस्मा सुर्ग की ओड़ था या माणसां की ओड़ तै था?” ");
INSERT INTO bgc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","फेर वे आप्पस म्ह कहण लाग्गे, “जै हम कह्वां, ‘सुर्ग की ओड़,’ तो वो कहवैगा, ‘फेर थमनै उसका बिश्वास क्यांतै न्ही करया?’ ");
INSERT INTO bgc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","अर जै हम कह्वां, ‘माणसां की ओड़,’ तो सारे माणस म्हारै पै पत्थर बरसावैगें, क्यूँके सारे जाणै सै के यूहन्ना साच्चीये नबी था।” ");
INSERT INTO bgc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","आखर उननै जवाब दिया, “हमनै न्ही बेरा के वो किस ओड़ तै था।” ");
INSERT INTO bgc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","यीशु नै उनतै कह्या, “तो मै भी कोनी बतान्दा के मै ये काम किस हक तै करुँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","फेर वो माणसां तै यो उदाहरण कहण लाग्या: “किसे माणस नै अंगूर का बाग लगाया, अर किसानां तै उसनै ठेक्का दे दिया अर घणे दिनां खात्तर परदेस चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","जिब बखत आया तो उसनै किसानां कै धोरै एक नौक्कर ताहीं भेज्या के वे अंगूर के बाग के कुछ फळां का हिस्सा उसनै देवै, पर किसानां नै उस ताहीं छेतकै रित्ते हाथ्थां बोहड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","फेर उसनै एक और नौक्कर ताहीं भेज्या, अर उननै उस ताहीं भी छेतकै अर उसकी बेजती करकै रित्ते हाथ्थां बोहड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","फेर उसनै तीसरा भेज्या, उननै उस ताहीं भी घायल करकै लिकाड़ दिया।” ");
INSERT INTO bgc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","फेर अंगूर के बाग कै माल्लिक नै कह्या, “मै के करुँ? मै अपणे प्यारे बेट्टे नै भेज्जूगा, हो सकै सै वे उसकी इज्जत करै।” ");
INSERT INTO bgc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","जिब किसानां नै उस ताहीं देख्या तो आप्पस म्ह विचार करण लाग्गे, “यो तो वारिस सै, आओ, हम इसनै मार दया के विरासत म्हारी हो जावै।” ");
INSERT INTO bgc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","अर उननै उस ताहीं अंगूर के बाग तै बाहरणै लिकाड़कै मार दिया। इस करकै अंगूर के बाग का माल्लिक उनकै गेल्या के करैगा? ");
INSERT INTO bgc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","वो आकै उन किसानां का नाश करैगा, अंगूर के बाग औरां नै सोपैगा। न्यू सुणकै उननै कह्या, “परमेसवर करै इसा ना हो।” ");
INSERT INTO bgc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","उसनै उनकी ओड़ देखकै कह्या, फेर यो के लिख्या सै: “जिस पत्थर नै राजमिस्त्रियाँ नै निकम्मा ठहराया था, वोए कोणे का सिरा होग्या। ");
INSERT INTO bgc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“जो कोए उस पत्थर पै पड़ैगा वो चकणाचूर हो ज्यागा, अर जिसपै वो पड़ैगा, उसनै पिस देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","उस्से बखत शास्त्रियाँ अर प्रधान याजकां नै उस ताहीं पकड़णा चाह्या, क्यूँके वे समझगे थे के उसनै म्हारै पै यो उदाहरण कह्या, पर वे माणसां तै डरगे। ");
INSERT INTO bgc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","अर वे उसकी टाह म्ह लाग्गे अर भेदिए भेज्जै के धर्म का भेष धरकै उसकी कोए ना कोए बात पकड़ै, ताके उस ताहीं राज्यपाल कै हाथ अर अधिकार म्ह सौंप दें। ");
INSERT INTO bgc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","उननै उसतै न्यू बुझ्झया, “हे गुरु, हमनै बेरा सै के तू ठीक कहवै अर सिखावै भी सै, अर किसे की मेरै कोनी लेन्दा, बल्के परमेसवर की राह सच्चाई तै बतावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","के म्हारा कैसर तै चुंगी देणा ठीक सै या कोनी?” ");
INSERT INTO bgc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","उसनै उनकी श्याणपत ताहीं ताड़कै उनतै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“एक दीनार (एक दिन की मजदूरी) मन्नै दिखाओ। इसपै किसकी छाप अर नाम सै?” उननै कह्या, “कैसर का।” ");
INSERT INTO bgc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","उसनै उन ताहीं कह्या, “तो जो कैसर का सै, वो कैसर नै द्यो, अर जो परमेसवर का सै, वो परमेसवर नै द्यो।” ");
INSERT INTO bgc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","वे माणसां कै स्याम्ही इस बात म्ह उसनै पकड़ कोनी सके, बल्के उसकै जवाब तै हैरान होकै बोल-बाल्ले रहगे। ");
INSERT INTO bgc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","फेर सदूकी जो कहवै सै के मरे होया का जिन्दा होणा सै ए कोनी उन म्ह तै कुछ नै उसकै धोरै आकै बुझ्झया, ");
INSERT INTO bgc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“हे गुरु, मूसा नबी नै म्हारै खात्तर यो लिख्या सै: जै किसे का भाई अपणी घरआळी कै रहन्दे बेऊलादा मर जावै, तो उसका भाई उसकी घरआळी तै ब्याह करले, अर अपणे भाई कै खात्तर पीढ़ी पैदा करै। ");
INSERT INTO bgc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","सात भाई थे, पैहल्ड़ा भाई ब्याह करकै बेऊलादा मरग्या। ");
INSERT INTO bgc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","फेर दुसरे ");
INSERT INTO bgc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","अर तीसरे नै भी उस बिरबान्नी तै ब्याह कर लिया। इस तरियां तै सात्तु बेऊलादे मरगे। ");
INSERT INTO bgc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","आखर म्ह वा बिरबान्नी भी मरगी। ");
INSERT INTO bgc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","आखर म्ह जिन्दा होण पै वा उन म्ह तै किसकी घरआळी होवैगी, क्यूँके वा सातुवां की घरआळी हो ली थी।” ");
INSERT INTO bgc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीशु नै उनतै कह्या, “इस युग की ऊलादां म्ह ब्याह होवै सै, ");
INSERT INTO bgc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पर जो माणस इस जोग्गे ठहरैगें के उस युग नै अर मरे होया म्ह तै जिन्दा उठ्ठणके पद नै पा लेवै, उन म्ह ब्याह शादी कोनी होन्दी। ");
INSERT INTO bgc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","वे दुबारै मरण के भी कोनी, क्यूँके वे सुर्गदूत्तां की ढाळ होवैगें, अर पुनरुत्थान की ऊलाद होणे तै परमेसवर की भी ऊलाद होवैगें। ");
INSERT INTO bgc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","पर इस बात ताहीं के मरे होए जिन्दा होवै सै, मूसा नबी नै भी झाड़ी की कहाँनी म्ह दिखाया सै के वो प्रभु ताहीं ‘अब्राहम का परमेसवर, अर इसहाक का परमेसवर अर याकूब का परमेसवर कहवै सै।’ ");
INSERT INTO bgc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","परमेसवर तो मुर्दा का कोनी पर जिन्दा का परमेसवर सै: क्यूँके उसकै लोवै सारे जिन्दे सै।” ");
INSERT INTO bgc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","फेर न्यू सुणकै शास्त्रियाँ म्ह तै कुछ नै न्यू कह्या, “हे गुरु, तन्नै ठीक कह्या।” ");
INSERT INTO bgc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","अर उननै दुबारै उसतै कुछ और बुझ्झण की हिम्मत कोनी करी। ");
INSERT INTO bgc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","फेर उसनै उनतै बुझ्झया, “मसीह नै दाऊद की ऊलाद किस तरियां कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","दाऊद खुदे भजन संहिता की किताब म्ह कहवै सै: ");
INSERT INTO bgc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","प्रभु नै मेरै प्रभु तै कह्या, “मेरै सोळे कान्ही बैठ, जिब ताहीं के मै तेरे बैरियाँ तेरे पायां म्ह न्ही झुका दियुँ।” ");
INSERT INTO bgc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाऊद तो उसनै प्रभु कहवै सै, “तो फेर वो उसकी ऊलाद किस ढाळ होया?” ");
INSERT INTO bgc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","जिब सारे सुणै थे, तो उसनै अपणे चेल्यां तै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“शास्त्रियाँ तै चौकन्ने रहियो, जिनताहीं लाम्बे-लाम्बे चोगे पहरकै हांडणा आच्छा लाग्गै सै, अर जिन नै बजारां म्ह नमस्कार, अर आराधनालयाँ म्ह खास बैठणा अर जिम्मण म्ह खास जगहां प्यारी लाग्गै सै। ");
INSERT INTO bgc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","वे बिधवायाँ के घर खा जावै सै, अर दिखाण खात्तर घणी वार ताहीं प्रार्थना करदे रहवै सै: ये घणा दण्ड पावैगें।” ");
INSERT INTO bgc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","फेर उसनै निगांह ठाकै सहूकारां ताहीं अपणा-अपणा दान भण्डार म्ह घालदे देख्या। ");
INSERT INTO bgc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","उसनै एक कंगाल बिधवा ताहीं भी उस म्ह दो दमड़ी (जो एक धेले कै बराबर होवै सै) घालदे देख्या। ");
INSERT INTO bgc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","फेर उसनै कह्या, “मै थमनै सच कहूँ सूं के इस कंगाल बिधवा नै सारया तै बाध घाल्या सै। ");
INSERT INTO bgc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","क्यूँके उन सारया नै अपणी-अपणी बढ़दी म्ह तै दान म्ह कुछ घाल्या सै, पर इसनै अपणी घटी म्ह तै अपणी सारी कमाई घाल्ली सै।” ");
INSERT INTO bgc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जिब घणखरे माणस मन्दर कै बाबत कहरे थे के वो किसे सुथरे पत्थरां अर भेटां की चिज्जां तै समारया गया सै, तो उसनै कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“वे दिन आवैगें, जिन म्ह यो सारा जिन नै थम देक्खो सो, उन म्ह तै उरै किसे पत्थर पै पत्थर भी कोनी रहवैगा, जो गेरया न्ही जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","उननै उसतै बुझ्झया, “हे गुरु, यो सारा कद होवैगा? अर ये बात जिब पूरी होण पै होवैगी, तो उस बखत की के निशान्नी होवैगी?” ");
INSERT INTO bgc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","उसनै कह्या, “चौकन्ने रहियो के भकाए ना जाओ, क्यूँके घणखरे मेरै नाम तै आकै कहवैगें, ‘मै वोए सूं,’ अर न्यू भी के, ‘बखत लोवै आण पोंहच्या सै।,’ थम उनकै पाच्छै ना चले जाइयो। ");
INSERT INTO bgc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जिब थम रोळे अर झगड़े का जिक्र सुणो तो घबराईयो ना, क्यूँके इनका पैहल्या होणा जरूरी सै, पर उस बखत जिब्बे खात्मा कोनी होवैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","फेर उसनै उनतै कह्या, “जात पै जात अर राज्य पै राज्य चढ़ाई करैगा, ");
INSERT INTO bgc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","अर बड़े-बड़े हाल्लण आवैगें, अर जगहां-जगहां अकाळ अर महामारियाँ पड़ैंगी, अर अकास म्ह खतरनाक बात अर बड़े-बड़े निशान जाहिर होवैगें।” ");
INSERT INTO bgc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","पर इन सारी बात्तां तै पैहल्या मेरै नाम कै बाबत थमनै पकड़ैगें, अर कांल करैगें, अर आराधनालयाँ म्ह सौपैगें, अर जेळ म्ह गिरवावैंगे, राज्यपालों अर राजयां कै स्याम्ही ले जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","पर यो थारे खात्तर गवाही देण का मौक्का हो जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","इस करकै अपणे-अपणे मन म्ह ठान ल्यो के हम पैहल्या तै जवाब देण की फिक्र कोनी करागें। ");
INSERT INTO bgc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","क्यूँके मै थारे ताहीं इसा बोल अर समझ दियुँगा के थारे सारे बिरोधी सामना या खण्डन कोनी कर सकैगें। ");
INSERT INTO bgc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","थारे माँ-बाप, अर भाई अर कुण्बा, अर साथी भी थमनै पकड़वावैगें, उरै ताहीं के थारे म्ह तै कईयाँ नै मरवा देवैगें। ");
INSERT INTO bgc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मेरै नाम कै कारण सारे माणस थारे तै बैर राक्खैगें। ");
INSERT INTO bgc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","पर थारे सिर का एक बाळ भी बाँका कोनी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","अपणे धीरज तै थम अपणी जान नै बचाए राक्खोगे। ");
INSERT INTO bgc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“जिब थम यरुशलेम की पलटन तै घिरया होया देक्खो, तो जाण लियो के उसका उजड़ जाणा लोवै सै। ");
INSERT INTO bgc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","फेर जो यहूदिया परदेस म्ह हों पहाड़ां पै भाज जावै, अर जो यरुशलेम नगर कै भीत्त्तर हों वे बाहरणै लिकड़ जावै, अर जो गाम्मां म्ह हों वे उस म्ह न्ही जावै। ");
INSERT INTO bgc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","क्यूँके ये बदला लेण के इसे दिन होंगे, जिन म्ह लिक्खी होई सारी बात पूरी हो जावैगी। ");
INSERT INTO bgc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","उन दिनां म्ह जो गर्भवती अर दूध पिलान्दी बिरबान्नी होवैगीं, उनकै खात्तर भागणा भी मुश्किल होगा! क्यूँके देश म्ह बड्ड़ा क्ळेश अर इन माणसां पै बड्ड़ा प्रकोप होवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","वे तलवार की कौर हो जावैंगे, अर सारे देश कै माणसां म्ह कैदी होकै पोहुचाये जावैंगे, अर जिब ताहीं गैर यहूदी का बखत पूरा कोनी होवै, जद ताहीं यरुशलेम गेरजात्तां तै रोंद्या जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“सूरज, चाँद, अर तारां म्ह निशान्नी दिखैगी, अर धरती पै देश-देश के आदमियाँ पै संकट होगा, क्यूँके वे समुन्दर कै गरजण अर लहरां के रोळें तै घबरां जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","भय कै कारण अर दुनिया पै आण आळी घटनायां की बाट देखदे-देखदे माणसां कै जी म्ह जी कोनी रहवैगा, क्यूँके अकास की शक्तियाँ हलाई जावैगी। ");
INSERT INTO bgc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","फेर वे माणस के बेट्टे नै सामर्थ अर बड्डी महिमा कै गेल्या बादळां पै आन्दे देखैगें। ");
INSERT INTO bgc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जिब ये बात होण लाग्गै, तो सीध्धे होकै अपणे सिर उप्पर ठाईयो, क्यूँके थारा छुटकारा लोवै होगा।” ");
INSERT INTO bgc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","यीशु नै उनतै एक उदाहरण देकै कह्या, “अंजीर के दरखत अर सारे दरखतां नै देक्खो। ");
INSERT INTO bgc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ज्योए उन म्ह कोंपले लिकड़ै सै, तो थम खुद जाण ल्यो सो, के गर्मी का बखत लोवै सै। ");
INSERT INTO bgc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","इस तरियां तै जिब थम ये बात होन्दे देक्खो, तो जाण ल्यो के परमेसवर का राज्य लोवै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","मै थमनै साच्ची कहूँ सूं के जिब ताहीं ये सारी बात न्ही हो ले, जद तक इस पीढ़ी का कदे भी अन्त कोनी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","धरती अर अकास टळ जावैंगे, पर मेरी बात कदे न्ही टळैगी। ");
INSERT INTO bgc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“इस करकै चौकन्ने रहियो, इसा ना हो के थारा मन खुमार, अर मतवालेपण, अर इस जिन्दगी की फिक्र तै सुस्त हो जावै, अर वो दिन थारे पै फन्दे की ढाळ चाणचक आण पड़ै। ");
INSERT INTO bgc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","क्यूँके वो सारी धरती के सारे बासिन्दा पै इस तरियां आण पड़ैगा। ");
INSERT INTO bgc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","इस करकै जागदे रहो अर हर बखत प्रार्थना करदे रहो के थम इन सारी आण आळी घटनायां तै बचण अर माणस के बेट्टे कै स्याम्ही खड़े होण कै जोग्गे बण सको।” ");
INSERT INTO bgc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","वो दिन म्ह मन्दर म्ह उपदेश देवै था, अर रात नै बाहरणै जाकै जैतून नामक पहाड़ पै रह्या करै था, ");
INSERT INTO bgc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","अर सबेरै नै तड़कै सारे माणस उसकी सुणण की खात्तर मन्दर म्ह उसकै धोरै आया करै थे। ");
INSERT INTO bgc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","अखमीरी रोट्टी का त्यौहार जो फसह कुह्वावै सै, धोरै था, ");
INSERT INTO bgc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","अर प्रधान याजक अर शास्त्री इस बात की टोह् म्ह थे। के यीशु नै किस तरियां मारै, पर वे माणसां तै डरै थे। ");
INSERT INTO bgc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","फेर शैतान यहूदा म्ह बडग्या, जो इस्करियोती कुह्वावै अर बारहां चेल्यां म्ह गिण्या जावै था। ");
INSERT INTO bgc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","उसनै जाकै प्रधान याजकां अर पहरेदार के सरदारां के गेल्या बातचीत करी के किस तरियां यीशु नै उनके हाथ पकड़वांवां। ");
INSERT INTO bgc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","वे राज्जी होए, अर उस ताहीं रुपिये देण का वादा किया। ");
INSERT INTO bgc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","वो मान ग्या अर मौक्का टोह्ण लाग्या के जिब भीड़ न्ही हो तो उसनै उनके हाथ पकड़वा दे। ");
INSERT INTO bgc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","फेर अखमीरी रोट्टी कै त्यौहार का दिन आया, जिसम्ह फसह का मेम्‍ना बलि करणा जरूरी था। ");
INSERT INTO bgc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","यीशु नै पतरस अर यूहन्ना ताहीं यो कहकै भेज्या, “जाकै म्हारै खाण खात्तर फसह त्यार करो।” ");
INSERT INTO bgc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","उननै यीशु तै बुझया, “तू कित्त चाहवै सै के हम उसनै त्यार करा?” ");
INSERT INTO bgc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","यीशु नै चेल्यां ताहीं कह्या, देक्खो, नगर म्ह बड्तेए एक आदमी पाणी का पैंढ़ा ठाए होए थमनै मिलैगा, जिस घर म्ह वो जावै थम उसके पाच्छै चले जाइयो, ");
INSERT INTO bgc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","अर उसके घर के माल्लिक तै कहियो, “गुरु तेरे तै बुझ्झै सै के वा बैठक कित्त सै जिस म्ह मै अपणे चेल्यां के गेल्या फसह खाऊँ?” ");
INSERT INTO bgc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","वो थमनै एक सजी-सजाई बड़ी अटारी दिखा देवैगा, ओड़ैए त्यारी करियो। ");
INSERT INTO bgc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","उननै जाकै, जिसा उसनै उनतै कह्या था, उस्से तरियां पाया अर फसह का भोज त्यार करया। ");
INSERT INTO bgc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जद वा घड़ी आगी, के यीशु प्रेरितां गेल्या खाणा खाण बेठ्या। ");
INSERT INTO bgc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","अर उसनै उन ताहीं कह्या “मन्नै बड़ी लालसा थी के मरण तै पैहल्या यो फसह भोज थारे गेल्या खाऊँ। ");
INSERT INTO bgc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","क्यूँके मै थमनै सच कहूँ सूं के मै इसनै जिब तक न्ही खाऊँगा जब तक यो परमेसवर के राज्य म्ह पूरा न्ही हो।” ");
INSERT INTO bgc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","फेर उसनै अंगूरां के रस का कटोरा लेकै परमेसवर का धन्यवाद करया अर कह्या, “इसनै ल्यो अर आप्पस म्ह बाँट ल्यो। ");
INSERT INTO bgc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","क्यूँके के मै थमनै कहूँ सूं के जिब ताहीं परमेसवर का राज्य न्ही आवै तब तक मै अंगूर का रस इब तै कदे न्ही पिऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","फेर यीशु नै रोट्टी ली अर परमेसवर का धन्यवाद करकै तोड़ी, अर चेल्यां ताहीं या कहकै दी, “या मेरी देह सै जो थारे खात्तर दी जा सै: मेरी याद म्ह न्यूए करया करो।” ");
INSERT INTO bgc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","इसे तरियां तै उसनै खाणे के पाच्छै कटोरा भी यो कहन्दे होए दिया, “यो कटोरा मेरै उस लहू म्ह जो थारे खात्तर बहाया जा सै नया करार सै। ");
INSERT INTO bgc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पर देक्खो, जो मन्नै पकड़वावैगा वो म्हारे गेल्या इस भोज म्ह शामिल सै। ");
INSERT INTO bgc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","क्यूँके मै माणस का बेट्टा तो जिसा मेरे खात्तर तय करया गया सै, ठीक उस्से तरियां होण लागरया सै, पर धिक्कार सै उस माणस पै जिसकै जरिये मै पकड़वाया जाऊँ सूं!” ");
INSERT INTO bgc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","फेर वे आप्पस म्ह पूच्छताछ करण लाग्ये के म्हारै म्ह तै कौण सै, जो यो काम करैगा। ");
INSERT INTO bgc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","उन म्ह या बहस भी होगी के म्हारे मै तै कौण बड्ड़ा समझा जावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","यीशु नै उन ताहीं कह्या, “और गैर यहूदियाँ के राजा उनपै राज करै सै, अर जो उनपै हक जमावैं सै वे भले कुह्वावै सै। ");
INSERT INTO bgc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पर थम इसे ना होइयो, बल्के जो थारे म्ह बड्ड़ा सै वो छोट्टे कै बरोब्बर अर जो प्रधान सै, वो सेवक कै बरोब्बर बणै। ");
INSERT INTO bgc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","क्यूँके बड्ड़ा कौण सै, वो जो खाणे पै बेठ्या सै, या वो जो सेवा करै सै? के वो न्ही जो ज़िम्मण बेठ्या सै? पर मै थारे बिचाळै सेवक बरोब्बर सूं। ");
INSERT INTO bgc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","थम वो सों, जो मेरी मुसीबतां म्ह लगातार मेरै गेल्या रहे, ");
INSERT INTO bgc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","अर जिस तरियां मेरै पिता नै मेरै खात्तर एक राज्य ठहराया सै, उस्से तरियां मै भी थारे खात्तर ठहराऊँ सूं, ");
INSERT INTO bgc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ताके थम मेरै राज्य म्ह मेरी मेज पै खाओ-पीओ बल्के सिंहासनां पै बैठकै इस्राएल के बारहां गोत्रां का न्याय करो।” ");
INSERT INTO bgc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“शमौन, हे शमौन! देख शैतान नै परमेसवर तै हुकम ले लिया सै, के थारे ताहीं परखै जिस तरियां किसान गेहूँ नै भूसी तै न्यारा करै सै। ");
INSERT INTO bgc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पर मन्नै तेरे खात्तर बिनती करी ताके थम मेरे पै बिश्वास करणा ना छोड़ दे, अर जिब थम पाप करणा छोड़ दे, तो अपणे भाईयाँ नै भी इसाए करण खात्तर कहियो।” ");
INSERT INTO bgc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","उसनै उसतै कह्या, “हे प्रभु मै, तेरे गेल्या जेळ जाण, बल्के मरण नै भी त्यार सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","उसनै कह्या, “हे पतरस, मै तन्नै सच कहूँ सूं, के आज मुर्गा बाँग न्ही देवैगा जब ताहीं तू तीन बर मेरै बारै म्ह मुकरैगा जावैगा, के मै तन्नै न्ही जाण्दा।” ");
INSERT INTO bgc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","फेर यीशु नै चेल्यां ताहीं कह्या, “जिब मन्नै थारे ताहीं वचन सुणाण खात्तर बटुए, अर झोळी, अर जूत्याँ कै बिना भेज्या था, तो के थमनै किसे चीज की कमी होई थी?” उननै कह्या, “किसे चीज की न्ही।” ");
INSERT INTO bgc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","उसनै चेल्यां तै कह्या, “पर इब जिसकै धोरै बटुआ ना हो वो उसनै ले अर उस्से तरियां जिसकै धोरै तलवार न्ही हो तो वो अपणे लत्ते बेचकै एक मोल लेवै। ");
INSERT INTO bgc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","क्यूँके मै थमनै कहूँ सूं, यो जो पवित्र ग्रन्थ म्ह लिख्या सै, ‘वो गुन्हेगार गेल्या गिण्या गया,’ उसका मेरै म्ह पूरा होणा जरूरी सै, क्यूँके मेरै बारै म्ह लिखी सारी बात्तां का होणा जरूरी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","चेल्यां नै कह्या, “हे प्रभु याड़ै दो तलवार सै।” यीशु नै उन ताहीं कह्या, “भतेरी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","फेर यीशु बारणै लिकड़कै अपणी रीत के मुताबिक जैतून कै पहाड़ पै गया, अर चेल्लें उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","उस जगहां पोहुच कै उसनै चेल्यां तै कह्या, “प्रार्थना करो कै थम परखे ना जाओ।” ");
INSERT INTO bgc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","अर आप उनतै न्यारा एक डळा फेकण के बराबर जितनी दूर गया, अर गोड्डे टेक कै प्रार्थना करण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“हे पिता जै तू चाहवै तो इस दुख के कटोरे नै मेरै धोरै तै हटा ले, तोभी मेरी न्ही पर तेरी मर्जी पूरी हो।” ");
INSERT INTO bgc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","फेर सुर्ग तै एक सुर्गदूत उसनै दिख्या जो उसनै सामर्थ दिया करै था। ");
INSERT INTO bgc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","वो और घणे संकट म्ह काल होकै और भी मन तै प्रार्थना करण लाग्या, अर उसका पसीन्ना मान्नो लहू की बड्डी-बड्डी बूँदां के जू धरती पै गिरै था। ");
INSERT INTO bgc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","फेर वो प्रार्थना तै उठ्या अर अपणे चेल्यां कै धोरै आकै उन ताहीं उदासी कै मारै सोन्दे पाया। ");
INSERT INTO bgc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","अर उनतै कह्या, “क्यूँ सोवों सों? उठ्ठो, प्रार्थना करो के थम परखे ना जाओ।” ");
INSERT INTO bgc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","यीशु न्यू कहण ए लागरया था, के एक भीड़ आई, अर उन बारहां चेल्यां म्ह तै एक जिसका नाम यहूदा था उसकै आग्गै-आग्गै आण लाग रह्या था। वो यीशु कै धोरै आया के उसनै चूम ले। ");
INSERT INTO bgc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","यीशु नै उसतै कह्या, “हे यहूदा, के तू चुम्मा लेकै माणस के बेट्टा नै पकड़वावै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","उसकै साथियाँ नै जद देख्या के, के होण आळा सै, तो कह्या “हे प्रभु, के हम तलवार चलावां?” ");
INSERT INTO bgc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","अर उन म्ह तै एक नै महायाजक के नौक्कर पै तलवार चलाकै उसका सोळा कान उड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","इसपै यीशु नै कह्या, “इब बस करो।” अर उसका कान छू कै उस ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","फेर यीशु नै प्रधान याजकां अर मन्दर कै पैहरेदारां कै सरदारां अर यहूदी अगुवां तै, जो उसपै चढ़ ग्ये थे, कह्या, “के थम मन्नै डाकू जाणकै तलवार अर लाठ्ठी लेकै लिकड़े सो? ");
INSERT INTO bgc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","जद मै मन्दर म्ह हरेक दिन थारे गेल्या था, तो थमनै मेरै हाथ भी कोनी लाया, पर यो थारा बखत सै, अर अन्धकार का हक सै।” ");
INSERT INTO bgc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","फेर वे यीशु नै पकड़कै ले चाल्ले, अर महायाजक कै घर म्ह लाये, पतरस दूरे ए दूर उसकै पाच्छै-पाच्छै चाल्लै था। ");
INSERT INTO bgc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","अर जद वे आँगण म्ह आग सुलगाकै कठ्ठे बेठ्ठे, तो पतरस भी उसके बिचाळै बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","फेर एक नौकराणी उस ताहीं आग कै चाँदणे म्ह बेठ्या देखकै अर उस कान्ही देखकै कहण लाग्गी, “यो भी तो उसकै गेल्या था।” ");
INSERT INTO bgc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पर पतरस नै यो कहकै मना कर दिया, के “हे, जनानी मै उसनै कोनी जाणदा।” ");
INSERT INTO bgc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोड़ी हाण पाच्छै किसे और नै पतरस ताहीं देखकै कह्या, “तू भी तो उन म्ह तै ए सै।” उसनै कह्या, “हे भाई, मै वो कोनी।” ");
INSERT INTO bgc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","कोए एक घंटे कै पाच्छै एक और माणस पक्के बिश्वास तै कहण लाग्या, “सही म्ह यो भी तो उसकै गेल्या था, क्यूँके यो गलीलवासी सै।” ");
INSERT INTO bgc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरस नै कह्या, “हे भाई, मै न्ही जाण्दा के तू के कहवै सै!” वो या कहवैए था के मुर्गे नै बाँग देई ");
INSERT INTO bgc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","फेर घूमकै प्रभु नै पतरस की ओड़ देख्या अर पतरस नै प्रभु की बात याद आई जो उसनै कही थी: “आज मुर्गे कै बाँग देण तै पैहल्या, तू तीन बर इन्कार करैगा।” ");
INSERT INTO bgc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","अर वो बारणै लिकड़कै नै फूट-फूटकै रोण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जो माणस यीशु नै पकड़े होए थे, वे उसका मजाक बणाकै पीटण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","अर उसकी आँख ढँक कै उसतै बुझया, “भविष्यवाणी करकै बता के तेरे किसनै मारया!” ");
INSERT INTO bgc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","अर उननै घणीए बुराई की बात उसकै बिरोध म्ह कही। ");
INSERT INTO bgc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जिब दिन लिकड़या तो यहूदी अगुवें, प्रधान याजक अर शास्त्री कठ्ठे होए, अर उस ताहीं अपणी बड्डी सभा म्ह ल्याकै बुझया, ");
INSERT INTO bgc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“जै तू मसीह सै, तो म्हारै ताहीं कह दे!” उसनै उनतै कह्या, “जै मै थारे तै कहूँ, तो बिश्वास कोनी करोगे, ");
INSERT INTO bgc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","अर जै बुझ्झु, तो जवाब न्ही द्योगे। ");
INSERT INTO bgc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","पर इब तै मै माणस का बेट्टा सर्वशक्तिमान परमेसवर कै सोळी ओड़ बेठ्या रहूँगा।” ");
INSERT INTO bgc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","इसपै सब नै कह्या, “तो के तू परमेसवर का बेट्टा सै?” यीशु नै उन ताहीं कह्या, “थम अपणे-आप्पे कहो सों, क्यूँके मै सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","फेर उननै कह्या, “इब हमनै गवाह की के जरूरत सै, क्यूँके हमनै आप्पे उसकै मुँह तै सुण लिया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","फेर सारी मंडळी उठकै यीशु नै राज्यपाल पिलातुस कै धोरै लेग्यी। ");
INSERT INTO bgc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","वो ये कहकै उसपै इल्जाम ल्गाण लाग्गे, “हमनै इस ताहीं माणसां नै भकांदे, अर कैसर नै चुंगी देण तै मना करदे, अर खुद नै मसीह, राजा कहन्दे होए सुण्या सै।” ");
INSERT INTO bgc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पिलातुस नै उसतै बुझ्झया, “के तू यहूदियाँ का राजा सै?” उसनै उस ताहीं जवाब दिया, “तू आप ए कहण लागरया सै।” ");
INSERT INTO bgc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","फेर पिलातुस नै प्रधान याजकां तै अर माणसां तै कह्या, “मन्नै इस आदमी म्ह कोए खोट न्ही पाया।” ");
INSERT INTO bgc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","पर वे और भी बिश्वास के गेल्या कहण लाग्गे, “यो गलील परदेस तै लेकै याड़ै ताहीं, सारे यहूदिया परदेस के माणसां नै उपदेश देकै दंगा करवावै सै।” ");
INSERT INTO bgc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","या सुणकै पिलातुस नै बुझया, “के यो आदमी गलीलवासी सै?” ");
INSERT INTO bgc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","अर या जाणकै के वो हेरोदेस की रियासत का सै, उस ताहीं हेरोदेस के धोरै भेज दिया, क्यूँके उस बखत वो भी यरुशलेम म्ह था। ");
INSERT INTO bgc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदेस यीशु नै देखकै घणा राज्जी होया, क्यूँके वो घणे दिनां तै उसनै देखणा चाहवै था, इस खात्तर के उसके बारै म्ह सुण्या था, अर उसतै किमे चमत्कार देखण की आस राक्खै था। ");
INSERT INTO bgc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","वो उसतै भोत-सी बात बुझता रह्या, पर उसनै उस ताहीं कोए भी जवाब न्ही दिया। ");
INSERT INTO bgc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","प्रधान याजक अर शास्त्री खड़े होए तन मन तै उसपै इल्जाम लगान्दे रहे। ");
INSERT INTO bgc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","फेर हेरोदेस नै अपणे सिपाहियाँ के गेल्या उसकी बेजती करकै मजाक उड़ाया, अर भड़कीले लत्ते पिराह के उस ताहीं पिलातुस के धोरै भेज दिया। ");
INSERT INTO bgc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","उस्से दिन पिलातुस अर हेरोदेस साथी बणगे, इसतै पैहल्या वे एक-दुसरे के दुश्मन थे। ");
INSERT INTO bgc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुस नै प्रधान याजकां, सरदारां अर माणसां नै बुलाकै उन ताहीं कह्या, ");
INSERT INTO bgc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“थम इस आदमी नै माणसां का भकाण आळा बताकै मेरै धोरै ल्याए सों, अर देक्खो, मन्नै थारे स्याम्ही उसकी जाँच करी, पर जिन बात्तां का थम उसपै इल्जाम लगाओ सों उन बात्तां के बारै म्ह मन्नै इस म्ह कोए भी खोट कोनी पाया, ");
INSERT INTO bgc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ना हेरोदेस नै दोषी पाया, क्यूँके उसनै इस ताहीं म्हारै धोरै भेज दिया सै: अर देक्खो, उसतै इसा कुछ कोनी होया के वो मौत की सजा के काबिल ठहराया जावै। ");
INSERT INTO bgc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","इस खात्तर मै इसनै छित्वा कै छोड़ द्यु सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(पिलातुस त्यौहार के बखत उनकै खात्तर एक कैदी नै छोड़ण पै मजबूर था।) ");
INSERT INTO bgc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","फेर सारे मिलकै चिल्ला उठे, “इसका काम तमाम करदे, अर म्हारै खात्तर बरअब्बा नै छोड़दे!” ");
INSERT INTO bgc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","वो किसे बलवे के कारण जो नगर म्ह होया था, अर हत्या के कारण जेळ म्ह गेरया ग्या था ");
INSERT INTO bgc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पर पिलातुस नै यीशु ताहीं छोड़ण की इच्छा तै माणसां ताहीं फेर समझाया, ");
INSERT INTO bgc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","आखर उननै रुक्के मारकै कह्या, “उसनै क्रूस पै चढ़ा, क्रूस पै!” ");
INSERT INTO bgc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","उसनै तीसरी बर उन ताहीं कह्या, “क्यांतै उसनै के बुरा करया सै? मन्नै उस म्ह मौत की सजा के काबिल कोए बात कोनी पाई। इस तरियां मै इसनै छित्वा कै छोड़ देऊ सूं।” ");
INSERT INTO bgc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पर वे रुक्के मार-मारकै पाच्छै पड़ ग्ये के वो क्रूस पै चढ़ाया जावै, अर उनका रुक्के मारणा तेज होग्या। ");
INSERT INTO bgc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","आखर पिलातुस नै हुकम दिया के उनकी बिनती के मुताबिक करया जावै। ");
INSERT INTO bgc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","उसनै उस आदमी के जो बलवे अर हत्या के कारण जेळ म्ह गेरया ग्या था, अर जिसनै वो माँग्गै थे, छोड़ दिया, अर यीशु नै उनकी इच्छा के मुताबिक सौप दिया। ");
INSERT INTO bgc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जिब वो यीशु नै लेकै जावै थे, तो उननै एक माणस जिसका नाम शमौन कुरेनी था, जो गाम म्ह तै आवै था, पकड़कै उसपै क्रूस लाद दिया के उस्से यीशु के पाच्छै-पाच्छै ले चाल्लै। ");
INSERT INTO bgc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","माणसां की भीड़ उसकै पाच्छै-पाच्छै हो ली उन म्ह घणीए बिरबान्नी भी थी जो उसकै खात्तर छात्त्ती पीट्टै अर रोवै धोवै थी। ");
INSERT INTO bgc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीशु नै उनकै कान्ही मुड़कै कह्या, “हे यरुशलेम की बेटियों, मेरै खात्तर ना रोओ, पर अपणे अर अपणे बाळकां के खात्तर रोओ ");
INSERT INTO bgc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","क्यूँके देक्खो, वे दिन आवै सै, जिन म्ह माणस कहवैंगें, ‘धन्य सै वे जो बिरबान्नी जो बाँझ सै अर वे गर्भ जिननै ऊलाद न्ही पैदा करी, अर वे स्तन जिन नै दूध न्ही पियाया।’ ");
INSERT INTO bgc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","उस बखत ‘माणस पहाड़ां अर टीलां तै कहण लाग्ये के म्हारै पै आण पड़ो, अर हमनै ढँक ल्यो।’” ");
INSERT INTO bgc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","क्यूँके वे जिब हरे रुखां गेल्या इसा करै सै, तो सूख्या कै गेल्या के किमे न्ही करया ज्यागा? ");
INSERT INTO bgc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","वे और दो माणसां नै भी जो बुरे काम करण आळे थे यीशु कै गेल्या मारण नै ले चाल्ले। ");
INSERT INTO bgc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","जद वे उस जगहां पै पोहचे जो “खोपड़ी” यानी इब्रानी भाषा म्ह “गुलगुता” कुह्वावै सै, तो उननै ओड़ै यीशु ताहीं अर बुरे काम करण आळे ताहीं भी, एक नै सोळी अर दुसरे नै ओळी ओड़ क्रूस पै चढ़ाए। ");
INSERT INTO bgc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","फेर यीशु नै कह्या, “हे पिता इन्हनै माफ कर, क्यूँके ये न्ही जाणदे के ये के करै सै।” अर उननै पर्ची गेर कै उसके लत्ते बांड लिए। ");
INSERT INTO bgc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","माणस खड़े-खड़े देक्खै थे, अर सरदार भी मजाक करकै कहवै थे “इसनै औरां ताहीं बचाया, जै यो परमेसवर का मसीह सै, अर उसका छाट्या होए सै, तो अपणे-आपनै बचाले।” ");
INSERT INTO bgc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सिपाही भी धोरै आकै अर सिरका देकै उसका मजाक बणा के कहवै थे, ");
INSERT INTO bgc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“जै तू यहूदियाँ का राजा सै, तो अपणे-आपनै बचाले!” ");
INSERT INTO bgc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","अर उसकै उप्पर एक दोषपत्र भी लगा दिया: “यो यहूदियाँ का राजा सै।” ");
INSERT INTO bgc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","जो बुरे काम करणीये ओड़ै लटकाए गए थे, उन म्ह तै एक नै उसकी बेजती करकै कह्या, “के तू मसीह कोनी? फेर अपणे-आपनै अर हमनै बचा!” ");
INSERT INTO bgc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","इसपै दुसरे नै उस ताहीं धमका के कह्या, “के तू परमेसवर तै भी कोनी डरदा? तू भी तो वाए सजा पा रया सै, ");
INSERT INTO bgc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","हम तो न्याय के मुताबिक सजा पारे सां, क्यूँके हम अपणे काम्मां की ठीक सजा पारे सां, पर उसनै कोए गलत काम न्ही करया।” ");
INSERT INTO bgc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","फेर उसनै कह्या, “हे यीशु, जद तू अपणे राज्य म्ह आवै, तो मेरी खियास करिये।” ");
INSERT INTO bgc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","उसनै उस ताहीं कह्या, “मै तन्नै सच कहूँ सूं के आजे तू मेरै गेल्या सुर्गलोक म्ह होगा।” ");
INSERT INTO bgc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","करीबन दोफ्फारै तै तीन बजे ताहीं सारे देश म्ह अन्धेरा होया रह्या, ");
INSERT INTO bgc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","अर सूरज का चाँदणा जान्दा रह्या, अर मन्दर का पड़दा बिचाळै तै पाटग्या, ");
INSERT INTO bgc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","अर यीशु नै जोर तै किल्की मारकै कह्या, “हे पिता, मै अपणी आत्मा तेरे हाथ्थां म्ह सौंप्पू सूं।” अर या कह के जी दे दिया। ");
INSERT INTO bgc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","सूबेदार नै जो कुछ होया था देखकै परमेसवर की बड़ाई करी, अर कह्या, “पक्का यो माणस धर्मी था।” ");
INSERT INTO bgc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","अर भीड़ जो यो देक्खण नै कठ्ठी होई थी, इस घटना नै देखकै दुख के मारे छात्त्ती पीटती होई बोहड्गी। ");
INSERT INTO bgc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","पर उसकै सब जाण-पिच्छाण, अर जो बिरबान्नी गलील परदेस तै उसकै गेल्या आई थी, दूर खड़ी यो सब देक्खै थी। ");
INSERT INTO bgc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ओड़ै यूसुफ नाम का यहूदी अगुवां की सभा का एक सदस्य था जो आच्छा अर धर्मी आदमी था ");
INSERT INTO bgc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","वो सभा के फैसले अर इस काम तै राज्जी कोनी था। वो यहूदिया परदेस के नगर अरिमतिया गाम का रहण आळा अर परमेसवर के राज्य की बाट देखण आळा था। ");
INSERT INTO bgc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","उसनै पिलातुस के धोरै जाकै यीशु की लाश माँग्गी, ");
INSERT INTO bgc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","अर उस ताहीं उतार के मलमल की चाद्दर म्ह लपेट्या, अर एक कब्र म्ह धरया, जो पत्थरां म्ह खुदी होए थी, अर उस म्ह कोए कदे न्ही राख्या ग्या था। ");
INSERT INTO bgc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","वो त्यारी का दिन था, अर आराम का दिन शरु होण आळा था। ");
INSERT INTO bgc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","उन बिरबानियाँ नै जो उसके गेल्या गलील परदेस तै आई थी, पाच्छै-पाच्छै जाकै उस कब्र ताहीं देख्या, अर यो भी के उसकी लाश किस रीति तै राक्खी गयी सै। ");
INSERT INTO bgc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","फेर उननै घर बोहड़ के खुशबुदार चीज अर इत्र त्यार करया, अर आराम कै दिन उननै हुकम के मुताबिक आराम करया। ");
INSERT INTO bgc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","पर हफ्तै कै पैहल्ड़े दिन तड़कै-तड़कै नै वे उन खुशबुदार चिज्जां नै जो उननै बणाई थी, लेकै यीशु की कब्र पै आई। ");
INSERT INTO bgc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","उननै पत्थर कब्र पै तै गिरड़या होया पाया, ");
INSERT INTO bgc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","पर भीत्त्तर जाकै प्रभु यीशु की लाश कोनी पाई। ");
INSERT INTO bgc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","जब वे इस बात तै हैरान होरी थी तो देक्खो दो माणस चमकदे होए लत्ते पहरी होए उनकै धोरै आण खड़े होए। ");
INSERT INTO bgc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","जिब वे डरगी अर धरती की ओड़ मुँह झुकाए रही तो उननै उन ताहीं कह्या, “थम जान्दे नै मरे होया म्ह क्यूँ टोह्वो सो? ");
INSERT INTO bgc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","वो उरै कोनी, पर जिन्दा होग्या सै। याद करो कै उसनै गलील परदेस म्ह रहंदे होए थारे तै कै कह्या था, ");
INSERT INTO bgc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","जरूरी सै कै मै माणस का बेट्टा पापियाँ कै हाथ्थां म्ह पकड़वाया जाऊँ, अर क्रूस पै चढ़ाया जाऊँ, अर तीसरे दिन जी उठ्ठु।” ");
INSERT INTO bgc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","फेर उसकी बात उनकै याद आई, ");
INSERT INTO bgc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","अर कब्र तै उल्टे आकै उननै उन ग्यारहां नै अर, सारया ताहीं ये सब बात कह दी। ");
INSERT INTO bgc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जिन नै प्रेरितां तै ये बात कही वे मरियम मगदलीनी अर योअन्ना अर याकूब की माँ मरियम अर उसकै साथ की और भी बिरबान्नी थी। ");
INSERT INTO bgc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पर उनकी बात उन ताहीं कहाँनी-सी लाग्गी, अर उननै उसका बिश्वास कोनी करया। ");
INSERT INTO bgc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","फेर पतरस कब्र पै भाज्या ग्या, अर झुककै लत्यां की पट्टियाँ का ढेर पड़े देक्खे, अर जो होया था उसतै अचम्भा होया करदा होया अपणे घरां चल्या ग्या। ");
INSERT INTO bgc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","उस्से दिन उन म्ह तै दो चेल्लें इम्माऊस नाम के गाम म्ह जाण लागरे थे, जो यरुशलेम तै कोए सात कोंस की दूरी पै था। ");
INSERT INTO bgc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","वे इन सब बात्तां पै जो होई थी, आप्पस म्ह बातचीत करदे जाण लागरे थे, ");
INSERT INTO bgc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","अर जद वे आप्पस म्ह बातचीत अर पूछताछ करै थे तो यीशु खुद धोरै आकै उनकै गेल्या चाल्लण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पर परमेसवर नै उनकी आँख न्यू बन्द कर दी थी कै यीशु ताहीं पिच्छाण ना सकै। ");
INSERT INTO bgc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","यीशु नै उनतै बुझया, “ये कै बात सै, जो थम चाल्दे-चाल्दे आप्पस म्ह करो सों?” वे खड़े होगे अर उनका मुँह भोत उदास था। ");
INSERT INTO bgc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","या सुणकै चेल्यां म्ह तै क्‍लियुपास नाम के एक चेल्लें नै कह्या, “इसा लाग्गै सै के तू यरुशलेम म्ह एक्ला परदेशी सै, जो न्ही जाण्दा के इन दिनां म्ह इस नगर म्ह के-के होया सै?” ");
INSERT INTO bgc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","यीशु नै उनतै बुझया, “कौण सी बात? उननै उस ताहीं कह्या, यीशु नासरी जो नबी था उसकी बात, जो परमेसवर अर सारे माणसां कै स्याम्ही काम अर वचन म्ह सामर्थी था। ");
INSERT INTO bgc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","अर प्रधान याजकां अर म्हारै सरदारां नै उस ताहीं पकड़वा दिया ताके उसतै मौत का हुकम दिया जावै, अर उस ताहीं क्रूस पै चढ़वाया। ");
INSERT INTO bgc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","पर हमनै उम्मीद थी के योए इस्राएल नै रोमी साम्राज्य तै छुटकारा देवैगा। इन सारी बात्तां कै सिवा इस घटना नै होए आज तीसरा दिन सै, ");
INSERT INTO bgc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","अर म्हारै म्ह तै कई बिरबानियाँ नै भी म्हारै ताहीं उळझन म्ह गेर दिया, जो आज सबेरै कब्र पै ग्यी थी, ");
INSERT INTO bgc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","अर जिब उसकी लाश कोनी पाई तो वा या कहन्दी आई के हमनै सुर्गदूत्तां के दर्शन पाये, जिन नै कह्या के यीशु जिन्दा सै। ");
INSERT INTO bgc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","फेर म्हारै साथियाँ म्ह तै कई कब्र पै गये, अर जिसा बिरबानियाँ नै कह्या था उसाए पाया, पर वो कोनी देख्या।” ");
INSERT INTO bgc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","फेर यीशु नै उन दो चेल्यां तै कह्या, “हे सब बेकुफों अर नबियाँ की सारी बात्तां पै बिश्वास करण म्ह नासमझों! ");
INSERT INTO bgc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","कै जरूरी कोनी था कै मसीह ये दुख उठाकै अपणी महिमा म्ह दाखल हो?” ");
INSERT INTO bgc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","फेर उसनै मूसा नबी तै अर सारे नबियाँ तै शरु करकै सारे पवित्र ग्रन्थां म्ह तै अपणे बारै म्ह लिक्खी बात्तां का मतलब, उन ताहीं समझा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","इतनै म्ह वो उस गाम कै धोरै पोहचे जित्त वे जावै थे, अर उसके ढंग तै इसा लाग्या के वो आग्गै जाणा चाहवै सै। ");
INSERT INTO bgc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","पर उननै यो कहकै उस ताहीं रोक्या, “म्हारै गेल्या रह, क्यूँके साँझ होली सै अर दिन इब घणा ढळग्या सै।” फेर वो उनकै गेल्या रहण के खात्तर भीत्त्तर ग्या। ");
INSERT INTO bgc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","जद वो उनकै गेल्या खाणा खाण बेठ्या, तो उसनै रोट्टी लेकै धन्यवाद करया अर उस ताहीं तोड़कै उननै देण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","फेर उनकी आँख खुलगी, अर उननै उस ताहीं पिच्छाण लिया, अर वो उनकी आँखां तै ओन्झळ होग्या। ");
INSERT INTO bgc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","उननै आप्पस म्ह कह्या, “जद वो म्हारै तै रास्ते म्ह बात करै था अर पवित्र ग्रन्थ का मतलब हमनै समझावै था, तो कै म्हारै मन म्ह जोश न्ही आया?” ");
INSERT INTO bgc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","वो उस्से बखत जिब्बे उठकै यरुशलेम नगर म्ह चले गये, अर उन ग्यारहां चेल्यां अर उनकै साथियाँ ताहीं उननै कठ्ठे मिलगे। ");
INSERT INTO bgc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","वो कहवै थे, “प्रभु साच्चेए जी उठ्या, अर शमौन नै दिख्या।” ");
INSERT INTO bgc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","फेर उन दो चेल्यां नै भी राह म्ह होई घटना के बारें ब्यौरा सुण्या अर किस तरियां खाणा खान्दे बखत उननै मसीह यीशु ताहीं पिच्छाणा लिया था। ");
INSERT INTO bgc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","वे ये बात करै ए थे के वो खुद ए उनके बिचाळै आण खड्या होया, अर उन ताहीं कह्या, “थमनै शान्ति मिलै।” ");
INSERT INTO bgc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पर वे घबरागे अर डरगे, अर समझे के हम किसे भूत नै देक्खां सां। ");
INSERT INTO bgc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीशु नै उनतै कह्या के, “क्यूँ घबराओ सों? अर थारे मन म्ह क्यूँ बैहम हो सै? ");
INSERT INTO bgc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मेरै हाथ-पायां नै देक्खो के मै वोए सूं। मन्नै छू के देक्खो, क्यूँके आत्मा के हाड-माँस कोनी होन्दे जिसा मेरै म्ह देक्खो सों।” ");
INSERT INTO bgc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","न्यू कहकै उसनै उन ताहीं अपणे हाथ पैर के घा दिखाए। ");
INSERT INTO bgc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जद खुशी के मारै उननै बिश्वास कोनी होया, अर वो अचम्भा मान्नै थे, तो यीशु नै उन ताहीं बुझया, “के याड़ै थारे धोरै किमे खाण नै सै?” ");
INSERT INTO bgc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","चेल्यां नै उस ताहीं भुनी होई मच्छी का टुकड़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","उसनै वो मच्छी का टुकड़ा लेकै उनकै आग्गै खाया। ");
INSERT INTO bgc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","फेर उसनै उन ताहीं कह्या, “ये मेरी वे बात सै, जो मन्नै थारे गेल्या रहंदे होए थारे तै कही थी के जरूरी सै जितनी बात मूसा नबी की नियम-कायदा अर नबियाँ अर भजनां की किताबां म्ह मेरै बारै म्ह लिक्खी सै, सारी पूरी हों।” ");
INSERT INTO bgc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","फेर उसनै पवित्र ग्रन्थ बुझण के खात्तर उनकी बुद्धि खोल दी, ");
INSERT INTO bgc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","अर उनतै कह्या, “यो पवित्र ग्रन्थ म्ह लिख्या सै के मसीह दुख ठावैगा, अर तीसरे दिन मरे होया म्ह तै जी उठ्ठैगा, ");
INSERT INTO bgc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","अर यरुशलेम तै लेकै सारी जात्तां म्ह पापां नै छोड़ण का अर पापां की माफी का प्रचार, उसकै-ए नाम तै करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","थम इन सारी बात्तां के गवाह सों। ");
INSERT INTO bgc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","अर देक्खो, मै थारे पै पवित्र आत्मा भेज्जूँगा जिसा मेरे पिता नै कह्या सै, जिब तैई पवित्र आत्मा थारे पै न्ही आवै, अर थम सुर्ग तै सामर्थ ना पाओ, जब ताहीं इसे नगर म्ह रुके रहो।” ");
INSERT INTO bgc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","फेर यीशु उननै बैतनिय्याह गाम ताहीं बाहर लेग्या, अर अपणे हाथ ठाकै उन ताहीं आशीर्वाद दिया, ");
INSERT INTO bgc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","अर उननै आशीष देंदे होए वो उनतै न्यारा होग्या अर सुर्ग पै उठा लिया। ");
INSERT INTO bgc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","फेर वो उसनै नमस्कार करकै बड़ी खुशी तै यरुशलेम चले गए, ");
INSERT INTO bgc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","अर वे लगातार मन्दर म्ह हाज्जर होकै परमेसवर की भगति करया करै थे।");
INSERT INTO bgc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","दुनिया बणण तै पैहल्या वचन था, अर वचन परमेसवर कै गेल्या था, अर वचन परमेसवर था। ");
INSERT INTO bgc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","यो वचन ए शरुआत तै परमेसवर कै गेल्या था। ");
INSERT INTO bgc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","दुनिया की हरेक चीज उस्से कै जरिये बणी सै, अर उसके बिना किसे भी चीज की रचना न्ही होई। ");
INSERT INTO bgc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","वो जीवन का जरिया था, अर वो जीवन मानव जात्ति कै खात्तर चाँदणा था। ");
INSERT INTO bgc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","चाँदणा अन्धेरै म्ह चमकै सै, अर अन्धेरा उस ताहीं बुझा न्ही सक्या। ");
INSERT INTO bgc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेसवर कै ओड़ तै भेज्जा होया एक माणस आया, जिसका नाम यूहन्ना था। ");
INSERT INTO bgc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","वो गवाही देण खात्तर आया के माणसां नै चाँदणे की गवाही देवै, के सारे माणस उसकै जरिये चाँदणे पै बिश्वास करै। ");
INSERT INTO bgc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","वो खुद तै वो चाँदणा कोनी था, पर माणसां नै उस्से चाँदणे की गवाही देण खात्तर आया था। ");
INSERT INTO bgc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","जो साच्चा चाँदणा था, हरेक माणस नै ज्ञान का चाँदणा देवै सै, वो धरती पै आण आळा था। ");
INSERT INTO bgc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","वो दुनिया म्ह था, अर दुनिया उसकै जरिये बणी, अर दुनिया के माणसां नै उस ताहीं न्ही पिच्छाण्या। ");
INSERT INTO bgc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","वो अपणे यहूदी माणसां कै धोरै आया अर उसके अपणे लोग्गां नै उस ताहीं कोन्या अपणाया। ");
INSERT INTO bgc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पर जितन्या नै उस ताहीं अपणाया, उसनै उन ताहीं परमेसवर के ऊलाद होण कि हक दिया। ");
INSERT INTO bgc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","वे कुदरती तौर पै ना तो पूर्वजां तै, ना देह की मर्जी तै, ना माणसां की मर्जी तै, पर परमेसवर की मर्जी तै पैदा होए सै। ");
INSERT INTO bgc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","अर वचन देह धारण करकै आया, अर अनुग्रह अर सच्चाई तै भरकै म्हारै बिचाळै रहण लाग्या, अर हमनै उसकी इसी महिमा देक्खी, जिसी पिता कै इकलौते बेट्टे की महिमा। ");
INSERT INTO bgc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्ना नै उसकै बारै म्ह गवाही दी, अर रुक्का मारकै बोल्या, “यो वोए सै, जिसका मन्नै जिक्र करया के जो मेरै पाच्छै आण लागरया सै, वो मेरतै घणा महान् सै क्यूँके वो मेरतै पैहल्या था।” ");
INSERT INTO bgc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","क्यूँके उसकी करुणा अर सच्चाई की भरपूरी म्ह तै हम सारया नै आशीष पै आशीष पाई। ");
INSERT INTO bgc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","इस खात्तर के नियम-कायदे तो मूसा नबी तै मिले, पर अनुग्रह अर सच्चाई यीशु मसीह कै जरिये पोहची। ");
INSERT INTO bgc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेसवर ताहीं किसे नै कदे कोन्या देख्या, पर परमेसवर के इकलौते बेट्टे नै, जो सदा परमपिता कै गैल सै, उस्से नै म्हारे ताहीं दिखाया। ");
INSERT INTO bgc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यूहन्ना की गवाही या सै, के जिब यहूदी अगुवां नै यरुशलेम तै याजकां अर लेवियाँ नै उसतै यो बुझ्झण नै भेज्या, के “तू कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","फेर उसनै नाट्या कोनी, पर मान लिया के “मै मसीह कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","फेर उननै यूहन्ना तै बुझ्झया, “तो फेर तू कौण सै? के तू एलिय्याह नबी सै?” उसनै साफ-साफ कह दिया के, “मै मसीह कोनी।” “तो के तू वो नबी सै?” उसनै जवाब दिया, “ना।” ");
INSERT INTO bgc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","फेर उननै यूहन्ना तै बुझ्झया, “फेर तू सै कौण? ताके हम अपणे भेजण आळा ताहीं जवाब देवां। तू अपणे बारै म्ह के कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","वो बोल्या, “जिसा यशायाह नबी नै बोल्या सैः ‘मै जंगल-बियाबान म्ह एक रुक्का देवण आळे का वचन सूं, के थम प्रभु का रास्ता सीध्धा करो।’” ");
INSERT INTO bgc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","वे फरीसियों के कान्ही तै भेज्जै होड़ थे। ");
INSERT INTO bgc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","उननै उसतै यो सवाल बुझ्झया, “जै तू ना मसीह सै, अर ना एलिय्याह, अर ना वो नबी सै, तै फेर बपतिस्मा क्यांतै देवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्ना नै उन ताहीं जवाब दिया, “मै तो थमनै पाणी तै बपतिस्मा देऊँ सूं, पर थारे बीच म्ह एक माणस खड्या सै जिसनै थम कोनी जाणदे। ");
INSERT INTO bgc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","यानी मेरै पाच्छै आण आळा सै, जिसके जूत्याँ के फित्ते भी मै खोल्लण जोग्गा कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ये बात यरदन नदी तै परली ओड़ बैतनिय्याह गाम म्ह होई, जडै़ यूहन्ना माणसां ताहीं बपतिस्मा दिया करदा। ");
INSERT INTO bgc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दुसरे दिन यूहन्ना नै यीशु ताहीं अपणी ओड़ आन्दे देखकै बोल्या, “देक्खो, यो परमेसवर का मेम्‍ना सै जो दुनिया का पाप ठावै सै। ");
INSERT INTO bgc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","यो वोए सै जिसकै बारै म्ह मन्नै कह्या था, एक माणस मेरै बाद आवै सै जो मेरतै महान् सै, ज्यातै वो मेरतै पैहल्या था। ");
INSERT INTO bgc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","मै खुद तो उसनै कोनी पिच्छाणु था, पर इस्से खात्तर मै पाणी तै बपतिस्मा देन्दा होया आया, ताके इस्राएल के माणस उसनै जान ले।” ");
INSERT INTO bgc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","अर यूहन्ना नै या गवाही दीः “मन्नै सुर्ग तै पवित्र आत्मा ताहीं कबूतर की तरियां अकास तै उतरदे अर उस ताहीं मसीह यीशु पै ठहरते देख्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","मै तो उसनै पिच्छाणु कोनी था, पर जिसनै मेरै ताहीं पाणी तै बपतिस्मा देण कै खात्तर भेज्या, उस्से नै मेरै ताहीं कह्या, “जिसपै तू आत्मा नै उतरदे अर ठहरदे देक्खै, वोए पवित्र आत्मा तै बपतिस्मा देणिया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","“अर मन्नै देख्या, अर गवाही दी सै, के योए परमेसवर का बेट्टा सै।” ");
INSERT INTO bgc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","आगले दिन यूहन्ना अपणे दो चेल्यां कै गैल फेर ओड़ै खड़े थे, ");
INSERT INTO bgc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","अर उसनै यीशु ताहीं जो उसकै धोरै तै जाण लागरया था, उसकी ओड़ लखाकै बोल्या, “देक्खो, यो परमेसवर का मेम्‍ना सै।” ");
INSERT INTO bgc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","जिब्बे वे दोन्नु चेल्लें उसकी या बात सुणकै यीशु कै गैल हो लिए। ");
INSERT INTO bgc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीशु नै मुड़कै उन ताहीं गैल आन्दे देख्या अर उनतै बोल्या, “थम के चाह्वो सो?” वे उसतै बोल्ले, “हे गुरु, तू कित्त रहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","यीशु उनतै बोल्या, “चाल्लों, तो देख लियो।” फेर उननै उसकै रहण की जगहां देक्खी, अर उस दिन उसकै गेल्या रहे। क्यूँके साँझ के करीब चार बजगे थे। ");
INSERT INTO bgc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","उन दोनुआ म्ह तै, जो यूहन्ना की बात सुणकै यीशु कै गेल्या हो लिए थे, एक तो शमौन पतरस का भाई अन्द्रियास था। ");
INSERT INTO bgc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","उसनै पैहल्या अपणे सगे भाई शमौन तै मिलकै उसतै बोल्या, “हमनै ख्रिस्त यानी मसीह (परमेसवर का अभिषिक्त) मिलग्या।” ");
INSERT INTO bgc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","फेर अन्द्रियास शमौन नै यीशु कै धोरै ल्याया। यीशु नै उसकी ओड़ लखाकै कह्या, “तू यूहन्ना का बेट्टा शमौन सैः तू कैफा यानिके पतरस कुआवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","आगले दिन यीशु नै गलील परदेस जाण का इरादा करया। वो फिलिप्पुस तै मिल्या अर बोल्या, “मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस, अन्द्रियास अर पतरस के नगर बैतसैदा का रहणीया था। ");
INSERT INTO bgc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुस नतनएल तै मिल्या अर उसतै बोल्या, “जिसका जिक्र मूसा नबी नै नियम-कायदा म्ह अर नबियाँ नै करया सै, वो हमनै मिलग्या सै! वो यूसुफ का बेट्टा, यीशु नासरी सै।” ");
INSERT INTO bgc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएल नै उसतै बुझ्झया, “के कोए उत्तम चीज भी नासरत तै लिकड़ सकै सै?” फिलिप्पुस उसतै बोल्या, “चालकै देख ले।” ");
INSERT INTO bgc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीशु नै नतनएल ताहीं अपणी ओड़ आन्दे देखकै उसकै बारै म्ह कह्या, “देक्खो, यो साच्चए इस्राएली सैः इस म्ह कपट कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएल नै उसतै बुझ्झया, “तू मन्नै किस तरियां जाणै सै?” यीशु नै उस ताहीं जवाब दिया, “इसतै पैहल्या के फिलिप्पुस नै तेरे ताहीं बुलाया, तो मन्नै तेरे ताहीं देख्या था जिब तू अंजीर कै दरखत तळै था।” ");
INSERT INTO bgc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएल नै उस ताहीं जवाब दिया, “हे गुरु, तू परमेसवर का बेट्टा सै, तू इस्राएल का राजा सै।” ");
INSERT INTO bgc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीशु नै उस ताहीं जवाब दिया, “मन्नै जो तेरे तै कह्या के मन्नै तेरे ताहीं अंजीर कै दरखत तळै देख्या, के तू इस्से बात पै बिश्वास करै सै? तू इसतै भी बड़े-बड़े काम देक्खैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फेर उसनै कह्या, “मै तेरे तै सच-सच कहूँ सूं, के थम सुर्ग नै खुल्या होड़ अर परमेसवर के सुर्गदूत्तां ताहीं मुझ माणस कै बेट्टे कै खात्तर नीच्चै उतरदे अर उप्पर जान्दे होए देक्खोगे।” ");
INSERT INTO bgc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","फेर तीसरे दिन गलील परदेस कै काना नगर म्ह किसे का ब्याह था, अर यीशु की माँ भी ओड़ैए थी। ");
INSERT INTO bgc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","यीशु अर उसके चेल्लें भी उस ब्याह म्ह न्योंद राक्खे थे। ");
INSERT INTO bgc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जिब अंगूर का रस खतम होग्या, फेर यीशु की माँ उसतै बोल्ली, “उनकै धोरै अंगूर का रस कोनी रहया।” ");
INSERT INTO bgc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीशु नै उसतै कह्या, “हे नारी, या बात तू मेरे तै क्यूँ कहवै सै? इब्बै मेरा बखत कोनी आया।” ");
INSERT INTO bgc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","पर उसकी माँ नै नौकरां तै कह्या, “जो कुछ यो थारे ताहीं कहवै, न्यूए करियो।” ");
INSERT INTO bgc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","यहूदी परम्परा के मुताबिक शुद्ध करण कै खात्तर ओड़ै छः पत्थर के पैण्डे धरे थे, जिन म्ह दो-दो, तीन-तीन मण पाणी आवै था। ");
INSERT INTO bgc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीशु नै उनतै कह्या, “पैंढ़ा म्ह पाणी भर द्यो।” अर उननै वे मुँह तक भर दिए। ");
INSERT INTO bgc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","फेर यीशु नै नौकरां ताहीं कह्या, “इब काढकै भोज कै प्रधान धोरै ले जाओ।” अर वे लेगे। ");
INSERT INTO bgc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जिब भोज कै प्रधान नै वो पाणी चाख्या, जो अंगूर का रस बणग्या था अर वे न्ही जाणै था के वो कड़ै तै आया सै पर जिन नौकरां नै पाणी काढ्या था वे जाणै थे फेर भोज कै प्रधान नै बन्दड़े ताहीं बुलाकै उसतै कह्या, ");
INSERT INTO bgc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“हरेक माणस पैहल्या बढ़िया अंगूर का रस देवै सै, अर जिब माणस पीकै छिक्क जावै सै, फेर हल्का देवै सै, पर तन्नै बढ़िया अंगूर का रस इब ताहीं राख राख्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","यीशु नै गलील परदेस के काना नगर म्ह अपणा यो पैहला चिन्ह-चमत्कार दिखाकै अपणी महिमा जाहिर कर दी अर जिसकी बजह तै उसके चेल्यां नै उसपै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","इसकै बाद वो अर उसकी माँ अर उसके भाई अर उसके चेल्लें कफरनहूम नगर म्ह गए अर ओड़ै कुछ दिन रहे। ");
INSERT INTO bgc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदियाँ का फसह का त्यौहार लोवै था, अर यीशु यरुशलेम नगर म्ह गया। ");
INSERT INTO bgc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","उसनै मन्दर म्ह बळध, भेड़ अर कबूतर बेच्चण आळे अर सर्राफां (पईसा का लेण देण करण आळे) ताहीं बेठ्ठे होए पाया। ");
INSERT INTO bgc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","फेर उसनै जेवड़ियां का कोरड़ा बणाकै, सारी भेड्डां अर बळ्धां ताहीं मन्दर तै काढ दिया, अर सर्राफां के पईसे खिन्डा दिए अर उनके पीढ़े पलट दिए, ");
INSERT INTO bgc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","अर कबूतर बेचण आळा ताहीं बोल्या, “इन्हनै उरै तै ले जाओ। मेरै पिता कै घर नै व्यापर का घर ना बणाओ।” ");
INSERT INTO bgc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","फेर उसकै चेल्यां नै याद आया के पवित्र ग्रन्थ म्ह लिख्या होड़ सै, “तेरे घर की धुन मन्नै खा ज्यागी।” ");
INSERT INTO bgc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","इसपै यहूदी अगुवां नै यीशु तै कह्या, “तू म्हारै ताहीं कौण सा अदभुत निशान दिखा सकै सै?” जो इस तरियां के काम तू करै सै, यो साबित हो सकै, के तू उसका हक राक्खै सै। ");
INSERT INTO bgc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीशु नै उन ताहीं जवाब दिया, “इस मन्दर नै ढ़ा दो, मै इसनै तीन दिन म्ह बणा दियुँगा।” ");
INSERT INTO bgc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदी अगुवां नै कह्या, “इस मन्दर कै बणाण म्ह छियालिस साल लाग्गे सै, अर के तू इसनै तीन दिन म्ह बणा देवैगा?” ");
INSERT INTO bgc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","पर यीशु नै उनतै अपणी देह रूपी मन्दर कै बारै म्ह कह्या था। ");
INSERT INTO bgc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","आखर म्ह जिब वो मरे होया म्ह तै जिन्दा होया, जिब उसकै चेल्यां नै याद आई, के उसनै यो कह्या था, अर उननै पवित्र ग्रन्थ के वचन जो यीशु के जिन्दा होण के बारें म्ह बतावै सै, अर उननै यीशु के जरिये कहे होए वचनां पै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","फसह के त्यौहार के दिन्नां म्ह जिब यीशु यरुशलेम नगर म्ह था, तो उसके जरिये करे गये चिन्ह-चमत्कार के काम्मां नै देखकै घणे माणसां नै उसपै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पर यीशु नै अपणे-आप ताहीं उनकै भरोसै पै कोनी छोड्या, ज्यातै वो सारया नै जाणै था, ");
INSERT INTO bgc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","अर उसनै इस बात की जरूरत कोनी थी के कोए आकै उसनै माणसां के बारै म्ह बतावै, क्यूँके वो खुदे जाणै था के माणस कै मन म्ह के सै? ");
INSERT INTO bgc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसियाँ म्ह तै नीकुदेमुस नाम का एक माणस था, जो यहूदियाँ का प्रधान था। ");
INSERT INTO bgc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","उसनै रात नै यीशु के धोरै आकै उस ताहीं कह्या, “हे गुरु, हमनै बेरा सै के तू परमेसवर की ओड़ तै म्हारे ताहीं सिखाण खात्तर आया सै, ज्यातैए कोए इन चिन्ह-चमत्कारां नै जिननै तू दिखावै सै, जै परमेसवर उसकै गेल्या ना हो, तो दिखा कोन्या सकदा।” ");
INSERT INTO bgc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीशु नै उस ताहीं जवाब दिया, “मै थारे ताहीं सच कहूँ सूं, जै कोए नए सिरे तै ना जन्म ले तो परमेसवर का राज्य देख न्ही सकदा।” ");
INSERT INTO bgc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस नै उस ताहीं कह्या, “माणस जिब बूढ़ा होज्या, तो किस ढाळ जन्म ले सकै सै? के वो अपणी माँ कै गर्भ म्ह दुसरी बर भीत्त्तर बड़कै जन्म ले सकै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीशु नै जवाब दिया, “मै तेरे तै सच कहूँ सूं, जिब ताहीं कोए माणस पाणी अर आत्मा तै ना जन्मे तो वो परमेसवर के राज्य म्ह बड़ न्ही सकदा। ");
INSERT INTO bgc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","क्यूँके मानव देह म्ह जन्म सिर्फ देह का जन्म सै, जिब के आत्मा तै जन्म नया जन्म सै। ");
INSERT INTO bgc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","हैरान ना होवै, के मन्नै तेरे तै कह्या, के थारे ताहीं नए सिरे तै जन्म लेणा जरूरी सै। ");
INSERT INTO bgc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हवा जितोड़ चाहवै सै उतोड़ चाल्लै सै, अर तू उसकी आवाज सुणै सै, पर जाण्दा कोनी, के वा कड़ै तै आवै सै अर कितोड़ नै जावै सै? जो कोए पवित्र आत्मा तै जन्मा सै वो इसाए सै।” ");
INSERT INTO bgc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुस नै उस ताहीं जवाब दिया, के या बात किस ढाळ हो सकै सै? ");
INSERT INTO bgc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","या सुणकै यीशु नै उस ताहीं जवाब दिया, “तू इस्राएलियाँ का गुरु होकै भी के इन बात्तां नै कोनी समझदा?” ");
INSERT INTO bgc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मै तेरे तै साच्ची-साच कहूँ सूं के हम जो जाणां सां, वो कह्वां सां, अर जिस ताहीं हमनै देख्या सै उसकी गवाही देवां सां, अर जो हम कह्वां सां, उसका थम बिश्वास कोनी करदे। ");
INSERT INTO bgc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जिब मन्नै थारैतै दुनिया की बात कही, अर थम बिश्वास न्ही करदे, तो जै मै थमनै सुर्ग की बात कहूँ, तो फेर किस ढाळ बिश्वास करोगे? ");
INSERT INTO bgc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","अर कोए सुर्ग पै कोनी चढ़ा, सिर्फ वोए एक सै जो सुर्ग तै उतरा यानिके मै माणस का बेट्टा। ");
INSERT INTO bgc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","अर जिस ढाळ तै मूसा नबी नै जंगल-बियाबान म्ह कांस्सी का साँप बणाकै उस ताहीं ऊँच्चे पै चढ़ाया, उस्से ढाळ तै जरूरी सै के मै माणस का बेट्टा भी ऊँच्चे पै चढ़ाया जाऊँ। ");
INSERT INTO bgc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताके जो कोए मेरे पै बिश्वास करै वो अनन्त जीवन पावै। ");
INSERT INTO bgc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","क्यूँके परमेसवर नै दुनिया के माणसां तै इसा प्यार राख्या के उसनै अपणा इकलौता बेट्टा दे दिया, ताके जो कोए उसपै बिश्वास करै, वो नाश कोनी होवै, पर अनन्त जीवन पावै। ");
INSERT INTO bgc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","क्यूँके परमेसवर नै अपणा बेट्टा दुनिया म्ह इस खात्तर न्ही भेज्या, के दुनिया पै दण्ड का हुकम देवै, पर इस खात्तर भेज्या के दुनिया उसकै जरिये उद्धार पावै। ");
INSERT INTO bgc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जो परमेसवर के बेट्टे पै बिश्वास करै सै, उसपै दण्ड का हुकम कोन्या होन्दा, पर जो उसपै बिश्वास न्ही करदा, वो कसूरवार बणैगा, ज्यांतै के उसनै परमेसवर के इकलौते बेट्टै कै नाम पै बिश्वास कोनी करया। ");
INSERT INTO bgc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","अर दण्ड कै हुकम का कारण यो सै के चान्दणा दुनिया म्ह आया सै, अर माणसां नै अन्धेरै ताहीं चाँदणे तै घणा प्यारा जाण्या क्यूँके उनके काम बुरे थे। ");
INSERT INTO bgc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","क्यूँके जो कोए पाप करै सै, वो चाँदणे तै बैर राक्खै सै, अर चाँदणे धोरै कोनी आन्दा, क्यूँके उसके पाप उजागर हो जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","पर जो सच्चाई पै चाल्लै सै वो चाँदणे धोरै आवै सै, ताके ये साबित हो जावै के उसके काम परमेसवर की ओड़ तै कराये गये सै। ");
INSERT INTO bgc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","फेर यीशु अर उसके चेल्लें यहूदिया परदेस म्ह पोहचे, अर वो ओड़ै उनकै गेल्या रहकै माणसां ताहीं बपतिस्मा देण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्ना भी शालेम नगर कै धोरै ऐनोन नामक गाम म्ह बपतिस्मा देवै था, क्यूँके ओड़ै घणाए पाणी था, अर माणस आकै बपतिस्मा लेवै थे। ");
INSERT INTO bgc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","यूहन्ना उस बखत ताहीं जेळखान्ने म्ह कैद न्ही करया था। ");
INSERT INTO bgc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ओड़ै यूहन्ना के कुछ चेल्यां का किसे यहूदी गेल्या पाणी तै शुद्धिकरण कै बारै म्ह बहस होगी। ");
INSERT INTO bgc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","अर यूहन्ना कै चेल्यां नै आकै उस ताहीं कह्या, “हे गुरु, जो माणस यरदन नदी कै परली ओड़ तेरी गेल्या था, अर जिसके बारें म्ह तन्नै कह्या सै, देख, वो यीशु बपतिस्मा देवै सै, अर सारे उसकै धोरै आवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्ना नै जवाब दिया, “माणस नै तब तक कुछ न्ही मिल सकता, जिब तक वो सुर्ग तै ना दिया जावै।” ");
INSERT INTO bgc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","थारे ताहीं तो पैहले मन्नै बताया था के “मै मसीह कोनी, पर उसतै पैहले भेज्या गया सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","बन्दड़ा बन्दड़ी तै ब्याह करै सै, पर बन्दड़े का साथी जो खड्या होया उसकी आवाज सुणै सै, बन्दड़े कै वचन तै घणा खुश होवै सै, अर मै भी खुश सूं। ");
INSERT INTO bgc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","जरूरी सै के वो बधै अर मै घटूँ। ");
INSERT INTO bgc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","जो सुर्ग तै आवै सै, वो सारया म्ह सबतै महान् सै, जो धरती कान्ही तै आवै सै वो धरती का सै, अर धरतीए की बात कहवै सै: जो सुर्ग कान्ही तै आवै सै, वो सारया तै उप्पर सै। ");
INSERT INTO bgc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","उसनै जो कुछ देख्या अर सुण्या सै, वो उस्से की बात करै सै, पर उसकी गवाही कोए न्ही मानता। ");
INSERT INTO bgc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जिसनै उसकी गवाही अपणाई उसनै इस बात पै छाप लगा दी के परमेसवर साच्चा सै। ");
INSERT INTO bgc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","क्यूँके जिस ताहीं परमेसवर नै भेज्या सै, वो परमेसवर की बात कहवै सै, क्यूँके परमेसवर उननै बिना किसे माप के पवित्र आत्मा देवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पिता अपणे बेट्टै तै प्यार करै सै, अर उसनै सारी चीज उसकै हाथ्थां म्ह दे दी सै। ");
INSERT INTO bgc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जो बेट्टै पै बिश्वास करै सै, अनन्त जीवन उस्से का सै, पर जो बेट्टै की बात कोनी मान्दा, उसनै वो अनन्त जीवन कोनी मिलै, इसकी बजाये उसपै परमेसवर का छो बण्या रहवैगा। ");
INSERT INTO bgc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","फेर जिब यीशु नै बेरा पाट्या के फरीसियाँ नै सुण्या सै के यीशु यूहन्ना तै घणे चेल्लें बणावै सै अर उननै बपतिस्मा देवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ऊतो यीशु खुद न्ही बल्कि उसके चेल्लें बपतिस्मा देवै थे) ");
INSERT INTO bgc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","फेर वो यहूदिया परदेस नै छोड़कै दुबारै गलील परदेस म्ह चल्या गया, ");
INSERT INTO bgc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","इस बार उसनै सामरिया परदेस होकै जाणा पड्या था। ");
INSERT INTO bgc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","इस करकै वो सामरिया परदेस के सूखार नामक एक नगर म्ह आया, यो नगर उस जगहां कै धोरै था जो याकूब नै अपणे बेट्टे यूसुफ ताहीं दिया था। ");
INSERT INTO bgc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","अर याकूब का कुआँ भी ओड़ैए था। यीशु सफर का थक्या होड़ उस कुएँ पै न्यूए बैठग्या। दोपहर का बखत होरया था। ");
INSERT INTO bgc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","इतनै म्ह एक सामरी बिरबान्नी पाणी भरण आई। यीशु नै उस ताहीं कह्या, “मन्नै पाणी पिया।” ");
INSERT INTO bgc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","क्यूँके उसके चेल्लें नगर म्ह खाणा मोल लेण जारे थे। ");
INSERT INTO bgc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","उस सामरी बिरबान्नी नै उस ताहीं कह्या, “तू यहूदी होकै मेरे तै सामरी बिरबान्नी तै पाणी क्यांतै माँग्गै सै?” (क्यूँके यहूदी सामरियाँ तै नफरत करै थे।) ");
INSERT INTO bgc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीशु नै जवाब दिया, “जै तू जाणदी के परमेसवर तन्नै के देणा चाहवै सै, अर वो कौण सै, जो तेरे तै कहवै सै, ‘मन्नै पाणी पिया,’ फेर तू उसतै माँगदी, अर वो तन्नै जीवन का पाणी देन्दा।” ");
INSERT INTO bgc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","बिरबान्नी नै उस ताहीं कह्या, “हे प्रभु, तेरे धोरै पाणी भरण नै तो किमे सै भी कोनी, अर कुआँ डून्घा सै, तो फेर वो जीवन का पाणी तेरे धोरै कड़ै तै आया? ");
INSERT INTO bgc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","के तू म्हारै पूर्वज याकूब तै बड्ड़ा सै, जिसनै म्हारै ताहीं यो कुआँ दिया, अर खुद भी अपणे ऊलादां, अर अपणे डान्गरां सुधा इस म्ह तै पिया?” ");
INSERT INTO bgc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीशु नै उस ताहीं जवाब दिया, “जो कोए यो पाणी पीवैगा वो फेर तिसाया होगा, ");
INSERT INTO bgc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पर जो कोए उस पाणी म्ह तै पीवैगा जो मै उस ताहीं दियुँगा वो फेर अनन्त काल ताहीं तिसाया कोनी होवैगा, बल्के जो पाणी मै उस ताहीं दियुँगा वो उस म्ह तै एक चोवा बण ज्यागा जो अनन्त जीवन खात्तर उमड़दा रहवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","बिरबान्नी नै उस ताहीं कह्या, “हे प्रभु, वो पाणी मन्नै दे ताके मै तिसाई ना होऊँ अर ना पाणी भरण नै इतनी दूर आऊँ।” ");
INSERT INTO bgc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीशु नै उस ताहीं कह्या, “जा अपणे धणी नै याड़ै बुला ल्या।” ");
INSERT INTO bgc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","बिरबान्नी नै जवाब दिया, “मै बिना धणी की सूं।” यीशु नै उस ताहीं कह्या, “तू ठीक कहवै सै, ‘मै बिना धणी की सूं।’ ");
INSERT INTO bgc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","क्यूँके तन्नै पाँच धणी कर लिए सै, अर जिस माणस कै गेल्या तू इब सै वो भी तेरा धणी कोनी। या तन्नै साच्ची-ए कही सै।” ");
INSERT INTO bgc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","बिरबान्नी नै उस ताहीं कह्या, “हे प्रभु, मन्नै लाग्गै सै तू नबी सै। ");
INSERT INTO bgc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","म्हारै सामरी पूर्वजां नै इस्से पहाड़ पै भगति करी, अर यहूदी लोग कहवै सै, के वा जगहां जड़ै भगति करणी चाहिए यरुशलेम नगर म्ह सै।” ");
INSERT INTO bgc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीशु नै उस ताहीं कह्या, “हे नारी,” मेरी बात का भरोस्सा कर, के वो बखत आवै सै, के थम ना तो इस पहाड़ पै पिता की भगति करोगे, ना यरुशलेम म्ह। ");
INSERT INTO bgc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","थम जिसनै कोनी जाणदे, उसकी भगति करो सो, अर हम यहूदी लोग जिसनै जाणा सा उसकी भगति करा सां, क्यूँके उद्धार यहूदियाँ म्ह तै सै। ");
INSERT INTO bgc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पर वो बखत आवै सै, बल्कि इब भी सै, जिसम्ह सच्चे भगत पिता की भगति आत्मा अर सच्चाई तै करैगें, क्यूँके पिता अपणे खात्तर इसेए भगतां नै टोहवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेसवर आत्मा सै अर जरूरी सै के उसकी भगति करण आळे आत्मा अर सच्चाई तै उसकी भगति करै। ");
INSERT INTO bgc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","बिरबान्नी नै उस ताहीं कह्या, “मै जांणु सूं के मसीह” जो ख्रिस्त कुहावै सै, “आण आळा सै, जिब वो आवैगा, फेर म्हारै ताहीं सारी बात बता देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीशु नै उस ताहीं कह्या, “मै जो तेरे तै बोल्लण लागरया सूं, मै वोए सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","इतनै म्ह उसके चेल्लें आण पोहचे, अर हैरान होण लागगे के वो बिरबान्नी तै बतळावै था, फेर भी किसे नै कोनी बुझ्झया, “तू के चाहवै सै? या क्यातै उसतै बतळावै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","फेर बिरबान्नी अपणा पैंढ़ा छोड़कै नगर म्ह चली गई, अर माणसां तै कहण लाग्गी, ");
INSERT INTO bgc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“आओ एक माणस नै देक्खो, जिसनै सारा किमे जो मन्नै करया मेरै तै बता दिया। कदे योए तो मसीह न्ही सै?” ");
INSERT INTO bgc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तब वे नगर के बासिन्दे गाम तै लिकड़कै यीशु कै धोरै आण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","इस बिचाळै उसके चेल्यां नै यीशु तै या बिनती करी, “हे गुरु, किमे खा ले।” ");
INSERT INTO bgc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","पर उसनै उन ताहीं कह्या, “मेरै धोरै खाण खात्तर इसा खाणा सै जिसनै थम कोनी जाणदे।” ");
INSERT INTO bgc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","फेर चेल्यां नै आप्पस म्ह कह्या, “के कोए उसकै खात्तर खाणा लेकै आया सै?” ");
INSERT INTO bgc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीशु नै उनतै कह्या, “मेरा खाणा यो सै के अपणे भेजण आळे की मर्जी कै मुताबिक चाल्लुँ अर उसके काम नै पूरा करुँ जो उसनै कह्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","के थम कोनी कहन्दे, ‘लामणीयां के इब्बै चार महिन्ने रहरे सै?’ अपणी आँखां तै देक्खों जितने माणस आण लागरे सै, वो उस खेत की तरियां सै जो काट्टण खात्तर तैयार सै। ");
INSERT INTO bgc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","पैहले तै मजदूर काम करण लागरया सै अर अपणी मजदूरी पाण लागरया सै, इसका मतलब यो सै के वो माणसां नै कठ्ठा करण लागरया सै जो अनन्त जीवन पागे। ");
INSERT INTO bgc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","क्यूँके याड़ै या कहावत ठीक बेठ्ठै सैः बोणआळा और सै, अर काट्टण आळा और। ");
INSERT INTO bgc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मन्नै थारे ताहीं वो खेत काट्टण खात्तर भेज्या जिसम्ह थमनै मेहनत कोन्या करी दुसरयां नै मेहनत करी अर थम उनकी मेहनत कै फळ म्ह हिस्सेदार होए।” ");
INSERT INTO bgc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","उस नगर के घणखरे सामरियाँ नै उस बिरबान्नी कै कहण तै यीशु पै बिश्वास करया, क्यूँके उसनै कह्या था, के “उसनै सारा किमे जो मन्नै करया सै, मेरै तै बता दिया।” ");
INSERT INTO bgc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ज्यांतै जिब सामरी उसकै धोरै आए, तो उसतै बिनती करण लागगे के म्हारै याड़ै रह। आखर म्ह वो ओड़ै दो दिन ताहीं रहया। ");
INSERT INTO bgc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","उसके वचन कै कारण और भी घणखरे माणसां नै बिश्वास करया ");
INSERT INTO bgc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","अर उस बिरबान्नी तै कह्या, “इब हम तेरे कहण तैए बिश्वास कोनी करदे, क्यूँके हमनै खुदे सुण लिया, अर जाणगे सा के योए साच्चए म्ह दुनिया का उद्धार करणीया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","फेर दो दिनां कै पाच्छै वो ओड़ै तै लिकड़कै गलील परदेस म्ह गया। ");
INSERT INTO bgc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","क्यूँके यीशु नै खुदे गवाही दी के नबी अपणे गाम म्ह आदर मान कोनी पान्दा। ");
INSERT INTO bgc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जिब वो गलील परदेस म्ह आया, तो गलील परदेस के माणस राज्जी होकै उसतै मिले, क्यूँके जितने काम उसनै यरुशलेम म्ह त्यौहार कै बखत करे थे, उननै उन सारया ताहीं देख्या था, क्यूँके वे भी त्यौहार म्ह जारे थे। ");
INSERT INTO bgc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","फेर वो दुबारै गलील परदेस कै काना नगर म्ह आया, जड़ै उसनै पाणी ताहीं अंगूर का रस बणाया था। ओड़ै राजा का एक कर्मचारी था जिसका बेट्टा कफरनहूम नगर म्ह बीमार था। ");
INSERT INTO bgc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","वो या सुणकै के यीशु यहूदिया परदेस तै गलील परदेस म्ह आ रहया सै, उसकै धोरै गया अर उसतै बिनती करण लागग्या के चालकै मेरै बेट्टै नै ठीक कर दे: क्यूँके वो मरण आळा था। ");
INSERT INTO bgc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीशु नै उस ताहीं कह्या, “जिब ताहीं थम चमत्कार अर अचम्भे के काम कोनी देखदे जद ताहीं कदे भी बिश्वास कोनी करोगे।” ");
INSERT INTO bgc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","राजा कै कर्मचारी नै उसतै कह्या, “हे प्रभु, मेरै बाळक की मौत होण तै पैहल्या चाल।” ");
INSERT INTO bgc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीशु नै उस ताहीं कह्या, “जा, तेरा बेट्टा जिन्दा सै।” उस माणस नै यीशु की कही होई बात का बिश्वास करया अर चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","वो रास्ते म्ह था के उसके नौक्कर उसतै आ मिले अर कहण लाग्गे, “तेरा छोरा जिन्दा सै।” ");
INSERT INTO bgc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","उसनै उसतै बुझ्झया, “किस बखत वो ठीक होण लागग्या?” उननै उस ताहीं कह्या, “काल दोफहरै एक बजे उसका बुखार उतर गया।” ");
INSERT INTO bgc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","फेर बाप जाण गया के यो उस्से बखत होया जिस बखत यीशु नै उस ताहीं कह्या, “तेरा बेट्टा जिन्दा रहवैगा,” अर उसनै अर उसके सारे कुण्बे नै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","यो दुसरा अचम्भे का काम था जो यीशु नै यहूदिया परदेस तै गलील परदेस म्ह आकै दिखाया। ");
INSERT INTO bgc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","इन बात्तां कै पाच्छै यहूदियाँ का एक त्यौहार आया, अर यीशु यरुशलेम नगर म्ह गया। ");
INSERT INTO bgc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरुशलेम म्ह भेड़-फाटक कै धोरै एक कुण्ड सै जो इब्रानी भाषा म्ह बैतहसदा कुह्वावै सै, उसके पाँच घाट सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","इन म्ह घणखरे बीमार, आन्धे, लंगड़े अर सूखे अंगआळे (पाणी कै हाल्लण कै आस म्ह) पड़े रहवै थे। ");
INSERT INTO bgc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(क्यूँके खास बखत पै परमेसवर के सुर्गदूत कुण्ड म्ह उतरकै पाणी नै हलाया करै थे। पाणी हाल्दे जो कोए पैहल्या उतरदा वोए ठीक हो जान्दा चाहे उसकै कोए बीमारी क्यूँ ना हो।) ");
INSERT INTO bgc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","उड़ै एक माणस था, जो अड़तीस साल तै बीमारी म्ह पड्या था। ");
INSERT INTO bgc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीशु नै उस ताहीं पड्या होया देखकै अर न्यू जाणकै के वो घणे दिनां तै इसी हाल्लत म्ह पड्या सै, उसतै बुझ्झया, “के तू ठीक होणा चाहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","उस बीमार नै उस ताहीं जवाब दिया, “हे प्रभु, मेरै धोरै कोए माणस कोनी के जिब पाणी हलाया जावै, तो मन्नै कुण्ड म्ह उतारै, पर मेरे पोंहोचदे-पोंहोचदे दुसरा मेरतै पैहल्या पाणी म्ह उतर जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीशु नै उस ताहीं कह्या, “उठ, अपणे बिस्तर ठाकै, हाँड-फिर।” ");
INSERT INTO bgc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","वो माणस जिब्बे ठीक होग्या, अर अपणे बिस्तर ठाकै हाँड़ण-फिरण लागग्या। ");
INSERT INTO bgc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","वो आराम का दिन था। ज्यांतै यहूदी उस ताहीं जो ठीक होया था, कहण लाग्गे, “आज तो आराम का दिन सै, तेरा बिस्तर ठाणा नियम-कायदा के मुताबिक ठीक कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","उसनै उन ताहीं जवाब दिया, “जिसनै मेरै ताहीं ठीक करया, उस्से नै मेरै ताहीं कह्या, ‘अपणा बिस्तर ठा अर हाँड-फिर।’” ");
INSERT INTO bgc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","उननै उसतै बुझ्झया, “वो कौण माणस सै जिसनै तेरे तै कह्या, ‘बिस्तर ठा, अर हाँड-फिर?’” ");
INSERT INTO bgc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","पर जो ठीक होया था वो कोनी जाणै था के वो कौण सै, क्यूँके उस जगहां पै भीड़ होण कै कारण यीशु ओड़ै तै चला ग्या था। ");
INSERT INTO bgc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","इन बात्तां कै पाच्छै वो यीशु नै मन्दर म्ह मिल्या। यीशु नै उस ताहीं कह्या, “देख, तू ठीक होग्या सै: दुबारा पाप ना करिये, इसा ना हो के इसतै कोए भारी संकट तेरे पै आण पड़ै।” ");
INSERT INTO bgc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","उस माणस नै जाकै यहूदियाँ तै कह दिया के जिसनै मेरै ताहीं ठीक करया वो यीशु सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","इस कारण यहूदी अगुवें यीशु नै तंग करण लाग्गे, क्यूँके वो इसे काम आराम कै दिन करया करदा। ");
INSERT INTO bgc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","इसपै यीशु नै उन ताहीं कह्या, “मेरा पिता सारी हाण काम करै सै, अर मेरे ताहीं भी करते रहणा सै।” ");
INSERT INTO bgc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","यीशु की बात के कारण यहूदी अगुवें और भी घणे उस ताहीं मारण खात्तर कोशिश करण लाग्गे, क्यूँके वो ना सिर्फ आराम कै दिन का नियम तोड्या करदा, पर परमेसवर नै अपणा पिता कहकै खुद ताहीं परमेसवर कै बरोबर भी ठैहरावै था। ");
INSERT INTO bgc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","इसपै यीशु नै उस ताहीं कह्या, “मै थारैताहीं साच्ची-साच कहूँ सूं, बेट्टा खुद तै किमे न्ही कर सकदा, सिर्फ वो जो पिता नै करदे देक्खै सै, क्यूँके जिन-जिन काम्मां नै वो करै सै उननै बेट्टा भी इस्से ढाळ करै सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","क्यूँके पिता बेट्टै तै प्यार करै सै अर जो-जो काम वो खुद करै सै, वो सारे उसतै दिखावै सैः अर वो इसतै भी बड़े काम उस ताहीं दिखावैगा, ताके थम हैरान होओ। ");
INSERT INTO bgc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","जिसा पिता मरे होया नै ठावै अर जिवांवै सै उस्से ढाळ बेट्टा भी जिननै चाहवै सै उननै जिवांवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","पिता किसे का न्याय कोनी करदा, पर न्याय करण का सारा काम बेट्टै ताहीं सौंप राख्या सै, ");
INSERT INTO bgc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ताके सारे माणस जिस ढाळ पिता की इज्जत करै सै उस्से ढाळ बेट्टै की भी इज्जत करै। जो बेट्टै की इज्जत कोनी करदा, वो पिता की भी इज्जत कोनी करदा, जिसनै उस ताहीं भेज्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मै थारैतै साच्ची-साच कहूँ सूं, जो मेरा वचन सुणकै उसपै बिश्वास करै सै, जिसनै मेरै ताहीं भेज्या सै, वो अनन्त जीवन पावै सै, अर उसपै दण्ड का हुकम कोनी होन्दा, पर वो मौत नै पार करकै जीवन म्ह दाखल हो लिया सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“मै थारैतै साच्ची-साच कहूँ सूं, वो बखत आवै सै, अर इब सै, जिसम्ह मरे होड़ परमेसवर के बेट्टै का वचन सुणैगें, अर जो सुणैगें वे जिवैंगे। ");
INSERT INTO bgc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","क्यूँके जिस ढाळ तै पिता खुद म्ह जीवन राक्खै सै, उस्से ढाळ तै उसनै बेट्टै ताहीं भी यो अधिकार दिया सै के खुद जीवन राक्खै। ");
INSERT INTO bgc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","बल्के मेरे ताहीं माणसां के न्याय करण का भी अधिकार दिया सै, ज्यांतै के मै माणस का बेट्टा सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","इसतै हैरान मतना होओ: क्यूँके वो बखत आवै सै के जितने मरे होए लोग कब्रां म्ह सै वे मेरा वचन सुणकै लिकड़ आवैगें। ");
INSERT INTO bgc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जिन नै भले काम करे सै वे जीवन कै पुनरुत्थान खात्तर जी जावैंगे अर जिन नै बुरे काम करे सै वे दण्ड के पुनरुत्थान खात्तर जी जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“मै खुद तो कुछ कोनी कर सकदा, जिसा सुणु सूं, उस्से तरियां न्याय करुँ सूं, अर मेरा न्याय साच्चा सै, क्यूँके मै अपणी मर्जी कोनी पर अपणे भेजण आळे की मर्जी चाहूँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","जै मै खुदे अपणी गवाही द्यूँ, तो मेरी गवाही साच्ची कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","एक और सै जो मेरा पिता सै, वो मेरी गवाही देवै सै, अर मै जाणु सूं, के मेरी जो गवाही वो देवै सै, वा साच्ची सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","थमनै यूहन्ना तै बुझवाया अर उसनै सच्चाई की गवाही दी सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","पर मै अपणे बारै म्ह माणसां की गवाही कोनी चाहन्दा, फेर भी मै ये बात ज्यांतै कहूँ सूं के थारा उद्धार हो। ");
INSERT INTO bgc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्ना तो बळदे अर चमकदे होए दीवै कै समान था, अर थमनै किमे वार ताहीं उसके चाँदणे म्ह मगन होणा भाया। ");
INSERT INTO bgc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पर मेरै धोरै जो गवाही सै वा यूहन्ना की गवाही तै बड्डी सै, क्यूँके जो काम पिता नै मेरै ताहीं निपटाण नै सौप्या सै यानिके योए काम जो मै करुँ सूं, वे मेरे गवाह सै के पिता नै मेरै ताहीं भेज्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","अर पिता जिसनै मेरै ताहीं भेज्या सै, उस्से नै मेरी गवाही दी सै। थमनै ना कदे उसका वचन सुण्या, अर ना उसकी शक्ल देक्खी सै, ");
INSERT INTO bgc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","अर उसकै वचन ताहीं मन म्ह बणाए कोनी राखदे, क्यूँके जिस ताहीं उसनै भेज्या थम उसका बिश्वास कोनी करदे। ");
INSERT INTO bgc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","थम पवित्र ग्रन्थ म्ह टोव्हो सो, क्यूँके समझों सो के उस म्ह अनन्त जीवन थारे ताहीं मिलै सै, अर यो वोए सै जो मेरी गवाही देवै सै, ");
INSERT INTO bgc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","फेर भी थम अनन्त जीवन पाण खात्तर मेरै धोरै आणा कोनी चाहन्दे। ");
INSERT INTO bgc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","मै माणसां तै आदर कोनी चाहन्दा। ");
INSERT INTO bgc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पर मै थमनै जाणु सूं, के थारे म्ह परमेसवर खात्तर प्यार कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","थम मेरे ताहीं पसन्द न्ही करते जिब के मै अपणे पिता कै नाम तै आया सूं, जै दुसरा कोए खुद कै नाम तै आवै, तो उसनै थम अपणा लोगे। ");
INSERT INTO bgc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","थम मेरै पै किस तरियां बिश्वास कर सको सो? क्यूँके थम तो आप्पस म्ह एक-दुसरे तै तारीफ सुणणा चाहो सो, अर उस तारीफ की ओड़ देखते भी कोनी जो एकमात्र परमेसवर तै आवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","न्यू ना समझियों के मै पिता के स्याम्ही थारे म्ह खोट काढ्ढू सूं, थारे म्ह खोट काढणिया तो मूसा नबी सै, जिसपै थमनै भरोस्सा करया सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","क्यूँके जै थम मूसा नबी पै बिश्वास करदे, तो मेरा भी बिश्वास करदे, ज्यांतै के उसनै मेरै बारै म्ह लिख्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","पर जै थम उसके पवित्र ग्रन्थ म्ह लिक्खी होई बात्तां पै बिश्वास कोनी करदे, तो मेरी बात्तां पै किस तरियां बिश्वास करोगे? ");
INSERT INTO bgc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","इन बात्तां कै पाच्छै यीशु गलील समुन्दर यानिके तिबिरियास की झील कै धोरै गया। ");
INSERT INTO bgc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","अर एक बड्डी भीड़ उसकै गेल्या हो ली क्यूँके जो अचम्भे के काम वो बिमारां पै दिखावै था वे उननै देख्या करै थे। ");
INSERT INTO bgc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","फेर यीशु पहाड़ पै चढ़कै अपणे चेल्यां कै गेल्या बैठग्या। ");
INSERT INTO bgc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहूदियाँ कै फसह का त्यौहार लोवै था। ");
INSERT INTO bgc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","जिब यीशु नै अपणी आँख ठाकै एक बड्डी भीड़ ताहीं अपणे कान्ही आन्दे देख्या, फेर फिलिप्पुस ताहीं कह्या, “हम इनकै खाणे कै खात्तर कड़ै तै रोट्टी मोल ल्यावां?” ");
INSERT INTO bgc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","उसनै या बात उस ताहीं आजमाण ताहीं बोल्ली, क्यूँके वो खुदे जाणै था के वो के करैगा। ");
INSERT INTO bgc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुस नै उस ताहीं जवाब दिया, “दो सौ दीनार (200 दिन की मजदूरी) की रोट्टी भी उन खात्तर पूरी कोनी पड़ै के उन म्ह तै हरेक नै माड़ी-माड़ी मिल जा।” ");
INSERT INTO bgc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","उसके चेल्यां म्ह तै शमौन पतरस का भाई अन्द्रियास नै उस ताहीं कह्या, ");
INSERT INTO bgc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“याड़ै एक छोरा सै जिसकै धोरै जौ की पाँच रोट्टी अर दो मच्छी सै, पर इतने माणसां खात्तर वे के सै?” ");
INSERT INTO bgc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीशु बोल्या, “माणसां नै बिठा द्यो।” उस जगहां घणी घास थी: फेर माणस जिन म्ह आदमियाँ की गिणती करीबन पाँच हजार की थी, बैठगे। ");
INSERT INTO bgc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","फेर यीशु नै रोट्टी ली अर परमेसवर का धन्यवाद करकै बैठण आळा ताहीं बांड दीः अर उस्से ढाळ मच्छियाँ म्ह तै जितनी वे चाहवै थे, बांड दी। ");
INSERT INTO bgc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जिब वे खाकै छिकगे फेर वो चेल्यां तै बोल्या, “बचे होड़ टुकड़े कठ्ठे कर ल्यो के किमे बगायां न्ही जावै।” ");
INSERT INTO bgc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","आखर म्ह उननै कठ्ठा करया, अर जौ की पाँच रोटियाँ के टुकड्या तै जो खाण आळा तै बची होड़ थी, बारहा टोकरी भरी। ");
INSERT INTO bgc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","फेर जो अचम्भे के काम उसनै कर दिखाये उसनै वे माणस देखकै कहण लाग्गे, “वो नबी जो दुनिया म्ह आण आळा था, पक्का योए सै।” ");
INSERT INTO bgc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीशु न्यू जाणकै के वे मन्नै राजा बणाण खात्तर पकड़णा चाहवै सै, फेर पहाड़ पै एक्ला चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","जिब साँझ होई, तो उसके चेल्लें झील कै किनारे गए, ");
INSERT INTO bgc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","अर किस्ती पै चढ़कै झील कै परली ओड़ कफरनहूम नगर म्ह जाण लाग्गे। उस बखत अन्धेरा होग्या था, अर यीशु इब ताहीं उनकै धोरै कोनी आया था। ");
INSERT INTO bgc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","अर आँधी कै कारण समुन्दर म्ह झांल उठ्ठण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","जिब वे खेते-खेते तीन-चार कोस कै करीबन लिकड़गे, फेर उननै यीशु ताहीं समुन्दर पै चाल्दे अर किस्ती कै धोरै आन्दे देख्या, अर डरगे। ");
INSERT INTO bgc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पर उसनै उनतै कह्या, “मै सूं, डरो मतना।” ");
INSERT INTO bgc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","आखर म्ह वे उसनै किस्ती पै चढ़ाण नै राज्जी होए अर जिब्बे वा किस्ती उस जगहां पै जा पोहची जड़ै वे जाण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","जो लोग गलील समुन्दर के उस पार रहगे थे, उननै दुसरे दिन देख्या के याड़ै सिर्फ एक ए किस्ती थी, अर यीशु अपणे चेल्यां गेल्या उस किस्ती पै कोनी चढ़या था, पर सिर्फ उसके चेल्लें एक्ले ए चले गए थे। ");
INSERT INTO bgc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तिबिरियास नगर की कुछ किस्ती उस जगहां कै धोरै आकै रुकी, जड़ै प्रभु नै परमेसवर का धन्यवाद करकै भीड़ ताहीं रोट्टी खुआई थी। ");
INSERT INTO bgc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","जिब भीड़ नै देख्या के याड़ै ना यीशु सै अर ना उसके चेल्लें, फेर वे भी छोट्टी-छोट्टी किस्तियाँ पै चढ़कै यीशु नै टोन्दे होए कफरनहूम नगर पोहचे। ");
INSERT INTO bgc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","गलील समुन्दर कै परली ओड़ जिब वे उसतै मिले तो बोल्ले, “हे गुरु, तू याड़ै कद आया?” ");
INSERT INTO bgc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीशु नै उन ताहीं जवाब दिया, “मै थारैताहीं साच्ची-साच कहूँ सूं, थम मन्नै ज्यांतै कोनी टोव्हो सो के थमनै अचम्भे के काम देक्खे, पर ज्यांतै के थमनै पेट भरकै रोट्टी खाई थी।” ");
INSERT INTO bgc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","उस खाणे खात्तर मेहनत ना करो जो सड़ जावै सै, पर उस खाणे खात्तर जतन करो जो कदे खराब न्ही होंदा अर अनन्त जीवन देवै सै, मै माणस का बेट्टा यो खाणा थारे ताहीं देऊँगा, क्यूँके पिता परमेसवर नै मेरे ताहीं इसा करण का हक दिया सै। ");
INSERT INTO bgc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","वे उसतै बोल्ले, “परमेसवर के काम करण खात्तर हम के करा?” ");
INSERT INTO bgc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीशु नै उन ताहीं जवाब दिया, “परमेसवर चाहवै सै, के थम उसपै बिश्वास करो, जिस ताहीं उसनै भेज्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","फेर वे उसतै बोल्ले, “फेर तू कौण सा निशान दिखावै सै के हम उसनै देखकै तेरा बिश्वास करा? तू कौण सा काम दिखावै सै? ");
INSERT INTO bgc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","म्हारै पूर्वजां नै जंगल-बियाबान म्ह मन्ना खाया, जिसा पवित्र शास्त्र म्ह लिख्या सै, ‘परमेसवर नै उन ताहीं खाण खात्तर सुर्ग तै रोट्टी देई।’” ");
INSERT INTO bgc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","यीशु नै उनतै कह्या, “मै थारे ताहीं साच्ची-साच कहूँ सूं, के मूसा नबी नै थारे ताहीं वा रोट्टी सुर्ग तै कोनी दी, पर मेरा पिता थमनै सुर्ग तै असली रोट्टी देवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","क्यूँके परमेसवर की रोट्टी वाए सै, जो सुर्ग तै उतरकै दुनिया के माणसां ताहीं जिन्दगी देवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","फेर यो सुणकै यीशु तै बिनती करी, “के हे प्रभु, वा रोट्टी हमनै सदा दिया कर।” ");
INSERT INTO bgc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीशु नै उनतै कह्या, “जीवन की रोट्टी मै सूं: जो मेरै धोरै आवैगा, वो कदे भूक्खा कोनी रहवैगा, अर जो कोए मेरै पै बिश्वास करैगा, वो कदे तिसाया कोनी होवैगा। ");
INSERT INTO bgc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","पर मन्नै थारे ताहीं पैहले तै कह्या था, के थमनै मेरैताहीं देख भी लिया सै, फेर भी बिश्वास कोनी करदे। ");
INSERT INTO bgc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","वे सारे जो पिता नै मेरे ताहीं दिये सै, वे मेरै धोरै आवैगें, अर हर एक जो कोए मेरै धोरै आवैगा उसनै मै कदे भी कोनी छोड्डूंगा। ");
INSERT INTO bgc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","पर मै अपणी मर्जी कोनी पर अपणे भेजण आळे पिता की मर्जी पूरी करण खात्तर सुर्ग तै उतरया सूं। ");
INSERT INTO bgc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","अर मेरै भेजण आळे की मर्जी या सै के जो किमे उसनै मेरै ताहीं दिया सै, उस म्ह तै मै किसे नै ना खोऊँ, पर उसनै आखर के दिनां म्ह दुबारै जिन्दा कर द्यूँ। ");
INSERT INTO bgc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","क्यूँके मेरै पिता की मर्जी या सै के जो कोए बेट्टै नै अपणा कै उसपै बिश्वास करै, वो अनन्त जीवन पावै, अर मै उसनै आखरी के दिनां म्ह दुबारै जिन्दा करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","इसपै यहूदी उसपै बिरड़ाण लागगे, क्यूँके उसनै कह्या था, “जो रोट्टी सुर्ग तै उतरी, वा मै सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","अर वे बोल्ले, “के यो यीशु सै, यूसुफ का बेट्टा, जिसकै माँ-बाप नै हम जाणां सां? फेर वो किस ढाळ कह सकै सै के मै सुर्ग तै उतरया सूं?” ");
INSERT INTO bgc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीशु नै उन ताहीं जवाब दिया, “आप्पस म्ह मतना बिरड़ाओ।” ");
INSERT INTO bgc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोए मेरै धोरै कोनी आ सकदा जिब ताहीं पिता, जिसनै मेरैताहीं भेज्या सै, उसनै खींच न्ही लेवै, अर मै उसनै आखर के दिनां म्ह फेर जिन्दा करुँगा। ");
INSERT INTO bgc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","नबियाँ के लेखां म्ह यो लिख्या सै: “वे सारे परमेसवर की ओड़ तै सिखाए होए होवैगें।” जिस किसे नै पिता तै सुण्या अर सिख्या सै, वो मेरै धोरै आवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","किसे नै पिता ताहीं कोनी देख्या, सिवाए उसके, जो परमेसवर की ओड़ै तै सै, सिर्फ उस्से नै पिता ताहीं देख्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","मै थारैताहीं साच्ची-साच कहूँ सूं, के जो कोए बिश्वास करै सै, अनन्त जीवन उस्से का सै। ");
INSERT INTO bgc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","जीवन की रोट्टी मै सूं। ");
INSERT INTO bgc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","थारे पूर्वजां नै जंगल-बियाबान म्ह मन्ना खाया अर मरगे। ");
INSERT INTO bgc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","या वा रोट्टी सै जो सुर्ग तै उतरी सै, ताके माणस उस म्ह तै खावै अर ना मरै। ");
INSERT INTO bgc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","जीवन की रोट्टी जो सुर्ग तै उतरी सै, मै सूं। जै कोए इस रोट्टी म्ह तै खावै, तो सारी हाण जिन्दा रहवैगा, अर जो रोट्टी मै दुनिया कै जीवन खात्तर दियुँगा, वो मेरा माँस सै। ");
INSERT INTO bgc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","इसपै यहूदी न्यू कहकै आप्पस म्ह बहस करण लागगे, “यो माणस किस ढाळ हमनै अपणा माँस खाण नै दे सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीशु नै उन ताहीं कह्या, “मै थारैताहीं साच्ची-साच कहूँ सूं, के जिब ताहीं थम मुझ माणस कै बेट्टे का माँस ना खाओ, अर मेरा लहू ना पियो, थारे म्ह जीवन कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जो मेरा माँस खावै अर मेरा लहू पीवै सै, अनन्त जीवन उस्से का सै, अर आखरी के दिनां म्ह मै उसनै दुबारै जिन्दा कर दियुँगा। ");
INSERT INTO bgc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","क्यूँके मेरा माँस सच म्ह खाण की चीज सै, अर मेरा लहू सच म्ह पीण की चीज सै। ");
INSERT INTO bgc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जो मेरा माँस खावै अर मेरा लहू पीवै सै वो मेरै म्ह डटया रहवै सै, अर मै उस म्ह। ");
INSERT INTO bgc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जिसा जिन्दे पिता नै मेरैताहीं भेज्या सै, अर मै पिता कै कारण जिन्दा सूं, उस्से ढाळ वो भी जो मन्नै खावैगा मेरै कारण जिन्दा रहवैगा। ");
INSERT INTO bgc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","जो रोट्टी सुर्ग तै उतरी सै याए सै, उस रोट्टी बरगी कोनी जो पूर्वजां नै खाई अर मरगे, जो कोए या रोट्टी खावैगा, वो सदा ताहीं जिन्दा रहवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ये बात उसनै कफरनहूम नगर कै एक आराधनालय म्ह उपदेश देन्दे बखत कही। ");
INSERT INTO bgc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","उसके चेल्यां म्ह तै घणखरा नै या सुणकै कह्या, “या सख्त शिक्षा सै, इसनै कौण सुण सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीशु नै अपणे मन म्ह न्यू जाणकै के मेरे चेल्लें आप्पस म्ह इस बात पै बिरड़ावै सै, उन ताहीं बुझ्झया, “के इस बात तै थारे ताहीं ठेस लाग्गै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","जै थम मुझ माणस कै बेट्टै नै जड़ै मै पैहल्या था, ओड़ैए उप्पर जान्दे देक्खोगे, तो के होगा? ");
INSERT INTO bgc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आत्मा ए सै जो देह नै जीवन देवै सै, देह का कोए महत्व कोनी, जो वचन मन्नै थारैतै कह्ये सै, वे आत्मा सै, अर जीवन भी। ");
INSERT INTO bgc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","पर थारे म्ह तै किमे इसे सै जो बिश्वास कोनी करदे। क्यूँके यीशु पैहल्या तै ए जाणै था के जो बिश्वास न्ही करदे, वे कौण सै, अर कौण मेरै ताहीं पकड़वावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","अर वो बोल्या, “ज्यांतै मन्नै थारे ताहीं कह्या था के जिब ताहीं किसे नै पिता की ओड़ तै यो वरदान ना मिलै तब ताहीं वो मेरै धोरै कोनी आ सकदा।” ");
INSERT INTO bgc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","इसपै उसकै चेल्यां म्ह तै घणखरे उल्टे हटगे अर उसकै बाद उसकै गेल्या कोनी चाल्ले। ");
INSERT INTO bgc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","फेर यीशु नै उन बारहां चेल्यां तै कह्या, “के थम भी चले जाणां चाहो सो?” ");
INSERT INTO bgc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","शमौन पतरस नै उस ताहीं जवाब दिया, “हे प्रभु, हम किसकै धोरै जावां? अनन्त जीवन की बात तो तेरैए धोरै सै, ");
INSERT INTO bgc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","अर हमनै बिश्वास करया अर जाणगे सै के परमेसवर का पवित्र जन तूए सै।” ");
INSERT INTO bgc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीशु नै उन ताहीं जवाब दिया, “के मन्नै थम बारहां चेल्यां ताहीं कोन्या छाट्या? फेरभी थारे म्ह तै एक जन शैतान सै।” ");
INSERT INTO bgc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","यो उसनै शमौन इस्करियोती के बेट्टै यहूदा कै बारै म्ह कह्या था, क्यूँके वोए जो बारहां चेल्यां म्ह तै एक था, उस ताहीं पकड़वाण म्ह था। ");
INSERT INTO bgc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","इन बात्तां कै हो लेण कै पाच्छै यीशु गलील परदेस म्ह सफर करण लाग्या, वो यहूदिया परदेस म्ह जाणा कोनी चाहवै था, क्यूँके यहूदी लोग उस ताहीं मारण की ताक म्ह थे। ");
INSERT INTO bgc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","यहूदियाँ का झोपड़ियाँ का त्यौहार लोवै था। ");
INSERT INTO bgc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ज्यांतै उसके भाईयाँ नै उस ताहीं कह्या, “याड़ै तै यहूदिया परदेस नै जा, ताके जो काम तू करै सै उननै तेरे चेल्लें ओड़ै भी देक्खै। ");
INSERT INTO bgc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","क्यूँके इसा कोए न्ही होगा जो मशहुर होणा चाहवै, अर लुह्क कै काम करै। जै तू यो काम करै सै, तो खुद नै दुनिया म्ह साबित कर।” ");
INSERT INTO bgc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","क्यूँके उसके भाई भी उसपै बिश्वास कोनी करै थे। ");
INSERT INTO bgc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","फेर यीशु नै उनतै कह्या, “मेरे खात्तर इब्बै सही बखत कोनी आया, पर थारे खात्तर सारा बखत सही सै। ");
INSERT INTO bgc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","दुनिया थारे तै बैर कोनी कर सकदी, पर वा मेरै तै बैर करै सै क्यूँके मै उसकै बिरोध म्ह या गवाही दियुँ सूं के उसके काम भुन्डे़ सै। ");
INSERT INTO bgc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","थम त्यौहार म्ह जाओ, मै इब्बै इस त्यौहार म्ह कोनी जान्दा, क्यूँके इब्बै मेरा सही बखत कोनी आया।” ");
INSERT INTO bgc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","वो उनतै ये बात कहकै गलील परदेस म्ह रहग्या। ");
INSERT INTO bgc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","पर जिब उसके भाई त्यौहार म्ह जा लिए तो वो खुद भी, जाहिर म्ह न्ही पर मान्नो गुप्ती तै गया। ");
INSERT INTO bgc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","त्यौहार म्ह कुछ यहूदी लोग यीशु ताहीं टोह्न्दे होए पूछताछ करण लागरे थे, “के वो कड़ै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","फेर भी यीशु के बारें म्ह बड़ी बहस होण लागरी थी, कई माणस कहवै थे, “के वो भला माणस सै।” अर कईयाँ का कहणा था, “के ना, वो माणसां नै बहकावै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","फेर भी यहूदियाँ कै डरकै मारे कोए भी माणस यीशु कै बारै म्ह खुलकै कोनी बोल्लै था। ");
INSERT INTO bgc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","जिब त्यौहार के आध्धे दिन बीतगे, फेर यीशु मन्दर म्ह जाकै उपदेश देण लागग्या। ");
INSERT INTO bgc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","फेर यहूदियाँ नै हैरान होकै कह्या, “इसनै बिना पढ़े ज्ञान किस तरियां आ ग्या?” ");
INSERT INTO bgc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीशु नै उन ताहीं जवाब दिया, “जो उपदेश मै देऊँ सूं, मेरा अपणा कोनी, पर उसतै आवै सै जिसनै मेरे ताहीं भेज्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","जै कोए माणस उसकी मर्जी पै चाल्लण का प्रण करै, तो उस ताहीं यो बेरा लाग ज्यागा, के यो उपदेश परमेसवर की ओड़ तै सै, या मै अपणी ओड़ तै देऊँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जो अपणी ओड़ तै कुछ कहवै सै, वो खुद की बड़ाई चाहवै सै, पर जो अपणे भेजण आळे की बड़ाई चाहवै सै वोए साच्चा सै, अर उस म्ह अधर्म कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","के मूसा नबी नै थारैताहीं नियम-कायदे कोनी दिये? फेरभी थारैम्ह तै कोए नियम-कायदा पै कोनी चाल्दा। थम मन्नै क्यातै मारणा चाहो सो?” ");
INSERT INTO bgc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","माणसां नै जवाब दिया, “तेरे म्ह ओपरी आत्मा सै! कौण तन्नै मारणा चाहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीशु नै उन ताहीं जवाब दिया, “मन्नै आराम कै दिन एक चमत्कार करया, अर थम सारे छो म्ह होगे। ");
INSERT INTO bgc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","इस्से खात्तर मूसा नबी नै थारैताहीं खतने का नियम दिया था (यो नियम मूसा नबी का न्ही था बल्के या थारे पूर्वजां तै ए लाग लागरी सै) अर थम आराम कै दिन माणस का खतना करो सो। ");
INSERT INTO bgc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जिब आराम कै दिन माणस का खतना करया जावै सै ताके मूसा नबी कै नियम-कायदा का हुकम न्ही टळै। फेर थम मेरै पै क्यांतै छो करो सो के मन्नै आराम कै दिन एक माणस ताहीं पूरी तरियां ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मुँह देख्या न्याय मतना करो, पर सही-सही न्याय करो।” ");
INSERT INTO bgc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","फेर यरुशलेम म्ह रहण आळे माणसां म्ह तै कईयाँ नै कह्या, “के यो वोए कोनी जिस ताहीं यहूदी अगुवें मार देणा चाहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पर लखाओ, “वो तो सरेआम बात करै सै अर कोए उसतै किमे कोनी कहन्दा। के यो न्ही हो सकता के यहूदी अगुवां नै साच्ये बेरा पाटग्या सै, के योए मसीह सै? ");
INSERT INTO bgc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","इसकै बारै म्ह हमनै बेरा सै यो कितका सै, पर मसीह जिब आवैगा तो कोए कोनी जाणै के वो कितका सै।” ");
INSERT INTO bgc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","फेर यीशु नै मन्दर म्ह उपदेश देन्दे होए रुक्का मारकै कह्या, “थम मन्नै जाणो सो, अर न्यू भी जाणो सो के मै कित्त तै आया सूं। मै तो खुद कोनी आया, पर मेरा भेजण आळा साच्चा सै, उसनै थम कोनी जाणदे। ");
INSERT INTO bgc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","पर मै उसनै जाणु सूं, क्यूँके मै उसकै कान्ही तै आया सूं, अर उस्से नै मेरै ताहीं भेज्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","यो सुणकै यहूदी अगुवां नै यीशु ताहीं पकड़णा चाह्या, फेरभी किसे नै उसकै हाथ कोनी लाया, क्यूँके उसके मरण का सही बखत इब्बै कोनी आया था। ");
INSERT INTO bgc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","फेर भी भीड़ म्ह तै घणखरे माणसां नै उसपै बिश्वास करया, अर बोल्ले, “मसीह जिब आवैगा तो के इसतै घणे अचम्भे के काम दिखावैगा जो इसनै दिखाए?” ");
INSERT INTO bgc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसियाँ नै भीड़ म्ह माणस ताहीं यीशु के बारें म्ह चुपके-चुपके बात करते सुण्या, तो प्रधान याजक अर फरीसियाँ नै यीशु ताहीं पकड़ण खात्तर मन्दर के सिपाहियाँ ताहीं भेज्या। ");
INSERT INTO bgc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","मसीह यीशु बोल्या, “मै थोड़ी बार ताहीं थारे गेल्या सूं, फेर अपणे भेजण आळे धोरै उल्टा चल्या जाऊँगा। ");
INSERT INTO bgc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","थम मन्नै टोहओगे, पर कोनी पाओगे, अर जड़ै मै सूं, ओड़ै थम कोनी आ सकदे।” ");
INSERT INTO bgc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","इसपै यहूदी अगुवां नै आप्पस म्ह कह्या, “यो कित्त जावैगा, के हम इसनै कोनी टोह् सकदे? के यो जो यूनानी परदेशियाँ म्ह तो बसणा न्ही चाहन्दा, ताके यूनानियाँ ताहीं भी उपदेश दे? ");
INSERT INTO bgc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","इसकी इस बात का के मतलब सै? जो उसनै बोल्ली सै, के थम मन्नै टोहओगे, पर कोनी पाओगे, अर जड़ै मै सूं, ओड़ै थम न्ही आ सकदे।” ");
INSERT INTO bgc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","त्यौहार कै आखरी दिन, जो खास दिन सै, यीशु खड्या होया अर रुक्का मारकै कह्या, “जै कोए तिसाया हो तो मेरै धोरै आवै अर पीवै। ");
INSERT INTO bgc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जो कोए मेरै पै बिश्वास करैगा, जिसा पवित्र ग्रन्थ म्ह लिख्या सै, ‘उसकी अंतरआत्मा म्ह तै जीवन कै जल की नदियाँ बह लिकड़ैंगी, जो अनन्त जिन्दगी देवै सै।’” ");
INSERT INTO bgc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","यीशु नै यो वचन पवित्र आत्मा कै बारै म्ह कह्या, जो बिश्वास करण आळा नै मिलण आळी थी, क्यूँके इब ताहीं पवित्र आत्मा कोनी उतरया था, क्यूँके यीशु इब ताहीं अपणी महिमा म्ह कोनी पोंहच्या था। ");
INSERT INTO bgc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","फेर भीड़ म्ह तै कईयाँ नै या बात सुणकै कह्या, “साच्ये योए वो नबी सै, जिसके आण की हम आस देक्खां थे।” ");
INSERT INTO bgc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","अर कईयाँ नै कह्या, “यो मसीह सै” पर कई बोल्ले, “मसीह गलील परदेस तै तो न्ही आवैगा?” ");
INSERT INTO bgc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","पवित्र ग्रन्थ यो कहवै सै, के मसीह दाऊद की पीढ़ी तै अर बैतलहम नगर तै आवैगा, जड़ै दाऊद रहवै था? ");
INSERT INTO bgc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","आखर म्ह उसकै कारण माणसां म्ह फूट पड़ी। ");
INSERT INTO bgc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","उन म्ह तै कई उस ताहीं पकड़णा चाहवै थे, पर किसे नै उसकै हाथ कोनी लाया। ");
INSERT INTO bgc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","फेर सिपाही, प्रधान याजकां अर फरीसियाँ कै धोरै बोहड़ आए, उननै उन ताहीं कह्या, “थम उसनै क्यातै न्ही ल्याए?” ");
INSERT INTO bgc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सिपाहियाँ नै जवाब दिया, “इसी बात बताण आळा माणस हमनै आज ताहीं कदे भी कोनी मिल्या।” ");
INSERT INTO bgc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरीसियाँ नै उन ताहीं जवाब दिया, “के थम भी भळोई म्ह आग्गै? ");
INSERT INTO bgc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","के सरदारां या फरीसियाँ म्ह तै किसे नै भी उसपै बिश्वास करया सै? ");
INSERT INTO bgc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","पर ये माणस जो मूसा नबी के नियम-कायदे कोनी जाणदे, परमेसवर की ओड़ तै सरापित सै।” ");
INSERT INTO bgc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुस जो उन म्ह तै एक था, वो मसीह यीशु तै पैहल्या मिल चुका था, उन ताहीं बोल्या, ");
INSERT INTO bgc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“के म्हारे नियम-कायदे किसे माणस नै, जिब ताहीं पैहल्या उसकी सुणकै जाण ना लेवै, के वो के करै सै, कसूरवार मान्नै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","उननै नीकुदेमुस ताहीं जवाब दिया, “तू भी गलील परदेस का सै? पवित्र ग्रन्थ म्ह ढूँढ़ अर देख के गलील परदेस तै कोए नबी कोनी आवै।” ");
INSERT INTO bgc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","फेर सारे अपणे-अपणे घरां चले गए। ");
INSERT INTO bgc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","यीशु अपणे चेल्यां कै गैल जैतून कै पहाड़ पै गया। ");
INSERT INTO bgc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","तड़कैए आगले दिन यीशु फेर मन्दर म्ह आया। भोत सारे माणस उसकै धोरै आए अर वो बैठकै उननै उपदेश देण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","जिब वो बोलण लागरया था, तो जिब्बे शास्त्री अर फरीसी एक बिरबान्नी नै ल्याए, जो जारी करते होए रंगे हाथ पकड़ी गयी थी, अर उस ताहीं माणसां के स्याम्ही खड्या कर दिया, अर यीशु ताहीं कह्या, ");
INSERT INTO bgc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“हे गुरु, या बिरबान्नी जारी कर दी रंगे हाथ पकड़ी गयी सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","मूसा नबी के नियम-कायदा म्ह उसनै म्हारै ताहीं हुकम दिया सै, के इसी बिरबान्नी नै पत्थर बरसा कै मार द्यो। पर तू इस बिरबान्नी कै बारै म्ह के कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","उननै यीशु ताहीं परखण खात्तर या बात कही, ताके उस म्ह खोट लिकाड़ण का कोए सुराग मिलै जावै। पर यीशु कोड्डा होकै आन्गळी तै धरती पै लिखण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जिब वे बार-बार उसतै सवाल करते रहे, तो फेर उसनै सीध्धा होकै उन ताहीं कह्या, “थारे म्ह जिसनै भी कोए पाप न्ही करया हो, वोए उसकै सबतै पैहला पत्थर मारै।” ");
INSERT INTO bgc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","फेर यीशु कोड्डा होकै आन्गळी तै धरती पै लिक्खण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","जिब माणसां नै यो सुण्या तो सबतै पैहले बूढ़े माणस अर फेर एक-एक करकै ओड़ै तै खिसकण लाग्गे, क्यूँके वे सब जाणै थे, के हम सब पापी सां, अर सिर्फ यीशु अर वा बिरबान्नी ओड़ै रहगे। ");
INSERT INTO bgc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीशु खड्या होया अर उस बिरबान्नी ताहीं कह्या, “हे नारी, वे कित्त गए? के किस्से नै तेरे ताहीं दण्ड न्ही दिया?” ");
INSERT INTO bgc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","वा बोल्ली, “हे प्रभु, किसे नै न्ही।” यीशु बोल्या, “मै भी तेरे ताहीं दण्ड न्ही देऊँगा, जा, अर दुबारा कदे पाप ना करिए।” ");
INSERT INTO bgc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","मन्दर म्ह अपणे उपदेश नै दुबारै शरु करदे होए यीशु नै माणसां तै कह्या, “दुनिया का चाँदणा मै सूं, जो कोए मेरै पाच्छै चाल्लैगा, वो अन्धेरै म्ह कदे कोनी चाल्लैगा, पर वो चाँदणा पावैगा जो अनन्त जीवन देवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसियाँ नै उस ताहीं कह्या, “तू अपणी गवाही खुद देवै सै, इस खात्तर तेरी गवाही साच्ची कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीशु नै उन ताहीं जवाब दिया, “भलाए मै अपणी गवाही खुद देऊँ सूं, फेर भी मेरी गवाही मान्नी जावैगी, क्यूँके मै जाणु सूं, के मै कित्त तै आया सूं, अर कितोड़ जाऊँ सूं? पर थम कोनी जाणदे के मै कित्त तै आऊँ सूं, या कितोड़ जाऊँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","थम मानवीय सोच तै, न्याय करो सो, मै किसे का न्याय कोनी करदा। ");
INSERT INTO bgc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","जै मै न्याय करुँ भी तो वो सही ए होगा, क्यूँके मै एक्ला कोनी, पर परम पिता, जिसनै मेरै ताहीं भेज्या सै, वो अर मै दोन्नु मिलकै न्याय करा सां। ");
INSERT INTO bgc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","थारे मूसा नबी के नियम-कायदा म्ह भी लिख्या सै, के दो जण्यां की गवाही सच के रूप म्ह मान्नी जा सकै सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","एक तो मै खुद अपणी गवाही दियुँ सूं, अर दुसरा मेरा पिता मेरी गवाही देवै सै, जिसनै मेरैताहीं भेज्या।” ");
INSERT INTO bgc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","उननै उस ताहीं कह्या, “तेरा पिता कित्त सै?” यीशु नै जवाब दिया, “ना थम मन्नै जाणो सो, ना मेरै पिता नै, जै मन्नै जाणदे तै मेरै पिता नै भी जाणदे।” ");
INSERT INTO bgc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","यीशु नै ये वचन मन्दर म्ह उपदेश देन्दे होए भण्डार घर म्ह बोल्ली, अर किसे नै उस ताहीं कोनी पकड्या, क्यूँके उसके दुख ठाण का अर मरण का बखत इब ताहीं कोनी आया था। ");
INSERT INTO bgc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीशु नै फेर उन ताहीं कह्या, “मै जाऊँ सूं, अर थम मन्नै टोहओगे, अर अपणे पाप म्ह मरोगे। जड़ै मै जाऊँ सूं, ओड़ै थम न्ही आ सकदे।” ");
INSERT INTO bgc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","इसपै यहूदी अगुवां नै कह्या, “के वो खुद नै मार देवैगा, जो कहवै सै, ‘जड़ै मै जाऊँ सूं, ओड़ै थम न्ही आ सकदे?’” ");
INSERT INTO bgc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","यीशु नै उन ताहीं कह्या, “थम इस दुनिया म्ह पैदा होए सों, अर मै सुर्ग तै आया सूं। थम इस दुनिया के सो, मै इस दुनिया का कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ज्यांतै मन्नै थारे ताहीं कह्या के थम अपणे पापां म्ह मरोगे, जै थारा मेरे म्ह बिश्वास कोनी के मै कौण सूं, तो थम मरोगे, अर थारे पाप माफ कोनी होंगे।” ");
INSERT INTO bgc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","यहूदी अगुवां नै यीशु ताहीं कह्या, “के तू कौण सै?” वो उनतै बोल्या, जिब तै मन्नै प्रचार करणा शरु करया सै, तब तै मै थमनै कहन्दा आया सूं, “के मै कौण सूं?” ");
INSERT INTO bgc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“थारे बारै म्ह कहण खात्तर अर फैसला करण खात्तर मेरे धोरै भोत कुछ सै, पर सच्चाई याए सै के जिसनै मेरे ताहीं भेज्या सै, मै वोए कहूँ सूं, जो मन्नै उसतै सुण्या सै, वोए दुनिया के माणसां तै कहूँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","वे न्यू न्ही समझै के म्हारै तै, पिता कै बारै म्ह कहवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","फेर यीशु बोल्या, “जिब थम मुझ माणस कै बेट्टै नै ऊँच्चे पै चढ़ाओगे, जिब जाणोगे के मै वोए सूं। मै खुद तै किमे कोनी करदा, पर जिस तरियां मेरै पिता नै, मेरै ताहीं सिखाया सै, उस्से ढाळ ये बात कहूँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","मेरा भेजण आळा मेरै गेल्या सै, उसनै मेरैताहीं एक्ला कोनी छोड्या क्यूँके मै सारी हाण वैए काम करुँ सूं, जिसतै वो राज्जी होवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","वो ये बात कहणे लागरया था, के घणखरयां नै उसपै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","फेर यीशु नै उन यहूदियाँ तै जिन नै उसपै बिश्वास करया था, बोल्या, “जै थम मेरै वचन म्ह बणे रहोगे, तो साच-ए मेरे चेल्लें ठहरोगे।” ");
INSERT INTO bgc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","थम सच नै जाणोगे अर सच थमनै आजाद करैगा। ");
INSERT INTO bgc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","उननै उस ताहीं जवाब दिया, “हम तो अब्राहम के वंशज सा, कदे किसे के गुलाम कोनी बणे। फेर तू किस तरियां कहवै सै, के थम आजाद हो जाओगे?” ");
INSERT INTO bgc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीशु नै उन ताहीं जवाब दिया, “मै थारैतै साच्ची-साच कहूँ सूं, के जो कोए पाप करै सै, वो पाप का गुलाम सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","गुलाम सारी हाण घर म्ह कोनी रहन्दा, बेट्टा सारी हाण घरां रहवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ज्यांतै जै बेट्टा थमनै आजाद करैगा, तो साच्ये थम आजाद हो जाओगे। ");
INSERT INTO bgc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मै जाणु सूं, के थम अब्राहम के वंश के सो, फेर भी थम मेरे वचनां नै कोनी मानते, ज्यांतै थम मन्नै मारणा चाहो सो। ");
INSERT INTO bgc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","मै वोए कहूँ सूं, जो मेरे पिता नै मेरे ताहीं दिखाया सै, अर थम वोए करो सों, जो थमनै अपणे पिता तै सुण्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","उननै उस ताहीं जवाब दिया, “म्हारा पूर्वज तो अब्राहम सै।” यीशु उनतै बोल्या, “जै थम अब्राहम के वंशज होन्दे, तो अब्राहम जिसे काम करदे। ");
INSERT INTO bgc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","पर इब थम मेरै ताहीं मारणा चाहो सो, जिसनै थारे ताहीं वो साच्चा वचन बताया जो परमेसवर तै सुण्या, इस तरियां तो अब्राहम नै कोनी करया था। ");
INSERT INTO bgc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","थम अपणे पिता कै जिसे काम करो सो।” उननै यीशु ताहीं कह्या, “हम जारी तै कोनी जणे, म्हारा एक ए पिता सै यानिके परमेसवर।” ");
INSERT INTO bgc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीशु उनतै बोल्या, “जै परमेसवर थारा पिता होन्दा, तो थम मेरै तै प्यार करदे, क्यूँके मै परमेसवर की ओड़ तै आया सूं। मै खुद कोनी आया, पर उस्से नै मेरै ताहीं भेज्या। ");
INSERT INTO bgc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","थम मेरी बात क्यांतै न्ही समझदे? ज्यांतै के थम मेरे वचनां नै अपणादे कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","थम अपणे पिता शैतान की ओड़ तै सो, अर अपणे पिता की मर्जी पूरी करणा चाहो सो। वो तो शरु तै ए खून्नी सै, अर सच पै टिक्या ए कोनी रहया, क्यूँके सच उस म्ह सै ए कोनी। जिब वो झूठ बोल्लै सै, तो अपणे सुभाव तै ए बोल्लै सै, क्यूँके वो झूठ्ठा सै बल्के झूठ का बाप सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","पर मै जो सच बोल्लू सूं, इस्से करकै थम मेरा बिश्वास कोनी करदे। ");
INSERT INTO bgc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","थारे म्ह तै कौण मन्नै पापी ठैहरावै सै? जै मै सच बोल्लू सूं, तो थम मेरा बिश्वास क्यांतै न्ही करदे? ");
INSERT INTO bgc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जो परमेसवर कान्ही तै होवै सै, वो परमेसवर की बात सुणै सै, अर थम ज्यांतै कोनी सुणदे के परमेसवर की ओड़ तै कोनी सो।” ");
INSERT INTO bgc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","न्यू सुण यहूदियाँ नै उस ताहीं कह्या, “के हम ठीक कोनी कहन्दे के तू सामरी सै, अर तेरे म्ह भुन्ड़ी ओपरी आत्मा सै?” ");
INSERT INTO bgc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीशु नै जवाब दिया, “मेरै म्ह भुन्ड़ी ओपरी आत्मा कोनी,” पर मै अपणे बाप की इज्जत करुँ सूं, अर थम मेरी बेजती करो सो। ");
INSERT INTO bgc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","पर मै अपणा मान-सम्मान कोनी चाहन्दा, हाँ, एक सै जो चाहवै सै, अर न्याय करण आळा सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मै थमनै साच्ची-साच कहूँ सूं, “के जै कोए माणस मेरे वचनां नै मान्नैगा, तो वो अनन्त काल ताहीं कोनी मरै।” ");
INSERT INTO bgc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदियाँ नै उस ताहीं कह्या, “इब हम जाणगे के तेरे म्ह भुन्ड़ी ओपरी आत्मा सै। अब्राहम मरग्या अर नबी भी मरग्ये सै, अर तू कहवै सै, ‘जै कोए मेरे वचनां नै मान्नैगा, तो वो अनन्त काल ताहीं कोनी मरै।’ ");
INSERT INTO bgc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","म्हारा पूर्वज अब्राहम तो मरग्या। के तू उसतै भी बड्ड़ा सै? अर नबी भी मरग्ये। तू अपणे-आपनै के मान्नै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीशु नै जवाब दिया, “जै मै खुद अपणी महिमा करुँ, तो मेरी महिमा किमे कोनी। पर मेरी महिमा करण आळा मेरा पिता सै, जिसनै थम कहो सो के वो थारा परमेसवर सै। ");
INSERT INTO bgc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","थमनै तो उस ताहीं कोनी जाण्या, पर मै उस ताहीं जाणु सूं। जै मै कहूँ के मै उस ताहीं कोनी जाण्दा, तो मै थारी ढाळ झूठ्ठा ठहरूँगा, पर मै उस ताहीं जाणु अर उसके वचनां नै मान्नु सूं। ");
INSERT INTO bgc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","थारा पूर्वज अब्राहम मेरा दिन देक्खण की आस म्ह घणा मगन था, अर उसनै देख्या अर आनन्द करया।” ");
INSERT INTO bgc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदियाँ नै उस ताहीं कह्या, “इब ताहीं तू पचास साल का कोनी, फेरभी तन्नै अब्राहम ताहीं देख्या सै?” ");
INSERT INTO bgc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीशु उनतै बोल्या, “मै थमनै साच्ची-साच कहूँ सूं, के पैहल्या इसकै के अब्राहम पैदा होया, मै सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","या बात सुणकै माणसां नै यीशु ताहीं मारण खात्तर पत्थर ठाए, पर यीशु लुह्ककै मन्दर तै लिकड़ ग्या। ");
INSERT INTO bgc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ओड़ तै जान्दे होए राह म्ह एक यीशु ताहीं जन्म तै आन्धा एक माणस मिला। ");
INSERT INTO bgc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","उसके चेल्यां नै उसतै बुझ्झया, “हे गुरु, किसनै पाप करया था के यो आन्धा पैदा होया, इस माणस नै या इसकै माँ-बाप नै?” ");
INSERT INTO bgc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीशु नै जवाब दिया, “ना तो इसनै पाप करया था, ना इसके माँ-बाप नै पाप करया, पर यो ज्यांतै आन्धा पैदा होया ताके परमेसवर की शक्ति दिखाई जा सकै। ");
INSERT INTO bgc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जिसनै मेरै ताहीं भेज्या सै, हमनै उसके काम दिन-ए-दिन म्ह करणा जरूरी सै। वा रात आण आळी सै, जिस म्ह कोए माणस काम न्ही कर पावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जिब ताहीं मै दुनिया म्ह सूं, जद ताहीं दुनिया का चान्दणा सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","न्यू कहकै यीशु नै धरती पै थुक्या, अर उस थूक तै माट्टी का लेप बणाया, अर उस लेप ताहीं आंधै की आँखां पै लगाकै। ");
INSERT INTO bgc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","उसतै बोल्या, “जा,” “शीलोह कै कुण्ड म्ह” (शीलोह का मतलब भेज्या होया सै)। उसनै जाकै अपणा मुँह धोया, अर जिब वो बोहड़ा तो उसनै दिक्खण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","फेर भिखारी के पड़ोसी अर उन माणसां नै जिननै उस ताहीं पैहल्या भीख माँगदे देख्या था, एक-दुसरे तै कहण लाग्गे, “के यो वोए न्ही सै, जो बेठ्या भीख माँगया करै था?” ");
INSERT INTO bgc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कई माणस बोल्ले, “यो वोए सै,” दुसरे बोल्ले, “कोनी, पर उसकै जिसा सै।” उसनै कह्या, “मै वोए सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","फेर वे उसतै बुझ्झण लाग्गे, “तेरी आँखां की रोशनी किस तरियां आगी?” ");
INSERT INTO bgc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","उसनै जवाब दिया, “यीशु नामक एक माणस नै माट्टी का लेप बणाया, अर मेरी आँखां पै लाकै मेरै ताहीं बोल्या, ‘जा, शीलोह म्ह जाकै अपणा मुँह धो ले,’ बस फेर के था मै गया अर अपणा मुँह धोया अर देक्खण लाग्या।” ");
INSERT INTO bgc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","उननै उसतै बुझ्झया, “वो माणस कित्त सै?” वो बोल्या, “मै कोनी जाण्दा।” ");
INSERT INTO bgc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","माणस उसनै जो आन्धा था फरीसियाँ कै धोरै ले आए। ");
INSERT INTO bgc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जिस दिन यीशु नै माट्टी लगाकै उसकी आँख खोल्ली थी, वो आराम का दिन था। ");
INSERT INTO bgc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फेर फरीसियाँ नै भी उनतै बुझ्झया के उसकी आँखां की रोशनी किस ढाळ मिली। उसनै उन ताहीं कह्या, “उसनै मेरी आँखां पै माट्टी लाई, फेर मन्नै अपणा मुँह धो लिया, अर इब देक्खूँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","इसपै कई फरीसी कहण लाग्गे, “यो माणस परमेसवर की ओड़ तै कोनी, क्यूँके वो आराम कै दिन नै कोनी मान्दा।” दुसरे बोल्ले, “पापी माणस इसे अचम्भे के काम किस ढाळ दिखा सकै सै?” आखर म्ह उन म्ह फूट पड़गी। ");
INSERT INTO bgc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","उननै उस आंधै तै फेर कह्या, “जिस माणस नै तेरे ताहीं आँखां की रोशनी दी सै। तू उसकै बारै म्ह के कहणा चाहवै सै?” उसनै कह्या, “वो नबी सै।” ");
INSERT INTO bgc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","पर यहूदी अगुवां नै बिश्वास कोनी होया, के वो आन्धा था, अर इब वो देक्खै सै, इस खात्तर उननै उसके माँ-बाप ताहीं बुलाया। ");
INSERT INTO bgc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","अर उनतै बुझ्झया, “के यो थारा बेट्टा सै, जिसके बारें मै थम कहों सों, के वो जन्म तै आन्धा था? फेर इब वो किस तरियां देक्खै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","उसकै माँ-बाप नै जवाब दिया, “हाँ, या तो जाणा सा के यो म्हारा बेट्टा सै, अर या भी के यो आन्धा जन्मा था, ");
INSERT INTO bgc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पर न्यू कोनी जाणदे, के इब यो किस तरियां देक्खण लाग्या, अर ना न्यू जाणदे के किसनै इसकी आँखां की रोशनी दी सै। वो बाळक कोनी सै, उस्से तै बुझल्यो, वो अपणे बारै म्ह खुद ए बतावैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ये बात उसकै माँ-बाप नै ज्यांतै कही क्यूँके वे यहूदी अगुवां तै डरै थे, क्यूँके यहूदी अगुवां नै एक्का कर लिया था, के जै कोए कहवै के वो मसीह सै, तो उस ताहीं आराधनालय म्ह तै लिकाड़ दिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","इस्से कारण उसकै माँ-बाप नै कह्या, “वो बाळक कोनी, उस्से तै बुझल्यो।” ");
INSERT INTO bgc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","फेर यहूदी अगुवां नै उस माणस ताहीं जो आन्धा था, दुसरी बर बुलाकै उसतै कह्या, “सच बता अर जो तू ठीक होया सै, तो तू सच बोलकै परमेसवर की महिमा कर, हम जाणां सां के वो माणस पापी सै।” ");
INSERT INTO bgc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","उसनै जवाब दिया, “मै न्ही जाण्दा, के वो पापी सै के न्ही, मै एक बात जाणु सूं, के मै आन्धा था अर इब देक्खूँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","उननै उस ताहीं फेर दुबारै कह्या, “उसनै तेरे गेल्या के करया? अर किस ढाळ तेरी आँखां की रोशनी आगी?” ");
INSERT INTO bgc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","उसनै उन ताहीं कह्या, “मन्नै तो थारे ताहीं पैहले भी बता दिया, पर थम उस बात नै सुणते कोनी, इब दुसरी बर क्यांतै सुणणा चाहवो सो? के थम भी उसके चेल्लें बणाणा चाहवो सो?” ");
INSERT INTO bgc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","फेर वे उसतै आच्छा-भुन्ड़ा कहकै बोल्ले, “तूए उसका चेल्ला सै, हम तो मूसा नबी के चेल्लें सां। ");
INSERT INTO bgc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","हम जाणा सां, के परमेसवर नै मूसा नबी तै बात करी, पर इस माणस नै कोनी जाणदे के कड़ै तै आया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","उसनै उन ताहीं जवाब दिया, “या तो अचम्भे की बात सै, के थम न्ही जाणदे के वो कित्त का सै, फेर भी उसनै मेरी आँखां की रोशनी दे दी। ");
INSERT INTO bgc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","हम जाणां सां, के परमेसवर पापियाँ की कोनी सुणदा, पर जै कोए परमेसवर का भगत हो अर उसकी मर्जी पै चाल्दा हो, तो वो उसकी जरुर सुणै सै। ");
INSERT INTO bgc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","दुनिया कै शरुआत तै यो कदे सुणनै म्ह कोनी आया, के किसे नै जन्म तै आन्धै की आँखां की रोशनी दी हो। ");
INSERT INTO bgc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","जै यो माणस परमेसवर कै कान्ही तै न्ही होन्दा, तो किमे भी कोनी कर सकदा।” ");
INSERT INTO bgc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","उननै उस ताहीं जवाब दिया, “तू तो जमाए पापां म्ह जन्मा सै, तू हमनै के सिखावै सै?” अर उननै उस ताहीं आराधनालय तै बाहरणै लिकाड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यीशु नै सुण्या के उननै उस ताहीं बाहरणै लिकाड़ दिया सै, अर जिब उसतै मिल्या तो बोल्या, “के तू परमेसवर कै बेट्टै पै बिश्वास करै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","उसनै जवाब दिया, “हे जनाब, परमेसवर का बेट्टा कौण सै, के मै उसपै बिश्वास करुँ?” ");
INSERT INTO bgc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीशु नै उस ताहीं कह्या, “तन्नै उस ताहीं देख्या भी सै, अर जो तेरे गेल्या बात करण लाग रह्या सै, वो मै ए सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","उसनै कह्या, “हे प्रभु, मै तेरे पै बिश्वास करुँ सूं।” अर उस ताहीं मोध्धा पड़कै प्रणाम करया। ");
INSERT INTO bgc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","फेर यीशु बोल्या, “मै इस दुनिया म्ह न्याय खात्तर आया सूं, ताके जो आन्धे सै, वे देक्खै, अर जो देक्खै सै, वे आन्धे हो जावै।” ");
INSERT INTO bgc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","जो फरीसी उसकै गेल्या थे, उननै या बात सुणकै उस ताहीं कह्या, “के हम भी आन्धे सां?” ");
INSERT INTO bgc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीशु नै उन ताहीं कह्या, “जै थम आन्धे होन्दे तो पापी कोनी होते, पर इब जिसा के थम कहो सो, के थम देक्खों सों, तो सच म्ह थारा पाप माफ न्ही हो सकदा।” ");
INSERT INTO bgc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","यीशु नै कह्या, “मै थारे ताहीं साच्ची-साच कहूँ सूं, के जो कोए भेड्या के बाड़े म्ह दरबाजे तै न्ही आन्दा, बल्के बाड़ा कूदकै बड़ै सै, वो चोर अर डाकू सै। ");
INSERT INTO bgc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पर जो दरबाजे तै भीत्त्तर बड़ै सै वो भेड्डां का पाळी सै। ");
INSERT INTO bgc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","उस खात्तर द्वारपाल दरबाजा खोल देवै सै, अर भेड़ उसका बोल सुणै सै, अर वो अपणी उन भेड्डां नै नाम ले-लेकै बुलावै सै, अर बाड़ै तै बाहरणै ले जावै सै। ");
INSERT INTO bgc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","जिब वो अपणी सारी भेड्डां नै बाहरणै काढ लेवै सै, तो उनकै आग्गै-आग्गै चाल्लै सै, अर भेड़ उसकै गैल-गैल हो ले सै, क्यूँके वे उसका बोल पिच्छाणै सै। ");
INSERT INTO bgc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पर भेड़ बिगान्ने कै गेल्या कोनी चाल्लै, पर उसतै भाज्जैंगी, क्यूँके वे बिगान्ने का बोल कोनी पिच्छाणदी।” ");
INSERT INTO bgc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीशु नै उन ताहीं यो उदाहरण देकै कह्या, पर वे कोनी समझे के वो उनतै के समझणा चाहवै। ");
INSERT INTO bgc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","फेर यीशु नै उन ताहीं दुबारै कह्या, “मै थारैताहीं साच्ची-साच कहूँ सूं, भेड्डां का दरबाजा मै सूं। ");
INSERT INTO bgc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जितने मेरै तै पैहल्या आए वे सारे चोर अर डाक्कू सै, पर मेरी भेड्डां नै उनकी एक न्ही सुणी। ");
INSERT INTO bgc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","दरबाजा मै सूं, जै कोए मेरै जरिये भीत्त्तर बड़ै सै, तो वो उद्धार पावैगा, अर भीत्त्तर बाहर आण-जाण लाग ज्यागा अर खाण खात्तर खाणा पावैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोर किसे और काम खात्तर कोनी पर सिर्फ चोरी करण अर घात करण अर नुकसान करण नै आवै सै, मै ज्यांतै आया के वे जिन्दगी पावै अर भोत-ए घणी पावै। ");
INSERT INTO bgc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","आच्छा पाळी मै सूं, आच्छा पाळी भेड्डां कै खात्तर अपणी मर्जी तै जान देवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","मजदूर जो ना पाळी सै अर ना भेड्डां का माल्लिक सै, भेड़िये नै आन्दे देखकै भेड्डां नै छोड़कै भाज जावै सै, अर भेड़िया उननै पकड़ै सै, अर उनपै हमला करै देवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","वो ज्यांतै भाज जावै सै क्यूँके वो मजदूर सै, उसनै भेड्डां की फिक्र कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“काम्मल चरवाहा मै सूं, मै अपणी भेड्डां नै जाणु सूं, अर मेरी भेड़ मन्नै जाणै सै। ");
INSERT INTO bgc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","जिस ढाळ पिता मन्नै जाणै सै, अर मै पिता नै जाणु सूं, अर मै अपणी भेड्डां खात्तर अपणी जान दियुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","मेरी और भी भेड़ सै, जो इस बाड़े की कोनी। मन्नै उन ताहीं भी ल्याणा जरूरी सै। वे मेरा बोल पिच्छाणैगी, फेर एकैए रेवड़ अर एकैए पाळी होगा। ");
INSERT INTO bgc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","पिता ज्यांतै मेरै तै प्यार करै सै, क्यूँके मै अपणी जान अपणी मर्जी तै दियुँ सूं, के उसनै दुबारै ले लूँ। ");
INSERT INTO bgc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कोए मेरी जान मेरै तै खोसदा कोनी, बल्के मै उसनै खुदे उसनै अपणी मर्जी तै दियुँ सूं। मन्नै उसकै देण का भी हक सै, अर उस ताहीं दुबारा लेण का भी हक सै, यो हुकम मेरै पिता नै मेरै ताहीं दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","इन बात्तां कै कारण यहूदियाँ म्ह दुबारै फूट पड़ी। ");
INSERT INTO bgc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","उन म्ह तै घणखरे माणस कहण लागगे, “उस म्ह ओपरी आत्मा सै, अर वो बावळा सै, उसकी क्यांतै सुणो सो?” ");
INSERT INTO bgc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","दुसरे माणसां नै कह्या, “ये वचन इसे माणस की न्ही हो सकदे, जिसम्ह ओपरी आत्मा हो। के ओपरी आत्मा आन्धयां नै आँखां की रोशनी दे सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरुशलेम नगर म्ह स्थापन का त्यौहार मनाया जारया था, अर जाड्यां का मौसम था। ");
INSERT INTO bgc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीशु मन्दर म्ह सुलैमान कै बराम्दा म्ह हान्डण लागरया था। ");
INSERT INTO bgc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","फेर यहूदियाँ नै उस ताहीं आ घेरया अर बुझ्झया, “तू म्हारै मन नै कद ताहीं दुबिध्या म्ह गेरे राक्खैगा? जै तू मसीह सै, तो म्हारै तै साफ-साफ बता दे।” ");
INSERT INTO bgc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीशु नै उन ताहीं जवाब दिया, “मन्नै थारैतै कह दिया पर थम बिश्वास करदेए कोनी। जो काम मै अपणे पिता कै नाम तै करुँ सूं, वैए मेरे गवाह सै, ");
INSERT INTO bgc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पर थम ज्यांतै बिश्वास कोनी करदे क्यूँके थम मेरी भेड्डां म्ह तै कोनी सो। ");
INSERT INTO bgc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मेरी भेड़ मेरा बोल पिच्छाणै सै, मै उननै जाणु सूं, अर वे मेरै पाच्छै-पाच्छै चाल्लै सै ");
INSERT INTO bgc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","अर मै उन ताहीं अनन्त जीवन दियुँ सूं। वे कदे नाश कोनी होवैगीं, अर कोए उननै मेरै हाथ तै खोस न्ही सकदा। ");
INSERT INTO bgc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मेरा पिता, जिसनै उन ताहीं मेरै तै दिया सै, सारया तै बड्ड़ा सै, अर कोए उननै पिता कै हाथ्थां तै खोस कोनी सकदा। ");
INSERT INTO bgc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मै अर पिता एक सां।” ");
INSERT INTO bgc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदियाँ नै यीशु पै मारण खात्तर दुबारा पत्थर ठा लिये। ");
INSERT INTO bgc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","इसपै यीशु नै उन ताहीं कह्या, “मन्नै थारे तै अपणे पिता की ओड़ तै घणे भले काम दिखाए सै, उन म्ह तै कौण सै काम खात्तर थम मेरै पै पत्थर मारणा चाह्वो सो?” ");
INSERT INTO bgc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदियाँ नै उस ताहीं जवाब दिया, “भले काम खात्तर हम तेरे पै पत्थर कोनी मारदे, पर परमेसवर की बुराई करण कै कारण, अर ज्यांतै के तू माणस होकै खुद नै परमेसवर कहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीशु नै उन ताहीं जवाब दिया, “के थारे मूसा नबी के नियम-कायदा म्ह कोनी लिख्या सै, ‘मन्नै कह्या, थम ईश्‍वर सो?’ ");
INSERT INTO bgc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","जै उसनै उन ताहीं ईश्‍वर कह्या, जिनकै धोरै परमेसवर का वचन पोंहच्या (अर पवित्र ग्रन्थ की बात झूठ न्ही हो सकदी), ");
INSERT INTO bgc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","तो जिस ताहीं पिता नै पवित्र ठहराकै दुनिया म्ह भेज्या सै, थम मेरे ताहीं कहो सो, ‘तू बुराई करै सै, ज्यांतै के मन्नै यो कह्या,’ ‘मै परमेसवर का बेट्टा सूं?’ ");
INSERT INTO bgc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","जै मै अपणे पिता के काम कोनी करदा, तो मेरा बिश्वास ना करो। ");
INSERT INTO bgc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पर जै मै करुँ सूं, तो चाहे मेरा बिश्वास ना भी करो, पर उन काम्मां का तो बिश्वास करो, ताके थम जाणो अर समझो के पिता मेरै म्ह सै अर मै पिता म्ह सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","फेर यहूदियाँ नै दुबारै उस ताहीं पकड़ण की कोशिश करी पर वो उनके हाथ्थां तै लिकड़ ग्या। ");
INSERT INTO bgc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","यीशु दुबारै यरदन नदी कै परली ओड़ै उस जगहां पै चल्या गया, जड़ै यूहन्ना पैहल्या बपतिस्मा दिया करै था, अर वो ओड़ैए रहया। ");
INSERT INTO bgc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","घणखरे माणस उसकै धोरै आकै कहवै थे, “यूहन्ना नै तो कोए चमत्कार कोनी दिखाया, पर जो किमे यूहन्ना नै इसकै बारै म्ह कह्या था, वो सारा कुछ साच्ची था।” ");
INSERT INTO bgc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","अर ओड़ै भोत-से माणसां नै यीशु पै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","लाजर नामका एक माणस बीमार था, जो बैतनिय्याह गाम का था, अर उसकी दो भाण थी मरियम अर मार्था। ");
INSERT INTO bgc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","या वाए मरियम थी जिसनै बाद म्ह प्रभु पै खसबूदार तेल गेर कै उसके पायां ताहीं बाळां तै पुन्जयां था, लाजर इस्से का भाई था जो बीमार था। ");
INSERT INTO bgc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","इस करकै उसकी भाणां नै यीशु ताहीं कुहवां भेज्या, “हे प्रभु, लखा, जिसतै तू प्यार करै सै, वो बीमार सै।” ");
INSERT INTO bgc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","न्यू सुणकै यीशु न्यू बोल्या, “या बीमारी मरण का कारण कोनी, पर परमेसवर की महिमा खात्तर सै, ताके उसकै जरिये परमेसवर कै बेट्टै की महिमा होवै।” ");
INSERT INTO bgc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","मार्था उसकी बेब्बे अर लाजर तै यीशु प्यार करै था। ");
INSERT INTO bgc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","पर जिब उसनै सुण्या के लाजर बीमार सै, तो जिस जगहां पै वो था, ओड़ै दो दिन और रुक ग्या। ");
INSERT INTO bgc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","दो दिन बाद फेर उसनै चेल्यां ताहीं कह्या, “आओ, हम फेर यहूदिया परदेस म्ह चाल्लां।” ");
INSERT INTO bgc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेल्यां नै उस ताहीं कह्या, “हे गुरु, कुछ दिन पैहल्या तो यहूदी तेरे पै पत्थर बरसा कै तन्नै मारणा चाहवै थे, अर के तू फेर भी उड़ैए जाणा चाहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीशु नै जवाब दिया, “के दिन के बारहा घन्टे कोनी होन्दे? जै कोए दिन म्ह चाल्लै तो ठोक्कर कोनी खान्दा, क्यूँके वे इस दुनिया के उजाळै नै देक्खै सै। ");
INSERT INTO bgc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पर जै कोए रात म्ह चाल्लै तो ठोक्कर खावै सै, क्यूँके उस म्ह उजाळा कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","उसनै ये बात कही, अर इसके बाद उन ताहीं कहण लाग्या, “के म्हारा साथी लाजर सो ग्या सै, पर मै उसनै जगाण जाऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","फेर चेल्यां नै उस ताहीं कह्या, “हे प्रभु, जै वो सो ग्या सै तो वो ठीक हो ज्यागा।” ");
INSERT INTO bgc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीशु नै तो उसकी मौत कै बाबत कह्या था, पर उननै सोच्या के उसनै नींद तै सोण कै बाबत कह्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","फेर यीशु नै उन ताहीं साफ-साफ कह दिया, “लाजर मर लिया सै, ");
INSERT INTO bgc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","यो थारे ए हित म्ह सै, के मै उड़ै कोनी था, क्यूँके इब थम मेरे पै बिश्वास कर सकोगे, आओ, हम उसकै धोरै चाल्लां।” ");
INSERT INTO bgc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","फेर थोमा नै जो दिदुमुस कुह्वावै सै, अपणे गेल्या के चेल्यां ताहीं कह्या, “आओ, हम भी प्रभु कै गेल्या मरण नै चाल्लां।” ");
INSERT INTO bgc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","बैतनिय्याह गाम पोहचे पाच्छै यीशु नै न्यू बेरया पाट्या के लाजर नै कब्र म्ह धरे चार दिन हो लिए सै। ");
INSERT INTO bgc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनिय्याह गाम यरुशलेम कै धोरै कोए दो कोस की दूरी पै था, ");
INSERT INTO bgc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","घणखरे यहूदी माणस मार्था अर मरियम कै धोरै उसकै भाई की मौत कै बाबत दीलास्सा देण नै आरे थे। ");
INSERT INTO bgc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जिब मार्था नै यीशु कै आण की खबर सुणी, तो मार्था उसतै मिलण खात्तर गई, पर मरियम घरा ए बेठ्ठी रही। ");
INSERT INTO bgc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्था नै यीशु ताहीं कह्या, “हे प्रभु, जै तू आड़ै होंदा, तो मेरा भाई कदे न्ही मरदा। ");
INSERT INTO bgc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","अर इब भी मन्नै बेरा सै, जो कुछ तू परमेसवर तै माँगैगा, परमेसवर तन्नै देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीशु नै उस ताहीं कह्या, “तेरा भाई जी ज्यागा।” ");
INSERT INTO bgc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्था नै उस ताहीं कह्या, “मन्नै बेरा सै, के आखर के दिन म्ह पुनरुत्थान के बखत वो जी ज्यागा।” ");
INSERT INTO bgc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीशु नै मार्था तै कह्या, “पुनरुत्थान अर जीवन मै ए सूं, जो कोए मेरै पै बिश्वास करैगा, वो जै मर भी जावै फेर भी जिवैगा, ");
INSERT INTO bgc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","अर जो कोए जीवै सै, अर वो मेरै पै बिश्वास करै सै, वो अनन्त काल ताहीं कोनी मरैगा। के तू इस बात पै बिश्वास करै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मार्था नै यीशु तै कह्या, “हाँ, हे प्रभु, मै बिश्वास करुँ सूं, के परमेसवर का बेट्टा मसीह जो दुनिया म्ह आण आळा था, वो तूए सै।” ");
INSERT INTO bgc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","न्यू कहकै मार्था चली गयी, अर अपणी बेब्बे मरियम ताहीं एक्ले म्ह बुलाकै चुपके तै कह्या, “गुरु याड़ैए सै अर तन्नै बुलावै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","न्यू सुण तिए मरियम जिब्बे उठकै उसकै धोरै आई। ");
INSERT INTO bgc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीशु इब्बे गाम तै बाहरे था, पर उस्से जगहां था जड़ै मार्था उसतै मिली थी। ");
INSERT INTO bgc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","फेर जो यहूदी माणस उसकै गेल्या घर म्ह थे अर उस ताहीं दीलास्सा देवै थे, न्यू देखकै के मरियम जिब्बे उठकै बारणै चली गयी सै, न्यू समझे के वा कब्र पै रोण नै जावै सै, तो उसकै पाच्छै हो लिये। ");
INSERT INTO bgc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जिब मरियम उड़ै गई जड़ै यीशु था, तो उसनै देखदे उसकै पायां म्ह पड़कै कह्या, “हे प्रभु, जै तू आड़ै होन्दा फेर मेरा भाई कोनी मरदा।” ");
INSERT INTO bgc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जिब यीशु नै जो यहूदी माणस उसकै गेल्या आये थे, रोन्दे होए देख्या, तो आत्मा म्ह घणाए दुखी अर उदास होग्या, ");
INSERT INTO bgc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","अर कह्या, “थमनै उसकी लाश कित्त धर राक्खी सै?” उननै उस ताहीं कह्या, “हे प्रभु, चालकै देख ले।” ");
INSERT INTO bgc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीशु रोण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","फेर यहूदी माणस कहण लाग्गे, “लखाओ, वो लाजर तै कितना प्यार करै था।” ");
INSERT INTO bgc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पर उन म्ह तै कईयाँ नै कह्या, “के यो जिसनै आंध्याँ ताहीं रोशनी दे दी, के यो लाजर ताहीं मरण तै न्ही बचा सकै था?” ");
INSERT INTO bgc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीशु मन म्हए फेर घणाए दुखी होकै कब्र पै आया। वा एक गुफा थी अर एक पत्थर उसपै धरया था। ");
INSERT INTO bgc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीशु नै कह्या, “पत्थर हटादो।” लाजर की बेब्बे मार्था उसतै कहण लाग्गी, “हे प्रभु, उस म्ह तै इब तो बदबू आवै सै, क्यूँके उसनै मरे चार दिन हो लिए सै।” ");
INSERT INTO bgc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीशु नै उन ताहीं कह्या, “के मन्नै तेरे तै कोनी कह्या था के जै तू बिश्वास करैगी, तो परमेसवर की महिमा नै देक्खैगी।” ");
INSERT INTO bgc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","फेर उननै पत्थर ताहीं हटाया। यीशु नै सुर्ग कान्ही निगांह ठाकै कह्या, “हे पिता, मै तेरा धन्यवाद करुँ सूं, के तन्नै मेरी सुण ली सै। ");
INSERT INTO bgc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","अर मन्नै बेरा था के तू सारी हाण मेरी सुणै सै, पर जो भीड़ आसै-पासै खड़ी सै, उनकै बाबत मन्नै कह्या, ताके वे बिश्वास करै, के तन्नै मेरैताहीं भेज्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","न्यू कहकै ठाड्डू आवाज म्ह रुक्का मारया, “हे लाजर, लिकड़ आ।” ");
INSERT INTO bgc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जो मर लिया था उसके हाथ पैर पट्टियाँ तै बंधे हुए थे, अर उसकै मुँह पै अंगोच्छा लिपटरया था। यीशु नै उन ताहीं कह्या, “उसनै खोलदो अर जाण द्यो।” ");
INSERT INTO bgc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","फेर जो यहूदी मरियम धोरै मिलण आरे थे, अर उसका यो चमत्कार देख्या था, उन म्ह तै घणखरयां नै उसपै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पर उन म्ह तै कईयाँ नै फरीसियाँ धोरै जाकै यीशु के काम्मां की खबर दी। ");
INSERT INTO bgc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ज्यांतै प्रधान याजकां अर फरीसियाँ नै यहूदी अगुवां की सभा करी, अर कह्या, “हमनै के करणा चाहिये? यो माणस तो घणे चमत्कार दिखावै सै। ");
INSERT INTO bgc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","जै हम उसनै न्यूए करण द्या, तो फेर सारे उसपै बिश्वास करैगें, अर रोमी सैनिक आकै म्हारे देश अर मन्दर दोनुवां पै कब्जा कर लेवैगें।” ");
INSERT INTO bgc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","फेर उन म्ह तै काइफा नामका एक माणस नै जो उस साल का महायाजक था, उन ताहीं कह्या, “थम किमे न्ही जाणदे! ");
INSERT INTO bgc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","अर ना ए थमनै इस बात की समझ सै, के इस्से म्ह थारा फायदा सै, के बजाये इसके के सारे माणस ए नाश हो जावै, सब खात्तर एक आदमी नै मरणा होगा।” ");
INSERT INTO bgc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","पर या बात उसनै अपणी ओड़ तै कोन्या कही, पर उस साल का महायाजक होण के नाते या भविष्यवाणी करी, के यीशु उस जात खात्तर मरैगा। ");
INSERT INTO bgc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","अर ना सिर्फ यहूदी जात खात्तर बल्के ज्यांतै के परमेसवर की खिंड-मिंड ऊलादां नै एक करदे। ");
INSERT INTO bgc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","इस तरियां उस्से दिन तै यहूदी अगुवें उस ताहीं मारण खात्तर साजिस रचाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ज्यांतै यीशु उस बखत तै यहूदी लोग्गां म्ह घाट दिक्खण लागग्या, अर यरुशलेम नगर नै छोड़कै वो जंगल-बियाबान कै धोरै इफ्राईम नामक एक नगर कान्ही चल्या गया, अर अपणे चेल्यां गैल उड़ैए रहण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहूदियाँ का फसह का त्यौहार लोवै था, अर घणेए माणस फसह तै पैहल्या अपणे गाम्मां म्ह तै यरुशलेम नगर म्ह गए, के खुद नै पवित्र करै। ");
INSERT INTO bgc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","वे यीशु नै टोह्ण लाग्गे अर मन्दर म्ह खड़े होकै आप्पस म्ह बतलाण लाग्गे, “थम के सोच्चो सो? के वो त्यौहार म्ह कोनी आवैगा?” ");
INSERT INTO bgc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","अर प्रधान याजकां अर फरीसियाँ नै हुकम दे राख्या था, के जै कोए न्यू जाणै सै, के यीशु कित्त सै तो बतावै, ताके वे उसनै पकड़ ले। ");
INSERT INTO bgc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","फेर यीशु फसह का त्यौहार तै छ: दिन पैहल्या बैतनिय्याह गाम म्ह आया जित्त लाजर था, जिस ताहीं यीशु नै मरया होड़ म्ह तै जिन्दा करया था। ");
INSERT INTO bgc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","उड़ै उननै यीशु कै खात्तर भोज तैयार करया, अर मार्था सेवा करण लागरी थी, अर लाजर भी उन म्ह तै एक था जो उसकै गेल्या खाणा खाण बेठ्ठे थे। ");
INSERT INTO bgc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","फेर मरियम नै जटामांसी फूल का आध्धा सेर घणा महँगा खसबूदार तेल लेकै यीशु के पायां पै गेरया, अर अपणे बाळां तै उसके पैर पुन्झे, अर खसबूदार तेल की खस्बू तै घर खसबूदार होग्या। ");
INSERT INTO bgc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पर उसके चेल्यां म्ह तै यहूदा इस्करियोती नामका एक चेल्ला जो उस ताहीं पकड़वाणा चाहवै था, कहण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“यो महँगा खसबूदार तेल तीन सौ दीनार (तीन सौ दिन की मजदूरी) म्ह बेचकै कंगालां ताहीं क्यातै कोनी दिया गया?” ");
INSERT INTO bgc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","उसनै या बात ज्यातै कोनी कही के उसनै कंगालां की फिक्र थी बल्के ज्यांतै के वो चोर था, अर उसकै धोरै पिस्या की थैल्ली रह्या करै थी अर उस म्ह जो कुछ गेरया जान्दा, वो काढ लेवै था। ");
INSERT INTO bgc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीशु नै कह्या, “उस ताहीं यो करण द्यो, यो मेरे गाड्डे जाण की तैयारी कै खात्तर सै। ");
INSERT INTO bgc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","क्यूँके कंगाल तो थारे गेल्या सारी हाण रहवैंगे, पर मै थारे गेल्या सारी हाण कोनी रहूँगा।” ");
INSERT INTO bgc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","फसह का त्यौहार म्ह आई यहूदियाँ की एक बड़ीए भीड़ नै जिब बेरा लागग्या के वो बैतनिय्याह गाम म्ह सै, तो वे ना सिर्फ यीशु कै बाबत आये पर ज्यांतै भी के लाजर नै देक्खै, जिस ताहीं यीशु मसीह नै मरया होड़ म्ह तै जिन्दा करया था। ");
INSERT INTO bgc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","फेर प्रधान याजकां नै लाजर ताहीं भी मारण की सलाह करी। ");
INSERT INTO bgc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","क्यूँके उसकै बाबत घणखरे यहूदी चले गये अर यीशु पै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दुसरे दिन घणखरे माणसां नै जो फसह के त्यौहार म्ह आरे थे न्यू सुण्या, के यीशु यरुशलेम नगर म्ह आरया सै। ");
INSERT INTO bgc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ज्यांतै उननै खजूर की डाळी ली, अर उसतै फेट्टण नै लिकड़े, अर रुक्के मारण लाग्गे, “होशाना! (मतलब जै-जै कार हो) धन्य इस्राएल का राजा, जो प्रभु कै नाम तै आवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जिब यीशु यरुशलेम नगर कै धोरै आया, तो उसनै एक गधे का बच्चा मिल्या, फेर वो उसपै बैठग्या, ");
INSERT INTO bgc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","जिसा पवित्र शास्त्र म्ह लिख्या सै, “हे सिय्योन की बेट्टी, मतना डरै, लखा, तेरा राजा गधी के बच्चे पै चढ़ा होड़ चाल्या आवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","यीशु के चेल्लें ये बात पैहल्या कोनी समझे थे, पर जिब यीशु की महिमा दिक्खी फेर उनकै याद आया के ये बात उसकै बाबत लिक्खी होड़ थी, अर माणसां नै उसकै गेल्या न्यूए बरताव करया था। ");
INSERT INTO bgc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","फेर उसकै गैल जो भीड़ थी उननै या गवाही दी, जो उस बखत उसकै गेल्या थे, जिब उसनै लाजर ताहीं कब्र म्ह तै बुलाकै मरया होया म्ह तै जिन्दा करया था। ");
INSERT INTO bgc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ज्यांतै माणस यीशु तै फेट्टण नै आरे थे क्यूँके उननै सुण्या था के उसनै यो अचम्भे का काम करया था। ");
INSERT INTO bgc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","फेर फरीसियाँ नै आप्पस म्ह कह्या, “सोचकै तो देक्खो, के थारे तै कुछ भी कोनी बणदा। लखाओ, दुनिया उसकै गैल हो ली सै।” ");
INSERT INTO bgc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जो माणस उस फसह के त्यौहार म्ह भगति करण नै आये थे उन म्ह तै कुछ यूनानी थे। ");
INSERT INTO bgc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","उननै गलील परदेस कै बैतसैदा नगर के बासिन्दे फिलिप्पुस कै धोरै आकै उसतै बिनती करी, “श्रीमान, हम यीशु तै फेटणा चाहवां सां।” ");
INSERT INTO bgc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप्पुस नै आकै अन्द्रियास तै कह्या, फेर अन्द्रियास अर फिलिप्पुस नै जाकै यीशु ताहीं कह्या। ");
INSERT INTO bgc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","इसपै यीशु नै उन ताहीं कह्या, “वो बखत आ ग्या सै के मुझ माणस के बेट्टै की महिमा हो। ");
INSERT INTO bgc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मै थारे तै साच्ची-साच कहूँ सूं, के जिब ताहीं गेहूँ का दाणा धरती म्ह पड़कै मर न्ही जान्दा, वो एक्ला रहवै सै, पर जिब मर जावै सै, तो वो अनगणित दाण्या नै जन्म देवै सै। ");
INSERT INTO bgc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जो अपणे जीवन नै प्यारा जाणै सै, वो उसनै खो देवै सै, अर जो इस दुनिया म्ह अपणे जीवन नै प्यारा कोनी जाण्दा, वो अनन्त जीवन कै खात्तर उसकी रुखाळी करैगा। ");
INSERT INTO bgc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","जै कोए मेरी सेवा करै, तो वो मेरा चेल्ला बण जावै, अर जिब जड़ै मै सूं, उड़ै मेरा सेवक भी होवैगा। जै कोए मेरी सेवा करै, तो पिता उसका आदर करैगा। ");
INSERT INTO bgc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“इब मेरा जी भोत दुखी सै। ज्यांतै इब मै के कहूँ? ‘हे पिता, मन्नै इस दुख की घड़ी तै बचा?’ पर मै इस्से खात्तर इस दुनिया म्ह आया सूं, ताके मै दुख सहु। ");
INSERT INTO bgc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे पिता अपणे नाम की महिमा कर।” फेर या अकास वाणी होई, “मन्नै इसकी महिमा करी सै, अर फेर भी करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","फेर जो माणस खड़े होए सुणरे थे, उननै कह्या के बाद्दळ गरजा। दुसरयां नै कह्या, “कोए सुर्गदूत उसतै बोल्या।” ");
INSERT INTO bgc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","इसपै यीशु नै कह्या, “या आवाज मेरै खात्तर न्ही, पर थारे खात्तर आई सै। ");
INSERT INTO bgc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","इब इस दुनिया का न्याय होवै सै, इब इस दुनिया का अधिकारी काढ्या जावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","अर मै जै धरती पै तै ऊँच्चे पै चढ़ाया जाऊँगा, तो सारया नै अपणे कान्ही खिच्चुगाँ।” ");
INSERT INTO bgc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","न्यू कहकै उसनै यो बता दिया के वो किस ढाळ की मौत तै मरैगा। ");
INSERT INTO bgc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","इसपै माणसां नै यीशु ताहीं कह्या, “हमनै मूसा नबी के नियम-कायदा की या बात सुणी सै के मसीह सदा जिन्दा रहवैगा, फेर तू क्यातै कहवै सै के माणस का बेट्टा ऊँच्चे पै चढ़ाया जाणा जरूरी सै? यो माणस का बेट्टा कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","यीशु नै उन ताहीं कह्या, “चाँदणा (यीशु नै अपणे-आप तै कह्या सै) इब थोड़ी देर ताहीं थारे बिचाळै सै। जिब ताहीं चाँदणा थारे गेल्या सै जद ताहीं चाल्दे रहो, इसा ना हो के अँधेरा थारे ताहीं घेर लेवै, जो अँधेरे म्ह चाल्लै सै वो कोनी जाण्दा के कड़ै जावै सै। ");
INSERT INTO bgc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जिब ताहीं चाँदणा थारे गेल्या सै, चाँदणे पै बिश्वास राक्खो ताके थम चाँदणे की ऊलाद बणो।” ये बात कहकै यीशु चल्या गया अर उनतै दूर रह्या। ");
INSERT INTO bgc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","यीशु मसीह नै उनकै स्याम्ही इतने चमत्कार दिखाए, फेर भी उननै उसपै बिश्वास कोनी करया, ");
INSERT INTO bgc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ताके यशायाह नबी का वचन पूरा हो जो उसनै कह्या “हे प्रभु, म्हारै संदेश का किसनै बिश्वास करया सै? अर प्रभु की शक्ति किसपै जाहिर होई सै?” ");
INSERT INTO bgc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","इस बाबत वे बिश्वास कोनी कर सके, क्यूँके यशायाह नै न्यू भी कह्या सै: ");
INSERT INTO bgc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“उसनै उनकी आँख आँधी, अर उनके मन कठोर कर दिए सै, कदे इसा ना हो के वे आँखां तै देक्खै, अर मन तै समझै, अर पलटै, अर मै उननै ठीक करुँ।” ");
INSERT INTO bgc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशायाह नै ये बात ज्यांतै कही, के उसनै यीशु मसीह की महिमा देक्खी, अर उसनै उसकै बारें म्ह बताया। ");
INSERT INTO bgc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","फेरभी यहूदी सरदारां म्ह तै घणाए नै उसपै बिश्वास करया, पर फरीसियाँ कै कारण खुलकै कोनी मान्नै थे, क्यूँके उननै डर था कदे वे आराधनालय म्ह तै लिकाड़े ना जावै ");
INSERT INTO bgc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","क्यूँके माणसां की ओड़ तै करी जाण आळी बड़ाई उननै परमेसवर की ओड़ तै बड़ाई की बराबरी म्ह घणी प्यारी लाग्गै थी। ");
INSERT INTO bgc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","यीशु नै रुक्का मारकै कह्या, “जो मेरै पै बिश्वास करै सै, वो मेरै पै न्ही बल्के मेरै खन्दानआळै पै बिश्वास करै सै। ");
INSERT INTO bgc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","अर जो मन्नै देक्खै सै, वो मेरै खन्दानआळै नै देक्खै सै। ");
INSERT INTO bgc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मै दुनिया म्ह चाँदणा बणकै आया सूं, ताके जो कोए मेरै पै बिश्वास करै वो अँधेरे म्ह कोनी रहवै।” ");
INSERT INTO bgc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“जै कोए मेरे वचन सुणकै भी उननै न्ही मानता, तोभी मै उसनै कसूरवार कोनी ठहरान्दा, क्यूँके मै दुनिया के माणसां ताहीं कसूरवार ठहराण खात्तर कोनी, पर दुनिया के माणसां का उद्धार करण खात्तर आया सूं। ");
INSERT INTO bgc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जो कोए मन्नै नकारै सै, अर मेरे सुसमाचार नै कोनी अपणावै, उस ताहीं कसूरवार ठहराण आळा तो एके सै, यानिके जो वचन मन्नै कह्या सै, वोए पाच्छले दिन म्ह उस ताहीं कसूरवार ठहरावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","क्यूँके मै अपणी ओर तै बात न्ही कहन्दा, पर पिता जिसनै मेरै ताहीं भेज्या सै, उसनै मेरै ताहीं हुकम दिया सै के, के मै कहूँ अर किस तरियां बोल्लूँ? ");
INSERT INTO bgc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","अर मन्नै बेरा सै के उसका हुकम अनन्त जीवन देवै सै। ज्यांतै मै जो कुछ कहूँ सूं, ठीक उसाए कहूँ सूं, जिसा पिता नै मेरै ताहीं कहण का हुकम दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह कै त्यौहार तै पैहल्या, जिब यीशु नै बेरा लागग्या, के मेरा वो बखत आ लिया सै, के दुनिया छोड़कै पिता कै धोरै उल्टा जाऊँ, तो अपणे मानण आळा तै, जो दुनिया म्ह थे, जिसा प्यार वो करया करदा, आखर ताहीं उसाए प्यार करदा रह्या। ");
INSERT INTO bgc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","यीशु अर उसके चेल्लें साँझ नै खाणा खाण लागरे थे। शमौन के बेट्टे यहूदा इस्करियोती के मन म्ह शैतान नै यो विचार घाल दिया था, के वो यीशु कै गेल्या धोक्खा करै। ");
INSERT INTO bgc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीशु यो जाणै था, के पिता नै सब कुछ उसके हाथ म्ह सौप दिया सै, अर यो भी के वो परमेसवर की ओड़ तै आया सै, परमेसवर कै धोरै ए उल्टा जाण लागरया सै। ");
INSERT INTO bgc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","इस खात्तर वो खाणा छोड़कै खड्या होग्या, उसनै अपणे उप्परले लत्ते उतार दिये, अंगोच्छा लेकै अपणी कमर म्ह बाँध लिया। ");
INSERT INTO bgc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","फेर बास्सण म्ह पाणी भरकै चेल्यां के पैर धोये, अर जो अंगोच्छा कमर पै बाँध राख्या था, उस्से तै पूंझण लागग्या। ");
INSERT INTO bgc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जिब वो शमौन पतरस कै धोरै आया, फेर पतरस नै उस ताहीं कह्या, “हे प्रभु, के तू मेरे पैर धोवैगा?” ");
INSERT INTO bgc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीशु नै उस ताहीं जवाब दिया, “जो मै करुँ सूं, तू उसका मतलब इब्बे न्ही समझ पावैगा, पर इसकै बाद समझैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरस नै उस ताहीं कह्या, “मै अपणे पैर तेरे ताहीं कदे न्ही धोण दियुँगा।” न्यू सुणकै यीशु नै उस ताहीं कह्या, “जै मै तेरे पैर ना धोऊँ, तो तू मेरा चेल्ला न्ही कुह्वावैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","शमौन पतरस नै उस ताहीं कह्या, “हे प्रभु, फेर मेरे पैर ए न्ही बल्के मेरे हाथ अर सिर भी धोदे।” ");
INSERT INTO bgc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीशु नै उस ताहीं कह्या, “जो माणस न्हा लिया हो उस ताहीं पैर कै सिवाय और कुछ धोण की जरूरत कोनी, पर वो पूरी तरियां साफ हो चुका सै, थम सारे साफ सो, पर एक नै छोड़ के।” ");
INSERT INTO bgc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","यीशु तो अपणे पकड़वाण आळे नै जाणै था, ज्यांतै उसनै कह्या, “थम सारे साफ सो, पर एक नै छोड़ के।” ");
INSERT INTO bgc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जिब यीशु नै पैर धो लिये, अर अपणे लत्ते दुबारा पहरकै फेर बैठग्या, तो उन ताहीं कहण लागग्या, “के थम समझे के मन्नै थारे गेल्या के करया?” ");
INSERT INTO bgc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","थम मन्नै गुरु अर प्रभु कहो सो, अर सही कहो सो, क्यूँके मै वोए सूं। ");
INSERT INTO bgc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","जिब मन्नै गुरु अर प्रभु होकै थारे पैर धोए, तो थमनै भी मेरी तरियां एक-दुसरे के पैर धोणे चाहिये। ");
INSERT INTO bgc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","क्यूँके मन्नै थारे ताहीं नमूना दिखाया सै, के जिसा मन्नै थारे गेल्या करया सै, थम भी उसाए करया करो। ");
INSERT INTO bgc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मै थारे तै साच्ची-साच कहूँ सूं, नौक्कर अपणे माल्लिक तै बड्ड़ा कोनी, अर ना प्रेरित अपणे भेजण आळे तै। ");
INSERT INTO bgc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","इब थम ये बात जाणगे सों, जै उनपै चाल्लों तो थम सुखी रहोगे। ");
INSERT INTO bgc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","मै थम सारया कै बारें म्ह कोनी कहन्दा, मै उननै जांणु सूं, जिनताहीं मन्नै छाँट लिया सै, (अर यो भी के यहूदा बिश्वासघाती सै) क्यूँके मन्नै उस ताहीं इस खात्तर छाट्या सै, ताके पवित्र ग्रन्थ का यो वचन पूरा हो, “जो मेरी रोट्टी खावै सै, उसनै मेरै पै लात ठाई।” ");
INSERT INTO bgc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“ये सब कुछ मन्नै थारे ताहीं पैहले ए बता दिया था, के जब न्यू हो जावै तो थम बिश्वास करियो के मै वोए सूं। ");
INSERT INTO bgc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मै थारे ताहीं साच्ची-साच कहूँ सूं, के जो मेरे भेज्जै होया नै अपणावै सै, वो मन्नै अपणावै सै, अर जो मन्नै अपणावै सै, वो मेरे भेजण आळे नै अपणावै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ये बात कहकै यीशु आत्मा म्ह दुखी होया अर या गवाही दी, “मै थारे ताहीं साच्ची-साच कहूँ सूं, के थारे म्ह तै एक मन्नै धोक्खा देकै पकड़वावैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेल्लें यो शक करते होए के वो किसकै बाबत कहवै सै, एक-दुसरे कै कान्ही लखाण लागगे। ");
INSERT INTO bgc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","उसके चेल्यां म्ह तै यूहन्ना जिस ताहीं यीशु प्यार राक्खै था, यीशु कै धोरै बेठ्या था। ");
INSERT INTO bgc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","शमौन पतरस नै यूहन्ना कान्ही इशारा करकै उस ताहीं बुझ्झया, “बता तो, वो किसकै बाबत कहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","फेर उसनै उस्से ढाळ यीशु की छात्ती कै कान्ही झुककै उस ताहीं बुझ्झया, “हे प्रभु, वो कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीशु नै जवाब दिया, “जिस ताहीं मै यो रोट्टी का टुकड़ा डुबोकै द्युगां वोए सै।” अर उसनै टुकड़ा डुबोकै शमौन के बेट्टे यहूदा इस्करियोती ताहीं दिया। ");
INSERT INTO bgc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","टुकड़ा खान्दे शैतान यहूदा इस्करियोती म्ह बड़ग्या। फेर यीशु नै उस ताहीं कह्या, “जो तू करै सै, तोळा कर।” ");
INSERT INTO bgc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","भोज पै बैठण आळे चेल्यां म्ह तै किसे नै भी यो कोनी बेरा लाग्गण पाया के उसनै या बात उसतै किस मतलब तै कही। ");
INSERT INTO bgc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","कईयाँ नै सोच्या के रपियाँ की थैल्ली यहूदा कै धोरै रहवै सै, ज्यांतै यीशु उस ताहीं कहवै सै के त्यौहार कै खात्तर जरूरी समान मोल ले आओ या गरीबां नै कुछ देवै, इस खात्तर यहूदा नै रोट्टी का टुकड़ा लिया। ");
INSERT INTO bgc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","आखर म्ह वो टुकड़ा खाकै जिब्बे बाहरणै लिकड़ग्या, अर रात का बखत था। ");
INSERT INTO bgc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जिब यहूदा बाहरणै लिकड़ग्या तो यीशु नै कह्या, “इब मुझ माणस के बेट्टे की महिमा होई सै, अर परमेसवर की महिमा मेरे म्ह होई सै, ");
INSERT INTO bgc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","परमेसवर भी अपणे बेट्टे की महिमा करैगा, अर वो जिब्बे करैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","हे बाळकों, मै थोड़ी सी वार और थारे धोरै सूं, फेर थम मन्नै टोहओगे, अर जिसा मन्नै यहूदियाँ ताहीं कह्या, “जड़ै मै जाऊँ सूं, उड़ै थम कोनी आ सकदे, न्यू इब मै थारे ताहीं भी कहूँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“मै थमनै नया हुकम द्यु सूं, के एक-दुसरे तै प्यार करो, जिसा मन्नै थारैतै प्यार करया सै, उस्से तरियां थम भी एक-दुसरे तै प्यार करो। ");
INSERT INTO bgc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","जै आप्पस म्ह प्यार राक्खोगे, तो इसतै सारया नै बेरा पाट्टैगा के थम मेरे चेल्लें सो।” ");
INSERT INTO bgc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","शमौन पतरस नै उस ताहीं कह्या, “हे प्रभु, तू कित्त जा सै?” यीशु नै जवाब दिया, “जड़ै मै जाऊँ सूं, उड़ै तू इब्बे मेरै पाच्छै न्ही आ सकदा, पर इसकै बाद मेरै गेल्या आवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरस नै उसतै कह्या, “हे प्रभु, इब्बे मै तेरे पाच्छै क्यातै न्ही आ सकदा? मै तो तेरी खात्तर अपणी जान भी देण नै तैयार सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीशु नै जवाब दिया, “के तू मेरी खात्तर अपणी जान दे देवैगा? मै तेरे तै सच कहूँ सूं, के मुर्गे कै बाँग देण तै पैहल्या तू तीन बार मेरे बारें म्ह मुकरैगा। ");
INSERT INTO bgc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“अपणे मन नै दुखी ना होण द्यो, थम परमेसवर पै बिश्वास राक्खो सो, अर मेरै पै भी बिश्वास राक्खो। ");
INSERT INTO bgc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मेरै पिता कै घर म्ह घणीए रहण की जगहां सै, जै न्ही होंदी तो मै थारे ताहीं कह देंदा, क्यूँके मै थारे खात्तर जगहां त्यार करण नै जाऊँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","अर जै मै जाकै थारे खात्तर जगहां त्यार करुँ, तो फेर दुबारै आकै थमनै अपणे उरै ले जाऊँगा के जड़ै मै रहूँ उड़ै थम भी रहो। ");
INSERT INTO bgc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","अर जित्त म्ह जाऊँ सूं, थम ओड़ै की राह जाणो सों।” ");
INSERT INTO bgc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा नै उसतै सवाल करया, “हे प्रभु, हमनै तेरे ठिकाणै का ए कोनी बेरा तो उसका राह किस तरियां जाण सका सां?” ");
INSERT INTO bgc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीशु नै उस ताहीं जवाब दिया, “मै ए वो राह अर सच अर अनन्त जीवन सूं, बिना मेरै जरिये कोए पिता धोरै कोनी पोहच सकदा। ");
INSERT INTO bgc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","जै थम सच म्ह ए मन्नै जाणदे होन्दे, तो मेरै पिता नै भी जाणदे, इसकै बाद थमनै उस ताहीं जाण लिया सै, अर उस ताहीं देख भी लिया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुस नै उस ताहीं कह्या, “हे प्रभु, तू म्हारै ताहीं पिता के दर्शन ए करा दे, योए म्हारै खात्तर भतेरा होगा।” ");
INSERT INTO bgc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीशु नै उस ताहीं कह्या, “हे फिलिप्पुस, मै इतने दिन तै थारे गेल्या सूं, के तू मन्नै कोनी जाण्दा? जिसनै मेरैताहीं देख्या सै उसनै पिता ताहीं देख्या सै। फेर क्यातै कहवै सै के पिता नै म्हारैताहीं दिखा?” ");
INSERT INTO bgc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","के तन्नै बिश्वास कोनी के मै पिता म्ह सूं, अर पिता मेरै म्ह सै? ये वचन जो मै थारे ताहीं बताऊँ सूं, अपणी ओड़ तै कोनी बतान्दा, पर मेरे भित्तर बसा पिता ए सै, जो मेरे म्ह होकै अपणे काम पूरा करण लागरया सै। ");
INSERT INTO bgc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मेरा-ए बिश्वास करो के मै पिता म्ह सूं, अर पिता मेरै म्ह सै, ना तो काम्मां कै कारण मेरा बिश्वास करो। ");
INSERT INTO bgc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","मै थारैतै साच्ची-साच कहूँ सूं, के जो मेरै पै बिश्वास राक्खै सै, ये काम जो मै करुँ सूं, वो भी करैगा, बल्के इनतै भी बड़े-बड़े काम करैगा, क्यूँके मै इब पिता कै धोरै जाऊँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","मेरै नाम तै थम जो कुछ माँगोगे, वोए मै करुँगा, जिसतै बेट्टे कै जरिये पिता की महिमा हो। ");
INSERT INTO bgc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","जै थम मेरै तै मेरै नाम तै कुछ माँगोगे, तो मै उस ताहीं पूरा करुँगा। ");
INSERT INTO bgc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“जै थम मेरै तै प्यार करो सो, तो मेरे हुकमां नै मान्नोगे। ");
INSERT INTO bgc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","मै पिता तै बिनती करुँगा, अर वो थारे ताहीं एक और मददगार देवैगा के वो सारीहाण थारे गेल्या रहवै। ");
INSERT INTO bgc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","यानिके सच का आत्मा, जिस ताहीं दुनिया कोनी अपणा सकदी, क्यूँके वो ना उसनै देक्खै सै, अर ना उस ताहीं जाणै सै, थम उसनै जाणो सो, क्यूँके आज वो थारे गेल्या सै, अर आण आळे बखत म्ह भी वो थारे म्ह बणा रहवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“मै थारे ताहीं अनाथ कोनी छोडूँगा, मै थारे धोरै बोहड़ के आऊँगा। ");
INSERT INTO bgc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","थोड़ा ए बखत बाकी सै, जिब दुनिया मेरै ताहीं कोनी देक्खैगी, पर थम मन्नै देक्खोगे, ज्यांतै के मै जिन्दा सूं, थम भी जिन्दा रहोगे। ");
INSERT INTO bgc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","जिब मै बोहड़ के आऊँगा, उस दिन थमनै बेरा लाग्गैगा, के मै अपणे पिता म्ह सूं, अर थम मेरै म्ह, मै थारे म्ह। ");
INSERT INTO bgc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","वो, जो मेरे हुकम नै मान्नै सै अर उननै निभावै सै, वोए मेरतै प्यार करै सै, अर जो मेरतै प्यार करै सै, वोए मेरे पिता का प्रियजन होगा, मै उसतै प्यार करुँगा, अर अपणे-आप ताहीं उसपै जाहिर करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","उस यहूदा नै (जो इस्करियोती कोनी था) यीशु ताहीं कह्या, “हे प्रभु, इसा के होया के तू अपणे-आप ताहीं म्हारै पै जाहिर करणा चाहवै सै, अर दुनिया के माणसां पै न्ही?” ");
INSERT INTO bgc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीशु नै उस ताहीं जवाब दिया, “जै कोए मेरै तै प्यार करै सै, तो वो मेरी शिक्षा का पालन करैगा, वो मेरे पिता का प्रियजन बणैगा, अर हम उसकै धोरै आकै उसकै गेल्या वास करागें।” ");
INSERT INTO bgc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","वो, जो मेरतै प्यार कोनी करदा, वो मेरै वचन नै कोनी मानता, अर जो वचन थम सुणो सो वो मेरे कोनी बल्के पिता के सै, जो मेरा भेजण आळा सै। ");
INSERT INTO bgc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ये बात मन्नै थारे गेल्या रहंदे होए थारैतै कही। ");
INSERT INTO bgc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पर मददगार यानिके पवित्र आत्मा जिस ताहीं पिता मेरै नाम तै भेज्जैगा, वो थारे ताहीं इन सारी बात्तां की शिक्षा देवैगा, अर जो कुछ मन्नै थारे तै कह्या सै, वो सारा कुछ थारे ताहीं याद दुआवैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","मै थारे ताहीं शान्ति देकै जाऊँ सूं, अपणी शान्ति थारे ताहीं दियुँ सूं, जिसी दुनिया थारे ताहीं शान्ति देवै सै, मै थमनै उसी शान्ति कोनी देंदा अपणे मन नै दुखी ना होण द्यो अर ना डरियो। ");
INSERT INTO bgc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","थमनै सुण्या के मन्नै थारे ताहीं के कह्या, “मै जाऊँ सूं, अर थारे धोरै फेर आऊँगा।” जै थम मेरै तै प्यार करदे, तो यो जाणकै राज्जी होन्दे, के मै पिता कै धोरै जाऊँ सूं, जो मेरै तै घणा महान् सै। ");
INSERT INTO bgc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","यो सब होण तै पैहल्या मन्नै थारे ताहीं इसके बारै म्ह बता दिया सै, के जिब यो हो जावै, तो थम बिश्वास करो। ");
INSERT INTO bgc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","मै इब थारे तै घणा कुछ न्ही कहूँगा, क्यूँके इस दुनिया का शासक (शैतान) आवै सै। मेरै पै उसका कोए हक कोनी, ");
INSERT INTO bgc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","दुनिया यो समझ ले के मै पिता तै प्यार करुँ सूं, योए कारण सै के मै उसके सारे हुकमां का पालन करुँ सूं। उठो, हम याड़ै तै चाल्लां। ");
INSERT INTO bgc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","यीशु नै कह्या, “मै सच्ची अंगूर की बेल की तरियां सूं, अर मेरा पिता किसान की तरियां सै। ");
INSERT INTO bgc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","मेरे मै लाग्गी हरेक डाळी जो फळ न्ही देन्दी, उस ताहीं वो काट देवै सै, पर हरेक एक फळ देण आळी डाळी ताहीं छांगै सै ताके वा और घणा फळ ल्यावै। ");
INSERT INTO bgc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","थम तो उस वचन कै कारण जो मन्नै थारैताहीं कह्या सै, शुद्ध होगे सो। ");
INSERT INTO bgc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","थम मेरै म्ह बणे रहो, अर मै थारे म्ह, जिस तरियां डाळी जै अंगूर की बेल म्ह बणी न्ही रहवै तो खुद तै कोनी फळ सकदी, उस्से तरियां थम भी जै मेरै म्ह बणे न्ही रहो तो कोनी फळ सकदे।” ");
INSERT INTO bgc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","मै अंगूर की बेल की ढाळ सूं अर थम डाळी सो। जो मेरै म्ह बण्या रहवै सै अर मै उस म्ह, वो घणाए फळ फळै सै, क्यूँके मेरै तै न्यारे पाटकै थम कुछ न्ही कर सकदे। ");
INSERT INTO bgc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","जै कोए मेरै म्ह न्ही बण्या रहंदा, तो वो डाळी की तरियां बगा दिया जावैगा, अर सूख जावै सै, अर माणस उन ताहीं कठ्ठे करकै आग म्ह झोक देवै सै, अर वे बळ जावै सै। ");
INSERT INTO bgc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","जै थम मेरै म्ह बणे रहो अर मेरे वचन थारे म्ह बणे रहवै, तो थारे माँगण पै थारी इच्छा पूरी करी जावैगी। ");
INSERT INTO bgc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","थारे फळ की भरपूरी म्ह मेरै पिता की महिमा अर थारा मेरे चेल्लें होण का सबूत सै। ");
INSERT INTO bgc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जिसा पिता नै मेरै तै प्यार करया, उसाए मन्नै थारैतै प्यार करया, मेरै प्यार म्ह बणे रहो। ");
INSERT INTO bgc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","जै थम मेरे हुकमां नै मान्नोगे, तो मेरै प्यार म्ह बणे रहोगे, जिस ढाळ के मन्नै अपणे पिता का हुकम मान्या सै, अर उसकै प्यार म्ह बणा रहूँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मन्नै ये बात थारे तै ज्यांतै कही, के जो आनन्द मेरे म्ह सै, वो थारे म्ह भी हो अर बढ़ता जावै। ");
INSERT INTO bgc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“मै थमनै नया हुकम द्यु सूं, के एक-दुसरे तै प्यार करियो, जिसा मन्नै थारैतै प्यार करया सै, उसाए थम भी एक-दुसरे तै प्यार करियो। ");
INSERT INTO bgc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","इसतै बड्ड़ा प्यार किसे का कोनी के कोए अपणे दोस्तां कै खात्तर अपणी जान दे। ");
INSERT INTO bgc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जो हुकम मै थारे ताहीं दियुँ सूं, जै थम उसपै चाल्लों सों तो थम मेरे साथी सो।” ");
INSERT INTO bgc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","मन्नै थारे ताहीं नौक्कर न्ही, पर साथी मान्या सै, क्यूँके नौक्कर माल्लिक के काम्मां तै अनजाण रहवै सै, मन्नै थारे ताहीं वे सारी बात बता दी सै, जो मन्नै पिता तै मिली सै। ");
INSERT INTO bgc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","थमनै मेरै ताहीं कोनी चुण्या पर मन्नै थारे ताहीं चुण्या सै अर थारैताहीं काम पै लाया सै, के थम जाकै फळ ल्याओ अर थारा फळ बणा रहवै, के थम मेरै नाम तै जो कुछ पिता तै माँग्गो, वो थारे ताहीं दे दे। ");
INSERT INTO bgc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","मेरा हुकम यो सै के थम एक-दुसरे तै प्यार करो। ");
INSERT INTO bgc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“जै दुनिया के माणस थारैतै बैर राक्खै सै, तो जाण ल्यो के उसनै थारैतै पैहल्या मेरै तै बैर राख्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","जै थम दुनिया के माणसां जिसे होन्दे, तो दुनिया थारे तै आपण्यां जिसा प्यार करदी, पर थम दुनिया के कोनी, बल्के मन्नै थारैताहीं दुनिया म्ह तै छाँट लिया सै, इस करकै दुनिया के माणस थारे तै बैर राक्खै सै। ");
INSERT INTO bgc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","याद राक्खों मन्नै थारे तै के कह्या था, ‘नौक्कर अपणे माल्लिक तै बड्ड़ा कोनी होंदा,’ जिब उननै मेरै ताहीं सताया, तो थारैताहीं भी सतावैगें। जै उननै मेरी शिक्षा मान्नी, तो थारी भी माँन्नैगें। ");
INSERT INTO bgc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","पर यो सब कुछ माणस मेरै नाम कै कारण थारे गेल्या करैगें, क्यूँके माणस मेरै भेजण आळे नै कोनी जाणदे। ");
INSERT INTO bgc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","जै मै न्ही आन्दा, अर उनतै बात न्ही करदा, फेर वे पापी कोनी ठहरदे, पर इब उननै उनकै पाप खात्तर कोए बहान्ना कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जो मेरै तै बैर राक्खै सै, वो मेरै पिता तै भी बैर राक्खै सै। ");
INSERT INTO bgc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","जै मै उनके बीच म्ह वे काम न्ही करदा, जो और किसे नै कोनी करे, तो वे पापी कोनी ठहरदे, पर इब तो जो कुछ मन्नै करया सै उननै मेरै ताहीं देख लिया सै, उननै मेरै ताहीं अर मेरे पिता दोनुआ तै बैर करया। ");
INSERT INTO bgc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","पर यो इस करकै होया के जो उनकै नियम-कायदा म्ह लिख्या सै वो सच हो सकै, ‘उननै मेरै तै खामखां बैर करया।’” ");
INSERT INTO bgc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पर जिब वो मददगार (सच का आत्मा जो पिता की ओड़ तै आवै सै) धोरै आवैगा, जिसनै मै थारे धोरै पिता की ओड़ तै भेज्जूँगा, तो वो मेरी गवाही देवैगा, ");
INSERT INTO bgc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","अर थम भी मेरे गवाह सो, क्यूँके थम शरु तै मेरै गेल्या रहे सो। ");
INSERT INTO bgc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ये बात मन्नै थारैतै ज्यांतै बताई सै के थारा बिश्वास डगमगा न्ही जावै।” ");
INSERT INTO bgc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","वे थमनै आराधनालयाँ म्ह तै काढ देवैगें, बल्के वो बखत आवै सै, के जो कोए थमनै मार देवैगा, वो न्यू समझैगा के मै परमेसवर की सेवा करुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","इसा वे ज्यांतै करैंगें के उननै ना पिता ताहीं जाण्या सै, अर ना मन्नै जाणै सै। ");
INSERT INTO bgc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पर ये बात मन्नै ज्यांतै थारैतै कही, के जिब इनका बखत आवै तो थमनै याद रहवै के मन्नै थारैतै पैहल्याए उसकै बारें म्ह बता दिया था। “मन्नै शरु म्ह थारैतै ये बात ज्यांतै कोनी कही क्यूँके मै थारे गेल्या था।” ");
INSERT INTO bgc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","पर इब मै अपणे भेजण आळे कै धोरै जाऊँ सूं, अर थारे म्ह तै कोए मेरै तै कोनी बुझता, “तू कित्त जावै सै?” ");
INSERT INTO bgc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पर मन्नै जो ये बात थारैतै कही सै, ज्यांतै थारा मन दुख तै भरग्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","फेरभी मै थारैतै साच्ची कहूँ सूं, के मेरा जाणा थारे खात्तर ठीक सै, क्यूँके जै मै ना जाऊँ तो वो मददगार थारे धोरै कोनी आवैगा, पर जै मै जाऊँगा, तो उस ताहीं थारे धोरै भेज्जूँगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","वो आकै दुनिया के माणसां ताहीं पाप अर धार्मिकता अर न्याय कै बाबत बतावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पाप कै बारै म्ह ज्यांतै के वे मेरै पै बिश्वास कोनी करदे। ");
INSERT INTO bgc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","अर धार्मिकता कै बारै म्ह ज्यांतै के मै पिता कै धोरै जाऊँ सूं, अर थम मन्नै दुबारै कोनी देक्खोगे, ");
INSERT INTO bgc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","न्याय कै बारै म्ह ज्यांतै के दुनिया का शासक कसूरवार ठहराया जा चुक्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","मन्नै थारे तै और भी घणीए बात कहणी सै, पर इब्बे थम उननै सह न्ही सकदे। ");
INSERT INTO bgc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पर जिब वो यानिके सच का आत्मा आवैगा, तो थम सारया नै सच का रास्ता बतावैगा, क्यूँके वो अपणी ओड़ तै कोनी कहवैगा पर जो कुछ सुणैगा वोए कहवैगा, अर होण आळी बात थारे ताहीं बतावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","वो मेरी महिमा करैगा, क्यूँके उस ताहीं मेरी ओड़ तै जो मिला सै, वो थारे ताहीं मेरी बात्तां म्ह तै लेकै बतावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","वो सब कुछ, जो पिता का सै, वो सारा मेरा सै, ज्यांतै मन्नै कह्या के वो मेरी बात्तां म्ह तै लेकै थारे ताहीं बतावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“थोड़ी देर म्ह थम मन्नै कोनी देक्खोगे, अर फेर थोड़ी देर म्ह मन्नै दुबारा देक्खोगे।” ");
INSERT INTO bgc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","फेर उसके कुछ चेल्यां नै आप्पस म्ह कह्या, “उसका इस बात तै के मतलब सै जो वो म्हारै ताहीं कहवै सै, ‘थोड़ी देर म्ह थम मन्नै कोनी देक्खोगे, अर फेर थोड़ी देर म्ह मन्नै दुबारा देक्खोगे?’ अर यो ‘ज्यांतै के मै पिता कै धोरै जाऊँ सूं?’” ");
INSERT INTO bgc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","फेर उननै कह्या, “यो ‘थोड़ी देर’ जो वो कहवै सै, या के बात सै? हम कोनी जाणदे के वो के कहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीशु नै न्यू जाणकै के वे मेरतै बुझणा चाहवै सै, उन ताहीं कह्या, “के थम आप्पस म्ह मेरी इस बात बाबत जाँच-पड़ताळ करो सो, ‘थोड़ी देर म्ह थम मन्नै कोनी देक्खोगे, अर फेर थोड़ी देर म्ह मन्नै दुबारा देक्खोगे?’ ");
INSERT INTO bgc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मै थारे तै साच्ची-साच कहूँ सूं, के जिब मै मरूँगा तो थम रोओगे अर बिलाप करोगे, पर दुनिया राज्जी होवैगी। थमनै दुख होगा, पर थारा दुख आनन्द म्ह बदल जावैगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","जाप्पै कै बखत बिरबान्नी नै दुख होवै सै, क्यूँके उसकै दुख का बखत आरया सै, पर जिब वा बाळक नै जन्म दे सै, तो इस खुशी तै, के दुनिया म्ह एक माणस पैदा होया, उस दुख नै फेर याद कोनी कर दी। ");
INSERT INTO bgc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","उस्से तरियां थारे म्ह भी इब तो दुख सै, पर मै थारे तै दुबारा मिलूँगा अर थारे मन आनन्द तै भर जावैंगे, थारा आनन्द कोए थारे तै खोस न्ही सकदा। ");
INSERT INTO bgc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","उस बखत थम मेरतै कुछ न्ही बुझ्झोगे। मै थारैतै सच कहूँ सूं, जै थम पिता तै कुछ माँगोगे, तो वो मेरै नाम तै थमनै देवैगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","इब ताहीं थमनै मेरै नाम तै पिता तै कुछ न्ही मांग्या, माँग्गो, तो पा ल्योगे ताके थारा आनन्द पूरा हो जावै। ");
INSERT INTO bgc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“मन्नै ये बात थारैताहीं उदाहरणां म्ह कही सै, पर वो बखत आवै सै, जिब पिता के बारें म्ह मै उदाहरणां म्ह न्ही कहूँगा, पर साफ शब्दां म्ह थारे ताहीं बताऊँगा। ");
INSERT INTO bgc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","उस दिन थम मेरै नाम तै माँगोगे, अर मै थारैतै न्यू कोनी कहन्दा के मन्नै ए थारे खात्तर पिता तै बिनती करणी पड़ैंगी, ");
INSERT INTO bgc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","क्यूँके मेरा पिता तो खुदे थारैतै प्यार करै सै, ज्यांतै के थमनै मेरतै प्यार करया सै अर यो बिश्वास करया सै के मै पिता की ओड़ तै भेज्या होड़ सूं। ");
INSERT INTO bgc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मै पिता की ओड़ तै दुनिया म्ह आया सूं, अर इब दुनिया नै छोड़कै पिता कै धोरै जाऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","उसकै चेल्यां नै कह्या, “हाँ, इब तू उदाहरणां म्ह न्ही, बल्के साफ शब्दां म्ह समझाण लागरया सै। ");
INSERT INTO bgc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","इब हम समझगे सां, के तू सब कुछ जाणै सै, अर इब किसे नै तेरे तै कोए सवाल पूच्छण जुरत कोनी, इस खात्तर हम बिश्वास करा सां के तू परमेसवर की ओड़ तै आया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","न्यू सुणकै यीशु नै उन ताहीं कह्या, “के थमनै इब बिश्वास होया सै?” ");
INSERT INTO bgc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","लखाओ, वो बखत आवै सै बल्के आण पहोंच्या सै के थम सारे खिंड-मिन्ड होकै अपणे-अपणे घर बोहड़ जाओगे, अर मन्नै एक्ला छोड़ दोगे, फेरभी मै एक्ला कोनी क्यूँके पिता मेरै गेल्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“मन्नै ये बात थारैतै ज्यांतै कही सै, के थम मेरै म्ह शान्ति पाओ। दुनिया म्ह थारे पै क्ळेश होवै सै, पर हिम्मत राखियो, मन्नै दुनिया ताहीं जीत लिया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीशु नै ये बात कही अर अपणी नजर अकास कान्ही ठाकै कह्या, “हे पिता, वो बखत आण पहोंच्या सै, अपणे बेट्टे की महिमा कर, के बेट्टा भी तेरी महिमा कर सकै, ");
INSERT INTO bgc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","क्यूँके तन्नै उस ताहीं सारी मानवजात्ति पै हक दिया, के वो सब नै अनन्त जीवन देवै जो तन्नै उस ताहीं सौप्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","अर अनन्त जीवन यो सै के वे तुझ, जो के एकमात्र सच्चे परमेसवर अर यीशु मसीह नै जिस ताहीं तन्नै भेज्या सै, जाणै। ");
INSERT INTO bgc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","जो काम तन्नै मेरै ताहीं सौप्या था, उस ताहीं पूरा करकै मन्नै धरती पै तेरी महिमा करी सै। ");
INSERT INTO bgc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","जो महिमा मेरी तेरे गैल दुनिया की सृष्टि तै पैहल्या थी, इब हे पिता, तू अपणे गेल्या मन्नै भी महिमावान कर।” ");
INSERT INTO bgc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“मन्नै तेरा नाम उन माणसां पै जाहिर करया सै दुनिया म्ह तै जिनताहीं तन्नै छाटकै मेरै ताहीं सौप्या था, वे तेरे थे पर तन्नै उन ताहीं मेरै ताहीं सौप्या सै, अर उननै तेरे वचन का पालन करया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","इब जाणगे सै के जो कुछ तन्नै मेरै ताहीं दिया सै, वो सारा तेरी ओड़ तै सै, ");
INSERT INTO bgc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","क्यूँके जो बात तन्नै मेरै ताहीं बताई, मन्नै उन ताहीं उनकै धोरै पहोंच्या दी सै, अर उननै उन ताहीं अपणालिया, अर सच म्ह ए जाण लिया सै के मै तेरी ओड़ तै आया सूं, अर उननै बिश्वास भी कर लिया सै के तू ए मेरा भेजण आळा सै। ");
INSERT INTO bgc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","मै उन खात्तर बिनती करुँ सूं, दुनिया के माणसां कै खात्तर बिनती कोनी करदा पर उन्नैए कै खात्तर करुँ सूं जिन ताहीं तन्नै मेरै ताहीं दिया सै, क्यूँके वे तेरे सै, ");
INSERT INTO bgc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","अर जो कुछ मेरा सै वो सारा तेरा सै, अर जो तेरा सै वो मेरा सै, अर मन्नै उनके जरिये महिमा पाई सै। ");
INSERT INTO bgc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","इब मै इस दुनिया म्ह कोनी रहूँगा, अर मै तेरे धोरै आऊँ सूं, पर ये दुनिया म्ह रहवैंगे, हे पवित्र पिता, अपणे नाम की शक्ति तै उनकी रुखाळ कर, जो तन्नै मेरै ताहीं दिया सै, ताके जिस तरियां मै अर तू एक सां, वे भी एक हो सकै। ");
INSERT INTO bgc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जिब मै उनकै गेल्या था, तो मन्नै उन ताहीं तेरे नाम म्ह, जो तन्नै मेरै ताहीं दिया था, उनकी रुखाळ करी, अर उन म्ह तै किसे का नाश कोनी होया, सिवाए उसके जिस ताहीं खोणा जरूरी था, वो भी ज्यांतै के पवित्र ग्रन्थ म्ह जो लिख्या होड़ सच हो। ");
INSERT INTO bgc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","पर इब मै तेरे धोरै आऊँ सूं, अर ये बात दुनिया म्ह रहते होए कहूँ सूं, ताके वे अपणे मनां म्ह मेरे भरपूर आनन्द नै पा सकै। ");
INSERT INTO bgc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मन्नै तेरा वचन उन ताहीं पोहोचा दिया सै, अर दुनिया के माणसां नै उनतै बैर करया, क्यूँके जिस तरियां मै इस दुनिया का कोनी, उस्से तरियां वे भी इस दुनिया के कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मै या बिनती कोनी करदा के उननै तू दुनिया तै लिकाड़ ले, बल्के तू उननै उस शैतान तै बचाए राख। ");
INSERT INTO bgc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जिस तरियां मै दुनिया का कोनी, उस्से तरियां वे भी दुनिया के कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","तेरा वचन साच्चा सै, सच कै जरिये तू उननै अलग करण खात्तर समर्पित कर। ");
INSERT INTO bgc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जिस तरियां तन्नै मेरै ताहीं दुनिया म्ह भेज्या, उस्से तरियां मन्नै भी उन ताहीं दुनिया म्ह भेज्या, ");
INSERT INTO bgc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","मै उनकै खात्तर खुद नै तेरी सेवा म्ह समर्पित करुँ सूं, ताके वे भी सच कै खात्तर समर्पित हो जावै। ");
INSERT INTO bgc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“मै केवल इन्हे खात्तर बिनती कोनी करदा, पर उन माणसां खात्तर भी जो इनकै वचन कै जरिये मेर पै बिश्वास करैगें, ");
INSERT INTO bgc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ताके वे सब एक हों, जिस तरियां हे पिता तू मेरै म्ह सै, अर मै तेरे म्ह सूं, उस्से तरियां वे भी म्हारै म्ह एक हो, जिसतै दुनिया के माणस बिश्वास करै के तन्नै ए मेरै ताहीं भेज्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","वा महिमा जो तन्नै मेरै ताहीं दी, मन्नै उन ताहीं दी सै, ताके वे उस्से तरियां ए एक होवै जिस तरियां हम एक सा, ");
INSERT INTO bgc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मै उन म्ह अर तू मेरे म्ह ताके वे सिध्द होकै एक हो जावै, अर दुनिया नै बेरा पाट्टै के तन्नै ए मेरै ताहीं भेज्या, अर जिस तरियां तन्नै मेरै तै प्यार करया उस्से तरियां उनतै प्यार करया।” ");
INSERT INTO bgc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","हे पिता, मै चाहूँ सूं, के जिन ताहीं तन्नै मेरैताहीं सौप्या सै, जड़ै मै सूं उड़ै वे भी मेरै गेल्या हो, के वे मेरी उस महिमा नै देक्खै जो तन्नै मेरैताहीं दी सै, क्यूँके तन्नै दुनिया नै बणाण तै पैहल्या मेरतै प्यार करया सै। ");
INSERT INTO bgc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“हे धार्मिक पिता, दुनिया के माणसां नै तो तेरे ताहीं कोनी जाण्या, पर मन्नै तेरे ताहीं जाण लिया सै, अर मेरे चेल्यां नै भी बेरा पाटग्या के तन्नै ए मेरैताहीं भेज्या सै। ");
INSERT INTO bgc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मन्नै तेरे ताहीं उनपै जाहिर करया सै, अर जाहिर होन्दा रहूँगा, के जो प्यार तन्नै मेरतै करया था वोए प्यार उन म्ह बस जावै, अर मै उन म्ह रहूँ।” ");
INSERT INTO bgc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","जिब यीशु नै प्रार्थना खतम कर ली, तो वो अपणे चेल्यां कै गेल्या किद्रोन नाळे कि परली ओड़ गया। उड़ै एक फूल्लां का बाग था, जिस म्ह वो अर उसके चेल्लें गए। ");
INSERT INTO bgc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","यीशु का पकड़ाण आळा यहूदा भी उस जगहां नै जाणै था, क्यूँके यीशु अपणे चेल्यां कै गैल उड़ै जाया करै था। ");
INSERT INTO bgc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","फेर यहूदा, सिपाहियाँ कै एक टोळ नै अर प्रधान याजकां अर फरीसियाँ की ओड़ तै मन्दर के पैहरेदारां नै लेकै, दीवे अर मशाल अर हथियारां नै लेकै उड़ै आया। ");
INSERT INTO bgc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","फेर यीशु, उन सारी बात्तां नै जो उसपै बीत्तण आळी थी जाणकै, लिकड़कै उन ताहीं पूछा, “किसनै टोह्वो सो?” ");
INSERT INTO bgc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","उननै उस ताहीं जवाब दिया, “यीशु नासरी नै।” यीशु नै उन ताहीं कह्या, “मैए सूं।” यीशु नै पकड़वाण आळा यहूदा भी उनकै गेल्या खड्या था। ");
INSERT INTO bgc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","जिब यीशु नै उनतै कह्या, “मै सूं,” वे पाच्छै हटकै धरती पै पड़गे। ");
INSERT INTO bgc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","फेर उसनै दुबारै उन ताहीं बुझ्झया, “थम किसनै टोह्वो सो?” वे बोल्ले, “यीशु नासरी नै।” ");
INSERT INTO bgc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीशु नै जवाब दिया, “मन्नै तो थारे ताहीं कह दिया सै के वो मै सूं, जै थम मन्नै टोह्वो सो तो इन माणसां नै जाण दो।” ");
INSERT INTO bgc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","यो इस करकै के खुद उसके जरिये कह्या गया यो वचन पूरा हो, “मन्नै उन म्ह तै एक भी न्ही खोया, जिन ताहीं तन्नै मेरतै सौप्या था।” ");
INSERT INTO bgc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","फेर शमौन पतरस नै तलवार, जो उसकै धोरै थी, खींच्ची अर महायाजक के नौक्कर पै चलाकै उसका सोळा कान उड़ा दिया, उस नौक्कर का नाम मलखुस था। ");
INSERT INTO bgc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","फेर यीशु नै पतरस तै कह्या, “अपणी तलवार म्यान म्ह धर। जो दुख का कटोरा पिता नै मेरै ताहीं दिया सै, के मै उसनै न्ही पीऊँ?” ");
INSERT INTO bgc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","फेर रोमी सिपाहियाँ अर उनकै सूबेदार अर यहूदिया परदेस के मन्दर के पैहरेदारां नै यीशु ताहीं पकड़कै बाँध लिया, ");
INSERT INTO bgc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","अर पैहल्या उस ताहीं हन्ना कै धोरै ले गए, क्यूँके वो उस साल के महायाजक काइफा का सुसरा था। ");
INSERT INTO bgc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","यो वोए काइफा था, जिसनै यहूदियाँ ताहीं सलाह दी थी के म्हारे माणसां खात्तर एक आदमी का मरणा ठीक सै। ");
INSERT INTO bgc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","शमौन पतरस अर एक और दुसरा चेल्ला भी यीशु कै पाच्छै हो लिए। यो चेल्ला महायाजक का जाण-पिच्छाण का था, ज्यांतै वो यीशु कै गेल्या महायाजक कै आँगण म्ह गया, ");
INSERT INTO bgc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पर पतरस बाहरणै दरबाजे पै खड्या रह्या। फेर दुसरा चेल्ला जो महायाजक की जाण-पिच्छाण का था, वो बाहरणै लिकड़या अर पहरेदारणी तै कहकै पतरस ताहीं भीत्त्तर लियाया। ");
INSERT INTO bgc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","उस नौकराणी नै, जो पहरेदारणी भी थी, पतरस तै कह्या, “कदे तू भी इस माणस के चेल्यां म्ह तै तो न्ही सै?” उसनै कह्या, “मै कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","नौक्कर अर मन्दर के पहरेदारां नै जाड्डे कै कारण आग जळा राक्खी थी, अर खड़े होकै सेक्कै थे, अर पतरस भी उनकै गेल्या खड्या आग सेक्कै था। ");
INSERT INTO bgc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","फेर महायाजक नै यीशु तै उसकै चेल्यां कै बाबत अर उसकै उपदेशां कै बाबत जाँच-पड़ताळ करी। ");
INSERT INTO bgc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीशु नै उस ताहीं जवाब दिया, “मन्नै हरेक माणस तै खुलकै बात करी, मन्नै सभायां अर आराधनालयाँ म्ह, जड़ै सारे यहूदी कठ्ठे होया करै सै, सारी हाण उपदेश दिया अर लुह्क कै कुछ कोनी कह्या। ");
INSERT INTO bgc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तू क्यूँ मेरे तै सवाल बुझ्झै सै? सवाल उनतै कर जिननै मेरे वचन सुणे सै, वे जाणे सै, के मन्नै उन ताहीं के-के कह्या।” ");
INSERT INTO bgc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जिब उसनै न्यू कह्या, तो मन्दर के पैहरेदारां म्ह तै एक नै जो धोरै खड्या था, यीशु कै थप्पड़ मारकै कह्या, “के तन्नै महायाजक ताहीं इस तरियां जवाब देण की हिम्मत किसी करी?” ");
INSERT INTO bgc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीशु नै उसतै जवाब दिया, “जै मेरा कहणा गलत सै तो साबित करो पर मन्नै जो कह्या सै वो सही सै तो फेर थम मेरै क्यूँ मारण लागरे सों?” ");
INSERT INTO bgc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","इस खात्तर यीशु ताहीं जो इब भी बाँधे होए थे, हन्ना नै काइफा महायाजक कै धोरै भेज दिया। ");
INSERT INTO bgc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","शमौन पतरस खड्या होया आग सेक्कै था, फेर उननै उसतै कह्या, “कदे तू भी उसकै चेल्यां म्ह तै तो न्ही सै?” उसनै नाट-कै कह्या, “मै कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","महायाजक के नौकरां म्ह तै एक, जो उसकै कुण्बे म्ह तै था, जिसका कान पतरस नै काट दिया था, बोल्या, “के मन्नै तेरे ताहीं यीशु कै गेल्या फूल्लां के बाग म्ह कोनी देख्या था?” ");
INSERT INTO bgc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरस फेर नाटग्या, अर जिब्बे मुर्गे नै बाँग देई। ");
INSERT INTO bgc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","फेर वे यीशु ताहीं काइफा कै धोरै तै किले म्ह लेगे, अर तड़कैए का बखत था, पर वे खुद किले कै भीत्त्तर कोनी गए ताके वे फसह का भोज खाण तै पैहल्या अशुद्ध ना हों जावै। ");
INSERT INTO bgc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","फेर राज्यपाल पिलातुस उनकै धोरै बाहरणै लिकड़कै आया अर कह्या, “थम इस माणस पै किस बात का दोष लाओ सो?” ");
INSERT INTO bgc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","उननै उस ताहीं जवाब दिया, “जै वो बुरे काम करणीया न्ही होंदा तो हम इसनै तेरे धोरै कोनी ल्यान्दे।” ");
INSERT INTO bgc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुस नै उनतै कह्या, “थमे इसनै ले जाकै अपणे नियम-कायदा कै मुताबिक इसका न्याय करो।” यहूदी अगुवां नै उसतै कह्या, “हमनै हक कोनी के किसे की जानलेवां।” ");
INSERT INTO bgc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","“यो इस करकै होया, ताके यीशु की वा बात पूरी हो जो उसनै यो इशारा देंदे होड़ कही थी के उसकी मौत किस ढाळ होगी।” ");
INSERT INTO bgc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","फेर पिलातुस दुबारै किले कै भीत्त्तर गया, यीशु ताहीं बुलाकै उसनै बुझ्झया, “के तू यहूदियाँ का राजा सै?” ");
INSERT INTO bgc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीशु नै जवाब दिया, “के तू या बात अपणी ओड़ तै कहवै सै या दुसरयां नै मेरै बाबत तेरे तै न्यू कह्या सै?” ");
INSERT INTO bgc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुस नै जवाब दिया, “के मै यहूदी न्ही सूं, तेरी-ए कोम अर प्रधान याजकां नै तेरे ताहीं मेरै हाथ म्ह सौंप्या सै। तन्नै के करया सै?” ");
INSERT INTO bgc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीशु नै जवाब दिया, “मेरा राज्य इस दुनिया का कोनी, जै मेरा राज्य इस दुनिया का होंदा, तो मेरे सेवादार लड़दे के मै यहूदी अगुवां कै हाथ्थां सौंप्या कोनी जान्दा पर सच्चाई तो या सै के मेरा राज्य आड़ै का सै ए कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातुस नै उसतै कह्या, “के तू राजा सै?” यीशु नै जवाब दिया, “तू कहवै सै के मै राजा सूं। मन्नै ज्यांतै जन्म लिया अर ज्यांतै दुनिया म्ह आया सूं, के सच की गवाही दियुँ। जो कोए सच का सै, वो मेरा वचन सुणै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुस नै उसतै कह्या, “सच के सै?” न्यू कहकै वो फेर यहूदी अगुवां कै धोरै लिकड़ आया अर उन ताहीं कह्या, “मै तो उस म्ह कुछ खोट कोनी पांदा।” ");
INSERT INTO bgc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पर थारे यो रिवाज सै के मै फसह पै थारे खात्तर एक माणस नै छोड़ दियुँ। आखर के थम चाह्वो सो, “के मै थारे खात्तर यहूदियाँ के राजा नै छोड़ दियुँ?” ");
INSERT INTO bgc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","फेर उननै रुक्के मारकै कह्या, “इसनै न्ही, पर म्हारै खात्तर बरअब्बा नै छोड़दे।” जिब के बरअब्बा बिद्रोही था। ");
INSERT INTO bgc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","फेर पिलातुस राज्यपाल नै यीशु कै कोड़े लगवाण खात्तर सिपाहियाँ के हाथ सौप दिया। ");
INSERT INTO bgc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपाहियाँ नै काण्डयाँ का मुकुट गूँथकै उसकै सिर पै धरया, अर उस ताहीं बैंजनी लत्ते पिहराये, ");
INSERT INTO bgc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","अर उसकै धोरै आ-आकै कहण लाग्गे, “हे यहूदियाँ के राजा, प्रणाम!” अर उसकै थप्पड़ भी मारे। ");
INSERT INTO bgc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","फेर पिलातुस नै दुबारै बाहरणै लिकड़कै माणसां ताहीं कह्या, “लखाओ, मै उसनै थारे धोरै फेर ल्याया सूं, ताके थमनै बेरा लाग्गै के मै उस म्ह कुछ भी खोट कोनी पान्दा।” ");
INSERT INTO bgc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","फेर यीशु ताहीं काण्डयाँ का मुकुट अर बैंजनी लत्ते पहरे होड़ बाहरणै लेग्या, अर पिलातुस नै उन ताहीं कह्या, “देक्खों, इस माणस नै!” ");
INSERT INTO bgc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","जिब प्रधान याजकां अर मन्दर के पैहरेदारां नै उस ताहीं देख्या, तो रुक्के मारकै कह्या, “उस ताहीं क्रूस पै चढ़ा, क्रूस पै!” पिलातुस नै उनतै कह्या, “थमे उसनै ले जाकै क्रूस पै चढ़ाओ, क्यूँके मै उस म्ह कोए खोट कोनी पान्दा।” ");
INSERT INTO bgc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदी अगुवां नै उस ताहीं जवाब दिया, “म्हारे नियम-कायदे सै अर उस नियम-कायदा कै मुताबिक इस माणस नै मौत की सजा मिलणी चाहिये, क्यूँके इसनै खुद ताहीं परमेसवर का बेट्टा होण का दावा करया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जिब पिलातुस नै या बात सुणी तो और भी घणा डरग्या, ");
INSERT INTO bgc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","अर दुबारै किले कै भीत्त्तर गया अर यीशु तै कह्या, “तू कितका सै?” पर यीशु नै उसतै कुछ भी जवाब कोनी दिया। ");
INSERT INTO bgc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","इसपै पिलातुस नै उसतै कह्या, “मेरतै क्यातै न्ही बोल्दा? के तन्नै कोनी बेरा के तेरे ताहीं छोड़ देण का हक मेरै ताहीं सै, अर तेरे ताहीं क्रूस पै चढ़ाण का भी मेरै ताहीं हक सै।” ");
INSERT INTO bgc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीशु नै जवाब दिया, “जै तेरे ताहीं परमेसवर की ओड़ तै हक न्ही दिया जान्दा, तो तेरा मेरै पै कोए हक कोनी होंदा, ज्यांतै जिसनै मेरै ताहीं तेरे हाथ पकड़ाया सै उसका पाप घणा सै।” ");
INSERT INTO bgc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","इस बात नै सुणकै पिलातुस नै उस ताहीं छोड़ देणा चाह्या, पर यहूदी माणसां की भीड़ नै रुक्के मार-मारकै कह्या, “जै तू इसनै छोड़ देवैगा, तो तू कैसर का बिरोध्दी बण जावैगा। जो कोए खुद नै राजा होण का दावा करै सै, वो कैसर का बिरोध्द करै सै।” ");
INSERT INTO bgc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ये बात सुणकै पिलातुस यीशु नै बाहरणै ल्याया अर उड़ै न्याय की गद्दी पै बैठग्या, जो इब्रानी भाषा म्ह “गब्बता” कुह्वावै सै, जिसका मतलब चोतरा हो सै। ");
INSERT INTO bgc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","यो फसह की त्यारी का दिन था, अर दोफाहरा का बखत था। फेर उसनै यहूदी माणसां ताहीं कह्या, “यो रह्या थारा राजा!” ");
INSERT INTO bgc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पर उननै और ऊँच्ची आवाज म्ह कह्या, “उस ताहीं मार द्यो! उस ताहीं मार द्यो! उस ताहीं क्रूस पै चढ़ा!” पिलातुस नै उनतै कह्या, “के मै थारे राजा नै क्रूस पै चढ़ाऊँ?” प्रधान याजकां नै जवाब दिया, “कैसर नै छोड़ म्हारा और कोए राजा कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","फेर पिलातुस नै यीशु ताहीं क्रूस पै चढ़ाण खात्तर उनकै हवालै कर दिया। ");
INSERT INTO bgc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","फेर सिपाही यीशु नै ले गए, अर यीशु अपणा क्रूस ठाए होए उस जगहां तक बाहर गया, जो “खोपड़ी” यानी इब्रानी भाषा म्ह “गुलगुता” कुह्वावै सै। ");
INSERT INTO bgc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","उड़ै उननै उस ताहीं अर उसकै गेल्या और दो माणसां ताहीं क्रूस पै चढ़ाया, एक इस ओड़ अर एक दुसरी ओड़, अर बिचाळै यीशु ताहीं। ");
INSERT INTO bgc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातुस नै एक दोषपत्र लिखकै क्रूस पै लगवा दिया, अर उसपै लिख्या होया था, “यीशु नासरी, यहूदियाँ का राजा।” ");
INSERT INTO bgc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","यो दोषपत्र घणखरे यहूदियाँ नै पढ़्या, क्यूँके यरुशलेम नगर जड़ै यीशु क्रूस पै चढ़ाया गया था नगर कै धोरै थी, अर दोषपत्र इब्रानी अर लतीनी अर यूनानी म्ह लिख्या होया था। ");
INSERT INTO bgc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","फेर यहूदियाँ के प्रधान याजकां नै पिलातुस तै कह्या, “‘यहूदियाँ का राजा’ मतना लिखै पर यो के उसनै कह्या, ‘मै यहूदियाँ का राजा सूं।’” ");
INSERT INTO bgc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुस नै जवाब दिया, “मन्नै जो लिखणा था, लिख दिया।” ");
INSERT INTO bgc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जिब सिपाहियाँ नै यीशु ताहीं क्रूस पै चढ़ा दिया, तो उसके लत्ते लेकै चार हिस्यां म्ह बांड लिए, हरेक सिपाही खात्तर एक हिस्सा, अर कुड़ता भी लिया, पर कुड़ता बिन सिलाई उप्पर तै तळै ताहीं सिम्या होया था। ");
INSERT INTO bgc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","इस करकै सिपाहियाँ नै आप्पस म्ह कह्या, “हम इस ताहीं पाड़ा कोनी, पर इसपै पर्ची गेर कै, के यो किसका होवैगा।” न्यू इस करकै होया के पवित्र ग्रन्थ म्ह जो लिख्या होया वो पूरा हो, “उननै मेरे लत्ते आप्पस म्ह बांड लिए अर मेरे लत्ते पै पर्ची गेरी।” ");
INSERT INTO bgc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","आखर म्ह सिपाहियाँ नै इसाए करया। यीशु कै क्रूस कै धोरै यीशु की माँ, अर उसकी मौस्सी, क्लोपास की घरआळी मरियम, अर मगदल गाम की मरियम खड़ी थी। ");
INSERT INTO bgc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","जिब यीशु नै अपणी माँ, अर उस चेल्लें ताहीं जिसतै वो प्यार करै था, धोरै खड़े देख्या तो अपणी माँ तै कह्या, “हे नारी, लखा, यो तेरा बेट्टा सै।” ");
INSERT INTO bgc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","फेर उस चेल्लें तै कह्या, “या तेरी माँ सै।” अर उस्से बखत वो चेल्ला उस ताहीं अपणे घरां लेग्या। ");
INSERT INTO bgc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","इसकै पाच्छै यीशु नै बेरा लागग्या के इब उसनै सारा काम पूरा कर लिया सै, ज्यांतै के पवित्र ग्रन्थ म्ह जो कह्या गया वो पूरा हो, कह्या, “मै तिसाया सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","उड़ै सिरके तै भरया होड़ एक बास्सण धरया था, आखर म्ह सिपाहियाँ नै सिरके म्ह भेकै स्पंज (फोम) ताहीं जुफे की लाठ्ठी पै धरकै उसकै मुँह कै लगाया ");
INSERT INTO bgc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","जिब यीशु नै वो सिरका चख्या, तो कह्या, “पूरा होया,” अर सिर झुकाकै जी दे दिया। ");
INSERT INTO bgc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","इब यो त्यारी का दिन था, अर आगला दिन आराम का दिन अर फसह का दिन था, यो यहूदी माणसां खात्तर एक खास दिन था, अर वे न्ही चाहवै थे, के इस दिन देह क्रूस पै टंगी रहवै, इस करकै यहूदियाँ नै पिलातुस तै बिनती करी के उन माणसां की टाँग तोड़ दी जावै, जो क्रूस पै चढ़ाये गये थे। ");
INSERT INTO bgc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","आखर म्ह सिपाहियाँ नै आकै उन माणसां म्ह तै पैहले की टाँग तोड़ी फेर दुसरे की भी, जो उसकै गेल्या क्रूस पै चढ़ाए गए थे, ");
INSERT INTO bgc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पर जिब यीशु कै धोरै आकै देख्या के वो मर लिया सै, तो उसकी टाँग कोनी तोड़ी। ");
INSERT INTO bgc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पर सिपाहियाँ म्ह तै एक नै बरछी तै उसका पंजर चीर दिया, अर उस म्ह तै जिब्बे लहू अर पाणी लिकड़या। ");
INSERT INTO bgc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जिस माणस नै यो देख्या, उसनै गवाही दी सै, अर उसकी गवाही साच्ची सै, अर उननै बेरा सै के वो साच्ची कह सै के थम भी बिश्वास करो। ");
INSERT INTO bgc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ये बात ज्यांतै होई के पवित्र ग्रन्थ म्ह जो कह्या गया वो पूरा हो, “उसकी कोए हाड्डी कोनी तोड़ी जावैगी।” ");
INSERT INTO bgc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फेर एक और जगहां पै पवित्र ग्रन्थ म्ह न्यू लिख्या सै, “जिस ताहीं उननै बेधा सै, उसनै वे देक्खैगें।” ");
INSERT INTO bgc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","इन बात्तां पाच्छै अरिमतिया गाम के यूसुफ नै जो यीशु का चेल्ला था, पर यहूदी अगुवां कै डर के मारे इस बात नै ल्कोए राक्खै था, पिलातुस तै बिनती करी, के वो यीशु की लाश ले जा सकै सै। पिलातुस नै उसकी बिनती सुणी, अर वो आकै उसकी लाश लेग्या। ");
INSERT INTO bgc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस भी, जो पैहले यीशु कै धोरै रात नै गया था, पचास सेर कै करीबन रळा होड़ गन्धरस अर एलवा (काण्डयाँ आळा पौधा) लियाया। ");
INSERT INTO bgc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","फेर उननै यीशु की लाश ली, अर यहूदियाँ कै गाड्डण कै रिवाज कै मुताबिक उस ताहीं खुशबुदार द्रव्य कै गेल्या कफन म्ह लपेट्या। ");
INSERT INTO bgc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","उस जगहां पै जड़ै यीशु क्रूस पै चढ़ाया गया था, एक फूल्लां का बगीचा था, अर उस फूल्लां की क्यारी म्ह एक नई कब्र थी जिसम्ह कदे कोए कोनी राख्या ग्या था। ");
INSERT INTO bgc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ज्यांतै उननै यीशु की लाश ताहीं उस्से कब्र म्ह धर दिया, क्यूँके वा लोवै ए थी, अर वो यहूदियाँ के आराम की त्यारी का दिन भी था। ");
INSERT INTO bgc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","हफ्तै कै पैहल्ड़े दिन तड़कैए सूरज लिकड़ण तै पैहल्या अन्धेरै रहंदे ए मगदल गाम की मरियम कब्र पै गई, अर पत्थर ताहीं कब्र पै तै हटया होड़ देख्या। ");
INSERT INTO bgc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","फेर वा भाज्जी अर शमौन पतरस अर उस दुसरे चेल्लै कै धोरै जिसतै यीशु प्यार राक्खै था, आकै कह्या, “वे प्रभु की लाश नै कब्र म्ह तै काढ लेगे सै, अर हमनै न्ही बेरा के उस ताहीं कित्त धर दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","फेर पतरस अर वो दुसरा चेल्ला लिकड़कै कब्र कै कान्ही चाल्ले। ");
INSERT INTO bgc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","वे दोन्नु गैल-गैल भाजरे थे, पर दुसरा चेल्ला पतरस तै तेज भाजकै कब्र पै पैहल्या पोंहच्या, ");
INSERT INTO bgc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","अर झुककै लत्ते पड़े देक्खे, तोभी वो भीत्त्तर कोनी गया। ");
INSERT INTO bgc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","फेर शमौन पतरस उसकै पाच्छै-पाच्छै पोंहच्या, अर कब्र कै भीत्त्तर गया अर उसनै भी लत्ते पड़े देक्खे, ");
INSERT INTO bgc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","अर वो अंगोच्छा जो उसकै सिर पै बन्धया होड़ था, लत्यां कै गेल्या कोनी पड्या था, पर न्यारा एक जगहां लपेटकै धरया होया देख्या। ");
INSERT INTO bgc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","फेर दुसरा चेल्ला भी जो कब्र पै पैहल्या पोंहच्या था, भीत्त्तर गया अर देखकै बिश्वास करया के यीशु मुर्दा म्ह तै जिन्दा होग्या। ");
INSERT INTO bgc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","पतरस अर दुसरा चेल्ला इब ताहीं पवित्र ग्रन्थ की वा बात कोनी समझे थे के उसनै मरे होया म्ह तै जी उठणा होगा। ");
INSERT INTO bgc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","फेर चेल्लें अपणे घरां बोहड़गे। ");
INSERT INTO bgc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","पर मरियम रोंदी होई कब्र कै धोरै ए बाहरणै खड़ी रही, अर रोन्दे-रोन्दे कब्र कै कान्ही कोड्डी होकै, ");
INSERT INTO bgc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","दो सुर्गदूत्तां ताहीं धोळे-चमकदे लत्ते पहरे होड़ एक सिरहाणै अर दुसरे ताहीं पांयां की ओड़ बेठ्ठे देख्या, जड़ै यीशु की लाश धरी गई थी। ");
INSERT INTO bgc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","उननै उस ताहीं कह्या, “हे नारी, तू क्यातै रोवै सै?” उसनै उन ताहीं कह्या, “वे मेरै प्रभु की लाश नै ठा लेगे अर मन्नै कोनी बेरा के उसनै कित्त धर राख्या सै।” ");
INSERT INTO bgc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","न्यू कहकै वा पाच्छै मुड़ी अर यीशु ताहीं खड़े देख्या, पर पिच्छाण्या कोनी के यो यीशु सै। ");
INSERT INTO bgc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीशु नै उसतै कह्या, “हे नारी, तू क्यातै रोवै सै? किसनै टोहवै सै?” उसनै माळी समझकै उस ताहीं कह्या, “हे श्रीमान, जै तन्नै उस लाश ताहीं ठा लिया सै, तो मन्नै बता के उस ताहीं कित्त धर राख्या सै, अर मै उसनै ले जाऊँगी।” ");
INSERT INTO bgc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीशु नै उस ताहीं कह्या, “मरियम!” उसनै बोहड़कै उस ताहीं इब्रानी म्ह कह्या, “रब्बुनी!” यानिके “हे गुरु”। ");
INSERT INTO bgc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीशु नै उस ताहीं कह्या, “पैरां म्ह लिपटकै मन्नै मतना छुओ, क्यूँके मै इब ताहीं पिता कै धोरै उप्पर कोनी गया, पर मेरे भाईयाँ कै धोरै जाकै उनतै कह दे, के मै अपणे पिता अर थारे पिता, अर अपणे परमेसवर अर थारे परमेसवर कै धोरै उप्पर जाकै आऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मगदलीनी नै जाकै चेल्यां ताहीं बताया, “मन्नै प्रभु ताहीं देख्या, अर उसनै मेरै तै ये बात कही।” ");
INSERT INTO bgc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","उस्से दिन जो हफ्तै का पैहल्ड़ा दिन था, साँझ कै बखत यहूदियाँ कै डर के मारे चेल्लें जिब किवाड़ मूंदे होड़ एक कमरे म्ह थे, तो यीशु उनकै बिचाळै आ खड्या होया अर उनतै बोल्या, “थमनै शान्ति मिलै।” ");
INSERT INTO bgc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","अर न्यू कहकै उसनै अपणे हाथ्थां के घा अर अपणा पंजर उनतै दिखाए। फेर चेल्लें यीशु नै देखकै राज्जी होए। ");
INSERT INTO bgc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीशु नै फेर उनतै कह्या, “थमनै शान्ति मिलै: जिस तरियां पिता नै मेरै ताहीं दुनिया म्ह भेज्या सै, उस्से तरियां ए मै थमनै दुनिया म्ह भेज्जू सूं।” ");
INSERT INTO bgc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","न्यू कहकै उसनै उनपै फूँक मारी अर उसनै कह्या, “पवित्र आत्मा ल्यो। ");
INSERT INTO bgc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","जिनके पाप थम माफ करो, वे उनकै खात्तर माफ करे गए सै, जिनके थम राक्खो, वे राक्खे गए सै।” ");
INSERT INTO bgc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","पर बारहा चेल्यां म्ह तै एक, यानिके थोमा जो दिदुमुस कुह्वावै सै, जिब यीशु आया तो उनकै गेल्या कोनी था। ");
INSERT INTO bgc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जिब दुसरे चेल्लें उसतै कहण लाग्गे, “हमनै प्रभु ताहीं देख्या सै,” फेर उसनै उनतै कह्या, “जिब ताहीं मै उसकै हाथ्थां म्ह कील्लां के छेद न्ही देख ल्यूँ, अर कील्लां के छेदां म्ह अपणी आंगळी न्ही घाल ल्यूँ, अर उसकै पंजर म्ह अपणा हाथ ना घाल ल्यूँ, जद ताहीं बिश्वास कोनी करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","आठ दिन कै पाच्छै उसके चेल्लें फेर घर कै भीत्त्तर थे, अर थोमा उनकै गेल्या था, अर किवाड़ मूंद राक्खे थे, फेर यीशु आया अर उनकै बिचाळै खड्या होकै कह्या, “थमनै शान्ति मिलै।” ");
INSERT INTO bgc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","फेर उसनै थोमा तै कह्या, “अपणी आंगळी याड़ै ल्याकै मेरै हाथ्थां नै देख अर अपणा हाथ ल्याकै मेरै पंजर म्ह घाल, अर अबिश्वासी न्ही पर बिश्वासी बण।” ");
INSERT INTO bgc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","न्यू सुणकै थोमा नै जवाब दिया, “हे मेरे प्रभु, हे मेरे परमेसवर!” ");
INSERT INTO bgc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीशु नै उसतै कह्या, “तन्नै तो मेरै ताहीं देखकै बिश्वास करया सै, धन्य वे सै जिन नै बिन देक्खे बिश्वास करया।” ");
INSERT INTO bgc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीशु नै और भी घणखरे चमत्कार चेल्यां कै आग्गै दिखाए, जो इस किताब म्ह कोनी लिक्खे गए, ");
INSERT INTO bgc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पर ये ज्यांतै लिक्खे गए सै के थम बिश्वास करो के यीशु ए परमेसवर का बेट्टा मसीह सै, अर बिश्वास करकै उसकै नाम म्ह अनन्त जिन्दगी पाओ। ");
INSERT INTO bgc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","इन बात्तां कै पाच्छै यीशु नै खुद ताहीं तिबिरियास झील कै किनारे चेल्यां पै जाहिर करया, अर इस ढाळ जाहिर करया ");
INSERT INTO bgc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","शमौन पतरस, अर थोमा जो दिदुमुस कुह्वावै सै, अर गलील परदेस कै काना नगर का नतनएल, अर जब्दी के बेट्टे, अर उसके चेल्यां म्ह तै दो और जणे कठ्ठे थे। ");
INSERT INTO bgc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","शमौन पतरस नै उन ताहीं कह्या, “मै मच्छी पकड़ण नै जाऊँ सूं।” उननै उसतै कह्या, “हम भी तेरे गेल्या चाल्लां सां।” इस करकै वे लिकड़कै किस्ती पै चढ़े, पर उस रात उननै कुछ न्ही पकड्या। ");
INSERT INTO bgc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","सबेर होन्दे-ए यीशु किनारे पै आ खड्या होया, फेरभी चेल्यां नै कोनी पिच्छाणा के यो यीशु सै। ");
INSERT INTO bgc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","फेर यीशु नै उन ताहीं कह्या, “हे बाळकों, के थारे धोरै कुछ खाण नै सै?” उननै जवाब दिया, “कोनी।” ");
INSERT INTO bgc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","यीशु नै उन ताहीं कह्या, “किस्ती कै सोळी ओड़ जाळ गेरो फेर पाओगे।” आखर उननै जाळ गेरया, अर इब घणी मच्छियाँ कै बाबत जाळ उनपै खिच्या कोनी। ");
INSERT INTO bgc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","फेर उस चेल्लें नै जिसतै यीशु प्यार करै था, पतरस तै कह्या, “यो तो प्रभु सै!” शमौन पतरस नै न्यू सुणकै के वो तो प्रभु सै, अपणा बाहरी कपड़ा लपेट्या अर झील म्ह कूद पड्या, क्यूँके उस बखत वो अंगोच्छें-अंगोच्छें म्ह था। ");
INSERT INTO bgc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","पर दुसरे चेल्लें डोंगी पै मच्छी तै भरया होड़ जाळ खिंचदे होए आए, क्यूँके वे किनारे तै घणी दूर कोनी, पर कोए दो सौ हाथ (सौ मीटर) की दूरी पै थे। ");
INSERT INTO bgc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जिब चेल्लें किनारे पै उतरे, तो उननै कोयले की आग अर उसपै मच्छी धरी होई, अर रोट्टी देक्खी। ");
INSERT INTO bgc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीशु नै उनतै कह्या, “जो मच्छी थमनै इब्बे पकड़ी सै, उन म्ह तै कुछ ल्याओ।” ");
INSERT INTO bgc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","फेर शमौन पतरस नै डोंगी पै चढ़कै एक सौ तरेपन बड्डी मच्छियाँ तै भरया होड़ जाळ किनारे पै खिच्या, अर इतनी मच्छी होन्दे होए भी जाळ कोनी पाट्या। ");
INSERT INTO bgc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीशु नै उनतै कह्या, “आओ, खाणा खाओ।” चेल्यां म्ह तै किसे की हिम्मत कोनी होई, के उसतै बुझ्झै, “तू कौण सै?” क्यूँके उननै बेरा था, के हो ना हो यो प्रभु ए सै। ");
INSERT INTO bgc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीशु आया अर रोट्टी लेकै उन ताहीं दी, अर उस्से ढाळ मच्छी भी। ");
INSERT INTO bgc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","यो तीसरी बार सै के यीशु मरे होया म्ह तै जिन्दा उठ्ठण कै पाच्छै चेल्यां नै दिखाई दिया। ");
INSERT INTO bgc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","खाणा खाणे कै पाच्छै यीशु नै शमौन पतरस तै कह्या, “हे शमौन, यूहन्ना के बेट्टे, के तू चेल्यां तै बाध मेरतै प्यार करै सै?” उसनै उसतै कह्या, “हाँ प्रभु, तन्नै तो बेरा सै के मै तेरे तै प्यार राक्खूँ सूं।” उसनै उसतै कह्या, “मेरे मेम्‍ना नै चरा।” ");
INSERT INTO bgc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","उसनै दुसरी बर उसतै कह्या, “हे शमौन, यूहन्ना के बेट्टे, के तू मेरै तै प्यार राक्खै सै?” उसनै उसतै कह्या, “हाँ प्रभु, तन्नै तो बेरा सै के मै तेरे तै प्यार राक्खूँ सूं।” उसनै उसतै कह्या, “मेरी भेड्डां की रुखाळी कर।” ");
INSERT INTO bgc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","उसनै तीसरी बर उस ताहीं कह्या, “हे शमौन, यूहन्ना के बेट्टे, के तू मेरतै प्यार राक्खै सै?” पतरस कांल होया के उसनै उसतै तीसरी बर इसा कह्या, “हे शमौन, यूहन्ना के बेट्टे, के तू मेरतै प्यार राक्खै सै?” अर उसतै कह्या, “हे प्रभु, तन्नै तो सारा कुछ बेरा सै, तन्नै न्यू बेरा सै के मै तेरे तै प्यार राक्खूँ सूं।” यीशु नै उसतै कह्या, “मेरी भेड्डां नै चरा।” ");
INSERT INTO bgc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","मै तेरे तै साच्ची-साच कहूँ सूं, “जिब तू जवान था तो अपणी कड़ बाँधकै जड़ै चाहवै था उड़ै हाँडै था, पर जिब तू बूढ़ा होगा तो अपणे हाथ पसारैगा, अर दुसरा तेरी कड़ बाँधकै जड़ै तू ना चाहवैगा उड़ै तन्नै ले जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","यीशु नै इन बात्तां तै इशारा करया के पतरस किसी मौत तै परमेसवर की महिमा करैगा, अर फेर उसनै उसतै कह्या, “मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरस नै बोहड़कै उस चेल्लें ताहीं पाच्छै आन्दे देख्या, जिसतै यीशु प्यार राक्खै था, जो खाणे कै बखत उसकै साथ बेठ्या था, उसतै बुझ्झया, “हे प्रभु, तेरा पकड़वाण आळा कौण सै?” ");
INSERT INTO bgc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","उस ताहीं देखकै पतरस नै यीशु तै कह्या, “हे प्रभु, इसका के हाल होगा?” ");
INSERT INTO bgc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीशु नै उसतै कह्या, “जै मै चाहूँ के वो मेरै आण ताहीं रुक्या रहवै, तो तन्नै इसतै के? तू मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ज्यांतै भाईयाँ म्ह या बात फैलगी के वो चेल्ला कोनी मरैगा, फेरभी यीशु नै उसतै न्यू कोनी कह्या के वो कोनी मरैगा, पर यो के, “जै मै चाहूँ के वो मेरै आण ताहीं रुक्या रहवै, तो तन्नै इसतै के?” ");
INSERT INTO bgc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","यो वोए चेल्ला सै जो इन बात्तां की गवाही देवै सै अर जिसनै इन बात्तां ताहीं लिख्या सै, अर हमनै बेरा सै के उसकी गवाही साच्ची सै। ");
INSERT INTO bgc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","और भी घणेए काम सै, जो यीशु नै करे, जै वे एक-एक करकै लिखे जान्दे, तो मै समझू सूं के किताब जो लिक्खी जान्दी वा दुनिया म्ह भी कोनी समान्दी।");
INSERT INTO bgc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","हे थियुफिलुस, मन्नै पैहल्ड़ी किताब उन सारी बात्तां कै बारें म्ह लिक्खी, जो यीशु शरु तै लेकै सुर्ग म्ह ठाए जाण तक करदा अर सिखान्दा रहया, ");
INSERT INTO bgc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","पर यीशु ताहीं परमेसवर के जरिये सुर्ग म्ह उठाए जाण तै पैहले उसनै अपणे चुणे होए प्रेरितां ताहीं पवित्र आत्मा के जरिये हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","यीशु के दुख ठाण कै पाच्छै उन प्रेरितां कै स्याम्ही भोत-से पक्के सबूत दिखाए के वो जिन्दा सै, अर वो चाळीस दिन तक उननै दिखदा रहया, अर परमेसवर के राज्य की बात करदा रहया। ");
INSERT INTO bgc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","अर एक दिन मसीह यीशु नै उनतै कठ्ठे करकै उन ताहीं हुकम दिया, “यरुशलेम नगर नै ना छोड्डो, पर पिता की उस प्रतिज्ञा की पूरे होण की बाट देखदे रहो, जिसका जिक्र थम मेरै तै सुण चुके सो। ");
INSERT INTO bgc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","क्यूँके यूहन्ना नै तो पाणी तै बपतिस्मा दिया सै पर थोड़े दिनां पाच्छै थम पवित्र आत्मा तै बपतिस्मा पाओगे।” ");
INSERT INTO bgc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","चेल्लें जिब यीशु तै दुबारा मिले तो उननै उसतै बुझ्झया, “हे प्रभु, के वो बखत आ ग्या सै, के तू इस्राएल ताहीं छुड़वा कै उसनै दुबारा बसाकै राजा के रूप म्ह सब पै शासन करैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","उसनै उनतै कह्या, “उस बखत या युगा ताहीं, जिन ताहीं पिता नै अपणे अधिकार म्ह कर राख्या सै, उननै जाणणा थारा काम कोनी। ");
INSERT INTO bgc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पर जिब पवित्र आत्मा थारे पै आवैगा फेर थम सामर्थ पाओगे, अर यरुशलेम नगर अर सारे यहूदिया और सामरिया परदेसां म्ह, अर धरती कै सिरे ताहीं मेरे बारें म्ह गवाही द्योगे।” ");
INSERT INTO bgc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","न्यू कहकै यीशु उनकै देखदे-देखदे परमेसवर के जरिये उप्पर ठा लिया गया, अर बाद्दळ नै उस ताहीं उनकी आँखां तै लह्को लिया। ");
INSERT INTO bgc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","उसकै जान्दे बखत जिब वे अकास की ओड़ देक्खै थे, तो देक्खो, चाणचक दो माणस धोळे लत्ते पहरे ओड़ उनकै लोवै आण खड़े होए, ");
INSERT INTO bgc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","अर उनतै कह्या, “हे गलील परदेस के माणसों, थम खड़े अकास कान्ही क्यांतै लखाओ सो? योए यीशु, जो परमेसवर के जरिये थारे धोरै तै सुर्ग पै ठा लिया गया सै, जिस तरियां तै थमनै उस ताहीं सुर्ग नै जान्दे देख्या उस्से तरियां तै वो दुबारा आवैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","जिब सुर्गदूत चले गये, तो चेल्लें जैतून नाम के पहाड़ तै जो यरुशलेम नगर तै करीब आधै कोस की दूरी पै सै, यरुशलेम नगर म्ह बोह्ड़े। ");
INSERT INTO bgc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","जिब वे नगर पोहचे तो उस चुबारै पै गये, जित्त पतरस अर यूहन्ना अर याकूब अर अन्द्रियास अर फिलिप्पुस अर थोमा अर बरतुल्मै अर मत्ती अर हलफई का बेट्टा याकूब अर शमौन, जेलोतेस अर याकूब का बेट्टा यहूदा ये सारे माणस ओड़ै थे। ");
INSERT INTO bgc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ये सारे कई बिरबानियाँ अर यीशु की माँ मरियम अर उसके भाईयाँ कै गेल्या कठ्ठे होकै एक मन तै प्रार्थना म्ह लाग्गे रहे। ");
INSERT INTO bgc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","उन्हे दिनां म्ह पतरस बिश्वासियाँ कै बिचाळै म्ह जो एक सौ बीस आदमियाँ कै करीबन थे, खड्या होकै कहण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","हे भाईयो, जरूरी था के पवित्र ग्रन्थ का वो लेख पूरा हो जो पवित्र आत्मा नै दाऊद के मुँह तै यहूदा कै बाबत, जो यीशु कै पकड़वाण आळा का अगुवां था, पैहल्याए तै कह्या था। ");
INSERT INTO bgc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","क्यूँके वो तो म्हारै म्ह गिण्या गया, अर इस सेविकाई म्ह साझ्झी होया। ");
INSERT INTO bgc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“जिसा थम जाणो सों (उसनै पाप की कमाई तै एक खेत मोल लिया, अर सिर के बळ गिरया अर उसका पेट पाटग्या अर उसकी सारी आन्दड़ी लिकड़गी। ");
INSERT INTO bgc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","इस बात ताहीं यरुशलेम नगर के सारे रहणीये जाणगे, उरै ताहीं के उस खेत का नाम उनकी भाषा म्ह ‘हक्कलदमा’ यानिके ‘लहू का खेत’ पड़ग्या।)” ");
INSERT INTO bgc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“दाऊद नै भजन संहिता म्ह लिख्या सै, ‘उसका घर उजड़ जावै, अर यो भी लिख्या सै, के उस म्ह कोए न्ही बसै,’ अर ‘उसका पद कोए और ले लेवै।’” ");
INSERT INTO bgc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“इस करकै यो जरूरी सै के एक इसा माणस छाट्या जावै, जो प्रभु यीशु के सारे काम्मां के हरेक बखत का गवाह हो, प्रभु यीशु ताहीं यूहन्ना के जरिये बपतिस्मा दिये जाण तै लेकै, सुर्ग म्ह स्वीकार किये जाण तक, ");
INSERT INTO bgc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","वो माणस म्हारे गैल प्रभु यीशु के जिन्दा होण का गवाह बणै।” ");
INSERT INTO bgc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","फेर उननै दो नाम सुझाए, एक यूसुफ जो बरसब्बा कुह्वावै था, जिसका उपनाम यूसतुम सै, दुसरा मत्तियाह ताहीं, ");
INSERT INTO bgc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","अर या प्रार्थना करी, “हे प्रभु, तू जो सारया के मनां नै जाणै सै, न्यू बता के इन दोनुआ म्ह तै तन्नै किस ताहीं चुण्या सै, ");
INSERT INTO bgc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","के वो इस सेवा के काम अर प्रेरितों की वा खाल्ली जगहां ले, जिसनै यहूदा छोड़कै अपणी जगहां चल्या गया, जित्त उसनै जाणा चाहिए था।” ");
INSERT INTO bgc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","फेर उननै उनकै बाबत पर्ची गेरी, अर पर्ची मत्तियाह कै नाम लिकड़ी। आखर वो उन ग्यारहां प्रेरितां कै गेल्या गिण्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","यहूदियाँ के पिन्तेकुस्त त्यौहार के दिन, यीशु के चेल्लें एक जगहां कठ्ठे थे। ");
INSERT INTO bgc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","चाणचक अकास तै तेज आँधी जिसी आवाज आई, अर उसतै सारा घर जित्त वे बेठ्ठे थे, गूँजग्या। ");
INSERT INTO bgc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","अर उननै एक आग की लपट दिक्खी, जो जीभ के समान थी, वा आग की लपट अलग-अलग होकै उन सब कै उप्पर आ उतरी। ");
INSERT INTO bgc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","वे सारे पवित्र आत्मा तै भरगे, अर जो वरदान पवित्र आत्मा नै उन ताहीं दिया, उसके मुताबिक वो अन्य-अन्य भाषा बोल्लण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","उस बखत पूरी दुनिया की हरेक जात म्ह तै यहूदी-भगत यरुशलेम नगर म्ह रहण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जिब आँधी जिसा शब्द गरजा, तो भीड़ लाग्गी अर आदमी घबरागे, क्यूँके हर एक अपणी-अपणी भाषा म्ह चेल्यां ताहीं बोलदे सुणण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","वे सारे हैरान अर अचम्भा करकै कहण लाग्गे, “देक्खो, जो वे बोल्लण लागरे सै के सारे गलीलवासी कोनी? ");
INSERT INTO bgc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तो यो के होण लागरया सै, के जो म्हारे म्ह तै हर एक इन ताहीं अपणी-अपणी जन्म-भूमि की भाषा म्ह बात करते सुणै सै! ");
INSERT INTO bgc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हम जो पारथी अर मेदी अर एलामी अर मेसोपोटामिया अर यहूदिया अर कप्‍पदूकिया अर पुन्तुस अर आसिया परदेस, ");
INSERT INTO bgc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","कुछ फ्रुगिया, पंफूलिया परदेस अर कुछ मिस्र देश अर लीबिया देश जो कुरेने नगर कै लोवै-धोरै सै, इन सारे देशां के रहण आळे अर रोमी प्रवासी, ");
INSERT INTO bgc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","यानिके यहूदी माणस अर यहूदी पंथ धारण करण आळे, क्रेतो दीप अर अरब देश के माणस भी सै, पर अपणी-अपणी भाषा म्ह उनतै परमेसवर के बड़े-बड़े काम्मां का जिक्र सुणै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","अर वे सारे हैरान होए अर घबराकै एक-दुसरे तै कहण लाग्गे, “यो के होण लागरया सै?” ");
INSERT INTO bgc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पर औरां नै मखौल करकै कह्या, “वे तो नई मदिरा कै नशै म्ह चूर सै।” ");
INSERT INTO bgc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","जिब पतरस उन ग्यारहां प्रेरितां कै गेल्या खड्या होया, अर ठाड्डू आवाज म्ह बोल्या, “हे यहूदिवासियों अर हे यरुशलेमवासियों, न्यू जाण ल्यो, अर कान लाकै मेरी बात सुणो।” ");
INSERT INTO bgc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","जिसा थम समझरे सो, ये आदमी नशै म्ह कोनी, क्यूँके इब्बे दिन के नौ बजे सै। ");
INSERT INTO bgc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","जो थम म्हारै साथ होते होए देखण लागरे सों, यो योएल नबी कै जरिये कही गई भविष्यवाणी का पूरा होणा सै। ");
INSERT INTO bgc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘परमेसवर कहवै सै, के अन्त के दिनां म्ह इसा होवैगा के मै अपणा आत्मा सारे माणसां ताहीं दियुँगा,’ अर थारे बेट्टे अर थारी बेट्टी भविष्यवाणी करैगी, अर थारे जवान दर्शन देखैगें, अर थारे बुजुर्ग सपना देक्खैगें।” ");
INSERT INTO bgc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","उन दिनां म्ह, मै अपणे दास्सां, अर दासियाँ ताहीं अपणी आत्मा दियुँगा, अर वे भविष्यवाणी करैगें। ");
INSERT INTO bgc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","अर मै उप्पर अकास म्ह अनोक्खे काम अर तळै धरती पै निशान, यानिके लहू अर आग अर धुम्मै का बाद्दळ दिखाऊँगा। ");
INSERT INTO bgc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","प्रभु के महान् अर तेजस्वी दिन कै आण तै पैहल्या सूरज अँधेरा अर चाँद लहू-सा हो जावैगा। ");
INSERT INTO bgc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","अर जो कोए प्रभु का नाम लेवैगा, उसका उद्धार होवैगा। ");
INSERT INTO bgc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“हे इस्राएलियों, इन बात्तां नै सुणो यीशु नासरी एक माणस था जिसका परमेसवर की ओड़ तै होण का सबूत उन सामर्थ के काम्मां अर हैरानी के काम्मां अर चमत्कारां तै जाहिर सै, जो परमेसवर नै थारे बिचाळै उसकै जरिये कर दिखाए जिसकै बारै म्ह थमनै खुदे बेरा सै। ");
INSERT INTO bgc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","उस्से यीशु ताहीं, जो परमेसवर की ठहराई होई योजना अर पूर्व ज्ञान कै मुताबिक पकड़वाया गया, थमनै अधर्मियाँ के हाथ्थां तै क्रूस पै चढ़ाकै उस ताहीं मार दिया। ");
INSERT INTO bgc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पर उस्से ताहीं परमेसवर नै मौत के बन्धनां तै छुड़ाकै जिन्दा करया, क्यूँके यीशु ताहीं अपणे बस म्ह राखणा मौत खात्तर असम्भव था।” ");
INSERT INTO bgc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","राजा दाऊद यीशु कै बारै म्ह कहवै सै, “मै प्रभु नै सारी हाण अपणे धोरै देख्दा रहया क्यूँके वो मेरी सोळी ओड़ सै, मै उनतै न्ही डरुँगा जो लोग मेरा नुकसान करणा चाहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","इस्से कारण मेरा मन आनन्दित होया, अर मै खुशी तै गाऊँगा, बल्के मेरी आस भी उस्से म्ह बणी रहवैगी। ");
INSERT INTO bgc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","क्यूँके तू मेरै प्राणां नै अधोलोक म्ह कोनी छोड्डैगा, अर ना अपणे पवित्र माणस नै सड़ण देवैगा। ");
INSERT INTO bgc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","“तन्नै मेरै ताहीं जीण का राह बताया सै, तू मन्नै दर्शन कै जरिये आनन्द तै भर देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“हे भाईयो, मै कुलपति राजा दाऊद कै बारै म्ह थारे तै हिम्मत करकै कहूँ सूं के वो तो मरग्या अर गाड्या भी गया अर उसकी कब्र आज ताहीं म्हारै उरै न्यू-की-न्यू सै। ");
INSERT INTO bgc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","वो नबी था अर उसनै बेरा था के परमेसवर नै मेरै तै वादा करया सै के मै तेरी पीढ़ी म्ह तै एक माणस नै तेरे सिंहासन पै बिठाऊँगा, ");
INSERT INTO bgc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","उसनै होण आळी बात ताहीं पैहल्याए तै देखकै मसीह के जिन्दा उठण कै बारै म्ह भविष्यवाणी करी के ना तो उसका प्राण अधोलोक म्ह छोड्या गया अर ना उसकी देह सड़ण पाई। ");
INSERT INTO bgc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","इस्से यीशु ताहीं परमेसवर नै जिन्दा करया, जिसके हम सारे गवाह सां। ");
INSERT INTO bgc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","इस तरियां परमेसवर के सोळे हाथ पै सबतै ऊँच्चा पद पाकै, अर पिता तै वो पवित्र आत्मा पाकै जिसका वादा लिया गया था, उसनै यो उण्डेल दिया सै जो थम देक्खो अर सुणो सो। ");
INSERT INTO bgc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","क्यूँके दाऊद तो सुर्ग पै कोनी चढ्या, पर वो खुद कहवै सै, ‘प्रभु परमेसवर नै मेरे प्रभु तै कह्या,’ मेरै सोळी ओड़ नै बैठ, ");
INSERT INTO bgc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“जिब ताहीं के मै तेरे बैरियाँ नै तेरे कदमां तळै ना झुका दियुँ।” ");
INSERT INTO bgc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“आखर इस्राएल का सारा खानदान पक्की तरियां तै जाण लेवै के परमेसवर नै उस्से यीशु ताहीं जिस ताहीं थमनै क्रूस पै चढ़ाया, प्रभु भी ठहराया अर मसीह भी।” ");
INSERT INTO bgc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","जिब माणसां नै यो सुण्या, तो बिश्वास होग्या था के उननै गलत काम करया सै, अर वे पतरस अर बाकी प्रेरितां तै बुझ्झण लाग्गे, “हे भाईयो, हम के करा?” ");
INSERT INTO bgc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरस नै उनतै कह्या, “पाप करणा छोड़ द्यो, अर थारे म्ह तै हरेक अपणे-अपणे पापां की माफी कै खात्तर यीशु मसीह कै नाम तै बपतिस्मा लेवै, जिब थम पवित्र आत्मा का दान पाओगे। ");
INSERT INTO bgc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","क्यूँके या प्रतिज्ञा थम, अर थारी ऊलादां, अर उन सारे दूर-दूर के आदमियाँ खात्तर भी सै जिन ताहीं प्रभु म्हारा परमेसवर अपणे धोरै बुलावैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरस नै कई और बात्तां तै, भी गवाही दे-देकै समझाया के अपणे-आपनै इस टेढ़ी जात तै बचाओ। ");
INSERT INTO bgc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","आखर जिननै उसके वचन पै बिश्वास करकै बपतिस्मा लिया, अर उस्से दिन तीन हजार माणसां कै करीबन उन म्ह मिलगे। ");
INSERT INTO bgc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","जिननै पतरस के वचन पै बिश्वास करया, वे प्रेरितां तै शिक्षा लेन्दे, अर संगति राखदे, अर रोट्टी तोड़ण, अर प्रार्थना करण म्ह मग्न रहे। ");
INSERT INTO bgc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","अर सारे के यरुशलेम माणस डरगे, अर घणे अनोक्खे काम अर चमत्कार प्रेरितां कै जरिये जाहिर होवै थे। ");
INSERT INTO bgc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","अर सारे बिश्वास करणीये कठ्ठे रहवै थे, अर उनकी सारी चीज साझे म्ह थी। ");
INSERT INTO bgc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","वे अपणी-अपणी जायदाद अर सामान बेच-बेचकै जिसकी जरूरत होवै थी बांड दिया करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","वे हरेक दिन एक मन होकै मन्दर म्ह कठ्ठे होवै थे, घर-घर रोट्टी तोड़दे होए खुशी अर मन की सीधाई तै खाणा खावै थे, ");
INSERT INTO bgc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","अर परमेसवर की जय-जयकार करै थे, अर सारे माणस उनतै राज्जी थे जो उद्धार पावैं थे, उन ताहीं प्रभु हरेक दिन उन म्ह मिला देवै था। ");
INSERT INTO bgc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","पतरस अर यूहन्ना दोफाहरै के तीन बजे पाच्छै प्रार्थना कै बखत मन्दर म्ह जाण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","अर माणस एक जन्म तै लंगड़े नै ल्यावै थे, जिस ताहीं वे हरेक दिन मन्दर कै बाहरणै पै जो सुन्दर नामक फाटक कुह्वावै सै, बिठा देवै थे, के वो मन्दर म्ह जाण आळा तै भीख माँग्गै। ");
INSERT INTO bgc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जिब उसनै पतरस अर यूहन्ना ताहीं मन्दर म्ह जान्दे देख्या, तो उनतै भीख माँगी। ");
INSERT INTO bgc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पतरस नै यूहन्ना कै गेल्या उसकी ओड़ गौर तै देखकै कह्या, “म्हारी ओड़ लखा!” ");
INSERT INTO bgc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","आखर वो उनतै कुछ पाण की आस राखते होए उनकी ओड़ लखाण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","फेर पतरस नै कह्या, “चाँदी अर सोन्ना तो मेरै धोरै सै न्ही, पर जो मेरै धोरै सै वो तन्नै दियुँ सूं, यीशु मसीह नासरी कै नाम तै उठ अर चाल-फिर।” ");
INSERT INTO bgc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","पतरस नै उसका सोळा हाथ पकड़कै उस ताहीं ठाया, अर जिब्बे उसके पायां अर टाखणयां म्ह ताकत आगी। ");
INSERT INTO bgc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","वो उछळते-कूदते खड्या होग्या अर चाल्लण-फिरण लाग्या, अर चाल्दा, अर कुद्दा, अर परमेसवर की जय-जयकार करदा होया उनकै गेल्या मन्दर म्ह गया। ");
INSERT INTO bgc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","सारे आदमियाँ नै उस ताहीं चाल्दे-फिरदे अर परमेसवर की जय-जयकार करदे होए देखकै, ");
INSERT INTO bgc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","उस ताहीं पिच्छाण लिया के यो वोए सै जो मन्दर कै “सुन्दर” नामक फाटक पै बैठकै भीख मांग्या करै था, अर उस घटना तै जो उसकै गेल्या होई थी वे घणे अचम्भित अर हैरान होए। ");
INSERT INTO bgc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","जिब वो पतरस अर यूहन्ना ताहीं पकड़े होए था, तो सारे माणस घणे हैरान होन्दे होए उस बराम्दा म्ह जो सुलैमान का कुह्वावै सै, उनकै धोरै भाज्जे आये। ");
INSERT INTO bgc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","न्यू देखकै पतरस नै माणसां तै कह्या, “हे इस्राएलियों, थम इस माणस पै क्यांतै हैरान होवो सो, म्हारी ओड़ क्यांतै इस ढाळ लखाओ सों, के मान्नो हमनै-ए अपणी सामर्थ या भगति तै इस ताहीं चाल्लण-फिरण जोग्गा बणा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम अर इसहाक अर याकूब के परमेसवर, म्हारे पूर्वजां के परमेसवर नै अपणे सेवक यीशु मसीह की महिमा करी, जिस ताहीं थमनै पकड़वा दिया, अर जिब राज्यपाल पिलातुस नै उस ताहीं छोड़ देण का विचार करया, फेर थमनै उसकै स्याम्ही उसका इन्कार करया। ");
INSERT INTO bgc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","थमनै उस धर्मी अर पवित्र का इन्कार करया, अर बिनती करी के एक खून्नी ताहीं थारे खात्तर छोड़ दिया जावै, ");
INSERT INTO bgc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","अर थमनै अनन्त जीवन के कर्ता ताहीं मार दिया, जिस ताहीं परमेसवर नै मरे होया म्ह तै जिन्दा करया, अर इस बात के हम गवाह सां। ");
INSERT INTO bgc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","मसीह यीशु कै नाम म्ह बिश्वास कै कारण इस माणस नै जिसनै थम जाणो सों, जिसनै थम इस बखत देक्खण लागरे सों, उस ताहीं ताकत दी सै, यो माणस यीशु के नाम म्ह अर मसीह यीशु पै बिश्वास के जरिये कती भला चंगा होया सै, जिसा के थम खुद देख सको सों।” ");
INSERT INTO bgc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“इब हे भाईयो, मन्नै बेरा सै के थमनै अर थारे अगुवां नै यो काम अज्ञानता म्ह करया, क्यूँके थम न्ही जाणो थे के वो मसीह सै। ");
INSERT INTO bgc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पर जिन बात्तां ताहीं परमेसवर नै सारे नबियाँ के मुँह तै पैहल्याए तै बता दिया था, के उसका मसीह दुख ठावैगा, उन ताहीं उसनै इस्से ढाळ पूरा करया। ");
INSERT INTO bgc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","इस करकै, पाप करणा छोड़ द्यो अर बोहड़ आओ के थारे पाप मिटाए जावै, जिसतै प्रभु के स्याम्ही तै सुख-चैन के दिन आवै, ");
INSERT INTO bgc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","अर वो यीशु ताहीं भेज्जै, जो थारे खात्तर पैहल्या तै ए मसीह ठहराया गया सै। ");
INSERT INTO bgc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","जरूरी सै के वो सुर्ग म्ह उस बखत ताहीं रहवै जिब ताहीं के वो सारी बात्तां का सुधार ना कर लेवै जिसका जिक्र पुराणे बखत तै परमेसवर नै अपणे पवित्र नबियाँ के मुँह तै करया सै। ");
INSERT INTO bgc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","जिस ढाळ के मूसा नबी नै कह्या, ‘परमेसवर थारे भाईयाँ म्ह तै थारे खात्तर मेरै जिसा एक नबी भेज्जैगा, जो किमे वो थारे तै कहवै उसकी सुणीयो।’ ");
INSERT INTO bgc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","पर हरेक माणस जो उस नबी की न्ही सुणै, आदमियाँ म्ह तै नाश करया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“अर शमूएल तै लेकै उसकै पाच्छै आळा ताहीं जितने नबी बोल्ले उन सारया नै इन दिनां का सन्देशा दिया सै। ");
INSERT INTO bgc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","थम सारे नबियाँ की ऊलाद अर उस करार के हिस्सेदार सो, जो परमेसवर नै थारे बाप-दाद्यां तै करया, जिब उसनै अब्राहम तै कह्या, ‘तेरी पीढ़ी के जरिये धरती के सारे खानदान आशीष पावैगें।’ ");
INSERT INTO bgc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","परमेसवर नै अपणे सेवक ताहीं मरे होया म्ह तै ठाकै सब तै पैहल्या थारे धोरै भेज्या, के थारे म्ह तै हरेक ताहीं उसकी बुराईयाँ तै पलटा कै आशीष देवै।” ");
INSERT INTO bgc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","जिब वे आदमियाँ तै न्यू कहण लागरे थे, तो याजक अर मन्दर के सरदार अर सदूकी दल के लोग उनपै चढ़ आये। ");
INSERT INTO bgc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","क्यूँके वे घणे खुन्दक म्ह थे के वे आदमियाँ ताहीं सिखावै थे, अर यीशु का उदाहरण दे-देकै प्रचार करै थे, के परमेसवर मुर्दां नै एक दिन जिन्दा करैगा जिसा उसनै यीशु ताहीं करया। ");
INSERT INTO bgc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","उननै उन ताहीं बन्दी बणाकै दुसरे दिन तक हवालात म्ह राख्या क्यूँके साँझ होग्यी थी। ");
INSERT INTO bgc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पर वचन के सुणण आळा म्ह तै घणाए नै बिश्वास करया, अर उनकी गिणती पाँच हजार माणसां कै करीबन होग्यी थी। ");
INSERT INTO bgc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","दुसरे दिन इसा होया के उनके सरदार, यहूदी अगुवें, शास्त्री ");
INSERT INTO bgc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","अर महायाजक हन्ना, कैफा, यूहन्ना, सिकन्दर अर जितने महायाजक के कुण्बे के थे, सारे यरुशलेम नगर म्ह एक जगहां कठ्ठे होए। ");
INSERT INTO bgc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","वे उन ताहीं बिचाळै खड्या करकै बुझ्झण लाग्गे के थमनै यो काम किसकै सामर्थ तै अर किसकै नाम तै करया सै। ");
INSERT INTO bgc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","फेर पतरस नै पवित्र आत्मा तै भरकै उनतै कह्या, ");
INSERT INTO bgc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“हे माणसां के सरदारो अर यहूदी अगुवों, इस कमजोर माणस गेल्या जो भलाई करी गयी सै, जै आज म्हारै तै उसकै बारै म्ह पूछताछ करी जावै सै, के वो किस ढाळ ठीक होया।” ");
INSERT INTO bgc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तो थम सारे अर सारे इस्राएली आदमी जाण लेवै के यीशु मसीह नासरी कै नाम तै जिस ताहीं थमनै क्रूस पै चढ़ाया, अर परमेसवर नै मरे होया म्ह तै जिन्दा करया, यो माणस थारे स्याम्ही भला-चंगा खड्या सै। ");
INSERT INTO bgc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","यीशु मसीह ए वो पत्थर सै जिस ताहीं थम राजमिस्त्रियाँ नै नकार दिया, अर वो सिरे का पत्थर होग्या। ");
INSERT INTO bgc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“यीशु के अलावा किसे दुसरे नाम म्ह उद्धार कोनी, क्यूँके सुर्ग कै तळै माणसां म्ह और कोए दुसरा नाम कोनी दिया गया, सिर्फ यीशु के जरिये हम उद्धार पा सकां सां।” ");
INSERT INTO bgc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जिब उननै पतरस अर यूहन्ना की हिम्मत देक्खी, अर न्यू बेरा लाग्या के ये अनपढ़ अर साधारण सा माणस सै, तो अचम्भा करया, फेर उन ताहीं पिच्छाण्या के ये यीशु कै गेल्या रहे सै। ");
INSERT INTO bgc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","उस माणस ताहीं जो ठीक होया था, पतरस अर यूहन्ना कै गेल्या खड़े देखकै, वे बिरोध म्ह किमे न्ही कह सके। ");
INSERT INTO bgc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","पर उन ताहीं यहूदी अगुवां की सभा तै बाहर जाण का हुकम देकै, वे आप्पस म्ह विचार करण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“हम इन माणसां कै गेल्या के करा? क्यूँके यरुशलेम नगर के सारे रहणीया नै बेरा पाटरया सै, के इनकै जरिये एक मशहुर चमत्कार दिखाया गया सै, अर हम उसकै बारै म्ह नाट न्ही सकदे। ");
INSERT INTO bgc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पर माणसां म्ह इस सुसमाचार का और घणा प्रसार ना हो।” ");
INSERT INTO bgc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","फेर उन ताहीं बुलाया अर चेतावनी देकै न्यू कह्या, “यीशु कै नाम पै ना तो वे चर्चा करै अर ना सिखाइयो।” ");
INSERT INTO bgc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पर पतरस अर यूहन्ना नै उन ताहीं जवाब दिया, “थमे न्याय करो, के यो परमेसवर कै धोरै भला सै के हम परमेसवर की बात तै बढ़कै थारी बात मान्नां। ");
INSERT INTO bgc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","क्यूँके यो तो म्हारै तै न्ही हो सकदा के जो हमनै देख्या अर सुण्या सै, वो न्ही कह्वां।” ");
INSERT INTO bgc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","फेर उननै उन ताहीं और धमकाकै छोड़ दिया, क्यूँके आदमियाँ कै कारण उन ताहीं सजा देण का कोए मौक्का न्ही मिल्या, इस करकै के जो घटना होई थी उसकै कारण सारे आदमी परमेसवर की बड़ाई करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","वो माणस जो अचम्भे के काम तै ठीक होया था, चाळीस बरस तै घणी उम्र का था। ");
INSERT INTO bgc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","वे छूट कै अपणे साथियाँ कै धोरै आए, अर जो किमे प्रधान याजकां अर यहूदी अगुवां नै उनतै कह्या था, उन ताहीं सुण्या दिया। ");
INSERT INTO bgc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","न्यू सुणकै उननै एक मन होकै ठाड्डू आवाज तै परमेसवर तै कह्या, “हे माल्लिक,” तू वोए सै जिसनै सुर्ग अर धरती अर समुन्दर अर जो किमे उन म्ह सै बणाया सै। ");
INSERT INTO bgc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तन्नै पवित्र आत्मा के जरिये अपणे सेवक म्हारे पूर्वज दाऊद के मुँह तै कह्या, “गैर यहूदियाँ नै रोळा क्यांतै मचाया? अर देश-देश के माणसां नै क्यांतै बेकार म्ह बात सोच्ची?” ");
INSERT INTO bgc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","प्रभु अर उसके अभिषिक्त के बिरोध म्ह धरती के राजा खड़े होए, अर हाकिम एक सेत्ती कठ्ठे होए। ");
INSERT INTO bgc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“क्यूँके साच्चए तेरे सेवक यीशु कै बिरोध म्ह, जिसका तन्नै अभिषेक करया, हेरोदेस अर पुन्तियुस पिलातुस भी गैर यहूदियाँ अर इस्राएलियाँ कै गेल्या इस नगर म्ह कठ्ठे होए, ");
INSERT INTO bgc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","के जो किमे पैहल्या तै तेरी सामर्थ अर बुद्धि तै ठहरा था वोए करै। ");
INSERT INTO bgc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","इब हे प्रभु, उनकी धमकियाँ नै सुण, अर अपणे दास्सां ताहीं यो वरदान दे के तेरा वचन बड़ी हिम्मत तै सुणावै। ");
INSERT INTO bgc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ठीक करण कै खात्तर तू अपणा हाथ बढ़ा के चमत्कार अर अनोक्खे काम तेरे पवित्र सेवक यीशु कै नाम तै करे जावै।” ");
INSERT INTO bgc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जिब उननै प्रार्थना कर ली, तो वा जगहां जित्त वे कठ्ठे थे काम्बगी, अर वे सारे पवित्र आत्मा तै भरगे, अर परमेसवर का वचन हिम्मत तै सुणान्दे रहे। ");
INSERT INTO bgc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","बिश्वास करण आळा का टोळ एक चित्त अर एक मन का था, उरै ताहीं के कोए भी अपणी सम्पत्ति अपणी न्ही कहवै था, पर सारा किमे साझ्झै म्ह था। ");
INSERT INTO bgc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","प्रेरित बड़ी सामर्थ तै प्रभु यीशु के जिन्दा होण की गवाही देन्दे रहे, अर उन सारया पै घणा अनुग्रह था। ");
INSERT INTO bgc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","अर उन बिश्वासियाँ म्ह कोए भी गरीब कोनी था, क्यूँके जिनकै धोरै धरती या घर थे, वे उननै बेच-बेचकै, बिकी होई चिज्जां का दाम ल्यावै थे, अर उस ताहीं प्रेरितां के पायां म्ह धरै थे। ");
INSERT INTO bgc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","अर जिसी जिसकी जरूरत होवै थी, उसकै मुताबिक हरेक ताहीं बांड दिया करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","यूसुफ नाम का साइप्रस टापू का एक लेवी था जिसका नाम प्रेरितां नै बरनबास (यानिके उत्साहित करण आळा) धरया था। ");
INSERT INTO bgc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","उसकी किमे धरती थी, जिस ताहीं उसनै बेच्या, अर दाम के रपिये प्रेरितां के पायां म्ह धर दिए। ");
INSERT INTO bgc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नाम का एक माणस अर उसकी घरआळी सफीरा नै अपणी कुछ जमीन बेच्ची। ");
INSERT INTO bgc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","अर उसकै दाम म्ह तै कुछ अपणे खात्तर राख लिया, अर या बात उसकी घरआळी भी जाणै थी, उसका एक हिस्सा ल्याकै प्रेरितां के पायां म्ह धर दिया। ");
INSERT INTO bgc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","पतरस बोल्या, “हे हनन्याह! शैतान नै तेरे मन म्ह या बात क्यांतै घाल्ली के तू पवित्र आत्मा तै झूठ बोल्लै, अर जमीन के दाम म्ह तै किमे राख लेवै? ");
INSERT INTO bgc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","के बेचण तै पैहल्या वा जमीन तेरी कोनी थी? अर जिब बिकगी तो उस धन पै तेरा हक कोनी था? तन्नै या बात अपणे मन म्ह क्यांतै सोच्ची? तन्नै माणसां तै न्ही, पर परमेसवर तै झूठ बोल्या सै।” ");
INSERT INTO bgc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","या बात सुणदे हनन्याह जमीन पै गिर पड्या अर जी लिकड़ग्या, सारे सुणण आळे घणे डरगे। ");
INSERT INTO bgc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","फेर जवानां नै उठकै उसकी लाश ताहीं कपड़े म्ह लपेटा अर बाहरणै ले जाकै गाड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","करीबन तीन घंटा कै पाच्छै उसकी घरआळी, जिसनै बेराए कोनी था जो किमे होया था, भीत्त्तर आई। ");
INSERT INTO bgc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","फेर पतरस नै उसतै कह्या, “मन्नै बता के थम दोनुआं नै वा जमीन इतनै म्ह बेच्ची थी?” वा बोल्ली, “हाँ, इतनै ए म्ह।” ");
INSERT INTO bgc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पतरस नै उसतै कह्या, “या के बात सै के थम दोनुआं नै प्रभु की आत्मा ताहीं परखण खात्तर एक्का करया? लखा, तेरे धणी नै गाड्डण आळे बाहरणै ए खड़े सै, अर तन्नै भी बाहरणै ले जावैंगे।” ");
INSERT INTO bgc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","फेर वा जिब्बे उसकै पायां म्ह गिर पड़ी, अर जी लिकड़ग्या, अर जवानां नै भीत्त्तर आकै उस ताहीं मरया पाया, अर बाहरणै ले जाकै उसकै धणी कै धोरै ए उस ताहीं भी गाड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","यरुशलेम की सारी कलीसिया अर इन बात्तां के सारे सुणनियें भोत घणे डरगे। ");
INSERT INTO bgc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","प्रेरितां के जरिये घणे चमत्कार अर अनोक्खे काम आदमियाँ कै बिचाळै दिखाए जावै थे, अर वे सारे एक चित्त होकै सुलैमान के बरामदे म्ह कठ्ठे होया करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","पर औरां म्ह तै किसे और की या हिम्मत कोनी होवै थी के उन म्ह जा मिलै, फेर भी आदमी उनकी बड़ाई करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","प्रभु म्ह बिश्वास करण आळी की गिणती बढ़ती गई भोत घणे बिश्वासी प्रभु म्ह आ मिले, लोग-लुगाईयाँ का एक भोत बड़ा टोळ बणग्या। ");
INSERT INTO bgc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","जो प्रेरित करण लागरे थे, उसकी बजह तै माणस, बिमारां ताहीं सड़कां पै ल्या-ल्याकै, खाट-खटोल्यां पै लिटा देवैं थे, के जिब पतरस आवै, तो उसकी छाया-ए उन म्ह तै किसे पै पड़ जावै। ");
INSERT INTO bgc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरुशलेम नगर कै लोवै-धोवै के नगरां तै भी घणे माणस बिमारां अर भुंडी ओपरी आत्मायाँ के सताए होया ताहीं चेल्यां कै धोरै ल्या-ल्याकै, कठ्ठे होवै थे, अर सारे ठीक कर दिए जावै थे। ");
INSERT INTO bgc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","फेर महायाजक अर उसके सारे मित्तर जो सदूकियाँ के पंथ के थे, प्रेरितां तै जळण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","अर प्रेरितां ताहीं पकड़कै जेळ म्ह बन्द कर दिया। ");
INSERT INTO bgc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पर रात नै प्रभु के एक सुर्गदूत नै जेळ के किवाड़ खोल कै उन ताहीं बाहरणै ल्याकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जाओ, मन्दर म्ह खड़े होकै अनन्त जीवन की सारी बात आदमियाँ ताहीं सुणाओ।” ");
INSERT INTO bgc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","वे न्यू सुणकै सबेरा होन्दे मन्दर म्ह जाकै उपदेश देण लाग्गे। फेर महायाजक अर उसके मित्तरां नै आकै यहूदी अगुवां की सभा अर इस्राएलियाँ के सारे बुजुर्गां ताहीं कठ्ठे करया, अर जेळ म्ह कहवां भेज्या के उन ताहीं ल्याओ। ");
INSERT INTO bgc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","पर मन्दर के पैहरेदारां नै उड़ै पोहचकै उन ताहीं जेळ म्ह कोन्या पाया, अर बोहड़कै संदेशां दिया, ");
INSERT INTO bgc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“हमनै जेळ ताहीं घणी चौकसी तै बन्द कर राख्या था, अर पैहरेदारां ताहीं बाहरणै दरवाज्यां पै खड़े पायां, पर जिब खोल्या, तो भीत्त्तर कोए ना मिल्या।” ");
INSERT INTO bgc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जिब मन्दर के सरदार अर प्रधान याजकां नै या खबर सुणी, तो वे घबरागे थे, अर वे यो विचार करण लाग्गे के इन बात्तां का नतिज्जा के होगा! ");
INSERT INTO bgc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","इतनै म्ह किसे नै आकै उन ताहीं बताया, “देक्खो, जिन ताहीं थमनै जेळ म्ह बन्द कर राख्या था, वे माणस मन्दर म्ह खड़े होकै आदमियाँ नै उपदेश देण लागरे सै।” ");
INSERT INTO bgc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","27","फेर सरदार, पैहरेदारां कै गेल्या ओड़ै जाकै, प्रेरितां ताहीं यहूदी अगुवां की सभा कै स्याम्ही लीआया, पर हंगे तै न्ही, क्यूँके वे आदमियाँ तै डरै थे के कदे म्हारै पै पत्थर ना बरसा देवैं। फेर महायाजक नै उनतै बुझ्झया, ");
INSERT INTO bgc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“के हमनै थारे ताहीं चिताकै हुकम न्ही दिया था के थम इस नाम तै उपदेश ना दियो? फेरभी, थमनै सारे यरुशलेम नगर ताहीं अपणे उपदेश तै भर दिया सै अर उस माणस की हत्या का कसूर थम म्हारै पै लगाणा चाहो सो।” ");
INSERT INTO bgc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","फेर पतरस अर दुसरे प्रेरितां नै जवाब दिया, “माणसां के हुकम तै बढ़कै परमेसवर के हुकम का पालन करणा ए म्हारा फर्ज सै। ");
INSERT INTO bgc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","म्हारै पूर्वजां कै परमेसवर नै यीशु ताहीं मुर्दां म्ह तै जिन्दा करया, जिस ताहीं थमनै क्रूस पै लटकाकै मार दिया था। ");
INSERT INTO bgc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","उस्से ताहीं परमेसवर नै प्रभु अर उद्धारकर्ता ठैहराया अर परमेसवर नै मसीह यीशु ताहीं अपणे सोळे हाथ कान्ही बैठाया, ताके इस्राएल के माणस पाप करणा छोड़ दे, अर अपणे पापां खात्तर उन ताहीं माफी मिल सकै। ");
INSERT INTO bgc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","हम इन बात्तां के गवाह सां अर उस्से तरियां पवित्र आत्मा भी, जिस ताहीं परमेसवर नै उन ताहीं दिया सै जो उनका हुकम मान्नै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","यहूदी अगुवां की सभा के सारे माणस या बात सुणकै जळगे, अर प्रेरितां ताहीं मारणा चाह्या। ");
INSERT INTO bgc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पर गमलीएल नामक एक फरीसी नै जो शास्त्री अर सारे आदमियाँ म्ह आदर-मान राक्खै था, यहूदी अगुवां की सभा म्ह खड़े होकै प्रेरितां ताहीं थोड़ी देर खात्तर बाहरणै ले जाण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","फेर वो बोल्या, “हे इस्राएलियों, थम जो किमे इन माणसां गैल करणा चाहवो सो, सोच-समझकै करियो। ");
INSERT INTO bgc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","इन दिनां तै पैहल्या थियूदास भी दावा करै था के मै भी किमे सूं, अर तकरीबन चार सौ माणस उसकै चेल्लें बणगे, पर वो मारया गया, अर उस ताहीं मानण आळे सब लोग बिखरगे अर उनका नामो-निशान भी कोनी रह्या। ");
INSERT INTO bgc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","उसकै पाच्छै नाम लिखाई के दिनां म्ह गलीलवासी यहूदा आया, अर कई आदमी अपणी ओड़ कर लिये, वो भी मर ग्या, अर जितने आदमी उसनै मान्नै थे, सारे तित्तर-बितर होग्ये। ");
INSERT INTO bgc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ज्यांतै मै थारे तै कहूँ सूं, इन माणसां तै दूर ए रहो अर इनतै किमे काम ना राक्खो, क्यूँके जै यो धर्म या काम माणसां की ओड़ तै हो फेर तो मिट जावैगा। ");
INSERT INTO bgc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पर जै परमेसवर की ओड़ तै सै, तो थम उन ताहीं कदे भी न्ही मिटा सकदे। कदे इसा ना हो के थम परमेसवर तै भी लड़णआळे ठहरो।” फेर उननै उसकी बात मान ली। ");
INSERT INTO bgc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","अर प्रेरितां ताहीं बुलाकै छितवाया, अर यो हुकम देकै छोड़ दिया के यीशु कै नाम तै दुबारा कोए बात ना करणा। ");
INSERT INTO bgc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","वे इस बात तै राज्जी होकै यहूदी अगुवां की सभा कै स्याम्ही तै चले गये, के हम यीशु कै नाम कै खात्तर बेईज्जत होण कै जोग्गे तो ठहरे। ");
INSERT INTO bgc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","वे हरेक दिन मन्दर म्ह अर घर-घर म्ह उपदेश करण तै, अर इस बात का सुसमाचार सुणाण तै के यीशु ए मसीह सै न्ही रुके। ");
INSERT INTO bgc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","उन दिनां म्ह जिब चेल्यां की गिणती घणी बधण लाग्गी, फेर यूनानी भाषा बोल्लण आळे यहूदी चेल्लें इब्रानी भाषा बोल्लण आळे यहूदी चेल्यां पै बिरड़ाण लाग्गे, के हरेक दिन पईसा अर खाणे के मामलै म्ह म्हारी बिधवायाँ की सुध कोनी ली जान्दी। ");
INSERT INTO bgc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","फेर उन बारहां चेल्यां नै उन बिश्वासियाँ ताहीं जो यरुशलेम म्ह थे, अपणे धोरै बुलाकै कह्या, “यो ठीक कोनी के हम परमेसवर का वचन छोड़कै खिलाण-पिलाण की सेवा म्ह रह्वां। ");
INSERT INTO bgc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","इस करकै, हे बिश्वासी भाईयो, अपणे म्ह तै सात बढ़िया नाम्मी माणसां ताहीं जो पवित्र आत्मा अर बुद्धि तै भरे हो, जिनके बारें म्ह सब नै बेरा हो, छाँट ल्यो, के हम उननै इस काम पै ला देवां। ");
INSERT INTO bgc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","पर हम तो प्रार्थना म्ह अर वचन के प्रचार अर शिक्षा देण की सेवा म्ह लाग्गे रहवांगें।” ");
INSERT INTO bgc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","या बात सारे टोळ नै आच्छी लाग्गी, अर उननै स्तिफनुस नामक एक माणस ताहीं जो बिश्वास अर पवित्र आत्मा तै भरया था, अर फिलिप्पुस, अर प्रुखुरुस, अर नीकानोर, अर तीमोन, अर परमिनास, अर अन्ताकियावासी नीकुलाउस ताहीं जो यहूदी पंथ म्ह आ ग्या था, छाँट लिया। ");
INSERT INTO bgc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","इन ताहीं प्रेरितां कै स्याम्ही ल्याए अर उननै प्रार्थना करकै उनपै हाथ धरे, ताके वे उस काम नै करै। ");
INSERT INTO bgc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","परमेसवर का वचन फैलदा गया अर यरुशलेम नगर म्ह चेल्यां की गिणती घणी बढ़दी गई, अर भोत सारे यहूदी याजक भी प्रभु यीशु के सुसमाचार पै बिश्वास करकै मानणआळे होगे। ");
INSERT INTO bgc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस अनुग्रह अर सामर्थ तै भरया-पूरा होकै आदमियाँ म्ह बड़े-बड़े अनोक्खे काम अर चमत्कार दिखाया करै था। ");
INSERT INTO bgc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","फेर वो आराधनालय म्ह तै जो लिबिरतिनों की कुह्वावै थी, अर कुरेनी अर सिकन्दरिया अर किलिकिया अर आसिया परदेस के आदमियाँ म्ह तै कई माणस उठकै स्तिफनुस तै बहसण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","पर उस ज्ञान अर उस पवित्र आत्मा का जिसतै वो बात करै था, वे सामना न्ही कर सके। ");
INSERT INTO bgc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","इसपै उननै कई आदमियाँ ताहीं उकसाया जो कहण लाग्गे, “हमनै इस ताहीं मूसा नबी अर परमेसवर कै बिरोध म्ह बुराई की बात कहन्दे होए सुण्या सै।” ");
INSERT INTO bgc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","उननै स्तिफनुस के बिरुध्द माणसां, यहूदी अगुवां अर शास्त्रियाँ ताहीं उकसाया अर आकै उस ताहीं पकड़कै यहूदी अगुवां की सभा कै स्याम्ही ले गये। ");
INSERT INTO bgc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","अर उननै झूठ्ठे गवाह खड़े करे, जिननै स्तिफनुस पै यो इलजाम लगाकै, कह्या, “यो माणस इस पवित्र जगहां अर मूसा के नियम-कायदे कै बिरोध म्ह बुराई करणा न्ही छोड़दा। ");
INSERT INTO bgc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","क्यूँके हमनै उस ताहीं न्यू कहन्दे सुण्या सै के योए यीशु नासरी इस मन्दर नै गेर देवैगा, अर उन रिवाज्जां नै बदल देवैगा जो मूसा नबी नै म्हारै ताहीं सौंपी सै।” ");
INSERT INTO bgc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","फेर सारे आदमियाँ नै जो यहूदी अगुवां की सभा म्ह बेठ्ठे थे, उसपै निगांह गड़ाई तो उसका मुँह सुर्गदूत जिसा दिख्या। ");
INSERT INTO bgc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","फेर महायाजक नै स्तिफनुस तै बुझ्झया, “के यो इलजाम सच सै?” ");
INSERT INTO bgc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","उसनै कह्या, “हे भाईयो, अर बुजुर्गों सुणो। म्हारा पूर्वज अब्राहम हारान नगर म्ह बसण तै पैहल्या जिब वो मेसोपोटामिया परदेस म्ह था, तो तेजोमय परमेसवर नै उस ताहीं दर्शन दिया, ");
INSERT INTO bgc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","अर उसतै बोल्या, ‘तू अपणे देश अर अपणे कुण्बे म्ह तै लिकड़कै उस देश म्ह जा, जिस ताहीं मै तन्नै दिखाऊँगा।’” ");
INSERT INTO bgc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","फेर अब्राहम कसदियो के देश तै लिकड़कै हारान नगर म्ह जा बस्या। उसकै पिता की मौत कै पाच्छै परमेसवर नै उस ताहीं ओड़ै तै इस देश म्ह ल्याकै बसाया जिसम्ह इब हम बसां सां, ");
INSERT INTO bgc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","अर उस ताहीं कुछ भी विरासत न्ही दी, बल्के पैर धरण भर की भी उस म्ह जगहां कोनी देई, पर परमेसवर नै वादा करया, के मै यो देश तेरे अर तेरे बाद तेरे वंश कै हाथ कर दियुँगा, हालाकि उस बखत उसकै कोए बेट्टा कोनी था। ");
INSERT INTO bgc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","अर परमेसवर नै यो भी कह्या, “वे लोग उननै गुलाम बणा लेंगे, अर चार सौ साल ताहीं उनकै गैल भुंडा बरताव करैगें।” ");
INSERT INTO bgc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","फेर परमेसवर नै यो भी कह्या, “के जिस जात के वे गुलाम होवैंगें, उस ताहीं मै सजा देऊँगा, अर इसकै बाद वे लिकड़कै इस्से देश म्ह मेरी भगति करैंगें।” ");
INSERT INTO bgc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","अर परमेसवर नै अब्राहम कै गैल खतने का करार करया, जिब अब्राहम के बेट्टे इसहाक का जन्म होया, तो आंठ्वै दिन उसका खतना करया गया, अर इसहाक तै याकूब अर याकूब तै बारहां कुलपति पैदा होए। ");
INSERT INTO bgc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“कुलपतियाँ नै अपणे भाई यूसुफ तै जळण करकै उस ताहीं मिस्र देश जाण आळा ताहीं बेच्या। पर परमेसवर उसकै गेल्या था, ");
INSERT INTO bgc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","अर परमेसवर नै यूसुफ ताहीं उसके सारे क्लेशां तै छुड़ाकै मिस्र देश कै राजा फिरौन की निगांह म्ह अनुग्रह अर बुद्धि दी, अर फिरौन नै उस ताहीं मिस्र देश पै अर अपणे सारे घर पै हाकिम बणा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“जिब यूसुफ मिस्र देश का हाकिम था, तो सारे मिस्र देश अर कनान देश म्ह अकाळ पड़ग्या, जिसतै हरेक जगहां हाहाकार माचग्या, अर म्हारे पूर्वजां ताहीं नाज कोनी मिलै था। ");
INSERT INTO bgc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","पर याकूब नै न्यू सुणकै के मिस्र देश म्ह नाज सै, म्हारे पूर्वजां ताहीं नाज मोल लेण खात्तर पैहली बार भेज्या। ");
INSERT INTO bgc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","जिब वे दुसरी बार नाज मोल लेण खात्तर गये, तो यूसुफ नै खुद ताहीं अपणे भाईयाँ पै जाहिर करया, अर यूसुफ के परिवार के बारें म्ह फिरौन नै बेरा पाटग्या। ");
INSERT INTO bgc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","फेर यूसुफ नै अपणे बाप याकूब अर अपणे साबतै कुण्बे ताहीं, जो पचत्तर माणस थे, बुलवा भेज्या। ");
INSERT INTO bgc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","फेर याकूब मिस्र देश गया, अर कुछ साल्लां बाद ओड़ैए वो अर म्हारे पूर्वज मरग्ये। ");
INSERT INTO bgc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","उनकी लाश शकेम नगर म्ह पहुँचाकै उस कब्र म्ह धरी गई, जिस ताहीं अब्राहम नै चाँदी देकै शकेम नगर म्ह हमोर की ऊलाद तै मोल लिया था।” ");
INSERT INTO bgc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“पर जिब उस वादा के पूरे होण का बखत लोवै आया जो परमेसवर नै अब्राहम तै करया था, तो मिस्र देश म्ह वे आदमी बढ़ग्ये अर घणे होग्ये। ");
INSERT INTO bgc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","फेर मिस्र देश म्ह दुसरा राजा होया जो यूसुफ ताहीं कोनी जाणै था। ");
INSERT INTO bgc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","उसनै म्हारे जात्ति भाईयाँ तै हेरा-फेरी करकै म्हारे पूर्वजां कै गेल्या उरै ताहीं भुंडा बीवार करया, के अपणे माँ-बाप नै अपणे बाळकां ताहीं बगाणे पड़गे, के एक भी बाळक जिन्दा ना रहवैं। ");
INSERT INTO bgc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“उस बखत मूसा नबी पैदा होया। वो परमेसवर की निगांह म्ह घणा सुथरा था। वो तीन महिन्ने ताहीं अपणे बाप कै घरां लुह्को कै पाळया गया। ");
INSERT INTO bgc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","जिब उसके परिवार आळे उस ताहीं और न्ही लह्को सके, तो उननै मूसा ताहीं छोड़णा पड्या, फेर फिरौन की बेट्टी नै उस ताहीं ठा लिया, अर अपणा बेट्टा करकै पाळया। ");
INSERT INTO bgc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मूसा नबी नै मिस्र देश की सारी विद्या पढ़ाई गई, अर वो बोलण म्ह अर काम करण म्ह, दोनुआ म्ह सामर्थी था।” ");
INSERT INTO bgc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“जिब मूसा नबी चाळीस साल का होया, तो उसकै मन म्ह आया के मै अपणे इस्राएली भाईयाँ तै मिलूं। ");
INSERT INTO bgc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","उसनै एक इस्राएली माणस पै जुल्म होन्दे देखकै उस ताहीं बचाया, अर उस मिस्री आदमी ताहीं मारकै सताए होए का बदला लिया। ");
INSERT INTO bgc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","मूसा नै सोच्या के उसके भाई-बन्धु जाण जावैंगे के उन ताहीं गुलामी तै छुटकारा दुआण खात्तर परमेसवर उसका इस्तमाल करण लाग रह्या सै, पर वे इस ताहीं समझ न्ही पाये। ");
INSERT INTO bgc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","दुसरे दिन जिब वे आप्पस म्ह लड़ै थे, तो वो उड़ै तै आण लिकड़या, अर न्यू कहकै उननै मेल करण कै खात्तर समझाया, ‘हे भले माणसों, थम तो भाई-भाई सो, एक-दुसरे पै क्यांतै जुल्म करो सो?’” ");
INSERT INTO bgc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“पर जो अपणे पड़ोसी पै जुल्म करै था, उसनै उस ताहीं न्यू कहकै धक्का दिया, ‘तेरे ताहीं किसनै म्हारै पै हाकिम अर न्यायाधीश ठहराया सै? ");
INSERT INTO bgc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","के जिस ढाळ तै तन्नै काल उस मिस्री आदमी ताहीं मार दिया मन्नै भी मार देणा चाहवै सै?’ ");
INSERT INTO bgc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","या बात सुणकै मूसा नबी डरकै भाज्या अर मिधान देश म्ह परदेशी होकै रहण लाग्या, अर ओड़ै उसके दो बेट्टे पैदा होए।” ");
INSERT INTO bgc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“जिब मूसा ताहीं ओड़ै रहन्दे पूरे चाळीस साल बीतगे, तो परमेसवर नै एक सुर्गदूत के रूप म्ह सीनै पहाड़ के बण म्ह उस ताहीं बळदी होई झाड़ी की ज्वाला म्ह दर्शन दिया। ");
INSERT INTO bgc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मूसा नबी नै यो बळदी होई झाड़ी का दर्शन देखकै हैरानी होई, अर जिब देखण खात्तर लोवै गया, तो प्रभु की या वाणी सुणाई दी, ");
INSERT INTO bgc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘मै तेरे पूर्वज, अब्राहम, इसहाक, याकूब का परमेसवर सूं,’ फेर मूसा नबी डर के मारे काम्बग्या, उरै ताहीं के उसकी देखण की हिम्मत भी कोनी होई।” ");
INSERT INTO bgc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“फेर प्रभु नै मूसा नबी तै कह्या, ‘अपणे पायां तै जूत्ती उत्तार ले, क्यूँके जिस जगहां तू खड्या सै, वा पवित्र धरती सै। ");
INSERT INTO bgc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मन्नै साच्ये अपणे आदमियाँ की जो मिस्र देश म्ह सै, भुन्ड़ी हालत देक्खी सै, अर उनकी आह अर उनका रोणा सुण्या सै, ज्यांतै उन ताहीं छुड़ाण कै खात्तर उतरया सूं। इब आ, मै तन्नै मिस्र देश भेज्जूँगा।’” ");
INSERT INTO bgc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“जिस मूसा नबी ताहीं उननै न्यू कहकै नकारा दिया था, ‘तेरे ताहीं किसनै म्हारै पै हाकिम अर न्यायाधीश ठहराया सै?’ उस्से ताहीं परमेसवर नै हाकिम अर छुड़ाण आळा ठहराकै उस सुर्गदूत के जरिये जिसनै उस ताहीं झाड़ी म्ह दर्शन दिया था, भेज्या। ");
INSERT INTO bgc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","योए माणस मिस्र देश अर लाल समुन्दर अर जंगळ म्ह चाळीस साल ताहीं अनोक्खे काम अर चमत्कार दिखा-दिखाकै उन ताहीं लिकाड़ ल्याया।” ");
INSERT INTO bgc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","यो वोए मूसा नबी सै, जिसनै इस्राएल के माणसां तै कह्या, “परमेसवर थारे भाईयाँ म्ह तै थारे खात्तर मेरै जिसा एक नबी ठावैगा। ");
INSERT INTO bgc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","यो वोए सै, जिसनै जंगळ म्ह इस्राएली मण्डळी कै बिचाळै उस सुर्गदूत के साथ सीनै पहाड़ पै उसतै बात करी, अर म्हारे पूर्वजां कै गेल्या था, उस्से ताहीं जिन्दा वचन मिल्या ताके म्हारै तक पोहोचावै।” ");
INSERT INTO bgc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पर म्हारे पूर्वजां नै उसकी मानणी कोनी चाह्यी, बल्के उस ताहीं हटाकै अपणे मन मिस्र देश की ओड़ पलटे, ");
INSERT INTO bgc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","अर मूसा नबी कै भाई हारुन तै, कह्या, म्हारै खात्तर इसा देवता बणा, जो म्हारै आग्गै-आग्गै चाल्लै, क्यूँके यो मूसा नबी जो हमनै मिस्र देश तै लिकाड़ ल्याया, हमनै न्ही बेरा के उसकै के होया? ");
INSERT INTO bgc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","उन दिनां म्ह उननै एक बाछड़े की मूर्ति बणाकै उसकै आग्गै बलि चढ़ाई, अर अपणे हाथ्थां तै बणाई होई मूर्ति तै मग्न होण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","इस खात्तर परमेसवर नै मुँह मोड़कै उन ताहीं छोड़ दिया, के अकास के सूरज चाँद सितारां ताहीं परमेसवर मानकै पुजै, जिसा नबियाँ की किताब म्ह लिख्या सै, “हे इस्राएल के घराने, के थम जंगळ म्ह चाळीस साल ताहीं पशुबलि अर अन्नबलि मेरै ताहीं ए चढ़ान्दे रहे?” ");
INSERT INTO bgc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","“थम उस तम्बू ताहीं जिस म्ह मोलेक देवता की मूर्ति अर अपणे रिफान देवता, के तारे नै लिये फिरे, यानिके उन मूरतां ताहीं जिन ताहीं थमनै आराधना करण कै खात्तर बणाया था। इस करकै मै थारे ताहीं बेबीलोन देश तै परली ओड़ ले जाकै बसाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“मिलापआळे तम्बू की जंगल-बियाबान म्ह म्हारै पूर्वजां कै बिचाळै था, जिसा उसनै ठहराया जिसनै मूसा नबी तै कह्या, ‘जो रूप तन्नै देख्या सै, उसकै मुताबिक इसनै बणा।’ ");
INSERT INTO bgc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","उस्से तम्बू नै म्हारे पूर्वज पाच्छले बखत तै पाकै यहोशू कै गेल्या उरै लियाये, जिस बखत के उननै उन दुसरी जात्तां पै हक पाया, जिन ताहीं परमेसवर नै म्हारै पूर्वजां कै स्याम्ही तै लिकाड़ दिया, अर वो तम्बू राजा दाऊद के बखत ताहीं रहया। ");
INSERT INTO bgc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊद पै परमेसवर नै अनुग्रह करया, राजा दाऊद नै याकूब के परमेसवर कै खात्तर रहण की जगहां बणाण की बिनती करी। ");
INSERT INTO bgc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पर उसके बेट्टे राजा सुलैमान नै उसकै खात्तर घर बणाया।” ");
INSERT INTO bgc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","पर परमप्रधान हाथ के बणाए होए घरां म्ह कोनी रहन्दा, जिसा के यशायाह नबी की किताब म्ह कह्या, ");
INSERT INTO bgc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“परमेसवर कहवै सै, सुर्ग मेरा सिंहासन अर धरती मेरी पायां तळै की पीढ़ी सै, मेरै खात्तर थम किस ढाळ का घर बणाओगे? अर मेरै आराम कि कौण-सी जगहां होवैगी?” ");
INSERT INTO bgc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","के ये सारी चीज मेरे जरिये न्ही बणाई गई सै? ");
INSERT INTO bgc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“हे जिद्दी, अर मन अर कान के खतनारहित आदमियो, थम सारी हाण पवित्र आत्मा का बिरोध करो सो। जिसा थारे पूर्वज करै थे, उस्से तरियां ए थम भी करो सो। ");
INSERT INTO bgc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","के कोए इसा भी नबी था, जिस ताहीं थारे पूर्वजां नै न्ही सताया हो? उननै तो उस ताहीं भी मार दिया, जिननै भोत पैहले ए तै उस मसीहा के आण की मुनाद्दी कर दी थी, जिस ताहीं इब थमनै धोक्खे तै पकड़वा दिया अर मार दिया। ");
INSERT INTO bgc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","थमनै सुर्गदूत्तां कै जरिये ठहराये होए नियम-कायदे तो पाए, पर उसका पालन कोनी करया।” ");
INSERT INTO bgc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ये बात सुणकै यहूदी अगुवें छो म्ह भरगे अर स्तिफनुस पै दाँत पिस्सण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पर उसनै पवित्र आत्मा तै पूरी तरियां भरकै सुर्ग की ओड़ देख्या अर परमेसवर की महिमा अर यीशु ताहीं परमेसवर के सोळी ओड़ खड्या देखकै ");
INSERT INTO bgc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","कह्या, “देक्खो, मै सुर्ग नै खुल्या होया, अर माणस के बेट्टे ताहीं परमेसवर कै सोळी ओड़ खड्या देखु सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","फेर ये बात सुणते ए सुणण आळा नै चीखते होए अपणे कान्ना पै हाथ रख लिये, अर वे छो म्ह एक साथ उसपै टूट पड़े, ");
INSERT INTO bgc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","अर स्तिफनुस ताहीं यरुशलेम नगर कै बाहरणै लिकाड़कै उसपै पत्थर बरसाण लाग्गे। गवाहां नै अपणे लत्ते शाऊल नामक एक जवान कै पायां कै धोरै उतारकै धर दिए। ");
INSERT INTO bgc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","वे स्तिफनुस पै पत्थर बरसान्दे रहे, अर वो न्यू कहकै प्रार्थना करदा रह्या, “हे प्रभु यीशु, मेरी आत्मा ताहीं अपणाले।” ");
INSERT INTO bgc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","फेर गोड्डे टेककै ठाड्डू आवाज म्ह रुक्का मारया, “हे प्रभु, यो पाप उनपै मतना ला।” अर न्यू कह कै उसनै अपणे प्राण दे दिए। ");
INSERT INTO bgc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","शाऊल उसकै मारण म्ह सहमत था। उस्से दिन यरुशलेम नगर की कलीसिया म्ह घणा दंगा शरु होग्या अर प्रेरितां नै छोड़कै सारे के सारे यहूदिया अर सामरिया परदेस म्ह खिंड-मिंड होग्ये। ");
INSERT INTO bgc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","कुछ परमेसवर भगतां नै स्तिफनुस ताहीं कब्र म्ह धरया अर उसकै खात्तर घणा बिलाप करया। ");
INSERT INTO bgc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","शाऊल कलीसिया नै सताण लागरया था, अर घर-घर म्ह बड़कै माणसां अर लुगाईयाँ ताहीं घिसड़ा-घिसड़ा कै जेळ म्ह गेरै था। ");
INSERT INTO bgc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जो बिश्वासी खिंड-मिन्ड होए थे, वे सुसमाचार सुणान्दे होए हान्डे, ");
INSERT INTO bgc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","अर फिलिप्पुस सामरिया परदेस के एक नगर म्ह जाकै माणसां म्ह मसीह का प्रचार करण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","जो बात फिलिप्पुस नै कही उन ताहीं आदमियाँ नै सुणकै अर जो चमत्कार वो दिखावै था उन ताहीं देख देखकै, एक चित्त होकै मन लगाया। ");
INSERT INTO bgc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","क्यूँके घणखरयां म्ह तै भुंडी ओपरी आत्मा ठाड्डू आवाज म्ह किल्की मारदी होई लिकड़ग्यी, अर घणखरे लकवे के बीमार अर लंगड़े भी ठीक करे गये, ");
INSERT INTO bgc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","अर उस नगर म्ह घणी खुशी मनाई गई। ");
INSERT INTO bgc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","उस नगर म्ह शमौन नाम का एक माणस था, जो जादू-टोणा करकै सामरिया परदेस के आदमियाँ नै हैरान करदा अर खुद ताहीं एक बड्ड़ा माणस बतावै था। ");
INSERT INTO bgc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","छोट्या तै लेकै बड्डयाँ ताहीं सारे उसका आदर करकै कहवै थे, “यो माणस परमेसवर की वा शक्ति सै, जो महान् कुह्वावै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","उसनै घणे दिनां तै उन ताहीं अपणे जादू के काम्मां तै हैरान कर राख्या था, ज्यांतै वे उसकी घणी मान्नै थे। ");
INSERT INTO bgc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पर जिब माणसां नै परमेसवर के राज्य अर यीशु मसीह के नाम का सुसमाचार, फिलिप्पुस के संदेश म्ह सुण्या, तो सारे माणसां अर लुगाईयाँ नै बिश्वास करया अर सब नै बपतिस्मा ले लिया। ");
INSERT INTO bgc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","फेर शमौन नै खुद भी फिलिप्पुस के संदेश का बिश्वास करया अर बपतिस्मा लेकै उसकै गेल्या रहण लाग्या। वो चमत्कार अर बड़े-बड़े सामर्थ के काम होन्दे देखकै हैरान होवै था। ");
INSERT INTO bgc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जिब प्रेरितां नै जो यरुशलेम नगर म्ह थे, सुण्या के सामरिया परदेस के माणसां नै परमेसवर का वचन मान लिया सै तो पतरस अर यूहन्ना ताहीं उनकै धोरै भेज्या। ");
INSERT INTO bgc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","उननै ओड़ै जाकै उनकै खात्तर प्रार्थना करी के पवित्र आत्मा पावै। ");
INSERT INTO bgc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","क्यूँके वो इब ताहीं इन म्ह तै किसे पै भी कोनी उतरया था, उननै तो सिर्फ प्रभु यीशु कै नाम तै बपतिस्मा लिया था। ");
INSERT INTO bgc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","फेर प्रेरितां नै उनपै हाथ धरे अर उननै पवित्र आत्मा पाया। ");
INSERT INTO bgc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जिब शमौन नै देख्या के प्रेरितां कै हाथ धरण तै पवित्र आत्मा दिया जावै सै, तो उनकै धोरै रपिये ल्याकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“या शक्ति मन्नै भी द्यो, के जिस किसे पै हाथ धरुँ वो पवित्र आत्मा पावै।” ");
INSERT INTO bgc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरस नै उसतै कह्या, “तेरे रपिये तेरे गेल्या नाश होज्या, क्यूँके तन्नै परमेसवर का दान रपियाँ तै मोल लेण का विचार करया। ");
INSERT INTO bgc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","इस बात म्ह ना तेरा हिस्सा सै, ना हक, क्यूँके तेरा मन परमेसवर कै आग्गै सच्चा कोनी। ");
INSERT INTO bgc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","इस करकै अपणी इस बुरी सोच नै छोड़कै प्रभु तै प्रार्थना कर, हो सकै सै वो तेरे मन का यो बुरा विचार माफ करदे। ");
INSERT INTO bgc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","क्यूँके मै देक्खूँ सूं के तू कड़वाहट तै भरया सै अर पाप के चुंगल म्ह फँसा सै।” ");
INSERT INTO bgc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","शमौन नै जवाब दिया, “थम मेरै खात्तर प्रभु तै प्रार्थना करो के जो बात थमनै कही, उन म्ह तै कोए भी मेरै पै न्ही आवै।” ");
INSERT INTO bgc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","आखर म्ह वे गवाही देकै प्रभु यीशु का वचन सुणाकै यरुशलेम नगर नै बोहड़गे, अर सामरिया के घणखरे गाम्मां म्ह सुसमाचार सुणान्दे गये। ");
INSERT INTO bgc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","फेर प्रभु कै एक सुर्गदूत नै फिलिप्पुस तै कह्या, “उठ अर दक्षिण की ओड़ उस राह पै जा, जो यरुशलेम नगर तै गाज़ा नगर म्ह जावै सै।” यो बियाबान राह सै। ");
INSERT INTO bgc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","वो उठकै चल दिया, अर देक्खो, कूश देश का एक माणस आण लागरया था जो खोजा (किन्नर) अर कूशियों की राणी कन्दाके का मंत्री अर खजांची था। वो आराधना करण खात्तर यरुशलेम नगर म्ह आया था। ");
INSERT INTO bgc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","वो अपणे रथ पै बेठ्या होया था, अर यशायाह नबी की किताब पढ़दा होया बोहड़ण लागरया था। ");
INSERT INTO bgc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","फेर पवित्र आत्मा नै फिलिप्पुस ताहीं कह्या, “लोवै जाकै इस रथ कै गेल्या हो ले।” ");
INSERT INTO bgc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस दौड़ कै रथ कै धोरै पोहचा अर उस ताहीं यशायाह नबी की किताब पढ़ते होए सुण्या, अर बुझ्झया, “तू जो पढ़ै सै, के उसनै समझै भी सै?” ");
INSERT INTO bgc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","वो बोल्या, “जिब ताहीं कोए मेरै ताहीं न्ही समझावै तो मै किस ढाळ समझूँ।” अर फिलिप्पुस तै बिनती करी के वो रथ पै चढ़कै उसकै धोरै बेठ्ठै। ");
INSERT INTO bgc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","पवित्र ग्रन्थ का जो पाठ वो पढ़ै था, वो यो था: “वो भेड़ की ढाळ मारण खात्तर पोहचाया गया, अर जिस तरियां मेम्‍ना अपणे ऊन काट्टण आळा कै स्याम्ही बोल-बाल्ला रहवै सै, उस्से तरियां ए उसनै भी अपणा मुँह कोनी खोल्या।” ");
INSERT INTO bgc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","“उस ताहीं अपमानित करया गया अर उस ताहीं कोए न्याय न्ही मिल्या। उसकै बखत के माणसां का ब्यौरा कौण देवैगा? क्यूँके धरती तै उसका प्राण ठा लिया जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","इसपै खोजे (किन्नर) नै फिलिप्पुस तै बुझ्झया, “मै तेरे तै बिनती करुँ सूं, न्यू बता के नबी यो किसकै बारै म्ह कहवै सै, अपणे या किसे दुसरे कै बारै म्ह?” ");
INSERT INTO bgc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","फेर फिलिप्पुस नै बताणा शरु करया, अर इस्से पवित्र ग्रन्थ तै शरु करकै उस ताहीं यीशु का सुसमाचार सुणाया। ");
INSERT INTO bgc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","राह म्ह चाल्दे-चाल्दे वे किसे तालाब कै धोरै पोहचे। फेर खोजे नै कह्या, “लखा उरै पाणी सै, इब मन्नै बपतिस्मा लेण म्ह के रोक सै।” ");
INSERT INTO bgc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुस बोल्या, “जै तू पूरे मन तै बिश्वास करै सै तो ले सकै सै।” उसनै जवाब दिया, “मै बिश्वास करुँ सूं के यीशु मसीह परमेसवर का बेट्टा सै।” ");
INSERT INTO bgc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","फेर उसनै रथ खड्या करण का हुकम दिया, अर फिलिप्पुस अर खोजा (किन्नर) दोन्नु तालाब म्ह बड़गे, अर उसनै खोजा (किन्नर) ताहीं बपतिस्मा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जिब वे पाणी म्ह तै लिकड़कै ऊपरान आये, तो प्रभु का आत्मा फिलिप्पुस ताहीं ठा लेग्या, अर खोजे नै उस ताहीं दुबारा न्ही देख्या, अर वो खुश था क्यूँके परमेसवर नै उस ताहीं बचा लिया सै। ");
INSERT INTO bgc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","फिलिप्पुस अशदोद नगर म्ह आ लिकड़या, अर जिब ताहीं कैसरिया नगर म्ह न्ही पोंहच्या, तब तक नगर-नगर सुसमाचार सुणान्दा गया। ");
INSERT INTO bgc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","शाऊल जो इब ताहीं प्रभु यीशु के चेल्यां ताहीं धमकाण अर मारण की धुन म्ह था, महायाजक कै धोरै गया ");
INSERT INTO bgc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","अर उसतै दमिश्क नगर के आराधनालयाँ कै नाम पै इस बाबत म्ह चिट्ठियाँ माँगी के, के चाहे माणस हो, चाहे लुगाई हो, जिन नै वो इस पंथ म्ह पावै उन ताहीं बाँधकै यरुशलेम नगर लियावै। ");
INSERT INTO bgc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","पर चाल्दे-चाल्दे जिब शाऊल अर उसके साथी दमिश्क नगर कै लोवै पोहुच्ये, तो चाणचक अकास तै उसकै चौगरदे नै चाँदणा चमक्या, ");
INSERT INTO bgc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","अर वो धरती पै पड़ग्या अर परमेसवर का यो शब्द सुण्या, “हे शाऊल, हे शाऊल, तू मन्नै क्यांतै सतावै सै?” ");
INSERT INTO bgc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","उसनै बुझ्झया, “हे प्रभु, तू कौण सै?” उसनै कह्या, “मै यीशु सूं, जिस ताहीं तू सतावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","पर इब उठकै नगर म्ह जा, अर जो तन्नै करणा सै वो तेरे तै कह्या जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जो माणस उसकै गेल्या थे, वे हैरान रहग्ये, क्यूँके बोल तो सुणै थे पर किसे ताहीं देक्खै कोनी थे। ");
INSERT INTO bgc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","फेर शाऊल धरती पै तै उठ्या, पर जिब आँख खोल्ली तो उस ताहीं किमे कोनी दिख्या, अर वे उसका हाथ पकड़कै दमिश्क नगर म्ह ले गये। ");
INSERT INTO bgc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","वो तीन दिन ताहीं कोनी देख सक्या, अर ना खाया अर ना पिया। ");
INSERT INTO bgc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिश्क नगर म्ह हनन्याह नामक एक चेल्ला था, उसतै प्रभु यीशु नै दर्शन म्ह कह्या, “हे हनन्याह!” वो बोल्या, “हाँ, प्रभु!” ");
INSERT INTO bgc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","फेर प्रभु नै उसतै कह्या, “उठकै उस गळी म्ह चल्या जा जो ‘सीध्धी’ कुह्वावै सै, अर यहूदा कै घर म्ह शाऊल नामक एक तरसुसवासी नै बुझ, क्यूँके देख, वो प्रार्थना करण लागरया सै, ");
INSERT INTO bgc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","अर उसनै दर्शन म्ह हनन्याह नामक एक माणस ताहीं भीत्त्तर आन्दे अर अपणे उप्पर हाथ धरदे देख्या सै, ताके दुबारा आँखां की रोशनी पावै।” ");
INSERT INTO bgc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याह नै जवाब दिया, “हे प्रभु, मन्नै इस माणस कै बारै म्ह घणाए तै सुण्या सै के इसनै यरुशलेम नगर म्ह तेरे आदमियाँ गेल्या बड्डी-बड्डी बुराई करी सै, ");
INSERT INTO bgc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","अर उरै भी इस ताहीं प्रधान याजकां की ओड़ तै हक मिल्या सै के जो माणस तेरे म्ह बिश्वास राक्खै सै, उन सारया नै बाँधकै यरुशलेम ले जा।” ");
INSERT INTO bgc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पर प्रभु नै उसतै कह्या, “तू चल्या जा, क्यूँके वो तो गैर यहूदी अर राजयां अर इस्राएलियों कै स्याम्ही मेरा नाम का प्रचार करण कै खात्तर चुण्या होया पात्र सै। ");
INSERT INTO bgc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","अर मै उसनै बताऊँगा, के मेरै बारें बताण कै खात्तर उसनै किसा-किसा दुख ठाणा पड़ैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","फेर हनन्याह उठकै उस घर म्ह गया जड़ै शाऊल रुक्या था, अर उसपै अपणा हाथ धरकै कह्या, “हे भाई शाऊल, प्रभु, यानिके यीशु, जो उस राह म्ह, जिसतै तू आया तेरे ताहीं दिखया था, उस्से नै मेरै ताहीं भेज्या सै के तू दुबारा आँखां की रोशनी पावै अर पवित्र आत्मा तै भरया-पूरा हो जावै।” ");
INSERT INTO bgc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","अर जिब्बे उसकी आँखां तै छिल्के-से पड़े अर वो देखण लाग्या, अर उठकै बपतिस्मा लिया, ");
INSERT INTO bgc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","फेर खाणा खाकै हिम्मत पाई। शाऊल कई दिन उन चेल्यां कै गेल्या रहया जो दमिश्क नगर म्ह थे। ");
INSERT INTO bgc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","अर वो जिब्बे दमिश्क नगर के आराधनालयाँ म्ह यीशु का प्रचार करण लाग्या, के वो परमेसवर का बेट्टा सै। ");
INSERT INTO bgc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","सारे सुणण आळे हैरान होकै कहण लाग्गे, “के यो वोए माणस न्ही सै जो यरुशलेम नगर म्ह उन ताहीं जो यीशु मसीह के बिश्वासी थे, उनका नाश करया करै था, अर उरै भी इस्से खात्तर आया था, के उननै बाँधकै प्रधान याजकां कै धोरै ले जावै?” ");
INSERT INTO bgc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पर शाऊल और भी सामर्थी होंदा गया, अर इस बात का सबूत दे-देकै, के मसीह यीशु-ए सै, दमिश्क नगर के रहणीये यहूदियाँ का मुँह बन्द करदा रहया। ");
INSERT INTO bgc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","जिब शाऊल नै ओड़ै रहन्दे होए भोत दिन बीतगे, तो यहूदियाँ नै मिलकै उस ताहीं मारण की साजस रची। ");
INSERT INTO bgc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","पर उनकी साजिस का शाऊल नै बेरा पाटग्या। वे तो उसनै मारण खात्तर रात-दिन फाटकां पै घात म्ह लाग्गे रहवैं थे। ");
INSERT INTO bgc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","पर रात नै उसके चेल्यां नै उस ताहीं टोकरे म्ह बिठाया, अर दमिश्क नगर की चारदीवारी पै तै लटकाकै उतार दिया। ");
INSERT INTO bgc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","यरुशलेम नगर म्ह पोहचकै शाऊल नै चेल्यां कै गेल्या मिल जाण की कोशिश करी, पर सारे उसतै डरै थे, क्यूँके उननै बिश्वास कोनी होवै था, के वो भी चेल्ला सै। ");
INSERT INTO bgc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","पर बरनबास नै उस ताहीं अपणे गेल्या प्रेरितां कै धोरै ले जाकै उन ताहीं बताया के इसनै किस ढाळ तै राह म्ह प्रभु यीशु ताहीं देख्या, अर यीशु नै इसतै बात करी, फेर दमिश्क नगर म्ह इसनै किस तरियां हिम्मत दिखाकै यीशु कै नाम का प्रचार करया। ");
INSERT INTO bgc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","वो उनकै गेल्या यरुशलेम नगर म्ह आन्दा-जान्दा रहया ");
INSERT INTO bgc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","अर बेधड़क होकै प्रभु का नाम तै प्रचार करै था, अर यूनानी भाषा बोल्लण आळे यहूदियाँ कै गेल्या बोलचाल अर बहस करै था, पर वे उसनै मारण की कोशिश करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","न्यू जाणकै भाई उस ताहीं कैसरिया नगर लिआये, अर तरसुस नै भेज दिया। ");
INSERT INTO bgc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","इस तरियां सारे यहूदिया परदेस, अर गलील परदेस, अर सामरिया परदेस की कलीसिया नै चैन मिल्या, अर उसकी बढ़ोतरी होन्दी गई, अर वा प्रभु कै भय अर पवित्र आत्मा की शान्ति म्ह चाल्दी अर बढ़दी गई। ");
INSERT INTO bgc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","फेर इसा होया के पतरस हरेक जगहां हांडदा होया, उन पवित्र आदमियाँ कै धोरै भी पोंहच्या जो लुद्दा नगर म्ह रहवैं थे। ");
INSERT INTO bgc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ओड़ै उसनै एनियास नामक लकवे का रोग्गी एक माणस मिल्या, जो आठ साल तै खाट पै पड्या था। ");
INSERT INTO bgc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरस नै उसतै कह्या, “हे एनियास! यीशु मसीह तन्नै ठीक करै सै। उठ, अपणा बिछाणा ठा।” फेर वो जिब्बे उठ खड्या होया। ");
INSERT INTO bgc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","फेर लुद्दा नगर अर शारोन के सारे रहणीये उस ताहीं देखकै प्रभु की ओड़ फिरे। ");
INSERT INTO bgc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा नगर म्ह तबीता यानिके दोरकास नाम की एक बिश्वासण रहवै थी। वा घणे भले-भले काम अर दान करया करै थी। ");
INSERT INTO bgc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","उन्हे दिनां म्ह जिब पतरस लुद्दा नगर म्ह था, तो वा बीमार होकै मरग्यी, अर उननै उस ताहीं नुह्वाकै चुबारै पै धर लिया। ");
INSERT INTO bgc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा नगर याफा नगर कै धोरै था, चेल्यां नै न्यू सुणकै पतरस ओड़ै सै, दो माणस भेजकै उसतै बिनती करी, “म्हारै धोरै आण म्ह वार ना लावै।” ");
INSERT INTO bgc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","फेर पतरस उठकै उसकै गेल्या हो लिया, अर जिब वो पोंहच्या तो वे उसनै उस चौबारे म्ह ले गये। सारी बिधवां रोंदी होई उसकै धोरै आण खड़ी होई, अर जो कुड़ते अर लत्ते दोरकास नै उनकै गेल्या रहंदे होए बणाए थे, दिखाण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","फेर पतरस नै सारया ताहीं बाहरणै कर दिया, अर गोड्डे टेक कै प्रार्थना करी अर लाश की ओड़ लखाकै कह्या, “हे तबीता, उठ!” फेर उसनै अपणी आँख खोल दी, अर पतरस ताहीं देखकै उठ बेठ्ठी। ");
INSERT INTO bgc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","उसनै हाथ बढ़ाकै उस ताहीं ठाया, अर पवित्र आदमी अर बिधवायाँ ताहीं बुलाकै उस ताहीं जिन्दा दिखा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","या बात साब्बत याफा नगर म्ह फैलग्यी, अर घणखरयां नै प्रभु यीशु पै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","अर पतरस याफा नगर म्ह शमौन नामक किसे चमड़े का धन्धा करणीये कै उरै घणे दिनां ताहीं रहया। ");
INSERT INTO bgc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया नगर म्ह कुरनेलियुस नाम का एक माणस था, जो इतालियानी नामक पलटन का सूबेदार था। ");
INSERT INTO bgc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","वो भगत था, अर अपणे साब्ते कुण्बे सुधा परमेसवर तै डरै था, अर गरीब यहूदी आदमियाँ ताहीं घणा दान देवै था, अर बराबर परमेसवर की प्रार्थना करै था। ");
INSERT INTO bgc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","उसनै दिन कै बजे कै लोवै दर्शन म्ह साफ तौर तै देख्या के परमेसवर का एक सुर्गदूत उसकै धोरै भीत्त्तर आकै कहवै सै, “हे कुरनेलियुस!” ");
INSERT INTO bgc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कुरनेलियुस नै उस ताहीं गौर तै देख्या अर डरकै कह्या, “हे प्रभु, के हुकम सै?” उसनै उसतै कह्या, “तेरी प्रार्थनाएँ अर तेरे दान याद कै खात्तर परमेसवर कै स्याम्ही पोहचे सै, ");
INSERT INTO bgc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","अर याफा नगर म्ह माणस भेजकै शमौन नै, जो पतरस कुह्वावै सै, बुलवा ले। ");
INSERT INTO bgc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","वो शमौन, चमड़े का धन्धा करण आळे कै उरै मेहमान सै, जिसका घर समुन्दर कै किनारे सै।” ");
INSERT INTO bgc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जिब वो सुर्गदूत जिसनै उसतै बात करी थी चल्या गया, तो कुरनेलियुस नै दो नौक्कर, अर जो उसकै लोवै हाजिर रहया करै थे उन म्ह तै एक भगत सिपाही ताहीं बुलाया, ");
INSERT INTO bgc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","अर उन ताहीं सारी बात बताकै याफा नगर की ओड़ भेज्या, ताके पतरस ताहीं ले आवै। ");
INSERT INTO bgc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दुसरे दिन जिब वे तीन आदमी जो कुरनेलियुस जरिये भेज्जे गये थे, चाल्दे-चाल्दे नगर कै धोरै पोहचे, तो दोफारी कै लोवै पतरस छात पै प्रार्थना करण चढ़या। ");
INSERT INTO bgc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","उसनै भूख लाग्गी अर कुछ खाणा चाहवै था, पर जिब वे खाणा त्यार करै थे तो वो बेसुध होग्या, ");
INSERT INTO bgc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","अर उसनै देख्या, के अकास खुलग्या, अर एक बड्डी चाद्दर च्यारु कुणयां तै लटकदी होई, धरती की ओड़ उतरै सै। ");
INSERT INTO bgc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जिस म्ह धरती के सारे ढाळ के चार पैरां आळे अर रेंगणेआळे जिनोर अर अकास के पंछी थे। ");
INSERT INTO bgc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","उसनै एक इसा बोल सुण्या, “हे पतरस उठ, मार अर खा।” ");
INSERT INTO bgc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पर पतरस नै कह्या, “ना प्रभु, कती भी न्ही, क्यूँके मन्नै कदे कोए अशुद्ध चीज न्ही खाई सै।” ");
INSERT INTO bgc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","फिर दुसरी बर उस ताहीं बोल सुणाई दिया “जो किमे परमेसवर नै शुद्ध कर दिया सै, उस ताहीं अशुद्ध मतना कहवै।” ");
INSERT INTO bgc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","तीन बर इस तरियां ए होया, फेर जिब्बे वा चाद्दर अकास म्ह ठा ली गई। ");
INSERT INTO bgc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जिब पतरस अपणे मन म्ह दुबिध्या म्ह था, के यो दर्शन जो मन्नै देख्या इसका के मतलब हो सकै सै, तो देक्खो, वे माणस जिन ताहीं कुरनेलियुस नै भेज्या था, शमौन कै घर का पता लगाकै दरबाजे पै आण खड़े होए, ");
INSERT INTO bgc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","अर रुक्का मारकै बुझ्झण लाग्गे, “के शमौन जो पतरस कुह्वावै सै, याड़ैए सै के?” ");
INSERT INTO bgc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस तो उस दर्शन पै सोचण ए लागरया था, के पवित्र आत्मा नै उसतै कह्या, “देख, तीन माणस तेरी टोह् म्ह सै। ");
INSERT INTO bgc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","आखर उठकै तळै जा, अर बेझिझक उनकै गेल्या हो ले, क्यूँके मन्नै ए उन ताहीं भेज्या सै।” ");
INSERT INTO bgc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","फेर पतरस नै उतरकै उन माणसां ताहीं कह्या, “देक्खो, जिसकी टोह् म्ह थम सो, वो मै सूं। थारे आण का के कारण सै?” ");
INSERT INTO bgc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","वे बोल्ले, “कुरनेलियुस सूबेदार जो धर्मी अर परमेसवर तै डरणआळा अर सारी यहूदी जात म्ह नाम्मी माणस सै, उसनै एक पवित्र सुर्गदूत तै यो निर्देश पाया सै के तेरे ताहीं अपणे घरां बुलाकै तेरे तै वचन सुणै।” ");
INSERT INTO bgc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","फेर उसनै उन ताहीं भीत्त्तर बुलाकै उनकी मेहमान-नवाजी करी। दुसरे दिन वो उनकै गेल्या गया, अर याफा नगर के बिश्वासी भाईयाँ म्ह तै कुछ उसकै गेल्या हो लिए। ");
INSERT INTO bgc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","आगले दिन वे कैसरिया नगर पोहचे, अर कुरनेलियुस अपणे कुण्बे आळा अर प्यारे साथियाँ ताहीं कठ्ठा करकै उनकी बाट देक्खै था। ");
INSERT INTO bgc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जिब पतरस भीत्त्तर आवै था, तो कुरनेलियुस उसतै मिल्या, अर उसकै पायां म्ह पड़कै उस ताहीं प्रणाम करया, ");
INSERT INTO bgc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पर पतरस नै उस ताहीं ठा कै कह्या, “खड्या हो, मै भी तो माणस सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","अर उसकै गेल्या बतळान्दा भीत्त्तर गया, अर घणे आदमियाँ ताहीं कठ्ठे देखकै ");
INSERT INTO bgc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","पतरस नै उनतै कह्या, “थमनै बेरा सै के हम यहूदियाँ कै खात्तर गैर यहूदियाँ तै संगति करणा या उसकै उरै जाणा कानून के खिलाफ सै, पर परमेसवर नै मेरै तै बताया सै के किसे माणस ताहीं अपवित्र या अशुद्ध ना कहूँ। ");
INSERT INTO bgc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ज्यांतै मै जिब बुलाया गया तो बिना कुछ कहे चल्या आया। इब मै बुझ्झु सूं के मेरै ताहीं किस काम कै खात्तर बुलाया गया?” ");
INSERT INTO bgc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलियुस बोल्या, “इस्से घड़ी, पूरे चार दिन होए, मै अपणे घर म्ह दोफाहरै पाच्छै तीन बजे प्रार्थना करण लागरया था, तो एक माणस चमकीला बाणा पहरे होए, मेरै स्याम्ही आण खड्या होया ");
INSERT INTO bgc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","अर कहण लाग्या, ‘हे कुरनेलियुस, तेरी प्रार्थनाएँ अर तेरे दान याद कै खात्तर परमेसवर कै स्याम्ही पोहचे सै। ");
INSERT INTO bgc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","इस करकै किसे नै याफा नगर भेजकै शमौन जो पतरस कुह्वावै सै, बुलवा ले। वो शमौन, चमड़े का धन्धा करण आळे कै उरै मेहमान सै, जिसका घर समुन्दर कै किनारे सै।’ ");
INSERT INTO bgc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","फेर मन्नै जिब्बे तेरे धोरै आदमी भेज्जै, अर तन्नै भला करया जो आ ग्या। इब हम सारे उरै परमेसवर कै स्याम्ही सां, ताके जो किमे परमेसवर नै तेरे तै कह्या उस ताहीं सुणां।” ");
INSERT INTO bgc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","फेर पतरस बोल्या, “इब मेरै पक्का यकिन होग्या के परमेसवर किसे का पक्षपात कोनी करदा, ");
INSERT INTO bgc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","बल्के हरेक जात म्ह जो परमेसवर तै डरै अर धर्म के काम करै सै, वो उसनै भावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","थम जाणो सों के परमेसवर नै इस्राएल के माणसां ताहीं अपणा संदेश भेज्जा, उसनै शान्ति के बारै म्ह सुसमाचार सुणाया जो माणसां ताहीं यीशु मसीह पै बिश्वास करण कै जरिये मिलै सै। ");
INSERT INTO bgc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","वो वचन थमनै बेरा सै, जो यूहन्ना के बपतिस्मा के प्रचार कै पाच्छै गलील परदेस तै शरु होकै साब्ते यहूदिया परदेस म्ह फैलग्या। ");
INSERT INTO bgc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","परमेसवर नै किस तरियां तै यीशु नासरी ताहीं पवित्र आत्मा अर सामर्थ तै अभिषेक करया, वो भलाई करदा अर सारया ताहीं जो शैतान के सताए होड़ थे, आच्छा करदा फिरया, क्यूँके परमेसवर उसकै गेल्या था।” ");
INSERT INTO bgc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“हम उन सारे काम्मां के गवाह सां, जो उसनै यहूदिया परदेस अर यरुशलेम नगर म्ह भी करे, अर उननै उस ताहीं क्रूस पै लटकाकै मार दिया। ");
INSERT INTO bgc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","उस ताहीं परमेसवर नै तीसरे दिन जिन्दा करया, अर जाहिर भी कर दिया सै, ");
INSERT INTO bgc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सारे आदमियाँ पै न्ही बल्के उन गवाह पै जिन ताहीं परमेसवर नै पैहल्या तै छाँट लिया था, यानिके म्हारै पै जिन नै उसकै मरे होया म्ह तै जिन्दा उठण कै पाच्छै उसकै गेल्या खाया-पिया, ");
INSERT INTO bgc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","अर उसनै म्हारै ताहीं हुकम दिया के आदमियाँ म्ह प्रचार करो अर गवाही द्यो, के यो वोए सै जिस ताहीं परमेसवर नै जिन्दा अर मरया होया का न्यायी ठहराया सै। ");
INSERT INTO bgc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","उसकी सारे नबी गवाही देवैं सै के जो कोए उसपै बिश्वास करैगा, उस ताहीं उसकै नाम तै पापां की माफी मिलैगी।” ");
INSERT INTO bgc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस ये बात कहण ए लागरया था के पवित्र आत्मा वचन के सारे सुणण आळा पै उतर आया। ");
INSERT INTO bgc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","अर जितने खतना करे होए बिश्वासी पतरस कै गेल्या आये थे, वे सारे हैरान होए के गैर यहूदियाँ पै भी पवित्र आत्मा का दान ढाळा गया सै। ");
INSERT INTO bgc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","क्यूँके उननै उन ताहीं कई ढाळ की भाषा बोल्दे अर परमेसवर की बड़ाई करदे सुण्या। इसपै पतरस नै कह्या, ");
INSERT INTO bgc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“के कोए पाणी नै रोक सकै सै के ये बपतिस्मा ना पावै, जिननै म्हारै की ढाळ परमेसवर की ओड़ तै पवित्र आत्मा पाया सै?” ");
INSERT INTO bgc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","अर उसनै हुकम दिया के उननै यीशु मसीह कै नाम म्ह बपतिस्मा दिया जावै। फेर उननै उसतै बिनती करी के वो कुछ दिन और उनकै गेल्या रहवै। ");
INSERT INTO bgc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","फेर प्रेरितां अर बिश्वासी भाईयाँ नै जो यहूदिया परदेस म्ह थे सुण्या के गैर यहूदियाँ नै भी परमेसवर का वचन मान लिया सै। ");
INSERT INTO bgc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","आखर म्ह जिब पतरस यरुशलेम नगर म्ह आया, तो खतना किये होए आदमी उसतै बहस करण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“तन्नै खतनारहित आदमियाँ कै उरै जाकै उनकै गेल्या खाया।” ");
INSERT INTO bgc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","फेर पतरस नै उन ताहीं शरु तै आखर ताहीं सारा किमे कह सुणाया ");
INSERT INTO bgc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“मै याफा नगर म्ह प्रार्थना करण लागरया था, अर बेसुध होकै एक दर्शन देख्या के एक बड्डी चाद्दर च्यारु कुणयां तै लटकदी होई, अकास तै उतरकै मेरै धोरै आई।” ");
INSERT INTO bgc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","जिब मन्नै उसपै गौर करया, तो उस म्ह धरती के चार पैरां आळे अर बणपशु अर रेंगण आळे जिनोर अर अकास के पंछी देक्खे, ");
INSERT INTO bgc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","अर यो बोल भी सुण्या, “हे पतरस उठ, मार अर खा।” ");
INSERT INTO bgc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","मन्नै कह्या, “ना प्रभु, ना, क्यूँके कोए अशुद्ध चीज मेरै मुँह म्ह कदे न्ही गई।” ");
INSERT INTO bgc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","इसकै जवाब म्ह अकास तै दुसरी बर आवाज होई, “जो किमे परमेसवर नै शुद्ध ठैहराया सै, उस ताहीं अशुद्ध मतना कहवै।” ");
INSERT INTO bgc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तीन बर इसा होया, फेर सारा किमे दुबारा अकास पै खींच लिया गया। ");
INSERT INTO bgc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","जिब्बे तीन माणस जो कुरनेलियुस नै कैसरिया परदेस तै मेरै धोरै भेज्जे थे, उस घर पै जिसम्ह हम थे, आण खड़े होए। ");
INSERT INTO bgc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","फेर पवित्र आत्मा नै मेरै तै बेझिझक होकै उनकै गेल्या जाण खात्तर कह्या, अर छ: भाई भी मेरै गेल्या हो लिये, अर हम उस माणस कै घरां गये। ");
INSERT INTO bgc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","उसनै म्हारै ताहीं बताया, के उसनै एक सुर्गदूत ताहीं अपणे घर म्ह खड्या देख्या, जिसनै उसतै कह्या, “याफा नगर म्ह माणस भेजकै शमौन ताहीं जो पतरस कुह्वावै सै, बुलवा ले। ");
INSERT INTO bgc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","वो थारे तै इसी बात कहवैगा, जिनकै जरिये तू अर तेरा सारा घराना उद्धार पावैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","जिब म्ह बात करण लाग्या, तो पवित्र आत्मा उनपै उस्से तरियां तै उतरया जिस तरियां तै शरु म्ह म्हारै पै उतरया था। ");
INSERT INTO bgc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","फेर मन्नै प्रभु का यो वचन याद आया, जो उसनै कह्या था, “यूहन्ना नै तो पाणी तै बपतिस्मा दिया, पर थम पवित्र आत्मा तै बपतिस्मा पाओगे। ");
INSERT INTO bgc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","इस खात्तर जिब परमेसवर नै उन ताहीं भी वोए दान दिया, जो म्हारै ताहीं प्रभु यीशु मसीह पै बिश्वास करण तै मिल्या था, तो मै कौण था जो परमेसवर नै रोक सकदा?” ");
INSERT INTO bgc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","यो सुणण कै बाद उसके जवाब म्ह वे यहूदी बिश्वासी कुछ भी न्ही बोल पाए, अर परमेसवर की बड़ाई करकै कहण लाग्गे, “फेर तो परमेसवर नै गैर यहूदियाँ ताहीं भी अनन्त जीवन कै खात्तर पापां की माफी अर यीशु मसीह पै बिश्वास करण का दान दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","जो आदमी उस क्ळेश के मारे जो स्तिफनुस कै कारण पड्या था, खिंड-मिंड हो गये थे, वे हांडदे-हांडदे फीनीके परदेस अर साइप्रस टापू अर अन्ताकिया नगर म्ह पोहचे, पर यहूदियाँ नै छोड़ किसे और ताहीं वचन कोनी सुणावै थे। ");
INSERT INTO bgc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","पर उन म्ह तै कुछ बिश्वासी साइप्रस टापू अर कुरेनवासी थे, जो अन्ताकिया नगर म्ह आकै यूनानियाँ ताहीं भी प्रभु यीशु का सुसमाचार सुणाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभु का हाथ उनपै था, अर घणे आदमी बिश्वास करकै प्रभु की ओड़ फिरे। ");
INSERT INTO bgc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","जिब उनका जिक्र यरुशलेम नगर की कलीसिया के लोग्गां कै सुणण म्ह आया, तो उननै बरनबास ताहीं अन्ताकिया नगर भेज्या। ");
INSERT INTO bgc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","वो उड़ै पोहचकै अर परमेसवर के अनुग्रह नै देखकै राज्जी होया, अर सारया ताहीं उपदेश दिया के तन-मन लगाकै प्रभु तै लिपटे रहो। ");
INSERT INTO bgc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","वो एक भला माणस था, अर पवित्र आत्मा अर बिश्वास तै पूरा भरया था, अर दुसरे घणखरे आदमी प्रभु म्ह आ मिले। ");
INSERT INTO bgc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","फेर वो शाऊल नै टोह्ण कै खात्तर तरसुस नगर म्ह चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","जिब वो उसतै मिल्या तो उस ताहीं अन्ताकिया नगर ल्याया, अर इसा होया के वे एक साल ताहीं कलीसिया कै गेल्या मिलदे अर प्रभु यीशु मसीह का घणे आदमियाँ ताहीं उपदेश देन्दे रहे, अर चेल्लें सारया तै पैहल्या अन्ताकिया नगर ए म्ह मसीह कुहाए। ");
INSERT INTO bgc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","उननै दिनां म्ह कई नबी यरुशलेम नगर तै अन्ताकिया नगर आए। ");
INSERT INTO bgc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","उन म्ह तै अगबुस नामक एक नबी नै खड़े होकै आत्मा की प्रेरणा तै न्यू बताया के सारी दुनिया म्ह बड्ड़ा अकाळ पड़ैगा, वो अकाळ (रोम के सम्राट) क्लौदियुस के बखत म्ह पड्या। ");
INSERT INTO bgc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","फेर चेल्यां नै फैसला लिया के हरेक अपणी-अपणी पूंजी कै मुताबिक यहूदिया परदेस म्ह रहण आळे भाईयाँ की मदद कै खात्तर किमे भेज्जै। ");
INSERT INTO bgc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","उननै इस तरियां ए करया, अर बरनबास अर शाऊल कै हाथ कलीसिया के अगुवां कै धोरै कुछ भेज दिया। ");
INSERT INTO bgc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","उस बखत हेरोदेस राजा नै कलीसिया के कई माणसां ताहीं सताण कै मकसद तै बन्दी बणा लिया। ");
INSERT INTO bgc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","उसनै प्रेरित यूहन्ना के भाई याकूब ताहीं तलवार तै मरवा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जिब उसनै देख्या के यहूदी माणस इसतै राज्जी होवै सै, तो उसनै पतरस ताहीं भी पकड़ लिया। वे अखमीरी रोट्टी के त्यौहार के दिन थे। ");
INSERT INTO bgc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","हेरोदेस नै उस ताहीं पकड़कै जेळ म्ह गेरया, अर चार-चार सिपाहियाँ के चार पहरया म्ह राख्या, इस विचार तै के फसह कै बाद उसनै आदमियाँ कै स्याम्ही ल्यावै। ");
INSERT INTO bgc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","जेळ म्ह पतरस बन्द था, पर कलीसिया उसकै खात्तर लौ लाकै परमेसवर तै प्रार्थना करण लागरी थी। ");
INSERT INTO bgc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जिब हेरोदेस राजा उसनै आदमियाँ कै स्याम्ही ल्याण आळा था, उस्से रात पतरस दो जंजीरां तै बंध्या होड़ दो सिपाहियाँ कै बिचाळै सोण लागरया था, अर पहरेदार दरबाजे पै जेळ की रुखाळी कररे थे। ");
INSERT INTO bgc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","तो देक्खो, प्रभु का एक सुर्गदूत आण खड्या होया अर उस कोठड़ी म्ह चाँदणा चमक्या, अर उसनै पतरस की पासळी पै हाथ मारकै उस ताहीं जगाया अर बोल्या, “उठ, तावळ कर।” अर उसकै हाथ्थां तै बेड़ी खुलकै गिरगी। ");
INSERT INTO bgc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","फेर सुर्गदूत नै उसतै कह्या, “कमर बाँध, अर अपणे जूत्ते पहर ले।” उसनै उस्से ढाळ करया। फेर उसनै उसतै कह्या, “अपणे लत्ते पहरकै मेरै पाच्छै हो ले।” ");
INSERT INTO bgc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","वो लिकड़कै उसकै पाच्छै हो लिया, पर उसनै न्यू न्ही बेरा था के जो किमे सुर्गदूत कर रह्या सै वो साच्ची सै, बल्के न्यू समझै था के जणु मै दर्शन देखण लागरया सूं। ");
INSERT INTO bgc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","फेर वे पैहल्या अर दुसरे पहरे तै लिकड़कै उस लोहे के फाटक पै पोहचे, जो नगर की ओड़ सै। वो उनकै खात्तर अपणे-आप्पे खुलग्या, अर वे लिकड़कै एक गळी म्ह गए, अर जिब्बे ए सुर्गदूत उसनै छोड़कै चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","फेर पतरस नै चेत म्ह होकै कह्या, “इब मन्नै सच का बेरा पटया सै के प्रभु नै अपणा सुर्गदूत भेजकै मेरै ताहीं हेरोदेस राजा के हाथ्थां तै छुड़ा लिया, अर यहूदी अगुवां की सारी मनसा पै पाणी फेर दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","न्यू जाणकै वो उस यूहन्ना की माँ मरियम कै घरां आया, जो मरकुस कुह्वावै सै। ओड़ै घणे आदमी कठ्ठे होकै प्रार्थना करण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","जिब उननै दरबाजा खटखटाया, तो रूदे नामक एक नौकराणी देखण नै आई। ");
INSERT INTO bgc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पतरस का बोल पिच्छाणकै उसनै खुशी के मारे दरबाजा न्ही खोल्या, पर भाजकै भीत्त्तर गई अर बताया के पतरस दरबाजे पै खड्या सै। ");
INSERT INTO bgc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","उननै उसतै कह्या, “तू बावळी सै।” पर वा पूरे बिश्वास तै बोल्ली के पतरस ए सै। फेर उननै कह्या, “उसका सुर्गदूत होगा।” ");
INSERT INTO bgc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","पर पतरस खटखटान्दा ए रहया आखर म्ह उननै दरबाजा खोल्या, अर उस ताहीं देखकै हैरान होग्ये। ");
INSERT INTO bgc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","फेर उसनै उन ताहीं हाथ तै इशारा करया के बोल-बाल्ले रहवैं, अर उन ताहीं बताया के प्रभु किस ढाळ उस ताहीं जेळ तै लिकाड़ ल्याया सै। फेर बोल्या, “याकूब अर दुसरे भाईयाँ नै या बात बता दियो।” फेर लिकड़कै दुसरी जगहां चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","तड़कैए जेळ के सिपाहियाँ म्ह घणी भगदड़ माचगी के पतरस कित्त गया। ");
INSERT INTO bgc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","जिब हेरोदेस राजा नै उसकी टोहया-टाही करवाई अर न्ही मिल्या, तो पैहरेदारां की जाँच करकै हुकम दिया के वे मार दिये जावै, अर वो यहूदिया परदेस नै छोड़कै कैसरिया नगर म्ह जाकै रहण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोदेस राजा सूर अर सैदा नगर के लोग्गां तै घणा नाराज था। वे एक टोळ बणाकै उसतै मिलण आये, राजा का एक खास कर्मचारी बलास्तुस ताहीं मनाकै राजा तै मेल करणा चाह्या, क्यूँके राजा के देश म्ह उनकै देश का पालन-पोषण होवै था। ");
INSERT INTO bgc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","खास दिन पै हेरोदेस राजा राजसी-बाणा पहरकै सिंहासन पै बेठ्या, अर उन ताहीं खुलास्सा करण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","फेर आदमियाँ नै रुक्का मारया, “यो तो माणस का न्ही ईश्‍वर का बोल सै।” ");
INSERT INTO bgc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","उस्से घड़ी प्रभु कै एक सुर्गदूत नै जिब्बे आकै हेरोदेस राजा ताहीं झिड़का, अर वो कीड़े पड़कै मरग्या। क्यूँके उसनै परमेसवर की महिमा कोनी करी, ");
INSERT INTO bgc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पर परमेसवर का वचन बढ़दा अर फैलदा गया। ");
INSERT INTO bgc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जिब बरनबास अर शाऊल नै अपणी सेवा पूरी कर ली तो यूहन्ना जो मरकुस कुह्वावै था, गेल्या लेकै यरुशलेम नगर तै बोह्ड़े। ");
INSERT INTO bgc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया नगर की कलीसिया म्ह कई नबी अर उपदेशक थे, यानी बरनबास, शमौन जो नीगर (काळा आदमी) कुह्वावै सै, अर शाऊल अर कुरेनी लूकियुस, मनाहेम जिसका पालन-पोषण चौथाई देश के राजा हेरोदेस कै गैल होया था। ");
INSERT INTO bgc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जिब ये लोग प्रभु की आराधना अर ब्रत करण लागरे थे, तो पवित्र आत्मा नै उनतै कह्या, “मेरै खात्तर बरनबास अर शाऊल नै उस काम कै खात्तर न्यारा करो जिसकै खात्तर मन्नै उन ताहीं बुलाया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","फेर उननै ब्रत अर प्रार्थना करकै अर उनपै हाथ धरकै उन ताहीं परमेसवर के काम खात्तर बिदा करया। ");
INSERT INTO bgc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","शाऊल अर बरनबास पवित्र आत्मा के भेज्जै होए सिलूकिया बन्‍दरगाह गये, अर ओड़ै तै जहाज पै चढ़कै साइप्रस टापू कान्ही चाल्ले, ");
INSERT INTO bgc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","अर सलमीस नगर म्ह पोहचकै, परमेसवर का वचन यहूदियाँ के आराधनालयाँ म्ह सुणाया। यूहन्ना उनका सेवक था। ");
INSERT INTO bgc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","वे उस सारे टापू म्ह होन्दे होए पाफुस परदेस ताहीं पोहचे। ओड़ै उननै बारयीशु नामक एक यहूदी जादूगर अर झूठ्ठा नबी मिल्या। ");
INSERT INTO bgc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","वो राज्यपाल सिरगियुस पौलुस कै गेल्या था, जो अकलमंद माणस था। उसनै बरनबास अर शाऊल ताहीं अपणे धोरै बुलाकै परमेसवर का वचन सुणणा चाह्या। ");
INSERT INTO bgc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पर इलीमास जादूगर नै (क्यूँके योए उसकै नाम का मतलब सै) उनका बिरोध करकै हाकिम ताहीं यीशु पै बिश्वास करण तै रोकणा चाह्या। ");
INSERT INTO bgc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","फेर शाऊल नै जिसका नाम पौलुस भी सै, पवित्र आत्मा तै पूरी तरियां भरकै उसकी ओड़ टकटकी लाकै देख्या अर बोल्या, ");
INSERT INTO bgc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“हे सारे कपट अर सारी ढ़ाळ कि चतुराई तै भरे होड़ शैतान की ऊलाद, सारे धर्मां के बैरी, के तू प्रभु के सीध्धी राही नै टेढ़ी करणा न्ही छोड्डैगा?” ");
INSERT INTO bgc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","इब लखा, “प्रभु का हाथ तेरे बिरोध म्ह उठ्या सै, अर तू कुछ बखत ताहीं आन्धा रहवैगा अर सूरज नै कोनी देक्खैगा।” फेर जिब्बे धुँधळापण अर अन्धेरा उसपै छा गया, वो आस्सै-पास्सै टटोळण लाग्या ताके कोए उसका हाथ पकड़कै ले चाल्लै। ");
INSERT INTO bgc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","फेर हाकिम नै जो होया था उस ताहीं देखकै अर प्रभु के उपदेश तै हैरान होकै यीशु पै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौलुस अर उसके मित्तर पाफुस परदेस तै पाणी का जहाज खोल कै पंफूलिया परदेस के पिरगा नगर म्ह आये, अर यूहन्ना उननै छोड़कै यरुशलेम नगर बोहड़ गया। ");
INSERT INTO bgc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पिरगा नगर तै आग्गै बढ़कै वे पिसिदिया परदेस के अन्ताकिया नगर म्ह पोहचे, अर आराम कै दिन आराधनालय म्ह जाकै बैठग्ये। ");
INSERT INTO bgc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","मूसा के नियम-कायदे अर नबियाँ की किताब नै पढ़ण कै पाच्छै आराधनालय के सरदारां नै उनकै धोरै कहवां भेज्या, “हे भाईयो, जै आदमियाँ के उपदेश कै खात्तर थारे मन म्ह कोए बात हो तो कहो।” ");
INSERT INTO bgc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","फेर पौलुस नै खड़े होकै अर हाथ तै इशारा करकै कह्या, “हे इस्राएलियों, अर गैर यहूदी जो परमेसवर तै डरण आळो, सुणो!” ");
INSERT INTO bgc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इस्राएल के परमेसवर नै म्हारै पूर्वजां ताहीं छाँट लिया, अर जिब वे मिस्र देश म्ह परदेशी होकै रहवै थे, तो उनकी बढ़ोतरी करी, अर अपणी शक्ति के दम पै उननै लिकाड़ ल्याया। ");
INSERT INTO bgc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","वो कोए चाळीस साल ताहीं जंगल-बियाबान म्ह उनकी सहण करदा रहया, ");
INSERT INTO bgc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","अर कनान देश की सात जात्तां का नाश करकै उनका देश कोए साढ़े चार सौ साल म्ह इनकी वसियत म्ह कर दिया। ");
INSERT INTO bgc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“इसकै बाद परमेसवर नै शमूएल नबी ताहीं उन म्ह न्यायाधीश ठहराया। ");
INSERT INTO bgc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","इसकै पाच्छै उननै शमूएल तै उनपै एक राजा ठैहराण की माँग करी, फेर परमेसवर नै चाळीस साल कै खात्तर बिन्‍यामीन के गोत्र म्ह तै एक माणस, यानिके कीश के बेट्टे शाऊल ताहीं उनपै राजा ठहराया। ");
INSERT INTO bgc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","फेर परमेसवर नै शाऊल ताहीं पद तै हटाकै दाऊद ताहीं उनका राजा बणाया, जिसकै बारै म्ह उसनै गवाही दी, ‘मन्नै एक माणस यिशै का बेट्टा दाऊद, जो मेरी इच्छा कै मुताबिक मिलग्या सै, वोए मेरी सारी इच्छा पूरी करैगा।’” ");
INSERT INTO bgc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","इस्से पीढ़ी म्ह तै परमेसवर नै अपणे वादा कै मुताबिक इस्राएल कै धोरै एक उद्धारकर्ता, यानिके यीशु भेज्या। ");
INSERT INTO bgc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","यीशु कै आण तै पैहल्या यूहन्ना नै सारे इस्राएलियाँ नै अपणे पाप मान के परमेसवर की ओड़ मुड़ण का अर बपतिस्मा का प्रचार करया। ");
INSERT INTO bgc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जिब यूहन्ना अपणी सेवा पूरी करण पै था, तो उसनै कह्या, “थम मन्नै के समझो सो? मै मसीह कोनी! बल्के देक्खो, मेरै पाच्छै एक आण आळा सै, जो भोत महान् सै, जिसके जूत्याँ के फित्ते भी मै खोल्लण जोग्गा कोनी।” ");
INSERT INTO bgc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“हे भाईयो, थम जो अब्राहम की ऊलाद सो, अर थम गैर यहूदी जो परमेसवर तै डरो सो, थारे धोरै इस उद्धार का वचन भेज्या गया सै। ");
INSERT INTO bgc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरुशलेम नगर के रहणआळो अर उनकै सरदारां नै, ना मसीह यीशु ताहीं पिच्छाणा अर ना नबियाँ की बात समझी, जो हरेक आराम कै दिन पढ़ी जावै सै, ज्यांतै उस ताहीं कसूरवार ठहराकै उन बात्तां नै पूरा करया। ");
INSERT INTO bgc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","उननै मारण कै जोग्गा कोए कसूर उस म्ह कोनी पाया, फेरभी राज्यपाल पिलातुस तै बिनती करी, के वो मार दिया जावै। ");
INSERT INTO bgc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","जिब उननै उसकै बारै म्ह पवित्र ग्रन्थ लिक्खी होई सारी बात पूरी करी, तो उस ताहीं क्रूस पै तै उतारकै कब्र म्ह धरया। ");
INSERT INTO bgc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पर परमेसवर नै उस ताहीं मरे होया म्ह तै जिन्दा करया, ");
INSERT INTO bgc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","अर वो उन ताहीं जो उसकै गेल्या गलील परदेस तै यरुशलेम नगर आये थे, घणे दिनां ताहीं अपणे चेल्यां नै दिख्दा रहया, आदमियाँ कै स्याम्ही इब वैए उसके गवाह सै।” ");
INSERT INTO bgc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","हम थमनै उस वादा कै बारै म्ह जो बाप-दाद्या तै करया गया था, यो सुसमाचार सुणावां सां, ");
INSERT INTO bgc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","के परमेसवर नै यीशु ताहीं जिन्दा करकै, वोए वादा म्हारी ऊलाद कै खात्तर पूरा करया, जिसा के भजन संहिता दो म्ह लिख्या सै, “तू मेरा बेट्टा सै, आज तै ए मै तेरा पिता बणग्या सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","अर उसके इस तरियां तै मरे होया म्ह तै जिन्दा होण कै बारै म्ह भी के वो कदे न्ही सड़ै, परमेसवर नै यो कह्या सै, “मै दाऊद पै की पवित्र अर अटल दया तेरे पै करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","दाऊद नै और जगहां भी भजन संहिता म्ह भी लिख्या सै, “तू अपणे पवित्र माणस नै सड़ण न्ही देवैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","दाऊद तो परमेसवर की मर्जी कै मुताबिक अपणे बखत म्ह सेवा करकै मर गया, अर अपणे बाप-दाद्या म्ह जा मिल्या, अर सड़ भी गया। ");
INSERT INTO bgc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पर जिस ताहीं परमेसवर नै जिन्दा करया, वो सड़ण कोनी पाया। ");
INSERT INTO bgc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ज्यांतै, हे भाईयो, थम जाण ल्यो के इस्से के जरिये पापां की माफी का सुसमाचार थारे ताहीं दिया जावै सै, ");
INSERT INTO bgc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","अर पापां तै मुक्त करण म्ह मूसा नबी के नियम-कायदे हमेशा नाकामयाब रहे सै, हरेक जो बिश्वास करै सै, वो यीशु के जरिये सारे पापां तै मुक्त करया जावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ज्यांतै चौकन्ने रहो, इसा ना हो के जो नबियाँ की किताब म्ह आया सै, थारे पै भी आण पड़ै ");
INSERT INTO bgc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“हे बुराई करण आळो, देक्खो, अर हैरान होवो, अर मिट जाओ, क्यूँके मै थारे दिनां म्ह एक काम करुँ सूं, ‘इसा काम के जै कोए थारे तै उसका जिक्र करै, तो थम भी बिश्वास कोनी करोगे।’” ");
INSERT INTO bgc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","जिब पौलुस अर बरनबास यहूदी सभाघर तै बाहरणै लिकड़ण लागरे थे, तो माणस उनतै बिनती करण लाग्गे के आगले आराम कै दिन म्हारै ताहीं ये बात फेर सुणाई जावै। ");
INSERT INTO bgc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","जिब सभा उठ ली फेर भोत-से यहूदी अर यहूदी पंथ म्ह आये होए भगतां म्ह तै घणखरे पौलुस अर बरनबास कै पाच्छै हो लिये, अर उननै उन ताहीं बात करकै समझाया के परमेसवर कै अनुग्रह म्ह बणे रहो। ");
INSERT INTO bgc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","आगले आराम कै दिन नगर के तकरीबन सारे लोग परमेसवर का वचन सुणण नै कठ्ठे हो गये। ");
INSERT INTO bgc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","पर यहूदी भीड़ नै देखकै मन ए मन म्ह जळण लाग्गे, अर बुराई करदे होए पौलुस की बात्तां कै बिरोध म्ह बोल्लण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","फेर पौलुस अर बरनबास हिम्मत करकै कहण लाग्गे, “जरूरी था के परमेसवर का वचन पैहल्या थारे तै सुणाया जान्दा, इब जिब के थमनै इस ताहीं नकार दिया सै, अर यो करते होए अपणे-आप ताहीं अनन्त जीवन कै खात्तर अयोग्य घोषित कर दिया सै, तो देक्खो, हम गैर यहूदियाँ कै कान्ही फिरां सां। ");
INSERT INTO bgc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","क्यूँके प्रभु नै म्हारै ताहीं यो हुकम दिया सै, ‘मन्नै तेरे ताहीं गैर यहूदियाँ कै खात्तर चाँदणा ठहराया, ताके तू धरती कै छोर ताहीं उद्धार का दरबाजा हो।’” ");
INSERT INTO bgc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","न्यू सुणकै गैर यहूदी राज्जी होए, अर परमेसवर कै वचन की बड़ाई करण लाग्गे, अर जितने अनन्त जीवन कै खात्तर ठहराए गये थे, उननै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","फेर प्रभु का वचन उस सारे देश म्ह फैलाण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","पर यहूदी अगुवां नै भगत अर आच्छे खानदान की लुगाईयाँ ताहीं अर नगर के खास आदमियाँ ताहीं उकसाया, अर पौलुस अर बरनबास कै खिलाफ दंगा करा कै उन ताहीं अपणी सीमा तै लिकाड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","फेर पौलुस अर बरनबास उनकै स्याम्ही पायां की धूळ झाड़कै इकुनियुम नगर म्ह चले गये। ");
INSERT INTO bgc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","अर चेल्लें आनन्द अर पवित्र आत्मा तै भरदे चले गये। ");
INSERT INTO bgc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनियुम नगर म्ह इसा होया के वे यहूदियाँ के आराधनालय म्ह गैल-गैल गये, अर इस ढाळ बात करी के यहूदियाँ अर यूनानियाँ म्ह घणखरयां नै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पर बिश्वास ना करण आळे गैर यहूदियाँ के मन बिश्वासी भाईयाँ कै बिरोध म्ह उकसाये अर कडुवापण पैदा करया। ");
INSERT INTO bgc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","पौलुस अर बरनबास घणे दिन ताहीं उड़ै रहे, अर प्रभु कै भरोसै पै हिम्मत तै बात करै थे, अर वो उनकै हाथ्थां तै चमत्कार अर अनोक्खे काम करवा कै अपणे अनुग्रह के वचन ताहीं साबित करदा रह्या। ");
INSERT INTO bgc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पर नगर के लोग्गां म्ह फूट पड़गी थी, इसतै घणेए तो यहूदियाँ कान्ही अर घणेए प्रेरितां कान्ही होग्ये। ");
INSERT INTO bgc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","जिब गैर यहूदी अर यहूदी उनकी बेजती करण नै अर उनकै पत्थर मारण कै खात्तर अपणे सरदारां सुधा उन कान्ही भाज्जे, ");
INSERT INTO bgc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","फेर वे इस बात नै जाणगे अर लुकाउनिया परदेस के लुस्त्रा अर दिरबे नगरां म्ह, अर लोवै-धोरै के परदेसां म्ह भाजगे ");
INSERT INTO bgc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","अर ओड़ै सुसमाचार सुणाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्त्रा नगर म्ह एक माणस बेठ्या था, जो पायां तै लाचार था। वो जन्म तै ए लंगड़ा था, अर कदे न्ही चाल्या था। ");
INSERT INTO bgc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","वो पौलुस नै बात करदे सुणै था। पौलुस नै उसकी ओड़ टकटकी लाकै देख्या के उसनै ठीक होण का बिश्वास सै, ");
INSERT INTO bgc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अर ठाड्डू आवाज म्ह बोल्या, “अपणे पायां कै बळ सीध्धा खड्या हो।” फेर वो उछळकै चाल्लण-फिरण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","लोग्गां नै पौलुस का यो काम देखकै लुकाउनिया की भाषा म्ह ठाड्डू आवाज म्ह कह्या, “देवता माणस कै रूप म्ह होकै म्हारै धोरै उतर आये सै।” ");
INSERT INTO bgc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","उननै बरनबास ताहीं ज्यूस देवता, अर पौलुस ताहीं हिरमेस कह्या क्यूँके वो खास संदेश देण आळा था। ");
INSERT INTO bgc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ज्यूस देवता के उस मन्दर का पुजारी जो उनकै नगर कै स्याम्ही था, बळध अर फूल्लां के हार फाटकां पै ल्याकै लोग्गां कै गेल्या बलिदान करणा चाहवै था। ");
INSERT INTO bgc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पर बरनबास अर पौलुस प्रेरितां नै जिब यो सुण्या, तो अपणे लत्ते पाड़े अर भीड़ म्ह लपके, अर रुक्का मारकै कहण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“हे भले माणसों, थम के करो सो? हम भी तो थारे तरियां दुख-सुख भोग्गण आळे माणस सां, अर थमनै सुसमाचार सुणावां सां के थम इन बेकार चिज्जां तै न्यारे होकै जिन्दे परमेसवर कै कान्ही फिरो, जिसनै सुर्ग अर धरती अर समुन्दर अर जो किमे उन म्ह सै बणाया सै। ");
INSERT INTO bgc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","उसनै बीत्ते होए बखत म्ह सारी जात्तां ताहीं अपणे-अपणे रास्तयां पै चाल्लण दिया। ");
INSERT INTO bgc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","फेर भी वो अपणे भले काम करण के जरिये अपणे बारें म्ह गवाही देंदा रहया, अर अकास तै मिह अर फळआळी ऋतु देकै थारे मन नै खाणे अर खुशी तै भरदा रहया।” ");
INSERT INTO bgc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","न्यू कहकै भी उननै लोग्गां ताहीं बड्डी मुश्किलां तै रोक्या के उनकै खात्तर बलिदान ना करै। ");
INSERT INTO bgc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","पर कुछ यहूदियाँ नै अन्ताकिया नगर अर इकुनियुम नगर तै आकै लोग्गां ताहीं अपणी ओड़ कर लिया, अर पौलुस पै पत्थर बरसाए, अर मरया होड़ सोचकै उस ताहीं नगर कै बाहरणै घसीट लेगे। ");
INSERT INTO bgc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पर चेल्लें जिब उसकै चौगरदेकै आण खड़े होए, तो वो उठकै नगर म्ह गया अर दुसरे दिन बरनबास कै गेल्या दिरबे नगर कान्ही चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","वे उस नगर के लोग्गां ताहीं सुसमाचार सुणाकै अर घणे चेल्लें बणाकै, लुस्त्रा अर इकुनियुम अर अन्ताकिया नगर नै बोहड़ आये, ");
INSERT INTO bgc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","अर चेल्यां के मनां नै स्थिर करदे अर उत्साहित करते होए या शिक्षा देते रह्ये के बिश्वास म्ह बणे रहो, अर न्यू कहवै थे, “हमनै घणे दुख ठाकै परमेसवर के राज्य म्ह बड़णा होगा।” ");
INSERT INTO bgc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","अर उननै हरेक कलीसिया म्ह उनकै खात्तर अगुवें ठहराए, अर ब्रत सुधा प्रार्थना करकै उन ताहीं प्रभु कै हाथ्थां म्ह सौप्या जिसपै उननै बिश्वास करया था। ");
INSERT INTO bgc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","फेर पिसिदिया परदेस तै होन्दे होए वे पंफूलिया परदेस पोहचे, ");
INSERT INTO bgc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","फेर पिरगा नगर म्ह वचन सुणाकै अत्तलिया नगर म्ह आये, ");
INSERT INTO bgc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","अर ओड़ै तै वे पाणी के जहाज तै अन्ताकिया नगर गये, जित्त वे उस काम कै खात्तर जो उननै पूरा करया था परमेसवर के अनुग्रह म्ह सौपे गये थे। ");
INSERT INTO bgc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","अन्ताकिया नगर पोहचकै उननै कलीसिया कठ्ठी करी अर बताया के परमेसवर नै उनकै गेल्या होकै किसे बड़े-बड़े काम करे, अर गैर यहूदियाँ कै खात्तर बिश्वास का बारणा खोल दिया। ");
INSERT INTO bgc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","अर वे चेल्यां कै गेल्या घणे दिन ताहीं रहे। ");
INSERT INTO bgc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","फेर कुछ यहूदी बिश्वासी यहूदिया परदेस तै आकै भाईयाँ नै सिखाण लाग्गे “जै मूसा नबी की रीत पै थारा खतना न्ही हो तो थम उद्धार कोनी पा सकदे।” ");
INSERT INTO bgc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","जिब पौलुस अर बरनबास का उनतै घणा वाद-विवाद अर बहस होई तो यो फैसला लिया गया के पौलुस अर बरनबास अर उन म्ह तै कुछ माणस इस बात कै बारै म्ह प्रेरितां अर कलीसिया के अगुवां कै धोरै यरुशलेम नगर म्ह जावै। ");
INSERT INTO bgc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","कलीसिया नै उन ताहीं बिदा करया, अर वे फीनीके अर सामरिया परदेसां तै होन्दे होए गैर यहूदियाँ के जरिये यीशु मसीह पै बिश्वास करण का जिक्र करते गये, जिसतै सारे बिश्वासी भाई घणे राज्जी होए। ");
INSERT INTO bgc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जिब वे यरुशलेम नगर पोहचे, तो कलीसिया अर प्रेरित अर कलीसिया के अगुवें उनतै खुशी कै गैल मिले, अर पौलुस अर बरनबास नै बताया के परमेसवर नै उनकै गेल्या होकै किसे-किसे काम करे थे। ");
INSERT INTO bgc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पर फरीसियाँ के पंथ म्ह तै जिन नै बिश्वास करया था, उन म्ह तै कितन्याँ नै उठकै कह्या, “गैर यहूदियाँ ताहीं खतना कराण अर मूसा नबी के नियम-कायदे नै मानण का हुकम देणा चाहिए।” ");
INSERT INTO bgc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","फेर प्रेरित अर कलीसिया के अगुवें इस बात कै बारै म्ह विचार करण कै खात्तर कठ्ठे होए। ");
INSERT INTO bgc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","फेर पतरस नै घणी बहस हो जाणकै पाच्छै खड़े होकै उनतै कह्या, “हे भाईयो, थमनै बेरा सै के घणे दिन होए परमेसवर नै थारे म्ह तै मेरै ताहीं छाँट लिया के मेरै मुँह तै गैर यहूदी सुसमाचार का वचन सुणकै बिश्वास करै। ");
INSERT INTO bgc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","मन कै जाँचण आळे परमेसवर नै उन ताहीं भी म्हारै की तरियां पवित्र आत्मा देकै यो बताया सै के वे सब भी उसके माणस सै, ");
INSERT INTO bgc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","अर बिश्वास कै जरिये उनके मन शुद्ध करकै म्हारै म्ह अर उन म्ह किमे फर्क कोनी राख्या। ");
INSERT INTO bgc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","तो इब थम क्यांतै परमेसवर नै परखो सों, ताके गैर यहूदी चेल्यां के कंध्या पै इसा जूआ धरो, जिसनै ना म्हारे बाप-दाद्दे ठा सकै थे अर ना हम ठा सकां सां? ");
INSERT INTO bgc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","हाँ, म्हारा यो यकिन सै के जिस तरियां तै वे प्रभु यीशु कै अनुग्रह तै उद्धार पावैंगें, उस्से तरियां तै हम भी पावागें।” ");
INSERT INTO bgc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","फेर सारी सभा चुपचाप बरनबास अर पौलुस की सुणण लाग्गी, के परमेसवर नै उनकै जरिये गैर यहूदियाँ म्ह किसे बड़े-बड़े चमत्कार, अर अनोक्खे काम दिखाए। ");
INSERT INTO bgc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","उनके भाषण के खतम होण पै याकूब सभा ताहीं कहण लाग्या, “हे भाईयो, मेरी सुणो।” ");
INSERT INTO bgc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","शमौन पतरस नै बताया के परमेसवर नै पैहले-पहल गैर यहूदियाँ पै किसी दया की निगांह करी के उन म्ह तै अपणे नाम कै खात्तर एक प्रजा बणा ले। ");
INSERT INTO bgc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","नबियाँ लेख भी इस बात का समर्थन करै सै, जिसा के पवित्र ग्रन्थ म्ह लिख्या सै ");
INSERT INTO bgc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“इसकै पाच्छै मै फेर आकै दाऊद का पड्या होड़ डेरा उठाऊँगा, अर उसके खण्डरां नै दुबारा बणाऊँगा, अर उस ताहीं खड्या करुँगा,” ");
INSERT INTO bgc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","जिसके कारण बाकी की बची होड़ मानवजात्ति परमेसवर नै पा सकै, अर वे सारी गैर यहूदी भी, जिनपै मेरै नाम की छाप लाग्गी सै, प्रभु नै टोहवैं, ");
INSERT INTO bgc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","यो वोए प्रभु कहवै सै जो दुनिया की शरुआत तै इन बात्तां की खबर देंदा आया सै। ");
INSERT INTO bgc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ज्यांतै मेरा विचार यो सै के हम उन गैर यहूदियाँ खात्तर कोए मुसीबत पैदा ना करा, जो परमेसवर कै कान्ही फिरै सै, हम उन ताहीं दुख ना देवां, ");
INSERT INTO bgc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पर आच्छा तो यो होगा के हम उन ताहीं यो हुकम लिख भेज्जा, के वे मूर्तियाँ नै चढ़ाण आळी चिज्जां अर जारी अर गळा घोट्टे होया के माँस तै अर लहू तै दूर रहवै। ");
INSERT INTO bgc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","क्यूँके गुजरे बखत तै नगर-नगर मूसा नबी के नियम-कायदे का प्रचार करण आळे होन्दे चले आये सै, अर वा हरेक आराम कै दिन आराधनालय म्ह पढ़ी जावै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","फेर सारी कलीसिया सुधा प्रेरितां अर कलीसिया के अगुवां नै आच्छा लाग्या के अपणे म्ह तै कुछ माणसां नै चुणै, यानिके यहूदा जो बरसब्बा कुह्वावै सै, अर सीलास ताहीं जो भाईयाँ म्ह मुखिया थे, अर उन ताहीं पौलुस अर बरनबास कै गेल्या अन्ताकिया नगर खन्दावै। ");
INSERT INTO bgc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","उननै उनकै हाथ या चिट्ठी लिख भेजी “अन्ताकिया नगर, सीरिया अर किलिकिया परदेस के रहण आळे भाईयाँ नै जो गैर यहूदियाँ म्ह तै सै, प्रेरितां अर कलीसिया के अगुवें भाईयाँ का नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","हमनै सुण्या सै के म्हारै म्ह तै कुछां नै ओड़ै जाकै, थारे ताहीं अपणी बात्तां तै डरा दिया, अर थारे मन उल्ट दिये सै पर हमनै उन ताहीं हुकम कोनी दिया था। ");
INSERT INTO bgc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","इस करकै हमनै एक चित्त होकै ठीक जाण्या के छाँटे होड़ माणसां ताहीं अपणे प्यारे बरनबास अर पौलुस कै गेल्या थारे धोरै भेज्जा। ");
INSERT INTO bgc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ये इसे माणस सै जिन नै अपणी ज्यांन म्हारै प्रभु यीशु मसीह कै नाम कै खात्तर जोख्खम म्ह गेरी सै। ");
INSERT INTO bgc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ज्यांतै हमनै यहूदा अर सीलास ताहीं भेज्या सै, के थम खुद उनकै ए मुँह तै इस बारें म्ह सुण सको। ");
INSERT INTO bgc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पवित्र आत्मा नै अर हमनै ठीक जाण पाट्टी के इन जरूरी बात्तां नै छोड़, थारे पै और बोझ ना गेरै, ");
INSERT INTO bgc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","के थम मूर्तियाँ पै बलि करे होया तै अर लहू तै, अर गळा घोट्टे होए पशुआं के माँस तै, अर जारी तै दूर रहो। इनतै दूर रहो तो थारा भला होगा। बाकी सब ठीक-ठाक सै।” ");
INSERT INTO bgc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","फेर वे बिदा होकै अन्ताकिया नगर पोहचे, अर सभा नै कठ्ठी करकै वा चिट्ठी उन ताहीं दे दी। ");
INSERT INTO bgc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","वे चिट्ठी पढ़कै उस उपदेश की बात तै घणे राज्जी होए। ");
INSERT INTO bgc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदा अर सीलास नै जो आप भी नबी थे, घणी बात्तां तै बिश्वासी भाईयाँ ताहीं उपदेश देकै पक्का करया। ");
INSERT INTO bgc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","वे कुछे दिन रहकै, बिश्वासी भाईयाँ तै शान्ति कै गेल्या बिदा होए के अपणे खन्दाण आळा कै धोरै जावै। ");
INSERT INTO bgc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(पर सीलास नै ओड़ै रहणा आच्छा लाग्या।) ");
INSERT INTO bgc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पर पौलुस अर बरनबास अन्ताकिया नगर म्ह रह गये अर और घणखरे आदमियाँ कै गेल्या प्रभु यीशु कै वचन का उपदेश करदे अर सुसमाचार सुणान्दे रहे। ");
INSERT INTO bgc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","कुछे दिनां पाच्छै पौलुस नै बरनबास तै कह्या, “जिन-जिन नगरां म्ह हमनै प्रभु का वचन सुणाया था, आओ, फेर उन म्ह चालकै अपणे बिश्वासी भाईयाँ ताहीं देक्खै के वे किस तरियां सै।” ");
INSERT INTO bgc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","फेर बरनबास नै यूहन्ना ताहीं जो मरकुस कुह्वावै सै, गेल्या लेण का विचार करया। ");
INSERT INTO bgc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पर पौलुस नै उस ताहीं जो पंफूलिया परदेस म्ह उनतै न्यारा होग्या था, अर काम पै उनकै गेल्या कोनी गया, गेल्या ले जाणा ठीक कोनी समझया। ");
INSERT INTO bgc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","आखर म्ह इसा वाद-विवाद होया के वे एक-दुसरे तै न्यारे पाटगे, अर बरनबास, मरकुस नै लेकै जहाज पै साइप्रस टापू चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पर पौलुस नै सीलास ताहीं छाँट लिया, अर बिश्वासी भाईयाँ तै परमेसवर कै अनुग्रह म्ह सौंप्या जाकै ओड़ै तै चल्या गया, ");
INSERT INTO bgc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","अर वो कलीसियाओं ताहीं स्थिर करदा होया सीरिया अर किलिकिया परदेस तै होन्दे होए लिकड़या। ");
INSERT INTO bgc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","फेर वो दिरबे अर लुस्त्रा नगर म्ह भी गया। ओड़ै तीमुथियुस नाम का एक चेल्ला था, उसकी माँ एक यहूदी बिश्वासी थी, पर उसका बाप यूनानी था। ");
INSERT INTO bgc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","वो लुस्त्रा अर इकुनियुम नगर के भाईयाँ म्ह उसका आच्छा नाम था। ");
INSERT INTO bgc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुस की मर्जी या थी के वो उसके गेल्या जावै, अर जो यहूदी माणस उन जगहां म्ह थे उनकै कारण उननै उनका खतना करया, क्यूँके वे सारे जाणै थे, के उनका बाप यूनानी था। ");
INSERT INTO bgc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","पौलुस अर उसका साथी नगर-नगर जान्दे होड़ चेल्यां ताहीं वे सारे हुकम सौपते जावै थे, जो यरुशलेम नगर के प्रेरितां अर कलीसिया के अगुवां नै तय करी थी। ");
INSERT INTO bgc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","इस तरियां कलीसिया बिश्वास म्ह पक्की होंदी गई अर गिणती दिन-ब-दिन बधती गई। ");
INSERT INTO bgc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","वे फ्रुगिया अर गलातिया परदेसां म्ह तै होकै गये, क्यूँके पवित्र आत्मा नै उननै आसिया परदेस म्ह वचन सुणाण तै मना करया। ");
INSERT INTO bgc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","उननै मूसिया परदेस कै लोवै पोहचकै, बिथुनिया परदेस म्ह जाणा चाह्या, पर पवित्र आत्मा नै उन ताहीं जाण कोनी दिया। ");
INSERT INTO bgc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","आखर म्ह वे मूसिया परदेस तै होकै त्रोआस म्ह आये। ");
INSERT INTO bgc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ओड़ै पौलुस नै रात नै दर्शन देख्या के एक मकिदुनिया परदेस का माणस खड्या होया उनतै बिनती करकै कहण लागरया सै, “पार उतरकै मकिदुनिया परदेस म्ह आ, अर म्हारी मदद कर।” ");
INSERT INTO bgc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","उसकै यो दर्शन देखदे हमनै जिब्बे मकिदुनिया परदेस जाणा चाह्या, न्यू सोचकै के परमेसवर नै म्हारै ताहीं उनतै सुसमाचार सुणाण कै खात्तर बुलाया सै। ");
INSERT INTO bgc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","इस करकै त्रोआस नगर तै जहाज खोल कै हम सीध्धे सुमात्राके टापू अर दुसरे दिन नियापुलिस नगर म्ह आये। ");
INSERT INTO bgc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ओड़ै तै हम फिलिप्पी नगर पोहचे, जो मकिदुनिया परदेस का खास नगर अर रोमियों का मोहल्ला सै, अर हम उस नगर कुछे दिन रहे। ");
INSERT INTO bgc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","आराम कै दिन हम नगर कै फाटक कै बाहरणै नदी कै किनारे न्यू सोचकै गये के ओड़ै प्रार्थना करण की जगहां होगी, अर बैठकै उन लुगाईयाँ तै जो कठ्ठी होई थी, बतळाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","थुआतीरा नगर की बैंजनी लत्ते बेचण आळी एक लुदिया नाम की परमेसवर की भगतणी उनकी बात सुणण लागरी थी। प्रभु नै उसका मन खोल्या ताके वा पौलुस की बात्तां पै मन लगावै। ");
INSERT INTO bgc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","जिब उसनै अपणे कुण्बे सुधा बपतिस्मा लिया, तो उसनै म्हारै तै बिनती करी, “जै थम मन्नै प्रभु की बिश्वासिणी समझो सो, तो चालकै मेरै घर म्ह रहो,” अर वा हमनै मनाकै ले गई। ");
INSERT INTO bgc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","जिब हम प्रार्थना करण की जगहां पै जाण लागरे थे, तो हमनै एक कम उम्र की दास्सी मिली जिसम्ह भविष्य बताण आळी आत्मा थी, अर वा भविष्य बताकै अपणे मालिकां कै खात्तर घणाए कमा लेवै थी। ");
INSERT INTO bgc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","वा पौलुस कै अर म्हारै पाच्छै आकै नै किल्की मारण लाग्गी, “ये माणस परमप्रधान परमेसवर के दास सै, जो म्हारै ताहीं उद्धार के राह की कथा सुणावै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","वा घणे दिनां ताहीं न्यूए कर दी रही, पर पौलुस परेशान होग्या, अर बोहड़कै उस ओपरी आत्मा तै बोल्या, “मै तन्नै यीशु मसीह कै नाम तै हुकम दियुँ सूं के उस म्ह तै बाहरणै लिकड़ जा।” अर वा उस्से बखत लिकड़गी। ");
INSERT INTO bgc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जिब उसके मालिकां नै देख्या के म्हारी कमाई की आस खतम होग्यी, तो पौलुस अर सीलास नै पकड़कै चौक म्ह प्रधानां कै धोरै खींच ल्याए, ");
INSERT INTO bgc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","अर उन ताहीं न्यायाधीश कै धोरै ल्याए अर बोल्ले, “ये माणस जो यहूदी सै, म्हारे नगर म्ह दंगा मचाण लागरे सै, ");
INSERT INTO bgc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","अर इसे रीति-रिवाज बतावै सै, जिन ताहीं हम रोमियाँ कै खात्तर अपणाना सही कोनी।” ");
INSERT INTO bgc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","फेर भीड़ के माणस उनकै बिरोध म्ह कठ्ठे होकै उनपै चढ़ याए, अर हाकिमां नै उनके लत्ते पाड़कै उतार दिये, अर उनकै बैत मारण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","घणी बैत मारे पाच्छै उननै उन ताहीं जेळ म्ह गेर दिया अर दरोग्गा ताहीं हुकम दिया के उननै चौक्कस राखिये। ");
INSERT INTO bgc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","उसनै इसा हुकम पाकै उन ताहीं भित्तरली कोठड़ी म्ह राख्या अर उनके पाँ काठ की बेड़ियाँ तै जकड़ दिये। ");
INSERT INTO bgc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","आध्धी रात कै बखत पौलुस अर सीलास प्रार्थना करदे होए परमेसवर के भजन गाण लागरे थे, अर कैदी उनकी सुणण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","इतनै म्ह चाणचक बड्ड़ा हाल्लण आ ग्या, उरै ताहीं के जेळ की नीम भी हालगी, अर जिब्बे सारे दरबाजे खुलगे, अर सारया के बन्धन खुलकै पड़गे। ");
INSERT INTO bgc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","दरोग्गा जागग्या, अर जेळ के दरबाजे खुल्ले देखकै समझ गया के कैदी भाजगे सै, इस करकै उसनै तलवार खिंचकै खुद ताहीं मारणा चाह्या। ");
INSERT INTO bgc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पर पौलुस नै ठाड्डू आवाज म्ह रुक्का मारया, “अपणे-आपनै किमे नुकसान ना पोहोचाइये, क्यूँके हम सारे उरैए सां।” ");
INSERT INTO bgc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","फेर दरोग्गा दिवां मँगाकै भित्तर आया, अर काम्बदा होया पौलुस अर सीलास कै आग्गै पड्या, ");
INSERT INTO bgc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","अर उन ताहीं बाहरणै ल्याकै बोल्या, “हे भले माणसों, उद्धार पाण कै खात्तर मै के करुँ?” ");
INSERT INTO bgc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","उननै कह्या, “प्रभु यीशु मसीह पै बिश्वास कर, तो तू अर तेरा कुण्बा उद्धार पावैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","अर उननै उस ताहीं अर उसके सारे घर के माणसां ताहीं प्रभु का वचन सुणाया। ");
INSERT INTO bgc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","रात नै उस्से बखत उसनै उन ताहीं ले जाकै उनके घाव धोये, अर उसनै अपणे सारे माणसां सुधा जिब्बे बपतिस्मा लिया। ");
INSERT INTO bgc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","फेर दरोग्गै नै उन ताहीं अपणे घरां ले जाकै उनकै आग्गै खाणा धरया, अर साब्ते कुण्बे सुधा परमेसवर पै बिश्वास करकै आनन्द करया। ");
INSERT INTO bgc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","आगले दिन फेर हाकिमां नै सिपाहियाँ के हाथ्थां कहवां भेज्या के उन माणसां नै छोड़ द्यो। ");
INSERT INTO bgc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","दरोग्गै नै ये बात पौलुस तै कही, “हाकिमां नै थारे ताहीं छोड़ देण का हुकम दिया सै। ज्यांतै इब खुश होकै जाओ।” ");
INSERT INTO bgc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पर पौलुस नै उनतै कह्या, “उननै म्हारै ताहीं जो रोमी माणस सै, कसूरवार ठहराए बिना माणसां कै स्याम्ही मारया अर जेळ म्ह गेरया। इब के हमनै बोल-बाल्ले लिकाड़ण लागरे सै? इसा कोनी, पर वे खुद आकै हमनै बाहरणै लिकाड़ै।” ");
INSERT INTO bgc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाहियाँ नै ये बात हाकिमां तै कही, अर वे न्यू सुणकै के वे रोम के बासिन्दे सै, डरगे, ");
INSERT INTO bgc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","अर आकै उन ताहीं मनाया, अर बाहरणै ले जाकै बिनती करी के नगर चले जाओ। ");
INSERT INTO bgc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","वे जेळ तै लिकड़कै लुदिया कै उरै गये, अर बिश्वासी भाईयाँ तै भेंट करकै उन ताहीं शान्ति देई, अर चले गये। ");
INSERT INTO bgc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पौलुस अर सीलास अम्फिपुलिस अर अपुल्लोनिया नगरां तै होकै थिस्सलुनीके नगर म्ह आये, जित्त यहूदियाँ का एक आराधनालय था। ");
INSERT INTO bgc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पौलुस अपणी रीत कै मुताबिक उनकै धोरै गया, अर तीन्नु आराम कै दिनां म्ह पवित्र ग्रन्थ म्ह तै उनकै गेल्या बहस करी, ");
INSERT INTO bgc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","अर वो उनका मतलब खोल-खोल कै समझावै था के मसीह नै दुख ठाणा, अर मरे होया म्ह तै जिन्दा उठणा, जरूरी था, अर “योए यीशु जिसकी मै थमनै कथा सुणाऊँ सूं, मसीह सै।” ");
INSERT INTO bgc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","कितने यहूदी अर परमेसवर के भगत यूनानियाँ म्ह तै घणखरयां नै, अर घणी आच्छे खानदान की लुगाईयाँ नै मान लिया, अर पौलुस अर सीलास कै गेल्या मिलगे। ");
INSERT INTO bgc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पर यहूदियाँ नै जळण तै भरकै बाजारू माणसां म्ह तै कुछ दुष्ट माणसां ताहीं अपणे गेल्या लिया, अर भीड़ कठ्ठी करकै नगर म्ह दंगा मचाण लाग्गे, अर यासोन कै घर पै चढ़ाई करकै उन ताहीं आदमियाँ कै स्याम्ही ल्याणा चाह्या। ");
INSERT INTO bgc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","उननै जिब वे ओड़ै न्ही मिले तो वे किल्की मारदे होए यासोन अर कुछ बिश्वासी भाईयाँ ताहीं नगर के हाकिमां कै स्याम्ही खींच ल्याए, “ये माणस जिन नै दुनिया ताहीं उल्टा-पुल्टा कर दिया सै, उरै भी आ लिए सै। ");
INSERT INTO bgc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","यासोन नै उन ताहीं अपणे घरां रहण की इजाजत दी सै। ये सारे के सारे न्यू कहवै सै के यीशु राजा सै, अर कैसर के हुकमां का बिरोध करै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","उननै आदमियाँ ताहीं अर नगर के हाकिमां ताहीं न्यू सुणाकै डरा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ज्यांतै उननै यासोन अर बाकी माणसां तै जमानत पै उन ताहीं छोड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","बिश्वासी भाईयाँ नै जिब्बे राते-रात पौलुस अर सीलास ताहीं बिरीया नगर भेज दिया, अर वे ओड़ै पोहचकै यहूदियाँ के आराधनालय म्ह गये। ");
INSERT INTO bgc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ये माणस तो थिस्सलुनीके नगर के यहूदियाँ तै आच्छे थे, अर उननै घणे चाह् तै वचन अपणाया, अर हर-रोज पवित्र ग्रन्थां म्ह टोह्न्दे रहे के ये बात न्यू सै के न्ही। ");
INSERT INTO bgc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ज्यांतै उन म्ह तै घणखरयां नै, अर यूनानी आच्छे खानदान की बिरबानियाँ म्ह तै अर माणसां म्ह तै भी घणखरयां नै बिश्वास करया। ");
INSERT INTO bgc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","पर जिब थिस्सलुनीके नगर के यहूदी जाणगे के पौलुस बिरीया नगर म्ह भी परमेसवर का वचन सुणावै सै, तो ओड़ै भी माणसां ताहीं उकसाण अर गड़बड़ मचाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","फेर बिश्वासी भाईयाँ नै जिब्बे पौलुस ताहीं बिदा करया के समुन्दर कै किनारे चल्या जावै, पर सीलास अर तीमुथियुस बिरीया रहगे। ");
INSERT INTO bgc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पौलुस के मददगार उस ताहीं एथेंस नगर तक लेगे, अर सीलास अर तीमुथियुस कै खात्तर या आज्ञा पाकै बिदा होए के उसकै धोरै घणी तगाजै तै आवै। ");
INSERT INTO bgc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जिब पौलुस एथेंस नगर म्ह उसकी बाट देक्खै था, तो नगर नै मूर्तियाँ तै भरया होड़ देखकै भोत परेशान होग्या। ");
INSERT INTO bgc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","इस करकै वो आराधनालय म्ह यहूदियाँ तै अर भगतां तै, अर चौक म्ह जो माणस उसतै फेटै थे उनतै हरेक दिन बहस करया करै था। ");
INSERT INTO bgc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","फेर इपिकूरी अर स्तोईकी उपदेशकां म्ह तै कुछे उसतै तर्क करण लाग्गे, अर कुछां नै कह्या, “यो बकवादी के कहणा चाहवै सै?” पर दुसरयां नै कह्या, “वो दुसरे देवत्यां का प्रचारक दिक्खै सै” क्यूँके वो यीशु का अर पुनरुत्थान का सुसमाचार सुणावै था। ");
INSERT INTO bgc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","फेर वे उसनै अपणे गेल्या अरियुपगुस नामक आराधनालय म्ह लेगे अर बुझ्झया, “के हम जाण सकां सां के यो नया पंथ जो तू सुणावै सै, के सै? ");
INSERT INTO bgc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","क्यूँके तू अनोक्खी बात म्हारै ताहीं सुणावै सै, ज्यांतै हम जाणणा चाहवां सां के इनका के मतलब सै।” ");
INSERT INTO bgc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(ज्यांतै के सारे एथेंसवासी अर परदेशी जो ओड़ै रहवै थे, नयी-नयी बात कहण अर सुणण कै सिवाए और किसे काम म्ह बखत कोनी बितावैं थे।) ");
INSERT INTO bgc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","फेर पौलुस नै अरियुपगुस कै बिचाळै खड़े होकै कह्या, “हे एथेंस के माणसों, मै देक्खूँ सूं के थम हर बात म्ह देवत्यां के घणे मानण आळे सो। ");
INSERT INTO bgc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","क्यूँके मै हांडदे होए जिब थारी पूज्जण की चिज्जां नै देखण लागरया था, तो एक इसी वेदी भी मिली, जिसपै लिख्या था, ‘अनजाणे ईश्‍वर कै खात्तर।’ इस करकै जिसनै थम बिना बेरे पूज्जो सो, मै थमनै उस्से परमेसवर का सुसमाचार सुणाऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जिस परमेसवर नै धरती अर उसकी सारी चिज्जां ताहीं बणाया, वो सुर्ग अर धरती का माल्लिक होकै, हाथ के बणाए होड़ मन्दरां म्ह कोनी रहन्दा, ");
INSERT INTO bgc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","उसनै माणसां की जरूरत कोनी, क्यूँके वो तो खुदे सारया ताहीं जिन्दगी अर साँस अर सारा किमे देवै सै। ");
INSERT INTO bgc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","उसनै एक ए मूल तै माणसां की सारी जात सारी धरती पै रहण कै खात्तर बणाई सै, अर उनकै ठहराए होड़ बखत अर रहण या निवास की हदां ताहीं ज्यांतै बाँधया सै, ");
INSERT INTO bgc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","के वे परमेसवर नै टोहवै, कदाचित उस ताहीं टटोळकै पावै, फेरभी वो म्हारै म्ह तै किसे तै दूर कोनी। ");
INSERT INTO bgc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","क्यूँके उस्से म्ह म्हारा जीवन, चलणा-फिरणा अर म्हारी पहचान बणै सै, जिस ढाळ थारे कितने कवियाँ नै भी कह्या सै, “हम तो उस्से के वंशज सां।” ");
INSERT INTO bgc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“इस करकै म्ह परमेसवर का वंश होकै म्हारा यो समझणा सही कोनी के ईश्वरत्व सोन्ने-चाँदी, पत्थर के जिसा सै, जो माणसां की कारीगरी अर कल्पना तै गढ़े गये हों। ");
INSERT INTO bgc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ज्यांतै परमेसवर नै अज्ञानता के बखत पै खियास कोनी करी, पर इब हरेक जगहां सारे माणसां ताहीं पाप छोड़ण का हुकम देवै सै। ");
INSERT INTO bgc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","क्यूँके उसनै एक दिन तय करया सै, जिसम्ह वो धार्मिकता म्ह खुद के जरिये ठहराया गये उस माणस के जरिये दुनिया का न्याय करैगा, जिन ताहीं उसनै मरे होया म्ह तै दुबारा जिन्दा करकै या बात सारे माणसां के स्याम्ही साबित कर दी सै।” ");
INSERT INTO bgc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","मरे होया के पुनरुत्थान की बात सुणकै कुछ तो मखौल करण लाग्गे, अर कुछां नै कह्या, “या बात हम तेरे तै फेर कदे सुणांगें।” ");
INSERT INTO bgc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","इसपै पौलुस उनकै बिचाळै तै लिकड़ग्या। ");
INSERT INTO bgc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","पर कई माणस प्रभु यीशु कै गेल्या मिलगे, अर बिश्वास करया, जिन म्ह दियुनुसियुस जो अरियुपगुस का सदस्य था, अर दमरिस नामकी एक लुगाई थी, अर उनकै गेल्या कुछ और भी माणस थे। ");
INSERT INTO bgc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","इसकै पाच्छै पौलुस एथेंस नगर नै छोड़कै कुरिन्थुस नगर म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ओड़ै उसनै अक्विला नामक एक यहूदी मिल्या, जिसका जन्म पुन्तुस परदेस म्ह होया था। वो अपणी घरआळी प्रिसकिल्ला कै गेल्या इटली देश तै इब्बे आया था, क्यूँके सम्राट क्लौदियुस नै सारे यहूदियाँ ताहीं रोम तै लिकड़ जाण का हुकम दिया था। ज्यांतै वो उनकै उरै गया। ");
INSERT INTO bgc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","पौलुस अर अक्विला का एक ए काम-धन्धा था, इस करकै वो उनकै गेल्या रहया अर वे काम करण लाग्गे, अर उनका काम-धन्धा तम्बू बणाण का था। ");
INSERT INTO bgc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","पौलुस हरेक आराम कै दिन आराधनालय म्ह बहस करकै यहूदियाँ अर यूनानियाँ ताहीं भी समझावै था, के यीशु ए मसीह सै। ");
INSERT INTO bgc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जिब सीलास अर तीमुथियुस मकिदुनिया परदेस तै आये, तो पौलुस वचन सुणाण की धुन म्ह यहूदियाँ ताहीं गवाही देण लाग्या के यीशु ए मसीह सै। ");
INSERT INTO bgc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पर जिब यहूदी बिरोध अर बुराई करण लाग्गे, तो उसनै अपणे लत्यां तै धूळ झाड़कै उनतै कह्या, “इब जै परमेसवर थमनै इस पाप की सजा देवै तो उसकी मौत के जिम्मेदार थम खुदे हो! मै बेकसूर सूं। इब तै मै गैर यहूदियाँ कै धोरै जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","पौलुस यहूदी आराधनालय तै लिकड़कै वो तीतुस यूस्तुस नामक परमेसवर के एक भगत कै घरां आया, जिसका घर आराधनालय तै लाग्या होड़ था। ");
INSERT INTO bgc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","फेर आराधनालय के सरदार क्रिस्पुस नै अपणे सारे कुण्बे सुधा प्रभु पै बिश्वास करया, अर घणखरे कुरिन्थवासी सुणकै बिश्वास लाये, अर बपतिस्मा लिया। ");
INSERT INTO bgc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","प्रभु नै एक रात दर्शन कै जरिये पौलुस तै कह्या, “मतना डरै, बल्के कहे जा अर बोल-बाल्ला मतना रहवै, ");
INSERT INTO bgc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","क्यूँके मै तेरे गैल सूं, अर कोए तेरे पै चढ़ाई करकै तेरा नुकसान कोनी करैगा, क्यूँके इस नगर म्ह मेरे घणे माणस सै।” ");
INSERT INTO bgc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ज्यांतै पौलुस उन म्ह परमेसवर का वचन सिखान्दे होए डेढ़ साल ताहीं रहया। ");
INSERT INTO bgc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जिब गल्लियो अखाया परदेस का राज्यपाल था, तो यहूदी माणस एक्का करकै पौलुस पै चढ़ आये, अर उस ताहीं न्याय गद्दी कै स्याम्ही ल्याकै कहण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“यो माणसां नै समझावै सै, के परमेसवर की आराधना इस ढाळ तै करो, जो नियम-कायदे कै उल्ट सै।” ");
INSERT INTO bgc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","जिब पौलुस बोल्लण पैए था, तो गल्लियो नै यहूदियाँ ताहीं कह्या, “हे यहूदियों, जै या किमे अन्याय या दुष्टता की बात होन्दी, तो सही था के मै थारी सुणदा। ");
INSERT INTO bgc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पर जै या बहस शब्दां, अर नाम्मां, अर थारे उरै के नियम-कायदे कै बारै म्ह सै, तो थमे जाणो, क्यूँके मै इन बात्तां का न्यायाधीश कोनी बणणा चाहन्दा।” ");
INSERT INTO bgc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","अर उसनै उन ताहीं न्याय गद्दी कै स्याम्ही तै लिकाड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","जद सारे माणसां नै आराधनालय के सरदार सोस्थिनेस ताहीं पकड़कै न्याय गद्दी कै स्याम्ही मारया। पर गल्लियो नै इन बात्तां की भी किमे चिन्ता कोनी करी। ");
INSERT INTO bgc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौलुस घणे दिन ताहीं कुरिन्थुस नगर रहया। फेर बिश्वासी भाईयाँ तै बिदा होकै किंख्रिया बन्‍दरगाह म्ह ज्यांतै सिर मुण्डाया, क्यूँके उसनै मन्नत मान्नी थी, अर जहाज पै सीरिया परदेस नै चल्या गया अर उसकै गेल्या प्रिसकिल्ला अर अक्विला थे। ");
INSERT INTO bgc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","उसनै इफिसुस नगर पोहचकै उन ताहीं ओड़ै छोड्या, अर खुद आराधनालय म्ह जाकै यहूदियाँ तै बहस करण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","जिब माणसां नै उसतै बिनती करी, “म्हारै गेल्या कुछ और दिन रह।” तो उसनै कोनी मान्नी, ");
INSERT INTO bgc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पर न्यू कहकै उसतै बिदा होया, “जै परमेसवर नै चाह्या तो मै थारे धोरै फेर आऊँगा।” फेर वो इफिसुस नगर तै जहाज खोल कै चाल दिया, ");
INSERT INTO bgc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","अर कैसरिया नगर म्ह उतरकै (यरुशलेम नगर नै) गया अर कलीसिया ताहीं नमस्कार करकै अन्ताकिया नगर म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","फेर किमे दिन रहकै वो ओड़ै तै लिकड़या, अर एक और तै गलातिया अर फ्रुगिया परदेसां म्ह सारे चेल्यां ताहीं स्थिर करदा हांडया। ");
INSERT INTO bgc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अपुल्लोस नामक एक यहूदी, जिसका जन्म सिकन्दरिया नगर म्ह होया था, जो ज्ञान्नी माणस था अर पवित्र ग्रन्थ ताहीं आच्छी तरियां तै जाणै था, इफिसुस नगर म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","उसनै प्रभु कै राह की शिक्षा पाई थी, अर मन लाकै यीशु कै बारै म्ह सही-सही सुणावै अर सिखावै था, पर वो सिर्फ यूहन्ना कै बपतिस्मा की बात जाणै था। ");
INSERT INTO bgc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","वो आराधनालय म्ह बिना डरे बोल्लण लाग्या, पर प्रिसकिल्ला अर अक्विला उसकी बात सुणकै उस ताहीं अपणे उरै लेगे अर परमेसवर की राह उस ताहीं और भी सही-सही बताई। ");
INSERT INTO bgc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","जिब उसनै फैसला करया के पार उतरकै अखाया परदेस म्ह जावै तो बिश्वासी भाईयाँ नै उस ताहीं धीरज बन्धाकै चेल्यां ताहीं लिख्या के वे उसतै आच्छी ढाळ फेटै, अर उसनै ओड़ै पोहचकै उन माणसां की घणी मदद करी जिन नै अनुग्रह कै कारण बिश्वास करया था। ");
INSERT INTO bgc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","क्यूँके वो पवित्र ग्रन्थ तै सबूत दे-देकै के यीशु ए मसीह सै, घणे तावळेपण तै यहूदियाँ ताहीं सारया कै स्याम्ही निरुतर (बोलती बन्द) करदा रहया। ");
INSERT INTO bgc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","जिब अपुल्लोस कुरिन्थुस नगर म्ह था, तो पौलुस उप्पर के सारे परदेस तै होकै इफिसुस नगर म्ह आया। ओड़ै कई चेल्यां ताहीं मिल्या। ");
INSERT INTO bgc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","उनतै बोल्या, “के थमनै बिश्वास करदे बखत पवित्र आत्मा पाया था?” उननै उसतै कह्या, “हमनै तो पवित्र आत्मा का जिक्र भी कोनी सुण्या।” ");
INSERT INTO bgc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","पौलुस नै उनतै कह्या, “तो फेर थमनै किसका बपतिस्मा लिया?” वे बोल्ले, “यूहन्ना का बपतिस्मा।” ");
INSERT INTO bgc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पौलुस बोल्या, “यूहन्ना नै न्यू कह्या, के पाप करणा छोड़ दो, अर बपतिस्मा ल्यो, परमेसवर थारे पाप माफ कर देगा, अर जो मेरै पाच्छै आण आळा सै, उसपै बिश्वास करियो, यानिके यीशु पै।” ");
INSERT INTO bgc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","न्यू सुणकै उननै प्रभु यीशु कै नाम म्ह बपतिस्मा लिया। ");
INSERT INTO bgc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","जिब पौलुस नै उनपै हाथ धरे, तो पवित्र आत्मा उनपै उतरया, अर वे अन्य-अन्य भाषा बोल्लण अर भविष्यवाणी करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ये सारे करीबन बारहा माणस थे। ");
INSERT INTO bgc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","पौलुस आराधनालय म्ह जाकै तीन महिन्ने ताहीं बिना डरे होकै बोल्दा रहया, अर परमेसवर के राज्य कै बारै म्ह बहस करदा अर समझान्दा रहया। ");
INSERT INTO bgc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पर जो माणसां कठोर थे उननै उसका बिश्वास कोनी करया, बल्के माणसां कै स्याम्ही इस पंथ नै बुरा कहण लाग्गे, तो उसनै उन ताहीं छोड़ दिया अर चेल्यां ताहीं साथ लेकै तुरन्नुस की पाठशाला म्ह गये, जित्त वे रोज भीड़ तै परमेसवर के बारें म्ह बहस करया करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","दो साल ताहीं न्यूए होन्दा रहया, उरै ताहीं के आसिया परदेस के रहणीये के यहूदी के यूनानी सारया नै प्रभु का वचन सुण लिया। ");
INSERT INTO bgc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","परमेसवर नै पौलुस ताहीं अदभुत चमत्कार करण की सामर्थ दी। ");
INSERT INTO bgc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","उरै ताहीं के रूमाल अर अन्गोंछे उसकै गात तै छुआ कै बिमारां पै गेरै थे, अर उनकी बीमारी जान्दी रहवैं थी, अर भुंडी ओपरी आत्मा उन म्ह तै लिकड़ जाया करै थी। ");
INSERT INTO bgc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","पर कुछ यहूदी लोग जो झाड़ा-फूँक करदे हान्डै थे, न्यू करण लाग्गे के जिन म्ह भुंडी ओपरी आत्मा हो उनपै प्रभु यीशु का नाम न्यू कहकै फूँके, “जिस यीशु का प्रचार पौलुस करै सै, मै थारे ताहीं उस्से आदमी की कसम दियुँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","अर स्क्किवा नाम का एक यहूदी प्रधान याजक के सात बेट्टे थे, जो इस्से तरियां ए करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","पर भुंडी ओपरी आत्मा नै उन ताहीं जवाब दिया, “यीशु ताहीं मै जांणु सूं, अर पौलुस ताहीं भी पिच्छाणु सूं, पर थम कौण सो?” ");
INSERT INTO bgc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","अर उस माणस नै जिसम्ह भुंडी ओपरी आत्मा थी उनपै लपककै अर उन ताहीं बस म्ह करकै, उनपै इसा दुर्गति मचाया के वे उघाड़े अर घायल होकै उस घर तै लिकड़ भाज्जे। ");
INSERT INTO bgc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","या बात इफिसुस नगर के रहण आळे सारे यहूदी अर यूनानी भी जाणगे, अर वे सारे डरगे, अर प्रभु यीशु कै नाम की बड़ाई होई। ");
INSERT INTO bgc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","जिन नै बिश्वास करया था, उन म्ह तै घणखरयां नै आकै अपणे-अपणे काम्मां ताहीं मान लिया अर दिखा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","जादू करण आळा म्ह तै घणाए नै अपणी-अपणी सारी पोथी कठ्ठी करकै सारया कै स्याम्ही जळा दी, अर जिब उसका दाम जोड़या गया, तो पचास हजार चाँदी के सिक्के कै बराबर लिकड़या। ");
INSERT INTO bgc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","इस तरियां प्रभु का वचन सामर्थी तरिक्के तै फैलदा अर हावी होंदा गया। ");
INSERT INTO bgc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जिब ये बात हो ली तो पौलुस नै आत्मा म्ह ठाण लिया के मकिदुनिया अर अखाया परदेस तै होकै यरुशलेम नगर जाऊँ, अर बोल्या, “यरुशलेम जाणकै बाद मन्नै रोम ताहीं भी देखणा जरूरी सै।” ");
INSERT INTO bgc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","इस करकै अपणी सेवा करणीया म्ह तै तीमुथियुस अर इरास्तुस ताहीं मकिदुनिया परदेस भेजकै खुद किमे दिन आसिया परदेस म्ह रहग्या। ");
INSERT INTO bgc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","उस बखत उस पन्थ कै बारै म्ह घणा दंगा माच्या। ");
INSERT INTO bgc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","क्यूँके देमेत्रियुस नाम का एक सुनार अरतिमिस के चाँदी के मन्दर बणवाकै कारिगरां ताहीं घणा काम दुवाया करै था। ");
INSERT INTO bgc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","उसनै उन ताहीं अर इस्से तरियां की चिज्जां के कारिगरां ताहीं कठ्ठा करकै कह्या, “हे भाईयो, थमनै बेरा सै के इस काम तै हमनै कितना धन मिलै सै। ");
INSERT INTO bgc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","थम देक्खो अर सुणो सो के सिर्फ इफिसुस नगर म्ह ए कोनी, बल्के कई बर सारे आसिया परदेस म्ह न्यू कह-कहकै इस पौलुस नै घणे माणसां ताहीं समझाया अर भकाया भी सै, के जो हाथ की कारीगरी सै, वे ईश्‍वर कोनी। ");
INSERT INTO bgc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","इसतै इब सिर्फ इस्से बात का ए भय न्ही सै के म्हारै इस धन्धे की इज्जत-मान जान्दी रहवैगी, बल्के न्यू भी के महान् देवी अरतिमिस का मन्दर तुच्छ समझया जावैगा, अर जिस ताहीं सारा आसिया परदेस अर दुनिया पूज्जै सै उसका महत्व भी जान्दा रहवैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","कारीगर न्यू सुणकै खुन्दक तै भरगे अर किल्की मार-मारकै कहण लाग्गे, “इफिसियाँ की अरतिमिस देवी, महान् सै!” ");
INSERT INTO bgc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","अर सारे नगर म्ह घणा दंगा माचग्या, अर माणसां नै मकिदुनियावासी गयुस अर अरिस्तर्खुस ताहीं जो पौलुस के संगी मुसाफर थे, पकड़ लिया, अर एक सेत्ती रंगशाला म्ह भाजगे। ");
INSERT INTO bgc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","जिब पौलुस नै माणसां कै धोरै भीत्त्तर जाणा चाह्या तो चेल्यां नै उस ताहीं जाण न्ही दिया। ");
INSERT INTO bgc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","आसिया परदेस के हाकिमां म्ह तै भी उसके कई साथियाँ नै उसकै धोरै कहवां भेज्या अर बिनती करी के रंगशाला म्ह जाकै जोख्खम ना ठाईयो। ");
INSERT INTO bgc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","भीड़ म्ह तै कोए कुछ चिल्लावै था अर कोए कुछ, सारी भीड़ पूरी तरियां घबराई होई थी, अर घणखरे माणसां नै तो न्यूए कोनी बेरा था के वे क्यां खात्तर कठ्ठे होए सै। ");
INSERT INTO bgc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","फेर उननै सिकन्दर ताहीं, जिस ताहीं यहूदियाँ नै खड्या करया था, भीड़ म्ह आग्गै बढ़ाया। सिकन्दर हाथ तै इशारा करकै माणसां कै स्याम्ही जवाब देणा चाहवै था। ");
INSERT INTO bgc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पर जिब उननै बेरा लागग्या के वो यहूदी सै, तो सारे के सारे एक बोल म्ह कोए दो घंटे ताहीं चिल्लान्दे रहे, “इफिसियाँ की अरतिमिस देवी, महान् सै।” ");
INSERT INTO bgc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","फेर नगर के मन्त्री नै माणसां ताहीं शान्त करकै कह्या, “हे इफिसुस नगर के माणसों, किसनै न्ही बेरा के इफिसियाँ का नगर महान् अरतिमिस देवी के मन्दर, अर ज्यूस की ओड़ तै गिरी होड़ मूर्ति का टहलुआ सै।” ");
INSERT INTO bgc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","आखर म्ह जिब के इन बात्तां का खण्डन ए कोनी हो सकदा, तो सही सै के थम शान्त रहो अर बिना सोच्चे-समझे किमे ना करो। ");
INSERT INTO bgc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","क्यूँके थम इन माणसां नै ल्याए सो जो ना मन्दर के लुट्टण आळे सै अर ना म्हारी देवी के बुराई करणीये सै। ");
INSERT INTO bgc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","इस करकै देमेत्रियुस अर उसके मित्तर-कारिगरां ताहीं किसे तै एतराज हो तो कच्हेड़ी जा सकै सै अर हाकिम भी सै, वे एक-दुसरे पै दोष लावै। ");
INSERT INTO bgc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पर जै थम किसे और बात कै बारै म्ह किमे बुझणा चाहो सो, तो बखत पै सभा म्ह फैसला करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","आज की इस घटना कै कारण म्हारै पै उपद्रव का इल्जाम लाग्गण का खतरा सै, क्यूँके इसकै खात्तर कोए भी ठोस कारण दिखाई कोनी देंदा, “हम इस भीड़ के कठ्ठा होण का कोए जवाब कोनी दे सकांगें।” ");
INSERT INTO bgc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","न्यू कहकै उसनै सभा ताहीं बिदा करया। ");
INSERT INTO bgc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","जिब दंगा थम ग्या तो पौलुस नै चेल्यां ताहीं बुलाकै उत्साहित करया, अर उनतै बिदा होकै मकिदुनिया परदेस की ओड़ चाल दिया। ");
INSERT INTO bgc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","उस सारे परदेस म्ह तै होकै अर चेल्यां ताहीं घणा समझाकै वो यूनान देश म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","जिब तीन महिन्ने रहकै वो ओड़ै तै जहाज पै सीरिया परदेस की ओड़ जाण पै था, तो यहूदी अगुवें उसकी टाह म्ह लाग्गे, ज्यांतै उसनै निश्चय करया के मकिदुनिया परदेस होकै बोहड़ जावै। ");
INSERT INTO bgc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरीयावासी पुर्रुस का बेट्टा सोपत्रुस अर थिस्सलुनीकियों नगर म्ह तै अरिस्तर्खुस अर सिकुन्दुस, अर दिरबे नगर का गयुस, अर तीमुथियुस, अर आसिया परदेस का तुखिकुस अर त्रुफिमुस आसिया परदेस ताहीं उसकै गैल हो लिये। ");
INSERT INTO bgc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ये म्हारे मुसाफिर साथी म्हारे तै पैहले चले गये। ");
INSERT INTO bgc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","अर हम अखमीरी रोट्टी के त्यौहार के दिनां कै पाच्छै फिलिप्पी तै जहाज पै चढ़कै पाँच दिन म्ह त्रोआस म्ह उसकै धोरै पोहचे, अर सात दिन ताहीं रहे। ");
INSERT INTO bgc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हफ्तै के पैहल्ड़े दिन जिब हम प्रभुभोज कै खात्तर कठ्ठे होए, तो पौलुस जो दुसरे दिन चले जाण पै था, उनतै बात करी, आध्धी रात ताहीं बात करदा रहया। ");
INSERT INTO bgc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","जिस चौबारे पै हम कठ्ठे थे, उस म्ह घणे दीवे जळण लागरे थे। ");
INSERT INTO bgc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","अर यूतुखुस नाम का एक जवान खिड़की पै बेठ्या होया नींद की झपकियाँ लेण लागरया था। जिब पौलुस वारी ताहीं बात करदा रहया तो यूतुखुस नींद कै झोक्के म्ह तीसरी अटारी पै तै पड़ग्या, अर उसकी मौत होगी। ");
INSERT INTO bgc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पौलुस नीच्चै गया, उसकै धोरै जाकै उसतै लिपटग्या, अर गळे लाकै कह्या, “घबराओ ना, वो जीवै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","अर उसनै दुबारा उप्पर जाकै रोट्टी तोड़ी अर खाकै दिन लिकड़ण ताहीं उनतै बात करदा रहया, सबेरा होग्या। फेर वो चल्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","अर वे उस जवान ताहीं जिन्दा लियाए अर माणस भोत खुश होए। ");
INSERT INTO bgc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","हम पाणी के जहाज पै सवार होकै अस्सुस नगर की ओड़ बढ़े, जड़ै हमनै पौलुस ताहीं साथ लेकै आग्गै बढ़णा था, पर पौलुस ओड़ै पैदल राह तै पोहोचा था, क्यूँके या उसकी पैहले तै बणाई तरकीब थी। ");
INSERT INTO bgc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","अस्सुस नगर उन ताहीं मिल्या तो हमनै उस ताहीं पाणी के जहाज म्ह अपणे साथ लिया अर मितुलेने नगर म्ह जा पोहचे। ");
INSERT INTO bgc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ओड़ै तै जहाज खोल कै हम दुसरे दिन खियुस टापू कै स्याम्ही पोहचे, अर आगले दिन सामुस टापू म्ह जाण लाग्गे, पर उसके आगले एक दिन कै बाद मीलेतुस बन्‍दरगाह म्ह आये। ");
INSERT INTO bgc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पौलुस नै इफिसुस नगर म्ह ना उतरकै आग्गै बढ़ जाण का इरादा करया क्यूँके वो चाहवै था के आसिया परदेस म्ह ठैहरण की बजाए जै हो सक्या तो तगाजै तै पिन्तेकुस्त कै त्यौहार के मौक्कै पै यरुशलेम नगर म्ह पोहच जावै। ");
INSERT INTO bgc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","मीलेतुस नगर तै पौलुस नै इफिसुस नगर म्ह समाचार भेजकै कलीसिया के अगुवां ताहीं बुलवाया। ");
INSERT INTO bgc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जिब वे उसकै लोवै आये, तो उनतै कह्या “थमनै बेरा सै के पैहल्ड़े ए दिन तै जिब मै आसिया परदेस म्ह पोंहच्या, मै हर-बखत थारे गेल्या किस ढाळ रहया, ");
INSERT INTO bgc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","यानिके घणी दीनता तै, अर आँसू बहा-बहाकै, अर उन मुसीबतां म्ह जो यहूदियाँ की साजिस कै कारण मेरै पै आण पड़ी, मै प्रभु की सेवा करदा ए रहया। ");
INSERT INTO bgc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","अर जो-जो बात थारे फायदे की थी, उन ताहीं बताण अर माणसां कै स्याम्ही अर घर-घर सिखाण तै कदे न्ही झिझक्या, ");
INSERT INTO bgc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","बल्के यहूदियाँ अर यूनानियाँ कै स्याम्ही गवाही देंदा रहया के परमेसवर की ओड़ मन फिराणा अर म्हारै प्रभु यीशु पै बिश्वास करणा चाहिये।” ");
INSERT INTO bgc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","इब देक्खो, मै पवित्र आत्मा म्ह बन्धया होया यरुशलेम नगर नै जाऊँ सूं, अर मन्नै न्ही बेरा के ओड़ै मेरै पै के-के बीतैगी। ");
INSERT INTO bgc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","सिर्फ यो के पवित्र आत्मा हरेक नगर म्ह गवाही दे-देकै मेरै तै कहवै सै के बन्धन अर क्ळेश तेरे खात्तर त्यार सै। ");
INSERT INTO bgc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पर मै अपणी जान नै किमे न्ही समझदा के उसतै प्यार राक्खूँ, बल्के यो के मै अपणी दौड़ ताहीं अर उस सेवा नै पूरी करुँ, जो मन्नै परमेसवर कै अनुग्रह के सुसमाचार पै गवाही देण कै खात्तर प्रभु यीशु तै पाई सै। ");
INSERT INTO bgc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","इब देक्खो, मन्नै बेरा सै के थम सारे जिन म्ह मै परमेसवर के राज्य का प्रचार करया सै, मेरा मुँह दुबारा कोनी देक्खोगे। ");
INSERT INTO bgc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ज्यांतै मै आज कै दिन थारे तै गवाही देकै कहूँ सूं, के मै किसे की भी मौत का कसूरवार न्ही सूं। ");
INSERT INTO bgc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","क्यूँके मै परमेसवर की सारी इच्छा नै थारे ताहीं बताण म्ह कदे कोनी हिचकिचाया। ");
INSERT INTO bgc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","इस करकै थम अपणा ध्यान राक्खो अर उस टोळ का भी, जिसका रुखाळा थारे ताहीं पवित्र आत्मा ठहराया सै, के थम परमेसवर की कलीसिया की रुखाळी करो, जिस ताहीं उसनै खुद अपणे लहू तै मोल लिया सै। ");
INSERT INTO bgc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मन्नै बेरा सै के मेरै जाणकै बाद पाड़ण आळे भेड़िये थारे म्ह आवैगें जो टोळ नै कोनी छोड्डैगें। ");
INSERT INTO bgc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","थारे ए बिचाळै तै भी इसे-इसे माणस उठैंगें, जो चेल्यां ताहीं अपणे पाच्छै खींच लेण ताहीं टेढ़ी-मेढ़ी बात कहवैगें। ");
INSERT INTO bgc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","इस करकै जागदे रहो, अर याद राक्खो के मन्नै तीन साल्लां ताहीं रात-दिन आँसू बहा-बहाकै हरेक ताहीं चेतावनी देणा न्ही छोड्या। ");
INSERT INTO bgc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“अर इब मै थमनै परमेसवर अर उनके अनुग्रह के वचन की देखभाळ म्ह सौपण लागरया सूं, जिस म्ह थारी बढ़ोतरी करण अर उन सब के साथ मीरास देण की ताकत सै, जो प्रभु खात्तर न्यारे करे गये सै। ");
INSERT INTO bgc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मन्नै किसे के चाँदी, सोन्ने या लत्ते का लोभ कोनी करया। ");
INSERT INTO bgc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","थमनै खुदे बेरा सै के इन्हे हाथ्थां नै मेरी अर मेरे साथियाँ की जरूरत पूरी करी सै। ");
INSERT INTO bgc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मन्नै थारे ताहीं सारया किमे करकै दिखाया के इस तरियां तै मेहनत करदे होए कमजोरां ताहीं सम्भालणा अर प्रभु यीशु के वचन याद राखणा जरूरी सै, जो उसनै खुदे कह्या सै: ‘लेण तै देणा धन्य सै।’” ");
INSERT INTO bgc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","न्यू कहकै उसनै गोड्डे टेक्के अर उन सारया कै गेल्या प्रार्थना करी। ");
INSERT INTO bgc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","फेर वे सारे घणे रोये अर पौलुस कै गळे लिपटकै उस ताहीं चुम्ण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","वे खासकर इस बात तै दुखी थे जो उसनै कही थी के थम मेरा मुँह दुबारा कोनी देक्खोगे। इसके बाद वे पौलुस के साथ पाणी के जहाज तक गये। ");
INSERT INTO bgc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","जिब हमनै उनतै न्यारे होकै जहाज खोल्या, तो सीध्धी राही तै कोस टापू म्ह आये, अर दुसरे दिन रुदुस टापू म्ह अर ओड़ै तै पतरा टापू म्ह। ");
INSERT INTO bgc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ओड़ै एक जहाज फीनीके परदेस नै जान्दा होया मिल्या, अर हमनै उसपै चढ़कै अपणा सफर शरु करया। ");
INSERT INTO bgc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","हमनै ओळै हाथ कान्ही साइप्रस टापू दिखया, तो हम उसनै छोड़कै सीरिया परदेस की ओड़ बढ़ते गये अर सूर नगर म्ह जा पोहचे, क्यूँके ओड़ै जहाज तै समान उतारया जाणा था। ");
INSERT INTO bgc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","चेल्यां नै पाकै हम ओड़ै सात दिन ताहीं रहे। उननै पवित्र आत्मा के सिखाए पौलुस तै कह्या के ओड़ै (यरुशलेम नगर म्ह) पाँ ना धरिये। ");
INSERT INTO bgc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","सात दिन के बाद जिब ओड़ै तै म्हारे जाण का बखत आया, तो वे पूरे परिवार कै साथ म्हारै ताहीं बिदा करण खात्तर नगर की सीमा तक आये, अर समन्दर कै किनारे हमनै घुटने टेककै प्रार्थना करी, ");
INSERT INTO bgc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","फेर एक-दुसरे तै बिदा होकै, हम तो जहाज पै चढ़गे अर वे अपणे-अपणे घरां बोहड़गे। ");
INSERT INTO bgc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","जिब हम सूर नगर तै जहाज पै सफर करकै पतुलिमयिस नगर म्ह पोहचे, अर बिश्वासी भाईयाँ नै नमस्कार करकै उनकै गेल्या एक दिन रहे। ");
INSERT INTO bgc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दुसरे दिन हम ओड़ै तै चालकै कैसरिया नगर म्ह आये, अर फिलिप्पुस सुसमाचार प्रचारक कै घर म्ह जो उन सात आदमियाँ म्ह तै एक था, जिन ताहीं प्रेरितां नै बिधवा जनानियाँ की सेवा करण खात्तर यरुशलेम म्ह छाट्या था, हम उस्से कै घर म्ह ठहरे। ");
INSERT INTO bgc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","उसकी चार कुँवारी बेट्टी थी, जो भविष्यवाणी करया करै थी। ");
INSERT INTO bgc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जिब हम ओड़ै घणे दिन ताहीं रह लिये, तो अगबुस नाम का एक नबी यहूदिया परदेस म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","उसनै म्हारै धोरै आकै पौलुस का कमरबन्द लिया, अर अपणे हाथ-पाँ बाँधकै कह्या, “पवित्र आत्मा न्यू कहवै सै के जिस माणस का यो कमरबन्द सै, उस ताहीं यरुशलेम नगर म्ह यहूदी इस्से तरियां तै बाँधैगें, अर गैर यहूदियाँ कै हाथ्थां म्ह सौंपैगें।” ");
INSERT INTO bgc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जिब हमनै ये बात सुणी, तो हमनै अर ओड़ै के माणसां नै पौलुस तै बिनती करी के यरुशलेम नगर नै ना जाइए। ");
INSERT INTO bgc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पर पौलुस नै जवाब दिया, “थम के करो सो के रो-रोकै मेरा मन तोड़ो सो? मै तो प्रभु यीशु कै नाम कै खात्तर यरुशलेम नगर म्ह ना सिर्फ बाँधे जाण ए कै खात्तर बल्के मरण कै खात्तर भी त्यार सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जिब उसनै न्ही मान्नी तो हम न्यू कहकै बोल-बाल्ले रहगे, “प्रभु की मर्जी पूरी हो।” ");
INSERT INTO bgc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","कई दिनां पाच्छै हमनै त्यारी करी अर यरुशलेम नगर नै चाल दिए। ");
INSERT INTO bgc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया नगर तै भी कुछ चेल्लें म्हारै गेल्या हो लिए, अर म्हारै ताहीं ठैहराण खात्तर साइप्रसवासी मनासोन के घर ले गये, वो सब तै पैहले के चेल्यां म्ह तै एक था। ");
INSERT INTO bgc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जिब हम यरुशलेम नगर म्ह पोहचे, तो बिश्वासी भाई घणी खुशी कै गेल्या हम तै मिले। ");
INSERT INTO bgc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दुसरे दिन पौलुस म्हारै ताहीं लेकै याकूब कै धोरै गया, जित्त सारे कलीसिया के अगुवें कठ्ठे थे। ");
INSERT INTO bgc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","जद उसनै उन ताहीं नमस्कार करकै, जो-जो काम परमेसवर नै उसकी सेवा के जरिये गैर यहूदियाँ म्ह करे थे, एक-एक करकै सारे बताए। ");
INSERT INTO bgc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","उननै न्यू सुणकै परमेसवर की महिमा करी, फेर उसतै बोल्या, “हे भाई, तू देक्खै सै के यहूदियाँ म्ह तै कई हजारां नै बिश्वास करया सै, अर सारे नियम-कायदे कै खात्तर मानण म्ह पक्के सै। ");
INSERT INTO bgc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","उननै यो सुण राख्या सै के तू गैर यहूदी माणसां के बीच म्ह रहन्दे होए यहूदियाँ ताहीं या शिक्षा देण लागरया सै के मूसा नबी के नियम-कायदा नै छोड़ द्यो, ना तो अपणे बाळकां का खतना करो अर ना रीति-रिवाज्जां पै चाल्लों। ");
INSERT INTO bgc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","तो फेर के करया जावै? माणस जरुर सुणैगें के तू आया सै। ");
INSERT INTO bgc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","इस करकै जो हम तेरे तै कह्वां सां, वो कर। म्हारा सुझाव मान उरै इसे चार माणस सै, जिन नै कसम खाई सै।” ");
INSERT INTO bgc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","तू उनकै गैल जा, शुद्ध होण की विधि पूरी कर, अर उसकै मुण्डन का खर्चा ठा, फेर सारया नै यो बेरा लाग ज्यागा के जो कुछ भी बात तेरे बारै म्ह कह्या गया सै, उस म्ह कोए सच्चाई न्ही सै पर तू खुद भी नियम-कायदे का पालन करै सै। ");
INSERT INTO bgc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","पर उन गैर यहूदियाँ कै बारै म्ह जिन नै बिश्वास करया सै, हमनै यो फैसला करकै लिख भेज्या सै “के वे मूर्तियाँ कै स्याम्ही बलि करे हाड़ माँस तै, अर लहू तै अर घेट्टी घोट्टे होयां के माँस तै अर जारी तै बचे रहवैं।” ");
INSERT INTO bgc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","फेर पौलुस उन माणसां नै लेकै, अर दुसरे दिन उनकै गेल्या शुद्ध होकै मन्दर म्ह गया, अर ओड़ै बता दिया के शुद्ध होण कै दिन, यानिके उन म्ह तै हरेक कै खात्तर चढ़ावा चढ़ाए जाण तक के दिन कद पूरे होवैगें। ");
INSERT INTO bgc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जिब वे सात दिन पूरे होण पै थे, तो आसिया परदेस के यहूदियाँ नै पौलुस ताहीं मन्दर म्ह देखकै सारे माणसां ताहीं उकसाया, अर न्यू रुक्का मारकै उस ताहीं पकड़ लिया, ");
INSERT INTO bgc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“हे इस्राएलियों, मदद करो, यो वोए माणस सै, जो माणसां के, अर नियम-कायदे के, अर इस जगहां कै बिरोध म्ह हरेक जगहां सारे माणसां नै सिखावै सै, उरै ताहीं के यूनानियाँ ताहीं भी मन्दर म्ह ल्याकै उसनै इस पवित्र जगहां ताहीं अपवित्र करया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","उननै इसतै पैहल्या इफिसुसवासी त्रुफिमुस ताहीं पौलुस कै गेल्या नगर म्ह देख्या था, अर सोच्चै थे के पौलुस उसनै मन्दर म्ह लियाया सै। ");
INSERT INTO bgc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","फेर सारे नगर म्ह दंगा माचग्या, अर माणस भाजकै कठ्ठे होए, अर पौलुस नै पकड़कै मन्दर कै बाहरणै घसीट ल्याए, अर जिब्बे किवाड़ बन्द करे गये। ");
INSERT INTO bgc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जिब वे उसनै मार देणा चाहवै थे, तो पलटन के सरदार नै सन्देशा पोंहच्या के सारे यरुशलेम नगर म्ह दंगा माचरया सै। ");
INSERT INTO bgc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","फेर वो जिब्बे सिपाहियाँ अर सूबेदारां नै लेकै उनकै धोरै तळै भाज आया, अर उननै पलटन के सरदार अर सिपाहियाँ ताहीं देखकै पौलुस ताहीं मारणा-छेतणा छोड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","फेर पलटन के सरदार नै धोरै आकै पौलुस ताहीं पकड़ लिया, अर दो साँकळां तै बाँधण का हुकम देकै बुझ्झण लाग्या, “यो कौण सै अर इसनै के करया सै?” ");
INSERT INTO bgc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","पर भीड़ म्ह तै कोए किमे अर कोए किमे चिल्लान्दा रहया। जिब रोले कै कारण वो सही सच्चाई न्ही जाण सक्या, तो उस ताहीं गढ़ म्ह ले जाण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जिब वो सीढ़ी पै पोंहच्या, तो इसा होया के भीड़ की दाब कै मारे सिपाहियाँ नै उस ताहीं ठाकै ले जाणा पड्या। ");
INSERT INTO bgc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","क्यूँके माणसां की भीड़ न्यू चिल्लान्दी होई उसकै पाच्छै पड़री थी, “उसनै खतम कर द्यो।” ");
INSERT INTO bgc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जिब वे पौलुस नै गढ़ म्ह ले जावण आळे थे, तो उसनै पलटन के सरदार तै कह्या, “जै मन्नै इजाजत हो तो मै थारे तै किमे कहूँ?” वो बोल्या, “के तू यूनानी भाषा जाणै सै? ");
INSERT INTO bgc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“के तू मिस्र देश का कोनी, जो इन दिनां तै पैहल्या बिद्रोही बणकै, चार हजार हथियार सुधा माणसां नै जंगळ म्ह लेग्या?” ");
INSERT INTO bgc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुस नै कह्या, “मै तो तरसुस का यहूदी माणस सूं! मै किलिकिया परदेस के तरसुस नगर का बासिन्दा सूं। मै तेरे तै बिनती करुँ सूं के मन्नै माणसां तै बात करण दे।” ");
INSERT INTO bgc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जिब उसनै हुकम दिया, तो पौलुस नै सीढ़ी पै खड़े होकै माणसां ताहीं हाथ तै इशारा करया। जिब वे चुप होए तो वो इब्रानी भाषा म्ह बोल्लण लाग्या: ");
INSERT INTO bgc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“हे भाईयो अर बुजुर्गों, मेरा बदले म्ह जवाब सुणो, जो मै इब थारे स्याम्ही ल्याऊँ सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","वे न्यू सुणकै के वो हम तै इब्रानी भाषा म्ह बोल्लै सै, और भी बोल-बाल्ले होगे। फेर उसनै कह्या ");
INSERT INTO bgc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“मै तो यहूदी माणस सूं, जो किलिकिया के तरसुस नगर म्ह जन्मा, पर इस नगर म्ह गमलीएल के पायां कै धोरै बैठकै पढ़ाया गया, अर पूर्वजां के नियम-कायदा नै ठीक रीति तै सिखाया गया अर परमेसवर कै खात्तर इसी धुन लारया था, जिस तरियां थम सारे आज लारे सो। ");
INSERT INTO bgc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मन्नै माणस अर लुगाई दोनुआ ताहीं जुड़-जुड़कै अर जेळ म्ह गेर-गेर कै, इस पंथ नै उरै ताहीं सताया के उन ताहीं मरवा भी दिया। ");
INSERT INTO bgc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","इस बात कै खात्तर महायाजक अर सारे यहूदी अगुवें गवाह सै, के उनतै मै भाईयाँ कै नाम पै चिट्ठियाँ लेकै दमिश्क नगर नै चाल्या जाऊँ था, के जो ओड़ै हों उन ताहीं भी सजा दुवाण कै खात्तर बाँधकै यरुशलेम नगर लाऊँ। ");
INSERT INTO bgc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“जिब मै चाल्दे-चाल्दे दमिश्क नगर कै लोवै पोंहच्या, तो इसा होया के दोपहर कै करीबन चाणचक एक घणा चाँदणा अकास तै मेरै चौगरदे नै चमक्या। ");
INSERT INTO bgc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","अर मै धरती पै गिर ग्या अर यो शब्द सुण्या, ‘हे शाऊल, हे शाऊल, तू मन्नै क्यांतै सतावै सै?’” ");
INSERT INTO bgc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मन्नै जवाब दिया, “हे प्रभु, तू कौण सै?” उसनै मेरै तै कह्या, “मै यीशु नासरी सूं,” जिस ताहीं तू सतावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","मेरे साथियाँ नै चाँदणा तो देख्या, पर मेरै तै जो बोल्लै था उसनै समझ कोनी पाए। ");
INSERT INTO bgc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","फेर मन्नै कह्या, “हे प्रभु, मै के करुँ?” प्रभु नै मेरै तै कह्या, “उठकै दमिश्क नगर म्ह जा, अर जो किमे तेरे तै करण कै खात्तर ठहराया गया सै ओड़ै तेरे तै सब बता दिया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जिब उस चाँदणे के तेज के मारे मन्नै किमे कोनी दिख्या, तो मै अपणे साथियाँ का हाथ पकड़े होए दमिश्क नगर म्ह आया। ");
INSERT INTO bgc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“फेर हनन्याह नामक नियम-कायदे कै मुताबिक एक भगत माणस, जो ओड़ै के रहणीये सारे यहूदियाँ म्ह सुनाम्मी था, मेरै धोरै आया,” ");
INSERT INTO bgc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","अर खड़े होकै मेरै तै कह्या, “हे भाई शाऊल, फेर देखण लाग।” उस्से बखत मेरी आँख खुलगी अर मन्नै उस ताहीं देख्या। ");
INSERT INTO bgc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","फेर उसनै कह्या, “म्हारै बाप-दाद्या के परमेसवर नै तेरे ताहीं ज्यांतै ठहराया के तू उसकी मर्जी नै जाणै, अर उस धर्मी नै देक्खै अर उसकै मुँह की बात सुणै। ");
INSERT INTO bgc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","क्यूँके तू उसकी ओड़ तै सारे माणसां कै स्याम्ही उन बात्तां का गवाह होगा जो तन्नै देक्खी अर सुणी सै। ");
INSERT INTO bgc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","इब क्यांतै वार करै सै? उठ, बपतिस्मा ले, अर उसका नाम लेकै अपणे पापां की माफी पा ले।” ");
INSERT INTO bgc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“जिब मै दुबारा यरुशलेम नगर म्ह आकै मन्दर म्ह प्रार्थना करण लागरया था, तो बेसुध होग्या, ");
INSERT INTO bgc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","अर उस ताहीं देख्या के वो मेरै तै कहवै सै, ‘तावळ करकै यरुशलेम नगर तै झट दे-सी लिकड़ज्या,’ क्यूँके वे मेरै बारै म्ह तेरी गवाही कोनी मान्नैगें।” ");
INSERT INTO bgc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मन्नै कह्या, “हे प्रभु, उननै तो खुदे बेरा सै के मै तेरे पै बिश्वास करण आळा नै जेळ म्ह गेरू अर जगहां-जगहां आराधनालय म्ह छित्वाऊँ था। ");
INSERT INTO bgc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","जिब तेरे गवाह स्तिफनुस का लहू बहाया जाण लागरया था जद मै भी ओड़ैए खड्या था अर इस बात म्ह सहमत था, अर उसकै मारणीयां के लत्यां की रुखाळी करुँ था।” ");
INSERT INTO bgc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","अर प्रभु नै मेरै तै कह्या, “चल्या जा क्यूँके मै तेरे ताहीं गैर यहूदियाँ कै धोरै दूर-दूर भेज्जूँगा।” ");
INSERT INTO bgc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","माणस इस बात तक उसकी सुणदे रहे, फेर जोर तै चिल्लाए, “इसे माणस का नाश करो, उसका जिन्दा रहणा ठीक कोनी!” ");
INSERT INTO bgc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जिब वे चिल्लान्दे अर लत्ते बगान्दे अर अकास म्ह धूळ उड़ावै थे, ");
INSERT INTO bgc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","तो पलटन के सरदार नै कह्या, “इस ताहीं गढ़ म्ह ले जाओ, अर कोड़े मारकै जाँच्चो, के मन्नै बेरा लाग्गै के माणस किस कारण उसकै बिरोध म्ह इस ढाळ चिल्लावै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","जिब उननै उस ताहीं फित्त्यां तै बाँधया तो पौलुस नै उस सूबेदार तै जो धोरै खड्या था, कह्या, “के यो सही सै के थम एक रोमी माणस ताहीं, अर वो भी बिना कसूरवार ठहराए होए, कोड़े मारो?” ");
INSERT INTO bgc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","सूबेदार नै न्यू सुणकै पलटन के सरदार कै धोरै जाकै कह्या, “तू यो के करै सै? यो तो रोमी माणस सै।” ");
INSERT INTO bgc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","फेर पलटन के सरदार नै उसकै धोरै आकै कह्या, “मन्नै बता, के तू रोमी सै?” उसनै कह्या, “हाँ।” ");
INSERT INTO bgc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","न्यू सुणकै पलटन के सरदार नै कह्या, “मन्नै रोमी होण का पद घणे रपिये देकै मिल्या सै।” पौलुस नै कह्या, “मै तो जन्म तै रोमी सूं?” ");
INSERT INTO bgc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","फेर जो माणस उस ताहीं जांच्चण पै थे, वे जिब्बे उसकै धोरै तै हटगे, अर पलटन का सरदार भी न्यू जाणकै के यो रोमी सै अर मन्नै उस ताहीं बाँधया सै, डरग्या। ");
INSERT INTO bgc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","दुसरे दिन उसनै सही-सही जाणण की मर्जी तै के यहूदी उसपै क्यांतै दोष लावै सै, उसके बन्धन खोल दिए, अर प्रधान याजकां अर यहूदी अगुवां की सभा ताहीं कठ्ठा होण का हुकम दिया, अर पौलुस नै तळै ले जाकै उनकै स्याम्ही खड्या कर दिया। ");
INSERT INTO bgc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुस नै यहूदी अगुवां की सभा की ओड़ गौर तै देख्या अर कह्या, “हे भाईयो, मन्नै आज ताहीं परमेसवर कै खात्तर जमा-कती सच्चे मन तै जीवन बिताया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","इसपै हनन्याह महायाजक नै उन ताहीं जो उसकै धोरै खड़े थे, उसकै मुँह पै थप्पड़ मारण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","फेर पौलुस नै उसतै कह्या, “हे चुन्ना फिरी होड़ भीत, परमेसवर तेरे ताहीं मारैगा। तू नियम-कायदे कै मुताबिक मेरा न्याय करण नै बेठ्या सै, अर फेर के नियम-कायदे कै खिलाफ मेरै ताहीं मारण का हुकम देवै सै?” ");
INSERT INTO bgc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जो धोरै खड़े थे उननै कह्या, “के तू परमेसवर कै महायाजक नै आच्छा-भुंडा बोल्लै सै?” ");
INSERT INTO bgc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुस नै कह्या, “हे भाईयो, मन्नै न्ही बेरा था के यो महायाजक सै, क्यूँके वचन म्ह लिख्या सै: ‘अपणे माणसां के प्रधान नै भुंडा ना बोलिए।’” ");
INSERT INTO bgc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","फेर पौलुस नै न्यू जाणकै के एक टोळ सदूकी अर दुसरा फरीसी लोग्गां का सै, यहूदी अगुवां की सभा म्ह रुक्का मारकै कह्या, “हे भाईयो, मै फरीसी अर फरीसी लोग्गां के वंश का सूं, मरे होया की आस अर पुनरुत्थान कै बारै म्ह मेरा मुकद्दमा होरया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","जिब उसनै या बात कही तो फरीसियाँ अर सदूकियाँ म्ह दंगा होण लाग्या, अर सभा म्ह फूट पड़गी। ");
INSERT INTO bgc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","क्यूँके सदूकियाँ का बिश्वास तो न्यू कहवै सै, के ना पुनरुत्थान सै, ना सुर्गदूत अर ना आत्मा सै, पर फरीसी इन सारया नै मान्नैं सै। ");
INSERT INTO bgc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","फेर घणा दंगा माच्या अर कुछ शास्त्री जो फरीसियाँ के टोळ के थे, उठ लिए अर न्यू कहकै दंगा करण लाग्गे, “हम इस माणस म्ह कोए बुराई कोनी पांदे, अर जै कोए आत्मा या सुर्गदूत उसतै बोल्या सै तो फेर के होग्या?” ");
INSERT INTO bgc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जिब घणा दंगा होया, तो पलटन के सरदार नै इस भय तै के वे पौलुस के टुकड़े-टुकड़े ना कर देवै, पलटन ताहीं हुकम दिया के उतरकै उस ताहीं उनकै बिचाळै तै हाँगै तै लिकाड़ै, अर गढ़ म्ह ले जावै। ");
INSERT INTO bgc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","उस्से रात प्रभु यीशु नै उसकै धोरै खड़े होकै कह्या, “हे पौलुस, धीरज राख, क्यूँके जिसी तन्नै यरुशलेम नगर म्ह मेरी गवाही देई, उसीए तन्नै रोम म्ह भी गवाही देणी होगी।” ");
INSERT INTO bgc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","जिब दिन लिकड़या तो यहूदियाँ नै साजिस रची अर कसम खाई के जिब ताहीं हम पौलुस नै मार न्ही देवा, जै हम खावां या पीवां तो म्हारै पै धिक्कार सै। ");
INSERT INTO bgc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जिन नै आप्पस म्ह या कसम खाई थी, वे चाळीस जण्यां तै घणे थे। ");
INSERT INTO bgc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","उननै प्रधान याजकां अर यहूदी अगुवां कै धोरै जाकै कह्या, “हमनै न्यू ठान लिया सै के जिब ताहीं हम पौलुस नै मार न्ही देंदे, जद ताहीं जै किमे चाक्खां तो म्हारै पै धिक्कार सै। ");
INSERT INTO bgc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","इस करकै इब यहूदी अगुवां की सभा सुधा पलटन के सरदार नै समझाओ के उसनै थारे धोरै लियावै, मान ल्यो के थम उसकै बारै म्ह और भी सही तै जाँच करणा चाहवो सो, अर हम उसकै पोहोचण तै पैहल्याए उस ताहीं मार देण कै खात्तर त्यार रहवांगें।” ");
INSERT INTO bgc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पौलुस कै भाण्जै नै सुण्या के वे उसकी टाह म्ह सै, तो गढ़ म्ह जाकै पौलुस ताहीं संदेशां दिया। ");
INSERT INTO bgc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पौलुस नै सूबेदारां म्ह तै एक ताहीं अपणे धोरै बुलाकै कह्या, “इस जवान नै पलटन के सरदार कै धोरै ले जाओ, यो उसतै किमे कहणा चाहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","इस करकै उसनै उस ताहीं पलटन के सरदार कै धोरै ले जाकै कह्या, “कैदी पौलुस नै मेरै ताहीं बुलाकै बिनती करी के यो जवान पलटन के सरदार तै किमे कहणा चाहवै सै, उस ताहीं उसकै धोरै ले जा।” ");
INSERT INTO bgc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","पलटन के सरदार नै उसका हाथ पकड़कै अर न्यारा जाकै बुझ्झया, “तू मेरै तै के कहणा चाहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","वो बोल्या, “यहूदियाँ नै साजिस रची सै के तेरे तै बिनती करै के काल पौलुस नै यहूदी अगुवां की सभा म्ह ल्यावै, मान्नो वे और सही ढाळ तै उसकी जाँच करणा चाहवै सै। ");
INSERT INTO bgc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","पर उनकी मानियो मतना, क्यूँके उन म्ह तै चाळीस कै उप्पर माणस उसनै मारण की टाह म्ह सै, जिन नै न्यू ठान लिया सै के जिब ताहीं वे पौलुस नै मार न्ही देवै, जद ताहीं ना खावैगें अर ना पीवैगें, अर इब वे त्यार सै अर तेरे वचन की बाट देखण लागरे सै।” ");
INSERT INTO bgc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","फेर पलटन के सरदार नै जवान ताहीं यो हुकम देकै बिदा करया, “किसे तै ना कहिये के तन्नै मेरै तै ये बात बताई सै।” ");
INSERT INTO bgc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","फेर उसनै दो सूबेदारां ताहीं बुलाकै कह्या, “दो सौ सिपाही, सत्तर सवार, अर दो सौ भालैत, रात के नौ बजे कैसरिया नगर नै जाणकै खात्तर त्यार कर करो। ");
INSERT INTO bgc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","अर पौलुस की सवारी कै खात्तर घोड़े त्यार राक्खो, के उस ताहीं फेलिक्स राज्यपाल कै धोरै राज्जी-खुशी तै पोहोचा दे।” ");
INSERT INTO bgc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","उसनै इस तरियां की चिट्ठी भी लिक्खी ");
INSERT INTO bgc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","महामहिम फेलिक्स राज्यपाल ताहीं क्लौकियुस लूसियास का नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","इस माणस ताहीं यहूदियाँ नै पकड़कै मार देणा चाह्या, पर जिब मन्नै जाण्या के रोमी सै, तो पलटन लेकै छुड़ा ल्याया। ");
INSERT INTO bgc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","मै जाणणा चाहूँ था के वे उसपै किस कारण दोष लावै सै, ज्यांतै उस ताहीं यहूदी अगुवां की सभा म्ह ले गया। ");
INSERT INTO bgc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","फेर मन्नै जाण लिया के वे अपणे नियम-कायदे कै रोळे कै बारै म्ह उसपै इल्जाम लगावै सै, पर मार देण जोग्गा या बाँधे जाणकै जोग्गा उस म्ह कोए कसूर कोनी। ");
INSERT INTO bgc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","जिब मेरै ताहीं बताया गया के वे इस माणस की टाह म्ह लागरे सै तो मन्नै जिब्बे उस ताहीं तेरे धोरै भेज दिया, अर बैरियाँ ताहीं भी हुकम दिया के तेरे स्याम्ही उसपै नालिश करै। ");
INSERT INTO bgc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","आखर म्ह जिसा सिपाहियाँ नै हुकम मिल्या था, उस्से तरियां ए वे पौलुस नै लेकै रातो-रात अन्तिपत्रिस म्ह आये। ");
INSERT INTO bgc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दुसरे दिन वे सवारा नै उसकै गेल्या जाणकै खात्तर छोड़कै खुद यरुशलेम म्ह बोहड़ै। ");
INSERT INTO bgc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","उननै कैसरिया पोहचकै राज्यपाल ताहीं चिट्ठी दी, अर पौलुस ताहीं भी उसकै स्याम्ही खड्या करया। ");
INSERT INTO bgc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","राज्यपाल नै चिट्ठी पढ़कै बुझ्झया, “यो किस प्रान्त का सै?” ");
INSERT INTO bgc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","अर जिब जाण लिया के किलिकिया परदेस का सै तो उसतै कह्या, “जिब तेरे बैरी भी आवैगें, तो मै तेरा मुकद्दमा करुँगा।” अर उसनै उस ताहीं हेरोदेस कै किले म्ह पहरे म्ह राक्खण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाँच दिन कै पाच्छै हनन्याह महायाजक कई यहूदी अगुवें अर तिरतुल्लुस नामक किसे वकील नै गेल्या लेकै कैसरिया नगर आ पोहचे। उननै राज्यपाल कै स्याम्ही पौलुस कि बुराई करी। ");
INSERT INTO bgc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","जिब पौलुस बुलाया गया तो तिरतुल्लुस उसपै इल्जाम लाकै कहण लाग्या: “हे महामहिम फेलिक्स, तेरे जरिये हम राज्जी-खुशी सां, अर तेरे इन्तजाम तै इस जात कै खात्तर घणीए बुराईयाँ सुधरदी जावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","इस ताहीं हम हरेक जगहां अर हरेक तरियां तै धन्यवाद कै गैल मान्नां सां। ");
INSERT INTO bgc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","मै तेरा और ज्यादा बखत कोनी लेऊँ, मै तेरे तै बिनती करुँ सूं के दया करकै दो-एक बात सुण ले।” ");
INSERT INTO bgc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“बात या सै के इस माणस ताहीं हमनै एक उत्पाती के रूप म्ह पाया सै, सारी दुनिया के यहूदिया परदेस म्ह इसनै दंगे भड़काए सै, यो नासरियाँ के पंथ का नेता सै। ");
INSERT INTO bgc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","उसनै मन्दर ताहीं अशुद्ध करणा चाह्या, पर हमनै उस ताहीं पकड़ लिया। (हमनै उस ताहीं अपणे नियम-कायदे कै मुताबिक सजा दे दी होन्दी, ");
INSERT INTO bgc_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पर पलटन के सरदार लूसियास नै उस ताहीं हाँगै तै म्हारै हाथ तै खोस लिया, ");
INSERT INTO bgc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","अर बैरियाँ ताहीं तेरे स्याम्ही आण का हुकम दिया।) इन सारी बात्तां नै जिनकै बारै म्ह हम उसपै इल्जाम लावां सां, तू खुदे ए उसनै जाँच करकै जाण लेवैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदियाँ नै भी उसका साथ देकै कह्या, ये बात इस्से ढाळ तै करी सै। ");
INSERT INTO bgc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","जिब राज्यपाल नै पौलुस ताहीं बोल्लण का इशारा करया, तो उसनै जवाब दिया: “मै न्यू जाणकै के तू घणे साल्लां तै इस जात का न्याय करण लागरया सै, खुशी तै अपणा बदले का जवाब देऊँ सूं। ");
INSERT INTO bgc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तू आप्पे ए जाण सकै सै जिब तै मै यरुशलेम नगर के मन्दर म्ह आराधना करण नै आया, मन्नै बारहा दिनां तै बाध कोनी होए, ");
INSERT INTO bgc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","उननै मेरै ताहीं ना मन्दर म्ह, ना आराधनालयाँ म्ह, ना किसे नगर म्ह किसे तै बहस करदे या भीड़ लगांदे पाया, ");
INSERT INTO bgc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","अर ना तो वे उन बात्तां ताहीं, जिनका वे इब मेरै पै दोष लावै सै, तेरे स्याम्ही साच्ची साबित कर सकै सै। ");
INSERT INTO bgc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","पर मै तेरे स्याम्ही यो मान ल्यु सूं के जिस पन्थ नै वे बुरा पन्थ कहवै सै, उस्से की रीत पै मै अपणे बाप-दाद्या के परमेसवर की सेवा करुँ सूं, अर जो बात नियम-कायदे अर नबियाँ की किताबां म्ह लिक्खी सै, उन सारया पै बिश्वास करुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","अर परमेसवर तै आस राक्खूँ सूं जो वे खुद भी राक्खै सै, के धर्मी अर अधर्मी दोनुआ का जिन्दा उठणा होवैगा। ");
INSERT INTO bgc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","इसतै मै खुद भी कोशिश करुँ सूं के परमेसवर की, अर माणसां की ओड़ तै मेरा मन सारी-हाण बेकसूर रहवै।” ");
INSERT INTO bgc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“घणे साल्लां पाच्छै मै गरीबां नै दान पोहोचाण, अर भेंट चढ़ाण आया था। ");
INSERT INTO bgc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","उस्से बखत इननै मेरै ताहीं मन्दर म्ह, शुद्ध होण की रीति पूरी करते देख्या, ओड़ै ना कोए भीड़ थी, अर ना ए किसे ढाळ का शोर, पर ओड़ै आसिया परदेस के कई यहूदी थे ");
INSERT INTO bgc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","जै मेरै बिरोध म्ह उनकै धोरै कोए बात कहण की हो तो उरै तेरे स्याम्ही आकै मेरै पै इल्जाम लांदे। ");
INSERT INTO bgc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","या ये खुद ए बतावै के जिब मै यहूदी अगुवां की सभा कै स्याम्ही खड्या था, तो उननै मेरै म्ह कौण सा कसूर पाया? ");
INSERT INTO bgc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","इस एक बात नै छोड़ जो मन्नै उनकै बिचाळै खड्या होकै कही थी: ‘मरे होया के जिन्दा उठण कै बारै म्ह आज मेरा थारे स्याम्ही मुकद्दमा होण लागरया सै।’” ");
INSERT INTO bgc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलिक्स नै, जो इस पन्थ की बात सही-सही जाणै था, उन ताहीं न्यू कहकै टाळ दिया, “जिब पलटन का सरदार लूसियास आवैगा, तो थारी बात का फैसला करुँगा।” ");
INSERT INTO bgc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","उसनै सूबेदार ताहीं हुकम दिया के पौलुस ताहीं जेळ म्ह तो राख्या जावै पर उस ताहीं इतनी छूट जरुर दी जावै के उसके खास साथी आकै उसकी सेवा कर सकै। ");
INSERT INTO bgc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","कुछ दिनां पाच्छै फेलिक्स हाकिम अपणी घरआळी दुसिल्ला ताहीं, जो यहूदी थी, गेल्या लेकै आया अर पौलुस ताहीं बुलवाकै उस बिश्वास कै बारै म्ह जो मसीह यीशु पै सै, उसतै सुण्या। ");
INSERT INTO bgc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","जिब पौलुस धर्म, अर संयम, अर आण आळे न्याय का जिक्र करण लागरया था, तो फेलिक्स नै भयभीत होकै जवाब दिया, “इब तो जा, मौक्का मिल तिए मै तन्नै दुबारा बुलवाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","फेलिक्स ताहीं पौलुस तै कुछ रपिये मिलण की भी आस थी, ज्यांतै और भी बुला-बुलाकै उसतै बात करया करै था। ");
INSERT INTO bgc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","पर जिब दो साल बीतगे तो पुरकियुस फेस्तुस, फेलिक्स की जगहां पै आया, अर फेलिक्स यहूदियाँ ताहीं राज्जी करण की मर्जी तै पौलुस ताहीं कैदी ए छोड़ ग्या। ");
INSERT INTO bgc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","राज्यपाल पद का काम सम्भाळण के तीन दिन बाद फेस्तुस कैसरिया नगर तै यरुशलेम नगर म्ह गया। ");
INSERT INTO bgc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","फेर प्रधान याजकां अर यहूदियाँ के खास माणसां नै उसकै स्याम्ही पौलुस की बुराई करी, ");
INSERT INTO bgc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","के वो खियास करकै पौलुस ताहीं यरुशलेम नगर भेजदे, असल म्ह उसकी तरकीब राह म्ह मौक्का देखकै पौलुस ताहीं मारण की थी। ");
INSERT INTO bgc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुस नै जवाब दिया, “पौलुस कैसरिया म्ह पहरे म्ह सै, अर मै आप्पे ए तावळ तै ओड़ै जाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","फेर बोल्या, “थारे म्ह जो अधिकार राक्खै सै वे गैल चाल्लै, अर जै इस माणस नै किमे गलत काम करया सै तो उसपै इल्जाम लावै।” ");
INSERT INTO bgc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","उनकै बिचाळै कोए आठ-दस दिन रहकै फेस्तुस कैसरिया चल्या गया, अर दुसरे दिन न्याय-गद्दी पै बैठकै पौलुस ताहीं ल्याण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जिब वो आया तो जो यहूदी अगुवें यरुशलेम नगर तै आये थे, उननै लोवै-धोवै खड़े होकै उसपै घणे भारया दोष लगाये, जिनका सबूत वे कोनी दे सकै थे। ");
INSERT INTO bgc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पर पौलुस नै जवाब दिया, “मन्नै ना तो यहूदियाँ के नियम-कायदे कै अर ना मन्दर कै, अर ना ए कैसर कै बिरुध्द कोए अपराध करया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","फेर फेस्तुस नै यहूदी अगुवां ताहीं राज्जी करण के मकसद तै पौलुस तै कह्या, “के तू चाहवै सै के यरुशलेम नगर नै जावै, अर ओड़ै मेरै स्याम्ही तेरा यो मुकद्दमा तय करया जावै?” ");
INSERT INTO bgc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पौलुस नै कह्या, “मै कैसर कै न्याय-गद्दी कै स्याम्ही खड्या सूं, मेरै मुकद्दमे फैसला उरैए होणा चाहिये। जिसा तन्नै आच्छी ढाळ बेरा सै, यहूदियाँ का मन्नै किमे अपराध कोनी करया। ");
INSERT INTO bgc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","जै मै अपराधी सूं अर मारण कै जोग्गा कोए काम करया सै, तो मरण तै कोनी नाटदा, पर जिन बात्तां की ये मेरै पै इल्जाम लावै सै, जै उन म्ह तै कोए भी बात साच्ची न्ही लिकड़ी, तो कोए मेरै ताहीं उनकै हाथ्थां न्ही सौंप सकदा। मै कैसर की दुहाई द्यु सूं।” ");
INSERT INTO bgc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","फेर फेस्तुस नै मन्त्रियाँ की सभा कै गेल्या बात करकै जवाब दिया, “तन्नै कैसर की दुहाई दी सै, तू कैसर कै ए धोरै जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कुछे दिन बीतण कै पाच्छै अग्रिप्पा राजा अर बिरनीके नै कैसरिया म्ह आकै फेस्तुस तै भेंट करी। ");
INSERT INTO bgc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","उनकै घणे दिन ओड़ै रहण कै पाच्छै फेस्तुस नै पौलुस कै बारै म्ह राजा ताहीं बताया “एक माणस सै, जिस ताहीं फेलिक्स कैदी छोड़ ग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जिब मै यरुशलेम नगर म्ह था, तो प्रधान याजक अर यहूदिया परदेस के यहूदी अगुवां नै उसकी बुराई करी अर चाह्या के उसपै दण्ड का हुकम होवै। ");
INSERT INTO bgc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","पर मन्नै उन ताहीं जवाब दिया के रोमियों की या रीत कोनी के किसे माणस ताहीं सजा कै खात्तर सौंप देवै, जिब ताहीं मुजरिम ताहीं अपणे बैरियाँ कै स्याम्ही खड़े होकै दोष का जवाब देण का मौक्का ना मिलै। ");
INSERT INTO bgc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","आखर जिब वे कठ्ठे होए, तो मन्नै किमे वार कोनी करी, पर दुसरे ए दिन न्याय-गद्दी पै बैठकै उस माणस ताहीं ल्याण का हुकम दिया। ");
INSERT INTO bgc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जिब उसके बैरी खड़े होए, तो उननै इसी गलत बात्तां की इल्जाम कोनी लाई, जिसा मै समझूँ था। ");
INSERT INTO bgc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","पर वे अपणे पंथ कै अर यीशु नाम किसे माणस कै बारै म्ह, जो मरग्या था अर पौलुस उस ताहीं जिन्दा बतावै था, बहस करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","मै उळझन म्ह था के इन बात्तां का बेरा किस ढाळ लाऊँ? ज्यांतै मन्नै उसतै बुझ्झया, के तू यरुशलेम नगर जावैगा के ओड़ै इन बात्तां का फैसला होवै? ");
INSERT INTO bgc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पर जिब पौलुस नै दुहाई देई के “उसकै मुकद्दमे का फैसला सम्राट कै उरै हो, तो मन्नै हुकम दिया के जिब तक उस ताहीं कैसर कै धोरै न्ही भेज्जू, उस ताहीं हिरासत म्ह राख्या जावै।” ");
INSERT INTO bgc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","फेर अग्रिप्पा नै फेस्तुस तै कह्या, “मै भी उस माणस की सुणणा चाहूँ सूं।” उसनै कह्या, “तू काल सुण लेवैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","आखर म्ह दुसरे दिन जिब अग्रिप्पा अर बिरनीके बड्डी धूम-धड़ाकै तै आये अर पलटन के सरदारां अर नगर के खास आदमियाँ कै गेल्या दरबार म्ह पोहचे। फेर फेस्तुस नै हुकम दिया के वे पौलुस ताहीं ली यावै। ");
INSERT INTO bgc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुस नै कह्या, “हे राजा अग्रिप्पा, अर हे सारे माणसों जो उरै म्हारै गेल्या सो, थम इस माणस नै देक्खो सो, जिसकै बारै म्ह सारे यहूदियाँ नै यरुशलेम नगर म्ह अर उरै भी रुक्के मार-मारकै मेरै तै बिनती करी के इसका जिन्दा रहणा सही कोनी। ");
INSERT INTO bgc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पर मन्नै बेरा पाट लिया के उसनै इसा किमे कोनी करया के मार दिया जा, अर जिब के उसनै आप्पे ए सम्राट की दुहाई दी, तो मन्नै उस ताहीं खन्दाण का फैसला करया। ");
INSERT INTO bgc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","मन्नै उसकै बारै म्ह कोए पक्की बात कोनी पाई के अपणे माल्लिक कै धोरै लिखूँ। ज्यांतै मै उस ताहीं थारे स्याम्ही अर खासकर हे राजा अग्रिप्पा तेरे स्याम्ही ल्याया सूं के जाँचे पाच्छै मन्नै किमे लिखण का मौक्का मिलै। ");
INSERT INTO bgc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","क्यूँके कैदी ताहीं खन्दाणा अर जो दोष उसपै लगाये सै, उन ताहीं न्ही बताणा, मन्नै खामखां लाग्या सै।” ");
INSERT INTO bgc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्रिप्पा नै पौलुस तै कह्या, “तेरे ताहीं अपणे बाबत बोल्लण की आज्ञा सै।” फेर पौलुस हाथ तै इशारा करकै जवाब देण लाग्या, ");
INSERT INTO bgc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“हे राजा अग्रिप्पा, जितनी बात्तां का यहूदी अगुवें मेरै पै इल्जाम लावै सै, आज तेरे स्याम्ही उनका जवाब देण म्ह अपणे ताहीं धन्य समझूँ सूं, ");
INSERT INTO bgc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","खास करकै ज्यांतै के तू सारी यहूदी प्रथा अर परेशानियाँ नै भली-भाँति जाणै सै। इस करकै मै बिनती करुँ सूं, धीरज तै मेरी सुण।” ");
INSERT INTO bgc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“मेरा चाल-चलण शरुआत तै अपणी जात कै बिचाळै अर यरुशलेम नगर म्ह जिसा था, उसका सारे यहूदियाँ नै बेरा सै। ");
INSERT INTO bgc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","जै वे गवाही देणा चाहवैं, तो तू मेरै ताहीं तब तै पिच्छाणै सै जिब मै जवान था, के मै फरीसी होकै अपणे धर्म कै सबतै खरे पन्थ कै मुताबिक चाल्या। ");
INSERT INTO bgc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","अर आज मै परमेसवर के जरिये म्हारे पूर्वजां नै दिए गये उस वादे की आस के कारण उरै दोषी के रूप म्ह खड्या सूं। ");
INSERT INTO bgc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","यो वोए वादा सै, जिसके पूरे होण की आस म्हारे बारहां कुल दिन-रात सच्चाई म्ह परमेसवर की भगति-आराधना करदे होए आये सै। हे राजा, आज मेरे पै यहूदियाँ के जरिये मुकद्दमा इस्से आस कै कारण चलाया जाण लागरया सै। ");
INSERT INTO bgc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","जिब के परमेसवर मरे होया नै जिन्दा करै सै, तो थारे उरै या बात क्यांतै बिश्वास कै जोग्गी कोनी समझी जान्दी?” ");
INSERT INTO bgc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“मन्नै भी समझया था के यीशु नासरी कै नाम कै बिरोध म्ह मन्नै भोत कुछ करणा चाहिये। ");
INSERT INTO bgc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","अर मन्नै यरुशलेम नगर म्ह न्यूए करया, अर प्रधान याजकां तै हक पाकै घणखरे पवित्र माणसां ताहीं जेळ म्ह गेरया, अर जिब वे मार दिये जावै थे तो मै भी उनकै बिरोध म्ह अपणी राय द्यु था। ");
INSERT INTO bgc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","हरेक आराधनालय म्ह मै उन ताहीं कांल कर-करकै यीशु की बुराई करवाऊँ था, उरै ताहीं के छो के मारे इसा बावळा होग्या के दुसरे नगरां म्ह भी जाकै उन ताहीं कांल करुँ था।” ");
INSERT INTO bgc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“इस्से धुन म्ह जिब मै प्रधान याजकां तै अधिकार अर हुकम-चिट्ठी लेकै दमिश्क नगर नै जाण लागरया था, ");
INSERT INTO bgc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","तो हे राजा, राह म्ह दोफारी कै बखत मन्नै अकास तै सूरज कै तेज तै भी बढ़कै एक चाँदणा, अपणे अर अपणे गेल्या चाल्लण आळा कै चौगरदे नै चमकदा होड़ देख्या। ");
INSERT INTO bgc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","जिब हम सारे धरती पै पड़गे, तो मन्नै इब्रानी भाषा म्ह, मेरै तै न्यू कहन्दे होए एक बोल सुण्या, ‘हे शाऊल, हे शाऊल, तू मन्नै क्यांतै सतावै सै? पैने पै लात मारणा तेरे खात्तर ओक्खा सै। (जै तू मन्नै सतावैगा तो तू खुद नै सतावैगा)’” ");
INSERT INTO bgc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","फेर मै बोल्या, “हे प्रभु, तू कौण सै?” प्रभु नै कह्या, “‘मै यीशु सूं, जिस ताहीं तू सतावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","पर तू उठ, अपणे पायां पै खड्या हो, क्यूँके मन्नै तेरे ताहीं ज्यांतै दर्शन दिया सै के तन्नै उन बात्तां का भी सेवक अर गवाह ठहराऊँ, जो तन्नै देक्खी सै, अर उनका भी जिनकै खात्तर मै तन्नै दर्शन दियुँगा। ");
INSERT INTO bgc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","अर मै तन्नै तेरे माणसां तै अर गैर यहूदियाँ तै बचान्दा रहूँगा, जिनकै धोरै मै इब तन्नै इस करकै भेज्जू सूं ");
INSERT INTO bgc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","के तू उनकी आँख खोल्लै के वे अन्धेरै तै चाँदणे कान्ही, अर शैतान कै अधिकार तै परमेसवर कै कान्ही पलटै, इस करकै के पापां की माफी अर उन माणसां कै गेल्या जो मेरै पै बिश्वास करण तै पवित्र करे गये सै, वसियत पावैं।’” ");
INSERT INTO bgc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“इस करकै हे राजा अग्रिप्पा, मन्नै उस सुर्गीय दर्शन की बात कोनी टाळी, ");
INSERT INTO bgc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","मन्नै सबतै पैहल्या दमिश्क नगर कै, फेर यरुशलेम नगर कै, अर फेर यहूदिया परदेस के बासिन्दा ताहीं, अर गैर यहूदियाँ म्ह भी यो प्रचार करदा रहया के पाप करणा छोड़कै परमेसवर कान्ही बोहड़ आओ, अर अपणे सुभाव के जरिये यो साबित करो के थमनै पाप करणा छोड़ दिया सै। ");
INSERT INTO bgc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","इन बात्तां कै कारण यहूदी मन्नै मन्दर म्ह पकड़कै मार देण की कोशिश करै थे। ");
INSERT INTO bgc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पर परमेसवर की मदद तै मै आज ताहीं बण्या सूं छोट्या-बड़या सारया कै स्याम्ही गवाही द्यूँ सूं, अर उन बात्तां नै छोड़ किमे कोनी कहन्दा जो नबियाँ अर मूसा नबी नै भी कह्या के होण आळी सै, ");
INSERT INTO bgc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","के मसीह नै दुख ठाणा होगा, अर वोए सब तै पैहल्या मरे होया म्ह तै जी उठकै, म्हारै माणसां म्ह गैर यहूदियाँ म्ह चाँदणे का प्रचार करैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जिब वो इस तरियां तै जवाब देण लागरया था, तो फेस्तुस नै ऊँच्ची आवाज म्ह कह्या, “हे पौलुस, तू बावळा सै। घणे ज्ञान नै तेरे ताहीं बावळा कर दिया सै।” ");
INSERT INTO bgc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पर पौलुस नै कह्या, “हे महामहिम फेस्तुस, मै बावळा कोनी, पर सच्चाई अर बुद्धि की बात कहूँ सूं। ");
INSERT INTO bgc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","राजा नै भी जिसकै स्याम्ही मै बिना डरे बोल्लण लागरया सूं, इन बात्तां का बेरा सै, अर मन्नै बिश्वास सै के इन बात्तां म्ह तै कोए उसतै लुक्ही कोनी, क्यूँके यो वाक्या गुप्त म्ह कोनी होया। ");
INSERT INTO bgc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","हे राजा अग्रिप्पा, के तू नबियाँ का बिश्वास करै सै? हाँ, मन्नै बेरा सै के तू बिश्वास करै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","फेर अग्रिप्पा नै पौलुस तै कह्या, “तू माड़े-से समझाण तै मन्नै मसीह बणाणा चाहवै सै?” ");
INSERT INTO bgc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुस बोल्या, “परमेसवर तै मेरी प्रार्थना सै के, देर या सबेर तै, पर ये सारे सुणण आळे, जो आज मेरी बात सुणै सै, वे मेरै समान हो जावै।” ");
INSERT INTO bgc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","फेर राजा अर अधिकारी अर बिरनीके अर उनकै गेल्या बैठणीये उठ खड़े होए, ");
INSERT INTO bgc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","न्यायालय तै बाहर लिकाड़कै आप्पस म्ह कहण लाग्गे, “यो माणस इसा तो किमे कोनी करदा, जो मौत की सजा या जेळ, म्ह गेरण जोग्गा हो।” ");
INSERT INTO bgc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पा नै फेस्तुस तै कह्या, “जै यो माणस कैसर की दुहाई न्ही देंदा, तो छूट सकै था।” ");
INSERT INTO bgc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जिब फेस्तुस राज्यपाल के जरिये यो पक्का होग्या के हम जहाज कै जरिये इटली देश जावां, तो उननै पौलुस अर कुछ दुसरे कैदियाँ ताहीं भी यूलियुस नामक औगुस्तुस सम्राट की पलटन कै एक सूबेदार कै हाथ्थां सौंप दिया। ");
INSERT INTO bgc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अद्र्मुत्तियुम नगर के एक जहाज पै जो आसिया परदेस कै किनारे की जगहां पै जाण पै था, पाणी रास्ते हमनै अपणा सफर शरु करया, अर अरिस्तर्खुस नामक जो मकिदुनिया परदेस के थिस्सलुनीके नगर का एक बसिन्दा था। ");
INSERT INTO bgc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दुसरे दिन हम सैदा नगर पोह्चाये गये, अर यूलियुस नै पौलुस पै दया करकै उस ताहीं साथियाँ कै उरै जाण दिया के उनतै जरूरी चीज ले आवां। ");
INSERT INTO bgc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ओड़ै तै हमनै सफर दुबारा शरु करया, हवा कै पलट होण कै कारण हम साइप्रस टापू की ओट म्ह होकै चाल्ले, ");
INSERT INTO bgc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","अर किलिकिया परदेस अर पंफूलिया किनारे कै लोवै कै समुन्दर म्ह होकै लूसिया के मूरा नगर म्ह उतरे। ");
INSERT INTO bgc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ओड़ै सूबेदार नै सिकन्दरिया नगर का एक जहाज इटली देश जान्दा होड़ मिल्या, अर उसनै म्हारै ताहीं उस जहाज पै चढ़ा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","जिब हम घणे दिनां ताहीं होळे-होळे चालकै मुश्किल तै कनिदुस कस्बे कै स्याम्ही पोहचे, तो इस करकै के हवा म्हारै ताहीं आग्गै बढ़ण कोनी देवै थी, हम सलमोने कै स्याम्ही तै होकै क्रेते टापू की आड़ म्ह चाल्ले, ");
INSERT INTO bgc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","अर उसकै किनारे-किनारे मुश्किल तै चालकै “शुभलंगरबारी” नामक एक जगहां पोहचे, जित्त तै लसया नगर लोवै था। ");
INSERT INTO bgc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","जिब घणे दिन बीत लिये अर पाणी कै सफर म्ह जोख्खम ज्यांतै होवै थी ब्रत के दिन इब बीत लिये थे। आखर म्ह पौलुस नै उन सारया ताहीं कहकै चेतावनी दी, ");
INSERT INTO bgc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“हे सज्जनों, मन्नै इसा लाग्गै सै के इस सफर म्ह मुश्किल अर घणा नुकसान, ना सिर्फ माळ अर जहाज की बल्के म्हारी जान का भी, होणआळा सै।” ");
INSERT INTO bgc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पर सूबेदार नै पौलुस की बात्तां तै कप्तान अर जहाज कै माल्लिक की बात्तां तै बाध मान्या। ");
INSERT INTO bgc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","शुभ लंगरबारी नाम का बंदरगाह जाड्डा काटण कै खात्तर सही कोनी था, ज्यांतै घणाए का विचार होया के ओड़ै तै आग्गै बढ़ जावां जै किसे तरियां तै हो सकै तो फीनिक्स पोहचकै जाड्डा काटै। यो तो क्रेते टापू का एक बंदरगाह सै जो दक्षिण-पश्चिम अर उत्तर-पश्चिम कान्ही खुलै सै। ");
INSERT INTO bgc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जिब दक्षिणी हवा होळे-होळे चाल्लण लाग्गी, तो न्यू सोच्या के उनकी तरकीब पूरी करण खात्तर बढ़िया बखत था, लंगर उठाया अर किनारे धोरै होन्दे होए क्रेते टापू कै किनारे जाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पर माड़ी वार म्ह धरती कै कान्ही तै बड्डी ए आँधी उठी, जो “यूरकुलिन” कुह्वावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जिब आँधी जहाज पै लाग्गी तो जहाज उसकै स्याम्ही ठैहर कोनी सक्या, इस करकै हमनै जहाज ताहीं हवा के बाहाव छोड़ दिया, अर इस्से तरियां बहन्दे होए चाल्ले गये। ");
INSERT INTO bgc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","फेर कौदा नामक एक छोट्टे-से टापू की आड़ म्ह बहन्दे-बहन्दे हम मुश्किल तै डोंगी नै बस म्ह कर सके। ");
INSERT INTO bgc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","फेर जहाज के मल्लाहां नै उस ताहीं ठाकै सही उपाय करकै जहाज ताहीं तळै तै रस्‍यां तै कसकै बाँधया, अर सुरतिस खाड़ी के चोरबालू पै फँस जाणकै डर तै उननै लंगर ताहीं थोड़े नीच्चै उतारकै जहाज ताहीं हवा के बाहाव के गैल-गैल बहण कै खात्तर छोड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","जिब हमनै आँधी तै घणे हिचकोले अर धक्के खाए, तो दुसरे दिन वे जहाज का माळ बगाण लाग्गे, ");
INSERT INTO bgc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","अर तीसरे दिन उननै अपणे हाथ्थां तै जहाज का साज-सामान भी बगा दिया। ");
INSERT INTO bgc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","जिब घणे दिन ताहीं ना सूरज, ना तारे दिक्खे अर बड्डी आँधी चाल्दी रही, तो आखर म्ह म्हारै बचण की सारी उम्मीद जान्दी रही। ");
INSERT INTO bgc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जिब वे घणे दिन ताहीं भूखे रह लिये, तो पौलुस नै उनकै बिचाळै खड़े होकै कह्या, “हे भाईयो, चाहिये था के थम मेरी बात मानकै क्रेते टापू तै आग्गै ए ना बढ़ते तो या मुसीबत न्ही आन्दी अर ना यो नुकसान ठान्दे। ");
INSERT INTO bgc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","पर इब मै थमनै समझाऊँ सूं के धीरज राक्खो, क्यूँके थारे म्ह तै किसे की जान का नुकसान कोनी होवैगा, पर सिर्फ जहाज का। ");
INSERT INTO bgc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","क्यूँके परमेसवर जिसका मै सूं, अर जिसकी भगति करुँ सूं, उसके सुर्गदूत नै आखरी रात मेरै धोरै आकै कह्या, ");
INSERT INTO bgc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘हे पौलुस, डरै मतना! तन्नै कैसर कै स्याम्ही खड्या होणा जरूरी सै। परमेसवर नै सारया ताहीं जो तेरे गेल्या सफर करै सै, जीवन दान दिया सै।’ ");
INSERT INTO bgc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ज्यांतै, हे भले माणसों, सब्र करो, क्यूँके मै परमेसवर का बिश्वास करुँ सूं, के जिसा मेरै तै कह्या गया सै, उसाए होगा। ");
INSERT INTO bgc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","पर म्हारै ताहीं किसे टापू पै जा टिकणा होगा।” ");
INSERT INTO bgc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जिब चौदहवीं रात आई, अर हम अद्रिया समुन्दर म्ह भटकदे होए हाँ डरे थे, तो आध्धी रात कै लोवै मल्लाहां नै अंदाजे तै जाण्या के हम किसे देश कै लोवै पोहच रहे सां। ");
INSERT INTO bgc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","पाणी की गहराई नाप्पण पै उननै एक सौ बीस फुट डून्घा पाया, अर थोड़ा आग्गै बढ़कै दुबारा थाह लेई तो नब्बै फुट पाया। ");
INSERT INTO bgc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","फेर पथरीली जगहां तै टकराण कै डर तै उननै जहाज की पिछली ओड़ चार लंगर गेरे, अर सबेरै होण की चाह करदे रहे। ");
INSERT INTO bgc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","पर जिब मल्लाह जहाज पै तै भाजणा चाहवैं थे, अर गलही तै लंगर गेरण कै बहाणै डोंगी समुन्दर म्ह उतार दी, ");
INSERT INTO bgc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","तो पौलुस नै सूबेदार अर सिपाहियाँ तै कह्या, “जै ये जहाज पै न्ही रहे, तो थम भी कोनी बच सकदे।” ");
INSERT INTO bgc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","फेर सिपाहियाँ नै जोड़े काटकै डोंगी गेर दी। ");
INSERT INTO bgc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जिब सबेरै होण पै था, फेर पौलुस नै न्यू कहकै, सारया ताहीं खाणा खाण कै खात्तर बिनती करी, “आज चौदहा दिन होगे सै के थम चिन्ता करते-करते भूखे रहे, अर किमे न्ही खाया। ");
INSERT INTO bgc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ज्यांतै थारे तै समझाऊँ सूं के किमे खा ल्यो, जिसतै थारा बचाव होवै, क्यूँके थारे म्ह तै किसे का सिर का एक बाल भी कोनी गिरैगा।” ");
INSERT INTO bgc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","न्यू कहकै उसनै रोट्टी लेकै सारया कै स्याम्ही परमेसवर का धन्यवाद करया अर तोड़कै खाण लाग्या। ");
INSERT INTO bgc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","इस बात तै वे सारे उत्साहित होकै खाणा खुवाण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","हम सारे मिलकै जहाज पै दो सौ छिहत्तर जणे थे। ");
INSERT INTO bgc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जिब वे खाणा खाकै छिक्क लिये, तो गेहूँ ताहीं समुन्दर म्ह बगाकै जहाज हल्का करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जिब दिन लिकड़या तो उननै उस देश ताहीं कोनी पिच्छाणा, पर एक खाड़ी देक्खी जिसका किनारा चौरस था, अर विचार करया के जै हो सकै तो इस्से पै जहाज नै टिकावै। ");
INSERT INTO bgc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","फेर उननै लंगरा ताहीं खोल कै समुन्दर म्ह छोड़ दिया अर उस्से बखत पाल के रस्से ढील्ले कर दिये, अर हवा कै स्याम्ही आगला पाल चढ़ाकै किनारे कै कान्ही चाल्ले। ");
INSERT INTO bgc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","पर दो समुन्दर के संगम की जगहां पड़कै उननै जहाज ताहीं टिकाया, अर आगला भाग तो टिक ग्या, पर पिछली ओड़ लहरा तै टूटण लाग्गी। ");
INSERT INTO bgc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","फेर सिपाहियाँ का यो विचार होया के कैदियाँ ताहीं मार देवैं, इसा ना हो के कोए तैर कै लिकड़ भाज्जै। ");
INSERT INTO bgc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पर सूबेदार नै पौलुस ताहीं बचाण की मर्जी तै उन ताहीं इस विचार तै रोक्या अर न्यू कह्या, के जो तैर सकै सै, पैहल्या छलाँग मारकै किनारे पै लिकड़ जावै। ");
INSERT INTO bgc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","अर बाकी कोए फट्टा पै, अर कोए जहाज की दुसरी चीज कै सहारै लिकड़ जावै। इस तरियां तै सारे धरती पै बच लिकड़े। ");
INSERT INTO bgc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जिब हम बच लिकड़े, तो बेरा लाग्या के यो माल्टा टापू कुह्वावै सै। ");
INSERT INTO bgc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ओड़ै के बासिन्दयां नै म्हारै पै अनोक्खी दया करी, क्यूँके मिह बरसण कै कारण ठण्ड थी, ज्यांतै आग सुलगाकै हम सारया ताहीं ठहराया। ");
INSERT INTO bgc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जिब पौलुस नै लाकड़ियाँ का भरोटा कठ्ठा करकै आग पै धरया, तो एक साँप आँच पाकै लिकड़या अर उसकै हाथ तै लिपट गया। ");
INSERT INTO bgc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जिब उन बासिन्दयां नै साँप ताहीं उसकै हाथ तै लिपटे होड़ देख्या, तो आप्पस म्ह कह्या, “साच्चए यो माणस खून्नी सै के फेर भी समुन्दर तै बच ग्या, तोभी न्याय नै जिन्दा कोनी रहण दिया।” ");
INSERT INTO bgc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","फेर उसनै साँप ताहीं आग म्ह झटक दिया, अर उस ताहीं किमे नुकसान कोनी होया। ");
INSERT INTO bgc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","पर वे लोग बाट देक्खै थे के वो सूज जावैगा या चाणचक पड़कै मर जावैगा, पर जिब वे घणी वार ताहीं देखदे रहे अर देख्या के उसका किमे भी कोनी बिगड़या, तो अपणा विचार बदलकै कह्या, “यो तो कोए देवता सै।” ");
INSERT INTO bgc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","उस जगहां कै लोवै-धोवै उस टापू कै प्रधान पुबलियुस की धरती थी। उसनै म्हारै ताहीं अपणे घरां ले जाकै तीन दिन मित्तर की ढाळ सेवा-पाणी करी। ");
INSERT INTO bgc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुबलियुस का बाप बुखार अर बवासीर तै बीमार पड्या था। आखर म्ह पौलुस नै उसकै धोरै कमरे म्ह जाकै प्रार्थना करी अर उसपै हाथ धरकै उस ताहीं ठीक करया। ");
INSERT INTO bgc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","जिब इसा होया तो उस टापू के बाकी बीमार पौलुस कै धोरै आये अर वे चंगे करे गये। ");
INSERT INTO bgc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","उननै म्हारा घणा आदर-मान करया, अर जिब हम चाल्लण लाग्गे तो जो किमे म्हारै खात्तर जरूरी था, उननै जहाज पै धर दिया। ");
INSERT INTO bgc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","तीन महिन्ने कै पाच्छै हमनै सिकन्दरिया जावण आळे जहाज पै सफर शरु करया, यो जहाज ठण्ड़ के कारण इस टापू म्ह ठैहरा होया था, इस जहाज के आगले भाग पै एक जोड़ी देवत्यां का एक निशान था। (दियुसकूरी गढ़ी होई थी) ");
INSERT INTO bgc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","सुरकूसा नगर म्ह लंगर गेर कै हम तीन दिन टिके रहे। ");
INSERT INTO bgc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ओड़ै तै आग्गै बढ़कै हम रेगियुम नगर म्ह आये, अर एक दिन कै पाच्छै दक्षिणी हवा चाल्ली, फेर हम दुसरे दिन पुतियुली नगर म्ह आये। ");
INSERT INTO bgc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ओड़ै हमनै बिश्वासी भाई मिले, उनकै कहणे तै हम उनकै उरै सात दिन ताहीं रहे, अर इस तरियां तै हम रोम देश कान्ही चाल्ले। ");
INSERT INTO bgc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","कुछ बिश्वासी भाई रोम देश तै म्हारी खबर सुणकै अप्पियुस कै चौक अर तीन-सराए ताहीं म्हारै तै फेटण नै लिकड़ आये, जिन नै देखकै पौलुस नै परमेसवर का धन्यवाद करया अर बड़ा उत्साहित होया। ");
INSERT INTO bgc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जिब हम रोम नगर म्ह पोहचे, तो पौलुस ताहीं एक सिपाही कै गेल्या जो उसकी रुखाळी करै था, एक्ले रहण का हुकम मिलग्या। ");
INSERT INTO bgc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीन दिन कै पाच्छै उसनै यहूदियाँ कै खास माणसां ताहीं बुलाया, अर जिब वे कठ्ठे होए तो उनतै कह्या, “हे भाईयो, मन्नै अपणे माणसां कै या बाप-दाद्या कै बीवारां कै बिरोध म्ह किमे भी कोनी करया, तोभी कैदी बणाकै यरुशलेम नगर तै रोमी सरकार कै हाथ्थां सौंप्या गया। ");
INSERT INTO bgc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","उननै मेरै ताहीं जाँचकै छोड़ देणा चाह्या, क्यूँके मेरै म्ह मौत कै जोग्गा कोए कसूर कोनी था। ");
INSERT INTO bgc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पर जिब यहूदी अगुवें इसकै बिरोध म्ह बोल्लण लाग्गे, तो मन्नै कैसर की दुहाई देणी पड़ी यो न्ही के मन्नै अपणे माणसां पै कोए दोष लाणा था। ");
INSERT INTO bgc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ज्यांतै मन्नै थारे ताहीं बुलाया सै के थारे तै मिलूं अर बतळाऊँ, क्यूँके इस्राएल की आस कै खात्तर वो मसीह इस बेल तै जकड़े होए सै।” ");
INSERT INTO bgc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","उननै उसतै कह्या, “ना हमनै तेरे बारै म्ह यहूदिया परदेस तै चिट्ठी पाई, अर ना बिश्वासी भाईयाँ म्ह तै किसे नै आकै तेरे बारै म्ह किमे बताया अर ना बुरा कह्या। ");
INSERT INTO bgc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पर तेरा विचार के सै? वोए हम तेरे तै सुणणा चाहवां सां, क्यूँके हमनै बेरा सै के हरेक जगहां इस पंथ कै बिरोध म्ह माणस बात करै सै।” ");
INSERT INTO bgc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","फेर जो यहूदी पौलुस कै गैल थे, उननै उसकै खात्तर एक दिन ठहराया, अर घणे माणस उसकै उरै कठ्ठे होए, अर वो परमेसवर कै राज्य की गवाही देंदा होया, अर मूसा नबी के नियम-कायदे अर नबियाँ की किताबां तै यीशु कै बारै म्ह समझा-समझाकै सबेरै तै साँझ ताहीं वर्णन करदा रहया। ");
INSERT INTO bgc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","फेर कुछां नै उन बात्तां ताहीं मान लिया, अर कुछां नै बिश्वास कोनी करया। ");
INSERT INTO bgc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","जिब वे आप्पस म्ह एक पंथ कोनी होए, तो पौलुस की इस बात कै कहण पै चाल्ले गये “पवित्र आत्मा नै यशायाह नबी कै जरिये थारे बाप-दाद्या तै सही ए कह्या था,” ");
INSERT INTO bgc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“जाकै इन माणसां तै कह, के सुणदे तो रहोगे, पर ना समझोगे, देखदे तो रहोगे, पर ना बुझ्झोगे! ");
INSERT INTO bgc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","क्यूँके ‘इन माणसां का मन मोट्टा अर उनके कान भारया हो गये सै, अर उननै अपणी आँख मूंद ली सै, इसा ना हो के वे कदे आँखां तै देक्खै अर कान्ना तै सुणै अर मन तै समझै अर पलटै, अर मै उन ताहीं ठीक करुँ।’ ");
INSERT INTO bgc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“इस करकै थम जाणो सो के परमेसवर कै इस उद्धार की कथा गैर यहूदियाँ कै धोरै भेज्जी गयी सै, अर वे स्वीकार करैगें।” ");
INSERT INTO bgc_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जिब उसनै न्यू कह्या तो यहूदी आप्पस म्ह घणे बहस करण लाग्गे अर ओड़ै तै चले गये। ");
INSERT INTO bgc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","वो पूरे दो साल अपणे किराए कै घर म्ह रहया, ");
INSERT INTO bgc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","अर जो उसकै धोरै आवै थे, उन सारया तै मिलदा रहया अर बिना रोक-टोक घणा निडर होकै परमेसवर कै राज्य का प्रचार करदा अर प्रभु यीशु मसीह की बात सिखान्दा रहया।");
INSERT INTO bgc_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","या चिट्ठी पौलुस की ओड़ तै सै, जो यीशु मसीह का दास सै अर परमेसवर के जरिये प्रेरित होण कै खात्तर चुण्या गया अर उसका सुसमाचार सुणाण खात्तर न्यारा करया गया सै। ");
INSERT INTO bgc_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","यीशु के इस दुनिया म्ह आण तै भोत पैहले परमेसवर नै वादा करया था, के वो नबियाँ कै जरिये इस सुसमाचार ताहीं जाहिर करै, जिननै इसके बारें म्ह पवित्र ग्रन्थ म्ह लिख्या सै। ");
INSERT INTO bgc_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","यो सुसमाचार परमेसवर के बेट्टे के बारें म्ह सै, जो म्हारा प्रभु यीशु मसीह सै। वो शारीरिक तौर पै तो राजा दाऊद की पीढ़ी तै पैदा होया, ");
INSERT INTO bgc_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","पर पवित्र आत्मा की शक्ति तै मरे होया म्ह तै जिन्दा होण के कारण परमेसवर का बेट्टा कुह्वाया। ");
INSERT INTO bgc_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","मसीह कै जरिये हमनै अनुग्रह अर प्रेरिताई परमेसवर तै मिली, ताके उसकै नाम कै कारण गैर यहूदी माणस मसीह म्ह बिश्वास करकै उसकी मान्नै, ");
INSERT INTO bgc_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","थम गैर यहूदी बिश्वासी जो रोम नगर म्ह सों, उन माणसां म्ह शामिल सों, जिन ताहीं परमेसवर नै यीशु मसीह के माणस होण खात्तर बुलाया सै। ");
INSERT INTO bgc_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","या चिट्ठी रोम नगर के उन सारे माणसां के नाम सै, जो परमेसवर के प्यारे सै, अर उसके पवित्र जन होण कै खात्तर बुलाए गये सै। मै प्रार्थना करुँ सूं, के म्हारै पिता परमेसवर अर प्रभु यीशु मसीह की ओड़ तै थारे ताहीं अनुग्रह अर शान्ति मिलदी रहवै। ");
INSERT INTO bgc_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","सब तै पैहल्या मै थम सारया कै खात्तर यीशु मसीह कै जरिये अपणे परमेसवर का धन्यवाद करुँ सूं, क्यूँके यीशु मसीह म्ह थारे बिश्वास का जिक्र साब्ती दुनिया म्ह होरया सै। ");
INSERT INTO bgc_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","परमेसवर, जिसकी सेवा मै पूरे मन तै करुँ सूं, अर उसकै बेट्टे के सुसमाचार कै बारै म्ह माणसां ताहीं बताऊँ सूं, वोए मेरा गवाह सै, के मै अपणी प्रार्थना म्ह थमनै किस तरियां सारी हाण याद करुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","अर बिनती करुँ सूं, के जै हो सक्या तो परमेसवर की इच्छा के मुताबिक मै थारे तै मिलण भी आऊँ। ");
INSERT INTO bgc_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","क्यूँके मै थारे तै मिलण की लालसा करुँ सूं, ताके मै थमनै कोए आत्मिक आशीष दियुँ जिसतै थम बिश्वास म्ह मजबूत हो जाओ। ");
INSERT INTO bgc_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","मेरे कहण का मतलब यो सै, के जिब मै थारे तै मिलु, तो मै थारे ताहीं अर थम मन्नै उत्साहित कर सको, थम मेरे बिश्वास नै जाणकै मजबूत हो जाओ, अर मै थारे बिश्वास नै जाणकै मजबूत हो जाऊँ। ");
INSERT INTO bgc_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","हे बिश्वासी भाईयो, मै चाहूँ सूं के थम इस बात नै जाणो, के मन्नै कई बार थारे धोरै आण की योजना बणाई, के मै थारे बीच म्ह उसीए आत्मिक बढ़ोतरी देख सकूँ, जिसी मन्नै बाक्की गैर यहूदियाँ म्ह देक्खी सै, पर इब तक मेरे आण म्ह रुकावट ए होन्दी रही सै। ");
INSERT INTO bgc_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","मै उन संस्कारी माणसां का जो यूनानी भाषा अर सभ्यता नै जाणै सै, अर जो माणस उनकी भाषा अर सभ्यता नै न्ही जाणते, अर अकलमंद अर बेअक्ल माणसां ताहीं वचन सुणाण का मन म्ह बोझ राक्खूँ सूं। ");
INSERT INTO bgc_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","इस करकै म्ह मै थमनै भी जो रोम नगर म्ह रहो सो, सुसमाचार सुणाण खात्तर जमा उत्सुक सूं। ");
INSERT INTO bgc_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","क्यूँके मै मसीह के सुसमाचार के बारें म्ह कोनी सरमान्दा, परमेसवर अपणी शक्ति के जरिये सब नै बचावै सै जो सुसमाचार पै बिश्वास करै सै, पैहल्या यहूदियाँ ताहीं अर फेर गैर यहूदी ताहीं। ");
INSERT INTO bgc_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","क्यूँके सुसमाचार हमनै बतावै सै, के परमेसवर अपणी नजर म्ह हमनै किस तरियां धर्मी बणावै सै। जो शरु तै लेकै अंत तक मसीह पै बिश्वास करण तै हो सै, जिसा पवित्र ग्रन्थ म्ह लिख्या भी सै, के परमेसवर अपणी नजर म्ह धर्मी जन बणावै सै, वो बिश्वास तै जिन्दा रहवैगा। ");
INSERT INTO bgc_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेसवर का छो तो उन माणसां की सारी अभगति अर अधर्म के काम्मां के कारण जो माणस करै सै, सुर्ग तै जाहिर हो सै, वो अपणे सब अधर्म के काम्मां तै माणस ताहीं, परमेसवर की सच्चाई के बारें म्ह जाणण तै रोक्कै सै। ");
INSERT INTO bgc_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","वे परमेसवर के बारें म्ह इस करकै सही अर आसान्नी तै जाण सकै सै, क्यूँके परमेसवर नै उन ताहीं इन बात्तां के बारें म्ह बताया सै। ");
INSERT INTO bgc_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","सच यो सै के दुनिया की शरुआत तै ए परमेसवर के अनदेक्खे गुण, उसकी अनन्त सामर्थ्य अर उनका परमेसवरत्व, दुनिया म्ह सै, अर दिक्खै भी सै, इस करकै माणस कै धोरै कोए बहाना कोनी, के वो परमेसवर नै न्ही जाणता। ");
INSERT INTO bgc_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","परमेसवर का ज्ञान होण पै, भी उननै ना तो उस ताहीं परमेसवर होण कै लायक सम्मान दिया, अर ना ए उसका धन्यवाद करया। इसके उल्ट वो उसके बारें म्ह बेकार की बात सोच्चण लाग्गे, अर जिसा उन ताहीं सोचणा चाहिए था उसा न्ही सोच्या, पर बुरा ए सोच्या। ");
INSERT INTO bgc_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","वे अपणे-आप ताहीं अकलमंद मानकै बेअक्ले बणगे, ");
INSERT INTO bgc_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","अर अविनाशी परमेसवर की महिमा न्ही करी, बल्के नाशवान माणस, अर पंछियाँ, रेंगण आळे अर चार पैरां आळे जानवरां की मूर्ति की आराधना करण लाग्गे। ");
INSERT INTO bgc_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","इस करकै परमेसवर नै उन ताहीं उनकै मन की बुरी इच्छा कै मुताबिक गलत काम करण खात्तर छोड़ दिया ताके वे आप्पस म्ह अपणे शरीरां तै गन्दे काम करै। ");
INSERT INTO bgc_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","क्यूँके उननै परमेसवर के बारें म्ह सच्ची बात्तां ताहीं जाणण की बजाये झूठ पै बिश्वास करया, अर सृष्टि की चिज्जां की आराधना अर सेवा करी, ना के उस सृजनहार परमेसवर की जो सदा खात्तर महिमा के लायक सै! आमीन। ");
INSERT INTO bgc_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ज्यांतै परमेसवर नै उन ताहीं उनकी नीच कामनाओं कै बस म्ह छोड़ दिया, जिस कारण उनकी लुगाईयाँ नै भी प्राकृतिक संभोग की जगहां अप्राकृतिक संभोग अपणालिया। ");
INSERT INTO bgc_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","उस्से तरियां ए लुगाईयाँ कै गेल्या प्राकृतिक संभोग नै छोड़कै माणस दुसरे माणस कै खात्तर आप्पस म्ह कामुकता म्ह जळण लाग्गे, अर माणस का माणस कै गेल्या बेशर्मी के काम करणा उनके उप्पर दण्ड लेकै आये। ");
INSERT INTO bgc_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","अर जिब उननै परमेसवर ताहीं जाणणा बेवकूफी लाग्या, तो परमेसवर नै भी उन ताहीं उनकै निकम्मे मन के बस म्ह छोड़ दिया, ताके वे बुरे काम करै। ");
INSERT INTO bgc_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ज्यांतै वे सारे ढाळ के अधर्म, दुष्टता, लालच, अर बैर-भाव तै भरगे, अर जळण, हत्या, झगड़े, छळ, ईर्ष्या तै भरगे, अर चुगलखोर, ");
INSERT INTO bgc_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","बदनाम करण आळे, परमेसवर तै नफरत करण आळे, बुराई करण आळे, दुसरयां की बेजती करण आळे, डिंगमार, घमण्डी, भुंडी-भुंडी बात्तां कै बणाण आळे, माँ-बाप का हुकम ना मानण आळे, ");
INSERT INTO bgc_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","बेअक्ले, बिश्वासघाती, प्यार अर दया की कमी अर निर्दयी होग्ये। ");
INSERT INTO bgc_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","वे तो परमेसवर की या धार्मिक विधि नै जाणै सै, के इसे-इसे काम करण आळे मौत के दण्ड कै जोग्गे सै, फेरभी ना सिर्फ आप ए इसे काम करै सै, बल्के इसे काम करण आळा तै राज्जी भी होवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","इस करकै हे मेरे बिश्वासी भाईयो, थम जो कोए भी क्यूँ ना हो, थारे धोरै इस बात का कोए जवाब कोनी, के थम जो दुसरयां पै दोष लगाओ सों, तो उस बात के कारण खुद अपणे-आप पै दण्ड लेकै आओ सों, क्यूँके जिस बात के बारें म्ह थम उसनै दोषी बणाओ हो, थम खुद भी वोए काम करो सों। ");
INSERT INTO bgc_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","हमनै यो बेरा सै, के परमेसवर उसका न्याय धार्मिकता कै साथ जरुर करैगा, जो इसे बुरे काम करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","जिब के थम जो इसे-इसे काम करणीया पै दोष लगाओ सों, अर खुद वैए काम करो सों, के न्यू समझों सों के थम परमेसवर के दण्ड तै बच जाओगे? ");
INSERT INTO bgc_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","के थम परमेसवर की भलाई, सहनशीलता, अर धीरजरूपी धन ताहीं तुच्छ जाणो सों? के थम न्ही समझते के परमेसवर की भलाई ए थारे ताहीं पाप छोड़णा सिखावै सै? ");
INSERT INTO bgc_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","पर थम हठिल्ले सों, अर पाप करणा न्ही छोड़दे, अर ना ए अपणे-आपनै बदलना चाहन्दे। इस करकै जिस दिन परमेसवर अपणा छो दिखावैगा, उस दिन धार्मिकता कै साथ उसका न्याय जाहिर होवैगा, अर वो थारे ताहीं भारी दण्ड देवैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेसवर हरेक नै उसकै काम कै मुताबिक फळ देवैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जो माणस भले काम करते रहवै सै, अर परमेसवर की महिमा, आदर अर अनन्त जीवन की खोज म्ह लाग्गे रहवै सै, परमेसवर उन सारया ताहीं अनन्त जीवन देवैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","पर जो मतलबी सै अर सच नै कोनी मान्दे, बल्के अधर्म नै मान्नैं सै, उनपै परमेसवर का छो अर प्रकोप पड़ैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","क्ळेश अर संकट हरेक माणस पै आवैगा। परमेसवर सबतै पैहल्या यहूदियाँ का अर बाद म्ह उन माणसां का न्याय करैगा जो गैर यहूदी सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","पर महिमा, आदर अर शान्ति हरेक नै मिलैगी, जो भले काम करै सै, पैहल्या यहूदी ताहीं फेर उन माणसां ताहीं जो गैर यहूदी सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","क्यूँके परमेसवर किसे का पक्षपात कोनी करदा। ");
INSERT INTO bgc_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","वे सारे गैर यहूदी माणस जिननै परमेसवर के नियम-कायदे जो मूसा नबी ताहीं मिले थे, उन ताहीं जाणे बिना जिसनै पाप करया सै, वे नियम-कायदा नै बिना जाणे नाश भी होवैंगें, पर जिन नै नियम-कायदे नै जाणकै भी पाप करया सै, उनका न्याय भी नियम-कायदे कै मुताबिक करया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","क्यूँके परमेसवर की निगांह म्ह नियम-कायदे कै सुणण आळे धर्मी माणस कोनी, पर नियम-कायदे पै चाल्लण आळा नै धर्मी बणावैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","फेर जिब गैर यहूदी लोग जिनकै धोरै मूसा नबी के नियम-कायदे कोनी, कुदरती तौर पैए नियम-कायदे की बात्तां पै चाल्लै सै, तो नियम-कायदे उनकै धोरै ना होण पै भी, उन ताहीं बेरा सै, के उननै के करणा सै, अर के न्ही करणा। ");
INSERT INTO bgc_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","वे नियम-कायदे की बात अपणे-अपणे दिलां म्ह लिखी होई दिखावै सै अर उनकी अन्तरात्मा भी इसकी गवाही देवैं सै, के ये बात सच सै, क्यूँके उनके विचार उनपै दोष लगावै सै, या फेर यो बतावै सै के वो ठीक करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","यो सब उस दिन स्पष्ट हो जावैगा, जिब परमेसवर मेरै जरिये सुणाये गये सुसमाचार के मुताबिक, माणसां की लुक्ही होई बात्तां का न्याय, यीशु मसीह कै जरिये करैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","थम खुद नै यहूदी कुह्वावै सों, अर मूसा नबी के नियम-कायदे पै भरोस्सा राक्खों सों, परमेसवर थारे पै दया करै सै, इस कारण थम घमण्ड करण लागरे सों। ");
INSERT INTO bgc_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","अर थमनै परमेसवर की मर्जी का बेरा से, थम आच्छी-आच्छी बात्तां नै तो चाहो सों, क्यूँके थारे ताहीं ये बात मूसा नबी के नियम-कायदे म्ह तै सिखाई गई सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","अर थमनै इस बात का पूरा भरोस्सा सै, के थम आंध्याँ नै राह दिखाण आळे अर अन्धकार म्ह भटके होए माणसां खात्तर परमेसवर का चाँदणा सों। ");
INSERT INTO bgc_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","अर बेअक्लां नै सिखाण आळे अर बाळकां के उपदेशक सों। थमनै बेरा सै के परमेसवर के नियम-कायदे थमनै पूरी तरियां तै ज्ञान अर सच्चाई देवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","इस करकै थम जो दुसरयां नै शिक्षा देओ सों, तो अपणे-आपनै शिक्षा क्यूँ न्ही देन्दे? थम उपदेश देओ सों, के “चोरी ना करियो,” के थम खुद चोरी कोनी करते! ");
INSERT INTO bgc_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","थम जो कहवै सों, के “जारी ना करियो,” के खुद जारी कोनी करते? थम जो मूर्तियाँ तै नफरत करो सों, के खुद ए मन्दरां नै कोनी लूटते? ");
INSERT INTO bgc_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","थम जो नियम-कायदे नै जाणण का घमण्ड करो सों, के नियम-कायदे नै ना मानकै परमेसवर का अनादर कोनी करते? ");
INSERT INTO bgc_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“थम यहूदियाँ के कारण गैर यहूदियाँ म्ह परमेसवर के बारें म्ह बुरा भला कह्या जावै सै, जिसा पवित्र ग्रन्थ म्ह लिख्या भी सै।” ");
INSERT INTO bgc_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","मै थमनै कुछ बताऊँ सूं, थारा खतना करया जाणा जिब्बे फायदेमन्द सै, जिब थम नियम-कायदा नै मान्नो, जै थम इसा न्ही करते तो थम उन माणसां की ढाळ सों जिनका खतना न्ही होया। ");
INSERT INTO bgc_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","जै बिना खतना करे होए माणस नियम-कायदे की विधियाँ नै मान्नै, तो परमेसवर उन ताहीं अपणे माणस क्यूँ न्ही कहवैगा। ");
INSERT INTO bgc_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","बिना खतना होए माणस जो परमेसवर के हुकमां नै मान्नै सै, वे थारी बुराई करैगें जिनकै धोरै परमेसवर के नियम-कायदे सै जिन ताहीं थम मानते न्ही। ");
INSERT INTO bgc_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","असली यहूदी वो कोनी जो सिर्फ यहूदी माँ-बाप तै पैदा होया सै, अर ना ए वो असली खतना सै, जो दिखाण खात्तर देह म्ह करया गया सै। ");
INSERT INTO bgc_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","यहूदी वो सै, जो अपणे मन म्ह यहूदी सै, अर खतना वो सै, जो पवित्र आत्मा के जरिये मन का करया जावै सै, ना के वो जो नियम-कायदा के मुताबिक करया जावै सै, इस ढाळ के माणसां की तारीफ माणसां की ओड़ तै न्ही, पर परमेसवर की ओड़ तै करी जावै सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","कोए कह सकै सै, के भला यहूदी होण का के फायदा, या खतना कराण का के फायदा? ");
INSERT INTO bgc_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","यहूदी होण के भोत फायदे सै, क्यूँके परमेसवर के वचन यहूदियाँ ताहीं ए सौंपे गये सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","अगर कुछ यहूदी माणस बिश्वासघाती लिकड़ै भी तो उसतै के फर्क पड़ै सै? परमेसवर अपणे वादे पूरा करण म्ह बिश्वास जोग्गा सै, तो इसका यो मतलब कोनी के परमेसवर भी बिश्वासघाती सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","न्ही! बिल्कुल न्ही! बल्के परमेसवर सच्चा सै, अर दुनिया का हरेक माणस झूठ्ठा ठैहरै, जिसा पवित्र ग्रन्थ म्ह परमेसवर के बारें म्ह लिख्या सै, “जिसतै तू अपणी बात्तां म्ह धर्मी साबित हो अर न्याय करदे बखत तू जीत पावै।” ");
INSERT INTO bgc_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","इस करकै जै म्हारे बुरे काम परमेसवर की धार्मिकता साबित कर देवै सै, तो हम के कह्वां? के न्यू कह्वां के परमेसवर जो छो करै सै, तो के वो अन्यायी सै? (यो तो मै दुनियावी नजरिये तै कहूँ सूं)। ");
INSERT INTO bgc_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","न्ही! बिल्कुल न्ही! जै परमेसवर यहूदी माणसां का न्याय सही तरिक्कें तै न्ही कर सकता, तो वो दुनिया के माणसां का भी न्याय सही तरिक्कें तै न्ही कर सकता? ");
INSERT INTO bgc_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","के कोए कह सकै सै, जै मेरा झूठ परमेसवर की सच्चाई नै दिखावै अर उसकी महिमा नै बढ़ावै, तो परमेसवर किस तरियां मन्नै परख के पापी साबित कर सकै सै? ");
INSERT INTO bgc_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","कई माणस यो कह के मेरे पै दोष लगावै सै, के “आओ, हम बुरे काम करा के इसतै ए कुछ भलाई हो जा।” जो मेरे बिरुध्द इसी बात कहवै सै वो दण्ड के लायक सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","तो फेर हम के कह सका सां? के हम यहूदी गैर यहूदियाँ तै आच्छे सां? कदे भी न्ही! क्यूँके हम यहूदी अर गैर यहूदी दोनुवां पै यो दोष ला चुके सां के वे सारे के सारे पाप की शक्ति के बस म्ह सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जिसा के पवित्र ग्रन्थ म्ह लिख्या सै: “कोए भी माणस परमेसवर की नजर म्ह धर्मी कोनी, एक भी कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोए भी माणस समझदार कोनी, कोए परमेसवर का टोह्ण आळा कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सारे माणस परमेसवर की राह तै भटक ग्ये सै, सबके सब परमेसवर की नजर म्ह निकम्मे बणगे सै, कोए भी भलाई करण आळा कोनी, एक भी कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","उनका मुँह खुली होई कब्र की ढाळ सै, जिस म्ह तै बदबू आवै सै। क्यूँके अपणे मुँह तै वे भुंडा बोल्लै सै, अर वे जो भी बोल बोल्लै सै वो साँप के जहर की तरियां जहरीले सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","उनका बोल श्राप अर कड़वाहट तै भरया सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","वो लहू बहाण खात्तर फुर्तीले सै, ");
INSERT INTO bgc_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","वे जित्त भी किते जावै सै ओड़ै नाश अर क्ळेश लेकै जावै सै, ");
INSERT INTO bgc_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","वे न्ही जाणते के माणसां के गैल खुशी अर शान्ति तै किस तरियां जीणा सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","उन म्ह परमेसवर का डर सै ए कोनी।” ");
INSERT INTO bgc_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","हमनै बेरा सै के मूसा नबी के नियम-कायदे जो कुछ कहवै सै, उन्हे तै कहवै सै, जो नियम-कायदे कै अधीन सै, ताके कोए भी माणस भान्ना न्ही बणा सकै, अर दुनिया के सारे माणस परमेसवर के स्याम्ही दोषी ठैहराये जावै। ");
INSERT INTO bgc_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","क्यूँके मूसा नबी के नियम-कायदे के पुगाण तै कोए माणस उसकै स्याम्ही धर्मी कोनी बणैगा, क्यूँके नियम-कायदा कै जरिये हमनै बेरा लाग्गै सै के हम पापी सां। ");
INSERT INTO bgc_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","पर इब नियम-कायदा नै मान्ने बिना धार्मिकता जो परमेसवर तै मिलै सै, अर जिसके बारें म्ह मूसा नबी के नियम-कायदा अर नबियाँ की किताब्बां म्ह भोत पैहले लिख्या सै, के परमेसवर हमनै धर्मी किस तरियां बणावै सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","मतलब यो के हम प्रभु यीशु मसीह पै बिश्वास करण तै धर्मी बणा सां, जो यीशु मसीह पै बिश्वास करण तै सब माणसां खात्तर सै। क्यूँके परमेसवर की नजर म्ह सब माणस एक समान सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","क्यूँके सारया नै पाप करया सै, अर सब परमेसवर की महिमा तै दूर होगे सै, ");
INSERT INTO bgc_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","परमेसवर नै म्हारे पै अनुग्रह करया, के उसनै यीशु मसीह के जरिये म्हारे ताहीं म्हारे पापां के दण्ड तै छुड़ा लिया, अर म्हारे ताहीं बिना कुछ करे धर्मी बणाया। ");
INSERT INTO bgc_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","परमेसवर नै यीशु मसीह ताहीं म्हारे पाप की कीमत चुकाण खात्तर इस दुनिया म्ह भेज्जा, यीशु मसीह नै म्हारे खात्तर अपणा लहू बहा के अपणी जान दे दी। ताके हम उसपै बिश्वास करण के जरिये परमेसवर कै धोरै आ सकां, अर उसनै इसा यो दिखाण खात्तर करया, के वो पैहले जमाने म्ह भी पापी माणसां गैल सबर तै रहण म्ह अर उनके पाप माफ करण म्ह धर्मी था, बल्के इब भी उसकी धार्मिकता जाहिर हो जावै, जिसतै वे खुद धर्मी बणै अर जो प्रभु यीशु म्ह बिश्वास राक्खै सै, वो परमेसवर की नजर म्ह भी धर्मी बण जावै। ");
INSERT INTO bgc_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तो के हम किसे बात पै घमण्ड कर सकां सां? उसकै खात्तर कोए जगहां न्ही। के नियम-कायदा के जरिये या उननै मानण कै जरिये सां? न्ही! पर यीशु मसीह पै बिश्वास करण तै घमण्ड करां सां। ");
INSERT INTO bgc_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","इस करकै हम इस नतीजै पै पोहचे सा, के परमेसवर म्हारे ताहीं यीशु मसीह पै बिश्वास करण कै जरिये धर्मी बणावै सै, ना के मूसा नबी के नियम-कायदा ताहीं मानण तै। ");
INSERT INTO bgc_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","परमेसवर सिर्फ यहूदियाँ ए का परमेसवर कोनी, पर वो गैर यहूदियाँ का भी परमेसवर सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","क्यूँके एक ए परमेसवर सै, जो खतना आळा नै यीशु मसीह पै बिश्वास करण तै अर बिन-खतना आळा ताहीं भी, बिश्वास कै जरिये धर्मी बणावै सै। ");
INSERT INTO bgc_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","तो के म्हारा बिश्वास नियम-कायदे नै बेकार बतावै सै? न्ही! बिल्कुल न्ही! बल्के इसके उल्ट जिब हम बिश्वास करा सां तो हम समझ जावां सां, के परमेसवर नै म्हारे ताहीं नियम-कायदा क्यूँ दिये। ");
INSERT INTO bgc_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","तो हम यहूदी होण के नाते म्हारे पूर्वज अब्राहम के बारें म्ह के कहवा। ");
INSERT INTO bgc_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","जै अब्राहम आच्छे काम्मां तै धर्मी बणाया जान्दा, तो वो इसका घमण्ड कर सकै था, पर वो परमेसवर के स्याम्ही आच्छे काम्मां के जरिये घमण्ड न्ही कर सकदा। ");
INSERT INTO bgc_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","पवित्र ग्रन्थ के कहवै सै? न्यू के “अब्राहम नै परमेसवर के वादे पै बिश्वास करया, अर परमेसवर नै उसके बिश्वास के कारण उस ताहीं धर्मी बणा दिया।” ");
INSERT INTO bgc_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","जो मेहनत करै सै उसकी मजदूरी नै ईनाम न्ही कहन्दे, बल्के वो तो उसका हक सै। ");
INSERT INTO bgc_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","पर माणस काम्मां के जरिये धर्मी कोनी बणता, पर भगतिहीन माणस जो परमेसवर पै बिश्वास करै सै उसके बिश्वास के करण वो धर्मी बणै सै। ");
INSERT INTO bgc_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","जिसनै परमेसवर बिना काम्मां कै धर्मी बणावै सै, पवित्र ग्रन्थ म्ह राजा दाऊद भी धन्य उस ताहीं कहवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्य सै, वे जिनके अधर्म माफ होए, अर पाप भूला दिये गये। ");
INSERT INTO bgc_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धन्य सै वो माणस जिसके पापां का हिसाब परमेसवर न्ही राखदा।” ");
INSERT INTO bgc_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","के या आशीष जिन माणसां का खतना हो लिया, उनकै ए खात्तर सै, या जिनका खतना न्ही होया उन खात्तर भी सै? हम न्यू कह्वां सां, “अब्राहम नै परमेसवर पै बिश्वास करया, अर परमेसवर नै उसके बिश्वास के कारण उस ताहीं धर्मी बणा दिया।” ");
INSERT INTO bgc_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","तो यो कद होया? खतने की हालत म्ह या बिना खतने की हालत म्ह? खतने की हालत म्ह कोनी पर बिना खतने की हालत म्ह। ");
INSERT INTO bgc_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","जिब अब्राहम का खतना न्ही होया था, जिब भी परमेसवर नै उस ताहीं स्वीकार करया, अर उस ताहीं धर्मी बणाया, खतने का निशान अब्राहम ताहीं अपनाण की छाप सै, इस करकै अब्राहम उन माणसां का आत्मिक पूर्वज सै, जो बिश्वास करै सै पर जिनका खतना न्ही होया, वो बिश्वास के जरिये धर्मी बणे। ");
INSERT INTO bgc_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","अर वो उन खतना करे होए माणसां का आत्मिक पूर्वज सै, जो ना सिर्फ खतना करे होए सै, पर उनका बिश्वास उसाए हो जिसा उनके पूर्वज अब्राहम का तब था, जिब उसका खतना न्ही होया था। ");
INSERT INTO bgc_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","परमेसवर नै अब्राहम ताहीं अर उसके वंश ताहीं पूरी दुनिया देण का वादा करया, यो इस करकै कोनी होया के अब्राहम नै नियम-कायदा ताहीं मान्या, क्यूँके उसनै परमेसवर पै बिश्वास करया, इस बजह तै उसनै उस ताहीं धर्मी बणा दिया। ");
INSERT INTO bgc_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","अब्राहम अर उसके वंश ताहीं यो वादा इस खात्तर दिया गया, क्यूँके उननै नियम-कायदा ताहीं मान्या, तो बिश्वास बेकार अर वादा झूठ्ठा लिकड़या। ");
INSERT INTO bgc_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","परमेसवर का छो नियम-कायदा नै ना मानण आळा पै पड़ै सै, अर जित्त नियम-कायदे कोनी ओड़ै उसका उल्लंघन भी कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","इस बजह तै वादा परमेसवर पै बिश्वास करण तै मिलै सै, जो अनुग्रह के मुताबिक से, यो वादा अब्राहम के सारे वंशा ताहीं मिल्या सै, ना कै सिर्फ उन ताहीं जो माणस मूसा नबी के नियम-कायदा नै मान्नै सै, पर उन माणसां कै खात्तर भी जो अब्राहम की ढाळ परमेसवर पै बिश्वास करै सै, क्यूँके अब्राहम ए म्हारे सारया का पूर्वज सै। ");
INSERT INTO bgc_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जिसा पवित्र ग्रन्थ म्ह लिख्या सै, “मन्नै तेरे ताहीं घणीए जात्तां का पूर्वज बणाया सै” परमेसवर की नजर म्ह अब्राहम म्हारा पूर्वज सै। उननै उस परमेसवर पै बिश्वास करया, जो मरे होया नै जिन्दा करै सै, अर जो बात सै ए न्ही उनका नाम इसा लेवै सै के मान्नो वे सै। ");
INSERT INTO bgc_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","19","परमेसवर नै अब्राहम तै कह्या, तेरे भोत-से वंश होवैंगे। पर अब्राहम नै सोच्या के बुढ़ापे म्ह, मेरै किस तरियां ऊलाद पैदा होगी? क्यूँके वो तकरीबन सौ साल का हो लिया था, अर सारा भी बूढ़ी होण के कारण बच्चे पैदा कोनी कर सकै थी। इन सारी बात्तां तै साफ जाहिर था, के उसके भोत-से वंशज न्ही हो सकदे, तोभी अब्राहम का बिश्वास कमजोर न्ही होया, वो परमेसवर के वादे पै बिश्वास करदा रह्या, अर उसनै आस न्ही तोड़ी। ");
INSERT INTO bgc_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","अर ना ए अबिश्वासी होकै परमेसवर कै वादा पै शक करया, पर बिश्वास म्ह पक्का होकै उसकी महिमा करी। ");
INSERT INTO bgc_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","अर पक्के तौर पै जाण्या के जिस बात का परमेसवर नै वादा करया सै, वो उसनै पूरा करण म्ह भी सामर्थी सै। ");
INSERT INTO bgc_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","अर परमेसवर नै उसके बिश्वास के कारण उस ताहीं धर्मी बणा दिया। ");
INSERT INTO bgc_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","अर पवित्र ग्रन्थ के इस वचन नै, “बिश्वास के कारण उस ताहीं धर्मी बणा दिया।,” ना सिर्फ यो वचन अब्राहम कै खात्तर लिख्या गया, ");
INSERT INTO bgc_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","बल्के म्हारै खात्तर भी जिनकै खात्तर लिख्या गया, जो बिश्वास के जरिये धर्मी बण जावैगा, यानिके के म्हारै खात्तर, जो उसपै बिश्वास करा सां, जिसनै म्हारै प्रभु यीशु ताहीं मरे होया म्ह तै जिन्दा करया। ");
INSERT INTO bgc_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","यीशु मसीह म्हारै अपराध्धा कै खात्तर पकड़वाया अर मारा भी गया, अर म्हारे ताहीं धर्मी बणाण कै खात्तर परमेसवर नै उस ताहीं जिन्दा कर दिया। ");
INSERT INTO bgc_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","इस करकै जिब हम मसीह पै बिश्वास करण तै धर्मी बणा दिए गये सां, तो परमेसवर तै म्हारा मेळ-मिलाप अपणे प्रभु यीशु मसीह कै जरिये हो लिया। ");
INSERT INTO bgc_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","बिश्वास कै जरिये मसीह नै म्हारी पोहच पिता के उस अनुग्रह तक कर दी सै। उस अनुग्रह म्ह हम बणे होए सां, अर परमेसवर की महिमा की आस म्ह खुश सां। ");
INSERT INTO bgc_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","सिर्फ योए न्ही, बल्के हम मुसीबतां म्ह भी खुश रहवां, न्यू जाणकै के मुसीबतां तै धीरज, ");
INSERT INTO bgc_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","धीरज तै खरयां लिकड़णा, अर खरे लिकड़ण तै आस होवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","अर आस तै निराशा न्ही होन्दी, क्यूँके पवित्र आत्मा जो परमेसवर नै म्हारै ताहीं दिया सै, उसकै जरिये परमेसवर का प्यार म्हारै मन म्ह भरया गया सै। ");
INSERT INTO bgc_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","क्यूँके जिब हम कमजोर थे, तो मसीह परमेसवर के बताये गये सही बखत पै बुरे माणसां कै खात्तर मरया। ");
INSERT INTO bgc_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","किसे धर्मी माणस कै खात्तर कोए जान देवै यो तो मुश्किल सै, पर शायद कोए भले माणस खात्तर जान देण खात्तर तैयार हो सकै सै। ");
INSERT INTO bgc_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","पर परमेसवर म्हारे पै अपणे प्यार की भलाई इस तरियां तै साबित करै सै, के जिब हम पापी ए थे, जिब्बे मसीह यीशु म्हारै खात्तर मरया। ");
INSERT INTO bgc_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","जिब के इब यीशु कै लहू बहाण के कारण परमेसवर नै म्हारे ताहीं अपणी नजर म्ह धर्मी बणाया सै, तो उसकै जरिये परमेसवर कै छो तै क्यांतै न्ही बचांगें? ");
INSERT INTO bgc_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","क्यूँके जिब हम परमेसवर के बैरी थे, तो उसकै बेट्टे की मौत कै जरिये म्हारा मेळ-मिलाप परमेसवर कै गेल्या होया, अर सब तै आच्छी बात या सै, के मेळ-मिलाप हो जाण के कारण उसकै बेट्टे यीशु मसीह के जरिये दिए गये जीवन कै कारण म्हारा उद्धार पक्का सै। ");
INSERT INTO bgc_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","इब तो म्हारे प्रभु यीशु मसीह कै जरिये, परमेसवर म्ह म्हारा मेळ-मिलाप होग्या सै, इस खात्तर हम उस म्ह खुश सां। ");
INSERT INTO bgc_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","परमेसवर नै एक माणस आदम बणाया, जिसकै कारण दुनिया म्ह पाप आया, अर उस पाप के करण मौत आई, अर इस तरियां तै मौत सारे माणसां म्ह फैलगी, क्यूँके आदम के वंश होण के कारण सब पापी बणगे। ");
INSERT INTO bgc_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","मूसा नबी के नियम-कायदा कै दिए जाण तै पैहले भी, दुनिया म्ह माणस पाप करै थे, पर वो पाप गिण्या कोनी जावै था, क्यूँके ओड़ै नियम-कायदे कोनी थे, जिन ताहीं तोड्या जा सकै। ");
INSERT INTO bgc_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","तोभी आदम तै लेकै मूसा नबी तक सब नै मौत आई। जिस तरियां आदम नै परमेसवर के हुकम ताहीं तोड्या उसकी तरियां हमनै उसके हुकम ताहीं न्ही तोड़ा, अर आदम यीशु मसीह का नमूना था जो आण आळा था। ");
INSERT INTO bgc_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","पर आदम के अपराध अर परमेसवर के अनुग्रह के वरदान के बीच म्ह एक भोत बड़ा अन्तर सै, क्यूँके जब एक माणस आदम, कै अपराध करण के कारण, भोत-से माणसां की मौत होई, पर दुसरे माणस यीशु मसीह के जरिये, परमेसवर का अनुग्रह भोत-से माणसां पै होया सै। ");
INSERT INTO bgc_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","तो परमेसवर के वरदान का नतिज्जा आदम के पाप तै भोत अलग सै। उसका पाप दण्ड लेकै आवै सै, पर परमेसवर का वरदान म्हारे ताहीं धर्मी बणावै सै, भलाए हम कई पापां के दोषी क्यूँ ना हो। ");
INSERT INTO bgc_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","क्यूँके एक माणस के अपराध कै कारण सब नै मौत आई। पर इसतै ज्यादा परमेसवर का अनुग्रह अर धार्मिकता का वरदान सै, जो उस ताहीं पावै सै, वो पाप अर मौत पै यीशु मसीह कै जरिये जयवन्त होवै सै, अर वे उसकै गैल अनन्त जीवन म्ह राज करैगें। ");
INSERT INTO bgc_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","जिस तरियां आदम का अपराध, सारे माणसां कै खात्तर दण्ड लेकै आया, ठीक उस्से तरियां ए मसीह यीशु के धार्मिकता के काम करण तै, सारे माणसां नै जिन्दगी मिली, अर वे परमेसवर की नजर म्ह धर्मी बणै। ");
INSERT INTO bgc_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","क्यूँके जिसा एक माणस कै हुकम ना मानण तै भोत-से माणस पापी बणे, उस्से तरियां ए एक माणस कै हुकम मानण तै भोत-से माणस धर्मी बणैगें। ");
INSERT INTO bgc_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","मूसा के नियम-कायदे म्हारे ताहीं इस खात्तर दिए गये, ताके माणस देख सकै के वे कितने पापी सै पर जिब माणस पाप पै पाप करै सै, तो ओड़ै परमेसवर का अनुग्रह उसतै भी घणा होया करै। ");
INSERT INTO bgc_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","सारे माणसां नै पाप पै पाप करया, अर वे मरगे, पर म्हारै प्रभु यीशु मसीह कै जरिये परमेसवर का अनुग्रह हमनै धर्मी बणावै सै, अर म्हारे ताहीं अनन्त जीवन देवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","कोए कह सकै सै? के परमेसवर अपणे अनुग्रह तै म्हारे पाप माफ करै सै, पर इसा मत सोच्चों के पाप करदे रहवां ताके अनुग्रह घणा हो। ");
INSERT INTO bgc_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","न्ही! बिल्कुल न्ही! हम जिब पाप कै खात्तर मरग्ये तो हमनै आग्गै तै दुबारा पाप न्ही करणा चाहिए। ");
INSERT INTO bgc_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","हम जाणा सां, के हम सारे जिननै मसीह यीशु के नाम म्ह बपतिस्मा लिया सै, यो इसा सै, के जिसा हम मसीह के गैल मर जाणा। ");
INSERT INTO bgc_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","इस करकै जिब हम बपतिस्मा लेवां सां, तो हम उसकै साथ मर जावां सां, अर उसके साथ गाड्डे जावां सां, ताके जिस तरियां मसीह पिता परमेसवर की महिमा कै जरिये मरे होया म्ह तै जिन्दा करया गया, उस्से तरियां ए हमनै भी नया जीवन जीणा चाहिए। ");
INSERT INTO bgc_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","क्यूँके जै हम उसकी मौत की समानता म्ह बपतिस्में के जरिये उसके गेल्या एक हो जावां सां, तो पक्के तौर पै उसकै जिन्दा उठण की समानता म्ह भी एक हो जावांगें। ");
INSERT INTO bgc_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","इस्से तरियां म्हारा पुराणा पापी सुभाव यीशु मसीह कै गेल्या क्रूस पै चढ़ाया गया, ताके जो पापी सुभाव म्हारी देह म्ह सै वो नाश हो जावै, अर हम आग्गै दुबारा पाप की गुलामी म्ह न्ही रहवां। ");
INSERT INTO bgc_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","क्यूँके जिब हम मसीह के गैल मरा सां, तो हम पाप की शक्ति तै आजाद हो जावां सां। ");
INSERT INTO bgc_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","इस करकै जै हम मसीह कै गेल्या मरगे, तो म्हारा बिश्वास यो सै के उसकै गेल्या जीवांगें भी। ");
INSERT INTO bgc_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","क्यूँके न्यू बेरा सै, के मसीह मरे होया म्ह तै जिन्दा उठकै दुबारा फेर न्ही मरैगा, उसपै फेर मौत का राज न्ही होवैगा। ");
INSERT INTO bgc_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","क्यूँके मसीह पाप कै खात्तर एक ए बार मर गया, पर इब जो जिन्दा सै, तो परमेसवर की महिमा करण कै खात्तर जिन्दा सै। ");
INSERT INTO bgc_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","इस्से तरियां थम भी अपणे-आप ताहीं पाप कै खात्तर तो मरया होड़, पर परमेसवर की महिमा करण खात्तर मसीह यीशु म्ह जिन्दा समझो। ");
INSERT INTO bgc_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","इस करकै पाप की लालसा थारी नाश होण आळी देह म्ह राज न्ही करै, के थम उसकी लालसाओं के कब्जे म्ह ना रहो। ");
INSERT INTO bgc_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","अपणे देह के अंगा ताहीं अधर्म कै काम्मां खात्तर इस्तमाल ना करो, पर अपणे-आप ताहीं मरे होया म्ह तै जिन्दे जाणकै अपणी जिन्दगी परमेसवर ताहीं दे दो, अर अपणे देह के अंगा ताहीं धार्मिक काम्मां खात्तर परमेसवर नै सौंप दो। ");
INSERT INTO bgc_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","फेर थारे पै पाप का राज कोनी होवैगा, क्यूँके थम नियम-कायदे कै अधीन म्ह न्ही, बल्के परमेसवर के अनुग्रह कै अधीन म्ह जीण लागरे सों। ");
INSERT INTO bgc_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","तो इसका मतलब के सै? के हम नियम-कायदे का अधीन म्ह न्ही, बल्के परमेसवर के अनुग्रह कै अधीन सां, इस करकै के हम पाप कर सका सां? न्ही! बिलकुल न्ही! ");
INSERT INTO bgc_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","थम जाणो सों के जिब थम खुद नै किसे का गुलाम होण खात्तर देओ सों, तो थम वोए करो सों, जो थारा माल्लिक कहवै सै। थम पाप के गुलाम भी बण सकों सों, जो मौत लेकै आवै सै, या फेर थम परमेसवर के हुकम नै मानकै धार्मिकता का जीवन जी सको सों। ");
INSERT INTO bgc_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","थम पाप के गुलाम थे, पर इब थमनै वे सारी शिक्षा मान्नी सै, जो थारे ताहीं मिली थी, इस करकै मै परमेसवर का धन्यवाद करुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","इब पाप की शक्ति तै छुटाये जाकै परमेसवर के दास बणो ताके थम धर्म के काम करो। ");
INSERT INTO bgc_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","मै थारे ताहीं आसान तरिक्कें लिखूँ सूं, ताके आम आदमी भी आसान्नी तै समझ सकै, के जिब थम अपणी पिच्छली जिन्दगी की गुलाम थे, अर थम हरेक ढाळ के अशुद्ध अर भुन्डे़ काम करो थे। तो इब थम अपणी देह नै धार्मिक जीवन के दास बणा ल्यो, ताके थम पवित्र जीवन जी सको। ");
INSERT INTO bgc_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","जिब थम पाप के गुलाम थे, तो थम धार्मिकता के काम न्ही कर पाओ थे। ");
INSERT INTO bgc_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","थम बुरा काम करो थे, अर इब उन बुरे काम्मां के कारण शर्मिन्दा सों, तो थमनै के मिल्या? इन सारी बात्तां का नतिज्जा मौत सै। ");
INSERT INTO bgc_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पर इब पाप तै आजाद होकै अर परमेसवर के दास बणकै इब थम वो काम करो सों, जिसतै थम पवित्र बणो सों, अर उसका नतिज्जा अनन्त जीवन सै। ");
INSERT INTO bgc_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","क्यूँके पाप का नतिज्जां तो मौत सै, पर परमेसवर का वरदान म्हारै प्रभु मसीह यीशु म्ह अनन्त जीवन सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","हे बिश्वासी भाईयो, थमनै बेरा सै, (मै नियम-कायदे के जाणण आळा तै कहूँ सूं) के जिब ताहीं माणस जिन्दा रहवै सै, तब तक उसनै नियम-कायदे मानने पड़ैगें। ");
INSERT INTO bgc_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","उदाहरण के तौर पै एक ब्याता लुगाई नै मरते दम तक नियम-कायदे कै मुताबिक अपणे धणी कै साथ रहणा चाहिये, पर जै धणी मर जा, तो वा धणी के नियम-कायदे तै आजाद हो जा सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ज्यांतै जै धणी कै जिन्दे जी वा किसे दुसरे माणस की हो जावै, तो जार कुह्वावैगी, पर जै धणी मर ज्या, तो वा उस नियम-कायदे तै आजाद हो जा सै, उरै ताहीं के जै किसे दुसरे माणस की हो जावै तोभी जार कोनी ठैहरैगी। ");
INSERT INTO bgc_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","उस्से तरियां ए हे मेरे बिश्वासी भाईयो, जिब थम मसीह कै साथ मरगे, तो थम नियम-कायदा खात्तर मरेगे, इब थम मसीह के हो, जो मरे होया म्ह तै जिन्दा उठ्या, ताके हम परमेसवर कै खात्तर धार्मिक जीवन जी सका। ");
INSERT INTO bgc_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","क्यूँके जिब हम अपणे देह की इच्छा के मुताबिक जिवां सां, तो पाप की लालसा म्हारै अंगा म्ह काम करै सै, अर नियम-कायदे ए उन लालसा नै उजाग्गर करकै मौत नै लेकै आवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","हम नियम-कायदा खात्तर मरगे जिसकै बन्धन म्ह हम पैहले थे। इब हम पवित्र आत्मा की मानकै, नये सिरे तै परमेसवर की सेवा कर सकां सां। ");
INSERT INTO bgc_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","तो हम के कह्वां? के मूसा नबी के नियम-कायदे पाप सै? न्ही! बिलकुल न्ही! बल्के नियम-कायदा ए सै, जो मेरे ताहीं बतावै सै, के पाप के सै! जै नियम-कायदे न्ही कहन्दे, के लालच मतना करै तो मै लालच नै जाण ए न्ही पान्दा। ");
INSERT INTO bgc_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","पर पाप नै मौक्का पाकै, हुकम कै जरिये मेरै म्ह सारी तरियां का लालच पैदा करया, क्यूँके बिना नियम-कायदे पाप मुर्दा सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","एक बखत था जिब मै मूसा नबी के नियम-कायदे बिना जीऊँ था, पर जिब मन्नै मूसा नबी के नियम-कायदा ताहीं जाण्या, तो मेरे म्ह पाप करण की इच्छा होण लाग्गी, अर मै मरे होया जिसा होग्या। ");
INSERT INTO bgc_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","अर वो हुकम जिसतै मन्नै जिन्दगी मिलणी थी वो मेरी आत्मिक मौत का कारण बण्या। ");
INSERT INTO bgc_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","क्यूँके पाप नै मौक्का पाकै हुकम कै जरिये मेरै ताहीं भकाया, अर उस्से कै जरिये मेरी आत्मिक मौत भी हो गई। ");
INSERT INTO bgc_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ज्यांतै हम यो नतिज्जा लिकाड़ा सां, के नियम-कायदे पवित्र सै, अर हुकम पवित्र, धर्मी अर खरया सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","तो के मूसा नबी के नियम-कायदे जो खरे थे, मेरै खात्तर मौत लेकै आये? न्ही! बिलकुल न्ही! यो पाप ए था जिसनै इसा करया। पर नियम-कायदे जो खरे थे, मेरै खात्तर मौत लेकै आये, ताके पाप की असलियत जाहिर हो जा, अर हुकम दिखावै सै के पाप घणाए बुरा सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","क्यूँके हमनै बेरा सै, के मूसा नबी के नियम-कायदे तो आत्मिक सै, पर मै शारीरिक सूं, अर पाप का गुलाम सूं। ");
INSERT INTO bgc_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","अर जो मै करुँ सूं, उस ताहीं कोनी जाण्दा, क्यूँके जो मै चाहूँ सूं, वो न्ही करया करदा, पर जिसतै मन्नै घृणा आवै सै वोए करै सूं। ");
INSERT INTO bgc_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","जै जो मै न्ही चाहन्दा वोए बुरे काम करुँ सूं, तो मै मान ल्यूँ सूं, के मूसा नबी के नियम-कायदे खरे सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","तो इसी हालत म्ह जो मेरे म्ह बुरे काम करै सै, वो मै न्ही, बल्के पाप सै, जो मेरै म्ह बस्या होया सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","क्यूँके मन्नै बेरा सै के मेरै म्ह यानिके मेरे पापी सुभाव म्ह कोए आच्छी चीज वास कोनी कर दी। मेरा जी तो भले काम करण की इच्छा तो करै सै, पर भले काम मेरै तै बणदे कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","क्यूँके जिस आच्छे काम करण नै मेरा जी करै सै, वो तो कोनी करदा, पर जो बुरे काम करणा न्ही चाहन्दा, वोए करुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","इस करकै जै मै वोए करुँ सूं जो न्ही चाहन्दा, तो उसका करण आळा मै कोनी रहया, पर पाप सै जो मेरै भित्तर म्ह बस रहया सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","इस तरियां तै मन्नै सच का बेरा पटै सै, के जिब मै भलाई करण की इच्छा करुँ सूं, तो बुराई ए करुँ सूं। ");
INSERT INTO bgc_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","क्यूँके मै भीतरी माणस-पण तै तो परमेसवर के नियम-कायदे तै घणा खुश रहूँ सूं। ");
INSERT INTO bgc_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","पर मेरे भित्तर एक नियम-कायदा की शक्ति काम करण लागरी सै, जो मेरी पापी अन्तरात्मा तै युध्द करै सै। या नियम-कायदा की शक्ति मेरी अन्तरात्मा नै पाप का गुलाम बणावै सै जो इब भी मेरी देह म्ह सै। ");
INSERT INTO bgc_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","मै किसा निरभागा माणस सूं! मन्नै इस पापी सुभाव तै जो मौत लेकै आवै सै, कौण छुड़ावैगा? ");
INSERT INTO bgc_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","म्हारै प्रभु यीशु मसीह कै जरिये परमेसवर का धन्यवाद होवै। ज्यांतै मै अपणी समझ तै तो परमेसवर के नियम-कायदे नै मानना चाहूँ सूं, पर पापी सुभाव के कारण मै पाप का गुलाम सूं। ");
INSERT INTO bgc_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","इस करकै इब जो मसीह यीशु पै बिश्वास करै सै, उनपै दण्ड का हुकम कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","क्यूँके पवित्र आत्मा थमनै वा जिन्दगी देवैगा, जो मसीह यीशु की ओड़ तै आवै सै, अर वो थारे ताहीं पाप अर मौत तै आजाद करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","क्यूँके जो काम मूसा नबी के नियम-कायदे पापी सुभाव कै कारण देह म्ह न्ही कर सके, उस ताहीं परमेसवर नै करया, यानिके अपणे ए बेट्टे ताहीं इन्सान के रूप म्ह पापबलि होण कै खात्तर भेज दिया, परमेसवर नै पाप की शक्ति ताहीं अपणे बेट्टे की देह के बलिदान के जरिये तोड़ दिया। ");
INSERT INTO bgc_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ज्यांतै के मूसा नबी के नियम-कायदे की विधि म्हारै म्ह पूरी करी जावै, जो पापी सुभाव कै मुताबिक न्ही, बल्के पवित्र आत्मा कै मुताबिक चाल्लै सै, ");
INSERT INTO bgc_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","क्यूँके जो अपणे पापी सुभाव के कारण चाल्लै सै, वो बुरी चिज्जां कै बारें म्ह सोच्चै सै, पर जो-जो पवित्र आत्मा के जरिये चाल्लै सै, वो उन चिज्जां के बारें म्ह सोच्चै सै, जो पवित्र आत्मा ताहीं खुश करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","जै थम अपणी पापमय लालसा के मुताबिक चाल्लोंगे तो मरोगे, पर पवित्र आत्मा के कहे मुताबिक चाल्लोंगे तो जिन्दगी अर शान्ति पाओगे। ");
INSERT INTO bgc_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","क्यूँके पापमय लालसा के मुताबिक चालणा तो परमेसवर तै बैर राखणा सै, क्यूँके ना तो वो परमेसवर के नियम-कायदे कै अधीन सै अर ना कदे हो सकै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","अर जो पापमय लालसा के मुताबिक चाल्लै सै, वे परमेसवर नै खुश न्ही कर सकदे। ");
INSERT INTO bgc_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पर जिब के परमेसवर का पवित्र आत्मा थारे म्ह बसै सै, तो थम पापमय लालसा के मुताबिक न्ही पर पवित्र आत्मा के कहे मुताबिक चाल्लों। जै किसे म्ह मसीह का आत्मा कोनी चाल्दा तो वो परमेसवर का माणस कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","जै मसीह थारे म्ह वास करै सै, तो पाप कै कारण देह मरी होई सै, पर धार्मिकता कै कारण थारी आत्मा जिन्दा सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","जै परमेसवर का आत्मा जिसनै मसीह यीशु ताहीं मरे होया म्ह तै जिन्दा करया, थारे म्ह बस्या होया सै, तो जिसनै मसीह ताहीं मरे होया म्ह तै जिन्दा करया, वो थारी नाश होण आळी देह नै भी अपणे पवित्र आत्मा कै जरिये जिन्दा करैगा, जो थारे म्ह बस्या होया सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","इस करकै हे बिश्वासी भाईयो, हम पापी सुभाव के कर्जदार कोनी के हम इसकै मुताबिक बरताव करां। ");
INSERT INTO bgc_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","क्यूँके जै थम पापी सुभाव के मुताबिक जीओगे, तो मरोगे जै पवित्र आत्मा तै पापमय लालसा के काम्मां नै मारोगे तो जिन्दे रहोगे। ");
INSERT INTO bgc_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ज्यांतै के जितने माणस परमेसवर के आत्मा के चलाए चाल्लै सै, वैए परमेसवर की ऊलाद सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","क्यूँके थारे ताहीं गुलामी की आत्मा कोनी दी गई, के थम डरो, पर पवित्र आत्मा हमनै परमेसवर की ऊलाद बणावै सै, जिसतै हम हे अब्बा, हे पिता कहकै बोल्लां सां। ");
INSERT INTO bgc_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","पवित्र आत्मा आप ए म्हारी आत्मा कै गेल्या गवाही देवै सै, के हम परमेसवर की ऊलाद सां, ");
INSERT INTO bgc_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","अर जै ऊलाद सां तो वारिस भी, बल्के परमेसवर के वारिस अर मसीह कै संगी वारिस सां, अगर हम मसीह के ढाळ दुख ठावांगे, तो हम उसकी महिमा म्ह भी शामिल हो पावांगे। ");
INSERT INTO bgc_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","मन्नै पक्का यकिन सै, के इस बखत के दुख अर क्ळेश उस महिमा कै स्याम्ही, उस महिमा के समान जो प्रभु म्हारै ताहीं देवैगा, किमे भी कोनी सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","क्यूँके सृष्टि की सारी चिज्जें घणी उम्मीद भरी निगांह तै परमेसवर की ऊलाद की बाट देखण लागरी सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","परमेसवर की बणाई गई हर एक चीज नै अपणे मकसद ताहीं खो दिया सै, यो इस करकै न्ही के सृष्टि खुद चाहवै थी, पर परमेसवर नै इसा करया, पर फेर भी आस सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","सृष्टि भी खुद उस दिन की बाट देक्खै सै, जिब वो मौत अर विनाश की गुलामी तै छुटकारा पाकै, परमेसवर की महिमा म्ह उसकी ऊलाद कै साथ शामिल होवैंगे। ");
INSERT INTO bgc_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","क्यूँके हमनै बेरा सै के सारी सृष्टि इब ताहीं मिलकै कराहती अर दर्दांं म्ह पड़ी, उस जनानी की तरियां सै, जिसा बच्चा होण तै पैहले दर्दांं म्ह तड़फै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","अर सिर्फ परमेसवर की बणाई सृष्टि ए न्ही, पर हम भी जिस म्ह होण आळी महिमा के पैहले तै स्वाद चखण के रूप म्ह पवित्र आत्मा का वास सै, हम खुद भी अपणे-आप म्ह कराहवा सां। यो जिब्बे होगा जिब हम देह तै आजाद होवांगे, अर परमेसवर हमनै अपणी ऊलाद बणाण कै खात्तर अपणावै। ");
INSERT INTO bgc_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","आण आळी महिमा की आस के जरिये ए थारा उद्धार होया सै, जै थम उन चिज्जां की आस राक्खों सों जो थारे धोरै पैहले तै सै, तो थारी आस धरणा बेकार सै, कोए भी उस चीज की आस कोनी राखदा, जो उसकै धोरै पैहले तै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","हम उन चिज्जां की आस करां सां, जो म्हारे धोरै इब ताहीं सै कोनी, तो हम धीरज तै बाट देक्खां सां, जिब तक वो चीज हमनै मिल ना जावै। ");
INSERT INTO bgc_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","प्रार्थना करण खात्तर म्हारे धोरै बुद्धि कोनी, पर पवित्र आत्मा म्हारी मदद करै सै, क्यूँके हमनै न्ही बेरा के किन बात्तां कै खात्तर प्रार्थना करणी चाहिये, पर पवित्र आत्मा आप्पे इसी आह भर-भरकै, जो बयान तै बाहरणै सै, म्हारै खात्तर बिनती करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","परमेसवर जो मनां का जाँचण आळा सै उसनै बेरा सै, के पवित्र आत्मा का मकसद के सै? क्यूँके वो पवित्र माणसां कै खात्तर परमेसवर की मर्जी कै मुताबिक बिनती करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","हमनै बेरा सै के जो माणस परमेसवर तै प्यार राक्खै सै, उनकै खात्तर सारी बात मिलकै भलाई ए नै पैदा करै सै, यानिके उनकै खात्तर जो उसकी मर्जी कै मुताबिक चुणे होए सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","क्यूँके जिन ताहीं परमेसवर नै पैहल्या तै चुण्या होया सै, उन ताहीं उसकै बेट्टे यीशु मसीह जिसे बणण खात्तर ठहराया भी सै, ताके वो घणे भाईयाँ म्ह पैहल्ड़ा यानी जेट्ठा बणै। ");
INSERT INTO bgc_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","फेर जिन माणसां ताहीं उसनै पैहल्या तै ठैहराया, उन ताहीं चुण्या भी, अर जिन ताहीं चुण्या, उन ताहीं धर्मी भी बणाया सै, अर जिन ताहीं धर्मी बणाया, उन ताहीं अपणी महिमा म्ह भागीदारी भी बणाया सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","तो इन बात्तां तै हम यो नतिज्जां लिकाड़ा सां, जै परमेसवर म्हारी कान्ही सै, हमनै कौण हरा सकै सै? ");
INSERT INTO bgc_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","परमेसवर वो सै जिसनै अपणे खुद कै बेट्टे ताहीं भी म्हारे खात्तर बलिदान करण म्ह कोए संकोच कोनी करया, तो जो उसनै म्हारे तै वादा करया सै, वो सारा कुछ म्हारे ताहीं क्यूँ न्ही देवैगा? ");
INSERT INTO bgc_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","कोए भी हमनै परमेसवर के स्याम्ही दोषी न्ही ठैहरा सकता? परमेसवर ए सै जो म्हारे ताहीं धर्मी बणावै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","कोए भी हमनै दोषी न्ही ठैहरा सकता? क्यूँके यीशु मसीह ए सै, जो मरया बल्के मुर्दां म्ह तै जिन्दा भी उठ्या, अर परमेसवर कै सोळी ओड़ सै, अर म्हारै खात्तर बिनती भी करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कौण हमनै मसीह कै प्यार तै न्यारा करैगा? के क्ळेश, संकट, उपद्रव, अकाळ, नंगाई, जोख्खम, या तलवार? ");
INSERT INTO bgc_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जिसा पवित्र ग्रन्थ म्ह लिख्या सै, “तेरे खात्तर लोग हमनै रोज मारण की धमकी देवै सै, हम मरण आळी भेड्डां की तरियां समझे गये सां।” ");
INSERT INTO bgc_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","पर इन सारी बात्तां म्ह हम उसकै जरिये जिसनै म्हारै तै प्यार करया सै, जयवन्त तै भी बाध सै। ");
INSERT INTO bgc_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","क्यूँके मै जाणु सूं, के कोए भी चीज मसीह नै म्हारे तै प्यार करण तै न्ही रोक सकदी। इसतै कोए फर्क न्ही पड़ता के चाहे हम जिवां या मरा, सुर्गदूत, प्रधानताएँ, शक्तियाँ जो सुर्ग म्ह सै इन म्ह तै कोए भी हमनै मसीह के प्यार तै अलग न्ही कर सकदी, अर इब जो होण लागरया सै, जो भविष्य म्ह होण आळा सै, गहराई, ऊँचाई हमनै परमेसवर के प्यार तै, जो म्हारे प्रभु यीशु मसीह म्ह सै अलग न्ही कर सकदी। ");
INSERT INTO bgc_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","3","जै कोए भी चीज हमनै परमेसवर के प्यार तै अलग न्ही कर सकदी, तो क्यूँ इस्राएली, मेरे यहूदी भाई परमेसवर तै दूर सै? मेरा मन उन खात्तर भोत दुखी सै, जै उन माणसां के छुटकारै खात्तर मेरे उप्पर चाहे दोष भी लगाये जावै या मसीह तै अलग करया जावै, तोभी मै इसकै खात्तर तैयार सूं, अर मै मसीह नै गवाह मानते होए सच बोल्लू सूं, पवित्र आत्मा अर मेरी अन्तरात्मा भी या गवाही देवै सै के मै झूठ कोनी बोल्दा। ");
INSERT INTO bgc_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","वे इस्राएल देश के माणस सै, अर वे परमेसवर के गोद लिये होड़ माणस सै, अर महिमा, करार, नियम-कायदे अर परमेसवर की आराधना करण का हक अर वादे उन्हे के सै। ");
INSERT INTO bgc_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","अब्राहम, इसहाक, याकूब ये सारे पूर्वज भी उन्हे के सै, अर मसीह भी देह कै भाव तै उन्हे म्ह तै इस्राएली सै। जो सारया कै उप्पर परम परमेसवर सै, युगानयुग धन्य हो। आमीन। ");
INSERT INTO bgc_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","पर इसा कोनी के परमेसवर अपणे वादे तै मुकर गया, ज्यांतै के जो इस्राएल के वंशज सै, वे सारे सच्चे इस्राएली कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","अर ना अब्राहम का वंश होण कै कारण सारे उसकी सच्ची ऊलाद होगी, पर पवित्र ग्रन्थ म्ह लिख्या सै, “इसहाक के वंश म्ह जन्म लेण तै ए सारे उसकी सच्ची ऊलाद न्ही हो जान्दी।” ");
INSERT INTO bgc_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","यानिके जो दुनियावी तौर पै शारीरिक रूप तै जन्मे होए परमेसवर की ऊलाद कोनी, पर वायदे की ऊलाद सै। ");
INSERT INTO bgc_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","क्यूँके वादे का वचन यो सै: “आगले साल मै इस्से बखत दुबारा आऊँगा, अर तब सारा कै एक बेट्टा पैदा होवैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","अर सिर्फ योए न्ही, पर जिब रिबका कै गर्भ म्ह एक ए आदमी यानिके म्हारै पूर्वज इसहाक तै जुड़वां बाळक पैदा होए। ");
INSERT INTO bgc_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","इब तै पैहले के वो पैदा होते अर कुछ बुरा या भला काम जाणते, परमेसवर नै रिबका तै कह दिया था के “जेट्ठा बेट्टा छोटळै का गुलाम होवैगा,” परमेसवर नै यो दिक्खाण कै खात्तर कह्या था, वो अपणे मन की इच्छा तै खुद चुनाव करै सै, ना के उनके भले या बुरे काम्मां तै। ");
INSERT INTO bgc_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","जिसा पवित्र ग्रन्थ म्ह लिख्या सै, “मन्नै एसाव तै बढ़कै याकूब ताहीं घणा प्यार करया।” ");
INSERT INTO bgc_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ज्यांतै हम के कह्वां? के परमेसवर की अपणी इच्छा तै चुनाव करणा अन्याय सै? न्ही! बिलकुल न्ही! ");
INSERT INTO bgc_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","क्यूँके परमेसवर मूसा नबी तै कहवै सै, “मै जिस किसे पै दया करणा चाहूँ, उसपै दया करुँगा, अर जिस किसे पै तरस खाणा चाहूँ उस्से पै तरस खाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","इस करकै परमेसवर उस ताहीं चुणै सै, जिसकै उप्पर वो दया दिखाणा चाहवै सै, उसका चुनाव इस बात पै आधारित कोनी, के लोग के चाहवै सै, अर वे के करण की कोशिश करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","क्यूँके पवित्र ग्रन्थ म्ह परमेसवर नै फिरौन (मिस्र के राजा) तै कह्या, “मन्नै तेरे ताहीं ज्या ए तै राजा बणाया सै, के तेरे म्ह अपणी सामर्थ दिखाऊँ, अर मेरै नाम का प्रचार सारी धरती पै होवै।” ");
INSERT INTO bgc_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","इस करकै वो जिसपै चाहवै सै उसपै दया करै सै, अर जिस ताहीं चाहवै सै उस ताहीं हठील्ला बणा देवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","तब घणखरे माणस मेरै तै कहवैगें, “जै इसा सै, तो परमेसवर किस तरियां कह सकै सै, के हम गलत सां? क्यूँके परमेसवर जो करणा चाहवै सै उसनै करण तै कौण रोक सकै सै?” ");
INSERT INTO bgc_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","हे भले माणस, भला तू कौण सै जो परमेसवर तै वाद-विवाद करै? के बणाई होई चीज बणाण आळे तै कह सकै सै, “तन्नै मेरै ताहीं इसा क्यांतै बणाया सै?” ");
INSERT INTO bgc_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","के कुम्हार ताहीं माट्टी पै हक कोनी के एक ए लोंदे म्ह तै एक बासण आदर कै खात्तर, अर दुसरे ताहीं अनाद्दर कै खात्तर बणावै? ");
INSERT INTO bgc_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","23","परमेसवर अपणा छो अर अपणी सामर्थ उनकै बिरुध्द दिखाणा चाहवै सै, जो नाश ए होण लायक सै, पर वो धीरज धरे सै क्यूँके वो दिखाणा चाहवै सै के वो कितना महान् सै, वो उन माणसां पै दया करै सै, जिन ताहीं उसनै अपणी महिमा म्ह साँझा करण खात्तर चुण्या सै। ");
INSERT INTO bgc_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","यानिके म्हारै पै जिन ताहीं उसनै ना सिर्फ यहूदी माणसां म्ह तै, बल्के गैर यहूदियाँ म्ह तै भी चुण्या। ");
INSERT INTO bgc_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जिसा के वो होशे नबी की किताब म्ह भी गैर यहूदियाँ के बारें म्ह कहवै सै, “जो मेरी प्रजा कोनी थी, उन ताहीं मै अपणी प्रजा कहूँगा, अर जिनतै मै प्यार न्ही करुँ था, उन ताहीं प्यार करुँगा। ");
INSERT INTO bgc_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","अर जिस जगहां पै परमेसवर नै इसा कह्या था, के थम मेरी प्रजा कोनी सो, उस्से जगहां पै परमेसवर उन ताहीं अपणी ऊलाद कहवैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","अर यशायाह नबी इस्राएल के माणसां कै बारै म्ह रुक्का मारकै कहवै सै, “चाहे इस्राएल की ऊलादां की गिणती समुन्दर के बालू कै बराबर हो, तोभी उन म्ह तै थोड़े ए बचैंगें। ");
INSERT INTO bgc_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","क्यूँके परमेसवर धरती पै तावळा-ए आवैगा, अर एक बार म्ह ए सबका न्याय करैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जिसा यशायाह नबी नै पैहल्या भी कह्या था, “जै सेनाओं का प्रभु म्हारै खात्तर कुछ वंश न्ही छोड़दा, तो म्हारी हाल्लत सदोम अर अमोरा नगर के जिसी हो जान्दी, जिस ताहीं परमेसवर नै पूरी तरियां तै नाश कर दिया।” ");
INSERT INTO bgc_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ज्यांतै हम के कह्वां? गैर यहूदियाँ नै अपणे-आप ताहीं धर्मी बणाण की कोशिश न्ही करी, पर परमेसवर नै मसीह यीशु पै बिश्वास करण कै कारण उन ताहीं धर्मी बणा दिया। ");
INSERT INTO bgc_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","जो इस्राएली मूसा नबी के नियम-कायदा नै मानकै धर्मी बणणा चाहवै थे वे धर्मी न्ही बण पाये। ");
INSERT INTO bgc_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","यो किस तरियां हो सकै सै? इस करकै के वे बिश्वास तै न्ही, पर मान्नो आच्छे काम्मां तै धर्मी बणणा चाहवै थे। उननै उस ठोक्कर कै पत्थर पै ठोक्कर खाई, ");
INSERT INTO bgc_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","जिसा पवित्र ग्रन्थ यीशु मसीह के बारें कहवै सै, “देक्खो, मै यरुशलेम नगर म्ह एक ठेस लाग्गण का पत्थर, अर ठोक्कर खाण की चट्टान राक्खूँ सूं, अर जो कोए उसपै बिश्वास करैगा वो शर्मिन्दा कोनी होवैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","हे बिश्वासी भाईयो, मेरै मन की इच्छा अर मेरे यहूदी माणसां खात्तर, परमेसवर तै मेरी याए प्रार्थना सै के वे बचाए जावै। ");
INSERT INTO bgc_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","क्यूँके मै उनकी गवाही द्यूँ सूं, के उन ताहीं परमेसवर कै खात्तर उत्साह रहवै सै, पर सही समझकै गेल्या न्ही। ");
INSERT INTO bgc_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","क्यूँके वा धार्मिकता जो परमेसवर की ओड़ तै आवै सै, उस ताहीं वे समझण म्ह नाकामयाब रहे अर अपणे तरिक्कें तै धर्मी बणण की कोशिश करी, वे परमेसवर की धार्मिकता के अधीन न्ही होए। ");
INSERT INTO bgc_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","क्यूँके मसीह नै पैहले तै ए उस मकसद ताहीं पूरा कर लिया सै। जिस खात्तर नियम-कायदे दिए गये थे, उसका नतिज्जां यो होया के जो यीशु मसीह पै बिश्वास करै सै वो धर्मी बणाए जावैंगे। ");
INSERT INTO bgc_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","क्यूँके मूसा नबी नै नियम-कायदा तै धर्मी बणण के बारें म्ह पवित्र ग्रन्थ म्ह यो लिख्या सै, के जो माणस उननै मान्नै सै, वो इस्से कारण तै जिन्दा रह्वैगा। ");
INSERT INTO bgc_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","पर बिश्वास के जरिये धर्मी बणाये जाण के बारें म्ह पवित्र ग्रन्थ या कहवै सै, के “तू अपणे मन म्ह न्यू ना कहिये, के मसीह ताहीं नीच्चै ल्याण खात्तर सुर्ग पै कौण चढ़ैगा?” ");
INSERT INTO bgc_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","या “अधोलोक म्ह कौण उतरैगा?” (यानिके मसीह ताहीं मरे होया म्ह तै जिन्दा उप्पर लाण कै खात्तर!) ");
INSERT INTO bgc_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","पर के कहवै सै, योए के “परमेसवर का वचन तेरे धोरै सै, ताके तू उसनै अपणे मुँह तै अंगीकार कर सकै अर अपणे मन म्ह राक्ख सकै,” यो वोए बिश्वास का वचन सै, जो हम प्रचार करा सां। ");
INSERT INTO bgc_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","जै तू माणसां के स्याम्ही यीशु नै प्रभु मान ले, अर अपणे मन तै बिश्वास करै के परमेसवर नै उस ताहीं मरे होया म्ह तै जिन्दा करया, तो परमेसवर तन्नै बचावैगा। ");
INSERT INTO bgc_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","क्यूँके हम अपणे मन तै बिश्वास करां सां, तो हम परमेसवर के जरिये धर्मी बणाए जावै सै, अर हम मुँह तै अंगीकार करां सां, के हम मसीह पै बिश्वास करां सां, तो इस करकै हम बच जावांगे। ");
INSERT INTO bgc_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","क्यूँके यशायाह नै पवित्र ग्रन्थ म्ह मसीह के बारें म्ह यो लिख्या सै, “जो कोए उसपै बिश्वास करैगा वो शर्मिन्दा कोनी होवैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","यहूदियाँ अर यूनानियाँ म्ह किमे फर्क कोनी, ज्यांतै के परमेसवर सारया का प्रभु सै, जो उसका नाम लेवै सै उस ताहीं वो बचावै सै। ");
INSERT INTO bgc_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","क्यूँके पवित्र ग्रन्थ म्ह लिख्या सै के “जो कोए प्रभु का नाम लेवैगा, वो बचाया जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","पर जिन माणसां नै मसीह पै बिश्वास न्ही करया, तो वे उसनै मदद खात्तर किस तरियां पुकारैंगे? अर जिसकै बारें म्ह सुण्या न्ही उसपै किस तरियां बिश्वास करैंगें? अर वे किस तरियां सुणैगें जिब तक कोए प्रचारक ना जावै। ");
INSERT INTO bgc_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","जै प्रचारक भेज्जे ना जावै, तो किस तरियां प्रचार करै? जिसा पवित्र ग्रन्थ म्ह लिख्या सै, “जो आच्छी बात्तां का सुसमाचार लेकै आवै सै, उनके पाँव कितने सुहावने सै।” ");
INSERT INTO bgc_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","पर सारया नै उस सुसमाचार पै बिश्वास कोनी करया जिसा यशायाह नबी कहवै सै, “हे प्रभु, किस्से नै भी म्हारै सन्देस पै बिश्वास न्ही करया?” ");
INSERT INTO bgc_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","पर मसीह के बारें म्ह वचन सुणण तै बिश्वास होवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","पर मै पूच्छु सूं, के यहूदियाँ नै, मसीह के बारें म्ह न्ही सुण्या? सुण्या तो जरुर सै, क्यूँके पवित्र ग्रन्थ म्ह लिख्या सै, “उनके बोल साब्ती धरती पै, अर उनके वचन दुनिया के कुणे ताहीं पोंहोचगे सै।” ");
INSERT INTO bgc_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","फेर मै पूच्छु सूं, के इस्राएली लोग मसीह के बारें म्ह सन्देस ताहीं समझै सै? पैहल्या तो प्रभु नै मूसा नबी के जरिये यो कह्या, “मै उन गैर यहूदियाँ के जरिये थारे मन म्ह जळण पैदा करुँगा, मै थमनै यहूदियाँ कै जरिये मूर्ख समझण आळे माणसां तै गुस्सा दिलाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","फेर जो बात प्रभु नै कही वा बात यशायाह नबी बड़ी हिम्मत करकै कहवै सै, “जो मन्नै न्ही टोहवैं थे, उननै मेरै ताहीं पा लिया, अर जो मन्नै बुझ्झै भी कोनी थे, उनपै मै जाहिर होया।” ");
INSERT INTO bgc_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","पर इस्राएल देश के माणसां कै बारै म्ह, परमेसवर यशायाह नबी के जरिये न्यू भी कहवै सै, “मै सारा दिन अपणे हाथ, एक हुकम ना मानण आळी अर विवाद करण आळी प्रजा कै कान्ही पसारे रहया।” ");
INSERT INTO bgc_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ज्यांतै मै पूच्छु सूं, के परमेसवर नै अपणी प्रजा ताहीं छोड़ दिया? न्ही! बिलकुल न्ही! मै भी तो इस्राएली सूं, मै अब्राहम की पीढ़ी अर बिन्‍यामीन कै गोत्र म्ह तै सूं। ");
INSERT INTO bgc_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेसवर नै अपणी उस प्रजा ताहीं कोनी छोड्या, जिस ताहीं उसनै पैहल्याए तै चुण्या सै। के थमनै न्ही बेरा के पवित्र ग्रन्थ एलिय्याह नबी कै बारै म्ह के कहवै सै, वो इस्राएल के माणसां कै बिरोध म्ह परमेसवर तै शिकायत करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“हे प्रभु, उननै तेरे नबियाँ ताहीं मार दिया, अर तेरी वेदियाँ ताहीं नाश कर दिया सै, अर मै ए एक्ला बचा सूं, जो तेरे पै बिश्वास करुँ सूं अर जिन्दा सूं, अर वे मेरी जान भी लेणा चाहवै सै।” ");
INSERT INTO bgc_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","तब परमेसवर नै एलिय्याह नबी तै कह्या, “मन्नै अपणे खात्तर सात हजार माणसां ताहीं राख राख्या सै, जिन नै बाल देवता की मूर्ति की आराधना करण खात्तर गोड्डे कोनी टेक्के सै।” ");
INSERT INTO bgc_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ठीक इस्से तरियां तै इस बखत भी, परमेसवर के अनुग्रह तै अलग करे होए कुछ यहूदी माणस बचरे सै, जिन ताहीं उसनै अपणे खात्तर चुण्या सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","जै उन ताहीं परमेसवर नै अपणे अनुग्रह तै चुण्या सै, तो यो आच्छे काम्मां तै न्ही होया, न्ही तो अनुग्रह फेर अनुग्रह न्ही रहया। ");
INSERT INTO bgc_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","फेर इसका नतिज्जा के लिकड़या? हालाकि इस्राएली माणस जो परमेसवर की नजर म्ह धर्मी बणणा चाहवै थे, पर वो बण न्ही पाए, पर परमेसवर नै जिन ताहीं चुण्या वे उसकै गैल धर्मी बण ग्ये, अर बचे होड़ माणस हठीले करे गये अर उननै उसकी सुणण तै इन्कार कर दिया। ");
INSERT INTO bgc_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जिसा पवित्र ग्रन्थ म्ह यशायाह नबी नै लिख्या सै, “परमेसवर नै उन ताहीं आज कै दिन तक सुस्त दिमाग दे राख्या सै, अर इसी आँख दी जो ना देक्खै, अर इसे कान दिये जो ना सुणै।” ");
INSERT INTO bgc_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","अर राजा दाऊद कहवै सै, “के जिसा एक पंछी खाणा खाण खात्तर जाळ म्ह फँस जावै सै अर जानवर खड्डे म्ह गिर जावै सै, उसी तरियां ये माणस भी परमेसवर की ओड़ तै दण्ड पावैंगें। ");
INSERT INTO bgc_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","उनकी आँख आँधी हो जावै ताके वो देख न्ही पावै, अर वे सारी हाण मुसीबतां म्ह फसे रहवै।” ");
INSERT INTO bgc_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","तो मै पूच्छु सूं, के यहूदी लोग ठोक्कर खाण कै कारण सदा कै खात्तर नाश होगे? न्ही! बिलकुल न्ही! पर उनकै अबिश्वास कै कारण गैर यहूदियाँ ताहीं उद्धार मिल्या, ताके इस्राएल के माणसां कै जळण होवै। ");
INSERT INTO bgc_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ज्यांतै जै उनका अबिश्वास दुनिया की गैर यहूदियाँ कै खात्तर भलाई का कारण बणै, तो इस्राएल के माणसां का परमेसवर के धोरै बोहड़ के आणा और भी आच्छा क्यूँ न्ही होगा। ");
INSERT INTO bgc_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","मै थम दुसरी जात्तां तै ये बात कहूँ सूं। जिब के मै गैर यहूदियाँ कै खात्तर प्रेरित सूं, तो मै अपणी सेवा की बड़ाई करुँ सूं, ");
INSERT INTO bgc_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ताके किसे तरियां तै मै अपणे कुण्बे आळे माणसां म्ह जळण पैदा करवा कै उन म्ह तै एक-आधै का उद्धार कराऊँ। ");
INSERT INTO bgc_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","क्यूँके जिब इस्राएली माणसां का छोड़ दिया जाणा, गैर यहूदियाँ का परमेसवर कै साथ मेळ-मिलाप का कारण होया। तो उनका मसीह ताहीं अपणाया जाणा, इसा होगा, जिसा किसे माणस का मुर्दां म्ह तै जिन्दा जाणा। ");
INSERT INTO bgc_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","मै थमनै एक उदाहरण देऊँ सूं, यो यहूदी माणसां का रिवाज सै, जिब हम चून गुंधा सां, तो उस म्ह तै पैहले रोट्टी का एक पेड़ा परमेसवर कै खात्तर लिकाड़ा सां, तो पूरा गुन्द्या होया चून भी परमेसवर कै खात्तर सै, उस्से तरियां जिस तरियां जड़ परमेसवर की सै, तो डाळी भी उस्से की सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","इस्राएल के माणस जैतून की डाळी की तरियां सै अर पिता अब्राहम, इसहाक अर याकूब पेड़ की जड़ की तरियां सै, पर जै कुछ डाळी तोड़ दी गई, अर तू जंगळी जैतून होकै उन म्ह कलम करया गया, अर यहूदी माणसां ताहीं मिलण आळी आशीष का फायदा थारे ताहीं भी होया, जिसा जैतून के पेड़ की डाळी पेड़ की जड़ तै रस हासिल करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","तो थम यो घमण्ड ना करियो, के थम उन कटी होई डाळियाँ तै बढ़िया सों, यो याद राक्खों के थम जड़ नै कोनी पर, जड़ थमनै सम्भाळै सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","फेर थम बोल सकों सों के “परमेसवर पेड़ तै टुट्टी होए डाळियाँ की तरियां थमनै छोड़ देगा।” ताके गैर यहूदियाँ ताहीं अपणाले, जो के उन डाळियाँ की तरियां सै जो कलम करकै लगाई गई सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","यो सच सै के वे तो अबिश्वास कै कारण तोड़ी गई, पर तू बिश्वास तै बण्या रहवै सै ज्यांतै घमण्डी ना होवै, पर भय मान, ");
INSERT INTO bgc_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","क्यूँके जिब परमेसवर नै खुद की डाळियाँ पै दया न्ही करी तो वो थारे पै भी दया न्ही करैगा। ");
INSERT INTO bgc_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ज्यांतै परमेसवर की दया अर कठोरता नै देख! जो अबिश्वासी माणसां खात्तर कठोरता अर थारे खात्तर दया सै, जै थम असलियत म्ह उसकी दया की हद म्ह न्ही बणे रहवोंगे, तो थारे ताहीं भी काट के अलग कर दिया जावैगा। ");
INSERT INTO bgc_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","यहूदी लोग भी जै बिश्वास करणा शरु करदे, तो दुबारा तै लगा दिए जावैंगे, क्यूँके परमेसवर उन ताहीं फेर छांग सकै सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","एक जंगळी डाळी खात्तर एक आच्छे पेड़ का हिस्सा बणणा कुदरती न्ही सै, अर जो यहूदी कोनी जंगळी जैतून के पेड़ की डाळी की तरियां सै, जो के एक आच्छे जैतून के पेड़ म्ह लगाई गई सै, पर यहूदी एक डाळी की तरियां सै जो आच्छे पेड़ तै उगै सै, पक्के तौर पै वे अपणे पेड़ म्ह शामिल हो सकै सै। ");
INSERT INTO bgc_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","हे बिश्वासी भाईयो, मै न्ही चाहन्दा के थम इस भेद तै अनजाण रहों, इसा ना हो के थम अपणे-आप पै घमण्ड करण लाग्गों, जिब तक गैर यहूदी परमेसवर के धोरै ना आवै सै, तब तक इस्राएल के कुछ माणस सख्त बणे रहवैंगे। ");
INSERT INTO bgc_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","अर इसके बाद सारे इस्राएल के माणस उद्धार पावैंगें। जिसा पवित्र ग्रन्थ म्ह लिख्या सै, “छुटाण आळा यरुशलेम तै आवैगा, अर अभगति नै याकूब के वंश तै दूर करैगा। ");
INSERT INTO bgc_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","अर उनकै गेल्या मेरा यो करार होगा, जिब मै उनके पापां नै माफ कर दियुँगा।” ");
INSERT INTO bgc_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","यहूदी लोग परमेसवर के दुश्मन बणगे थे, क्यूँके वे उस सुसमाचार पै बिश्वास करणा न्ही चाहन्दे, यो थारे खात्तर फायदेमन्द होया, पर परमेसवर उनतै प्यार करै सै, क्यूँके उसनै अपणे खात्तर उन ताहीं चुण्या सै, योए वो वादा सै जो उसनै म्हारे पूर्वजां तै करया था। ");
INSERT INTO bgc_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","क्यूँके परमेसवर अपणे वरदान्नां तै, अर बुलाहट तै कदे भी पाच्छै कोनी हटदा। ");
INSERT INTO bgc_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","एक बखत था जिब थम गैर यहूदियाँ नै परमेसवर ताहीं ठुकरा दिया था, पर इब इस्राएल के माणसां नै परमेसवर ताहीं ठुकरा दिया, इस कारण थारे पै दया दिखाई गई। ");
INSERT INTO bgc_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","थारे पै दया दिखाण कै कारण उनपै भी दया दिखाई जावैगी। ");
INSERT INTO bgc_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","क्यूँके सारे माणसां नै परमेसवर के हुकम का उलंघण करया सै, योए कारण सै के परमेसवर उनकै गैल कैदियाँ की ढाळ बरताव करै सै, वो इस करकै इसा करै सै के सब माणसां पै दया हो सकै। ");
INSERT INTO bgc_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ओह! किसा अपार सै परमेसवर की बुद्धि अर ज्ञान का भण्डार! कितने महान् सै उसके फैसले! अर किसा रहस्यमयी सै उसके काम करण का तरिक्कां! ");
INSERT INTO bgc_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“भला कौण जाण सकै सै परमेसवर के मन नै? या कौण उसका सलाहकार होया सै? ");
INSERT INTO bgc_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","या किसनै परमेसवर ताहीं कुछ दिया सै, जिसका बदला उस ताहीं दिया जावै?” इसा कोए कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","क्यूँके सब कुछ उस्से कै कान्ही तै आवै सै, अर उस्से नै सब कुछ बणाया सै अर सब कुछ उस्से का सै। उसकी महिमा युगानुयुग होन्दी रहवै आमीन। ");
INSERT INTO bgc_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ज्यांतै हे बिश्वासी भाईयो, मै थारे तै परमेसवर की दया याद दुवाकै बिनती करुँ सूं, के अपणी जिन्दगी ताहीं जिन्दा, पवित्र अर परमेसवर ताहीं भान्दा होया बलिदान करकै चढ़ाओ। योए परमेसवर की सेवा करण का सही तरिक्कां सै। ");
INSERT INTO bgc_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","इस दुनिया के माणसां बरगे ना बणो, पर परमेसवर थारी सोच नै बदलै, अर थारा चाल-चलण भी बदलता जावै, जिसतै थम परमेसवर की भली, अर आच्छी लागण आळी, अर सिध्द इच्छा अनुभव तै बेरा पाड़ सको। ");
INSERT INTO bgc_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","क्यूँके मै उस अनुग्रह कै कारण जो मेरै ताहीं मिल्या सै, थारे म्ह तै हरेक तै कहूँ सूं, के जिसा समझणा चाहिये, उसतै बढ़कै कोए भी अपणे-आपनै ना समझै। पर इसकी बजाए सदबुध्दी राखकै, जिसा परमेसवर नै जितना बिश्वास थारे ताहीं दिया सै उसकै मुताबिक अपणे-आपनै समझो। ");
INSERT INTO bgc_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","क्यूँके जिसा म्हारी एक देह म्ह घण-ए अंग सै, अर सारे अंगा का एके काम कोनी। ");
INSERT INTO bgc_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","इस्से तरियां हम जो मसीह म्ह बिश्वास करा सां, हम उसके देह के कुछ अंग बणगे सां, अर हम दुसरे तै जुड़े होए सां। ");
INSERT INTO bgc_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","जिब के उस अनुग्रह कै मुताबिक जो परमेसवर नै म्हारै ताहीं दिया सै, हमनै न्यारे-न्यारे वरदान मिले सै। तो जिस ताहीं परमेसवर नै भविष्यवाणी का दान दिया सै, वो उन ए बात्तां नै बोल्लै जो उसनै बिश्वास दिलाते हो के ये परमेसवर की ओड़ तै सै। ");
INSERT INTO bgc_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","जै दुसरयां की सेवा करण का दान मिल्या हो, तो सेवा म्ह लाग्या रहवै, जै कोए सिखाण आळा हो, तो सिखाण म्ह लाग्या रहवै। ");
INSERT INTO bgc_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","जो उत्साहित करण आळा हो, वो उत्साहित करण म्ह लाग्या रहवै, दान देण आळा हो उदारता तै देवै, जो अगुवाई करै, वो जोश तै करै, जो दया करै, वो खुशी तै करै। ");
INSERT INTO bgc_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","प्यार करण का दिखावा ना करो, बुराई तै नफरत करो, भलाई म्ह उत्सुक रहो। ");
INSERT INTO bgc_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","एक-दुसरे तै इस तरियां प्यार करो, जणु एक ए परिवार के हो, आप्पस म्ह एक-दुसरे का बढ़-चढ़कै आदर करो। ");
INSERT INTO bgc_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","कड़ी मेहनत करो अर आलसी ना बणो, आत्मिक जोश तै भरे रहो। प्रभु की सेवा पूरे मन तै करदे रहो। ");
INSERT INTO bgc_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","आस म्ह खुश रहो, क्ळेश म्ह धीरज धरो, प्रार्थना म्ह सारी हाण लाग्गे रहो। ");
INSERT INTO bgc_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","पवित्र माणसां ताहीं जो किमे जरूरी हो, उस म्ह उनकी मदद करो, अर अजनबी माणसां की सदा सेवा-पाणी म्ह लाग्गे रहो। ");
INSERT INTO bgc_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","अपणे सताण आळा ताहीं आशीष द्यो, आशीष दो श्राप ना द्यो। ");
INSERT INTO bgc_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","आनन्द करण आळा कै गेल्या आनन्द करो, अर रोण आळा कै गेल्या रोओ। ");
INSERT INTO bgc_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","जिस तरियां थम अपणी परवाह करो सों, उस्से तरियां दुसरयां की परवाह करो, खुद पै घमण्ड ना करो, पर दीन-दुखियाँ कै गेल्या संगति राक्खो, अपणी नजर म्ह अकलमंद ना होवो। ");
INSERT INTO bgc_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","बुराई कै बदले किसे तै बुराई ना करो, जो बात सारे माणसां कै लोवै आच्छी सै, उनकी फिक्र करया करो। ");
INSERT INTO bgc_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जित्त ताहीं हो सकै, थम पूरे मन तै सारे माणसां कै गेल्या मेळ-मिलाप राक्खो। ");
INSERT INTO bgc_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","हे प्यारे बिश्वासी भाईयो, बदला ना लियो, पर परमेसवर ताहीं बदला लेण का मौक्का द्यो, क्यूँके पवित्र ग्रन्थ म्ह लिख्या सै, “बदला लेणा मेरा काम सै, प्रभु कहवै सै मै ए बदला ल्यूँगा।” ");
INSERT INTO bgc_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","पर वचन यो भी कहवै “जै तेरा बैरी भूक्खा हो तो उस ताहीं खाणा खुवा, जै तिसाया हो तो उस ताहीं पाणी पिला, क्यूँके तेरे इसा करण तै वो खुद शर्मिन्दा हो जावैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","बुराई तै ना जीत हासिल करो, पर भलाई तै बुराई नै जीत ल्यो। ");
INSERT INTO bgc_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","हरेक माणस शासन करण आळे अधिकारियां कै अधीन रहवै, क्यूँके सारे अधिकार परमेसवर की ओड़ तै आवै सै, अर जो अधिकार सै, वे परमेसवर नै बणाये सै। ");
INSERT INTO bgc_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ज्यांतै जो कोए भी माणस उन माणसां का पालन करण तै इन्कार करै सै, जिनके धोरै शासन करण की शक्ति सै, तो वो परमेसवर की विधि का बिरोध करै सै, अर बिरोध करण आळे दण्ड पावैंगें। ");
INSERT INTO bgc_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","क्यूँके हाकिम आच्छे काम के न्ही, पर भुन्डे़ काम कै खात्तर डर का कारण सै। जै तू हाकिम तै बिना डरे रहणा चाहवै सै, तो आच्छा काम कर, ताके उसकी ओड़ तै तेरी बड़ाई हो। ");
INSERT INTO bgc_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","क्यूँके वो तेरी भलाई कै खात्तर परमेसवर का सेवक सै। परन्तु जै तू बुराई करै, तो डर, क्यूँके उसनै दण्ड देण का हक सै, अर वो परमेसवर का सेवक सै ताके उसकै छो कै मुताबिक भुन्डे़ काम करण आळे ताहीं सजा देवै। ");
INSERT INTO bgc_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ज्यांतै थम उनके अधीन रहों ना सिर्फ उसकै दण्ड तै बचण खात्तर बल्के साफ अन्तरात्मा राक्खण खात्तर भी। ");
INSERT INTO bgc_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ज्यांतै चुंगी भी द्यो क्यूँके शासन करण आळे परमेसवर के सेवक सै अर सारी हाण उस फर्ज नै पूरा करण म्ह लाग्गे रहवैं सै। ");
INSERT INTO bgc_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ज्यांतै हरेक का हक चुकाया करो, जिस ताहीं चुंगी देणी चाहिये, उस ताहीं चुंगी देओ, कर देण आळे ताहीं कर देओ, जिसतै डरणा चाहिये, उसतै डरो, जिसका आदर-मान करणा चाहिये, उसका आदर-मान करो। ");
INSERT INTO bgc_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","एक ए चीज सै जिसके थमनै कर्जदार होणा चाहिए, वो सै थारा आप्पस म्ह प्यार, क्यूँके जो एक-दुसरे तै प्यार करै सै, उस्से नै परमेसवर के नियम-कायदा ताहीं पूरा करया सै। ");
INSERT INTO bgc_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","क्यूँके, मूसा नबी के नियम-कायदा म्ह भोत-से हुकम सै, “जारी ना करणा, खून ना करणा, चोरी ना करणा, लालच ना करणा,” अर इन्नै छोड़ और कोए भी हुकम हो, तो सारया का निचोड़ इस एक हुकम म्ह पाया जावै सै, “अपणे पड़ोसी तै अपणे जिसा प्यार करो।” ");
INSERT INTO bgc_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","प्यार पड़ोसी की कुछ बुराई कोनी करदा, जो प्यार करै सै, वो परमेसवर के नियम-कायदा नै पूरा करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","आप्पस म्ह हरेक नै एक-दुसरे तै प्यार करते रहणा चाहिए, क्यूँके वो बखत आवै सै, के जिब परमेसवर हमनै इस बुरी दुनिया तै छुड़ावैगा, जिब हमनै पैहली बार मसीह म्ह बिश्वास करया था, तब तै इब वो बखत धोरै आ लिया सै, तो थारे ताहीं नींद तै जागणा चाहिए अर सावधान रहणा चाहिए। ");
INSERT INTO bgc_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","दुनिया म्ह रहण का म्हारा बखत लगभग एक रात की ढाळ सै, जो खतम होण आळी सै, अर मसीह के बोहड़ण आळा बखत भोत लवै सै, ज्यांतै हमनै अन्धकार के काम्मां नै छोड़कै, चाँदणे की ढाळ आच्छे काम करणे चाहिए, जो बुराई का बिरोध करण म्ह म्हारे हथियार बणै सकै। ");
INSERT INTO bgc_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","आओ! हम खुद नै सही तरिक्के तै चलाणा शरु करा, जो उन माणसां की तरियां सै जो चाँदणे म्ह रहवै सै, पर अँधेरे म्ह रहण आळे माणसां की ढाळ ना बणो जो भोग-विलास, दारूबाजी, जारी, लुचपण, रोळे अर जळण करण जिसा काम करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","बल्के प्रभु यीशु मसीह ताहीं कवच बणा के पैहर ल्यो, अर देह की पापी अभिलाषायां नै पूरा करण का उपाय ना करो। ");
INSERT INTO bgc_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","जो माणस बिश्वास म्ह कमजोर सै, उस ताहीं अपणी संगति म्ह ले ल्यो, पर उस ताहीं के करणा चाहिए के न्ही करणा चाहिए इस बारें म्ह बहस ना करो। ");
INSERT INTO bgc_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","एक नै बिश्वास सै, के सारा कुछ खाणा सही सै, पर जो बिश्वास म्ह कमजोर सै वो साग-पात ए खावै सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","अर माँस-मच्छी खाण आळे साग-पात खाण आळे ताहीं तुच्छ ना जाणै, अर ना साग-पात खाणआळा, माँस-मच्छी खाणआळै पै दोष लावै, क्यूँके परमेसवर नै दोंनुआ ताहीं अपणाया सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","तू कौण सै जो दुसरे कै नौक्कर पै दोष लावै सै? पर उसकी कामयाबी या नाकामयाबी उसकै माल्लिक कै ए हाथ्थां म्ह सै, बल्के वो कामयाब ए कर दिया जावैगा, क्यूँके प्रभु उस ताहीं कामयाब कर सकै सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","इस तरियां कई माणस तो एक दिन नै दुसरे तै बाध मान्नै सै, अर कई माणस सारे दिनां नै एक जिसा जाणै सै, इस तरियां तै हरेक अपणे ए मन म्ह, इस बात नै पक्का कर लेवै जो वो सोच्चै सै वोए सही सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","जो कोए किसे दिन नै बाध मान्नै सै, वो प्रभु नै आदर मान देण खात्तर मान्नै सै। जो कोए माँस-मच्छी खावै सै, वो प्रभु नै आदर मान देण खात्तर खावै सै, क्यूँके वो परमेसवर का धन्यवाद करै सै, अर जो साग-पात खावै सै, क्यूँके वो प्रभु नै आदर मान देण खात्तर खावै अर परमेसवर का धन्यवाद करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","क्यूँके हम सारे प्रभु के सां। म्हारै म्ह तै ना तो कोए अपणे खात्तर जिन्दा सै, अर ना कोए अपणे खात्तर मरै सै, पर परमेसवर ताहीं खुश करण खात्तर करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","जै हम जिवां सां, तो प्रभु कै खात्तर जिवां सां, अर जै मरा सां, तो प्रभु कै खात्तर ए मरा सां, हम जिवां या मरा, हम प्रभु ए के सां। ");
INSERT INTO bgc_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","क्यूँके मसीह यीशु इस्से खात्तर मरा अर मुर्दां म्ह तै जिन्दा भी हो गया के वो मरे होया अर जिन्दयां का, दोनुआं का प्रभु होवै। ");
INSERT INTO bgc_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","तू अपणे बिश्वासी भाई पै क्यांतै दोष लावै सै? या फेर क्यांतै अपणे बिश्वासी भाई नै तुच्छ जाणै सै? परमेसवर हम सारा का न्याय करैगा। ");
INSERT INTO bgc_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","क्यूँके पवित्र ग्रन्थ म्ह लिख्या सै, “प्रभु कहवै सै, मेरे जीवन की कसम, के हरेक घुटना मेरै स्याम्ही टिकैगा, अर हरेक कोए अपणी जुबान तै मन्नै परमेसवर मान लेवैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ज्यांतै म्हारै म्ह तै हरेक नै अपणे-अपणे काम का लेक्खा परमेसवर ताहीं देणा पड़ैगा। ");
INSERT INTO bgc_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","इस खात्तर आग्गै तै हम एक-दुसरे पै दोष न्ही लावांगें, पर थम या ठान ल्यो के कोए अपणे बिश्वासी भाई कै स्याम्ही पाप करण की बजह ना बणै। ");
INSERT INTO bgc_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","मन्नै बेरा सै अर प्रभु यीशु म्ह मन्नै पक्का यकिन होया सै, के कोए खाण-पीण की चीज अपणे-आप तै अशुद्ध कोनी, पर जो उस ताहीं अशुद्ध समझै सै, उसकै खात्तर अशुद्ध सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","जै तेरा बिश्वासी भाई तेरे खाणे कै कारण दुखी होवै सै, तो फेर तू मसीह की प्यार की रीत पै न्ही चाल्दा, जिसकै खात्तर मसीह मरा, तेरे खाणे की बजह तै तेरा बिश्वासी भाई मसीह तै पाच्छै ना हटै। ");
INSERT INTO bgc_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","इस करकै जै तू अपणी नजर म्ह बढ़िया काम करै सै, पर दुसरा उसनै बुरा मान्नै सै तो उसनै ना करै। ");
INSERT INTO bgc_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","क्यूँके परमेसवर का राज्य खाणा-पीणा कोनी, पर धार्मिकता अर मेळ-मिलाप म्ह ए खुशी सै, जो पवित्र आत्मा तै मिलै सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","जो कोए इस तरियां तै मसीह की सेवा करै सै, इसतै परमेसवर खुश होवै सै, अर माणसां म्ह भी उसकी तारीफ होवै सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ज्यांतै हम उन काम्मां म्ह लाग्गे रह्वां जिनतै मेळ-मिलाप अर शान्ति होवै, अर एक-दुसरे का बिश्वास मजबूत होवै। ");
INSERT INTO bgc_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","खाणे कै खात्तर परमेसवर का काम ना बिगाड़ै। सारी ढाळ का खाणा शुद्ध सै, पर उस माणस कै खात्तर पाप करण की बजह ना बणो, जिस ताहीं उसकै खाणे तै ठेस लाग्गै सै। ");
INSERT INTO bgc_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","भला तो यो सै के तू ना माँस-मच्छी खा अर ना अंगूर का रस पी, ना और किमे इसा करै जिसतै तेरे बिश्वासी भाई के बिश्वास नै ठेस लाग्गै। ");
INSERT INTO bgc_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","जै तू बिश्वास करै के तू सही करै सै, तो इन बात्तां नै अपणे ए अर परमेसवर के बीच म्ह राख। धन्य सै वो जो उस बात म्ह, जिस ताहीं वो सही समझै सै, अपणे-आपनै कसूरवार न्ही समझदे। ");
INSERT INTO bgc_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","पर इब थारे मन म्ह शक सै, के खाणा सै अर के न्ही खाणा अर फेर भी खा ल्यो सो, तो पाप करो सों। क्यूँके थम अपणे बिश्वास के मुताबिक न्ही करते अर जै थम इसा काम करो सों, जिसपै थमनै बिश्वास सै, वो काम गलत सै, तो वो पाप सै। ");
INSERT INTO bgc_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","हो सकै सै के हम जो बिश्वास म्ह मजबूत सां, हम जाणा सां के इन बात्तां तै कोए फर्क न्ही पड़ता, हम इस खात्तर यो काम न्ही करते के हम अपणे-आपनै खुश कर सका, हमनै उन माणसां का डर अर शंका का भी ध्यान करणा सै, के जो यो सोच्चै सै के हम गलत सां। ");
INSERT INTO bgc_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","म्हारै म्ह तै हरेक नै अपणे बिश्वासी भाई कै साथ भले काम करणे चाहिए, जो उसनै खुश करै अर उस ताहीं बिश्वास म्ह मजबूत बणाए राक्खै। ");
INSERT INTO bgc_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","क्यूँके मसीह नै अपणे-आप ताहीं खुश कोनी करया, पर जिसा पवित्र ग्रन्थ म्ह लिख्या सै, “तेरी बुराई करण आळा नै मेरी बुराई करी सै।” ");
INSERT INTO bgc_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","जितनी बात पैहल्या तै पवित्र ग्रन्थ म्ह लिक्खी गई, वे म्हारी ए सिखाण कै खात्तर लिक्खी गई सै, ताके हम धीरज अर उत्साह जो म्हारे ताहीं पवित्र ग्रन्थ देवै सै, उसके जरिये हमनै आस मिलै। ");
INSERT INTO bgc_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","मै प्रार्थना करुँ सूं के धीरज अर उत्साह का दात्ता परमेसवर, थमनै यीशु मसीह की तरियां जीवन बिताण अर एक-दुसरयां कै साथ शान्ति तै रहण म्ह मदद करै। ");
INSERT INTO bgc_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ताके थम सब कठ्ठे होकै म्हारै परमेसवर प्रभु यीशु मसीह कै पिता की महिमा करो। ");
INSERT INTO bgc_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","इस करकै एक-दुसरे नै अपणाओ जिसा मसीह नै थारे ताहीं अपणाया सै, यो इस खात्तर करो के माणस परमेसवर की जै-जै कार करै। ");
INSERT INTO bgc_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ज्यांतै मै कहूँ सूं के जो वादे म्हारे पूर्वजां ताहीं दिए गये थे, उन वादा नै मजबूत करण खात्तर मसीह, परमेसवर की सच्चाई साबित करण खात्तर मसीह, यहूदी माणसां का सेवक बण्या। ");
INSERT INTO bgc_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","अर गैर यहूदी भी परमेसवर की दया कै कारण उसकी महिमा करै, जिसा पवित्र ग्रन्थ म्ह लिख्या सै, “ज्यांतै मै गैर यहूदी माणसां म्ह तेरा धन्यवाद करुँगा, अर तेरे नाम के भजन गाऊँगा।” ");
INSERT INTO bgc_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","फेर कह्या सै, “हे गैर यहूदी माणसों, परमेसवर की प्रजा कै गैल आनन्द करो।” ");
INSERT INTO bgc_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","अर फेर पवित्र ग्रन्थ कहवै सै, “हे गैर यहूदी माणसों, प्रभु की जय-जयकार करो, अर हे राज्य-राज्य के सारे माणसों, उसकी बड़ाई करो।” ");
INSERT INTO bgc_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","अर यशायाह नबी पवित्र ग्रन्थ म्ह कहवै सै, “यिशै के वंश तै एक बेट्टा पैदा होगा, अर सारी जात्तां पै राज करैगा, वो गैर यहूदी माणसां नै बचावैगा।” ");
INSERT INTO bgc_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","मै प्रार्थना करुँ सूं, के परमेसवर जो आस का दात्ता सै, थारे ताहीं बिश्वास करण म्ह सारी तरियां के आनन्द अर शान्ति तै भरपूर करै, के पवित्र आत्मा की सामर्थ तै थारी आस बधती जावै। ");
INSERT INTO bgc_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","हे मेरे बिश्वासी भाईयो, मै अपणे-आप थारे बारै म्ह पक्का जाणु सूं, के थम भी आप ए भलाई तै भरे होए सों, अर थमनै बेरा होणा चाहिए के थमनै के करणा चाहिए, अर एक-दुसरे नै सीखा भी सको सों। ");
INSERT INTO bgc_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तोभी मन्नै कई बात्तां के बारें म्ह थारे ताहीं जो हिम्मत करकै लिख्या। यो उस अनुग्रह कै कारण होया जो परमेसवर नै मेरै ताहीं दिया सै, ");
INSERT INTO bgc_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","के मै गैर यहूदियाँ कै खात्तर मसीह यीशु का सेवक होकै परमेसवर कै सुसमाचार की सेवा याजक कै ढाळ करुँ, ताके गैर यहूदियाँ ताहीं परमेसवर खात्तर भेट के रूप म्ह दे सकूँ, जिसकै साथ वो खुश होवै सै, जिन ताहीं पवित्र आत्मा नै पवित्र माणस बणा दिया। ");
INSERT INTO bgc_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ज्यांतै मै यीशु मसीह के कारण ए परमेसवर की सेवा पै गर्व कर सकूँ सूं। ");
INSERT INTO bgc_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","क्यूँके मै हिम्मत कै गैल सिर्फ उन बात्तां बारै म्ह जिक्र करणा चाहूँ सूं, जो मसीह नै मेरे ताहीं करण के काबिल बणाया, ताके जो मन्नै कह्या अर करया सै उसके जरिये गैर यहूदी माणस परमेसवर का हुकम मान्नै। ");
INSERT INTO bgc_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","पवित्र आत्मा के जरिये दी गई शक्ति तै मै अदभुत चिन्ह-चमत्कार करुँ सूं, इस कारण जित्त भी मै यरुशलेम नगर तै लेकै चौगरदेकै इल्लुरिकुम परदेस तक गया, ओड़ै मन्नै सारया ताहीं यीशु मसीह का सुसमाचार सुणाया। ");
INSERT INTO bgc_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","पर मेरै मन की इच्छा या सै के जित्त-जित्त मसीह यीशु का नाम न्ही लिया गया, ओड़ैए सुसमाचार सुणाऊँ, अर उस मकान बणाण आळे मिस्त्री की ढाळ ना होऊँ जो दुसरे की नीम पै घर बणावै सै। ");
INSERT INTO bgc_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","पर जिसा पवित्र ग्रन्थ म्ह लिख्या सै मै उस ताहीं पूरा करणा चाहूँ सूं, “जिनकै धोरै यीशु मसीह का सुसमाचार न्ही पोंहच्या, वैए देखैंगें, अर जिन नै न्ही सुणा वैए समझैंगें।” ");
INSERT INTO bgc_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ज्यांतै मै थारे धोरै आण तै बार-बार रुक्या रहया। ");
INSERT INTO bgc_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","पर इब यरुशलेम नगर अर इल्लुरिकुम परदेस म्ह मन्नै माणसां ताहीं परमेसवर का वचन सुणा दिया सै, जिननै यीशु मसीह के बारें म्ह सुण्या ए न्ही था, अर इब मै थारे तै आकै मिलूँगा, जिसकी लालसा मन्नै घणे साल्लां तै थी। ");
INSERT INTO bgc_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ज्यांतै जिब मै स्पेन देश म्ह जाऊँगा, तो थारे धोरै होंदा होया जाऊँगा, क्यूँके मन्नै उम्मीद सै के उस सफर म्ह थारे तै भेंट होवैगी, अर जिब थारी संगति तै मेरा जी खुश हो जावै, तो थम मेरी स्पेन देश जाण म्ह मदद कर दिओ। ");
INSERT INTO bgc_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","पर इब तो मै यरुशलेम नगर म्ह जाऊँ सूं ताके ओड़ै परमेसवर के पवित्र माणसां नै दान दे सकूँ। ");
INSERT INTO bgc_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","क्यूँके मकिदुनिया अर अखाया परदेस के माणसां नै यो आच्छा लाग्या के यरुशलेम नगर के गरीब माणसां कै खात्तर कुछ दान कठ्ठा करै। ");
INSERT INTO bgc_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","उननै आच्छा तो लाग्या, पर वे यरुशलेमवासियों कै कर्जदार भी सै, क्यूँके यहूदियाँ नै गैर यहूदियाँ कै साथ परमेसवर की आत्मिक बात्तां का साँझा करया सै, यो सही सै गैर यहूदियाँ की दुनियावी चिज्जां नै यहूदियाँ कै गैल साँझा करै। ");
INSERT INTO bgc_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ज्यांतै मै यरुशलेम नगर म्ह जाण लागरया सूं, ताके वो दान दे सकूँ, जो मन्नै कठ्ठा करया सै, उसकै बाद थारे तै रोम देश म्ह मिलकै स्पेन देश म्ह जाऊँगा। ");
INSERT INTO bgc_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","अर मन्नै बेरा सै के जिब मै थारे धोरै आऊँगा, तो मै मसीह की आशीष नै थारे साथ साँझा करुँगा। ");
INSERT INTO bgc_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","हे बिश्वासी भाईयो, म्हारै प्रभु यीशु मसीह म्ह बिश्वास के कारण अर जो पवित्र आत्मा नै म्हारे ताहीं जो प्यार दिया सै मै थारे तै बिनती करुँ सूं, के मेरै खात्तर अर मेरे साथ मन तै परमेसवर तै प्रार्थना करो ");
INSERT INTO bgc_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ताके मै यहूदिया परदेस के अबिश्वासियाँ तै बचा रहूँ, अर जो दान मै यरुशलेम नगर म्ह लेकै जाण लागरया सूं, वो परमेसवर के पवित्र माणसां खात्तर खुशी का कारण बणै। ");
INSERT INTO bgc_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","अर मै परमेसवर की मर्जी तै थारे धोरै आनन्द कै गैल आकै थारे गेल्या आराम पाऊँ। ");
INSERT INTO bgc_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","मै प्रार्थना करुँ सूं, शान्ति का दात्ता परमेसवर थारे सारया कै गेल्या रहवै। आमीन। ");
INSERT INTO bgc_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","मै थारे तै फिबे कै खात्तर जो म्हारी बिश्वासी भाण अर किंख्रिया नगर की कलीसिया की सेविका सै, मै चाहूँ सूं के थम उसका आदर करो। ");
INSERT INTO bgc_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","थम यो जाणकै उसका इसा स्वागत करो जिसा थम परमेसवर के पवित्र माणसां का करो सों, अर जिस किसे बात म्ह उस ताहीं थारी जरूरत होवै, उसकी मदद करो, क्यूँके वा भी घणखरयां की बल्के मेरी भी उपकार करण आळी रही सै। ");
INSERT INTO bgc_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","प्रिसकिल्ला बिश्वासी भाण अर उसके धणी अक्विला नै जो मसीह यीशु म्ह मेरै गैल काम करणीये सै, उन ताहीं मेरा नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","उननै मेरै प्राण कै खात्तर अपणा ए जीवन जोख्खम म्ह गेर दिया था, अर सिर्फ मै ए न्ही, बल्के गैर यहूदियाँ की सारी कलीसिया भी उनका धन्यवाद करै सै। ");
INSERT INTO bgc_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","अर उस कलीसिया नै भी नमस्कार जो उनकै घर म्ह कठ्ठा होवै सै। मेरे प्यारे भाई इपैनितुस नै, जिसनै आसिया म्ह सब तै पैहले मसीह पै बिश्वास करया, उस ताहीं भी मेरा नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","बिश्वासी भाण मरियम ताहीं, जिसनै थारे खात्तर घणी मेहनत करी, नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","बिश्वासी भाई अन्द्रुनीकुस अर उसकी भाण यूनियास नै जो मेरे यहूदी साथी सै, जो मेरै गेल्या कैद होए थे अर प्रेरितां म्ह बड़ा नाम्मी सै, अर मेरै तै पैहल्या मसीह म्ह आए थे, नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","बिश्वासी भाई अम्पलियातुस नै, जो प्रभु मसीह म्ह मेरा प्यारा सै, नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","बिश्वासी भाई उरबानुस नै, जो मसीह म्ह म्हारा गैल काम करणीया सै, अर मेरे प्यारे बिश्वासी भाई इस्तखुस नै नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","बिश्वासी भाई अपिल्लेस नै जो मसीह म्ह खरयां लिकड़या, नमस्कार। बिश्वासी भाई अरिस्तुबुलुस कै कुण्बे नै नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","मेरै बिश्वासी साथी हेरोदियोन नै नमस्कार। बिश्वासी भाई नरकीस्सुस का कुण्बे के जो माणस परमेसवर पै बिश्वास करै सै, उन ताहीं नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","त्रुफेना अर त्रूफोसा बिश्वासी भाणां नै जो प्रभु म्ह मेहनत करै सै, नमस्कार। प्यारी बिश्वासी भाण पिरसिस नै, जिसनै प्रभु म्ह घणी मेहनत करी, नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","बिश्वासी भाई रूफुस नै जो प्रभु नै अपणा होण खात्तर चुण्या सै, अर उसकी माँ नै, जो मेरी भी माँ के समान सै, दोनुआ नै, नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","बिश्वासी भाई अंसुक्रितुस, फिलगोन, हिर्मेस, पत्रुबास, हर्मास अर उनकै साथ के सारे बिश्वासी भाईयाँ नै, नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","बिश्वासी भाई फिलुलुगुस, यूलिया अर नेर्युस अर उसकी बेब्बे, अर बिश्वासी भाई उलुम्पास अर उनकै साथ के सारे पवित्र माणसां नै नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","आप्पस म्ह एक-दुसरे ताहीं गळे मिलकै प्यार तै नमस्कार करो। थारे ताहीं मसीह की सारी कलीसियाओं की ओड़ तै नमस्कार। ");
INSERT INTO bgc_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","इब हे बिश्वासी भाईयो, मै थारे तै बिनती करुँ सूं, के जो माणस उस सच्ची शिक्षा कै उल्ट जो थमनै मिली सै, अर उन माणसां नै जो फूट गेरण अर ठेस लाग्गण का कारण बणै सै, उननै ताड़ लिया करो अर उनतै दूर रहो। ");
INSERT INTO bgc_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","क्यूँके इसे माणस म्हारै प्रभु मसीह के न्ही, पर अपणी ए इच्छा पूरी करै सै, अर चिकणी-चुपड़ी बात्तां तै सीध्धे-साद्दे माणसां नै भका देवैं सै। ");
INSERT INTO bgc_vpl VALUES ("R