﻿USE sofia;
DROP TABLE IF EXISTS sofia.bfz_vpl;
CREATE TABLE bfz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bfz_vpl WRITE;
INSERT INTO bfz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ये यीशु मसीह रे पुर्वजा रे नाओं ए जो राजा दाऊद और अब्राहमो रे वंशो रे थे। ");
INSERT INTO bfz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहमो ते इसहाक ऊआ; इसहाको ते याकूब ऊआ, याकूबो ते यहूदा और तेसरे ओर बी बऊत पाई ऊए। ");
INSERT INTO bfz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा री लाड़ी तामारा ते फिरिस और जोरह ऊआ, फिरिसो ते हिस्रोन जम्मेया और हिस्रोनो ते एराम ऊआ, ");
INSERT INTO bfz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","एरामो ते अम्मीनादाब ऊआ, अम्मीनादाबो ते नहशोन ऊआ और नहशोनो ते सलमोन ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन और तेसरी लाड़ी राहाबा ते बोअज ऊआ, बोअज और रूता ते ओबेद ऊआ और ओबेदो ते यिशै ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यिशै ते दाऊद राजा जम्मेया। दाऊदो ते सुलेमान तेसा जवाणसा ते ऊआ, जो पईले ऊरिय्याहो री लाड़ी थी। ");
INSERT INTO bfz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलेमानो ते रहबाम ऊआ, रहबामो ते अबिय्याह ऊआ, अबिय्याहो ते आसा ऊआ, ");
INSERT INTO bfz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसा ते यहोशफात ऊआ, यहोशफातो ते योराम और योरामो ते उज्जियाह ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्जियाहो ते योताम, योतामो ते आहाज और आहाजो ते हिजिकिय्याह ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजिकिय्याहो ते मनश्शिह, मनश्शिहो ते आमोन और आमोनो ते योशिय्याह ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","इस्राएली लोका खे बेबीलोनो खे बन्दी बणाई की लई जाणे ते पईले योशिय्याहो रे पोते यकुन्याह और तेसरे पाई ऊए। ");
INSERT INTO bfz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बन्दी ऊई की बेबीलोनो रे पऊँछाणे ते बाद यकुन्याहो ते शालतिएल जम्मेया और शालतिएलो रा पोता जरूब्बाबिल ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरूब्बाबिलो ते अबीहूद, अबीहूदो ते इल्याकीम और इल्याकीमो ते अजोर ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोरो ते सदोक, सदोको ते अखीम और अखीमो ते इलीहूद ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","इलीहूदो ते इलियाजार, इलियाजारो ते मत्तान और मत्तानो ते याकूब ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूबो ते यूसुफ ऊआ, जो मरियमा रा लाड़ा था। मरियमा रे यीशु पवित्र आत्मा ते जम्मेया, जिना खे मसीह बोलेया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","अब्राहमो ते दाऊदो तक सारिया चौदा पीढ़िया ऊईया और दाऊदो ते इस्राएलिया खे बाबेलो तक बन्दी बणाई की पऊँछाणे तक चौदा पीढ़िया ऊईया और बेबीलोनो तक बन्दी बणाई की पऊँछाणे ते मसीह तक चौदा पीढ़िया ऊईया। ");
INSERT INTO bfz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","एबे यीशु मसीह रा जन्म ईंयां ऊआ, कि जेबे तिना री आम्मा मरियमा री मंगणी यूसुफो साथे ऊई, तेबे तिना रा ब्या ऊणे ते पईले ई मरियम पवित्र आत्मा री तरफा ते गर्भवती ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","तेबे तेसा रा ऊणे वाल़ा लाड़ा यूसुफ जो तर्मी था, से तेसा खे बदनाम नि करना चाओ था, तिने आपणे मनो रे सोचेया कि मां ये चुपचाप छाडी देणी। ");
INSERT INTO bfz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जेबे से एड़ा सोचणे ई लगी रा था, तेबे प्रभुए रा स्वर्गदूत तेसखे सुपने रे दिशेया और से तेसखे बोलणे लगेया, “ओ दाऊदो रे वंशो रे यूसुफ! तूँ आपणी ऊणे वाल़ी लाड़ी मरियमा खे आपणे कअरे ल्याऊणे ते नि डर, कऊँकि जो तेसा रे पेटो रे बच्चा ए, से पवित्र आत्मा रिया तरफा तेआ। ");
INSERT INTO bfz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","तेसा रे एक पाऊ जमणा, तैं तेसरा नाओं यीशु राखणा। कऊँकि तेस आपणे लोक तिना रे पापो ते बचाई देणे।” ");
INSERT INTO bfz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ये सब कुछ तेबे ऊआ ताकि जो वचन प्रभुए भविष्यबक्ता ते बुलाई राखे, सेयो पूरे ओ ");
INSERT INTO bfz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“देखो, एक कुआँरी गर्भवती ऊणी और तेसा रे एक पाऊ जमणा और तेसरा नाओं इम्मानुएल ऊणा,” जेतेरा मतलब ए “परमेशर आसा साथे ए।” ");
INSERT INTO bfz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तेबे यूसुफ सयी की उठेया और जिंयाँ ई तेसखे परमेशरो रे स्वर्गदूते बोलेया था, तिंयाँ ई से आपणी ऊणे वाल़ी लाड़िया खे आपणे कअरे ली आया ");
INSERT INTO bfz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","और जदुओ तक, तेसा रे पाऊ नि जम्मेया, तदुओ तक यूसुफ तेसा गे नि गया और तेबे तेसा रे पाऊ जम्मेया और तिने तेसरा नाओं यीशु राखेया। ");
INSERT INTO bfz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","हेरोदेस राजे रे राज्य रे बखते जेबे यहूदिया प्रदेशो रे बैतलहम नगरो रे यीशुए रा जन्म ऊआ, तेबे देखो, पूर्व देशो ते कई ज्योतषी यरूशलेम नगरो रे आए और पूछणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“जो यहूदिया रा राजा जम्मी रा, से केई ए? कऊँकि आसे पूर्वो रे तेसरा तारा देखेया जो तेसरे जन्मो रे बारे रे बताओआ और आसे तेसगे माथा टेकणे आयी रे।” ");
INSERT INTO bfz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ये सुणी की हेरोदेस राजा और तेस साथे पूरा यरूशलेम कबराईगा। ");
INSERT INTO bfz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","तिने लोका रे सब बड़े पुरोईत और शास्त्री कट्ठे कित्ते और पूछेया, “मसीह रा जन्म केई ऊणा चाईयो?” ");
INSERT INTO bfz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","तिने सबी हेरोदेस राजे खे बोलेया, “यहूदिया प्रदेशो रे बैतलहम नगरो रे; कऊँकि परमेशरे मीका भविष्यबक्ते रे जरिए एई अया बोलेया रा ");
INSERT INTO bfz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘ओ बैतलहम, जो यहूदा रे प्रदेशो रे, तूँ किंयाँ बी यहूदा रे अधिकारिया रे सबी ते छोटा निया; कऊँकि तां बीचा ते एक राज करने वाल़ा निकल़ना जो मेरी प्रजा इस्राएलो रा रखवाल़ा ऊणा।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तेबे हेरोदेसे ज्योतषी चोरिए जे बुलाए और तिना ते पूछेया कि तारा ठीक केस बखते दिशेया था? ");
INSERT INTO bfz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","तिने ये बोली की सेयो बैतलहमो खे पेजे, “जाओ, और जाई की तेस बच्चे रे बारे रे ठीक-ठीक पता करो। जेबे से मिली जाओगा, तो आईकि मांगे बताओ, ताकि आऊँ बी आईकि तेसगे माथा टेकी सकूँ।” ");
INSERT INTO bfz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","सेयो राजे री गल्ल सुणी की चली गे और देखो, जो तारा तिने पूर्वो रे देखेया था, से तिना ते आगे-आगे चलणे लगेया और जेती बच्चा था, तेती जाई की रुकी गा। ");
INSERT INTO bfz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","तेस तारे खे देखी की सेयो बऊत खुश ऊए। ");
INSERT INTO bfz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","तेबे सेयो तेस कअरो रे पऊँछे और तिने बच्चा तेसरी माए मरियमा साथे देखेया, तेबे तिने मुंओ रे पारे लेटी की यीशुए गे माथा टेकेया और आपणा-आपणा चोल़ा खोलेया और सुईना, लोबान और गन्धरसो री पेंट चढ़ाई। ");
INSERT INTO bfz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","तेबे सुपने रे तिना खे ये आज्ञा मिली कि हेरोदेस राजे गे फेर नि जाणा, तेबे सेयो दुजिया बाटा रिये आपणे देशो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","तिना ज्योतषिया रे चली जाणे ते बाद परमेशरो रे एक स्वर्गदूते यूसुफो खे सुपने रे दिशणे ते बाद बोलेया, “उठ, और एस बच्चे और एसरी माया खे लयी की मिस्र देशो खे नठी जा और जदुओ तक आऊँ ताखे नि बोलूँ, तदुओ तक तेथी रणा, कऊँकि हेरोदेस राजा एस बच्चे खे काणा चाओआ और से एसखे टोल़ने लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तेबे से रातो-रात उठेया और बच्चे और बच्चे री माया खे लई की मिस्र देशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","जदुओ तक हेरोदेस नि मरेया, तदुओ तक से तेथी रया, ताकि जो वचन प्रभुए होशे भविष्यबक्ता ते बुलाई राखे, सेयो पूरे ओ कि, “मैं आपणा पाऊ मिस्र देशो ते बुलाया।” ");
INSERT INTO bfz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जेबे हेरोदेसो खे पता चलेया कि ज्योतषिये आऊँ ठगी ता, तेबे तेसखे बड़ा पारी रोष आया। तेबे तिने ज्योतषिया रे जरिए सई बखत पूछे रे मुताबिक आपणे मांणू बैतलहम और नेड़े-तेड़े पेजे और जो दो साला रे पाऊ थे और तिना ते छोटे थे, कुल़ाई ते। ");
INSERT INTO bfz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तेबे जो वचन यिर्मयाह भविष्यबक्ते बोलेया था, से पूरा ऊआ; ");
INSERT INTO bfz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह नगरो रे बड़िया-पारी राड़िया सुणिया, रोणा और शोग; राहेल आपणे बच्चेया खे रोणे लगी री थी और चुप नि ऊणा चाओ थी, कऊँकि तिना रे बच्चे काईते थे।” ");
INSERT INTO bfz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","हेरोदेसो रे मरने ते बाद, परमेशरो रे स्वर्गदूते मिस्र देशो रे यूसुफो खे सुपने रे बोलेया ");
INSERT INTO bfz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ और बच्चे और तेसरी आम्मा खे लई की इस्राएल देशो खे चली जा, कऊँकि जो बच्चे खे काणा चाओ थे, सेयो तो मरी गे।” ");
INSERT INTO bfz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","से उठेया और बच्चे और तेसरी आम्मा खे साथे लई की इस्राएल देशो खे आईगा। ");
INSERT INTO bfz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पर जेबे तिने सुणेया कि हेरोदेसो री जगा पाँदे एबे तेसरा पाऊ अरखिलाऊस यहूदिया प्रदेशो रे राज्य लगी रा चलाणे, तो से तेती जाणे ते डरीगा। तेबे सुपने रे तेसखे चेतावणी मिली और से गलील देशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","तेबे से नासरत नाओं रे नगरो रे बसी गा, ताकि भविष्यबक्ते रे जरिए बोलेया रा वचन पूरा ओ कि, “तेसखे नासरी बोलेया जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","तिना दिना रे यूहन्ना बपतिस्मा देणे वाल़ा यहूदिया रे सुणसाण जगा रे आयी की ये प्रचार करने लगेया, ");
INSERT INTO bfz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“मन फेरो; कऊँकि स्वर्गो रा राज्य नेड़े आईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ये सेई मांणू ए, जेसरी गल्ल यशायाह भविष्यबक्ते कित्ती थी कि, “सुणसाण जगा रे एक आक्का पाणे वाल़े री आवाज ओई, ‘प्रभुए री बाट त्यार करो, और तिना री सड़का सीदिया करो।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","तिने यूहन्ने ऊँटो रे बाल़ो रे टाले पईनी राखे थे और आपणे लको रे चामड़े रा पट्टू बानेया रा था और तेसरी रोटी टिड्डिया और बणो रा सईत था। ");
INSERT INTO bfz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तेबे यरूशलेमो रे, सारे यहूदिया प्रदेशो रे और सारे यरदन देशो रे ओरले-पोरले मांणू तेसगे आए। ");
INSERT INTO bfz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","तेबे तिने आपणे-आपणे पापो खे मानी की यरदन नदिया रे तेसते बपतिस्मा लया। ");
INSERT INTO bfz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जेबे तिने देखेया कि बऊत सारे फरीसी और सदूकी मांगे बपतिस्मा लणे लगी रे आऊणे, तेबे तिना खे बोलेया, “ओ सापो जेड़े जईरीले लोको! तुसा खे किने जताई ता कि आऊणे वाल़े परमेशरो रे रोषो ते नठो? ");
INSERT INTO bfz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","इजी री खातर मन फिराओ और अच्छे काम करो। ");
INSERT INTO bfz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","और आपणे-आपणे मनो रे एड़ा नि सोचो, ‘आसा रा बाओ अब्राहम ए।’ कऊँकि आऊँ तुसा खे बोलूँआ कि परमेशर इना पात्थरा ते अब्राहमो खे ल्वाद पैदा करी सकोआ। ");
INSERT INTO bfz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","एबे परमेशर तुसा खे सजा देणे वाल़ा ए, तेबेई तो जो-जो डाल़ खरा फल नि ल्याऊँदे, से बाडे और आगी रे सेटे जाओए। ");
INSERT INTO bfz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“आऊँ तो पाणिए की तुसा खे मन फेरने रा बपतिस्मा देऊँआ, पर जो मांते बाद आऊणे वाल़ा ए से मांते बी जादा महान् ए, आऊँ तेसरे जोड़े चकणे जोगा पनिए। तेस तुसा खे पवित्र आत्मा और आगी साथे बपतिस्मा देणा। ");
INSERT INTO bfz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","तेसरा सूप तेसरे आथो रे ए और तेस आपणा खल्याण ठीक टंगो ते साफ करना और कणक तो आपणे पण्डारो रे राखी देणी, पर जो पूऊ ऊणा, से एड़िया आगी रे सेटणा, जो कदी नि बिजणी।” ");
INSERT INTO bfz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","तेस बखते यीशु मसीह गलीलो ते यरदन नदिया रे कनारे यूहन्ने ते बपतिस्मा लणे आये। ");
INSERT INTO bfz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पर यूहन्ना तेसखे ये बोली की रोकणे लगेया, “माखे तो तुसा रे आथो ते बपतिस्मा लणे री जरूरत ए और तुसे मांगे आयी रे” ");
INSERT INTO bfz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यीशुए तेसखे ये जवाब दित्तेया, “एबे तो एड़ा ई ऊणे दे; कऊँकि आसा खे ईंयां ई सारी धार्मिकता पूरी करनी ठीक ए।” तेबे तिने यीशुए री गल्ल मानी ");
INSERT INTO bfz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","और यीशु मसीहे फटाफट बपतिस्मा लया और पाणिए ते पाँदे आए, और देखो, तिना खे सर्ग खुली गा; तेबे तिने परमेशरो री पवित्र आत्मा खे जिंयाँ कबूतर उड़दा ऊआ थाले आओआ तिंयाँ ई तिने आपू पाँदे आऊँदे ऊए देखेया ");
INSERT INTO bfz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","और देखो, स्वर्गो ते ये आवाज आयी, “ये मेरा प्यारा पुत्र ए, आऊँ एसते बऊत खुश ए।” ");
INSERT INTO bfz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","तेबे पवित्र आत्मा यीशुए खे सुणसाण जगा रे लईगा, ताकि शैतानो ते तिना री परीक्षा ओ। ");
INSERT INTO bfz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","सेयो चाल़ी दिन और चाल़ी राती पूखे रये और तेबे तिना खे पूख लगी। ");
INSERT INTO bfz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","तेबे शैताने यीशुए गे आई की बोलेया, “जे तूँ परमेशरो रा पुत्र ए, तो इना पात्थरा खे बोल कि रोटी बणी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीशुए जवाब दित्तेया, “पवित्र शास्त्रो रे लिखी राखेया, “ ‘मांणू रोटिया साथे ई जिऊँदा नि रणा, पर हर एक वचन, जो परमेशरो रे मुंओ ते निकल़ी रे तिना खे मानी की जिऊँदा रओआ।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तेबे शैतान यीशुए खे पवित्र नगर यरूशलेमो खे लईगा और सेयो मन्दरो री चूँडिया पाँदे खड़े करी ते। ");
INSERT INTO bfz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","तेबे तिना खे बोलणे लगेया, “जे तूँ परमेशरो रा पुत्र ए, तो आपू खे एथा ते थाले रुड़ाई दे; कऊँकि पवित्र शास्त्रो रे लिखी राखेया कि परमेशरो तेरिया तंईं आपणे स्वर्गदूता खे आज्ञा देणी, “ ‘और तिना तूँ आपणे आथो-आथ चकी लणा, केथी एड़ा नि ओ कि तेरे पैरो रे पात्थरो साथे बूड़ो।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीशुए तेसखे बोलेया, “पवित्र शास्त्रो रे एड़ा बीए लिखे रा, ‘तूँ प्रभु, आपणे परमेशरो खे नि परख।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","तेबे शैतान तिना खे एक ऊच्चे पाह्ड़ो पाँदे लईगा और सारी दुनिया रे सारे राज्य और तिजी रे एशो-आराम दखाई की ");
INSERT INTO bfz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","तिना खे बोलेया, “जे तां मांगे माथा टेकणा, तो मां ताखे ये सब कुछ देई देणा।” ");
INSERT INTO bfz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तेबे यीशुए तेसखे बोलेया, “हईओ शैतान; मेरी नजरा ते दूर ऊई जा, कऊँकि पवित्र शास्त्रो रे एड़ा लिखी राखेया, ‘तूँ प्रभु आपणे परमेशरो गे ई माथा टेक और बस तिना री ई आराधना कर।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तेबे शैतान यीशुए गे ते चली गा और स्वर्गदूत तिना री सेवा करने लगे। ");
INSERT INTO bfz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जेबे यीशुए सुणेया कि यूहन्ना पकड़वाईता, तेबे सेयो यहूदिया प्रदेशो खे छाडी की गलील प्रदेशो रे नासरत नगरो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","और फेर सेयो नासरत नगरो खे छाडी की कफरनहूम नगरो रे रणे लगे, जो जबूलून और नप्ताली इलाके रे समुद्रो रे कनारे था। ");
INSERT INTO bfz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ताकि जो यशायाह भविष्यबक्ते बोलेया था, से पूरा ओ, ");
INSERT INTO bfz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबूलून और नप्तालिया रे इलाके, समुद्रो री बाटा रिये यरदन नदिया रे पार, दूजी जातिया रा गलील। ");
INSERT INTO bfz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","जो मांणू परमेशरो खे नि जाणदे और न्हेरे रे जिऊणे लगी रे थे, तिने बड़ी जोति देखी; और जो मौता ते डरी की जिऊणे लगी रे थे, तिना पाँदे जोति चमकी।” ");
INSERT INTO bfz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","तेस बखतो ते यीशुए ये प्रचार करना और ये बोलणा शुरू करी ता कि, “मन फेरो कऊँकि स्वर्गो रा राज्य नेड़े आईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","तेबे तिने गलीलो रे समुद्रो रे कनारे कूमदे ऊए दो पाई, मतलब-शमौन, जेसखे पतरस बी बोलोए और तेसरा पाई अन्द्रियास समुद्रो रे जाल़ पाँदे ऊए देखेया, कऊँकि सेयो मछलिया पकड़ने वाल़े थे। ");
INSERT INTO bfz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","तेबे यीशुए तिना खे बोलेया, “मां पीछे आओ और जिंयाँ तुसे मच्छली पकड़ना जाणोए तिंयाँ ई मां तुसा खे परमेशरो गे मांणू पकड़ी की ल्याऊणे सिखाणे।” ");
INSERT INTO bfz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","सेयो तेबुई जाल़ छाडी की यीशुए पीछे चली पड़े। ");
INSERT INTO bfz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","तेथा ते आगे जाई की यीशुए और दो पाई मतलब जब्दिए रे पाऊ याकूब और तेसरा पाई यूहन्ना आपणे पिते साथे किस्तिया पाँदे जाल़ ठीक करदे ऊए देखे और तिने सेयो बी बुलाए। ");
INSERT INTO bfz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","सेयो तेबुई आपणी किस्ती और आपणे पिते खे छाडी की यीशुए रे पीछे चली पड़े। ");
INSERT INTO bfz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यीशु गलील प्रदेशो रे बऊत सारी जगा रे कूमदे रए और तिना री प्रार्थना रे कअरो रे उपदेश और राज्य रा सुसमाचार प्रचार करदे रए और लोका री बमारिया और कमजोरिया खे दूर करदे रए। ");
INSERT INTO bfz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","तेबे सारे सीरिया प्रदेशो रे सेयो मशुर ऊईगे और लोक सारे बमारा खे, जो कई प्रकारा रिया बमारिया ते और दु:खो रे जकड़ी रे थे, जिना रे दुष्टात्मा थिया, मिर्गी वाल़े और अदरंगो रे रोगिया खे यीशुए गे ल्याए और तिने सेयो ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","तेबे गलील प्रदेश, दिकापुलिस इलाका, यरूशलेम नगर, यहूदिया प्रदेश और यरदनो री नदिया ते पारो ते पीड़ा री पीड़ तिना पीछे आईगी। ");
INSERT INTO bfz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","यीशु तेसा पीड़ा खे देखी की पाह्ड़ो पाँदे चढ़ी गे, जेबे सेयो उपदेश देणे बैठे, तेबे तिना रे चेले तिना गे आए। ");
INSERT INTO bfz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","तेबे यीशु ये उपदेश देणे लगे: ");
INSERT INTO bfz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“धन्य ए सेयो, जो मनो रे सल़ीन ए, कऊँकि स्वर्गो रा राज्य तिना रा ईए। ");
INSERT INTO bfz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","धन्य ए सेयो, जो शोग करोए, कऊँकि परमेशरो तिना खे शान्ति देणी। ");
INSERT INTO bfz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","धन्य ए सेयो, जो नम्र ए, कऊँकि सेयो तरतिया रे अक्कदार ऊणे। ");
INSERT INTO bfz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धन्य ए सेयो, जो धार्मिकता री जिन्दगी जिऊणे खे पूखे ए और त्याय ए, कऊँकि सेयो रजाए जाणे। ");
INSERT INTO bfz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","धन्य ए सेयो, जो दयालु ए, कऊँकि परमेशरो तिना पाँदे दया करनी। ");
INSERT INTO bfz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","धन्य ए सेयो, जिना रे मन साफ ए, कऊँकि तिना परमेशर देखणा। ");
INSERT INTO bfz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","धन्य ए सेयो, जो मेल-जोल कराओए, कऊँकि तिना खे परमेशरो रे बच्चे बोलेया जाणा, ");
INSERT INTO bfz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धन्य ए सेयो, जो धार्मिकता री जिन्दगी जिऊणे री तंईं सताए जाओए, कऊँकि स्वर्गो रा राज्य तिना रा ईए। ");
INSERT INTO bfz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“धन्य ए तुसे, जेबे लोक मेरी बजअ ते तुसा री निन्दा करोए, तुसा खे सताओए और चूठ बोली-बोली की तुसा रे खलाफ बुरी-बुरी गल्ला बोलोए। ");
INSERT INTO bfz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तेबे खुश और मगन ऊणा, कऊँकि तुसा खे स्वर्गो रे बऊत बड़ा ईनाम मिलणा, कऊँकि तिने, जो तुसा ते बऊत पईले भविष्यबक्ता थे, सेयो बी ईंयां ई सताए थे। ");
INSERT INTO bfz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“तुसे तरतिया रे रणे वाल़े लोका खे लूणो जेड़े ए। पर जे लूणो रा स्वाद बिगड़ी जाओ, तेबे कुण जी एड़ी चीज ए जेते की लूणका ऊई जाओ। तेबे से किजी कामो रा नि रंदा सिवाए एतेरे कि तेसखे बारे सेटी देयो और लोक तिजी खे पैरा निठे केसदे रओ। ");
INSERT INTO bfz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तुसे दुनिया री जोति ए, जो नगर पाह्ड़ो पाँदे बसी रा, से लूकी नि सकदा। ");
INSERT INTO bfz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","लोक दिऊआ बाल़ी की टोकरूए निठे नि राखदे, पर फटिया पाँदे राखोए, तेबे तिजी साथे कअरो रे सारे मांणूआ खे प्रयासा ओआ। ");
INSERT INTO bfz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","तिंयाँ ई तुसा रा प्रयासा बी लोका सामणे चमको, ताकि तुसा रे खरे काम देखी की सेयो तुसा रे पिते री, जो स्वर्गो रे ए, तिना री तारीफ करो। ");
INSERT INTO bfz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“एड़ा नि समजो कि आऊँ मूसे रा बिधान या भविष्यबक्ता री कताबा खे रचाणे आयी रा, आँऊ रचाणे नि, पर पूरा करने आयी रा। ");
INSERT INTO bfz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","कऊँकि आऊँ तुसा खे सच लगी रा बोलणे कि जदुओ तक सर्ग और तरती नि टल़ी जाओगी, तदुओ तक बिधानो ते एक बी मात्रा या एक बी बिन्दु बिना पूरा ऊए नि टल़ना। ");
INSERT INTO bfz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","तेबेई तो जो कोई इना छोटिया ते छोटी आज्ञा बीचा ते केसी एकी खे पनि मानोगा और तेड़ा ई लोका खे सिखाओगा, से स्वर्गो रे राज्य रे सबी ते छोटा ऊणा, पर जो कोई तिना आज्ञा खे मानोगा और तिना खे बी सिखाओगा, सेई स्वर्गो रे राज्य रे बड़ा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","कऊँकि आऊँ तुसा खे बोलूँआ कि जे तुसे परमेशरो री आज्ञा खे शास्त्री और फरीसिया री आज्ञा ते बड़ी की नि मानो, तो तुसे कदी बी स्वर्गो रे राज्य रे नि जाई सकदे। ");
INSERT INTO bfz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“तुसे सुणी चुकी रे कि पुराणे बखतो रे मांणूआ खे बोलेया था कि ‘अत्या नि करनी’, और जो कोई बी अत्या करोगा तेसखे कचैरिया रे सजा मिलणी। ");
INSERT INTO bfz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पर आऊँ तुसा खे ये बोलूँआ कि जो बी आपणे पाईए पाँदे रोष करोगा, तेसखे कचैरिया रे सजा मिल़णी और जो कोई आपणे पाईए खे नकम्मा बोलोगा, तेसखे बडिया सभा रे सजा मिलणी और जो कोई दूजे खे ‘अरे मूर्ख’ बोलोगा से नरको री आगी री सजा जोगा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","इजी री खातर जेबे तूँ आपणी पेंट बेदिया पाँदे ल्याओ और तेती तूँ याद करे कि तेरे पाईए रे मनो रे तेरिया तंईं खोट ए, ");
INSERT INTO bfz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","तो आपणी पेंट तेथी बेदिया रे सामणे छाडी दे और पईले जाई की आपणे पाईए साथे मेल-जोल कर, तेबे आयी की आपणी पेंट चढ़ा। ");
INSERT INTO bfz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","जदुओ तक तूँ आपणे दुश्मणो साथे बाटा रेईए, तेस साथे फटाफट मेल-जोल करी लो, केथी एड़ा नि ओ कि तेरा दुश्मण ताखे हाकिमो रे आथो रे देई देओ और हाकिम ताखे सिपाईया रे आथो रे देई देओ और ताखे जेला रे पाई देओ। ");
INSERT INTO bfz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","आऊँ ताखे सच बोलूँआ कि जदुओ तक तूँ पाई-पाई नि देई देओगा, तदुओ तक तेथा ते छुटणा नि। ");
INSERT INTO bfz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“तुसे सुणी चुकी रे कि बोलेया था, ‘व्याभिचार नि करना।’ ");
INSERT INTO bfz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पर आऊँ तुसा खे ये बोलूँआ कि जो कोई बी केसी जवाणसा खे बुरी नजरा ते देखोआ, तो तिने आपणे मनो रेई तेसा साथे व्याभिचार करी ला। ");
INSERT INTO bfz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","जे तेरी दाँणी आख ताखे ठोकरा री बजअ बणो ई, तो तूँ तेसा खे काडी की सेटी दे; कऊँकि ताखे येई ठीक ए कि तेरे अंगा बीचा ते एक नाश बी ऊई जाओ, तो सारा शरीर नरको रे नि सेटेया जाओ ");
INSERT INTO bfz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","जे तेरा दाँणा आथ ताखे ठोकरा री बजअ बणोआ, तो तेस बाडी की सेटी दे, कऊँकि ताखे येई ठीक ए कि तेरे अंगा बीचा ते एक नाश बी ऊई जाओ तो सारा शरीर नरको रे नि पड़ना। (एतेरा मतलब ये नियाँ कि आसा आपणी आख काडी की सेटी देणी या आपणा आथ बाडी देणा पर ये कि जो काम तुसा खे परमेशरो रे राज्य रे आगे बड़ने ते रोको ए या जो मांणू तुसा खे गल़त करने खे उकसाओ ए तो तुसा से मांणू या चीज छाडी देणी चाईयो।) ");
INSERT INTO bfz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ये बी बोलेया रा था, ‘जो कोई आपणी लाड़िया खे तलाक देणा चाओ, तो से तेसा खे त्यागपत्र देयो।’ ");
INSERT INTO bfz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पर आऊँ तुसा खे ये बोलूँआ कि जो कोई आपणी लाड़िया खे व्याभिचारो ते अलावा किजी ओरी बजअ ते छाडोगा, तो से तेसा ते व्याभिचार करवाओआ और जो कोई तेसा छाडी रिया जवाणसा साथे ब्या करोआ, से बी व्याभिचार करोआ। ");
INSERT INTO bfz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“फेर तुसे सुणी चुकी रे कि पुराणे जमाने रे लोका खे बोलेया रा था, ‘चूठी कसम नि खाणी, पर प्रभुए री खातर आपणी कसम पूरी करनी।’ ");
INSERT INTO bfz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पर आऊँ तुसा खे ये बोलूँआ, कि कदी कसम नि खाणी, ना तो स्वर्गो री, कऊँकि से परमेशरो रा सिंहासन ए। ");
INSERT INTO bfz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ना तरतिया री, कऊँकि से तिना रे पैरो री चौकी ए, ना यरूशलेमो री, कऊँकि से महाराजे रा नगर ए। ");
INSERT INTO bfz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","आपणे सिरो री कसम पनि खाणा, कऊँकि तूँ एक बी बाल़ो खे न तो सफेद करी सकदा, ना ई काल़ा। ");
INSERT INTO bfz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","पर तुसा री गल्ल ‘आ री आ’ और ‘ना री ना’ ऊणी चाईयो; कऊँकि जो गल्ल इजी ते जादा ओई, से शैतानो री तरफा तेई ओई। ");
INSERT INTO bfz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“तुसे सुणी चुकी रे कि बिधानो रे बोलेया रा था, ‘आखी रे बदले आख, और दाँदो रे बदले दाँद।’ ");
INSERT INTO bfz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पर आऊँ तुसा खे ये बोलूँआ कि जो कोई तां साथे बुरा करो तेतेरा बदला नि लणा, पर जो कोई तुसा री दाँणी खाखा रे थप्पड़ बाओआ, तो तेस कनारो खे दूजी खाख बी करी देओ। ");
INSERT INTO bfz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","जे कोई तां पाँदे दोष लगाई की तांते तेरा कुरता लणा चाओआ, तो तेसखे तोती बी लणे देओ। ");
INSERT INTO bfz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","जे कोई जबरदस्ती ताखे एक मील लई चलोआ, तो तूँ दो मील तेस साथे चल। ");
INSERT INTO bfz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जो कोई तांते माँगो, तेसखे दे और जो कोई तांते त्वार लणा चाओआ, तो तूँ तेसते मूँ नि फेर। ");
INSERT INTO bfz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“तुसे सुणी चुकी रे कि बिधानो रे बोलेया रा था, ‘आपणे पड़ोसिये साथे प्यार राखो और आपणे बैरिया साथे बैर।’ ");
INSERT INTO bfz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पर आऊँ तुसा खे बोलूँआ कि आपणे दुश्मणा साथे प्यार राखो और जो तुसा खे सताओआ, तो तेसखे प्रार्थना करेया करो। ");
INSERT INTO bfz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ताकि तुसे आपणे स्वर्गो रे पिते रे बच्चे ठईरो, कऊँकि से खरे लोका और बुरे लोका दूँईं पाँदे आपणा सूरज निकयाल़ोआ और तर्मी लोका और पापी लोका दूँईं पाँदे बरखा करोआ। ");
INSERT INTO bfz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","कऊँकि जे तुसे आपू साथे प्यार राखणे वाल़ेया साथे ई प्यार राखोगे, तो तुसा खे क्या फाईदा ऊणा? क्या कर लणे वाल़े बी एड़ा ई नि करदे? ");
INSERT INTO bfz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“जे तुसे आपणे पाईए खेई नमस्कार करोए, तो कुण जा बड़ा काम करोए? क्या दूजी जातिया रे बी एड़ा ई नि करदे? ");
INSERT INTO bfz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","इजी री तंईं तुसे सिद्ध बणो, जेड़ा तुसा रा स्वर्गिय पिता सिद्ध ए। ");
INSERT INTO bfz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“सावधान रओ! तुसे लोका खे दखाणे रिया तंईं तर्मो रे काम नि करो, नई तो आपणे स्वर्गिय पिते ते कुछ बी फल नि मिल़णा। ");
INSERT INTO bfz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","तेबेई तो जेबे तूँ दान करे, तो सबी गे राग नि लगा, जेड़ा कपटी, प्रार्थना रे कअरो रे और गल़िया रे करोए, ताकि लोक तिना री तारीफ करो। आऊँ तुसा खे सच बोलूँआ कि सेयो आपणा फल पाई चुके। ");
INSERT INTO bfz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पर जेबे तूँ दान करे, तो जो तेरा दाँणा आथ करोआ, से तेरे खूँजे आथो खे पता नि ऊणा चाईए। ");
INSERT INTO bfz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताकि तेरा दान गुप्त रओ और तेबे तेरा पिता जो गुप्तो रे देखोआ, तेस ताखे फल देणा। ");
INSERT INTO bfz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“जेबे तूँ प्रार्थना करे, तो कपटिया जेड़ी नि ऊणी चाईयो, कऊँकि लोका खे दखाणे रिया तंईं प्रार्थना रे कअरो रे और सड़का रे मोड़ो रे खड़े ऊई की प्रार्थना करना तिना खे अच्छा लगोआ, पर आऊँ तुसा खे सच बोलूँआ कि सेयो आपणा फल पाई चुके। ");
INSERT INTO bfz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पर जेबे तूँ प्रार्थना करे, तो आपणे कमरे रे जा और दरवाजा बन्द करी की आपणे पिते ते, जो गुप्तो रे ए, प्रार्थना कर। तेबे तेरा पिता, जो गुप्तो रे देखोआ, तेस ताखे फल देणा। ");
INSERT INTO bfz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","जेबे तूँ प्रार्थना करे तो दूजी जातिया जेड़ी बक-बक नि कर, कऊँकि सेयो समजोए कि तिना रे बऊत बोलणे ते तिना री सुणनी। ");
INSERT INTO bfz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","इजी री खातर तुसे तिना जेड़े नि बणो, कऊँकि तुसा रा पिता पईले ई जाणोआ कि तुसा री क्या-क्या जरूरता ए। ");
INSERT INTO bfz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“तो तुसे ईंयां प्रार्थना करेया करो; “ ‘ओ म्हारे पिता, तुसे जो स्वर्गो रे ए, तुसा रा नाओं पवित्र मानेया जाओ। ");
INSERT INTO bfz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तुसा रा राज्य आओ, जेड़ी तुसा री इच्छा स्वर्गो रे पूरी ओई, तेड़ी ई, तरतिया पाँदे बी ओ। ");
INSERT INTO bfz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","आसा रे पूरे दिनो री रोटी आज आसा खे दे। ");
INSERT INTO bfz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","और जिंयाँ आसे आपणे अपराधिया खे माफ कित्तेया, तिंयाँ ई म्हारे अपराध बी माफ करो। ");
INSERT INTO bfz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","आसा खे परीक्षा रे नि ल्याओ, पर शैतानो ते बचाओ, कऊँकि राज्य, पराक्रम और महिमा तुसा री ए। आमीन्।’ ");
INSERT INTO bfz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“तेबेई तो जे तुसे लोका रे अपराध माफ करोगे, तो तुसा रे स्वर्गिय पिते बी तुसा रे अपराध माफ करने। ");
INSERT INTO bfz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","जे तुसे लोका रे अपराध माफ करो, तुसा रे पिते बी तुसा रे अपराध माफ करने। ");
INSERT INTO bfz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“जेबे तुसे बअरत करोए, तो कपटिया जेड़ी तुसा रे मुंओ पाँदे उदासी नि रओ, कऊँकि सेयो आपणा मूँ एतेरी तंईं बणाई राखोए, ताकि लोक तिना खे बअरततारी जाणो; आऊँ तुसा खे सच बोलूँआ कि सेयो आपणा फल पाई चुके। ");
INSERT INTO bfz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पर जेबे तूँ बअरत करे, तो आपणे सिरो रे तेल मल़ और मूँ तोओ। ");
INSERT INTO bfz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ताकि लोक नि, पर तेरा पिता, जो गुप्तो रे ए, से ताखे बअरततारी जाणो, एड़िया दशा रे तेरा पिता, जो गुप्तो रे ए, से देखोआ और तेस ताखे फल देणा। ");
INSERT INTO bfz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“आपणी तंईं तरतिया पाँदे धन कट्ठा नि करो, जेती कीड़ा और केअट लगी जाओई और जेती चोरा खे पता लगी जाओआ और चोरी करोए। ");
INSERT INTO bfz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","पर आपू खे खरा काम करी की स्वर्गो रे धन कट्ठा करो, जेती ना कीड़ा लगो, ना खराब ओ, ना तेती चोरो खे पता लगोआ और ना ई चोरी करदे। ");
INSERT INTO bfz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","कऊँकि जेती तेरा धन ए, तेती तेरा मन बी लगेया रा रणा। ");
INSERT INTO bfz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“शरीरो रा दिऊआ तो आखी ए, तेबे जे तेरी आखी साफ ए, तो तेरे सारे शरीरो रे बी प्रयासा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","पर जे तेरी आखी बुरिया ए, तो तेरे सारे शरीरो रे बी न्हेरा ई ऊणा, इजी बजअ ते से प्रयासा, जो तांदे ए, जे न्हेरा ओ, तो से न्हेरा कितणा बड़ा ऊणा! ");
INSERT INTO bfz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“कोई बी मांणू एकी बखतो रे दो मालका री सेवा नि करी सकदा, कऊँकि तेस एकी साथे प्यार और दूजे साथे बैर राखणा या एकी साथे मिले रा रणा और दूजा तेस तुच्छ जाणना। तुसे परमेशर और धन दूँईं री सेवा नि करी सकदे। ");
INSERT INTO bfz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","तेबेई तो आऊँ तुसा खे बोलूँआ कि आपणी जिन्दगिया रे बारे रे ये चिन्ता नि करो कि आसे क्या खाऊँगे और क्या पिऊँगे? ना आपणे शरीरो रे बारे रे कि क्या पईनुँगे? क्या जिन्दगी रोटिया ते और शरीर टालेया ते बढ़ी की निए? ");
INSERT INTO bfz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","सर्गो रे पंछिया खे देखो, सेयो ना बांदे, ना बाडदे और ना ई पण्डारो रे कट्ठा करदे, तेबे बी आसा रा स्वर्गिय पिता तिना खे खुल़ाओआ। क्या तुसे तिना ते जादा किमती निए? ");
INSERT INTO bfz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुसा बीचा ते एड़ा कुण ए, जो चिन्ता करी की आपणिया जिन्दगिया री एक कअड़ी बी बढ़ाई सकोआ? ");
INSERT INTO bfz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“तुसे टालेया री चिन्ता कऊँ करोए? बांके जंगल़ी फूला पाँदे त्यान करो कि सेयो किंयाँ बड़ोए? सेयो ना तो मईणत करदे ना आपू खे टाले बणाओए। ");
INSERT INTO bfz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","पर आऊँ तुसा खे बोलूँआ कि राजा सुलेमान आपणे सारे एशो-आरामो रे रओ था और बऊत बांके टाले पईनो था, पर तेबे बी तेसरे टाले तिना जंगल़ी फूला ते जादा बांके नि थे। ");
INSERT INTO bfz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","तेबेई तो जेबे परमेशर मैदानो रे काओ खे, जो आज आए और काल आगी बीचे फूकी देणा, तो जो तिदे बी एड़े बांके फूल खिलाओआ, तो ओ कम विश्वास करने वाल़ेयो! तुसा खे तेस इना ते बढ़ी की बांके टाले कऊँ नि पनयाणे? ");
INSERT INTO bfz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“तेबेई तो तुसे चिन्ता करी की ये नि बोलणा, ‘आसे क्या खाऊँगे?’ और ‘क्या पिऊँगे?’ और ‘क्या पईनुँगे?’ ");
INSERT INTO bfz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","दूजी जातिया रे लोक इना सबी चीजा री चिन्ता करोईया, पर तुसे इना चीजा री चिन्ता नि करो। कऊँकि तुसा रा स्वर्गिय पिता जाणोआ कि तुसा खे इना सबी चीजा री जरूरत ए। ");
INSERT INTO bfz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","इजी री खातर, जे पइले तुसे परमेशरो रे राज्य री टोल़ करो और धार्मिकता री जिन्दगी जिओ, तो यो सब चीजा तुसा खे मिली जाणिया। ");
INSERT INTO bfz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","इजी खे कालकी चिन्ता नि करो, कऊँकि काल का जो दिन ऊणा, तेस आपणी चिन्ता आपू करी लणी, आजो खे तो आजका दु:ख ई बऊत ए। ");
INSERT INTO bfz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“दोष मत लगाओ, ताकि तुसा पाँदे बी दोष नि लगाया जाओ। ");
INSERT INTO bfz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","कऊँकि जिंयाँ तुसे दोष लगाओए, तिंयाँ ई परमेशरो तुसा पाँदे बी दोष लगाणा और जेड़ा बर्ताव तुसे लोका साथे करोए परमेशरो बी तेड़ा ई बर्ताव तुसा साथे करना। ");
INSERT INTO bfz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“तूँ कऊँ आपणे पाईए री छोटी-छोटी गल़तिया टोल़ेया तांदे आपणिया बड़ी-बड़ी गल़तिया नजर कऊँ नि आँऊदिया? ");
INSERT INTO bfz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जेबे तांदे आपू दे बड़ी-बड़ी गल़तिया ए, तो तूँ आपणे पाईए खे किंयाँ बोली सकेया, ‘तूँ गल़त ए?’ ");
INSERT INTO bfz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ओ कपटी! पईले आपणी बड़ी-बड़ी गल़तिया देख, तेबेई तो तूँ आपणे पाईए री गल़तिया ठीक-टंगो रे देखी की निकयाल़ी सकेया। ");
INSERT INTO bfz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“पवित्र चीज कुत्तेया खे नि देओ और आपणे मोती सूंअरो रे आगे नि सेटो, एड़ा नि ओ कि सेयो तिना खे आपणे पैरा निठे केसी देयो और ताखे खाणे पड़ो। ");
INSERT INTO bfz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“तुसा री जो बी जरूरत ए से परमेशरो ते माँगो और परमेशरो ते पाणे री उम्मीद बी राखो। ");
INSERT INTO bfz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","कऊँकि जो कोई माँगोआ तेसखे मिलोआ। जो टोल़ोआ, से पाओआ। जो खटखटाओआ तेसखे खोलेया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तुसा बीचा ते कुण एड़ा मांणू ए कि तेसरा पाऊ तेसते रोटी मांगोगा और से तेसखे पात्थर देओ? ");
INSERT INTO bfz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","या मछली माँगो और तेसखे साप देओ? ");
INSERT INTO bfz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","तो तेबे तुसे बुरे ऊई की आपणे बच्चेया खे खरी चीजा देणा जाणोए, तो तुसा रे स्वर्गिय पिते आपणे मांगणे वाल़ेया खे अच्छी चीजा कऊँ नि देणियां? ");
INSERT INTO bfz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","इजी बजअ ते जो कुछ तुसे चाओए कि मांणू तुसा साथे करो, तुसे बी तिना साथे तेड़ा ई करो, कऊँकि मूसे रा बिधान और भविष्यबक्तेया री येई शिक्षा ए। ");
INSERT INTO bfz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“स्वर्गो रे परमेशरो तक पऊँछणे री बाट बऊत कठण ए। पर एते बाटा रिये तुसा चलणा ईए। एक और चौड़ी बाट ए जिदे जादातर लोक चलणा पसंद करोए, से बाट नरको खे जाओई और लोक तिदे मरी जाणे। ");
INSERT INTO bfz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","कऊँकि संगड़ा ए से फाटक और कठण ए से बाट, जो अनन्त जिन्दगिया खे पऊँछाओई और सेयो थोड़े ईए, जिना खे से मिलोई। ");
INSERT INTO bfz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“चूठे भविष्यबक्तेया ते सावधान रओ, जो पेडा रे पेषो रे तुसा गे आओए, पर पीतरो ते सेयो फाड़ने वाल़े भेड़िए ओए। ");
INSERT INTO bfz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","तिना रे बुरे कामो ते तुसा सेयो पछयाणी लणे, क्या जाड़ो रे अँगूर और कांडेया ते दाऊगल़े तोड़े जाओए? ");
INSERT INTO bfz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","तिंयाँ ई हर एक अच्छा डाल़ अच्छा फल ल्याओआ और नकम्मा डाल़ बुरा फल। ");
INSERT INTO bfz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","अच्छा डाल़ बुरा फल नि ल्याई सकदा और ना नकम्मा डाल़ अच्छा फल ल्याई सकदा। ");
INSERT INTO bfz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जिंयाँ जो-जो डाल़ अच्छा फल नि ल्याऊँदे, सेयो बाडे जाओए और आगी बीचे सेटे जाओए। तिंयाँ ई चूठे भविष्यवक्ता बी नरको री आगी रे सेटे जाणे। ");
INSERT INTO bfz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ईंयां तिना रे कामो ते तुसा सेयो पछयाणी लणे। ");
INSERT INTO bfz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“जो माखे, ‘ओ प्रभु, ओ प्रभु’ बोलोआ, तिना बीचा ते हर एक स्वर्गो रे राज्य रे नि जाणा, पर सेई, जो-जो मेरे स्वर्गिय पिते री इच्छा पाँदे चलोआ। ");
INSERT INTO bfz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","न्याय रे तेस दिने बऊत मांणूआ माखे बोलणा, ‘ओ प्रभु, ओ प्रभु, क्या आसे तेरे नाओं ते भविष्यबाणी नि कित्ती, और तेरे नाओं ते दुष्टात्मा नि निकयाल़िया, और तेरे नाओं ते बऊत सामर्था रे काम नि कित्ते?’ ");
INSERT INTO bfz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तेबे मां तिना खे खुली की बोली देणा, ‘आऊँ तो तुसा खे कदी नि जाणदा। ओ कुकर्म करने वाल़ेयो, मांगा गे ते चली जाओ।’ ");
INSERT INTO bfz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“इजी री खातर जो कोई मेरिया गल्ला सुणी की तिना खे मानोआ, से तेस अक्लमंद मांणूए जेड़ा ऊणा, जिने आपणा कअर चट्टानी पाँदे बणाया। ");
INSERT INTO bfz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","तेबे बरखा उईया, बाढ़ा आईया और तूफान चले, और तेस कअरो रे टकराए, पर से कअर नि टल़ेया, कऊँकि तिजी री निऊँ चट्टानी पाँदे थी बणाई री। ");
INSERT INTO bfz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","पर जो कोई मेरी इना गल्ला तो सुणोआ, पर मानदा नि, से तेस मूर्ख मांणूए जेड़ा ऊणा, जिने आपणा कअर बालूए पाँदे बणाया। ");
INSERT INTO bfz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","जेबे बरखा ऊईया, बाढ़ा आईया, तूफान चले और तेस कअरो साथे टकराए और से कअर तेबुई टल़ीगा और सत्यानाश ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जेबे यीशु इना गल्ला करी चुके, तो एड़ा ऊआ कि जो तेती पीड़ थी, से हैरान उईगी। ");
INSERT INTO bfz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","कऊँकि सेयो तिना शास्त्रिया जेड़े नि, पर अक्को साथे उपदेश देयो थे। ");
INSERT INTO bfz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जेबे यीशु तेस पाह्ड़ो ते उतरे, तो एक बऊत बड़ी पीड़ तिना पीछे आईगी। ");
INSERT INTO bfz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","तेबे देखो, एक कोढ़िए तिना गे आयी की तिना गे माथा टेकेया और बोलेया, “ओ प्रभु, जे तुसे चाओ तो माखे ठीक करी सकोए।” ");
INSERT INTO bfz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीशुए आपणा आथ आगे कित्तेया और से छूँयां और तेसखे बोलेया, “आऊँ चाऊँआ कि तूँ ठीक ऊई जाए।” से तेबुई आपणे कोढ़ो ते ठीक ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीशुए तेसखे बोलेया, “देख, केसी गे नि बताणा, पर जाई की आपू खे पुरोईतो गे दखा और जो कुछ मूसे नबीए चढ़ावा ठराई राखेया, तेस चढ़ा, ताकि तिना खे गवाई ओ कि तूँ ठीक ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जेबे यीशु कफरनहूम नगरो रे आए, तो एकी सूबेदारे तिना गे आयी की तिना ते बिनती कित्ती, ");
INSERT INTO bfz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ओ प्रभु! मेरा दास कअरे अदरंगो ते दु:खी पड़ी रा।” ");
INSERT INTO bfz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","यीशुए तेसखे बोलेया, “आऊँ आयी की तेसखे ठीक करूँगा।” ");
INSERT INTO bfz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सूबेदारे जवाब दित्तेया, “ओ प्रभु! आऊँ एते जोगा निए कि तुसे मेरे कअरे आयी सको, पर जे तुसे आपणे मुंओ तेई बोली देओ, तो से मेरा दास ठीक ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","कऊँकि आऊँ बी पराधीन मांणू ए और सिपाई मेरे आथो रे ए। जेबे एकी खे बोलूँआ, ‘जा,’ तो से जाओआ और दूजे खे बोलूँ, ‘आओ,’ तो से आओआ। आपणे दासा खे बोलूँ, ‘ये कर,’ तो से करोए।” ");
INSERT INTO bfz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ये सुणी की यीशु हैरान ऊईगे और जो तिना पीछे आऊणे लगी रे थे, तिने तिना खे बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि मैं इस्राएलो रे बी एड़ा विश्वास नि देखेया। ");
INSERT INTO bfz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","आऊँ तुसा खे बोलूँआ कि बऊत सारे दूजिया जातिया रे लोक पूर्वो और पच्छमो ते आयी की अब्राहम, इसहाक और याकूबो साथे स्वर्गो रे राज्य रे रोटी खाणे बैठणे। ");
INSERT INTO bfz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पर बऊत सारे इस्राएली जिना खे स्वर्गो रा राज्य त्यार कित्तेया राए, बारे न्हेरे रे पाई देणा, तेती रोणा और दाँदा रा किरड़ना ई ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","तेबे यीशुए सूबेदारो खे बोलेया, “कअरे जा, जेड़ा तेरा विश्वास ए, तेड़ा ई ताखे ओ।” और तेबुई तेसरा दास ठीक ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","जेबे यीशु पतरसो रे कअरे आए, तो तिने पतरसो री सासु बुखारो साथे पड़ी री देखी। ");
INSERT INTO bfz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","तिने तेसा रा आथ छूँयां और तेसा रा बुखार उतरी गा। तेबे से उठी की तिना री सेवा करने लगी। ");
INSERT INTO bfz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","जेबे साँज ऊई, तेबे सेयो बऊत लोका खे यीशुए गे ल्याए, जिना रे दुष्टात्मा थिया और तिने दुष्टात्मा आपणे वचनो साथे निकयाल़िया और सब बमार ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ताकि जो वचन यशायाह भविष्यबक्ते बोलेया था से पूरा ओ “तिने आपू ई म्हारिया कमजोरिया लयी लिया और म्हारिया बमारिया चकी तिया।” ");
INSERT INTO bfz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीशुए जेबे आपणे चऊँ कनारे लोका री एक बड़ी पीड़ देखी, तो तिने आपणे चेलेया खे गलीली समुद्रो ते पार जाणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","तेबे एक शास्त्रिए तिना गे नेड़े आयी की बोलेया, “ओ गुरू! जेती केथी तुसे जाओगे, मां तुसा पीछे-पीछे चली पड़ना।” ");
INSERT INTO bfz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीशुए तेसखे बोलेया, “गीदड़िया रे डवार और सर्गो रे पंछिया रे बसेरे ओए, पर मां माणूं रे पुत्रो खे सिर राखणे खे बी आपणा कअर निए।” ");
INSERT INTO bfz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","एक और चेले तिना खे बोलेया, “ओ प्रभु! पईले माखे जाणे दे कि आऊँ आपणे पिते खे दबाई आऊँआ। तेबे तां पीछे चली पड़ुँगा।” ");
INSERT INTO bfz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीशुए तेसखे बोलेया, “तूँ मां पीछे आईजा, और जो आत्मिक रूपो रे मरे रे ए तिना खे आपणे मुड़दे दबाणे दे।” ");
INSERT INTO bfz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जेबे यीशु किस्तिया रे चढ़े, तो तिना रे चेले तिना पीछे आईगे। ");
INSERT INTO bfz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","तेबे देखो, समुद्रो रे बऊत बड़ा तूफान आया जेते की किस्ती पाणिए साथे टखी गी और यीशु सये रे थे। ");
INSERT INTO bfz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तेबे चेलेया नेड़े आयी की यीशु जगाए और तिना खे बोलेया, “ओ प्रभु! आसा खे बचा, आसे डूबणे वाल़े ए।” ");
INSERT INTO bfz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","यीशुए आपणे चेलेया खे बोलेया, “ओ कम विश्वास करने वाल़ेयो! कऊँ डरोए?” तेबे यीशु उठे और तूफान और पाणिए खे बकणे लगे और तेबे सब शान्त ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","तेबे लोक हैरान ऊई की बोलणे लगे, “ये केड़ा मांणूए? तूफान और पाणी बी एसरी आज्ञा खे मानोए।” ");
INSERT INTO bfz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जेबे सेयो पार गदरेनिया रे देशो रे पऊँछे, तेबे दो मांणू जिना रे दुष्टात्मा थिया कब्रा ते निकल़दे ऊए तिना खे मिले। सेयो इतणे प्रचण्ड थे कि कोई बी तेसा बाटा रिये जाई नि सको था। ");
INSERT INTO bfz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","तेबे तिने चींगी की बोलेया, “ओ परमेशरो रे पुत्र! आसा रा तां साथे क्या काम? क्या तूँ बखतो ते पइले ई आसा खे एती दु:ख देणे आयी रा?” ");
INSERT INTO bfz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","तिना ते थोड़ी जी दूर सूंअरो रा एक चूण्ड चरने लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","दुष्टात्मे तिना ते ये बोली की बिनती कित्ती, “जे तूँ आसा खे निकयाल़ने ई लगी रा तो सूंअरा रे चूण्डो रे पेजी दे।” ");
INSERT INTO bfz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","तिने तिना खे बोलेया, “जाओ!” सेयो निकल़ी की सूंअरा रे बैठी गिया और सारा चूण्ड काअड़ी ते छवाल़ लयी की डूबी गा और मरी गा। ");
INSERT INTO bfz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","तिना खे चराणे वाल़े नठे और नगरो रे गए और जिना रे दुष्टात्मा थिया तिना रा सारा आल सुणाया। ");
INSERT INTO bfz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","तेबे सारे नगरो रे लोक यीशुए खे मिलणे आए, और तिना खे देखी की बिनती कित्ती कि म्हारे बन्ने ते निकल़ी जाओ। ");
INSERT INTO bfz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","तेबे यीशु किस्तिया रे चढ़ी की पार गए, और आपणे नगरो खे आए। ");
INSERT INTO bfz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","तेबे यीशुए देखेया, कई लोक एक अदरंगो रे रोगिए खे माँजे पाँदे चकी की तिना गे ल्याए, यीशुए तेसरा विश्वास देखेया और तेस अदरंगो रे रोगिए खे बोलेया, “ओ पाऊआ! याओ राख; तेरे पाप माफ ऊईगे।” ");
INSERT INTO bfz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","तेबे कई शास्त्रिए सोचेया, “ये तो परमेशरो री निन्दा करने लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीशुए तिना रे मनो री गल्ल जाणी की तिना खे बोलेया, “तुसे आपणे मनो रे बुरा बिचार कऊँ करने लगी रे? ");
INSERT INTO bfz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ये बोलणा बऊत आसान ए कि, ‘तेरे पाप माफ ऊईगे’, पर ये बोलणा बऊत कठण ए कि, ‘आपणा मांजा चकी की चल फिर।’ ");
INSERT INTO bfz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पर इजी री खातर कि तुसे जाणी लओ कि मां माणूं रे पुत्रो खे तरतिया पाँदे पाप माफ करने रा बी अक्क ए।” यीशुए तेस अदरंगो रे रोगिए खे बोलेया, “उठ, आपणा मांजा चक और आपणे कअरो खे चली जा।” ");
INSERT INTO bfz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","से उठी की आपणे कअरो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","लोक ये देखी की डरी गे और परमेशरो री महिमा लगे करने, जिने मांणूआ खे एड़ा अक्क देई राखेया। ");
INSERT INTO bfz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","तेथा ते आगे चली की यीशुए मत्ती नाओं रा एक मांणू करो री चौकिया पाँदे बैठेया रा देखेया और तिने तेसखे बोलेया, “मां पीछे आओ।” से उठेया और तिना पीछे चली पड़ेया। ");
INSERT INTO bfz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","जेबे यीशु कअरे रोटी खाणे बैठेया, तेबे बऊत जणे कर लणे वाल़े और पापी आयी की यीशु और तिना रे चेलेया साथे रोटी खाणे बैठे। ");
INSERT INTO bfz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ये देखी कि फरीसिये तिना रे चेलेया खे बोलेया, “तुसा रा गुरू इना कर लणे वाल़े और पापिया साथे रोटी खाणे कऊँ बैठी रा।” ");
INSERT INTO bfz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","यीशुए ये सुणी की तिना खे बोलेया, “बैद बमारा खे चाईयो, पलेया-चंगेया खे नि। ");
INSERT INTO bfz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","तो तुसे जाओ और इजी रा मतलब जाणी लओ कि, ‘आऊँ बलिदान नि, पर दया चाऊँआ।’ कऊँकि आऊँ तर्मिया खे नि, पर पापिया खे बुलाणे आयी रा।” ");
INSERT INTO bfz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","तेबे बपतिस्मा देणे वाल़े यूहन्ने रे चेलेया तिना गे आयी की बोलेया, “क्या बजअ ए कि आसे और फरीसी इतणे बअरत करूँए और तेरे चेले बअरत नि करदे?” ");
INSERT INTO bfz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीशुए तिना खे बोलेया, “क्या बराती, जदुओ तक लाड़ा तिना साथे ए, तदुओ तक शोग मनाई सको ए? पर सेयो दिन आऊणे, जेबे लाड़ा बरातिया ते लग करेया जाणा, तेस बखते तिना बअरत करना। ");
INSERT INTO bfz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","नये टाले री टाली, पुराणे टालेया रे कोई नि लगांदा, कऊँकि टाली पुराणे टालेया खे ओर बी कट्ठा करी देओ ई, मतलब-नया टाला पुराणे साथे ओर बी जादा फटी जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","नया अँगूरा रा रस पुराणे खल्लड़ुआ रे कोई नि परदा। कऊँकि एड़ा करने ते खल्लड़ु फटी जाओए और अँगूरा रा रस बारे निकल़ी जाओआ और खल्लड़ु नाश ऊई जाओ। पर जे नया अँगूरा रा रस नये खल्लड़ुआ रे परो तो दोनो बचे रे रओए।” ");
INSERT INTO bfz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","जेबे यीशु इना गल्ला तिना खे बोलणे ई लगी रे थे, तेबे एक अधिकारी तिना गे आया और तिना गे माथा टेकेया और बोलेया, “मेरी बेटी एबु-एबु मरी गी, पर जे तुसे चलो और आपणा आथ राखो तो से जिऊँदी ऊई जाणी।” ");
INSERT INTO bfz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीशु उठे और आपणे चेलेया लयी की तेस पीछे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","तेबे एक जवाणस आयी, तेसा खे बारा साला ते खून बइणे री बमारी थी, से पीछे ते आयी और तेसे यीशुए रे टालेया रा कनारा छूँयां। ");
INSERT INTO bfz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","कऊँकि से आपणे मनो रे बोलो थी, “जे आऊँ तिना रे टाले ई छुँईं लऊँगी, तो ठीक ऊई जाणी।” ");
INSERT INTO bfz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीशुए तेसा खे मुड़ी की बोलेया, “बेटिये! याओ राख, तेरे विश्वासे तूँ बचाईती।” तेबे से जवाणस तेबुई ठीक ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जेबे यीशु तेस अधिकारिए रे कअरे पऊँछे, तेबे तिने बांसल़ी बजाणे वाल़े और पीड़ आल्ला-गोल्ला करदे ऊए देखी। ");
INSERT INTO bfz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तेबे यीशुए बोलेया, “आटी जाओ, मुन्नी मरी नि रई, पर सऊणे लगी री।” ये सुणी की सेयो तिना रा मजाक लगे ऊड़ाणे। ");
INSERT INTO bfz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पर जेबे पीड़ तेथा निकयाल़ी ती, तेबे तिने पीतरे जाई की तेसा मुन्निया रा आथ पकड़ेया और से ठीक ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","तेबे ये गल्ल पूरे देशो रे फैली गी। ");
INSERT INTO bfz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जेबे यीशु तेथा ते आगे गए, तेबे दो अन्दे तिना पीछे ये बोली की आक्का लगे पाणे, “ओ दाऊदो री ल्वाद! आसा पाँदे दया कर।” ");
INSERT INTO bfz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जेबे सेयो कअरे पऊँछे, तेबे सेयो दो अन्दे तिना गे आए, तेबे यीशुए तिना खे बोलेया, “क्या तुसा खे विश्वास ए कि आऊँ तुसा खे ठीक करी सकूँआ?” तिने बोलेया, “आ प्रभु।” ");
INSERT INTO bfz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तेबे यीशुए तिना रिया आखिया छुँईं की तिना खे बोलेया, “तुसा रे विश्वासो रे मुताबिक तुसा साथे ओ।” ");
INSERT INTO bfz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","और सेयो तेबुई देखणे लगे। यीशुए तिना खे सावधान करदे ऊए बोलेया, “देखो! कोई बी एसा गल्ला खे नि जाणो।” ");
INSERT INTO bfz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पर तिने बारे निकल़ी की तिना रा यश सारे देशो रे फैलाई ता। ");
INSERT INTO bfz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जेबे सेयो बारे लगी रे थे जाणे, तेबे लोक एक गूँगे खे जेसरे दुष्टात्मा थी, यीशुए गे ल्याए। ");
INSERT INTO bfz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","जेबे यीशुए दुष्टात्मा निकयाल़ी ती, तेबे गूँगा बोलणे लगेया और लोके हैरान ऊई की बोलेया, “इस्राएलो रे एड़ा कदी नि देखेया।” ");
INSERT INTO bfz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पर फरीसिये बोलेया, “ये तो दुष्टात्मा रे सरदारो री मतादा ते दुष्टात्मा खे निकयाल़ोआ।” ");
INSERT INTO bfz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीशु और तिना रे चेले गलील प्रदेशो रे कई नगर और कई गांव रे कूमदे रए और तिना रे प्रार्थना रे कअरो रे उपदेश देंदे रए और परमेशरो रे राज्य रा सुसमाचार प्रचार करदे रए और हर बमारी और कमजोरी दूर करदे रए। ");
INSERT INTO bfz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जेबे तिने पीड़ देखी तो तिना खे लोका पाँदे तरस आया, कऊँकि सेयो तिना पेडा जेड़े, जिना रा कोई रखवाल़ा नि ऊँदा, बेचैन और पटके ऊए रे थे। ");
INSERT INTO bfz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तेबे यीशुए आपणे चेलेया खे बोलेया, “पाक्के रे डोरू तो बऊत ए, पर मजूरदार कम ए। ");
INSERT INTO bfz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","इजी री खातर डोरूआ रे मालको ते प्रार्थना करो कि सेयो आपणे डोरूआ बडाणे खे मजूरदार पेजो।” ");
INSERT INTO bfz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","तेबे यीशुए आपणे बारा चेले बुलाए और तिना खे दुष्टात्मा पाँदे अक्क दित्तेया कि हर बमारिया खे निकयाल़ो और हर कमजोरिया खे दूर करो। ");
INSERT INTO bfz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","इना बारा प्रेरिता रे नाओं यो ए-पईला शमौन, जेसखे पतरस बी बोलोए, और तेसरा पाई अन्द्रियास, जब्दियो रा पाऊ याकूब और तेसरा पाई यूहन्ना। ");
INSERT INTO bfz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस, बरतुल्मै थोमा, कर लणे वाल़ा मत्ती, हलफईसो रा पाऊ याकूब और तद्दै। ");
INSERT INTO bfz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","शमौन कनानी, यहूदा इस्करियोती, जिने सेयो पकड़वाए बी थे। ");
INSERT INTO bfz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","यो बारा जणे यीशुए ये आज्ञा देई की पेजे कि ओरी जातिया बीचे नि जाणा, “ना ई सामरिया रे केसी बी देशो रे जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","पर इस्राएलो रे कराने री राची रिया पेडा गे ई जाणा ");
INSERT INTO bfz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","और चलदे-चलदे ये प्रचार करो कि स्वर्गो रा राज्य नेड़े आईगा रा। ");
INSERT INTO bfz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बमारा खे ठीक करो, मरेया रे खे जिऊँदा करो, कोढ़िया खे शुद्ध करो, दुष्टात्मा खे निकयाल़ो, तुसे मुफ्त पाई राखेया और मुफ्त ई देओ। ");
INSERT INTO bfz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","आपणी गाठड़िया रे ना सुईना, ना रूपा और ना तांबा राखणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","बाटा खे ना चोल़ा, ना दो कुरते, ना जोड़े और ना ई सोठा लओ, कऊँकि मजूरदारो खे तेसरी रोटी तो मिलणी ई चाईयो। ");
INSERT INTO bfz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“तुसे जेते बी गांव या नगरो रे जाओ तो पता लगाओ कि कुण खरा ए? और जदुओ तक तेथा ते नि निकल़ो, तेसगे ई रओ। ");
INSERT INTO bfz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","जेबे तुसे तेसरे कअरे जाओ तो तेसखे आशीष देणी। ");
INSERT INTO bfz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","जे तेस कअरो रे मांणू खरे ओगे तो तुसा रा कल्याण तिना गे पऊँछणा, पर सेयो खरे नि ओगे तो तुसा रा कल्याण तुसा गे वापस आयी जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जो कोई तुसा खे मानोगा नि और तुसा री गल्ला नि सुणो, तो तेस कअरो या नगरो ते निकल़दे ऊए आपणे पैरा री तूड़ तेथी चाड़ी देयो। ");
INSERT INTO bfz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","आऊँ तुसा खे सच बोलूँआ कि जेबे न्याय रा दिन आऊणा, तेबे तेस नगरो री दशा ते, सदोम और गमोरा रे देशो री दशा जादा सईणे जोगी ऊणी।” ");
INSERT INTO bfz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","और यीशुए बोलेया, “देखो, आऊँ तुसा खे पेडा जेड़े तिना लोका बीचे पेजुँआ जो भेड़िए जेड़े खतरनाक ए, तो तुसे सापो जेड़े अक्लमंद और कबूतरो जेड़े शरीफ रओ बणे रे। ");
INSERT INTO bfz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","पर लोका ते चौकस रओ, कऊँकि तिना तुसे पंचायती रे देई देणे और आपणी प्रार्थना रे कअरो रे तुसा खे कोड़े बाणे। ");
INSERT INTO bfz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तुसे मेरी तंईं हाकिमो और राजेया रे सामणे तिना पाँदे और दूजी जातिया पाँदे गवा ऊणे खे पऊँछाए जाणे। ");
INSERT INTO bfz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जेबे सेयो तुसा खे पकड़वाओगे, तेबे ये चिन्ता नि करनी कि आसा किंयाँ और क्या करना, कऊँकि जो बी तुसा बोलणा ओगा, से तुसा खे तेस बखते ई बताई देणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","कऊँकि बोलणे वाल़े तुसे नि, पर तुसा रे पिते रा पवित्र आत्मा तुसा रे बोलोआ। ");
INSERT INTO bfz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“पाईया आपणे पाई और पितेया आपणे पाऊ कुल़वाणे खे पकड़वाणे और बच्चे आपणे माया-बाओ रे खलाफ उठणे और तिना सेयो कुल़ाई देणे। ");
INSERT INTO bfz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मेरे नाओं री बजअ ते सबी लोका तुसा ते बैर राखणा, पर जो आखरी तक सब्र राखोगा, तेसरा ई उद्धार ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जेबे सेयो तुसा खे एकी जगा रे सताओगे, तो तुसे दूजी जगा खे नठी जाणा। आऊँ तुसा खे सच लगी रा बोलणे कि तुसे इस्राएलो रे सारे देशो रे कूमी नि चुकणे कि तदुओ खे माणूं रा पुत्र आयी जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“चेला आपणे गुरूओ ते बड़ा नि ऊँदा; ना दास आपणे मालको ते। ");
INSERT INTO bfz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेले रा गुरूओ रे और दासो रा मालको रे बराबर ऊणा ई बऊत ए; जेबे तिने कअरो रे मालको खे शैतान बोलेया, तो तेसरे कअरो वाल़ेया खे क्या कुछ नि बोलणा? ");
INSERT INTO bfz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“इजी री खातर मांणूआ ते नि डरो, कऊँकि कुछ बी टकेया रा निए, जो खोलेया नि जाणा और ना कुछ छिपेया राए, जो जाणी नि सकदे। ");
INSERT INTO bfz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","जो आऊँ तुसा खे न्हेरे रे बोलूँआ, तिजी खे तुसे लोका बीचे दिनो रे बखते सबी रे सामणे खुली की बोलेया करो और जो आपणे कानो रे खसफस करोए, तेस छतो पाँदो ते बोलेया करो। ");
INSERT INTO bfz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","जो शरीरो खे काई सकोए, पर आत्मा खे काई नि सकदे, तिना ते नि डरो, पर परमेशरो तेई डरो, जो आत्मा और शरीर दूँईं खे नरको रे नाश करी सकोआ। ");
INSERT INTO bfz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","एकी पैसे साथे दो चिड़िया बिकोईया? तेबे बी तुसा रे पिते री इच्छा ते बिना तिना बीचा ते एक बी जमीना रे नि पड़ी सकदी। ");
INSERT INTO bfz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","तुसा रे सिरो रे बाल़ बी सारे गिणे रे ए। ");
INSERT INTO bfz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","इजी री खातर डरो नि; तुसे मुखती चिड़िया ते बी बढ़ी की ए। ");
INSERT INTO bfz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जो कोई मांणूआ सामणे माखे मानी लओगा, से मां बी आपणे स्वर्गिय पिते सामणे मानी लणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पर जो कोई मांणूआ सामणे माखे नि मानोगा, तो मां बी से स्वर्गिय पिते सामणे नि मानणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ये नि समजो कि आऊँ तरतिया पाँदे मेल-जोल करने आयी रा, आऊँ मेल-जोल करने नि, पर तलवार चलवाणे आयी रा। ");
INSERT INTO bfz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","आऊँ तो आयी इजी खे रया कि ‘मांणूए खे तेसरे पिते ते और बेटिया खे तेसा री माया ते और बऊआ खे तेसा री सासुआ ते लग करुँ। ");
INSERT INTO bfz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","मांणूए रे बैरी तेसरे कअरो रेई लोक ऊणे।’ ");
INSERT INTO bfz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जो माया-बावा खे मांते जादा प्यार करोआ, से मेरे लायक निए और जो माठे-बेटिया खे मांते जादा प्यार करोआ, से बी मेरे लायक निए। ");
INSERT INTO bfz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","जे तुसे मेरे चेले बणना चाओए, पर मेरिया तंईं मरने खे त्यार निए, तो तुसे मेरे लायक निए। ");
INSERT INTO bfz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जो आपणे प्राण बचाओआ, तेस से खोणा और जो मेरी बजअ ते आपणे प्राण खोओआ, तेस अनन्त जिन्दगी पाणी। ");
INSERT INTO bfz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जो तुसा खे मानोआ, से माखे मानोआ और जो माखे मानोआ, से मेरे पेजणे वाल़े खे मानोआ। ");
INSERT INTO bfz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जो भविष्यबक्ते खे भविष्यबक्ता जाणी की ग्रहण करोआ, तेस भविष्यबक्ते जेड़ा ईनाम पाणा और जो तर्मिंयों खे तर्मी जाणी की ग्रहण करो, तेस तर्मिंयों जेड़ा ईनाम पाणा। ");
INSERT INTO bfz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जो कोई इना छोटेया बीचा ते एकी खे बी मेरा चेला जाणी की बस एक ठण्डे पाणिए रा कटोरा पल़याओगा, आऊँ तुसा खे सच लगी रा बोलणे, तेस किंयाँ बी आपणा प्रतिफल नि खोणा।” ");
INSERT INTO bfz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","जेबे यीशु आपणे बारा चेलेया खे आज्ञा देई चुके, तेबे सेयो तिना रे नगरो रे उपदेश और प्रचार करने खे तेथा ते चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","यूहन्ने जेला रे मसीह रे कामो रा प्रचार सुणी की आपणे चेले तिना ते ये पूछणे पेजे, ");
INSERT INTO bfz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“क्या आऊणे वाल़े मसीह जेते रा वादा परमेशरे करी राखेया से तुसे ईए, या आसे केसी दूजे री बाट देखूँ?” ");
INSERT INTO bfz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीशुए जवाब दित्तेया, “जो कुछ तुसे सुणोए और देखोए, से सब जाई की यूहन्ने खे बताओ ");
INSERT INTO bfz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","कि अन्दे देखोए, लंगड़े चलोए, कोढ़ी शुद्ध ऊई जाओए, टऊणे सुणोए, मुड़दे जिऊँदे ऊई जाओए और कंगाल़ा खे सुसमाचार सुणाया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","धन्य ए सेयो, जो मेरी बजअ ते आपणा विश्वास नि छाडदे।” ");
INSERT INTO bfz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जेबे यूहन्ना रे चेले तेथा ते चली गे, तेबे यीशु यूहन्ने रे बारे रे लोका खे बताणे लगे, “तुसे जंगल़ो रे क्या देखणे गए थे? क्या अवा साथे ईलदे ऊए काओ जेड़े नगल़ो खे? ");
INSERT INTO bfz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","तेबे तुसे क्या देखणे गए थे? क्या तेस मांणूए खे, जिने नरम टाले थे पईने रे? देखो, जो नरम टाले पईनोए, सेयो राजभवनो रे रओए। ");
INSERT INTO bfz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","तेबे तुसे कऊँ गए थे? क्या केसी भविष्यबक्ते खे देखणे? आ, आऊँ तुसा खे बोलूँआ कि तुसे तो भविष्यबक्ते ते बी बड़े खे देखणे गए थे। ");
INSERT INTO bfz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ये सेईए, जेसरे बारे रे पवित्र शास्त्रो रे लिखी राखेया कि “ ‘देख, आऊँ आपणे दूतो खे तांते आगे-आगे पेजुँआ, जेस तांते आगे जाई की तेरी बाट त्यार करनी।’ ");
INSERT INTO bfz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“आऊँ तुसा खे सच लगी रा बोलणे कि जो जवाणसा ते जम्मी रे, तिना बीचा ते यूहन्ना बपतिस्मा देणे वाल़े ते, कोई बी बड़ा नि ऊआ, पर जो स्वर्गो रे राज्य रे छोटे ते छोटा ए से तेसते बड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","यूहन्ना बपतिस्मा देणे वाल़े रे दिना ते लयी की एबुए तक स्वर्गो रे राज्य रे बलपूर्वक प्रवेश ऊँदा रया, पर तागतबर तेसखे जबरदस्ती छुड़ाई लओए। ");
INSERT INTO bfz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","यूहन्ना बपतिस्मा देणे वाल़े तक सारे भविष्यबक्ता और बिधान भविष्यबाणी करदे रए। ");
INSERT INTO bfz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","जे चाओ, तो मानो कि एलिय्याह जो आऊणे वाल़ा था, से येईए। ");
INSERT INTO bfz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जो समजी सकोआ से तिजी खे त्यानो साथे सुणो और मानी बी लओ। ");
INSERT INTO bfz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“आऊँ आजकाल के लोका री उपमा किजी साथे करुँ? सेयो तिना बच्चेया जेड़े ए, जो बजारो रे बैठी की एकी-दूजे खे आक्का पाई की बोलोए ");
INSERT INTO bfz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","कि आसे तुसा खे बांसल़ी बजाई, पर तुसे नि नाचे; आसे शोग कित्तेया, पर तुसे छाती नि बजाई। ");
INSERT INTO bfz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","कऊँकि यूहन्ना ना खांदा आया और ना पींदा आया और सेयो बोलोए, ‘तेसरे दुष्टात्मा ए।’ ");
INSERT INTO bfz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","पर आँऊ माणूं रा पुत्र खांदा-पींदा ऊआ आया और सेयो बोलोए कि देखो, पेटू और पियक्कड़ मांणू, कर लणे वाल़ेया रा और पापिया रा दोस्त ए, पर ज्ञान आपणे कामो की सच्चा ठराई राखेया।” ");
INSERT INTO bfz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तेबे यीशु तिना रे लोका नगरा खे ल़वामे देणे लगेया, जिना बीचे तिने बऊत सामर्था रे काम कित्ते थे, कऊँकि तिने आपणा मन नि था फेरेया रा। ");
INSERT INTO bfz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“हाय खुराजीन! हाय बैतसैदा! जो सामर्था रे काम तुसा रे कित्ते, जे सेयो सूर और सैदा रे नगरा रे ऊँदे, तो टाटा रे शोको रे टाल्ले पईनी की और आपू दे स्वा मल़ी की और दुःखी ऊई की सेयो कदका मन फिराई देंदे। ");
INSERT INTO bfz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","पर आऊँ तुसा खे बोलूँआ कि जेबे न्याय रा दिन ऊणा, तेबे तुसा री दशा ते, सूर और सैदा नगरो री दशा जादा सईणे जोगी ऊणी। ");
INSERT INTO bfz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ओ कफरनहूम! क्या तूँ स्वर्गो तक ऊच्चा करेया जाणा? तूँ तो नरको तक थाले करेया जाणा। जो सामर्था रे काम तांदे ऊए, जे सेयो काम, सदोम नगरो रे ऊँदे, तो से आजो तक बणेया रा रणा था। ");
INSERT INTO bfz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पर आऊँ तुसा खे बोलूँआ कि जेबे न्याय रा दिन आऊणा तेबे, तेरी दशा ते सदोमो रे नगरो री दशा जादा सईणे जोगी ऊणी।” ");
INSERT INTO bfz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","तेस ई बखते यीशुए बोलेया, “ओ पिता! स्वर्ग और तरतिया रे प्रभु! आऊँ तुसा रा धन्यवाद करूँआ कि तुसे यो गल्ला ज्ञानी और समजदारा ते लकोई रिया राखिया और बाल़का गे बताईया। ओ पिता! कऊँकि तुसा खे येई खरा लगेया।” ");
INSERT INTO bfz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","आ, ओ पिता! कऊँकि तुसा खे येई खरा लगेया। ");
INSERT INTO bfz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“मेरे पिते मांगे सब कुछ संबाल़ी राखेया। कोई पुत्रो खे नि जाणदा, बस पिता जाणोआ। कोई पिते खे नि जाणदा, बस पुत्र जाणोआ और से, जेस पाँदे पुत्र तिजी खे प्रगट करना चाओ। ");
INSERT INTO bfz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ओ सब मईणत करने वाल़ेयो! और बोजे की दबे रे लोको, मांगे आओ, मां तुसा खे आराम देणा। ");
INSERT INTO bfz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","“मेरे चेले बणो और मेरी गल्ल मानेया करो कऊँकि आऊँ नम्र और मनो ते दीन ए, और तेबे तुसा आपणे मनो रे आराम पाणा। ");
INSERT INTO bfz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","कऊँकि मेरा काम आसान ए और बोज अल़का ए।” ");
INSERT INTO bfz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","तेस बखते यीशु आरामो रे दिने डोरूआ रिये जाणे लगी रे थे। जेबे तिना रे चेलेया के पूख लगी, तेबे सेयो सिल्ले तोड़ी-तोड़ी की खाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","तेबे फरीसिये तिना खे देखी की यीशुए खे बोलेया, “देख, तेरे चेले से काम लगी रे करने, जो आरामो रे दिने करना ठीक निए।” ");
INSERT INTO bfz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","यीशुए तिना खे बोलेया, “क्या तुसे पढ़ी नि राखेया कि जेबे दाऊद और तेसरे साथिया खे पूख लगी, तो तिने क्या कित्तेया? ");
INSERT INTO bfz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","सेयो किंयाँ परमेशरो रे भवनो रे गये और तिने पेंटा रिया रोटिया खाईया, जबकि बिधानो रे मुताबिक तिना, ना तो से और ना तेसरे साथी खाई सको थे, पर पुरोईत ई खाई सको थे। ");
INSERT INTO bfz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","क्या तुसे बिधानो रे नि पढ़ेया कि पुरोईत आरामो रे दिनो रे मन्दरो रे नियम तोड़ने रे बी निर्दोष ठईरो थे? ");
INSERT INTO bfz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पर आऊँ तुसा खे बोलूँए कि ऐती से ए, जो मन्दरो ते बी बड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","जे तुसे एतेरा मतलब जाणदे कि, ‘आऊँ कृपा ते खुश ए,’ बलिदानो ते नि, तो तुसे निर्दोषो खे दोषी नि ठरांदे। ");
INSERT INTO bfz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","आँऊ माणूं रा पुत्र आरामो रे दिनो रा बी प्रभु ए।” ");
INSERT INTO bfz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","तेथा ते चली की सेयो तिना रे प्रार्थना रे कअरो रे आए। ");
INSERT INTO bfz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","तेती एक मांणू था, जेसरा आथ सूकेया रा था। तिने यीशुए पाँदे दोष लगाणे रिया तंईं तिना ते पूछेया, “क्या आरामो रे दिने चंगा करना ठीक ए?” ");
INSERT INTO bfz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","यीशुए तिना खे बोलेया, “तुसा बीचा ते एड़ा कूणे, जेसगे एक ई पेड ओ और से आरामो रे दिने गड्डे रे पड़ी जाओ और से तेसा खे नि निकयाल़ो? ");
INSERT INTO bfz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","पला, मांणूए री कीमत तो पेडा ते कितणी बड़ी की ए। इजी री खातर बिधानो रे मुताबिक आरामो रे दिने पला करना ठीक ए।” ");
INSERT INTO bfz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तेबे यीशुए तेस मांणूए खे बोलेया, “आपणा आथ आगे कर” तिने आगे कित्तेया, तेबे तेसरा आथ दूजे आथो जेड़ा ठीक ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","तेबे फरीसिये बारे जाई की यीशुए रे खलाफ योजना बणाई कि तिना खे किंयाँ बर्बाद करिए। ");
INSERT INTO bfz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ये जाणी की यीशु तेथा ते चली गे और बऊत जणे तिना पीछे आईगे और यीशुए सबी खे चंगाई दित्ती। ");
INSERT INTO bfz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","तेबे यीशुए सेयो सावधान कित्ते कि मेरे बारे रे केसी गे नि बताणा, “आँऊ परमेशरो रा पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ताकि जो वचन यशायाह भविष्यबक्ते बोलेया था, से पूरा ओ; ");
INSERT INTO bfz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“देखो, ये मेरा सेवक ए, जो मैं चूणी राखेया। मेरा प्यारा, जेसते मेरा मन खुश ए, मां आपणा पवित्र आत्मा तेसरे पाणा; और तेस अन्य जातिया खे न्याय रा सुसमाचार देणा। ");
INSERT INTO bfz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","तेस ना चगड़ा करना, ना चिल्लाणा, और ना ई केसी बजारो रे तेसरी आवाज सुणनी। ");
INSERT INTO bfz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","जो लोक बेसहारा ए, तेस तिना साथे नरमाईया ते पेश आऊणा। तेस सेयो मरने नि देणे और तिना रा न्याय करना, जदुओ तक तिना खे निर्दोष नि ठराई देओ। ");
INSERT INTO bfz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","जो दुजिया जातिया ऊणिया तिना खे तेसरे नाओं पाँदे उम्मीद रणी।” ");
INSERT INTO bfz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तेबे लोक एक मांणूए खे तिना गे ल्याए, जो अन्दा और गूँगा था, तिने से ठीक कित्तेया और से देखणे और बोलणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ये देखी की लोक हैरान ऊई की बोलणे लगे, “क्या ये दाऊदो री ल्वाद ए?” ");
INSERT INTO bfz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","पर फरीसिये ये सुणी की बोलेया, “ये तो दुष्टात्मा रे सरदार शैतानो री मतादा ते दुष्टात्मा खे निकयाल़ोआ।” ");
INSERT INTO bfz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","यीशुए तिना रे मनो री गल्ल जाणी ली और तिना खे बोलेया, “जेस बी राज्य रे फूट ओई, से ऊजड़ी जाओआ, और कोई बी नगर या कराना, जिदे फूट ओई, से कदी नि बसी सकदा। ");
INSERT INTO bfz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","और जे शैतान ई शैतानो खे लगेया निकयाल़ने, तो से तो आपणा ई बिरोदी ऊईगा। तेबे तेसरा राज्य किंयाँ बणेया रा रणा? ");
INSERT INTO bfz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","जे आऊँ शैतानो री मतादा ते दुष्टात्मा खे निकयाल़ूँआ, तो तुसा रे वंश केसरी मतादा ते निकयाल़ोए? बस, तेबे सेयो ई तुसा रा न्याय करोगे। ");
INSERT INTO bfz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","पर जे आऊँ परमेशरो री पवित्र आत्मा री मतादा ते दुष्टात्मा खे निकयाल़ूँआ, तो परमेशरो रा राज्य तुसा गे आईगा रा। ");
INSERT INTO bfz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“या किंयाँ कोई मांणू केसी तागतबरो रे कअरे कूसी की तेसरा माल लूटी सकोआ, जदुओ तक से तेसखे बानी नि लओगे? तेबेई से तेसरा माल लूटी सकोआ। ");
INSERT INTO bfz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जो मां साथे निए, से मेरे खलाफ ए और जो मां साथे कट्ठा नि करदा, से बखेरोआ। ");
INSERT INTO bfz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","इजी री खातर आऊँ तुसा खे बोलूँआ कि मांणूए रे सारे पाप और निन्दा माफ ऊई जाणे, पर पवित्र आत्मा री निन्दा माफ नि ऊणी। ");
INSERT INTO bfz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जो कोई मां माणूं रे पुत्रो रे खलाफ कोई बी गल्ल बोलोगा, तेसरा ये अपराध माफ ऊई जाणा। पर जो कोई पवित्र आत्मा रे खलाफ कुछ बी बोलोगा, तेसरा अपराध ना तो एते लोको रे और ना ई परलोको रे माफ ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“जे डाल़ो खे अच्छा बोलो, तो तिजी रे फलो खे बी अच्छा बोलो। या डाल़ो खे नकम्मा बोलो, तो तिजी रे फलो खे बी नकम्मा ई बोलो; कऊँकि डाल़ आपणे फल़ो साथे ई पछयाणा जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ओ सापो जेड़े जईरीले लोको! तुसे बुरे ऊई की किंयाँ खरिया गल्ला बोली सकोए? कऊँकि जो तुसा रे मनो रे ओआ, सेई तुसा री जबानी पाँदे आओआ। ");
INSERT INTO bfz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","खरा मांणू आपणे खरे मनो रे पण्डारो ते खरिया गल्ला निकयाल़ोआ और बुरा मांणू आपणे बुरे मनो रे पण्डारो ते बुरिया गल्ला निकयाल़ोआ। ");
INSERT INTO bfz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","आऊँ तुसा खे बोलूँआ कि जो-जो नकम्मिया गल्ला मांणूआ बोलणिया, जेबे न्याय रा दिन आऊणा, तेबे तिना खे हर गल्ला रा लेखा देणा पड़ना। ");
INSERT INTO bfz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","कऊँकि तूँ आपणिया गल्ला तेई, दोषी और निर्दोष ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ये सुणी की कुछ शास्त्रिए और कुछ फरीसिये तिना खे बोलेया, “ओ गुरू! आसे तुसा ते एक चिह्न देखणा चाऊँए।” ");
INSERT INTO bfz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","यीशुए तिना खे जवाब दित्तेया, “एते जुगो रे बुरे और व्याभिचारी लोक चिह्न टोल़ोए; पर, योना भविष्यबक्ते रे चिह्नो खे छाडी की कोई ओर चिह्न् तिना खे नि देणा। ");
INSERT INTO bfz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","योना, तीन रात-दिन पाणिए रे बड़ी मच्छल़िया रे पेटो रे रया, तिंयाँ ई आँऊ माणूं रा पुत्र, तीन रात-दिन तरतिया ते पीतरे रणा। ");
INSERT INTO bfz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नीनवे रे लोक न्याय रे दिनो दे, एस बखतो रे लोका साथे उठणे, और तिना सेयो ई दोषी ठराणे, कऊँकि तिने योने रा प्रचार सुणी की मन फेरेया, पर देखो, एती तो से ए, जो योना ते बड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","दख्खणो री राणी, न्याय रे दिनो रे, एस बखतो रे लोका साथे उठणी और सेयो दोषी ठराणे, कऊँकि से सुलेमानो रा ज्ञान सुणने खे तरतिया रे दूजे कनारे पाँदा ते आयी थी और देखो, एती तो से ए, जो सुलेमानो ते बी बड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“जेबे दुष्टात्मा मांणूए ते निकल़ी जाओई, तेबे से सूकी जगा आराम करने खे टोल़ो ई, पर तेसा खे मिलदी नि। ");
INSERT INTO bfz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तेबे से आपणे आपू रे बोलोई, ‘मां आपणे तेस मांणूए रेई, जेथा ते से आयी थी, तेथी वापस चली जाणा।’ जेबे से वापस आओई, तेबे तेसा खे से मांणू कअरो जेड़ा, कल्ला, साफ-सुथरा और सजाया रा मिलोआ। ");
INSERT INTO bfz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तेबे से दुष्टात्मा आपू साथे सात ओर दुष्टात्मा खे ल्याओई और सेयो तेस मांणूए रे बैठी जाओईया और तेथी वास करोईया और तेस मांणूए री दशा पईलकी दशा ते बी खराब ऊई जाओई। एस जुगो रे बुरे लोका री दशा बी एड़ी ई ऊणी।” ");
INSERT INTO bfz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","जेबे यीशु पीड़ा साथे इना गल्ला करने ई लगी रे थे, तेबे तिना री आम्मा और पाई बारे खड़ी रे थे और तिना साथे कुछ गल्ल करना चाओ थे। ");
INSERT INTO bfz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","तेबे किने तिना खे बोलेया, “देखो, तुसा री आम्मा और पाई और बईण बारे खड़ी रे और तुसा साथे गल्ल करना चाओए।” ");
INSERT INTO bfz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ये सुणी की तिने बोलणे वाल़े खे जवाब दित्तेया, “कुण मेरी आम्मा ए? और कुण मेरा पाई ए?” ");
INSERT INTO bfz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","तेबे तिने आपणे चेलेया री तरफा खे आथ कित्तेया और बोलेया, “देखो, मेरी आम्मा और मेरे पाई तो यो ए। ");
INSERT INTO bfz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","कऊँकि जो कोई मेरे स्वर्गिय पिते री इच्छा पाँदे चलोआ, सेई मेरा पाई, बईण और आम्मा ए।” ");
INSERT INTO bfz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","तेस दिने यीशु कअरो ते निकल़ी की समुद्रो रे कनारे बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","तेबे तिना गे बऊत बड़ी पीड़ कट्ठी ऊईगी। तेबे सेयो किस्तिया पाँदे चढ़ी गे और सारी पीड़ कनारे पाँदे खड़ी री रई। ");
INSERT INTO bfz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","तेबे यीशुए तिना खे बऊत गल्ला उदारणा रे बोलिया, “एक बार बाणे वाल़ा, बेजा बाणे निकल़ेया। ");
INSERT INTO bfz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","बांदे ऊए कुछ बिऊ बाटा रे कनारे छूटी गे और पंछी आए और तिने बीज चूगी ले। ");
INSERT INTO bfz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","कुछ बिऊ सापड़ी वाल़ी जगा रे छूटी गे, जेती तिना खे जादा माट्टी नि मिली और जादा गईरी माट्टी ना मिलणे री बजअ ते सेयो चट-चट जम्मी गे। ");
INSERT INTO bfz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पर सूरज निकल़दे ई सेयो फूकी गे और जड़ ना पकड़ने री बजअ ते सेयो सूकी गे। ");
INSERT INTO bfz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कुछ बिऊ जाड़ो रे छूटे, तेबे जाड़ बड़ा ऊईगा और तिने सेयो दबाई ते। ");
INSERT INTO bfz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","पर कुछ बिऊ अच्छी जमीना पाँदे छूटे और फल ल्याए, कोई सौ गुणा, कोई साठ गुणा और कोई तीइ गुणा। ");
INSERT INTO bfz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जो समजी सकोआ से तिजी खे त्यानो साथे सुणो और मानी बी लओ।” ");
INSERT INTO bfz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","चेलेया नेड़े आयी की तिना खे बोलेया, “तुसे उदारणा रे लोका साथे गल्ला कऊँ करोए?” ");
INSERT INTO bfz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","यीशुए तिना खे जवाब दित्तेया, “तुसा खे तो स्वर्गो रे राज्य रे पेतो री समज दित्ती रिये, पर तिना खे निए। ");
INSERT INTO bfz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","कऊँकि जेसगे आए तेसखे ओर बी देणा, तेबे तेसगे बऊत ऊई जाणा। पर जेसगे कुछ पनिए, तेसगे जो कुछ बी आए से बी लई लया जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","आऊँ तिना साथे उदारणा रे इजी री खातर गल्ला करूँआ, कऊँकि सेयो, देखदे ऊए पनि देखदे, सुणदे ऊए पनि सुणदे और ना समजदे। ");
INSERT INTO bfz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","तिना रे बारे रे यशायाह भविष्यबक्ते री ये भविष्यबाणी पूरी ओई, “ ‘तुसा कानो ते तो सुणना, पर समजणा नि और आखी ते तो देखणा, पर दिशणा नि। ");
INSERT INTO bfz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","कऊँकि इना लोका रा मन मोटा ऊईगा रा और सेयो कानो ते ऊच्चा सुणोए, तिने आपणी आखी बन्द करी ती रिया। केथी एड़ा नि ओ कि सेयो, आखी ते देखणे लगो, कानो ते सुणने लगो, मनो ते समजणे लगो, और फिरी जाओ और आऊँ तिना खे ठीक करी देऊँ।’ ");
INSERT INTO bfz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“पर धन्य ए तुसा री आखी जो देखोईया और तुसा रे कान, जो सुणोए। ");
INSERT INTO bfz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","कऊँकि आऊँ तुसा खे सच बोलूँआ कि बऊत सारे भविष्यबक्ते और तर्मी लोके चाया कि जो गल्ला तुसे देखोए, तिना देखो, पर देखी नि सके, और जो गल्ला तुसे सुणोए, सुणो, पर सुणी नि सके। ");
INSERT INTO bfz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“एबे तुसे बाणे वाल़े रे उदारणो रा मतलब सुणो। ");
INSERT INTO bfz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जो कोई परमेशरो रा वचन सुणी की नि समजदा, तेसरे मनो रे जो कुछ बाई राखेया था, तेसखे से दुष्ट आयी की छुड़ाई की लई जाओआ। ये सेईए जो बाटा रे कनारे बाई राखेया था। ");
INSERT INTO bfz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","जो सापड़ी पाँदली जमीना पाँदे बाई राखेया था, ये से ए, जो वचन सुणी की फटाफट खुशिया साथे मानी लओआ। ");
INSERT INTO bfz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पर आपू रे जड़ ना राखणे री बजअ ते से, थोड़े ई दिनो खे ए और जेबे वचनो री बजअ ते क्ल़ेश या बुरा ओआ, तो चट ई ठोकर खाई लओआ। ");
INSERT INTO bfz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जो जाड़ो रे बाया, से ये ए, जो वचनो खे तो सुणोआ, पर दुनिया री चिन्ता, धनो रा तोखा, वचनो खे दबाई देओआ और से फल नि ल्याऊँदा। ");
INSERT INTO bfz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","जो अच्छी जमीना रे बाया, से ये जो वचनो खे सुणी की समजोआ और फल ल्याओआ, कोई सौ गुणा, कोई साठ गुणा और कोई तीइ गुणा।” ");
INSERT INTO bfz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीशुए तिना खे एक और उदारण दित्तेया, “स्वर्गो रा राज्य, तेस जिम्मीदारो जेड़ा ए, जिने आपणे डोरूआ रे अच्छा बीज बाया। ");
INSERT INTO bfz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पर जेबे लोक सऊणे लगी रे थे, तेबे तेसरा दुश्मण आया और कणका बीचे जंगल़ी बीज बाई की चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जेबे लूंग आयी और सिल्ले लगे, तेबे जंगल़ी दाणेया री डाल़ी बी दिशणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","तेबे कअरो रे दासे आयी की तेसखे बोलया, ‘ओ मालक! क्या तुसे आपणे डोरूआ रे टंगो रा बीज नि था बाए रा? तेबे जंगल़ी दाणे रिया डाल़िया तेते बीचे केथा ते आईया?’ ");
INSERT INTO bfz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","तिने तिना खे बोलेया, ‘ये तो केसी दुश्मणो रा काम ए।’ तेबे जो दास थे, तिने तेसखे बोलेया, ‘क्या तेरी इच्छा ए कि आसे जाई की तिना खे कट्ठा करी देऊँ?’ ");
INSERT INTO bfz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","तिने बोलेया, ‘ना, एड़ा नि ओ कि जंगल़ी दाणेया री डाल़िया खे कट्ठे करदे-करदे, कणका खे बी पटी देयो। ");
INSERT INTO bfz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","बाडणे रे बखतो तक तिना दूँईं खे साथे-साथे बड़ने देयो और जेबे बाडणे रा बखत आऊणा तेबे मां बाडणे वाल़े खे बोलणा कि जंगल़ी दाणे कट्ठे करी की फूकणे खे, तिना रे बिंडे बानी देयो, और कणका खे मेरे पण्डारो रे कट्ठा करी देयो।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","यीशुए तिना खे एक और उदारण दित्तेया, “स्वर्गो रा राज्य अऊरिया रे एक दाणे जेड़ा ए, जो एकी मांणूए लया और आपणे डोरूआ रे बीजी ता। ");
INSERT INTO bfz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","से सबी बीजो ते तो छोटा ए, पर जेबे से बढ़ोआ, तेबे सबी सागो-पातो ते बड़ा ओआ और एड़ा डाल़ ऊई जाओआ कि सर्गो रे पंछी आयी की तेतेरी डाल़िया रे आपणा बसेरा करोए।” ");
INSERT INTO bfz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","तिने एक ओर उदारण सुणाया, “स्वर्गो रा राज्य, सजेड़े जेड़ा ए, जो एकी जवाणसे लया और बीइ किलो ते जादा आटे रे गूँदी ता और ऊँदे-ऊँदे सारा आटा सजेड़ा ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ये सब गल्ला यीशुए लोका खे उदारणा रे बोलिया और बिना उदारणो ते सेयो तिना खे कुछ नि बोलो थे। ");
INSERT INTO bfz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ताकि जो वचन भविष्यबक्ते बोलेया था, से पूरा ओ कि “मां उदारण बोलणे खे आपणा मूँ खोलणा; मां सेयो गल्ला बोलणिया, जो दुनिया री शुरूआता ते गुप्त ए।” ");
INSERT INTO bfz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","तेबे यीशु पीड़ा खे छाडी की कअरे आए, तेबे तिना रे चेलेया तिना गे आयी की बोलेया, “डोरूआ रे जंगल़ी दाणे रा उदारण आसा खे समजयाई देओ।” ");
INSERT INTO bfz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","यीशुए तिना खे जवाब दित्तेया, “अच्छे बीज बाणे वाल़ा माणूं रा पुत्र ए। ");
INSERT INTO bfz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","डोरू दुनिया रे लोक ए, अच्छा बीज राज्य रे से लोक ए जिना पाँदे परमेशर राज करने ते खुश ए और जंगल़ी बीज, दुष्टो री से ल्वाद ए जो शैतानो री आज्ञा मानी की काम करोए। ");
INSERT INTO bfz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","जिने दुश्मणे सेयो बीजे, से शैतान ए; बडाई दुनिया रा अंत ए और बाडणे वाल़े स्वर्गदूत ए। ");
INSERT INTO bfz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","तेबे जिंयाँ जंगल़ी दाणे कट्ठे करोए और फूकी देओए, तेड़ा ई दुनिया रे अंतो रे ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मां माणूं रे पुत्रो आपणे स्वर्गदूत पेजणे, तिना तेसरे राज्य रे, सब, जो ठोकरा री बजअ ओ ए और पाप करने वाल़े, कट्ठे करने ");
INSERT INTO bfz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","और सेयो आगी रे कुण्डो रे सेटी देणे, जेती रोणा और दाँद किरड़ना ई ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तेस बखते तर्मी आपणे पिते रे राज्य रे सूरजो जेड़े चमकणे, जो समजी सकोआ से तिजी खे त्यानो साथे सुणो और मानी बी लओ। ");
INSERT INTO bfz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“स्वर्गो रा राज्य डोरूआ रे लूके रे खजाने जेड़ा ए, जो केसी मांणूए खे मिलेया और तिने लकोईता, तेबे तिने खुश ई की आपणा सब कुछ बेची ता और से डोरू खरीदी ला। ");
INSERT INTO bfz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“स्वर्गो रा राज्य एक बपारिए जेड़ा ए, जो खरे मोतिए री टोल़ा रे था। ");
INSERT INTO bfz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जेबे तेसखे एक किमती मोती मिली गा, तेबे तिने जाई की आपणा सब कुछ बेची ता और से मोती खरीदी ला। ");
INSERT INTO bfz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“फेर, स्वर्गो रा राज्य तेस बड़े जाल़ो जेड़ा ए, जो समुद्रो रे पाया और हर प्रकारा रिया मछलिया तिदे आयी गिया ");
INSERT INTO bfz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","और जेबे जाल़ फरी गा, तेबे मछली पकड़ने वाल़े तिजी खे कनारे पाँदे खिंजी की ली आए और जो अच्छी-अच्छी मछलिया थिया सेयो पांडे रे राखी तिया और जो नकम्मिया थिया सेयो सेटी तिया। ");
INSERT INTO bfz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","दुनिया रे अंतो रे एड़ा ई ऊणा, तेबे स्वर्गदूता आयी की दुष्ट तर्मिया ते लग करने, ");
INSERT INTO bfz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","और सेयो आगी रे कुण्डो रे सेटी देणे। तेती रोणा और दाँद किरड़ना ई ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“क्या तुसे यो सब गल्ला समजिया?” तिने यीशुए खे बोलेया, “आ।” ");
INSERT INTO bfz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","तेबे यीशुए तिना खे बोलेया, “हर एक शास्त्री, जो स्वर्गो रे राज्य रा चेला बणी रा, तेस करेलू मांणूए जेड़ा ए, जो आपणे पण्डारो ते नईया और पुराणिया चीजा निकयाल़ोआ।” ");
INSERT INTO bfz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जेबे यीशु इना सारे उदारणा बोली चुके, तेबे सेयो तेथा ते चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","तेबे आपणे नगरो रे आयी की तिना रे प्रार्थना रे कअरो रे तिना खे एड़ा उपदेश लगे देणे कि सेयो हैरान ऊई की तिना खे बोलणे लगे, “इना खे इतणा ज्ञान और सामर्थो रे काम केथा ते मिले? ");
INSERT INTO bfz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","क्या ये मिस्त्रियो रा पाऊ निए? क्या इना री आम्मा रा नाओं मरियम निए और पाईयो रा नाओं याकूब, यूसुफ, शमोन और यहूदा निए? ");
INSERT INTO bfz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","क्या इना रिया सारिया बईणा आसा बीचे नि रंदिया? तेबे इना खे ये सब कुछ केथा ते मिलेया?” ");
INSERT INTO bfz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","यीशुए तिना री बजअ ते ठोकर खाई पर तिने तिना खे बोलेया, “भविष्यबक्ते रा आपणे देश और आपणे कअरो खे छाडी की ओरथी केथी बी नरादर नि ऊँदा।” ");
INSERT INTO bfz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","तेबे यीशुए तिना रे अविश्वासो री बजअ ते जादा सामर्था रे काम नि कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","तेस बखते चौथाई देशो रे राजे हेरोदेसे यीशुए री चर्चा सुणी, ");
INSERT INTO bfz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","और तेबे तिने आपणे दासा खे बोलेया, “ये यूहन्ना बपतिस्मा देणे वाल़ा ए और मरे रेया बीचा ते जिऊँदा ऊईगा रा, तेबेई तो एसते सामर्था रे काम ओए।” ");
INSERT INTO bfz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","कऊँकि हेरोदेसे, आपणे पाई फिलिप्पुसो री लाड़ी हेरोदियासा री बजअ ते, यूहन्ना पकड़ी की बानेया और जेला रे पाईता था। ");
INSERT INTO bfz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","कऊँकि यूहन्ने तेसखे बोलेया था, “एसा खे राखणा बिधानो रे मुताबिक ताखे ठीक निए।” ");
INSERT INTO bfz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","इजी री बजअ ते से यूहन्ने खे काणा चाओ था, पर लोका ते डरो था, कऊँकि लोक तेसखे भविष्यबक्ता मानो थे। ");
INSERT INTO bfz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पर जेबे हेरोदेसो रा जन्मदिन आया, तेबे हेरोदियासा री बेटिये त्योआरो रे नाची की हेरोदेस खुश करी ता। ");
INSERT INTO bfz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","तेबे तिने कसम खाई की वचन दित्तेया, “जो कुछ तूँ मांगेगी, मां ताखे देणा।” ");
INSERT INTO bfz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","से आपणी आम्मा री सकेल़ी री थी और तेसे बोलेया, “यूहन्ने बपतिस्मे रा सिर थाल़िया रे एथी माखे मंगवाई दे।” ");
INSERT INTO bfz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","राजा दु:खी ऊईगा, पर आपणी कसमा री और आपू साथे बैठणे वाल़ेया री बजअ ते, तिने आज्ञा दित्ती कि देई दो। ");
INSERT INTO bfz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","तेबे तिने जेला रे आपणे मांणूआ खे पेजी की यूहन्ने रा सिर बडवाईता ");
INSERT INTO bfz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","और तेसरा सिर थाल़िया रे ल्याया और मुन्निया खे दित्तेया और से तिजी खे आपणी आम्मा गे लईगी। ");
INSERT INTO bfz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","तेबे यूहन्ने रे चेले आए और तेसरी लोथ लई की दबाई ती और यीशुए खे एतेरा समाचार सुणाया। ");
INSERT INTO bfz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जेबे यीशुए ये सब सुणेया, तेबे सेयो किस्तिया रे बैठी की सुणसाण जगा रे लग जे चली गे और जेबे लोके ये सुणेया तेबे सेयो नगरो-नगरो रिये हांडी की तिना पीछे आईगे। ");
INSERT INTO bfz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","यीशुए निकल़ी की एक बड़ी पीड़ देखी और तिना पाँदे तिना खे तरस आया और तिने तिना रे बमार ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जेबे साँज ऊई, तेबे तिना रे चेले तिना गे आए और बोलणे लगे, “एती तो सुणसाण जगा ए और देर लगी री ऊणे, तुसे लोका खे बिदा करो, ताकि सेयो जाई की बस्तिया रे आपू खे रोटी खरीदी सको।” ");
INSERT INTO bfz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","यीशुए तिना खे बोलेया, “तिना रा जाणा जरूरी निए, तुसेई इना खे खाणे खे देयो।” ");
INSERT INTO bfz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","तिने बोलेया, “एती तो आसा गे पाँज रोटिया और दो मछलिया छाडी की कुछ निए।” ");
INSERT INTO bfz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","यीशुए बोलेया, “तिना खे मांगे ली आओ।” ");
INSERT INTO bfz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तेबे तिने लोका खे काओ पाँदे बैठणे खे बोलेया, तेबे तिने सेयो पाँज रोटिया और दो मछलिया लईया और स्वर्गो खे देखेया और धन्यवाद कित्तेया और रोटिया तोड़ी-तोड़ी की चेलेया खे दित्तिया और चेलेया लोका खे। ");
INSERT INTO bfz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","जेबे सब खाई की रजी गे, तेबे चेलेया जो टुकड़े थे बचे रे तिना रिया बारा टोकरिया परिया और चकिया। ");
INSERT INTO bfz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","खाणे वाल़े जवाणसा और बच्चेया खे छाडी की तकरीबन पाँज ह्जार मर्द थे। ");
INSERT INTO bfz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","तेबे यीशुए तेबुई आपणे चेले किस्तिया रे चढ़ाणे खे मजबूर कित्ते कि जदुओ तक आऊँ लोका खे बिदा करूँआ, तुसे तिजी ते पईले पार चली जाओ। ");
INSERT INTO bfz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","तेबे यीशु लोका खे बिदा करी की प्रार्थना करने खे लग पाह्ड़ो पाँदे चली गे और साँजा तक तेती कल्ले थे। ");
INSERT INTO bfz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तेस बखते किस्ती समुद्रो रे लईरा साथे छूनके खाणे लगी, कऊँकि सामणी अवा थी। ");
INSERT INTO bfz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","तेबे यीशु राथियो रे चौथे पइरो रे समुद्रो रे चली की तिना गे आए। ");
INSERT INTO bfz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","चेले तिना खे समुद्रो रे चलदे ऊए देखी की कबराइगे और बोलणे लगे, “ए तो पूत ए,” और सेयो डरी गे और चिंगणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","यीशुए तेबुई तिना साथे गल्ला कित्तिया और बोलेया, “इम्मत राखो, आऊँ ए, डरो नि।” ");
INSERT INTO bfz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरसे तिना खे बोलेया, “ओ प्रभु! जे तुसे ईए, तो माखे आपू गे चली की आऊणे री आज्ञा देयो।” ");
INSERT INTO bfz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","यीशुए बोलेया, “आईजा।” तेबे पतरस किस्तिया ते पाणिए बीचे उतरेया और यीशुए गे जाणे खे पाणिए बीचे चलणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पर से पाणिए खे देखी की जो समुद्रो रे अवा साथे लईरा उठणे लगी री थिया देखी की डरीगा और जेबे डूबणे लगेया, तेबे चींगी की बोलणे लगेया, “ओ प्रभु, माखे बचा।” ");
INSERT INTO bfz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीशुए फटाफट आपणा आथ आगे कित्तेया और से बचाईता और तेसखे बोलेया, “ओ कम विश्वास करने वाल़े, तैं शक कऊँ कित्तेया?” ");
INSERT INTO bfz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जेबे सेयो किस्तिया रे चढ़ी गे, तेबे अवा रुकी गी। ");
INSERT INTO bfz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ये देखी की जो किस्तिया रे थे तिने तिना गे माथा टेकी की बोलेया, “सच्ची तुसे परमेशरो रे पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","सेयो पार उतरी की गन्नेसरत देशो रे पऊँछे। ");
INSERT INTO bfz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","तेथो रे लोके सेयो पछयाणी ले और ओरे-पोरे सबी गे बोलेया और सब लोक बमारा खे तिना गे ल्याए ");
INSERT INTO bfz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","और यीशुए ते प्रार्थना करने लगे कि आसा खे बस आपणे टाले रा पल्ला ई छूणे दे, और जितणेया बी सेयो छूँएं, सब ठीक ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तेबे यरूशलेमो रे बऊत शास्त्री और फरीसी यीशुए गे आए और बोलणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“तुसा रे चेले बुजुर्गा री रवाजा खे कऊँ नि मानदे और बिना आथ तोए रोटी खाओए?” ");
INSERT INTO bfz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","यीशुए तिना खे जवाब दित्तेया, “तुसे बी आपणिया रवाजा रे खलाफ कऊँ परमेशरो रिया आज्ञा खे तोड़ोए? ");
INSERT INTO bfz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","कऊँकि परमेशरे बोलेया था, ‘आपणे माया-बाओ रा आदर करो,’ और ‘जो कोई आपणे माया-बावा खे बुरा बोलोगा से काया जाओ।’ ");
INSERT INTO bfz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पर तुसे बोलोए कि जे कोई आपणे माया-बावा खे बोलो, ‘जो कुछ ताखे मांते फाईदा ऊई सको था, से परमेशरो खे पेंट चढ़ाईता।’ ");
INSERT INTO bfz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","तो से आपणे पिते रा आदर नि करो, तुसे आपणी रवाजा री बजअ ते परमेशरो रा वचन टाल़ी ता। ");
INSERT INTO bfz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ओ कपटियो! यशायाहे तुसा रे बारे ये भविष्यबाणी ठीक कित्ती: ");
INSERT INTO bfz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘यो लोक मुंओ ते तो मेरा आदर करोए, पर मनो ते मांते दूर रओए ");
INSERT INTO bfz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","और यो बेकार ई मेरी भक्ति करोए, कऊँकि मांणूए रिया रवाजा खे तर्मो रा उपदेश मानोए।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","तेबे यीशुए लोका खे आपू गे बुलाई की बोलेया, “सुणो, और समजो। ");
INSERT INTO bfz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जो मुंओ रे जाओआ से मांणूए खे अशुद्ध नि करदा, पर जो मुंओ रिये निकल़ोआ से मांणूए खे अशुद्ध करोआ।” ");
INSERT INTO bfz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तेबे चेलेया आयी की तिना खे बोलेया, “क्या तुसे जाणोए कि फरीसिये ये वचन सुणी की ठोकर खाई?” ");
INSERT INTO bfz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","यीशुए जवाब दित्तेया, “हर डाल़ी जो मेरे स्वर्गिय पिते निए लगाई री, से पटी देणी। ");
INSERT INTO bfz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","तिना खे जाणे देयो, सेयो अन्दी बाट दखाणे वाल़े ए और अन्दा जे अन्दे खेई बाट बताओगा तो दोनो गड्डे रे पड़ी जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ये सुणी की पतरसे तिना खे बोलेया, “एस उदारणो आसा खे समजयाई दो।” ");
INSERT INTO bfz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","यीशुए बोलेया, “क्या तुसे बी एबुए तक नि समजी रे? ");
INSERT INTO bfz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","क्या तुसे नि जाणदे कि जो कुछ मुंओ रिये जाओआ, से पेटो रे पड़ोआ और सड़यानी साथे बारे निकल़ोआ। ");
INSERT INTO bfz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पर जो कुछ मुंओ रिये निकल़ोआ, से मनो ते निकल़ोआ और सेई मांणूए खे अशुद्ध बणाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","कऊँकि बुरे बिचार, अत्या, परस्त्रीगमन, व्याभिचार, चोरी, चूठी गवाई और निन्दा मनो तेई निकल़ोई। ");
INSERT INTO bfz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","येईए जो मांणूए खे अशुद्ध करोए, पर बिना आथ तोए रोटी खाणा मांणूए खे अशुद्ध नि करदा।” ");
INSERT INTO bfz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","यीशु तेथा ते निकल़ी की सूर और सैदा रे नगरो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","तेबे तेस देशो ते एक कनानी जवाणस निकल़ी, और से चींगी की बोलणे लगी, “ओ प्रभु दाऊदो री ल्वाद! मां पाँदे दया कर, मेरी मुन्निया खे दुष्टात्मा बऊत तंग लगी री करने।” ");
INSERT INTO bfz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पर तिने तेसा खे कोई बी जवाब नि दित्तेया, तेबे तिना रे चेलेया बोलेया, “एसा खे एथा ते पेजी दे, कऊँकि ये तो आसा पीछे आल्ला पाँदी ऊई आऊणे लगी री।” ");
INSERT INTO bfz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","तिने बोलेया, “इस्राएलो रे कराने रिया राची रिया पेडा खे छाडी की आऊँ केसी गे निए पेजेया रा।” ");
INSERT INTO bfz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पर से आयी और तिना गे माथा टेकी की बोलणे लगी, “ओ प्रभु! मेरी मताद करो।” ");
INSERT INTO bfz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","प्रभुए तेसा खे बोलेया, “बच्चेया री रोटी कुत्तेया रे आगे देणे ते कोई फाईदा निए।” ");
INSERT INTO bfz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","जवाणसे बोलेया, “सच ए प्रभु, पर कुत्ते बी तेस चुरा-चूरा खाओए, जो तिना रे मालका री मेजा ते छुटोआ।” ");
INSERT INTO bfz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ये सुणी की यीशुए तेसा खे बोलेया, “ओ जवाणसे! तेरा विश्वास बड़ा ए, जेड़ा तूँ चाए ई तेड़ा ई ओ” और तेसा री मुन्नी तेबुई ठीक ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीशु तेथा ते गलीलो रे समुद्रो रे आए और पाह्ड़ो पाँदे चढ़ी की बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","तेबे पीड़ा री पीड़ यीशुए गे आयी और अन्दे, लंगड़े, गूँगे, टूण्डे और ओर बी कई जणेया खे यीशुए गे ल्याए और सेयो तिना रे पैरा पाँदे राखी ते और तिने सेयो ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","तेबे, जेबे लोके देखेया कि गूँगे बोलणे लगे, अन्दे देखणे लगे, टूण्डे ठीक ऊईगे, लंगड़े चलणे लगी गे तो तिने हैरान ऊई की इस्राएलो रे परमेशरो री तारीफ कित्ती। ");
INSERT INTO bfz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीशुए आपणे चेले बुलाए और तिना खे बोलेया, “माखे एसा पीड़ा पाँदे तरस आओए, कऊँकि ये तीन दिना ते मां साथे ए और इना गे कुछ बी खाणे खे निए। आऊँ तिना खे पूखे नि पेजणा चांदा, केथी एड़ा नि ओ कि यो बाटा रे थकी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","चेलेया तिना खे बोलेया, “आसा खे जंगल़ो रे इतणिया सारिया रोटिया केथा ते मिलणिया कि आसे इतणी बड़ी पीड़ा खे रजाई सकिए?” ");
INSERT INTO bfz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीशुए तिना ते पूछेया, “तुसा गे कितणी रोटिया ए?” तिने बोलेया, “सात, और कुछ छोटिया मछलिया ए।” ");
INSERT INTO bfz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तेबे तिने लोका खे जमीना पाँदे बैठणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","और तिने सेयो सात रोटिया और मछलिया लईया और धन्यवाद करी की तोड़िया और आपणे चेलेया खे दित्तिया और चेलेया लोका खे। ");
INSERT INTO bfz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","तेबे सब तिना खाई की रज्जी गे और चेलेया बचे रे टुकड़ेया ते परे रे सात टोकरे चके। ");
INSERT INTO bfz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","खाणे वाल़े, जवाणसा और बच्चेया खे छाडी की चार ह्जार मर्द थे ");
INSERT INTO bfz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तेबे सेयो पीड़ा खे बिदा करी की किस्तिया पाँदे चढ़ी गे और मगदन देशो रे बन्ने रे आए। ");
INSERT INTO bfz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","तेबे फरीसिये और सदूकिये नेड़े आयी की यीशुए खे परखणे खे बोलया, “आसा खे स्वर्गो रा कोई चिह्न् दखाओ।” ");
INSERT INTO bfz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","तिने तिना खे जवाब दित्तेया, “साँजा खे तुसे बोलोए, ‘मौसम साफ रणा, कऊँकि सर्ग लाल ए,’ ");
INSERT INTO bfz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","और प्यागा खे बोलोए, ‘आज तूफान आऊणा, कऊँकि सर्ग लाल और तूँदल़ा ए।’ तुसे सर्गो खे देखी की पेत बताई सकोए, पर बखतो रे चिह्नो रा पेत नि बताई सकदे? ");
INSERT INTO bfz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","एस जुगो रे बुरे और व्याभिचारी लोक चिह्न टोल़ोए; पर योने रे चिह्नो खे छाडी की कोई और चिह्न तिना खे नि देणा।” यीशु इना खे छाडी की चली जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","चेले समुद्रो ते पार पऊँछी गे, पर सेयो रोटी लणा पूली गे थे। ");
INSERT INTO bfz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीशुए तिना खे बोलेया, “देखो, फरीसी और सदूकिये रे सजेड़े ते चौकस रणा।” ");
INSERT INTO bfz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","सेयो आपू बीचे सोचणे लगे, “आसे तो रोटी ल्याई नि राखी, तेबेई तो यो आसा खे एड़ा बोलणे लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ये जाणी की यीशुए तिना खे बोलेया, “ओ कम विश्वास करने वाल़ेयो! तुसे आपू बीचे कऊँ लगी रे सोचणे कि आसा गे रोटी निए? ");
INSERT INTO bfz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","क्या तुसे एबुए तक नि समजे? क्या तुसा खे सेयो पाँज ह्जारा रिया पाँज रोटिया याद निए, और ना ये कि तुसे कितणिया टोकरिया चकिया थिया? ");
INSERT INTO bfz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ना तिना चार ह्जारा रिया सात रोटिया; और ना ये कि तुसे कितणे टोकरे चके थे? ");
INSERT INTO bfz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तुसे कऊँ नि समजदे कि मैं तुसा खे रोटिया रे बारे रे नि बोलेया? पर ये की तुसे फरीसी और सदूकिये रे सजेड़े ते चौकस रएयो।” ");
INSERT INTO bfz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तेबे तिना खे समज आया कि प्रभुए तिना खे रोटिया रे सजेड़े ते नि पर फरीसी और सदूकियो रिया शिक्षा ते चौकस रणे खे बोलेया था। ");
INSERT INTO bfz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","यीशु कैसरिया और फिलिप्पिया रे देशो रे आयी की आपणे चेलेया खे पूछणे लगे, “लोक माखे माणूं रे पुत्रो खे क्या बोलोए?” ");
INSERT INTO bfz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","तिने बोलेया, “कोई तो यूहन्ना बपतिस्मा देणे वाल़ा, कोई एलिय्याह, कोई यिर्मयाह और कोई बोलोए कि ये तो भविष्यबक्तेया बीचा ते कोई एक ए।” ");
INSERT INTO bfz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","तेबे तिने तिना खे बोलेया, “तुसे माखे क्या बोलोए?” ");
INSERT INTO bfz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","शमौन पतरसे जवाब दित्तेया, “तुसे जिऊँदे परमेशरो रे पुत्र मसीह ए।” ");
INSERT INTO bfz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीशुए तेसखे जवाब दित्तेया, “ओ शमौन, योने रा पाऊ! तूँ धन्य ए; कऊँकि मांस और खूने नि, पर मेरा पिता जो स्वर्गो रे ए, तिने ये गल्ल तांते बुलाई राखी ");
INSERT INTO bfz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","और आऊँ बी ताखे बोलूँआ कि तूँ पतरस ए और मां एस पात्थरो पाँदे आपणी मण्डल़ी बनाणी और नरको रे फाटक एस पाँदे प्रबल नि ऊणे।” ");
INSERT INTO bfz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मां ताखे स्वर्गो रे राज्य रिया कुँजियाँ देणियां और तां जो कुछ तरतिया पाँदे बानणा, से स्वर्गो रे बानेया जाणा और जो कुछ तां तरतिया रे खोलणा, से स्वर्गो रे खुलणा। ");
INSERT INTO bfz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तेबे तिने चेलेया खे सावधान करी की बोलेया कि केसी गे नि बोलणा कि आऊँ मसीह ए। ");
INSERT INTO bfz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","तेस बखतो ते यीशु आपणे चेलेया खे बताणे लगे, “जरुरी ए कि आऊँ यरूशलेमो खे जाऊँ और बुजुर्गा ते, बड़े पुरोईता ते और शास्त्रिया ते दु:ख उठाऊँ और कुल़ाया जाऊँ और तीजे दिने जिऊँदा ऊई जाऊँ।” ");
INSERT INTO bfz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ये सुणी की पतरस तिना खे लग जे लईगा और थिड़कणे लगेया, “ओ प्रभु! परमेशर नि करो तुसा साथे कदी एड़ा ओ।” ");
INSERT INTO bfz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","यीशुए मुड़ी की पतरसो खे बोलेया, “ओ शैतान! मेरी नजरा ते दूर ऊई जा, तूँ माखे ठोकरा रा कारण ए, कऊँकि तूँ परमेशरो री गल्ला पाँदे नि, पर मांणूए रिया गल्ला पाँदे मन लगाएया।” ");
INSERT INTO bfz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तेबे यीशुए आपणे चेलेया खे बोलेया, “जे कोई मां पीछे आऊणा चाओआ तो आपणे आपू खे ना करी दो और आपणा क्रूस आपू चको और मां पीछे आयी जाओ। ");
INSERT INTO bfz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","कऊँकि जो कोई आपणा प्राण बचाणा चाओगा, तेस से खोणा और जो कोई आपणा प्राण मेरी बजअ ते खोओगा, तेस से पाणा। ");
INSERT INTO bfz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","जे मांणूए खे सारी दुनिया मिली जाओ और आपणे प्राण नि रओ, तो क्या फाईदा ऊणा? या मांणूए आपणे प्राणो रे बदले क्या देणा। ");
INSERT INTO bfz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","मां माणूं रे पुत्रो आपणे स्वर्गदूता साथे आपणे पिते रिया महिमा रे आऊणा, और तेस बखते मां हर एकी खे तेसरे कामो रे मुताबिक फल देणा। ");
INSERT INTO bfz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","आऊँ तुसा खे सच लगी रा बोलणे कि जो एती खड़ी रे, तिना बीचा ते कुछ एड़े ए, जो तदुओ तक नि मरने, जदुओ तक माणूं रे पुत्रो खे तेसरे राज्य रे आऊँदा ऊआ नि देखी लओगे।” ");
INSERT INTO bfz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छे दिनो ते बाद यीशुए, पतरस, याकूब और तेसरा पाई यूहन्ना साथे लये और तिना खे लग जे केथी पाह्ड़ो पाँदे लईगे। ");
INSERT INTO bfz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","तेबे तिना सामणे यीशुए री शक्ल बदली गी और तिना रा मूँ सूरजो जेड़ा चमकीगा, तिना रे टालेया रे जोतिया जेड़ा प्रयासा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","तेबे तिना खे मूसा और एलिय्याह, यीशुए साथे गल्ला करदे ऊए दिखे। ");
INSERT INTO bfz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ये देखी की पतरसे यीशुए खे बोलेया, “ओ प्रभु! आसा रा एती रणा ठीक ए! जे तेरी इच्छा ए तो आऊँ एती तीन तम्बू बणाई देऊँ, एक तुसा खे, एक मूसे खे और एक एलिय्याह खे।” ");
INSERT INTO bfz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","से ये बोलणे ई लगी रा था कि एक प्रयासे वाल़ा बादल़ तिना पाँदे छाईगा और तेस बादल़ो ते परमेशरो री ये आवाज आई, “ये मेरा प्यारा पुत्र ए, आऊँ एसते बऊत खुश ए; एसरी सुणो।” ");
INSERT INTO bfz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","चेले ये सुणी की मुंओ रे पारे रूड़ी गे और बऊत जादा डरी गे। ");
INSERT INTO bfz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","यीशुए नेड़े आयी की सेयो छूँएं और तिना खे बोलेया, “उठी जाओ, डरो नि।” ");
INSERT INTO bfz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तेबे तिने आपणी आखी ऊबे चकिया और यीशुए खे छाडी की और कोई नि देखेया। ");
INSERT INTO bfz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जेबे सेयो पाह्ड़ो ते उतरने लगी रे थे, तेबे यीशुए तिना खे ये आज्ञा दित्ती, “जदुओ तक आँऊ माणूं रा पुत्र मरे रेया बीचा ते जिऊँदा नि ऊई जाओ, तदुओ तक जो कुछ तुसे देखेया, से केसी गे नि बताणा।” ");
INSERT INTO bfz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","तेबे तिना रे चेलेया तिना ते पूछेया, “तेबे शास्त्री कऊँ बोलोए कि एलिय्याह रा पईले आऊणा जरूरी ए?” ");
INSERT INTO bfz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","यीशुए जवाब दित्तेया, “एलिय्याह तो जरूर आऊणा और तेस सब कुछ सुदारना। ");
INSERT INTO bfz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पर आऊँ तुसा खे बोलूँआ कि एलिय्याह तो आयी चुकेया रा और लोके से नि पछयाणेया; पर जो चाया, से तेस साथे कित्तेया, तिंयाँ ई माणूं रे पुत्रो बी तिना रे आथो ते दु:ख उठाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तेबे चेलेया खे समज आया कि तिने आसा गे यूहन्ना बपतिस्मा देणे वाल़े रे बारे रे बोलेया। ");
INSERT INTO bfz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","जेबे यीशु पीड़ा रे नेड़े आए, तेबे एक मांणू तिना गे आया और कुटणे टेकी की बोलणे लगेया, ");
INSERT INTO bfz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ओ प्रभु! मेरे पाऊए पाँदे दया कर, कऊँकि तेसखे मिर्गी ए और तेसखे बऊत दु:ख ओआ, से बार-बार पाणिए रे और बार-बार आगी रे पड़ी जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","आऊँ तेसखे तुसा रे चेलेया गे ल्याया था, पर तिना रे बोले से ठीक नि ऊआ।” ");
INSERT INTO bfz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","यीशुए जवाब दित्तेया, “ओ अविश्वास करने वाल़ेयो और टीठ लोको! मां कदुओ तक तुसा साथे रणा? कदुओ तक तुसा खे सईन करुँ? तेसखे ओरे ल्याओ मांगे।” ");
INSERT INTO bfz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तेबे यीशु दुष्टात्मा खे बके और तेबे दुष्टात्मा बारे निकल़ी गी और से पाऊ तेसी बखते ठीक ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","तेबे चेलेया कल्ले जे आयी की यीशुए ते पूछेया, “आसे एसा खे कऊँ नि निकयाल़ी सके?” ");
INSERT INTO bfz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","तिने तिना खे बोलेया, “आपणे कम विश्वासो री कमिया री बजअ ते; कऊँकि आऊँ तुसा खे सच लगी रा बोलणे कि जे तुसा रा विश्वास एक अऊरिया रे दाणे बराबर बी ऊँदा, तो तुसे एस पाह्ड़ो खे बोलोगे, ‘एथा ते पोरो खे सरकी जा’, तो से चली जाणा और कोई बी गल्ल तुसा खे कठण नि ऊणी। ");
INSERT INTO bfz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पर ये जाति बिना प्रार्थना और बअरतो ते नि निकल़दी।” ");
INSERT INTO bfz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जेबे सेयो गलीलो रे थे, तेबे यीशुए तिना खे बोलेया, आँऊ माणूं रा पुत्र, मांणूआ रे आथो रे पकड़वाऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","तिना आँऊ काई देणा और आँऊ तीजे दिने जिऊँदा ऊई जाणा। ये सुणी की सेयो बऊत दु:खी ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जेबे सेयो कफरनहूम पऊँछे तेबे मन्दरो रा कर लणे वाल़ेया, पतरसो गे आयी की पूछेया, “क्या तुसा रा गुरू मन्दरो रा कर नि देंदा?” ");
INSERT INTO bfz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","तिने बोलेया, “आ, देओआ।” जेबे सेयो कअरे आये तेबे यीशुए तेसरे पूछणे ते पईले ई तेसखे बोलेया, “ओ शमौन! तूँ क्या समजेया? तरतिया रे राजे कर केस ते लओए? आपणे बच्चेया ते या पराया ते?” ");
INSERT INTO bfz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरसे तिना खे बोलेया, “पराया ते।” यीशुए तेसखे बोलेया, “तेबे पाऊ तो बची गे। ");
INSERT INTO bfz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","पर तेबे बी आसे तिना खे ठोकर नि देणा चांदे। तूँ समुद्रो रे कनारे जा और बंसी पाणिए रे पा, जो मछली पईले निकल़ो, तेसा खे लओ और तेसा रा मूँ खोली की ताखे एक सिक्का मिलणा। तेस लओ और आपणे और मेरे बदले तिना खे देई दे।” ");
INSERT INTO bfz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","तेस बखते चेले यीशुए गे आयी की पूछणे लगे, “स्वर्गो रे राज्य रे बड़ा कुण ए?” ");
INSERT INTO bfz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","यीशुए एक बाल़क आपू गे बुलाया और तिना बीचे खड़ा कित्तेया ");
INSERT INTO bfz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","और बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि जदुओ तक तुसे नि फिरो और बच्चे जेड़े नि बणो, तुसे स्वर्गो रे राज्य रे नि जाई सकदे। ");
INSERT INTO bfz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जो कोई एस बच्चे जेड़ा आपू खे छोटा करोगा, से स्वर्गो रे राज्य रे बड़ा ऊणा ");
INSERT INTO bfz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","और जो कोई मेरे नाओं ते एड़े बाल़को खे मानोआ, से माखे मानोआ। ");
INSERT INTO bfz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“पर जो कोई इना छोटेया बीचा ते, जो मां पाँदे विश्वास राखोए, एकी खे बी ठोकर देओगा, तो तेसखे पला ऊँदा कि तेसरे गल़े रे चाक्किया रा एक बड़ा पूड़ लटकाई देओ और तेसखे समुद्रो रे सेटी देओ। ");
INSERT INTO bfz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ठोकरा री बजअ ते एसा दुनिया पाँदे हाय! ठोकरा रा लगणा जरूरी ए; पर हाय तेस मांणूए खे जेसरे पापो री बजअ ते ठोकर लगोई। ");
INSERT INTO bfz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“जे तेरा आथ या पैर ताखे ठोकर देओआ, तो तेस बाडी की सेटी दे, कऊँकि तेरे दो आथ और दो पैर ऊँदे ऊए बी जे तूँ अनन्त आगी रे सेटेया जाओआ, तो ताखे बड़िया ए कि तूँ टूण्डा या लंगड़ा ऊई की जिन्दगी बिताए। ");
INSERT INTO bfz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","जे तेरी आख ताखे पापो री बजअ बणो ई, तो तेसा निकयाल़ी की सेटी दे। काणा ऊई कि जिन्दगिया रे जाणा ताखे ये पला ए कि दो आखी रंदे ऊए तूँ नरको रिया आगी रे सेटेया जाओ। ");
INSERT INTO bfz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“देखो, तुसे इना छोटेया बीचा ते केसी खे बी तुच्छ नि जाणना। कऊँकि आऊँ तुसा खे सच लगी रा बोलणे कि स्वर्गो रे तिना रे स्वर्गदूत मेरे स्वर्गिय पिते रे सामणे बिनती करने रे मकसदो ते सदा तिना सामणे आजीर रओए। ");
INSERT INTO bfz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","कऊँकि आँऊ माणूं रा पुत्र राचेया रे खे बचाणे आयी रा। ");
INSERT INTO bfz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“तुसे क्या सोचोए? जे मानी लो केसी मांणूए गे सौ पेडा ए और तिना बीचा ते एक पेड राची जाओ, तो क्या से तिना नड़िनूए पेडा खे छाडी की और पाह्ड़ो पाँदे जाई की तेसा राची रिया पेडा खे टोल़ने नि जाणा? ");
INSERT INTO bfz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","और जेबे तेसखे से पेड मिली जाओ तो आऊँ तुसा खे सच लगी रा बोलणे कि से तिना नड़िनूए पेडा खे, जो राची नि रईया थिया, ईतणा खुश नि ऊणा, जितणा तेसा राची री एक पेडा खे। ");
INSERT INTO bfz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","एड़ी ई इच्छा, तुसा रे स्वर्गिय पिते री निए कि इना छोटेया बीचा ते एक बी नाश ओ। ");
INSERT INTO bfz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“जे तेरा कोई विश्वासी पाई तेरे खलाफ अपराध करो, तो तेसखे कल्ले जे लई जाई की समजेया, जे से तेरी सुणोगा तो तैं आपणा विश्वासी पाई पायी ला। ");
INSERT INTO bfz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","जे से तेरी नि सुणोगा, तो तूँ आपू साथे, एकी-दूँईं जणे खे ओरी खे बी लई जा, ताकि ‘मूसे रा बिधानो रे मुताबिक हर एक गल्ला री गवाई, दो या तीन जणेया रे मुंओ ते पक्की कित्ती जाओ।’ ");
INSERT INTO bfz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","जे से तिना री पनि मानो, तो तूँ मण्डल़िया खे बोल, पर जे से मण्डल़िया री पनि सुणोगा, तो तूँ तेसखे दूजी जातिया रा और कर लणे वाल़ा जेड़ा समज। ");
INSERT INTO bfz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“आऊँ तुसा खे सच लगी रा बोलणे कि जो कुछ तुसा तरतिया रे बानणा, से स्वर्गो रे बानेया जाणा और जो कुछ तुसा तरतिया रे खोलणा, से स्वर्गो रे खोलेया जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","फेर आऊँ तुसा खे बोलूँआ कि जो कोई तरतिया रे दो जणे एक मन ऊई की तिजी खे माँगो, तो से मेरे स्वर्गिय पिते री तरफा ते, जो स्वर्गो रे ए, से तिना खे ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","कऊँकि जेती दो या तीन जणे मेरे नाओं ते कट्ठे ओए, तेती आऊँ तिना बीचे ओऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तेबे पतरसे नेड़े आयी की यीशुए खे बोलेया, “ओ प्रभु! जे मेरा विश्वासी पाई अपराध ई करदा रओ, तो आऊँ कितणी बार तेसखे माफ करुँ? क्या सात बार तक?” ");
INSERT INTO bfz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीशुए तेसखे बोलेया, “आऊँ तुसा खे ये नि बोलदा कि सात बार, बल्कि सात बारा रे सत्तर गुणे तक माफ करो। ");
INSERT INTO bfz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“तेबेई तो स्वर्गो रा राज्य तेस राजे जेड़ा ए, जिने आपणे दासा ते लेखा लणा चाया। ");
INSERT INTO bfz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जेबे से लेखा लणे लगेया, तेबे एक मांणू तेस सामणे ल्याया जो दस हजार सूईने रे सिक्के रा कर्जदार था। ");
INSERT INTO bfz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","जबकि तेसगे कर्ज चुकाणे खे कुछ पनि था। तेबे तेसरे मालके बोलेया, एसखे, एसरी लाड़ी, एसरे बच्चे और जो कुछ एसरे कअरो रे ए, से सब बेची देयो और तेबे एसरा कर्ज चुकदा ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","तेबे से दास, आपणे मालको रे पैरा पाँदे पड़ी गा और माथा टेकणे लगेया, और बोलणे लगेया, ‘सब्र राख, मां सब वापस करी देणा।’ ");
INSERT INTO bfz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तेबे तेस दासो रे मालको खे तेस पाँदे तरस आईगा और तिने तेसरा सारा त्वार माफ करी ता। ");
INSERT INTO bfz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“पर जेबे से दास बारे निकल़ेया तेबे तेस साथले दासा बीचा ते तेसखे एक जणा मिलेया, जो, तेसरे सौ चाँदिए रे सिक्के रा कर्जदार था; तिने से पकड़ी की तेसरा गल़ा कोटेया और बोलेया, ‘जो तांगे मेरा त्वार ए तेस वापस कर।’ ");
INSERT INTO bfz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","तेबे तेस साथला दास तेसरे पैरा पाँदे पड़ी की बोलणे लगेया, ‘सब्र राख, मां तेरा कर्ज चुकाई देणा।’ ");
INSERT INTO bfz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","पर से नि मानेया और तिने से जेला रे पाईता कि जदुओ तक इने मेरा कर्ज नि दित्तेया, तदुओ तक ये एथी रणा। ");
INSERT INTO bfz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","तेसरा साथी ये देखी की बऊत दु:खी ऊईगा और तिने सारा आल जाई की आपणे मालको गे बताया। ");
INSERT INTO bfz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“तेबे तेसरे मालके से बुलाया और तेसखे बोलेया, ओ दुष्ट दास! जेबे तैं मांते प्रार्थना कित्ती थी, तेबे मैं तो तेरा सारा कर्ज माफ करी ता था। ");
INSERT INTO bfz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","जेबे मैं तां पाँदे दया कित्ती, तो ताखे एस पाँदे दया नि करनी चाईयो थी? ");
INSERT INTO bfz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","तेबे मालको खे रोष आईगा और तिने से सजा देणे वाल़ेया गे देईता और बोलेया कि जदुओ तक ये कर्ज नि देई देंदा, तदुओ तक एसखे आपू गे ई राखो। ");
INSERT INTO bfz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","तेबेई तो जो कोई तुसा बीचा ते आपणे विश्वासी पाईए रे पाप माफ नि करदा, तो मेरा पिता जो स्वर्गो रे ए, तिना बी तुसा साथे एड़ा ई करना।” ");
INSERT INTO bfz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","जेबे यीशु इना गल्ला बोली चुके, तेबे सेयो गलील प्रदेशो ते चली गे और यरदन नदिया ते पार यहूदिया प्रदेशो रे आए। ");
INSERT INTO bfz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","तेबे एक बड़ी पीड़ तिना पीछे आईगी और तिने सेयो तेती ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तेबे फरीसी तिना खे परखणे खे तिना गे आए और बोलणे लगे, “क्या हर एक बजअ ते आपणी लाड़ी छाडणी खरी गल्ल ए?” ");
INSERT INTO bfz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","यीशुए जवाब दित्तेया, “क्या तुसे नि पड़ी राखेया, जिने सेयो बणाई राखे तिने शुरूओ तेई मर्द और जवाणस बणाई की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘इजी बजअ ते मांणू आपणे माया-बावा ते लग ऊई की आपणिया लाड़िया साथे रणा और सेयो दोनो एक तन ऊणे’ ");
INSERT INTO bfz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","तो एबे सेयो, दो नि पर एक तन ए। इजी री खातर, जो परमेशरे जोड़ी राखेया, तिना खे मांणू लग नि करो।” ");
INSERT INTO bfz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","तिने यीशुए खे बोलया, “तेबे मूसे कऊँ ठराई राखेया कि त्यागपत्र देई की तेसा खे छाडी देओ?” ");
INSERT INTO bfz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","तिने तिना खे बोलेया, “मूसे तुसा रे मनो रे जिद्दी स्वभाव री बजअ ते तुसा खे आपणी लाड़ी छाडणे री आज्ञा दित्ती; पर शुरूओ रे एड़ा नि था। ");
INSERT INTO bfz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","पर आऊँ तुसा खे सच बोलूँआ कि जो कोई व्याभिचार छाडी की ओर केसी बजअ ते आपणी लाड़िया खे त्यागपत्र देई की, केसी दुजिया साथे ब्या करोआ, से व्याभिचार करोआ। जो कोई तेसा छाडी रिया जवाणसा साथे ब्या करोआ, से बी व्याभिचार करोआ।” ");
INSERT INTO bfz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेलेया तिना खे बोलेया, “जे मर्दो रा जवाणसा साथे एड़ा सम्बन्ध ए, तो क्या ब्या करना खरा निए?” ");
INSERT INTO bfz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","तिने तिना खे बोलेया, “सारे ये वचन मानी नि सकदे, बस सेयो ई जिना खे परमेशरे एतेरा दान देई राखेया। ");
INSERT INTO bfz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","कऊँकि कुछ नपुंसक एड़े ए, जो माया रे पेटो तेई एड़े जम्मी रे; और कुछ नपुंसक एड़े ए, जो मांणूए नपुंसक बणाए और कुछ नपुंसक एड़े ए, जिने स्वर्गो रे राज्य खे आपू खेई नपुंसक बणाई राखेया। जो कोई इजी खे समजी सकोआ, ओ समजी लओ।” ");
INSERT INTO bfz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तेबे लोक बच्चेया खे तिना गे ल्याए, ताकि सेयो तिना पाँदे आपणा आथ राखो और प्रार्थना करो; पर चेले तिना खे बकणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीशुए तिना खे बोलेया, “बच्चेया खे मांगे आऊणे देयो और तिना खे ना नि करो, कऊँकि स्वर्गो रा राज्य एड़ेया रा ईए।” ");
INSERT INTO bfz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","तेबे सेयो तिना पाँदे आथ राखी की तेथा ते चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","तेबे एक मांणूए तिना गे आयी की बोलेया, “ओ गुरू! आऊँ एड़ा कुण जा खरा काम करुँ कि अनन्त जीवन पाऊँ?” ");
INSERT INTO bfz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीशुए तेसखे बोलेया, “तूँ मांते पलाईया रे बारे रे कऊँ लगी रा पूछणे? खरा तो एक ईए, पर जे तूँ जिन्दगिया रे जाणा चाओ तो, आज्ञा खे मानेया कर।” ");
INSERT INTO bfz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","तिने यीशुए ते पूछेया, “कुण जी आज्ञा ए?” तिने बोलेया, “अत्या, व्याभिचार, चोरी नि करना और ना चूठी गवाई देणा, ");
INSERT INTO bfz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","आपणे माया-बावा रा आदर करना और आपणे पड़ोसिये साथे आपू जेड़ा प्यार करना।” ");
INSERT INTO bfz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","तिने जवाने तिना खे बोलेया, “इना सबी गल्ला खे तो आऊँ मानूँआ, एबे मांदे किजी गल्ला री कमी ए?” ");
INSERT INTO bfz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीशुए तेसखे बोलेया, “जे तूँ सिद्ध बणना चाया, तो जा, आपणा सारा माल बेची की कंगाल़ा खे देई दे; तेबे ताखे स्वर्गो रे खजाना मिलणा और आयी की, मां पीछे आईजा।” ");
INSERT INTO bfz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","पर इना गल्ला सुणी की से उदास ऊईगा और तेथा ते चली गा, कऊँकि से बऊत साऊकार था। ");
INSERT INTO bfz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तेबे यीशुए आपणे चेलेया खे बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि अमीरा रा स्वर्गो रे राज्य रे जाणा मुश्किल ए। ");
INSERT INTO bfz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","आऊँ तुसा खे फेर बोलूँआ कि परमेशरो रे राज्य रे अमीरा रा जाणा, ऊँटो रा सूईया रे नाके ते निकल़ना सान ए।” ");
INSERT INTO bfz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ये सुणी की चेलेया हैरान ऊई की बोलेया, “तेबे केसरा उद्धार ऊई सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीशुए तिना री तरफा खे देखेया और बोलेया, “मांणूआ ते तो ये ऊई नि सकदा, पर परमेशरो ते सब कुछ ऊई सकोआ।” ");
INSERT INTO bfz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","तेबे पतरसे बोलेया, “देखो, आसे तो सब कुछ छाडी की तुसा पीछे आईगे रे, तो आसा खे क्या मिलणा?” ");
INSERT INTO bfz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि जेबे नई सृष्टि ऊणी और आँऊ माणूं रा पुत्र महिमा रे सिंहासनो रे बैठणा, तो तुसे बी, जो मां पीछे आयी रे, बारा सिंहासनो पाँदे बैठणे और इस्राएलो रे बारा गोत्रा रा न्याय करना ");
INSERT INTO bfz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","और जिने बी आपणे कअर, पाई, बईण, बाओ, माए, लाड़ी, बाल-बच्चे और डोरू मां पीछे छाडी राखे, तेसखे सौ गुणा मिलणा और से अनन्त जीवनो रा अक्कदार ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पर एबे बऊत सारे लोक जो आपणे आपू खे एते दुनिया रे बड़े समजोए, सेयो परमेशरो री नजरा रे छोटे ऊई जाणे, और जिना खे संसार एबु छोटा समजोआ, सेयो परमेशरो री नजरा रे बड़े समजे जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","यीशुए फेर बोलेया, “स्वर्गो रा राज्य केसी कअरो रे मालको जेड़ा ए, जो प्यागा निकल़ेया, ताकि आपणे अँगूरा रे बगीचे रे मजूरदार लगाओ। ");
INSERT INTO bfz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","तेबे तिने मजूरदारा री त्याड़ी एक चाँदिए रे सिक्के रे बराबर देणी कित्ती और सेयो आपणे अँगूरा रे बगीचे रे पेजे। ");
INSERT INTO bfz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","तेबे तिने पईले पईरे बजारो रे जाई की कुछ ओर मजूरदार बेकार खड़े रे देखे। ");
INSERT INTO bfz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","तिने तिना खे बोलेया, ‘तुसे बी अँगूरा रे बगीचे रे जाओ और जो कुछ ठीक ऊणा, से तुसा खे देऊँगा।’ तेबे सेयो बी काम करने खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","तेबे तिने दूजे और तीजे पईरो रे नेड़े निकल़ी की एड़ा ई कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","तेबे एक कंटा दिन रये और तिने फेर दूजे खड़े देखे और तिना खे बोलेया, ‘तुसे पूरे दिन एती बेकार कऊँ खड़े रे रये?’ तिने तेसखे बोलेया, ‘कऊँकि आसे किने त्याड़िया पाँदे निए लगाए रे।’ ");
INSERT INTO bfz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","तिने तिना खे बी बोलेया, ‘तुसे बी अँगूरा रे बगीचे रे काम करने जाओ।’ ");
INSERT INTO bfz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“साँजा अँगूरा रे बगीचे रे मालके आपणे पण्डारिये खे बोलेया, ‘मजूरदारा खे बुलाई की पिछलेया ते लई की आगलेया तक सबी खे मजदूरी देई दे।’ ");
INSERT INTO bfz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जेबे सेयो आए तेबे जो एक कंटे री त्याड़िया पाँदे थे आए रे, तिना खे एक दिनो री त्याड़ी एक चाँदिए रे सिक्के रे बराबर मिली। ");
INSERT INTO bfz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","जो पईले थे आए रे तिने सोचेया कि आसा खे तो जादा मिलणा, पर तिना खे बी एकी दिनो री त्याड़ी एक चाँदिए रे सिक्के रे बराबर मिली। ");
INSERT INTO bfz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","जेबे त्याड़ी मिलीगी, तेबे सेयो मनो रे मालको खे कुड़कुड़ाणे लगे और बोलणे लगे ");
INSERT INTO bfz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘कि जो आसा ते बादो ते आए थे तिने तो एक ई कंटा काम कित्तेया था और तिना खे बी आसा बराबर ई दित्तेया और जिने पूरा दिन काम कित्तेया, पाअर चकेया और तूप सईन कित्ती?’ ");
INSERT INTO bfz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","तिने तिना बीचा ते एकी जणे खे जवाब दित्तेया, ‘ओ दोस्त! मैं तां साथे कोई अन्याय निए कित्तेया रा, क्या तैं ई माखे एक दिनो री त्याड़िया खे नि बोलेया था? ");
INSERT INTO bfz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","जो तेरी त्याड़ी बणो ई, तेस चक और चली जा; मेरी ये इच्छा ए कि जितणा ताखे देऊँ, तिथणा ई पिछले खे बी देऊँ। ");
INSERT INTO bfz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","क्या ये ठीक निए कि आऊँ आपणे मालो साथे जो चाऊँ से करुँ। क्या तूँ मेरे खरे ऊँदे ऊए बी माखे बुरी नजरा ते देखेया?’ ");
INSERT INTO bfz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","पर एबे बऊत सारे लोक जो आपणे आपू खे एते दुनिया रे बड़े समजोए, सेयो परमेशरो री नजरा रे छोटे ऊई जाणे, और जिना खे संसार एबु छोटा समजोआ, सेयो परमेशरो री नजरा रे बड़े समजे जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यीशु यरूशलेम नगरो खे जांदे ऊए आपणे बारा चेलेया खे लग जे लईगे और बाटा रे तिना खे बोलणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“देखो, आसे यरूशलेम नगरो खे चली रे और आँऊ माणूं रा पुत्र, बड़े पुरोईत और शास्त्रिया ते पकड़वाऊणा और तिना आँऊ काणे जोगा ठराणा। ");
INSERT INTO bfz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","तिना आँऊ दुजिया जातिया रे आथो रे देई देणा, ताकि सेयो मेरा मजाक ऊड़ाओ, कोड़े बाओ और क्रूसो पाँदे चढ़ाओ। पर आँऊ तीजे दिने जिऊँदा ऊई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तेबे जब्दिए रे पाऊआ री आम्मा आपणे पाऊआ साथे आयी और यीशुए गे माथा टेकेया और तिना ते कुछ मांगणे लगी। ");
INSERT INTO bfz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","यीशुए तेसा खे बोलेया, “तूँ क्या चाए ई?” तेसे बोलेया, “आऊँ चाऊँई कि तूँ वादा कर कि मेरे ये दोनो पाऊ, तेरे राज्य रे, एक दाँणे और एक खूँजे कनारे बैठो।” ");
INSERT INTO bfz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीशुए जवाब दित्तेया, “तुसे नि जाणदे कि क्या लगी रे मांगणे? जो दुःख आँऊ सईन करने वाल़ा ए, क्या से दुःख तुसे सईन करी सकोए?” तिने बोलेया, “आसे सईन करी सकूँए।” ");
INSERT INTO bfz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","यीशुए तिना खे बोलेया, “तुसे मेरा दुःख तो सईन करी सकोए, पर आपणे दाँणे और खूँजे बठयाल़ना मेरा काम निए, पर जो मेरे पिते री तरफा ते त्यार ए कित्ते रे, तिना राए।” ");
INSERT INTO bfz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ये सुणी की बाकि दस चेलेया खे तिना दूँईं पाईया पाँदे रोष आया। ");
INSERT INTO bfz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","यीशुए सेयो आपू गे बुलाए और बोलेया, “तुसे जाणोए कि दूजी जातिया रे हाकिम तिना पाँदे राज करोए और जो बड़े ए, सेयो तिना पाँदे अक्क जमाओए। ");
INSERT INTO bfz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पर तुसा बीचे एड़ा नि ऊणा; पर जो कोई तुसा बीचा ते बड़ा ऊणा चाओआ, से तुसा रा दास बणो ");
INSERT INTO bfz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","और जो तुसा बीचा ते प्रदान ऊणा चाओआ, से तुसा रा दास बणो। ");
INSERT INTO bfz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","जेड़ा की माणूं रा पुत्र, से इजी खे नि आयी रा कि तेसरी देख-बाल़ करो, पर इजी खे आयी रा कि से देख-बाल़ करो और बऊत जणेया खे छुड़ाणे री खातर आपणे प्राण देई देओ।” ");
INSERT INTO bfz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जेबे सेयो यरीहो नगरो ते निकल़ने लगी रे थे, तेबे एक बड़ी पीड़ तिना पीछे आईगी। ");
INSERT INTO bfz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","तेबे दो अन्दे, जो सड़का रे कनारे बैठी रे थे, तिने जेबे ये सुणेया कि यीशु जाणे लगी रे, तो सेयो आक्का पायी की बोलणे लगे, “ओ प्रभु! दाऊदो री ल्वाद, आसा पाँदे दया कर।” ");
INSERT INTO bfz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","लोक तिना खे बकणे लगे कि चुप रओ, पर सेयो ओर बी चींगी की बोलणे लगे, “ओ प्रभु! दाऊदो री ल्वाद, आसा पाँदे दया कर।” ");
INSERT INTO bfz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तेबे यीशुए खड़े ऊई की सेयो बुलाए और बोलेया, “तुसे क्या चाओए कि आऊँ तुसा खे करुँ?” ");
INSERT INTO bfz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","तिने बोलेया, “ओ प्रभु! ये कि म्हारिया आखी खुली जाओ” ");
INSERT INTO bfz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीशुए खे तिना पाँदे तरस आया और तिने तिना रिया आखिया छूँईया और सेयो तेबुई देखणे लगे और सेयो तिना पीछे चलणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","जेबे सेयो यरूशलेम नगरो रे नेड़े पऊँछी की जैतून पाह्ड़ो पाँदे बैतफगे गांव रे नेड़े आए, तेबे यीशुए आपणे दो चेले ये बोली की पेजे ");
INSERT INTO bfz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“आपणे सामणे रे गांव रे जाओ, तेती पऊँछदे ई तुसा खे एक गह्दी बानी री मिलणी और तेसा साथे एक बच्चा तुसा खे मिलणा, तिना खे खोली की मांगे ली आओ। ");
INSERT INTO bfz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","जे तुसा खे कोई कुछ बोलोगा, तेबे तिना खे बोलणा कि प्रभुए खे इना ते कुछ मतलब ए, तेबे तिना तेबुई से पेजी देणे।” ");
INSERT INTO bfz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ये तेबे ऊआ ताकि जो वचन भविष्यबक्ते बोलेया था, से पूरा ओ; ");
INSERT INTO bfz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सिय्योनो री बेटिया खे बोलो, ‘देख, तेरा राजा तांगे आओआ, से नम्र ए और गह्दे पाँदे बैठी रा, बल्कि लादूओ रे बच्चे पाँदे।’ ” ");
INSERT INTO bfz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेलेया जाई की जिंयाँ यीशुए बोलेया था तिंयाँ ई कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","गह्दिया और बच्चे खे ल्याई की तिना पाँदे आपणे टाले पाए और यीशु तिना पाँदे बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","तेबे बऊत जणेया आपणी-आपणी चादरी बाटा रे बछाइतिया और कईए खजूरो रिया डाल़िया बाडी-बाडी की तिना रे स्वागतो खे की बछाइतिया। ");
INSERT INTO bfz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","जो पीड़ आगे-आगे और पीछे-पीछे चली री थी, से आक्का पाई-पाई की बोलणे लगी री थी, “दाऊदो री ल्वादा खे होशन्ना; धन्य ए से, जो प्रभुए रे नाओं ते आओआ, स्वर्गो रे होशन्ना।” ");
INSERT INTO bfz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जेबे सेयो यरूशलेमो नगरो रे पऊँछे, तो सारे नगरो रे अलचल ऊईगी और लोक बोलणे लगे, “ये कुण ए?” ");
INSERT INTO bfz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","लोके बोलेया, “ये गलीलो रे नासरतो रा भविष्यबक्ता यीशु ए।” ");
INSERT INTO bfz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीशुए परमेशरो रे मन्दरो रे जाई की सेयो सब जणे निकयाल़ी ते, जो लेण-देण लगी रे थे करने और सर्राफो रे पीढ़े और कबूतरा खे बेचणे वाल़िया चौकिया मूँदिया करी तिया। ");
INSERT INTO bfz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","और तिना खे बोलेया, “लिखी राखेया, ‘मेरे कअरो खे प्रार्थना रा मन्दर बोलोए,’ पर तुसे से डाकूआ रा डवार बणाई ता रा।” ");
INSERT INTO bfz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","तेबे अन्दे और लंगड़े, मन्दरो रे तिना गे आए और तिने सेयो ठीक करी ते। ");
INSERT INTO bfz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","पर जेबे, बड़े पुरोईत और शास्त्रिए, ये अचम्बे वाल़े काम, जो तिने कित्ते थे और लोका खे मन्दरो रे “दाऊदो री ल्वादा खे होशन्ना,” बोलदे उए देखेया, तो सेयो बऊत रोषे ऊईगे ");
INSERT INTO bfz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","और बोलणे लगे, “क्या तूँ सुणने लगी रा कि लोक क्या लगी रे बोलणे?” यीशुए तिना खे बोलेया, “आ; क्या तैं ये कदी नि पढ़ेया कि, ‘बाल़क और दूद पीणे वाल़े बच्चेया रे मुंओ ते तैं अपार स्तुति कराई?’ ” ");
INSERT INTO bfz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तेबे सेयो तिना खे छाडी की नगरो ते बारे बैतनिय्याहो खे गए, और राथियो खे तेथी रए। ");
INSERT INTO bfz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","प्यागा जेबे सेयो नगरो खे आऊणे लगी रे थे, तो तिना खे पूख लगी। ");
INSERT INTO bfz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","तेबे तिने सड़का रे कनारे दाऊगल़े रा एक डाल़ देखी की तेसगे चली गे, पर तिदे पत्तेया खे छाडी की ओर कुछ नि था, तेबे तिने बोलेया, “आजो ते तांदे कोई फल नि लगणा!” और दाऊगल़े रा डाल़ तेबुई सूकी गा। ");
INSERT INTO bfz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ये देखी की चेले हैरान ऊईगे और पूछणे लगे, “ये दाऊगल़े रा डाल़ एबु ई किंयाँ सूकी गा?” ");
INSERT INTO bfz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीशुए तिना खे जवाब दित्तेया, “आऊँ तुसा खे सच लगी रा बोलणे कि जे तुसे विश्वास राखो और शक नि करो तो, तुसा इतणा ई नि करना, जो एस दाऊगल़े रे डाल़ो साथे ऊआ; पर जे एस पाह्ड़ो खे बी बोलोगे, कि ‘पट्ठी जा, और समुद्रो रे पड़ी जा,’ तो ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","और जो कुछ तुसे प्रार्थना रे विश्वासो साथे मांगोगे, तो से सब तुसा खे मिली जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","जेबे सेयो मन्दरो रे उपदेश लगी रे थे करने, तेबे बड़े पुरोईत और लोका रे बुजुर्ग तिना गे आए और पूछणे लगे, “तूँ इना कामा केसरे अक्को ते करेया? और ताखे ये अक्क किने देई राखेया?” ");
INSERT INTO bfz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीशुए तिना खे जवाब दित्तेया, “आऊँ बी तुसा ते एक गल्ल पुछूँआ, जे तुसे बताओगे, तो मां बी बताई देणा कि आऊँ इना कामा केस अक्को ते करूँआ। ");
INSERT INTO bfz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्ने रा बपतिस्मा केथा ते था? स्वर्गो रिया तरफा ते या मांणूए रिया तरफा ते?” सेयो आपू बीचे बिचार करने लगे, “जे आसे बोलूँगे कि ‘स्वर्गो री तरफा ते’, तो एस पूछणा, ‘तेबे तुसे तेसरा विश्वास कऊँ नि कित्तेया?’ ");
INSERT INTO bfz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","और जे बोलूँगे, ‘मांणूए री तरफा ते’, तो आसा खे लोका रा डर ए, कऊँकि यो सब तेसखे भविष्यबक्ता जाणो थे।” ");
INSERT INTO bfz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","तो, तेबे तिने यीशुए खे जवाब दित्तेया, “आसे नि जाणदे।” तेबे तिने बी तिना खे बोलेया, “तेबे आऊँ बी तुसा खे कुछ नि बतांदा कि इना कामा केसरे अक्को ते करूँआ। ");
INSERT INTO bfz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“एस उदारणो रे बारे रे तुसे क्या समजोए? केसी मांणूए रे दो पाऊ थे; तिने पईले पाऊए गे जाई की बोलेया, ‘ओ पाऊ, आज अँगूरा रे बगीचे रे जा और काम कर।’ ");
INSERT INTO bfz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","तिने बोलेया, ‘मां नि जाणा,’ पर से बादो ते मनो रे पछताई की चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","तेबे पिते दूजे गे जाई की बी एड़ा ई बोलेया, तिने जवाब दित्तेया, ‘अच्छा जी जाऊँआ,’ पर गया नि। ");
INSERT INTO bfz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","इना दूँईं बीचा ते किने पिते री इच्छा पूरी कित्ती?” तिने बोलेया “पईले।” यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि कर लणे वाल़े और वेश्या, तुसा ते पइले परमेशरो रे राज्य रे जाओए। ");
INSERT INTO bfz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","कऊँकि बपतिस्मा देणे वाल़ा यूहन्ना तर्मो री बाट बतांदे ऊए तुसा गे आया और तुसे तेसरा विश्वास नि कित्तेया, पर कर लणे वाल़े और वेश्या तेसरा विश्वास कित्तेया और तुसे ये देखी की बादो ते पनि पछताए कि तेसरा विश्वास करी लंदे। ");
INSERT INTO bfz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“एक ओर उदारण सुणो कि एक करेलू मालक था। जिने अँगूरा रा बगीचा लगाया और तिजी रे चऊँ कनारे बाड़ लगाया और अँगूरा रे रसो खे पात्थरो दे एक गड्डा खणेया, जुगाल़ी बणाई और ठेकेदारा खे तिजी रा ठेका देई की परदेशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जेबे फलो रा बखत नेड़े आया तेबे तिने आपणे दास तिजी रा फल लणे तिना ठेकेदारा गे पेजे। ");
INSERT INTO bfz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पर ठेकेदारे तेसरे दास पकड़ी की कोई कूटे, कोई काई ते और केसी खे पात्थर बाए। ");
INSERT INTO bfz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","तेबे तिने पईले ते जादा दास पेजे, पर तिने तिना साथे बी तेड़ा ई कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आखरी रे तिने आपणे पाऊए तिना गे ये सोची की पेजेया कि तिना मेरे पाऊए रा आदर करना। ");
INSERT INTO bfz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","पर ठेकेदारे पाऊए खे देखी की आपू बीचे ये बोलेया, ‘ये तो बारस ए, आओ एसखे काई देऊँए और एसरी जायदात लयी लऊँए।’ ");
INSERT INTO bfz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","तेबे तिने से पकड़ेया और अँगूरा रे बगीचे ते बारे निकयाल़ी की काई ता। ");
INSERT INTO bfz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","बादो ते जेबे अँगूरा रे बगीचे रा मालक आऊणा, तो तेस तिना ठेकेदारा साथे क्या करना?” ");
INSERT INTO bfz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","तिने यीशुए खे जवाब दित्तेया, “तेस बुरे लोक बुरी तरअ ते नाश करने और अँगूरा रे बगीचे रा ठेका केसी ओरी ठेकेदारा गे देई देणा। जिना बखतो पाँदे तेसखे फल देई देया करना।” ");
INSERT INTO bfz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीशुए तिना खे बोलेया, “क्या तुसे पवित्र शास्त्रो रे ये कदी नि पढ़ेया, “ ‘जो पात्थर राजमिस्त्रिए नकम्मा ठराया, सेई कूणे रे सिरे रा पात्थर ऊईगा। ये प्रभुए रिया तरफा ते ऊआ, पर आसा री नजरा रे नऊखा ईए’? ");
INSERT INTO bfz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“तेबेई तो आऊँ तुसा खे बोलूँआ कि परमेशरो रा राज्य तुसा ते लई लणा और एड़िया जातिया गे देई देणा, जो फल ल्याओ। ");
INSERT INTO bfz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","जो एस पात्थरो पाँदे पड़ना, से चूर-चूर ऊई जाणा और जेस पाँदे ये पड़ना, तेस से पीसी देणा।” ");
INSERT INTO bfz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","बड़े पुरोईत और फरीसी तिना रे उदारण सुणी की समजी गे कि सेयो आसा रे बारे रे लगी रे बोलणे। ");
INSERT INTO bfz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","तेबे तिने सेयो पकड़ने चाए, पर लोका ते डरी गे, कऊँकि सेयो तिना खे भविष्यबक्ता मानो थे। ");
INSERT INTO bfz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","तेबे फेर यीशु तिना साथे उदारणा रे बोलणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“स्वर्गो रा राज्य तेस राजे जेड़ा ए, जिने आपणे पाऊए रा ब्या कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","तेबे तिने आपणे दास पेजे कि जाओ, निऊँदा दित्ते रे लोका खे ब्याओ री पाट्टिया रे बुलाओ, पर तिने आऊणा नि चाया। ");
INSERT INTO bfz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","तेबे तिने आपणे दास ये बोली की पेजे, निऊँदा दित्ते रे लोका खे बोलो, देखो, आऊँ पाट्टी त्यार करी चुकेया रा। मेरे बल़द और पाल़े रे डांगर सब बाडी ते रे; और सब कुछ त्यार ए, ब्याओ री पाट्टिया रे आओ। ");
INSERT INTO bfz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पर तिने कोई परवा नि कित्ती और कोई आपणे डोरूआ खे और कोई आपणे कामो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","और जो बचे, तिने सेयो दास पकड़े और तिना रा मजाक ऊड़ाया और काई ते। ");
INSERT INTO bfz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","जेबे राजे ये सुणेया तेबे तिना खे रोष आईगा और तिने आपणी सेना पेजी और जो अत्यारे थे, तिना रा सत्यानाश करी ता और तिना रे नगर फूकी ते। ");
INSERT INTO bfz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तेबे तिने आपणे दासा खे बोलेया, ब्याओ री रोटी तो त्यार ए, पर खाणे वाल़े नि आए। ");
INSERT INTO bfz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","एबे एड़ा करो कि चौको रे जाओ और जितणे लोक तुसा खे मिलोगे, तिना खे रोटी खाणे ली आओ। ");
INSERT INTO bfz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","तेबे तिने दासे सड़का दे जाई की क्या खरे बुरे जो बी मिले सबी खे कट्ठे करी की ली आया और ब्याओ रा कअर मांणूआ साथे फरी गा। ");
INSERT INTO bfz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“जेबे राजा मईमाना खे देखणे पीतरे गया, तेबे तिने देखेया कि एक मांणूए ब्याओ रे टाले नि थे पइने रे जो राजे ब्याओ खे तेसखे पईनणे खे दित्ते थे। ");
INSERT INTO bfz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","तिने तेसते पूछेया, ओ दोस्त, तूँ एती ब्याओ रे टाले पइनी की कऊँ नि आयी रा, जो ताखे मैं पईनणे खे दित्ते थे? और से मांणू चुप ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तेबे राजे, दासा खे बोलेया कि एसरे आथ-पैर बानो और एसखे बारे न्हेरे रे राखी देओ, तेती रोणा और दाँद किरड़ना ई ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","कऊँकि बुलाए रे तो बऊत ए, पर चुणे रे थोड़े ईए।” ");
INSERT INTO bfz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तेबे फरीसी गए और आपू बीचे सोच-बिचार लगे करने कि एसखे किंयाँ फसाइए? ");
INSERT INTO bfz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","तेबे यहूदी अगुवे यीशु गल्ला रे फसाणे री तंईं कई फरीसी चेले और हेरोदेस राजे रा समर्थन करने वाल़े यहूदी तिना गे पेजे। और तिने आयी की तिना खे बोलेया, “ओ गुरू! आसे जाणूंए कि तुसे सच्चे और परमेशरो री बाट सच्चाईया साथे सिखाओए, और केसी री परवा नि करदे, कऊँकि तुसे मांणूए रा मूँ देखी की गल्ल नि करदे। ");
INSERT INTO bfz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","तो तुसे आसा खे बताओ कि तुसे क्या समजोए? कैसरो खे कर देणा खरा ए, या नई।” ");
INSERT INTO bfz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीशुए खे तिना री दुष्टता पता थी और तिने बोलेया, “ओ कपटियो; माखे कऊँ परखोए? ");
INSERT INTO bfz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","करो रा सिक्का मांगे दखाओ।” तेबे सेयो तिना गे एक चाँदिए रा सिक्का ली आए। ");
INSERT INTO bfz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","तिने तिना ते पूछेया, “ये मूर्ति और ये नाओं केसरा ए?” ");
INSERT INTO bfz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","तिने बोलेया, “कैसरो रा।” तेबे तिने बोलेया, “जो कैसरो राए से कैसरो खे और जो परमेशरो राए से परमेशरो खे देओ।” ");
INSERT INTO bfz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ये सुणी की सेयो हैरान ऊईगे और तिना खे छाडी की चली गे। ");
INSERT INTO bfz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","तेसी दिने सदूकी, जो बोलो थे कि जो मरी जाओए तिना रा दुबारा जन्म नि ऊँदा, यीशुए गे आए और पूछणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ओ गुरू, मूसे बोलेया था कि जे कोई बिना ल्वादा ते मरी जाओ, तो तेसरा पाई तेसरी लाड़िया साथे ब्या करी लओ और आपणे पाईए खे वंश पैदा करो। ");
INSERT INTO bfz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","एबे आसा रे सात पाई थे, पईला पाई ब्या करी की बिना ल्वादा तेई मरी गा और ल्वाद ना ऊणे री बजअ ते आपणी लाड़िया खे आपणे पाईए खे छाडी गा। ");
INSERT INTO bfz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","तिंयाँ ई दूजे और तीजे बी एड़ा ई कित्तेया और साता साथे एड़ा ई ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","सबी ते बादो ते, से जवाणस बी मरी गी। ");
INSERT INTO bfz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","जेबे से जिऊँदी ऊणी तो केसरी लाड़ी ऊणी? कऊँकि से तो सबी री लाड़ी रई चुकी थी।” ");
INSERT INTO bfz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीशुए तिना खे जवाब दित्तेया, “तुसे पवित्र शास्त्र और परमेशरो री सामर्थ नि जाणदे, तेबेई तो तुसा ते पूल ऊई री। ");
INSERT INTO bfz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","कऊँकि जेबे जिऊँदे ऊणे, तेबे ब्या-शादिया नि ऊणिया, पर सेयो स्वर्गो रे परमेशरो रे स्वर्गदूतो जेड़े ऊणे। ");
INSERT INTO bfz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","पर क्या तुसे, मरे रे जिऊँदे ऊणे रे बारे रे ये वचन नि पढ़ेया, जो परमेशरे तुसा खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","आऊँ अब्राहमो रा परमेशर, इसहाको रा परमेशर और याकूबो रा परमेशर आ? सेयो मरे रेया रे नि, पर जिऊँदेया रे परमेशर ए।” ");
INSERT INTO bfz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ये सुणी की लोक तिना रे उपदेशो ते हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जेबे फरीसिये सुणेया कि तिने सदूकिये रे मूँ बन्द करी ते, तो सेयो कट्ठे ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","तेबे तिना बीचा ते एक धर्मशास्त्रीए परखणे खे तिना ते पूछेया, ");
INSERT INTO bfz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ओ गुरू! बिधानो रे कुण जी गल्ल बड़ी ए?” ");
INSERT INTO bfz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","यीशुए तेसखे बोलेया, “तूँ परमेशर आपणे प्रभुए साथे, आपणे पुरे मन, आपणे पुरे प्राण और आपणी पूरी अक्ला साथे प्यार राख। ");
INSERT INTO bfz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","बड़ी और मुख्य आज्ञा तो येईए। ");
INSERT INTO bfz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","और एसा ई जेड़ी ये दूजी बी ए, ‘तूँ आपणे पड़ोसिये साथे आपू जेड़ा प्यार राख।’ ");
INSERT INTO bfz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","येई दो आज्ञा सारा बिधान और भविष्यबक्तेया रा आधार ए।” ");
INSERT INTO bfz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जेबे फरीसी कट्ठे थे, तेबे यीशुए तिना ते पूछेया, ");
INSERT INTO bfz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसीह रे बारे रे तुसे क्या समजोए? से केसरी ल्वाद ए?” फरीसिये बोलेया, “दाऊदो री।” ");
INSERT INTO bfz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","तेबे तिने फेर पूछेया, “तेबे दाऊद आत्मा रे परी की तेसखे प्रभु कऊँ बोलोआ? ");
INSERT INTO bfz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","प्रभुए, मेरे प्रभुए खे बोलेया, ‘मेरे दाँणे बैठ, जदुओ तक आऊँ तेरे बैरिया खे तेरे पैरा निठे नि ल्याई देऊँ।’ ");
INSERT INTO bfz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","तो, जेबे दाऊद तेसखे प्रभु बोलोआ, तो से तेसरा पुत्र किंयाँ ऊआ?” ");
INSERT INTO bfz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","इजी रा जवाब कोई नि देई सकेया। पर तिजी ते बादो ते केसी खे बी तिना ते कुछ पूछणे री इम्मत नि ऊई। ");
INSERT INTO bfz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तेबे यीशुए पीड़ा खे और आपणे चेलेया खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“शास्त्री और फरीसी, मूसे रे बिधानो खे अक्को साथे बताओ थे। ");
INSERT INTO bfz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","तो, सेयो तुसा खे जो कुछ बोलो, से करना और मानणा, पर तिना जेड़े काम नि करना, कऊँकि सेयो ओरी खे सिखाओ तो आए, पर आपू तिना कामा खे करदे नि। ");
INSERT INTO bfz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","सेयो लोका खे एड़े-एड़े कड़े नियम मानणे खे मजबूर करो थे जिना खे मानणा तिना खे बऊत कठण ए। पर आपू तिना नियमा खे मानणे री बी कोशिश तक नि करदे। ");
INSERT INTO bfz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","सेयो आपणे सारे काम लोका खे दखाणे री तंईं करोए, सेयो आपणे जन्त्र चौड़े करोए और आपणे टालेया रे पल्ले बड़ाओ ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","पाट्टिया रे खास-खास जगा और प्रार्थना रे कअरो रे खास-खास जगा ");
INSERT INTO bfz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","और बजारो रे नमस्ते और मांणूआ ते गुरू बुलाणा तिना खे अच्छा लगोआ। ");
INSERT INTO bfz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पर तुसे आपणे आपू खे गुरू नि बुलवाणा; कऊँकि तुसा रा एक ई गुरूए और तुसे सब आपू बीचे पाई ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","तरतिया रे केसी खे आपणा पिता नि बोलणा, कऊँकि तुसा रा एक ई पिता ए, परमेशर जो स्वर्गो रे ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","और मालक पनि बुलाणा, कऊँकि तुसा रा एक ई मालक ए, मतलब-मसीह। ");
INSERT INTO bfz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जो तुसा बीचा ते बड़ा ओ, से तुसा रा दास बणो। ");
INSERT INTO bfz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जो कोई आपू खे बड़ा बणाओगा, से छोटा ऊणा; और जो कोई आपू खे छोटा बणाओगा से बड़ा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ओ कपटी शास्त्री और फरीसियो तुसा पाँदे हाय! तुसे मांणूआ खे स्वर्गो रे राज्य रा द्वार बंद करोए। तुसे ना तो आपू ई तेती जांदे और ना ई तिदे जाणे वाल़ेया खे जाणे देंदे। ");
INSERT INTO bfz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ओ कपटी शास्त्री और फरीसियो तुसा खे हाय! तुसे बिदुआ रे कअर खाई जाओए और दखाणे री तंईं बऊत देर तक प्रार्थना करदे रओए, तेबेई तो तुसा खे जादा सजा मिलणी। ");
INSERT INTO bfz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ओ कपटी शास्त्री और फरीसियो तुसा खे हाय! तुसे एकी जणे खे आपणे मतो रे ल्याऊणे री तंईं सारे जल और थलो रे फिरोए और जेबे से तुसा रे मतो रे आयी जाओआ, तो तेसखे आपू ते दुगणा नरको री सजा जोगा बणाई देओए। ");
INSERT INTO bfz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ओ अन्दे अगुओ तुसा खे हाय! जो बोलोए कि जे कोई मन्दरो री कसम खाओ तो कुछ नि, पर जो मन्दरो रे सूईने री कसम खाओगा तो तिना खे तेसा कसमा खे पूरा करना जरूरी ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ओ मूर्खो और अन्दो कुण बड़ा ए, सुईना या से मन्दर, जेते साथे सुईना पवित्र ओआ? ");
INSERT INTO bfz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","फेर बोलोए कि जे कोई बेदिया री कसम खाओ तो कुछ निए, पर से पेंट जो तिजी पाँदे ए, तेतेरी कसम खाओगा, तो तिना खे तेसा कसमा खे पूरा करना जरूरी ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ओ अन्दो! कुण बड़ा ए, पेंट या बेदी; जेते साथे पेंट पवित्र ओई? ");
INSERT INTO bfz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","तेबेई तो, जो बेदिया री कसम खाओआ, से तेतेरी और जो बी तेते पाँदे ए, तेतेरी बी कसम खाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","जो मन्दरो री कसम खाओआ, से तेतेरी और तिदे रणे वाल़ेया री बी कसम खाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","जो स्वर्गो री कसम खाओआ, से परमेशरो रे सिंहासनो री और तिदे बैठणे वाल़ेया री बी कसम खाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ओ कपटी शास्त्री और फरीसियो तुसा खे हाय! तुसे पदीने, संफ और जीरे रा दसुआ पाअग देओए, पर तुसे बिधानो रिया गूढ़ गल्ला मतलब न्याय, कृपा और विश्वास छाडी ते रे, तुसा खे चाईयो था कि इना खे बी करदे रंदे और तिना खे पनि छाडदे। ");
INSERT INTO bfz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ओ अन्दे अगुओ! तुसे छोटिया-छोटिया गल्ला रे नियम तो ईंयां मानी लओए जिंयाँ माच्छरो खे पाणिए ते कनारे ताल़ी देओए! पर परमेशरो री खास आज्ञा खे टाल़ना, तुसा खे ऊँटो खे निगल़ी जाणे रे बराबर ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ओ कपटी शास्त्रियो और फरीसियो तुसा खे हाय! तुसे तिना कटोरे और थाल़िया जेड़े ए, जिना खे पाँदा-पाँदा ते तो मांजी लओए, पर पितरे तिना रे गन्दगी परी री रओई। ");
INSERT INTO bfz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","हे अन्दे फरीसी, पईले कटोरे और थाल़िया खे पीतरा ते मांजी लओ ताकि से बारा ते बी साफ ओ। ");
INSERT INTO bfz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ओ कपटी शास्त्रियो और फरीसियो तुसा खे हाय! तुसे चूना फिरी री कब्रा जेड़े ए, जो पाँदा ते तो सुन्दर दिशोई पर, पर पीतरा ते मरेया रिया आड्डिया और सारिया गन्दे कामो साथे फरी रिये। ");
INSERT INTO bfz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","तिंयाँ ई तुसे बी, सामणे तो आपणे-आपू खे लोका खे तर्मी दखाओ ए, पर पीतरो ते कपट और पापो साथे फरे रे ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ओ कपटी शास्त्रियो और फरीसियो तुसा खे हाय! तुसे भविष्यबक्तेया रिया कब्रा सजाओए और तर्मिया रे समारक बणाओए। ");
INSERT INTO bfz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","और बोलोए, ‘जे आसे आपणे बाप-दादेया रे बखतो रे ऊँदे, तो भविष्यबक्तेया रिया अत्या रे तिना रा साथ नि देंदे।’ ");
INSERT INTO bfz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","इजी ते तो तुसे आपू ई आपणे खलाफ गवाई देओए कि तुसे भविष्यबक्तेया खे काणे वाल़ेया रे ल्वाद ए। ");
INSERT INTO bfz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","तो तुसे आपणे बाप-दादेया रे जो बुरे काम तिने करी राखे तिजी खे पूरा करने वाल़े ओ। ");
INSERT INTO bfz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ओ जईरीले सापो जेड़े लोको, और जईरीले सापो री ल्वाद! तुसे ये किंयाँ सोचा ला तुसे नरको रे दण्डो ते बची जाणे? ");
INSERT INTO bfz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","तेबेई तो देखो, आऊँ तुसा गे भविष्यबक्ता खे, अक्लमंदा खे और शास्त्रिया खे पेजुँआ और तुसा तिना बीचा ते कुछ लोक काणे और कुछ लोक क्रूसो पाँदे चढ़ाई देणे और कईया खे आपणे प्रार्थना रे कअरो रे कोड़े बाणे और सेयो एकी नगरो ते दूजे नगरो खे नठाणे। ");
INSERT INTO bfz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","जिदे तर्मी हाबिलो ते लई की बिरिक्याहो रा पाऊ जकरयाहो तक, जो तुसे मन्दरो रे और बेदिया बीचे काए थे, जितणे तर्मिया रा खून तरतिया रे बयी रा, तेतेरी सजा तुसा सबी खे मिलणी। ");
INSERT INTO bfz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","आऊँ तुसा खे सच बोलूँआ कि इना सबी अत्या री सजा एस बखतो रे सबी लोका खे मिलणी। ");
INSERT INTO bfz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ओ यरूशलेमो रे लोको, ओ यरूशलेमो रे लोको! तूँ जो भविष्यबक्तेया खे काओआ और जो तांगे पेजी राखे, तिना खे पात्थर बाएआ, कितणी बार मैं चाया कि जिंयाँ मुर्गी आपणे बच्चेया खे आपणे पंखो निठे कट्ठा करी की समाल़ोई, तिंयाँ ई आऊँ बी चाऊँआ कि तेरे बाल़का खे कट्ठा करी की समाल़ुँ। पर तुसे नि चाया। ");
INSERT INTO bfz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देखो, तुसा रा कअर तुसा खे उजाड़ी की छाडीता। ");
INSERT INTO bfz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","कऊँकि आऊँ तुसा खे बोलूँआ कि एबुए ते जदुओ तक तुसे नि बोलोगे, ‘धन्य ए सेयो, जो प्रभुए रे नाओं ते आओए’ तदुओ तक तुसा आऊँ फेर कदी नि देखणा।” ");
INSERT INTO bfz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जेबे यीशु मन्दरो ते निकल़ी की जाणे लगी रे थे, तेबे तिना रे चेले मन्दरो री रचना दखाणे खे तिना गे आए। ");
INSERT INTO bfz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","यीशुए तिना खे बोलेया, “तुसे जो ये सब कुछ लगी रे ना देखणे, आऊँ तुसा खे सच लगी रा बोलणे कि एती जो पात्थरो पाँदे पात्थर लगी रे, सब टाल़े जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जेबे यीशु जैतूनो पाह्ड़ो पाँदे बैठे रे थे, तेबे चेलेया लग जे आयी की तिना खे बोलेया, “आसा गे बताओ कि यो गल्ला कदी ऊणिया? तुसा रे आऊणे रा और दुनिया रे आखरी रा क्या चिह्न् ऊणा?” ");
INSERT INTO bfz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीशुए तिना खे जवाब दित्तेया, “चौकस रओ कि कोई तुसा खे बईकाओ नि। ");
INSERT INTO bfz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","कऊँकि बऊत जणे एड़े ऊणे जो, मेरे नाओं ते आऊणे और बोलणा, ‘आऊँ मसीह ए’, और तिना बऊत जणे भरमाणे। ");
INSERT INTO bfz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुसा लड़ाई और लड़ाईया रे बारे रे सुणो, पर कबराणा नि कऊँकि इना रा ऊणा जरूरी ए, पर तेस बखते अंत नि ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","कऊँकि जातिया पाँदे जातिया और राज्य पाँदे राज्य अमला करना और जगा-जगा अकाल़ पड़ना और ईल्लण ऊणे। ");
INSERT INTO bfz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","इना सबी गल्ला ते, पीड़ा री शुरूआत ऊणी। ");
INSERT INTO bfz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","तेबे सेयो लोक जो तुसा रे खलाफ ए क्ल़ेश देणे खे तुसे पकड़वाणे और तुसे काणे और मां पाँदे विश्वास करने री बजअ ते सबी जातिया रे लोका तुसा ते बैर राखणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तेबे बऊत जणेया विश्वास करना छाडी देणा और एकी-दूजे पकड़वाणे और एकी-दूजे ते बैर राखणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","बऊत सारे चूठे भविष्यबक्ता आऊणे और तिना बऊत लोक भरमाणे। ");
INSERT INTO bfz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","पापो रे बड़ने ते बऊत जणेया एकी दूजे साथे प्यार नि राखणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पर जो आखरी तक सब्र राखोगा, तेसरा ई उद्धार ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","और राज्य रा ये सुसमाचार सारी दुनिया रे प्रचार ऊणा, ताकि सब देशो रे लोका खे सुसमाचारो खे मानणे रा मौका मिलो, तेबे दुनिया रा अन्त आयी जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“पढ़ने वाल़ा समजी लओ, जेबे तुसे, तेसा उजाड़ने वाल़ी घृणित चीज जेतेरे बारे रे दानिय्यल भविष्यबक्ते बोलेया था, जेती ठीक निए तेती मतलब मन्दरो रे खड़ी री देखो। ");
INSERT INTO bfz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","तेबे जो यहूदिया रे ओ, सेयो पाह्ड़ो खे नठी जाओ। ");
INSERT INTO bfz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जो कोई छतो पाँदे ओ, सेयो आपणे कअरे कुछ बी लणे खे थाले नि आओ और ना ई पीतरे जाओ ");
INSERT INTO bfz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","“और जो कोई डोरूआ रे ओ, सेयो आपणे टाले लणे पीछे नि आटो। ");
INSERT INTO bfz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","तिना दिना रे जो गर्भवती ऊणी और जो दूद पल़याणे वाल़ी ऊणी तिना खे हाय! हाय! ");
INSERT INTO bfz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","प्रार्थना करेया करो कि तुसा खे ठण्डी रे और आरामो रे दिने नठणा नि पड़ो। ");
INSERT INTO bfz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","कऊँकि तेस बखते एड़ा पारी क्ल़ेश ऊणा, जेड़ा दुनिया री शुरूओ ते लई की एबुए तक कदी नि ऊआ और ना ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","जे सेयो दिन कटाए रे नि ऊँदे, तो कोई प्राणी नि बचणा था; पर चुणे ऊए री बजअ ते सेयो दिन कटाए जाणे। ");
INSERT INTO bfz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","तेस बखते जे कोई तुसा खे बोलो कि देखो, मसीह एती ए, या तेती ए, तो विश्वास नि करना। ");
INSERT INTO bfz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“कऊँकि चूठे मसीह और चूठे भविष्यबक्ता खड़े ऊणे और तिना बड़े-बड़े चिह्न् और अचम्बे रे काम दखाणे, जे ऊई सको तो जो परमेशरो रे चूणे रे ए, तिना खे बी भरमाई देओ। ");
INSERT INTO bfz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देखो, मैं पइले तेई तुसा खे ये सब कुछ बोली ता रा। ");
INSERT INTO bfz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","तेबे जे सेयो तुसा खे बोलो, देखो, से जंगल़ो रे ए, तो चली नि जाणा, या देखो, से छतो पाँदे ए, तो विश्वास नि करना। ");
INSERT INTO bfz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“कऊँकि जिंयाँ बिजल़ी पूर्वो ते निकल़ी की पच्छमो तक चमकोई, तिंयाँ ई मां माणूं रे पुत्रो रा आऊणा बी ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","जेती लोथ ऊणी, तेथी इल्ला कट्ठिया ऊणिया। ");
INSERT INTO bfz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“तिना दिना रे, तेस क्ल़ेशो ते बाद सूरजो रा चमकदा प्रयासा न्हेरा पड़ी जाणा और चांदे प्रयासा नि देणा। और सर्गो ते तारे छुटणे शुरू ऊणे और सर्गो रिया शक्तिया इलाईया जाणिया। ");
INSERT INTO bfz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तेबे माणूं रे पुत्रो रा चिह्न् सर्गो रे दिशणा। तेबे तरतिया रे सबी कुल़ा रे लोका छातिया पीटणियां और माणूं रा पुत्र बड़ी सामर्थ और महिमा साथे सर्गो रे बादल़ा पाँदे आऊँदे ऊए देखणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","तेस तुरहिया रे बड़ी आवाजा साथे, आपणे स्वर्गदूत पेजणे और तिना सर्गो रे एकी कनारे ते लई की दूजे कनारे तक, चारो दिशा रे तेसरे चूणे रे कट्ठे करने। ");
INSERT INTO bfz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“दाऊगल़े रे डाल़ो ते ये उदारण सीखो, जेबे तेतेरी डाल़ी नरम ऊई जाओई और पत्ते निकल़ने लगोए, तो तुसे जाणी लओए कि तऊँदी नेड़े ए। ");
INSERT INTO bfz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ईंयां ई जेबे तुसे इना गल्ला खे ऊँदे ऊए देखो, तो समजी जाणा कि एबे आँऊ नेड़े ईए, बल्कि द्वारो पाँदे ईए खड़ेया रा। ");
INSERT INTO bfz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","आऊँ तुसा खे सच लगी रा बोलणे कि जदुओ तक यो सब गल्ला पूरिया नि ऊई जाओगिया, तदुओ तक एसा पीढ़िया रे लोका री मौत नि ऊणी। ");
INSERT INTO bfz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","सर्ग और तरती टल़ी जाओगी, पर मेरा वचन कदी नि टल़ना।” ");
INSERT INTO bfz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“तेस दिनो रे बारे रे और तेसा कअड़िया रे बारे रे कोई नि जाणदा, न स्वर्गदूत, ना पुत्र, पर बस पिता। ");
INSERT INTO bfz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जेड़े नूहो रे दिन थे, तिंयाँ ई मां माणूं रे पुत्रो रा आऊणा बी ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","कऊँकि जिंयाँ जल-प्रलय ते पईले, जदुओ तक नूह जाह्जो रे नि चढ़ेया, तदुओ तक लोक खाओ-पीओ थे और तिना रे ब्या-शादिया ओ थे ");
INSERT INTO bfz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","और जदुओ तक जल-प्रलय तिना सबी खे हड़ाई की नि लईगा, तदुओ तक तिना खे कुछ बी पता नि चलेया; तिंयाँ ई मां माणूं रे पुत्रो रा बी आऊणा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","तेस बखते दो जणे डोरूआ रे ऊणे, एक लयी लणा और दूजा छाडी देणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दो जवाणसा चाक्की पीशणे लगी री ऊणिया, एक लयी जाणी और दूजी छाडी देणी। ");
INSERT INTO bfz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","तेबेई तो, जागदे रओ, कऊँकि तुसे नि जाणदे कि तुसा रा प्रभु केस दिने आयी जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पर ये जाणी लओ कि जे कअरो रा मालक जाणदा कि चोर कदी जे आऊणा तो, से जागदा रंदा और आपणे कअरे चोरी नि ऊणे देंदा। ");
INSERT INTO bfz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","इजी री खातर तुसे बी त्यार रओ, कऊँकि जेसा कअड़िया रे बारे रे तुसे सोचदे पनि, तेसी कअड़िया रे आँऊ माणूं रा पुत्र आयी जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“एक विश्वासो जोगा और अक्लमंद दास एड़ा ए: जेसखे कअरो रा मालक दूजे दासा पाँदे निगरानी और बखतो पाँदे रोटी देणे खे जिम्मेवारी देओआ। तिजी ते बाद से परदेशो खे चली जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","धन्य ए से दास, जेसखे तेसरा मालक आयी की एड़ा ई करदा ऊआ पाओ। ");
INSERT INTO bfz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","आऊँ तुसा खे सच लगी रा बोलणे कि तेस से आपणी सारी सम्पतिया पाँदे अक्कदार ठराणा। ");
INSERT INTO bfz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","पर जे से दुष्ट दास सोचणे लगो कि मेरे मालको खे आऊणे रे देर ए ");
INSERT INTO bfz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","और आपणे साथलेया दासा खे कुटणे लगी जाओ और पीणे वाल़ेया साथे खाओ-पीओ, ");
INSERT INTO bfz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","तो तेस दासो रा मालक एड़े दिने आऊणा, जेबे से तेसखे न्याल़दा ई ना ओ और एड़िया कअड़िया रे, जेतेखे से नि जाणदा ओ। ");
INSERT INTO bfz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","तेबे तेस तेसखे बऊत दण्ड देणा और तेसरा इस्सा कपटिया साथे ठराणा; तेती रोणा और दाँद किरड़ना ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","तेबे यीशुए आपणे चेलेया खे फेर बोलेया, “जेबे आँऊ माणूं रा पुत्र आऊणा, तेबे स्वर्गो रा राज्य लाड़िया री तिना दस कुआँरिया सहेलिया जेड़ा ऊणा, जो आपणिया मशाला लयी की तेसा रे लाड़े साथे मिलणे खे निकल़िया। ");
INSERT INTO bfz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","तिना बीचा ते पाँज मूर्ख और पाँज समजदार थिया। ");
INSERT INTO bfz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","जो मूर्ख थिया तिने आपणिया मशाला तो लईया, पर आपू साथे फालतू तेल नि लया। ");
INSERT INTO bfz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पर समजदारे आपणिया मशाला साथे आपणिया कूप्पिया रे तेल बी परी ला। ");
INSERT INTO bfz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जेबे लाड़े खे आऊणे रे देर ऊईगी, तेबे तिना खे नींजा रे टमके लगणे लगे और सेयो सयी गिया। ");
INSERT INTO bfz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“आदिया राती आल्ला-गोल्ला लगेया ऊणे कि देखो, लाड़ा आऊणे लगी रा, तेस साथे मिलणे चलो। ");
INSERT INTO bfz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तेबे सेयो सब कुआँरिया उठिया और आपणी-आपणी मशाला ठीक करने लगिया। ");
INSERT INTO bfz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","तेबे जो मूर्ख थिया सेयो समजदारा खे लगिया बोलणे, ‘आपणे तेलो बीचा ते आसा खे बी थोड़ा जा तेल देई दो, कऊँकि आसा री मशाला बिजणे लगी रिया।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पर समजदारे बोलेया, ‘ये आसा और तुसा खे पूरा नि ऊणा। खरा तो ये कि तुसे जाओ और बेचणे वाल़ेया ते खरीदी की ली आओ।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जदुओ खे सेयो खरीदणे गईया, तदुओ खे लाड़ा आईगा और जो त्यार थिया, सेयो तेस साथे ब्याओ रे कअरे चली गिया और द्वार बंद करी ता। ");
INSERT INTO bfz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","तिजी ते बाद सेयो दुजिया कुआँरिया बी आयी की लाड़े खे बोलणे लगिया, ‘ओ मालक, ओ मालक, आसा खे बी दरवाजा खोलो।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","तिने जवाब दित्तेया, ‘आऊँ तुसा खे सच लगी रा बोलणे कि आऊँ तुसा खे नि जाणदा।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","इजी री खातर जागदे रओ, कऊँकि तुसे ना तो मेरे आऊणे रे तेस दिनो खे जाणोए और ना तेसा कअड़िया खे। ");
INSERT INTO bfz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“स्वर्गो रा राज्य तेस मांणूए जेड़ा बी ए, जिने परदेशो खे जांदे ऊए आपणी सारी सम्पति, आपणे दासा खे बुलाई की तिना गे सम्बाल़ी ती। ");
INSERT INTO bfz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","तिने एकी खे पाँज तोड़े, (एक तोड़ा मतलब पन्द्रहा साला री त्याड़ी) दूजे खे दो और तीजे खे एक, मतलब हर एकी खे तेसरी काबलियता रे मुताबिक दित्तेया और तेबे परदेशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तेबे, जेसखे पाँज तोड़े मिले थे, से गया और तिने जाई की तिजी साथे लेण-देण कित्तेया और पाँज तोड़े ओर कमाए। ");
INSERT INTO bfz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ईंयां ई जेसखे दो तोड़े मिले थे तिने बी दो तोड़े ओर कमाए। ");
INSERT INTO bfz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पर जेसखे एक तोड़ा मिलेया था, तिने जाई की माट्टी खणी और आपणे मालको रे पैसे लकोई ते। ");
INSERT INTO bfz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“बऊत दिना बाद तिना दासा रा मालक आया और तिना ते लेखा लगेया लणे। ");
INSERT INTO bfz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जेसखे पाँज तोड़े मिले थे, तिने पाँज तोड़े ओर ल्याई की बोलेया, ‘ओ मालक, तुसे माखे पाँज तोड़े दित्ते थे और मैं इजी ते पाँज तोड़े ओर कमाए।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","तेसरे मालके तेसखे बोलेया, ‘धन्य ए तूँ, खरे और विश्वास जोगे दास, तूँ थोड़े रेई विश्वासो जोगा रया, मां तूँ बऊत चीजा रा अक्कदार बनाणा, आओ मां साथे खुशिया रे शामिल ओ।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“तेबे जेसखे दो तोड़े मिले थे, तिने बी आयी की बोलेया, ‘ओ मालक! तुसे माखे दो तोड़े दित्ते थे, देखो, मैं दो तोड़े ओर कमाए।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","तेसरे मालके तेसखे बोलेया, ‘धन्य ए तूँ, खरे और विश्वास जोगे दास, तूँ थोड़े रेई विश्वासो जोगा रया, मां तूँ बऊत चीजा रा अक्कदार बनाणा, आओ मां साथे खुशिया रे शामिल ओ।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“तेबे जेसखे एक तोड़े मिलेया था, तिने आयी की बोलेया, ‘ओ मालक! आऊँ तुसा खे जाणूंआ कि तुसे कठोर मांणू ए। तुसे जेती बांदे नि तेती, बाडोए और जेती फरकांदा नि, तेती कट्ठा करोए।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","तो आऊँ डरीगा और जाई की तुसा रा तोड़ा माट्टिया रे लकोईता, देखो, ‘जो तुसा राए, से ये ए।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","तेसरे मालके तेसखे जवाब दित्तेया, ‘ओ दुष्ट और आल़सी दास, जेबे तूँ जाणेया था कि जेती मैं नि बायी राखेया, से बाडी देऊँआ और जेती फरकांदा नि, तेथा ते कट्ठा करूँआ। ");
INSERT INTO bfz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","तो ताखे चाईयो था कि तूँ मेरे पैसे साऊकारो गे देई देंदा, तेबे आऊँ आयी की आपणा पैसा ब्याजो समेत लई लंदा। ");
INSERT INTO bfz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","इजी खे ये तोड़ा एसते लई लो और जेसगे दस तोड़े ए, तेसखे देई देओ’ ");
INSERT INTO bfz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","कऊँकि जेस केसी गे आए, तेसखे ओर देणा और तेसगे ओर ऊई जाणा, पर जेसगे कुछ निए, तेसते से बी, जो तेसगे आए, लई लणा। ");
INSERT INTO bfz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","एस नकम्मे दासो खे बारे न्हेरे रे सेटी देओ, जेती रोणा और दाँद किरड़ना ई ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“जेबे आँऊ माणूं रा पुत्र आपणी महिमा रे आऊणा, तेबे सब स्वर्गदूत मां साथे आऊणे, तेबे मां आपणी महिमा रे सिंहासनो रे बैठणा। ");
INSERT INTO bfz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","तेबे सब जातिया तेस सामणे कट्ठिया करी देणियां और जिंयाँ गाद्दी बाकरिया खे पेडा ते लग करी देओआ, तिंयाँ ई तेस सेयो एकी-दूजे ते लग करी देणियां। ");
INSERT INTO bfz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","तेस पेडा मतलब तर्मी लोक आपणे दाणे कनारे खड़े करने और बाकरिया मतलब पापी लोक खूँजे कनारे। ");
INSERT INTO bfz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तेबे मां राजे आपणी दाँणे कनारे वाल़ेया खे बोलणा, ‘ओ मेरे पिते रे धन्य लोको; आओ, तेस राज्य रे अक्कदार ऊई जाओ, जो दुनिया रे सृष्टिया ते तुसा खे त्यार ए कित्ते रा। ");
INSERT INTO bfz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","कऊँकि जेबे आऊँ पूखा था और तुसे माखे खाणे खे दित्तेया, जेबे आऊँ त्याया था, तुसे माखे पाणी पल़याया, जेबे आऊँ परदेशी था, तुसे आऊँ आपणे कअरे ठराया। ");
INSERT INTO bfz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","जेबे आऊँ नांगा था, तुसे माखे टाले दित्ते, जेबे आऊँ बमार था और तुसे मेरी सम्बाल़ लई, जेबे आऊँ जेला रे था और तुसे माखे मिलणे आए।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“तेबे तर्मिया तेसते पूछणा, ‘आसे कदी तूँ पूखा देखेया और ताखे खुल़ाया? या त्याया देखेया और पाणी पल़याया? ");
INSERT INTO bfz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","आसे कदी तूँ परदेशी देखेया और आपणे कअरे ठराया? या नांगा देखेया और टाले पणयाए? ");
INSERT INTO bfz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","आसे कदी तूँ जेला रे या बमार देखेया और ताखे मिलणे आए?’ ");
INSERT INTO bfz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तेबे राजे तिना खे जवाब देणा, ‘आऊँ तुसा खे सच लगी रा बोलणे कि तुसे इना मेरे छोटेया ते छोटेया, केसी एकी पाईए साथे बी कित्तेया, से मां ई साथे कित्तेया।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“तेबे तेस खूँजे कनारे वाल़ेया खे बोलणा, ‘ओ स्रापित लोको! मां सामणे ते एसा अनन्त आगी रे चली जाओ, जो परमेशरे शैतानो खे और तेसरे दूतो खे त्यार ए कित्ती री। ");
INSERT INTO bfz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","कऊँकि आऊँ पूखा था, पर तुसे माखे रोटी नि दित्ती और आऊँ त्याया था, पर तुसे माखे पाणी नि पल़याया? ");
INSERT INTO bfz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","आऊँ परदेशी था, पर तुसे माखे आपणे कअरे जगा नि दित्ती, आऊँ नांगा था, पर तुसे माखे टाले नि दित्ते। आऊँ जेला रे और बमार था, पर तुसे माखे मिलणे नि आए।’ ");
INSERT INTO bfz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“तेबे तिना जवाब देणा, ‘ओ प्रभु! आसे कदी तूँ पूखा, त्याया, परदेशी, नांगा, बमार और जेला रे देखेया और तेरी सेवा नि कित्ती?’ ");
INSERT INTO bfz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तेबे मां तिना खे जवाब देणा, ‘आऊँ तुसा खे सच लगी रा बोलणे कि जो तुसे इना छोटेया ते छोटे बीचा ते केसी एकी साथे पनि कित्तेया, से मां साथे पनि कित्तेया’ ");
INSERT INTO bfz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","और तिना खे अनन्त सजा मिलणी, पर तर्मी, अनन्त जीवनो खे जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जेबे यीशु इना सबी गल्ला बोली चुके, तेबे आपणे चेलेया खे बोलणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुसे जाणोए कि दो दिन बाद फसह रा त्योआर ए और माणूं रा पुत्र क्रूसो पाँदे चढ़ाणे रिया तंईं पकड़वाया जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तेबे बड़े पुरोईत और लोका रे बुजुर्ग, कैफा नाओं रे प्रदान पुरोईतो रे आँगणो रे कट्ठे ऊए ");
INSERT INTO bfz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","और आपू बीचे बिचार करने लगे कि यीशुए खे तोखे रे पकड़ी की काई देऊँए। ");
INSERT INTO bfz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पर सेयो बोलो थे, “त्योआरो रे बखते नि, केथी एड़ा नि ओ कि लोका बीचे हुड़दंग मची जाओ।” ");
INSERT INTO bfz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जेबे यीशु बैतनिय्याह गांव रे शमौन कोढ़िए रे कअरे थे ");
INSERT INTO bfz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","तेबे एक जवाणस संगमरमरो रे पांडे री सुराइया रे मईंगा इत्र लयी की तिना गे आयी और जेबे सेयो रोटी खाणे बैठे रे थे, तेबे तेसे तिना रे सिरो पाँदे उलटाईता। ");
INSERT INTO bfz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ये देखी की तिना रे चेले जल़ने लगे और बोलणे लगे, “एते इत्रो रा सत्यानाश कऊँ कित्तेया? ");
INSERT INTO bfz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","एस इत्रो खे खरे दामो रे बेची की कंगाल़ा खे बांडी सको थे।” ");
INSERT INTO bfz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ये जाणी की यीशुए तिना खे बोलेया, “एसा जवाणसा खे तंग कऊँ लगी रे करने? एसे मां साथे पलाई करी राखी। ");
INSERT INTO bfz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","कंगाल़ तो तुसा साथे सदा रओए, पर आऊँ तुसा साथे सदा नि रणा। ");
INSERT INTO bfz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","तेसे मेरे शरीरो रे जो ये इत्र उलटाया, से मेरे दबाणे खे करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","आऊँ तुसा खे सच लगी रा बोलणे कि सारी दुनिया रे जेती केथी बी ये सुसमाचार प्रचार ऊणा, तेती एस कामो री चर्चा तेसा री यादा रे ऊणी।” ");
INSERT INTO bfz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तेबे यहूदा इस्करियोती जो बारा चेलेया बीचा ते एक था, तिने बड़े पुरोईतो गे जाई की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“जे आऊँ तिना खे तुसा रे आथो रे पकड़वाई देऊँ तो माखे क्या देणा?” तिने तेसखे तीई चाँदिए रे सिक्के तोली की देई ते। ");
INSERT INTO bfz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","तेबे से तेसी बखतो ते यीशुए खे पकड़वाणे रा मोका टोल़ने लगेया। ");
INSERT INTO bfz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","तेबे बिना सजेड़े री रोटिया रे त्योआरो रे पईलके दिने चेले आयी की यीशुए ते पूछणे लगे, “तुसे केयी चाओए कि आसे तुसा खे फसह रे त्योआरो री रोटी खाणे री त्यारी करिए?” ");
INSERT INTO bfz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","यीशुए बोलेया, “नगरो रे अमुक नाओं रे मांणूए गे जाओ और तेसखे बोलो कि गुरू बोलोआ कि मेरा बखत नेड़े ए, मां आपणे चेलेया साथे तेरे कअरे ये फसह रा त्योआर मनाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","तेबे चेलेया यीशुए री आज्ञा मानी और फसह रे त्योआरो री रोटी त्यार कित्ती। ");
INSERT INTO bfz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जेबे साँज ऊई तेबे सेयो आपणे बारा चेलेया साथे रोटी खाणे बैठे। ");
INSERT INTO bfz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जेबे सेयो खाणे लगी रे थे तेबे तिने बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि तुसा बीचा ते एकी जणे आऊँ पकड़वाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ये सुणी की सेयो बऊत दु:खी ऊईगे और सब तिना ते पूछणे लगे, “ओ गुरू! क्या से आऊँ ए?” ");
INSERT INTO bfz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","तिने जवाब दित्तेया, “जिने मां साथे थाल़िया रे आथ पाई राखेया, तेस आऊँ पकड़वाणा। ");
INSERT INTO bfz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","आँऊ माणूं रा पुत्र पक्का ई मारेया जाणा जेड़ा मेरे बारे रे पवित्र शास्त्रो रे लिखी राखेया, पर तेस मांणूए खे हाय, जेस आऊँ पकड़वाणा। तेस मांणूए खे खरा था कि से जमदा ई नि।” ");
INSERT INTO bfz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तेबे तिना खे पकड़वाणे वाल़े यहूदे बोलेया, “ओ गुरू! क्या से आऊँ ए?” तिने तेसखे बोलेया, “तूँ आपू ई बोली चुकेया।” ");
INSERT INTO bfz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जेबे सेयो खाणे लगी रे थे, तेबे यीशुए रोटी लयी और आशीष मांगी की तोड़ी और चेलेया खे दित्ती और बोलेया, “लओ खाओ; ये मेरा शरीर ए।” ");
INSERT INTO bfz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","तेबे तिने कटोरा लयी की धन्यवाद कित्तेया और तिना खे देई की बोलेया, “तुसे सब एते बीचा ते पियो। ");
INSERT INTO bfz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","कऊँकि ये वाचा रा मेरा से खून ए, जो बऊत जणेया रे पापो री माफिया खे बाह्या जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","आऊँ तुसा खे सच बोलूँआ कि मां अँगूरा रा रस तेस दिनो तक फेर कदी नि पीणा, जदुओ तक तुसा साथे आपणे पिते रे राज्य रे नया नि पीऊँ।” ");
INSERT INTO bfz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","तेबे सेयो पअजन गायी की जैतूनो रे पाह्ड़ो पाँदे गए। ");
INSERT INTO bfz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तेबे यीशुए तिना खे बोलेया, “तुसा सबी आजी राती मेरे बारे रे ठोकर खाणी; कऊँकि लिखी राखेया, ‘मां गाद्दी काणे और चूण्डा रिया पेडा ओरे-पोरे ऊई जाणिया।’ ");
INSERT INTO bfz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पर मरे रेया बीचा ते जिऊँदे ऊणे ते बाद, मां तुसा ते पईले गलीलो खे जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ये सुणी की पतरसे तिना खे बोलेया, “चाए सब तुसा रे बारे रे ठोकर खाओ तो खाओ, पर मां कदी नि खाणी।” ");
INSERT INTO bfz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीशुए तेसखे बोलेया, “आऊँ ताखे सच लगी रा बोलणे कि आज राती मुर्गे री बांग देणे ते पइले, तूँ तीन बार माखे जाणने ते मुकरी जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरसे तिना खे बोलेया, “जे माखे तुसा साथे मरना बी पड़ोगा, तो बी मां कदी ना नि करनी” और सबी चेले बी एड़ा ई बोलेया। ");
INSERT INTO bfz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तेबे यीशु आपणे चेलेया साथे गतसमनी नाओं री जगा रे आए और आपणे चेलेया खे बोलणे लगे, “एथी बैठे रे रणा, जदुओ तक आऊँ तेती जाई की प्रार्थना करुँ।” ");
INSERT INTO bfz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","सेयो पतरस और जब्दिए रे दोनो पाऊए खे साथे लईगे और उदास और बेचैन ऊणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","तेबे यीशुए तिना खे बोलेया, “मेरा जिऊ बऊत उदास ए, एथो तक कि मेरे प्राण निकल़ने लगी रे; तुसे एथी रूको और मां साथे जागदे रओ।” ");
INSERT INTO bfz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","तेबे सेयो थोड़ी जी आगे चली की मुंओ रे पारे रुड़ी गे और ये प्रार्थना करने लगे, “ओ मेरे पिता! ऊई सको तो ये दुःख मांगा गे ते टल़ी जाओ, पर तेबे बी जेड़ा आऊँ चाऊँआ, तेड़ा नि, पर जेड़ा तुसे चाओए तेड़ा ओ।” ");
INSERT INTO bfz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","तेबे जेबे सेयो वापस आए तो चेले सऊणे लगी रे थे, तेबे तिने पतरसो खे बोलेया, “क्या तुसे मां साथे एक कअड़ी पनि जागी सके? ");
INSERT INTO bfz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागदे रओ और प्रार्थना करदे रओ कि केथी तुसे परीक्षा रे नि पड़ी जाओ; आत्मा तो त्यार ए, पर शरीर कमजोर ए।” ");
INSERT INTO bfz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","फेर तिने दूजी बार जाई की प्रार्थना कित्ती, “ओ मेरे पिता! जे ये मेरे पीणे ते बिना नि आटी सकदा, तो तुसा री इच्छा पूरी ओ।” ");
INSERT INTO bfz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तेबे फेर जेबे सेयो आए तो तिने आपणे चेले सए रे पाए, कऊँकि तिना री आखी रे नींज थी। ");
INSERT INTO bfz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","तिना खे छाडी की सेयो फेर चली गे और तिना ई शब्दा ते तिने तीन बार प्रार्थना कित्ती। ");
INSERT INTO bfz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तेबे यीशुए चेलेया गे आयी की बोलेया, “एबे सऊँदे रओ और आराम करो। देखो, से कअड़ी आईगी री कि आँऊ माणूं रा पुत्र पापिया रे आथे पकड़वाणे वाल़ा ए। ");
INSERT INTO bfz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठो, चलो, देखो, माखे पकड़वाणे वाल़ा नेड़े आईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","यीशु ये बोलणे ई लगी रे थे तदुओ कि यहूदा, जो बारा चेलेया बीचा ते एक था, आया और तेस साथे बड़े पुरोईत और लोका रे बुजुर्गा री तरफा ते एक बड़ी पीड़, तलवार और डण्डे लयी की आयी। ");
INSERT INTO bfz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","तिना खे पकड़वाणे वाल़े तिना खे बताई ता था कि, “जेसखे आऊँ नमस्ते करुँ और गल़े लगूँ, सेई ऊणा और तुसे से पकड़ी की लई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","तेबे तिने फटाफट यीशुए गे आयी की बोलेया, “ओ गुरू!” और तेसखे नमस्ते कित्ती और गल़े लगेया। ");
INSERT INTO bfz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीशुए तेसखे बोलेया, “ओ दोस्त! जेते कामो खे तूँ आयी रा तेस कर।” तेबे तिने नेड़े आयी की यीशु पकड़ी ले। ");
INSERT INTO bfz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","तेबे यीशुए रे चेलेया बीचा ते एकी जणे आथ आगे करी की आपणी तलवार खिंजी ली और प्रदान पुरोईतो रे एकी दासो पाँदे चलाई और तेसरा कान ऊड़ाई ता। ");
INSERT INTO bfz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तेबे यीशुए तेसखे बोलेया, “आपणी तलवार म्यानो रे राखी दे, कऊँकि जो तलवार चलाओए, तिना रा तलवारी साथे नाश ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","क्या तूँ नि जाणदा कि आऊँ आपणे पिते ते बिनती करी सकूँआ और सेयो आपणे स्वर्गदूतो रिया बारा पल़टणा ते बी जादा एबु मांगे पेजी सकोए? ");
INSERT INTO bfz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पर पवित्र शास्त्रो रिया गल्ला कि ईंयां ई ऊणा जरूरी ए, किंयाँ पूरिया ऊणिया।” ");
INSERT INTO bfz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","तेस बखते यीशुए पीड़ा खे बोलेया, “क्या तुसे माखे डाकू समजोए कि तलवारी और डण्डे लयी की माखे पकड़ने आयी रे? आऊँ रोज मन्दरो रे बैठी की उपदेश देऊँ था, तेबे तुसे कऊँ नि पकड़ेया? ");
INSERT INTO bfz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","पर ये सब तेबे ऊआ ताकि भविष्यबक्ते रे वचन पूरे ओ” और सब चेले तिना खे छाडी की नठीगे। ");
INSERT INTO bfz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","तेबे यीशुए खे पकड़ने वाल़े तिना खे कैफा नाओं रे प्रदान पुरोईतो गे लईगे। जेती शास्त्री और बुजुर्ग कट्ठे थे ऊए रे। ");
INSERT INTO bfz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","पतरस दूरो तेई तिना ते पीछे-पीछे प्रदान पुरोईतो रे आँगणो तक गया और पीतरे जाई की अन्त देखणे खे प्यादेया साथे बैठी गा। ");
INSERT INTO bfz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","बड़े पुरोईत और सारी बड़ी सभा यीशुए खे काणे रिया तंईं चूठी गवाई सोचणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पर बऊत चूठे गवा आए, पर तेबे पनि मिली। ");
INSERT INTO bfz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","बादो ते दो जणेया आयी की बोलेया, “इने बोली राखेया कि आऊँ परमेशरो रे मन्दरो खे टाल़ी सकूँआ और तीजे दिने दूजा बणाई सकूँआ।” ");
INSERT INTO bfz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तेबे प्रदान पुरोईते खड़े ऊई की बोलेया, “क्या तूँ कोई जवाब नि देणा चांदा? यो लोक तेरे बारे रे क्या गवाई लगी रे देणे?” ");
INSERT INTO bfz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पर यीशु चुप रए। तेबे प्रदान पुरोईते तिना खे बोलेया, “आऊँ ताखे जिऊँदे परमेशरो री कसम देऊँआ कि जे तूँ परमेशरो रा पुत्र मसीह ए तो आसा गे बोली दे।” ");
INSERT INTO bfz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीशुए तेसखे बोलेया, “तैं आपू ई बोली ता; बल्कि आऊँ तुसा खे ये बी बोलूँआ कि आजो ते तुसा आँऊ माणूं रा पुत्र, सर्वशक्तिमानो रे दाँणे कनारे और सर्गो रे बादल़ा पाँदे आऊँदे ऊए देखणा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","तेबे प्रदान पुरोईते आपणे टाले फाड़े और बोलेया, “इने परमेशरो री निन्दा करी राखी, एबे आसा खे गवाओ री क्या जरूरत ए। देखो, तुसे एबु ये निन्दा सुणी राखी। ");
INSERT INTO bfz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुसे क्या सोचोए?” तिने जवाब दित्तेया, “ये तो काणे जोगा ए।” ");
INSERT INTO bfz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तेबे तिने यीशुए रे मुंओ पाँदे थूकेया और तिना खे मुक्के बाए और किने तो थप्पड़ बाए और बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ओ मसीह, आसा खे भविष्यबाणी करी की बोल कि तांदे किने बाई?” ");
INSERT INTO bfz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस बारे आँगणो रे बैठे रा था, तेबे एक दासी तेसगे आयी और बोलेया, “तूँ बी तो यीशु गलीलीए साथे था?” ");
INSERT INTO bfz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","तेबे से सबी सामणे मुकरी गा और तिने बोलेया, “आऊँ नि जाणदा कि तूँ क्या लगी री बोलणे।” ");
INSERT INTO bfz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","जेबे से बारे देऊल़िया गे चली गा, तेबे दूजी दासिये बी तेसखे देखी की जो तेती थे तिना खे बोलया, “ये बी तो यीशु नासरियो साथे था।” ");
INSERT INTO bfz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","पतरसे फेर कसम खाई की बोलेया, “आऊँ एस मांणूए खे नि जाणदा।” ");
INSERT INTO bfz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","थोड़ी देर बाद लोके जो तेती खड़ी रे थे, तिने पतरसो गे आयी की तेसखे बोलेया, “सच्ची तूँ बी तिना बीचा ते एक ए, कऊँकि तेरी पाषा तेरा पेत बताओई।” ");
INSERT INTO bfz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तेबे से आपू खे कोसणे लगेया और कसम खाणे लगेया, “आऊँ एस मांणूए खे नि जाणदा” और तेबुई मुर्गे बांग दित्ती। ");
INSERT INTO bfz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तेबे पतरसो खे यीशुए री गल्ल याद आयी कि, “मुर्गे री तीन बार बांग देणे ते पइले तां मेरे बारे रे जाणने ते ना करनी,” तेबे से बारे जाई की फुटी-फुटी की रोणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","जेबे प्याग ऊई तेबे सबी बड़े पुरोईत और लोका रे बुजुर्गे यीशुए खे काणे री योजना बणाई। ");
INSERT INTO bfz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","तेबे सेयो यीशुए खे बानी की लईगे और पिलातुस हाकिमो रे आथो रे देई ते। ");
INSERT INTO bfz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जेबे यीशुए खे तोखे ते पकड़वाणे वाल़े यहूदे देखेया कि सेयो दोषी ठराई ते, तेबे से बऊत पछताया और तिना चाँदिए रे तीई सिक्केया लयी की बड़े पुरोईता गे और बुजुर्गा गे फेर ली आया ");
INSERT INTO bfz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","और बोलणे लगेया, “मैं बेकसुर मांणूए री मौत करवाणे खे पकड़वाई की पाप करी राखेया।” तेबे तिने बोलेया, “आसा खे क्या ए? तूँ ई जाण।” ");
INSERT INTO bfz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","तेबे यहूदा तिना सिक्केया खे मन्दरो रे सेटी की चली गा और जाई की आपू खे गल़फा लगाईता। ");
INSERT INTO bfz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","तेबे बड़े पुरोईते तिना सिक्केया खे लयी की बोलेया, “इना खे पण्डारो रे राखणा ठीक निए, कऊँकि ये खून कराणे खे दित्ती री कीमत ए।” ");
INSERT INTO bfz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","तेबे तिने योजना बणाई की तिना सिक्केया ते परदेशिया खे दबाणे रिया तंईं कुम्हारो रा डोरू मोले लयी ला। ");
INSERT INTO bfz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","तेबेई तो आजो तक तेस डोरूआ खे खूनो रा डोरू बोलोए। ");
INSERT INTO bfz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तेबे जो वचन यिर्मयाह भविष्यबक्ते बोलेया था, से पूरा ऊआ, “तिने सेयो तीई सिक्के, मतलब जो मोल था राखेया रा (जो इस्राएलो री ल्वादा बीचा ते कितणेया जणे ठराया था) लयी ला ");
INSERT INTO bfz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","और जिंयाँ माखे प्रभुए आज्ञा दित्ती थी, तिंयाँ ई से कुम्हारा रे डोरूआ रे मोलो रे देईता।” ");
INSERT INTO bfz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","जेबे यीशु हाकिमो सामणे खड़े थे, तेबे हाकिमे पूछेया, “क्या तूँ यहूदिये रा राजा ए?” यीशुए तेसखे बोलेया, “तूँ आपू ई लगी रा बोलणे।” ");
INSERT INTO bfz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","जेबे बड़े पुरोईत और बुजुर्ग तिना पाँदे दोष लगी रे थे लगाणे, तेबे तिने कोई जवाब नि दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","तेबे पिलातुसे तिना खे बोलेया, “क्या तूँ सुणने नि लगी रा कि यो तेरे खलाफ कितणिया गवाईया लगी रे देणे।” ");
INSERT INTO bfz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","पर यीशुए तेसरी एक बी गल्ला रा जवाब नि दित्तेया, ये देखी की हाकिमो खे बऊत हैरानी ऊई। ");
INSERT INTO bfz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","हाकिमो रा ये रवाज था कि तेस त्योआरो खे लोका री तंईं जेसखे सेयो चाओ थे, एकी बन्दुओ खे छाडी देयो था। ");
INSERT INTO bfz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","तेस बखते तिना गे बरअब्बा नाओं रा एक मानेया रा बन्दुआ था। ");
INSERT INTO bfz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","तेबे, जेबे सेयो कट्ठे ऊए, तेबे पिलातुसे तिना खे बोलेया, “तुसे केसखे चाओए कि आऊँ तुसा री तंईं छाडी देऊँ? बरअब्बे खे या यीशुए खे, जेसखे मसीह बी बोलोए?” ");
INSERT INTO bfz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","कऊँकि पिलातुस जाणो था कि तिने से जल़नी रे पकड़वाया। ");
INSERT INTO bfz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जेबे से न्याय आसणो री गद्दिया पाँदे था बैठे रा, तेबे तेसरी लाड़िए तेसखे सन्देशा पेजेया कि, “तूँ तेस तर्मी मांणूए रे बारे रे दखलंदाजी नि कर; कऊँकि आज माखे सुपने रे तेसरी बजअ ते बऊत दु:ख ऊआ।” ");
INSERT INTO bfz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","बड़े पुरोईत और बुजुर्गे लोक ऊकसाए कि तुसे बरअब्बे खे माँगो और यीशुए खे नाश कराओ। ");
INSERT INTO bfz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","हाकिमे तिना ते पूछेया, “तुसे इना दूँईं बीचा ते केसखे चाओए कि आऊँ तुसा खे छाडी देऊँ?” तिने बोलेया, “बरअब्बे खे।” ");
INSERT INTO bfz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातुसे तिना ते पूछेया, “तेबे यीशुए खे, जेसखे मसीह बोलोए, तेस साथे क्या करुँ?” सबी तेसखे बोलेया, “एसखे क्रूसो पाँदे चढ़ाओ।” ");
INSERT INTO bfz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","हाकिमे पूछेया, “कऊँ, तिने क्या बुरा करी राखेया?” पर सेयो ओर बी चींगी-चींगी की बोलणे लगे, “एसखे क्रूसो पाँदे चढ़ाओ।” ");
INSERT INTO bfz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जेबे पिलातुसे देखेया कि कोई बात नि लगी री बणने, बल्कि बिगड़ने ई लगी री, तेबे तिने पाणी लई की पीड़ा सामणे आपणे आथ तोए और बोलेया, “आऊँ एस तर्मिंयों रे खूनो ते निर्दोष ए; तुसेई जाणो।” ");
INSERT INTO bfz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","सबी जवाब दित्तेया, “एसरे खूनो री अत्या आसा खे और आसा री ल्वादा खे लगो!” ");
INSERT INTO bfz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","तेबे तिने बरअब्बा तिना खे छाडीता और यीशु कोड़े लगवाई की तिना खे देई ते कि क्रूसो पाँदे चढ़ाई देयो। ");
INSERT INTO bfz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","तेबे हाकिमो रे सिपाई यीशुए खे किले दे लईगे और सारी पल़टण तिना रे चऊँ कनारे कट्ठी करी ती, ");
INSERT INTO bfz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","और तिना रे टाले खोली की तिना खे लाल रंगो रा चौगा पणयाई ता ");
INSERT INTO bfz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","और कांडेया रा मुकट बूणी की तिना रे सिरो पाँदे राखेया और तिना रे दाँणे आथो रे एक नगल़ो रा डण्डा देईता और तिना रे आगे कुटणे टेकी की तिना रा मजाक ऊड़ाणे लगे और बोलणे लगे, “ओ यहूदिया रे राजा नमस्कार!” ");
INSERT INTO bfz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","और तिना पाँदे थूकेया और सेई नगल़ो रा डण्डा लयी की तिना रे सिरो पाँदे बाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","जेबे सेयो तिना रा मजाक ऊड़ाई चुके, तेबे तिने तिना पाँदो ते से चौगा उतारेया और तिना खे तिना रेई टाल्ले पणयाईते और क्रूसो पाँदे चढ़ाणे खे लयी चले। ");
INSERT INTO bfz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","बारे जाई की तिना खे शमौन नाओं रा एक कुरेनी मांणू, जो दूजे गांव ते आऊणे लगी रा था, तेसी बखते से तिसिये निकल़ेया। तेबे सिपाईए से ईंयां ई पकड़ी ता कि यीशु रा क्रूस चकी की लई चल। ");
INSERT INTO bfz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","तेसा जगा रे जो गुलगुता, मतलब-जेथो खे खोपड़िया री जगा बी बोलोए, तेती पऊँछी की ");
INSERT INTO bfz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","तिने यीशुए खे पित्त मलाए रा अँगूरा रा रस पीणे खे दित्तेया, पर तिने चाखी की पीणा नि चाया। ");
INSERT INTO bfz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","तेबे तिने यीशु क्रूसो पाँदे चढ़ाई ते और चिट्ठिया पाई की तिना रे टाले बांडी ते ");
INSERT INTO bfz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","और तेती बैठी की तिना रा पईरा देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","तेबे तिना रा दोष पत्र तिना रे सिरो पाँदे लगाया, “ये यहूदिया रा राजा यीशु ए।” ");
INSERT INTO bfz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तेबे तिना साथे दो डाकू, एक दाँणे कनारे और दूजा खूँजे कनारे क्रूसो पाँदे चढ़ाए। ");
INSERT INTO bfz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","आऊणे जाणे वाल़े सिर इलाई-इलाई की तिना री निन्दा करदे रओ थे ");
INSERT INTO bfz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","और ये बोलदे रओ थे, “ओ मन्दरो खे टाल़ने वाल़े और तीन दिना रे बनाणे वाल़े, आपू खे तो बचा! जे तूँ परमेशरो रा पुत्र ए, तो क्रूसो पाँदो ते उतरी की थाले आओ।” ");
INSERT INTO bfz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","तिंयाँ ई बड़े पुरोईत, शास्त्री और बुजुर्ग मजाक ऊड़ाई की बोलो थे, ");
INSERT INTO bfz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“इने ओर बचाए, पर आपू खे नि बचाई सकदा। ये तो ‘इस्राएलो रा राजा’ ए जे एबे क्रूसो ते ऊतरी की आओ, तो आसे विश्वास करिए। ");
INSERT INTO bfz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","इने तो परमेशरो पाँदे विश्वास राखी राखेया, जे से एसखे चाओआ, तो एबे एसखे छुड़ाई लो, कऊँकि इने बोलेया था, कि आऊँ परमेशरो रा पुत्र ए” ");
INSERT INTO bfz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","तिंयाँ ई सेयो डाकू बी, जो यीशुए साथे क्रूसो पाँदे चढ़ाई राखे थे, निन्दा करदे रओ थे। ");
INSERT INTO bfz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","त्याड़िया ते लयी की तीजे पईरो तक सारे देशो रे न्हेरा ई रया। ");
INSERT INTO bfz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तीजे पईरो रे नेड़े यीशुए जोरे की आक्का पाई की बोलेया, “एली, एली, लमा शबक्तनी?” मतलब “ओ मेरे परमेशर, ओ मेरे परमेशर! तैं आऊँ कऊँ छाडीता?” ");
INSERT INTO bfz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","जो तेती थे खड़े रे, तिना बीचा ते बऊत जणेया ये सुणी की बोलेया, “ये एलिय्याह खे लगी रा आक्का पाणे।” ");
INSERT INTO bfz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","तिना बीचा ते एक फटाफट दौड़ेया और स्पंज लयी की सिरके बीचे डबोया और नगल़ो रे डण्डे रे राखी की तिना खे चुसाया। ");
INSERT INTO bfz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","तेबे ओरी बोलेया, “देखी लऊँए कि एलिय्याह एसखे बचाणे आओआ कि नई।” ");
INSERT INTO bfz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तेबे यीशु फेर जोरे की चींगे और प्राण छाडी ते। ");
INSERT INTO bfz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","तेबे मन्दरो रा पड़दा पाँदो ते लई की थालो तक फटीगा और तिजी रे दो टुकड़े ऊईगे। ये ए दखाओआ कि एबे कोई बी मांणू परमेशरो री हजुरिया रे जाई सकोआ। तरती ईलणे लगी और जानी तिड़की गिया ");
INSERT INTO bfz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","और कब्रा खुली गिया और मरे रे पवित्र लोका रिया बऊत लोथा उठी गिया। ");
INSERT INTO bfz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","और तिना रे जिऊँदे ऊणे ते बाद सेयो कब्रा ते निकल़ी की पवित्र नगरो खे गए और बऊत लोका खे दिखे। ");
INSERT INTO bfz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","तेबे सूबेदार और जो तेस साथे पईरा देणे लगी रे थे, ईल्लण और जो कुछ तेती ऊआ, देखी की बऊत डरी गे और बोलणे लगे, “सच्ची, ये तो परमेशरो रा ई पुत्र था।” ");
INSERT INTO bfz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","तेती बऊत जवाणसा, जो गलील प्रदेशो ते यीशुए साथे तिना री सेवा करदिया ऊईया आईया थिया, ये दूरो ते लगी री थिया देखणे। ");
INSERT INTO bfz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","तिना बीचे मरियम मगदलिनी और याकूब और योसेसो री आम्मा मरियम और जब्दिए रे पाऊए री आम्मा थी। ");
INSERT INTO bfz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","जेबे साँज ऊई तेबे यूसुफ नाओं रा अरिमतियाह रा एक अमीर मांणू, जो आपू बी यीशुए रा चेला था, आया। ");
INSERT INTO bfz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","तिने पिलातुसो गे जाई की यीशुए री लोथ मांगी। तेबे पिलातुसे देणे री आज्ञा देईती। ");
INSERT INTO bfz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफे लोथ लई और सफेद चादरी रे लपेटी ती ");
INSERT INTO bfz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","और से आपणी नईया कब्रा रे राखी, जो तिने चट्टानी रे थी खणवाई री और कब्रा रे द्वारो पाँदे एक बड़ा पात्थर खसकेयी की चली गा। ");
INSERT INTO bfz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मगदलिनी और दूजी मरियम तेती कब्रा सामणे बैठी रिया थिया। ");
INSERT INTO bfz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","दूजे दिने, जो आरामो रा दिन था, बड़े पुरोईत और फरीसिये कट्ठे ऊई की पिलातुसो खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ओ महाराज! आसा खे याद ए कि तिने भरमाणे वाल़े, जेबे से जिऊँदा था तिने बोलेया था कि, मां मरने ते बाद तीजे दिने जिऊँदा ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","तो आज्ञा दे कि तीन दिना तक कब्रा री रखवाल़ी ओ, एड़ा नि ओ कि तेसरे चेले आयी की तेसखे चोरी की लयी जाओ और लोका खे बोलो कि, से मरे रे बीचा ते जिऊँदा ऊईगा; तेबे पिछला तोखा, पईले ते बी बुरा ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुसे तिना खे बोलेया, “तुसा गे पईरेदार आए। तिना खे लयी जाओ और आपणी समजा रे मुताबिक रखवाल़ी करो।” ");
INSERT INTO bfz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","तेबे सेयो पईरेदारा खे साथे लयी गे और पात्थरो पाँदे मोहर लगाई की कब्रा री रखवाल़ी करने लगे। ");
INSERT INTO bfz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","आरामो रे दिनो ते बाद, अफ़्ते रे पईले दिने, तड़के-तड़के मरियम मगदलिनी और दूजी मरियम, कब्र देखणे आईया। ");
INSERT INTO bfz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","तेबे देखो, बऊत बड़ा ईल्लण ऊआ, कऊँकि प्रभुए रा एक स्वर्गदूत स्वर्गो ते उतरेया और तिने नेड़े आयी की कब्रा रा पात्थर कनारे खसकेयी ता और तेते पाँदे बैठी गा। ");
INSERT INTO bfz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","तेसरा रूप बिजल़िया जेड़ा और टाले पाल़े जेड़े चमकीले थे। ");
INSERT INTO bfz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","तेस देखी की पईरेदार थरथराईगे और बेओश ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","स्वर्गदूते तिना जवाणसा खे बोलेया, “डरो नि; कऊँकि माखे पता ए कि तुसे यीशुए खे, जो क्रूसो पाँदे चढ़ाया था, तेसखे टोल़ने लगी रिया। ");
INSERT INTO bfz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","से एती निए, पर आपणे वचनो रे मुताबिक जिऊँदा ऊईगा रा। आओ, एसा जगा खे देखो, जेती प्रभु थे राखे रे ");
INSERT INTO bfz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","और फटाफट जाई की तिना रे चेलेया खे बोलो कि सेयो मरे रे बीचा ते जिऊँदे ऊईगे रे और सेयो तुसा ते पईले गलील प्रदेशो रे पऊँछी जाणे, तेती तुसा खे तिना रा दर्शन ऊणा, मैं तुसा खे बोली ता।” ");
INSERT INTO bfz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","सेयो जवाणसा डर और खुशिया साथे कब्रा ते फटाफट वापस ऊई की चेलेया खे ये समाचार देणे दौड़ी गिया। ");
INSERT INTO bfz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तेबे यीशु तिना खे मिले और बोलेया, “नमस्ते!” सेयो नेड़े आईया और तिना रे पैर पकड़ी की तिना गे माथा टेकेया। ");
INSERT INTO bfz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तेबे प्रभु यीशुए तिना खे बोलेया, “डरो नि; मेरे चेलेया खे जाई की बोलो कि गलीलो खे चली जाओ। तेती तिना आऊँ देखणा।” ");
INSERT INTO bfz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","जेबे सेयो जवाणसा चेलेया खे ये समाचार देणे जाणे ई लगी रिया थिया, तदुओ तक पईरेदारा बीचा ते कई जणेया नगरो रे आयी की सारा आल बड़े पुरोईता गे सुणाया। ");
INSERT INTO bfz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तेबे बड़े पुरोईते और बुजुर्गा साथे कट्ठे ऊई की सम्मति कित्ती और पईरेदारा खे बऊत चाँदी देई की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“तुसे सबी लोका गे ये बोलणा कि जेबे राती आसे सऊणे लगी रे थे, तेबे तेसरे चेले आए और तेसखे चोरी की लईगे ");
INSERT INTO bfz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","और जे ये बात हाकिमो तक पऊँछी गी तो आसे तेसखे समजयाई लऊँगे और तुसा खे मुश्किला ते बचाई लऊँगे।” ");
INSERT INTO bfz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","तेबे तिने पैसे लए और जेड़ा बोलेया था, तेड़ा ई कित्तेया। ये गल्ल आजो तक बी यहूदिया बीचे प्रचलित ए। ");
INSERT INTO bfz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","तेबे ग्यारा चेले गलील प्रदेशो रे तेस पाह्ड़ो पाँदे गए, जो यीशुए तिना खे बताई राखेया था। ");
INSERT INTO bfz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","तेबे तिने यीशुए रे दर्शन कित्ते और तिना गे माथा टेकेया, पर तिना बीचा ते केसी-केसी खे शक ऊआ कि से जिऊँदा ऊईगा रा ");
INSERT INTO bfz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","यीशुए तिना रे नेड़े आयी की बोलेया, “स्वर्ग और तरतिया रा सारा अक्क मांगे देई राखेया। ");
INSERT INTO bfz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","तो, तुसे जाओ और सब जातिया रे लोका खे चेला बणाओ, और तिना खे पिता, पुत्र और पवित्र आत्मा रे नाओं ते बपतिस्मा देओ ");
INSERT INTO bfz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","और तिना खे सब गल्ला, जो मैं तुसा खे आज्ञा देई राखिया, मानणा सिखाओ; और देखो, आऊँ दुनिया रे आखरी तक सदा तुसा साथे ए।”");
INSERT INTO bfz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","यीशु मसीह जो परमेशरो रा पुत्र ए, तेसरे बारे रे सुसमाचारो री शुरूआत। ");
INSERT INTO bfz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जेड़ा यशायाह भविष्यबक्ते री कताबा रे लिखी राखेया, परमेशरे आपणे पुत्रो खे बोलेया। “देख, आऊँ आपणे दूतो खे तांते पईले पेजुँआ, तेस लोका रे मन ताखे त्यार करने।” ");
INSERT INTO bfz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“सुणसाण जगा रे एक आक्का पाणे वाल़े री आवाज सुणने लगी री, ‘प्रभुए री खातर लोका रे मनो खे त्यार करो, और तिना रे मनो खे सीदा करो।’ ” ");
INSERT INTO bfz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","यूहन्ना आया, जो सुणसाण जगा रे बपतिस्मा देओ था और पापो री माफिया खे मन फेरने रे बपतिस्मे रा प्रचार करो था। ");
INSERT INTO bfz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","तेबे बऊत सारे यहूदिया प्रदेशो रे लोक और यरूशलेम नगरो रे बी बऊत सारे रणे वाल़े लोक निकल़ी की तेसगे गये और आपणे पापो खे मानी की यरदन नदिया रे तेसते बपतिस्मा लया। ");
INSERT INTO bfz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्ना ऊँटो रे बाल़ो रे टाले पईनो था और आपणे लको रे चामड़े रा पट्टू बानी राखो था और टिड्डिया और बणो रा सईत खाया करो था। ");
INSERT INTO bfz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","से ये प्रचार करो था, “जो मांते बाद आऊणे वाल़ा ए, से मांते बी जादा महान् ए, आऊँ तो एते जोगा पनिए कि चुकी की तेसरे जोड़े रे फिथे खोलूँ। ");
INSERT INTO bfz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मैं तो तुसा खे पाणिए साथे बपतिस्मा दित्तेया, पर तेस तुसा खे पवित्र आत्मा साथे बपतिस्मा देणा।” ");
INSERT INTO bfz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","तेस बखते यीशुए, गलील प्रदेशो रे नासरत नगरो ते आई की यरदन नदिया रे यूहन्ने ते बपतिस्मा लया। ");
INSERT INTO bfz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","जेबे यीशु पाणिए बीचा ते निकल़ी की पाँदे आए, तेबे तिने तेबु सर्ग खुलदा ऊआ और जिंयाँ कबूतर उड़दा ऊआ थाले आओआ तिंयाँ ई तिने पवित्र आत्मा आपू पाँदे आऊँदे ऊए देखेया। ");
INSERT INTO bfz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","तेबे स्वर्गो ते ये आवाज आई, “तूँ मेरा प्यारा पुत्र ए और आऊँ तांते खुश ए।” ");
INSERT INTO bfz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तेबे पवित्र आत्मा तेबुई यीशुए खे सुणसाण जगा रे लईगा। ");
INSERT INTO bfz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","सुणसाण जगा रे चाल़ी दिन तक शैतान तिना री परीक्षा करदा रया और सेयो जंगल़ी जानवरो साथे रए और स्वर्गदूत तिना री सेवा करदे रये। ");
INSERT INTO bfz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","यूहन्ने रे पकड़वाए जाणे ते बाद, यीशुए गलील प्रदेशो रे आई की परमेशरो रे राज्य रा सुसमाचार प्रचार कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","तिने बोलेया, “बखत पूरा ऊईगा रा और परमेशरो रा राज्य नेड़े आईगा रा, मन फेरो और सुसमाचारो पाँदे विश्वास करो।” ");
INSERT INTO bfz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","गलीलो रे समुद्रो रे कनारे-कनारे जांदे ऊए यीशुए शमौन और तेसरा पाई अन्द्रियास समुद्रो रे जाल़ पाँदे ऊए देखेया, कऊँकि सेयो मछलिया पकड़ने वाल़े थे। ");
INSERT INTO bfz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","तेबे यीशुए तिना खे बोलेया, “मां पीछे आओ और जिंयाँ तुसे मच्छली पकड़ना जाणोए तिंयाँ ई मां तुसा खे परमेशरो गे मांणू पकड़ी की ल्याऊणे सिखाणे।” ");
INSERT INTO bfz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","सेयो तेबुई जाल़ छाडी की यीशुए पीछे चली पड़े। ");
INSERT INTO bfz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","तेबे थोड़ी जी आगे जाई की यीशुए, जब्दिए रे पाऊ याकूब और तेसरा पाई यूहन्ना किस्तिया पाँदे जाल़ ठीक करदे ऊए देखे। ");
INSERT INTO bfz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","तिने तेबुई सेयो बुलाए और सेयो आपणे पिते जब्दियो खे मजदूरा साथे, किस्तिया पाँदे छाडी की यीशुए रे पीछे चली पड़े। ");
INSERT INTO bfz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","तेबे यीशु और तिना रे चेले कफरनहूम नगरो रे आए और यीशु आरामो रे दिने प्रार्थना रे कअरो रे गए और उपदेश देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","लोक तिना रे उपदेशो ते हैरान ऊईगे, कऊँकि सेयो तिना खे शास्त्रिया जेड़े नि, पर अधिकारो साथे उपदेश देओ थे। ");
INSERT INTO bfz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","तेबे तेस बखते तिना रे प्रार्थना रे कअरो रे एक एड़ा मांणू था, जेसरे दुष्टात्मा थी। ");
INSERT INTO bfz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","तिने चींगी की बोलेया, “ओ यीशु नासरी! आसा खे तांते क्या काम ए? क्या तूँ आसा खे नाश करने आई रा? आऊँ ताखे जाणूंआ कि तूँ कूण ए? तूँ परमेशरो रा पवित्र पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","यीशु तेसखे बक्के और बोलेया, “चुप रओ और एसते निकल़ी जा।” ");
INSERT INTO bfz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तेबे दुष्टात्मा तेसखे मकरेड़ी की और जोरे की चींगदी ऊई, तेसते निकल़ी गी। ");
INSERT INTO bfz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ये देखी की सब लोक हैरान ऊईगे और आपू बीचे बईस करने लगे, “ये केड़ी गल्ल ए? ये तो कोई नया ई उपदेश ए। ये तो अधिकारो साथे दुष्टात्मा खे बी आज्ञा देओआ और सेयो एसरी आज्ञा खे मानोईया।” ");
INSERT INTO bfz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","तेबे यीशुए रा नाओं गलीलो रे सारे प्रदेशो रे फैली गा। ");
INSERT INTO bfz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","तेबे यीशु तेबुई प्रार्थना रे कअरो ते निकल़ी की याकूब और यूहन्ने साथे, शमौन और अन्द्रियासो रे कअरे आए। ");
INSERT INTO bfz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","शमौनो री सासुआ खे बऊत बुखार था से माँजे पाँदे सुती री थी और तेबे तिने फटाफट तेसा रे बारे रे यीशुए खे बोलेया। ");
INSERT INTO bfz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तेबे यीशुए नेड़े जाई की तेसा रा आथ पकड़ी की से ऊबे ठवाल़ी और तेसा रा बुखार उतरी गा और तेबे से तिना री सेवा करने लगी। ");
INSERT INTO bfz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","साँजके बखते जेबे सूरज डूबी गा तेबे लोक बऊत सारे बमारा खे और जिना रे दुष्टात्मा थिया, तिना खे लई की यीशुए गे आए। ");
INSERT INTO bfz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","तेबे नगरो रे बऊत सारे लोक द्वारो पाँदे कट्ठा ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","तेबे यीशुए, जो कईया प्रकारा रिया बमारिया ते दु:खी थे, सब ठीक कित्ते, कई दुष्टात्मा निकयाल़िया और दुष्टात्मा खे बोलणे नि देओ थे, कऊँकि सेयो तिना खे जाणो थिया कि सेयो परमेशरो रे पुत्र ए। ");
INSERT INTO bfz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","तेबे यीशु तड़के ई उठी गे और सुनसाण जगा खे चली गे और तेती प्रार्थना करने लगे। ");
INSERT INTO bfz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","तेबे शमौन और तेसरे साथी तिना खे टोल़दे ऊए गए। ");
INSERT INTO bfz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","जेबे सेयो मिली गे, तेबे तिना खे बोलेया, “बऊत सारे लोक तुसा खे टोल़ने लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","तेबे यीशुए तिना खे बोलेया, “चलो, आसे केथी नेड़े-तेड़े बस्तिया रे चलूँए, ताकि आऊँ तेती बी प्रचार करी सकूँ, कऊँकि आऊँ आई इजी खे रया।” ");
INSERT INTO bfz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","तेबे सेयो गलील प्रदेशो रे बऊत सारी जगा रे और तिना रे प्रार्थना रे कअरो रे जाई-जाई की प्रचार करदे और दुष्टात्मा खे निकयाल़दे रओ थे। ");
INSERT INTO bfz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","तेबे एक कोढ़िए यीशुए गे आई की बिनती कित्ती और तिना रे सामणे कूटणे टेकी की तिना खे बोलेया, “जे तुसे चाओ, तो माखे ठीक करी सकोए।” ");
INSERT INTO bfz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","तेबे यीशुए तेस पाँदे तरस खाई की आपणा आथ आगे कित्तेया और तेसखे छुँईं की बोलेया, “आऊँ चाऊँआ कि तूँ ठीक ऊई जाए।” ");
INSERT INTO bfz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","तेबे तेबुई तेसरा कोढ़ निकल़ी गा और से ठीक ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तेबे यीशुए सावधान करी की से तेथा ते फटाफट पेजी ता। ");
INSERT INTO bfz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","और तेसखे बोलेया, “देख, केसी गे नि बताणा, पर जाई की आपू खे पुरोईतो गे दखा और आपणे ठीक ऊणे रे बारे रे जो कुछ मूसे नबीए चढ़ावा ठराई राखेया, तेस चढ़ा, ताकि लोका बीचे तेरी गवाई ओ कि तूँ ठीक ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","और से बारे जाई की एसा गल्ला रा बऊत प्रचार करने लगेया और एसा गल्ला खे एथो तक फैलाणे लगेया कि यीशु फेर नगरो रे खुल्लमखुल्ले नि जाई सके, पर सेयो सुणसाण जगा रे रए, पर तेती बी लोक चऊँ कनारे ते तिना गे आऊँदे रये। ");
INSERT INTO bfz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","कुछ दिना ते बाद यीशु फेर कफरनहूमो नगरो खे आए और सुणने बीचे आया कि सेयो कअरे ए। ");
INSERT INTO bfz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","तेबे इतणे लोक कट्ठे ऊईगे कि द्वारो पाँदे बी खड़ने खे जगा नि रई और यीशु तिना खे वचन सुनाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","तेबे लोक एक अदरंगो रे रोगिए खे चार मांणूआ ते चकाई की तिना गे ली आए। ");
INSERT INTO bfz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","पर जेबे सेयो पीड़ा रिया बजअ ते यीशुए गे नि पऊँछी सके, तेबे तिने से छत जेते निठे यीशु थे, खोली ता और जेबे सेयो तेस पटी चुके, तेबे से मांजा जेते पाँदे अदरंगो रा रोगी पड़ी रा था, यीशुए रे सामणे त्वारेया। ");
INSERT INTO bfz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","यीशुए तिना रा विश्वास देखी की तेस अदरंगो रे रोगिए खे बोलेया, “ओ पाऊआ, तेरे पाप माफ ऊईगे।” ");
INSERT INTO bfz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","तेबे कुछ शास्त्री जो तेती बैठी रे थे, आपणे-आपणे मनो रे सोचणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ये मांणू कऊँ एड़ा बोलोआ? ये तो परमेशरो री निन्दा करने लगी रा। परमेशरो खे छाडी की ओर कूण पाप माफ करी सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","यीशुए तेबुई आपणी आत्मा रे जाणी ला कि सेयो आपणे मनो रे एड़ा लगी रे सोचणे तेबे तिने तिना खे बोलेया, “तुसे आपणे-आपणे मनो रे एड़ा बिचार कऊँ करने लगी रे? ");
INSERT INTO bfz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ये बोलणा बऊत आसान ए कि तेरे पाप माफ ऊईगे पर ये बोलणा बऊत कठण ए कि आपणा मांजा चकी की चल फिर। ");
INSERT INTO bfz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","इजी री खातर तुसे जाणी लओ कि मां माणूं रे पुत्रो खे तरतिया पाँदे पाप माफ करने रा बी अक्क ए।” यीशुए तेस अदरंगो रे रोगिए खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“आऊँ ताखे बोलूँआ कि उठ! आपणा मांजा चकी की आपणे कअरो खे चली जा” ");
INSERT INTO bfz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","से उठेया और तेबु आपणा मांजा चकी की सबी रे सामणे ते निकल़ी की चली गा। तेबे सब हैरान ऊईगे और परमेशरो री तारीफ करी की बोलणे लगे, “आसे एड़ा कदी पनि देखेया।” ");
INSERT INTO bfz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","यीशु तेथा ते निकल़ी कि समुद्रो रे कनारे चली गे और सारी पीड़ तिना गे आईगी, तेबे सेयो तिना खे उपदेश देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","तेबे जांदे ऊए तिने हलफइसो रा पाऊ लेवी चुंगी लणे री चौकिया पाँदे बैठे रा देखेया और तेसखे बोलेया, “मां पीछे आओ” और से उठी की तिना पीछे चली पड़ेया। ");
INSERT INTO bfz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","जेबे यीशु लेवीए रे कअरे रोटी खाणे बैठेया, तेबे बऊत चुंगी लणे वाल़े और पापी, यीशु और तेसरे चेलेया साथे रोटी खाणे बैठे, और सेयो बऊत थे जो तिना पीछे आईगे थे। ");
INSERT INTO bfz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","शास्त्रिए और फरीसिये ये देखी खे की ये तो पापिया और चुंगी लणे वाल़ेया साथे रोटी खाणे लगी रा, तेसरे चेलेया खे बोलेया, “ये तो चुंगी लणे वाल़े और पापिया साथे कऊँ खाओ पीओआ?” ");
INSERT INTO bfz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","यीशुए ये सुणी की तिना खे बोलेया, “जो पले चंगे ए, तिना खे बैदो री जरूरत नि ऊँदी, पर बमारा खे ओई। आऊँ एड़ेया लोका खे बुलाणे नि आई रा जो सोचोए कि आँऊ तर्मी ए, पर आँऊ पापिया खे बुलाणे और तिना रा उद्धार करने आई रा।” ");
INSERT INTO bfz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","बपतिस्मा देणे वाल़े यूहन्ने रे चेले और फरीसी बअरत करोए। तेबे कुछ लोक यीशुए गे आये और पूछेया, “यूहन्ने रे चेले और फरीसी बअरत राखोए, पर तेरे चेले कऊँ बअरत नि करदे?” ");
INSERT INTO bfz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीशुए तिना खे बोलेया, “जदुओ तक लाड़ा बरातिया साथे रओआ, क्या सेयो बअरत करी सकोए? ना, जदुओ तक लाड़ा तिना साथे ए, तदुओ तक सेयो बअरत नि करी सकदे। ");
INSERT INTO bfz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पर, सेयो दिन आऊणे, जेबे लाड़ा बरातिया ते लग करेया जाणा, तेस बखते तिना बअरत करना। ");
INSERT INTO bfz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“नये कपड़े री टाली, पुराणे टालेया रे कोई नि लगांदा, कऊँकि टाली पुराणे टालेया खे ओर बी कट्ठा करी देओ ई, मतलब-नया टाला पुराणे साथे ओर बी जादा फटी जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नया अँगूरा रा रस पुराणे खल्लड़ुआ रे कोई नि परदा, नई तो अँगूरा रा रस फैली जाणा और तेस खल्लड़ु फाड़ी देणे और अँगूरा रा रस और खल्लड़ु दोनो ई खराब ऊई जाणे, पर नया अँगूरा रा रस, नये खल्लड़ुआ रे परेया जाओआ।” ");
INSERT INTO bfz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","एड़ा ऊआ कि यीशु और तिना रे चेले आरामो रे दिने डोरूआ रिये जाणे लगी रे थे और तिना रे चेले जांदे ऊए सिल्ले तोड़ने लगे। ");
INSERT INTO bfz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तेबे फरीसिये ये देखी की यीशुए खे बोलेया, “तेरे चेले आरामो रे दिने एड़ा काम कऊँ लगी रे करने? क्या इना खे एड़ा करना बिधानो रे मुताबिक खरा ए?” ");
INSERT INTO bfz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","यीशुए तिना खे बोलेया, “क्या तुसे पढ़ी नि राखेया कि जेबे दाऊदो खे जरूरत पड़ी और जेबे तेसखे और तेसरे साथिया खे पूख लगी, तेबे तिने क्या कित्तेया था? ");
INSERT INTO bfz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","तिने किंयाँ अबियातार प्रदान पुरोईतो रे बखते परमेशरो रे भवनो रे जाई की पेंटा रिया रोटिया खाईया, बिधानो रे मुताबिक पुरोईतो खे छाडी की ओर केसी खे बी खाणा ठीक निए और आपणे साथिया खे बी दित्तिया।” ");
INSERT INTO bfz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","यीशुए तिना खे बोलेया, “आरामो रा दिन मांणूआ खे बणाई राखेया, मांणू आरामो खे निए बणाए रे। ");
INSERT INTO bfz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","तेबेई तो आँऊ माणूं रा पुत्र आरामो रे दिनो रा बी प्रभु ए।” ");
INSERT INTO bfz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","यीशु प्रार्थना रे कअरो रे फेर गए, तेबे तेती एक मांणू था, जेसरा आथ सूकेया रा था। ");
INSERT INTO bfz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","तेबे कुछ फरीसी यीशुए पाँदे दोष लगाणे खे और तिना खे काणे रे चक्रो रे थे कि देखूँए कि आरामो रे दिने तेसखे ये ठीक करोआ की नयी। ");
INSERT INTO bfz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","तिने सूके रे आथो वाल़े मांणूए खे बोलेया, “बीचे जे खड़ा ऊई जा।” ");
INSERT INTO bfz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","तेबे यीशुए फरीसिया खे बोलेया, “आरामो रे दिने बिधानो रे मुताबिक खरा करना ठीक ए या बुरा करना, प्राण बचाणा या मारना।” पर सेयो चुप रए। ");
INSERT INTO bfz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","तेबे यीशुए तिना रे मनो रे जिद्दी सबाओ ते उदास ऊई की तिना खे रोषो रे चऊँ कनारो खे देखेया और तेस मांणूए खे बोलेया, “आपणा आथ आगे कर” तिने आगे कित्तेया और तेसरा आथ ठीक ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तेबे फरीसी बारे गए और हेरोदेसो खे समर्थन देणे वाल़े यहूदिया साथे मिली की तिना रे खलाफ योजना बणाई कि तिना खे किंयाँ नाश करिए? ");
INSERT INTO bfz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","यीशु आपणे चेलेया साथे समुद्रो रे कनारे चली गे और गलील प्रदेश ते एक बड़ी पीड़ तिना पीछे आईगी। ");
INSERT INTO bfz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","तेबे तिना रे अचम्बे रे काम सुणी की यरूशलेम नगरो, यहूदिया प्रदेश, इदुमिया प्रदेश और यरदन नदिया रे पारो ते सूर और सैदा नगरो रे नेड़े ते एक बड़ी पीड़ तिना गे आई। ");
INSERT INTO bfz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","तेबे यीशुए आपणे चेलेया खे बोलेया, “पीड़ मुखती ए, एड़ा नि ओ केथी आऊँ दबी जाऊँ, तो तुसे माखे एक किस्ती त्यार करी दो।” ");
INSERT INTO bfz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","कऊँकि तिने बऊत ठीक कित्ते थे, तेबे जितणे लोका खे बमारिया थिया, सेयो तिना खे छूणे री खातर तिना पाँदे टूटी पड़ो थे। ");
INSERT INTO bfz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","दुष्टात्मा बी, जेबे यीशुए खे देखो थिया, तो सेयो तिना रे सामणे रूड़ी जाओ थिया; और चींगी की बोलो थिया, “तूँ परमेशरो रा पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","यीशुए दुष्टात्मा बऊत सावधान कित्तिया कि केसी गे मेरे बारे रे नि बताणा, “आँऊ परमेशरो रा पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","इजी ते बाद यीशु पाह्ड़ो पाँदे चली गे, और जिना खे से चाओ थे, सेयो आपू गे बुलाए और सेयो तिना गे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तेबे यीशुए बारा मर्दा खे प्रेरिता री पदवी दित्ती ताकि सेयो तिना साथे-साथे रओ और तिना खे प्रचार करने खे पेजो। ");
INSERT INTO bfz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","और तिना खे दुष्टात्मा खे निकयाल़ने रा अक्क ओ। ");
INSERT INTO bfz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","और सेयो यो ए, शमौन जेसरा नाओं यीशुए पतरस राखेया। ");
INSERT INTO bfz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जब्दिए रे पाऊ याकूब और तेसरा पाई यूहन्ना, जिना रा नाओं तिने बूअनरगिस, मतलब, गर्जणो रे पाऊ राखेया। ");
INSERT INTO bfz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","और अन्द्रियास, फिलिप्पुस, बरतुल्मै, मत्ती, थोमा, हलफईसो रा पाऊ याकूब, तद्दै और दूजा शमौन कनानी, देशभक्त तेते समूह रा सदस्य था जो रोमी सरकारा रे खलाफ थे। ");
INSERT INTO bfz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","और यहूदा इस्करियोती, जिने यीशु बादो ते तोखे ते पकड़वाए बी थे। ");
INSERT INTO bfz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","तेबे यीशु और तिना रे चेले कअरे आए और तिना गे फेर इतणी पीड़ कट्ठी ऊईगी कि सेयो रोटी पनि खाई सके। ");
INSERT INTO bfz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जेबे तिना रे टब्बरो वाल़ेया ये सुणेया, तो सेयो तिना खे पकड़ने खे निकल़े, कऊँकि तिना रा मानणा था कि एसरा दमाक ठकाणे निए। ");
INSERT INTO bfz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","जो शास्त्री यरूशलेम नगरो ते आए थे सेयो बोलो थे, “एसरे शैतान ए,” और “ये दुष्टात्मा रे सरदारो री मतादा साथे दुष्टात्मा खे निकयाल़ोआ।” ");
INSERT INTO bfz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","तेबे यीशु तिना खे नेड़े बुलाई की तिना ते उदारणो रे बोलणे लगे, “शैतान आपणे आपू खे और आपणी दुष्टात्मा खे किंयाँ निकयाल़ी सकोआ? ");
INSERT INTO bfz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","और जे केसी राज्य रे फूट पड़ी जाओ तो, से राज्य किंयाँ खड़ा रई सकोआ? ");
INSERT INTO bfz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","और केसी रे कअरे फूट पड़ी जाओ तो, से कअर किंयाँ बणेया रा रई सकोआ? ");
INSERT INTO bfz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","और जे शैतान आपणेया रा ई बैरी बणी जाओगा, तो, से किंयाँ बणेया रा रई सकोआ? तेसरा तो अन्त ई ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“पर कोई मांणू केसी तागतबरो रे कअरे कूसी की, तेसरा माल किंयाँ लूटी सकोआ? जदुओ तक से तेसखे बानी नि लओगा और तिजी ते बाद ई से तेसरा माल लूटी सकोआ। ");
INSERT INTO bfz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“आऊँ तुसा खे सच लगी रा बोलणे कि मांणूए रे सारे पाप और निन्दा जो से करोआ, माफ ऊई जाणे। ");
INSERT INTO bfz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पर जो पवित्र आत्मा री निन्दा करोआ, तेसखे कदी बी माफी नि मिलणी, और से अनन्त पापो रा अपराधी ऊई जाओ आ।” ");
INSERT INTO bfz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","यीशुए ये तेबे बोलेया कऊँकि सेयो ईंयां बोलो थे, “एसरे दुष्टात्मा ए।” ");
INSERT INTO bfz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","तेबे यीशुए री आम्मा और तेसरे पाई आए और तेबे तिने बारे खड़ी की तिना खे सन्देशा पेजेया। ");
INSERT INTO bfz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","यीशुए रे नेड़े पीड़ थी बैठी री, तेबे तिने यीशुए खे बोलेया, “देख, तुसा री आम्मा और पाई और बईण तुसा ते मिलणा चाओए।” ");
INSERT INTO bfz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","यीशुए तिना खे बोलेया, “मेरी आम्मा और पाई कूणे?” ");
INSERT INTO bfz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","तेबे तिने, जो तिना रे नेड़े थे बैठे रे, तिना खे देखेया और बोलेया, “देखो, मेरी आम्मा और पाई यो ईए। ");
INSERT INTO bfz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","कऊँकि जो परमेशरो री इच्छा पाँदे चलोआ, सेई मेरे पाई, बईण और आम्मा ए।” ");
INSERT INTO bfz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","यीशु फेर समुद्रो रे कनारे उपदेश देणे लगे, तेबे लोका री इतणी बड़ी पीड़ तेती कट्ठी ऊईगी कि सेयो समुद्रो रे एक किस्तिया रे बैठीगे और लोक कनारे पाँदे खड़े रे रये। ");
INSERT INTO bfz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","तेबे से उदारणो रे तिना खे बऊत गल्ला सिखाणे लगे और उपदेशो रे तिना खे बोलणे लगेया, ");
INSERT INTO bfz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“सुणो! देखो, एक बेजा बाणे वाल़ा, बेजा बाणे निकल़ेया। ");
INSERT INTO bfz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","तेबे कुछ बिऊ बांदे बखते बाटा रे छूटी गे और सेयो पंछिए चुगी ले। ");
INSERT INTO bfz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","कुछ बिऊ सापड़ी पाँदे छूटी गे और तेती जादा माट्टी ना ऊणे री बजअ ते सेयो चट-चट जम्मी गे ");
INSERT INTO bfz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","और जेबे सूरज निकल़ेया तो तूपा रे फूकी गे और जड़ ना पकड़ने री बजअ ते सूकी गे। ");
INSERT INTO bfz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","तेबे कुछ बिऊ जाड़ो रे छूटी गे और जाड़ बड़ी गा और सेयो दबी गे और तिना रे कोई फल नि लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पर कुछ बिऊ अच्छी जमीना पाँदे छूटे और सेयो जम्मी गे और बड़े ऊई की फल ल्याए, कोई तीइ गुणा, कोई साठ गुणा और कोई सौ गुणा।” ");
INSERT INTO bfz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","तेबे तिने बोलेया, “जो समजी सकोआ से तिजी खे त्यानो साथे सुणो और मानी बी लओ।” ");
INSERT INTO bfz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जेबे यीशु आपणे बारा चेलेया और कुछ साथिया साथे कल्ले थे तेबे तिने यीशुए ते इना उदारणा रे बारे रे पूछेया। ");
INSERT INTO bfz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","यीशुए तिना खे बोलेया, “तुसा खे तो परमेशरो रे राज्य रे पेतो री समज दित्ती रिये, पर बाकि लोका खे उदारणा रेई सारिया गल्ला बोलणिया पड़ोईया। ");
INSERT INTO bfz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","कऊँकि “सेयो देखोए, पर तिना खे सुजदा नि, सेयो सुणदे ऊए तो सुणोए, पर समजदे नि, एड़ा नि ओ केथी तिना रा मन फिरी जाओ और तिना रे पाप माफ ऊई जाओ।” ");
INSERT INTO bfz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","तेबे यीशुए तिना खे बोलेया, “अगर तुसे एस उदारणो खे नि समजदे? तो तुसा ओर क्या उदारण समजणे ");
INSERT INTO bfz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","बाणे वाल़ा परमेशरो रा वचन लगी रा बाणे। ");
INSERT INTO bfz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जो बिऊ बाटा रे छूटे थे, सेयो ये लोक ए जिने परमेशरो रा वचन सुणेया, पर शैतान तिना खे फटाफट जो तिने सुणी राखेया था, चोरी की लई जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","तिंयाँ ई जो सापड़ी पाँदली जमीना पाँदे बाए जाओए, सेयो ये लोक ए जो परमेशरो रा वचन सुणी की खुशी-खुशी मानी लओए। ");
INSERT INTO bfz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पर सेयो लोक तिना छोटी जी डाल़िया जेड़े जो जड़ ना राखणे री बजअ ते सेयो थोड़े ई दिना खे ओईया; जेबे वचनो री बजअ ते तिना पाँदे क्ल़ेश या उपद्रव ओए, तो सेयो चट ई ठोकर खाई लओए ");
INSERT INTO bfz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","और जो जाड़ो रे बाए थे, सेयो ये लोक ए, जिने परमेशरो रा वचन सुणेया, ");
INSERT INTO bfz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","पर दुनिया री चिन्ता, पैसे रा तोखा और कई चीजा रा लोब तिना रे बसी की वचनो खे दबाई देओआ और से निष्फल रई जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","जो अच्छी जमीना रे बाए थे, सेयो यो लोक ए, जो परमेशरो रा वचन सुणी की मानी लओए और आत्मिक फल ल्याओ ए, कोई तीइ गुणा, कोई साठ गुणा और कोई सौ गुणा।” ");
INSERT INTO bfz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","तेबे यीशुए तिना खे बोलेया, “क्या दिऊए खे इजी री खातर ल्याओ कि टोकरूए या माँजे निठे राखो? क्या इजी री खातर नि कि फटिया पाँदे राखो? ");
INSERT INTO bfz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","कऊँकि कोई बी चीज छिपी नि सकदी; पर सामणे आओई ना कुछ गुप्त ए, पर सामणे आई जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","जो समजी सकोआ से तिजी खे त्यानो साथे सुणो और मानी बी लओ।” ");
INSERT INTO bfz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","तेबे यीशुए तिना खे बोलेया, “चौकस रओ कि क्या लगी रे सुणने? जेते नापे की तुसे नापोए, तिजी नापो साथे तुसा खे बी नापेया जाणा और तुसा खे जादा देणा। ");
INSERT INTO bfz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","जो मेरा वचन सुणोआ तेसखे ओर बी अक्ल दित्ती जाणी, पर जो मेरा वचन नि सुणदा, तेसते से बी जो तेसगे आए लई लणा।” ");
INSERT INTO bfz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","तेबे यीशुए बोलेया, “परमेशरो रा राज्य एड़ा ए, जिंयाँ कोई मांणू डोरूआ रे बीज सेटोआ ");
INSERT INTO bfz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","और ये जिम्मीदार राती सओआ, दिने जागोआ और सेयो बिऊ एड़े जम्मोए और बड़ोए कि तेसखे पता ई नि लगदा। ");
INSERT INTO bfz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","तरती आपू फल ल्याओ ई पईले लूंग तेबे सिल्ले और तेबे सिल्लेया रे त्यार दाँणा। ");
INSERT INTO bfz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पर जेबे दाँणा पाक्की जाओआ, तेबे ये जिम्मीदार फटाफट दराटी लगाओआ, कऊँकि बाडणे रा बखत ऊई जाओआ।” ");
INSERT INTO bfz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","तेबे यीशुए बोलेया, “आसे परमेशरो रे राज्य री तुलना किजी साथे करिए और केस उदारणो साथे परमेशरो रे राज्य रे बारे रे बताईए? ");
INSERT INTO bfz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","परमेशरो रा राज्य अऊरिया रे दाणे जेड़ा ए कि जेबे जमीना रे बाओए, तेबे सबी दाणेया ते छोटा ओआ। ");
INSERT INTO bfz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","पर जेबे से जम्मोआ, तेबे सबी सागो-पातो ते बड़ा ऊई जाओआ और तिजी रिया इतणिया बड़िया डाल़िया निकल़ोईया कि सर्गो रे पंछी तिजी री छांयाँ रे बसेरा करी सकोए।” ");
INSERT INTO bfz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","यीशु एड़े बऊत उदारण देई की तिना रे समजणे रे मुताबिक तिना खे परमेशरो रा वचन सुणाओ थे ");
INSERT INTO bfz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","और सब कुछ उदारणो साथे बोलो थे, पर सेयो कल्ले जे आपणे चेलेया खे बुलाओ थे और हर उदारणा रा मतलब समजयाओ थे। ");
INSERT INTO bfz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","तेसी दिने जेबे साँज ऊई, तेबे यीशुए चेलेया खे बोलेया, “आओ, आसे समुद्रो ते पार चलूँए।” ");
INSERT INTO bfz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","तेबे चेले पीड़ा खे छाडी की तेते किस्तिया रे गए, जेते किस्तिया रे यीशु पईले तेई बैठे रे थे और सेयो यीशुए खे लई की पार चली गे और तिना साथे ओर बी किस्तिया थिया। ");
INSERT INTO bfz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","तेबे बऊत बड़ा पारी तूफान आया और लईरा एड़िया आईया कि किस्ती पाणिए साथे फरने वाल़ी थी। ");
INSERT INTO bfz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","यीशु पीछे गद्दिया पाँदे सऊणे लगी रे थे, तेबे चेलेया यीशुए खे जगाई की बोलेया, “ओ गुरू! क्या तुसा खे फिकर निए कि आसे डूबणे वाल़े ए?” ");
INSERT INTO bfz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तेबे यीशु उठी की तूफानो खे बके और पाणिए खे बोलेया, “शान्त रओ और रूकी जा!” और तूफान रूकी गा, तेबे बड़ी शांति ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","तेबे यीशुए चेलेया खे बोलेया, “तुसे कऊँ डरोए? क्या तुसा खे एबुए तक विश्वास निए?” ");
INSERT INTO bfz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","तेबे चेले बऊत डरी गे और आपू बीचे बोलणे लगे, “ये कूणे, जो न केवल दुष्टात्मा बल्कि तूफान और पाणी बी एसरी आज्ञा खे मानोए?” ");
INSERT INTO bfz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","तेबे यीशु और तिना रे चेले गलीली समुद्रो ते पार गिरासेनियो रे प्रदेशो रे पऊँछी गे। ");
INSERT INTO bfz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","जेबे यीशु किस्तिया ते उतरे, तेबे तेबुई एक मांणू, जेसरे दुष्टात्मा थी, कब्रा ते निकल़ी की तिना खे मिलेया। ");
INSERT INTO bfz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","से कब्रिस्तानो रे रओ था और बऊत ई हुड़दंग मचाणे वाल़ा था। तेसखे कोई बी एबुए तक साँगल़ो रे बानी की नि राखी सको था। ");
INSERT INTO bfz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","कऊँकि से कई बार बेड़िये की और साँगल़ो साथे बानेया, पर तिने साँगल़ तोड़ी ते और बेड़िया रे टुकड़े-टुकड़े करी ते, तेसखे कोई बी वशो रे नि करी सको था। ");
INSERT INTO bfz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","से रात-दिन कब्रिस्तानो रे और पाह्ड़ो रे चींगदा रओ था और आपू खे पात्थरो साथे काईल करदा रओ था। ");
INSERT INTO bfz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","से यीशुए खे देखी की दूरो तेई दौड़ी गा और तिने तिना गे माथा टेकेया। ");
INSERT INTO bfz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","तेबे तिने ऊच्ची आवाजा रे चींगी की बोलेया, “ओ यीशु परमप्रदान परमेशरो रे पुत्र! माखे तांते क्या काम? आऊँ ताखे परमेशरो री कसम देऊँआ कि माखे दुःखी न कर।” ");
INSERT INTO bfz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","कऊँकि तिने तेसखे बोलेया था, “ओ दुष्टात्मा, एस मांणूए ते निकल़ी जा।” ");
INSERT INTO bfz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","यीशुए तेसते पूछेया, “तेरा नाओं क्या ए?” दुष्टात्मे बोलेया, “सेना कऊँकि आसे बऊत सारे ए।” ");
INSERT INTO bfz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","तेबे तिने तिना ते बऊत बिनती कित्ती, “आसा खे एसा जगा ते बारे नि पेज।” ");
INSERT INTO bfz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","तेती पाह्ड़ो पाँदे सूंअरो रा एक चूण्ड चरने लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","तेबे दुष्टात्मा यीशुए ते बिनती कित्ती, “आसा खे इना सूंअरा बीचे पेजी दे, ताकि आसे इना रे पीतरे चली जाऊँ।” ");
INSERT INTO bfz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","तेबे यीशुए तिना खे आज्ञा दित्ती, और दुष्टात्मा निकल़ी और सूंअरा रे चूण्डा रे समाई गी। जो दो ह्जारा रा था। तेबे से काअड़ी पाँदो ते छवाल़ खाई की समुद्रो रे पड़ी गा और डूबी की मरी गा। ");
INSERT INTO bfz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","तेबे तिना खे चराणे वाल़ेया दौड़ी की गांव और शईरो रे खबर दित्ती और जो ऊआ था लोक तेस देखणे आए। ");
INSERT INTO bfz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","यीशुए गे आई की सेयो, जेसरे दुष्टात्मा थी, मतलब-जेसरे सेना समाई री थी, से बिल्कुल ओशा रे और टाले पईनी की बैठे रा देखेया, और डरी गे। ");
INSERT INTO bfz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","एस आदसे खे देखणे वाल़ेया, तेसरा, जेसरे दुष्टात्मा थी और सूंअरा रा पूरा आल तिना खे सुणाया। ");
INSERT INTO bfz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तेबे सेयो यीशुए ते बिनती करने लगे, “म्हारे बन्ने ते चली जाओ।” ");
INSERT INTO bfz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","जेबे यीशु किस्तिया रे चढ़ने लगे और जेसरे दुष्टात्मा थी, तिने बोलेया, “माखे बी आपू साथे आऊणे दे। ");
INSERT INTO bfz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पर यीशुए तेसखे ना करी ती और तेसखे बोलेया कि आपणे कअरो खे वापस चली जा और लोका खे बता कि तां पाँदे प्रभुए केड़ी दया कित्ती और तेरी तंईं कितणे बड़े काम कित्ते।” ");
INSERT INTO bfz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","तेबे से दिकापुलिस प्रदेशो खे गया और इना गल्ला रा प्रचार करने लगेया, “यीशुए मेरिया तंईं कितणे बड़े काम कित्ते।” ये सुणी की सब लोक हैरान उई गे। ");
INSERT INTO bfz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जेबे यीशु किस्तिया रे वारले कनारे आए और समुद्रो रे कनारे पऊँछी गे तेबे एक बड़ी पारी पीड़ तिना गे कट्ठी ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","तेबे याईर नाओं रे प्रार्थना रे कअरो रे सरदारा बीचा ते एक तेती आया और यीशुए खे देखी की तिना रे पैरो पाँदे पड़ी गा। ");
INSERT INTO bfz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","तेबे तिने बिनती कित्ती और बोलेया, “मेरी छोटी बेटी मरने वाल़ी ए, तुसे मेरे कअरे आई की तेसा पाँदे आथ राखो, ताकि से ठीक ऊई जाओ और जिऊँदी रओ।” ");
INSERT INTO bfz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तेबे यीशु तेस साथे चली गे, और एक बड़ी पारी पीड़ बी तिना साथे आईगी, एथो तक की लोक तिना पाँदे रूड़ी जाओ थे। ");
INSERT INTO bfz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","तेबे एक जवाणस जो तेसा पीड़ा रे थी, जेसा खे बारा साला ते खून बइणे री बमारी थी ");
INSERT INTO bfz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","और से आपू खे ठीक ऊणे री तंईं कई बैदा गे गई और आपणा सब कुछ खर्च करी ता, पर से ओर बी बमार ऊईगी और कुछ फाईदा नि ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","यीशुए रे बारे रे सुणी की से पीड़ा ते पीछे ते आई और तिना रे टाले छूँएं। ");
INSERT INTO bfz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","कऊँकि से बोलो थी, “जे आऊँ तिना रे टाले ई छुँईं लऊँगी, तो ठीक ऊई जाणी।” ");
INSERT INTO bfz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","और तेबुई तेसा रा खून बइणा बंद ऊईगा और तेसे आपणे शरीरो ते जाणी ला कि मेरी बमारी ठीक ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीशुए तेबुई आपू रे जाणी ला, “मांते सामर्थ निकल़ी री।” तेबे तिने पीड़ा रे पीछे मुड़ी की पूछेया, “मेरे टाले किने छुँए?” ");
INSERT INTO bfz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","तिना रे चेलेया तिना खे बोलेया, “तुसा खे पता तो आए कि इतणी पीड़ तुसा पाँदे पड़ी री और तुसे बोलोए, ‘आऊँ किने छूँयां?’ ” ");
INSERT INTO bfz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","तेबे यीशु ये देखणे री तंईं, “आऊँ किने छूँयां” सेयो चऊँ कनारे देखणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","तेबे से जवाणस ये जाणी गी कि मां साथे केड़ी पलाई ऊई री, से डरदी और थरथरांदी ऊई आई और यीशुए रे पैरा पाँदे पड़ी गी और तेसे सारा आल सच-सच तिना खे सुणाया। ");
INSERT INTO bfz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","यीशुए तेसा खे बोलेया, “बेटिये, तेरे विश्वासे तूँ ठीक कित्ती। बेफिकर ऊई की जा और आपणी एसा बमारिया ते बची री रओ।” ");
INSERT INTO bfz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","यीशु ये बोलणे ई लगी रे थे कि प्रार्थना रे कअरो रे सरदारो रे कअरो ते कुछ लोक आए और बोलेया, “तेरी मुन्नी मरी गी। एबे गुरूओ खे कष्ट कऊँ लगी रा देणे?” ");
INSERT INTO bfz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","जो गल्ल सेयो करने लगी रे थे, से यीशुए अणसुणी करी की प्रार्थना रे कअरो रे सरदारो खे बोलेया, “डर नि; बस विश्वास राख।” ");
INSERT INTO bfz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","तेबे यीशुए पतरस, याकूब और तेसरा पाई यूहन्ने खे छाडी की कोई बी आपू साथे आऊणे नि दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","तेबे प्रार्थना रे कअरो रे सरदारो रे कअरे पऊँछी की तिने लोक रोंदे ऊए और राड़िया देंदे ऊए देखे। ");
INSERT INTO bfz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तेबे यीशुए पीतरे जाई की तिना खे बोलेया, “तुसे रोणे और राड़िया कऊँ लगी रे देणे? तेरी मुन्नी मरी नि रई, पर सऊणे लगी री।” ");
INSERT INTO bfz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","सेयो ये गल्ल सुणी की यीशुए रा मजाक लगे ऊड़ाणे, पर तिने सब जणे बारे निकयाल़ी की मुन्निया रे माए-बाओ और आपणे तीनो चेलेया साथे पितरे गया, जेती मुन्नी थी पड़ी री। ");
INSERT INTO bfz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","तेबे तिने मुन्निया रा आथ पकड़ी की तेसा खे बोलेया, “तलीता कूमी!” मतलब “ओ मुन्निए आऊँ ताखे बोलूँआ कि उठ।” ");
INSERT INTO bfz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","तेबे मुन्नी उठी और फटाफट चलणे-फिरने लगी। से बारा साला री थी। ये देखी की सारे लोक बऊत हैरान रई गे। ");
INSERT INTO bfz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","तेबे तिने तिना खे सावधान करी की बोलेया, “ये गल्ल केसी गे नि बोलणी और एसा मुन्निया खे कुछ खाणे खे देओ।” ");
INSERT INTO bfz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","यीशु कफरनहूमो ते निकल़ी की आपणे नगर नासरतो खे आए और तिना रे चेले बी तिना साथे आए। ");
INSERT INTO bfz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","आरामो रे दिने सेयो प्रार्थना रे कअरो रे उपदेश देणे लगे, उपदेश सुणी की लोक हैरान ऊईगे और बोलणे लगे, “यो गल्ला एसखे किंयाँ ए पता? और ये कुण जा ज्ञान ए, जो एसखे देई राखेया? और एसरे आथो साथे यो सामर्थो रे काम किंयाँ ओए? ");
INSERT INTO bfz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","आसे जाणूंए कि ये लकड़िया रा मिस्त्री ए, जो मरियमो रा पाऊ ए और याकूब, योसेस, यहूदा और शमौनो रा पाई ए और क्या एसरिया बईणी आसा बीचे ई नि रंदिया?” इजी बजअ ते तिने तेसखे अपनाणे ते न कित्ती। ");
INSERT INTO bfz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीशुए तिना खे बोलेया, “भविष्यबक्ता रा आपणे इलाके रे, आपणे टब्बर और आपणे कअरो खे छाडी की ओरथी सारी जगा आदर ओआ।” ");
INSERT INTO bfz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","तेबे सेयो नासरत नगरो रे बऊत सामर्था रे काम नि करी सके, बस तिने कुछ बमारा पाँदे आथ राखी की सेयो ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","तेबे सेयो, तिना रा अविश्वास देखी की हैरान ऊईगे, और तेबे सेयो गांव रे चऊँ कनारे कूमदे ऊए उपदेश देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","तेबे यीशुए बारा चेले बुलाई की दो-दो करी की पेजे और तिना खे दुष्टात्मा खे निकयाल़ने रा अक्क दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","तेबे यीशुए तिना खे आज्ञा दित्ती, “बाटा खे आपू साथे डण्डा छाडी की ओर कुछ नि लणा; ना रोटी, ना चोल़ी और ना बटुए रे पैसे। ");
INSERT INTO bfz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","पर जोड़े पईनो, और आपू साथे दो जोड़ी टाल्ले नि राखो।” ");
INSERT INTO bfz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","तेबे तिने तिना खे बोलेया, “जेबे तुसे केसी नगरो रे जाओ और कोई तुसा खे आपणे कअरे बुलाओ, तो जदुओ तक तुसे तेस इलाके ते चली नि जाओ, तदुओ तक तेस ई कअरो रे रओ। ");
INSERT INTO bfz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जेते जगा रे लोक तुसा खे नि मानो और तुसा री नि सुणो, तो तेथा ते चलदे बणो और आपणे पैरा री तूड़ तेथी चाड़ी देओ, ताकि तिना रे खलाफ सबूत ओ।” ");
INSERT INTO bfz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","तेबे चेलेया जाई की प्रचार कित्तेया, “मन फिराओ।” ");
INSERT INTO bfz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","तिने बऊत दुष्टात्मा निकयाल़िया और बऊत बमार तेल मल़ी की ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","तेबे हेरोदेस राजे यीशुए रे बारे रे सुणेया, कऊँकि तिना रा नाओं बऊत फैली गा था। तेबे कुछ लोक ईंयां बोलो थे, “यूहन्ना बपतिस्मा देणे वाल़ा मरे रेया बीचा ते जिऊँदा उई गा रा, तेबेई तो तेसते यो सामर्था रे काम ओए।” ");
INSERT INTO bfz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","तेबे कुछ जणे बोलेया, “ये तो एलिय्याह ए”, कुछ जणे बोलेया, “भविष्यबक्तेया बीचा ते कोई एक ए।” ");
INSERT INTO bfz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","हेरोदेसे राजे ये सुणी की बोलेया, “जेस यूहन्ने रा सिर मैं बडवाया था, ये सेई जिऊँदा ऊईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","कऊँकि हेरोदेसे आपणे पाई फिलिप्पुसो री लाड़ी हेरोदियासा री बजअ ते, जेसा साथे तिने ब्या कित्तेया था, लोका खे पेजी की यूहन्ना पकड़वाया और जेला रे पाईता था। ");
INSERT INTO bfz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","कऊँकि यूहन्ने हेरोदेसो खे बोलेया था, “आपणे पाईए री लाड़ी राखणा ताखे खरी गल्ल निए।” ");
INSERT INTO bfz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","तेबेई तो हेरोदियास यूहन्ने साथे दुश्मणी राखो थी और ये चाओ थी कि एसखे कुल़वाई देऊँ, पर एड़ा नि ऊई सकेया। ");
INSERT INTO bfz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","कऊँकि हेरोदेस यूहन्ने खे तर्मी और पवित्र मांणू मानो था और तेसते डरो था और तेसखे बचाए रे राखो था और तेसरी सुणी की बऊत कबराओ था, पर बऊत खुश ओ था। ");
INSERT INTO bfz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","तेबे ठीक मोके पाँदे, जेबे हेरोदेसो रा जन्मदिन था, तेबे तिने आपणे प्रदाना खे, सेनापतिया और गलीलो रे बड़े लोका खे पाट्टी राखी। ");
INSERT INTO bfz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","तेबे हेरोदियासा री मुन्नी पीतरे आई और नाचणे लगी, तेसा रा नाच देखी की हेरोदेस और तेस साथे बैठणे वाल़े खुश ऊईगे। तेबे हेरोदेस राजे तेसा खे बोलेया, “माँग, जो ताखे चाईयो, मां ताखे देणा” ");
INSERT INTO bfz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","और तिने कसम खाई, “आदे राज्य तक, जो तूँ मांगेगी, मां ताखे देणा।” ");
INSERT INTO bfz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","तेसे बारे जाई की आपणी आम्मा ते पूछेया, “आऊँ क्या मांगू?” माए बोलेया, “यूहन्ना बपतिस्मा देणे वाल़ेया रा सिर चाईयो।” ");
INSERT INTO bfz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","तेबे मुन्नी फटाफट राजे गे पितरे आई और तेसते बिनती करी की बोलेया, “आऊँ चाऊँई कि तूँ एबु यूहन्ना बपतिस्मा देणे वाल़े रा सिर एक थाल़िया रे माखे मंगवाई दे।” ");
INSERT INTO bfz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","तेबे हेरोदेस राजा बऊत उदास ऊईगा, पर आपणी कसमा री बजअ ते और आपू साथे बैठे रे लोका री बजअ ते, से तेसा री गल्ल टाल़ी नि सकेया। ");
INSERT INTO bfz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","तेबे राजे तेबुई एक जलाद पेजेया और तेसखे आज्ञा दित्ती कि तेसरा सिर बाडी की ल्याओ। ");
INSERT INTO bfz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","तेबे तिने जेला रे जाई की तेसरा सिर बाडेया और एक थाल़िया रे पाई की ल्याया और हेरोदियासा री मुन्निया खे दित्तेया, और मुन्निए आपणी आम्मा खे दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ये बुरी खबर सुणी की यूहन्ना रे चेले आए और तेसरी लोथ चकी की कब्रा रे राखी। ");
INSERT INTO bfz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","जेबे बारा प्रेरित जो यीशुए दुष्टात्माओं खे निकाल़ने रा अक्क देई की दो-दो करी की पेजे थे वापस आए तो जो कुछ तिने कित्तेया और जो सिखाई राखेया था, सब तिना गे बताया। ");
INSERT INTO bfz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","यीशुए चेलेया खे बोलेया, “तुसे आपू बी केथी जंगल़ो रे जाई की आराम करी लो।” तिने ये इजी खे बोलेया था, कऊँकि बऊत लोक आओ थे और तिना खे रोटी खाणे खे बी बखत नि मिलो था। ");
INSERT INTO bfz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","तेबे यीशु और तिना रे चेले किस्तिया रे चढ़ी की, सुणसाण जगा रे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","तेबे बऊत जणेया यीशु और तिना रे चेले जांदे ऊए देखी ले और तेबे सब नगरो रे लोक कट्ठे ऊई की पैदल ई दौड़ी गे और तिना ते पइले तेती पऊँछी गे। ");
INSERT INTO bfz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","तेबे तिने किस्तिया ते उतरी की एक बड़ी पीड़ देखी और तिना खे तेसा पीड़ा पाँदे तरस आया, कऊँकि सेयो तिना पेडा जेड़े थे, जिना रा कोई रखवाल़ा नि ऊँदा। तेबे यीशु तिना खे बऊत गल्ला सिखाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जेबे साँज ऊणे वाल़ी थी, तेबे तिना रे चेले तिना खे बोलणे लगे, “ये सुणसाण जगा ए और दिन बऊत चढ़ी गा रा। ");
INSERT INTO bfz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","एबे इना खे बिदा करी देयो, ताकि यो गांव, और बस्तिया रे जाई की आपू खे खाणे खे कुछ खरीदी सको।” ");
INSERT INTO bfz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","यीशुए तिना खे बोलेया, “तुसेई इना खे खाणे खे देयो।” चेलेया बोलेया, “क्या आसे इना खे दो सौ चाँदिए रे सिक्केया रे मोलो रे बराबर (मतलब दो सौ दिनो री मजदूरिया रे बराबर ए) रोटिया खरीदी लईये और इना खे खुल़ाईए?” ");
INSERT INTO bfz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","यीशुए तिना खे बोलेया, “जाओ और देखो तुसा गे कितणिया रोटिया ए?” तिने पता करी की बोलेया, “पाँज रोटिया और दो मछलिया ए।” ");
INSERT INTO bfz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तेबे यीशुए चेलेया खे आज्ञा दित्ती कि सबी खे अरे काओ पाँदे बांईठी रे बठयाल़ी देओ। ");
INSERT INTO bfz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","सेयो सौ-सौ और पंजा-पंजा, बांईठी रे बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","तेबे यीशुए सेयो दो मछलिया और पाँज रोटिया लईया और स्वर्गो खे देखी की धन्यवाद कित्तेया और रोटिया तोड़ी-तोड़ी की आपणे चेलेया खे दित्तिया कि लोका खे बांडी देओ और सेयो मछलिया बी बांडिया। ");
INSERT INTO bfz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","तेबे सब खाई की रजी गे। ");
INSERT INTO bfz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","और तेबे तिने बचे रे टुकड़ेया रिया बारा टोकरिया परी की चकिया और कुछ मछलिया बी थिया। ");
INSERT INTO bfz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","जिने रोटिया खाईया, तिना बीचे जादातर पाँज ह्जार तो मर्द थे। ");
INSERT INTO bfz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तेबे यीशुए तेबुई आपणे चेले किस्तिया रे चढ़ाए, ताकि सेयो तिना ते पईले, पार बैतसैदा नगरो खे चली जाओ, जदुओ तक की सेयो लोका खे बिदा करोए। ");
INSERT INTO bfz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","तेबे से पीड़ा खे बिदा करी की पाह्ड़ो पाँदे प्रार्थना करने खे गए। ");
INSERT INTO bfz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","जेबे साँज ऊई, तेबे चेलेया री किस्ती समुद्रो रे थी और यीशु कल्ले जमीना पाँदे थे। ");
INSERT INTO bfz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","यीशुए देखेया कि तिना रे चेले बड़ी मुश्किला साथे चप्पू चलांदे-चलांदे ऊए कबराणे लगी रे, कऊँकि अवा तिना रे खलाफ थी, तेबे सेयो राथियो रे चौथे पइरो रे नेड़े, समुद्रो रे पाणिए पाँदे चली की तिना गे आए और सेयो तिना ते आगे निकल़ना चाओ थे। ");
INSERT INTO bfz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पर जिंयाँ ई चेलेया यीशुए खे समुद्रो रे पाणिए पाँदे चलदे ऊए देखी की सोचेया कि ये तो पूत ए और सब डरो रे मारे चींगणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","कऊँकि सब तिना खे देखी की कबराई गे थे, पर यीशुए फटाफट तिना साथे गल्ल कित्ती और बोलेया, “याओ राखो। आऊँ ए। डरो नि।” ");
INSERT INTO bfz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तेबे सेयो तिना साथे किस्तिया रे आए और अवा रूकी गी, तिना रे चेले ये देखी की हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","कऊँकि सेयो एथो तक तिना रोटिया रे बारे रे नि समजे थे। और तिना रे मन कठोर ऊईगे थे। ");
INSERT INTO bfz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","तेबे यीशु और तिना रे चेले गलीली समुद्रो ते उतरी की गन्नेसरत नगरो री जगा रे पऊँछे और किस्ती कनारे पाँदे लगाईती। ");
INSERT INTO bfz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","जेबे सेयो किस्तिया ते उतरे, तेबे लोक तिना खे पछयाणने लगे ");
INSERT INTO bfz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","और ओरे-पोरे सारे-देशो रे दौड़े और बमारा खे माँजे पाँदे लटयाल़ी की, जेती-जेती सुणेया कि यीशु तेती ए, ");
INSERT INTO bfz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","सेयो तेथी-तेथी पऊँछी गे। और जेती केथी सेयो, गांव, नगर और बस्तिया रे जाओ थे, तेबे लोक बमारा खे बजारो रे छाडी की तिना ते बिनती करो थे कि बमारा खे बस आपणे टाले रा पल्ला ई छूणे दे। और जितणे तिना खे छूँओ थे, सेयो ठीक ऊई जाओ थे। ");
INSERT INTO bfz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","तेबे फरीसी और कई शास्त्री यीशुए गे कट्ठे ऊए, जो यरूशलेम नगरो ते आए थे। ");
INSERT INTO bfz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","तेबे तिने तिना रे चेले बिना आथ तोए रोटी खांदे ऊए देखे। ");
INSERT INTO bfz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","कऊँकि फरीसी और सब यहूदी बुजुर्गा रिया रवाजा पाँदे चलो थे और जदुओ तक तिना री रिवाजा रे मुताबिक ठीक टंगो रे आथ नि तोई लओ थे, तदुओ तक नि खाओ थे। ");
INSERT INTO bfz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","और बजारो ते आई की जदुओ तक नाई नि लओ थे, तदुओ तक नि खाओ थे और बऊत एड़िया गल्ला ए, जो सेयो मानोए-जेड़े-कटोरे, लोटे और तांबेया रे पांडे मांजणे। ");
INSERT INTO bfz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","तेबेई तो तिने फरीसिये और शास्त्रिए यीशुए ते पूछेया, “तेरे चेले बुजुर्गा रिया गल्ला कऊँ नि मानदे और बिना आथ तोए रोटी खाओए?” ");
INSERT INTO bfz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","यीशुए तिना खे बोलेया, “यशायाह भविष्यबक्ते तुसा कपटिया रे बारे रे ठीक भविष्यबाणी ए कित्ती री; जेड़ा लिखी राखेया, “ ‘यो लोक मुंओ ते तो मेरा आदर करोए, पर मनो ते मांते दूर रओए। ");
INSERT INTO bfz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","यो बिना मतलबो ते मेरी भक्ति करोए, कऊँकि मांणूए री आज्ञा खे यो तर्मो रा उपदेश करी की सिखाओए।’ ");
INSERT INTO bfz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","कऊँकि तुसे परमेशरो री आज्ञा खे टाल़ी की मांणूए री रवाजा खे मानोए।” ");
INSERT INTO bfz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","तेबे यीशुए तिना खे बोलेया, “तुसे मांणूए रे जरिए बणाई री रीति-रिवाजा खे मानणे री तंईं परमेशरो री आज्ञा खे कितणी चलाकिया साथे टाल़ी देओए। ");
INSERT INTO bfz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","कऊँकि मूसे नबीए बिधानो रे बोली राखेया, ‘आपणे माया-बावा रा आदर कर’ और ‘जो कोई तिना खे बुरा बोलोगा से जरूर काया जाणा।’ ");
INSERT INTO bfz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","पर तुसे बोलोए कि जे कोई आपणे माया-बावा खे बोलो, ‘जो कुछ तुसा खे मांते फाईदा ऊई सकोआ, से कुरबान ए, सब कुछ परमेशरो खे।’ क्या एड़ा बोलणा ठीक ए? ");
INSERT INTO bfz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","तो तेबे तुसे तेसखे आपणे माया-बावा री कुछ बी सेवा करने नि देंदे। ");
INSERT INTO bfz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ईंयां ई तुसे आपणी रवाजा ते, जो तुसे बणाई राखिया, परमेशरो रा वचन टाल़ी देओए और एड़े-एड़े ई बऊत बुरे काम करोए।” ");
INSERT INTO bfz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तेबे यीशुए लोका खे आपू गे बुलाई की बोलेया, “तुसे सब मेरी सुणो और समजो। ");
INSERT INTO bfz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","एड़ी कोई बी चीज निए जो मांणूआ खे बाअरा ते अशुद्ध करोई, पर जो गल्ला मांणूए रे पीतरो ते निकल़ोई, से मांणूए खे अशुद्ध करोई। ");
INSERT INTO bfz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","जो समजी सकोआ से तीजी खे त्यानो साथे सुणो और मानी बी लओ।” ");
INSERT INTO bfz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जेबे यीशु पीड़ा गे ते कअरो खे गए, तेबे तिना रे चेलेया तिना ते एस उदारणो रे बारे रे पूछेया। ");
INSERT INTO bfz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","तिने तिना खे बोलेया, “क्या तुसे बी एड़े ई नासमज ए? क्या तुसे नि जाणदे कि जो रोटी मांणू खाओआ, से तिजी ते अशुद्ध नि ऊई सकदा? ");
INSERT INTO bfz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","कऊँकि से तेसरे मनो रे नि, पर पेटो रे जाओई, और सड़यानी साथे निकल़ोई।” ये बोली की तिने सारी खाणे रिया चीजा शुद्ध ठईराई राखिया। ");
INSERT INTO bfz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","तेबे तिने बोलेया, “जो बुरिया गल्ला मांणूआ रे मुंओ ते निकल़ोईया, सेई तेसखे अशुद्ध बणाओईया। ");
INSERT INTO bfz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","कऊँकि मांणूए रे मनो रे बुरे-बुरे बिचार, व्याभिचार, चोरी, अत्या, ");
INSERT INTO bfz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","परस्त्रीगमन, लोब, दुष्टता, छल, लुचपण, बुरी नजर, निन्दा, कमण्ड और मुर्खता निकल़ोई। ");
INSERT INTO bfz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","यो सब बुरिया गल्ला पीतरो तेई निकल़ोईया और मांणूए खे बुरा बणाओईया।” ");
INSERT INTO bfz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","तेबे यीशु और तिना रे चेले गलील प्रदेशो ते उठी की सूर और सैदा रे नगरो खे आए और एक कअरो रे गए और सेयो चाओ थे कि कोई बी तिना रे बारे रे नि जाणो, पर सेयो लुकी नि सके। ");
INSERT INTO bfz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","तेबे एक जवाणस थी, जेसा री छोटी मुन्निया रे दुष्टात्मा आत्मा थी, तेसे यीशुए रे बारे रे सुणेया और तेबे से तिना गे आई और तिना रे पैरो पाँदे पड़ी गी। ");
INSERT INTO bfz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ये यूनानी और सूरूफिनीकी जातिया री थी, तेसे यीशुए ते बिनती कित्ती, “मेरी मुन्निया ते दुष्टात्मा निकयाल़ी दे।” ");
INSERT INTO bfz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","तिने तेसा खे बोलेया, “पईले बच्चेया खे रजणे दे, कऊँकि बच्चेया री रोटी कुत्तेया रे आगे राखणा खरी गल्ल निए।” ");
INSERT INTO bfz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","तेसे जवाणसे बोलेया, “सच ए प्रभु, पर तेबे बी तो छोटे कुत्ते बी बच्चेया री रोटिया ते बचे रे टुकड़ेया रा चूरा खाई लओए।” ");
INSERT INTO bfz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीशुए तेसा खे बोलेया, “जे एड़ी गल्ल ए, तेबे तो तूँ चली जा; दुष्टात्मा तेरी मुन्निया ते निकल़ी गी री।” ");
INSERT INTO bfz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","तेबे से आपणे कअरे आई और तेसे देखेया कि तेसा री मुन्नी माँजे पाँदे ए और दुष्टात्मा निकल़ी गी री। ");
INSERT INTO bfz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","तेबे यीशु सूर और सैदा रे नगरो ते निकल़ी की सिदोन और दिकापुलिसो रे प्रदेशो रे ऊँदे ऊए गलीलो रे समुद्रो रे नेड़े पऊँछे। ");
INSERT INTO bfz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","तेबे लोके एक मांणू तिना गे ल्याया जो टौणा और तूतला था, तेबे तिने यीशुए ते बिनती करी की बोलेया, “आपणा आथ एस पाँदे राखी देयो।” ");
INSERT INTO bfz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","तेबे यीशु तेसखे पीड़ा ते लग जे लईगे और आपणिया गुठिया तेसरे कानो रे पाईया और थूक लगाई की तेसरी जीब छुँईं। ");
INSERT INTO bfz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","तेबे तिने स्वर्गो खे लांबा साआ परी की देखेया और बोलेया, “ईप्फत्तह!” मतलब “खुली जा!” ");
INSERT INTO bfz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","तेबे से तेबुई सुणने लगेया और तेसरी जीब खुली गी और से साफ-साफ बोलणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तेबे तिने तेसखे सावधान करी की बोलेया, “केसी गे नि बोलणा।” पर जितणा तिने से सावधान कित्तेया, तिथणा ई से ओर बी प्रचार करने लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","तेबे सेयो लोक बऊत हैरान ऊई की बोलणे लगे, “तिने जो कुछ कित्तेया, अच्छा कित्तेया, सेयो टौणेया खे सुणने री और गूँगेया खे बोलणे री शक्ति देओ ए।” ");
INSERT INTO bfz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","तिना दिना रे जेबे बड़ी पीड़ कट्ठी ऊई और तिना गे कुछ खाणे खे नि था, तेबे तिने आपणे चेलेया खे आपू गे बुलाई की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“माखे एसा पीड़ा पाँदे तरस आओआ, कऊँकि ये तीन दिना ते बराबर मां साथे ए और इना गे कुछ बी एबे खाणे खे निए। ");
INSERT INTO bfz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","जे आऊँ इना खे पूखा कअरो खे पेजुँगा, तो यो बाटा रेई थकी जाणे, कऊँकि इना बीचा ते कोई-कोई बड़ी दूरो ते आई रे।” ");
INSERT INTO bfz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","तिना रे चेलेया तिना खे बोलेया, “एती सुणसाण जगा रे इतणिया सारिया रोटिया केथा ते ल्याईए, ताकि यो रज्जी जाओ?” ");
INSERT INTO bfz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","यीशुए तिना ते पूछेया, “तुसा गे कितणी रोटिया ए?” तिने बोलेया, “सात।” ");
INSERT INTO bfz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","तेबे यीशुए तिना खे बोलेया, “जमीना पाँदे बैठी जाओ।” तिने सेयो सात रोटिया लईया और परमेशरो रा धन्यवाद करी की तोड़िया और आपणे चेलेया खे देंदे गए कि इना लोका खे देओ, और सेयो लोका खे देंदे गए। ");
INSERT INTO bfz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","तिना गे थोड़ी जीया छोटिया मछलिया बी थिया और यीशुए सेयो बी धन्यवाद करी की लोका खे देणे खे बोलेया। ");
INSERT INTO bfz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","तेबे सेयो खाई की रज्जी गे और जो टुकड़े बची रे थे तिना रे सात बड़े टोकरू परी की चके। ");
INSERT INTO bfz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","खाणे वाल़े तकरीबन चार ह्जार लोक थे; तेबे तिने सेयो बिदा करी ते। ");
INSERT INTO bfz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","तेबे यीशु आपणेया चेलेया साथे किस्तिया पाँदे चढ़ी की दलमनूता नाओं रे नगरो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","तेबे फरीसी यीशुए साथे बईस करने लगे और तिना खे परखणे खे बोलेया, “कोई स्वर्गिय चिह्न् बता।” ");
INSERT INTO bfz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","तिने लांबा साआ परी की बोलेया, “एते जमाने रे लोक चिह्न् कऊँ टोल़ोए? आऊँ तुसा खे सच बोलूँआ कि एस बखतो रे लोका खे कोई बी चिह्न् नि देणा।” ");
INSERT INTO bfz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","तेबे सेयो तिना खे छाडी की किस्तिया रे बैठे और पार चली गे ");
INSERT INTO bfz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","चेले रोटिया लणा पूली गे थे और किस्तिया रे तिना गे बस एक ई रोटी थी। ");
INSERT INTO bfz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","तेबे यीशुए सेयो सावधान कित्ते कि देखो, “फरीसिये रे सजेड़े और हेरोदेसो रे सजेड़े ते चौकस रएयो” ");
INSERT INTO bfz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","चेले आपू बीचे सोच-बिचार करी की बोलणे लगे, “से इजी खे बोलोआ कऊँकि आसा गे तो रोटी आए ई नि।” ");
INSERT INTO bfz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ये जाणी की यीशुए तिना खे बोलेया, “तुसे आपू बीचे ये बिचार कऊँ लगी रे करने कि आसा गे रोटी निए? क्या एबुए तक नि जाणदे और समजदे नि? क्या तुसा रे अक्ल निए? ");
INSERT INTO bfz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","क्या आखी ऊँदे ऊए पनि देखदे और कान ऊँदे ऊए पनि सुणदे? क्या तुसा खे याद निए? ");
INSERT INTO bfz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","कि जेबे मैं पाँज ह्जार लोका खे पाँज रोटिया तोड़िया थिया और तुसे टुकड़े रिया कितणिया टोकरिया चकिया थिया?” तिने तिना खे बोलेया, “बारा टोकरिया।” ");
INSERT INTO bfz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","यीशुए फेर पूछेया, “जेबे चार ह्जारा लोका खे सात रोटिया थिया, तो तेबे तुसे टुकड़े रिया कितणिया टोकरिया चकिया थिया?” चेलेया बोलेया, “सात टोकरिया।” ");
INSERT INTO bfz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","यीशुए तिना खे बोलेया, “क्या तुसे एबुए तक नि समजदे?” ");
INSERT INTO bfz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","तेबे सेयो बैतसैदा नगरो खे आए और लोक एक अन्दे खे यीशुए गे ल्याए और बिनती कित्ती कि तुसे एसखे छुँईं देओ। ");
INSERT INTO bfz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","तेबे यीशु तेस अन्दे खे आथ पकड़ी की गांव ते बारे लईगे और तेसरी आखी पाँदे थूकी की आथ राखे और तेसते पूछेया, “क्या तूँ देखी सकेया?” ");
INSERT INTO bfz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","तिने आखी चकी की बोलेया, “आऊँ मांणूआ खे देखी सकूँआ, सेयो माखे चलदे ऊए डाल़ा जेड़े दिशोए।” ");
INSERT INTO bfz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तेबे यीशुए तेसरी आखी पाँदे फेर आथ राखे और तेबे तिने अन्दे त्यानो साथे देखेया और से ठीक ऊईगा और सब कुछ साफ-साफ देखणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","यीशुए से कअरो खे पेजेया और तेसखे बोलेया, “एस गांव रे पीतरे पैर पनि राखणा।” ");
INSERT INTO bfz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","यीशु और तिना रे चेले कैसरिया फिलिप्पिया नगरो रे नेड़े-तेड़े गांव खे चली गे; तेबे यीशुए बाटा रे तिना ते पूछेया, “लोक माखे क्या बोलोए?” ");
INSERT INTO bfz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","चेलेया जबाब दित्तेया, “यूहन्ना बपतिस्मा देणे वाल़ा; पर कोई-कोई एलिय्याह और कोई-कोई भविष्यबक्ता बीचा ते एक बी बोलोए।” ");
INSERT INTO bfz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","यीशुए तिना ते पूछेया, “पर तुसे माखे क्या बोलोए?” पतरसे तिना खे बोलेया, “तुसे मसीह ए, परमेशरो रे पेजे रे।” ");
INSERT INTO bfz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तेबे यीशुए तिना खे सावधान करी की बोलेया, ये केसी गे नि बताणा, “आँऊ ई मसीह ए।” ");
INSERT INTO bfz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","तेबे यीशु तिना खे बताणे लगे कि, “मां माणूं रे पुत्रो खे जरूरी ए कि आँऊ बऊत दु:ख उठाऊँ और बुजुर्ग, बड़े पुरोईत और शास्त्री माखे तुच्छ जाणी की काई देओ और आँऊ तीजे दिने जिऊँदा ऊई जाऊँ।” ");
INSERT INTO bfz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","यीशुए तिना खे साफ-साफ बताई ता। ये सुणी की पतरस तिना खे लग जे लईगा और थिड़कणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","पर यीशु मुड़े और आपणेया चेलेया खे देखी की पतरसो खे थिड़कणे लगे, “ओ शैतान! मेरी नजरा ते दूर ऊई जा; कऊँकि तूँ परमेशरो रिया गल्ला रे नि, पर मांणूए रिया गल्ला पाँदे आपणा मन लगाएया।” ");
INSERT INTO bfz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","यीशुए पीड़ा समेत आपणे चेले आपू गे बुलाए और तिना खे बोलेया, “जो कोई मां पीछे आऊणा चाओआ, से आपणा सब कुछ छाडी की और आपणे दुःखो और कष्टा रा क्रूस चकी की आपणी इच्छा ते मां पीछे आई जाओ। ");
INSERT INTO bfz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","कऊँकि जो कोई आपणा प्राण बचाणा चाओगा, तेस से खोणा, पर जो कोई मेरिया और सुसमाचारो रिया तंईं आपणे प्राण देओगा, तेस सच्ची ई आपणे प्राण बचाणे। ");
INSERT INTO bfz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","जे मांणूए खे सारी दुनिया मिली जाओ, और आपणे ई प्राण नि रओ, तो तेसखे क्या फाईदा? ");
INSERT INTO bfz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","और मांणूए आपणे प्राणो रे बदले ओर क्या देई सकोआ? ");
INSERT INTO bfz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जो कोई एसा व्याभिचारिया और पापी जातिया बीचे, मांते और मेरिया गल्ला ते शर्माओगा, तो तेबे मां माणूं रा पुत्रो बी, जेबे पवित्र स्वर्गदूता साथे आपणे पिते री महिमा साथे आऊणा, तो मां बी तेसते शर्माणा।” ");
INSERT INTO bfz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि जो एती खड़ी रे तिना बीचा ते कई एड़े ए, कि जदुओ तक परमेशरो रे राज्य खे सामर्था साथे आऊँदा ऊआ नि देखी लओगे, तदुओ तक नि मरने।” ");
INSERT INTO bfz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","छे दिनो ते बाद यीशुए पतरस, याकूब और यूहन्ना आपू साथे लए और लग जे ऊच्चे जे पाह्ड़ो पाँदे चली गे और तेती तिना सामणे यीशुए री शक्ल बदली गी। ");
INSERT INTO bfz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","तेबे तिना रे टाले ईतणे चमकणे लगे कि बड़े पारी साफ ऊईगे और तरतिया रे कोई बी तोबी इतणा साफ नि करी सकदा। ");
INSERT INTO bfz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","तेबे चेलेया खे पुराणे बखतो रे दो भविष्यवक्ता मूसा और एलिय्याह दिशे और सेयो यीशुए साथे गल्ला करो थे। ");
INSERT INTO bfz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ये देखी की पतरसे यीशुए खे बोलेया, “ओ गुरू! आसा रा एती रणा ठीक ए और आसे एड़ा करूँए कि तीन तम्बू बणाऊँए; एक तुसा खे, एक मूसे खे और एक एलिय्याहो खे।” ");
INSERT INTO bfz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","कऊँकि सेयो बऊत डरी गे थे और पतरस नि जाणो था कि क्या जवाब देऊँ। ");
INSERT INTO bfz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तेबे एक बादल़ तिना पाँदे छाईगा और तेस बादल़ो ते परमेशरो री ये आवाज आई, “ये मेरा प्यारा पुत्र ए, एसरी सुणो।” ");
INSERT INTO bfz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तेबे सेयो फटाफट चऊँ कनारे देखणे लगे और यीशुए खे छाडी की तिने ओर कोई नि देखेया। ");
INSERT INTO bfz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","पाह्ड़ो ते उतरदे ऊए यीशुए तिना खे आज्ञा दित्ती कि, “जदुओ तक आँऊ माणूं रा पुत्र, मरे रेया बीचा ते जिऊँदा नि ऊई जाऊँ, तदुओ तक जो कुछ तुसे देखी राखेया, से केसी गे नि बताणा।” ");
INSERT INTO bfz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","चेलेया ये गल्ल आपू तक ई राखी और आपू बीचे बात-चीत करने लगे, “मरे रेया बीचा ते जिऊँदा ऊणे रा क्या मतलब ए?” ");
INSERT INTO bfz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","तेबे तिने यीशुए ते पूछेया, “शास्त्री कऊँ बोलोए कि मसीह रे आऊणे ते पईले एलिय्याहो रा आऊणा जरूरी ए?” ");
INSERT INTO bfz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","यीशुए तिना खे जवाब दित्तेया, “एलिय्याह रा तो सच्ची पईले आऊणा और लोका रे मनो खे मेरिया तंईं त्यार करना जरूरी ए। पर पवित्र शास्त्रो रे माणूं रे पुत्रो रे बारे रे बी एड़ा कऊँ लिखी राखेया कि तेसखे बऊत दु:ख ऊणे और से तुच्छ समजेया जाणा? ");
INSERT INTO bfz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पर आऊँ तुसा खे सच बोलूँआ कि एलिय्याह तो आई चुकेया रा और जो तेसरे बारे रे लिखी राखेया था, तिने जो कुछ चाया तेस साथे कित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","और जेबे यीशु आपणे तीनो चेलेया साथे ओरी चेलेया नेड़े आए तो तेबे तिने देखेया कि तिना रे चऊँ कनारे पीड़ लगी री और शास्त्री तिना साथे बईस करने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","तेबे यीशुए खे देखी की सब हैरान ऊईगे और तिना गे दौड़ी की तिना खे नमस्कार कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","यीशुए तिना ते पूछेया, “तुसे इना साथे क्या बईस लगी रे करने?” ");
INSERT INTO bfz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","पीड़ा बीचा ते एकी जणे बोलेया, “ओ गुरू! आऊँ आपणे पाऊए खे तुसा गे ल्याई राखेया, जेसे दुष्टात्मे ये गूँगा करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","जेती-केथी से तेसखे पकड़ोई, तेथी पटकी देओई और एसरे मुंओ ते जगुड़ निकल़ने लगी जाओआ और से दाँद किरड़दा रओआ और सूकदा रओआ। मैं तुसा रे चेलेया खे बोलेया, ‘तुसे एसा खे निकयाल़ी देओ, पर सेयो निकयाल़ी नि सके।’ ” ");
INSERT INTO bfz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ये सुणी की यीशुए तिना खे जवाब दित्तेया, “ओ अविश्वासी लोको! मां कदुओ तक तुसा साथे रणा? और कदुओ तक तुसा खे सईन करुँ? बच्चे खे मांगे ल्याओ।” ");
INSERT INTO bfz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तेबे सेयो बच्चे खे यीशुए गे ल्याए; और जेबे दुष्टात्मे यीशुए खे देखेया, तो तेबे दुष्टात्मे बच्चा फटाफट मकरेड़ी ता और बच्चा जमीना पाँदे पड़ी गा, और से मुंओ ते जगुड़ निकयाल़दे ऊए कजणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","यीशुए तेसरे बाओ ते पूछेया, “एसरी ये आलत कदुओ ते ए?” ");
INSERT INTO bfz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","तिने बोलेया, “बचपनो ते। दुष्टात्मा एसरा नाश करने री तंईं, कदी ये आगी रे और कदी पाणिए रे रुड़ाया। पर जे तुसे कुछ करी सकोए तो आसा पाँदे तरस खाई की एसखे ठीक करी देयो।” ");
INSERT INTO bfz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीशुए तेसखे बोलेया, “जे तुसे करी सकोए तो, ये क्या गल्ल ऊई? विश्वास करने वाल़ेया खे सब कुछ ऊई सकोआ।” ");
INSERT INTO bfz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","तेस पाऊए रे बाओ फटाफट गिड़गिड़ाई की बोलेया, “ओ प्रभु! आऊँ विश्वास करूँआ। मेरे विश्वासो खे और बड़ाई देओ।” ");
INSERT INTO bfz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जेबे यीशुए देखेया कि लोक दौड़ी की पीड़ लगी रे लगाणे, तो सेयो दुष्टात्मा खे बके कि ओ “गूँगा और टौणा करने वाल़ी दुष्टात्मा, आऊँ ताखे आज्ञा देऊँआ कि एस बच्चे ते निकल़ी जा; और एसरे कदी दुबारा नि आऊणा।” ");
INSERT INTO bfz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तेबे से चींगी की और तेसखे मकरेड़ी की निकल़ी गी और पाऊ मरे रे जेड़ा ऊईगा। एथो तक बऊत लोक बोलणे लगे, “ये तो मरी गा रा।” ");
INSERT INTO bfz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पर यीशुए तेसरा आथ पकड़ी की से ठवाल़ेया और से खड़ा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जेबे यीशु कअरे आए, तेबे तिना रे चेलेया तिना ते लग जे जाई की पूछेया, “आसे तेसा खे कऊँ नि निकयाल़ी सके?” ");
INSERT INTO bfz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","यीशुए तिना खे बोलेया, “ये एड़ी दुष्टात्मा ए जो बअरतो साथे प्रार्थना करने ते अलावा कोई और उपाय ते नि निकल़ी सकदी।” ");
INSERT INTO bfz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","तेबे यीशु और तिना रे चेले तेथा ते चली की गलील प्रदेशो ते ऊई की जाणे लगी रे थे और सेयो नि चाओ थे कि कोई जाणो। ");
INSERT INTO bfz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","तेबे यीशु आपणे चेलेया खे उपदेश देणा चाओ था और बोलणे लगे, “आँऊ माणूं रा पुत्र, मांणूआ रे आथो रे पकड़वाऊणा और तिना आँऊ काई देणा और आँऊ मरने ते तीजे दिने जिऊँदा ऊई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पर ये गल्ल तिना री समजा रे नि आई और सेयो तिना ते पूछणे ते डरो थे। ");
INSERT INTO bfz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","तेबे यीशु आपणे चेलेया साथे कफरनहूम नगरो खे आए और कअरे आई की यीशुए तिना ते पूछेया, “बाटा रे तुसे कुण जी गल्ला रे बईस लगी रे थे करने?” ");
INSERT INTO bfz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","सेयो चुप रए, कऊँकि बाटा रे तिने बईस कित्ती थी, “आसा बीचा ते बड़ा कूण ए?” ");
INSERT INTO bfz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","तेबे यीशुए आपणे बारा चेले बुलाए और बोलेया, “जे कोई बड़ा ऊणा चाओआ तो, सबी ते छोटा और सबी रा सेवक बणो।” ");
INSERT INTO bfz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तेबे तिने एक बाल़क आपणी गोदा रे लया और तिना बीचे खड़ा कित्तेया और तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जो मेरे नाओं ते एड़े केसी एकी बाल़को खे बी मानोआ, से माखे मानोआ, और जो माखे मानोआ, से माखे नि, पर मेरे पेजणे वाल़े खे मानोआ।” ");
INSERT INTO bfz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","तेबे यूहन्ने नाओं रे चेले यीशुए खे बोलेया, “ओ गुरू! आसे एक मांणू तुसा रे नाओं ते दुष्टात्मा खे निकयाल़दा ऊआ देखेया और आसे तेसखे एड़ा करने ते ना कित्ती। कऊँकि से तेरा चेला नि था।” ");
INSERT INTO bfz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","यीशुए बोलेया, “तेसखे ना नि करो, कऊँकि एड़ा कोई निए जो मेरे नाओं ते सामर्था रे काम नि करो और फटाफट माखे बुरा बोली सको। ");
INSERT INTO bfz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","कऊँकि जो म्हारे खलाफ निए, से आसा साथे ए। ");
INSERT INTO bfz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जो कोई तुसा खे एक कटोरा पाणिए रा इजी री खातर पल़याओ कि तुसे मसीहे रे ए, तो आऊँ तुसा खे सच लगी रा बोलणे कि तेस आपणा प्रतिफल किंयाँ पनि खोणा।” ");
INSERT INTO bfz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","यीशुए बोलेया, “पर जो इना छोटेया बीचा ते, जो मां पाँदे विश्वास राखोए, केसी खे बी पापो रे पाओ तिना खे बऊत खतरनाक सजा मिलणी। तेसखे ये पला ऊँदा कि तेसरे गल़े रे एक बड़ा चाक्किया रा पूड़ लटकाई देओ और तेसखे समुद्रो रे सेटी देओ। ");
INSERT INTO bfz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","जे तेरा आथ ताखे पापो री बजअ बणोआ तो, तेस बाडी दे और टुण्डा ऊई की जिन्दगी जियो। ताखे येई ठीक ए कि दो आथ रंदे ऊए ताखे नरको री आगी रे सेटी देओ जो कदी बिजणी नि। ");
INSERT INTO bfz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","जेती कीड़ा शरीरो खे सदा खांदा रओआ और मरदा नि और आग बी सदा बल़दी रओई। ");
INSERT INTO bfz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","जे तेरा पैर पापो री बजअ बणोआ, तो तेस बाडी दे। लंगड़ा ऊई की तेरा जिऊणा इजी ते खरा ए कि दो पैर रंदे ऊए ताखे नरको रे सेटी देओ। ");
INSERT INTO bfz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","जेती कीड़ा शरीरो खे सदा खांदा रओआ और मरदा नि और आग बी सदा बल़दी रओई। ");
INSERT INTO bfz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","जे तेरी आख ताखे पापो री बजअ बणो ई, तो तेसा निकयाल़ी दे। काणा ऊई कि परमेशरो रे राज्य रे जाणा ताखे ये पला ए कि दो आखी रंदे ऊए तूँ नरको रे सेटेया जाओ। ");
INSERT INTO bfz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","जेती कीड़ा शरीरो खे सदा खांदा रओआ और मरदा नि और आग बी सदा बल़दी रओई। ");
INSERT INTO bfz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","कऊँकि हर एक मांणू आगी साथे ईंयां परखेया जाणा, जिंयाँ खाणे दे लूणो रा स्वाद चाखेया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","लूण अच्छा ए, पर जे लूणो रा स्वाद बिगड़ी जाओ तो से किजी साथे लूणका करना? आपू रे लूणो जेड़ा मित्रता रा स्वभाव राखो और आपू बीचे मिली-जुली की रओ।” ");
INSERT INTO bfz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","तेबे यीशु और तिना रे चेले कफरनहूम नगरो ते उठी की यहूदिया प्रदेशो रे बन्ने रे और यरदनो नदिया ते पार आए। पीड़ फेर तिना गे कट्ठी ऊईगी और यीशु तिना खे आपणे तरीके ते उपदेश देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तेबे फरीसिये तिना खे परखणे री तंईं तिना ते पूछेया, “क्या मांणूए खे आपणी लाड़िया खे छाडणा खरी गल्ल ए?” ");
INSERT INTO bfz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","यीशुए तिना खे जवाब दित्तेया, “मूसे बिधानो रे मुताबिक तुसा खे क्या आज्ञा देई राखी?” ");
INSERT INTO bfz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","फरीसिये बोलेया, “मूसे त्यागपत्र लिखणे री और छाडणे री आज्ञा देई राखी।” ");
INSERT INTO bfz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यीशुए बोलेया, “तुसा रे मनो रे जिद्दी सबाओ री बजअ ते तिने तुसा खे ये आज्ञा लिखी राखी। ");
INSERT INTO bfz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","पर सृष्टिया री शुरूआता तेई परमेशरे मर्द और जवाणस करी की सेयो बणाई राखे। ");
INSERT INTO bfz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","इजी बजअ ते मांणू आपणे माया-बावा ते लग ऊई की आपणी लाड़िया साथे रणा ");
INSERT INTO bfz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","और सेयो दोनो एक तन ऊणे। एबे सेयो दो नि, पर एक तन ए। ");
INSERT INTO bfz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","इजी री खातर जो परमेशरे जोड़ी राखे, तो लाड़ा-लाड़ी आपू बीचे एकी-दूजे खे नि छाडो।” ");
INSERT INTO bfz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","कअरे जाई की चेलेया एतेरे बारे रे फेर यीशुए ते पूछेया। ");
INSERT INTO bfz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","यीशुए तिना खे बोलेया, “जो कोई आपणी लाड़िया खे छाडी की केसी ओरी साथे ब्या करोआ, तो से तेसा पईलकिया रे खलाफ व्याभिचार करोआ। ");
INSERT INTO bfz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","जे लाड़ी आपणे लाड़े खे छाडी की दूजा ब्या करो, तो से व्याभिचार करोई।” ");
INSERT INTO bfz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","तेबे लोक बच्चेया खे यीशुए गे ल्याऊणे लगे, ताकि सेयो तिना पाँदे आथ राखी की आशीर्वाद देओ, पर चेले तिना खे बकणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीशुए ये देखी की तिना खे रोषो रे बोलेया, “बाल़का खे मांगे आऊणे देओ और तिना खे ना नि करो, कऊँकि परमेशरो रा राज्य एड़े रा ईए। ");
INSERT INTO bfz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","आऊँ तुसा खे सच लगी रा बोलणे कि जो कोई परमेशरो रा राज्य बाल़को जेड़ा समजी की मानदा नि, से कदी तिदे नि जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","तेबे यीशुए बच्चे गोदा रे लए और तिना रे सिरो पाँदे आथ राखी की तिना खे आशीष दित्ती। ");
INSERT INTO bfz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","जेबे यीशु तेथा ते निकल़ी की बाटा रे चली रे थे, तेबे एक मांणू तिना गे दौड़दा ऊआ आया और तिना रे पैरो पाँदे पड़ी की तिना ते पूछेया, “ओ उत्तम गुरू! अनन्त जीवनो रा अधिकारी ऊणे खे आऊँ क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीशुए तेसखे बोलेया, “तूँ माखे उत्तम कऊँ बोलेया? कोई उत्तम निए, बस एक-मतलब, परमेशर ई उत्तम ए। ");
INSERT INTO bfz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तूँ आज्ञा खे तो जाणेया, ‘अत्या, व्याभिचार, चोरी नि करना, चूठी गवाई नि देणी, छल नि करना, आपणे माया-बावा रा आदर करना।’ ” ");
INSERT INTO bfz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","तिने मांणूए बोलेया, “ओ गुरू! इना सबी आज्ञा खे तो आऊँ बचपनो ते मानूँआ।” ");
INSERT INTO bfz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","यीशुए तेसखे प्यारो ते देखेया और तेसखे बोलेया, “तांदे एक गल्ला री कमी ए, जा, जो कुछ तांगे आए, से बेची की कंगाल़ा खे देई दे और ताखे स्वर्गो रे सच्चा धन मिलणा, और मां पीछे आईजा।” ");
INSERT INTO bfz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ये सुणी की से उदास ऊईगा और से दु:खी उई की कअरो खे चली गा, कऊँकि से बऊत अमीर था। ");
INSERT INTO bfz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","यीशुए चऊँ कनारे देखी की आपणे चेलेया खे बोलेया, “अमीर लोका खे परमेशरो रे राज्य रे जाणा बऊत कठण ए।” ");
INSERT INTO bfz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","चेले तिना री गल्ला ते हैरान ऊईगे, ये देखी की यीशुए तिना खे फेर बताया, “ओ बाल़को! जो धनो पाँदे विश्वास राखोए, तिना खे परमेशरो रे राज्य रे जाणा बऊत कठण ए। ");
INSERT INTO bfz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","परमेशरो रे राज्य रे अमीरा रा जाणा ईंयां बऊत कठण ए, जिंयाँ की ऊँटो रा सूईया रे छेदो रिये निकल़ना कठण ए।” ");
INSERT INTO bfz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","चेले बऊत हैरान ऊईगे और आपू बीचे बोलणे लगे, “तेबे केसरा उद्धार ऊई सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीशुए तिना खे देखी की बोलेया, “मांणूआ ते तो ये ऊई नि सकदा, पर परमेशरो ते सब कुछ उई सकोआ। कऊँकि परमेशरो खे सब कुछ सम्भव ए” ");
INSERT INTO bfz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस तिना खे बोलणे लगेया, “देखो, आसे तो सब कुछ छाडी की तुसा पीछे आईगे रे।” ");
INSERT INTO bfz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि हर कोई जिने माखे और सुसमाचारो री तंईं कअर, पाई, बईण, माए-बाओ, बाल-बच्चे या डोरू छाडे ओ, ");
INSERT INTO bfz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","और तेस एबे एस बखते सौ गुणा फल पाणा। कअर, पाई, बईण माए, बाल-बच्चे और डोरू सताव साथे पाणे और परलोको रे अनन्त जीवन पाणा। ");
INSERT INTO bfz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","पर एबे बऊत सारे लोक जो आपणे आपू खे एते दुनिया रे बड़े समजोए, सेयो परमेशरो री नजरा रे छोटे ऊई जाणे, और जिना खे संसार एबु छोटा समजोआ, सेयो परमेशरो री नजरा रे बड़े समजे जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","सेयो यरूशलेम नगरो खे जांदे ऊए बाटा रे थे और यीशु तिना ते आगे चली रे थे और चेले हैरान ऊईगे और जो लोक पीछे चली रे थे सेयो डरने लगे। तेबे यीशु तिना बारा चेलेया खे लई की तिना खे सेयो गल्ला बताणे लगे, जो तिना पाँदे आऊणे वाल़िया थिया। ");
INSERT INTO bfz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","यीशुए बोलेया, “देखो, आसे यरूशलेम नगरो खे जाणे लगी रे और आँऊ माणूं रा पुत्र बड़े पुरोईत और शास्त्रिया रे आथो रे देई देणा और तिना आँऊ काणे जोगा ठराणा और दुजिया जातिया रे आथो रे देई देणा। ");
INSERT INTO bfz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","तिना मेरा मजाक उड़ाणा, मां पाँदे थूकणा, माखे कोड़े बाणे, आँऊ काणा और आँऊ तीजे दिने जिऊँदा ऊई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तेबे जब्दिए रे पाऊए, याकूब और यूहन्ने तिना गे आई की बोलेया, “ओ गुरू! आसे चाऊँ ए कि जो कुछ आसे तुसा ते मांगू, तेड़ा ई तुसे आसा खे करो।” ");
INSERT INTO bfz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","यीशुए तिना खे बोलेया, “तुसे क्या चाओए कि आऊँ तुसा खे करुँ?” ");
INSERT INTO bfz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","तिने बोलेया, “आसे चाऊँए कि जेबे तुसे आपणी महिमामय राज्य रे आओ तो आसे दोनो एक तुसा रे दाँणे और एक खूँजे कनारे बैठिए।” ");
INSERT INTO bfz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीशुए तिना खे बोलेया, “तुसे नि जाणदे कि क्या लगी रे मांगणे? जो दुःख आँऊ सईन करने वाल़ा ए, क्या से दुःख तुसे सईन करी सकोए? और जो मौता रा बपतिस्मा आऊँ लणे वाल़ा ए, क्या तुसे लई सकोए?” ");
INSERT INTO bfz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","तिने बोलेया, “आसे करी सकूँए।” यीशुए तिना खे बोलेया, “जो दुःख आँऊ सईन करने वाल़ा ए, से तुसे सईन करी सकोए; और जो मौता बपतिस्मा आऊँ लणे वाल़ा ए, से तुसा लणा। ");
INSERT INTO bfz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","पर जो त्यार कित्ते रे ए, तिना खे छाडी की ओर कोई आपणे दाँणे और खूँजे बठयाल़ना मेरा काम निए।” ");
INSERT INTO bfz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ये सुणी की बाकि दस चेले, याकूब और यूहन्ने पाँदे रोष करने लगे। ");
INSERT INTO bfz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","यीशुए सेयो आपू गे बुलाए और तिना खे बोलेया, “तुसे जाणोए कि जो दुजिया जातिया रे हाकिम समजे जाओए, सेयो तिना पाँदे जबरदस्ती राज करोए और जो तिना बीचे बड़े ए, तिना पाँदे अक्क जताओए। ");
INSERT INTO bfz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पर तुसा बीचे एड़ा नि ऊणा चाईयो, बल्कि जो कोई तुसा बीचा ते बड़ा ऊणा चाओआ, से तुसा रा दास बणो। ");
INSERT INTO bfz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","और जो कोई तुसा रा प्रदान बणना चाओआ, से सबी रा दास बणो। ");
INSERT INTO bfz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","कऊँकि आँऊ माणूं रा पुत्र इजी खे नि आया कि मेरी सेवा करो, बल्कि इजी खे आया कि से आपू सेवा करो और बऊत जणेया छुड़ाणे खे आपणा प्राण देई देओ।” ");
INSERT INTO bfz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","यीशु और तिना रे चेले यरीहो नगरो रे आए। और जेबे सेयो और तिना रे चेले बाटा रे थे, तेबे एक बड़ी पीड़ तिना पीछे-पीछे जाणे लगी री थी, तेबे तिमाईयो रा पाऊ बरतिमाई एक अन्दा भिखारी सड़का रे कनारे बैठेया रा था। ");
INSERT INTO bfz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","जेबे तिने ये सुणेया कि यीशु नासरी ये, तेबे से जोरे-जोरे की आक्का पाणे लगेया कि, “ओ दाऊदो री ल्वाद, यीशु! मां पाँदे दया कर।” ");
INSERT INTO bfz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","कई जणे तेसखे बकणे लगे कि चुप रओ, पर से ओर बी आक्का पाणे लगेया कि, “ओ दाऊदो री ल्वाद! मां पाँदे दया कर।” ");
INSERT INTO bfz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तेबे यीशुए रूकी की बोलेया, “तेसखे बुलाओ।” तेबे लोके से अन्दा बुलाई की तेसखे बोलेया, “याओ राख, उठ, यीशु ताखे बुलाणे लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","से आपणी चादर सेटी की फटाफट उठी गा और यीशुए गे आईगा। ");
INSERT INTO bfz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","तेबे यीशुए तेसखे बोलेया, “तूँ क्या चाएया कि आऊँ ताखे क्या करुँ?” अन्दे बोलेया, “ओ गुरू! ये कि आऊँ देखणे लगी जाऊँ।” ");
INSERT INTO bfz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीशुए तेसखे बोलेया, “चली जा, तेरे विश्वासे तूँ ठीक करी ता” और से तेबुई देखणे लगेया और बाटा रे से तिना पीछे चलणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जेबे यीशु और तिना रे चेले यरूशलेम नगरो रे नेड़े जैतून पाह्ड़ो पाँदे, बैतफगे और बैतनिय्याहो गांव रे नेड़े आए, तो तेबे यीशुए आपणे चेलेया बीचा ते दो जणे ये बोली की पेजे, ");
INSERT INTO bfz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“सामणे रे गांव रे जाओ, और तेती पऊँछी की तुसा खे एक गह्दिया रा बच्चा, जेस पाँदे कदी कोई नि बैठी रा, बाने रा तुसा खे मिलणा, तेस खोली की ल्याओ। ");
INSERT INTO bfz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","जे तुसा खे कोई पूछो गा ‘एड़ा कऊँ लगी रे करने?’ तो बोलणा, ‘मेरे प्रभुए खे एसते कुछ काम ए,’ और तिना फटाफट से एती पेजी देणा।” ");
INSERT INTO bfz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","चेलेया से गह्दिया रा बच्चा बाअरे गल़िया रे दरवाजे रे नेड़े बाने रा देखेया और सेयो तेसखे खोलणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","तेबे जो तेती खड़ी रे थे, तिना बीचा ते कोई-कोई बोलणे लगे, “ये क्या लगी रे करने? गह्दिया रे बच्चे खे कऊँ लगी रे खोलणे?” ");
INSERT INTO bfz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","चेलेया, जिंयाँ यीशुए था बोले रा, तिंयाँ ई तिना खे बोलणे लगे, तेबे तिने सेयो जाणे दित्ते। ");
INSERT INTO bfz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","चेलेया से गह्दिया रा बच्चा यीशुए गे ल्याया और तेस पाँदे आपणे टाले पाए और यीशु तेस पाँदे बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","तेबे बऊत जणेया आपणी-आपणी चादरी बाटा रे बछाइतिया और कईए डोरूआ ते खजूरो रिया डाल़िया बाडी-बाडी की तिना रे स्वागतो खे बछाइतिया। ");
INSERT INTO bfz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","तेबे जो यीशुए रे आगे और पीछे चली रे थे, सेयो जोरे-जोरे की बोलणे लगी रे थे, “होशन्ना, धन्य ए से, जो प्रभुए रे नाओं ते आओआ। ");
INSERT INTO bfz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","आसा रे पिता दाऊदो रा राज्य जो आऊणे लगी रा; से धन्य ए; स्वर्गो रे होशन्ना।” ");
INSERT INTO bfz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","तेबे यीशु यरूशलेमो नगरो रे पऊँछी की मन्दरो रे आए और चऊँ कनारे सब कुछ देखी की आपणे बारा चेलेया साथे बैतनिय्याहो गांव खे गए, कऊँकि साँज ऊईगी थी। ");
INSERT INTO bfz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","दूजे दिने जेबे सेयो बैतनिय्याहो गांव ते निकल़े, तेबे यीशुए खे पूख लगी। ");
INSERT INTO bfz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","तेबे तिने दूरो ते एक दाऊगल़े रा अरा डाल़ देखेया और तेस डाल़ो रे नेड़े आए कि क्या पता ईदे कुछ लगी रा ओगा, पर पत्तेया खे छाडी की ओर कुछ नि मिलेया, कऊँकि फल लगणे रा बखत नि था। ");
INSERT INTO bfz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","तेबे यीशुए तेस डाल़ो खे बोलेया, “आजो ते बाद तेरा फल केसी नि खाणा” और तिना रे चेले सुणने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","तेबे यीशु यरूशलेमो नगरो खे आए और मन्दरो रे गए, तेबे जो तेती लेण-देण लगी रे थे करने, सेयो तिना खे बारे निकयाल़ने लगे और सर्राफे रिया पेटिया और कबूतरा खे बेचणे वाल़िया चौकिया मूँदिया करी तिया ");
INSERT INTO bfz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","और मन्दरो रिये कोई बी सामान लई की आऊणे-जाणे नि दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","तेबे उपदेश देई की तिना खे बोलेया, “एड़ा लिखी राखेया, मेरा मन्दर, सब जातिया खे प्रार्थना रा कअर ऊणा। पर तुसे ये डाकूआ री गुफा बणाई ती री।” ");
INSERT INTO bfz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ये सुणी की बड़े पुरोईत और शास्त्री यीशुए खे बर्बाद करने रा मोका टोल़ने लगे, कऊँकि सेयो तिना ते डरो थे और लोक बी तिना रे उपदेशो ते हैरान थे। ");
INSERT INTO bfz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","साँज ऊँदे ई यीशु और तिना रे चेले नगरो ते बाअरे चली गे। ");
INSERT INTO bfz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","तेबे प्यागा सेयो तिसिये गए और चेलेया से दाऊगल़े रा डाल़ जड़ा ते सूकेया रा देखेया। ");
INSERT INTO bfz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरसो खे से गल्ल याद आई और तिने यीशुए खे बोलेया, “ओ गुरू! देख, ये दाऊगल़े रा डाल़, जेसखे तुसे स्राप दित्तेया था, सूकी गा रा।” ");
INSERT INTO bfz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीशुए जवाब दित्तेया, “परमेशरो पाँदे विश्वास राखो। ");
INSERT INTO bfz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","आऊँ तुसा खे सच बोलूँआ कि जे कोई एस पाह्ड़ो खे बोलो, ‘तूँ पट्ठी जा और समुद्रो रे पड़ी जा,’ और आपणे मनो रे शक नि करो, बल्कि विश्वास राखो कि जो बोलूँआ, से ऊई जाणा, तो तेसखे से ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","तेबेई तो आऊँ तुसा खे बोलूँआ कि जो कुछ तुसे प्रार्थना करी की मांगोगे, तो विश्वास राखो कि तुसा खे मिली गा और तुसा खे ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","जेबे कदी तुसे खड़े ऊई की प्रार्थना करोए और तुसा रे मनो रे केसी रे खलाफ कोई गल्ल ओ, तो तेसखे माफ करी देओ। तुसा रा स्वर्गिय पिता बी तुसा रे पाप माफ करोआ। ");
INSERT INTO bfz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","और जे तुसे माफ नि करोगे, तो तुसा रे स्वर्गिय पिते बी तुसा रे अपराध माफ नि करने।” ");
INSERT INTO bfz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","तेबे यीशु और तिना रे चेले फेर यरूशलेमो नगरो खे आए और जेबे यीशु मन्दरो रे कूमणे लगी रे थे, तेबे बड़े पुरोईत, शास्त्री और बुजुर्ग तिना गे आई की पूछणे लगे, ");
INSERT INTO bfz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“तूँ इना कामा केस अक्को ते करेया? और ताखे ये अक्क किने देई राखेया कि तूँ इना कामा खे करे?” ");
INSERT INTO bfz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","यीशुए तिना खे बोलेया, “आऊँ बी तुसा ते एक गल्ल पुछूँआ, माखे जवाब देओ, तो मां बी तुसा खे बताणा कि इना कामा केस अक्को ते करूँआ? ");
INSERT INTO bfz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्ने रा बपतिस्मा क्या स्वर्गो ते था या मांणूए री तरफा ते था? माखे जवाब देओ।” ");
INSERT INTO bfz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","तेबे सेयो आपू बीचे बात-चीत करने लगे, “जे आसे बोलूँ कि ‘स्वर्गो री तरफा ते था,’ तो एस बोलणा, ‘तेबे तुसे तेस पाँदे विश्वास कऊँ नि कित्तेया?’ ");
INSERT INTO bfz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","और जे आसे बोलूँगे, ‘मांणूए री तरफा ते ए,’ तो लोका रा डर ए, कि लोक गुस्सा ऊई जाणे; कऊँकि सब जाणोए कि यूहन्ना भविष्यबक्ता था।” ");
INSERT INTO bfz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","तो तेबे तिने यीशुए खे जवाब दित्तेया, “आसे नि जाणदे।” यीशुए बी तिना खे बोलेया, “मां पनि बताणा कि ये काम केसरे अक्को ते करूँआ।” ");
INSERT INTO bfz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","यीशु उदारणा रे तिना साथे गल्ला करने लगे, “एकी मांणूए अँगूरा रा बगीचा लगाया और तिजी रे चऊँ कनारे बाड़ लगाया और अँगूरा रे रसो खे पात्थरो दे एक गड्डा खणेया, जुगाल़ी बणाई और ठेकेदारा खे तिजी रा ठेका देई की परदेशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","जेबे फल लगणे रा बखत ऊआ तेबे तिने आपणा एक दास ठेकेदारा गे पेजेया कि तिना ते अँगूरा रे बगीचे रे फलो रा इस्सा ल्याओ। ");
INSERT INTO bfz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पर ठेकेदारे से पकड़ी की कूटेया और खाली आथे पेजी ता। ");
INSERT INTO bfz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","तेबे तिने एक ओर दास पेजेया और तिने तेसरा सिर फोड़ी ता और तेसरी बेज्जती कित्ती। ");
INSERT INTO bfz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","तेबे तिने एक ओर पेजेया और तिने से काई ता; तेबे तिने ओर कई जणे पेजे; तिना बीचा ते तिने कई जणे कूटे और कई जणे काई ते। ");
INSERT INTO bfz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","एबे एक ई रई गा था, जो तेसरा प्यारा पाऊ था, तिने आखरी रे से बी ये सोची की पेजेया, ‘तिना मेरे पाऊए रा तो आदर करना।’ ");
INSERT INTO bfz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पर तिने ठेकेदारे आपू बीचे बोलेया, ‘येई तो बारस ए,’ आओ एसखे काई देऊँए, तेबे जायदात म्हारी ऊई जाणी। ");
INSERT INTO bfz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","तेबे तिने से पकड़ी की काई ता और अँगूरा रे बगीचे ते बारे सेटी ता।” ");
INSERT INTO bfz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","यीशुए पूछेया, “तो तेबे अँगूरा रे बगीचे रे मालके क्या करना? तेस आई की तिना ठेकेदारो रा नाश करी देणा और अँगूरा रा बगीचा ओरी गे देई देणा। ");
INSERT INTO bfz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","क्या तुसे पवित्र शास्त्रो रे ये वचन नि पढ़ेया, “ ‘जेस पात्थरो खे राजमिस्त्रिए नकम्मा बोलेया था, सेई कूणे रा सिरा ऊईगा’ ");
INSERT INTO bfz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","‘ये प्रभुए री तरफा ते ऊआ, और आसा री नजरा रे नऊखा ए’?” ");
INSERT INTO bfz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","तेबे तिने से पकड़ना चाया, कऊँकि सेयो समजी गे थे, “तिने ये उदारण आसा रे बारे रे बोलेया।” पर सेयो लोका ते डरी गे और तिना खे छाडी की चली गे। ");
INSERT INTO bfz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","तेबे यहूदी अगुवे यीशु गल्ला रे फसाणे री तंईं कई फरीसी और हेरोदेस राजे रा समर्थन करने वाल़े यहूदी तिना गे पेजे। ");
INSERT INTO bfz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","और तिने आई की तिना खे बोलेया, “ओ गुरू! आसे जाणूंए कि तुसे सच्चे ए और केसी री परवा नि करदे, कऊँकि तुसे मांणूआ रा मूँ देखी की गल्ल नि करदे, पर परमेशरो री बाट सच्चाईया साथे बताओए। तो क्या कैसरो खे कर देणा खरी गल्ल या नि? ");
INSERT INTO bfz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","आसे देऊँ या नई देऊँ?” यीशुए तिना रा कपट जाणी की बोलेया, “माखे कऊँ परखोए? एक चाँदिए रा सिक्का मांगे ल्याओ ताकि आऊँ देखूँ।” ");
INSERT INTO bfz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","सेयो ली आए और तिने तिना खे बोलेया, “ये मूर्ति और नाओं केसरा ए?” तिने बोलेया, “रोमो रे राजा कैसरो रा।” ");
INSERT INTO bfz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","यीशुए तिना खे बोलेया, “जो कैसरो राए, से कैसरो खे और जो परमेशरो राए, से परमेशरो खे देयो।” तेबे सेयो तिना पाँदे हैरानी करने लगे। ");
INSERT INTO bfz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","तेबे सदूकिये बी जो एड़ा बोलो थे कि मरेया रा जिऊँदा ऊई नि सकदा, तिने यीशुए गे आई की पूछेया, ");
INSERT INTO bfz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ओ गुरू, मूसे आसा खे लिखी राखेया कि जे केसी मांणूए रा पाई बिना ल्वादा ते मरी जाओ और तेसरी लाड़ी रई जाओ, तो तेसरा पाई तेसा बिदुआ साथे ब्या करी लओ और आपणे पाईए खे ल्वाद पैदा करो। ");
INSERT INTO bfz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","एक बार सात पाई थे; पईला पाई ब्या करी की बिना ल्वादा ते मरी गा। ");
INSERT INTO bfz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तेबे दूजे पाईए तेसा बिदुआ साथे ब्या करी ला और से बी बिना ल्वादा ते मरी गा; और तिंयाँ ई तीजे बी कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","साता पाईया ते ल्वाद नि ऊई। सबी ते बाद से जवाणस बी मरी गी। ");
INSERT INTO bfz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","तो तेबे, जेबे सेयो जिऊँदे ऊणे, तो से तिना बीचा ते केसरी लाड़ी ऊणी? कऊँकि से साता जणेया री लाड़ी ऊई चुकी थी।” ");
INSERT INTO bfz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीशुए तिना खे बोलेया, “तुसे केथी एते पूला रे तो निए कि ना तुसे पवित्र शास्त्रो खेई जाणदे और ना ई परमेशरो री सामर्था खे? ");
INSERT INTO bfz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","कऊँकि जेबे सेयो मरेया रे बीचा ते जिऊँदे ऊणे, तो तिना बीचे शादी-ब्या नि ऊणे, पर स्वर्गदूतो जेड़े ऊणे। ");
INSERT INTO bfz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरे रे बीचा ते जिऊँदे ऊणे रे बारे रे क्या तुसे मूसे री कताबा रे बल़दे ऊए जाड़ो री काणियां रे नि पढ़ेया कि परमेशरे तेसखे बोलेया, ‘आऊँ अब्राहमो रा परमेशर, इसहाको रा परमेशर और याकूबो रा परमेशर ए’? ");
INSERT INTO bfz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","परमेशर मरेया रा नि, पर जिऊँदेया रा परमेशर ए। तो तुसे बऊत बड़ी पूला रे पड़ी रे।” ");
INSERT INTO bfz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","तेबे शास्त्रिया बीचा ते एकी जणे आई की सेयो बईस करदे ऊए सुणे और ये जाणी की कि यीशुए तिना खे खरा जवाब दित्तेया, तेबे तिने यीशुए ते पूछेया, “सबी ते खास आज्ञा कूण जिए।” ");
INSERT INTO bfz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीशुए तेसखे जवाब दित्तेया, “सबी आज्ञा बीचा ते ये आज्ञा बड़ी ए कि, ‘ओ इस्राएल सुण, प्रभु आसा रा परमेशर एक ई प्रभु ए ");
INSERT INTO bfz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","और तूँ प्रभु आपणे परमेशरो साथे आपणे पुरे मनो ते, पुरे प्राणो ते, पुरे दमाको ते और आपणी पुरिया तागता ते प्यार राख।’ ");
INSERT INTO bfz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","और दूजी ये कि, ‘तूँ आपणे पड़ोसिये साथे आपू जेड़ा प्यार राख’ इजी ते बड़ी ओर कोई आज्ञा निए।” ");
INSERT INTO bfz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","शास्त्रिए तिना खे बोलेया, “ओ गुरू! बऊत खरा।” तुसे सच बोलेया, “परमेशर एक ईए और परमेशरो खे छाडी की ओर कोई बड़ा निए ");
INSERT INTO bfz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","और तेस साथे पुरे मन, पुरे दमाक और पुरिया तागता साथे प्यार राख और आपणे पड़ोसिये साथे आपू जेड़ा प्यार राख। सारे अवन और बलिदानो ते बड़ी की ए।” ");
INSERT INTO bfz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","जेबे यीशुए देखेया कि तिने समजदारिया साथे जवाब दित्तेया, तो तेसखे बोलेया, “तूँ परमेशरो रे राज्य ते दूर निए।” तेबे केसी खे बी तिना ते कुछ पूछणे री इम्मत नि ऊई। ");
INSERT INTO bfz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","तेबे यीशुए मन्दरो रे ये उपदेश देंदे ऊए बोलेया, “शास्त्री कऊँ बोलोए, कि मसीह दाऊदो रा पाऊ ए? ");
INSERT INTO bfz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाऊदे आपू ई पवित्र आत्मा रे परी की बोलेया था कि: “ ‘प्रभुए मेरे प्रभुए खे बोलेया: “मेरे दाँणे कनारे बैठ जदुओ तक आऊँ तेरे बैरिया खे तेरे पैरो निठे नि करी देऊँ।” ’ ");
INSERT INTO bfz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाऊद तो आपू ई तेसखे प्रभु बोलोआ, तो आँऊ तेसरा पुत्र किंयाँ ऊआ?” और जो पीड़ा रे लोक थे सेयो तिना री गल्ल खुश ऊई की सुणो थे। ");
INSERT INTO bfz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","यीशुए तिना खे आपणे उपदेशो रे बोलेया, “शास्त्रिया ते चौकस रओ, जो लाम्बे टाले पईनी की कूमदे रओए और बजारो रे नमस्कार, ");
INSERT INTO bfz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","और प्रार्थना रे कअरो रे खास-खास जगा और पाट्टिया रे खास जगा चाओए। ");
INSERT INTO bfz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","सेयो बिदुआ रे कअरो खे खाई जाओए और दखाणे खे मुखती देर तक प्रार्थना करोए, इना खे जादा सजा मिलणी।” ");
INSERT INTO bfz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","यीशु मन्दरो रे दान-पात्रो रे सामणे बैठी की देखणे लगी रे थे कि लोक मन्दरो रे दान-पात्रो रे किंयाँ पैसे पाओए और जादा अमीर लोके बऊत पाया। ");
INSERT INTO bfz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","तेबे एक कंगाल़ बिदुआ आई और तेसे दो दमड़िया पाईया, जो एक तेअले रे बराबर थिया। ");
INSERT INTO bfz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तेबे यीशुए आपणे चेलेया खे बुलाई की बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि जिने मन्दरो रे दान-पात्रो रे पाया, तिना बीचा ते एसे कंगाल़ बिदुए सबी ते जादा पाई राखेया। ");
INSERT INTO bfz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","कऊँकि सबी आपणे बऊत सारे खजाने बीचा ते थोड़ा जा पाया, पर एसे आपणी कमिया बीचा ते जो कुछ एसा गे था-मतलब-आपणी सारी कमाई पाई ती।” ");
INSERT INTO bfz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जेबे यीशु मन्दरो ते निकल़ने लगी रे थे, तेबे तिना रे चेलेया बीचा ते एकी जणे तिना खे बोलेया, “ओ गुरू! देखो, कितणे बड़े-बड़े पात्थर ए और कितणे अच्छे-अच्छे भवन ए।” ");
INSERT INTO bfz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीशुए तेसखे बोलेया, “क्या तूँ ये बड़े-बड़े भवन लगी रा देखणे? इदे जो पात्थरो पाँदे पात्थर लगी रे, सब टाल़े जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","जेबे यीशु जैतूनो रे पाह्ड़ो पाँदे, मन्दरो रे सामणे थे बैठे रे, तेबे पतरस, याकूब, यूहन्ने और अन्द्रियासे तिना ते लग जे जाई की पूछेया, ");
INSERT INTO bfz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“आसा गे बताओ कि यो गल्ला कदी ऊणिया? और जेस बखते यो गल्ला पुरिया ऊणे वाल़िया ऊणिया, तेस बखते क्या चिह्न ऊणे?” ");
INSERT INTO bfz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","यीशुए तिना खे बोलेया, “चौकस रओ कि कोई तुसा खे बईकाओ नि। ");
INSERT INTO bfz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","बऊत एड़े ऊणे, जो मेरे नाओं ते आऊणे और बोलणा, ‘आऊँ ई मसीह ए,’ और बऊत जणे बईकाणे। ");
INSERT INTO bfz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जेबे तुसे लड़ाई और लड़ाईया रे बारे रे सुणो, तो कबराणा नि; कऊँकि इना रा ऊणा जरुरी ए, पर तेस बखते अंत नि ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","कऊँकि जातिया पाँदे जातिया और राज्य पाँदे राज्य अमला करना और बऊत जगा दे ईल्लण ऊणे, अकाल़ पड़ने। ये तो पीड़ा री शुरूआत ई ऊणी। ");
INSERT INTO bfz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“पर तुसे आपणे बारे रे चौकस रओ, कऊँकि लोका तुसे पंचायती रे देई देणे और प्रार्थना रे कअरो रे कूटणे और मेरी बजअ ते हाकिमो और राजेया रे सामणे खड़े करने, पर ये तुसा खे सुसमाचार सुनाणे रा मोका ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","पर जरूरी ए कि अंत आऊणे ते पईले सुसमाचार सबी जातिया रे प्रचार ओ। ");
INSERT INTO bfz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","जेबे सेयो तुसा खे लयी जाई की अधिकारिए रे आथो रे देई देओगे, तो पईले तेई चिन्ता नि करनी, ‘आसा क्या बोलणा।’ पर जो कुछ तुसा गे तेस बखते बताणा, सेई बोलणा, कऊँकि बोलणे वाल़े तुसे नि ऊणे, बल्कि पवित्र आत्मा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","पाईए आपणा पाई और पिते आपणे बच्चे काणे खे देई देणे, बाल-बच्चे आपणे माया-बावा रे खलाफ ऊणे और तिना सेयो कुल़वाणे। ");
INSERT INTO bfz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","तुसे मां पाँदे विश्वास कित्तेया इजी बजअ ते सबी लोका तुसा ते बैर राखणा, पर जो आखरी तक सब्र राखोगा, तेसरा ई उद्धार ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“पढ़ने वाल़ा समजी लओ। जेबे तुसे तेसा उजाड़ने वाल़ी घृणित चीज जेतेरे बारे दानिय्यल भविष्यबक्ते बोलेया था, जेती ठीक निए तेती मतलब मन्दरो रे खड़ी री देखो, तेबे जो लोक यहूदिया प्रदेशो रे ओ, सेयो पाह्ड़ो खे नठी जाओ। ");
INSERT INTO bfz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जो कोई छतो पाँदे ओ, सेयो आपणे कअरे कुछ बी लणे खे थाले नि आओ और ना ई पीतरे जाओ ");
INSERT INTO bfz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","और जो कोई डोरूआ रे ओ, सेयो आपणे टाले लणे पीछे नि आटो। ");
INSERT INTO bfz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","तिना दिना रे जो गर्भवती ऊणी और जो दूद पल़याणे वाल़ी ऊणी तिना खे हाय! हाय! ");
INSERT INTO bfz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","प्रार्थना करेया करो कि ये सब कुछ ठण्डी रे दिना रे नि ओ। ");
INSERT INTO bfz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","कऊँकि तेस बखते एड़े क्ल़ेश ऊणे, जो सृष्टिया री शुरूआता दे, जो परमेशरे बणाई थी, आजो तक ना ऊआ और ना कदी फेर ऊणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","और जे प्रभु तिना दिना खे नि कटांदे, तो कोई प्राणी नि बचणा था; पर तिना परमेशरो रे चुणेया री बजअ ते, सेयो मुश्किल दिन कटाईते। ");
INSERT INTO bfz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","तेस बखते जे कोई तुसा खे बोलो, ‘देखो, मसीह एती ये’ या ‘देखो, मसीह तेती ये’ तो विश्वास नि करना। ");
INSERT INTO bfz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","कऊँकि चूठे मसीह और चूठे भविष्यबक्ता खड़े ऊणे और तिना बड़े-बड़े चिह्न् और अचम्बे रे काम दखाणे, जे ऊई सको तो जो परमेशरो रे चूणे रे ए, तिना खे बी भरमाई देओ। ");
INSERT INTO bfz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","पर तुसे चौकस रओ। देखो, मैं तुसा खे सारी गल्ला मुसीबत आऊणे ते पईले ई बताई ती रिया। ");
INSERT INTO bfz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“तिना दिना रे, तेस क्ल़ेशो ते बाद सूरजो रा चमकदा प्रयासा न्हेरा पड़ी जाणा और चांदे प्रयासा नि देणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","और सर्गो ते तारे छुटणे शुरू ऊणे और सर्गो रिया शक्तिया इलाईया जाणिया। ");
INSERT INTO bfz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तेबे लोका आँऊ माणूं रा पुत्र बड़ी सामर्थ और महिमा साथे बादल़ा रे आऊँदे ऊए देखणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","तेस बखते मां आपणे स्वर्गदूत पेजणे और तरतिया रे एकी कनारे ते लई की सर्गो रे दूजे कनारे तक, चऊँ दिशा ते आपणे चूणे रे लोक कट्ठे करने। ");
INSERT INTO bfz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“दाऊगल़े रे डाल़ो ते एस उदारणो खे सीखो, जेबे तिजी री डाल़ी नरम ऊई जाओई और पत्ते निकल़ने लगी जाओए, तो तुसा खे पता लगी जाओआ कि तऊँदी आऊणे वाल़ी ए। ");
INSERT INTO bfz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ईंयां ई जेबे तुसे इना गल्ला खे ऊँदे ऊए देखो, तो समजी जाणा कि एबे आँऊ नेड़े ईए, बल्कि द्वारो पाँदे ईए खड़ेया रा। ");
INSERT INTO bfz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","आऊँ तुसा खे सच लगी रा बोलणे कि जदुओ तक यो सब गल्ला पूरिया नि ऊई जाओगिया, तदुओ तक एसा पीढ़िया रे लोका री मौत नि ऊणी। ");
INSERT INTO bfz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","सर्ग और तरती टल़ी जाओगी, पर मेरा वचन कदी नि टल़ना। ");
INSERT INTO bfz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“यो गल्ला कदी ऊणिया तेस दिनो रे बारे रे या तेसा कअड़िया रे बारे रे कोई नि जाणदा, न स्वर्गदूत और ना पुत्र, पर बस पिता जाणोआ। ");
INSERT INTO bfz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","देखो, जागदे और प्रार्थना करदे रओ; कऊँकि तुसे नि जाणदे कि से बखत कदी जे आई जाणा। ");
INSERT INTO bfz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ये तेस मांणूए री जी दशा ए, जो परदेशो खे जांदे ऊए आपणा कअर छाडी जाओ और आपणे दासा खे अक्क देई दो और हर एकी खे तेसरा काम बताई देओ और चौकीदार खे जागणे री आज्ञा देओ। ");
INSERT INTO bfz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“जागदे रओ, कऊँकि तुसे नि जाणदे कि कअरो रा मालक कदी जे आई जाणा, साँजा या आदी राथियो रे या मुर्गे री बांग देणे रे बखते या प्यागा। ");
INSERT INTO bfz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","एड़ा नि ओ कि से केथी अचाणक ई आई जाओ और तुसा खे सऊँदा ऊआ देखो। ");
INSERT INTO bfz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","से जो आऊँ तुसा खे बोलूँआ, सेई सबी खे बोलूँआ कि जागदे रओ!” ");
INSERT INTO bfz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दो दिन बाद फसह रा त्योआर और बिना सजेड़े री रोटिया रा त्योआर ऊणे वाल़ा था। बड़े पुरोईत और शास्त्री एड़ी गल्ला री टोल़ा रे थे कि किंयाँ यीशुए खे तोखे रे मरवाईए। ");
INSERT INTO bfz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पर बोलो थे, “त्योआरो रे दिने नि, केथी एड़ा नि ओ कि लोका बीचे हुड़दंग मची जाओ।” ");
INSERT INTO bfz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जेबे यीशु बैतनिय्याह गांव रे शमौन जेसखे पईले कोढ़ था तेसरे कअरे रोटी खाणे बैठे रे थे, तेबे एक जवाणस संगमरमरो रे पांडे (सुराई) रे जटामासिया रा मईंगा और साफ इत्र लई की आई और पांडा तोड़ी की इत्र तिना रे सिरो रे लटी ता। ");
INSERT INTO bfz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","तेबे कोई-कोई गुस्सा करी की बोलणे लगे, “एस इत्रो रा सत्यानाश कऊँ कित्तेया? ");
INSERT INTO bfz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","कऊँकि ये इत्र तो तीन सौ चाँदिए रे सिक्केया रे मोलो ते जादा पैसेया रा बेची की कंगाल़ा खे बांडी सको थे।” सेयो तेसा खे थिड़कणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यीशुए बोलेया, “एसा खे छाडी देओ। एसा खे कऊँ सताणे लगी रे? एसे तो मां साथे पलाई ए कित्ती री। ");
INSERT INTO bfz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","कंगाल़ तो तुसा साथे सदा रओए और तुसे जेबे चाओ, तेबे तिना साथे पलाई करी सकोए। पर आऊँ तुसा साथे सदा नि रणा। ");
INSERT INTO bfz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","जो कुछ ये करी सको थी, एसे कित्तेया, एसे मेरे दबाणे री त्यारिया ते पईले ई मेरे शरीरो रे इत्र मल़ीता। ");
INSERT INTO bfz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","आऊँ तुसा खे सच बोलूँआ कि सारी दुनिया रे जेती, केथी सुसमाचार प्रचार ऊणा, तेती एसा रे एस कामो री चर्चा, एसा री यादा रे ऊणी।” ");
INSERT INTO bfz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तेबे यहूदा इस्करियोती, जो बारा चेलेया बीचा ते एक था, बड़े पुरोईतो गे गया, ताकि यीशु तिना रे आथे पकड़वाया जाओ। ");
INSERT INTO bfz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","सेयो ये सुणी की खुश ऊईगे और तेसखे पैसे देणा मंजूर कित्तेया। तेबे से मोका टोल़ने लगेया कि यीशुए खे किंयाँ पकड़वाऊँ। ");
INSERT INTO bfz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","बिना सजेड़े री रोटिया रे त्योआरो रे पईले दिने, जिदे सेयो फसह रे मिन्टूओ रा बलिदान करो थे, तिना रे चेले तिना ते पूछेया, “तुसे केयी चाओए कि आसे तुसा खे फसह रे त्योआरो री रोटी खाणे री त्यारी करुँ?” ");
INSERT INTO bfz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","यीशु आपणे चेलेया बीचा ते दो जणे ये बोली की पेजे, “नगरो रे जाओ और तेती तुसा खे एक मांणू मिलणा, जिने एक पाणिए रा कअड़ा ऊणा चकेया रा, तेस पीछे चली जाणा ");
INSERT INTO bfz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","और से जेते कअरो रे जाओगा, तेस कअरो रे मालको खे बोलणा, ‘गुरू बोलोआ, “मेरा बैठका रा कमरा, जेती आऊँ आपणे चेलेया साथे फसह रे त्योआरो री रोटी खाऊँ, से केयी ए?” ’ ");
INSERT INTO bfz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","तेस तुसा खे एक सजी-सजाई री और त्यार कित्ती री बड़ी बाऊड़ो दखाणी। तेती आसा खे फसह खाणे री त्यारी करो।” ");
INSERT INTO bfz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","तेबे चेले निकल़ी की नगरो खे आए और जेड़ा यीशुए तिना खे बोलेया था, तेड़ा ई पाया और फसह रे त्योआरो री रोटी त्यार कित्ती। ");
INSERT INTO bfz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जेबे साँज ऊई, तेबे यीशु बारा चेलेया साथे तेती आए। ");
INSERT INTO bfz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","और जेबे सेयो रोटी खाणे लगी रे थे, तेबे यीशुए बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि तुसा बीचा ते एक ए, जो मां साथे रोटी लगी रा खाणे, तेस आऊँ पकड़वाणा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","चेले उदास ऊईगे और तिना बीचा ते एक-एक तिना खे पूछणे लगेया, “क्या से आऊँ ए?” ");
INSERT INTO bfz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","यीशुए तिना खे बोलेया, “से बारा बीचा ते एक ए, जो मां साथे थाल़िया रे आथ पाओआ। ");
INSERT INTO bfz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","आँऊ माणूं रा पुत्र पक्का ई मारेया जाणा जेड़ा मेरे बारे रे पवित्र शास्त्रो रे लिखी राखेया, पर तेस मांणूए खे हाय, जेस आऊँ पकड़वाणा। तेस मांणूए खे खरा था कि से जमदा ई नि।” ");
INSERT INTO bfz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","जेबे सेयो खाणे ई लगी रे थे, तेबे यीशुए रोटी लयी और आशीष मांगी की तोड़ी और चेलेया खे दित्ती और बोलेया, “लओ और खाओ, ये मेरा शरीर ए।” ");
INSERT INTO bfz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","तेबे तिने कटोरा लयी की धन्यवाद कित्तेया और तिना खे दित्तेया और तिने सबी तिजी ते पिया। ");
INSERT INTO bfz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","यीशुए तिना खे बोलेया, “ये मेरा से खून ए, जो परमेशर और तिना रे लोका बीचे नई वाचा ए, और बऊत जणेया रे पापो री माफिया खे बाह्या जाओआ। ");
INSERT INTO bfz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","आऊँ तुसा खे सच बोलूँआ कि मां अँगूरा रा रस तेस दिनो तक फेर कदी नि पीणा, जदुओ तक परमेशरो रे राज्य रे नया नि पीऊँगा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","तेबे सेयो पअजन गायी की बारे जैतूनो रे पाह्ड़ो पाँदे गए। ");
INSERT INTO bfz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तेबे यीशुए तिना खे बोलेया, “तुसे सब माखे छाडी की चली जाणे, कऊँकि लिखी राखेया, ‘मां रखवाल़ा काई देणा और पेडा ओरे-पोरे ऊई जाणिया।’ ");
INSERT INTO bfz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","पर मां मुड़देया बीचा ते जिऊँदा ऊणे ते बाद, तुसा ते पईले गलीलो खे जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पतरसे तिना खे बोलेया, “जे तुसा खे छाडी की सब जणे चली बी जाओ, तेबे बी मां तुसा खे छाडी की कदी नि जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीशुए तेसखे बोलेया, “आऊँ ताखे सच लगी रा बोलणे कि आज ई राती रे मुर्गे री दो बार बांग देणे ते पईले तूँ तीन बार माखे जाणने ते मुकरना।” ");
INSERT INTO bfz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पर पतरसे ओर बी जोर देई की बोलेया, “जे माखे तुसा साथे मरना बी पड़ो, तो तेबे बी मां तुसा खे ना नि करनी।” ईंयां ई ओरी सबी बी बोलेया। ");
INSERT INTO bfz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","तेबे सेयो गतसमनी नाओं री जगा रे आए और यीशुए आपणे चेलेया खे बोलेया, “जदुओ तक आऊँ प्रार्थना करूँआ, तदुओ तक तुसे एथी बैठे रे रओ।” ");
INSERT INTO bfz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","यीशु पतरस, यूहन्ना और याकूबो खे आपू साथे लईगे और बऊत ई बेचैन और परेशान ऊणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","तेबे यीशुए तिना खे बोलेया, “मेरा जिऊ बऊत उदास ए, एथो तक कि आऊँ मरने पाँदे ए। तुसे एथी रूको और जागदे रओ।” ");
INSERT INTO bfz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","यीशु थोड़े जे आगे गए और जमीना पाँदे पड़ी की प्रार्थना करने लगे कि, “जे ऊई सको तो ये दुःखो री कअड़ी मां पाँदो ते टल़ी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","और बोलेया, “ओ अब्बा! ओ पिता! तुसा ते सब कुछ ऊई सकोआ, एस दुःखो खे मांगा गे ते टाई दे, पर तेबे बी जेड़ा आऊँ चाऊँआ, तेड़ा नि, पर जो तुसे चाओए सेई ओ।” ");
INSERT INTO bfz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","तेबे यीशु आए और चेले सये रे देखी की पतरसो खे बोलेया, “ओ शमौन तूँ सऊणे लगी रा? क्या तूँ एक कअड़ी पनि जागी सकेया? ");
INSERT INTO bfz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जागदे और प्रार्थना करदे रओ, ताकि परीक्षा रे नि पड़ो; आत्मा तो त्यार ए, पर शरीर कमजोर ए।” ");
INSERT INTO bfz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","यीशु फेर चली गे और सेई प्रार्थना कित्ती। ");
INSERT INTO bfz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","तेबे दूजी बार आई की सेयो सये रे देखे, कऊँकि तिना री आखी रे नींज थी और सेयो नि जाणो थे कि यीशुए खे क्या जवाब देईए। ");
INSERT INTO bfz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","तेबे यीशुए तीजी बार आई की बोलेया, “एबे सऊँदे रओ और आराम करदे रओ, बस से कअड़ी आईगी री। देखो, आँऊ माणूं रा पुत्र पापिया रे आथे पकड़वाई जाऊणा। ");
INSERT INTO bfz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठो चलो। देखो, माखे पकड़वाणे वाल़ा नेड़े आईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","सेयो ये बोलणे ई लगी रे थे कि यहूदा, जो बारा चेलेया बीचा ते एक था, से आया। और तेस साथे बड़े पुरोईत, शास्त्री, और बुजुर्गा री तरफा ते एक बड़ी पीड़, तलवार और डण्डे लयी की फटाफट आईगी। ");
INSERT INTO bfz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","तिना खे पकड़वाणे वाल़े तिना खे बताई ता था, “जेसखे आऊँ नमस्ते करुँ और गल़े लगूँ, सेई ऊणा और तुसे से पकड़ी की लई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","तेबे यहूदा यीशुए गे आया और बोलेया, “ओ गुरू!” और तेसखे नमस्ते कित्ती और गल़े लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तेबे तिने सेयो आथ पाई की पकड़ी ले। ");
INSERT INTO bfz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","तिना बीचा ते जो नेड़े खड़ी रे थे, एकी जणे तलवार खिंजी की प्रदान पुरोईतो रे दासो पाँदे चलाई और तेसरा कान ऊड़ाई ता। ");
INSERT INTO bfz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीशुए तिना खे बोलेया, “क्या तुसे आऊँ डाकू समजी राखेया, जो माखे पकड़ने री तंईं डण्डे और तलवारी लई की आई रे? ");
INSERT INTO bfz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","आऊँ तो हर दिन तुसा साथे मन्दरो रे उपदेश देऊँ था और तेबे तो तुसे आऊँ नि पकड़ेया। पर ये सब कुछ तेबे ऊआ, ताकि पवित्र शास्त्रो रे मेरे बारे जो गल्ल भविष्यवक्ते लिखी राखी थी, से पूरी ओ।” ");
INSERT INTO bfz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","तेबे तिना रे सारे चेले तिना खे छाडी की नठीगे। ");
INSERT INTO bfz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","तेबे एक जवान आपणे नांगे शरीरो रे चादर टखी की तिना पीछे-पीछे चली गा और लोके से चेला समजी की पकड़ी ता। ");
INSERT INTO bfz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पर से चादर छाडी की नांगा ई नठी गा। ");
INSERT INTO bfz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","तेबे सेयो यीशुए खे बड़े पुरोईतो रे कअरे लईगे और सब प्रदान पुरोईत, शास्त्री और बुजुर्ग तेसगे कट्ठे ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस दूरो तेई तिना पीछे-पीछे प्रदान पुरोईतो रे आँगणो रे पीतरो तक गया और चौकीदारा साथे बैठी की आग सेखणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","बड़े पुरोईत और सारी बड़ी सभा यीशुए खे काणे री तंईं, तिना रे खलाफ गवाई लगी रे थे टोल़ने, पर मिली नि। ");
INSERT INTO bfz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","कऊँकि बऊत जणे तिना रे खलाफ चूठी गवाई लगी रे थे देणे, पर तिना री गवाई एक जेड़ी नि थी। ");
INSERT INTO bfz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तेबे बऊत जणेया तिना रे खलाफ ये चूठी गवाई दित्ती कि ");
INSERT INTO bfz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“आसे ये, ए बोलदे ऊए सुणी राखेया, ‘मां ये आथो साथे बणाया रा मन्दर टाल़ी देणा और तीजे दिने दूजा बणाई देणा, जो आथो साथे नि बणे रा ऊणा।’ ” ");
INSERT INTO bfz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","एते पाँदे बी सबी री गवाई एक जेड़ी नि निकल़ी। ");
INSERT INTO bfz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तेबे प्रदान पुरोईते, बीचे खड़े ऊई की, यीशुए ते पूछेया, “क्या तूँ कोई जवाब नि देणा चांदा? यो लोक तेरे बारे रे क्या गवाई लगी रे देणे?” ");
INSERT INTO bfz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","पर यीशु चुप रए और कुछ बी जवाब नि दित्तेया। प्रदान पुरोईते तिना ते फेर पूछेया, “क्या तूँ परमधन्य परमेशरो रा पुत्र मसीह ए?” ");
INSERT INTO bfz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीशुए बोलेया, “आ, आऊँ आए; और तुसा आँऊ माणूं रा पुत्र सर्वशक्तिमानो रे दाँणे कनारे बैठे रा और सर्गो रे बादल़ो पाँदे आऊँदा ऊआ देखणा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तेबे प्रदान पुरोईते आपणे टाले फाड़ी की बोलेया, “एबे आसा खे गवाओ रा क्या काम ए? ");
INSERT INTO bfz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुसे ये निन्दा सुणी, तुसा री क्या राय ए?” तिने सबी बोलेया, “ये तो काणे जोगा ए।” ");
INSERT INTO bfz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तेबे कोई तिना पाँदे थूकणे लगे, कोई मूँ टखणे लगे, कोई मुक्के बाणे लगे और तिना ते बोलणे लगे, “भविष्यबाणी कर।” और सिपाई तिना खे पकड़ी की थप्पड़ बाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जेबे पतरस आँगणो रे था, तेबे प्रदान पुरोईतो री दासिया बीचा ते एक तेती आई ");
INSERT INTO bfz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","और जेबे पतरस आग सेखणे लगी रा था, तेबे से तेसखे टकटक करी की देखणे लगी और बोलणे लगी, “तूँ बी तो तेस यीशु नासरियो साथे था।” ");
INSERT INTO bfz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","से मुकरी गा, और बोलणे लगेया, “आऊँ तो नि जाणदा और मेरी समजा रे नि आऊँदा कि तूँ क्या लगी री बोलणे।” तेबे से बारे देऊल़िया गे गया और मुर्गे बांग दित्ती। ");
INSERT INTO bfz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","तेबे से दासी फेर तेसखे देखी की, जो तेती नेड़े खड़ी रे थे, तिना गे बोलणे लगी, “ये तो तिना बीचा ते एक ए।” ");
INSERT INTO bfz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पर से फेर मुकरी गा और थोड़ी देर बाद जो तेती खड़ी रे थे, तिने फेर पतरसो खे बोलेया, “पक्का तूँ तिना बीचा ते एक ए, तूँ बी तो गलीली ए, कऊँकि तेरी बोलिया ते तूँ गलीली लगोआ।” ");
INSERT INTO bfz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","तेबे से आपू खे कोसणे लगेया और कसम खाणे लगेया, “जेस मांणूए रे बारे रे तुसे बोलणे लगी रे, आऊँ तेसखे बिल्कुल पनि जाणदा।” ");
INSERT INTO bfz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तेबे तेबुई मुर्गे दूजी बार फेर बांग दित्ती। तेबे पतरसो खे से गल्ल, जो यीशुए तेसखे बोली थी, याद आई कि, “मुर्गे री दो बार बांग देणे ते पईले तूँ तीन बार माखे जाणने ते मुकरना।” तेबे से एसा गल्ला सोची की जोरे-जोरे की रोणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","प्यागा ऊँदे ई फटाफट बड़े पुरोईत, बुजुर्ग, शास्त्री और सारी बड़ी सभा सलाह् कित्ती कि एस साथे क्या करिए। तेबे यीशु बानी ते और तिना खे लईगे और पिलातुस हाकिमो रे आथो रे देई ते। ");
INSERT INTO bfz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","तेबे पिलातुसे तिना ते पूछेया, “क्या तूँ यहूदिया रा राजा ए?” यीशुए तेसखे बोलेया, “तूँ आपू ई लगी रा बोलणे।” ");
INSERT INTO bfz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","बड़े पुरोईत तिना पाँदे बऊत दोष लगाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुसे तिना ते फेर पूछेया, “क्या तांगे कोई जवाब ए देणे खे? देख, यो तां पाँदे कितणे दोष लगी रे लगाणे।” ");
INSERT INTO bfz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","यीशुए फेर बी कुछ जवाब नि दित्तेया। ये देखी की पिलातुस हैरान ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","पिलातुस हर साल फसह रे त्योआरो रे एकी कैदियो खे, जेसखे सेयो बोलो थे, तिना खे छाडी देओ था। ");
INSERT INTO bfz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","तेस बखते बरअब्बा नाओं रा एक मांणू तिना हुड़दंग करने वाल़ेया साथे जेला रे था, जिने दंगेया रे अत्या कित्ती थी। ");
INSERT INTO bfz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","तेबे पीड़ ऊबे जाई की तेसते बिनती करने लगी, “जेड़ा तुसे आसा खे करदे आए, तेड़ा ई करो।” ");
INSERT INTO bfz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलातुसे तिना खे बोलेया, “क्या तुसे ये चाओए कि आऊँ तुसा खे यहूदिये रे राजे खे छाडी देऊँ?” ");
INSERT INTO bfz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","पिलातुस जाणो था कि बड़े पुरोईते यीशुए ते जल़न राखोए, तेबेई तिने से पकड़वाया। ");
INSERT INTO bfz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पर बड़े पुरोईते लोक ऊकसाए, “बरअब्बे खे आसा खे छाडी देओ।” ");
INSERT INTO bfz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ये सुणी की पिलातुसे तिना ते फेर पूछेया, “जेसखे तुसे यहूदिया रा राजा बोलोए, तेस साथे क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","सेयो ओर बी चिंगणे लगे, “एसखे क्रूसो पाँदे चढ़ाओ।” ");
INSERT INTO bfz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातुसे तिना खे बोलेया, “कऊँ?, इने क्या बुरा करी राखेया?” पर सेयो और बी चिंगणे लगे, “एसखे क्रूसो पाँदे चढ़ाओ।” ");
INSERT INTO bfz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तेबे पिलातुसे पीड़ा खे खुश करने री ईच्छा ते बरअब्बा तिना खे छाडीता, और यीशुए खे कोड़े लगवाई की तिना गे सम्बाल़ी ता कि क्रूसो पाँदे चढ़ाया जाओ। ");
INSERT INTO bfz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","तेबे रोमी सिपाई यीशुए खे पीतरे आँगणो दे लईगे, जेतेखे प्रीटोरियुम राज्यपालो रा मुख्यालय बी बोलोए, और सारी सिपाईया री पल़टण बुलाई। ");
INSERT INTO bfz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","तेबे तिने यीशुए खे बैंगणी टाले पणयाए और कांडेया रा मुकट बूणी की तिना रे सिरो पाँदे राखी ता। ");
INSERT INTO bfz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","और तिना खे ये बोली की तिना रा मजाक उड़ाणे लगे, “हे यहूदिया रे राजा, नमस्कार।” ");
INSERT INTO bfz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","सेयो तिना रे सिरो पाँदे नगल़ो रे डण्डे की बाओ थे, तिना पाँदे थूको थे और कूटणे टेकी की माथा टेको थे। ");
INSERT INTO bfz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","जेबे सेयो तिना रा मजाक उड़ाई चूके, तेबे तिना पाँदो ते बैंगणी टाले खुलाई ते और तिना रेई टाले पणयाईते और यीशुए खे क्रूसो पाँदे चढ़ाणे खे बारे ली आए। ");
INSERT INTO bfz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","जेबे सेयो यीशुए खे क्रूसो पाँदे चढ़ाणे खे लयी चली रे थे। तेबे सिकन्दर और रूफुसो रा पिता, शमौन नाओं रा एक कुरेनी मांणू, जो दूजे गांव ते आऊणे लगी रा था, तेसी बखते से तिसिये निकल़ेया। तेबे सिपाईए से ईंयां ई पकड़ी ता कि यीशु रा क्रूस चकी की लई चल। ");
INSERT INTO bfz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","तेबे सेयो यीशुए खे गुलगुता नाओं री जगा रे पकड़ी की लईगे, जेतेखे खोपड़िया री जगा बी बोलोए। ");
INSERT INTO bfz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","तेबे सेयो तिना खे मुर्र नाओं री जड़ी बूटी मलाई की अँगूरा रा रस पीणे खे देणे लगे, पर तिने नि पिया। ");
INSERT INTO bfz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तेबे तिने यीशु क्रूसो पाँदे चढ़ाए और तेबे तिना रे टाले रिया चिट्ठिया पाईया कि केसी खे क्या मिलणा, और सेयो बांडी ते। ");
INSERT INTO bfz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","तेबे प्यागा रे नौ बजे रा बखत था, जेबे तिने सेयो क्रूसो पाँदे चढ़ाई ते। ");
INSERT INTO bfz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","और तिना रा दोष-पत्र लिखी की क्रूसो पाँदे तिना पाँदे लगाई ता कि “यहूदिया रा राजा।” ");
INSERT INTO bfz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","तेबे तिने दो डाकू, एक तिना रे दाँणे कनारे और एक खूँजे कनारे, क्रूसो पाँदे चढ़ाए। ");
INSERT INTO bfz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तेबे धर्मशास्त्रो रा से वचन कि, “से अपराधिया साथे गिणेया जाणा” पूरा ऊआ। ");
INSERT INTO bfz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","बाटा रे जाणे वाल़े सिर इलाई-इलाई की ये बोली की तिना री निन्दा करो थे, “वाह! मन्दरो खे टाल़ने वाल़े और तीन दिना रे बनाणे वाल़े, ");
INSERT INTO bfz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","क्रूसो पाँदा ते उतरी की आपणे आपू खे बचा।” ");
INSERT INTO bfz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ईंयां ई बड़े पुरोईत बी, शास्त्रिया साथे, आपू बीचे मजाक करो थे, “इने ओर तो बचाए, पर आपू खे नि बचाई सकेया। ");
INSERT INTO bfz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इस्राएलो रा राजा मसीह, एबे क्रूसो ते ऊतरी की तो आओ, ताकि आसे बी देखी की विश्वास करिए।” जो तिना साथे क्रूसो पाँदे चढ़ाए राखे थे, सेयो बी तिना री निन्दा करो थे। ");
INSERT INTO bfz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","और जेबे त्याड़ी ऊई, तेबे सारे देशो रे न्हेरा ऊईगा और तीजे पईरो तक रया। ");
INSERT INTO bfz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","तीजे पइरो रे यीशुए जोरे की बोलेया, “इलोई, इलोई लमा शबक्तनी?” जेतेरा मतलब ए, “ओ मेरे परमेशर, ओ मेरे परमेशर! तुसे आऊँ कऊँ छाडीता?” ");
INSERT INTO bfz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","जो नेड़े थे खड़े रे, तिना बीचा ते कुछ जणेया ये सुणी की बोलेया, “देखो, ये एलिय्याहो खे आक्का पाणे लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","तेबे एकी जणे दौड़ी की स्पंज सिरके रे डबोया और नगल़ो रे डण्डे पाँदे राखेया और तिना खे चुसाया, और बोलेया, “चलो थोड़ा रूकी कि देखूँए कि एलिय्याह एसखे उतारने आओआ कि नि।” ");
INSERT INTO bfz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तेबे यीशुए जोरे की चींगी की प्राण छाडी ते। ");
INSERT INTO bfz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","तेबे मन्दरो रा पड़दा पाँदो ते लई की थालो तक फटीगा और तिजी रे दो टुकड़े ऊईगे। ए ये दखाओ कि एबे कोई बी मांणू परमेशरो री हजुरिया रे जाई सकोआ। ");
INSERT INTO bfz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","जो सूबेदार तेती था खड़े रा, जेबे तिने यीशु ईंयां चींगी की प्राण छाडदे ऊए देखे, तो तेबे तिने बोलेया, “सच्ची ये तो परमेशरो रा पुत्र था।” ");
INSERT INTO bfz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","कुछ जवाणसा दूरो ते देखणे लगी री थिया, तिना बीचा ते मरियम मगदलिनी और छोटे याकूब और योसेसो री आम्मा मरियम और सलोमी थिया। ");
INSERT INTO bfz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जेबे यीशु गलील प्रदेशो रे थे, तेबे सेयो तिना पीछे-पीछे जाओ थिया और तिना री सेवा करो थिया, ओर बी कई जवाणसा थिया, जो तिना साथे यरूशलेम नगरो रे आईया थिया। ");
INSERT INTO bfz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जेबे साँज ऊई, तेबे, कऊँकि से त्यारिया रा दिन था, जो आरामो रे एक दिन पईले ओआ, ");
INSERT INTO bfz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","तेबे अरिमतियाह रा रणे वाल़ा यूसुफ आया, जो बड़ी सभा रा खास जाणेया-मानेया रा सदस्य था और आपू बी परमेशरो रे राज्य री बाट न्याल़ो था। से याओ करी की पिलातुसो गे गया और यीशुए री लोथ मांगी। ");
INSERT INTO bfz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातुस हैरान ऊईगा कि से ईतणे चट मरी गा; तेबे तिने सूबेदार बुलाया और तेसते पूछेया, “क्या यीशु सच्ची मरी गा?” ");
INSERT INTO bfz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","जेबे तिने सूबेदारो ते सारा आल जाणी ला, तेबे पिलातुसे लोथ यूसुफो खे दलाई ती। ");
INSERT INTO bfz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तेबे तिने एक मलमलो री चादर खरीदी और लोथ ऊतारी की चादरी रे लपेटी और कब्रा रे राखी, जो चट्टानी रे थी खणी री। तेबे कब्रा रे द्वारो पाँदे एक पात्थर खसकेईता। ");
INSERT INTO bfz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","तेबे मरियम मगदलिनी और योसेसो री आम्मा मरियम देखणे लगी री थिया कि तिने यीशुए री लोथ केयी राखी रिये। ");
INSERT INTO bfz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जेबे आरामो रा दिन बीती गा, तेबे मरियम मगदलिनी और याकूबो री आम्मा मरियम और सलोमिए, अच्छी बासी वाल़िया चीजा मोले लईया, ताकि आई की तिना पाँदे मल़िए। ");
INSERT INTO bfz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","और अफ़्ते रे पईले दिने, जेबे प्याग ऊई और सूरज निकल़ेया ई था, तेबे सेयो कब्रा गे आईया। ");
INSERT INTO bfz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","और आपू बीचे बोलणे लगीया, “आसा खे कब्रा रे द्वारो पाँदो ते पात्थर केस टाणा?” ");
INSERT INTO bfz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","जेबे तिने आखी चकिया तो देखेया कि पात्थर तो कनारे टाये राए। कऊँकि से बऊत बड़ा था। ");
INSERT INTO bfz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","तेबे कब्रा रे पीतरे जाई की तिने एक जवान सफेद टाले पइने रा और दाणे कनारे बैठे रा देखेया और सेयो बऊत हैरान ऊई गिया। ");
INSERT INTO bfz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","तिने तिना खे बोलेया, “डरो नि। तुसे जेस यीशु नासरिये खे, जो क्रूसो पाँदे लटकाया था, टोल़ने लगी रिया। से जिऊँदा ऊईगा रा, से एती निए देखी लो; ये सेई जगा ए जेती से राखी राखेया था। ");
INSERT INTO bfz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","पर तुसे जाओ और तिना रे चेलेया खे और पतरसो खे बोलो, ‘सेयो तुसा ते पईले गलील प्रदेशो रे पऊँछी जाणे, जेड़ा तिने तुसा खे बोलेया था, तुसा से तेथी देखणा।’ ” ");
INSERT INTO bfz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","तेबे सेयो कब्रा गे ते नठी गिया, कऊँकि सेयो कबराई गिया थिया और तिना रे थुरनी छूटी गी थी, तिने डरो रे मारे केसी गे कुछ नि बोलेया। ");
INSERT INTO bfz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","अफ़्ते रे पईले दिने प्यागा ई, जेबे यीशु मरे रेया बीचा ते जिऊँदे ऊए तेबे सबी ते पईले मरियम मगदलिनिया खे दिशे। पईले जेसा ते तिने सात दुष्टात्मा निकयाल़िया थिया। ");
INSERT INTO bfz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","तेसे जाई की तिना रे चेलेया गे, जो बऊत दु:खी थे और रोणे लगी रे थे, तिना गे समाचार सुणाया। ");
INSERT INTO bfz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","पर तिने मरियम मगदलीनिया री गल्ला पाँदे विश्वास नि कित्तेया कि यीशु जिऊँदे ऊईगे रे और तेसे सेयो देखे। ");
INSERT INTO bfz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","तिजी ते बाद यीशु दूजे रूपो रे तिना बीचा ते दूँईं जणेया खे दिशे, जेबे सेयो गांव खे जाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","तिने बी जाई की ओरी खे समाचार दित्तेया, पर तिने तिना पाँदे बी विश्वास नि कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","बादो ते यीशु तिना ग्यारा चेलेया खे बी दिशी गे, जेबे सेयो रोटी लगी रे थे खाणे और तिना रे अविश्वासो और काठे मनो खे ल़वामा दित्तेया, कऊँकि जिने सेयो जिऊँदे ऊणे ते बाद देखे थे, तिने तिना रा विश्वास नि कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","यीशुए तिना खे बोलेया, “तुसे सारी दुनिया रे जाई की सारी सृष्टिया रे लोका खे सुसमाचार प्रचार करो। ");
INSERT INTO bfz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जेस विश्वास करना और बपतिस्मा लणा, तेसरा ई उद्धार ऊणा, पर जेस विश्वास नि करना से दोषी ठईराया जाणा। ");
INSERT INTO bfz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","और विश्वास करने वाल़ेया रे ये चिह्न् ऊणे कि तिना मेरे नाओं ते दुष्टात्मा निकयाल़निया; नई-नई पाषा बोलणिया; ");
INSERT INTO bfz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","साप चकी देणे और जे सेयो नाश करने वाल़ी चीज बी पी लओगे, तो तेबे बी तिना खे कुछ नि ऊणा, तिना बमारा पाँदे आथ राखणा और सेयो ठीक ऊई जाणे।” ");
INSERT INTO bfz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","तिना साथे गल्ला करने ते बाद प्रभु यीशु स्वर्गो खे चकी ते और सेयो परमेशरो रे दाँणे कनारे बैठे। ");
INSERT INTO bfz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","तेबे चेलेया हर जगा प्रचार कित्तेया, प्रभु तिना साथे काम करदे रए, और तिना चिह्ना साथे, जो साथे-साथे ऊणे लगी रे थे, और ये सामणे ल्याऊँदे रए कि परमेशरो रा ये सन्देश सच्चा ए। आमीन्।");
INSERT INTO bfz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","बऊत जणेया सेयो गल्ला, जो आसा बीचे ओईया, इतियास लिखणे रे आसा री मताद कित्ती, ");
INSERT INTO bfz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","जेड़ा कि पईले ई तिने जो इना गल्ला खे देखणे वाल़े और वचनो खे मानणे वाल़े सेवक थे, आसा गे पऊँछाईया। ");
INSERT INTO bfz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","तेबेई तो, ओ श्रीमान् थियुफिलुस! माखे बी ये ठीक लगेया कि तिना सबी गल्ला रा सारा आल शुरूओ तेई ठीक-ठीक पता लगाई की तिना ताखे एक-एक करी की लिखूँ। ");
INSERT INTO bfz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ताकि तूँ ये जाणी लो कि यो गल्ला, जिना री तैं शिक्षा पाई राखी, केड़िया अटल ए। ");
INSERT INTO bfz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया प्रदेशो रे राजा हेरोदेसो रे बखते अबिय्याहो रे दलो रे जकरयाह नाओं रा एक पुरोईत था और तेसरी लाड़िया रा नाओं इलीशिबा था। ये दोनो लाड़ा-लाड़ी हारूणो रे कुलो रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","सेयो दोनो परमेशरो सामणे तर्मी थे और परमेशरो री सारी आज्ञा और बिधिया पाँदे निर्दोष चलो थे। ");
INSERT INTO bfz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","तिना रे कोई ल्वाद नि थी, कऊँकि इलीशिबा बांझ थी और सेयो दोनो स्याणे ऊईगे थे। ");
INSERT INTO bfz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","एक दिन जेबे जकरयाह आपणे दलो री बारिया पाँदे परमेशरो सामणे पुरोईतो रा काम करो था। ");
INSERT INTO bfz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","तेबे पुरोईता री रवाजा रे मुताबिक, तेसरे नाओं री चिट्ठी निकल़ी, कि परमेशरो रे मन्दरो रे जाई की तूप बाल़। ");
INSERT INTO bfz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","और तूप बाल़ने रे बखते, लोका री सारी मण्डल़ी बारे मन्दरो रे आँगणो रे प्रार्थना करने लगी री थी। ");
INSERT INTO bfz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","तेबे जकरयाहो खे प्रभुए रा स्वर्गदूत तूपो री वेदिया रे दाँणे कनारे खड़ेया रा दिशेया। ");
INSERT INTO bfz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","जकरयाह तेसखे देखी की कबराईगा और बऊत डरीगा। ");
INSERT INTO bfz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पर स्वर्गदूते तेसखे बोलेया, “ओ जकरयाह! डर नि, कऊँकि परमेशरे तेरी प्रार्थना सुणी ली री और जो तेरी लाड़ी इलीशिबा ए, तेसा रे ताखे एक पाऊ जमणा और तैं तेसरा नाओं यूहन्ना राखणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ताखे आनन्द और खुशी ऊणी और बऊत सारे लोक तेसरे जमणे ते खुश ऊणे। ");
INSERT INTO bfz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","कऊँकि से परमेशरो सामणे महान् ऊणा, तेस अँगूरा रा रस और शराब कदी नि पीणा और से आपणी माया रे गर्भो तेई पवित्र आत्मा ते परेया रा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","तेस इस्राएलो बीचा ते कई जणे, तिना रे प्रभु परमेशरो री तरफा खे फेरने। ");
INSERT INTO bfz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","से एलिय्याह री आत्मा और सामर्था रे ऊई की तेसरे आगे-आगे चलणा ताकि पितरा रा मन बाल-बच्चेया री तरफा खे फेरो। आज्ञा नि मानणे वाल़ेया खे तर्मिया री समजा रे ल्याओ और प्रभुए खे एक लायक प्रजा त्यार करो।” ");
INSERT INTO bfz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकरयाहे स्वर्गदूतो ते पूछेया, “ये आऊँ किंयाँ जाणूं कि एड़ा ई मां साथे ऊणा? कऊँकि आऊँ और मेरी लाड़ी तो स्याणे ऊईगे रे।” ");
INSERT INTO bfz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","स्वर्गदूते तेसखे बोलेया, “आऊँ जिब्राईल ए, जो परमेशरो सामणे खड़ा रओआ। आऊँ तां साथे गल्ला करने और ये सुसमाचार सुनाणे रिया तंईं पेजी राखेया ");
INSERT INTO bfz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","और देख जदुओ तक यो गल्ला पूरिया नि ऊई जाओगिया, तदुओ तक तूँ चुप रणा और बोली नि सकदा। कऊँकि तैं मेरिया गल्ला पाँदे कि सेयो आपणे बखते पूरिया ऊणिया, विश्वास नि कित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","लोक जकरयाहो खे न्याल़दे रए और हैरान ऊईगे कि तेसखे मन्दरो रे इतणी देर किंयाँ ऊईगी? ");
INSERT INTO bfz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जेबे से बारे आया, तेबे से तिना साथे गलाई नि सकेया, तेबे तिना खे पता लगी गा कि तिने मन्दरो रे कोई दर्शन पाई राखेया, से तिना साथे साअरे रे गल्ला करदा रया और गूँगा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जेबे मन्दरो रे तेसरे पुरोईतो रे कामो री सेवा करने रे दिन पूरे ऊईगे, तेबे से यरूशलेमो नगरो खे छाडी की आपणे कअरो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","तेबे तेसरी लाड़ी इलीशिबा गर्भवती ऊईगी और पाँज मीन्ने तक आपू खे कअरे ये बोली की लकोए रे राखेया, ");
INSERT INTO bfz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“मांणूए जो मेरी बेज्जती करी राखी, तिजी खे दूर करने खे, परमेशरे मां पाँदे कृपा करने खे एड़ा करी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","इलीशिबा रे गर्भावस्था रे छटुए मीन्ने परमेशरो री तरफा ते जिब्राईल स्वर्गदूत गलील प्रदेशो रे नासरत नाओं नगरो रे, ");
INSERT INTO bfz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","एक कुआँरिया गे पेजेया। तेसारी मंगणी यूसुफ नाओं रे दाऊदो रे कराने रे एक माठे साथे ऊई थी। तेसा कुआँरिया रा नाओं मरियम था। ");
INSERT INTO bfz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","स्वर्गदूते तेसा गे पीतरे आयी की बोलेया, “खुशी और जय तेरी ओ, जेस पाँदे परमेशरो री कृपा ऊई री, प्रभु तां साथे ए।” ");
INSERT INTO bfz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","से तेस वचनो ते बऊत कबराई गी और सोचणे लगी कि ये केड़ी गल्ल ए? ");
INSERT INTO bfz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","स्वर्गदूते तेसा खे बोलेया, “ओ मरियम! डर नि कऊँकि परमेशरो री कृपा तां पाँदे ऊई री। ");
INSERT INTO bfz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","देख, तूँ गर्भवती ऊणी, तेरे एक पाऊ जमणा और तैं तेसरा नाओं यीशु राखणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","से महान् ऊणा, और परमप्रदानो रा पुत्र ऊणा और प्रभु परमेशरे तेसरे पुरखा दाऊदो रा सिंहासन तेसखे देणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","और तेस याकूबो रे कराने रे सदा राज्य करना और तेसरे राज्य रा अंत कदी नि ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियमे स्वर्गदूतो खे बोलेया, “ये किंयाँ ऊणा? आऊँ तो मर्दो खे जाणदी ई नि, कऊँकि आऊँ तो एबु कुँवारी ए” ");
INSERT INTO bfz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्वर्गदूते तेसा खे जवाब दित्तेया, “पवित्र आत्मा तां पाँदे उतरना और परमप्रदानो री सामर्थ तां पाँदे छांयाँ करनी, तेबेई तो से, जो जमणे वाल़ा ए, तेसखे पवित्र और परमेशरो रा पुत्र बोलेया जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","देख, तेरे टब्बरो री इलीशिबा रे बी स्याणदे बखते पाऊ ऊणे वाल़ा ए। ये तेसा रा, जेसा खे बांझ बोलोए, छटा मीन्ना चली रा। ");
INSERT INTO bfz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","कऊँकि परमेशर सब कुछ करी सकोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियमे बोलेया, “देख, आऊँ परमेशरो री दासी ए, मां साथे तेरे वचनो रे मुताबिक ओ।” तेबे स्वर्गदूत तेसा गे ते चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","तिना दिना रे मरियम उठी की फटाफट पाह्ड़ी इलाके रे यहूदा प्रदेशो रे एक नगरो खे गई ");
INSERT INTO bfz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","और तेसे जकरयाहो रे कअरे जाई की इलीशिबा खे नमस्ते कित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जिंयाँ ई इलीशिबे मरियमा री नमस्ते सुणी, तिंयाँ ई बच्चा तेसा रे पेटो रे उटकेया और ईलीशिबा पवित्र आत्मा ते फरी गी। ");
INSERT INTO bfz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","तेबे तेसे मरियमा खे जोरे की बोलेया, “तूँ सबी जवाणसा बीचे धन्य ए और जेस बच्चे खे तां जन्म देणा से बी धन्य ए। ");
INSERT INTO bfz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ये कृपा मां पाँदे केथा ऊई कि मेरे प्रभुए री आम्मा मांगे आयी? ");
INSERT INTO bfz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","जिंयाँ ई मैं तेरी नमस्ते सुणी, तिंयाँ ई बच्चा मेरे पेटो रे खुश ऊई की उटकणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","धन्य ए से, जिने विश्वास कित्तेया कि जो गल्ला प्रभुए री तरफा ते तेसा गे बोलिया, सेयो पुरिया ऊणिया।” ");
INSERT INTO bfz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","तेबे मरियमे बोलेया, “मेरा प्राण प्रभुए री बढ़ाई करोआ। ");
INSERT INTO bfz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","और मेरी आत्मा मेरा उद्धार करने वाल़े परमेशरो ते खुश ए। ");
INSERT INTO bfz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","कऊँकि तिने आपणी दासिया कनारो खे देखेया, तेबेई तो, देखो, आजो ते सारे जुगा-जुगा रे लोका माखे धन्य बोलणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","कऊँकि तिने शक्तिमाने मेरे बड़े-बड़े काम करी राखे और तेसरा नाओं पवित्र ए। ");
INSERT INTO bfz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","तेस परमेशरो री दया, जो तेसते डरोए, पीढ़िया री पीढ़िया तक बणी री रओई। ");
INSERT INTO bfz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","तिने आपणे आथो रे जरिए सामर्था रे काम दिखाए और जो आपू खे बड़ा समजोए, सेयो रूल़ाई ते। ");
INSERT INTO bfz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","तिने राजेया रा राज खत्म करी ता और शरीफ ऊच्चे कित्ते। ");
INSERT INTO bfz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","तिने पूखे अच्छी चीजा ते रजाए और अमीर खाली आथे निकयाल़ी ते। ");
INSERT INTO bfz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","तिने आपणा सेवक इस्राएल सम्बाल़ी ता। ताकि आपणी तेसा दया रे वादे खे याद करुँ, ");
INSERT INTO bfz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","जो अब्राहम और तेसरे कुल़ो पाँदे सदा रणी, जेड़ा तिने म्हारे बाओ-दादेया खे बोलेया था।” ");
INSERT INTO bfz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम तकरीबन तीन मीन्ने तक तेती रई और तेबे कअरो खे चली गी। ");
INSERT INTO bfz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","तेबे इलीशिबा रे बच्चा पैदा करने रा बखत पूरा ऊईगा और तेसा रे एक पाऊ जम्मेया। ");
INSERT INTO bfz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","तेसा रे पड़ोसी और टब्बरो वाल़ेया जेबे ये सुणेया कि प्रभुए तेसा पाँदे बड़ी पारी दया करी राखी, सेयो तेसा साथे बऊत खुश ऊए। ");
INSERT INTO bfz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","तेबे एड़ा ऊआ कि सेयो आठुए दिने बाल़को रा खतना करने आए और तेसरा नाओं, तेसरे बाओ रे नाओं पाँदे जकरयाह राखणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","तेबे बच्चे री आम्मे बोलेया, “ना; एसरा नाओं यूहन्ना राखणा।” ");
INSERT INTO bfz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","तेबे तिने बोलेया, “तेरे टब्बरो रे एड़ा नाओं केसी रा निए।” ");
INSERT INTO bfz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","तेबे तिने तेसरे बाओ ते साअरे रे पूछेया, “तूँ एसरा क्या नाओं राखणा चाएया?” ");
INSERT INTO bfz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","तेबे तिने लिखणे री पट्टी मुंगाई की लिखी ता, “एसरा नाओं यूहन्ना ए” और सब हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","तेबे तेसरा मूँ और जीब तेबुई खुली गी। तेबे से बोलणे जोगा ऊईगा और परमेशरो रा धन्यवाद करने लगेया। ");
INSERT INTO bfz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","तेसरे ओरे-पोरे रणे वाल़े लोक डरी गे और तिना सबी गल्ला री चर्चा यहूदिया प्रदेशो रे सारे पाह्ड़ी इलाके रे फैली गी। ");
INSERT INTO bfz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","सब सुणने वाल़े आपणे-आपणे मनो रे बिचार करने लगे, “ये बाल़क केड़ा ऊणा?” कऊँकि परमेशरो रा आथ तेस साथे ए। ");
INSERT INTO bfz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","तेबे तेसरा पिता जकरयाह पवित्र आत्मा ते परी गा और भविष्यबाणी करने लगेया, ");
INSERT INTO bfz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“प्रभु इस्राएलो रा परमेशर धन्य ए, जो तिने आपणे लोका कनारो खे देखेया और तिना खे छुटकारा दित्तेया ");
INSERT INTO bfz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","और आपणे सेवक दाऊदो रे कराने रे आसा खे उद्धारकर्ता पेजी राखेया। ");
INSERT INTO bfz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","जेड़ा तिने आपणे पवित्र भविष्यबक्तेया ते बुलवाया था, जो दुनिया रे शुरूओ ते ऊँदे ऊए आयी रे ");
INSERT INTO bfz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","मतलब-आसा रे दुश्मणा ते और बैरिया रे आथो ते म्हारा उद्धार करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ताकि आसा रे बाप-दादेया पाँदे कृपा करी की आपणी पवित्र वाचा याद राखो ");
INSERT INTO bfz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","और से कसम जो तिने आसा रे पिते अब्राहमो साथे खाई थी ");
INSERT INTO bfz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","कि तेस आसा खे ये देणा, ताकि आसे आपणे दुश्मणा रे आथो ते बची की ");
INSERT INTO bfz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","परमेशरो सामणे पवित्रता, और धार्मिकता साथे सारी जिन्दगी नच्चके रई की तेसरी सेवा करदे रईए। ");
INSERT INTO bfz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ओ बाल़क! ताखे परमप्रदान परमेशरो रा भविष्यबक्ता बोलेया जाणा, कऊँकि तूँ प्रभुए री बाट त्यार करने खे तिना रे आगे-आगे चलणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ताकि तिना रे लोका खे उद्धारो रा ज्ञान देई सके, जो तिना रे पापो री माफिया ते मिलोआ। ");
INSERT INTO bfz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ये आसा रे परमेशरो री तेसा बड़िया दया ते ऊणा; जेसरी बजअ ते, स्वर्गो ते आसा पाँदे प्यागा रा प्रयासा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ताकि न्हेरे रे और मरने वाल़ेया खे जिन्दगी देई सको, और आसा रे पैरा खे शान्तिया री बाटा रे सिदे चलाई सको।” ");
INSERT INTO bfz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","तेबे से बाल़क यूहन्ना बड़दा और आत्मा रे तागतबर ऊँदा गया और इस्राएलो रे सामणे आऊणे रे दिना तक, जंगल़ो रे रया। ");
INSERT INTO bfz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","तिना दिना रे रोमी महाराजा अगस्तुस कैसरो री तरफा ते आज्ञा निकल़ी की सारे रोमी साम्राज्य रे लोका री गणना कित्ती जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ये पईली गणना तेस बखते ऊई, जेबे क्विरिनियुस सीरिया प्रदेशो रा राज्यपाल था। ");
INSERT INTO bfz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","तेबे सब लोक नाओं लिखाणे खे आपणे-आपणे नगरो खे गए। ");
INSERT INTO bfz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","तेबे यूसुफ बी इजी री खातर कि से दाऊदो रे कराने और कुलो रा था, गलीलो रे नासरत नगरो ते, यहूदिया दे, दाऊदो रे नगर बैतलहमो खे गया। ");
INSERT INTO bfz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ताकि आपणी मंगेतर मरियमा साथे, जो गर्भवती ए, नाओं लिखाऊँ। ");
INSERT INTO bfz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","जेबे सेयो बैतलहम पऊँछे तेबे मरियमा रे बच्चा जमणे रिया पीड़ा लगी गिया। ");
INSERT INTO bfz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","तेसा रे पईला बच्चा पाऊ ऊआ, तेसे से टालेया साथे लपेटी की डांगरा री खुरलिया रे राखेया, कऊँकि तिना खे संरायी रे रणे खे जगा नि मिली। ");
INSERT INTO bfz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","तेस देशो रे बऊत गाद्दी थे, जो राती मैदानो रे रई की आपणे चूण्डो रा पईरा देयो थे। ");
INSERT INTO bfz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","तेबे परमेशरो रा एक स्वर्गदूत तिना रे सामणे आयी की खड़ा ऊईगा और परमेशरो रा तेज तिना रे चऊँ कनारे चमकणे लगेया और सेयो बऊत डरी गे। ");
INSERT INTO bfz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","तेबे स्वर्गदूते तिना खे बोलेया, “डरो नि, कऊँकि देखो आऊँ तुसा खे बऊत खुशिया रा सुसमाचार सुनाणे आयी रा, जो सारे लोका खे ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","कि आज दाऊदो रे नगर बैतलहमो रे तुसा खे एक उद्धारकर्ता जम्मी रा और येई मसीह प्रभु ए। ");
INSERT INTO bfz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","और इजी रा पता तुसा खे ईंयां लगणा, तुसा खे एक बाल़क टालेया रे लपेटेया रा और डांगरा री खुरलिया रे पड़ेया रा मिलणा।” ");
INSERT INTO bfz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","तेबे एकदम तेस स्वर्गदूतो साथे, स्वर्गदूता रा एक दल, परमेशरो री स्तुति करदे ऊए और ये बोलदे ऊए दिशेया, ");
INSERT INTO bfz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“स्वर्गो रे परमेशरो री महिमा और तरतिया रे, तिना मांणूआ खे जिना ते आऊँ खुश ए, शान्ति ओ।” ");
INSERT INTO bfz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जेबे स्वर्गदूत तिना गे ते स्वर्गो खे चली गे, तेबे गाद्दी आपू बीचे बोलणे लगे, “आओ आसे बैतलहमो खे चलूँए और जो गल्ल प्रभुए आसा गे बताई राखी, तेसा देखूँए।” ");
INSERT INTO bfz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","तेबे तिने तेबुई जाई की मरियम और यूसुफ और डांगरा री खुरलिया रे से बाल़क लेटेया रा देखेया। ");
INSERT INTO bfz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","इना खे देखी की से गल्ल जो एस बाल़को रे बारे रे तिने बोली थी, सामणे आयी। ");
INSERT INTO bfz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","सबी सुणने वाल़ेया, तिना गल्ला ते जो गाद्दिये तिना गे बताईया थिया, हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","पर मरियम इना सबी गल्ला खे आपणे मनो रे सोचदी रई। ");
INSERT INTO bfz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","तेबे गाद्दी परमेशरो री स्तुति और गुणगाण करदे ऊए वापस चली गे, कऊँकि जो कुछ तिने देखी राखेया था,से ठीक तेड़ा ई था जेड़ा स्वर्गदूते तिना खे बोली राखेया था। ");
INSERT INTO bfz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","जेबे आठ दिन पूरे ऊईगे और खतने रा बखत आया, तेबे तेसरा नाओं यीशु राखेया, जो स्वर्गदूते तेसरे मरियमा रे पेटो रे आऊणे ते पईले बताया था। ");
INSERT INTO bfz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","जेबे मूसे रा बिधानो रे मुताबिक मरियम और यूसुफो रे शुद्ध ऊणे रे दिन पूरे ऊए, तेबे सेयो यरूशलेम मन्दरो खे गए। सेयो बाल़क यीशुए खे बी आपू साथे यरूशलेमो रे मन्दरो रे ल्याए कि तेसखे प्रभुए रे सामणे अर्पण करो ");
INSERT INTO bfz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","जेड़ा प्रभुए रा बिधानो रे लिखी राखेया, “हर एक जेठा बाल़क प्रभुए खे पवित्र ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","मरियम और यूसुफो रे शुद्ध ऊणे खे प्रभुए रा बिधानो रे वचनो रे मुताबिक कूगीया रा एक जोड़ा या कबूतरो रे दो बच्चे ल्याई की बलिदान करो। ");
INSERT INTO bfz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","तेस बखते यरूशलेमो रे शमौन नाओं रा एक मांणू था, से तर्मी और भक्त था और इस्राएलो री शान्ति और मसीह रे आऊणे री बाट न्याल़ो था और पवित्र आत्मा तेस पाँदे था। ");
INSERT INTO bfz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","पवित्र आत्मा ते तेसखे चेतावणी मिली थी कि जदुओ तक तूँ प्रभुए रे मसीह खे नि देखी लएगा, तदुओ तक मरना नि। ");
INSERT INTO bfz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","तेबे से आत्मा रा सिखाया, मन्दरो रे आया, जेबे माए-बाओ बाल़क यीशुए खे पीतरे ल्याए, ताकि तेसखे बिधानो री रवाजा रे मुताबिक करूँए ");
INSERT INTO bfz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","तेबे तिने से बाल़क आपणी गोदा रे लया और परमेशरो रा धन्यवाद करी की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ओ स्वामी! एबे तूँ आपणे दासो खे आपणे वचनो रे मुताबिक बेफिकर ऊई की एते दुनिया ते बिदा कर। ");
INSERT INTO bfz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","कऊँकि मेरी आखी तेरा उद्धार देखी ला रा। ");
INSERT INTO bfz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जो तुसे सबी लोका रे सामणे त्यार करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ताकि से दूजी जातिया खे सच्चाईया खे सामणे ल्याऊणे खे एक जोति देओ और तेरे आपणे इस्राएलो रे लोका री महिमा ओ।” ");
INSERT INTO bfz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","यीशुए रे माए-बाओ, तिना गल्ला ते, जो शमौने तेसरे बारे रे बोली थी, हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","तेबे शमौने तेसखे आशीष देई की तेसरी आम्मा मरियमा खे बोलेया, “देख ये तो इस्राएलो रे बऊत जणेया रे रूड़ने, उठणे खे और एक एड़ा चिह्न् ऊणे खे ठईराई राखेया, जेसरे खलाफ बऊत गल्ला ऊणिया। ");
INSERT INTO bfz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","एथो तक तेरा प्राण बी तलवारी रे वारो साथे पार छीदी जाऊणा। इजी ते बऊत मनो रे बिचार प्रगट ऊणे।” ");
INSERT INTO bfz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","आशेरो रे गोत्रो बीचा ते हन्नाह नाओं री फनुएलो री बेटी एक भविष्यबक्तणी थी। से बऊत स्याणी थी और ब्या ऊणे ते बाद आपणे लाड़े साथे बस सात साल तक ई रई। ");
INSERT INTO bfz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","से चुरासी साला ते बिदुआ थी और जादातर मन्दरो रे रओ थी, से बअरत और प्रार्थना करी की रात-दिन भक्ति करदी रओ थी। ");
INSERT INTO bfz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","तेबे से तेस बखते तेती आयी की परमेशरो रा धन्यवाद करने लगी और तिना सबी खे जो यरूशलेमो रे लोका खे छुटकारे री बाट न्याल़ो थे, तेसरे बारे रे गल्ल करने लगी ");
INSERT INTO bfz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","जेबे यूसुफ और मरियम प्रभुए रा बिधानो रे मुताबिक सब कुछ नपटेई चूके, तेबे गलीलो रे आपणे नगर नासरतो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","तेबे बाल़क बड़दा, और तागतबर और अक्ला ते परिपूर्ण ऊँदा गया और परमेशरो री कृपा तेस साथे थी। ");
INSERT INTO bfz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","यीशुए रे माए-बाओ हर साल फसह रे त्योआरो खे यरूशलेमो खे जाओ थे। ");
INSERT INTO bfz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जेबे से बारा साला रा ऊआ, तेबे सेयो त्योआरो रे रवाजा रे मुताबिक, यरूशलेमो खे गये। ");
INSERT INTO bfz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","जेबे सेयो तिना दिना खे पूरा करी की आऊणे लगे, तेबे से बाल़क यीशु, यरूशलेमो रेई रई गा और ये गल्ल तेसरे माए-बाओ खे नि थी पता। ");
INSERT INTO bfz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","तिने सोचेया कि से ओरी यात्रिया साथे ऊणा, एक दिन बीती गा और तेबे सेयो तेसखे आपणे टब्बरो और जाण-पछयाण वाल़ेया गे टोल़ने लगे। ");
INSERT INTO bfz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","पर जेबे मिलेया नि, तेबे टोल़दे-टोल़दे यरूशलेमो रे पऊँछी गे। ");
INSERT INTO bfz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","और तेबे तीन दिन बाद तिना खे से मन्दरो रे आँगणो रे, उपदेशका साथे बैठे रे, तिना री सुणदे और तिना ते प्रश्न करदा ऊआ मिलेया। ");
INSERT INTO bfz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","जितणे जणे तेसरी सुणने लगी रे थे, सेयो सब तेसरी समज और जवाबो ते हैरान थे। ");
INSERT INTO bfz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","तेबे सेयो तेसखे देखी की हैरान ऊईगे और तेसरी आम्मे तेसखे बोलेया, “ओ पाऊ! तैं आसा साथे एड़ा कऊँ कित्तेया? देख, तेरे पिता जी और आऊँ ताखे रोषो रे टोल़ने लगी रे थे।” ");
INSERT INTO bfz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","यीशुए तिना खे बोलेया, “तुसे माखे कऊँ लगी रे टोल़ने? क्या जाणो नि थे कि मेरा मेरे परमेशरो रे भवनो रे ऊणा जरूरी ए?” ");
INSERT INTO bfz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पर जो गल्ल तिने तिना खे बोली, से तिना खे समज नि आयी। ");
INSERT INTO bfz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","तेबे से तिना साथे चली गा और नासरतो खे आया और तिना रे कुलो रे रया, तेसरी आम्मे यो सारिया गल्ला आपणे मनो रेई राखिया। ");
INSERT INTO bfz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","यीशु बुद्धि और डील-डौल, परमेशर और मांणूए री कृपा रे बड़दे गये। ");
INSERT INTO bfz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबिरियुस महाराजा कैसरो रे राज्य रे पन्द्रुए साले जेबे पुन्तियुस पिलातुस यहूदिया प्रदेशो रा राज्यपाल था, और गलीलो रे हेरोदेस, इतुरैया और त्रखोनितीसो रे तेसरा पाई फिलिप्पुस और अबिलेनो रे लिसानियास रे राजा थे। ");
INSERT INTO bfz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","जेबे हन्ना और कैफा प्रदान पुरोईत थे, तेस बखते परमेशरो रा वचन सुनसाण जगा रे जकरयाहो रे पाऊ यूहन्ने गे पऊँछेया। ");
INSERT INTO bfz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","तेबे से यरदन नदिया रे नेड़े-तेड़े रे सारे देशो रे आयी की, पापो री माफिया खे, मन फेरने रे और बपतिस्मा लणे रा प्रचार करने लगेया। ");
INSERT INTO bfz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जेड़ा यशायाह भविष्यबक्ते रे बोले रे वचनो री कताबा रे लिखे राए कि, “सुणसाण जगा रे एक आक्का पाणे री आवाज ओई कि, प्रभुए री बाट त्यार करो, तिना री सड़का सीदिया करो। ");
INSERT INTO bfz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","हर एक काअटी परी जाणी, हर एक पाह्ड़ और टीला थाले करेया जाणा और जो टेडा ए, से सीदा और जो थाले पाँदे ए, से चौड़ी (सवीं) बाट बणनी ");
INSERT INTO bfz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","और सबी लोका परमेशरो रा उद्धार देखणा।” ");
INSERT INTO bfz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जो पीड़ा री पीड़ तेसते बपतिस्मा लणे आओ थी, तिना खे से बोलो था, “ओ सापो जेड़े जईरीले लोको! तुसा खे किने जताई ता कि आऊणे वाल़े परमेशरो रे रोषो ते नठो? ");
INSERT INTO bfz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","इजी री खातर मन फिराओ और अच्छे काम करो; और आपणे-आपणे मनो रे एड़ा नि सोचो, ‘आसा रा बाओ अब्राहम ए।’ कऊँकि आऊँ तुसा खे बोलूँआ कि परमेशर इना पात्थरा ते अब्राहमो खे ल्वाद पैदा करी सकोआ। ");
INSERT INTO bfz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","एबे परमेशर तुसा खे सजा देणे वाल़ा ए, तेबेई तो जो-जो डाल़ खरा फल नि ल्याऊँदे, से बाडे और आगी रे सेटे जाओए।” ");
INSERT INTO bfz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","तेबे लोके तेसते पूछेया, “परमेशरो री सजा ते बचणे खे आसे क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","यूहन्ने बोलेया, “जेसगे दो कुरते ए, से तेसखे बांडी देओ, जेसगे आए नि और जेसगे रोटी ओ, से बी एड़ा ई करो।” ");
INSERT INTO bfz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","तेबे कर लणे वाल़े बी बपतिस्मा लणे आए और तेसते पूछेया, “ओ गुरू! आसे क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","तिने बोलेया, “जो तुसा खे रोमी सरकारे ठराई राखेया, तिजी ते जादा नि लणा।” ");
INSERT INTO bfz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","तेबे सिपाईए बी तेसते पूछेया, “आसे क्या करुँ?” तिने बोलेया, “केसी खे नाजाईज तंग नि करना, ना चूठा दोष लगाणा और आपणी मजदूरिया पाँदे सन्तुष्टी राखणी।” ");
INSERT INTO bfz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जेबे सबी लोके मसीह रे आऊणे री उम्मीद लगाई राखी थी और आपणे-आपणे मनो रे यूहन्ने रे बारे रे बिचार करने लगी रे थे कि केथी येई तो मसीह तो निए? ");
INSERT INTO bfz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","तेबे यूहन्ने तिना सबी खे जबाब दित्तेया, “आऊँ तो तुसा खे पाणिए साथे बपतिस्मा देऊँआ, पर जो आऊणे वाल़ा ए, से मांते बी जादा महान् ए। आऊँ तो एते जोगा पनिए कि तेसरे जोड़े रे फिथे खोली सकूँ। तेस तुसा खे पवित्र आत्मा और आगी साथे बपतिस्मा देणा। ");
INSERT INTO bfz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","तेसरा सूप तेसरे आथो रे ए और तेस आपणा खल्याण ठीक टंगो ते साफ करना और कणक तो आपणे पण्डारो रे राखी देणी पर जो पूऊ ऊणा से एड़िया आगी रे सेटणा जो कदी नि बिजणी।” ");
INSERT INTO bfz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","तेबे से बऊत शिक्षा देई-देई की लोका खे सुसमाचार सुणांदा रया। ");
INSERT INTO bfz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","पर जेबे तिने गलील प्रदेशो रे चौथाई देशो रे राजा हेरोदेसो खे, तेसरे पाई फिलिप्पुसो री लाड़ी हेरोदियासा रे बारे रे और सब कुकर्मा रे बारे रे जो तिने कित्ते थे, फटकार दित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","हेरोदेसे तिना ते बढ़ी की कुकर्म बी कित्तेया कि यूहन्ना जेला रे पाईता। ");
INSERT INTO bfz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","जेबे सबी लोके बपतिस्मा लया और यीशु बी बपतिस्मा लयी की प्रार्थना करने लगी रे थे, तेबे सर्ग खुली गा। ");
INSERT INTO bfz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","तेबे पवित्र आत्मा शारीरिक रूपो रे जिंयाँ कबूतर उड़दा ऊआ थाले आओआ तिंयाँ तिने आपू पाँदे उतरदे ऊए देखेया और स्वर्गो ते ये आवाज आयी, “तूँ मेरा प्यारा पुत्र ए और आऊँ तांते खुश ए।” ");
INSERT INTO bfz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","जेबे यीशु आपू उपदेश देणे लगे, तेबे सेयो तकरीबन तीई साला रे थे (और जेड़ा समजेया जाओआ) यीशु यूसुफो रे पाऊ थे और यूसुफ एलीयो रा पाऊ था ");
INSERT INTO bfz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","और एली, मत्तातो रा पाऊ था, मत्तात लेवियो रा पाऊ था, लेवी मलकियो रा पाऊ था, मलकी यन्ना रा पाऊ था और यन्ना यूसुफो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","यूसुफ मत्तियाहो रा पाऊ था, मत्तियाह आमोसो रा पाऊ था, आमोस नहूमो रा पाऊ था, नहूम असल्याहो रा पाऊ था, असल्याह नोगह रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नोगह मातो रा पाऊ था, मात मत्तियाहो रा पाऊ था, मत्तियाह शिमियो रा पाऊ था, शिमी योसेखो रा पाऊ था और योसेख योदाह रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदाह यूहन्ने रा पाऊ था, यूहन्ना रेसा रा पाऊ था, रेसा जरूब्बाबिलो रा पाऊ था, जरूब्बाबिल शालतियेलो रा पाऊ था और शालतियेल नेरियो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरी मलकियो रा पाऊ था, मलकी अद्दियो रा पाऊ था, अद्दी कोसामो रा पाऊ था, कोसाम इलमोदामो रा पाऊ था और से एरो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एर येशुओ रा पाऊ था, येशु इलाजारो रा पाऊ था, इलाजार योरिमो रा पाऊ था, योरिम मत्तातो रा पाऊ था, मत्तात लेवियो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेवी शमोनो रा पाऊ था, शमोन यहूदाह रा पाऊ था, यहूदाह यूसुफो रा पाऊ था, यूसुफ योनानो रा पाऊ था, योनान इलयाकीमो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","और इलयाकीम मलेआहो रा पाऊ था, मलेआह मिन्नाहो रा पाऊ था, मिन्नाह मत्तता रा पाऊ था, मत्तता नातानो रा पाऊ था, नातान दाऊदो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाऊद यिशै रा पाऊ था, यिशै ओबेदो रा पाऊ था, ओबेद बोअजो रा पाऊ था, बोअज सलमोनो रा पाऊ था, सलमोन नहशोनो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहशोन अम्मीनादाबो रा पाऊ था, अम्मीनादाब अरनीयो रा पाऊ था, अरनी हिस्रोनो रा पाऊ था, हिस्रोन फिरिसो रा पाऊ था, फिरीस यहूदाहो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहूदाह याकूबो रा पाऊ था, याकूब इसहाको रा पाऊ था, इसहाक अब्राहमो रा पाऊ था, अब्राहम तिरहो रा पाऊ था, तिरह नाहोरो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नारोहो रा सरूगो रा पाऊ था, सरूग रऊओ रा पाऊ था, रऊ फिलिगो रा पाऊ था, फिलिग एबिरो रा पाऊ था, एबिर शिलहो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","शिलह केनानो रा पाऊ था, केनान अरफक्षदो रा पाऊ था, अरफक्षद शेमो रा पाऊ था, शेम नूहो रा पाऊ था, नूह लिमिको रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लिमिक मथूशिलहो रा पाऊ था, मथूशिलह हनोको रा पाऊ था, हनोक यिरिदो रा पाऊ था, यिरिद महललेलो रा पाऊ था, महललेल केनानो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनान इनोशो रा पाऊ था, इनोश शेतो रा पाऊ था, शेत आदमो रा पाऊ था और से परमेशरो रा पाऊ था। ");
INSERT INTO bfz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","तेबे यीशु पवित्र आत्मा ते परी की यरदनो नदिया ते वापस आये और चाल़ी दिन तक आत्मा रे सिखाणे खे सुणसाण जगा रे फिरदे रये; ");
INSERT INTO bfz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","और शैतान चाल़ी दिना तक तिना री परीक्षा करदा रया। तिना दिना रे तिने कुछ नि खाया और जेबे सेयो दिन पूरे ऊईगे तेबे तिना खे पूख लगी। ");
INSERT INTO bfz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","तेबे शैताने यीशुए खे बोलेया, “जे तूँ परमेशरो रा पुत्र ए, तो एस पात्थरो खे बोल कि रोटी बणी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","यीशुए तेसखे जवाब दित्तेया, “लिखी राखेया कि मांणू रोटिया साथे ई जिऊँदा नि रंणा।” ");
INSERT INTO bfz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","तेबे शैतान तिना खे लईगा और तिना खे एकदम दुनिया रे सारे राज्य दखाए। ");
INSERT INTO bfz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","और शैताने तिना खे बोलेया, “मां यो सब अक्क और इना रे एशो-आराम ताखे देई देणे, कऊँकि ये सब कुछ मांगे सम्बाल़ी राखेया और जेसखे चाऊँआ, तेसखे देई देऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","तेबे तिने यीशुए खे फेर बोलेया, “जे तां मांगे माथा टेकणा, तो ये सब कुछ तेरा ऊई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीशुए तेसखे जवाब दित्तेया, “लिखी राखेया कि तूँ बस प्रभु आपणे परमेशरो गे ई माथा टेक और बस तिना री ई आराधना कर।” ");
INSERT INTO bfz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","तेबे शैताने यीशु यरूशलेमो रे लयी जाई की मन्दरो री चूँडिया पाँदे खड़े करी ते। तेबे तिना खे बोलणे लगेया, “जे तूँ परमेशरो रा पुत्र ए, तो आपू खे एथा ते थाले रुड़ाई दे। ");
INSERT INTO bfz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","कऊँकि पवित्र शास्त्रो रे लिखी राखेया कि परमेशरो तेरिया तंईं आपणे स्वर्गदूता खे आज्ञा देणी कि सेयो तुसा खे बचाओ। ");
INSERT INTO bfz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","और तिना तूँ आपणे आथो-आथ चकी लणा, केथी एड़ा नि ओ कि तेरे पैरो रे पात्थरो साथे बूड़ो।” ");
INSERT INTO bfz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीशुए तेसखे जवाब दित्तेया, “पवित्र शास्त्रो रे ये बीए लिखेया राए, ‘तूँ प्रभु आपणे परमेशरो खे नि परख।’ ” ");
INSERT INTO bfz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जेबे शैतान तिना री सारिया परीक्षा करी चुकेया, तेबे कुछ बखतो खे यीशुए खे छाडी की चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","तेबे यीशु पवित्र आत्मा री सामर्था ते परी की गलीलो खे चली गे और तिना री चर्चा ओरे-पोरे सारे देशो रे फैली गी। ");
INSERT INTO bfz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","तेबे सेयो तिना रे प्रार्थना रे कअरो रे उपदेश देंदे रये और सब तिना री तारीफ करदे रये। ");
INSERT INTO bfz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","तेबे सेयो नासरतो गांव खे वापस आए, जेती सेयो पाल़े थे ओर आपणी रवाजा रे मुताबिक आरामो रे दिने प्रार्थना रे कअरो रे जाई की पढ़ने खे खड़े ऊए। ");
INSERT INTO bfz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","यशायाह भविष्यबक्ते री कताब तिना खे दित्ती और तिने कताब खोली की से जगा निकयाल़ी जेती ये लिखी राखेया था, ");
INSERT INTO bfz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभुए रा पवित्र आत्मा मां पाँदे ए, कऊँकि तिने मेरा अभिषेक कंगाल़ा खे सुसमाचार सुनाणे खे करी राखेया और आऊँ इजी खे पेजी राखेया ताकि दुष्टात्मा रे वशो रे पड़े रे लोका खे छुटकारे रा और अन्देया खे देखणे रा सुसमाचार प्रचार करुँ और केसेया रे खे छुडाऊँ। ");
INSERT INTO bfz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","और प्रभुए खे खुश रणे रे सालो रा प्रचार करुँ।” ");
INSERT INTO bfz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","तेबे तिने कताब बंद करी की सेवको रे आथो रे देईती और बैठीगे और प्रार्थना रे कअरो रे सब लोक तिना खे देखदे ई रये। ");
INSERT INTO bfz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","तेबे सेयो तिना खे बोलणे लगे, “आज ई ये लेख तुसा सामणे पूरा ऊई रा।” ");
INSERT INTO bfz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","सबी तिना री तारीफ कित्ती और जो कृपा री गल्ल तिना रे मुंओ ते निकल़ो थी, तिना ते हैरान ऊईगे और बोलणे लगे, “क्या ये यूसुफो रा पाऊ निए?” ");
INSERT INTO bfz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","तिने तेसखे बोलेया, “तुसा ये कहावत मां पाँदे जरूर बोलणी, ‘ओ बैद आपू खे ठीक कर! जो कुछ आसे सुणी राखेया कि कफरनहूमो रे करी राखेया, से एती आपणे देशो रे बी कर।’ ” ");
INSERT INTO bfz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","यीशुए बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि कोई बी भविष्यबक्ता आपणे देशो रे मान-सम्मान नि पाँदा। ");
INSERT INTO bfz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","आऊँ तुसा खे सच लगी रा बोलणे कि जेबे एलिय्याह नबीए रे दिना रे साडे तीन साल तक सर्ग बंद रया, एथो तक कि सारे देशो रे अकाल़ पड़ी गा था और इस्राएलो रे बऊत सारी बिदुआ थिया। ");
INSERT INTO bfz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पर एलिय्याह तिना बीचा ते केसी गे नि पेजेया, बस सिदोनो रे सारफत गांव रे एक बिदुआ ते अलावा। ");
INSERT INTO bfz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","और एलीशा भविष्यबक्ता रे बखते इस्राएलो रे बऊत सारे कोढ़ी थे, पर सीरिया देशो रे नामानो खे छाडी की तिना बीचा ते कोई बी ठीक नि कित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","इना सारिया गल्ला खे सुणी की जो प्रार्थना रे कअरो रे थे तिना सबी खे रोष आईगा। ");
INSERT INTO bfz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","तेबे तिने सबी उठी की सेयो बारे निकयाल़ी ते और जेते पाह्ड़ो पाँदे तिना रा नगर था, तेतेरी चूँडिया पाँदे लयी चले, ताकि तेथा ते तिना खे थाले सेटी की मारी देओ। ");
INSERT INTO bfz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पर यीशु तिना बीचा ते निकल़ी की चली गे। ");
INSERT INTO bfz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","तेबे सेयो गलीलो रे कफरनहूम नगरो खे गये और आरामो रे दिने लोका खे उपदेश देणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","सेयो तिना रे उपदेशो ते हैरान ऊईगे, कऊँकि तिना रा वचन अक्को साथे था। ");
INSERT INTO bfz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","प्रार्थना रे कअरो रे एक मांणू था, जेसरे दुष्टात्मा थी। ");
INSERT INTO bfz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","से जोरे की चींगणे लगेया कि, “ओ यीशु नासरी! आसा खे तांते क्या काम ए? क्या तूँ आसा खे नाश करने आयी रा? आऊँ ताखे जाणूंआ कि तूँ कुण ए? तूँ परमेशरो रा पवित्र पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीशु तेसखे बक्के और बोलेया, “चुप रओ; और एसते निकल़ी जा; तेबे दुष्टात्मा तेसखे बीचे पटकी की बिना नुकशाण पऊँछाए तेसते निकल़ी गी।” ");
INSERT INTO bfz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ये देखी की सब हैरान ऊईगे और सेयो आपू बीचे बोलणे लगे, “ये केड़ा वचन ए? और ये अक्क और सामर्था साथे दुष्टात्मा खे आज्ञा देओआ और सेयो निकल़ी जाओईया।” ");
INSERT INTO bfz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","तेबे चऊँ कनारे तिना रा बोल-बाला फैली गा। ");
INSERT INTO bfz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","यीशु प्रार्थना रे कअरो ते उठी की शमौनो रे कअरो खे गये और शमौनो री सासुआ खे बुखार था और तिने तेसा री खातर, यीशुए ते प्रार्थना कित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","सेयो तेसा रे नेड़े जाई की बुखारो खे बके और तेसा रा बुखार ऊतरी गा और से फटाफट उठी की तिना री सेवा करने लगी। ");
INSERT INTO bfz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","सूरज डूबणे ते पईले जेती-जेती लोक कईया प्रकारा रिया बमारिया रे पड़ी रे थे, सेयो सब तिना खे तेसगे ली आए और तिने एकी-एकी पाँदे आथ राखी की सेयो ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","तेबे दुष्टात्मा चींगदी ऊई और ये बोलदी उई, “तूँ परमेशरो रा पुत्र ए,” बऊत जणेया ते निकल़ी गी पर सेयो तिना खे बको थे और बोलणे नि देओ थे, कऊँकि सेयो तिना खे जाणो थिया कि ये मसीह ए। ");
INSERT INTO bfz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","जेबे दिन ऊआ तेबे सेयो निकल़ी की सुनसाण जगा खे चली गे और पीड़ा री पीड़ तिना खे टोल़दी उई तिना गे आयी और तिना खे रोकणे लगी कि आसा गे ते नि जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पर तिने तिना खे बोलेया, “माखे ओरी नगरा रे बी परमेशरो रे राज्य रा सुसमाचार सुनाणा जरूरी ए, कऊँकि आऊँ इजी खेई पेजी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","तेबे यीशु यहूदिया प्रदेशो रे प्रार्थना रे कअरो रे प्रचार करदे रये। ");
INSERT INTO bfz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","जेबे पीड़ यीशुए पाँदे पड़ो थी और परमेशरो रे वचन सुणो थी और सेयो गन्नेसरतो री झीला रे कनारे थे खड़े रे, तेबे एड़ा ऊआ ");
INSERT INTO bfz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","कि तिने झीला रे कनारे दो किस्तिया खड़ी रिया देखिया और मच्छुआरे तिना पाँदो ते ऊतरी की आपणे जाल़ लगी रे थे तोणे। ");
INSERT INTO bfz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","तिना किस्तिया बीचा ते एक किस्ती जो शमौनो री थी, चढ़ी की यीशुए तेसखे बोलेया, “थोड़ी जी कनारे जे लई चल।” तेबे सेयो किस्तिया पाँदे बैठी की लोका खे उपदेश देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","जेबे सेयो लोका साथे गल्ला करी चुके, तेबे तिने शमौनो खे बोलेया, “डूगे पाणिए रे लयी चल और मछलिया पकड़ने खे आपणे जाल़ पाओ।” ");
INSERT INTO bfz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","शमौने बोलेया, “स्वामी! आसे सारी रात मईणत कित्ती पर कुछ नि पकड़ेया, पर तेबे बी तेरे बोलणे ते जाल़ पाई देऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जेबे पतरस और तिना रे साथिए जाल़ पाईता तेबे बऊत सारिया मछलिया केरिया और तिना रे जाल़ फटणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","तेबे तिने आपणे साथिया खे, जो दूजी किस्तिया रे थे, तिना खे साअरा कित्तेया, “आयी की म्हारी मताद करो।” तिने आयी की आपणिया दोनो किस्तिया मच्छल़िया ते इतणिया परी तिया कि सेयो डूबणे लगिया। ");
INSERT INTO bfz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ये देखी की शमौन पतरस यीशुए रे पैरा पाँदे पड़ी गा और बोलणे लगेया, “ओ प्रभु! मांगा गे ते चली जा, कऊँकि आऊँ पापी मांणू ए।” ");
INSERT INTO bfz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","कऊँकि इतणिया सारिया मछलिया पकड़ी की देखी की से और तेसरे साथी हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","तिंयाँ ई जब्दी और तेसरे पाऊ याकूब और यूहन्ने खे बी, जो शमौनो साथे थे, सेयो बी हैरान ऊईगे, तेबे यीशुए शमौनो खे बोलेया, “डर नि, आजो ते तां मांणू परमेशरो री तरफा खे फेरने।” ");
INSERT INTO bfz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","तेबे सेयो किस्तिया खे कनारे पाँदे ली आए और सब कुछ छाडी की यीशुए पीछे चली पड़े। ");
INSERT INTO bfz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जेबे सेयो नगरो रे थे, तेबे तिना खे तेती एक कोढ़ी मिलेया और से प्रभुए खे देखी की तिना रे पैरो पाँदे पड़ी गा और बिनती कित्ती, “ओ प्रभु! जे तुसे चाओ तो माखे ठीक करी सकोए।” ");
INSERT INTO bfz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","यीशुए आपणा आथ आगे कित्तेया और से छूँयां और तेसखे बोलेया, “आऊँ चाऊँआ कि तूँ ठीक ऊई जाए” और तेबुई तेसरा कोढ़ चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","तेबे यीशुए से सावधान कित्तेया, “केसी गे नि बताणा, पर जाई की आपू खे पुरोईतो गे दखा, और आपणे ठीक ऊणे रे बारे रे, जो कुछ मूसे नबीए चढ़ावा ठईराई राखेया, तेस चढ़ा ताकि तिना खे गवाई ओ कि तूँ ठीक ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","पर यीशुए रे इना कामा री चर्चा ओर बी फैली गी और पीड़ा री पीड़ तिना खे सुणने खे और आपणी बमारिया खे ठीक कराने खे कट्ठी ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","यीशु सुनसाण जगा रे जाई की कल्ले जे प्रार्थना करेया करो थे। ");
INSERT INTO bfz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","तेबे एक दिन एड़ा ऊआ कि सेयो उपदेश देणे लगी रे थे तेबे फरीसी और धर्मशास्त्री तेती थे बैठे रे, जो गलील और यहूदिया प्रदेशो रे हर एक गांव ते और यरूशलेम नगरो ते थे आए रे और ठीक करने खे प्रभुए री सामर्थ तिना साथे थी। ");
INSERT INTO bfz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","तेबे कई लोक एक मांणूए खे, जो अदरंगो रा रोगी था, माँजे पाँदे ल्याए और सेयो तेसखे पीतरे लयी जाणे खे और यीशुए सामणे राखणे रा तरीका टोल़ने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","जेबे पीड़ा री बजअ ते सेयो तेसखे पीतरे नि लयी जाई सके, तेबे तिने छतो पाँदे चढ़ी की और खेप्रे टाई की, से माँजे समेत बीचे यीशुए रे सामणे त्वारेया। ");
INSERT INTO bfz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","यीशुए तिना रा विश्वास देखी की तेस अदरंगो रे रोगिए खे बोलेया, “ओ मांणू! तेरे पाप माफ ऊईगे।” ");
INSERT INTO bfz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","तेबे शास्त्री और फरीसी बईस करने लगे, “ये कूणे, जो परमेशरो री निन्दा करने लगी रा? परमेशरो खे छाडी की ओर कुण पाप माफ करी सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","यीशुए तिना रे मनो री गल्ल जाणी की तिना खे बोलेया, “तुसे आपणे मनो रे क्या सोचणे लगी रे? ");
INSERT INTO bfz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ये बोलणा बऊत आसान ए कि तेरे पाप माफ ऊईगे पर ये बोलणा बऊत कठण ए कि आपणा मांजा चकी की चल फिर। ");
INSERT INTO bfz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पर इजी री खातर कि तुसे जाणी लओ कि माणूं रे पुत्रो खे तरतिया पाँदे पाप माफ करने रा बी अक्क ए।” यीशुए तेस अदरंगो रे रोगिए खे बोलेया, “आऊँ ताखे बोलूँआ कि उठ और आपणा मांजा चकी की आपणे कअरो खे चली जा।” ");
INSERT INTO bfz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","से तेबु आपणा मांजा चकी की तिना सामणे उठेया और परमेशरो री तारीफ करदा ऊआ आपणे कअरो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","तेबे सब हैरान ऊईगे और परमेशरो री तारीफ करने लगे और बऊत डरी की बोलणे लगे कि आज आसे नऊखिया गल्ला देखिया। ");
INSERT INTO bfz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","तेबे इजी ते बाद यीशु बारे चली गे और लेवी नाओं रा एक कर लणे वाल़ा करो री चौकिया पाँदे बैठे रा देखेया और तिने तेसखे बोलेया, “मां पीछे आओ और मेरे चेले बणो।” ");
INSERT INTO bfz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","तेबे से सब कुछ छाडी की तिना पीछे चली पड़ेया। ");
INSERT INTO bfz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","तेबे लेविए तिना खे आपणे कअरे एक बड़ा भोज राखेया और कर लणे वाल़ेया री और ओरी लोका री जो तिना साथे रोटी खाणे बैठी रे थे तिना री एक बड़ी पीड़ थी। ");
INSERT INTO bfz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","तेबे फरीसी और शास्त्री, तिना रे चेलेया ते कुड़कुड़ाणे लगे और बोलणे लगे, “तुसे कर लणे वाल़ेया साथे और पापिया साथे कऊँ खाओ-पियोए?” ");
INSERT INTO bfz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीशुए तिना खे जवाब दित्तेया, “बैद पलेया-चंगेया खे नि, पर, बमारा खे जरूरी ए। ");
INSERT INTO bfz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","आऊँ तर्मिया खे नि, पर पापिया रा मन फिराणे खे बुलाणे आयी रा।” ");
INSERT INTO bfz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","तेबे तिने तिना खे बोलेया, “बपतिस्मा देणे वाल़े यूहन्ने रे चेले तो सदा बअरत और प्रार्थना करदे रओए और तिंयाँ ई फरीसी बी, पर तेरे चेले तो खाओ पियो ए।” ");
INSERT INTO bfz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीशुए तिना खे बोलेया, “क्या बराती, जदुओ तक लाड़ा तिना साथे ए, तदुओ तक तिना ते बअरत करवाई सको ए? ");
INSERT INTO bfz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","पर सेयो दिन आऊणे, जेबे लाड़ा बरातिया ते लग करेया जाणा, तेस बखते तिना बअरत करना।” ");
INSERT INTO bfz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","यीशुए तिना खे एक उदारण बोलेया, “कोई बी मांणू नए टाले ते फाड़ी की पुराणे टाले रे टाली नि लगांदा, नई तो नया फटी जाणा और तेस पुराणे साथे मेल पनि खाणा। ");
INSERT INTO bfz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","नया अँगूरा रा रस पुराणे खल्लड़ुआ रे कोई नि परदा, नई तो नया अँगूरा रा रस खल्लड़ुआ खे फाड़ी की बारे निकल़ी जाणा और खल्लड़ुआ रा बी नाश ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","पर जो नया अँगूरा रा रस ओआ, से नये खल्लड़ुआ रे परना चाईयो। ");
INSERT INTO bfz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोई बी मांणू पुराणा अँगूरा रा रस पी की नया नि चांदा, कऊँकि से बोलोआ कि पुराणा ई अच्छा ए।” ");
INSERT INTO bfz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","तेबे आरामो रे दिने यीशु डोरूआ रिये जाणे लगी रे थे और तिना रे चेले सिल्ले तोड़ी-तोड़ी की और मल़ी-मल़ी की खाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तेबे फरीसिया बीचा ते कई जणे बोलणे लगे, “तुसे से काम कऊँ करोए, जो आरामो रे दिने करना ठीक निए?” ");
INSERT INTO bfz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीशुए तिना खे जवाब दित्तेया, “क्या तुसे ये नि पढ़ी राखेया कि जेबे दाऊद और तेसरे साथी पूखे थे, तो, तेबे तिने क्या कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","से कऊँ परमेशरो रे भवनो दे गया? और पेंटा रिया रोटिया खाईया, जबकि बिधानो रे मुताबिक सेयो खाणिया पुरोईता खे छाडी की ओरी खे ठीक नि थिया और तिने आपणे चेलेया खे बी दित्तिया।” ");
INSERT INTO bfz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","तेबे तिने तिना खे बोलेया, “आँऊ माणूं रा पुत्र आरामो रे दिनो रा बी प्रभु ए।” ");
INSERT INTO bfz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","तेबे एड़ा ऊआ कि केसी ओरी आरामो रे दिने सेयो प्रार्थना रे कअरो रे उपदेश देणे लगी रे थे, तेबे तेती एक मांणू आया, जेसरा आथ सूकेया रा था। ");
INSERT INTO bfz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","शास्त्री और फरीसी यीशुए पाँदे दोष लगाणे री ताका रे थे कि देखूँए कि आरामो रे दिने तेसखे ये ठीक करोआ की नयी। ");
INSERT INTO bfz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","पर यीशु तिना रे बिचार जाणो थे, तेबे तिने सूके रे आथो रे मांणूए खे बोलेया, “उठ और बीचे खड़े ऊई जा।” से उठेया और खड़ा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","यीशुए तिना खे बोलेया, “आऊँ तुसा ते पुछूँआ कि बिधानो रे मुताबिक आरामो रे दिने क्या ठीक ए, पला करना या बुरा करना, प्राणो खे बचाणा या नाश करना?” ");
INSERT INTO bfz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","तेबे तिने चऊँ कनारे तिना सबी खे देखी की तेस सूके रे आथो वाल़े मांणूए खे बोलेया, “आपणा आथ आगे कर।” तिने आगे कित्तेया और तेसरा आथ ठीक ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","पर शास्त्री और फरीसी आपणे आपू ते बारे ऊईगे और आपू बीचे बईस करने लगे कि आसे यीशुए साथे क्या करिए? ");
INSERT INTO bfz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","तेबे तिना दिना रे यीशु पाह्ड़ो पाँदे प्रार्थना करने खे निकल़े और सारी रात परमेशरो ते प्रार्थना करदे रये। ");
INSERT INTO bfz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जेबे दिन ऊआ तेबे तिने आपणे खास चेले बुलाई की तिना बीचा ते बारा चूणी ले और तिना खे प्रेरित करी की बोलेया। ");
INSERT INTO bfz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","और सेयो यो ए, शमौन जेसरा नाओं तिने पतरस राखेया, तेसरा पाई अन्द्रियास, याकूब, यूहन्ना, फिलिप्पुस, बरतुल्मै ");
INSERT INTO bfz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ती, थोमा, हलफईसो रा पाऊ याकूब, शमौन जेसखे जेलोतेस बी बोलोए ");
INSERT INTO bfz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकूबो रा पाऊ यहूदा और यहूदा इस्करियोती, जो तिना खे पकड़वाणे वाल़ा बी था। ");
INSERT INTO bfz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","तेबे सेयो तिना साथे उतरी की चौड़ी जगा रे खड़े ऊईगे और तिना रे चेलेया री बड़ी पीड़, और सारे यहूदिया प्रदेश, यरूशलेम नगर, सूर और सैदा नगरो रे समुद्रो रे कनारे रे बऊत लोक, ");
INSERT INTO bfz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","जो तिना री सुणने और आपणी बमारिया ते ठीक ऊणे खे तिना गे आए थे, तेती थे। और दुष्टात्मा रे सताए रे लोक बी ठीक ऊई जाओ थे। ");
INSERT INTO bfz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","तेबे सब यीशुए खे छूणा चाओ थे, कऊँकि तिना ते सामर्थ निकल़ी की सबी खे चंगा करी देयो थी। ");
INSERT INTO bfz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","तेबे यीशुए आपणेया चेलेया खे देखी कि बोलेया, “धन्य ए तुसे, जो सल़ीन ए, कऊँकि परमेशरो रा राज्य तिना रा ईए। ");
INSERT INTO bfz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","धन्य ए तुसे, जो एबु पूखे ए, कऊँकि रजाए जाणे, धन्य ए तुसे, जो एबु रोए, कऊँकि आसणे। ");
INSERT INTO bfz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","धन्य ए तुसे, जेबे माणूं रे पुत्रो री बजअ ते लोका तुसा ते बैर राखणा और तुसे निकयाल़ी देणे, तुसा री निन्दा करनी और तुसा रा नाओं बुरा जाणी की कटी देणा। ");
INSERT INTO bfz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“तेस दिने खुश ऊई की उटकणा, कऊँकि देखो तुसा खे स्वर्गो रे बऊत बड़ा ईनाम मिलणा, तिना रे बाप-दादे, भविष्यबक्तेया साथे बी एड़ा ई करो थे। ");
INSERT INTO bfz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“पर हाय! तुसा खे, जो पैसे वाल़े ए, कऊँकि तुसे आपणे सारे सुख पईले ई पाई चुके रे। ");
INSERT INTO bfz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","पर हाय तुसा खे जो एबु रज्जे रे ए, कऊँकि पूखे ऊणे, हाय तुसा खे, जो एबु आसोए, कऊँकि शोग करना और रोणे। ");
INSERT INTO bfz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","हाय तुसा खे, जेबे सब तुसा खे खरा बोलोए, कऊँकि तिना रे बाप-दादे बी चूठे भविष्यबक्तेया साथे एड़ा ई करो थे। ");
INSERT INTO bfz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“पर आऊँ तुसा सुणने वाल़ेया खे बोलूँआ कि आपणे दुश्मणा साथे प्यार राखो, जो तुसा साथे बैर राखोए, तिना रा पला करो। ");
INSERT INTO bfz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जो तुसा खे स्राप देओ, तिना खे आशीष देओ, जो तुसा रा मजाक करो, तिना खे प्रार्थना करो। ");
INSERT INTO bfz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जो तुसा री खाखा रे थप्पड़ बाओआ, तो तेस कनारो खे दूजी खाख बी करी देओ और जो तेरा दोहर (तोती) छुड़ाई लओआ, तेसखे कुरता लणे ते पनि रोक। ");
INSERT INTO bfz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जो कोई तांते माँगो, तेसखे दे और जो तेरी चीज छुड़ाई लओआ, तेसते माँग नि ");
INSERT INTO bfz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","और जेड़ा तुसे चाओए कि लोक तुसा साथे करो, तुसे बी तिना साथे तेड़ा ई करो। ");
INSERT INTO bfz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“जे तुसे आपू साथे प्यार राखणे वाल़ेया साथे प्यार राखो, तो तुसा री क्या तारीफ? कऊँकि पापी बी आपू साथे प्यार राखणेया वाल़ेया साथे प्यार राखोए। ");
INSERT INTO bfz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","जे तुसे आपू साथे खरा करने वाल़ेया साथे ई खरा करोए, तो तुसा री क्या तारीफ? कऊँकि पापी बी एड़ा ई करोए। ");
INSERT INTO bfz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","जे तुसे तिना खे त्वार देओ, जिना ते फेर लणे री उम्मीद राखोए, तो तुसा री क्या तारीफ? कऊँकि पापी बी पापिया खे त्वार देओए, ताकि तिथणा ई फेर पाओ। ");
INSERT INTO bfz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","बल्कि आपणे दुश्मणा साथे प्यार राखो और तिना रा पला करो, और फेर पाणे री उम्मीद नि राखी की त्वार देओ। तेबे तुसा खे बड़ा फल मिलणा और तुसे परमप्रदान परमेशरो रे बच्चे ठईरने। कऊँकि से तिना पाँदे जो धन्यवाद नि करदे और बुरेया पाँदे बी कृपा करोआ। ");
INSERT INTO bfz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","जेड़ा तुसा रा पिता परमेशर दयालु ए, तेड़े ई तुसे बी दयालु बणो। ");
INSERT INTO bfz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“दोष मत लगाओ, तो तुसा पाँदे बी दोष नि लगाया जाणा, दोषी नि ठराओ, तो तुसे बी दोषी नि ठराए जाणे, माफ करो, तो तुसा खे बी माफ कित्तेया जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","देया करो, तेबे तुसा खे बी दित्तेया जाणा, लोका पूरा नाप दबाई-दबाई की और इलाई-इलाई की और ऊबरदे ऊए तुसा री गोदा रे पाणा, कऊँकि जेस नापो साथे तुसे नापोए, तेसी साथे तुसा खे बी नापेया जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","तेबे यीशुए तिना खे एक उदारण बोलेया, “क्या अन्दा, अन्देया खे बाट दशी सकोआ? क्या दोनो गड्डे रे नि पड़ने। ");
INSERT INTO bfz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","चेला आपणे गुरूओ ते बड़ा नि ऊँदा, पर जो कोई सिद्ध ऊणा, से आपणे गुरूओ जेड़ा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","तूँ कऊँ आपणे पाईए री छोटी-छोटी गल़तिया टोल़ेया, तांदे आपणिया बड़ी-बड़ी गल़तिया नजर कऊँ नि आँऊदिया? ");
INSERT INTO bfz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","जेबे तांदे आपू रे बड़ी-बड़ी गल़तिया ए, तो तूँ आपणे पाईए खे किंयाँ बोली सकेया कि ओ पाई! तूँ गल़त ए? ओ कपटी! पईले आपणी बड़ी-बड़ी गल़तिया देख, तेबेई तो तूँ आपणे पाईए री गल़तिया ठीक टंगो रे देखी की निकयाल़ी सकेया। ");
INSERT INTO bfz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“कोई बी अच्छा डाल़ निए, जो नकम्मा फल़ ल्याओ और ना तो नकम्मा डाल़ ए, जो अच्छा फल़ ल्याओ। ");
INSERT INTO bfz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","हर एक डाल़ आपणे फल़ो साथे पछयाणा जाओआ, कऊँकि लोक जाड़ो ते दाऊगल़े नि तोड़दे और ना कांडेया ते अँगूर। ");
INSERT INTO bfz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","खरा मांणू आपणे खरे मनो रे पण्डारो ते खरिया गल्ला निकयाल़ोआ और बुरा मांणू आपणे बुरे मनो रे पण्डारो ते बुरिया गल्ला निकयाल़ोआ, कऊँकि जो, जेसरे मनो रे परे रा ओआ, तेड़ा ई मुंओ ते निकल़ोआ। ");
INSERT INTO bfz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“जेबे तुसे मेरा कईणा नि मानदे, तो, तेबे कऊँ माखे ओ प्रभु, ओ प्रभु बोलोए? ");
INSERT INTO bfz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जो कोई मांगे आओआ और मेरिया गल्ला सुणी की तिना खे मानोआ, आऊँ तुसा खे बताऊँआ कि से केस जेड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","से तेस मांणूए जेड़ा ए, जिने कअर बणांदे बखते, तरतिया रे डूगी निऊँ खणी की पात्थरा री निऊँ पाई और जेबे बाढ़ आयी तो ताअर तेस कअरो रे लगी, पर से इलाई नि सकी, कऊँकि से पक्का था। ");
INSERT INTO bfz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","पर जो सुणी की नि मानदा, से तेस मांणूए जेड़ा ए, जिने माट्टिया पाँदे बिना निऊँआ रा कअर बणाया और जेबे तेस कअरो पाँदे ताअर लगी, तो से कअर तेबुई टल़ीगा और सत्यानाश ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जेबे यीशु लोका खे इना सबी गल्ला बताई चुके, तेबे सेयो कफरनहूम नगरो रे आए। ");
INSERT INTO bfz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","तेबे केसी सूबेदारो रा दास, जो तेसखे बऊत प्यारा था, बमारिया ते मरने वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","तिने यीशुए रे बारे रे सुणी की कई यहूदिया रे बुजुर्ग तिना गे ये बिनती करने पेजे कि आयी की मेरे दासो खे बचा। ");
INSERT INTO bfz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","सेयो यीशुए गे आयी की तिना ते बड़ी बिनती करी की बोलणे लगे, “से एते जोगा आए कि तुसे तेसखे ठीक करी सको। ");
INSERT INTO bfz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","कऊँकि से म्हारी जातिया खे प्यार करोआ और तिने ई आसा रा प्रार्थना रा कअर बणाई राखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीशु तिना साथे चलणे लगे, जेबे सेयो कअरो रे नेड़े पऊँछणे वाल़े थे, तेबे तिने सूबेदारे तिना खे आपणे कई दोस्ता रे जरिए सन्देशा पेजेया, “ओ प्रभु कष्ट नि कर कऊँकि आऊँ एते जोगा निए कि तुसे मेरे कअरे आयी सको। ");
INSERT INTO bfz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","इजी बजअ ते आऊँ आपू खे एते जोगा पनि समजदा कि तुसा गे आऊँ, पर तुसे आपणे मुंओ तेई बोली देओ, तो से मेरा दास ठीक ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","आऊँ बी पराधीन मांणू ए और सिपाई मेरे आथो रे ए। जेबे एकी खे बोलूँआ, ‘जा,’ तो से जाओआ और दूजे खे बोलूँ, ‘आओ,’ तो से आओआ। आपणे दासा खे बोलूँ, ‘ये कर,’ तो से करोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ये सुणी की यीशु हैरान ऊईगे, तेबे तिने मूँ फेरी की तेसा पीड़ा खे जो तिना पीछे आऊणे लगी री थी बोलेया, “आऊँ तुसा खे सच लगी रा बोलणे कि मैं इस्राएलो रे बी एड़ा विश्वास नि देखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","तेबे जो दोस्त सूबेदारे पेजी राखे थे तिने कअरे जाई की से दास ठीक देखेया। ");
INSERT INTO bfz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","थोड़े दिन बाद सेयो नाईन नाओं रे एक नगरो रे गये और तिना रे चेले और बऊत बड़ी पीड़ तिना साथे चली री थी। ");
INSERT INTO bfz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जेबे सेयो नगरो रे फाटको गे पऊँछे, तेबे लोक एक मुड़दे खे बारे निणे लगी रे थे। जो जवान मरी रा था से आपणी बिदुआ माया रा इकलौता पाऊ था। नगरो रे बऊत सारे लोक तेसा साथे थे। ");
INSERT INTO bfz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","तेसा बिदुआ माया खे देखी की यीशुए खे तरस आया और तेसा खे बोलेया, “रोओ नि।” ");
INSERT INTO bfz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तेबे तिने नेड़े जाई की सीढ़ छुँईं और सीढ़ चकणे वाल़े रूकी गे, तेबे तिने बोलेया, “ओ जवान आऊँ ताखे बोलूँए कि उठ।” ");
INSERT INTO bfz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","तेबे से मुड़दा उठी गा और बोलणे लगेया, तेबे यीशुए से तेसरी माया गे सम्बाल़ी ता। ");
INSERT INTO bfz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","तेबे सब डरी गे और सेयो परमेशरो री तारीफ करदे ऊए बोलणे लगे, “आसा बीचे एक बऊत बड़ा भविष्यबक्ता आईगा रा और परमेशरे आसा लोका पाँदे कृपा दृष्टि करी राखी।” ");
INSERT INTO bfz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","और तिना रे बारे रे ये गल्ल सारे रे यहूदिया प्रदेशो और नेड़े-तेड़े सारे देशो रे फैली गी। ");
INSERT INTO bfz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","यूहन्ने खे तेसरे चेलेया इना सबी गल्ला रा समाचार सुणाया। ");
INSERT INTO bfz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","तेबे यूहन्ने आपणे चेलेया बीचा ते दो जणे बुलाई की यीशुए गे ये पूछणे पेजे, “क्या आऊणे वाल़े तुसे ईए या आसे केसी ओरी री बाट देखिये?” ");
INSERT INTO bfz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","तिने यीशुए गे आयी की बोलेया, “यूहन्ने बपतिस्मे देणे वाल़े आसे ये पूछणे पेजी राखे कि क्या आऊणे वाल़ा तूँ ई ये या आसे केसी ओरी री बाट देखिये?” ");
INSERT INTO bfz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","तेसी बखते तिने बऊत जणे बमार और पीड़ा ते ठीक कित्ते और दुष्टात्मा ते छुड़ाए और बऊत जणेया अन्देया खे आखी दित्तिया। ");
INSERT INTO bfz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","यीशुए तिना खे बोलेया, “जो कुछ तुसे देखेया और सुणेया, जाई की यूहन्ने खे बताओ कि अन्दे देखोए, लंगड़े चलोए, कोढ़ी शुद्ध ऊई जाओए, टऊणे सुणोए और मुड़दे जिऊँदे ऊई जाओए और कंगाल़ा खे सुसमाचार सुणाया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","धन्य ए सेयो, जो मेरी बजअ ते आपणा विश्वास नि छाडदे।” ");
INSERT INTO bfz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","जेबे यूहन्ने रे पेजे रे चेले चली गे, तेबे यीशु यूहन्ने रे बारे रे लोका खे बोलणे लगे, “तुसे जंगल़ो रे क्या देखणे गये थे? क्या अवा साथे ईलदे ऊए काओ जेड़े नगल़ो खे? ");
INSERT INTO bfz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","तो तुसे तेबे क्या देखणे गये थे? क्या नरम टाले पईने रे मांणूए खे? देखो जो भड़किले टाले पईनोए और सुख-विलासो रे रओए, सेयो राजभवनो रे रओए। ");
INSERT INTO bfz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","तो तेबे क्या देखणे गए थे? क्या केसी भविष्यबक्ते खे? आ, आऊँ तुसा खे बोलूँआ कि भविष्यबक्ते ते बी बड़े खे। ");
INSERT INTO bfz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","से येई, जेसरे बारे रे लिखी राखेया कि, “देख, आऊँ आपणे दूतो खे तांते आगे-आगे पेजुँआ, जेस तांते आगे जाई की बाट ठीक करनी। ");
INSERT INTO bfz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“आऊँ तुसा खे बोलूँआ कि जो जवाणसा ते जम्मी रे तिना बीचा ते यूहन्ने ते बड़ा कोई निए पर जो परमेशरो रे राज्य रे छोटे ते बी छोटा ए, से तेसते बी बड़ा ए।” ");
INSERT INTO bfz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","तेबे सबी आम मांणूए सुणी की और कर लणे वाल़ेया बी यूहन्ने रा बपतिस्मा लयी की परमेशरो खे सच्चा मानी ला। ");
INSERT INTO bfz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","पर फरीसिये और धर्मशास्त्री तेसते बपतिस्मा ना लयी की परमेशरो री इच्छा आपणे बारे रे टाल़ी ती। ");
INSERT INTO bfz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","यीशुए फेर बोलेया, “आऊँ आजकाल के लोका री उपमा किजी साथे करुँ? ");
INSERT INTO bfz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","सेयो तिना बच्चेया जेड़े ए, जो बजारो रे बैठी की एकी-दूजे खे आक्का पाई की बोलोए, ‘आसे तुसा खे बांसल़ी बजाई, पर तुसे नि नाचे; आसे शोग कित्तेया, पर तुसे छाती नि बजाई।’ ");
INSERT INTO bfz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","कऊँकि यूहन्ना बपतिस्मा देणे वाल़ा न तो रोटी खांदा आया और ना अँगूरा रा रस पींदा आया और तुसे बोलोए कि तेसरे दुष्टात्मा ए? ");
INSERT INTO bfz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","पर आँऊ माणूं रा पुत्र खांदा-पींदा ऊआ आया और तुसे बोलोए कि, ‘देखो, पेटू और पियक्कड़ मांणू कर लणे वाल़ेया रा और पापिया रा दोस्त ए।’ ");
INSERT INTO bfz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पर ज्ञान आपणी ल्वादा ते सच्चा ठराई राखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","तेबे किने फरीसिये तिना ते बिनती कित्ती कि मां साथे रोटी खाओ; तेबे सेयो तेसरे कअरे जाई की रोटी खाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","तेस नगरो री एक पापी जवाणस ये जाणी की कि यीशु एक फरीसियो रे कअरे रोटी खाणे बैठी रा, संगमरमरो रे पांडे (सुराई) रे इत्र ल्याई ");
INSERT INTO bfz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","और तेबे तिना रे पैरा गे पीछे खड़ी ऊई की रोणे लगी और आपणे आसूआ साथे तिना रे पैर तोए और आपणे सिरो रे बाल़ो साथे साफ कित्ते और तिना रे पैर बार-बार चूम्मी की तिना पाँदे इत्र मल़ेया। ");
INSERT INTO bfz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ये देखी की से फरीसी, जिने यीशु बुलाए थे, आपणे मनो रे सोचणे लगेया, “जे ये भविष्यबक्ता ऊँदा तो जाणी लंदा कि ये जो जवाणस एसखे छूणे लगी री, ये कूणे और केड़ी जवाणस ए? कऊँकि से तो पापी ए?” ");
INSERT INTO bfz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ये जाणी की यीशुए बोलेया, “ओ शमौन मां ताखे कुछ बोलणा,” शमौने बोलेया, “ओ गुरू बोलो।” ");
INSERT INTO bfz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","तेबे यीशुए बोलेया, “केसी साऊकारो रे दो देणदार थे, एक पाँज सौ चाँदिए रे सिक्के और दूजा पंजा चाँदिए रे सिक्केया रा देणदार था। ");
INSERT INTO bfz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","जेबे तिना गे वापस करने खे कुछ नि था, तो तेबे तिने दूँईं जणेया रा कर्ज माफ करी ता, तो बता तिना बीचा ते केस तेसखे जादा प्यार करना।” ");
INSERT INTO bfz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","शमौने जवाब दित्तेया, “मेरी समजा ते तेस, जेसरा तिने जादा कर्ज माफ कित्तेया।” यीशुए तेसखे बोलेया, “तैं ठीक उतर देई राखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","तेबे तेसा जवाणसा कनारे फिरी की तिने शमौनो खे बोलेया, “क्या तूँ एसा जवाणसा खे देखणे लगी रा? आऊँ तेरे कअरे आया, पर तैं माखे पैर तोणे खे पाणी नि दित्तेया पर एसे मेरे पैर आपणे आसूआ साथे तोए और आपणे बाल़ा साथे साफ कित्ते। ");
INSERT INTO bfz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तैं मेरे गल़े लगी की मेरा स्वागत नि कित्तेया, पर जदुओ ते आऊँ आयी रा, तदुओ ते एसे मेरे पैर चूमणे नि छाडी राखे। ");
INSERT INTO bfz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तैं मेरे सिरो रे तेल नि मल़ेया, पर एसे मेरे पैरो रे इत्र मल़ेया। ");
INSERT INTO bfz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","तेबेई तो आऊँ ताखे बोलूँआ कि एसा रे जो बी पाप थे, सेयो माफ ऊईगे कऊँकि एसे बऊत प्यार कित्तेया, पर जेसरा थोड़ा माफ ऊआ, से थोड़ा ई प्यार करोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","तेबे यीशुए तेसा जवाणसा खे बोलेया, “तेरे पाप माफ ऊईगे।” ");
INSERT INTO bfz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","तेबे जो लोक तिना साथे रोटी खाणे बैठी रे थे, सेयो आपणे-आपणे मनो रे सोचणे लगे, “ये कूणे जो पाप बी माफ करी देओआ? जेते खे सिर्फ परमेशर ई माफ करी सकोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पर तिने तेसा जवाणसा खे बोलेया, “तेरे विश्वासे तूँ बचाई ली, बेफिकर ऊई की चली जा।” ");
INSERT INTO bfz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","इजी ते बाद सेयो नगर-नगर और गांव-गांव रे प्रचार करदे ऊए और परमेशरो रे राज्य रा सुसमाचार सुणांदे ऊए, फिरने लगे, और सेयो बारा चेले तिना साथे थे, ");
INSERT INTO bfz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","और कुछ जवाणसा बी जो दुष्टात्मा ते और बमारिया ते छुड़ाई राखिया थिया, और तिना बीचा ते यो ए-मरियम मगदलिनी, जेसा ते सात दुष्टात्मा निकाल़ी राखिया थिया ");
INSERT INTO bfz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","और हेरोदेस राजे रे पण्डारी खोजे री लाड़ी योअन्ना और सूसन्नाह और मुखती सारिया जवाणसा, जो आपणे पैसे साथे यीशु और तिना रे चेलेया री मताद करो थिया। ");
INSERT INTO bfz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","जेबे बड़ी पीड़ कट्ठी ऊई और जगा-जगा रे लोक तिना गे आओ थे, तेबे तिने उदारणो रे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“एक बेजा बाणे वाल़ा बेजा बाणे निकल़ेया और बांदे बखते कुछ दाँणे बाटा रे छूटे और सर्गो रे पंछिए सेयो चूगी ले। ");
INSERT INTO bfz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","कुछ सापड़ी पाँदे छूटे और जम्मे पर सिनक ना मिलणे री बजअ ते सूकी गे। ");
INSERT INTO bfz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कुछ बिऊ जाड़ो बीचे छूटे और जाड़े साथे-साथे बढ़ी की सेयो दबाई ते। ");
INSERT INTO bfz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","कुछ अच्छी जमीना पाँदे छूटे और जम्मी की सौ गुणा फल ल्याए।” ये बोली की तिने जोरे की बोलेया, “जो समजी सकोआ से तिजी खे त्यानो साथे सुणो और मानी बी लओ।” ");
INSERT INTO bfz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","तिना रे चेलेया तिना ते पूछेया, “ये उदारण क्या ए?” ");
INSERT INTO bfz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","यीशुए बोलेया, “तुसा खे परमेशरो रे राज्य रे पेतो री समज दित्ती रिये, पर ओरी खे उदारणो रे सुणाया जाओआ,तेबेई, “सेयो देखदे ऊए पनि देखदे, और सुणदे ऊए पनि समजदे। ");
INSERT INTO bfz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“उदारणो रा मतलब तो ए: दाँणे परमेशरो रा वचन ए। ");
INSERT INTO bfz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","बाटा रे कनारले सेयो दाँणे ए, जिने सुणेया पर शैतान तिना रे मनो चकी की लई जाओआ केथी एड़ा नि ओ कि सेयो विश्वास करी की उद्धार पाओ। ");
INSERT INTO bfz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","सापड़ी पाँदले सेयो ए कि जेबे सुणोए, तेबे खुश ओए, पर जड़ ना पकड़ने री बजअ ते थोड़ी देर तक विश्वास करोए और परीक्षा रे बखते पटकी जाओए। ");
INSERT INTO bfz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जो जाड़ो रे छूटे सेयो ये कि जो सुणो तो आए, पर चिन्ता, पैसा, जिन्दगिया रे सुख-बिलासा रे फसी जाओए और तिना रा फल नि पाकदा। ");
INSERT INTO bfz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","पर अच्छी जमीना रे सेयो ए, जो वचन सुणी की खरे और खरे मनो ते सम्बाल़ी कि राखोए और सब्रा साथे फल लयाओए। ");
INSERT INTO bfz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“कोई बी दिऊए खे पांडे साथे नि टकदा और ना माँजे निठे राखदा, पर फटिया पाँदे राखोआ, ताकि पीतरे आऊणे वाल़ेया खे प्रयासा ओ। ");
INSERT INTO bfz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","जो कुछ बी छिपेया राए, से सामणे आऊणा और जो कुछ गुप्त ए, से जाणेया जाणा और सामणे बी आऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","इजी री खातर चौकस रओ कि तुसे किंयाँ सुणोए? कऊँकि जेसगे आया, तेसखे देणा और जेसगे आए नि, तेसते से बी लयी लणा, जेतेखे से आपणा समजोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","यीशुए री आम्मा और पाई तिना गे आए, पर पीड़ा री बजअ ते तिना खे मिली नि सके। ");
INSERT INTO bfz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","तेबे तिना खे बोलेया, “तुसा री आम्मा और पाई और बईण बारे खड़ी रे और तुसा खे मिलणा चाओए।” ");
INSERT INTO bfz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","यीशुए तिना खे जवाबो रे बोलेया, “तिना खे बोलो कि मेरी आम्मा और पाई तो यो ई ये, जो परमेशरो रा वचन सुणोए और मानोए।” ");
INSERT INTO bfz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","तेबे एक दिन यीशु और तिना रे चेले किस्तिया रे चढ़े और तिने तिना खे बोलेया, “आओ, गलीली समुद्रो ते पार चलूँए।” तेबे तिने किस्ती खोली ती। ");
INSERT INTO bfz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","पर जेबे किस्ती चली री थी, तेबे यीशु सयी गे और समुद्रो रे तूफान आया और किस्तिया रे पाणी फरने लगेया और सेयो मुसीबता रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","तेबे चेलेया नेड़े आयी की यीशु जगाए और बोलेया, “ओ स्वामी! स्वामी! आसे डूबणे वाल़े ए।” तेबे यीशु उठी की तूफानो खे, पाणिए खे और लईरा खे बकणे लगे और सेयो रूकी गे और चैन ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","तेबे यीशुए चेलेया खे बोलेया, “तुसा रा विश्वास केयी था?” पर सेयो डरी गे और हैरान ऊई की आपू बीचे बोलणे लगे, “ये कूणे, जो तूफान और पाणिए खे आज्ञा देओआ और सेयो एसरी आज्ञा खे मानोए?” ");
INSERT INTO bfz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","तेबे सेयो गिरासेनियो रे देशो रे पऊँछे जो गलीलो ते पार, सामणे ए। ");
INSERT INTO bfz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","जेबे यीशु कनारे पाँदे उतरे, तेबे तिना खे तेस नगरो रा एक मांणू मिलेया, जेसरे दुष्टात्मा थी और कई दिना ते ना टाले पईनो था और ना कअरे जाओ था, पर कब्रा रे रओ था। ");
INSERT INTO bfz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","से यीशुए खे देखी की चींगेया और तिना सामणे रूड़ी की जोरे की बोलणे लगेया, “ओ परमप्रदान परमेशरो रे पुत्र यीशु! माखे तांते क्या काम? मेरी तांते बिनती ये कि माखे कष्ट नि दे।” ");
INSERT INTO bfz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","कऊँकि यीशु तेस मांणूए रे जो अशुद्ध आत्मा थी तेसा खे निकल़ने री आज्ञा लगी रे थे देणे, कऊँकि से बार-बार तेसखे कष्ट देओ थी। लोक तेसखे साँगल़ो और बेड़िये की बानी की राखो थे, पर से तिना खे तोड़ी की बणो खे नठी जाओ था और दुष्टात्मा तेसरे बैठी गी थी। ");
INSERT INTO bfz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीशुए तेसते पूछेया कि तेरा नाओं क्या ए? तिने बोलेया सेना। कऊँकि मुखती सारिया दुष्टात्मा तेसरे बैठी गी थिया। ");
INSERT INTO bfz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","और तिने यीशुए ते प्रार्थना कित्ती कि माखे डूगे गड्डे रे सेटणे री आज्ञा नि दे। ");
INSERT INTO bfz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","तेती पाह्ड़ो पाँदे सूंअरो रा एक चूण्ड चरने लगी रा था, तो तेबे तिने तिना ते बिनती कित्ती, “आसा खे एते चूण्डो रे बैठणे दे।” तो तिने सेयो जाणे दित्तिया। ");
INSERT INTO bfz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तेबे दुष्टात्मा तेस मांणूए ते निकल़ी की सूंअरो रे चली गिया और से चूण्ड काअड़ी पाँदो ते छवाल़ लयी की समुद्रो रे डूबी की मरी गा। ");
INSERT INTO bfz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","गवाल़े जो ऊआ था तेस देखी की नठीगे। और नगरो और गांव रे जाई की सारा आल सुणाया। ");
INSERT INTO bfz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","तेबे लोक जो ऊआ था, तेस देखणे खे आए, तेबे तिने से मांणू, जेसरे दुष्टात्मा थिया, से यीशुए रे पैरा पाँदे पड़े रा और टाले पईनी की ओशा रे बैठे रा देखेया और डरी गे। ");
INSERT INTO bfz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","देखणे वाल़ेया तिना गे बताया कि से दुष्टात्मा रा सताया रा मांणू किंयाँ ठीक ऊआ। ");
INSERT INTO bfz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तेबे गिरासेनियो रे ओरले-पोरले लोके यीशुए ते बिनती कित्ती कि एथा ते चली जा, कऊँकि सेयो बऊत डरी गे थे, तेबे सेयो किस्तिया रे बैठी की वापस ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जेस मांणूए ते दुष्टात्मा निकल़ी गी थी, से तिना ते बिनती करने लगेया कि माखे आपू साथे आऊणे दे, पर यीशुए तेसखे बिदा करदे ऊए बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“आपणे कअरो खे चली जा और लोका गे बता कि परमेशरे तेरिया तंईं कितणे बड़े काम करी राखे।” तेबे से सारे नगरो रे जाई की प्रचार करने लगेया कि यीशुए मेरिया तंईं कितणे बड़े काम करी राखे। ");
INSERT INTO bfz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जेबे यीशु वापस ऊणे लगी रे थे, तेबे लोक तिना साथे खुशिया साथे मिले, कऊँकि सेयो सब जणे तिना खे न्याल़ो थे। ");
INSERT INTO bfz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","तेबे याईर नाओं रा एक मांणू, जो प्रार्थना रे कअरो रा अधिकारी था, यीशुए गे आया और तिना रे पैरो पाँदे पड़ी की प्रार्थना करने लगेया कि मेरे कअरे चलो। ");
INSERT INTO bfz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","कऊँकि तेसरी बारा साला री इकलौती बेटी मरने वाल़ी थी; जेबे सेयो जाणे लगी रे थे, तेबे लोक तिना पाँदे रूड़ी जाओ थे। ");
INSERT INTO bfz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","तेबे एक जवाणस जेसा खे बारा साला ते खून बइणे री बमारी थी और से आपणी सारी सम्पति बैदा खे देई चुकी थी पर तेबे बी से केसी रे आथो की ठीक नि ऊई। ");
INSERT INTO bfz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","तेबे तेसे पीछे ते आयी की यीशुए रे टाले छूँएं और तेबुई तेसा रा खून बईणा बन्द ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","तेबे यीशुए बोलेया, “आऊँ किने छूँयां?” जेबे सब मुकरी गे, तेबे पतरसे और तेसरे साथिये बोलेया, “ओ स्वामी! तुसे तो पीड़े जिक्की ते और ये तो तुसा पाँदे ई पड़ी गी।” ");
INSERT INTO bfz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","पर यीशुए बोलेया, “आऊँ किने तो छुँईं राखेया।” कऊँकि माखे पता लगी गा रा कि मांते सामर्थ निकल़ी री। ");
INSERT INTO bfz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जेबे जवाणसे देखेया कि आऊँ छिपी नि सकदी, तेबे से बऊत डरदे-डरदे आयी और तिना रे पैरा पाँदे पड़ी की तेसे सबी लोका सामणे बताया कि मैं किजी री बजअ ते तुसे छूँएं और किंयाँ फटाफट ठीक ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","यीशुए तेसा खे बोलेया, “बेटिये! तेरे विश्वासे तूँ बचाईती, बेफिकर ऊई की चली जा।” ");
INSERT INTO bfz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","सेयो ये बोलणे ई लगी रे थे कि किने प्रार्थना रे कअरो रे सरदारो रे कअरो ते आयी की बोलेया, “तेरी बेटी तो मरी गी और गुरूओ खे कष्ट नि दे।” ");
INSERT INTO bfz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","यीशुए ये सुणी की बोलेया, “डर नि; बस विश्वास राख तो से बची जाणी।” ");
INSERT INTO bfz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","सरदारो रे कअरे जाई की यीशुए पतरस, यूहन्ना याकूब और तेसा बेटिया रे माए-बाओ खे छाडी की ओर कोई बी पीतरे नि आऊणे दित्ते। ");
INSERT INTO bfz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सब तेसा खे रोणे-पीटणे लगी रे थे, पर यीशुए बोलेया, “रोओ नि; कऊँकि ये मरी नि रई, पर सयी री।” ");
INSERT INTO bfz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","सेयो ये जाणी की कि ये तो मरी गी री, तिना रा मजाक ऊड़ाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पर यीशुए तेसा रा आथ पकड़ेया और बोलेया, “ओ बेटिये उठ!” ");
INSERT INTO bfz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","तेबे तेसा रे प्राण आईगे और तेबे से फटाफट उठी गी। तेबे यीशुए तिना खे आज्ञा दित्ती कि एसा खे कुछ खाणे खे देयो। ");
INSERT INTO bfz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","तेसा रे माए-बाओ हैरान ऊईगे, पर यीशुए तिना खे सावधान करी की बोलेया, “एती जो कुछ ऊआ, से केसी गे नि बताणा।” ");
INSERT INTO bfz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","तेबे यीशुए बारा चेलेया खे बुलाई की तिना खे सारिया दुष्टात्मा पाँदे और बमारिया खे दूर करने री सामर्थ और अक्क दित्तेया ");
INSERT INTO bfz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","और तिना खे परमेशरो रे राज्य रा प्रचार करने और बमारा खे ठीक करने पेजे। ");
INSERT INTO bfz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","तेबे यीशुए तिना खे बोलेया, “बाटा खे कुछ नि लणा, ना डण्डा, ना चोल़ी, ना रोटी, ना पैसे और ना दो कुरते। ");
INSERT INTO bfz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जेस केसी रे बी कअरे तुसे जाओ, तेथी रओ और तेथा तेई बिदा ओ। ");
INSERT INTO bfz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","जो कोई तुसा खे मानोगा नि, तेस नगरो ते निकल़दे ऊए आपणे पैरा री तूड़ तेथी चाड़ी देओ, ताकि तिना पाँदे गवाई ओ।” ");
INSERT INTO bfz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","तेबे सेयो निकल़ी की गांव-गांव रे सुसमाचार सुणांदे ऊए और हर केथी लोका खे ठीक करदे ऊए कुमदे-फिरदे रये। ");
INSERT INTO bfz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","तेबे देशो रे चौथाईया रा राजा हेरोदेस ये सब सुणी की कबराईगा, कऊँकि बऊत जणे बोलेया, “यूहन्ना बपतिस्मा देणे वाल़ा मरे रेया बीचा ते जिऊँदा ऊईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","कई जणेया ये कि एलिय्याह दिशेया। कईए बोलेया कि पुराणे भविष्यबक्तेया बीचा ते कोई जिऊँदा ऊईगा रा। ");
INSERT INTO bfz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","हेरोदेसे बोलेया, “यूहन्ने रा तो मैं सिर बडाया, एबे ये कूणे, जेसरे बारे रे एड़िया गल्ला सुणूँआ?” तेबे तिने से देखणा चाया। ");
INSERT INTO bfz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","तेबे प्रेरिते वापस आयी की जो कुछ तिने कित्तेया था, तिना गे बताई ता, तेबे सेयो तिना खे लग करी की बैतसैदा नाओं रे एक नगरो खे लयी गा। ");
INSERT INTO bfz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ये जाणी की पीड़ तेस पीछे चली पड़ी और से खुशिया ते तिना साथे मिलेया और तिना साथे परमेशरो रे राज्य री गल्ला करने लगेया और जो ठीक ऊणा चाओ थे सेयो ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जेबे साँज ऊणे वाल़ी थी, तेबे बारा चेलेया तिना गे आयी की बोलेया, “पीड़ा खे बिदा करो, ताकि चऊँ कनारे रे गांव और बस्तिया रे जाई की रओ और रोटिया रा उपाय करो, कऊँकि आसे एती सुणसाण जगा रे ए।” ");
INSERT INTO bfz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","यीशुए तिना खे बोलेया, “तुसेई तिना खे खाणे खे देयो।” चेलेया बोलेया, “आसा गे तो पाँज रोटिया और दो मछलिया खे छाडी की ओर कुछ निए, पर आ, जे आसे जाई की इना सबी लोका खे रोटी खरीदी लईए, तो ऊई सकोआ।” सेयो लोक पाँज ह्जार मर्दा रे तकरीबन थे। ");
INSERT INTO bfz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","तेबे यीशुए चेलेया खे बोलेया, “तिना खे पंजा-पंजा करी की बांईठी रे बठयाल़ी देओ।” ");
INSERT INTO bfz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","तिने तेड़ा ई कित्तेया और सब बठयाल़ी ते। ");
INSERT INTO bfz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तेबे यीशुए सेयो पाँज रोटिया और दो मछलिया लईया और स्वर्गो रे कनारे देखी की धन्यवाद कित्तेया और रोटिया तोड़ी-तोड़ी की चेलेया खे देंदे गये कि लोका खे देओ। ");
INSERT INTO bfz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","तेबे सब खाई की रज्जी गे और बचे रे टुकड़ेया रिया बारा टोकरिया परी की चकिया। ");
INSERT INTO bfz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","जेबे यीशु कल्ले जे प्रार्थना करने लगी रे थे और चेले तिना साथे थे, तेबे तिने चेलेया ते पूछेया, “लोक माखे क्या बोलोए?” ");
INSERT INTO bfz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","तिने जवाब दित्तेया, “यूहन्ना बपतिस्मा देणे वाल़ा, और कोई-कोई एलिय्याह और कोई-कोई ये बोलोए कि पुराणे भविष्यबक्तेया बीचा ते कोई जिऊँदा ऊईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","यीशुए तिना ते पूछेया, “पर तुसे माखे क्या बोलोए?” पतरसे जवाब दित्तेया, “परमेशरो रा मसीह।” ");
INSERT INTO bfz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तेबे यीशुए तिना खे सावधान करी की बोलेया, “ये केसी गे नि बोलणा।” ");
INSERT INTO bfz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","तेबे तिने बोलेया, “मां माणूं रे पुत्रो खे जरूरी ए कि आँऊ बऊत दु:ख उठाऊँ, बुजुर्ग, बड़े पुरोईत और शास्त्री माखे तुच्छ जाणी की काई देओ और आँऊ तीजे दिने जिऊँदा ऊई जाऊँ।” ");
INSERT INTO bfz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","तिने सबी खे बोलेया, “जे कोई मां पीछे आऊणा चाओ, तो आपणे आपू खे ना करी की और हर रोज आपणा क्रूस चकी की मां पीछे आयी जाया करो। ");
INSERT INTO bfz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","कऊँकि जो कोई आपणा प्राण बचाणा चाओगा, तेस से खोणा, पर जो कोई मां पीछे आपणे प्राण खोओगा, तेस ई से बचाणा। ");
INSERT INTO bfz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","जे मांणूए खे सारी दुनिया मिली जाओ और आपणे प्राण नि रओ या तिजी रा नुकशाण ओ, तो तेसखे क्या फाईदा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जो कोई मांते और मेरी गल्ला ते शर्माओगा, माणूं रा पुत्र बी, जेबे आपणी, आपणे पिते री और पवित्र स्वर्गदूता री महिमा साथे आऊणा, तो से बी तेसते शर्माणा। ");
INSERT INTO bfz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","आऊँ तुसा खे सच लगी रा बोलणे कि जो एती खड़ी रे, तिना बीचा ते कई एड़े ए कि जदुओ तक परमेशरो रा राज्य नि देखी लओगे, तदुओ तक नि मरने।” ");
INSERT INTO bfz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","इना गल्ला ते कोई आठ दिन बाद यीशु, पतरस, याकूब और यूहन्ने खे लयी की प्रार्थना करने खे पाह्ड़ो पाँदे गये। ");
INSERT INTO bfz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","जेबे सेयो प्रार्थना करने ई लगी रे थे, तो तिना रे मुंओ री शक्ल बदली गी और तिना रे टाले सफेद ऊई की चमकणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","तेबे देखो, मूसा और एलिय्याह, यो दोनो मर्द यीशुए साथे गल्ला करने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","यो महिमा साथे दिखे और यीशुए रे मरने री चर्चा करने लगी रे थे, जो यरूशलेमो रे ऊणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस और तेसरे साथी नींजा रे थे और जेबे ठीक टंगो रे ओश आयी, तेबे यीशुए री महिमा और तिना दूँईं मर्दा खे, जो तिना साथे खड़ी रे थे, देखेया। ");
INSERT INTO bfz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","जेबे सेयो यीशुए गे ते जाणे लगे, तेबे पतरसे यीशुए खे बोलेया, “ओ मालक! आसा रा एती रणा ठीक ए, तो आसे तीन तम्बू बणाऊँए, एक तुसा खे, एक मूसे खे और एक एलिय्याह खे।” तेसखे पता नि था कि से क्या बोलणे लगी रा। ");
INSERT INTO bfz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","से ये बोलणे ई लगी रा था कि एक बादल़ तिना पाँदे छाईगा और जेबे सेयो तेस बादल़ो ते किरने लगे, तो डरी गे। ");
INSERT INTO bfz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","तेबे तेस बादल़ो ते परमेशरो री ये आवाज आई, “ये मेरा पुत्र और मेरा चूणेया राए, एसरी सुणो।” ");
INSERT INTO bfz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ये आवाज ऊँदे ई यीशु तिना खे कल्ले मिले और सेयो चुप रये और तिना री कोई गल्ल तिना दिना रे किने नि बोली। ");
INSERT INTO bfz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","और दूजे दिने जेबे यीशु पाह्ड़ो ते उतरे, तेबे एक बऊत बड़ी पीड़ तिना खे आयी की मिली। ");
INSERT INTO bfz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","देखो, पीड़ा बीचा ते मांणूए चींगी की बोलेया, “ओ गुरू! आऊँ तुसा ते बिनती करूँआ कि मेरे पाऊए पाँदे कृपा करो, कऊँकि से मेरा एकलौता ए। ");
INSERT INTO bfz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","देख, एक दुष्टात्मा तेसखे पकड़ोई, ये एकदम चींगणे लगी जाओआ और से एसखे एड़ा मरोड़ोई कि एसरे मुंओ ते जगुड़ निकल़ने लगी जाओआ और एसखे माण्डी की, मुश्किला साथे छाडोई। ");
INSERT INTO bfz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","मैं तुसा रे चेलेया ते बिनती कित्ती कि दुष्टात्मा खे निकयाल़ी देओ, पर सेयो नि निकयाल़ी सके।” ");
INSERT INTO bfz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","यीशुए जवाब दित्तेया, “ओ अविश्वास करने वाल़ेयो और टीठ लोको! मां कदुओ तक तुसा साथे रणा? कदुओ तक तुसा खे सईन करुँ? तेसखे ओरे ल्याओ मांगे।” ");
INSERT INTO bfz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","से आऊणे ई लगी रा था कि दुष्टात्मे से पटकी की मकरेड़ेया, पर यीशु दुष्टात्मा खे बके और पाऊए खे ठीक करी की तेसरे पिते गे सम्बाल़ी ता। ");
INSERT INTO bfz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","तेबे सारे लोक परमेशरो री महान् सामर्था ते हैरान ऊईगे। पर जेबे सब लोक तिना सबी कामा ते जो से करो था, अचम्बा करने लगी रे थे, तो तिने आपणे चेलेया खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“चौकस रओ और यो गल्ला तुसे याद राखो, कऊँकि आँऊ माणूं रा पुत्र मांणूआ रे आथो रे पकड़वाऊणे वाल़ा ए।” ");
INSERT INTO bfz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पर सेयो एसा गल्ला खे नि समजो थे और ये तिना ते छिपी री रई, ताकि तिना खे तिजी रे बारे रे पता नि लगो और सेयो एसा गल्ला रे बारे रे पूछणे ते तिना ते डरो थे। ");
INSERT INTO bfz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","तेबे तिना बीचे ये बईस ऊणे लगी कि आसा बीचा ते बड़ा कुण ए? ");
INSERT INTO bfz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","पर यीशुए खे तिना रे मनो री गल्ल पता लगी गी, तेबे तिने एक बाल़क लयी की आपू गे खड़ा कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","तेबे तिना खे बोलेया, “जो कोई मेरे नाओं ते एस बाल़को खे मानोआ, से माखे मानोआ, जो माखे मानोआ, से मेरे पेजणे वाल़े खे मानोआ, कऊँकि जो कोई तुसा बीचा ते छोटे ते छोटा ए, सेई बड़ा ए।” ");
INSERT INTO bfz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","तेबे यूहन्ने बोलेया, “ओ मालक! आसे एक मांणू तुसा रे नाओं ते दुष्टात्मा खे निकयाल़दा ऊआ देखेया और आसे तेसखे एड़ा करने ते ना कित्ती। कऊँकि से तेरा चेला नि था।” ");
INSERT INTO bfz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","यीशुए तिना खे बोलेया, “तेसखे ना नि करो, कऊँकि जो तुसा रे बिरोदो रे निए, से तुसा साथे ए।” ");
INSERT INTO bfz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जेबे तिना रे ऊबे चकणे रे दिन पूरे ऊणे वाल़े थे, तेबे तिने यरूशलेमो खे जाणे रे बारे रे पक्का बिचार करी ला। ");
INSERT INTO bfz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","तेबे तिने आपू ते आगे दूत पेजे। सेयो सामरिया रे गांव रे गये, ताकि तिना खे जगा त्यार करो। ");
INSERT INTO bfz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पर तिने लोके सेयो उतरने नि दित्ते, कऊँकि सेयो यरूशलेमो खे जाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ये देखी की तिना रे चेले याकूब और यूहन्ने बोलेया, “ओ प्रभु! क्या तुसे चाओए कि आसे आज्ञा देऊँ कि सर्गो ते आग पड़ी की तिना खे स्वा करी देओ।” ");
INSERT INTO bfz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","पर यीशु मुड़ी की तिना खे बकणे लगे और बोलेया, “तुसे नि जाणदे कि तुसे केड़ी आत्मा रे ए? ");
INSERT INTO bfz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","कऊँकि माणूं रा पुत्र लोका रे प्राणा खे नाश करने नि, बल्कि बचाणे खे आयी रा।” तेबे सेयो केसी ओरी रे नगरो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","जेबे सेयो बाटा रिये चलणे लगी रे थे, तेबे किने तिना खे बोलेया, “जेती-जेती तुसे जाओगे, मां तुसा पीछे चली पड़ना।” ");
INSERT INTO bfz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीशुए तेसखे बोलेया, “गीदड़िया रे डवार और सर्गो रे पंछिया रे बसेरे ओए, पर मां माणूं रे पुत्रो खे सिर राखणे बी आपणा कअर निए।” ");
INSERT INTO bfz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","यीशुए दूजे खे बोलेया, “मां पीछे आयी जा।” तिने बोलेया, “ओ प्रभु, पईले माखे जाणे दे, कि आऊँ आपणे पिते खे दबाई आऊँआ। तेबे तां पीछे चली पड़ुँगा।” ");
INSERT INTO bfz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","यीशुए तेसखे बोलेया, “जो आत्मिक रूपो रे मरे रे ए तिना खे आपणे मुड़दे दबाणे दे, पर तूँ जाई की परमेशरो रे राज्य रा सुसमाचार सुणा।” ");
INSERT INTO bfz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","एकी ओरी बी बोलेया, “ओ प्रभु! मां तुसा पीछे आयी जाणा, पर पईले माखे जाणे दे, ताकि आऊँ आपणे कअरो वाल़ेया ते बिदा लऊँ।” ");
INSERT INTO bfz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीशुए तेसखे बोलेया, “जो कोई आपणा आथ अल़ो पाँदे राखी की पीछे देखोआ, से परमेशरो रे राज्य जोगा निए।” ");
INSERT INTO bfz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","इना गल्ला ते बाद प्रभुए सत्तर और चेले ओर नियुक्त कित्ते और जेती-जेती नगर और जगा रे सेयो आपू जाणे वाल़े थे, तेती तिने सेयो दो-दो करी की आपू ते आगे पेजे ");
INSERT INTO bfz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","और यीशुए तिना खे बोलेया, “पाक्के रे डोरू तो बऊत ए, पर मजूरदार कम ए इजी री खातर डोरूआ रे मालको ते प्रार्थना करो कि सेयो आपणे डोरूआ बडाणे खे मजूरदार पेजो। ");
INSERT INTO bfz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जाओ; देखो, आऊँ तुसा खे पेडा जेड़े तिना लोका बीचे पेजुँआ जो भेड़िए जेड़े खतरनाक ए। ");
INSERT INTO bfz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","तेबेई तो ना बटुआ, ना चोल़ी, ना जोड़े लणे और ना ई बाटा रे केसी खे नमस्ते करनी। ");
INSERT INTO bfz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जेस केसी रे कअरो रे जाओ पईले बोलो, ‘एस कअरो रा कल्याण ओ।’ ");
INSERT INTO bfz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","जे तेती कोई कल्याणो जोगा ओगा, तो तुसा रा कल्याण तेसखे लगणा, नई तो तुसा गे वापस आयी जाणा ");
INSERT INTO bfz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","और तेसी कअरो रे रओ और जो कुछ तुसा खे खाणे-पीणे खे मिलो, खाओ-पीओ, कऊँकि मजूरदारो खे तिना री मजदूरी मिलणी चाईयो; और कअरे-कअरे जाई की नि कूमणा ");
INSERT INTO bfz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“और जेते नगरो रे जाओ और तेथो रे लोक तुसा खे मानो, तो जो सेयो तुसा रे सामणे राखो, सेई खाओ। ");
INSERT INTO bfz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","तेथो रे बमारा खे ठीक करो और तिना खे बोलो कि परमेशरो रा राज्य तुसा रे नेड़े आयी पऊँछी रा। ");
INSERT INTO bfz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","पर जेस नगरो रे जाओ और तेथो रे लोक तुसा खे नि मानो, तो तिना रे बजारो रे जाई की बोलो ");
INSERT INTO bfz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘तुसा रे नगरो री तूड़ बी जो म्हारे पैरो रे लगी री, आसे तुसा सामणे चाड़ी देऊँए, तेबे बी ये जाणी लो कि परमेशरो रा राज्य तुसा रे नेड़े आयी पऊँछी रा।’ ");
INSERT INTO bfz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","आऊँ तुसा खे बोलूँआ कि तेस दिने, तेस नगरो री दशा ते, सदोम नगरो री दशा जादा सईणे जोगी ऊणी। ");
INSERT INTO bfz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“हाय खुराजीन! हाय बैतसैदा! जो सामर्था रे काम तुसा रे कित्ते, जे सेयो सूर और सैदा रे नगरा ऊँदे, तो टाट टखी की और स्वाई बीचे बैठी की सेयो कदका मन फिराई देंदे। ");
INSERT INTO bfz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","पर न्याय रे दिना रे तुसा री दशा ते, सूर और सैदा री दशा जादा सईणे जोगी ऊणी। ");
INSERT INTO bfz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ओ कफरनहूम! क्या तूँ स्वर्गो तक ऊच्चा करेया जाणा? तूँ तो नरको तक थाले करेया जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","जो तुसा री सुणोआ, से मेरी सुणोआ और जो तुसा खे तुच्छ जाणोआ, से माखे तुच्छ जाणोआ और जो माखे तुच्छ जाणोआ, से मेरे पेजणे वाल़े खे तुच्छ जाणोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","सेयो सत्तर चेले खुश ऊई की आयी की फेर बोलणे लगे, “ओ प्रभु! तुसा रे नाओं ते दुष्टात्मा बी आसा रे वशो रे ए।” ");
INSERT INTO bfz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","यीशुए तिना खे बोलेया, “आऊँ शैतानो खे बिजल़िया जेड़ा, स्वर्गो ते ऊतरदा ऊआ देखणे लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","देखो; मैं तुसा खे सापो और बिच्छुआ खे केसणे रा और तुसा रे दुश्मण शैतानो री सारी सामर्था पाँदे अक्क देई राखेया और केसी बी चीजा ते तुसा खे नुकशाण नि ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","तेबे बी इजी ते खुश नि ओ कि दुष्टात्मा तुसा रे वशो रे, पर इजी ते खुश ओ कि तुसा रे नाओं स्वर्गो रे लिखे रे।” ");
INSERT INTO bfz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","तेसी बखते यीशु पवित्र आत्मा रे खुश ऊई की बोलणे लगे, “ओ पिता! स्वर्ग और तरतिया रे प्रभु! आऊँ तुसा रा धन्यवाद करूँआ कि तुसे यो गल्ला ज्ञानी और समजदारा ते लकोई रिया राखिया और बाल़का गे बताईया। आ,ओ पिता! कऊँकि तुसा खे येई खरा लगेया। ");
INSERT INTO bfz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","मेरे पिते मांगे सब कुछ सम्बाल़ी ता रा, और कोई नि जाणदा कि पुत्र कूणे? बस पिता और पिता कूणे? ये बी कोई नि जाणदा। बस पुत्र और जेस पाँदे पुत्र प्रगट करना चाओ।” ");
INSERT INTO bfz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तेबे तिने चेलेया री तरफा खे फिरी की बोलेया, “धन्य ए सेयो आखी, जो इना गल्ला खे जो तुसे देखोए, सेयो बी देखोईया। ");
INSERT INTO bfz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","कऊँकि आऊँ तुसा खे बोलूँआ कि बऊत सारे भविष्यबक्ते और राजे चाया कि जो गल्ला तुसे देखोए, देखो, पर देखी नि सके और जो गल्ला तुसे सुणोए, सुणो, पर सुणी नि सके।” ");
INSERT INTO bfz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","एक दिन जेबे यीशु लोका खे उपदेश देणे लगी रे थे तेबे एक धर्मशास्त्री उठेया और ये बोली की तिना री परीक्षा करने लगेया, “ओ गुरू! अनन्त जीवनो रा बारस ऊणे खे आऊँ क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीशुए तेसखे बोलेया, “मूसे रा बिधानो रे क्या लिखी राखेया? तूँ तिजी रा बखाण किंयाँ करेया?” ");
INSERT INTO bfz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","तिने जवाब दित्तेया, “तूँ प्रभु आपणे परमेशरो साथे आपणे पूरे मन, पूरे प्राण, पूरी शक्ति और पूरिया अक्ला साथे प्यार राख और आपणे पड़ोसिये खे आपू जेड़ा प्यार राख।” ");
INSERT INTO bfz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","यीशुए तेसखे बोलेया, “तैं ठीक बोलेया, येई कर, तो तां अनन्त जिन्दगी पाणी।” ");
INSERT INTO bfz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पर तिने आपणे आपू खे तर्मी ऊणे री तंईं पूछेया, “तो मेरा पड़ोसी कूणे?” ");
INSERT INTO bfz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीशुए बोलेया, “एक मांणू यरूशलेमो ते यरीहो नगरो खे जाणे लगी रा था, तेबे डाकूए से पकड़ेया और तेसरे टाले खुलाई ते और तेसखे कुटी की और अदमुआ करी की चली गे। ");
INSERT INTO bfz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","तेबे एड़ा ऊआ कि तेसा ई बाटा ते एक यहूदी पुरोईत जाणे लगी रा था, पर तेसखे देखी की बिना मताद कित्ते ग्लयान करी की चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ईंयां ई एक लेवी जो मन्दरो रे काम करोआ तिसिये आया, से बी तेसखे देखी की बिना मताद कित्ते ग्लयान करी की चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","पर सामरी प्रदेशो रा एक यात्री तिसिये आया। जेबे तेसरी नजर तेस काईल मांणूए पाँदे पड़ी, तेबे तेसखे देखी की तेस सामरिये खे तेस पाँदे तरस आईगा। ");
INSERT INTO bfz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","तेबे तिने तेसगे आयी की, जेती बूड़ी री थी, तेती तेल और दवाई लगाई की और पट्टिया बानिया और आपणी सवांरिया पाँदे चढ़ाई की संरायी खे लयी गा और तेसरी सेवा कित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दूजे दिने आयी की तिने दो चाँदिए रे सिक्के निकयाल़ी की संरायी रे मालको खे दित्ते और बोलेया, ‘एसरी सेवा करनी और जो कुछ तेरा ओर लगणा से जेबे आऊँ वापस आऊणा, तेबे ताखे देई देऊँगा।’ ");
INSERT INTO bfz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","एबे बताओ कि जो डाकूआ रे गेड़े रे आईगा था, इना तिऊँ बीचा ते तेसरा पड़ोसी कूणे?” ");
INSERT INTO bfz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","तिने बोलेया से, “जिने तेस पाँदे दया कित्ती।” यीशुए तेसखे बोलेया, “जा तूँ बी एड़ा ई कर।” ");
INSERT INTO bfz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","यीशु और तिना रे चेले सफर करदे ऊए एक गांव रे पऊँछे, जेती मार्था नाओं री एक जवाणसे सेयो आपणे कअरे बुलाए। ");
INSERT INTO bfz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","मरियम नाओं री तेसा री एक बईण थी, से यीशुए रे पैरा गे बैठी की तिना रा उपदेश सुणने लगी री थी। ");
INSERT INTO bfz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पर मार्था कअरो रा काम करी-करी की थकी गी और तिना गे आयी की बोलणे लगी, “ओ प्रभु! क्या तुसा खे पता निए कि मेरी बईणे आऊँ कअरो रा काम करने खे कल्ली छाडी ती री? तो एसा खे बोलो कि मेरी मताद कर।” ");
INSERT INTO bfz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","यीशुए तेसा खे बोलेया, “मार्था ओ मार्था! तूँ बऊत गल्ला री चिन्ता करेई और कबराएई। ");
INSERT INTO bfz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","पर एक गल्ल जरूर ए और से उत्तम इस्सा मरियमे चूणी ला रा, जो तेसा ते छुड़ाया नि जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","तेबे यीशु एकी जगा रे प्रार्थना लगी रे थे करने और जेबे सेयो प्रार्थना करी चुके, तेबे तिना रे चेलेया बीचा ते एकी जणे तिना खे बोलेया, “ओ प्रभु! जिंयाँ यूहन्ने आपणे चेलेया खे प्रार्थना करना सिखाया, तिंयाँ ई तुसे बी आसा खे सिखाई देओ।” ");
INSERT INTO bfz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","यीशुए तिना खे बोलेया, “जेबे तुसे प्रार्थना करो, तो बोलो; “ओ पिता तुसा रा नाओं पवित्र मानेया जाओ, तुसा रा राज्य आओ। ");
INSERT INTO bfz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","आसा रे पूरे दिनो री रोटी, हर दिन आसा खे देया करो। ");
INSERT INTO bfz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","म्हारे पाप माफ करो, कऊँकि आसे बी आपणे हर एक अपराधिया खे माफ करूँए और आसा खे परीक्षा रे नि ल्याओ।” ");
INSERT INTO bfz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","यीशुए तिना खे बोलेया, “तुसा बीचा ते कूणे कि तेसरा एक दोस्त ओ और तुसे आदी राती जाई की तेसखे बोलो कि ओ दोस्त! माखे तीन रोटिया दे। ");
INSERT INTO bfz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","कऊँकि एक यात्री मांगे आयी रा और तेसखे देणे खे मांगे कुछ निए ");
INSERT INTO bfz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","और से पीतरो ते जवाब देओ कि माखे तंग नि कर, एबे तो द्वार बंद ऊईगे रे और मेरे बाल़क मांगे बछाऊणे रे ए, तेबेई तो आऊँ ताखे उठी की देई नि सकदा। ");
INSERT INTO bfz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","आऊँ तुसा खे बोलूँआ कि जे तेसरा दोस्त ऊई की बी, तेसखे उठी की ना करो, तेबे बी तेसखे शर्म छाडी की मांगणे री बजअ ते, जितणी तेसखे जरूरत ए, तिथणा उठी की देणा। ");
INSERT INTO bfz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","आऊँ तुसा खे बोलूँआ कि तुसा री जो बी जरूरत ए से परमेशरो ते माँगो और परमेशरो ते पाणे री उम्मीद बी राखो। ");
INSERT INTO bfz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","कऊँकि जो कोई माँगोआ, तेसखे मिलोआ, और जो टोल़ोआ, से पाओआ और जो खटखटाओआ, तेसखे खोलेया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","तुसा बीचा ते कुण एड़ा पिता ए कि तेसरा पाऊ तेसते रोटी माँगो और से तेसखे पात्थर देओगा या मछली माँगो और से मछलिया रे बदले साप देओ। ");
INSERT INTO bfz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","या अण्डा माँगो और तेसखे बिच्छु देओ? ");
INSERT INTO bfz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","तो तेबे तुसे बुरे ऊई की आपणे बच्चेया खे खरी चीजा देणा जाणोए, तो तुसा रे स्वर्गिय पिते आपणे मांगणे वाल़ेया खे पवित्र आत्मा कऊँ नि देणी?” ");
INSERT INTO bfz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","तेबे तिने एक गूँगी दुष्टात्मा निकयाल़ी, जेबे दुष्टात्मा निकल़ी गी, तेबे गूँगा बोलणे लगेया और लोक हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पर तिना बीचा ते कई जणे बोलेया, “ये तो दुष्टात्मा रे सरदार शैतानो री मतादा ते दुष्टात्मा खे निकयाल़ोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","तेबे कईए तिना खे परखणे खे सर्गो रा एक चिह्न् मांगेया। ");
INSERT INTO bfz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पर यीशुए तिना रे मनो री गल्ल जाणी की तिना खे बोलेया, “जेस-जेस राज्य रे फूट ओई, से राज्य ऊजड़ी जाओआ। और जेस कअरो रे फूट ओई, से नाश ऊई जाओआ। ");
INSERT INTO bfz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","और जे शैतान आपणा ई बिरोदी ऊई जाओगा, तो तेसरा राज्य किंयाँ बणे रा रई सकोआ? कऊँकि तुसे मेरे बारे रे तो बोलोए कि शैतानो री मतादा ते दुष्टात्मा खे निकयाल़ोआ। ");
INSERT INTO bfz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","जे आऊँ शैतानो री मतादा ते दुष्टात्मा खे निकयाल़ूँआ, तो तुसा री ल्वादा केसरी मतादा ते निकयाल़ोए? इजी री खातर तिना ई तुसा रा न्याय चुकाणा। ");
INSERT INTO bfz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पर जे आऊँ परमेशरो री सामर्था ते दुष्टात्मा खे निकयाल़ूँआ, तो परमेशरो रा राज्य तुसा रे नेड़े आयी पऊँछी रा ");
INSERT INTO bfz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","जेबे तागतबर मांणू अथियार बानी की आपणे कअरो री रखवाल़ी करोआ, तो तेबे तेसरे कअरो री सारी सम्पति बची री रओई। ");
INSERT INTO bfz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पर जेबे कोई तेसते बी बलवान, तेस पाँदे चढ़ाई करी की तेसा जीती लओआ, तेबे तेसरे सेयो अथियार जिना पाँदे तेसखे विश्वास था, छुड़ाई लओए और तेसरी सम्पति लूटी की बांडी देओआ। ");
INSERT INTO bfz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जो मां साथे निए, से मेरे खलाफ ए और जो मां साथे कट्ठा नि करदा, से बखेरोआ। ");
INSERT INTO bfz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“जेबे दुष्टात्मा मांणूए ते निकल़ी जाओई, तेबे से राम करने खे सूकी जगा टोल़ो ई और जेबे मिलदी नि, तेबे बोलोई कि मां आपणे तेस कअरो रेई, जेथा आऊँ निकल़ी थी, वापस चली जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","और तेबे तेसा खे आयी की से, साफ-सुथरा और सजाया रा मिलोआ। ");
INSERT INTO bfz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तेबे से आपू साथे सात ओर दुष्टात्मा खे ल्याओई और सेयो तेथी बैठी जाओईया और तेस मांणूए री दशा पईलकी दशा ते बी खराब ऊई जाओई।” ");
INSERT INTO bfz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","जेबे यीशु इना गल्ला करने ई लगी रे थे, तेबे पीड़ा बीचा ते एक जवाणसे जोरे की बोलेया, “धन्य से माए जेसे ताखे जन्म देई राखेया और सेयो स्तन, जो तैं चूसी राखे।” ");
INSERT INTO bfz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","यीशुए बोलेया, “आ; पर धन्य ए सेयो, जो परमेशरो रा वचन सुणोए और मानोए।” ");
INSERT INTO bfz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जेबे बड़ी पीड़ कट्ठी ऊईगी, तेबे यीशु बोलणे लगे, “एस जुगो रे लोक बुरे ए, सेयो चिह्न् टोल़ोए, पर योना रे चिह्नो खे छाडी की तिना खे ओर कोई चिह्न नि देणा। ");
INSERT INTO bfz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जेड़ा योना नीनवे रे लोका खे चिह्न् ऊआ, तिंयाँ ई माणूं रा पुत्र बी एस जुगो रे लोका खे ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","दख्खणो री राणी न्याय रे दिनो रे एस बखतो रे लोका साथे उठणी और सेयो दोषी ठराणे, कऊँकि से सुलेमानो रा ज्ञान सुणने खे तरतिया रे दूजे कनारे पाँदा ते आयी थी और देखो एती तो से ए, जो सुलेमानो ते बी बड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","नीनवे रे लोक न्याय रे दिनो दे, एस बखतो रे लोका साथे खड़े ऊई की, सेयो दोषी ठराणे, कऊँकि तिने योना रा प्रचार सुणी की मन फेरेया और देखो एती से ए, जो नीनवे ते बी बड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कोई बी मांणू दिऊए खे टोकरूए निठे या पैमाने ते थाले नि राखदा, पर फटिया पाँदे राखोआ, ताकि पीतरे आऊणे वाल़ेया खे प्रयासा ओ। ");
INSERT INTO bfz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तेरे शरीरो रा दिऊआ, तेरी आखी ए, तेबेई तो जेबे तेरी आखी साफ ए, तो तेरे सारे शरीरो रे बी प्रयासा ऊणा; पर जे से बुरी ए, तो तेरे शरीरो रे बी न्हेरा ए। ");
INSERT INTO bfz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","इजी री खातर चौकस रणा कि जो सफाई तांदे आए, से मईली नि ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","तेबेई तो जे तेरा सारा शरीर साफ ए और तीजी रा कोई बी इस्सा मईला निए, तो तेबे सारी जगा रे एड़ा प्रयासा ऊणा, जेड़ा तेस बखते ओआ, जेबे दिऊआ आपणी चमका ते ताखे प्रयासा देओआ।” ");
INSERT INTO bfz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","जेबे यीशु इना गल्ला करने लगी रे थे, तेबे एक फरीसिये तिना ते बिनती कित्ती कि मेरे कअरे रोटी खाओ और तेबे सेयो पीतरे जाई की रोटी खाणे बैठे। ");
INSERT INTO bfz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी ये देखी की हैरान ऊईगा कि ये रोटी खाणे ते पईले नाया नि। ");
INSERT INTO bfz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","यीशुए तेसखे बोलेया, “ओ फरीसियो! तुसे तिना कटोरे और थाल़िया जेड़े ए, जिना खे पाँदा-पाँदा ते तो मांजी लओए, पर पितरे तिना रे गन्दगी परी री रओई। ");
INSERT INTO bfz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ओ मूर्खो! जिने बारला इस्सा बणाई राखेया, क्या तिने पितरला इस्सा नि बणाया? ");
INSERT INTO bfz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","पर आ; पितरलिया चीजा खे दान करी देओ, तो देखो, सब कुछ तुसा खे शुद्ध ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“पर ओ फरीसियो! तुसा पाँदे हाय! तुसे पदीने, सुदाब और सब पांती-पांती रे साग पातो रा दसुआ पाअग देओए, पर न्याय और परमेशरो रे प्यारो खे टाल़ी देओए, तुसा खे चाईयो था कि इना खे बी करदे रंदे और तिना खे पनि छाडदे। ");
INSERT INTO bfz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ओ फरीसियो तुसा पाँदे हाय! तुसे प्रार्थना रे कअरो रे खास-खास आसण और बजारो रे नमस्ते चाओए। ");
INSERT INTO bfz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","तुसा खे हाय! कऊँकि तुसे तिना छिपी री कब्रा जेड़े ए, जिना पाँदे लोक चलोए, पर जाणदे नि।” ");
INSERT INTO bfz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","तेबे एक धर्मशास्त्री तिना खे जवाब दित्तेया, “ओ गुरू! इना गल्ला करने ते तुसे म्हारी निन्दा लगी रे करने।” ");
INSERT INTO bfz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","यीशुए बोलेया, “ओ धर्मशास्त्री! तुसा पाँदे हाय! तुसे लोका खे एड़े-एड़े कड़े नियम मानणे खे मजबूर करो थे जिना खे मानणा तिना बऊत कठण ए। पर आपू तिना नियमा खे मानणे री बी कोशिश तक नि करदे। ");
INSERT INTO bfz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","हाय तुसा खे! तुसे तिना भविष्यबक्तेया रिया कब्रा बणाओए, जो तुसा रे बाप-दादेया काये थे। ");
INSERT INTO bfz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","तो तुसे गवा ए और आपणे बाप-दादेया रे कामो ते सईमत ए। कऊँकि तिने सेयो काये और तुसे तिना खे कब्रा बणाओए। ");
INSERT INTO bfz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","तेबेई तो परमेशरो री बुद्धिए बी बोलेया कि मां तिना गे भविष्यबक्ता और प्रेरित पेजणे और तिना, तिना बीचा ते कितणे जणे काणे और कितणे जणे सताणे। ");
INSERT INTO bfz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ताकि जितणे बी भविष्यबक्ते रा खून दुनिया री शुरूआता ते बाह्यी राखेया, सबी रा लेखा एस जुगो रे लोका ते लया जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","“हाबिलो री अत्या ते लयी की जकरयाहो री अत्या तक, जो बेदिया ते लयी की मन्दरो रे बीचा तक काया, आऊँ तुसा खे सच बोलूँआ कि तीजी रा लेखा एस बखतो रे लोका ते लया जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","हाय तुसा धर्मशास्त्री खे! कऊँकि तुसे ज्ञानो री कुँजी लयी तो लयी, तुसे ना तो आपू ई तेती जांदे और ना ई तिदे जाणे वाल़ेया खे जाणे देंदे।” ");
INSERT INTO bfz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जेबे यीशु तेथा ते निकल़े, तेबे शास्त्री और फरीसी बऊत पीछे पड़ी गे और तिना खे छेड़ने लगे कि सेयो मुखती सारिया गल्ला बताओ। ");
INSERT INTO bfz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","और तिना री ताका रे लगे रये कि तिना रे मुंओ री केसी गल्ला खे पकड़िए। ");
INSERT INTO bfz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","तदुओ की जेबे ह्जारा री पीड़ लगी गी, एथो तक कि एकी-दूजे पाँदे पड़ने लगी रे थे। तेबे यीशु सबी ते पईले आपणे चेलेया खे बोलणे लगे, “फरीसिये रे कपटी सजेड़े ते चौकस रणा। ");
INSERT INTO bfz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","कुछ बी टकेया रा निए, जो खोलेया नि जाणा और ना कुछ छिपेया राए, जो जाणी नि सकदे। ");
INSERT INTO bfz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","तेबेई तो, जो कुछ तुसे न्हेरे रे बोली राखेया, से सामणे सुणेया जाणा और जो तुसे कोठरिया रे आपणे कानो रे खसफस करी की बोली राखेया, से छतो पाँदो ते बोलेया करो। ");
INSERT INTO bfz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“आऊँ तुसा खे, जो मेरे दोस्त ए, बोलूँआ कि जो शरीरो खे काओए, पर तीजी ते पीछे ओर कुछ नि करी सकदे, तिना ते नि डरो। ");
INSERT INTO bfz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","आऊँ तुसा खे बताऊँआ कि केस ते डरना चाईयो, घात करने ते बाद, जेसखे नरको रे सेटणे रा अक्क ए, तेसते ई डरो; बल्कि आऊँ तुसा खे बोलूँआ कि तेसते ई डरो। ");
INSERT INTO bfz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","दो पैसे रिया पाँज चिड़िया बिकोईया? तेबे बी परमेशर तिना बीचा ते एकी खे पनि पुलदा। ");
INSERT INTO bfz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","बल्कि तुसा रे सिरो रे बाल़ बी सारे गिणे रे ए, तो डरो नि, तुसे बऊत चिड़िया ते बढ़ी की ए। ");
INSERT INTO bfz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“आऊँ तुसा खे बोलूँआ कि जो कोई मांणूआ सामणे माखे मानी लओगा, तेबे से बी मां माणूं रे पुत्रो परमेशरो रे स्वर्गदूता सामणे मानी लणा। ");
INSERT INTO bfz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पर जो मांणूआ सामणे माखे ना करो, तेसखे परमेशरो रे स्वर्गदूता सामणे ना ऊणी। ");
INSERT INTO bfz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","जो कोई माणूं रे पुत्रो रे खलाफ कोई गल्ल बोलोगा, तेसरा से अपराध माफ ऊई जाणा, पर जो कोई पवित्र आत्मा री निन्दा करोगा, तेसरा से अपराध माफ नि ऊणा ");
INSERT INTO bfz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","जेबे लोक तुसा खे प्रार्थना रे कअरो रे, हाकिम और अधिकारिए सामणे लयी जाओगे, तो चिन्ता नि करना कि आसे किंयाँ और क्या जवाब देईए। ");
INSERT INTO bfz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","कऊँकि पवित्र आत्मा तुसा गे तेसी बखते बताई देणा कि क्या बोलणा चाईयो।” ");
INSERT INTO bfz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","तेबे पीड़ा बीचा ते एकी जणे यीशुए खे बोलेया, “ओ गुरू! मेरे पाईयो खे बोलो कि पिते री सम्पति माखे बांडी दे।” ");
INSERT INTO bfz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","यीशुए तेसखे बोलेया, “ओ मांणू! आऊँ किने तुसा रा न्यायी और बांडणे वाल़ा बणाई राखेया?” ");
INSERT INTO bfz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","तेबे तिने तिना खे बोलेया, “चौकस रओ; और हर प्रकारा रे लोबो ते आपू खे बचाई की राखो, कऊँकि केसी री बी जिन्दगी, तेसरी सम्पतिया ते बड़ी नि ऊँदी।” ");
INSERT INTO bfz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","यीशुए तिना खे एक उदारण बोलेया, “एक धनवानो री जमीना रे मुखती फसल ऊई। ");
INSERT INTO bfz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","तेबे से आपणे मनो रे सोचणे लगेया कि आऊँ क्या करुँ? कऊँकि मांगे तो जगा निए, जेती आपणी फसल बगैरा राखूँ। ");
INSERT INTO bfz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","तेबे तिने सोचेया कि मां आपणे पण्डार तोड़ी की ओर बड़े पण्डार बनाणे और तेती मां आपणी सारी फसल और सम्पति राखणी ");
INSERT INTO bfz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","और तिजी ते बाद आपणे प्राणो खे बोलणा कि ओ प्राण! ताखे कई साला तक मुखती सम्पति राखी ती री; चैन कर, खा-पी सुखो साथे रओ। ");
INSERT INTO bfz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पर परमेशरे तेसखे बोलेया, ‘ओ मूर्ख! आज की राती ई तेरी मौत ऊई जाणी, तेबे जो कुछ तैं कट्ठा करी राखेया, से केसरा ऊणा?’ ");
INSERT INTO bfz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","एड़ा ई से मांणू बीए, जो आपू खे पैसा कट्ठा करी राखेया, पर परमेशरो री नजरा रे अमीर निए।” ");
INSERT INTO bfz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","तेबे यीशुए आपणे चेलेया खे बोलेया, “तेबेई तो आऊँ तुसा खे बोलूँआ कि आपणी जिन्दगिया रे बारे रे ये चिन्ता नि करो कि आसे क्या खाऊँगे, ना आपणे शरीरो रे बारे रे कि क्या पईनुँगे। ");
INSERT INTO bfz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","कऊँकि रोटिया ते जिन्दगी और टालेया ते शरीर केथी जादा किमती ए। ");
INSERT INTO bfz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कावा पाँदे त्यान देओ, सेयो ना बांदे, ना बाडदे, ना तिना रे पण्डार ए और ना पेढ़ू ऊँदा, तेबे बी परमेशर तिना खे पाल़ोआ, तुसा री कीमत पंछिया ते केथी बढ़ी की ए। ");
INSERT INTO bfz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","तुसा बीचा ते एड़ा कुण ए, जो चिन्ता करी की आपणिया जिन्दगिया री एक कअड़ी बी बढ़ाई सकोआ? ");
INSERT INTO bfz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","तेबेई तो जे तुसे सबी ते छोटा काम पनि करी सकदे, तो ओरी बड़ी गल्ला खे चिन्ता करी क्या फाईदा? ");
INSERT INTO bfz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","बांके जंगल़ी फूला पाँदे त्यान करो कि सेयो किंयाँ बड़ोए, सेयो ना तो मईणत करदे, ना आपू खे टाले बणाओए, तेबे बी आऊँ तुसा खे बोलूँआ कि राजा सुलेमान बी आपणे सारे एशो-आरामो रे बी, तिना बीचा ते केसी एकी जेड़े बी टाले नि पईने रा था। ");
INSERT INTO bfz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","तेबेई तो जेबे परमेशर मैदानो रे काओ खे, जो आज आए, और काल आगी बीचे फूकी देणा, तो जो तिदे बी एड़े बांके फूल खिलाओआ, तो ओ कम विश्वास करने वाल़ेयो! तुसा खे तेस इना ते बढ़ी की बांके टाले कऊँ नि पनयाणे? ");
INSERT INTO bfz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","और तुसे एसा गल्ला री टोल़ा रे नि रओ कि आसे क्या खाऊँगे, क्या पिऊँगे और ना शक करो। ");
INSERT INTO bfz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","कऊँकि दुनिया री जातिया इना सबी चीजा री टोल़ा रे रओईया और तुसा रा पिता जाणोआ कि तुसा खे इना सबी चीजा री जरूरत ए। ");
INSERT INTO bfz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","पर परमेशरो रे राज्य री टोल़ा रे रओ, तो यो सब चीजा बी तुसा खे मिली जाणिया। ");
INSERT INTO bfz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ओ छोटे चूण्ड, डर नि; कऊँकि तुसा रे पिता परमेशरो खे ये अच्छा लगेया कि तुसा खे राज्य देऊँ। ");
INSERT INTO bfz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","आपणी सम्पति बेची की दान करी देओ और आपू खे एड़े बटुए बणाओ, जो पुराणे नि ऊँदे, मतलब-स्वर्गो रे एड़ा धन कट्ठा करो, जो कटदा नि और तीजी रे नेड़े चोर नि जांदा और कीड़ा नि खांदा। ");
INSERT INTO bfz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","कऊँकि जेती तुसा रा धन ए, तेती तुसा रा मन बी लगेया रा रणा। ");
INSERT INTO bfz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“तुसा परमेशरो रा काम करने खे सदा त्यार रओ और मसीह रे आऊणे रे बखते और तेसखे ग्रहण करने खे एड़े त्यार रओ जेड़े दिऊए बल़दे दिऊए रओ। ");
INSERT INTO bfz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","मेरे वापस आऊणे खे तिना दासा जेड़े त्यार रओ, जो आपणे स्वामिए खे न्याल़दे रओए कि से ब्याओ ते कदी जे आऊणा कि जेबे से आओ और द्वार खटखटाओ तो तेसखे फटाफट खोलेया जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","धन्य ए सेयो दास, जिना खे स्वामी आयी की जागदे ऊए देखोए, आऊँ तुसा खे सच बोलूँआ कि स्वामिए एड़े टाले पईनणे जेड़े दास पईनोए और तेस दासा खे बठयाल़ी की से रोटी खाणे खे देणी जो तिने ब्याओ ते प्रिया ल्याई राखेया। ");
INSERT INTO bfz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","जे सेयो तिना खे राती रे दूजे या तीजे पईरे आयी की जागदा ऊआ पाओ, तो सेयो दास धन्य ए। ");
INSERT INTO bfz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","पर तुसे जाणी लओ कि जे कअरो रा मालक जाणदा कि चोर कदी जे आऊणा, तो जागदा रंदा और आपणे कअरे चोरी नि ऊणे देंदा। ");
INSERT INTO bfz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तेबेई तुसे बी त्यार रओ, कऊँकि जेसा कअड़िया रे बारे रे तुसे सोचदे पनि, तेसी कअड़िया आँऊ माणूं रा पुत्र आयी जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तेबे पतरसे बोलेया, “ओ प्रभु! क्या तुसे ये उदारण आसा खेई बोलणे लगी रे या सबी खे।” ");
INSERT INTO bfz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","यीशुए बोलेया, “एक विश्वासो जोगा और अक्लमंद पण्डारी एड़ा ए: जेसखे कअरो रा मालक दूजे दासा पाँदे निगरानी और बखतो पाँदे रोटी देणे खे जिम्मेवारी देओआ। तिजी ते बाद से परदेशो खे चली जाओआ। ");
INSERT INTO bfz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","धन्य ए से दास, जेसखे तेसरा मालक आयी की एड़ा ई करदा ऊआ पाओ। ");
INSERT INTO bfz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","आऊँ तुसा खे सच लगी रा बोलणे कि तेस से आपणी सारी सम्पतिया पाँदे अक्कदार ठराणा। ");
INSERT INTO bfz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पर जे से दास सोचणे लगो कि मेरा मालक आऊणे रे देर करने लगी रा और दास-दासिया खे कुटणे-फानणे और खाणे-पीणे और पियक्कड़ ऊणे लगो ");
INSERT INTO bfz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तो तेस दासो रा मालक एड़े दिने आऊणा, जेबे से तेसखे न्याल़दा ई ना ओ और एड़िया कअड़िया दे, जेतेखे से नि जाणदा ओ। तेबे तेस तेसखे बऊत दण्ड देणा और तेसरा इस्सा कपटिया साथे ठराणा। ");
INSERT INTO bfz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","से दास, जो आपणे मालको री इच्छा जाणोआ पर त्यार नि रया और ना तेसरी इच्छा रे मुताबिक चलेया, तो तेस बऊत मार खाणी। ");
INSERT INTO bfz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पर जो ना जाणी की मार खाणे जोगा काम करोगा, तेस थोड़ी मार खाणी, तेबेई तो जेसखे बऊत देई राखेया, तेसते बऊत मांगेया जाणा और जेसगे बऊत सम्बाल़ी राखेया, तेसते बऊत लया जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“आऊँ तरतिया पाँदे आग लगाणे आयी रा और ये चाऊँआ कि एबु ई सुलगी जांदी। ");
INSERT INTO bfz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मां तो एक दुःखदाई बपतिस्मा लणा ए और जदुओ तक से नि ऊई लो, तदुओ तक आऊँ केड़िया दशा रे रणा? ");
INSERT INTO bfz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","क्या तुसे एड़ा समजोए कि आऊँ तरतिया पाँदे मेल-जोल करने आयी रा? आऊँ बोलूँआ कि ना, बल्कि लग करने आयी रा। ");
INSERT INTO bfz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","कऊँकि आजो ते एकी कअरे पाँज जणे बिरोदी रणे। तीना, दूँईं ते और दूँईं तीना ते। ");
INSERT INTO bfz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","पिते पाऊए ते और पाऊए, पिते ते, माया बेटिया ते और बेटिया माया ते, सासुआ बऊआ ते और बऊआ सासुआ ते बिरोद राखणा।” ");
INSERT INTO bfz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","यीशुए पीड़ा खे बी बोलेया, “जेबे बादल़ो खे पच्छमा ते उड़दे ऊए देखोए, तेबे फटाफट बोलोए कि बर्खा ऊणी और एड़ा ई ओआ। ");
INSERT INTO bfz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","और जेबे अवा दक्खणो खे चलदी ऊई देखोए, तो बोलोए कि लू चलणी और एड़ा ई ओआ। ");
INSERT INTO bfz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ओ कपटियो! तुसे तरती और सर्गो रे रूप-रंगो रे भेद करी सकोए, पर एस जुगो रे बारे रे कऊँ भेद करना नि जाणदे? ");
INSERT INTO bfz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“तुसे आपू ई न्याय कऊँ नि करी लंदे कि अच्छा क्या ए? ");
INSERT INTO bfz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जेबे तूँ आपणे दुश्मणो साथे हाकिमो गे जाणे लगी रा, तो बाटा रेई तेसते छुटणे री कोशिश करी लो, एड़ा नि ओ कि से ताखे न्यायियो गे खिंजी की ल्याओ और न्यायी ताखे सिपाईया गे देयो और सिपाई ताखे जेला रे पाई देओ। ");
INSERT INTO bfz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","आऊँ तुसा खे बोलूँआ कि जदुओ तक तुसे दमड़ी-दमड़ी (पाई-पाई) नि देई देओगे, तदुओ तक तेथा ते छुटणा नि।” ");
INSERT INTO bfz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","तेस बखते कुछ लोक आए और यीशुए खे बोलेया कि पिलातुसे गलील प्रदेशो रे कुछ लोका री अत्या करी ती, जेबे सेयो मन्दरो रे बलिदान करने चढ़ाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ये सुणी की यीशुए तिना खे जवाब दित्तेया, “क्या तुसे समजोए कि यो गलीली लोक ओर सबी गलीलिया ते जादा पापी थे कि तिना पाँदे एड़ी बिपदा पड़ी? ");
INSERT INTO bfz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","आऊँ तुसा खे बोलूँआ कि ना; पर जे तुसे मन नि फेरोगे तुसे बी सब ईंयां ई नाश ऊणे। ");
INSERT INTO bfz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","या तुसे समजोए कि सेयो ठारा जणे जिना पाँदे शीलोहो रा गुम्मट पड़ेया था और सेयो दबी की मरी गे थे, क्या यरूशलेम और सबी रणे वाल़ेया ते जादा पापी थे? ");
INSERT INTO bfz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","आऊँ तुसा खे बोलूँआ कि ना, पर जे तुसे मन नि फेरोगे, तो तुसे बी ईंयां ई नाश ऊणे।” ");
INSERT INTO bfz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","तेबे यीशुए ये उदारण सुणाया, “केसी रे अँगूरा रे बगीचे रे दाऊगल़े रा एक डाल़ लगी रा था, से तिदे फल़ टोल़ने आया, पर मिलेया नि। ");
INSERT INTO bfz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तेबे तिने बगीचे रे रखवाल़े खे बोलेया, ‘देख आऊँ तीन साला ते इदे फल टोल़ने आऊँआ, पर मिलदा नि, एसखे बाडी दे, ताकि ये खरी जमीना खे पनि रोको।’ ");
INSERT INTO bfz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","तिने तेसखे बोलेया कि ओ स्वामी! एसखे एस सालो रे ओर रणी दे कि आऊँ एतेरे चऊँ कनारे खणी की खाद सेटुँ। ");
INSERT INTO bfz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","तो जे आगो खे फल लगेया तो ठीक, नई तो बाडी देयो।” ");
INSERT INTO bfz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","आरामो रे दिने यीशु प्रार्थना रे कअरो रे उपदेश देणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","तेबे एक जवाणस आयी, जेसा रे ठारा साला ते, कमजोर करने वाल़ी दुष्टात्मा थी और से कुबड़ी ऊईगी थी और किंयाँ बी सीदी नि ऊई सको थी। ");
INSERT INTO bfz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीशुए से देखी की बुलाई और तेसा खे बोलेया, “ओ जवाणसे! तूँ आपणी कमजोरिया ते छूटी गी।” ");
INSERT INTO bfz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","तेबे तिने तेसा पाँदे आथ राखे और से फटाफट सीदी ऊईगी और परमेशरो री तारीफ करने लगी। ");
INSERT INTO bfz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","कऊँकि यीशुए से आरामो रे दिने ठीक कित्ती थी, प्रार्थना रे कअरो रा सरदार जल़ी की लोका खे बोलणे लगेया, “अफ़्ते रे छे दिन ए जिदे काम करना चाईयो, तो तिना दिना रे आयी की ठीक ओ, आरामो रे दिने नि।” ");
INSERT INTO bfz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ये सुणी की यीशुए जवाब दित्तेया, “ओ कपटियो! क्या आरामो रे दिने तुसा बीचा ते हर एक आपणे बल़दा और गह्देया खे गवाईणी ते खोली की पाणी पल़याणे नि लयी जांदा? ");
INSERT INTO bfz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","तो क्या ठीक नि था कि ये जवाणस जो अब्राहमो रे वंशो ते ए जो शैताने ठारा साला ते बानी राखी थी, आरामो रे दिने एसा खे बन्दनो ते छुड़ाया जाओ।” ");
INSERT INTO bfz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","जेबे यीशुए यो गल्ला बोलिया, तेबे तिना रे सब बिरोदी शर्मिंदा ऊईगे और सारी पीड़ तिना हैरान करने वाल़ेया रे कामा ते, जो सेयो करो थे, खुश ऊई। ");
INSERT INTO bfz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","तेबे यीशुए बोलेया, “परमेशरो रा राज्य केस जेड़ा ए? और आऊँ तिजी री तुलना किजी साथे करुँ? ");
INSERT INTO bfz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","से अऊरिया रे एक दाणे जेड़ा ए, जो किने मांणूए लयी की आपणे डोरूआ रे बाया और से बड़ा ऊई की डाल़ बणीगा और सर्गो रे पंछिया तेते पाँदे आपणा बसेरा कित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","तिने फेर बोलेया, “आऊँ परमेशरो रे राज्य री उपमा किजी साथे करुँ? ");
INSERT INTO bfz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","से सजेड़े जेड़ा ए, जो एकी जवाणसे लया और बीई किलो ते जादा आटे रे गूँदी ता और ऊँदे-ऊँदे सारा आटा सजेड़ा ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","यीशु नगर-नगर और गांव-गांव रे आपणे चेलेया साथे उपदेश देंदे ऊए यरूशलेमो खे जाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","तेबे किने तिना ते पूछेया, “ओ प्रभु, क्या उद्धार पाणे वाल़े थोड़े ईए?” यीशुए तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“स्वर्गो रे परमेशरो तक पऊँछणे री बाट बऊत कठण ए। पर एते बाटा रिये तुसा चलणा ईए, कऊँकि आऊँ तुसा खे बोलूँआ कि बऊत जणेया चाणा कि पीतरे जाईए, पर जाई नि सकणे। ");
INSERT INTO bfz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जेबे परमेशर, कअरो रा मालक उठी की द्वार बंद करी चुकेया ओगा और तुसे बारे खड़ी की द्वार खटखटाई की बोलणे लगो, ‘ओ प्रभु! आसा खे खोली देओ,’ और से जवाब देओ, ‘आऊँ तुसा खे नि जाणदा, तुसे केथो रे ए?’ ");
INSERT INTO bfz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तेबे तुसा बोलणे लगणा कि आसे तां सामणे खाया-पिया और तैं आसा रे बजारो रे उपदेश कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","पर तेस बोलणा, आऊँ तुसा खे बोलूँआ, ‘आऊँ नि जाणदा कि तुसे केथो रे ए? ओ कुकर्म करने वाल़ेयो, तुसे सब मांते दूर रओ।’ ");
INSERT INTO bfz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","तेती रोणा और दाँदा रा किरड़ना ई ऊणा; जेबे तुसा अब्राहम, इसहाक, याकूब और सब भविष्यबक्ता परमेशरो रे राज्य रे बैठे रे देखणे और आपणे आपू खे बारे निकयाल़े रा देखणा। ");
INSERT INTO bfz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","पूर्व और पच्छम, उतर और दक्खणो रे लोका आयी की परमेशरो रे राज्य रे, साथे रोटी खाणी ");
INSERT INTO bfz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","पर एबे बऊत सारे लोक जो आपणे आपू खे एते दुनिया रे बड़े समजोए, सेयो परमेशरो री नजरा रे छोटे ऊई जाणे, और जिना खे संसार एबु छोटा समजोआ, सेयो परमेशरो री नजरा रे बड़े समजे जाणे।” ");
INSERT INTO bfz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","तेसी कअड़िया रे बऊत फरीसिये तिना खे आयी की बोलेया, “एथा ते निकल़ी जा, कऊँकि हेरोदेस तुसा खे काणा चाओआ।” ");
INSERT INTO bfz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","यीशुए तिना खे बोलेया, “जाई की तेसा लोमड़िया खे बोली देओ कि देख, माखे आज और काल दुष्टात्मा खे निकयाल़ने और बमारा खे ठीक करदे ऊए तीन दिन लगी जाणे। ");
INSERT INTO bfz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","तेबे बी मेरा आज, काल और परसु चलणा जरूरी ए, कऊँकि एड़ा ऊई नि सकदा कि कोई भविष्यबक्ता यरूशलेमो ते बारे मारेया जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ओ यरूशलेमो रे लोको, ओ यरूशलेमो रे लोको! तूँ जो भविष्यबक्तेया खे काओआ और जो तांगे पेजी राखे, तिना खे पात्थर बाएआ, कितणी बार मैं चाया कि जिंयाँ मुर्गी आपणे बच्चेया खे आपणे पंखो निठे कट्ठा करी की समाल़ोई, तिंयाँ ई आऊँ बी चाऊँआ कि तेरे बाल़का खे कट्ठा करी की समाल़ुँ। पर तुसे नि चाया। ");
INSERT INTO bfz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","देखो, तुसा रा कअर तुसा खे उजाड़ी की छाडीता। कऊँकि आऊँ तुसा खे बोलूँआ कि एबुए ते जदुओ तक तुसे नि बोलोगे, ‘धन्य ए सेयो, जो प्रभुए रे नाओं ते आओए’ तदुओ तक तुसा आऊँ फेर कदी नि देखणा।” ");
INSERT INTO bfz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","तेबे यीशु आरामो रे दिने फरीसिया रे अधिकारिया बीचा ते केसी एकी रे कअरे रोटी खाणे गये और सेयो तिना रे कोई गल़ती टोल़ने री ताका रे थे, ताकि तिना पाँदे कोई दोष लगाई सको। ");
INSERT INTO bfz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","तेती एक मांणू था जेसरे आथो रे और पैरा रे सोजा था ");
INSERT INTO bfz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","तेबे यीशुए धर्मशास्त्री खे और फरीसिया खे बोलेया, “क्या आरामो रे दिने अच्छा करना बिधानो रे मुताबिक ठीक ए कि गल़त?” ");
INSERT INTO bfz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","पर सेयो चुप-चाप रये। तेबे यीशुए से आथ लगाई की ठीक कित्तेया और जाणे दित्तेया ");
INSERT INTO bfz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","और तिना खे बोलेया, “तुसा बीचा ते एड़ा कूणे कि जेसरा पाऊ या बल़द कुँएं रे पड़ी जाओ और तेस आरामो रे दिने ई तेसखे बारे नि निकयाल़ो?” ");
INSERT INTO bfz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","सेयो इना गल्ला रा कोई बी जवाब नि देई सके। ");
INSERT INTO bfz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","जेबे यीशुए देखेया कि निऊँदे वाल़े लोक खास-खास जगा चूणी लओए, तेबे तिने एक उदारण सुणाई की तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“जेबे कोई ताखे ब्याओ खे बुलाओ, तो खास जगा रे नि बैठणा, केथी एड़ा नि ओ कि तिने तांते बी केसी बड़े खे निऊँदा देई राखेया ओ। ");
INSERT INTO bfz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","और जिने ताखे और तेसखे, दूँईं खे निऊँदा देई राखेया, आयी की ताखे बोलो कि एसखे जगा छाड और तेबे ताखे सबी ते शर्मिंदा ऊई की सबी ते थालली जगा रे बैठणा पड़ो। ");
INSERT INTO bfz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","पर जेबे ताखे बुलाओ, तेबे सबी ते थालली जगा रे जाई की बैठ, ताकि तेबे जिने तूँ बुलाई राखेया, से आओ और ताखे बोलो कि ओ दोस्त! आगे जे बैठ। तेबे तां साथे बैठणे वाल़ेया सामणे तेरी तारीफ ऊणी ");
INSERT INTO bfz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","कऊँकि जो कोई आपू खे बड़ा बणाओगा, से छोटा कित्तेया जाणा और जो आपू खे छोटा बणाओगा, से बड़ा कित्तेया जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तेबे यीशुए आपणे निऊँदा देणे वाल़ेया खे बोलेया, “जेबे तूँ दिनो री या साँजा री रोटी खाए तो तेबे तैं, आपणे दोस्त, पाई, टब्बरो वाल़े और अमीर दोस्त नि बुलाणे, केथी एड़ा नि ओ कि सेयो ताखे बी निऊँदा देओ और तेरा बदला चुकाई देओ। ");
INSERT INTO bfz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","पर जेबे तूँ रोटी खाए, तेबे कंगाल़ा खे, टुण्डेया खे, लंगड़ेया खे और अन्देया खे बुला। ");
INSERT INTO bfz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तेबे तूँ धन्य ऊणा, कऊँकि तिना गे ताखे बदला देणे खे कुछ निए, पर ताखे तर्मिया लोका रे मुड़देया बीचा ते जिऊँदे ऊणे पाँदे इजी रा ईनाम मिलणा।” ");
INSERT INTO bfz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","तिना साथे रोटी खाणे वाल़ेया बीचा ते एकी जणे इना गल्ला खे सुणी की बोलेया, “धन्य ए सेयो, जिना परमेशरो रे राज्य रे रोटी खाणी।” ");
INSERT INTO bfz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","यीशुए तेसखे बोलेया, “एकी मांणूए बऊत बडिया पाट्टिया कित्तिया और बऊत जणे बुलाए। ");
INSERT INTO bfz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जेबे रोटी त्यार ऊईगी, तेबे तिने आपणे दासो रे जरिए निऊँदा दित्ते रे लोका खे बोलेया, ‘आयी जाओ और रोटी त्यार ए।’ ");
INSERT INTO bfz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","पर सेयो सब जणे माफी मांगणे लगे, एकी जणे बोलेया, ‘मैं तो डोरू मोले लयी राखे और माखे सेयो देखणे जरूरी ए, आऊँ तांते बिनती करूँआ कि माखे माफ करी दे।’ ");
INSERT INTO bfz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दूजे बोलेया, ‘मैं पाँज जोड़े बल़दा रे खरीदी राखे और आऊँ तिना खे परखणे खे चली रा, मेरी तांते बिनती ए कि माखे माफ करी दे।’ ");
INSERT INTO bfz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","एकी ओरी बोलेया, ‘मैं ब्या करी राखेया आऊँ नि आयी सकदा।’ ");
INSERT INTO bfz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","तिने दासे सारी गल्ल मालको गे सुणाई, तेबे तिने रोषो रे आयी की आपणे दासो खे बोलेया, ‘नगरो दे, बजारो और गल़िया रे जाई की कंगाल़, लंगड़े, टूण्डे और अन्देया खे एती ली आओ।’ ");
INSERT INTO bfz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","दासे फेर बोलेया, ‘जिंयाँ तुसे बोलेया था, तिंयाँ ई कित्तेया, पर फेर बी जगा ए।’ ");
INSERT INTO bfz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","स्वामिए दासो खे बोलेया, ‘सड़का ते और बाटा ते लोका खे जबरदस्ती ली आओ, ताकि मेरा कअर फरी जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","कऊँकि आऊँ तुसा खे बोलूँआ कि तिना, जिना खे निऊँदा देई राखेया था, तिना निऊँदा दित्ते रे लोका बीचा ते एकी जणे पनि मेरे कअरे पाट्टी चाखणी।’ ” ");
INSERT INTO bfz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","तेबे यीशुए पीछे एक बड़ी पारी पीड़ जाणे लगी री थी, तेबे तिने तिना खे पीछे मुड़ी की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“जे कोई मांगे आओ और आपणे माए-बाओ, लाड़ी, बाल-बच्चे, पाई, बईण, बल्कि आपणे प्राणो ते बी बड़ी की मांते प्यार नि करो, तो से मेरा चेला नि ऊई सकदा। ");
INSERT INTO bfz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जे तुसे मेरे चेले बणना चाओए, पर मेरिया तंईं मरने खे त्यार निए और मां पीछे नि आओ, तो तुसे मेरे चेले नि ऊई सकदे। ");
INSERT INTO bfz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","तुसा बीचा ते कूणे, जो गढ़ बनाणा चाओआ और पईले बैठी की खर्च नि जोड़ो कि पूरा बनाणे लायक आए कि नई। ");
INSERT INTO bfz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","केथी एड़ा नि ओ कि जेबे निऊँ पाई की त्यार नि करी सको और सब देखणे वाल़े ये बोली की तेसरा मजाक ऊड़ाणे लगो ");
INSERT INTO bfz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","कि ये मांणू बनाणे तो लगेया, पर त्यार नि करी सकेया। ");
INSERT INTO bfz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","या कुण एड़ा राजा ए, जो दूजे राजे साथे लड़ने जाओआ और पईले बैठी की बिचार नि करी लो कि जो बीई ह्जार लई की मां पाँदे चढ़ाई करने आऊणे लगी रा क्या आऊँ दस ह्जार लई की तेसरा सामणा करी सकोआ कि नई। ");
INSERT INTO bfz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","नई तो तेसते दूर रई की तेस आपणा दूत पेजी की मिलाप करना चाणा। ");
INSERT INTO bfz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ईंयां ई तुसा बीचा ते जो कोई आपणा सब कुछ नि छाडी देओगा, से मेरा चेला नि ऊई सकदा। ");
INSERT INTO bfz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“लूण तो अच्छा ए, पर जे लूणो रा स्वाद बिगड़ी जाओ, तो से किजी चीजा साथे स्वाद कित्तेया जाणा? ");
INSERT INTO bfz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","से ना तो जमीना खे और ना खादा खे कामे आओआ, तेसखे तो लोक बारे सेटी देओए। जो समजी सकोआ से तिजी खे त्यानो साथे सुणो और मानी बी लओ।” ");
INSERT INTO bfz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","बऊत सारे चूंगी लणे वाल़े और पापी यीशुए गे आया करो थे, ताकि तिना री सुणो ");
INSERT INTO bfz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","तेबे फरीसी और शास्त्री कुड़कुड़ाई की बोलणे लगे, “ये तो पापिया साथे मिलोआ और तिना साथे खाओ-पीओआ।” ");
INSERT INTO bfz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तेबे यीशुए तिना खे ये उदारण बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“जे तुसा बीचा ते केसी एकी गे सौ पेडा ए। तिना बीचा ते एक पेड राची जाओ, तो नड़िनूआ खे जंगल़ो रे छाडी की तेसा एकी खे जो राची री, जदुओ तक से मिली नि जाओ, तदुओ तक से तेसा खे टोल़दा रणा ");
INSERT INTO bfz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","और जेबे मिली जाओई, तेबे से तेसा खे बड़ी खुशिया साथे कांदा पाँदे चकी लओआ ");
INSERT INTO bfz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","और आपणे कअरे जाईकी आपणे दोस्ता और पड़ोसिया खे कट्ठे करी की बोलोआ कि मां साथे खुशी मनाओ, कऊँकि मेरी राची री पेड मिलीगी री। ");
INSERT INTO bfz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","आऊँ तुसा खे बोलूँआ ईंयां ई एक मन फिराणे वाल़े पापिया रे बारे रे स्वर्गो रे बी एड़ी ई खुशी ऊणी, जितणा नड़िनूए एड़े तर्मिया रे बारे रे नि ऊणी, जिना खे मन फिराणे री जरूरत निए। ");
INSERT INTO bfz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“या कुण एड़ी जवाणस ऊणी, जेसा गे दस सिक्के ओ और तिना बीचा ते एक राची जाओ और से दिऊआ बाल़ी की सारे कअरो रे सुण-प्वार करी की, जदुओ तक मिली नि जाओ, तदुओ तक मन लगाई की टोल़दी नि रओ? ");
INSERT INTO bfz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","और जेबे मिली जाओआ, तेबे से आपणी सेलिया और पड़ोसणिया खे कट्ठी करी की बोलोई कि मां साथे खुशी मनाओ, कऊँकि मेरा राचे रा सिक्का माखे मिली गा रा। ");
INSERT INTO bfz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","आऊँ तुसा खे बोलूँआ कि ईंयां ई एक मन फिराणे वाल़े पापिया रे बारे रे परमेशरो रे स्वर्गदूता सामणे खुशी ओई।” ");
INSERT INTO bfz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","तेबे यीशुए एक और उदारण बोलेया, “एक मांणूए रे दो पाऊ थे। ");
INSERT INTO bfz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","तिना बीचा ते छोटे पाऊए आपणे पिते खे बोलेया, ‘ओ पिता सम्पतिया बीचा ते जो मेरा इस्सा आए, तेस माखे एबु देई दे।’ तिने तिना खे आपणी सम्पति बांडी ती। ");
INSERT INTO bfz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","तेबे जादा दिन नि थे ऊए रे कि छोटा पाऊ आपणा सब कुछ कट्ठा करी की दूर देशो खे चली गा और तेती कुकर्मो रे आपणी सम्पति ऊड़ाई ती। ");
INSERT INTO bfz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जेबे से सब कुछ खर्च करी चुकेया, तेबे तेते देशो रे बड़ा अकाल़ पड़ी गा और से कंगाल़ ऊईगा और तेसगे खाणे खे कुछ बी नि रया। ");
INSERT INTO bfz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","तेबे से तेस देशो रे रणे वाल़ेया बीचा ते एकी रे कअरे काम करने गया। तिने से आपणे डोरूआ रे सूंअर चराणे पेजेया ");
INSERT INTO bfz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","और से इतणा पूखा था और चाओ था कि तिना फल़िया ते जो सूंअर खाओ ए, तिना साथे आपणा पेट परूँ और तेसखे कोई कुछ नि देओ था। ");
INSERT INTO bfz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","जेबे से आपणी ओशा रे आया, तेबे बोलणे लगेया, ‘मेरे पिते रे मजूरदारा खे रोटिया ते जादी रोटी मिलो थी और आऊँ एती पूखा मरने लगी रा। ");
INSERT INTO bfz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मां एबे उठी की आपणे पिते गे जाणा और तेसखे बोलणा कि मैं परमेशरो रे खलाफ और तेरी नजरा रे पाप करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","एबे एते जोगा नि रया कि तेरा पाऊ ओऊँ, माखे आपू गे एक मजूरदार जेड़ा राखी दे।’ ");
INSERT INTO bfz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“तेबे से तेस देशो खे छाडी की आपणे पिते गे चली गा। से एबु दूर ई था कि तेसरे पिते तेसखे देखी की तरस खाया और दौड़ी की आपणे पाऊए खे गल़े लगाया और बऊत चूमेया। ");
INSERT INTO bfz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","पाऊए तेसखे बोलेया, ‘पिता जी! मैं परमेशरो रे खलाफ और तेरी नजरा रे पाप करी राखेया और एबे एते जोगा नि रया कि तेरा पाऊ ओऊँ।’ ");
INSERT INTO bfz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","पर पिते आपणे दासा खे बोलेया, ‘फटाफट अच्छे ते अच्छे टाले एसखे पणयाओ और एसरे आथो रे छाप और पैरो रे जूतिया पणयाओ ");
INSERT INTO bfz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","और सबी ते बढ़िया ते बढ़िया खाणा बणाओ, ताकि आसे खाऊँ और खुशी मनाऊँ। ");
INSERT INTO bfz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","कऊँकि मेरा ये पाऊ मरी गा था और फेर जिऊँदा ऊईगा रा, राची गा था, पर एबे मिली गा रा।’ सेयो खुशी मनाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“पर तेसरा बड़ा पाऊ डोरूआ रे था और जेबे से आऊँदा ऊआ कअरो रे नेड़े पऊँछेया, तेबे तिने गाणे बजाणे रा और नाचणे रा आल्ला सुणेया। ");
INSERT INTO bfz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","तेबे तिने एकी दासो ते पूछेया, ‘ये क्या लगी रा ऊणे?’ ");
INSERT INTO bfz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","दासे बोलेया, ‘तेरा पाई वापस आयी रा और तेरे पिते सबी ते बढ़िया ते बढ़िया खाणा बणवाई राखेया, कऊँकि से ठीक-ठाक मिलेया।’ ");
INSERT INTO bfz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ये सुणी की तेसखे रोष आईगा और पीतरे नि जाणा चाया, पर तेसरा पिता बारे आयी की तेसखे मनाणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","तिने पिते खे बोलेया, ‘देख, आऊँ इतणे साला ते तेरी सेवा करने लगी रा और कदी बी तेरी आज्ञा नि टाल़ी और तेबे बी तैं माखे कदी बी बढ़िया खाणा नि दित्तेया, ताकि आऊँ आपणे दोस्ता साथे मजे करुँ? ");
INSERT INTO bfz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पर जेबे तेरा ये पाऊ आया, जिने तेरी सम्पति वेश्या रे ऊड़ाई ती और आया तो तैं एसरी खुशिया रे बड़ी पाट्टी कित्ती।’ ");
INSERT INTO bfz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","पिते तेसखे बोलेया, ‘ओ मेरे पाऊ, तूँ सदा मां साथे ईए और जो कुछ मेरा ए, से सब तेरा ईए। ");
INSERT INTO bfz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पर एबे खुश और मग्न ऊणा चाईयो, कऊँकि ये तेरा पाई मरी गा था और फेर जिऊँदा ऊईगा और राची गा था, पर फेर मिली गा।’ ” ");
INSERT INTO bfz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","तेबे यीशुए आपणे चेलेया खे बी ये उदारण बोलेया, “केसी अमीरो रा एक पण्डारी था और लोके तेस सामणे तेस पाँदे ये दोष लगाया कि ये तेरा सारा पैसा उड़ाई देओआ। ");
INSERT INTO bfz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","तेबे तिने अमीर मांणूए से बुलाया और बोलेया, ‘ये क्या ए, जो आऊँ तेरे बारे रे सुणने लगी रा? आपणे पण्डारो रा लेखा दे, कऊँकि तूँ आगे ते पण्डारी नि रई सकदा।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","तेबे पण्डारी सोचणे लगेया कि एबे आऊँ क्या करुँ? कऊँकि मेरा मालक तो एबे पण्डारो री जगा मांते छुड़ाणे लगी रा। माट्टी तो मांते खणदी नि और पीख मांगणे ते तो माखे शर्म आओई। ");
INSERT INTO bfz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","माखे समज आयी की क्या करना; ताकि जेबे पण्डारियो रे कामो ते छुड़ाया जाऊँ तो लोक आपणे कअरे बुलाई लो। ");
INSERT INTO bfz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","तेबे तिने आपणे मालको रे देणदारा बीचा ते एक-एक बुलाए और पईले ते पूछेया कि तां मेरे मालको रा कितणा कर्ज देणा? ");
INSERT INTO bfz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","तिने बोलेया, ‘सौ मण जैतूनो तेल।’ तेबे तिने तेसखे बोलेया, ‘जा और आपणे खाते रे पंजा लिखी दे।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","तेबे तिने दूजे ते पूछेया कि तां मेरे मालको रा कितणा कर्ज देणा? तिने बोलेया सौ मण कणक; तिने तेसखे बोलेया, ‘जा और आपणे खाते रे की अस्सी लिखी दे।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“मालके से पापी पण्डारी सराया कि तिने चंट ऊई की काम कित्तेया, कऊँकि एसा दुनिया रे लोक, आपणे बखतो रे लोका रे रीति-रवाजा रे जोतिया रे लोका ते जादा ऊशियार ए। ");
INSERT INTO bfz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","आऊँ तुसा खे बोलूँआ कि पापो रे पैसे ते आपू खे दोस्त बणाई लो, ताकि जेबे से जाओ, तेबे सेयो तुसा खे अनन्त निवासो रे लयी लो। ");
INSERT INTO bfz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","जो थोड़े ते थोड़े रे सच्चा ए, से बऊत रे बी सच्चा ए और जो थोड़े ते थोड़े रे पापी ए, से बऊत रे बी पापी ए। ");
INSERT INTO bfz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","तेबे, जे तुसे पापो रे धनो रे सच्चे नि ऊए, तो सच्चा धन तुसा गे केस सम्बाल़ना? ");
INSERT INTO bfz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","और जे तुसे पराये धनो रे सच्चे नि ठईरे, तो तेबे जो तुसा राए, से तुसा खे केस देणा? ");
INSERT INTO bfz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कोई बी दास दो मालका री सेवा नि करी सकदा; कऊँकि तेस एकी साथे बैर और दूजे साथे प्यार राखणा, या एकी साथे मिले रा रणा और दूजा तेस तुच्छ जाणना। तुसे परमेशर और धन दूँईं री सेवा नि करी सकदे।” ");
INSERT INTO bfz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरीसी जो लाल़ची थे, ये सुणी की तिना रा मजाक करने लगे। ");
INSERT INTO bfz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीशुए तिना खे बोलेया, “तुसे तो मांणूआ सामणे आपू खे तर्मी ठराओए, पर परमेशर तुसा रे मनो खे जाणोआ, कऊँकि जो चीज मांणूआ री नजरा रे महान् ए, से परमेशरो सामणे घृणित ए। ");
INSERT INTO bfz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“यूहन्ना बपतिस्मा देणे वाल़े तक मूसे रा बिधान और भविष्यबक्ता रा संदेश तुसा री अगुवाई करदे रये। पर एबे परमेशरो रे राज्य रा सुसमाचार सुणाया जाणे लगी रा और हर कोई तिदे बऊत मईणत करी की जाओआ। ");
INSERT INTO bfz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","सर्ग और तरतिया रा टल़ी जाणा, बिधानो रे एक बिन्दुओ रे खोणे बराबर ए। ");
INSERT INTO bfz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“जो कोई आपणी लाड़िया खे छाडी की केसी ओरी साथे ब्या करोआ, से व्याभिचार करोआ और जो कोई एड़ी छाडी रिया जवाणसा साथे ब्या करोआ, से बी व्याभिचार करोआ। ");
INSERT INTO bfz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“एक अमीर मांणू था जो बैंगणी टाले और मलमलो रे टाले पईनो था और हर रोज सुख-बिलासो रे और मौज-मस्तिया साथे रओ था। ");
INSERT INTO bfz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","लाजर नाओं रा एक गरीब मांणू था, जेसरे सारे शरीरो रे जख्म थे, तेसखे तेस अमीर मांणूए री देऊल़िया पाँदे छाडी देओ थे। ");
INSERT INTO bfz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","और से चाओ था कि अमीरो री मेजा री जूठा ते आपणा पेट परूँ, एथो तक कि कुत्ते बी तेसरे जख्मा खे चाटी देओ थे। ");
INSERT INTO bfz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","तेबे एड़ा ऊआ कि से कंगाल़ मरी गा और स्वर्गदूते से लयी की अब्राहमो री गोदा रे पऊँछाई ता और से अमीर बी मरी गा और दबाई ता। ");
INSERT INTO bfz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","तेबे तिने नरको री पीड़ा ते ऊबो खे देखेया और दूरो ते अब्राहमो री गोदा रे लाजर देखेया। ");
INSERT INTO bfz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","तेबे तिने आक्का पायी की बोलेया, ‘ओ पिता अब्राहम! मां पाँदे दया करी की लाजरो खे पेजी दे, ताकि से आपणी गुठिया रा सिरा पाणिए साथे सेड़ी की मेरी जीबा खे ठण्डी करो, कऊँकि आऊँ एते आगी रे तड़फणे लगी रा।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","पर अब्राहमे बोलेया, ‘ओ पाऊ! याद कर कि तूँ आपणी जिन्दगिया रे अच्छी चीजा लयी चुकेया रा और तिंयाँ ई बुरिया चीजा खे लाजर बी, पर एबे से एती शान्ति पाणे लगी रा और तूँ तेती पीड़ा ते तड़फणे लगी रा। ");
INSERT INTO bfz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","इना सबी गल्ला खे छाडी की आसा बीचे और तां बीचे पारी गड्डा ए ठराए रा, ताकि कोई एथा ते तांगे पार नि जाई सको और ना पारा ते कोई एती आसा गे आयी सको।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","तिने बोलेया, ‘ओ पिता! तेबे आऊँ तांते बिनती करूँआ कि तूँ लाजरो खे मेरे पिते रे कअरे पेज। ");
INSERT INTO bfz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","कऊँकि मेरे पाँज पाई ए, ये तिना सामणे इना गल्ला री गवाई देओ, एड़ा नि ओ कि सेयो बी मरी की एते पीड़ा री जगा रे आओ।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहमे तेसखे बोलेया, ‘तिना गे तो चेतावणी देणे खे मूसे रा बिधान और भविष्यबक्ते री कताबा ए, सेयो तिना री सुणो।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","तिने बोलेया, ‘ना, ओ पिता अब्राहम! पर जे कोई एथा ते मरे रे बीचा ते तिना गे जाओगा, तो तिना मन फिराणा।’ ");
INSERT INTO bfz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","तिने तेसखे बोलेया, ‘जेबे सेयो मूसे और भविष्यबक्ते री नि सुणदे, तो जे मरे रे बीचा ते कोई बी जिऊँदा उठोगा, तेबे बी तेसरी नि मानणी।’ ” ");
INSERT INTO bfz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","तेबे यीशुए आपणे चेलेया खे बोलेया, “एड़ा ऊई नि सकदा कि ठोकरा नि लगो, पर हाय! तेस मांणूए खे, जेसरी बजअ ते सेयो आओईया। ");
INSERT INTO bfz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जो इना छोटेया बीचा ते केसी एकी खे बी ठोकर देओगा, तेसखे तो ये पला ऊँदा कि तेसरे गल़े रे चाक्किया रा एक पूड़ लटकाई देओ और समुद्रो रे सेटी देओ। ");
INSERT INTO bfz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","चौकस रओ, जे तेरा विश्वासी पाई अपराध करो, तो तेसखे समजेया और जे से पछताओ, तो तेसखे माफ कर। ");
INSERT INTO bfz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","जे एकी दिनो रे से तेरे खलाफ सात बार अपराध करो और सातो बार तांगे फेर आयी की बोलो कि आऊँ पछताऊँआ, तो तेसखे माफ कर।” ");
INSERT INTO bfz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तेबे प्रेरिते यीशुए खे बोलेया, “आसा रा विश्वास बढ़ा।” ");
INSERT INTO bfz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","यीशुए बोलेया, “जे तुसा खे अऊरिया रे दाणे रे बराबर बी विश्वास ऊँदा, तो एस करयूँओ रे डाल़ो खे बोलदे कि जड़ा ते पट्ठी की समुद्रो रे लगी जा, तो से तुसा री मानी लंदा। ");
INSERT INTO bfz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“तुसा बीचा ते एड़ा कूणे कि जेसरा दास अल़ बाओ या पेडा खे चराओआ और जेबे से डोरूआ ते आओ, तेबे तेसखे बोलो, ‘फटाफट आओ और रोटी खाणे बैठी जा?’ ");
INSERT INTO bfz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","और ये नि बोलो कि माखे रोटी बणा, और जदुओ तक आऊँ खाऊँ, तदुओ तक लक बानी की मेरी सेवा कर, तिजी ते बाद तैं बी खाई-पी लणा। ");
INSERT INTO bfz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","क्या तेस, तेस दासो रा एहसान मानणा कि तिने सेयो ई काम कित्ते, जेसरी तिने आज्ञा दित्ती थी। ");
INSERT INTO bfz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ईंयां ई तुसे बी, जेबे तिना सबी कामा खे करी चुकोगे, जिना खे करने री आज्ञा तुसा खे देई राखी थी, तो बोलो, ‘आसे नक्कमे दास ए; कऊँकि जो आसा करना चाईयो था, बस सेई करी राखेया।’ ” ");
INSERT INTO bfz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","और तेबे एड़ा ऊआ कि यीशु और तिना रे चेले यरूशलेमो खे जांदे ऊए सामरिया और गलीलो प्रदेशो रिये जाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","तेबे केसी गांव रे जांदे ऊए तिना खे दस कोढ़ी मिले। ");
INSERT INTO bfz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","तेबे तिने दूर खड़ी की जोरे की आक्का पाई की बोलेया, “ओ यीशु! ओ स्वामी! आसा पाँदे दया कर।” ");
INSERT INTO bfz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीशुए तिना खे देखी की बोलेया, “यरूशलेमो रे मन्दरो रे जाओ और आपू खे पुरोईतो गे बताओ।” सेयो जांदे-जांदे ई ठीक ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तेबे तिना बीचा ते एक ये देखी की कि आऊँ ठीक ऊईगा, जोरे-जोरे साथे परमेशरो री तारीफ करदा ऊआ वापस यीशुए गे आया ");
INSERT INTO bfz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","और यीशुए रे पैरा पाँदे मुंओ रे पारे पड़ी की तिना रा धन्यवाद करने लगेया और से सामरी था। ");
INSERT INTO bfz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","तेबे यीशुए बोलेया, “क्या दस के दस मांणू ठीक नि ऊए, तेबे सेयो नौ मांणू केयी ए? ");
INSERT INTO bfz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","क्या एस परदेशिया खे छाडी की ओर कोई नि निकल़ेया, जो परमेशरो री तारीफ करो?” ");
INSERT INTO bfz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तेबे यीशुए तेसखे बोलेया, “उठी की चली जा, तेरे विश्वासे तूँ बचाईता।” ");
INSERT INTO bfz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","जेबे फरीसिये यीशुए ते पूछेया कि परमेशरो रा राज्य कदी आऊणा? तेबे तिने जवाब दित्तेया, “परमेशरो रा राज्य प्रगट रूपो रे नि आऊँदा ");
INSERT INTO bfz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","और लोका एड़ा नि बोलणा कि देखो, एती ए या तेती ए, कऊँकि परमेशरो रा राज्य तुसा बीचे ए।” ");
INSERT INTO bfz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","तेबे तिने चेलेया खे बोलेया, “सेयो दिन आऊणे, जेबे तुसा माणूं रे पुत्रो रे दिना बीचा ते एकी दिनो खे देखणा चाणा और देखी नि सकणा। ");
INSERT INTO bfz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","लोका तुसा खे बोलणा, ‘देखो, मसीह एती ए!’ या ‘देखो, मसीह तेती ए!’ पर तुसे चली नि जाणा और ना ई तिना पीछे जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","कऊँकि जिंयाँ बिजल़ी सर्गो री एकी तरफा ते निकल़ी की सर्गो री दूजी तरफा खे चमकोई, तिंयाँ ई आँऊ माणूं रा पुत्र बी आपणे दिनो रे प्रगट ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पर पईले जरूरी ए कि तेसखे दु:ख ओ और एस जुगो रे लोक तेसखे तुच्छ ठराओ। ");
INSERT INTO bfz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जेड़ा नूहो रे दिनो रे ऊआ था, तेड़ा ई मां माणूं रे पुत्रो रे दिनो रे बी ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जेस दिनो तक नूह जाह्जो रे नि चढ़ेया, तेस दिनो तक लोक खाओ-पियो थे और तिना रे ब्या-शादिया ओ थिया, तेबे जल-प्रलय आयी की सेयो सब नाश कित्ते। ");
INSERT INTO bfz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","तिंयाँ ई जेड़ा लूतो रे दिना रे ऊआ था कि लोक खाओ-पियो और लेण-देण करो थे, डाल़ लगाओ थे और कअर बणाओ थे। ");
INSERT INTO bfz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पर जेस दिने लूत सदोमो ते निकल़ेया, तेस दिने आग और गन्धक सर्गो ते बरसी और तेते नगरो रे सब लोक नाश करी ते। ");
INSERT INTO bfz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“मां माणूं रे पुत्रो रे प्रगट ऊणे रे दिनो रे बी एड़ा ई ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","तेस दिने जो छतो पाँदे ओ और तेसरा समान कअरे ओ, से तेस लणे खे नि उतरो और तिंयाँ ई जो डोरूआ रे ओ, सेयो पीछे नि आटो। ");
INSERT INTO bfz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लूतो री लाड़िया खे याद राखो कि जो तेसा साथे उआ! ");
INSERT INTO bfz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जो कोई आपणा प्राण बचाओआ, तेस से खोणा और जो कोई तेसखे खोओआ, तेस अनन्त जिन्दगी पाणी। ");
INSERT INTO bfz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","आऊँ तुसा खे बोलूँआ, कि तेस राती दो लोक आपणे माँजे पाँदे ऊणे, एक लयी लणा और दूजा छाडी देणा। ");
INSERT INTO bfz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दो जवाणसा साथे-साथे चाक्की पिशणे लगी रिया ऊणिया, एक लयी लणी और दूजी छाडी देणी। ");
INSERT INTO bfz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दो जणे डोरूआ रे ऊणे, एक लयी लणा और दूजा छाडी देणा।” ");
INSERT INTO bfz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ये सुणी की चेलेया यीशुए ते पूछेया, “ओ प्रभु! ये केयी ऊणा?” तिने तिना खे बोलेया, “जेती लोथ ऊणी, तेथी इल्ला कट्ठिया ऊणिया।” ");
INSERT INTO bfz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","तेबे यीशुए इजी रे बारे रे कि हर रोज प्रार्थना करना और याओ नि छाडणा चाईयो, ये उदारण आपणे चेलेया खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“केसी नगरो रे एक न्यायी रओ था, जो ना परमेशरो ते डरो था और ना ई केसी मांणूए री परवा करो था ");
INSERT INTO bfz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","और तेसी नगरो रे एक बिदुआ बी रओ थी, जो तेसगे आयी-आयी की बोलदी रओ थी कि मेरा न्याय करी की माखे दुश्मणा ते बचा। ");
INSERT INTO bfz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","से थोड़े बखतो तक नि मानेया पर आखरी रे तिने सोचेया कि हालाँकि आऊँ ना परमेशरो ते डरदा और ना ई मांणूआ री परवा करदा, ");
INSERT INTO bfz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तेबे बी ये बिदुआ माखे सतांदी रओई, इजी री खातर मां तेसा रा न्याय चुकाई देणा, एड़ा नि ओ कि कअड़िया रे कअड़िया आयी की आखरी रे मेरे नाको रे दम करी देओ।” ");
INSERT INTO bfz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","यीशुए बोलेया, “त्यानो साथे सोचो, ये पापी न्यायी क्या बोलोआ? ");
INSERT INTO bfz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","तो क्या परमेशरे आपणे चूणे ऊए रा न्याय नि करना, जो रात-दिन तेसरी दुहाई देंदे रओए और क्या तेस तिना रे बारे रे देर करनी? ");
INSERT INTO bfz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","आऊँ तुसा खे बोलूँआ कि तेस फटाफट तिना रा न्याय करना, तेबे बी आँऊ माणूं रा पुत्र जेबे आऊणा, तो क्या मां तरतिया पाँदे विश्वास पाणा?” ");
INSERT INTO bfz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","तेबे तिना खे, जो आपू पाँदे विश्वास राखो थे कि आसे तर्मी ए और ओरी खे तुच्छ जाणो थे, ये उदारण बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“दो मांणू प्रार्थना करने खे मन्दरो रे गये, एक फरीसी था और दूजा कर लणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी खड़ा ऊई की ईंयां प्रार्थना करने लगेया, ‘ओ परमेशर आऊँ तेरा धन्यवाद करूँआ कि आऊँ ओरी मांणूए जेड़ा अन्देर करने वाल़ा, अन्यायी और व्याभिचारी निए और ना एस कर लणे वाल़े जेड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","आऊँ अफ़्ते रे दो बार बअरत करूँआ और आऊँ आपणी सारी कमाईया रा दसुआ अंश बी तुसा खे देऊँआ।’ ");
INSERT INTO bfz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","पर कर लणे वाल़े दूर खड़े ऊई की स्वर्गो रे कनारो खे आखी पनि चकणिया चाईया, बल्कि आपणी छाती बजाई-बजाई की बोलेया, ‘ओ परमेशर! मां पापिए पाँदे दया कर।’ ");
INSERT INTO bfz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","आऊँ तुसा खे बोलूँआ कि से दूजा नि पर येई मांणू तर्मी ठराई की आपणे कअरो खे गया, कऊँकि जो कोई आपू खे बड़ा बणाओगा, से छोटा करेया जाणा और जो आपू खे छोटा बणाओगा, से बड़ा करेया जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","तेबे लोक आपणे बच्चेया खे बी तिना गे ल्याऊणे लगे, ताकि सेयो तिना पाँदे आपणा आथ राखो, पर चेले तिना खे देखी की बकणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","यीशुए बच्चेया खे आपू गे बुलाई की बोलया, “बाल़का खे मांगे आऊणे देओ और तिना खे ना नि करो, कऊँकि परमेशरो रा राज्य एड़े रा ई ये। ");
INSERT INTO bfz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","आऊँ तुसा खे सच बोलूँआ कि जो कोई परमेशरो रे राज्य खे बाल़को जेड़ा नि मानोगा, से कदी बी तेती नि जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","तेबे एकी अधिकारिए यीशुए ते पूछेया, “ओ उत्तम गुरू! अनन्त जीवन पाणे खे आऊँ क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीशुए तेसखे बोलेया, “तूँ माखे उत्तम कऊँ लगी रा बोलणे? कोई बी उत्तम निए, बस एक, मतलब-परमेशर। ");
INSERT INTO bfz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तूँ आज्ञा खे तो जाणेया कि व्याभिचार नि करना, अत्या नि करना, चोरी नि करना, चूठी गवाई नि देणी, आपणे माए-बाओ रा आदर करना।” ");
INSERT INTO bfz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","तिने बोलेया, “इना गल्ला खे तो आऊँ बचपनो ते मानदा आयी रा।” ");
INSERT INTO bfz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ये सुणी की यीशुए बोलेया, “तांदे एबु बी एक गल्ला री कमी ए, आपणा सब कुछ बेची की कंगाल़ा खे बांडी दे और ताखे स्वर्गो रे धन मिलणा और आयी की मां पीछे आईजा।” ");
INSERT INTO bfz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","से ये सुणी की से बऊत उदास ऊईगा, कऊँकि से बऊत अमीर था। ");
INSERT INTO bfz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीशुए तेस देखी की बोलेया, “अमीरा रा परमेशरो रे राज्य रे जाणा कितणा कठण ए। ");
INSERT INTO bfz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","परमेशरो रे राज्य रे अमीरा रा जाणा, ऊँटो रा सूईया रे नाके ते निकल़ने रे बराबर ए।” ");
INSERT INTO bfz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","तेबे सुणने वाल़ेया बोलेया, “तेबे केसरा उद्धार ऊई सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","यीशुए बोलेया, “जो मांणूआ ते नि उई सकदा, से परमेशरो ते उई सकोआ।” ");
INSERT INTO bfz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","पतरसे बोलेया, “देख, आसे तो कअर-बार छाडी की तुसा पीछे आईगे रे।” ");
INSERT INTO bfz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","यीशुए बोलेया, “आऊँ तुसा खे सच बोलूँआ जो कोई, परमेशरो रे राज्य खे आपणे कअर, लाड़ी, पाई, बईण, माए-बाओ या बाल-बच्चे छाडी देओगा ");
INSERT INTO bfz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","तेस एस बखते कई गुणा फल पाणा और आऊणे वाल़े जुगो रे अनन्त जीवन।” ");
INSERT INTO bfz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","तेबे तिने बारा चेलेया खे साथे लयी की तिना खे बोलेया, “देखो, आसे यरूशलेम नगरो खे जाणे लगी रे और जितणी गल्ला मां माणूं रे पुत्रो रे बारे रे भविष्यबक्ते लिखी राखिया, सेयो सब पुरिया ऊणिया। ");
INSERT INTO bfz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","कऊँकि आँऊ दुजिया जातिया रे आथो रे देई देणा, और तिना मेरा मजाक उड़ाणा, और मां पाँदे थूकणा ");
INSERT INTO bfz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","और माखे कोड़े बाणे और काणा और आँऊ तीजे दिने जिऊँदा ऊई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","पर चेलेया इना गल्ला बीचा ते कोई बी गल्ल नि समजी और ये गल्ल तिना ते छिपी री रई और जो बोली राखेया था, से तिना री समजा रे नि आया। ");
INSERT INTO bfz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जेबे सेयो यरीहो नगरो रे नेड़े पऊँछे, तेबे एक अन्दा सड़का रे कनारे बैठे रा पीख लगी रा था मांगणे। ");
INSERT INTO bfz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","तेबे से पीड़ा रे हांडणे री छेड़ सुणी की पूछणे लगेया, “ये क्या लगी रा ऊणे?” ");
INSERT INTO bfz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","तिने तेसखे बोलेया, “यीशु नासरी लगी रे जाणे।” ");
INSERT INTO bfz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तेबे तिने आक्का पायी की बोलेया, “ओ दाऊदो री ल्वाद यीशु! मां पाँदे दया कर।” ");
INSERT INTO bfz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","जो आगे-आगे लगी रे थे चलणे, सेयो तेसखे बकणे लगे कि चुप रओ, पर से ओर बी चींगणे लगेया, “ओ दाऊदो री ल्वाद मां पाँदे दया कर!” ");
INSERT INTO bfz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","तेबे यीशुए खड़े ऊई की आज्ञा दित्ती, “एसखे मांगे ल्याओ।” और जेबे से नेड़े आया, तेबे तिने तेसते पूछेया, ");
INSERT INTO bfz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“तूँ क्या चाएया कि आऊँ ताखे क्या करुँ?” अन्दे बोलेया, “ओ प्रभु ये कि आऊँ देखणे लगी जाऊँ।” ");
INSERT INTO bfz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीशुए बोलेया, “देखणे लग, तेरे विश्वासे तूँ ठीक करी ता।” ");
INSERT INTO bfz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","और से तेबुई देखणे लगेया और परमेशरो री तारीफ करदा ऊआ तिना पीछे चलणे लगेया और सबी लोके ये देखी की परमेशरो री स्तुति कित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यीशु यरीहो नगरो ते जाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","तेती जक्कई नाओं रा एक मांणू कर लणे वाल़ेया रा सरदार था और अमीर था। ");
INSERT INTO bfz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","से यीशुए खे देखणा चाओ था कि से कुण जा ए? पर पीड़ा री बजअ ते देखी नि सको था, कऊँकि से बाऊणा था। ");
INSERT INTO bfz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","तेबे से तिना खे देखणे खे आगे दौड़ी की गूलरो रे डाल़ो पाँदे चढ़ी गा, कऊँकि सेयो तिसिये ई जाणे वाल़े थे। ");
INSERT INTO bfz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जेबे यीशु तेसा जगा रे पऊँछे, तेबे तिने पाँदे देखी की बोलेया, “ओ जक्कई फटाफट थाले उतरी जा! कऊँकि आज मेरा तेरे कअरे रणा जरूरी ए।” ");
INSERT INTO bfz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","से फटाफट गूलरो रे डाल़ो ते थाले उतरी की तिना खे खुशिया साथे आपणे कअरो खे लयी गा। ");
INSERT INTO bfz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ये देखी की सब लोक कुड़कुड़ाई की बोलणे लगे, “ये तो एक पापी मांणूए रे कअरे जाणे लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जक्कईये खड़े ऊई की यीशुए के बोलेया, “ओ प्रभु यीशु! देखो, आऊँ आपणी आदी जायदात कंगाल़ा खे देऊँआ और जे केसी रा कुछ बी अन्याय करी की लयी राखेया, तो तेसखे चार गुणा वापस करी देऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तेबे यीशुए बोलेया, “आज एते कअरो रे लोका बीचे उद्धार आयी रा, कऊँकि ये बी अब्राहमो रे वंशो राए। ");
INSERT INTO bfz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","कऊँकि आँऊ माणूं रा पुत्र राचे रेया खे टोल़ने और तिना खे बचाणे आयी रा।” ");
INSERT INTO bfz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जेबे सेयो इना गल्ला सुणने लगी रे थे, तेबे यीशुए एक उदारण बोलेया, कऊँकि सेयो यरूशलेमो रे नेड़े थे, और सेयो समजो थे कि परमेशरो रा राज्य एबु प्रगट ऊणे वाल़ा ए। ");
INSERT INTO bfz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","तेबे यीशुए बोलेया, “एक अमीर मांणू दूर देशो खे चली गा, ताकि राजपद पाई की फेर आओ। ");
INSERT INTO bfz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","तिने आपणे दासा बीचा ते दस दासा खे बुलाई की तिना खे दस सूईने रे सिक्के दित्ते और तिना खे बोलेया कि मेरे वापस आऊणे तक लेण-देण करी लएओ। ");
INSERT INTO bfz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","पर तेसरे नगरो रे रणे वाल़े तेसते बैर राखो थे और तेस पीछे दूता खे पेजी की सन्देशा पेजेया कि आसे नि चांदे कि ये आसा पाँदे राज्य करो। ");
INSERT INTO bfz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“जेबे से राजपद पाई की वापस आया, तेबे तिने सेयो दास बुलाए जिना खे तिने सूईने रे सिक्के दित्ते थे, ताकि पता लगाई सको कि तिने लेण-देणो ते क्या-क्या कमाया। ");
INSERT INTO bfz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तेबे एकी बोलेया, ओ मालक! तेरे सूईने रे सिक्के साथे दस ओर सिक्के कमाई राखे। ");
INSERT INTO bfz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","तिने तेसखे बोलेया कि ओ उत्तम दास तूँ धन्य ए कऊँकि तूँ थोड़े रेई विश्वासो जोगा निकल़ेया, एबे दस नगरो रा अक्क राख। ");
INSERT INTO bfz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दूजे बी आयी की बोलेया, ओ मालक! तेरे सूईने रे सिक्के साथे पाँज ओर सिक्के कमाई राखे। ");
INSERT INTO bfz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","तिने तेसखे बोलेया कि तूँ बी पाँज नगरा रा हाकिम ऊई जा। ");
INSERT INTO bfz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तीजे जणे आयी की बोलेया, ओ मालक! देख, तेरे सूईने रे सिक्के ये ए, जो मैं परने रे बानी की थे राखे रे। ");
INSERT INTO bfz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","कऊँकि आऊँ तांते डरूँ था, कऊँकि तुसे कठोर मांणू ए, जो तैं नि राखेया, से चकी लयेआ और जो तैं नि बाया, तेस बाडी देआ। ");
INSERT INTO bfz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","तिने तेसखे बोलेया, ओ दुष्ट दास! आऊँ तेरे ई मुंओ ते ताखे दोषी ठईराऊँआ, तूँ माखे जाणे था कि कठोर मांणू ए, जो मैं नि राखेया, तेस चकी लऊँआ और जो मैं नि बायी राखेया, से बाडी देऊँआ। ");
INSERT INTO bfz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तो तेबे तैं मेरे पैसे साऊकारो गे कऊँ नि राखे, ताकि आऊँ आयी की ब्याजो समेत लई लंदा। ");
INSERT INTO bfz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","और जो लोक नेड़े थे खड़े रे, तिने तिना खे बोलेया कि से सिक्का एसते लई लो और जेसगे दस सूईने रे सिक्के ए, तेसखे देई देओ। ");
INSERT INTO bfz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","तिने तेसखे बोलेया कि ओ स्वामी!, एसगे दस सिक्के तो आए। ");
INSERT INTO bfz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","आऊँ तुसा खे बोलूँआ कि जेसगे आए, तेसखे देणा, और जेसगे आया नि, तेसते से बी जो तेसगे आया, लयी लणा। ");
INSERT INTO bfz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पर मेरे तिना बैरिया खे, जो नई चाओ थे कि आऊँ तिना पाँदे राज्य करुँ, तिना खे एती मां सामणे ल्याई की काओ।” ");
INSERT INTO bfz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ये बोली की यीशु यरूशलेमो री तरफा खे आपणे चेलेया ते आगे-आगे चले। ");
INSERT INTO bfz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","जेबे सेयो जैतून नाओं रे पाह्ड़ो पाँदे बैतफगे गांव और बैतनिय्याहो गांव रे नेड़े पऊँछे, तेबे तिने आपणे चेलेया बीचा ते दो जणे ये बोली की पेजे, ");
INSERT INTO bfz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“सामणे रे गांव रे जाओ और तेती पऊँछी की एक गह्दिया रा बच्चा, जेस पाँदे कदी कोई नि बैठी रा, बाने रा तुसा खे मिलणा, तेस खोली की ल्याओ ");
INSERT INTO bfz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","और जे तुसा खे कोई पूछो कि कऊँ लगी रे खोलणे? तो बताई देणा कि प्रभुए खे एसते कुछ मतलब ए।” ");
INSERT INTO bfz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जो पेजे थे तिने जाई की तेड़ा ई पाया, जो तिना गे बताई राखेया था। ");
INSERT INTO bfz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जेबे सेयो गह्दे रे बच्चे खे खोलणे लगी रे थे, तेबे तेसरे मालके तिना ते पूछेया, “एस बच्चे खे कऊँ लगी रे खोलणे?” ");
INSERT INTO bfz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","तिने बोलेया, “प्रभुए खे एसते मतलब ए।” ");
INSERT INTO bfz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","सेयो तेसखे यीशुए गे लयी गे और आपणे टाले तेस बच्चे पाँदे पाई की यीशु तेस पाँदे बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","जेबे सेयो जाणे लगी रे थे, तेबे बऊत जणेया आपणी-आपणी चादरी बाटा रे बछाइतिया। ");
INSERT INTO bfz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","नेड़े आयी की जेबे सेयो जैतून पाह्ड़ो री टलाना रे पऊँछे, तेबे चेलेया री सारी मण्डल़ी, तिना सबी सामर्था रे कामो री बजअ ते, जो तिने देखे थे, खुश ऊई की जोरे-जोरे साथे परमेशरो री स्तुति करने लगी कि, ");
INSERT INTO bfz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“धन्य ए से राजा, जो प्रभुए रे नाओं ते आओआ, स्वर्गो रे शान्ति और सर्गो रे महिमा ओ।” ");
INSERT INTO bfz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तेबे पीड़ा बीचा ते कई फरीसी यीशुए खे बोलणे लगे, “ओ गुरू! आपणे चेलेया खे बक।” ");
INSERT INTO bfz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","तिने जवाब दित्तेया, “आऊँ तुसा खे बोलूँआ कि जे यो लोक चुप ऊईगे, तो पात्थर चींगणे लगी जाणे।” ");
INSERT INTO bfz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","जेबे यीशु नेड़े पऊँछे, तो नगरो खे देखी की तेस पाँदे रोणे लगे ");
INSERT INTO bfz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","और बोलेया, “पला ऊँदा कि तूँ एस दिनो रे शान्तिया री गल्ला जाणदा। पर एबे बऊत देर ऊईगी री और एबे शान्ति तेरी नजरा ते छीपी गी री। ");
INSERT INTO bfz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","कऊँकि सेयो दिन तां पाँदे आऊणे, जेबे तेरे बैरिया मोर्चा बानी की तूँ केरी लणा और चऊँ कनारे ते तूँ दबाई देणा ");
INSERT INTO bfz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","और तूँ और तेरे बाल़क, जो तां साथे ए, माट्टिया रे मलाई देणे और एती जो पात्थरो पाँदे पात्थर लगी रे, सब टाल़े जाणे। कऊँकि तैं से मोका, जेबे तां पाँदे कृपा-दृष्टि कित्ती थी, पछयाणा नि।” ");
INSERT INTO bfz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","तेबे यीशु मन्दरो रे जाई की बेचणे वाल़ेया खे बारे निकयाल़ने लगे ");
INSERT INTO bfz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","और तिना खे बोलेया, “लिखी राखेया कि मेरा मन्दर प्रार्थना रा कअर ए, पर तुसे से डाकूआ री गुफा बणाई ती।” ");
INSERT INTO bfz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","सेयो हर रोज मन्दरो रे उपदेश करो थे और बड़े पुरोईत और शास्त्री और लोका रे खास तिना खे नाश करने रा मोका टोल़ने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","पर कोई उपाय नि निकयाल़ी सके कि ये किंयाँ करिए, कऊँकि सब लोक बड़े त्यानो साथे यीशुए री सुणो थे। ");
INSERT INTO bfz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक दिन एड़ा ऊआ कि जेबे यीशु मन्दरो रे लोका खे उपदेश और सुसमाचार सुनाणे लगी रे थे, तेबे बड़े पुरोईत, शास्त्री और बुजुर्ग नेड़े आयी की खड़े ऊईगे ");
INSERT INTO bfz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","और बोलणे लगे, “आसा गे बता कि तूँ इना कामा केसरे अक्को ते करेया और से कूणे, जिने ताखे ये अक्क देई राखेया?” ");
INSERT INTO bfz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","यीशुए तिना खे जवाब दित्तेया, “आऊँ बी तुसा ते एक गल्ल पुछूँआ। माखे बी बताओ ");
INSERT INTO bfz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्ने रा बपतिस्मा स्वर्गो री तरफा ते था या मांणूए री तरफा ते?” ");
INSERT INTO bfz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","तेबे सेयो आपू बीचे बोलणे लगे, “जे आसे बोलूँगे कि स्वर्गो री तरफा ते था, तेबे एस बोलणा कि तेबे तुसे तेस पाँदे विश्वास कऊँ नि कित्तेया? ");
INSERT INTO bfz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","और जे आसे बोलूँगे कि मांणूए री तरफा ते ए, तो सबी लोका आसा खे पात्थर बाणे, कऊँकि तिना खे पक्का पता ए कि यूहन्ना भविष्यबक्ता था।” ");
INSERT INTO bfz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","तेबे तिने जवाब दित्तेया, “आसे नि जाणदे कि से केसरी तरफा ते था।” ");
INSERT INTO bfz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","यीशुए तिना खे बोलेया, “तेबे आऊँ पनि बतांदा कि आऊँ इना कामा केसरे अक्को ते करूँआ।” ");
INSERT INTO bfz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","तेबे सेयो लोका खे ये उदारण बोलणे लगे, “एकी मांणूए अँगूरा रा बगीचा लगाया और ठेकेदारा खे तिजी रा ठेका देई की बऊत दिना खे परदेशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","जेबे बखत आया तेबे तिने ठेकेदारा गे एक दास पेजेया कि से अँगूरा रे बगीचे रा कुछ इस्सा तेसखे देओ, पर ठेकेदारे से कुटी की खाली आथ पेजी ता। ");
INSERT INTO bfz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","तेबे तिने एक ओर दास पेजेया, पर तिने से बी कुटी की और तेसरी बेज्जती करी की खाली आथ पेजी ता। ");
INSERT INTO bfz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","तेबे तिने तीजा पेजेया, तेबे तिने से बी कायल करी की निकयाल़ी ता। ");
INSERT INTO bfz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तेबे तिने मालके सोचेया कि एबे आऊँ क्या करुँ? आऊँ आपणे प्यारे पाऊए खे तिना गे पेजुँआ, क्या पता सेयो तेसरा आदर करो। ");
INSERT INTO bfz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","जेबे ठेकेदारे से देखेया तो आपू बीचे बिचार करने लगे कि ये तो बारिस ए आओ एसखे काई देऊँए, ताकि जायदात म्हारी ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","तेबे तिने से अँगूरा रे बगीचे ते बारे निकयाल़ी की काई ता। तेबे अँगूरा रा बगीचे रे मालके तिना साथे क्या करना? ");
INSERT INTO bfz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","तेस आईकि तिना ठेकेदारा रा नाश करी देणा और अँगूरा रा बगीचा ओरी गे सम्बाल़ी देणा।” ये सुणी की तिने बोलेया, “परमेशर करो कि एड़ा नि ओ।” ");
INSERT INTO bfz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","यीशुए तिना री तरफा खे देखी की बोलेया, “तेबे ये क्या लिखी राखेया, “जो पात्थर राजमिस्त्रिए तुच्छ ठराई राखेया था, सेई कूणे रा सिरा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“जो कोई तेस पात्थरो पाँदे पड़ना, से चूर-चूर ऊई जाणा और जेस पाँदे ये पड़ना, तेस से पीसी देणा।” ");
INSERT INTO bfz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","तेसी बखते शास्त्रीए और बड़े पुरोईते सेयो पकड़ना चाए, कऊँकि सेयो समजी गे थे कि इने ये उदारण आसा पाँदे ई बोलेया, पर सेयो लोका ते डरी गे। ");
INSERT INTO bfz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","तेबे सेयो तिना री ताका रे रये और आपणे, पेतिये पेजे कि तर्मो रा पेष बदली की तेसरी कोई ना कोई गल्ल पकड़नी, ताकि तेसखे हाकिमो रे आथो रे और अक्को रे देई देऊँ। ");
INSERT INTO bfz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","तिने यीशुए ते पूछेया, “ओ गुरू! आसा खे पता ए कि तुसे ठीक बोलोए और सिखाओए और केसी रा पक्षपात नि करदे, पर परमेशरो री बाट सच्चाईया साथे बताओए। ");
INSERT INTO bfz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","तो क्या कैसरो खे कर देणा खरी गल्ल या नि?” ");
INSERT INTO bfz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","यीशुए तिना री चलाकी जाणी की तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“एक चाँदिए रा सिक्का मांगे बताओ। इदे केसरी मूर्ति और नाओं ए?” तिने बोलेया, “कैसरो रा।” ");
INSERT INTO bfz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","यीशुए तिना खे बोलेया, “जो कैसरो राए, से कैसरो खे देओ और जो परमेशरो राए, से परमेशरो खे देओ।” ");
INSERT INTO bfz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","सेयो लोका सामणे एसा गल्ला रे तिना खे पकड़ी नि सके, बल्कि तिना रा जवाब सुणी की हैरान ऊईगे और चुप रये। ");
INSERT INTO bfz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","तेबे सदूकी, जो बोलो थे कि मरेया रा जिऊँदा ऊणा आए ई नि, तिना बीचा ते कई जणेया आयी की यीशुए ते पूछेया, ");
INSERT INTO bfz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ओ गुरू! मूसे आसा खे ये लिखी राखेया कि जे केसी रा पाई आपणी लाड़िया रे रंदे ऊए बिना ल्वादा ते मरी जाओ, तो तेसरा पाई तेसरी लाड़िया साथे ब्या करी लो और आपणे पाईए खे कुल पैदा करो। ");
INSERT INTO bfz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","सात पाई थे पईला पाई ब्या करी की बिना ल्वादा तेई मरी गा। ");
INSERT INTO bfz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","तेबे दूजे और तीजे बी तेसा जवाणसा साथे ब्या करी ला। ");
INSERT INTO bfz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ईंयां ई सातो पाई बिना ल्वादा ते मरी गे। ");
INSERT INTO bfz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","सबी ते बाद से जवाणस बी मरी गी। ");
INSERT INTO bfz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","तेबे जिऊँदी ऊणे पाँदे से तिना बीचा ते केसरी लाड़ी ऊणी? कऊँकि से साता जणेया री लाड़ी ऊई चुकी थी।” ");
INSERT INTO bfz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीशुए तिना खे बोलेया, “एस जुगो रे लोका बीचे तो ब्या-शादिया ओईया। ");
INSERT INTO bfz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पर जो लोक एते जोगे ऊणे कि तेस जुगो खे और मरे रे बीचा ते जिऊँदे ऊणे ओ, तेबे तिना बीचे ब्या-शादिया नि ऊणिया। ");
INSERT INTO bfz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","सेयो फेर मरने पनि, कऊँकि सेयो स्वर्गदूता जेड़े ऊणे, और जिऊँदे ऊणे री ल्वाद ऊणे ते, परमेशरो री बी ल्वाद ऊणे। ");
INSERT INTO bfz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","पर ये गल्ल कि मरे रे बी फेर जिऊँदे ओए, मूसे जाड़ो री कथा रे प्रगट करी राखी कि से प्रभुए खे अब्राहम, इसहाक और याकूबो रा परमेशर करी की बोलोआ। ");
INSERT INTO bfz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","परमेशर मुड़देया रा नि, बल्कि जिऊँदेया रा परमेशर ए, कऊँकि तेसरे नेड़े सब जिऊँदे ए।” ");
INSERT INTO bfz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","तेबे ये सुणी की शास्त्रिया बीचा ते कई जणे बोलेया, “ओ गुरू! तुसे अच्छा बोलेया।” ");
INSERT INTO bfz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","तेबे तिना खे फेर तिना ते कुछ ओर पूछणे री इम्मत नि ऊई। ");
INSERT INTO bfz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","तेबे यीशुए तिना ते पूछेया, “मसीहे खे दाऊदो री ल्वाद कऊँ बोलोए? ");
INSERT INTO bfz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","दाऊद आपू ई भजनसंहिता री कताबा रे बोलोआ, “प्रभुए मेरे प्रभुए खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","मेरे दाँणे बैठ, जदुओ तक आऊँ तेरे बैरिया खे तेरे पैरा निठे नि करी देऊँ। ");
INSERT INTO bfz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“दाऊद तो तेसखे प्रभु बोलोआ, तो तेबे से तेसरी ल्वाद किंयाँ ऊआ?” ");
INSERT INTO bfz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","जेबे सब लोक सुणने लगी रे थे तेबे यीशुए आपणे चेलेया खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“शास्त्रिया ते चौकस रओ, जो लाम्बे टाले पईनी की कूमदे रओए और बजारो रे नमस्कार, और प्रार्थना रे कअरो रे खास-खास जगा और पाट्टिया रे खास जगा चाओए। ");
INSERT INTO bfz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","सेयो बिदुआ रे कअरो खे खाई जाओए और दखाणे खे मुखती देर तक प्रार्थना करोए, इना खे जादा सजा मिलणी।” ");
INSERT INTO bfz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","तेबे यीशुए आखी चकी की अमीर लोक आपणा-आपणा दान पण्डारो रे पाँदे ऊए देखे। ");
INSERT INTO bfz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","तिने एक कंगाल़ बिदुआ खे बी तिदे दो दमड़िया पाँदे ऊई देखी। ");
INSERT INTO bfz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","तेबे तिने बोलेया, “आऊँ तुसा खे सच बोलूँआ कि एसे कंगाल़ बिदुए सबी ते जादा पाई राखेया। ");
INSERT INTO bfz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","कऊँकि तिने सबी आपणिया सारिया सम्पतिया बीचा ते थोड़ा जा पाया, पर एसे आपणी कमाईया ते सारी आऊँदणी पाई ती।” ");
INSERT INTO bfz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जेबे कई जणे मन्दरो रे बारे रे बोलणे लगी रे थे कि यो कितणे सुन्दर पात्थर और पेंटा रिया चीजा साथे सजाई राखेया, तेबे तिने बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“सेयो दिन आऊणे, जेबे, जो तुसे लगी रे देखणे, तिना बीचा ते एती जो पात्थरो पाँदे पात्थर लगी रे, सब टाल़े जाणे।” ");
INSERT INTO bfz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","तिने यीशुए ते पूछेया, “ओ गुरू! ये सब कदी ऊणा? और जेबे यो सब गल्ला पुरिया ऊणे वाल़िया ऊणिया, तेबे, तेस बखतो रा क्या चिह्न् ऊणा?” ");
INSERT INTO bfz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","यीशुए बोलेया, “चौकस रओ कि कोई तुसा खे बईकाओ नि जाओ, कऊँकि बऊत जणे मेरे नाओं ते आऊणे और बोलणा कि आऊँ सेईए और ये बी कि बखत नेड़े आईगा रा, तुसे तिना पीछे नि चली जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जेबे तुसे लड़ाई और हुड़दंगा रे बारे रे सुणो, तेबे कबराणा नि, कऊँकि इना रा पईले ऊणा जरूरी ए, पर तेस बखते तेबुई अंत नि ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तेबे तिने तिना खे बोलेया, “जातिया पाँदे जातिया और राज्य पाँदे राज्य अमला करना ");
INSERT INTO bfz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","और बऊत ईल्लण ऊणे और जगा-जगा अकाल़ और बमारिया पड़नियां और सर्गो रे डराऊणिया गल्ला और बड़े-बड़े चिह्न् प्रगट ऊणे। ");
INSERT INTO bfz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","पर इना सबी गल्ला ते पईले तिना तुसे मेरे नाओं ते पकड़ने और सताणे, प्रार्थना रे कअरो रे देई देणे, जेला रे पाणे और राजेया और हाकिमो सामणे लयी जाणे। ");
INSERT INTO bfz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","पर तुसा खे ये गवाई देणे रा मोका ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","इजी री खातर आपणे-आपणे मनो रे ठाणी लो कि आसे पईले तेई जवाब देणे री चिन्ता नि करूँगे। ");
INSERT INTO bfz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","कऊँकि मां तुसा खे एड़ा बोल और बुद्धि देणी कि तुसा रे सब बिरोदी तुसा रा सामणा या खण्डन नि करी सकदे। ");
INSERT INTO bfz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","तुसा रे माए-बाओ, पाई-बईण, टब्बरो रे और दोस्ता बी तुसे पकड़वाणे, एथो तक कि तुसा बीचा ते कई जणे काई देणे। ");
INSERT INTO bfz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मेरे नाओं री वजह ते सबी लोका तुसा ते बैर राखणा। ");
INSERT INTO bfz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","पर तुसा रे सिरो रा एक बी बाल़ बांगा नि ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","आपणे सब्रो ते तुसा आपणे प्राण बचाणे। ");
INSERT INTO bfz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“जेबे तुसे यरूशलेमो खे सेना ते घिरे रा देखो, तो जाणी लणा कि तीजी रा नाश नेड़े ए। ");
INSERT INTO bfz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","तेबे जो यहूदिया प्रदेशो रे ओ, तिने पाह्ड़ो खे नठी जाणा और जो यरूशलेमो नगरो रे पीतरे ओ, सेयो बारे निकल़ी जाएओ और जो गांव रे ओ। सेयो तिदे नि जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","कऊँकि यो बदला लणे रे एड़े दिन ऊणे, जिना रे लिखी रिया सारिया गल्ला पुरिया ऊई जाणिया। ");
INSERT INTO bfz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","तिना दिना रे जो गर्भवती और दूद पल़याणे वाल़ी ऊणी, तिना खे हाय! हाय! कऊँकि देशो रे बड़ा क्ल़ेश और लोका पाँदे बड़ा प्रकोप ऊणा। ");
INSERT INTO bfz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","सेयो तलवारा रे ग्रा ऊई जाणे और बऊत सारे देशो रे लोका बीचे बन्दुए ऊई की पऊँछाए जाणे और जदुओ तक दुजिया जातिया रा बखत पूरा नि ऊई जाणा, तदुओ तक यरूशलेम दुजिया जातिया साथे केसेया जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“सूरज, चाँद और तारेया रे चिह्न् दिखणे और तरतिया पाँदे देशो-देशो रे जातिया रे लोका खे संकट ऊणा, कऊँकि सेयो समुद्रो रे गिड़ने और लईरा री छेड़ा ते कबराई जाणे ");
INSERT INTO bfz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","और डरो रे मारे और दुनिया रे आऊणे वाल़ी घटणा री बाट देखदे-देखदे लोका रे जानी पाँदे जान नि रणी, कऊँकि सर्गो रिया शक्तिया इलाईया जाणिया। ");
INSERT INTO bfz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तेबे तिना माणूं रा पुत्र सामर्थ और बड़ी महिमा साथे बादल़ो पाँदिए आऊँदा ऊआ देखणा। ");
INSERT INTO bfz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जेबे यो गल्ला ऊणे लगो, तेबे सीदे ऊई की आपणा सिर ऊबे चकणा, कऊँकि तुसा रा छुटकारा नेड़े ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","यीशुए तिना खे एक उदारण बी बोलेया, “दाऊगल़े रे डाल़ो खे और सबी डाल़ा खे बी देखो। ");
INSERT INTO bfz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जिंयाँ ई तिना रे पलँगूर निकल़ोए, तेबे तुसे देखी की आपू ई जाणी लओए कि तऊँदी नेड़े ए। ");
INSERT INTO bfz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ईंयां ई जेबे तुसे इना गल्ला खे ऊँदे ऊआ देखो, तेबे जाणी लो कि परमेशरो रा राज्य नेड़े ए। ");
INSERT INTO bfz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","आऊँ तुसा खे सच लगी रा बोलणे कि जदुओ तक यो सब गल्ला पूरिया नि ऊई जाओगिया, तदुओ तक एसा पीढ़िया रे लोका री मौत नि ऊणी। ");
INSERT INTO bfz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","सर्ग और तरती टल़ी जाओगी, पर मेरा वचन कदी नि टल़ना। ");
INSERT INTO bfz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","इजी री खातर सावधान रओ, एड़ा नि ओ कि तुसा रे मन, खुमार, मतवाल़ापण और एसा जिन्दगिया री चिन्ता ते सुस्त ऊई जाओ और सेयो दिन तुसा पाँदे फंदे जेड़ा अचाणक आयी जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“कऊँकि से सारी तरतिया पाँदे और सब रणे वाल़ेया पाँदे ईंयां ई पड़ना। ");
INSERT INTO bfz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","इजी री खातर जागदे रओ, हर बखत प्रार्थना करदे रओ, ताकि तुसे इना सबी आऊणे वाल़िया घटणा ते बचणे, और माणूं रे पुत्रो सामणे खड़े ऊणे जोगे बणो।” ");
INSERT INTO bfz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","यीशु दिने मन्दरो रे उपदेश करो थे और राती बारे जाई की जैतून नाओं रे पाह्ड़ो पाँदे रओ थे ");
INSERT INTO bfz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","और प्यागा तड़के सब लोक तिना री सुणने खे मन्दरो रे तिना गे आया करो थे। ");
INSERT INTO bfz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","बिना सजेड़े री रोटिया रा त्योआरो, जेतेखे फसह रा त्योआर बी बोलोए, नेड़े था ");
INSERT INTO bfz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","और बड़े पुरोईत और शास्त्री एड़ी गल्ला री टोल़ा रे थे कि यीशुए खे किंयाँ मरवाईए, पर सेयो लोका ते डरो थे। ");
INSERT INTO bfz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","तेबे शैतान यहूदा रे समायी गा, जेसखे, इस्करियोती बी बोलोए और बारा चेलेया बीचे गिणेया जाओ था। ");
INSERT INTO bfz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","तिने जाई की बड़े पुरोईत और पईरेदारा रे सरदारा साथे गल्ल कित्ती कि यीशुए खे तिना रे आथो रे किंयाँ पकड़वाईये। ");
INSERT INTO bfz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","सेयो खुश ऊईगे और तेसखे पैसे देणे रा वचन दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","से मानी गा और बिना उपद्रवो ते यीशुए खे तिना रे आथो रे पकड़वाणे रा मोका लगेया टोल़ने। ");
INSERT INTO bfz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","तेबे बिना सजेड़े री रोटिया रा त्योआरो था, जिदे फसह रे त्योआरो रा मिन्टू बलि करना जरूरी था। ");
INSERT INTO bfz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","यीशुए पतरस और यूहन्ना ये बोली की पेजे, “जाई की आसा खे खाणे खे फसह रे त्योआरो री रोटी त्यार करो।” ");
INSERT INTO bfz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","तिने तिना ते पूछेया, “तुसे केयी चाओए कि आसे तुसा खे फसह त्यार करुँ?” ");
INSERT INTO bfz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","यीशुए तिना खे बोलेया, “देखो नगरो रे जांदे ई तुसा खे एक मांणू पाणिए रा कअड़ा चकी की मिलणा, जेते कअरो रे से जाओ, तुसे तेस पीछे चली जाणा ");
INSERT INTO bfz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","और तेस कअरो रे मालको खे बोलणा कि गुरूए ताखे बोली राखेया कि से मईमाना रा कमरा केयी ए, जेती आऊँ आपणे चेलेया साथे फसह रे त्योआरो री रोटी खाऊँ? ");
INSERT INTO bfz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","तेस तुसा खे एक सजी-सजाई री बाऊड़ो दखाणी, तुसे तेथी त्यारी करनी।” ");
INSERT INTO bfz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","चेलेया जाई की तेड़ा ई पाया, जेड़ा यीशुए तिना खे बोलेया था तेड़ा ई पाया और फसह रे त्योआरो री रोटी त्यार कित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जेबे बखत आया तेबे सेयो प्रेरिता साथे रोटी खाणे बैठे। ");
INSERT INTO bfz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","तेबे यीशुए तिना खे बोलेया, “मेरी बड़ी इच्छा थी कि दु:ख सईन करने और मेरे मरने ते पईले तुसा साथे ये फसह रे त्योआरो री रोटी खाऊँ। ");
INSERT INTO bfz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","कऊँकि आऊँ तुसा खे बोलूँआ कि जदुओ तक से परमेशरो रे राज्य रे पूरा नि ओ, तदुओ तक मां से कदी नि खाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","तेबे तिने अँगूरो रे रसो रा कटोरा लयी की परमेशरो रा धन्यवाद कित्तेया और बोलेया, “पकड़ो और आपू बीचे बांडी लओ। ");
INSERT INTO bfz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","कऊँकि आऊँ तुसा खे बोलूँआ कि जदुओ तक परमेशरो रा राज्य नि आओ, तदुओ तक मां अँगूरा रा रस आजो ते कदी नि पीणा।” ");
INSERT INTO bfz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","तेबे तिने रोटी लयी और धन्यवाद करी की तोड़ी और तिना खे ये बोली कि दित्ती, “ये मेरा शरीर ए, जो तुसा खे देणे लगी रा, मेरी यादा रे एड़ा ई करेया करना।” ");
INSERT INTO bfz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ईंयां ई तिने रोटिया ते बाद कटोरा लया और ये बोलदे ऊए दित्तेया, “ये कटोरा मेरे तेस खूनो दे, जो तुसा री खातर बाह्या जाओआ, नयी वाचा ए। ");
INSERT INTO bfz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पर देखो, मेरे पकड़वाणे वाल़े रा आथ मां साथे मेजो पाँदे ए। ");
INSERT INTO bfz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","कऊँकि आँऊ माणूं रा पुत्र, जेड़ा मेरे बारे रे ठराई राखेया, जाणा ई ये। पर हाय! तेस मांणूए खे जेसरी बजअ ते आँऊ पकड़वाया जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","तेबे सेयो आपू-बीचे बात-चीत करने लगे कि आसा बीचा ते एड़ा कूणे जेस एड़ा काम करना? ");
INSERT INTO bfz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","तिना बीचे ये बईस बी ऊणे लगी कि आसा बीचा ते बड़ा कुण ए? ");
INSERT INTO bfz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","यीशुए तिना खे बोलेया, “दुजिया जातिया रे राजा तिना पाँदे राज करोए और जो तिना पाँदे अक्क राखोए, तिना खे उपकारक बोलोए। ");
INSERT INTO bfz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पर तुसे एड़े नि ऊणा, बल्कि जो तुसा बीचे बड़ा ए, से छोटेया जेड़ा और जो बड़ा ए, से सेवको जेड़ा बणो। ");
INSERT INTO bfz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","कऊँकि बड़ा कुण ए? क्या से जो रोटिया पाँदे बैठी रा या से जो सेवा करने लगी रा? क्या से नि जो रोटिया पाँदे बैठी रा? पर आऊँ तुसा बीचे सेवको जेड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“पर तुसे सेयो ए, जो परीक्षा रे लगातार मां साथे रये ");
INSERT INTO bfz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","और जिंयाँ मेरे पिते माखे एक राज्य ठराई राखेया। ");
INSERT INTO bfz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","तिंयाँ ई आऊँ बी तुसा खे ठराऊँआ, ताकि तुसे मेरे राज्य रे मां साथे खाओ-पियो, बल्कि सिंहासनो रे बैठी की इस्राएलो रे बारा गोत्रा रा न्याय करो। ");
INSERT INTO bfz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“शमौन, ओ शमौन! देख, शैताने तुसे लोक मांगी लये रे, ताकि कणका जेड़े फड़ाकुओ। ");
INSERT INTO bfz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पर मैं तेरिया तंईं प्रार्थना कित्ती कि तुसे मां पाँदे विश्वास करना नि छाडी देओ, और जेबे तूँ आपणा मन फेरो, तो आपणे पाई मजबूत करने।” ");
INSERT INTO bfz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","तिने बोलेया, “ओ प्रभु! आऊँ तुसा साथे जेला रे जाणे खे, बल्कि मरने खे बी त्यार ए।” ");
INSERT INTO bfz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","प्रभुए बोलेया, “ओ पतरस! आऊँ ताखे बोलूँआ कि आज मुर्गे बांग नि देणी, जदुओ तक तूँ माखे तीन बार जाणने ते नि मुकरना।” ");
INSERT INTO bfz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","यीशुए तिना खे बोलेया, “जेबे मैं तुसे सुसमाचार प्रचार करने बटुए, चोल़ी और जोड़ेया ते बिना पेजे थे, तेबे क्या तुसा खे किजी चीजा री कमी ऊई?” तिने बोलेया, “किजी चीजा री नि।” ");
INSERT INTO bfz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","तेबे यीशुए बोलेया, “पर एबे जेसगे बटुआ ए, से लयी लो और तिंयाँ ई चोल़ा बी और जेसगे तलवार निए, से आपणे टाले बेची की एक खरीदी लो। ");
INSERT INTO bfz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","कऊँकि आऊँ तुसा खे बोलूँआ कि ये जो पवित्र शास्त्रो रे लिखी राखेया, ‘से अपराधिया साथे गिणेया गया।’ से मां पाँदे ऊणा जरूरी ए, कऊँकि मेरे बारे रिया गल्ला पुरिया ऊणे वाल़िया ए।” ");
INSERT INTO bfz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","चेलेया बोलेया, “ओ प्रभु! देखो, एती दो तलवारी आए, तिने बोलेया बऊत ए।” ");
INSERT INTO bfz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तेबे यीशु बारे निकल़ी की आपणी रवाजा रे मुताबिक जैतूनो रे पाह्ड़ो पाँदे गये और चेले बी तिना पीछे चली गे। ");
INSERT INTO bfz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","तेते जगा रे पऊँछी की तिने आपणे चेलेया खे बोलेया, “प्रार्थना करदे रओ, ताकि परीक्षा रे नि पड़ो।” ");
INSERT INTO bfz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","तेबे सेयो आपू तिना ते थोड़ी जी दूर चली गे और कुटणे टेकी की प्रार्थना करने लगे ");
INSERT INTO bfz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","और बोलणे लगे, “ओ पिता! जे तुसे चाओ तो एस दु:खो खे मांगा गे ते दूर करी सकोए, तेबे बी मेरी इच्छा नि पर तुसा री इच्छा पूरी ओ।” ");
INSERT INTO bfz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तेबे स्वर्गो ते एक स्वर्गदूत तिना खे दिशेया, जो तिना खे सामर्थ देयो था। ");
INSERT INTO bfz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","तेबे सेयो जादा मुश्किला रे, व्याकुल ऊई की ओर बी दिलो ते दु:खी ऊई की प्रार्थना करने लगे और तिना रा पसीना, मानो खूनो रे बड़े-बड़े टीपेया जेड़ा जमीना पाँदे छुटणे लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","तेबे सेयो प्रार्थना करी की उठे और आपणे चेलेया गे गये ओर तिने सेयो उदास ऊई की सये रे देखे। ");
INSERT INTO bfz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","और तिना खे बोलेया, “सऊणे कऊँ लगी रे? उठो और प्रार्थना करो, ताकि परीक्षा रे नि पड़ो।” ");
INSERT INTO bfz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","सेयो ये बोलणे ई लगी रे थे कि एक बड़ी पीड़ तिना गे आयी और तिना बारा बीचा ते, एक जेसरा नाओं यहूदा था, तिना ते आगे-आगे आऊणे लगी रा था और से यीशुए गे आया, ताकि तेसखे चूमो। ");
INSERT INTO bfz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","यीशुए तेसखे बोलेया, “ओ यहूदा! क्या तूँ माणूं रे पुत्रो खे चूमा लयी की पकड़वाएया?” ");
INSERT INTO bfz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","तिना रे साथिये जेबे देखेया कि क्या ऊणे वाल़ा ए, तेबे बोलेया, “ओ प्रभु! क्या आसे तलवार चलाऊँ?” ");
INSERT INTO bfz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","तेबे तिना बीचा ते एकी जणे प्रदान पुरोईतो रे दासो पाँदे तलवार चलाई की तेसरा दाँणा कान ऊड़ाई ता। ");
INSERT INTO bfz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","तेबे यीशुए बोलेया, “एबे बस करो” और तेसरा कान छुँईं की से ठीक करी ता। ");
INSERT INTO bfz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तेबे यीशुए बड़े पुरोईतो ते, मन्दरो रे पईरा देणे वाल़े सरदारो ते, बुजुर्गा ते और जो तिना पाँदे चढ़ने लगी रे थे, तिना खे बोलेया, “क्या तुसे आऊँ डाकू समजी राखेया जो माखे पकड़ने खे तलवारी और डण्डे लयी की निकल़ी रे? ");
INSERT INTO bfz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","जेबे आऊँ मन्दरो रे हर दिन तुसा साथे था, तेबे तो तुसे मां पाँदे आथ नि पाया। पर ये तुसा रा बखत ए और न्हेरे रा अक्क ए।” ");
INSERT INTO bfz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","तेबे सेयो तिना खे पकड़ी की प्रदान पुरोईतो रे आँगणो रे ल्याए और पतरस दूरो-दूरो तेई तिना पीछे-पीछे आईगा ");
INSERT INTO bfz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","और जेबे सेयो आँगणो रे आग बाल़ी की बैठी रे थे, तेबे पतरस बी तिना बीचे बैठे गा। ");
INSERT INTO bfz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","तेबे एक दासी तेसखे आगी रे प्रयासे रे देखी की और तेसरे कनारो खे ताकि की बोलणे लगी, “ये बी तो तेस साथे था?” ");
INSERT INTO bfz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पर तिने ये बोली की ना करी ती कि, “ओ जवाणसे! आऊँ तेसखे नि जाणदा।” ");
INSERT INTO bfz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोड़ी देर बाद किने ओरी तेसखे देखी की बोलेया, “तूँ बी तो तिना बीचा ते ए,” पतरसे बोलेया, “ओ मांणू! आऊँ निए।” ");
INSERT INTO bfz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","तेबे कोई एक कंटे ते बाद एक ओर मांणू पक्का ऊई की बोलणे लगेया, “पक्का ये बी तेस साथे था, कऊँकि ये बी गलीली ए।” ");
INSERT INTO bfz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरसे बोलेया, “ओ मांणू! आऊँ नि जाणदा कि तूँ क्या लगी रा बोलणे?” से ये बोलणे ई लगी रा था कि तेबुई मुर्गे बांग दित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","तेबे यीशुए तेसखे मुड़ी की देखेया, तेबे पतरसो खे तिना री गल्ल याद आयी, जो तिने बोली थी कि, “आज मुर्गे री बांग देणे ते पईले तूँ माखे तीन बार जाणने ते मुकरना।” ");
INSERT INTO bfz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","तेबे से बारे निकल़ी की फूटी-फूटी की रोणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जिने मांणूए यीशु पकड़ी राखे थे, सेयो तिना रा मजाक ऊड़ाणे लगे और टीशणे लगे ");
INSERT INTO bfz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","और तिना रिया आखी टखी की तिना ते पूछेया, “भविष्यबाणी करी की बता कि तांदे किने बाई?” ");
INSERT INTO bfz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","तेबे तिने ओर बी बऊत निन्दा रिया गल्ला तिना रे बिरोदो रे बोलिया। ");
INSERT INTO bfz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जेबे दिन ऊआ तेबे, बुजुर्गे, बड़े पुरोईते और शास्त्रिए तिना खे आपणी बड़ी सभा रे ल्याई की पूछेया, ");
INSERT INTO bfz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“जे तूँ मसीह ए, तो आसा गे बताई दे।” यीशुए बोलेया, “जे आऊँ बोलूँगा तो तुसा विश्वास नि करना। ");
INSERT INTO bfz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","और जे पूछूँ तो जवाब नि देणा। ");
INSERT INTO bfz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","पर आजो ते आँऊ माणूं रा पुत्र सर्वशक्तिमान् परमेशरो रे दाँणे कनारे बैठे रा रणा।” ");
INSERT INTO bfz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ये सुणी की सबी जणे बोलेया, “तो क्या तूँ परमेशरो रा पुत्र ए?” तिने तिना खे बोलेया, “तुसे आपू ई बोलणे लगी रे, कऊँकि आऊँ आए।” ");
INSERT INTO bfz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","तेबे तिने बोलेया, “एबे आसा खे गवाईया री क्या जरूरत ए, कऊँकि आसे आपू ई एसरे मुंओ ते सुणी ता रा।” ");
INSERT INTO bfz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तेबे सारी सभा उठी की तिना खे पिलातुसो गे लयी गी। ");
INSERT INTO bfz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","सेयो ये बोली की तिना पाँदे दोष लगाणे लगे, “आसे ये लोका खे रोमी सरकारा रे खलाफ बरोद करने खे बईकांदे ऊए और कैसरो खे कर देणे खे ना करदे ऊए और आपू खे मसीह, राजा बोलदे ऊए सुणी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पिलातुसे तेसते पूछेया, “क्या तूँ यहूदिये रा राजा ए?” यीशुए तेसखे बोलेया, “तूँ आपू ई लगी रा बोलणे।” ");
INSERT INTO bfz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तेबे पिलातुसे बड़े पुरोईत और लोका खे बोलेया, “आऊँ एस मांणूए रे कोई दोष नि देखदा।” ");
INSERT INTO bfz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","पर सेयो ओर बी पक्के ऊई की बोलणे लगे, “ये गलीलो ते लयी की एथो तक, सारे यहूदिया रे उपदेश देई-देई की लोका खे उकसाओआ।” ");
INSERT INTO bfz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ये सुणी की पिलातुसे पूछेया, “क्या ये मांणू गलीलो रा रणे वाल़ा ए?” ");
INSERT INTO bfz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","तेबे ये जाणी की कि ये हेरोदेसो री रियासता राए, से हेरोदेसो गे पेजी ता, कऊँकि तिना दिना रे से बी यरूशलेमो रे था। ");
INSERT INTO bfz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदेस यीशुए खे देखी की बऊत खुश ऊईगा, कऊँकि से बऊत दिना ते तिना खे देखणा चाओ था, कऊँकि तिने तिना रे बारे रे सुणी राखेया था और यीशुए ते कोई चिह्न् देखणे री उम्मीद राखो था। ");
INSERT INTO bfz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","तेबे से तिना ते मुखती गल्ला पूछदा रया, पर तिने तेसखे कुछ बी जवाब नि दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","तेबे बड़े पुरोईत और शास्त्री खड़े ऊई की तनो-मनो साथे तिना पाँदे दोष लगांदे रये। ");
INSERT INTO bfz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तेबे हेरोदेसे आपणे सिपाईया साथे तिना रा मजाक उड़ाया और भड़किले टाले पणयाई की पिलातुसो गे वापस पेजी ता। ");
INSERT INTO bfz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","तेसी दिनो ते हेरोदेस और पिलातुस दोस्त बणी गे, इजी ते पईले सेयो एकी-दूजे रे बैरी थे। ");
INSERT INTO bfz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुसे बड़े पुरोईत, अधिकारी और लोक बुलाई की तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“तुसे एस मांणूए खे लोका खे रोमी सरकारा रे खलाफ बरोद करने खे बईकाणे वाल़ा बोली की मांगे ल्याई राखे और देखो, मैं तुसा सामणे एसरी जांच कित्ती, पर जिना गल्ला रा तुसे एस पाँदे दोष लगी रे लगाणे, तिना गल्ला रे मैं एसरे कोई बी दोष नि पाया। ");
INSERT INTO bfz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ना ई हेरोदेसे, कऊँकि तिने ये आसा गे वापस पेजी ता रा और देखो, एसते एड़ा कुछ नि ऊई रा, जेतेरी बजअ ते एसखे मृत्यु दण्ड मिलो। ");
INSERT INTO bfz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","तेबे आऊँ तेसखे कोड़े लगवाई की छाडी देऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","यहूदिया रे फसह रे त्योआरो रे दिने पिलातुस हर साल एकी कैदियो खे तिना खे छाडी देओ था। ");
INSERT INTO bfz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","तेबे सब मिली की चींगणे लगे, “एसरा काम-तमाम कर और आसा खे बरअब्बे खे छाडी दे।” ");
INSERT INTO bfz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ये सेईए जो हुड़दंगो री बजअ ते, जो नगरो रे ऊआ था और अत्या री बजअ ते जेला रे पायी ता था। ");
INSERT INTO bfz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पर पिलातुसे यीशुए खे छाडणे री इच्छा ते लोक फेर समजयाए। ");
INSERT INTO bfz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","पर तिने चींगी की बोलेया, “एसखे क्रूसो पाँदे चढ़ाई देओ, क्रूसो पाँदे।” ");
INSERT INTO bfz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","तिने तीजी बार तिना खे बोलेया, “कऊँ, इने कुण जी बुराई करी राखी? मैं एसरे मृत्यु दण्डो लायक कोई बी गल्ल नि देखी। इजी री खातर आऊँ एसखे कुटवाई की पेजी देऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पर सेयो चींगी-चींगी की पीछे ई पड़ी गे कि एसखे क्रूसो पाँदे चढ़ाओ और तिना रा चींगणा प्रबल ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","तेबे पिलातुसे आज्ञा दित्ती कि इना री बिनतिया रे मुताबिक कित्तेया जाओ। ");
INSERT INTO bfz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","तिने से मांणू जो हुड़दंग और अत्या री बजअ ते जेला रे पाया था और जेसखे सेयो माँगो थे, छाडीता और यीशु तिना री इच्छा रे मुताबिक तिना रे आथो रे देई ते। ");
INSERT INTO bfz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जेबे सेयो यीशुए खे नीणे लगी रे थे, तेबे तिने शमौन नाओं रा एक कुरेनी मांणू, जो दूजे गांव ते आऊणे लगी रा था, तेसी बखते से तिसिये निकल़ेया, पकड़ी की तेस पाँदे क्रूस लादी ता, ताकि एसखे यीशुए पीछे लयी चलो। ");
INSERT INTO bfz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","तेबे लोका री बड़ी पीड़ तिना पीछे चली पड़ी और मुखती जवाणसा बी, जो तिना पीछे रोओ थिया और छाती पीटो थिया। ");
INSERT INTO bfz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीशुए तिना खे मुड़ी की बोलेया, “ओ यरूशलेमो री बेटियो! माखे नि रोओ, बल्कि आपू और आपणे बाल़का खे रोओ जो तुसा साथे ऊणे वाल़ा ए ");
INSERT INTO bfz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","कऊँकि सेयो दिन आऊणे, जेबे बोलणा कि धन्य ए से जवाणसा जो बांझ ए और से गर्भ जिने बच्चे पैदा नि कित्ते और सेयो स्तन जिने दूद नि पल़याया। ");
INSERT INTO bfz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","तेस बखते तिना पाह्ड़ो ते बोलणा कि आसा पाँदे आयी जाओ और टिलेया खे कि आसा खे टखी देओ। ");
INSERT INTO bfz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“कऊँकि जेबे सेयो अरेया डाल़ा साथे एड़ा करोए, तो सूकेया साथे क्या कुछ नि करेया जाणा।” ");
INSERT INTO bfz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","सिपाई यीशुए साथे दो ओर मांणूआ खे जो कुकर्मी थे, काणे खे लयी चले। ");
INSERT INTO bfz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","तेबे सेयो तेते जगा रे जेतेखे खोपड़ी बोलो थे, पऊँछे, तेबे तिने तेती यीशु और सेयो दो जणे जो कुकर्मी थे, एक दाँणे कनारे और दूजा खूँजे कनारे क्रूसो पाँदे चढ़ाए। ");
INSERT INTO bfz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","तेबे यीशुए बोलेया, “ओ पिता! इना खे माफ कर, कऊँकि यो नि जाणदे कि क्या लगी रे करने?” और तिने चिट्ठिया पायी की तिना रे टाले बांडी ते। ");
INSERT INTO bfz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","लोक खड़े-खड़े देखणे लगी रे थे और अधिकारी बी मजाक करी-करी की बोलो थे, “इने ओर बचाए, जे ये परमेशरो रा मसीह ए और तेसरा चूणे राए, तो आपणे आपू खे बचाई लो।” ");
INSERT INTO bfz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सिपाई बी नेड़े आओ थे और सिरका देई की तिना रा मजाक करी की बोलो थे, ");
INSERT INTO bfz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“जे तूँ यहूदिया रा राजा ए, तो आपू खे बचा।” ");
INSERT INTO bfz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","तिना पाँदे एक दोष-पत्र बी था लगे रा कि, “ये यहूदिया रा राजा ए।” ");
INSERT INTO bfz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","जो कुकर्मी लटाकाई राखे थे, तिना बीचा ते एकी जणे यीशुए री निन्दा करी की बोलेया, “क्या तूँ मसीह निए? तो आपू और आसा खे बचा।” ");
INSERT INTO bfz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","तेबे दूजे जणे तेसखे बकी की बोलेया, “क्या तूँ परमेशरो रा डर पनि मानदा? तूँ बी तो सेई सजा पुगतणे लगी रा। ");
INSERT INTO bfz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","आसे तो न्याय रे मुताबिक सजा पाणे लगी रे, कऊँकि आसे आपणे कामो रा अच्छा फल लगी रे पाणे, पर इने कोई बी बुरा काम नि कित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तेबे तिने बोलेया, “ओ यीशु! जेबे तूँ आपणे राज्य रे आए, तो मेरी सम्बाल़ बी लयी लया।” ");
INSERT INTO bfz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","तिने तेसखे बोलेया, “आऊँ ताखे सच लगी रा बोलणे कि तूँ आज ई मां साथे स्वर्गलोको रे ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","और तकरीबन दोपईरो रे तीजे पईरो तक सारे देशो रे न्हेरा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","और सूरजो रा प्रयासा चली गा, तेबे मन्दरो रा पड़दा पाँदो ते लई की थालो तक फटीगा और तिजी रे दो टुकड़े ऊईगे। ए ये दखाओ कि एबे कोई मांणू परमेशरो री हजुरिया रे जाई सकोआ। ");
INSERT INTO bfz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","तेबे यीशुए जोरे की बोलेया, “ओ पिता! आऊँ आपणी आत्मा तुसा रे आथो रे सम्बाल़ूँआ और ये बोली की तिने प्राण छाडी ते।” ");
INSERT INTO bfz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","सूबेदारे जो कुछ ऊई रा था देखी की परमेशरो री तारीफ कित्ती और बोलेया, “सच्ची ये मांणू तर्मी था।” ");
INSERT INTO bfz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","तेबे पीड़ जो ये देखणे खे कट्ठी ऊई री थी, ये घटणा देखी की छाती पिटदी ऊई वापस ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","पर तिना रे सब जाण-पछयाण वाल़े और जो जवाणसा गलील प्रदेशो ते तिना साथे आयी रिया थिया, दूर खड़िया ऊई की ये सब देखणे लगी री थिया। ");
INSERT INTO bfz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","तेती यूसुफ नाओं रा बड़ी सभा रा एक सदस्य था, जो पला और तर्मी मांणू था ");
INSERT INTO bfz_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","और तिना री योजना और तिना रे इना कामो ते खुश नि था। से यहूदिया रे नगर अरिमतियाह रा रणे वाल़ा था और परमेशरो रे राज्य री बाट न्याल़ने वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","तिने पिलातुसो गे जाई की यीशुए री लोथ मांगी। ");
INSERT INTO bfz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","और से उतारी की मलमलो री चादरी रे लपेटी और कब्रा रे राखी, जो चट्टानी रे खणी राखी थी और तिदे कदी कोई नि राखी राखेया था। ");
INSERT INTO bfz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","से त्यारिया रा दिन था और आरामो रा दिन शुरू ऊणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","तिने जवाणसे जो गलीलो ते तिना साथे आयी री थिया, पीछे-पीछे जाई की से कब्र देखी और ये बी कि तिना री लोथ किंयाँ थी राखी री। ");
INSERT INTO bfz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","तेबे तिने आपणे कअरे वापस आयी की खुशबूदार चीजा और इत्र यीशुए रे शरीरो पाँदे मल़ने खे त्यार कित्तेया और आरामो रे दिने तिने आज्ञा रे मुताबिक आराम कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","तेबे सेयो अफ़्ते रे पईले दिने प्यागा-प्यागा खुशबूदार चीजा जो तिने त्यार कित्तिया थिया, कब्रा पाँदे लयी की आईया। ");
INSERT INTO bfz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","तिने पात्थर कब्रा पाँदा ते कनारे पाँदे खसकेया रा देखेया। ");
INSERT INTO bfz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","पर पीतरे जाई की यीशुए री लोथ नि पायी। ");
INSERT INTO bfz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","जेबे सेयो एसा गल्ला ते हैरान ऊणे लगी री थिया, तेबे दो मांणू सफेद टाले पईनी की तिना सामणे खड़े ऊईगे,मतलब दो स्वर्गदूत एकदम आयी तिना सामणे खड़े ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","जेबे सेयो डरी गिया और तरतिया कनारे खे मूँ जूँगेया रा राखेया, तेबे तिने तिना खे बोलेया, “तुसे जिऊँदे खे मरे रेया बीचे कऊँ लगी रिया टोल़ने? ");
INSERT INTO bfz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","से एती निए बल्कि जिऊँदा ऊईगा रा, याद करो कि तिने गलीलो रे रंदे ऊए तुसा खे बोलेया था, ");
INSERT INTO bfz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","जरूरी ए कि आँऊ माणूं रा पुत्र पापिया रे आथो रे पकड़वाया जाओ और क्रूसो पाँदे लटकाया जाओ और तीजे दिने जिऊँदा ऊई जाओ।” ");
INSERT INTO bfz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तेबे यीशुए रिया गल्ला तिना खे याद आईया। ");
INSERT INTO bfz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","तेबे तिने कब्रा ते वापस ऊई कि तिना ग्यारा जणेया खे और ओरी सबी खे, यो सब गल्ला बताईया। ");
INSERT INTO bfz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जिने प्रेरिते यो सब गल्ला बोलिया, सेयो, मरियम मगदलिनी, यूहन्ना और याकूबो री आम्मा मरियम और तिना साथलिया ओर बी जवाणसा थिया। ");
INSERT INTO bfz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पर तिना खे तिना री गल्ला काणियां जेड़िया लगीया और तिने तिना रा विश्वास नि कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तेबे पतरस उठी की कब्रा आओखे दौड़ी की चली गा और तिने नपी की बस टाले ई पड़े रे देखे और जो ऊआ था तिजी ते हैरान ऊई की कअरो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","तेबे तेसी दिने तिना बीचा ते दो चेले इम्माऊस नाओं रे गांव खे जाणे लगी रे थे, जो यरूशलेमो ते तकरीबन ग्यारा किलोमीटर दूर था। ");
INSERT INTO bfz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","सेयो इना सबी गल्ला खे, जो ऊई रिया थिया, आपू बीचे बातचीत करदे ऊए चली रे थे ");
INSERT INTO bfz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","और जेबे सेयो आपू बीचे बातचीत और पूछताछ करने लगी रे थे, तेबे यीशु आपू तिना साथे-साथे चलणे लगे। ");
INSERT INTO bfz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पर तिना री आखिया एड़िया बंद करी ती थिया कि सेयो तिना खे पछयाणी नि सके। ");
INSERT INTO bfz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","यीशुए तिना ते पूछेया, “यो केड़िया गल्ला ए, जो तुसे चलदे-चलदे ऊए आपू बीचे करने लगी रे?” सेयो उदास जे खड़े रे रई गे। ");
INSERT INTO bfz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ये सुणी की तिना बीचा ते क्लियुपास नाओं रे मांणूए बोलेया, “क्या तूँ यरूशलेमो रे कल्ला परदेशी ए, जो जाणदा नि कि आजकाल तेती क्या ऊई रा?” ");
INSERT INTO bfz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","तिने तिना ते पूछेया, “कुण जीया गल्ला?” तिने बोलेया, “यीशु नासरियो रे बारे रे, जो परमेशर और सबी लोका रे नेड़े काम और वचनो रे सामर्थी भविष्यबक्ता था ");
INSERT INTO bfz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","और बड़े पुरोईत और म्हारे अधिकारिए से पकड़वाईता, ताकि तेसखे मौता री सजा दित्ती जाओ और से क्रूसो पाँदे चढ़ाया। ");
INSERT INTO bfz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","पर आसा खे उम्मीद थी कि एस ई इस्राएलो खे छुटकारा देणा और इना सबी गल्ला ते अलावा एसा घटणा खे आज तीजा दिन ए। ");
INSERT INTO bfz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","और एबे आसा बीचा ते बी कई जवाणसे आसे हैरानिया रे पायी ते रे, जो आज प्यागा कब्रा पाँदे गईया थिया ");
INSERT INTO bfz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","और जेबे तेसरी लोथ नि मिली, तेबे ये बोलदिया ऊईया आईया कि आसे स्वर्गदूता रा दर्शन पायी राखेया, जिने आसा गे बताया कि यीशु जिऊँदा ए। ");
INSERT INTO bfz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","तेबे आसा रे साथिया बीचा ते कई जणे तेती गये और जेड़ा तिने जवाणसे बोलेया था, तेड़ा ई पाया, पर से नि देखेया।” ");
INSERT INTO bfz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तेबे यीशुए तिना दो चेलेया खे बोलेया, “ओ मूर्खो! और भविष्यबक्तेया रिया सबी गल्ला रे विश्वास करने रे मंदबुध्दियो! ");
INSERT INTO bfz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","क्या ये जरूरी नि था कि मसीह एस दु:खो ते बाद आपणी महिमा रे आओ?” ");
INSERT INTO bfz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","तेबे तिने मूसे ते और सबी भविष्यबक्तेया ते शुरूओ ते और सारे पवित्र शास्त्रा बीचा ते, आपणे बारे रे लिखी रिया सबी गल्ला रा मतलब तिना खे समजयाई ता। ");
INSERT INTO bfz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","तदुओ कि सेयो तेस गांव रे पऊँछी गे, जेती सेयो जाणे लगी रे थे और यीशुए रे चलणे ते एड़ा लगो था कि सेयो आगे जाणा चाओए। ");
INSERT INTO bfz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","पर तिने सेयो ये बोली की रोके, “आसा साथे रओ, कऊँकि साँज ऊईगी री।” तेबे सेयो तिना साथे पीतरे रणे खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","जेबे यीशु तिना साथे रोटी खाणे बैठे, तेबे तिने रोटी तोड़ी की धन्यवाद कित्तेया और तोड़ी की तिना खे देणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तेबे तिना री आखिया खुली गिया और तिने सेयो पछयाणी ले, तेबे यीशु तिना ते लूकी गे। ");
INSERT INTO bfz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","तिने आपू बीचे बोलेया, “जेबे से बाटा रे आसा साथे गल्ला करने लगी रा था और पवित्र शास्त्रो रा मतलब आसा खे समजयाणे लगी रा था, तेबे क्या आसा रे मनो रे उतेजना नि ओ थी?” ");
INSERT INTO bfz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","सेयो तेसी बखते उठी की यरूशलेमो खे वापस ऊईगे, और तिना ग्यारा चेलेया खे और तिना रे साथिया खे कट्ठे देखेया। ");
INSERT INTO bfz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","सेयो बोलो थे, “प्रभु सच्ची जिऊँदे ऊईगे रे और शमौन पतरसो खे दिशेया।” ");
INSERT INTO bfz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तेबे तिने बाटा रिया गल्ला तिना खे बताई तिया और ये बी कि तिने रोटी तोड़दे बखते सेयो किंयाँ पछयाणे? ");
INSERT INTO bfz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","सेयो इना गल्ला करने ई लगी रे थे कि यीशु आपू ई तिना बीचे खड़े ऊईगे और तिना खे बोलेया, “तुसा खे शान्ति मिलो।” ");
INSERT INTO bfz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पर सेयो कबराई गे, डरी गे और समजणे लगे कि केसी पूतो खे देखणे लगी रे। ");
INSERT INTO bfz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीशुए तिना खे बोलेया, “कबराणे कऊँ लगी रे? और तुसा रे मनो रे शक कऊँ ए? ");
INSERT INTO bfz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मेरे आथा खे और मेरे पैरा खे देखो कि आऊँ सेईए, माखे छुँईं की देखो, कऊँकि आत्मा रे आड्ड और मांस नि ऊँदे, जेड़ा मांदे देखणे लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ये बोली की तिने आपणे आथ पैर तिना गे बताए। ");
INSERT INTO bfz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जेबे खुशिया रे मारे तिना खे विश्वास नि ऊआ कि यीशु जिऊँदा ऊईगा रा और हैरान ऊईगे, तेबे यीशुए बोलेया, “क्या एती तुसा गे कुछ रोटी आयी।” ");
INSERT INTO bfz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","तिने तिना खे पुजी रिया मछलिया रा टुकड़ा दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","तिने लयी की तिना सामणे खाया। ");
INSERT INTO bfz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","तेबे यीशुए तिना खे बोलेया, “यो मेरिया सेयो गल्ला ए, जो मैं तुसा साथे रंदे ऊए, तुसा खे बोली थिया, कि जरूरी ए कि जितणिया गल्ला मूसे रा बिधान और भविष्यबक्ता और पजनो री कताबा रे मेरे बारे रे लिखी राखिया, सेयो सब पुरिया ओ।” ");
INSERT INTO bfz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तेबे यीशुए पवित्र शास्त्र समजणे खे तिना खे अक्ल दित्ती ");
INSERT INTO bfz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","और तिना खे बोलेया, “पवित्र शास्त्रो रे ईंयां लिखी राखेया कि मसीहे दु:ख उठाणा और तीजे दिने मरे रेया बीचा ते जिऊँदा ऊणा ");
INSERT INTO bfz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","और यरूशलेम नगरो ते लयी की सबी जातिया खे मन फिराणे रा और पापो रिया माफिया रा प्रचार, तेसरे ई नाओं ते कित्तेया जाणा। ");
INSERT INTO bfz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","तुसे इना सबी गल्ला रे गवा ए ");
INSERT INTO bfz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","और देखो, मां आपू पवित्र आत्मा पेजणी जेतेरी प्रतिज्ञा मेरे पिते करी राखी और जदुओ तक स्वर्गो ते सामर्थ नि पाओ, तदुओ तक एस नगरो रेई रओ।” ");
INSERT INTO bfz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","तेबे यीशु तिना खे बैतनिय्याह नगरो तक बारे लईगे, और आपणे आथ चकी की तिना खे आशीष दित्ती। ");
INSERT INTO bfz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","और तिना खे आशीष देंदे ऊए सेयो तिना ते लग ऊईगे और स्वर्गो खे चकी ते। ");
INSERT INTO bfz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","तेबे चेले तिना गे माथा टेकी की और बडिया खुशिया साथे यरूशलेमो खे वापस ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","और हर रोज मन्दरो रे आजीर ऊई की परमेशरो री स्तुति करेया करो थे।");
INSERT INTO bfz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","सृष्टिया ते पईले वचन था, वचन परमेशरो साथे था और वचन परमेशर था। ");
INSERT INTO bfz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","येई शुरूओ ते परमेशरो साथे था। ");
INSERT INTO bfz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","परमेशरे सब कुछ तेसरी जरिए पैदा कित्तेया और जो कुछ पैदा ऊई रा, तिना बीचा ते कोई बी चीज तेसते बिना नि ऊई। ");
INSERT INTO bfz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","तेसदे जीवन था और से जीवन मांणूआ री जोति थी। ");
INSERT INTO bfz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","जोति न्हेरे रे चमकदी रई; पर न्हेरा तिजी पाँदे हावी नि ऊई सकेया। ");
INSERT INTO bfz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेशरे एक माणूं पेजेया, जेसरा नाओं यूहन्ना था। ");
INSERT INTO bfz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","से तेसा ई जोतिया री गवाई देणे आया, ताकि सब तेसरी बजअ ते विश्वासो रे आओ। ");
INSERT INTO bfz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","यूहन्ना आपू तो, से जोति नि था, पर तेसा जोतिया री गवाई देणे आयी रा था। ");
INSERT INTO bfz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","सच्ची जोति जो हर एक मांणूए खे प्रयासा देओई, से आपणे आपू खे दुनिया रे लोका पाँदे प्रकट करने वाल़ी थी। ");
INSERT INTO bfz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","से दुनिया रे था और दुनिया तेसरे जरिए पैदा ऊई, पर दुनिया रे लोके से नि पछयाणा। ");
INSERT INTO bfz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","से आपणे कअरे आपणे लोका बीचे आया पर तेसरे आपणेया से नि मानेया। ");
INSERT INTO bfz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पर जितणेया से मानेया, तिना खे तिने परमेशरो री ल्वाद ऊणे रा अक्क दित्तेया। मतलब-जो तेसरे नाओं पाँदे विश्वास राखो थे। ");
INSERT INTO bfz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","सेयो ना तो खूनो ते, ना शरीरो री इच्छा ते, ना मांणूए री इच्छा ते, पर परमेशरो ते पैदा ऊई रे। ");
INSERT INTO bfz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","और वचन माणूं रे शरीरो रे आया और कृपा और सच्चाईया ते परिपूर्ण ऊई की आसा बीचे डेरा कित्तेया और आसे तेसरी एड़ी महिमा देखी, जेड़ी पिते रे एकलौते री महिमा। ");
INSERT INTO bfz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्ने तेसरे बारे रे गवाई दित्ती और आक्का पाई की बोलेया, “से येईए, जेसरे बारे रे मैं बोलेया कि जो मांते बाद आऊणे लगी रा, से मांते बढ़ी की ए, कऊँकि से मांते पईले था।” ");
INSERT INTO bfz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","कऊँकि तेसरी कृपा री परिपूर्णता बीचा ते आसा सबी खे आशीषा पाँदे आशीष मिली। ");
INSERT INTO bfz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","तेबेई परमेशरे बिधान तो मूसे रे जरिए दित्तेया, पर तिने यीशु मसीह रे जरिए कृपा और सच्चाई दखाई। ");
INSERT INTO bfz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेशर कदी बी किने नि देखेया, केवल एकलौता पुत्रे, जो सच्ची ई आपू परमेशर ए, और जो पिते री गोदा रे ए, तिने ई ये प्रगट कित्तेया कि परमेशर केड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","जेबे यहूदी अगुवे यरूशलेम नगरो ते पुरोईत और लेविया खे यूहन्ना ते ये पूछणे खे पेजेया, “तूँ कुण ए?” तो यूहन्ने गवाई दित्ती, ");
INSERT INTO bfz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","“आऊँ मसीह निए।” ");
INSERT INTO bfz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तेबे तिने तेसते पूछेया, “तेबे तूँ कुण ए? क्या तूँ एलिय्याह भविष्यवक्ता ए?” तिने बोलया, “आऊँ निए।” “तेबे तूँ क्या भविष्यबक्ता ए?” तिने बोलेया, “ना।” ");
INSERT INTO bfz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तेबे तिने तेसते पूछेया, “तेबे तूँ कुण ए? ताकि आसे आपणे पेजणे वाल़ेया खे जवाब देऊँ, तूँ आपणे बारे रे क्या बोलेया?” ");
INSERT INTO bfz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","यूहन्ने तिना लोका खे यशायाह भविष्यबक्ते रे वचना रा इस्तेमाल करी की बोलेया, “आऊँ सुणसाण जगा रे एक आक्का पाणे वाल़े री आवाज ए, ताकि तुसे प्रभुए री बाट सीदी करो।” ");
INSERT INTO bfz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","सेयो फरीसिये री तरफा ते पेजी राखे थे। ");
INSERT INTO bfz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","तिने तेसते ये सवाल पूछेया, “जे तूँ ना तो मसीह ए, ना एलिय्याह और ना भविष्यबक्ता ए, तो बपतिस्मा कऊँ देआ?” ");
INSERT INTO bfz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्ने तिना सबी खे जबाब दित्तेया, “आऊँ तो पाणिए की बपतिस्मा देऊँआ, पर तुसा बीचे एक मांणू खड़ी रा, जेसखे तुसे नि जाणदे। ");
INSERT INTO bfz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","मतलब-मांते बाद आऊणे वाल़ा ए, जेसरे जोड़े रे फिथे बी आऊँ खोलणे जोगा निए।” ");
INSERT INTO bfz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","यो गल्ला यरदन नदिया ते पार बैतनिय्याह गांव रे ऊईया, जेती यूहन्ना लोका खे बपतिस्मा देओ था। ");
INSERT INTO bfz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दूजे दिने तिने यीशुए खे आपू गे आऊँदे ऊए देखी की बोलेया, “देखो, ये परमेशरो रा मिन्टू ए, जो दुनिया रे पाप चकी की लयी जाओआ। ");
INSERT INTO bfz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ये सेईए, जेसरे बारे रे मैं बोलेया था कि एक मर्द मां पीछे आओआ, जो मांते बी बड़ा ए, कऊँकि से मांते पईले था। ");
INSERT INTO bfz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","आऊँ तो तेसखे पछयाणुँ नि था कि से मसीह ए, पर आऊँ इजी री खातर पाणिए की बपतिस्मा देंदा ऊआ आया, ताकि से इस्राएलो रे प्रगट ऊई जाओ।” ");
INSERT INTO bfz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","यूहन्ने ये गवाई दित्ती, “जिंयाँ कबूतर उड़दा ऊआ थाले आओआ तिंयाँ ई तिने पवित्र आत्मा सर्गो ते उतरदे ऊए देखेया। और से तेस पाँदे रूकी गा। ");
INSERT INTO bfz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","आऊँ तो तेसखे पछयाणुँ नि था, पर जिने आऊँ पाणिए साथे बपतिस्मा देणे खे पेजेया, तिने ई मांगे बोलेया, ‘जेस पाँदे तूँ आत्मा खे उतरदे ऊए और रुकदे ऊए देखेगा, सेई पवित्र आत्मा ते बपतिस्मा देणे वाल़ा ए।’ ");
INSERT INTO bfz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","मैं से देखेया और आँऊ तुसा खे सच-सच बोलूँआ कि येई परमेशरो रा पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दूजे दिने फेर यूहन्ना और तेसरे चेलेया बीचा ते दो जणे खड़ी रे थे। ");
INSERT INTO bfz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","और तिने यीशुए खे, जो जाणे लगी रा था, देखी की बोलेया, “देखो, ये तो परमेशरो रा मिन्टू ए।” ");
INSERT INTO bfz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","तेबे सेयो दोनो चेले तेसते ये सुणी की यीशुए पीछे चली पड़े। ");
INSERT INTO bfz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीशुए तिना खे आऊँदे ऊए देखी की पीछे मुड़ी की बोलेया, “तुसे केसखे लगी रे टोल़ने?” तिने तिना खे बोलेया “ओ गुरू! तुसे केयी रओए?” ");
INSERT INTO bfz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","यीशुए बोलेया, “चलोगे तो देखी लओगे।” तेबे तिने आयी की तिना रे रणे री जगा देखी और तेस दिने तिना साथे ई रये और ये दोपईरो ते बाद तकरीबन चार बजे रे करीब था। ");
INSERT INTO bfz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","तिना दूँईं बीचा ते, जो यूहन्ने री गल्ल सुणी की तिना पीछे आए थे तिना बीचा ते एक शमौन पतरसो रा पाई अन्द्रियास था। ");
INSERT INTO bfz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","तिने पईले आपणे सके पाई शमौनो खे मिली की बोलेया, “आसा खे ख्रीस्ट, मतलब मसीह, मिली गा।” ");
INSERT INTO bfz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","अन्द्रियास तेसखे यीशुए गे ल्याया, यीशुए तेसखे देखी की बोलेया, “तूँ यूहन्ने रा पाऊ शमौन ए, तूँ कैफा नाओं ते जाणेया जाणा,” या पतरस जेतेरा मतलब पात्थर ऊणा। ");
INSERT INTO bfz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दूजे दिने यीशुए गलील प्रदेशो खे जाणा चाया। जेबे फिलिप्पुस तिना खे मिलेया तो तेसखे बोलेया, “मां पीछे आईजा।” ");
INSERT INTO bfz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस, अन्द्रियास और पतरसो रे नगर बैतसैदा रा रणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुसे नतनएलो ते मिली की बोलेया, “जेसरे बारे रे मूसे बिधानो रे और भविष्यबक्ते बोली राखेया, से आसा खे मिली गा रा, से यूसुफो रा पाऊ यीशु नासरी ए।” ");
INSERT INTO bfz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएले तेसखे बोलेया, “क्या कोई खरी चीज बी नासरतो ते निकल़ी सकोई?” फिलिप्पुसे तेसखे बोलेया, “चली की देखी लो।” ");
INSERT INTO bfz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीशुए नतनएलो खे आपू गे आऊँदे ऊए देखी की तेसरे बारे रे बोलेया, “देखो, ये सच्ची इस्राएली ए, एसरे कोई कपट निए।” ");
INSERT INTO bfz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएले तिना खे बोलेया, “तूँ माखे किंयाँ जाणेया?” यीशुए तेसखे जवाब दित्तेया, “इजी ते पईले फिलिप्पुसे तूँ बुलाया, जेबे तूँ दाऊगल़े रे डाल़ो निठे था, तेबे मैं तूँ देखेया था।” ");
INSERT INTO bfz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएले तिना खे जवाब दित्तेया, “ओ गुरू! तूँ परमेशरो रा पुत्र ए, तूँ इस्राएलो रा महाराजा ए।” ");
INSERT INTO bfz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीशुए तेसखे उतर दित्तेया, “मैं जो ताखे बोलेया कि मैं तूँ दाऊगल़े रे डाल़ो निठे देखेया, क्या तूँ तेबेई विश्वास करेया? तां इजी ते बी बड़े-बड़े काम देखणे।” ");
INSERT INTO bfz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फेर तेसखे बोलेया, “आऊँ ताखे सच-सच बोलूँआ कि तां स्वर्ग खुलेया रा और परमेशरो रे स्वर्गदूत माणूं रे पुत्रो पाँदे उतरदे और ऊबे जांदे ऊए देखणे।” ");
INSERT INTO bfz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","तीजे दिने गलील प्रदेशो रे काना नगरो रे केसी रा ब्या था और यीशुए री आम्मा बी तेती थी। ");
INSERT INTO bfz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","यीशु और तिना रे चेले बी तेती ब्याओ खे बुलाई राखे थे। ");
INSERT INTO bfz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जेबे अँगूरा रा रस कम ऊईगा, तेबे यीशुए री आम्मे तिना खे बोलेया, “तिना गे अँगूरा रा रस नि रया।” ");
INSERT INTO bfz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीशुए तेसा खे बोलेया, “ओ जवाणसे! ताखे मांते क्या काम ए? एबु मेरा आपणे आपू खे प्रकट करने रा बखत नि आयी रा।” ");
INSERT INTO bfz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","पर तिना री आम्मे दासा खे बोलेया, “जो कुछ ये तुसा खे बोलोगा, सेई करना।” ");
INSERT INTO bfz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","तेती यहूदिया री शुद्ध करने री रवाजा रे मुताबिक, पात्थरा रे छे बड़े कअड़े राखे रे थे, जिना रे दो-दो और तीन-तीन मण आओ था। ");
INSERT INTO bfz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीशुए दासा खे बोलेया, “कअड़ेया रे पाणी परी देओ।” तिने परी-परी करी ते। ");
INSERT INTO bfz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","यीशुए तेस दासो खे बोलेया, “एबे इजी बीचा ते थोड़ा पाणी निकयाल़ी की पाट्टिया (भोज) रे प्रदानो गे लयी जाओ और तिने दासे एड़ा ई कित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जेबे पाट्टिया रे प्रदाने से पाणी चाखेया, जो अँगूरा रा रस बणीगा था, पर ये नि जाणो था कि केथा ते आया (पर जिने दासे पाणी निकयाल़ेया था, सेयो जाणो थे) तेबे पाट्टिया रे प्रदाने लाड़े खे बुलाई की तेसखे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“हर एक मांणू पईले बढ़िया अँगूरा रा रस देओआ और जेबे लोक पी की थकी जाओए, तेबे आदा देओआ, पर तैं बढ़िया अँगूरा रा रस एबुए तक राखी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","यीशुए गलील प्रदेशो रे काना नगरो रे आपणा ये पईला चिह्न् दखाई की आपणी महिमा प्रगट कित्ती और तिना रे चेलेया तिना पाँदे विश्वास कित्तेया कि सच्ची येई ई मसीह ए। ");
INSERT INTO bfz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","इजी ते बाद यीशु, तिना री आम्मा, तिना रे पाई और तिना रे चेले कफरनहूम नगरो खे गये और तेती कुछ दिन तक रये। ");
INSERT INTO bfz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदिया रा फसह रा त्योआर नेड़े था और यीशु यरूशलेम नगरो खे गये। ");
INSERT INTO bfz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","तेबे तिने मन्दरो रे बल़द, पेड, और कबूतरा खे बेचणे वाल़े और सर्राफे बैठे रे देखेया। ");
INSERT INTO bfz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तेबे तिने रस्सिया रा कोड़ा बणाई की सब पेडा और बल़द मन्दरो ते बारे निकयाल़ी ते और सर्राफे रे पैसे बखेरी ते और चौकिया मूँदिया करी तिया ");
INSERT INTO bfz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","और कबूतरा खे बेचणे वाल़ेया खे बोलेया, “इना खे एथा ते लयी जाओ, मेरे पिते रे कअरो खे बपारो रा कअर नि बणाओ।” ");
INSERT INTO bfz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तेबे तिना रे चेलेया खे याद आया कि पवित्र शास्त्रो रे लिखी राखेया, “तेरे कअरो री चिन्ता आऊँ पितरे-पितरे ई खाई जाणा” ");
INSERT INTO bfz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","तेबे यहूदिये तिना खे बोलेया, “तूँ जो ये करेया, तो आसा खे क्या चिह्न् दखाएया?” ");
INSERT INTO bfz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीशुए तिना खे जवाब दित्तेया, “एस मन्दरो खे टाल़ी देओ और मां ये तीन दिना रे फेर खड़ा करी देणा।” ");
INSERT INTO bfz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदिये बोलेया, “एस मन्दरो खे बनाणे खे छयाल़ी साल लगी रे और क्या तां ये तीन दिना रे फेर खड़ा करी देणा?” ");
INSERT INTO bfz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","पर तिने आपणे शरीरो रे मन्दरो रे बारे रे बोलेया था। ");
INSERT INTO bfz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","तो जेबे सेयो मुड़देया बीचा ते जिऊँदे ऊईगे थे, तेबे तिना रे चेलेया खे याद आया कि तिने ये बोलेया था और तिने पवित्र शास्त्रो पाँदे और जो वचन यीशुए बोलेया था, विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जेबे सेयो फसह रे त्योआरो रे बखते यरूशलेमो रे थे, तेबे बऊत जणेया, सेयो चिह्न्, जो सेयो दखाओ थे, देखी की तिना पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पर यीशुए आपणे आपू खे तिना रे परोसे नि छाडेया, कऊँकि सेयो सबी खे जाणो थे ");
INSERT INTO bfz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","और तिना खे जरूरत नि थी कि मांणूए रे बारे रे कोई गवाई देओ, कऊँकि सेयो आपू जाणो थे कि मांणूए रे मनो रे क्या ए? ");
INSERT INTO bfz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसिया बीचा ते एक नीकुदेमुस नाओं रा मांणू था, जो यहूदिया रा धार्मिक अगुवा था। ");
INSERT INTO bfz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","तिने राती आयी की यीशुए खे बोलेया, “ओ गुरू! आसे जाणूंए कि तूँ परमेशरो री तरफा ते गुरू ऊई की आयी रा, कऊँकि कोई बी इना चमत्कारा खे, जो तूँ दखाएया, जे परमेशर तेस साथे नि ओ, तो दखाई नि सकदा।” ");
INSERT INTO bfz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीशुए तेसखे बोलेया, “आऊँ ताखे सच-सच बोलूँआ कि जे कोई नये सिरे ते नि जम्मो, तो परमेशरो रा राज्य जेती परमेशर राज करोआ देखी नि सकदा।” ");
INSERT INTO bfz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुसे तिना खे बोलेया, “जेबे मांणू स्याणा उई गा, तेबे किंयाँ जम्मी सकोआ? क्या से आपणी आम्मा रे गर्भो रे दूजी बार जाई की जम्मी सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीशुए बोलेया, “आऊँ ताखे सच-सच बोलूँआ कि जदुओ तक कोई मांणू पाणी और आत्मा साथे नि जम्मो, तो से परमेशरो रे राज्य रे नि जाई सकदा। ");
INSERT INTO bfz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","कऊँकि जो शरीरो साथे जम्मी रा, से शरीर ए और जो आत्मा साथे जम्मी रा, से आत्मा ए। ");
INSERT INTO bfz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","हैरान नि ओ कि मैं ताखे बोलेया, ‘तुसा खे नये सिरे ते जमणा जरूरी ए।’ ");
INSERT INTO bfz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","अवा जेथो खे चाओ, तेथो खे चलो ई और तूँ तिजी री छेड़ सुणेया, पर जाणदा नि कि से केथा ते आयी री और केथो खे जाओई? जो कोई आत्मा ते जम्मी रा, से एड़ा ईए।” ");
INSERT INTO bfz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुसे तिना खे बोलेया, “यो गल्ला किंयाँ ऊई सकोईया?” ");
INSERT INTO bfz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ये सुणी की यीशुए तेसखे उतर दित्तेया, “तूँ इस्राएलिया रा गुरू ऊई की बी क्या इना गल्ला खे नि समजदा? ");
INSERT INTO bfz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","आऊँ ताखे सच-सच बोलूँआ कि आसे जो जाणूंए, से बोलूँए और जो आसे देखी राखेया, तिजी री गवाई देऊँए, और तुसे म्हारी गवाई नि मानदे। ");
INSERT INTO bfz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जेबे मैं तुसा गे तरतिया रिया गल्ला बोलिया और तुसे विश्वास नि कित्तेया, तो जे आऊँ तुसा गे स्वर्गो रिया गल्ला बोलूँ, तो तुसा किंयाँ विश्वास करना। ");
INSERT INTO bfz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","कोई स्वर्गो रे नि चढ़ेया, बस से जो स्वर्गो ते उतरेया, मतलब आँऊ माणूं रा पुत्र जो स्वर्गो रे ए। ");
INSERT INTO bfz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","और जेते टंगो रे मूसे जंगल़ो रे पीतल़ो रा साप ऊच्चे पाँदे चढ़ाया था, तिंयाँ ई जरूरी ये कि आँऊ माणूं रा पुत्र बी ऊच्चे पाँदे चढ़ाया जाओ। ");
INSERT INTO bfz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताकि जो कोई मां पाँदे विश्वास करो, से अनन्त जीवन पाओ। ");
INSERT INTO bfz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“कऊँकि परमेशरे दुनिया रे लोका ते एड़ा प्यार कित्तेया कि तिने आपणा एकलौता पुत्र देईता, ताकि जो कोई तेस पाँदे विश्वास करो, से नाश नि ओ, पर अनन्त जीवन पाओ। ");
INSERT INTO bfz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","परमेशरे आपणा पुत्र दुनिया रे इजी खे नि पेजेया कि से दुनिया पाँदे दण्डो री आज्ञा देओ, पर इजी खे कि दुनिया रे लोक तेसरी बजअ ते उद्धार पाओ। ");
INSERT INTO bfz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जो मां पाँदे विश्वास करोआ, तेस पाँदे दण्डो री आज्ञा नि ऊँदी, पर जो मां पाँदे विश्वास नि करदा, से दोषी ठईरी चुकेया, कऊँकि तिने परमेशरो रे एकलौते पुत्रो रे नाओं पाँदे विश्वास नि कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","और दण्डो री आज्ञा री बजअ ये कि जोति दुनिया रे आयी री और मांणूआ खे न्हेरा जोतिया ते प्यारा लगेया, कऊँकि तिना रे काम बुरे थे। ");
INSERT INTO bfz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","कऊँकि जो कोई बुराई करोआ, से जोतिया ते बैर राखोआ और जोतिया रे नेड़े नि आऊँदा, एड़ा नि ओ कि तेसरे कामो पाँदे दोष लगाया जाओ। ");
INSERT INTO bfz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","पर जो सच्चाईया पाँदे चलोआ, से जोतिया रे नेड़े आओआ, ताकि तेसरे काम सामणे आओ कि सेयो परमेशरो री तरफा ते ऊई रे।” ");
INSERT INTO bfz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","इजी ते बाद यीशु और तिना रे चेले यहूदिया प्रदेशो रे आए और यीशु तेती तिना साथे रई की बपतिस्मा देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्ना बी सामरिया प्रदेशो रे शालेम नगरो रे नेड़े, ऐनोन गांव रे बपतिस्मा देओ था, कऊँकि तेती बऊत पाणी था और लोक आयी की बपतिस्मा लओ थे। ");
INSERT INTO bfz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","यूहन्ना तेस बखतो तक जेला रे नि पायी राखेया था। ");
INSERT INTO bfz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","तेती यूहन्ने रे चेलेया रा केसी यहूदिये साथे शुद्ध करने री रवाजा रे बारे रे बईस उई। ");
INSERT INTO bfz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","तेबे यूहन्ने रे चेलेया आयी की तेसखे बोलेया, “ओ गुरू! जो मांणू यरदनो ते पार तां साथे था और जेसरे बारे रे तैं गवाई दित्ती थी, देखो, से बपतिस्मा देओआ और लोक तेसगे आओए।” ");
INSERT INTO bfz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्ने जवाब दित्तेया, “जदुओ तक मांणूए खे स्वर्गो ते नि दित्तेया जाओ, तदुओ तक से कुछ नि पायी सकदा। ");
INSERT INTO bfz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुसे तो आपू ई मेरे गवा ए कि मैं बोली राखेया, ‘आऊँ मसीह निए, पर तेसते आगे पेजी राखेया।’ ");
INSERT INTO bfz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","जेसरी लाड़ी ए, सेई लाड़ा ए, पर लाड़े रा दोस्त जो खड़ा ऊई की तेसरी सुणोआ, लाड़े रे बोलो ते बऊत खुश ओआ, एबे मेरी ये खुशी पूरी ऊई री। ");
INSERT INTO bfz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","जरूरी ए कि से बढ़दा जाओ और आऊँ कम ऊँदा जाऊँ। ");
INSERT INTO bfz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“जो स्वर्गो ते आओआ, से सबी ते उत्तम ओआ, जो तरतिया ते आओआ, से तरतिया राए और तरतिया री गल्ला करोआ, जो परमेशरो री तरफा ते आओआ, से सबी ते ऊबे ए। ");
INSERT INTO bfz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","जो कुछ तिने देखेया और सुणेया, तेतेरी ई गवाई देओआ और कोई तेसरी गवाई नि मानदा। ");
INSERT INTO bfz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","पर जिने तेसरी गवाई मानी ली, तिने एते गल्ला पाँदे छाप देईती कि परमेशर सच्चा ए। ");
INSERT INTO bfz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","कऊँकि जो परमेशरे पेजी राखेया, से परमेशरो री गल्ला बोलोआ, कऊँकि परमेशर तेसखे आपणा आत्मा नापी-नापी की नि देंदा पर खुले दिलो ते देओआ। ");
INSERT INTO bfz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पिता पुत्रो साथे प्यार राखोआ और तिने सारी चीजा तेसरे आथो रे देईती रिया। ");
INSERT INTO bfz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जो परमेशरो रे पुत्रो पाँदे विश्वास राखोआ, अनन्त जीवन तेसरा ईए, पर जो परमेशरो रे पुत्रो री नि मानदा, तेस जीवन नि देखणा, पर परमेशरो रा रोष तेस पाँदे रओआ।” ");
INSERT INTO bfz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","तेबे, जेबे यीशुए खे पता लगेया कि फरीसिये सुणी राखेया कि यीशु यूहन्ने ते जादा चेले बणाओआ और तिना खे बपतिस्मा देओआ। ");
INSERT INTO bfz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","हालाँकि यीशु आपू नि, पर तिना रे चेले बपतिस्मा देओ थे। ");
INSERT INTO bfz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तेबे सेयो यहूदिया प्रदेशो खे छाडी की फेर गलील प्रदेशो खे चली गे ");
INSERT INTO bfz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","और तिना खे सामरिया प्रदेशो रिये ऊई की जाणा पड़ेया। ");
INSERT INTO bfz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","तेबे सेयो सूखार नाओं रे सामरिया प्रदेशो रे एक नगरो तक आए, जो तेसा जमीना रे नेड़े ए, जो याकूबे आपणे पाऊ यूसुफो खे दित्ती थी ");
INSERT INTO bfz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","और से कूँआं बी जो याकूबे खणेया था, तेथी था। तेबे यीशु बाटा रे थके रे तेस कुँएं पाँदे ईंयां ई बैठीगे। ये गल्ल दोपईरो रे तकरीबन ऊई। ");
INSERT INTO bfz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","तदुओ की एक सामरी जवाणस पाणी परने आयी। यीशुए तेसा खे बोलेया, “माखे पाणी पल़याई दे।” ");
INSERT INTO bfz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","कऊँकि तिना रे चेले नगरो रे रोटी खरीदणे जाई रे थे। ");
INSERT INTO bfz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","तेबे सामरी जवाणसे तिना खे बोलेया, “तूँ यहूदी ऊई की मां सामरिया जवाणसा ते पाणी कऊँ मांगेया?” कऊँकि यहूदी सामरिया साथे कोई बी मिलणा-बर्तणा नि राखो थे। ");
INSERT INTO bfz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीशुए जवाब दित्तेया, “जे तूँ परमेशरो रे बरदानो खे जाणदी और ये बी जाणदी कि से कुण ए, जो ताखे बोलोआ, ‘माखे पाणी पल़्या,’ तो तूँ तेसते मांगदी और से ताखे पवित्र आत्मा जीवनो रे पाणिए रे रूपो रे देंदा।” ");
INSERT INTO bfz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","जवाणसे तिना खे बोलेया, “ओ प्रभु! तुसा गे तो पाणी परने खे कुछ आया ई नि और कूँआं डूगा ए, तो तेबे से जीवनो रा पाणी तुसा गे केथा ते आया? ");
INSERT INTO bfz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","क्या तुसे म्हारे पिता याकूबो ते बी बड़े ए, जिने आसा खे ये कूँआं दित्तेया और आपू बी आपणे बाल-बच्चेया साथे और डांगरा साथे तिजी ते पिया।” ");
INSERT INTO bfz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीशुए तेसा खे जवाब दित्तेया, “जेस केसी बी ये पाणी पीणा, से फेर त्याया ऊणा। ");
INSERT INTO bfz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पर जो कोई तेस पाणिए ते पीओगा, जो मां तेसखे देणा, से कदी फेर अनन्तकालो तक त्याया नि ऊणा, बल्कि जो पाणी मां तेसखे देणा, से तेसरे एक सूबल़ बणी जाणी जो अनन्त जीवनो तक बईंदी रणी।” ");
INSERT INTO bfz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","जवाणसे तिना खे बोलेया, “ओ प्रभु! से पाणी माखे दे ताकि आऊँ त्यायी नि रऊँ और ना आऊँ पाणी परने खे इतणी दूर आऊँ।” ");
INSERT INTO bfz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीशुए तेसा खे बोलेया, “जा और आपणे लाड़े खे एती बुलाई की ली आओ।” ");
INSERT INTO bfz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","जवाणसे जवाब दित्तेया, “आऊँ बिना लाड़े तेई,” यीशुए तेसा खे बोलेया, “तूँ ठीक लगी री बोलणे कि आऊँ बिना लाड़े तेई। ");
INSERT INTO bfz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","कऊँकि तूँ पाँज लाड़े करी चुकी री और जेस मांणूए साथे तूँ एबुए, से बी तेरा लाड़ा निए, ये तैं सच बोली राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","जवाणसे तिना खे बोलेया, “ओ प्रभु! माखे लगोआ कि तुसे भविष्यबक्ता ए। ");
INSERT INTO bfz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","आसा रे बाप-दादे एस पाह्ड़ो पाँदे ई आराधना कित्ती और तुसे बोलोए कि जेती भक्ति करनी चाईयो से जगा यरूशलेम ए।” ");
INSERT INTO bfz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीशुए बोलेया, “ओ जवाणसे! मेरी गल्ला पाँदे विश्वास कर कि से बखत आऊणा, जेबे ना तुसा एते पाह्ड़ो पाँदे पिते री भक्ति करनी और ना ई यरूशलेमो रे। ");
INSERT INTO bfz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुसे सामरी लोक जेसखे जाणदे नि, तेसरी भक्ति करोए और आसे यहूदी जेसखे जाणूंए, तेसरी भक्ति करूँए, कऊँकि उद्धार आसा यहूदिया बीचा ते ए। ");
INSERT INTO bfz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पर से बखत आऊणा, बल्कि एबु बीए, जेबे सच्चे भक्ता, पिते री भक्ति आत्मा और सच्चाईया साथे करनी, कऊँकि पिता आपू खे एड़े ई भक्ति करने वाल़ेया खे टोल़ोआ। ");
INSERT INTO bfz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेशर आत्मा ए, इजी खे जरूरी ए कि तेसरी भक्ति करने वाल़े आत्मा और सच्चाईया साथे भक्ति करो।” ");
INSERT INTO bfz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","जवाणसे तिना खे बोलेया, “आऊँ जाणूंई कि मसीह जेसखे ख्रीस्ट बोलोए, आऊणे वाल़ा ए, जेबे से आऊणा, तेबे तेस आसा खे सब गल्ला बताणिया।” ");
INSERT INTO bfz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीशुए तेसा खे बोलेया, “आऊँ जो ताखे बोलणे लगी रा, सेई ये।” ");
INSERT INTO bfz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","तदुओ तक तिना रे चेले आईगे और हैरान ऊईगे कि सेयो जवाणसा साथे गल्ला करने लगी रे, तेबे बी किने नि बोलेया, “तूँ क्या चाएया?” या “तेसा साथे कऊँ लगी रा गलाणे?” ");
INSERT INTO bfz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तेबे जवाणस आपणा कअड़ा छाडी की नगरो खे चली गी और लोका खे बोलणे लगी, ");
INSERT INTO bfz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“आओ, एक मांणूए खे देखो, जिने सब कुछ, जो मैं करी राखेया, माखे बताई ता, केथी येई तो मसीह तो निए?” ");
INSERT INTO bfz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तेबे सेयो नगरो ते निकल़ी की यीशुए खे देखणे खे तिना गे आऊणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","तदुओ खे यीशुए रे चेले तिना ते बिनती करने लगे, “ओ गुरू! कुछ खाई लो।” ");
INSERT INTO bfz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","पर तिने तिना खे बोलेया, “मांगे खाणे खे एड़ी रोटी ए, जो तुसे नि जाणदे।” ");
INSERT INTO bfz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तेबे चेले आपू बीचे बोलणे लगे, “जेबे आसे चली गे थे तो क्या कोई गुरूए खे कुछ खाणे खे ल्याई राखेया?” ");
INSERT INTO bfz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीशुए तिना खे बोलेया, “मेरी रोटी ये कि आऊँ आपणे पेजणे वाल़े री इच्छा पाँदे चलूँ और तेसरा काम पूरा करुँ। ");
INSERT INTO bfz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","क्या तुसेई नि बोलदे कि बडाई ऊणे खे एबु चार मीन्ने पड़े रे ए। देखो, आऊँ तुसा खे बोलूँआ कि आपणिया आखिया चकी की डोरूआ खे देखो, कि सेयो बाडणे खे पाक्की चुके रे। ");
INSERT INTO bfz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","बाडणे वाल़ा मजदूरी पाओआ और अनन्त जीवनो खे फल कट्ठा करोआ, ताकि बाणे वाल़ा और बाडणे वाल़ा दोनो मिली की खुशी मनाओ। ");
INSERT INTO bfz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","कऊँकि इजी पाँदे ये कहावत ठीक बैठो ई कि बाणे वाल़ा ओर ए और बाडणे वाल़ा ओर ए। ");
INSERT INTO bfz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मैं तुसे तेस डोरूआ खे बाडणे खे पेजी राखे, जिदे तुसे मईणत नि करी राखी, ओरी मईणत कित्ती और तुसे तिना री मईणता रे फलो रे इस्सेदार ऊए।” ");
INSERT INTO bfz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","तेस नगरो रे बऊत सामरिये तेसा जवाणसा रे कईणे पाँदे यीशुए पाँदे विश्वास कित्तेया, कऊँकि तेसे ये गवाई दित्ती थी, “तिने सब कुछ जो मैं करी राखेया, माखे बताई ता।” ");
INSERT INTO bfz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","तेबे जेबे सेयो सामरी यीशुए गे आए, तेबे तिना ते बिनती करने लगे कि आसा साथे एथी रओ, तेबे सेयो तेती दो दिन तक रये। ");
INSERT INTO bfz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","तिना रे उपदेश सुणी की ओरी बी कई जणे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","तेबे तेसे जवाणसे बोलेया, “एबे आसे तुसा रे बोलणे तेई विश्वास नि करदे, कऊँकि आसे आपू सुणी राखेया और जाणूंए कि सच्ची, येई दुनिया रा उद्धारकर्ता ए।” ");
INSERT INTO bfz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","तेबे दो दिनो ते बाद सेयो तेथा ते निकल़ी की गलीलो खे गये। ");
INSERT INTO bfz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","कऊँकि यीशुए आपू ई बोली राखेया कि भविष्यबक्ता आपणे देशो रे आदर नि पाँदा। ");
INSERT INTO bfz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जेबे सेयो गलीलो रे आये तेबे गलीली तिना साथे खुश ऊई की मिले, कऊँकि जितणे काम तिने यरूशलेमो रे त्योआरो रे बखते कित्ते थे, तिने सेयो सब देखे थे, कऊँकि सेयो बी त्योआरो खे जाई रे थे। ");
INSERT INTO bfz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तेबे यीशु फेर गलील प्रदेशो रे काना गांव रे आए, जेती तिने पाणी अँगूरा रा रस बणाई ता था। तेती राजे रा एक कर्मचारी था, जेसरा पाऊ कफरनहूम नगरो रे बमार था। ");
INSERT INTO bfz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","जेबे तिने ये सुणेया कि यीशु यहूदिया ते गलीलो खे आईगा रा, तेबे से तिना गे गया और तिना ते बिनती करने लगेया कि चली की मेरे पाऊए खे ठीक करी दे, कऊँकि से मरने वाल़ा ए। ");
INSERT INTO bfz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीशुए तेसखे बोलेया, “जदुओ तक तुसे चिह्न् और अचम्बे काम नि देखी लओगे, तदुओ तक कदी बी विश्वास नि करी सकदे।” ");
INSERT INTO bfz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","राजे रे कर्मचारिये तिना खे बोलेया, “ओ प्रभु! मेरे पाऊए रे मरने ते पईले चलो।” ");
INSERT INTO bfz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीशुए तेसखे बोलेया, “जा, तेरा पाऊ जिऊँदा ए।” तिने मांणूए यीशुए री बोली री गल्ला पाँदे विश्वास कित्तेया और चली गा। ");
INSERT INTO bfz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","से जेबे बाटा रेई था कि तदुओ खे तेसरे दास तेसखे मिली गे और बोलणे लगे, “तेरा पाऊ जिऊँदा और तन्दरूस्त ए।” ");
INSERT INTO bfz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","तिने तेसते पूछेया, “कुण जी कअड़िया से ठीक ऊणे लगेया था?” तिने तेसखे बोलेया, “काल तकरीबन दोपईरो रे एक बजे रे करीब तेसरा बुखार उतरी गा था।” ");
INSERT INTO bfz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तेबे से पिता समजी गा कि ये तेस बखते ई ऊआ, जेस बखते यीशुए तेसखे बोलेया था, “तेरा पाऊ जिऊँदा ए।” और तिने और तेसरे सारे कराने यीशुए पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ये दूजा सामर्था रा काम था, जो यीशुए यहूदिया प्रदेशो ते आई कि गलील प्रदेशो रे दखाया। ");
INSERT INTO bfz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","इना गल्ला ते बाद यहूदिया रा एक त्योआर ऊआ और यीशु यरूशलेमो खे गये। ");
INSERT INTO bfz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूशलेमो रे पेडा रे फाटको (प्रवेश द्वार) रे नेड़े एक कुण्ड ए, जेतेखे इब्रानी पाषा रे बैतसैदा बोलोए और तिदे पाँज बरंडे ए। ");
INSERT INTO bfz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","इना रे बऊत लंगड़े, बमार, अन्दे और सूके रे अंग वाल़े पाणिए रे ईलणे री उम्मीदा दे पड़े रे रओ थे। ");
INSERT INTO bfz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","कऊँकि ठराए रे बखतो रे परमेशरो रे स्वर्गदूत कुण्डो रे उतरी की पाणिए खे ईलाया करो थे, पाणी ईलदे ई जो कोई पईले उतरो था, से ठीक ऊई जाओ था, चाए तेसरी कोई बी बमारी कऊँ नि ओ। ");
INSERT INTO bfz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","तेती एक मांणू था, जो ठती साला ते बमार था। ");
INSERT INTO bfz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीशुए तेसखे पड़ेया रा देखी की और ये जाणी की कि से बऊत दिना ते एड़िया ई दशा रे ए, तेसते पूछेया, “क्या तूँ ठीक ऊणा चाएया?” ");
INSERT INTO bfz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","तिने बमारे बोलेया, “ओ प्रभु! मेरी मताद करने खे कोई मांणू निए कि जेबे पाणी ईलाया जाओ, तो माखे कुण्डो रे उतारो, पर मेरे पऊँछणे ते पईले ई कोई दूजा मांते पईले ई उतरी जाओआ।” ");
INSERT INTO bfz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीशुए तेसखे बोलेया, “उठ और आपणा मांजा चकी की चल-फिर।” ");
INSERT INTO bfz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","से मांणू तेबुई ठीक ऊईगा और आपणा मांजा चकी की चलणे-फिरने लगेया। से आरामो रा दिन था। ");
INSERT INTO bfz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","तेबे यहूदी अगुवे तेसखे, जो ठीक ऊई रा था, बोलणे लगे, “आज तो आरामो रा दिन ए, मूसे रा बिधानो रे मुताबिक ताखे मांजा चकणा ठीक निए।” ");
INSERT INTO bfz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","तिने तिना खे जवाब दित्तेया, “जिने आऊँ ठीक कित्तेया, तिने ई माखे बोलेया, ‘आपणा मांजा चकी की चल-फिर।’ ” ");
INSERT INTO bfz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","तिने तेसते पूछेया, “से कुण मांणू ए, जिने ताखे बोलेया, ‘आपणा मांजा चकी की चल-फिर?’ ” ");
INSERT INTO bfz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","पर जो ठीक ऊईगा था, से नि जाणो था कि से कुण ए, कऊँकि तेते जगा रे पीड़ ऊणे री बजअ ते यीशु तेथा ते आटी गे थे। ");
INSERT INTO bfz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","इना गल्ला ते बाद से यीशुए खे मन्दरो रे आँगणो रे मिलेया। यीशुए तेसखे बोलेया, “देख, तूँ ठीक ऊईगा रा, दुबारा पाप नि करना, एड़ा नि ओ कि इजी ते जादा मुसीबत तां पाँदे पड़ी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","तिने मांणूए जायी की यहूदी अगुवे गे बताई ता कि जिने आऊँ ठीक करी राखेया से यीशु ए। ");
INSERT INTO bfz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","इजी बजअ ते यहूदी अगुवे यीशुए खे सताणे लगे, कऊँकि सेयो एड़े काम आरामो रे दिने करो थे। ");
INSERT INTO bfz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","तेबे यीशुए तिना खे बोलेया, “मेरा पिता परमेशर एबुए तक काम करोआ और आऊँ बी काम करूँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","इजी री बजअ ते यहूदी अगुवे ओर बी जादा तिना खे काणे री कोशिश करने लगे, कऊँकि से ना बस आरामो रे दिनो री बिधि-बिदान तोड़ोआ, बल्कि परमेशरो खे आपणा पिता बोली की आपणे आपू खे परमेशरो जेड़ा मानोआ। ");
INSERT INTO bfz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","तेबे यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच-सच बोलूँआ कि आँऊ आपणे आपू ते कुछ नि करी सकदा, बस से जो पिते खे करदा ऊआ देखूँआ, कऊँकि जो-जो काम से करोआ, आँऊ बी तिंयाँ ई करोआ। ");
INSERT INTO bfz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","कऊँकि पिता मांते ते प्यार राखोआ और जो-जो काम से आपू करोआ, तिना सबी खे से माखे दखाओआ और तेस इना ते बी बड़े काम माखे दखाणे, ताकि तुसे हैरान ओ। ");
INSERT INTO bfz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","कऊँकि जिंयाँ पिता मरे रेया खे उठाल़ोआ और जिऊँदा करोआ, तिंयाँ ई आँऊ बी जिना खे चाओआ, जिऊँदा करूँआ। ");
INSERT INTO bfz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","पिता केसी रा बी न्याय नि करदा, पर न्याय करने रा सारा काम मांगे गे सम्बाल़ी ता रा। ");
INSERT INTO bfz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ताकि सब लोक जिंयाँ पिते रा आदर करोए, तिंयाँ ई मेरा बी आदर करो, जो मेरा आदर नि करदा, से पिते रा आदर पनि करदा, जिने से पेजी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","आऊँ तुसा खे सच-सच बोलूँआ कि जो मेरा वचन सुणी की मेरे पेजणे वाल़े रा विश्वास करोआ, अनन्त जीवन तेसरा ईए और तेस पाँदे दण्डो री आज्ञा नि ऊँदी, बल्कि से मौता ते पार ऊई की जीवनो रे जाई चुकेया रा। ");
INSERT INTO bfz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“आऊँ तुसा खे सच-सच बोलूँआ कि से बखत आओआ, और एबुए, जिदे मरे रेया लोका, परमेशरो रे पुत्रो री आवाज सुणनी और जिना सुणनी, सेयो सदा खे जिऊँदे ऊई जाणे। ");
INSERT INTO bfz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","कऊँकि जिंयाँ पिता आपणे आपू रे जीवन राखोआ, तिंयाँ ई तिने माखे बी अक्क देई राखेया कि आपणे आपू रे जीवन राखूँ, ");
INSERT INTO bfz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","बल्कि पिते माखे लोका रा न्याय करने रा अक्क बी देई राखेया, कऊँकि आँऊ माणूं रा पुत्र ए। ");
INSERT INTO bfz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","इजी ते हैरान नि ओ, कऊँकि से बखत आऊणा, जेबे जितणे बी कब्रा रे ए, मेरी आवाज सुणी की जिऊँदे ऊई जाणे। ");
INSERT INTO bfz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जिने-जिने खरा करी राखेया सेयो दुबारा जीवन पाणे खे उठणे और जिने बुराई करी राखी, सेयो दण्ड पाणे खे दुबारा उठणे। ");
INSERT INTO bfz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“आऊँ आपणे आपू ते कुछ नि करी सकदा, जेड़ा पिते ते सुणूँआ, तेड़ा ई न्याय करूँआ और मेरा न्याय सच्चा ए, कऊँकि आऊँ आपणी इच्छा नि, पर आपणे पेजणे वाल़े री इच्छा चाऊँआ। ");
INSERT INTO bfz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","जे आऊँ आपू ई आपणी गवाई देऊँ, तो मेरी गवाई सच्ची निए। ");
INSERT INTO bfz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","एक ओर ए जो मेरी गवाई देओआ और आऊँ जाणूंआ कि मेरी जो गवाई से देओआ, से सच्ची ए। ");
INSERT INTO bfz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुसे यूहन्ना बपतिस्मा देणे वाल़े गे आपणे लोक पूछणे खे पेजे और तिने सच्चाईया री गवाई दित्ती। ");
INSERT INTO bfz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","पर आऊँ आपणे बारे रे मांणूआ री गवाई नि चांदा, तेबे बी आऊँ इना गल्ला इजी खे बोलूँआ, ताकि तुसा खे उद्धार मिलो। ");
INSERT INTO bfz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्ना बपतिस्मा देणे वाल़ा बल़दा और चमकदे ऊए दिऊए जेड़ा था और तुसा खे कुछ देरा खे तेसरी जोतिया रे मग्न ऊणा अच्छा लगेया। ");
INSERT INTO bfz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“पर जो मांगे गवाई ए, से यूहन्ना बपतिस्मा देणे वाल़े री गवाईया ते बड़ी ए। कऊँकि जो काम पिते मांगे पूरा करने खे सम्बाल़ी राखेया, मतलब-येई काम जो आऊँ करूँआ, सेयो मेरे गवा ए कि पिते आऊँ पेजी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","और पिते जिने आऊँ पेजी राखेया, तिने ई मेरी गवाई देई राखी, तुसे ना कदी तेसरी आवाज सुणी राखी और ना कदी तेसरा रूप देखी राखेया ");
INSERT INTO bfz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","और तेसरे वचनो खे मनो रे नि बठयाल़दे, कऊँकि जो तिने पेजी राखेया, तुसे तेसरा विश्वास नि करदे। ");
INSERT INTO bfz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुसे पवित्र शास्त्रो रे टोल़ोए, कऊँकि तुसे समजोए कि तुसा खे अनन्त जीवन तिदे मिलोआ और ये सेईए, जो मेरी गवाई देओआ। ");
INSERT INTO bfz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","“तेबे बी तुसे अनन्त जिन्दगी पाणे खे मांगे नि आऊणा चांदे। ");
INSERT INTO bfz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","आऊँ मांणूआ ते आदर नि चांदा। ");
INSERT INTO bfz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पर आऊँ तुसा खे जाणूंआ कि तुसा रे परमेशरो रा प्यार निए। ");
INSERT INTO bfz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","आऊँ आपणे पिता परमेशरो रे नाओं ते आयी रा और तुसे माखे नि मानदे, जे कोई दूजा आपणे ई नाओं ते आओ, तो तुसा से मानी लणा। ");
INSERT INTO bfz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुसे जो एकी-दूजे ते आदर चाओए और से आदर जो एक मात्र परमेशरो री तरफा ते ए, चांदे नि, किंयाँ विश्वास करी सकोए? ");
INSERT INTO bfz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ये नि समजो कि मां पिते सामणे तुसा पाँदे दोष लगाणा, तुसा पाँदे तो दोष लगाणे वाल़ा अया, मतलब-मूसा, जेस पाँदे तुसे उम्मीद राखी री ए। ");
INSERT INTO bfz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","कऊँकि जे तुसे मूसे रा विश्वास करदे, तो मेरा बी विश्वास करदे, कऊँकि तिने मेरे बारे रे लिखी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","पर जे तुसे तेसरी लिखी री गल्ला रा विश्वास नि करदे, तो मेरी गल्ला रा किंयाँ करना?” ");
INSERT INTO bfz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","इना गल्ला ते बाद यीशु गलीलो रे समुद्रो दे, मतलब-तिबिरियास समुद्रो ते पार गये। ");
INSERT INTO bfz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","तेबे एक बड़ी पारी पीड़ तिना पीछे आईगी, कऊँकि जो सामर्थ रे काम यीशु बमारा पाँदे करो थे, सेयो तिना खे देखो थे। ");
INSERT INTO bfz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तेबे यीशु पाह्ड़ो पाँदे चढ़ी की आपणे चेलेया साथे तेती बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहूदिया रा फसह रा त्योआर नेड़े था। ");
INSERT INTO bfz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","तेबे यीशुए आपणिया आखी चकी की एक बड़ी पीड़ आपू गे आऊँदी ऊई देखी, तेबे फिलिप्पुसो खे बोलेया, “एबे आसे इना खे केथा ते रोटी खरीदी की ल्याऊँ?” ");
INSERT INTO bfz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","पर तिने ये गल्ल तेसखे परखणे खे बोली, कऊँकि सेयो आपू जाणो थे कि मां क्या करना। ");
INSERT INTO bfz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुसे तिना खे बोलेया, “दो सौ चाँदिए रे सिक्केया रे मोलो री रोटी तिना खे थोड़ी-थोड़ी करी की बी पूरी नि ऊणी।” ");
INSERT INTO bfz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","तिना रे चेलेया बीचा ते शमौन पतरसो रे पाईए अन्द्रियासे तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“एती एक पाऊ ए, जेसगे पाँज जौ रिया रोटिया और दो मछलिया ए, पर इतणे लोका खे यो केयी ऊणिया?” ");
INSERT INTO bfz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीशुए बोलेया, “लोका खे बठयाल़ी देओ।” तेते जगा रे बऊत काआ था, तेबे लोक, जिना रे मर्दा री संख्या तकरीबन पाँज ह्जारा री थी, तेती बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तेबे यीशुए सेयो रोटिया लईया और धन्यवाद करी की बैठणे वाल़ेया खे बांडी तिया और तिंयाँ ई मछलिया बी जितणिया सेयो चाओ थे, तिना खे बांडी तिया। ");
INSERT INTO bfz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जेबे सेयो खाई की रज्जी गे, तेबे तिने आपणे चेलेया खे बोलेया, “बचे रे टुकड़े कट्ठे करी देओ, कुछ बी सेटणा नि।” ");
INSERT INTO bfz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","तेबे तिने कट्ठे करी ते और बारा टोकरिया परी तिया, जबकि सेयो पांजा रोटिया रे टुकड़े थे, जो खाणे वाल़ेया ते बाद बची रिया थिया। ");
INSERT INTO bfz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","तेबे जो सामर्था रे काम यीशुए करी की दखाए, तिना देखी की लोक बोलणे लगे, “से भविष्यबक्ता जो दुनिया रे आऊणे वाल़ा था, पक्का येईए।” ");
INSERT INTO bfz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीशु ये जाणी की कि सेयो माखे राजा बनाणे खे पकड़ना चाओए, फेर सेयो पाह्ड़ो पाँदे कल्ले चली गे। ");
INSERT INTO bfz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","जेबे साँज ऊई, तेबे तिना रे चेले समुद्रो रे कनारे चली गे ");
INSERT INTO bfz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","और किस्तिया रे चढ़ी की समुद्रो ते पार कफरनहूमो खे जाणे लगे। तेस बखते न्हेरा ऊईगा था और यीशु एबुए तक तिना गे नि पऊँछी रे थे। ");
INSERT INTO bfz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","तेबे तूफानो री बजअ ते समुद्रो रे लईरा उठणे लगिया। ");
INSERT INTO bfz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","जेबे सेयो किस्तिया रे सैर करदे ऊए तकरीबन पाँज-छ: किलोमीटर निकल़ी गे, तेबे तिने यीशु समुद्रो रे चलदे ऊए और किस्तिया रे नेड़े आऊँदे ऊए देखे और सेयो डरी गे। ");
INSERT INTO bfz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पर तिने तिना खे बोलेया, “आऊँ ए, डरो नि।” ");
INSERT INTO bfz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","तेबे सेयो तिना खे किस्तिया रे चढ़ाणे खे त्यार ऊईगे और तेबे से किस्ती फटाफट तेती पऊँछी गी, जेती सेयो जाणा चाओ थे। ");
INSERT INTO bfz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","दूजे दिने तेसे पीड़े, जो समुद्रो ते पार थी खड़ी री, तिने देखेया कि एती तो एक किस्तिया खे छाडी की ओर कोई किस्ती नि थी और यीशु आपणे चेलेया साथे तेसा किस्तिया रे नि चढ़े, पर बस तिना रेई चेले गये। ");
INSERT INTO bfz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तेबे बी ओर किस्तिया तिबिरियास नगरो ते तेते जगा रे नेड़े आईया, जेती तिने यीशुए रे धन्यवाद करने ते बाद रोटी खाई थी। ");
INSERT INTO bfz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","तेबे जेबे पीड़े देखेया कि एती ना तो यीशु ए और ना तिना रे चेले, तेबे सेयो बी किस्तिया रे चढ़ी की यीशुए खे टोल़दे ऊए, कफरनहूम नगरो रे पऊँछी गे। ");
INSERT INTO bfz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","समुद्रो ते पार जेबे सेयो यीशुए खे मिले तेबे तिने बोलेया, “ओ गुरू! तुसे एती कदी आये?” ");
INSERT INTO bfz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीशुए जवाब दित्तेया, “आऊँ तुसा खे सच-सच बोलूँआ कि तुसे माखे इजी री खातर नि टोल़दे कि तुसे मेरे सामर्था रे काम देखो, पर इजी री खातर कि तुसे रोटिया खाई की रज्जी गे। ");
INSERT INTO bfz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","नाशवान रोटिया खे मईणत नि करो, पर तेसा रोटिया खे मईणत करो, जो अनन्त जीवनो देओई, जो मां माणूं रे पुत्रो तुसा खे देणी, कऊँकि पिता परमेशरे माखे इजी खे देणे रा अक्क देई राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","तिने यीशुए खे बोलेया, “परमेशरो रे काम करने खे आसे क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीशुए बोलेया, “परमेशरो रा काम ये कि तुसे तेस पाँदे, जो तिने पेजी राखेया, विश्वास करो।” ");
INSERT INTO bfz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तेबे तिने तिना खे बोलेया, “तेबे तुसे कुण जा चिह्न् दखाओ कि आसे तेस देखी की तुसा पाँदे विश्वास करिए, तुसे कुण जा काम दखाओए? ");
INSERT INTO bfz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","आसा रे बाप-दादे जंगल़ो रे मन्ना खाया, जिंयाँ पवित्र शास्त्रो रे लिखी राखेया कि तिने तिना खे खाणे खे स्वर्गो ते रोटी दित्ती।” ");
INSERT INTO bfz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच-सच बोलूँआ कि मूसे सेयो रोटिया तुसा खे स्वर्गो ते नि दित्तिया, बल्कि मेरा पिता तुसा खे सच्ची रोटिया स्वर्गो ते देओआ। ");
INSERT INTO bfz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","कऊँकि परमेशरो री रोटी सेईए, जो स्वर्गो ते ऊतरी की दुनिया रे लोका खे जीवन देओई।” ");
INSERT INTO bfz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तेबे तिने तिना खे बोलेया, “ओ प्रभु! एसा रोटिया आसा खे सदा देया कर।” ");
INSERT INTO bfz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीशुए तिना खे बोलेया, “जीवनो री रोटी आऊँ ए; जो मांगे आऊणा, से कदी पूखा नि ऊणा और जेस मां पाँदे विश्वास करना, से कदी त्याया नि ऊणा। ");
INSERT INTO bfz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","पर मैं तुसा खे बोलेया था कि तुसे आऊँ देखी बी लया रा, तेबे बी विश्वास नि करदे। ");
INSERT INTO bfz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","जो कुछ पिता माखे देओआ, से सब मांगे आऊणा। जो कोई मांगे आऊणा से मां कदी नि निकयाल़ना। ");
INSERT INTO bfz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","कऊँकि आऊँ आपणी इच्छा नि बल्कि आपणे पेजणे वाल़े री इच्छा पूरी करने खे स्वर्गो ते उतरी रा। ");
INSERT INTO bfz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","और मेरे पेजणे वाल़े री इच्छा ये कि, जो कुछ तिने माखे देई राखेया, तिजी बीचा ते आऊँ कुछ नि रचाऊँ, पर तेस आखरी दिना रे फेर जिऊँदा करुँ। ");
INSERT INTO bfz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","कऊँकि मेरे पिते री इच्छा ये कि जो कोई पुत्रो खे देखो और तेस पाँदे विश्वास करो, से अनन्त जीवन पाओ और मां से आखरी दिनो रे फेर जिऊँदा करना।” ");
INSERT INTO bfz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","तेबे यहूदी तिना पाँदे कुड़कुड़ाणे लगे, कऊँकि तिने बोलेया था, “जो रोटी स्वर्गो ते उतरी, से आऊँ ई ये।” ");
INSERT INTO bfz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","तेबे तिने बोलेया, “क्या ये यूसुफो रा पाऊ यीशु निए, जेसरे माए-बाओ खे आसे जाणूंए? तेबे ये कऊँ बोलोआ कि आऊँ स्वर्गो ते उतरी रा?” ");
INSERT INTO bfz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीशुए तिना खे जवाब दित्तेया, “आपू बीचे नि कुड़कुड़ाओ। ");
INSERT INTO bfz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोई मांगे नि आयी सकदा, जदुओ तक पिता, जिने आऊँ पेजी राखेया, तेसखे खिंजी ना लओ और आऊँ तेसखे आखरी दिनो रे फेर जिऊँदा नि करी देऊँ। ");
INSERT INTO bfz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","भविष्यबक्ता रे लेखो रे ये लिखी राखेया, सेयो सब परमेशरो री तरफा ते सखाए रे ऊणे। जिने किने बी पिते ते सुणेया और सीखी राखेया, से मांगे आओआ। ");
INSERT INTO bfz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","किने बी पिता परमेशर नि देखी राखेया, मांते अलावा, जो पिता री तरफा ते पेजी राखेया, बस तिने ई पिता देखी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“आऊँ तुसा खे सच-सच बोलूँआ कि जो कोई विश्वास करोआ, अनन्त जीवन तेसरा ईए। ");
INSERT INTO bfz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","जीवनो री रोटी आऊँ ई ये। ");
INSERT INTO bfz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुसा रे बाप-दादे जंगल़ो रे मन्ना खाया और मरी गे। ");
INSERT INTO bfz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ये से रोटी ये, जो स्वर्गो ते उतरोई, ताकि मांणू तिजी बीचा ते खाओ और मरो नि। ");
INSERT INTO bfz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","जीवनो री रोटी, जो स्वर्गो ते उतरी, से आऊँ ई ये। जे कोई इजी रोटिया ते खाओ, तो सदा जिऊँदा रणा। जो रोटी मां दुनिया रे लोका खे सदा री जिन्दगिया खे देणी, से मेरा शरीर ए।” ");
INSERT INTO bfz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ये सुणी की यहूदी लोक आपू बीचे लड़ने लगे, “ये मांणू किंयाँ आसा खे आपणा मांस खाणे खे देई सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच-सच बोलूँआ कि जदुओ तक मां माणूं रे पुत्रो रा मांस नि खाओ और मेरा खून नि पियो, तुसा रे अनन्त जीवन निए। ");
INSERT INTO bfz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जो मेरा मांस खाओआ और मेरा खून पियोआ, अनन्त जीवन तेसरा ईए; और मां आखरी दिनो रे से फेर जिऊँदा करना। ");
INSERT INTO bfz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","कऊँकि मेरा मांस ई तो खाणे री चीज ए और मेरा खून ई तो पीणे री चीज ए। ");
INSERT INTO bfz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जो मेरा मांस खाओआ और मेरा खून पियोआ, से मांदे पक्का बणेया रा रओआ और आऊँ तेसरे। ");
INSERT INTO bfz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जिंयाँ जिऊँदे पिता परमेशरे आऊँ पेजी राखेया और आऊँ पिते री बजअ ते जिऊँदा ए, तिंयाँ ई से बी, जो माखे खाओगा, जिऊँदा रणा। ");
INSERT INTO bfz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","आँऊ ई से रोटी ए जो स्वर्गो ते उतरी री। तेसा रोटिया जेड़ी निए, जो बाप-दादेया खाई और मरी गे, जो कोई एसा रोटिया खाओगा, से सदा जिऊँदा रणा।” ");
INSERT INTO bfz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","यो गल्ला यीशुए कफरनहूम नगरो रे प्रार्थना रे कअरो रे, उपदेश देंदे ऊए बोलिया। ");
INSERT INTO bfz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","तेबे तिना रे चेलेया बीचा ते कई जणे ये सुणी की बोलेया, “यो गल्ला तो कठोर ए, इना कुण सुणी सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीशु आपणे मनो रे ये जाणी की कि मेरे चेले आपू बीचे एते गल्ला पाँदे कुड़कुड़ाओए, तिना ते पूछेया, “क्या तुसा खे इना गल्ला ते ठोकर लगोई? ");
INSERT INTO bfz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","और जे तुसे मां माणूं रे पुत्रो खे, जेती आँऊ पईले था, तेती ऊबे स्वर्गो खे जांदे ऊए देखोगे, तो क्या ऊणा? ");
INSERT INTO bfz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","परमेशरो रा आत्मा ईए जो जीवन देणे वाल़ा ए, पर शरीर ये नि देई सकदा, जो मैं तुसा खे बोली राखिया, सेयो आत्मिक बी ए और जीवन बी ए। ");
INSERT INTO bfz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","पर तुसा बीचा ते कई जणे तो एड़े ए, जो विश्वास नि करदे।” कऊँकि यीशु तो पईले तेई जाणो था कि जो विश्वास नि करदे, सेयो कूणे? और केस आऊँ पकड़वाणा? ");
INSERT INTO bfz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","और तिने बोलेया, “तेबेई तो मैं तुसा खे बोलेया था कि जदुओ तक केसी खे पिते री तरफा ते ये बरदान नि दित्तेया जाओ, तदुओ तक से मांगे नि आयी सकदा।” ");
INSERT INTO bfz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ये सुणी की तिना रे चेलेया बीचा ते कई जणे उल्टे फिरी गे और तिजी ते बाद तिना साथे नि चले। ");
INSERT INTO bfz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तेबे यीशुए तिना बारा चेलेया खे बोलेया, “क्या तुसे बी जाणा चाओए?” ");
INSERT INTO bfz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","शमौन पतरसे तिना खे जवाब दित्तेया, “ओ प्रभु! आसे केसगे जाऊँ? अनन्त जीवनो री गल्ला तो तुसा गे ई ये ");
INSERT INTO bfz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","और आसे विश्वास कित्तेया और जाणी गे रे कि परमेशरो रा पवित्र जन तूँ ई ये।” ");
INSERT INTO bfz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीशुए तिना खे बोलेया, “क्या मैं तुसे बारा जणे नि चूणी राखे? तेबे बी तुसा बीचा ते एक मांणू शैतान ए।” ");
INSERT INTO bfz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ये तिने शमौन इस्करियोतियो रे पाऊ यहूदा रे बारे रे बोलेया था, कऊँकि येई तिना बारा चेलेया बीचा ते था, जो यीशुए खे पकड़वाणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","इना गल्ला ते बाद यीशु गलील प्रदेशो रे कुमदे-फिरदे रये, कऊँकि यहूदी अगुवे तिना खे काणे री कोशिश करने लगी रे थे, तेबेई तो सेयो यहूदिया प्रदेशो रे कूमणा नि चाओ थे। ");
INSERT INTO bfz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","यहूदिया रा चूँगड़िया रा त्योआर नेड़े था। ");
INSERT INTO bfz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","यीशुए रे पाईए तिना खे बोलेया, “एथा ते यहूदिया प्रदेशो खे चली जा, ताकि जो चमत्कारा रे काम तूँ करेया, तिना कामा तेरे और चेले तेती बी देखो। ");
INSERT INTO bfz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","कऊँकि एड़ा कोई नि ऊणा, जो मशुर ऊणा चाओ और लुकी की काम करो, जे तूँ इना काम करोआ, तो आपू खे दुनिया रे सामणे ल्याओ।” ");
INSERT INTO bfz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","कऊँकि तिना रे पाई बी तिना पाँदे विश्वास नि करो थे। ");
INSERT INTO bfz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तेबे यीशुए तिना खे बोलेया, “मेरा सई बखत एबु नि आयी रा, पर तुसा रिया तंईं सारा बखत ए। ");
INSERT INTO bfz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","दुनिया रे लोक तुसा ते बैर नि करी सकदे, पर से मांते बैर करोए, कऊँकि आऊँ तेसा रे बिरोदो रे येई गवाई देऊँआ कि तेसा रे काम बुरे ए। ");
INSERT INTO bfz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुसे त्योआरो रे जाओ, आऊँ एबु एस त्योआरो खे नि जाई सकदा, कऊँकि एबुए तक मेरा सई बखत पूरा नि ऊई रा।” ");
INSERT INTO bfz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","यीशु तिना साथे इना गल्ला करी की गलील प्रदेशो रेई रई गे। ");
INSERT INTO bfz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","पर जेबे तिना रे पाई त्योआरो खे चली गे, तेबे सेयो आपू बी सामणे नि, पर चोरिए जे चली गे। ");
INSERT INTO bfz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","तेबे यहूदी अगुवे त्योआरो रे तिना खे ये बोली की टोल़ने लगे कि, “से केयी ए?” ");
INSERT INTO bfz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","और लोका बीचे चोरिए-चोरिए तिना रे बारे रे मुखती गल्ला ऊईया, बऊत जणे बोलो थे, “से पला मांणू ए और कई जणे बोलो थे कि नई, से तो लोका खे भरमाओआ।” ");
INSERT INTO bfz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","तेबे बी यहूदिया रे डरो रे मारे कोई बी मांणू तिना रे बारे रे खुली की नि बोलो था। ");
INSERT INTO bfz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","जेबे त्योआरो रे आदे दिन बीती गे, तेबे यीशु मन्दरो रे आँगणो रे जाई की उपदेश देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","तेबे यहूदिये हैरान ऊई की बोलेया, “एसखे बिना पढ़े बिद्या केथा ते आईगी?” ");
INSERT INTO bfz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीशुए तिना खे बोलेया, “मेरा उपदेश मेरा नि, बल्कि मेरे पेजणे वाल़े राए। ");
INSERT INTO bfz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","जे कोई परमेशरो री इच्छा पाँदे चलणा चाओ, तो तेसखे एस उपदेशो रे बारे रे पता लगी जाणा कि ये परमेशरो रिया तरफा तेया या आऊँ आपू ते बोलूँआ। ");
INSERT INTO bfz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जो आपू ते कुछ बोलोआ, से आपणी तारीफ चाओआ, पर जो आपणे पेजणे वाल़े री तारीफ चाओआ, सेई परोसे रे जोगा ए और से पापी निए। ");
INSERT INTO bfz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","क्या मूसे तुसा खे बिधान नि देई राखेया? तेबे बी तुसा बीचा ते कोई बी बिधानो पाँदे नि चलदा। तुसे माखे काणा कऊँ चाओए?” ");
INSERT INTO bfz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","लोके जवाब दित्तेया, “तांदे दुष्टात्मा ए, ताखे कुण काणा चाओआ।” ");
INSERT INTO bfz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीशुए तिना खे जवाब दित्तेया, “मैं आरामो रे दिने एक चमत्कार कित्तेया और तुसे सब हैरानी करोए। ");
INSERT INTO bfz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","तुसे बोलोए कि मूसे तुसा खे खतने री आज्ञा देई राखी। इजी री बजअ ते तुसे आरामो रे दिने मांणूआ रा खतना करोए। ये नियम मूसे री तरफा ते निए, पर तुसा रे बाप-दादेया रे बखतो ते चले आयी रे। ");
INSERT INTO bfz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","तेबेई तो आरामो रे दिने मांणूए रा खतना करेया जाओआ, ताकि मूसे रे बिधानो री आज्ञा टल़ी नि जाओ, तो तुसे मां पाँदे रोष कऊँ करोए कि मैं आरामो रे दिने एक मांणू अच्छी रीतिया ते ठीक कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मूँ देखी की न्याय नि करो, पर ठीक-ठीक न्याय करो।” ");
INSERT INTO bfz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तेबे कई यरूशलेमी लोक बोलणे लगे, “क्या ये सेई निए, जेसखे काणे री कोशिश ऊणे लगी री? ");
INSERT INTO bfz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पर देखो, ये तो खुल्लमखुल्ला गल्ला करोआ और कोई एसखे कुछ नि बोलदा, केथी एड़ा तो निए कि अधिकारिए सच-सच जाणी ला रा कि येई मसीह ए? ");
INSERT INTO bfz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","एसखे तो आसे जाणूंए कि ये केथो राए; पर मसीह जेबे आऊणा, तेबे केसी नि जाणना कि से केथो राए?” ");
INSERT INTO bfz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तेबे यीशुए मन्दरो रे आँगणो रे उपदेश देंदे ऊए जोरे की बोलेया, “तुसे माखे जाणोए और ये बी जाणोए कि आऊँ केथो राए, आऊँ आपू ते नि आयी रा, पर माखे पेजणे वाल़ा सच्चा ए, तेसखे तुसे नि जाणदे। ");
INSERT INTO bfz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","पर आऊँ तेसखे जाणूंआ, कऊँकि आऊँ तेसरी तरफा ते और तिने आऊँ पेजी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","तेबे तिने सेयो पकड़ना चाए, पर तेबे बी किने बी तिना पाँदे आथ नि पाया, कऊँकि तिना रा सई बखत एबुए तक नि आयी रा था। ");
INSERT INTO bfz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","तेबे बी पीड़ा बीचा ते कई जणेया तिना पाँदे विश्वास कित्तेया और बोलणे लगे, “मसीह जेबे आऊणा, तो क्या एसते जादा सामर्था रे काम दखाणे, जो इने दखाए?” ");
INSERT INTO bfz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसिये, लोका ते तिना रे बारे रे यो गल्ला चोरिए-चोरिए करदे ऊए सुणिया और बड़े पुरोईत और फरीसिये तिना खे पकड़ने खे मन्दरो रे पईरेदार पेजे। ");
INSERT INTO bfz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","तेबे यीशुए बोलेया, “आऊँ थोड़ी देर तक ओर तुसा साथे ए, तेबे आपणे पेजणे वाल़े गे चली जाणा। ");
INSERT INTO bfz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुसा आऊँ टोल़ना, पर मिलणा नि और जेती आऊँ ए, तेती तुसे आयी नि सकदे।” ");
INSERT INTO bfz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","तेबे यहूदिये अगुवे आपू बीचे बोलेया, “ये केयी जाणा, कि आसा खे नि मिलणा? क्या ये तिना बीचे जाणा, जो यूनानो रे ओरे-पोरे ऊई की रओए और यूनानिया खे बी उपदेश देओगा? ");
INSERT INTO bfz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ये क्या गल्ल ए, जो इने बोली कि, ‘तुसा आऊँ टोल़ना, पर मिलणा नि और जेती आऊँ ए, तेती तुसे आयी नि सकदे?’ ” ");
INSERT INTO bfz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","तेबे त्योआरो रे आखरी दिने, जो खास दिन था, यीशु खड़े ऊईगे और आक्का पाई की बोलेया, “जेसखे त्याय ए, तो से मांगे आओ और पियो। ");
INSERT INTO bfz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जो मां पाँदे विश्वास करोगा, जेड़ा पवित्र शास्त्रो रे लिखी राखेया, ‘तेसरे दिलो ते जिन्दगिया रे पाणिए रिया नदिया बईंदिया निकल़निया।’ ” ");
INSERT INTO bfz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","तिने ये वचन पवित्र आत्मा रे बारे रे बोलेया, जो तिना पाँदे विश्वास करने वाल़ेया खे मिलणे वाल़ी थी। कऊँकि पवित्र आत्मा एबुए तक नि उतरी रा था, कऊँकि यीशु एबुए तक आपणी महिमा रे नि पऊँछेया था। ");
INSERT INTO bfz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","तेबे पीड़ा बीचा ते किने-किने ये गल्ला सुणी की बोलेया, “सच्ची येई से भविष्यबक्ता ए, जेसरे आऊणे री आसे उम्मीद लगाई राखी।” ");
INSERT INTO bfz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","कईए बोलेया, “ये मसीह ए।” पर कईए बोलेया कऊँ, “क्या मसीह गलील प्रदेशो ते आऊणा? ");
INSERT INTO bfz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","क्या पवित्र शास्त्रो रे नि लिखी राखेया कि मसीह दाऊदो रे कुलो रे और बैतलहमो रे गांव ते आऊणा, जेती दाऊद रओ था?” ");
INSERT INTO bfz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","तेबे तिना री बजअ ते लोका बीचे फूट पड़ी गी। ");
INSERT INTO bfz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","तिना बीचा ते कई जणे यीशुए खे पकड़ना चाओ थे, पर किने बी तिना पाँदे आथ नि पाया। ");
INSERT INTO bfz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तेबे मन्दरो रे पईरेदार, बड़े पुरोईत और फरीसिया गे वापस आए, तेबे तिने तिना खे बोलेया, “तुसे तेसखे कऊँ नि ल्याए?” ");
INSERT INTO bfz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","मन्दरो रे पईरेदारे बोलेया, “किने बी मांणूए कदी बी एड़िया गल्ला नि बोलिया।” ");
INSERT INTO bfz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरीसिये पईरेदारा खे बोलेया, “क्या तुसे बी भरमाई गे दे? ");
INSERT INTO bfz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","क्या अधिकारी और फरीसिया बीचा ते किने बी तेस पाँदे विश्वास करी राखेया? ");
INSERT INTO bfz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","पर यो लोक जो मूसे रे बिधानो खे नि जाणदे, परमेशरो री तरफा ते स्रापित ए।” ");
INSERT INTO bfz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुसे जो पईले यीशुए गे राती आया था और तिना बीचा ते एक था, तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“क्या आसा रा बिधान केसी मांणूए खे, जदुओ तक तेसरी सुणी की जाणी नि लओ कि से क्या करोए; दोषी मानोआ?” ");
INSERT INTO bfz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","तिने तेसखे जबाब दित्तेया, “ओ नीकुदेमुस, क्या तूँ बी गलील प्रदेशो राए? पवित्र शास्त्रो रे टोल़ और देख कि गलील प्रदेशो ते कोई बी भविष्यबक्ता आई नि सकदा।” ");
INSERT INTO bfz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","तेबे सब आपणे-आपणे कअरो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","यीशु जैतूनो रे पाह्ड़ो पाँदे चली गे। ");
INSERT INTO bfz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","आगले दिने प्यागा फेर से मन्दरो रे आईगे और बऊत लोक तिना गे आईगे और यीशु मन्दरो रे आँगणो रे बैठी की तिना खे उपदेश देणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तेबे शास्त्री और फरीसी एक जवाणसा खे ल्याए, जो व्याभिचार करदे ऊए पकड़ी थी और से बीचे खड़ी करी ती ");
INSERT INTO bfz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","और यीशुए खे बोलेया, “ओ गुरू! ये जवाणस व्याभिचार करदे ऊए पकड़ी राखी। ");
INSERT INTO bfz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","बिधानो रे मूसे आसा खे आज्ञा देई राखी कि एड़िया जवाणसा खे पत्थराव करना चाईयो। तो तुसे एसा जवाणसा रे बारे रे क्या बोलोए?” ");
INSERT INTO bfz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","तिने तिना खे परखणे खे ये गल्ल बोली, ताकि तिना रे दोष लगाणे खे कोई गल्ल पकड़ो, पर यीशु चुकी की गूठिये की जमीना पाँदे लिखणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जेबे सेयो तिना ते पुछदे ई रये, तेबे तिने सीदे ऊई की तिना खे बोलेया, “तुसा बीचा ते जो निष्पाप ए सेई एसा पाँदे पईले पात्थर बाओ।” ");
INSERT INTO bfz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","और तेबे फेर चुकी की जमीना पाँदे गुठिया साथे लिखणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","पर सेयो ये सुणी की बड़ेया ते लयी की छोटेया तक, एक-एक करी की निकल़ी गे और यीशु कल्ले रई गे और जवाणस तेथी बीचे खड़ी री रईगी। ");
INSERT INTO bfz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीशुए सीदे ऊई की तेसा खे बोलेया, “ओ जवाणसे! सेयो केयी गे? क्या किने बी तां पाँदे दण्डो री आज्ञा नि दित्ती?” ");
INSERT INTO bfz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","तेसे बोलेया, “ओ प्रभु! किने पनि।” यीशुए बोलेया, “आऊँ बी तां पाँदे दण्डो री आज्ञा नि देंदा, जा और फेर पाप नि करना।” ");
INSERT INTO bfz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","तेबे यीशुए फेर लोका खे बोलेया, “दुनिया री जोति आऊँ ई ये, जो मां पीछे आऊणा, से न्हेरे रे नि चलणा, बल्कि तेस जोति पाणी जो जीवन देओई।” ");
INSERT INTO bfz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसिये तिना खे बोलेया, “तूँ आपणी गवाई आपू देओआ, तेरी गवाई ठीक निए।” ");
INSERT INTO bfz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीशुए तिना खे बोलेया, “बेशक आऊँ आपणी गवाई आपू ई देऊँआ, तेबे बी मेरी गवाई ठीक ए, कऊँकि आऊँ जाणूंआ कि आऊँ केथा ते आयी रा और केथो खे जाऊँआ? पर तुसे नि जाणदे कि आऊँ केथा ते आयी रा और केथो खे जाऊँआ? ");
INSERT INTO bfz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुसे मूँ देखी की न्याय करोए, आऊँ केसी रा न्याय नि करदा ");
INSERT INTO bfz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","और जे आऊँ न्याय करुँ बी, तो मेरा न्याय सच्चा ए, कऊँकि आऊँ कल्ला निए, पर पिता जिने आऊँ पेजी राखेया मां साथे ए। ");
INSERT INTO bfz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","तुसा रा बिधानो रे बी लिखी राखेया कि दो जणेया री गवाई मिली की ठीक ओई, ");
INSERT INTO bfz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","एक तो आऊँ आपणी गवाई देऊँआ और दूजा पिता मेरी गवाई देओआ, जिने आऊँ पेजी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","तिने तिना खे बोलेया, “तेरा पिता केयी ए?” यीशुए बोलेया, “ना तुसे माखे जाणदे और ना मेरे पिते खे, जे तुसे माखे जाणदे तो मेरे पिते खे बी जाणदे।” ");
INSERT INTO bfz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","यो गल्ला तिने मन्दरो रे आँगणो रे उपदेश देंदे ऊए पण्डार कअरो रे बोलिया और किने बी सेयो पकड़े नि, कऊँकि एबुए तक तिना रा सई बखत नि आयी रा था। ");
INSERT INTO bfz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीशुए फेर तिना खे बोलेया, “आऊँ जाऊँआ और तुसा आऊँ टोल़ना और आपणे पापो रे मरने। जेती आऊँ जाऊँआ, तेती तुसे नि आयी सकदे।” ");
INSERT INTO bfz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","तेबे यहूदिये अगुवे बोलेया, “क्या ये आपणे आपू खे कायी देओगा, जो बोलोआ, ‘जेती आऊँ जाऊँआ तेती तुसे नि आयी सकदे’?” ");
INSERT INTO bfz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","यीशुए तिना खे बोलेया, “तुसे ऊँदले ए और आऊँ स्वर्गो राए, तुसे दुनिया रे ए और आऊँ दुनिया रा निए। ");
INSERT INTO bfz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","तेबेई तो मैं तुसा खे बोलेया कि तुसे आपणे पापो ते मरने, कऊँकि जे तुसे विश्वास नि करोगे कि आऊँ सेईए, तो आपणे पापो रे मरने।” ");
INSERT INTO bfz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","यहूदी अगुवे तिना खे बोलेया, “तूँ कूणे?” यीशुए तिना खे बोलेया, “आँऊ सेईए, जो शुरूओ ते तुसा खे बोलदा ऊआ आयी रा, ");
INSERT INTO bfz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुसा रे बारे रे मां बऊत कुछ बोलणा और न्याय करना ए, पर मेरा पेजणे वाल़ा सच्चा ए और जो मैं तेसते सुणी राखेया, सेई दुनिया रे लोका खे बोलूँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","सेयो एबुए तक ये नि समजे कि यीशु तिना गे आपणे पिता परमेशरो रे बारे रे बोलणे लगी रा। ");
INSERT INTO bfz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तेबे यीशुए बोलेया, “जेबे तुसा आँऊ माणूं रा पुत्र ऊच्चे पाँदे चढ़ाणा, तेबे जाणना कि आऊँ सेईए और आपणे आपू ते कुछ नि करदा, बल्कि जिंयाँ पिता परमेशरे माखे सखयाल़ी राखेया, तिंयाँ ई इना गल्ला खे बोलूँआ। ");
INSERT INTO bfz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","माखे पेजणे वाल़ा मां साथे ए, तिने आऊँ कल्ला नि छाडी राखेया, कऊँकि आऊँ सदा सेई काम करूँआ, जेते साथे से खुश ओआ।” ");
INSERT INTO bfz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","सेयो इना गल्ला बोलणे ई लगी रे थे कि बऊत जणेया तिना पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तेबे यीशुए तिना यहूदिया खे, जिने तिना पाँदे विश्वास कित्तेया था, बोलेया, “जे तुसे मेरे वचनो रे बणे रे रओगे, तो सच्ची मेरे चेले ठईरने। ");
INSERT INTO bfz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तुसा सच जाणना और सच्चो तुसे आजाद करने।” ");
INSERT INTO bfz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","तिने यीशुए खे बोलेया, “आसे तो अब्राहमो रे कुल़ो ते ए और कदी केसी रे दास नि ऊए। तेबे तुसे कऊँ बोलोए कि तुसे आजाद ऊई जाणे?” ");
INSERT INTO bfz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीशुए तिना खे जवाब दित्तेया, “आऊँ तुसा खे सच-सच बोलूँआ कि जो कोई पाप करोआ, से पापो रा दास ए। ");
INSERT INTO bfz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","दास सदा कअरे नि रंदा, पाऊ सदा कअरे रओआ। ");
INSERT INTO bfz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","तेबे जे पुत्र तुसा खे आजाद करोगा, तो सच्ची तुसे आजाद ऊई जाणे। ");
INSERT INTO bfz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","आऊँ जाणूंआ कि तुसे अब्राहमो रे कुल़ो ते ए, तेबे बी मेरा वचन तुसा रे दिलो रे नि बसदा, तेबेई तो तुसे माखे काणा चाओए। ");
INSERT INTO bfz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","आऊँ सेई बोलूँआ, जो मैं पिते गे देखी राखेया और तुसे सेई करदे रओए, जो तुसे आपणे पिते ते सुणी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","तिने बोलेया, “आसा रा पिता तो अब्राहम ए।” यीशुए तिना खे बोलेया, “जे तुसे अब्राहमो री ल्वाद ऊँदे तो अब्राहमो जेड़े काम करदे। ");
INSERT INTO bfz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","पर एबे तुसे मां जेड़े मांणूए खे काणा चाओए, जिने तुसा गे से सच्चा वचन बताया, जो परमेशरो ते सुणेया, ये तो अब्राहमे नि कित्तेया था। ");
INSERT INTO bfz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुसे आपणे पिते जेड़ा काम करोए।” तिने यीशुए खे बोलेया, “आसे व्याभिचारो ते नि जम्मी रे, आसा रा एक ई पिता ए, मतलब-परमेशर।” ");
INSERT INTO bfz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीशुए तिना खे बोलेया, “जे परमेशर तुसा रा पिता ऊँदा, तो तुसे मां साथे प्यार राखदे, कऊँकि आऊँ परमेशरो री तरफा ते आयी रा, आऊँ आपू ते नि आयी रा, बल्कि तिने ई आऊँ पेजी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","तुसे मेरी गल्ल कऊँ नि समजदे? क्या तेबे कि तुसे मेरा वचन नि सुणी सकदे? ");
INSERT INTO bfz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुसा रा पिता शैतान ए और तुसे आपणे पिते री इच्छा पूरी करना चाओए। से तो शुरूओ तेई अत्यारा ए और सच्चो पाँदे खड़ा नि रंदा, कऊँकि सच तेसरे आया ई नि, जेबे से चूठ बोलोआ, तेबे से आपणे ई सबाओ ते बोलोआ, कऊँकि से चूठा ए, बल्कि चूठो रा पिता ए। ");
INSERT INTO bfz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","पर आऊँ जो सच बोलूँआ, तेबेई तो तुसे मेरा विश्वास नि करदे। ");
INSERT INTO bfz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुसा बीचा ते कुण माखे पापी ठराओआ? जे आऊँ सच बोलूँआ, तो तुसे मेरा विश्वास कऊँ नि करदे? ");
INSERT INTO bfz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जो कोई परमेशरो राए, से परमेशरो री गल्ला सुणोआ। ये गल्ला तुसे तेबे नि सुणदे, कऊँकि तुसे परमेशरो रे निए।” ");
INSERT INTO bfz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ये सुणी की यहूदिये तिना खे बोलेया, “क्या आसे ठीक नि बोलदे कि तूँ सामरी ए और तांदे दुष्टात्मा ए?” ");
INSERT INTO bfz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीशुए जवाब दित्तेया, “मांदे दुष्टात्मा निए, पर आऊँ आपणे पिते रा आदर करूँआ और तुसे मेरा आदर नि करदे। ");
INSERT INTO bfz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","पर आऊँ आपणा आदर नि चांदा, पर आ, एक तो आए, जो मेरा आदर करवाणा चाओआ और से इजी रा न्याय करोआ। ");
INSERT INTO bfz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","आऊँ तुसा खे सच-सच बोलूँआ कि जे कोई मांणू मेरे वचनो पाँदे चलोगा, तो तेसखे अनन्तकालो तक मौत नि आऊणी।” ");
INSERT INTO bfz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदिये यीशुए खे बोलेया, “एबे तो आसे जाणी ला रा कि तांदे दुष्टात्मा ए, अब्राहम तो मरी गा रा और भविष्यबक्ता बी मरी गे रे और तूँ बोलेया कि ‘जो कोई मेरे वचनो पाँदे चलोगा, तो तेसखे अनन्तकालो तक मौत नि आऊणी।’ ");
INSERT INTO bfz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","आसा रा पिता अब्राहम तो मरी गा रा, क्या तूँ तेसते बड़ा ए? भविष्यबक्ता बी मरी गे रे, तूँ आपणे आपू खे क्या समजेया?” ");
INSERT INTO bfz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीशुए बोलेया, “जे आऊँ आपणी महिमा आपू ई करने लगी जाऊँ, तो मेरी महिमा कुछ निए, पर मेरी महिमा करने वाल़ा मेरा पिता ए, जेसखे तुसे बोलोए कि आसा रा परमेशर ए। ");
INSERT INTO bfz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","तुसे तो से नि जाणेया, पर आऊँ तेसखे जाणूंआ, और जे बोलूँ कि आऊँ तेसखे नि जाणदा, तो आऊँ तुसा जेड़ा चूठा ठईरूँगा, पर आऊँ तेसखे जाणूंआ और तेसरे वचनो पाँदे चलूँआ। ");
INSERT INTO bfz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुसा रा पिता अब्राहम मेरा दिन देखणे री इच्छा रे बऊत मग्न था और तिने देखेया और खुश ऊआ।” ");
INSERT INTO bfz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदिये तिना खे बोलेया, “एबुए तक तूँ पंजा साला रा नि ऊआ, तेबे बी तैं अब्राहम देखी राखेया?” ");
INSERT INTO bfz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीशुए तिना खे बोलेया, “आऊँ तुसा खे सच-सच बोलूँआ कि अब्राहमो रे पैदा ऊणे ते पईले, आऊँ ए।” ");
INSERT INTO bfz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तेबे तिने यीशुए खे बाणे खे पात्थर चके, पर यीशु लुकी की मन्दरो ते निकल़ी गे। ");
INSERT INTO bfz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","यीशु और तिना रे चेलेया तीसिए जांदे ऊए एक एड़ा मांणू देखेया, जो जन्मो तेई अन्दा था। ");
INSERT INTO bfz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","तेबे तिना रे चेलेया तिना ते पूछेया, “ओ गुरू! किने पाप कित्तेया था, इने मांणूए, जो अन्दा जम्मेया या एसरे माए-बाओ?” ");
INSERT INTO bfz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीशुए जवाब दित्तेया, “ना तो इने पाप करी राखेया और ना एसरे माए-बाओ कि ये अन्दा जम्मेया, पर ये तेबे ऊआ, ताकि परमेशरो रे सामर्था रे काम एस पाँदे प्रगट ओ। ");
INSERT INTO bfz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जिने आऊँ पेजी राखेया, आसा खे जरूरी ये कि आसे तेसरे काम दिनो-दिने ई नपटयाणा जरूरी ए, कऊँकि से रात आऊणे वाल़ी ए, जिदे कोई काम नि करी सकदा। ");
INSERT INTO bfz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जदुओ तक आऊँ दुनिया रे ए, तदुओ तक, दुनिया री जोति ए।” ");
INSERT INTO bfz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ये बोली की तिने जमीना पाँदे थूकेया और तेस थूको साथे माट्टी सीन्नी कित्ती और से माट्टी तेस अन्दे रिया आखी रे मल़ी की ");
INSERT INTO bfz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","तेसखे बोलेया, “जा, और शीलोहो रे कुण्डो रे आपणी आखी तोई लो” (जेतेरा मतलब पेजे राए) तेबे तिने जायी की आखी तोईया और देखदा ऊआ आया। ");
INSERT INTO bfz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तेबे तेस मांणूए रे पड़ोसिये और जिने से पईले पीख मांगदा ऊआ देखेया था, एकी दूजे ते बोलणे लगे, “क्या ये सेई निए, जो बैठेया रा पीख माँगो था?” ");
INSERT INTO bfz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कईए बोलेया, “ये सेईए,” ओरी बोलेया, “ना, ये तो तेसरा हमशक्ल ए।” तिने बोलेया, “आऊँ सेईए।” ");
INSERT INTO bfz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तेबे सेयो तेसते पूछणे लगे, “तेरिया आखी किंयाँ ठीक ऊईगिया?” ");
INSERT INTO bfz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","तेबे तिने बोलेया, “यीशु नाओं रे एक मांणूए माट्टी सेड़ी और मेरी आखी रे मल़ी और माखे बोलेया, ‘जा और शीलोहो रे कुन्डो रे आपणी आखी तोई लो।’ तेबे आऊँ कुण्डो रे गया और आखी तोई की देखणे लगी गा।” ");
INSERT INTO bfz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","तिने तेसते पूछेया, “से मांणू केयी ए?” तिने बोलेया, “आऊँ नि जाणदा।” ");
INSERT INTO bfz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","तेबे लोक तेसखे, जो पईले अन्दा था, फरीसिये गे लयी गे। ");
INSERT INTO bfz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जेस दिने यीशुए माट्टी सेड़ी की तेसरी आखी ठीक कित्तिया थिया, से आरामो रा दिन था। ");
INSERT INTO bfz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","तेबे फरीसिये बी तेसते पूछेया, “तेरिया आखी किंयाँ ठीक ऊईगिया?” तिने बोलेया, “तिने मेरी आखी रे माट्टी लगाई, तेबे मैं तोईया और एबे देखणे लगेया।” ");
INSERT INTO bfz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","तेबे कई फरीसी बोलणे लगे, “ये मांणू परमेशरो री तरफा ते निए, कऊँकि से आरामो रा दिन नि मानदा।” ओरी बोलेया, “पापी मांणू किंयाँ एड़े चिह्न् दखाई सकोआ?” तेबे तिना बीचे फूट पड़ी गी। ");
INSERT INTO bfz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","तिने तेस अन्दे खे फेर बोलेया, “जिने तेरी आखी कित्तिया ठीक कि तूँ तेसरे बारे रे क्या बोलेया?” तिने बोलेया, “से भविष्यबक्ता ए।” ");
INSERT INTO bfz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","पर यहूदिया खे विश्वास नि ऊआ कि ये अन्दा था और एबे देखोआ, जदुओ तक तिने तेसरे माए-बाओ बुलाई की ");
INSERT INTO bfz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","सेयो नि पूछी ले, “क्या ये तुसा रा पाऊ ए, जेसखे तुसे बोलोए कि अन्दा जम्मी रा? तेबे एबे किंयाँ देखोआ?” ");
INSERT INTO bfz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","तेसरे माए-बाओ बोलेया, “आसे ये तो जाणूंए कि ये आसा रा पाऊ ए और जन्मो ते अन्दा था। ");
INSERT INTO bfz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पर ये नि जाणदे कि किंयाँ देखणे लगी गा और ना ई ये जाणदे कि किने एसरिया आखी ठीक कित्तिया। से छोटा जा बच्चा निए, तेसते ई पूछी लो, तेस आपणे बारे रे आपू ई बताई देणा।” ");
INSERT INTO bfz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","यो गल्ला तिने तेबे बोलिया कऊँकि, सेयो यहूदी अगुओ ते डरो थे, कऊँकि यहूदी अगुवे एक मत ऊई चुके थे कि जे कोई ये विश्वास करोगा कि से मसीह ए, तो से प्रार्थना रे कअरो ते निकयाल़ी देणा। ");
INSERT INTO bfz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","इजी री बजअ ते तेसरे माए-बाओ बोलेया, “से छोटा जा बच्चा निए, एसते ई पूछी लो।” ");
INSERT INTO bfz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तेबे यहूदी अगुवे तेस मांणूए ते, जो अन्दा था, दूजी बार बुलाई की तेसखे बोलेया, “परमेशरो खे गवा मानी की सच बोल, आसे तो जाणूंए कि से मांणू पापी ए।” ");
INSERT INTO bfz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","तिने बोलेया, “आऊँ नि जाणदा कि से पापी ए कि नई, आऊँ एक गल्ल जाणूंआ कि आऊँ पईले अन्दा था और एबे देखी सकूँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","तिने तेसखे फेर बोलेया, “तिने तां साथे क्या कित्तेया और तेरी आखी किंयाँ ठीक कित्तिया?” ");
INSERT INTO bfz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","तिने तिना खे बोलेया, “आऊँ तो तुसा खे बोली चुकेया रा और तुसेई नि सुणेया, एबे दूजी बार कऊँ सुणना चाओए? क्या तुसे बी तेसरे चेले बणना चाओए?” ");
INSERT INTO bfz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तेबे सेयो तेसखे खरा-बुरा बोलणे लगे, “तूँ ई तेसरा चेला ए, आसे तो मूसे रे चेले ए। ");
INSERT INTO bfz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","आसे जाणूंए कि परमेशरे मूसे साथे गल्ला कित्तिया, पर एस मांणूए खे नि जाणदे कि केथो राए?” ");
INSERT INTO bfz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","तिने तिना खे बोलेया, “ये तो हैरानिया री गल्ल ए कि तुसे नि जाणदे कि से केथो राए, तेबे बी तिने मेरिया आखी ठीक कित्तिया। ");
INSERT INTO bfz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","आसे जाणूंए कि परमेशर पापिया री नि सुणदा, पर जे कोई परमेशरो रा भक्त ओ और तेसरी इच्छा पाँदे चलोआ, तो से तेसरी सुणोआ। ");
INSERT INTO bfz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","दुनिया री शुरूआता ते ये कदी बी सुणने बीचे नि आया कि किने बी जन्मो रे अन्दे रिया आखी ठीक कित्तिया ओ। ");
INSERT INTO bfz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","जे ये मांणू परमेशरो री तरफा ते नि ऊँदा, तो कुछ पनि करी सको था।” ");
INSERT INTO bfz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","तिने तेसखे जवाब दित्तेया, “तूँ तो बिल्कुल पापो ते जम्मी रा, तूँ आसा खे क्या सिखाएया?” और तिने से बारे निकयाल़ी ता। ");
INSERT INTO bfz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","जेबे यीशुए सुणेया कि तिने से बारे निकयाल़ी ता, तेबे सेयो तेसखे मिले और बोलेया, “क्या तूँ माणूं रे पुत्रो पाँदे विश्वास करेया?” ");
INSERT INTO bfz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","तिने जवाब दित्तेया, “ओ प्रभु! से कुणे कि आऊँ तेस पाँदे विश्वास करूँ?” ");
INSERT INTO bfz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीशुए तेसखे बोलेया, “तैं से देखी बी राखेया और जो तां साथे जपणे लगी रा से येईए।” ");
INSERT INTO bfz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","तिने बोलेया, “ओ प्रभु! आँऊ विश्वास करूँआ।” और तिने तिना गे माथा टेकेया। ");
INSERT INTO bfz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तेबे यीशुए बोलेया, “आँऊ एसा दुनिया पाँदे न्याय करने आयी रा ताकि जो देखदे नि,सेयो देखो और जो देखोए, सेयो अन्दे ऊई जाओ।” ");
INSERT INTO bfz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","जो फरीसी तिना साथे थे तिने यो गल्ला सुणी की तिना खे बोलेया, “क्या आसे बी अन्दे ए?” ");
INSERT INTO bfz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीशुए तिना खे बोलेया, “जे तुसे अन्दे ऊँदे तो पापी नि ऊँदे, पर एबे बोलोए कि आसे देखूँए, तेबेई तो तुसा रा पाप बणेया रा रओआ।” ");
INSERT INTO bfz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","यीशुए फेर बोलेया, “आऊँ तुसा खे सच-सच बोलूँआ कि जो कोई गवाईणी रे द्वारो ते नि जांदा, पर ओरी किसीये चढ़ी जाओआ, से चोर और डाकू ए। ");
INSERT INTO bfz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पर जो-जो द्वारो रिये आओआ, से पेडा खे चराणे वाल़ा ए। ");
INSERT INTO bfz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","तेसखे द्वारपाल द्वार खोली देओआ और पेडा तेसरा ग्लाणा पछयाणोईया और से आपणी पेडा खे नाओं लयी-लयी की बुलाओआ और बारे लयी जाओआ। ");
INSERT INTO bfz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","जेबे से आपणी सारी पेडा खे बारे निकाल़ी चुकोआ, तेबे से तिना रे आगे-आगे चलोआ और पेडा तेस पीछे-पीछे चलणे लगोईया, कऊँकि सेयो तेसरा ग्लाणा पछयाणोईया। ");
INSERT INTO bfz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पर सेयो ओरी पीछे नि जांदिया, बल्कि तेसगे ते नठी जाओईया, कऊँकि सेयो ओरी री आवाज नि पछयाणदिया।” ");
INSERT INTO bfz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीशुए तिना खे ये उदारण बोलेया, पर सेयो नि समजे कि यो कुण जी गल्ला ए, जो ये आसा खे बोलणे लगी रा। ");
INSERT INTO bfz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तेबे यीशुए तिना खे फेर बोलेया, “आऊँ तुसा खे सच-सच बोलूँआ कि पेडा रा पीतरे आऊणे रा द्वार आऊँ ए। ");
INSERT INTO bfz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जितणे मांते पईले आए, सेयो सब चोर और डाकू ए, पर मेरी पेडे तिना री नि सुणी। ");
INSERT INTO bfz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","द्वार आऊँ ए, जे कोई मेरे जरिए पीतरे जाओगा, तो उद्धार पाओगा, और पीतरे-बारे आया-जाया करना और तेसखे चारा मिलणा। ");
INSERT INTO bfz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोर कोई ओर काम करने नि, पर बस चोरी करने, काणे और सत्यानाश करने आओआ, आऊँ तेबे आया कि सेयो जीवन पाओ और बऊत जादा पाओ। ");
INSERT INTO bfz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","अच्छा चराणे वाल़ा आऊँ ए, अच्छा चराणे वाल़ा आपणी पेडा खे आपणा प्राण तक देई देओआ। ");
INSERT INTO bfz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","मजदूर, जो ना तो चराणे वाल़ा ए और ना पेडा रा मालक ए, जेबे भेड़िया आओआ, तो पेडा खे छाडी की नठी जाओआ और भेड़िया तिना पेडा पाँदे अमला करोआ और पेडा खे ओरे-पोरे करी देओआ। ");
INSERT INTO bfz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","से तेबे नठी जाओआ, कऊँकि से एक मजदूर ए और तेसखे पेडा री चिन्ता निए। ");
INSERT INTO bfz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“अच्छा चराणे आऊँ ए, आऊँ आपणी पेडा खे जाणूंआ और मेरी पेडा माखे जाणोईया। ");
INSERT INTO bfz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","जिंयाँ पिता माखे जाणोआ और आऊँ तेसखे जाणूंआ और आऊँ पेडा खे आपणे प्राण देऊँआ। ");
INSERT INTO bfz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","मेरिया ओर बी पेडा ए, जो एथो री गवाईणी रिया निया, माखे सेयो बी ल्याऊणिया जरूरी ए, तिना मेरा ग्लाणा सुणना, तेबे एक ई चूण्ड और एक ई चराणे वाल़ा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","पिता तेबे मांते प्यार राखोआ, कऊँकि आऊँ आपणे प्राण देई देऊँआ, ताकि तेस फेर लयी लूँ। ");
INSERT INTO bfz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कोई बी मांते मेरा प्राण लई नि सकदा, बल्कि आऊँ तेसखे आपू ई देई देऊँआ। माखे देणे रा अक्क ए और तिजी खे फेर लणे रा अक्क बी ए, ये आज्ञा मेरे पिते ते माखे मिली री।” ");
INSERT INTO bfz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","इना गल्ला री बजअ ते यहूदिया बीचे फेर फूट पड़ी गी। ");
INSERT INTO bfz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","तिना बीचा ते बऊत जणे बोलणे लगे, “एसरे दुष्टात्मा ए और ये पागल ए, एसरी कऊँ सुणोए?” ");
INSERT INTO bfz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ओरी बोलेया, “इना गल्ला एड़ा मांणू नि बोली सकदा, जेसरे दुष्टात्मा ओ, क्या दुष्टात्मा अन्दे रिया आखी खोली सकोई?” ");
INSERT INTO bfz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरूशलेमो रे समर्पणो रा त्योआर था और ठण्डी रा बखत था। ");
INSERT INTO bfz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीशु मन्दरो रे आँगणो रे सुलेमानो रे बरंडे( बरामदा) रे कूमणे-फिरने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तेबे यहूदिये सेयो केरी ते और तिना ते पूछेया, “तां आसा रा मन कदुओ तक दुबिदा रे राखणा? जे तूँ मसीह ए, तो आसा गे साफ-साफ बोली दे।” ");
INSERT INTO bfz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीशुए तिना खे बोलेया, “मैं तो तुसा खे बोलेया पर तुसे मेरा विश्वास नि कित्तेया, जो काम आऊँ पिते रे नाओं ते करूँआ, सेयो ई मेरे गवा ए। ");
INSERT INTO bfz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पर तुसे मेरा विश्वास तेबे नि करदे, कऊँकि तुसे मेरी पेडा बीचा ते निए। ");
INSERT INTO bfz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मेरी पेडा मेरा ग्लाणा पछयाणोईया और आऊँ तिना खे जाणूंआ, और सेयो मां पीछे-पीछे चलोईया। ");
INSERT INTO bfz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","आऊँ तिना खे अनन्त जीवन देऊँआ और सेयो कदी नाश नि ऊणिया, और तिना खे कोई मांते छुड़ाई की लई नि सकदा। ");
INSERT INTO bfz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मेरे पिता, जिने माखे सेयो देई राखिया, सबी ते बड़ा ए और कोई तिना खे पिते रे आथो ते छुड़ाई की लई नि सकदा। ");
INSERT INTO bfz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","आऊँ और पिता एक ए।” ");
INSERT INTO bfz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदिये फेर तिना खे पत्थराव करने खे पात्थर चके। ");
INSERT INTO bfz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","तेबे यीशुए तिना खे बोलेया, “मैं तो तुसा खे आपणे पिते री तरफा ते बऊत खरे काम दखाई राखे, तिना बीचा ते तुसे कुण जे कामो री बजअ ते मां पाँदे पत्थराव करोए?” ");
INSERT INTO bfz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदिये तिना खे जवाब दित्तेया, “खरे कामा खे आसे तां पाँदे पत्थराव नि लगी रे करने, बल्कि परमेशरो री निन्दा री बजअ ते और इजी री बजअ ते कि तूँ मांणू ऊई की आपू खे परमेशर बोलोआ।” ");
INSERT INTO bfz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीशुए तिना खे बोलेया, “क्या तुसा रे पवित्र शास्त्रो रे नि लिखी राखेया, ‘मैं बोली राखेया, तूँ ईश्वर ए’? ");
INSERT INTO bfz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","तुसे जाणोए कि पवित्र शास्त्रो री गल्ल बदली नि सकदी। जिना गे परमेशरो रा वचन पऊँछी रा, तिने तिजी खे ईश्वर बोलेया, ");
INSERT INTO bfz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","तेबे जो पिते पवित्र ठईराई की दुनिया पाँदे पेजी राखेया, तुसे तेसखे बोलोए कि तूँ निन्दा करोआ, कऊँकि मैं बोली राखेया कि आऊँ परमेशरो रा पुत्र ए। ");
INSERT INTO bfz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","जे आऊँ पिते रे काम नि करदा, तो मेरा विश्वास नि करो। ");
INSERT INTO bfz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पर जे आऊँ करूँआ, तेबे चाए मेरा विश्वास नि करो, पर तिना कामो रा विश्वास तो करो। ताकि तुसे जाणो और समजो कि पिता मांदे और आऊँ पिते रे ए।” ");
INSERT INTO bfz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तेबे तिने फेर तिना खे पकड़ने री कोशिश कित्ती, पर सेयो तिना रे आथो ते निकल़ी गे। ");
INSERT INTO bfz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","तेबे यीशु यरदनो ते पार तेसा जगा रे गये, जेती यूहन्ना पईले बपतिस्मा देया करो था और तेथी रये। ");
INSERT INTO bfz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","तेबे बऊत जणे तिना गे आयी की बोलणे लगे, “यूहन्ने तो कोई चमत्कार नि दखाए, पर जो कुछ यूहन्ने इना रे बारे रे बोलेया था, से सब सच था।” ");
INSERT INTO bfz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","और तेती बऊत जणेया यीशुए पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","मरियम और तेसा री बईण मार्था रे गांव बैतनिय्याहो रे लाजर नाओं रा एक मांणू बमार था। ");
INSERT INTO bfz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ये सेई मरियम थी, जेसे यीशुए रे पैरा पाँदे इत्र मल़ी की आपणे बाल़ो साथे टूसे थे। एसा रा ई पाई लाजर बमार था। ");
INSERT INTO bfz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","तेबे तेसा री बईणे तिना खे संदेशा पेजेया, “ओ प्रभु! देख, जेस साथे तुसे प्यार राखोए, से बमार ऊई रा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ये सुणी की यीशुए बोलेया, “ये बमारी मरने जोगी निए, बल्कि परमेशरो री महिमा खे ए, ताकि तेसरी बजअ ते परमेशरो रे पुत्रो री महिमा ओ।” ");
INSERT INTO bfz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","यीशु मार्था और तेसा री बईण और तिना रे पाई लाजरो खे प्यार करो थे। ");
INSERT INTO bfz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","तो जेबे तिने सुणेया कि से बमार ए, तेबे जेती सेयो थे, तेती दो दिन ओर रूकी गे। ");
INSERT INTO bfz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","तेबे दो दिनो ते बाद तिने आपणे चेलेया खे बोलेया, “आओ, आसे फेर यहूदिया प्रदेशो खे चलूँए।” ");
INSERT INTO bfz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेलेया तिना खे बोलेया, “ओ गुरू! एबु तो यहूदी अगुवे तुसा पाँदे पत्थराव करना चाओ थे और क्या तुसे फेर बी तेथी जाणा चाओए।” ");
INSERT INTO bfz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीशुए बोलेया, “क्या दिनो रे बारा कंटे नि ऊँदे? जे कोई दिने चलो तो कोई ठोकर नि खांदा कऊँकि से एसा दुनिया रा प्रयासा देखोआ। ");
INSERT INTO bfz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पर जे कोई राथियो खे चलोआ, तो से ठोकर खाओआ, कऊँकि तेसरे प्रयासा निए।” ");
INSERT INTO bfz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","तिने यो गल्ला बोलिया और इजी ते बाद तिना खे बोलणे लगे, “आसा रा दोस्त लाजर सयी गा रा, पर आऊँ तेसखे जगाणे चली रा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तेबे चेलेया तिना खे बोलेया, “ओ प्रभु! जे से सयी रा तो से बची जाणा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीशुए तो तेसरी मौता रे बारे रे बोलेया था, पर सेयो समजे कि तिने तेसरी नींजा ते सऊणे रे बारे रे बोलेया। ");
INSERT INTO bfz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तेबे यीशुए तिना खे साफ बोली ता, “लाजर मरी गा रा ");
INSERT INTO bfz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","और आँऊ तुसा री बजअ ते खुश ए कि आऊँ तेती नि था, ताकि तुसे विश्वास करो, पर एबे आओ आसे तेसगे चलूँए।” ");
INSERT INTO bfz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तेबे थोमे, जेसखे दिदुमुस बोलो थे, तिने आपणे साथले चेलेया खे बोलेया, “आओ, आसे बी तेस साथे मरने खे चलूँए।” ");
INSERT INTO bfz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","तेबे यीशुए खे बैतनिय्याह गांव रे आयी की पता चलेया कि लाजरो खे कब्रा रे राखे रे चार दिन ऊईगे रे। ");
INSERT INTO bfz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनिय्याह, यरूशलेमो ते नेड़े कोई तीन किलोमीटर था। ");
INSERT INTO bfz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","बऊत सारे यहूदी मरियम और मार्था रे गे तिना रे पाईए रे बुलावे खे आयी रे थे। ");
INSERT INTO bfz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जेबे मार्थे यीशुए रे आऊणे रा समाचार सुणेया, तेबे से तिना खे मिलणे गयी, पर मरियम कअरे ई बैठी री रई। ");
INSERT INTO bfz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्थे यीशुए खे बोलेया, “ओ प्रभु! जे तुसे एती ऊँदे, तो मेरा पाई कदी नि मरदा ");
INSERT INTO bfz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","और एबे बी आऊँ जाणूंई कि जो कुछ तुसा परमेशरो ते मांगणा, से तुसा खे मिलणा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीशुए तेसा खे बोलेया, “तेरा पाई जिऊँदा ऊई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्थे तिना खे बोलेया, “आऊँ जाणूंई कि आखरी दिना रे दुबारा जिऊँदा ऊणा रे बखते से फेर जी उठणा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीशुए तेसा खे बोलेया, “दुबारा जिऊँदा ऊणा और जीवन आऊँ ईए, जे कोई मां पाँदे विश्वास करोआ, से जे मरी बी जाओ, तेबे बी जिऊणा। ");
INSERT INTO bfz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","और जो कोई जिओआ और मां पाँदे विश्वास करोआ, से अनन्तकालो तक नि मरना। क्या तूँ एसा गल्ला पाँदे विश्वास करेई?” ");
INSERT INTO bfz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","तेसे तिना खे बोलेया, “आ, ओ प्रभु, आऊँ विश्वास करी चुकी री कि परमेशरो रा पुत्र मसीह, जो दुनिया रे आऊणे वाल़ा था, सेयो तुसेई ये।” ");
INSERT INTO bfz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ये बोली की से चली गी और आपणी बईण मरियमा खे चोरिए जे बुलाई की बोलेया, “गुरू एथी ई ये और ताखे बुलाणे लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ये सुणदे ई से फटाफट उठी की तिना गे आयी। ");
INSERT INTO bfz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीशु एबुए तक गांव रे नि पऊँछी रे थे, बल्कि तेथी थे, जेती मार्था तिना खे मिली थी। ");
INSERT INTO bfz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तेबे जो यहूदी तेसा साथे कअरे थे और तेसा खे शान्ति देणे लगी रे थे। ये देखी की कि मरियम फटाफट उठी की बारे चली गी री, सेयो समजे कि से कब्रा पाँदे रोणे जाई री, तेसा पीछे चली गे। ");
INSERT INTO bfz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जेबे मरियम तेती पऊँछी, जेती यीशु थे, तो तिना खे देखी की तिना रे पैरा पाँदे पड़ी की और बोलणे लगी, “ओ प्रभु! जे तुसे एती उँदे, तो मेरा पाई कदी नि मरदा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जेबे यीशुए तेसा खे और तिना यहूदिया खे, जो तेसा साथे आए थे, रोंदे ऊए देखेया, तो आत्मा रे बऊत उदास और बेचैन ऊईगा ");
INSERT INTO bfz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","और तिने बोलेया, “तुसे तेसरा शरीर केयी दबाई राखेया?” तिने तिना खे बोलेया, “ओ प्रभु! चली की देखी लो।” ");
INSERT INTO bfz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीशुए री आखी रे पाणी आईगा। ");
INSERT INTO bfz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तेबे यहूदिये बोलेया, “देखो, ये तेसखे कितणा प्यार करो था।” ");
INSERT INTO bfz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पर तिना बीचा ते बऊत जणेया बोलेया, “क्या ये, जिने अन्दे री आखी ठीक कित्तिया, ये पनि करी सकेया कि तेसखे मरने ते बचाई देओ?” ");
INSERT INTO bfz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीशु मनो रे उदास ऊई की कब्रा पाँदे आए, से एक गुफा थी और एक पात्थर तेते पाँदे राखी राखेया था। ");
INSERT INTO bfz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीशुए बोलेया, “पात्थरो खे टाओ।” तेस मरे री बईण मार्था तिना खे बोलणे लगी, “ओ प्रभु! तेसते तो एबे बास आओए, कऊँकि तेसखे मरे रे चार दिन ऊईगे रे।” ");
INSERT INTO bfz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीशुए तेसा खे बोलेया, “क्या मैं ताखे नि बोली राखेया था कि जे तूँ विश्वास करेगी, तो परमेशरो री महिमा खे देखेगी।” ");
INSERT INTO bfz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तेबे तिने से पात्थर टाया, तेबे यीशुए आखी चकी की बोलेया, “ओ पिता आऊँ तेरा धन्यवाद करूँआ कि तैं मेरी प्रार्थना सुणी ली री ");
INSERT INTO bfz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","और आऊँ जाणूं था कि तूँ मेरी सदा सुणेया, पर जो पीड़ नेड़े-तेड़े खड़ी री, तिना री बजअ ते मैं बोलेया, ताकि सेयो विश्वास करो कि तैं आऊँ पेजी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ये बोली की तिने जोरे की बोलेया, “ओ लाजर, कब्रा ते बारे निकल़ी की आईजा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जो मरी गा था, से कफनो ते आथ पैर बानेया रा निकल़ी गा और तेसरा मूँ टाल्ले की लपेटे रा था, यीशुए बोलेया, “एसखे खोली की जाणे देओ।” ");
INSERT INTO bfz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","तेबे जो यहूदी मरियमा गे आयी रे थे और जेबे तिना रा ये काम देखेया, तेबे तिना बीचा ते कई जणेया तिना पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पर तिना बीचा ते कई जणे फरीसिया गे जाई की यीशुए रे कामो रा समाचार दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","तेबे बड़े पुरोईत और फरीसिये बऊत बड़ी सभा रे लोका खे कट्ठे करी की बोलेया, “आसे क्या करूँए? ये मांणू तो बऊत चमत्कार दखाओआ। ");
INSERT INTO bfz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","जे आसे तेसखे ईंयां ई छाडी देऊँगे तो, सबी तेस पाँदे विश्वास करने लगी जाणा और रोमिया एती आयी की आसा री जगा और जाति दूँईं पाँदे अक्क करी लणा।” ");
INSERT INTO bfz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","सभा रे सदस्या बीचा ते कैफा नाओं रे एक मांणूए, जो तेस बखतो रा प्रदान पुरोईत था, तिना खे बोलेया, “तुसे कुछ नि जाणदे ");
INSERT INTO bfz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","और ना ई ये सोचदे कि तुसा खे ये खरा ए कि आसा रे लोका री खातर एक मांणू मरो और सारी जातिया नाश नि ओ।” ");
INSERT INTO bfz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ये गल्ल तिने आपणी तरफा ते नि बोली, बल्कि तेस बखतो रा प्रदान पुरोईत ऊणे री बजअ ते भविष्यबाणी कित्ती कि यीशु इस्राएलो रे लोका रिया तंईं मरना ");
INSERT INTO bfz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","और ना बस तेसा जातिया खे, बल्कि इजी खे बी कि परमेशरो री बिखरी री ल्वादा खे एक करी देओ। ");
INSERT INTO bfz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","तेबे तेसी दिनो ते यहूदी अगुवे यीशुए खे मारने री तरकीब टोल़ने लगे। ");
INSERT INTO bfz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","तेबेई तो यीशु तेस बखतो ते यहूदिया प्रदेशो रे खुल्लेआम नि कूमी सके, पर तेथा ते सुणसाण जगा रे नेड़ो रे एप्रैम नाओं रे देशो रे, एक नगरो खे चली गे और आपणे चेलेया साथे तेथी रणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","तेबे यहूदिया रा फसह रा त्योआर नेड़े था और बऊत सारे लोक फसह ते पईले ई गांव ते यरूशलेमो खे गये कि आपणे आपू खे शुद्ध करिए। ");
INSERT INTO bfz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","तेबे सेयो यीशुए खे टोल़ने लगे और मन्दरो रे खड़े ऊई की आपू बीचे बोलणे लगे, “तुसे क्या सोचोए? क्या से त्योआरो रे नि आऊणा?” ");
INSERT INTO bfz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","बड़े पुरोईत और फरीसिये ये आज्ञा देई राखी थी कि जे केसी खे ये पता ओ कि यीशु केईये, तो बताओ ताकि तेसखे पकड़ी सकूँ। ");
INSERT INTO bfz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","तेबे यीशु फसह रे त्योआरो ते छे दिन पईले बैतनिय्याह गांव रे आए, जेती लाजर था; जो यीशुए मरे रेया बीचा ते जिऊँदा कित्तेया था। ");
INSERT INTO bfz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","तेती तिने तिना खे पाट्टी त्यार कित्ती और मार्था सेवा करने लगी री थी और लाजर तिना बीचा ते एक था, जो यीशुए साथे पाट्टी खाणे बैठे। ");
INSERT INTO bfz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तेबे मरियमे जटामासिया रा आदा सेर बऊत मंईगा इत्र लयी की यीशुए रे पैरा पाँदे मल़ेया और आपणे बाल़ो की तिना रे पैर टूसे और इत्रो री खूशबुओ साथे सारा कर खुशबूदार ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पर तिना रे चेलेया बीचा ते यहूदा इस्करियोती नाओं रा एक चेला, जो तिना खे पकड़वाणे वाल़ा था, बोलणे लगेया, ");
INSERT INTO bfz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ये इत्र तीन सौ चाँदिए रे सिक्केया रे बेची की कंगाल़ा खे कऊँ नि बांडी ता।” ");
INSERT INTO bfz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","तिने ये गल्ल इजी री खातर नि बोली कि तेसखे कंगाल़ा री चिन्ता थी, पर तेबे कऊँकि से चोर था और तेसगे तिना री पैसेया री थैली रओ थी और तिदे जो कुछ पाओ थे, से निकयाल़ी देओ था। ");
INSERT INTO bfz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीशुए बोलेया, “एसा खे कल्ली छाडी देओ। एसे मेरे दबाणे री त्यारिया खे एड़ा करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","कऊँकि कंगाल़ तो तुसा साथे सदा रओए, पर आऊँ तुसा साथे सदा नि रणा।” ");
INSERT INTO bfz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जेबे यहूदिया री बड़ी पीड़ जाणी गी कि से एथी ए, तो सेयो सिर्फ यीशुए री ई बजअ ते नि, बल्कि लाजरो खे मिलणे खे बी आए थे, जो तिने मरे रेया बीचा ते जिऊँदा कित्तेया था। ");
INSERT INTO bfz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तेबे बड़े पुरोईत लाजरो खे बी काणे री तरकीब बणाई। ");
INSERT INTO bfz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","कऊँकि लाजरो री बजअ ते बऊत सारे यहूदिये तिना खे छाडी की यीशुए पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दूजे दिने बऊत सारे लोके त्योआरो खे आये, जेबे लोके सुणेया यीशु यरूशलेमो खे आऊणे लगी रे। ");
INSERT INTO bfz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","तेबे तिने खजूरो रिया डाल़िया लईया और तिना खे मिलणे खे चली पड़े और जोरे-जोरे साथे बोलणे लगे, “होशन्ना! धन्य इस्राएलो रा राजा, जो प्रभुए रे नाओं ते आयी रा।” ");
INSERT INTO bfz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जेबे यीशुए खे गह्दे रा एक बच्चा मिलेया, तो सेयो तेस पाँदे बैठीगे और से यरूशलेम नगरो खे आये। ये तिंयाँ ई ऊआ जेड़ा पवित्र शास्त्रो रे लिखी राखेया, ");
INSERT INTO bfz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ओ यरूशलेमो रे लोको! डरो नि, देख, तेरा राजा गह्दे रे बच्चे पाँदे बैठी की आऊणे लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","यीशुए रे चेले यो गल्ला पईले नि समजे थे, पर जेबे यीशुए री महिमा सामणे आयी, तेबे तिना खे याद आया कि यो गल्ला तिना रे बारे रे लिखी राखी थिया; और लोके तिना साथे एड़ा बर्ताव कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तेबे पीड़ा रे तिने लोके, जो तेस बखते तिना साथे थे, ये गवाई दित्ती कि तिने लाजर कब्रा ते बुलाई की मरे रेया बीचा ते जिऊँदा कित्तेया था। ");
INSERT INTO bfz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","एतेरी बजअ ते लोक तिना खे मिलणे आए थे, कऊँकि तिने सुणेया था कि तिने ये सामर्था रा काम दखाया। ");
INSERT INTO bfz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तेबे फरीसिये आपू बीचे बोलेया, “सोचो, तुसा ते तो कुछ पनि ऊणे लगी रा, देखो, दुनिया रे सारे लोक एस पीछे ई चली पड़ी रे।” ");
INSERT INTO bfz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जो लोक फसह रे त्योआरो खे भक्ति करने आए थे, तिना बीचा ते कुछ यूनानी थे। ");
INSERT INTO bfz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","तिने गलील प्रदेशो रे बैतसैदा नगरो रे रणे वाल़े फिलिप्पुसो गे आयी की बिनती कित्ती कि, “श्रीमान् जी! आसे यीशुए साथे मिलणा चाऊँए।” ");
INSERT INTO bfz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप्पुसे आयी की अन्द्रियासो खे बोलेया, तेबे तिने दूँईं यीशुए खे बोलेया। ");
INSERT INTO bfz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","तेबे यीशुए तिना खे बोलेया, “से बखत आईगा रा कि माणूं रे पुत्रो री महिमा ओ। ");
INSERT INTO bfz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","आऊँ तुसा खे सच-सच बोलूँआ कि जदुओ तक कणका रा दाँणा जमीना रे पड़ी की मरी नि जाओ, से कल्ला रओआ, पर जेबे मरी जाओआ, तेबे बऊत फल़ ल्याओआ। ");
INSERT INTO bfz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जो आपणे प्राणो खे प्यारा मानोआ, से तेसखे खोई देओआ, और जेसखे एसा दुनिया रे आपणा प्राण प्यारा निए, तेस अनन्त जीवनो तक से बचाणा। ");
INSERT INTO bfz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","जे कोई मेरी सेवा करो, तो मां पीछे आयी जाओ और जेती आऊँ ऊणा, मेरा सेवक बी तेथी रणा और जो मेरी सेवा करोआ, मेरा पिता तेसरा आदर करोआ। ");
INSERT INTO bfz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“एबे मेरा जिऊ बेचैन ऊणे लगी रा। तो एबे आऊँ क्या बोलूँ? ‘ओ पिता, माखे एसा कअड़िया ते बचा!’ पर आऊँ इजी बजअ ते एसा कअड़िया गे पऊँछी रा। ");
INSERT INTO bfz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ओ पिता, आपणे नाओं री महिमा कर।” तेबे स्वर्गो ते ये आवाज आई कि, “मैं एसरी महिमा करी राखी और फेर बी करनी।” ");
INSERT INTO bfz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तेबे जो लोक खड़ी की सुणने लगी रे थे तिने बोलेया, “बादल़ गरजेया” ओरी बोलेया, “कोई स्वर्गदूत तेथा ते बोलेया।” ");
INSERT INTO bfz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","तेबे यीशुए बोलेया, “ये शब्द माखे नि पर तुसा रे फाईदे खे आयी रा। ");
INSERT INTO bfz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","एबे एसा दुनिया रा न्याय ओआ। एबे एस दुनिया रा सरदार निकयाल़ी देणा ");
INSERT INTO bfz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","और आऊँ जे तरतिया पाँदा ते ऊच्चे रे चढ़ाया जाऊँगा, तो सबी खे आपू गे खींजूँगा।” ");
INSERT INTO bfz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ये बोली की तिने ये सामणे ल्याई ता कि से केड़ी मौता साथे मरना। ");
INSERT INTO bfz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","तेबे लोके तिना खे बोलेया, “आसे पवित्र शास्त्रो री ये गल्ल सुणी राखी कि मसीह सदा जिऊँदा रणा, तेबे तुसे कऊँ बोलोए कि माणूं रे पुत्रो खे ऊच्चे रे चढ़ाणा जरूरी ए? ये माणूं रा पुत्र कूणे?” ");
INSERT INTO bfz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","यीशुए तिना खे बोलेया, “जोति एबे थोड़ी जी देरा खे तुसा बीचे ए। जदुओ तक जोति तुसा साथे ए, तदुओ तक चलदे रओ। एड़ा नि ओ कि न्हेरा तुसा खे आयी की केरी देओ, जो न्हेरे रे चलोआ, से नि जाणदा कि केयी जाणे लगी रा। ");
INSERT INTO bfz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जदुओ तक जोति तुसा साथे ए, जोतिया पाँदे विश्वास करो, ताकि तुसे जोतिया री ल्वाद बणो।” इना गल्ला बोली की यीशु चली गे और तिना ते लूके रे रये। ");
INSERT INTO bfz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","तिने तिना सामणे इतणे चमत्कार दिखाए, पर तेबे बी तिने तिना पाँदे विश्वास नि कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ताकि यशायाह भविष्यबक्ते रा वचन पूरा ओ, जो तिने बोलेया था, “ओ प्रभु! किने आसा रे सुसमाचारो पाँदे विश्वास करी राखेया? और परमेशरो रा बाहुबल केसगे प्रगट ऊई रा?” ");
INSERT INTO bfz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","एतेरी बजअ ते सेयो विश्वास नि करी सके, कऊँकि यशायाहे फेर बी बोलेया, ");
INSERT INTO bfz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“तिने तिना री आखी अंदिया और मन काठा करी राखेया, केथी एड़ा नि ओ कि सेयो आखी ते देखो और मनो ते समजो और फिरो और आऊँ तिना खे ठीक करुँ।” ");
INSERT INTO bfz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशायाहे यो गल्ला तेबे बोलिया, कऊँकि तिने यीशुए री आऊणे वाल़ी महिमा देखी और तिने तेसरे बारे रे गल्ला कित्तिया। ");
INSERT INTO bfz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","तेबे बी अधिकारिया बीचा ते कई जणे तिना पाँदे विश्वास कित्तेया। पर फरीसिये री डरो री बजअ ते सामणे नि आऊणा चाओ थे, एड़ा नि ओ कि प्रार्थना रे कअरो ते निकयाल़े जाओ। ");
INSERT INTO bfz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","कऊँकि मांणूआ ते तारीफ, तिना खे परमेशरो री तारीफा ते जादा प्यारी लगो थी। ");
INSERT INTO bfz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","यीशुए जोरे की बोलेया, “जो मां पाँदे विश्वास करोआ, से मां पाँदे नि, बल्कि मेरे पेजणे वाल़े परमेशरो पाँदे विश्वास करोआ। ");
INSERT INTO bfz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","और जो माखे देखोआ, से मेरे पेजणे वाल़े खे देखोआ। ");
INSERT INTO bfz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","आऊँ दुनिया रे जोति ऊई की आयी रा, ताकि जो कोई मां पाँदे विश्वास करो, से न्हेरे रे नि रओ। ");
INSERT INTO bfz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","जो कोई मेरिया गल्ला सुणी की नि मानो, आऊँ तेसखे दोषी नि ठईरांदा, कऊँकि आऊँ दुनिया रे लोका खे दोषी ठईराणे खे नि, बल्कि दुनिया रे लोका खे बचाणे आयी रा। ");
INSERT INTO bfz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जो माखे तुच्छ जाणोआ और मेरी गल्ला नि मानदा, तेसखे दोषी ठईराणे वाल़ा एक ईए, मतलब-जो वचन मैं बोली राखेया, तेस ई आखरी दिनो रे से दोषी ठईराणा। ");
INSERT INTO bfz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","कऊँकि मैं आपणी तरफा ते गल्ला नि करी राखिया, पर पिते, जिने आऊँ पेजी राखेया, तिने ई माखे आज्ञा देई राखी कि क्या-क्या बोलूँ? और किंयाँ बोलूँ? ");
INSERT INTO bfz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","और आऊँ जाणूंआ कि तेसरी आज्ञा अनन्त जीवन ए, तेबेई तो जो आऊँ बोलूँआ, जेड़ा पिते मांगे बोली राखेया, तेड़ा ई बोलूँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह रे त्योआरो ते पईले जेबे यीशुए जाणी ला कि मेरी से कअड़ी आईगी री कि दुनिया खे छाडी की पिते गे जाऊँ। तेबे आपणे लोका खे जो दुनिया रे थे, जेड़ा प्यार राखो था, अंतो तक तेड़ा ई प्यार राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","रात की रोटिया रे बखते जेबे शैतान, यहूदा इस्करियोतियो रे मनो रे ये गल्ल पाई चुकेया था कि यीशुए खे पकड़वाओ, ");
INSERT INTO bfz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीशुए, ये जाणी की कि पिते सारा अक्क मेरे आथो रे देईता रा और आऊँ परमेशरो गे ते आयी रा और परमेशरो गे ई जाणा, ");
INSERT INTO bfz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","रोटिया गे ते उठी की आपणे टाल्ले खोली ते और पड़तणी लयी की आपणा लक बानेया। ");
INSERT INTO bfz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तेबे पांडे रे पाणी लयी की आपणे चेलेया रे पैर तोये और जो पड़तणी आपणे लको रे थी बानी री, तिजी साथे साफ करने लगे। ");
INSERT INTO bfz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जेबे सेयो शमौन पतरसो गे आए, तेबे तिने तिना खे बोलेया, “ओ प्रभु! क्या तुसे मेरे पैर तोणे लगी रे?” ");
INSERT INTO bfz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीशुए बोलेया, “जो आऊँ करूँआ, से तूँ एबु नि जाणदा, पर इजी ते बाद समजणा।” ");
INSERT INTO bfz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरसे तिना खे बोलेया, “तुसे मेरे पैर कदी नि तोई सकदे!” ये सुणी की यीशुए तेसखे बोलेया, “जे तूँ माखे आपणे पैर नि तोणे देगा, तो मां साथे तेरा कुछ बी साजा निया।” ");
INSERT INTO bfz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","शमौन पतरसे तिना खे बोलेया, “ओ प्रभु! तेबे मेरे पैर नि बल्कि मेरे आथ और सिर बी तोई दे।” ");
INSERT INTO bfz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीशुए तेसखे बोलेया, “जो नायी चुकेया रा, तेसरे पैर तोणे ते अलावा कुछ ओर तोणे ते मतलब निए, बल्कि से बिल्कुल शुद्ध ए और तूँ बी शुद्ध ए, पर सब के सब निए।” ");
INSERT INTO bfz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","सेयो आपणे पकड़वाणे वाल़े खे जाणो थे, तेबेई तो तिने बोलेया, “तुसे सब के सब शुद्ध निए।” ");
INSERT INTO bfz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जेबे यीशु तिना रे पैर तोई चुके और फेर आपणे टाले पईनी की बैठीगे, तेबे तिने चेलेया खे पूछेया, “क्या तुसे समजे कि मैं तुसा साथे क्या कित्तेया? ");
INSERT INTO bfz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुसे माखे गुरू और प्रभु बोलोए और ठीक ई बोलोए, कऊँकि आऊँ तुसा रा गुरू और प्रभु ए। ");
INSERT INTO bfz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","जे मैं प्रभु और गुरू ऊई की तुसा रे पैर तोये, तो तुसा बी नम्र ऊई की एकी दूजे रे पैर तोणे चाईयो। ");
INSERT INTO bfz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","कऊँकि मैं तुसा गे नमूना दखाई ता कि जिंयाँ मैं तुसा साथे करी राखेया, तुसे बी तिंयाँ ई करेया करो। ");
INSERT INTO bfz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“आऊँ तुसा खे सच-सच बोलूँआ, दास आपणे मालको ते बड़ा नि ऊँदा, और ना पेजेया रा आपणे पेजणे वाल़े ते। ");
INSERT INTO bfz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तुसे तो इना गल्ला खे जाणोए और जे इना पाँदे चलो, तो धन्य ए। ");
INSERT INTO bfz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","आऊँ तुसा सबी रे बारे रे नि बोलदा, जो मैं चूणी लये रे, तिना खे आऊँ जाणूंआ, पर ये इजी खे ए, ताकि पवित्र शास्त्रो रा ये वचन पूरा ओ कि, जिने मेरा दोस्त ऊई की मां साथे रोटी खाई सेई मेरे खलाफ ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","एबे आऊँ तिजी रे ऊणे ते पईले तुसा खे जताई देऊँआ कि जेबे ये ऊई जाओ, तो तुसे विश्वास करो कि आऊँ सेईए। ");
INSERT INTO bfz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","आऊँ तुसा खे सच-सच बोलूँआ कि जो मेरे पेजे रे खे मानोआ, से माखे मानोआ और जो माखे मानोआ, से मेरे पेजणे वाल़े खे मानोआ।” ");
INSERT INTO bfz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ये बोली की यीशु आत्मा रे बेचैन ऊईगे और तिने आपणे चेलेया ते बोलेया, “आऊँ तुसा खे सच-सच बोलूँआ कि तुसा बीचा ते एकी जणे आऊँ पकड़वाणा।” ");
INSERT INTO bfz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेले ये शक करी की कि यो केसरे बारे रे बोलणे लगी रे, एकी दूजे खे देखणे लगे। ");
INSERT INTO bfz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","तिना रे चेलेया बीचा ते एक जेस साथे यीशु प्यार राखो थे, यीशुए री छातिया री तरफा खे चूकी की तिना री बगला रे बैठी रा था। ");
INSERT INTO bfz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","तेबे शमौन पतरसे तेसरी तरफा खे साअरा करी की बोलेया, “बता तो, यो केसरे बारे रे बोलणे लगी रे?” ");
INSERT INTO bfz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तेबे तिने तिंयाँ ई यीशुए री छातिया री तरफा खे चूकी की पूछेया, “ओ प्रभु! से कूणे?” ");
INSERT INTO bfz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीशुए बोलेया, “जेसखे मां ये रोटिया रा टुकड़ा डबोई की देणा, सेईए।” तेबे तिने टुकड़ा शमौनो रे पाऊ, यहूदा इस्करियोतियो खे दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","रोटिया रा टुकड़ा खांदे ई शैतान तेसरे समाई गा, तेबे यीशुए बोलेया, “जो तूँ करने लगी रा, से फटाफट कर।” ");
INSERT INTO bfz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","पर ओरी चेलेया ये नि जाणेया कि तिने ये गल्ल कऊँ बोली। ");
INSERT INTO bfz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदे गे पैसेया री थैली रओ थी, तेबे किने-किने समजेया कि यीशुए इजी रे बारे रे बोलेया कि जो कुछ आसा खे त्योआरो रे दिनो खे चाईयो, से खरीद या कंगाल़ा खे कुछ देई दे। ");
INSERT INTO bfz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","तेबे यहूदा रोटिया रा टुकड़ा खाणे ते बाद फटाफट बारे चली गा और से राथियो रा बखत था। ");
INSERT INTO bfz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जेबे से बारे चली गा, तेबे यीशुए बोलेया, “एबे मां माणूं रे पुत्रो री महिमा ऊई और परमेशरो री महिमा तेसरे ऊई री। ");
INSERT INTO bfz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","तो परमेशरे बी आपू रे पुत्रो री महिमा करनी, बल्कि फटाफट करनी। ");
INSERT INTO bfz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ओ बाल़को! आऊँ तुसा साथे थोड़ी देर ओर ए, तेबे तुसा आऊँ टोल़ना और जेड़ा मैं यहूदी अगुवा खे बोलेया, ‘जेती आऊँ जाऊँआ, तेती तुसे नि आयी सकदे,’ तेड़ा ई एबे आऊँ तुसा खे बी बोलूँआ। ");
INSERT INTO bfz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","आऊँ तुसा खे एक नयी आज्ञा देऊँआ कि एकी-दूजे साथे प्यार राखो, जेड़ा मैं तुसा साथे प्यार राखी राखेया। तेड़ा ई तुसे बी एकी-दूजे साथे प्यार राखो। ");
INSERT INTO bfz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","जे तुसे आपू बीचे प्यार राखोगे तो इजी तेई सबी जाणी लणा कि तुसे मेरे चेले ए।” ");
INSERT INTO bfz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","शमौन पतरसे तिना खे बोलेया, “ओ प्रभु! तुसे केयी चली रे?” यीशुए बोलेया, “जेती आऊँ एबु चली रा, तेती तूँ एबु मां पीछे नि आयी सकदा, पर इजी ते बाद मां पीछे आऊणा।” ");
INSERT INTO bfz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरसे तिना खे बोलेया, “ओ प्रभु! एबु आऊँ तुसा पीछे कऊँ नि आयी सकदा? आँऊ तो तुसा खे आपणे प्राण देणे खे बी त्यार ए।” ");
INSERT INTO bfz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीशुए बोलेया, “क्या तां माखे आपणे प्राण देणे? आऊँ ताखे सच-सच बोलूँआ कि मुर्गे बांग नि देणी, जदुओ तक तां मेरा तीन बार ना नि करना।” ");
INSERT INTO bfz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","यीशुए आपणे चेलेया खे बोलेया, “तुसा रा मन बेचैन नि ओ, तुसे परमेशरो पाँदे विश्वास राखोए, मां पाँदे बी राखो। ");
INSERT INTO bfz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मेरे पिते रे कअरो रे बऊत जगा ए रणे खे, जे ऊँदी नि तो मां तुसा खे बोली देणा था, कऊँकि आऊँ तुसा खे जगा त्यार करने जाऊँआ ");
INSERT INTO bfz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","और तेती जाई की तुसा खे जगा त्यार करने ते बाद मां तुसे आयी की आपू साथे लयी जाणे खे फेर आऊणा, ताकि जेती आऊँ रऊँ, तुसे बी मां साथे तेथी रओ। ");
INSERT INTO bfz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","और जेती आऊँ जाऊँआ, तुसे तेथो री बाट जाणोए।” ");
INSERT INTO bfz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमे तिना खे बोलेया, “ओ प्रभु! आसे नि जाणदे कि तुसे केयी जाओए? तो बाट किंयाँ जाणी सकूँए?” ");
INSERT INTO bfz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीशुए तेसखे बोलेया, “बाट, सच्चाई और जीवन आऊँ ईए; मांते बिना कोई बी पिते गे नि पऊँछी सकदा। ");
INSERT INTO bfz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","जे तुसे आऊँ जाणी राखेया, तो मेरा पिता बी जाणी राखेया और एबे तेसखे जाणो बी ए और से देखी बी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुसे तिना खे बोलेया, “ओ प्रभु! पिते खे आसा गे बताई देओ, येई आसा खे बऊत ए।” ");
INSERT INTO bfz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीशुए तेसखे बोलेया, “ओ फिलिप्पुस! आऊँ इतणे दिना ते तुसा साथे ए और क्या तूँ माखे नि जाणदा? जिने आऊँ देखी राखेया, तिने पिता देखी राखेया, तेबे तूँ कऊँ बोलेया कि पिते खे आसा गे दखाई देओ? ");
INSERT INTO bfz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","क्या तूँ विश्वास नि करदा कि आऊँ पिते रे ए और पिता मांदे ए? यो गल्ला जो आऊँ तुसा खे बोलूँआ, आपणी तरफा ते नि बोलदा, पर पिता मांदे रई की आपणे काम करोआ। ");
INSERT INTO bfz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मेरा विश्वास करो कि आऊँ पिते रे ए और पिता मांदे ए, नई तो तिना चमत्कारा री बजअ ते जो मैं करी राखे मेरा विश्वास करो। ");
INSERT INTO bfz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","आऊँ तुसा खे सच-सच बोलूँआ कि जो मां पाँदे विश्वास राखोआ, यो काम, जो आऊँ करूँआ, तेस बी करने, बल्कि इना ते बी बड़े काम करने, कऊँकि आऊँ पिते गे चली रा। ");
INSERT INTO bfz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","और जो कुछ तुसे मेरे नाओं ते मांगोगे, सेई मां करना ताकि पाऊए री बजअ ते पिते री महिमा ओ। ");
INSERT INTO bfz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","जे तुसे मांते, मेरे नाओं ते कुछ बी मांगोगे, तो मां से करना। ");
INSERT INTO bfz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“जे तुसे मांते प्यार राखोए, तो मेरी आज्ञा खे मानोगे। ");
INSERT INTO bfz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","आऊँ पिते ते प्रार्थना करूँगा और तेस तुसा खे एक ओर मददगार पेजणा, ताकि से तुसा साथे सदा रओ। ");
INSERT INTO bfz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","से पवित्र आत्मा ए जो परमेशरो रे बारे रे पूरी सच्चाई बताओआ। जेसखे दुनिया मानी नि सकदी, कऊँकि से ना तेसखे देखोआ और ना तेसखे जाणोआ, तुसे तेसखे जाणोए, कऊँकि से तुसा साथे रओआ और से तुसा रे ऊणा। ");
INSERT INTO bfz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“मां तुसे अनाथ नि छाडणे, आऊँ तुसा गे वापस आऊँआ। ");
INSERT INTO bfz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","और थोड़ी जी देर रईगी री कि दुनिया आऊँ नि देखणा, पर तुसा आऊँ देखणा, कऊँकि आऊँ जिऊँदा ए, तुसे बी जिऊँदे रणे। ");
INSERT INTO bfz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","जेबे आँऊ जिऊँदा ऊई की वापस आऊणा, तेस दिने तुसा जाणना कि आऊँ आपणे पिते रे ए और तुसे मांदे ए और आऊँ तुसा रे ए। ");
INSERT INTO bfz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जेसगे मेरी आज्ञा ओ और से तिना खे मानोआ, सेई मां साथे प्यार राखोआ, तेसते मेरे पिते प्यार राखणा और मां बी तेसते प्यार राखणा और आपणे आपू खे तेसदे प्रगट करूँगा।” ");
INSERT INTO bfz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","तिने यहूदे, जो इस्करियोती नि था, तिने बोलेया, “ओ प्रभु! क्या ऊआ कि तुसे आपू खे आसा पाँदे प्रगट करना चाओए और दुनिया रे लोका पाँदे नि?” ");
INSERT INTO bfz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीशुए तेसखे बोलेया, “जे कोई मांते प्यार राखोआ, तो तेस मेरे उपदेश मानणे और मेरे पिते तेसते प्यार राखणा और आसे तेसगे आऊणे और तेस साथे रणे। ");
INSERT INTO bfz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","“जो मांते प्यार नि करदा, से मेरे उपदेश नि मानदा और जो उपदेश तुसे सुणोए, से मेरा नि बल्कि पिते राए, जिने आऊँ पेजेया। ");
INSERT INTO bfz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","यो गल्ला मैं तुसा साथे रंदे ऊए तुसा खे बोलिया। ");
INSERT INTO bfz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पर मददगार, मतलब-पवित्र आत्मा, जो पिते मेरे नाओं ते पेजणा, तेस तुसा खे सारिया गल्ला सिखयाणियां और जो कुछ मैं तुसा खे बोली राखेया, तेस तुसा खे सब कुछ याद दलयाणा। ");
INSERT INTO bfz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“आऊँ तुसा खे शान्ति देऊँआ, आपणी शान्ति तुसा खे देऊँआ, जिंयाँ दुनिया देओई, आऊँ तुसा खे नि देंदा, तुसा रा मन नि कबराओ और ना डरो। ");
INSERT INTO bfz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","तुसे सुणेया कि मैं तुसा खे बोलेया, आऊँ जाऊँआ और तुसा गे फेर आऊँआ, जे तुसे मांते प्यार राखदे, तो एसा गल्ला ते खुश ऊँदे कि आऊँ पिते गे चली रा, कऊँकि पिता मांते बड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","मैं एबे तिना सारी घटना ऊणे ते पईले तुसा खे बोली ताकि जेबे से ऊई जाओ, तो तुसे मां पाँदे विश्वास करो। ");
INSERT INTO bfz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","मांगे एबे तुसा साथे गल्ला करने खे ओर जादा बखत निए, कऊँकि एसा दुनिया रा सरदार आऊणे वाल़ा ए। मां पाँदे तेसरा कोई अक्क निए। ");
INSERT INTO bfz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","पर ये तेबे ऊआ, ताकि दुनिया जाणो कि आऊँ पिते ते प्यार करूँआ और जिंयाँ पिते माखे आज्ञा दित्ती, आऊँ तिंयाँ ई करूँआ। उठो, एथा ते चलूँए।” ");
INSERT INTO bfz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“सच्ची अँगूरा री बेल आऊँ ई ये और मेरा पिता जिम्मीदार ए। ");
INSERT INTO bfz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","जो डाल़ी मांदे ए और फल़दी नि, से तेसा खे बाडी देओआ और जो फल़ोई, से तेसा री कांट छांट करोआ, ताकि ओर बी जादा फल़ो। ");
INSERT INTO bfz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुसे तो तेस उपदेशो री बजअ ते, जो मैं तुसा खे बोली राखेया, शुद्ध ए। ");
INSERT INTO bfz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुसे मांदे बणे रे रओ और आऊँ तुसा रे। जिंयाँ डाल़ी जे अँगूरा री बेला रे बणी री नि रओ, तो आपणे आपू ते नि फल़ी सकदी, तिंयाँ ई तुसे बी जे मांदे बणे रे नि रओगे, तो फल़ी नि सकदे। ");
INSERT INTO bfz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","आऊँ अँगूरा री बेल ए, तुसे डाल़िया ए, जो मांदे बणेया रा रओआ और आऊँ तेसरे, तिदे बऊत फल़ लगोआ, कऊँकि मांते लग रई की तुसे कुछ पनि करी सकदे। ");
INSERT INTO bfz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","जे कोई मांदे बणेया रा नि रओ, तो से तेसा बेकार और सूकी डाल़िया जेड़ा सेटेया जाओआ और लोक तिजी खे कट्ठे करी की आगी रे सेटी देओए और सेयो फूखी जाओईया। ");
INSERT INTO bfz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","जे तुसे मांदे बणे रे रओ और मेरे उपदेश तुसा रे बणे रे रओ, तो जो चाओ, से माँगो और से तुसा खे ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मेरे पिते री महिमा इजी साथे ई ओई कि तुसे बऊत सारा फल़ ल्याओ। तेबेई तुसे मेरे चेले ऊणे। ");
INSERT INTO bfz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“जेड़ा पिते मां साथे प्यार राखेया, तेड़ा ई मैं तुसा साथे प्यार राखेया। मेरे प्यारो रे बणे रओ। ");
INSERT INTO bfz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","जे तुसे मेरी आज्ञा खे मानोगे, तो मेरे प्यारो रे बणे रे रणे, जिंयाँ मैं आपणे पिते री आज्ञा मानी राखिया और तेसरे प्यारो रे बणेया रा रऊँआ। ");
INSERT INTO bfz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मैं तुसा खे यो गल्ला तेबे बोलिया ताकि मेरी खुशी तुसा रे बणी री रओ और तुसा री खुशी पूरी ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मेरी आज्ञा ये कि जेड़ा मैं तुसा साथे प्यार राखेया, तेड़ा ई प्यार तुसे बी एकी-दूजे साथे राखो। ");
INSERT INTO bfz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","इजी ते बड़ा प्यार केसी रा निए कि कोई आपणे दोस्ता खे आपणा प्राण देओ। ");
INSERT INTO bfz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जो कुछ आज्ञा आऊँ तुसा खे देऊँआ, जे तुसे मानो, तो तुसे मेरे दोस्त ए। ");
INSERT INTO bfz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","आजो ते आऊँ तुसा खे दास नि बोलूँगा, कऊँकि दास नि जाणदा कि मालक क्या करोआ, पर मैं तुसा खे दोस्त बोलेया, कऊँकि मैं जो गल्ला आपणे पिते ते सुणिया, सेयो सब तुसा खे बताई तिया। ");
INSERT INTO bfz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुसे आऊँ नि चुणेया, पर मैं तुसे चुणी राखे और तुसे ठराए, ताकि तुसे जाई की फल़ ल्याओ और तुसा रा फल़ बणेया रा रओ कि जो कुछ तुसे मेरे नाओं ते पिते ते माँगो, से तुसा खे देओ। ");
INSERT INTO bfz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","इना गल्ला री आज्ञा आऊँ तुसा खे तेबे देऊँआ, ताकि तुसे एकी-दूजे साथे प्यार राखो। ");
INSERT INTO bfz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“जे दुनिया रे लोक तुसा ते बैर राखोए, तो तुसे जाणोए कि तिने तुसा ते पईले मांते बी बैर राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","जे तुसे दुनिया रे ऊँदे, तो दुनिया रे लोक तुसा साथे आपणेया जेड़ा प्यार राखदे, कऊँकि तुसे दुनिया रे निए, बल्कि मैं तुसे चुणी ले रे, तेबेई तो दुनिया तुसा ते बैर राखोई। ");
INSERT INTO bfz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","याद राखो कि मैं तुसा खे क्या बोलेया था कि दास आपणे मालको ते बड़ा नि ऊँदा, जे तिने आऊँ सताया, तो तुसे बी सताणे, जे तिने मेरा उपदेश मानी ला, तो तुसा रा बी मानी लणा। ");
INSERT INTO bfz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","मां पाँदे विश्वास करने री बजअ ते तिना तुसा साथे बुरा बर्ताव करना, कऊँकि सेयो मेरे पेजणे वाल़े परमेशरो खे नि जाणदे। ");
INSERT INTO bfz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","जे आऊँ नि आऊँदा और तिना साथे गल्ला नि करदा, तो सेयो पापी नि ठईरदे, पर एबे तिना खे तिना रे पापो खे कोई बाह्ना निए। ");
INSERT INTO bfz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जो मांते बैर राखोआ, से मेरे पिते ते बी बैर राखोआ। ");
INSERT INTO bfz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","“जे आऊँ तिना बीचे सेयो चमत्कारा रे काम नि करदा, जो ओरी किने नि कित्ते, तो सेयो पापी नि ठईरदे, पर एबे तो तिने आऊँ तिना चमत्कारा रे काम करदे ऊए देखी ला रा और तिने मांते और मेरे पिता दूँईं ते बैर कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","और ये तेबे ऊआ, ताकि से वचन पूरा ओ, जो तिना रे पवित्र शास्त्रो रे लिखी राखेया, ‘तिने मांते बेकार बैर कित्तेया।’ ");
INSERT INTO bfz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पर जेबे से मददगार आऊणा, जो मां तुसा गे पेजणा, मतलब-सच्चो रा आत्मा, जो पिते री तरफा ते निकल़ी रा, तो तेस मेरी गवाई देणी ");
INSERT INTO bfz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","और तुसे बी गवा ए, कऊँकि तुसे शुरूओ तेई मां साथे रई रे।” ");
INSERT INTO bfz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","28 “यो गल्ला मैं तुसा खे तेबे बोलिया, ताकि तुसे केसी रे बी बईकावे रे नि आओ। ");
INSERT INTO bfz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","तिना तुसे प्रार्थना रे कअरो ते निकाल़ी देणे, बल्कि से बखत आऊणा कि जेस केसी तुसे काणे, तेस समजणा कि आसे परमेशरो री सेवा करने लगी रे। ");
INSERT INTO bfz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","तिना एड़ा तेबे करना, कऊँकि तिने ना पिता जाणेया और ना माखे जाणोए। ");
INSERT INTO bfz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पर यो गल्ला मैं तुसा खे तेबे बोलिया, ताकि जेबे तिना रा बखत आओ, तेबे तुसा खे याद आयी जाओ कि मैं तुसा खे पईले ई बोली ता था और जदुओ ते तुसे मेरे‍ चेले बणे मैं तुसा खे यो गल्ला तेबे नि बोलिया, कऊँकि आऊँ तुसा साथे था। ");
INSERT INTO bfz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“एबे आऊँ आपणे पेजणे वाल़े गे चली रा और तुसा बीचा ते कोई मांते नि पुछदा, ‘तूँ केयी चली रा?’ ");
INSERT INTO bfz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पर मैं यो जो गल्ला तुसा खे बोली राखिया, तेबेई तो तुसा रा मन दु:खी ऊईगा रा। ");
INSERT INTO bfz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तेबे बी आऊँ तुसा खे सच बोलूँआ कि मेरा जाणा तुसा री तंईं अच्छा ए, कऊँकि जे आऊँ नि जाऊँगा, तो से मददगार तुसा गे नि आऊणा, पर जे आऊँ जाऊँगा, तो तेस तुसा गे पेजी देऊँगा। ");
INSERT INTO bfz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","तेस आयी की दुनिया खे पाप, परमेशरो री धार्मिकता और न्याय रे बारे रे दोषी ठराणा। ");
INSERT INTO bfz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“पापो रे बारे रे तेबे, कऊँकि सेयो मां पाँदे विश्वास नि करदे ");
INSERT INTO bfz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","और धार्मिकता रे बारे रे तेबे, कऊँकि आऊँ पिते गे जाऊँआ और तुसा आऊँ फेर नि देखणा। ");
INSERT INTO bfz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","न्याय रे बारे रे तेबे, कऊँकि दुनिया रा सरदार मतलब शैतान दोषी ठईराई ता रा। ");
INSERT INTO bfz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","माखे तुसा ते ओर बी गल्ला बोलणिया ए, पर एबु तुसे तिना खे सईन नि करी सकदे। ");
INSERT INTO bfz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पर जेबे से, मतलब-सच्चो रा आत्मा आऊणा, तेबे तुसा खे सब सच्चो री बाट बताणी, कऊँकि तेस आपणी तरफा ते नि बोलणा, पर जो कुछ तेस परमेशरो ते सुणना, सेई बोलणा और आऊणे वाल़ी गल्ला तुसा गे बताणिया। ");
INSERT INTO bfz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","तेस मेरी महिमा करनी, कऊँकि तेस मेरिया गल्ला बीचा ते लयी की तुसा खे बताणिया। ");
INSERT INTO bfz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जो कुछ पिते राए, से सब मेरा ए, तेबेई तो मैं बोलेया कि तेस मेरी गल्ला बीचा ते लयी कि तुसा खे बताणिया। ");
INSERT INTO bfz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“थोड़ी देरा तक तुसा आऊँ नि देखणा और तेबे थोड़ी देरा बाद आऊँ देखणा।” ");
INSERT INTO bfz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","तेबे तिना रे बऊत चेलेया आपू बीचे बोलेया, “ये क्या ए, जो ये आसा खे बोलणे लगी रे, ‘थोड़ी देर तुसा आऊँ नि देखणा और तेबे थोड़ी देर बाद आऊँ देखणा?’ और ये इजी खे कऊँकि आऊँ पिते गे जाऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","तेबे तिने बोलेया, “ये थोड़ी देर, जो ये बोलणे लगी रे, क्या गल्ल ए? आसे नि जाणदे कि क्या लगी रे बोलणे?” ");
INSERT INTO bfz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीशुए ये जाणी की कि यो मांते इजी रा मतलब पूछणा चाओए, तिना खे बोलेया, “क्या तुसे आपू बीचे मेरी इना गल्ला रे बारे रे पूछ-ताछ करोए कि थोड़ी देर बाद तुसा आऊँ नि देखणा और थोड़ी देर बाद आऊँ देखणा? ");
INSERT INTO bfz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","आऊँ तुसा खे सच-सच बोलूँआ कि मेरे मरने ते बाद तुसे रोणे और दु:ख करना, पर दुनिया रे लोका खुश ऊणा, तुसा खे दु:ख ऊणा, पर जेबे आँऊ जिऊँदा ऊई की वापस आऊणा तो तुसा रा दु:ख, खुशिया रे बदली जाणा। ");
INSERT INTO bfz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","जेबे जवाणस बच्चा पैदा करने लगोई, तो तेसा खे पीड़ ओई, कऊँकि तेसा रे दु:खो री कअड़ी आयी पऊँछोई, पर जेबे से बाल़क जम्मी चुकोई, तो तेबे एसा खुशिया साथे कि दुनिया रे एक मांणू पैदा ऊआ, तेस दु:खो खे फेर याद नि करदी। ");
INSERT INTO bfz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","तिंयाँ ई तुसा खे बी एबुए तक दु:ख ए, पर आऊँ तुसा खे फेर मिलणा और तुसा रे मनो रे खुशी ऊणी और तुसा री खुशी केसी पनि छिनणी। ");
INSERT INTO bfz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","तेस दिने तुसा मांते कुछ नि पूछणा, आऊँ तुसा खे सच-सच बोलूँआ कि जे पिते ते कुछ मांगोगे, तो तेस मेरे नाओं ते तुसा खे देणा। ");
INSERT INTO bfz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","एबुए तक तुसे मेरे नाओं ते पिता ते कुछ नि मांगेया, परमेशरो ते माँगो तो तुसा खे मिलणा, ताकि तुसा री खुशी पूरी ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“मैं तुसा खे यो गल्ला उदारणा रे बोलिया, पर से बखत आऊणा जेबे मां तुसा खे फेर उदारणा रे नि बोलणा, बल्कि खुली की पिते रे बारे रे तुसा गे बताणा। ");
INSERT INTO bfz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","तेस दिने तुसा आपू मेरे नाओं ते पिते ते मांगणा, और आऊँ तुसा खे ये नि बोलदा कि आऊँ तुसा रिया तंईं पिते ते प्रार्थना करूँगा। ");
INSERT INTO bfz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","कऊँकि पिता परमेशर तो आपू बी तुसा ते प्यार राखोआ, कऊँकि तुसे मां साथे प्यार राखी राखेया और ये बी विश्वास कित्तेया कि आऊँ पिते री तरफा ते आयी रा। ");
INSERT INTO bfz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","आऊँ पिते ते निकल़ी की दुनिया रे आयी रा, फेर दुनिया खे छाडी की पिते गे जाऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","तिना रे चेलेया बोलेया, “देखो, एबे तो तुसे खुली की बोलणे लगी रे और कोई बुजाणी नि बोलदे। ");
INSERT INTO bfz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","एबे आसा खे पता लगी गा कि तुसे सब कुछ जाणोए और तुसा खे कोई मतलब निए कि कोई तुसा ते कुछ पूछो, इजी पाँदे आसे विश्वास करूँए कि तुसे परमेशरो री तरफा ते आयी रे।” ");
INSERT INTO bfz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ये सुणी की यीशुए तिना खे बोलेया, “क्या एबे तुसे विश्वास करोए ");
INSERT INTO bfz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","देखो, से कअड़ी आऊणी, बल्कि आईगी री कि तुसा ओरे-पोरे ऊई की आपणी-आपणी बाटा रिये जाणा और आऊँ कल्ला छाडी देणा, तेबे बी आऊँ कल्ला नि रणा, कऊँकि पिता मां साथे ए। ");
INSERT INTO bfz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मैं तुसा खे यो गल्ला तेबे बोलिया, ताकि तुसा खे मांदे शान्ति मिलो, दुनिया रे तुसा खे क्ल़ेश ओआ, पर इम्मत राखो, मैं एसा दुनिया रा सरदार शैतान जीती ला रा।” ");
INSERT INTO bfz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीशुए आपणे चेलेया खे यो सब गल्ला बोलणे ते बाद आपणिया आखी सर्गो री तरफा खे चकिया और बोलेया, “ओ पिता! से बखत आईगा रा, आपणे पुत्रो री महिमा कर, ताकि पुत्र बी तेरी महिमा करो। ");
INSERT INTO bfz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","कऊँकि तैं तेसखे सबी प्राणिया पाँदे अक्क दित्तेया कि जो तैं तेसखे देई राखे, तिना सबी खे से अनन्त जीवन देओ ");
INSERT INTO bfz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","और अनन्त जीवन ये कि सेयो ताखे महान् सच्चे परमेशरो खे और यीशु मसीह खे, जो तैं पेजी राखेया, जाणो। ");
INSERT INTO bfz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","जो काम तैं माखे करने खे दित्तेया था, से काम पूरा करी की मैं तरतिया पाँदे तेरी महिमा कित्ती। ");
INSERT INTO bfz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","एबे ओ पिता! तूँ आपू साथे मेरी महिमा, तेसा महिमा साथे कर, जो दुनिया री सृष्टिया ते पईले, मेरी तां साथे थी। ");
INSERT INTO bfz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“मैं तेरा नाओं तिना मांणूआ गे प्रगट कित्तेया, जो तैं माखे दुनिया बीचा ते दित्ते, सेयो तेरे थे और तैं सेयो माखे दित्ते और तिने तेरे वचन मानी ले रे। ");
INSERT INTO bfz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","एबे तिना खे पता लगी गा रा कि जो कुछ तैं माखे देई राखेया, से सब तेरी तरफा ते ए। ");
INSERT INTO bfz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","कऊँकि जो उपदेश तैं माखे दित्ते, मैं सेयो तिना गे पऊँछाए और तिने सेयो माने और सच-सच जाणी ला रा कि आऊँ तेरी तरफा ते आयी रा और विश्वास करी ला रा कि तैं ई आऊँ पेजी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","आऊँ तिना खे बिनती करूँआ, जो तैं माखे देई राखे, कऊँकि सेयो तेरे ए। दुनिया रे लोका खे आँऊ बिनती नि करदा। ");
INSERT INTO bfz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","और जो कुछ मेरा ए से सब कुछ तेरा ए, और जो तेरा ए से मेरा ए और इना ते मेरी महिमा प्रगट ऊई री। ");
INSERT INTO bfz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“आऊँ एबे दुनिया रे नि रणा, पर मेरे चेले एसा दुनिया रे रणे और आऊँ तांगे आऊणे लगी रा, ओ पवित्र पिता! आपणी तेसा सामर्था ते जो तैं माखे देई राखी, तिना री रक्षा कर ताकि सेयो आसा जेड़े, एक ओ। ");
INSERT INTO bfz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जेबे आऊँ तिना साथे था, तेबे मैं तेरे तेस नाओं ते, जो तैं माखे देई राखेया, तिना री रक्षा कित्ती, मैं तिना री चौकसी कित्ती और विनाशो रे पाऊए खे छाडी की तिना बीचा ते कोई बी नाश नि ऊआ, ताकि पवित्र शास्त्रो री गल्ल पूरी ओ। ");
INSERT INTO bfz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","पर एबे आऊँ तांगे आऊँआ और इना गल्ला खे दुनिया रे रंदे ऊए बोलूँआ कि सेयो मेरी खुशी आपू रे पूरी करो। ");
INSERT INTO bfz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मैं तेरा वचन तिना गे पऊँछाई ता रा और दुनिया रे लोके तिना ते बैर कित्तेया, कऊँकि जिंयाँ आऊँ दुनिया रा निए, तिंयाँ ई सेयो बी दुनिया रे निए। ");
INSERT INTO bfz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“आऊँ ये प्रार्थना नि करदा कि तूँ तिना खे दुनिया तेई चकी लो, पर ये कि तूँ तिना खे तेस दुष्टो ते बचाई कि राख। ");
INSERT INTO bfz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जिंयाँ आऊँ दुनिया रा निए, तिंयाँ ई सेयो बी दुनिया रे निए। ");
INSERT INTO bfz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","सच्चो रे जरिए तिना खे पवित्र कर, तेरा वचन सच्चा ए। ");
INSERT INTO bfz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जिंयाँ तैं आऊँ दुनिया रे पेजेया, तिंयाँ ई मैं बी सेयो दुनिया रे पेजे। ");
INSERT INTO bfz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","तिना रे फाईदे री खातर आऊँ आपणे आपू खे पवित्र करूँआ, ताकि सेयो बी सच्चो रे जरिए पवित्र करे जाओ। ");
INSERT INTO bfz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“आऊँ सिर्फ इना चेलेया खेई बिनती नि करदा, पर तिना खे बी, जेस इना रे वचनो रे जरिए मां पाँदे विश्वास करना। ");
INSERT INTO bfz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ताकि सेयो सब एक ओ, जिंयाँ तूँ ओ पिता मांदे ए और आऊँ तांदे ए, तिंयाँ ई सेयो बी आसा रे ओ, ताकि दुनिया रे लोक विश्वास करो कि तैं ई आऊँ पेजी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","से महिमा, जो तैं माखे देई राखी, मैं तिना खे दित्ती, ताकि सेयो तिंयाँ ई एक ओ, जिंयाँ आसे एक ए। ");
INSERT INTO bfz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","आऊँ तिना रे और तूँ मांदे, ताकि सेयो सिद्ध ऊई की एक ऊई जाओ और दुनिया जाणो कि तैं ई आऊँ पेजी राखेया और जेड़ा तैं मां साथे प्यार राखेया, तेड़ा ई तिना साथे प्यार राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ओ पिता! आऊँ चाऊँआ कि जो तैं माखे देई राखे, जेती आऊँ ए, तेती सेयो बी मां साथे ओ, ताकि सेयो मेरी तेसा महिमा खे देखो, जो तैं माखे देई राखी, कऊँकि तैं दुनिया री सृष्टिया ते पईले, मां साथे प्यार राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ओ धार्मिक पिता! दुनिए आऊँ नि जाणेया, पर मैं तूँ जाणेया और इने चेलेया बी जाणेया कि तैं ई आऊँ पेजी राखेया। ");
INSERT INTO bfz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मैं तेरा नाओं तिना गे बताया और बतांदा रऊँगा कि जो प्यार ताखे मांते था, से तिना रे रओ और आऊँ तिना रे रऊँ।” ");
INSERT INTO bfz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","यीशु इना गल्ला बोली की आपणे चेलेया साथे किद्रोनो रे नाल़े ते पार गये, तेती एक बगीचा था, जिदे सेयो और तिना रे चेले गये। ");
INSERT INTO bfz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","तेसरा पकड़वाणे वाल़ा यहूदा बी से जगा जाणो था, कऊँकि यीशु आपणे चेलेया साथे तेती जाया करो था ");
INSERT INTO bfz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तेबे यहूदा सिपाईया री एक पल़टण, बड़े पुरोईत और फरीसिया री तरफा ते मन्दरो रे पईरेदारा खे लयी की दिऊए, मशाला और अथियार लयी की तेती आया। ");
INSERT INTO bfz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तेबे यीशुए तिना सबी गल्ला खे जो तिना पाँदे आऊणे वाल़िया थिया, जाणी की निकल़े और तिना खे बोलणे लगे, “केसखे टोल़ने लगी रे?” ");
INSERT INTO bfz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","तिने तिना खे जवाब दित्तेया, “यीशु नासरिये खे।” यीशुए तिना खे बोलेया, “आऊँ ई ये” और तिना खे पकड़वाणे वाल़ा यहूदा बी तिना साथे खड़ी रा था। ");
INSERT INTO bfz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","यीशुए रे ये बोलदे ई, “आऊँ ईए,” सेयो पीछे आटी की जमीना पाँदे रूड़ी गे। ");
INSERT INTO bfz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","तेबे तिने फेर तिना ते पूछेया, “तुसे केसखे टोल़ोए?” तिने बोलेया, “यीशु नासरिये खे।” ");
INSERT INTO bfz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीशुए बोलेया, “आऊँ तो तुसा खे बोली चुकेया कि आऊँ ईए, जे माखे टोल़ने लगी रे तो इना लोका खे जाणे देओ।” ");
INSERT INTO bfz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ये तेबे ऊआ ताकि से वचन पूरा ओ, जो तिने बोलेया था, “जो तैं माखे देई राखे, तिना बीचा ते मैं एक पनि खोया।” ");
INSERT INTO bfz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","शमौन पतरसे जो तलवार तेसगे थी, खिंजी और प्रदान पुरोईतो रे दासो पाँदे चलाई की तेसरा दाँणा कान ई उड़ाईता, तेस दासो रा नाओं मलखुस था। ");
INSERT INTO bfz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तेबे यीशुए पतरसो खे बोलेया, “आपणी तलवार म्यानो रे राखी दे, जो कटोरा मेरे पिते देई राखेया, क्या आऊँ तेस नि पीऊँ?” ");
INSERT INTO bfz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तेबे सिपाईए, सूबेदारे और यहूदिया रे मन्दरो रे पईरेदारे यीशु पकड़ी की बानी ते। ");
INSERT INTO bfz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","और पईले तिना खे हन्ने गे लयी गे, कऊँकि से तेस सालो रे प्रदान पुरोईत कैफे रा सऊरा था। ");
INSERT INTO bfz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ये सेई कैफा था, जिने यहूदिया खे सला दित्ती थी कि आसा रे लोका री खातर एक मांणूए रा मरना ठीक ए। ");
INSERT INTO bfz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","शमौन पतरस और एक ओर चेला बी यीशुए पीछे-पीछे चली पड़े। ये चेला प्रदान पुरोईतो रा जाणने वाल़ा था और यीशुए साथे प्रदान पुरोईतो रे आँगणो रे गया। ");
INSERT INTO bfz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पर पतरस द्वारो गे खड़े रा रया, तेबे से दूजा चेला, जो प्रदान पुरोईतो री जाण-पछयाणा रा था, बारे निकल़ेया और द्वारपालिना खे बोली की पतरसो खे पीतरे ली आया। ");
INSERT INTO bfz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","तेसे दासिये, जो द्वारपालिनी थी, पतरसो खे बोलेया, “क्या तूँ बी एस मांणूए रे चेलेया बीचा ते ए?” तिने बोलेया, “आऊँ निए।” ");
INSERT INTO bfz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","दास और मन्दरो रा पईरेदार ठण्डी रे मारे आग बाल़ी की खड़ी की सेखणे लगी रे थे और पतरस बी तिना साथे खड़ी की आग सेखणे लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तेबे प्रदान पुरोईते यीशुए ते तिना रे चेले और तिना रे उपदेशो रे बारे रे पूछेया। ");
INSERT INTO bfz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीशुए जवाब दित्तेया, “मैं दुनिया रे खुली की गल्ला कित्तिया, मैं प्रार्थना रे कअरो रे और मन्दरो रे, जेती सब यहूदी कट्ठे ओया करो थे, सदा उपदेश दित्तेया और चोरिए कुछ नि बोलेया। ");
INSERT INTO bfz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तूँ मांते कऊँ पूछेया? सुणने वाल़ेया ते पूछ कि मैं तिना खे क्या बोलेया? देख, सेयो जाणोए कि मैं क्या-क्या बोलेया?” ");
INSERT INTO bfz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जेबे तिने ये बोलेया, तेबे मन्दरो रे पईरेदारा बीचा ते एक ई जणे, जो नेड़े था खड़े रा, यीशुए खे थप्पड़ बाई की बोलेया, “क्या तूँ प्रदान पुरोईतो खे ईंयां जवाब देआ।” ");
INSERT INTO bfz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीशुए तेसखे बोलेया, “जे मैं बुरा बोलेया, तो तेसा बुराईया पाँदे गवाई दे, पर जे खरा बोली राखेया, तो माखे कऊँ बाणे लगी रा?” ");
INSERT INTO bfz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","हन्ने यीशु बानेया रा कैफे प्रदान पुरोईतो गे पेजी ता। ");
INSERT INTO bfz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","शमौन पतरस खड़े रा आग सेखणे लगी रा था। तेबे तिने तेसखे बोलेया, “क्या तूँ बी एसरे चेलेया बीचा ते ए?” तिने बोलेया, “आऊँ निए।” ");
INSERT INTO bfz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","प्रदान पुरोईतो रे दासो बीचा ते एकी जणे जो तेसरे टब्बरो बीचा ते था, जेसरा कान पतरसे बाडीता था, बोलेया, “क्या मैं तूँ यीशुए साथे बगीचे रे नि देखेया था?” ");
INSERT INTO bfz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरसे फेर ना करी ती और तेबुई मुर्गे बांग दित्ती। ");
INSERT INTO bfz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तेबे सेयो यीशुए खे कैफे गे ते राज्यपालो रे मुख्यालय रे लयी गे और प्यागा रा बखत था, पर सेयो आपू पीतरे नि गये, ताकि अशुद्ध ना ओ, पर फसह रे त्योआरो री रोटी खाई सको। ");
INSERT INTO bfz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तेबे पिलातुस तिना गे बारे निकल़ेया और बोलेया, “तुसे एस मांणूए पाँदे किजी गल्ला रा दोष लगाओए?” ");
INSERT INTO bfz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","तिने जवाब दित्तेया, “ये मांणू अपराधी ए, तेबेई तो आसे एसखे तांगे लई की आई रे।” ");
INSERT INTO bfz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुसे तिना खे बोलेया, “तुसेई एसखे लयी जाई की आपणे बिधानो रे मुताबिक न्याय करो।” यहूदिये अगुवे तेसखे बोलेया, “आसा खे अक्क निए कि केसी रा प्राण लऊँ।” ");
INSERT INTO bfz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ये तेबे ऊआ ताकि यीशुए री से गल्ल पूरी ओ, जो तिने ये साअरा करदे ऊए बोली थी कि तेसरा मरना केड़ा ऊणा। ");
INSERT INTO bfz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तेबे पिलातुस फेर राज्यपालो रे मुख्यालय रे पीतरे गया और यीशुए खे बुलाई की तिना ते पूछेया, “क्या तूँ यहूदिये रा राजा ए?” ");
INSERT INTO bfz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीशुए बोलेया, “क्या तूँ ये गल्ल आपणी तरफा ते बोलणे लगी रा या ओरी मेरे बारे रे तांगे बोली?” ");
INSERT INTO bfz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुसे बोलेया, “तुसे क्या सोचोए आऊँ यहूदी ए? तेरी जातिया वाल़े और बड़े पुरोईते ई तूँ मेरे आथो रे देई राखेया। तैं एड़ा क्या करी राखेया?” ");
INSERT INTO bfz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीशुए जवाब दित्तेया, “मेरा राज्य एसा दुनिया रा निए, जे मेरा राज्य एसा दुनिया रा ऊँदा, तो मेरे सेवक लड़दे और माखे यहूदी अगुवो रे आथो रे नि देंदे, पर एबे मेरा राज्य एथो रा निए।” ");
INSERT INTO bfz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातुसे तिना खे बोलेया, “तो क्या तूँ राजा ए?” यीशुए बोलेया, “तूँ आपू बोलेया कि आऊँ राजा ए मैं तेबेई तो जन्म लया और तेबेई तो दुनिया रे आयी रा कि सच्चो री गवाई देऊँ, जो कोई सच्चाईया ते प्यार राखोआ, से मेरा शब्द सुणोआ।” ");
INSERT INTO bfz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुसे बोलेया, “तो सच क्या ए?” ये बोली की से फेर यहूदी अगुवे गे चली गा और तिना खे बोलेया, “आऊँ तो तेसदे कोई दोष नि पाँदा।” ");
INSERT INTO bfz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पर तुसा री ये रवाज ए कि आऊँ फसह रे त्योआरो रे तुसा खे एक मांणू छाडी देऊँ, तेबे क्या तुसे चाओए कि आऊँ तुसा खे यहूदिया रा राजा छाडी देऊँ? ");
INSERT INTO bfz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तेबे तिने चींगी की बोलेया, “एसखे नि पर आसा खे बरअब्बे खे छाडी दे।” जो हुड़दंग और अत्या री बजअ ते जेला रे पाया था। ");
INSERT INTO bfz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","तेबे पिलातुसे यीशुए खे कोड़े लगवाए। ");
INSERT INTO bfz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपाईए कांडेया रा मुकट बूणी की तिना रे सिरो पाँदे राखी ता और तिना खे बैंगणी टाले पईनाए। ");
INSERT INTO bfz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","और तिना गे आयी-आयी की बोलणे लगे, “ओ यहूदिया रे राजा प्रणाम!” और तिना खे थप्पड़ बाए। ");
INSERT INTO bfz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तेबे पिलातुसे फेर बारे निकल़ी की लोका खे बोलेया, “देखो, आऊँ तेसखे तुसा गे फेर बारे ल्याऊँआ, ताकि तुसे जाणो कि आऊँ तेसदे कोई दोष नि पाँदा।” ");
INSERT INTO bfz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तेबे यीशु कांडेया रा मुकट और बैंगणी टाले पणयाई की बारे निकयाल़े और पिलातुसे बोलेया, “देखो, ये मांणू।” ");
INSERT INTO bfz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","तेबे बड़े पुरोईते और मन्दरो रे पईरेदारे ए सेयो देखे और जोरे की बोलेया, “एसखे क्रूसो पाँदे चढ़ाओ, क्रूसो पाँदे।” पिलातुसे तिना खे बोलेया, “तुसेई एसखे लयी की क्रूसो पाँदे चढ़ाओ, कऊँकि आऊँ एसदे कोई दोष नि पाँदा।” ");
INSERT INTO bfz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदिये अगुवे तेसखे बोलेया, “आसा रा बी बिधान ए और म्हारे बिधानो रे मुताबिक, ये क्रूसो पाँदे चढ़ाणे जोगा ए कऊँकि तिने आपू खे परमेशरो रा पुत्र बताया।” ");
INSERT INTO bfz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जेबे पिलातुसे ये गल्ल सुणी, तेबे ओर बी डरीगा। ");
INSERT INTO bfz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","तेबे फेर राज्यपालो रे मुख्यालय रे पीतरे गया और यीशुए खे बोलेया, “तूँ केथो राए?” पर यीशुए तेसखे कोई बी जवाब नि दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातुसे तिना खे बोलेया, “मांगे कऊँ नि बोलदा? क्या तूँ नि जाणदा कि ताखे छाडणे रा अक्क मांगे ए और ताखे क्रूसो पाँदे चढ़ाणे रा बी?” ");
INSERT INTO bfz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीशुए बोलेया, “ताखे परमेशरो री तरफा ते ए अक्क देई राखेया, तेबेई तेरा मां पाँदे अक्क ए, जिने आऊँ तेरे आथो रे पकड़वाया, तेसरा पाप जादा ए।” ");
INSERT INTO bfz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","तेबे पिलातुसे सेयो छाडणा चाए, पर यहूदिये चींगी-चींगी की बोलेया, “जे तूँ एसखे छाडी देगा, तो तेरी भक्ति कैसरो री तरफा खे निए, जो कोई आपणे आपू खे राजा बणाओआ, से कैसरो रा सामणा करोआ।” ");
INSERT INTO bfz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","इना गल्ला सुणी की पिलातुस यीशुए खे बारे ल्याया और तेती एक चबूतरा था, जेतेखे इब्रानिया रे गब्बता बोलोए, और न्याय आसणो रे बैठेया। ");
INSERT INTO bfz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ये फसह रे त्योआरो री त्यारिया रा दिन था और दोपईरो रे तकरीबन था, तेबे तिने यहूदिये खे बोलेया, “देखो, येईए तुसा रा राजा।” ");
INSERT INTO bfz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पर सेयो चींगे और बोलेया, “लयी जा, लयी जा, एसखे क्रूसो पाँदे चढ़ाओ।” पिलातुसे तिना खे बोलेया, “क्या आऊँ तुसा रे राजे खे क्रूसो पाँदे चढ़ाऊँ?” बड़े पुरोईते जवाब दित्तेया, “कैसरो खे छाडी की आसा रा कोई राजा निए।” ");
INSERT INTO bfz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तेबे पिलातुसे यीशु क्रूसो पाँदे चढ़ाणे खे तिना रे आथो रे देईते, ताकि तिना खे क्रूसो पाँदे चढ़ाई देओ। ");
INSERT INTO bfz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तेबे सेयो यीशुए खे लयी गे। और सेयो आपणा क्रूस चकी की तेसा जगा तक गये, जेतेखे खोपड़िया री जगा बोलो थे और इब्रानिया रे गुलगुता। ");
INSERT INTO bfz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","तेती तिने सेयो और तिना साथे दो ओर मांणू क्रूसो पाँदे चढ़ाए, एकी खे ओरे और दूजे खे पोरे और बीचे यीशु। ");
INSERT INTO bfz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","तेबे पिलातुसे एक दोष पत्र लिखी की क्रूसो पाँदे लगाईता और तिदे लिखी राखेया था, “यीशु नासरी यहूदिया रा राजा।” ");
INSERT INTO bfz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ये दोष पत्र बऊत यहूदिये पढ़ेया, कऊँकि से जगा, जेती यीशु क्रूसो पाँदे चढ़ाए थे से जगा यरूशलेम नगरो ते नेड़े ई थी और पत्र, इब्रानी, लतीनी और यूनानिया रे लिखेया रा था। ");
INSERT INTO bfz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तेबे यहूदिया रे बड़े पुरोईते पिलातुसो खे बोलेया, “यहूदिया रा राजा नि लिख,” पर ये लिख कि तिने बोलेया, “आऊँ यहूदिया रा राजा ए।” ");
INSERT INTO bfz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुसे बोलेया, “मैं जो लिखी ता, से लिखी ता।” ");
INSERT INTO bfz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जेबे सिपाई यीशुए खे क्रूसो रे चढ़ाई चुके, तेबे तिना रे टाले लयी की चार इस्से कित्ते, हर सिपाईए खे एक इस्सा, तेबे तिने कुरता बी लया पर कुरता बिना सलाईया ते ऊबो ते लयी की ऊँदो तक बुणेया रा था। ");
INSERT INTO bfz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","तेबे तिने आपू बीचे बोलेया, “आसे एसखे फाड़ना रणी देऊँए, पर एते पाँदे पर्ची पाऊँए कि ये केसरा ऊणा। ये तेबे ऊआ कि पवित्र शास्त्रो री गल्ल पूरी ओ कि “तिने आपू बीचे मेरे टाले बांडी ते और मेरे टालेया पाँदे पर्ची पायी,” ");
INSERT INTO bfz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","तो सिपाईए एड़ा ई कित्तेया। यीशुए रे क्रूसो गे तिना री आम्मा और तेसा री बईण, क्लोपासो री लाड़ी मरियम और मरियम मगदलिनी खड़ी रिया थिया। ");
INSERT INTO bfz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","जेबे यीशुए आपणी आम्मा और तेस चेले खे जेसते से प्यार राखो था, नेड़े खड़े रा देखेया तो आपणी आम्मा खे बोलेया, “ओ जवाणसे, देख, ये तेरा पाऊए।” ");
INSERT INTO bfz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तेबे तिने चेले खे बोलेया, “ये तेरी आम्मा ए।” तेबे तेसी बखते से चेला तेसा खे आपणे कअरे लयी गा। ");
INSERT INTO bfz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","इजी ते बाद यीशुए ये जाणी की कि एबे सब कुछ ऊईगा, ताकि पवित्र शास्त्रो री गल्ल पूरी ओ, तिने बोलेया, “आऊँ त्याया ए।” ");
INSERT INTO bfz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","तेती एक सिरके रा पांडा परी की था राखेया रा, तेबे तिने स्पंजो रा टाला सिरके रे सेड़ेया और डण्डे पाँदे राखी की तिना रे मुंओ रे लगाया। ");
INSERT INTO bfz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","जेबे यीशुए से सिरका चाखेया, तेबे बोलेया, “पूरा ऊआ” और सिर चुकाई की प्राण छाडी ते। ");
INSERT INTO bfz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","तेबे से त्यारिया रा दिन था, यहूदिये पिलातुसो ते बिनती कित्ती कि तिना री खुटिया तोड़ी देओ और तिना खे ऊतारी देओ, ताकि आरामो रे दिने सेयो क्रूसो रे नि रओ, कऊँकि ये आरामो रा दिन बड़ा दिन था। ");
INSERT INTO bfz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","तेबे सिपाईए आयी की पईले रिया खुटिया तोड़िया, तेबे दूजे रिया, जो तिना साथे क्रूसो रे चढ़ाई राखे थे। ");
INSERT INTO bfz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पर जेबे यीशुए गे आयी की देखेया कि ये मरी चुकेया रा, तो तिना री खुटिया नि तोड़िया। ");
INSERT INTO bfz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पर सिपाईया बीचा ते एकी जणे एक बड़छा बखिया रे कुसाया और तेते बीचा ते तेबुई खून और पाणी निकल़ेया। ");
INSERT INTO bfz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जिने ये देखेया, तिने ई ये गवाई दित्ती और तेसरी गवाई सच्ची ए और से जाणोआ कि सच बोलणे लगी रा, ताकि तुसे बी विश्वास करो। ");
INSERT INTO bfz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","यो गल्ला तेबे ऊईया, ताकि पवित्र शास्त्रो रा से वचन पूरा ओ, “तेसरी कोई बी आड्डी तोड़ी नि जाणी।” ");
INSERT INTO bfz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फेर एक ओरी जगा रे ये लिखी राखेया, “जिने से ऊजी राखेया, तिना पाँदे नजर करनी।” ");
INSERT INTO bfz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","इना गल्ला ते बाद अरिमतियाह गांव रा यूसुफे, जो यीशुए रा चेला था, पर यहूदी अगुओ रे डरो रे मारे से एसा गल्ला खे छिपाए रे राखो था, तिने पिलातुसो ते बिनती कित्ती कि आऊँ यीशुए री लोथ लयी जाऊँ; और पिलातुसे तेसरी बिनती सुणी और से आयी की तिना री लोथ लयी गा। ");
INSERT INTO bfz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस बी, जो पईले यीशुए गे राथियो खे गया था, पंजा सेरो रे तकरीबन मिलेया रा गन्धरस और एलवा ल्याया। ");
INSERT INTO bfz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तेबे तिने यीशुए री लोथ लयी और यहूदिया रे दबाणे री रवाजा रे मुताबिक सेयो खुशबूदार चीजा साथे कफनो रे लपेटेया। ");
INSERT INTO bfz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","तेसा जगा रे जेती यीशु क्रूसो पाँदे चढ़ाए थे, एक बगीचा था और तेस बागीचे रे एक नयी कब्र थी, जेती कदी कोई नि राखेया था। ");
INSERT INTO bfz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","तेबे यहूदिया री त्यारिया रे दिनो री बजअ ते, तिने यीशुए री लोथ तिदे ई राखी, कऊँकि से कब्र नेड़े थी। ");
INSERT INTO bfz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","अफ़्ते रे पईले दिने मरियम मगदलिनी कुछ ओर जवाणसा साथे प्यागा ई न्हेरे-न्हेरे कब्रा पाँदे आयी और तिने पात्थर कब्रा पाँदा ते आटेया रा देखेया। ");
INSERT INTO bfz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","तेबे सेयो दौड़ी की शमौन पतरस और बाकि चेलेया गे गईया, जिना खे यीशु प्यार करो थे, और बोलेया, “सेयो प्रभुए रे शरीरो खे कब्रा ते निकाल़ी की लयी गे रे और आसे नि जाणदिया कि तिना खे केयी लयी गे रे।” ");
INSERT INTO bfz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तेबे पतरस और दूजा चेला निकल़ी की कब्रा गे गये। ");
INSERT INTO bfz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","और दोनो साथे-साथे दौड़ने लगी रे थे, पर दूजा चेला पतरसो ते आगे दौड़ी की कब्रा पाँदे पईले पऊँछेया। ");
INSERT INTO bfz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","तिने नपी की टाले ई पड़े रे देखे, पर से पीतरे नि गया। ");
INSERT INTO bfz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","तेबे शमौन पतरस तेसते पीछे-पीछे पऊँछेया और कब्रा रे पीतरे गया और टाले पड़े रे देखे। ");
INSERT INTO bfz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","और से टाल्ला जो तिना रे सिरो रे था बानेया रा, से टालेया साथे नि था, पर एक लग जगा रे था लपेटेया रा। ");
INSERT INTO bfz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तेबे दूजा चेला बी, जो कब्रा पाँदे पईले पऊँछेया था, पीतरे गया और देखी की विश्वास कित्तेया कि यीशु मरेया रे बीचा ते जिऊँदा ऊईगा रा। ");
INSERT INTO bfz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","सेयो एबुए तक पवित्र शास्त्रो री गल्ल नि समजे थे कि से मरेया रे बीचा ते जिऊँदा ऊणा था। ");
INSERT INTO bfz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","तेबे सेयो चेले आपणे कअरो खे वापस ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","पर मरियम रोंदी ऊई कब्रा गे ई बारे खड़ी री रई और रोंदे-रोंदे कब्रा खे चूकी की देखदी रई। ");
INSERT INTO bfz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","तेबे तेसे दो स्वर्गदूत सफेद टाले पईने रे, एक सरयाणे रे और दूजा पाईंदिया रे बैठे रे देखे, जेती यीशुए री लोथ थी पड़ी री। ");
INSERT INTO bfz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","तिने तेसा खे बोलेया, “ओ जवाणसे तूँ कऊँ लगी री रोणे?” तेसे तिना खे बोलेया, “सेयो मेरे प्रभुए रे शरीरो खे चकी की लयी गे रे और आऊँ नि जाणदी कि सेयो केयी लयी गे रे।” ");
INSERT INTO bfz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ये बोली कि से पीछे मुड़ी और यीशु खड़े रे देखे और पछयाणे नि कि यीशु ए। ");
INSERT INTO bfz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीशुए तेसा खे बोलेया, “ओ जवाणसे तूँ कऊँ लगी री रोणे? केसखे टोल़ेई?” तेसे माली समजी की तिना खे बोलेया, “ओ महाराज! जे तुसे तिना रा शरीर चकी की लयी गे रे तो मांगे बताई दे कि केयी राखी राखे और आऊँ तिना खे लयी जाऊँगी।” ");
INSERT INTO bfz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीशुए तेसा खे बोलेया, “मरियम!” तेसे पीछे मुड़ी की तिना खे इब्रानी पाषा रे बोलेया, “रब्बुनी!” मतलब-ओ गुरू! ");
INSERT INTO bfz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीशुए तेसा खे बोलेया, “माखे नि छूँ, कऊँकि आऊँ एबुए तक ऊबे पिते गे नि जाई रा, पर मेरे पाईया गे जाई की तिना खे बोली दे कि आऊँ आपणे पिते गे और तुसा रे परमेशरो गे ऊबे जाऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मगदलिनिये जाई की चेलेया गे बताया, “मैं प्रभु देखे, तिने मां साथे गल्ला कित्तिया।” ");
INSERT INTO bfz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","तेसी दिने, जो अफ़्ते रा पईला दिन था, साँजके बखते, जेबे तेथो रे द्वार, जेती चेले थे, यहूदी अगुओ रे डरो रे मारे बंद थे, तेबे यीशु आए और बीचे खड़े ऊई की तिना खे बोलेया, “तुसा खे शान्ति मिलो।” ");
INSERT INTO bfz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","और ये बोली की तिने आपणे आथ और आपणी पसल़ी तिना खे दखाए, तेबे चेले यीशुए खे देखी की खुश ऊए। ");
INSERT INTO bfz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीशुए तिना खे फेर बोलेया, “तुसा खे शान्ति मिलो; जिंयाँ पिते आऊँ पेजी राखेया, तिंयाँ ई आऊँ बी तुसा खे दुनिया रे पेजुँआ।” ");
INSERT INTO bfz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ये बोली की तिने तिना पाँदे फूकर दित्ती और बोलेया, “पवित्र आत्मा लओ। ");
INSERT INTO bfz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","जिना रे पाप तुसे माफ करो, तिना खे माफ ऊईगे और जिना रे पाप तुसे माफ नि करोगे, तिना रे पाप माफ नि ऊणे।” ");
INSERT INTO bfz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","पर बारा चेलेया बीचा ते एक, मतलब-थोमा, जेसखे दिदुमुस बी बोलोए, जेबे यीशु आए, तो से तिना साथे नि था। ");
INSERT INTO bfz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जेबे ओर चेले तेसखे बोलणे लगे, “आसे यीशु देखे,” तेबे तिने तिना खे बोलेया, “जदुओ तक आऊँ तिना रे आथो रे परेगा रे छेद नि देखी लऊँ और परेगा रे छेदो रे आपणी गूठी और तिना री पसल़िया रे आपणा आथ नि पाई लऊँ, तदुओ तक आऊँ विश्वास नि करदा कि से मरेया रे बीचा ते जिऊँदा ऊईगा रा।” ");
INSERT INTO bfz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","एक अफ़्ते ते बाद फेर तिना रे चेले पीतरे थे और थोमा तिना साथे था और द्वार बंद थे, तेबे यीशुए आयी की और बीचे खड़ी की बोलेया, “तुसा खे शान्ति मिलो।” ");
INSERT INTO bfz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तेबे तिने थोमे खे बोलेया, “आपणी गूठी ओरे ल्याई की मेरी पसल़िया रे पा और अविश्वासी नि, पर विश्वासी बण।” ");
INSERT INTO bfz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ये सुणी की थोमे बोलेया, “ओ मेरे प्रभु! ओ मेरे परमेशर!” ");
INSERT INTO bfz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीशुए तेसखे बोलेया, “तैं तो माखे देखी की विश्वास करी राखेया, पर धन्य सेयो, जिने बिना देखे विश्वास कित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीशुए ओर बी बऊत चमत्कार चेलेया सामणे दखाए, जो एसा कताबा रे लिखी नि राखे। ");
INSERT INTO bfz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पर यो तेबे लिखे, ताकि तुसे विश्वास करो कि यीशु ई परमेशरो रा पुत्र मसीह ए, और विश्वास करी की तिना रे नाओं ते अनन्त जीवन पाओ। ");
INSERT INTO bfz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","इना गल्ला ते बाद यीशु तिबिरियास समुद्रो रे कनारे आपणे चेलेया सामणे आए और ईंयां सामणे आए, ");
INSERT INTO bfz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","शमौन पतरस और थोमा, जेसखे दिदुमुस बी बोलोए और गलीलो रे काना नगरो रा नतनएल और जब्दिए रे पाऊ और यीशुए रे चेलेया बीचा ते दो ओर जणे कट्ठे थे। ");
INSERT INTO bfz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","शमौन पतरसे तिना खे बोलेया, “आऊँ मछलिया पकड़ने जाऊँआ।” तिने बोलेया, “आसे बी तां साथे चलूँए।” तेबे सेयो निकल़ी की किस्तिया रे चढ़े, पर तेसा राती कुछ नि पकड़ेया। ");
INSERT INTO bfz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","आगले दिने प्याग ऊँदे ई यीशु कनारे पाँदे थे खड़े रे, पर चेलेया नि पछयाणे कि यीशु ए। ");
INSERT INTO bfz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तेबे यीशुए तिना खे बोलेया, “ओ बाल़को! क्या तुसा गे कुछ खाणे खे आए?” तिने बोलेया, “ना।” ");
INSERT INTO bfz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","तिने तिना खे बोलेया, “किस्तिया रे दाँणी तरफा खे जाल़ पाओ, तो मिलणा।” तेबे तिने जाल़ पाया और एबे बऊत मछलिया ऊणे री बजअ ते जाल़ खिंजी नि सके। ");
INSERT INTO bfz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तेबे तिने चेले जेस साथे यीशु प्यार राखो थे, पतरसो खे बोलेया, “ये तो प्रभु ए।” शमौन पतरसे ये सुणी की कि यीशु ए, लको रे टाला बानी ला, कऊँकि से नांगा था और समुद्रो रे छवाल़ खाई ती। कऊँकि से यीशु खे मिलणे खे बड़ा उताऊल़ा था ");
INSERT INTO bfz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","पर ओर चेले डोंगिया पाँदे मछलिया रा फरेया रा जाल़ खींजदे ऊए आए, कऊँकि सेयो कनारे ते बऊत दूर नि थे, पर दो सौ की आथ दूर थे। ");
INSERT INTO bfz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जेबे सेयो कनारे पाँदे पऊँछे, तेबे तिने सुल़गे रे फेऊओ पाँदे मछली देखी और रोटी देखी। ");
INSERT INTO bfz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीशुए तिना खे बोलेया, “जो मछलिया तुसे एबु पकड़ी राखिया, तिना बीचा ते कुछ ल्याओ।” ");
INSERT INTO bfz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","शमौन पतरसे डोंगिया पाँदे चढ़ी की एक सौ तिरेपन बड़िया मछलिया रा परेया रा जाल़ कनारे पाँदे खींजेया और इतणिया मछलिया ऊँदे ऊए बी जाल़ नि फटेया। ");
INSERT INTO bfz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीशुए तिना खे बोलेया, “आओ रोटी खाओ।” पर चेलेया बीचा ते केसी खे बी याओ नि ऊआ कि तिना ते पूछो, “तूँ कूणे?” कऊँकि सेयो जाणो थे कि यो यीशु ए। ");
INSERT INTO bfz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीशुए आगे बढ़ी की रोटी लयी की तिना खे दित्ती और तिंयाँ ई मछली बी। ");
INSERT INTO bfz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ये तीजी बार था कि यीशुए मरने ते बाद चेलेया खे दर्शन दित्ते। ");
INSERT INTO bfz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","रोटी खाणे ते बाद यीशुए शमौन पतरसो खे बोलेया, “ओ शमौन, यूहन्ने रे पाऊ! क्या तूँ इना ते जादा माखे प्यार करेया?” तिने बोलेया, “आ प्रभु, तुसे तो जाणोए कि आऊँ तुसा खे प्यार करूँआ।” तिने तेसखे बोलेया, “मेरे मिन्टूआ खे चरा।” ");
INSERT INTO bfz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","तिने फेर दूजी बार तेसखे बोलेया, “ओ शमौन, यूहन्ने रा पाऊ! क्या तूँ माखे प्यार करेया?” तिने बोलेया, “आ प्रभु, तुसे तो जाणोए कि आऊँ तुसा खे प्यार करूँआ।” तिने तेसखे बोलेया, “मेरी पेडा री रखवाल़ी कर।” ");
INSERT INTO bfz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","तिने तीजी बार तेसखे बोलेया, “ओ शमौन, यूहन्ने रा पाऊ! क्या तूँ माखे प्यार करेया?” पतरस उदास ऊईगा कि तिने तीजी बार मांते येई गल्ल पूछी ली। तेबे तिने बोलेया, “ओ प्रभु! तुसे तो सब कुछ जाणोए कि आऊँ तुसा खे प्यार करूँआ।” यीशुए तेसखे बोलेया, “मेरी पेडा खे चरा। ");
INSERT INTO bfz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","आऊँ ताखे सच-सच बोलूँआ कि जेबे तूँ जवान था, तेबे आपणा लक बानी की जेती चाओ था, तेती कूमो-फिरो था, पर जेबे तूँ स्याणा ऊणा, तेबे दूजे आपणे आथ लांबे करने और तेरा लक बानी की जेती से चाओगा, तूँ लयी जाणा।” ");
INSERT INTO bfz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","तिने इना गल्ला ते जताई ता कि पतरसे केड़िया मौता साथे परमेशरो री महिमा करनी। तेबे तिने तेसखे बोलेया, “मां पीछे आईजा।” ");
INSERT INTO bfz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरसे मुड़ी की से चेला देखेया, जेस साथे यीशु प्यार राखो थे, और जिने रोटी खांदे ऊए तिना री छातिया री तरफा खे चूकी की पूछेया था, “ओ प्रभु! तुसा खे पकड़वाणे वाल़ा कूणे?” ");
INSERT INTO bfz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","तेसखे देखी की पतरसे यीशुए खे बोलेया, “ओ प्रभु! एसरा क्या आल ऊणा?” ");
INSERT INTO bfz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीशुए तेसखे बोलेया, “जे आऊँ चाऊँ कि ये मेरे वापस आऊणे तक रूकेया रा रओ, तो ताखे क्या ए? तूँ मां पीछे आईजा।” ");
INSERT INTO bfz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","तेबेई तो पाईया बीचे ये गल्ल फैली गी कि से चेला नि मरना, पर यीशुए ये नि बोलेया कि ये नि मरना, पर ये कि “जे आऊँ चाऊँ कि ये मेरे वापस आऊणे तक रूकेया रा रओ, तो ताखे क्या ए?” ");
INSERT INTO bfz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ये सेई चेला ए जो इना गल्ला री गवाई देओआ और जिने यो गल्ला लिखी राखिया और आसे जाणूंए कि तेसरी गवाई सच्ची ए। ");
INSERT INTO bfz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ओर बी बऊत सारे काम ए, जो यीशुए कित्ते, जे सेयो एक-एक करी की लिखे जांदे, तो आऊँ समजूँआ कि जो कताबा बी लिखिया जांदिया और सेयो दुनिया रे बी नि औडणिया थिया।");
INSERT INTO bfz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ओ श्रीमान्, थियुफिलुस! मैं पईली कताब तिना सबी गल्ला रे बारे रे लिखी, जो प्रभु यीशु शुरूओ ते करदा और सिखांदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","जदुओ तक से परमेशरो रे जरिए स्वर्गो रे नि चकेया गया, तदुओ तक तेसरे स्वर्गो रे चकणे ते पईले, तिने आपणे चुणे रे प्रेरिता खे पवित्र आत्मा रे जरिए आज्ञा देंदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","और यीशुए दु:खो ते और मौता ते बाद, बऊत ई पक्के सबूता साथे आपणे आपू खे प्रेरिता गे जिऊँदा दखाया और चाल़ी दिनो तक सेयो तिना खे दिशदे रये और परमेशरो रे राज्य रिया गल्ला करदे रये। ");
INSERT INTO bfz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","तेबे तिने चेलेया खे मिली की आज्ञा दित्ती, “यरूशलेमो खे नि छाडो, पर पिते रे तेस वादे रा पूरे ऊणे रा इन्तजार करदे रओ, जेतेरे बारे रे तुसे मांते सुणी चुके रे। ");
INSERT INTO bfz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","कऊँकि यूहन्ने तो पाणिए साथे बपतिस्मा देई राखेया, पर थोड़े दिन बाद तुसा पवित्र आत्मा रा बपतिस्मा पाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","तेबे तिने कट्ठे ऊई की तिना ते पूछेया, “ओ प्रभु! क्या तुसा एसी बखते ई इस्राएलो खे राज्य फेरी देणा?” ");
INSERT INTO bfz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","तिने तिना खे बोलेया, “तेस बखतो खे और तेसा कअड़िया खे जाणना, जो पिते आपणे ई अक्को रे राखी राखे, तुसा रा काम निए। ");
INSERT INTO bfz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पर जेबे पवित्र आत्मा तुसा पाँदे आऊणा, तेबे तुसा सामर्थ पाणी और यरूशलेम नगरो रे, सारे यहूदिया और सामरिया प्रदेशो रे और तरतिया रे कनारे तक तुसे मेरे गवा ऊणे।” ");
INSERT INTO bfz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ये बोलदे ऊए सेयो, तिना रे देखदे-देखदे परमेशरो रे जरिए स्वर्गो खे चकी ते और बादल़ो री बजअ ते सेयो तिना खे जादा देरा तक देखी नि सके। ");
INSERT INTO bfz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","जेबे तिना खे जांदे ऊए सेयो सर्गो खे ताकणे लगी रे थे, तेबे दो मांणू सफेद टाले पईने रे अचाणक तिना बीचे आयी की खड़े ऊईगे ");
INSERT INTO bfz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","और तिना खे बोलेया, “ओ गलीली मर्दो! तुसे खड़े ऊई की सर्गो खे कऊँ लगी रे देखणे? येई यीशु जो तुसा गे ते स्वर्गो खे चकी ला रा, जिंयाँ तुसे से स्वर्गो खे जांदा ऊआ देखी राखेया, तिंयाँ ई से फेर आऊणा।” ");
INSERT INTO bfz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","तेबे चेले जैतून नाओं रे पाह्ड़ो ते, जो यरूशलेम नगरो रे नेड़े तकरीबन एक किलोमीटरो री दुरिया रे ए, यरूशलेमो खे वापस ऊए। ");
INSERT INTO bfz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","जेबे सेयो नगरो रे पऊँछे, तेबे सेयो तेसा बाऊड़ी दे गये, जेती पतरस, यूहन्ना, याकूब, अन्द्रियास, फिलिप्पुस, थोमा, बरतुल्मै, मत्ती, हलफईसो रा पाऊ याकूब, शमौन जेलोतेस और याकूबो रा पाऊ यहूदा रओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","यो सब कईया जवाणसा साथे और प्रभु यीशुए री आम्मा मरियम और तिना रे पाईया साथे एक चित्त ऊई की प्रार्थना रे लगे रये। ");
INSERT INTO bfz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","तिना दिना रेई पतरस पाईया बीचे, जो एक सौ बीईया रे तकरीबन विश्वासी थे, खड़ा ऊई की बोलणे लगेया, ");
INSERT INTO bfz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ओ पाईयो जरूरी था कि पवित्र शास्त्रो रा से लेख पूरा ओ, जो पवित्र आत्मे दाऊदो रे मुंओ ते यहूदा रे बारे दे, जो प्रभु यीशुए खे पकड़ने वाल़ेया रा अगुवा था, पईले तेई बोलेया था। ");
INSERT INTO bfz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहूदा तो आसा बीचे गिणेया गया और तेसा सेवकाईया रे शामिल ऊआ।” ");
INSERT INTO bfz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","तिने पापो री कमाईया ते एक डोरू खरीदेया और सिरो रे पारे रूड़ेया और तेसरा पेट फटीगा और तेसरी सारिया आंजा निकल़ी गिया, ");
INSERT INTO bfz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","और एसा गल्ला खे यरूशलेमो रे रणे वाल़े जाणी गे, एथो तक कि तेस डोरूआ रा नाओं तिना री पाषा रे हकलदमा, मतलब-खूनो रा डोरू पड़ी गा। ");
INSERT INTO bfz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","पतरसे बोलेया, “कऊँकि भजनसंहिता रे लिखी राखेया, “ ‘तेसरा कअर उजड़ी जाओ और तिदे कोई ना बसो,’ ‘और तेसरी अध्यक्षो री जगा कोई ओर लयी लो।’ ");
INSERT INTO bfz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“तेबेई ये जरूरी ए कि एक एड़ा मांणू चुणेया जाओ जो प्रभु यीशुए रे कित्ते रे सारे कामो रे गवा ओ। प्रभु यीशुए खे यूहन्ने रे जरिए बपतिस्मा देणे ते लयी की तिना रे स्वर्गो रे चकणे तक ये आदमी आसा साथे प्रभु यीशुए रे मरे रेया बीचा ते जिऊँदा ऊणे रा गवा बणो। ");
INSERT INTO bfz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","खरा ए कि तिना बीचा ते एक मांणू आसा साथे, यीशुए रे जिऊँदे ऊणे रा गवा ऊई जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तेबे तिने दो जणे खड़े कित्ते, एक यूसुफ, जेसखे बरसब्बास बी बोलोए, जेसरा छोटा नाओं युस्तुस ए और दूजा मत्तियाह। ");
INSERT INTO bfz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","तेबे ये बोली की प्रार्थना कित्ती, “ओ प्रभु! तुसे जो सबी रे मनो खे जाणोए, ये बताओ कि तुसे इना दूँईं बीचा ते कुण चुणी राखेया, ");
INSERT INTO bfz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ताकि से एसा सेवा री और प्रेरिताईया री जगा लई लओ, जेसखे यहूदा छाडी की आपणी जगा खे गया।” ");
INSERT INTO bfz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तेबे तिने तिना रे बारे रे चिट्ठिया पाईया और पत्री मत्तियाहो रे नाओं पाँदे निकल़ी, तेबे से तिना ग्यारा प्रेरिता साथे गिणेया गया। ");
INSERT INTO bfz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जेबे यहूदिया रा पिन्तेकुसो रा त्योआरो रा दिन आया, तेबे सेयो सब एकी जगा रे कट्ठे थे। ");
INSERT INTO bfz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","तदुओ की एकदम सर्गो ते बड़े तूफानो री जी छेड़ ऊई और तिजी ते सारा कअर, जेती सेयो थे बैठे रे, गूँजी गा। ");
INSERT INTO bfz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","तिना खे आगी रिया लुपिया जेड़िया जीबा निकल़दिया ऊईया दिशिया और तिना बीचे सबी पाँदे आयी की ठईरी गिया। ");
INSERT INTO bfz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","तेबे सेयो सब पवित्र आत्मा ते परी गे और जिंयाँ पवित्र आत्मे तिना खे बोलणे री सामर्थ दित्ती, सेयो लग-लग पाषा रे बोलणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","तिना दिना रे बऊत भक्त यहूदी जो परमेशरो ते डरो थे, दुनिया रे हर देशो ते त्योआर मनाणे आये थे और यरूशलेम नगरो रे रणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जेबे से छेड़ ऊई, तेबे पीड़ कट्ठी ऊईगी और लोक कबराई गे, कऊँकि हर एकी खे येई सुणो था कि ये मेरी ई पाषा रे बोलणे लगी रे। ");
INSERT INTO bfz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","सेयो सब हैरान ऊई की बोलणे लगे, “देखो, ये जो बोलणे लगी रे, क्या सब गलीली निए? ");
INSERT INTO bfz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तो तेबे ये क्या ऊणे लगी रा, तेबे आसे सब आपणी-आपणी जन्म-भूमिया री पाषा कऊँ सुणने लगी रे? ");
INSERT INTO bfz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","आसा बीचा ते जो पारथी, मेदी और एलामी लोक, मेसोपोटामिया, यहूदिया, कप्पदूकिया, पुन्तुस, आसिया, ");
INSERT INTO bfz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फुगिया, पंफूलिया, मिस्र और लिबिया वासी जो कुरेनो रे नेड़े-तेड़े ए, इना सबी देशो रे रणे वाल़े और रोमो रे रणे वाल़े यहूदी और यहूदी तर्म तारण करने वाल़े, ");
INSERT INTO bfz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","मतलब क्या यहूदी और क्या यहूदी तर्म तारण करने वाल़े, क्रेती और अरबी बी ए, पर आपणी-आपणी पाषा रे तिना ते परमेशरो रे बड़े-बड़े कामो रे बारे रे चर्चा सुणने लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","तेबे सेयो सब हैरान ऊईगे और कबराई की एकी-दूजे खे बोलणे लगे, “ये क्या ऊणे लगी रा?” ");
INSERT INTO bfz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पर ओरी मजाक करी की बोलेया, “सेयो तो नये शराबो रे नशे रे चूर ए।” ");
INSERT INTO bfz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तेबे पतरस तिना ग्यारा चेलेया साथे खड़ा ऊआ और जोरे की बोलणे लगेया, “ओ यहूदिया! और ओ यरूशलेमो रे सब रणे वाल़ो! ये जाणी लो और कान लगाई की मेरी गल्ला सुणो। ");
INSERT INTO bfz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","जेड़ा तुसे समजणे लगी रे, यो लोक नशे रे निए, कऊँकि एबु तो प्यागा रे नौ ई बजी रे। ");
INSERT INTO bfz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","पर ये से गल्ल ए, जो परमेशरे योएल भविष्यबक्ते रे जरिए बोली थी, ");
INSERT INTO bfz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘परमेशर बोलोआ कि आखरी रे दिना रे एड़ा ऊणा, कि मां आपणा आत्मा सबी मांणूआ पाँदे लटणा और तुसा रे माठे-बेटिया भविष्यबाणी करनी और तुसा रे जवाना दर्शन देखणे और तुसा रे बुजुर्गा सुपने देखणे। ");
INSERT INTO bfz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","बल्कि मां आपणे दास और दासिया पाँदे तिना दिना रे आपणी आत्मा बीचा ते लटणा और तिना भविष्यबाणी करनी ");
INSERT INTO bfz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","और मां ऊबे सर्गो रे अचम्बे रे काम और ऊँदे तरतिया रे चिह्न्, मतलब-खून, आग और तुएँ रे बादल़ दखाणे। ");
INSERT INTO bfz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","प्रभुए रा न्याय रा दिन आऊणे ते पईले सूरज काल़ा और चाँद खूनो जेड़ा लाल ऊई जाणा। ");
INSERT INTO bfz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","और जेस केसी प्रभुए रा नाओं लणा, तेसरा ई उद्धार ऊणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ओ इस्राएलियो! इना गल्ला खे सुणो, यीशु नासरी एक मांणू था। जेसरा परमेशरो री तरफा ते ऊणे रा सबूत, तिना सामर्था रे कामो, अचम्बे रे कामो ते और चमत्कारा ते प्रगट ए। जो परमेशरे तुसा बीचे, तेसरे जरिए दखाए, जेसखे तुसे आपू बी जाणोए। ");
INSERT INTO bfz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","तेस ई यीशुए खे, जो परमेशरो री ठराई री योजना और पईलके ज्ञानो रे मुताबिक पकड़वाया। तेबे तुसे से पापिया रे आथो क्रूसो पाँदे चढ़ाई की मरवाईता। ");
INSERT INTO bfz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पर सेई परमेशरे मौता रे बंदनो ते छुड़ाई की जिऊँदा कित्तेया, कऊँकि ये ऊणा नि था कि से तेसरे वशो रे रंदा। ");
INSERT INTO bfz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","कऊँकि दाऊद यीशु मसीह रे बारे रे बोलोआ, “आऊँ सदा प्रभुए खे आपणे सामणे देखदा रया, कऊँकि से मेरी दाँणी तरफा खे ए, ताकि आऊँ कबराई नि जाऊँ। ");
INSERT INTO bfz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","इजी री बजअ ते मेरा मन खुश ऊआ और मेरी जीब मग्न ऊई, बल्कि मेरा शरीर बी उम्मीदा रे बसे रा रणा। ");
INSERT INTO bfz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","कऊँकि तां मेरा प्राण नरको रे नि छाडणा और तां आपणा पवित्र जन सड़ने नि देणा। ");
INSERT INTO bfz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तैं माखे जीवनो री बाट बताई राखी, तां आपणे दर्शनो रे जरिए आऊँ खुशिये की परी देणा। ");
INSERT INTO bfz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ओ पाईयो! आऊँ तेस कुलपति दाऊदो रे बारे रे तुसा खे इम्मता साथे बोली सकूँआ कि से तो मरी गा और दबाई बी दित्तेया और तेसरी कब्र आजो तक आसा गे मौजुद ए। ");
INSERT INTO bfz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","से भविष्यबक्ता था और ये जाणो था कि परमेशरे मांते कसम खाई की वादा करी राखेया कि मां तेरे वंशो बीचा ते एक जणा तेरे सिंहासनो पाँदे बठयाल़ना। ");
INSERT INTO bfz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","तिने ऊणे वाल़ी गल्ला खे पईले तेई देखी की मसीह रे जिऊँदे ऊणे रे बारे रे भविष्यबाणी कित्ती, कि ना तो तेरा प्राण नरको रे छाडेया और ना ई तेसरा शरीर सड़ेया। ");
INSERT INTO bfz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","येई यीशु परमेशरे जिऊँदा कित्तेया, जेसरे आसे सब गवा ए। ");
INSERT INTO bfz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","तिंयाँ ई परमेशरो रे दाँणे आथो ते सबी ते उचा पद पाई की और पिते ते से पवित्र आत्मा पाई की जो वादा कित्तेया था, तिने ये लटेया, जो आज तुसे देखोए और सुणोए। ");
INSERT INTO bfz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","कऊँकि दाऊद तो स्वर्गो रे नि चढ़ना, पर से आपू बोलोआ, “ ‘प्रभुए परमेशरे मेरे प्रभुए खे बोलेया; ");
INSERT INTO bfz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","मेरे दाँणे बैठ, जदुओ तक आऊँ तेरे बैरिया खे तेरे पैरा निठे नि करी देऊँ।’ ");
INSERT INTO bfz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“तो एबे इस्राएलो रा सारा कराना, पक्का जाणी लओ कि परमेशरे तेसी यीशुए खे, जो तुसे क्रूसो पाँदे चढ़ाया, प्रभु बी और मसीह बी ठराया।” ");
INSERT INTO bfz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","तेबे सुणने वाल़े लोका खे विश्वास ऊईगा कि आसे गल़त काम करी राखेया और सेयो पतरसो खे और बाकि प्रेरिता खे पूछणे लगे, “ओ पाईयो! आसे क्या करिए?” ");
INSERT INTO bfz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरसे तिना खे बोलेया, “पापो ते मन फिराओ, और तुसा बीचा ते हर एक आपणे-आपणे पापो री माफिया खे यीशु मसीह रे नाओं ते बपतिस्मा लओ, तो तुसा खे पवित्र आत्मा रा दान मिलणा। ");
INSERT INTO bfz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ये वादा तुसे और तुसा री ल्वादे और तिना सबी दूरो-दूरो रे लोका खे बीए, जो प्रभुए म्हारे परमेशरे आपू गे बुलाणे।” ");
INSERT INTO bfz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरसे बऊत ओर गल्ला री गवाई देई-देई की बी समजयाया, “आपणे आपू खे एसा टेडिया जातिया ते बचाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","तो जिने लोके पतरसो रा वचन सुणी की मानेया, तिने बपतिस्मा लया और तेसी दिने तीन ह्जार मांणूआ रे तकरीबन विश्वासिया साथे मिली गे। ");
INSERT INTO bfz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","तेबे ये सब विश्वासी प्रेरिता ते शिक्षा पाणे और संगति राखणे रे और रोटी तोड़ने रे और प्रार्थना करने रे लगे रे रये ");
INSERT INTO bfz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","और यरूशलेमो रे सबी लोका खे डर ऊईगा और बऊत अचम्बे रे काम और चिह्न् प्रेरित करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","और सेयो सब विश्वास करने वाल़े कट्ठे रओ थे और तिना री सब चीजा साजिया थिया। ");
INSERT INTO bfz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","और सेयो आपणी-आपणी सम्पति और सामान बेची-बेची की जेड़ी जेसरी जरूरत ओ थी, बांडी देओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","और सेयो हर रोज एक मन ऊई की मन्दरो रे कट्ठे ओ थे और कअरे-कअरे रोटी तोड़ी की खुश और मन लगाई की रोटी खाया करो थे ");
INSERT INTO bfz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","और परमेशरो री स्तुति करो थे और सब लोक तिना ते खुश थे और जो उद्धार पाओ थे तिना खे प्रभु हर रोज तिना बीचे मिलाई देओ था। ");
INSERT INTO bfz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","पतरस और यूहन्ना तकरीबन दोपईरो रे तीन बजे प्रार्थना रे बखते मन्दरो रे जाणे लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","तेबे लोक एक लंगड़े खे ल्याए, जो जन्मो तेई लंगड़ा था। तेसखे सेयो हर रोज मन्दरो रे तेस द्वारो पाँदे, जेतेखे सुन्दर बोलोए, बठयाल़ी देओ थे, ताकि से मन्दरो रे जाणे वाल़ेया ते पीख माँगो। ");
INSERT INTO bfz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जेबे तिने पतरस और यूहन्ना मन्दरो रे जांदे ऊए देखे, तो तिना ते पीख मांगी। ");
INSERT INTO bfz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पतरसे यूहन्ने साथे तेसरी तरफा खे बड़े ई त्यानो साथे देखी की बोलेया, “आसा कनारो खे देख।” ");
INSERT INTO bfz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","तेबे पीख मांगणे वाल़ा जन्मो रा लंगड़ा तिना ते कुछ पाणे री उम्मीदा ते तिना खे ताकणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","तेबे पतरसे बोलेया, “सुईना और चाँदी मांगे आए नि, पर जो मांगे आए, से ताखे देऊँआ, यीशु मसीह नासरियो रे नाओं ते उठ और चल-फिर।” ");
INSERT INTO bfz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","तेबे पतरसे तेसरा दाँणा आथ पकड़ी की से खड़ा कित्तेया और तेबुई तेसरे पैरा और खुटिया रे जान आईगी। ");
INSERT INTO bfz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","से उटकी की खड़ा ऊईगा और चलणे-फिरने लगेया और चलदा उछल़दा और परमेशरो री स्तुति करदा ऊआ तिना साथे मन्दरो रे आँगणो रे गया। ");
INSERT INTO bfz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","सबी लोके से उटकदे और परमेशरो री स्तुति करदा ऊआ देखी की ");
INSERT INTO bfz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","से पछयाणी ला कि ये तो सेई लंगड़ा ए, जो मन्दरो रे सुन्दर फाटको पाँदे बैठी की पीख माँगो था और तेस कामो ते जो तेस साथे ऊआ था, सेयो बऊत हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","जेबे से पतरस और यूहन्ने खे पकड़े रे था, तो सब लोक बऊत हैरान ऊई की जेतेखे सुलेमानो रा बरंडा (बरामदा) बोलोए, तिना गे दौड़दे ऊए आए। ");
INSERT INTO bfz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ये देखी की पतरसे लोका खे बोलेया, “ओ इस्राएलियो! तुसे एस मांणूए खे देखी की अचम्बा कऊँ करोए? और आसा री तरफा खे ईंयां कऊँ लगी रे देखणे कि मानो आसे ई आपणी सामर्थ या भक्तिया ते ये चलणे-फिरने जोगा करी राखेया? ");
INSERT INTO bfz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम, इसहाक और याकूबो रे परमेशर, आसा रे बाप-दादेया रे परमेशरे आपणे सेवक यीशुए री महिमा कित्ती, जो तुसे मारने खे यहूदी अगुवे रे आथो रे पकड़वाया। जेबे पिलातुसे तेसखे छाडणे रा बिचार बणाया, तेबे तुसे तेसरे सामणे तेसरी बेज्जती कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तुसे यीशुए खे मानणे ते ना कित्ती जो पवित्र और तर्मी था और बिनती कित्ती कि एक खुनिए खे तुसा खे छाडेया जाओ ");
INSERT INTO bfz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","और तुसे अनन्त जीवनो खे बनाणे वाल़ा मरवाईता, जो परमेशरे मरे रेया बीचा ते जिऊँदा कित्तेया और एसा गल्ला रे आसे गवा ए। ");
INSERT INTO bfz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","और यीशुए मसीह रेई नाओं ते, तेस विश्वासो रे जरिए, जो तेसरे नाओं पाँदे ए, एस मांणूए खे जेसखे तुसे देखणे लगी रे और जाणो बी ए कि सामर्थ देई राखी, तिने विश्वासे ई, जो तेसरे जरिए ए, से तुसा सबी सामणे, पला-चंगा करी ता। ");
INSERT INTO bfz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“एबे ओ पाईयो! आऊँ जाणूंआ कि तुसे और तुसा रे अगुवे यीशु अणजाणे रे काई ते। कऊँकि तुसे नि जाणो थे कि सेई मसीह था। ");
INSERT INTO bfz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पर जो गल्ला परमेशरे सबी भविष्यबक्तेया रे मुंओ ते पईले ई बुलाईया थिया कि तेसरे मसीह दु:ख सईन करना और मरना, से तिने तिंयाँ ई पूरा कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","इजी री खातर मन फिराओ और वापस आओ, कि तुसा रे पाप माफ ऊई जाओ, ताकि प्रभुए रे सामणे शान्तिया रे दिन आओ। ");
INSERT INTO bfz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","और से यीशुए खे पेजो, जो तुसा खे पईले तेई मसीह चुणी राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","जरूरी ये कि से स्वर्गो रे तेस बखतो तक रओ, जदुओ तक कि से सबी गल्ला खे सुदारी नि लओ, जेतेरे बारे रे परमेशरे आपणे पवित्र भविष्यबक्तेया रे मुंओ ते बोली राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","जेड़ा कि मूसे बोली राखेया, प्रभु परमेशरे तुसा रे पाईया बीचा ते, तुसा खे मां जेड़ा एक भविष्यबक्ता पेजणा, जो कुछ से तुसा खे बोलो, से करना। ");
INSERT INTO bfz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","पर हर मांणू जो तेस भविष्यबक्ते री नि सुणोगा, से लोका बीचा ते नाश ऊणा। ");
INSERT INTO bfz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“और शमुएलो ते लयी की तेसरे बाद वाल़ेया तक, जितणे भविष्यबक्ते गल्ल बोली, तिने सबी इना दिना रा संदेश देई राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","तुसे सब तिना भविष्यबक्तेया री ल्वाद और तेस वादे रे इस्सेदार ए, जो परमेशरे तुसा रे बाप-दादेया साथे बानी, जेबे तिने अब्राहमो खे बोलेया कि तेरे कुल़ो रे जरिए तरतिया रे सारे करानेया आशीष पाणी, ");
INSERT INTO bfz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","परमेशरे आपणे सेवको खे मरे रेया बीचा ते जिऊँदा करी की सबी ते पईले तुसा गे पेजेया, ताकि तुसा बीचा ते हर एकी खे तेसरी बुराईया ते फेरी की आशीष देओ।” ");
INSERT INTO bfz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","जेबे सेयो लोका खे ये बोलणे लगी रे थे, तेबे पुरोईत, मन्दरो रे सरदार और सदूकी तिना पाँदो खे आईगे। ");
INSERT INTO bfz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","कऊँकि तिना खे बऊत रोष आईगा कि सेयो लोका खे सिखाओ थे और प्रभु यीशुए रा उदारण देई-देई की मरे रेया रा जिऊँदे उठणे रा प्रचार करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","तेबे तिने सेयो पकड़ी की प्यागा तक जेला रे राखे, कऊँकि साँज ऊईगी थी। ");
INSERT INTO bfz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पर जिने-जिने वचन सुणेया, तिना बीचा ते बऊत जणेया यीशुए पाँदे विश्वास कित्तेया और तिना री गिणती पाँज ह्जार मर्दो रे तकरीबन ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","दूजे दिने एड़ा ऊआ कि यहूदिया रे अगुवे, बुजुर्ग और शास्त्री, ");
INSERT INTO bfz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","प्रदान पुरोईत हन्ना, कैफा, यूहन्ना, सिकन्दर और जितणे प्रदान पुरोईतो रे कराने रे थे, सब यरूशलेमो रे कट्ठे ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","सेयो तिना खे बीचे खड़े करी की पूछणे लगे, “तुसे ये काम कुण जी सामर्था ते और केसरे नाओं ते कित्तेया?” ");
INSERT INTO bfz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तेबे पतरसे पवित्र आत्मा ते परी की बुजुर्गा खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“ओ लोका रे सरदारो और बुजुर्गो! आसे एस कमजोर मांणूए साथे जो पलाई करी राखी, जे आज तिजी रे बारे रे पूछ-ताछ ओई कि से किंयाँ ठीक ऊआ, ");
INSERT INTO bfz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तो तुसे सब और सारे इस्राएली लोक जाणी लओ कि यीशु मसीह नासरियो रे नाओं ते, जो तुसे क्रूसो पाँदे चढ़ाईता और परमेशरे से मरे रेया बीचा ते जिऊँदा कित्तेया, आज तिना रे नाओं रे जरिए ये मांणू तुसा सामणे पला-चंगा खड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","यीशु मसीह ई सेई पात्थर ए, जो तुसे राजमिस्त्रिए ठुकराईता और ये कूणे रे सिरे रा पात्थर ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","यीशुए ते बगैर केसी दूजे रे जरिए उद्धार निए, कऊँकि स्वर्गो रे निठे और मांणूआ बीचे और कोई नाओं नि देई राखेया, जेसरे जरिए आसे उद्धार पाई सकूँ।” ");
INSERT INTO bfz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जेबे तिने पतरस और यूहन्ने री इम्मत देखी और ये जाणी ला कि यो तो अनपढ़ और सादारण मांणू ए तो हैरान ऊईगे, तेबे सेयो पछयाणे कि यो तो प्रभु यीशुए साथे रओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","तेबे तेस मांणूए खे जो ठीक ऊईगा था, पतरस और यूहन्ने साथे खड़ा देखी की यहूदी अगुवे तिना रे खलाफ कुछ नि बोली सके। ");
INSERT INTO bfz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","पर तिना खे सभा ते बारे पेजी की आपू बीचे बिचार करने लगे, ");
INSERT INTO bfz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“आसे इना मांणूआ साथे क्या करिए? कऊँकि यरूशलेमो रे सब रणे वाल़ेया खे पता ए कि इने एक खास चमत्कार दखाई राखेया और आसे तिजी ते मुकरी नि सकदे। ");
INSERT INTO bfz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पर इजी री खातर कि लोका बीचे ये गल्ल ओर जादा नि फैली जाओ, आसे तिना खे तमकी देऊँए कि सेयो एस नाओं ते फेर कदी केसी मांणूए साथे गल्ला नि करो।” ");
INSERT INTO bfz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तेबे तिने सेयो बुलाए और तिना खे चेतावणी देई की बोलेया, “यीशुए रे नाओं ते कुछ नि बोलणा और ना सखयाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पर पतरस और यूहन्ने तिना खे जवाब दित्तेया, “तुसेई न्याय करो कि क्या ये परमेशरो रे नेड़े खरा ए कि आसे परमेशरो री गल्ला ते बढ़ी की तुसा री गल्ल मानूँ? ");
INSERT INTO bfz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","कऊँकि ये तो आसा ते ऊई नि सकदा, जो आसे देखी राखेया और सुणी राखेया, से नि बोलूँ।” ");
INSERT INTO bfz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तेबे तिने सेयो ओर बी तमकाए और छाडी ते, कऊँकि लोका री बजअ ते तिना खे कोई बी सजा देणे रा बाना नि मिलेया, कऊँकि जो घटणा ऊई थी, तिजी री बजअ ते सब लोक परमेशरो री तारीफ करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","कऊँकि से मांणू, जो चमत्कारी रूपो ते ठीक ऊईगा था, चाल़ी साला ते जादा उम्रा रा था। ");
INSERT INTO bfz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","सेयो छूटी की आपणे साथिया गे गये और जो कुछ बड़े पुरोईते और बुजुर्गे तिना साथे कित्तेया था, सब कुछ तिना गे बताया। ");
INSERT INTO bfz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ये सुणी की तिने एक चित्त ऊई की जोरे की परमेशरो खे बोलेया, “ओ स्वामी! तूँ सेईए जिने स्वर्ग, तरती, समुद्र और जो कुछ तिना रे बणाई राखेया, ");
INSERT INTO bfz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तैं पवित्र आत्मा रे जरिए आपणे सेवक, आसा रे पिता, दाऊदो रे मुंओ ते बोलेया, “दूजिये जातिये आल्ला कऊँ पाया? और देशो रे लोके बेकारो री गल्ला कऊँ सोचिया? ");
INSERT INTO bfz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","प्रभु और मसीह रे अभिषेक कित्ते रे बिरोदो रे तरतिया रे राजा खड़े ऊए और हाकिम एकी साथे कट्ठे ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“कऊँकि सच्ची तेरे सेवक यीशुए रे बिरोदो रे, जेसरा तैं अभिषेक कित्तेया, हेरोदेस और पुन्तियुस पिलातुस बी दूजी जातिया साथे और इस्राएलिया साथे एस नगरो रे कट्ठे ऊए। ");
INSERT INTO bfz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","कि जो कुछ पईले ते तेरी सामर्थ और समजा ते ठईरेया था, से ई ओ। ");
INSERT INTO bfz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","एबे, ओ प्रभु, तिना री तमकिया खे सुण, और आपणे दासा खे ये बरदान दे कि तेरा वचन बड़ी ई इम्मता साथे सुणाऊँ ");
INSERT INTO bfz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ठीक करने खे तूँ आपणा आथ बढ़ा कि चिह्न् और अचम्बे रे काम तेरे पवित्र सेवक यीशुए रे नाओं ते करे जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जेबे सेयो प्रार्थना करी चुके, तेबे से जगा, जेती सेयो खड़ी रे थे, से जगा इल्ली गी और सेयो सब पवित्र आत्मा ते परी गे और परमेशरो रा वचन इम्मता साथे सुणांदे रये। ");
INSERT INTO bfz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","विश्वास करने वाल़ेया री मण्डल़ी एक चित्त और एक मनो री थी, एथो तक कोई बी आपणी जायदाता खे आपणी नि बोलो था, बल्कि सब कुछ साजा था। ");
INSERT INTO bfz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","प्रेरित बड़ी सामर्था साथे प्रभु यीशुए रे जिऊँदे ऊणे री गवाई देंदे रये और तिना सबी पाँदे बड़ी कृपा थी। ");
INSERT INTO bfz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","तिना बीचे कोई बी गरीब नि था, कऊँकि जिना गे जमीन या कअर थे, सेयो तिना खे बेची-बेची की बिकी री चीजा रा दाम ल्याओ थे और से प्रेरिता रे पैरा गे राखी देओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","और जेड़ी, जेसखे जरूरत ओ थी, तिजी रे मुताबिक हर एकी विश्वासिये खे प्रेरित बांडी देओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","यूसुफ नाओं रा साईप्रस टापूए रा एक लेवी था, जेसरा नाओं प्रेरिते बरनबास, मतलब-इम्मत देणे वाल़ा मांणू राखी राखेया था। ");
INSERT INTO bfz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","तेसरी कुछ जमीन थी, जो तिने बेची ती और दामो रे पैसे ल्याई की प्रेरिता खे देई ते कि सेयो तिजी खे जरूरतमंद लोका बीचे बांडी देओ। ");
INSERT INTO bfz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नाओं रे एक मांणूए आपणी लाड़ी सफीरा साथे मिली की आपणी जमीना रा एक पाअग बेची ता ");
INSERT INTO bfz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","और तिजी रे दामो बीचा ते कुछ आपू खे राखी ता और ये गल्ल तेसरी लाड़ी बी जाणो थी और तिजी रा एक इस्सा ल्याई की प्रेरिता खे देईता। ");
INSERT INTO bfz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","तेबे पतरसे बोलेया, “ओ हनन्याह! शैताने तेरे मनो रे ये गल्ल किंयाँ पाई कि तूँ पवित्र आत्मा ते चूठ बोले और जमीना रे दामो बीचा ते कुछ आपू खे राखी दे? ");
INSERT INTO bfz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","जदुओ तक से तांगे रई, क्या तेरी नि थी? और जेबे बिकी गी तो क्या तेरे वशो रे नि थी? तेरे मनो रे एस बुरे कामो रा बिचार किंयाँ आया? तैं मांणूआ ते नि, पर परमेशरो ते चूठ बोलेया।” ");
INSERT INTO bfz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","इना गल्ला सुणी की हनन्याह जमीना पाँदे रूड़ी गा और मरी गा और सबी सुणने वाल़ेया खे डर लगी गा। ");
INSERT INTO bfz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","तेबे जवाने आयी की तेसरी अर्थी बणाई और बारे लयी जाई की से दबाई ता। ");
INSERT INTO bfz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","तकरीबन तीन कंटे ते बाद तेसरी लाड़ी पीतरे आयी और जो कुछ ऊआ था, तिजी रे बारे रे तेसा खे पता नि था। ");
INSERT INTO bfz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","तेबे पतरसे तेसा खे बोलेया, “मांगे बता क्या तुसे से जमीन इतणे रेई बेची?” तेसे बोलेया, “आ, इतणे रेई।” ");
INSERT INTO bfz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पतरसे तेसा खे बोलेया, “ये क्या गल्ल ऊई कि तुसे दूँईं प्रभुए रे पवित्र आत्मा री परीक्षा खे एड़ा कित्तेया? देख, तेरे लाड़े खे दबाणे वाल़े द्वारो पाँदे ई खड़ी रे और तूँ बी बारे लयी जाणी।” ");
INSERT INTO bfz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","तेबे से फटाफट तेसरे पैरा पाँदे पड़ी गी और मरी गी और जवाने पीतरे आयी की से मरी री देखी और से बी बारे लयी जाई की तेसा रे लाड़े साथे दबाई ती। ");
INSERT INTO bfz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","तेबे यरूशलेमो री सारी मण्डल़ी और इना गल्ला खे सब सुणने वाल़े बऊत ई जादा डरी गे। ");
INSERT INTO bfz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","प्रेरिता रे जरिए बऊत चिह्न् और अचम्बे रे काम लोका बीचे दखाए जाओ थे और मसीह रे सब विश्वासी एक मन ऊई की सुलेमानो रे बरंडे रे कट्ठे ओया करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","पर ओरी बीचा ते जिने यीशुए पाँदे एबुए तक विश्वास नि करी राखेया था केसी खे बी ये इम्मत नि ओ थी कि तिना बीचे जायी की मिली जाईए, पर तेबे बी लोक तिना री तारीफ करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","विश्वास करने वाल़े बऊत सारे मर्द और जवाणसा प्रभुए री मण्डल़िया रे ओर बी जादा आयी की मिलणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","एथो तक कि लोक बमारा खे सड़का रे ल्याई-ल्याई की माँजे पाँदे लटयाई देओ थे कि जेबे पतरस आओ, तेबे तेसरा टवांवा ई तिना बीचा ते केसी पाँदे पड़ी जाओ। ");
INSERT INTO bfz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरूशलेमो रे नेड़े-तेड़े रे नगरो ते बी बऊत लोक बमारा खे और दुष्टात्मा रे सताए रे, तिना गे ल्याई-ल्याई की कट्ठे ओ थे और सेयो सबी खे ठीक करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","तेबे प्रदान पुरोईत और तेसरे सब साथी, जो सदूकिया रे टोलिया रे थे, चेलेया रे खलाफ जल़ना ते परी गे ");
INSERT INTO bfz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","और तिने प्रेरित पकड़ी की जेला रे बंद करी ते। ");
INSERT INTO bfz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पर राथियो खे प्रभुए रे एक स्वर्गदूते जेला रे द्वार खोली की तिना खे बारे निकयाल़ी की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जाओ और मन्दरो रे खड़े ऊई की एस अनन्त जीवनो रा पूरा संदेश लोका खे सुणाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","जेड़ा तिना खे बताई राखेया था प्याग ऊँदे ई सेयो मन्दरो रे जाई की उपदेश देणे लगे। तेबे प्रदान पुरोईत और तेसरे साथिये आयी की महासभा और इस्राएलिया रे सारे बुजुर्ग कट्ठे कित्ते और जेला रे सन्देशा पेजेया कि तिना खे ल्याओ। ");
INSERT INTO bfz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","पर मन्दरो रे पईरेदारे तेती पऊँछी की चेले जेला री नि पाये और वापस ऊई की सन्देशा दित्तेया ");
INSERT INTO bfz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","कि आसे जेला खे बड़ी चौकसिया साथे बंद कित्तेया रा और पईरेदारा खे बारे द्धारो पाँदे खड़े रा देखेया, पर जेबे खोलेया, तेबे पीतरे कोई नि मिलेया। ");
INSERT INTO bfz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जेबे मन्दरो रे पईरेदारो रे प्रदान और बड़े पुरोईते ये गल्ल सुणी, तो तेबे तिना रे बारे रे पारी चिन्ता रे पड़ी गे कि एबे क्या ऊणा? ");
INSERT INTO bfz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","तदुओ कि किने आयी की तिना गे बताया, “देखो, जो तुसे जेला रे बंद करी राखे थे, सेयो मांणू तो मन्दरो रे खड़े ऊई की लोका खे उपदेश देणे लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","जेब तिने सुणेया तेबे मन्दरो रे पईरेदारो रे प्रदान आपणे पईरेदारा साथे तेती जाई की चेलेया खे महासभा रे सामणे ली आया, पर जबरदस्ती नि, कऊँकि सेयो लोका ते डरो थे कि केथी आसा पाँदे पात्थर नि बाओ। ");
INSERT INTO bfz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","तिने सेयो फेर ल्याई की महासभा सामणे खड़े करी ते, तेबे प्रदान पुरोईते तिना ते पूछेया, ");
INSERT INTO bfz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“क्या आसे तुसे सावधान नि कित्ते थे कि तुसे एस नाओं ते उपदेश नि देणा? तेबे बी देखो, तुसे सारा यरूशलेम आपणे उपदेशो ते परी ता रा और तेस मांणूए री अत्या रा दोष आसा रे गल़े पाँदे ल्याऊणा चाओए।” ");
INSERT INTO bfz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","तेबे पतरसे और ओरी प्रेरिते जवाब दित्तेया, “मांणूए री आज्ञा ते बढ़ी की परमेशरो री आज्ञा खे मानणा ई म्हारा फर्ज ए। ");
INSERT INTO bfz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","आसा रे बाप-दादेया रे परमेशरे प्रभु यीशु मरे रेया बीचा ते जिऊँदा कित्तेया, जो तुसे क्रूसो पाँदे चढ़ाई की मरवाईता था। ");
INSERT INTO bfz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","सेई परमेशरे प्रभु और उद्धारक ठईराई की आपणे दाँणे आथो ते ऊच्चा करी ता, ताकि से इस्राएलिया खे मन फिराओ री शक्ति और पापो ते माफी देओ। ");
INSERT INTO bfz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","और आसे इना गल्ला रे गवा ए और पवित्र आत्मा रे बी, जो परमेशरे तिना खे दित्ती, जो तेसरी आज्ञा मानोए।” ");
INSERT INTO bfz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ये सुणी की महासभा रे सदस्य जल़ने लगे और तिने चेले काणा चाए। ");
INSERT INTO bfz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पर गमलिएल नाओं रे एक फरीसिये, जो धर्मशास्त्री और सबी लोका बीचे जाणा-मानेया रा था, कचैरिया रे खड़े ऊई की प्रेरिता खे थोड़ी देरा खे बारे जाणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तेबे तिने महासभा रे सदस्या खे बोलेया, “ओ इस्राएलियो! जो कुछ इना मांणूआ साथे करना चाओए, सोची समजी की करना। ");
INSERT INTO bfz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","कऊँकि इना दिना ते पईले थियुदास ये बोलदा रओ था कि आऊँ बी कुछ आए; और कोई चार सौ मांणू तेस साथे ऊईगे, पर से कायी ता और जितणे लोक तेसखे मानो थे, सब ओरे-पोरे ऊईगे और खत्म ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","तिजी ते बाद नाओं लिखाईया रे दिनो रे यहूदा गलीली उठेया और तिने कुछ लोक आपणी तरफा खे करी ते, तेसरा बी नाश उई गा और जितणे लोक तेसखे मानो थे, सब ओरे-पोरे ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“इजी री खातर आऊँ तुसा खे बोलूँआ कि इना मांणूआ ते दूर ई रओ और इना ते कोई मतलब नि राखो, कऊँकि जे ये तर्म या काम मांणूआ री तरफा ते ओ, तो तेबे तो नाश ऊई जाणे, ");
INSERT INTO bfz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पर जे परमेशरो री तरफा ते, तो तुसे इना खे कदी बी खत्म नि करी सकदे, केथी एड़ा ना ओ कि तुसे परमेशरो साथे बी लड़ने वाल़े ठईरो।” ");
INSERT INTO bfz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","तेबे तिने तेसरी गल्ल मानी ली और प्रेरित बुलाए और कूटे और ये आज्ञा देई की छाडी ते कि यीशुए रे नाओं ते फेर कदी गल्ला नि करनिया। ");
INSERT INTO bfz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","चेले एसा गल्ला ते खुश ऊई की महासभा रे सामणे ते चली गे कि आसे तेसरे नाओं री खातर नरादर ऊणे जोगे तो ऊए। ");
INSERT INTO bfz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","तेबे चेले हर रोज मन्दरो रे और कअरे-कअरे उपदेश करने और एसा गल्ला रा सुसमाचार सुनाणे ते नि रूके कि यीशु ई मसीह ए। ");
INSERT INTO bfz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","तिना दिना रे जेबे चेले बऊत ऊणे लगे, तेबे यूनानी पाषा बोलणे वाल़े यहूदी चेले इब्रानी पाषा बोलणे वाल़े यहूदी चेलेया पाँदे कुड़कुड़ाणे लगे, “हर दिनो री चीजा देणे रे आसा री बिदुआ री खबर-सम्बाल़ नि लंदे।” ");
INSERT INTO bfz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तेबे तिने बारा चेलेया विश्वासिया री सारी मण्डल़ी आपू गे कट्ठी बुलाई की बोलेया, “ये ठीक निए कि आसे परमेशरो रे वचनो रा प्रचार करना और शिक्षा देणा छाडी की खुलाणे-पल़याणे री सेवा रे लगे रईये। ");
INSERT INTO bfz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","इजी री खातर ओ पाईयो! आपू बीचा ते सात जाणे-माणे मर्दा खे, जो पवित्र आत्मा ते परे रे और सुल़जे रे ओ, चुणी लो, ताकि आसे तिना खे ये काम देई देईए। ");
INSERT INTO bfz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","पर आसा तो प्रार्थना, वचनो रा प्रचार और उपदेश देणे री सेवा रे लगे रे रणा।” ");
INSERT INTO bfz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ये गल्ल सारी मण्डल़िया खे ठीक लगी और तिने स्तिफुनुस नाओं रा एक मांणू जो विश्वासो रे और पवित्र आत्मा ते परे रा था और फिलिप्पुस, नीकानोर, तीमौन, परमिनास, अन्ताकिया वाल़ा नीकुलाऊस, जो यहूदी मतो रे आईगा था, चुणी ले। ");
INSERT INTO bfz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","तेबे यो प्रेरिता सामणे खड़े कित्ते। और इना चूणे रे माणूंआ खे प्रार्थना कित्ती और तिना पाँदे आथ राखी की तिना खे सेवा करने रा अक्क दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","तेबे परमेशरो रा वचन फैलदा गया और यरूशलेमो रे चेलेया री गिणती बड़दी गयी और यहूदी पुरोईता रा एक बड़ा समाज यीशु मसीह पाँदे विश्वास करी की एस मतो खे मानणे वाल़ा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफुनुस कृपा और सामर्था ते परिपूर्ण ऊई की लोका खे बड़े-बड़े चिह्न् और अचम्बे रे काम दखाया करो था। ");
INSERT INTO bfz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","पर कुछ लोके स्तिफनुसो रा बरोद कित्तेया। बरोद करने वाल़े तेस प्रार्थना रे कअरो रे सदस्य थे जो गुलामिया ते आजाद ऊई रे थे, और कुरेनी, सिकन्दरिया, किलिकिया और आसिया रे लोका बीचा ते कई एक उठी की स्तिफुनुसो साथे बईस करने लगे। ");
INSERT INTO bfz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","पर तेस ज्ञानो ते और पवित्र आत्मा रा, जेते री मतादा ते से गल्ला करो था, सेयो सामणा नि करी सके। ");
INSERT INTO bfz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","तेबे तिने कई लोक स्तिफुनुसो रे बारे रे चूठ बोलणे खे उकसाए जो बोलणे लगे, “आसे ये मूसे और परमेशरो रे खलाफ निन्दा री गल्ला करदे ऊए सुणी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","तेबे लोक, बुजुर्ग और शास्त्रिया खे पड़काई की तेस पाँदो खे आईगे और तेसखे पकड़ी की महासभा रे लयी गे। ");
INSERT INTO bfz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","और चूठे गवा खड़े करी ते और स्तिफनुसो पाँदे आरोप लगाई की बोलेया, “ये मांणू एसा पवित्र जगा रे बारे रे और मूसे रा बिधानो रे खलाफ बोलणा नि छाडदा। ");
INSERT INTO bfz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","कऊँकि आसे ये, ये बोलदे ऊए सुणी राखेया कि एसी यीशु नासरिये ये मन्दर टाल़ी देणा और सेयो रवाजा बदली देणियां जो मूसे आसा गे सम्बाल़ी राखिया।” ");
INSERT INTO bfz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तेबे सबी लोके जो सभा रे बैठी रे थे, तेसखे ताकणे लगे तो तिने तेसरा मूँ स्वर्गदूतो जेड़ा देखेया। ");
INSERT INTO bfz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तेबे प्रदान पुरोईत पूछेया, “क्या ये आरोप सच ए?” ");
INSERT INTO bfz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्तिफनुसे उतर दित्तेया, “ओ पाईयो और पिताओं सुणो! आसा रा पिता अब्राहम हारान नगरो रे बसणे ते पईले, जेबे मेसोपोटामिया प्रदेशो रे था, तेबे सामर्थी परमेशरे तेसखे दर्शन दित्तेया ");
INSERT INTO bfz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","और तिने बोलेया, ‘तूँ आपणे देशो ते निकल़ी की और आपणे परिवारो ते निकल़ी की तेस देशो रे चली जा, जो मां ताखे दखाणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तेबे से कसदियो रे देशो ते निकल़ी की हारान नगरो रे जाई की बसी गा। तेसरे पिते रे मरने ते बाद परमेशरे से तेथा ते एस देशो रे ल्याई की बसाया, जेती एबे तुसे रओए। ");
INSERT INTO bfz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","तेस बखते परमेशरे तेसखे कुछ बी जायदात, बल्कि पैर राखणे तक बी जगा नि दित्ती, बल्कि परमेशरे वादा कित्तेया कि मां ये देश ताखे और तांते बाद तेरे वंशो खे देई देणा। हालाँकि तेस बखते तेसरा कोई बी पाऊ नि था। ");
INSERT INTO bfz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","परमेशरे एड़ा बोलेया, ‘तेरी ल्वादा रे लोक पराये देशो रे परदेशी ऊणे और तिना सेयो दास बनाणे और चार सौ साला तक तिना खे दु:ख देणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","तेबे परमेशरे बोलेया, ‘जेसा जातिया रे सेयो दास ऊणे, तेसा खे मां सजा देणी और तिजी ते बाद तिना तेस देशो ते निकल़ी की एस देशो रे आयी की मेरी सेवा करनी।’ ");
INSERT INTO bfz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","परमेशरे अब्राहमो साथे खतने री वाचा कित्ती। जेबे अब्राहमो रे पाऊ इसहाको रा जन्म ऊआ तो आठुए दिने तेसरा खतना कित्तेया। इसहाको ते याकूब और याकूबो ते बारा कुलपति जम्मे। ");
INSERT INTO bfz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“कुलपतिये यूसुफो साथे दुश्मणी राखी की से मिस्र देशो खे जाणे वाल़ेया रे आथे बेची ता, पर परमेशर तेस साथे था ");
INSERT INTO bfz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","और परमेशरे यूसुफो खे सारे क्ल़ेशो ते छुड़ाई की मिस्रो रे राजा फिरौनो री नजरा रे कृपा और बुद्धि दित्ती। फिरौन राजे यूसुफो खे मिस्र देशो और आपणे सारे कअरो पाँदे हाकिम बणाया। ");
INSERT INTO bfz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","जेबे यूसुफ राज्यपाल था तेबे सारे मिस्र और कनानो देशो रे अकाल़ पड़ी गा, जेतेरी बजअ ते पारी क्ल़ेश ऊईगा और आसा रे बाप-दादेया खे अन्न नि मिलो था। ");
INSERT INTO bfz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","पर याकूबे ये सुणी की कि मिस्र देशो रे अन्न आए, आसा रे बाप-दादेया खे पईली बार तेथा ते अन्न खरीदणे खे पेजेया। ");
INSERT INTO bfz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","दूजी बार यूसुफ आपणे पाईया सामणे आया और यूसुफो री जाति फिरौनो खे पता लगी गी। ");
INSERT INTO bfz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","तेबे यूसुफे आपणे पिते याकूबो खे संदेशा पेजेया और आपणे सारे टब्बरो रे, जो पचयात्तर मांणू थे, मिस्र देशो खे बुलाए। ");
INSERT INTO bfz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","तेबे याकूब मिस्रो रे आया और तेती से और आसा रे बाप-दादे मरी गे। ");
INSERT INTO bfz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","तिना री लोथा शाकेमो रे पऊँछाई की तेसा कब्रा रे राखिया, जो अब्राहमे चाँदी देई की शाकेमो रे हमोरो री ल्वादा ते खरीदी थी। ");
INSERT INTO bfz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“पर जेबे तेसा कसमा रा पूरा ऊणे रा बखत नेड़े आया, तेबे जो वादा परमेशरे अब्राहमो साथे कित्तेया था, तेबे मिस्रो रे सेयो लोक बड़ी गे और बऊत ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","तेबे मिस्रो रे दूजा राजा ऊआ, जो यूसुफो खे नि जाणो था। ");
INSERT INTO bfz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","तिने आसा री जातिया साथे चलाकी करी की आसा रे बाप-दादेया साथे गल़त बर्ताव कित्तेया, एथो तक की तिना खे आपणे नये जम्मे रे बाल़क सेटणे पड़े, ताकि सेयो जिऊँदे नि रओ। ");
INSERT INTO bfz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","तेस बखते मूसे रा जन्म ऊआ। से परमेशरो री नजरा रे बऊत ई सुन्दर था और से तीन मीन्ने तक आपणे पिते रे कअरे लकोई की पाल़ेया। ");
INSERT INTO bfz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","जेबे तेसखे लकोई की राखणा मुश्किल ऊईगा तेबे तिने से टोकरिया दे पाई की नदिया रे हड़ाईता, तेबे फिरौनो री बेटिये से चकी ला और आपणा पाऊ समजी की पाल़ेया। ");
INSERT INTO bfz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मूसे खे मिस्रिया री सारी विधा पढ़ाई और से वचन और कामो रे सामर्थी था। ");
INSERT INTO bfz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“जेबे मूसा चाल़िया साला रा ऊआ तेबे तेसरे मनो रे आया कि आऊँ आपणे इस्राएली पाईया खे मिलूँ। ");
INSERT INTO bfz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","तेती तिने एक इस्राएली मांणूए पाँदे अन्याय ऊँदे ऊए देखेया और से बचाया और मिस्रिए खे काई की जो सताई राखे थे, बदला लया। ");
INSERT INTO bfz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","तिने सोचेया कि मेरे पाईया समजणा कि परमेशरे मेरे आथो साथे तिना खे गुलामिया ते आजाद करना, पर सेयो नि समजे। ");
INSERT INTO bfz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","दूजे दिने जेबे सेयो आपू बीचे लड़ने लगी रे थे, तेबे से तेती आईगा और ये बोली की तिना खे मलाप करने खे बोलेया कि ओ मर्दो! तुसे तो पाई-पाई ए, एकी-दूजे पाँदे अन्याय कऊँ करोए? ");
INSERT INTO bfz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","पर जो आपणे पड़ोसिया पाँदे अन्याय करने लगी रा था तिने से ये बोली की कनारे टाई ता, ‘तूँ किने आसा पाँदे हाकिम और न्यायी बणाई राखेया? ");
INSERT INTO bfz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","क्या जिंयाँ तैं काल मिस्री काया, माखे बी काणा चाएया?’ ");
INSERT INTO bfz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ये गल्ल सुणी की मूसा नठी गा और मिद्यान देशो रे जाई की परदेशी ऊई की रणे लगेया और तेती तेसरे दो पाऊ ऊए। ");
INSERT INTO bfz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“जेबे पूरे चाल़ी साल मिद्यान देशो रे बीती गे, तेबे एक स्वर्गदूते सीनै पाह्ड़ो रे जंगल़ो रे तेसखे फुखदे ऊए जाड़ो री लूपिया रे दर्शन दित्ते। ");
INSERT INTO bfz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मूसा ये दर्शन देखी की हैरान ऊईगा और जेबे देखणे खे ओर नेड़े गया, तेबे प्रभुए री आवाज ऊई, ");
INSERT INTO bfz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘आऊँ तेरे बाप-दादे, अब्राहम, इसहाक और याकूबो रा परमेशर ए।’ तेबे मूसे खे डरो रे मारे थुरनी छूटी गी, एथो तक कि तेसखे देखणे री इम्मत नि रई। ");
INSERT INTO bfz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तेबे प्रभुए तेसखे बोलेया, ‘आपणे पैरो ते जोड़े खोली दे, कऊँकि जेते जगा रे तूँ खड़ी रा, से पवित्र जगा ए। ");
INSERT INTO bfz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मैं सच्ची आपणे लोका री जो मिस्र देशो रे बुरी दशा देखी राखी और तिना रा कणना और तिना रा रोणा सुणी राखेया, तेबेई तो आऊँ तिना खे छुड़ाणे खे उतरी रा, एबे आओ और मां तूँ मिस्र देशो रे पेजणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ये सेई मूसा ए जो इस्राएलिए ये बोली की नकारिता था कि तूँ किने आसा पाँदे हाकिम और न्यायी ठईराई राखेया? सेई परमेशरे हाकिम और छुड़ाणे वाल़ा बणाया। तेस स्वर्गदूतो रे जरिए, जिने तेसखे जाड़ो रे दर्शन दित्तेया था, पेजेया। ");
INSERT INTO bfz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","येई मांणू मिस्र देश और लाल समुद्र और जंगल़ो रे चाल़िया साला तक अचम्बे रे काम और चिह्न् दखाई-दखाई की तिना खे निकयाल़ी की ली आया। ");
INSERT INTO bfz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ये सेई मूसा ए, जिने इस्राएली लोका खे बोलेया, ‘परमेशरे तुसा रे पाईया बीचा ते तुसा रिया तंईं मां जेड़ा एक भविष्यबक्ता चकणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ये सेई मूसा ए जिने जंगल़ो रे मण्डल़िया रे बीचे, तेस स्वर्गदूतो साथे सीनै पाह्ड़ो पाँदे तेस साथे गल्ला कित्तिया और आसा रे बाप-दादेया साथे था, तेसखे ई जिऊँदे वचन मिले ताकि आसा तक पऊँछाओ। ");
INSERT INTO bfz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पर आसा रे बाप-दादेया मूसा री गल्ल मानणी नि चायी। तिने से ठुकराईता और सेयो मिस्र देशो खे वापस जाणा चाओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“और लोके मूसा रे पाई हारूणो खे बोलेया, ‘आसा खे एड़ा देवता बणा, जो आसा ते आगे-आगे रओ और आसा खे वापस मिस्र देशो खे लयी चलो, कऊँकि ये मूसा जो आसा खे मिस्र देशो ते निकयाल़ी की ल्याया, आसे नि जाणदे कि एसखे क्या ऊआ?’ ");
INSERT INTO bfz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","तिना दिना रे तिने एक बाछु बणाई की तेसरी मूर्तिया ते आगे बलि चढ़ाई और आपणे आथो रे कामो रे मग्न ऊणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","तेबे परमेशरे तिना ते आपणा मूँ मोड़ी ला और सेयो छाडी ते, ताकि सर्गो रिया चीजा खे पूजो, जेड़ा भविष्यबक्तेया री कताबा रे परमेशरे बोली राखेया, “ओ इस्राएलो रे लोको! क्या तुसे सुनसाण जगा रे चाल़ी साल रई की पशु बलि और अन्नबलि माखे ई चढ़ांदे नि रये? ");
INSERT INTO bfz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","और तुसे मोलेक देवता री बेदी बणाई और रिफान देवता रे तारे खे लयी की फिरदे रओ थे, मतलब-तिना मूर्तिया खे जो तुसे माथा टेकणे खे बणाए थे, तो मां तुसे बेबीलोनो ते पोरे लयी जाई की बसाई देणे। ");
INSERT INTO bfz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“साक्षिया रा तम्बू सुनसाण जगा रे आसा रे बाप-दादेया बीचे था, जेड़ा परमेशरे ठईराया, जिने मूसे खे बोलेया, ‘जेड़ा तैं आयी की देखी राखेया, तिजी रेई मुताबिक इजी खे बणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","तेसी तम्बूओ खे आसा रे बाप-दादे पुराणे जमाने ते पाई की यहोशूओ साथे एती ल्याए, जेस बखते तिने अन्य जातिया रा अक्क पाया, जो परमेशरे आसा रे बाप-दादेया रे सामणे ते निकयाल़ी ता और से तम्बू राजा दाऊदो रे बखतो तक रया। ");
INSERT INTO bfz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊदो पाँदे परमेशरे कृपा कित्ती, तेबे तिने बिनती कित्ती कि मां याकूबो रे परमेशरो खे मन्दर बनाणा। ");
INSERT INTO bfz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पर तेसरे पाऊ सुलेमाने परमेशरो खे मन्दर बणाया। ");
INSERT INTO bfz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","पर परमप्रदान आथो रे बणाए रे मन्दरो रे नि रंदा, जेड़ा कि भविष्यबक्ते री कताबा रे परमेशरे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“परमेशर बोलोआ कि स्वर्ग मेरा सिंहासन और तरती मेरे पैरो री चौकी ए, माखे तुसा केड़ा मन्दर बनाणा? मेरे आराम करने री कुण जी जगा ऊणी? ");
INSERT INTO bfz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","क्या यो सब चीजा मेरे आथो की निए बणाई रिया? ");
INSERT INTO bfz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“ओ टीठ और परमेशरो री गल्ल ना मानणे और ना सुणने वाल़े लोको! तुसे सदा पवित्र आत्मा रा बरोद करोए। जेड़ा तुसा रे बाप-दादे करो थे, तेड़ा ई तुसे बी करोए। ");
INSERT INTO bfz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","भविष्यबक्तेया बीचा ते कुण नि तुसा रे बाप-दादेया नि सताए और तिने से तर्मी, जेसरे आऊणे रे बारे रे पुराणे बखतो ते सन्देश देणे वाल़ा ई काई ता और एबे तुसे बी तेसरे पकड़वाणे वाल़े और काणे वाल़े ऊए। ");
INSERT INTO bfz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुसा खे स्वर्गदूता रे जरिए बणाया रा बिधान तो मिलेया, पर तुसे से बिधान मानेया नि।” ");
INSERT INTO bfz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","इना गल्ला खे सुणी की यहूदी अगुवेया खे इतणा गुस्सा आईगा और स्तिफनुसो पाँदे आपणे दाँद किरड़ने लगे। ");
INSERT INTO bfz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पर तिने पवित्र आत्मा ते परिपूर्ण ऊई की स्वर्गो खे देखेया और परमेशरो री महिमा कित्ती और प्रभु यीशुए खे परमेशरो रे दाँणे कनारे खड़ा देखी की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“देखो, आऊँ स्वर्गो खे खुले रा और माणूं रे पुत्रो खे परमेशरो रे दाणे कनारे खड़े रा देखूँआ।” ");
INSERT INTO bfz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","तेबे तिने जोरे की चींगी की आपणे कान बंद करी ते और एक चित्त ऊई की तेस पाँदे झपटे। ");
INSERT INTO bfz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","तेबे तेसखे यरूशलेम नगरो ते बारे लयी जाई की पात्थर बाणे लगे और तिना री अत्या करी ती। जो गवा थे तिने आपणे टाले शाऊल नाओं रे एक जवानो रे पैरो पाँदे खोली की रखवाल़ी करने खे राखी ते। ");
INSERT INTO bfz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","सेयो स्तिफुनुसो खे पात्थर बांदे रये और से ये बोली की प्रार्थना करदा रया, “ओ प्रभु यीशु मेरी आत्मा खे ग्रहण कर।” ");
INSERT INTO bfz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","तेबे तिने कुटणे टेकी की जोरे की बोलेया, “ओ प्रभु! एस पापो रा दोष तिना पाँदे नि लगा।” ये बोली की से मरी गा। शाऊल बी तेसरी मौता रे शामिल था। ");
INSERT INTO bfz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","शाऊल स्तिफनुसो री मौता रे पूरी तरह ते शामिल था। तेसी दिने यरूशलेम नगरो री मण्डल़िया पाँदे बऊत उपद्रव ऊणे लगेया और प्रेरिता खे छाडी की सब विश्वासी यहूदिया और सामरिया रे प्रदेशो रे ओरे-पोरे ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","तेबे कुछ भग्त लोके स्तिफुनुस कब्रा रे राखेया और तेसखे बऊत दु:ख कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","शाऊल मण्डल़िया खे ऊजाड़ने लगी रा था और कअरे-कअरे कूसी की मर्द और जवाणसा विश्वासिया खे कसिटी-कसिटी की जेला रे पाओ था। ");
INSERT INTO bfz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जो विश्वासी ओरे-पोरे ऊईगे थे, सेयो सुसमाचार सुणांदे ऊए, कुमदे-फिरदे रये। ");
INSERT INTO bfz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलिप्पुस सामरिया प्रदेशो रे एक नगरो रे जाई की मसीह रा प्रचार करने लगेया ");
INSERT INTO bfz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","और जो गल्ला फिलिप्पुसे बोलिया सेयो लोके सुणी की और जो चमत्कार से दखाओ था तिना खे देखी की एक मन ऊई की त्यान लगाया। ");
INSERT INTO bfz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","कऊँकि फिलिप्पुसो री आज्ञा ते बऊत जणेया ते दुष्टात्मा जोरे-जोरे साथे चींगी की निकल़ी गिया और बऊत सारे अदरंगो रे रोगी और लंगड़े बी ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","तेबे तेस नगरो रे बऊत शान्ति ऊईगी। ");
INSERT INTO bfz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","इजी ते पईले तेती शमौन नाओं रा एक मांणू रओ था, जो जादू-टौणा करी की सामरिया जातिया रे लोका खे हैरान करो था और आपणे आपू खे कोई बड़ा मांणू बताओ था। ");
INSERT INTO bfz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","और सब छोटेया ते लयी की बड़ेया तक तेसखे मानो थे और बोलो थे, “ये मांणू परमेशरो री से सामर्थ ए, जेतेखे महान् बोलोए।” ");
INSERT INTO bfz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","तिने बऊत दिनो ते सेयो आपणे जादूओ रे कामो साथे हैरान करी राखे थे। तेबेई तो सेयो तेसखे बऊत मानो थे। ");
INSERT INTO bfz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पर जेबे तिने फिलिप्पुसो पाँदे विश्वास कित्तेया, जो परमेशरो रे राज्य रा और प्रभु यीशु मसीह रे नाओं रा सुसमाचार सुणाओ था, तेबे लोक, क्या मर्द क्या जवाणसा, सब बपतिस्मा लणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","तेबे शमौने आपू बी विश्वास कित्तेया और बपतिस्मा लई की फिलिप्पुसो साथे रणे लगेया, से चिह्न और बड़े-बड़े सामर्था रे काम देखी की हैरान ओ था। ");
INSERT INTO bfz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जेबे प्रेरिते, जो यरूशलेम नगरो रे रओ थे, सुणेया कि सामरिया रे लोके परमेशरो रा वचन मानी ला रा, तेबे पतरस और यूहन्ना तिना गे पेजे। ");
INSERT INTO bfz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","तेबे तिने जाई की तिना खे प्रार्थना कित्ती, ताकि पवित्र आत्मा खे पाओ। ");
INSERT INTO bfz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","कऊँकि से एबुए तक केसी पाँदे नि उतरेया था, तिने तो बस प्रभु यीशुए रे नाओं ते बपतिस्मा लयी राखेया था। ");
INSERT INTO bfz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तेबे पतरसे और यूहन्ने तिना पाँदे आथ राखे और पवित्र आत्मा तिना पाँदे आया। ");
INSERT INTO bfz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जेबे शमौने देखेया कि प्रेरिता रे आथ राखणे ते पवित्र आत्मा दित्तेया जाओआ, तेबे तिने तिना गे पैसे ल्याई की तिना खे बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ये सामर्थ माखे बी देयो ताकि जेस केसी पाँदे आथ राखूँ, तेसखे पवित्र आत्मा मिलो।” ");
INSERT INTO bfz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरसे तेसखे बोलेया, “तेरे पैसे तां साथे ई नाश ओ, कऊँकि तैं परमेशरो रा दान पैसेया साथे खरीदणे रे बारे रे सोचेया। ");
INSERT INTO bfz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","एते सेवा रे तेरा मेरा कोई लेणा-देणा निए कऊँकि तेरा मन परमेशरो सामणे सच्चा निए। ");
INSERT INTO bfz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","इजी री खातर आपणी एसा बुराईया ते मन फिराई की प्रभुए ते प्रार्थना कर, ऊई सकोआ कि तेरे मनो रा बिचार माफ ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","कऊँकि आऊँ देखणे लगी रा कि ताखे इतणी जल़न ओई और पापो रे बन्दनो रे पड़े राए।” ");
INSERT INTO bfz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","शमौने जवाब दित्तेया, “तुसे मेरिया तंईं प्रभुए ते प्रार्थना करो कि जो गल्ला तुसे बोलिया, तिना बीचा ते कोई बी मां पाँदे नि पड़ो।” ");
INSERT INTO bfz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","तेबे सेयो गवाई देई की और प्रभु यीशुए रा वचन सुणाई की यरूशलेमो खे वापस ऊईगे और तिने सामरिया रे बऊत सारे गांव रे सुसमाचार सुणाया। ");
INSERT INTO bfz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","तेबे प्रभुए रे एक स्वर्गदूते फिलिप्पुसो खे बोलेया, “उठी की दक्खणा री तरफा खे, तेसा बाटा रे जा, जो यरूशलेमो ते गाजा नगरो खे जाओई। ये रेगिस्तान बाट ए।” ");
INSERT INTO bfz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","फिलिप्पुस उठी की चली गा। बाटा रे तेसरी मुलाकात एक खोजे ते ऊई, जो कूश देशो री राणी कन्दाके रा मन्त्री और खजान्ची था। से भक्ति करी की यरूशलेमो ते वापस आऊणे लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","से आपणे रथो रे था बैठेया रा और यशायाह भविष्यबक्ते री कताब पढ़दा ऊआ आपणे देशो खे जाणे लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तेबे पवित्र आत्मे फिलिप्पुसो खे बोलेया, “नेड़े जाई की एस रथो साथे ऊई जा।” ");
INSERT INTO bfz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुसे तेसरी तरफा खे दौड़ी की से यशायाह भविष्यबक्ते री कताब पढ़दे ऊए सुणेया और पूछेया, “जो तूँ पढ़ने लगी रा क्या समजणे बी लगी रा?” ");
INSERT INTO bfz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","तिने बोलेया, “जदुओ तक माखे कोई समजयाओ गा नि, तदुओ तक माखे किंयाँ समज आऊणा?” तेबे तिने फिलिप्पुसो ते बिनती कित्ती कि रथो पाँदे चढ़ी की मां साथे बैठी जा। ");
INSERT INTO bfz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","पवित्र शास्त्रो रा जो पाठ से पढ़ने लगी रा था, से ये था “से पेडा जेड़ा काणे खे पऊँछाया और जिंयाँ मिन्टू आपणे ऊन कापणे वाल़ेया सामणे चुप रओआ, तिंयाँ ई तिने बी आपणा मूँ नि खोलेया। ");
INSERT INTO bfz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","तेसरी दीनता रे तेसरा न्याय नि ऊआ और तेसरे बखतो रे लोका रे बारे रे केस बताणा, कऊँकि तरतिया ते तेसरी जिन्दगी लयी ली।” ");
INSERT INTO bfz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","तेबे खोजे फिलिप्पुसो ते पूछेया, “आऊँ तांते बिनती करूँआ कि भविष्यबक्ता ये किजी रे बारे रे बोलणे लगी रा आपणे या केसी दूजे रे बारे रे?” ");
INSERT INTO bfz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तेबे फिलिप्पुसे बोलणा शुरू कित्तेया और एते ई शास्त्रो ते शुरू करी की तेसखे प्रभु यीशुए रा सुसमाचार सुणाया। ");
INSERT INTO bfz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","बाटा रे चलदे ऊए सेयो पाणिए रे कनारे पऊँछे, तेबे खोजे बोलेया, “देख, एती पाणी ए, एबे माखे बपतिस्मा लणे ते कुण रोकी सकोआ?” ");
INSERT INTO bfz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुसे बोलेया, “जे तूँ सारे मनो ते विश्वास करेया, तो लई सकोआ।” तिने बोलेया, “आऊँ विश्वास करूँआ कि यीशु मसीह परमेशरो रा पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तेबे तिने रथ खड़ा करने री आज्ञा दित्ती और खोजा और फिलिप्पुस दोनो जणे पाणिए बीचे गये और फिलिप्पुसे तेसखे बपतिस्मा दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जेबे सेयो पाणिए ते निकल़ी की पाँदे आए, तेबे प्रभुए रा पवित्र आत्मा फिलिप्पुसो खे चकी की लयी गा। और खोजे से फेर नि देखेया और से खुश ऊईगा कि परमेशरे आऊँ बचाईता और आपणे देशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","तेबे फिलिप्पुस अशदोद नगरो रे आयी की निकल़ेया और जदुओ तक कैसरिया नगरो रे नि पऊँछेया, तदुओ तक नगरो-नगरो रे सुसमाचार सुणांदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","शाऊल जो एबुए तक प्रभु यीशुए रे चेलेया खे तमकाणे और काणे री ताका रे था, प्रदान पुरोईतो गे गया। ");
INSERT INTO bfz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","और तेसते दमिश्क नगरो रे नाओं रे प्रार्थना रे कअरो रे नाओं पाँदे इजी खे चिट्ठिया मांगिया कि क्या मर्द क्या जवाणसा, जिना खे से एस पंथो रे पाओगा, तिना खे बानी की यरूशलेमो रे ली आऊँ। ");
INSERT INTO bfz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जेबे शाऊल और तेसरे लोक चलदे-चलदे दमिश्क नगरो रे नेड़े पऊँछे, तेबे एकदम सर्गो ते तेसरे चऊँ कनारे ते जोति चमकी ");
INSERT INTO bfz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","और से जमीना पाँदे रूड़ी गा और तिने प्रभुए री ये आवाज सुणी, “ओ शाऊल! ओ शाऊल! तूँ माखे कऊँ सताणे लगी रा?” ");
INSERT INTO bfz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","तिने पूछेया “ओ प्रभु! तूँ कुण ए?” तिने बोलेया, “आऊँ यीशु ए। जेसखे तूँ सताएया। ");
INSERT INTO bfz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","पर एबे उठी की नगरो खे जा और जो कुछ करना, से ताखे बताई देणा।” ");
INSERT INTO bfz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जो मांणू तेस साथे थे, सेयो चुपचाप रये, कऊँकि तिना खे आवाज तो सुणने लगी री थी, पर कोई दिशो नि था। ");
INSERT INTO bfz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तेबे शाऊल जमीना पाँदा ते उठेया, पर जेबे तिने आखी खोलिया तेबे तेसखे कुछ नि दिशेया। तेबे सेयो तेसरा आथ पकड़ी की तेसखे दमिश्क नगरो खे लयी गे। ");
INSERT INTO bfz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","से तीन दिन तक नि देखी सकेया और ना ई तिने खाया-पिया। ");
INSERT INTO bfz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिश्क नगरो रे हनन्याह नाओं रा एक चेला था, तेसखे प्रभु यीशुए दर्शनो रे बोलेया, “ओ हनन्याह!” तिने बोलेया, “हां प्रभु!” ");
INSERT INTO bfz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तेबे प्रभु यीशुए तेसखे बोलेया, “उठी की तेसा गल़िया रे जा, जेतेखे सीदी बोलोए और यहूदा रे कअरे शाऊल नाओं रे एक तरसुसो रे रणे वाल़े खे पूछी लो; कऊँकि देख, से प्रार्थना लगी रा करने। ");
INSERT INTO bfz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","तिने दर्शणो रे देखेया कि हनन्याह नाओं रे एक मांणूए पीतरे आई की तेस पाँदे आथ राखे ताकि फेर देखणे लगो।” ");
INSERT INTO bfz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याहे बोलेया, “ओ प्रभु! मैं एस मांणूए रे बारे रे बऊत जणेया ते सुणी राखेया कि इने यरूशलेमो रे तेरे पवित्र लोका साथे बडिया-बडिया बुराईया करी राखिया। ");
INSERT INTO bfz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","और एती बी एसखे बड़े पुरोईतो री तरफा ते अक्क मिली रा कि जो लोक तां पाँदे विश्वास करोए, तिना सबी खे बानी की यरूशलेमो खे लयी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पर प्रभुए तेसखे बोलेया, “तूँ चली जा, कऊँकि से तो दूजी जातिया और राजा और इस्राएली लोका सामणे मेरा नाओं रा प्रचार करने खे मेरा चुणे रा जणा ए। ");
INSERT INTO bfz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","और मां तेसखे बताणा कि मेरे नाओं खे तेसखे केड़ा-केड़ा दु:ख उठाणा पड़ना।” ");
INSERT INTO bfz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तेबे हनन्याह उठेया और तेस कअरो रे गया जेती शाऊल था और तेस पाँदे आपणा आथ राखेया और बोलेया, “ओ शाऊल पाई! प्रभु, मतलब-यीशु जो तेसा बाटा रे, जिसिये तूँ आया और ताखे दिशेया था, तिने ई आऊँ पेजी राखेया, ताकि तूँ फेर देखणे लगो और पवित्र आत्मा ते परिपूर्ण ऊई जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","तेबे तेसरी आखी ते छिलके जे निकल़े और से देखणे लगेया और तिने उठी की बपतिस्मा लया, ");
INSERT INTO bfz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","तेबे रोटी खाई की तागत पाई। से कई दिन तक तिना चेलेया साथे रया, जो दमिश्क नगरो रे थे। ");
INSERT INTO bfz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","तेबे से फटाफट दमिश्क नगरो रे प्रार्थना रे कअरो रे प्रभु यीशुए रा प्रचार करने लगेया, “यीशु ई परमेशरो रा पुत्र ए।” ");
INSERT INTO bfz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","तेबे सब सुणने वाल़े हैरान ऊई की बोलणे लगे, “क्या ये सेई मांणू निए, जो यरूशलेमो रे तिना खे जो यीशुए रे विश्वासी थे, नाश करी देओ था और एती बी इजी खे आया था कि तिना खे बानी कि बड़े पुरोईतो गे लयी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पर शाऊल ओर बी सामर्थी ऊँदा गया और एसा गल्ला रा सबूत देई-देई की कि मसीह येईए, दमिश्क नगरो रे रणे वाल़ा यहूदिया रा मूँ बंद करदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","जेबे बऊत दिन बीती गे, तेबे यहूदिये मिली की तेसखे काणे री तरकीब निकयाल़ी। ");
INSERT INTO bfz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","पर तिना री तरकीब शाऊलो खे पता लगी गी। सेयो तो तेसखे काणे री ताका रे रात-दिन फाटको रिये लगे रे रओ थे, ");
INSERT INTO bfz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","पर राथियो खे चेलेया शाऊल टोकरिया रे बठयाल़ेया और शहरपनाहो पाँदा ते लटकाई की उतारी ता। ");
INSERT INTO bfz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","यरूशलेमो रे जाई की तिने चेलेया साथे मिलणे रा उपाय कित्तेया, पर सब तेसते डरो थे, कऊँकि तिना खे विश्वास नि ओ था कि से बी चेला ए। ");
INSERT INTO bfz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","पर बरनबासे से आपू साथे प्रेरिता गे लयी जाई की तिना खे बोलेया कि इने किंयाँ प्रभु यीशु दमिश्क नगरो री बाटा रे देखेया और इने तेस साथे गल्ला कित्तिया और तेबे इने दमिश्को रे बड़ी ई इम्मता साथे प्रभु यीशुए रा प्रचार कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","चेलेया बरनबासो री गल्ला पाँदे विश्वास कित्तेया और शाऊल तिना साथे यरूशलेमो रे आऊँदा-जांदा रया और निडर ऊई की प्रभु यीशुए रे नाओं रा प्रचार करो था। ");
INSERT INTO bfz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","से यूनानी पाषा बोलणे वाल़े यहूदिया साथे गल्ल-बात और बईस करो था। तेबे सेयो तेसखे काणे री कोशिश करने लगे। ");
INSERT INTO bfz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ये जाणी की पाई तेसखे कैसरिया नगरो रे ली आए और तरसुस नगरो खे पेजी ता। ");
INSERT INTO bfz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","तेबे सारे यहूदिया, गलील और सामरिया प्रदेशो री मण्डल़िया खे चैन मिलेया और मण्डल़ी विश्वासो रे बड़दी गई। से प्रभुए रे डरो रे और पवित्र आत्मा री शान्तिया रे चलदी और गिणतिया रे बड़दी गई। ");
INSERT INTO bfz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","तेबे एड़ा ऊआ कि पतरस सबी प्रदेशा रे कुमदा-फिरदा ऊआ तिना पवित्र लोका गे बी पऊँछेया, जो लुद्दा नगरो रे रओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","तेती तेसखे ऐनियास नाओं रा मांणू मिलेया, जेसखे अदरंग था और से आठ साला ते माँजे पाँदे पड़ेया रा रओ था। ");
INSERT INTO bfz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरसे तेसखे बोलेया, “ओ ऐनियास! प्रभु यीशु मसीह ताखे ठीक करोआ, उठ, आपणा बछऊणा बछा। तेबे से फटाफट खड़ा ऊईगा।” ");
INSERT INTO bfz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तेबे लुद्दा और शारोण नगरो रे बऊत सारे रणे वाल़े, तेसखे देखी की प्रभु यीशुए पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा नगरो रे तबीता, मतलब-दोरकास प्रभु यीशुए पाँदे विश्वास करने वाल़ी चेली रओ थी। से बऊत खरे काम और दान करदी रओ थी। ");
INSERT INTO bfz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","तिना दिना रे जेबे पतरस लुद्दा नगरो रे था से बमार ऊई की मरी गी और तिने से नुल़ाई की बाऊड़ी रे राखी ती। ");
INSERT INTO bfz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा याफा रे नेड़े था, चेलेया ये सुणी की कि पतरस तेती ये, दो मांणू पेजी की तेसते बिनती कित्ती कि, “आऊणे रे देर नि कर।” ");
INSERT INTO bfz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तेबे पतरस तिना साथे आईगा और जेबे पऊँछी गा, तेबे सेयो तेसखे तेस बाऊड़ी रे लयी गे और तेती सब बिदुआ रोंदिया उईया तेसगे खड़िया ऊई गिया और जो टाले और कुरते दोरकासे तिना साथे रंदे ऊए बणाए थे, दखाणे लगिया। ");
INSERT INTO bfz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","तेबे पतरसे सब जणियां बारे करी तिया और कुटणे टेकी की प्रार्थना कित्ती और लोथा रे कनारे देखी की बोलेया, “ओ तबीता! उठ।” तेबे तेसे आपणी आखिया खोली तिया और पतरसो खे देखी की उठी की बैठी गी। ");
INSERT INTO bfz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","तिने आथो रा सआरा लगाई की से ठवाल़ी और पवित्र लोका खे और बिदुआ खे बुलाई की से जिऊँदी-जागदी दखाई ती। ");
INSERT INTO bfz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ये गल्ल सारे याफा नगरो रे फैली गी और बऊत जणेया प्रभु यीशुए पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","पतरस याफा नगरो रे शमौन नाओं रे केसी चामड़े रा काम करने वाल़े मांणूए रे कअरे बऊत दिनो तक रया। ");
INSERT INTO bfz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया नगरो रे कुरनेलियुस नाओं रा एक मांणू था, जो इतालियानी नाओं री पल़टणा रा सूबेदार था। ");
INSERT INTO bfz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","से विश्वासी था और आपणे सारे कराने समेत परमेशरो ते डरो था और से यहूदिया रे लोका खे बऊत दान देओ था और हर रोज परमेशरो ते प्रार्थना करो था। ");
INSERT INTO bfz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","तिने दिनो रे तीजे पईरो रे नेड़े दर्शनो रे साफ देखेया कि परमेशरो रा एक स्वर्गदूत तेसगे पीतरे आयी की बोलोआ, “ओ कुरनेलियुस!” ");
INSERT INTO bfz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कुरनेलियुसे से त्यानो साथे देखेया और डरी की बोलेया, “ओ प्रभु! क्या ए?” तिने तेसखे बोलेया, “तेरी प्रार्थना और तेरे दान याद करने खे परमेशरो रे सामणे पऊँछी रे ");
INSERT INTO bfz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","और एबे याफा नगरो रे कोई मांणूआ खे पेजी की शमौनो खे, जेसखे पतरस बोलोए, बुलाई लो। ");
INSERT INTO bfz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","शमौन चामड़े रा काम करने वाल़े रे कअरे पराऊणा ए, जेसरा कअर समुद्रो रे कनारे ए।” ");
INSERT INTO bfz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जेबे से स्वर्गदूत जिने तेस साथे गल्ला कित्तिया थिया, चली गा, तेबे तिने दो दास और जो तेस साथे रओ थे, तिना बीचा ते एक विश्वासी सिपाई बुलाया। ");
INSERT INTO bfz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","तिना खे सारिया गल्ला बताई की सेयो याफा नगरो खे पतरसो खे बुलाणे पेजे। ");
INSERT INTO bfz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दूजे दिने जेबे सेयो चलदे ऊए नगरो रे पऊँछे, तेबे त्याड़िया जे पतरस छतो पाँदे प्रार्थना करने खे चढ़ेया। ");
INSERT INTO bfz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","तेबे तेसखे पूख लगी और से कुछ खाणा चाओ था; पर जेबे सेयो रोटी बनाणे री त्यारी करने लगी रे थे, तदुओ की से बेओश ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","तेबे तिने देखेया कि सर्ग खुली गा और एक बड़ी चादर, पांडे जेड़ी चऊँ कूणे ते लटकी री, तरतिया री तरफा खे उतरने लगी री। ");
INSERT INTO bfz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जिदे तरतिया रे सब प्रकारा रे चऊँ पैरा वाल़े जानवर और रेंगणे वाल़े जन्तु और सर्गो रे पंछी थे। ");
INSERT INTO bfz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","तेबे तेसखे एक शब्द सुणेया, “ओ पतरस उठ और काई की खा।” ");
INSERT INTO bfz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पर पतरसे बोलेया, “ना प्रभु, कदी पनि, कऊँकि मैं कदी बी अपवित्र या अशुद्ध चीज नि खाई।” ");
INSERT INTO bfz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","तेबे दूजी बार तेसखे शब्द सुणेया, “जो कुछ परमेशरे शुद्ध ठराई राखेया, तेसखे अशुद्ध नि बोल।” ");
INSERT INTO bfz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","तीन बार एड़ा ई ऊआ। तेबे फटाफट से पांडा सर्गो खे चकी ता। ");
INSERT INTO bfz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जेबे पतरस आपणे मनो रे दुबिदा रे था कि ये दर्शन जो मैं देखेया क्या ऊई सकोआ? तेबे देखो, सेयो मांणू जो कुरनेलियुसे पेजे थे, शमौनो रे कअरो रा पता लगाई की द्धारो पाँदे आयी की खड़े ऊईगे ");
INSERT INTO bfz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","और आक्का पाई की पूछणे लगे, “क्या शमौन, जेसखे पतरस बोलोए, एथी पराऊणा ए?” ");
INSERT INTO bfz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस तो तेस दर्शनो रे बारे रे सोचणे ई लगी रा था कि पवित्र आत्मे तेसखे बोलेया, “देख तीन मांणू ताखे टोल़ने लगी रे। ");
INSERT INTO bfz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","तो उठ और थाले जा और फटाफट तिना साथे चली जा, कऊँकि मैं ई सेयो पेजी राखे।” ");
INSERT INTO bfz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तेबे पतरसे उतरी की तिना मांणूआ खे बोलेया, “देखो, जेसखे तुसे टोल़ने लगी रे, से आऊँ ईए। तुसा रे आऊणे री क्या बजअ ए?” ");
INSERT INTO bfz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","तिने बोलेया, “कुरनेलियुस सूबेदार, जो तर्मी और परमेशरो ते डरने वाल़ा ए और सारी यहूदी जातिया रे जाणेया-माणेया मांणू ए, तिने एक पवित्र स्वर्गदूतो ते चेतावणी पाई कि ताखे आपणे कअरे बुलाई की तांते वचन सुणो।” ");
INSERT INTO bfz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तेबे तिने सेयो पीतरे बुलाई की तिना री पराऊणचारी कित्ती और दूजे दिने से तिना साथे गया और याफा नगरो रे कुछ विश्वासी पाईया बीचा ते कई जणे तेस साथे चली पड़े। ");
INSERT INTO bfz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","दूजे दिने सेयो कैसरिया नगरो रे पऊँछे और कुरनेलियुस आपणे टब्बरो वाल़ेया साथे और खास दोस्ता साथे कट्ठे ऊई की तिना खे न्याल़ने लगी रा था। ");
INSERT INTO bfz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जेबे पतरस पीतरे आऊणे लगी रा था, तेबे कुरनेलियुस तेसखे मिलेया और तेसरे पैरा पाँदे पड़ी की माथा टेकेया। ");
INSERT INTO bfz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पर पतरसे तेसखे उठाल़ी की बोलेया, “खड़ा ओ, आऊँ बी तो मांणू ए।” ");
INSERT INTO bfz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","तेबे से तेस साथे बातचीत करदा ऊआ पीतरो खे गया। तेबे तिने बऊत सारे लोक कट्ठे देखी की ");
INSERT INTO bfz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","पतरसे तिना खे बोलेया, “तुसे जाणोए कि दुजिया जातिया साथे संगति करना या तेसरे कअरे जाणा, यहूदी नियमा रे खलाफ ए, पर परमेशरे माखे बताई राखेया कि केसी बी मांणूए खे अशुद्ध या अपवित्र नि बोलो। ");
INSERT INTO bfz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","तेबेई तो जेबे आऊँ बुलाया, तेबे बिना कुछ बोले चली की आया। एबे आऊँ पुछूँआ कि आऊँ किजी खे बुलाई राखेया?” ");
INSERT INTO bfz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलियुसे बोलेया, “एसा कअड़िया चार दिन पूरे ऊईगे, आऊँ आपणे कअरे तीजे पईरो रे प्रार्थना करने लगी रा था, तेबे देखो, एक मांणू चमकीले टाले पईनी की मां सामणे आयी की खड़ा ऊईगा ");
INSERT INTO bfz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","और बोलणे लगेया कि, ओ कुरनेलियुस! तेरी प्रार्थना सुणी ली री और तेरे दान परमेशरो रे सामणे याद करी राखे। ");
INSERT INTO bfz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","इजी री खातर केसी खे याफा नगरो रे पेजी की शमौनो खे, जेसखे पतरस बोलोए, तेसखे बुला। से समुद्रो रे कनारे शमौन चामड़े रा काम करने वाल़े रे कअरे पराऊणा ए। तेस आई की तुसा खे परमेशरो रा संदेश सुनाणा। ");
INSERT INTO bfz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तेबे मैं फटाफट तांगे लोक पेजे और तैं खरा कित्तेया जो आईगा। एबे आसे सब परमेशरो सामणे ए, ताकि जो कुछ परमेशरे तांगे बोली राखेया, से सुणिंए।” ");
INSERT INTO bfz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तेबे पतरसे बोलेया, “एबे माखे निश्चा ऊआ कि परमेशर केसी रा पक्षपात नि करदा। ");
INSERT INTO bfz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","बल्कि हर जातिया दे, जो परमेशरो ते डरोआ और तर्मो रे काम करोआ, से तेसखे अच्छा लगोआ। ");
INSERT INTO bfz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","जो वचन तिने इस्राएलिया गे पेजेया, जेबे तिने प्रभु यीशु मसीह रे जरिए (जो सबी रा प्रभु ए) शान्तिया रा सुसमाचार सुणाया। ");
INSERT INTO bfz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","से वचन तुसे जाणोए, जो यूहन्ने रे बपतिस्मे रे प्रचारो ते बाद गलील प्रदेशो ते शुरू उई की यहूदिया प्रदेशो रे बऊत सारी जगा रे फैली गा। ");
INSERT INTO bfz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","परमेशरे किंयाँ प्रभु यीशु नासरी पवित्र आत्मा और सामर्था ते अभिषेक कित्ते। से पलाई करो था और बऊत सारे लोक जो शैतानो रे सताए रे ओ थे, अच्छा करदा फिरेया, कऊँकि परमेशर तेस साथे था। ");
INSERT INTO bfz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“आसे तिना सबी कामो रे गवा ए, जो तिने यहूदिया प्रदेशो रे और यरूशलेमो रे बी कित्ते और यहूदी अगुवे से यरूशलेमो रे क्रूसो पाँदे लटकाई की काई ता। ");
INSERT INTO bfz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","पर से परमेशरे तीजे दिने जिऊँदा कित्तेया और प्रगट बी करी ता। ");
INSERT INTO bfz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सबी लोका खे नि, बल्कि तिना गवाओ पाँदे, जो परमेशरे पइले ई चुणी ले थे, मतलब-आसा पाँदे, जिने तेसरे मरने और जिऊँदे ऊणे ते बाद तेस साथे खाया-पिया। ");
INSERT INTO bfz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","तिने आसा खे आज्ञा दित्ती कि सबी लोका बीचे प्रचार करो और गवाई देओ कि ये सेई, जो परमेशरे जिऊँदेया रा और मरे रेया रा न्यायी ठराई राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","तेसरी सब भविष्यबक्ता गवाई देओए, ताकि जो कोई तेस पाँदे विश्वास करो, तेसखे तेसरे नाओं ते पापो ते माफी मिलणी।” ");
INSERT INTO bfz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस इना गल्ला खे बोलणे ई लगी रा था कि वचनो रे सबी सुणने वाल़ेया पाँदे पवित्र आत्मा उतरी गा ");
INSERT INTO bfz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","और जितणे खतना करे रे यहूदी विश्वासी पतरसो साथे आए थे, सेयो सब हैरान ऊईगे कि दुजिया जातिया पाँदे बी पवित्र आत्मा रा दान लटी राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","कऊँकि तिने सेयो लग-लग पाषा बोलदे ऊए और परमेशरो री तारीफ करदे ऊए सुणे। ");
INSERT INTO bfz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","तेबे पतरसे बोलेया, “क्या कोई पाणिए खे रोकी सकोआ कि यो बपतिस्मा नि पाओ, जिने आसा जेड़ा परमेशरो री तरफा ते पवित्र आत्मा पाई राखेया?” ");
INSERT INTO bfz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","और पतरसे आज्ञा दित्ती कि तिना खे प्रभु यीशु मसीह रे नाओं ते बपतिस्मा देओ, तेबे तिने तेसते बिनती कित्ती कि तुसे कुछ दिन ओर आसा साथे रओ। तेबे से तिना साथे कुछ दिन ओर रईगा। ");
INSERT INTO bfz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","तेबे प्रेरिते और विश्वासी पाईए जो यहूदिया प्रदेशो रे थे, सुणेया कि दूजिये जातिये बी परमेशरो रा वचन मानी ला रा। ");
INSERT INTO bfz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","जेबे पतरस यरूशलेमो रे आया, तेबे खतना करे रे यहूदी विश्वासी तेस साथे बईस करने लगे ");
INSERT INTO bfz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","और बोलेया, “तैं बिना खतना कराए दूजी जातिया रे कअरे जाई की तिना साथे खाणा बी खाई ला।” ");
INSERT INTO bfz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","तेबे पतरसे तिना खे शुरूओ ते एक-एक करी की सुणाया, ");
INSERT INTO bfz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“आऊँ याफा नगरो रे प्रार्थना करने लगी रा था और बेओश ऊई की एक दर्शन देखेया, कि एक बड़ी चादर, एक पांडे जेड़ी, चऊँ कूणे ते लटकी री सर्गो ते ऊतरी की मांगे आयी। ");
INSERT INTO bfz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","जेबे मैं तिजी पाँदे त्यान कित्तेया, तेबे तिदे तरतिया रे चऊँ पैरा वाल़े जानवर और बणो रे पशु, लूरने वाल़े जन्तु और सर्गो रे पंछी देखे ");
INSERT INTO bfz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","और ये शब्द बी सुणेया, ‘ओ पतरस उठ, मार और खा।’ ");
INSERT INTO bfz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“मैं बोलेया, ‘ना प्रभु! ना, कऊँकि कोई बी अपवित्र या अशुद्ध चीज मैं कदी नि खाई।’ ");
INSERT INTO bfz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","तेबे एतेरे जवाबो रे दूजी बार सर्गो ते शब्द ऊआ, ‘जो कुछ परमेशरे शुद्ध ठराई राखेया, तेसखे अशुद्ध नि बोल।’ ");
INSERT INTO bfz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तीन बार एड़ा ई ऊआ, तेबे सब कुछ सर्गो खे खिंजी ता। ");
INSERT INTO bfz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","और देखो, तेबुई तीन मांणू, जो कैसरिया नगरो ते मांगे पेजी राखे थे, तेस कअरो रे, जेती आसे थे, आयी की खड़े ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तेबे पवित्र आत्मे माखे तिना साथे चुप-चाप जाणे खे बोलेया और यो छे पाई बी मां साथे आईगे और आसे तेस मांणूए रे कअरे गये। ");
INSERT INTO bfz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","तिने आसा गे बताया कि मैं एक स्वर्गदूत आपणे कअरे खड़े रा देखेया, जिने माखे बोलेया कि याफा रे मांणूआ खे पेजी की शमौनो खे, जेसखे पतरस बी बोलोए, बुला। ");
INSERT INTO bfz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","तेस तांगे एड़िया गल्ला बोलणिया, जेते साथे तां और तेरे कराने उद्धार पाणा। ");
INSERT INTO bfz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“जेबे आऊँ तिना साथे गल्ला लगी रा था करने, तेबे पवित्र आत्मा तिना पाँदे तिंयाँ ई आया, जिंयाँ शुरूओ रे पेन्तिकुस्तो रे दिने आसा पाँदे उतरेया था। ");
INSERT INTO bfz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तेबे माखे प्रभुए रा से वचन याद आया, जो तिने बोलेया था, ‘यूहन्ने तो पाणिए साथे बपतिस्मा दित्तेया, पर तुसा पवित्र आत्मा रा बपतिस्मा पाणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","तो जेबे परमेशरे बी तिना खे सेई दान दित्तेया, जो आसा खे प्रभु यीशु मसीह पाँदे विश्वास करने ते मिलेया था, तो आऊँ कुण था, जो परमेशरो खे रोकी सकूँआ?” ");
INSERT INTO bfz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ये सुणी की यहूदी विश्वासी चुप रये और परमेशरो री तारीफ करी की बोलणे लगे, “तेबे तो परमेशरे दुजिया जातिया खे बी अनन्त जीवनो खे बुरे कामा ते मन फिराणे रा मौका देई राखेया।” ");
INSERT INTO bfz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","तेबे जो लोक तेस क्ल़ेशो रे मारे जो स्तिफुनुसो री बजअ ते पड़ेया था, ओरे-पोरे ऊईगे थे, तेबे सेयो कूमदे-फिरदे फीनीके प्रदेश, साईप्रस टापू और अन्ताकिया नगरो रे पऊँछे, पर सेयो यहूदिया ते अलावा केसी ओरी खे परमेशरो रा वचन नि सुणाओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","पर तिना बीचा ते कुछ विश्वासी साईप्रसवासी और कुरेनी थे, जो अन्ताकिया नगरो रे आयी की यूनानिया खे बी प्रभु यीशु मसीह रे सुसमाचारो रिया गल्ला सुणाओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभुए री सामर्थ तिना साथे थी और बऊत सारे दूजिया जातिया रे लोक तिना रे संदेशो पाँदे विश्वास करी की प्रभुए री तरफा खे फिरी गे। ");
INSERT INTO bfz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","जेबे तिना रे बारे रे यरूशलेमो री मण्डल़िया रे सुणने खे मिलेया, तेबे तिने बरनबास अन्ताकिया नगरो खे पेजेया। ");
INSERT INTO bfz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","से तेती पऊँछी की और परमेशरो री कृपा देखी की खुश ऊआ और तिने सबी खे उपदेश दित्तेया कि तन-मन लगाई की प्रभुए साथे चीपटे रे रओ। ");
INSERT INTO bfz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","बरनबास एक खरा मांणू था और पवित्र आत्मा और विश्वासो रे परिपूर्ण था और बऊत सारे लोक प्रभुए रे मिली गे। ");
INSERT INTO bfz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तेबे बरनबास शाऊलो खे टोल़ने तरसुसो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","और जेबे सेयो तेसखे मिले, तो तेसखे अन्ताकिया नगरो रे ली आया। तेबे एड़ा ऊआ कि बरनबास और शाऊल एक साल तक मण्डल़िया साथे मिलदे और बऊत सारे लोका खे यीशुए रा उपदेश देंदे रये और चेलेया खे सबी ते पईले अन्ताकिया नगरो रे मसीह बोलेया। ");
INSERT INTO bfz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","तिना दिना रेई कुछ विश्वासी जो भविष्यबक्ता थे, यरूशलेमो ते अन्ताकिया नगरो खे आए। ");
INSERT INTO bfz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","तिना बीचा ते अगबुस नाओं रे एक भविष्यबक्ते खड़े ऊई की पवित्र आत्मा री प्रेरणा ते ये बताया कि सारी दुनिया रे बऊत बड़ा अकाल़ पड़ना और से अकाल़ क्लौदियुस महाराजे रे बखतो रे पड़ना। ");
INSERT INTO bfz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","चेलेया न्याय कित्तेया कि हर एक आपणिया-आपणिया आऊँदणियां रे मुताबिक, यहूदिया प्रदेशो रे रणे वाल़े विश्वासी पाईया री मतादा खे कुछ पेजो। ");
INSERT INTO bfz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","तिने एड़ा ई कित्तेया और बरनबास और शाऊलो गे बुजुर्ग लोका खे कुछ पैसे पेजी ते। ");
INSERT INTO bfz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","तेस बखते हेरोदेस राजा मण्डल़िया रे कई लोक दु:ख देणे खे पकड़े। ");
INSERT INTO bfz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","तिने यूहन्ने रा पाई याकूब तलवारे की मरवाया। ");
INSERT INTO bfz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जेबे तिने देखेया कि यहूदी लोक इजी ते खुश ओए, तेबे तिने पतरस बी पकड़ी ता। सेयो अखमीरी रोटिया रे त्योआरो रे दिन थे। ");
INSERT INTO bfz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","हेरोदेसे पतरस पकड़ी की जेला रे पायी ता और रखवाल़िया खे चार-चार सिपाईया खे चार पईरे रे राखेया। एड़ी इच्छा ते ताकि तेसखे फसह रे त्योआरो ते बाद लोका सामणे ल्याईए। ");
INSERT INTO bfz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","पतरस जेला रे कई दिना ते बंद था, पर मण्डल़ी तेसरी खातर दिऊआ बाल़ी की परमेशरो ते प्रार्थना लगी री थी करने। ");
INSERT INTO bfz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जेबे हेरोदेस तेसखे लोका सामणे मुकद्दमा चलाणे खे ल्याऊणे वाल़ा था, तो तेसा ई राती पतरस दो जंजीरा साथे बाने रा, दो सिपाईया रे बीचे सऊणे लगी रा था और पईरेदार द्वारो पाँदे जेला री रखवाल़ी लगी रे थे करने। ");
INSERT INTO bfz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","अचाणक प्रभुए रा एक स्वर्गदूत आयी की पतरसो रे नेड़े खड़ा ऊईगा और तेती कोठरिया रे जोति चमकणे लगी और तिने पतरसो री पसलिया रे आथ बाई की से जगाया और बोलेया, “उठ, फटाफट कर।” तेसरे आथो ते जंजीरा खुली की छूटी गिया। ");
INSERT INTO bfz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तेबे स्वर्गदूते तेसखे बोलेया, “लक बान और आपणे बूट पईनी लो।” तिने तेड़ा ई कित्तेया। तेबे स्वर्गदूते तेसखे बोलेया, “आपणे टाले पईनी की मां पीछे आईजा।” ");
INSERT INTO bfz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","से निकल़ी की तेस पीछे आईगा, पर ये नि जाणो था कि जो स्वर्गदूत करने लगी रा, से सच्ची ये, बल्कि ये समजणे लगी रा था कि आऊँ सुपना लगी रा देखणे। ");
INSERT INTO bfz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तेबे सेयो पईले और दूजे पईरे ते निकल़ी की तेस लोए रे फाटको गे पऊँछे, जो नगरो री तरफा खे था। से तिना खे आपू तेई खुली गा और सेयो निकल़ी की एकी गल़िया रिये गये, तदुओ की स्वर्गदूत तेसखे छाडी की चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","तेबे पतरसे ओशा रे आयी की बोलेया, “एबे आऊँ सच जाणी गा रा कि प्रभुए आपणा स्वर्गदूत पेजी की आऊँ हेरोदेसो रे आथो ते छुड़ाई ता और यहूदी अगुवा री सारी उम्मीद तोड़ी ती।” ");
INSERT INTO bfz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ये जाणी की परमेशरे से छुड़ाई ता रा पतरस तेस यूहन्ने री आम्मा मरियमा रे कअरे आया, जेसखे मरकुस बी बोलोए। तेती बऊत सारे विश्वासी कट्ठे ऊई की प्रार्थना करने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","जेबे तिने फाटको री दवारी खटखटाई तेबे रुदे नाओं री एक दासी देखणे आयी। ");
INSERT INTO bfz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पतरसो री आवाज पछयाणी की तेसे खुशिया रे मारे फाटक नि खोलेया, पर पीतरे दौड़ी की गयी और बताया, “पतरस द्वारो पाँदे खड़ी रा।” ");
INSERT INTO bfz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","तिने तेसा खे बोलेया, “तूँ पागल ए?” पर से पक्का ऊई की बोलणे लगी कि से पतरस ईए। तेबे तिने बोलेया, “तेसरा स्वर्गदूत ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","पर पतरस दरवाजा खटखटांदा ई रया। तेबे तिने द्वारी खोली और तेसखे देखी की हैरान ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तेबे तिने तिना खे आथो साथे सारा कित्तेया कि चुप रओ और तिना खे बताया कि प्रभु माखे किंयाँ जेला ते निकयाल़ी की ल्याया और बोलेया, “याकूब और पाईया खे ये गल्ल बताई देणी।” तेबे से निकल़ी की दूजी जगा खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","प्यागा-प्यागा सिपाईया बीचे आल्ला-गोल्ला ऊणे लगेया कि पतरसो रा क्या ऊआ? ");
INSERT INTO bfz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","जेबे हेरोदेसे तेसखे टोल़ने री आज्ञा दित्ती और मिलेया नि, तेबे तिने पईरेदारा री परख करी की तिना खे आज्ञा दित्ती कि तिना खे काई दो। तेबे से यहूदिया प्रदेशो खे छाडी की कैसरिया नगरो रे जाई की कुछ बखतो खे रणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","राजा हेरोदेसे सूर और सैदा नगरो रे लोका ते बऊत नराज था। तेबे सेयो एक मन ऊई की हेरोदेसो गे आए। तिने बलास्तुसो खे, जो राजे रा एक दास था, मनाई की मेल-जोल करना चाया, कऊँकि हेरोदेसो राजे रे देशो ते तिना रे देशो रा पालण-पोषण ओ था। ");
INSERT INTO bfz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ठराए रे दिनो रे हेरोदेस राजवस्त्र पईनी की न्याय आसणो रे बैठेया और तिना खे पाषण देणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","तेबे लोक जोरे की बोलणे लगे, “ये तो मांणूए रा नि, पर परमेशरो रा शब्द ए।” ");
INSERT INTO bfz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","तेसी बखते प्रभुए रे एक स्वर्गदूते तेबुई तेसखे बाई, कऊँकि तिने परमेशरो री महिमा नि कित्ती और तेसरे कीड़े पड़ी गे और कीड़े पड़ने री बजअ ते से मरी गा। ");
INSERT INTO bfz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पर परमेशरो रा वचन लगातार फैलदा गया और विश्वासिया री गिणती बड़दी गई। ");
INSERT INTO bfz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जेबे बरनबास और शाऊल यहूदिया प्रदेशो रे यहूदी विश्वासिया खे मताद करने रा काम पुरा करी चुके, तेबे यूहन्ने खे, जेसखे मरकुस बी बोलोए, साथे लयी की यरूशलेमो ते अन्ताकिया खे वापस ऊए। ");
INSERT INTO bfz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया नगरो री मण्डल़िया रे कई भविष्यबक्ता और उपदेशक थे। जिंयाँ-बरनबास, शमौन जेसरा दूजा नाओं नीगर बी बोलोए, लूकियुस कुरेनी और चौथाई देशो रे राजे हेरोदेसो साथे पल़ेया-बड़ेया रा पाई मनाहेम और शाऊल। ");
INSERT INTO bfz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जेबे सेयो बअरतो साथे प्रभुए री भक्ति करने लगी रे थे, तेबे पवित्र आत्मे बोलेया, “मेरी तंईं बरनबासो खे और शाऊलो खे तेस काम करने खे लग करी देओ, जेतेरी खातर मैं सेयो बुलाई राखे।” ");
INSERT INTO bfz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तेबे तिने बअरत और प्रार्थना करी की और तिना पाँदे आथ राखी की सेयो परमेशरो रा काम करने खे पेजे। ");
INSERT INTO bfz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","तेबे बरनबास और शाऊल पवित्र आत्मा रे पेजे रे अन्ताकिया नगरो ते सिलूकिया नगरो खे गये और तेथा ते जाह्जो रे चढ़ी की साईप्रस टापूए पाँदे सलमीसो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","तेबे तिने सलमीसो रे पऊँछी की परमेशरो रा वचन यहूदिया रे प्रार्थना रे कअरो रे सुणाया और यूहन्ना मरकुस तिना री मताद करने वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","सेयो तेस सारे टापूओ रिये ऊँदे ऊए पाफुस नगरो तक पऊँछे। तेती तिना खे बारयीशु नाओं रा एक यहूदी जादू-टोणे वाल़ा और चूठा भविष्यबक्ता मिलेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","से हाकिम, सिरगियुस पौलुसो साथे था। सिरगियुस पौलुस अक्लमंद मांणू था। तिने बरनबास और शाऊलो खे आपू गे बुलाई की परमेशरो रा वचन सुणना चाया। ");
INSERT INTO bfz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पर एलिमास जादू करने वाल़े, कऊँकि येई तेसरे नाओं रा मतलब ए, तिना रा बिरोद करी की हाकिमो खे यीशुए पाँदे विश्वास करने ते रोकणा चाओ था। ");
INSERT INTO bfz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तेबे शाऊले, जेसरा नाओं पौलुस बी ए, तिने पवित्र आत्मा ते परिपूर्ण ऊई की एलिमास जादूगरो री तरफा खे एक टक लगाई की देखेया और बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ओ सारे कपट और ऊशयारिया ते परे रे शैतानो री ल्वाद! सकल तर्मो रे बैरी, क्या तां प्रभुए री सीदी बाट, टेडी करने ते नि छाडणी? ");
INSERT INTO bfz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","एबे देख, प्रभुए री सजा ताखे मिलणी और तूँ कुछ बखतो तक अन्दा रणा और सूरज नि देखणा।” तेबे तेबुई चाल़ा-माल़ा और न्हेरा तेस पाँदे छाईगा और से ओरे-पोरे टटोल़ने लगेया, ताकि कोई तेसरा आथ पकड़ी की लयी चलो। ");
INSERT INTO bfz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तेबे हाकिमे जो कुछ ऊई रा था, से देखी की और प्रभुए रे उपदेशो ते हैरान ऊई की प्रभु यीशुए पाँदे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौलुस और तेसरे साथी पाफुस नगरो ते जाह्ज खोली की पंफूलिया प्रदेशो रे पिरगा नगरो रे आए। तेबे यूहन्ना मरकुस तिना खे छाडी की यरूशलेमो खे वापस ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","तेबे सेयो पिरगा नगरो ते आगे पऊँछी की पिसिदिया प्रदेशो रे अन्ताकिया नगरो रे पऊँछे और आरामो रे दिने प्रार्थना रे कअरो रे जाई की बैठीगे। ");
INSERT INTO bfz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","मूसे रा बिधान और भविष्यबक्तेया री कताब पढ़ने ते बाद, प्रार्थना रे कअरो रे सरदारे तिना खे सन्देशा पेजेया, “ओ पाईयो! जे लोका री बढ़ोतरिया री खातर तुसा रे मनो रे कुछ गल्ल आए तो बोलो।” ");
INSERT INTO bfz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तेबे पौलुसे खड़े ऊई की आथो साथे साअरा करी की बोलेया, “ओ इस्राएलियो! और परमेशरो ते डरने वाल़ेयो, सुणो। ");
INSERT INTO bfz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इना इस्राएलिया रे लोका रे परमेशरे आसा रे बाप-दादे चुणी ले और जेबे सेयो मिस्र देशो रे परदेशी ऊई की रओ थे, तेबे तिना री तरक्की कित्ती और बऊत बड़ी सामर्था साथे निकयाल़ी की ली आया। ");
INSERT INTO bfz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","एथो तक सेयो परमेशरो री आज्ञा खे तोड़दे रये तेबे बी परमेशर तिना खे कोई चाल़ी साल तक सुनसाण जगा रे तिना खे सईन करदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","“तिने कनान देशो रे सात जातिया रा नाश करी की तिना री जमीन आपणे लोका रे कब्जे रे करी ती। ");
INSERT INTO bfz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","एते सारे कामो रे तकरीबन कोई साडे चार सौ साल लगे। इजी ते बाद परमेशरे तिना खे शमुएल भविष्यबक्ता रे आऊणे तक तिना रे न्यायी ठराए। ");
INSERT INTO bfz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","जेबे शमूएल एबु बी तिना रा अगुवा था तेबे इस्राएली लोके आपू खे एक राजा मांगेया। तेबे परमेशरे चाल़ी साला खे बिन्यामीनो रे गोत्रा बीचा ते एक मांणूए खे, मतलब-कीशो रा पाऊ शाऊल, तिना रा राजा बणाया। ");
INSERT INTO bfz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","तेबे परमेशरे शाऊलो खे राजे रे पदो ते टाई की तेसरी जगा पाँदे दाऊदो खे इस्राएलिया रा राजा बणाया। जेसरे बारे रे तिने गवाई दित्ती कि माखे यिशै रा पाऊ दाऊद, मेरे मनो रे मुताबिक मिली गा रा, तेस ई मेरी सारी इच्छा पूरी करनी। ");
INSERT INTO bfz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“इजी रेई वंशो बीचा ते परमेशरे आपणे वादे रे मुताबिक, इस्राएलो गे एक उद्धारकर्ता, मतलब-प्रभु यीशुए खे पेजेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","जेसरे आऊणे ते पईले यूहन्ने सबी इस्राएलिया खे मन फिराणे रे बपतिस्मे रा प्रचार कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जेबे यूहन्ना आपणी सेवा पूरी करने वाल़ा था, तेबे तिने बोलेया कि तुसे माखे क्या बोलोए? आऊँ मसीह निए, पर देखो, जो मांते बाद एक आऊणे वाल़ा ए, से मांते इतणा महान् ए, आँऊ तेसरे पैरो रे जोड़े रे फिथे खोलणे जोगा बी निए। ");
INSERT INTO bfz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ओ पाईयो! तुसे जो अब्राहमो री ल्वाद ए और तुसे जो परमेशरो ते डरोए, तुसा गे एतेरे उद्धारो रा वचन पेजे राए। ");
INSERT INTO bfz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरूशलेमो रे रणे वाल़े और तिना रे अधिकारिए, ना यीशु पछयाणा और ना भविष्यबक्ते रिया गल्ला समजिया, जो हर आरामो रे दिने पड़ी जाओई। तेबेई से दोषी ठराई की सेयो गल्ला पुरिया कित्तिया। ");
INSERT INTO bfz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","तिने काणे जोगा तेसरे कोई दोष नि देखेया, तेबे बी पिलातुसे बिनती कित्ती कि से काया जाओ। ");
INSERT INTO bfz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","जेबे तिने तेसरे बारे रे पवित्र शास्त्रो रे लिखी रिया सारिया गल्ला पुरिया कित्तिया। तिने से क्रूसो पाँदे लटकाई की काई ता और तेबे क्रूसो पाँदे ते उतारी की कब्रा रे राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पर परमेशरे से मरे रेया बीचा ते जिऊँदा कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","और से तिना खे जो तेस साथे गलील प्रदेशो ते यरूशलेमो खे आए थे, बऊत दिनो तक आपणे चेलेया खे दिशदा रया। लोका सामणे एबे सेयो ई तेसरे गवा ए। ");
INSERT INTO bfz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“आसे बी तुसा खे तेस वादे रे बारे दे, जो परमेशरे बाप-दादेया साथे कित्तेया था, ये सुसमाचार सुणाऊँए। ");
INSERT INTO bfz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","कि परमेशरे यीशुए खे मरे रेया बीचा ते जिऊँदा करी की सेई वादा आसा री ल्वादा खे पूरा कित्तेया, जेड़ा भजनसंहिता रे दूजे पजनो रे परमेशरे मसीह रे बारे बोली राखेया कि “तूँ मेरा पुत्र ए, आज मैं ई तूँ पैदा करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“और तेसरे ईंयां मरे रेया बीचा ते जिऊँदे ऊणे रे बारे रे बी कि से कदी नि सड़ो, परमेशरे ये बोली राखेया मां दाऊदो पाँदलिया पवित्र और अटल कृपा तुसा पाँदे करनिया। ");
INSERT INTO bfz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","तेबेई तो दाऊदे एकी ओरी पजनो रे बी बोली राखेया कि “तां आपणा पवित्र जन सड़ने नि देणा। ");
INSERT INTO bfz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“कऊँकि दाऊद तो परमेशरो री इच्छा रे मुताबिक आपणे बखतो री सेवा पूरी करी की मरी गा और आपणे बाप-दादेया साथे जाई की मिली गा और सड़ी बी गया। इजी रे जरिए आसे जाणूंए कि दाऊदे ये गल्ला आपणे बारे रे नि बोली राखिया। ");
INSERT INTO bfz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पर ये गल्ला यीशुए रे बारे रे बोली राखिया थिया जो परमेशरे मरे रेया बीचा ते जिऊँदा करी राखेया, से सड़ेया नि। ");
INSERT INTO bfz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“इजी री खातर, ओ पाईयो! तुसे जाणी लो कि एसरी ई बजअ ते पापो री माफिया रा सुसमाचार तुसा खे दित्तेया जाओआ ");
INSERT INTO bfz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","और जिना गल्ला साथे तुसे मूसे रिया बिधानो रे जरिए निर्दोष नि ठईरी सको थे, तिना सबी ते हर एक विश्वास करने वाल़ा, यीशुए री बजअ ते निर्दोष ठईरोआ। ");
INSERT INTO bfz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","तेबेई तो चौकस रओ, एड़ा नि ओ कि जो भविष्यबक्ता री कताबा रे लिखी राखेया, ");
INSERT INTO bfz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","तुसा पाँदे बी आओ कि, “ओ निन्दा करने वाल़े देखो और हैरान ओ और खत्म ऊई जाओ, कऊँकि आऊँ तुसा रे दिनो रे एक काम करूँआ, एड़ा काम कि जे कोई तुसा ते तिजी रे बारे रे पूछो, तो तुसा कदी विश्वास नि करना।” ");
INSERT INTO bfz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","पौलुस और बरनबासो रे प्रार्थना रे कअरो ते बारे निकल़दे बखते लोक तिना ते बिनती करने लगे कि आगले आरामो रे दिने तुसे आसा खे फेर इना गल्ला खे सुणाओ। ");
INSERT INTO bfz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","जेबे प्रार्थना रे कअरो रे लोक उठी गे, तेबे यहूदी और तिना रे मतो रे आए रे भक्ता बीचा ते बऊत पौलुस और बरनबासो पीछे आईगे और तिने तिना साथे गल्ला करी की सेयो समजयाए कि परमेशरो री कृपा रे बणे रे रओ। ");
INSERT INTO bfz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","आगले आरामो रे दिने नगरो रे तकरीबन सारे लोक परमेशरो रा वचन सुणने खे कट्ठे ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","पर यहूदी अगुवे पीड़ा खे देखी की जल़ना साथे परी गे और निन्दा करदे ऊए पौलुसो री गल्ला रे बिरोदो रे बोलणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तेबे पौलुस और बरनबासे निडर ऊई की बोलेया, “जरूरी था कि पईले तुसा खे परमेशरो रा वचन सुणाया जांदा। पर जबकि तुसे लोके से नकारिता और आपू खे अनन्त जीवनो जोगा बणाओए, तो देखो, आसे दुजिया जातिया खे परमेशरो रा वचन सुनाणे खे जाऊँए। ");
INSERT INTO bfz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","कऊँकि प्रभुए आसा खे ये आज्ञा देई राखी कि “मैं तूँ दुजिया जातिया खे जोति ठराई राखेया; ताकि तुसा रे जरिए सारी तरतिया पाँदे उद्धार ल्याया जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ये सुणी की दूजी जाति खुश ऊई और परमेशरो रे वचनो री तारीफ करने लगे और जितणे अनन्त जीवनो खे बणाई राखे थे, तिने विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","तेबे प्रभुए रा वचन तेस सारे देशो रे फैलणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","पर यहूदिया रे अगुवे भक्त और तर्मी जवाणसा और नगरो रे खास लोक उकसाए और पौलुस और बरनबासो पाँदे उपद्रव करवाई की सेयो आपणे इलाके ते निकयाल़ी ते। ");
INSERT INTO bfz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","तेबे पौलुस और बरनबास तिना सामणे आपणे पैरा री तूड़ चाड़ी की इकुनियुम नगरो खे चली गे ");
INSERT INTO bfz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","और अन्ताकिया नगरो रे चेले खुशिया साथे और पवित्र आत्मा ते परिपूर्ण ऊँदे गये। ");
INSERT INTO bfz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनियुम नगरो रे एड़ा ऊआ कि पौलुस और बरनबास यहूदिया रे प्रार्थना रे कअरो रे साथे गये और एड़िया गल्ला कित्तिया कि यहूदी और यूनानिया बीचा ते कई जणे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पर ना मानणे वाल़े यहूदिये दुजिया जातिया रे मन विश्वासी पाईया रे खलाफ उकसाए और फूट पैदा करी ती। ");
INSERT INTO bfz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","पौलुस और बरनबास बऊत दिनो तक तेती रये और प्रभुए पाँदे विश्वास करी की इम्मता साथे गल्ला करो थे और से तिना रे आथो साथे चिह्न और अचम्बे रे काम करवाओ था और आपणी कृपा रे वचनो पाँदे गवाई देओ था। ");
INSERT INTO bfz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पर इलाके रे लोका बीचे फूट पड़ी गी थी और तेबे कुछ लोक यहूदिया रे कनारे और कुछ प्रेरिता री तरफा खे ऊईगे थे। ");
INSERT INTO bfz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","जेबे दूजी जाति और यहूदी तिना रा मजाक करने और तिना खे पत्थराव करने खे आपणे अधिकारिया समेत तिना पाँदे दौड़े, ");
INSERT INTO bfz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","तेबे तिना खे एसा गल्ला रा पता लगी गा और सेयो लूकाउनिया प्रदेशो रे लुस्त्रा और दिरबे रे नगरो रे और ओरे-पोरे रे प्रदेशो रे नठीगे ");
INSERT INTO bfz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","और तेती जाई की सुसमाचार सुनाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्त्रा नगरो रे एक मांणू था बैठे रा, जो पैरा ते कमजोर था। से जन्मो तेई लंगड़ा था और कदी पनि चली रा था। ");
INSERT INTO bfz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","से पौलुसो खे गल्ला करदे ऊए सुणने लगी रा था और तिने एक टक लगाई की देखेया कि एसखे ठीक ऊणे रा विश्वास ए ");
INSERT INTO bfz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","और जोरे की बोलेया, “आपणे पैरा रे पारे सीदा खड़ा ऊई जा।” तेबे से उटकी की चलणे-फिरने लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","लोके पौलुसो पाँदे विश्वास करी की लूकाउनिया पाषा रे जोरे की बोलेया, “देवता आसा गे उतरी की आईगे रे।” ");
INSERT INTO bfz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","तेबे तिने बरनबासो खे यूनानी देवते रा नाओं पाँदे ज्यूस और पौलुसो खे हिरमेस बोलेया, कऊँकि ये संदेश करने रे खास था। ");
INSERT INTO bfz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ज्यूस तेस मन्दरो रा पुजारी था, जो तेसरे नगरो ते सामणे था। बेल और फूला रे आर फाटका पाँदे लगाई की लोका साथे बलिदान करना चाओ था। ");
INSERT INTO bfz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पर बरनबास और पौलुस प्रेरिते जेबे सुणेया, तो तेबे तिने आपणे टाले फाड़े और पीड़ा रे लमखणे लगे और आक्का पाई की बोलणे लगे, ");
INSERT INTO bfz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ओ लोको! तुसे क्या लगी रे करने? आसे बी तो तुसा जेड़े दु:ख-सुख पोगणे वाल़े मांणू ए और तुसा खे सुसमाचार सुणाऊँए कि तुसे इना बेकारा रिया चीजा ते लग ऊई की जिऊँदे परमेशरो री तरफा खे फिरो, जिने स्वर्ग, तरती, समुद्र और जो कुछ तिना रे आए, से बणाया। ");
INSERT INTO bfz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","तिने बीते रे बखतो रे सब जातिया आपणी-आपणी बाटा रे चलणे दित्तिया। ");
INSERT INTO bfz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","तेबे बी तिने आपणे आपू खे बिना गवाओ ते नि छाडेया, पर से पला करदा रया और सर्गो ते बर्खा और फल़दार ऋतु देई की तुसा रे मनो खे रोटी और खुशिया ते परदा रया।” ");
INSERT INTO bfz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ये बोली की बी तिने लोक बडिया मुश्किला ते रोके कि तिना खे बलिदान नि करो। ");
INSERT INTO bfz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","पर कुछ यहूदिये अन्ताकिया और इकुनियुम नगरो ते आयी की लोक आपणी तरफा खे करी ते और पौलुसो खे पात्थर बाए और तेसखे मरे रा समजी की नगरो ते बारे कसिटी की लयी गे। ");
INSERT INTO bfz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पर जेबे चेले आईकि तेसरे चऊँ कनारे खड़े ऊईगे, तेबे से उठी की नगरो खे चली गा और दूजे दिने बरनबासो साथे दिरबे खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","तेबे पौलुस और बरनबास तेस नगरो रे लोका खे सुसमाचार सुणाई की और बऊत सारे चेले बणाई की लुस्त्रा और इकुनियुमो रे ऊँदे ऊए अन्ताकिया नगरो खे वापस ऊईगे ");
INSERT INTO bfz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","और सेयो हर नगरो रे चेलेया रे मनो खे स्थिर (पक्का) करदे रये और ये उपदेश देंदे रओ थे कि विश्वासो रे बणे रे रओ और ये बोलदे रओ थे, “आसा खे बड़े क्ल़ेश उठाई की परमेशरो रे राज्य रे जाणा पड़ना” ");
INSERT INTO bfz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","और तिने हर एक मण्डल़िया रे तिना खे बुजुर्ग ठईराए और बअरतो साथे प्रार्थना करी की सेयो प्रभुए रे आथो रे सम्बाल़ी ते, जेस पाँदे तिने विश्वास कित्तेया था। ");
INSERT INTO bfz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","तेबे सेयो पिसिदिया प्रदेशो रे ऊँदे ऊए पंफूलिया प्रदेशो रे पऊँछे। ");
INSERT INTO bfz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","तेबे पंफूलिया प्रदेशो रे पिरगा नगरो रे वचन सुणाई की अत्तलिया नगरो रे आए ");
INSERT INTO bfz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","और तेथा ते सेयो जाह्जो रे अन्ताकिया नगरो रे आए, जेथा ते तिना खे परमेशरो री कृपा रे सम्बाल़ी की तेस कामो खे पेजेया था जेतेखे सेयो एबे पूरा करी की वापस आईगे। ");
INSERT INTO bfz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","तेती पऊँछी की तिने मण्डल़ी कट्ठी कित्ती और तिना खे बताया कि परमेशरे आसा साथे रई की कितणे बड़े-बड़े काम कित्ते और दुजिया जातिया खे विश्वासो रा दरवाजा खोली ता। ");
INSERT INTO bfz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","पौलुस और बरनबास चेलेया साथे बऊत दिन तक रये। ");
INSERT INTO bfz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","तेबे कुछ यहूदी विश्वासी यहूदिया प्रदेशो ते अन्ताकिया नगरो रे आयी की विश्वासी पाईया खे सखयाणे लगे, “जे मूसे री रवाजा रे मुताबिक तुसा रा खतना नि ओ तो तुसे उद्धार नि पाई सकदे।” ");
INSERT INTO bfz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","जेबे पौलुस और बरनबासो रा तिना साथे बऊत चगड़ा और बईस ऊई तो कलीसिये ये फैंसला लया कि पौलुस और बरनबासो खे कुछ ओर माणूंआ साथे एसा गल्ला रे बारे रे सोचणे खे यरूशलेम नगरो रे प्रेरिता और बुजुर्गा गे पेजो। ");
INSERT INTO bfz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","तेबे मण्डल़िए सेयो थोड़ी जी दूर तक पऊँछाए और सेयो फीनीके और सामरिया प्रदेशो ते ऊँदे ऊए दुजिया जातिया रे मन फिराणे रा समाचार सुणांदे गये और सब विश्वासी पाई खुश कित्ते। ");
INSERT INTO bfz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जेबे सेयो यरूशलेमो रे पऊँछे, तेबे मण्डल़ी, प्रेरित और बुजुर्ग तिना साथे खुश ऊई की मिले और पौलुस और बरनबासे बताया कि परमेशरे आसा साथे रंदे ऊए केड़े-केड़े काम कित्ते थे। ");
INSERT INTO bfz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पर फरीसिया रे पंथो बीचा ते जिने विश्वास कित्तेया था, तिना बीचा ते कई जणे उठी की बोलेया, “दूजी जातिया खे खतना कराणा और मूसे रे बिधानो खे मानणे री आज्ञा देणी चाईयो।” ");
INSERT INTO bfz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तेबे प्रेरित और बुजुर्ग एसा गल्ला रे बारे रे विचार करने खे कट्ठे ऊए। ");
INSERT INTO bfz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","तेबे पतरसे बऊत बईस ऊणे ते बाद खड़े ऊई की तिना खे बोलेया, “ओ पाईयो! तुसे जाणोए कि बऊत दिन ऊईगे कि परमेशरे तुसा बीचा ते आऊँ चुणी ला रा, ताकि दूजी जाति मेरे मुंओ ते सुसमाचारो रा वचन सुणी की विश्वास करो। ");
INSERT INTO bfz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","मनो खे परखणे वाल़े परमेशरे तिना खे बी आसा जेड़ा पवित्र आत्मा देई की तिना री गवाई दित्ती ");
INSERT INTO bfz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","और विश्वासो रे जरिए तिना रे मन शुद्ध करी की आसा रे और तिना रे कोई फर्क नि राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","तो एबे तुसे कऊँ परमेशरो री परीक्षा करोए की चेलेया री क्याड़िया (गरदन) पाँदे एड़ा जूँगड़ा राखो, जेतेखे ना म्हारे बापदादे चकी सको थे और ना आसे चकी सकदे? ");
INSERT INTO bfz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","पर आ, आसा रा ये तो निश्चा ए कि जिंयाँ तिना प्रभु यीशुए री कृपा ते उद्धार पाणा, तिंयाँ ई आसा बी पाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तेबे सारी सभा चुप-चाप ऊई की बरनबास और पौलुसो री सुणने लगी कि परमेशरे तिना रे जरिए दुजिया जातिया बीचे केड़े-केड़े चिह्न् और अचम्बे रे काम दखाए। ");
INSERT INTO bfz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","जेबे बरनबासे और पौलुसे आपणा पाषण देणा बन्द कित्तेया, तेबे याकूब बोलणे लगेया, “ओ पाईयो, मेरी सुणो। ");
INSERT INTO bfz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","शमौन पतरसे बताया कि परमेशरे पईले-पईले दुजिया जातिया पाँदे केड़ी कृपा दृष्टि कित्ती कि तिना बीचा ते आपणे नाओं खे एक प्रजा बणाई लो। ");
INSERT INTO bfz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","इजी साथे भविष्यबक्ते रिया गल्ला बी मिलोईया, जेड़ा लिखी राखेया, ");
INSERT INTO bfz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“इजी ते बाद मां फेर आयी की दाऊदो रा टल़े रा डेरा चकणा और तिजी रे खंडहर फेर बनाणे और से खड़ा करना। ");
INSERT INTO bfz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ताकि बाकि मांणू, मतलब-सब दुजिया जातिया, जो मेरे नाओं ते जाणे जाओए, प्रभुए खे टोल़ो। ");
INSERT INTO bfz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ये सेई प्रभु बोलोआ, जो दुनिया री सृष्टिया ते इना गल्ला रा समाचार देंदा आयी रा। ");
INSERT INTO bfz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“तेबे मेरा बिचार ये कि दुजिया जातिया बीचा ते जो लोक परमेशरो री तरफा खे फिरोए, आसे तिना खे दु:ख नि देईए। ");
INSERT INTO bfz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पर तिना खे लिखी की पेजिये कि सेयो मूर्तिया री अशुद्धात्मा, व्याभिचार और गल़ा कोटे रे मासो ते और खूनो ते दूर रओ। ");
INSERT INTO bfz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","कऊँकि पुराणे बखतो ते नगरो-नगरो रे मूसा रे बिधानो रा प्रचार करने वाल़े चलदे आयी रे और से हर आरामो रे दिने प्रार्थना रे कअरो रे पढ़ी जाओई।” ");
INSERT INTO bfz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तेबे यरूशलेमो री सारी मण्डल़िया समेत प्रेरिता और बुजुर्गा खे अच्छा लगेया कि आपू बीचा ते कई मांणूआ खे चुणो, मतलब-यहूदा, जेसखे बरसब्बास बी बोलोए, सीलास जो विश्वासी पाईया रा मुखिया था, तिना खे पौलुस और बरनबासो साथे अन्ताकिया री कलीसिया खे पेजो। ");
INSERT INTO bfz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","तिने तिना रे आथो रे ये लिखी की पेजेया, “अन्ताकिया नगर, सीरिया और किलिकिया प्रदेशो रे रणे वाल़े सब विश्वासी पाईया खे जो दुजिया जातिया बीचा ते ए, प्रेरित और बुजुर्ग पाईया री नमस्ते। ");
INSERT INTO bfz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","आसे सुणी राखेया कि आसा बीचा ते कई जणेया तेती जाई की तुसे आपणी गल्ला ते कबराईते और तुसा रे मन पल़्टी ते रे, पर आसे तिना खे आज्ञा नि दित्ती थी। ");
INSERT INTO bfz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","इजी री खातर आसे एक चित्त ऊई की ठीक समजेया कि चुणे रे मांणूआ खे आपणे प्यारे बरनबास और पौलुसो साथे तुसा गे पेजिये। ");
INSERT INTO bfz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ये तो एड़े मांणू ए, जिने आपणे प्राण आसा रे प्रभु यीशु मसीह री खातर मुसीबता रे पाई राखे ");
INSERT INTO bfz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","और आसे यहूदा और सीलास पेजी राखे, जिना आपणे मुंओ ते बी यो गल्ला बोली देणियां। ");
INSERT INTO bfz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पवित्र आत्मा और आसा खे ठीक लगेया कि इना जरूरी गल्ला खे छाडी की तुसा पाँदे ओर बोज नि पाऊँ ");
INSERT INTO bfz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","कि तुसे मूर्तिया रे सामणे बलि कित्ते रे और खूनो ते, गल़ा कोटे रे मासो ते और व्याभिचारो ते दूर रओ, तो तुसा रा पला ऊणा और शुभ।” ");
INSERT INTO bfz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","तेबे, सेयो विदा ऊई की अन्ताकिया नगर रे पऊँछे और सभा कट्ठी करी की से पत्री तिना खे देईती। ");
INSERT INTO bfz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","सेयो पत्री पढ़ी की तेस उपदेशो री गल्ला ते बऊत ई जादा खुश ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","तेबे यहूदा और सीलासे, जो आपू बी भविष्यबक्ता थे, बऊत गल्ला साथे विश्वासी पाईया खे उपदेश देई की मजबूत कित्ते। ");
INSERT INTO bfz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","यहूदा और सीलास कुछ दिन रई कि विश्वासी पाईया ते शान्तिया साथे बिदा ऊए कि आपणे पेजणे वाल़ेया गे यरूशलेमो खे जाओ। ");
INSERT INTO bfz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","पर सीलासे अन्ताकिया रेई रणे रा निश्चा कित्तेया और यहूदा कल्ला ई यरूशलेमो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पौलुस और बरनबास अन्ताकिया रेई रई गे और बऊत ओर लोका साथे प्रभु यीशुए रा वचन और सुसमाचार सुणांदे रये। ");
INSERT INTO bfz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","कुछ दिनो ते बाद पौलुसे बरनबासो खे बोलेया, “जेती-जेती नगरो रे आसे प्रभुए रा सुसमाचार सुणाया था, आओ, फेर चली की आपणे विश्वासी पाईया खे देखूँए कि केड़े ए।” ");
INSERT INTO bfz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तेबे बरनबासे यूहन्ने खे, जेसखे मरकुस बी बोलोए, साथे लणे रा बिचार कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पर पौलुसे तेसखे, जो पंफूलिया प्रदेशो रे लग ऊईगा था और कामो खे तिना साथे नि गया, तेसखे साथे निणा अच्छा नि समजेया। ");
INSERT INTO bfz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","तेबे एड़ी बईस ऊई कि पौलुस और बरनबास एकी-दूजे ते लग ऊईगे और बरनबास मरकुसो खे लयी की जाह्जो रे साईप्रस टापूए खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पर पौलुसे सीलास चुणेया और विश्वासी पाईया खे परमेशरो री कृपा रे देई की तेथा ते चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","से मण्डल़िया खे मजबूत करदा ऊआ, सीरिया और किलिकिया प्रदेशो रिये ऊँदे ऊए गया। ");
INSERT INTO bfz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","तेबे से दिरबे और लुस्त्रा नगरो रे बी गया, और देखो, तेती तीमुथियुस नाओं रा एक चेला था, जो केसी विश्वासी यहूदिणिया रा पाऊ था, पर तेसरा पिता यूनान देशो रा रणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","से लुस्त्रा और इकुनियुम नगरो रे विश्वासी पाईया बीचे जाणेया-मानेया रा था। ");
INSERT INTO bfz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुसो री इच्छा थी की ये बी मां साथे चलो और जो यहूदी लोक तिना जगा रे थे तिना री बजअ ते तेसरा खतना कित्तेया, कऊँकि सेयो सब जाणो थे कि एसरा पिता यूनान देशो रा रणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","तेबे पौलुस और तिना रे साथी नगरो-नगरो रे जांदे ऊए तिना बिधिया खे, जो यरूशलेमो रे प्रेरिते और बुजुर्गे ठराई राखी थी, मानणे खे तिना खे पऊँछांदे जाओ थे। ");
INSERT INTO bfz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ईंयां मण्डल़ी विश्वासो रे मजबूत ऊँदी रई और गिणतिया रे हर रोज बड़दी गयी। ");
INSERT INTO bfz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","तेबे सेयो फूगिया और गलातिया रे प्रदेशो रिये ऊँदे ऊए गये और पवित्र आत्मे तिना खे आसिया प्रदेशो रे वचन सुनाणे खे ना कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","तेबे तिने मूसिया प्रदेशो रे नेड़े पऊँछी की बितूनिया नगरो खे जाणा चाया, पर प्रभु यीशुए रे पवित्र आत्मे सेयो जाणे नि दित्ते। ");
INSERT INTO bfz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","तेबे सेयो मूसिया प्रदेशो रे ऊई की त्रोआसो नगरो खे आए। ");
INSERT INTO bfz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","तेबे पौलुसे राथियो खे दर्शन देखेया कि एक मकदुनी मर्द खड़े रा, तेसते बिनती करी की बोलोआ, “पार उतरी की मकिदुनिया खे आओ और आसा री मताद कर।” ");
INSERT INTO bfz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","तेसरा ये दर्शन देखदे ई तिने फटाफट मकिदुनिया प्रदेशो खे जाणा चाया, ये समजी की कि परमेशरे सेयो सुसमाचार सुनाणे खे तेती बुलाई राखे। ");
INSERT INTO bfz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","तेबे त्रोआसो नगरो ते जाह्ज खोली की आसे सीदे सुमात्राके टापूए खे और दूजे दिने नियापुलिस नगरो खे आए। ");
INSERT INTO bfz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","तेथा ते आसे फिलिप्पिया रे पऊँछे, जो मकिदुनिया प्रान्तो रा खास नगर और रोमिया री बस्ती थी और आसे तेस नगरो रे कई दिन तक रये। ");
INSERT INTO bfz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","आरामो रे दिने आसे नगरो रे फाटको ते बारे नदिया रे कनारे ये समजी की गये कि तेती प्रार्थना करने खे जगा ऊणी और बैठी की तिना जवाणसा साथे, जो कट्ठिया ऊईया थिया, गल्ला करने लगे। ");
INSERT INTO bfz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","लुदिया नाओं री थुआतीरा नगरो री, बैंगणी टाले बेचणे वाल़ी परमेशरो री एक भक्त जवाणस सुणने लगी री थी और प्रभुए तेसा रा मन खोलेया, ताकि से पौलुसो री गल्ला खे त्यान करी की सुणो। ");
INSERT INTO bfz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","जेबे तेसे आपणे कराने समेत बपतिस्मा लया, तेबे तेसे बिनती कित्ती, “जे तुसे माखे प्रभुए री विश्वासणी समजोए तो चली की मेरे कअरे रओ।” ");
INSERT INTO bfz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","जेबे सेयो प्रार्थना करने री जगा रे जाणे लगी रे थे, तेबे आसा खे एक दासी मिली, जेसा रे आऊणे वाल़े बखतो रे बारे रे बताणे वाल़ी दुष्टात्मा थी और जो एड़ा करने ते से आपणे स्वामिया खे बऊत कुछ कमाई की ली आओ थी। ");
INSERT INTO bfz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","से पौलुस और आसा पीछे आयी की चींगणे लगी कि, “यो मांणू परमप्रदान परमेशरो रे दास ए, जो आसा खे उद्धारो री कथा सुणाओए।” ");
INSERT INTO bfz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","से बऊत दिन तक एड़ा ई करदी रई। पर पौलुस दु:खी ऊईगा और मूँ फेरी की तेसा दुष्टात्मा खे बोलेया, “आऊँ ताखे प्रभु यीशु मसीह रे नाओं ते आज्ञा देऊँआ कि एसा बीचा ते निकल़ी जा और से तेसी बखते ई निकल़ी गी।” ");
INSERT INTO bfz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जेबे तेसा रे स्वामिए देखेया कि आसा री कमाईया री उम्मीद चली गी, तेबे सेयो पौलुस और सीलासो के पकड़ी की चौको रे प्रदाना गे खिंजी की लयी गे ");
INSERT INTO bfz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","और तिना खे यहूदिया रे हाकिमा गे लयी जाई की बोलेया, “यो लोक जो यहूदी ए, आसा रे नगरो रे बऊत जादा शोर-शराबा लगी रे करने। ");
INSERT INTO bfz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","और एड़िया रवाजा बताणे लगी रे जिना खे ग्रहण करना या मानणा आसा रोमिया खे ठीक निए।” ");
INSERT INTO bfz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तेबे पीड़ा रे लोक पौलुस और सीलासो रे बिरोदो रे कट्ठे ऊई की चढ़ी गे और हाकिमे तिना रे टाले फाड़ी की खोली ते और तिना खे डण्डे बाणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","तेबे तिना खे बऊत डण्डे बाई की सेयो जेला रे पाई ते और जेलरो खे आज्ञा दित्ती कि इना री चौकसी राखणी। ");
INSERT INTO bfz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","तिने एड़ी आज्ञा पाई की सेयो पीतरो री कोठरिया रे राखे और तिना रे पैर काठो रे ठोकी ते। ");
INSERT INTO bfz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","तकरीबन आदी राथियो तक पौलुस और सीलास प्रार्थना करदे ऊए परमेशरो रे पजन लगी रे थे गाणे और बन्दुए तिना खे सुणने लगी रे थे। ");
INSERT INTO bfz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","तदुओ की एकदम बऊत बड़ा इल्लण ऊआ, एथो तक कि जेला री निऊँआ तक इल्ली गिया और फटाफट सब द्वार खुली गे और सबी रे बन्दन खुली गे। ");
INSERT INTO bfz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","तेबे जेलर जागी गा और जेला रे द्वार खुले देखी की समजेया कि बन्दुए नठीगे रे, तेबे तिने तलवार खिंजी की आपू खेई बाणी चायी। ");
INSERT INTO bfz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पर तदुओ कि पौलुसे जोरे की बोलेया, “आपणे आपू खे कुछ बी नुकशाण नि पऊँचा, कऊँकि आसे सब एथी ए।” ");
INSERT INTO bfz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तेबे जेलरे दिऊआ मंगवाई की पीतरो खे लमखणे लगेया और थरथरांदा ऊआ पौलुस और सीलासो रे आगे रूड़ेया। ");
INSERT INTO bfz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","तेबे तिने तिना खे बारे ल्याई की बोलेया, “ओ सज्जनो! उद्धार पाणे खे आऊँ क्या करुँ?” ");
INSERT INTO bfz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","तिने बोलेया, “प्रभु यीशुए पाँदे विश्वास कर, तेबे ताखे और तेरे कराने खे उद्धार मिलणा।” ");
INSERT INTO bfz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","तेबे पौलुस और सिलासे तेसखे और तेसरे सारे कअरो रे लोका खे प्रभुए रा वचन सुणाया। ");
INSERT INTO bfz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","तेबे राथियो खे तेसी कअड़िया रे जेलरे पौलुस और सिलास निए और तिना रे जख्म तोए और तिने आपणे लोका समेत फटाफट बपतिस्मा लया। ");
INSERT INTO bfz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","तेबे तिने सेयो आपणे कअरे निए और तिना खे रोटी खुल़ाई और सारा कराना परमेशरो पाँदे विश्वास करी की खुश ऊआ। ");
INSERT INTO bfz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","जेबे दिन ऊआ, तेबे हाकिमे सिपाईया गे सन्देशा पेजेया, “तिना मांणूआ खे छाडी देओ।” ");
INSERT INTO bfz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","जेलरे यो गल्ला पौलुसो गे बोलिया, “हाकिमे तुसा खे छाडणे खे बोली ता रा, तो एबे निकल़ी की बेफिकर ऊई की चली जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पर पौलुसे तेसखे बोलेया, “तिने आसे, हालाँकि रोमी मांणू ए, दोषो ते बिना, लोका सामणे कुटे और जेला रे पाईते। एबे क्या चोरिए-चोरिए निकयाल़ी देओए? एड़ा नि ऊणा, पर सेयो आपू आयी की आसा खे बारे निकयाल़ी की लयी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाईए ये गल्ल हाकिमा खे बोली ती और सेयो ये सुणी की सेयो कि रोमी ए, डरी गे। ");
INSERT INTO bfz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","तेबे तिने आयी की तिना ते माफी मांगी और बारे लयी जाई की बिनती कित्ती कि नगरो ते बारे चली जाओ। ");
INSERT INTO bfz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","तेबे सेयो जेला ते निकल़ी की लुदिया रे कअरे गये और विश्वासी पाईया साथे मिली की तिना खे बोलेया तुसा खे शान्ति मिलो और चली गे। ");
INSERT INTO bfz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","तेबे पौलुस और सीलास अम्फिपुलिस और अपुल्लोनिया नगरो रिये ऊई की थिस्सलुनीके नगरो खे आए, जेती यहूदिया रा एक प्रार्थना रा कअर था। ");
INSERT INTO bfz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","तेबे पौलुस आपणी रवाजा रे मुताबिक तिना गे गया और तिना रे आरामो रे दिने पवित्र शास्त्रो बीचा ते तिना साथे बईस कित्ती ");
INSERT INTO bfz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","और से तिना रा मतलब तिना रा उदारण देई-देई की समजयाओ था कि मसीह रा दु:ख उठाणा और मरे रेया बीचा ते जिऊँदा ऊणा जरूरी था, “येई यीशु, जेसरी आऊँ तुसा खे कथा सुणाऊँआ, मसीह ए।” ");
INSERT INTO bfz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","तिना बीचा ते कुछ यहूदिये और कई यूनानी भक्ते और बऊत सारी तर्मी जवाणसे मानी ला और पौलुस और सीलासो साथे, मिली गे। ");
INSERT INTO bfz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पर यहूदिया खे जल़न ऊईगी और तिने बजारू मांणूआ बीचा ते कई दुष्ट मांणू आपू साथे मलाई ते और पीड़ (भीड़) लगाई की नगरो रे शोर-शराबा करने लगे और यासोनो रे कअरो रे चढ़ाई करी की पौलुस और सीलास लोका सामणे ल्याऊणा चाए। ");
INSERT INTO bfz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","तेबे तिना रे तेती ना मिलणे ते बाद सेयो जोरे-जोरे साथे ये बोली की यासोन और कई ओर विश्वासी पाईया खे नगरो रे हाकिमो सामणे खिंजी की ली आए, “यो लोक, जिने दुनिया बी उल्ट-पुल्ट करी ती री, एती बी आईगे रे ");
INSERT INTO bfz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","और यासोने यो आपणे कअरे राखी राखे और यो सब के सब बोलोए कि यीशु राजा ए और महाराजा कैसरो री आज्ञा रा बिरोद करोए।” ");
INSERT INTO bfz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","तिने लोका खे और नगरो रे हाकिमो खे ये सुणाई की सेयो डराई ते। ");
INSERT INTO bfz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","तेबे तिने यासोन और बाकि लोका ते जमानत लयी की सेयो छाडी ते। ");
INSERT INTO bfz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","विश्वासी पाईए रातो-रात पौलुस और सीलास बिरिया नगरो खे पेजी ते और सेयो तेती पऊँछी की यहूदिया रे प्रार्थना रे कअरो रे गये। ");
INSERT INTO bfz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","यो लोक तो थिस्सलुनीके नगरो रे यहूदिया ते ठीक थे और तिने बड़ी लालसा साथे वचन ग्रहण कित्तेया और हर रोज पवित्र शास्त्रो रे टोल़दे रये कि यो गल्ला सच्चिया कि नई। ");
INSERT INTO bfz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","तेबे तिना बीचा ते कई जणे और यूनानी दमदार जवाणसा बीचा ते और मर्दा बीचा ते बी कई जणे विश्वास कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","पर जेबे थिस्सलुनीके रे यहूदी जाणी गे कि पौलुस बिरिया नगरो रे बी परमेशरो रा सुसमाचार सुनाणे लगी रा, तेबे सेयो तेती बी आईगे और लोका खे उकसाणे लगे और आल्ला-गोल्ला करने लगे। ");
INSERT INTO bfz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तेबे विश्वासी पाईए पौलुस फटाफट बिदा कित्तेया कि समुद्रो रे कनारे चली जा, पर सीलास और तीमुथियुस बिरिया रेई रईगे। ");
INSERT INTO bfz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पौलुसो खे पऊँछाणे वाल़े तेसखे एथेंस नगरो तक लयी गे और सीलास और तीमुथियुसो खे ये आज्ञा लयी की बिदा ऊआ कि मांगे फटाफट आयी जाओ। ");
INSERT INTO bfz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जेबे पौलुस एथेंस नगरो रे सीलास और तीमुथियुसो खे न्याल़ने लगी रा था, तेबे नगरो खे मूर्तिया साथे परे रा देखी की तेसरा जिऊ बऊत दु:खी ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","तेबे से प्रार्थना रे कअरो रे यहूदिया खे और भक्ता खे और चौको रे जो बी लोक मिलो थे, तिना साथे हर रोज बईस करो था। ");
INSERT INTO bfz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","तेबे इपिकूरी और स्तोईकी ज्ञानिया बीचा ते कई जणे तेस साथे बईस करने लगे और बऊत जणेया बोलेया, “ये बकवासी क्या बोलणा चाओआ?” पर ओरी बोलेया, “ये ओरी देवतेया रा प्रचार करने वाल़ा लगोआ, कऊँकि ये यीशुए रा और दुबारा जिऊँदा ऊणे रा सुसमाचार सुणाओआ।” ");
INSERT INTO bfz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तेबे सेयो तेसखे आपू साथे अरियुपगुस नाओं रे प्रार्थना रे कअरो रे लयी गे और पूछेया, “क्या आसे जाणी सकूँए कि ये जो नौखी गल्ला, जो तूँ सुणाएया, क्या ए? ");
INSERT INTO bfz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","कऊँकि तूँ आसा खे नऊखिया ई गल्ला सुणाएया, इजी री खातर आसे जाणना चाऊँए कि इना रा मतलब क्या ए?” ");
INSERT INTO bfz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(कऊँकि बऊत सारे एथेंस रे लोक और परदेशी जो तेती रओ थे, नईया-नईया गल्ला बोलणे और सुणने ते अलावा ओर कोई बी कामो रे आपणा बखत नि बिताओ थे।) ");
INSERT INTO bfz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","तेबे पौलुसे अरियुपगुस प्रार्थना रे कअरो रे खड़े ऊई की बोलेया, “ओ एथेंस नगरो रे लोको! आऊँ देखूँआ कि तुसे हर गल्ला रे देवतेया खे बड़ा मानणे वाल़े ए। ");
INSERT INTO bfz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","कऊँकि जेबे आऊँ कूमदे-फिरदे ऊए तुसा री पूजणे रिया चीजा खे देखणे लगी रा था, तेबे एक एड़ी बेदी बी देखी, जेतेरे लिखी राखेया रा था, अणजाणे ईश्वरो खे। तो जेसखे तुसे बिना जाणे पूजोए, आऊँ तुसा खे तेसरा समाचार सुणाऊँआ। ");
INSERT INTO bfz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“जिने परमेशरे तरती और तिजी री हर चीज बणाई, से स्वर्ग और तरतिया रा स्वामी ऊई की आथो रे बणाए रे मन्दरो रे नि रंदा ");
INSERT INTO bfz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","और ना ई किजी बी चीजा ते मतलब राखी की मांणूआ रे आथो री सेवा लओआ, कऊँकि से आपू ई सबी खे जीवन, श्वास और सब कुछ देओआ। ");
INSERT INTO bfz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","तिने एक ई मूल़ो ते मांणूआ री सब जातिया, सारी तरतिया रे रणे खे बणाई राखिया और तिना रे बणाए रे बखत और रणे री सीमा इजी री खातर बानी राखिया। ");
INSERT INTO bfz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","परमेशरे एड़ा तेबे कित्तेया ताकि लोक तेसखे टोल़ो, उम्मीद राखो कि तेसखे टटोल़ी की पायी सकोए, तेबे बी से आसा बीचा ते केसी ते बी दूर निए। ");
INSERT INTO bfz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","कऊँकि आसे तेसदे ई जिऊँदे, चलदे-फिरदे और खड़े रऊँए, जेड़ा तुसा रे कितणे कविये बी बोली राखेया कि, आसे तो तेसरे ई वंश ए। ");
INSERT INTO bfz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","तेबे परमेशरो रा वंश ऊई की आसा खे ये समजणा ठीक निए कि ईश्वर, सुईना, रूपा या पात्थरो जेड़ा ए, जो मांणूआ री कारीगरिया ते और सोच-विचारा ते गढ़ी राखे। ");
INSERT INTO bfz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“तेबेई परमेशरे लोका री अज्ञानता रे बखतो खे त्यान नि दित्तेया, पर एबे हर जगा रे सबी मांणूआ खे मन फिराणे री आज्ञा देओआ। ");
INSERT INTO bfz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","कऊँकि तिने एक दिन बणाई राखेया, जिदे तेस, तेस मांणूए रे जरिए तर्मो साथे एसा दुनिया रा न्याय करना, जो तिने बणाई राखी और तेसखे मरे रेया बीचा ते जिऊँदा करी की ये गल्ल सबी पाँदे परमाणित करी ती री।” ");
INSERT INTO bfz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","मरे रेया दुबारा जिऊँदा ऊणे री गल्ल सुणी की बऊत जणे तेसरा मजाक करने लगे और बऊत जणे बोलणे लगे, “ये गल्ल आसे तांते फेर कदी सुणुंगे।” ");
INSERT INTO bfz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","तेबे पौलुस तिना बीचा ते निकल़ी गा। ");
INSERT INTO bfz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","पर कई सारे मांणू तेस साथे मिली गे और तिने प्रभु यीशुए पाँदे विश्वास कित्तेया, जिना बीचा ते दियुनुसियुस अरियुपगुस था और दमरिस नाओं री एक जवाणस थी और तिना साथे ओर बी बऊत मांणू थे। ");
INSERT INTO bfz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","इजी ते बाद पौलुस एथेंस नगरो खे छाडी की कुरिन्थुस नगरो खे आया। ");
INSERT INTO bfz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","तेबे तेती तेसखे अक्विला नाओं रा यहूदी मिलेया, जेसरा जन्म पुन्तुस प्रदेशो रे ऊआ था। से आपणी लाड़ी प्रिस्किल्ला समेत इटलिया प्रदेशो ते कुछ बखत पईले ई आयी रा था, कऊँकि महाराजा क्लौदियुसे सबी यहूदिया खे रोमो ते निकल़ने री आज्ञा दित्ती थी। पौलुस तिना खे मिलणे तिना रे कअरे गया। ");
INSERT INTO bfz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","पौलुस और अक्विला रा एक ई काम था, इजी री खातर से तिना साथे रया और सेयो काम करने लगे और तिना रा तम्बू बनाणे रा काम था। ");
INSERT INTO bfz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","पौलुस हर आरामो रे दिने प्रार्थना रे कअरो रे बईस करी की यहूदी और यूनानिया खे बी यीशु मसीह पाँदे विश्वास करने खे समजयाओ था। ");
INSERT INTO bfz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जेबे सीलास और तीमुथियुस मकिदुनिया प्रदेशो ते आए, तेबे पौलुस वचन सुनाणे री धुना रे लगी की यहूदिया खे गवाई देओ था कि प्रभु यीशु ई मसीह ए। ");
INSERT INTO bfz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पर जेबे यहूदी बिरोद और निन्दा करने लगे, तेबे तिने आपणे टाले चाड़ी की मतलब इना गल्ला दे मेरा तुसा साथे कोई लेणा-देणा निए तिना खे बोलेया, “तुसा रा खून तुसा री क्याड़िया पाँदे रओ; आऊँ निर्दोष ए, आजो ते मां दुजिया जातिया गे जाणा और तिना खे परमेशरो रा वचन सुनाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","तेथा ते चली की से तीतुस युस्तुस नाओं रे परमेशरो रे एक भग्तो रे कअरे दूजिया जातिया खे उपदेश देणे आया, जेसरा कअर प्रार्थना रे कअरो रे नेड़े था। ");
INSERT INTO bfz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","तेबे प्रार्थना रे कअरो रे सरदारे क्रिसपुसे आपणे सारे कराने समेत प्रभुए पाँदे विश्वास कित्तेया और बऊत सारे कुरिन्थियों रे रणे वाल़े सुणी की विश्वासो रे आए और बपतिस्मा लया। ");
INSERT INTO bfz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","तेबे प्रभुए राथियो खे दर्शनो रे पौलुसो खे बोलेया, “डर नि, बल्कि बोलदा जा और चुप नि रओ। ");
INSERT INTO bfz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","कऊँकि आऊँ तां साथे ए और केसी बी तां पाँदे चढ़ाई करी की तेरा नुकशाण नि करना, कऊँकि एस नगरो रे मेरे बऊत सारे लोक ए।” ");
INSERT INTO bfz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","तेबे पौलुस तिना बीचे परमेशरो रा वचन सिखांदा ऊआ डेढी साल तक रया। ");
INSERT INTO bfz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जेबे गल्लियो अखाया प्रदेशो रा हाकिम था, तेबे यहूदी लोक एक ऊई की पौलुसो पाँदे चढ़ी गे और तेसखे न्याय आसणो सामणे ल्याई की बोलणे लगे, ");
INSERT INTO bfz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ये लोका खे समजयाओआ कि परमेशरो री भक्ति ईंयां करनी ओ, जो बिधानो ते उल्टी ए।” ");
INSERT INTO bfz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","जेबे पौलुस बोलणे ई वाल़ा था, तेबे गल्लिये यहूदिया खे बोलेया, “ओ यहूदिया! जे ये कोई अन्याय या दुष्टता री गल्ल ऊँदी तो ठीक था कि आऊँ तुसा री सुणदा। ");
INSERT INTO bfz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पर जे ये बईस शब्द, नाओं और तुसा रा बिधानो रे बारे रे ए, तो तुसेई जाणो, कऊँकि आऊँ इना गल्ला रा न्यायी नि बणना चांदा।” ");
INSERT INTO bfz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","तेबे गल्लियो सेयो न्याय आसणो रे सामणे ते निकल़वाई ते। ");
INSERT INTO bfz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तेबे बऊत सारे लोके प्रार्थना रे कअरो रा सरदार सोस्थिनेस पकड़ेया और न्याय आसणो सामणे कुटेया, पर गल्लिये इना गल्ला री कोई परवा नि कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","तेबे पौलुस बऊत दिन तक कुरिन्थ नगरो रे रया। तेबे तिने विश्वासी पाईया ते बिदा लयी की किंख्रिया रे जाई की इजी री खातर बाल़ कटवाए, कऊँकि तिने मान्नत कित्ती थी। तेबे से जाह्जो रे सीरिया खे चली गा और तेस साथे प्रिस्किल्ला और अक्विला थे। ");
INSERT INTO bfz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","तेबे तिने इफिसुस नगरो रे पऊँछी की प्रिस्किल्ला और अक्विला तेती छाडी ते और आपू प्रार्थना रे कअरो रे जाई की यहूदिया साथे बईस करने लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","तेबे लोके तेसते बिनती कित्ती, “आसा साथे कुछ ओर दिन तक रओ।” पर से मानेया नि। ");
INSERT INTO bfz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पर ये बोली की तिना ते बिदा ऊआ, “जे परमेशर चाओगा तो आऊँ तुसा गे फेर आऊँगा।” तेबे से इफिसुसो ते जाह्ज खोली की चली गा ");
INSERT INTO bfz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","और कैसरिया नगरो रे उतरी की यरूशलेमो खे गया और मण्डल़िया खे नमस्ते करी की अन्ताकिया नगरो खे आया। ");
INSERT INTO bfz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","तेबे से कुछ दिन तेती रई की अन्ताकिया नगरो ते चली गा और एक तरफा ते गलातिया रे और फूगिया रे प्रदेशो रे सबी चेलेया खे मजबूत करदा ऊआ फिरेया। ");
INSERT INTO bfz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अपुल्लोस नाओं रा एक यहूदी, जेसरा जन्म सिकन्दरिया नगरो रे ऊआ था, जो विद्वान मांणू था और पवित्र शास्त्रो खे अच्छी तरअ ते जाणो था, इफिसुसो नगरो रे आया। ");
INSERT INTO bfz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","तिने प्रभुए री बाटा री शिक्षा पाई राखी थी और मन लगाई की प्रभु यीशुए रे बारे रे ठीक-ठीक सुणाओ था और सीखाओ था, पर से बस यूहन्ने रे बपतिस्मे री गल्ल जाणो था। ");
INSERT INTO bfz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","अपुल्लोस प्रार्थना रे कअरो रे निडर ऊई की बोलणे लगेया। पर प्रिस्किल्ला और अक्विला तेसरी गल्ल सुणी की तेसखे आपणे कअरे लयी गे और तिने परमेशरो री बाट तेसखे ओर बी ठीक-ठीक बताई। ");
INSERT INTO bfz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","जेबे तिने निश्चा कित्तेया कि पार ऊतरी की अखाया प्रदेशो खे जाऊँ, तेबे विश्वासी पाईया तेसखे तसल्ली देई की चेलेया खे लिखेया कि सेयो तेसखे अच्छी तरअ ते मिलेओ और तिने तेती पऊँछी की तेसरी बऊत मताद कित्ती, जिने कृपा री बजअ ते विश्वास कित्तेया था। ");
INSERT INTO bfz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","कऊँकि से पवित्र शास्त्रो ते सबूत देई-देई की कि यीशु ई मसीह ए, बड़ी ई प्रबलता साथे यहूदिया खे सबी सामणे निरूत्तर करदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","जेबे अपुल्लोस कुरिन्थुस नगरो रे था, तेबे पौलुस दूर-दराजो रे प्रदेशो ते ऊई की इफिसुस नगरो रे आया, तेती कुछ चेलेया ते मिले ");
INSERT INTO bfz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","तिने बोलेया, “क्या तुसे विश्वास करदे बखते पवित्र आत्मा पाया?” तिने बोलेया, “आसे तो पवित्र आत्मा रे बारे रे निए सुणेया रा।” ");
INSERT INTO bfz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","पौलुसे तिना खे बोलेया, “तेबे तुसे केसरा बपतिस्मा लयी राखेया?” तिने बोलेया, “यूहन्ने रा बपतिस्मा।” ");
INSERT INTO bfz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पौलुसे बोलेया, “यूहन्ने ये बोली की मन फिराणे रा बपतिस्मा दित्तेया कि जो मांते बाद आऊणे वाल़ा ए तेस पाँदे, मतलब-प्रभु यीशुए पाँदे विश्वास करना।” ");
INSERT INTO bfz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ये सुणी की तिने प्रभु यीशुए रे नाओं ते बपतिस्मा लया। ");
INSERT INTO bfz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","और जेबे पौलुसे तिना पाँदे आथ राखेया, तो तेबे तिना पाँदे पवित्र आत्मा उतरेया और सेयो लग-लग पाषा बोलणे लगे और भविष्यबाणी करने लगे। ");
INSERT INTO bfz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","यो सब तकरीबन बारा मर्द थे। ");
INSERT INTO bfz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","तेबे पौलुस प्रार्थना रे कअरो रे जाई की तीन मीन्ने तक निडर ऊई की बोलदा रया और परमेशरो रे राज्य रे बारे रे बईस करदा और समजयांदा रया ");
INSERT INTO bfz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पर जेबे बऊत जणेया कठोर ऊई की विश्वास करने ते न कित्ती, बल्कि लोका सामणे एसा बाटा खे बुरा बोलणे लगे, तेबे तिने तिना खे छाडी की चेले लग करी ते और हर रोज तुरन्नुसो री पाठशाला रे उपदेश करो था। ");
INSERT INTO bfz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","दो साला तक येई ऊँदा रया, एथो तक कि आसिया प्रदेशो रे रणे वाल़े क्या यहूदी, क्या यूनानी सबी प्रभुए रा वचन सुणी ला। ");
INSERT INTO bfz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","परमेशर पौलुसो रे जरिए सामर्था रे नऊखे काम दखाओ था। ");
INSERT INTO bfz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","एथो तक कि रूमाल और टाल्ले तेसरे शरीरो साथे छवाँई की बमारा पाँदे राखो थे और सेयो ठीक ऊई जाओ थे और दुष्टात्मा तिना ते निकल़ी जाओ थी। ");
INSERT INTO bfz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","पर कुछ यहूदी लोक जो सँवावा करदे फिरदे रओ थे, ये बोलणे लगे, “जेसदे दुष्टात्मा ओ, तिना पाँदे प्रभु यीशुए रा नाओं, ये बोली की फूक बाओ थे कि जेस यीशुए रा प्रचार पौलुस करोआ आऊँ ताखे तेसरी कसम देऊँआ।” ");
INSERT INTO bfz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","तेबे स्क्किवा नाओं रे एक यहूदी बड़े पुरोईतो रे सात पाऊ थे, जो एड़ा ई करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","पर दुष्टात्मे बोलेया, “यीशुए खे तो आऊँ जाणूंई और पौलुसो खे बी पछयाणुँई, पर तूँ कूणे?” ");
INSERT INTO bfz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","तेबे तिने मांणूए जेसदे दुष्टात्मा थी, तिना पाँदे लमखी की और तिना खे बसो रे ल्याई की तिना पाँदे एड़ा उपद्रव कित्तेया कि सेयो नांगे और काईल ऊई की तेस कअरो ते नठीगे। ");
INSERT INTO bfz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ये गल्ल इफिसुसो रे रणे वाल़े यहूदी और यूनानी, सबी खे पता लगी गी और सेयो सब डरी गे और प्रभु यीशुए रे नाओं री तारीफ ऊई। ");
INSERT INTO bfz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","जिने विश्वास कित्तेया था तिना बीचा ते कई जणेया आयी की आपणे-आपणे काम मानी ले और सामणे ल्याए। ");
INSERT INTO bfz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","और जादू करने वाल़ेया बीचा ते कई जणेया आपणी-आपणी पोथिया कट्ठिया करी की सबी सामणे फूकी तिया और जेबे तिना रा दाम जोड़ेया, तो सेयो पंजा ह्जार चाँदिए रे सिक्के रे बराबर निकल़िया। ");
INSERT INTO bfz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ईंयां प्रभुए रा वचन जोरो-शोरो साथे फैलदा गया और प्रबल ऊँदा गया। ");
INSERT INTO bfz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जेबे यो गल्ला ऊई चुकिया तेबे पौलुसे आत्मा रे ठाणी ला कि मकिदुनिया और अखाया प्रदेशो ते ऊई की यरूशलेमो खे जाऊँ और बोलेया, “तेती जाई की माखे रोम नगरो खे देखणा बी जरूरी ए।” ");
INSERT INTO bfz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","तेबे आपणी सेवा करने वाल़ेया बीचा ते तीमुथियुस और इरास्तुसो खे मकिदुनिया प्रदेशो रे पेजी की आपू कुछ दिन तक आसिया प्रदेशो रे इफिसुस नगरो रेई रई गा। ");
INSERT INTO bfz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","तेस बखते एस पंथो रे बारे रे बऊत आल्ला-गोल्ला ऊआ। ");
INSERT INTO bfz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","कऊँकि देमेत्रियुस नाओं रा एक सन्यार अरतिमिसो री देविया रे मन्दरो री चाँदिए री मूर्तिया बणवाई की कारीगरा खे बऊत काम दलाओ था। ");
INSERT INTO bfz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","देमेत्रियुसे तिना खे और एड़ी चीजा रे कारीगरा खे कट्ठे करी की बोलेया, “ओ पाईयो! तुसे जाणोए कि एस काम करी की आसा खे कितणा पैसा मिलोआ। ");
INSERT INTO bfz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","तुसे देखोए और सुणो बी ए कि सिर्फ इफिसुस नगरो रेई नि बल्कि सारे आसिया प्रदेशो रे ये बोली-बोली की इने पौलुसे बऊत लोका खे समजयाया और परमाई बी राखे, कि जो आथे की बणाई राखे, से ईश्वर निए। ");
INSERT INTO bfz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","और एबे सिर्फ एसा गल्ला रा ई डर निए कि आसा रे एस कामो री प्रतिष्ठा जांदी रणी, बल्कि ये बी कि महान् देवी अरतिमिसा रा मन्दर तुच्छ समजेया जाणा और जेसखे सारा आसिया प्रदेश और दुनिया पूजो ई, तिजी री खासियत बी जांदी रणी।” ");
INSERT INTO bfz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","तिना खे ये सुणी की रोष आईगा और सेयो चींगी-चींगी की बोलणे लगे, “इफिसियों री अरतिमिस महान् ए।” ");
INSERT INTO bfz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","तेबे सारे नगरो रे बड़ा आल्ला पड़ी गा और लोके गयुस और अरिस्तर्खुस मकिदुनिया प्रदेशो खे जो पौलुसो साथे यात्री थे, पकड़ी ते और एक चित्त ऊई की रंगशाला खे दौड़ी गे। ");
INSERT INTO bfz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","जेबे पौलुसे लोका गे पीतरे जाणा चाया तेबे चेलेया से जाणे नि दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","आसिया रे कुछ हाकिमा बीचा ते बी तेसरे कई दोस्ते, तेसखे सन्देशा पेजेया और बिनती कित्ती कि रंगशाला रे जाई की आपणी जिन्दगी मुसीबता रे नि पाणी। ");
INSERT INTO bfz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","तेबे कोई कुछ बोलणे लगे और कोई कुछ, कऊँकि सभा रे बऊत गड़बड़ी ऊणे लगी री थी और बऊत जणे लोक ये पनि जाणो थे कि आसे किजी खे कट्ठे ऊई रे। ");
INSERT INTO bfz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तेबे तिने सिकन्दरो खे, जो यहूदिये खड़ा कित्तेया था, पीड़ा (भीड़) बीचा ते आगे कित्तेया। सिकन्दर आथो साथे सारा (ईशारा) करी की लोका सामणे कुछ बोलणा चाओ था। ");
INSERT INTO bfz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पर जेबे तिना खे पता लगेया कि ये यहूदी ए, तो सब के सब एक शब्दो ते कोई दो कंटे तक चींगदे रये कि इफिसियों री अरतिमिस महान् ए। ");
INSERT INTO bfz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","तेबे नगरो रे मन्त्रिये लोका खे शान्त करी की बोलेया, “ओ इफिसियों रे लोको! कुण नि जाणदा कि इफिसियों रा नगर बड़ी देवी अरतिमिसो रे मन्दर और ज्यूस मतलब सर्गो री तरफा ते सेटिया री मूरता रा रखवाल़ा ए। ");
INSERT INTO bfz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","तो तेबे इना गल्ला रा कोई जवाब नि ऊई सकदा, तो तुसा खे ठीक ए कि चुप रओ और बिना सोचे-समजे कुछ नि करो। ");
INSERT INTO bfz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","कऊँकि तुसे इना मांणूआ खे, जो ल्याई राखे, ना मन्दरो खे लूटणे वाल़े ए और ना ई आसा री देविया रे निन्दक ए। ");
INSERT INTO bfz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","जे देमेत्रियुस और तेसरे साथी कारीगरा खे केसी ते कोई बईस ओ तो कचैरी खुली ए और न्याय करने खे हाकिम बी ए, सेयो एकी दूजे पाँदे दोष लगाओ। ");
INSERT INTO bfz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पर तुसे जे केसी ओरी गल्ला रे बारे रे पूछणा चाओए, तो सभा सामणे न्याय करेया जाणा। ");
INSERT INTO bfz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","माखे डर ए कि जेबे राज्यपालो एस अंगामे रे बारे रे सुणना तो तेस बोलणा कि आसे रोमी सरकारा रे खलाफ बिद्रोह करने री कोशिश लगी रे करने। कऊँकि एस अंगामे रा कोई कारण निए, तो आसे एसा पीड़ा रे कट्ठे ऊणे रा कोई जवाब नि देई सकदे।” ");
INSERT INTO bfz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","तेबे तिने ये बोली की तिने सभा बिदा कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","जेबे आल्ला-गोल्ला बंद ऊईगा, तेबे पौलुसे चेले बुलाई की तिना री इम्मत बढ़ाई और तिना ते बिदा ऊई की मकिदुनिया प्रदेशो खे चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","तेबे से तेस सारे देशो ते ऊई की और तिना खे बऊत इम्मत देई की यूनान प्रदेशो खे आया। ");
INSERT INTO bfz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","जेबे तीन मीन्ने यूनानो रे रई की जाह्जो रे सीरिया प्रदेशो खे जाणे वाल़ा था, तेबे तिने सुणेया कि कुछ यहूदी अगुवे बाटा रे तेसखे काणे री ताका रे लगी रे, तेबे तिने आपणे मनो रे ठाणी ला कि मकिदुनिया प्रदेशो ते ऊई की सीरिया प्रदेशो खे जाऊँ। ");
INSERT INTO bfz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","एसा यात्रा रे बिरिया रे पुर्रूसो रा पाऊ सोपत्रुस और थिस्सलुनीकियों नगरो बीचा ते अरिस्तर्खुसो रा सिकुन्दुस और दिरबे नगरो रा गयुस और लुस्त्रा नगरो ते तीमुथियुस, आसिया प्रदेशो रा तुखिकुस और त्रुफिमुस आसा साथे थे। ");
INSERT INTO bfz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","सेयो आसा रे साथी यात्री आसा ते आगे चली गे और त्रोआस नगरो रे पऊँछी की आसा खे न्याल़दे रये। ");
INSERT INTO bfz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","तेबे आसे अखमीरी रोटिया रे त्योआरो ते बाद फिलिप्पिया नगरो ते जाह्जो रे चढ़ी की पाँज दिना रे त्रोआसो रे तिना गे पऊँछे और साता दिना तक तेथी रये। ");
INSERT INTO bfz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","अफ़्ते रे पईले दिने जेबे आसे रोटी तोड़ने खे कट्ठे ऊए, तेबे पौलुसे, जो दूजे दिने जाणे वाल़ा था, तिना साथे गल्ला करने लगेया और आदी राती तक गल्ला ई करदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","जेसा बाऊड़ी रे आसे कट्ठे थे, तिदे बऊत सारे दिऊए थे बल़े रे ");
INSERT INTO bfz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","और यूतुखुस नाओं रा एक जवान द्वारिया रे बैठी की गईरी नींजा रे चुलारे खाणे लगी रा था और जेबे पौलुस गल्ला लगी रा था करने तेबे से नींजा रे चुलारे रे तीजिया बाऊड़ी ते रूड़ी गा और जेबे कुछ लोक तेसखे चकणे थाले आये तेबे से मरी चुकेया था। ");
INSERT INTO bfz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पर पौलुस उतरी की थाले गया और तेस साथे चिपटी गा और गल़े लगाई की बोलेया, “कबराओ नि, कऊँकि एसरा प्राण एसदे ईए।” ");
INSERT INTO bfz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","तेबे फेर ऊबे जाई की रोटी तोड़ी और खाई की इतणी देरा तक तिना साथे गल्ला करदा रया कि प्याग ऊईगी और तेबे से चली गा। ");
INSERT INTO bfz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","तेबे सेयो तेस जवानो खे जिऊँदा ली आए और तिना खे बऊत शान्ति ऊई। ");
INSERT INTO bfz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","आसे पईले तेई जाह्जो रे चढ़ी की अस्सुस नगरो खे ये सोची की आगे गये कि तेथा ते आसे पौलुसो खे चढ़ाई लऊँए, कऊँकि तिने ये बोली राखेया था कि मां आपू ई पैदल जाणा। ");
INSERT INTO bfz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जेबे से अस्सुस नगरो रे आसा खे मिलेया, तेबे आसे तेसखे जाह्जो रे चढ़ाई की मितुलेन नगरो खे ली आए। ");
INSERT INTO bfz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","तेथा ते जाह्ज खोली की आसे दूजे दिने खियुस नगरो रे ऊँदे ऊए सामुस नगरो रे पऊँछी गे। तेबे दूजे दिने मिलेतुस नगरो खे आए। ");
INSERT INTO bfz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पौलुसे ठाणी ला की से इफिसुस नगरो खे छाडी की आगे बढ़ी जाओ, ताकि तेसखे आसिया प्रदेशो रे रणा नि पड़ो। कऊँकि से जल्दीया रे था कि ऊई सको तो तेसरा पिन्तेकुस त्योआरो रा दिन यरूशलेमो रे बीतो। ");
INSERT INTO bfz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","जेबे आसे मिलेतुस नगरो रे पऊँछे तो पौलुसे इफिसुस नगरो खे सन्देशा पेजेया और मण्डल़िया रे बुजुर्ग बुलाए। ");
INSERT INTO bfz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जेबे सेयो तेसगे आए, तेबे तिना खे बोलेया, “तुसे जाणोए कि पईले ई दिनो ते जेबे आऊँ आसिया नगरो रे पऊँछेया, तो आऊँ हर बखत आजो तक तुसा साथे किंयाँ रया? ");
INSERT INTO bfz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","मतलब-बड़ी दीनता ते, आसू निकयाल़ी-निकयाल़ी की और तिना परीक्षा ते, जो यहूदिया रे षड़यन्त्रा री बजअ ते मां पाँदे पड़ी, तेबे बी आऊँ प्रभुए री सेवा करदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","और जो-जो गल्ला तुसा रे फाईदे री थिया, तिना खे बताणे, लोका रे सामणे ल्याऊणे और कअरे-कअरे सखयाणे ते कदी बी पीछे नि अटेया। ");
INSERT INTO bfz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","बल्कि यहूदी और यूनानिया सामणे गवाई देंदा रया कि परमेशरो री तरफा खे मन फिराणा और आसा रे प्रभु यीशुए पाँदे विश्वास करना चाईयो। ");
INSERT INTO bfz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“और एबे देखो, आऊँ पवित्र आत्मा रा बानेया रा यरूशलेमो खे जाऊँआ और आऊँ ये नि जाणदा कि मां पाँदे तेती क्या-क्या बितणी। ");
INSERT INTO bfz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","बस येई कि पवित्र आत्मा हर नगरो रे गवाई देई-देई की माखे बोलोआ कि बन्दन और क्ल़ेश ताखे त्यार ए। ");
INSERT INTO bfz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पर आऊँ आपणे प्राणो खे कुछ नि समजदा कि तेसखे प्यारे जाणूं, बल्कि ये कि आऊँ आपणी दौड़ा खे और आपणी सेवकाईया खे पूरा करुँ, जो मैं परमेशरो री कृपा रे सुसमाचारो पाँदे गवाई देणे खे प्रभु यीशु मसीहे ते पाई राखी ");
INSERT INTO bfz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“और एबे देखो, आऊँ जाणूंआ कि तुसा सबी जणेया, जिना खे आऊँ परमेशरो रे राज्य रा सुसमाचार सुणांदा रया, मेरा मूँ फेर नि देखणा। ");
INSERT INTO bfz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","इजी री खातर आऊँ आजके दिनो रे तुसा खे गवाई देई की बोलूँआ कि जे तुसा बीचा ते कोई बी यीशुए पाँदे विश्वास करने ते बगैर मरी जाओआ तो आऊँ सबी रे खूनो ते निर्दोष ए। ");
INSERT INTO bfz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","कऊँकि आऊँ परमेशरो री सारी इच्छा खे तुसा खे पूरी रीतिया ते मनाणे ते पीछे नि अटेया। ");
INSERT INTO bfz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“इजी री खातर आपणी और पूरे चूण्डो री चौकसी करो, जेते साथे पवित्र आत्मे तुसे अध्यक्ष बणाई राखे कि तुसे परमेशरो री मण्डल़िया री रखवाल़ी करो, जो तिने आपणे खून बाह्ई की खरीदी राखी। ");
INSERT INTO bfz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","आऊँ जाणूंआ कि मांते जाणे ते बाद तुसा बीचे चूठे उपदेशक आऊणे और विश्वासिया खे बऊत नुकशाण पऊँछाणा। ");
INSERT INTO bfz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","तुसा बीचा ते बी एड़े-एड़े मांणू खड़े ऊणे, जिना चेलेया खे आपू पीछे खिंजणे खे टेडिया-मेडिया गल्ला बोलणिया। ");
INSERT INTO bfz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","इजी री खातर जागदे रओ, और याद राखो कि मैं तीन साल तक रात-दिन आसू निकयाल़ी-निकयाल़ी की हर एकी खे चेतावणी देणा नि छाडेया। ");
INSERT INTO bfz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","एबे आऊँ तुसा खे परमेशरो गे और तेसरी कृपा रे वचनो गे सम्बाल़ी देऊँआ, जो तुसा री तरक्की करी सकोआ और सबी पवित्र कित्ते रे लोका खे साजी करी की जायदात देई सकोआ। ");
INSERT INTO bfz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“मैं केसी रे बी चाँदी-सूईने और टालेया रा लाल़च नि कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुसे आपू जाणोए कि इने आथे मेरे और मेरे साथिया री जरूरता पूरी करी राखिया। ");
INSERT INTO bfz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मैं तुसा खे सब कुछ करी की दखाया कि किंयाँ मईणत करी की कमजोर सम्बाल़ने और प्रभु यीशु मसीहे रिया गल्ला याद राखणिया जरूरी ए कि तिने आपू ई बोली राखेया कि लणे ते देणा अच्छा ए।” ");
INSERT INTO bfz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ये बोली की तिने कुटणे टेके और तिना सबी साथे प्रार्थना कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तेबे सेयो बऊत रोए और पौलुसो रे गल़ो रे चिपकी की तेसखे चूमणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","सेयो खास करी की इना गल्ला रा दु:ख करो थे, जो तिने बोलिया थिया कि तुसा मेरा मूँ फेर नि देखणा और तेबे तिने से जाह्जो तक पऊँछाया। ");
INSERT INTO bfz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","जेबे आसे तिना ते विदा ऊई की जाह्ज खोलेया, तेबे सिदी बाटा ते कोस टापूए खे आए और दूजे दिने रूदुस टापूए दे और तेथा ते पतरा टापूए दे। ");
INSERT INTO bfz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","तेबे एक जाह्ज फीनीके नगरो खे जांदा ऊआ मिलेया और तेस पाँदे चढ़ी की यात्रा शुरू कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जेबे आसा खे साईप्रस टापू खूँजे कनारे दिशेया, आसे तिजी खे छाडी की सीरिया प्रदेशो खे चली की सूरो रे उतरे, कऊँकि तेती जाह्जो रा बोजा उतारना था। ");
INSERT INTO bfz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","तेबे तेती चेलेया खे पाई की सात दिन तक रये, तिने पवित्र आत्मा रे सिखाए रे पौलुसो खे बोलेया, “यरूशलेमो नगरो रे पैर नि राखणा।” ");
INSERT INTO bfz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","सात दिना बाद जेबे तेथा ते आसा रे जाणे रा बखत आया, तेबे आसे तेथा ते चली पड़े और सबी जवाणसे बाल़का समेत आसे नगरो ते बारे पऊँछाए, तेबे आसे कनारे पाँदे पऊँछी की कुटणे टेकी की प्रार्थना कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तेबे एकी-दूजे ते बिदा ऊए, आसे तो जाह्जो रे चढ़े और सेयो आपणे-आपणे कअरो खे वापस ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","जेबे आसे सूर नगरो ते जलयात्रा पूरी करी की पतुलिमयिस नगरो रे पऊँछे, तेबे आसे विश्वासी पाईया खे नमस्ते करी की तिना साथे एक दिन रये। ");
INSERT INTO bfz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दूजे दिने आसे तेथा ते चली की कैसरिया नगरो खे आए और फिलिप्पुस सुसमाचार प्रचारको रे कअरे, जो साता बीचा ते एक था, जेसखे यरूशलेमो रे चेलेया बिदुआ री देखपाल़ करने खे चुणी राखेया था, जाई की तेसरे कअरे रये। ");
INSERT INTO bfz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","तेसरी चार कुआँरी बेटिया थिया, जो भविष्यबाणी करो थिया। ");
INSERT INTO bfz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जेबे आसे तेती बऊत दिन तक रई चुके, तेबे अगबुस नाओं रा एक भविष्यबक्ता यहूदिया प्रदेशो ते आया। ");
INSERT INTO bfz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","तिने आसा गे आयी की पौलुसो रा पटका लया और आपणे आथ पैर बानी की बोलेया, “पवित्र आत्मा ये बोलोआ कि जेस मांणूए रा ये पटका ए, से यरूशलेमो रे यहूदिया ईंयां बानणा और दुजिया जातिया रे आथो रे देई देणा।” ");
INSERT INTO bfz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जेबे आसे यो गल्ला सुणिया, तो आसे और तेथो रे लोके पौलुसो ते बिनती कित्ती कि यरूशलेमो खे नि जाणा। ");
INSERT INTO bfz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पर पौलुसे बोलेया, “तुसे क्या लगी रे करने कि रोयी-रोयी की मेरा मन लगी रे दुःखी करने? आऊँ तो प्रभु यीशुए रे नाओं ते यरूशलेमो रे बाने जाणे खेई नि, बल्कि मरने खे बी त्यार ए।” ");
INSERT INTO bfz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जेबे से तिना ते नि मानेया, तो आसे ये बोली की चुप ऊईगे, “प्रभुए री इच्छा पूरी ओ।” ");
INSERT INTO bfz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","कुछ दिना ते बाद आसे पक्का इरादा करी की यरूशलेमो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया नगरो रे बी कई चेले आसा साथे चली पड़े और मनासोन नाओं रे साईप्रसो रे रणे वाल़े रे एक पुराणे चेले रे कअरे साथे ली आए, ताकि आसे तेसरे कअरे रऊँ। ");
INSERT INTO bfz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जेबे आसे यरूशलेमो रे पऊँछे, तेबे विश्वासी पाई आसा साथे बड़े खुश ऊई की मिले। ");
INSERT INTO bfz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दूजे दिने पौलुस आसा खे लयी की याकूबो गे गया, जेती सब बुजुर्ग कट्ठे थे। ");
INSERT INTO bfz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तेबे तिने तिना खे नमस्ते करी की जो-जो काम परमेशरे तेसरी सेवकाईया रे जरिए दुजिया जातिया बीचे कित्ते थे, एक-एक करी की सब बताए। ");
INSERT INTO bfz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","तिने ये सुणी की परमेशरो री महिमा कित्ती, तेबे तिने बोलेया, “ओ पाई! तूँ देखणे लगी रा कि यहूदिया बीचा ते कई ह्जार मांणूए विश्वास कित्तेया और सब बिधानो री धुन लगाई राखोए ");
INSERT INTO bfz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","तिना यहूदी विश्वासिया खे तेरे बारे रे बताया कि तूँ दुजिया जातिया बीचे रणे वाल़े यहूदिया खे मूसे रे बिधानो खे छाडणे रे बारे रे सिखाएया और बोलोआ कि ना आपणे बच्चेया रा खतना कराओ और ना ई रवाजा पाँदे चलो, तो क्या करना चाईयो? ");
INSERT INTO bfz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","लोका जरूर सुणना कि तूँ आयी रा। ");
INSERT INTO bfz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","इजी री खातर जो आसे ताखे बोलूँए, से कर, आसा गे एती चार मांणू ए, जिने मान्नत मानी राखी। ");
INSERT INTO bfz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","तिना खे लयी की तेस साथे आपणे आपू खे शुद्ध कर और तिना खे खर्चा दे, ताकि सेयो बाल़ कटवाओ। तेबे सबी खे पता लगी जाणा कि जो गल्ला तिना खे तेरे बारे रे सिखाईया गईया, तिना री कोई जड़ निए, पर तूँ आपू बी बिधानो खे मानी की तिजी रे मुताबिक चलेया ");
INSERT INTO bfz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","पर तिना दुजिया जातिया रे बारे रे, जिने विश्वास कित्तेया, आसे ये न्याय लयी की लिखी की पेजी राखेया कि सेयो मूर्तिया सामणे बलि कित्ते रे मासो ते, खूनो ते, गल़ा कोटे रे मासो ते और व्याभिचारो ते बचे रओ।” ");
INSERT INTO bfz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","तेबे पौलुस तिना मांणूआ खे लयी की दूजे दिने तिना साथे शुद्ध ऊई की मन्दरो रे गया और बताई ता कि शुद्ध ऊणे रे दिन, मतलब-तिना बीचा ते हर एकी खे चढ़ावा चड़ाए जाणे तको रे दिन कदी पूरे ऊणे। ");
INSERT INTO bfz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जेबे सेयो सात दिन पूरे ऊणे वाल़े थे, तेबे आसिया प्रदेशो रे यहूदिये पौलुसो खे मन्दरो रे देखी की सब लोक उकसाये और ये बोली की से पकड़ी ता, ");
INSERT INTO bfz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ओ इस्राएलियो! मताद करो, ये सेई मांणू ए, जो लोका खे और बिधानो खे और एथो री जगा रे बिरोदो रे, हर जगा रे सबी लोका खे सिखाओआ, एथो तक कि यूनानिया खे बी मन्दरो रे ल्याई की तिने ये पवित्र जगा अशुद्ध करी ती।” ");
INSERT INTO bfz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","तिने तो इजी ते पईले त्रुफिमुस इफिसुसवासिए खे पौलुसो साथे नगरो रे देखेया था और समजो थे कि पौलुस तेसखे मन्दरो रे ली आयी रा। ");
INSERT INTO bfz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तेबे सारे नगरो रे आल्ला पड़ी गा और लोक दौड़ी की कट्ठे ऊईगे और पौलुसो खे पकड़ी की मन्दरो ते बारे कसिटी की ली आए और फटाफट द्वार बन्द करी ते। ");
INSERT INTO bfz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जेबे सेयो तेसखे काणा चाओ थे, तेबे पल़टणा रे सरदारो खे सन्देशा पऊँछेया कि सारे यरूशलेम नगरो रे आल्ला पड़ी रा। ");
INSERT INTO bfz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","तेबे से फटाफट सिपाईया और सूबेदारा खे लयी की तिना गे थाले दौड़ी की आया। जेबे पीड़े फौजिया री पल़टणा रे सरदारो खे और सिपाईया खे देखी की पौलुसो खे मारने कुटणे खे बन्द करी ता। ");
INSERT INTO bfz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तेबे पल़टणा रे सरदारे पौलुसो रे नेड़े आयी की से पकड़ी ता और दो जंजीरा साथे बानणे री आज्ञा देई की पूछणे लगेया, “ये कूणे और इने क्या करी राखेया?” ");
INSERT INTO bfz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","पर पीड़ा (भीड़) बीचा ते कोई कुछ बोलणे लगे और कोई कुछ और जेबे शोर-शराबे रे मारे ठीक सच्चाईया रा पता नि लगेया तो तेसखे गढ़ो रे लयी जाणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जेबे से संगा पाँदे पऊँछेया, तेबे एड़ा ऊआ कि पीड़ा रे दबाओ री बजअ ते सिपाईया खे से चकी की निणा पड़ेया। ");
INSERT INTO bfz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","कऊँकि लोका री पीड़ ये बोली की तेस पीछे पड़ी गी कि एसरा अन्त करी दो। ");
INSERT INTO bfz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जेबे सेयो पौलुसो खे गढ़ो रे निणे वाल़े थे, तेबे तिने पल़टणा रे सरदारो खे बोलेया, “क्या माखे आज्ञा आयी कि आऊँ ताखे कुछ बोलूँ?” तिने बोलेया, “क्या तूँ यूनानी पाषा जाणेया? ");
INSERT INTO bfz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","क्या तूँ सेई मिस्री निए, जो इना दिनो ते पईले बिरोदी बणाई की चार ह्जार आतंकबादी लोका खे जंगल़ो रे लयी गा था?” ");
INSERT INTO bfz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुसे बोलेया, “आऊँ तो तरसुसो रा यहूदी मांणू ए, किलिकिया रा प्रसिद्ध रणे वाल़ा निवासी आ और आऊँ तांते बिनती करूँआ कि माखे लोका ते गल्ला करने दे।” ");
INSERT INTO bfz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जेबे तिने आज्ञा दित्ती, तेबे पौलुसे संगाओ पाँदे खड़े ऊई की लोका खे आथो साथे सारा (ईशारा) कित्तेया, जेबे सेयो चुप ऊईगे, तेबे से इब्रानी पाषा रे बोलणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ओ पाईयो! और पितरो, मेरा जवाब सुणो, जो आऊँ एबे तुसा सामणे बोलणे लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","सेयो ये सुणी की कि से आसा साथे इब्रानी पाषा (भाषा) दे बोलोआ, और बी चुप ऊईगे। तेबे तिने बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“आऊँ तो यहूदी मांणू ए, और किलिकिया प्रदेशो रे तरसुस नगरो रा जम्मे राए, पर एस नगरो रे गमलिएलो रे पैरा गे बैठी की पढ़ाई राखेया और बाप-दादेया रे बिधानो री ठीक रीतिया रे सखाई राखेया और परमेशरो खे एड़ी धुन लगाई री राखूँ था, जिंयाँ तुसे सब जणे आज लगाणे लगी रे। ");
INSERT INTO bfz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","और मैं मर्द और जवाणस दूँईं खे बानी-बानी की और जेला रे पाई-पाई की एस पंथो खे एथो तक सताया कि सेयो मरवाईते। ");
INSERT INTO bfz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","एसा गल्ला रे प्रदान पुरोईत और बड़ी सभा रे सब बुजुर्ग गवा ए कि तिना बीचा ते आऊँ पाईया रे नाओं पाँदे चिट्ठिया लयी की दमिश्क नगरो खे जाणे लगी रा था, ताकि जो तेती बी ओ तिना खे बी सजा दलाणे खे बानी की यरूशलेमो खे ल्याऊँ। ");
INSERT INTO bfz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“जेबे आऊँ चलदे-चलदे दमिश्क नगरो रे नेड़े पऊँछेया, तेबे एड़ा ऊआ कि तकरीबन त्याड़िया जे सर्गो ते एकदम ज्योति मेरे चऊँ कनारे चमकी। ");
INSERT INTO bfz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","और आऊँ जमीना पाँदे रूड़ी गा, तेबे मैं ये शब्द सुणेया, ‘ओ शाऊल! ओ शाऊल’ तूँ माखे कऊँ सताणे लगी रा? ");
INSERT INTO bfz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मैं बोलेया, ‘ओ प्रभु! तूँ कुणे ए?’ तिने बोलेया, ‘आऊँ यीशु नासरी ए, जेसखे तूँ सताएया।’ ");
INSERT INTO bfz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","और मेरे साथिया ज्योति तो देखी, पर जो मां साथे जपणे लगी रा था, तिने तेसरा शब्द तो सुणेया, पर से समजी नि सके। ");
INSERT INTO bfz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तेबे मैं बोलेया, ‘ओ प्रभु! आऊँ क्या करुँ?’ प्रभुए माखे बोलेया, ‘उठी की दमिश्को रे जा और जो कुछ तेरे करने राए, तेती ताखे सब कुछ बताया जाणा।’ ");
INSERT INTO bfz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जेबे तेसा ज्योतिया रे चमकणे ते माखे कुछ नि दिशेया, तेबे आऊँ आपणे साथिया रे आथ पकड़ी की दमिश्क नगरो रे आया। ");
INSERT INTO bfz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“तेबे हनन्याह नाओं रा बिधानो रे मुताबिक एक चेला था, जो तेती रणे वाल़े सबी यहूदिया बीचे सुनाम था, मांगे आया। ");
INSERT INTO bfz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","और खड़े ऊई की माखे बोलेया कि ओ शाऊल पाई फेर देखणे लगी जा। तेसी बखते मेरी आखी खुली गिया और मैं से देखेया। ");
INSERT INTO bfz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तेबे तिने बोलेया कि आसा रे बाप-दादेया रे परमेशरे तूँ इजी री खातर ठराई राखेया; ताकि तूँ तेसरी इच्छा खे जाणे और तेस तर्मिंयों खे देखी सके और तेसरे मुंओ ते गल्ला सुणी सके। ");
INSERT INTO bfz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","कऊँकि तूँ तेसरी तरफा ते सबी मांणूआ सामणे तिना गल्ला रा गवा ऊणा, जो तैं देखी राखिया और सुणी राखिया। ");
INSERT INTO bfz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","एबे देर कऊँ लगी रा करने? उठ बपतिस्मा लओ और तेसरा नाओं लयी की आपणे पापो खे तोओ। ");
INSERT INTO bfz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“जेबे आऊँ फेर यरूशलेमो रे आयी की मन्दरो रे प्रार्थना लगी रा था करने, तेबे बेओश ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","और तिने देखेया कि से माखे बोलोआ कि फटाफट यरूशलेमो ते निकल़ी जा, कऊँकि तिना लोका जो एती ए मेरे बारे रे तेरी गवाई नि मानणी। ");
INSERT INTO bfz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मैं बोलेया कि ओ प्रभु! तुसे तो जाणोए कि आऊँ तुसा पाँदे विश्वास करने वाल़ेया खे जेला रे पाऊँ था और जगा-जगा प्रार्थना रे कअरो रे कुटवाऊँ था। ");
INSERT INTO bfz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","और जेबे तेरे गवा स्तिफुनुसो रा खून बइणे लगी रा था, तेबे आऊँ बी तेथी खड़ा था और एसा गल्ला रे शामिल था और तेसखे काणे वाल़ेया रे टालेया री देख-रेख करुँ था। ");
INSERT INTO bfz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","और प्रभुए माखे बोलेया, ‘चली जा, कऊँकि मां तूँ दुजिया जातिया गे दूर-दूर पेजणा।’ ” ");
INSERT INTO bfz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","सेयो लोक एसा गल्ला तक तेसरी सुणदे रये, तेबे जोरे की बोलणे लगे, “एड़े मांणूए रा अन्त करो, एसरा जिऊँदा रणा ठीक निए।” ");
INSERT INTO bfz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जेबे सेयो चिंगणे, टाले सेटणे और सर्गो रे तूड़ उड़ाओ थे, ");
INSERT INTO bfz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","तेबे पल़टणा रे सरदारे बोलेया, “एसखे गढ़ो रे लयी जाओ और कोड़े बाई कि परखो, ताकि माखे बी पता लगो कि लोक किजी री बजअ ते एसरे बिरोदो रे एड़े चिंगणे लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","जेबे तिने से तसमेया साथे बानेया, तेबे पौलुसे तेस सूबेदारो ते, जो नेड़े था खड़ेया रा बोलेया, “क्या ये ठीक ए कि तुसे एक रोमी मांणूए खे और से बी बिना दोषो ते, कोड़े बाओ?” ");
INSERT INTO bfz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","सूबेदारे ये सुणी की पल़टणा रे सरदारो गे जाई की बोलेया, “तूँ ये क्या लगी रा करने? ये तो रोमी मांणू ए।” ");
INSERT INTO bfz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तेबे पल़टणा रे सरदारे तेसगे आयी की बोलेया, “मांगे बता कि क्या तूँ रोमी ए?” तिने बोलेया, “आ।” ");
INSERT INTO bfz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ये सुणी की पल़टणा रे सरदारे बोलेया, “मैं रोमी ऊणे रा पद बऊत पैसे देई की पाई राखेया।” पौलुसे बोलेया, “आऊँ तो जन्मो तेई रोमी ए।” ");
INSERT INTO bfz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तेबे सेयो लोक जो तेसखे परखणे वाल़े थे। सेयो फटाफट तेसगे ते आटी गे और पल़टणा रा सरदार बी ये जाणी की कि ये रोमी ए और मैं ये बानी राखेया, डरीगा। ");
INSERT INTO bfz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","दूजे दिने से ठीक-ठीक जाणने री इच्छा ते कि यहूदी तेस पाँदे कऊँ दोष लगाणे लगी रे, तेसरे बन्दन खोली ते और बड़े पुरोईत और सारी सभा खे कट्ठे ऊणे री आज्ञा दित्ती और पौलुस थाले ल्याई की तिना सामणे खड़ा करी ता। ");
INSERT INTO bfz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुसे महासभा खे टकटकी लगाई की देखेया और बोलेया, “ओ पाईयो! मैं आजो तक परमेशरो खे बिल्कुल सच्चाईया साथे जीवन बिताया।” ");
INSERT INTO bfz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","हनन्याह प्रदान पुरोईत, तिना री, जो तेसगे खड़ी रे थे, तेसरे मुंओ रे थप्पड़ बाणे खे बोलेया। ");
INSERT INTO bfz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तेबे पौलुसे तेसखे बोलेया, “ओ दखावटी मांणू, परमेशरे तूँ काणा, तां पाँदे परमेशरो री मार पड़नी। तूँ बिधानो रे मुताबिक मेरा न्याय करने बैठी रा और तेबे क्या बिधानो रे खलाफ माखे बाणे खे बोलणे लगी रा?” ");
INSERT INTO bfz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जो नेड़े थे खड़े रे तिने बोलेया, “क्या तूँ परमेशरो रे प्रदान पुरोईतो खे बुरा लगी रा बोलणे?” ");
INSERT INTO bfz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुसे बोलेया, “ओ पाईयो! माखे नि था पता कि ये प्रदान पुरोईत ए, कऊँकि पवित्र शास्त्रो रे लिखी राखेया कि आपणे लोका रे प्रदानो खे बुरा नि बोल।” ");
INSERT INTO bfz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तेबे पौलुसे ये जाणी की कि कितणे सदूकी ए और कितणे फरीसी ए, सभा रे आक्का पाई की बोलेया, “ओ पाईयो! आऊँ फरीसी और फरीसिया रे वंशो राए, मरे रेया री उम्मीद और दुबारा जिऊँदा ऊणे रे बारे रे मेरा मुकद्दमा ऊणे लगी रा।” ");
INSERT INTO bfz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","जेबे तिने ये गल्ल बोली तेबे फरीसी और सदूकिया बीचे चगड़ा ऊणे लगेया और सभा रे फूट पड़ी गी। ");
INSERT INTO bfz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","कऊँकि सदूकिया रा ये विश्वास ए कि ना तो दुबारा जिऊँदा ऊणा ए, ना स्वर्गदूत ए और ना ई आत्मा ए, पर फरीसी इना सबी गल्ला खे मानो थे। ");
INSERT INTO bfz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तेबे बऊत आल्ला पड़ी गा और बऊत शास्त्री, जो फरीसिया रे दलो रे थे, उठी की ये बोली की चगड़ने लगे, “आसे एस मांणूए रे कोई बुराई नि पाँदे और जे कोई आत्मा या स्वर्गदूत एस साथे बोलेया, तो तेबे क्या ए?” ");
INSERT INTO bfz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जेबे बऊत चगड़ा ऊईगा, तेबे पल़टणा रे सरदारे, इजी रे डरो ते कि से केथी पौलुसो रे टुकड़े-टुकड़े नि करी देओ, पल़टणा खे आज्ञा दित्ती, “उतरी की पौलुसो खे तिना बीचा ते जबरदस्ती खिंजी की निकयाल़ो और गढ़ो रे ली आओ।” ");
INSERT INTO bfz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","तेसी राती प्रभु यीशुए पौलुसो गे आयी की बोलेया, “ओ पौलुस! इम्मत राख, कऊँकि जेड़ी तैं यरूशलेमो रे मेरी गवाई दित्ती, तेड़ी ई ताखे रोमो रे बी गवाई देणी पड़नी।” ");
INSERT INTO bfz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","जेबे दिन ऊआ, तेबे कुछ यहूदिये एक ऊई की बोलेया और कसम खाई, “जदुओ तक आसे पौलुसो खे काई नि देऊँगे, तदुओ तक खाऊँगे या पिऊँगे तो आसा पाँदे धिक्कार ए।” ");
INSERT INTO bfz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जिने आपू बीचे ये कसम खाई, सेयो चाल़िया ते पाँदे थे। ");
INSERT INTO bfz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","तिने बड़े पुरोईत और बुजुर्गा गे आयी की बोलेया, “आसे ये ठाणी राखेया कि जदुओ तक आसे पौलुसो खे नि काई लऊँगे, तदुओ तक जे कोई कुछ चाखो गा बी, तो आसा पाँदे धिक्कारो पाँदे धिक्कार ए। ");
INSERT INTO bfz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","इजी री खातर एबे बड़ी सभा समेत पल़टणा रे सरदारो खे समजयाओ कि पौलुसो खे तांगे ली आओ, मानेया कि तुसे तेसरे बारे रे ओर बी परख करना चाओए और आसे तेसरे पऊँछणे ते पईले ई, तेसखे काणे खे त्यार रणे।” ");
INSERT INTO bfz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पर पौलुसो री बईणा रे पाऊए सुणेया कि सेयो तेसखे काणे री ताका रे ए, तेबे तिने पौलुसो खे गढ़ो रे जाई की सन्देशा दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पौलुसे सूबेदारा बीचा ते एकी खे आपू गे बुलाई की बोलेया, “एस जवानो खे पल़टणा रे सरदारो गे लयी जाओ, ये तेसखे कुछ बोलणा चाओआ।” ");
INSERT INTO bfz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","तेबे सुबेदारे पौलुसो रे पांणजे खे पल़टणा रे सरदारो गे लयी जाई की बोलेया, “पौलुस बन्दुए माखे बुलाई की बिनती कित्ती कि ये जवान पल़टणा रे सरदारो ते कुछ बोलणा चाओआ, एसखे तेसगे लयी जा।” ");
INSERT INTO bfz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","पल़टणा रे सरदारे तेसरा आथ पकड़ी की और तेसखे लग जे लयी जाई की पूछेया, “मांगे क्या बोलणा चाएया?” ");
INSERT INTO bfz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","तिने बोलेया, “यहूदिये अगुवे एकता करी राखी कि तांते बिनती करो कि काल पौलुसो खे बड़ी सभा रे ल्याओ, मानेया कि तूँ ओर ठीक तरअ ते तेसखे परखणा चाएया। ");
INSERT INTO bfz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","पर एसरी ए बिनतिया नि मानणी, कऊँकि तिना बीचा ते चाल़ी मांणूआ ते पाँदे पौलुसो खे काणे री ताका रे ए, जिने ये ठाणी ला रा कि जदुओ तक आसे पौलुसे खे काई नि देऊँगे, तदुओ तक खाऊँ, पिऊँगे तो आसा पाँदे धिक्कार ए, और एबु सेयो त्यार ए और तेरे वचनो री उम्मीद देखणे लगी रे।” ");
INSERT INTO bfz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","तेबे पल़टणा रे सरदारे जवानो खे ये आज्ञा देई की बिदा कित्तेया, “केसी गे नि बोलणा कि तैं मांगे ये गल्ल बोली राखी।” ");
INSERT INTO bfz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तेबे सेनापतिये दो सूबेदारा खे बुलाई की बोलेया, “दो सौ सिपाई, सत्तर सवार और दो सौ भालैत, पहर राथियो खे कैसरिया नगरो खे जाणे खे त्यार करी की राखो ");
INSERT INTO bfz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","और पौलुसो री सवांरिया खे कोड़े त्यार राखो, ताकि तेसखे फेलिक्स हाकिमो गे ठीक-ठाक पऊँछाया जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","सेनापतिये राज्यपालो खे ईंयां पत्री बी लिखी, ");
INSERT INTO bfz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“महाप्रतापी फेलिक्स हाकिमो खे क्लौदियूस लूसियासो री तरफा ते नमस्ते। ");
INSERT INTO bfz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ये मांणू यहूदिये पकड़ी की काणा चाया, पर जेबे माखे पता लगेया कि ये रोमी ए, तेबे पल़टण लयी की छुड़ाई की ली आया। ");
INSERT INTO bfz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","आऊँ जाणना चाऊँ था कि सेयो एस पाँदे किजी री बजअ ते तेस पाँदे दोष लगाणे लगी रे, इजी री खातर आऊँ तेसखे तिना री महासभा रे लयी गा। ");
INSERT INTO bfz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","तेबे माखे पता लगी गा कि सेयो आपणी यहूदी बिधानो रे बईसो रे बारे रे एस पाँदे दोष लगी रे लगाणे, पर काणे जोगा और बानणे जोगा एसदे कोई दोष निए। ");
INSERT INTO bfz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","जेबे मांगे बताया गया कि सेयो लोक एसखे काणे री ताका रे लगी रे, तो मैं फटाफट से तांगे पेजी ता और दुश्मणा खे बी आज्ञा दित्ती कि तां सामणे तेसखे निर्दोष करेयो।” ");
INSERT INTO bfz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","तो तेबे जिंयाँ सिपाईया खे आज्ञा दित्ती थी तिंयाँ ई सिपाईए पौलुसो खे रातो-रात अन्तिपत्रिस नगरो खे ली आए। ");
INSERT INTO bfz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दूजे दिने सेयो सवारा खे पौलुसो साथे कैसरिया नगरो खे जाणे खे छाडी की आपू गढ़ो खे वापस आईगे। ");
INSERT INTO bfz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","तिने कैसरिया नगरो रे पऊँछी की हाकिमो खे पत्री दित्ती और पौलुस बी तेस सामणे खड़ा कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","राज्यपाले पढ़ी की पूछेया, “ये मांणू कुण जे प्रदेशो राए?” पौलुसे उतर दित्तेया, “आँऊ किलिकिया प्रदेशो राए।” ");
INSERT INTO bfz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","जेबे जाणी ला कि किलिकिया राए तो राज्यपाले तेसखे बोलेया, “जेबे तेरे दुश्मण बी आओगे, तेबे आऊँ तेरा मुकद्दमा करूँगा।” तिने पौलुस हेरोदेसो रे किले रे पईरे रे राखणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाँज दिना ते बाद हनन्याह नाओं रा प्रदान पुरोईत कई बुजुर्ग और तिरतुल्लुस नाओं रे केसी वकीलो खे साथे लयी की केसरिया नगरो खे आया, तिने हाकिमो सामणे पौलुसो पाँदे दोष लगाया। ");
INSERT INTO bfz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","जेबे पौलुस बुलाया, तेबे तिरतुल्लुस तिना पाँदे दोष लगाई की बोलणे लगेया, “ओ महाप्रतापी फिलेक्स! तेरे जरिए जो आसा खे बड़ा राम मिलोआ और तेरे प्रबन्धो ते इना जातिया खे कितणिया बुराईया सुदारिया जाओईया, ");
INSERT INTO bfz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","इना खे आसे हर जगा और हर प्रकारो ते धन्यवादो साथे मानूँए। ");
INSERT INTO bfz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","पर इजी री खातर कि आँऊ तेरा ओर जादा बखत खराब नि करना चांदा। आऊँ तांते बिनती करूँआ कि कृपा करी की म्हारिया दो-एक गल्ला सुणी लो। ");
INSERT INTO bfz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","कऊँकि आसे ये मांणू ऊदम मचाणे वाल़ा और दुनिया रे सारे यहूदिया बीचे अंगामा करने वाल़ा और नासरियो रे अड़दंगे कामो रा मुखिया पाई राखेया। ");
INSERT INTO bfz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","इने मन्दर अशुद्ध करना चाया पर आसे ये पकड़ी ता। (आसे एसखे आपणे बिधानो रे मुताबिक सजा दित्ती ऊँदी) ");
INSERT INTO bfz_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पर पल़टणा रे सरदार लूसीयासे ये आसा ते जबरदस्ती छुड़ाई ला, ");
INSERT INTO bfz_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","और दुश्मणा खे तां सामणे आऊणे खे बोलेया इना सबी गल्ला खे जिना रे बारे रे आसे एस पाँदे दोष लगाणे लगी रे, ताखे आपू ई एसखे परखी की पता लगी जाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदिये बी तेसरा साथ देई की बोलेया कि यो गल्ला ईंयां ई आईया। ");
INSERT INTO bfz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","जेबे हाकिमे पौलुसो खे बोलणे खे सारा (संकेत) कित्तेया, तेबे पौलुसे जवाब दित्तेया, “जेबे माखे पता लगेया कि तूँ बऊत साला ते एसा जातिया रा न्याय करदा आयी रा, तेबेई खुशिया साथे आपणा जवाब देऊँआ। ");
INSERT INTO bfz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तूँ आपू जाणी सकेया कि जदुओ ते आऊँ यरूशलेमो रे भक्ति करने खे मन्दरो रे आया, माखे बारा दिना ते जादा नि ऊई रे। ");
INSERT INTO bfz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","और तिने आऊँ ना मन्दरो रे, ना प्रार्थना रा कअर, ना नगरो रे केसी साथे बईस करदे या पीड़ (भीड़) लगांदे ऊए देखेया, ");
INSERT INTO bfz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","और ना ई सेयो तिना गल्ला खे, जिना रा सेयो मां पाँदे दोष लगाणे लगी रे, तां सामणे सच साबित करी सकोए। ");
INSERT INTO bfz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","पर आऊँ तां सामणे ये मानी लऊँआ कि जेते कामो खे यो अड़दंगे काम बोलोए तेसरी ई रीतिया ते आऊँ आपणे बाप-दादेया रे परमेशरो री सेवा करूँआ और जो गल्ला बिधान और भविष्यबक्तेया री कताबा रे लिखी राखिया, तिना सबी पाँदे विश्वास करूँआ ");
INSERT INTO bfz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","और परमेशरो ते उम्मीद राखूँआ कि जो सेयो आपू बी राखोए कि तर्मी और पापी दोनो जिऊँदे ऊणे। ");
INSERT INTO bfz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","इजी ते आऊँ आपू बी कोशिश करूँआ कि परमेशरो री और मांणूआ री तरफा ते मेरा विवेक सदा निर्दोष रओ। ");
INSERT INTO bfz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“बऊत साला ते बाद आऊँ आपणे गरीब लोका खे दान पऊँछाणे और पेंट चढ़ाणे यरूशलेम नगरो खे आया था। ");
INSERT INTO bfz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","तिने आऊँ मन्दरो रे शुद्ध दशा रे और बिना पीड़ा ते और बिना दंगा करदे ऊए पेंट चड़ांदे ऊए देखेया-पर आ, आसिया प्रदेशो रे कई यहूदी थे, तिना खे ठीक था ");
INSERT INTO bfz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","कि जे मेरे बिरोदो रे तिना री कोई गल्ल ओ तो, एती मां सामणे आयी की मां पाँदे दोष लगांदे। ");
INSERT INTO bfz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","या यो आपू ई बोलो कि जेबे आऊँ महासभा सामणे खड़ा था, तेबे इने मांदे कुण जा अपराध पाया? ");
INSERT INTO bfz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","एसा एकी गल्ला खे छाडी की जो मैं इना बीचे आक्का पाई की बोली थी, ‘मरे ऊए रे जिऊँदे ऊणे रे बारे रे आज मेरा तुसा सामणे मुकद्दमा ऊणे लगी रा।’ ” ");
INSERT INTO bfz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलिक्से जो एस कामो रिया गल्ला ठीक-ठीक जाणो था, सेयो ये बोली की टाल़ी ते, “जेबे पल़टणा रा सरदार लूसियास आऊणा, तेबे तुसा री गल्ला रा न्याय करूँगा।” ");
INSERT INTO bfz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","सूबेदारो खे बोलेया कि पौलुसो खे कुछ टीअल (छूट) देई की रखवाल़ी करेयो पर तेसरे दोस्ता बीचा ते केसी खे बी तेसरी सेवा करने ते नि रोकणा। ");
INSERT INTO bfz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","थोड़े दिनो ते बाद राज्यपाल फेलिक्स आपणी लाड़ी द्रुसिल्ला खे, जो यहूदिणी थी, साथे लयी की केसरिया नगरो खे आया और पौलुसो खे बुलाई की तेस विश्वासो रे बारे दे, जो यीशु मसीह पाँदे ए, तेसते सुणेया। ");
INSERT INTO bfz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","जेबे पौलुस तर्म, सब्र और आऊणे वाल़े न्याय रे बारे रे बताओ था, तेबे फेलिक्से डरदे ऊए बोलेया, “एबु तो जा, मौका मिलणे पाँदे मां तूँ फेर बुलाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","राज्यपाल फेलिक्सो खे पौलुसो ते कुछ पैसे मिलणे री बी उम्मीद थी, इजी री बजअ ते से तेसखे ओर बी बुलाई-बुलाई की गल्ला करो था। ");
INSERT INTO bfz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","पर जेबे दो साल बीती गे, तेबे पुरकियुस फेस्तुस फेलिक्सो री जगा पाँदे राज्यपाल बणेया और फेलिक्स यहूदिया खे खुश करने री इच्छा ते पौलुसो खे बन्दुआ ई छाडी गा। ");
INSERT INTO bfz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्तुस यहूदिया प्रदेशो रे राज्यपालो रा काम सम्बाल़ने ते तीन दिन बाद कैसरिया नगरो ते यरूशलेमो खे गया। ");
INSERT INTO bfz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","तेबे बड़े पुरोईत और यहूदी अगुवे तेस सामणे पौलुसो पाँदे आरोप लगाए। ");
INSERT INTO bfz_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","तिने फेस्तुसो ते बिनती कित्ती कि से पौलुसे खे यरूशलेमो खे बुलाणे री कृपा करो, कऊँकि सेयो पौलुसो खे बाटा रेई काणे री ताका रे थे। ");
INSERT INTO bfz_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुसे बोलेया, “पौलुस कैसरिया रे पईरे रे ए और मां आपू तेती चट ई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","फेर बोलेया, “जो तुसा बीचे अक्क राखोए, सेयो बी साथे चलो और जे इने मांणूए कुछ बुरा काम करी राखेया, तो तेस पाँदे दोष लगाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","फेस्तुस यरूशलेमो रे तिना बीचे कोई आठ-दस दिन रई की कैसरिया नगरो खे गया और दूजे दिने न्याय आसणो पाँदे बैठी की पौलुसो खे ल्याऊणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जेबे से आया, तेबे जो यहूदी अगुवे यरूशलेमो ते आयी रे थे, तिने नेड़े-तेड़े खड़ी की तेस पाँदे बऊत सारे दोष लगाए, जिना रा तिना गे कोई सबूत नि था। ");
INSERT INTO bfz_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पर पौलुसे जवाब दित्तेया, “मैं ना तो यहूदिया रा बिधानो रा, ना ई मन्दरो रा और ना ई कैसरो रे खलाफ कुछ अपराध करी राखेया।” ");
INSERT INTO bfz_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","तेबे फेस्तुसे यहूदिया खे खुश करने री इच्छा ते पौलुसो ते पूछेया, “क्या तूँ यरूशलेमो खे जाणा चाएया और तेती मां सामणे तेरे एस मुकद्दमे रा न्याय कित्तेया जाणा?” ");
INSERT INTO bfz_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पौलुसे बोलेया, “आऊँ कैसरो रे न्याय आसणो सामणे खड़ी रा, मेरे मुकद्दमे रा एथी न्याय ऊणा चाईयो, जेड़ा तूँ अच्छी तरअ ते जाणेया कि यहूदिया रा मैं कुछ बी अपराध निए कित्तेया रा। ");
INSERT INTO bfz_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","जे आऊँ अपराधी ए और काणे जोगा कुछ अपराधो रा काम करी राखेया, तो मरने ते नि मुकरदा। पर जिना गल्ला रा यो यहूदी अगुवे मां पाँदे दोष लगाणे लगी रे, जे तिना बीचा ते कोई गल्ल सच नि ऊई, तो कोई माखे तिना रे आथो रे नि देई सकदा। आऊँ कैसरो ते विनती करूँआ, सेई मेरा न्याय करो।” ");
INSERT INTO bfz_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तेबे फेस्तुसे मन्त्रिया री सभा साथे बात-चीत करी की बोलेया, “तैं कैसरो ते विनती करी राखी, तूँ कैसरो गे ई जाणा।” ");
INSERT INTO bfz_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कुछ दिन बितणे ते बादो ते अग्रिप्पा राजा और तेसरी छोटी बईण बिरनिके कैसरिया रे आयी की फेस्तुसो खे मिले। ");
INSERT INTO bfz_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","तिना रे बऊत दिन तक तेती रणे ते बादो ते फेस्तुसे पौलुसो रे बारे रे राजे गे बताया कि एक मांणू ए, जेसखे फेलिक्स बन्दुआ छाडी गा रा। ");
INSERT INTO bfz_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जेबे आऊँ यरूशलेमो रे था, तेबे बड़े पुरोईत और यहूदिया रे बुजुर्गे तेस पाँदे आरोप लगाया और चाया कि तेसखे सजा मिलो। ");
INSERT INTO bfz_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","पर मैं तिना खे बोलेया, “रोमिया री एड़ी रवाज निए कि केसी मांणूए खे सजा मिलो, जदुओ तक अपराधिया खे तेस पाँदे दोष लगाणे वाल़े रे आमणे-सामणे खड़े ऊई की दोषो रा जवाब देणे रा अवसर नि मिलो। ");
INSERT INTO bfz_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","तो जेबे यहूदी अगुवे मां साथे केसरिया आये थे, तेबे मैं देर नि कित्ती, पर दूजे ई दिने न्याय आसणो रे बैठी की तेस मांणूए खे ल्याऊणे री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जेबे तेसरे दुश्मण खड़े ऊए, तेबे तिने एड़ी बुरी गल्ला रा दोष नि लगाया, जेड़ी आऊँ समजूँ था। ");
INSERT INTO bfz_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","पर सेयो आपणे तर्म और यीशु नाओं रे केसी मांणूए रे बारे दे, जो मरी गा था और पौलुस तेसखे जिऊँदा बताओआ, बईस करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","आऊँ उल़जणा रे पड़ी गा कि इना गल्ला रा पता किंयाँ लगाऊँ? इजी री खातर मैं पौलुसो ते पूछेया, क्या तूँ यरूशलेम जाणा चाएगा, ताकि तेती इना गल्ला रा न्याय ओ? ");
INSERT INTO bfz_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पर जेबे पौलुसे विनती कित्ती कि मेरे मुकद्दमे रा न्याय महाराजाधिराजो गे ओ, तो तेबे मैं आज्ञा दित्ती कि जदुओ तक तेसखे कैसरो गे नि पेजूँ, तदुओ तक तेसखे कैदा रे राखेया जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","तेबे अग्रिप्पे फेस्तुसे खे बोलेया, “आऊँ बी तेस मांणूए री सुणना चाऊँआ।” तिने बोलेया, “तां काल सुणी लणी।” ");
INSERT INTO bfz_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","तेबे दूजे दिने, जेबे महाराजा अग्रिप्पा और बिरनिके बड़ी धूमधामा साथे पल़टणा रे सरदार और नगरो रे बड़ेया लोका साथे दरबारो रे पऊँछेया, तेबे फेस्तुसे आज्ञा दित्ती कि पौलुसो खे ली आओ। ");
INSERT INTO bfz_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुसे बोलेया, “ओ राजा अग्रिप्पा और सब लोको, जो आसा साथे एती ए, तुसे एस मांणूए खे देखोए, जेसरे बारे रे सारे यहूदिये यरूशलेम और एती बी चींगी-चींगी की मांते बिनती कित्ती कि एसरा जिऊँदा रणा ठीक निए। ");
INSERT INTO bfz_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पर मैं जाणी ला की तिने एड़ा कुछ नि करी राखेया की तेसखे मारी देओ, और बल्कि तिने आपू ई महाराजे ते विनती कित्ती, तेबे मैं तेसखे रोम पेजणे रा फैंसला कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","पर मैं तेसरे बारे रे कोई ठीक गल्ल नि पाई, ताकि आपणे स्वामिए खे लिखूँ, इजी री खातर आऊँ एसखे तुसा सामणे और महाराज अग्रिप्पा तां सामणे ल्याई राखेया, ताकि परखणे ते बाद माखे कुछ लिखणे खे मिलो ");
INSERT INTO bfz_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","कऊँकि बन्दुओ खे पेजणा और जो तेस पाँदे दोष लगाई राखे, सेयो नि बताणे, माखे बेकार लगोआ।” ");
INSERT INTO bfz_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्रिप्पे पौलुसो खे बोलेया, “ताखे आपणे बारे रे बोलणे री आज्ञा आए।” तेबे पौलुस आथ आगे करी की जवाब देणे लगेया, ");
INSERT INTO bfz_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ओ अग्रिप्पा राजा! जितणी गल्ला रा यहूदी अगुवे मां पाँदे दोष लगाणे लगी रे, आज तां सामणे तिना रा जवाब देणे खे आऊँ आपू खे धन्य समजूँआ। ");
INSERT INTO bfz_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","खास कर इजी खे कि तूँ यहूदिया रे सब व्यवहार और बईसा खे जाणेया। तेबे आऊँ बिनती करूँआ कि शान्त ऊई की मेरी सुणो। ");
INSERT INTO bfz_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“जेड़ा मेरा चाल-चलण शुरूओ ते आपणी जातिया बीचे और यरूशलेमो रे था, ये सब यहूदिया रे अगुवा जाणोए। ");
INSERT INTO bfz_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","सेयो जे गवाई देणा चाओए, तो शुरूओ ते माखे पछयाणोए कि आऊँ फरीसी ऊई की आपणे तर्मो रे सबी ते खरे पन्थो रे मुताबिक चलेया। ");
INSERT INTO bfz_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","और एबे तेस वादे री उम्मीदा री बजअ ते, जो परमेशरे आसा रे बाप-दादेया साथे कित्ती थी, मां पाँदे मुकद्दमा चली रा। ");
INSERT INTO bfz_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","तेसी वादे रे पूरे ऊणे री उम्मीद लगाए रे आसा रे बारा गोत्र, आपणे सारे मनो ते रात-दिन परमेशरो री सेवा करदे आयी रे। ओ राजा! इजी उम्मीदा रे बारे रे यहूदी मां पाँदे दोष लगाणे लगी रे। ");
INSERT INTO bfz_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","जबकि जादातर यहूदी ये विश्वास करोए कि परमेशर मरे रेया खे जिऊँदा करोआ, तो तुसा रे एती, ये गल्ल कऊँ विश्वासो जोगी नि समजी जांदी? ");
INSERT INTO bfz_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“मैं बी सोचेया था कि यीशु नासरियो रे नाओं रे बिरोदो रे माखे बऊत कुछ करना चाईयो। ");
INSERT INTO bfz_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","और मैं यरूशलेमो रे एड़ा ई कित्तेया और बड़े पुरोईता ते अक्क पाई की बऊत सारे पवित्र लोक जेला रे पाए और जेबे सेयो काए जाओ थे, तो आऊँ बी तिना रे बिरोदो रे आपणी सलाह देऊँ था। ");
INSERT INTO bfz_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","आऊँ हर प्रार्थना रे कअरो रे तिना खे कूटी-कूटी की यीशुए री निन्दा करवाऊँ था, एथो तक कि रोषो रे मारे इतणा पागल ऊईगा कि बारले नगरो रे जाई की बी तिना खे सताऊँ था। ");
INSERT INTO bfz_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“एसी धुना रे जेबे आऊँ बड़े पुरोईता ते अक्क और आज्ञा-पत्र लयी की दमिश्को नगरो खे जाणे लगी रा था, ");
INSERT INTO bfz_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","तेबे ओ राजा! बाटा रे त्याड़िया जे, मैं सर्गो ते एक सूरजो री चमका ते बी बढ़ी की एक जोति आपू पाँदे और साथे चलणे वाल़ेया रे चऊँ कनारे चमकदी ऊई देखी। ");
INSERT INTO bfz_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","और जेबे आसे सब जमीना पाँदे रूड़ी गे, तेबे मैं इब्रानी पाषा (भाषा) रे मां साथे बोलदे ऊए ये शब्द सुणेया, ‘ओ शाऊल! ओ शाऊल! तूँ माखे कऊँ सताणे लगी रा? पईने पाँदे लाते बाणी ईदे तेरा ई नुकशाण ए।’ ");
INSERT INTO bfz_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","मैं बोलेया, ‘ओ प्रभु! तूँ कुण ए?’ प्रभुए बोलेया, ‘आऊँ यीशु ए, जेसखे तूँ सताएया। ");
INSERT INTO bfz_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","पर तूँ उठ, आपणे पैरा पाँदे खड़ा ओ, कऊँकि मैं ताखे इजी री खातर दर्शन देई राखेया, ताकि ताखे तिना गल्ला रा सेवक और गवा ठराऊँ, जो तैं देखी राखिया और तिना रा बी, जिना री तंईं मां ताखे दर्शन देणा ");
INSERT INTO bfz_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","यहूदियो और दुजिया जातिया ते, जिना बीचे आँऊ ताखे पेजणे लगी रा मां तूँ तिना ते बचाणा। ");
INSERT INTO bfz_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ताकि तूँ तिना री आखी खोल, ताकि सेयो न्हेरे ते जोतिया री तरफा खे और शैतानो रे अक्को ते परमेशरो रे राज्य री तरफा खे फिरो। ताकि सेयो पापो री माफी और तिना लोका साथे जो मां पाँदे विश्वास करने ते पवित्र कित्ते रे ए, जायदात पाओ।’ ");
INSERT INTO bfz_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“तो ओ अग्रिप्पा राजा! मैं तेस स्वर्गिय दर्शनो री गल्ल मानी ली। ");
INSERT INTO bfz_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","पर पईले दमिश्क नगरो रे और तेबे यरूशलेमो रे रणे वाल़ेया खे, तेबे यहूदिया रे सारे देशो रे और दुजिया जातिया खे समजयांदा रया कि मन फिराओ और परमेशरो री तरफा खे फिरी की मन फिराणे जोगा काम करो। ");
INSERT INTO bfz_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","इना गल्ला री बजअ ते यहूदी माखे मन्दरो रे पकड़ने और काणे री कोशिश करो थे। ");
INSERT INTO bfz_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पर परमेशरो री मइरबानिया ते आऊँ आजो तक बणी रा और छोटे-बड़े सबी सामणे गवाई देऊँआ और तिना गल्ला खे छाडी की ओर कुछ नि बोलदा, जो भविष्यबक्ते और मूसे बी बोलेया कि ऊणे वाल़िया ए ");
INSERT INTO bfz_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","कि मसीह खे दु:ख ऊणा और तेस ई सबी ते पईले मरे देया बीचा ते जिऊँदे ऊई की यहूदी लोका बीचे और दुजिया जातिया बीचे जोतिया रा प्रचार करना।” ");
INSERT INTO bfz_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जेबे पौलुस ईंयां जवाब देणे लगी रा था, तेबे फेस्तुसे जोरे की बोलेया, “ओ पौलुस, तूँ पागल ऊईगा रा, जादा पढ़ाईये तूँ पागल बणाई ता दा।” ");
INSERT INTO bfz_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पर पौलुसे बोलेया, “ओ महाप्रतापी फेस्तुस! आऊँ पागल निए, पर सच्चाई और बुद्धि री गल्ल करूँआ। ");
INSERT INTO bfz_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","राजा बी जेस सामणे आऊँ निडर ऊई की बोलणे लगी रा, इना गल्ला खे जाणोआ और माखे विश्वास ए कि इना गल्ला बीचा ते कोई एसते छीपी दी निए, कऊँकि ये घटणा कोई कूणे रे नि ऊई री। ");
INSERT INTO bfz_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ओ अग्रिप्पा राजा! क्या तूँ भविष्यबक्तेया पाँदे विश्वास करेया? आ, आऊँ जाणूंआ कि तूँ विश्वास करेया।” ");
INSERT INTO bfz_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","तेबे अग्रिप्पे पौलुसो खे बोलेया, “तूँ थोड़ा जा ई समजयाणे ते माखे मसीह बनाणा चाएया?” ");
INSERT INTO bfz_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुसे बोलेया, “मेरी परमेशरो ते ये प्रार्थना ए कि क्या थोड़े जे, क्या बऊत जे, बस तूँई नि, पर जितणे लोक आज मेरी सुणने लगी रे, इना बन्दना खे छाडी की सेयो मां जेड़े मसीह बणी जाओ।” ");
INSERT INTO bfz_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तेबे राजा, हाकिम और बिरनिके और तिना साथे बैठणे वाल़े खड़े ऊईगे ");
INSERT INTO bfz_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","और लग जे जाई की आपू बीचे बोलणे लगे, “ये मांणू एड़ा कुछ तो नि करदा, जो मौत या फसणे जोगा ओ।” ");
INSERT INTO bfz_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पे फेस्तुसो खे बोलेया, “जे ये मांणू कैसरो री दुहाई नि देंदा, तो छूटी सको था।” ");
INSERT INTO bfz_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जेबे फेस्तुस राज्यपालो खे ये पक्का निश्चा ऊईगा कि आसे जाह्जो रे इटलिया प्रदेशो रे रोम नगरो खे जाईए, तो तेबे तिने पौलुस और कुछ ओर कैदी बी यूलियुस नाओं री महाराजा अगुस्तुसो री पल़टणा रे एक सूबेदारो रे आथो रे देई ते। ");
INSERT INTO bfz_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अद्रमुत्तियुमो नगरो रे एक जाह्जो पाँदे, जो आसिया प्रदेशो रे कनारे री जगा रे जाणे वाल़ा था, चढ़ी की आसे से खोली ता और अरिस्तर्खुस नाओं रा एक मांणू आसा साथे था जो मकिदुनी प्रदेशो रे थिस्सलुनीके नगरो रा रणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दूजे दिने आसे सैदा नगरो रे पऊँछे और यूलियुसे पौलुसो पाँदे कृपा करी की से साथिया गे जाणे दित्तेया ताकि से तिना ते जरूरी चीजा ली आओ। ");
INSERT INTO bfz_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","तेथा ते आसे लोके दुबारा यात्रा शुरू कित्ती। उल्टी अवा चलणे री बजअ ते आसे साइप्रसो टापूए री आड़ा रिये चले ");
INSERT INTO bfz_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","और किलिकिया और पंफूलिया नगरो रे नेड़े समुद्रो रे ऊई की लूसिया प्रदेशो रे मूरा नगरो रे उतरे। ");
INSERT INTO bfz_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","तेती सूबेदारो खे सिकन्दरिया नगरो रा एक जाह्ज इटलिया प्रदेशो खे जांदा ऊआ मिलेया और तिने आसे तिदे चढ़ाई ते। ");
INSERT INTO bfz_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","जेबे आसे बऊत दिन तक, आऊल़े-आऊल़े चली की मुश्किला ते कनिदुस नगरो रे सामणे पऊँछे, तो तेबे कऊँकि अवा आसा खे आगे जाणे नि देओ थी, आसे सलमोने रे सामणे ते ऊई की क्रेते टापूए री आड़ा रे चले ");
INSERT INTO bfz_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","और तिजी रे कनारे-कनारे पाँदे मुश्किला ते चली की शुभ लंगरबारी नाओं री एक जगा रे पऊँछे, जेथा ते लसया नगर नेड़े था। ");
INSERT INTO bfz_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","जेबे बऊत दिन बीती गे और जलयात्रा रे मुसीबत तेबे ओ थी, कऊँकि बअरतो रे दिन एबे बीती गे थे। तेबे पौलुसे सेयो ये बोली की समजयाए, ");
INSERT INTO bfz_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ओ सज्जनो! माखे एड़ा लगोआ कि एसा यात्रा रे विपदा और बऊत नुकशाण, माल और जाह्जो रा ई नि, बल्कि म्हारे प्राणो रा बी ऊणे वाल़ा ए।” ");
INSERT INTO bfz_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पर सूबेदारे पौलुसो री गल्ला ते बढ़ी की कप्तान और जाह्जो रे मालको री गल्ल मानी। ");
INSERT INTO bfz_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","से बन्दरगाह ठण्ड बिताणे खे ठीक नि थी, इजी री खातर बऊत जणेया रा बिचार ऊआ कि जे तेथा ते जाह्ज खोली की जे किंयाँ बी ऊई सको, तो फीनिक्सो रे पऊँछी की ठण्ड बिताईये। ये तो क्रेते टापूए री एक बन्दरगाह ए, जो दक्खण-पच्छम और उत्तर-पच्छमो री तरफा खे खुलोआ। ");
INSERT INTO bfz_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जेबे कुछ-कुछ दक्खण री अवा चलणे लगी, तेबे ये समजी गे कि आसा रा मतलब पूरा ऊईगा, आसे लंगर चकेया और कनारे पाँदिए क्रेते टापूए रिये जाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पर थोड़ी देर बाद जमीना री तरफा ते बऊत बड़ा तूफान आईगा, जेतेखे यूरकुलीन बोलोए। ");
INSERT INTO bfz_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जेबे तूफान जाह्जो साथे टकराया, तेबे जाह्ज तेस सामणे ठईरी नि सकेया, तेबे आसे से हड़ने दित्तेया और ईंयां ई हड़दे ऊए चली गे। ");
INSERT INTO bfz_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तेबे कौदा नाओं रे एक छोटे जे टापूओ री आड़ा रे हड़दे-हड़दे, बड़ी मुश्किला साथे डोंगिया खे वशो रे करी सके। ");
INSERT INTO bfz_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","तेबे मल्लाहे से चकी की बऊत तरीके करी की जाह्ज थालो ते बानेया और सुरतिस खाड़िया रे चोरबालूओ पाँदे फसणे रे डरो ते तिने लंगरो खे थोड़ा थाले ऊतारी की जाह्ज अवा साथे-साथे हड़ने खे छाडीता। ");
INSERT INTO bfz_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","जेबे आसे तूफानो ते बऊत छूनके और ताक्के खाए, तेबे दूजे दिने सेयो जाह्जो रा माल सेटणे लगे ");
INSERT INTO bfz_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","और तीजे दिने तिने आपणे आथो साथे जाह्जो रा साज़ समान बी सेटी ता। ");
INSERT INTO bfz_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","जेबे बऊत दिन तक ना सूरज दिशेया और ना तारे और बड़ा तूफान चलदा रया, तेबे आखरी रे आसा रे बचणे री उम्मीद बी जांदी रई। ");
INSERT INTO bfz_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जेबे सेयो बऊत दिन तक पूखे रई चुके, तेबे पौलुसे तिना बीचे खड़े ऊई की बोलेया, “ओ लोको! तुसा खे चाईयो था कि तुसे मेरी गल्ल मानी की क्रेते टापूए ते जाह्ज नि खोलदे और ना ई बिपदा आऊँदी और ना ई ये नुकशाण ऊँदा। ");
INSERT INTO bfz_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","पर एबे आऊँ तुसा खे समजयाऊँआ कि इम्मत राखो, कऊँकि तुसा बीचा ते केसी रे बी प्राणो रा नुकशाण नि ऊणा, पर सिर्फ जाह्जो रा। ");
INSERT INTO bfz_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","कऊँकि परमेशर जेसरा आऊँ ए और जेसरी सेवा करूँआ, तेसरे स्वर्गदूते आज राती मांगे आयी की बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ओ पौलुस! डर नि, तेरा कैसरो रे सामणे खड़ा ऊणा जरूरी ए, और देख परमेशरे तां पाँदे कृपा करी की सबी खे जो तां साथे यात्रा करोए, ताखे देईते रे। ");
INSERT INTO bfz_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","इजी री खातर ओ सज्जनो! इम्मत राखो, कऊँकि आऊँ परमेशरो पाँदे विश्वास राखूँआ कि जेड़ा मांगे बोली राखेया, तेड़ा ई ऊणा। ");
INSERT INTO bfz_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","पर आसा खे केसी टापूओ रे जाई की टिकणा चाईयो।” ");
INSERT INTO bfz_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जेबे चऊदवीं रात आयी और आसे अद्रिया समुद्रो रिये पटकदे फिरने लगी रे थे, तेबे आदिया राती रे नेड़े मल्लाहे अनुमानो ते जाणेया कि आसे केसी देशो रे नेड़े पऊँछणे लगी रे। ");
INSERT INTO bfz_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","थाह लयी की तिने सैंती मीटर डूगा पाया और थोड़ा जा आगे चली की फेर थाह लयी, तेबे सताई मीटर डूगा पाया। ");
INSERT INTO bfz_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तेबे पात्थरो वाल़ी जगा रे टकराणे रे डरो ते तिने जाह्जो री पिछाड़िया रे चार लंगर बाए और प्याग न्याल़ने री कामना करदे रये। ");
INSERT INTO bfz_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","पर जेबे मल्लाह जाह्जो ते नठणा चाओ थे और तिने जाह्जो रे सामणे री तरफा ते लंगर पाणे रे बाने रे डोंगी समुद्रो रे ऊतारी ती। ");
INSERT INTO bfz_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","तेबे पौलुसे सूबेदार और सिपाईया खे बोलेया, “इना रा जाह्जो रे रणा जरूरी ए तेबे तुसे बची सकोए।” ");
INSERT INTO bfz_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तेबे सिपाईए रस्से बाडी की डोंगी रुड़ाई ती। ");
INSERT INTO bfz_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जेबे प्याग ऊणे वाल़ी थी, तेबे पौलुसे ये बोली की सब रोटी खाणे खे समजयाए, “आज चौदा दिन ऊईगे कि तुसे उम्मीद देखदे-देखदे रये और बिल्कुल रोटी नि खाई। ");
INSERT INTO bfz_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","इजी री खातर आऊँ तुसा खे बोलूँआ कि सब रोटी खाई लो जेते साथे तुसा रा बचाव ओ, और तुसे सब बिल्कुल ठीक-ठाक रणे।” ");
INSERT INTO bfz_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ये बोली की तिने रोटी लयी की सबी सामणे परमेशरो रा धन्यवाद करी की तोड़ी और खाणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","तेबे सेयो सब बी इम्मत बानी की रोटी खाणे लगे। ");
INSERT INTO bfz_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","आसे सब मिली की जाह्जो रे दो सौ छयात्तर जणे थे। ");
INSERT INTO bfz_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जेबे सेयो रोटी खाई की रजी गे तेबे कणक समुद्रो रे सेटी की जाह्ज अल़का करने लगे। ");
INSERT INTO bfz_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जेबे दिन ऊआ, तेबे तिने से देश नि पछयाणेया, पर एक खाड़ी देखी, जेतेरा कनारा चौरस था और सोचेया कि जे ऊई सको तो एते पाँदे ई जाह्जो खे टिकाऊँए। ");
INSERT INTO bfz_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तेबे तिने लंगर खोली की समुद्रो रे छाडीता और तेबुई पतवारा रे रस्से खोली ते और अवा रे सामणे आगला पाल चड़ाई की कनारे पाँदो खे चले। ");
INSERT INTO bfz_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","पर जेती दो समुद्रो रे संगमो री जगा पड़ो थी, तेती तिने जाह्ज टिकाया, तेबे तिजी रा आगला इस्सा तो ताक्का खाई की दबी गी और टल़ी नि सकी, पर पिछला इस्सा लईरा रे जोरो ते टूटणे लगेया। ");
INSERT INTO bfz_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तेबे सिपाईए सोचेया कि कैदिया खे काई देऊँए, केथी एड़ा नि ओ कि कोई तरी की नठी जाओ। ");
INSERT INTO bfz_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पर सूबेदारे पौलुसो खे बचाणे री खातर सेयो एड़ा करने ते रोके और बोलेया कि जो तरी सकोए, सेयो पईले ई छवाल़ लयी की कनारे पाँदे निकल़ी जाओ ");
INSERT INTO bfz_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","और बाकी कोई पाटड़ेया पाँदे और कोई जाह्जो री ओरी केसी चीजा रे साअरे निकल़ी जाओ। ईंयां सब बची की जमीना पाँदे बची की निकल़ी गे। ");
INSERT INTO bfz_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जेबे आसे सब यात्री कनारे पाँदे ठीक-ठाक पऊँछी गे, तेबे आसा खे पता लगेया कि एस टापूओ खे माल्टा बोलोए। ");
INSERT INTO bfz_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","तेथो रे रणे वाल़े लोके आसा पाँदे नऊखा प्यार दखाया, कऊँकि बादल़ बरसणे री बजअ ते ठण्ड थी, तेबे तिने आग सुल़गाई की आसे सब ठराए। ");
INSERT INTO bfz_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जेबे पौलुसे लकड़ुआ रा पारा (गट्ठा) कट्ठा करी की आगी पाँदे राखेया, तेबे एक साप आगी रे सेको रे निकल़ेया और तेसरे आथो रे लिपटी गा। ");
INSERT INTO bfz_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जेबे तेथो रे रणे वाल़ेया साप तेसरे आथो रे लटकेया रा देखेया, तेबे आपू बीचे बोलेया, “सच्ची ये मांणू अत्यारा ए, हालाँकि समुद्रो ते बची गा, पर तेबे बी न्यायी देविए जिऊँदा नि रणे दित्तेया।” ");
INSERT INTO bfz_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","पौलुसे साप आगी रे चड़ाकी ता और तेसखे कोई नुकशाण नि ऊआ। ");
INSERT INTO bfz_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","पर सेयो लोक न्याल़दे रये कि तेसरे सोजा आयी जाणा या एकदम रूड़ी की मरी जाणा, पर जेबे सेयो बऊत देर तक देखदे रये कि एसरा कुछ नि बिगड़ेया, तेबे तिने ओर ई बिचार कित्तेया और बोलेया, “ये तो कोई देवता ए।” ");
INSERT INTO bfz_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","तेसा जगा रे नेड़े-तेड़े तेस टापूओ रे प्रदान पुबलियुसो री जमीन थी। तिने आसे आपणे कअरे दोस्ता जेड़े निए और तीन दिन तक प्यारो साथे पराऊणचारी कित्ती। ");
INSERT INTO bfz_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुबलियुसो रा पिता बुखार और खूनो री आंवा रा रोगी था, तेबे पौलुसे तेसरे कमरे रे जाई की तेसखे प्रार्थना कित्ती और तेस पाँदे आथ राखी की से ठीक कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","जेबे एड़ा ऊआ, तेबे तेस टापूओ रे बाकी बमार बी पौलुसो गे आईगे और तिने सेयो ठीक कित्ते। ");
INSERT INTO bfz_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","तिने आसा री बऊत आओ-बैठ कित्ती और जेबे आसे तेथा ते तीन मीन्ने बाद चलणे लगे, तेबे जो कुछ आसा खे जरूरी था, से जाह्जो पाँदे राखी ता। ");
INSERT INTO bfz_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","तीन मीन्ने ते बाद आसे सिकन्दरिया रे एक जाह्जो पाँदे चली पड़े, जो तेस टापूओ पाँदे ठण्ड पड़ने री बजअ ते रूकेया रा था। तेते जाह्जो रे आगले इस्से पाँदे एक जोड़ी देवतेया री मूरत दियुसकूरी गढ़ी री थी। ");
INSERT INTO bfz_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","सुरकूसा नगरो रे लंगर पाई की आसे तेती तीन दिन तक रये। ");
INSERT INTO bfz_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","तेथा ते आसे कूमी की रेगियुम नगरो रे आए और एक दिन बाद दक्खणो ते अवा चली, तेबे आसे दूजे दिने पुतियुले नगरो रे आए। ");
INSERT INTO bfz_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","तेती आसा खे विश्वासी पाई मिले और तिना रे बोलणे पाँदे आसे तिना रे कअरे सात दिन तक रये और तेबे रोमो खे चली गे। ");
INSERT INTO bfz_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","रोमो ते कुछ विश्वासी पाई आसा रा समाचार सुणी की कि आसे तेती आऊणे लगी रे सेयो अप्पियुसो रे चौको रे और तीन सराँए तक आसा खे मिलणे खे आए, जिना खे देखी की पौलुसे परमेशरो रा धन्यवाद कित्तेया और इम्मत बानी। ");
INSERT INTO bfz_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जेबे आसे रोम नगरो रे पऊँछे, तेबे पौलुसो खे एक सिपाईए साथे, जो तेसरी रखवाल़ी करो था, कल्ले रणे री आज्ञा मिली। ");
INSERT INTO bfz_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीन दिना ते बाद तिने यहूदिया रे खास लोक बुलाए और जेबे सेयो कट्ठे ऊए तो तिना खे बोलेया, “ओ पाईयो, मैं आपणे लोका रे या आपणे बाप-दादेया रे व्यवहारो रे बिरोदो रे कुछ नि बोलेया, तेबे बी कैदी बणाई की यरूशलेमो ते रोमी सरकारा रे आथो रे सम्बाल़ी ता। ");
INSERT INTO bfz_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","तिने आऊँ परखी की छाडणा चाया, कऊँकि मांदे मृत्यु-दण्डो जोगा कोई दोष नि था। ");
INSERT INTO bfz_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पर जेबे यहूदी अगुवे इजी रे बिरोदो रे बोलणे लगे, तेबे माखे कैसरो ते विनती करनी पड़ी, ये सोची की नि कि मां आपणे लोका पाँदे कोई दोष लगाणा था। ");
INSERT INTO bfz_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","इजी री खातर मैं तुसे बुलाई राखे ताकि तुसा साथे मिलूँ और बातचीत करुँ, कऊँकि इस्राएलो री उम्मीदा खे आऊँ इना जंजीरा रे जकड़ी रा।” ");
INSERT INTO bfz_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","तिने तेसखे बोलेया, “ना आसा खे तेरे बारे रे यहूदिया प्रदेशो ते चिट्ठिया मिलिया और ना ई विश्वासी पाईया बीचा ते आयी की किने तेरे बारे रे कुछ बताया और ना ई बुरा बोलेया। ");
INSERT INTO bfz_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पर तेरा बिचार क्या ए? सेई आसा तांते सुणना चाऊँए, कऊँकि आसे जाणूंए कि हर जगा रे एस मतो रे बिरोदो रे लोक गल्ला करोए।” ");
INSERT INTO bfz_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तेबे तिने पौलुसो खे एक दिन ठराया और बऊत लोक तेसरे गे कट्ठे ऊए और से परमेशरो रे राज्य री गवाई देंदा ऊआ और मूसे रा बिधान और भविष्यबक्तेया री कताबा ते प्रभु यीशुए रे बारे रे समजयाई-समजयाई की प्यागा ते साँजा तक बोलदा रया। ");
INSERT INTO bfz_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","तेबे कुछ जणेया सेयो गल्ला मानी लईया और कुछ जणेया विश्वास नि कित्तेया जो पौलुसे बोलिया थिया। ");
INSERT INTO bfz_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","जेबे सेयो आपू बीचे एक मत नि ऊए, तेबे पौलुसो री एसा एक गल्ला बोलणे पाँदे चली गे, “पवित्र आत्मे यशायाह भविष्यबक्ते रे जरिए तुसा रे बाप-दादेया खे ठीक ई बोलेया, ");
INSERT INTO bfz_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“जाई की इना लोका खे बोल कि सुणदे तो रणे, पर समजणे नि और देखदे तो रणे, पर दिशणा नि। ");
INSERT INTO bfz_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","कऊँकि इना लोका रा मन मोटा और तिना रे कान पारी ऊईगे रे और तिने आपणी आखी बंद करी ती रिया, एड़ा नि ओ कि सेयो कदी आखी ते देखो और कानो ते सुणो और मनो ते समजो और फिरो और आऊँ तिना खे ठीक करुँ। ");
INSERT INTO bfz_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“तेबे तुसे जाणो कि परमेशरो रे एस उद्धारो री कथा दुजिया जातिया गे पेजी ती री और तिना सुणनी।” ");
INSERT INTO bfz_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जेबे तिने ये बोलेया तो यहूदी आपू बीचे बऊत बईस करने लगे और तेथा ते चली गे। ");
INSERT INTO bfz_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","से पूरे दो साल तक आपणे खर्चे रे कअरो रे रया ");
INSERT INTO bfz_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","और जो तेसगे आओ थे, तिना सबी ते मिलदा रया और बिना रोका-टोका ते बऊत निडर ऊई की परमेशरो रे राज्य रा प्रचार करदा ऊआ और प्रभु यीशु मसीह री गल्ला सिखांदा रया।");
INSERT INTO bfz_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","आँऊ पौलुस एसा चिट्ठिया खे लिखणे लगी रा जो यीशु मसीह रा दास ए। परमेशरे आँऊ प्रेरित ऊणे खे चुणी राखेया। तिने आँऊ सुसमाचारो रा प्रचार करने खे लग करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","परमेशरे पईले तेई आपणे भविष्यबक्ताओं रे जरिए पवित्र शास्त्रो रे एस सुसमाचारो री प्रतिज्ञा कित्ती थी। ");
INSERT INTO bfz_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ये सुसमाचार आपणे पुत्र आसा रे प्रभु यीशु मसीह रे बारे रे था। से शरीरो रे मुताबिक तो राजा दाऊदो रे वंशो ते जम्मेया, ");
INSERT INTO bfz_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","और पवित्र आत्मा री सामर्था ते से मरे रेया बीचा ते जिऊँदा ऊआ। इजी ते ये साबित ऊआ कि से परमेशरो रा पुत्र ए और सेई यीशु मसीह आसा रा प्रभु ए। ");
INSERT INTO bfz_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","यीशु मसीह रे जरिए माखे कृपा और प्रेरिताईया रा काम मिलेया, ताकि तेसरे नाओं री बजअ ते सब जातिया रे लोक सुसमाचारो पाँदे विश्वास करो और तेसरी आज्ञा मानो। ");
INSERT INTO bfz_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","जिना बीचा ते तुसे बी ओ, जिना खे परमेशरे प्रभु यीशु मसीह रे लोक ऊणे खे बुलाई राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","आँऊ ये चिट्ठी तुसा सबी लोका खे लिखणे लगी रा जो रोम नगरो रे परमेशरो रे प्यारे ए और आपणे पवित्र लोक ऊणे खे बुलाई राखे, आसा रे पिता परमेशर और प्रभु यीशु मसीह री तरफा ते तुसा खे कृपा और शान्ति मिलदी रओ। ");
INSERT INTO bfz_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","पईले आऊँ तुसा सबी खे प्रभु यीशु मसीह रे जरिए आपणे परमेशरो रा धन्यवाद करूँआ, कऊँकि यीशु मसीह रे तुसा रे विश्वासो री चर्चा सारी दुनिया रे ऊणे लगी रिया। ");
INSERT INTO bfz_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","परमेशर, जेसरी सेवा आऊँ आपणे पूरे मनो ते तेसरे पुत्रो रे सुसमाचारो रे बारे रे करूँआ, सेई मेरा गवा ए कि आऊँ आपणी प्रार्थना रे तुसा लोका खे लगातार याद करदा रऊँआ। ");
INSERT INTO bfz_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","और हर रोज आपणी प्रार्थना रे बिनती करूँआ कि परमेशरो री इच्छा रे मुताबिक माखे आखरी रे तुसा लोका गे आऊणे रा मौका मिलो। ");
INSERT INTO bfz_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","कऊँकि आऊँ तुसा खे मिलणे री बड़ी इच्छा करूँआ, ताकि आऊँ तुसा खे कोई आत्मिक बरदान देऊँ, जेते कि तुसे विश्वासो रे मजबूत ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","मेरा मतलब ये कि आऊँ तुसा खे और तुसे माखे आपू बीचे एक दूजे खे विश्वासो रे मजबूत करिए। तुसे मजबूत ऊई जाणे कऊँकि तुसे जाणोए कि मैं किंयाँ विश्वास कित्तेया और आँऊ मजबूत ऊई जाणा कऊँकि आँऊ जाणूंआ ए कि तुसे किंयाँ विश्वास करोए। ");
INSERT INTO bfz_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ओ साथी विश्वासियो! आऊँ नि चांदा कि तुसे इजी ते अणजाण रओ कि मैं बार-बार तुसा गे आऊणा चाया पर एबुए तक आँऊ रोकी की राखी राखेया। आँऊ चाऊँआ कि जेड़े मैं दूजी कई जगा रे दुजिया जातिया रे मसीह रे चेले बणाए, तेड़े ई रोमो रे तुसा बीचे मसीह रे चेले बणाई सकूँ। ");
INSERT INTO bfz_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","आऊँ आपणे आपू खे यूनानी पाषा बोलणे वाल़ेया रा और अन्यभाषिया रा, अक्लमंद और मूर्खा खे सुसमाचारो रा प्रचार करने खे कर्जदार ए। ");
INSERT INTO bfz_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","तो तेबे आऊँ तुसा खे बी जो रोम नगरो रे रओए, सुसमाचार सुनाणे खे त्यार ए। ");
INSERT INTO bfz_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","कऊँकि आऊँ मसीह रे बारे रे एस सुसमाचारो ते शर्मांदा निए। ये तिना सबी खे उद्धारो रे निमित परमेशरो री सामर्थ ए, सबी ते पईले यहूदिया खे तिजी ते बाद दूजी जातिया खे जो एस सुसमाचारो पाँदे विश्वास करोए। ");
INSERT INTO bfz_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","कऊँकि सुसमाचारो रे परमेशरो री धार्मिकता विश्वासो ते और विश्वासो खे प्रगट ओई, जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “विश्वासो रे जरिए तर्मी मांणू जिऊँदा रणा।” ");
INSERT INTO bfz_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेशरो रा रोष तो तिना सबी री अभक्ति और पापो पाँदे जो लोक करोए स्वर्गो ते प्रगट ओआ, जो सच्चो खे पापो रे कामो ते दबाई की राखोए। ");
INSERT INTO bfz_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","इजी खे परमेशरो रे बारे रे ज्ञान तिना रे मनो रे प्रगट ए, कऊँकि परमेशरे तिना पाँदे प्रगट करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","परमेशरो रे अणदेखे गुण, मतलब तेसरी सनातन सामर्थ और परमेशरो री तागत दुनिया री सृष्टिया रे बखतो ते, तेसरे कामे की देखणे रे आओए। इजी खे तिना लोका गे आपणे आपू खे बचाणे खे कोई जवाब निए, “आसे परमेशरो खे नि जाणदे।” ");
INSERT INTO bfz_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","कऊँकि तिने परमेशरो खे जाणदे ऊए बी परमेशरो खे परमेशरो जोगा आदर और धन्यवाद नि कित्तेया। इजी रे बदले सेयो लोक बेकारो रे सोचणे लगे, एथो तक की तिना रे मूर्ख मनो रे न्हेरा ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","सेयो आपू खे अक्लमंद जताई की मूर्ख बणी गे। ");
INSERT INTO bfz_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","और तिने अविनाशी महिमामय परमेशरो री आराधना छाडी की नाशवान मांणू, पंछी, जानवर और लूरने वाल़े जन्तुआ री मूर्तिया री आराधना कित्ती। ");
INSERT INTO bfz_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","इजी री बजअ ते परमेशरे सेयो तिना रे शरीरो री पापमय इच्छा रे मुताबिक यौन अशुद्धता खे छाडी ते ताकि सेयो आपू बीचे बुरे कामो रे जरिए आपणे शरीरो रा अनादर करो। ");
INSERT INTO bfz_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","तिने परमेशरो री सच्चाईया रे बारे रे विश्वास करने ते ना कित्ती और चूठो पाँदे विश्वास कित्तेया। तिने परमेशरो रे बजाये तिना रे जरिए बणाई री सृष्टिया री पूजा और सेवा कित्ती, जो सदा धन्य ए। आमीन्। ");
INSERT INTO bfz_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","इजी री खातर परमेशरे सेयो निर्लज्ज वासनाओं रे वशो रे छाडी ते। एथो तक कि तिना री जवाणसे बी आपणा कुदरती यौन सम्बन्ध छाडी की तिजी खे जो सबाओ रे खलाफ ए, बदली ता। ");
INSERT INTO bfz_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","तिंयाँ ई मर्द बी जवाणसा साथे कुदरती मेलजोल छाडी की आपू बीचे कामातुर ऊई की जल़ने लगे और मर्दे, मर्दा साथे बेशर्म काम करी की आपू पाँदे बुरे कामा री सजा रा ठीक फल पाया। ");
INSERT INTO bfz_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","इजी ते बाद बी तिने ये ठीक नि समजेया कि परमेशरो रे सारे ज्ञानो खे मानो। तो परमेशरे बी सेयो सब गल़त काम करने खे तिना रे नक्कमे मनो रे वशो रे छाडी ते। ");
INSERT INTO bfz_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","सेयो सबी प्रकारा रे पाप, दुष्टता, लोब, बैरभावो ते परी गे और जल़न, अत्या, चगड़े, छल और ईर्ष्या ते परी गे और चूगलखोर, ");
INSERT INTO bfz_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","बदनाम करने वाल़े, परमेशरो ते करीणा करने वाल़े, ओरी रा अनादर करने वाल़े, कमण्डी, त्वाल़िया देणे वाल़े, बुरिया-बुरिया गल्ला बनाणे वाल़े, माया-बाओ रा कईणा ना मानणे वाल़े, ");
INSERT INTO bfz_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","निर्बुध्दि, विश्वासघाती, दयारहित और निर्दयी ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","सेयो परमेशरो री ये तर्मो री बिधि जाणोए कि एड़े-एड़े काम करने वाल़ेया खे मौता री सजा मिलणी, तेबे बी ना सिर्फ आपणे आपू ई एड़े काम करोए, बल्कि करने वाल़ेया ते बी खुश ओ ए। ");
INSERT INTO bfz_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","तुसा खे लगोआ कि तुसे एड़े लोका पाँदे दोष लगाई सकोए पर ओ दोष लगाणे वाल़ो! तूँ जो दूजेया पाँदे दोष लगाएया तांगे कोई बाह्ना निए। कऊँकि जेसा गल्ला रा तूँ दूजे पाँदे दोष लगाएया, तेसी गल्ला रे आपणे आपू खे बी दोषी बणाएया, इजी री खातर, जो तूँ दोष लगाएया, आपू बी तिना ई कामा करेया। ");
INSERT INTO bfz_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","और आसे जाणूंए कि एड़े-एड़े काम करने वाल़ेया पाँदे परमेशरो री तरफा ते ठीक-ठीक दण्डो री आज्ञा ओई ");
INSERT INTO bfz_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","और ओ मांणू! तूँ जो एड़े-एड़े काम करने वाल़ेया पाँदे दोष लगाएया और आपू तेड़े ई काम करेया, क्या समजेया कि तूँ परमेशरो रे दण्डो ते बची जाणा? ");
INSERT INTO bfz_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","क्या तूँ परमेशरो री पलाई, सईन शीलता और धीरजरूपी दौलता खे तुच्छ जाणोआ? और क्या ये नि समजदा कि परमेशरो री कृपा ताखे मन फिराणे री तरफा खे लई जाओई? ");
INSERT INTO bfz_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","पर तुसे टीठ मनो रे ए और आपणे बुरे कामा ते मन फिराणे ते मना करी देओए। एड़ा करी की तुसे आपू खे बऊत पारी सजा कट्ठी करने लगी रे। रोषो रा दिन आऊणे वाल़ा ए जिदे परमेशरो री धार्मिकता रा न्याय प्रकट ऊणा। ");
INSERT INTO bfz_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेशरो हर एकी खे तेसरे कामो रे मुताबिक प्रतिफल देणा। ");
INSERT INTO bfz_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जो लोक खरे कामो रे खड़े रई की महिमा, आदर और अमरता री टोल़ा रे, तिना खे परमेशरो अनन्त जीवन देणा। ");
INSERT INTO bfz_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","पर जो स्वार्थी ए और सच्चो खे नि जाणदे, बल्कि बुरे काम करोए, तिना पाँदे परमेशरो रा रोष और कोप पड़ना। ");
INSERT INTO bfz_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","और क्ल़ेश और संकट हर एकी मांणूए रे प्राणो पाँदे, जो बुरा करोआ, आऊणा। परमेशरो सबी ते पईले यहूदिया रा न्याय करना और तिजी ते बाद दूजिया जातिया रा न्याय करना। ");
INSERT INTO bfz_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","पर महिमा, आदर और शान्ति हर एकी खे मिलणी, जो पला करोआ, पईले यहूदिया खे मिलणी, तेबे दूजिया जातिया खे। ");
INSERT INTO bfz_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","कऊँकि परमेशर केसी रा पक्ष नि करदा। ");
INSERT INTO bfz_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","कऊँकि जिने बिना मूसे रा बिधान पाए, पाप कित्तेया, तिना खे बिना मूसे रा बिधानो तेई सजा मिलणी और यहूदी जिने मूसे रा बिधान पाई कि पाप कित्तेया, तिना रा न्याय मूसे रा बिधानो रे मुताबिक ई ऊणा। ");
INSERT INTO bfz_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","कऊँकि परमेशरो रे एती बिधानो खे सुणने वाल़े तर्मी निए, पर बिधानो पाँदे चलणे वाल़े तर्मी ठराए जाणे। ");
INSERT INTO bfz_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","तेबे, जेबे दूजी जातिया रे लोक, जिना गे मूसे रा बिधान निए, सबाओ तेई बिधानो री गल्ला पाँदे चलोए और मूसे रा बिधान तिना गे ना ऊणे पाँदे बी, सेयो ये सिद्ध करी देओए की तिना रे मनो रे एक बिधान ए ");
INSERT INTO bfz_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","सेयो परमेशरो रे बिधानो रिया गल्ला आपणे दिलो रे लिखी रिया दखाओए। तिना रे विवेक बी गवाई देओए। तिना रे बिचार तिना खे कदी दोष लगाओए तो कदी तिना खे निर्दोष ठराओए। ");
INSERT INTO bfz_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ये तेस दिने सपष्ट ऊई जाणा जेस दिने परमेशर मेरे सुसमाचारो रे मुताबिक यीशु मसीह रे जरिए मांणूआ री गुप्त गल्ला रा न्याय करोगा, ");
INSERT INTO bfz_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","आपणे बारे रे सोच जो तूँ आपू खे यहूदी समजेया और बिधानो पाँदे विश्वास राखेया और तूँ त्वाल़िया मारेया कि आँऊ परमेशरो रे खास जन ए। ");
INSERT INTO bfz_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","तुसे परमेशरो री इच्छा जाणोए और तुसे खरिया-खरिया गल्ला जाणोए कऊँकि तुसे यो सब गल्ला मूसे रा बिधानो ते सीखी राखिया। ");
INSERT INTO bfz_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","तुसा खे ये निश्चा ए कि तुसे अन्दे लोका खे पक्का ई बाट दखाई सकोए और जो न्हेरे रे पटकणे लगी रे तिना खे तुसे जोतिया जेड़े ए। ");
INSERT INTO bfz_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","तुसे सोचोए, “आँऊ मूर्खा खे सिखाणे वाल़ा और बाल़का रा उपदेशक ए।” तुसा खे निश्चा ए कि परमेशरो रा बिधान तुसा खे पुरा ज्ञान और सच्चाई देओआ। ");
INSERT INTO bfz_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","पर तूँ जो ओरी खे सिखाएया, आपणे आपू खे कऊँ नि सिखांदा? तूँ ओरी खे चोरी ना करने रा उपदेश दे आ और आपू ई चोरी करेया! ");
INSERT INTO bfz_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तूँ जो बोलेया, “व्याभिचार नि करना,” तो आपू ई व्याभिचार कऊँ करेया? तूँ जो मूर्तिया ते नफरत करेया, तो आपू ई कऊँ मन्दरा खे लूटोआ? ");
INSERT INTO bfz_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तूँ परमेशरो रा बिधानो रे बारे रे कमण्ड करेया और बिधानो खे ना मानी की परमेशरो रा नरादर कऊँ करेया। ");
INSERT INTO bfz_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","इजी खे जेड़ा कि पवित्र शास्त्रो रे लिखी राखेया, “तुसा लोका री बजअ ते दूजी जातिया बीचे परमेशरो रे नाओं री निन्दा ओई।” ");
INSERT INTO bfz_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","जे तूँ बिधानो पाँदे चले, तो खतने ते तो लाब ए, पर जे तूँ बिधानो खे नि माने, तो तेरा खतना बिना खतने जेड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","तेबे जे बिना खतने रा मांणू, परमेशरो रे बिधानो री बिधिया खे मानेया करो, तो क्या तेसरे बिना खतने री दशा, खतने रे बराबर नि गिणी जाणी? ");
INSERT INTO bfz_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","और जो मांणू शारीरिक रुपो ते बिना खतने ते परमेशरो रे बिधानो खे पूरा-पूरा मानोआ, तेस तुसे दोषी ठईराणे, कऊँकि तुसा गे परमेशरो रा लिखेया रा बिधान ए और खतना ऊँदे ऊए बी तुसे बिधानो खे नि मानदे। ");
INSERT INTO bfz_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","असली यहूदी से निए जेसरा सिर्फ बारला रूप यहूदिया जेड़ा ए और असली खतना से निए जो बारले रूपो ते सिर्फ शरीरो रे करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","पर यहूदी सेईए, जो मनो रे और खतना सेईए, जो पवित्र आत्मा रे जरिए दिलो रे कित्तेया जाओआ, ना कि लेखो खे मानणे ते, ईंयां ई तारीफ आपणिया तरफा ते नि, बल्कि परमेशरो री तरफा ते ओई। ");
INSERT INTO bfz_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","तो ओरी री बजाए यहूदिया खे जादा क्या मिलेया? और खतने ते क्या फायदा ऊआ? ");
INSERT INTO bfz_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","आ, हर प्रकारा ते बऊत कुछ फायदा ऊआ। सबी ते जरूरी तो ये कि परमेशरो रे वचन यहूदिया गे सम्बाल़ी ते। ");
INSERT INTO bfz_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","जे कुछ विश्वासघाती निकल़े बी तो क्या ऊआ? क्या तिना रे विश्वासघाती ऊणे ते परमेशरो रा कित्तेया रा वादा बेकार जाणा? ");
INSERT INTO bfz_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","कदी पनि! बल्कि परमेशर सदा सच बोलोआ और दुनिया रा हर मांणू चूठा ठईरी सकोआ, जेड़ा लिखी राखेया, “जेते कि तूँ आपणी गल्ला रे तर्मी बणो, और न्याय करदे ऊए तेरी जय ओ।” ");
INSERT INTO bfz_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","तेबे जे आसा रे बुरे काम परमेशरो री धार्मिकता दखाओई, तो आसे क्या बोलूँ? क्या ये कि परमेशर जो रोष करोआ, अन्यायी ए? ये तो आऊँ मांणूआ री रीतिया पाँदे बोलूँआ। ");
INSERT INTO bfz_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","कदी पनि। जे परमेशर अन्यायी ऊँदा तो तेस दुनिया रा न्याय किंयाँ करना? ");
INSERT INTO bfz_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","जे मेरे चूठो री बजअ ते, परमेशरो री सच्चाई तेसरी महिमा खे जादा करी की सामणे आयी, फेर कऊँ पापिया जेड़ा आऊँ दण्डो जोगा ओऊँआ। ");
INSERT INTO bfz_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","कुछ लोक ये बोलदे ऊए आसा पाँदे दोष लगाओ कि इने बोलेया, “आसा खे बुरे काम करने देओ ताकि कुछ पला ऊई जाओ!” जो लोक मेरे बारे रे एड़िया गल्ला बोलोए से सजा पाणे जोगे ए। ");
INSERT INTO bfz_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","तो फेर क्या ऊआ? क्या आसे यहूदी ओरी ते जादा खरे ए? कदी पनि। कऊँकि आसे यहूदी और यूनानी दूँईं पाँदे ये दोष लगाई चूके रे कि सेयो सब के सब पापो रे वशो रे ए। ");
INSERT INTO bfz_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “परमेशरो री नजरा रे कोई तर्मी निए, एक पनि। ");
INSERT INTO bfz_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोई समजदार निए, कोई बी परमेशरो खे टोल़ने वाल़ा निए। ");
INSERT INTO bfz_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सब परमेशरो ते दूर ऊईगे रे, सब के सब नक्कमे बणी गे रे, कोई पला करने वाल़ा निए, एक पनि। ");
INSERT INTO bfz_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","तिना रा गल़ा खुली री कब्र ए, तिने ई आपणी जीबा ते छल कित्तेया, तिना रे ओठा रे सापो जेड़ा विष निकल़ोआ। ");
INSERT INTO bfz_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","और तिना रा मूँ श्राप और कड़वाहटा ते फरे राए। ");
INSERT INTO bfz_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","तिना रे पैर खून करने खे फुर्तिले ए। ");
INSERT INTO bfz_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","तिना री बाटा रे नाश और क्ल़ेश ए। ");
INSERT INTO bfz_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","तिने शान्तिया री बाट नि जाणी। ");
INSERT INTO bfz_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","तिना रे परमेशरो रा डर अया ई नि।” ");
INSERT INTO bfz_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","आसे जाणूंए कि बिधान जो कुछ बोलोआ, तिना खेई बोलोआ, जो बिधानो रे अधीन ए, ताकि लोका खे बाह्ना बनाणे ते रोकणे खे हर एक मूँ बंद करेया जाओ और सारी दुनिया रे लोक परमेशरो रे सामणे दोषी ठईरो। ");
INSERT INTO bfz_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","कऊँकि बिधानो रे कामो ते कोई बी लोक परमेशरो रे सामणे तर्मी नि ऊणे, कऊँकि मूसे रा बिधान आसा खे दखाओआ कि आसे सब पापी ए। ");
INSERT INTO bfz_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","पर एबे मूसा रे बिधानो खे बिना माने परमेशरो री धार्मिकता प्रगट ऊई री। ये गल्ला मूसे रा बिधान और भविष्यबक्तेया री कताबा रे बऊत पईले तेई लिखी राखिया कि परमेशर आसा खे किंयाँ धार्मिक बणाओआ। ");
INSERT INTO bfz_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","मतलब-परमेशरो री से धार्मिकता, जो प्रभु यीशु मसीह पाँदे विश्वास करने ते, सब विश्वास करने वाल़ेया खे ए। यहूदी और दूजिया जातिया बीचे कुछ भेद निए। ");
INSERT INTO bfz_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","कऊँकि सबी पाप करी राखेया और परमेशरो री महिमा ते दूर ऊईगे रे। ");
INSERT INTO bfz_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","पर परमेशरो री कृपा ते तेस छुटकारे रे जरिए, जो यीशु मसीह रे ए, मुफ्तो रे तर्मी ठराए जाओए। ");
INSERT INTO bfz_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","परमेशरे यीशु मसीह खे आसा री खातर बलिदान ऊणे खे पेजेया। यीशु मसीहे आपणी जिन्दगिया रा बलिदान इजी खे दित्तेया ताकि आसे तेस पाँदे विश्वास करी की परमेशरो रे नेड़े जाई सकिए। बऊत पईले परमेशरे ये दखाणे खे कित्तेया कि से सईन शीलता दखाणे रे और पापिया खे माफ करने रे सई था। इजी ते ये बी पता चलोआ कि परमेशर सई ए, जेबे से तिना लोका खे अपणाओआ जो यीशुए पाँदे विश्वास करोए। ");
INSERT INTO bfz_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तो क्या एड़ा कुछ ए जेते कि आसे कमण्ड करी सकिए? तिजी खे तो कोई जगा ई निए, कुण जे नियमा री बजअ ते? क्या इजी खे कि आसे बिधानो खे मानूँए? ना, बल्कि यीशु मसीह पाँदे विश्वास करने री बजअ ते। ");
INSERT INTO bfz_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","इजी री खातर आसे एते नतीजे पाँदे पऊँछी रे कि मांणू बिधानो रे कामो ते बिना, विश्वासो रे जरिए तर्मी बणोआ। ");
INSERT INTO bfz_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","क्या परमेशर सिर्फ यहूदिया रा ईए? क्या दूजी जातिया रा निए? आ, दुजिया जातिया रा बीए। ");
INSERT INTO bfz_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","कऊँकि परमेशर एक ईए, जेस खतने वाल़े विश्वासो ते और बिना खतने वाल़े बी विश्वासो ते तर्मी ठराणे। ");
INSERT INTO bfz_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","तो क्या आसे बिधानो खे विश्वासो रे जरिए बेकार ठराऊँए? कदी पनि, बल्कि बिधानो खे स्थिर करूँए। ");
INSERT INTO bfz_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","एबे आसे आपणे पुर्वज अब्राहमो रे बारे क्या बोलिये? क्या तिना खे शरीरो री नजरा ते कुछ मिलेया या कृपा ते मिलेया? ");
INSERT INTO bfz_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","जे अब्राहम अच्छे कामो ते तर्मी ठराया जांदा, तो से आपू पाँदे कमण्ड करी सको था। पर से आपणे अच्छे कामा खे परमेशरो रे नेड़े कमण्ड नि करी सकदा। ");
INSERT INTO bfz_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","पवित्र शास्त्र क्या बोलोआ? “अब्राहमे परमेशरो पाँदे विश्वास कित्तेया और ये तेसखे धार्मिकता गिणी गयी।” ");
INSERT INTO bfz_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","काम करने वाल़ेया री मजदूरी देणा दान निए, पर अक्क समजेया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","से माणूं जो परमेशरो खे खुश करने खे बिधानो खे नि मानदा, बल्कि परमेशरो रे जो भक्तिहिनो खे तर्मी बणाओआ तिदे विश्वास करोआ, तो तेसरा ये विश्वास तेसखे धार्मिकता गिणेया जाओआ। ");
INSERT INTO bfz_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","जेसखे परमेशर बिना कामो ते मतलब बिना बिधान माने तर्मी ठराओआ, तेसखे दाऊद बी धन्य बोलोआ। ");
INSERT INTO bfz_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्य ए सेयो जिना रे बुरे काम माफ ऊए, और जिना रे पाप पुलाईते। ");
INSERT INTO bfz_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धन्य ए से मांणू जेसरे पापो रा लेखा प्रभु ए कदी नि लणा।” ");
INSERT INTO bfz_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","क्या ये धन्य वचन सिर्फ खतना वाल़े यहूदिया खे ईए या बिना खतना वाल़े दुजिया जातिया खे बीए? आसा रा मानणा ए, “अब्राहमो खे तेसरा विश्वास धार्मिकता गिणेया गया।” ");
INSERT INTO bfz_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","तो तेसरी धार्मिकता किंयाँ गिणी गई? खतने री दशा रे या बिना खतने री दशा रे? खतने री दशा रे नि, बल्कि बिना खतने री दशा रे। ");
INSERT INTO bfz_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","बिना खतने ते रंदे बखते तिना खे विश्वासो रे जरिए जो धार्मिकता मिली, तिजी पाँदे मुहरा साई खतने रा चिह्न् लगाया। ईंयां अब्राहम तिना सबी रा बी पिता बणेया, जो बिना खतने री दशा रे विश्वास करोए, जेते कि तिना रा बी विश्वास तिना खे धार्मिकता मानेया जाओ ");
INSERT INTO bfz_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","अब्राहम तिना खतने वाल़ेया रे बी पिता बणे, जो ना सिर्फ खतने पाँदे निर्भर रओए, पर आसा रे पिता अब्राहमो रे तेस विश्वासो पाँदे चलोए, जो तिने बिना खतने री दशा रे कित्तेया था। ");
INSERT INTO bfz_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","परमेशरे अब्राहम और तेसरे वंशो ते वादा कित्तेया था कि की सेयो दुनिया रे बारस ऊणे। ये इजी खे नि ऊआ कि अब्राहमे बिधान मानेया, बल्कि इजी खे ऊआ कि तिने परमेशरो पाँदे विश्वास कित्तेया और परमेशरे सेयो तर्मी माने। ");
INSERT INTO bfz_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","जे अब्राहम और तेसरे वंशो खे बिधानो खे मानणे ते वादा मिलेया तो विश्वास बेकार और निष्फल साबित ऊआ। ");
INSERT INTO bfz_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","बिधानो खे नि मानणा रोष पैदा करोई और जेती बिधान निए, तेती तिजी रा ऊल्लंघन पनिए। ");
INSERT INTO bfz_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ये वादा परमेशरो रे विश्वासो पाँदे निर्भर ए, ताकि परमेशरो रा वादा तिना री कृपा रे जरिए पक्का ऊई जाओ। ये वादा सिर्फ अब्राहमो रे वंशो खे निए जिना गे बिधान ए। बल्कि तिना खे बीए, जो अब्राहमो जेड़े विश्वासो वाल़े बी ए, सेई तो आसा सबी रा पिता ए। ");
INSERT INTO bfz_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “मैं तूँ बऊत सारी जातिया रा पिता ठराई राखेया।” आसा रे पुर्वज अब्राहमे तेस ई परमेशरो पाँदे विश्वास कित्तेया और जो मरे रेया खे जिऊँदा करोआ और जो गल्ला आईया ई नि, तिना रा नाओं एड़ा लओआ, कि मानो सेयो आईया। ");
INSERT INTO bfz_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","तिने निराशा रे बी उम्मीद राखी की विश्वास कित्तेया, इजी री खातर कि तेस वचनो रे मुताबिक ओ कि, “तेरा वंश एड़ा ऊणा” कि से बऊत सारी जातिया रा पिता ऊणा। ");
INSERT INTO bfz_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","और से जो एक सौ साला रा था आपणे मरे रे जे शरीर और सारा रे गर्भो री मरी री जी दशा जाणी की बी विश्वासो रे मजबूत बणेया रा रया। ");
INSERT INTO bfz_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ना ई अविश्वासी ऊई कि परमेशरो रे वादे पाँदे शक कित्तेया, पर विश्वासो रे मजबूत रई कि परमेशरो री महिमा कित्ती। ");
INSERT INTO bfz_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","और निश्चा कित्तेया कि जेसा गल्ला रा परमेशरे वादा करी राखेया, से तेसा खे पूरी करने रे बी सामर्थी ए। ");
INSERT INTO bfz_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","तेसरे विश्वासो री बजअ ते ये तेसखे धार्मिकता गिणेया गया। ");
INSERT INTO bfz_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","और ये वचन कि विश्वास तेसखे धार्मिकता गिणेया गया, ना बस तेसखे लिखेया गया ");
INSERT INTO bfz_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","बल्कि आसा खे बी, जिना खे विश्वास धार्मिकता गिणेया जाणा, मतलब आसा खे जो परमेशरो पाँदे विश्वास करोए, जिने आसा रे प्रभु यीशुए खे मरे रेया बीचा ते जिऊँदा कित्तेया। तो आसे बी तेस विश्वासो री बजअ ते तर्मी माने जाणे। ");
INSERT INTO bfz_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","यीशु मसीह आसा रे बुरे कामो री खातर मौता री सजा खे पकड़वाया गया और आसा खे तर्मी ठराणे खे जिऊँदा बी कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","जेबे आसे विश्वासो रे जरिए तर्मी ठईरे, तो आपणे प्रभु यीशु मसीह रे जरिए जो तिने आसा खे करी राखेया परमेशरो साथे मेल राखिए। ");
INSERT INTO bfz_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","मसीह रे जरिए विश्वासो री बजअ ते आसा री पऊँछ तेसा कृपा तक ऊई री, जिदे आसे एबे बणे रे। आसे एसा गल्ला पाँदे कमण्ड करूँए कि आसा खे परमेशरो री महिमा रे इस्सेदार बणने री उम्मीद ए। ");
INSERT INTO bfz_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","बस येई नि, बल्कि आसा खे क्ल़ेशो पाँदे बी कमण्ड करना चाईयो, ये जाणी की कि क्ल़ेशो ते सब्र ");
INSERT INTO bfz_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","और सब्रो ते खरा निकल़ना और खरे निकल़ने ते उम्मीद जागोई ");
INSERT INTO bfz_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","और उम्मीदा ते शर्म नि ऊँदी, कऊँकि पवित्र आत्मा, जो परमेशरे आसा खे देई राखेया तिजी रे जरिए परमेशरो रा प्यार आसा रे मनो रे पाई राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","कऊँकि जेबे आसे कमजोर ई थे, तेबे मसीह ठीक बखतो पाँदे भक्तिहीना री खातर मरेया। ");
INSERT INTO bfz_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","केसी तर्मी जणे खे कोई मरो, ये तो मुश्किल ए। फेर बी ऊई सकोआ कि केसी खरे मांणूए री खातर कोई मरने खे त्यार ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","पर जेबे आसे पापी ई थे, तेबुई मसीह आसा री खातर मरेया। इजी ते परमेशरे आसा रिया तंईं आपणे प्यारो रा सबूत दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","जे आसे मसीह रे खूनो रे जरिए तर्मी ठराई राखे, तो आसे पक्का ई मसीह रे जरिए परमेशरो रे रोषो ते बची जाणे। ");
INSERT INTO bfz_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","जेबे आसे परमेशरो रे बैरी ई थे तो तेसरे पुत्रो री मौत ऊणे रे जरिए आसा रा मेल परमेशरो साथे ऊआ, तेबे मेल ऊई जाणे पाँदे, तेसरे जीवनो री बजअ ते आसा उद्धार कऊँ नि पाणा? ");
INSERT INTO bfz_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","और बस येई नि, पर एबे तो आसा रे प्रभु यीशु मसीह रे जरिए परमेशरो ते मेल ऊईगा रा इजी खे आसे परमेशरो रे खुश ए। ");
INSERT INTO bfz_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","तेबेई जेड़ा एक मांणू आदमो रे जरिए पाप दुनिया रे आया और पापो रे जरिए मृत्यु आयी और ईंयां ई मृत्यु सबी मांणूआ रे फैली गी, कऊँकि सबी पाप करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","मूसे रा बिधान आऊणे ते पईले ई दुनिया रे पाप था। पर जेती बिधान निए, तेती पाप नि गिणेया जांदा। ");
INSERT INTO bfz_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","तेबे बी आदमो ते लयी कि मूसे तक मौते तिना लोका पाँदे बी राज कित्तेया, जिने आदमो जेड़ा आज्ञा तोड़ने रे जरिए पाप नि कित्तेया। आदम तेस मांणूए रा चिह्न् था जो आऊणे वाल़ा था। ");
INSERT INTO bfz_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","पर आदमो रे पाप और परमेशरो री दया ते परी री कृपा रे बऊत बड़ा फर्क ए। कऊँकि जेबे एक मांणूए रे पापो री बजअ ते बऊत सारे मांणू मरे। तिंयाँ ई परमेशरो री कृपा और धार्मिकता रा तोफा जो तिने आसा खे यीशु मसीह रे जरिए दित्तेया बऊत सारे लोका रा पाप माफ करने खे बऊत बड़ा दान ए। ");
INSERT INTO bfz_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","परमेशरो रा दित्तेया रा तोफा आदमो रे पापो जेड़ा निए। कऊँकि एक ई अपराध मौता री सजा लयी की आया। पर बऊत सारे अपराधा ते बाद परमेशरे जो बरदान दित्तेया तिजी रे जरिए पापो खे माफ करी की आपणी नजरा रे तर्मी बणाईते। ");
INSERT INTO bfz_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","कऊँकि जेबे एक मांणूए रे पापो री बजअ ते मौते तेस एक ई री बजअ ते सारे लोका पाँदे राज कित्तेया, तो जेबे सेयो लोक कृपा और धर्मरूपी बरदान बऊत जणेया ते पाओ ए, सेयो एक मांणूए ते, मतलब प्रभु यीशु मसीह रे जरिए तिना पक्का अनन्त जीवनो रा राज करना। ");
INSERT INTO bfz_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","तेबे जेड़ा एक पाप सबी मांणूआ खे मौता री सजा री बजअ ऊआ, तेड़ा ई एक तर्मो रा काम बी सबी मांणूआ रे जीवनो खे तर्मी ठराणे री बजअ ऊआ। ");
INSERT INTO bfz_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","कऊँकि जेड़ा एक मांणूए री आज्ञा ना मानणे ते बऊत लोक पापी ठईरे तिंयाँ ई एक मांणूए री आज्ञा मानणे ते बऊत लोक तर्मी ठईरने। ");
INSERT INTO bfz_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","बादो ते मूसे रा बिधान दित्तेया ताकि लोक एड़ा समजी सको कि से कितणा पापी ए। पर जेती पाप बऊत ऊआ, तेती कृपा तिजी ते बी केथी जादा ऊई। ");
INSERT INTO bfz_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ताकि जेड़ा पापे मौत फैलांदे ऊए सारे लोका पाँदे राज कित्तेया, तेड़ा ई आसा रे प्रभु यीशु मसीह रे जरिए परमेशरो री कृपा तिना खे धार्मिक बणाओई और अनन्त जीवन देओई। ");
INSERT INTO bfz_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","परमेशर आपणी कृपा ते आसा रे पापो खे माफ करोआ। तो आसे क्या बोलूँ? क्या आसे पाप करदे रईए, ताकि कृपा बऊत ओ? ");
INSERT INTO bfz_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","कदी पनि, आसे जेबे पापो खे मरी गे तो आगो खे तिदे किंयाँ जीवन बिताईये? ");
INSERT INTO bfz_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","आसे जाणूंए कि आसे जितणेया बी प्रभु यीशु मसीह रा बपतिस्मा लया, तो तेसरी मौता रा बपतिस्मा लया। ");
INSERT INTO bfz_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","इजी खे जेबे आसे बपतिस्मा लया तो आसे यीशु मसीह साथे मारे गये और गाड़े गये। ताकि जिंयाँ मसीह पिता परमेशरो री महिमा रे जरिए मरे रेया बीचा ते जिऊँदा कित्तेया, तिंयाँ ई आसे बी नये जीवनो री जी चाल चलिए। ");
INSERT INTO bfz_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","कऊँकि जे आसे तेसरी मौता री समानता रे तेस साथे जुड़ी गे रे, तो पक्का ई तेसरे जिऊँदे ऊणे री समानता रे बी तेस साथे जुड़ी जाणे। ");
INSERT INTO bfz_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","आसे जाणूंए कि आसा रा पुराणा जीवन यीशु मसीह साथे क्रूसो पाँदे चढ़ाईता रा ताकि पापो रा शरीर बेकार ऊई जाओ और आसे आगे खे पापो रे दास नि रऊँ। ");
INSERT INTO bfz_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","जेबे आसे यीशु मसीह साथे मरी गे तो पापो रे वशो ते छूटी गे। ");
INSERT INTO bfz_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","तेबे जे आसे मसीह साथे मरी गे, तो आसा रा विश्वास ये कि तेस साथे जिऊँदे बी ऊई जाणे। ");
INSERT INTO bfz_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","आसे ये जाणूंए कि मसीह मरे रेया बीचा ते जिऊँदा ऊई की फेर मरना नि। तेस पाँदे फेर मौत नि आऊणी। ");
INSERT INTO bfz_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","जेबे मसीह मरी गा, तो पापो खे एक ई बार मरी गा, पर एबे जो जिऊँदा ए, तो परमेशरो री खातर जिऊँदा ए। ");
INSERT INTO bfz_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ईंयां ई तुसे बी आपणे आपू खे पापो खे मरे रा, पर परमेशरो री खातर यीशु मसीह रे जिऊँदा समजो। ");
INSERT INTO bfz_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","इजी खे पापी इच्छा तुसा रे नाश ऊणे वाल़े शरीरो रे राज्य नि करो ताकि तुसे तेसरी इच्छा रे अधीन रओ। ");
INSERT INTO bfz_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","और ना आपणे शरीरो रे अंगा खे अधर्मो रा अथियार ऊणे खे पापो खे सम्बाल़ो, पर आपणे आपू खे मरे रेया बीचा ते जी उठे रा जाणी की आपणी जिन्दगी परमेशरो गे सम्बाल़ो और आपणे शरीरो रे अंगा खे तर्मो रा अथियार ऊणे खे आपणी पूरी जिन्दगी परमेशरो गे सम्बाल़ी देओ। ");
INSERT INTO bfz_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","तेबे तुसा लोका पाँदे पापो रा कोई अक्क नि रणा। कऊँकि तुसे एबे बिधानो रे साअरे नि जिऊँदे बल्कि परमेशरो री कृपा रे सआरे जिओ ए। ");
INSERT INTO bfz_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","तो क्या ऊआ? क्या आसे इजी री खातर पाप करिए कि आसे बिधानो रे अधीन निए, बल्कि कृपा रे अधीन ए? कदी पनि। ");
INSERT INTO bfz_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","तुसे जाणोए कि जेबे केसी री आज्ञा मानणे खे तुसे आपणे आपू खे देई देओए और तेसरी आज्ञा खे मानोए तेबे तुसे तेसरे गुलाम बणी जाओए। ये गुलामी चाए पापो री ओ जेतेरा नतीजा मौत ए, चाए परमेशरो री ओ जेतेरी आज्ञा मानणे रा नतीजा धार्मिकता ए। ");
INSERT INTO bfz_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","पर परमेशरो रा धन्यवाद ओ कि तुसे जो पापो रे दास थे, एबे मनो ते तेस उपदेशो खे मानणे वाल़े ऊईगे, जेतेरे सखाए रे तुसे चले। ");
INSERT INTO bfz_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","परमेशरो रे जरिए पापो ते छुड़ाई की तर्मो रे दास ऊईगे। ");
INSERT INTO bfz_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","आऊँ तुसा री शरीरो री कमजोरिया री बजअ ते मांणूआ री रीतिया पाँदे बोलूँआ। जिंयाँ तुसे आपणे शरीरो रे अंग अशुद्ध और कुकर्मो रे दास करी की सम्बाल़ेया था। तिंयाँ ई एबे आपणे शरीरो रे अंग पवित्रता खे तर्मो रे दास करी की सम्बाल़ी देओ। ");
INSERT INTO bfz_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","जेबे तुसे पापो रे दास थे, तेबे तर्मो री तरफा ते आजाद थे। ");
INSERT INTO bfz_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","तुसे बुरे काम कित्ते और एबे तुसे तिना गल्ला ते शर्मिंदा ओए। तिना सारे बुरे कामा ते तुसा खे क्या फायदा ऊआ? कऊँकि तिना रा अंत तो मौत ए। ");
INSERT INTO bfz_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पर एबे पापो ते आजाद ऊई की परमेशरो रे दास बणी की तुसा खे से फल मिलेया, जेते कि पवित्रता मिलोई और तिजी रा अंत अनन्त जीवन ए। ");
INSERT INTO bfz_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","कऊँकि पापो री मजदूरी तो मौत ए, पर परमेशरो रा बरदान आसा रे प्रभु यीशु मसीह रे अनन्त जीवन ए। ");
INSERT INTO bfz_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ओ साथी विश्वासियो! आऊँ बिधानो खे जाणने वाल़ेया खे बोलूँआ, क्या तुसे नि जाणदे कि जदुओ तक मांणू जिऊँदा रओआ, तदुओ तक ई तिना खे बिधान मानणा पड़ोआ? ");
INSERT INTO bfz_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ब्यायी री जवाणस बिधानो रे मुताबिक आपणे लाड़े रे जिऊँदे जिऊए, तेस साथे बंदी री रओई। पर जे लाड़ा मरी जाओ, तो से लाड़े रा बिधानो ते जो तेसा खे तेसते बानी की राखोई छूटी जाओई। ");
INSERT INTO bfz_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","जे से आपणे लाड़े रे जिऊँदे जिऊए केसी ओरी मर्दो साथे रिश्ता बणाई लओ, तो तेसा खे व्याभिचारिणी बोलोए। पर जे लाड़ा मरी जाओ, तो से तेसा बिधानो ते छूटी गी, एथो तक कि से केसी ओरी मर्दो साथे ब्या करी लओगी, तो तेबे व्याभिचारिणी नि ऊणी। ");
INSERT INTO bfz_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","तो ओ साथी विश्वासियो! जेबे तुसे मसीह साथे मरी गे तो तुसे बिधानो खे मरी गे। पर एबे तुसे मसीह रे मतलब जो मरे रेया बीचा ते जिऊँदा ऊईगा बणी गे रे, ताकि आसे परमेशरो खे फल ल्याऊँ। ");
INSERT INTO bfz_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","जेबे आसे पापी शरीरो रे वशो रे थे, तो पापो री इच्छा, जो बिधानो ते थी, मौता रा फल पैदा करने खे, आसा रे अंगा रे काम करो थी। ");
INSERT INTO bfz_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","पर आसे बिधानो खे मरी गे जेसरे बंदनो रे आसे पईले बंदी रे थे, एबे आसे बिधानो ते छूटी गे। ईंयां आसे पुराणी लिखी रा बिधानो रे मुताबिक नि, बल्कि पवित्र आत्मा रे मुताबिक नईया रीतिया ते परमेशरो री सेवा करूँए। ");
INSERT INTO bfz_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","तो आसे क्या बोलूँ? क्या बिधान पाप ए? कदी पनि, बल्कि बिना बिधानो ते आऊँ पापो खे नि पछयाणदा। जे बिधान नि बोलदा, “लाल़च नि कर,” तो आऊँ ये नि जाणदा कि लाल़च क्या ए। ");
INSERT INTO bfz_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","पर पापे मौका पाई की आज्ञा रे जरिए मांदे सब किस्मा रा लाल़च पैदा कित्तेया। कऊँकि बिना बिधानो ते पाप मुड़दा ए। ");
INSERT INTO bfz_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","एक बखत था जेबे आऊँ बिधानो खे नि जाणूं था और आँऊ जिऊँदा था। पर जेबे मैं आज्ञा खे जाणेया तेबे मेरे पितरे पाप करने री इच्छा जागी और आऊँ परमेशरो ते दूर ऊईगा। ");
INSERT INTO bfz_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","सेई आज्ञा, जो जिन्दगी देणे खे थी, माखे मौता री बजअ ऊई। ");
INSERT INTO bfz_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","कऊँकि पापे मौका पाई की आज्ञा रे जरिए आऊँ बईकाया, और तिजी साथे आऊँ कायी बी दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ईंयां आसे देखूँए कि बिधान पवित्र ए और तिजी री आज्ञा पवित्र ए, ठीक ए और खरी ए। ");
INSERT INTO bfz_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","तो क्या बिधान जो अच्छा था, माखे मौत ऊई? कदी पनि। बल्कि पाप तेसा खरी चीजे की माखे मौत पैदा करने वाल़ा ऊआ ताकि तेसरा पाप सामणे आओ, और आज्ञा रे जरिए पाप बऊत जादा पापमय ठईरो। ");
INSERT INTO bfz_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","आसे जाणूंए कि बिधान तो आत्मिक ए। पर आऊँ सिर्फ एक माणूं ए और शरीर और पापो री गुलामिया रे पूरिया तरअ ते बिकी रा। ");
INSERT INTO bfz_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","और जो आऊँ करूँआ, से नि जाणदा, कऊँकि जो आऊँ चाऊँआ, से नि करदा, पर जेतेते माखे नफरत ओई, सेई करूँआ। ");
INSERT INTO bfz_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","जे, जो आऊँ चांअदा नि, सेई करूँआ, तो आऊँ मानी लऊँआ कि बिधान खरा ए। ");
INSERT INTO bfz_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","तो एड़ी दशा रे तेसा खे करने वाल़ा आऊँ निए, बल्कि पाप ए, जो मांदे बसी रा। ");
INSERT INTO bfz_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","कऊँकि आऊँ जाणूंआ कि मांदे मतलब मेरे पापी शरीरो रे कोई खरी चीज वास नि करदी। पले काम करने री इच्छा तो मांदे आयी, पर खरे काम मांते नि ऊँदे। ");
INSERT INTO bfz_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","कऊँकि जेस खरे कामो री इच्छा आऊँ करूँआ, पर करी नि सकदा, पर जेसा बुराईया री इच्छा नि करदा, सेई करूँआ। ");
INSERT INTO bfz_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","पर जे आऊँ सेई करूँआ, जेतेरी इच्छा नि करदा, तो से करने वाल़ा आऊँ नि रया, पर पाप, जो मांदे बसी रा। ");
INSERT INTO bfz_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ईंयां मेरा अनुभव ये कि जेबे आँऊ खरा करने री इच्छा करूँआ, तो मांते बुरा काम ई ऊई जाओआ। ");
INSERT INTO bfz_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","आऊँ दिलो ते तो परमेशरो रा बिधानो ते बऊत खुश रऊँआ, ");
INSERT INTO bfz_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","पर माखे आपणे शरीरो रे अंगा रे दूजा ई बिधान दिखोई, जो मेरी अक्ला रा बिधानो ते लड़ोई और माखे पापो रा बिधानो रे बंदनो रे पाई देओई, जो मेरे शरीरो रे अंगा रे ए। ");
INSERT INTO bfz_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","आऊँ केड़ा बदनसीब मांणू ए। आऊँ एस शरीरो ते जो मौत लयी की आओई केस छुड़ाणा? ");
INSERT INTO bfz_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","आऊँ परमेशरो रा धन्यवाद करूँआ जिने माखे प्रभु यीशु मसीह रे जरिए उद्धार दित्तेया। ईंयां तो आऊँ आपणी अक्ला ते परमेशरो रे बिधानो राए, पर शरीरो ते पापो रे बिधानो रा इस्तेमाल करूँआ। ");
INSERT INTO bfz_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","तो एबे जो यीशु मसीह रे ए, तिना पाँदे दण्डो री आज्ञा निए। कऊँकि सेयो शरीरो रे मुताबिक नि, पर आत्मा रे मुताबिक चलोए। ");
INSERT INTO bfz_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","पवित्र आत्मा तुसा खे जिन्दगी देणी जो यीशु मसीह ते आओई। तेसा तुसे पाप और मौता ते आजाद करी देणे। ");
INSERT INTO bfz_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","कऊँकि जो काम मूसे रा बिधान आसा रे पापी शरीरो रे सबाओ री बजअ ते कमजोर ऊई की नि करी सकी। से काम परमेशरे कित्तेया। मतलब आपणे ई पुत्रो खे आसा जेड़ा पापी शरीरो री समानता रे और आसा रे पापो री खातर बलिदान ऊणे खे पेजी की परमेशरे मसीह रे शरीरो रे पापो पाँदे दण्डो री आज्ञा दित्ती। ");
INSERT INTO bfz_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","कऊँकि बिधानो री बिधिया री इच्छा आसा रे पापी शरीरो रे सबाओ रे मुताबिक नि, बल्कि पवित्र आत्मा रे मुताबिक चलूँए, पूरी करी जाओ। ");
INSERT INTO bfz_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","कऊँकि शारीरिक मांणू शरीरो री गल्ला रे मन लगाओए, पर आध्यात्मिक पवित्र आत्मा री गल्ला पाँदे मन लगाओए। ");
INSERT INTO bfz_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","शरीरो रे मन लगाणा तो मौत ए, पर आत्मा रे मन लगाणा जिन्दगी और शान्ति ए। ");
INSERT INTO bfz_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","कऊँकि शरीरो रे पापी सबाओ पाँदे मन लगाणा तो परमेशरो साथे बैर राखणा ए। कऊँकि ना तो पापी सबाओ परमेशरो रा बिधानो रे अधीन ए और ना ई ऊई सकोआ। ");
INSERT INTO bfz_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","और जो लोक पापमय शारीरिक दशा रे, सेयो परमेशरो खे खुश नि करी सकदे। ");
INSERT INTO bfz_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पर जबकि पवित्र आत्मा तुसा रे बसोआ, तो तुसे पापी शरीरो रे सबाओ री दशा रे निए, बल्कि आत्मिक दशा रे। जे केसी रे पवित्र आत्मा निए, तो से तेसरा जन निया। ");
INSERT INTO bfz_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","और जे मसीह तुसा रे ए, तो शरीर पापो री बजअ ते मरे राए, पर आत्मा तर्मो री बजअ ते जिऊँदी ए। ");
INSERT INTO bfz_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","और जे परमेशरो रा आत्मा, जिने प्रभु यीशु मरे रेया बीचा ते जिऊँदा कित्तेया, तुसा रे बसी रा, तो जिने मसीह मरे रेया बीचा ते जिऊँदा कित्तेया, से तुसा रे मरे रे शरीरो खे बी आपणे आत्मे की, जो तुसा रे बसी री, जिऊँदा करोगा। ");
INSERT INTO bfz_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","तो ओ साथी विश्वासियो, आसे शरीरो रे कर्जदार निए कि शरीरो रे मुताबिक दिन काटिए। ");
INSERT INTO bfz_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","कऊँकि जे तुसे शरीरो रे मुताबिक दिन काटोगे, तो मरने, जे पवित्र आत्मा ते शरीरो रे पापी सबाओ रे कामो खे मारोगे, तो जिऊँदे रणे। ");
INSERT INTO bfz_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","कऊँकि जितणे लोक परमेशरो री आत्मा रे मुताबिक चलोए, सेयो ई परमेशरो रे पुत्र ए। ");
INSERT INTO bfz_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","कऊँकि तुसा लोका खे गुलामिया री आत्मा नि मिली जेते कि फेर डरने लगो। बल्कि परमेशरो रा आत्मा मिली रा जेबे तिने तुसे आपणे गोदी पुत्रो रे रूपो रे अपनाए। एबे आसे तिना खे “ओ अब्बा, ओ पिता” करी की बुलाऊँए। ");
INSERT INTO bfz_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","पवित्र आत्मा आपू ई आसा री आत्मा साथे गवाई देओआ कि आसे परमेशरो री ल्वाद ए। ");
INSERT INTO bfz_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","और जे आसे ल्वाद ए, तो बारस बीए, बल्कि परमेशरो रे बारस और मसीह साथले बारस ए। सिर्फ एक शर्त ए कि आसे मसीह साथे दु:ख उठाऊँए कि आसे तेस साथे महिमा बी पाऊँ। ");
INSERT INTO bfz_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","आऊँ समजूँआ कि एस बखतो रे दु:ख और क्ल़ेश, तेसा महिमा रे सामणे, जो आसा पाँदे प्रगट ऊणे वाल़ी ए, कुछ पनिए। ");
INSERT INTO bfz_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","कऊँकि सृष्टि बड़ी उम्मीदा साथे परमेशरो री ल्वादा रे प्रगट ऊणे री बाट न्याल़ने लगी री। ");
INSERT INTO bfz_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","कऊँकि परमेशरे जो कुछ बी बणाया तिने सबी चीजे आपणी अहमियत खोई ती, इने सबी चीजे आपणी अहमियत आपणी इच्छा ते नि खोई बल्कि परमेशरे आपू एड़ा कित्तेया। पर एक उम्मीद ए ");
INSERT INTO bfz_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","कि सृष्टि आपू ई नाशो रे बंदनो ते छुटकारा पाई कि, परमेशरो री ल्वादा री महिमा री आजादिया खे प्राप्त ओ। ");
INSERT INTO bfz_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","कऊँकि आसे जाणूंए कि सारी सृष्टि एबुए तक जदुओ ते आदमे पाप करी राखेया मिली की करलाओई और पीड़ा रे पड़ी की तड़फोई। ");
INSERT INTO bfz_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","और बस सृष्टि ई नि पर आसे बी पितरे ई पितरे करलाऊँए। आसा खे तो पवित्र आत्मा मिली चुकी रा जो परमेशरो री दया रे दानो रा पईला फल ए। आसे बी बड़ी उम्मीदा साथे गोदीपुत्र ऊणे री, मतलब-आपणे शरीरो रे छुटकारे री बाट न्याल़दे रऊँए। ");
INSERT INTO bfz_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","आसा खे उम्मीदा रे जरिए ई उद्धार मिली रा। पर जेते चीजा री उम्मीद ओई, जेबे से देखणे खे मिलो, तो फेर तिजी री उम्मीद नि करी जांदी। कऊँकि जेसा चीजा खे कोई देखणे लगी रा, तो तिजी री उम्मीद कऊँ करनी? ");
INSERT INTO bfz_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","पर जेसा चीजा खे आसे देखदे नि, जे तिजी री उम्मीद राखूँए, तो सब्रो साथे तेसा खे नयाल़ुं बी ए। ");
INSERT INTO bfz_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ईंयां ई पवित्र आत्मा बी आसा री मताद करोआ जेबे परमेशरो पाँदे आसा रा विश्वास कमजोर ओआ। कऊँकि आसे नि जाणदे कि प्रार्थना किंयाँ करनी चाईयो। पर पवित्र आत्मा आपू ई एड़िया आहें परी-परी की, जो बखाण नि करी सकदे, आसा खे बिनती करोआ। ");
INSERT INTO bfz_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","परमेशर जो आसा रे मनो खे परखणे वाल़ा ए, ये जाणोआ कि पवित्र आत्मा रा मकसद क्या ए। कऊँकि से पवित्र लोका खे परमेशरो री इच्छा रे मुताबिक बिनती करोआ। ");
INSERT INTO bfz_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","आसे जाणूंए कि जो लोक परमेशरो खे प्यार करोए, तिना खे सब गल्ला मिली की पलाई पैदा करोईया, मतलब तिना खेई, जो तेसरी इच्छा रे मुताबिक बुलाई राखे। ");
INSERT INTO bfz_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","कऊँकि जो परमेशरे पईले तेई चुणी लये रे, सेयो पईले तेई ठराई बी राखे कि तेसरे पुत्रो जेड़े ओ, ताकि से सारे बच्चेया बीचे जेठा ओ। ");
INSERT INTO bfz_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","फेर जो परमेशरे पईले ते चुणी राखे, सेयो बुलाए बी और जो बुलाए, सेयो तर्मी बी ठराई राखे और जो तर्मी ठराए, तिना खे महिमा बी देई राखी। ");
INSERT INTO bfz_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","इना सबी गल्ला खे त्यानो रे राखदे ऊए आसे एते नतीजे पाँदे पऊँछुए कि जे परमेशर आसा री तरफा खे आया, तो आसा रा बिरोदी कुण ऊई सकोआ? ");
INSERT INTO bfz_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","परमेशरे जिने आपणा एकलौता पुत्र पनि राखी छाडेया, पर आसा पाँदे कृपा करी की से आसा सबी खे देईता। तो इतणा देणे ते बाद, तेस आसा खे आपणे पुत्रो साथे सब कुछ कऊँ नि देणा? ");
INSERT INTO bfz_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","परमेशरो रे चुणे रेया पाँदे दोष केस लगाणा? परमेशर ईए जो, तिना खे तर्मी ठराणे वाल़ा ए। ");
INSERT INTO bfz_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","आसा पाँदे कुण दोष लगाई सकोआ? कोई बी नि। कऊँकि से यीशु मसीह ईए जिने आपणा प्राण आसा रिया तंईं देईता और तिजी ते बाद मुड़देया बीचा ते जिऊँदा बी ऊईगा और परमेशरो रे दाँणे कनारे ए और आसा री खातर बिनती बी करोआ। ");
INSERT INTO bfz_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कुण आसा खे मसीह रे प्यारो ते लग करी सकोआ? क्या क्ल़ेश, संकट, उपद्रव, अकाल़, नांगापण, खतरा या तलवार? ");
INSERT INTO bfz_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जेड़ा कि पवित्र शास्त्रो रे लिखी राखेया, “ताखे आसे पुरे दिन घात करे जाऊँए, आसे फाटणे वाल़ी पेडा जेड़े गिणी राखे।” ");
INSERT INTO bfz_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","पर इना सबी गल्ला रे आसे तेसरे जरिए, जिने आसा खे प्यार कित्तेया, आसा गे उम्मीदा ते बी बढ़ी की जीत ए। ");
INSERT INTO bfz_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","कऊँकि माखे पक्का पता ए कि आसा खे परमेशरो रे प्यारो ते, जो आसा रे प्रभु यीशु मसीह रे ए, कोई बी लग नि करी सकदा। ना मृत्यु, ना जीवन, ना स्वर्गदूत, ना दुष्टात्मा, ना वर्तमान, ना भविष्य, ना सामर्थ, ना ऊच्चा, ना डूगा और ना ई कोई सृष्टि। ");
INSERT INTO bfz_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","आऊँ मसीह रे सच बोलूँआ, चूठ नि बोलदा और मेरा विवेक बी पवित्र आत्मा रे गवाई देओआ ");
INSERT INTO bfz_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","कि माखे बऊत दु:ख ए और मेरा मन मेरे लोका री खातर दु:खदा रओआ। ");
INSERT INTO bfz_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","कऊँकि आऊँ एथो तक चाऊँ था कि आपणे यहूदी पाईया खे, जो शरीरो ते मेरे टब्बरो रे ए, आपू ई मसीह ते श्रापित और लग ऊई जांदा। ");
INSERT INTO bfz_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","सेयो बी मां ई जेड़े इस्राएली लोक ए। सेयो लोक बी परमेशरो रे चुणे रे गोदीपुत्र ए। परमेशरे आपणी महिमा तिना लोका पाँदे प्रकट कित्ती। तिने तिना लोका साथे वाचा बानी और आपणा बिधान दित्तेया। परमेशरो तिना लोका खे आपणी भक्ति करने खे और आपणा नौखा वादा पाणे खे खास अक्क दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","मशुर पूर्वज बी तिना रेईए और मसीह बी शरीरो रे भावो ते तिना ई बीचा ते ऊआ। से परमेशर ए जो सबी पाँदे राज करोआ तेसरी तारीफ जुगो-जुगो ऊँदी रओ। आमीन्। ");
INSERT INTO bfz_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","फेर बी ये नि समजणा चाईयो कि परमेशर आपणा बादा निबाणे रे असफल ऊईगा रा। कऊँकि इस्राएलो रे वंशो रे जन्म लणे वाल़े सब लोक सच्चे इस्राएली निए। ");
INSERT INTO bfz_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","अब्राहमो रे वंशो रे जन्म लणे तेई सब परमेशरो री सच्ची ल्वाद नि बणी जांदे। कऊँकि परमेशरे अब्राहमो खे बोलेया, “जिना इसहाको रे वंशो ते जन्म लणा सेयो ई तेरे वंशो रे माने जाणे।” ");
INSERT INTO bfz_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","इजी रा मतलब ये ए कि शरीरो ते जम्मे रे परमेशरो री ल्वाद निए, पर वादे रे जरिए जम्मे रेई अब्राहमो रे असली वंश गिणे जाओए। ");
INSERT INTO bfz_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","कऊँकि वादे रा वचन ये ए, “आगले साल एस बखते मां फेर आऊणा और सारा रे एक पुत्र ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","और बस येई नि, पर जेबे रिबका रे गर्भो रे एकी मर्द मतलब आसा रे पुर्वज इसहाको ते जुड़ुवा बच्चे थे। ");
INSERT INTO bfz_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","और एबुए तक ना बाल़क जमी रे थे और ना तिने कुछ पला या बुरा कित्तेया रा था कऊँकि परमेशरो री इच्छा, जो तेसरे चुणे रे मुताबिक ए, कर्मो री बजअ ते नि, पर बुलाणे वाल़ेया री बजअ ते बणी रओ। ");
INSERT INTO bfz_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","तिने बोलेया, “जेठा छोटे रा दास ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","जेड़ा पवित्रो शास्त्रो रे लिखी राखेया, “मैं याकूबो खे प्यार कित्तेया, पर एसाव अप्रिय जाणेया।” ");
INSERT INTO bfz_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","तो आसे क्या बोलूँ? क्या परमेशरो रे कअरे अन्याय ए? कदी पनि। ");
INSERT INTO bfz_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","कऊँकि परमेशरे मूसे खे बोलोआ, “आऊँ जेस केसी पाँदे बी दया करना चाऊँ, तेस पाँदे दया करूँआ, और जेस केसी पाँदे कृपा करना चाऊँ, तेस पाँदे ई कृपा करूँआ।” ");
INSERT INTO bfz_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","इजी खे ये माणूंआ री इच्छा या तेसरी मईणती पाँदे निर्भर नि करदे, बल्कि दया करने वाल़े परमेशरो पाँदे निर्भर रओए और जेसखे से चुणना चाओआ तेस पाँदे दया करोआ। ");
INSERT INTO bfz_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","कऊँकि पवित्र शास्त्रो रे मिस्रो रे राजा फिरौनो खे बोलेया था, “मैं तूँ इजी खे राजा बणाया ताकि आऊँ तांदे आपणी सामर्थ दखाऊँ और मेरे नाओं रा प्रचार सारी तरतिया रे ओ।” ");
INSERT INTO bfz_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","तो परमेशर जेस पाँदे चाओआ, तेस पाँदे दया करोआ और जेसखे चाओआ, तेसखे हठी बणाई देओआ। ");
INSERT INTO bfz_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","तेबे कुछ लोका माखे बोलणा, “जे एड़ा ए तो परमेशरो किंयाँ आसा खे दोषी ठराई सकोआ? कऊँकि कोई बी तिना खे रोकी नि सकदा जो से करना चाओआ।” ");
INSERT INTO bfz_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ओ पाई! पला तूँ कुण ए, जो परमेशरो ते बईस करी करोआ? क्या कअड़ी री चीज, कअड़णे वाल़ेया खे बोली सकोई कि तैं आऊँ एड़ी कऊँ बणाई राखी? ");
INSERT INTO bfz_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","क्या कम्मारो खे माट्टिया पाँदे अक्क निए कि एक ई चाको पाँदो ते, एक पांडा खास कामो रे इस्तेमालो खे और दूजा हर रोज इस्तेमाल करने खे बणाओ? ");
INSERT INTO bfz_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","हालाँकि परमेशरो खे आपणा रोष और आपणी सामर्थ प्रगट करने रा अक्क ए, फेर बी से तिना लोका साथे बऊत ई सब्र राखोआ, जिना पाँदे तिना रा रोष आओआ और जो विनाशो खे त्यार कित्ते थे। ");
INSERT INTO bfz_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","तिने एड़ा इजी खे कित्तेया कि दया रे तिना पांडेया पाँदे आपणी महिमा री शान प्रकट करना चाओ था जो तिने पईले तेई तेसा महिमा खे त्यार कित्ते। ");
INSERT INTO bfz_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","मतलब आसा पाँदे जिने तिने ना बस यहूदिया बीचा ते, बल्कि दूजी जातिया बीचा ते बी बुलाया। ");
INSERT INTO bfz_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जेड़ा परमेशर होशे भविष्यवक्ता री कताबा रे बी दुजिया जातिया रे बारे रे बोलोआ, “जो मेरी प्रजा नि थी, तिना खे मां आपणी प्रजा बोलणा और जो प्यारी नि थी, तिना खे प्यारा बोलूँगा।” ");
INSERT INTO bfz_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","और, “एड़ा ऊणा कि जेते जगा रे तिना खे एड़ा बोलेया था कि ‘तुसे मेरी प्रजा निए,’ तेते जगा रे सेयो ‘जिऊँदे परमेशरो री ल्वाद ऊणे।’ ” ");
INSERT INTO bfz_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","और यशायाह भविष्यवक्ता इस्राएली लोका रे बारे रे आक्का पाई की बोलोआ, “चाए इस्राएलिया रे ल्वादा री गिणती समुद्रो रे बालूए रे बराबर ओ, तेबे बी तिना बीचा ते थोड़े ई बचणे। ");
INSERT INTO bfz_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","कऊँकि प्रभुए आपणा वचन तरतिया रे पूरा करी की धार्मिकता ते चट ई तरतिया रे लोका रा न्याय करना।” ");
INSERT INTO bfz_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जेड़ा यशायाह भविष्यवक्ते पईले बी बोलेया था, “जे सेनाओं रा प्रभु, आसा खे कोई वंश नि छाडदा, तो आसे सदोमो जेड़े ऊई जाणे थे और गमोरा जेड़े ठईरने थे।” ");
INSERT INTO bfz_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","तो आसे क्या बोलूँ? ये कि दूजी जाति, जो तर्मो खे नि टोल़ो थे, तिना खे धार्मिकता मिली, मतलब तेसा धार्मिकता खे जो विश्वासो ते ए। ");
INSERT INTO bfz_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","पर इस्राएली लोक जो तर्मो रे बिधानो खे टोल़दे ऊए, तर्मी बणने रे सफल नि ऊए। ");
INSERT INTO bfz_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","किजी खे? इजी री खातर कि सेयो विश्वासो ते नि, पर मानो अच्छे कामा ते तेसखे टोल़ोए, तिने तेस ठोकरा रे पात्थरो पाँदे ठोकर खाई। ");
INSERT INTO bfz_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “देखो, आऊँ सिय्योन नगरो रे एक ठोकर लगणे रा पात्थर और ठोकर खाणे री जान राखूँआ और जेस तेस पाँदे विश्वास करना, से शर्मिंदा नि ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ओ साथी विश्वासियो, मेरे मनो री इच्छा और इस्राएली लोका खे मेरी परमेशरो ते प्रार्थना ये ए कि तिना खे उद्धार मिलो। ");
INSERT INTO bfz_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","कऊँकि आऊँ तिना री गवाई देऊँआ कि तिना खे परमेशरो री खातर धुन रओई, तिना लोका खे तिना री सेवा करने री ठीक समज निए। ");
INSERT INTO bfz_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","कऊँकि सेयो परमेशरो री धार्मिकता ते अणजाण ऊई की और आपणी धार्मिकता बनाणे री कोशिश करदे रओए। सेयो परमेशरो रे जरिए तय कित्ती री धार्मिकता रे अधीन नि ऊए। ");
INSERT INTO bfz_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","कऊँकि मसीह ई धार्मिकता रे बिधानो रा अंत ए और हर एक विश्वास करने वाल़े खे धार्मिकता देओए। ");
INSERT INTO bfz_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","कऊँकि मूसे ये लिखी राखेया कि जो मांणू तेसा धार्मिकता पाँदे, “जो बिधानो रे ए चलोआ से इजी बजअ ते जिऊँदा रणा।” ");
INSERT INTO bfz_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","पर जो धार्मिकता विश्वासो ते ए, से ईंयां बोलोई, “तूँ आपणे मनो रे ये नि बोलणा कि स्वर्गो पाँदे कुण चढ़ना?” मसीह खे त्वारी कि ल्याऊणे खे, ");
INSERT INTO bfz_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","या डूगे रे कुण उतरना? मतलब मसीह खे मरे रेया बीचा ते जिऊँदा करी की ऊबो खे निणे खे। ");
INSERT INTO bfz_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","पर से क्या बोलोई? “परमेशरो रा वचन तुसा गे ए, से तुसा रे मुंओ रे और तुसा रे मनो रे ए।” ये विश्वासो रा से वचन ए, जो आसे प्रचार करूँए। ");
INSERT INTO bfz_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","जे तूँ आपणे मुंओ ते यीशुए खे प्रभु जाणी की अंगीकार करेगा और आपणे मनो रे विश्वास करेगा कि परमेशरे से मरे रेया बीचा ते जिऊँदा कित्तेया, तो तेरा पक्का उद्धार ऊणा। ");
INSERT INTO bfz_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","कऊँकि विश्वास दिलो ते करेया जाओआ जेतेरा नतीजा धार्मिकता ए और अंगीकार मुंओ ते करेया जाओआ जेतेरा नतीजा उद्धार ए। ");
INSERT INTO bfz_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","जिंयाँ यशायाहे पवित्र शास्त्रो रे लिखी राखेया, “जो कोई तेस पाँदे विश्वास करोगा, से शर्मिंदा नि ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","यहूदिया रे और यूनानिया रे कोई फर्क निए, कऊँकि परमेशर सबी रा प्रभु ए और आपणे सब नाओं लणे वाल़ेया खे उद्धार ए। ");
INSERT INTO bfz_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","जिंयाँ पवित्र शास्त्रो रे लिखी राखेया, “जेस केसी प्रभुए रा नाओं लणा, तेसरा उद्धार ऊणा।” ");
INSERT INTO bfz_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","पर जेस पाँदे तिने विश्वास नि कित्तेया, सेयो तेसरा नाओं किंयाँ लओ? और जेसरे बारे रे सुणेया नि, तेस पाँदे विश्वास किंयाँ करना और प्रचारका ते बिना किंयाँ सुणना? ");
INSERT INTO bfz_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","और जे पेजे नि जाओ, तो किंयाँ प्रचार करो? जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “तिना रे पैर केड़े खरे ए, जो अच्छी गल्ला रा सुसमाचार सुणाओए।” ");
INSERT INTO bfz_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","पर सबी इस्राएलिए तेस सुसमाचारो पाँदे विश्वास नि कित्तेया। जेड़ा यशायाह भविष्यवक्ता बोलोआ, “ओ प्रभु, किने आसा रे सुसमाचारो पाँदे विश्वास करी राखेया?” ");
INSERT INTO bfz_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","तो विश्वास सुणने ते और सुणना मसीह रे वचनो ते ओआ। ");
INSERT INTO bfz_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","पर आऊँ पुछूँआ, क्या तिने मसीह रे बारे नि सुणेया? सुणेया तो जरूर ए, कऊँकि पवित्र शास्त्रो रे लिखी राखेया, “तिना री आवाज सारी तरतिया पाँदे, और तिना रे वचन दुनिया रे कनारे तक पऊँछी गे रे।” ");
INSERT INTO bfz_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","आऊँ फेर पुछूँआ कि क्या इस्राएलो रे लोक नि जाणो थे? पईले तो प्रभुए मूसा रे जरिए ये बोलोआ, “मां तिना रे जरिए, जो यहूदी जाति निए, तुसा रे मनो रे जल़न पैदा करनी, मां एक मूर्ख दूजिया जातिया रे जरिए, तुसा खे रिस दलाणी।” ");
INSERT INTO bfz_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","तेबे यशायाह बड़ी ई इम्मता साथे बोलोआ, “जो माखे नि टोल़ो थे, तिना खे आऊँ मिली गा और जो माखे पूछो तक नि थे, तिना रे सामणे आऊँ आया।” ");
INSERT INTO bfz_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","पर इस्राएलो रे लोका रे बारे रे परमेशर यशायाह रे जरिए ये बोलोआ, “आऊँ सारे दिन आपणे आथ एक आज्ञा ना मानणे वाल़ी और बईस करने वाल़ी प्रजा री तरफा खे फैलाए रे रया।” ");
INSERT INTO bfz_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","एबे आऊँ पुछूँआ, “क्या परमेशरे आपणी प्रजा छाडी ती? कदी पनि। आऊँ बी तो इस्राएली ए, अब्राहमो रे वंश और बिन्यामीनो रे गोत्रो तेआ।” ");
INSERT INTO bfz_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेशरे आपणी से प्रजा नि छाडी, जेसखे से पईले तेई जाणो था, क्या तुसे नि जाणदे कि पवित्र शास्त्र एलिय्याह भविष्यवक्ता रे बारे रे क्या बोलोआ कि से इस्राएलो रे लोका रे बिरोदो रे परमेशरो ते बिनती करोआ? ");
INSERT INTO bfz_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","तिने बोलेया, “ओ प्रभु, तिने तेरे भविष्यबक्ता काईते और तेरिया बेदिया नाश करी तिया। आऊँ ई कल्ला बची गा और सेयो मेरे प्राण बी लयी लणा चाओए।” ");
INSERT INTO bfz_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","पर परमेशरे एलिय्याह खे उत्तर दित्तेया, “मैं आपू खे सात ह्जार मर्द राखी राखे, जिने चूठे बाअल़ देवता रे आगे कुटणे टेकी की आराधना नि कित्ती।” ");
INSERT INTO bfz_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","तो ईंयां ई एस बखते बी, परमेशरो री कृपा ते चुणे रे कुछ यहूदी लोक बाकि ए। ");
INSERT INTO bfz_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","जे ये परमेशरो री कृपा ते ऊई रा, तो तेबे बिधानो रे कामा ते निए। जे ये बिधानो रे कामा रे जरिए ऊँदा तो कृपा फेर कृपा नि रंदी। ");
INSERT INTO bfz_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","फेर नतीजा क्या ऊआ? ये कि इस्राएली परमेशरो री जेसा कृपा खे टोल़ने लगी रे थे, से तिना खे नि मिली, बल्कि चुणे रेया खे मिली और बाकि लोक हठी बणाईते। ");
INSERT INTO bfz_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “परमेशरे तिना लोका खे आजके दिनो तक सुस्त दमाक देई राखेया और एड़िया आखी दित्तिया, जो देखी ना सको और एड़े कान, जो सुणी नि सको।” ");
INSERT INTO bfz_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","और राजा दाऊद बोलोआ, “तिना री रोटी तिना खे जाल़, और फन्दा बणे; से तिना खे सजा और रूड़ने री बजअ ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","तिना री आखी रे तल़ोजा आई जाओ जेते कि देखी नि सको और तूँ सदा तिना री पीठी खे मुसीबता रे बोजो निठे चुकाई की राख।” ");
INSERT INTO bfz_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","तो आऊँ फेर पुछूँआ कि क्या इस्राएली लोके इजी खे ठोकर खाई कि सेयो सदा खे नाश ऊई जाओ? कदी पनि। पर तिना रे अविश्वासो री बजअ ते दूजी जातिया खे उद्धार मिलेया, कि इस्राएली लोका खे जल़न ओ। ");
INSERT INTO bfz_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","तो जे तिना रा अविश्वास दुनिया रे लोका खे बड़ी आशीष और तिना री कमी दूजी जातिया खे सम्पतिया री बजअ ऊई, तो कितणी जादा आशीष उणी जेबे सब इस्राएली लोक परमेशरो पाँदे विश्वास करी लओगे। ");
INSERT INTO bfz_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","आऊँ तुसा दूजी जातिया खे इना सबी गल्ला खे बोलूँआ, जबकि आऊँ दूजी जातिया खे प्रेरित ए। माखे आपणी एसा सेवा पाँदे बड़ा गर्व ए। ");
INSERT INTO bfz_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ताकि किंयाँ बी आऊँ आपणे यहूदी लोका ते जल़न कराई की तिना बीचा ते कई जणेया खे बचाऊँ। ");
INSERT INTO bfz_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","कऊँकि जेबे तिना रा त्याग करना दुनिया रे लोका खे परमेशरो साथे मिलापो री बजअ ऊई, तो क्या तिना रा मसीह खे ग्रहण करना मरे रेया बीचा ते जिऊँदे ऊणे रे बराबर नि ऊणा? ");
INSERT INTO bfz_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","जेबे गूँदे रे आटे रा पईला पेड़ा पवित्र ठईरेया, तो पूरा गूँदेया रा आटा बी पवित्र ए, और जेबे जड़ पवित्र ठईरी, तो डाल़िया बी पवित्र आईया। ");
INSERT INTO bfz_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","इस्राएलो रे लोक जैतूनो रे डाल़ो री डाल़िया जेड़े ए और पिता अब्राहम, इसहाक और याकूब तेस जैतूनो रे डाल़ो री जड़ा जेड़े ए। तुसे दूजिया जातिया रे लोक जैतूनो रे डाल़ो पाँदे कलम चढ़ाई री डाल़िया जेड़े ए और तूँ जंगल़ी डाल़िया जेड़ा तेसा बाडी री डाल़िया री जगा पाँदे जैतूनो री जड़ा री चिकणाईया रा इस्सेदार ऊआ। ");
INSERT INTO bfz_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","पर तैं तेसा बाडी री डाल़िया ते आपणे आपू खे बढ़ी की नि समजणा और जे तूँ आपणे आपू खे तिना ते बढ़ी कि समजेया तो जाणी लो कि तूँ जड़ा खे नि, पर जड़ ताखे सम्बाल़ोई। ");
INSERT INTO bfz_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","तेबे तां बोलणा, “डाल़िया तेबे बाडिया ताकि मां पाँदे तिजी री अच्छी कलम चढ़ाई जाओ।” ");
INSERT INTO bfz_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ये सच ए, सेयो तो अविश्वासो री बजअ ते बाडी की लग करी तिया, पर तूँ विश्वासो री बजअ ते आपणी जगा पाँदे बणे रा रओआ। इजी री खातर कमण्ड नि कर, बल्कि डर। ");
INSERT INTO bfz_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","कऊँकि जेबे परमेशरे कुदरती डाल़िया नि छाडिया, तो तूँ पनि छाडणा। ");
INSERT INTO bfz_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","इजी री खातर परमेशरो री दया और सख्ती देख, जो रूड़ी गे, तिना पाँदे सख्ती और तां पाँदे दया, तूँ तिदे बणेया रा रओ, नयी तो तूँ बी बाडी देणा। ");
INSERT INTO bfz_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","जे इस्राएलो रे लोक बी विश्वास करना शुरू करी देओ तो सेयो बी फेर तेस डाल़ो रे कलम चढ़ाई की जोड़े जाणे कऊँकि परमेशर सामर्थी ए कि फेर तिना खे जोड़ी सकोआ। ");
INSERT INTO bfz_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","कऊँकि जे तूँ तेसा जैतूना ते, जो सबाओ तेई जंगल़ी ए बाडी दित्तेया और सबाओ रे खलाफ अच्छी जैतूना रे डाल़ो साथे जोड़ी ता, तो यो जो कुदरती डाल़िया ए, आपणी ई जैतूना रे कलम चढ़ाई की चट ई कऊँ नि बढ़ना! ");
INSERT INTO bfz_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ओ साथी विश्वासियो! केथी एड़ा नि ओ कि तुसे आपणे आपू खे अक्लमंद समजी लो, इजी री खातर आऊँ चाऊँआ कि तुसे एस भेदो खे जाणी लो कि जदुओ तक दूजी जातिया पूरी तरअ ते नि आयी जाओ, तदुओ तक इस्राएलो रा एक इस्सा एड़ा ई सख्त रणा। ");
INSERT INTO bfz_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","और ईंयां ई सारे इस्राएलो रे लोका खे उद्धार मिलणा, जेड़ा कि पवित्र शास्त्रो रे लिखी राखेया, “छुड़ाणे वाल़ा सिय्योन नगरो ते आऊणा और अभक्ति याकूबो रे वंशो ते दूर करनी। ");
INSERT INTO bfz_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","और तिना साथे मेरी ये वाचा ऊणी, जबकि मां तिना रे पाप माफ करी देणे।” ");
INSERT INTO bfz_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","सेयो सुसमाचारो री नजरा ते तो आपू ई दुजिया जातिया री खातर परमेशरो रे बैरी ए। पर चुणने रे नजरा ते बाप-दादेया री बजअ ते परमेशरो रे प्यारे ए। ");
INSERT INTO bfz_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","कऊँकि परमेशर आपणे बरदानो ते और बुलाहटा ते कदी पीछे नि अटदा। ");
INSERT INTO bfz_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","कऊँकि जिंयाँ तुसे पईले ई परमेशरो री आज्ञा नि मानी, पर एबे इस्राएली लोका री आज्ञा ना मानणे ते तुसा पाँदे दया ऊई। ");
INSERT INTO bfz_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","तिंयाँ ई तिने बी एबे आज्ञा नि मानी ताकि तुसा पाँदे जो दया ओई, इजी ते तिना पाँदे बी दया ओ। ");
INSERT INTO bfz_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","कऊँकि परमेशरे सबी लोका खे आज्ञा ना मानणे री बजअ ते बन्दी बणाई की राखेया, ताकि से सबी लोका पाँदे दया करो। ");
INSERT INTO bfz_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","वाह, परमेशरो री कृपा रा धन, बुद्धि और ज्ञान कितणे गम्भीर ए! तेसरे विचार कितणे गईरे ए, और तेसरी बाट कितणी साफ ए। ");
INSERT INTO bfz_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“प्रभुए रा मन किने जाणेया? या तेसरा सलाहकार कुण ऊआ? ");
INSERT INTO bfz_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","या किने तेसखे पईले कुछ देई राखेया, जेतेरा बदला तेसखे दित्तेया जाओ?” ");
INSERT INTO bfz_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","कऊँकि परमेशरो री तरफा ते और तेसरे जरिए और तेसखे ई सब कुछ ए, तेसरी महिमा जुगो-जुगो तक ऊँदी रओ। आमीन्। ");
INSERT INTO bfz_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","इजी री खातर ओ साथी विश्वासियो! आऊँ तुसा खे परमेशरो री दया याद कराई की बिनती करूँआ कि आपणे आपू खे जिऊँदा और पवित्र और परमेशरो खे अच्छा लगदा ऊआ बलिदान करी की चढ़ाओ। परमेशरो री सेवा करने रा येई सच्चा तरीका ए। ");
INSERT INTO bfz_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","और एसा दुनिया रे लोका जेड़े नि बणो, बल्कि तुसा रे मनो रा नवां ऊई जाणे ते, तुसा रा चाल-चलण बी बदलदा रओ। ताकि तुसे परमेशरो री खरी, भावती और सिद्ध इच्छा अनुभवो ते पता करदे रओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","कऊँकि आऊँ तेसा कृपा री बजअ ते, जो माखे मिली री, तुसा बीचा ते हर एकी खे बोलूँआ कि जेड़ा समजणा चाईयो, तिजी ते बढ़ी की कोई बी आपू खे नि समजो, पर जेड़ा परमेशरे हर एकी खे विश्वासो रे नतीजे रे मुताबिक बांडी ता रा, तेड़ा ई अच्छी सोचा साथे आपू खे समजो। ");
INSERT INTO bfz_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","कऊँकि जेड़े म्हारे एक ई शरीरो रे बऊत अंग ए और सबी अंगा रा एक जेड़ा काम निए, ");
INSERT INTO bfz_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","तेड़ा ई आसे जो बऊत ए, मसीह रे एक शरीर ऊई की आपू बीचे एकी दूजे रे अंग ए। ");
INSERT INTO bfz_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","जबकि तेसा कृपा रे मुताबिक, जो आसा खे देई राखी, आसा खे लग-लग बरदान मिली रे, तो जेसखे भविष्यबाणी करने रा बरदान मिली रा, से विश्वासो रे नतीजे रे मुताबिक भविष्यबाणी करो। ");
INSERT INTO bfz_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ईंयां ई जे सेवा करने रा बरदान मिली रा, तो सेवा करदे रओ, जे कोई सिखाणे वाल़ा ए, तो सिखाणे रे लगे रा रओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","जेसखे औंसला देणे रा दान मिली रा, से लोका खे औंसला देंदा रओ, दान देणे वाल़ा उदारता ते देंदा रओ, जो अगुवाई करोआ, से लगना साथे अगुवाई करदा रओ, जो दया करो, से खुशिया ते दया करो। ");
INSERT INTO bfz_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","प्यार बिना कपटो ते ओ, बुराईया ते नफरत करो, पलाईया रे लगे रे रओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","पाईचारे रे प्यारो ते एकी-दूजे ते प्यार करो, आपू बीचे आदर करने रे एकी-दूजे ते जादा बढ़ो। ");
INSERT INTO bfz_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","कड़ी मईणत करो और आल़सी नि बणो। आत्मिक खुशिया ते परे रे रओ, प्रभुए री सेवा करदे रओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","उम्मीदा रे खुश ऊँदे रओ, क्ल़ेशो रे स्थिर रओ, हर बखत प्रार्थना करदे रओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","परमेशरो रे लोका खे जो कुछ जरूरी ओ, तिदे तिना री मताद करो, पराऊणचारिया रे लगे रे रओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","आपणे सताणे वाल़ेया खे आशीष देओ, आशीष देओ, श्राप नि देओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","खुशी करने वाल़ेया साथे खुशी करो और रोणे वाल़ेया साथे रोओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","आपू बीचे एक जेड़ा मन राखो, कमण्डी नि बणो। पर गरीब लोका साथे संगति राखणे खे सदा त्यार रओ। आपणी नजरा रे अक्लमंद नि ओ। ");
INSERT INTO bfz_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","बुराईया रे बदले केसी साथे बुराई नि करो, जो गल्ल सबी लोका रे नेड़े खरी ओ, तिना री चिन्ता करेया करो। ");
INSERT INTO bfz_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जेथो तक ऊई सको आपणे सबी मांणूआ साथे मेल-जोल राखो। ");
INSERT INTO bfz_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ओ प्यारो! आपणा बदला नि लओ, पर परमेशरो रे रोषो खे मौका देओ, कऊँकि पवित्र शास्त्रो रे परमेशर बोलोआ, “बदला लणा मेरा काम ए, मां ई प्रतिफल देणा।” ");
INSERT INTO bfz_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","पर ये बी लिखी राखेया, “जे तेरा बैरी पूखा ओ, तो तेसखे रोटी खुल़ा, जे त्याया ओ, तो तेसखे पाणी पल़्या। कऊँकि तुसा रे एड़ा करने ते तेसरा सिर शरमा रे मारे चूकी जाणा।” ");
INSERT INTO bfz_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","बुराईया ते नि आरो, बल्कि पलाईया ते बुराईया खे जीती लओ। ");
INSERT INTO bfz_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","हर एक मांणू बड़े अधिकारिया रे अधीन रओ, कऊँकि कोई अक्क एड़ा निए, जो परमेशरो री तरफा ते नि ओ और जो अक्क आए, सेयो परमेशरे रे जरिए ई ठराई राखे। ");
INSERT INTO bfz_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","इजी ते जो कोई अधिकारिए रा बिरोद करोआ, से परमेशरो री आज्ञा रा बिरोद करोआ और बिरोद करने वाल़ेया दण्ड पाणा। ");
INSERT INTO bfz_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","कऊँकि जो कोई खरा काम करोए तिना खे अधिकारिया ते डरने री जरूरत निए। पर जो कोई बुरे काम करोआ तिना खे अधिकारिया ते डरना चाईयो। जे तूँ अधिकारिया ते निडर रणा चाओआ तो खरा काम कर और तेसरी तरफा ते तेरी तारीफ ऊणी। ");
INSERT INTO bfz_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","कऊँकि से तेरी पलाईया खे परमेशरो रा सेवक ए, पर जे तूँ बुराई करे, तो डर। कऊँकि तिने तलवार बेकारो रे नि लयी राखी बल्कि से परमेशरो रा सेवक ए ताकि तेसरे रोषो रे मुताबिक बुरे काम करने वाल़ेया खे दण्ड देओ। ");
INSERT INTO bfz_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","इजी री खातर तिना रे अधीन रणा ना बस तेस रोषो ते, बल्कि डरो ते जरूरी ए, बल्कि विवेक बी येई गवाई देओआ। ");
INSERT INTO bfz_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","इजी री खातर सरकारा खे मामला बी देओ, कऊँकि शासन करने वाल़े परमेशरो रे सेवक ए और सदा एसी कामो रे लगे रे रओए। ");
INSERT INTO bfz_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","इजी री खातर हर एकी रा अक्क चुकाया करो, जेसखे मामला चाईयो, तेसखे मामला देओ, जेसखे शुल्क चाईयो, तेसखे शुल्क देओ, जेसते डरना चाईयो, तेसते डरो, जेसरा आदर करना चाईयो, तेसरा आदर करो। जो तारीफा जोगा ए, तेसरी तारीफ करो। ");
INSERT INTO bfz_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","आपू बीचे प्यारो खे छाडी की केसी बी गल्ला रे केसी रे बी कर्जदार नि ओ। कऊँकि जो दूजे साथे प्यार राखोआ, तिने ई बिधान पूरा करी राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","मूसे रा बिधानो रे बऊत सारी आज्ञा ए कि व्याभिचार नि करना, अत्या, चोरी, लाल़च नि करना और इना खे छाडी की ओर कोई बी आज्ञा ओ तो सबी रा निचोड़ एसा आज्ञा रे मिलोआ कि आपणे पड़ोसिये ते आपू जेड़ा प्यार राख। ");
INSERT INTO bfz_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","प्यार पड़ोसियो री कुछ बी बुराई नि करदा। इजी री खातर जो प्यार करोआ से परमेशरो रे बिधानो खे पूरा करोआ। ");
INSERT INTO bfz_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","और बखतो खे पछयाणी की एड़ा ई करो, कऊँकि एबे तुसा खे नींजा ते जागणे री कअड़ी आईगी री, कऊँकि जेस बखते आसे विश्वास कित्तेया था, तेस बखतो रे बिचारो ते एबे आसा रा उद्धार नेड़े ए। ");
INSERT INTO bfz_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","रात बऊत बीती गी री और दिन निकल़ने वाल़ा ए, इजी री खातर आसे न्हेरे रे कामो खे छाडी कि जोतिया रे अथियार बानी लऊँए। ");
INSERT INTO bfz_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","जेड़ा दिनो खे अच्छा लगोआ, तेड़ी ई आसा सीदी चाल चलणी चाईयो, ना कि लीलाक्रीड़ा, पियक्कड़, ना व्याभिचार, ना लिचड़पण और ना चगड़े रे और जल़ना रे। ");
INSERT INTO bfz_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","बल्कि प्रभु यीशु मसीह खे पईनी लो और शरीरो री बुरी इच्छा खे पूरा करने रा उपाय नि करो। ");
INSERT INTO bfz_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","विश्वासो रे कमजोर लोका खे तिना रे विश्वासो रे बारे रे केसी बी शंका ते बगैर ई अपनाई लो। ");
INSERT INTO bfz_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","कऊँकि कुछ लोका खे विश्वास ए कि सब कुछ खाणा चाईयो, पर जो विश्वासो रे कमजोर ए, से साग-पात ई खाओआ। ");
INSERT INTO bfz_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","जो लोक मांस खाओए तिना खे शाकाहारी लोक तुच्छ नि समजो और शाकाहारी लोक मांस खाणे वाल़े लोका पाँदे दोष नि लगाओ। कऊँकि परमेशरे सेयो दोनो ई ग्रहण करी राखे। ");
INSERT INTO bfz_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","तूँ कुण ए जो प्रभुए रे सेवको पाँदे दोष लगाएया? तेसरा बणेया रा रणा और रुड़ना, तेसरे मालको तेई रिश्ता राखोआ, बल्कि से खड़ा ई करेया जाणा, कऊँकि प्रभु तेसखे खड़ा करी सकोआ। ");
INSERT INTO bfz_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","तिंयाँ ई कोई तो एकी दिनो खे, दूजे ते बड़ा मानोआ और केसी खे सब दिन एक जेड़े ए। हर एक आपणे ई मनो रे निश्चा करी लो। ");
INSERT INTO bfz_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","जो केसी खास दिनो खे मानोआ, से प्रभुए खे मानोआ। जो खाओआ, से प्रभुए री खातर खाओआ, कऊँकि से परमेशरो रा धन्यवाद करोआ और जो खांदा नि, से प्रभुए री खातर नि खांदा और परमेशरो रा धन्यवाद करोआ। ");
INSERT INTO bfz_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","कऊँकि आसा बीचा ते कोई ना तो आपणी खातर जिओआ और ना ई कोई आपणी खातर मरोआ। ");
INSERT INTO bfz_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","कऊँकि आसे जे जिऊँदे ए, तो प्रभुए री खातर जिऊँदे ए और जे मरूँए, तो प्रभुए री खातर मरूँए। ईंयां आसे जिऊँ, चाए मरूँ, आसे प्रभुए रेईए। ");
INSERT INTO bfz_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","कऊँकि मसीह इजी री खातर ई मरेया और जिऊँदा बी ऊआ, से मरे रा और जिऊँदेया रा सबी रा प्रभु ए। ");
INSERT INTO bfz_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","तूँ आपणे साथी विश्वासिया पाँदे दोष कऊँ लगाएया? या आपणे साथी विश्वासिया खे तुच्छ कऊँ समजेया? आसे सब परमेशरो रे न्याय आसणो सामणे खड़े ऊणे। ");
INSERT INTO bfz_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","कऊँकि पवित्र शास्त्रो रे लिखी राखेया, “प्रभु बोलोआ कि मेरी जिन्दगिया री कसम कि ‘हर एकी मेरे सामणे आपणे कुटणे टेकणे और हर एक माणूंआ परमेशर मानणा।’ ” ");
INSERT INTO bfz_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","तो आसा बीचा ते हर एकी परमेशरो खे आपणे-आपणे कामा रा लेखा देणा। ");
INSERT INTO bfz_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","तो आगे ते आसे एकी-दूजे पाँदे दोष नि लगाओ, पर तुसे येई ठाणी लो कि कोई आपणे पाईया सामणे ठेस या ठोकर खाणे री बजअ नि ओ। ");
INSERT INTO bfz_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","आऊँ जाणूंआ कि प्रभु यीशुए ते माखे निश्चा ऊई रा कि कोई बी खाणे री चीज आपू ते अशुद्ध निए। पर जो कोई तिजी खे अशुद्ध समजोआ, से तेसखे अशुद्ध ए। ");
INSERT INTO bfz_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","जे तेरा पाई तेरी रोटिया ते नराज ओआ, तो तेबे तूँ प्यारो ते नि चलदा। जेतेरी खातर मसीह मरेया, तेसखे तूँ आपणी रोटिया री बजअ ते नाश नि कर। ");
INSERT INTO bfz_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","जो तुसा री नजरा रे ठीक ए तिजी री दूजे लोक निंदा नि करो। ");
INSERT INTO bfz_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","कऊँकि परमेशरो रे राज्य रे खाणे-पीणे री अहमियत निए, बल्कि तर्म, मेल और खुशी ए जो पवित्र आत्मा ते ओआ। ");
INSERT INTO bfz_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","जो कोई इजी रीतिया ते मसीह री सेवा करोआ, से परमेशरो खे अच्छा लगोआ और मांणूआ बीचे ग्रहण करने जोगा ओआ। ");
INSERT INTO bfz_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","इजी री खातर आसा खे इना गल्ला री कोशिश करनी चाईयो जिना साथे मेल-जोल और एकी-दूजे रे विश्वासो खे मजबूत करने रे मताद मिलो। ");
INSERT INTO bfz_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","रोटिया री खातर परमेशरो रा काम नि बिगाड़। सब कुछ तो शुद्ध ए, पर तेस मांणूए खे बुरा ए, जेसखे तेसरी रोटी खाणे ते ठोकर लगोई। ");
INSERT INTO bfz_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","पला तो ये कि तूँ ना तो मांस खा और ना दाखरस पी और ना ई कुछ एड़ा कर, जेते की तेरा साथी विश्वासी ठोकर खाओ। ");
INSERT INTO bfz_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","इना चीजा रे बारे रे जो बी तुसा रा विश्वास ओ, से तुसा रे और परमेशरो बीचली गल्ल ए। धन्य से माणूं जो तेसा गल्ला रे, जेसखे से ठीक समजोआ, आपणे आपू खे दोषी नि मानदा ");
INSERT INTO bfz_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","पर जो शक करी की खाओआ, से दण्डो जोगा ठईरी चुकेया, कऊँकि से विश्वास करी की नि खांदा। जो कुछ विश्वासो ते निए, से पाप ए। ");
INSERT INTO bfz_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","जे म्हारा विश्वास मजबूत ए तो तिना साथी विश्वासिया साथे जिना रा विश्वास कमजोर ए तिना साथे धीरज राखो। आसा खे आपणे आपू खे खुश करने रे बदले तिना खे खुश करने री कोशिश करनी चाईयो। ");
INSERT INTO bfz_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","आसा बीचा ते हर एक आपणे साथी विश्वासिया खे तेसरी पलाईया खे तिना खे खुश करो और तिना रे विश्वासो खे मजबूत करने री कोशिश करो कि तिना री तरक्की ओ। ");
INSERT INTO bfz_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","कऊँकि मसीहे आपणे आपू खे खुश नि कित्तेया, पर जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “तेरी निन्दा करने वाल़ेया मेरी निन्दा करी राखी।” ");
INSERT INTO bfz_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","जितणिया गल्ला पईले तेई पवित्र शास्त्रो रे लिखी राखी थिया, सेयो आसा री ई शिक्षा री खातर ई लिखिया ताकि आसे सब्र और पवित्र शास्त्रो री शान्तिया रे जरिए उम्मीद राखूँ। ");
INSERT INTO bfz_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","आँऊ प्रार्थना करूँआ कि सब्र और इमम्ती रा दाता परमेशर तुसा खे ये बरदान देओ कि यीशु मसीह रे मुताबिक आपू बीचे एक मन ऊई कि रओ। ");
INSERT INTO bfz_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ताकि तुसे एक मन और एक आवाज ऊई की आसा रे प्रभु यीशु मसीह रे पिता परमेशरो री बढ़ाई करो। ");
INSERT INTO bfz_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","तेबे, जेड़ा मसीहे बी परमेशरो री महिमा री खातर तुसे अपनाए, तेड़े ई तुसे बी एकी-दूजे खे अपणाओ। ");
INSERT INTO bfz_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","आऊँ बोलूँआ कि जो वादे बाप-दादेया खे दित्ते थे, तिना खे मजबूत करने खे, मसीह, परमेशरो री सच्चाईया रा सबूत देणे खे खतना कित्ते रे लोका रा सेवक बणेया। ");
INSERT INTO bfz_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","और दूजी जाति बी परमेशरो री दया पाई कि तेसरी बढ़ाई करो। जेड़ा पवित्र शास्त्रो लिखी राखेया, “इजी री खातर जातिया-जातिया बीचे मां तेरा धन्यवाद करना और तेरे नाओं रे पजन गाणे।” ");
INSERT INTO bfz_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","फेर बोली राखेया, “ओ दूजिया जातिया रे सब लोको, परमेशरो री प्रजा साथे खुशी मनाओ।” ");
INSERT INTO bfz_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","एकी ओरी जगा लिखी राखेया, “ओ दूजिया जातिया रे सब लोको, प्रभुए री स्तुति करो और ओ राज्य-राज्य रे सब लोको, तेसखे सराओ।” ");
INSERT INTO bfz_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","और तेबे यशायाह बोलोआ, “यिशै रे वंशो ते एक सामणे आऊणा और दूजी जातिया रा हाकिम ऊणे खे उठणा, तेस पाँदे दूजी जातिया उम्मीद राखणी।” ");
INSERT INTO bfz_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","आँऊ परमेशरो ते प्रार्थना करूँआ कि जो उम्मीदा रा दाता ए, तुसा खे विश्वास करने रे सब प्रकारा री खुशी और शान्तिया ते परिपूर्ण करो, ताकि पवित्र आत्मा री सामर्था ते तुसा री उम्मीद बड़दी जाओ। ");
INSERT INTO bfz_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ओ मेरे साथी विश्वासियो! माखे आपू बी तुसा रे बारे रे निश्चा ए कि तुसे आपू बी पलाईया ते फरे रे और परमेशरो रे ज्ञानो ते बी फरे रे ए और एकी दूजे खे समजयाई सकोए। ");
INSERT INTO bfz_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तेबे बी मैं केथी-केथी याद दलाणे खे, तुसा खे बऊत इम्मत करी की लिखेया, ये तेस अनुग्रहो री बजअ ते ऊआ, जो परमेशरे माखे देई राखेया। ");
INSERT INTO bfz_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","आऊँ दुजिया जातिया खे प्रभु यीशु मसीह रा सेवक ऊई की परमेशरो रे सुसमाचारो री सेवा, पुरोईतो जेड़ी करुँ। जेते कि दूजी जाति परमेशरो रे आगे अपनाणे जोगी भेंट बणी सको और पवित्र आत्मा रे जरिए परमेशरो खे पूरी तरअ ते पवित्र बणो। ");
INSERT INTO bfz_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","तो आऊँ यीशु मसीह री बजअ तेई परमेशरो री सेवा रे गर्व करी सकूँआ। ");
INSERT INTO bfz_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","आँऊ ये बोलणे खे इम्मत राखूँआ कि मसीहे मेरे जरिए जो नौखा काम करी राखेया जेतेरा नतीजा ये निकल़ेया कि दूजिया जातिया रे लोके परमेशरो पाँदे विश्वास कित्तेया जेबे तिने मेरा वचन सुणेया और मेरे काम देखे। ");
INSERT INTO bfz_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ये सब चिह्न् और अचम्बे रे काम पवित्र आत्मा री सामर्था ते मेरे ई जरिए कित्ते। एथो तक कि मैं यरूशलेमो ते लयी की चऊँ कनारे इल्लुरिकुमो तक, मसीह रे सुसमाचारो रा पूरा-पूरा प्रचार कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","मेरे मनो री खुशी ये कि जेती-जेती यीशु मसीह रा नाओं नि लया, तेथी सुसमाचार सुणाऊँ, एड़ा नि ओ कि दूजे री निऊँवा पाँदे कअर बणाऊँ। ");
INSERT INTO bfz_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","पर जेड़ा पवित्र शास्त्रो रे लिखी राखेया, तेड़ा ई ओ, “जेसगे तेसरा सुसमाचार नि पऊँछेया, तिना ई देखणा और जिने सुणेया नि, सेयो ई समजणा।” ");
INSERT INTO bfz_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","तेबेई तो आऊँ तुसा गे आऊणे ते बार-बार रूकेया रा रया। ");
INSERT INTO bfz_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","पर एबे माखे इना प्रदेशा रे मेरे कामा खे ओर जगा नि रई और बऊत साला ते माखे तुसा गे आऊणे री इच्छा ए। ");
INSERT INTO bfz_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","तेबे, जेबे आऊँ स्पेनो खे जाऊँगा, तो तुसा गिये ई जाऊँगा, कऊँकि माखे उम्मीद ए कि तेसा यात्रा रे आऊँ तुसा ते मिलूँ, और जेबे तुसा री संगतिया ते मेरा जिऊ कुछ फरी जाओ, तो तुसे माखे स्पेनो रे सफरो खे मताद करी कि आगे पऊँछाई देओ। ");
INSERT INTO bfz_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","पर एबु तो परमेशरो रे लोका री सेवा करने खे यरूशलेमो खे जाऊँआ। ");
INSERT INTO bfz_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","कऊँकि मकिदुनिया और अखाया प्रदेशो रे लोका खे ये अच्छा लगेया कि यरूशलेमो रे परमेशरो रे लोका रे गरीबा खे कुछ चंदा कट्ठा करिए। ");
INSERT INTO bfz_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","तिने ये खुशिया साथे तो कित्तेया, सेयो यरूशलेमो रे रणे वाल़े लोका रे कर्जदार बी ए, कऊँकि जेबे दूजी जातिया रे लोके तिना ते आत्मिक धन पाई राखेया तो तिना खे बी ठीक ए कि शारीरिक गल्ला रे तिना री सेवा करो। ");
INSERT INTO bfz_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","तो तेबे आऊँ एस कामो खे पूरा करी की और तिना गे एस चंदे खे सम्बाल़ी कि तुसा गिये ऊँदा ऊआ स्पेनो खे जाऊँगा। ");
INSERT INTO bfz_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","और आऊँ जाणूंआ कि जेबे आऊँ तुसा गे आऊणा, तो मसीह री पूरी आशीषा साथे आऊणा। ");
INSERT INTO bfz_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","और ओ साथी विश्वासियो! आऊँ प्रभु यीशु मसीह रा जो आसा रा प्रभु ए और पवित्र आत्मा रे प्यारो री याद दलाई की तुसा ते बिनती करूँआ कि माखे परमेशरो ते प्रार्थना करने खे मां साथे लौलीन रओ। ");
INSERT INTO bfz_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ताकि आऊँ यहूदिया प्रदेशो रे अविश्वासिया ते बचे रा रऊँ और मेरी से सेवा, जो यरूशलेमो खे ए, परमेशरो रे लोका खे अच्छी लगो ");
INSERT INTO bfz_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","और आऊँ परमेशरो री इच्छा ते तुसा गे खुशिया साथे आयी की तुसा साथे आराम करुँ। ");
INSERT INTO bfz_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","आँऊ प्रार्थना करूँआ शान्तिया रा परमेशर तुसा सबी साथे रओ। आमीन्। ");
INSERT INTO bfz_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","आँऊ पौलुस फिबे खे बिनती करूँआ कि तुसे तेसा रा आदर करो। से आसा री साथी विश्वासी बईण और किंख्रिया नगरो री मण्डल़िया री सेविका ए। ");
INSERT INTO bfz_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","तुसे लोक बईण फिबे खे प्रभुए री सेविका जाणी की तेसा रा स्वागत करो। और जेसा केसी गल्ला रे तेसा खे तुसा ते मतलब ओ, तेसा री मताद करो। कऊँकि तेसा रा बऊत जणेया पाँदे, बल्कि मां पाँदे बी तेसा रा उपकार ए। ");
INSERT INTO bfz_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","बईण प्रिस्किल्ला और तेसा रा लाड़ा अक्विला खे बी, जो यीशु मसीह रे मां साथे काम करने वाल़े ए, नमस्ते। ");
INSERT INTO bfz_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","तिने मेरा प्राण बचाणे खे आपणी जिन्दगी दाव पाँदे लगाईती थी और बस आऊँ ई नि, बल्कि दूजी जातिया री सारी मण्डल़ी बी, तिना रा धन्यवाद करोई। ");
INSERT INTO bfz_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","और तेसा मण्डल़िया खे बी नमस्कार, जो तिना रे कअरे कट्ठे ओए। मेरे प्यारे इपैनेतुसो खे, जो मसीह खे अपनाणे वाल़ेया बीचा ते आसिया प्रदेशो रा पईला फल ए, नमस्ते। ");
INSERT INTO bfz_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","मरियमा खे, जेसे तुसा री खातर बऊत मईणत कित्ती, नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","पाई अन्द्रुनीकुस और बईण यूनियासो खे, जो मां जेड़े ई यहूदी ए और मां साथे जेला रे कैद ऊए थे, तिना खे मां पौलुसो रा नमस्कार। सेयो लोक प्रेरिता बीचे जाणे-माणे रे थे और मांते पईले मसीह खे मानणे वाल़े ऊए। ");
INSERT INTO bfz_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","पाई अम्पलियातुसो खे, जो प्रभुए रे मेरा प्यारा ए, नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","पाई उरबानुसो खे, जो मसीह रे आसा साथे काम करने वाल़ा ए और मेरे प्यारे इस्तखुसो खे नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","अप्पिलेसो खे जो मसीह रे खरा निकल़ेया, नमस्कार। अरिस्तुबुलुस रे कराने खे नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","मेरे साथी यहूदी पाई हेरोदियोनो खे नमस्कार। नरकिस्सुसो रे कराने रे जो लोक प्रभुए रे ए, तिना खे नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","प्रभुए री सेवा रे मईणत करने वाल़िया जवाणसा त्रूफैना और त्रूफोसा खे, जो प्रभुए रे मईणत करोए, नमस्कार। प्यारी बईण पिरसिसो खे, जिने प्रभुए रे बऊत मईणत कित्ती, नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","रूफुसो खे, जो प्रभुए रे चुणी राखेया और तेसरी आम्मा खे जो मेरी बी आम्मा जेड़ी ए, दूँईं खे नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","असुक्रितुसो और फिलगोन, हिर्मेस, पत्रुबास, हिर्मास और तिना रे साथले साथी विश्वासिया खे, नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","फिलुलुगुस, यूलिया, नेर्युस और तेसरी बईण, उलुम्पास और तिना साथले सब परमेशरो रे लोका खे नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","आपू बीचे गल़े लगी की नमस्कार करो। तुसा खे मसीह री सारी मण्डल़िया री तरफा ते नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","एबे ओ साथी विश्वासियो, आऊँ तुसा ते बिनती करूँआ कि तिना लोका ते चौकस रओ जो तेसा शिक्षा रे खलाफ, जो तुसे पाई राखी और से फूट पड़ने और ठोकर खाणे री बजअ ओए। तिना ते दूर रओ। ");
INSERT INTO bfz_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","कऊँकि एड़े लोक म्हारे प्रभु मसीह री नि, बल्कि आपणे पेटो री सेवा करोए। सेयो लोक चिकणी-चूपड़िया गल्ला करी की सीदे-सादे मनो वाल़े लोका खे बईकाई देओए। ");
INSERT INTO bfz_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","तुसा री आज्ञा मानणे रे बारे रे सबी लोका खे पता लगी गा रा। इजी री बजअ ते आऊँ तुसा रे बारे रे खुश ओऊँआ। पर आऊँ ये चाऊँआ कि तुसे पलाईया खे, अक्लमंद, पर बुराईया खे पोल़े बणे रे रओ। ");
INSERT INTO bfz_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","परमेशरो जो शान्तिया रा दाता ए, तुसा रे पैरो निठे शैतानो खे तुसा ते चट ई मंडाणा। म्हारे प्रभु यीशुए री कृपा तुसा पाँदे सदा ऊँदी रओ। ");
INSERT INTO bfz_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","मां साथे काम करने वाल़ा तीमुथियुसो री तरफा ते और मेरे यहूदी साथी लूकियुस, यासोन और सोसिपत्रुस तुसा लोका खे नमस्कार बोलोए। ");
INSERT INTO bfz_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","आँऊ तिरतियुस जो पौलुसो री तरफा ते ये चिट्ठी लिखणे लगी रा, प्रभुए रे तुसा लोका खे नमस्कार बोलूँआ। ");
INSERT INTO bfz_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","गयुस रा, जो मेरी और मण्डल़िया री पराऊणचारी करने वाल़ा ए, तेसरा तुसा खे नमस्कार। इरास्तुस, जो नगरो रा पण्डारी ए और पाई क्वारतुसो रा, तुसा खे नमस्कार। ");
INSERT INTO bfz_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","आँऊ प्रार्थना करूँआ कि आसा रे प्रभु यीशु मसीह री कृपा, तुसा सबी लोका पाँदे सदा ऊँदी रओ। ");
INSERT INTO bfz_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","तेस परमेशरो री स्तुति ओ, जो तुसा लोका खे मेरे सुसमाचार और प्रभु यीशु मसीह रे संदेशो रे मुताबिक स्थिर राखणे रे सामर्थी ए। ये सुसमाचार से पेत ए जो जुगो-जुगो ते छिपेया रा था। ");
INSERT INTO bfz_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","पर एबे सामणे आयी की सनातन परमेशरो री आज्ञा ते, भविष्यबक्तेया रे पवित्र शास्त्रो री कताबा रे जरिए, सबी जातिया खे बताया कि सेयो विश्वासो ते आज्ञा मानणे वाल़े ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","तेस कल्ले अक्लमंद परमेशरो री बऊत जादा, प्रभु यीशु मसीह रे जरिए, जुगो-जुगो तक महिमा ऊँदी रओ। आमीन्।");
INSERT INTO bfz_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ये चिट्ठी मां पौलुस और आसा रे पाई सोस्थिनेसो री तरफा ते ए। आँऊ परमेशरो री इच्छा ते यीशु मसीह रा प्रेरित ऊणे खे बुलाई राखेया। ");
INSERT INTO bfz_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","आँऊ ये चिट्ठी परमेशरो री तेसा मण्डल़िया खे लिखूँआ जो कुरिन्थुस नगरो रे ए। तुसे लोक यीशु मसीह रे जरिए पवित्र कित्ते रे और तिना सबी परमेशरो रे लोका साथे तुसे बी तिना रे लोक ऊणे खे बुलाए राखे जो हर जगा आसा रे प्रभु यीशु मसीह रे नाओं री मतलब से जो आसा रा और तिना रा सबी रा प्रभु ए, स्तुति करोए। ");
INSERT INTO bfz_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","आँऊ प्रार्थना करूँआ कि म्हारे पिता परमेशर और प्रभु यीशु मसीह री तरफा ते, तुसा खे कृपा और शान्ति मिलदी रओ। ");
INSERT INTO bfz_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","आऊँ तुसा रे बारे रे आपणे पिता परमेशरो रा धन्यवाद सदा करूँआ, कऊँकि परमेशरो तुसा खे कृपा ते यीशु मसीह साथे एक करने रे जरिए बऊत आशीष देई राखी। ");
INSERT INTO bfz_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","तुसे लोक यीशु मसीह रे हर तरअ ते भरपूर करी राखे। से ये ए कि तिने तुसा खे आपणे वचन बोलणे और समजणे खे हर तरअ ते खास काबलियत देई राखी। ");
INSERT INTO bfz_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ये तेसा गल्ला खे साबित करोआ कि मैं मसीह रे बारे जो बताया था से सच ए। ");
INSERT INTO bfz_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","नतीजन एस बखते, जबकि तुसे आसा रे प्रभु यीशु मसीह रे आऊणे री बड़ी बेसबरिया साथे इन्तजार करने लगी रे, तुसा रे पवित्र आत्मा रे जरिए दित्ते रे केसी बी आत्मिक बरदानो री कमी निए। ");
INSERT INTO bfz_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","परमेशरो तुसे आखरी तक विश्वासो रे मजबूत बी करने, ताकि तुसे आसा रे प्रभु यीशु मसीह रे आऊणे तक निर्दोष ठईरो। ");
INSERT INTO bfz_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","परमेशर विश्वासो जोगा ए, जिने तुसे आपणे पुत्र, आसा रे प्रभु यीशु मसीह री संगतिया रे बुलाई राखे। ");
INSERT INTO bfz_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ओ साथी विश्वासियो! आऊँ तुसा ते आसा रे प्रभु यीशु मसीह रे नाओं ते बिनती करूँआ कि तुसे सब एक ई गल्ल बोलो और तुसा बीचे फूट नि ओ, पर एक ई मन और एक ई इरादा करी की मिले रे रओ। ");
INSERT INTO bfz_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","कऊँकि ओ मेरे साथी विश्वासियो! खलोए रे कराने रे लोके, मांगे तुसा रे बारे रे बताई राखेया कि तुसा बीचे चगड़े ऊणे लगी रे। ");
INSERT INTO bfz_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","मेरे बोलणे रा मतलब ये ए कि तुसा बीचा ते कोई आपणे आपू खे पौलुसो रा चेला, कोई अपुल्लोसो रा, कोई पतरसो रा और कोई मसीह रा चेला बोलोआ। ");
INSERT INTO bfz_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","तुसे लोक जो करने लगी रे से ठीक निए, क्या मसीह बंटी गा रा? क्या पौलुस तुसा री खातर क्रूसो पाँदे चढ़ाया? या क्या तुसा खे पौलुसो रे नाओं ते बपतिस्मा मिलेया? ");
INSERT INTO bfz_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","आऊँ परमेशरो रा धन्यवाद करूँआ कि क्रिस्पुस और गयुस इना दो पाईया खे छाडी की मैं तुसा बीचा ते केसी खे बी बपतिस्मा नि दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","केथी एड़ा नि ओ कि कोई बोलो कि तुसा खे मेरे नाओं ते बपतिस्मा मिलेया। ");
INSERT INTO bfz_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","और आ, मैं स्तिफनासो रे कराने खे बी बपतिस्मा दित्तेया, इना खे छाडी की आऊँ नि जाणदा कि मैं ओरी केसी खे बपतिस्मा दित्तेया। ");
INSERT INTO bfz_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","यीशु मसीहे आऊँ बपतिस्मा देणे नि पेजेया। बल्कि तिने आँऊ सुसमाचार प्रचार करने पेजी राखेया और मैं ये काम मांणूआ रे शब्दो रे ज्ञानो रे मुताबिक नि कित्तेया एड़ा नि ओ कि मसीह रा क्रूस बेकार ठईरो। ");
INSERT INTO bfz_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","जो लोक विनाशो री बाटा रिये चलोए तिना लोका खे क्रूसो री शिक्षा मुर्खता री गल्ल ए। पर आसा लोका खे जो उद्धारो री बाटा रिये चलोए क्रूसो री शिक्षा परमेशरो री सामर्थ ए। ");
INSERT INTO bfz_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","कऊँकि पवित्र शास्त्रो रे लिखी राखेया, “मां ज्ञानवानो रा ज्ञान नाश करना और समजदारा री समज तुच्छ करी देणी।” ");
INSERT INTO bfz_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","तो फेर समजदार लोका खे आसे क्या बोलिये? यहूदी बिधानो रे जाणने वाल़े माहिर शास्त्रिए रे बारे रे आसे क्या बोलिये? दुनिया रे तिना लोका रे बारे आसे क्या बोलिये जो बोलणे रे बऊत चलाक ए? परमेशरे दुनिया रा ज्ञान मूर्ख और बेकार ठराईता रा। ");
INSERT INTO bfz_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","कऊँकि परमेशरे आपणे ज्ञानो रे मुताबिक ये देखेया कि दुनिया रे लोक आपणे ज्ञानो रे जरिए तिना खे कदी बी नि जाणी सकदे, तेबेई तिना लोका रा उद्धार करने खे जो विश्वास करोए सुसमाचारो रे प्रचारो रा इस्तेमाल कित्तेया, हालाँकि कुछ लोक इजी खे मूर्खता री गल्ल समजोए।। ");
INSERT INTO bfz_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ये यहूदी लोका खे मूर्खता री गल्ल ए जो स्वर्गो ते चिह्न् चाओए, और दूजिया जातिया रे लोका खे बी मूर्खता री गल्ल ए जो मांणूआ रे ज्ञानो री टोल़ा रे ए। ");
INSERT INTO bfz_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","पर आसे तो तेस क्रूसो पाँदे चढ़ाए रे मसीह रा प्रचार करूँए, जो यहूदिया खे ठोकरा री बजअ और दूजिया जातिया खे मूर्खता री गल्ल ए। ");
INSERT INTO bfz_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","पर परमेशरो रे चुणे रे लोका खे क्या यहूदी, क्या दूजी जाति दूँईं खेई येई मसीह परमेशरो री सामर्थ और परमेशरो रा ज्ञान ए। ");
INSERT INTO bfz_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","कऊँकि परमेशरो री मूर्खता, मांणूआ रे ज्ञानो ते ज्ञानवान ए और परमेशरो री कमजोरी, मांणूआ री तागती ते बऊत तागतबर ए। ");
INSERT INTO bfz_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ओ साथी विश्वासियो! आपणे तिना दिना खे याद करो जेबे तुसे परमेशरे बुलाए थे तेबे तुसे न तो दुनिया री नजरा रे ज्ञानी थे, न ई बऊत तागतबर थे और न ई समाजो रे तुसा रा कोई दबदबा था। ");
INSERT INTO bfz_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ज्ञानी मांणू शर्मिंदा करने खे परमेशरे सेयो चूणी ले रे, जिना खे दुनिया मूर्ख समजोई। तागतबरा खे बी शर्मिंदा करने खे तिने सेयो चूणी ले रे, जो दुनिया री नजरा रे कमजोर ए। ");
INSERT INTO bfz_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","गणमानय लोका रे कमण्डो खे चूर करने खे परमेशरे सेयो लोक चूणी ले जो दुनिया री नजरा रे नीच, तुच्छ और कुछ नि समजे जाओए। ");
INSERT INTO bfz_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","परमेशरे एड़ा इजी खे कित्तेया ताकि कोई बी प्राणी तेसरे सामणे कमण्ड नि करी सको। ");
INSERT INTO bfz_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","पर परमेशरे आसे यीशुए साथे एक करी ते रे और मसीह रे जरिए तिने आसा खे आपणा ज्ञान दित्तेया। परमेशर आपणी नजरा रे आसा खे तर्मी बी बणाओआ। तिने मसीह रे जरिए आसे पवित्र करी राखे और से आसा खे आसा रे पापो ते छुटकारा देओआ। ");
INSERT INTO bfz_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ताकि जेड़ा पवित्र शास्त्रो रे लिखी राखेया, तेड़ा ई ओ, “जो कमण्ड करो, से सिर्फ प्रभुए पाँदे कमण्ड करो।” ");
INSERT INTO bfz_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ओ साथी विश्वासियो! जेबे आऊँ परमेशरो रा पेत सुणांदा ऊआ तुसा गे आया था, तो आँऊ बड़े शब्दा रा या मांणूआ रे ज्ञानो रा इस्तेमाल नि कित्तेया। ");
INSERT INTO bfz_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","कऊँकि मैं ये ठाणी ला था कि तुसा बीचे यीशु मसीह, बल्कि क्रूसो पाँदे चढ़ाए रे मसीह खे छाडी की ओरी केसी गल्ला खे नि जाणूं। ");
INSERT INTO bfz_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","आऊँ कमजोर और डरो साथे और बऊत थरथरांदा ऊआ, तुसा साथे रया ");
INSERT INTO bfz_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","और मेरी शिक्षा और मेरे प्रचारो रे ज्ञानो री लुबाणे वाल़िया गल्ला नि थिया, बल्कि पवित्र आत्मा और सामर्था रा सबूत था। ");
INSERT INTO bfz_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","इजी खे तुसा रा विश्वास मांणूआ रे ज्ञानो पाँदे नि, बल्कि परमेशरो री सामर्था पाँदे निर्भर ओ। ");
INSERT INTO bfz_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","फेर बी आँऊ तिना लोका खे ज्ञानो रा संदेश सुणाऊँआ, जो आत्मिक तौरो पाँदे सिद्ध ए। पर ये ज्ञान ना तो एसा दुनिया रा और ना एसा दुनिया रे हाकिमा राए, जिना रा नाश ऊणा तय ए। ");
INSERT INTO bfz_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","पर आसे परमेशरो रा से गुप्त ज्ञान, पेतो री रीतिया पाँदे बताऊँए, जो परमेशरे जुगो ते आसा री महिमा खे ठराया। ");
INSERT INTO bfz_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","परमेशरो री एसा योजना खे दुनिया रे हाकिमा बीचा ते किने नि समजेया, कऊँकि जे समजदे तो तेजोमय प्रभुए खे क्रूसो पाँदे नि चढ़ांदे। ");
INSERT INTO bfz_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","पर जेड़ा पवित्र शास्त्रो रे लिखी राखेया, “जो गल्ला आखी ते नि देखिया और ना कानो ते सुणिया और जो गल्ला मांणूआ रे चित्तो रे नि चढ़िया सेयो ई आईया, जो परमेशरे आपणे प्यार करने वाल़ेया खे त्यार करी राखिया।” ");
INSERT INTO bfz_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","पर परमेशरे इना गल्ला खे पवित्र आत्मा रे जरिए आसा प्रेरिता पाँदे प्रगट कित्तेया। पवित्र आत्मा सब गल्ला, बल्कि परमेशरो रिया खास गल्ला बी जाणोआ। ");
INSERT INTO bfz_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","मांणूआ बीचा ते कुण केसी मांणूआ री गल्ल जाणोआ? बस मांणूआ री आपणी आत्मा जो तेसरे ए। तिंयाँ ई परमेशरो री गल्ला कोई नि जाणदा, बस परमेशरो री आत्मा ई जाणोई। ");
INSERT INTO bfz_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","पर आसा रे दुनिया रा आत्मा निए, पर से आत्मा पायी राखेया, जो परमेशरो री तरफा ते ए कि आसे तिना गल्ला खे जाणूं, जो परमेशरे आसा खे देई राखिया। ");
INSERT INTO bfz_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","जेबे आसे ये गल्ला तुसा खे सिखाऊँए तो मांणूआ री तरफा ते आये रे ज्ञानो रा इस्तेमाल नि करदे। बल्कि आसे तिना वचना खे बोलूँए जो आत्मा रे जरिए देई राखे, आत्मिक सच्चाईया री व्याख्या करने खे पवित्र आत्मा रे वचनो खे इस्तेमाल करोए। ");
INSERT INTO bfz_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","पर शारीरिक मांणू परमेशरो री आत्मा री सच्चाई ग्रहण नि करदा, कऊँकि सेयो तिना री नजरा रे मूर्खता री गल्ला ए और ना से तिना खे जाणी सकोआ, कऊँकि तिना री परख आत्मिक रीतिया ते ओई। ");
INSERT INTO bfz_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","आत्मिक जणा सब कुछ जाणोआ, पर से आपू केसी ते नि परखेया जांदा। ");
INSERT INTO bfz_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","कऊँकि प्रभुए रा मन किने जाणी राखेया कि तेसखे सखयाओ? पर आसा रे मसीह रा मन ए। ");
INSERT INTO bfz_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ओ साथी विश्वासियो, जेबे आऊँ तुसा साथे था तो तुसा लोका खे गईरी शिक्षा नि देई सकेया जिंयाँ आऊँ आत्मिक लोका खे देऊँआ। मैं तुसा साथे ईंयां गल्ला कित्तिया मानो तुसे शारीरिक लोक ए या जेड़े कि मसीह जिन्दगिया रे छोटे बच्चे ओ। ");
INSERT INTO bfz_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","तेस बखते मैं तुसा लोका खे परमेशरो रे वचनो री शुरूओ री शिक्षा तो दित्ती पर गईरी शिक्षा नि दित्ती कऊँकि तुसे तेस बखते एड़ी शिक्षा समजणे जोगे नि थे। सच तो ये ए कि तुसे इजी खे एबे बी नि समजी सकदे। ");
INSERT INTO bfz_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","तुसे विश्वासी ऊई की बी तुसा रा बर्ताव एबुए तक अविश्वासिया जेड़ा ए। आऊँ जाणूंआ कि तुसा बीचा ते कई जणे एकी दूजे ते जल़ो ए और चगड़ा करोए और अविश्वासिया जेड़ा न्याय करोए? क्या तुसे अविश्वासी मांणूआ री रीतिया पाँदे नि चलदे? ");
INSERT INTO bfz_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","कऊँकि जेबे एक बोलोआ कि आऊँ पौलुसो राए और दूजा कि आऊँ अपुल्लोसो रा, तो क्या तुसा रा सबाओ संसारिक मांणूए जेड़ा निए? ");
INSERT INTO bfz_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","तो फेर अपुल्लोस कुणे ए? और पौलुस कुणे ए? आसे लोक परमेशरो रे बस सेवक ईए, जिना रे जरिए तुसे मसीह रे विश्वास कित्तेया। आसा बीचा ते हर कोई से काम करोआ जो काम करने खे प्रभुए देई राखेया। ");
INSERT INTO bfz_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","जे आँऊ तुसा री तुलना डोरूआ ते करूँ तो आँऊ ई से ए जिने तुसा रे दिलो रे वचनो रा बीज बाई राखेया और अपुल्लोसे से सिंजेया। पर परमेशर ईए जिने से बढ़ाया। ");
INSERT INTO bfz_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","इजी री खातर ना तो बाणे वाल़े रा और ना सिंजणे वाल़े रा कुछ महत्व ए, पर सिर्फ परमेशरो रा महत्व ए जो तिने से बढ़ाई राखेया ए। ");
INSERT INTO bfz_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","बाणे वाल़े और सिंजणे वाल़े दूँईं रा एक ई मकसद ए, पर हर एक मांणूए आपणी ई मईणता रे मुताबिक परमेशरो ते आपणी मजदूरी पाणी। ");
INSERT INTO bfz_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","कऊँकि आसे दोनो मिली की परमेशरो खे काम करूँए। तुसे कुरिन्थो रे विश्वासी परमेशरो री खेती और परमेशरो रे कअर ए। ");
INSERT INTO bfz_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","परमेशरो री तेसा कृपा रे मुताबिक, जो माखे देई राखी, मैं अक्लमंद राजमिस्त्रिए जेड़ी निऊँ पाई और दूजा तेते पाँदे रद्दा राखोआ, पर हर एक मांणू चौकस रओ कि से तेस पाँदे केड़ा रद्दा राखोआ। ");
INSERT INTO bfz_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","कऊँकि तेसा निऊँआ खे छाडी की जो पड़ी री ए और से प्रभु यीशु मसीह ए, कोई दूजी निऊँ नि पाई सकदा ");
INSERT INTO bfz_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","जे मसीह सेवक परमेशरो री तरफा ते दित्ती री सई शिक्षा खे सिखाओए तो सेयो तेस कअरो खे बनाणे वाल़ेया जेड़े ए जिने सुईना, चाँदी और मईंगा पात्थरो जेड़ी अच्छी किस्मा री चीजा रा इस्तेमाल करी की निऊँ बणाई। पर जे से चूठी शिक्षा सिखाओए तो से तेस कअरो खे बनाणे वाल़े जेड़े ए जो काठ, काआ और पुओ जेड़ा कटिया समानो रा इस्तेमाल करी की निऊँ पाओए। ");
INSERT INTO bfz_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","पर न्याय रे दिनो रे आगी रे जरिए प्रकट ऊई जाणा कि हर एक कअर बनाणे वाल़ेया केड़ा काम करी राखेया। आगी रे जरिए हर काम परखेया जाणा कि से काम केड़ा ए। ");
INSERT INTO bfz_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","जे केसी रे जरिए बणाया रा कअर तिजी पाँदे बणे रा खड़ा रओगा तो तेस तिजी रा इनाम पाणा। ");
INSERT INTO bfz_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","पर जे मसीह केसी मांणूए खे बोलोआ कि इने अच्छा काम नि करी राखेया तो तेस मांणूए मसीह री तरफा ते इनाम नि पाणा। पर तेस मांणूए परमेशरो रे जरिए दित्ती री अनन्त जिन्दगी नि खोणी। ");
INSERT INTO bfz_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","क्या तुसे नि जाणदे कि तुसे परमेशरो रा मन्दर ए और परमेशरो री पवित्र आत्मा तुसा रे वास करोआ? ");
INSERT INTO bfz_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","जे कोई परमेशरो रे मन्दरो खे नाश करोगा, तो परमेशरो से नाश करी देणा। कऊँकि परमेशरो रा मन्दर पवित्र ए और से मन्दर तुसे ए। ");
INSERT INTO bfz_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","कोई आपणे आपू खे तोखा नि देओ, जे तुसा बीचा ते कोई एसा दुनिया री नजरा रे आपणे आपू खे ज्ञानी समजोआ, तो से मूर्ख बणो कि ज्ञानी ऊई जाओ। ");
INSERT INTO bfz_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","कऊँकि एसा दुनिया रा ज्ञान परमेशरो रे नेड़े मूर्खता ए, जेड़ा कि पवित्र शास्त्रो रे लिखी राखेया, “से ज्ञानिया खे तिना री चलाकिया रे फसाई देओआ।” ");
INSERT INTO bfz_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","और फेर पवित्र शास्त्र ये बी बोलोआ, “प्रभु ज्ञानिया रे बचारा खे जाणोआ कि बेकार ए।” ");
INSERT INTO bfz_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","इजी री खातर मांणूआ पाँदे कोई कमण्ड नि करो कऊँकि सब कुछ तुसा राए। ");
INSERT INTO bfz_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","क्या पौलुस, क्या अपुल्लोस, क्या पतरस, क्या दुनिया, क्या जिन्दगी, क्या मरण, क्या बर्तमान, क्या भविष्य, सब कुछ तुसा राए ");
INSERT INTO bfz_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","और तुसे मसीह रे ए और मसीह परमेशरो राए। ");
INSERT INTO bfz_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","तुसे लोक आसा खे मसीह रे सेवक और परमेशरो रे पेतो रा पण्डारी समजो जिना खे सुसमाचारो री लुकी री सच्चाईया खे समजयाणे रा काम समाल़ी राखी। ");
INSERT INTO bfz_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","एबे पण्डारियो ते ये उम्मीद कित्ती जाओई कि से विश्वासो जोगा निकल़ो। ");
INSERT INTO bfz_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","पर मेरी नजरा रे ये बऊत छोटी गल्ल ए कि तुसे या मांणूआ रा कोई न्यायी माखे परखो, बल्कि आऊँ बी आपणे आपू खे नि परखदा। ");
INSERT INTO bfz_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","कऊँकि मेरा विवेक माखे केसी बी गल्ला रे दोषी नि ठरांदा, पर इजी ते आऊँ निर्दोष नि ठईरदा कऊँकि मेरा परखणे वाल़ा प्रभु ए। ");
INSERT INTO bfz_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","तो जदुओ तक प्रभु नि आओ, बखतो ते पईले केसी बी गल्ला रा न्याय नि करो, तेसी तो न्हेरे रे लकोईया रिया गल्ला प्रयासे रे दखाणियां और मनो रे विचार सामणे ल्याऊणे, तेबे परमेशरो री तरफा ते हर एकी री तारीफ ऊणी। ");
INSERT INTO bfz_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ओ साथी विश्वासियो, मैं इना गल्ला रे तुसा खे आपणी और अपुल्लोसो री चर्चा उदारणा री रीतिया पाँदे करी राखी, ताकि तुसे आसा रे जरिए ये सीखो कि कोई बी मांणू पवित्र शास्त्रो रे लिखी री गल्ला ते आगे नि बड़ना और एक अगुवे रा पक्ष लयी की दूजे अगुवे रा अनादर करदे ऊए गर्व नि करना। ");
INSERT INTO bfz_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","कऊँकि तांदे और दूजे रे कुण भेद करोआ? और तांगे क्या ए, जो तैं दूजे ते नि पाया और जबकि तैं दूजे ते पाई राखेया, तो एड़ा कमण्ड कऊँ करेया कि मानो पाई नि राखेया? ");
INSERT INTO bfz_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","तुसे तो रजी गे, तुसे अमीर ऊई चुके, तुसे आसा ते बिना राज्य कित्तेया, पर पला ऊँदा कि तुसे राज्य करदे और आसे बी तुसा साथे राज्य करदे। ");
INSERT INTO bfz_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","मेरी समजा रे परमेशरे आसा प्रेरिता खे सबी ते बाद तिना लोका जेड़े ठराया, जिना रे मरने री आज्ञा ऊई चुकी ओ, कऊँकि आसे दुनिया और स्वर्गदूत और मांणूआ खे तमाशा ठईरी रे। ");
INSERT INTO bfz_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","लोक आसा खे मूर्ख समजोए ए कऊँकि आसे मसीह रा प्रचार करूँए। पर तुसे लोक ये समजी बैठे कि आसे अक्लमंद मसीह ए। आसे कमजोर समजे जाऊँए ए, पर तुसे आपणे आपू खे तागतबर समजोए। लोक तुसा रा आदर करोए, पर आसा रा नरादर ओआ। ");
INSERT INTO bfz_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","आसे इना दिना तक पूखे-त्याये और नांगे ए और मुक्के खाऊँए और मारे-मारे फिरूँए, ");
INSERT INTO bfz_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","और आपणे ई आथो रा काम करी की मईणत करूँए। लोक बुरा बोलोए और आसे तिना खे आशीष देऊँए। सेयो सताओए, आसे सईन करूँए। ");
INSERT INTO bfz_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","सेयो लोक आसा खे बदनाम करोए और आसे तिना ते नरमाईया साथे गल्ल करूँए। एथो तक एबे बी लोक आसा रा आदर नि करदे सेयो बोलोए कि आसा री कोई बी कीमत निए। ");
INSERT INTO bfz_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","आऊँ तुसा खे शर्मिंदा करने खे इना गल्ला खे नि लिखदा, पर आपणे प्यारे बाल़क जाणी की तुसा खे चिताऊँआ। ");
INSERT INTO bfz_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","कऊँकि मसीह रे तुसा खे सखयाणे वाल़े दस ह्जार बी ऊँदे, तेबे बी तुसा रे पिते बऊत निए, इजी री खातर कि यीशु मसीह रे सुसमाचारो रे जरिए आऊँ तुसा रा पिता ऊआ। ");
INSERT INTO bfz_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","तो आऊँ तुसा ते बिनती करूँआ कि मेरी जी चाल चलो। ");
INSERT INTO bfz_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","इजी री खातर मैं तीमुथियुसो खे, जो प्रभुए रे मेरा प्यारा और विश्वासो जोगा पाऊ ए, तुसा गे पेजी राखेया और से तुसा खे मसीह रे मेरा चाल-चलण याद कराओगा, जेड़ा कि आऊँ हर जगा, हर एकी मण्डल़िया रे इजी रे बारे रे उपदेश करूँआ। ");
INSERT INTO bfz_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","कुछ लोक ये समजी की कमण्ड करी की ईंयां फूली गे रे कि मानो आऊँ तुसा गे फेर आऊणा ई नि। ");
INSERT INTO bfz_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","पर प्रभु चाओ तो आऊँ तुसा गे चट ई आयी जाणा और तिना कमण्ड कित्ते रिया गल्ला खे नि, पर तिना रे परमेशरो री सामर्था खे बी जाणी लऊँगा कि तिना रे पितरे ये सामर्थ आये की नई। ");
INSERT INTO bfz_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","कऊँकि परमेशरो रा राज्य गल्ला रे निए, पर सामर्था रे ए। ");
INSERT INTO bfz_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","तुसे क्या चाओए? क्या आऊँ डण्डा लयी की तुसा गे आऊँ या प्यारो रे और नरमाईया री आत्मा साथे? ");
INSERT INTO bfz_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","कुछ लोके माखे बताया कि तुसा रे व्याभिचार ओआ, बल्कि एड़ा व्याभिचार जो अविश्वासिया बीचे पनि ऊँदा कि एक मांणू आपणे पिते री लाड़िया साथे व्याभिचार करोआ। ");
INSERT INTO bfz_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","इजी ते अलावा इना गल्ला री बजअ ते तुसा खे शर्मिंदा ऊई की शोग करना चाईयो था प