﻿USE sofia;
DROP TABLE IF EXISTS sofia.bfd_vpl;
CREATE TABLE bfd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bfd_vpl WRITE;
INSERT INTO bfd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Bɨ səŋ bɨ̂tà bɨ atsə bɨ Yesu Kristo, yìi mə à lɛ mfɛ̀ꞌɛ̀ a atsə David, mu Abraham aa mə: ");
INSERT INTO bfd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham à lɛ mbə ta bɨ̀ Isaac, ");
INSERT INTO bfd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda a bə ta bɨ̀ Perez bo Zerah yìi ǹdè wàà à lɛ mbə Tamar aa, ");
INSERT INTO bfd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram a bə ta bɨ̀ Amminadab, ");
INSERT INTO bfd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon a bə ta bɨ̀ Boaz, yìi mə ǹdè yì à lɛ mbə Rahab aa, ");
INSERT INTO bfd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse tɨgə̀ mbə ta bɨ̀ M̀fɔ̀ David. David, yìi mə à lɛ mbə ta bɨ̀ Solomon yìi ǹdè yì à lɛ mbə ŋgwɛ Uriah aà, ");
INSERT INTO bfd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon a bə ta bɨ̀ Rehoboam, ");
INSERT INTO bfd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a bə ta bɨ̀ Jehoshaphat, ");
INSERT INTO bfd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah a bə ta bɨ̀ Jotham, ");
INSERT INTO bfd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah a bə ta bɨ̀ Manasseh, ");
INSERT INTO bfd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah a bə ta bɨ̀ Jechoniah, yìi mə à lɛ njwe waa bɨ̀ bɔɔ bɨ maà bi fyâ noò mə bɨ lɛ nlɔ̀gə̀ baYuda ŋghɛɛ nɨ bu a alaꞌa Babylon tsǒ ɨbùꞌu ntsò aà. ");
INSERT INTO bfd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bo ghɛ̀ɛ̀ mə̂ ǹtswe a alaꞌa Babylon aa, ");
INSERT INTO bfd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel a bə ta bɨ̀ Abiud, ");
INSERT INTO bfd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor a bə ta bɨ̀ Zadok, ");
INSERT INTO bfd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud a bə ta bɨ̀ Eleazar, ");
INSERT INTO bfd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob a bə ta bɨ̀ Joseph, yìi à lɛ mbə ndoo Mary, Mary mə à lɛ njwe Yesu yìi bɨ twoŋə nɨ Kristo aà. ");
INSERT INTO bfd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma la a bə mə bɨ̀ta bɨ atsə bɨ Yesu, ǹlɔgɨnə a nu Abraham ŋkɔꞌɔ nyweꞌe a nu David, bɨ lɛ mbə nɨghûm ǹtsò nɨ̀kwà, m̀bu nlò a nu David ŋkɔꞌɔ nyweꞌe fyâ noò mə bɨ lɛ nlɔ̀gə̀ waa ŋghɛɛ nɨ bu a alaꞌa Babylon tsǒ ɨbùꞌu ntsò aa, bo kɨ̂ m̀bə nɨghûm ǹtsò nɨkwà, ŋ̀kɨ mbu nlɔ̀gɨ̀nə̀ wa noò ɨ̀bùꞌu ntsò ŋ̀kɔꞌɔ nyweꞌe a nu Kristo bo kɨ̂ m̀bə nɨghûm ǹtsò nɨ̀ kwà. ");
INSERT INTO bfd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bɨ lɛ njwe Yesu Kristo aa laà mə: Joseph à lɛ kosə Mary, ǹdè bɨ̀ Yesu nɨ̂ ŋ̀gwɛ̂ yì, lâ m̀bɔŋ tâ nòò nɨ̀yɔꞌɔ̀ yì à kuꞌu, Mary a yə mə Àzwì Nwî a bàŋnə̀ mə̂ ŋ̀ghɨrə yu tswe nɨ̀ mû! ");
INSERT INTO bfd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tsǒ mə Joseph à lɛ mbə ŋû yìi mɨ̀nnù mi mɨ tsinə aa, kaa à lɛ ŋwaꞌà kɔ̀ŋ mə yu dɨ̀rɨ̀sə̌ atu Mary a nsi bə̀. À lɛ ntɨgə nlɔɔ nɨ mânjì yìi mə yu ka ŋeꞌesə tuu Mary ghu. ");
INSERT INTO bfd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","À kà mə̂ aa kwaꞌatə nɨ̂ àtu nɨ ma yû ànnù, Angel M̀màꞌàmbi a zî ghu mbo nɨ a njə̀ə̀, ǹswoŋ mə: “Joseph, mû m̀fɔ David, tsuu lǒ bɔꞌɔ a lɔ̀gə Mary nɨ̂ ŋ̀gwɛ̂ ghò bə̂, ǹloŋ mə mu wa mə à tswe nɨ ghu aa a fâ Àzwì Nwî yìi mə a laa màŋsə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","À ka jwe mûmbâŋnə̀ tâ ò tswe ɨkûm yi nɨ Yesu ǹloŋ mə à ka yǐ yweensə bə̂ bi nɨ̂ ɨ̀bɨ̂ waa aà.” ");
INSERT INTO bfd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma yû ànnù a lɛ mfɛ̀ꞌɛ̀ tsiꞌì tsɨ̀m ma mùu ajàŋ aa, tâ ànnù yìi mə M̀màꞌàmbî à lɛ ghɨ̀rə̀ ŋ̀gàŋntoò yì a swoŋ aa, tâ à fɛꞌɛ mbòòntə̀ tsiꞌì maa ajàŋ mə: ");
INSERT INTO bfd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yə̂ nɨ̀, Mûŋgɔ̀ɔ̀ màŋgyɛ̀ à ka yǐ tswe nɨ mu, ɨ jwe mûmbâŋnə̀, tâ bɨ̀ tswe ɨkûm yi nɨ Emmanuel,” (ǹjiꞌì ɨ̀kùm ma ghû ɨ bə mə, “Nwì à tswe biꞌinə̀”). ");
INSERT INTO bfd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph à bɨ̀ɨ̀nə̀ mə̂ wa njə̀ə̀, ǹyɔꞌɔ Mary tsiꞌì wa ajàŋ mə Angel M̀màꞌàmbi wa à lɛ nswoŋ ghu mbo mə tâ à ghɨrə aà. ");
INSERT INTO bfd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lâ kaa à lɛ ŋwaꞌà nɨ ghu nɔ̂ŋ ǹyweꞌe a noò yìi mə Mary à lɛ njwe mû yì yî m̀bâŋnə̀ wa aà. À jwè mə̂ aa Joseph a tswê ɨ̀kûm yi nɨ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bɨ lɛ njwe Yesu aa a alaꞌa Bethlehem a mbùꞌù Yudea, wa noò wa yìi mə Herod à lɛ mbə Mfɔ̀ aà. Ma mùu noò, bə̀ bî mɔꞌɔ bìi mə bɨ lɛ sɨ lìì nɨ mɨ̀njɔ̀ŋ aa, bɨ lɛ nlò a mbɨ nsaꞌa nòò, ǹzi a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bo zì mə̂ aa, m̀betə mə: “Bɨ jwe mu wa mə à ka yǐ bə Mfɔ̀ baYuda aa fə aa ɛ? Bìꞌi lɛ nyə fɨ̂njɔ̀ŋ fi a ajàŋ yìi mə fɨ lɛ mfɛ̀ꞌɛ̀ a mbɨ̌ nsaꞌa nòò wa nòò yìi bɨ lɛ njwe yi aà. Bìꞌì zi aa a mmiì yi.” ");
INSERT INTO bfd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mfɔ̀ Herod à yùꞌù mə̂ laà, ǹtɔ̂ŋ yi ɨ lwî, nû yì ɨ tsɨgɨ̀nə̀, ɨ̀dɨ̀gə̀ ɨ kɨɨ̀ ǹtɨgə ntsɨgɨnə tsiꞌì tsɨ̀gɨ̀nə̀ a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","À lɛ ntwoŋ bɨlɨɨ bɨ ŋgǎŋmaaꞌanwì bɨ tsɨ̀m bo bɨ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋgsə̀ tsɨ̀m bɨ zî a betə̀ a mbo bo mə: “Bɨ lɛ ntswe nɨ̂ ǹjwe Ǹyɔꞌɔ̀ Nwì wa aa a fə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bo kwiꞌi mə, “A njɔ̀ꞌɔ̀ àlaꞌa Yerusalem a mbùꞌù Yudea. Yulà à nɨ̂ ànnù yìi mə ŋ̀gàŋtoò Nwì à lɛ ŋŋwàꞌànə̀ aà: ");
INSERT INTO bfd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wò, àlaꞌa Bethlehem, a mbùꞌu Yudea, wò, kaa ò sɨ̀ kəꞌətə̀ bə̂, a tɨtɨ̀ɨ ɨlaꞌa jì wè jìi mə ɨ tswe a mbùꞌù Yudea aà; ǹloŋ mə ǹtsyàsə̀ bə̀ à ka yǐ fɛ̀ꞌɛ̀ a tɨtɨ̀ɨ wò; ŋù yìi mə à ka yǐ kɨ tsisə nɨ̂ bə̂ bâ, baIsrael aà.’ ” ");
INSERT INTO bfd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod à yùꞌù mə̂ lâlà, ǹtwoŋ ŋgǎŋnlii mɨ̀njɔ̀ŋ jya bo bo tswê ŋ̀ŋeꞌesə ŋghaanə, a betə̀ waa bo naŋsə̀ ǹswoŋə noò wa yìi mə bo lɛ nyə fɨ̂njɔ̀ŋ fya ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","À yùꞌù mə̂, ǹtɨgə ntoo waa a wa Bethlehem ǹswoŋ mə: “Nɨ̀ ghɛɛ naŋsə nlɔɔ mu wâ; bɛɛ nɨ̀ lɔɔ nyə, nɨ̀ tɨgə̀ m̀bu mbɨ̀ɨ̀ ǹswoŋə a mbo mə̀, ta mə̀ kɨ ŋghɛɛ mmii yi.” ");
INSERT INTO bfd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bo yùꞌùtə̀ mə̂ ànnù ya mə mfɔ̀ wa à swòŋ aa, ntɨgə mfɛꞌɛ ŋghɛ̀ɛ̀ waa. Fɨ̀njɔ̀ŋ fya mə bo lɛ nyə a mbɨ̌ nsàꞌa nòò aa, fɨ tɨgə̀ ŋ̀ghɛɛ nɨ mbii bo, ŋ̀ghɛɛ ntəə wa adɨgə yìi mə bɨ lɛ njwe mu wa a tswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bo yə̀ mə̂ fɨ̂njɔ̀ŋ fya mburə ndorɨtə tsiꞌì a mbə̂ ànnù. ");
INSERT INTO bfd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bo ghɛɛ̀ ŋ̀kuu wa nda, ǹyə mu wa bo ǹdè yi Mary, ŋ̀wo ghu nsi, m̀mii yi. Bo mìì mə̂ yi, ŋ̀ŋaꞌa ɨbàâ jyaa m̀fiꞌi njoo jìi mə bo lɛ nzì a ntsàꞌàtə mu wa nɨ̀ ju aa, mfa ntəŋə yi ghu; bo lɛ mfa aa gold, nɨ frankinsense a bɔ̀ꞌɔ nɨ məə̀ ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bo fɛ̀ꞌɛ̀ mə̂ ŋ̀ka mbɨɨ waa fu mbaŋnə ntɨgə ntsya nɨ mânjì yî dàŋ ǹloŋ mə à lɛ sɨ bə aa boŋ ǹjə̀ə̀ ɨ̀ lɛ̀ mə̂ waa, Nwì a swoŋ a mbo bo mə tâ bo tsuu bǔ bɨɨ ghɛ̀ɛ̀ fu wa a mbɛ̀ɛ mfɔ̀ Herod. ");
INSERT INTO bfd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nòò yìi mə bo lɛ mmàꞌàtə̀ ŋghɛɛ waa laa, angel Mmàꞌàmbi a zî a mbo Joseph a mûm ǹjə̀ə̀ ǹswoŋ ghu mbo mə, “Wa Herod à ka kɨ lɔ̀ɔ̀ mu wa mə yu zwitə, bɨ̀ɨ̀nə nlɔ̀gə̀ yi bô ǹdè yì, ŋ̀khə ŋghɛ̀ɛ̀ nɨ ghu a alaꞌa Egipto, ǹtɨgə ntswe ghu nyweꞌe a noò yìi mə̀ ka yǐ bǔ swoŋə a mbo wò aà.” ");
INSERT INTO bfd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph à lɛ mbɨ̀ɨ̀nə̀ ǹlɔgə mu wa bô ǹdè yì tsiꞌì nɨ̀tugə, ŋghɛ̀ɛ̀ a alaꞌa Egipto, ");
INSERT INTO bfd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ǹtɨgə ntswe ghu nyweꞌe a noò yìi mə Herod à lɛ ŋkwo aà. Ma yû ànnù a lɛ mfɛ̀ꞌɛ̀ aa a nlwensə ànnù yìi mə Mmàꞌàmbî à lɛ ghɨ̀rə̀ ŋ̀gàŋntoò yì a foò ǹswoŋ aa mə, “Mə̀ lɛ ntwoŋə mû ghà a fɛꞌɛ̀ aa a alaꞌa Egipto.” ");
INSERT INTO bfd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nòò yìi mə Herod à lɛ nyə mə bə̀ bya mə bɨ lɛ nlò a mbɨ nsaꞌa nòò bɨ bweꞌesə yi aa, ǹtɔ̂ŋ ɨ lɛ nlwì tsiꞌì siꞌi siꞌi. A too bə̀ mə tâ bɨ̀ ghɛɛ nzwitə bɔɔ mbâŋnə̀ bɨtsɨ̀m a alaꞌa Bethlehem bo bɨ̀ nɨ a ɨlaꞌa jìi ɨ lɛ ntswe ghu mbɛ̀ɛ̀ aa, ǹlɔ̀gɨnə nɨ bɔɔ bìi bɨ lɛ mbə ɨlòò ji baa aa ntɨgə nsɨgə, ǹyoŋə aa wa nɨ nòò wa mə bə̀ bya lɛ nswoŋ mə fɨ̀ŋjɔ̀ŋ fya lɛ mfɛ̀ꞌɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma yû ànnù a lɛ mfɛ̀ꞌɛ̀ ǹlwensə aa annù yìi mə ŋgàŋntoò Nwì Yeremiah à lɛ nswoŋ aa mə: ");
INSERT INTO bfd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ŋù a yə̀ꞌə a Rama, nlərə nɨ̂ àkhɨɨ̀ yi, Rachel a yə̀ꞌə bɔɔ̀ bi; kaa waꞌà biì nɨ mə mbə ŋù tsɨmsə̀ yi, ǹloŋ mə bɨ kwòkə̀ mə̂ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nòò yìi Herod à lɛ ŋkwo aa, Angel M̀màꞌàmbi a zî a mbo Joseph a mûm ǹjə̀ə̀ a alaꞌa Egipto nswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bɨ̀ɨ̀nə nlɔgə mu wa bô ǹdè yì, m̀bɨɨ alaꞌa Israel, ǹloŋ mə bə̀ bya mə bɨ lɛ sɨ lɔ̀ɔ nzwitə mu wa aa bo kwòkə̀ mə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","À lɛ mbɨ̀ɨ̀nə̀ ǹlɔgə mu wa bo ǹdè yì, m̀bɨɨ a alaꞌa Israel. ");
INSERT INTO bfd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","La à bɨ̀ɨ̀ mə̂ ǹyuꞌu mə Archelaus à lɛɛ̀ ǹjɨ ndâ taà yì ǹtɨgə mfɔ̀ a alaꞌa Yudea aa, lɛ mbɔꞌɔ a ŋghɛ̀ɛ ghu. Nwì à lɛ mbu ndɨꞌɨtə yi a mûm ǹjə̀ə̀ mə tâ à ghɛɛ a mbuꞌu alaꞌa Galilea. ");
INSERT INTO bfd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","À lɛ nghɛ̀ɛ̀ ǹtɨgə ŋka ntswe aa a njɔ̀ꞌɔ̀ àlaꞌa Nazareth, tǎ lwensə annù yìi ŋgàŋntoò Nwì à lɛ nswoŋ aa, mə, “Bɨ ka yǐ kɨ twoŋə nii nɨ ŋù baNazareth.” ");
INSERT INTO bfd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","À lɛ mbə maa noò, Jɔn Ŋ̀gàŋmùrə bə̀ a ŋkì a zî a atu ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ yìi ɨ lɛ ntswe a mbuꞌu Yudea aa, ǹlɔgɨnə ŋka nswoŋə nɨ̂ ànnù Nwî ghu. ");
INSERT INTO bfd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","À lɛ sɨ swoŋə nɨ mə, “Nɨ̀ bəŋkə mɨ̂ntɨɨ̀ muu, mmaꞌatə ɨbɨ̂ ghuu nloŋ mə annù nɨfɔ̌ aburə a tɨgə a abô. ");
INSERT INTO bfd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","“Jɔn à lɛ mbə aa ŋù wa mə ŋgàŋntoò Nwì Yesaiah à lɛ nswoŋ nloŋ yi mə, ‘Ǹjì ŋù ɨ tɔŋnə nɨ a atu ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ ǹswoŋə nɨ mə, Nɨ̀ naŋsə a mânjì M̀màꞌàmbi, ǹnaŋsə ɨyaà ji tâ ɨ̀ tsinə!’ ” ");
INSERT INTO bfd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jɔn à lɛ sɨ wɛꞌɛ ɨtsə̀ꞌə̀ jìi bɨ lɛ naŋsə nɨ̂ ɨ̀nòŋ kamɛl aa, ŋkɨɨ ŋwɛꞌɛ nɨ̂ ɨ̀kô ŋ̀gùù a atìi yu; mɨ̀jɨ̂ mi mɨ lɛ mbə ŋgweenə bo nwu yì ǹtàꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bə̀ lɛ sɨ zì ghu mbɛ̀ɛ̀ ǹlo nɨ a Yerusalem, bo bɨ̌ a mbùꞌù Yudea ntsɨ̀m, bo bɨ̀ nɨ̂ ɨ̀laꞌà tsɨ̀m jìi ɨ lɛ ntswe ŋkarɨsə ŋkǐ Jordan aà. ");
INSERT INTO bfd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bo lɛ sɨ bii nɨ̂ ɨ̀fansənnû jyaa, Jɔn a tɨgə̀ m̀murə nɨ̂ waa a ŋkì Jordan. ");
INSERT INTO bfd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lâ nòò yìi mə à lɛ nyə baFarisai bî ghàꞌàtə̀ bo bɨ̀ baSadukai bɨ zî ghu mbo mə tâ à murə waa a ŋkì aa, a lɛ nswoŋ a mbo bo mə, “Bǔ bɔɔ bɨ nô! A ghuu aa a wàꞌàsə wò mə tâ nɨ̀ khə̂ àlwintɔŋə Nwî yìi mə a zì aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nɨ̀ ka ŋkoonə mɨ̂ntà mìi mə mɨ dɨ̀ꞌɨ̀ nɨ mə nɨ̀ bə̀ŋkə̀ mə̂ mɨ̂ntɨɨ̀ muu, m̀maꞌatə ɨbɨ̂ ghuu aà. ");
INSERT INTO bfd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nɨ̀ tsee kɨ mɔ̀ɔ̀ntə̀ nɨ mə mbə nɨ̀ yî ŋ̀khə njo Nwì ǹloŋ mə nɨ swoŋə nɨ mə, ‘Taà yìꞌì à nɨ aa Abraham.’ Mə̀ swòŋ a mbo bù mə mbə Nwî à zî àjàŋ mə mbə yu bəŋkə̀ ŋ̀gɔ̀ꞌɔ̀ jûlà ɨ tɨgə̀ bɔɔ bɨ Abraham! ");
INSERT INTO bfd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tsiꞌì tsɨ̀tsɔ̀ŋ wa bɨ nɔ̀ŋsə̀ mə̂ ǹjàà ǹlɔɔ nɨ̂ ŋ̀wâ ɨtì ghu tsiꞌǐ mɨ̂ŋgàŋ! Ɨ̀tǐ tsɨ̀m jìi mə kaa ɨ sɨ mɨ̂ntà mî sɨgɨ̀nə̀ koonə aa, bɨ ka wǎ mmàꞌa a mɔꞌɔ tâ ɨ̀ khɨ. ");
INSERT INTO bfd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mə murə ghuu aa a ŋkì a ndɨ̀ꞌɨ mə nɨ̀ bə̀ŋkə̀ mə̂ mɨ̂ntɨɨ̀ muu, lâ ŋù yì mɔ̀ꞌɔ a yòŋə a njɨ̌m mə̀, yìi mə à kɔ̀ꞌɔ̀nə ntsyàtə̀ ghâ, kaa mə̀ waꞌà kùꞌùnə̀ tsiꞌǐ tugɨtə̂ ɨ̀baakòrə̀ ji. À nɨ yu wa yìi à ka yǐ kɨ murə ghuu a mûm Àzwì yî Làà nɨ a mum mɔꞌɔ aà. ");
INSERT INTO bfd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Àyoo nsəgə mɨ̀sàŋ a tswe ghu abo, à ka səgə mɨ̂sàŋ mya ɨ tii ntsàꞌa tsɨ̀m fiꞌisə ɨ tɨgə ghotə mɨsàŋ mya a mûm àta yu, ɨ bàŋnə tɔɔ ntsàꞌà jya a nɨ mɔꞌɔ yìi mə ɨ khɨ kaa waꞌà m̀mɛ̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu à lɛ ntɨgə nlo a Galilea nzi a mbɛ̀ɛ Jɔn a ŋkǐ Jordan mə tâ à murə yi a ŋkì. ");
INSERT INTO bfd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jɔn à lɛ ŋka nlɔɔ ntuù, ǹswoŋə nɨ mə, “A kuꞌunə mə boŋ a mùrə wò m̀murə gha a ŋkì, ò bâŋnə̀ m̀bu nzì bə a mbo mə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu a kwiꞌi ghu mbo mə, “Màꞌàtə tâ à bə laà tsɨtsɔ̀ŋə̀; ǹloŋ mə àâ àjàŋ yìi mə a kuꞌunə mə tâ bɨ̀ ghɨrə tâ ɨ̀nnù tsɨ̀m ɨ̀ tsinə aà.” Jɔn à lɛ ntɨgə mbii mmurə yi a ŋkì. ");
INSERT INTO bfd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nòò yìi bɨ lɛ mmurə Yesu a ŋkì aa, à lɛ ŋghɛ̀sə̀ m̀fɛꞌɛ wa mûm ŋ̀kì ŋ̀kɔꞌɔ ntəə a ntaꞌà. Àbùrə̀ a lɛ ŋŋaꞌanə a yə Azwì Nwî a sɨgə, mbə tsǒ bugɨrəmɨ̀kuu ntəə ghu atû. ");
INSERT INTO bfd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ǹjì Nwì ɨ tɨgə̀ ŋ̀ghaa nlo a aburə nswoŋ mə, “Àa mû ghà yî m̀bâŋnə̀ yìi mə mə̀ kɔ̀ŋə aa à ghulà, mə naŋsə ndorɨtə nloŋə yì.” ");
INSERT INTO bfd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma yaa ànnù a ghə̀ mə kɨ tsyà, Àzwi Nwì a tsyâsə̀ Yesu a atu ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ mə tâ Devil à kwaꞌanə yi ghu. ");
INSERT INTO bfd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","À lɛ ntswe ghu mɨtugə mɨ njwi mɨ̀ghum mi nɨkwà, a siꞌinə bo bɨ̀ a tɨ̀tugə, ǹtuu njɨ̂, ǹjì ɨ yaŋə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ŋ̀gàŋkwàꞌànə bə̀ wa a zî ghu mbo nswoŋ mə, “M̀bə ò bə Mu Nwì, ò swoŋ a mbô ŋ̀gɔ̀ꞌɔ̀ jû mə tâ ɨ̀ bəŋkə ntɨgə abaà.” ");
INSERT INTO bfd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu a kwiꞌi mə, “Bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ Nwì mə, ‘Kaa ŋù à sɨ ntɨ̀ɨ̀ tswe nloŋ aa tsiꞌì àbaa yu yu bə̂, a kɨɨ nlɔɔ mɨghàà mɨ tsɨ̀m mìi mɨ fɛ̀ꞌɛ a ntsu Nwì aà.’” ");
INSERT INTO bfd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Devil a bû ǹlɔgə Yesu ŋghɛɛ nɨ ghu wa njɔ̀ꞌɔ̀ àlaꞌa yì ǹlàà maŋsə, ǹtɛꞌɛ yi wa atu nɨdòò nɨ ndâmàꞌanwì, ");
INSERT INTO bfd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ǹswoŋ ghu mbo mə, “M̀bə ò bə Mu Nwì, ò tsɔꞌɔnə̀ ǹlo fàa atu nda nnàŋə a nsyɛ̂; ǹloŋ mə bɨ ŋwaꞌanə mûm àŋwàꞌànə Nwì mə, ‘Nwì à ka swoŋ annù a mbo baangel bi nloŋə ghô.’ M̀bu nswoŋ mə, ‘Bo ka tɨgə ŋɛɛ gho ɨ tugɨtə a mbo bo a ndəŋ mbɨ̀ꞌɨ̀ ò tumə̀ àkòrə̂ yo a nɨ̂ ŋ̀gɔ̀ꞌɔ̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu a kwiꞌi mə, “Bɨ bû ŋ̀wàꞌànə̀ a mûm àŋwàꞌànə Nwì mə, ‘Tsùu Mmàꞌàmbî Nwìŋgɔ̂ŋ ghǒ kwàꞌànə̀.’” ");
INSERT INTO bfd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Devil a kuꞌùsə̀ m̀bu nlɔ̀gə̀ Yesu ŋkɔꞌɔ ŋghɛɛ nɨ ghu a atu ntaꞌa yìi a lɛ ŋkɔꞌɔ njɔŋnə aa, ǹdɨꞌɨ ɨtoò tsɨ̀m jìi mə bɨ̀fɔ̀ bɨ mbi bù saꞌa aa bo bɨ̀ nɨ̀ghaꞌà nyaa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ǹswoŋ ghu mbo mə, “Mə̀ ka fa ŋgɔ̀ŋ ǹjoo ma jû tsɨ̀m a mbo wò mə mbə ò wo a nsyɛ mmii ghâ.” ");
INSERT INTO bfd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu a kwiꞌi ghu mbo mə, “Lǒ ŋghɛ̀ɛ̂, Satan! Bɨ ŋwaꞌanə a mûm àŋwàꞌànə Nwî mə, ‘Ka mii tsiꞌì M̀màꞌàmbi Nwìŋgɔ̀ŋ ghò, ŋ̀kɨɨ ŋka mfaꞌa tsiꞌì ghu mbo yuyu.’ ” ");
INSERT INTO bfd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Devil à lɛ ntɨgə mmaꞌatə Yesu, baangel bɨ zî m̀faꞌa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu à yùꞌù mə mə bɨ nɨŋə Jɔn Ŋgàŋmùrə bə̀ a ŋkì a atsaŋ, ǹtɨgə nlo ŋghɛ̀ɛ̀ a Galilea. ");
INSERT INTO bfd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","À ghɛ̀ɛ̀ mə̂ ghuu aa, mmaꞌatə Nazareth ŋ̀ghɛɛ ntɨgə ntswe a Kapernaum, a mbɛ̀ɛ̀ àtsumə Galilea, a mbùꞌu Zebulem bo Naphtali. ");
INSERT INTO bfd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A lɛ mfɛ̀ꞌɛ̀ laa a nlwensə annù yìi mə ŋ̀gàŋntoò Nwì Yesaiah à lɛ nswoŋ aa mə, ");
INSERT INTO bfd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Àlaꞌa Zebulum nɨ alaꞌa Naphtali, jìi mə ɨ tswe a mbɛ̀ɛ ŋkì mɨyaa, a njii ŋkì Jordan, Galilea, wò àlaꞌa bɨ̂tɨ̀zi Nwî! ");
INSERT INTO bfd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bə̀ bìi mə bɨ lɛ sɨ tswe a mûm m̀fiì ɨ̀dɨ̀gə̀ aa bɨ yə̀ mə ŋkàꞌà yî wè, bə̀ bìi mə bɨ lɛ sɨ tswe a alaꞌa yìi mə àlɨləŋə nɨwo a lɛ ntswe ghu aa, ŋkàꞌà ɨ tà mə a nu bo.” ");
INSERT INTO bfd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ǹlɔgɨnə maa noò Yesu a lɔgɨ̀nə̀ ŋ̀ka nswoŋə nɨ̂ ànnù Nwî ǹswoŋə nɨ mə, “Nɨ̀ bəŋkə mɨ̂ntɨɨ̀ muu, mmaꞌatə ɨbɨ̂ ghuu, ǹloŋ mə annù nɨfɔ̌ aburə a tɨgə a abô.” ");
INSERT INTO bfd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu à kà mə̂ aa ntəə nzi a aghəŋə ŋkì mɨyaa Galilea nyə ŋgǎŋkômbwɛ̀ ji baa, a bə Simon yìi bɨ lɛ sɨ twoŋə nɨ Peta aa, bo mumaà yì Andrew, bɨ tswê wa mûm ŋ̀kì ǹlə nɨ̂ m̀bwɛ̀ nɨ̂ àmbunjya. ");
INSERT INTO bfd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu a swoŋ a mbo bo mə, “Nɨ̀ zi ŋka nyoŋə nàâ, mə̀ ka ghɨ̀rə tâ nɨ̀ tɨgə mbə ŋgǎŋko bə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bo kɨ̂ ŋ̀ghɛnsə mmàꞌàtə mbunjyâ jyaa jya ǹyoŋə yi. ");
INSERT INTO bfd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bo bo kà mə̂ aa ŋghɛntə a bû ǹyə bɔɔ bɨ ma bî mɔꞌɔ bi baa, a bə Jɛms bo Jɔn, bɔɔ bɨ Zebedee. Bo bɨ̀ taà wàà Zebedee lɛ ntswe a mûm àkànuꞌu ŋkɛɛ nɨ̂ m̀bunjyâ jyaa. Yesu a twoŋə̀ waa. ");
INSERT INTO bfd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bo kɨ̂ ŋ̀ghɛsə mmàꞌàtə akànuꞌù yaa ya bo bɨ̀ taà wàà ǹyoŋə yi. ");
INSERT INTO bfd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu à lɛ ntɨgə ŋkarə nɨ alaꞌa Galilea tsɨ̀m ǹdɨꞌɨ nɨ̂ ɨ̀nnù a ndâghòtə baYuda, ŋ̀kɨɨ nswoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya nloŋə annù nɨfɔ̌ aburə. Ŋ̀ghurə nɨ mɨ̀ghɔ̀ɔ̀ mɨ tsɨ̀m bo bɨ̀ ɨ̀lɔ̀ꞌɔ tsɨ̀m jìi ɨ lɛ ntswe a nu bə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ànnù ǹloŋ ŋgaà yì a lɛ ntɨgə nsɛɛnə a mûm àlaꞌa Syria tsɨ̀mə̀. Bə̀ tɨgə̀ ǹlɔgə nɨ̂ ŋ̀gàŋmɨghɔ̀ɔ̀ jyaa tsɨ̀m, tsiꞌì bə̀ bìi bɨ lɛ sɨ ghɔ̀ɔ̀ nɨ mɨ̀ghɔ̀ɔ̀ a mbuu mbuu, bo bə̀ bìi mə bɨ lɛ sɨ yuꞌu nyaŋə a mbuu mbuu aa, bə̀ bìi mə bɨ̀ demon lɛ ntswe a nu bo aa, ŋ̀gǎŋwo abùbùrə̀, bo bɨ̀ bɨ̀bwɛ̀nkə̀ ǹzi nɨ bo, a kɨɨ̀ ŋ̀ghurə waa. ");
INSERT INTO bfd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mɨ̀nnɔ̀ɔ̀ mî ghàꞌàtə̀ lɛ ntɨgə nlo a mbùꞌu Galilea bo bɨ̀ nɨ a Decapolis, ǹlo a Yerusalem, nɨ a Yudea, nɨ a njii ŋkǐ Jordan ǹyoŋə nìi. ");
INSERT INTO bfd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu à yə̀ mə nnɔ̀ɔ̀ bə̂ wa ntɨgə ŋkɔꞌɔ ŋghɛɛ a atu ntaꞌa, ntswe a nsyɛ, ŋgǎŋyəgə̂nnù ji ɨ yôŋ ǹtswe ghu mbɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A lɔgɨ̀nə̀ ŋ̀ka ndɨꞌɨ waa mə: ");
INSERT INTO bfd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“M̀bɔɔnə a mbo bə̀ bìi mə bo fumə a mûm Àzwì aà, ǹloŋ mə ànnù nɨfɔ̌ aburə à nɨ̂ à yaa. ");
INSERT INTO bfd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“M̀bɔɔnə a mbo bə̀ bìi mə mɨ̀ntɨɨ̀ myaa luu nɨ̂ àjəŋnə̀ aà, ǹloŋ mə bɨ ka tɨgə bɔrɨsə mɨ̂ntɨɨ̀ myaa. ");
INSERT INTO bfd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Mbɔɔnə a mbo bə̀ bìi mə bɨ bɔnə aà, ǹloŋ mə bo ka yǐ jɨ mbi yù aà. ");
INSERT INTO bfd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“M̀bɔɔnə a mbo bə̀ bìi mə njì ɨ yaŋə nɨ̂ waa, mɨ̀ntɨɨ̀ myaa kɨɨ̀ ǹloo nloŋ ɨnnù jìi ɨ tsinə aà, ǹloŋ mə bo ka yǐ ywurə. ");
INSERT INTO bfd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“M̀bɔɔnə a mbo bə̀ bìi mə bɨ ko mɨlɨ̀ŋnə̀ bə̀ bi mɔꞌɔ aà, ǹloŋ mə bɨ ka yǐ kɨɨ ko mɨlə̀ŋnə̀ wàà. ");
INSERT INTO bfd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“M̀bɔɔnə a mbo bə̀ bìi mə mɨ̀ntɨɨ̀ myaa mɨ laa aà, ǹloŋ mə bo ka yǐ yə Nwî. ");
INSERT INTO bfd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“M̀bɔɔnə a mbo bə̀ bìi mə bɨ fàꞌà a ŋghɨ̀rə mə tâ m̀bɔɔnə tswe a tɨtɨ̀ɨ bə̀ aà, ǹloŋ mə baa yǐ tɨgə twoŋə waa nɨ bɔɔ bɨ Nwî. ");
INSERT INTO bfd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“M̀bɔɔnə a mbo bə̀ bìi mə bɨ tsɔꞌɔ akòrə̂ yaa ǹloŋ mə bo ghɨ̀rə annù yìi a tsinə aà, ànnù nɨfɔ̌ aburə a nɨ̂ à yaa. ");
INSERT INTO bfd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“M̀bɔɔnə a mbo bù mə mbə bə̀ ka mbəgɨtə nɨ̂ ghuu, ǹtsɔꞌɔ nɨ̂ àkòrə̂ yuu, ŋkɨɨ nswoŋə nɨ̂ m̀buu ɨnnù jì bɨ̂ tsɨ̀m, tsiꞌì àdàŋə̀ dàŋə̀, a atu bù ǹloŋ ŋgaa yà aà. ");
INSERT INTO bfd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nɨ̀ ka ndorɨtə ŋkɨɨ ŋwyɛ nsəgɨtə nloŋ mə mɨ̀tsɔꞌɔnə̀ mɨ afàꞌà mìi mɨ ghaꞌa aa mɨ tswe a mbo bù a aburə aà. Ǹloŋ mə à kɨ mbə ajàŋ yìi bɨ lɛ sɨ tsɔꞌɔ akorə ŋgǎŋntoo Nwî jìi ɨ lɛ ntswe a mbii bù aà. ");
INSERT INTO bfd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nɨ̀ laa mbə fɨ̂ŋgwaŋ a mbô m̀bî. Lâ m̀bə fɨ̀ŋgwaŋ fɨ tuu nìi bǔ kɨ lìì boŋ bɨ ka tɨgə bǔ ghɨ̀rə aa mə akə tâ fɨ̀ bǔ ka nlii aa ɛ? Kaa fɨ sɨ̀ nɨ̂ àfàꞌà bǔ ntswe, ntɨgə mbə aa mə tâ bɨ̀ meꞌe tâ bə̀ tɨgə ntəəntə ghu nɨ mɨ̀kòrə̀. ");
INSERT INTO bfd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nɨ̀ laa mbə ŋkàꞌa mbi ghù. Kaa mbə bɨ waꞌǎ njɔ̀ꞌɔ̀ àlaꞌa yìi ɨ̀ təə a atu ntaꞌa aa lɔ̀ꞌɔ̀sə̀. ");
INSERT INTO bfd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kaa bə̀ sɨ lâm kosə nnɨŋə nɨ a mûm àntɔ̀ɔ̀ ŋ̀kusə, bɨ bàŋnə̀ ǹtɛꞌɛ aa bə a atu atɛtɛ̀, ŋ̀kàꞌâ yi wa ɨ tɨgə̀ ǹta ŋkeꞌetə nɨ bə̀ bɨ̀tsɨ̀m a mûm ǹdâ. ");
INSERT INTO bfd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma mùu ajàŋ, nɨ̀ ghɨrə tâ ŋ̀kàꞌâ ghuu ka nta a nsi miꞌi bə̀, tâ bo ka nyə ɨnnù jî sɨgɨ̀nə̀ jìi nɨ ghɨ̀rə̀ aa ta tɨgə ghaꞌasə Taà ghùù yìi à tswe a aburə aà. ");
INSERT INTO bfd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nɨ̀ tsee waꞌatə mə mə̀ zì aa a mbwɛsə nɔ̀ŋsə̀ yìi à tswe a mûm ŋ̀ŋwàꞌànə̀ Moses kə̀ ànnù yìi a tswe a mûm àŋwàꞌànə ŋgǎŋntoo Nwî aà. Kaa mə̀ sɨ̀ zì aa a mbwɛsə nɔ̀ŋsə̀, mə̀ zì aa bə a nlwensə̂. ");
INSERT INTO bfd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mə̀ swoŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə kaa nɨ̀liꞌi nɨ̂ àŋwàꞌànə̀ nî fùùrə̀ kə̀ àntsɔ̀ꞌɔ̀nə̀ yî fùùrə̀ kaa ka yì waꞌà bwɛ wa nɨ̂ àŋwàꞌànə̀ nɔ̂ŋsə̀ ǹyweꞌe a noò yìi mə abùrə̀ bo ǹsyɛ ka yǐ tsyà aà; bɨ ka yǐ ghɨ̀rə ɨnnù jìi ɨ tswe ghu aa tsiꞌì tsɨ̀m yaꞌa. ");
INSERT INTO bfd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ŋù tsù yìi mə a wò tsiꞌì ǹdɨꞌɨ yì kə̀gə yî mɔ̀ꞌɔ a nɨ̂ ǹdɨꞌɨ ma jû, ŋ̀kɨɨ ntɨgə ndɨꞌɨ nɨ a mbo bə̀ bî mɔꞌɔ mə bɨ̀ ka ŋghɨrə mala aa, bɨ ka yǐ twoŋə yi nɨ ŋù yî kə̀ꞌə̀tə nsɨgə nlwiꞌi a mûm ànnù nɨfɔ̌ aburə. Lâ ŋù yìi mə a lə̀ə ndɨꞌɨ mà jû ŋ̀kɨɨ mmɨrɨsə nɨ bə̀ bî mɔꞌɔ mə bɨ̀ kɨɨ ŋka nləə aa, bɨ ka yǐ twoŋə yi nɨ ŋù yì ŋ̀wè a mûm ànnù nɨfɔ̌ aburə. ");
INSERT INTO bfd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Mə̀ swoŋ a mbo bù mə, mbə ɨnnǔ juu tsuu tsinə ɨ tsyatə ji ŋgǎŋndɨꞌɨ nɔ̀ŋsə̀ bo bɨ̀ ji baFarɨsai, bəə boŋ kaa nɨ̀ ka yǐ waꞌǎ a mum annù nɨfɔ̌ aburə kuù. ");
INSERT INTO bfd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nɨ̀ yuꞌu mə bɨ lɛ sɨ swoŋə a mbo bə̀ a mbìì mə, ‘Tsee ŋû zwitə; ŋù yìi mə à ghɨ̀rə ma la aa bɨ ka lɔ̀gə̀ yi ghɛ̀ɛ̀ nɨ ghu a ndântsɔ̀ꞌɔ̀tə mɨ̀saꞌà.’ ");
INSERT INTO bfd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lâ, mə̀ swòŋə a mbo bù mə, ‘Ŋù yìi mə à lwìsə ntɔŋ a nû ǹdɨ̂m yì aa, a bɔŋ mə bɨ̀ nɨŋ ɨsaꞌa ghu nû.’ Ŋù yìi mə à twòŋə ndɨ̂m yì nɨ̂ àtɨ̀rə̀ aa, a bɔŋ mə bɨ̀ lɔgə ŋghɛ̀ɛ̀ nɨ ghu a nsi ŋgǎŋnsaꞌa mɨ̀saꞌà. Ŋù yìi mə twòŋə ndɨ̂m yì nɨ̂ àjɨ̀ŋtə ayoo dàŋə̀ dàŋə̀ aa, a kuꞌunə mə tâ bɨ̀ maꞌa yi a mum mɔꞌɔ tɨ mɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“M̀bə ò yǐ nzì nɨ̂ ǹjoo mmàꞌanwì jo a nsi nɨ̀kèntə̀ nɨ mɔꞌɔ nɨ mmàꞌa Nwì, ŋ̀waꞌatə mə ò fànsə annù a mbo ǹdɨm ghò, ");
INSERT INTO bfd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ò maꞌàtə̀ ǹjoo mmàꞌanwì jya wa mbɛ̀ɛ nɨ̀kèntə̀ nɨ mɔꞌɔ, mfoo ŋghɛ̀ɛ̀ bǔ ndɨm ghò wa mâŋsə̀ ànnù ya, mbɔŋ tâ ò zi mfa njoo mmàꞌanwì jo jyâ. ");
INSERT INTO bfd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“M̀bə ŋù yìi à nɨ̌ŋ ɨsaꞌa a nu wò a lɔgə gho ŋka ŋghɛɛ nɨ wò a kɔrə̀, ò swoŋ bu yu mâŋsə̀ ɨ̀saꞌa wa a mânjì m̀bɔŋ ghɛ̀ɛ kuu wâ kɔrə̀; ǹloŋ mə bu yu bə ghɛ̀ɛ kuu ghu, boŋ à ka ghɛ̀ɛ fa gho a mbo ŋ̀gàŋnsaꞌa mɨ̀saꞌa tâ à tɨgə mfa gho a mbô ŋ̀gàŋmbɛ̂ àtsàŋə̀ tâ à ghɛɛ nnɨŋə gho a atsaŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mə̀ swǒŋ tsiꞌì ànnù nɨ̂koŋ a mbo wò mə ò bə kuu wa atsaŋ boŋ ò ka tɨgə tswe ghu ɨ yweꞌe a noò yìi ò ka yǐ màŋsə tu ŋkabə yìi mə o tswa nii ghu aa tsiꞌì ǹtsɨ̀m, ɨ sɨgə yweꞌe nɨ̂ ànini yìi a lwiꞌi aà.” ");
INSERT INTO bfd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nɨ̀ lɛ nyuꞌu bɨ swoŋ a mbìì mə, ‘Tsee annǔ mâghàbə ghɨ̀rə̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lâ mə̀ swǒŋ a mbo bù mə, ŋù yìi mə à lèntə mâŋgyɛ̀ ǹyəꞌətə yi aa, à ghɨ̀rə̀ mə annǔ mâghàbə̀ bo yu a mûm ǹtɨɨ yu. ");
INSERT INTO bfd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Maa ajàŋ m̀bə nɨ̀liꞌì no nì màꞌà nɨ ghɨ̀rə mə tâ ò wo a mûm ɨnnù jî bɨ, ò tweꞌè m̀meꞌe! A bɔŋ mə tâ ò bwɛ adɨgə nû yo yǐ mɔꞌɔ ntsyatə mə tâ bɨ̀ yi mmàꞌa ɨbɨɨnû gho tsɨ̀m a mum mɔꞌɔ Satan. ");
INSERT INTO bfd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","M̀bə abô yo yì màꞌà a ghɨrə mə tâ ò wo a mûm ɨ̀nnù jî bɨ, ò kwyɛ̂ m̀meꞌe! A bɔŋ mə tâ ò bwɛ nɨkwɛɛ̀ no nǐ mɔꞌɔ ntsyatə mə tâ bɨ̀ yi mmàꞌa ɨbɨɨ nû gho tsɨ̀m a mum mɔꞌɔ Satan. ");
INSERT INTO bfd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bɨ lɛ swoŋ mə, ‘Ŋù yìi à fìꞌi ŋgwɛ̂ yì a nda yu aa, tâ à yə mə yu fa àŋwàꞌànə̌ nsàꞌànə nɨ̀yɔꞌɔ ghu mbô.’ ");
INSERT INTO bfd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lâ, mə̀ swǒŋ a mbo bù mə, m̀bə ŋù a fiꞌi ŋgwɛ̂ yì a nda yu, ntsuu nloŋ aa annǔ atsùùrə bə, bəə boŋ à ghɨ̀rə̀ aa mə tâ à tɨgə màŋgyâ àjɨrə̀; ŋùmbâŋnə̀ yìi à yɔ̀ꞌɔ yi aa, a ghɨrə̀ aa annǔ mâghàbə̀ bo màŋgyɛ̀ ma wâ. ");
INSERT INTO bfd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nɨ̀ yuꞌu mə bɨ lɛ sɨ swoŋə a mbìì mə, ‘Nɨ̀ tsuu kɨ kàà annù a mbweꞌesə bə̀, lâ m̀bə ò tɛꞌɛ ŋkaa a mbo M̀màꞌàmbi mə ò ka ghɨrə annù, ò ghɨ̀rə̀ ànnù ma yâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","La mə̀ swǒŋ a mbo bù mə, nɨ̀ tɛꞌɛ tsuu burə kɨ kaa kàà. Nɨ̀ yi tɨ kàꞌa annù nɨ̀ tsuu kɨ kàà. Nɨ tsee nɨ̂ àbùrə̀ kàà, ǹloŋ mə àa adɨ̀gə̀ yìi mə àbə̀rə̀ Nwî a tswe ghu aà; ");
INSERT INTO bfd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kə̌ a nsyɛ, nloŋ mə àa adɨ̀gə yìi mə Nwǐ a tɛtə mɨkòrə̂ mi ghu aà; kě nɨ̂ Yerusalem, ǹloŋ mə àa ǹjɔ̀ꞌɔ̀ àlaꞌà M̀fɔ̀ yî ŋ̀wè aà. ");
INSERT INTO bfd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nɨ̀ tsee kɨ kàà nɨ̂ àtû yuu, nloŋ mə kaa mbə nɨ̀ waꞌǎ ɨnùŋ yî m̀fùꞌù kə̀ yî m̀fìì ghɨrə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tâ ànnù yìi mə nɨ̀ ka kɨ swoŋə aa tâ bə tsiꞌì ‘ɨ̀ɨ̀ŋə’ kə̀ ‘ŋ̀gaŋ’; ànnù yi dàŋ yìi nɨ̌ bù ǹswoŋə aa a tɨgə nlo aa a mbo ŋù yì mbɨ wâ. ");
INSERT INTO bfd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nɨ̀ lɛ nyuꞌu mə bɨ lɛ nswoŋ mə, ‘Nɨ̀liꞌi a atu nɨ̀liꞌì, bo bɨ̀ nɨ̀sɔ̀ŋə̀ a atu nɨ̀sɔ̀ŋə̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","La mə̀ swòŋə a mbo bù mə, tsuu ɨbɨ yìi ŋù yì mbɨ a ghɨrə a nu bù kɨ tuu. Lâ m̀bə ŋù a fɛɛ nɨghaꞌà no ni abô màꞌà, ò bəŋkə̀ nî mɔꞌɔ mfa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","M̀bə ŋù a lɔɔ gho nɨ̀ ɨ̀saꞌa ŋka nlɔɔ mə yu kwɛrə atsə̀ꞌə̂ yo yì màꞌà, ò kɨ̂ m̀fa akutə̀ yo ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","M̀bə ŋù a gaansə gho mə tâ ò kwɛtə yi tâ bu yu ghɛɛ malə̀ yî m̀fùùrə̀, ò bii bu yu bâŋnə̀ ŋ̀ghɛɛ bi baà. ");
INSERT INTO bfd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","M̀bə ŋù a yi nlɔɔ ayoo a mbo wò, ò fâ, ǹtsee tuu a ntsɔꞌɔsə ŋù nɨ̂ àyoò. ");
INSERT INTO bfd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nɨ̀ lɛ nyuꞌu bɨ swoŋ mə, ‘Ka kɔ̀ŋə̀ a ndɨ̂m ghò, ŋ̀ka mbaa ŋgàŋkɨ̀bàâ ghò.’ ");
INSERT INTO bfd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","La mə̀ swòŋə a mbo bù mə, nɨ̀ ka ŋkɔŋ ŋgàŋkɨbàâ juu, ŋ̀ka ntsaꞌatə nɨ̂ Nwî a atu bə̀ bìi bɨ tsɔꞌɔ akòrə̂ yuu aa, ");
INSERT INTO bfd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tǎ tɨgə bə bɔɔ bɨ Taà ghùù yìi à tswe a aburə aà; ǹloŋ mə a ghɨ̀rə nɨ̀nòò yì a tâ nɨ a atu bə̀ bî bɨ bo bɨ̀ bì sɨgɨ̀nə̀, ŋ̀ghɨrə m̀bə̀ŋ ɨ loò nɨ̀ bə̀ bìi annû yaa a tsinə aa bo bɨ̀ bìi annû yaa sɨ̀ tsinə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","M̀bə nɨ̀ ka ŋkɔŋ aa tsiꞌì bə̀ bìi bɨ kɔ̀ŋə̀ ghuu aa, boŋ mbə Nwì a bû ǹtsɔꞌɔ ɨfàꞌà ghuu aa a ya aa ɛ? Tsiꞌì ŋ̀gǎŋkwɛrə bɨ̀tax, bɨ sɨ ma mùu ajàŋ ghɨrə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“M̀bə nɨ̀ ka ntwoŋtə aa tsiꞌǐ bɔɔ bɨ maà buu, boŋ kwensə nɨ̂ ànnù yìi nɨ ghɨ̀rə̀ aa à nɨ̂ àkə̀ aa ɛ? Tsiꞌì bɨ̀tɨzi Nwî, bɨ sɨ maa ajàŋ kɨɨ ŋghɨrə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Nɨ̀ ghɨrə tâ ɨ̀nnù juu ɨ̀ bɔŋ màŋsə̀ tsiꞌì àjàŋ mə Taà ghuu a aburə à bɔ̌ŋ màŋsə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nɨ̀ ka ntsyɛsə ghuu ntsuu ɨnnù jìi mə ɨ tsinə aa a nsi miꞌi bə̀ kɨ ghɨ̀rə̀ bə mə tâ bɨ̀ ka nyə ghuu. Ǹloŋ mə nɨ̀ bə kɨ ghɨ̀rə̀ maa ajàŋ boŋ kaa nɨ̀ ka waꞌǎ mɨtsɔꞌɔnə̀ mɨ ɨfàꞌà a mbo Taà ghùu yìi à tswe a aburə aa kwɛrə̀. ");
INSERT INTO bfd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Maa ajàŋ, nɨ̀ yi tɨ fa ayoo a mbo ŋ̀gàŋə̂fumə nɨ̀ tsuu ntàŋ kɨ tɔŋə, tsiꞌì tsǒ ajàŋ mə ŋgǎŋabagɨlə ɨ ghɨ̀rə a ndaŋghotə bo bɨ̀ a nɨ mɨ̂mfâŋnə̀ mə tâ bɨ̀ ka ŋghaꞌasə waa aà. Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋ mə bo kwɛ̀rə̀ mə̂ mɨtsɔꞌɔnə̀ mɨ ɨfàꞌâ myaa mɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lâ nɨ̀ yi mbàŋnə̀ tɨ fa ayoo a mbo ŋ̀gàŋə̂fumə, nɨ̀ tsuu ghɨ̀rə mə tâ àbô yuu yî ŋ̀kwàbə̀ à zi ayoo yìi mə àbo yì màꞌà a tugɨtə aà. ");
INSERT INTO bfd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tǎ tâ ǹjoo jya mə nɨ fa aa tâ ɨ̀ tswe a alɔ̀ꞌɔ̀sə̀, boŋ Taà ghùu yìi mə a yə ɨdɨgə a alɔ̀ꞌɔ̀sə̀ aa, à ka tsɔꞌɔ ɨfàꞌâ ghuu. ");
INSERT INTO bfd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nɨ̀ yi tɨ tsàꞌàtə̀ Nwî, nɨ̀ tsuu bə tsiꞌì tsǒ ŋgǎŋabagɨlə̀ mə bo kɔ̀ŋə mə bo kɨ bɨɨnə təə nɨ a ndaŋghotə kə̌ a mbɛ̀ɛ̀ mɨ̂mfâŋnə̀ mə bə̀ ka nyə waa aà. Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋ mə bo kwɛ̀rə̀ mə̂ mɨtəŋnə̂ myaa. ");
INSERT INTO bfd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lâ nɨ̀ yi mbàŋnə̀ tɨ tsàꞌàtə̀ Nwî, nɨ̀ kuu ŋghɛ̀ɛ̀ a mûm ǹjaꞌà ǹda bù, ǹtsetə abàꞌà, m̀buꞌu mbo a mbo Taà ghùù yìi à tswe alɔ̀ꞌɔ̀sə̀ aa, boŋ Taà ghùù yìi a yə ɨdɨgə a alɔ̀ꞌɔ̀sə̀ aa, à ka tsɔꞌɔ ɨfàꞌâ ghuu. ");
INSERT INTO bfd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nɨ̀ yi tɨ tsàꞌàtə̀ Nwî, nɨ̀ tsuu buꞌusə̀ kɨ ghàà mɨ̀ghàà bə̂ àdàŋə̀ dàŋə̀ tsiꞌì tsǒ ajàŋ yìi mə bɨ̀tɨ̀zî Nwî bɨ ghɨ̀rə̀ aà. Ǹloŋ mə bo waꞌatə nɨ mə Nwɨ̀ŋgɔ̀ŋ à ka yuꞌu nɨyə̀ꞌə̂ nyaa ɨ yòŋə̀ aa mɨghàâ mya mî ghàꞌà ŋ̀ghaꞌa. ");
INSERT INTO bfd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nɨ̀ tsuu tsǒ bo bə, ǹloŋ mə Taà ghùù à zi njoo jya jìi mə nɨ boŋə aa mbɔŋ tâ nɨ̀ ka mbetə. ");
INSERT INTO bfd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nɨ̀ tɨgə ŋka ntsaꞌatə Nwì aa laà mə: Taà yiꞌi a aburə, ghɨ̀rə̂ tâ bɨ̀ ka ŋghaꞌasə Ɨkûm ghô. ");
INSERT INTO bfd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tâ ànnù nɨfɔ̂ yo â zi, Ta bǎnsyɛ aa nyuꞌu ndɨꞌɨ̀ jo tsǒ bǎburə. ");
INSERT INTO bfd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fa mɨjɨ mìi mə mɨ kuꞌunə a mbo bìꞌì sii aà. ");
INSERT INTO bfd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lìꞌìnə ɨfansənnù jiꞌi a ajàŋ mə bìꞌi kɨɨ nliꞌinə nɨ̂ jì bə̂ bìi bɨ fànsə̀ a nu bìꞌì aà. ");
INSERT INTO bfd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ǹtsuu bii bìꞌì kwo a ŋkɨ̀rə̀ Satan bə̀. Lâ yweensə yiꞌi nɨ̂ ɨ̀nnù jì bɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ǹloŋ mə nɨ̀ bə kɨ lìꞌìnə ɨfansənnù bə̂, bəə boŋ Taà ghùù yìi à tswe a aburə aa à ka kɨɨ lìꞌìnə̂ juu. ");
INSERT INTO bfd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lâ m̀bə nɨ̀ tsuu ɨfansənnù bə̂ kɨ lìꞌìnə bəə boŋ kaa Taà ghùù kaa à ka waꞌà juu ka nliꞌinə. ");
INSERT INTO bfd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nɨ̀ yi tɨ siꞌisə ɨbɨɨnû ghuu tɨ jɨ, nɨ̀ tsuu kɨ jəŋnə tsiꞌǐ tsǒ ŋgǎŋəbagɨlə̀ ǹloŋ mə bo tsuŋ mɨ̂nsî myaa mə tâ bə̀ ka nyə mə bo siꞌisə̂ ɨ̀bɨɨ nû waa tɨ jɨ̂. Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə bo kwɛ̀rə̀ mə̂ mɨtsɔꞌɔnə̀ mɨ ɨfaꞌâ myaa mɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lâ nɨ̀ yi mbàŋnə̀ tɨ siꞌisə ɨbɨɨ nû ghuu tɨ jɨ, nɨ̀ ka nsiꞌitə mɨ̂nsî muu nyɔꞌɔ, ");
INSERT INTO bfd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tâ bə̀ tsee yə mə nɨ̀ sìꞌìsə ɨbɨɨnû ghuu tɨ jɨ̂. Tâ Taà ghùù yìi à tswe alɔ̀ꞌɔ̀sə̀ aa, tâ yə. Boŋ Taà ghùù wa mə a yə ɨdɨgə a alɔ̀ꞌɔ̀sə̀ aa, à ka tsɔꞌɔ ɨfàꞌâ ghuu. ");
INSERT INTO bfd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nɨ̀ tsuu afùꞌû yuu a ɨtà fàa nsyɛ kɨ lə̀ə̀, a adɨgə yìi mə mbə ǹsə̀gə̀ ɨ̀ kurə kə̀ ǹtsə̀bə̀ ɨ̀ kô, kə̀ bɨ̀yə̀rə bəgə nyə̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nɨ̀ baŋnə ŋka nləə afùꞌû yuu bə a atǎ aburə, a adɨgə yìi mə m̀bə̂ ǹsə̀gə̀ ɨ̀ waꞌà kurə, kaa ntsə̀bə̀ waꞌà kɨ̀ ŋ̀ko, kaa bɨ̀yə̀rə waꞌà kɨ̀ m̀bəgə nyərə. ");
INSERT INTO bfd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ǹloŋ mə adɨ̀gə̀ yìi mə afùꞌû yo a tswe ghu aa, ǹtɨɨ̀ gho ɨ ka kɨɨ tswe aa ghu. ");
INSERT INTO bfd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nɨ̀liꞌì no laa mbə lâm ɨbɨɨnû ghô. Nɨ̀liꞌì no bə tswe sɨgɨnə̀, bəə boŋ mbɨ̀ɨ̀ nû yǒ ntsɨ̀m ɨ̀ luu nɨ̀ ŋ̀kàꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lâ nɨ̀liꞌì mo bə tsuu ɨ sɨgɨnə̌ tswe boŋ m̀bɨ̀ɨ̀ nû yǒ ntsɨ̀m ɨ̀ luu nɨ̀ m̀fiì ɨ̀dɨ̀gə̀. M̀bə̂ ŋ̀kàꞌà yìi mə ɨ tswe a nu bù aa ɨ bə mfii ɨdɨ̀gə̀ bəə boŋ à nɨ̂ m̀fii ɨdɨ̀gə̀ yî ǹswèrə̀ ǹswerə. ");
INSERT INTO bfd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kaa mbə ŋù à waꞌà a mbo bɨ̀tà bɨ afàꞌà bi baa ka mfaꞌa; ǹloŋ mə à ka bàà yî mɔ̀ꞌɔ ɨ bàŋnə kɔ̀ŋ yì mɔ̀ꞌɔ̂; kə̀ a kâ m̀faꞌa a mbo yì mɔ̀ꞌɔ nɨ̂ ǹtɨɨ̀ yi tsɨ̀m, m̀baŋnə ntsaꞌa nɨ yì mɔ̀ꞌɔ̂. Kaa mbə ò waꞌǎ a mbo Nwì bo bɨ̀ a mbô ŋ̀kabə ka mfaꞌa.” ");
INSERT INTO bfd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ma mùu ajàŋ, mə̀ tɨgə̀ ǹswǒŋ a mbo bù mə nɨ̀ tsuu ɨnnǔ kɨ waꞌa nloŋ ntswêntɨ̀ɨ̂ yùù, mə nɨ̀ ka jɨ aa àkə̀, kə̀ no aa àkə̀ lɛ, kə̀ ǹloŋə ɨbɨɨnû ghuu, mə nɨ̀ ka wɛꞌɛ aa àkə̀ lɛ. Ǹtswê ǹtɨ̀ɨ̂ yùu, ɨ̀ sɨ̀ mɨjɨ tsyàtə̀ aa ɛ? Mɨ̀bɨ̀ɨ̀mɨnû muu mɨ waꞌa ɨ̀tsə̀ꞌə̀ kɨ ntsyatə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nɨ̀ lentə bɨ̂sɨŋ bìi bɨ dàrə̀ a ndəŋ aà. Kaa bɨ sɨ waa njoo bweꞌe, kaa waꞌa kɨ̀ɨ̀ m̀fuꞌu nlə̀ə̀ nɨ a atà. Lâ Taà ghùù yìi à tswe a aburə aa, a jɛꞌɛ̀ nɨ̀ waa. Ǹdùû ghuu ɨ sɨ̌ ɨ waa tsyâtə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","M̀bə ŋù nɨ̀bû ghùù yî tsù a kuꞌùsə̀ mûbàŋtə̀ a nɨ̂ ǹtswêntɨ̀ɨ̂ yì ǹloŋ mə a waꞌa ɨnnù aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nɨ waꞌa nɨ̂ ɨnnù ǹloŋ ɨtsə̀ꞌə̀ aa aya aa ɛ? Nɨ̀ lentə ɨbwìꞌi ŋgɛ̀ɛ̀ jìi ɨ kwe a ŋgɛ̀ɛ̀ aà. Kaa ɨ sɨ nwùgɨ̀nə̀, kaa kɨꞌɨ̀ nɨ̂ àsìsì kɨɨ mbaꞌa. ");
INSERT INTO bfd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mə̀ swòŋə a mbo bù mə tsiꞌì m̀fɔ̀ Solomon, a mum nɨ̀ghaꞌà ni nɨ tsɨ̀m, kaa à lɛ ŋkɨꞌɨ atsə̀ꞌə̀ yî tsu wɛꞌɛ tâ à bɔŋ mbə tsiꞌì tsô jyaa. ");
INSERT INTO bfd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lâ m̀bə Nwìŋgɔ̀ŋ a ka nwɛꞌɛ ɨtsə̀ꞌə̀ a nû ŋ̀gɛ̀ɛ̀ a ɨtu mɨntaꞌa, yìi mə ɨ kwe sii a lo tɨ bə a yɔɔ bɨ tɔɔ̀ a abu aa, boŋ mbə a kɨꞌɨ ɨtsə̀ꞌə̀ a nu bù naŋsə̀ ŋ̀wɛꞌɛ ntsyatə aa ɛ? Àbìintɨɨ̀ yuu a kəꞌə bɨ laa aa a ya ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ma mùu ajàŋ, a kuꞌunə mə nɨ̀ tsuu ɨnnù kɨ waꞌa, ɨ betə nɨ mə, ‘Bìꞌì ka jɨ aa àkə̀, kə̀ bìꞌì ka no aa àkə̀, kə̀ bìꞌì ka wɛꞌɛ aa àkə̀ lɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ǹloŋ mə bɨ̀tɨ̀zî Nwî bɨ lɔ̀ɔ̀ ma jû ǹjoò tsɨ̀mə̀; lâ Taà ghùù a aburə à zi mə nɨ boŋ njoo mà jû tsiꞌì tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lâ tâ nɨ̀ foo ŋka nlɔɔ bə ànnù nɨfɔ̀ Nwî bo bɨ̀ ànnû yi yìi mə a tsinə aà, boŋ à ka kɨɨ fa njoo mà jû tsiꞌì tsɨ̀m a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ma mùu ajàŋ, nɨ̀ tsuu ɨnnù kɨ waꞌa nloŋ annǔ ayɔɔ bə̂, ǹloŋ mə ɨyɔ̀ɔ̀ ka lǒ tswe nɨ ɨ̀ jii ɨnnù. Tâ ŋ̀gɨꞌɨ yì sii tâ ɨ̀ kuꞌunə siì.” ");
INSERT INTO bfd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tsuu mɨlɔꞌɔ mɨ bə̂ kɨ twi tâ bɨ̀ tsuu mo ɨ kɨɨ twi. ");
INSERT INTO bfd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ǹloŋ mə àjàŋ yìi mə o twi mɨlɔꞌɔ mɨ bə̂ aa, à nɨ̂ àjàŋ yìi mə bɨ ka yǐ kɨɨ twi mô. Fɨ̀gə̀ yìi mə o fa nɨ a mbo bə̀ aa, à nɨ fɨ̀gə̀ yìi bɨ ka kɨɨ fa nɨ a mbo wò aà. ");
INSERT INTO bfd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","A ghɨ̀rə̂ àkə̀ mə ò ka nyə nɨ̂ àbàꞌa ati yìi mə a tswe nɨliꞌi ndɨ̂m ghò kaa ŋkɨꞌɨ nɨ̀ koonə yìi mə à tswe a nɨliꞌi wò aa yə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kə̀ m̀bə ò tsyà aa la nswoŋ a mbo ǹdɨ̂m ghò mə, ‘Zǐ ta mə̀ fiꞌi abàꞌa ati a nɨliꞌi wò’, mə koonə à bàŋnə ntswe a nɨliꞌi wò aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wò ŋgàŋàbagɨlə̀, foo ntyǎ mbìì m̀fiꞌi koonə wa a nɨliꞌi wò, boŋ ò ka naŋsə yə abàꞌa ati ya a nɨliꞌi ndɨm ghò ɨ fiꞌi. ");
INSERT INTO bfd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nɨ̀ tsuu njoo jìi ɨ laa màŋsə̀ aa a mbô m̀bu kɨ fa boŋ ɨ ka bəŋkə ɨ wǒ a nu bù. Nɨ̀ tsuu njoo atɨ̀ndùû juu a mbo bɨ̀kwiŋyàm kɨ fa boŋ bɨ ka nɨ̀ŋtə̀ ɨ ta ŋgɨꞌɨ ghu. ");
INSERT INTO bfd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nɨ̀ ka mbetə boŋ bɨ ka kɨ fa a mbo bù. Nɨ̀ ka nlɔɔ boŋ nɨ̀ ka yə. Nɨ̀ ka ŋkwɛntə boŋ bɨ ka ŋaꞌa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ǹloŋ mə ŋù ǹtsɨ̀m yìi a betə aa, a kwɛrə, ŋù ǹtsɨ̀n yìi a kɨɨ nlɔɔ aa, a yə. Ŋù yìi mə a kwɛ̀ntə̀ aa, bɨ kɨɨ̀ ŋ̀ŋaꞌa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kə̀ à nɨ̂ m̀buu ŋû ghuu yìi mə à tswe a atɨtɨ̀ɨ bù mə mbə mû yì à betə yi mə tâ à fa abaa a mbo yu a bâŋnə̀ m̀fa bə̂ ŋ̀gɔ̀ꞌɔ̀ ghu mbo aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kə̀ bɛɛ mə a betə yi mə à fa fɨbwɛ̀ a mbo yu a bâŋnə̀ m̀fa bə no aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","M̀bə bù bìi mə nɨ̀ nɨ ŋgǎŋghɨ̀rə ɨnnù jì bɨ, nɨ̀ zi ajàŋ mə m̀bə nɨ̀ ka mfa njoo jì sɨgɨ̀nə̀ a mbo bɔɔ̀ buu, boŋ mbə Taà ghùù yìi à tswe aburə aa a kɨꞌɨ njoo jì sɨgɨ̀nə̀ a mbo bə̀ bìi mə bɨ betə aa ka mfa aa mə akə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ka ŋghɨrə a nu bə̀ ɨ ɨnnù jya jìi mə o kɔ̀ŋə̀ mə bɨ̀ ka ŋghɨrə a nu wò aà. Ǹloŋ mə àâ ànnù yìi mə nɔ̀ŋsə̀ bo bɨ̀ nɨ̀ghàà nɨ ŋgǎŋntoo Nwî swoŋə aa a yulà. ");
INSERT INTO bfd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nɨ̀ tsya nɨ ǹtsǔ ŋkya yì kəgə wa ŋkuu, nloŋ mə ntsǔ ŋkya mà wa ɨ jwaanə ntəə, mânjì yì a kɨ̂ m̀fwaatə, ɨ ghɛ̀ɛ̀ aa a ntsǔ nɨ̀wo nɨ nlwìꞌì ǹjɨ̀mə̀, bə̀ kɨɨ̀ ǹzwu nyoŋə ghu ŋghaꞌa. ");
INSERT INTO bfd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lâ ǹtsǔ ŋkya yìi mə ɨ ghɛ̀ɛ a mûm ǹtswêntɨ̀ɨ̀ aa ɨ kəꞌətə; mânjì yìi mə a kɨɨ ŋghɛɛ ghu aa a tsyânə̀, a bə tsiꞌì m̀bùmtə̀ bə̂ mə mbə bɨ yə̂. ");
INSERT INTO bfd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nɨ̀ ka ntsyɛsə ghuu nɨ̂ ŋ̀gǎŋntoo Nwî m̀bweꞌesə̀, jìi ɨ zǐ a mbo bù m̀maꞌa ŋgùù m̀bînjə̀rə̀ a nu bo, lâ m̀baŋnə̀ mbə naàŋgwyɛ̀ mɨtsəꞌə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wa nɨ̀ ka yǐ zi waa aa a njɨ̌m mɨ̀ntâ myaa. M̀bə̂ àtǐ njɔ̂ŋ ǹjɔŋ a koonə̀ maŋgòlə̀ aa ɛ? Kə̀ ǹtsìbɨ̀njɔ̀ŋ ɨ koonə̀ àjɔ̀ɔ̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wa àtì yî sɨgɨ̀nə̀ a koonə aa mɨ̀ntà mî sɨgɨ̀nə̀, àtì yî bɨ a ŋkoonə aa mɨ̀ntà mî bɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kaa mbə àtì yî sɨgɨ̀nə̀ a kɨꞌɨ̀ yi mɨ̂ntà mî bɨ koonə̀. Kaa yì bɨ a waꞌǎ mîntà mî sɨgɨ̀nə̀ kɨ ŋkoonə. ");
INSERT INTO bfd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Àtǐ tsɨ̀m yìi kaa a sɨ mɨ̂ntà mî sɨgɨ̀nə̀ koonə aa, bɨ wà m̀maꞌa a mum mɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wa nɨ̀ ka yǐ kɨ zi waa ɨ yòŋə̀ aa a njɨ̌m mɨ̀ntâ myaa. ");
INSERT INTO bfd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kaa à sɨ̀ ŋû ǹtsɨ̀m yìi mə a twoŋə nàa mə, ‘M̀màꞌàmbî, M̀màꞌàmbî’, aa bə mə à ka yǐ kuu a mûm ànnù nɨfɔ aburə. A ka yǐ kuu tsiꞌì bə̀ bìi mə bɨ ghɨ̀rə annù yìi mə Taà ghà a aburə a lɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","À ka yǐ bə wa njwi ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa, tâ bə̀ bì ghàꞌàtə̀ zi nswoŋ a mbo mə̀ mə, ‘M̀màꞌàmbî, M̀màꞌàmbî, bìꞌì lɛ sɨ swoŋ ntoo yì ǹsɨgɨ̀nə̀ nɨ̂ ɨ̀kûm gho, m̀fiꞌi nɨ̂ ɨ̀zwì jî bɨ nɨ̂ ɨ̀kûm gho, ŋ̀kɨɨ ŋghɨrə nɨ̂ ɨ̀nnù jî yɛ̌yɛrə jî ghàꞌàtə̀ nɨ̂ ɨ̀kûm gho.’ ");
INSERT INTO bfd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tâ mə̀ swoŋ a mbo bo nɨ̂ ǹsi nɨ̀ ǹsɨ mə, ‘Wa mə̀ lɛ waꞌà ghuu zî. Nɨ̀ lo ghuu a mbɛ̀ɛ mə̀ ŋ̀ghɛɛ mba a ŋgǎŋghɨ̀rə̂ ɨ̀nnù jì bɨ̂!’ ");
INSERT INTO bfd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ŋù ǹtsɨ̀m yìi a yuꞌu mɨghàâ ma mù m̀fa nɨ mu aa, à bə̀ aa tsiꞌì tsǒ ŋù mɨ̀tsyɛ̀ yìi mə à bɔ̀ɔ ndâ yì a atû àlàŋsə ŋgɔ̀ꞌɔ̀; ");
INSERT INTO bfd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","bɛɛ mbə̀ŋ ɨ̀ zi nloo, ŋ̀kì ɨ luu, àfìsə̀ a kɨ ntsya ntum nda ya, kaa ɨ kɨꞌɨ̀ yi wô, ǹloŋ mə à lɛ mbɔɔ a atu alâŋsə ŋgɔ̀ꞌɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lâ ŋù yìi mə a yuꞌu mɨghàa ma mû kaa waꞌà nɨ mu faꞌa aa, à bə aa tsiꞌì tsǒ àjɨ̀ŋtə̀ ŋû yìi mə à lɛ ghùrə ndâ yì a atû àwàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nòò yìi mbə̀ŋ ɨ̀ lɛ nloo, mɨ̀ŋkì luuŋkə̀, à fìsə̀ a kɨɨ̀ ǹtsya ntumə nɨ̂ ǹda ya aa, ɨ wô tsiꞌǐ nɨ nɨ̀wò nî wè.” ");
INSERT INTO bfd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nòò yìi Yesu à lɛ mmàŋsə̀ a nswoŋ ma jû ɨ̀nnù aa, ɨ̀kùrə nnɔ̀ɔ̀ bə̂ wa ɨ yɛrə̀ àjàŋ yìi mə à lɛ sɨ dɨ̀ꞌɨ ànnù Nwì aa, ");
INSERT INTO bfd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ǹloŋ mə à lɛ sɨ dɨ̀ꞌɨ̀ waa aa tsǒ ŋù yìi à tswe nɨ̂ àdàꞌà, kaa waꞌà aa tsiꞌì tsǒ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ jyaa dɨꞌɨ̀ bə̂. ");
INSERT INTO bfd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu à lò mə̂ wa atu ntaꞌa nsɨgə mâbêm ǹnɔ̀ɔ̀ ɨ yoŋə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ŋù àkɨ̀kwen yî mɔ̀ꞌɔ à lɛ ŋkɨ nzi ntsiꞌi yi, nswɛtə mɨkuꞌutə̂ mi ghu nsi, ǹswoŋ mə, “M̀màꞌàmbî, ò bə kɔ̌ŋ, boŋ ò ghɨ̀rə nû yà ɨ laà.” ");
INSERT INTO bfd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu a nâsə̀ àbô yi mmɔɔntə yi ghu, ǹswoŋ ghu mbo mə, “Mə̀ kɔ̀ŋə̂, tâ nû yò laa.” Àkɨ̀kwen ya a lɛ kɨ mburə ŋghɛsə nsɨgə ghu nu, a laà. ");
INSERT INTO bfd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu a tɨgə̀ ǹswoŋ ghu mbo mə, “Yə̂, ò ghɛɛ, ò tsuu annù tsu a mbo ŋù lǒ swoŋə, la mbàŋnə̀ ŋ̀ghɛɛ ndɨ̀ꞌɨ ɨbɨɨ nû gho a mbô ŋ̀gàŋmàꞌanwì, ŋ̀kɨ mfa ayoo mmaꞌanwì yìi mə Moses à lɛ lə̀ə̀ aa, tâ dɨ̀ꞌɨ a mbo bə̀ mə nû yò ɨ̀ làà mə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nòò yìi mə Yesu à lɛ ŋghɛ̀ɛ̀ ŋ̀kuu a Kapernaum aa, àtu bɨ̂sogyɛ ŋkhɨ̀ a lɛ nzi ntsiꞌi yi, m̀buꞌu mbo ghu mbo mə à kwɛtə yi. ");
INSERT INTO bfd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ǹswoŋ mə, “M̀màꞌàmbî, nɨ̀ghɔ̀ɔ̀ bwentə a ŋgàŋàfàꞌâ ghà, à nɔ̀ŋə a ndâ tsiꞌì nɨ̀ ŋ̀gɨꞌɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu a tɨgə̀ ǹswoŋ mə, “Wa mə̀ ka zǐ ɨ ghùrə̀ yi.” ");
INSERT INTO bfd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Àtu bɨ̂sogyɛ̀ ya a kwiꞌi mə, “M̀màꞌàmbî, kaa mə̀ sɨ̀ kuꞌùnə̀ mə mbə ò zî ŋ̀kuu a nda mə̀; lâ, ghɛ̀nsə ŋghàà tsiꞌì nɨghàà nî fùùrə̀ boŋ ŋ̀gàŋàfàꞌâ ghà ghû à ka tɨɨ. ");
INSERT INTO bfd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ǹloŋ mə mə̀ laa mbə ŋû, ǹtswe nɨ̂ bə̀ bìi mə bɨ tswe nɨ̂ àdaꞌa a atu mə̀ ǹsaꞌa nɨ̂ ghà, mə̀ kɨ̂ ǹtswe nɨ̂ àdàꞌa a atu bɨ̀sogyɛ̀ bìi mə mə saꞌa aà: Mə̀ bə swoŋ nɨ yì mɔ̀ꞌɔ mə, ‘Ghɛ̀ɛ̂!’, boŋ à ghɛ̀ɛ̂; mə̀ kɨ nswoŋ nɨ yì mɔ̀ꞌɔ mə, ‘Zǐ!’ a kɨ̂ ǹzi; Bɛɛ mə̀ kɨ nswoŋ a mbo àbùꞌû ya mə ‘Ghɨ̀rə̀ yulà ànnù!’ a kɨ̂ ŋ̀ghɨrə.” ");
INSERT INTO bfd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu à yùꞌù mə̂ ànnù ya yìi mə à lɛ nswoŋ aa, nyɛrə, nswoŋ a mbo bə̀ bya mə bɨ lɛ sɨ yòŋə̀ nii aa mə, “Mə̀ swoŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, tsiꞌǐ a alaꞌa baIsrael, kaa mə̀ lɛɛ̀ ŋ̀kɨꞌɨ̌ abəŋə abìintɨɨ mà yû yə̂. ");
INSERT INTO bfd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mə̀ swòŋə a mbo bù mə bə̀ bî ghàꞌàtə̀ ka yǐ lò a mbɨ nsàꞌa nòò, nɨ a mbɨ ntso nòò, ɨ zǐ tswe a atu atɛtə̀ bo bɨ̀ Abraham, Isaac, nɨ Yakob wa a mûm annù nɨfɔ̌ aburə, ");
INSERT INTO bfd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","lâ tâ bɨ̀ baŋnə mmèꞌe bɨbɔŋ bɨ annù nɨfɔ̀ Nwì a mûm m̀fìi ɨ̀dɨ̀gə̀ a abɛɛ; tâ bo tɨgə nyəꞌə ghu ŋkurə nɨ̂ mɨ̀sɔ̀ŋə̂ myaa.” ");
INSERT INTO bfd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu a tɨgə̀ m̀bu nswoŋ a mbo atu bɨ̂sogyɛ̀ ya mə, “Ka ŋghɛ̀ɛ̂; wa ànnù ya mə ò bìì aa a ka ghɨ̀rə ŋgàŋàfàꞌâ ghò wâ.” Ŋ̀gàŋàfàꞌâ yì wa à lɛ ŋkɨ ntɨɨ tsiꞌì maa noò. ");
INSERT INTO bfd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu à lɛ ŋghɛ̀ɛ̀ ŋ̀kuu a nda Peta ǹyə nɔ̂ŋsə̂ yì a nɔ̂ŋ ŋ̀ghɔɔ nɨ fibà. ");
INSERT INTO bfd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A ghɛnsə̀ àbô yi mmɔɔntə ghu, fibà wa a maꞌàtə̀ yi, a bɨɨ̀nə̀ ǹtɨgə nlɔɔ mɨjɨ mfa a mbo bo bo jɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","À bə̀ mə̂ a noò ŋ̀kwɛ̂fɔ̀ bɨ zî nɨ̀ bə̀ bî ghàꞌàtə̀ bìi mə ɨ̀zwì jî bɨ ɨ lɛ ntswe a nu bo aà. Yesu a ghɛ̂sə̀ ŋ̀ghaa nɨghàà nî fùùrə̀ m̀furə ɨzwì jya, ŋ̀kɨ ŋghurə bə̀ bɨ̀tsɨ̀m bìi bɨ lɛ sɨ ghɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","À lɛ ghɨ̀rə̀ ma yû ànnù aa a lwensə ànnù yìi mə ŋgàŋntoò Nwì Yesaiah à lɛ nswoŋ aa mə, “À lɛ ŋkwɛrə ɨlɔ̀ꞌɔ̂ jiꞌinə̀ ŋ̀kɨ beꞌe mɨghɔ̀ɔ̂ miꞌinə̀ mɨtsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Àjàŋ mə Yesu à lɛ nyə mɨ̂nòò mî ghàꞌà ŋ̀ghaꞌa mìi mə mɨ lɛ karɨsə yi aa, ǹswoŋə a mbo ŋgǎŋyəgə̂nnù ji mə tâ bɨ̀ too ŋghɛɛ wa njii àtsùm yî mɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ŋ̀gàŋndɨ̀ꞌɨ nɔ̀ŋsə̀ yî mɔ̀ꞌɔ, à lɛ nzì ǹswoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨ̀nnù, mə̀ ka kɨ yòŋə̀ nɨ̂ gho a nɨ̂ ŋ̀gɔ̀ŋ ɨ̀dɨ̀gə tsɨ̀m jìi mə o ghɛ̀ɛ̀ ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu a kwiꞌi ghu mbo mə, “Ɨ̀tsò ɨ tswe nɨ̀ mɨ̀mborə̀ myaa, bɨ̀sɨŋ kɨ̂ ǹstswe nɨ̂ ǹdâ jyaa; la kaa Mu Ŋù à sɨ̀ nɨ̂ àdɨ̀gə̀ yìi mə mbə a nɔ̂ŋsə̀ àtû yi ghu mmɨɨntə aa tswê.” ");
INSERT INTO bfd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ŋ̀gàŋyə̀gə̂nnù yì yî mɔ̀ꞌɔ à lɛ ŋkɨ nswoŋ ghu mbo mə, “M̀màꞌàmbî, lə̀ə tâ mə̀ bɨɨ ŋghɛ̀ɛ̀ m̀foo ntwiŋə taà yaꞌa.” ");
INSERT INTO bfd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","La Yesu a swoŋ ghu mbo mə, “Zǐ ŋka nyòŋə̀ nàâ, m̀maꞌatə tâ bɨ̀ku ka ntwiŋ bɨkû bɨ bə̂ byaa.” ");
INSERT INTO bfd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu à lɛ ntɨgə ŋkuu a mûm àkànuꞌu, ŋ̀gǎŋyəgə̂nnù ji jya ɨ kɨ̂ ǹyoŋə yi ŋkuu ghu. ");
INSERT INTO bfd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bo kà mə̂ aa ŋghɛɛ, àfìsə̀ yî tɨ̀ɨ̀ a lɛ ŋghɛ̀sə̀ m̀beꞌenə ŋka ntsya wa mûm ŋ̀kì. Ɨ̀kàŋə ŋkì ɨ tumə̀ nɨ̂ àkànuꞌu ya a tɨgə̀ ǹlɔɔ nɨ̂ m̀bwɛ wa mûm ŋ̀kì. La Yesu à lɛ mbàŋnə̀ ǹnɔŋ mbwii. ");
INSERT INTO bfd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bɨ lɛ ŋghɛ̀ɛ̀ ǹtsɨgɨtə yi nswoŋ mə, “Yweensə yiꞌi, Mmàꞌàmbî; wa bìꞌì tɨgə ntswe aa a ntsu nɨ̀ wô.” ");
INSERT INTO bfd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu a kwiꞌi mə, “Nɨ naŋsə mbɔꞌɔ aa àkə̀ laà aa ɛ? Àbìintɨɨ̀ yuu a kəꞌə bɨ laa a ya aa ɛ?” À lɛ ntɨgə mbɨɨnə, ŋwenə afìsə̀ ya bo bɨ̀ ɨ̀kàŋnə ŋkì jya, ɨ̀dɨ̀gə̀ ɨ m̀bɔrə mə tùk ǹtɨgə ŋghɛɛ nɨ mə swee. ");
INSERT INTO bfd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bə̀ bɨ̀tsɨ̀m lɛ nyɛrə ntɨgə nswoŋə nɨ mə, “Àâ m̀buu ŋu akə à ghuà aa ɛ? Tsiꞌì àfìsə̀ bo bɨ̀ ɨ̀kàŋnə ŋkì ɨ yuꞌunə̀ nii aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu à tòò mə atsùm ya, m̀fɛꞌɛ a alaꞌa Gadara m̀bâŋnə̀ ji baa jìi mə bɨ̀demon lɛ ntswe a ɨtoꞌo bo aa, bɨ lô a ɨtu mɨsyɛ̀ ǹzi ntsiꞌi yi. Bə̀ ma bû lɛ ntsəꞌə siꞌi ŋghɨrə mə tâ ŋù tsee maa mânjì kɨ tsyà. ");
INSERT INTO bfd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bo ghɛ̀sə̀ mə̂ ǹyə Yesu aa, ŋka ntɔŋnə nswoŋə nɨ mə, “Bìꞌinə̀ tswe aa nɨ̀ àkə aa ɛ, a Mu Nwì? Ò zǐ faa mə o zǐ nnɨŋ ŋgɨꞌɨ a nu bìꞌì tɨghə nòò à kùꞌù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Àkàrə̀ bɨ̂kwiŋyàm a lɛ ntswe maa mbɛ̀ɛ̀ àdɨ̀gə̀ njɨ. ");
INSERT INTO bfd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bɨ̀demon bya bɨ tɨgə̀ m̀buꞌu mbo a mbo Yesu mə, “M̀bə ò ka mfiꞌi yiꞌi, ò toò yiꞌi bìꞌì ghɛɛ̀ ŋ̀kuu a nu àkàrə̀ bɨ̂kwiŋyàm yî.” ");
INSERT INTO bfd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu a swoŋ a mbo bo mə, “Nɨ̀ ghɛɛ.” Bo lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ ŋkuu a nu àkarə̀ bɨ̂kwiŋyàm yâ tsɨ̀m, a juꞌù ǹsɨgə mbaa yâ; ǹtɨgə ŋkoŋ wa a mûm ŋ̀kì. ");
INSERT INTO bfd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bə̀ bìi bɨ lɛ sɨ bɛ bɨ̂kwiŋyàm bya aa, bɨ lɛ nlò ŋ̀khə ŋkuu wa njɔ̀ꞌɔ̀ àlaꞌà ǹtɨgə nswoŋ ɨnnù tsɨ̀m bo bɨ̀ ànnù yìi a lɛ mfɛ̀ꞌɛ̀ a nu bə̀ bya bi baà. ");
INSERT INTO bfd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bə̀ bɨtsɨ̀m lɛ mfɛ̀ꞌɛ̀ wa njɔ̀ꞌɔ̀ àlaꞌa nzì ǹtsiꞌi Yesu. Bo yə̂ mə̂ yi aa mbuꞌu mbo ghu mbo mə tâ à maꞌatə mbùꞌù àlaꞌà yàà ya mburə ŋghɛɛ yi tâ àghaꞌa saꞌa. ");
INSERT INTO bfd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu à lɛ ŋkuu a mûm àkànuꞌu ntoo ŋghɛɛ a njɔ̀ꞌɔ̀ àlaꞌa bo. ");
INSERT INTO bfd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bə̀ lɛ mbèꞌe a mbweŋkə yi mɔꞌɔ nɨ̂ ɨ̀kùû yi nzi nɨ ghu ghu mbo. Yesu, à yə̀ mə abìintɨɨ̀ yaa, nswoŋə a mbo m̀bwènkə̀ wa mə, “Tswa ntɨɨ̀ gho mbǎ mû ghà; wa bɨ lìꞌìnə̀ mə ɨbɨ̂ ghô.” ");
INSERT INTO bfd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ jya ji mɔꞌɔ ɨ yuꞌu nswoŋ bo nɨ bo mə, “M̀bâ ghû a bə̀gɨ̀tə̀ aa Nwì.” ");
INSERT INTO bfd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu à lɛ nzi annù yìi mə bo lɛ sɨ mɔ̀ɔ̀ntə aa nswoŋ mə, “Nɨ mɔ̀ɔ̀ntə ɨjǎŋ ɨnnù jî bɨ juà a mûm mɨ̀ntɨɨ bù aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A waŋsə aa a swoŋ mə, ‘Bɨ lìꞌì mə ɨfansənnù jo,’ kə̀ a nswoŋ mə, ‘Bɨ̀ɨ̀nə ŋka ntəə ghɛ̀ɛ̀ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Lâ mə̀ ka dɨ̀ꞌɨ a mbo bù mə Mu Ŋù à tswe nɨ̀ àdàꞌà fàa atu nsyɛ a lìꞌìnə̂ ɨ̀bɨ̂.” A tɨgə̀ m̀bu nswoŋ a mbô m̀bwènkə̀ wa mə, “Bɨ̀ɨ̀nə mbèꞌe ɨkuù gho ŋghɛ̀ɛ̀ gho a ndùgə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","À lɛ mbɨ̀ɨ̀nə̀ ŋ̀ghɛɛ yi a ndùgə yu. ");
INSERT INTO bfd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Àjàŋ yìi mə nnɔ̀ɔ̀ bə̂ bya lɛ nyə laà aa, bo lɛ mbɔꞌɔ, ǹtɨgə ŋghaꞌasə nɨ̂ Nwî, nloŋ mə à fâ àjàŋə adaꞌa ma ya a mbo bə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu à lò mə̂ maa adɨgə ŋka ntsya, nyə Mateo, ŋù ŋkwɛrə bɨ̀tax a tswê a ndâfàꞌa yu. A swoŋ ghu mbo mə, “Ka nyòŋə̀ nàâ.” À lɛ mbɨ̀ɨ̀nə̀ ǹyoŋə yi. ");
INSERT INTO bfd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu à ghɛ̀ɛ̀ mə̂ ǹtswe ŋka njɨ a nda Mateo, ŋ̀gǎŋkwɛrə bɨ̀tax jÎ ghàꞌàtə̀ bo bɨ̀ ŋ̀gǎŋghɨ̀rə ɨnnù jî bɨ ɨ zî ǹtswe bo bɨ̀ Yesu nɨ̂ ŋ̀gǎŋyəgə̂nnù ji wa atu atɛtə̀. ");
INSERT INTO bfd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bafarɨsai yə̀ mə̂ aa, mbetə ŋgǎŋyəgə̂nnù ji mə, “Ǹdɨ̀ꞌɨ̀nnù ghùù a jɨ bo bɨ̀ ŋ̀gǎŋkwɛrə bɨ̀tax nɨ bə̀ bî bɨ aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu a yuꞌu, ǹswoŋ a mbo bo mə, “Kaa bə̀ bìi mə bɨ tswe bɨtɨ̀ɨ̀ aa sɨ dokta lɔɔ, lâ a lɔ̀ɔ ŋgàŋmɨghɔ̀ɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Lâ nɨ̀ ghɛɛ nlɔ̀ɔ̀ ǹjiꞌì nɨ̀ghàà nɨ Nwî nya mə nɨ swoŋ mə: ‘Mə lɔ̀ɔ̀ aa annǔ ŋko mɨ̀lɨ̀ŋnə̀, kaa mə̀ sɨ aa njoo mmàꞌanwì lɔɔ.’ Kaa mə̀ lɛ ŋwaꞌà zì aa a ntwoŋ bə̀ bìi mə mɨ̀nnû myaa mɨ tsinə aà, mə̀ lɛ nzì aa a ntwoŋ bə̀ bìi bɨ ghɨ̀rə ɨnnù jì bɨ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ŋ̀gǎŋyəgə̂nnǔ Jɔn ɨ lɛ nzì m̀betə Yesu mə, “Bìꞌi bɨ̀ baFarɨsai siꞌisə mɨbɨ̀ɨ̀ mɨ nû miꞌi tɨ jɨ̂, kaa ŋgǎŋyəgə̂nnù jo waꞌà siꞌisə̀ aa a ya lɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu a kwiꞌi mə, “M̀bə bə̀ bìi bɨ twoŋə waa a adɨgə nɨyɔꞌɔ kâ ǹjəŋə wâ noò mə ǹdoo mûŋgèn à tswe bo bo aa ɛ? Ŋ̀gaŋ! Lâ nòò à ka yǐ zǐ yìi mə bɨ ka yǐ lɔ̀gə ndoo mûŋgèn wa ɨ lɔ̀ꞌɔ̀sə̀ a mbɛ̀ɛ bo aa, tâ bo bɨmbɔŋ tɨgə kɨ siꞌisə mɨbɨ̀ɨ̀ mɨ nû myaa tɨ jɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kaa ŋù laa waꞌà lɔ̀gə̀ nɨ̂ àsàꞌa atsə̀ꞌə̀ yî fii a nnɨŋə nɨ̂ àbùꞌu àtsə̀ꞌə̀ yî lwèn ǹtatə; à bə ghɨ̀rə̀ ma mùu ajàŋ boŋ a satə atsə̀ꞌə̀ yî fii ya a ka swùŋə̀ yî lwèn ya ɨ sàꞌàtə abùꞌù yâ tâ à ghaꞌatə. ");
INSERT INTO bfd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaa bɨ sɨ kɨɨ nlɔgə nɨ mɨ̀lùꞌù mî fii nnɨ̀ŋə nɨ̂ ŋ̀gùu mɨlùꞌu jî lwèènə̀; bɨ bə nɨŋ, bəə boŋ ŋ̀gùù jya ɨ ka bwiꞌikə, tâ mɨ̀lùꞌù mya saa, tâ bɨ̀ kɨ nta ŋgɨꞌɨ nɨ̂ ŋ̀gùù jyâ. Lâ bɨ bə nɨŋ mɨlùꞌù mî fii a nɨ̂ ŋ̀gùù jî fii, bəə boŋ ŋgùù jya ka tswe sɨgɨ̀nə̀ tâ mɨ̀lùꞌù mya kɨ ntswe ghu.” ");
INSERT INTO bfd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nòò yìi mə Yesu à lɛ sɨ swoŋə ma ya ànnù aa, ǹtsyàsə̀ baYuda yî mɔ̀ꞌɔ a zî ghu mbô, ǹswɛtə mɨkuꞌutə̂ mi ghu nsi, nswoŋ mə, “Mû ghà yî màŋgyɛ̀ à ghɛ̀nsə ŋkwo; lâ zǐ nnɔ̀ŋsə abô yo ghu nu ta tâ à bu ntswe ntɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu à lɛ mbɨ̀ɨ̀nə̀ bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji, ŋghɛɛ bo bo. ");
INSERT INTO bfd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Màŋgyɛ̀ yî mɔ̀ꞌɔ yìi mə à lɛ ŋghɔ̀ɔ̀ nɨghɔ̀ɔ̀ nɨ bâŋgyɛ̀ nɨ ɨ̀lòò nɨghûm ǹtsò baa, nɨ zî tsiꞌì nɨ̀tɨ̀ɨ̀ kaa waꞌà kɛntə̀ aa, à lɛ nyòŋ m̀mɔɔntə atsəŋə atsə̀ꞌə̀ Yesu; ");
INSERT INTO bfd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ǹloŋ mə à lɛ nswoŋə a mûm ǹtɨɨ yu mə, “Mə̀ bə tɛꞌɛ mɔ̀ɔ̀ntə̀ tsiꞌǐ atsə̀ꞌə̂ yi boŋ mə̀ ka tɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu à lɛ ŋkarɨkə, ǹyə yi, nswoŋ mə, “Tswa ntɨɨ̀ ghô m̀ba mû ghà yî màŋgyɛ̀; wa àbìintɨɨ̀ yo a ghɨ̀rə̀ mə̂ ò tɨɨ̀.” Màŋgyɛ̀ wa à lɛ mburə ŋkɨ ntɨɨ tsiꞌì maa noò. ");
INSERT INTO bfd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu a ghɛɛ̀ ŋ̀kuu wa ndâ ǹtsyàsə̀ baYuda wa, ǹyə ŋgǎŋmbuꞌu mɨ̀kòò bo bɨ̀ ǹnɔ̀ɔ ŋgǎŋyəꞌə nɨ̀wo wa ɨ tsɨgə̀ nɨ̀ ɨ̀dɨ̀gə̀, ");
INSERT INTO bfd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ǹswoŋ mə, “Bə̀ bɨ̀tsɨ̀m lòkə̂ nɨ̀! Wa mumàŋgyɛ̀ ghû kaa à sɨ̀ aa kwò kwô; a bwii aà bwìì.” À swòŋ mə̂ laa aa bo kâ ŋ̀wyɛ yi. ");
INSERT INTO bfd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lâ bɨ ghɨ̀rə̀ mə̂ ǹnɔ̀ɔ̀ wa ɨ fɛꞌɛ̀ ŋ̀ghɛɛ a abɛɛ, a kuu ntswa abo mu wa, a bɨɨ̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ŋ̀gàn ǹloŋ ma yaà ànnù ɨ̀ lɛ nsɛ̀ɛ̀nə̀ ŋ̀ghɛɛ ɨdɨgə tsɨ̀m wa alaꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu à màꞌàtə̀ mə adɨgə ma ya ŋka ŋghɛɛ, bɨ̀fə̀ꞌə̀nə̀ bi baa kâ ǹyoŋə nii, ǹtɔŋnə nswoŋə nɨ mə, “Ko mɨlə̀ŋnə̀ yìꞌì m̀bâ mu David.” ");
INSERT INTO bfd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu à ghɛ̀ɛ̀ mə̂ ŋ̀kuu a mûm ǹda aa, bɨ̀ fə̀ꞌə̀nə̀ bya bi baa bɨ zǐ ntsiꞌi yi. Yesu a betə̀ waa mə, “Nɨ̀ bii mə mbə mə̀ ghurə̀ ghuu aa ɛ?” Bo kwiꞌi mə, “Ɨ̀ɨ̀ŋə, Mmàꞌàmbî.” ");
INSERT INTO bfd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu a tɨgə̀ m̀mɔɔntə miꞌì myaa nswoŋ mə, “Ànnù ya mə nɨ̀ bìi aa, tâ à ghɨrə ghuu.” ");
INSERT INTO bfd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Miꞌì myaa mya lɛ nlaa, bo kâ ǹyə ɨdɨgə. Yesu a waꞌàsə̀ waa tsiꞌì nɨ̀tɨ̀ɨ̀ ǹswoŋ mə, “Nɨ̀ tsee annù yû a mbo ŋù swoŋə.” ");
INSERT INTO bfd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lâ bo lɛ nlò ŋ̀ghɛɛ ntɨgə nsɛɛnsə annù ǹloŋ Yesu wa mbùꞌà àlaꞌà ǹtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nòò wa yìi mə bɨ fə̀ꞌə̀nə̀ bya lɛ mfɛ̀ꞌɛ̀ ŋ̀ka ŋghɛɛ aa, bə̀ bî mɔꞌɔ lɛ nzì nɨ ŋù yìi mə àzwì yî bɨ a lɛ ŋghɨ̀rə̀ kaa a waꞌà ghàà aa a mbo Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu à fìꞌì mə azwì yî bɨ ya, ŋù wa a lɔgɨ̀nə̀ ŋ̀ka ŋghaa; ǹnɔ̀ɔ̀ bə̂ wa ɨ lɛ nyɛrə mbuꞌu nɨ̂ ŋ̀gòò mə, “Kaa bìꞌì lɛɛ̀ ŋ̀waꞌǎ mbuu annù yulà a alaꞌa Israel yə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","BaFarɨsai bâŋnə̀ ǹswoŋ mə, “A fiꞌi bɨdemon aa nɨ̀ m̀fɔ̀ bɨ̀demon wa mə à tswe nɨ ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu à lɛ sɨ tɨgə ŋkarə a mûm ǹjɔ̀ꞌɔ alaꞌa bo bɨ̀ bɔɔ bɨ alaꞌa, ǹdɨꞌɨ nɨ̂ nɨ̀ghàà nɨ Nwî a mûm ǹdaŋghotə nswoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya nloŋə annù nɨfɔ̌ aburə, ŋ̀kɨɨ ŋghurə nɨ mɨ̀ghɔ̀ɔ̀ mɨtsɨ̀m bo bɨ̀ ɨ̀lɔ̀ꞌɔ tsɨ̀m jìi ɨ lɛ ntswe a nu bə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nòò yìi à lɛ nyə mɨnɔ̀ɔ̀ myaa, à lɛ ko mɨlɨ̀ŋnə̀ wàà ǹloŋ mə bo lɛ sɨ tsɨŋə nkarə nɨ̂ ŋ̀gɨꞌɨ kaa waꞌà nɨ̂ àkwɛtə̀ tswê tsǒ m̀binjèrə̀ jìi mə kaa ɨ sɨ̀ nɨ̂ ǹtsèè tswe aà. ");
INSERT INTO bfd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yesu a tɨgə̀ ǹswoŋə a mbô ŋ̀gǎŋyəgə̂nnù ji mə, “Mɨjɨ mɨ bè mə̂ a nsoo ghaꞌa lâ bɨ̀fùꞌù bâŋnə̀ ŋ̀kəꞌətə; ");
INSERT INTO bfd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","nɨ̀ ka ntsaꞌatə Nwî mə tâ M̀màꞌàmbî m̀bɔ̂ŋ ǹsòò à too ŋgǎŋfàꞌà tâ ɨ̀ ghɛɛ mfùꞌù mɨjɨ̂ mi myâ.” ");
INSERT INTO bfd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu a twôŋ ŋ̀gǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa mfa adaꞌa a mbo bo mə bo ghɛɛ ŋka mfiꞌi nɨ̂ ɨ̀zwì jɨ̂ bɨ ŋkɨɨ ŋghurə nɨ mɨ̀ghɔ̀ɔ̀ mɨtsɨ̀m bo bɨ̀ ɨ̀lɔ̀ꞌɔ tsɨ̀m a nu bə̀. ");
INSERT INTO bfd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Àa mɨ̀kùm mɨ ŋgǎŋtoo Kristo jya mɨ muà: Ǹtsyàmbìɨ̀ à lɛ mbə Simon, yìi mə bɨ kɨɨ ntwoŋə nɨ Peta aà; nɨ Andrew yìi mə à lɛ mbə muma bɨ̀ Peta aà; Jɛms bo mumaà yì Jɔn, bɔɔ bɨ Zebedee; ");
INSERT INTO bfd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip bo Batholomew; Thomas bo Mateo, yìi à lɛ mbə ŋgàŋkwɛrə tax aa; Jɛms mu Alfeus, bo Thaddaeus, ");
INSERT INTO bfd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon ŋù Cananaan, nɨ Judas Iscariot, yìi à lɛ mfèè Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu à lɛ ntoo waa ma bû nɨghûm ǹtsò ji baa nswoŋ a mbo bo mə: “Nɨ̀ tsee alaꞌa bɨ̀tɨ̀zî Nwî ɨ lǒ kuu, kə̀ a njɔ̀ꞌɔ̀ àlaꞌa Samaria yî tsù. ");
INSERT INTO bfd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nɨ̀ ghɛɛ tsiꞌì a mbo m̀bi njə̀rə̀ Israel jya mə ɨ bwɛ aà. ");
INSERT INTO bfd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ŋ̀ghɛɛ ŋka nswoŋə nɨ mə, ‘Wa ànnù nɨfɔ̌ aburə a tɨgə a abô.’ ");
INSERT INTO bfd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nɨ̀ ka ŋghurə ŋgàŋmɨghɔ̀ɔ̀, m̀bɨɨnsə nɨ bɨ̀ku bɨ bə̂, ŋ̀ghurə nɨ̂ ŋ̀gàŋakɨ̀kwen, ŋkɨɨ mfurə nɨ̂ ɨ̀zwì jɨ̂ bɨ a nu bə̀. Nɨ̀ kwɛ̀rə aa tɨ̀ ŋ̀kabə̀, nɨ̀ kɨ mfa tɨ̂ ŋ̀kabə̀. ");
INSERT INTO bfd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nɨ tsuu a gold, kə̀ silver, kə̀ ŋkabə̀ koper lǒ lɔ̀gə̀; ");
INSERT INTO bfd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nɨ̀ tsee abàa nnɨŋ njoo, kə̌ ɨtsə̀ꞌə̀ ji baa, kə̌ ntam, kə̌ ati yî tswèꞌè lǒ lɔ̀gə̀. A kuꞌunə mə bɨ̀ ka mfa mɨjɨ a mbo ŋ̀gàŋàfàꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nɨ̀ yǐ ŋghɛ̀ɛ̀ ŋ̀kuu a njɔ̀ꞌɔ̀ àlaꞌa yì tsù, kə̀ a nɨ àlaꞌa yì kə̀gə, nɨ̀ lɔ̀ɔ ŋû yìi à kùꞌùnə aa, ŋka ntswe bu bo nyweꞌe a noò yìi nɨ̀ ka mmàꞌàtə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɨ̀ yi ŋkuu a nda yìi nɨ̀ kùu ghu aa, nɨ̀ swoŋ mə, ‘M̀bɔɔnə a mbo bù.’ ");
INSERT INTO bfd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bɛɛ mə banda bya bɨ kuꞌunə, boŋ m̀bɔɔnə ya ɨ̀ ka lwìꞌì ghu; bɛɛ mə ǹda ya ɨ̀ sɨ̀ kuꞌùnə̀, m̀bɔɔnə yùù ya ɨ bû m̀bɨɨ fu a nu bù. ");
INSERT INTO bfd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bɛɛ nɨ̀ yǐ ŋghɛ̀ɛ̀ ŋ̀kuu a adɨgə ŋù tsuu ghuu kwɛrə, kə̀ ǹtsuu annù yìi mə nɨ swoŋə aa yuꞌutə, nɨ̀ yɛtə̌ abɨrə yìi mə a tswe a mɨkòrə bù aa mfɛꞌɛ ghuu maa nda kə̀ maa njɔ̀ꞌɔ̀ àlaꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, à ka yi bə wa njwî ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa tâ Nwì à ko mɨlɨ̀ŋnə̀ Sodom bo Gomorrah ntsyatə yî ǹjɔ̀ꞌɔ̀ àlaꞌa ma yâ. ");
INSERT INTO bfd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Yə nɨ̀, mə too ghuu aa tsiꞌi tsǒ bɨ too mbinjə̀rə̀ a tɨtɨ̀ɨ bɨ̀takurə̀. Maa ajàŋ nɨ̀ tsyɛsə tsiꞌì tsǒ no, ŋkɨ mbɔnə mbə tsǒ bɨ̀bugɨləmɨ̀kuù. ");
INSERT INTO bfd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nɨ̀ ka ntsyɛsə ghuu, bɨ ka yǐ kɨ lɔ̀gə̀ nɨ̂ ghuu ɨ ghɛ̀ɛ̀ nɨ bù a mbo ŋgǎŋnsaꞌa mɨ̀saꞌa, tâ bɨ̀ ghɔɔ nɨ̂ ghuu a ndâŋghòtə̂. ");
INSERT INTO bfd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bɨ ka yǐ kɨ swùŋə̀ nɨ̂ ghuu zì nɨ bù a nsi bɨ̀gûmnàà bo bɨ̀ bɨ̀fɔ̀ ǹloŋ ɨkûm ghâ, mə tâ nɨ̀ zǐ nswoŋ ntoo yì ǹsɨgɨ̀nə̀ ya a mbo bo bɨ̀tɨ̀zî Nwî. ");
INSERT INTO bfd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bɛɛ bɨ yi nlɔ̀gə̀ ghuu ŋghɛɛ nɨ bù, nɨ̀ tsee kɨ waꞌa nloŋə annù yìi nɨ̀ ka swoŋə, kə̀ mânjì yìi nɨ̀ ka swoŋ ghu aà. Wa nòò à bə kùꞌù boŋ bɨ ka fa annù yìi nɨ̀ ka swoŋ aa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wa kaa à ka waꞌa bu ka ŋghaa. Mɨ̀ghàà mìi nɨ̀ ka kɨ ghàà aa, mɨ ka kɨ lò aa a mbo Àzwì Taà ghùù tâ à ka ŋghaa ntsyà nɨ a nu bù. ");
INSERT INTO bfd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ŋù à ka yǐ kɨ fa nɨ mumaà yì mə bɨ̀ zwitə, tâ tà à ka mfa nɨ mû yì mə bɨ̀ zwitə, tâ bɔɔ fa nɨ̂ bɨ̀taà byaa bo bɨ̀ bɨ̀maà byaa mə bɨ̀ zwitə. ");
INSERT INTO bfd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“Bə̀ bɨ̀tsɨ̀m ka yǐ kɨ bàà ghuu nloŋ ɨkûm ghâ. Lâ ŋù yìi mə à tswa ntɨɨ̀ yi nyweꞌe a nlwìꞌì aa, à ka yi yweenə. ");
INSERT INTO bfd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bɛɛ bɨ yi tɨ tsɔꞌɔ akòrə̂ yuu a mûm ǹjɔ̀ꞌɔ̀ àlaꞌa yì tsù, nɨ̀ khə̂ ŋ̀ghɛɛ nɨ yì dàŋə̀. Mə̀ swoŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, nòò yìi mə Mu Ŋù à ka yǐ bǔ bɨ̀ɨ̀ aa, kaa tâ nɨ̀ burə tɨ a mûm ǹjɔꞌɔ ɨlaꞌa baIsrael tsɨ̀m kuù. ");
INSERT INTO bfd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kaa ŋ̀gàŋyəgə̂nnù kaa à sɨ ndɨ̀ꞌɨ̀ yì tsya, kaa ŋ̀gàŋàfàꞌà a waꞌa nɨ ta àfàꞌâ yì kɨɨ ntsyatə. ");
INSERT INTO bfd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ŋ̀gàŋyəgə̂nnù à bə bə tsiꞌì tsǒ ǹdɨ̀ꞌɨ̀ yì boŋ a kuꞌunə̂, ŋ̀gàŋàfàꞌà a kɨ mbə tsǒ ta àfàꞌâ yì a kuꞌùnə̀. M̀bə bɨ ka ntwoŋə a tâ ǹdùgə̀ nɨ Beelzebul, boŋ bɨ ka tɛꞌɛ twoŋ bandùgə̀ bya nɨ̂ ɨ̀kùm yìi ɨ bɨꞌɨ ntsyà ma wâ. ");
INSERT INTO bfd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Maa mùu ajàŋ, nɨ̀ tsuu bə̂ kɨ bɔꞌɔ; ànnù tsɨ̀m yìi mə bɨ bɔɔntə aa, a ka yǐ fɛ̀ꞌɛ yɛntə, kə̀ yìi mə bɨ lɔꞌɔsə aa, a ka fɛ̀ꞌɛ bɨ̀ yə. ");
INSERT INTO bfd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“Ànnù yìi mə mə swoŋ a mbo bù a mfiì ɨ̀dɨ̀gə̀ aa, nɨ̀ swoŋə a nlaa ɨdɨ̀gə̀, ànnù yìi mə mə tsùmtə a mbo bù aa, nɨ tɨgə ntəə a atu nɨdòò nɨ nda ŋkɛ̀ꞌɛ̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nɨ̀ tsee ŋû yìi mə mbə a zwitə̀ ɨ̀bɨɨnû ghuu lâ kaa waꞌǎ nzwitə ǹtɨɨ̀ ghuu zi aa kɨ bɔꞌɔ; nɨ̀ ka mbɔꞌɔ ŋû yìi mə mbə a tsə̂ ŋ̀gɨꞌɨ a nɨ̂ ǹtɨɨ̀ ghuu nɨ̂ ɨ̀bɨ̀ɨnû ghuu mmaꞌa a mum mɔꞌɔ tɨ mɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Tɨgə bɨ fèe ndaꞌa ji baa aa nɨ kabà aa ɛ? La kaa mbə ǹdaꞌa yì m̀fùùrə̀ waꞌǎ a nsyɛ wò tɨghə̂ Taà ghùù à bìî. ");
INSERT INTO bfd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lâ ŋ̀ghɛɛ nɨ yùu ŋgaa, tsiꞌì ɨ̀nǒŋ atu jìi ɨ tswe a ɨtu bù aa, à sə̀ŋ mə̂ tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Maa ajàŋ, nɨ̀ tsee kɨ bɔꞌɔ; wa ǹdùû ghuu ɨ tɨɨ ntsyàtə̀ yi ndaꞌa jî ghàꞌàtə̀! ");
INSERT INTO bfd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ŋù yìi mə a bii gha nɨ̀ ǹsi nɨ nsi fàa mbi aa, mə̀ ka yǐ kɨ bii yi a nsi miꞌi Taà yìi à tswe a aburə aà; ");
INSERT INTO bfd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","lâ ŋù yìi mə a tuu nàa a nsi miꞌi bə̀ aa, mə̀ ka yǐ kɨɨ tuu yi a nsi miꞌi Taà yìi à tswe a aburə aà. ");
INSERT INTO bfd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nɨ tsee waꞌatə mə mə̀ zì aa a mfâ m̀bɔɔnə a mbô m̀bî; kàa mə̀ sɨ̀ zì aa a mfâ m̀bɔɔnə̂, mə̀ zì aa a ŋghɨ̀rə mə bə̀ ka nto nɨ munwî ǹtsò. ");
INSERT INTO bfd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mə̀ zì aa a ŋghɨ̀rə mə tâ mûmbâŋnə̀ bo taà yì tɨgə mfunə ɨtû jyaa, tâ mumàŋgyɛ̀ bo ǹdè yì tɨgə mfunə nɨ̂ ɨ̀tû jyaa, tâ màŋgyɛ̀ bo manə̀ yì kɨɨ mfunə nɨ̂ ɨ̀tû jyaa; ");
INSERT INTO bfd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tâ ŋ̀gàŋkɨbàa ŋû ɨ̀ baŋnə mbə aa bə̂ ŋ̀gǎŋgwɛ̀ꞌɛ̂ ji. ");
INSERT INTO bfd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ŋù yìi à kɔ̀ŋə taà yì kə̌ ndè yì ǹtsyatə gha aa, kaa à sɨ̀ kuꞌùnə̀ a mbə ŋgàŋyə̀gə̂nnù ghà. Ŋù yìi a kɔ̀ŋə mû yì yî m̀bâŋnə̀ kə̀ yî màŋgyɛ̀ ǹtsyatə gha aa, kaa à sɨ̀ kuꞌùnə̀ a mbə ŋgàŋyə̀gə̂nnù ghà. ");
INSERT INTO bfd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ŋù yìi mə kaa à sɨ̌ ati abàŋnə̀ bàŋnə̀ yi beꞌè ŋ̀ka nyoŋə nàa aa, kaa à sɨ̀ kuꞌùnə̀ a mbə ŋgàŋyə̀gə̂nnù ghà. ");
INSERT INTO bfd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Ŋù yìi mə a lɔ̀ɔ nlə̀ə ntswêntɨ̀ɨ̂ yì aa, à ka bàŋnə bwɛ, ŋù yìi mə à bwɛ ntswêntɨ̀ɨ̂ yì ǹloŋ ŋgaa yà aa, à ka baŋnə lə̀ə. ");
INSERT INTO bfd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ŋù yìi mə a kwɛrə nɨ̂ ghuu laa, a kwɛrə aa ghâ; ŋù yìi mə a kwɛrə naa laa, a kwɛrə yu wa yìi mə à lɛ ntoo gha aà. ");
INSERT INTO bfd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","“Ŋù yìi mə à kwɛ̀rə ŋgàŋntoò Nwì ǹloŋ mə à nɨ ŋgàŋntoò Nwì aa, à ka ka yǐ kɨɨ kwɛrə mɨ̀tsɔꞌɔnə̀ mɨ ɨfàꞌà mìi à nɨ mi ŋgàŋntoò Nwì aà; ŋù yìi à kwɛ̀rə ŋû yìi mə ànnû yi tsinə nloŋ mə a ghɨ̀rə ɨnnù jìi ɨ tsinə aa, à ka yǐ kwɛrə mɨ̀tsɔꞌɔnə̀ mɨ ɨfàꞌà mìi à nɨ mî ŋû yìi mə ɨ̀nnù ji ɨ tsinə aà. ");
INSERT INTO bfd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Ŋù yìi mə à fa tsiꞌì ǹdɔ̂ŋ ŋ̀kì yî fwɛ̀tə̀ a mbo mûntsìrə̂ ŋù ghû yî mɔ̀ꞌɔ nloŋ mə à nɨ ŋgàŋyə̀gə̂nnù ghà aa, mə̀ swǒŋ tsiꞌì ànnù nɨ̂ŋkoŋ mə kaa à ka yǐ waꞌa mɨ̀tsɔꞌɔnə̀ mɨ ɨfàꞌà mi saà.” ");
INSERT INTO bfd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu à màŋsə̀ mə a ndɨꞌɨtə ŋgǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa, ǹlo ŋkuu ŋghɛɛ ntɨgə ndɨꞌɨ nɨ̂ ɨ̀nnù ŋ̀kɨɨ nswoŋə nɨ̂ ànnù Nwî a mûm ǹjɔꞌɔ ɨlaꞌa jyaa maa kəꞌə̀ àdɨgə̀. ");
INSERT INTO bfd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nòò yìi mə Jɔ̀n Ŋ̀gàŋmùrə bə̌ ŋkì à lɛ ntswe a ndâtsaŋ nyuꞌu ɨnnù tsɨ̀m jìi Kristo à lɛ sɨ ghɨ̀rə̀ aa, ntoo ŋgǎŋyəgə̂nnù ji a mbo Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","M̀betə yi mə, “Ò nɨ yu wa yìi mə à tswe nɨ̂ nzì aa ɛ? Kə̀ bìꞌì ka nyuꞌutə yî dàŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu a kwiꞌi a mbo bo mə, “Nɨ̀ ghɛɛ nswoŋ a annù yìi mə nɨ̀ nyuꞌu ŋkɨ yə aa a mbo Jɔn; ");
INSERT INTO bfd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","mə bɨ̀fə̀ꞌə̀nə̀ bɨ yə ɨ̀dɨgə, bɨ̀bwènkə̀ təə̀, nu ŋgàŋâkɨ̀kwenə ɨ laà, ɨ̀kwotu yuꞌù nɨ̂ ɨnnù, bɨ bɨɨ̀nsə̀ nɨ bɨ̀ku bɨ bə̀ a nɨwo, ŋkɨɨ nswoŋə nɨ̂ ǹtoo yì sɨgɨ̀nə̀ ya a mbô ŋ̀gàŋə̂fumə. ");
INSERT INTO bfd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","M̀bɔɔnə a mbo ŋù yìi mə à sɨ ŋû yìi mə mə̀ nɨ ghu aa jɨ̀ŋkə̀ aà!” ");
INSERT INTO bfd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ŋ̀gǎŋyəgə̂nnù Jɔn jya ɨ màꞌàtə̀ mə̂ ǹlo ŋka ŋghɛɛ aa, Yesu a lɔgɨ̀nə̀ ŋ̀ka nswoŋə a mbo ǹnɔ̀ɔ̀ bə̂ wa ǹloŋə Jɔn mə: “Nɨ̀ lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ wa atu ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ laa a nyə àkə̀? A nyə ŋ̀kɨ̀ŋkàꞌà yìi mə fɨ̀fə̀rə̀ a tsɨ̀gə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nɨ̀ lɛ nnaŋsə mfɛꞌɛ ŋghɛ̀ɛ̀ aa a nyə wò aa ɛ? A nyə ŋù yìi à wɛꞌɛ ɨtsə̀ꞌə̀ nɨfɔ̀ a nu yu aa ɛ? Yə nɨ̀, bə̀ bìi bɨ wɛꞌɛ ɨjǎŋ ɨtsə̀ꞌə̀ ma jya aa, bɨ tswe aa a ntɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nɨ̀ lɛ ntɨgə mfɛꞌɛ ŋghɛ̀ɛ̀ aa a ya aa ɛ? A nyə ŋgàŋntoò Nwì aa ɛ? Ɨ̀ɨ̀ŋə, mə̀ swòŋə a mbo bù mə, nɨ̀ lɛ nyə aa ŋù yìi à tsyàtə ŋgàŋntoo Nwì aà. ");
INSERT INTO bfd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wa àa yu wa yìi bɨ lɛ ŋŋwàꞌànə̀ ǹloŋə yi aà, mə, ‘Yə̂, mə̀ ka too ŋgàŋntoò ghà a mbìi wò, yìi à ka ghɛ̀ɛ nnaŋsə mânjî a mbo wò aà.’ ");
INSERT INTO bfd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mə̀ swoŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, a tɨtɨ̀ɨ bə̀ bɨ̀tsɨ̀m bìi mə bàŋgyɛ̀ bɨ jwe aa, kaa ŋù tsù à sɨ̀ ghu tswê yìi à kɔ̀ꞌɔ̀nə ntsyàtə̀ Jɔn Ŋ̀gàŋmùrə bə̀ a ŋkì; lâ ŋù yìi à kə̀ꞌə nsɨgə nlwiꞌi a mûm ànnù nɨfɔ̀ nɨ aburə aa, à kɔ̀ꞌɔ̀nə ntsyàtə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ǹlɔgɨnə wâ noò yìi mə Jɔn Ŋ̀gàŋmùrə bə̌ ŋkì à lɛ nzì aa, nyi nyweꞌe tsɨ̂tsɔ̀ŋ, ànnù nɨfɔ̀ aburə a yə̀ mə ŋgɨꞌɨ yì ŋ̀ghàꞌàtə̀, bə̀ bî ghàꞌàtə̀ tonə̀ ǹlɔɔ nɨ̂ ŋ̀kuu ghu aa bə nɨ̀ mɨ̀dàꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ǹloŋ mə ŋgǎntoo Nwî tsɨ̀m bo bɨ̀ nɔ̀ŋsə̀ lɛ sɨ tɛꞌɛ nswoŋə aa ànnù ǹloŋ annù nɨfɔ̌ aburə, ŋkɔꞌɔ nyweꞌe a noò Jɔn. ");
INSERT INTO bfd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","M̀bə nɨ ka ŋkɔŋ nyuꞌu ǹtoò yàà ya ɨ bii, tâ nɨ̀ zi mə Jɔn à bə aa Elijah wa mə bɨ lɛ nswoŋ mə à ka yǐ zì aà. ");
INSERT INTO bfd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ŋù yìi à tswe nɨ̂ ɨ̀tônə̀ aa, tâ à yuꞌu. ");
INSERT INTO bfd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“M̀bə mə̀ fɨgɨ̀nə̀ nɨ̀wàà nɨ bə̂ bûlà aa a nɨ̂ àkə̀ lɛ? Nɨ bə aa tsǒ bôŋkhə bìi bɨ tswe a nsaanə mɨtaa ndorə ntwoŋə nɨ bî mɔꞌɔ mə bɨ̀ zi bo bo ka ndorə; ");
INSERT INTO bfd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ǹswoŋə nɨ mə, ‘Bìꞌì lɛ mbuꞌu ɨkòò nɨyɔꞌɔ a mbo bù kaa nɨ̀ waꞌà m̀bènə̂; bìꞌì bû ǹyəꞌə, m̀maꞌa atsàà nɨwo, nɨ̀ tuù m̀biì!’ ");
INSERT INTO bfd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Jɔn à lɛ nzì nsiꞌisə nɨ̂ ɨ̀bɨɨnû yi tɨ jɨ̂, kaa waꞌà nɨ̀ mɨ̀lùꞌù kɨɨ nno, nɨ̀ swoŋ mə, ‘À tswe nɨ̀ demon!’ ");
INSERT INTO bfd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mu ŋù a zî ǹjɨ ŋkɨɨ nno, bə̀ bɨ̀tsɨ̀m swoŋ mə, ‘Nɨ̀ yə a mbâ ghû! Àa lɛɛ̀nàà, m̀bə abàrə mɨlùꞌù, ŋkɨ mbə nsûkàꞌâ ŋ̀gǎŋkwɛrə bɨ̀tax bo bɨ̀ ŋ̀gǎŋghɨ̀rə ɨnnù jî bɨ̂!’ Ka mə a bə laà aa, bɨ zi mɨtsyɛ̀ mɨ Nwî ǹyoŋə nɨ ɨ̀nnù jìi mə a ghɨ̀rə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu à lɛ ntɨgə nlɔgɨnə ŋka ŋwenə bə̂ bìi mə bɨ lɛ ntswe nɨ̂ ǹjɔ̀ꞌɔ alaꞌa jya jìi mə à lɛ ŋghɨ̀rə ɨnnù jî yɛ̌yɛrə jî wè ghu aa, ǹloŋ mə kaa bɨ lɛ ŋwaꞌà mɨ̂ntɨɨ̀ myaa bəŋkə̀ m̀maꞌatə ɨbɨ̂ waa aà. ");
INSERT INTO bfd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ŋwenə nɨ̂ waa nswoŋə nɨ mə, “Ŋ̀gɨꞌɨ yì ŋ̀wè a mbo wò mba Chorazin! Ŋ̀gɨꞌɨ yì ŋ̀wè a mbo wò, Bethsaida! Ǹloŋ mə ɨ̀nnù jî wè jî wè jya mə bɨ ghɨrə a mbo bù aa, bɨ lɛ mbaa ghɨ̀rə̀ aa mbo Tai bo Sidon boŋ bo lɛɛ̀ m̀bəŋ kə mɨ̂ntɨɨ̀ myaa tsiꞌì tɛ̀tɛ̀, ŋ̀wɛꞌɛ ɨtsə̀ꞌə ŋgɨꞌɨ ŋkɨ mfuꞌu atû yaa nɨ̂ àbû. ");
INSERT INTO bfd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","La mə̀ swòŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, àa yǐ bə wa njwî ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa tâ Nwì à ko mɨlə̀ŋnə̀ bə̀ bɨ Tai nɨ̀ Sidon ǹtsyatə ghùù! ");
INSERT INTO bfd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A mbo wò, Kapernaum, ò bə tɛꞌɛ ŋentə ɨbɨɨ nû gho ɨ kɔꞌɔ yweꞌe bə a aburə, boŋ baa yǐ sɨgɨsə gho ɨ màꞌa a bâŋsyɛ̂. Ǹloŋ mə ɨnnù jî wè jî wè jya mə bɨ lɛ ŋghɨ̀rə a nu wò aa, bɨ lɛ mbaa ghɨ̀rə̀ aa a alaꞌa Sodom, boŋ kaa bɨ lɛ ŋwaꞌa yi bwɛsə̀. ");
INSERT INTO bfd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","La mə̀ swoŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə àa yǐ bə wa njwî ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa tâ bɨ̀ ko mɨlə̀ŋnə̀ baSodom ǹtsya ghùù.” ");
INSERT INTO bfd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesu a tɨgə̀ ǹswoŋ maa noò mə, “Mə̀ fâ m̀bɨꞌɨkə a mbo wò, Taà, M̀màꞌambî àburə̀ bô ǹsyɛ, ǹloŋ mə ò lɔ̀ꞌɔ̀sə ɨnnù juà a mbo bə̀ bìi bə tswe nɨ̀ mɨ̀tsyɛ̀ ŋ̀kɨ nzi ɨnnù aà, m̀baŋnə ndɨ̀ꞌɨ̀ a mbo bɔɔ bì bɔrə aà; ");
INSERT INTO bfd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ɨ̀ɨ̀ŋə, Taà ghà, àa àjàŋ yìi mə a lɛ mbɔ̀ŋə̀ gho mə tâ ò ghɨrə aà. ");
INSERT INTO bfd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Taà ghà à fà mə ɨnnù tsɨ̀m a mbo mə̀. Kaa ŋù tsù à sɨ Mu zî, a kɨ nzi tsiꞌì Tà. Kaa ŋù tsù waꞌà Ta kɨ nzi, ntsyatə Mu nɨ ŋù yìi mə Mu à tsɔ̀ꞌɔ mə yu dɨ̀ꞌɨ̀ yi ghu mbo aà. ");
INSERT INTO bfd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nɨ̀ zi a mbo mə̀, bù bɨ tsɨ̀m bìi nɨ nwùgə nû juu nɨ̂ ɨ̀fàꞌà ŋ̀kɨ mbeꞌe ɨbèꞌè jìi mə ɨ dɨ̀rə̀ ghuu aà, boŋ mə̀ ka ghɨ̀rə nɨ̀ fwɛtə. ");
INSERT INTO bfd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nɨ̀ kwɛrə ɨkɔꞌɔ̀ gha nnɨŋ a ntɔŋ bù, ŋka nyəgə nɨ̂ ɨ̀nnù jìi mə mə ghɨ̀rə̀ aà; ǹloŋ mə mə̀ bɔ̀nə ŋkɨɨ nsɨgɨsə nɨ̂ ɨ̀bɨɨ nû gha a nsyɛ aa, boŋ mɨ̀ntɨɨ̀ muu ka fwɛtə. ");
INSERT INTO bfd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ǹloŋ mə ɨ̀kɔ̀ꞌɔ̂ gha ɨ yaŋsə, àbèꞌə̂ ya a kɨ̂ m̀fwaatə aà.” ");
INSERT INTO bfd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tsiꞌì maa nɨ̂ àtɨɨ noò, Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù jɨ lɛ ŋghɛ̀ɛ̀ ŋ̀ka ntsya a mûm ǹsòo ansaŋ a njwîŋgɔ̀ŋ; ǹjì lɛ sɨ yaŋə nɨ̂ ŋ̀gǎŋyəgə̂nnù ji jya, bo lɔgɨ̀nə̀ ŋ̀ka ntɨɨ nɨ̂ ànsaŋ wa yì mɔꞌɔ ŋkurə. ");
INSERT INTO bfd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bɨ kà mə aa ŋghɨrə aa baFarɨsai yə̂ waa, nswoŋ a mbo Yesu mə, “Yə̂, ŋ̀gǎŋyəgə̂nnù jo ɨ ghɨ̀rə annù yìi kaa a sɨ̀ kuꞌùnə̀ a ŋghɨ̀rə a njwîŋgɔ̀ŋ aà!” ");
INSERT INTO bfd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A swoŋ a mbo bo mə, “Nɨ̀ lɛɛ̀ ŋ̀waꞌǎ annù ya mə David à lɛ ŋghɨ̀rə̀ aa twoŋə aa ɛ? Wâ noò yìi mə njì lɛ sɨ yaŋə nii bo bɨ̀ bə̀ bìi bo bo lɛ ntswe aa. ");
INSERT INTO bfd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mə à lɛ ŋkuu a ndânwì bo bɨ̀ bə̀ bi bya ŋkurə àbaa ya mə bɨ lɛ nlə̀ə̀ a mbo Nwì, ka mə nɔ̀ŋsə̀ à lɛ ndɨ̀ꞌɨ mə kaa mbə bo waꞌà kurə aà, ǹloŋ mə a abaa mà yu aa a lɛ sɨ kurə tsiꞌì ŋ̀gǎŋmàꞌa Nwì aà. ");
INSERT INTO bfd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Kə̀ nɨ̀ lɛɛ̀ ŋ̀waꞌà kɨ̀ ǹtwoŋə a mûm àŋwàꞌànə̀ mə, a yi mbə a njwîŋgɔ̀ŋ aa, tsiꞌì ŋgǎŋmàꞌa Nwì ɨ wô nɨ̂ nɔ̂ŋsə̀ la kaa bɨ waꞌà lɔ̀gə̀ nɨ mə bo wò aa annù aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lâ mə swoŋ a mbo bù aa mə wa àyoo yi mɔꞌɔ a tswe faà mə a tsyatə ndâmàꞌanwì. ");
INSERT INTO bfd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nɨ̀ lɛ mbaa kɨɨ zi yuà ànnù mə, ‘Wa mə kɔ̀ŋ aa annǔ ŋko mɨ̀lə̀ŋnə̀ ǹtsyatə a annǔ ntɔ̀ɔ njoo mmàꞌanwì,’ boŋ kaa nɨ sɨ ɨsaꞌa a nu bə̀ bìi bɨ sɨ̌ annù wô aa nɨŋə. ");
INSERT INTO bfd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wa Mu Ŋù à nɨ Mmàꞌàmbi yìi a saꞌa ǹjwîŋɔ̀ŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu a tɨgə̀ mbu nlò ŋ̀ghɛɛ ŋkuu a ndâŋghòtə bo. ");
INSERT INTO bfd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ŋ̀û yì mɔꞌɔ yìi mə àbô yi a lɛ ŋkwo aa, à lɛ ntswe ghu. Bɨ tɨgə̀ m̀betə Yesu mə, “Nɔ̀ŋsə̀ à dɨ̀ꞌɨ mə mbə bɨ ghurə̀ ŋû a njwîŋgɔ̀ŋ aa ɛ?” Bɨ lɛ mbetə laa aa a ŋkwàꞌànə yu tâ tsyà ghu ɨ nɨŋ ɨsaꞌa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu a kwiꞌi mə, “M̀bə ŋù nɨ̀ bù a tswe nɨ̀ m̀bî yì, ɨ wô a mûm nɨ̀bɨrə a njwîŋgɔ̀ŋ, a waꞌà swùŋ m̀fiꞌisə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ŋù à sɨ mbi tsyàtə̀ aa ɛ? Tsǒ mə a bə laa aa, nɔ̀ŋsə à dɨ̀ꞌɨ mə, tâ bìꞌinə̀ ka ŋghɨrə ɨbɔ̀ŋ a njwîŋgɔ̀ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A tɨgə̀ ǹswoŋə a mbo ŋù wa mə àbô yi ya a lɛ ŋkwo aa mə, “Sèntə abô yo yâ.” Ŋù wa à lɛ sèntə abô yi ya a tɨɨ̀ ǹtɨgə mbə tsǒ yi mɔꞌɔ yâ. ");
INSERT INTO bfd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","BaFarɨsai lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ ntɨgə ntaŋə mɨnàŋ a jàŋə mbə bɨ zwitə̀ yi aà. ");
INSERT INTO bfd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu à yùꞌù mə̂ mə bɨ taŋə mɨnàŋ a atu yu aa nlò maa adɨgə ŋghɛɛ yi. Ǹnɔ̀ɔ bə̂ yî ghàꞌàtə̀ ɨ lɛ nyòŋə̀ yi. A ghurə̀ bə̀ bɨ̀tsɨ̀m bìi bɨ lɛ sɨ ghɔ̀ɔ̀ aà, ");
INSERT INTO bfd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ǹswoŋə a mbo bo mə tâ bo tsuu lǒ ghɨ̀rə tâ bə̀ zi. ");
INSERT INTO bfd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","À lɛ ŋghɨ̀rə̀ ma yuà ànnù aa a lwensə ànnù yìi ŋ̀gàŋntoònwì Yesaiah à lɛ nswoŋ aa mə: ");
INSERT INTO bfd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yə̂ nɨ̀, àâ ŋ̀gàŋàfàꞌâ ghà yìi mə mə̀ tsɔ̀ꞌɔ aa à ghuà, yìi mə mə̀ kɔ̀ŋə, ǹtɨɨ̀ gha ɨ kɨɨ ndorɨtə ghu nû aà. Mə̀ ka nɨŋ Azwì ya ghu nû, tâ à ka ŋkɛꞌɛnə annù Nwî yìi mə a zì nɨ̂ ànnù yî tsìnə̀ aa a mbo bɨ̀tɨ̀zî Nwî. ");
INSERT INTO bfd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kaa à ka yi waꞌà bo bɨ̀ bə̀ ka nyɔŋə, kə̀ ka ŋghaa nɨ̂ tɨ̀ɨ̀, kə̀ tâ ŋù tsù à yuꞌu njì yì a mfâŋnə̀; ");
INSERT INTO bfd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kaa à ka yǐ waꞌǎ ŋkɨ̀ŋkàꞌà yìi ɨ yə̀ŋnə aa bəgə̀; kə̌ fəꞌə a lâm yìi a tɨgə mbwɛnə aa ɨ bwɛtə, ǹyweꞌe a noò yìi mə annù a tsinə aa a ka yǐ fɛ̀ꞌɛ laa; ");
INSERT INTO bfd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bɨ̀tɨ̀zî Nwî bɨtsɨ̀m ka yǐ tɨgə tɛꞌɛ atû yaa kɨ bɛ nii.” ");
INSERT INTO bfd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bə̀ bî mɔꞌɔ lɛ nzì nɨ ŋù yìi mə demon à lɛ nghɨ̀rə̀ a fəꞌə̀, kaa a waꞌà kɨ̀ɨ̀ ŋ̀ghaa aa a mbo Yesu mə tâ à ghurə yi. À lɛ ŋghùrə̀ a tɨgə̀ ŋ̀ghaa ŋkɨɨ nyə nɨ̂ ɨ̀dɨ̀gə̀. ");
INSERT INTO bfd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bə̀ bɨ̀tsɨ̀m lɛ nyɛrə nloŋ annù ya yìi à lɛ ŋghɨ̀rə̀ aà. Ǹtɨgə mbetə nɨ mə, “M̀bə a bə mə àa Mu David wa à ghuà aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nòò yìi baFarɨsai lɛ nyuꞌu ma yû ànnù aa, bɨ lɛ ŋkwiꞌi mə, “Mbâ ghû a fiꞌi nɨ bɨ̀demon aa nɨ̂ àdàꞌa Beezebul, mfɔ̀ bɨ̀demon wa.” ");
INSERT INTO bfd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu à lɛ nzi annù yìi mə bo lɛ sɨ mɔ̀ɔ̀ntə̀ aa, ǹswoŋə a mbo bo mə, “Àtoo yìi mə a yatə a akùrə kùrə, ntɨgə nto nɨ̂ waa bo bɨmbɔŋ aa, kaa a ka waꞌà tɨ̀gɨ̀tə̀ a mbwɛ̂. Ǹjɔ̀ꞌɔ̀ àlaꞌa kə̀ ŋ̀gwɛ̀ꞌɛ̀ yìi ɨ̀ kɨ nyàtə̀ ǹtɨgə ntonə bo nɨ bo aa, ɨ̀ ka jàꞌànə̀. ");
INSERT INTO bfd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“M̀bə a bə mə a mûm ànnù nɨfɔ̌ Satan, Satan à tɨ̀gə̂ m̀furə nɨ yì mɔꞌɔ, bəə boŋ ànnù nɨfɔ̌ yi ya a yàtə̀ mə mbɛ̀ɛ̀ ji baa; m̀bə Satan a bû ǹtəə aa mə akə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","M̀bə a bə yìi mə mə fiꞌi nɨ̂ bɨdemon aa nɨ̂ àdàꞌa Beezebul, bəə boŋ bɔɔ̀ buu bàŋnə̀ m̀fiꞌi aa nɨ̀ àdàꞌa wo aa ɛ? Maa ajàŋ tâ ànnù yìi mə bɔɔ̀ buu ghɨ̀rə̀ aa tâ à tɨgə ntsɔꞌɔtə̀ ɨsaꞌà ghuu. ");
INSERT INTO bfd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","M̀bə mə̀ ka mfiꞌi bɨ̂demon aa nɨ̂ àdàꞌa Azwì Nwî, a dɨꞌɨ̀ aa mə ànnù nɨfɔ̀ Nwî à zì mə̂ ǹtswe a tɨtɨ̀ɨ bù. ");
INSERT INTO bfd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Mbə ŋù a kuu mfuꞌu ndâ ǹtɨ̀ɨ̀ ŋù tɨ ghə̂ à foo ntswa ntɨ̀ɨ̀ ŋù wa ŋkwerə aa ɛ? À bə kwerə boŋ à ka bɔ̌ŋ fuꞌu ndâ yì yâ. ");
INSERT INTO bfd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ŋù yìi à sɨ̀ biꞌiyu tswê aa, à bə aa ŋùkɨ̀bàâ ghà, ŋù yìi à sɨ biꞌiyu ghotə aa, a jàꞌà aa jàꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mə̀ swoŋ a mbu bù mə, bɨ ka yǐ lìꞌìnə ɨbɨ̂ tsɨ̀m bo bɨ̀ m̀bə̀gɨ̀tə̀ yìi bə̌ bə̀gɨ̀tə̀ Nwî ghu aa, la kaa bɨ ka yǐ waꞌǎ mbə̀gɨ̀tə̀ yìi bɨ bəgɨtə Azwì Nwî ghu aa lìꞌìnə̀. ");
INSERT INTO bfd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bɨ ka yǐ lìꞌinə ɨbɨ ŋû yìi mə à swòŋə annù yì bɨ a atu Mu Ŋù aà; la kaa bɨ ka yǐ waꞌa ɨbɨ ŋù yìi mə à swòŋə annù a atu Azwì yî Làà aa lìꞌìnə̀, kə̀ bə fàa mbi, kə̀ nɨ̂ m̀bi yìi ɨ̀ ka bǔ yǐ zì aà. ");
INSERT INTO bfd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ghìrə tâ àtì tâ à bɔŋ, tǎ tâ mɨ̀ntà mi kɨ mbɔŋə; kə̀ ò ghɨrə̀ àtì ya a bɨꞌɨ, mɨ̀ntâ mi kɨ̂ m̀bɨꞌɨ; ǹloŋ mə bɨ zi ati nyoŋə aa nɨ mɨ̀ntà mìi mə a koonə aà. ");
INSERT INTO bfd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Bǔ bɔɔ bɨ nô! M̀bə nɨ̀ kâ ŋ̀ghaa ɨnnù jî sɨgɨ̀nə̀ aa mə akə tsǒ mə nɨ̀ bə aa bə̀ bî bɨ aa ɛ? Ŋǔ ghàà aa ànnù yìi a luu ghu ntɨɨ aà. ");
INSERT INTO bfd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋù yî ǹsɨgɨ̀nə̀ a fiꞌisə aa ɨ̀nnù jî sɨgɨnə̀ jìi ɨ lò nɨ̂ àtǎ ɨnnù ji jî sɨgɨ̀nə̀ jya aà, ŋù yì m̀bɨ a kɨɨ̀ m̀fiꞌisə aa ɨnnù jì bɨ jìi ɨ lò nɨ̂ àtǎ ɨnnù jî bɨ ji jya aà. ");
INSERT INTO bfd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mə̀ swoŋ a mbo bù mə, à ka yǐ bə wa njwî ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa tâ ŋù ǹtsɨ̀m à swoŋə annù ǹloŋ mɨghàà mɨ adàŋə̀ dàŋə̀ mɨtsɨ̀m mìi à lɛɛ̀ ŋ̀ghaa aà. ");
INSERT INTO bfd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bɨ ka yǐ lɔ̀gə̀ aa mɨ̀ghàâ muu ɨ tsɔꞌɔtə mɨsaꞌà muu ghu. A ka yǐ ghɨ̀rə̀ mɨghàa muu mə tâ nɨ̀ jɨ ɨsaꞌa kə̀ ŋ̀kɨ ŋwo ɨsaꞌà.” ");
INSERT INTO bfd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ŋ̀gǎŋndɨ̀ꞌi ɨ̀nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai bî mɔꞌɔ lɛ ntɨgə mbu nswoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨ̀nnù, bìꞌi lɔ̀ɔ̀ mə tâ ò ghɨrə alènsə̀ bìꞌì yə.” ");
INSERT INTO bfd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A kwiꞌi a mbo bo mə, “Àa tsiꞌì nɨ̀wàà nɨ bə̂ bìi bɨ ghɨ̀rə ɨbɨ ŋkɨ mmeꞌe Nwî aa mə bɨ lɔ̀ɔ̀ ɨlènsə̀; la kaa mbə bɨ waꞌǎ alènsə̀ a mbo bo fa ntsyatə ya nloŋ ŋgàŋntoò Nwì Jona. ");
INSERT INTO bfd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tsǒ àjàŋ yìi mə Jona à lɛ ntswe njwi ji tarə, nɨtugə nɨ̀ àsìꞌìnə̀, fya mum àtòꞌo fɨ̀bwɛ̀ fî wè fya aa, àa ajàŋ mə Mu Ŋù à ka yǐ kɨɨ tswe njwi ji tarə, nɨ̂tugə nɨ̀ àsìꞌìnə̀, a nɨbǔm nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Àa yǐ bə a njwî ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa tâ baNineveh bɨɨnə nnɨŋ ɨsaꞌa a nu bù, nɨ̀wàà nɨ mbi nulà, ǹloŋ mə bo lɛ nyuꞌu annù Nwî yìi mə Jona à lɛ nswoŋ aa mbəŋkə mɨ̂ntɨɨ̀ myaa, mmeꞌe ɨbɨ̂ waa. La tsɨtsɔ̀ŋ, àyoo yǐ mɔꞌɔ yìi a tsyatə Jona aa, a tswe faà! ");
INSERT INTO bfd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Àa yǐ bə a njwi ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa tâ m̀fɔ̀ màŋgyɛ̀ yìi mə à lǒ a Sheha aa, tâ à bɨɨnə bo bɨ̀ nɨ̀wàà nɨ bə̂ bulà ǹnɨŋ ɨsaꞌa a nu bo; ǹloŋ mə à lɛ nlǒ a alaꞌa yu ǹzi a nyuꞌu annù ǹloŋ mɨtsyɛ̀ mɨ Solomon aà. Lâ tsɨtsɔ̀ŋ àyoo yǐ mɔꞌɔ a tswe faà mə a tsyatə Solomon! ");
INSERT INTO bfd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Àzwì yî bɨ a yi mfɛ̀ꞌɛ̀ a nu ŋù aa a, təə̀ ŋ̀karə a ɨdɨgə jìi mə kaa ŋ̀kì sɨ̀ ghu tswe aa, ǹlɔɔ nɨ̂ àfwɛtə̀ kaa waꞌà yə̂. ");
INSERT INTO bfd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ǹtɨgə nswoŋ mə, ‘Mə̀ ka bɨɨ ghɛ̀ɛ̀ wa nda mə mə̀ ghɨ̀rə mfɛ̀ꞌɛ̀ ghu aà.’ A bu mbɨɨ nyə nda ya ɨ tswe ŋɛꞌɛ, bɨ yɛꞌɛ ŋkɨ naŋsə ntaŋntə, ");
INSERT INTO bfd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","boŋ à ka bǔ ghɛ̀ɛ ɨ lɔ̀ɔ ɨzwì jî mɔꞌɔ ji sàmbaa, jìi ɨ bɨꞌɨ ǹtsyàtə yi aa, tâ bo bo yi ŋkuu ntswe wa ndâ. Bɛɛ a ghɨrə laa, ànnù ŋû wa a tɨgə̀ m̀bɨꞌɨ ntsyatə ajàŋ yìi a lɛ mbə a mbìì aà. Àa ajàŋ yìi a ka yǐ kɨɨ fɛ̀ꞌɛ̀ a nu nɨ̀wàà nɨ bə̂ bî bɨ nulà aà.” ");
INSERT INTO bfd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nòò yìi mə Yesu à lɛ mburə ka kɨ ghàà bo bɨ̀ bə̀ bya aa, ǹdè yì bo bɨ̀ bɔɔ bɨmaà yì lɛ nzì, ǹtəə a abɛɛ, ǹlɔɔ nɨ mə tâ à zi bo bo ghaanə.  ");
INSERT INTO bfd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ŋù wa yì mɔ̀ꞌɔ à lɛ ntɨgə nswoŋ ghu mbo mə, “Yə̂, ǹdè gho bo bɨ̀ bɔɔ bɨmaà ghò təə a abɛɛ, nlɔɔ nɨ mə bǔ bo ghaanə.” ");
INSERT INTO bfd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A kwiꞌi ghu mbo mə, “Ǹdè ghà aa wò aa ɛ? Bɔɔ bɨmaà aa bɨ̀wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ǹtɨgə nnansə abô yi, ǹdɨꞌɨ ŋgǎŋyəgə̂nnù ji nswoŋ mə, “Àâ ǹdè ghà bo bɨ̀ bɔɔ bɨmaà ba bɨ buà! ");
INSERT INTO bfd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ŋù ǹtsɨ̀m yìi mə a ghɨ̀rə annù yìi mə Taà ghà a aburə a lɔ̀ɔ̀ aa, àa mumaà yî m̀bâŋnə̀, nɨ yì màŋgyɛ̀, nɨ ǹdè ghà.” ");
INSERT INTO bfd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tsiꞌi maa njwi, Yesu à lɛ mfɛ̀ꞌɛ a nda ŋghɛ̀ɛ̀ ǹtswe a mbɛ̀ɛ̀ àghəŋə ŋkì mɨyaa, ");
INSERT INTO bfd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ǹnɔ̀ɔ̀ bə̂ a kùrə kùrə̀ ɨ lɛ ŋghotə ŋkarɨsə yi. A tɨgə̀ ǹlɔgə akànuꞌu ŋkuu ghu ntswe a mûm ŋ̀kì. Ǹnɔ̀ɔ̀ bə̂ wa ɨ bâŋnə̀ ntəə wa aghəŋə ŋkì. ");
INSERT INTO bfd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A lɔgɨ̀nə̀ ǹnaa ɨnnù jî ghàꞌàtə a mbo bo a nɨ mɨ̀ghàà mî nǎnaa. Ǹswoŋə nɨ mə, “Ŋ̀gàŋmàꞌa ǹjoo, à lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ a màꞌa ǹjoo yu. ");
INSERT INTO bfd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","À kà mə aa mmaꞌa njoo jya aa, m̀bum njoo jya jǐ mɔꞌɔ ɨ wô a ndômânjì. Bɨ̀sɨŋ zî m̀bwɛɛntə. ");
INSERT INTO bfd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jǐ mɔꞌɔ ɨ wô a atû àlâŋsə ŋgɔ̀ꞌɔ̀ yìi mə ǹsyɛ̂ ɨ̀ lɛ mbɔɔ ntswe ghu tsiꞌǐ muntsirə̂. Ɨ waŋsə̀ ǹtoo ŋkɔꞌɔ nloŋ mə kaa mânjì yìi mə mbə mɨ̀ŋgǎŋ mi kuu a nsyɛ aa kaa à lɛ ŋwaꞌà bə̂ aà. ");
INSERT INTO bfd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lâ àjàŋə mə nòò yî ǹtɨ̀nsə̀ à lɛ nta aa, à lɛ ntɔɔ njoo jyâ. Tsǒ mə ɨ lɛ ŋwaꞌà nɨ mɨ̀ŋgàŋ tswê aa ɨ ghɛ̂nsə̀ ǹyoo yi. ");
INSERT INTO bfd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jǐ mɔꞌɔ ɨ lɛ ŋwò a tɨtɨ̀ɨ bɨ̀kə̀rə̀ kərə. Bɨ̀kə̀rə̀ kərə bya kwe nzwitə njoo jyâ. ");
INSERT INTO bfd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jǐ mɔꞌɔ ɨ wô nɨ̂ àbwènə nsyɛ yì sɨgɨ̀nə̀. Ǹtɨgə ŋkwe, ntɨgə mbaa, jǐ mɔꞌɔ ɨ baa ansaŋ ŋkhɨ̀ yî fùùrə̀, jǐ mɔꞌɔ ɨ baa mɨ̀ghum mi ntoꞌo, jǐ mɔꞌɔ ɨ baa mɨ̀ghum mi ntarə̂. ");
INSERT INTO bfd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ŋù yìi à tswe nɨ̂ àtoŋnə̀ aa, tâ à yuꞌu.” ");
INSERT INTO bfd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ŋ̀gǎŋyəgə̂nnù ji ɨ lɛ nzì ghu mbo mbetə yi mə, “O ghàa a mbo bo nɨ mɨ̀ghàà mî nǎnaa aa aya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu a kwiꞌi a mbo bo mə, “Nwì à fa mɨ̀tsyɛ̀ a mbo bù mə tâ nɨ̀ zi ɨnnù jî lɔ̀ꞌɔ̀sə̀ ǹloŋə annù nɨfɔ̌ aburə. La, kaa waꞌà a mbo bo fâ. ");
INSERT INTO bfd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ǹloŋ mə a mbo ŋù yìi à tswe nɨ yu aa, bɨ ka kùꞌùsə̀ ta tâ à tswe nɨ ju ɨ̀ ghaꞌatə. Lâ a mbo ŋù yìi à sɨ̀ nɨ yu tswe aa, tsiꞌì mû àtɨɨ yìi à tswe nɨ yu aa, bɨ ka kwɛrə. ");
INSERT INTO bfd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A bə ǹjiꞌì ànnù yìi mə mə ghàà nɨ a mbo bo nɨ mɨ̀ghàà mî nǎnaa aà. Ta tâ bo naŋsə ŋka nlii nlìì kaa waꞌà yə̂. Ǹnaŋsə ŋka nyuꞌutə nyuꞌutə kaa waꞌà yuꞌù tâ àtû yaa a laa ghu. ");
INSERT INTO bfd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tǎ tâ à lwensə annù yìi mə ŋgàŋntoò Nwì Yesaiah à lɛ nswoŋ nloŋ ŋgaà yàà aa mə, ‘Nɨ̀ ka yǐ kɨ naŋsə yuꞌu lâ kaa atû yuu waꞌa ghu ka nlaa, ɨ kɨɨ kɨ naŋsə yə kaa tâ miꞌì muu waꞌa ghu laà. ");
INSERT INTO bfd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ǹloŋ mə mɨntɨɨ mɨ bə̂ bû luu nɨ̂ àjɨ̀ŋtə̀. Bɨ jesə̀ ɨ̀tôŋnə̀ jyaa kaa bo waꞌà nɨ̀ ɨ̀nnù bû ǹyuꞌu. Ŋ̀kɨ ŋkusə miꞌì myaa mbɨ̀ꞌɨ̀ bo lô ǹyə nɨ miꞌì myaa, ŋ̀kɨ yuꞌu nɨ̂ ɨ̀tôŋnə̂ jyaa, ŋkɨ nyuꞌu mɨ̀ntɨɨ̀ myaa laa ghu, mbəŋkə waa, ǹzi a mbo mə̀, mə̀ ghurə̀ waa.’ ");
INSERT INTO bfd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Lâ, m̀bɔɔnə a mbo bù nloŋ mə miꞌì muu mɨ yə ɨdɨgə, ɨ̀tôŋnə̀ juu ɨ yuꞌù nɨ̂ ɨ̀nnù aà. ");
INSERT INTO bfd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə ŋ̀gǎŋntoo Nwî jî ghàꞌàtə̀ bo bɨ̀ bə̀ bìi mə annù yaa a tsinə aa bo lɛ sɨ yə̀ꞌə̀tə̀ nɨ a nyə̂ ànnù yìi nɨ yə aa, lâ kaa ŋkɨꞌɨ̀ yə̂. Ǹyəꞌətə nɨ a nyuꞌu ànnù yìi nɨ yuꞌu aa la ŋkaa ŋkɨꞌɨ̀ yuꞌù. ");
INSERT INTO bfd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nɨ̀ naŋsə nyuꞌutə la nyəgə annù yìi mə nɨ̀ghàà nî nǎnaa nloŋ ŋgàŋmàꞌâ ǹjoo ghù swoŋə aà. ");
INSERT INTO bfd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bə̀ bìi mə bɨ yuꞌu nɨghàà nloŋ annù nɨfɔ̀ Nwî kaa nɨ waꞌǎ nɨ a atu bo laa, ŋu yì mbɨ wa a ghɛ̂nsə̀ ǹzi nswà nɨ a mbo bo ŋghɛɛ nɨ nu aa, bɨ bə aa tsiꞌì tsǒ mbǔm njoo jya mə ɨ lɛ ŋwò wa ndômânjì aà. ");
INSERT INTO bfd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","M̀bùm jya jìi ɨ lɛ ŋwò a atû àlâŋsə ŋgɔ̀ꞌɔ̀ aa, ɨ bə aa tsiꞌì tsǒ bə̀ bìi mə bɨ yuꞌu nɨghàà nɨ Nwì ŋ̀waŋsə ŋkwɛrə nɨ nɨ̀dorə̀. ");
INSERT INTO bfd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lâ kaa nɨ waꞌà mɨ̂ŋgàŋ mi a nu bo twiŋə̀, bo bɔɔ̀ ǹtswa ntugɨtə tsiꞌì a nɨ mû àtɨɨ noò. Ŋ̀gɨꞌɨ ɨ yi ŋghɛ̀nsə̀ ghə̀ə kɨ zì ǹloŋ nɨghàà nɨ Nwî nya, kə̀ bɛɛ bɨ tɨ tsɔꞌɔ àkòrə̂ yaa aa, bo burə̀ m̀maꞌatə ŋkhə̀. ");
INSERT INTO bfd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","M̀bǔm njoo jya jìi ɨ lɛ ŋwò wa mûm bɨ̀kə̀rə̀ kərə aa, ɨ təə a atu bə̀ bìi mə bɨ yi nyuꞌu ntoo yì ǹsɨgɨ̀nə̀ ya, ànnǔ ŋka nwùgə nu nloŋ ntswêntɨ̀ɨ̂ yàà kə̀ ànnǔ ŋka ŋkɔ̌ŋ ŋ̀kabə, a fumsə̀ àzwǐ ntoo yì ǹsɨgɨ̀nə̀ ya, kaa bo waꞌà mɨ̂ntà koonə̀. ");
INSERT INTO bfd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","M̀bǔm njoo jya jìi ɨ lɛ ŋwò wa abwenə nsyɛ yì sɨgɨ̀nə̀ yaa, ɨ təə aa a atu bə̀ bìi bɨ yuꞌu ntoo yì ǹsɨgɨ̀nə̀ ya ɨ laa a atu bo, bo tɨgə̀ ŋ̀koonə mɨ̂ntà, bǐ mɔꞌɔ, ŋ̀khɨ̀ yî fùùrə̀, bǐ mɔꞌɔ, mɨ̀ghum mi ntoꞌo, bǐ mɔꞌɔ, mɨ̀ghum mi ntarə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu à lɛ ŋkùꞌùsə̀ naa nɨghàà nî nǎnaa a mbo bo mə, “Ànnù nɨfɔ̌ aburə a bə aa laà mə: Ŋù yì mɔ̀ꞌɔ à lɛ mbweꞌe nsoo mɨkuù yi. ");
INSERT INTO bfd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","À bə̀ mə̂ nɨ̂tugə a noò yìi bə̀ bwiiŋkə aa, ŋ̀gàŋkɨ̀bàâ yì a ŋeꞌesə̀ ǹzi mmàꞌà bɨ̂nə̀ghə̀ ghu ŋghɛɛ yi. ");
INSERT INTO bfd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nòo yìi mə mɨkuu mya mɨ lɛ ŋka ŋkwi aa, nòò ŋ̀kòònə a kuꞌù aa, ŋ̀gwen ya ɨ kɨ̂ ŋ̀kɔꞌɔ tsǒ mɨ̀kuu myâ. ");
INSERT INTO bfd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ŋ̀gǎŋəfàꞌà ŋû wa ɨ lɛ nzì m̀betə yi mə, ‘Taà, ò lɛ mbwiꞌi aa mɨ̀kuu mì sɨgɨ̀nə̀ fàa mûm ǹsòò, bɨ̀nə̀ghə̀ bû ǹtɨgə nlo aa a fə ghu aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A kwiꞌi a mbo bo mə, ‘Wa ma yû ànnù aa a ghɨ̀rə̂ ŋ̀gàŋkɨ̀bàà.’ Bo betə̀ yi mə, ‘Bìꞌì ghɛɛ ndwèn bɨ̂nə̀ghə̀ bya aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A kwiꞌi a mbo bo mə, ‘Ŋ̀gaŋ, nɨ̀ tsuu ghɛ̀ɛ̀, ǹloŋ mə m̀bə nɨ̀ ghɛɛ̀ ŋ̀ka ndwenə, ndùntə̀ mɨkuu mya mi mɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nɨ̀ maꞌatə tâ mɨ̀kuu mya bo bɨ̀ bɨ̀nə̀ghə̀ bya ka ŋkwe, nyweꞌe a noò ŋ̀kyâ. Boŋ mə̀ ka swoŋ a mbo ŋgàŋəfàꞌâ jya mə, tâ bo foo ntsyǎ mbìì ǹdwen bɨ̂nə̀ghə̀ bya ŋkwerə a nɨbɨ̂ŋə̀ nɨbɨŋ, ntɔ̀ɔ̀, m̀baŋnə ŋkya mɨkuu mya nnɨŋ a atǎ mə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu a bû ǹnaa nɨghàà nî nǎnaa a mbo bo mə, “Ànnù nɨfɔ̌ aburə a bə aa tsiꞌì tsǒ abùrə mâghum yìi mə ŋù à lɛ nlɔ̀gə̀ m̀bweꞌe a mûm ǹsòo yu. ");
INSERT INTO bfd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Àbùrə̀ ma yû, à nɨ fɨ̀ntà fî mɔꞌɔ fìi fɨ kəꞌə nsɨgə nlwiꞌisə. Lâ fɨ yi ntoo aa, fɨ kwe ntɨgə mbə ati yìi mə a faŋ ntsyatə ɨti tsɨ̀m aà, bɨsɨŋ tɨgə̀ ŋ̀ghurə nɨ̂ ǹdâ jya ghu.” ");
INSERT INTO bfd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu a kuꞌùsə̀ m̀bu nnaa nɨghàà nî nǎnaa a mbo bo nswoŋ mə, “Ànnù nɨfɔ̌ aburə a bə aa lâlà: Màŋgyɛ̀ à lɛ nlɔ̀gə̀ a mûŋkùgə̀ m̀bɛ̀ꞌɛ̀ àbaa, nnɨŋ a nɨ̂ àkaŋ abaà, a tɨgə̀ m̀morə ŋkɔꞌɔ nluu ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu à lɛ nlɔgə aa mɨ̀ghàà mî nǎnaa ndɨꞌɨ nɨ̂ ɨ̀nnù ma jû ghu a mbo nnɔ̀ɔ̀ bə̂ byâ. Kaa à lɛ ŋkɨꞌɨ annǔ tsu dɨꞌɨ̀ tɨ ghə̂ mə à nàa a nɨ nɨ̀ghàà. ");
INSERT INTO bfd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ma yû a lɛ nlwensə aa nɨ̀ghàà nìi mə ŋ̀gàŋntoò Nwì à lɛ nswoŋ aa mə, “Màa ŋaꞌa ntsû gha a nɨ mɨ̀ghàà mî nǎnaa, ɨ swoŋ ɨnnù jìi ɨ lɛ ntswe a alɔ̀ꞌɔ̀sə̀, ǹlɔgɨnə a noò ǹnàŋsə̂ m̀bi aà.” ");
INSERT INTO bfd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu à lɛ mmàꞌàtə nnɔ̀ɔ̀ wa ntɨgə mbu mbɨɨ fu a ndâ. Ŋ̀gǎŋyəgə̂nnù ji ɨ zî ghu mbɛ̀ɛ̀ ǹzi nswoŋ ghu mbo mə, “Tɔꞌɔtə njiꞌì nɨ̀ghàà nî nǎnaa nloŋ ŋgwen ya a mbo bìꞌì.” ");
INSERT INTO bfd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A kwiꞌi a mbo bo mə, “Ŋù yìi mə a bweꞌe mɨkuu mya aa à laa mbə Mu Ŋù. ");
INSERT INTO bfd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ǹsòò wa a bə m̀bi yù. Mɨ̀kuu mya, a bə bə̀ bɨ annù nɨfɔ̀ Nwî. Ŋ̀gwen ya a bə bə̀ bɨ ŋû yî m̀bɨ wâ. ");
INSERT INTO bfd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ŋ̀gàŋkɨ̀bàà wa mə a bweꞌe waa laa, a bə Devil. Nòò m̀fùꞌu mɨ̀jɨ wa, a bə nòò ǹlwìꞌî m̀bî. Bɨ̀fùꞌù bɨ mɨjɨ bya, a bə baangel. ");
INSERT INTO bfd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tsiꞌì tsǒ ajàŋ mə bɨ lɛ ndwèn bɨ̂nə̀ghə̀ bya ŋkwerə ntɔɔ aa, àâ àjàŋ mə a ka yǐ kɨɨ bə a nlwìꞌî m̀bî aà. ");
INSERT INTO bfd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mu Ŋù à ka yǐ too baangel bi tâ bɨ̀ ghɛɛ a mûm ànnù nɨfɔ̂ yi, m̀fiꞌi bə̂ bìi bɨ ghɨ̀rə bə̀ bî mɔꞌɔ bɨ ghɨrə̀ nɨ̀ ɨ̀nnù jì bɨ aa tsiꞌì bɨtsɨ̀m, bo bɨ̀ ŋ̀gǎŋmbùꞌu ɨnnù, ");
INSERT INTO bfd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tâ bɨ̀ maꞌa waa a mum mɔꞌɔ yî tɨ̀ɨ̀ ntɨɨ wa, tâ bo tɨgə nyəꞌə ŋkurə nɨ mɨ̀sɔ̀ŋə̂ myaa, ");
INSERT INTO bfd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","tâ bə̀ bìi ɨnnû jyaa ɨ tsinə aa bɨ̀ baŋnə ŋka nta tsiꞌì tsǒ nɨ̀nòò a mûm ànnù nɨfɔ̌ Taà wàà. Ŋù yìi à tswe nɨ̂ ɨ̀tôŋnə̀ aa tâ à yuꞌu. ");
INSERT INTO bfd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ànnù nɨfɔ̌ aburə a bə aa lâlà: Ŋù yì mɔ̀ꞌɔ à lɛ ŋghɛ̀ɛ̀ m̀fɛꞌɛ nɨ àfùꞌù a nɨ nsòò yî mɔꞌɔ. M̀bɔɔ mbɔɔntə fu, ǹnaŋsə nluu nɨ nɨ̀dorə, ŋghɛ̀ɛ̀ ŋ̀ghɛɛ mfèe ŋgɔ̀ŋ ǹjoò tsɨ̀m jìi à tswe nɨ juu aa, ŋghɛɛ nyuu nsoo wâ. ");
INSERT INTO bfd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“M̀bə bɨ kɨ̂ m̀bu mfɨ̀gɨ̀nə annù nɨfɔ̀ aburə lâlà: Ŋù ǹtaŋmɨ̀tàà yî mɔ̀ꞌɔ à lɛ ŋka nlɔɔ a ayoo tɨ̀ndùù, ");
INSERT INTO bfd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","à ghɛ̀ɛ̀ mə̂ ǹyə â yìi a lɛ naŋsə mbɔŋ a nu yu, ŋghɛɛ mfèe njoò ji tsɨ̀m, ŋ̀ghɛɛ nyuu ghu. ");
INSERT INTO bfd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“M̀bə bɨ bû m̀fɨgɨnə annù nɨfɔ̀ aburə aa laà mə: A bə aa tsiꞌì tsǒ fɨ̀lwàꞌà fìi mə ŋgǎŋkô m̀bwɛ̀ ɨ màꞌa a ŋkì, ŋ̀ko mbwɛ̀ ghu a mbuu, mbuù. ");
INSERT INTO bfd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nòò yìi mə fɨluu aa, bo swûŋ m̀fɛꞌɛsə a ŋkì, ǹyarə mbwɛ̀ mî sɨgɨ̀nə̀ mya nnɨŋə a mûm ǹjoo bo, ǹtɨgə mmeꞌe mî bɨ myâ. ");
INSERT INTO bfd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Àâ àjàŋə mə a ka yǐ kɨɨ bə a nlwìꞌî m̀bi aà. Baangel ka yǐ fɛ̀ꞌɛ ɨ ghɛɛ yàrə̀ bə̂ bî bɨ fiꞌisə a tɨtɨ̀ɨ bə̀ bìi mə annù yaa a tsinə aa, ");
INSERT INTO bfd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ɨ màꞌà waa wa mum mɔꞌɔ yî tɨ̀ɨ̀ wa, tâ bo tɨgə nyəꞌə ghu, ŋkurə nɨ mɨ̀sɔ̀ŋə̂ myaa. ");
INSERT INTO bfd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Nɨ̀ yuꞌù ɨ̀nnù jû ɨ̀ tsɨ̀m aa, ɨ̀tû juu ɨ laa ghu aa ɛ?” Bo bii ghu mbo mə, “Ɨ̀ɨ̀ŋə.” ");
INSERT INTO bfd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A tɨgə̀ ǹswoŋ a mbo bo mə, “Tsǒ mə a bə laa, ŋùndɨꞌɨ bɨ̀nɔ̀ŋsə ntsɨ̀m yìi mə bɨ mɨrɨsə a nɨ ànnù nɨfɔ̀ aburə aa, à bə̀ aa tsiꞌì tsǒ m̀bɔ̂ŋndùgə̀ yìi mə a fiꞌisə njoo jì fii bo bɨ̀ jì lwèn a atǎ yu.” ");
INSERT INTO bfd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Àjàŋ mə Yesu à lɛ màŋsə̀ mɨghàà mî nǎnaa ma mû aa, à lɛ mmàꞌàtə̀ ŋ̀ghɛɛ. ");
INSERT INTO bfd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","À ghɛ̀ɛ̀ mə̂ ǹyweꞌe a alaꞌa bo, ŋ̀kuu a ndâŋ̀ghòtə, ǹdɨꞌɨ annù ghu. Ànnù a ghaꞌa bə̀ bya, bo tɨgə̀ m̀betə nɨ mə, “Ŋù ghû à nàŋsə nlɔ̀gə̀ mulà mɨ̀tsyɛ̀ bo bɨ̀ ɨ̀nnù jî wè juà aa a fə? ");
INSERT INTO bfd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","À sɨ mu kabindà wa à ghuà bə aa ɛ? Bɨ sɨ a ndè yì aa a nɨ Mary twoŋə lɛ? Jɛms, Joseph, nɨ Simon, nɨ Yuda, à sɨ bɔɔ bɨmaà bi bə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bɨ̀jààntə̂ bi bɨ sɨ̀ a tɨtɨ̀ɨ bìꞌinə̀ tswê aa ɛ? Ŋù ghû a tɨgə̀ ǹlɔgə mbuu ɨnnù jû aa a fə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mɨ̀ntɔ̀ŋə̂ myaa lɛ nlwìnə̀ ghu nû. Lâ Yesu a swoŋ a mbo bo mə, “Bɨ ghuꞌusə ŋgàŋntoo Nwì a ɨdɨgə tsɨ̀m lâ kaa waꞌà nìi a alaꞌa bo kə̌ a nda bo ghuꞌusə̀. ");
INSERT INTO bfd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kaa à lɛ ŋkɨꞌɨ ɨnnù jî wè jî wè jî ghàꞌàtə̀ ghu bû ŋ̀ghɨrə, ǹloŋ mə kaa bo lɛ ŋwaꞌà nɨ̂ àbìintɨɨ tswê aà.” ");
INSERT INTO bfd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A bə maa noò Herod yìi à lɛ mbə mfɔ̀, nsaꞌa nɨ̂ m̀bùꞌu Galilea aa, a yuꞌù ànnù ǹloŋ ɨkum Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ǹtɨgə nswoŋ a mbo ɨ̀tsendâ jì mə, “Wa à nɨ Jɔn Ŋ̀gàŋmùrə bə̌ ŋkì mə bɨ bu nyweensə nɨ nɨ̀wô. A bə̂ ǹjiꞌì ànnù yìi mə mɨ̀dàꞌà muà mɨ fàꞌà ghu nu aà.” ");
INSERT INTO bfd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ǹloŋ mə à lɛ tɨ bə maa noò aa boŋ Herod à bàŋnə̀ mə̂ Jɔn ŋkwerə yi, nnɨŋ yi a ndâtsaŋ, mbɨꞌɨ ŋgaa Herodias, ŋgwɛ ndɨ̂m yì Philip. ");
INSERT INTO bfd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ǹloŋ mə Jɔn à lɛ sɨ ghɛ̀ɛ̀ ghu mbo nswoŋə nɨ mə, “Kaa a sɨ̀ kuꞌùnə̀ a mbo wò a nyɔꞌɔ màŋgyɛ̀ ghû.” ");
INSERT INTO bfd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ka mə à lɛ sɨ lɔ̀ɔ mə boŋ yu zwitə Jɔn aa, à lɛ mbɔꞌɔ miꞌi mɨ bə̂ bya nloŋ mə bɨ lɛ bii mə Jɔn à nɨ̂ ŋ̀gàŋntoò Nwì aà. ");
INSERT INTO bfd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lâ nòò yìi mə ǹjwî ǹjwe Herodias ɨ̀ lɛ mbòòntə̀ aa, mu Herodias yî màŋgyɛ̀ à lɛ naŋsə nzi mben ɨkòò a nsi bə̀ bìi bɨ lɛ twoŋə waa aà. Ǹtɨɨ Herod ɨ dorɨtə̀. ");
INSERT INTO bfd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A tɨgə̀ ŋ̀kaa, ŋkaꞌa mə yu ka fa a ayoo yìi mə à bètə aà. ");
INSERT INTO bfd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ǹdè yì a tintə̀ yi, ǹswoŋ mə tâ à swoŋ a mbo Herod mə, “Fa a atu Jɔn Ŋ̀gàŋmùrə bə̌ ŋkì a mbo mə̀ a mûm àkaŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nû m̀fɔ̀ wa ɨ lɛ mbɨꞌɨ tsiꞌì nɨ̂ m̀bə̂ ànnù. Lâ àjàŋ mə à lɛ ŋkaa a nsi miꞌi bə̀ aa, à lɛ nswoŋ mə tâ bɨ̀ fa. ");
INSERT INTO bfd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","À lɛ ntoo bə̂ bɨ ghɛɛ̀ ŋ̀kwyɛ atu Jɔn wa ndâtsaŋ, ");
INSERT INTO bfd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ǹlɔgə atu ya nnɨŋ wa mûm àkaŋ, mfa a mbo mûmàŋgyɛ̀ wa a ghɛɛ̀ m̀fa a mbô ǹdè yì. ");
INSERT INTO bfd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ŋ̀gǎŋyəgə̂nnù Jɔn ɨ lɛ nyuꞌu, ŋghɛɛ nlɔ̀gə akû yi ŋghɛɛ ntwiŋ, ntɨgə ŋghɛɛ ŋkɛ̀ꞌɛ̀nə̀ a mbo Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nòò yìi mə Yesu à lɛ nyuꞌu ma yû ànnù ǹloŋ Jɔn aa, à lɛ mmàꞌàtə̀ adɨgə ma ya ŋkuu a mûm àkànuꞌu ŋghɛɛ a adɨgə yi mɔꞌɔ yìi bə̀ sɨ̀ ghu tswe aa, mə yu tswe ghu tsiꞌì yùyù. Nòò yìi mə nnɔ̀ɔ̀ bə̂ wa lɛ nyuꞌu maa ajàŋ aa, bɨ lɛ mfɛ̀ꞌɛ̀kə a njɔ̀ꞌɔ ɨlaꞌa jyaa ntəə nɨ mɨ̀kòrə̀ ǹyoŋə yi ghu. ");
INSERT INTO bfd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu à ghə̀ mə̂ mə yu kɨ fɛ̀ꞌɛ̀ wa a mûm àkànuꞌu, nyə nnɔ̀ɔ̀ bə̂ wâ. Ǹtɨɨ̀ yi ɨ luu nɨ̀ àjəŋnə̀ ǹloŋ ŋgaà yàà. A tɨgə̀ ŋ̀ghurə ŋgàŋmɨghɔ̀ɔ̀ a tɨtɨ̀ɨ bo. ");
INSERT INTO bfd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","À bə̀ mə a ŋkwɛ̂fɔ̀ tsiꞌì maa njwi, ŋgǎŋgyəgə̂nnù ji ɨ zî ǹswoŋ ghu mbo mə, “Wa nòò à tɨgə̀ ǹtsya, àdɨ̀gə̀ yû a kɨ̂ m̀bə àfumnə adɨgə. Ghɨ̀rə tâ bə̀ bû sɛɛnə mə mbə bo ghɛɛ̀ ǹlɔɔ ayoo nɨjɨ yaa nɨ ɨlaꞌa ɨtoo ji mɔꞌɔ nyuu njɨ.” ");
INSERT INTO bfd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu a kwiꞌi a mbo bo mə, “Kaa bo sɨ̀ nɨ̂ m̀màꞌàtə tswê, bùmbɔŋ, nɨ̀ fa ayoo a mbo bo bǒ jɨ.” ");
INSERT INTO bfd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bo kwiꞌi ghu mbo mə, “Àyoo yìi bìꞌì tswe nɨ yu faà, à nɨ tsiꞌì ŋkya ɨbaa ji ntaà nɨ m̀bwɛ̀ mi mbaà.” ");
INSERT INTO bfd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu a swoŋ mə bɨ̀ zi nɨ mu a mbo yu. ");
INSERT INTO bfd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A swoŋ a mbo nnɔ̀ɔ̀ bə̂ wa mə tâ bo tswetə a nyɛ nɨ̂ ŋ̀gɛ̀ɛ̀ yâ. Bɨ tswè mə̂ aa, a lɔgə̀ ŋ̀kya ɨbaa jya ji ntaà bo bɨ̀ m̀bwɛ̀ mya mi mbaa, ŋ̀ŋɛntə miꞌì mi a ndəŋ, mfa mbɨꞌɨkə a mbo Nwì, m̀batə abaa ya mfa a mbo ŋ̀gǎŋyəgə̂nnù ji mə tâ bo fa a mbo bə̀ byâ. ");
INSERT INTO bfd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ŋù ǹtsɨ̀m à lɛ njɨ nyurə, ŋ̀gǎŋyəgə̂nnù ji jya ɨ bû ǹtɨgə nsyɛ abùgə̀ mɨjɨ jya a luu a nɨ̂ ŋ̀kyɛ̀ nɨghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ǹdùu mbâŋnə̀ yìi ɨ lɛ njɨ mɨjɨ myaa, ɨ lɛ mbə tsǒ ntsùꞌù ji ntaà; kaa bɨ lɛ ŋwaꞌà bâŋgyɛ̀ bo bôŋkhə səŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu à lɛ swoŋ ŋgǎŋyəgə̂nnù ji ɨ kuu a mûm àkànuꞌu mbu ntoo ŋghɛɛ fu a njii yî mɔ̀ꞌɔ̂. Yu mbɔŋ a tɨgə̀ m̀baŋnə ntswe a njɨ̀m ǹswoŋ nnɔ̀ɔ̀ bə̂ wa ɨ sɛɛnə. ");
INSERT INTO bfd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ǹnɔ̀ɔ̀ bə̂ wa ɨ sɛ̀ɛ̀nə̀ mə̂, a kɔꞌɔ ŋghɛ̀ɛ̀ wa atu ntaꞌa tsiꞌì yù yù a ntsàꞌàtə Nwì. Nòò ŋ̀kwɛ̂fɔ̀ à lɛ ŋkùꞌù a tswê ghu tsiꞌì yù yù, ");
INSERT INTO bfd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","lɛ boŋ àkànuꞌu ya a bùrə̀ mə̂ ŋ̀ghɛɛ a mûm ŋ̀kì àghaꞌa a saꞌà. Ɨ̀kàŋnə ŋkì ɨ tumə̀ ŋ̀ghɛɛ, ntumə mbɨɨ nloŋ mə àfìsə̀ a lɛ ŋghaꞌa a mûm ŋ̀kì. ");
INSERT INTO bfd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","À bə̀ mə̂ a nɨ nòò ǹjwi a zî a mbo bo, ǹtəə nɨ a atu ŋkì. ");
INSERT INTO bfd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nòò yìi ŋgǎŋyəgə̂nnù ji ɨ lɛ nyə yi a təə̀ wa atu ŋkì aa, nɨ̀bɔꞌɔ nì wè tswâ waa, bo tɨgə̀ ǹtɔŋnə nswoŋə nɨ mə, “À nɨ̂ ŋ̀kû!” ");
INSERT INTO bfd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu a waŋsə̀ ŋ̀ghaa a mbo bo nswoŋ mə, “Tswa nɨ ntɨɨ̀ ghuu, à wa nɨ mə̀. Nɨ̀ tsuu bɔꞌɔ.” ");
INSERT INTO bfd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peta a swoŋ ghu mbo mə, “M̀màꞌàmbî, m̀bə a bə wô, ò swoŋ mə̀ zî a mbɛ̀ɛ wò fya mûm ŋ̀kì.” ");
INSERT INTO bfd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu a swoŋ ghu mbo mə, “Zǐ!” Peta à lɛ mfɛ̀ꞌɛ̀ wa mûm àkànuꞌu, ntəə wa atu ŋkì ŋ̀ghɛɛ a mbɛ̀ɛ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lâ, àjàŋ mə à lɛ nyə afìsə̀ ya aa, nlɔ̀gɨ̀nə̀ ŋ̀ka mbɔꞌɔ, ntɨgə mbwɛ nsɨgə ŋghɛɛ wa mûm ŋ̀kì. Ǹtɔŋnə nyəꞌə mə, “M̀màꞌàmbî, yweensə ghâ.” ");
INSERT INTO bfd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu a wâŋsə̀ ǹnasə abô yi ǹtswa yi ghu, nswoŋ mə, “Àbìintɨɨ̀ yo a kəꞌə bə laà aa a ya aa ɛ? O ghɨ̀rə̀ ǹjɨŋkə aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nòò yìi bo lɛ ŋkɔꞌɔ ŋkuu wa mûm àkànuꞌu aa, àfìsə̀ ya a kɛntə̀. ");
INSERT INTO bfd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bə̀ bìi bɨ lɛ ntswe wa mûm àkànuꞌu aa, bɨ miì yi nswoŋ mə, “Àâ ànnù nɨ̂koŋə̀, ò nɨ Mu Nwìŋgɔ̀ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bo tòò mə̂ ŋ̀ghɛɛ a alaꞌa Gennesaret. ");
INSERT INTO bfd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Badɨgə bya lɛ nyə yi nzi, ǹtsyasə ŋ̀kɨ̀ɨ̀ tsiꞌǐ a ɨdɨgə ɨdɨgə maa mbɛ̀ɛ̀ àlaꞌa mə bɨ̀ ghotə ŋgàŋmɨghɔ̀ɔ̀ ǹzi nɨ ju ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bo lɛ mbuꞌu mbo ghu mbo mə tâ à maꞌatə tâ ŋ̀gàŋmɨ̀ghɔ̀ɔ̀ jyâ bɔɔ mɔɔntə tsiꞌì àtsəŋ atsə̀ꞌə̂ yi. Bə̀ bɨtsɨ̀m bìi bɨ lɛ mmɔ̀ɔ̀ntə̀ aa, bɨ lɛ ntɨ̀ɨ̀ nɨghɔ̀ɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","BaFarɨsai bo bɨ̀ ŋgǎŋndɨꞌɨ nɔ̀ŋsə̀ lɛ nlǒ a Yerusalem nzi mbetə Yesu mə, ");
INSERT INTO bfd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kaa ŋgǎŋyəgə̂nnù jo ɨ sɨ bɨ̂nɔ̀ŋgɔ̀ŋ bɨ bɨ̂tà bɨ bɨ̂taà biꞌi ləə aa a a ya aa ɛ? Ǹloŋ mə kaa bɨ sɨ mbô myaa siꞌi a nɨ mânjì yìi a kùꞌùnə nsìꞌi mbɔŋ kɨ jɨ.” ");
INSERT INTO bfd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu a kwiꞌi mə, “Kaa nɨ̀ sɨ ndɨꞌɨ Nwî yuꞌunə, mbaŋnə yòŋə̀ bə̂ bɨ̀nɔ̀ŋgɔ̀ŋə̂ bu aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ǹloŋ mə Nwì à lɛ ndɨꞌɨ mə, ‘Ka nyuꞌunə a taà ghò bo ǹdè ghò,’ ŋ̀kɨ ndɨꞌɨ mə, ‘Ŋù yìi à bə̀gɨ̀tə a taà yì kə̌ ndè yì aa, a kuꞌùnə̀ mə tâ bɨ̀ zwitə yi.’ ");
INSERT INTO bfd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nɨ̀ bâŋnə̀ ǹswoŋə nɨ̂ yùu ŋgaa bə mə, M̀bə ŋù a swoŋə a mbo taà yì kə̀ ǹdè yì mə, ‘Wa àyoo yìi mə boŋ mə̀ fa ŋkwɛtə gho ghu aa, mə̀ fà mə̂ a mbo Nwì,’ ");
INSERT INTO bfd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","boŋ kaa à sɨ̀ nɨ̂ ǹyùꞌùnə taà yì bû ǹtswe. Ma yû a dɨꞌɨ aa ajàŋ mə nɨ tɨgə mbwɛsə nɨ̂ nɔ̂ŋsə̀ Nwì m̀baŋnə ŋka nyoŋ nɨ̂ bɨ̀nɔ̀ŋgɔ̀ŋə̂ buu aà. ");
INSERT INTO bfd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bǔ ŋgàŋabagɨlə̀! Ŋ̀gàŋntoò Nwì Yesaiah à lɛ nyə aa tsiꞌì sɨgɨ̀nə̀ ŋ̀ŋwàꞌànə annù yìi mə Nwî à lɛ nswoŋ nloŋ ŋgaà yùù aà, mə, ");
INSERT INTO bfd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bə̀ buà, bɨ ghuꞌusə nɨ̂ gha aa tsiꞌì nɨ̂ ɨ̀ghoŋ ntsǔ jyaa, lâ mɨ̀ntɨɨ̀ myaa bâŋnə̀ ǹtswe a ndìsyà; ");
INSERT INTO bfd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bo mii nɨ̂ gha laa tsiꞌì àdàŋə̀ àdàŋə̀ ǹloŋ mə bo bàŋnə̀ ǹdɨꞌɨ bə bɨ̀nɔ̀ŋsə̀ bɨ bə̂ tsǒ ǹdɨ̀ꞌɨ̂ jyâ!’ ” ");
INSERT INTO bfd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu a tɨgə̀ ǹtwoŋ nnɔ̀ɔ̀ bə̂ wa ɨ zî ghu mbɛ̀ɛ̀ a swoŋ a mbo bo mə, “Nɨ̀ naŋsə nyuꞌu tâ à laa a atu bù: ");
INSERT INTO bfd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Àyoo yìi mə ŋǔ a jɨ a ntsǔ yu aa kaa a sɨ ma ya ghɨ̀rə mə tâ à tsuu laa, a ajàŋ yìi mə nɔ̀ŋsə̀ à dɨ̀ꞌɨ̀ aà, a bàŋnə̀ ŋ̀ghɨrə ayoo yìi mə a fɛ̀ꞌɛ̀ ghu ntɨɨ aa mə tâ à tsuu laa.” ");
INSERT INTO bfd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ŋ̀gǎŋyəgə̂nnù ji ɨ zî ǹswoŋ ghu mbo mə, “Ò zî mə baFarɨsai ghɨrə nlwìsə ntɔŋ a nu wò ǹloŋ annù ya mə ò ghɨ̀rə nswoŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu a kwiꞌi mə, “Àyoo yìi mə a sɨ̀ Taà ghà a aburə bê aa bɨ ka yǐ dǔ lɔ̀ꞌɔ̀sə̀. ");
INSERT INTO bfd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nɨ̀ maꞌatə waa; bo bə aa bɨ̀fə̀ꞌə̀nə̀ mə bɨ tsyàsə̀ bî mɔꞌɔ. M̀fə̀ꞌə̀nə̀ à bə kɨ tsyàsə̀ yî mɔ̀ꞌɔ boŋ bo bɨtsɨ̀m ka wǒ a ataà.” ");
INSERT INTO bfd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peta a swoŋ ghu mbo mə, “Tɔꞌɔtə njiꞌì nɨ̀ghàà nî nàà ma nû a mbo bìꞌì.” ");
INSERT INTO bfd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu a swoŋ mə, “Mala a bə mə, tsiꞌì bù, kaa nɨ̀ sɨ̀ kɨ nzi aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nɨ̀ sɨ̀ zi mə àyoo yìi mə ŋǔ jɨ a ntsǔ yu aa, a sɨgə aa ghu atoꞌo a kɨ̂ m̀bu ŋyì aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lâ àyoo yìi mə a fɛ̀ꞌɛ̀ a ntsǔ ŋù aa a fɛ̀ꞌɛ̀ aa ghu ntɨɨ̀, ŋ̀ghɨ̀rə nɨ mə tâ à tsuu laa. ");
INSERT INTO bfd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ǹloŋ mə a ntɨɨ ŋù aa a fɛ̀ꞌɛ ɨmɔ̀ɔ̀ntə̀ jî bɨ̂, ànnǔ nzwitə ŋù, ànnǔ mâghàbə̀, ànnǔ ajɨrə̀, ɨ̀yə̀rə, ǹswòŋə̂ àbaŋnənnù a atu ŋù, bo bɨ̀ ǹswòŋə̂ ànnù yì bɨ a atu ŋù. ");
INSERT INTO bfd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Àa ma jû ɨ̀nnù mə ɨ ghɨ̀rə mə ŋû à tsuu laa aà; kaa ǹjɨ tɨ̀ sìꞌì m̀bo tsǒ mə bo swoŋə aa, kaa a sɨ ghɨ̀rə mə ŋù à tsuu laa.” ");
INSERT INTO bfd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu à lɛ ntɨgə mmaꞌatə adɨgə ma ya ŋghɛɛ a mbùꞌu Tai bo Sidon. ");
INSERT INTO bfd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Màŋgyɛ baKana yî mɔ̀ꞌɔ, yìi à lɛ ntswe maa mbùꞌù aa, à lɛ nzì nyəꞌə nswoŋə nɨ mə, “Ko mɨlɨ̀ŋnə̀ ghà, m̀bâ M̀màꞌàmbî Mu David! Demon yî mɔ̀ꞌɔ̂ à naŋsə ntswe a atoꞌo mû ghà yî màŋgyɛ̀ ǹdɨ nɨ̂ ŋ̀gɨꞌɨ ghu nu siꞌi.” ");
INSERT INTO bfd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","La kaa Yesu kaa a waꞌǎ yi kwɛꞌɛ̀. Ŋ̀gǎnyəgə̂nnù ji ɨ tɨgə̀ ǹzi mbuꞌu mbo ghu mbo nswoŋ mə, “Furə mâŋgyɛ̀ ghû tâ à bɨɨ a njɨ̌m bìꞌinə̀! Wa a yə̀ꞌə̀ ǹyoŋ aa nzwi nɨ̂ àtu ŋû.” ");
INSERT INTO bfd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu a kwiꞌi mə, “Bɨ lɛ ntoo gha aa tsiꞌǐ a mbo mbinjə̀rə̀ jìi ɨ bwɛ a ŋgwɛ̀ꞌɛ nda baIsrael aà.” ");
INSERT INTO bfd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Maà noò màŋgyɛ̀ wa a zî ǹswɛtə mɨkuꞌutə mi ghu nsi, nswoŋ mə, “M̀màꞌàmbî, Kwɛtə ghâ.” ");
INSERT INTO bfd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu a kwiꞌi mə, “Kaa a sɨ̀ kuꞌùnə̀ a nlɔ̀gə̂ àbaa bɔɔ mbàŋnə̀ m̀maꞌa a mbô m̀bû.” ");
INSERT INTO bfd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Màŋgyɛ̀ wa a kwiꞌi mə, “Ɨ̀ɨ̀ŋə, Mmàꞌàmbî, lâ m̀bu jya ɨ syɛ̂ nɨ̀ ŋ̀kùgə abaa jya mə ɨ lò wa atu atɛtə̌ taà wàà ŋ̀wokə aa ŋkurə.” ");
INSERT INTO bfd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu a tɨgə̀ ŋ̀kwiꞌi ghu mbo mə, “Oh! Màŋgyɛ̀, ò tswe nɨ̀ àbìintɨɨ siꞌi! Wa ò ka tswe nɨ̂ ànnù ya yìi o lɔ̀ɔ̀ aà.” Mû yì wa à lɛ ŋghɛ̀nsə̀ ŋ̀kɨ ntɨɨ tsiꞌì maà noò. ");
INSERT INTO bfd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu à lɛ ntɨgə nlo maa adɨgə ŋghɛɛ ntsyǎ a mbɛ̀ɛ àtsùmə̀ Galilea. Ŋ̀kɔꞌɔ ŋghɛɛ a atu ntaꞌa, ǹtɨgə ntswe a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mâ m̀bêm ǹnɔ̀ɔ̀ à lɛ nzì ghu mbɛ̀ɛ̀ nɨ bɨ̀tsə̀ŋkərə̀, bɨ̀bwènkə̀, bɨ̀fə̀ꞌə̀nə̀, bɨ̀tɨ̀ghàà, nɨ̂ ŋ̀gàŋmɨghɔ̀ɔ̀ jî mɔꞌɔ tsiꞌì jì ghàꞌàtə̀, ǹnɔŋsə a mɨkòrə Yesu a ghurə̀ waa. ");
INSERT INTO bfd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bə̀ bya lɛ nyɛrə siꞌi a ajàŋ yìi mə bo lɛ nyə bɨ̀tɨ̀ghàà ghaà, bɨ̀bwènkə̀ tɨɨ̀, bɨ̀tsə̀ŋkərə̀ təə̀, bɨ̀fə̀ꞌə̀nə̀ kɨɨ̀ ǹyə nɨ̂ ɨ̀dɨ̀gə̀ aà; bo lɛ ntɨgə ŋghaꞌasə Nwîŋgɔ̀ŋ baIsrael. ");
INSERT INTO bfd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu à lɛ ntɨgə ntwoŋ ŋgǎŋyəgə̂nnù ji jya nswoŋ a mbo bo mə, “Mə ko mɨlɨ̀ŋnə̀ bə̀ bû, ǹloŋ mə bɨ tswè mə̂ biꞌibo tsɨ̂tsɔ̌ŋ njwi ji tarə kaa waꞌà nɨ̂ àyoo yì jɨ̀ tswê aà. Kaa mbə mə̀ waꞌà swoŋ mə tâ bo lo ŋghɛ̀ɛ̀ nɨ̂ ǹjì ǹloŋ mə mbə bo ghɨrə̀ ŋ̀ghɛɛ ŋwòkə̀ a mânjì.” ");
INSERT INTO bfd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ŋ̀gǎŋyəgə̂nnù ji ɨ betə yi mə, “M̀bə bìꞌinə̀ lɔgə̌ abaa aa fə fàa a atu ntaꞌa mɨwɛ̀ɛ̀ a kuꞌùnə̀ a njɛꞌɛ mâmbêm ǹnɔ̀ɔ̀ ghû ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu a betə̀ waa mə, “Nɨ̀ tswe nɨ̀ ŋ̀kya abaa aa ji səgə aa ɛ?” Bo kwiꞌi mə, “Ɨ nɨ ji sàmbaa nɨ̀ bɔɔ bɨ mbwɛ̀ bî mɔꞌɔ̂.” ");
INSERT INTO bfd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu a swoŋ mə tâ ǹnɔ̀ɔ̀ bə̂ wa tswe a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A tɨgə̀ ǹlɔgə ɨbaa jya ji sàmbaa nɨ mbwɛ̀ mya, mfa mbɨꞌɨkə a mbo Nwì, m̀batə, m̀fa a mbô ŋ̀gǎŋyəgə̂nnù ji bo yatə a mbo bə̀ byâ. ");
INSERT INTO bfd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bə̀ bya bɨ̀tsɨ̀m lɛ njɨ nyurə; bɨ̀ bwɛɛ̀ àbùgə̀ mɨjɨ ya, ɨ̀bàꞌa abaa jya bo bɨ̀ ɨ̀sàꞌa mbwɛ̀ jya, ɨ luu nɨ̂ ŋ̀kyɛ̀ ji sàmbaà. ");
INSERT INTO bfd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ǹdùu mbâŋnə̀ jìi ɨ lɛ njɨ aa lɛ mbə ntsùꞌù ji nɨkwà; kaa bɨ lɛ waꞌà bâŋgyɛ̀ bo bɨ̀ bôŋkhə səŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu à lɛ ntɨgə nsɛɛnsə bə̂ bya, ŋ̀kuu a mûm àkànuꞌu ntoo ŋghɛɛ a mbùꞌù àlaꞌa Magadan. ");
INSERT INTO bfd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","BaFarɨsai bɨ̂ mɔ̀ꞌɔ bo bɨ̀ baSadukai bɨ lɛ nzì a bo Yesu nlɔɔ mə bɨ kwàꞌànə̀ yi, m̀betə yi mə tâ à ghɨrə alènsə̀ yìi mə a lo a aburə aa a ndɨ̀ꞌɨ mə Nwì à tswe bo yu. ");
INSERT INTO bfd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu a kwiꞌi waa nɨ̂ àbetə̀ mə, “A yǐ mbə a ŋkwɛ̂fɔ̀ aa nɨ̀ swoŋə̀ nɨ mə ‘Ɨ̀dɨ̀gə̀ ka ghɨ̀rə bɔ̀ŋə̀ ǹloŋ mə m̀bàꞌà àbùrə ɨ bàŋə̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A yi ŋkɨ mbə a tɨ̀tugə aa nɨ̀ swoŋə̀ nɨ mə, ‘Sìi à ka ghɨ̀rə bə njwî àfìsə̀ ǹloŋ mə m̀bàꞌà àbùrə̀ ɨ bàŋə̀ ŋ̀kɨ mbosə nɨ̂ ɨ̀dɨ̀gə̀.’ Nɨ̀ zî àjàŋə mə mbə nɨ̀ kâ ǹyə nɨ̂ ɨ̀nnù a ajàŋ mə m̀bàꞌà àbùrə ɨ dɨ̀ꞌɨ̀ aà. Lâ kaa mbə nɨ̀ waꞌǎ ɨlènsə̀ noò ŋ̀gùꞌu mbi yulà zî. ");
INSERT INTO bfd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bǔ ŋgǎŋghɨ̀rə̂ ɨ̀nnù jî bɨ bɨ̀tɨ̀biì Nwî bɨ̀ ŋgùꞌù bulà, nɨ betə nàa mə mə̀ dɨꞌɨ alensə annù a mbo bù aa ɛ? Ŋ̀gaŋ, àlènsə̀ yìi mə mbə mə̀ dɨꞌɨ a mbo bù à kɨ mbə aa tsiꞌì yì Jɔna.” À swòŋ mə̂ laa ntɨgə mmaꞌatə waa ŋghɛɛ yi. ");
INSERT INTO bfd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nòò yìi mə ŋgǎŋyəgə̂nnù ji ɨ lɛ ntoo ŋghɛɛ nyweꞌe wa mbɛ̀ɛ̀ àtsùm ya yì mɔ̀ꞌɔ aa, bo lɛ yə mə bo liꞌinə a nlɔ̀gə àbaà. ");
INSERT INTO bfd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu a swoŋ a mbo bo mə, “Nɨ̀ ka nstsyɛsə ghuu, ntsee nɨ̂ àtû yuu nloŋ mbɛ̀ꞌɛ̀ abaa baFarɨsai bo bɨ̀ yì baSadukai.” ");
INSERT INTO bfd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bo lɔgɨ̀nə̀ ǹtɨgə ŋghaa a atɨtɨ̀ɨ bo nswoŋə nɨ mə, “À swǒŋ laà aa nloŋ mə kaa bìꞌinə̀ ghɨ̀rə ŋwaꞌǎ abaa lɔ̀gə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu a zî ànnù yìi mə a lɛ ntswe a ntɨɨ bo, ǹtɨgə nswoŋ mə, “Bù bə̂ bìi mə àbìintɨɨ̀ yaa a kəꞌətə, a ghɨ̀rə̂ àkə̀ mə nɨ̀ ka ŋghaa a tɨtɨ̀ɨ bù mə nɨ̀ sɨ̀ nɨ̂ àbaa tswe aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nɨ̀ sɨ annù zi tâ àtû yuu laa ghu aa ɛ? Nɨ̀ sɨ̀ burə kɨ waꞌatə ajàŋ mə mə̀ kɨ̀ jɛ̀ꞌɛ bə̂ bya ǹtsùꞌù ji ntaà nɨ̂ ŋ̀kya ɨbaa jya ji ntaà aa ɛ? Nɨ̀ lɛ nsyɛ̌ ŋkugə ji ɨ luu aa a nɨ̂ ŋ̀kyɛ̀ ji səgə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nɨ̀ sɨ̀ kɨ ŋwaꞌatə ŋkya abaa jya ji sàmbaa mə mə̀ kɨ̀ jɛ̀ꞌɛ bə̌ ntsùꞌù ji nɨkwà ghu aa ɛ? Nɨ̀ lɛ ŋkɨ nsyɛ ŋkùgə̂ ji ɨ luu aa a nɨ̂ ŋ̀kyɛ̀ ji səgə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Â tɨgə̀ ŋ̀ghɨrə akə mə nɨ̀ bu ŋka njɨŋkə, kaa ŋkɨꞌɨ̀ zi mə mə̀ sɨ aa annǔ nloŋə abaa ghàà aa ɛ? Nɨ̀ ka ntsyɛsə ghuu nɨ̂ m̀bɛ̀ꞌɛ̀ àbaà baFarɨsai nɨ baSadukai.” ");
INSERT INTO bfd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bo tɨgə̀ ǹzi maa noò a laa mə kaa à sɨ a mbo bo ghaa mə tâ bo ka ntsyɛsə nloŋ aa m̀bɛ̀ꞌɛ̀ àbaa. À bàŋnə̀ ŋ̀ghaa nloŋ aa ɨ̀nnù jìi mə baFarɨsai bo bɨ̀ baSadukai lɛ sɨ dɨ̀ꞌɨ aà. ");
INSERT INTO bfd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu à lɛ ŋghɛ̀ɛ̀ ŋ̀ka ŋkoontə a mbɛ̀ɛ Kaisaria Filipi, m̀betə ŋgǎŋyəgə̂nnù ji mə, “Bə̌ swoŋə nɨ mə Mu Ŋù à bə aa wo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bo kwiꞌi mə, “Bǐ mɔꞌɔ swoŋə nɨ mə, Jɔn Ŋgàŋmùrə bə̌ ŋkì, bǐ mɔꞌɔ swoŋə̀ nɨ mə, Elijah, bǐ mɔꞌɔ kɨɨ̀ m̀bu nswoŋə nɨ mə, Yeremiah, kə̀ ŋ̀gàŋntoò Nwì wa yì mɔ̀ꞌɔ̂.” ");
INSERT INTO bfd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A betə̀ waa mə, “Lâ nɨ̀ swǒŋ yuu ŋgaa mə mə̀ laa mbə wo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peta a kwiꞌi mə, “Ò nɨ̂ Àyɔꞌɔ̀ Nwì wâ, m̀bə Mu Nwìŋgɔ̀ŋ yìi mə à tswe ntɨ̀ɨ̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu a swoŋ ghu mbo mə, “M̀bɔɔnə a mbo wò mbâ Simon mu Jɔna nloŋ mə a ma yû ànnù nɨ̂ŋkoŋ a mbo wò aa kaa a sɨ ŋûmɨ̀sɔ̀ŋ dɨꞌɨ̀. A dɨ̀ꞌɨ Taà ghà a aburə a mbo wò. ");
INSERT INTO bfd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mə̀ swòŋə a mbo wò mə, ò laa mbə Peta, mə̀ ka bɔɔ ŋghotə̂ yà ma mùu atû àlâŋsə ŋgɔ̀ꞌɔ̀. Kaa tâ tsiꞌì nɨ̀wo, tâ nɨ̀ waꞌà tɨ̀ɨ̀ ǹtsya. ");
INSERT INTO bfd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mə̀ ka fa bɨ̂key bɨ annù nɨfɔ̌ aburə a mbo wò. Ànnù yìi mə ò kwerə fàa nsyɛ aa boŋ baa kɨɨ kwerə a aburə. Ànnù yìi mə ò fɛ̀ɛ fàa nsyɛ aa boŋ baa kɨɨ fɛ̀ɛ a aburə.” ");
INSERT INTO bfd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A tɨgə̀ ǹnaŋsə ŋkwantə ŋgǎŋyəgə̂nnù ji mə tâ bɨ̀ tsuu a mbo ŋǔ lǒ swoŋ mə yu laa mbə Ayɔꞌɔ̀ Nwì wâ. ");
INSERT INTO bfd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ǹlɔgɨnə maa noò Yesu a lɔ̀gɨ̀nə̀ ǹdɨꞌɨ a mbo ŋ̀gǎŋyəgə̂nnù ji mə, yu tswe nɨ̀ ǹlɨ̀gɨ̀nə ŋkɔꞌɔ ŋghɛ̀ɛ a Yerusalem ɨ ghɛ̀ɛ ɨ yə mbuu ŋgɨꞌɨ jì ghàꞌàtə̀ ghu a mbo bɨ̀tà bɨ alaꞌa, bo bɨ̀ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌanwì nɨ̂ ŋ̀gǎŋndɨ̀ꞌɨ̀ nɔ̀ŋsə̀, tâ bɨ̀ zwìtə yi, a tɨ bə nɨ̂ ǹjwi ji tarə bɨ bu nyweensə yi fu nɨ nɨ̀wô. ");
INSERT INTO bfd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peta à lɛ nswùŋtə̀ yi ŋghɛntə nɨ ghu, ǹlɔgɨnə ŋka ŋghaantə nii nswoŋə nɨ mə, “Wa mbə Nwì waꞌǎ ma yû ànnù bii, Mmàꞌàmbî. Wa kaa mbə ajàŋə annù ma yû a waꞌǎ a nu wò fɛꞌɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A bəŋkə̀ yi nswoŋ a mbo Peta mə, “Tsyǎ mbɨ̀ɨ a njɨ̌m mə̀, m̀bâ Satan! Ò nɨ̀ m̀fànsə̀ mânjì a mbo mə̀ ǹloŋ mə kaa ò sɨ̀ aa a njɨ̌m Nwì təə̀, ò bàŋnə ntəə aa a njɨ̌m bə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu a tɨgə̀ ǹswoŋ a mbô ŋ̀gǎŋyəgə̂nnù ji mə, “M̀bə ŋù tsù a ka nlɔɔ a ŋka nyòŋə a njɨ̌m mə̀, a tuù ɨ̀bɨɨ nû yi, mbeꞌe abàŋnə̀ bàŋnə̂ yi ŋka nyoŋə nàâ. ");
INSERT INTO bfd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ǹloŋ mə ŋù yìi mə a lɔ̀ɔ mə yu yweensə ɨbɨɨ nû yi aa, à ka bàŋnə bwɛ. Ŋù yìi mə a bàŋnə̀ m̀bwɛ ɨbɨɨ nû yi nloŋ ŋkwi atû gha aa, à ka bàŋnə tswe nɨ ghu. ");
INSERT INTO bfd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","M̀bə a kwɛtə ŋû tsù aa nɨ̂ àkə̀ mə mbə a tswe nɨ̂ m̀bi yǔ ntsɨ̀m m̀baŋnə mbwɛ ntswêntɨ̀ɨ yì aa ɛ? Kə̀ m̀bə ŋù a fa aa àkə̀ ŋ̀kwensə ǹtswêntɨ̀ɨ̂ yì ghu aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ǹloŋ mə Mu Ŋù à ka yǐ zǐ bo bɨ̀ baangel bi a mûm nɨ̀ghaꞌa nɨ Taà yì ɨ tsɔꞌɔ ɨfàꞌà ŋû ǹtsɨ̀m ɨ yòŋə nɨ̂ àfàꞌà yìi mə à lɛ mfàꞌa aà. ");
INSERT INTO bfd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə bə̀ bî mɔꞌɔ bɨ təə faà bìi mə kaa bo ka yǐ waꞌà nɨwo yweꞌetə̀ tɨ yə nòò wa mə Mu Ŋù à ka yǐ zì a mûm ànnù nɨfɔ̌ yu aà.” ");
INSERT INTO bfd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ǹjwi ɨ tsyà mə̂ ji ntoꞌo, Yesu a lɔ̀gə Peta bo Jɛms nɨ mumaà yì Jɔn bo bo kɔꞌɔ ghɛ̀ɛ̀ a atu ntaꞌa yì syà yî mɔꞌɔ, ǹtswe ghu tsiꞌì bò bo. ");
INSERT INTO bfd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nû yì ɨ bəŋkə̀ a nsi bo, ǹsî yi ɨ tɨgə̀ ǹta tsiꞌì tsǒ nɨ̀nòò, ɨ̀tsə̀ꞌə̀ jì ɨ fuꞌù ǹjɛɛŋkə. ");
INSERT INTO bfd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bo ghəə kɨ yə Moses nɨ Elijah wiꞌìkə̀ m̀fɛꞌɛ ntɨgə ŋghaanə bo bɨ̀ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peta a swoŋ a mbo Yesu mə, “M̀màꞌàmbî, a bɔŋ mə bìꞌinə̀ tswe faà aà. Ò bə kɔ̌ŋ boŋ mə̀ ka ghùrə̀ mɨ̂ntàŋ mi ntarə faà, tâ yì fùùrə̀ ɨ̀ tswe a mbo wò, yǐ mɔꞌɔ ɨ̀ tswe a mbo Moses, tâ yǐ mɔꞌɔ ɨ̀ tɨgə ntswe a mbo Elijah.” ");
INSERT INTO bfd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Àjàŋ mə à lɛ mburə kɨ ghàà aa mbàꞌà yî ǹtà yî mɔ̀ꞌɔ ɨ wiꞌìkə̀ ŋ̀kusə waa, ǹjì ŋù ɨ fɛꞌɛ̀ wa mûm m̀bàꞌà ǹswoŋ mə, “Àa mû ghà yî m̀bâŋnə̀ yìi mə mə̀ kɔ̀ŋə aa à ghulà, mə naŋsə ndorɨtə nloŋə yì. Nɨ̀ ka nyuꞌu annù yìi a swoŋə aà.” ");
INSERT INTO bfd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nòò yìi ŋgǎŋyəgə̂nnù ji ɨ lɛ yuꞌu lâlàà aa, bo lɛ ŋwǒ a nsyɛ àkùu kuu, nluu nɨ nɨ̀bɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lâ Yesu à lɛ nzì ǹzi mmɔ̀ɔ̀ntə̀ waa nswoŋ mə, “Bɨ̀ɨ̀nə̂ nɨ̀, nɨ̀ tsuu kɨ bɔꞌɔ.” ");
INSERT INTO bfd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bo ŋɛntə̀ miꞌì myaa ntɨgə yə tsiꞌì Yesu, kaa ŋkɨꞌɨ̀ ŋû dàŋ bû ǹyə. ");
INSERT INTO bfd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Àjàŋ mə bo lɛ nlò wa atu ntaꞌa ŋka nsɨgə aa, Yesu a swoŋ a mbo bo mə, “Nɨ̀ tsuu annù ǹloŋ njə̀ə̀ təə təə ma yû a mbo ŋǔ lǒ swoŋə, ɨ yweꞌe noò yìi mə Mu Ŋù à ka yǐ yweenə nɨ nɨ̀wo aà.” ");
INSERT INTO bfd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ betə̀ yì mə, “Ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ ɨ nswoŋə nɨ mə Elijah à tswe nɨ̀ m̀fòo ntsyǎ mbìì ɨ zì aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu a kwiꞌi a mbo bo mə, “Elijah à tswe nɨ̀ zî, ŋ̀kɨ tswe nɨ̂ ǹzǐ tsisə ɨ̀nnù tsɨ̀m fu ɨ bɨ̀nsə̀ a ajàŋ mə ɨ lɛ ntswe aà.” ");
INSERT INTO bfd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","La mə̀ swòŋə a mbo bù mə Elijah à tɛ̀ꞌɛ̀ mə̂ ǹzi, kaa bo waꞌà yi zî, m̀baŋnə ŋghɨ̀rə annù yìi mə bɨ kɔ̀ŋə aa ghu nû. À kɨ mbə a ŋgɨ̌ŋgɨ̀ŋ a ajàŋ mə Mu Ŋù à ka yə ŋgɨꞌɨ a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ tɨgə̀ ǹyuꞌu a laa atu bo maa noò mə a swoŋə aa ànnù ǹloŋ ŋgaa Jɔn Ŋ̀gàŋmùrə bə̌ ŋkì. ");
INSERT INTO bfd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nòò yìi mə bo lɛ mbù m̀bɨɨ ntsiꞌi nnɔ̀ɔ̀ bə̂ wa aa, ŋùmbâŋnə̀ yî mɔ̀ꞌɔ̀ à lɛ nzì ǹswɛtə mɨkuꞌutə̂ mi a nsi Yesu, ǹswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“M̀màꞌàmbî, ko mɨlɨ̀ŋnə̀ mû ghà ghû, ǹloŋ mə a wǒ àbùbùrə̀ ǹnaŋsə nyə nɨ̂ ŋ̀gɨꞌɨ tsiꞌì nɨ̂ m̀bə̂ ànnù. A yi mbə noò mɔ̀ꞌɔ a wô a mum mɔꞌɔ, a bə a noò mɔ̀ꞌɔ a wô a mûm ŋ̀kì. ");
INSERT INTO bfd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mə̀ ghɨ̀rə nzì nɨ ghu a mbô ŋ̀gǎŋyəgə̂nnù jo kaa bo kɨꞌɨ̀ àjàŋ mə mbə bo ghurə̀ yi zî.” ");
INSERT INTO bfd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu a swoŋ mə, “Oò, bǔ nɨwaa nɨ bə̂ bìi bɨ sɨ̀ nɨ̂ àbìintɨɨ tswê, ŋ̀ghɨrə nɨ̂ ɨ̀nnù jìi ɨ sɨ̀ tsinə̀ aa, mə̀ ka tswe biꞌinə̀ ɨ yweꞌe aa a noò àkə̀ aa ɛ? Mə̀ ka kɨ tswa ntɨɨ̀ gha nloŋ ŋgaà yùù ɨ ghɛɛ yweꞌe aa a noò àkə̀ aa ɛ? Nɨ̀ zi nɨ ghu a mbo mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu a wenə̀ demon wa, a burə̀ m̀fɛꞌɛ ghu nu, mu wa a ghɛsə̀ ǹtɨɨ. ");
INSERT INTO bfd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ŋ̀gǎŋyəgə̂nnù Yesu ɨ lɛ ntɨgə nzi ghu mbo a alɔ̀ꞌɔ̀sə̀ m̀betə yi mə, “Bìꞌì ghɨrə ŋkɨꞌɨ a mfiꞌi demon wa zi aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A kwiꞌi a mbo bo mə, “Ǹloŋ mə àbìintɨɨ̀ yuu a kəꞌə aà. Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, mbə nɨ̀ tswe nɨ̂ àbìintɨɨ a tɛꞌɛ ŋkəꞌə mbə tsiꞌì tsǒ àbùrə mâghum, bəə boŋ mbə nɨ̀ swoŋə a mbô ǹtaꞌa ghǔ mə, ‘Bɨ̀ɨ̀nə̀ faà ŋ̀ghɛɛ ntəə fiì’ ɨ kɨ̂ m̀bɨɨnə. Maa mùu ajàŋ boŋ kaa mbə ànnû tsu a waꞌà ghuu tsyâ.  ");
INSERT INTO bfd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","M̀buu demon ma ghû a lɔ̀ɔ̀ aa mə mbə nɨ̀ siꞌisə̀ ɨ̀bɨɨ nû ghuu tɨ jɨ ǹtsaꞌatə Nwî m̀bɔŋ fiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nòò yìi mə ŋ̀gǎŋyəgə̂nnù jɨ ɨ lɛ mbù ŋ̀ghotə a alaꞌa Galilea aa, Yesu a swoŋ a mbo bo mə, “Bɨ ka fa Mu Ŋù a mbo bə̀, ");
INSERT INTO bfd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","tâ bɨ̀ zwitə yi, a tɨ bə a nɨ̂ ǹjwi ji tarə̀ bɨ bû m̀bɨɨnsə yi fu a nɨwô.” Nû yàà ɨ̀ lɛ nnaŋsə mbɨꞌɨ tsiꞌì nɨ̂ m̀bə̂ ɨ̀nnù. ");
INSERT INTO bfd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nòò yìi bo lɛ nzì ŋ̀kuꞌu a Kapernaum aa, ŋ̀gǎŋkwɛrə tax ndâmàꞌanwì bo zî a mbo Peta mbetə yi mə, “Ǹdɨ̀ꞌɨ̀nnù ghùù ghû, à sɨ tax ǹdâmàꞌanwì tu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peta a kwiꞌi mə, “A tu.” Nòò yìi mə Peta à lɛ ŋkuu a nda aa, Yesu a betə yi mə, “Simon, àmɔ̀ɔ̀ntə yo a nɨ mə akə aa ɛ? A tax a mbo bɨ̀fɔ̀ bî fàa nsyɛ aa a tu wo aa ɛ? Bə̀ bɨ alaꞌa bya, kə̀ bɨ̀gɨ̀ɨ̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peta a kwiꞌi mə, “Bɨ̀gɨ̀ɨ̀.” Yesu a tɨgə̀ ǹswoŋ mə, “M̀bə a bə la boŋ kaa bǎlaꞌa bya sɨ̀ nɨ̂ ǹtǔ tswê. ");
INSERT INTO bfd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lâ kaa bìꞌinə̀ sɨ lɔ̀ɔ̀ mə mbə bìꞌinə̀ lwîsə̀ mɨ̀ntɔ̂n myaa. Tsǒ mə a bə laa aa, ghɛ̀ɛ̀ fìi atsùm m̀maꞌa ǹsaꞌa ghu. Fɨ̀bwɛ̀ fɨ mbìì fìi ò ko aa, ò ŋaꞌatə̀ ǹtsû yi, boŋ ò ka fiꞌi abàtə ŋkabə ghu tâ à kuꞌu a ntu tax ǹdâmàꞌanwì ghà bo ghu. Lɔ̀gə ŋghɛ̀ɛ ntu tax yìꞌô ghu a mbo bo.” ");
INSERT INTO bfd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","À bə maa noò, ŋ̀gǎŋyəgə̂nnù Yesu zî ghu mbo mbetə yi mə, “Ŋù yìi mə à kɔ̀ꞌɔ ntsɨrə a mûm ànnù nɨfɔ̀ aburə aa à nɨ̂ wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu a twoŋə̀ mûŋkhə nzì ǹtɛꞌɛ a tɨtɨ̀ɨ bo ");
INSERT INTO bfd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ǹswoŋ mə, “Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə mbə nɨ̀ tsuu ghuu bəŋkə ɨ bə tsiꞌì tsǒ bôŋkhə boŋ kaa nɨ̀ ka yǐ waꞌà a mûm ànnù nɨfɔ̌ aburə kuù. ");
INSERT INTO bfd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ŋù ǹtsɨ̀m yìi mə à sɨ̀gɨ̀sə ɨbɨ̀ɨ nû yì a nsyɛ tsǒ mu ghulà aa, àa bə ŋù yìi à kɔ̀ꞌɔ̂ ǹtsɨrə a mûm ànnù nɨfɔ̌ a aburə. ");
INSERT INTO bfd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ŋù ǹtsɨ̀m yìi mə à kwɛrə ajàŋ mu mà yû nɨ̂ ɨ̀kûm gha aa boŋ à kwɛ̀rə aa ghâ. ");
INSERT INTO bfd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lâ ŋù yìi mə à ghɨ̀rə mə ajàŋə mu ma yû yî mɔꞌɔ mə à nɨ̌ŋ ntɨɨ̀ yi a nu mə̀ aa tâ à wo a mûm ɨ̀nnù jî bɨ, a bɔŋ mə tâ bɨ̀ kwerə ŋgɔ̀ꞌɔ abaa yì ŋ̀wè ghu ntɔŋ, m̀maꞌa yi a mûm ŋ̀kì mɨyaa tâ à bwɛ nsɨgə ŋghɛɛ a nsyɛ̂ ŋ̀kì. ");
INSERT INTO bfd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ŋ̀gɨꞌɨ yì ŋ̀wè a mbô mbì mə ɨ zì nɨ̂ ɨ̀kwàꞌànə̀ jìi mə bə̌ wò ghu aà. Ɨ̀kwàꞌànə̀ ɨ tɛꞌɛ ntswe nɨ̂ ǹzî, lâ ŋ̀gɨꞌɨ yì ŋ̀wè a nu ŋù yìi mə ɨ̀kwàꞌànə̀ ma jya ɨ tsya ghu njɨ̀m ǹzi aà. ");
INSERT INTO bfd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","M̀bə abô yo kə̀ àkòrə̂ yo a ghɨrə mə tâ ò wo a mûm ɨ̀nnù jî bɨ, ò kwyɛ̂ m̀meꞌe. A bɔŋ mə ta ò bə abô mɔ̀ꞌɔ kə̀ àkòrə̀ mɔꞌɔ ǹtsyatə a ntswe nɨ̀ mbo mi mbaa kə̀ mɨ̀kòrə̀ mi mbaa, tâ bɨ̀ yi mbàŋnə̀ m̀maꞌa gho a mum mɔꞌɔ tɨ mɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","M̀bə nɨ̀liꞌì no nɨ ghɨrə mə ò wo a mûm ɨ̀nnù jî bɨ, ò tweꞌè m̀meꞌe. A bɔŋ mə tâ ò bə nɨ̀liꞌì mɔꞌɔ nyi ŋkuu a mûm ǹtswêntɨ̀ɨ̀, ǹtsyatə a ntswe nɨ̀ miꞌi mi mbaa tâ bɨ̀ yi mbàŋnə̀ m̀maꞌa gho a mum mɔꞌɔ Satan. ");
INSERT INTO bfd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“A nɨ̀ yə mə kaa nɨ̀ sɨ bɔɔ bì kəgə tsǒ buà bû tsaꞌa. Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə baangel byaa bɨ təə a nsi miꞌi Taà a ŋgɔ̀ŋ bɨ̀nòò bɨtsɨ̀m a aburə.  ");
INSERT INTO bfd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ǹloŋ mə Mu Ŋù à lɛ nzì aa nyweensə bə̀ bìi mə bɨ bwɛ aà. ");
INSERT INTO bfd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nɨ̀ waꞌatə mə akə aa ɛ? M̀bə ŋù à tswe nɨ mbi njə̀rə̂ ji ŋkhɨ̀, bɛɛ yì mɔ̀ꞌɔ ɨ faꞌanə mbwɛ, a waꞌà jî mɔꞌɔ jya mɨ̀ghum mi bùꞌu ntsò bùꞌu a atu ntaꞌa mmàꞌàtə̀ ŋ̀ghɛɛ nlɔ̀ɔ̀ ya mə ɨ̀ fàꞌa a mânjì aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bɛ lə mə a yə, boŋ mə̀ swòŋə a mbo bù nɨ̂ ànnù nɨ̂ŋkoŋ mə àa kɨ dorɨtə nloŋ ŋgaa mbî mà ya ɨ tsyǎ ajàŋ mə a dorɨtə nloŋ ŋgaa jya mɨghum mi bùꞌu ǹtsò bùꞌu mə kaa ɨ ghɨrə waꞌǎ a mânjì faꞌà aà. ");
INSERT INTO bfd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","À kɨ mbə a ŋgɨ̌ŋ ŋgɨ̀ŋ ajàŋ mə Taà ghùù yìi à tswe a aburə aa, kaa à sɨ kɔ̀ŋ mə tâ mûntsirə̀ mu ghulà yî mɔ̀ꞌɔ tâ à bwɛ. ");
INSERT INTO bfd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“M̀bə ndɨ̂m ghò ghɨrə annù yî bɨ a nu wò, ò ghɛɛ̀ ghu mbɛ̀ɛ̀, bu yu tswê tsiꞌì bǔ yu bi baa, ò dɨꞌɨ̀ ɨ̀bɨ̂ yi ghu mbô. Bɛɛ a yuꞌutə bəə boŋ ò bù mə̂ ǹtswe nɨ̂ ǹdɨ̂m ghò wa fu. ");
INSERT INTO bfd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bɛɛ a tsuu yi nyuꞌutə, ò bû ǹtwoŋtə a ŋû yî m̀fùùrə̀ kə̀ bə̂ bi baa, bɨ zî nɨ̀ ghɛɛ̀ bǔ bo, ta tâ ɨ̀nnù tsɨ̀m jìi mə bɨ swoŋ aa tâ tswe nɨ bɨ̀yəfə bi baa kə̀ bi tarə bìi bɨ beentə. ");
INSERT INTO bfd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bɛɛ mə a kɨ mbu ntuu yi a nyuꞌutə ànnù yìi mə bǔ bo swoŋ aa, nɨ̀ lɔgə̀ yi ŋghɛɛ nɨ ghu a nsî ŋ̀ghòtə̂. Bɛɛ a kɨ mbu ntuu annù yìi mə ŋ̀ghòtə ɨ̀ swòŋə aa, nɨ̀ lêntə̀ yi tsiꞌì tsǒ tɨ̀zî Nwî kə̀ ŋ̀gàŋkwɛrə tax. ");
INSERT INTO bfd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Mə̀ swòŋə a mbo bù tsiꞌì ànnù nɨ̂ŋkoŋ mə, ànnù yìi mə nɨ̀ kwerə fàa nsyɛ aa boŋ baa kɨɨ kwerə a aburə, yìi mə nɨ̀ fɛ̀ɛ fàa nsyɛ aa boŋ baa kɨɨ fɛ̀ɛ a aburə. ");
INSERT INTO bfd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mə̀ kuꞌùsə̀ m̀bu nswoŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, mbə bù bi baa beenə fàa nsyɛ a nlɔɔ ayoo boŋ Taà ghà yìi à tswe a aburə aa à ka fa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ǹloŋ mə àdɨ̀gə̀ yìi mə bə̀ ghotə ntswe ghu bi baa kə̀ bi tarə nɨ̂ ɨ̀kûm gha aa, mə̀ tswe a tɨtɨ̀ɨ bo.” ");
INSERT INTO bfd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peta à lɛ nzì a mbo Yesu mbetə yi mə, “M̀màꞌàmbî, m̀bə ndɨm ghà a ghɨrə̀ ànnù yî bɨ a nu mə̀ aa ŋgàà ji sɨgə mə̀ kɨ̂ ǹliꞌinə ɨ tsɨ̀m aa ɛ? Mbə ŋgàà ji sàmbaa ɨ kuꞌù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu a kwiꞌi ghu mbo mə, “Kaa mə̀ ka waꞌà a mbo wò swoŋ mə ŋgàà ji sàmbaa, mə̀ ka bàŋnə swoŋ mə, ŋ̀gàà mɨghum mi sàmbaa ŋgàà ji sàmbaà. ");
INSERT INTO bfd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ma mùu ajàŋ, mbə bìꞌinə̀ fɨgɨ̀nə̀ ànnù nɨfɔ̌ aburə tsǒ mfɔ̀ yî mɔ̀ꞌɔ yìi mə à lɛ nlɔ̀ɔ̀ mə yu sèntə ɨnnǔ ŋkabə̂ ji bo bɨ̀ ŋ̀gǎŋəfàꞌâ ji, ");
INSERT INTO bfd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nòò yìi mə bɨ lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka nlentə aa, bɨ zî nɨ ŋù yì mɔ̀ꞌɔ yìi à lɛ sɨ tswa nìi nɨ bɨ milion bɨ francs bi nɨghumə̀. ");
INSERT INTO bfd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tsǒ mə kaa à lɛ ŋkɨꞌɨ ajàŋ yìi mə mbə yu tû ŋ̀kabə ya zi aa, m̀fɔ̀ wa a swoŋ mə bɨ̀ tswa yi mfee a bɔ̀ꞌɔ bɨ̀ ŋ̀gwɛ̂ yì nɨ bɔɔ̀ bi, nɨ̂ ŋ̀gɔ̀ŋ ǹjoò tsɨ̀m jìi à tswe nɨ ju aa ntu ŋkabə̀ yì ya ghu. ");
INSERT INTO bfd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ŋ̀gàŋàfàꞌà wa a swɛ̂tə̀ mɨ̀kùꞌùtə̀ mi a nsyɛ, mbuꞌu mbo ghu mbo, nswoŋ mə, ‘‘Mmàꞌambî, tswa ntɨɨ̀ gho a nu mə̀, wa mə̀ ka yǐ tu njoò tsɨ̀mə̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","M̀fɔ̀ wa a kô mɨlɨ̀ŋnə̀ yì, m̀maꞌatə yi, nswoŋ mə tâ à tsuu ŋkabə ya bǔ tu. ");
INSERT INTO bfd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tsiꞌì ma waà ŋ̀gàŋàfàꞌà à ghə̀ mə yu kɨ fɛ̀ꞌɛ, m̀boo ŋû nɨ̀bô wàà yî mɔ̀ꞌɔ yìi à lɛ sɨ bàŋnə̀ ǹtswa nii nɨ ǹtsùꞌù ji nɨghum, m̀faŋ a ntɔŋ, nswoŋ mə, ‘Tu ŋkabə̀ yà yâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A wô ghu nsi, ǹyəꞌə mə, ‘tswa ntɨɨ̀ gho a nu mə̀, wa mə̀ ka yǐ tu ŋkabə̀ yò yâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","A tuù yi, ǹswuŋ yi ŋghɛɛ nɨ ghu, ŋghɛɛ nnɨŋə a ndâtsaŋ mə tâ à tswe ghu nyweꞌe a noò yìi à ka yǐ tu nɨkarə̀ ni nya aà. ");
INSERT INTO bfd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nòò yìi mə ŋgǎŋfàꞌà jya jî mɔꞌɔ ɨ lɛ nyə ma ya ànnù aa, nû yàà ɨ bɨꞌɨ tsiꞌì nɨ̂ m̀bə̂nnù. Bo ghɛɛ̀ ŋ̀kɛꞌɛnə ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi ɨ lɛ mfɛ̀ꞌɛ̀ aa a mbô m̀fɔ̀ wâ. ");
INSERT INTO bfd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","M̀fɔ̀ wa à lɛ ntwoŋə yi a zî a swoŋ ghu mbo mə, ‘Wò ŋ̀gàŋàfàꞌà àbɨ̀ꞌɨntɨɨ̀, mə̀ kɨ̀ lɛ mmàꞌàtə̀ nɨkarə nya nɨ̀ tsɨ̀m nìi ò lɛ ntswa gha ghu aa, nloŋ ajàŋ mə ò lɛ nyə̀ꞌə̀ a mbo mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ò kɨ̀ waꞌà zî àjàŋə mə mbə ò ko mɨ̀lɨ̀ŋnə̀ ǹdɨm ghò, tsiꞌì tsǒ ajàŋ mə mə lɛ ŋko ghò aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","M̀fɔ̀ wa à lɛ nlwìnsə ntɔŋ, ntwoŋ ŋgǎŋmfɨ̀ɨ bə̀, m̀fa yi a mbo bo mə bɨ̀ ghɛɛ mfɨ̀ɨ̀ yi nyweꞌe a noò yìi à ka yǐ tu nɨkarə̀ ni nya nɨ̀tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Àa ajàŋə mə Taà ghà mə à tswe a aburə aa, àa yi ghɨ̀rə a nu bù bɨtsɨ̀m, mə mbə nɨ̀ tsuu ɨfansənnǔ bɨlɨ̂m buu a mûm ǹtɨɨ bù ɨ kɨ lìꞌìnə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nòò yìi mə Yesu à lɛ màŋsə nswoŋ ma jû ɨ̀nnǔ tsɨ̀m aa, à lɛ màꞌàtə alaꞌa Galilea ŋghɛɛ a mbuꞌu Yudea a njii ŋ̀kǐ Jordan, ");
INSERT INTO bfd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mɨ̀nɔ̀ɔ̀ mɨ bə̂ mî ghàꞌàtə̀ lɛ nyòŋə̀ yi, a ghurə̀ mɨ̀ghɔ̀ɔ̀ a nu bo maa adɨgə. ");
INSERT INTO bfd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","BaFarisai bî mɔꞌɔ bɨ lɛ nzì, a ŋkwàꞌànə̂ yi, mbetə yi mə, “Nɔ̀ŋsə̀ a bìi mə mbə ŋù a fiꞌi ŋgwɛ̂ yì ǹloŋ annǔ tsu mə à ghɨ̀rə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A betə̀ waa mə, “Nɨ̀ lɛɛ̀ ŋ̀kɨꞌɨ̀ twoŋ mə, ŋù yìi à lɛ naŋsə waa nlɔgɨnə a nlɔ̀gɨ̀nə aa, à lɛ naŋsə waa aa ŋùmbâŋnə̀ bo mâŋgyɛ̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ǹtɨgə nswoŋə nɨ mə, ‘Tsǒ mə a bə laà, ŋùmbâŋnə̀ à ka kɨ màꞌàtə̀ taà yì bô ǹdè yì, ɨ zǐ bòònsə̀ bô ŋ̀gwɛ̂ yì, tâ bo bi baa tɨgə mbə njyǎnu yì m̀fùùrə̀ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Maa ajàŋ kaa tâ bo waꞌà bə̂ bi baa bù m̀bə, ntɨgə mbə njyǎnu yì m̀fùùrə̀. Àyoo yìi mə Nwìŋgɔ̀ŋ à bòònsə̀ mə̂ aa, tâ ŋù tsù à tsuu lǒ yàtə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bo bû m̀betə yi mə, “Moses à lɛ ntɨgə nswoŋ mə mbə ŋù à tse fa aŋwàꞌànə nsàꞌa nɨ̀yɔꞌɔ a mbo ŋ̀gwɛ̂ yì, ɨ fiꞌi yi aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A kwiꞌi a mbo bo mə, “Moses à lɛ mbeentə mə mbə ŋù kâ m̀fiꞌi ŋgwɛ̂ yì aa nloŋ ajàŋ mə mɨ̀ntɨɨ̀ muu tɨɨ aà. Lâ kaa a waꞌǎ aa ajàŋ mə a lɛ ntswe a nlɔ̀gɨ̀nə aa bə̂. ");
INSERT INTO bfd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mə̀ swǒŋ a mbo bù mə mbə ŋù a fiꞌi ŋgwɛ̂ yì a nda yu, ntsuu nloŋ aa annǔ atsùùrə̀ bə, m̀bu nyɔꞌɔ yî dàŋ, bəə boŋ à ghɨ̀rə aa annǔ mâghàbə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ŋ̀gǎŋyəgə̂nnù ji ɨ betə̀ yi mə, “M̀bə a bə ma mùu ajàŋ a tɨtɨ̀ɨ ŋùmbâŋnə̀ bô ŋ̀gwɛ̂ yì a kɨꞌɨ̀ kùꞌùnə̀ aa bə mə tâ ŋùmbâŋnə̀ wa a tswe yi tɨ yɔꞌɔ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lâ a kwiꞌi a mbo bo mə, “Ànnù ma yû mə mə dɨ̀ꞌɨ̀ aa, kaa mbə a kɨꞌɨ a mbo ŋù ǹtsɨ̀m ghɛɛ̀. M̀bə a kɨ̂ ŋ̀ghɛɛ aa tsiꞌǐ a mbo bə̀ bìi mə Nwìŋgɔ̀ŋ à tsɔ̀ꞌɔ mfa a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ǹloŋ mə bə̀ bǐ mɔꞌɔ à nɨ bɨ̀sɔ̀ŋ aa a njwê, bǐ mɔꞌɔ, bɨ ghɨrə̀ nɨ̂ m̀bô, bǐ mɔꞌɔ bɨ ghɨrə̀ ɨ̀bɨ̀ɨnû waa maa ajàŋ mbɨꞌɨ aa annù nɨfɔ̌ aburə. Ŋù yìi mə mbə kwɛrə̌ annù ma yû mə mə dɨ̀ꞌɨ̀ aa, tâ à kwɛrə.” ");
INSERT INTO bfd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bə̀ bî mɔꞌɔ lɛ nzì nɨ bôŋkhə ghu mbo mə tâ à nɔŋsə mbô mi a atu bo ntsaꞌatə Nwî. Ŋ̀gǎŋyəgə̂nnù ji ɨ wenə̀ bə̂ byâ. ");
INSERT INTO bfd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lâ Yesu a swoŋ mə, “Nɨ̀ maꞌatə bɔɔ bya tâ bɨ̀ zi a mbo mə̀, ǹtsuu waa kɨ kɨ̀ŋə̀ bə̂; ǹloŋ mə annù nɨfɔ̌ aburə a tswe aa a mbo bə̀ tsǒ bo.” ");
INSERT INTO bfd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","À swòŋ mə̂ laà aa ntɨgə nnɔŋsə mbô mi a atu bo, ŋghɛɛ yi. ");
INSERT INTO bfd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ŋù yî mɔ̀ꞌɔ à lɛ nzì ghu mbo mbetə yi mə, “Ǹdɨ̀ꞌɨ̀nnù, ànnù yî sɨgɨ̀nə̀ yìi mbə mə̀ kâ ŋ̀ghɨrə nyi ŋkuu a mûm ǹtswêntɨ̀ɨ̀ yìi ɨ̀ lwìꞌi nɨ̂ŋkoŋ aa à nɨ yu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu a betə yi mə, “Ò bètə gha nloŋ annù yî sɨgɨ̀nə̀ aa a ya aa ɛ? Wa ŋù yìi à bɔ̀ŋ aa, à nɨ tsiꞌì ŋù yî m̀fùùrə̀. M̀bə ò ka ŋkɔŋ mə o kuu a mûm ǹtswêntɨ̀ɨ̀, ò kâ ǹləə ndɨꞌɨ Nwî jyâ.” ");
INSERT INTO bfd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A betə Yesu mə, “Ɨ juu aa ɛ?” Yesu a kwiꞌi ghu mbo mə, “Tsèe ŋû zwitə. Tsèe annǔ mâghàbə ghɨ̀rə̀. Tsèe yə̀rə̀. Tsèe abàŋnənnù tswɛɛ. ");
INSERT INTO bfd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ka nyuꞌunə taà ghò bô ǹdè ghò. Ka ŋkɔ̀ŋə̀ nɨ ndɨm ghò tsǒ ɨ̀bɨɨ nû ghô.” ");
INSERT INTO bfd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mûŋgwàꞌà wa a kwiꞌi ghu mbo mə, “Mə̀ lə̀ə̀ mə ndɨꞌɨ ma jû tsiꞌì tsɨ̀mə̀, a tɨ̀gə mboŋ akə a mbo mə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu a kwiꞌi ghu mbo mə, “M̀bə ò ka ŋkɔŋ mə òo bɔ̌ŋ màŋsə̀, ò ghɛɛ̀ m̀fee ŋgɔ̀ŋ ǹjoò tsɨ̀m jìi ò tswe nɨ ju aa, mfa a mbo ŋgàŋə̂fumə, nzi ŋka yoŋə naa, boŋ ò ka tswe nɨ̂ àfùꞌù a aburə.” ");
INSERT INTO bfd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mûŋgwàꞌà wa à yùꞌù mə̂ ma yû ànnù aa, ǹlo ŋghɛ̀ɛ̀ yi nɨ̂ àjəŋnə̀ ǹloŋ mə ǹjoò ji ɨ lɛ ŋghaꞌa. ");
INSERT INTO bfd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu a tɨgə̀ ǹswoŋ a mbô ŋ̀gǎŋyəgə̂nnù ji mə, “Mə̀ swǒŋ tsiꞌǐ annù nɨ̂koŋ a mbo bù mə a tsyanə a mbo ŋ̀gàŋkabə a ŋkuu a mûm ànnù nɨfɔ̌ aburə. ");
INSERT INTO bfd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mə̀ bu ŋkùꞌùsə̀ ǹswoŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, a fwaatə a mbo kamɛl a ntsurə a nɨliꞌi nɨ nsaꞌa, ntsyatə a mbô ŋ̀gàŋkabə a ŋkuu a mûm ànnù nɨfɔ̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ŋ̀gǎŋyəgə̂nnù ji yùꞌù mə̂ ma yû ànnù aa, ànnù a tsyâ waa tsiꞌǐ mbə̂nnù. Bo tɨgə̀ m̀betə yi mə, “Ŋù yìi mbə a yweenə̀ aa a tɨgə̀ m̀bə aa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu a liì ǹsî waa nswoŋ a mbo bo mə, “A tsyà aa ŋùmɨ̀sɔ̀ŋ, lâ a ghɛ̀ɛ nɨ Nwì, mbə à tse ghɨ̀rə ɨnnù tsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peta à kwiꞌi nswoŋ mə, “Yə̂, bìꞌì bìi bìꞌì màꞌàtə̀ mə ŋgɔ̀ŋ ǹjoò tsɨ̀m ǹyoŋə gho aa, bìꞌì ka yǐ tɨgə nnaŋsə tswe aa nɨ̀ àkə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu a swoŋ a mbo bo mə, “Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋ mə wa a mûm m̀bi yì m̀fii, wa a noò yìi mə Mu Ŋù à ka yǐ ŋaŋnə a nɨ̂ àbə̀rə̀ nɨghaꞌa yu aa, bù bya bìi mə nɨ̀ lɛ ŋka nyoŋə nàa aa, nɨ̀ ka yǐ kɨɨ ŋaŋnə nɨ̂ ɨ̀bə̀rə̀ nɨghûm ǹtsò baa, ɨ tɨgə saꞌa ɨtsə baIsrael jya nɨ̀ghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ŋù ǹtsɨ̀m yìi à màꞌàtə mɨlaꞌà mi, kə̀ bɨ̀lɨ̂m bi, kə̀ bɨ̀jààntə̂ bi, kə̌ taà yì, kə̌ ndè yì kə̀ bɔɔ̀ bi, kə̌ ɨbwɛ̀nə nsyɛ̂ ji, nloŋ ɨkûm gha aa, à ka yǐ bǔ tswe nɨ̂ ǹjoo mà jya ŋ̀gàa ŋkhɨ̀; ɨ kɨ bǔ tswe nɨ̂ ǹtswêntɨ̀ɨ̀ yìi ɨ̀ lwìꞌi nɨ̂ŋkoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lâ bə̀ bî ghàꞌàtə̀ bìi mə à nɨ bɨ̂tsyà bɨ mbìì tsɨ̂tsɔ̀ŋ aa, bɨ ka yǐ tɨgə bə bɨtsɨrə bɨ njɨ̀mə̀, tâ bɨ̀tsɨrə bɨ njɨ̀m tɨgə mbə bɨtsyà bɨ mbìì.” ");
INSERT INTO bfd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ǹloŋ mə ànnù nɨfɔ̀ aburə a bə aa tsiꞌì tsǒ ajàŋ yìi mə ŋù yî mɔ̀ꞌɔ à lɛ mfɛ̀ꞌɛ̀ tsiꞌì a tɨ̀tugə a mbàꞌa mbàꞌà ŋ̀ghɛɛ a nlɔ̀ɔ̀ bə̂ mə bɨ̀ zi mfàꞌà a akǒ mɨlùꞌu yu. ");
INSERT INTO bfd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","À lɛ mbii mə yu ka tu waa nɨ̂ ŋ̀kabə yìi ɨ̀ kùꞌùnə nɨ̂ ɨ̀fàꞌa njwi yì m̀fùùrə̀ aà, ǹtɨgə ntoo waa wa mûm àkò mɨlùꞌu yu. ");
INSERT INTO bfd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","À bù mə̂ m̀bə a nlòòntə nòò, a bû m̀fɛꞌɛ ŋghɛ̀ɛ̀ ǹyə bə̂ bî mɔꞌɔ bɨ təə a nsaanə mɨtaa tsiꞌì àdàŋà dàŋà; ");
INSERT INTO bfd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","a swoŋ a mbo bo mə, ‘Nɨ̀ kɨ ŋghɛɛ wa mûm àkò, wa mə̀ ka ghɨ̀rə fa ayoo yìi mə a kuꞌunə aa a mbo bù.’ ");
INSERT INTO bfd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bo tɨgə̀ ŋ̀kɨ ŋghɛɛ. A bû m̀fɛꞌɛ a nsiꞌi nòò bo bɨ̀ a nyə̌ŋ nòò, ŋkɨ ŋghɛɛ ŋghɨ̀rə̀ tsiꞌì wa ajàŋ mə à lɛ ŋghɨ̀rə a mbìì aà. ");
INSERT INTO bfd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","À bə̀ mə a mbǎŋ nòò, a bû ŋ̀ghɛɛ nyə bə̂ bî mɔꞌɔ bo təə, a swoŋ a mbo bo mə, ‘Nɨ̀ siꞌi ntəə faà m̀bwɛsə nɨ̂ ǹjwi yù a adàŋə̀ dàŋə̀ aa a ya aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bo kwiꞌi ghu mbo mə, ‘Kaa ŋù tsù à ghɨ̀rə waꞌà yiꞌi lɔgə̀ mə bìꞌì zi mfàꞌà a mbo yu.’ A swoŋ a mbo bo mə, ‘Nɨ̀ kɨ ŋghɛɛ ŋka mfaꞌa wa mûm àkò.’ ");
INSERT INTO bfd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nòò ǹtso nòò à kùꞌù mə̂ m̀bɔŋə̀ àkò mɨlùꞌù wa a swoŋ a mbô ŋ̀gàŋǹlèntə̂ ǹjoò yì mə, ‘Twoŋ ŋgǎŋfàꞌà jya ntu ŋkabə̀ yàà, ǹlɔgɨnə nɨ bǐ nlwìꞌì ǹjɨ̀m bya, ŋkɔꞌɔ mmàŋsə̀ nɨ bǐ ntsyàmbìì byâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Bə̀ bya mə bɨ lɛ nlɔ̀gə̀ waa a noò m̀baŋ nòò aa bɨ zì mə̂, ŋù yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ a kwɛrə̀ ŋ̀kabə yìi mə ɨ̀ kùꞌùnə a ntû ŋ̀gàŋàfàꞌà ghu a atû ǹjwi aà. ");
INSERT INTO bfd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nòò yìi mə bɨ̀tsyà bɨ mbìì bya bɨ lɛ nzì aa, bo lɛ ŋwaꞌatə mə ɨ̀ yàa ŋkabə ɨ̀ ka ghaꞌatə; la ŋù ǹtsɨ̀m a kɨ̂ ŋ̀kwɛrə tsiꞌì ŋ̀kabə yìi mə bɨ tu ŋû ghu a atû ǹjwi aà. ");
INSERT INTO bfd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bo kwɛ̀rə̀ mə̂, ǹlɔgɨnə ŋka nwurɨkə a mbɔ̂ŋ àkò wâ, ");
INSERT INTO bfd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ǹswoŋə nɨ mə, ‘Bə̀ bi nlwìꞌì ǹjɨ̀m bû bɨ faꞌa aa tsiꞌì a atu mu fɨ̀bàŋtə̀, lâ bìꞌì bâŋnə̀ ǹsiꞌi nyɔꞌɔ nɨ̂nòò m̀faꞌa njwi yǔ ntsɨ̀m, ò tû ŋ̀kabə̀ yiꞌibo ɨ kuꞌùnə̀!’ ");
INSERT INTO bfd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","M̀bɔ̂ŋ àkò wa a kwiꞌi a mbo ŋù nɨ̀bô wàà yî mɔ̀ꞌɔ mə, ‘Ǹsûkàꞌa ghà, kaa mə̀ sɨ̌ annù a mbo wò fânsə̀; ò ghɨ̀rə waꞌà bii aa mə ò ka kwɛrə aa ŋ̀kabə yìi mə ɨ̀ kùꞌùnə nɨ̂ ɨ̀fàꞌa njwi yì m̀fùùrə̀ aa a mbo mə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Lɔ̀gə ŋkabə̀ ò ya ŋghɛ̀ɛ̀ ghô; à wa a kɔ̌ŋ mə̀ ŋ̀kɔŋ a ŋkɨ mfâ àyoo yìi mə mə̀ fa a mbo wò aa a mbo ŋù ǹlwìꞌì ǹjɨ̀m ghû.’ ");
INSERT INTO bfd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“M̀bə mə̀ waꞌǎ annù yìi mə̀ kɔ̀ŋ aa nɨ̀ ǹjoo jìi mə à nɨ̂ ɨ̀ ja aa ghɨ̀rə̀ aa ɛ? Kə̀ nɨ ghə̀ꞌə̀nə̀ aa gha nloŋ mə mə fa aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu a tɨgə̀ ǹlwiꞌisə nswoŋ mə, “Ma mùu ajàŋ, bɨ̀lwìꞌì bɨ njɨ̀m ka yǐ bə bɨ̂tsyà bɨ mbìì, tâ bɨ̀tsyà bɨ mbìì tɨgə mbə bɨ̂ lwìꞌì bɨ njɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu à kà mə̂ aa ŋkɔꞌɔ ŋghɛɛ a Yerusalem, ǹlɔgə ŋgǎŋyəgə̂nnù ji jyâ ǹtsò baà, a tswê tsiꞌì bò bo. Bo kà mə̂ aa ŋghɛɛ a mânjì a swoŋ mbo bo mə, ");
INSERT INTO bfd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yə̂ nɨ̀, àjàŋə mə bìꞌinə ŋkɔꞌɔ ŋghɛɛ nɨ a Yerusalem laà aa, bɨ ka tswa Mu Ŋù ɨ fa a mbo bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌanwì bo bɨ̀ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ tâ bo tsɔꞌɔtə ɨsaꞌà yi ǹtsərə mə bɨ̀ zwitə yi, ");
INSERT INTO bfd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","tâ bɨ̀ fa yi a mbo bɨ̀tɨ̀zî Nwî tâ bo wyɛ yi, ŋ̀ghɔɔ yi, ŋ̀kweentə yi a atu atibàŋnə̀ bàŋnə̀; lâ a tɨ bə nɨ̂ ǹjwi ji tarə bɨ bû m̀bɨɨnsə yi nɨwô.” ");
INSERT INTO bfd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ǹdè bɨ̀ bɔɔ bɨ Zebedee à lɛ ntɨgə nzi a mbo Yesu bo bɨ̀ bɔɔ̀ bi, ǹswɛtə mɨkuꞌutə̂ mi ghu nsi, ǹlɔɔ annù yî mɔꞌɔ ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu a betə̀ ghu mbo mə, “O lɔ̀ɔ̀ aà àkə̀ aa ɛ?” A kwiꞌi ghu mbo mə, “Bii mə tâ bɔɔ̀ aa bù bi baa bɨ̀ yi ntswe a mûm ànnù nɨfɔ̌ wò, tâ yì mɔ̀ꞌɔ a tswe a abo wò yî màꞌà, tâ yì mɔ̀ꞌɔ a tswe a abo wò yî ŋ̀kwàbə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu a kwiꞌi a mbo bɔɔ bya mə, “Kaa nɨ̀ sɨ̌ annù yìi mə nɨ betə aa zî. M̀bə nɨ̀ nô ǹdɔŋ yìi mə mə̀ ka no aa ɛ? ” Bo kwiꞌi gho mbo mə, “M̀bə bìꞌì nô.” ");
INSERT INTO bfd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu a swoŋ a mbo bo mə, “Tsiꞌǐ annù nɨ̂ŋkoŋə̀, nɨ̀ ka no ndɔŋ yìi mə mə̀ tswe nɨ̀ nno aà, tâ bɨ̀ kɨ mmurə ghuu a mûm ŋ̀kì a ajàŋ yìi mə bɨ tswe nɨ̀ m̀mùrə mə̀ ghu aà. La kaa a sɨ adɨgə ya bə̂ a ntsɔꞌɔ bə̀ bìi mə bɨ ka yǐ tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ mə̀ nî màꞌà kə̀ nî ŋ̀kwàbə̀ aà, a nɨ̂ ɨ̀dɨ̀gə̀ ma jû aa a ka yǐ tswe bə̂ bìi mə Taà ghà à nàŋsə nlə̀ə̀ a mbo bo aà.” ");
INSERT INTO bfd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Àbùgə ŋgǎŋyəgə̂nnù jya nɨ̀ghum ɨ yùꞌù mə̂ ànnù ma ya, ǹlwisə ntɔŋ a nu bo bya bi baà. ");
INSERT INTO bfd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lâ Yesu a twoŋə̀ waa bɨtsɨ̀m, ǹswoŋ mə, “Nɨ̀ zi mə bə̀ bìi mə bɨ saꞌa bɨ̀tɨ̀zî Nwî aa, bɨ nɔŋ aa atu bo, m̀buꞌutə nɨ̂ waa; bə̀ bî wè byaa bɨ tswê nɨ̂ àdàꞌà a atu bo. ");
INSERT INTO bfd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kaa m̀bə waꞌǎ maa ajàŋ a tɨtɨ̀ɨ bù bə̂; ŋù yìi mə a lɔ̀ɔ mbə ŋù yî ŋ̀wè a tɨtɨ̀ɨ bù aa, tâ à bə ŋgàŋàfàꞌâ ghùù, ");
INSERT INTO bfd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","tâ ŋù yìi mə a lɔ̀ɔ mbə ǹtsyàmbìì aa, tâ à bə abùꞌû yuu; ");
INSERT INTO bfd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ǹloŋ mə, tsiꞌì Mu Ŋù, kaa à lɛ ŋwaꞌà zì aa mə tâ bɨ̀ ka mfaꞌa ghu mbô. À lɛ nzì aa a mfàꞌa a mbo bə̀, ɨ kɨɨ fa ntswêntɨ̀ɨ̂ yì a ntsuꞌu atu bə̂ bî ghàꞌàtə̀ ghu.” ");
INSERT INTO bfd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù jì kà mə̂ aa mfɛꞌɛ a Jericho, mâmbêm ǹnɔ̀ɔ̀ a kâ ǹyoŋə waa. ");
INSERT INTO bfd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bɨ̀fə̀ꞌə̀nə̀ bi baa lɛ ntswe a mbɛ̀ɛ̀ mânjì ǹyuꞌu mə Yesu a tsyà. Ǹlɔgɨnə ntɨgə ntɔŋnə nswoŋə nɨ mə, “Ko mɨlɨ̀ŋə̀ yìꞌì, Mu David!” ");
INSERT INTO bfd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ǹnɔ̀ɔ̀ wa ɨ wenə̀ waa nswoŋ mə tâ bo kutə ntsǔ waa; la bo bâŋnə̀ ŋ̀kuꞌusə ntɔŋnə nswoŋ mə, “Mmàꞌàmbî, ko mɨlɨ̀ŋnə̀ yìꞌì, Mu David!” ");
INSERT INTO bfd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu à lɛ ntəə ntwoŋə waa mbetə mə, “Nɨ lɔ̀ɔ̀ aa mə tâ mə̀ ghɨrə mə akə nɨ bù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bo kwiꞌi mə, “M̀màꞌàmbî, ghɨ̀rə tâ bìꞌì bu ŋka nyə ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu à lɛ ŋko mɨlɨ̀ŋnə̀ wàà, m̀mɔɔntə miꞌì myaa, bo ghɛ̂sə̀ ǹlɔgɨnə ŋka nyə ɨdɨgə, ǹlo ntɨgə nyoŋə nii. ");
INSERT INTO bfd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bô ghɛ̀ɛ̀ mə̂ ŋ̀ka yweꞌe a Yerusalem ŋ̀kuu a Betfage yìi à lɛ ntswe a njiꞌì ǹtaꞌa Olive aà. Yesu a toò ŋ̀gǎŋyəgə̂nnù ji ji baa a mbìì ");
INSERT INTO bfd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ǹswoŋ a mbo bo mə, “Nɨ̀ ghɛɛ fìi a nɨ mû àlaꞌa yì a mbìi bù, àjàŋ yìi nɨ̀ ka ghɛ̀ɛ kɨ kuu aa, ɨ yə jàkasì yìi bɨ tɨŋnə bo mu yì. Nɨ̀ yə, nɨ̀ fɛɛ̀ ǹzi nɨ ju mfa a mbo mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bɛɛ ŋù a betə annù a mbo bù, nɨ̀ swoŋ ghu mbo mə, ‘A lɔ̀ɔ Mmàꞌàmbî,’ boŋ à ka tɨgə ghɛ̀sə swoŋ tâ nɨ̀ lɔgə.” ");
INSERT INTO bfd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ma yû ànnù a lɛ mfɛ̀ꞌɛ̀ aa a nlwensə̂ ànnù ya yìi mə ǹtoò Nwì à lɛ nswoŋ aa mə, ");
INSERT INTO bfd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Swoŋ a mbo bɔɔ bɨ Zion mə, ‘Yə̂ nɨ̀, m̀fɔ̀ ghùù à ghuà mə a zì a mbo bù aà!’ À sɨ̀gɨ̀sə ɨ̀bɨ̀ɨnû yi a nsyɛ, ŋkɔꞌɔ a atu jàkâsì, a bə tsiꞌì mu jàkâsì yî ŋ̀kə̀gə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ lɛ ntɨgə ghɛɛ ŋkɨ ŋghɨrə tsiꞌì ànnù ya mə à lɛ nswoŋ mə tâ bo ghɨrə aà; ");
INSERT INTO bfd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bo lɛ nzì nɨ jàkâsì wa bo mû yì, ǹnɔŋsə ɨtsə̀ꞌə̂ jyaa a njɨ̌m nnàà jya a tɨgə̀ ŋ̀kɔꞌɔ ntswe ghu. ");
INSERT INTO bfd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bə̀ bî ghàꞌàtə̀ wa a tɨtɨ̀ɨ nnɔ̀ɔ̀ wa lɛ nsàŋtə ɨtsə̀ꞌə̂ jyaa a mânjì, bǐ mɔꞌɔ kwyɛ̂ ǹtaa ɨti ŋkɨ saŋtə wa a mânjì. ");
INSERT INTO bfd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ǹnɔ̀ɔ̀ yìi ɨ lɛ sɨ ghɛ̀ɛ a mbìì bo bɨ̀ yìi ɨ lɛ sɨ yòŋə a njɨ̀mə̀ aa ɨ lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka ntɔŋnə mə, “Hosiana, a mbo Mu David! Bìꞌinə̀ ghaꞌasə yu wa yìi mə a zì nɨ̂ ɨ̀kǔm Mmàꞌàmbi aà! Hosiana a mbô Nwì Àkɔꞌɔ̀ntsɨrə!” ");
INSERT INTO bfd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu à kɔ̀ꞌɔ̀ mə̂ ŋkuu a mûm ǹjɔ̀ꞌɔ̀ àlaꞌà Yerusalem aa, ɨ̀dɨ̀gə tsɨ̀m ghu ɨ tɨgə̀ tsɨgɨnə tsiꞌì ǹtsɨ̀gɨ̀nə̀, bə̀ tɨgə̀ m̀betə nɨ mə, “Àâ wòô ghûlà aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ǹnɔ̀ɔ̀ wa ɨ kwiꞌi mə, “Àa Yesu, ŋ̀gàŋntoò Nwì yìi mə à lo a Nazareth a mbùꞌu Galilea aà.” ");
INSERT INTO bfd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu à lɛ ŋghɛ̀ɛ̀ ŋ̀kuu a mûm ǹdâmàꞌanwì, m̀furə bə̂ bɨ̀tsɨ̀m bìi bɨ lɛ ntswe ghu mfee nɨ̂ ǹjoo ŋkɨɨ nyuu aà. À lɛ ntii ɨtɛtə̌ bə̂ bìi mə bɨ lɛ sɨ kwensə nɨ̂ ŋ̀kabə bo bɨ̀ ɨ̀lə̀ŋ bə̀ bìi mə bɨ lɛ sɨ fèè nɨ̂ bɨ̀ bugɨrəmɨ̀kuu aa mmàꞌànə̀ a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ǹswoŋ a mbo bo mə, “Bɨ ŋwaꞌanə a mûm àŋwàꞌànə Nwì mə, ‘Bɨ ka yǐ kɨ twoŋ ndâ yà aa nɨ̂ ǹdâ ǹtsàꞌàtə Nwì.’ Lâ nɨ̀ ghɨ̀rə̀ mə̂ ɨ tɨgə̀ m̀bə a adɨgə nlə̀ə̀ntə bɨ̀yə̀rə̂!” ");
INSERT INTO bfd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bɨ̀fə̀ꞌə̀nə̀ bo bɨ̀ bɨ̀bwènkə̀ lɛ nzì ǹtsiꞌi yi wa ndâmàꞌanwì, a ghurə̀ waa. ");
INSERT INTO bfd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bɨ̀lɨɨ bɨ ŋgǎŋmàꞌanwì bo bɨ̀ ŋ̀gǎŋndɨꞌɨ nɔ̀ŋsə̀ yə̀ mə ɨnnǔtsyâmbo jya jìi mə à lɛ ghɨ̀rə̀ aa, ŋkɨ nyə bɔɔ bya mə bɨ lɛ ntswe wa ndâmàꞌanwì ǹtɔŋnə nɨ mə, “Hosiana a mbo Mu David!” aa mɨ̀tɔ̀ŋə̂ myaa bâŋnə̀ ǹlwi lwì, ");
INSERT INTO bfd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","bo swoŋ a mbo Yesu mə, “Ò yùꞌû ànnù yû mə bɔɔ bù swoŋə aa ɛ?” Yesu a kwiꞌi mə, “Ɨ̀ɨ̀ŋə; nɨ̀ lɛɛ̀ ŋ̀waꞌà twoŋ, a mûm àŋwàꞌànə Nwì mə, ‘Wò Nwì ò ghɨ̀rə̀ mə mə tâ bɔɔ bì bɔrə bo bɨ̀ bìi bɨ burə aa kɨ nɔŋsə aa tâ bɨ̀ ka mfa nɨghaꞌa nìi nɨ bɔŋ màŋsə̀ aa a mbo wò’ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu à lɛ ntɨgə mmaꞌatə waa, m̀fɛꞌɛ ŋghɛ̀ɛ a alaꞌa Bethany, ǹlɛ ghu. ");
INSERT INTO bfd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","À bə̀ mə a tɨ̀tugə a noò yìi mə à lɛ mbù ŋ̀ka ŋkuu ŋghɛɛ a Yerusalem aa, ǹjì ɨ yaŋə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A yə̂ àtì figə̀ yî mɔꞌɔ a mbɛ̀ɛ̀ mânjì, ŋ̀ghɛɛ ghu, kaa waꞌà fɨ̂ntà ghu yə a njɨ̂, a bâŋnə̀ ǹluu tsiꞌì ɨ̀yə̀ŋ ghu. A swoŋ a mbô àtì ya mə, “Tâ ò yǐ ntsùù fɨ̂ntà ɨ lǒ bǔ koonə!” Àtì ya lɛ kɨ mburə ŋghɛnsə nyoo ŋkwo. ");
INSERT INTO bfd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ŋ̀gǎŋyəgə̂nnù ji ɨ lɛ nyə ma yaà ànnù, ǹyɛrə, ǹswoŋ mə, “A ghɨ̀rə̂ àkə̀ àtì yû a burə̀ ŋ̀ghɛsə ŋkwo tsiꞌì lâ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu a kwiꞌi a mbo bò mə, “Mə̀ swoŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, nɨ̀ bə tswe nɨ̂ àbìintɨɨ ɨ tsuu kɨ jɨ̀ŋkə̀ bəə boŋ mbə nɨ̀ ghɨrə̀ ànnù yù mə mə̀ ghɨ̀rə a nû àtì figə̀ yû aà. Kaa waꞌǎ aa tsiꞌì ma yû ghɨrə̀ bə̂, boŋ m̀bə nɨ̀ tɛꞌɛ̀ ǹswoŋ bə a mbô ǹtaꞌa ghû mə, ‘Tsɔꞌɔnə nlò faà ŋ̀ghɛɛ nnàŋə a mûm ŋ̀kì mɨyaa,’ boŋ wa ɨ ka kɨɨ lǒ ghɛ̀ɛ nnàŋ ghu. ");
INSERT INTO bfd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nɨ̀ bə tswe nɨ̂ àbìintɨɨ boŋ nɨ ka kɨ kwɛrə nɨ̂ ŋ̀gɔ̌ŋ ɨnnǔ tsɨ̀m jìi mə nɨ betə nɨ a mûm àtsàꞌàtə̀ Nwî aà.” ");
INSERT INTO bfd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu à ghɛ̀ɛ̀ mə̂ ŋ̀kuu a ndâmàꞌanwì bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌanwì bo bɨ̀ bɨ̀tà bɨ alaꞌa zî ǹtsiꞌi yi ghu a noò yìi à lɛ sɨ dɨ̀ꞌɨ annù Nwî aà, m̀betə yi mə, “O ghɨ̀rə ɨnnù juà jìi mə o ghɨ̀rə̀ aa nɨ̂ àdaꞌa wo aa ɛ? A adàꞌà ma yû a mbo wò aa, a fa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu a kwiꞌi mə, “Mə̀ ka kɨɨ betə ghuu nɨ̂ àbetə̀, bɛɛ mə nɨ̀ fa akwiꞌi a mbo mə̀ bəə boŋ mə̀ ka kɨɨ swoŋə a adɨgə yìi mə mə̀ lɔ̀gə adaꞌa ya mə mə̀ tswe nɨ yu a ŋka ŋghɨ̀rə̂ ɨ̀nnù jû ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“Jɔn à lɛ nlɔ̀gə adaꞌa aa fə a ŋka mmurə bə̌ ŋkì aa ɛ? A lɛ nlò aa a mbo Nwì kə̀ a mbo bə̀ aa ɛ?” Bo lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka nswuŋnə bo nɨ bo nswoŋə nɨ mə, “M̀bə bìꞌinə̀ swoŋ mə ‘A lɛ nlò aa a mbo Nwì,’ boŋ à ka swoŋ a mbo bìꞌinə̀ mə, ‘Nɨ̀ lɛɛ̀ ǹtɨgə waꞌǎ annǔ yìi mə àlɛ sɨ swoŋ bii aa a ya aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kə̀ m̀bə̂ bìꞌinə̀ swoŋ mə ‘A lɛ nlò aa a mbo bə̀,’ boŋ bìꞌinə̀ aa kɨ bɔꞌɔ nnɔ̀ɔ̀ bə̂ bù; ǹloŋ mə bə̀ bɨ̀tsɨ̀m bii mə Jɔn à lɛ mbə aa ŋ̀gàŋntoò Nwì.” ");
INSERT INTO bfd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Maa ajàŋ bo lɛ ntɨgə ŋkwiꞌi mə, “Kaa bìꞌì sɨ̀ zî.” A tɨgə̀ ǹswoŋ a mbo bo mə, “Kaa mə̀ ka waꞌà ŋû yìi mə̂ à fa adaꞌa mə̀ ghɨrə̀ nɨ̂ ɨ̀nnù jû ghu aa a mbo bù kɨ nswoŋə.” ");
INSERT INTO bfd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nɨ̀ mɔ̀ɔ̀ntə mə akə aa ɛ? Ŋù yì mɔ̀ꞌɔ à lɛ ntswe nɨ bɔɔ mbâŋnə̀ bi baa, ŋ̀ghɛɛ nswoŋ a mbo yì ǹtsyàmbìì mə, ‘Mû ghà, ghɛ̀ɛ mfàꞌà wa mûm àkò mɨlùlù siì.’ ");
INSERT INTO bfd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mu wa a kwiꞌi mə, ‘Kaa mə̀ ka waꞌà ghɛ̀ɛ̀.’ Lâ m̀bu ŋkwàꞌàtə̀ atû yi ŋghɛɛ. ");
INSERT INTO bfd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","À lɛ mbù ŋ̀ghɛɛ ntoo mu yì yìi à yweꞌe bi baa tsiꞌì maa ajàŋ; a kwiꞌi mə, ‘Wa mə̀ ka ghɛ̀ɛ̀, taà,’ la kaa waꞌà yi bâŋnə̀ ŋ̀ghɛɛ. ");
INSERT INTO bfd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Àa ghuu mu a tɨtɨ̀ɨ bɔɔ bya bi baa mə à lɛ ŋghɨ̀rə annù yìi mə taà yì à lɛ sɨ lɔ̀ɔ̀ aa ɛ?” Bo swoŋ mə, “Àa yì ǹtsyàmbìì wâ.” Yesu a swoŋ a mbo bo mə, “Mə̀ swǒŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, ŋgǎŋkwɛrə bɨ̀tax bo bɨ̀ ɨ̀kwàrə̀ ka yǐ fòo kuu a mûm ànnù nɨfɔ̀ Nwî tɨ bù. ");
INSERT INTO bfd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ǹloŋ mə Jɔn à lɛ nzì a mbo bù ǹdɨꞌɨ nɨ mânjì yìi à tsìnə̀ aa kaa nɨ̀ waꞌǎ annǔ yi biì. Lâ ŋ̀gǎŋkwɛrə bɨ̀tax bo bɨ̀ ɨ̀kwàrə̀ ɨ bâŋnə m̀bii. Ka mə nɨ̀ lɛ nyə annù ma yû aa, kaa nɨ̀ lɛ ŋwaꞌà mɨ̂ntɨɨ̀ muu kɨ mbəŋkə mbii annû yi. ");
INSERT INTO bfd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nɨ̀ yuꞌutə nɨghàà nî nanaa nî mɔꞌɔ. Ŋù yî mɔ̀ꞌɔ à lɛ mbě akò mɨlùꞌû yi, ǹjiꞌi ŋkya ŋ̀karɨsə ghu, ŋkɨ toŋ nɨgho nɨ nɨ̌ŋ mɨ̀lùꞌù wa mûm ŋ̀kyâ, m̀bɔɔ ndânɨ̀kàŋ yìi bɨ ka kɨ tswe ghu ɨ bɛ nɨ̂ àkò ya aà. À lɛ ntɨgə nlɛnsə akò ya a mbo bə̀, m̀fɛꞌɛ ŋghɛ̀ɛ̀ yi a atoo dàŋ. ");
INSERT INTO bfd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nòò ŋ̀kya mɨ̀ntà mɨ ati mɨ̀luꞌu mya à kùꞌù mə̂ a toò ŋ̀gàŋəfàꞌâ ji mə tâ bɨ̀ ghɛɛ ŋkwɛrə mɨ̂ntà mɨ ati mɨlùꞌù mya mi mɔꞌɔ a mbo bɨ̀lɛnsə bɨ akò byâ. ");
INSERT INTO bfd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bɨ̀lɛnsə bɨ akò bya lɛ ntswa ŋgàŋəfàꞌâ ji jya, ŋ̀ghɔɔ yî mɔ̀ꞌɔ, ǹzwitə yî mɔ̀ꞌɔ, ŋkɨ ntumntə yî mɔ̀ꞌɔ nɨ̀ ŋ̀gɔ̀ꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","À lɛ mbù ǹtoo ŋgàŋəfàꞌà jìi ɨ lɛ ŋghaꞌatə ntsya ji mbìì jya. Bo bû ŋ̀ghɨrə tsiꞌì ŋgɨ̌ŋgɨ̀ŋ a nu bo. ");
INSERT INTO bfd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A nlwìꞌìsə, a tɨgə̀ ǹtoo a mû yì m̀bâŋnə̀, ǹswoŋə nɨ mə, ‘Bo ka bɔꞌɔtə mû ghà ghû.’ ");
INSERT INTO bfd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lâ bə̀ byâ yə̀ mə mu wa, nswoŋ bo nɨ bo mə, ‘Àâ ǹjɨ̂ndâ yì à ghûlà mə, nɨ̀ zi bìꞌinə̀ zwitə yi tǎ tɨgə jɨ njoò ji jû.’ ");
INSERT INTO bfd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bɨ lɛ ntɨgə nlɔgə mu wa mmaꞌa a abɛɛ wa njɨ̀m ŋ̀kya mɨlùꞌù ǹzwitə yi. ");
INSERT INTO bfd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ma mùu ajàŋ nɨ̀ mɔɔ̀ntə̀ mə nòò yìi mə mbɔ̂ŋ àkò mɨlùꞌù wa à ka yǐ bɨ̀ɨ̀ aa, àa yǐ ghɨ̀rə mə akə nɨ bɨ̀lɛnsə bɨ akò bya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bo kwiꞌi mə, “Tsiꞌǐ annù nɨ̂ŋkoŋə̀, à ka yǐ naŋsə zwitə bɨ̂ku bɨ kweꞌèfɔ̀ ma bya, ɨ tɨgə lɛnsə akò mɨlùꞌù ya a mbo bǎdàŋ bìi mə bɨ ka kɨ fa mii mɨ̂ntà mɨ ati mɨlùꞌù mya a nɨ nòò yìi à kùꞌùnə aà.” ");
INSERT INTO bfd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu a bû ǹswoŋ a mbo bo mə, “Nɨ̀ lɛɛ̀ waꞌǎ nɨghàà nɨ Nwî nya twoŋ mə nɨ swoŋə mə: ‘Tsiꞌì ŋ̀gɔ̀ꞌɔ̀ ya mə bɨ̀bɔɔ bɨ nda bɨ lɛ ntuu aa, ɨ̀ bə̀ŋ mə̂ ǹtɨgə ŋgɔ̀ꞌɔ̀ nɨ̀buu nɨ nda yì ŋ̀wè; a ma yû ànnù aa a ghɨ̀rə Mmàꞌàmbî, a bə̂ ànnù yî yɛ̌yɛrə a mbo bìꞌì.’ ");
INSERT INTO bfd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ma mùu ajàŋ mə̀ tɨgə̀ ǹswoŋ a mbo bù mə, ‘Bɨ ka yǐ kwɛrə annǔ nɨfɔ̀ Nwî a mbo bù, ɨ fa a mbo bə̀ bɨ atoo dàŋ bìi bɨ ka kɨ koonə mɨ̂ntà mìi mɨ kuꞌunə a mûm ànnù nɨfɔ̀ aà.’  ");
INSERT INTO bfd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ŋù yìi à ka wǒ a nɨ̂ ŋ̀gɔ̀ꞌɔ̀ ma yû aa, à ka bəgɨkə; kə̀ bɛɛ mə ɨ wo a nu ŋù bəə boŋ ɨ̀ ka ghɔ̀ꞌɔ̀ yi.” ");
INSERT INTO bfd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bɨ̀lɨɨ bɨ ŋgǎŋmàꞌanwì bo bɨ̀ baFarɨsai lɛ nyuꞌu mɨghàà mî nàà mû aa, ǹzi mə Yesu à lɛ sɨ ŋghàà ǹloŋ aà ŋ̀gaà yàà. ");
INSERT INTO bfd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bo lɛ ntɨgə ŋka nlɔɔ a ntswâ yi, lâ m̀bɔꞌɔ nnɔ̀ɔ̀ wa, nloŋ mə nnɔ̀ɔ wa ɨ lɛ mbii mə Yesu à bə aa ǹtoò Nwì. ");
INSERT INTO bfd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu a ghɛ̀ɛ̀ nɨ̂ m̀bìì ŋ̀ghaa a mbo bo nɨ mɨ̀ghàà mî nanaa, ǹswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ànnù nɨfɔ̌ aburə mbə bɨ fɨgɨ̀nə̀ aa a nɨ mfɔ̀ yî mɔ̀ꞌɔ yìi mə à lɛ ŋkàꞌa adina nɨyɔꞌɔ nɨ mû yì yî m̀bâŋnə̀, ");
INSERT INTO bfd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ǹtoo ŋgǎŋfàꞌâ ji mə tâ bɨ̀ ghɛɛ ntwoŋ bə̂ bìi mə à lɛ ntwoŋə waa wa adɨgə adina nɨyɔꞌɔ aà; lâ bə̀ bìi mə à lɛ ntwoŋə waa aa kaa bo waꞌà kɔ̀ŋ a nzî. ");
INSERT INTO bfd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","À bû ŋ̀ghɛɛ nɨ̂ m̀bìì ǹtoo ŋgǎŋfàꞌâ ji ji dàŋ, ǹswoŋ a mbo bo mə, ‘Nɨ̀ ghɛɛ nswoŋ a mbo bə̀ bìi mə mə̀ twòŋə waa wa adɨgə adinà aa mə, Yə̂ nɨ̀, nòò adinà wa à kùꞌù mə̂, mə̀ wâ m̀bɔ̀ŋ bo bɨ̀ bɨ̀kaù bìi bɨ jɛꞌɛ bɨ naŋsə mfaŋkə aà, bɨ̀ kɨ̀ mə̂ ǹtaŋtə njoò tsɨ̀m nləə; nɨ̀ zi wa adɨgə àdinà nɨyɔꞌɔ̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lâ bə̀ bya mə bɨ lɛ ntwoŋə aa, kaa bɨ lɛ ŋwaꞌà waa laŋtə̀. M̀baŋnə ŋghɛ̀ɛ̀ nɨ̂ waa bə a adɨgə bo, yì mɔ̀ꞌɔ a ghɛɛ̀ yi a nsoo yu, yì mɔ̀ꞌɔ a ghɛɛ̀ yi a adɨgə mɨtaa yu, ");
INSERT INTO bfd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Àbùgə̂ yaa, bɨ tswâ ŋ̀gǎŋfàꞌà jya ŋ̀ghɔɔ waa tsiꞌǐ a mbə̂ ànnù ǹzwitə. ");
INSERT INTO bfd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ǹtɔ̌ŋ m̀fɔ̀ wa ɨ lwî siꞌi siꞌi, a too bɨ̀sogyɛ̀, bɨ ghɛɛ̀ ǹta ŋgɨꞌɨ a nu bə̀ bya mə bɨ lɛ nzwitə ŋgǎŋfàꞌâ ji jya aa, ŋkɨ ntɔɔ ǹjɔ̀ꞌɔ̀ àlaꞌâ yàà. ");
INSERT INTO bfd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","M̀fɔ̀ wa a ŋghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ a mbô ŋ̀gǎŋfàꞌâ ji mə, ‘Nòò ǹjɨ àdinà nɨyɔꞌɔ wa à kùꞌù mə̂, lâ bə̀ bìi mə mə̀ twǒŋ mə bɨ̀ zi fàa adɨgə adinà nɨyɔꞌɔ aa, à nɨ bɨ̀tɨ̀zî ɨ̀bɔ̀ŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nɨ̀ tɨgə ŋghɛɛ la a atu mɨ̂mfâŋnə̀ ǹtwoŋ bə̂ bɨ̀tsɨ̀m bìi mə nɨ̀ yə aa, mə bɨ̀ zi fàa adɨgə adinà nɨyɔꞌɔ̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma jyâ ŋ̀gǎŋfàꞌà ɨ fɛꞌɛ̀ ŋ̀ghɛɛ a atu mɨ̂ŋfâŋnə̀, ŋ̀ghotə bə̂ bɨ̀tsɨ̀m bìi mə bo lɛ nyə aa, bì bɨ, bo bɨ̀ bì sɨgɨ̀nə̀; maa ajàŋ ǹdâ àdinà nɨyɔꞌɔ ya ɨ luu nɨ̀ bɨ̀gɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Lâ m̀fɔ̀ wa à kùù mə̂ a nlèntə bɨ̀gɨ̀ɨ̀ bìi bɨ lɛ ntswe wa ndâ àdina aa, ǹyə ŋù yì mɔ̀ꞌɔ yìi mə kaa à lɛ ŋwaꞌǎ atsə̀ꞌə̂ àdinà nɨyɔꞌɔ màꞌà; ");
INSERT INTO bfd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","m̀betə yi mə, ‘Ǹsûkàꞌâ ghà, ò tsyà aa mə akə, ŋkuu a adɨgə adinà nɨyɔꞌɔ tɨ̂ àtsə̀ꞌə̀ nɨyɔꞌɔ aa ɛ?’ Kaa ŋù wa a waꞌǎ nɨ̂ ànnù yî àkwìꞌì tswê. ");
INSERT INTO bfd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","M̀fɔ̀ wa a swoŋ a mbo bɨ̀tsè bɨ ndâ bi mə, ‘Nɨ̀ kwerə mbô mi bo bɨ̀ mɨ̀kòrə̂ mi, mmaꞌa yi a abɛɛ a mûm m̀fìî ɨ̀dɨ̀gə̀; a adɨgə yìi mə bə̀ ka yǐ kɨ yə̀ꞌə̀ ghu ɨ kurə nɨ mɨ̀sɔ̀ŋə̂ myaa aà.’ ");
INSERT INTO bfd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ǹloŋ mə bɨ twoŋ aa bə̀ bî ghàꞌàtə̀, m̀baŋnə ntsɔꞌɔ tsiꞌì m̀bùmtə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","BaFarɨsai bɨ ghɛɛ̀ ǹtaŋ mɨnàŋ a ntswâ yi a nɨ nɨ̀ghàâ ni. ");
INSERT INTO bfd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bo toò ŋ̀gǎŋyəgə̂nnù jyaa jî mɔꞌɔ bo bɨ̀ ŋ̀gǎŋnjɨ̌m Herod ghu mbo, bɨ betə̀ yi mə, “Ǹdɨ̀ꞌɨ̀nnù, bìꞌì zi mə, ànnù yìi mə o dɨ̀ꞌɨ̀ aa, à nɨ̂ ànnù nɨ̂ŋkoŋə̀, ŋ̀kɨɨ naŋsə ndɨꞌɨ nɨ mânjì yìi mə Nwì a lɔ̀ɔ mə bə̀ ka ntswe ghu aa tsiꞌì ànnù nɨ̂ŋkoŋə̀, ŋkaa waꞌà nɨ̂ ǹsi ŋû liì; ǹloŋ mə kaa ò sɨ abwarə bə̂ laŋtə. ");
INSERT INTO bfd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tsɨ̂tsɔ̀ŋ, swoŋ a mbo bìꞌì, àyoò àmɔ̀ɔ̀ntə̀ a nɨ mə akə . A kuꞌunə nɨ nɔ̀ŋsə̀ yìꞌinə̀ a ntu bɨtax a mbo Kaisa kə̀ ŋ̀gaŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lâ Yesu à zî àtaŋtə̀ yî bɨ yaa, ŋ̀kwiꞌi a mbo bo mə, “Nɨ lɔ̀ɔ ŋkwàꞌànə̂ a gha aa a ya aa ɛ, a ŋgàŋabagɨlə̀. ");
INSERT INTO bfd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nɨ̀ dɨꞌɨ abaꞌatə ŋkabə yìi mə nɨ tu tax ghu aa a mbo mə̀.” Bo zî nɨ̀ yì mɔ̀ꞌɔ mfa ghu mbô? ");
INSERT INTO bfd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu a betə̀ waa mə, “A tswê àtu wo bo bɨ̀ ɨ̀kǔm wo fàa nɨ̂ ŋ̀kabə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bo kwiꞌi mə, “Àa yǐ Kaisa.” Yesu a tɨgə̀ ǹswoŋ a mbo bo mə, “Mala a bə mə nɨ̀ ka mfa njoo jìi mə à nɨ jî Kaisa aa a mbo Kaisa ŋkɨɨ mfa nɨ̂ ǹjoo jìi mə à nɨ jî Nwî aa a mbo Nwì.” ");
INSERT INTO bfd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bo yùꞌù mə̂ mala aa, ànnù a tsyâ waa; bo maꞌàtə̀ yi, ŋghɛɛ waa. ");
INSERT INTO bfd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A bə tsiꞌì maa njwi, baSadukai bìi mə bɨ swoŋə nɨ mə kaa bə̀ sɨ a nɨ nɨ̀wo yweenə aa, bɨ zî a mbo Yesu, m̀betə yi mə, ");
INSERT INTO bfd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ǹdɨ̀ꞌɨ̀nnù, Moses à lɛ nswoŋ mə, ‘M̀bə ŋù a kwo tɨ mu, ǹdɨ̂m yì a lɔgə̀ ŋ̀kwiꞌi yì, ǹjwe bɔɔ bo yu a mbo ǹdɨ̂m yì wa.’ ");
INSERT INTO bfd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tsɨ̂tsɔ̀ŋ bɔɔ bɨma bi mbâŋnə̀ bi sàmbaa bɨ lɛ ntswe ghu faà; yì ǹtsyàmbìì a yɔꞌɔ̀ mâŋgyɛ̀ ŋ̀kwo yi tɨghə̂ bo yu tswe nɨ̀ mû, m̀maꞌatə mâŋgyɛ̀ wa a mbô ǹdɨ̂m yì. ");
INSERT INTO bfd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Àbùgə̀ bɨlɨ̂m bi bya bi ntoꞌo bɨ lɔgə̀ mâŋgyɛ̀ wa yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ, ŋkɨ ŋkwokə waa tɨ mû. ");
INSERT INTO bfd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","M̀bâŋnə̀ jya tsɨ̀m ɨ kwòkə̀ mə̂ aa, màŋgyɛ̀ wa a kɨ̂ ŋ̀kwo yìi ŋgaa a njɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nòò yìi mə bə̀ ka yǐ yweenə nɨ nɨ̀wo aa ta màŋgyɛ̀ ghû à bə aa ŋgwɛ̂ wò a tɨtɨ̀ɨ bɔɔ bɨ ma bû bi sàmbaa aa ɛ? Ǹloŋ mə bo bɨtsɨ̀m bɨ lɛ nyɔꞌɔ yi aà.” ");
INSERT INTO bfd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu a kwiꞌi a mbo bo mə, “Ànnù yìi mə nɨ̀ swòŋə aa kaa a sɨ̀ kuꞌùnə̀ ǹloŋ mə kaa nɨ̀ sɨ̌ annù yìi mə a tswe a mûm àŋwàꞌànə Nwì aa zi, kaa waꞌà mɨdaꞌa mɨ Nwî kɨ nzi aà. ");
INSERT INTO bfd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ǹloŋ mə nòò yìi bə̀ ka yǐ yweenə nɨ nɨ̀wo aa, kaa baa yǐ waꞌà kà ǹyɔꞌɔ, kaa waꞌà bâŋgyɛ̀ a nda nɨ̀yɔꞌɔ ka mfa, ɨ bàŋnə bə aa tsiꞌì tsǒ baangel a aburə. ");
INSERT INTO bfd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lâ ŋ̀ghɛɛ nɨ̂ ànnǔ a nyweenə nɨ̀ nɨ̀wo, nɨ̀ lɛɛ̀ ŋ̀waꞌa a annù yìi mə Nwì à lɛ ŋŋwàꞌànə a mbo bù aa twoŋ, à ajàŋ mə a swǒŋ mə, ");
INSERT INTO bfd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mə̀ laa mbə Nwîŋgɔ̀ŋ Abraham, m̀bə Nwîŋgɔ̀ŋ Isaac, ŋ̀kɨ mbə Nwîŋgɔ̀ŋ Yakob aa ɛ’? Kaa à laa waꞌà Nwîŋgɔ̀ŋ bɨ̀ku bɨ bə̂ bə̂, à bə aa Nwîŋgɔ̀ŋ bə̀ bìi bɨ tswe bɨtɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ǹnɔ̀ɔ̀ bə̂ wa ɨ yùꞌù mə̂ aa, ǹyɛrə a nɨ̂ ɨ̀nnù jìi à lɛ sɨ dɨ̀ꞌɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nòò yìi mə baFarɨsai lɛ nyuꞌu mə à kùtə̀ mə̂ mɨ̂ntsù mɨ baSadukai aa, bo ghotə̀ ǹzi. ");
INSERT INTO bfd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ŋù nɨbò yî mɔ̀ꞌɔ, mbə ndɨ̀ꞌɨ̀ nɔ̀ŋsə̀, a betə̀ yi nɨ̂ àbetə̀ a ŋkwàꞌànə yu. ");
INSERT INTO bfd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ǹdɨ̀ꞌɨ̀nnù, ǹdɨ̀ꞌɨ yì àkɔꞌɔ̂ ǹtsɨrə a mum bɨ̀nɔ̀ŋsə̀ àa yu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu a kwiꞌi ghu mbo mə, “Tɨgə kɔ̀ŋə a Mmàꞌàmbì Nwìŋɔ̀ŋ ghò nɨ̂ ǹtɨɨ̀ gho ɨ̀ tsɨ̀m, nɨ̂ ǹtswêntɨ̀ɨ̂ yǒ ntsɨ̀m, nɨ mɨ̀tsyɛ̂ mo mɨ̀tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Àa ndɨꞌɨ yî àkɔꞌɔ̂ ǹtsɨrə ŋkɨ mbə yî ǹtsyàmbìì. ");
INSERT INTO bfd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yìi mə ɨ̀ yòŋtə aa, ɨ̀ kɨ mbə ŋgɨ̌ŋ ŋgɨ̀ŋ tsǒ ma yû. Tɨgə kɔ̀ŋə̀ a ndɨ̂m ghò tsǒ ɨ̀bɨ̀ɨ nû ghô. ");
INSERT INTO bfd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bɨ̀nɔ̀ŋsə̀ bɨtsɨ̀m, nɨ̂ ɨ̀nnǔ tsɨ̀m jìi mə ǹtoo Nwî lɛ ŋgwàꞌànə̀ aa, ɨ tsugɨnə aa a nɨ̂ ǹdɨꞌi mà jû ji baà.” ");
INSERT INTO bfd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsǒ mə baFarɨsai lɛ ŋghotə ntswe aa, Yesu a betə waa nɨ̂ àbetə̀ yuà: ");
INSERT INTO bfd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nɨ̀ mɔ̀ɔ̀ntə mə akə nloŋ Ayɔꞌɔ̀ Nwì wa aa ɛ? À bə aa mû wò aa ɛ?” Bo kwiꞌi ghu mbo mə, “À bə aa mu David.” ");
INSERT INTO bfd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu a betə waa mə, “A tɨgə̀ ǹtsya aa mə akə mə David, ǹyoŋ ajàŋ mə Àzwì Nwî a lɛ ntintə yi aa, mə tâ à twoŋə yi nɨ Mmàꞌàmbi aa ɛ? Ǹloŋ mə à lɛ nswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘M̀màꞌàmbi a swoŋ a mbô M̀màꞌàmbî ghà mə, tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ mə̀ nî màꞌà, ǹyweꞌe a noò yìi mə mə̀ ka yǐ nɔ̀ŋsə ŋgàŋkɨbàâ jò a njiꞌi mɨkòrə̂ wò aà.’ ");
INSERT INTO bfd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ma mùu ajàŋ m̀bə David a ka ntwoŋə yi nɨ̂ M̀màꞌàmbi, a tɨgə̀ m̀bu ntsyà aa la mbə mu David aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaa ŋù nɨ̀bò yî tsù à lɛ waꞌà nɨ̂ ànnù a ŋkwiꞌi tswê, kə̀ ǹlɔgɨnə maa njwi, kaa ŋù a waꞌà nɨ̂ yi nɨ̂ ànnù yî tsu bû m̀betə nɨ̂ àbetə̀. ");
INSERT INTO bfd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu a bəŋkə̀ a mbo ǹnɔ̀ɔ̀ bə̂ wa bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji ǹswoŋ a mbo bo mə, ");
INSERT INTO bfd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai, bɨ tswe nɨ̂ àlə̀ŋə Moses. ");
INSERT INTO bfd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Maa ajàŋ a kuꞌùnə̀ mə tâ nɨ̀ ka nyuꞌunə nɨ waa ŋkɨɨ ŋghɨrə nɨ̂ ɨ̀nnù tsɨ̀m jìi bɨ swoŋ a mbo bù aà, lâ ǹtsuu nɨ̂ ɨ̀nnù jìi mə bo ghɨ̀rə̀ aa kɨ ghɨ̀rə̀; ǹloŋ mə bo dɨ̀ꞌɨ̀ nɨ̂ ɨ̀nnù la kaa waꞌà bàŋnə̀ ŋ̀ghɨrə. ");
INSERT INTO bfd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bo kwerə nɨ̂ ɨ̀bèꞌè jìi mə ɨ dɨ̀rə̀ aa ǹnɔŋsə nɨ a mbɨ̀gɨ̀nə bə̀; la kaa bo bɨ̂mbɔŋ waꞌà nɨ a muswɛ̂bo ghu nɔ̂ŋsə̀ a ŋkwɛtə abèꞌè yâ. ");
INSERT INTO bfd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bɨ ghɨ̀rə ɨnnù tsɨ̀m aa bə mə bə̀ ka nyə waa; jyaa ɨbàa ŋgùù jìi mə bɨ ŋwàꞌànə̀ nɨghàà nɨ Nwî nɨnə ghu aa bo bɨ̀ ɨ̀ jyaa ɨtsəŋə ɨtsə̀ꞌə̀, bo ghɨ̀rə̀ ɨ naŋsə̀ m̀faŋ ŋkɨɨ nsaꞌa! ");
INSERT INTO bfd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bo kɔ̀ŋə̀ nɨ̂ ɨ̀lə̀ŋ jìi ɨ kɔꞌɔnə aa, a adɨgə àdinà, ŋ̀kɔŋ a ntswe a nɨ̂ ɨ̀ləŋ jìi ɨ tswe a mbìì a ndâŋghòtə̂, ");
INSERT INTO bfd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ŋ̀kɨɨ ŋkɔ̀ŋə nɨ mə tâ bə̀ ka ntsaꞌatə waa nɨ̂ àghuꞌusə̀ a nsaanə mɨtaa, ŋkɨɨ ŋkɔŋə nɨ mə bɨ̀ ka ntwoŋə nɨ̂ waa nɨ̂ ‘Rabbi.’ ");
INSERT INTO bfd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Lâ nɨ̀ tsuu lǒ bii tâ ŋù à twoŋə ghuu nɨ̂ ‘rabbi,’ ǹloŋ mə nɨ̀ tswe nɨ̀ Ǹdɨ̀ꞌɨ̀nnù aa tsiꞌì yì m̀fùùrə̀, bù bɨtsɨ̀m bâŋnə̀ m̀bə aa bə bɨ̀lɨ̀m bɨlɨmə. ");
INSERT INTO bfd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nɨ̀ tsuu ŋû tsù fàa a atu nsyɛ nɨ taà ghùu kɨɨ twoŋə, ǹloŋ mə nɨ̀ tswe nɨ̀ Tà aa tsiꞌì yì m̀fùùrə̀, yìi mə à tswe a aburə aa. ");
INSERT INTO bfd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɨ̀ tsuu kɨɨ bìì tâ bàa ntwoŋə ghuu nɨ bɨ̀masà, ǹloŋ mə nɨ̀ tswe nɨ̀ Masà aa tsiꞌì yì m̀fùùrə̀, a bə̂ Àyɔꞌɔ̀ Nwì wâ. ");
INSERT INTO bfd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ŋù yìi mə à kɔ̀ꞌɔ̀nə a tɨtɨ̀ɨ bù ǹtsyatə abùgə̀ bə̂ aa, tâ à baŋnə bə ŋgàŋàfàꞌâ ghùù. ");
INSERT INTO bfd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ŋù yì mə a ŋentə nɨ m̀bɨ̀ɨ̀ nû yì aa, baa sɨgɨtə nɨ ghu, lâ ŋù yìi mə a bàŋnə̀ ǹsɨgɨsə nɨ̂ m̀bɨ̀ɨ̀ nû yì a nsyɛ aa, baa bàŋnə ŋŋɛntə yi. ");
INSERT INTO bfd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Lâ ŋ̀gɨꞌɨ yì ŋ̀wè a mbo bù, m̀ba ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀, bo bɨ̀ ba Farɨsai, ŋ̀gǎŋabagɨlə̀! Ǹloŋ mə nɨ tsetə abàꞌa annù nɨfɔ̌ aburə a nsi bə̀. Kaa bù bumbɔŋ kaa nɨ̀ waꞌà ghu kuu, kaa waꞌà kɨ̀ m̀maꞌatə bə̂ bìi mə bɨ kɔ̀ŋə ŋkuu aa mə bɨ̀ kuu ghu!  ");
INSERT INTO bfd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ŋ̀gɨꞌɨ yì ŋ̀wè a mbo bù m̀ba ŋgǎŋndɨꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai, ŋgǎŋabagɨlə̀! Nɨ nɨ̀ꞌɨ̀ nɨ bɨ̀kwìꞌì bɨ bâŋgyɛ̀, ŋ̀kwɛrə nɨ̂ ǹjoò jyaa nɨ mɨ̀laꞌà myaa, m̀bagɨlə ntsaꞌatə nɨ̂ Nwî nɨ̂ ɨdaŋə mɨghàà. Ma mùu ajàŋ, wâ ŋ̀gɨꞌɨ yìi ɨ̀ ka yǐ kuu a nu bù aa ɨ̀ ka yǐ swèrə̀!” ");
INSERT INTO bfd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ŋ̀gɨꞌɨ yì ŋ̀wè a mbo bù m̀ba, ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai, ŋ̀gǎŋabagɨlə̀! Bù bìi mə nɨ too nɨ bɨ̀ mɨ̀yàà, ŋ̀ghɛɛ nɨ a ɨtoo ɨtoo, a nyə mə mbə nɨ̀ ghɨrə̀ ŋù yî m̀fùùrə̀ a biì ànnùnwî yuu, nòò yìi mə nɨ̀ ghɨ̀rə̀ mə̂ a bəŋkə̀ m̀bii aa, nɨ̀ bâŋnə̀ ŋ̀ghɨrə a kuꞌùnə̀ bə ŋkuu a mɔꞌɔ Satan, ǹtsyatə ghuu. ");
INSERT INTO bfd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ŋ̀gɨꞌɨ yì ŋ̀wè a mbo bù m̀ba, bɨ̂tsyàsə̀ bìi bɨ fəꞌə aà, nɨ dɨ̀ꞌɨ̀ mə, ‘Ŋù à bə kàa nɨ̂ ɨ̀kǔm ǹdâmàꞌanwì, boŋ ŋ̀kàa mà ya ɨ̀ tsyâ àdàŋə̀ dàŋə̀; lâ ŋù à bə kàà nɨ ɨ̀kǔm atɨɨ gold yìi a tswe a ndâmàꞌanwì aa, boŋ à tswe nɨ̀ ǹlə̀ə akàà ma yâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bǔ ɨtɨ̀rə̀ jìi ɨ kɨ mfəꞌə aa! Nɨ̀ zi mə a kɔ̀ꞌɔ̀nə yuu aa ɛ, àtɨ̀ɨ̀ gold ya kə̀ ǹdâmàꞌanwì ya yìi mə ɨ̀ ghɨ̀rə atɨɨ gold ya a tɨgə̀ àyoo abaꞌatə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nɨ kɨɨ nswoŋə nɨ mə, ‘Ŋù à bə kàà nɨ nɨ̀kèntə̀ nɨ mɔꞌɔ nɨ màꞌanwì, boŋ àkàà ma ya a tsya yi a dàŋə̀ dàŋə̀; la mbə ŋù a baŋnə ŋkàà nɨ̂ ǹjoo mmàꞌanwì jìi mə ɨ nɔŋ wa nɨkentə aa, boŋ à tswe nɨ̀ ǹlə̀ə̂ àkàà ma yâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bù bɨfə̀ꞌə̀nə̀! Àyìi mə a kɔꞌɔnə aa, à nɨ yuu aa ɛ, àyoo mmàꞌanwì ya, kə̀ nɨ̀kèntə̀ nɨ mmàꞌa Nwì nya mə nɨ ghɨ̀rə àyoo mmàꞌanwì ya a tɨgə̀ àyoo yìi a laa màŋsə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Maa ajàŋ, ŋù yìi mə a kàà nɨ nɨ̀kèntə̀ nɨ mmàꞌanwì aa, a kàà aa nɨ̀ nɨ̀kèntə̀ nya bo bɨ̀ ǹjoò tsɨ̀m jìi mə ɨ nɔŋ ghu aà; ");
INSERT INTO bfd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ŋù yìi mə a kɨɨ ŋkaa nɨ̂ ǹdâmàꞌanwì aa, a kàà aa nɨ̀ ǹda ya bo bɨ̀ yu wa yìi à tswe ghu aà; ");
INSERT INTO bfd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ŋù yìi mə a kɨɨ ŋkaa nɨ̂ àbùrə̀ aa, a kàà aa nɨ̀ àbə̀rə̀ Nwî bo bɨ̀ yu wa yìi mə à ŋàŋnə wa nɨ̂ àbə̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ŋ̀gɨꞌɨ yì ŋwè a mbo bǔ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai, ŋgǎŋabagɨlə̀! Nɨ yàtə̀ bâmbɔ̀rə̀ bî kə̀ꞌə̀kə̀ tsiꞌì tsǒ bɨ̀ mint, nɨ dill, nɨ cumin, jìi à nɨ̂ ǹjoo àghɔ̀ꞌɔ̀ aa, ɨtɨɨ nɨ̀ghum, mfa nɨ̂ àtɨɨ yì fùùrə̀ a mbo Nwì, m̀baŋnə mmàꞌàtə̀ nɨ̂ ɨ̀nnù jî wè jìi mə ɨ tswe a mum nɔ̀ŋsə̀, tsiꞌì tsǒ annù yìi mə atsinə aa, bo bɨ̀ ŋ̀ko mɨ̀lɨ̀ŋnə̀, nɨ̂ àbìintɨɨ̀; boŋ nɨ̀ laa mfàꞌà nɨ̂ ɨ̀nnù ma jû tsiꞌì tsɨ̀m kaa waꞌa nɨ̂ ji mɔꞌɔ màꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bɨ̀tsyàsə̀ bìi bɨ fəꞌə aà! Nɨ kɛɛ fɨrɨ̂njì a nɨ mɨ̀lùꞌù m̀baŋnə nno nɨ̂ ləŋə ghu bɔ̀ꞌɔ̀! ");
INSERT INTO bfd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ŋ̀gɨꞌɨ yì ŋwè a mbo bǔ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai, ŋgǎŋabagɨlə̀! Ǹloŋ mə nɨ lɔ̀gə̀ nɨ̂ noò ǹsìꞌi nɨ̂ ǹdɔŋ bo bɨ̀ àkaŋ tsiꞌǐ a abɛɛ abɛɛ, lâ mûm yì ɨ bâŋnə̀ ǹluu nɨ̂ ɨ̀yə̀rə bo bɨ̀ àghə̀ꞌə̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bǔ baFarɨsai, bɨ̀fə̀ꞌə̀nə̀, nɨ̀ foo nlɔ̀gɨ̀nə̀ ǹsiꞌi mûm ǹdɔŋ ya bo bɨ̀ àkaŋ ya yaꞌa, boŋ njɨ̀m àbɛ̀ɛ̀ ɨ̀ ka bɔ̌ŋ laa. ");
INSERT INTO bfd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ŋ̀gɨꞌɨ yì ŋwè a mbo bǔ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai, ŋgǎŋabagɨlə̀! Nɨ̀ bə aa tsiꞌì tsǒ mɨ̀syɛ̀ mìi mə bɨ yɔꞌɔ nɨ̂ m̀bə̀ə̀ yî m̀fùꞌù, m̀bɔŋə nɨ a ŋkɨrə tsiꞌì àbɛ̀ɛ abɛɛ, la ò tɨ kuu ghu mum, mɨ bâŋnə̀ ǹluu nɨ̂ ɨ̀kwɛ̀ɛ ɨku bə̂ bo bɨ̀ ǹjoo jìi mə ɨ sɨ̀ laa aà. ");
INSERT INTO bfd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Àa ŋgɨ̌ŋ ŋgɨ̀ŋ ajàŋ yìi mə nɨ kɨrə abɛɛ aà, tsiꞌì tsǒ bə̀ bìi mə ànnù yaa a tsinə, lâ bɨ tɨ kuu a mûm ǹtɨɨ bù, nɨ̀ luu nɨ̀ àbagɨlə̀ nɨ̂ ɨ̀nnù jî bɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ŋ̀gɨꞌɨ yì ŋwè a mbo bǔ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai, ŋgǎŋabagɨlə̀! Ǹloŋ mə nɨ bɔɔ nɨ mɨ̀syɛ̀ mɨ ŋgǎŋtoo Nwî, ŋ̀kɨɨ nnaŋsə nləŋtə nɨ mɨ̀syɛ̀ mɨ bə̂ bìi ɨ̀nnù jyaa ɨ tsinə aa, ");
INSERT INTO bfd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nswoŋə nɨ mə, ‘Bìꞌì lɛ mbaa tswe aa a noò bɨ̀tà bɨ bɨ̂taà biꞌi boŋ kaa bìꞌì lɛ waꞌǎ abô yiꞌi nɨŋ a nsaansə àləə ŋgǎŋntoo Nwî.’ ");
INSERT INTO bfd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ma mùu ajàŋ nɨ̀ fɨ̀gɨ̀tə̀ aa mə nɨ bɨ̀yə̂fə̂ buu bûmbɔŋ mə nɨ̀ laa mbə bɔɔ bɨ bə̂ bìi mə bɨ lɛ nzwitə ŋgǎŋntoo Nwî aà. ");
INSERT INTO bfd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nɨ̀ ghɛɛ la nɨ̀ m̀bìì m̀maŋsə afàꞌa yìi mə bɨ̀tà bɨ bɨ̂taà buu lɛ nlɔ̀gɨ̀nə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bǔ nô, bǔ bɔɔ bɨ bɨ̂mweꞌenə, mbə nɨ̀ tsyâ aa mə akə ŋkhə a ŋkuu a mɔꞌɔ Satan aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","M̀bə yìi mə a bə ma mùu ajàŋ aa, mə too nɨ̂ ŋ̀gǎŋntoo Nwî bo bɨ̀ ŋ̀gàŋmɨtsyɛ̀, nɨ̂ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀, bǐ mɔꞌɔ bìi mə nɨ̀ ka zwitə a ajàŋ mə nɨ̀ ka kwèèntə̀ waa a ati bàŋnə̀ bàŋnə̀ aa, ɨ bàŋnə ghɔ̀ɔ̀ bî mɔꞌɔ a ndâŋghòtə bù, ɨ kɨɨ kɨ tsɔꞌɔ nɨ̂ àkòrə̂ yaa, ɨ yòŋə̀ nɨ̂ waa a nɨ̂ ɨ̀laꞌa jìi bo khə̀ ŋ̀ghɛɛ ghu aà, ");
INSERT INTO bfd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tǎ tâ àləə bə̂ bìi ànnù yaa a tsinə, mə nɨ lɛ nzwitə waa tɨ ghə̌ bo fansə ànnù aa, ǹlɔgɨnə nɨ yì Abel ŋ̀ghɛɛ nyweꞌe nɨ yi Zacharias mu Barachiah, yìi mə nɨ̀ lɛ nzwitə, a tɨtɨ̀ɨ ndâmàꞌanwì bo bɨ̀ nɨ̀kèntə̀ nɨ màꞌanwì aa, tâ à kuu a atu bù. ");
INSERT INTO bfd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, ǹjo ɨnnù ma jû ɨ̀ ka kuu a atu nɨ̀wàà nɨ bə̂ buà. ");
INSERT INTO bfd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Wɛɛ! Yerusalem, Yerusalem! O zwitə nɨ ŋgǎŋntoo Nwî, ǹtumntə nɨ̂ bə̀ bìi mə bɨ too a mbo wò aa nɨ̀ ŋ̀gɔ̀ꞌɔ̀! Ŋ̀gààjî ghàꞌàtə̀ mə̀ lɔ̀ɔ̀ mə̂ mə mə ghotə bɔɔ̀ buu, tsǒ mə mâŋgu a ghotə bɔɔ̀ bi a njiꞌi mɨbǎ yu aà. Lâ kaa nɨ̀ waꞌà biì! ");
INSERT INTO bfd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yə̂ nɨ̀ bɨ mèꞌè mə ndâ yùù ɨ tɨgə̀ ŋ̀ghɛɛ nɨ̂ m̀fùmndùgə̀. ");
INSERT INTO bfd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mə̀ swǒŋ a mbo bù mə kaa nɨ̀ ka waꞌà gha bù ǹyə, ɨ yweꞌe a noò yìi mə nɨ̀ ka yǐ tɨgə swoŋə nɨmə ‘Bìꞌinə̀ ghaꞌasə yu wa yìi mə a zì nɨ̂ ɨ̀kǔm M̀màꞌàmbi aà!’ ” ");
INSERT INTO bfd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu à fɛ̀ꞌɛ̀ mə̂ wa ndâmàꞌanwì ŋ̀ka ŋghɛɛ, ŋ̀gǎŋyəgə̂nnù ji ɨ zî, ǹdɨꞌɨ ndâmàꞌanwì ya mə tâ à yə ajàŋ yìi mə bɨ lɛ naŋsə mbɔɔ tsiꞌì sɨgɨ̀nə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A bâŋnə̀ ŋ̀kwiꞌi a mbo bo mə, “Tɨgə nɨ̀ naŋsə nyə, kə̀ a sɨ̀ la bə aa ɛ? Mə̀ swǒŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, Kaa tsiꞌì ŋ̀gɔ̀ꞌɔ̀ yî m̀fùùrə̀ kaa ɨ̀ ka yǐ waꞌà a atu yì mɔꞌɔ bû nɔŋə. Bɨ ka yǐ sàꞌà tsiꞌì tsɨ̀m màꞌànə a nsyɛ̂.” ");
INSERT INTO bfd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu à ghɛ̀ɛ̀ mə̂ ǹtswe a nsyɛ a atu ntaꞌa Olive, ŋ̀gǎŋyəgə̂nnù ji jya ɨ zî ghu mbɛ̀ɛ̀ a tswê tsiꞌì bo bo, mbetə yi mə, “Naŋsə nwoŋ tâ bìꞌì yuꞌu, ɨ̀nnù ma jû ɨ ka yǐ fɛ̀ꞌɛ̀ aa a noò àkə̀ aa ɛ? Àlènsə̀ yìi mə a ka yǐ dɨ̀ꞌɨ a noò ǹzi ghò bo bɨ̀ nòò ǹlwìꞌî m̀bi aa à ka yǐ bə aa akə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu a kwiꞌi mə, “Nɨ̀ ka ntsyɛsə ghuu ntsee lǒ lə̀ə̀ tâ ŋù tsù à bweꞌesə ghuu. ");
INSERT INTO bfd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bə̀ bî ghàꞌàtə̀ ka yǐ kɨ zì a nɨ̂ ɨ̀kûm gha ɨ swoŋə nɨ mə, ‘Wa mə̀ bə̀ aa Àyɔꞌɔ̀ Nwì wâ,’ ɨ bweꞌesə nɨ̂ bə̀ bî ghàꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɨ̀ ka yǐ kɨ yuꞌu mə bɨ màꞌa ntsò, ɨ kɨɨ yuꞌu nɨ̂ fɨswoŋ ǹloŋ mɨ̂ntsò. Lâ nɨ̀ yi tɨ yuꞌu, nɨ̀ tsuu kɨ bɔꞌɔ, nloŋ mə ma jû ɨ̀nnù ɨ tswe nɨ̀ m̀fɛ̀ꞌɛ̂, lâ kaa a waꞌà bə aa mə nòò ǹlwìꞌî m̀bi wa à kùꞌù mə̂. ");
INSERT INTO bfd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ǹloŋ mə ɨ̀too ɨ ka yǐ kɨ màꞌa ntsò bo bɨ̀ jǐ mɔꞌɔ, tâ ɨ̀too jìi mə bɨfɔ̀ buꞌutə aa tâ ɨ̀ kɨ ŋka maꞌanə bo bɨ̀ jǐ mɔꞌɔ̀; tâ mɨ̀kwenə̀ à kuu a alaꞌà. Tâ ǹsyɛ ɨ tsɨgɨnə nɨ̂ a ɨdɨgə ɨdɨgə. ");
INSERT INTO bfd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma jû ɨ̀nnǔ tsɨ̀m ɨ ka yǐ bə aa tsǒ ajàŋ yìi maburə̀ à lɔ̀gɨ̀nə a nyuꞌu ǹyaŋə a noò yìi à tsɨ̀gə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bɨ ka yǐ tswa ghuu ɨ fa a mbo bə̀ tâ bɨ̀ nɨŋ ŋgɨꞌɨ yì ŋ̀wè a nu bù kə̀ ɨ zwitə ghuu. M̀bî ǹtsɨ̀m ɨ̀ ka yǐ kɨ bàà ghuu nloŋ ɨkûm ghâ. ");
INSERT INTO bfd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bə̀ bì ghàꞌàtə̀ ka yǐ màꞌàtə abìintɨɨ̀ yaa, ɨ fèè nɨ̂ waa bo nɨ bo, ɨ kɨɨ bànə̀ nɨ̂ waa. ");
INSERT INTO bfd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ŋ̀gǎŋntoo Nwi mbweꞌesə̀ jî ghàꞌàtə̀ ɨ ka yǐ fɛ̀ꞌɛ ɨ kɨ bweꞌesə nɨ̂ bə̀ bî ghàꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ɨ̀bɨ ɨ ka yǐ ghaꞌa siꞌi tâ àkɔ̀ŋnə̀ bə̂ bî ghàꞌàtə̀ à bɔrə. ");
INSERT INTO bfd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lâ ŋù yìi à tswa ntɨɨ̀ yi nyweꞌə a nlwìꞌì aa, à ka yǐ yweenə. ");
INSERT INTO bfd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bɨ ka yǐ swoŋ ntoo yì sɨgɨ̀nə̀ yû ǹloŋ annù nɨfɔ̀ aburə a mbô m̀bî ǹtsɨ̀m, tâ ɨ̀ bə àyəfə a mbo ŋ̀gwɛ̀ꞌɛ̀ mu ŋǔ ntsɨ̀m, mbɔŋ tâ nòò ǹlwìꞌî m̀bi à zi. ");
INSERT INTO bfd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nɨ̀ ka yǐ yə annù yî swèrə̀ ǹswerə ya mə ŋ̀gàŋntoò Nwì Daniel à lɛ nswoŋə aa tâ à tswe wa Adɨgə yî Làà maŋsə. (Tâ ŋù yìi a twoŋ annù yuà aa tâ à naŋsə nyuꞌu nzi.) ");
INSERT INTO bfd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bɛɛ mə nɨ̀ yə ma mùu ajàŋ, tâ bə̀ bìi mə bɨ tswe a alaꞌa Yudea aa bɨ̀ fɛꞌɛ ŋkhə̀kə̀ ŋ̀kɔꞌɔ ŋghɛɛ a ɨtu mɨ̂ntaꞌà. ");
INSERT INTO bfd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tâ ŋù yìi à tswe a atu nda aa, tâ à tsee lǒ bǔ sɨgə ɨ kuu a nlɔ̀gə̂ ǹjoò ji jìi ɨ tswe a mûm ǹda aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tâ ŋù yìi mə à tswe a mûm ǹsòò aa tâ à tsuu bǔ bɨ̀ɨ̀ a nlɔ̀gə̂ àkutə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wɛɛ! Ŋ̀gɨꞌɨ̀ bɨ̀maburə̀ bi atoꞌo bo bɨ̀ yì bìi mə bɨ nɔŋsə bɔɔ maa nɨ̂ ǹjwi ma jya aà! ");
INSERT INTO bfd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nɨ̀ ka ntsaꞌatə Nwî tâ ɨ̀nnù ma jû ɨ̀ yi ntsuu fɛ̀ꞌɛ aa a noò m̀fəꞌə, kə̀ a njwîŋgɔ̀ŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ǹloŋ mə ŋgɨꞌɨ yìi ɨ̀ ka yǐ tswe maà noò aa ɨ̀ ka yǐ swèrə ɨ tsyǎ ŋgɨꞌɨ̀ ǹtsɨ̀m yìi ɨ̀ lɛɛ̀ m̀fɛꞌɛ nlɔ̀gɨ̀nə̀ a noò yìi mə Nwì à lɛ naŋsə mbi, ɨ kɔꞌɔ yweꞌe tsɨtsɔ̀ŋə̀. Kaa yì dàŋ ɨ̀ ka yǐ waꞌà bù m̀fɛꞌɛ tsǒ ma yû. ");
INSERT INTO bfd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lâ Nwì à ka yǐ kwyɛ̀tə ndùu njwi mà jû ǹloŋ ŋkwitu bə̂ bi bìi à tsɔ̀ꞌɔ̀ aà. A sɨ̀ laa bə boŋ kaa ŋù tsù à ka yǐ waꞌa yweenə̀. ");
INSERT INTO bfd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“M̀bə ŋù a zi tɨ swoŋə a mbo bù mə, ‘Yə̂, Àyɔꞌɔ̀ Nwì wa à ghuà!’ kə̀ ‘Yə̂, à wiì!’ nɨ̀ tsee annù yìi a swoŋ aa lǒ bii. ");
INSERT INTO bfd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ǹloŋ mə bÀyɔꞌɔ̀ Nwì bɨ mbweꞌesə̀ bo bɨ̀ ŋ̀gǎŋntoo Nwi mbweꞌesə̀ ɨ ka yǐ fɛ̀ꞌɛ ɨ kɨ ghɨ̀rə̀ nɨ̂ ɨlensə ɨnnù jî wè bo bɨ̀ ɨ̀nnǔtsyâmbo a mbweꞌesə bə̀ ghu, ɨ tɛꞌɛ kɨ yweꞌetə nɨ a mbweꞌesə tsiꞌì bə̀ bii mə Nwì à tsɔ̀ꞌɔ aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yə̂ nɨ̀, wa mə̀ swòŋ mə̂ a mbo bù m̀bɔŋ tâ nòò ma wa a kuꞌu. ");
INSERT INTO bfd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Maa ajàŋ, m̀bə bə̀ yi ka nswoŋə nɨ a mbo bù mə, ‘Yə̂, wa à tswe a atu ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀,’ nɨ̀ tseè ghu ghɛ̀ɛ̀; kə̀ bɨ swoŋ mə, ‘Yə̂, à tswe a mûm ǹjaꞌa nda jǐ mum,’ nɨ̀ tsee lǒ bii. ");
INSERT INTO bfd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ǹloŋ mə ànnǔ nzǐ Mu Ŋù a ka yǐ bə aa tsiꞌì tsǒ ajàŋ mə mbə̌ŋ ŋwàꞌà a mbɨ̌ nsàꞌa nòò ŋ̀kàꞌâ yi wa ɨ ta ŋghɛ̀ɛ̀ ǹyweꞌe a mbɨ ntso nòò aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Àdɨ̀gə yìi mə àkwo ayoo a nɔŋ ghu aa, bɨ̀buꞌùmbɨ̀rə̀ ghotə ghu. ");
INSERT INTO bfd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ǹjwi ŋgɨꞌɨ mà jya ɨ ka yǐ ghɛ̀sə̀ kɨ mɛ̀ aa, tâ nɨ̀nòò à fii, kaa tâ sàŋ à waꞌà bù ŋ̀ka nta, tâ mɨ̀njɔ̀ŋ mɨ ka nlo a aburə ŋwokə nɨ a nsyɛ̂, tâ bɨ̀ tsɨgə ɨdaꞌa tsɨ̀m jìi ɨ tswe a aburə aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Maa noò tâ àlènsə̌ Mu Ŋù tâ à fɛꞌɛ a aburə, tâ ŋ̀gwɛ̀ꞌɛ̀ mu ŋù ǹtsɨ̀m a nsyɛ tâ à yəꞌə, nyə Mu ŋù tâ à zi nɨ a mûm m̀bàꞌà àbùrə̀ nɨ mɨ̀dàꞌà nɨ nɨ̀ghaꞌa nì wè. ");
INSERT INTO bfd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ǹtàŋ Nwì ɨ̀ ka yǐ ghàà nɨ̂ tɨ̀ɨ̀, tâ à too baangel bi a nɨ̂ m̀bɛ̀ɛ mbi ji nɨkwà mə tâ bo ghɛɛ ŋghotə bə̂ bi bìi mə à tsɔ̀ꞌɔ̀ aa, ǹlɔgɨnə a mbɛ̀ɛ̀ m̀bî yì mɔ̀ꞌɔ ŋghɛɛ nlwìꞌìsə nɨ yì mɔ̀ꞌɔ̂. ");
INSERT INTO bfd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Tâ nɨ̀ yəgə annù a nɨ̂ àtì figə̀. A yi mbə a noò yìi ntaà ji ɨ fìꞌìsə̀ mə ɨyə̀ŋ jî fii aa, nɨ̀ zi mə nòò ǹtsǔ mbə̀ŋ à tɨ̀gə a abô. ");
INSERT INTO bfd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","A kɨ̂ m̀bə nɨ a ŋgɨ̌ŋ ŋgɨ̀ŋ mə, mbə nɨ̀ yǐ nyə ɨnnù juà tsɨ̀m, nɨ̀ zi mə à zì mə̂ ŋkoontə, ǹtɨgə aa tsiꞌǐ a ntsǔbùꞌù. ");
INSERT INTO bfd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mə̀ swoŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, kaa nɨ̀wàà nɨ bə̂ nuà nɨ ka waꞌà tsyà tɨ ghə mə ɨ̀nnù ma jû tsɨ̀m ɨ fɛ̀ꞌɛ̀ mə̂. ");
INSERT INTO bfd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Àbùrə̀ bô ǹsyɛ ka yǐ tsyà, lâ kaa tâ nɨ̀ghaâ na nɨ̀ waꞌà tsyà. ");
INSERT INTO bfd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kaa ŋù tsù à sɨ̌ njwi kə̀ noò wa zî, kaa tsiꞌì baangel bii bɨ tswe a aburə aa, kə̀ Mû. A kɨ nzi tsiꞌi Tà yuyu. ");
INSERT INTO bfd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Àjàŋ yìi mə a lɛ mbə wa noò Noah aa, àa àjàŋ yìi a ka yǐ kɨɨ bə a nòò yìi mə Mu Ŋù à ka yǐ kɨ zì aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tsiꞌì tsǒ mə a lɛ mbə wa noò m̀bɔŋ mɨ̀yàa m̀bə̀ŋ wa a fɛꞌɛ aa, bə̀ lɛ sɨ jɨ ŋkɨɨ nno, nyɔꞌɔkə nɨ bàŋgyɛ̀, ŋ̀kɨɨ mfa nɨ̂ bɔɔ byaa a nda nɨ̀yɔꞌɔ, ǹyweꞌe wa njwi mə Noah à lɛ ŋkuu wa mûm àbaŋ aà, ");
INSERT INTO bfd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","kaa waꞌa annù tsu zî, ǹyweꞌe wâ noò mə mɨ̀yàa m̀bə̀ŋ wa à lɛ nzì ǹyɛꞌɛ waa aà. Àâ àjàŋ yìi mə a ka yǐ kɨɨ bə a noò yìi mə Mu Ŋù à ka yǐ zì aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","M̀bâŋnə̀ ji baa ɨ ka yǐ kɨ fàꞌà a afɔ̀ tâ bɨ̀ yi nlɔ̀gə̀ yî m̀fùùrə̀ m̀maꞌatə yî mɔ̀ꞌɔ̂. ");
INSERT INTO bfd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bàŋgyɛ̀ bi baa ka yǐ tswe adɨgə ŋghɔ̀ꞌɔ̂ àbaa tâ bɨ̀ zi nlɔ̀gə̀ yî m̀fùùrə̀ m̀maꞌatə yî mɔ̀ꞌɔ̂. ");
INSERT INTO bfd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Maa ajàŋ, nɨ̀ ka ntsyɛsə ghuu nloŋ mə kaa nɨ̀ sɨ njwi ya yìi mə Mmàꞌàmbî ghùù à ka zì ghu aa zî. ");
INSERT INTO bfd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nɨ̀ zi tâ à laa mə, m̀bɔ̂ŋ ǹdâ wa à lɛ mbaa zi a noò yìi mə nyə̀rə̂ à ka zì ghu nɨ̂tugə aa boŋ à tswe nɨkerə̀ ŋ̀ka bɛ ndâ yì ya mə tâ ǹyərə wa à tsee zǐ bəgə ɨ kuu ghu. ");
INSERT INTO bfd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Maa ajàŋ, nɨ̀ ka ŋkɨɨ ntaŋtə nû juu, nloŋ mə Mu Ŋù à ka yǐ zì aa a noò yìi mə kaa nɨ̀ sɨ̀ zî aà. ");
INSERT INTO bfd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ŋ̀gàŋàfàꞌà yìi a fàꞌà nɨ̂ ǹtɨɨ̀ yi tsɨ̀m ŋ̀kɨ ntswe nɨ mɨ̀tsyɛ̀ aa, yìi mə masà yì à lə̀ə mə tâ à ka nlentə ndâ yì, ŋ̀ka mfa nɨ mɨ̀jɨ a mbo banda bya a nɨ nòò yìi a kùꞌùnə aa, à nɨ wò aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","M̀bɔɔnə a mbo ŋgàŋàfàꞌà ma wa mə mbə masà yì a ka mbɨɨ nyə a ghɨ̀rə̀ maa ajàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mə̀ swoŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, taà yì wa à ka tɨgə ghɨ̀rə̀ mə à ka nlentə njoò ji tsiꞌì tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lâ m̀bə ŋgàŋàfàꞌà yî m̀bɨ wa a swoŋ a mbo ɨbɨɨ nû yi mə, ‘Masà ghà à ka tɨ̀gə’ ");
INSERT INTO bfd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ǹlɔgɨnə ŋka ŋghɔɔ ŋgǎŋfàꞌà jya ji mɔꞌɔ, ǹjɨ, nno, mbaanə, ");
INSERT INTO bfd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","boŋ masà yì wa à ka zǐ a njwi yìi à sɨ nii yuꞌutə aa, bo a nɨ nòò yìi kaa à sɨ̀ zi aa, ");
INSERT INTO bfd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ɨ nɨŋ njo ghu nu, ɨ lɔ̀gə̀ yi ɨ lə̀ə̀ bo bɨ̀ ŋ̀gàŋabagɨlə̀; maa adɨgə bə̌ yə̀ꞌə̀ ghu ŋkɨɨ kurə nɨ mɨ̀sɔ̀ŋə̂ myaa.” ");
INSERT INTO bfd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Bìꞌinə̀ fɨgɨnə annù nɨfɔ̌ aburə nɨ bɔɔ ŋgɔ̀ɔ̀ bi nɨghum bìi bɨ lɛ nlɔ̀gə̀ bɨ̂lâm byaa ŋghɛɛ a mbòo ndòò nɨ̀yɔꞌɔ ghu. ");
INSERT INTO bfd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bì bi ntaà lɛ njɨ̀ŋtə̀, bì bi ntaà bɨ bâŋnə̀ ǹtsyɛsə. ");
INSERT INTO bfd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bǐ ajɨ̀ŋtə̀ bya lɛ nlɔ̀gə̀ bɨ̂lâm byaa kaa kɨꞌɨ̀ bɨ̂yweꞌe bɨ mɨghurə bi dàŋ bû ǹtugɨtə. ");
INSERT INTO bfd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lâ bì tsyɛ̀sə̀ bya lɛ ntugɨtə bɨ̂yweꞌe bɨ mɨghurə bi dàŋ. ");
INSERT INTO bfd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tsǒ mə ndoo nɨ̀yɔꞌɔ wa à lɛ ntɨ̀gə̀ a nzi aa, bo bɨtsɨ̀m lɛ ntsɨŋ fɨ̀lo mbwiiŋkə. ");
INSERT INTO bfd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lâ à bə̀ mə̂ nɨ̂ ǹtɨɨ̀ ɨ̀tugə, bə̀ tɔŋnə̀ ǹswoŋ mə, ‘Wa ndoo nɨ̀yɔꞌɔ wa à zì mə̂, nɨ̀ ghɨrə bìꞌinə̀ fɛꞌɛ ntsiꞌi yi.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bɔɔ ŋgɔ̀ɔ̀ bya bɨ̀tsɨ̀m lɛ mbɨ̀ɨ̀nə̀, ŋ̀kɔꞌɔtə nɨ mɨ̀ŋkɨ̀rə̀ mɨ bɨ̂lâm byaa. ");
INSERT INTO bfd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bǐ jɨ̀ŋtə̀ bya swoŋ a mbo bì mɨtsyɛ̀ bya mə, ‘Fa nɨ̀ yiꞌi nɨ mɨ̀ghurə̀ ǹloŋ mə bɨ̀lâm biꞌi bwɛnə ŋghɛɛ.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lâ bì mɨtsyɛ̀ bya kwiꞌi a mbo bo mə, ‘M̀bə bìꞌì fa boŋ kaa mɨ ka waꞌà a mbo bìꞌinə̀ bɨtsɨ̀m kuꞌùnə̀. Nɨ̀ ghɛɛ a mbô ŋ̀gàŋmɨtaa nyuu muu ghu.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bô lò mə̂ ŋ̀ghɛɛ a nyuu, ǹdoo nɨ̀yɔꞌɔ wa a zî. Ǹlɔgə bə̂ bìi bɨ lɛ ntaŋtə nû yàà ǹtɨgə nyuꞌutə aa bo bo kuu ŋghɛ̀ɛ̀ waa wa adɨgə njɨ nɨ̀yɔꞌɔ ntsetə ntsǔndâ. ");
INSERT INTO bfd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Àbàŋtə̀ a bə̀ mə̂, bɔɔ ŋgɔ̀ɔ̀ bya bǐ mɔꞌɔ kɨ̂ ǹzi, ntɨgə ntwoŋə nswoŋə nɨ mə ‘M̀màꞌàmbî, màꞌàmbî, ŋaꞌa ntsǔnda a mbo bìꞌì.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lâ ǹdoo nɨ̀yɔꞌɔ wa a kwiꞌi a mbo bo mə, ‘Mə̀ swǒŋ annù nɨ̂koŋ a mbo bù mə kaa mə̀ sɨ̀ ghuu zî. ");
INSERT INTO bfd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma mùu ajàŋ nɨ̀ tswe nɨkərə̀ ŋ̀ka mbɛ nloŋ mə kaa nɨ̀ sɨ njwi ya kə̌ abàŋtə̀ noò ya zî.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Maà noò a ka yǐ bə aa tsǒ ŋû yìi à lɛ sɨ ghɛ̀ɛ̀ a nɨghaa a ndɨsyà ǹtwoŋ ŋgǎŋfàꞌâ ji, m̀fa njoò ji a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A mbo yì mɔ̀ꞌɔ, a fa bɨ̀talent bi ntaà. Ŋ̀ghɛɛ a mbo yì mɔ̀ꞌɔ mfa bi baa, ŋ̀kɨ ntɨgə mfa yî mɔ̀ꞌɔtə a mbo yì mɔ̀ꞌɔ̂. Ǹyatə nyòŋ aa a nɨ mɨ̀tɨ̀ɨ̂ myaa, ǹtɨgə ŋghɛɛ yi wa a nɨghaà. ");
INSERT INTO bfd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ŋù wa mə à lɛ ŋkwɛrə bɨ̂talent bi ntaà, à lɛ mburə ŋghɛɛ ŋka ntaŋə mɨtaa nɨ bu. Àbìì a yoŋ ghu mbə bɨ̂talent bi ntaà. ");
INSERT INTO bfd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wa yìi à lɛ ŋkwɛrə bɨ̂talent bi baa aa, à lɛ ŋkɨ ŋghɛɛ ntaŋə mɨtaa nɨ bu, àbìì a kɨ̂ ǹyoŋ ghu, mbə bɨ̂talent bi baà. ");
INSERT INTO bfd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","La wa yìi mə à lɛ ŋkwɛrə talent yî m̀fùùrə̀ aa, à lɛ mbàŋnə̀ ŋ̀ghɛɛ ntoŋ nsyɛ ntwiŋ ŋkabə̀ taà yì ya ghu. ");
INSERT INTO bfd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Àghaꞌa a lɛɛ̀ ǹsaꞌa, taà wàà wa a bɨɨ̀ wa a nɨghaa, ntwoŋə waa mə bo bo tswe a nsyɛ nlèntə annǔ ŋkabə yâ. ");
INSERT INTO bfd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wa mə à lɛ ŋkwɛrə bɨ̂talent bi ntaà aa, à lɛ ntsyà ǹtəə a nsyɛ nswoŋ mə, ‘Taà, ò lɛ mfa aa bɨ̀talent bi ntaà a mbo mə̀, mə̀ fùꞌù mə̂ bi ntaà ŋ̀kuꞌusə ghu.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Taà yì wa a swoŋ ghu mbo mə, ‘Ò ghɨ̀rə̂ sɨgɨ̀nə̀ m̀bǎ ŋgàŋàfàꞌâ ghâ yî sɨgɨ̀nə̀ yìi à tsyɛ̀sə aà. Àjàŋə mə ò lèntə ayoo yì kə̀ꞌə̀tə̀ nɨ̀ ǹtɨɨ̀ gho tsɨ̀mə̀ aa, mə̀ aa lə̀ə̀ gho tâ ò ka nlentə jî ghàꞌàtə̀. Tɨgə ŋkuu nzǐ tâ sɨ̀ ka ndorɨtə.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Wa yìi à lɛ ŋkwɛrə bɨ̂talent bi baa aa, à lɛ ŋkɨ ntsya ntəə yìi ŋgaa nswoŋ mə, ‘Taà ghà, ò kɨ̀ fa aa bɨ̀talent bi baa a mbo mə̀, mə̀ bù mə̂ m̀fuꞌu bi baa ŋkùꞌùsə̀ ghu, bɨ bulà.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Taà yì wa a swoŋ ghu mbo mə, ‘Wa ò ghɨ̀rə sɨgɨ̀nə̀ m̀ba ŋgàŋàfàꞌâ ghà yî ǹsɨgɨ̀nə̀ yìi à tsyɛ̀sə aà. Àjàŋə mə ò kɨ̀ lèntə ayoo yì kə̀ꞌə̀tə̀ nɨ̂ ǹtɨɨ̀ ghô tsɨ̀mə̀ aa, mə̀ aa tɨgə lə̀ə̀ gho tâ ò tɨgə nlentə jî ghàꞌàtə̀. Kuu nzǐ tâ sɨ̀ ka ndorɨtə.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Wa yìi mə à lɛ ŋkwɛrə a talent yî m̀fùùrə̀ aa, à lɛ ntsyà ǹtəə, nswoŋ mə, ‘Taà, mə̀ zi gho mə ò nɨ̂ àtɨntə ŋû, m̀fuꞌu nɨ mɨ̀jɨ a adɨgə yìi kaa ò sɨ̀ ghu bê, ŋ̀kɨɨ kya tɨ ghə ò bwìꞌî. ");
INSERT INTO bfd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mə̀ kɨ̀ sɨ bɔꞌɔ nɨ̂ ghô, ŋ̀ghɛ̀ɛ̀ ǹtoŋ nsyɛ nnɨŋə a talent ghò wa ghu. Kò, àyoo yìi à nɨ à yo aa a yûlà.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lâ, tâfàꞌà yì wa a swoŋ ghu mbo mə, ‘Àbɔrɨkə ŋgàŋàfàꞌà yî m̀bɨ̂! Ò lɛ nzi mə mə fùꞌù tɨ ghə̂ mə̀ be, ŋkɨɨ ŋkya tɨ ghə̂ mə̀ bwiꞌi, ");
INSERT INTO bfd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","boŋ ò lɛ mbaa ŋghɛ̀ɛ̀ ǹləə ŋkabə̀ yà ya a ndânlə̀ə̂ ŋ̀kabə̀, tà mə̀ tɨ bɨ̀ɨ, mə̀ kwɛrə ayoo yìi a nɨ̂ àyaa nɨ̀ àbìì ghu. ");
INSERT INTO bfd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tsɨ̂tsɔ̀ŋ, tâ nɨ̀ kwɛrə a talent gha wa ghu mbo mfa a mbo ŋù wa mə à tswe nɨ bɨ̀talent bi nɨghum aà. ");
INSERT INTO bfd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ǹloŋ mə, a mbo ŋù ǹtsɨ̀m yìi à tswe nɨ̂ ǹjoo aa, bɨ aa kùꞌùsə̀ tâ à tswe nɨ ju ɨ̀ ghaꞌa. Lâ, ŋù yìi mə à sɨ̀ nɨ̂ ǹjoo tswê aa, bɨ ka kwɛrə, ɨ kwɛrə mûntsirə̀ yìi à tswe nɨ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ŋ̀ghɛɛ nɨ̂ ndə̌ àbɔrɨkə ŋgàŋàfàꞌà ghû, nɨ̀ maꞌa yi a abɛɛ a mûm m̀fiì ɨ̀dɨ̀gə̀; a adɨgə yìi mə bə̌ yə̀ꞌə̀ ŋ̀kurə nɨ mɨ̀sɔ̀ŋə̂ myaa ghu aà.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nòò yìi mə Mu Ŋù à ka yǐ zì, a mum nɨ̀ghaꞌa yu bo bɨ̀ baangel bɨtsɨ̀m aa, à ka yi ŋaŋnə nɨ̂ àbə̀rə̀ nɨfɔ̀ yî wè. ");
INSERT INTO bfd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɨ̀too ɨtsɨ̀m ɨ ka yǐ tɨgə ghotə tswe ghu nsi, tâ à yatə waa mbɛ̀ɛ̀ baa tsiꞌì tsǒ ajàŋ mə ntsèèmbi a yàrə mbinjə̀rə̀ m̀fiꞌisə nɨ a tɨtɨ̀ɨ mbindɔŋ aà. ");
INSERT INTO bfd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɨ tɨgə lə̀ə mbinjə̀rə̀ jya a abo yu yî màꞌà, ɨ bàŋnə lə̀ə̀ ji ndɔŋ jya a abo yu yî ŋ̀kwàbə̀. ");
INSERT INTO bfd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tâ m̀fɔ̀ wa a tɨgə nswoŋ a mbo bə̀ bya mə bɨ tswe a abo yu yî màꞌà aa mə, ‘Nɨ̀ zi mbâ bə̂ bìi mə Taà ghà à nɨ̌ŋ mbɔɔnə a nu bù aà, ǹzi njɨ nɨ̌ annù nɨfɔ̀ yìi bɨ lɛ ntaŋtə nləə a mbo bù ǹlɔgɨnə a nlɔ̀gɨ̀nə̂ m̀bi aà. ");
INSERT INTO bfd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ǹloŋ mə njì ɨ̀ lɛ sɨ yaŋə nàa, nɨ̀ fa mɨ̀jɨ a mbo mə̀. Ǹjì ŋ̀kì ɨ kâ yaŋə nàa, nɨ̀ fâ ŋ̀kì à mbo mə̀. Mə̀ bə̂ ŋ̀gɨ̀ɨ̀, nɨ̀ kwɛrə̂ ghâ. ");
INSERT INTO bfd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mə̀ tswê ǹswèrə̀ ǹswèrə̀, nɨ̀ fâ àtsə̀ꞌə̀ a mbo mə̀. Mə̀ kâ ŋ̀ghɔɔ, nɨ̀ lêntə̀ nɨ̀ghɔ̀ɔ̂ nâ. Mə̀ tswê a ndâtsaŋ, nɨ̀ lêntə̀ ghâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Maa noò, tâ bə̀ bya mə ànnù yaa a tsinə aa tâ bɨ̀ betə yi mə, ‘M̀màꞌàmbî, bìꞌì lɛ nyə gho aa a fə, ǹjì ɨ kâ ǹyaŋə noo, bìꞌì jɛꞌɛ̀ gho, kə̀ ŋ̀kɨ mfa ayoo yì nò a mbo wò a jaŋə njì ŋkɨ lɛ sɨ yaŋə nòo aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bìꞌì lɛ nyə gho aa fə ò bə̂ ŋ̀gɨ̀ɨ̀ bìꞌì kwɛrə̀ gho, kə̀ ò tswê ǹswèrə̀ bìꞌì wɛꞌɛ̀ àtsə̀ꞌə̀ a nu wò aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bìꞌì lɛ nlèntə̀ nɨghɔ̀ɔ̂ no aa fə, kə̀ ŋ̀kɨ lentə gho a ndâtsaŋ aa fə aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tâ m̀fɔ̀ wa a kwiꞌi a mbo bo mə, ‘Mə̀ swòŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, àjàŋə mə nɨ̀ lɛ ŋghɨ̀rə̀ ma ya annù a nu mumaà ghà ghû yî mɔ̀ꞌɔ yìi à kə̀ꞌə nsɨgə nlwiꞌi aa, nɨ̀ lɛ ghɨ̀rə̀ aa a nu mə̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“A ŋghɛ̀ɛ a nɨ bə̀ bya bìi mə bɨ tswe a abo yu yî ŋ̀kwàbə̀ aa, â swoŋə a mbo bo mə, ‘Lǒ nɨ̀ ghuu a mbɛ̀ɛ mə̀ mba ŋgǎŋndɔ̀ɔ̀, ŋ̀ghɛɛ ŋkuu nɨ mɔꞌɔ tɨ mɛ̀ wa yìi bɨ naŋsə a mbo Devil bo bɨ̀ baangel bi aà. ");
INSERT INTO bfd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ǹloŋ mə ǹjì ɨ̀ lɛ sɨ yaŋə nàa kaa nɨ̀ waꞌǎ mɨjɨ a mbo mə̀ fâ; ǹjì ŋ̀kì ɨ kâ ǹyaŋə nàa, kaa nɨ̀ kɨꞌɨ̌ ayoo yì nò a mbo mə̀ fâ. ");
INSERT INTO bfd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mə̀ lɛ mbə ŋgɨ̀ɨ̀ kaa nɨ̀ kɨꞌɨ̀ gha kwɛrə̀; mə̀ tswê ǹswèrə̀ ǹswèrə̀ kaa nɨ̀ waꞌǎ atsə̀ꞌə̀ a nu mə̀ wɛꞌɛ̀. Mə̀ ghɔɔ̀ kaa nɨ̀ kɨꞌɨ̀ nɨghɔ̀ɔ̂ na lèntə̀. Mə̀ tswê a ndâtsaŋ, kaa nɨ̀ kɨꞌɨ̀ gha ghantə̀.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tâ bo kɨ mbetə yi mə, ‘M̀màꞌàmbî, bìꞌì lɛ nyə gho aa fə, ǹjì ɨ yaŋə̀ noo, kə̀ ǹjì ŋ̀kì ɨ yaŋə̀ noo, kə̀ ò kɨ̂ m̀bə ŋgɨ̀ɨ̀, kə̀ ò kɨ̂ ǹtswe nswèrə̀ ǹswèrə̀, kə̀ ŋkɨɨ ŋghɔɔ, kə̀ ŋ̀kɨ ntswe a ndâtsaŋ kaa bìꞌì kɨꞌɨ̌ annǔ tsu a nu wò ghɨrə̀ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Boŋ à ka kwiꞌi a mbo bo mə, ‘Mə̀ swòŋ a mbo bù tsiꞌǐ annù nɨ̂koŋ mə, àjàŋə mə nɨ̀ lɛ ŋkɨꞌɨ a nu ghûlà yî mɔ̀ꞌɔ yìi à kə̀ꞌə nsɨgə nlwiꞌisə aa ghɨ̀rə̀ aa, kaa nɨ̀ lɛ ŋkɨꞌɨ aa a nu mə̀ kɨ ŋghɨrə.’ ");
INSERT INTO bfd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tâ bo tɨgə nlo ŋghɛ̀ɛ̀, ŋ̀ghɛɛ ŋkuu a nɨ ǹjo tɨ̀ mɛ̀ ya. Tâ bə̀ bìi mə ànnù yaa a tsinə aa tâ bo baŋnə ŋkuu a mûm ǹtswêntɨ̀ɨ̀ yìi ɨ̀ lwìꞌi nɨ̂koŋə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu à màŋsə̀ mə̂ a ndɨ̀ꞌɨ̂ ɨ̀nnù ma jû, ǹswoŋə a mbô ŋ̀gǎŋyəgə̂nnù ji mə, “Nɨ̀ zi mə ");
INSERT INTO bfd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ǹjwî Passa ɨ̀ tswe aa a njɨ̌m njwi ji baà. Bɨ ka fa Mu Ŋù, tâ bɨ̀ lɔgə ŋghɛ̀ɛ̀ ŋ̀kwèèntə̀ a ati bàŋnə̀bàŋnə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Maà nòò, bɨ̀lɨɨ bɨ ŋgǎŋmàꞌa Nwì, a bɔ̀ꞌɔ nɨ bɨ̀tà bɨ alaꞌa bo lɛ mbòòntə̀ a ntɔꞌɔ ŋgàŋmàꞌanwi yî ŋ̀wè mə bɨ lɛ sɨ twoŋə nɨ Kaifas aa, ");
INSERT INTO bfd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","a ntaŋə̀ a ajaŋ mə bo ka ŋeꞌesə tswa Yesu ghɛ̀ɛ zwitə aà. ");
INSERT INTO bfd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lâ bo lɛ nswoŋ mə, “A bɔŋ mə tâ bìꞌinə̀ tsuu ma yuà ànnù fàa njwî Passa ghɨ̀rə̀ ǹloŋ mə mbə bìꞌinə̀ tswa yi boŋ fɨ̀kɔ̀rə̀ ka fɛ̀ꞌɛ̀ a tɨtɨ̀ɨ bə̀ ɨ bùùrə ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu à lɛ ntswe a Bethany a nda Simon yìi mə à lɛɛ̀ m̀bə ŋûkɨkwen aa ŋka jɨ, ");
INSERT INTO bfd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","màngyɛ̀ yî mɔ̀ꞌɔ a zî ghu mbɛ̀ɛ̀, nɨ mɨ̀ghurə mì lùmtə̀ mɨ antɨ̀ndùû mî sɨgɨ̀nə̀ nɨ̂ ǹtsɨ̂ŋ ŋ̀gɔ̀ꞌɔ̀ alabasta. À zì mə aa, ǹlɔ̀gə̀ mɨghùrə̀ mya ntswentə nyɔꞌɔ atu Yesu ghu. ");
INSERT INTO bfd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ŋ̀gǎŋyəgə̂nnù Yesu bo yə, mɨ̀ntɔ̂ŋ myaa mɨ lwî, bo betə mə, “À nàŋsə nta ŋgɨꞌɨ nɨ mɨ̀ghurə mù laà aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ǹloŋ mə mbə bɨ lɔgə̀ mɨ̀ghurə mà mû m̀fee nɨ̂ ŋ̀kabə yì ŋwè m̀fa a mbo ŋ̀gàŋə̂mfumə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu a yuꞌù à àjàŋ yìi mə bo ghàà laà aa, ǹswoŋ a mbo bo mə̀, “Nɨ fa ŋgɨꞌɨ a mbo màŋgyɛ̀ ghù aa a ya ɛ? Nɨ̀ sɨ̀ zi mə à nɨ̂ ànnù yî sɨgɨ̀nə̀ mə à ghɨ̀rə a nu mə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ŋ̀gàŋə̂mfumə ɨ tswe a tɨtɨ̀ɨ bù aa bɨ̀nòò bɨ̂tsɨ̀mə̀, lâ kaa mə̀ ka waꞌa a tɨtɨ̀ɨ bu aa a ŋgɔ̀ŋ bɨ̀nòò bɨ̂tsɨ̀m tswê. ");
INSERT INTO bfd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","À yɔꞌɔ gha nɨ̀ mɨ̀ghurə mù, ǹnaŋsə aa nû yà m̀bɔŋ tâ nòò ǹtwìŋə̂ ghà à kuꞌu. ");
INSERT INTO bfd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mə̀ swoŋ a mbo bù tsiꞌì ànnù nɨ̂ŋkoŋ mə, a nɨ̂ ŋ̀gɔ̌ŋ ɨdɨ̀gə tsɨ̀m jìi mə bɨ ka yǐ kɨ swoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ yû ghu fàa mbi aa, bɨ ka yi kɨɨ kɨ swoŋə nɨ̂ ànnù yuà mə màŋgyɛ̀ ghuà à ghɨ̀rə a nu mə̀ aà, ŋ̀waꞌatə nɨ̂ yi.” ");
INSERT INTO bfd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ma mùu noò ŋù yî mɔ̀ꞌɔ a tɨtɨ̀ɨ ŋgǎŋyəgə̂nnù Yesu jya nɨ̀ghûm ǹtsò baa mə bɨ lɛ sɨ twoŋə nɨ Judas Iscariot aa, a ghɛɛ̀ a mbɛ̀ɛ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì ");
INSERT INTO bfd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ǹswoŋ a mbo bo mə: “M̀bə mə̀ fee Yesu a mbo bù boŋ nɨ̀ ka fa akə a mbo mə̀ aa ɛ?” Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bo lɔɔ̀ ɨ̀bàꞌatə ŋkabə Silva mɨghum mi ntarə mfa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ǹlɔgɨnə maà noò Judas à lɛ sɨ tɨgə nlɔɔ nɨ̂ mânjì yìi mə mbə yu tsyâ ghu mfee Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A bə a njwi yì ǹtsyà m̀bìì a njwi ŋ̀kurə̂ àbaa tɨ kɔꞌɔ, ŋ̀gǎŋyəgə̂nnù Yesu ɨ zî m̀betə ghu mbo mə, “Ò lɔ̀ɔ mə bɨ̀ naŋsə aa yuu adɨgə a mbo wò tǎ tâ ò jɨ mɨjɨ mɨ Passa ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu a kwiꞌi a mbo bo mə, “Nɨ̀ ghɛɛ a mbɛ̀ɛ ŋù kɨ̀kyɛ̀ a mûm àlaꞌa, ǹswoŋ ghu mbo mə, ‘Ǹdɨ̀ꞌɨ̀nnù à swòŋ mə nòò ghà à kùꞌù mə̂. Wa mə̀ ka jɨ mɨjɨ mɨ Passa bìꞌi bɨ̀ ŋ̀gǎŋyəgə̂nnù ja aa a nda wò.’ ” ");
INSERT INTO bfd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ŋ̀gǎnyəgə̂nnù Yesu jya ɨ kɨ̂ ŋ̀ghɛɛ ŋghɨ̀rə̀ tsiꞌì wa ajàŋ mə Yesu à swòŋə aà, ǹnaŋsə njoo njɨ Passa jyâ. ");
INSERT INTO bfd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nòò ŋ̀kwɛ̂fɔ̀ à kùꞌù mə̂, a tswe a atu atɛtə̀ ŋ̀ka jɨ bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bô kà mə aa njɨ, Yesu a swoŋ a mbo bo mə, “Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂ ŋ̀koŋ mə, ŋù yî mɔ̀ꞌɔ a tɨtɨ̀ɨ bù à ka ghɨ̀rə fèè ghâ.” ");
INSERT INTO bfd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bo lɛ mburə njəŋnə siꞌi siꞌi a nyuꞌu annù ma yu, ǹtɨgə nlɔgɨnə ŋka mbetə nɨ̂ Yesu yi mɔ̀ꞌɔ, yi mɔ̀ꞌɔ mə, “M̀màꞌàmbî, à nɨ mə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu a kwiꞌi a mbo bo mə, “Ŋù yìi mə bìꞌi yu jɨ, a nɨŋə̀ nɨ̂ àbô yi biꞌiyu a akaŋ yì fùùrə̀ aa, à ka ghɨ̀rə fèè ghâ. ");
INSERT INTO bfd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lâ ànnù ma yû a ka yə Mu Ŋù aa tsiꞌì à àjàŋ yìi mə bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ Nwî ǹloŋ ŋgaa yì aà. Ŋ̀gɨꞌɨ yì ǹswèrə̀ ǹswerə a nu ŋù yìi à fèe Mu Ŋu aà. Lâ a lɛ mbaa mbɔ̀ŋ mə tâ bɨ̀ tsee ajàŋ ŋû ma yû lô burə jwe, jwe bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas mə a lɛ ntswe nɨ̂ m̀fèe yi aa, a kɨ̂ m̀betə yìi ŋgaa mə, “Rabbi, tɨgə kaa ò sɨ aa gha swoŋə aa ɛ?” Yesu a kwiꞌi ghu mbo mə, “Ò swòŋ mə̂!” ");
INSERT INTO bfd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bo kà maa njɨ, Yesu a lɔgə̀ àbaa, mfa mbɨꞌɨkə a mbo Nwì, m̀batə, mfa a mbô ǹgǎŋyəgə̂nnù ji jya, ǹswoŋ mə: “Kò ŋkurə nɨ̀; à nɨ̂ ɨ̀bɨ̀ɨ nû gha ɨ ghuà.” ");
INSERT INTO bfd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","M̀bu ntɨgə nlɔgə ndɔ̂ŋ mɨ̀lùꞌù, m̀fa mbɨꞌɨkə a mbo Nwì, m̀fa a mbo bo, nswoŋ mə, “Kò nô nɨ̀ bu bɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","À nɨ̂ àləə nû ya â yuà, àləə ŋwàrə̂ àkàà yìi mə bɨ ka saansə atu bə̀ bî ghàꞌàtə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, ǹlɔgɨnə tsɨ̂tsɔ̀ŋ, kaa mə̀ ka yi waꞌà mɨlùꞌù bû ǹno, nyweꞌe a njwi yìi mə mə̀ ka yǐ bǔ no mɨlùꞌù mî fii bìꞌinə̀ a mûm ànnù nɨfɔ̀ Taà ghà a aburə aà.” ");
INSERT INTO bfd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bo yəə̀ ɨ̀kòò, m̀fɛꞌɛ ŋkɔꞌɔ ŋghɛɛ a atu ntaꞌa Olive. ");
INSERT INTO bfd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bo kɔ̀ꞌɔ̀ mə̂ ǹyweꞌe ghu, Yesu a swoŋ a mbo bo mə, “Bù tsiꞌì bɨ̀tsɨ̀m, nɨ̀ ka ghɨ̀rə màꞌàtə̀ gha khə̀kə̀ nɨ̂tugə siì, ǹloŋ mə a tswe a mûm àŋwàꞌànə̀ Nwî mə, ‘Mə̀ ka zwitə ntsèèmbi tâ àkàrə mbinjə̀rə̂ yi tâ à jaꞌanə.’ ");
INSERT INTO bfd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lâ nòò yìi mə mə̀ ka yǐ yweenə nɨ nɨ̀wo aa, mə̀ ka yǐ tsyǎ a mbìi bù, ɨ fòo ŋghɛ̀ɛ̀ a Galilea.” ");
INSERT INTO bfd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peta swoŋ ghu mbo mə, “M̀bə bə̀ bɨ̀tsɨ̀m tɛꞌɛ kɨ màꞌàtə̀ nɨ̂ ghô màꞌàtə̀ khə̀ boŋ kaa mbə mə̀ waꞌà gho màꞌàtə̀ bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu a kwiꞌi ghu mbo mə, “Mə̀ swǒŋ a mbo wò tsiꞌì ànnù nɨ̂ŋkoŋ mə, tsiꞌì nɨ̀tugə sìi, m̀bɔŋ tâ àŋkə̀gə̀ tâ à tɔŋ boŋ ò tùù mə̂ ghâ ŋ̀gàà ji tarə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peta a kwiꞌi mə, “À tɛ̀ꞌɛ kɨ bə bə̂ ànnù nɨ̀wo boŋ mə̀ ka kwo biꞌò; kaa m̀bə mə̀ waꞌà gho tuù.” Ŋ̀gǎŋyəgə̂nnù Yesu jyâ tsɨ̀m bo lɛ ŋkɨ nswoŋ tsiꞌì maa ajàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu a bɔꞌɔ nɨ ŋgǎŋyəgə̂nnù ji jya ghɛ̀ɛ̀ mə̂ nyweꞌe a adɨgə yî mɔ̀ꞌɔ yìi mə bɨ lɛ sɨ twoŋə nɨ Getsemane aa, Yesu a swoŋ a mbo bo mə, “Nɨ̀ tswe faà, tâ mə̀ ghɛɛ ntsàꞌàtə̀ Nwî fiì.” ");
INSERT INTO bfd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yesu à kà mə aa ŋghɛɛ aa, ǹlɔ̀gə̀ Peta a bɔꞌɔ nɨ bɔɔ bɨ Zebedee bya bi baà. Nû yì ɨ̀ lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka mbɨꞌɨ, ǹtɨɨ̀ yi ɨ luu nɨ̂ àjəŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yesu a swoŋ a mbo bo mə, “Àjəŋnə̀ a luu a ntɨɨ mə̀ siꞌi mburə mbə tsiꞌi a nzwitə mə̀; nɨ̀ tswe faà, ǹtswe nɨkɨrə̀ biꞌinə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A maꞌàtə̀ waa, ŋghɛntə a mbìì, ŋ̀wo nnɔ̀ŋə a nsyɛ a kùu kuu, ǹtsaꞌatə Nwî ǹswoŋ mə, “Taà ghà, m̀bə mânjì a tswe ghu, Ò ghɨrə̀ mə tâ ǹdɔ̂ŋ ŋ̀gɨꞌɨ yuà ɨ tsyâ. Lâ mə kɔ̀ŋ aa ŋghɨ̀rə annù yìi mə o lɔ̀ɔ̀ aà, kaa waꞌǎ bə̂ ànnù yìi mə mə lɔ̀ɔ̀ aa bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A bɨɨnə̀ m̀bɨɨ ŋghɛ̀ɛ̀ a mbɛɛ ŋgǎŋyəgə̂nnù ji jya ǹyə bo bɨtsɨ̀m bwiì. A twoŋtə̀ Peta m̀betə ghu mbo mə, “M̀bə nɨ̀ waꞌà nɨkərə̀ bìꞌinə̀ a nɨ àbàŋtə̀ noò yî fùùrə̀ tswê aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nɨ̀ ka ntswe nɨkərə̀ ǹtsaꞌatə nɨ̂ Nwî ta waꞌǎ a ŋkɨ̀rə̀ Satan lô ŋ̀wo; mə̀ zi mə ntɨɨ̀ ghuu ɨ lɔ̀ɔ ŋghɨrə ànnù yìi a kuꞌunə aà, lâ njyǎnû yùù ɨ bâŋnə̀ m̀bɔrə.” ");
INSERT INTO bfd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu a maꞌàtə̀ waa, m̀bu ŋghɛ̀ɛ̀ ǹtsaꞌatə Nwî mə, “Taà ghà, mbə a bə yìi mə mânjì kaa à sɨ̀ ghu tswê a ŋkwɛrə ndɔ̂ŋ ŋ̀gɨꞌɨ yù a mbo mə̀, tǎ tâ mə̀ tsuu no, Ò tɨgə̀ ŋ̀ghɨrə bə̂ ànnù yìi mə o lɔ̀ɔ̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A bû m̀bɨɨ ŋghɛ̀ɛ̀, ǹyə ŋgǎŋyəgə̂nnù ji jya ɨ burə̀ kɨ bwii tsiꞌì bwìì, ǹloŋ mə fɨ̀lo lɛ nluu a miꞌi bo aà. ");
INSERT INTO bfd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A maꞌàtə̀ waa mbu ŋghɛ̀ɛ̀ ǹtsaꞌatə a Nwî a nɨ̂ ŋ̀gàà yìi mə ɨ̀ yweꞌe ji tarə aa, m̀bu nswoŋ tsiꞌì ànnù ya yìi mə a lɛ mfòò ǹswoŋ a mbìì aà ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","À màŋsə̀ mə̂, m̀bu mbɨ̀ɨ̀ wa a mbɛ̀ɛ ŋgǎŋyəgə̂nnù ji jya, ǹswoŋ a mbo bo mə, “Nɨ̀ burə ka kɨ bwii tsiꞌì bwìì, m̀mɨɨntə nɨ̂ ghuu aa ɛ? Wa nòò à tɨgə a abô; bɨ fèè mə Mu Ŋù a mbo bə̀ bî bɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bɨ̀ɨ̀nə nɨ̀ tâ bìꞌinə̀ ghɛɛ, wa ŋù yìi mə à fèe gha aa, à zì mə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu à kà mə aa ŋghaa laà, kaa mburə tɨ màŋsə̀, Judas, ŋù yì mɔ̀ꞌɔ wa a tɨtɨ̀ɨ ŋgǎŋyəgə̂nnù Yesu jya nɨ̀ghûm ǹtsò baa, a burə̀ ǹzi bo bɨ̀ ǹnɔ̀ɔ̀ bə̂ yî ghàꞌàtə̀ mə bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwi nɨ̂ ŋ̀gǎŋdɨꞌɨ nɔ̀ŋsə̀ bo bɨ bɨ̀tà bɨ alaꞌa bo lɛ ntoo. Bo lɛ ntugɨtə nwi ntsò nɨ mɨ̀buꞌù. ");
INSERT INTO bfd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, yìi mə à lɛ mfèè yi aa, à lɛ mfa alènsə̀ a mbo bo mə, “Ŋù yìi mə mə̀ ka ghɛ̀ɛ nɔŋ mɨghə̀gə̂ mi aa, boŋ à nɨ ghu; nɨ̀ baŋnə̀ yi.” ");
INSERT INTO bfd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","À zì mə̂, m̀burə ntsinə ŋghɛɛ a mbɛ̀ɛ Yesu, ǹnɔŋ mɨghə̀gə̂ mi, ǹswoŋ ghu mbo mə, “Rabbi, mə tsàꞌàtə̀ nɨ̂ ghô.” ");
INSERT INTO bfd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu a kwiꞌi ghu mbo mə, “Nsû ghà, ghɨ̀rə annù yìi mə̀ ò tswe nɨ̂ ŋ̀ghɨ̀rə aà.” Bə̀ bya mə bo bɨ̀ Judas lɛ nzì aa, bo tɨgə̀ m̀baŋnə Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bo bàŋnə̀ mə̂ yi aa, ŋ̀gàŋyə̀gə̂nnù yì wa yì mɔ̀ꞌɔ a tsɔꞌɔ munwi yì ŋ̀kwyɛ atôŋnə̌ abùꞌu ŋgàŋmàꞌa Nwì yî ŋ̀wè ghu nlɔꞌɔsə. ");
INSERT INTO bfd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu a swoŋ ghu mbo mə, “Nɨŋə munwi ghò wa fu a mbaꞌà, ǹloŋ mə ŋù yìi mə à sɔ̀ŋə munwi a mbaꞌa aa, a ka yì kɨɨ kwo aa tsiꞌì nɨ̀wo nɨ munwi. ");
INSERT INTO bfd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ò sɨ̀ zi mə mbə mə̀ betə̀ Taà ghà a tsyâsə̀ ǹda bɨ̂mânjɔ̀ŋ bɨ baangel bìi mə bɨ tsyatə ntsùꞌù nɨghûm ǹtsò baà aa, tsiꞌì tsɨ̀tsɔ̀ŋ tâ bɨ̀ zi ŋkwɛtə gha aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mbə mə̀ ghɨrə ma mùu ajaŋ boŋ kaa ànnù yìi mə àŋwàꞌànə̀ Nwî a swoŋ aa, kaa a ka waꞌà nɨ̂ ànnù nɨ̂koŋ fɛ̀ꞌɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesu à ghàà mə̂ laà aa, m̀bəŋ mbetə nɔ̀ɔ̀ bə̂ bya mə, “Nɨ̀ zi nɨ̀ nwi ntsò a bɔ̀ꞌɔ nɨ mɨ̀buꞌu aa a ntswa mə̀ tsǒ nɨ̀ zi a mbaŋnə àŋgâmɨghee aa ɛ? Tɨgə mə̀ kɨ̀ sɨ tswe biꞌinə̀ a Ndâmaꞌanwì aa a njwi njwi ndɨ̀ꞌɨ̀ nɨ ghuu, kaa nɨ̀ waꞌà gha tswa aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lâ ɨ̀nnù ma jû tsɨ̀m ɨ fɛꞌɛ aa, a nlwensə nɨ̀ghàà nìi mə ŋ̀gǎŋntoo Nwî ɨ lɛ ŋwàꞌànə̀ aà.” Ŋ̀gǎŋyəgə̂nnù Yesu jyâ tsɨ̀m ɨ tɨgə̀ m̀maꞌatə yi ŋ̀khəkə waa. ");
INSERT INTO bfd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bə̀ bya mə bɨ lɛ ntswa Yesu aa lɛ ntɨgə nlɔgə yi ŋghɛɛ nɨ ghu a nda Kaifas, ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè, a adɨgə yìi mə ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ nɨ bɨ̀tà bɨ alaꞌa lɛ ŋghotə ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peta à lɛ sɨ tɨgə nyoŋə a njɨ̀m, ǹtəə nii nɨ a sàꞌa aghaꞌà. À yòŋ mə̂ ǹyweꞌe a ndùgə Kaifas laa, ŋ̀kuu ntswe a nsàŋàbɛ̀ɛ̀ bo bɨ̀ ŋgǎŋmbɛ̂ ǹdâmàꞌanwì a nyə̂ ànnù yìi mə bɨ ka ghɨ̀rə̀ a nu Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ ŋgǎŋndasaꞌa lɛ sɨ lɔɔ nɨ mânjì yìi mə mbə bə̀ swôŋ ɨ̀bàŋnənnù a atu Yɛɛsɔ̂ tâ bo tsya ghu nzwitə yi. ");
INSERT INTO bfd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lâ kaa waꞌà yə̂, ka mə bɨ̂yəfə bɨ abǎŋnənnù bî ghàꞌàtə̀ lɛ mfɛ̀ꞌɛ̀ ǹtswɛɛ ɨbàŋnənnù ghu atu aà. Ǹgǎŋabaŋnənnù jya jǐ mɔꞌɔ ji baa ɨ fɛꞌɛ̀ ǹtəə nswoŋ mə: ");
INSERT INTO bfd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“M̀bâ ghulà à lɛ nswoŋ mə yu tswe nɨ̀ àdàꞌà a nsàꞌa ǹdâmàꞌanwì ɨ bǔ ghùrə̀ fu a njɨ̌m njwi ji tarə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè a bɨɨ̀nə̀ ǹtəə mbetə Yesu mə, “Ò sɨ nɨ̂ ànnù yî tsu a kwiꞌi tswê? Ò swǒŋ mə akə nɨ̂ ɨ̀nnù jû mə bɨ swoŋə a atu wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu a təə kaa waꞌà yi kwɛꞌɛ̀. Kaifas a bû ǹswoŋ ghu mbo mə, “Kàà nɨ̂ Ɨ̀kùm Nwî yìi à tswe ntɨ̀ɨ̀ aa mə o swoŋ aa tsiꞌì ànnù nɨ̂koŋ mə ò nɨ̂ Àyɔꞌɔ̀ Nwì wa mə à nɨ Mu Nwì aa lɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu a kwiꞌi ghu mbo mə, “Ò swòŋ mə̂. A ŋghɛ̀ɛ ghu, mə̀ swǒŋ a mbo bù mə, ǹlɔgɨnə tsɨ̂tsɔ̀ŋ, nɨ̀ ka yə Mu Ŋù tâ à tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ Nwì yìi mə à tswe nɨ̂ mɨ̀dàꞌà aa ni màꞌà, ǹlo a aburə nsɨgə nɨ a mûm m̀bàꞌà.” ");
INSERT INTO bfd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","À kwìꞌì mə̂ laà, ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè wa a satə̀ ɨ̀tsə̀ꞌə̂ ji, ǹswoŋ mə, “À bə̀gɨ̀tə Nwî! Nɨ̀ yùꞌû àjàŋ yìi mə à bə̀gɨ̀tə Nwî aà. Bìꞌinə̀ bù ǹlɔɔ nɨ̂ bɨ̀yəfə aa, a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kə̀ nɨ̀ wàꞌàtə mə akə lɛ?” Bo bɨtsɨ̀m bo kwiꞌi mə, “A kuꞌunə mə tâ à kwo.” ");
INSERT INTO bfd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bo swòŋ mə̂ laà aa, ǹlɔgɨnə ntɨgə tsee mɨ̀twyɛ ghu nsi, ŋ̀ghɔɔ nii, bǐ mɔꞌɔ bɨ fɛɛ̀ nii, m̀betə nii nɨ mə: ");
INSERT INTO bfd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Tsǒ mə ò swǒŋ mə ò nɨ Àyɔꞌɔ̀ Nwì aa, twi ŋû yìi mə à fɛ̀ɛ gho aà.” ");
INSERT INTO bfd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Maa noò Peta a tswê wa nsàŋàbɛ̀ɛ̀. Ŋ̀gàŋàfàꞌa Kaifas yî màŋgyɛ̀ yî mɔ̀ꞌɔ a zî ǹyə yi, m̀betə yi mə: “Tɨgə ò ghɨ̀rə mbaa ŋkɨ ntswe bu Yesu mu baGalilea wa aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peta a tuu a nsi miꞌi bo bɨtsɨ̀m, ǹswoŋ mə, “Kaa mə̀ sɨ̌ annù yìi mə o swoŋ aa zî.” ");
INSERT INTO bfd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Peta à ghàà mə̂ mùu ajàŋ aa, m̀fɛ̀ꞌɛ̀ ŋ̀ghɛɛ a ntsǔbùꞌù. À fɛ̀ꞌɛ̀ mə̂, ŋ̀gàŋàfàꞌà yî màŋgyɛ̀ yî dàŋ a bû ǹyə yi, ǹswoŋ a mbo bə̀ bya mə bo bo lɛ ntəə aa mə, “Ŋù ghulà à ghɨ̀rə ntswe bo Yesu mu Naaserə wâ.” ");
INSERT INTO bfd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peta a kuꞌùsə̀ ǹtuu, ŋ̀kaa nswoŋ mə, “Kaa mə̀ sɨ̀ ŋû ma wî zî.” ");
INSERT INTO bfd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mu fɨ̀bàŋtə̀ à bù mə̂ ŋ̀ghə̀ə kɨ bə, bə̀ bya mə bo bɨ̀ Peta lɛ ntəə aa, bû ǹswoŋ ghu mbo mə, “O lɔ̀ɔ̀ aà ǹswoŋ mə kaa ò sɨ ŋgàŋyəgə̂nnù Yesu yî mɔ̀ꞌɔ bə? Mânjì yìi mə o ghàà ghu aa, a dɨ̀ꞌɨ̀ mə bu Yesu lo aa adɨ̀gə̀ yî fùùrə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peta a lɔgɨ̀nə̀ ǹtɨgə ŋkaa nswoŋə nɨ mə, “Kaa mə sɨ̀ ŋû yî zî. Bɛɛ a bə yìi mə mə swoŋə aa àbǎŋnənnù, Nwì nɨ̂ŋ ǹdɔ̀ɔ̀ a atu mə̀.” Tsiꞌì maa noò àŋkə̀gə̀ a tɔŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Àŋkə̀gə̀ wâ à tɔ̀ŋ mə̂, Peta a waꞌatə̀ ànnù ya yìi mə Yesu à ghɨ̀rə nswoŋ ghu mbo aa mə, “M̀bɔŋ tâ àŋkə̀gə̀ à tɔŋ, lɛ boŋ ò tùù mə̂ ghâ ŋ̀gàà ji tarə̀”. À wàꞌàtə̀ mə̂, m̀fɛꞌɛ ŋghɛ̀ɛ̀ ǹyəꞌə tsiꞌì a mbə̂ ànnù. ");
INSERT INTO bfd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Àbɛ̀ɛ̀ fùꞌù mə̂, bɨlɨɨ bɨ ŋgǎŋmàꞌa Nwì bɨtsɨ̀m a bɔ̀ꞌɔ nɨ bɨ̀tà bɨ alaꞌa bɨ̀tsɨ̀m bo boòntə̀ a ntaŋtə ajàŋ yìi mə bo ka zwitə Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bô tàŋtə̀ mə̂ m̀maŋsə, ŋ̀kwerə mbô mɨ Yesu, ǹlɔgə yi ŋghɛɛ mfa a mbo Pilato, mə à lɛ mbə Gûmnàà aà. ");
INSERT INTO bfd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas mə à lɛ mfèè Yesu aa, à yə̀ mə ajàŋ yìi mə bɨ swoŋ mə bi ka zwitə Yesu aà, ǹtɨɨ̀ yi ɨ saꞌà yi, a lɔgə̀ ɨ̀bàtə ŋkabə silva jya mɨ̀ghum mi ntarə ŋghɛ̀ɛ̀ m̀fa fu a mbo bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì a bɔ̀ꞌɔ nɨ bìtà bɨ alaꞌa, ǹswoŋ a mbo bo mə, ");
INSERT INTO bfd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Mə̀ ghɨ̀rə̂ ɨ̀bɨ̂ ǹloŋ mə mə̀ fèe ŋû tɨghə̂ mə à ghɨ̀rə̂ ànnù yî bɨ yì tsu aà!” Bo kwiꞌi ghu mbo mə, “Ma ya a yə yi aa nɨ àkə̀? Â ka zi wô zi annù yìi mə ò ka ghɨ̀rə̀ nɨ yu aà.” ");
INSERT INTO bfd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas a maꞌà ŋ̀kabə ya a mûm ǹdâmàꞌanwì, m̀fɛꞌɛ ŋghɛ̀ɛ̀ ǹləŋə. ");
INSERT INTO bfd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bɨ bwɛɛ̀ ŋ̀kabə ya nswoŋ mə, “Nɔ̀ŋsə̀ yìꞌinə̀ à dɨ̀ꞌɨ mə kaa à sɨ̀ kuꞌùnə̀ mə tâ bɨ̀ ləə ajàŋə ŋkabə ma yû a mûm àbàa ŋkabə̀ ǹdânwì ǹloŋ mə à nɨ̂ ŋ̀kabə̀ àləə aà.” ");
INSERT INTO bfd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bo swòŋ mə̂ laà aa, ǹtswe a nsyɛ ŋghàànə̀, ǹlɔgə ŋkabə ya ŋghɛ̀ɛ̀ ǹyuu adɨgə ŋû m̀bɔ̀ɔ bàntɔ̀ɔ̀ ghu, tâ bɨ̀ ka ntwiŋə nɨ̂ bɨ̀gɨ̀ɨ̀ ghu. ");
INSERT INTO bfd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ǹzi nyweꞌe sii, bɨ twoŋə adɨgə mayû aa nɨ Àdɨ̀gə Aləə̀. ");
INSERT INTO bfd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ma yû ànnù a kɨ̂ m̀fɛꞌɛ mbòòntə̀ nɨ̂ ànnù yìi mə ŋ̀gàŋntoò Nwi Yeremiah à lɛ nswoŋ aà, mə, “Bɨ lɛ nlɔ̀gə ɨbàtə ŋkabə silva jya mɨ̀ghum mi ntarə mə bɔɔ bɨ baIsrael lɛ ntaŋ mə bɨ ka yi tu a atu yu ma wa aa, ");
INSERT INTO bfd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ŋghɛ̀ɛ̀ ǹyuu adɨgə ŋû m̀bɔɔ bàntɔ̀ɔ̀ ghu, tsiꞌǐ a ajàŋ yìi mə M̀màꞌàmbî à lɛ nswoŋə a mbo mə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya nɨ bɨ̀ bɨ̀tà bɨ alaꞌa bya bo tɨgə̀ ǹlɔgə Yesu ŋ̀ghɛɛ nɨ ghu a nsi Gûmnàà. Gûmnàà a betə̀ yi mə, “Ò bə aa m̀fɔ̀ baYuda aa ɛ?” Yesu a kwiꞌi mə, “Ò swòŋ mə̂!” ");
INSERT INTO bfd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì a bɔ̀ꞌɔ nɨ bɨ̀tà bɨ alaꞌa bo lɛ nɨŋ ɨnnù a nu Yesu a nsi Pilato. La Yesu a naꞌà waa bɨtsɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato a tɨgə̀ m̀betə ghu mbo mə, “Ò sɨ ndùu ɨnnù jù mə bɨ swoŋə nɨ mə ò ghɨ̀rə aa yuꞌu?” ");
INSERT INTO bfd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ànnù a lɛ mburə ntsya Gûmnàà tsiꞌì tsyà a nyə mə kaa Yesu à lɛ ŋwaꞌà ànnù yî tsu burə ŋkwikwiꞌi bə aà. ");
INSERT INTO bfd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","À lɛ mbə nɔ̂ŋsə̀ Gûmnàà mə a yi mbə njwî Passa aa a fiꞌisə̀ ŋ̀gàŋàtsaŋ yì m̀fùùrə̀ yìi mə bə̀ lɛ ŋkɔ̀ŋ aa mfa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma mùu noò ŋ̀gàŋàtsaŋ yì mɔ̀ꞌɔ à lɛ ntswe a atsàŋ mə bə̀ bî ghàꞌàtə̀ bɨ lɛ nzi yi, bɨ twoŋə̀ nii nɨ Barabas. ");
INSERT INTO bfd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ǹnɔ̀ɔ̀ bə̂ bya bɨ ghòtə̀ mə̂ aa, Pilato a betə̀ waa mə, “Nɨ̀ kɔ̌ŋ mə tâ mə̀ fiꞌisə aa wò mfa a mbo bù, Barabas kə̀ Yesu mə bɨ twoŋə nɨ Àyɔꞌɔ̀ Nwì aa lɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato à lɛ mbetə ma mùu ajàŋ aa, nloŋ mə à lɛ nzi mə â lɛ ŋghɨ̀rə àghə̀ꞌə̀nə̀ mə tâ baYuda tswa Yesu ǹzi mfa ghu mbo aà. ");
INSERT INTO bfd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato à tswè mə̂ a aləŋə nsaꞌa mɨ̀saꞌa, ŋ̀gwɛ̂ yì a toò ŋ̀kɨ̀ɨ̀ ghu nu mə, “Sìꞌi mbô mo wa a nu ŋù wâ, ǹloŋ mə kaa à sɨ̌ annù yî tsu fânsə̀ aà. Mə̀ swoŋ laà aa ǹloŋ mə ǹjə̀ə̀ yî m̀bɨ̂ ɨ̀ ghɨ̀rə nlɛ gha sìi a ŋgaa yu.” ");
INSERT INTO bfd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lâ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì a bɔ̀ꞌɔ nɨ bɨ̀ta bɨ alaꞌa bɨ totə bə̂ bya mə tâ bɨ̀ betə Pilato tâ fiꞌisə Barabas tǎ tâ bɨ̀ baŋnə nzwitə Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gûmnàà a bû ŋ̀kuꞌusə mbetə waa mə, “A tɨtɨ̀ɨ bə̀ buà bi baa, nɨ̀ lɔ̀ɔ mə tâ mə̀ maꞌatə aa ghuu?” Bo kwiꞌi bɨ̀tsɨ̀m mə, tâ bɨ̀ fiꞌisə Barabas. ");
INSERT INTO bfd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato a bû m̀betə waa mə, “Nɨ lɔ̀ɔ mə tâ mə̀ tɨgə ŋghɨrə aa mə akə nɨ Yesu ghû mə bɨ twoŋə nɨ Àyɔꞌɔ̀ Nwì aa ɛ?” Bo tɔŋnə̀ ǹswoŋ mə, “Ta bɨ̀ kweentə yì a ati bàŋnə̀bàŋnə̀.” ");
INSERT INTO bfd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato betə̀ mə, “Nɨ lɔ̀ɔ̀ mə bɨ̀ kweentə yi aa a ya? Ànnù yî bɨ yìi mə à bùꞌù aa à nɨ̂ àkə̀ aa ɛ?” Lâ bo bû ŋ̀kuꞌusə ntɔŋnə ghaa bə nɨ̀ mɨ̀tɨ̀ɨ̀ ǹswoŋ mə tâ bɨ̀ ghɛɛ ŋkwèèntə̀ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato à lɛ nyə mə yu ghɛ̀nsə̀ aa nòò yì, ŋ̀kɨ nzi mə yu bə ghɛ̀ɛ̀ nɨ̂ m̀bìì boŋ fɨ̀kɔ̀rə̀ fɨ ka fɛ̀ꞌɛ̀. Ǹswoŋ bɨ zî nɨ̂ ŋ̀kì, a siꞌì m̀bô mi ghu a nsi bə̀ bɨ̀tsɨ̀m, ǹswoŋ mə, “Kaa àbô ya kaa a sɨ̀ a nɨ àləə nu ŋû ghû mə nɨ lɔ̀ɔ̀ a nsaansə aa tswê. A annù yìi mə nɨ lɔ̀ɔ̀ a ŋghɨ̀rə aa, a zi tsiꞌì bù.” ");
INSERT INTO bfd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bə̀ bɨtsɨ̀m bɨ kwiꞌi mə, “Ɨ̀ɨ̀ŋə, tâ àləə nû yi tâ kuu a atu bìꞌì bo bɨ̀ a atu bɔɔ̀ biꞌi.” ");
INSERT INTO bfd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato a fiꞌisə̀ Barabas m̀fa a mbo bo, ŋ̀ghɨrə bɨ ghɔɔ̀ Yesu, a fâ yi mə tâ bɨ̀ tɨgə nlɔgə ŋghɛ̀ɛ̀ ŋkweentə a ati bàŋnə̀bàŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bɨ̀sogyɛ̀ bɨ Pilato tɨgə̀ ǹlɔgə Yesu ŋ̀kuu ŋghɛɛ nɨ ghu a mûm ntɔꞌɔ Gûmnàà (mə bɨ lɛ sɨ twoŋə nɨ Praetorium aà), ǹtwoŋ bɨ̂sogyɛ̀ bɨtsɨ̀m bɨ zî ŋ̀ghotə ghu nsî. ");
INSERT INTO bfd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bo tsɔꞌɔtə̀ ɨ̀tsə̀ꞌə̂ ji, ǹlɔɔ atsə̀ꞌə̀ yî ghə̀ꞌə̀ boò ŋ̀wɛꞌɛ ghu nû. ");
INSERT INTO bfd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bɨ wɛ̀ꞌɛ̀ mə̂, ǹlɔɔ mɨ̂ndɨgə mɨ njɔ̂ŋ ǹjɔŋ mbaꞌa tsǒ atsə̀ꞌətu nɨfɔ̀ ǹsosə ghu atû. Ŋ̀kɨ mfa ŋkɨ̀ŋkàꞌà ghu abo yì màꞌà. Ǹtɨgə ŋwyɛ nii nsigɨtə ŋwo ghu nsi nswoŋə nɨ mə, “O lɛlɛ lɛɛ̀! M̀fɔ̀ baYuda à kɨ̀ kwɛ̀ɛ̂! À kwɛ̀ɛ̂!” ");
INSERT INTO bfd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bo lɛ sɨ kɨɨ ntsee nɨ mɨ̀twyɛ ghu nu, ŋkɨɨ ŋghɔɔ nɨ̂ àtû yi nɨ̂ ŋ̀kɨ̀ŋkàꞌà yâ. ");
INSERT INTO bfd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bɨ̀sogyɛ̀ bya bɨ nàŋsə̀ mə̂ ŋ̀wyɛ yi laà aa, ntsɔꞌɔ atsə̀ꞌə̀ yî bagɨtə ya ghu nu, m̀bu ŋwɛꞌɛ jìi ɨtsə̀ꞌə̀ jya fu ghu nu, ǹtɨgə nlɔgə yi mə bo ghɛ̀ɛ kwèèntə̀ a ati bàŋnə̀bàŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bo kà mə aa ŋghɛɛ a mânjì, ǹyə ŋû baCerene yî mɔꞌɔ, ɨ̀kǔm yi ɨ bə Simon, ǹtswa yi nɨ àdàꞌà mə tâ à beꞌe ati bàŋnə̀bàŋnə̀ Yesu yâ. ");
INSERT INTO bfd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bo ghɛ̀ɛ̀ mə̂ ǹyweꞌe wa adɨgə yìi bɨ lɛ sɨ twoŋ nɨ Golgota aa, (ǹjiꞌì ɨ̀kùm ma ghû ɨ bə mə, àdɨgə akwɛɛ atu ŋû) ");
INSERT INTO bfd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ǹlɔɔ mɨlùꞌù mìi bɨ lɛ mfɔrɨnə nɨ̂ àfù yìi bɨ twoŋə nɨ gall aa mfa ghu mbo mə tâ no. Yesu a yweꞌetə̀ ǹtuu yi a nnô. ");
INSERT INTO bfd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bɨ̀sogyɛ̀ bya kwèèntə̀ yi a ati bàŋnə̀bàŋnə̀, m̀maꞌa ɨbìrə̀ a nyə bə̀ bìi mə bɨ ka jɨ ɨtsə̀ꞌə̀ ji jyâ. ");
INSERT INTO bfd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bɨ ghɨ̀rə̀ mə̂ laà aa, ntswe nsyɛ ntɨgə mbɛ nii. ");
INSERT INTO bfd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bɨ lɛ ŋŋwàꞌànə annù yìi mə à lɛ ŋghɨ̀rə̀ bɨ nɨ̂ŋ ɨ̀saꞌa ghu nu aa mbɛɛ wa ati bàŋnə̀bàŋnə̀ ghu atu mə, “À nɨ Yesu, M̀fɔ̀ bàYuda à ghuà mə.” Ma yû a dɨꞌɨ̀ nɨ ànnù yìi mə à lɛ ŋghɨ̀rə̀ bɨ kweèntə̀ yi aà. ");
INSERT INTO bfd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bɨ lɛ ŋkɨ ŋkweentə bɨ̂yə̀rə bi baa bo bɨ̀ Yesu, ŋ̀kweentə yî m̀fùùrə̀ ghu mbɛ̀ɛ̀ a abo màꞌà, ŋ̀kɨ tɨgə ŋkweentə yî mɔ̀ꞌɔ ghu mbɛ̀ɛ̀ a abô ŋ̀kwàbə̀. ");
INSERT INTO bfd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bɨ̀tsyà bɨ mânjì bɨ lɛ sɨ wyɛ̀ nɨ̂ Yesu ntsɨgə nɨ̂ ɨ̀tû jyaa nswoŋə nɨ ghu mbo mə, ");
INSERT INTO bfd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Wò yìi mə ò lɛ nswoŋ mə ò ka sàꞌa ndâmàꞌanwì ɨ bǔ bɔɔ fu a jɨ̌m njwi ji tarə aa, yweensə ɨtu ɨbɨ̀ɨnû gho lâ. M̀bə a bə annù nɨ̂ŋkoŋ mə ò nɨ Mu Nwì, ò sɨgə la fya atu ati bàŋnə̀bàŋnə̀ bìꞌì yə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì, bo bɨ̀ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ nɨ bɨ̀tà bɨ alaꞌa bo lɛ ŋkɨɨ ŋwyɛ nɨ̂ Yesu tsiꞌì mùu ajàŋ mə, ");
INSERT INTO bfd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“À lɛ sɨ yweensə badàŋ, tâ waꞌǎ ɨbɨ̀ɨ nû yi yumbɔŋ tsɨ̀tsɔ̀ŋ yweensə̀ la tâ bìꞌinə̀ yə. À nɨ yu yìi mə à nɨ Mfɔ̀ baIsrael aà. Tâ à sɨgə la fìi atu ati bàŋnə̀bàŋnə̀ boŋ bìꞌinə̀ ka bii annû yi. ");
INSERT INTO bfd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","À lɛ nnɨŋ ntswêntɨ̀ɨ̂ yǐ ntsɨ̀m a mbo Nwì; tâ Nwì à waꞌà yi tsɨ̂tsɔ̀ŋ zî ŋ̀kwɛtə la, mə mbə a kɔŋə yi. À lɛ mbaa tɛꞌɛ̀ waꞌà swoŋə̀ nɨ mə yu nɨ Mu Nwì aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɨ̀yərə bya mə bɨ lɛ ŋkwèèntə̀ waa bo aa, bo lɛ sɨ kɨɨ mbəgɨtə nɨ̂ Yesu tsiꞌì mùu ajàŋ. ");
INSERT INTO bfd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ɨ̀tugə ɨ lɛ mfii ŋkusə alaꞌà tsɨ̀m, ǹlɔgɨnə nɨ nòò ǹsiꞌi nòò ŋ̀ghɛɛ nyweꞌe nɨ nòò nyə̌ŋ nòò. ");
INSERT INTO bfd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nòò nyə̌ŋ nòò à kà mə aa ŋkuꞌu, Yesu tɔŋnə̀ nyəꞌə nswoŋ mə, “Eli, Eli, lama sabachthani?” Ma la a bə mə, “Nwìŋgɔ̀ŋ ghà, Nwìŋgɔ̀ŋ ghà, ò mèꞌe gha aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bə̀ bya bǐ mɔꞌɔ mə bɨ lɛ ntəəntə maa adɨgə aa bɨ yuꞌu nswoŋ mə “Ŋù ghû a twoŋ aa Elijah.” ");
INSERT INTO bfd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ŋù yî mɔ̀ꞌɔ a tɨtɨ̀ɨ bo a burə̀ ŋ̀ghɛɛ nlɔ̀ɔ̀ kûntsa ntsu nɨ mɨ̀lùꞌù mî tsə̀ꞌə̀, ǹsɔꞌɔnə a nɨ̂ ŋ̀kɨ̀ŋkàꞌà, ŋ̀kɔꞌɔsə mfa mə tâ Yesu à no. ");
INSERT INTO bfd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lâ bi mɔꞌɔ bɨ swoŋ mə “yuꞌutə tâ bìꞌinə̀ yə mə Elijah à ka zi kwɛtə yi lɛ.” ");
INSERT INTO bfd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu a bû ŋ̀kuꞌusə ŋŋɛntə njì yì ǹyəꞌə mburə ntsɨɨ. ");
INSERT INTO bfd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Maa noò, àtsə̀ꞌə̀ ya yìi mə a lɛ ŋkwàsə mûm ǹdâmàꞌanwì aa, a lɛ mbòꞌònə̀ a tɨtɨ̀ɨ̀, ǹlɔgɨnə a ndəŋ nsɨgə nyweꞌe a nsyɛ̂, ɨ̀dɨ̀gə̀ ɨ tsɨgə̀nə̀, ɨ̀lâŋsəŋgɔ̀ꞌɔ̀ ɨ baꞌàkə̀. ");
INSERT INTO bfd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mɨ̀syɛ̀ mɨ ŋaꞌakə̀ bə̀ bɨ Nwî bî ghàꞌàtə̀ mə bɨ lɛɛ̀ ŋ̀kwokə aa, bɨ bɨɨ̀nə̀ nɨwô. ");
INSERT INTO bfd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bə̀ ma bû bɨ lɛ mfɛ̀ꞌɛ̀kə̀ a mɨsyɛ̀, ŋ̀kuu ŋghɛɛ wa mûm àlaꞌa yì làà, bə̀ bî ghàꞌàtə̀ bɨ yə̂ waa a nòò yìi mə Yesu à lɛ nyweenə nɨwo aà. ");
INSERT INTO bfd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Àtu bɨ̂sogyɛ̀ ya bo bɨ̀ bɨ̀sogyɛ̀ bya bɨ̀tsɨ̀m mə bo lɛ ntswe mbɛ nɨ̂ Yesu aa, bô yə̀ mə̂ a ajàŋ yìi mə ǹsyɛ̂ ɨ̀ tsɨ̀gɨ̀nə aa, a bɔ̀ꞌɔ nɨ ɨ̀nnù tsɨ̀m jìi mə ɨ lɛ mfɛ̀ꞌɛ̀ aa, nɨ̀bɔꞌɔ nɨ tswâ waa, bo swoŋ mə, “Tsiꞌì ànnù nɨ̂koŋə̀, ŋù ghuà à bə aa Mu Nwì.” ");
INSERT INTO bfd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bàŋgyɛ̀ bî ghàꞌàtə̀ bɨ lɛ tswe ghu, ǹtəə a sàꞌa aghaꞌa, ǹlìì. À lɛ mbə bâŋgyɛ̀ ma bû mə bɨ lɛ nlò a Galilea ǹyoŋə nɨ̂ Yesu, ŋ̀kwɛtə nii aà. ");
INSERT INTO bfd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A tɨtɨ̀ɨ bàŋgyɛ̀ ma bû, Mary Magdalene, Mary ǹdè bɨ̀ Jɛms nɨ Joseph, a bɔ̀ꞌɔ nɨ ǹdè bɨ̀ bɔɔ bɨ Zebedee, bo lɛ ntswe ghu. ");
INSERT INTO bfd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nòò ŋ̀kwɛ̂fɔ̀ à kùꞌù mə̂, ŋ̀gàŋkabə yì mɔꞌɔ, mə à lɛ nlo a alaꞌa Arimathea, bɨ twoŋə̀ nɨ Joseph, ŋ̀kɨ mbə ŋgàŋyə̀gə̂nnù Yesu yî mɔ̀ꞌɔ aa, a zî ");
INSERT INTO bfd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ŋ̀ghɛɛ a mbɛ̀ɛ Pilato a mbetə aku Yesu ya mə yu lɔ̀gə̀ ɨ ghɛ̀ɛ twiŋə. Pilato a fâ àdàꞌà mə tâ bɨ̀ fa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joseph a tɨgə̀ ŋ̀ghɛɛ nlɔ̀gə aku Yesu ya nlɨm nɨ̂ àtsə̀ꞌə̀ yî fùꞌù yî sɨgɨ̀nə̀ yî fii, ");
INSERT INTO bfd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ŋ̀ghɛɛ nɨŋ a mum nɨ̀syɛ̀ ni nî fii nìi mə à lɛ ntoŋ a mûm àlâŋsəŋgɔ̀ꞌɔ̀ aà. À nɨ̀ŋ mə aa, ǹtii alâŋsə̌ŋgɔ̀ꞌɔ̀ yî mɔꞌɔ ntsetə ntsù nɨsyɛ̀ nya ghu, ǹtɨgə nlo ŋghɛ̀ɛ̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene nɨ Mary yî mɔ̀ꞌɔ wa bo lɛ nzì ǹtswe nlii nɨ nɨ̀syɛ̀ nyâ. ");
INSERT INTO bfd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ǹjwî ǹnàŋsə̂ ǹjoo njwîŋgɔ̀ŋ ya ɨ̀ tsyà mə̂, àbɛ̀ɛ̀ a fuꞌu, bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì a bɔ̀ꞌɔ nɨ baFarɨsai bo ghotə̀ ŋ̀ghɛɛ nyə Pilato, ");
INSERT INTO bfd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ǹswoŋ ghu mbo mə, “Taà, bìꞌì waꞌatə mə nòò wa yìi mə ǹgàŋmbweꞌesə̀ wa, mə à kɨ̀ swoŋ mə yu nɨ M̀fɔ̀ baIsrael à kɨ̀ burə aa, à kɨ̀ swoŋ mə yu ka bɨ̀ɨ̀nə̀ nɨwo a njɨ̌m njwi ji tarə̀. ");
INSERT INTO bfd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bìꞌì zi aa a nswoŋ a mbo wò mə tâ ò too bə̂ tâ bɨ̀ ghɛɛ ŋka mbɛ nɨsyɛ̀ nya a atû ǹjwi ji tarə̀. Bìꞌì swoŋ laà aa nloŋ mə bìꞌì bɔꞌɔ mə ŋ̀gǎŋyəgə̂nnù ji jya ɨ ka zǐ yə̀rə akû yi ya ghɛ̀ɛ̀ nɨ yu ɨ bàŋnə tɨgə swoŋ a mbo bə̀ mə à ywèènə̀ mə̂ nɨwô. M̀bə bo ghɨrə ma mùu ajàŋ boŋ àbaŋnənnù ma yû a ka bàŋnə bɨꞌɨ tsyàtə yi ntsyàmbìì yâ.” ");
INSERT INTO bfd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato a swoŋ a mbo bo mə, “Nɨ̀ lɔgə bɨ̂sogyɛ̀ tâ bɨ̀ ghɛɛ ŋka mbɛ nɨsyɛ̀ nyâ.” ");
INSERT INTO bfd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bo fɛꞌɛ̀ ŋ̀ghɛɛ nsɨ̀ŋtə̀ nɨsyɛ̀ nya nɨ mànjì yìi mə mbə bɨ ŋaꞌa, bɨ zî, ŋ̀kɨ nləə bɨ̂sogyɛ̀ mə tâ bɨ̀ ka mbɛ. ");
INSERT INTO bfd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ǹjwîŋgɔ̀ŋ ya ɨ̀ tsyà mə̂, àbɛ̀ɛ̀ fuꞌu, a bə tsiꞌì a tɨ̀tugə tɨ̀tugə a njwî yì ǹtsyàmbìì a mûm ŋgyà, Mary Magdalene, a bɔ̀ꞌɔ nɨ Mary yî mɔ̀ꞌɔ wa bo lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ a lèntə nɨ̀syɛ̀ nɨ Yesu nyâ. ");
INSERT INTO bfd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ǹsyɛ ɨ̀ lɛ ntsɨ̀gɨ̀nə̀ tsiꞌì nɨ̀tɨ̀ɨ̀, angel Nwì a lô a aburə nsɨgə ntii ŋgɔ̀ꞌɔ̀ ya mə bɨ lɛ ntsetə nɨsyɛ̀ nɨ Yesu nya nɨ̀ yù aa nlɔ̀ꞌɔ̀sə̀, ŋ̀kɔꞌɔ ntswe ghu atû. ");
INSERT INTO bfd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ǹsî yi ɨ lɛ sɨ ŋwàŋkə̀ tsǒ mbə̀ŋ yî ŋ̀wàꞌàkə̀, ɨ̀tsə̀ꞌə̂ ji ɨ fuꞌù tsiꞌì fùꞌù mə buu. ");
INSERT INTO bfd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nɨbɔꞌɔ nɨ lɛ ntswa bɨ̂sogyɛ̀ bya mə bɨ lɛ sɨ bɛ nɨsyɛ̀ nya aa, bo tɨgə̀ ǹtsɨgɨnə, m̀bəŋ ntɨgə tsǒ bɨ̀ku bɨ bə̂. ");
INSERT INTO bfd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angel wa a swoŋ a mbo bàŋgyɛ̀ bya mə, “Nɨ̀ tsuu kɨ bɔꞌɔ. Mə̀ zi mə nɨ lɔ̀ɔ̀ aa Yesu mə bɨ kɨ̀ kwèèntə yi atu ati bàŋnə̀bàŋnə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa kaa à sɨ̀ faà mə tswê. À bɨ̀ɨ̀nə̀ mə̂ a nɨwo tsiꞌì wa ajàŋ mə à lɛ nswoŋ aà. Nɨ̀ zi nyə adɨgə yìi mə à kɨ̀ nɔ̌ŋ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nɨ̀ waŋsə ŋghɛ̀ɛ̀ ǹswoŋ a mbo ŋ̀gǎŋyəgə̂nnù ji mə wa à bɨ̀ɨ̀nə̀ mə̂ nɨwô. À tsyà mə a mbìi bo ŋghɛɛ nɨ a Galilea. Bo bə ghɛ̀ɛ̀ boŋ bo ka tɨgə yə yi ghu. Nɨ̀ ka ŋwaꞌatə nɨ ànnù ma yû mə mə̀ swoŋ a mbo bù aà.” ");
INSERT INTO bfd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mɨ̀ntɨɨ mɨ bâŋgyɛ̀ bya mɨ lɛ nluu nɨ nɨ̀dorə̀, nɨ̀bɔꞌɔ nɨ kɨ̂ ǹtswa waa, bo fɛꞌɛ̀ ǹtɨgə ŋkhə ghɛ̀ɛ a ŋkɛ̀ꞌɛ̀nə a mbo ŋ̀gǎŋyəgə̂nnù Yesu jya. ");
INSERT INTO bfd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yesu yumbɔŋ a zî m̀boo bâŋgyɛ̀ bya, ǹtsàꞌàtə̀ waa. Bo zî ŋ̀wo ghu nsi, ǹtswa mɨ̀kòrə̂ mi mmii yi. ");
INSERT INTO bfd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu a swoŋ a mbo bo mə, “Nɨ̀ tsee kɨ bɔꞌɔ. Nɨ̀ ghɛɛ nswoŋ a mbo bɔɔ bɨ maà ba mə tâ bo ghɛɛ a alaꞌa Galilea tâ bìꞌibo boontə ghu.” ");
INSERT INTO bfd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bàŋgyɛ̀ bya bɨ kà mə aa ŋghɛɛ laa, bɨ̀sogyɛ̀ bya bǐ mɔꞌɔ bɨ kɨ̂ ǹlo ŋkuu ŋghɛɛ a mûm àlaꞌa a ŋkɛ̀ꞌɛ̀nə ɨ̀nnù jyâ tsɨ̀m jìi mə ɨ fɛꞌɛ aa, a mbo bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì. ");
INSERT INTO bfd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bo twoŋ bɨ̀tà bɨ alaꞌa bo tswe a nsyɛ ŋghàànə̀, ǹlɔɔ ŋkabə yì ŋghàꞌàtə̀ m̀fa a mbo bɨ̀sogyɛ̀ bya ");
INSERT INTO bfd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nswoŋ a mbo bo mə, “Bɛɛ bɨ betə ghuu nɨ̂ ànnù, nɨ̀ swoŋ mə, ‘Bìꞌì kɨ̀ sɨ bwii aà bwìì ŋ̀gǎŋyəgə̂nnù Yesu jya ɨ zî nɨ̂tugə, ǹzì ǹyərə aku yi yâ.’ ");
INSERT INTO bfd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gûmnàà à bə tɛꞌɛ yuyuꞌu, wa boŋ bìꞌì ka zi mânjì yìi mə bìꞌì ka tsyà ghu ɨ ghɨ̀rə tâ ŋ̀gɨꞌɨ yì tsù tâ ɨ̀ waꞌà a nu bù kuu bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bɨ̀sogyɛ̀ bya bɨ kwɛrə̀ ŋ̀kabə ya ntɨgə ŋghɛɛ ŋghɨ̀rə̀ wa ajàŋ yìi mə bɨ̀lɨɨ bya bɨ lɛ nswoŋ aà. Ǹzi nyweꞌe sii, baYuda bo burə kɨ bii mə à nɨ ànnù yìi mə a lɛ mfɛ̀ꞌɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ŋ̀gǎŋyəgə̂nnù Yesu jya nɨ̀ghum ntsò mɔ̀ꞌɔ ɨ lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ a alaꞌa Galilea wa a atu ntaꞌa mə Yesu à lɛ mfɨ̀gɨ̀tə̀ mə tâ bobo zi mbòòntə̀ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bô yə̀ mə̂ Yesu aa, mmii yi, ka mə kaa bo bî mɔꞌɔ bɨ lɛ waꞌà bii mə, tsiꞌì a annù nɨ̂ŋkoŋ, à nɨ Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu a swoŋ a mbo bo mə, “Nwì à fâ àdàꞌa tsɨ̀m a aburə bo bɨ a nsyɛ a mbo mə̀: ");
INSERT INTO bfd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nɨ̀ ghɛɛ lâ a mbo ŋ̀gwɛ̀ꞌɛ̀ mu ŋǔ ntsɨ̀m fàa a atu nsyɛ, ŋ̀ghɨrə waa tâ bo tɨgə ŋgǎŋyəgə̂nnù jâ; ŋ̀ka mmurə nɨ̂ waa a ŋkì nɨ̂ Ɨ̀kǔm Ta, nɨ̀ yi Mu nɨ̀ yi Azwì yî Làà. ");
INSERT INTO bfd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ŋ̀kɨɨ ndɨꞌɨ nɨ̂ waa mə tâ bo ka nyuꞌu ŋkɨɨ nləə nɨ̂ ǹdɨ̀ꞌɨ̂ tsɨ̀m jìi mə mə̀ kɨ̀ fa a mbo bù aà. Tâ nɨ̀ zi mə mə̀ ka tswe a mbo bù a ŋgɔ̀ŋ bɨ̀nòò bɨ̂ tsɨ̀m ɨ yweꞌe a noò ǹlwìꞌî m̀bî yù.”");
INSERT INTO bfd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ǹtoo yì ǹsɨgɨ̀nə̀ ǹloŋə Yesu Kristo Mu Nwìŋgɔ̀ŋ ɨ̀ lɔ̀gɨ̀nə aa faà. ");
INSERT INTO bfd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ǹtoo mà yû ɨ̀ lɔ̀gɨ̀nə aa tsiꞌì a ajàŋ yìi mə Ǹgàŋntoò Nwî, Yesaiah à lɛ ŋŋwàꞌànə̀ aà; “Nwì à swǒŋ mə: ‘Yə̂ nɨ̀, mə̀ ka too ŋgàŋntoò ghà a mbìi wò mə à ka naŋsə mânjì ghò’. ");
INSERT INTO bfd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ǹjì ŋû yìi mə a tɔŋnə à ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ ǹswoŋə nɨ mə: ‘Nɨ̀ naŋsə mânjì M̀màꞌàmbî ǹnaŋsə ɨyàâ ji tâ ɨ̀ tsinə.’ ” ");
INSERT INTO bfd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ma mùu ajàŋ Jɔn Ŋ̀gàŋmùrə bə̌ ŋkì a lɛ ntɨgə nzi a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ ǹswoŋə nɨ̂ ànnu Nwî ghu, ǹswoŋə nɨ a mbo bə̀ mə bɨ̀ bəŋkə mɨ̂ntɨɨ̀ myaa mmaꞌatə ɨbɨ̂ waa, ŋkwɛrə ŋkì tâ Nwì à liꞌinə ɨfansə ɨnnù jyaa. ");
INSERT INTO bfd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bə̀ bɨ̀tsɨ̀m lɛ sɨ fɛ̀ꞌɛ̀ nɨ a njɔ̀ꞌɔ alaꞌa Yerusalem bo bɨ̌ a mbùꞌu Yudea ntsɨ̀m ŋ̀ghɛɛ nɨ a mbɛ̀ɛ̀ Jɔn, m̀bii nɨ ɨ̀fansə ɨnnù jyaa ghu mbo, a tɨgə̀ m̀murə nɨ̂ waa a ŋkǐ Jordan. ");
INSERT INTO bfd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jɔn à lɛ sɨ wɛꞌɛ ɨtsəꞌə jìi mə bɨ lɛ nnaŋsə nɨ ɨ̀nòŋ naà yìi mə bɨ twoŋə nɨ kamɛl aà; ŋ̀kɨɨ ŋwɛꞌɛ nɨ̂ ɨ̀kǒ ŋgùù, a atìi yu, ŋ̀kurə nɨ̂ ŋ̀gwèènə̀ ŋ̀kɨɨ njɨ nɨ nwu yì ǹtàꞌà. ");
INSERT INTO bfd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","À lɛ sɨ swoŋə nɨ mbo bə̀ mə: “Ŋù yì mɔ̀ꞌɔ a yòŋə a njɨ̌m mə̀ yìi mə à kɔ̀ꞌɔ̀nə ntsyàtə̀ ghâ, m̀bə a ajàŋ yìi mə, tsiꞌì mə̀, kaa mə̀ sɨ̀ kùꞌùnə̀ a ntuŋnə mfɛ̀ɛ ŋ̀kɨ̀rə ɨbaamɨkòrə̂ ji. ");
INSERT INTO bfd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mə murə ghuu aa tsiꞌǐ a ŋkì, lâ yu à kà yi kɨ murə ghuu nɨ̂ Àzwì yî Làà.” ");
INSERT INTO bfd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","À lɛ mbə tsiꞌì maà noò Yesu a fɛꞌɛ̀ a Nazareth a mbùꞌu Galilea ǹzi, Jɔn a murə̀ yi a ŋkǐ Jordan. ");
INSERT INTO bfd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu à fɛ̀ꞌɛ̀ mə̂ wa ŋkì ŋ̀ghə̀ə kɨ təə a ntaꞌa, ǹyə aburə a ŋaꞌanə̀, Àzwì Nwî a sɨgə ntəə ghu atu, mbə tsǒ bugɨrəmɨ̀kuù. ");
INSERT INTO bfd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A sɨ̀gə̀ mə̂ ǹtəə ghu tu aa, ǹjì ɨ lô a aburə ŋghaa nswoŋ mə: “Ò nɨ Mû ghà yî m̀bâŋnə̀ yìi mə mə̀ ŋkɔ̀ŋə aà, mə naŋsə ndorɨtə nloŋə ghô.” ");
INSERT INTO bfd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Àzwì Nwî a burə̀ ǹlɔgə yi ŋghɛɛ nɨ ghu a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","À lɛ ŋghɛ̀ɛ̀ ǹtswe wa a antaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ a tɨtɨ̀ɨ nàà mɨtsəꞌə njwi mɨ̀ghum mi nɨkwà, Satan kwaꞌànə̀ yi. A nɨ̂ ǹjwi mà jû; baangel bɨ lɛ nzì m̀faꞌa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nòò wâ mə bɨ lɛ ntswa Jɔn nnɨŋ a andâtsaŋə aa, Yesuà lɛ nzì a Galilea ǹswoŋə nɨ̂ ǹtoò Nwì yî ǹsɨgɨ̀nə̀ ghu. ");
INSERT INTO bfd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","À lɛ sɨ swoŋə nɨ mə: “Nòò à kùꞌù mə̂; ànnù nɨfɔ̀ Nwî a tɨgə a abô. Nɨ̀ bəŋkə mɨ̂ntɨɨ̀ muu, m̀maꞌatə ɨbɨ̂ ghuu, mbii ntoo yì ǹsɨgɨ̀nə̀ yâ.” ");
INSERT INTO bfd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu à kà mə̂ aa ntsya a aghəŋə ŋkì mɨyaa Galilea, ǹyə ŋgǎŋnkômbwɛ̀ ji baa, Simon bo mumaà yi Andrew, bo lə̂ nɨ̂ m̀bwɛ̀ nɨ̂ àmbunjya. ");
INSERT INTO bfd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu a swoŋ a mbo bo mə, “Nɨ̀ zi ŋka nyoŋə nàâ, mə̀ ka ghɨ̀rə tâ nɨ̀ tɨgə mbə ŋgǎŋko bə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bo kɨ̂ ŋ̀ghɛnsə mmàꞌàtə mbunjyâ jyaa jya ǹyoŋə yi. ");
INSERT INTO bfd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bo bo kà mə̂ aa ŋghɛntə, a yə̂ Jɛms mu Zebedee bo mumaà yì Jɔn bo tswê a mûm àkànuꞌù yaa, ŋ̀kɛɛ nɨ̂ m̀bunjyâ jyaa. ");
INSERT INTO bfd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","À yə̀ mə̂ waa, m̀burə ntwoŋə waa, bo maꞌàtə̀ taà wàà Zebedee wa mûm àkànuꞌu bo bɨ̀ ŋ̀gàŋəfàꞌâ ji ǹtɨgə nyoŋə nɨ̂ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bo lô ŋ̀ghɛɛ ŋkuu a alaꞌa Kapernaum. À bə̀ mə njwîŋgɔ̀ŋ Yesu a ghɛɛ̀ ŋ̀kuu a ndâŋghòtə nlɔgɨnə ŋka ndɨꞌɨ nɨ̂ ànnù Nwî ghu. ");
INSERT INTO bfd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bə̀ yɛrə̌ ajàŋ yìi mə à lɛ sɨ dɨ̀ꞌɨ ànnù Nwì aa, ǹloŋ mə à lɛ sɨ dɨ̀ꞌɨ̀ waa aa tsǒ ŋù yìi à tswe nɨ̂ àdàꞌà, kaa waꞌà aa tsiꞌì tsǒ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ dɨꞌɨ̀. ");
INSERT INTO bfd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tsiꞌì maà noò, ŋù yî mɔ̀ꞌɔ yìi mə a lɛ ntswe wa ndâŋghòtə ntswe nɨ̂ àzwì yî bɨ aa, a tɔŋnə̀ tsiꞌì nɨ̀ tɨ̀ɨ̀ m̀betə mə: ");
INSERT INTO bfd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ò tswe aa nɨ̀ àkə̀ biꞌinə̀ a Yesu mu Nazareth ? Ò zì aa a ntâ ŋ̀gɨꞌɨ a nu bìꞌì aa ɛ? Wa mə̀ zi ŋù yìi mə ò nɨ ghu aà. Ò bə aa Yu wa yìi mə à Laa màŋsə̀, ǹlo a mbo Nwì aà.” ");
INSERT INTO bfd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","La Yesu a wenə̀ yi nswoŋ mə, “Kutə ntsû gho wâ, m̀fɛꞌɛ ghu nû.” ");
INSERT INTO bfd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Àzwì yî bɨ ya a tsɨgə̀ ŋû wa, ǹyəꞌə tsiꞌì nɨ̀ mɨ̀tɨ̀ɨ̀ m̀fɛꞌɛ ghu nû. ");
INSERT INTO bfd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntswe wa nda aa bɨ yɛrə̀ ǹtɨgə mbetə nɨ̂ waa bo nɨ bo mə: “Ma yuù ànnù a lo aà fə̀ aa ɛ? Àa ànnù yî fii yi mɔꞌɔ mə a lɔ̀ɔ ndɨ̀ꞌɨ̀ aa ɛ? A wenə nɨ̂ ɨ̀zwì jî bɨ nɨ̂ àdàꞌà, ŋ̀ghɨrə ɨ yuꞌunə̀ nii!” ");
INSERT INTO bfd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ǹlɔgɨnə maà noò ŋ̀gàn Yesu ɨ burə̀ ǹsɛɛnə a ɨdɨgə tsɨm a mbùꞌù àlaꞌa Galilea. ");
INSERT INTO bfd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji, Jɛms nɨ Jɔn lɛ mburə nlo nghɛ̀ɛ̀ ŋ̀kuu a nda bɨ̀ Simon bo Andrew. ");
INSERT INTO bfd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nɔ̂ŋsə Simon à lɛ nnɔ̀ŋ a ɨkuu ŋghɔɔ nɨ fibà. Yesu à kùù mə̂ bɨ burə̀ ǹswoŋ ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A ghɛɛ̀ ghu mbɛ̀ɛ̀, ǹtswa abô yi, ŋ̀ŋɛɛ yi, m̀bɨɨnsə. Fibà wa a burə̀ m̀maꞌatə yi, a bɨɨ̀nə̀ ǹlɔɔ mɨjɨ mfa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","À bə̀ mə a ŋkwɛ̂fɔ̀, a nɨ nòò ǹtso nòò, bɨ lɔgə̀ ŋ̀gàŋmɨghɔ̀ɔ̀ a bɔ̀ꞌɔ nɨ bə̀ bìi mə bɨ lɛ ntswe nɨ bɨ̀demon aa bɨtsɨ̀m ǹzi nɨ bo a mbo Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bə̀ bɨ̀tsɨ̀m ma mùu njɔ̀ꞌɔ̀ àlaꞌa bɨ lɛ mburə mfɛꞌɛ nzì ghotə wa ntsǔ ndâ. ");
INSERT INTO bfd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu à lɛ mburə ghurə waa bìi mə bɨ lɛ sɨ ghɔ̀ɔ̀ aa tsiꞌì bì ghàꞌàtə̀; bo lɛ ntswe nɨ mɨ̀ghɔ̀ɔ̀ tsiꞌǐ ɨbəŋ ɨbəŋə̀. À lɛ ŋkɨ mfiꞌi bɨ̂demon bî ghàꞌàtə a atoꞌo bə̀, kaa waꞌà lò m̀bii nɨ mə tâ demon wa yì tsù à ghaa, ǹloŋ mə bɨ lɛ zi ŋû yìi mə Yesu nɨ ghu aà; kaa Yesu yumboŋ kaa a waꞌà bàŋnə̀ ǹlɔɔ mə tâ bo ghɨrə tâ bə̂ zi. ");
INSERT INTO bfd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesu à lɛ nlɛ mbɨ̀ɨ̀nə̀ m̀fɛꞌɛ tsiꞌì tɨ̀tugə tɨ̀tugə, nòò a burə̀ nsaꞌatə mbɔŋ tâ àbɛ̀ɛ̀ fuꞌu, a ghɛɛ̀ a adɨgə yìi mə kaa bə̀ lɛ waꞌà ghu tswê aa a ntsàꞌàtə Nwì ghu. ");
INSERT INTO bfd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lâ Simon bo bɨ̀ ŋ̀ŋàŋakòrə̂ ji lɛ mfɛ̀ꞌɛ̀ ŋ̀ka nlɔɔ yi nyoŋə. ");
INSERT INTO bfd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bo yə̀ mə̂ yi, ǹswoŋ mə: “Bə̀ bɨtsɨ̀m bɨ lɔ̀ɔ̀ nòô!” ");
INSERT INTO bfd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A swoŋə a mbo bo mə: “Nɨ̀ zi tâ bìꞌinə̀ fɛꞌɛ faà ŋ̀ghɛɛ ɨlaꞌa jǐ mɔꞌɔ jìi mə ɨ tswe ŋkòòntə̀ fàa a mbɛ̀ɛ̀ àlaꞌa yua aà, tâ mə̀ kɨ nswoŋə annù Nwì ghu, ǹloŋ mə a nɨ annu yìi mə ma lɛ nzì a ghɨ̀rə aa.” ");
INSERT INTO bfd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A fɛꞌɛ̀ ǹtɨgə ŋkuu nɨ̂ ɨ̀dɨ̀gə̀ tsɨ̀m jìi mə ɨ lɛ ntswe a Galilea aa, ǹswoŋə nɨ̂ ànnu Nwì a ndâŋghotə, ŋ̀kɨɨ mfiꞌi nɨ bɨ̀demom a atoꞌo bə̀. ");
INSERT INTO bfd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ŋù àkɨ̀kwen yî mɔ̀ꞌɔ à lɛ nzì a mbɛ̀ɛ Yesu ǹswɛtə mɨkuꞌutə̂ mi ghu nsi, m̀buꞌu mbo ghu mbo mə tâ à kwɛtə yi; ǹswoŋ mə: “Ò bə kɔ̌ŋ boŋ ò ghɨ̀rə nû yà ɨ laà.” ");
INSERT INTO bfd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu à lɛ ŋko mɨlɨ̀ŋnə̀ yì ǹnâsə abô yi, m̀mɔɔntə yi ghu nswoŋ mə: “Mə̀ kɔ̀ŋə̂; tâ nû yò ya laa!” ");
INSERT INTO bfd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Àkɨ̀kwɛn ya a lɛ ŋkɨ mburə ŋghɛnsə nsɨgə ghu nû, nû yì ya ɨ kɨ̂ ǹtɨgə nlaa. ");
INSERT INTO bfd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu a tɨgə̀ ǹnaŋsə ŋghaa ghu mbo tsiꞌì sɨgɨ̀nə̀ ǹswoŋ mə tâ à lo ŋghɛ̀ɛ̀ yi ");
INSERT INTO bfd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ŋkɨ nswoŋ mə: “Yə̂, ò ghɛɛ, ò tsuu annù tsu a mbo ŋù lǒ swoŋə, lâ m̀bàŋnə̀ ŋ̀ghɛɛ ndɨ̀ꞌɨ ɨbɨɨ nû gho a mbô ŋ̀gàŋmàꞌa Nwì, ŋ̀kɨ mfa ayoo mmaꞌanwì yìi mə Moses à lɛ lə̀ə̀ aa, tǎ dɨ̀ꞌɨ a mbo bə̀ mə nû yò ɨ̀ làà mə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lâ ŋù wa a bâŋnə̀ ŋ̀ghɛɛ ŋ̀ka lɛnsə nɨ̂ àjàŋ yìi mə Yesu à lɛ ŋghùrə̀ yi aa a mbo bə̀ bɨ̀tsɨ̀mə̀, a tɨgə̀ ŋ̀ghɨrə a tsyânə̀ a mbo Yesu mə tâ à bu ŋka ŋkuu alaꞌa yì tsu nɨ̂ nsî. Ma mùu àjàŋ, Yesu a tɨgə̀ ǹtswe tsiꞌì a ɨdɨgə jìi mə bə̀ lɛ waꞌà ghu tswe aà, bə̀ tɨgə̀ ǹlo nɨ ɨdɨgə ɨdɨgə nzi ghu mbɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ǹjwi jì tsu lɛ ŋghə̀ə kɨ tysa Yesu a bû m̀bɨɨ fu a alaꞌa Kapernaum; à bɨ̀ɨ̀ mə̂ bə̀ burə̀ ǹlaansə mə à kwɛ̀ɛ̀ mə̂ ǹtswe a ndùgə̀. ");
INSERT INTO bfd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bə̀ lɛ nyuꞌu nzi ŋghotə a ntsǔnda yìi mə Yesu à lɛ ntswe ghu aà, m̀burə ŋghaꞌa nluu ɨdɨgə, kaa àbwarə waꞌà bù mbə a ntysa ŋkuu a mûm ǹdâ. Yesu a tɨgə̀ ǹswoŋə nɨ̂ ànnu Nwi a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","À kà mə̂ aa nswoŋə aa bə bî mɔꞌɔ bi nɨkwà bɨ beꞌě mbwenkə nzi nɨ ghu ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tsǒ mə kaa àbwarə a lɛ ŋwaꞌǎ wa ntsǔnda tswe aa, bo lɛ kɔꞌɔ a atunda, ǹlɔbɨtə nnaŋsə abùꞌù ghu, a kəꞌə̀ àdɨ̀gə̀ ya yìi mə Yesu a lɛ ntswe ghu aà. Bo màŋsə̀ mə̂ ǹlɔgə mbwenkə wa nɨ̂ ɨ̀kùù yìi mə bo lɛ mbèꞌè ghu aa, ntsurɨsə wa nɨ̂ àbùꞌù ǹsɨgɨsə a nsi Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu à yə̀ mə abìintɨɨ yìi mə bo lɛ ntswe nɨ yu aa, ǹswoŋ a mbo m̀bwènkə̀ wa mə: “Mû ghà, wa bɨ lìꞌìnə̀ mə ɨfansənû jô.” ");
INSERT INTO bfd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ jî mɔꞌɔ lɛ ntswe ghu, ǹtɨgə mbetə nɨ a mûm ǹɨ̀tɨɨ bo mə: ");
INSERT INTO bfd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ŋù ghû à tsyà aa la ŋka ŋghaa fàa ajàŋ aa ɛ? A ghàà laà m̀bəgɨtə aa Nwì! Kaa ŋù tsu kaa sɨ̀ ghu tswê mə m̀bə liꞌinə̀ ɨ̀fansənnù bə̂ ntsyatə Nwî yuyu.” ");
INSERT INTO bfd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu à lɛ mburə ŋ̀ghɛsə nzi ɨnnù ma jû mə bɨ lɛ sɨ kwàꞌàtə nɨ a atu bo aà, ŋ̀waꞌasə waa, m̀betə mə: “Nɨ kwaꞌatə ɨjaŋ ɨnnu ma jû a atu bù aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A laà waŋsə aa a nswoŋə a mbo mbwènkə̀ ghuà mə, ‘mə̀ lìꞌìnə̂ ɨ̀fansənnù jô,’ kə̀ mə: ‘Bɨ̀ɨ̀nə nlɔ̀gə ɨkuù gho wa ŋka ghɛ̀ɛ̀ noò lɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wa mə̀ ka dɨ̀ꞌɨ a mbo bù mə Mu Ŋù à tswe nɨ̀ àdàꞌà fàa mbi a lìꞌìnə ɨ̀fansənnù bə̂.” À ghàà mə̂ laà aa ntɨgə nswoŋə a mbo m̀bwènkə̀ wa mə: ");
INSERT INTO bfd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mə̀ swòŋə a mbo wò, bɨ̀ɨ̀nə nlɔgə ɨkuù gho wa ŋghɛ̀ɛ̀ gho a nda wò.” ");
INSERT INTO bfd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","M̀bwènkə̀ wa a bɨɨ̀nə̀, m̀burə nlɔgə ɨkuù yi wa, ǹtəə tsya mfɛ̀ꞌɛ̀ yi a nsi bə̀ bya bɨ̀tsɨ̀m; a burə̀ m̀bə tsiꞌì ànnù yî yɛ̌yɛrə a mbo bo. Bo tɨgə̀ ŋ̀ghaꞌasə nɨ̂ Nwî ǹswoŋə nɨ mə, “Kaa bìꞌì lɛɛ̀ waꞌǎ annù tsu laà yə̂!” ");
INSERT INTO bfd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu à lɛ mbù ŋ̀ghɛɛ fu a aghəŋə ŋkì mɨyaa Galilea; àkùrə̌ bə̂ a zî ŋ̀karɨsə yi, a tɨgə̀ ǹlɔgɨnə ŋka ndɨꞌi waa. ");
INSERT INTO bfd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","À màŋsə̀ mə̂ ǹlo ŋka ŋghɛɛ wa aghəŋə ŋkì, nyə ŋ̀gàŋkwɛrə bɨ̀tâx, Levi, mu Alfeus a tswê a ndâ ŋkwɛrə bɨ̀tâx. Yesu a swoŋ ghu mbo mə: “Zǐ ŋka nyòŋə̀ nàâ.” Levi a burə̀ m̀bɨɨnə ntɨgə nyoŋə nii. ");
INSERT INTO bfd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","À ghaꞌà a bɔ̀ɔ̀ mə̂ ǹsaꞌatə, Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji ghɛɛ̀ a nda Levi a njɨ ghu. Ŋ̀gǎŋkwɛrə bɨ̀tâx bo bə̀ bî bɨ bî ghàꞌàtə̀ lɛ ntswe bo bo ntɨgə njɨ; ǹloŋ mə bə̀ bî ghàꞌàtə̀ lɛ sɨ yòŋə̀ Yesu maa noò. ");
INSERT INTO bfd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀nsə̀ jî mɔꞌɔ jìi mə ɨ lɛ mbə baFarɨsai aa ɨ lɛ nyə a ajàŋ yìi mə Yesu lɛ sɨ jɨ bo bɨ̀ ŋ̀gǎŋkwɛrə bɨ̀tâx bo bɨ̀ bə̀ bî bɨ aa, mbetə a mbo ŋgǎŋyəgə̂nnù ji mə: “Taà ghùù a jɨ bo bɨ̀ ɨ̀jàŋ bə̂ ma ju aa a ya ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu a yuꞌù ànnù yìi mə bo lɛ sɨ ghàà aa, ǹswoŋə mbo bo mə: “Bə bìi mə bɨ tswe bɨtɨ̀ɨ̀ aa, kaa bɨ sɨ dɔgɨtà lɔɔ, a dɔgɨtà aa a lɔ̀ɔ ŋgàŋmɨghɔ̀ɔ̀. Kaa mə̀ lɛ waꞌà aa a ntwoŋ bə̀ bìi mə ànnǔ yaa a tsinə aa zî, mə̀ lɛ zì aa a ntwoŋ bə̀ bî bɨ̂.” ");
INSERT INTO bfd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","À lɛ mbə maà nòò ŋ̀gǎŋyəgə̂nnù Jɔn bo bɨ̀ baFarɨsai lɛ sɨ siꞌisə ɨbɨɨnu waa tɨ jɨ̂ ǹtsaꞌatə nɨ̂ Nwî; bə̀ bî mɔꞌɔ zî m̀betə Yesu mə: “Ŋ̀gǎŋyəgə̂nnu Jɔn bo bɨ̀ jǐ baFarɨsai bɨ siꞌisə ɨbɨɨnû tɨ jɨ̂ ǹtsaꞌatə nɨ̂ Nwî lâ kaa bǒ waꞌà ma mùu ajàŋ ghɨrə̀ aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu betə̀ waa mə: “M̀bə bə̀ bìi mə bɨ twoŋə waa a adɨgə nɨyɔꞌɔ bɨ tuu mɨjɨ, ǹsiꞌisə ɨbɨɨnû waa tɨ jɨ̂, ǹlii nɨ̂ ǹdoo mûŋgèn wa yìi mə bo tswe ghu mbɛ̀ɛ̀ aa ɛ? Àjàŋə mə ǹdoo mûŋgèn wa à tswe bo bo aa, kaa m̀bə bo waꞌà mɨjɨ tuu nsiꞌisə ɨbɨ̀ɨnû waa tɨ jɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lâ nòò yî mɔꞌɔ̀ à tswe ghu mə bɨ ka yi lɔ̀gə̀ ǹdoo mûŋgèn wa ghɛ̀ɛ̀ nɨ ghu, maa noò, mbə bo tse bɔŋ tuu mɨjɨ̂, ɨ siꞌisə ɨbɨɨnû wa tɨ jɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kaa m̀bə ŋù tsù waꞌà kà ǹlɔgə asàꞌa atsə̀ꞌə̀ yî fii a ŋkɛ̀ɛ̂ àtsəꞌə̀ yî lwèn ghu; m̀bə a ghɨrə ma mùu ajàŋ boŋ, àdɨ̀gə̀ ya mə bɨ kɛɛ aa a ka bu sàꞌànə lò yi, tâ àbàꞌa atsə̀ꞌə̀ yî fii ya tâ à yɛnə nlò yi, m̀baŋnə ntɨgə nɨŋə abùꞌù yi ghàꞌàtə̀ a nɨ atsə̀ꞌə̀ yî lwèn yâ. ");
INSERT INTO bfd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","A kɨ̂ m̀bə ŋgɨ̌ŋgɨ̀ŋ mə kaa m̀bə ŋù a waꞌà mɨlùꞌù mî fii lɔ̀gə̀ ǹnɨŋə nɨ̂ ŋ̀gùù mɨ lùꞌù jî lwènə̀, à bə nɨŋ boŋ mɨ̀lùꞌù mya mɨ ka bwǐ ŋgùù jya, tâ mɨ̀lùꞌù mya saa, tâ ŋgùù jya kɨ mbɨꞌɨ. Bɨ nɨŋ mɨlùꞌù mî fii aa a nɨ̂ ŋgùù jî fiì.” ");
INSERT INTO bfd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu bo bɨ̀ ŋgǎŋyəgə̂nnù ji lɛ sɨ tsyà a mûm ǹsòo ànsaŋ a njwîŋgɔ̌ŋ, bo kà mə̂ aa tsya, ŋ̀gǎŋyəgə̂nnù ji ɨ kâ ǹtɨɨ nɨ̂ ànsaŋ wa yì mɔꞌɔ ŋkurə. ");
INSERT INTO bfd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","BaFarɨsai bî mɔꞌɔ lɛ nyə, nswoŋ ghu mbo mə: “Yə̂, kaà sɨ̀ kuꞌùnə̀ a nɨ nɔ̀ŋsə̀ mə tâ ŋgǎŋyəgə̂nnù jo ɨ̀ ka ŋghɨrə laà, a njwîŋgɔ̌ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu a kwiꞌi a mbo bo mə: “Nɨ̀ lɛɛ̀ waꞌà ànnù ya yìi David lɛ ŋghɨ̀rə̀ aa twoŋ, wa noò yìi mə à lɛ sɨ lɔ̀ɔ ayoo yî jɨ̀, a ajàŋ yìi mə ǹjì ɨ̀ lɛ yaŋə yi bo bɨ̀ bə̀ bi aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David à lɛ ŋkuu a ndâmàꞌanwì, a noò yìi mə Abiata a lɛ mbə ŋ̀gàŋmàꞌa Nwi yî ŋ̀wè aa, ŋ̀kurə abaa Nwì, ŋ̀kɨ mfa yî mɔꞌɔ a mbo bə̀ bìi mə bo bo lɛ ntswe aà. Nɨ̀ zi mə a nɨ nɔ̀ŋsə̀ yìꞌinə̀ mə a abaa mà yû aa mbə a kurə tsiꞌì ŋ̀gǎŋəmàꞌa Nwì.” ");
INSERT INTO bfd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu a lwìꞌìsə̀ ǹswoŋ a mbo bo mə: “Bɨ lɛ lə̀ə njwîŋgɔ̂ŋ aa nloŋə bə̂, kaa bɨ lɛ ŋwaꞌà lə̀ə̀ aa mə tâ njwîŋgɔ̀ŋɨ̀ ka nsaꞌa nɨ̂ bə̂. ");
INSERT INTO bfd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wa Mu Ŋu a nɨ̂ M̀màꞌàmbî yìi a saꞌa njwîŋgɔ̀ŋə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu à lɛ mbù ŋ̀ghɛɛ ŋkuu a ndâŋghòtə̂. Ŋù yî mɔꞌɔ à lɛ ntswe ghu mə nɨ̀kwɛɛ̀ ni lɛ ŋkwo. ");
INSERT INTO bfd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bə̀ bî mɔꞌɔ lɛ ntswe ghu ǹlɔɔ nɨ̂ ǹnɨ̀ŋə̂ ànnù a nu Yesu. Bo lɛ nnaŋsə ntɨgə nlii nɨ a nyə mə kə̀ à ka ghùrə ŋû wa a njwîŋgɔ̀ŋ lɛ. ");
INSERT INTO bfd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu à lɛ nswoŋ a mbo ŋu wa mə nɨ̀kwɛɛ̀ ni lɛ ŋkwo aa mə: “Fɛ̀ꞌɛ nzǐ ntəə a mbìì faà mə!” ");
INSERT INTO bfd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","À fɛ̀ꞌɛ̀ mə̂ ǹzi ntəə, Yesu a bəŋ mbetə a mbo bo mə: “Nɔ̀ŋsə̀ yìꞌinə̀ a dɨ̀ꞌɨ mə tâ bɨ̀ ka ŋghɨrə aa ɨbɔ̀ŋ kə̌ ɨbɨ a njwîŋgɔ̀ŋ aa ɛ? À bìi mə bɨ̀ yweensə ŋû kə̀ mə bɨ̀ zwitə a njwîŋgɔ̀ŋ aa ɛ?” À bètə̀ mə̂ laà aa kaa bo tswê waꞌà kwɛꞌɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A liì waa ntsya ŋkarɨsə nɨ̂ afìi miꞌì, la m̀bàŋnə̀ ǹjəŋnə siꞌi nloŋ mə bo lɛ ŋkɨɨ mɨ̂ntɨɨ̀ myaa aà; ǹswoŋə a mbo ŋù wa mə: “Sèntə̀ nɨkwɛɛ̀ nô.” A sêntə̀ nɨ̀kwɛɛ̀ ni nya, nɨ burə̀ ǹtɨɨ. ");
INSERT INTO bfd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","BaFarɨsai bya bɨ bɨɨ̀nə̀ m̀fɛꞌɛ wa ndâŋghòtə ŋghɛɛ bo bɨ̀ bə̀ bɨ Herod burə̀ boontə a ntaŋə ajàŋ yìi mə bo ka tsyǎ ghu zwitə yi aà. ");
INSERT INTO bfd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ a ŋkì mɨyaa Galilea. Ǹnɔ̀ɔ̀ bə̂ bî ghàꞌà ŋ̀ghaꞌa bìi mə bɨ lɛ nlǒ a Galilea bo bɨ̀ a Yudea aa ɨ burə̀ m̀fɛꞌɛ ntɨgə nyoŋə nii. ");
INSERT INTO bfd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bǐ mɔꞌɔ bɨ lô a Yerusalem, bi mɔꞌɔ bɨ fɛ̀ꞌɛ̀ a mbɛ̀ɛ̀ àlaꞌa Idumia, bo bî mɔꞌɔ bɨ lô a njiì ŋkǐ Jordan, ŋ̀kɨ lo a mbɛ̀ɛ̀ ɨ̀laꞌa Tai bo bɨ̀ Sidon. Ǹnɔ̀ɔ̀ bə̂ yî ŋ̀ghàꞌà ŋ̀ghaꞌa ma ghû ɨ lɛ mfɛ̀ꞌɛ̀ nzi ghu mbɛ̀ɛ aa nloŋ mə bɨ lɛ nyuꞌu ɨnnù jìi mə à lɛ sɨ ghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu à yə̀ mə nnɔ̀ɔ̀ bə̂ wa ɨ zî ǹtɨgə mburə ŋ̀ghaꞌa bə siꞌi; a swoŋ a mbo ŋ̀gǎŋyəgə̂nnu ji mə tâ bɨ̀ lɔɔ akànuꞌu mfa tâ yù kuu ghu mum tâ bə̀ bya waꞌà yi lô ǹnɔrə̀. ");
INSERT INTO bfd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","À lɛ sɨ bə aa boŋ à ghùrə̀ mə̂ bə̂ bɨ burə̀ ŋ̀ghaꞌa tsiꞌǐ annù, ma yû a tɨgə̀ ŋ̀ghɨrə mə tâ ŋ̀gàŋmɨghɔ̀ɔ tsɨ̀m tɨgə nzwu nyoŋə nɨ a mmɔɔntə yu. ");
INSERT INTO bfd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bɛɛ mə ɨ̀zwì jî bɨ ɨ yǐ nyə yi, ɨ wô ghu nsi ntɔŋnə nswoŋ mə: “Ò nɨ Mu Nwì wâ.” ");
INSERT INTO bfd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A bâŋnə̀ ǹswoŋ a mbo ɨ̀ ŋkwantə mə tâ bo tsuu lǒ ghɨ̀rə̀ tâ bɨ̀ zi ŋû yìi mə yu nɨ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu à lɛ ŋkɔꞌɔ ŋghɛɛ a atu ntaꞌa, ǹtwoŋ bə̂ bìi mə à lɛ nlɔ̀ɔ ntwoŋə aà; à twòŋ mə̂, bɨ tɨgə̀ ǹzi ghu mbɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","À lɛ ntsɔꞌɔ bə̀ nɨghûm ǹtsò baa a tɨtɨ̀ɨ bo mə tâ bo bo tswe, tǎ tâ yù too waa a nswoŋə ànnù Nwì, ");
INSERT INTO bfd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tâ yù kɨ mfa adaꞌa a mbo bo a mfurə bɨ̀demon a atoꞌo bə̀. ");
INSERT INTO bfd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bə̀ bìi mə à lɛ ntsɔꞌɔ waa à lɛ mbə: Simon yìi mə ə̀ lɛ mfa mɨ̂kɛ̀ꞌɛ̀sə̀ mi nɨ Peta aà. ");
INSERT INTO bfd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jɛms nɨ mumaà yì Jɔn, bɔɔ bɨ Zebedee bìi mə̀ Yesu à lɛ twoŋ ŋkɛꞌɛsə nɨ Boanarges, ǹjiꞌì ɨ̀kùm ma ghû ɨ bə mə, “bɔɔ bɨ mbə̀ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, nɨ Philip, nɨ Batolomeo, nɨ Mateo, nɨ Tomas, nɨ Jɛms mu Alfeus, nɨ Thadeus, nɨ Simon mu Kana. ");
INSERT INTO bfd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","A bɔꞌɔ nɨ Judas Iskariot mə lɛ mfèe Yesu aà. Yesu à lɛ ntɨgə nlo ŋkwɛɛ yi fu a ndùgə̀. ");
INSERT INTO bfd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","À kwɛ̀ɛ̀ mə̂ ŋ̀kuu a nda, àkùrə̀ bə̂ a bû ŋ̀ghotə nzi ghu mbɛ̀ɛ̀ a tɨgə̀ ǹtsyanə ghu mbo bo bɨ̀ ŋ̀gǎŋyəgə̂nnu ji a njɨ mû àyoò. ");
INSERT INTO bfd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ŋ̀gwɛ̀ꞌɛ̀ yì ɨ̀ lɛ nyuꞌu, m̀fɛꞌɛ nzì a ntswa yu nloŋ mə bə̀ lɛ sɨ tɨgə nswoŋə nɨ mə: “A baanə aà bàànə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ jìi mə ɨ lɛ nlo a Yerusalem ǹsɨgə aa, ɨ lɛ sɨ swoŋə nɨ̂ mə: “À tswe nɨ̀ Beelzebul a atoꞌo yu. A fiꞌi nɨ̂ ɨ̀zwì jî bɨ̂ a atoꞌo bə̀ aa nɨ̂ àdàꞌa m̀fɔ̀ bɨ̀demon mà ghû.” ");
INSERT INTO bfd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bɨ kà mə̂ aa nswoŋə laà aa, Yesu a twoŋə̀ waa ŋ̀ghaa a mbo bo nɨ nɨ̀ghàà nî nàà, m̀betə waa mə: “M̀bə Satan a bû m̀furə Satan yumbɔŋ aa mə a kə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","M̀bə̂ àlaꞌa a yâtə̀ yi ǹtswe ɨtu ɨtu, ŋ̀ka nto nɨ̂ waa bo nɨ bo boŋ mbə a tɨgə̀ m̀bu ntəə aa la aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kə̀ m̀bə̂ ǹda ɨ yâtə̀ yi ntswe ntsǔtsù, ǹtɨgə nto nɨ̂ waa bo nɨ bo boŋ mbə ɨ tɨgə̀ m̀bu ntəə aa mə a kə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma la a bə mə, m̀bə Satan a bɨɨ̀nə̀ ŋka nto nɨ̂ ŋ̀gwɛ̀ꞌɛ̀ yì, ǹjaꞌa ndâ yì yumbɔŋ, bo tɨgə̀ ǹtswe ntsǔtsù, bəə boŋ kaa mbə ɨ waꞌà təə̀, a bàŋnə̀ ǹlɔɔ aà m̀bɔ̀ꞌɔ̂ ŋ̀kwɛ̀ꞌɛ̀ yì. ");
INSERT INTO bfd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A kɨ̂ m̀bə ŋ̀gɨ̌ŋ ŋgɨ̀ŋ mə kaa m̀bə ŋù tsù waꞌà ghɛ̀ɛ̀ ŋ̀kuu a nda ŋù mɨ̀tɨ̀ɨ̀, m̀fuꞌu ndâ yì tɨ fùù ǹtswa yi ŋkwerə mbɔŋ fuꞌu nda yâ. ");
INSERT INTO bfd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə m̀bə Nwì à tse lìꞌìnə ɨfansənnù bə̂ tsiꞌì tsɨ̀m bo bɨ̀ m̀bə̀gɨ̀tə ntsɨ̀m yìi bɨ bə̀gɨ̀tə̀ nii ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lâ ŋù ǹtsɨ̀m yìi mə à ghàa nɨghàà m̀bəgɨtə Azwì Nwî yìi mə a laa màŋsə̀ ghu aa, kaa Nwì à ka yǐ waꞌǎ ɨbɨ̂ yi liꞌinə̀ bə̂, ǹloŋ mə à ghɨ̀rə aà ɨ̀bɨ yìi ɨ lwiꞌi nɨ̂ŋkoŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu lɛ nswoŋ ma mùu ajàŋ aa nloŋ mə bo lɛ swǒŋ mə: “À tswe nɨ̀ àzwì yî bɨ a atoꞌo yu.” ");
INSERT INTO bfd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ǹdè bɨ̀ Yesu nɨ bɔɔ bɨ maà bi bi mbâŋə̀ lɛ nzì ǹtəə a abɛɛ, ǹtoo bə̂ mə bɨ̀ twoŋə yi. ");
INSERT INTO bfd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ǹnɔ̀ɔ̀ bə̂ lɛ ntswe ntsya ŋkarɨsə yi; bɨ kuu nswoŋ ghu mbo mə: “Ǹdè ghò bo bɨ̀ bɔɔ bɨ maà bo bǐ mbâŋnə̀ bɨ təə a abɛɛ nlɔɔ nòô.” ");
INSERT INTO bfd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu a kwiꞌi mə: “Ǹdè ghà nɨ bɔɔ bɨ maà ba bǐ mbâŋnə̀, à nɨ bɨ̀wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","M̀bəŋkə yi, ǹlii bə̂ bya mə bɨ lɛ ntswe ntsya ŋkarɨsə yi aa, ǹswoŋ mə: “Àa ǹdè ghà bo bɨ̀ bɔɔ bɨ maà ba bǐ mbâŋnə̀ buà mə! ");
INSERT INTO bfd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ŋù ǹtsɨ̀m yìi mə a ghɨ̀rə annù yìi mə Taà ghà a lɔ̀ɔ̀ aa, à nɨ mumaà ghà yî m̀bâŋnə̀ bo mumaà ghà yî màŋgyɛ̀ nɨ̂ ǹdè ghà.” ");
INSERT INTO bfd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","À lɛ mbù m̀bə a njwi yì mɔ̀ꞌɔ Yesu a lɔgɨ̀nə̀ ŋka dɨꞌɨ nɨ̂ ànnù a mbo bə̀ a mbɛ̀ɛ ŋkì mɨyaa Galilea, ǹnɔ̀ɔ̀ bə̂ ɨ nzi ŋkarɨsə yi mburə ŋghaꞌa ŋghaꞌa; a tɨgə̀ ŋ̀kuu a mûm àkanuꞌu, ŋ̀kuntə ŋghɛɛ wa mûm ŋ̀ki, ǹnɔ̀ɔ̀ bə̂ bya ɨ tɨgə̀ m̀baŋnə ntswe a ntaꞌa wa aghəŋə ŋkì. ");
INSERT INTO bfd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A dɨꞌɨ̀ nɨ̂ ɨ̀nnù jî ghàꞌàtə̀ a mbo bo nɨ̂ mɨ̀ghàà mî nǎnaa, ǹswoŋ a mbo bo mə: ");
INSERT INTO bfd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ŋù yì mɔ̀ꞌɔ à lɛ ŋghɛ̀ɛ mbweꞌê ǹjoo ŋgwɛ̀ꞌɛ̂ ji, ");
INSERT INTO bfd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","àkà mə̂ aa mbweꞌe aa, ǹjoo jya jǐ mɔꞌɔ ɨ wô a ndômânjì, bɨ̀sɨŋ bɨ zî ǹsyɛ ŋkurə. ");
INSERT INTO bfd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jǐ mɔꞌɔ ɨ wô a adɨgə nsyɛ yìi mə a lɛ mbə tsiꞌì ŋ̀gɔ̀ꞌɔ ŋgɔ̀ꞌɔ̀, kaa ǹsyɛ ɨ waꞌà ghu tswê ŋ̀ghaꞌatə. Ǹjoo jya ɨ wâŋsə̀ ǹtoo, ǹloŋ mə kaa ǹsyɛ yìi mə ɨ̀ lɛ ntswe wa atu ŋgɔ̀ꞌɔ̀ aa kaa ɨ̀ lɛ ŋwaꞌà tsotə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɨ tòò mə̂, nɨ̀nòò a tɔɔ̀ mɨ̀jɨ mya mɨ yɔrə̀, ǹloŋ mə kaa mɨ̀ŋgàŋ myaa kaa mɨ lɛ ŋwaꞌà a nsyɛ tsotə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ǹjoo jǐ mɔꞌɔ ɨ lɛ wǒ a tɨtɨ̀ɨ kə̀rə̀kərə. Ɨ tòò mə̂, kə̀rə̀kərə wa a kɔꞌɔ lɨmtə ŋkwerə ɨ kwo, kaa ɨ waꞌà mɨ̂ntà koonə̀. ");
INSERT INTO bfd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ǹjoo jya jǐ mɔꞌɔ ɨ lɛ ntɨgə ŋwǒ a adɨgə nsyɛ yì sɨgɨ̀nə̀, ŋkɔꞌɔ nsɛnsə ŋwɛ̀ꞌɛ̀ ɨ ghaꞌatə: Jǐ mɔꞌɔ koonə̀ m̀bùm mɨghum mi ntarə, jǐ mɔꞌɔ koonə mɨghum mi ntoꞌo, jǐ mɔꞌɔ koonə̀ ŋ̀khɨ̀ yî fùùrə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu à ghàà mə̂ m̀maŋsə, ǹswoŋ mə: “Ŋù yìi à tswe nɨ̂ ɨ̀tôŋnə̀ aa tâ à yuꞌu.” ");
INSERT INTO bfd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nòò yii mə Yesu à bɨ̀ɨ̀ mə̂ tswe tsiꞌì yù yù aa, bə̀ bya bìi mə bo bo lɛ ntswe a bɔ̀ꞌɔ nɨ̂ ŋ̀gǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa aa, bɨ zî ghu mbɛ̀ɛ̀, m̀betə yi mə tâ à tɔꞌɔtə njiꞌì nɨ̀ghàà nya mə à lɛ nnaa aa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bɨ bètə̀ mə̂ aa, a swoŋ a mbo bo mə: “Nwì à fa mɨ̀tsyɛ̀ a mbo bù mə tâ nɨ̀ zi annù yî àlɔ̀ꞌɔ̀sə̀ ǹloŋə annù nɨfɔ̀ yi. Lâ a ŋghɛɛ a nɨ bə̀ bìi mə bɨ sɨ̀ a tɨtɨ̀ɨ bù tswe aa, bɨ yuꞌu ɨnnù tsɨ̀m aa nɨ nɨ̀ghàà nî nǎnaa. ");
INSERT INTO bfd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Ta bo naŋsə nlii nlìì, kaa waꞌà yə̂; ǹnaŋsə yuꞌutə yuꞌutə, kaa waꞌà bàŋnə̀ yuꞌu tâ à laa a atu bo; m̀bɨ̀ꞌɨ̀ bo lô m̀bəŋkə mɨ̂ntɨɨ̀ myaa tǎ tâ Nwì à liꞌinə ɨfansənnù jyaa.’ ” ");
INSERT INTO bfd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu a betə a mbo bo mə: “Nɨ̀ sɨ njiꞌì nɨ̀ghàà nî nǎnaa ma nû zi aa ɛ? M̀bə nɨ̀ tuu ma nuù nɨ̀ghàà yuꞌu boŋ mbə nɨ̀ tɨgə̀ ǹtsya aa la mbɔŋ zi njiꞌì mɨ̀ghàà mî nǎnaa mî mɔꞌɔ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ŋ̀gàŋmbwèꞌê ǹjoo wâ a bè aa Nɨ̀ghàà nɨ Nwî. ");
INSERT INTO bfd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bə̀ bî mɔꞌɔ bɨ bə aa tsǒ ǹjoo jya mə ɨ lɛ ŋwò a ndômânjì aà. A ŋghɛ̀ɛ nɨ ma buù bə̀, bɨ yi mbè nɨghàà nɨ Nwî nya a ntɨɨ bo aa, bo yuꞌù, lâ Satan a burə̀ ǹzi mfiꞌi nlo nɨ nu. ");
INSERT INTO bfd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bə̀ bî mɔꞌɔ bû m̀bə tsiꞌì tsǒ njoo jya mə ɨ lɛ ŋwǒ wa adɨgə nsyɛ̂ ŋ̀gɔ̀ꞌɔ ŋgɔ̀ꞌɔ̀ aà; ma buù bə̀, bɨ yi nyuꞌu annù Nwî ya aa, bo burə̀ ŋ̀ghɛsə ŋkwɛrə tsiꞌì nɨ̀ nɨ̀dorə̀. ");
INSERT INTO bfd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","A kuu a atu bo, lâ kaa waꞌà nɨ mɨ̀ŋgàŋ tswê, ŋ̀ghɛsə ntswa ntugɨtə tsiꞌì nɨ mu àtɨɨ noò; bɛɛ mə ngɨꞌɨ yi mfɛ̀ꞌɛ̀ kə̀ bɛɛ bɨ lɔgɨnə ŋka ntsɔꞌɔ nɨ̂ àkòrə̂ yaa nloŋə ànnu Nwî ya aa, bo burə̀ m̀bɔꞌɔ mmaꞌatə àbìintɨɨ̀ yaa. ");
INSERT INTO bfd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bə̀ bî mɔꞌɔ bɨ tɨgə̀ kɨ mbu mbə aa tsiꞌì tsǒ njoo jya mə ɨ lɛ ŋwǒ a tɨtɨ̀ɨ kə̀rə̀kərə aà. Ma buù bə̀ a nɨ bya bìi mə bɨ yi nyuꞌu annù Nwî aa, ");
INSERT INTO bfd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","annǔ nwùgə nu nloŋ njoo mbi jù, bo bɨ̀ ànnǔ ŋkɔ̌ŋ ntswe nɨ̀ ŋ̀kabə siꞌi siꞌi, kə̌ annǔ nyə̀ꞌə̀ ǹjoo jǐ mɔꞌɔ, ɨ̀nnù ma jû, ɨ kuu a atu bo mfem nɨ̀ghàà nya nɨ kwo kaa waꞌà mîntà koonə̀. ");
INSERT INTO bfd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lâ bə̀ bî mɔꞌɔ tɨgə̀ m̀bə aa tsiꞌì tsǒ ǹjoo jya mə bɨ lɛ bweꞌe wa nɨ̂ àdɨ̀gə nsyɛ yì sɨgɨ̀nə̀ ya aà. Ma buù bə̀, bɨ yi nyuꞌu nɨghàà nɨ Nwî aa, bo bii nlə̀ə̀ a atu bo, nɨ tɨgə̀ ŋ̀ghɨrə bo koonə̀ mɨ̂ntà; bo bî mɔꞌɔ bɨ koonə̀ mɨ̀ntà mɨghum mi ntarə, bǐ mɔꞌɔ bɨ koonə̀ mɨ̀ghum mi ntoꞌo, bǐ mɔꞌɔ tɨgə̀ ŋ̀koonə mɨ̀ntǎ ŋkhɨ̀ yî fùùrə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu bû m̀betə waa mə: “Bɨ yi ŋkosə lâm ŋ̀kuu nɨ ghu a mûm nda aa bɨ nɨŋə aa a mûm àntɔ̀ɔ̀ ŋ̀kusə kə̀ bɨ tɛꞌɛ aa a njiꞌì ɨ̀kùù lɛ? Tɨgə bɨ kosə lâm ǹtɛꞌɛ aa a atu atɛtə̀ tǎ tâ bɨ̀ ka nnaŋsə nyə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kaà ànnù yî lɔ̀ꞌɔ̀sə̀ yî tsu kaa a sɨ̀ ghu tswê mə a ka yǐ waꞌà fɛ̀ꞌɛ̀ ǹyɛntə a nsi miꞌi bə̀. Bɨ bə lɔ̀ꞌɔ̀sə annù boŋ a ka yǐ yaꞌa fɛꞌɛ yɛntə a nsi miꞌi bə̀. ");
INSERT INTO bfd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ŋù yìi mə̂ à tswe nɨ̂ ɨ̀tôŋnə̀ a ŋka nyuꞌù ànnù aa tâ à yuꞌu.” ");
INSERT INTO bfd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A bû ǹswoŋ a mbo bo mə: “Nɨ̀ ka ntsyɛsə nɨ̂ ghuu nɨ̂ ànnù yìi mə nɨ yuꞌu aà. Fɨ̀gə̀ yìi mə nɨ fa nɨ a mbo bə̀ aa, à nɨ fɨ̀gə̀ yìi bɨ ka kɨɨ kɨ fa nɨ a mbo bù aà, ɨ bǔ kùꞌùsə̀. ");
INSERT INTO bfd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ŋù yìi mə̂ à tswe nɨ̂ ǹjoo aa bɨ ka bǔ kùꞌùsə̀ tâ à kuꞌusə ntswe nɨ̂ ju tâ ɨ̀ ghaꞌatə. Lâ ŋù yìi mə̂ à sɨ̀ nɨ̂ àyoo tswê aa, bɨ ka bàŋnə bǔ kwɛrə, ɨ kwɛrə kwɛre mû àyoo yìi mə à tswe nɨ ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu a bû ǹswoŋ mə: “Ànnù nɨfɔ̌ Nwî a bə aa tsǒ mə ŋù a bweꞌe njoo a mûm ǹsòo yu aà. ");
INSERT INTO bfd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","A yǐ mbweꞌe njoo jya aa, a ghɛɛ̀ ǹtswe yi, ǹlɛ nnɔŋə nii, àbɛ̀ɛ̀ a fuꞌù, a tɨgə̀ ǹghɛɛ ŋghɨ̀rə̀ nɨ̂ ɨ̀nnǔ ji ji dàŋ; ǹjoo jya mə à bwèꞌè aa, ɨ toò ŋ̀kɔꞌɔ. Lâ kaa a waꞌǎ ajàŋ yìi mə ǹjoo jya ɨ tsya mbɔ̌ŋ kɨ kwe kɔꞌɔ aa zî! ");
INSERT INTO bfd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ǹsyɛ ya yìi mə bɨ bweꞌè ǹjoo jya ghu aa, ɨ ghɨrə̀ nɨ mə tâ ɨ̀ too. Ɨ lɔgɨnə, ɨ fiꞌisə̀ ɨ̀yə̀ŋə̂ ji, ǹtoo mbərə ntɨgə ŋkɔꞌɔ ŋkoonə mɨ̂ntà mìi mə mɨ burə ŋghaꞌatə aà. ");
INSERT INTO bfd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bɛɛ mə njoo jya ɨ tɨɨ, bɨ tɨgə̀ ŋ̀ghɛɛ ŋkya, nloŋ mə nòò m̀fùꞌu mɨ̀jɨ à kùꞌù mə̂ aà.” ");
INSERT INTO bfd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu a bû m̀betə mə: “M̀bə bɨ bǔ mfɨgɨnə annù nɨfɔ̀ Nwî aa nɨ̂ àkə̀ aa ɛ? M̀bə bìꞌinə̀ bû naa aa nuu nɨghàà tǎ ghɨ̀rə à fɛꞌɛ nlaa atu bə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ànnù nɨfɔ̀ Nwî a bə aa tsǒ àbùrə mâghum yìi mə a burə ŋkəꞌə ntsyatə mbǔm njoò tsɨ̀m jìi mə bɨ bweꞌe aà. ");
INSERT INTO bfd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lâ bɨ yi mbweꞌe abùrə ati ma yû aa, a too ŋkɔꞌɔ, àtì yi a tɨgə̀ m̀baŋnə mfaŋ ntsyatə ŋgɔ̌ŋ ɨtǐ tsɨ̀m jìi mə bɨ bè aà. Bɛɛ mə a kɔꞌɔ, ǹtaà ji ɨ burə̀ m̀faŋkə m̀bə ajàŋ yìi mə m̀bə bɨ̀sɨŋ bɨ tɨgə̀ ǹzi ŋghùrə̀ nɨ̂ ǹdâ jyaa ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu à lɛ mbù ǹswoŋə annù Nwî a mbo bə̀ nɨ mɨ̀ghàà mî nǎnaa mî ghàꞌàtə̀ tsǒ ma mû. À lɛ mburə nswoŋ ɨnnù jî ghàꞌàtə̀, ŋ̀yoŋə aa ajàŋ yìi mə bə̀ bya lɛ ŋkɨɨ ŋkɔŋə nɨ̂ ǹyùꞌû ànnù ya yìi mə à lɛ sɨ swoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kaa à lɛ sɨ waꞌà ànnǔ tsu a mbo bə̀ ghaà tɨ nɨ̀ghàà nî nǎnaa, lâ a yi mbù m̀bɨɨ ntswe tsiꞌì yù bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji jya aa, a bû ǹnaŋsə ntɔꞌɔtə njiꞌì ɨnnǔ tsɨ̀m a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","À bə̀ mə̂ a kwɛ̂fɔ̀ tsiꞌì maa njwi, Yesu a swoŋ a mbô ŋ̀gǎŋyəgə̂nnù ji mə: “Nɨ̀ zi tâ bìꞌinə̀ too ŋkì ghû ŋ̀ghɛɛ fìi njii.” ");
INSERT INTO bfd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ tɨgə̀ m̀maꞌatə nnɔ̀ɔ̀ bə̂ wa wa aghəŋə ŋkì ŋ̀kuu ŋkwɛtə Yesu wa mûm àkànuꞌu, nlɔgə yi bo bo tɨgə̀ ǹtoo nɨ̂ ŋkì wâ. Ɨ̀baŋ jǐ mɔꞌɔ ɨ lɛ sɨ yòŋə̀ nɨ̂ waa. ");
INSERT INTO bfd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bo kà mə̂ aa ntoo ŋghɛɛ, àfìsə̀ yî tɨ̀ɨ̀ ǹtɨɨ a lɔgɨ̀nə̀ ŋka ntsya, m̀beꞌe nɨ̂ ɨ̀kàŋə ŋkì m̀maꞌa wa mûm àkànuꞌu; ŋ̀kì ɨ kuu ǹtɨgə nlɔɔ nluu ghu mum. ");
INSERT INTO bfd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lâ Yesu a bâŋnə̀ ǹnɔŋə yi wa njɨ̀m àkànuꞌu nlɨ̀gɨ̀sə̌ atu yi nɨ pilò m̀bwii nìi; ŋ̀gǎŋyəgə̂nnù ji jya ɨ ghɛ̀ɛ̀ ǹyəə yi, m̀betə ghu mbo mə: “Ǹdɨ̀ꞌɨ̀nnù, ò tswe kaa waꞌà nɨ̂ gho kwɛꞌɛ̀! Ò sɨ̀ zi mə m̀bə bìꞌinə̀ kwo fàa mûm ŋkì?” ");
INSERT INTO bfd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bô bètə̀ mə̂ làà aa, Yesu a bɨɨ̀nə ŋ̀wenə afìsə̀ ya, ǹswoŋ a mbo mɨ̀yàà wa mə, “Kɛntə̂! Tsuu bǔ kɨ jùꞌù!” Àfìsə̀ ya a burə̀ ŋ̀kɛntə a ntsyâ, ɨ̀dɨ̀gə̀ ɨ m̀bɔrə mə tùk, ǹtɨgə ŋghɛɛ nɨ mə swee. ");
INSERT INTO bfd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu a bəŋkə̀ yi ŋ̀ghaa a mbô ŋ̀gǎŋyəgə̂nnù ji jya mbetə mə, “Nɨ bɔꞌɔ aa àkə̀? Nɨ̀ sɨ̀ nɨ̂ àbìintɨɨ tswê aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nɨ̀bɔꞌɔ nɨ burə̀ ǹtswa waa siꞌi siꞌi, bo tɨgə̀ ǹswoŋə bo nɨ bo mə, “Ghuà ŋù à lò aà fə̀? Yə̂ nɨ̀ àjàŋ yìi mə tsiꞌì àfìsə̀ bo bɨ̀ mɨ̀yàà yuꞌunə nìi!” ");
INSERT INTO bfd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bo lɛ ntoo m̀fɛꞌɛ a njiì ŋ̀kì mɨyaa wa a mbɛ̀ɛ̀ àlaꞌa Gerasenes. ");
INSERT INTO bfd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu a fɛ̀ꞌɛ̀ mə̂ wa mûm àkànuꞌu ŋghə̀ə kɨ təə, ŋù yî mɔ̀ꞌɔ yìi mə̂ àzwì yî bɨ a lɛ ntswe ghu atoꞌo aa, a lô a ɨtu mɨsyɛ̀ m̀fɛꞌɛ nzì ǹtsitə yi. ");
INSERT INTO bfd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ŋù ma ghû à lɛ sɨ tswe aa wa ɨtu mɨsyɛ̀. A lɛ mburə ntsyanə a mbo bə̀ bɨ̀tsɨ̀m a ntswâ àbarə mà yû ŋ̀kwerə nɨ mɨ̀ŋkɨ̀rə̀ ");
INSERT INTO bfd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ǹloŋ mə, a ŋgaa jî ghàꞌàtə̀, bə̀ lɛ sɨ tswa nii, ŋ̀kwerə nɨ mɨ̀kòrə̂ mi bo bɨ̀ m̀bô mi, kə̀ ŋ̀kɨɨ nnɨŋə nɨ̂ mɨ̀kaꞌa ghu mɨkòrə̀, lâ tsiꞌì a ŋgɔ̀ŋ bɨ̀nòò bɨtsɨ̀m, a bâŋnə̀ ǹtentə nɨ mɨ̀ŋkɨ̀rə̀ mya, kə̀ ŋ̀kɨɨ mbatə nɨ mɨ̀kaꞌa myâ. Kaa ŋù tsù kaa à lɛ ŋwaꞌà nɨ mɨ̀tɨ̀ɨ̀ tswe ntsyàtə̀ yi a ajàŋ yìi mə mbə a tswâ yi ŋ̀ghɨrə mə tâ à ŋeꞌesə ntswe. ");
INSERT INTO bfd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","À lɛ sɨ karə wa ɨtu mɨsyɛ̀ bo bɨ̀ a ɨtu mɨ̂ntaꞌa, a siꞌinə bo bɨ a nɨ̂tugə̀, ǹlwugə, ŋ̀watə nɨ̂ nû yì nɨ̂ ɨ̀bàꞌa ŋgɔ̀ꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","À yə̀ mə̂ Yesu a sàꞌa aghaꞌa, m̀burə ŋ̀khə nzì ŋ̀wo ghu nsi mmii yi; ");
INSERT INTO bfd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ǹtɔŋnə nswoŋ mə, “Sɨ̀ tswè aa nɨ àkə̀ aa ɛ, Mu Nwìŋgɔ̀ŋ Àkɔꞌɔ̀tsɨrə? Mə̀ buꞌù m̀bo a mbo wò nɨ̂ ɨ̀kùm Nwî, tsùu ŋgɨꞌɨ nu mə lǒ nɨŋ bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","À lɛ ŋghàà ma mùu ajàŋ aa nloŋ mə Yesu à lɛ mfòò ǹswoŋ mə, “Àzwì yî bɨ̂, fɛ̀ꞌɛ̀ ghu atoꞌo!” ");
INSERT INTO bfd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu a betə̀ yi mə, “ɨ̀kǔm ghô nɨ̂ wò?” A kwiꞌi mə, “Ɨ̀kǔm ghâ nɨ Ǹnɔ̀ɔ̀ ǹloŋ mə bìꞌì burə ghaꞌatə fàa a atoꞌo ŋù ghû.” ");
INSERT INTO bfd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A tɨgə̀ ǹnaŋsə mbuꞌu mbo a mbo Yesu mə tâ à tsuu waa lǒ furə tâ bo fɛꞌɛ maa m̀bɛ̀ɛ̀ àlaꞌà. ");
INSERT INTO bfd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","À lɛ sɨ bə aa àkàrə̀ bɨ̂ kwiŋyàm a jɨ̂ nɨ a mbɨ̀ɨ̀ m̀baa maa adɨgə; ");
INSERT INTO bfd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ɨ̀zwì jî bɨ jya ɨ buꞌù m̀bo a mbo Yesu ǹswoŋ mə, “Tsyàsə̀ yiꞌi tâ bìꞌì kuu fìi nu nàà jiì mə.” ");
INSERT INTO bfd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu a yuꞌu mbii; ɨ tɨgə̀ m̀fɛꞌɛ wa nu ŋù wa ŋkuu wa nu nàà jyâ. Àkàrə̀ bɨ̂kwiŋyàm ma yû a lɛ mbə tsǒ ǹtsùꞌù ji baà. Ɨ̀zwì jya ɨ kùù mə̂ ghu nu aa, ɨ tɨgə̀ m̀burə nlo ŋkhə̀ mə kàrə̀, ǹsɨgə mbɨ̀ɨ̀ m̀baa ya, ǹsɨgə ŋwokə wa mûm ŋ̀kì mɨyaa ŋkoŋə. ");
INSERT INTO bfd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bə̀ bìi mə bɨ lɛ sɨ jɛꞌɛ nɨ̂ naà jya aa, bo lô m̀burə ŋ̀khə ŋghɛ̀ɛ̀ ǹswoŋ a mbo bə̀ a mûn àlaꞌa bo bɨ a afɔ̀. Bɨ tɨgə̀ m̀fɛꞌɛkə nzǐ a nyə annù yìi mə a lɛ mfɛ̀ꞌɛ wa adɨgə aà. ");
INSERT INTO bfd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bô zì mə̂, ŋ̀ghɛɛ a mbɛ̀ɛ Yesu, ǹyə ŋû wa mə ɨ̀zwì jî bɨ jya lɛ ntswe ghu atoꞌo aa, a tswê ghu mbɛ̀ɛ̀, ŋ̀wɛꞌɛ ɨtsə̀ꞌə̂ ji, mɨ̀tsyɛ̂ mi mɨ kɨ̂ ǹtswe ghu tsiꞌì mɨ̀tsɨ̀m, bɨ yə̂ a kɨ̂ m̀bə tsiꞌì ŋù wa mə ǹnɔ̀ɔ ɨzwì jî bɨ jya ɨ lɛ ntswe ghu atoꞌo aà. Bɨ yə̀ mə̂ laà aa, nɨ̀bɔꞌɔ nɨ tswâ waa. ");
INSERT INTO bfd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bə̀ bìi mə bɨ lɛ nyə annù ma yû yìi mə a lɛ mfɛ̀ꞌɛ̀ wa nu ŋù wa bo bɨ̀ a nu nàà jya aa, bo lɛ sɨ tɨgə nswoŋə nɨ a mbo bə̀. ");
INSERT INTO bfd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bo lɛ sɨ tɨgə ntsaꞌasə nɨ̂ Yesu mə tâ à maꞌatə mbɛ̀ɛ̀ àlaꞌà yàà ma ya nlò ŋ̀ghɛɛ yi. ");
INSERT INTO bfd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu a lô ŋ̀ka ŋkuu a mûm àkànuꞌu mə yu ghɛ̀ɛ̀ yi; ŋù wa mə̂ ɨ̀zwì jɨ̂ bɨ jya lɛ ntswe ghu atoꞌo aa, a buꞌù m̀bo ghu mbo mə tâ à maꞌatə yi tâ yù ka nyoŋə nìi. ");
INSERT INTO bfd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lâ Yesu a tuu, ǹswoŋ ghu mbo mə, “Kwɛɛ ŋghɛ̀ɛ a ndùgə̀, a mbɛ̀ɛ bə̌ bô, ǹswoŋ annù yìi mə Mmàꞌàmbî à ghɨ̀rə a nu wò aà; a ajàŋ yìi mə à ko mɨlɨ̀ŋnə̀ ghò, ŋ̀kwɛtə gho aà.” ");
INSERT INTO bfd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yesu à swòŋ mə ghu mbo laà, a lô ŋ̀ghɛɛ ntɨgə nswoŋə nɨ annù yìi mə Yesu à ghɨ̀rə ghu nu aa, a mbo bə̀ wa mbùꞌu Dekapolis. Bə̀ bɨ tsɨ̀m yuꞌu, a burə̀ m̀bə tsiꞌì ànnù yî yɛ̌yɛrə a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu à bù mə̂ ǹtoo ŋkì wa a mûm àbaŋ ya ŋ̀ghɛɛ mfɛ̀ꞌɛ̀ a aghəŋə ŋkì, ǹnɔ̀ɔ̀ bə̂ ɨ burə̀ ǹzi ŋghaꞌa ŋghaꞌa, ǹtəə ntsya ŋkarɨsə yi. ");
INSERT INTO bfd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ǹdɨ̀ɨ̂ ǹdâ ŋ̀ghòtə̂ baIsrael maa adɨgə, ɨ̀kǔm yi ɨ bə Jairius, a kɨ̂ ǹzi yìi ŋgaa. À yə̀ mə̂ Yesu, ŋ̀wo ghu mɨkòrə̀, ");
INSERT INTO bfd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","m̀buꞌu mbo ghu mbo, ǹswoŋ mə, “Mûntsìrə̂ mû ghà yî màŋgyɛ̀, a ghɔ̀ɔ̀, ǹtɨgə tsiꞌì a ŋkwô. Zǐ nɔ̀ŋsə mbô mo ghu nû tǎ tâ à fwɛtə ǹtswe ntɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","À swòŋ mə̂ laa, Yesu a yôŋ yi bo yu tɨgə̀ ŋ̀ghɛɛ. Bo kà mə̂ aa ŋghɛɛ aa, ǹnɔ̀ɔ̀ bə̂ yî wè ɨ kɨɨ̀ ǹtɨgə nyoŋə nii, ǹtsya ŋkarɨsə yi, bo bo tɨgə̀ ŋ̀ghɛɛ. ");
INSERT INTO bfd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Màŋgyɛ̀ yî mɔ̀ꞌɔ̂ à lɛ ntswe a tɨtɨ̀ɨ nnɔ̀ɔ̀ bə̂ wâ. Àləə a lɛ sɨ zì ghu nû. À lɛ sɨ bə maa noò aa boŋ nɨ̀ghɔ̀ɔ̀ ma nû nɨ tswè mə̂ ghu nu ɨlòò nɨghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lɛ boŋ à yə̀ mə̂ ŋ̀gɨꞌɨ nɨ nɨ̀ghɔ̀ɔ̀ nya siꞌi siꞌi, ǹghɛɛ nɨ nu a mbɛ̀ɛ bɨ̀dogɨta bî ghàꞌàtə̀, m̀bwɛsə ŋkabə̀ yìi mə à lɛ ntswe nɨ yu aa tsiꞌì ǹtsɨ̀mə̀. Kaa nɨ̀ghɔ̀ɔ̀ nya nɨ waꞌà tɨ̀ɨ̀, m̀baŋnə ŋkùꞌùsə̀ ŋ̀ghaꞌatə nɨ̂ ghàꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Màŋgyɛ̀ ma ghû à lɛ nyuꞌu ŋ̀gàn ǹloŋə Yesu. À yə̀ mə̂ Yesu aa, ǹtɨgə nyoŋə nìi bo bɨ̀ nnɔ̀ɔ̀ wâ, ǹyoŋ mfaatə ghu njɨ̀m, ŋ̀ghɛsə abô yi mmɔɔntə atsə̀ꞌə̀ Yesu ghu. ");
INSERT INTO bfd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","À lɛ sɨ waꞌatə nɨ a mûm ǹtɨɨ yu mə, “M̀bə mə̀ tɛꞌɛ̀ ŋ̀ghɛnsə mmɔ̀ɔ̀ntə̀ tsiꞌì ɨ̀tsə̀ꞌə̂ ji boŋ mə̀ ka tɨ̀ɨ̀ nɨghɔ̀ɔ̀ ma nû.” ");
INSERT INTO bfd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","À mɔ̀ɔ̀ntə̀ mə̂ aa, àləə ya a burə̀ ŋ̀ghɛsə ŋkɛntə a nzǐ ghu nû. A kɨ̂ m̀burə nzi a mûm ǹtɨɨ yu mə nɨ̀ghɔ̀ɔ̂ ni nya nɨ fwɛ̀tə̀ mə̂! ");
INSERT INTO bfd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Maa noò, Yesu a yə mə mɨ̀dàꞌà mɨ fɛꞌɛ a nu yu; m̀bəŋkə yi, m̀betə a mbô ǹnɔ̀ɔ̀ bə̂ wa mə lɛ sɨ yòŋə̀ nìi aa mə, “A ɨtsə̀ꞌə̂ ja aa a mɔ̀ɔ̀ntə̂ wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ŋ̀gǎŋyəgə̂nnù ji ɨ swoŋ ghu mbo mə, “Ò yə mə nnɔ̀ɔ̀ bə̂ ɨ ywu nyoŋə nɨ̂ gho, m̀bù m̀betə nɨ mə ɨtsə̀ꞌə̂ jo aà mɔ̀ɔ̀ntə̂ wò lɛ aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu a kuꞌùsə̀ ǹlii nɨ̂ bə̀ bya tsiꞌì lìì, mə yu ka yə ŋû yìi mə̂ à mɔ̀ɔ̀ntə yi aa lɛ. ");
INSERT INTO bfd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Lâ màŋgyɛ̀ wa à lɛ mbàŋnə̀ ǹzi annù yìi mə a ghɨrə yi aà; ǹtɨgə mfɛꞌɛ nzì, nû yì ɨ tɨgə̀ m̀benə baꞌà bàꞌà nɨ nɨ̀bɔꞌɔ, a wô a njiꞌi mɨkòrə Yesu, ŋ̀kɛꞌɛnə ɨnnù tsɨ̀m ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu a swoŋ ghu mbo mə, “Mû ghà, wa àbìintɨɨ̀ yo a ghɨ̀rə̀ mə̂ mə ta ò tɨɨ. Tɨgə nlǒ ŋghɛ̀ɛ̀ gho la nɨ̀ m̀bɔɔnə̂, tâ nɨ̀ghɔ̀ɔ̂ nya nɨ̀ fwɛtə.” ");
INSERT INTO bfd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","À ghàà mə̂ a mbo màŋgyɛ̀ wâ ŋ̀ghə̀ə kɨ màŋsə̀, bə̀ bî mɔꞌɔ bɨ lô wa ndùgə̂ ǹdɨ̀ɨ̂ ǹdâŋghotə nzi nswoŋ ghu mbo mə, “Wa mû ghò wâ à kwò mə̂! O tɨgə mbu mfa nɨ̂ ŋ̀gɨꞌɨ a mbo Taà ghû aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu a foonsə̀ waa, ǹswoŋ a mbo ǹdɨ̀ɨ̂ ǹdâŋghòtə̂ baIsrael wa mə, “Tsèe kɨ bɔꞌɔ bə̂, nɨŋ tsiꞌì ǹtɨɨ̀ gho a nu mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","À swòŋ mə̂ maa ajàŋ, ǹlo ŋka ŋghɛɛ wa ndâ ǹdɨɨ wa, kaa waꞌà bii mə tâ ŋù tsù à bu nyòŋə̀ yi ntsyatə Peta, nɨ Jɛms a bɔ̀ꞌɔ Jɔn, muma bɨ̀ Jɛms. ");
INSERT INTO bfd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bo ghɛ̀ɛ̀ mə̂ ǹyweꞌe wa ndùgə ndɨ̀ɨ ndâŋhòtə baIsrael wa, ǹyə ɨdɨ̀gə̀ ɨ burə̀ ǹjuꞌu tsiꞌì jùꞌù, bə̀ yəꞌə̀, m̀burə mboꞌo tsiꞌì nɨ̀tɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu a kuu ŋghɛ̀ɛ̀ a nda, m̀betə a mbo bo mə, “Nɨ yə̀ꞌə aa àkə̀, ŋ̀ghɨrə ɨdɨ̀gə̀ ɨ tɨgə̀ ǹjuꞌu laà? Wa kaa mu ghù kaa à sɨ̀ aà kwò kwô! Wa a bwii aà bwìì.” ");
INSERT INTO bfd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","À swòŋ mə̂ laà, bə̀ bya bâŋnə̀ ŋ̀ka wyɛ nɨ̂ yi bə̂ wyɛ̀. A furə̀ waa tsiꞌì bɨ̀tsɨ̀m mə tâ bɨ̀ fɛꞌɛkə ŋghɛ̀ɛ a abɛɛ. M̀baŋnə nlɔ̀gə̀ ta bɨ̀ mu wa bo bɨ̀ ǹdè yì a bɔ̀ꞌɔ bə̀ bya mə bo bo lɛ nzì aa, bo bo tɨgə̀ ŋ̀kuu ŋghɛɛ wa adɨgə mə mu wa à lɛ nnɔ̀ŋ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bo kùù mə̂, a tswa nɨ̀kwɛɛ nɨ mu wa, ǹswoŋ ghu mbo mə, “Talita koumi,” a bə aa mə, “Mûntsìrə̂ mumàŋgyɛ̀, mə̀ swǒŋ a mbo wò mə tâ ò bɨɨnə ntəə a ǹdəŋə.” ");
INSERT INTO bfd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","À swòŋ mə̂ ma mùu ajàŋ, mumàŋgyɛ̀ wa a burə̀ m̀bɨɨnə nlò ŋ̀ka ntəə ŋkarə. (Ɨ̀lòo mu mà ghû ɨ lɛ mbə aa nɨ̀ghûm ǹtsò baà.) Bə̀ bya bɨ liì ǹyə, ànnù a burə̀ ǹtsya waa tsiꞌì tsyà. ");
INSERT INTO bfd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu a swoŋ a mbo bo ŋkwantə mə tâ bo tsuu lǒ ghɨ̀rə tâ ŋù tsù à zi; ŋ̀kɨ nswoŋ mə tâ bo lɔɔ ayoo mfa a mbo mu wa tâ à jɨ. ");
INSERT INTO bfd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji bo lɛ nlò maa adɨgə ntɨgə mfɛꞌɛ ŋghɛ̀ɛ a Nazareth, a alaꞌa bo. ");
INSERT INTO bfd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","À bə̀ mə̂ a njwîŋgɔ̀ŋ a ghɛɛ̀ a ndâŋhòtə, ŋ̀ka ndɨꞌɨ nɨ̂ ànnù Nwî ghu, a kɨ mburə mbə tsiꞌì ànnù yî yɛ̌yɛrə a mbo bə̀ bî ghàꞌàtə̀ bìi mə bɨ lɛ ntswe ghu aa a nyuꞌù ànnù yìi mə à lɛ sɨ dɨ̀ꞌɨ̀ aà. Bo lɛ sɨ tɨgə mbetə bo nɨ bo mə, “M̀bâ ghû à lɔ̀gə yulà ànnù aa fə lɛ? Mulà mɨ̀tsyɛ̀ ghu atu mɨ lo aa fə? Yə̂ nɨ̌ ɨnnù jî wè jî wê jìi mə a ghɨ̀rə̀ aà! ");
INSERT INTO bfd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","À sɨ̌ kabindà wa à ghuà bə, làꞌà yu wa mə à nɨ mu Mary ŋ̀kɨ mbə, muma bɨ̀ Jɛms, nɨ Joses a bɔꞌɔ Judas nɨ Simon aa ɛ? Bɔɔ bɨ maà bi bî bâŋgyɛ̀ bɨ̂ sɨ̀ faà a tɨtɨ̀ɨ bìꞌinə̀ kɨ̂ ntswe ɛ?” Bô swòŋ mə̂ laà, ǹtɨgə ntuu yi. ");
INSERT INTO bfd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu a swoŋ a mbo bo mə, “Bɨ ghuꞌusə ŋgàŋntoò Nwì a ɨdɨgə tsɨ̀m, lâ kaa waꞌà nii a alaꞌa bo, kə̀ a ŋgwɛ̀ꞌɛ yu, kə̀ a ndùgə yu bâŋnə̀ ghuꞌusə.” ");
INSERT INTO bfd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsǒ mə a lɛ ntɨgə mbə maa ajàŋ aa, kaa à lɛ ŋwaꞌǎ ɨnnù jî yɛ̌yɛrə jî ghàꞌàtə̀ ghu ghɨrə̀ ǹtsyatə ajàŋ yìi mə à lɛ nnɔ̀ŋsə mbô mi a atû ŋ̀gàŋmɨghɔ̀ɔ mbùmtə̀ jî tsu, ŋ̀ghurə waa. ");
INSERT INTO bfd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Àjàŋ yìi mə bə̀ bɨ alaꞌà bi bɨ lɛ ŋwaꞌà nɨ̂ àbìintɨɨ tswê aa, a lɛ mburə ntsya Yesu tsiꞌì tsyà. À lɛ ntɨgə nlo ŋka karə ǹdɨ̀ꞌɨ nɨ̂ ànnù Nwî a ɨlaꞌa ji mɔꞌɔ jìi mə ɨ lɛ ntswe wa mbɛ̀ɛ̀ àlaꞌa bo aà. ");
INSERT INTO bfd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu à lɛ ntwoŋ ŋgǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa, ǹlɔgɨnə ŋka ntoo nɨ̂ waa bi baa bi baà; m̀fa adaꞌa mbo bo mə ta bo ka mfiꞌi nɨ̂ ɨ̀zwì jî bɨ a atoꞌo bə̀. ");
INSERT INTO bfd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ǹswoŋ a mbo bo mə bɛɛ bo tɨ ghɛ̀ɛ, bo tsuù àyoò tsu lǒ lɔ̀gə̀, ǹtsyatə ɨtɨ̂ jyaa. Ǹswoŋ mə tâ bo tsuu abaa kə̌ abàà lǒ lɔ̀gə̀; ǹtsuu ŋkabə a abàa bo lǒ nɨŋə bə̂. ");
INSERT INTO bfd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ǹswoŋ mə m̀bə bo tse wɛꞌɛ ɨbaa mɨkòrə̀, lâ kaa waꞌǎ ɨtsə̀ꞌə̀ ji baa lò m̀maꞌa bə̂. ");
INSERT INTO bfd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A bû ǹswoŋ a mbo bo mə, “Bɛɛ nɨ̀ ghɛɛ ŋkuu a nda yìi mə nɨ̀ kùu ghu aa, nɨ̀ tswê ghu nyweꞌe a noò yìi mə nɨ ka màꞌàtə̀ a adɨgə ma ya lǒ ghɛ̀ɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bɛɛ nɨ̀ ghɛɛ a adɨgə yî tsu, bɛɛ mə bə̀ bìi mə bɨ tswe ghu aa, bɨ tsuu ghuu kwɛrə, ǹtuu a nyuꞌù ànnù yìi mə nɨ swoŋə aa, nɨ̀ maꞌàtə̀ waa, nlo ghuu. Bɛɛ mə nɨ̀ tɨ fɛ̀ꞌɛ̀ maa adɨgə, nɨ̀ buꞌutə̀ àbɨ̀rə̀ yìi mə a tswe a mɨkòrə bu aà, tǎ tâ à bə alènsə̀ a ajàŋ mə bo tuu ghuu aà.” ");
INSERT INTO bfd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bo tɨgə̀ m̀fɛꞌɛ ŋghɛ̀ɛ̀ ŋ̀ka nswoŋə nɨ mbo bə̀ mə tâ bo bəŋkə mîntɨɨ̀ myaa, m̀maꞌatə ɨbɨ̂ waa. ");
INSERT INTO bfd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bo lɛ mfiꞌi ɨzwì jî bɨ jì ghàꞌàtə̀ a atoꞌo bə̀, ǹyɔꞌɔ ŋ̀kàŋmɨghɔ̀ɔ̀ jî ghàꞌàtə̀ nɨ mɨ̀ghurə, ŋ̀ghurə waa. ");
INSERT INTO bfd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","M̀fɔ̀ Herod à lɛ nyuꞌu ma juù ɨ̀nnù, ǹloŋ mə à lɛ sɨ bə aa boŋ bə̀ bî ghàꞌàtə̀ bɨ bùrə̀ mə̂ nzi Yesu. Bə̀ bî mɔꞌɔ bɨ lɛ sɨ tɨgə nswoŋə nɨ̂ mə, “À nɨ Jɔn Ŋgàŋmùrə bə̌ ŋkì mə à bù mə̂ m̀bɨɨnə nɨwô. À nɨ̂ annu yìi mə a ghɨrə mə tâ à tswe nɨ mɨ̀dàꞌà a ŋghɨ̀rə ɨ̀nnù jî yɛ̌yɛrə ma jû ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lâ, bə̀ bî mɔꞌɔ bɨ bâŋnə̀ ǹswoŋə nɨ mə, “À nɨ ŋ̀gàŋntoò Nwì, Elijah.” Bǐ mɔꞌɔ bɨ swoŋə̀ nɨ mə, “À nɨ ŋ̀gàŋntoò Nwî tsǒ ŋgǎŋntoo Nwî ji mbìi mbìì jyâ.” ");
INSERT INTO bfd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lâ Herod à yùꞌù mə̂ aa, ǹswoŋ yìi ŋgaa mə, “Jɔn wa mə mə̀ lɛ ŋkwyɛ̌ atû yi aa, à bɨ̀ɨ̀nə̀ mə̂ nɨwô.” ");
INSERT INTO bfd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","À lɛ tɨ bə maa noò aa lɛ boŋ Herod à zwìtə̀ mə Jɔn. À lɛ ŋghɨ̀rə̀ bɨ tswâ Jɔn, ŋ̀kwerə nnɨŋ a ndâtsaŋ nloŋə Herodias, ŋ̀gwɛ mumaà yì Philip, yìi mə à lɛ ŋkwɛrə aà. ");
INSERT INTO bfd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jɔn à lɛ ŋka ghaantə nɨ̂ Herod, ǹswoŋ ghu mbo mə, “Ò lɔ̀gə ŋgwɛ mumaà ghò laa kaa a waꞌà kùꞌùnə̀ a nɨ nɔ̀ŋsə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tsǒ mə Jɔn à lɛ sɨ ghàà ma mùu ajàŋ aa, Herodias à lɛ sɨ lwìsə̀ nɨ̂ ǹtɔŋ ghu nû, ǹlɔɔ nɨ̂ mânjì yìi mə m̀bə yu tsyâ ghu nzwitə yi, kaa waꞌà zî, ");
INSERT INTO bfd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ǹloŋ mə Herod à lɛ sɨ bɔꞌɔ nɨ̂ Jɔn, ǹzi mə Jɔn à lɛ mbə ŋû Nwì, ànnù yi a tsinə̀. À lɛ ntɨgə nlɔgə yi nlɔꞌɔsə mə tâ ànnǔ tsu tsuu yi lǒ ghɨ̀rə̀. À lɛ sɨ dorɨtə a ŋgɔ̀ŋ bɨ̀nòò bɨ̂tsɨ̀m a yuꞌù ànnù yìi mə Jɔn à lɛ sɨ swoŋə aà, ka mə a yi nyuꞌu, a waꞌà nɨ̂ ànnù yìi mə yu ka ghɨ̀rə̀ aa kɨ kaŋ aà. ");
INSERT INTO bfd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lâ a yî m̀bə nɨ a njwi yì mɔ̀ꞌɔ, Herodias a tswê nɨ̂ àbwarə a ŋghɨ̀rə ànnù ya yìi mə à lɛ sɨ tɛꞌɛ nlɔɔ nɨ a ŋhɨ̀rə aà. M̀fɔ Herod à lɛ ghɨ̀rə àdinà a mbo bɨ̀kǔm bi bo bɨ̀ bɨ̀tamândoo bi, nɨ bə̀ bî wè bî wè bìi mə bɨ lɛ ntswe a alaꞌa Galilea aà, ǹloŋ mə à lɛ mbə njwî ǹjwê yì aà. ");
INSERT INTO bfd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mu Herodias yî màŋgyɛ̀ à lɛ ŋkuu zi nnaŋsə mben ɨkòò tsiꞌì sɨgɨ̀nə̀, nû Herod bo bɨ̀ yì bə̀ bya bìi mə à lɛ ntwoŋə aa, ɨ naŋsə̀ m̀bɔŋ bɔ̀ŋ. M̀fɔ̀ Herod a swoŋ a mbo mumàngyɛ wa mə, “Betə ayoo yìi mə ò kɔ̀ŋ aa a mbo mə̀, boŋ mə̀ ka fa a mbo wò.” ");
INSERT INTO bfd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ǹtɨgə ŋkaa nswoŋ ghu mbo mə, “Àyoo yìi mə ò betə a mbo mə̂ aa boŋ mə̀ ka yaꞌa fa, ò bə tɛꞌɛ kɔ̀ŋ bə m̀bɛ̀ɛ̀ àlaꞌà yà yî m̀fùùrə̀ boŋ mə̀ ka kɨɨ fa tsiꞌì fà.” ");
INSERT INTO bfd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","À swòŋ mə̂ laà aa, mumàŋgyɛ̀ wa a fɛꞌɛ̀ ŋ̀ghɛɛ mbetə ndè yì mə, “Mə̀ betə akə ghu mbô?” A kwiꞌi mə, “Betə atu Jɔn Ŋgàŋmùrə bə̌ ŋkì.” ");
INSERT INTO bfd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mu wa a tɨgə̀ m̀fɛꞌɛ ŋhɛ̀ɛ̀ tsiꞌì nɨ̀tɨ̀ɨ̀, ǹzi ŋkuu nswoŋ a mbo m̀fɔ̀ wa mə, “Mə lɔ̀ɔ mə ta ò fa atu Jɔn Ŋgàŋmùrə bə̌ ŋkì a mûm akaŋ, a mbo mə̀ tsiꞌì tsɨ̀tsɔ̀ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A ajàŋ mə à bètə̀ mə̂ atu Jɔn laa, ma yû a ghɨrə̀ mə tâ nû m̀fɔ Herod ɨ̀ burə mbɨꞌɨ bɨꞌɨ. Lâ, m̀bə yìi mə à lɛ mfòò m̀bii a mbo mumàŋgyɛ̀ wa a nsi bə̀ bya bìi mə à lɛ ntwoŋə aa, à lɛ nlɔ̀ɔ̀ a ŋghɨ̀rə tsiꞌì wa ajàŋ mə à lɛ ŋkàꞌà mə yu ka ghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","M̀fɔ wa a tɨgə̀ m̀burə ntoo ŋû sogyɛ̀ yî mɔ̀ꞌɔ a tɨtɨ̀ɨ bìi mə bɨ lɛ sɨ bɛ nɨ̂ yi aa, ǹswoŋ mə tâ à ghɛɛ nzi nɨ̂ àtu Jɔn. A ghɛɛ̀ ŋ̀kwyɛ atu yi a ndâtsaŋ, ");
INSERT INTO bfd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ǹlɔ̀gə̀ ǹnɨŋ a mûm àkaŋ nzì m̀fa a mbo mumàŋgyɛ̀ wâ. A tɨgə̀ ǹlɔgə ŋghɛ̀ɛ̀ m̀fa a mbô ǹdè yì. ");
INSERT INTO bfd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ŋ̀gǎŋyəgə̂nnù Jɔn, ɨ yùꞌù mə̂, ǹtɨgə nzi nlɔ̀gə akû Jɔn ǹtɨgə ŋghɛɛ twiŋə. ");
INSERT INTO bfd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ŋ̀gǎŋntoo Yesu jya ɨ lɛ mbɨ̀ɨ̀ ǹswoŋ ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi mə bo lɛ ŋghɨ̀rə̀ ŋ̀kɨ ndɨꞌɨ aa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bə̀ bî ghàꞌàtə̀ lɛ sɨ burə ŋkuu ŋkɨɨ mfɛꞌɛ, a ghɨrə̀ mə tâ Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji waꞌà nɨ nòò a njɨ mû àyoo burə ntswe tswe. Yesu a tɨgə̀ ǹswoŋ a mbo ŋ̀gǎŋyəgə̂nnù ji mə, “Nɨ̀ zi bìꞌinə̀ ghɛɛ a adɨgə yìi mə m̀bə bìꞌinə̀ tswê ghu tsiꞌì bìꞌinə̀ tǎ mɨ̀ɨ̀ntə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","À swòŋ mə̂ laà bo bo tɨgə̀ ǹlo ŋghɛ̀ɛ̀ ŋ̀kuu a mûm àkànuꞌu ntoo ŋghɛɛ a adɨgə yìi mə kaa bə̀ sɨ̀ ghu tswê aa tǎ tswe ghu tsiꞌì bo bo. ");
INSERT INTO bfd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lâ bə̀ bî ghàꞌàtə̀ lɛ nyə ajàŋ yìi mə bo lɛ nlò ŋ̀ka ŋghɛɛ aà, ǹzi bə̂ bìi mə bo nɨ bu aà, m̀burə mfɛꞌɛkə a mɨkurə mɨkurə, ŋ̀khə ntsyǎ mbìì ŋ̀ghɛɛ ntswe wa adɨgə mə bɨ̀ Yesu lɛ ŋka ŋghɛɛ ghu aa, mboŋ tâ bo zi ŋkuu ghu. ");
INSERT INTO bfd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu à tòò mə̂ ŋ̀ka mfɛꞌɛ wa mûm àkànuꞌu, nyə akùrə̀ bə̂ a tswê wa aghəŋə ŋkì m̀burə ŋghaꞌa ŋghaꞌa; a ko mɨ̀lɨ̀ŋnə̀ wàà siꞌi siꞌi, nloŋ mə bə̀ bya bɨ lɛ ntswe tsǒ mbinjə̀rə̀ jìi mə kaa ɨ sɨ̀ nɨ̂ ntsèè tswê aà. À lɛ ntɨgə nlɔgɨnə ŋka ǹdɨꞌɨ waa nɨ̂ ɨ̀nnù jî ghàꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ŋ̀gǎŋyəgə̂nnù Yesu jya ɨ yə mə nòò à ghɛ̀ɛ̀ mə̂, ǹtɨgə ntsya ǹzì ǹswoŋ ghu mbo mə, “Àdɨ̀gə̀ yû à nɨ̂ àdɨ̀gə̀ yìi mə kaa bə̀ sɨ ghu tswê, nòò à kɨ̀ mə̂ ŋ̀ghɛɛ ŋghɛ̀ɛ̀; ");
INSERT INTO bfd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ghɨ̀rə tâ bə̀ bû ghɛɛ waa, ta tâ bo ghɛɛ ŋkuu a ɨfɔ̀ bo bɨ a mumə̀ ɨlaꞌa jìi ɨ tswe faa mbɛ̀ɛ̀ àdɨ̀gə̀, ǹyuu mɨjɨ ghu njɨ.” ");
INSERT INTO bfd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lâ Yesu a bâŋnə̀ ŋ̀kwiꞌi a mbo bo mə, “Nɨ lɔɔ ayoo mfa tâ bo jɨ.” À swòŋ mə̂ laà, bo betə̀ yi mə, “O lɔ̀ɔ mə tâ bìꞌì naŋsə nlɔgə bɨ̀francs ntsùꞌu ŋkhɨ̀ ji baa ŋ̀ghɛɛ nyuu tsiꞌì àbaa nɨ yù ta jɛꞌɛ bə̂ bû ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A bû ǹswoŋ a mbo bo mə, “Nɨ̀ ghɛɛ nlèntə̀ mə nɨ̀ tswe nɨ̀ ɨ̀baa ji səgə lɛ?” Bo ghɛɛ nlentə, mbɨ̀ɨ̀ ǹswoŋ ghu mbo mə bo tswe nɨ̀ ɨ̀baa aa ji ntaà, abɔꞌɔ nɨ m̀bwɛ̀ mi mbaà. ");
INSERT INTO bfd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu a tɨgə̀ ǹswoŋ a mbo bo mə tâ bo ghotə bə̂ bya ŋghɨ̀rə̀ tâ bo tswe a ɨbwen ɨbwen, a atu ŋgɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bə̀ bya bɨ tɨgə̀ ŋ̀ghotə waa ntswetə a ɨbwen ɨbwen, ǹtswe nɨ a abwen yî fùùrə̀ ŋkhɨ̀ yî fùùrə̀, kə̌ mɨghum mi ntaà. ");
INSERT INTO bfd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu a lɔgə̀ ɨ̀baa jya ji ntaà nɨ̂ m̀bwɛ̀ mya mi mbaa, ŋ̀ŋɛntə atû yi a ndəŋ, ǹlii aburə, mfa mbɨꞌɨkə a mbo Nwì, m̀batə ɨbaa jya, m̀fa a mbo ŋgǎŋyəgə̂nnù ji mə tâ bo yatə a mbo bə̀ byâ. À lɛ ŋkɨ nyatə mbwɛ̀ mya mi mbaa a mbo bə̀ byâ bɨ̀tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bə̀ bɨ̀tsɨ̀m bɨ lɛ njɨ nyurə. ");
INSERT INTO bfd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bɨ lɛ ŋghotə abugə ɨbaa jya bo bɨ̀ àbùgə mbwɛ̀ mya mə bɨ lɛ nyàtə̀ aa, a lwensə̀ ŋ̀kyɛ̀ nɨghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","M̀bâŋnə̀ jìi mə ɨ lɛ ŋkurə ɨbaa jya aa, ɨ lɛ mbə ntsùꞌù ji ntaà. ");
INSERT INTO bfd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu à lɛ mburə ŋghɨrə ŋgǎŋyəgə̂nnù ji jya ɨ bû ŋ̀kuu fu wa mûm àbaŋ, ǹtsya mbìì ŋ̀ka ntoo ŋghɛɛ a njii ŋ̀kì a Betsaida. Bo kà mə̂ aa ntoo ŋghɛɛ aa a swoŋ a mbo bə̀ bya mə tâ bo tɨgə nlo ŋkwɛɛŋkə waa. ");
INSERT INTO bfd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","À fà mə̂ fɨlô fyaa, ŋkɔꞌɔ ghɛɛ a atu ntaꞌa a ntsàꞌàtə Nwì ghu. ");
INSERT INTO bfd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɨ̀tugə lɛ mfii ŋkwɛtə àkànuꞌu ya wa mûm ŋ̀kì; Yesu a bâŋnə̀ ǹtswe a abɛɛ wa atu ntaꞌa tsiꞌì yù yù. ");
INSERT INTO bfd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ǹyə mə a lɛ ntsyànə̀ a mbo ŋ̀gǎŋyəgə̂nnù ji jya a tii àbaŋ ya nloŋ mə àfìsə̀ a lɛ sɨ tsyà ǹtii nɨ̂ waa mbɨnsə nɨ njɨ̀mə̀. À bə̀ mə̂ a nɨ nòò ǹjwi a lô ŋ̀ka ntəə wa atu ŋkì ǹzi nɨ a mbɛ̀ɛ bo. À lɛ ŋka zi aa ŋwaꞌatə nɨ mə yu ka zǐ kwaatə tsyà yi a mbɛ̀ɛ bo. ");
INSERT INTO bfd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lâ ŋ̀gǎŋyəgə̂nnù ji jya ɨ yə̀ mə ajàŋ yìi mə à lɛ sɨ təə nzi wa atu ŋkì aa, mmɔ̀ɔ̀ntə mə à lɛ mbə ŋkû; m̀burə ntɔŋnə mboꞌo tsiꞌì nɨ̀ tɨ̀ɨ̀, ");
INSERT INTO bfd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ǹloŋ mə nɨ̀bɔꞌɔ lɛ ntswa waa. Lâ Yesu a burə̀ waŋsə ghàà ǹswoŋ a mbo bo mə, “Tswâ nɨ̌ ntɨɨ̀ ghuu, ǹtsuu kɨ bɔꞌɔ bə̂, ǹloŋ mə à nɨ mə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","À swòŋ mə̀ laa, ŋkɔꞌɔ ŋkuu wa mûm àkànuꞌu, àfìsə̀ ya a kɛntə̀ a ntsyâ. A tɨgə̀ m̀burə mbə tsiꞌì ànnù yî yɛ̌yɛrə a mbo ŋ̀gǎŋyəgə̂nnù ji jyâ, ");
INSERT INTO bfd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ǹloŋ mə, kaa bo lɛ ŋwaꞌà ǹjiꞌì ànnù yî yɛ̌yɛrə yî mɔꞌɔ ya mə Yesu à lɛ ŋghɨ̀rə̀ aa zî, a ajaŋ yìi mə a lɛ jɛꞌɛ bə̂ bya nɨ̂ ɨ̀baa jya aà; bɨ lɛ mfɨɨ atû yaa! ");
INSERT INTO bfd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji bo lɛ ntoo ŋkì wa ŋghɛ̀ɛ̀ m̀fɛꞌɛ a Gennesaret, ǹtɨŋnə akànuꞌu ya a aghəŋə ŋkì. ");
INSERT INTO bfd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bo ghɛ̀sə̀ mə̂ ŋ̀ghə̀ə kɨ fɛ̀ꞌɛ̀ wa mûm àkànuꞌu, bə̀ burə̀ ǹyə Yesu ǹzi. ");
INSERT INTO bfd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bə̀ lɛ sɨ ntɨgə ŋkhənə ŋkarə nɨ̂ àlaꞌa ya bo bɨ a mbùꞌù ma yâ ǹtsɨ̀m, ǹlɔgə nɨ̂ ŋ̀gàŋmɨghɔ̀ɔ̀ jyaa, m̀beꞌe a nɨ mɨ̀kùù ǹzi nɨ ju ghu mbo a nɨ̂ ŋ̀gɔ̂ŋ ɨdɨgə tsɨ̀m jìi mə bɨ lɛ nyuꞌu mə Yesu à tswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","A nɨ̂ ŋ̀gɔ̌ŋ ɨdɨgə tsɨ̀m jìi mə Yesu à lɛ ghɛ̀ɛ̀ ghu aa, a ɨlaꞌa, a mûm ɨ̀laꞌa kə̌ a ɨfɔ̀ aa, bə̀ bɨ lɛ sɨ lɔ̀gə̀ nɨ̂ ŋ̀gàŋmɨghɔ̀ɔ̀ ǹzi nɨ ju a nsàanə mɨtaa, m̀buꞌu nɨ̂ m̀bo ghu mbo mə tâ à maꞌatə tâ ŋ̀gàŋmɨghɔ̀ɔ̀ jya ɨ̀ ghɛsə mbô myaa mmɔɔntə tsiꞌì àtsəŋ atsə̀ꞌə̂ yi. Ŋ̀gɔ̀ŋ bə̀ bɨtsɨ̀m bìi mə bɨ lɛ mmɔ̀ɔ̀ntə̀ yi aa bo lɛ ntɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","BaFarisai bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ jǐ mɔꞌɔ jìi mə ɨ lɛ nlo a Yerusalem nzi aa, lɛ nzì ŋ̀ghotə a mbɛ̀ɛ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bo bo tswè mə̂, bo yə̂ ŋ̀gǎŋyəgə̂nnǔ Yesu jî mɔꞌɔ ɨ jɨ̂ nɨ̂ m̀bo mìi mɨ lɛ ŋwaꞌà laà, ma la a bə mə kaa bo lɛ ŋwaꞌǎ mbô myaa siꞌì ǹyoŋə a ajàŋ yìi mə baFarɨsai lɛ sɨ lɔ̀ɔ̀ mə bɨ̀ ka nsiꞌi aà. ");
INSERT INTO bfd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ǹloŋ mə kaa mbə baFarɨsai, bo bɨ̀ baYuda bɨtsɨ̀m kaa mbə bo waꞌà jɨ tɨ ghə̂ mə bo siꞌì m̀bô myaa, ǹyoŋə aa nɨ nɔ̀ŋsə̀ bɨ̀tà bɨ bɨtaà byaa. ");
INSERT INTO bfd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bɛɛ mə bo yi ŋkɨ mbɨɨ a mɨtaa, kaa bo waꞌà lò m̀bii njɨ tɨ ghə̂ mə bo siꞌi nû jyaa mə tâ ɨ̀ laa. Bɨ̀nɔ̀ŋsə̀ bî ghàꞌàtə̀ bî mɔꞌɔ bɨ kɨ mbu tswe ghu mə bo lɛ sɨ yòŋə̀, tsiꞌì tsǒ ǹnàŋsə nsìꞌî ǹdɔŋ jì nò ghu, nɨ bàntɔ̀ɔ̀ bo bɨ̀ ǹjoo nnɨ̂ŋ ǹjoo jìi bɨ naŋsə nɨ̂ atɨ̀ɨ bronze aà. ");
INSERT INTO bfd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","BaFarɨsai bya bo bɨ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ jya bô yə̀ mə̂ laà aa, mbetə Yesu mə, “A ghɨ̀rə̂ àkə̀ kaa ŋ̀gǎŋyəgə̂nnù jô waꞌà nɨ̂ nɔ̀ŋsə̀ bɨ̀tà bɨ bɨ̂taà biꞌi lə̀ə̀, m̀baŋnə njɨ tsiꞌì tɨ̀ sìꞌì nɨ̂ m̀bô myaa mɨ laa aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A kwiꞌi mə, “Ŋ̀gàŋntoò Nwì Yesaiah à lɛ nyə aa tsiꞌì sɨgɨ̀nə̀ ŋ̀ŋwàꞌànə annù yìi mə Nwî à lɛ nswoŋ nloŋ ŋgaà yùù aa, bǔ ŋgǎŋabagɨlə̀, mə, ‘Bə̀ buà, bɨ ghuꞌusə nɨ̂ gha aa tsiꞌì nɨ̂ ɨ̀ghoŋ ntsǔ jyaa, lâ mɨ̀ntɨɨ̀ myaa bâŋnə̀ ǹtswe a ndìsyà; ");
INSERT INTO bfd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bo mii nɨ̂ gha laa tsiꞌì àdàŋə̀ àdàŋə̀ ǹloŋ mə bo bàŋnə̀ ǹdɨꞌɨ bə bɨ̀nɔ̀ŋsə̀ bɨ bə̂ tsǒ ǹdɨ̀ꞌɨ̂ jyâ!’ ");
INSERT INTO bfd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nɨ̀ màꞌàtə̂ ǹdɨ̀ꞌɨ̂ Nwî, m̀baŋnə ntswa nɔ̂ŋsə̀ bə̀ a tɨɨ̀nsə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu a bû ǹswoŋə a mbo bo mə, “Wâ nɨ̀ nàŋsə nzi a ntuu ǹlə̀ə̂ ǹdɨ̀ꞌɨ̂ Nwì tǎ bàŋnə kɨ lə̀ə̀ nɨ̂ nɔ̂ŋsə̀ ghùù! ");
INSERT INTO bfd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses à lɛ nswoŋə mə, ‘Ka yuꞌunə taà ghò bo maà gho.’ Ŋ̀kɨ mbu nswoŋ mə, ‘Ŋù yìi mə à bə̀gɨ̀tə taà yi kə̌ ndè yi aa, a kuꞌunə mə tâ bɨ̀ zwitə yi.’ ");
INSERT INTO bfd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lâ nɨ̀ bâŋnə̀ ǹswoŋə nɨ̂ yùu ŋgaa mə m̀bə ŋù a swoŋə a mbo taà yì kə̀ ǹdè yì mə, ‘Wa àyoo yìi mə boŋ mə̀ fa ŋkwɛ̀tə gho ghu aa a nɨ Corban,’ (mala a bə mə mə̀ fà mə̂ a mbo Nwì) ");
INSERT INTO bfd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bəə boŋ kaa à sɨ̀ nɨ̂ ŋ̀kwɛtə taà yì, kə̌ ndè yi bû ǹtswe. ");
INSERT INTO bfd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma mùu ajàŋ, nɨ̀ bwɛsə aa nɨ̀ghàà nɨ Nwî, ǹloŋə nɔ̂ŋsə̀ ghùù yìi mə nɨ dɨ̀ꞌɨ̀ nɨ a mbo bə̀ aà. Ŋ̀kɨɨ ŋghɨrə nɨ̂ ɨ̀nnù ji ghàꞌàtə̀ jî mɔꞌɔ jìi mə ɨ bə tsǒ ma jû aà.” ");
INSERT INTO bfd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu a bû ǹtwoŋ bə̂ bya nswoŋ a mbo bo mə, “Bù bɨtsɨ̀m nɨ̀ yuꞌutə nɨ̌ annù yìi mə mə swoŋ aa, tâ à laa a atu bù. ");
INSERT INTO bfd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kaa àyoo yì tsu kaa a sɨ̀ a abɛɛ tswê mə m̀bə ŋù a jɨ a kuu ŋghɨ̀rə̀ mə tâ à tsuu laa; lâ a ŋû aa a bàŋnə̀ ŋ̀ghɨrə nɨ̂ ɨ̀nnù ji bɨ̂ jìi mə ɨ lò ghu atoꞌo mfɛꞌɛ aa mə̂ à tsuu laa.  ");
INSERT INTO bfd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ŋù yìi mə à tswe nɨ̂ ɨ̂tôŋnə̀ a nyuꞌu annù aa, tâ à yuꞌu annù yìi mə mə swoŋə aà.” ");
INSERT INTO bfd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","À màꞌàtə̀ mə̂ bə̂ bya nlò ŋ̀kuu ŋghɛɛ a mûm ǹda, ŋ̀gǎŋyəgə̂nnù ji ɨ betə̀ ǹjiꞌì nɨ̀ghàà nî nǎnaa ma nû ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Bô bètə̀ mə̂ aa, a swoŋ a mbo bo mə, “Ma la a bə mə kaa nɨ̀ sɨ̌ yùu ŋgaa kɨ nyuꞌu aa ɛ! Nɨ̀ sɨ̀ zi mə ayoo yìi mə a lò bə a abɛɛ ŋkuu nɨ a nu ŋù aa, kaa mbə a waꞌà yi ghɨrə̀ mə̂ à tsuu laa aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ǹloŋ mə kaa a sɨ̀ aa ghu ntɨɨ kuu; a bàŋnə̀ ŋ̀kuu aa ghu atoꞌo, ɨ kɨɨ bǔ tsyǎ mfɛ̀ꞌɛ fu.” (Ma mùu ajàŋ à lɛ nswoŋ mə wa mɨ̀jɨ mɨ̀tsɨ̀m mɨ laà, ŋ̀kuꞌunə a njɨ̂.) ");
INSERT INTO bfd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A bû ǹswoŋ mə, “A ŋû aa a sɨ̌ŋ njoo jìi mə ɨ fɛ̀ꞌɛ̀ ghu nû aà, ŋ̀ghɨrə nɨ mə tâ à tsuu laa. ");
INSERT INTO bfd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ǹloŋ mə ɨ̀nnù jî bɨ tsɨ̀m ɨ lò aa a mûm ǹtɨɨ ŋù m̀fɛ̀ꞌɛ̀: Ŋ̀wàꞌàtə̂ ɨ̀nnù jî bɨ, ànnǔ ajɨrə̀, ɨ̀yə̀rə̂, ǹzwìtə bə̀, ànnǔ mâghàbə̀, ");
INSERT INTO bfd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ǹyə̀ꞌə̀tə̂ ǹjoo bə̂; àbɨ̀ꞌɨntɨɨ, m̀bwèꞌèsə bə̀, ɨ̀buurənnù, àghə̀ꞌə̀nə̀, ǹswòŋə̂ ɨ̀nnu jî bɨ a atu bə̀; ŋ̀ŋee nû, nɨ̂ ɨ̀jɨ̀ŋtə ɨnnù. ");
INSERT INTO bfd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ɨ̀nnù jî bɨ mà jû tsiꞌì tsɨ̀m ɨ lò aa a nu ŋù, a mûm ǹtɨɨ yu, m̀fɛꞌɛ nsɨ̀ŋə̀ nɨ̂ ŋû, ŋ̀ghɨrə nɨ mə tâ à tsuu laa.” ");
INSERT INTO bfd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu a lɛ nlò ŋ̀ghɛɛ a mbɨ̌ Tai bo Sidon. À ghɛ̀ɛ̀ mə̂ ghu, ŋ̀kuu ntswe a mûm ǹda yi mɔ̀ꞌɔ, kaa waꞌà lɔ̀ɔ̀ mə tâ bə̀ zi; lâ a bâŋnə̀ ǹtsyanə a ŋghɨ̀rə mə tâ bɨ̀ tsuu lǒ zi. ");
INSERT INTO bfd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Màŋgyɛ̀ yî mɔ̀ꞌɔ yìi mə mû yi yî màŋgyɛ̀ à lɛ ntswe nɨ̂ àzwì yî bɨ a atoꞌo yu aa, à lɛ nyuꞌu mə Yesu à tswe wa ndâ. À yùꞌù mə̂, m̀burə mfɛꞌɛ nzì a mbɛ̀ɛ Yesu, ŋ̀wo ghu mɨkòrə̀. ");
INSERT INTO bfd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Màŋgyɛ̀ ma ghû à lɛ mbə mâŋgyɛ Grikia, yìi mə bɨ lɛ njwe aa a alaꞌa Sirofonisia. À wò mə̂ a mɨ̀kòrə Yesu aa, m̀buꞌu mbo ghu mbo mə tâ à fiꞌi azwì yî bɨ ya a atoꞌo mû yì wâ. ");
INSERT INTO bfd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu a swoŋ ghu mbo mə, “Lə̀ə tâ bɨ̀ foo njɛꞌɛ bɔɔ yaꞌa, ǹloŋ mə kaa a sɨ̀ kuꞌunə̀ a nlɔ̀gə̂ àbaa bɔɔ mbàŋnə̀ m̀maꞌa a mbô m̀bû.” ");
INSERT INTO bfd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lâ Màŋgyɛ̀ wa a kwiꞌi ghu mbo mə, “Ɨ̀ɨ̀ŋə, Mmàꞌàmbî, lâ tsiꞌì m̀bu jìi mə ɨ nɔ̀ŋə̀ a njiꞌì àtɛtə̀ aa, ɨ kɨɨ mbwɛɛ nɨ̂ ɨ̀nùgə abaa bɔɔ bya njɨ.” ");
INSERT INTO bfd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu a tɨgə̀ ǹswoŋ ghu mbo mə, “Nloŋ mə ò nàŋsə ŋghàà ma mùu ajàŋ aa, tɨgə nlǒ ŋghɛ̀ɛ̀ gho mbà. Wâ demon wa a màꞌàtə̀ mə mu ghò wâ.” ");
INSERT INTO bfd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","À yùꞌù mə̂ laà aa ntɨgə nlo mbɨ̀ɨ̀ yi a ndùgə yu. À bɨ̀ɨ̀ mə̂ ŋ̀kuu a nda, nyə mu wa a nɔ̂ŋ a ɨkuu, lɛ boŋ demon wa a fɛ̀ꞌɛ̀ mə̂ ghu atoꞌo. ");
INSERT INTO bfd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu a lɛ ntɨgə nlo wa mbùꞌù àlaꞌa Tai ŋ̀ghɛɛ ntsya a alaꞌa Sidon, ŋ̀ghɛɛ a ŋkì mɨyaa Galilea, ǹlo ghu ŋghɛɛ ntsya a mbùꞌù àlaꞌa Dekapolis. ");
INSERT INTO bfd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","À kà mə̂ aa ntsya ghu, bɨ zî nɨ ŋù yî mɔ̀ꞌɔ mə àtû yi a lɛ ŋkwo, a kɨɨ̀ m̀mii nɨ̂ ŋ̀ghàa kɨ kaŋ, m̀buꞌu mbo a mbo Yesu mə tâ à nɔŋsə mbô mi ghu nu ŋghùrə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bɨ swòŋ mə̂ laà aa, Yesu a lɔgə̀ ŋû wa bo yu maꞌàtə̀ àkùrə̀ bə̂ ya ŋghɛ̀ɛ̀ a adɨgə dàŋ, bo yu ghɛ̀ɛ̀ mə̂ aa, a nɨŋ bɨ̀swɛbɨbo bi ghu ɨtôŋnə̀, ǹtwutə mɨtwyɛ a abo yu, m̀mɔɔntə aləə ŋû wa ghu; ");
INSERT INTO bfd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ŋ̀ŋɛntə miꞌì mi ŋka lii aburə, ǹtsaa nû yì, ǹswoŋ a mbo ŋù wa mə, “Efata”, ǹswoŋ aa mə, “ŋaꞌanə̂!” ");
INSERT INTO bfd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","À swòŋə̀ mə̂ laà aa, ɨtôŋnə̀ ŋû wa ɨ burə̀ ŋ̀ŋaꞌanə, àləə̀ yi a kɨ̂ m̀burə mfɛɛŋkə, a ghaà tsiꞌì sɨgɨ̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu a swoŋ a mbo bə̀ bya mə tâ bo tsuu a mbo ŋù tsù lǒ swoŋə. Lâ a yi nswoŋ mə tâ bo tsuu kɨ swoŋə aa, bo bâŋnə̀ ŋ̀kuꞌusə ŋghɛ̀ɛ̀ bə nɨ̀ m̀bìì a kɛ̀ꞌɛ̀nə a mbo bə bî mɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ànnù a lɛ mburə ntsya bə̂ bɨ̀tsɨm bìi mə bɨ lɛ nyuꞌu aa, bo tɨgə̀ ǹswoŋə nɨ mə, “À fàꞌà mə̂ m̀buu ɨnnù tsiꞌì tsɨ̀m, ŋ̀kɨ nnaŋsə mfaꞌa; ŋ̀kɨɨ ghɨrə nɨ mə tâ ɨ̀kwotu ɨ̀ tɨgə nyuꞌu nɨ̂ ɨ̀nnù, ŋ̀ghɨə nɨ mə tâ bɨ̀tɨ̀ghàà bɨ̀ ghaa!” ");
INSERT INTO bfd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","À lɛ mbə nɨ̂ ǹjwi mà jya, ǹnɔ̀ɔ̀ bə̂ ɨ bû m̀boontə ghu mbɛ̀ɛ̀. Kaa àyoo nɨjɨ yì tsu kaa a lɛ ŋwaꞌà a mbo bo tswê a njɨ̂. Yesu a twôŋ ŋ̀gǎŋyəgə̂nnù ji nswoŋ a mbo bo mə, ");
INSERT INTO bfd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mə ko mɨlɨ̀ŋnə̀ bə̀ bû ǹloŋ mə bo tswè mə̂ biꞌi bo tsɨ̂tsɔ̌ŋ njwi ji tarə kaa waꞌà nɨ̂ àyoo yì jɨ̀ tswê aà. ");
INSERT INTO bfd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","M̀bə mə̀ swoŋ mə tâ bo lo ŋghɛ̀ɛ̀ŋkə̀ a mɨlaꞌa bo nɨ̂ ǹjì boŋ bo ka ghɨ̀rə ghɛ̀ɛ wòkə̀ a mânjì, ǹloŋ mə bi mɔꞌɔ a tɨtɨ̀ɨ bo bɨ lo aa a sàꞌa aghaꞌà aà.” ");
INSERT INTO bfd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ betə̀ yi mə, “M̀bə bɨ naŋsə̀ ǹlɔgə abaa aa fə fàa atu ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ a njɛꞌɛ̀ ǹdùù bə̂ waà ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu a betə̀ waa mə, “Nɨ̀ tswe nɨ̀ ŋ̀kya abaa aa Ji səgə aa ɛ?” Bo kwiꞌi mə, “ji sàmbaà.” ");
INSERT INTO bfd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A tɨgə̀ ǹswoŋ mə tâ ǹnɔ̀ɔ̀ bə̂ wa ɨ̀ tswe a nsyɛ̂. Bɨ tswè mə̂, a lɔgə̀ ɨ̀baa jya ji sàmbaa, ǹtsaꞌatə Nwî, mbatə mfa a mbô ŋ̀gǎŋyəgə̂nnù ji jya mə ta bɨ yatə a mbo bə̀ byâ. ");
INSERT INTO bfd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bo lɛ ŋkɨ ntswe nɨ̂ m̀bùmtə mbwɛ̀ mî kə̀ꞌə̀kə̀ mî mɔꞌɔ̂; Yesu à nɨ̀ŋ mə mbɔɔnə ghu, nswoŋ mə tâ bɨ ŋkɨ nyatə a mbo bə̀ byâ. ");
INSERT INTO bfd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bo lɛ njɨ nyurə; bɨ̀ bwɛɛ̀ àbùgə̀ mɨjɨ ya, ɨ̀bàꞌa abaa jya bo bɨ̀ ɨ̀sàꞌa mbwɛ̀ jya, ɨ luu nɨ̂ ŋ̀kyɛ̀ ji sàmbaà. ");
INSERT INTO bfd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bə̀ bya bɨ̀tsɨ̀m lɛ mbə tsiꞌì tsǒ ntsùꞌù ji nɨkwà. ");
INSERT INTO bfd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesu à lɛ ntɨgə nswoŋ mə tâ bo lo ŋghɛ̀ɛ̀ŋkə̀ waa, m̀burə ntɨgə ŋkuu a mûm àkànuꞌu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji ŋghɛɛ a mbùꞌù àlaꞌa Dalamanuta. ");
INSERT INTO bfd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","BaFarɨsai lɛ nzì ǹtsiꞌi Yesu bo bo kâ ǹswuŋnə bo lɔ̀ɔ ŋkwàꞌànə yu, ǹswoŋ ghu mbo mə tâ à ghɨrə alènsə̀ yìi mə a lo a aburə aa tâ dɨ̀ꞌɨ mə Nwi à tswe bo yu. ");
INSERT INTO bfd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bô swòŋ mə̂ laà, a naŋsə̀ ǹso ntɨɨ yi, a tsaa nû yì, m̀betə mə, “Bə̀ bû bɨ lɔ̀ɔ alènsə̀ aa a ya ɛ? Mə̀ swoŋ a mbo bù tsiꞌì ànnù nɨ̂koŋ mə kaa mbə mə̀ waꞌǎ alènsə̀ yî tsu a mbo bù bə̂ bî faa ŋgùꞌù dɨꞌɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","À swòŋ mə̂ laà, m̀maꞌatə waa, mbu nlò ŋghɛɛ ŋkuu yi fu wa mûm àkànuꞌu, ǹtoo ŋghɛɛ a njii ŋ̀kì. ");
INSERT INTO bfd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ŋ̀gǎŋyəgə̂nnù Yesu jya ɨ lɛ nlìꞌìnə̀ a nlɔ̀gə̂ àbaa; ǹyə mə bo lɛ ntswe tsiꞌì nɨ̂ àbaa yì fùùrə̀ wa mûm àkànuꞌu. ");
INSERT INTO bfd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu a lɔgɨ̀nə̀ ŋ̀ka dɨꞌɨtə nɨ̂ waa nswoŋə nɨ mə, “Nɨ̀ ka ntsyɛsə nɨ̂ ghuu, ǹtsee nɨ̂ àtû yuu nloŋə mbɛ̀ꞌɛ̀ àbaà baFarisai bo bɨ̀ yì Herod.” ");
INSERT INTO bfd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bo tɨgə̀ ǹlɔgɨnə ŋka ŋghaa bo nɨ bo, ǹswoŋə nɨ mə, “A swoŋə laa nloŋ mə kaa bìꞌinə̀ sɨ̀ nɨ̂ àbaa tswê aà.” ");
INSERT INTO bfd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu à lɛ nzi annù yìi mə bo lɛ sɨ ghàà aà, m̀betə waa mə, “Nɨ bù ŋ̀ghaa àkə̀, m̀bu nswoŋə nɨ mə nɨ̀ sɨ̀ nɨ̂ àbaa tswê aa ɛ? Nɨ̀ burə tɨ̀ zi, kə̀ ǹyuꞌu tâ à laa a atu bù ɛ? A atû yuu laa a fɨ̀ɨ̂ àkə̀ ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nɨ̀ tswe nɨ̀ miꞌi aa kaa waꞌà nɨ̀ ɨ̀dɨ̀gə̀ yə̂ aa ɛ? Kə̀ nɨ̀ sɨ ɨnnù nɨ̂ ɨ̀tôŋnə̀ juu yuꞌu lɛ? Kə̀ kaa nɨ̀ sɨ annù kɨɨ mbu ŋwaꞌatə lɛ? ");
INSERT INTO bfd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mə̀ kɨ̀ bàtə̂ ɨ̀baa jya ji ntaà m̀fa wa mbo bə̀ bya ǹtsùꞌù ji ntaà aa nɨ̀ bwɛɛ̀ ɨ̀bàꞌa abaa jya ɨ luu aa nɨ̂ ŋ̀kyɛ̀ ji səgə aa ɛ?” Bo swoŋ mə, “Nɨ̀ghûm ǹtsò baà.” ");
INSERT INTO bfd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A bû m̀betə waa mə, “Mə̀ kɨ̀ bàtə̂ ɨ̀baa jya ji sàmbaa mfa wa mbo bə̀ bya ntsùꞌù ji nɨkwà aa, nɨ̀ ghotə̀ ɨ̀bàꞌâ ji ɨ kɨ̂ ǹluu aa nɨ̂ ŋ̀kyɛ̀ ji səgə aa ɛ?” Bo kwiꞌi ghu mbo mə, “Ji sàmbaà.” ");
INSERT INTO bfd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A tɨgə̀ m̀bu mbetə waa mə, “Kaa nɨ̀ waꞌǎ annù yî tsu ghu kɨ̂ ǹyəgə nzi aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bo lɛ nlò ŋ̀ghɛɛ a Bethsaida. Bo ghɛ̀ɛ̀ mə̂ ŋ̀kuu ghu, bə̀ bî mɔꞌɔ bɨ zi nɨ̂ m̀fə̀ꞌə̀nə̀ ghu mbo, m̀buꞌu mbo ghu mbo mə tâ à mɔɔntə yi. ");
INSERT INTO bfd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A tswâ àbo mfə̀ꞌə̀nə̀ wa, ǹlɔgə yi bo yu fɛꞌɛ̀ wa mûm àlaꞌà. Bo yu fɛ̀ꞌɛ̀ mə̂ ŋ̀ghɛɛ, a tutə̀ mɨ̀twyɛ ghu miꞌi, ǹnɔŋsə mbo mi ghu, m̀betə ghu mbo mə, “O yə ayoo yì tsu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A ŋɛntə̀ miꞌì mi a ǹdəŋ, ǹswoŋ mə, “Mə yə bə̂, lâ bɨ bâŋnə̀ m̀bə bə tsiꞌì tsǒ ɨtì jìi mə ɨ təə ŋghɛɛ.” ");
INSERT INTO bfd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu a bû ǹnɔŋsə mbô mi ghu miꞌi, m̀fə̀ꞌə̀nə̀ wa a naŋsə̀ ǹsaŋtə miꞌì mi nlii ɨdɨgə ghu, mɨ laa, a yə̂ ǹjoò tsɨ̀m tsiꞌì sɨgə̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu a swoŋ ghu mbo mə tâ à lo ŋkwɛɛ ghɛɛ yi a ndùgə yu, m̀bu nswoŋ ghu mbo mə, “Bɛɛ ò tɨ kwɛɛ, ò tsuu a mûm àlaꞌa bǔ kuu.” ");
INSERT INTO bfd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu à lɛ mbù ǹlo bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji ŋka ŋghɛɛ a ɨlaꞌa Kaisaria a mbùꞌu Filippi. Bo kà mə̂ aa ŋghɛɛ, a betə̌ ŋgǎŋyəgə̂nnù ji mə, “Bə̌ swoŋə nɨ mə mə̀ bə aa wo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bo kwiꞌi ghu mbo mə, “Bə̀ bî mɔꞌɔ bɨ swoŋə nɨ mə ò nɨ Jɔn Ŋgàŋmùrə bə̌ ŋkì, bǐ mɔꞌɔ bɨ swoŋə̀ nɨ mə ò nɨ Elijah, bǐ mɔꞌɔ bɨ swoŋə̀ nɨ mə ò nɨ ŋ̀gàŋntoò Nwì yî mɔ̀ꞌɔ̂.” ");
INSERT INTO bfd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A bû m̀betə waa mə, “Lâ nɨ̀ swǒŋ yuu ŋgaa mə mə̀ laa mbə wo aa ɛ?” Peta a kwiꞌi ghu mbo mə, “Ò nɨ Kristo, Àyɔꞌɔ̀ Nwì wâ.” ");
INSERT INTO bfd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu a tɨgə̀ ŋ̀kwantə waa, nswoŋ mə tâ bo tsuu a mbo ŋù tsù lǒ swoŋə. ");
INSERT INTO bfd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu à lɛ ntɨgə nlɔgɨnə ŋka tɔꞌɔtə a mbô ŋ̀gǎŋyəgə̂nnù ji mə Mu Ŋù à tswe nɨ̀ ǹyə̂ m̀buu ŋgɨꞌɨ jì ghàꞌàtə̀. Bɨ̀tà bɨ alaꞌa nɨ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì, bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ ka yǐ tuu yi. Bɨ ka yǐ zwitə yi, lâ tâ yù bu yweenə nɨwo a njɨ̌m njwi ji tarə̂. ");
INSERT INTO bfd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A lɛ naŋsə nswoŋ ma yuù ànnù aa mə tâ à fɛꞌɛ nlaa a atu bo. À swòŋ mə̂ laà, Peta a lɔgə̀ yi bo yu ghɛ̂ntə̀, a lɔgɨ̀nə̀ ŋ̀ka ŋghaantə nìi. ");
INSERT INTO bfd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lâ Yesu a bəŋkə̀ yi nlii njɨ̀m, ǹyə ŋgǎŋyəgə̂nnù ji, ŋ̀ghaantə Peta, ǹswon mə, “Tsyǎ mbɨ̀ɨ a njɨ̌m mə̀ m̀bâ, Satan! Ǹloŋ mə kaa ò sɨ aa njɨ̌m Nwì təə̀, ò bàŋnə ntəə a njɨ̌m bə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu à lɛ ntɨgə twoŋ nnɔ̀ɔ̀ bə̂ bya a bɔ̀ꞌɔ nɨ̂ ŋ̀gǎŋyəgə̂nnù ji bɨ zî ghu mbɛ̀ɛ̀, a swoŋ a mbo bo mə, “M̀bə ŋù tsù à ka nlɔɔ a ŋka nyòŋə a njɨ̌m mə̀, à tuù ɨ̀bɨ̀ɨ nû yi, mbeꞌe ati bàŋnə̀ bàŋnə yi ŋka yoŋə nàâ. ");
INSERT INTO bfd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ǹloŋ mə ŋù ǹtsɨ̀m yìi mə a lɔ̀ɔ a nyweensə̂ ɨ̀bɨ̀ɨnû yi aa, à ka bàŋnə bwɛ; lâ ŋù ǹstsɨ̀m yìi mə a lɔ̀ɔ a mbwɛ̂ ɨ̀bɨ̀ɨnû yi nloŋ ŋkwɨtû gha aa, kə̀ ǹloŋ ntoo yì ǹsɨgɨ̀nə̀ ya aa, a ka bàŋnə yweensə. ");
INSERT INTO bfd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","M̀bə a kwɛtə ŋû tsù aa nɨ̂ àkə̀ mə mbə a tswe nɨ̂ m̀bi yǔ ntsɨ̀m m̀baŋnə mbwɛ ntswêntɨ̀ɨ̂ yì aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kə̀ m̀bə ŋù a fa aa àkə̀ ŋ̀kwensə ntswêntɨ̀ɨ̂ yì ghu aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","M̀bə ŋù tsù à ka ndɨrə atu nloŋ ŋgaà yà, kə̀ ǹloŋ ànnù yìi mə mə swoŋə aa, a tɨtɨ̀ɨ bə̀ bû fàa ŋgùꞌû m̀bi yu mə ɨ tuu Nwî, bo bɨ̀ nɨ̀wàà nɨ bə̂ bù bìi bɨ ghɨ̀rə ɨnnù jî bɨ aa, boŋ Mu Ŋù à ka yǐ kɨɨ dɨ̀rə̀ nɨ̂ àtu nloŋ ŋgaa yì a noò yìi mə à ka yǐ bǔ bɨ̀ɨ̀ a mum nɨ̀ghaꞌa nɨ Taà yì bo bɨ̀ baangel bìi mə bɨ laa mmàŋsə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu a bû ǹswoŋ a mbo mə, “Mə̀ swoŋ a mbo bù tsiꞌì ànnù nɨ̂ ŋ̀koŋ mə bə̀ bî mɔꞌɔ bɨ tswe faà mə kaa bo ka yǐ waꞌà kwo tɨ ghə mə bo yə̀ mə̂ ànnǔ nɨfɔ̀ Nwî a zî tsiꞌì nɨ̀ àdàꞌà.” ");
INSERT INTO bfd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ǹjwi ɨ tsyà mə̂ ji ntoꞌo, Yesu a lɔgə̀ Peta, nɨ Jɛms, a bɔꞌɔ nɨ Jɔn bo bo kɔꞌɔ ŋghɛ̀ɛ̀ a atu ntaꞌa yì syâ yî mɔꞌɔ, ǹtswe ghu tsiꞌì bo bo. Nû yì ɨ bəŋkə̀ a nsi bo, ");
INSERT INTO bfd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ɨ̀tsə̀ꞌə̂ ji ɨ bəŋkə̀ ǹtɨgə ŋŋweenə tsiꞌì ŋwèènə̀, ǹtɨgə mfuꞌu nɨ mə buu, m̀fuꞌu ntsyatə ajàŋ yìi mə mbə ŋù tsù fàa mbi a ghɨrə̀ ɨ̀tsə̀ꞌə̀ ɨ kâ m̀fuꞌu aà. ");
INSERT INTO bfd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ yə̂ Elijah bo Moses bo zî ŋ̀ka ŋghaanə bo bɨ̀ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peta à yə̀ mə̂ laà, ǹswoŋ a mbo Yesu mə, “Rabbi, a bɔŋ mə bìꞌinə̀ tswe faà aà. Tâ bìꞌì ghurə mɨ̂ntàŋ mi ntarə̀, tâ yì fùùrə̀ ɨ̀ tswe a mbo wò, yǐ mɔꞌɔ ɨ̀ tswe a mbo Moses, tâ yǐ mɔꞌɔ ɨ̀ tɨgə ntswe a mbo Elijah.” ");
INSERT INTO bfd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peta à lɛ nswoŋ ma mùu ajàŋ aa nloŋ mə nɨ̀bɔꞌɔ nɨ lɛ nnaŋsə ntswa waa, kaa a waꞌa annù yìi mə mbə yu swoŋ aa bù ǹzi. ");
INSERT INTO bfd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bo ghə̀ mə kɨ yə mbàꞌà ɨ fɛꞌɛ̀ ŋ̀kusə waa, ǹjì ŋù ɨ fɛꞌɛ̀ wa mûm m̀bàꞌà ǹswoŋ mə, “À nɨ Mû ghà yî m̀bâŋnə̀ yìi mə mə̀ kɔ̀ŋə aa à ghulà; nɨ̀ ka nyuꞌunə nii.” ");
INSERT INTO bfd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bo yùꞌù mə njì ya aa, ŋ̀karɨkə waa, ǹlii ɨdɨgə, la kaa waꞌà ŋû dàŋ bû ǹyə ntsyatə Yesu yìi mə à lɛ ntswe bo bo aà. ");
INSERT INTO bfd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bô lò mə̂ wa atu ntaꞌa ŋka nsɨgə, Yesu a swoŋ a mbo bo mə tâ bo tsuu annù ya mə bo ghɨrə nyə aa, a mbo ŋù tsù lǒ swoŋ bə̂, ǹyweꞌe a nɨ nòò wa yìi mə Mu Ŋù à ka yǐ yweenə nɨ nɨ̀wo aà. ");
INSERT INTO bfd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bo lɛ nyuꞌu annù ya mə Yesu à lɛ nswoŋ aa, a kɨ̂ ǹtɨgə nlwiꞌi tsiꞌì a mbo bo. Lâ bo lɛ mbàŋnə̀ ǹtɨgə mbetə nɨ̂ waa bo nɨ bo mə, “Ǹjiꞌì ǹywèènə nɨwo, ɨ̀ bə aa àkə̀ lɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bo lɛ mbetə Yesu mə, “Ŋ̀gǎŋndɨꞌɨ̀ nɔ̀ŋsə̀ ɨ swoŋə nɨ mə Elijah à tswe nɨ̀ m̀fòo nzì yaꞌa aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A swoŋ mə, “À nɨ̂ ànnù nɨ̂ŋkoŋə̀, Elijah à ka fòo zì a ntsisə ɨnnù tsɨ̀mə̀. Lâ nɨ̀ kɨ ŋwaꞌatə mə àŋwàꞌànə̀ Nwî a swoŋə nɨ mə Mu Ŋu à ka yǐ yə mbuu ŋgɨꞌɨ jì ghàꞌàtə̀ tâ bə̀ tuu yi. Nɨ̀ mɔ̀ꞌɔ̀ntə mə a swoŋə laà aa a ya? ");
INSERT INTO bfd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lâ mə̀ swoŋ a mbo bù mə wa Elijah à lɛɛ̀ ǹzi, lâ bə̀ bâŋnə̀ ŋ̀ghɨrə ghu nu a ajàŋ yìi mə bo kɔŋ aà, tsiꞌì a ŋ̀gɨ̌ŋg ŋgɨ̀ŋ wa ajàŋ yìi mə àŋwàꞌànə̀ Nwî a lɛ nswoŋ nloŋ ŋgaa yì aà.” ");
INSERT INTO bfd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bo sɨ̀gə̀ mə̂ ǹtsiꞌi ŋgǎŋyəgə̂nnù Yesu jya jǐ mɔꞌɔ, ǹyə mə nnɔ̀ɔ̀ bə̂ yî ghàꞌà ŋ̀ghaꞌa ɨ lɛ ntswe bo bo, ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ ɨ betə nɨ̂ ɨ̀nnù a mbo bo, bo bo swûŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bə̀ bya bɨ ghə̀ mə̂ mə bɨ kɨ lèntə̀, ǹyə Yesu, ànnù a tsyâ waa bo burə̀ ŋ̀khə ŋghɛ̀ɛ̀ a ntsàꞌàtə̂ yi. ");
INSERT INTO bfd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A betə̀ waa mə, “Nɨ̀ swùŋnə̀ aa nɨ̂ ànnǔ akə bu bo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ŋù yî mɔ̀ꞌɔ a tɨtɨ̀ɨ bo a kwiꞌi mə, “Ǹdɨ̀ꞌɨ̀nnù, mə̀ ghɨ̀rə nzì nɨ mû ghà a mbo wò, ǹloŋ mə à tswe nɨ̀ àzwì yî bɨ yìi mə a ghɨ̀rə̀ mə tâ à tsuu kɨ ghàà. ");
INSERT INTO bfd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Àzwì yî bɨ ya a yi ntswa yi aa, a maꞌà yi nsyɛ, ŋghɨ̀rə̀ àjwòꞌò a ka mfɛꞌɛ ghu ntsù, a tɨgə̀ ŋ̀kurə nɨ̂ mɨ̀sɔ̌ŋ mi, nû yǐ tsɨ̀m ɨ têntə̀. Mə̀ ghɨ̀rə nswoŋ a mbô ŋ̀gǎŋyəgə̂nnù jo jù mə tâ bo fiꞌi azwì ya ghu atoꞌo kaa bo waꞌǎ mfiꞌi zî.” ");
INSERT INTO bfd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu a swoŋ a mbo bo mə, “Oò, bù, nɨ̀waa nɨ bə̂ bìi mə kaa bɨ̀ sɨ̀ nɨ̂ àbìintɨɨ tswê! Mə̀ ka tswe biꞌinə̀ ɨ yweꞌe aa a noò àkə̀ aa ɛ? Mə̀ ka kɨ tswa ntɨɨ̀ gha nloŋ ŋgaa yùù ɨ yweꞌe aa a noò àkə̀ aa ɛ? Zǐ mfa nɨ̌ mu wa a mbo mə̀!” ");
INSERT INTO bfd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bə̀ bya bɨ yuꞌu, nzì m̀fa mu wa ghu mbô. Àzwì ya a ghɛ̀sə̀ mə̂ ghə̀ə kɨ yə Yesu, m̀burə ntswa mu wa ntsɨ̀gə̀, a wô a nsyɛ, ntɨgə mbɨŋkə ghu, àjwòꞌò a fɛꞌɛ̀ ghu ntsù. ");
INSERT INTO bfd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu a betə ta bɨ̀ mu wa mə, “Nɨ̀ghɔ̀ɔ̀ nû nɨ̂ tswè mə̂ ghu nu aa ɨ̀lòò ji səgə?” A swoŋ mə, “Ǹlɔgɨnə a mûŋkhə̂. ");
INSERT INTO bfd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Àzwì yî bɨ yù a bùrə̀ mə nlɔɔ a nzwitə mu ghù tsiꞌì a nɨ̂ ŋ̀gàà jî ghàꞌàtə̀, ǹtswa mmaꞌa nɨ a mum mɔꞌɔ bo bɨ̀ a mûm ŋ̀kì. Tsɔ̀ꞌɔ̀ tsɔ̀ꞌɔ Taà, m̀bə ò zî ŋ̀ghɨ̀rə̂ ànnû tsu, ò kô mɨlɨ̀ŋnə̀ yìꞌì, ŋ̀kwɛtə yiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu a swoŋ ghu mbo mə, “Ò swǒŋ bə mə, ‘M̀bə ò zî ŋ̀ghɨ̀rə̂ ànnû tsu!’ Kaa m̀bə̂ ànnù yî tsu a waꞌà ŋû yìi mə à nɨ̌ŋ ntɨɨ̀ yi a nu Nwì aa tsyà bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ta bɨ̀ mu wa a burə̀ ǹtɔŋnə ŋghaa tsiꞌì nɨ̀tɨ̀ɨ̀ ǹswoŋ mə, “Wa mə̀ nɨ̌ŋ ǹtɨɨ̀ gha a nu wò, lâ kaa àbìintɨɨ̀ ya kaa a waꞌà kùꞌù, kwɛtə ghâ ta mə̀ kuꞌusə nnɨŋ ntɨɨ̀ gha a nu wò.” ");
INSERT INTO bfd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu a yə ǹnɔ̀ɔ̀ bə̂ wa ɨ ka nzwunə nzi ghu mbɛ̀ɛ̀, m̀burə ŋwenə azwì yî bɨ ya, ǹswoŋ ghu mbo mə, “Wò, àzwì yìi mə a ghɨ̀rə̀ nɨ mə tâ mu ghù à tsuu kɨ ghàà, ŋ̀kɨ ŋghɨrə mə tâ àtû yi kwo aa, mə̀ swòŋ a mbo wò mə ta ò fɛꞌɛ ghu atoꞌo, ǹyi tsùù ghu nu burə bǔ kuu kuu.” ");
INSERT INTO bfd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","À swòŋ mə̂ laà, àzwì ya a yəꞌə̀, ǹnaŋsə ntsɨgə mu wa tsiꞌì nɨ̀ mɨ̀tɨ̀ɨ̀, m̀fɛꞌɛ ghu nû. Mu wa à tɨgə̀ m̀bə tsǒ àku ŋû. Bə̀ bî ghàꞌàtə̀ bìi mə bɨ̀ lɛ nyə yi aa, bɨ lɛ nswoŋ mə, “À kwò mə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lâ Yesu a tswâ àbô yi, ŋ̀ŋɛɛ yi mbɨɨnsə, a bɨɨ̀nə̀ ǹtəə. ");
INSERT INTO bfd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu a tɨgə̀ ǹlo ŋghɛ̀ɛ̀ ŋ̀kuu a ndâ, à kùù mə̂ bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji tswê tsiꞌì bò bo, bo betə ghu mbo mə, “A ghɨ̀rə ŋghɨ̀rə akə kaa bìꞌì waꞌǎ mfiꞌi azwì ya zî aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu a kwiꞌi mə, “Kaa m̀bə bɨ waꞌǎ mbuu azwì ma yû nɨ̂ àyoo dàŋ fiꞌi ntsyàtə̌ atsàꞌàtə̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bo lɛ mmàꞌàtə adɨgə ya, ǹlo ŋghɛ̀ɛ̀ ǹtsya a mûm àlaꞌa Galilea. Kaa Yesu à waꞌà kɔ̀ŋ mə tâ ŋù tsù à zi ");
INSERT INTO bfd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nloŋ mə à lɛ sɨ dɨ̀ꞌɨ̀ ɨ̀nnù a mbo ŋ̀gǎŋyəgə̂nnù ji aà; ǹswoŋə nɨ a mbo bo mə, “Bɨ ka fa Mu Ŋù a mbo bə̀ tâ bɨ zwitə yi, bɛɛ mə bɨ zwitə yi boŋ a ka bǔ bɨ̀ɨ̀nə̀ fu nɨwo a njɨ̌m njwi ji tarə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","La kaa bo lɛ ŋwaꞌǎ njiꞌì ànnù ma yû mə à lɛ ŋka dɨꞌɨ aa zî, la mbàŋnə̀ m̀bɔꞌɔ nɨ a mbetə̂ yi. ");
INSERT INTO bfd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bo zì mə̂ ǹyweꞌe a Kapernaum, ŋ̀kuu ntswe a mûm ǹda, Yesu a betə waa mə, “Nɨ ghɨ̀rə̀ ŋ̀ghaa aa ànnǔ akə a mânjì aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","À bètə̀ mə̂ aa, kaa bo waꞌà waa bâŋnə̀ ŋ̀ghaa nloŋ mə bo ghɨrə ntswe a mânjì ŋ̀ghaa nswùŋnə̀ bo nɨ bo, ǹlɔɔ nɨ̂ ǹzi ŋù yìi mə à kɔ̀ꞌɔ ntsɨrə a tɨtɨ̀ɨ bo aà. ");
INSERT INTO bfd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu, a tswê a nsyɛ, ǹtwoŋ ŋgǎŋyəgə̂nnù ji jya nɨghûm ǹtsò baa, nswoŋ a mbo bo mə, “Ŋù yìi mə a lɔ̀ɔ̂ a mbə̂ ǹtsyàmbìì aa, à tswe nɨ m̀bəŋ ɨ tɨgə bə nlwìꞌìnjɨ̀m a tɨtɨ̀ɨ bə̀ bɨ̂tsɨ̀m, ŋ̀kɨ ntswe nɨ̂ m̀bə ŋgàŋàfàꞌà a mbo bə̀ bɨ̀ tsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","À swòŋ mə̂ laà, ǹlɔgə mûŋkhə ntɛꞌɛ a tɨtɨ̀ɨ bo, ŋ̀ŋɛɛ mu wa ntukɨtə a mbo yu, ǹswoŋ a mbo bo mə, ");
INSERT INTO bfd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ŋù ǹtsɨ̀m yìi mə à kwɛ̀rə mûŋkhə yì tsù tsǒ ghuà nɨ̂ ɨ̀kǔm gha aa, à kwɛ̀rə aà ghâ. Ŋù ǹtsɨ̀m yìi mə à kwɛ̀rə gha aa, kaa à sɨ̀ aa tsiꞌì gha kwɛrə̀, à kɨ ŋkwɛ̀rə aa yu wa yìi mə à lɛ ntòo ghâ aà.” ");
INSERT INTO bfd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jɔn a swoŋə a mbo Yesu mə, “Ǹdɨ̀ꞌɨ̂nnù, bìꞌì ghɨrə nyə ŋû yì mɔꞌɔ a fiꞌì nɨ ɨ̀zwì jî bɨ a atoꞌo bə̀ nɨ̂ ɨ̀kǔm gho, bìꞌì tsuꞌunə̀ yi nloŋ mə kaa à sɨ̀ ŋû àkòrə yìꞌinə̀ yî mɔ̀ꞌɔ bə aà.” ");
INSERT INTO bfd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu a swoŋ mə, “Nɨ̀ tsuu nìi kɨ tsuꞌunə bə̂, ǹloŋ mə ŋù à bə ghɨ̀rə annù yî yɛ̌yɛrə nɨ̂ ɨ̀kǔm ghà boŋ kaa m̀bə waꞌà bù ǹzi a wàŋsə a ŋghàa ànnù yî bɨ a noò ǹjɨ̀m a ngaa mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ǹloŋ mə ŋù yìi mə kaa à sɨ annǔ yiꞌinə̀ tuu aa, à bìi aà ǹjɨ̀m yìꞌinə̀. ");
INSERT INTO bfd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mə̀ swoŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, ŋù yìi mə à fa ndɔ̂ŋ ŋ̀kì mə tâ nɨ̀ no nloŋ mə nɨ bii nɨ̂ ɨkǔm Kristo aa, kaa à ka yǐ waꞌà tswê tɨ kwɛrə mɨ̀tsɔꞌɔnə̀ mɨ afàꞌâ mi. ");
INSERT INTO bfd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ŋù yìi mə à ghɨ̀rə mə ta mu yì mɔ̀ꞌɔ fàa tɨtɨ̀ɨ bɔɔ bì kəgə buà bìi mə bɨ nɨ̂ŋ ǹtɨɨ̀ waa a nu mə̀ aa, ŋù yìi mə a ghɨ̀rə a ghɨrə̀ ànnù yî bɨ ŋwò aa, a bɔŋ mə tâ bɨ̀ kwerə ŋgɔ̀ꞌɔ̀ àbaa yì ŋ̀wè ghu ntɔŋ ŋghɛɛ mmàꞌà a ŋkì mɨyaa.” ");
INSERT INTO bfd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","M̀bə àbô yo a ghɨrə mə tâ ò wo a mûm ɨnnù jî bɨ, ò kwyɛ̂ ǹlɔꞌɔsə. A bɔŋ mə ta ò bə abô mɔ̀ꞌɔ nyi ŋkuu a mûm ǹtswêntɨ̀ɨ̀, ǹtsyatə a ntswe nɨ̀ mbo mi mbaa nyi mbàŋnə̀ ŋ̀ghɛɛ a mum mɔꞌɔ Satan, a adɨgə yìi mə mɔꞌɔ ɨ khɨ ghu, kaa kɨꞌɨ̀ bwɛnə̀ aà.  ");
INSERT INTO bfd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ma mùu adɨgə kaa mɨ̀wìꞌì mìi mə mɨ kurə bə̂ aa, kaa mɨ sɨ kwokə, kaa mɔꞌɔ yìi mə ɨ tɔ̀ɔ̀ bə̂ ghu aa kaa waꞌà kɨ̀ɨ̀ m̀bwenə. ");
INSERT INTO bfd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kɨ̀ bɛɛ mə àkòrə̂ yo a ghɨrə mə ta ò wo a mûm ɨ̀nnù jî bɨ, ò kwyɛ̂ ǹlɔꞌɔsə. A bɔŋ mə ta ò bə ntâ mɔ̀ꞌɔ nyi ŋkuu a mûm ǹtswêntɨ̀ɨ̀, ǹtsyatə a ntswe nɨ̀ mɨ̀kòrə̀ mi mbaa tâ bɨ̀ yi mbàŋnə̀ m̀maꞌa gho a mum mɔꞌɔ Satan.  ");
INSERT INTO bfd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ma mùu adɨgə kaa mɨ̀wìꞌì mìi mə mɨ kurə bə̂ aa, kaa mɨ sɨ kwokə, kaa mɔꞌɔ yìi mə ɨ tɔ̀ɔ̀ bə̂ ghu aa, kaa ɨ waꞌà kɨ̀ɨ̀ m̀bwenə. ");
INSERT INTO bfd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bɛɛ mə nɨ̀lìꞌî no nɨ ghɨrə mə tâ ò wo a mûm ɨ̀nnù jî, bɨ ò tweꞌè m̀meꞌe. A bɔŋ mə ta ò bə nɨliꞌì mɔ̀ꞌɔ nyi ŋkuu a mûm ànnù nɨfɔ̀ Nwî, ǹtsyatə ntswe nɨ miꞌi mi mbaa tâ bɨ̀ yi mbàŋnə̀ m̀maꞌa gho a mum mɔꞌɔ Satan. ");
INSERT INTO bfd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ma mùu adɨgə kaa mɨ̀wìꞌì mìi mə mɨ kurə bə̂ aa, kaa mɨ sɨ kwokə, kaa mɔꞌɔ yìi mə ɨ tɔ̀ɔ̀ bə̂ ghu aa, kaa ɨ waꞌà kɨ̀ɨ̀ m̀bwɛnə. ");
INSERT INTO bfd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bɨ ka yǐ naŋsə ŋû ǹtsɨ̀m nɨ mɔꞌɔ, a ŋgɨ̌ŋgɨ̀ŋ a ajàŋ yìi mə bɨ naŋsə nɨ̂ ǹjoo mmàꞌanwì tsɨ̀m nɨ fɨ̀ŋgwaŋ aà. ");
INSERT INTO bfd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Fɨ̀ŋgwaŋ fɨ bɔŋə̀, Lâ m̀bə fɨ̀ŋgwaŋ fɨ tuu nìi bǔ kɨ lìì, boŋ bɨ ka tɨgə bǔ ghɨ̀rə aa mə akə tâ fɨ̀ bǔ ka nlii aa ɛ? A bɔŋ mə tâ nɨ̀ ghɨrə tâ fɨ̀ŋgwaŋ tswe a nu bù tǎ tâ nɨ tswe nɨ̂ m̀bɔɔnə bù nɨ bù. ");
INSERT INTO bfd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu à lɛ mbù ǹlo maa adɨgə ŋghɛɛ a mbùꞌu Yudea, ǹtoo ŋghɛɛ a njii ŋ̀kǐ Jordan. À ghɛ̀ɛ̀ mə̂ ǹtswe ghu, àkùrə̀ bə̂ a bû m̀boontə ghu mbɛ̀ɛ̀. À bû ŋ̀ka ndɨꞌɨ waa nɨ̂ ànnù Nwi tsiꞌǐ ajàŋ yìi mə à lɛ sɨ ghɨ̀rə a ŋgaa ŋgaa aà. ");
INSERT INTO bfd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","BaFarɨsai bɨ lɛ nzì ǹtsitə yi, ǹlɔɔ mə bɨ kwàꞌànə̀ yi, m̀betə yi mə, “Nɔ̀ŋsə̀ à bìi mə tâ ŋù à fiꞌi ŋgwɛ yì a nda yu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A betə̀ waa mə, “Moses à lɛ nswoŋ a mbo bù mə akə nloŋ ma yu ànnù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bo swoŋ mə, “Moses à lɛ nlə̀ə mə mbə ŋù a tswe nɨ̂ m̀fìꞌi ŋ̀gwɛ̂ yì a nda yu, a ŋwàꞌànə̀ àŋwàꞌànə nsàꞌa nɨ̀yɔꞌɔ m̀bɔŋ furə yi.” ");
INSERT INTO bfd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Lâ Yesu a swoŋ a mbo bo mə, “Moses à lɛ ŋŋwàꞌànə nɔ̂ŋsə̀ mà ghu a mbo bù aa nloŋ mə mɨ̀ntɨɨ̀ muu lɛ ntɨ̀ɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lâ ǹlɔgɨnə a noò yìi mə Nwì à lɛ nnaŋsə mbi yù aa, àŋwàꞌànə̀ Nwî a swoŋ mə, ‘Nwì à lɛ nnaŋsə waa aa, ŋùmbâŋnə̀ nɨ màŋgyɛ̀.’ ");
INSERT INTO bfd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tsǒ mə a bə laà aa, ŋùmbâŋnə̀ à ka kɨ màꞌàtə̀ taà yì bô ǹdè yì, ɨ zî bòònsə̀ bô ŋ̀gwɛ̂ yì, tâ bo bì baa tɨgə mbə njyǎnu yì m̀fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Maa ajàŋ kaa tâ bo waꞌà bə̂ bî baa bù m̀bə, ntɨgə mbə njyǎnu yì m̀fùùrə̀.’ ");
INSERT INTO bfd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ma mùu ajàŋ àyoo yìi mə Nwìŋgɔ̀ŋ à bòònsə̀ mə̂ aa, tâ ŋù tsù à tsuu lǒ yàtə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu à bù mə̂ ǹlo ŋkuu ŋghɛɛ a nda, ŋ̀gǎŋyəgə̂nnù ji ɨ bû m̀betə ɨnnù ghu mbo nloŋ annù ma yû. ");
INSERT INTO bfd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A kwiꞌi a mbo bo mə, “M̀bə ŋùmbâŋnə a fiꞌi ŋgwɛ̂ yì a nda yu mbu nyɔꞌɔ yî dàŋ boŋ à ghɨ̀rə aa annǔ mâghàbə̀; m̀fansə annù a mbô ŋ̀gwɛ̂ yì. ");
INSERT INTO bfd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kə̀ bɛɛ mə mâŋgyɛ̀ a tuu ndoò yì, m̀fɛꞌɛ ŋghɛ̀ɛ̀ ǹyɔꞌɔ yî dàŋ boŋ à ghɨ̀rə aa annǔ mâghàbə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bə̀ bî mɔꞌɔ bɨ lɛ nzì nɨ bôŋkhə ghu mbo mə tâ à nɔŋsə mbô mi a atu bo, lâ ŋ̀gǎŋyəgə̂nnù ji ɨ wenə̀ waa. ");
INSERT INTO bfd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bɨ kà mə̂ aa ŋwenə waa aa, Yesu a yə, ǹtɔ̀ŋə̂ yi ɨ lwî, a swoŋ a mbo bo mə, “Nɨ̀ maꞌatə bɔɔ bya tâ bɨ̀ zi a mbo mə̀, ǹtsuu waa kɨ kɨ̀ŋə̀ bə̂; ǹloŋ mə ànnù nɨfɔ̀ Nwî a tswe aa a mbo bə̀ tsǒ bo. ");
INSERT INTO bfd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋ mə, ŋù yìi mə à sɨ annǔ nɨfɔ̌ Nwî tsiꞌì tsǒ mûŋkhə kwɛrə aa, kaa à ka yǐ waꞌà ghu kuù.” ");
INSERT INTO bfd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","À swòŋ mə laà aa, ŋŋɛɛ bɔɔ bya ŋkweꞌe, nnɔŋsə mbô mi a atu bo, ǹnɨŋ mbɔ̀ɔnə a nu bo. ");
INSERT INTO bfd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu à lɛ mfɛ̀ꞌɛ̀ ŋ̀ghə̀ə kɨ ghɛ̀ɛ̀ nɨghaa, ŋùmbâŋnə̀ yî mɔ̀ꞌɔ a khə̂ ǹzi nswɛ̀ɛ̀tə̀ mɨkuꞌutə̂ mi ghu nsi, m̀betə yi mə, “Ǹdɨ̀ꞌɨ̂nnù yî ǹsɨgɨ̀nə̀, m̀bə mə̀ ghɨrə̀ aa mə akə m̀bɔŋ jɨ ɨlòŋ yìi mə ɨ tswe nɨ̂koŋə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu a betə̀ ghu mbo mə, “Ò twòŋə gha nɨ ŋù yî ǹsɨgɨ̀nə̀ aa a ya aa ɛ? Kaa ŋù yì ǹsɨgɨ̀nə̀ à sɨ ghu tswê, ǹtsyatə Nwî yuyu. ");
INSERT INTO bfd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ò zî ǹdɨꞌɨ Nwî: ‘Tsuu ŋû zwitə. Tsùu annǔ mâghàbə̀ ghɨ̀rə. Tsùu yə̀rə̀. Tsùu abǎŋnənnù tswɛɛ. Tsùu ŋkòbə̀ a nu ŋù jɨtə. Ka nyuꞌunə taà ghò bo ǹdè ghò.’ ” ");
INSERT INTO bfd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ŋù wa a swoŋ a mbo Yesu mə, “Ǹdɨꞌɨ̂nnù, mə lə̀ə mə ndɨꞌɨ mà jû tsiꞌì tsɨ̀mə̀, ǹlɔgɨnə aa a mûŋkhə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu a liì yi, ŋ̀kɔŋə yi, ǹswoŋ ghu mbo mə, “Àyoo yì fùùrə̀ a boŋə a mbo wò: Ghɛ̀ɛ mfèe njoò tsɨ̀m jìi mə ò tswe nɨ ju aa, ǹlɔgə ŋkabə yìi mə ò fèe ghu aa, nyàtə̀ a mbô ŋ̀gàŋə̂fumə, boŋ ò ka bàŋnə tswe nɨ̂ àfùꞌù a aburə. Ò ghɛɛ ŋghɨ̀rə̀ ma mùu ajàŋ, ò bû m̀bɨɨ nzì ŋ̀ka nyoŋə nàâ.” ");
INSERT INTO bfd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A yuꞌù ànnù ma yû, nû yì ɨ bɔrə, a lô ǹtɨgə ŋghɛɛ nɨ̂ àjəŋnə̀, ǹloŋ mə a lɛ mburə mbə ŋgàŋkabə yî ŋwè aà. ");
INSERT INTO bfd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu a karɨkə̀ yi nlii ŋgǎŋyəgə̂nnù ji nswoŋ mə, “A burə ǹtsyànə̀ siꞌi a mbo ŋ̀gàŋkabə a ŋkuu a mûm ànnù nɨfɔ̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ànnù ma yû a lɛ mburə ŋghaꞌa ŋ̀gǎŋyəgə̂nnù Yesu. La a bû ŋkuꞌusə nswoŋ a mbo bo mə, “Bɔɔ̀ bâ, a burə ntsyànə̀ siꞌi siꞌi a ŋkuu a mûm ànnu nɨfɔ Nwî. ");
INSERT INTO bfd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A fwaatə a mbo kamɛl a ntsurə a nɨliꞌi nɨ saꞌa ntsyatə a mbo ŋ̀gàŋkabə a kuu a mûm ànnù nɨfɔ̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bo yùꞌù mə̂ nuà nɨ̀ghàà nɨ burə̀ ǹtsya waa tsiꞌǐ a mbə̂nnù bo tɨgə̀ m̀betə bo nɨ bo mə, “Ŋù yìi mbə a yweenə aa a tɨgə mbə aa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu aliì waa nswoŋ mə, “Ànnù a tsya aa bə ŋùmɨ̀sɔ̀ŋə̀, kaa a sɨ Nwî tsya, ǹloŋ mə mbə Nwì à tse ghɨ̀rə ɨnnù tsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peta a lɔgɨ̀nə̀ ŋ̀ka nswoŋ ghu mbo mə, “Tɨgə ò yə mə bìꞌì mmàꞌàtə̌ njoò tsɨ̀m tǎ kɨ yòŋə̀ nòô?” ");
INSERT INTO bfd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu a swoŋ mə, “Mə̀ swoŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, ŋù ǹtsɨ̀m yìi mə à màꞌàtə nda yi, kə̌ bɔɔ bɨ maà bi bi mbâŋnə̀ kə̀ bì bâŋgyɛ̀, kə̌ ndè yì, kə̀ taà yì, kə̌ bɔɔ̀ bi, kə̌ ɨbwensyɛ ji nloŋ ŋgaa yà kə̀ ǹloŋ ntoo yì ǹsɨgɨ̀nə̀ aa, ");
INSERT INTO bfd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","à ka yi kwɛrə, tsɨ̂tsoŋ fàa atu nsyɛ, nda bo bɨ̀ bɔɔ bɨ maà bǐ bi mbâŋnə̀ bo bɨ̀ bì bâŋgyɛ̀, nɨ bɨ̀ndè, nɨ bɔɔ, nɨ̂ ɨ̀bwěnsyɛ, ŋgaa ŋkhɨ̀, tâ bə̀ kɨɨ ntsɔꞌɔ nɨ̂ àkòrə̂ yi. Lâ bɛɛ a yi tɨ bə a noò ǹjɨm, a jɨ̂ ɨ̀lòŋ yìi mə ɨ lwiꞌi nɨ̂ŋkoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lâ bə bî ghàꞌàtə̀ bìi mə bɨ nɨ bɨ̀tsyà bɨ mbìì tsɨ̂tsɔ̀ŋ aa ka yi tɨgə bə bɨ̀tsɨrə bɨ njɨ̀mə̀, tâ bɨ̀tsɨrə bɨ njɨ̀m tâ bɨ̀ yi mbàŋnə̀ ǹtɨgə bɨ̂tsyà bɨ mbìì.” ");
INSERT INTO bfd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu à lɛ nswoŋ ma juù ɨ̀nnù aa a noò yìi mə bo lɛ ntswe a mânjì, ŋ̀kɔꞌɔ ŋghɛɛ nɨ a Yerusalem aà. À lɛ sɨ ghɛ̀ɛ̀ nɨ a mbìì ŋ̀gǎŋyəgə̂nnù ji jya ɨ yoŋə̀ nɨ a njɨ̀m, ànnù a burə̀ ǹtsya waa tsiꞌì tsyà; nɨ̀bɔꞌɔ nɨ tswâ bə̀ bya bìi mə bɨ lɛ sɨ yòŋə̀ nɨ̂ waa laà. Yesu a lɔgə̀ ŋ̀gǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa bo bo ghɛ̂ntə a mbìì, a bû ŋ̀ka ŋkwatə nswoŋ nɨ̂ ɨ̀nnù jìi mə ɨ ka fɛ̀ꞌɛ̀ a nu yu aà. ");
INSERT INTO bfd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A swoŋ a mbo bo mə, “Yə̂ nɨ̀, tsǒ mə bìꞌinə̌ kɔꞌɔ ŋghɛɛ a Yerusalem aa, bìꞌinə̂ ka kɔꞌɔ ghɛɛ ghu, tâ bɨ̀ tswa Mu Ŋù m̀fa a mbo bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ a mbô ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ tâ bo tsɔꞌɔtə ɨsaꞌà yi ntsərə mə tâ bɨ̀ zwitə yi. Bɛɛ bo tsərə laà boŋ bo ka tɨgə lɔ̀gə̀ yi fa a mbo bɨtɨ̀zi Nwî, ");
INSERT INTO bfd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","tâ bo ka ŋwyɛ nìi, ntutə mɨ̀twyɛ ghu nu, ŋ̀ghɔɔ yi, mbɔŋ nzwitə yi. Bɛɛ mə̂ ǹjwi ɨ tsya ji tarə, a bû mbɨɨnə nɨwô.” ");
INSERT INTO bfd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jɛms bo Jɔn, bɔɔ bɨ Zebedee, bo lɛ nzì ǹtsiꞌi Yesu ǹswoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨ̂nnù, bìꞌi lɔ̀ɔ mə ta ò ghɨrə annù yî mɔꞌɔ a mbo bìꞌì.” ");
INSERT INTO bfd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A betə a mbo bo mə, “Nɨ lɔ̀ɔ mə ta mə̀ ghɨrə aa annǔ kə a mbo bù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bo swoŋ ghu mbo mə, “Bìꞌi lɔ̀ɔ mə ta ò bii mə, nòò yìi mə ò ka yǐ kuu a mûm ànnù nɨfɔ̀ wò aa, ta biꞌi bi baa tswe, yì mɔ̀ꞌɔ a mbɛ̀ɛ̀ nɨ̀kwɛɛ wò nî màꞌà, yì mɔ̀ꞌɔ, a mbɛ̀ɛ̀ abô ŋ̀kwàbə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Lâ Yesu a swoŋ a mbo bo mə, “Kaa nɨ̀ sɨ̌ annù yìi mə nɨ betə aa zî. M̀bə nɨ̀ nô ǹdɔŋ yìi mə mə̀ tswe nɨ̀ ǹno aa, kə̀ m̀bə nɨ̀ bii mə bɨ̀ m̀murə ghuu a mûm ŋ̀kì a ajàŋ yìi mə bɨ tswe nɨ̀ m̀murə mə̀ ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bo bii mə, “Ɨ̀ɨ̀ŋə.” Yesu a swoŋ a mbo bo mə, “Tsiꞌǐ annù nɨ̂ŋkoŋə̀, nɨ̀ ka no ndɔŋ yìi mə mə̀ tswe nɨ̀ nno aà, tâ bɨ̀ kɨ mmurə ghuu a mûm ŋ̀kì a ajàŋ yìi mə bɨ tswe nɨ̀ m̀mùrə mə̀ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","La kaa à sɨ adɨgə ya bə̂ a ntsɔꞌɔ bə̀ bìi mə bɨ ka yǐ tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ mə̀ nî màꞌà kə̀ nî ŋ̀kwàbə̀ aà, a nɨ̂ ɨ̀dɨ̀gə̀ ma jû aa a ka yǐ tswe bə̂ bìi mə bɨ naŋsə ɨləŋ ghu a mbo bo aà.” ");
INSERT INTO bfd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Àbùgə ngǎŋyəgə̂nnù jya nɨ̀ghum bô yùꞌù mə annu ma ya, ǹlwisə ntɔŋ a nu Jɛms bo Jɔn. ");
INSERT INTO bfd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu a twoŋə̀ waa bɨtsɨ̀m, bo zi a mbɛ̀ɛ yu, a swoŋ mə, “Nɨ̀ zi mə bə̀ bìi mə bɨ saꞌa bɨ̀tɨ̀zî Nwî aa, bɨ nɔŋ aa atu bo, m̀buꞌutə nɨ̂ waa; bə̀ bî wè byaa bɨ tswê nɨ̂ àdàꞌà a atu bo. ");
INSERT INTO bfd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kaa m̀bə waꞌǎ maa ajàŋ a tɨtɨ̀ɨ bù bə̂; ŋù yìi mə a lɔ̀ɔ mbə ŋù yî ŋ̀wè a tɨtɨ̀ɨ bù aa, tâ à bə ŋgàŋàfàꞌâ ghùù, ");
INSERT INTO bfd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","tâ ŋù yìi mə a lɔ̀ɔ mbə ǹtsyàmbìì aa, tâ à bə abùꞌû yuu bɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ǹloŋ mə, tsiꞌì Mu Ŋù, kaa à lɛ ŋwaꞌà zì aa mə tâ bɨ̀ ka mfaꞌa ghu mbô. À lɛ nzì aa a mfàꞌa a mbo bə̀, ɨ kɨɨ fa ntswêntɨ̀ɨ̀ yì a ntsuꞌu atu bə̂ bî ghàꞌàtə̀ ghu.” ");
INSERT INTO bfd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji bo lɛ zì ǹyweꞌe a Yeriko, bô lò mə̂ ghu ŋka mfɛꞌɛ bo bɨ àkùrə̀ bə̂ bî ghàꞌàtə̀, ǹyə Batimeo, m̀fə̀ꞌə̀nə̀ mu Timeo, a tswê a mbɛ̀ɛ̀ mânjì, ǹlɔɔ nɨ̂ ǹjoò. ");
INSERT INTO bfd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","À yùꞌù mə̂ mə à nɨ Yesu mu Nazareth, ǹlɔgɨnə ŋka ntɔŋnə nswoŋə nɨ mə, “Yesu, Mu David, ko mɨlɨ̀ŋnə̀ ghà!” ");
INSERT INTO bfd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","À kà mə̂ aa ŋghaa laà, bə̀ bì ghàꞌàtə̀ bɨ ka ŋghaantə nswoŋə ghu mbo mə tâ à kutə ntsù yi; la a bâŋnə̀ ŋ̀kuꞌusə ŋghɛ̀ɛ̀ bə nɨ̀ mbìì ǹtɔŋnə nswoŋə nɨ mə, “Mu David, ko mɨlɨ̀ŋnə̀ ghà!” ");
INSERT INTO bfd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu a təə, ǹswoŋ mə, “Nɨ̀ twoŋə yi tâ à zi.” Bɨ twoŋə̀ m̀fə̀ꞌə̀nə̀ wa nswoŋ ghu mbo mə, “Gaansə mɨtɨ̀ɨ̂ mô m̀bɨ̀ɨ̀nə̂, wâ a twoŋə nòô!” ");
INSERT INTO bfd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A burə̀ m̀furə atsə̀ꞌə̀ yìi mə à lɛ ŋwabətə a nu yu aa, mmaꞌa, ǹlɨ mbɨɨnə ŋghɛɛ a mbɛ̀ɛ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu a betə ghu mbo mə, “O lɔ̀ɔ mə tâ mə̀ ghɨrə aa akə̀ a mbo wò?” M̀fə̀ꞌə̀nə̀ wa a swoŋ mə, “Taà, ghɨ̀rə tâ mə̀ bu ŋka nyə ɨdɨgə!” ");
INSERT INTO bfd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu a swoŋ ghu mbo mə, “Tɨgə nlǒ ŋka ŋghɛ̀ɛ̀ nòô m̀bà, wa àbìintɨɨ̀ yo a ghɨ̀rə̀ mə̂ ò tɨɨ̀.” À swòŋ mə̂ laà, miꞌi mɨ m̀fə̀ꞌə̀nə̀ wa mɨ kɨ̂ ŋ̀ghɛnsə nlaa, ǹtɨgə nyə nɨ̂ ɨ̀dɨ̀gə̀, a tɨgə̀ ǹlo ŋka nyoŋə nɨ̂ Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bô ghɛ̀ɛ̀ mə̂ ŋ̀ka ŋkuu a Yɛrusalem, ŋ̀ghɛɛ nyweꞌe a Betfage bo a Bethany, a mbɨ̀ɨ̀ ǹtaꞌa Olive, Yesu a toò ŋ̀gǎŋyənə̂nnù ji ji baa ");
INSERT INTO bfd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ǹswoŋ a mbo bo mə, “Nɨ̀ ghɛɛ ŋkuu a mûm mû àlaꞌa yì, a mbìi bù. Nɨ̀ bə ghɛ̀ɛ kɨ kuu ghu boŋ nɨ̀ ka yə mu nàà jàkâsì yìi mə kaa ŋù à lɛɛ̀ m̀burɨtə̀ ghu atu kɔꞌɔ aa, tâ bɨ̀ tɨŋnə. Nɨ̀ yə, nɨ̀ fɛɛ̀ ǹzi mfa nɨ mə̀. ");
INSERT INTO bfd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bɛɛ nɨ̀ tɨ fɛ̀ɛ̀ ŋù a betə ghuu mə nɨ fɛ̀ɛ̀ aa a ya lɛ, nɨ̀ swoŋ ghu mbo mə, ‘A lɔ̀ɔ Mmàꞌàmbî. Wâ à ka wàŋsə bènsə̀ fu.’ ” ");
INSERT INTO bfd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bô ghɛ̀ɛ̀ mə̂ nyə jâkâsì wa bɨ̂ tɨ̂ŋnə̀ a ntsǔnda a mbɛ̀ɛ̀ mânjì, bo tɨgə̀ ŋ̀ghɛɛ ŋka mfɛɛ. ");
INSERT INTO bfd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bo kà mə̂ aa mfɛɛ aa, bə̀ bìi mə bɨ lɛ ntəə maa adɨgə aa, bɨ betə̀ waa mə. “Nɨ ghɨ̀rə̀ aa àkə̀? Nɨ fɛ̀ɛ mu jàkâsì wa aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bɨ bètə̀ mə̂ laà, bo kɨ̂ ŋ̀kwiꞌi tsiꞌì wa ajàŋ yìi mə Yesu à ghɨ̀rə nswoŋ mə tâ bo kwiꞌi aà. Bə̀ bya bɨ tɨgə̀ m̀maꞌatə waa bo ghɛɛ̀ nɨ nàà yâ. ");
INSERT INTO bfd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bo zî nɨ jàkâsì wa a mbo Yesu, ǹlɔgə ɨ̀tsə̀ꞌə̌ jyaa nnɔŋsə wa njɨ̌m nàà, Yesu a tɨgə̀ ŋ̀kɔꞌɔ ntswe ghu. ");
INSERT INTO bfd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bə̀ bî ghàꞌàtə̀ bɨ lɔgə̀ ɨ̀tsə̀ꞌə̂ jyaa nsaŋtə a mânjì, bə̀ bî mɔꞌɔ bɨ ghɛɛ̀ ǹlɔɔ ɨjaŋ a mûm mɨ̀nsòò ŋ̀kɨ nzi nɔ̀ŋsə̀ wa mânjì. ");
INSERT INTO bfd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesu à kà mə̂ aa ŋghɛɛ, bə̀ bìi mə bɨ lɛ sɨ ghɛ̀ɛ a mbìì aa, bo bɨ̀ bìi mə bɨ lɛ sɨ yòŋə̀ ghu njɨ̀m aa, bɨ tɨgə̀ ǹtɔŋnə nswoŋə nɨ mə, “Hosiana! Bìꞌinə̀ ghaꞌasə yu wa yìi mə a zì a nɨ̂ ɨ̀kǔm Mmàꞌàmbi aà.” ");
INSERT INTO bfd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bìꞌinə̀ ghaꞌasə annù nɨfɔ̀ taà yìꞌinə̀ David yìi a zì aà. Hosiana a mbo Nwî Àkɔꞌɔ̀ntsɨrə. ");
INSERT INTO bfd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu à kùù mə̂ a Yerusalem, ŋ̀kuu ŋghɛɛ a ndâmàꞌanwì, ǹlii nyə ŋgɔ̀ŋ ǹjoò tsɨ̀m jìi mə ɨ lɛ ntswe ghu aà. Tsǒ mə à lɛ tɨ bə aa boŋ nòò à ghɛ̀ɛ̀ mə̂ aa, bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa bo tɨgə̀ ǹlo m̀bu mbɨ̀ɨ̀ fu a Bethany. ");
INSERT INTO bfd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Àbɛ̀ɛ̀ a lò mə̂ m̀fuꞌu bo lô a Bethany ŋka mbɨɨ, ǹjɨ̀ ɨ kâ nyaŋə Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A təə a sàꞌa aghaꞌa nyə ati fig, ɨ̀yə̌ŋ ji ɨ naŋsə̀ m̀fwɛ mfwɛ ntɨgə mfii nɨ mə tsɨ̀ŋ, a ghɛɛ̀ ghu mbɛ̀ɛ̀ mə mbə yu yə àyoo ghu tǎ kya jɨ lɛ. À ghɛ̀ɛ̀ mə̂ ǹyə tsiꞌì ɨ̀fu fù kaa waꞌǎ ayoo ghu yə̂, ǹloŋ mə kaa à lɛ ŋwaꞌà noò mɨ̀ntà mɨ fɨg bə aà. ");
INSERT INTO bfd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","À yə̀ mə̂ laà, ǹswoŋ a mbo àtì fig ya mə, “Ǹlɔgɨnə sii, kaa ò ka yǐ waꞌà mɨ̂ntà bû ŋkoonə tâ bə̀ jɨ.” Ŋ̀gǎŋyəgə̂nnù ji jya lɛ yuꞌu annù ya mə à lɛ nswoŋə aà. ");
INSERT INTO bfd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bô ghɛ̀ɛ̀ mə̂ ǹyweꞌe a Yerusalem, Yesu a kuu a mûm ǹdâmàꞌanwì. À kùù mə̂, ǹyə bə̂ bɨ tswê ghu, m̀fee ŋkɨɨ nyuu nɨ̂ ǹjoò. A tɨgə̀ ǹlɔgɨnə ŋka mfurə nɨ̂ waa ma byâ bìi mə bɨ lɛ sɨ taŋə mɨtaa ghu aà. Ǹtii ɨtɛtə̀ bə̂ bìi mə bɨ lɛ sɨ kwensə nɨ̂ ŋ̀kabə ghu aa, bo bɨ̀ ɨ̀lə̀ŋ bə̂ bìi mə bɨ lɛ sɨ fèè nɨ̂ bɨ̀ bugɨrəmɨ̀kuu aa, mmàꞌànə̀ a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kaa waꞌà lò m̀bii mə tâ ŋù nɨ̀bò wàà yî tsù tâ à beꞌe njoo ŋkuu ntsya nɨ ju wa ndâmàꞌanwì. ");
INSERT INTO bfd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","À ghɨ̀rə̀ mə̂ laà, ǹtɨgə nlɔgɨnə ŋka ndɨꞌɨ waa, ǹswoŋ mə, “A tswe a mûm àŋwàꞌànə Nwî mə, ‘Bɨ ka yǐ tɨgə twoŋə nɨ̂ ǹdâ yà nɨ̂ ǹda yìi mə bə̀ bɨ ɨtoò tsɨ̀m ka yǐ tɨgə zǐ tsàꞌàtə̀ nɨ̂ Nwî ghu’. Lâ nɨ̀ bàŋnə̀ mə̂ m̀bəŋ ɨ tɨgə̀ àdɨ̀gə nlə̀ə̀ntə bɨ̀yə̀rə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bɨlɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ lɛ nyuꞌu annù yìi mə à lɛ ŋghɨ̀rə̀ aa, ǹtɨgə nlɔɔ nɨ mânjì yìi mə mbə bo tsyâ ghu nzwitə yi. Bo lɛ sɨ bɔꞌɔ nìi nloŋ mə nnɔ̀ɔ̀ bə̂ wa tsɨ̀m lɛ mburə yɛrə nɨ̂ ɨ̀nnù jya yìi mə à lɛ sɨ dɨ̀ꞌɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","À bə̀ mə̂ a noò ŋ̀kwɛ̂fɔ̀ Yesu bo bɨ̀ ŋ̀gǎŋyənə̂nnù ji bo fɛꞌɛ̀ wa mûm àlaꞌa Yerusalem, ŋ̀ghɛɛ waa. ");
INSERT INTO bfd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Àbɛ̀ɛ̀ a fùꞌù mə̂ bo ka ǹtsya a tɨ̀tugə, nyə mə atì fig ya a yòò mə̂ tsiꞌì tsɨ̀m ǹsɨgə nyweꞌe nɨ mɨ̀ŋgǎŋ mi. ");
INSERT INTO bfd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peta a yə ŋwaꞌatə annù ya mə Yesu à lɛ nswoŋ aà, ǹswoŋ ghu mbo mə, “Rabbi, yə atì fig ya mə ò kɨ̀ ǹnɨ̌ŋ ndɔ̀ɔ̀ ghu atu aà. A yòò mə̂!” ");
INSERT INTO bfd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu a swoŋ a mbo bo mə, “Nɨ̀ nɨŋ ntɨɨ̀ ghuu a nu Nwì.” ");
INSERT INTO bfd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mə̀ swoŋ tsiꞌì ànnù nɨ̂koŋ a mbo bù mə, “Ŋù ǹtsɨ̀m yìi mə à swoŋ a mbô ǹtaꞌa ghulà mə, ‘Tsɔꞌɔnə ŋghɛ̀ɛ nnàŋə a mûm ŋ̀kì mɨyaa,’ ǹswoŋə aa kaa ŋkɨꞌɨ̀ jɨ̀ŋkə̀ a mûm ǹtɨɨ yu, m̀bii nɨ mə ànnù yìi mə yu swoŋ aa, a ka fɛ̀ꞌɛ̀ tsiꞌì maa ajàŋ, boŋ Nwì à ka ghɨ̀rə annù ma ya fa ghu mbô.” ");
INSERT INTO bfd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ma mùu ajàŋ, mə̀ swoŋ a mbo bù mə, “Ŋ̀gɔ̀ŋ ɨ̀nnǔ tsɨ̀m jìi mə nɨ lɔɔ nɨ a mûm àtsàꞌàtə̀ Nwî aa, nɨ̀ bii mə nɨ̀ kwɛ̀rə̀ mə̂, boŋ Nwì à ka fa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ŋ̀gòŋ bɨ̀nòò bɨ̂tsɨm bìi mə nɨ tə̀ə a ntsaꞌatə Nwì aa, tâ nɨ̀ nliꞌinə ɨfansənnù bə̂ bɨ̂tsɨ̀m bìi mə bɨ fansə ɨnnù a mbo bù aà, tâ tâ Taà ghùù a aburə tâ à kɨ nliꞌinə juu ɨfansənnù.  ");
INSERT INTO bfd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","M̀bə nɨ̀ tsuu ɨfansənnù bə̂ bî mɔꞌɔ kɨ lìꞌìnə̀ boŋ Taà ghùù a aburə kaà m̀bə a waꞌa juu ɨfansənnù kɨ nliꞌinə.” ");
INSERT INTO bfd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bo lɛ mbù ǹzi fu a Yerusalem. Bo zì mə̂, Yesu a ka ŋkarə nɨ a mûm ǹdâmàꞌa Nwì, bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì, nɨ̂ ŋ̀gǎŋndɨꞌɨ nɔ̀ŋsə̀ bo bɨ̀ bɨtà bɨ alaꞌa bo zî ghu mbɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","M̀betə ghu mbo mə, “O ghɨ̀rə ɨnnù juà jìi mə o ghɨ̀rə̀ aa nɨ̂ àdaꞌa wo aa ɛ? A adàꞌà ma yû a mbo wò aa, a fa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu a swoŋ a mbo bo mə, “Mə̀ ka kɨɨ betə ghuu nɨ̂ àbetə̀, bɛɛ mə nɨ̀ fa akwiꞌi a mbo mə̀ boŋ mə̀ ka bɔ̌ŋ swoŋ adɨgə yìi mə mə̀ lɔ̀gə adaꞌa yìi mə mə ghɨ̀rə ɨnnù ma jû ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jɔn à lɛ nlɔ̀gə adaꞌa aa fə a ŋka mmurə bə̌ ŋkì aa ɛ? A lɛ nlò aa mbo Nwì kə̀ a mbo bə̀ aa ɛ? Nɨ̀ kwiꞌi tâ mə̀ yuꞌu.” ");
INSERT INTO bfd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","À bə̀tə̀ mə̂ laà, bo lɔgɨ̀nə̀ ǹtɨgə nswuŋnə bo nɨ bo nswoŋə nɨ mə, “M̀bə bìꞌinə̀ kwiꞌi mə a lo aa a mbo Nwì boŋ à ka betə mə, lâ nɨ̀ tɨgə̀ waꞌǎ annù yìi mə à lɛ sɨ swoŋə bii aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kə̀ m̀bə bìꞌinə̀ swoŋə̀ bə mə, ‘A lo aa a mbo bə̀ lɛ?’” Bo lɛ ŋka mbɔꞌɔ a nswoŋə ma mùu ajàŋ aa nloŋ mə bo lɛ sɨ bɔꞌɔ nɨ bə̀ bya aà. Bə̀ bɨ̀tsɨ̀m bɨ lɛ mbii tsiꞌì ànnù nɨ̂ŋkoŋ mə Jɔn à lɛ mbə aa ŋ̀gàŋntoò Nwì. ");
INSERT INTO bfd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bo tɨgə̀ ŋkwiꞌi a mbo Yesu mə, “Kaa bìꞌì sɨ̀ zî.” Yesu a kɨ̂ ŋ̀kwiꞌi a mbo bo mə, “Kaa mə̀ ka waꞌà ŋû yìi mə̂ à fa adaꞌa mə̀ ghɨrə̀ nɨ̂ ɨ̀nnù jû ghu aa a mbo bù kɨ nswoŋə.” ");
INSERT INTO bfd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu a lɔgɨ̀nə̀ ŋka ŋghaa a mbo bo nɨ mɨ̀ghàà mî nǎnaa nswoŋ mə, “Ŋù yî mɔ̀ꞌɔ à lɛ mbě akò mɨlùꞌû yi, ǹjiꞌi ŋkya ŋkarɨsə ghu, ŋ̀kɨ toŋ nɨgho nɨ nɨ̌ŋ mɨ̀lùꞌù wa mûm ŋ̀kyâ, m̀bɔɔ ndânɨ̀kàŋ yìi bɨ ka kɨ tswe ghu ɨ bɛ nɨ̂ àkò ya aà. À lɛ ntɨgə nlɛnsə akò ya a mbo bə̀, m̀fɛꞌɛ ŋghɛ̀ɛ̀ yi a atoo dàŋ. ");
INSERT INTO bfd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nòò ŋkya mɨ̀ntà mɨ ati mɨ̀luꞌu mya à kùꞌù mə̂ a toò ŋ̀gàŋàfàꞌà yì yî mɔ̀ꞌɔ mə tâ à ghɛɛ ŋkwɛrə mɨ̂ntà mɨ ati mɨlùꞌù mya mi mɔꞌɔ a mbo bɨ̀lɛnsə bɨ akò byâ. ");
INSERT INTO bfd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bo tswâ yi ŋ̀ghɔɔ, ntsyàsə̀ yi a bɨɨ̀ tsiꞌì mbô m̀bô. ");
INSERT INTO bfd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A bû ǹtoo ŋgàŋàfàꞌâ yì yî mɔ̀ꞌɔ, bə̀ bya bɨ ghɔɔ̀ àtû yi nnɨŋ alaꞌa ghu, ǹdɨrɨsə atû yi. ");
INSERT INTO bfd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A bû ǹtoo ŋgàŋàfaꞌâ yi yî mɔꞌɔ, bo zwitə̀ yi. A bû ǹtoo bî mɔꞌɔ bì ghàꞌàtə̀, bɨ kɨ̂ ŋ̀ghɨrə nɨ̂ bo tsiꞌì maa ajàŋ, ŋ̀ghɔɔ bî mɔꞌɔ, ǹzwitə bî mɔꞌɔ̂. ");
INSERT INTO bfd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ŋù yìi mə à lɛ ntɨgə mburə ghu mbo aa, à lɛ ntɨgə mbə aa tsiꞌì mû yì yìi mə a lɛ nnaŋsə ŋkɔŋ kɔ̀ŋ aà. A lɔgə̀ mû yì ma ghû ŋ̀kɨ ntoo a mbo bə̀ bya, nswoŋə nɨ mə, ‘Bo ka bɔꞌɔtə mû ghà ghû’. ");
INSERT INTO bfd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lâ bɨ̀lɛnsə bɨ akò bya bɨ yə̀ mə mû yì wa nswoŋ bo nɨ bo bə mə, ‘Àâ ǹjɨ̂ndâ yì à ghulà mə, nɨ̀ zi bìꞌinə̀ zwitə yi tǎ lɔ̀gə njoò ji tâ ɨ̀ tɨgə mbə jìꞌinə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bo lɛ ntɨgə ntswa mû wa nzwitə yi mmàꞌa a abɛɛ wa njɨ̀m ŋ̀kya mɨlùꞌù. ");
INSERT INTO bfd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu a betə mə, “M̀bə m̀bɔ̂ŋ àkò mɨlùꞌù wa a ghɨrə aa mə akə a nu bə̀ bya lɛ? À ka ghɛ̀ɛ zwitə bɨ̂lɛnsə bɨ akò bya ɨ lɔ̀gə akò mɨlùꞌù ya ɨ fa a mbo bǎdàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kə̀ nɨ̀ lɛɛ̀ ŋ̀waꞌǎ a mûm àŋwàꞌànə Nwì twoŋ mə, ‘Tsiꞌì ŋ̀gɔ̀ꞌɔ̀ ya mə bɨ̀bɔɔ bɨ nda bɨ lɛ ntuu aa, ɨ̀ bə̀ŋ mə̂ ǹtɨgə ŋgɔ̀ꞌɔ̀ nɨ̀buu nɨ nda yì ŋ̀wè; ");
INSERT INTO bfd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","a ma yû ànnù aa a ghɨ̀rə Mmàꞌàmbî, a bə̂ ànnù yî yɛ̌yɛrə a mbo bìꞌì.’’” ");
INSERT INTO bfd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bɨ̀tsyàsə̀ bɨ baYuda bya bɨ yùꞌù mə annù ya mə Yesu à lɛ nswoŋ aa nlɔ̀ɔ̀ a ntswâ yi nloŋ mə bo lɛ nyə mə Yesu a lɛ nnaa nɨghàà nya aa nloŋ ŋgaà yàà, lâ kaa waꞌǎ ajàŋ yìi mə mbə bo tswâ yi aa zî ǹloŋ mə bo lɛ sɨ bɔꞌɔ nnɔ̀ɔ bə̂ wa mə bɨ lɛ ŋghotə ghu aà. Bo lɛ ntɨgə mmaꞌatə yi nlo ŋghɛ̀ɛ̀ waa. ");
INSERT INTO bfd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bɨ lɛ ntoo baFarɨsai bî mɔꞌɔ bo bɨ̀ ŋgǎnjɨ̀m Herod jî mɔꞌɔ a mbɛ̀ɛ Yesu mə ta bo zi ntswa yi nɨ nɨ̀ghàâ ni. ");
INSERT INTO bfd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bo zî ghu mbɛ̀ɛ̀ ǹswoŋ mə, “Ǹdɨ̀ꞌɨ̀nnù, bìꞌì zi mə annù yìi mə o dɨ̀ꞌɨ̀ aa à nɨ̂ ànnù nɨ̂ŋkoŋə̀, kaa waꞌà nɨ̂ ǹsi ŋû liì, ǹloŋ mə kaa ò sɨ abwarə̀ ŋû laŋtə, lâ ǹdɨꞌɨ aa tsiꞌì mânjì yìi mə Nwì a lɔ̀ɔ̀ mə tâ bə̀ ka ntswe ghu aà. A kuꞌunə nɨ nɔ̀ŋsə̀ yìꞌinə̀ a ntu tax a mbo Kaisa kə̀ ŋ̀kàŋ aa ɛ? Bìꞌì ka mmaꞌa tax kə̀ bìꞌì tsuu kɨ màꞌà lɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lâ Yesu a zî àbagɨlə̂ yaa, m̀betə waa mə, “Nɨ lɔ̀ɔ a ŋkwàꞌànə a gha aa a ya aa ɛ? Fâ nɨ̌ ŋkabə̀ silva a mbo mə̀ tâ mə̀ yə lɛ.” ");
INSERT INTO bfd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bo fâ ŋ̀kabə ya ghu mbô, a betə̀ waa mə, “A tswê àtu wo bo bɨ̀ ɨ̀kǔm wo fàa nɨ̂ ŋ̀kabə aa ɛ?” Bo kwiꞌi ghu mbo mə, “Aà yi Kaisa.” ");
INSERT INTO bfd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu a tɨgə̀ ǹswoŋ a mbo bo mə, “Nɨ̀ ka mfa njoo jìi mə à nɨ jî Kaisa aa a mbo Kaisa ŋkɨɨ mfa nɨ̂ ǹjoo jìi mə à nɨ jî Nwî aa a mbo Nwì.” Bo yùꞌù mə̂ ànnù a burə̀ ǹtsya waa tsiꞌì tsyà. ");
INSERT INTO bfd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","BaSadukai bìi mə bɨ swoŋə nɨ mə kaa bə̀ sɨ a nɨwo yweenə aa, bɨ lɛ nzì a mbɛ̀ɛ Yesu, m̀betə yi mə, ");
INSERT INTO bfd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ǹdɨ̀ꞌɨ̀nnù, Moses à lɛ ŋŋwàꞌànə ndɨꞌɨ a mbo bìꞌì mə, m̀bə ǹdɨm ŋù a kwo mmaꞌatə ŋgwɛ̂ yì tɨ bɔɔ, mumaà yì wa a lɔgə̌ ŋgwɛ̂ yì wa jwe bɔɔ bo yu a mbo ǹdɨ̂m yì wâ. ");
INSERT INTO bfd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bɔɔ bɨ ma bi mbâŋnə̀ bɨ lɛ ntswe ghu bi Sàmbaà; yì ǹtsyàmbìì a lɔgə̌ ŋgwɛ̂ yì, ŋ̀ka ŋkwo kaa waꞌa bɔɔ jwî. ");
INSERT INTO bfd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yìi mə à yòŋtə aa a lɔgə̀ mângyɛ̀ wa, lâ ŋ̀kɨ ŋkwo tsiꞌì tɨ̀ bɔɔ; muma yìi mə à lɛ nyweꞌe bitarə aa, à lɛ ŋkɨ nyɔꞌɔ mâŋgyɛ̀ wa, ŋ̀kɨ kwo yìi ŋgaa tsiꞌì tɨ̀ bɔɔ̀. ");
INSERT INTO bfd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bɔɔ bɨ ma bya bi sàmbaa bɨ yɔꞌɔ̀ mâŋgyɛ̀ wa ŋkɨ ŋkwo tsiꞌì bɨ̀tsɨ̀m tɨ bɔɔ̀. Màŋgyɛ̀ wa yu mbɔŋ a yî ŋ̀kɨ ŋkwo yìi ŋgaa a njɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A noò yìi bə̀ ka yǐ yweenə nɨ nɨ̀wo aa tâ màŋgyɛ̀ wa tâ à bə aa ŋ̀gwɛ̂ wò, tsǒ mə bo bya bi sàmbaa bɨ lɛ nyɔꞌɔ yi aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu a kwiꞌi a mbo bo mə, “Nɨ̀ sɨ̀ zi mə nɨ̀ fànsə aa ànnù laà ɛ? Nɨ̀ fànsə̂ ànnù aa nloŋ mə kaa nɨ̀ sɨ̌ annù yìi mə a tswe a mûm àŋwàꞌànə̀ Nwî aa zi, kaa waꞌǎ mɨdaꞌa mɨ Nwî kɨ nzi aà. ");
INSERT INTO bfd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ǹloŋ mə nòò yìi bə̀ ka yǐ bɨ̀ɨ̀nə nɨwo aa, kaa baa yi waꞌà kà nyɔꞌɔ, kaa waꞌà nɨ̀ bàŋgyɛ̀ a ndâ nɨ̀yɔꞌɔ kɨɨ mfa, bɨ ka yǐ bàŋnə bə aa tsǒ baangel a aburə. ");
INSERT INTO bfd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lâ ŋ̀ghɛɛ nɨ̂ ànnǔ nyweenə bɨ̀ku bɨ bə̂, nɨ̀ lɛɛ̀ ŋ̀waꞌǎ adɨgə ya a mûm àŋwàꞌànə Moses, nloŋ atsùgə ɨti ya mə mɔꞌɔ lɛ sɨ khɨ ghu aa, twoŋ aa ɛ? Nwì à lɛ nswoŋ a mbo Moses mə, ‘Mə̀ laa mbə Nwìŋgɔ̀ŋ Abraham, m̀bə Nwîŋgɔ̀ŋ Isaac, ŋ̀kɨ mbə Nwîŋgɔ̀ŋ Yakob.’ ");
INSERT INTO bfd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kaa à laa ŋwaꞌà Nwîŋgɔ̀ŋ bɨ̀ku bɨ bə̂ bə̂. À bə̀ aa Nwîŋgɔ̀ŋ bə̀ bìi bɨ tswe bɨ tɨ̀ɨ̀. Wa nɨ̀ burə mfànsə aa ànnù.” ");
INSERT INTO bfd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ŋ̀gàŋdɨ̀ꞌɨ nɔ̀ŋsə̀ yî mɔ̀ꞌɔ à lɛ ntswe a tɨtɨ̀ɨ bo, ǹyuꞌu ajàŋ yìi mə bo lɛ sɨ ghàà aà. À yə̀ mə̂ mə Yesu à kwìꞌi abetə̀ yaa ya tsiꞌì sɨgɨ̀nə̀ aa, mbetə yi mə, “Ntsyàmbìì ǹdɨ̀ꞌɨ̂ Nwì ɨ̀ bə aa yuu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu a kwiꞌi mə, “Ǹdɨ̀ꞌɨ yì ǹtsyàmbìì ɨ̀ bə aa mə, ‘Nɨ̀ yuꞌu mbâ, baIsrael! M̀màꞌàmbî Nwìŋgɔ̀ŋ yìꞌinə̀, M̀màꞌàmbî à nɨ tsiꞌì yù yu yî m̀fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tɨgə ŋkɔ̀ŋə Mmàꞌàmbî Nwìŋgɔ̀ŋ ghò nɨ̂ ǹtɨɨ̀ ghô tsɨ̀mə̀, nɨ̂ ǹtswêntɨ̀ɨ̂ yô ɨ̀ tsɨ̀m, nɨ mɨ̀tsyɛ̌ mo mɨ̀tsɨ̀m, nɨ mɨ̀dàꞌâ mo mɨ̀tsɨ̀mə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yìi mə ɨ̀ yòŋtə aa, ɨ̀ bə mə, “Tɨgə ŋkɔ̀ŋə̀ a ndɨ̂m ghò tsǒ ɨ̀bɨ̀ɨ nû ghô. Kaa ǹdɨꞌɨ yì dàŋ kaa ɨ̀ sɨ ghu bû ǹtswe mə ɨ̀ tsyàtə ma jû ji baà.” ");
INSERT INTO bfd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ŋ̀gàŋdɨ̀ꞌɨ nɔ̀ŋsə̀ wa a swoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨ̀nnù, Ò swòŋ aa ànnù yìi mə a kuꞌunə̀, Ò swòŋ aa tsiꞌì ànnù nɨ̂ŋkoŋ mə Mmàꞌàmbî Nwìŋgɔ̀ŋ à nɨ aa tsiꞌì yù yu yî m̀fùùrə̀, kaa yì dàŋ kaa a waꞌà ghu bû ǹtswe ntsyatə yi. ");
INSERT INTO bfd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A ŋka ŋkòŋə̀ nìi nɨ̂ ǹtɨɨ̀ ghô tsɨ̀m, nɨ mɨ̀tsyɛ̌ mo mɨ̀tsɨ̀m, nɨ mɨ̀tɨ̀ɨ̂ mo mɨ̀tsɨ̀m, a ŋka ŋkɨɨ ŋkòŋə̀ nɨ̂ ǹdɨ̂m ghò tsǒ ɨ̀bɨ̀ɨ̀ nû gho, a nlə̀ə ǹdɨꞌɨ ma jû, a burə mbɔ̀ŋ ǹtsyatə a mfa nnaà tâ bɨ̀ tɔɔ ɨ tsɨ̀m m̀maꞌa Nwî ghu, kə̌ njoo mmàꞌanwì jî mɔꞌɔ tsiꞌì tsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu à yə̀ mə ajàŋ yìi mə à kwìꞌî sɨgɨ̀nə̀ aa nswoŋ ghu mbo mə, “Kaa àghaꞌa a sɨ̀ bû ǹsaꞌatə a mbo wò a ŋkuu a mûm ànnù nɨfɔ̀ Nwî.” Ǹlɔgɨnə maà noò kaa ŋù tsù kaa a waꞌà bù ǹyweꞌetə a mbetə Yesu nɨ̂ àbetə̀. ");
INSERT INTO bfd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu à lɛ ŋka ndɨꞌɨ nɨ̂ ànnù Nwì a mûm ǹdâmàꞌanwì, m̀betə mə, “m̀bə̂ ŋ̀gǎŋdɨ̀ꞌɨ̂ nɔ̀ŋsə̀ ɨ swoŋ mə Àyɔꞌɔ̀ Nwì à nɨ mu David aa mə akə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Àzwì yî Laa a lɛ ntintə David yumbɔŋ a ghaà swoŋ mə: ‘M̀màꞌàmbi a swoŋ a mbô M̀màꞌàmbî ghà mə: Tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ mə̀ nî màꞌà, ǹyweꞌe a noò yìi mə mə̀ ka yǐ nɔ̀ŋsə ŋgàŋkɨbàâ jò a njiꞌi mɨkòrə̂ wò aà.’ ");
INSERT INTO bfd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“M̀bə David yumbɔŋ a ka ntwoŋə yi nɨ̂ M̀màꞌàmbi, a tɨgə̀ m̀bu ntsyà aa la mbə mu David aa ɛ?” Àkùrə̀ bə̂ yî ghàꞌà ŋ̀ghaꞌa yìi mə a lɛ bòòntə̀ a mbɛ̀ɛ Yesu aa a lɛ ŋkɔ̀ŋ a nyuꞌu ànnù yìi mə à lɛ sɨ swoŋə aà. ");
INSERT INTO bfd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu à kà mə̂ aa ndɨꞌɨ nɨ̂ ànnù Nwî a mbo bo, ǹswoŋ mə, “Nɨ̀ ka ntsyɛsə ghuu nloŋ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀; bo kɔ̂ŋə̀ nɨ̂ ŋ̀wɛ̀ꞌɛ̂ ǹdàŋə ɨtsə̀ꞌə̀ ŋ̀karə nɨ ju, ŋ̀kɨɨ ŋkɔŋə nɨ mə tâ bə̀ ka ntsaꞌatə nɨ̂ waa nɨ àghuꞌusə̀ a mɨtaa. ");
INSERT INTO bfd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bo kɨɨ ŋkɔŋə nɨ̂ ǹtswe nɨ̂ ɨ̀lə̀ŋ jìi mə ɨ tswe a mbìì a mûm ǹdâŋghòtə aà, ŋ̀kɔŋə nɨ̂ ǹtswe a nɨ̂ ɨ̀lə̀ŋ jìi ɨ kɔꞌɔnə aa a ɨdɨgə àdina. ");
INSERT INTO bfd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bo nɨ̀ꞌɨ̀ nɨ bɨ̀Kwìꞌì bɨ bâŋgyɛ̀, ŋ̀kwɛrə nɨ̂ ǹjoò jyaa nɨ mɨ̀laꞌà myaa, m̀bagɨlə ntsaꞌatə nɨ̂ Nwî nɨ̂ ǹdaŋə mɨghàà. Wâ ŋ̀gɨꞌɨ yìi ɨ̀ ka yǐ kuu a nu bo aa ɨ̀ ka yǐ swèrə̀!” ");
INSERT INTO bfd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu à lɛ ntswe a mbɛ̀ɛ̀ ŋ̀kòm ǹnɨ̌ŋ ŋkabə̀ ǹtsàꞌàtə Nwì, ǹlii nɨ̂ àjàŋ yìi mə bə̀ lɛ sɨ nɨŋə nɨ̂ ŋ̀kabə wa mûm ŋ̀kom aà. Ŋ̀gǎŋkabə jì ghàꞌàtə̀ ɨ lɛ sɨ nɨŋə nɨ̂ ŋ̀kabə yì ŋ̀wè wa mûm ŋ̀kòmə̀. ");
INSERT INTO bfd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ŋ̀kwìꞌi màŋgyɛ̀ yî mɔ̀ꞌɔ yìi mə à lɛ mbə ŋgàŋàfùm aa, à lɛ nzì ǹnɨŋ ɨbàꞌatə ŋkabə copper ji baà, ǹdùû yi ɨ bə tsǒ kabà yî m̀fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu a twôŋ ŋ̀gǎŋyəgə̂nnù ji bo zî ghu mbɛ̀ɛ̀, a swoŋ a mbo bo mə, “Mə̀ swòŋ a mbo bù tsiꞌì ànnù nɨ̂ŋkoŋ mə ŋ̀kwìꞌi màŋgyɛ̀ ghû mə à nɨ ŋgàŋàfum aa, à nɨ̌ŋ ŋkabə fàa mûm ŋ̀kòm ǹtsyatə bə̂ bɨ̀tsɨ̀m bìi mə bɨ maꞌà ŋ̀kabə̀ ǹtsàꞌàtə Nwì ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ŋ̀loŋ mə bo swatə aa tsiꞌì mûntsirə̀ a nɨ̂ ŋ̀kabə yìi bo luu nɨ yu aa mmaꞌa Nwî ghu, lâ màŋgyɛ̀ ghû mə à nɨ ŋgàŋàfum aa, à kɔ̀ɔ̀ntə aa ŋ̀kabə̀ ǹtsɨ̀m yìi mə à tswe nɨ yu aa mfa, à sɔ̀rətə aa ǹdâ yì.” ");
INSERT INTO bfd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji bo kà mə̂ aa mfɛꞌɛ wa ndâmàꞌa Nwì, ŋ̀gàŋyə̀gə̂nnù yì wa yì mɔ̀ꞌɔ a swoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨ̂nnù, yə ajàŋ yìi mə ŋgɔ̀ꞌɔ̀ jù ɨ burə mbɔ̀ŋ m̀bɔŋ ŋghɨrə nda jìi mə bɨ bɔɔ ghu aa ɨ kɨ mbɔŋ mbɔ̀ŋə̀!” ");
INSERT INTO bfd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu a swoŋ ghu mbo mə, “Ò yə ǹda jì wè jî wè jû? Kaa tsiꞌì ŋ̀gɔ̀ꞌɔ̀ yî m̀fùùrə̀ kaa ɨ̀ ka yǐ waꞌà a atu yì mɔ̀ꞌɔ bû nɔŋə. Bɨ ka yǐ sàꞌà tsiꞌì tsɨ̀m màꞌànə a nsyɛ̂.” ");
INSERT INTO bfd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A kɔꞌɔ ŋghɛ̀ɛ̀ ǹtswe nsyɛ a atu ntaꞌa Olive, mə ɨ tswe nlìì nɨ̂ ǹdâmàꞌanwì aa, Peta nɨ Jɛms, nɨ Jɔn, a bɔ̀ꞌɔ nɨ Andrew, bo betə̀ Yesu a noò yìi mə à lɛ ntɨgə ntswe tsiꞌì bo bo aa mə, ");
INSERT INTO bfd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Naŋsə nwoŋ tâ bìꞌì yuꞌu, ɨ̀nnù ma jû ɨ ka yǐ fɛ̀ꞌɛ̀ aa a noò àkə̀ aa ɛ? Àlènsə̀ yìi mə a ka yǐ dɨ̀ꞌɨ̀ mə nòò à kùꞌù mə̂ a nyə ɨnnù ma jû aa a nɨ aa akə̀ ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu a lɔgɨ̀nə̀ ŋ̀ka nswoŋə nɨ a mbo bo mə, “Nɨ̀ ka ntsyɛsə ghuu tsee lǒ lə̀ə̀ tâ ŋù tsù à m̀bweꞌesə ghuu. ");
INSERT INTO bfd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bə̀ bî ghàꞌàtə̀ bɨ ka yǐ zì nɨ̂ ɨ̀kǔm ghâ, ɨ kɨ swoŋə nɨ mə, ‘Mə̀ nɨ yu!’ ɨ bweꞌesə nɨ̂ bə̀ bì ghàꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bɛɛ mə nɨ̀ yuꞌu mə bɨ màꞌa ntsò, kə̀ bɛɛ mə nɨ̀ yuꞌu fɨswoŋ nloŋ ntsò, nɨ̀ tsuu kɨ bɔꞌɔ bə̂. Ma juù ɨ̀nnù ɨ tswe nɨ̀ m̀fɛ̀ꞌɛ̂, la kaa a waꞌà bəə mə nòò ǹlwìꞌî m̀bi wa à kùꞌù mə̂. ");
INSERT INTO bfd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɨ̀too ɨ ka yǐ kɨ màꞌa ntsò bo bɨ̀ jǐ mɔꞌɔ, tâ ɨ̀too jìi mə bɨfɔ̀ buꞌutə aa tâ ɨ̀ kɨ ŋka maꞌanə bo bɨ̀ jǐ mɔꞌɔ̀. Ǹsyɛ̂ ɨ̀ ka yǐ kɨ tsɨ̀gɨ̀nə̀ a ɨdɨgə ɨdɨgə, tâ mɨ̀kwenə̀ tâ à kuu alaꞌà. Kaa ma juù ɨ̀nnù kaa ɨ ka yǐ waꞌà kà ǹdɨꞌɨ aa mə nòò ŋ̀gɨꞌɨ à mɛ̀ mə̂, ŋ̀gɨꞌɨ mà yû ɨ̀ ka yǐ bə aa tsǒ ajàŋ yìi maburə̀ à lɔ̀gɨ̀nə a nyuꞌu nyaŋə a noò yìi à tsɨ̀gə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nɨ̀ ka ntsyɛsə nɨ̂ ghuu nloŋ mə bɨ ka yǐ kɨ tswatə nɨ̂ ghuu fa nɨ a mbo ŋ̀gǎŋsaꞌa mɨ̀saꞌa; ɨ kɨɨ ghɔ̀ɔ̀ nɨ̂ ghuu a ndâŋghotə̀. Nɨ̀ ka yǐ ghɛ̀ɛ təə a nsi bɨ̀gûmnàà bo bɨ̀ bɨ̀fɔ̀ ǹloŋ ŋgaa yà, ɨ swoŋ annû yâ a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lâ m̀bɔŋ tâ nòò ǹlwìꞌi mbî à kuꞌu, bɨ tswe nɨ̂ m̀fòo nswoŋ ntoo yì ǹsɨgɨ̀nə̀ ya a mbo ɨtoò tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bɛɛ mə bɨ yi ntswa ghuu ŋghɛɛ nɨ bù a nsi ŋgǎŋnsaꞌa mɨ̀saꞌa, nɨ̀ tsuu kɨ waꞌa nɨ̂ ànnù yìi mə nɨ̀ ka ghɛɛ swoŋ aà. Bɛɛ mə nòò ŋ̀ghàa a kuꞌu, nɨ̀ swoŋ ànnù yìi mə a zi a atu bù aà, ǹloŋ mə kaa à sɨ bu swoŋə, a swoŋə nɨ̂ Àzwì Nwî. ");
INSERT INTO bfd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ŋù à ka yǐ kɨ fa nɨ̂ mumaà yì mə bɨ̀ zwitə, tâ tà à ka mfa nɨ mû yì mə bɨ̀ zwitə, tâ bɔɔ bɨ̀ bɨɨnə ntswatə bɨ̂taà byaa bo bɨ̀ bɨ̀maà byaa nɨ̂ ɨ̀saꞌa, ɨ lɔ̀gə̀ waa fa mə bɨ̀ zwitə. ");
INSERT INTO bfd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bə̀ bɨ̀tsɨ̀m ka yǐ kɨ bàà ghuu nloŋ ɨkûm ghâ. Lâ ŋù yìi mə a tswa ntɨɨ̀ yi mbii ŋgɨꞌɨ nyweꞌe a nlwìꞌì aa, à ka yǐ yweenə. ");
INSERT INTO bfd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Lâ bɛɛ mə nɨ yi nyə annù yî swèrə̀ ǹswerə ya a tswe a adɨgə yìi mə a sɨ̀ nɨ̂ ǹtswe ghu tswe aa, (tâ ŋù yìi mə a twoŋ annù yuà aa tâ naŋsə nyuꞌu nzi,) tâ bə̀ bìi mə bɨ tswe a alaꞌa Yudea aa bɨ̀ fɛꞌɛ ŋkhə̀kə̀ ŋ̀kɔꞌɔ ŋghɛɛ a ɨtu mɨ̂ntaꞌà. ");
INSERT INTO bfd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tâ ŋù yìi mə à tswe a atu nda aa tâ à tsuu lǒ bǔ sɨgə, tâ à tsuu a nda yu a nlɔ̀gə̂ àyoò tsu bǔ kuu bə̂. ");
INSERT INTO bfd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tâ ŋù yìi mə à tswe a mûm ǹsòò aa tâ à tsuu bǔ bɨ̀ɨ̀ a nlɔ̀gə̂ àkutə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wɛɛ! Ŋ̀gɨꞌɨ̀ bɨ̀maburə̀ bi atoꞌo bo bɨ̀ yì bìi mə bɨ nɔŋsə bɔɔ maa nɨ̂ ǹjwi ma jya aà! ");
INSERT INTO bfd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nɨ̀ ka ntsaꞌatə nɨ̂ Nwî mə tâ ɨ̀nnù ma jû ɨ̀ yi ntsuu fɛ̀ꞌɛ̀ a noò m̀fəꞌə̀. ");
INSERT INTO bfd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ǹloŋ mə ŋgɨꞌɨ yìi mə ɨ̀ ka yǐ tswe maa noò aa ɨ̀ ka yǐ tsyàtə̌ ŋgɨꞌɨ̀ ǹtsɨ̀m yìi mə ɨ̀ lɛɛ̀ m̀fɛꞌɛ nlɔ̀gɨ̀nə̀ a noò yìi mə Nwì à lɛ nnaŋsə mbi yu aa ɨ kɔꞌɔ yweꞌe tsɨ̂tsɔ̀ŋə̀. Kaa yì dàŋ ɨ̀ ka yǐ waꞌà bù m̀fɛꞌɛ tsǒ ma yû. ");
INSERT INTO bfd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lâ Nwì à kwyɛ̀tə̀ mə ndùu njwi mà jû ǹloŋ ŋkwitu bə̂ bi bìi mə à tsɔꞌɔ aà. A sɨ̀ laa bə boŋ kaa ŋù tsù à ka yǐ waꞌà yweenə̀. ");
INSERT INTO bfd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“M̀bə ŋù a zi tɨ swoŋə a mbo bù mə, ‘Yə̂, Àyɔꞌɔ̀ Nwì wa à ghuà!’ kə̀ ‘Yə̂, à wiì!’ nɨ̀ tsee annù yìi a swoŋ aa lǒ bii. ");
INSERT INTO bfd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ǹloŋ mə bÀyɔꞌɔ̀ Nwì bɨ mbweꞌesə̀ bo bɨ̀ ŋ̀gǎŋntoo Nwi mbweꞌesə̀ ɨ ka yǐ fɛ̀ꞌɛ ɨ kɨ ghɨ̀rə̀ nɨ̂ ɨlensə ɨnnù bo bɨ̀ ɨ̀nnǔtsyâmbo a mbweꞌesə bə̀ ghu, ɨ tɛꞌɛ kɨ yweꞌetə nɨ a mbweꞌesə tsiꞌì bə̀ bii mə Nwì à tsɔ̀ꞌɔ aà. ");
INSERT INTO bfd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nɨ̀ tɨgə ŋka ntsyɛsə ghu; wa mə̀ swòŋ mə ɨnnù tsɨ̀m a mbo bù m̀bɔŋ tâ nòò ma wa à kuꞌu. ");
INSERT INTO bfd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“À ka yǐ bə nɨ a njɨ̀m, a nɨ̂ ǹjwi jìi mə ɨ ka yǐ kɨ yòŋə̀ noò ŋ̀gɨꞌɨ wa aa, ta nɨ̀nòò à fii, kaa tâ sàŋ à waꞌà bù ka nta. ");
INSERT INTO bfd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tâ mɨ̀njɔ̀ŋ mɨ̀ ka nlo nɨ a aburə ŋ̀wokə nɨ a nsyɛ̂, tâ bɨ̀ tsɨgə ɨdaꞌa tsɨ̀m jìi ɨ tswe a aburə aà. ");
INSERT INTO bfd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Maa noò tâ bɨ̀ tɨgə nyə Mu Ŋù tâ à ka nzi nɨ a mûm m̀bàꞌà nɨ mɨ̀dàꞌà mî wè nɨ nɨ̀ghàꞌà. ");
INSERT INTO bfd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bɛɛ a sɨgə, a tɨgə̀ ǹtoo baangel bi a nɨ̂ m̀bɛ̀ɛ mbi ji nɨkwà mə tâ bo ghɛɛ ŋghotə bə̂ bi bìi mə à tsɔ̀ꞌɔ̀ aa, ǹlɔgɨnə a mbɛ̀ɛ̀ m̀bî yì mɔ̀ꞌɔ ŋghɛɛ nlwìꞌìsə nɨ yì mɔ̀ꞌɔ̂. ");
INSERT INTO bfd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Tâ nɨ̀ yəgə annù a nɨ àtǐ fig. A yi mbə noò yìi mə ntaà ji ɨ fìꞌìsə̀ mə ɨyə̀ŋ jî fii aa, nɨ̀ zi mə nòò ǹtsû m̀bə̀ŋ à tɨ̀gə a abô ");
INSERT INTO bfd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A kɨ̂ m̀bə nɨ a ŋgɨ̌ŋ ŋgɨ̀ŋ mə, nɨ̀ bə yə tâ ɨ̀nnù juà ɨ̀ ka mfɛꞌɛ, nɨ̀ zi mə à zì mə̂ ŋkoontə, ǹtɨgə aa tsiꞌǐ a ntsǔbùꞌù. ");
INSERT INTO bfd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mə̀ swǒŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, kaa nɨ̀wàà nɨ bə̂ nuà nɨ ka waꞌà tsyà tɨ̀ ghə mə ɨ̀nnù ma jû tsɨ̀m ɨ fɛ̀ꞌɛ̀ mə̂. ");
INSERT INTO bfd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Àbùrə̀ bô ǹsyɛ ka yǐ tsyà, lâ kaa tâ nɨ̀ghaâ na nɨ̀ waꞌà tsyà. ");
INSERT INTO bfd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kaa ŋù tsù à sɨ̌ njwi kə̀ nòò wa zî, kaa tsiꞌì baangel bìi bɨ tswe a aburə aa, kə̀ Mû. A kɨ nzi tsiꞌi Tà yuyu. ");
INSERT INTO bfd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nɨ̀ ka ntsyɛsə nɨ̂ ghuu, ŋka ntswe nɨkərə̀ ǹloŋ mə kaa nɨ̀ sɨ̀ noò ma wa zi aa. ");
INSERT INTO bfd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","À bə aa tsǒ ŋù à fɛ̀ꞌɛ mə yu ghɛ̀ɛ̀ a nɨghaa, à kà mə̂ aa mfɛꞌɛ, ntwoŋ ŋgǎŋəfàꞌâ ji mfa ɨfàꞌà yìi mə bo ka kɨ fàꞌà aa, a mbo bo yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ, ǹswoŋ a mbô ŋ̀gàŋmbɛ̂ ǹtsǔnda mə ta à tswe tsiꞌǐ nɨkərə̀ ŋ̀ka mbɛ nìi. ");
INSERT INTO bfd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","A bɔŋ mə tâ nɨ̀ tswe nɨkərə̀ ŋ̀ka mbɛ nɨ̂ m̀bɔ̂ŋ ǹdùgə̀ ǹloŋ mə kaa nɨ̀ sɨ̀ noò yìi mə à ka yǐ bɨ̀ɨ̀ ghu aa zi aà. M̀bə a tse bə a noò ŋ̀kwɛ̂fɔ̀, nɨ̂ ǹtɨ̀ɨ̂ ɨ̀tugə, nɨ nòò ǹjwi, kə̀ a tɨ̀tugə̀. ");
INSERT INTO bfd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ta bɛɛ mə à buꞌunə nzi, kaa a waꞌà zì ǹyə mə nɨ bwii. ");
INSERT INTO bfd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ànnù yìi mə mə swoŋə a mbo bù aa, à kɨ mbə yìi mə mə swoŋə nɨ a mbo bə̀ bɨ̀tsɨ̀mə̀: ‘Nɨ̀ ka ntswe nɨkərə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A lɛ ntɨgə mburə njwi ji baa mbɔŋ tâ ǹjwi Passa bo bɨ̀ ǹjwî ǹjɨ̂ àbaa tɨ kɔꞌɔ̀ ɨ̀ kuꞌu. Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwi bo bɨ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ bo lɛ ŋka nlɔɔ nɨ ajàŋ yìi mə mbə bo ŋeꞌesə̀ ntswa Yesu ghu nzwitə. ");
INSERT INTO bfd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bo lɛ sɨ̀ swoŋə nɨ mə, “A bɔŋ mə tâ bìꞌinə̀ tsuu ma yuù ànnu fàa njwi Passa ghɨ̀rə̀ ǹloŋ mə mbə bìꞌinə̀ tswa yi boŋ fɨ̀kɔ̀rə̀ ka fɛ̀ꞌɛ̀ a tɨtɨ̀ɨ bə̀ ɨ bùùrə ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu a lɛ ntswe a Bethany a nda Simon yìi mə à lɛɛ̀ m̀bə ŋùkɨ̀kwen aa ŋka njɨ. À kà mə aa njɨ, màŋgyɛ̀ yî mɔ̀ꞌɔ a zi nɨ mɨ̀ghurə mì lùmtə̀ mɨ atɨ̀ndùù mìi mə mɨ lɛ naŋsə mbə tsiꞌì mì narda aa, a nɨ̂ ǹtsɨ̂ŋ ŋ̀gɔ̀ꞌɔ̀ alabasta. À zì mə̂, ǹzwi mɨghurə mya ntswentə nyɔꞌɔ atu Yesu ghu. ");
INSERT INTO bfd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mɨ̀ntɔ̀ŋ mɨ bə̂ bǐ mɔꞌɔ bìi mə bɨ lɛ ntswe ghu aa, mɨ lwînə̀, bo tɨgə̀ m̀betə nɨ̂ waa bo nɨ bo mə, “À nàŋsə nta ŋgɨꞌɨ nɨ mɨ̀ghurə mù laà aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ǹloŋ mə mbə bɨ feè mɨ̀ghurə ma mû ǹdùû yi tsyâtə̌ ɨbaꞌatə ŋkabə silva ŋkhɨ̀ ji tarə bɨ lɔgə̀ ŋ̀kabə ya mfa a mbo ŋ̀gàŋə̂fumə.” Bo ghaàntə̀ mâŋgyɛ̀ wa mfa afɨ̀rə̂ yi. ");
INSERT INTO bfd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","La Yesu a swoŋə a mbo bo mə, “Nɨ maꞌatə yi; nɨ fa ngɨꞌɨ a mbo màŋgyɛ̀ ghû aa a ya aa ɛ? Nɨ̀ sɨ̀ zi mə à ghɨ̀rə aa ànnù yî sɨgɨ̀nə̀ a nu mə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋ̀gàŋə̂fumə ɨ tswe a tɨtɨ̀ɨ bù aa bɨ̀nòò bɨtsɨ̀mə̀, m̀bə nɨ tse kwɛtə waa a noò yìi mə nɨ̀ kɔ̀ŋə aà, lâ kaa mə̀ ka waꞌǎ tɨtɨ̀ɨ bù aa a ŋgɔ̀ŋ bɨ̀nòò bɨtsɨ̀m tswê. ");
INSERT INTO bfd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","À ghɨ̀rə aa annù yìi mə mbə a ghɨrə̀. À yɔ̀ꞌɔ gha nɨ̀ mɨ̀ghurə mù, ǹnaŋsə aa nû ya mbɔŋ tâ nòò ǹtwìŋə̂ ghà à kuꞌu. ");
INSERT INTO bfd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mə̀ swǒŋ a mbo bù tsiꞌì ànnù nɨ̂ŋkoŋ mə, a nɨ̂ ŋ̀gɔ̌ŋ ɨdɨ̀gə tsɨ̀m jìi mə bɨ ka yǐ kɨ swoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ yû ghu fàa mbi aa, bɨ ka yi kɨɨ kɨ swoŋə nɨ̂ ànnù yuà mə màŋgyɛ̀ ghuà à ghɨ̀rə a nu mə̀ aà, ŋ̀waꞌatə nɨ̂ yi.” ");
INSERT INTO bfd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariot, mə lɛ mbə ŋù yì mɔꞌɔ a tɨtɨ̀ɨ̂ ŋgǎŋyəgə̂nnu Yesu jya nɨ̀ghûm ǹtsò baa aa, à lɛ nghɛ̀ɛ̀ a mbɛ̀ɛ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì a mfèe Yesu a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bo lɛ mburə ndorɨtə a nyuꞌu annù yìi à lɛ nzǐ a nswoŋə a mbo bo aa, mbii mə bo ka fa ŋkabə ghu mbô. Judas a tɨgə̀ ǹlɔɔ nɨ mânjì yìi mə mbə yu tsyâ ghu mfee Yesu. ");
INSERT INTO bfd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A bə a njwi yì ǹtsyàmbìì, a njwî ǹkurə̂ àbaa tɨ kɔꞌɔ a noò yìi mə bɨ wà nɨ̂ mû m̀bînjə̀rə Passa aa, ŋ̀gǎŋyəgə̂nnù Yesu bo betə ghu mbo mə, “O lɔ̀ɔ mə bìꞌì ghɛɛ naŋsə aa yuu adɨgə a mbo wò tâ ò jɨ mɨjɨ mɨ Passa ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A toò ŋ̀gǎŋyəgə̂nnù ji ji baa nswoŋə a mbo bo mə, “Nɨ̀ kuu ŋghɛɛ a mûm àlaꞌa, boŋ nɨ̀ ka yə ŋû m̀bâŋnə̀ yî mɔ̀ꞌɔ yìi mə a bèꞌe àntɔ̀ɔ̀ ŋ̀kì aa tâ zi ntsiꞌi ghuu. Bɛɛ a zi ntsiꞌi ghuu, ");
INSERT INTO bfd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","nɨ̀ kâ ǹyoŋə nìi ŋghɛɛ ŋkuu a nda yìi mə a kùu ghu aà, ǹswoŋə a mbo mbɔ̂ŋ ǹda wa mə, ‘Ǹdɨ̀ꞌɨ̀nnù à bètə mə, ǹjaꞌà ǹda yìi mə bìꞌi bɨ̀ ŋ̀gǎŋyəgə̂nnù ja ka jɨ Passa ghu aa ɨ̀ fə̀ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Boŋ à ka dɨ̀ꞌɨ njaꞌà ǹda yì ŋ̀wè yî mɔ̀ꞌɔ a ndəŋ bɨ nɨ̂ŋ ǹjoo ghu mum ŋkɨ naŋsə aa a mbo bu. Bɛɛ a dɨꞌɨ, nɨ̀ tɨgə̀ naŋsə njoo jìi mə bìꞌinə ka ghɨ̀rə jɨ Passa ghu aa ghu.” ");
INSERT INTO bfd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ŋ̀gǎŋyəgə̂nnu Yesu jya ghɛɛ̀ wa mûm àlaꞌa nyə a bə tsiꞌì maa ajàŋ mə à swòŋə aa, ǹtɨgə naŋsə njoo njɨ Passa jyâ. ");
INSERT INTO bfd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nòò ŋ̀kwɛ̂fɔ̀ à kùꞌù mə̂ Yesu a ghɛɛ̀ ghu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji jyâ. ");
INSERT INTO bfd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bo ghɛ̀ɛ ǹtswe ŋka njɨ atu atɛtə̀. Bo kà maa njɨ, Yesu a swoŋ mə, “Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋ mə ŋù yî mɔ̀ꞌɔ a tɨtɨ̀ɨ bù à ka ghɨ̀rə fèè ghâ, ŋù ma ghû a jɨ biꞌi yu.” ");
INSERT INTO bfd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bo lɔgɨ̀nə̀ ǹtɨgə njəŋnə, mbetə yî mɔꞌɔ yî mɔꞌɔ mə, “À nɨ mə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A swoŋə a mbo bo mə, “À nɨ̀ ŋù yî mɔ̀ꞌɔ a tɨtɨ̀ɨ bù nɨghûm ǹtsò baa mə a tsùtə̌ abaa bìꞌi yu a mûm àkaŋ yì fùùrə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Lâ ànnù ma yû a ka yə Mu ŋù aa tsiꞌǐ ajàŋ yìi mə bɨ ŋwaꞌanə a mûm àŋwàꞌànə Nwì ǹloŋ ŋgaà yì aà. Ŋ̀gɨꞌɨ yì swèrə̀ ǹswerə a nu ŋù yìi mə à fèe a Mu Ŋù aà! A lɛ mbaa mbɔ̀ŋ mə bɨ̀ tsee ajàŋə̀ ŋû ma yû lǒ burə jwe jwe bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bo kà maa njɨ, Yesu a lɔgə̀ àbaa, mfa mbɨꞌɨkə a mbo Nwì, m̀batə mfa a mbo bo, ǹswoŋə mə, “Kǒ nɨ̀; à nɨ̂ ɨ̀bɨ̀ɨ nû gha ghuà.” ");
INSERT INTO bfd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A kɨ̂ ǹlɔgə ndɔ̂ŋ mɨ̀lùꞌù, m̀fa mbɨꞌɨkə a mbo Nwì, m̀fa a mbo bo, bo bɨtsɨ̀m nô. ");
INSERT INTO bfd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bô nò mə̂, a swoŋə a mbo bo mə, “À nɨ̂ àləə nû ya â yuà, àləə ŋwàrə̂ àkàà yìi mə bɨ ka saansə atu bə̀ bî ghàꞌàtə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə kaa mə̀ ka yǐ waꞌa mɨlùꞌù bû ǹno, nyweꞌe a njwi yìi mə mə̀ ka yi bǔ no mɨ̀luꞌu mî fii a mûm ànnù nɨfɔ̀ Nwî aà.” ");
INSERT INTO bfd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bo yəə̀ ɨ̀kòò ǹtɨgə m̀fɛꞌɛ ŋkɔꞌɔ ŋghɛɛ a atu ntaꞌa Olive. ");
INSERT INTO bfd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu a swoŋ a mbo bo mə, “Bù tsiꞌì bɨ̀tsɨm, nɨ̀ ka ghɨ̀rə màꞌàtə̀ gha khə̀kə̀, ǹloŋ mə a tswe a mûm àŋwàꞌànə̀ Nwî mə, ‘Mə̀ ka zwitə ntsèèmbi tâ m̀bînjə̀rə̀ jya ɨ̀ jaꞌanə.’ ");
INSERT INTO bfd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lâ nòò yìi mə mə̀ ka yǐ yweenə nɨ nɨ̀wo aa, mə̀ ka yǐ tsyǎ a mbìi bù fòo ghɛ̀ɛ̀ a Galilea.” ");
INSERT INTO bfd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peta a swoŋ ghu mbo mə, “M̀bə bə̀ bɨtsɨm tɛꞌɛ kɨ màꞌàtə̀ nɨ̂ gho màꞌàtə ŋkhə boŋ kaa mbə mə̀ waꞌà gho màꞌàtə̀ bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu a kwiꞌi ghu mbo mə, “Mə̀ swǒŋ a mbo wò tsiꞌì ànnù nɨ̂ŋkoŋ mə, tsiꞌì nɨ̀tugə sìi, mbɔŋ tâ àŋkə̀gə̀ tâ à tɔŋ ŋgaa ji baa, boŋ ò tùù mə̂ ghâ ŋ̀gàà ji tarə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lâ Peta a swoŋ ghu mbo nɨ̀tɨ̀ɨ̀ mə, “À tɛ̀ꞌɛ kɨ bə bə̂ ànnù nɨwo boŋ mə̀ ka kwo biꞌò; kaa mbə mə̀ waꞌà gho tuù.” Ŋ̀gǎŋyəgə̂nnù Yesu jya tsɨ̀m bo lɛ ŋkɨ nswoŋ tsiꞌì maa ajàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bo lɛ ŋghɛ̀ɛ̀ ŋ̀yweꞌe a adɨgə yî mɔꞌɔ yìi mə bɨ lɛ sɨ twoŋə nɨ Getsemane aa, Yesu a swoŋə a mbo ŋ̀gǎŋyəgə̂nnù ji mə, “Nɨ̀ tswe faà tâ mə̀ ghɛɛ ntsàꞌàtə̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ǹlɔgə Peta nɨ Jɛms a bɔꞌɔ Jɔn mə tâ bo bo ghɛɛ, nû yì ɨ lɔgɨ̀nə̀ ŋ̀ka mbɨꞌɨ, ǹtɨɨ̀ yi ɨ luu nɨ̀ àjəŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A swoŋə a mbo bo mə, “Àjəŋnə̀ a luu a ntɨɨ mə̀ siꞌi mburə mbə tsiꞌì a nzwitə mə̀; nɨ̀ tswe faà mə, ǹtswe nɨkərə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A ghɛ̂ntə̀ a mû ǹtsirə̀, ŋ̀wo a nsyɛ ntsaꞌatə Nwî ǹswoŋ mə, mbə mânjì a tswe ghu a ghɨrə̀ nòò ŋgɨꞌɨ ma wa a tsyâ tâ yù waꞌà lò ǹyə. ");
INSERT INTO bfd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ǹswoŋ mə, “Abba, Taà ghà, m̀bə Ò ghɨrə̀ ɨ̀nnù tsiꞌì tsɨ̀mə̀, ghɨ̀rə mə tâ mə̀ tsuu ndɔ̂ŋ ŋ̀gɨꞌɨ yuà mə no; lâ mə kɔ̀ŋ aa a ŋghɨ̀rə tsiꞌì ànnù yìi mə o lɔ̀ɔ̀ aà, kaa waꞌà bə à yìi mə mə lɔ̀ɔ̀ aa bə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","À lò mə̂ m̀bɨɨ, nyə waa bo bwiì, a betə̌ a mbo Peta mə, “Nɨ bwii aà bwìì, Simon? M̀bə nɨ̀ waꞌà nɨkərə̀ a nɨ àbàŋtə̀ noò yî fùùrə̀ tswê aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nɨ̀ ka ntswe nɨkərə̀ ǹtsaꞌatə nɨ̂ Nwî tǎ waꞌǎ ŋkɨ̀rə̀ Satan lô ŋ̀wo. Ǹtɨɨ̀ ghuu ɨ lɔ̀ɔ ŋghɨ̀rə annù yìi mə a kuꞌunə aa lâ ǹjyǎ nû yùù ɨ bâŋnə̀ m̀bɔrə.” ");
INSERT INTO bfd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A bû ǹlo ŋghɛ̀ɛ̀ a ntsàꞌàtə Nwì ŋ̀kɨ mbu nswoŋ tsiꞌì ànnù ya mə à lɛ mfòò ǹswoŋ a mbìì aà. ");
INSERT INTO bfd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A bû m̀bɨɨ ŋghɛ̀ɛ̀ ǹyə ŋgǎŋyəgə̂nnù ji jya ɨ burə̀ kɨ bwii tsiꞌì bwìì ǹloŋ mə fɨ̀lo lɛ nluu a miꞌi bo aà; kaa bo waꞌǎ annù yìi mbə bo swoŋə ghu mbo zî. ");
INSERT INTO bfd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","À bù mə̂ mbɨɨ nɨ̂ ŋ̀gàà yìi mə ɨ̀ yweꞌe ji tarə aa nswoŋ a mbo bo mə, “Nɨ̀ bùrə ka kɨ bwii tsiꞌì bwìì, m̀mɨɨntə nɨ̂ ghuu aa ɛ? Wa â kùꞌù mə̂ lâ; nòò à kùꞌù mə̂; bɨ fèè mə̂ Mu Ŋù a mbo bə̀ bî bɨ̂. ");
INSERT INTO bfd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nɨ̀ bɨɨnə tâ bìꞌinə̀ ghɛɛ. Yə̂ nɨ̀, wa ŋù yìi mə à fèe gha aa à zì mə̂.” ");
INSERT INTO bfd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu à kà mə aa ŋghaa laà, kaa mburə tɨ màŋsə̀, Judas, ŋù yì mɔ̀ꞌɔ wa atɨtɨ̀ɨ ŋgǎŋyəgə̂nnù Yesu jya nɨ̀ghûm ǹtsò baa, a burə̀ ǹzi bo bɨ̀ ǹnɔ̀ɔ̀ bə̂ mə bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwi nɨ̂ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ bɨ̀tà bɨ alaꞌa bo lɛ ntoo. Bo lɛ ntugɨtə nwi ntsò nɨ mɨ̀buꞌù. ");
INSERT INTO bfd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, yìi mə à lɛ mfèè yi aa, à lɛ mfa alènsə̀ a mbo bo mə, “Ŋù yìi mə mə̀ ka ghɛ̀ɛ nɔŋ mɨghə̀gə̂ mi aa, boŋ à nɨ ghu. Nɨ̀ baŋnə̀ yi; ǹlɔgə ŋghɛ̀ɛ̀ nɨ ghu. Bɛɛ nɨ̀ tɨ ghɛ̀ɛ, nɨ̀ naŋsə̀ m̀bɛ yi.” ");
INSERT INTO bfd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","À zì mə̂, m̀burə ntsya ŋghɛ̀ɛ̀ ghu mbɛ̀ɛ̀ ǹnɔŋ mɨghə̀gə̂ mi, ǹswoŋ mə, “Rabbi!” ");
INSERT INTO bfd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bə̀ bya bɨ tɨgə̀ ŋ̀ghɛɛ mbaŋnə yi. ");
INSERT INTO bfd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ŋù yî mɔ̀ꞌɔ yìi mə a lɛ ntəə a tɨtɨ̀ɨ bo aa a tsɔꞌɔ munwî yì ŋ̀kwyɛ atôŋnə̌ abùꞌu ŋgàŋmàꞌa Nwì yî ŋ̀wè ghu nlɔꞌɔsə. ");
INSERT INTO bfd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu a betə waa mə, “Nɨ̀ zi nɨ̀ nwi ntsò a bɔ̀ꞌɔ nɨ mɨ̀buꞌu aa a ntswa mə̀ tsǒ nɨ zi a mbaŋnə àŋgâmɨghee aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tɨgə mə̀ kɨ̀ sɨ tswe biꞌinə̀ a ndâmaꞌanwì aa a njwi njwi ndɨ̀ꞌɨ̀ nɨ ghuu, kaa nɨ̀ waꞌà gha tswa aa a ya aa ɛ? Lâ ma yû ànnu a tswe nɨ mfɛ̀ꞌɛ̂ tǎ lwensə annù yìi mə aŋwàꞌànə̀ Nwî a swoŋə aa. ");
INSERT INTO bfd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ma mùu noò ŋgǎŋyəgə̂nnù ji jya tsiꞌi tsɨm ɨ tɨgə̀ m̀maꞌatə yi ŋkghəkə waà. ");
INSERT INTO bfd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mûjɔ̀ŋ yî mɔ̀ꞌɔ a ka nyoŋə nìi, ŋ̀wɛꞌɛ tsiꞌì àbàꞌa atsə̀ꞌə̀ yî fùꞌù a nu yu. Bə̀ bya bɨ̀ maꞌà m̀bô myaa ghu nu mə bɨ tswa yi mbaŋnə tswa atsə̀ꞌə̂ yi. ");
INSERT INTO bfd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lâ a bâŋnə̀ m̀maꞌatə abàꞌa atsə̀ꞌə̀ yî fùꞌù ya ŋkhə yi tsiꞌì ǹswèrè ǹswèrè. ");
INSERT INTO bfd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bɨ lɔgə̀ Yesu ŋ̀ghɛɛ nɨ ghu a mbɛ̀ɛ ŋgàŋmàꞌa Nwì yî ŋwè. Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bɨtsɨ̀m bo bɨ̀ bɨ̀tà bɨ alaꞌa bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo lɛ ŋghotə ntswe bo bo. ");
INSERT INTO bfd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peta à lɛ sɨ yòŋə̀ nɨ a njɨ̌m Yesu a sàꞌa aghaꞌà. À yòŋə̀ mə̂ ŋ̀kuu ŋghɛɛ ntswe a nsàŋàbɛ̀ɛ ngàŋmàꞌa Nwì yî ŋ̀wè bo bɨ ŋ̀gǎŋmbɛ̂ ǹdamaꞌanwì ǹyɔꞌɔtə nɨ̂ mɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ ŋgǎŋndasaꞌa tsɨ̀m bo lɛ ŋka nlɔɔ nɨ̂ mânjì yìi mə mbə ŋù a swôŋ ànnù yî tsu a atu Yesu yìi mə mbə bo tsyâ ghu nzwitə yi, lâ kaa waꞌà yî tsù yə̂. ");
INSERT INTO bfd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bə̀ bî ghàꞌàtə̀ bɨ lɛ sɨ tswɛɛ nɨ̂ ɨ̀bǎŋnənnù a atu Yesu, kaa mɨ̀ghàâ myaa mɨ waꞌà bàŋnə̀ m̀boontə. ");
INSERT INTO bfd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bə̀ bî mɔꞌɔ bɨ bɨɨ̀nə̀ ǹtswɛɛ nɨ̂ ɨ̀baŋnənnù ghu atu ǹswoŋə nɨ mə, ");
INSERT INTO bfd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Bìꞌì lɛ nyuꞌu a swoŋ mə yu ka yǐ sàꞌa ndâmàꞌanwì yuà mə bɨ bɔɔ nɨ̂ m̀bo aa ɨ bǔ ghùrə̀ yî dàŋ fu yìi mə kaa bɨ sɨ̀ aa nɨ̀ m̀bo bɔɔ aa, a njɨ̌m ǹjwi ji tarə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lâ a ŋkɨ ŋghɛ̀ɛ a nɨ ma buù bə̀, kaa ǹtsû waa kaa waꞌà kɨ̀ m̀boontə. ");
INSERT INTO bfd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ŋ̀gàŋmàꞌanwì yî ŋ̀wè wa a bɨɨ̀nə̀ ǹtəə a tɨtɨ̀ɨ bo mbetə Yesu mə, “Ò sɨ nɨ̂ ànnù yî tsu a kwiꞌi tswê? Ò swǒŋ mə akə nɨ̂ ɨ̀nnù jû mə bɨ swoŋə a atu wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","La a təə kaa waꞌà yi kwɛꞌɛ̀. Ŋ̀gàŋmàꞌanwì yî ŋ̀wè wa a bû m̀betə ghu mbo mə, “Ò nɨ̂ Àyɔꞌɔ̀ Nwì, Mu Nwì yìi mə bɨ ghaꞌasə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu A swoŋə mə, “À nɨ mə̀, nɨ̀ ka yi yə Mu Ŋù tâ à tswe a mbɛ̀ɛ̀ nɨkwɛɛ Nwì yìi à tswe nɨ mɨ̀dàꞌà aa nì màꞌà ǹlo a aburə nsɨgə nɨ a mûm m̀bàꞌà.” ");
INSERT INTO bfd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","À kwìꞌì mə laà, ŋ̀gàŋmàꞌa Nwi yî ŋ̀wè wa a satə̀ ɨ̀tsə̀ꞌə̂ ji, nswoŋ mə, “Bìꞌinə̌ bù ǹlɔɔ nɨ bɨ̀yəfə aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nɨ̀ yùꞌû àjàŋ yìi mə à bə̀gɨ̀tə Nwì aà. Kə̀ nɨ̀ wàꞌàtə mə akə lɛ?” Bo bɨtsɨ̀m tsərə̀ ɨ̀saꞌà yi nswoŋ mə a kuꞌunə mə bɨ̀ zwitə yi. ");
INSERT INTO bfd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bo bî mɔꞌɔ bɨ tɨgə̀ ǹlɔgɨnə ntɨgə ntsee nɨ mɨ̀twyɛ ghu nu, nlɔgə nɨ̂ ɨ̀tsə̀ꞌə̀ m̀bɔɔ nɨ̂ miꞌi mi ghu, ŋ̀ghɔɔ nɨ̂ yi, ǹswoŋə ghu mbo mə, “Twi ŋû yìi mə à ghɔ̀ɔ gho aà.” Bɨ lɛ ntɨgə mbu nlɔ̀gə̀ yi ŋghɛɛ mfa a mbo ŋgǎŋmbɛ ǹdâmàꞌanwì bɨ lɔgə̀ yi ntɨgə ŋku. ");
INSERT INTO bfd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peta à tswè mə̂ wa nsàŋàbɛɛ a mbɨ̂ ǹtii ŋka yɔꞌɔtə nɨ̂ mɔꞌɔ aa ŋ̀gàŋàfàꞌa ŋgàŋmàꞌa Nwì yî ŋ̀wè yî màŋgyɛ̀ yî mɔ̀ꞌɔ a zî ");
INSERT INTO bfd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ǹyə Peta ǹlii yi nswoŋə mə, “Tɨgə ò ghɨ̀rə mbaa ŋkɨ ntswe bu Yesu mu Nazereth wa aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peta a tuu nswoŋ mə, “Kaa mə̀ sɨ̀ yi zî, kaa waꞌǎ annù yìi mə o swoŋ aa kɨ nzi.” À swòŋə̀ mə̂ laà aa nlò wa nsàŋàbɛ̀ɛ̀ m̀fɛꞌɛ ŋghɛ̀ɛ̀ a ntsǔbùꞌù. Tsiꞌì maa noò, àkə̀gə̀ yî ǹtsyàmbìì a burə̀ ǹtɔŋ. ");
INSERT INTO bfd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","À fɛ̀ꞌɛ̀ mə̂, mu màngyɛ̀ wa a yə yi, m̀bu mbèꞌènə̀ ŋ̀ka nswoŋ a mbo bə̀ bìi mə bɨ lɛ ntəə wa ntsǔbùꞌù aa mə, “Ŋù ghuà à nɨ ŋù nɨ̀bò wàà yî mɔ̀ꞌɔ̂.” ");
INSERT INTO bfd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lâ Peta a bû ŋ̀kwatə ntuu yi. Mu fɨ̀bàŋtə̀ à bù mə̂ ghə̀ə kɨ bə, bə bya mə bɨ Peta lɛ ntəə aa bû ǹswoŋ ghu mbo mə, “Tsiꞌì ànnù nɨ̂ŋkoŋə̀, ò nɨ ŋù nɨ̀bò wàà yî mɔ̀ꞌɔ nloŋ mə ò nɨ mu Galilea.” ");
INSERT INTO bfd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peta a lɔgɨ̀nə̀ ǹtɨgə ŋkaa nswoŋə nɨ mə “Kaa mə̀ sɨ̀ ŋû yìi mə nɨ swoŋə aa zî. Bɛɛ a bə yìi mə mə swoŋə aa àbaŋnənnù, Nwì a nɨ̂ŋ ǹdɔ̀ɔ̀ a atu mə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tsiꞌì maa noò, àkə̀gə̀ bû ŋ̀kwatə tɔŋ, Peta a waꞌatə ajaŋ yìi mə Yesu à ghɨ̀rə nswoŋ ghu mbo mə, “M̀bɔŋ tâ àkə̀gə̀ à tɔŋ ŋgaa ji baa lɛ boŋ ò tùù mə̂ gha ŋgaa ji tarə̂.” À wàꞌàtə̀ mə laà aa mburə naŋsə yəꞌə. ");
INSERT INTO bfd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Àbɛ̀ɛ̀ a ghɛ̀sə̀ mə̂ mfuꞌu, bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì, nɨ bɨ̀tà bɨ alaꞌa, nɨ̂ ŋ̀gǎŋdɨ̀ꞌɨ̂ nɔ̀ŋsə̀, bo bɨ ŋ̀gǎŋndasaꞌa tsɨ̀m, bo tswâ ŋ̀ghòtə ŋghàànə̀, ǹtɨgə ntswa yi, ŋ̀kwerə mbo mî, ǹlɔgə ŋghɛ̀ɛ̀ mfa a mbo Pilato. ");
INSERT INTO bfd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bɨ ghɛ̀ɛ̀ mə̂ nɨ ghu a mbɛ̀ɛ Pilato, a betə̀ yi mə, “Ò bə aa mfɔ̀ baYuda aa ɛ?” A kwiꞌi ghu mbo mə, “Ò swòŋ mə̂!” ");
INSERT INTO bfd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwi bɨ lɛ mbù ǹnɨŋ ɨnnù jî ghàꞌàtə̀ ghu nû. ");
INSERT INTO bfd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato a bû m̀betə ghu mbo mə, “Ò sɨ̀ nɨ̂ ànnù yî tsu a kwiꞌi tswê aa ɛ? Yə ɨnnù jìi mə bɨ swoŋ nɨ a atu wò ɨ burə̀ ghaꞌa laà aà!” ");
INSERT INTO bfd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lâ kaa Yesu a waꞌà yi annù yî tsu burə̀ m̀bu kwikwiꞌi. Ma mùu ajàŋ annù a kɨ̂ m̀burə ntsya Pilato tsiꞌì tsyà. ");
INSERT INTO bfd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","À lɛ mbə nɔ̂ŋsə̀ Pilato mə a yi mbə a njwî Passa aa, a fiꞌisə̀ ŋ̀gàŋàtsaŋ yì m̀fùùrə̀ yìi mə bə̀ betə aa mfa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","À lɛ mbə ma mùu noò aa, ŋù yî mɔ̀ꞌɔ mə ɨ̀kùm yi lɛ mbə Barabbas, a tswe a atsaŋ a tɨtɨ̀ɨ ŋgǎŋmbùùrə̂ àlaꞌà. Ma ghuù ŋù à lɛ nzwitə ŋû a noò yìi mə bo lɛ sɨ bùùrə alaꞌa aà. ");
INSERT INTO bfd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ǹnɔ̀ɔ̀ bə̂ wa ɨ lɛ nzì ǹswoŋ a mbo Pilato mə tâ à ghɨrə a ajàŋ yìi mə a tɛꞌɛ ŋghɨrə a alòo lòò aà. ");
INSERT INTO bfd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A betə̀ a mbo bo mə, “Nɨ lɔ̀ɔ mə tâ mə̀ fiꞌisə aa mfɔ̀ baYuda a mbo bù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","À lɛ mbetə ma mùu ajàŋ aa nloŋ mə à lɛ zi mə â lɛ ŋghɨ̀rə aghə̀ꞌə̀nə̀ mə tâ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bɨ̀ tswa Yesu ǹzi mfa ghu mbo aà. ");
INSERT INTO bfd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lâ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bo totə̀ ǹnɔɔ̀ bə̂ wa mə tâ bo ghɨrə tâ Pilato à baŋnə fiꞌisə bə Barabas m̀fa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato a bû m̀betə a mbo bo mə, “Nɨ lɔ̀ɔ mə tâ mə̀ tɨgə ŋghɨrə aa mə akə nɨ ŋù ghû mə nɨ twoŋə nɨ̂ m̀fɔ̀ baYuda aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bo bû ǹtɔŋnə nswoŋ tsiꞌì nɨ̀ tɨ̀ɨ̀ mə, “Kwèèntə̀ yi a ati bàŋnə̀bàŋnə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lâ Pilato a bû m̀betə waa mə, “Nɨ lɔ̀ɔ̀ mə bɨ̀ kweentə yi aa a ya? Ànnù yî bɨ yìi mə à bùꞌù aa à nɨ̂ àkə̀ aa ɛ?” Lâ bo bû ŋ̀kuꞌusə ntɔŋnə ghaa bə nɨ̀ mɨ̀tɨ̀ɨ̀ ǹswoŋ mə, “Kwèèntə̀ yi a ati bàŋnə̀bàŋnə̀.” ");
INSERT INTO bfd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato a lɔɔ̀ mə yu ghɨ̀rə tâ nû ǹnɔ̀ɔ̀ bə̂ wa ɨ̀ bɔŋ, ǹtɨgə mfiꞌisə Barabbas mfa a mbo bo, ŋ̀ghɨrə bɨ ghɔɔ̀ Yesu a fâ yi mə tâ bɨ̀ tɨgə nlɔgə ghɛ̀ɛ̀ ŋ̀kweentə a ati bàŋnə̀ bàŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bɨ̀sogyɛ̀ bya bɨ tɨgə̀ ǹlɔgə Yesu ŋ̀kuu ŋghɛɛ nɨ ghu a mûm ǹtɔꞌɔ̀ Gûmnàà (bɨ lɛ sɨ twoŋə aa nɨ Pretoriun) ǹtwoŋ bɨ̂sogyɛ̀ bɨtsɨ̀m bìi mə bɨ lɛ ntswe maa ntɔꞌɔ aa bɨ ghotə̀. ");
INSERT INTO bfd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bo lɛ nlɔ̀gə atsə̀ꞌə̀ yî bàgɨtə yi atɨ̀ndùù ŋ̀wɛꞌɛ ghu nu tsǒ m̀fɔ̀, ǹlɔɔ mɨ̂ndɨgə mɨ njɔ̂ŋ ǹjɔŋ mbaꞌa tsǒ àtsə̀ꞌətu nɨfɔ̀ ǹsosə ghu atû; ");
INSERT INTO bfd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ǹlɔgɨnə ntɨgə ntsaꞌatə nìi, m̀bitə ǹswoŋə nɨ mə, “O lɛ lɛlɛ lɛɛ̀! M̀fɔ̀ baYuda à kɨ̀ kwɛ̀ɛ̂! À kwɛ̀ɛ̂!” ");
INSERT INTO bfd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bo tɨgə̀ ǹtsya yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ, ŋghɔ̀ɔ̀ nɨ̂ àtû yi nɨ̂ àtì, ǹtutə nɨ mɨ̀twyɛ ghu nu, ǹswɛtə nɨ mɨ̀kùꞌùtə̂ myaa ghu nsi a mmìi yi. ");
INSERT INTO bfd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bo nàŋsə̀ mə̂ ŋ̀wyɛ yi laà, ǹtsɔꞌɔ atsə̀ꞌə̀ yî bàgɨtə ya ghu nu, m̀bu ŋwɛꞌɛ jìi ɨtsə̀ꞌə̀ jya fu ghu nu, ǹtɨgə nlɔgə yi mfɛꞌɛ ghɛ̀ɛ̀ a ŋkwèèntə a ati bàŋnə̀ bàŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ŋù yì mɔ̀ꞌɔ yìi mə ɨkùm yi lɛ mbə Simon, m̀bə mu baCyrene, ŋ̀kɨ mbə ta bɨ̀ Alexander bo Rufus aa, a lɛ nlǒ a afɔ̀ ŋ̀ka ŋkwɛɛ, à zì mə̂ ŋ̀ka ntsya, bɨ tswâ yi nɨ̂ àdàꞌà mə tâ à beꞌe ati bàŋnə̀ bàŋnə Yesu yâ. ");
INSERT INTO bfd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bɨ ghɛɛ̀ nɨ Yesu wa adɨgə yìi mə bɨ̀ lɛ sɨ twoŋə nɨ Gologota aà (ǹjiꞌì ɨ̀kùm ma ghû ɨ bə àdɨgə akwɛ̀ɛtû ŋû). ");
INSERT INTO bfd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bo fa mɨ̀lùꞌù mìi mə bɨ lɛ mfɔrɨnə nɨ àfù yìi mə bɨ twoŋə nɨ məə̀ aa mə tâ à no, a tuù yi. ");
INSERT INTO bfd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bɨ kweèntə̀ yì wa ati bàŋnə̀ bàŋnə̀; ǹlɔgə ɨtsə̀ꞌə̂ ji a nyàtə a tɨtɨ̀ɨ bo, mmaꞌa ɨ̀bìrə̀ tǎ zi a ajàŋ yìi mə bo ka yàtə ɨtsə̀ꞌə̀ jya a tɨtɨ̀ɨ bo bɨ̂tsɨ̀m aà. ");
INSERT INTO bfd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bɨ lɛ ŋkwèèntə̀ yì aa a nɨ bɨ̀nòò bi bùꞌû a tɨ̀tugə̀. ");
INSERT INTO bfd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ŋ̀waꞌanə annù yìi mə à lɛ ŋghɨ̀rə̀ bɨ nɨ̂ŋ ɨ̀saꞌa ghu nu aa, m̀bɛɛ wa ati bàŋnə̀ bàŋnə̀ ghu atu mə, “M̀fɔ̀ baYuda.” ");
INSERT INTO bfd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bɨ lɛ ŋkɨ ŋkwèèntə bɨ̂yə̀rə bi baa bo bɨ̀ Yesu, ŋkweentə yî m̀fùrə̀ ghu mbɛ̀ɛ̀ a abô màꞌà, ŋkɨ ntɨgə ŋkweentə yî mɔ̀ꞌɔ ghu mbɛ̀ɛ̀ a abô ŋ̀kwàbə̀. ");
INSERT INTO bfd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","A kɨ mfɛꞌɛ mbòòntə̀ nɨ̂ ànnù yìi mə àŋwàꞌànə̀ Nwî a lɛ nswoŋ nloŋ ŋgaà yì aà, mə, “Bɨ lɛ nnɨŋ yì a tɨtɨ̀ɨ ŋ̀gǎŋghɨ̀rə ɨ̀nnù jî bɨ̂.” ");
INSERT INTO bfd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bɨ̀tsyà bɨ mâŋjì bɨ lɛ sɨ wyɛ̀ nii, ǹtsɨgə nɨ̂ ɨ̀tû jyaa, ǹswoŋə nɨ ghu mbo mə, “Wò yìi mə ò lɛ nswoŋ mə ò ka sàꞌa ndâmàꞌanwì ɨ bǔ bɔɔ fu a njɨ̌m njwi ji tarə aa, ");
INSERT INTO bfd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","yweensə ɨtu ɨbɨ̀ɨ nû gho lâ, ǹsɨgə wa atu ati bàŋnə̀bàŋnə̀ bìꞌì yə!” ");
INSERT INTO bfd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɨ̀lɨ̀ɨ bɨ ŋ̀gǎŋmaꞌa Nwi bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo lɛ sɨ kɨɨ ŋwyɛ nɨ̂ yi, ǹswoŋə bo nɨ bo mə, “À lɛ sɨ yweensə nɨ̂ badàŋ, tâ à waꞌǎ ɨbɨ̀ɨnû yi yumbɔŋ tsɨ̂tsɔ̀ŋ yweensə tâ bìꞌinə̀ yə! ");
INSERT INTO bfd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tâ Àyɔꞌɔ̀ Nwì, M̀fɔ̀ baIsrael, tâ à lo fìi atu ati bàŋnə̀ bàŋnə̀ ǹsɨgə tâ bìꞌì yə mbɔŋ bii annû yi.” Bə̀ bya bi baa mə bɨ lɛ ŋkwèèntə̀ waa bo aa, bo lɛ sɨ kɨɨ mbəgɨtə nìi yàa ŋgaa. ");
INSERT INTO bfd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nòò à sìꞌì mə̂ ɨtugə ɨ fii ŋkusə alaꞌà tsɨ̀m ŋ̀ghɛɛ nyweꞌe nɨ nòò ǹyəŋ nòò. ");
INSERT INTO bfd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","À bə̀ mə̂ nɨ nòò ǹyəŋ nòò, Yesu a tɔŋnə̀ ǹyəꞌə nswoŋ mə, “Eli, Eli, Lama Sabachthani?” Ma la a bə mə, “Nwìŋgɔ̀ŋ ghà Nwìŋgɔ̀ŋ ghà, Ò mèꞌe gha aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bə̀ bya bǐ mɔꞌɔ bìi mə bɨ lɛ ntəəntə maa adɨgə aa, bɨ yuꞌu laà, ǹswoŋ mə, “Yuꞌu nɨ̀, a twoŋə aa Elijah.” ");
INSERT INTO bfd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋù yî mɔ̀ꞌɔ a khə̂ ŋ̀ghɛɛ mmurə kûntsa a mum mɨ̀lùꞌù mî tsə̀ꞌə̀, ǹsɔꞌɔnə a nɨ̂ ŋ̀kɨ̀ŋkàꞌà, ŋ̀kɔꞌɔsə mfa ghu mbo mə tâ à no. À fà mə̂, ǹswoŋ mə, “Nɨ̀ yuꞌutə tâ bìꞌinə̀ yə mə Elijàh à ka zǐ ghɨ̀rə tâ à lo fìi atu ati bàŋnə̀bàŋnə̀ sɨgə lɛ.” ");
INSERT INTO bfd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu à lɛ nyə̀ꞌə̀ tsiꞌì nɨ tɨ̀ɨ̀ m̀burə ntsɨɨ. ");
INSERT INTO bfd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Àtsə̀ꞌə̀ ya yìi mə a lɛ ŋkwàsə mûm ǹdâmàꞌanwì aa, a lɛ mbòꞌònə̀ a tɨtɨ̀ɨ̀, ǹlɔgɨnə a ǹdə̌ŋ nsɨgə nyweꞌe a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Àtu bɨ̀sogyɛ̀ ya mə à lɛ ntəə nlii nɨ̂ Yesu aa, à yə̀ mə̂ mânjì yìi mə Yesu à lɛ ŋkwo ghu aa, ǹswoŋ mə, “Tsiꞌì ànnù nɨ̂koŋə̀, ŋù ghuà à bə aa Mu Nwì!” ");
INSERT INTO bfd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bàŋgyɛ̀ bî mɔꞌɔ bɨ lɛ ntswe ghu, ntəə a sàꞌa aghaꞌa nlìì. Atɨtɨ̀ɨ bo, Mary Magdalene, nɨ Mary, ǹdè bɨ̀ bɨ̀ Jɛms yî ŋ̀kəgə, bo bɨ Jose, a bɔ̀ꞌɔ Salome lɛ ntswe ghu. ");
INSERT INTO bfd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bo lɛ sɨ yòŋə̀ nɨ̂ Yesu wa noò wa mə à lɛ ntswe a Galilea aa, ŋ̀kwɛtə nii. Bàŋgyɛ̀ bî mɔꞌɔ bì ghàꞌàtə̀ bìi mə bo bɨ Yesu lɛ ŋkɔꞌɔ nzi a Yerusalem aa, bo lɛ ŋkɨ ntəə ghu. ");
INSERT INTO bfd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsǒ mə à lɛ mbə njwî ǹnàŋsə̂ ǹjoo nloŋ njwîŋgɔ̀ŋ aa, a bə̀ mə̂ a ŋkwɛ̂fɔ̀ maa njwi mə àbɛ̀ɛ̀ a kà lǒ fuꞌu a njwîŋgɔ̀ŋ aà, ");
INSERT INTO bfd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph mə à lɛ nlo a alaꞌa Arimathea, ǹyuꞌutə nɨ̂ ànnù nɨfɔ Nwî, ŋkɨ mbə ŋû yìi mə bə̀ lɛ sɨ lɛ sɨ bɔꞌɔ nìi, m̀bə ŋû yî mɔ̀ꞌɔ a tɨtɨ̀ɨ ŋgǎŋndasaꞌa aa, à lɛ ntǎŋ ntɨɨ ŋghɛ̀ɛ̀ a mbɛ̀ɛ Pilato a mbetə aku Yesu ya mə yu lɔ̀gə ɨ ghɛ̀ɛ twiŋə. ");
INSERT INTO bfd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","À ghɛ̀ɛ̀ mə̂ Pilato a betə̀ mə Yesu à kwò mə̂ lɛ, ǹtwoŋə atu bɨ̂sogyɛ̀ ya mbetə yì mə à nɨ tsiꞌì ànnù nɨ̂ŋkoŋ mə Yesu à kwò mə̂ lɛ. ");
INSERT INTO bfd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","À yùꞌù mə mə Yesu à kwò mə̂ aa, mbii mə tâ Joseph à ghɛɛ nlɔ̀gə akû yi ya ŋghɛ̀ɛ̀ ǹtswiŋə. ");
INSERT INTO bfd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A ghɛɛ̀ ǹyuu atsə̀ꞌə̀ yî fùꞌù yî sɨgɨ̀nə̀, ǹzi nlɔ̀gə̀ Yesu ǹsɨgɨsə, ǹlɨm nû yì nɨ̂ àtsə̀ꞌə̀ yâ. À lɨ̀m mə̂, ǹtɨgə nlɔgə yi ŋghɛɛ nnɨŋ a mûm nɨ̀syɛ̀ nìi mə bɨ lɛ ntoŋ a mûm àlâŋsəŋgɔ̀ꞌɔ̀ aà. À nɨ̀ŋ mə̂, ǹtii ŋgɔ̀ꞌɔ̀ ŋ̀ghɛɛ ŋkusə ntsù nɨsyɛ̀ wa ghu. ");
INSERT INTO bfd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene bo Mary, ǹdè bɨ Joses lɛ nyə adɨgə ya yìi mə bɨ lə ntwiŋə yì ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ǹjwîŋgɔŋ ya ɨ̀ tsyà mə̂, Mary Magdalene, bo Salome nɨ Mary, ǹdè bɨ Jɛms, bo yuu mɨ̀ghurə mì lùmtə̀ mə bo ghɛ̀ɛ yɔꞌɔ nû Yesu ghu. ");
INSERT INTO bfd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","À lò mə̂ m̀bə a njwî yì ǹtsyàmbìì a mûm ŋ̀gyà, tsiꞌì a tɨ̀tugə̀ tɨ̀tugə, a noò ǹsaꞌa nòò, bo fɛꞌɛ̀ a ŋghɛɛ wa ntsù nɨsyɛ̀. ");
INSERT INTO bfd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bô fɛ̀ꞌɛ̀ mə̂ ŋ̀ka ŋghɛɛ a mânjì ǹtɨgə mbetə nɨ̂ waa bo nɨ bo mə, “A ŋgɔ̀ꞌɔ̀ ya wa ntsù nɨsyɛ̀ aa a ka tii wo lɔ̀ꞌɔ̀sə̀ a mbo bìꞌinə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bô ghɛ̀ɛ̀ mə̂ ǹyweꞌe wa ntsù nɨsyɛ̀, ŋ̀ghə̀ə kɨ ŋɛntə miꞌì myaa, ǹyə mə bɨ tìì mə̂ ŋ̀gɔ̀ꞌɔ̀ ya nlɔ̀ꞌɔ̀sə̀. Ŋ̀gɔ̀ꞌɔ̀ ma yû ɨ̀ lɛ mburə mbə tsiꞌì ǹgɔ̀ꞌɔ̀ yî m̀fàŋ m̀faŋə. ");
INSERT INTO bfd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bo kuu ŋghɛ̀ɛ̀ wa mûm nɨ̀syɛ̀. Bô kùù mə̂, ǹyə mûjɔ̀ŋ yî mɔ̀ꞌɔ a wɛꞌɛ̀ àdaŋə atsə̀ꞌə̀ yî fùꞌù, ǹtswe a mbɛ̀ɛ̀ àbô màꞌà; mɨ̀bɛ̂ myaa mə syənə̀. ");
INSERT INTO bfd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A swoŋ a mbo bo mə, “Tâ mɨ̀bɛ̂ muu mɨ̀ tsuu lǒ syənə bə̂. Nɨ lɔ̀ɔ̀ aa Yesu mu Nasareth wa mə bɨ kɨ̀ kwèèntə a ati bàŋnə̀ bàŋnə̀ aa ɛ? Wâ à bɨ̀ɨ̀nə̀ mə̂ a nɨwô. Wa kaa à sɨ̀ faà mə tswê! Yə̂ nɨ̀ àdɨgə yìi mə bɨ kɨ̀ nɔ̀ŋsə yi ghu aà. ");
INSERT INTO bfd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nɨ̀ ghɛɛ nswoŋ a mbô ŋ̀gǎŋyənə̂nnù ji bo bɨ̀ a mbo Peta, mə Yesu à tsyà mə a mbìi bù ŋ̀ghɛɛ nɨ a Galilea. Nɨ̀ ka ghɛ̀ɛ̀ ghu, ɨ yə yi tsiꞌì wa ajàŋ yìi mə à lɛ nswoŋ a mbo bù aà.” ");
INSERT INTO bfd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bo fɛꞌɛ̀ wa mûm nɨ̀syɛ̀ ŋ̀khəkə nloŋ mə nû jyaa ɨ̀ lɛ nswèrə̀, ǹtɨgə̀ m̀benə baꞌà bàꞌà. Bo kà mə̂ aa ŋghɛɛ a mânjì kaa waꞌà ànnù a mbo ŋù tsù burə swoswoŋə, ǹloŋ mə nɨ̀bɔꞌɔ nɨ lɛ ntswa waa aà. ");
INSERT INTO bfd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nòò wa mə Yesu à lɛ nyweenə a nɨwo a njwi yì ǹtsyàmbìì a mûm ŋ̀gyà aa, à lɛ mfòò ǹdɨꞌɨ ɨbɨ̀ɨnû yì aa a mbo Mary Magdelene, wa yìi mə à lɛ mfiꞌi ɨzwì jî bɨ jya ji sàmbaa ghu atoꞌo aà. ");
INSERT INTO bfd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mary Magdelene a tɨgə̀ ŋ̀ghɛɛ nswoŋ annù yìi mə a lɛ mfɛ̀ꞌɛ̀ aa a mbo bə̀ bya mə bo bɨ̀ Yesu lɛ sɨ karə aà, ǹloŋ mə bo lɛ ntswe tsiꞌì nɨ̂ àjəŋnə̀, ǹyəꞌə. ");
INSERT INTO bfd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bo yùꞌù mə̂ mə Yesu à bɨ̀ɨ̀nə̀ mə̂ nɨ nɨwo Mary Magdelene a yə̂ yi aa, ŋka lɨgɨtə, kaa waꞌà waa biì. ");
INSERT INTO bfd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma yû â tsyà mə̂, a bû ǹzi ndɨ̀ꞌɨ ɨbɨ̀ɨnû yi a mbo bo bî mɔꞌɔ bi baa, mə bɨ lɛ mfɛ̀ꞌɛ a Yerusalem ntɨgə mfu ŋghɛɛ nɨ̂ waa a afɔ̀. Ma mùu noò Yesu a bâŋnə̀ ǹtɨgə ndɨꞌɨ aa bə ŋ̀kɨ̀rə̂ yì yî dàŋ a mbo bo ma bû. ");
INSERT INTO bfd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bô bɨ̀ɨ̀ mə̂, ǹswoŋ a mbo àbùgə̀ yaa bìi mə bo lɛ ntswe a Yerusalem aa, kaa bo waꞌà waa biì. ");
INSERT INTO bfd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","À bə̀ mə̂ a noò ǹjɨ̀m Yesu a zî ǹtsiꞌi ŋgǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò mɔ̀ꞌɔ bo tswê ǹjɨ, a ghaàntə̀ waa nloŋ mə kaa bo lɛ ŋwaꞌà nɨ̂ àbìintɨɨ tswê, ŋ̀kɨ ŋkɨɨ mɨ̂ntɨɨ̀ myaa, kaa waꞌà ànnù yìi mə bə̀ bya mə bɨ lɛ nyə yi a noò yìi mə à lɛ nyweenə nɨ nɨ̀wo aa bii aà. ");
INSERT INTO bfd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A swoŋ a mbo bo mə, “Nɨ̀ ghɛɛ a mbo mbî ǹtsɨ̀m, ŋ̀ka nswoŋə nɨ̂ ǹtoo yî ǹsɨgə̀nə̀ ya a mbo bə̀ bɨ̀ tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ŋù yìi mə à yùꞌu, nnɨŋ ntɨɨ̀ yi a nu mə̀, bɨ murə̀ yi a ŋkì aa, à ka yǐ yweenə, ŋu yìi mə kaa à sɨ̌ ntɨɨ̀ yi a nù mə̀ nɨŋ aa, Nwì à ka yǐ nɨŋ ɨsaꞌa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bə̀ bìi mə bɨ nɨŋ ntɨɨ̀ waa a nu mə̀ aa, bɨ ka yǐ tswe nɨ̂ ɨ̀lènsə̀ juà: Bo ka yǐ kɨ fiꞌi nɨ̂ bɨ̀demon a ntoꞌo bə̀ nɨ̂ ɨkǔm ghâ. Bo ka yǐ kɨ ghàà mɨghàà mî fii ");
INSERT INTO bfd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bo ka yǐ kɨ bwɛɛ nɨ̂ no tugɨtə nɨ̂ a mbo bo kaa tâ ɨ̀ waꞌǎ annù a nu bo ghɨrə̀; kə̀ bɛɛ mə bo tɛꞌɛ nno bə̂ ǹlɨꞌɨ, kaa ɨ waꞌǎ annǔ tsu a nu bo ghɨrə̀ bə̂. Bo ka yǐ kɨ nɔ̀ŋsə̀ nɨ̂ m̀bô myaa a nû ŋ̀gàŋmɨghɔ̀ɔ̀ tâ bo ka mfwɛtə.” ");
INSERT INTO bfd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","M̀màꞌàmbi Yesu à ghàà mə a mbo bo laà aa, Nwì a lɔgə̀ yi ŋkɔꞌɔ ghɛɛ nɨ ghu a aburə, ŋ̀ghɨrə a tswê a mbɛ̀ɛ̀ nɨ̀kwɛɛ yu nî màꞌà. ");
INSERT INTO bfd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bo fɛꞌɛ̀ ŋ̀ghɛɛ ntɨgə nswoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya a ɨdɨgə tsɨ̀m; M̀màꞌàmbi a faꞌà bo bo ŋ̀ghɨrə nɨ̂ ɨ̀lènsə̀ tâ bə̀ zi mə bo lɛ sɨ swoŋ aa tsiꞌì ànnù nɨ̂ŋkoŋə̀. Amen.");
INSERT INTO bfd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Taà Theophilos, bə̀ bî ghàꞌàtə bɨ gaansə mɨ̀tɨ̀ɨ̂ myaa a ŋŋwàꞌànə ɨnnù jìi mə ɨ lɛ mfɛ̀ꞌɛ̀ a tɨtɨ̀ɨ bìꞌì aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bo ŋwaꞌanə aa ajàŋ mə bə̀ bìi mə bɨ lɛ nyə ɨnnù ma jû ǹlɔgɨnə a noò ǹlɔ̀gɨ̀nə ŋkɨɨ nsɛɛnsə nɨ̂ ǹtoo ya aa, bɨ swoŋ a mbo bìꞌì aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Àjàŋə mə a bə laa aa, Taà, mə̀ nàŋsə̀ mə̂ ǹlɔgə noò ǹyəgə ɨnnù ma jû m̀beꞌenə a lɔ̀gɨ̀nə, ŋ̀waꞌatə mə a kuꞌunə mə tâ mə̀ naŋsə ntsisə ŋŋwaꞌanə ajàŋ mə ɨnnù ma jû ɨ lɛ mfɛ̀ꞌɛ̀ aa a mbo wò. ");
INSERT INTO bfd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mə ghɨ̀rə̀ mùu ajàŋ aa mə tâ ò naŋsə nzi annù nɨ̂koŋ yìi mə a tswe ghu nloŋ ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi bɨ swoŋ a mbo wò aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nòò yìi mə Herod à lɛ mbə mfɔ̀ a alaꞌa Yudea, ŋ̀gàŋmàꞌa Nwì yî mɔ̀ꞌɔ à lɛ ntswe ghu, mfɛꞌɛ aa a tɨtɨ̀ɨ àkhɨ̀rə̀ bə̂ bìi mə bɨ̀ lɛ sɨ fàꞌà bɔ bɨ̀ bə̀ bɨ ŋ̀gǎŋmàꞌa Nwì Abija aà, ɨ̀kǔm ŋgwɛ̂ yì ɨ lɛ mbə Elizabeth, ŋ̀kɨ mfɛꞌɛ aa a ŋgwɛ̀ꞌɛ Aaron ŋ̀gàŋmàꞌa Nwì wa. ");
INSERT INTO bfd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Àkòrə̀ nɨzì yaa bo bɨtsɨm a lɛ ntsinə a nsi miꞌi Mmàꞌàmbi, kaa bo waꞌà nɨ̂ àlɔ̀ꞌɔ̀ tswê ǹloŋ mə bo lɛ sɨ lə̀ə̀ bɨ̀nɔ̀ŋsə̀ bɨ Nwî ŋ̀kɨɨ nyuꞌunə nɨ̂ ǹdɨꞌɨ̂ ji tsiꞌì tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","La kaa bo lɛ ŋwaꞌà nɨ mu bàŋnə̀ tswe nloŋ mə Elizabeth à lɛ mbə afɨrə, bo kɨ̂ ǹtɨgə bɨlwèn aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","À lɛɛ̀ m̀bə a njwi yì mɔ̀ꞌɔ, a bə̂ ǹjwi yìi mə ŋ̀gǎŋmàꞌa Nwi Abija ɨ tswê nɨ̀ m̀fàꞌa a mûm ǹdâmàꞌanwì, Zechariah a kâ m̀faꞌa ɨfàꞌâ yi a mûm ǹdâmàꞌanwì, ");
INSERT INTO bfd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ǹyoŋə nɨ nɔ̀ŋsə̀ ŋ̀gǎŋmàꞌa Nwì maa noò, bɨ lɛ mmàꞌa ɨbìrə̀ ǹtsɔꞌɔ yi mə tâ à tɔɔ alùmtə̀ a nɨkentə nɨ mɔꞌɔ nɨ màꞌa Nwì. A tɨgə̀ ŋ̀kuu ŋghɛɛ a mûm ǹdâmàꞌanwì. ");
INSERT INTO bfd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ǹnɔ̀ɔ̀ bə̂ bɨ̀tsɨm bìi lɛ ntswe a abɛɛ aa bɨ lɛ sɨ tsàꞌàtə̀ Nwî maà noò yìi mə à lɛ mbə noò ntɔ̀ɔ̂ àlùmtə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Angel Mmàꞌàmbi à lɛ ŋwìꞌìkə̀ m̀fɛꞌɛ ghu nsi, ntəə a mbɛ̀ɛ̀ àbô amàꞌa nɨ̀kèntə̀ nɨ mɔꞌɔ nɨ alùmtə̀ nyâ. ");
INSERT INTO bfd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nòò yìi mə à lɛ nyə angel wa aa, mɨ̀bɛ̂ mi lɛ nsyənə, nɨ̀bɔꞌɔ tswâ yi. ");
INSERT INTO bfd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angel wa a swoŋ ghu mbo mə, “Tsùu bɔꞌɔ mbâ Zechariah. Wa Nwìŋgɔ̀ŋ à yùꞌù mə atsàꞌàtə̀ yô. Ŋ̀gwɛ̂ ghò Elizabeth à ka jwe mûmbâŋnə̀ tâ ò tswe ɨkûm yi nɨ Jɔn. ");
INSERT INTO bfd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","À ka yǐ bə annù nɨ̂dorə a mbo wò tâ nû yò ɨ̀ naŋsə mbɔŋ, bə̀ bî ghàꞌàtə̀ kɨɨ ndorɨtə nloŋ mə bɨ jwe yi aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ǹloŋ mə à ka yǐ bə ŋû yî ŋ̀wè a nsi miꞌi Mmàꞌàmbî, kaa waꞌǎ mɨlùꞌù ka nno, kə̀ mî bɔ̀nə̀ kə̀ mî tɨ̀ɨ̀. Àzwì Nwî a ka yǐ lwensə yi lɔgɨnə a atoꞌo ǹdè yì. ");
INSERT INTO bfd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","À ka yǐ ghɨ̀rə tâ baIsrael bî ghàꞌàtə̀ tâ bɨ̀ bǔ mbɨ̀ɨ̀ fu a mbo Mmàꞌàmbî Nwìŋgɔ̀ŋ wàà. ");
INSERT INTO bfd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","À ka yǐ tsyǎ a mbìi Mmàꞌàmbi nɨ̂ àzwǐ ǹtoò Nwì Elijah bo bɨ̀ mɨ̀dàꞌâ mi. À ka yǐ bòònsə bɨtà bo bɨ̀ bɔɔ̀, ɨ bəŋkə ŋgǎŋatɨɨ atu tâ bo tswe nɨ mɨ̀tsyɛ̂ tsǒ bìi ɨ̀nnù jyaa ɨ tsinə aà. À ka yǐ taŋtə bə̂ tâ bɨ̀ kuꞌunə a mbô M̀màꞌàmbî.” ");
INSERT INTO bfd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah a betə̀ Angel wa mə, “Mə̀ ka zi aa mə akə mə ma yû ànnù a ka fɛ̀ꞌɛ̀ aa ɛ? Ǹloŋ mə mə̀ tɨgə nlwèn ŋù, ŋ̀gwɛ̂ ghà a kɨ̂ ǹlwen lwen aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angel wa a kwiꞌi ghu mbo mə, “Mə̀ nɨ Gabriel yìi mə a təə nɨ a nsi miꞌi Nwì, yu wa yìi mə à too gha mə tâ mə zi ŋkɛ̀ꞌɛ̀nə ntoo yì ǹsɨgɨ̀nə̀ ma yû a mbo wò aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lâ, tsǒ mə kaa ò sɨ ntoo yì ǹsɨgɨ̀nə̀ yû mə ɨ̀ ka yǐ fɛ̀ꞌɛ nɨ nòò yìi mə à kùꞌùnə aa biì aa, kaa ò ka waꞌà bù ŋ̀ghaa. Ò ka ghɛ̀ɛ nɨ tɨ̀ghàà ɨ yweꞌe wa noò yìi mə ɨ̀nnù ma jû ɨ ka yǐ fɛ̀ꞌɛ laa aà.” ");
INSERT INTO bfd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bə̀ bya mə bɨ lɛ ntəə a abɛɛ aa, bɨ lɛ nyuꞌutə Zechariah kɨ kaŋ ntɨgə ŋwaꞌa nɨ mə a ghɨ̀rə̂ àkə a tɨgə̀ ǹtɨgə a mûm ǹdâmàꞌanwì ǹtɨgə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nòò yìi mə à lɛ mfɛ̀ꞌɛ̀ aa, kaa à lɛ ŋkɨꞌɨ̀ a ŋghàa a mbo bo bû ǹzi. Bo tɨgə̀ ǹzi mə ǹjə̀ə̀ təə təə ɨ̀ lɛ yi wa mûm ǹdâmàꞌanwì. À lɛ ntɨgə nsɛɛnsə waa nɨ̂ m̀bo, ǹtɨgə ntswe nɨ tɨ̀ghàà. ");
INSERT INTO bfd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nòò yìi mə à lɛ mmàŋsə afàꞌâ yi a mûm ǹdâmàꞌanwì aa, a tɨgə̀ ǹlo mbɨɨ yi a ndùgə yu. ");
INSERT INTO bfd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","À tɨ̀ mə bə nɨ mû àtɨɨ noò, ŋ̀gwɛ̂ yì Elizabeth a tswê nɨ mû, ǹtɨgə tswe tsiꞌǐ a nda mə bɨ̀ tsuu yi lǒ yə atu bɨ̀sàŋ bintaà. ");
INSERT INTO bfd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ǹtɨgə nswoŋ nɨ mə, “M̀màꞌàmbî à lèntə̀ mə̂ ŋ̀ghɨrə ma yû ànnù a nu mə aa, a mfiꞌi ǹdɨ̀rə̂ atu a atu mə̀ a tɨtɨ̀ɨ bə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bɨ̀sàŋ bɨ lɛ ntsyà bi ntoꞌo ajàŋ yìi mə Elizabeth à lɛ ntswe nɨ mu aà, Nwì a too angel Gabriel a njɔ̀ꞌɔ̀ àlaꞌa Nazareth a alaꞌa Galilea. ");
INSERT INTO bfd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","À lɛ ntswe nɨ̂ ŋ̀kɨ̀ɨ̀ a mbo mûŋgɔ̀ɔ̀ màŋgyɛ̀ yìi mə ŋù yî mɔ̀ꞌɔ yìi mə ɨ̀kǔm yi ɨ lɛ mbə Joseph, ǹlo a atsə M̀fɔ̀ David aa, à lɛ ŋkosə. Ɨ̀kǔm mûŋgɔ̀ɔ̀ màŋgyɛ̀ ma ghû ɨ lɛ mbə aa Mary. ");
INSERT INTO bfd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel wa à lɛ nzì ghu mbo nswoŋ mə: “Mə tsàꞌàtə̀ ghô! M̀màꞌàmbî à tswe bu yu, à kɨ̀ mə̂ ǹnɨŋ mbɔɔnə yì ŋ̀wè a nu wò.” ");
INSERT INTO bfd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary à lɛ mbɔꞌɔ tsiꞌì ànnù nɨ̂ŋkoŋ a ajàŋ yìi mə à lɛ nyuꞌu annù ya mə angel wa à lɛ nswoŋ aà, ǹtɨgə ŋwaꞌa nɨ mə ma yû m̀buu atsàꞌàtə a dɨꞌɨ aa àkə̀ lɛ. ");
INSERT INTO bfd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angel wa a swoŋ ghu mbo mə: “Tsuu bɔꞌɔ mbâ Mary, wa ɨ̀bɔ̀ŋ Nwìŋgɔ̀ŋ ɨ̀ tswe a mbo wò. ");
INSERT INTO bfd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ò ka tswe nɨ mu ɨ jwe mûmbâŋnə̀ ɨ tswě ɨkûm yi nɨ Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","À ka yǐ bə ŋû yî ŋ̀wè tâ bɨ̀ ka twoŋə nii nɨ Mu Nwìŋgɔ̀ŋ Àkɔꞌɔ̀ntsɨrə. Yaweh Nwìŋgɔ̀ŋ à ka yǐ ghɨ̀rə̀ yi nɨ̂ m̀fɔ̀ tsiꞌì tsǒ ta bɨ̀ taà yì David. ");
INSERT INTO bfd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","À ka yǐ bə Mfɔ̀ a ŋgwɛ̀ꞌɛ Yacob, ɨ lwìꞌì nɨ̂ŋkoŋ, kaa tâ ànnù nɨfɔ̂ yi tâ waꞌà nɨ̂ ǹlwìꞌi tswê.” ");
INSERT INTO bfd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary a betə̀ angel wa mə: “Mə̀ bùrə nɨ mûŋgɔ̀ɔ̀ màŋgyɛ̀, kaa mə̀ lɛɛ̀ ŋ̀waꞌà ŋûmbâŋnə̀ zi, m̀bə ma yû ànnù a fɛ̀ꞌɛ̀ aa mə akə lɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel wa a kwiꞌi ghu mbo mə, “Wa Àzwì Nwî a ka kusə gho tâ àdàꞌa Akɔꞌɔ̀ntsɨrə tâ à kuu a nu wò. Ma mùu ajàŋ, mu wa mə ò ka jwe aa, wa yìi mə à làa màŋsə̀ aa, bɨ ka yǐ tɨgə twoŋə yi nɨ Mu Nwì. ");
INSERT INTO bfd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Waꞌatə ŋû ŋ̀gwɛ̀ꞌɛ̀ ghùù, Elizabeth. Bɨ swoŋə nɨ mə kaa mbə a waꞌà bɔɔ jwê. La tsɨ̂tsɔ̀ŋ, yumbɔŋ à tswè mə̂ nɨ mu a nɨ bɨ̀sàŋ bi ntoꞌo, ka mə à lwèn mə̂ siꞌi siꞌi aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kaa ànnù yî tsu sɨ̀ ghu tswê mə mbə Nwì a waꞌà ghɨ̀rə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary a kwiꞌi mə, “Yə̂, mə̀ laa mbə abùꞌu Mmàꞌàmbî, tâ a fɛꞌɛ a nu mə̀ wa ajàŋ mə ò swòŋə aà.” Angel wa a tɨgə̀ m̀maꞌatə yi ŋghɛɛ yi. ");
INSERT INTO bfd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tsiꞌì maa noò Mary a burə̀ ǹtaŋtə njoò ji mmàꞌàtə̀ ŋ̀ghɛ̀ɛ̀ a njɔ̀ꞌɔ̀ àlaꞌà yì mɔ̀ꞌɔ yìi mə ɨ̀ lɛ ntswe a atu ntaꞌa a Yudea aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","À ghɛ̀ɛ̀ mə̂ aa, ŋghɛ̀ɛ̀ ŋ̀kuu a nda Zechariah ntsaꞌatə Elizabeth. ");
INSERT INTO bfd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mary à yùꞌù mə atsàꞌàtə Elizabeth aa, mu wa a lɨtə̀ ǹnaŋ ghu nɨbùm, Àzwì Nwî a lwensə Elizabeth ");
INSERT INTO bfd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a tɔŋnə̀ ǹswoŋ mə, “Nwì à nàŋsə nnɨŋ mbɔɔnə a nu wò a tɨtɨ̀ɨ bàŋgyɛ̀, m̀bɔɔnə ɨ kɨ̂ ǹtswe a nu mu wa yìi mə ò ka jwe aà! ");
INSERT INTO bfd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma yû ànnù yî wè, ajàŋ mə ndè bɨ̀ M̀màꞌàmbî ghà à zi ŋghantə gha aa, a fɛꞌɛ a nu mə̀ aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ǹloŋ mə ajàŋ mə mə̀ ghɨ̀rə nyuꞌu atsàꞌàtə̂ yo aa, mu ghù a nɨbǔm m1ə à ghɨ̀rə nlɨtə nnaŋ nɨ nɨ̀dorə̀. ");
INSERT INTO bfd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","M̀bɔɔnə a nu wò m̀bâ mâŋgyɛ̀, yìi ò lɛ mbii mə ànnù ya yìi mə Mmàꞌàmbi à lɛ nswoŋ a mbo wò aa, mə a ka fɛ̀ꞌɛ̀ tsiꞌì maa ajàŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary a swoŋ mə, “Ɨ̀bɨɨ nû gha tsɨ̀m ɨ ghaꞌasə Mmàꞌàmbî; ");
INSERT INTO bfd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ǹtɨɨ̀ gha ɨ dorɨtə nloŋ Nwîŋgɔ̀ŋ ŋgàŋnyweensə̂ gha ");
INSERT INTO bfd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ǹloŋ mə à wàꞌàtə̀ mə̂ gha, àbùꞌû yi yìi mə à nɨ tɨ̂kùm aà. Ǹloŋ mə, ǹlɔgɨnə tsɨ̂tsɔ̀ŋ, bə̀ bɨtsɨ̀m ka tɨgə twoŋ nɨ̂ gha nɨ ŋù yìi mbɔɔnə ɨ̀ tswe ghu nu aà, ");
INSERT INTO bfd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ǹloŋ ɨnnù jî wè jìi mə Mmàꞌàmbî yìi à nɨ̂ Ǹtɨ̀ɨ̀ aa à ghɨ̀rə a nu mə̀ aà, ɨ̀kǔm yi ɨ laa màŋsə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A ko mɨlɨ̀ŋnə̀ bə̀ bìi mə bɨ bɔꞌɔ nìi aa mɨwaa mɨwaa. ");
INSERT INTO bfd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","À nàsə̀ mə̂ nɨkwɛɛ ǹdɨꞌɨ adaꞌa yi, ǹsɛɛnsə ŋgǎŋŋee nu bo bɨ̀ ɨ̀nnù jìi mə bo mɔ̀ɔ̀ntə̀ a mûm ǹtɨɨ bo aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","À sɨ̀gɨ̀sə̀ mə̂ bɨfɔ̀ bî wè a ɨ̀bə̀rə bo, ŋ̀ŋentə bɨ̂tɨ̀kùmə̀. ");
INSERT INTO bfd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","À jɛ̀ꞌɛ̀ mə ŋgǎŋnjì, ǹlwensə waa nɨ̂ ǹjoo jì sɨgɨ̀nə̀, m̀baŋnə mfurə bə̂ bìi mə bɨ tswe nɨ̂ ǹjoo aa bɨ kwɛɛŋkə̀ nɨ̂ àbo ŋɛꞌɛ. ");
INSERT INTO bfd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","À zì mə̂ a ŋkwɛtə ŋ̀gàŋàfàꞌâ yì Israel, ŋ̀waꞌatə ŋko mɨ̀lɨ̀ŋnə̀ yìi mə à lɛ kàꞌà ǹloŋ ŋgaà yàà ");
INSERT INTO bfd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ǹswoŋ a mbo bɨ̀taà biꞌinə̀, a mbo Abraham bo bɨ̀ ŋgwɛ̀ꞌɛ̀ yì, ǹlwiꞌi nɨ̂ŋkoŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary à lɛ ntswe bo Elizabeth bɨsàŋ bi tarə mbu mbɨ̀ɨ̀ yi fu. ");
INSERT INTO bfd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nòò njwe Elizabeth à lɛ ŋkùꞌù, a jwe mûmbâŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ŋ̀gǎŋmbɛ̀ɛ ndugə jyaa nɨ̂ ŋ̀gwɛ̀ꞌɛ̀ yàà bɨ lɛ nyuꞌu ànnù yî wè yìi mə Nwìŋgɔ̀ŋ à lɛ ŋghɨ̀rə̀ ghu nu aa, bo bo bɨtsɨ̀m tɨgə̀ ǹdorɨtə. ");
INSERT INTO bfd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","À bə̀ mə̂ nɨ̂ ǹjwi ji nɨfwaa aa, bɨ zî a ŋŋètə mu wa, ǹlɔɔ mə bɨ tswě ɨkǔm yi nɨ Zechariah, nɨ yì taà yì, ");
INSERT INTO bfd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","lâ ǹdè yì a tuu tsiꞌì nɨ̀tɨ̀ɨ̀, ǹswoŋ mə, “Ŋ̀gaŋ, ɨ̀kûm yi à nɨ Jɔn.” ");
INSERT INTO bfd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bə̀ bya swoŋ ghu mbo mə, “kaa ŋù tsù a ŋgwɛ̀ꞌɛ bù kaa à sɨ̀ nɨ̂ ɨ̀kùm ma ghû tswê.” ");
INSERT INTO bfd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bo tɨgə̀ ŋ̀ghaa a mbo Zechariah nɨ̂ m̀bô m̀betə yi mə à kɔŋ mə bɨ tswe ɨkum mu wa nɨ̂ wò aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah à lɛ mbetə taafɛ̀rə̀ ŋ̀ŋwaꞌanə ghu mə, “Ɨ̀kǔm yi à nɨ Jɔn.” Ànnù a lɛ ŋghaꞌa waa bo bɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tsiꞌì maa noò, ǹtsù Zechariah ɨ ŋaꞌanə, àləə̀ yi a fɛɛ̀ŋkə̀, à bû ŋ̀ka ŋghaa fu, ntɨgə ŋghaꞌasə Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nɨ̀bɔꞌɔ lɛ ntswa bambɛ̀ɛ̀ ǹdùgə̂ bi bya, ŋ̀gàn ya ɨ sɛɛ̀nə̀ fya alaꞌa ntaꞌa Yudea tsiꞌì tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ŋù ǹtsɨ̀m yìi mə à lɛ nyuꞌu ŋgàn ya aa, a lɛ sɨ mɔ̀ɔ̀ntə atû yi ghu ntɨgə mbetə nɨ mə, “Mu mà ghû à ka yǐ bə aa àkə̀ aa ɛ?” Ǹloŋ mə a lɛ nlaa mə àdàꞌa Mmàꞌàmbi a lɛ ntswe ghu nû. ");
INSERT INTO bfd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Àzwì Nwî a lɛ nlwensə Zechariah ta bɨ̀ Jɔn, a tɨgə̀ ǹswoŋə nɨ̂ ǹtoò Nwì mə, ");
INSERT INTO bfd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tâ bìꞌinə̀ ka ŋghaꞌasə a Mmàꞌàmbi Nwìŋgɔ̀ŋ baIsrael, nloŋ mə à zì mə̂ ŋ̀kwɛtə bə̂ bi, ntsuꞌu atû yaa. ");
INSERT INTO bfd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","À fìꞌìsə̀ mə̂ a Ŋ̀gàŋywèènsə bə̀ yìi mə à tɨ̀ɨ̀ aa a mbo bìꞌinə̀, a bə ŋù àtsə ŋgàŋàfàꞌâ yi David ");
INSERT INTO bfd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","tsiꞌǐ ajàŋ yìi à lɛ ŋkàꞌà ǹtsya a njɨ̌m ŋgǎŋntoò ji jìi laa aa a ŋguꞌu, ");
INSERT INTO bfd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","mə yu ka yǐ yweensə yiꞌinə̀ a mbô ŋ̀gǎŋkɨ̂bàâ jiꞌinə̀, ɨ kwɛrə yiꞌinə̀ a mbo bə̀ bìi mə bɨ naa yiꞌinə̀ aà, ");
INSERT INTO bfd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ɨ dɨ̀ꞌɨ ɨbɔ̀ŋə̂ yi yìi mə à lɛ ŋkàꞌà a mbo bɨ̀tà bɨ bɨtaà biꞌinə̀ aà, ɨ kɨɨ waꞌatə a akàâ yi yî làà yâ, ");
INSERT INTO bfd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","làꞌa akàà ya mə à lɛ ŋwàrə̀ bo taà yiꞌinə̀ Abraham aà. ");
INSERT INTO bfd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","À lɛ ŋkàꞌà mə yu ka kwɛrə yiꞌinə̀ a mbo ŋ̀gàŋkɨ̂bàâ jiꞌinə̀, tâ bìꞌinə̀ tɨgə mfaꞌa ghu mbo kaa waꞌà bɔꞌɔ̀, ");
INSERT INTO bfd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nɨ mânjì yìi à laa mmaŋsə ŋkɨ ntsinə a nsi miꞌi yu a nɨ nòò yiꞌinə̀ ntsɨ̀m faa atu nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wò, mû ghà, bɨ ka yǐ tɨgə twoŋə nɨ̂ gho nɨ ŋgàŋntoò Nwìŋgɔ̀ŋ Àkɔꞌɔ̀ntsɨrə. Ǹloŋ mə ò ka yǐ ghɛ̀ɛ a mbii Mmàꞌàmbi, a nnaŋsə mânjì yì. ");
INSERT INTO bfd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ɨ tɨgə ghɨ̀rə tâ bə̀ bi zi mə bo ka yǐ yweenə aa mə mbə bɨ liꞌinə ɨfansə ɨnnù jyaa, ");
INSERT INTO bfd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ɨ tsyà aa a njɨ̌m ŋko mɨ̀lɨ̀ŋnə̀ Nwìŋgɔ̀ŋ yiꞌinə̀, a ajàŋ mə àbɛ̀ɛ̀ a ka yǐ lǒ a aburə ɨ fuꞌu sɨgə a nu bìꞌinə̀, ");
INSERT INTO bfd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","a mfa ŋ̀kàꞌà a mbo bə̀ bìi mə bɨ tswe a mûm m̀fii ɨ̀dɨ̀gə̀, a adɨgə àlɨləŋə nɨwo aa, ɨ kɨ tsisə mɨ̀kòrə̂ miꞌinə̀ tâ mɨ̀ ka ntəə nɨ mânjì m̀bɔɔnə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mu wa à lɛ ŋkwe, ntɨɨ a mûm Àzwì Nwî, ǹtswe nɨ a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀, ǹyweꞌe a noò yìi mə bɨ lɛ ndɨ̀ꞌɨ̀ yi a mbo baIsrael aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A bə maa noò M̀fɔ̀ Kaisa Augustus a swoŋ mə tâ bɨ̀ səŋ bə̂ tsiꞌì bɨ̀ tsɨ̀m a ɨtoo ɨtoo jìi mə baRoma bɨ lɛ sɨ buꞌutə aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nòò wa mə ànnǔ səŋ bə̀ ma yû yìi mə a lɛ mbə yi ntsyàmbìì a lɛ mfɛ̀ꞌɛ̀ aa, Kwirinius à lɛ mbə Gûmnàà a mbùꞌu Syria. ");
INSERT INTO bfd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ŋù ǹtsɨ̀m à lɛ ntɨgə ŋghɛɛ mə yu ŋwàꞌànə ɨkûm yi a nɨkurə bo. ");
INSERT INTO bfd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph à lɛ nlò a njɔ̀ꞌɔ̀ alaꞌà Nasareth yìi ɨ̀ lɛ ntswe a Galilea aa, ŋ̀kɨ ŋkɔꞌɔ ŋ̀ghɛɛ nɨkurə nɨ Bethelehem nìi mə nɨ lɛ ntswe a alaꞌa Yudea aa, a bə̂ àdɨ̀gə̀ yìi mə bɨ lɛ njwe Mfɔ̀ David ghu aà. Joseph à lɛ ŋghɛ̀ɛ̀ ghu aa nloŋ mə à lɛ mbə ŋû àtsə̂ David aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","À lɛ ŋghɛ̀ɛ̀ ghu mə yu ghɛɛ ŋwàꞌànə ɨkûm yi bo yǐ Mary yìi mə à lɛ ŋkosə nɨ̂ ŋ̀gwɛ̂ yì aà. Mary à lɛ ntswe nɨ mû. ");
INSERT INTO bfd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Àjàŋ mə bo lɛ ntswe a Bethlehem aa, a tsɨgə̀ mu wâ; ");
INSERT INTO bfd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ǹjwe mû yì yî ǹtsyàmbìì yî m̀bâŋnə̀, ǹlɨmtə yi nɨ̂ ɨ̀bàꞌa ɨtsə̀ꞌə̀, ǹnɔŋsə yi nɨ̂ àkhɨ̀ mɨjɨ naà ǹloŋ mə kaa àdɨ̀gə̀ a lɛ ŋwaꞌà a mbo bo wa ndâ bɨ̀gɨ̀ɨ̀ tswê aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bɨ̀tsèè bɨ mbi bǐ mɔꞌɔ bɨ lɛ ntswe maa mbɛ̀ɛ̀ àlaꞌa, a atu ntaꞌa, m̀bɛ nɨ̂ m̀bî jyaa. ");
INSERT INTO bfd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bo kà mə̂ aa mbɛ nɨ̂ m̀bî jyaa jya aa, Angel M̀màꞌàmbi a wiꞌìkə̀ m̀fɛꞌɛ a nsi mbo. Ŋ̀kàꞌa Mmàꞌàmbi yìi mə ɨ ŋwèènə̀ tsiꞌì ŋ̀wèènə̀ aa, ɨ ta ŋkarɨsə waa, nɨ̀bɔꞌɔ nì wè nɨ tswâ waa, ");
INSERT INTO bfd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","la angel wa a swoŋ a mbo bo mə: “Nɨ̀ tsuu bɔꞌɔ bə̂, wa mə̀ zì aa nɨ̀ ǹtoo yì ǹsɨgɨ̀nə̀ a mbo bù, yìi mə ɨ̀ ka zì nɨ nɨ̀dorə nì wè a mbo ŋù ǹtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bɨ jwè mə Ŋgàŋywèènsə̀ ghùù, mə nɨ Kristo M̀màꞌàmbî aa, a ɨtugə mbi sìi, a nɨkurə Mfɔ̀ David. ");
INSERT INTO bfd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Àlènsə̀ yìi mə a ka dɨ̀ꞌɨ̀ a mbo bù aa, a bə mə, nɨ̀ ka ghɛɛ yə mu yì m̀bɔrə tâ bɨ̀ lɨmtə yi nɨ ɨbàꞌa ɨtsə̀ꞌə̀, ǹnɨ̀ŋ yi nɨ àkhɨ̀ mɨjɨ naà.” ");
INSERT INTO bfd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","À ghə̀ə kɨ màŋsə, ǹtsǔntsò baangel yî wè bɨ lô a aburə nsɨgə, ǹyəə nɨ̂ ɨ̀kòò ŋ̀ghaꞌasə nɨ̂ Nwî ghu, ǹswoŋə nɨ mə, ");
INSERT INTO bfd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nɨ̀ghaꞌa a mbo Nwìŋgɔ̀ŋ yìi mə à tswe a aburə ŋkɔꞌɔ ntsɨrə aà, m̀bɔɔnə a mbo bə̀ fàa nsyɛ bìi mə Nwìŋgɔ̀ŋ a dorɨtə nloŋ ŋgaa yàà aà.” ");
INSERT INTO bfd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nòò wa mə baangel bya bɨ lɛ mbù mmaꞌatə waa ŋ̀kɔꞌɔ ŋghɛɛ a aburə aa, bɨ̀tsèè bɨ mbi bya bɨ tɨgə̀ ŋ̀ghaa bo nɨ bo mə, “Nɨ̀ ghɨrə bìꞌinə̀ ghɛɛ a Yerusalem, ŋ̀ghɛɛ nyə annù yìi mə a fɛꞌɛ ghu, M̀màꞌàmbi a kɛꞌɛnə̀ a mbo bìꞌinə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bo lɛ ntswaꞌatə ŋghɛɛ nyə Mary nɨ Joseph nɨ mu wa a nɔ̂ŋ a akhɨ mɨjɨ naà. ");
INSERT INTO bfd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bɨ̀tsèè bɨ mbi bya bɨ yə mu wa ŋkɛ̀ꞌɛ̀nə̀ a mbo bo ajàŋ yìi mə baangel bya bɨ lɛ nswoŋ nloŋ mu wa aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ŋ̀gɔ̀ŋ bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ nyuꞌu aa, bɨ lɛ nyɛrə ànnù ya mə bɨ̀tsèè bɨ mbi bya bɨ lɛ nswoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary à lɛ nlɔ̀gə ɨnnù jyâ tsɨ̀m ǹləə a ntɨɨ yu ntɨgə mmɔɔntə nɨ̂ àtû yi ghu. ");
INSERT INTO bfd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bɨ̀tsèè bɨ mbi bya bɨ lɛ mbù ǹlo ntɨgə mbɨɨ ŋghɛ̀ɛ̀ waa, ǹyəə nɨ̂ ɨ̀kòò ŋ̀ghaꞌasə nɨ̂ Nwî ghu nloŋ ànnù yìi mə bo lɛ nyuꞌu ŋkɨ nyə a boòntə̀ tsiꞌì wa ajàŋ yìi mə baangel bya bɨ lɛ nswoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ǹjwî ɨ tsyà mə ji nɨfwaa, a ajàŋə mə bɨ lɛ ŋŋetə yi aa, bɨ tswê ɨ̀kǔm yi nɨ Yesu, ɨ̀kùm wa mə angel wa lɛ mfa mbɔŋ tâ bɨ̀ tswe nɨ yu a atoꞌo aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nòò à lɛ ŋkùꞌù mə tâ taà yi bô ǹdè yi ghɨrə annǔ nsìꞌî waa tâ bo laa nyoŋə nɨ nɔ̀ŋsə̀ Moses, bo lɔ̀gə̀ Yesu mə tâ bo bo kɔꞌɔ ŋghɛɛ a Yerusalem, tâ bo ghɛɛ ndɨ̀ꞌɨ̀ yi a mbô M̀màꞌàmbî, ");
INSERT INTO bfd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ŋ̀yoŋ ajaŋ mə a lɛ ntswe bɨ ŋwàꞌànə̀ a nɨ nɔ̀ŋsə̀ M̀màꞌàmbî aà, “M̀fòò àjɛ̀ɛ̀ mâŋgyɛ̌ ntsɨ̀m yìi à nɨ mûmbâŋnə̀ aa, bɨ ntswe nɨ̂ ǹlə̀ə̂ yi nɨ̂ àyàrə ayoo a mbô M̀màꞌàmbî.” ");
INSERT INTO bfd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bo lɛ ŋghɛ̀ɛ̀ aa ta ɨ kɨɨ màꞌà Nwî, “nɨ bɨ̀bugɨ̀rəmɨ̀kuu bi baa bo bɨ̀ bɨ̀tsɔꞌɔ bî kə̀gə bi baà.” Ɨ yòŋə̀ nɨ̂ àjàŋ yìi mə nɔ̀ŋsə̀ Nwì à lɛ ndɨ̀ꞌɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ŋù yì mɔ̀ꞌɔ à lɛ ntswe a Yerusalem, ɨ̀kǔm yi ɨ bə Simon, a bə ŋù yìi mə mɨ̀nnû mi lɛ ntsinə, a kɨɨ̀ bɔꞌɔ nɨ̂ Nwî. Àzwì Nwî a tswê ghu nu, a yuꞌutə̀ nɨ̂ noò yìi mə Nwìŋgɔ̀ŋ à ka yǐ ləꞌətə mɨntɨɨ mɨ baIsrael aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lɛ boŋ Àzwì Nwî a lɛɛ̀ ǹdɨꞌɨ ghu mbo mə à ka yǐ yə Àyɔꞌɔ̀ Nwì M̀màꞌàmbi wa ɨ bɔ̌ŋ kwo. ");
INSERT INTO bfd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Àzwì Nwî a lɛ tintə yi mə tâ à zi a ndâmàꞌanwì maa njwi mə bɨ lɛ nzì nɨ mu wa aà. Ta bɨ̀ Yesu nɨ̀ ǹdè yì bɨ zì mə̂ nɨ ghu a nlwensə nɔ̀ŋsə̀ aa ");
INSERT INTO bfd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","a ŋɛɛ̀ yi ntugɨtə a mbo yu, ŋ̀ghaꞌasə Nwî ǹswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“M̀màꞌàmbî, màꞌàtə tâ àbùꞌû yô tâ à ghɛɛ nɨ̂ m̀bɔɔnə nyòŋə nɨ nɨ̀ghàa nô; ");
INSERT INTO bfd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ǹloŋ mə miꞌì ma mɨ yə̀ mə̂ ànnǔ nyweensə bə̀, ");
INSERT INTO bfd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yìi mə ò tàŋtə̀ mə̂ ǹləə a nsi miꞌi bə̀ bɨ̀tsɨ̀mə̀ aà, ");
INSERT INTO bfd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","a bə̂ ŋ̀kàꞌà a ŋka ndɨ̀ꞌɨ mânjì ghò a mbo bə̀ bɨ ɨtoo dàŋ, ɨ zì nɨ nɨghaꞌa a mbo bə̂ bo baIsrael aà.” ");
INSERT INTO bfd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taà yì bô ǹdè yì bɨ lɛ nyɛrə nloŋ annù yìi mə bɨ lɛ nswoŋ mbɨꞌɨ ŋgaà yì aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simon a tɨgə̀ ǹnɨŋ mbɔɔnə a nu bo nswoŋ a mbo Mary, ndè yì, mə, “Mu ghùlâ à ka yǐ ghɨ̀rə̀ tâ bə̀ bî ghàꞌàtə̀ wo, ɨ kɨ ŋɛntə bî ghàꞌàtə a alaꞌa baIsrael. À ka yǐ bə alènsə̀ yìi mə bə̀ ka yǐ tɨgə ŋghàa nloŋ ŋgaà yì, ɨ tuu nɨ̂ ànnû yi, ");
INSERT INTO bfd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tâ munwi ǹtsò tâ à kɨ nso ntɨɨ̀ ghô. Tâ ɨ̀nnù jìi mə bə̀ bî ghàꞌàtə̀ mɔ̀ɔ̀ntə a mɨ̂ntɨɨ bo aa, tâ bɨ̀ ghɨrə tâ ɨ̀ fɛꞌɛ nlaa.” ");
INSERT INTO bfd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ŋ̀gàŋtoò Nwì yî màŋgyɛ̀ yî mɔ̀ꞌɔ à lɛ ntswe ghu, ɨ̀kǔm yi ɨ bə Anna, a bə mu Fanuel, yìi mə à lɛ nlǒ a ŋgwɛ̀ꞌɛ Asher aà. A tɨ bə aa boŋ à lwèn mə̂. À lɛ nyɔꞌɔ ntswe bô ǹdoò yì tsiꞌì ɨ̀lòò ji sàmbaa a kwô. ");
INSERT INTO bfd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A tɨgə̀ ǹtswe tsǒ ŋ̀kwiꞌi màŋgyɛ̀ ɨ ɨlòò mɨghum mi nɨfwaa ǹtsò ji nɨkwà. Kaa à lɛ kɨꞌɨ̀ nìi ndâmàꞌanwì m̀màꞌàtə̀, ŋ̀ghaꞌasə nɨ̂ Nwî, ǹsiꞌisə nɨ̂ ɨ̀bɨɨnû yi tɨ jɨ, ntsàꞌàtə̀ nɨ̂ Nwî a nɨ̂tugə bo bɨ̀ a siꞌinə. ");
INSERT INTO bfd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","À lɛ ŋkɨ nzi tsiꞌì maa bàŋtə̀ noò, m̀fa mbɨꞌɨkə a mbo Nwì, ŋ̀ghaa nloŋ ŋgaa mu wâ, a mbo bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ sɨ bɛ nɨ mə tâ Nwìŋgɔ̀ŋ à tsuꞌu atu Yerusalem aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nòò yìi mə bo lɛ ŋghɨ̀rə ɨnnù tsɨ̀m ǹyoŋə nɨ nɔ̀ŋsə̀ M̀màꞌambi aa, bo lɛ mbù mbɨɨ fu a Galilea, ŋghɛɛ a nɨkurə bo a Nazareth. ");
INSERT INTO bfd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mu wa à lɛ ntɨgə ŋkwe, ntswe nɨ mɨ̀tɨ̀ɨ̀, ŋ̀kɨ nluu nɨ mɨ̀tsyɛ̀; ɨ̀bɔ̀ŋ Nwî ɨ tswê ghu nû. ");
INSERT INTO bfd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taà yì bô ǹdè yì lɛ sɨ kɔꞌɔ nɨ a Yerusalem a atû àlòò a atû àlòò a noò ɨ̀kòò Passa. ");
INSERT INTO bfd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nòò yìi à lɛ mbə ɨ̀lòò nɨghûm ǹtsò baa aa, bɨ lɔgə̀ yi bo bo kɔꞌɔ ŋghɛ̀ɛ̀ ghu tsiꞌǐ ajàŋ yìi bɨ lɛ sɨ ghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bo màŋsə̀ mə ɨkòò wa ŋka ŋkwɛɛ, mu wa, làꞌà Yesu, a benə̀ ǹtswe a njɨ̀m a Yerusalem, kaa taà yì bô ǹdè yì waꞌà zî. ");
INSERT INTO bfd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lâ bo lɛ sɨ waꞌatə nɨ mə à tswe a tɨtɨ̀ɨ bə̀ bìi mə bo bo lɛ sɨ zìnə̀ aà, ntɨgə ŋghɛɛ, ntəə nɨtəə nɨ jwi yì m̀fùùrə; ǹlɔɔ yi a mbɛ̀ɛ ɨ̀kàꞌâ jyaa bo bɨ̀ ŋ̀gǎŋgwɛ̀ꞌɛ jyaa. ");
INSERT INTO bfd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bo lɔ̀ɔ̀ mə̂ yi kaa waꞌà yə, mbu mbɨ̀ɨ̀ fu a Yerusalem a nlɔ̀ɔ̂ yi ghu. ");
INSERT INTO bfd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ǹjwî ɨ̀ tɨ̀ mə̂ tɨ tsyà ji tarə, bɨ yə̂ yi a ndâmàꞌanwì a tswê a tɨtɨ̀ɨ bɨ̀dɨ̀ꞌɨ̀ bɨ ɨ̀nnû, ǹyuꞌutə nɨ̂ ànnù yìi mə bo lɛ sɨ swoŋ aa, ŋkɨɨ mbetə nɨ̂ ɨ̀betə̀ a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ nyuꞌu ànnù yìi mə à lɛ sɨ ghàà aa, bɨ lɛ nyɛrə nloŋ mɨtsyɛ̀ mìi mə à lɛ ntswe nɨ mu aa, bo bɨ̀ ɨ̀kwiꞌi jìi à lɛ sɨ fa aà. ");
INSERT INTO bfd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nòò yìi mə bɨ lɛ nyə yi aa, ànnù lɛ ntsyà waa, ǹdè yì a swoŋ ghu mbo mə, “Mû ghà, ò ghɨ̀rə nɨ̀ bìꞌì lâlà aa a ya lɛ? Ye ajàŋ mə ò fa ŋgɨꞌɨ a mbo bìꞌi taà ghò, bìꞌì ghaà ǹlɔɔ nɨ̂ ghô aà.” ");
INSERT INTO bfd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A kwiꞌi a mbo bo mə, “Nɨ ghɨ̀rə̀ ŋ̀ghaa nlɔɔ nɨ̂ gha aa a ya lɛ? Nɨ̀ sɨ̀ zi mə a kuꞌunə a mbo mə̀ mə tâ mə̀ tswe a nda Taà ghà aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lâ, kaa bo lɛ ŋwaꞌǎ njiꞌì ànnù yìi mə à lɛ sɨ swoŋə a mbo bo aa naŋsə̀ ǹzi. ");
INSERT INTO bfd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","À lɛ nlò ǹyoŋə waa bo bo sɨgə ŋghɛ̀ɛ̀ fu a Nazareth. A tɨgə̀ ǹyuꞌunə nɨ̂ waa. Ǹdè yì à lɛ naŋsə nləə ɨnnù ma jû tsiꞌì tsɨ̀m a mûm ǹtɨɨ yu. ");
INSERT INTO bfd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu à lɛ ntɨgə ŋkwe nɨ mɨ̀tsyɛ̀ bo bɨ̀ àjɨ̀ŋə nû, Nwìŋgɔ̀ŋ bo bɨ̀ bə̀ kɔ̀ŋə̀ nɨ yi. ");
INSERT INTO bfd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","À lɛ mbə nɨ̂ ɨ̀lòò jìi mə ɨ lɛ nyweꞌe nɨghûm ǹtsò ǹtaà a noò yìi mə Tiberias à lɛ mbə Kaisa aa, Pontius Pilate a bə Gumnaa a Yudea, Herod a saꞌà nɨ̂ Galilea, mumaà yi Philip a saꞌà nɨ̀ Ituria, nɨ Trachonitis Lysanias a saꞌà nɨ̀ Abilene, ");
INSERT INTO bfd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas bo Kaifas bə̂ ŋ̀gǎŋmàꞌa Nwì jî wè; nɨ̀ghàà nɨ Nwî nɨ lɛ nzì a mbo Jɔn mu Zecharias a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀, ");
INSERT INTO bfd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","a tɨgə̀ ŋ̀karə ɨbuꞌù ɨtoò tsɨ̀m jìi ɨ lɛ ntswe a Jordan aa, ǹswoŋə nɨ mə tâ bə̀ bəŋkə mɨ̂ntɨɨ̀ myaa, ŋkwɛrə ŋkì tâ bɨ̀ liꞌinə ɨfansənnù jyaa. ");
INSERT INTO bfd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","À lɛ sɨ ghɨ̀rə̀ ma laà a bə aa ajàŋ yìi mə bɨ ŋwaꞌanə a mûm àŋwàꞌànə ŋgàŋntoò Nwì Yesiah aa mə, “Ǹjì ŋù ɨ tɔŋnə nɨ a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ ǹswoŋə nɨ mə, ‘Nɨ̀ naŋsə a mânjì M̀màꞌàmbi, ǹnaŋsə ɨyaà ji tâ ɨ̀ tsinə, ");
INSERT INTO bfd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nwì à ka tsɨrə ɨdɨgə mɨbɔrə ɨ̀ tsɨ̀m, ɨ kɨɨ sɨgɨsə mɨntaꞌa mì wə̀ bo bɨ̀ mì kə̀gə mɨ̀tsɨ̀m, ɨ ghɨ̀rə tâ ɨ̀dɨ̀gə̀ jî ŋɔ̀rɨ̀kə̌ tsɨ̀m tâ ɨ̀ tsinə. Ɨ lwensə mɨbɨrə mɨ̀tsɨ̀m tâ mânjì à laanə. ");
INSERT INTO bfd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tâ mu ŋǔ ntsɨ̀m tâ à yə ajàŋ mə Nwì a yweensə bə̂ aà.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ǹnɔ̀ɔ̀ bə̂ yî ghàꞌàtə̀ ɨ lɛ sɨ zì a Jordan mə tâ Jɔn à murə waa a ŋkì. A swoŋ a mbo bo mə, “Bù bɔɔ bɨ nô, a ghuu aa a wàꞌàsə wò mə tâ nɨ̀ khə alwintɔŋə Nwî yìi mə a zì aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tâ nɨ̀ ka ŋkoonə mɨ̂ntà mìi mə mɨ dɨ̀ꞌɨ mə nɨ̀ bə̀ŋkə̀ mə̂ mɨ̂ntɨɨ̀ muu mmaꞌatə ɨbɨ̂ ghuu. Ǹtsuu ɨ kɨ swoŋə nɨ mə, ‘Taà yìꞌì à nɨ aa Abraham’. Mə̀ swoŋ a mbo bù mə Nwì à zî àjàŋ mə mbə yu bəŋkə̀ ŋ̀gɔ̀ꞌɔ̀ jû ɨ tɨgə̀ m̀bə bɔɔ bɨ Abraham. ");
INSERT INTO bfd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tsiꞌì tsɨ̀tsɔ̀ŋ wa bɨ nɔ̀ŋsə̀ mə̂ ǹjàà ǹlɔɔ nɨ̂ ŋ̀wâ ɨtì ghu tsiꞌǐ mɨ̂ŋgàŋ! Ɨ̀tǐ tsɨ̀m jìi mə kaa ɨ sɨ mɨ̂ntà mî sɨgɨ̀nə̀ koonə aa, bɨ ka wǎ mmàꞌa a mɔꞌɔ tâ ɨ̀ khɨ.” ");
INSERT INTO bfd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ǹnɔ̀ɔ̀ bə̂ wa ɨ betə̀ yi mə, “Bìꞌì ka tɨgə ghɨ̀rə̀ aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A kwiꞌi a mbo bo mə, “Ŋù yìi mə à tswe nɨ ɨ̀tsə̀ꞌə̀ ji baa aa, tâ à fa yî mɔꞌɔ a mbo ŋù yìi mə kaa à sɨ̀ nɨ̂ yi tswê aà. Ŋù yìi à kɨ ntswe nɨ mɨ̀jɨ aa, tâ à ka nyatə a mbo bə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ŋ̀gǎŋkwɛrə tax ɨ lɛ ŋkɨ nzi mə bɨ̀ murə waa a ŋkì, m̀betə yi mə, “Ǹdɨ̀ꞌɨ̀nnù, bìꞌì ghɨrə yìꞌi ŋgaa mə akə lɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A kwiꞌi a mbo bo mə, “Nɨ̀ ka ŋkwɛrə tsiꞌì àyoo yìi nɨ̀ tswe nɨ̂ ŋ̀kwɛ̀rə aa, ǹtsuu kɨ kwɛrə ɨ tsyà.” ");
INSERT INTO bfd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bɨ̀sogyɛ̀ lɛ ŋkɨ mbetə yi mə, “Ŋ̀gaà yìꞌì ɨ̀ bə la aa ɛ? Bìꞌì ka ghɨ̀rə mə akə aa ɛ?” A kwiꞌi a mbo bo mə, “Nɨ̀ tsuu njoo bə̂ nɨ fɨ̀kɔ̀rə̀ ɨ kɨ twɛɛ kwɛrə. Ǹtsuu ɨbaŋnənnù a atu bə̀ kɨ tswɛɛ, ɨ kwɛrə nɨ̂ ǹjoò jyaa, ŋ̀kɨ mbeentə mə ŋ̀kabə yìi mə bɨ tu ghuu ghu aa ɨ̀ kùꞌùnə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Àjàŋ mə bə̀ bya bɨ lɛ sɨ waꞌatə mə ànnù yî wè yî mɔꞌɔ a ka fɛ̀ꞌɛ̀ aa, bo bɨ̀tsɨ̀m lɛ sɨ tɨgə mbetə nɨ̂ ɨ̀betə̀ ǹloŋ ŋgaa Jɔn mə à laà m̀bə yu mbə Ayɔꞌɔ̀ Nwì wa aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jɔn a fâ àkwiꞌi a mbo bo bɨtsɨ̀m mə, “Mə̀ murə ghuu aa a ŋkì, lâ ŋù yì mɔ̀ꞌɔ à tswe ghu yìi mə a yòŋə a njɨ̌m mə, à kɔ̀ꞌɔ̀nə ntsyà gha, kaa mə̀ tɛꞌɛ̀ kɨꞌɨ̀ kùꞌùnə̀ mə mbə mə̀ fɛɛ̀ mɨ̀ŋkɨ̀rə̀ mɨ ntâm mi bə̂. À ka yǐ kɨ murə ghuu aa a mûm Àzwì bo bɨ̀ a mum mɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Àyoo nsəgə mɨ̀sàŋ a tswe ghu abo, à ka səgə mɨ̂sàŋ mya ɨ tii ntsàꞌa tsɨ̀m fiꞌisə ɨ tɨgə ghotə mɨsàŋ mya a mûm àta yu, ɨ bàŋnə tɔɔ ntsàꞌà jya a nɨ mɔꞌɔ yìi mə ɨ khɨ kaa waꞌà m̀mɛ̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma mùu ajàŋ Jɔn à lɛ sɨ dɨꞌɨtə waa nɨ bɨ̀mânjì bî ghàꞌàtə̀ ǹswoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya a mbo bə̀. ");
INSERT INTO bfd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lâ, Jɔn à lɛ ŋghààntə Herod yìi à lɛ mbə Gûmnàà aa nloŋ mə à lɛ ŋkwɛrə Herodias, ŋgwɛ̂ ǹdɨ̂m yì, ŋ̀kɨ ŋghɨrə ɨnnù jî bɨ jì ghàꞌàtə̀ jî mɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod a kuꞌùsə̀ m̀bu ŋghɨ̀rə̀ bə̂ ànnù yî tɨ̀nsə̀, ǹtswa Jɔn m̀fɨɨ a ndâtsaŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nòò yìi mə bɨ lɛ murə bə̀ bɨtsɨ̀m a ŋkì aa, Yesu à lɛ ŋkɨ nzi bɨ murə̀ yi a ŋkì. Bɨ mùrə̀ mə̂ yi a kâ ǹtsaꞌatə Nwî, àbùrə̀ a ŋaꞌanə̀. ");
INSERT INTO bfd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Àzwì Nwî a lô a aburə nsɨgə ntəə ghu atu mbə tsǒ bugɨrəmɨ̀kuù. Ǹjì ɨ lô a aburə ŋghaa nswoŋ mə, “Ò nɨ mû ghà yî m̀bàŋnə̀ yìi mə mə̀ kɔ̀ŋə aà, mə naŋsə ndorɨtə nloŋə ghô.” ");
INSERT INTO bfd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu à lɛ ŋka nlɔgɨnə ɨfàꞌà yi aa boŋ à bə̀ mə̂ ɨ̀lòò mɨghum mi ntarə̀, bə̀ waꞌatə̀ nɨ mə à nɨ mu Joseph yìi mə ");
INSERT INTO bfd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A bə mu Matthat, ");
INSERT INTO bfd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A kɨ̂ mbə yî Mattias, a bə yì Amos, ");
INSERT INTO bfd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a bə mu Maaf, ");
INSERT INTO bfd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a bə mu Joanan, mbə yî Rhesa ");
INSERT INTO bfd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mbə yî Melchi, ");
INSERT INTO bfd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mbə yî Joshua, mbə yî Eliezer, ");
INSERT INTO bfd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a bə yì Simeon, ");
INSERT INTO bfd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a bə mu Melea, a bə yì Menna, ");
INSERT INTO bfd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","a bə mu Jesse, ");
INSERT INTO bfd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mbə mu Amminadab, mbə mu Admin, mbə yî Arni, ");
INSERT INTO bfd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mbə mu Yakob, ");
INSERT INTO bfd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a bə mu Serug, mbə mu Reu, ");
INSERT INTO bfd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mbə mu Cainan, ");
INSERT INTO bfd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a bə mu Methuselah, mbə mu Enoch, ");
INSERT INTO bfd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","a bə mu Enos, ");
INSERT INTO bfd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu a lô wa ŋkǐ Jordan, Àzwì Nwî a luu ghu nu, nlɔgə yi ntsyasə a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ ");
INSERT INTO bfd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","a tswê ghu mɨtugə mɨ njwi mɨ̀ghum mi nɨkwà, Devil a kwàꞌànə̀ yi. A nɨ ǹdùu njwi mà jû, kaa à lɛ ŋwaꞌǎ ayoò tsu jɨ̂; ǹjwi jya mɨghum mi nɨkwà kà maa ntsya, ǹjì ɨ yaŋə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Devil a swoŋ ghu mbo mə, “Mbə ò bə Mu Nwì, ò swoŋ a mbô ŋ̀gɔ̀ꞌɔ̀ yû mə tâ ɨ̀ bəŋ ntɨgə abaà.” ");
INSERT INTO bfd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu a kwiꞌi ghu mbo mə, “Bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ Nwî mə, ‘kaa ŋù à sɨ ntɨ̀ɨ̀ tswe nloŋ aa tsiꞌì àbaa yuyu bə̂.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Devil a bû ǹlɔgə yi ŋkɔꞌɔ ŋghɛɛ nɨ ghu a ndəŋ, ndɨꞌɨ ɨtoò tsɨ̀m jìi mə bɨ̀fɔ̀ bɨ mbi bù saꞌa aa ghu mbo tsiꞌǐ nɨ mû ǹtsirə̀ nòò, ");
INSERT INTO bfd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ǹswoŋ ghu mbo mə, “Mə̀ ka fa adaꞌa a mbo wò mə tâ ò ka mbuꞌutə ɨtoo mà jû tsiꞌì tsɨ̀m tâ ɨ̀ kɨ ŋka ŋghaꞌasə nɨ̂ ghô; ǹloŋ mə bɨ fà mə ɨtoo mà jû tsiꞌì tsɨ̀m a mbo mə̀, mə̀ tswê nɨ̀ mɨ̀dàꞌà a mfa a mbo ŋù yìi mə mə̀ kɔ̀ŋə aà. ");
INSERT INTO bfd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tsɨ̂tsɔ̀ŋ, m̀bə ò bii mə ò ka mii gha, boŋ mə̀ ka fa ɨtoo mà jû tâ ò tɨgə mbuꞌutə.” ");
INSERT INTO bfd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu a kwiꞌi ghu mbo mə, “Bɨ ŋwaꞌanə a mûm àŋwàꞌànə Nwì mə, ‘Ka mii tsiꞌì M̀màꞌàmbî Nwìŋgɔ̀ŋ ghò, ŋ̀kɨɨ ŋka mfaꞌa tsiꞌì ghu mbo yuyu.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Devil a bû ǹlɔgə Yesu ŋghɛɛ nɨ ghu a Yerusalem, ǹtɛꞌɛ yi wa atu nɨdòò nɨ ndâmàꞌanwì, ǹswoŋ ghu mbo mə, “Mbə ò bə Mu Nwì, ò tsɔꞌɔnə̀ ǹlo fàa atu nda nnàŋə a nsyɛ̂; ");
INSERT INTO bfd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ǹloŋ mə bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ Nwî mə, ‘Nwì à ka swoŋ a mbo baangel bi nloŋə gho mə tâ bɨ̀ ka mbɛ nɨ̂ ghô,’ ");
INSERT INTO bfd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ŋ̀kɨ mbu nswoŋ mə, ‘Bo ka tɨgə ŋɛɛ gho ɨ tugɨtə a mbo bo a ndəŋ mbɨ̀ꞌɨ̀ ò tumə̀ àkòrə̂ yo a nɨ̂ ŋ̀gɔ̀ꞌɔ̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu a kwiꞌi ghu mbo mə, “Àŋwàꞌànə̀ Nwî a swoŋ mə, ‘Tsùu a Mmàꞌàmbî Nwɨ̀ŋgɔ̀ŋ ghǒ kwàꞌànə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nòò yìi mə Devil à lɛ màŋsə a ŋkwàꞌànə Yesu aa, à lɛ mmàꞌàtə̀ yi ŋghɛɛ yi, nyweꞌe a noò yìi mə à lɛ mbù ntswe nɨ̂ àbwarə yî dàŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu a màꞌàtə̀ m̀bu mbɨ̀ɨ̀ fu a Galilea, nluu nɨ mɨ̀dàꞌà mɨ Azwì Nwî. Ŋ̀gàn ǹloŋ ŋgaa yì ɨ ghɛɛ̀ nɨ̂ ɨ̀dɨ̀gə tsɨ̀m jìi mə ɨ lɛ ŋkarɨsə Galilea aà. ");
INSERT INTO bfd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu a ghɛɛ̀ nɨ̂ m̀bìì ǹtɨgə ndɨꞌɨ nɨ̂ ànnù Nwî a ndâŋghòtə baYuda, bə̀ bɨtsɨ̀m bɨ ghaꞌasə̀ nìi. ");
INSERT INTO bfd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu a ghɛɛ̀ a Nazareth a adɨgə yìi mə à lɛ ŋkwe ghu aà; à ghɛ̀ɛ̀ mə̂ aa ŋkuu a ndâghòtə a ajàŋ yìi mə à lɛ sɨ ghaꞌasə ŋghɨrə a njwîŋ̀gɔ̀ŋ aà, m̀bɨɨnə ntəə a ndəŋ a ntwoŋ nɨ̀ghàà nɨ Nwî, ");
INSERT INTO bfd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","bɨ fâ àŋwàꞌànə ŋgàŋntoò Nwì Yesaiah ghu mbo, a ŋaꞌà àŋwàꞌànə̀ ya, nyə adɨgə ya yìi mə bɨ lɛ ŋŋwàꞌànə̀ ghu mə, ");
INSERT INTO bfd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Àzwǐ Mmàꞌàmbi a tswe a nu mə̀, ǹloŋ mə à tsɔ̀ꞌɔ gha mə mə̀ mə̀ ka nswoŋ ntoo yì ǹsɨgɨ̀nə̀ a mbô ŋ̀gàŋə̂fum. À tòo gha mə tâ mə̀ kɛꞌɛnə a mbo ŋ̀gàŋətsaŋ mə bɨ ka fiꞌisə waa, ɨ kɨɨ swoŋə a mbo bɨ̀fə̀ꞌə̀nə̀ mə tâ bɨ̀ ka nyə ɨdɨgə. Bə̀ bìi mə bɨ nɨꞌɨ nɨ̂ waa laa bɨ ka kɛntə a nɨ̀ꞌɨ bo, ");
INSERT INTO bfd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ɨ kɨɨ kɛ̀ꞌɛ̀nə̀ a mbo bə̀ mə nòò yìi mə Mmàꞌàmbî à ka ghɨ̀rə ɨ̀bɔ̀ŋ a nu bo aà à kùꞌù mə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","À màŋsə̀ mə̂ aa, ŋkusə àŋwàꞌànə̀ ya mfa fu a mbo ŋgàŋàfàꞌà ǹdâŋghotə wâ, ǹtɨgə ntswe a nsyɛ̂. Miꞌi mɨ bə̂ bɨ̀tsɨ̀m wa nda mɨ bəŋkə̀ ǹtɨgə nlii nìi. ");
INSERT INTO bfd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A lɔ̀gɨ̀nə̀ ǹtɨgə nswoŋ a mbo bo mə, “Sìi, ànnù yìi mə bɨ ŋwaꞌanə fàa adɨgə aŋwàꞌànə̀ aa, a fɛ̀ꞌɛ̀ mə̂ mboontə nɨ̀ yuꞌù.” ");
INSERT INTO bfd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bə̀ bɨtsɨ̀m bɨ lɛ sɨ tɨgə nswoŋ ɨnnù jî sɨgɨ̀nə̀ ǹloŋ ŋgaà yì. Ŋ̀kɨɨ yɛrə nɨ mɨ̀ghàà mɨ mbɔɔnə mìi mə lɛ sɨ fɛ̀ꞌɛ̀ ghu ntsù aà; ǹtɨgə nswoŋ nɨ mə, “À sɨ̀ tsiꞌì mu Joseph wa à ghuà bə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu a swoŋ a mbo bo mə, “ Mə̀ zi mə nɨ̀ ka swoŋ nɨghàà nî nǎnaa nuà a mbo mə̀, ‘Dokta, tsuꞌu ɨbɨ̀ɨnû ghô; ɨ ghɛ̀ɛ̀ nɨ̂ m̀bìì swoŋ mə tâ mə̀ kɨ ŋghɨrə ɨnnù jî yɛ̌yɛrə jìi mə nɨ̀ kɨ̀ yuꞌu mə mə̀ kɨ̀ ghɨ̀rə a Kapernaum aa, fàa nɨkurə bù.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu a ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ mə, “Tsiꞌǐ annù nɨ̂ŋkòŋ, mə̀ swoŋ a mbo bù mə kaa bɨ sɨ ŋgàŋntoo a alaꞌa bo bii. ");
INSERT INTO bfd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","La mə̀ swoŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, bɨ̀kwìꞌì bɨ bâŋgyɛ̀ bî ghàꞌàtə̀ bɨ lɛ ntswe a alaꞌa Israel wa noò Elijah, mə Nwì a lɛ ntsetə aburə atu ɨ̀lòò ji tarə nɨ bɨ̀sàŋ bi ntoꞌo, kaa mbə̀ŋ waꞌà loo, mɨ̀kwenə̀ yî ǹtɨ̀ɨ̀ a kuu wa alaꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kaa Nwì à lɛ waꞌǎ Elijah a mbo ŋù dàŋ too ntsyatə mâŋgyɛ Zarephath yuyu yìi mə à lɛ ntswe a alaꞌa Sidon, mbə ŋkwiꞌi màŋgyɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ŋ̀gàŋəkɨ̀kwen ɨ lɛ ntswe a alaꞌa Israel ŋghaꞌa wâ noò ŋ̀gàŋntoò Nwì Elisha; a kɨ̂ mmɛ tsiꞌì Naaman, ŋù baSyria yìi mə bɨ lɛ ghùrə akɨ̀kwen yi.” ");
INSERT INTO bfd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntswe wa ndâŋghòtə aa, bɨ yùꞌù mə annù yìi mə Yesu à swòŋ aa, ǹtɔ̀ŋə̂ waa ɨ naŋsə̀ ǹlwi, ");
INSERT INTO bfd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","bo bɨɨ̀nə̀, ǹtii yi mfɛꞌɛ nɨ ghu wa mûm àlaꞌa bo, ǹlɔgə yi ŋkɔꞌɔ ŋghɛɛ nɨ ghu a mbɛ̀ɛ̀ ntaꞌa yìi mə bɨ̀ lɛ mbɔɔ alaꞌa ya ghu aà, a adɨgə yìi mə mbaa ɨ lɛ ntswe ghu aa mə bɨ bɨŋsə yi ghu. ");
INSERT INTO bfd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","La Yesu a bâŋnə̀ ǹtsya a tɨtɨ̀ɨ bo ŋghɛɛ yi. ");
INSERT INTO bfd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu a maꞌàtə̀ ǹsɨgə ŋghɛɛ a Kapernaum, yìi mə à nɨ njɔ̀ꞌɔ̀ àlaꞌa yì mɔ̀ꞌɔ a Galilea aà. À bə a njwîŋgɔ̀ŋ a ghɛɛ̀ ŋ̀ka ndɨꞌɨ nɨ̂ ànnù Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bə̀ yɛrə̀ a ajàŋ yìi mə à lɛ sɨ dɨ̀ꞌɨ̀ aà, ǹloŋ mə nɨ̀ghàà ni nɨ lɛ ntswe nɨ àdàꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ŋù yî mɔ̀ꞌɔ à lɛ ntswe wa ndâŋghòtə mə à lɛ ntswe nɨ̂ àzwì demon yî bɨ̂. À yə̀ mə̂ Yesu aa, nyəꞌə tsiꞌì nɨ̀ ǹjì yî ǹtɨ̀ɨ̀, ǹswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah! Màꞌàtə̀ yiꞌi! Ò tswe aa nɨ̂ àkə̀ biꞌinə̀, a Yesu, mu Nazareth? Ò zi aa a ntâ ŋ̀gɨꞌɨ a nu bìꞌì aa ɛ? Wa mə̀ zi ŋû yìi mə ò nɨ ghu aà. Ò bə aa Yu wa yìi mə à Laa màŋsə̀, ǹlo a mbo Nwì aà.” ");
INSERT INTO bfd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","La Yesu a wenə̀ yi nswoŋ mə, “Kutə ntsû ghô, fɛ̀ꞌɛ̀ ghu nû!” Àzwì yî bɨ ya a maꞌà ŋû wa a nsyɛ a tɨtɨ̀ɨ bo, m̀fɛꞌɛ ghu nû, la kaa waꞌà yi bâŋnə̀ ǹləənsə. ");
INSERT INTO bfd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bə̀ bɨ̀tsɨ̀m bìi bɨ lɛ ntswe wa nda aa, bɨ yɛrə̀ ǹtɨgə nswoŋə bo nɨ bo mə, “Àa ajàŋə mbuu nɨghàa akə a yuà aa ɛ? Ǹloŋ mə à wenə ɨzwì jî bɨ nɨ̀ àdàꞌà bo bɨ̀ mɨ̀tɨ̀ɨ̀ ɨ fɛꞌɛ̀kə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ŋ̀gàn yì ɨ̀ lɛ ŋghɛ̀ɛ̀ a ɨdɨgə tsɨ̀m maa mbùꞌù àlàꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu a maꞌàtə̀ ǹdâŋghòtə ya ŋghɛ̀ɛ̀ ŋ̀kuu a nda Simon. Maa noò nɔ̂ŋsə Simon a tswê nɨ fibà yî ǹtɨ̀ɨ̀. Bɨ twoŋə̀ yi mə tâ à zi ŋkwɛtə yi. ");
INSERT INTO bfd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu a zî ǹtəə wa mbɛ̀ɛ̀ ɨ̀kùu màŋgyɛ̀ wa, ŋwenə fibà wa nswoŋ mə tâ à maꞌatə yi. À swòŋ mə̂ tɨ màŋsə̀ aa fibà wa a maꞌatə mâŋgyɛ̀ wa a burə̀ m̀bɨɨ̀nə̀ ntɨgə nlɔɔ mɨjɨ fa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nòò à kà mə̂ aa ntso, bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntswe nɨ ŋ̀gàŋmɨghɔ̀ɔ̀, jìi mə ɨ lɛ tswe nɨ mɨ̀ghɔ̀ɔ̀ tsiꞌǐ ɨbəŋ ɨbəŋ aa, bɨ lɔgə̀ ǹzi nɨ ju a mbo Yesu; a nɔ̂ŋsə̀ m̀bô mi a atu bo yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ, ŋghurə waa. ");
INSERT INTO bfd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɨ̀zwì jî bɨ ɨ lɛ ŋkɨ mfɛꞌɛ a atoꞌo bì ghàꞌàtə̀, ǹyəꞌənə mə, “Ò laa mbə Mu Nwì!” Lâ Yesu a wenə̀ waa kaa waꞌà màꞌàtə̀ mə tâ bo ghaa nloŋ mə ɨ̀zwì jya ɨ lɛ nzi mə Yesu à laa mbə Ayɔꞌɔ̀ Nwì wâ. ");
INSERT INTO bfd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Àbɛ̀ɛ̀ a kà mə̂ aa mfuꞌu Yesu a maꞌàtə̀ mûm àlaꞌa ya ŋghɛ̀ɛ̀ a adɨgə yìi kaa bə̀ lɛ ŋwaꞌà ghu tswê. Bə̀ bya bɨ tɨgə̀ ǹlɔɔ nìi, ŋghɛɛ nyə adɨgə yìi mə à lɛ ntswe ghu aa, kaa waꞌà bù mbii mə à maꞌatə waa. ");
INSERT INTO bfd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","La Yesu a swoŋ a mbo bo mə, “Mə̀ tswe nɨ̀ ŋ̀ka nsɛ̀ɛ̀nsə ntoo yì ǹsɨgɨ̀nə̀ ǹloŋə annù nɨfɔ̀ Nwî ya a mɨkurə mi mɔꞌɔ̀; ǹloŋ mə à nɨ̂ ǹjiꞌì ànnù yìi mə bɨ lɛ ntoo gha fàa mbi ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Maa ajàŋ a tɨgə̀ ŋ̀ghɛɛ ntɨgə nswoŋə nɨ̂ ànnù Nwî a mûm ndaŋghòtə jìi ɨ lɛ ntswe a Yudea aà. ");
INSERT INTO bfd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yesu à lɛ ntəə a mbɛ̀ɛ àtsùmə ntaꞌa a Gennesaret, bə̀ tinə̀ ǹzi ghu mbɛ̀ɛ̀ a nyuꞌu nɨ̀ghàà nɨ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A yə̂ ɨ̀kanuꞌu ji baa ɨ tswe wa aghəŋə ŋkì jìi mə ŋgǎŋnlə̂mbwɛ̀ jìi ɨ lɛ ntswe nɨ juu aa, ɨ lɛ mmàꞌàtə̀ m̀fɛꞌɛ ŋghɛ̀ɛ̀ a nsìꞌi mbunjyâ jyaa. ");
INSERT INTO bfd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu a kuu wa mûm àkanuꞌu ya yi mɔꞌɔ yìi mə a lɛ mbə yî Simon aa, ǹswoŋ ghu mbo mə tâ à tintə nlo nɨ yu wa aghəŋə ŋkì ŋ̀kuntə nɨ yu. Yesu a tɨgə̀ ǹtswe wa mûm àkànuꞌu ntɨgə ndɨꞌɨ nɨ̂ bə̀ bya ghu. ");
INSERT INTO bfd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","À màŋsə̀ mə̂ a ndɨꞌɨ waa laa, ǹswoŋ a mbo Simom mə, “Ghɛ̀ntə a adɨgə yî tsòtə̀ m̀maꞌa mbunjya yo ya ghu tǎ ko mbwɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon a kwiꞌi ghu mbo mə, “Masa, bìꞌì ghɨrə nzwi nû yìꞌì nɨ̂tugə kàa tsiꞌì ŋ̀kô àyoò! Lâ m̀bə yìi mə â swǒŋ wô aa, mə̀ ka màꞌa mbunjya yâ.” ");
INSERT INTO bfd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bo màꞌà mə mbunjya ya maa noò aa, m̀bwɛ̀ mî ghàꞌàtə̀ mɨ kwo ghu, m̀bunjyâ jyaa jya ɨ tɨgə̀ ǹlɔɔ nàâ ǹtèèŋkə. ");
INSERT INTO bfd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bo tɨgə̀ ǹtwoŋ ŋgǎŋakòrə̂ jyaa jìi mə ɨ lɛ ntswe nɨ̂ àkanuꞌu jî mɔꞌɔ jyaa mə ɨ̀ zi ŋkwɛtə waa. Bo zî bo bo lwensə̀ àkànuꞌu jya ji baa ɨ luu, ntɨgə nlɔɔ nɨ bə̂ ǹsɨgə ŋkoŋə a mûm ŋ̀kì. ");
INSERT INTO bfd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peta, à yə̀ mə̂ ma la, ŋkenə a nsi Yesu ǹswoŋ mə, “Lò gho a mbɛ̀ɛ mə̀ m̀bâ M̀màꞌàmbî ǹloŋ mə mə̀ nɨ ŋù ŋ̀ghɨ̀rə ɨ̀nnù jî bɨ̂.” ");
INSERT INTO bfd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","À lɛ nswoŋ laa nloŋ mə annǔ kôntsù a lɛ ntswa yi bo bɨ̀ bə̀ bî mɔꞌɔ bya bìi mə bo bo lɛ ntswe aa, ǹloŋ ndùu mbwɛ̀ mya mìi mə bo lɛ ŋko aà. ");
INSERT INTO bfd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma yû a lɛ ŋkɨ mbə annǔ kôntsù a mbo Jɔn nɨ Jɛms, ŋ̀gǎŋakòrə̀ Simon ji mɔꞌɔ, bìi mə bɨ lɛ mbə bɔɔ bɨ Zebedee aà. Yesu a swoŋ a mbo Simon mə, “Tsùu kɨ bɔꞌɔ bə̂; ǹlɔgɨnə tsɨ̂tsɔ̀ŋ, ò ka tɨgə koo aa bə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bo lɛ nswuŋ ɨkànuꞌu jyaa jya mfɛ̀ꞌɛ̀sə a ntaꞌa mmàꞌatə njoò tsɨ̀m ǹtɨgə nyoŋə nɨ̂ Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu à kà mə̂ aa ŋghɛɛ wa njɔ̀ꞌɔ̀ àlaꞌa ya yì mɔ̀ꞌɔ, ŋù mɔ̀ꞌɔ a zî, yìi mə nû yì ɨ̀ lɛ nluu nɨ̂ àkɨ̀kwen aà. À yə̀ mə̂ Yesu aa, ŋ̀wò ghu nsi à kùu kuu. M̀buꞌu mbo ghu mbo nswoŋ mə, “M̀màꞌàmbî, ò bə kɔ̀ŋ boŋ, ò ghɨ̀rə nû yà ɨ laà.” ");
INSERT INTO bfd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu a nâsə̀ àbô yi mmɔɔntə yi ghu, ǹswoŋ ghu mbo mə, “Mə̀ kɔ̀ŋə̂; tâ nû yò ɨ̀ laa.” Àkɨ̀kwen ya a lɛ ŋkɨ mburə ŋghɛnsə nsɨgə ghu nû. ");
INSERT INTO bfd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu a waꞌàsə̀ yi mə tâ tsuu a mbo ŋù lǒ swoŋə; lâ m̀baŋnə nswoŋ ghu mbo mə, “Ghɛ̀ɛ ndɨ̀ꞌɨ ɨbɨɨnû gho a mbo ŋgàŋmàꞌanwì. M̀fa ayoo mmàꞌa Nwì yìi mə Moses à lɛ nlə̀ə̀ aa tǎ dɨ̀ꞌɨ a mbo bə̀ mə nû yò ɨ̀ làà mə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ka mə Yesu à lɛ nswoŋ ma mùu ajàŋ aa, ŋ̀gàn ya ɨ̀ lɛ bàŋnə̀ m̀bu sɛ̀ɛ̀nə sɛ̀ɛ̀nə. Ǹnɔ̀ɔ̀ bə̂ ɨ lɛ sɨ tɨgə nzi a nyuꞌutə̂ ànnù yìi mə à lɛ sɨ dɨ̀ꞌɨ aa, bo bɨ̀ mə tâ à ghurə mɨghɔ̀ɔ̂ myaa. ");
INSERT INTO bfd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lâ Yesu a maꞌàtə̀ waa ŋghɛɛ a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ a ntsàꞌàtə Nwì ghu. ");
INSERT INTO bfd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","À bə̀ mə a njwi yì mɔ̀ꞌɔ, Yesu a kâ ǹdɨꞌɨ annù Nwî, baPharisai bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ bɨ̀nɔ̀ŋsə̀ bìi mə bɨ lɛ nlǒ a mɨkurə mɨ̀ tsɨ̀m a Galilea nɨ Yudea, bo bɨ̀ Yerusalem aa, bɨ tswê ghù. Yesu à lɛ nluu nɨ mɨ̀dàꞌà mɨ Mmàꞌàmbi a ŋghurə mɨ̀ghɔ̀ɔ̀ ghu. ");
INSERT INTO bfd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bɨ tɨ̀ mə̂ tɨ yə bə̀ bî mɔꞌɔ bɨ zî, m̀beꞌe ŋû yì mɔ̀ꞌɔ yìi mə à lɛ mbwenkə aa nɨ fɨ̀kùù. Bo lɛ sɨ lɔ̀ɔ̀ mânjì yìi mə mbə bo tsyâ ghu ntɛꞌɛ ŋû nɨ̀ghɔ̀ɔ̀ wa a nsi Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","M̀bə yìi mə ǹnɔ̀ɔ̀ bə̂ ɨ lɛ ntswe nluu ɨdɨgə, kaa mânjì yìi mə mbə bo tsyâ ghu a waꞌà bə aa, bo lɛ ŋkɔꞌɔ a atu nda, ǹsaa nɨkàŋ, ǹtsurɨsə fɨ̀kuu fya nsɨgɨsə ntɛꞌɛ ŋû nɨ̀ghɔ̀ɔ̀ wa a nsi Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu à yə̀ mə ajàŋə abìintɨɨ yìi mə bə̀ bya lɛ ntswe nɨ yu aa, nswoŋ mə, “Ŋùmbâŋnə̀, wa bɨ lìꞌìnə̀ mə ɨfansə ɨnnù jô.” ");
INSERT INTO bfd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ŋ̀gǎŋdɨꞌɨ bɨ̀nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai bo lɔgɨ̀nə̀ ǹtɨgə mbetə mə, “Ghuù ŋù mə a ghàa mɨghàà m̀bəgɨtə nɨ̂ Nwî ghu aa à nɨ wò aa ɛ? Ŋù tsù à tswe ghu mə mbə a lìꞌìnə ɨbɨ bə̂ ǹtsyatə Nwî aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu a zî ɨ̀nnù jìi mə bo lɛ sɨ betə nɨ̂ waa bo nɨ bo aa, ŋ̀kwiꞌi a mbo bo mə, “Nɨ betə ɨbetə̀ jû a mûm ǹtɨɨ bù aa a ya? ");
INSERT INTO bfd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A laà ǹyaŋsə aa a nswoŋ mə, ‘Bɨ liꞌinə ɨ̀fansənnù jo,’ kə̀ a nswoŋ mə, ‘Bɨ̀ɨ̀nə ŋka ntəə aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lâ mə̀ ka ghɨ̀rə tâ nɨ̀ zi mə Mu Ŋù a tswe nɨ̀ àdàꞌà fàa atu nsyɛ a nliꞌinə ɨ̀fansənnù bə̂.” À ghàà mə̂ laà ǹtɨgə nswoŋ a mbo mbwènkə̀ wa mə, “Mə̀ swòŋ a mbo wò, bɨ̀ɨ̀nə̂, m̀beꞌe fɨkuù fo fya ŋghɛ̀ɛ̀ gho a nda wò.” ");
INSERT INTO bfd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","M̀bwènkə̀ wa a kɨ̂ m̀burə mbɨɨnə a nsi bo, mbeꞌe fɨkuu fya mə à ghɨ̀rə nnɔ̀ŋ ghu aa, ntɨgə ŋghɛɛ nìi a nda yu, ŋghaꞌasə nɨ̂ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ànnǔ kontsù a kô waa bɨtsɨ̀mə̀. Bo tɨgə̀ ŋ̀ghaꞌasə nɨ̂ Nwî, nɨ̀bɔꞌɔ nɨ tswâ waa, bo tɨgə̀ ǹswoŋə nɨ mə, “Bìꞌì yə̂ ɨ̀nnù jî swèrə̀ ǹswerə siì.” ");
INSERT INTO bfd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma yû ànnù a tsyà mə̂ a kâ m̀fɛꞌɛ nyə ŋû ŋ̀kwɛrə bɨ̀tax yìi mə ɨ̀kǔm yi ɨ lɛ mbə Levi aa, a tswê a nda ŋkwɛ̀rə bɨ̀tax. Yesu a swoŋ ghu mbo mə, “Zǐ ŋka nyòŋə̀ nàâ.” ");
INSERT INTO bfd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A bɨɨ̀nə̀ m̀maꞌatə njoò tsɨ̀m, ŋ̀ka yoŋə nìi. ");
INSERT INTO bfd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi a ghɛɛ̀ ŋ̀ghɨrə adìnà yî wè a nda yu a mbo Yesu. Ŋ̀gǎŋŋkwɛrə bɨ̀tax bî ghàꞌàtə̀ nɨ bə̀ bi mɔꞌɔ bɨ lɛ ŋkɨ nzi ghu bo bo tswê a atu atɛtə̀ ǹjɨ. ");
INSERT INTO bfd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","BaFarɨsai bo bɨ̀ ŋgǎŋdɨꞌɨ nɔ̀ŋsə̀ a bo lɔgɨ̀nə̀ ŋka nnurəkə nloŋ ŋgǎŋyəgə̂nnù Yesu, ǹswoŋə nɨ mə, “A ghɨ̀rə àkə̀ mə tâ ò ka njɨ ŋkɨɨ nno bu bɨ̀ ŋgǎŋkwɛrə bɨ̀tax bo bɨ̀ ŋgǎŋghɨrə ɨ̀nnù jî bɨ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu a kwiꞌi a mbo bo mə, “Bə̀ bìi mə bɨ tswe bɨ̀tɨ̀ɨ̀ aa, kaa bɨ sɨ docta lɔɔ, a docta aa a lɔ̀ɔ̀ tsiꞌì bə̀ bìi mə bɨ ghɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kaa mə̀ sɨ̀ zi aa a ntwoŋ bə̀ bìi mə ɨ̀nnù jyaa ɨ tsinə aà, mə̀ bàŋnə nzì aa a ntwoŋ ŋgǎŋghɨ̀rə ɨ̀nnù jî bɨ mə tâ bo bəŋkə mɨ̂ntɨɨ̀ myaa.” ");
INSERT INTO bfd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","BaFarɨsai bya bɨ swoŋ ghu mbo mə, “Ŋ̀gǎŋyəgə̂nnù Jɔn ɨ ghaꞌa siꞌisə mɨbɨ̀ɨ̀ mɨ nû myaa tɨ jɨ ŋkɨɨ ntsaꞌatə nɨ̂ Nwì. Ŋ̀gǎŋyəgə̂nnù baFarɨsai ɨ kɨɨ̀ ŋ̀ghɨrə malâ, lâ ɨ̀ jo ɨ bâŋnə̀ ǹjɨ ŋkɨɨ nno.” ");
INSERT INTO bfd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu a kwiꞌi a mbo bo mə, “Mbə ò ghɨrə̀ bə̀ bìi mə bɨ zi a adɨgə nɨyɔꞌɔ aa bɨ siꞌi nɨ̀ ǹjì wa noò mə ndoo mûŋgen wa à tswe a tɨtɨ̀ɨ bo aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nòò a zì mə bɨ ka lɔ̀gə ndoo mûŋgen wa lɔ̀ꞌɔ̀sə̀ tâ bo tɨgə nsiꞌisə nɨ mɨ̀bɨ̀ɨ̀ mɨ nû myaa tɨ jɨ̂ maà noò.” ");
INSERT INTO bfd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A lɛ ŋghɛ̀ɛ̀ nɨ̂ m̀bìì ŋ̀kɨ nswoŋ nɨghàà nî nǎnaa a mbo bo: “Kaa ŋù à sɨ asàꞌa àtsə̀ꞌə̀ nɨ̂ àtsə̀ꞌə̀ yî fii sàtə̀ ŋ̀kɛɛ nɨ̂ yì lwèn ghu; à bə ghɨ̀rə̀ maa ajàŋ boŋ à sàtə atsə̀ꞌə̀ yî fii ya, kaa àsaꞌa atsə̀ꞌə̀ yî fii ya bo bì yì lwèn ya kaa waꞌà bòòntə̀. ");
INSERT INTO bfd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaa ŋù a waꞌà nɨ̀ mɨ̀lùꞌù mî fii kɨɨ nlɔgə nnɨŋə nɨ ŋgùù mɨ̀lùꞌù yî ǹlwenə̀; à bə ghɨ̀rə̀ ma la boŋ mɨ̀lùꞌù mî fii mya ka bwi ŋgùù ya, ɨ saa, lɛ boŋ mɨ kɨ̀ mə̂ ǹta ŋgɨꞌɨ nɨ̂ ŋ̀gùù yâ. ");
INSERT INTO bfd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bɨ bàŋnə̀ ǹnɨŋə nɨ mɨ̀lùꞌù mî fii laa a nɨ̂ ŋ̀gùù mɨ̀lùꞌù yî m̀fiì. ");
INSERT INTO bfd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ànnù yî mɔꞌɔ a kɨ̂ m̀bə mə Kaa ŋù yìi mə à no mɨ̀lùꞌù mî lwènə̀ aa, kaa à sɨ mɨlùꞌù mî fii bù ǹlɔɔ; nloŋ mə a nswoŋə nɨ mə, ‘Mì lwèn mya mɨ bɔŋə̀.’” ");
INSERT INTO bfd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","À lɛ mbə a njwîŋgɔ̌ŋ baYuda, Yesu bo bɨ̀ ŋ̀gǎŋyegə̂nnù ji kâ ǹtsya a mûm ǹsòò mɨsàŋ, ŋ̀gǎŋyəgə̂nnù ji ɨ kyâ nɨ̀ mɨ̀sàŋ mya mi mɔꞌɔ, nnwùgə̀ ŋ̀kurə. ");
INSERT INTO bfd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","BaFarɨsai bî mɔꞌɔ bɨ betə̀ waa mə, “Nɨ̀ ghɨ̀rə annù yìi mə nɔ̀ŋsə̀ à sɨ̀ bii mə bɨ̀ ka ŋghɨrə a njwîŋgɔ̀ŋ aa a ya?” ");
INSERT INTO bfd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu a kwiꞌi a mbo bo mə, “Nɨ̀ lɛɛ̀ ŋ̀waꞌǎ annù ya mə Mfɔ̀ David a lɛ ŋghɨ̀rə̀ a noò yìi mə njì ɨ̀ lɛ nyaŋə yi bo bɨ̀ bə̀ bìi mə bo bo lɛ ntswe aa twoŋ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ajàŋ à lɛ ŋkuu a ndânwì ǹlɔgə abaa a Nwì ya ŋkurə ŋ̀kɨ mfa yî bə̂ bìi mə bo bo lɛ ntswe aa ɛ? Lâ bìꞌinə̀ zi mə nɔ̀ŋsə̀ à dɨ̀ꞌɨ mə mbə a kurə tsiꞌì ŋ̀gǎŋmàꞌanwì ŋkurə abaa ma yâ!” ");
INSERT INTO bfd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ǹtɨgə nswoŋ a mbo bo mə, “Wa Mu Ŋù à nɨ Mmàꞌàmbi yìi a asaꞌa njwîŋgɔ̀ŋə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A bû m̀bə a njwîŋgɔ̀ŋ yî mɔ̀ꞌɔ, Yesu a kuu a ndâŋghòtə ŋka ndɨꞌɨ ànnù Nwî ghu. Ŋù yì mɔꞌɔ a tswê ghu mə nɨ̀kwɛɛ̀ ni nî màꞌà nɨ lɛ ŋkwo. ");
INSERT INTO bfd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ŋ̀gǎŋdɨꞌɨ nɔ̀ŋsə̀ bo baFarɨsai bɨ lii mə bo ka yə tâ à ghurə ŋû a njwîŋgɔ̀ŋ tâ bo nɨŋ ànnù ghu nû lɛ. ");
INSERT INTO bfd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lâ à lɛ nzi ɨmmɔ̀ɔ̀ntə̂ jyaa, ntɨgə nswoŋ wa mbô àku nɨkwɛɛ wa mə, “Zǐ ntəə faà.” A kɨ̂ m̀bɨɨnə nzì ǹtəə ghu. ");
INSERT INTO bfd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu a tɨgə̀ m̀betə waa mə, “Nɔ̀ŋsə̀ à laa mbii aa mə mbə bɨ ŋghɨ̀rə aa ɨbɔ̀ŋ a njwîŋgɔ̀ŋ kə̀ ɨ̀bɨ aa ɛ? Mə bɨ̀ yweensə ŋù kə̀ mə bɨ̀ zwitə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A tɨgə̀ m̀bəŋkə yi, ǹlii waa ntsya ŋkarɨsə, ǹswoŋ mə, “Sìntə abô yô.” A kɨ̂ ŋ̀ghɨrə tsiꞌì maa ajàŋə̀. Àbô yi ya a tɨɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bɨ yə̀ mə̂ laà, mɨ̀ntɔ̂ŋ myaa mɨ lwînə̀ bo tɨgə̀ ŋ̀ghaa bo nɨ bo ŋwaꞌa nɨ mə bo ka ghɨ̀rə̀ nɨ Yesu mə akə lɛ? ");
INSERT INTO bfd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A bə a nɨ̂ ǹjwi mà jya Yesu a kɔꞌɔ ŋghɛ̀ɛ a atu ntaꞌa a ntsaatə Nwì ǹtɨgə ŋghɛɛ nlɛ a ntsàꞌàtə Nwǐ ntsàꞌàtə̂. ");
INSERT INTO bfd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Àbɛ̀ɛ̀ a fùꞌù mə̂, a twoŋ ŋgǎŋyəgə̂nnǔ ji, ntsɔꞌɔ waa nɨghûm ǹtsò baa, ntwoŋə waa nɨ̂ ŋ̀gǎŋntoò ji. ");
INSERT INTO bfd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","À lɛ ntwoŋ Simon yìi mə à lɛ ntswě ɨkûm yì nɨ Peta aa, bo Andrew, mumaà yì, nɨ Jɛms abɔ̀ꞌɔ Jɔn, nɨ Philip bo Batholemiah, ");
INSERT INTO bfd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nɨ Mateo bo bɨ̀ Thomas, nɨ Jɛms yìi mə à lɛ mbə mu Alfeus, nɨ Simon yìi mə bɨ lɛ sɨ kɨɨ ntwoŋə nɨ Zealot aa, ");
INSERT INTO bfd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","a bɔ̀ꞌɔ Judas mu Jɛms, nɨ Judas Iscariot, wa yìi a lɛ mfèè Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A tɨgə̀ ǹsɨgə bo bo nsɨgə ntəə a adɨgə nɨbɔrə, bo bɨ̀ ǹnɔ̀ɔ ŋgǎŋyəgə̂nnù ji nɨ̂ ǹnɔ̀ɔ̀ bə̂ yî ghàꞌàtə̀ yìi ɨ lɛ nlǒ a alaꞌa Yudea bo bɨ̀ a alaꞌa Yerusalem tsiꞌì tsɨ̀m, bo bɨ̀ ɨ̀too jìi ɨ lɛ ntswe a aghəŋə ŋkǐ Tai bo bɨ̀ a Sidon aà. Bə̀ ma bû lɛ nzì aa mə bɨ zǐ a nyuꞌu annù yìi à lɛ sɨ swoŋə aà, mə tâ à kɨ ntsuꞌu mɨghɔ̀ɔ̂ myaa. ");
INSERT INTO bfd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","À lɛ ŋkɨ mfiꞌi ɨzwì jî bɨ a ɨtoꞌo bə̀ bìi ɨ lɛ sɨ fa ŋgɨꞌɨ a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ǹnɔ̀ɔ̀ bə̂ bya lɛ sɨ to nɨ̂ a mmɔ̀ɔ̀ntə̂ yi nloŋ mə àdàꞌà a lɛ sɨ fɛ̀ꞌɛ̀ ghu nu ntsuꞌu nɨ̂ waa. ");
INSERT INTO bfd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A ŋɛntə̀ miꞌì mi nlentə ŋgǎŋyəgə̂nnù ji ghu, nswoŋ mə, “M̀bɔɔnə a mbo bù bìi mə nɨ̀ fumə aa, nloŋ mə ànnù nɨfɔ̀ a aburə à nɨ̂ à yuu. ");
INSERT INTO bfd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“M̀bɔɔnə a mbo bù bìi mə ǹjɨ̌ ɨ yaŋə ghuu tsɨ̂tsɔ̀ŋ aa, nloŋ mə nɨ̀ ka jɨ ɨ yurə. M̀bɔɔnə a mbo bù bìi mə nɨ yəꞌə tsɨ̂tsɔ̀ŋ aa nloŋ mə nɨ̀ ka yǐ wyɛ̀tə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“M̀bɔɔnə a mbo bù mə mbə bə̀ kâ m̀baa nɨ̂ ghuu, ŋka mfurə nɨ̂ ghuu, ŋkɨɨ mbəgɨtə nɨ̂ ghuu, mmeꞌe nɨ̂ mɨ̀kûm muu mə nɨ̀ nɨ ŋgǎŋghɨ̀rə ɨ̀nnù jî bɨ nloŋ ŋgaa Mu Ŋù aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nɨ̀ ka ndorɨtə nlɨtə nnaŋə nɨ nɨ̀dorə maa njwì ǹloŋ mə mɨ̀tsɔꞌɔnə mɨ afàꞌâ muu a aburə mɨ ghaꞌà. À nɨ̂ àjàŋ mə bɨ̀tà bɨ bɨ̂taà buu lɛ sɨ ghɨ̀rə a nû ŋgǎŋntoo Nwî aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Lâ ŋ̀gɨꞌɨ ɨ̀ tswe a nu bù bya bìi nɨ̀ nɨ ŋgǎŋkabə aa, nloŋ mə nɨ̀ kwɛ̀rə̀ mə̂ ǹjoo jya jìi ɨ ghɨ̀rə̀ nɨ̀ dorɨtə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ŋ̀gɨꞌɨ ɨ̀ tswe a nu bù bya bìi nɨ̀ jɨ nyurə aa, nloŋ mə nɨ̀ ka yǐ tɨgə ntswe nɨ̂ ǹjì. “Ŋ̀gɨꞌɨ ɨ̀ tswe a nu bù bìi mə nɨ wyɛ̀ tsɨ̂tsɔ̀ŋ aa nloŋ mə nɨ̀ ka yǐ tɨgə jəŋnə ɨ yə̀ꞌə. ");
INSERT INTO bfd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ŋ̀gɨꞌɨ ɨ̀ tswe a nu bù mə mbə bə̀ bɨ̀tsɨ̀m ka swoŋə nɨ̂ ɨ̀nnù jî sɨgɨ̀nə̀ ǹloŋ ŋgaà yùù ǹloŋ mə a nɨ ajàŋ mə bɨ̀tà bɨ bɨ̂taà byaa bɨ lɛ sɨ ghɨ̀rə a nu ŋgǎŋntoo Nwî ji mbweꞌesə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lâ nɨ̀ naŋsə yuꞌutə annù yìi mə swoŋ a mbo bù aa mə, “Ka ŋkɔ̀ŋ nɨ̂ ŋ̀gàŋkɨ̂bàâ juu, ŋ̀kɨɨ ŋghɨrə nɨ̂ ɨ̀bɔ̀ŋ a nu bə̀ bìi bɨ bàà ghuu aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ka nɨŋ mbɔɔnə a nu bə̀ bìi mə bɨ nɨŋ ndɔ̀ɔ̀ a atu bù aa, ŋka ntsaꞌatə nɨ̂ Nwî a atu bə̀ bìi mə bə̀gɨ̀tə̀ nɨ̂ ghuu aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","M̀bə ŋù à fɛɛ gho faa nɨghaꞌa lâ, ò kuꞌùsə̀ m̀bəŋtə mbɛ̀ɛ̀ yî mɔ̀ꞌɔ mfa ghu mbo mə tâ à fɛɛ. Bɛlə mə ŋù à kwɛrə akutə̀ yo ò tsɔꞌɔ̀ àtsə̀ꞌə̂ yo yì màꞌà ǹyoŋ ŋkùꞌùsə̀ ghu. ");
INSERT INTO bfd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ka mfa njoo a mbo ŋù ǹtsɨ̀m yìi mə a lɔntə a mbo wò aa. Bɛɛ mə ŋù a zi nlɔ̀gə ayoò yo, ò tsuù gho bǔ betə kwɛrə. ");
INSERT INTO bfd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ma mùu ajàŋ ka ŋghɨrə a nu bə̀ ɨ ɨnnù jya jìi mə o kɔ̀ŋə̀ mə bɨ̀ ka ŋghɨrə a nu wò aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mbə ò ka ŋkɔŋə tsiꞌì bə̀ bìi mə bɨ kɔ̀ŋə̀ nɨ̂ gho aa, boŋ Nwì à ka tsɔꞌɔ ɨfàꞌà gho aa mə akə aa ɛ? Ǹloŋ mə tsiꞌì ŋ̀gǎŋghɨ̀rə ɨ̀nnù jî bɨ ɨ kɨɨ ŋkɔ̀ŋə nɨ̂ bə̂ bìi mə bɨ kɔ̀ŋə̀ waa aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mbə ò ka ŋghɨrə ɨ̀bɔ̀ŋ tsiꞌì a nu bə̀ bìi mə bɨ ghɨ̀rə ɨbɔ̀ŋ a nu wò aa boŋ Nwì à ka tsɔꞌɔ ɨfàꞌâ gho aa mə akə̀ aa ɛ? Ǹloŋ mə tsiꞌì bə̀ bî bɨ kɨɨ ŋghɨrə maa ajàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mbə ò ka ntsɔꞌɔsə ŋkabə tsiꞌǐ a mbo bə̀ bìi mə ò zi mə bo ka bǔ fa fu aa, boŋ Nwì à ka tsɔꞌɔ ɨfàꞌâ gho aa mə akə̀ aa ɛ? Tsiꞌì ŋ̀gǎŋghɨ̀rə ɨ̀nnù jî bɨ̀ ɨ tsɔꞌɔsə ŋkabə a mbo ŋgǎŋghɨ̀rə ɨnnù jì bɨ ji mɔꞌɔ ta bǔ kwɛrə ndùù ma wa fu. ");
INSERT INTO bfd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lâ nɨ̀ baŋnə ŋka ŋkɔŋ ŋgàŋkɨ̂bàâ juu, ŋka ŋghɨrə nɨ̂ ɨ̀bɔ̀ŋ a nu bo. O yi tɨ tsɔꞌɔsə ŋû nɨ̂ ŋ̀kabə ò tsuu kɨ waꞌatə mə ò ka bǔ kwɛrə fu bəə boŋ mɨ̀tsɔꞌɔnə̀ mɨ ɨfàꞌâ mo mɨ ka yǐ ghaꞌa tâ nɨ̀ tɨgə mbə bɔɔ bɨ Nwîŋgɔ̀ŋ Àkɔꞌɔ̀ntsɨrə. Ǹloŋ mə Nwì a ghɨ̀rə ɨbɔ̀ŋ a nu bə̀ bìi mə kaa bɨ sɨ mɨyà fa aa bo bɨ̀ a nu bə̀ bìi ɨ̀nnù jyaa ɨ bɨꞌɨ aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ka ŋko mɨlə̀ŋnə̀ bə̀ tsiꞌì tsǒ Taà ghùù a kɨɨ ŋko mɨlɨ̀ŋnə̀ bə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tsee mɨlɔꞌɔ mɨ bə̂ bi mɔꞌɔ kɨ twitə boŋ kaa bɨ ka waꞌà nɨ̀ muu kɨɨ ntwitə. Tsuu kɨ swoŋə nɨ mə ŋù à wô ɨ̀saꞌà boŋ kaa bɨ ka waꞌà kɨ̀ɨ̀ ǹswoŋə nɨ ma ò wô ɨ̀saꞌà. Ka nlìꞌìnə ɨfansənnù bə̂ tâ bɨ̀ kɨɨ nliꞌinə ɨfànsənnù jô. ");
INSERT INTO bfd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ka mfa nɨ ǹjoo a mbo bə̀ boŋ bɨ ka kɨɨ fa nɨ a mbo wò. Fɨ̀gɨ̀ yî ǹsɨgɨ̀nə̀ yìi mə bɨ tsɨgə, nnɨ̀ŋ nɨŋ, a nàŋsə nluu aa, yìi mə à lùu ntɨgə yaꞌanə aa, à nɨ yìi mə bɨ ka swìꞌi a mûm àbo atsə̀ꞌə̀ yìi mə ò nɔ̀ŋsə mɨtùꞌu wò aà. Ma la a bə mə fɨ̀gə̀ yìi mə o fa nɨ a mbo bə̀ aa, à nɨ fɨ̀gə̀ yìi mə bɨ ka kɨɨ kɨ fa nɨ a mbo wò aà.” ");
INSERT INTO bfd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","À lɛ mbù ǹnaa nɨghàà a mbo bo mə, “M̀bə̂ m̀fə̀ꞌə̀nə̀ a ka ntsyasə nɨ mfə̀ꞌə̀nə̀ yî mɔ̀ꞌɔ aa ɛ? Boŋ bo bɨtsɨ̀m ka waꞌǎ a mûm àtaa ghɛ̀ɛ̀ ŋ̀wo aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kaa m̀bə ŋgàŋyəgə̂nnù a waꞌǎ ŋgàŋndɨ̀ꞌɨnnù tsyâtə̀ bə̂. Lâ ŋù yìi mə à yə̀gə̂ ànnù maŋsə aa, a ka bə aa tsiꞌì tsǒ ǹdɨ̀ꞌɨ̀nnù yì. ");
INSERT INTO bfd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“A ghɨ̀rə̂ àkə̀ mə ò ka nyə nɨ̂ àbàꞌa ati yìi a tswe a nɨliꞌi ndɨ̂m ghò kaa ŋkɨꞌɨ̀ nɨ̀ koonə yìi à tswe a nɨliꞌi wò aa yə̂ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kə̀ m̀bə ò tsyâ aa la nswoŋ a mbo ǹdɨm ghò mə, ‘Ǹdɨm ghà, zi ta mə̀ fiꞌi abàꞌa ati ya a nɨliꞌi wò,’ mə mbə ò tuu koonə wa yìi à tswe nɨliꞌi wò kɨ yə aa ɛ? Wò, ŋ̀gàŋàbagɨlə̀, fòo ntsyǎ mbìì m̀fiꞌi koonə wa a nɨliꞌi wò, boŋ ò ka naŋsə yə abàꞌati ya a nɨliꞌi ndɨm ghò ɨ fiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","À wa àtì yî sɨgɨ̀nə̀ a sɨ mɨ̂ntà mî bɨ koonə. Kaa àtì yî bɨ waꞌà nɨ̀ mɨ̂ntà mî sɨgɨ̀nə̀ kɨɨ koonə. ");
INSERT INTO bfd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bɨ zi mbuu ati yìi a nɨ ghu ntsya aa a njɨm mɨ̀ntâ mi. Kaa mbə ò waꞌǎ maŋgòrə a nɨ̂ àti njɔ̂ŋ kyâ, kaa waꞌǎ ajɔ̀ɔ̀ a nɨ ǹtsìbɨ̀njɔ̀ŋ kɨ ŋkya. ");
INSERT INTO bfd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ŋù yî sɨ̀gə̀nə̀ a fiꞌisə aa ɨnnù jî sɨgɨ̀nə̀ a ntɨɨ yu yìi ɨ luu nɨ̂ ǹjoo jɨ̂ sɨgɨ̀nə̀ aà, ŋù yî m̀bɨ a kɨɨ̀ fiꞌisə aa ǹjoo jì bɨ a ntɨɨ yu yìi ɨ luu nɨ̀ ǹjoo jì bɨ aà. Ǹloŋ mə ǹtsù ŋû ɨ ghàà aa ɨ̀nnù jìi ɨ luu ghu ntɨɨ aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Bǔ twoŋə nɨ̂ gha mə Mmàꞌàmbi, Mmàꞌàmbi, la kaa kɨꞌɨ̀ nɨ̂ ànnù yìi mə mə swoŋə a mbo bù aa ghɨ̀rə̀ aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ŋù ǹtsɨ̀m yìi mə à zi a mbo mə̀ ǹyuꞌu nɨ nɨ̀ghàâ na ŋkɨɨ mfaꞌa nɨ̂ ànnù yìi mə mə swoŋ aa, ");
INSERT INTO bfd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","à bə̀ aa tsiꞌì tsǒ ŋù yìi à ghɛ̀ɛ a mbɔɔ̀ ǹda, naŋsə ntoŋə atsənda ya a tsotə̀ ǹsɨgə a nɨ̂ àlâŋsə ŋgɔ̀ꞌɔ̀. Nòò yìi ŋ̀kì ɨ lɛ nluu aa, àkànə ŋkì a zî ǹtum nda ya, kaa kɨꞌɨ̀ ǹda ya tsɨ̀gɨ̀tə̀ bə̂ ǹloŋ mə bɨ lɛ nnaŋsə ŋghurə ɨ tɨɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lâ ŋù yìi mə a yuꞌu kaa kɨꞌɨ̀ ghɨ̀rə̀ aa, à bə aa tsiꞌì tsǒ ŋù yìi mə à ghùrə nda tɨ̀ tumə̀ àtsə aà. Nòò yìi mə ŋ̀kì ɨ lɛ nluu aa, àkàŋnə ŋkì a zî ǹtum nda ya ɨ burə̀ ŋ̀ghɛnsə ŋwò yi, ǹjoo nda jya ɨ bɨꞌɨ tsiꞌì tsɨ̀m, bwɛ yìi mə a tswe ghu aa a ghaꞌà! ");
INSERT INTO bfd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu à màŋsə̀ mə̂ a nswoŋ ɨ̀nnù ji jìi mə à lɛ nlɔ̀ɔ mə bə̀ yuꞌu aa tsiꞌì tsɨ̀m, ŋkuu ŋghɛɛ a alaꞌa Kapernaum. ");
INSERT INTO bfd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Àtu bɨ̂sogyɛ ŋkhɨ̀ ŋù baRoma yî mɔ̀ꞌɔ, à lɛ ntswe nɨ ŋ̀gàŋàfàꞌa yìi mə à lɛ naŋsə ŋkɔŋ ŋkɔ̀ŋ aa, a ghɔɔ̀ ǹtɨgə tsiꞌǐ a ŋkwô. ");
INSERT INTO bfd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","À yùꞌù mə̂ mə Yesu a zì aa, ntoo bɨ̀lɨ̀ɨ bɨ baYuda ghu mbo mə tâ bɨ̀ zi ntwoŋə yi tâ à zi ŋghùrə ŋàŋàfàꞌâ yì wâ. ");
INSERT INTO bfd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bo zì mə̂ a mbɛ̀ɛ Yesu aa naŋsə mbuꞌu mbo ghu mbo nswoŋ mə, “Wa à nɨ ŋù yìi à kùꞌùnə mə mbə ò kwɛtə̀ yi ");
INSERT INTO bfd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ǹloŋ mə à kɔ̀ŋə alaꞌà yiꞌinə̀ yû, à lɛ ŋ̀ghùrə̀ yu ŋ̀ghurə ndâŋghòtə yìꞌì yû.” ");
INSERT INTO bfd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu a yòŋə̀ waa bo bo ghɛɛ̀. Bo ghɛ̀ɛ̀ mə̂ ǹtɨgə ŋkuꞌu a nda aa, àtu bɨ̂sogyɛ̀ ya a too bɨ̀subɨkaꞌâ bi mə bɨ̀ ghɛɛ nswoŋ ghu mbo mə, “M̀màꞌàmbî, tsuu ŋgɨꞌɨ yə a nzǐ bə̂, ǹloŋ mə kaa mə̀ sɨ̀ kuꞌùnə̀ mə mbə ò zî ŋ̀kuu a nda mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kaa mə̀ ghɨ̀rə waꞌà kɨ̀ mmɔɔntə mə mə̀ kùꞌùnə a nzǐ a mbɛ̀ɛ wò. Lâ, ghɛ̀nsə ŋghàà tsiꞌì nɨghàà nî fùùrə̀ boŋ ŋ̀gàŋàfàꞌâ ghà ghû à ka tɨɨ. ");
INSERT INTO bfd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ǹloŋ mə mə̀ laa mbə ŋû, ǹtswe nɨ̂ bə̀ bìi mə bɨ tswe nɨ̂ àdaꞌa a atu mə̀ ǹsaꞌa nɨ̂ ghà, mə̀ kɨ̂ ǹtswe nɨ̂ àdàꞌa a atu bɨ̀sogyɛ̀ bìi mə mə saꞌa aà: Mə̀ bə swoŋ nɨ yì mɔ̀ꞌɔ mə, ‘Ghɛ̀ɛ̂!’ boŋ à ghɛ̀ɛ̂; mə̀ kɨ nswoŋ nɨ yì mɔ̀ꞌɔ mə, ‘Zǐ!’ a kɨ̂ ǹzî; Bɛɛ mə̀ kɨ nswoŋ a mbô àbùꞌû ya mə ‘Ghɨ̀rə̀ yulà ànnù!’ a kɨ̂ ŋ̀ghɨrə.” ");
INSERT INTO bfd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu à yùꞌù mə̂ ànnù ya yìi mə à lɛ nswoŋə aa, nyɛrə, mbəŋkə yi nswoŋ a mbo nnɔ̀ɔ̀ bə̂ wa mə ɨ lɛ sɨ yòŋə̀ yi aa mə, “Mə̀ swòŋə a mbo bù mə, tsiꞌǐ a alaꞌa baIsrael, kaa mə̀ lɛɛ̀ ŋ̀kɨꞌɨ̌ abəŋə abìintɨɨ mà yû yə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bə̀ bya mə bɨ lɛ ntoo aa ɨ lɛ mbù m̀bɨɨ ŋghɛ̀ɛ̀ fu a nda, mbɨɨ nyə mə ŋgàŋàfàꞌà wa à tɨ̀ɨ̀ mə̂. ");
INSERT INTO bfd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Àbàŋtə̀ a tsyà mə̂, Yesu a ghɛɛ̀ a nɨkurə ni mɔꞌɔ mə bɨ lɛ sɨ twoŋə nɨ Nain. Ŋ̀gǎŋyəgə̂nnù ji bo bɨ̀ ǹnɔ̀ɔ̀ bə̂ lɛ ŋghɛ̀ɛ̀ bo bo ghu. ");
INSERT INTO bfd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","À ghɛ̀ɛ̀ mə̂ ŋ̀ka ŋkuꞌu a ntsǔbùꞌù yìi ɨ lɛ sɨ kuu wa nɨkurə, nyə bɨ beꞌè àku ŋûmbâŋnə̀ yî mɔꞌɔ yìi à lɛ mbə tsiꞌì yùyù a mbô ǹdè yì, ǹdè yì wa a kɨ̂ m̀bə ŋkwiꞌi màŋgyɛ̀, ǹnɔ̀ bə̂ ɨ yoŋə̀ nii. ");
INSERT INTO bfd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mmàꞌàmbî a yə̂ yi, ŋko mɨlɨ̀ŋnə̀ yì, ǹswoŋ ghu mbo mə, “Tsèe kɨ yə̀ꞌə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ŋ̀ghɛɛ mmɔ̀ɔ̀ntə̀ fɨkuu fìi bɨ lɛ mbèꞌe aku ŋû wa ghu aa, bɨ̀bèꞌè bya bɨ təə̀ tsiꞌì la, a swoŋ mə, “Mûjɔ̀ŋ, mə̀ swòŋə a mbo wò mə tâ ò bɨɨnə!” ");
INSERT INTO bfd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ŋ̀ku wa a bɨɨ̀nə̀ ǹtswe, nlɔgɨnə ŋka ŋghaa. Yesu a fâ yi fu a mbô ǹdè yì. ");
INSERT INTO bfd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nɨ̀bɔꞌɔ lɛ ntswa ŋû ǹtsɨ̀m, bo ghaꞌasə̀ Nwî ǹswoŋə nɨ mə, “Ŋ̀gàŋntoò Nwì yî ŋ̀wè à fɛ̀ꞌɛ̀ mə̂ a tɨtɨ̀ɨ bìꞌinə̀;” ŋ̀kɨ swoŋ mə, “Nwìŋgɔ̀ŋ à kɨ̀ mə̂ nzi ŋghantə bə̂ bi.” ");
INSERT INTO bfd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ǹgàn ma yû m̀bɨꞌɨ ŋgaà yì ɨ̀ lɛ nsɛɛnə̀ a mbùꞌu Yudea tsɨ̀m bo bɨ̀ ɨ̀too jì ɨ lɛ ntswe ŋkoontə ghu aà. ");
INSERT INTO bfd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ŋ̀gǎŋyəgə̂nnù Jɔn ɨ lɛ nswoŋ ɨnnù ma jû tsiꞌì tsɨ̀m ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jɔn a twoŋ ŋgǎŋyəgə̂nnù ji ji baa ntoo waa a mbô M̀màꞌàmbi mə bɨ̀ ghɛɛ mbetə mə, “Ò nɨ yu wa mə à tswe nɨ̂ ǹzi aa, kə̀ bìꞌi ka nyuꞌutə aa yî dàŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ŋ̀gǎŋntoo ji jya ɨ ghɛɛ̀ ǹyə yi mbetə yi mə, “Jɔn Ŋgàŋmurə bə̌ ŋkì à toò yiꞌi a mbo wò mə tâ bìꞌì zi mbetə gho mə, ‘Ò nɨ yu wa yìi à tswe nɨ̂ ǹzì aa ɛ? Kə̀ bìꞌì ka nyuꞌutə yî dàŋə̀ aa ɛ?’ ” ");
INSERT INTO bfd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A tɨ bə tsiꞌì maa noò aa Yesu à ghurə̀ mɨghɔ̀ɔ̀ mî ghàꞌàtə̀ a nu bə̀ bo bɨ̀ mɨ̀ghɔ̀ɔ̀ mɨ ŋkwoŋ bə̀; m̀fiꞌi ɨzwì jî bɨ a atoꞌo bə̀, ŋ̀kɨ ŋaꞌa miꞌi mɨ bɨfə̀ꞌə̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A tɨgə̀ ŋ̀kwiꞌi a mbo bo mə, “Nɨ̀ ŋghɛɛ nswoŋ annù yìi mə nɨ yə ŋkɨ nyuꞌu aa a mbo Jɔn. Bɨ̀fə̀ꞌə̀nə̀ yə ɨdɨgə, bɨ̀bwenkə̀ bɨ təə̀, àkɨkwenə a sɨgə̀ nɨ a nu ŋgǎŋakɨ̀kwenə̀, ɨkwotu ɨ yuꞌù nɨ̀ ɨ̀nnù, bɨ̀ku bɨɨ̀nə̀ nɨ nɨ̀wô, bɨ swoŋə̀ nɨ̀ ntoo yì sɨgɨ̀nə̀ a mbo ŋgàŋə̂fumə. ");
INSERT INTO bfd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","M̀bɔɔnə a nu ŋù yìi mə kaa à sɨ ŋû yìi mə mə̀ nɨ ghu aa jɨ̀ŋkə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nòò yì mə ǹgǎŋntoo Jɔn jya ɨ lɛ mbu ŋghɛɛ waa laa, a lɔ̀gɨ̀nə̀ ŋka ŋghaa annù ǹloŋ ŋgaa Jɔn ǹswoŋə nɨ mə, “Nɨ̀ lɛ ŋwaꞌatə mə nɨ ghɛ̀ɛ̀ a nyə aa akə̀ a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ aa ɛ? Ɨ ŋkɨ̀ŋkàꞌà yìi mə fɨ̀fə̀rə̀ a tsɨ̀kə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nɨ̀ lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ aa a nyə̂ àkə̀ aa ɛ? A ŋû yìi mə à lɛ ŋwɛꞌɛ ɨtsə̀ꞌə̀ jî sɨgɨ̀nə̀ aa ɛ? Bə̀ bìi mə bɨ wɛꞌɛ ɨjàŋ ɨtsə̀ꞌə̀ majya ǹnaŋsə ntswe nɨ̂ sɨgɨ̀nə̀ aa, ɨ tswe aa a ntɔꞌɔ̀ bɨ̀fɔ̀. ");
INSERT INTO bfd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lâ nɨ̀ lɛ nnaŋsə ŋghɛɛ aa a nyə̂ àkə̀ aa ɛ? A nyə ŋgàŋntoò Nwì aa ɛ? Ɨ̀ɨ̀ŋə, lâ mə̀ swòŋə a mbo bù mə à tsyàtə ŋgàŋntoò Nwì. ");
INSERT INTO bfd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","À nɨ yu wa yìi mə bɨ lɛ ŋŋwàꞌànə̀ ǹloŋ ŋgaà yì aa mə, ‘Yə̂, mə̀ ka too ŋgàŋntoò ghà a mbìi wò, yìi mə à ka ghɛ̀ɛ naŋsə mânjì ghò aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mə̀ swòŋə a mbo bù mə kaa ŋù tsù à sɨ̀ ghu tswê a tɨtɨ̀ɨ bə̀ bìi mə màŋgyɛ̀ à jwe aa, mə à kɔ̀ꞌɔ̀nə ntsyà Jɔn. Lâ ŋù yìi mə à kə̀ꞌə nsɨgə nlwiꞌi a mûm ànnù nɨfɔ̀ Nwî aa, à kɔ̀ꞌɔ̀nə ntsyà yi.” ");
INSERT INTO bfd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bə̀ bɨ̀tsɨ̀m bo bɨ̀ ŋgǎŋkwɛrə tax bìi bɨ lɛ nyuꞌu annù ma yû aa, bɨ lɛ mbeentə mə Nwì à ghɨ̀rə̂ ànnù yìi atsinə aà, ǹloŋ mə a waa a ŋkì aa a lɛ mmurə Jɔn aà. ");
INSERT INTO bfd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lâ baFarɨsai bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bɨ lɛ ntuu waa ŋkàꞌa Nwì ya yìi à lɛ ŋkàꞌà nloŋ ŋgaa yàà aà, nloŋ mə bɨ lɛ ntuu mə tâ Jɔn à waꞌà waa a ŋkì murə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu a ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ mə, “Mbə mə̀ fɨgɨ̀nə̀ nɨ̀wàà nɨ bə̂ bûlà aa a nɨ̂ àkə̀ lɛ? Bo naŋsə mbə aa tsiꞌì tsǒ àkə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bo bə aa tsiꞌì tsǒ bôŋkhə bìi bɨ sɨgɨtə ntswe a nsaanə mɨtaa, bî mɔꞌɔ bɨ twoŋə̀ nɨ̂ bì mɔꞌɔ nswoŋə nɨ mə, ‘Bìꞌì buꞌù ɨ̀kòò nɨyɔꞌɔ a mbo bù kaa nɨ̀ waꞌà benə̀, bìꞌì yəꞌə̀, m̀maꞌa atsàà nɨwo, kaa nɨ̀ waꞌà kɨ̀ɨ̀ ǹyəꞌə.’ ");
INSERT INTO bfd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mə̀ swoŋ laà aa nloŋ mə Jɔn ŋgàŋmurə bə̀ a ŋkì à lɛ nzì kaa waꞌà nìi abaa kurə̀ kaa waꞌà nìi mɨlùꞌù nô, nɨ̀ swoŋ mə, ‘À tswe nɨ̀ demon.’ ");
INSERT INTO bfd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mu Ŋù à zì mə̂ ǹjɨ ŋkɨɨ nno, nɨ̀ swoŋ mə, ‘Yə nɨ̀! À nɨ lɛɛ̀nàà, m̀bə àbàrə mɨlùꞌù! Ŋ̀kɨ mbə nsûkàꞌa ŋgǎŋkwɛrə bɨ̀tax bo bɨ̀ ŋ̀gǎŋghɨ̀rə ɨnnù jɨ̂ bɨ̂!’ ");
INSERT INTO bfd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lâ bɔɔ bìi mə mɨ̀tsyɛ̀ mɨ Nwɨ̂ mɨ jwe aa, bɨ dɨꞌɨ mə ɨ̀nnù Nwî ɨ tsinə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ŋù baFarɨsai yî mɔ̀ꞌɔ à lɛ ntwoŋə yi mə tâ à zi njɨ a nda yu. ");
INSERT INTO bfd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nòò yìi mə à lɛ zì ǹtswe ŋ̀ka njɨ aa, màŋgyɛ̌ nɨ̀kurə wa yì mɔ̀ꞌɔ yìi à lɛ mbə ŋû ŋ̀ghɨ̀rə ɨnnù jî bɨ aa, à lɛ nyuꞌu mə à tswe njɨ wa nda ŋù baFarɨsai wâ, ǹzi nɨ̂ mɨghurə mì lùmtə̀ a nɨ̂ ǹtsɨ̂ŋ ŋ̀gɔ̀ꞌɔ̀ àlàbasta, ");
INSERT INTO bfd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","À zì mə̂ ŋ̀ghɛɛ ntəə a njɨ̌m Yesu, a mbɛ̀ɛ mɨkòrə yu ŋka nyəꞌə, ntswu nɨ mɨkòrə̂ mi nɨ mɨ̀làà, ǹlɔgə ɨnǒŋtû ji nyɛꞌɛ nɨ mɨ̀kòrə̀ mi mya ghu, ntɨgə nnɔŋə nɨ mɨ̀kòrə̂ mi, ŋkɨɨ nyɔꞌɔ nɨ mɨ̀ghurə mì lùmtə̀ myâ. ");
INSERT INTO bfd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ŋù baFarɨsai wa mə à ghɨ̀rə ntwoŋə Yesu aa, à yə̀ mə annù ya mə màŋgyɛ̀ wa à lɛ sɨ ghɨ̀rə̀ aa, nswoŋ a mûm ǹtɨɨ yu mə, “Ŋù ghû à ghɨ̀rə mbaa bə ŋgàŋntoò Nwì boŋ à zi ŋû yìi à nɨ ghu aa, ǹzi mbuu mâŋgyɛ̀ ghû mə a mɔ̀ɔ̀ntə̀ yi aà, ǹloŋ mə à nɨ̂ ŋ̀gàŋghɨ̀rə̂ ɨ̀nnù jî bɨ̂.” ");
INSERT INTO bfd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu a swoŋ ghu mbo mə, “Simon, mə̀ tswe nɨ̀ ànnù a swoŋ a mbo wò.” A betə yi mə, “À nɨ̂ àkə̀ lɛ ndɨ̀ꞌɨ̀nnù?” ");
INSERT INTO bfd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu a swoŋ ghu mbo mə, “Ŋ̀gàŋtsɔ̀ꞌɔ̀sə ŋkabə yì mɔ̀ꞌɔ à lɛ ntswe nɨ ŋgàŋmɨkarə̀ ji ji baa, yì mɔ̀ꞌɔ a tswâ nìi, nɨ ɨbàꞌatə ŋkabə silva ŋkhɨ̀ ji ntaà, yì mɔꞌɔ a kɨɨ̀ ǹtswa nìi nɨ ɨbàꞌatə ŋkabə silva mɨghum mi ntaà, ");
INSERT INTO bfd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tsǒ mə a lɛ ntsyànə̀ a mbo bo a ntu aa, a maꞌàtə̀ waa bɨtsɨ̀mə̀. Swoŋ a mbo mə̀, ò mɔ̀ɔ̀ntə mə, a ka kɔ̀ŋ ghuu ɨ kɔ̀ŋ yi ɨ tsyàtə̀ yî mɔ̀ꞌɔ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon a kwiꞌi mə, “Mə̀ wàꞌàtə mə, ŋù wa mə nìi nɨkarə nya nɨ lɛ ŋghaꞌatə aà.” Yesu a kwiꞌi ghu mbo mə, “Wa ò kwiꞌi tsiꞌì sɨgɨ̀nə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ǹtɨgə mbəŋkə a nu màŋgyɛ̀ wa, nswoŋ a mbo Simon mə, “Ò yə mâŋgyɛ̀ ghû aa ɛ? Nòò yìi mə mə̀ ghɨ̀rə ŋkuu a nda wò aa, kaa ò ghɨrə waꞌǎ ŋkì fa mə tâ mə̀ siꞌi mɨkòrə̂ ma ghu. Lâ à bàŋnə̀ mə̂ ǹsiꞌi mɨkòrə̂ ma nɨ̀ mɨ̀làâ mi, ǹyɛꞌɛ nɨ̂ ɨ̀nǒŋtû ji. ");
INSERT INTO bfd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kaa ò ghɨrə ŋwaꞌǎ mɨghə̀gə̂ ma nɔŋə̀, lâ ǹlɔgɨnə nɨ nòò yìi mə̀ ghɨ̀rə nzì ŋkuu faà aa kaa à ghɨ̀rə̂ ŋ̀waꞌà kɛntə a nɔŋ mɨ̀kòrə̂ mâ. ");
INSERT INTO bfd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kaa ò ghɨ̀rə ŋkɨꞌɨ atû ya nɨ̀ mɨ̀ghurə yɔꞌɔ̀. Lâ, à bàŋnə̀ mə̂ ǹyɔꞌɔ mɨkòrə̂ ma nɨ̀ mɨ̀ghurə̀. ");
INSERT INTO bfd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ma mùu ajàŋ mə̀ swoŋ a mbo wò mə, ɨ̀nnù jî bɨ ji jya mə ɨ ghaꞌa aa, bɨ lìꞌìnə̀ mə̂. A laa ma mùu ajàŋ ǹloŋ mə à ghɨ̀rə ndɨ̀ꞌɨ àkɔ̀ŋnə̀ yî wè aà. Lâ ŋù yìi mə bɨ liꞌinə ɨ̀nnù jî bɨ̂ ji ji kəꞌətə̀ aa, a kɨɨ ndɨꞌɨ nɨ̂ àkɔ̀ŋnə̀ yî kə̀ꞌə̀tə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ǹtɨgə mbəŋ nswoŋ a mbo màŋgyɛ̀ wa mə, “Bɨ lìꞌìnə̀ mə ɨfansənnù jô.” ");
INSERT INTO bfd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bə̀ bìi mə bɨ lɛ sɨ jɨ bo bo aa, bɨ lɛ nlɔ̀gɨ̀nə̀ ǹtɨgə nswoŋə bo nɨ bo mə, “Ghuù ŋù à bə aa wò mə a lìꞌìnə ɨfansənnù bə̂ aa lɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu a swoŋ a mbo màŋgyɛ̀ wa mə, “Àbìintɨɨ̀ yo a ywèènsə̀ mə̂ ghô, ghɛ̀ɛ̀ nɨ̂ m̀bɔɔnə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","À kà mə aa maŋsə ŋkuu wa mûm ǹjɔ̀ꞌɔ̀ àlaꞌa bo bɨ̀ mɨ̀kurə, ǹtɨgə ndɨꞌɨ nɨ̂ ànnù Nwî ŋ̀kɨɨ nzi nɨ ntoo yì ǹsɨgɨ̀nə̀ ǹloŋ annù nɨfɔ̀ Nwî. A lɛ mbə bo bɨ̀ ŋgǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa mə à lɛ ntsɔꞌɔ nɨ̂ ŋ̀gǎŋntoò ji aà ");
INSERT INTO bfd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","bo bɨ̀ bàŋgyɛ̀ bî mɔꞌɔ bìi mə à lɛ ŋghùrə̀ waa nɨ̂ ɨ̀zwì jî bɨ bo bɨ̀ mɨ̀ghɔ̀ɔ̂ myaa: Mbə Mary yìi bɨ lɛ sɨ twoŋə nɨ Magdalene aa, yìi mə à lɛ mfiꞌi ɨzwì ji sàmbaa ghu atoꞌo aa, ");
INSERT INTO bfd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ŋkɨ mbə Juana, ŋgwɛ Tsuza, yìi mə à lɛ sɨ lèntə njoo Herod aà, ŋkɨ mbə Susana, bo bɨ̀ bǐ mɔꞌɔ bì ghàꞌàtə̀. Bàŋgyɛ̀ ma bû bɨtsɨ̀m bɨ lɛ sɨ fa nɨ̂ ǹjoo ŋkwɛtə nɨ̂ waa ghu. ");
INSERT INTO bfd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nòò yìi mə nnɔ̀ɔ̀ bə̂ ɨ lɛ nzì ŋ̀ghotə, ǹlo aa a ɨdɨgə ɨdɨgə nzi ghu mbɛ̀ɛ̀ aa, a ghaà a mbo bo nɨ nɨ̀ghàà nî nàà: ");
INSERT INTO bfd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ŋù m̀bwèꞌê ǹjoo à lɛ ŋghɛ̀ɛ̀ a mbweꞌe ǹjoò ji; ǹjoo jya jǐ mɔꞌɔ ɨ wô a ndô mânjì, bə̀ təəntə̀ ghu, bɨ̀sɨŋ bɨ kɨ̂ ǹsyɛ jî mɔꞌɔ ŋkurə. ");
INSERT INTO bfd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jǐ mɔꞌɔ ɨ wô a atû àlâŋsə ŋgɔ̀ꞌɔ̀; ɨ tòò mə̂ aa, mbù ǹyɔrə nloŋ mə kaa ɨ lɛ waꞌà nɨ̂ ŋ̀kì tswê. ");
INSERT INTO bfd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jǐ mɔꞌɔ ɨ wô a tɨtɨ̀ɨ kə̀rə̀ kərə; ɨ kà mə̂ aa ŋkɔꞌɔ aa kə̀rə̀ kərə wa a lɨmtə̀ ɨ kwô. ");
INSERT INTO bfd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jǐ mɔꞌɔ ɨ lɛ ŋkɨ wo nɨ̂ àdɨ̀gə nsyɛ yì sɨgɨ̀nə̀, ŋ̀kɔꞌɔ tsiꞌì sɨgɨ̀nə̀, ŋkɨ mfa ŋgwɛ̀ꞌɛ̀ mɨ̀jɨ ɨ ghaꞌà.” À swòŋ mə̂ maŋsə aa, ǹtɔŋnə nswoŋ mə, “Ŋù yìi mə à tswe nɨ ɨ̀tôŋnə̀ aa, tâ yuꞌù.” ");
INSERT INTO bfd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nòò yìi mə Ŋgǎŋyəgə̂nnù ji ɨ lɛ mbetə yi nɨ̂ ǹjiꞌì nɨ̀ghàà nî nǎnaa ma nû aa, ");
INSERT INTO bfd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","a swoŋ mə, “Nwì à fa mɨ̀tsyɛ̀ mə tâ nɨ̀ zǐ ɨnnù jî lɔ̀ꞌɔ̀sə̀ nloŋ annù nɨfɔ̀ yi; la a mbo bə̀ bî mɔꞌɔ, bɨ naa a mbo bo aa nàà, tâ bo tɨ yə, kaa bo waꞌà kà ǹyə, kə̀ tɨ yuꞌu, kaa a waꞌǎ a atu bo ka nlaa. ");
INSERT INTO bfd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ǹjiꞌì nɨ̀ghàà nî nǎnaa ma nû ɨ̀ bə aa mə: ‘Ǹjoo ŋ̀gwɛ̀ꞌɛ̀ jya à nɨ nɨ̀ghàà nɨ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jya jìi mə ɨ lɛ ŋwò a ndômânjì aa à nɨ bə̀ bya mə bɨ yuꞌu; Satan a zî m̀fiꞌi nɨghàà nɨ Nwî nya a ntɨɨ bo, tǎtâ bo tsuu bìì ɨ yweenə. ");
INSERT INTO bfd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jya mə ɨ lɛ ŋwò a atu alâŋsə ŋgɔ̀ꞌɔ̀ aa a bə bə̀ bìi mə bo kɨ nyuꞌu nɨghàà nɨ Nwî aa, bo kwɛrə nɨ nɨ̀dorə̀; kaa ajàŋ bə̂ ma bû kaa bɨ sɨ̀ nɨ mɨ̀gaŋ̀ tswê. M̀bii aa tsiꞌǐ nɨ mû àtɨɨ noò. La nòò yìi mə àkwàꞌànə̀ Satan a zi aa, bo wô. ");
INSERT INTO bfd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ŋ̀ghɛɛ nɨ̂ ǹjoo jya mə ɨ lɛ wò a tɨtɨ̀ɨ kə̀rə̀ kərə aa, à nɨ bə̀ bya mə bɨ yuꞌu nɨghàà nɨ Nwî, la a mûm ǹtswêntɨ̀ɨ yaa, ǹjoo mbi bo bɨ̀ ŋ̀kabə, nɨ̀ ɨ̀nnù yìi mə ǹjyǎ nû jyaa ɨ yə̀ꞌə̀tə̀ aa ɨ fêm ŋ̀ghɨrə kaa mɨ̀ntà mìi mɨ koonə kaa mɨ waꞌà tɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ǹtɨgə ŋghɛɛ nɨ̂ ǹjoo jya mə ɨ lɛ ŋwò a adɨgə nsyɛ yì ǹsɨgɨ̀nə̀ aa, à nɨ bə̀ bya mə bɨ kɨ nyuꞌu nɨghàà nɨ Nwî bɨ tswa ntugɨtə a mum ɨ̀ntɨɨ yìi ɨ laa ŋkɨ mbɔŋ aà, ǹtɨgə ŋkoonə mɨ̂ntà a njɨm àtàŋəntɨɨ̀.’ ");
INSERT INTO bfd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kaa ŋù à laa ŋwaꞌà nɨ̂ lâm kosə̀ m̀bu nlɔ̀gə̀ nɨ̂ àntɔ̀ɔ̀ ŋ̀kusə ghu, kaa kɨꞌɨ̀ kɨ̀ɨ̀ ŋ̀kosə nnɨŋə nɨ a njiꞌì ɨ̀kùù. Ŋù a kɨɨ ŋkosə lâm, a tɛꞌɛ aa a atu atɛtə̀ tà ŋù tɨ kuu a nda a yə̂ ŋ̀kàꞌà wâ. ");
INSERT INTO bfd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ǹloŋ mə kaa àyoò tsu a sɨ̌ alɔ̀ꞌɔ̀sə̀ tswê mə a ka yǐ waꞌà fɛ̀ꞌɛ̀ nyɛntə. Kaa ànnù yî lə̀ə̀ntə̀ yî tsu a waꞌà kɨ̀ ntswe ghu yìi mə kaa bɨ ka yǐ waꞌà zî. ");
INSERT INTO bfd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Maa ajàŋ, nɨ̀ ka ntsyɛsə nɨ̂ ghuu ajàŋ yìi mə nɨ yuꞌu aà; ǹloŋ mə ŋù yìi mə à tswe nɨ̂ ju ɨ ghaꞌatə̀ aa, bɨ ka bǔ kùꞌùsə̀, lâ ŋù yìi à tswe nɨ ju ɨ kəꞌətə̀ aa, tsiꞌì jya mə à mɔ̀ɔ̀ntə mə yu tswe nɨ̀ ju aa, baa bàŋnə bǔ kwɛrə ghu mbô.” ");
INSERT INTO bfd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ǹdè bɨ̀ Yesu bo bɨ̀ bɔɔ bɨ maà bi bǐ mbâŋnə̀ bɨ zî wa adɨgə mə à lɛ ntswe ghu aa, kaa mânjì yìi mə mbə bɨ zî ghu mbɛ̀ɛ̀ kaa waꞌà ghu tswê ǹloŋ mə bə̀ lɛ ntswe ntsya ŋkarɨsə yi. ");
INSERT INTO bfd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bɨ kɛ̀ꞌɛ̀nə̀ ghu mbo mə, “Ǹdè ghò bo bɔɔ bɨ maà bî mbâŋnə̀ bɨ təə a bɛɛ nlɔɔ nɨ̂ ǹyə wò.” ");
INSERT INTO bfd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A bâŋnə̀ ŋ̀kwiꞌi a mbo bo mə, “Ǹdèghà bo bɨ̀ bɔɔ bɨ maà ba bî m̀bâŋnè, à nɨ bə̀ bìi mə bɨ yuꞌu nɨghàà nɨ Nwî ŋ̀kɨɨ ŋghɨrə nɨ̂ ànnù yìi mə a swoŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","À bə̀ mə a njwi yì mɔꞌɔ Yesu a kuu a mum àkànuꞌu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji ǹswoŋ a mbo bo mə, “Nɨ̀ ghɨrə bìꞌinə̀ daŋ ghɛ̀ɛ̀ fìi njii àtsùməntaꞌà.” À swòŋ mə̂ aa, bo bo kuu ntɨgə ŋghɛɛ. ");
INSERT INTO bfd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bo kà mə̂ aa ŋghɛɛ aa, a wô fɨ̀lô. Àfìsə̀ yî tɨ̀ɨ̀ yî mɔꞌɔ a kâ ǹtsya wa atsùməntaꞌa, ɨ̀kàŋə ŋkì ɨ tɨgə̀ ŋ̀kuu wa mûm àkànuꞌu nlɔɔ nɨ̂ ŋ̀kòŋsə̂, bo tɨgə̀ tsiꞌǐ a ntsǔ nɨ̀wô. ");
INSERT INTO bfd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ŋ̀gǎŋyəgə̂nnù Yesu ɨ ghɛɛ̀ ǹtsɨgə yi nswoŋ mə, “Masa, Masa, wa bìꞌinə̀ ka kwokə!” Yesu a bɨɨ̀nə̀ wenə afìsə̀ ya bo bɨ̀ ɨ̀kàŋə ŋkì jî tɨ̀ɨ̀ jìi mə ɨ lɛ sɨ zì ǹlɔɔ nɨ̂ ŋ̀kòŋsə̂ àkànuꞌu yâ aà; ɨ burə kɛntə, ɨdɨ̀gə̀ ɨ bɔrə mə tùk. ");
INSERT INTO bfd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu a betə̀ waa mə, “Àbìintɨɨ̀ yuu a fə̀ aa ɛ?” Nɨ̀bɔꞌɔ lɛ ntswa waa bo kɨ̂ ǹyɛrə ntɨgə nswoŋə bo nɨ bo mə, “À nɨ̂ àjàŋ ŋû kə à yuà mə a ghààntə̀ nɨ̂ àfìsə̀ bo bɨ̀ ɨ̀kaŋ ŋkì ɨ yuꞌunə̀ nii aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bo lô ǹtɨgə ŋghɛɛ a alaꞌa baGerasens yìi a lɛ ntswe a ndàŋsə Galilea. ");
INSERT INTO bfd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Àjàŋ mə bo lɛ nzì m̀fɛꞌɛ wa mûm àkànuꞌu aa, ŋù yì mɔ̀ꞌɔ yìi mə à lɛ nlò wa mûm ǹjɔ̀ꞌɔ̀ àlaꞌa ntswe nɨ bɨ̀demon, à lɛ nzì ǹtsiꞌi waa; ŋù ma ghû à lɛ sɨ karə tsiꞌì ǹswèrə̀ ǹswèrə̀ a nɨ̂ àndaŋə noò. Kaa waꞌà nɨ a nda lɛ̂, m̀baŋnə nlɛtə nɨ aa ɨtu mɨsyɛ̀ a adɨgə yìi bɨ lɛ sɨ twiŋ bə̂ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nòò yì mə à lɛ nyə Yesu aa, ǹyəꞌə tsiꞌì nɨ̀tɨ̀ɨ̀, ŋ̀wo ghu nsi, ntɔŋnə nswoŋ mə, “Bìꞌi ò tswe aa nɨ̀ àkə̀, a Yesu, Mu Nwìŋgɔ̀ŋ yî Àkɔꞌɔ̀ntsɨrə? Mə̀ buꞌu tsiꞌì m̀bo tâ ò tsuu ŋgɨꞌɨ a nu mə̀ lǒ dɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","À lɛ tɨ bə aa boŋ Yesu à swòŋ mə̂ a mbo àzwì yî bɨ ya mə tâ à fɛꞌɛ wa nu ŋù wâ. (Ǹloŋ mə àzwì yî bɨ ma yû a lɛ sɨ tswa nɨ̂ ŋû wa màꞌà nɨ a nsyɛ ŋgàà jî ghàꞌàtə̀; bɨ tɨgə̀ m̀bɛ nìi, ŋ̀koo nìi nɨ̂ àtsaŋ bo bɨ̀ mfɨ̀kaꞌà. Ka mə bɨ lɛ sɨ ghɨ̀rə̀ maa ajàŋ aa, a tentə̀ nɨ̂ àtsaŋ ya, ɨ̀zwì jya ɨ ghɨrə̀ a khə̂ ŋ̀ghɛɛ nɨ ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀.) ");
INSERT INTO bfd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu a ghɛ̀ɛ̀ nɨ̂ m̀bìì m̀betə yi mə, “Ɨ̀kǔm gho à nɨ wò aa ɛ?” A kwiꞌi mə, “Ǹnɔ̀ɔ̀.” À lɛ nswoŋ laa nloŋ mə ɨ̀zwì jî bɨ jì ghàꞌàtə̀ ɨ lɛ ŋkuu ghu nû. ");
INSERT INTO bfd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɨ̀zwì jya ɨ buꞌù m̀bo ghu mbo mə tâ tsuu lǒ swoŋ mə tâ bo fɛꞌɛ ghɛ̀ɛ̀ ŋ̀kuu a mûm àtaa yi tsò ǹtso. ");
INSERT INTO bfd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Àkàrə̀ bɨ̂kwiŋyàm yî mɔꞌɔ a lɛ sɨ jɨ maa kəꞌə̀ àdɨ̀gə̀; ɨ̀zwì jya ɨ tɨgə̀ m̀buꞌu mbo a mbo Yesu mə tâ à maꞌatə tâ bo kuu wa nu bɨ̀kwiŋyàmə̀. A beentə̀. ");
INSERT INTO bfd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɨ̀zwì jî bɨ jya ɨ tɨgə̀ m̀fɛꞌɛ wa nu ŋù ǹtɨgə ŋkuu wa nu bɨ̀kwiŋyàmə̀. Àkàrə̀ bɨ̂kwiŋyàm ya a tɨgə̀ m̀bɨŋkə wa mbaa, nsɨgə ŋkuu wa mûm àtsùməntaꞌa ŋkoŋkə. ");
INSERT INTO bfd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nòò yìi mə bə̀ bìi mə bɨ lɛ sɨ tsèe akàrə̀ bɨ̂kwiŋyàm bya bɨ lɛ nyə annù yìi mə a lɛ mfɛ̀ꞌɛ̀ aa, ŋkhə̀ ŋ̀ghɛɛ nswoŋ a mûm ǹjɔ̀ꞌɔ̀ àlaꞌa bo bɨ̀ àlaꞌa ya tsɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bə̀ tɨgə̀ m̀fɛꞌɛ ŋghɛɛ a nyə ànnù yìi mə a lɛ mfɛ̀ꞌɛ̀ aà. Bo ghɛ̀ɛ̀ mə̂ aa nyə Yesu bo bɨ̀ ŋù wa mə ɨ̀zwì jî bɨ jya ɨ lɛ mfɛ̀ꞌɛ̀ ghu nu aa, a tswê a nsyɛ a mɨkòrə̂ Yesu, ŋ̀wɛꞌɛ atsə̀ꞌə̀, mɨ̀tsyɛ̂ mi mɨ kɨ̂ ǹtswe sɨgɨ̀nə̀; nɨ̀bɔꞌɔ nɨ tswâ waa. ");
INSERT INTO bfd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bə̀ bìi mə bɨ lɛ ntswe ghu wa noò mə Yesu à lɛ ŋghɨ̀rə̀ ɨ̀zwì jî bɨ jya ɨ fɛ̀ꞌɛ̀ a nu ŋù wa aa, bɨ tɨgə̀ ŋ̀kɛꞌɛnə nɨ̂ a mbo bo a ajàŋ yìi Yesu à lɛ ŋghùrə̀ yi aa. ");
INSERT INTO bfd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bə̀ bya bɨ̀tsɨ̀m bìi mə bɨ lɛ nlò wa mbùꞌù àlaꞌa Gerasens aa, bɨ swoŋ a mbo Yesu mə tâ à maꞌatə waa ŋghɛɛ yi; ǹloŋ mə nɨ̀bɔꞌɔ nì wè nɨ lɛ ntswa waa; maa ajàŋ a bû ŋ̀kuu wa mûm àkànuꞌu mbɨɨ yi. ");
INSERT INTO bfd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ŋù wa yìi ɨ̀zwì jî bɨ jya ɨ lɛ màꞌàtə̀ yi aa, a buꞌù m̀bo mə yu yòŋə̀ Yesu. La, a tuu, nswoŋ ghu mbo mə, ");
INSERT INTO bfd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bɨɨ ŋghɛ̀ɛ̀ a nda wò, ǹtɨgə ŋkɛ̀ꞌɛ̀nə̀ nɨ̂ ɨ̀nnù jî yɛ̌yərə jìi mə Nwì à ghɨ̀rə a nu wò aà.” Ŋù wa a ŋ̀ghɛɛ yi ntɨgə nlaansə nɨ̂ ànnù yìi mə Yesu à ghɨ̀rə a nu yu aa wa njɔ̀ꞌɔ̀ àlaꞌà tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nòò yìi mə Yesu à lɛ ntoo ŋkì wa mbɨ̀ɨ̀ aa, nnɔ̀ɔ̀ bə̂ ɨ lɛ nzì m̀boo yi, nloŋ mə à lɛ tɨ bə aa boŋ bo tɨgə̀ ǹyuꞌutə nìi. ");
INSERT INTO bfd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ŋù yî mɔ̀ꞌɔ yìi mə ɨ̀kǔm yì ɨ lɛ mbə Jairus aa, yìi mə à lɛ mbə ndɨɨ a ndâŋghòtə aa, a zî a mbo Yesu. À zì mə̂ aa ŋwò ghu nsi, mbuꞌu mbo ghu mbo mə tâ à yoŋə yi tâ bo yu ghɛɛ a nda yu, ");
INSERT INTO bfd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","nloŋ mə à lɛ ntswe nɨ̂ njoŋ mumàŋg yɛ̂ yì yìi mə à lɛ mbə ɨlòò nɨghûm ǹtsò baa, a ghɔɔ̀ ŋ̀kwo ŋghɛɛ nii aà. Àjàŋ mə bo yu lɛ sɨ ghɛ̀ɛ̀ aa, nnɔ̀ɔ̀ bə̂ wa ɨ lɛ sɨ yòŋə̀ ǹtɨgə ntii nɨ̂ Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Màŋgyɛ̀ yìi mə àləə a lɛ sɨ zì ghu nu a njɨ̌m ɨ̀lòò nɨghûm ǹtsò baa, kaa ŋù yìi mə mbə a tswaa waꞌà bə aa, ");
INSERT INTO bfd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","a yôŋtə̀ a njɨ̌m Yesu, m̀mɔɔntə a atsəŋə atsə̀ꞌə̂ yi; à mɔ̀ɔ̀ntə̀ mə̂ ŋ̀ka maŋsə aa, àləə ya mə a lɛ sɨ zì ghu nu aa, a tswanə̀. ");
INSERT INTO bfd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu a betə̀ mə, “Ŋù yìi mə à mɔ̀ɔ̀ntə gha aa, àâ wò aa ɛ?” Tsǒ mə kaa ŋù tsù à lɛ waꞌà bii mə yu mɔɔntə yi aa, Peta a tɨgə̀ ǹswoŋ mə, “Masa, nnɔ̀ɔ̀ bə̂ ghû ɨ ghaꞌa siꞌi, ntinə nɨ̂ ghô!” ");
INSERT INTO bfd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lâ Yesu a swoŋ mə, “Ŋù yì mɔ̀ꞌɔ à mɔ̀ɔ̀ntə ghâ; mə̀ yuꞌu mɨ̀dàꞌà mɨ fɛ̀ꞌɛ a nu mə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","M̀bə yìi mə màŋgyɛ̀ wa à lɛ nyə mə kaa mbə yu waꞌà lə̀ə̀ntə̀ aa, a tɨgə mfɛꞌɛ, ntsɨ̀gɨ̀nə̀, ŋ̀wo a nsi Yesu, ntɨgə ŋghaa a nsi bə̀ bɨ̀tsɨ̀m ŋ̀kɛꞌɛnə annù yìi a ghɨrə ŋghɨ̀rə̀ yu mɔɔ̀ntə̀ yi aa, bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntəə ghu aa bɨ yuꞌù. A tɨgə̀ ǹswoŋə ajàŋ yìi mə yu lɛ mburə ntɨɨ wa noò mə yu mɔ̀ɔ̀ntə̀ mə atsəŋə atsə̀ꞌə̀ Yesu ya aà. ");
INSERT INTO bfd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu a tɨgə̀ ǹswoŋ a mbo màŋgyɛ̀ wa mə, “Mû ghà, wa àbìintɨɨ̀ yo a ghurə ghô; tɨgə ŋghɛ̀ɛ̀ nɨ̂ m̀bɔɔnə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Àjàŋ yìi mə à lɛ mburə ka kɨ ghàà aa, ŋù a lô wa nda ndɨɨ ndâghotə wa nzì ǹswoŋ ghu mbo mə, “Wa mû ghò wa à kwò mə̂; tsuu ŋgɨꞌɨ a mbo Ǹdɨ̀ꞌɨ̀nnù bǔ kɨ fa.” ");
INSERT INTO bfd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu à yùꞌù mə̂ aa ŋkwiꞌi mə, “Tsuu bɔꞌɔ bə̂, bii tsiꞌì bìì boŋ à ka tɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nòò wa mə à lɛ nghɛ̀ɛ̀ ŋ̀kuꞌu wa nda aa, kaa à lɛ waꞌà bii mə tâ ŋù dàŋ à bu ŋkuu ntsyatə Peta nɨ Jɔn nɨ Jɛms bo bɨ̀ ta bɨ̀ mu wa nɨ̀ ǹdè yì. ");
INSERT INTO bfd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bə̀ bɨtsɨ̀m bìi mə bɨ lɛ ntswe ghu aa bɨ lɛ sɨ yə̀ꞌə̀ m̀buꞌu nɨ̂ nû jyaa nloŋə mu màŋgyɛ̀ wâ; la Yesu a swoŋ a mbo bo mə, “Nɨ̀ tsuu kɨ yə̀ꞌə̀; ǹloŋ mə kaa à sɨ̀ aa kwò kwô, a bwii aa bwìì.” ");
INSERT INTO bfd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bo wyɛ̂ yi, nloŋ mə bo lɛ nzi mə mu wa à kwò mə̂ aà. ");
INSERT INTO bfd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","La Yesu a tswa nɨ̀kwɛɛ nɨ mu wa, ǹswoŋ mə, “Mu, bɨ̀ɨ̀nə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Àzwî mu wa a bû m̀bɨɨ fu, a burə̀ m̀bɨɨnə ŋgaa yî mɔ̀ꞌɔ̂; Yesu a swoŋ mə tâ bɨ̀ lɔɔ ayoo nɨjɨ mfa ghu tâ à jɨ. ");
INSERT INTO bfd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Taà yì bô ǹdè yì naŋsə̀ ǹyɛrə tsiꞌǐ mbə̂nnù; lâ a kwàntə̀ waa mbɨ̀ꞌɨ̀ bo lǒ nswoŋə annù yìi mə a fɛꞌɛ a mbo ŋù. ");
INSERT INTO bfd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu a twoŋ ŋgǎŋyəgə̂nnù ji jya nighûm ǹtsò baa mfa mɨtɨ̀ɨ̀ bo bɨ̀ àdàꞌà mə, bo ka mfiꞌi ɨzwì jî bɨ ŋkɨɨ ŋghurə nɨ mɨ̀ghɔ̀ɔ̀. ");
INSERT INTO bfd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ǹtɨgə ntoo waa mə tâ bo ghɛɛ ŋka nswoŋə annù nloŋ annù nɨfɔ̀ Nwî ŋ̀kɨɨ ŋghurə nɨ mɨ̀ghɔ̀ɔ̀. ");
INSERT INTO bfd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","À kà mə̂ aa ntoo waa nswoŋ mə, “Nɨ̀ tsuu ayoò tsu lǒ lɔ̀gə̀, kə̌ ati yî tswìꞌì, kə̌ abàà, kə̌ mɨjɨ, kə̌ ŋgabə, ntsuu ɨtsə̀ꞌə̀ ji baa lǒ lɔ̀gə̀. ");
INSERT INTO bfd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nɨ̀ ghɛɛ ŋghɛ̀ɛ̀ ŋ̀kuu a nda yìi nɨ̀ kùu ghu aa, nɨ̀ tswê ghu, nyweꞌe noò yìi mə nɨ̀ ka lə̌ bǔ fɛ̀ꞌɛ ghɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bɛɛ nɨ̀ ghɛɛ ŋkuu a adɨgə bɨ tsuu ghuu kwɛrə, nɨ̀ ghɨrə tɨ fɛ̀ꞌɛ̀ ghu, nɨ̀ yɛ̂tə̀ àbɨ̀rə̀ yìi mə a tswe a mɨkòrə̂ bù aa, a ndɨ̀ꞌɨ mə kaa bǔ bo sɨ̀ nɨ̂ ànnǔ tsǔ burə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bo tɨgə̀ m̀maꞌatə ŋghɛ̀ɛ̀ ǹtsya nɨ a ɨtoo ɨtoo nswoŋə nɨ̂ ǹtoo yì sɨgɨ̀nə̀ ya, ŋkɨɨ ŋghurə nɨ bə̀ a ɨdɨgə tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nòò yìi mə Herod yìi mə à lɛ mbə Mfɔ̀ a alaꞌa Galilea aa, à lɛ nyuꞌu ɨnnù ma jû aa, àtû yì a lɛ mbùùrə̀, nɨ̀bɔꞌɔ tswâ yi, nloŋ mə bə̀ bì mɔꞌɔ lɛ sɨ swoŋə nɨ mə Jɔn Ŋgàŋmùrə bə̀ a Ŋkì à bù mə̂ m̀bɨɨnə nɨ nɨ̀wô. ");
INSERT INTO bfd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bǐ mɔꞌɔ swoŋə̀ nɨ mə, Elijah à bù mə̂ m̀bɨɨ fu, bǐ mɔꞌɔ kɨɨ̀ ǹswoŋə nɨ mə ŋgàŋntoò Nwì yì m̀bìi mbìì yì mɔꞌɔ à bù mə̂ m̀bɨɨ fu. ");
INSERT INTO bfd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod a swoŋə̀ nɨ mə, “Mə̀ kɨ̀ kwyə̂ àtu Jɔn, ghuù ŋù mə mə̀ bù ǹtɨgə nyuꞌu nɨ̂ ànnù ǹloŋ ŋgaà yì aa à nɨ ghuu aa ɛ?” Ǹtɨgə nlɔɔ nɨ mə yu lɨ̀gɨ̀nə yə yi. ");
INSERT INTO bfd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nòò yì mə ŋgǎŋtoo jya ɨ lɛ mbù m̀bɨɨ aa, bo lɛ kɛ̀ꞌɛ̀nə ɨnnù jìi mə bo lɛ ŋghɨ̀rə̀ aà a mbo Yesu, A swûŋtə̀ waa, ǹlɔgə waa bo bo lô ŋ̀ghɛɛ ntswe a alaꞌa Bethsaida. ");
INSERT INTO bfd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nòò yìi mə bə̀ bì ghàꞌàtə̀ lɛ nyuꞌu mə bo tswe ghu aa, bɨ yoŋə̀ yi ghu. A kwɛrə̀ waa ghu ntɨgə ŋghaa a mbo bo nloŋ annù nɨfɔ̀ Nwî ŋkɨ ŋghurə bə̂ bìi mə nɨ̀ghɔ̀ɔ̀ lɛ ntswe a nu bo aà. ");
INSERT INTO bfd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ɨ̀tugə ɨ lɔ̀gɨ̀nə̀ mə̂ ŋ̀ka mfii, ŋgǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa ɨ zî ghu mbo nswoŋ mə, “Màꞌàtə nnɔ̀ɔ bə̂ ghû tâ bo ŋghɛɛ mə mbə bo kuu a mûm mɨ̀kurə bo bɨ̀ a mbɛ̀ɛ ɨfɔ̀ jû mə mbə bɨ yə̂ àyoo ghu njɨ kə̀ ŋkɨ nyə adɨgə yî lɛ̀ ghu, ǹloŋ mə àdɨ̀gə̀ yû mə bìꞌinə̀ tswe ghu aa kaa bə̀ sɨ̀ ghu ghurə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu a kwiꞌi a mbo bo mə, “Bù bumbɔŋ nɨ̀ fa ayoò bo jɨ.” Bo swoŋ ghu mbo mə, “Kaa bìꞌì sɨ̀ nɨ mɨ̀jɨ mî dàŋ tswê, ǹtsyatə ŋkya abaa ji ntaà nɨ m̀bwɛ̀ mi mbaà. Mbə a bə yìi mə bìꞌinə̀ tswe nɨ̂ ǹjɛ̀ꞌɛ̂ bə̀ bû bɨtsɨ̀m boŋ bìꞌinə̀ tswe nɨ̀ ŋ̀ghɛɛ nyuu mɨjɨ a mbo bo.” ");
INSERT INTO bfd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bə̀ bìi mə bɨ lɛ ntswe ghu aa lɛ mbə mbâŋnə ntsùꞌù ji ntaà. A swoŋ a mbo ŋgǎŋyəgə̂nnù ji jya mə, “Nɨ̀ ghɨrə tâ bo tswe a nsyɛ ɨkɨ̀rə ɨkɨ̀rə̀, tâ bə̀ tswe nɨ̂ àkɨ̀rə̀ yî fùùrə̀ mɨghum mi ntaà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bo lɛ ŋghɨ̀rə̀ tsiꞌì maa ajàŋ bə̀ bya bɨ̀tsɨ̀m tswê a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A lɔgə̀ ŋ̀kya baa jya ji ntaà bo bɨ̀ m̀bwɛ̀ mya mi mbaa, ŋŋɛntə miꞌì mi a ndəŋ, ntsaꞌatə Nwî, ǹnɨŋ mbɔɔnə ghu, mbatə mfa a mbo bo mə bɨ̀ fa a mbo bə̀ byâ. ");
INSERT INTO bfd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bə̀ bɨ̀tsɨ̀m lɛ njɨ nyurə, bɨ ghotə̀ àbùgə̀, ǹwùkə̂ ji ɨ luu ŋkyɛ̀ nɨghûm ǹtsò ji baà. ");
INSERT INTO bfd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A bə njwi yì mɔ̀ꞌɔ Yesu a kâ ǹtsaꞌatə Nwî tsiꞌì yù. Ŋ̀gǎŋyəgə̂nnù ji ɨ tswê ghu mbɛ̀ɛ̀, a betə̀ waa mə, “Bə̀ bɨ swoŋ nɨ mə mə̀ bə aà wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bo kwiꞌi mə, “Jɔn Ŋ̀gàŋmùrə bə̌ ŋkì.” Bi mɔꞌɔ mə, “Elijah.” Bǐ mɔꞌɔ swoŋə̀ nɨ mə, “Ŋ̀gàŋntoò Nwì yî m̀bìi mbìì wa yì mɔ̀ꞌɔ̂.” ");
INSERT INTO bfd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A betə̀ waa mə, “Lâ nɨ̀ swǒŋ yuu ŋgaa mə mə̀ laa mbə wo aa ɛ?” Peta a kwiꞌi mə, “Ò nɨ Àyɔꞌɔ̀ Nwì wâ.” ");
INSERT INTO bfd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu a kwântə̀ waa nswoŋ mə tâ bo tsuu a mbo ŋù tsǔ lǒ swoŋə. ");
INSERT INTO bfd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ŋ̀kɨ mbu nswoŋ a mbo bo mə, “Mu Ŋù à ka yə mbuu ŋgɨꞌɨ jì ghàꞌàtə̀ tâ bɨ̀tà bɨ alaꞌa, bɨlɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì, nɨ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀, tâ bɨ̀ tuu yi, ǹzwitə yi, a tɨ bə nɨ̂ ǹjwi ji tarə, a bû ǹyweenə nɨ nɨ̀wô.” ");
INSERT INTO bfd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A swoŋ a mbo bə̀ bɨ̀tsɨ̀m mə, “M̀bə ŋù tsù à ka nlɔɔ a ŋka nyòŋə a njɨ̌m mə̀ a tuù ɨ̀bɨɨ nû yì, m̀beꞌe ati bàŋnə̀ bàŋnə̂ yi ŋka nyoŋə nàa tsiꞌì ǹjwî tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ǹloŋ mə ŋù ǹtsɨ̀m yìi mə a lɔ̀ɔ a nyweensə̂ ɨ̀bɨɨnû yi aa, à ka bàŋnə bwɛ; lâ ŋù ǹstsɨ̀m yìi mə a lɔ̀ɔ a mbwɛ̂ ɨ̀bɨɨnû yi nloŋ ŋkwɨtû gha aa, a ka bàŋnə yweensə. ");
INSERT INTO bfd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","M̀bə a kwɛtə ŋû tsù aa nɨ̀ àkə̀ mə mbə a tswe nɨ̀ m̀bi yǔ ntsɨ̀m mbaŋnə mbwɛ ɨbɨɨnû yì kə̀ yǐ nyə ŋgɨꞌɨ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","M̀bə ŋù tsù a ka ndɨrə atu nloŋ ŋgaa yà bo bɨ̀ nɨ̀ghàâ na, bəə boŋ Mu Ŋù à ka yǐ kɨɨ dɨ̀rə atu mbɨꞌɨ ŋgaà yì a noò yìi à ka yǐ zì a mum nɨ̀ghaꞌà ni, nɨ nɨ̀ghaꞌa nɨ Ta bo bɨ̀ baangel bi bìi bɨ laa màŋsə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A mbǔ ŋghɛ̀ɛ̀ ghu, mə̀ swoŋ a mbo bù tsiꞌǐ annù nɨ̂koŋ mə, bə̀ bî mɔꞌɔ bɨ təə faà bìi mə kaa bɨ ka yǐ waꞌà kwo, nyweꞌe noò yìi mə bɨ ka yǐ yə annù nɨfɔ̀ Nwî aà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ǹjwi ɨ tsyà mə̂ ji nɨfwaa, a ajàŋ mə à lɛ nswoŋ ɨnnù ma jû aa, a lɔgə̀ Peta, nɨ Jɛms nɨ Jɔn, bo bo kɔꞌɔ ŋghɛ̀ɛ a atu ntaꞌa a ntsàꞌàtə Nwì ghu. ");
INSERT INTO bfd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bo kà mə̂ aa ntsaꞌatə Nwî aa, ǹsî yì bo bɨ̀ ŋ̀kə̀rə̂ yì ɨ ŋ̀kwensə, ɨ̀tsə̀ꞌə̂ ji ɨ tɨgə̀ m̀fuꞌu njɛɛŋkə. ");
INSERT INTO bfd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bô ghə̀ mə̂ aa kɨ yə, bə̀ bi baa bɨ tɨgə̀ ŋ̀ghaa bo bo. A bə Moses bo Elijah ");
INSERT INTO bfd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bìi mə bɨ lɛ nzì a mûm nɨ̀ghaꞌa, ŋ̀ŋweenə, ŋ̀ka ŋghaa bo bo, nloŋ ajàŋə à ka yǐ màŋsə ɨfàꞌâ yi màꞌàtə mbi yu a Yerusalem aà. ");
INSERT INTO bfd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fɨ̀lo fɨ lɛ nnaŋsə ntswe a miꞌi Peta bo bɨ̀ bə̀ bya mə bo bo lɛ ntswe aà. Bo ghə̀ mə kɨ wìꞌìnə̀, ǹyə nɨghaꞌà ni bo bɨ̀ bə̀ bya mə bo bo təə aà. ");
INSERT INTO bfd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Àjàŋ mə bə̀ bya lɛ ŋghə̀ə mmàꞌàtə̀ Yesu ɨ lò aa, Peta a swoŋ mə, “Taà, a bɔŋ mə bìꞌinə̀ tswe faà aà. Tâ bìꞌì ghurə mɨ̂ntàŋ mi ntarə̀, tâ yì fùùrə̀ ɨ̀ tswe a mbo wò, yǐ mɔꞌɔ ɨ̀ tswe a mbo Moses, tâ yǐ mɔꞌɔ ɨ̀ tɨgə ntswe a mbo Elijah.” (Kaa à lɛ ŋwaꞌǎ annù yìi mə yu swoŋə aa zî.) ");
INSERT INTO bfd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Àjàŋə à lɛ mburə kɨ ghàà aa, m̀bàꞌà ɨ wiꞌìkə̀ ǹzi ŋkusə waa. Nɨ̀bɔꞌɔ nɨ tswa ŋgǎŋyəgə̂nnù jyâ. ");
INSERT INTO bfd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bo yuꞌù ǹjì ɨ ghaà wa mûm m̀bàꞌà ǹswoŋ mə, “À nɨ Mû ghà yìi mə̀ tsɔ̀ꞌɔ aa à ghulà; nɨ̀ ka nyuꞌu annù yìi a swoŋə aà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nòò yìi mə ǹjì ya ɨ̀ lɛ ŋkɛntə aa, bo tɨgə̀ ǹyə Yesu tsiꞌì yùyù. Bo lɛ ŋkutə mɨ̂ntsû myaa, kaa ŋkɨꞌɨ̀ ànnù yìi mə bo lɛ nyə aa a mbo ŋù tsù maa noò swoŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Àbɛ̀ɛ̀ a fùꞌù mə̂, Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji jya bɨ sɨgə wa atu ntaꞌa, ǹnɔ̀ɔ̀ bə̂ yî wè ɨ zî ǹtsiꞌi yi. ");
INSERT INTO bfd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋù yì mɔ̀ꞌɔ wa a tɨtɨ̀ɨ nnɔ̀ɔ̀ a tɔŋnə̀ ǹswoŋ mə, “Ǹdɨ̀ꞌɨ̀nnù, mə̀ buꞌù m̀bô, kwɛtə a mû ghà ghû, ǹloŋ mə à nɨ tsiꞌì mu yìi mə mə̀ tswe nɨ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Àzwì yî bɨ a yi naŋsə̀ ŋ̀ko mu ghù m̀maꞌa a nsyɛ, ŋghɨ̀rə̀ a wiꞌìkə̀ m̀boꞌo, a tsɨgə̀ yi, àjwòꞌò a tɨgə̀ m̀fɛꞌɛ ghu ntsù. A naŋsə̀ ǹwukə yi kaa waꞌà wàŋsə̀ m̀bii mmaꞌatə yi. ");
INSERT INTO bfd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mə̀ ghɨ̀rə mbuꞌu mbo a mbô ŋ̀gǎŋyəgə̂nnù jo mə tâ bɨ fiꞌi azwì ya, kaa bo waꞌǎ mfiꞌi zî.” ");
INSERT INTO bfd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu a swoŋ mə, “Oò, bù bə̂ bìi mə bɨ sɨ̀ nɨ̂ àbìintɨɨ tswê, kaa ɨnnû jyaa ɨ waꞌà tsinə̀ aa, mə̀ ka bǔ tswe biꞌinə̀ ɨ kɨɨ kɨ tswa ntɨɨ̀ gha nloŋ ŋgaà yùù ɨ yweꞌe aa a noò àkə̀ aa ɛ? Zì nɨ mu ghò wa faà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","À kà mə aa zi nɨ ghu, àzwì yî bɨ ya a kô yi mmaꞌa a nsyɛ ntsɨ̀gə ntɨgə ǹlɔɔ tsiꞌì ǹsàtə̂. Yesu a wenə̀ àzwì yî bɨ ya, ŋghurə mu wa mfa a mbo taà yì. ");
INSERT INTO bfd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bə̀ bɨ̀tsɨ̀m lɛ nyɛrə a ajàŋə mə bɨ lɛ nyə mɨdaꞌa mɨ Nwî aà. Àjàŋ mə bo lɛ mburə kɨ waꞌa ma jû ɨ̀nnù mə à lɛ ŋghɨ̀rə̀ aa, a swoŋ a mbo ŋgǎŋyəgə̂nnù ji mə, ");
INSERT INTO bfd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nɨ̀ naŋsə nyuꞌutə nɨghàà nû ta nɨ̀ kuu a atu bù. Bɨ ka fa Mu Ŋù a mbo bə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lâ kaa bo lɛ ŋwaꞌà yuꞌu tâ àtù yaa a laa ghu. Ǹloŋ mə bɨ lɛ nlɔ̀ꞌɔ̀sə̀ a mbo bo mə tâ bo tsuu zi; bo kɨɨ̀ m̀bɔꞌɔ nɨ a mbetə̂ yi. ");
INSERT INTO bfd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bo lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka nswuŋnə, m̀betə nî waa bo nɨ bo mə ŋù yìi mə à kɔ̀ꞌɔ ntsɨrə a tɨtɨ̀ɨ bo aa à nɨ wò aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu a zî ànnǔ yìi mə bo lɛ sɨ waꞌatə nɨ a ntɨɨ bo aà, ǹlɔgə mûŋkhə ntɛꞌɛ a mbɛ̀ɛ yu, ");
INSERT INTO bfd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ǹswoŋ a mbo bo mə, “Ŋù ǹtsɨ̀m yìi mə à kwɛrə mu ghù nɨ ɨ̀kǔm gha aa, à kwɛ̀rə aa ghâ. Ŋù ǹtsɨ̀m yìi mə à kwɛ̀rə gha aa, à kɨ ŋkwɛrə ŋù yìi mə à lɛ ntoo ghâ aà. Ǹloŋ mə aa yu wa yìi à kə̀ꞌə a tɨtɨ̀ɨ bù ǹsɨgə nlwìꞌì aa, à bàŋnə mbə aa yu yìi à kɔ̀ꞌɔ ntsɨrə aà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔn a swoŋ mə, “Taà bìꞌì ghɨrə nyə ŋû yì mɔꞌɔ a fiꞌì nɨ ɨ̀zwì jî bɨ a atoꞌo bə̀ nɨ̂ ɨ̀kǔm gho, bìꞌì tsuꞌunə̀ yi nloŋ mə kaa à sɨ̀ ŋû àkòrə yìꞌinə̀ yî mɔ̀ꞌɔ bə aà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu a swoŋ mə, “Nɨ̀ tsuu nìi kɨ tsuꞌunə bə̂, ǹloŋ mə ŋù yìi mə kaa à sɨ annǔ yiꞌinə̀ tuu aa, à bìi aà ǹjɨ̀m yìꞌinə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Àjàŋ mə nòò à lɛ ŋkòòntə mə bɨ ka bǔ kwɛrə Yesu fu a aburə aa, a kwerə̀ ǹtɨɨ̀ yi, ǹtaŋtə mə yu ghɛ̀ɛ a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ǹtoo bə̂ a mbìì yu mə tâ bɨ̀ ghɛɛ nnaŋsə nɨkurə nɨ Samaria ni mɔꞌɔ a mbo yu. ");
INSERT INTO bfd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","La bə̀ bya bɨ tuù ŋ̀kwɛ̀rə̂ yi, ǹloŋ mə bo lɛ nzi mə à lɛ sɨ tsyà aa bə tsyà ŋ̀ghɛɛ nɨ a Yerusalem aà. ");
INSERT INTO bfd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ŋ̀gǎŋyəgə̂nnù ji, Jɔn bo Jɛms, yə̀ mə̂ maa ajàŋ, m̀betə yi mə, “M̀màꞌàmbî, ò bèèntə mə tâ bìꞌì twoŋ mɔꞌɔ tâ ɨ̀ lo a aburə nsɨgə ntɔɔ waa aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu a bəŋkə yi ŋwenə waa. ");
INSERT INTO bfd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bo tɨgə̀ ǹlo ŋghɛ̀ɛ̀ a nɨkurə ni dàŋ. ");
INSERT INTO bfd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Àjàŋ mə bo lɛ sɨ ghɛ̀ɛ̀ a mânjì aa, ŋù yî mɔ̀ꞌɔ a swoŋ mə, “Mə̀ ka kɨ yòŋə̀ nɨ̂ gho a nɨ̂ ŋ̀gɔ̀ŋ ɨ̀dɨ̀gə tsɨ̀m jìi o ghɛ̀ɛ̀ ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu a kwiꞌi ghu mbo mə, “Ɨ̀tsò ɨ tswe nɨ̀ mɨ̀mborə̀ myaa, bɨ̀sɨŋ bɨ kɨ̂ ǹtswe nɨ̂ ǹdâ jyaa, la kaa Mu Ŋù à sɨ̀ nɨ àdɨ̀gə̀ yìi mə mbə a nɔ̂ŋsə̀ àtû yi ghu mmɨɨntə aa tswê.” ");
INSERT INTO bfd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A mbo ŋù yì mɔ̀ꞌɔ a swoŋ mə, “Zǐ ŋka nyòŋə̀ nàâ.” A bâŋnə̀ ŋ̀kwiꞌi mə, “M̀màꞌàmbî, lə̀ə tâ mə̀ bɨɨ ŋghɛɛ mfoo ntwiŋə taà yaꞌa.” ");
INSERT INTO bfd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A swoŋ ghu mbo mə, “Màꞌàtə̀ tâ bɨ̀ku ka ntwiŋ bɨku bɨ bə̂ byaa. Lâ a mbo wò, ghɛ̀ɛ ŋka nswoŋ ntoò ànnù nɨfɔ̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yì mɔ̀ꞌɔ a swoŋ mə, “Wa mə̀ ka kɨ yòŋə̀ noo Mmàꞌàmbî. La màꞌàtə tâ mə̀ foo ŋghɛ̀ɛ̀ m̀fa fɨlo fɨ bə̂ a ndùgə yaꞌa.” ");
INSERT INTO bfd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu a swoŋ ghu mbo mə, “Ŋù yìi mə à tswa aso afàꞌà m̀bu mbəŋkə yi ŋka nlii njɨ̀mə̀ aa, kaa à sɨ̀ kuꞌùnə̀ a ŋkuu a mûm ànnù nɨfɔ̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma ya à ghə̀ə kɨ tsyǎ Mmàꞌàmbi a bû ǹtsɔꞌɔ bə̂ bi mɔꞌɔ mɨ̀ghum mi sàmbaa ntsò baa ntoo waa mə tâ bo tsya mbìì yì ŋ̀ka nzinə bi baa bi baa ŋghɛɛ nɨ̂ ɨ̀too nɨ̂ ɨ̀dɨ̀gə̀ tsiꞌì tsɨ̀m jìi mə yu ka bɔ̌ŋ zì ghu aà. ");
INSERT INTO bfd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","À kà mə̂ aa ntoo waa nswoŋ mə, “Mɨjɨ mɨ bè mə̂ a nsoo ghaꞌa lâ bɨ̀fùꞌù bâŋnə̀ ŋ̀kəꞌətə; nɨ̀ ka ntsaꞌatə Nwî mə tâ M̀màꞌàmbî m̀bɔ̂ŋ ǹsòò à too ŋgǎŋfàꞌà tâ ɨ̀ ghɛɛ mfùꞌù mɨjɨ̂ mi myâ. ");
INSERT INTO bfd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɨ̀ ghɛɛ lâ, a ajàŋə mə mə̀ too ghuu aa, nɨ ghɛɛ tsiꞌì tsǒ mbinjə̀rə̀ a tɨtɨ̀ɨ bɨ̀takurə̀. ");
INSERT INTO bfd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nɨ̀ tsuu mû àbàa ŋkabə tugɨtə, ntsuu abàà kɨɨ tugɨtə, ntsuu ntam kɨɨ tugɨtə, ǹtsuu kɨ təə a ntsàꞌàtə ŋù tsù a mânjì. ");
INSERT INTO bfd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bɛɛ nɨ̀ yi ŋghɛ̀ɛ̀ ŋ̀kuu nɨ̂ ǹda yìi nɨ̀ ŋkuu ghu aa nɨ̀ fòò ǹswoŋ mə, ‘Â M̀bɔɔnə kuu fàa nda laa.’ ");
INSERT INTO bfd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bɛɛ mə ŋù m̀bɔɔnə a tswe ghu boŋ mbɔɔnə ya ɨ̀ ka kuu ghu nû, a tsuu ghu tswe boŋ mbɔɔnə̂ yùù ya ɨ̀ ka bɨ̀ɨ kuu fu a nu bù. ");
INSERT INTO bfd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bɛɛ nɨ̀ ghɛɛ ŋkuu nɨ̂ ǹda yìi nɨ̀ kuu ghu aa, nɨ̀ lwiꞌì maa nda ŋka njɨ ŋkɨɨ nno nɨ̂ àyoo yìi bɨ fa a mbo bù aà. Ǹloŋ mə wa bɨ tswe nɨ̀ ŋ̀ka ntû ŋ̀gàŋàfàꞌà. Nɨ̀ tsuu a mɨlaꞌa kɨ kuu ghɛɛ, ɨ kuu bɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bɛɛ nɨ̀ yi ŋghɛ̀ɛ̀ ŋkuu a atoo, bɛɛ bɨ kwɛrə ghu sɨgɨ̀nə̀, nɨ̀ ka ǹjɨ ayoo yìi bɨ fa a mbo bù aà. ");
INSERT INTO bfd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nɨ̀ ghurə̀ mɨ̀ghɔ̀ɔ̀ mìi mɨ tswe a nu bə̀ ghu aa, ntɨgə nswoŋə ŋkɛꞌɛnə a mbo bo mə, ‘Wa annù nɨfɔ̀ Nwî a zì mə̂ ŋ̀koontə a nu bù.’ ");
INSERT INTO bfd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lâ, mbə nɨ̀ yi ŋkuu nɨ atoo bɨ tuu ghuu ghu kwɛrə, nɨ̀ fɛꞌɛ̀ ŋ̀ghɛɛ a mɨ̂mfâŋnə̀ ǹswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Àbɨ̀rə alaꞌà yuu yìi mə a ghɨrə mbanə a mɨkòrə bìꞌì aa, bìꞌi yɛ̀tə̀, a ndɨ̀ꞌɨ mə kaa bìꞌinə̀ sɨ̀ nɨ̂ ànnǔ tsu tswê. Lâ bìꞌi swoŋ a mbo bù mə ànnù nɨfɔ̀ Nwî a zì mə̂ ŋ̀koontə a nu bù.’ ");
INSERT INTO bfd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mə̀ swǒŋ a mbo bù mə ŋgɨꞌɨ̀ àtoo mà ya a njwî ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa ɨ̀ ka yǐ tsyàtə yî Sodom. ");
INSERT INTO bfd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ŋ̀gɨꞌɨ yì ŋ̀wè ɨ̀ tswe a mbo wò m̀bâ Chorazin, bo bɨ̀ a mbo wò mba Bethsaida, nloŋ mə bɨ lɛ mbaa bə ghɨ̀rə ɨnnù jî wè jî wè jû mə bɨ ghɨ̀rə a alaꞌa bù aa a alaꞌa Tai kə̀ Sidon boŋ bɨ lɛɛ̀ m̀bəŋkə mɨ̂ntɨɨ̀ myaa tɛtə̀, ǹtɨgə ŋwɛꞌɛ ɨtsə̀ꞌə ŋgɨꞌɨ ŋkɨ mfuꞌu atû yaa nɨ̂ àbû. ");
INSERT INTO bfd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lâ a ka yǐ swèrə a mbo bù wa jwî ǹstsɔ̀ꞌɔ̀tə mɨ̀saꞌa ɨ tsyàtə̀ a mbo Tai bo Sidon. ");
INSERT INTO bfd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ŋ̀gaa yò ɨ bə mə akə aa ɛ, a Kapernaum? Ò ghɨ̀rə ŋwaꞌatə mə bɨ ka ŋɛntə ɨbɨɨ nû ghoɨ kɔꞌɔsə gho a aburə aa ɛ? Wa bɨ ka yǐ màꞌà gho ò sɨgə ŋghɛɛ a bâŋnsyɛ̂.” ");
INSERT INTO bfd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu a swoŋ a mbo ŋgǎŋyəgə̂nnù ji jya mə, “Ŋù yìi mə a bìî ànnù yìi nɨ swoŋə aa, à bìi aa annû yâ. Ŋù yìi a ntùû ànnù yìi nɨ swoŋə aa, a kɨ ntuu aà ghâ. Ŋù yìi mə à tùu gha aa, à kɨ ntuu aa yu wa yìi mə à lɛ ntoo gha aà.” ");
INSERT INTO bfd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bə̀ bya mɨ̀ghum mi sàmbaa bɨ lɛ mbɨ̀ɨ̀ nɨ nɨ̀dorə nswoŋ mə, “M̀màꞌàmbî tsiꞌì bɨ̀demon bɨ ghɨ̀rə̀ ǹyuꞌunə nɨ̂ yiꞌi nloŋ ɨkûm ghô.” ");
INSERT INTO bfd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A swoŋ a mbo bo mə, “Mə̀ ghɨ̀rə nyə Satan a lô a aburə ŋwo tsiꞌì tsǒ m̀bə̀ŋ yî ŋ̀wàꞌàkə̀. ");
INSERT INTO bfd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yə̂ nɨ̀, mə̀ fà mə̂ àdaꞌa a mbo bù mə nɨ̀ ka ntəəntə a atu no bo bɨ̀ bàŋgaa bî bɨ̂, ŋ̀kɨɨ ŋghaꞌa nɨ̂ àdàꞌa ŋgàŋkɨ̀bàà wa kaa tâ àyoò tsu waꞌà ghuu ləənsə̀. ");
INSERT INTO bfd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lâ ta nɨ̀ tsuu kɨ dorɨtə bə mə ɨ̀zwì jî bɨ yuꞌunə nɨ̂ ghuu, nɨ̀ ka ndorɨtə nɨ̀ bə mə bɨ ŋwàꞌànə̀ mə̂ mɨkûm muu a aburə aà.” ");
INSERT INTO bfd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A bə maa noò, Yesu a dorɨtə̀ a mûm Àzwì Nwî ǹswoŋ mə, “Taà, mə̀ fâ m̀bɨꞌɨkə a mbo wò a Mmàꞌàmî àbùrə̀ bô ǹsyɛ nloŋ mə ò lɔ̀ꞌɔ̀sə ɨnnù jûla a mbô ŋ̀gàŋmɨtsyɛ̀ bo bɨ̀ bə̀ bìi bɨ zi annù aa, mbàŋnə̀ ǹdɨꞌɨ a mbo bɔɔ bì bɔrə̀. Ɨ̀ɨ̀ŋə, Taà ghà, a bə̂ àjàŋ yìi mə a lɛ mbɔ̀ŋə̀ gho mə tâ ò ghɨrə aà. ");
INSERT INTO bfd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Taà ghà à fà mə ɨ̀nnù tsɨ̀m a mbo mə̀. Kaa mbə ŋù waꞌǎ ŋù yìi Mu à nɨ ghu aa zi ntsya a Ta. Kaa ŋù a waꞌǎ a Ta ŋkɨ nzi ntsya Mu, mə mbə a tsuu ŋû yìi mə Mu à tsɔ̀ꞌɔ mə yu dɨ̀ꞌɨ̀ a Ta ghu mbo aa bə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesu a bəŋkə̀ yi nswoŋ a mbo ŋgǎŋyəgə̂nnù ji jya mə, “M̀bɔɔnə a mbo miꞌi mìi mə mɨ yə annù yulà mə nɨ yə aà, ");
INSERT INTO bfd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ǹloŋ mə mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋə mə, ŋgǎŋntoo Nwî jî ghàꞌàtə̀ bo bɨ̀ bɨ̀fɔ̀ bî ghàꞌàtə̀ bɨ lɛ sɨ yə̀ꞌə̀tə̀ a nyə ma juù ɨ̀nnù mə nɨ yə aa, la kaa waꞌà yə̂. Ǹyəꞌətə nɨ a nyuꞌu ɨnnù jû mə nɨ yuꞌu aa kaa waꞌà yuꞌù.” ");
INSERT INTO bfd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ŋ̀gàŋndɨ̀ꞌɨ nɔ̀ŋsə̀ yì mɔ̀ꞌɔ à lɛ ŋkwàꞌànə̀ yi nswoŋ mə, “Ǹdɨ̀ꞌɨ̀nnù, m̀bə mə̀ ghɨrə̀ mə akə mbɔŋ jɨ ɨlòŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A betə̀ yi mə, “O twoŋə nyə mə bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ nɔ̂ŋsə̀ aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A kwiꞌi mə, “Tɨgə ŋkɔ̀ŋə M̀màꞌàmbi Nwìŋgɔ̀ŋ ghò nɨ̂ ǹtɨɨ̀ ghô tsɨ̀m, nɨ̂ ǹtswêntɨ̀ɨ̂ yǒ ɨ tsɨ̀m, nɨ mɨ̀tɨ̀ɨ̂ mo mɨ̀tsɨ̀m bo bɨ̀ nɨ mɨ̀tsyɛ̂ mo mɨ̀tsɨ̀mə̀. Ɨ kɨɨ tɨgə kɔ̀ŋə ndɨ̂m ghò tsǒ ɨ̀bɨɨ nû ghô.” ");
INSERT INTO bfd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu a swoŋ ghu mbo mə, “Ò kwiꞌi tsiꞌì sɨgɨ̀nə̀. Ka ŋghɨ̀rə̀ ma mùu ajàŋ boŋ ò ka tswe ntɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Àjàŋ mə à lɛ sɨ lɔ̀ɔ ndɨ̀ꞌɨ mə ànnù yi a tsinə aa, a bû m̀betə Yesu mə, “Ǹdɨm ghà aa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu a kwiꞌi ghu mbo mə, “Ŋù yì mɔ̀ꞌɔ à lɛ nlǒ a Yerusalem ŋka nsɨgə ŋghɛɛ a Yeriko, bɨ̀yərə bɨ tswâ yi, ntsɔꞌɔtə ɨtsə̀ꞌə̀ ghu nu, naŋsə ŋghɔɔ yi tsiꞌì sɨgɨ̀nə̀, a tɨgə̌ ŋkwo, bo maꞌàtə̀ ǹlo waa, ");
INSERT INTO bfd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ŋ̀gàŋmàꞌa Nwì yî mɔ̀ꞌɔ à lɛ ŋka nzi maa mânjì, à zì mə̂ m̀fɛꞌɛ ghu nu aa, ǹdaŋsə mbɛ̀ɛ̀, ǹstya yi. ");
INSERT INTO bfd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mu Levi yî mɔ̀ꞌɔ à lɛ ŋkɨ nzi nyə, ŋ̀ghɨrə tsiꞌì maa ajàŋ, ǹdaŋsə mbɛ̀ɛ̀ ntsya yi, ");
INSERT INTO bfd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lâ ŋù baSamaria yî mɔ̀ꞌɔ yìi à lɛ ŋka ŋghɛɛ a nɨghaa yu aa, à lɛ nzì nyə, ŋko mɨlɨ̀ŋnə̀ yì. ");
INSERT INTO bfd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ŋ̀ghɛɛ ghu mbɛ̀ɛ̀, nsiꞌi ɨlaꞌà ji jya, ǹnɨŋə afù ghu ŋkwerə, ntswesə yi a atu nàa yu, ǹlɔgə yi ŋghɛɛ nɨ ghu a nda bɨ̀gɨ̀ɨ̀, a nlèntə̂ yi ghu. ");
INSERT INTO bfd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bo yu lɛ ghu, àbɛ̀ɛ̀ a fùꞌù mə̂, a ghə̂ yu kɨ ghɛ̀ɛ̀, m̀fiꞌi ɨbàꞌatə ŋkabə silva ji baa, mfa a mbo ŋù ǹlèntə ǹdâ bɨ̀gɨ̀ɨ̀ wa, ǹswoŋ mə, ‘Ka nlèntə̀ nìi, bɛɛ mə a lɔgə ŋkabə ntsyà yulà, boŋ maa bǔ bènsə̀ fu, a noò yìi mə bɨ̀ɨ̀ aà.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu a betə̌ ndɨ̀ꞌɨ̀ nɔ̀ŋsə̀ wa mə, “Ò wàꞌàtə mə ǹdɨm ŋù wa mə bɨ̀yərə bya lɛ ŋghɔ̀ɔ̀ yi aa, a tɨtɨ̀ɨ bə̀ buà bi tarə, à nɨ wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A kwiꞌi mə, “Ŋù wa mə à lɛ ŋko mɨlɨ̀ŋnə̀ yì aà.” Yesu a swoŋ ghu mbo mə, “Ghɛ̀ɛ ŋkɨ ŋka ŋghɨ̀rə̀ maa ajàŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu bo bɨ̀ ŋgǎŋyəgə̂nnù ji ɨ lɛ ghɛ̀ɛ̀ ŋ̀kuu a nɨkurə nǐ mɔꞌɔ, màŋgyɛ̀ yî mɔ̀ꞌɔ, ɨ̀kǔm yi ɨ bə Martha, a twoŋə̀ yi a nda yu, ");
INSERT INTO bfd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Muma bɨ̀ màŋgyɛ̀ wa, ɨ̀kǔm yi ɨ bə Mary a tswê bo yu. Yesu à zì mə̂ aa, a zî ǹtswe yi tsiꞌì a mbɛ̀ɛ mɨkòrə Yesu, ǹyuꞌutə nɨ̂ ànnù yìi à lɛ sɨ dɨ̀ꞌɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lâ Martha à lɛ sɨ nwùgə nû yi, ŋwaꞌa tsiꞌǐ annǔ a ŋghɨ̀rə mɨ̀jɨ a mbo bɨ̀gɨ̀ɨ̀ byâ. À lɛ nzì ǹswoŋ a mbo Yesu mə, “M̀màꞌàmbî, ò sɨ̀ yə mə à nɨ̂ ànnù yì bɨ mə mumaà à ghɨ̀rə, mə à màꞌàtə gha tsiꞌì mə̀ mə̀, mə̀ yə nɨ̀ ŋgɨꞌɨ a nɨ mɨ̀jɨ mù aa ɛ? Ghààntə̀ yi tâ à zi ŋkwɛtə ghâ.” ");
INSERT INTO bfd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu a swoŋ ghu mbo mə, “Martha, Martha! O nwùgə nû yò siꞌi a nɨ ɨ̀nnù jî ghàꞌàtə̀! ");
INSERT INTO bfd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Àyoo yì fùùrə̀ a kuꞌunə a ntswe nɨ̀ yù. Mary à tsɔ̀ꞌɔ̀ mə mbɛ̀ɛ̀ yî sɨgɨ̀nə̀ kaa mbə ŋù a waꞌà ghu mbo kwɛrə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesu à lɛ sɨ tsàꞌàtə̀ Nwî a adɨgə yî mɔꞌɔ, à màŋsə̀ mə aa, ŋ̀gàŋyəgə̂nnù yì yî mɔ̀ꞌɔ a swoŋ ghu mbo mə, “M̀màꞌàmbî, dɨ̀ꞌɨ ntsàꞌàtə Nwî a mbo bìꞌì, tsǒ mə Jɔn à lɛ ndɨ̀ꞌɨ̀ a mbo ŋgǎŋyəgə̂nnù ji aà.” ");
INSERT INTO bfd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu a swoŋ a mbo bo mə, “Nɨ̀ kɨɨ tɨ tsàꞌàtə̀ Nwî nɨ̀ swoŋ mə: ‘Taà yìꞌì, ghɨ̀rə tâ bìꞌi ka ŋghaꞌasə Ɨkûm ghô. Tâ ànnù nɨfɔ̂ yo à zi. ");
INSERT INTO bfd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ka mfa mɨjɨ mìi mə mɨ kuꞌunə a mbo bìꞌì aa a njwi njwî; ");
INSERT INTO bfd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ŋ̀kɨ ŋka nlìꞌìnə̀ nɨ̂ ɨ̀fansənnù jiꞌi, nloŋ mə bìꞌi ŋkɨɨ nliꞌinə nɨ̂ jì bə̂ bìi mə bɨ fànsə a nu bìꞌì aà; ǹtsuu kɨ bii bìꞌì ka ŋwo nɨ̂ àkwàꞌànə̀ bə̂.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A bû ǹswoŋ a mbo bo mə, “M̀bə ŋù nɨ̀bô ghùù a ghɛɛ̀ a mbo nsûkàꞌâ yì nɨ̂ ǹtɨɨ ɨtugə nswoŋ ghu mbo mə, ‘Ǹsû ghà, tsɔꞌɔsə gha nɨ̀ ŋ̀kya abaa ji tarə; ");
INSERT INTO bfd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ǹloŋ mə ǹsû ghà yî mɔ̀ꞌɔ à lo nɨghaa a asàꞌa aghaꞌa nzì, kaa mə̀ waꞌà nɨ̂ àyoo nɨjɨ a mfa ghu mbo tswê.’ ");
INSERT INTO bfd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","M̀bə nsû yì wa a nɔŋə a ɨkuu ŋkwiꞌi ghu mbo mə, ‘Tsùu ŋgɨꞌɨ a mbo mə̀ fa; mə̀ tsètə̀ mə abàꞌâ yâ, bìꞌi bɨ̀ bɔɔ̀ ba nɔ̂ŋtə̀; kaa mbə mə̀ waꞌà bù m̀bɨɨnə a mfâ àyoo a mbo wò.’ ");
INSERT INTO bfd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mə̀ swòŋ a mbo bù mə, mbə tuu bɨ̀ɨ̀nə fa ayoo ghu mbo mə à nɨ nsûkàꞌâ yì aa, lâ ǹyoŋə ajàŋ yìi mə à ghɛ̀ɛ nɨ̂ m̀bìì ŋ̀ka mbetə kaa waꞌà lò aa, à ka bɨ̀ɨ̀nə fa njoò tsɨ̀m jìi mə a lɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ma mùu ajàŋ, mə̀ swòŋə a mbo bù mə: Nɨ ka mbetə boŋ bɨ ka fa a mbo bù; nɨ̀ ka nlɔɔ boŋ nɨ̀ ka yə; nɨ̀ ka ŋkwɛntə boŋ bɨ̀ ka ŋaꞌa fa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ǹloŋ mə ŋù ǹtsɨ̀m yìi a betə aa, a kwɛrə; ŋù ǹtsɨ̀m yìi mə a kɨɨ nlɔɔ aa a yə̂. Ŋù yìi mə a kwɛ̀ntə̀ aa bɨ kɨɨ̀ ŋ̀naꞌa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tà yî tsù à tswe a tɨtɨ̀ɨ bù mə mbə mû yì a betə fɨbwɛ̀, a tswe tɨ̀ fa fɨ̀bwɛ̀ m̀baŋnə mfa bə no ghu mbo ");
INSERT INTO bfd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","kə̌ a betə nɨbòò nɨ ŋgu ghu mbo a bâŋnə̀ m̀fa bə̂ àŋgaa ghu mbo aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","M̀bə bù bìi mə nɨ̀ nɨ ŋgǎŋghɨ̀rə ɨnnù jɨ̂ bɨ aa, nɨ̀ zi ajàŋ yìi mbə nɨ̀ ka mfa njoo jì sɨgɨ̀nə̀ a mbo bɔɔ̀ buu, nɨ̀ sɨ̀ waꞌatə̀ mə mbə Taà ghùù yìi mə à tswe a aburə aa a naŋsə ŋkɔŋtə a mfâ Àzwî yi a mbo bə̀ bìi mə bɨ betə nɨ̂ yi ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu à lɛ sɨ fiꞌi azwì yî bɨ yìi mə a lɛ mbə yî tɨ ghàà; nòò yìi mə àzwì yî bɨ ya a lɛ mfɛ̀ꞌɛ̀ aa, àkɨkoꞌo ya a lɔ̀gɨ̀nə̀ ŋka ŋghaa bə̀ bìi bɨ lɛ nyə aa bɨ yɛrə tsiꞌǐ mbə̂ ànnù. ");
INSERT INTO bfd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","La bo bî mɔꞌɔ bâŋnə̀ ǹswoŋ mə, “A fiꞌi nɨ̂ ɨ̀zwì jî bɨ ntsyà aa a njɨ̌m Beezebul, m̀fɔ̀ ɨ̀zwì jî bɨ wâ.” ");
INSERT INTO bfd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","La bə̀ bya bǐ mɔꞌɔ, a ŋkwàꞌànə yu, bɨ bâŋnə̀ ǹswoŋ mə, tâ à ghɨrə annù yî yɛ̌yɛrə a ndɨ̀ꞌɨ mə Nwì à tswe bo yu. ");
INSERT INTO bfd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","M̀bə yìi mə Yesu à lɛ nzi mmɔ̀ɔ̀ntə̂ jyaa aa, a swoŋ a mbo bo mə, “Àlaꞌa yìi mə a yatə waa ntəə a atutu, nto nɨ̂ waa bo nɨ bo aa, a wàŋsə̀ ŋ̀wo. Ŋ̀gwɛ̀ꞌɛ̀ yìi mə ɨ̀ kɨ nyàtə̀ waa laa, ɨ kɨɨ̀ ŋ̀waŋsə ŋwò. ");
INSERT INTO bfd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","M̀bə a bə mə Satan à kɨ nyàtə̀ yi, boŋ à ka kɨ to nìi yumbɔŋ, tâ ànnù nɨfɔ̀ yi təə mə akə aa ɛ? Ǹloŋ mə nɨ̀ swoŋ mə mə fiꞌi ɨzwì jî bɨ aa nɨ̂ mɨ̀dàꞌà mɨ Beezebul. ");
INSERT INTO bfd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mbə mə̀ ka mfiꞌi ɨzwì jî bɨ aa nɨ mɨ̀dàꞌà mɨ Beezebul, boŋ bɔɔ̀ buu tɨgə mfiꞌi aa nɨ̀ mɨ̀dàꞌà mɨ wo aa ɛ? M̀bɛɛ mə a bə maa ajàŋ aa, à nɨ bo bìi mə bo ka yǐ tɨgə tsə̀rə ɨ saꞌà ghuu. ");
INSERT INTO bfd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lâ m̀bə a bə mə mə fiꞌi ɨzwì jî bɨ aa nɨ mɨ̀dàꞌà mɨ Nwî boŋ ànnù nɨfɔ̀ Nwî à zì mə a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nòò yìi mə ǹtɨ̀ɨ̀ ŋù, yìi mə à tswe nɨ̂ ǹjoo mɨtsəꞌə a bɛ ndùgə̂ yì aa, ǹjoò ji ɨ tswe nɨ mbɔɔnə̂; ");
INSERT INTO bfd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lâ m̀bə nyərə yìi mə à tɨ̀nsə ntsyàtə̀ yi aa, mbə a zi boŋ à ka kwɛrə njoo mɨtsəꞌə jya mə à nɨŋ ntɨɨ̀ yì ghu aa, ɨ sɛꞌɛ njoò ji tsiꞌì tsɨ̀m ɨ yàtə. ");
INSERT INTO bfd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ŋù yìi mə à sɨ njɨ̀m yà bii aa, à bii aa njɨ̌m ŋgàŋkɨ̀bàâ yà. Ŋù yìi mə à sɨ ghotə aa, a bàŋnə̀ njaꞌa aa jàꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nòò yìi mə àzwì yî bɨ a fɛꞌɛ a nu ŋù aa, a karə a nɨ̂ àdɨ̀gə̀ yìi mə kaa ŋ̀kì ɨ sɨ̀ ghu tswê aa, ǹlɔɔ nɨ mə mbə yu mɨɨ̀ntə̀ ghu lɛ; a tuu yə aa, a swoŋ mə ‘mə̀ ka bù bɨ̀ɨ̀ gha fu a nda yìi mə mə̀ fɛ̀ꞌɛ ghu aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A tɨ bɨ̀ɨ̀ ǹyə mə bɨ yɛ̀ꞌɛ̀ mə nda ya ɨ laa ŋkùꞌùnə̀, ");
INSERT INTO bfd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","boŋ à ka ghɛ̀ɛ bǔ bɨɨ nɨ̂ ɨ̀zwì ji sàmbaa jì bɨ jî dàŋ jìi ɨ bɨꞌɨ ntsyàtə̀ yi, ɨ zî ŋ̀kuꞌusə yi ghu tâ bo bo kuu ŋkuu ntswe ghu; bɛɛ ɨ kuu maa noò boŋ ǹtswê ŋù wa ɨ̀ ka bɨꞌɨ tsyàtə ajàŋ yìi à lɛ mbə a mbìì aà.” ");
INSERT INTO bfd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Àjàŋ mə Yesu à lɛ mmàŋsə nswoŋə ma jû ɨ̀nnù aa, màŋgyɛ̀ yî mɔ̀ꞌɔ wa atɨtɨ̀ɨ nɔ̀ɔ̀ a swoŋ ghu mbo mə, “M̀bɔɔnə a mbo màŋgyɛ̀ yìi mə à lɛ njwe gho aa bo bɨ a nɨ̂ m̀bɨɨ mìi mə mɨ lɛ nɔŋsə gho aà!” ");
INSERT INTO bfd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","La Yesu a bâŋnə̀ ŋ̀kwiꞌi mə, “M̀bɔɔnə ɨ̀ bàŋnə̀ ǹtswe aa a mbo bə̀ bìi mə bɨ yuꞌu nɨghàà nɨ Nwî ǹləə aà!” ");
INSERT INTO bfd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nòò yìi mə nnɔ̀ɔ̀ bə̂ wa ɨ lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka ŋghaꞌatə aa, Yesu a beꞌenə̀ ŋka nswoŋə mə, “Nɨ̀wàà nɨ bə̂ buà tsɨ̂tɔ̀ŋ à nɨ nɨ̀wàà nî bɨ̂; bɨ lɔ̀ɔ nyə̂ àlènsə̀, la kaa mə̀ ka waꞌǎ alènsə̀ yi dàŋ a mbo bo fa ntsya alènsə̀ Jonah. ");
INSERT INTO bfd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ǹloŋ mə ajàŋ yìi mə Jonah à lɛ mbə alènsə̀ a mbo baNineveh aa, àâ ŋ̀gɨ̌ŋ ŋgɨ̀ŋ àjàŋ yìi mə Mu Ŋù à ka bə alènsə̀ a mbo nuà nɨ̀wàà. ");
INSERT INTO bfd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","M̀fɔ̀ màŋgyɛ̀ wa yìi mə à lɛ nlò a mbùꞌù ǹtii aa, à ka yǐ bɨ̀ɨ̀nə a noò ǹtsɔ̀ꞌɔ̀tə̀ mɨsaꞌa bo bɨ̀ nɨ̀wàà nɨ bə̂ bû tsɨ̂tsɔ̀ŋ ɨ nɨŋə wa a ɨsaꞌà. Ǹloŋ mə à lɛ nlo a nlwìꞌî m̀bi yù, ǹzi a a nyuꞌu nɨ̀ghàà nɨ mɨtsyɛ̀ a mbo M̀fɔ̀ Solomon, lâ yə̂ nɨ̀, ŋù yìi mə à kɔ̀ꞌɔ̀nə ntsyàtə̀ Solomon aa, à ghuà a tɨtɨ̀ɨ bù. ");
INSERT INTO bfd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bə̀ bɨ Nineveh ka yǐ bɨ̀ɨ̀nə a noò ǹtsɔ̀ꞌɔ̀tə mɨ̀saꞌa, ɨ təə bo bɨ̀ nɨ̀wàà nɨ bə̂ buà tsɨ̂tsɔ̀ŋ, ɨ nɨŋə waa a ɨsaꞌa à; ǹloŋ mə baNineveh lɛ mbəŋkə mɨ̂ntɨɨ̀ myaa wa noò mə Jonah à lɛ ŋghàà a mbo bo aà, lâ yə nɨ̀, ŋù yìi mə à kɔ̀ꞌɔ̀nə ntsyàtə̀ Jonah aa, à ghuà mə a tɨtɨ̀ɨ bù.” ");
INSERT INTO bfd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kaa ŋù à laa ŋwaꞌà nɨ̂ lâm kosə̀ ŋ̀ghɛɛ nnɨŋə nɨ a atà, kə̀ m̀bu nlɔ̀gə̀ nɨ̂ àntɔ̀ɔ̀ ŋ̀kusə ghu, kaa kɨꞌɨ̀ kɨ̀ɨ̀ ŋ̀kosə nnɨŋə nɨ a njiꞌì ɨ̀kùù. Ŋù a kɨɨ ŋkosə lâm, a tɛꞌɛ aa a atu atɛtə̀ tà ŋù tɨ kuu a nda a yə̂ ŋ̀kàꞌà wâ. ");
INSERT INTO bfd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nɨ̀liꞌì no laa mbə lâm ɨbɨɨnû ghô. Nɨ̀liꞌì no bə tswe sɨgɨnə̀, bəə boŋ mbɨ̀ɨ̀nû yǒ ntsɨ̀m ɨ̀ luu nɨ̀ ŋ̀kàꞌà. Lâ nɨ bə tsuu ɨ sɨgɨnə̌ tswe boŋ m̀bɨ̀ɨ̀nû yǒ ntsɨ̀m ɨ̀ luu nɨ̀ m̀fiì ɨ̀dɨ̀gə̀. ");
INSERT INTO bfd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","M̀bə yìi mə a bə ma mùu ajàŋ aa, nɨ̀ ka ntsyɛsə tâ ŋ̀kàꞌà yìi mə ɨ tswe a nu bù aa, ɨ tsuu bàŋnə bəŋ tɨgə ɨtugə̀. ");
INSERT INTO bfd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mbə ɨbɨɨnû ghuu tsɨ̀m ɨ luu nɨ̂ ŋ̀kàꞌà, ǹtsuu nɨ̂ àdɨ̀gə̀ yî fìì tswe, boŋ ɨ ka kɨ naŋsə ta, tsiꞌì tsǒ lâm yìi mə a ta nɨ a nu bə̀ m̀fa nɨ̀ ŋ̀kàꞌà aà.” ");
INSERT INTO bfd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu a burə kɨ ghàa ŋù baFarɨsai yî mɔ̀ꞌɔ a twoŋə̀ yi mə tâ à zi njɨ a nda yu; Yesu a ghɛɛ̀ ghu nda bo yu jɨ̂. ");
INSERT INTO bfd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ànnù a tsyâ ŋù baFarɨsaì wa ajàŋ yìi mə à lɛ nyə Yesu a jɨ tɨ̀ghə̂ à fòo nsìꞌi mbô mi aà. ");
INSERT INTO bfd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesu a swoŋ ghu mbo mə, bù ba Farɨsai, nɨ sìꞌi ndɔŋ bo bɨ̀ ɨ̀kaŋ tsiꞌì a abɛɛ abɛɛ, la a mum, nɨ̀ bâŋnə̀ ǹluu nɨ̂ ɨ̀nnù jî bɨ, ŋkɨɨ mbaŋnə nɨ̂ ǹjoo bə̂ ŋ̀kwɛrə, ");
INSERT INTO bfd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ɨtɨ̀rə ndə jî tsu! Nɨ̀ sɨ̀ zi mə ŋù yìi mə à lɛ naŋsə abɛɛ laa, a nɨ yu mə à lɛ ŋkɨ nnaŋsə mum aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lâ tâ nɨ̀ baŋnə mfa njoò tsɨ̀m ghu mum a ŋkwɛtə ŋgàŋə̂fum ghu, nɨ̀ bə ghɨ̀rə̀ ma mùu ajàŋ, boŋ a ka bə annu yìi a kuꞌunə aà, tâ ǹjoò tsɨ̀m a mbo bù ɨ̀ laa. ");
INSERT INTO bfd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Lâ ŋ̀gɨꞌɨ yì ŋ̀wè a nu bù m̀bâ baFarɨsai! Ǹloŋ mə nɨ lɔ̀gə̀ nɨ̂ ǹjoo aghɔ̀ꞌɔ̀ bo bɨ̀ bàmbɔ̀rə̂ buu ǹyatə nɨ̀ nɨ̂ ɨ̀tɨɨ nɨ̀ghum, mfa nɨ̂ àtɨ̀ɨ̀ yì fùùrə̀ a mbo Nwì, lâ kaa waꞌà nɨ̂ ànnù yìi mə a tsinə aa ghɨ̀rə, kaa waꞌà nɨ̂ Nwî kɨɨ ŋkɔŋə; boŋ nɨ ghɨ̀rə̀ nɨ̂ ɨ̀nnù ma jû tsiꞌì tsɨ̀m, kaa waꞌà nɨ̀ ji mɔꞌɔ màꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ŋ̀gɨꞌɨ yì ŋ̀wè a nu bù mbâ baFarɨsai! Ǹloŋ mə nɨ kɔ̀ŋə a ntswe nɨ̂ ɨ̀lə̀ŋ jìi mə ɨ kɔꞌɔnə aa a mûm ǹdaŋghòtə bù, ŋ̀kɔŋə nɨ mə tâ bə̀ ka nzi ntsàꞌàtə̀ nɨ̂ ghuu a ɨdɨgə mɨtaa, ");
INSERT INTO bfd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ŋ̀gɨꞌɨ yì ŋ̀wè a nu bù! Ǹloŋ mə nɨ̀ bə aa tsiꞌì tsǒ mɨ̀syɛ̀ mìi mə kaa bɨ sɨ̀ lênsə̀, kaa bə̀ waꞌà yə̂, ǹtsya ghu ɨtu tɨ̀ zî.” ");
INSERT INTO bfd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ŋù yî mɔ̀ꞌɔ a tɨtɨ̀ɨ ŋgǎŋndɨꞌɨ nɔ̀ŋsə̀ jya a kwiꞌi a mbo Yesu mə, “Ǹdɨ̀ꞌɨ̀nnù, ò swoŋ ma mùu ajàŋ ŋkɨɨ mbəgɨtə aa yiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu a swoŋ mə, “Ŋ̀gɨꞌɨ yì ŋ̀wè a nu bù m̀bâ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀! Ǹloŋ mə nɨ bèꞌèsə̀ bə̂ nɨ̂ àbèꞌè yìi mə a tsya waa a mbèꞌê. Kaa bù bûmbɔŋ kaa nɨ̀ waꞌà zî àjàŋ yìi mə mbə nɨ̀ tɛꞌɛ̀ ŋ̀koontə abèꞌè ma yû kə̌ ŋkwɛtə waa tâ bo beꞌe. ");
INSERT INTO bfd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ǹdɔ̀ɔ̀ a atu bù! Ǹloŋ mə nɨ bɔɔ mɨsyɛ̀ mɨ ŋgǎŋntoo Nwì jìi mə bɨ̀taà buu lɛ nzwitə aà. ");
INSERT INTO bfd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Maa ajàŋ nɨ̀ nɨ bɨ̀yəfə ŋkɨɨ mbeentə nɨ ɨnnù jìi mə bɨ̀taà buu lɛ mbùꞌù aà; ǹloŋ mə bo lɛ nzwitə waa, nɨ̀ bâŋnə̀ m̀bɨɨnə mbɔɔ mɨsyɛ̀ myaa. ");
INSERT INTO bfd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","M̀bə yìi mə a bə ma la aa, mɨ̀tsyɛ̀ mɨ Nwî mɨ swoŋ mə, ‘Mə̀ ka too ŋgǎŋtoo jya, bo bɨ̀ ŋ̀gǎŋnswoŋə annù Nwî tâ bo zwitə bî mɔꞌɔ ŋkɨ ŋka ntsɔꞌɔ akòrə̀ bî mɔꞌɔ,’ ");
INSERT INTO bfd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ta tâ àləə ŋgǎŋntoo Nwî tsɨ̀m, yìi mə bɨ lɛ nsaansə nlɔgɨnə a nlɔ̀gɨ̀nə mbi aa, ta bɨ̀ betə a mbo nɨ̀wàà nɨ bə̂ buà, ");
INSERT INTO bfd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ǹlɔgɨnə nɨ̂ àləə Abel ŋghɛɛ nyweꞌe nɨ̂ à yì Zechariah yìi mə bɨ lɛ nzwitə a tɨtɨ̀ɨ nɨ̀kèntə̀ nɨ màꞌanwì bo bɨ̀ Àdɨgə ya yìi mə a laa màŋsə aà. Ɨ̀ɨ̀ŋə, mə̀ swoŋə a mbo bù mə bɨ ka yǐ betə aləə̀ yaa a mbo nɨ̀wàà nɨ bə̂ buà. ");
INSERT INTO bfd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ŋ̀gɨꞌɨ yì ŋ̀wè a nu bù mbâ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀, ǹloŋ mə nɨ̀ kwɛ̀rə̀ mə̂ bɨ̂key bɨ mɨtsyɛ̀ bìi mə bɨ ŋaꞌa mânjì; nɨ̀ tuu ŋkuu, ŋkɨ ŋkɨŋ bə̂ bî mɔꞌɔ mə tâ bɨ̀ tsuu kɨɨ kuu.” ");
INSERT INTO bfd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Àjàŋ yìi mə Yesu à lɛ mmàꞌàtə̀ waa ŋka ŋghɛɛ nii aà, ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai lɔgɨ̀nnə̀ ŋka lɨgɨtə nɨ̂ ɨ̀nnù jya mə Yesu à lɛ nswoŋə aa tsiꞌì nɨ̀ mɨ̀tɨ̀ɨ̀ ŋ̀kɨɨ mbetə nìi nɨ̂ ɨ̀nnù jî ghàꞌàtə̀, ");
INSERT INTO bfd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mə mbə a swoŋə̀ ànnù yî bɨ yì tsu tâ bo tswa yi. ");
INSERT INTO bfd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Àjàŋ mə nnɔ̀ɔ̀ bə̂ wa ŋkam nɨ̀ ŋ̀kam ɨ lɛ nzì ŋ̀ghotə, ntɨgə ntinə waa ntinə ŋghɛɛ aa, Yesu a lɔ̀gɨ̀nə̀ m̀foo nswoŋ a mbo ŋgǎŋyəgə̂nnù ji mə, “Nɨ̀ ka ntsyɛsə ghuu nɨ̂ m̀bɛ̀ꞌɛ̀ àbaa baFarɨsai, yìi mə à nɨ abagɨlə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kaa àyoò yì tsu a sɨ̀ ghu tswê mə bɨ bɔɔntə mə kaa bɨ ka yǐ waꞌà fùrə̀, kə̀ mə a ləəntə yìi mə kaa a ka yǐ waꞌà fɛ̀ꞌɛ̀ yɛntə tâ bɨ̀ zi. ");
INSERT INTO bfd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ɨ̀nnù tsɨ̀m jìi mə nɨ̀ swòŋə a mûm ɨ̀tugə aa, bɨ yuꞌu a nlaà ɨ̀dɨ̀gə̀. Ɨ̀nnù jìi mə nɨ̀ kɨ ntsùmtə̀ a adɨgə yî lɔ̀ꞌɔ̀sə̀ aa, ba yǐ tɨgə təə a ɨtu mɨlaꞌa ɨ kɛ̀ꞌɛ̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mə̀ swòŋə a mbo bù, ɨ̀kaꞌâ jâ, mə, nɨ̀ tsuu kɨ bɔꞌɔ bə̂ bìi mə mbə bɨ zwitə̀ tsiꞌì m̀bɨ̀ɨ̀nu, kaa waꞌà annǔ dàŋ bû ŋ̀ghɨrə aa bə̂. ");
INSERT INTO bfd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","La mə̀ ka bàŋnə ŋwàꞌàsə̀ ghuu nloŋ ŋû yìi mbə nɨ̀ bâŋnə̀ ŋ̀ka mbɔꞌɔ aà: Nɨ̀ ka mbɔꞌɔ yu wa yìi mə a zwitə, ŋkɨ ntswe nɨ mɨ̀dàꞌà a mmàꞌa a mum mɔꞌɔ Satan; ɨ̀ɨ̀ŋə, mə̀ swòŋə a mbo bù mə nàa mbɔꞌɔ nìi. ");
INSERT INTO bfd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tɨgə bɨ fèe ndaꞌa ji ntaà aa nɨ bɨ̀kabə̀ bi baa aa ɛ? Kaa Nwì a waꞌà nɨ̂ ǹdaꞌa ma yû tsiꞌì yî fùùrə̀ liꞌìnə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yə mbà, à zi ndùu ɨnǒŋtu jìi ɨ tswe a atu bù aa tsiꞌì tsɨ̀m; tsuu kɨ bɔꞌɔ, nɨ̀ tswe nɨ̀ ǹdùù, ǹtsyatə ndaꞌa a nnɔ̀ɔ̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mə̀ ghɛɛ̀ nɨ̀ m̀bìì a nswoŋ a mbo bù mə, ŋu yìi mə à bii gha a nsi miꞌi bə̀ aa, Mu Ŋù à ka yǐ kɨɨ bii yi a nsi miꞌi baangel bɨ Nwî; ");
INSERT INTO bfd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","la ŋù yìi à tuu gha a nsi miꞌi bə̀ aa, bɨ ka yǐ kɨɨ tuu yi a nsi miꞌi baangel. ");
INSERT INTO bfd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ŋù ntsɨ̀m yìi mə à ghàa ànnù yî bɨ nloŋ Mu Ŋù aa bɨ ka yǐ lìꞌìnə ɨfansənnù ji; lâ ŋù yìi mə à bə̀gɨ̀tə Azwì Nwî aa, kaa bɨ ka yǐ waꞌà ɨfansənnù ji liꞌìnə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nòò yìi mə bɨ lɔ̀gə̀ nɨ̂ ghuu nzi nɨ bù a ndâŋghotə bo bɨ a nsi bɨ̀saꞌa bɨ alaꞌa bo bɨ̀ bɨ̀tà bɨ alaꞌa aa, nɨ̀ tsuu kɨ waꞌa annù yìi mə nɨ̀ ka swoŋ kə̀ ajàŋ yìi mə nɨ̀ ka kwiꞌi aà; ");
INSERT INTO bfd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ǹloŋ mə Azwì Nwî a ka dɨ̀ꞌɨ annù yìi mə nɨ̀ ka swoŋə aa maa noò.” ");
INSERT INTO bfd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ŋù yì mɔ̀ꞌɔ wa atɨtɨ̀ɨ nnɔ̀ɔ̀ a swoŋ a mbo Yesu mə, “Ǹdɨ̀ꞌɨ̀nnù swoŋ a mbo mumaà tâ à yatə njoo jìi mə Taà à lɛ mmàꞌàtə̀ aa a tɨtɨ̀ɨ bìꞌiyu.” ");
INSERT INTO bfd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu a kwiꞌi ghu mbo mə, “M̀bâ ghû, a gha nɨ̂ ǹsaꞌa mɨ̀saꞌa kə̀ ǹyàtə̂ ǹjoo a tɨtɨ̀ɨ bù aa a tsɔ̀ꞌɔ wò lɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesu a ghɛ̀ɛ̀ nɨ̀ m̀bìì ǹswoŋə a mbo bo mə, “Nɨ̀ ka ntsyɛsə ŋkɨɨ ntsuꞌutə nɨ̂ ghuu nloŋ aghə̀ꞌə̀nə tsɨ̀m yìi mə a ghɨ̀rə̀ bə̀ yəꞌə̀tə̀ nɨ̂ ǹjoo aà; ǹloŋ mə ntswêntɨ̀ɨ ŋù kaa à laa ŋwaꞌa aa njoo jì wè jìi mə à tswe nɨ ju aa bə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ nɨghàà nî nǎnaa a mbo bo mə, “Àbwènə nsyɛ ŋgàŋkabə yì mɔ̀ꞌɔ a lɛ fiꞌisə mɨjɨ tsiꞌǐ a mbə nù; ");
INSERT INTO bfd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","a naŋsə̀ ǹtswe ŋwaꞌatə annù yìi mə mbə yu ghɨrə̀ aa, m̀betə mə ‘Mə̀ ka naŋsə ghɨ̀rə̀ aa mə akə ɨ tswe nɨ̂ ɨ̀tà jìi mə ɨ ghaꞌatə mə mbə mə̀ fuꞌù mɨ̀jɨ ma mù ǹləə ghu aa ɛ.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A swoŋə a atu ɨbɨɨnû yi mə, “Ànnù yìi mə mə̀ ka ghɨ̀rə aa a nɨ mə: Mə̀ ka sàꞌa ɨtà jya tsiꞌì tsɨ̀m bu ghùrə̀ jî wè, jìi mə mbə lɔgə̀ mɨ̀jɨ aa mya bo bɨ̀ ǹjoò jyâ tsɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mə̀ ghɨrə ma la, boŋ mə̀ ka tɨgə swoŋ a mbô ǹtɨɨ̀ gha mə, ǹtɨɨ̀ ghâ, wa ò lə̀ə njoo a atà ɨ ghaꞌa ŋghaꞌa ajàŋ mə mbə ò jɨ a atu ɨlòò ɨ̀lòò; lɔ̀ɔ lâ àdɨ̀gə̀ ǹtswe ghu, ntɨgə njɨ ŋkɨɨ no, ŋkɨɨ ndorɨtə.” ");
INSERT INTO bfd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lâ Nwì a swoŋ ghu mbo mə, “Àtɨ̀rə̀ ndə yî tsu! Mə̀ ka twoŋ ntɨɨ̀ gho nɨ̀tugə sii, tâ ǹjoo jya mə ò fùꞌu ŋghotə aa tâ ɨ̀ tɨgə mbə ji wo aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","À nɨ̂ ŋgɨŋ ŋgɨ̀ŋ a mbo ŋù yìi mə a ghotə nɨ̂ ǹjoo, ǹlə̀ə̀ nɨ̂ a ata ǹloŋ ɨ̀bɨɨnû yi, kaa waꞌà nɨ̂ ǹjoo a mbɛ̀ɛ Nwì bâŋnə̀ ǹtswe.” ");
INSERT INTO bfd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A bû ǹswoŋ a mbo ŋ̀gǎŋyəgə̂nnù ji mə, “Ma mùu ajàŋ mə̀ tɨgə̀ ǹswǒŋ a mbo bù mə nɨ̀ tsuu ɨnnù kɨ waꞌa nloŋ ntswêntɨ̀i yùù, mə nɨ̀ ka jɨ aa akə̀, kə̀ ǹloŋ ɨbɨ̀ɨ̀nû ghuu, mə nɨ̀ ka wɛꞌɛ aa akə̀ lɛ. ");
INSERT INTO bfd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ǹloŋ mə ǹtswêntɨ̀ɨ̀ ɨ̀ tsyàtə mɨ̀jɨ, ɨ̀bɨɨ nu ɨ kɨ̂ ǹtsyatə ɨtsə̀ꞌə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nɨ̀ waꞌatə ŋɨ̀ŋyâ, kaa ɨ sɨ njoo bweꞌe, kaa waꞌà nɨ̀ mɨjɨ kɨɨ mfuꞌu, kaa waꞌà nɨ mɨ̀ntàŋ kə̀ nɨ̂ ɨ̀tà tswê, lâ Nwìŋgɔ̀ŋ a jɛꞌɛ̀ nɨ̂ waa. Nɨ̀ sɨ̀ nɨ̂ ǹdùù tswê ǹtsyatə bɨ̂sɨŋ ma bû aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","M̀bə ŋù nɨ̀bù yî tsù a kuꞌùsə̀ mûbàŋtə̀ a nɨ̂ ǹtswêntɨ̀ɨ̀ yì ǹloŋ mə a waꞌa ɨnnù aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma mùu ajàŋ, mbə nɨ̀ tsuu zi ajàŋ yìi mə mbə nɨ̀ naŋsə̀ ŋ̀kuꞌusə tsiꞌì mûntsìrə̂ àyoo tsiꞌì tsǒ ma yû, nɨ̀ bû ǹtɨgə waꞌa nloŋ njoo ji mɔꞌɔ aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nɨ̀ lentə ɨbwìꞌi ŋgɛ̀ɛ̀, ǹyə a ajàŋ mə ɨ kwe aà; kaa ɨ sɨ nwùgɨ̀nə̀ kaa waꞌà nɨ̂ àsìsì kɨɨ mbaꞌa; la mə̀ swoŋ a mbo bù mə, tsiꞌì m̀fɔ̀ Solomon a mûm nɨghaꞌà ni nɨ tsɨ̀m, kaa à lɛ ŋkɨꞌɨ atsə̀ꞌə̀ yî tsu wɛꞌɛ tâ à bɔŋ mbə tsiꞌì tsô jyaa. ");
INSERT INTO bfd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lâ m̀bə Nwì a ka ŋwɛꞌɛ ɨ̀tsə̀ꞌə̀ a nû ŋ̀gɛ̀ɛ̀ yìi mə ɨ kwe nɨ a atu mɨ̂ntaꞌa sìi a lo tɨ bə a yɔɔ bɨ tɔɔ̀ a abu aa, nɨ̀ sɨ̀ mɔɔ̀ntə̀ mə mbə a wɛꞌɛ̀ ɨ̀tsə̀ꞌə̀ a nu bù ǹtsyatə aa ɛ? Àbìintɨɨ̀ yuu a kəꞌə bə laa aa a ya ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Maa ajàŋ, nɨ̀ tsuu kɨ betə mə, nɨ̀ ka jɨ aa àkə̀, kə̀ nɨ̀ ka no aà àkə̀ lɛ, tâ mɨ̀ntɨɨ̀ muu tsuu ɨnnǔ ɨ kɨ waꞌa. ");
INSERT INTO bfd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ǹloŋ mə à nɨ̂ ɨ̀nnù jìi mə bɨ̀tɨ̀zî Nwî bɨ siꞌisə nɨ mɨ̀bɨ̀ɨ̀mɨnû myaa nlɔɔ aà; la Taà ghùù à zi mə nɨ boŋ njoo mà jû. ");
INSERT INTO bfd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lâ tâ nɨ̀ baŋnə ŋka nlɔɔ annù nɨfɔ̀ Nwî boŋ à ka fa njoo mà jû a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nɨ̀ tsuu kɨ bɔꞌɔ mbâ bɔɔ bɨ mbînjə̀rə̀ bâ, ǹloŋ mə, Taà ghùù a dorɨtə a mfâ ànnù nɨfɔ̌ aburə a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Fèe nɨ̀ ǹjoò juu mfa a mbô ŋ̀gǎŋə̂fumə tǎ tswe nɨ̂ ɨ̀bàà ŋkabə jìi mə kaa ɨ sɨ sàꞌàkə̀ aà, ɨ lə̀ə afùꞌù yùù a atà a aburə, a adɨgə yìi kaa ŋkabə ɨ̀ sɨ ghu mɛ, kaa bɨ̀yərə waꞌà ghu kuù. Kaa nsə̀bə̀ waꞌà nɨ̂ ŋ̀kabə ghu kɨɨ njɨ aà. ");
INSERT INTO bfd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ǹloŋ mə adɨ̀gə̀ yìi mə afùꞌû yo a tswe ghu aa, ǹtɨɨ̀ gho ɨ ka kɨɨ tswe aa ghu. ");
INSERT INTO bfd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nɨ̀ ka kwerə mɨkò muu ŋkɨɨ ŋkosə nɨ bɨ̀lâm buu bɨ̀ ka ŋkhɨ, ");
INSERT INTO bfd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mbə tsiꞌì tsǒ ŋ̀gàŋəfàꞌà jìi mə a yuꞌutə masa wàà yìi mə à tswe a adɨgə adìnà nɨyɔꞌɔ̀ aa, mə mbə a ghɨrə mbɨ̀ɨ̀ ŋkwɛntə abàꞌà bo wâŋsə̀ ŋ̀ŋàꞌa a kuù. ");
INSERT INTO bfd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","M̀bɔɔnə a mbo ŋgǎŋəfàꞌà jìi mə masà wàà a bɨ̀ɨ̀ ǹyə waa bɨ tswê nɨkərə̀ aà; mə̀ swoŋ tsiꞌì ànnù nɨ̂koŋ a mbo bù mə, tâfàꞌâ wàà wa à ka bàŋnə wɛꞌɛ atsə̀ꞌə afàꞌâ yi, ɨ ghɨ̀rə tâ bo tswe a atu atɛtə̀ tâ à tsyasə mɨjɨ a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","À ka bə annù nɨdorə a mbo ŋgǎŋfàꞌà jìi mə mbə a ka mbɨɨ nɨ̂ ǹtɨ̀ɨ̂ ɨ̀tugə̀ kə̀ nɨ̂ ǹtsyàtə̂ ǹtɨ̀ɨ̂ ɨ̀tugə bo tswê nɨkərə̀ aà! ");
INSERT INTO bfd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lâ tâ nɨ̀ zi mə, m̀bɔ̂ŋ ǹdâ à laa bə zi noò yìi mə ǹyərə̂ à ka zì ghu aa boŋ kaa à sɨ̀ màꞌàtə̀ mə bɨ̀ zi mbəgə ndâ yì. ");
INSERT INTO bfd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nɨ̀ kɨ ŋka ntswe nɨkərə̀; ǹloŋ mə Mu Ŋù à ka yǐ zì aa a noò yìi mə nɨ̀ sɨ waꞌatə mə à ka zì ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peta a betə̀ Yesu mə, “Mmàꞌàmbî, o swoŋ nɨghàà nî nǎnaa nû aa a mbo bìꞌì kə̀ a mbo bə̀ bɨ̀tsɨ̀mə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu akwiꞌi ghu mbo mə, “Yuꞌu nɨ annù ǹloŋə ŋgàŋàfàꞌà yìi a fàꞌà nɨ̂ ǹtɨɨ̀ yi tsɨ̀m ŋkɨ mbə yì mɨ̀tsyɛ̀ yìi mə mbə masà yì a lə̀ə̀ mə tâ a ka nlentə njoò ji, ŋkɨɨ nyatə nɨ mɨ̀jɨ a noò mɨ̀jɨ aà. ");
INSERT INTO bfd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","M̀bɔɔnə a mbo ŋgàŋàfàꞌà ma ghû yìi mə mbə masà yì a bɨɨ nyə a faꞌà maa ajàŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mə̀ swoŋ tsiꞌì ànnù nɨ̂koŋ a bo bù mə à ka tɨgə nlə̀ə ŋgàŋàfàꞌà ma wa mə tâ à tɨgə nlentə nɨ̂ ǹjoò ji tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lâ m̀bə ŋ̀gàŋàfàꞌà wa a baŋnə nswoŋ a mbo ɨ̀bɨ̀ɨnû yi mə, ‘Masà ghaà ka tɨ̀gə a mbɨ̀ɨ̀,’ m̀baŋnə ŋka ŋghɔɔ nɨ̂ ŋgǎŋəfàꞌà jya jî m̀bâŋnə̀ bo bɨ̀ jì bâŋgyɛ̀, ŋkɨɨ njɨ, nno, ntɨgə mbaanə nìi, ");
INSERT INTO bfd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","boŋ masa ŋgǎŋəfàꞌà jya à ka zì a nɨ̂ ǹjwi bo bɨ̀ nòò yìi mə kaa à sɨ̀ waꞌatə mə à ka bɨ̀ɨ̀ ghu aà. Bɛɛ a bɨɨ aa boŋ à ka tsə ŋgɨꞌɨ ghu nu, kɨɨ nɨŋə yi a tɨtɨ̀ɨ̂ ŋ̀gǎŋəfàꞌà jìi mə kaa bɨ sɨ nɨ mɨ̀ntɨɨ̀ myaa mɨtsɨ̀m faꞌa. ");
INSERT INTO bfd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ŋ̀gàŋàfàꞌà yìi mə à zi annù yìi mə masà yì a lɔ̀ɔ̀ aa, la kaa waꞌà nû yì taŋtə̀ kə̀ ŋkɨɨ mfaꞌa annù yìi mə a lɔ̀ɔ̀ aa, bɨ ka yǐ naŋsə ghɔ̀ɔ̀ yi. ");
INSERT INTO bfd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Lâ ŋ̀gàŋàfàꞌà yìi mə kaa à sɨ̌ annù yìi mə masà yì a lɔ̀ɔ̀ zi aa, m̀faꞌa annù yìi mə boŋ bɨ ghɔɔ yi ghu aa, bɨ ka yǐ ghɔ̀ɔ̀ yi tâ à kəꞌətə. Ŋù yìi mə bɨ fâ àyoo ghu mbo a ghaꞌatə aa, bɨ ka yǐ kɨɨ lɔ̀ɔ̀ a ŋkwɛrə̂ àyoo ghu mbo tâ à ghaꞌatə̀; ŋù yìi mə bə̌ fa njoo jì ghàꞌàtə̀ ghu mbo aa, bɨ bɛ mə à ka bìnsə̀ jìi mə ji ghaꞌatə ntsyà. ");
INSERT INTO bfd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Mə̀ lɛ nzì aa a ŋghɨ̀rə mə tâ m̀bi ŋka ŋkhɨ; ǹyəꞌətə̀ nɨ mə boŋ ɨ lɛɛ̀ m̀bàa ntɛꞌɛ nlɔgɨnə ŋka ŋkhɨ! ");
INSERT INTO bfd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mə̀ tswe nɨ̀ ŋkì yìi mə mə̀ tswe nɨ̂ ŋkwɛ̀rə̀ aà; kaa mbə ntɨɨ̀ gha ɨ waꞌà nɨ̂ m̀bɔɔnə tswê ǹyweꞌe a noò yìi mə mə̀ ka yǐ màŋsə̀ aà! ");
INSERT INTO bfd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nɨ laà mɔɔntə nɨ mə mə̀ sɨgə fàa a atu nsyɛ aa a mfa m̀bɔɔnə aa ɛ? Ŋ̀gaŋ, mə̀ swòŋə a mbo bù mə mə̀ bàŋnə nzì aa nɨ̂ àyàtə̀; ");
INSERT INTO bfd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ǹloŋ mə, ǹlɔgɨnə tsɨ̂tsɔ̀ŋ, a nda yìi bə̀ tswe ghu bi ntaà aa, bɨ ka yàtə tâ bì bi baa ka tonə nɨ̂ bì bi tarə̀; ");
INSERT INTO bfd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","bɨ ka yàtə̀ waa, tâ tà bo mû yì yî m̀bâŋnə̀ ka ntonə, tâ ma bo mû yì yî màŋgyɛ̀ ka ntonə, tâ manə̀ bo ŋ̀gwɛ mû yì kɨ ŋka ntonə.” ");
INSERT INTO bfd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu a ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋə a mbo ǹnɔ̀ɔ̀ bə̂ wa mə, “Nɨ̀ bə yə tâ m̀bàꞌà ɨ̀ ka ŋkɔꞌɔ a mbɨ̂ ǹtso nòò boŋ nɨ̀ burə nswoŋ mə, ‘mbə̀ŋ ɨ̀ ka loo’; nɨ̀ swòŋə a kɨ̂ m̀fɛꞌɛ maa ajàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nɨ̀ bə yə tâ àfìsə̀ à ka nzi a mbɨ ntii, boŋ nɨ swoŋə mə, ‘àbabə yì tɨ̀ɨ̀ a ka zì’; a kɨ̂ m̀fɛꞌɛ maa ajàŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ŋ̀gǎŋabagɨlə̀! Nɨ̀ zi aa tsiꞌì ǹtɔꞌɔtə ɨ̀lènsə̀ jìi mə nɨ yə ɨ fɛꞌɛ̀ nɨ a nsyɛ bo bɨ̀ a mbàꞌà àbùrə̀, a ghɨ̀rə akə̀ mə tâ nɨ̀ tsuu a ntɔꞌɔtə ɨnnù jìi mə ɨ fɛ̀ꞌɛ̀ fàa nɨ yulà ŋ̀gùꞌù aa zi aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nɨ̀ tuù ǹlɔ̀ɔ̂ ànnù jî tsinə a ŋghɨ̀rə aa a ya? ");
INSERT INTO bfd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bu ŋù yìi mə à nɨ̀ŋə ɨsaꞌa a nu wo aa, mbə bù yu ka ŋghɛɛ a nsi ŋ̀gàŋnsaꞌa mɨ̀saꞌa, ò yweꞌetə̀ mə mbə bǔ yu maŋsə a mânjì. Tâ à waꞌà gho a mbo ŋ̀gàŋnsaꞌa mɨ̀saꞌa wa fa, tâ ŋ̀gàŋnsaꞌa mɨ̀saꞌa wa tâ à fa gho a mbo ŋù bɨ̀burə̀sì tâ ŋù bɨ̀bùrə̂sì wa à nɨŋə gho a atsaŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mə̀ swǒŋ tsiꞌì ànnù nɨ̂koŋ a mbo wò mə ò bə kuu wa atsaŋ boŋ ò ka tɨgə tswe ghu ɨ yweꞌe a noò yìi ò ka yǐ màŋsə tu ŋkabə yìi mə o tswa nìi ghu aa tsiꞌì ǹtsɨ̀m, ɨ sɨgə yweꞌe nɨ̂ ànini yìi a lwiꞌi aà.” ");
INSERT INTO bfd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","À lɛ mbə maà noò aa, bə̀ bî mɔꞌɔ lɛ nswoŋ a mbo Yesu àjàŋ yìi mə Pilato à lɛ nswoŋ bɨ zwitə baGalilea bî mɔꞌɔ a noò yìi mə bɨ lɛ nzì ŋ̀ka nzwitə njoo mmàꞌanwì aà. ");
INSERT INTO bfd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu a kwiꞌi a mbo bo mə, “Nɨ̀ mɔ̀ɔ̀ntə mə ma buù baGalilea lɛ ŋkwo aa nloŋ mə bo lɛ mbə ŋgǎŋghɨ̀rə̂ ɨ̀nnù jî bɨ ntsyàtə baGalilea bî mɔꞌɔ bɨ̀tsɨ̀m aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mə̀ swòŋə a mbo bù mə, Ŋ̀gaŋ; mə̀ swoŋ a mbo bù mə nɨ̀ bə tuu mɨ̂ntɨɨ̀ muu bəŋkə mmàꞌàtə ɨbɨ̂ ghuu boŋ bù bɨ tsɨ̀m nɨ̀ ka yǐ kɨɨ kwo tsǒ bo. ");
INSERT INTO bfd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kə̀ nɨ̀ wàꞌàtə mə akə nloŋ baSiloam bya nɨ̀ghum ntsò ji nɨfwaa, bìi mə àtu nda nɨ̀kàŋ ya a lɛ ŋwò ǹzwitə aa, nɨ̀ mɔ̀ɔ̀ntə mə bo lɛ mbə ŋgǎŋghɨ̀rə̂ ɨ̀nnù jì bɨ ntsyàtə bə̀ bɨ̀tsɨ̀m bìi bɨ lɛ ntswe a Yerusalem aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mə̀ swòŋə a mbo bù mə, “Ŋ̀gaŋ.” Nɨ̀ bə tuu mɨ̂ntɨɨ̀ muu bəŋkə boŋ nɨ̀ ka yǐ kɨɨ kwo maa ajàŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A bû ǹswoŋ nɨghàà nî nǎnaa a mbo bo mə: “Ŋù yî mɔ̀ꞌɔ à lɛ mbě ati ajɔ̀ɔ̀ a mûm ŋ̀kya yu; à lɛɛ̀ ǹzi a lèntə, nyə mə kaa a lɛ waꞌà koonə̀. ");
INSERT INTO bfd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A swoŋ a mbo ŋù lèntə̂ ŋ̀kya wa mə, ‘Yə̂, àa ɨ̀lòò ji tarə mə mə̀ zì mə̂ ǹlentə ati yû, kaa waꞌǎ ajɔ̀ɔ̀ ghu atu yə̂. Wǎ mmàꞌa a nsyɛ̂; a tàsə adɨgə nsyɛ yù aa a ya aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ŋ̀gàŋnlèntə̂ ŋ̀kya wa a kwiꞌi mə, ‘Taà, màꞌàtə tâ yuà àlòò a kuꞌusə ntsyà, mə̀ ka toŋ mfə̀ŋ ɨ karɨsə ɨ nɨŋ ntsàꞌà ghu. ");
INSERT INTO bfd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bɛɛ mə a bə fìi alòò, sɨ̀ yə mə a ka koonə mɨ̂ntà lɛ, bɛɛ a tuu koonə, boŋ ò ka tɨgə wǎ mmàꞌà a nsyɛ̂.’” ");
INSERT INTO bfd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","À lɛ mbə a njwîŋgɔ̀ŋ yî mɔ̀ꞌɔ Yesu a tswê a mûm ǹdâŋghòtə ŋka ndɨꞌɨ nɨ̂ ànnù Nwî ghu. ");
INSERT INTO bfd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Màŋgyɛ̀ yî mɔ̀ꞌɔ à lɛ ntswe ghu yìi mə àzwì yî bɨ a lɛ ntswe ghu nu, ŋ̀ghɨ̀rə̀ a ghɔɔ̀ a atû ɨ̀lòò nɨghûm ǹtsò ji nɨfwaà; ǹtɨgə ŋgɨmnə ntəə, kaa waꞌǎ a sentə ɨ̀bɨ̀ɨ nû yi zî. ");
INSERT INTO bfd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nòò yìi Yesu à lɛ nyə yi aa, nswoŋ mə, “Màŋgyɛ̀, wa nɨ̀ ghɔ̀ɔ̀ no nya nɨ màꞌàtə̀ mə̂ ghô.” ");
INSERT INTO bfd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","À lɛ ŋghɛ̀nsə abô yi nnɔŋsə ghu nu, a burə̀ ǹtɨgə nsentə nû yì, ntsinə ntəə, ǹtɨgə ŋghaꞌasə nɨ̂ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ǹdɨ̀ɨ̂ ǹdâŋghòtə̀ à lɛ nlwìsə ntɔŋ nloŋ mə Yesu à lɛ ŋghùrə mâŋgyɛ̀ wa a njwîŋgɔ̀ŋ aà, ǹtɨgə nswoŋə a mbo bə̀ bìi bɨ lɛ ntswe ghu aa mə, “Ǹjwi ɨfàꞌà ɨ tswe ghu aa ji ntoꞌo; nɨ̀ ka nzi nɨ̂ ǹjwi mà jû tâ bɨ̀ ghurə ghuu, ntsee bə a njwîŋgɔ̀ŋ kɨ zì.” ");
INSERT INTO bfd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","M̀màꞌàmbi à lɛ ŋkwiꞌi ghu mbo mə, “Wò ŋ̀gàŋàbagɨlə̀! Ŋù nɨ̀bù yî tsù à sɨ mbɔ̀ŋ yì kə̀ jàkâsì yì fɛɛ mfiꞌisə a abùꞌù a njwîŋgɔ̀ŋ, ŋ̀ghɛɛ nɨ yu a ntsǔ ŋkì mə tâ ɨ̀ no ŋkì aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lâ, yə̂ nɨ̀, a nɨ mu Abraham yî mɔ̀ꞌɔ à ghuà yìi mə Satan à lɛ ŋkòò nɨ̂ àtsaŋ, ɨlòò nɨghûm ǹtsò nɨ̀fwaa, a sɨ̀ kuꞌùnə̀ mə mbə bɨ kɛtə atsaŋə̀ yi ya a njwîŋgɔ̀ŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","À kwìꞌì mə̂ ma mùu ajàŋ aa, atu ŋgàŋkɨ̂bàâ ji jya a lɛ ndɨ̀rə̀; bə̀ bya bɨ̀tsɨ̀m bɨ tɨgə̀ ǹdorɨtə nloŋ ɨnnù jî yɛ̌yɛrə jya mə à lɛ ŋghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu a tɨgə̀ ǹswoŋ mə, “Ànnù nɨfɔ̌ aburə a bə aa tsǒ àkə̀ aa ɛ? Kə̀ m̀bə mə̀ fɨgɨ̀nə̀ aa nɨ̂ àkə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A bə aa tsiꞌì tsǒ àbùrə mâghum, yìi mə ŋù à lɛ nlɔ̀gə̀ ŋ̀ghɛɛ mbweꞌe a mûm ŋ̀kya yu; a too ŋkɔꞌɔ ntɨgə mbə ati, bɨ̀sɨŋ bɨ tɨgə̀ ǹzi ŋghùrə̀ nɨ̂ ǹdâ jyaa nɨ̂ ǹtaà ji.” ");
INSERT INTO bfd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu a kuꞌùsə̀ ǹswoŋ mə, “M̀bə̂ mə̀ fɨgɨ̀nə̀ ànnù nɨfɔ̀ Nwî aa nɨ̂ àkə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A bə aa tsiꞌì tsǒ m̀bɛ̀ꞌɛ̀ àbaa yìi mə màŋgyɛ̀ à lɛ nlɔ̀gə̀ ǹnɨŋə a mum àbaa yì ghàꞌàtə̀ a ghɨrə̀ àbaa ya a tɨ̀gə̀ ŋ̀kɔꞌɔ ŋghaꞌa ŋghaꞌa aà.” ");
INSERT INTO bfd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu à lɛ mbù ŋ̀ghɛɛ ntsyà a mûm ɨ̀laꞌa jì wè bo bɨ̀ jì kə̀kə̂, ǹdɨꞌɨ nɨ nɨ̀ghàà nɨ Nwî ghu, a ajàŋ mə à lɛ sɨ kɔꞌɔ ŋghɛɛ nɨ a Yerusalem aà. ");
INSERT INTO bfd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ŋù yì mɔꞌɔ a betə̀ ghu mbo mə, “Taà, â ka yǐ yweenə tsiꞌì m̀bùmtə̀ bə̂ aa ɛ?” Yesu a kwiꞌi mə, ");
INSERT INTO bfd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nɨ̀ ka ŋgaansə mɨtɨ̀ɨ̂ muu a ŋkuu nɨ̂ ǹtsǔ nda yì kə̀ꞌə̀tə̀ wâ; ǹloŋ mə bə̀ bì ghàꞌàtə̀ ka yǐ kɨ yweꞌetə a ŋkuu ghu, kaa waꞌà bàŋnə̀ ǹzi a ŋkuù. ");
INSERT INTO bfd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nòò yìi mə mbɔ̂ŋ ǹda à bɨ̀ɨ̀nə̀ mə̂ ǹtsetə abàꞌà aa, bəə boŋ nɨ̀ ka tɨgə təə a abɛɛ tɨgə kwɛ̀ntə̀ nɨ̂ àbàꞌà ya ɨ swoŋə nɨ mə, ‘Taà, ŋaꞌà bìꞌì kuu!’ Tâ à kwiꞌi a mbo bù mə, ‘Kaa mə̀ sɨ̀ adɨgə yìi nɨ̀ lo ghu aa zî.’ ");
INSERT INTO bfd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tâ nɨ̀ lɔgɨnə ŋka nswoŋə nɨ mə, ‘bìꞌì lɛ sɨ jɨ ŋkɨɨ nno biꞌinə̀, ò kɨɨ̀ ǹdɨꞌɨ nɨ̂ ànnù Nwî a mûm àlaꞌa bìꞌì.’ ");
INSERT INTO bfd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lâ tâ à swoŋə a mbo bù mə, ‘Kaa mə̀ sɨ̀ adɨgə yìi nɨ̀ lo ghu aa zî. Nɨ̀ lo ghuu a mbɛ̀ɛ mə̀ ŋ̀ghɛɛ mba ŋgǎŋmbuꞌu ɨ̀nnù jì bɨ̀!’ ");
INSERT INTO bfd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nɨ̀ ka yǐ tɨgə yə̀ꞌə ɨ kurə nɨ̂ mɨ̀sɔ̀ŋə̂ muu, a noò yìi mə nɨ̀ ka yǐ yə Abraham bo Isaac nɨ Yakob, nɨ̂ ŋ̀gǎŋntoo Nwî tsɨ̀m tâ tswe a mum nɨ̀fɔ̀ nɨ Nwî. Tâ bɨ̀ baŋnə ntii ghuu mfɛꞌɛsə a abɛɛ! ");
INSERT INTO bfd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bə̀ ka yǐ lo a mbɨ nsaꞌa noò bo bɨ a mbɨ ntso nòò, a mbɛ̀ɛ̀ m̀bɨtu bo bɨ̀ mbɨntii, ɨ zǐ tswe a atu atɛtə̀, ɨ tɨgə jɨ nɨ̂ àdinà a mûm ànnù nɨfɔ̀ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yə̂, bə̀ bî mɔꞌɔ bìi à nɨ bɨlwìꞌì bɨ njɨ̀m tsɨ̂tsɔ̀ŋ aa ka yǐ tɨgə bə bɨ̂tsyà bɨ mbìì, tâ bə̀ bî mɔꞌɔ bìi mə à nɨ bɨtsyà bɨ mbìì tsɨ̂tsɔ̀ŋ aa tâ bɨ̀ tɨgə bɨ̂lwìꞌì bɨnjɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tsiꞌì maa noò baFarɨsai bî mɔꞌɔ bɨ lɛ nzì a mbɛ̀ɛ Yesu, ǹswoŋ ghu mbo mə, “Lò faà mə ŋghɛɛ a adɨgə yi dàŋ ǹloŋ mə Herod a lɔ̀ɔ nzwitə wò.” ");
INSERT INTO bfd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu a kwiꞌi a mbo bò mə, “Nɨ̀ ghɛɛ nswoŋə a mbo nɨ̀màŋ ma nya mə, ‘Yə̂, sìi mə fiꞌi ɨzwì jî bɨ a atoꞌo bə̀, ŋ̀kɨɨ ŋghurə nɨ mɨ̀ghɔ̀ɔ̂ myaa, ɨ ghɛ̀ɛ yweꞌe a yɔɔ, a tɨ bə nɨ̂ ǹjwi ji tarə, mə̀ mâŋsə ɨfàꞌâ ghâ.’ ");
INSERT INTO bfd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lâ mə̀ tswe nɨ̀ ŋ̀ghɛ̀ɛ nɨ̀ m̀bìì sii, bo a yɔɔ, nɨ̂ ǹjwi yìi ɨ̀ yòŋtə aà; kaa a sɨ̀ tsinə̀ mə mbə bɨ zwitə̌ ŋgàŋntoò Nwì a adɨgə dàŋ ǹtsyatə a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wɛɛ, Yerusalem! Yerusalem! O zwitə ŋgǎŋntoo Nwî, ǹtumtə nɨ̂ bə̀ bìi mə bɨ too a mbo wò aa nɨ̀ ŋ̀gɔ̀ꞌɔ̀! Ŋ̀gàà jî ghàꞌàtə̀ mə̀ lɔ̀ɔ̀ mə̂ mə mə ghotə bɔɔ̀ buu tsǒ mə mâŋgu a ghotə bɔɔ̀ bi a njiꞌi mɨbǎ yuu aa, kaa nɨ̀ waꞌà biì. ");
INSERT INTO bfd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yə̂ nɨ̀, bɨ mèꞌè mə ndâ yùù. Mə̀ swǒŋ a mbo bǔ mə, kaa nɨ̀ ka waꞌà gha bù ǹyə nyweꞌe a noò yìi mə nɨ̀ ka yǐ tɨgə swoŋə nɨ mə, ‘Bìꞌinə̀ ghaꞌasə yu wa yìi mə a zì nɨ̂ Ɨ̀kûm M̀màꞌàmbi aà!’ ” ");
INSERT INTO bfd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A bə nɨ̂ ǹjwîŋgɔ̀ŋ yî mɔ̀ꞌɔ Yesu a ghɛɛ̀ a njɨ a nda ǹsaꞌà àlaꞌa yì mɔ̀ꞌɔ mə à lɛ mbə ŋû baFarɨsai, à tswè mə̂ ghu aa, bɨ ka ŋ̀kəənsə nìi. ");
INSERT INTO bfd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ŋù yì mɔ̀ꞌɔ à lɛ ntswe ghu mə nû yì ɨ̀ lɛ ŋkɔꞌɔkə, ");
INSERT INTO bfd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu a betə̀ ŋ̀gǎŋdɨꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai bìi mə bɨ lɛ ntswe ghu aa mə, “Nɔ̀ŋsə̀ à laa ndɨꞌɨ mə mbə bɨ ghurə̀ ŋû a njwîŋgɔ̀ŋ kə̀ ŋ̀gaŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bo tswê waa atsitsi kaa waꞌà akwiꞌi fâ. Yesu a lɔ̀gə̀ ŋû nɨ̀ghɔ̀ɔ̀ wa ŋghùrə̀ yi ntɨgə nswoŋ mə tâ à ghɛɛ yi. ");
INSERT INTO bfd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesu a tɨgə̀ ǹswoŋ a mbo bo mə, “Ŋù nɨ̀bù à tswe ghu mə mbə mû yì kə̀ m̀bɔ̀ŋ yì wô a mûn àtaa a njwîŋgɔ̀ŋ kaa a waꞌà bùrə̀ ŋ̀waŋsə ŋghɛ̀ɛ̀ mfiꞌisə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kaa bɨ lɛ ŋwaꞌà nɨ̂ àkwiꞌi nɨ̂ àbetə̀ ma yû tswê. ");
INSERT INTO bfd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu a ghɛɛ̀ nɨ̂ m̀bìì ǹnaa nɨghàà nî nǎnaa a mbo bə̀ bya bìi bɨ lɛ ntwoŋə waa wa nda aa, ǹyoŋə ajàŋ yìi mə à lɛ nyə bo tsɔꞌɔ̀ nɨ̂ ɨ̀lə̀ŋ jî kɔ̀ꞌɔ̀nə̀ a ntswe ghu aa, nswoŋ a mbo bo mə ");
INSERT INTO bfd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“M̀bə ŋù a twoŋə gho a adɨgə adinà nɨyɔꞌɔ, ò tsuu ghɛ̀ɛ tswe nɨ̂ àlə̀ŋ yî kɔ̀ꞌɔ̀nə̀, m̀bɨ̀ꞌɨ̀ ŋù yìi mə à kɔ̀ꞌɔ̀nə ntsyàtə̀ gho aa, a bû ǹyoŋ; ");
INSERT INTO bfd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","boŋ ŋù wa mə à kàꞌa adinà ya ntwoŋə ghuu yu bɨ̂tsɨ̀mə̀ aa, à ka zǐ a mbo wò swoŋ mə, ‘Bɨ̀ɨ̀nə mfa aləŋ ya a mbo ghuà ŋù’, boŋ ò ka bɨ̀ɨ̀nə maà noò nɨ̂ àdɨ̀rə atu a ntswe nɨ̂ àlə̀ŋ yìi mə kaa a sɨ̀ kɔꞌɔnə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lâ m̀bə bɨ twoŋə gho a adɨgə adinà, ò ghɛɛ ò tswê nɨ̂ àlə̀ŋ yìi mə a tswe a njɨ̀m kaa waꞌà kɔꞌɔnə̀ aà, ta bɛɛ mə mbɔŋə̀ àdinà wa a zi nyə gho, boŋ à ka swoŋ a mbo wò mə, ‘Ǹsû ghà, kɔꞌɔ ntswe nɨ̂ àlə̀ŋ yî ŋɛ̀nə̀ yî’; maa noò boŋ bɨ ka fa aghuꞌusə̀ a mbo wò a tɨtɨ̀ɨ bə̀ bìi mə bǔ bo ka tswe wa atu atɛtə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ǹloŋ mə ŋù ǹtsɨ̀m yìi mə a ŋee nɨ̂ nû yì aa, bɨ ka sɨgɨsə yi, ŋù yìi mə a bàŋnə̀ ǹsɨgɨsə nɨ̂ ɨ̀bɨɨ nû yi a nsyɛ aa, bɨ ŋɛntə̀ yi.” ");
INSERT INTO bfd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu a ghɛ̀ɛ̀ nɨ̂ m̀bìì ǹswoŋ a mbo ŋù wa mə à lɛ ntwoŋə yi mə tâ à zi njɨ aa mə, “M̀bə ò ka ntwoŋə bə̂ a adɨgə adinà, ò tsuù tsiꞌì ɨ̀kàꞌâ jo, kə̀ bɔɔ bɨ maà bo, kə̌ ŋgǎŋgwɛ̀ꞌɛ̂ jo, kə̌ ŋgǎŋmbɛ̀ɛ̂ ǹdùgə̂ jo jì wè ɨ twoŋə. Nloŋ mə ò bə ghɨ̀rə̀ ma la boŋ bo kɨ ŋkàꞌâ yaa adinà ŋkɨ ntwoŋə ghô, tâ ma ya a bə mɨtunɨ̀ mô. ");
INSERT INTO bfd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","La mbə ò kaꞌa adinà, ò twôŋ ŋ̀gǎŋə̂fum, bɨ̀tsə̀ŋkərə̀, bɨ̀bwènkə̀ bo bɨ̀ bɨ̀fə̀ꞌə̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ò bə twoŋ ɨ̀jàŋ bə̂ ma jû boŋ ò ka tswe nɨ̂ m̀bɔɔnə, nloŋ mə kaa mbə bɨ waꞌà nɨ̂ àyoò tsu a ŋghɨ̀rə a ntwu wò ghu aà. Ò ka yǐ kwɛrə mɨtunɨ mɨ afàꞌâ mo wa noò mə bə̀ bìi mə ɨ̀nnû jyaa ɨ tsinə bɨ ka yǐ yweenə nɨ nɨ̀wo aà.” ");
INSERT INTO bfd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ŋù yì mɔꞌɔ yìi mə bo bɨ̀ Yesu lɛ ntswe wa atu atɛtə̀ njɨ aa à yùꞌù mə annù ya mə Yesu à lɛ nswoŋə aa, ǹswoŋ a mbo Yesu mə, “M̀bɔɔnə a mbo ŋù yìi mə à ka yǐ jɨ abaa a mûm ànnù nɨfɔ̀ Nwî aà!” ");
INSERT INTO bfd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lâ Yesu a swoŋ ghu mbo mə, “Ŋù yì mɔ̀ꞌɔ à lɛ ŋkàꞌa adinà yî wè ǹtwoŋ bə̂ bì ghàꞌàtə̀; ");
INSERT INTO bfd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ǹjwî àdinà ya ɨ̀ kùꞌù mə̂, a toò ŋ̀gǎŋəfàꞌâ ji nswoŋ mə tâ bo ghɛɛ a mbo bə̀ bya mə bɨ twoŋə waa wa adɨgə adinà aa, ǹswoŋ mə, ‘Zî nɨ̀; nòò ǹjɨ̂ àdinà ya à kùꞌù mə̂.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","La bo bɨtsɨ̀m, yî mɔ̀ꞌɔ, yî mɔ̀ꞌɔ, bɨ lɔgɨ̀nə̀ ŋ̀ka nswoŋə nɨ̂ ɨ̀nnù jìi mə ɨ ghɨrə mə kaa mbə bo waꞌà zì aà. Yì ǹtsyàmbìì a swoŋ ghu mbo mə, ‘Mə̀ yuu àbwènə nsyɛ̂ yâ, ǹtswe nɨ̂ ŋ̀ghɛɛ nlèntə̂; mə̀ bùꞌû m̀bo mə tâ ò ghɛɛ nswoŋ a mbo Taà ghò mə kaa mə̀ ka waꞌà zì.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yì mɔ̀ꞌɔ a swoŋ yìi ŋgaa mə, ‘Mə̀ yuu bɨ̂kaù bɨ nlɨgə̀ ǹsòò bi nɨghum ǹtswe nɨ̂ ŋ̀ghɛɛ nlèntə̂; mə̀ jə̀ŋnə̂, ghɛ̀ɛ nswoŋ ghu mbo mə kaa mə̀ ka waꞌà zì.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yì mɔ̀ꞌɔ a swoŋ mə, ‘Wa mə̀ yɔ̀ꞌɔ ŋgwɛ̂ ghà, kaa mânjì ǹzi kaa a waꞌà bə̂.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ŋ̀gàŋàfàꞌà wa a bɨɨ̀ ŋ̀kɛꞌɛnə ɨ̀nnù tsɨ̀m a mbo Masà yì, ǹtɔ̂ŋ yì ɨ lwî, a swoŋ a mbo ŋ̀gàŋàfàꞌà wa mə, ‘Wàŋsə mfɛ̀ꞌɛ ŋghɛ̀ɛ a ɨtu mɨ̂ŋfâŋnə̀ bo bɨ̀ a ɨtəə̀ ǹdorə ɨtsɨ̀m a mûm ǹjɔ̀ꞌɔ̀ àlaꞌa, ǹtwoŋ ŋgàŋə̂mfum nɨ bɨ̀tsə̀ŋkərə̀, nɨ bɨ̀fə̀ꞌə̀nə̀, bo bɨ̀ bɨ̀bwènkə̀.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ŋ̀gàŋàfàꞌà wa à ghɛ̀ɛ̀ mə̂ m̀bɨɨ nswoŋ mə, ‘Taà, wa ànnù yìi mə ò swoŋ mə tâ mə̀ ghɛɛ ŋghɨ̀rə̀ aa, mə̀ ghɨ̀rə̀ mə̂, lâ àbwarə a burə̀ a mbo bə̀ bî ghàꞌàtə̀.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Masà wa a ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ a mbo ŋ̀gàŋàfàꞌâ yì wa mə, ‘Ghɛ̀ɛ nɨ̂ ɨ̀yàa ɨtsɨ̀m bo bɨ̀ a mum mɨ̀fuꞌu mɨ̀tsɨ̀m, ŋ̀gaansə bə̂ bìi mə ò yə aa mə tâ bo zi, ta tâ ǹdâ yà ɨ̀ luu.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mə̀ swoŋ tsiꞌǐ annù nɨ̂koŋ a mbo wò mə, kaa ŋù wa yì tsù mə bɨ kɨ̀ fòo ntwoŋə aa kaa à ka waꞌǎ ayoo wa adɨgə adinǎ mə̀ yweꞌetə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ǹnɔ̀ɔ̀ bə̂ ɨ lɛ sɨ yòŋə̀ nɨ a njɨm Yesu; a karɨkə̀ yi nswoŋ a mbo bo mə, ");
INSERT INTO bfd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ŋù à bə kɨ yòŋə̀ nàa, ɨ tuu taà yì, nɨ̂ ǹdè yì, nɨ̂ ŋ̀gwɛ̂ yì, nɨ bɔɔ̀ bim nɨ bɔɔ bɨ maà yi bî bâŋnə̀ nɨ bì bâŋgyɛ̀ ɨ tuu, ɨ tuu ɨbɨɨ nû yi yumbɔŋ, ɨ kɨɨ tuu boŋ kaa mbə waꞌǎ ŋgàŋyəgə̂nnù ghà bə̂. ");
INSERT INTO bfd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ŋù yìi mə à sɨ̌ ati bàŋnə̀ bàŋnə̂ yi beꞌè ŋ̀ka nyoŋə nàa laa, kaa m̀bə waꞌǎ ŋgàŋyəgə̂nnû ghà bə̂. ");
INSERT INTO bfd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ǹloŋ mə ŋù nɨ̀bù yìi mə a lɔ̀ɔ mbɔɔ ǹdânɨ̀kàŋ kaa waꞌà fòò ǹtswe a nsyɛ, ǹtaŋtə ndùu njoo jìi mə yu ka màŋsə nda ya ghu mbɔŋ nlɔ̀gɨ̀nə̀ aa, à nɨ̂ wò lɛ? ");
INSERT INTO bfd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","À bə tuu maa ajàŋ taŋtə, ɨ bàŋnə fòo tumə atsənda, tsuu ŋghɛ̀ɛ̀ nɨ̀ m̀bìì a màŋsə̂ ǹda ya ɨ zi, boŋ bə̀ bɨ̀tsɨ̀m bìi mə bɨ yə nda ya aa bɨ ka kɨ wyɛ̀ nìi, ");
INSERT INTO bfd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ɨ swoŋə nɨ mə, ‘Ŋù ghû à kɨ̀ lɔ̀gɨ̀nə̂ ŋ̀ghùrə̂ ǹdâ, ɨ̀ tsyà mə̂ yi a mmàŋsə̂.’ ");
INSERT INTO bfd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kə̀ m̀fɔ̀ yî mɔ̀ꞌɔ à tswe ghu mə mbə a ka ŋghɛɛ a mmàꞌâ ǹtsò bô m̀fɔ̀ yî mɔ̀ꞌɔ, kaa waꞌà a nsyɛ tswê, ǹtaŋtə mə mbə yu lɔgə̀ bə̌ ntsùꞌù nɨghum mmɨrə ŋghaꞌa a mfɔ̀ yî mɔꞌɔ yìi mə à tswe nɨ̀ bə̌ ntsùꞌù mɨghum mi mbaa aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","M̀bə a yə mə mbə yu waꞌà ghaꞌa, boŋ à ka too bə̂ a noò yìi mə mfɔ̀ yì mɔ̀ꞌɔ wa à bùrə a sàꞌa aghaꞌa aa, mə mbə yu tsuꞌunə̀ ǹtsò wa, tâ bo yu tswe nɨ̂ m̀bɔɔnə̂. ");
INSERT INTO bfd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mə̀ tɨgə̀ ǹswoŋə nɨ a mbo bù aa mə, ŋù tsù yìi mə à sɨ̌ njoò tsɨ̀m jìi mə à tswe nɨ ju tuu aa, kaa m̀bə waꞌà ŋ̀gàŋyəgə̂nnù ghà bə̂. ");
INSERT INTO bfd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Fɨ̀ŋgwaŋ fɨ bɔŋə̀; Lâ m̀bə fɨ̀ŋgwaŋ fɨ tuu nìi bǔ kɨ lìì, boŋ bɨ ka tɨgə bǔ ghɨ̀rə aa mə akə tâ fɨ̀ bǔ ka nlii aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Fɨ bə tuu bǔ kɨ lìì boŋ kaa fɨ sɨ̀ nɨ̂ àfàꞌà bû ǹtswe; kaa waꞌà kɨ̀ ŋ̀kuꞌunə a nnɨŋ a nsyɛ bo bɨ̀ a bɔꞌɔ̀ ǹtsàꞌà. Ŋù yìi mə à tswe nɨ̂ ɨ̀tôŋnə̀ a nyuꞌu aa, tâ à yuꞌu.” ");
INSERT INTO bfd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","À lɛ mbə a njwi yì mɔ̀ꞌɔ, ŋgǎŋkwɛrə bɨ̀taksì bo bɨ̀ ŋ̀gǎŋghɨ̀rə̂ ɨ̀nnù jì bɨ zî ǹtswe a mbɛ̀ɛ Yesu a nyuꞌu ɨ̀nnù jìi à lɛ sɨ swoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","BaFarɨsai bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ kâ nnurəkə nswoŋə nɨ mə, “M̀bâ ghû à lɔ̀gə̀ nɨ̂ ŋ̀gǎŋghɨ̀rə̂ ɨ̀nnù jî bɨ bo bo jɨ̂!” ");
INSERT INTO bfd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Maa ajàŋ, Yesu a tɨgə̀ ǹnaa nɨghàà nuà a mbo bo: ");
INSERT INTO bfd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Àa ghuu ŋû nɨ̀bù yìi mə mbə a tswe nɨ̂ m̀bînjə̀rə̂ ji ŋkhɨ̀ yî fùùrə̀, bɛɛ mə yì mɔ̀ꞌɔ bwɛ, boŋ à ka waꞌà màꞌàtə jya mɨ̀ghum mi bùꞌû ǹtsò mbùꞌû a atu ntaꞌa, ŋghɛɛ ŋka nlɔɔ ya mə ɨ̀ bwɛ aa, nyweꞌe noò yìi mə à ka yə ma ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bɛɛ mə a yə, a ŋɛɛ nnɔ̀ŋsə̀ a abɛ̀ꞌɛ yu, ntɨgə ndorɨtə. ");
INSERT INTO bfd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ǹtɨgə ŋkwɛɛ a ndùgə̀, ǹtwoŋ ɨkaꞌà ji bo bɨ̀ bàmbɛ̀ɛ ndugə̂ bi, ǹswoŋə a mbo bo mə, ‘Bìꞌinə̀ ka ndorɨtə nloŋ mə mə̀ yə̀ mə̂ m̀bi yà ya mə ɨ̀ lɛ mbwɛ aà’. ");
INSERT INTO bfd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mə̀ swòŋə a mbo bù mə a kɨ mbə aa tsiꞌì ma mùu ajàŋ, nɨ̀dorə nì ghàꞌàtə̀ ka tswe a aburə mə mbə ŋù yì mbɨ yì m̀fùùrə̀ a bəŋkə ntɨɨ̀ yi, ntsyatə àjàŋə bɨ dorɨtə nloŋ bə̂ mɨghum mi bùꞌû ǹtsò bùꞌu bìi mə ànnù yaa a tsinə kaa bo waꞌà nɨ̂ m̀bə̀ŋkə mɨ̀ntɨɨ̀ myaa bû ǹtswe aà. ");
INSERT INTO bfd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kə̀ à nɨ ghuu mâŋgyɛ̀ mə à tswe nɨ̂ ɨ̀bàꞌatə ŋkabə̀ ji ji nɨghum, bɛɛ mə yǐ mɔꞌɔ a bwɛ, a waꞌà lâm kosə̀ nyɛꞌɛ ǹdâ yì, ǹnaŋsə ŋka nlɔɔ nyweꞌe noò yìi à ka yə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bɛɛ mə a yə, a twôŋ ɨ̀kàꞌâ ji bo bɨ̀ bambɛ̀ɛ̀ ǹdùgə̂ bi bɨ zî, a swoŋ a mbo bo mə, ‘Bìꞌinə̀ ka ndorɨtə ǹloŋ mə mə̀ yə̀ mə̂ ŋ̀kabə̀ yà ya mə ɨ̀ lɛ mbwɛ aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mə̀ swòŋə a mbo bù mə à kɨ mbə tsiꞌì a ŋgɨ̌ŋ ŋgɨ̀ŋ mə, nɨ̀dorə nɨ tswe a aburə a mbo baangel bɨ Nwî ǹloŋ ŋû ŋ̀ghɨ̀rə̂ ɨ̀nnù jì bɨ yì m̀fùùrə̀ yìi mə à bə̀ŋkə ntɨɨ̀ yi aà.” ");
INSERT INTO bfd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu a bû ŋ̀ghɛɛ nɨ̂ m̀bìì ǹswoŋ mə, “Ŋù yì mɔ̀ꞌɔ à lɛ ntswe nɨ bɔɔ mbâŋnə̀ bi baà. ");
INSERT INTO bfd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yì ŋ̀kə̀gə a swoŋ ghu mbo mə, ‘Taà, yàtə njoò jo mfa jìi mə ò tswe nɨ̀ m̀fa a mbo mə̀ aa tsɨ̂tsɔ̀ŋə̀.’ Taà waa wa a tɨgə̀ ǹyatə njoo jya a tɨtɨ̀ɨ bo. ");
INSERT INTO bfd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ǹjwi jì tsu ɨ ghə̀ mə kə tsyǎ, mu yì kə̀gə wa a ghotə̀ jìi njoo jya mfèè, ǹlɔgə ŋkabə yì m̀fɛꞌɛ ŋghɛ̀ɛ̀ yi a atoo asàꞌa aghaꞌà, ǹta ŋgɨꞌɨ nɨ̂ ŋ̀kabə̀ yì ya, njɨ nɨ̂ m̀bi ghu. ");
INSERT INTO bfd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nòò yìi mə ŋkabə yì ya ǹtsɨ̀m ɨ̀ lɛ mmɛ̀ aa, mɨ̀kwenə̀ yî ǹtɨ̀ɨ̀ a kuu wa alaꞌa, a tɨgə̀ ŋ̀karə nlɔɔ nɨ̂ àyoo yì jɨ̀ kɨkaŋ, ");
INSERT INTO bfd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ŋghɛɛ ntsiꞌi ŋû àlaꞌa wa yì mɔ̀ꞌɔ, mbuꞌu mbo ghu mbo mə tâ à lɔgə yì nɨ̂ ŋ̀gàŋàfàꞌâ yì. Ŋù wa a lɔgə̀ yi ntoo a mûm ǹsòo yu mə à ghɛɛ ŋka njɛꞌɛ bɨ̂kwiŋyàmə̂ bi. ");
INSERT INTO bfd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","À lɛ sɨ yə̀ꞌə̀tə mə boŋ yu jɨ ntsàꞌà bɨ̂ kwiŋyàm jyâ, la kaa ŋù waꞌà ghu mbo fâ. ");
INSERT INTO bfd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","À lɛɛ̀ m̀bə nɨ a njwi yì mɔ̀ꞌɔ, àtû yi a tɔŋ, a swoŋ mə, ‘Ŋ̀gǎŋəfàꞌà Taà tsiꞌì tsɨ̀m ɨ tswe nɨ̀ mɨ̀jɨ a njɨ mɨ ghaꞌà nɨ̀ waa, lâ mə̀ tswê faà m̀baŋnə ŋkwo nɨ̂ ǹjì ghu! ");
INSERT INTO bfd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mə̀ ka bɨ̀ɨ̀nə ɨ kwɛɛ ghɛ̀ɛ̀ a mbɛ̀ɛ Taà ghà, ɨ swoŋ gho mbo mə, “Taà, mə̀ ghɨ̀rə̂ ɨ̀bɨ a nsi miꞌi Nwì bo bɨ̀ a mbo wò: ");
INSERT INTO bfd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kaa mə̀ sɨ̀ kuꞌùnə̀ mə mbə ò twoŋə̀ gha nɨ mû ghò yî m̀bâŋnə̀; tɨgə nlɔ̀gə̀ gha bə tsiꞌì tsǒ ŋgàŋàfàꞌâ ghò yî mɔ̀ꞌɔ.” ’ ");
INSERT INTO bfd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","À lɛ ntɨgə mbɨɨnə ŋka ŋghɛɛ a mbɛ̀ɛ Taà yì wâ. Lâ nòò yìi mə à lɛ mburə tsiꞌì a sàꞌa aghaꞌa aa, Taà yì wa a yə̂ yi, ŋ̀ko mɨlɨ̀ŋnə̀ yì, ŋ̀khə̀ ŋ̀ghɛ̀ɛ̀ ŋ̀kotə yi a ntsǔntɨɨ yu, ǹnɔŋ mɨghə̀ŋə̂ mi. ");
INSERT INTO bfd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mu wa a swoŋ ghu mbo mə ‘Taà ghà, mə̀ ghɨ̀rə̂ ɨ̀bɨ a nsi miꞌi Nwì a aburə, ŋkɨ ŋghɨrə a nu wò; wa kaa mə̀ sɨ̀ kuꞌùnə̀ mə tâ ò ka ntwoŋə nàa nɨ mû ghò.’ ");
INSERT INTO bfd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","La taà yì wa a bâŋnə̀ ǹswoŋ a mbô ŋ̀gǎŋfàꞌâ ji mə, ‘Nɨ̀ waŋsə nzì nɨ̂ àtsə̀ꞌə̀ yî bɔ̀ŋ bɔŋ ya, mmàꞌà ghu nû; ŋ̀kɨ ŋwɛꞌɛ nɨ̀ a karə̀ ghu mbo, nɨ̂ ǹtam ghu mɨkòrə̀; ");
INSERT INTO bfd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Zǐ nɨ̀ nɨ kau wa mə bɨ naŋsə njɛꞌɛ a faŋ mfaŋ aa, ŋ̀wa, tâ bìꞌinə̀ jɨ, ŋka ndorɨtə; ");
INSERT INTO bfd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ǹloŋ mə mû ghà ghû à lɛ ŋkwo, à bǔ ntswe fu ntɨ̀ɨ̀; à lɛ mbwɛ, bɨ bù mə̂ ǹyə yi fu.’ Bo lɛ ntsuꞌu ntɨgə njɨ ndorə. ");
INSERT INTO bfd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“À lɛ mbə maa noò aa, mu yì ndɨɨ wa a tswê a afɔ̀; nòò yìi mə lɛ ŋkwɛɛ ŋka nyweꞌe a mbɛ̀ɛ̀ ǹdùgə̀ bo aa, nyuꞌu ajàŋ mə bɨ yəə nɨ̂ ɨ̀kòò m̀buꞌu nɨ̂ ŋ̀gɔ̀ɔ̀. ");
INSERT INTO bfd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","“A twoŋə̀ ŋ̀gàŋàfàꞌà wa yì mɔ̀ꞌɔ mbetə yi mə, a fɛ̀ꞌɛ̂ ànnǔ akə lɛ. ");
INSERT INTO bfd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A swoŋ mə, ‘Mu maà ghò wa à ghɨ̀rə̂ ŋ̀kwɛɛ, taà ghò a tɨgə̀ ŋ̀wa a kaù wa mə bɨ lɛ nnaŋsə njɛꞌɛ a faŋ aà, ǹloŋ mə à lɛ mbù ŋ̀kwɛɛ ŋkuu sɨgɨ̀nə̀ aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mu yì ndɨɨ wa à lɛ nlwìsə ntɔŋ, ntuu ŋkuu a ndùgə bo. Taà yì wa a fɛꞌɛ̀ ŋ̀ghɛɛ ntsiꞌi yi ŋka nlətə mə tâ à kuu. ");
INSERT INTO bfd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A kwiꞌi a mbo Taà yì mə, ‘Yə̂, mə̀ nwùgə̀ mə̂ nû ya mfaꞌa a mbo wò nɨ̂ ǹdùu ɨlòò jî ghàꞌàtə̀, kaa mə̀ lɛɛ̀ ŋ̀waꞌǎ atu a mbo wò tɨɨ̀; lâ kaa ò lɛɛ̀ ŋ̀waꞌà tsiꞌì mû mbi yì ŋkə̀ꞌə̀tə̀ a mbo mə̀ fa mə ta mə̀ wa ta bìꞌi bɨ̀ ɨ̀kàꞌâ jya kurə ŋka ndorɨtə. ");
INSERT INTO bfd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lâ mû ghò ghû, mə à lɛ nlɔ̀gə njoò jo ŋghɛ̀ɛ̀ bo bɨ̀ ɨ̀kwàrə̀ tâ ŋ̀gɨꞌɨ ghu aa, à tɨ̀ mə tɨ kwɛɛ aa, ò wâ kaù wa mə bɨ lɛ njɛꞌɛ a faŋ faŋ aà!’ ");
INSERT INTO bfd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Taà yì wa a swoŋ ghu mbo mə, ‘Mû ghà, ò tswe aa tsiꞌì bìꞌò bɨnòò bɨ̀tsɨ̀mə̀, ǹjoò jyâ tsɨ̀m ɨ kɨ̂ m̀bə̂ jô. ");
INSERT INTO bfd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A ghɨrə mbɔ̀ŋ mə tâ bɨ̀ jɨ ŋka ndorɨtə, ǹloŋ mə mumaà ghò ghû à lɛ ŋkwo, à bu ntswe ntɨ̀ɨ̀; à lɛ mbwɛ bɨ bû ǹyə yi.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu à ghɛ̀ɛ̀ nɨ̂ m̀bìì ǹswoŋ a mbô ŋ̀gǎŋyəgə̂nnù ji mə, “Ŋ̀gàŋkabə yì mɔ̀ꞌɔ à lɛ ntswe ghu, yìi mə à lɛ ntswe nɨ̂ ŋ̀gàŋàfàꞌà a lêntə̀ nɨ̀ ǹjoò ji. Bɨ zî ŋ̀kɛꞌɛnə a mbo ŋ̀gàŋkabə wa mə kaa ŋgàŋàfàꞌà wa kaa à lɛ sɨ waꞌà nɨ̀ njoò ji jya sɨgɨ̀nə̀ lêntə̀, ŋ̀kɨɨ nta nɨ̂ ŋ̀gɨꞌɨ nɨ̂ ŋ̀kabə̀ yì. ");
INSERT INTO bfd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A twoŋə̀ ŋ̀gàŋnlèntə̂ ǹjoò yì wa mbetə yi mə, ‘Yuà ànnù mə mə̀ yùꞌu nloŋ ŋgaà yò aa à nɨ̂ àkə̀ aa ɛ? Zì nɨ̂ àŋwàꞌànə̀ ǹdɨꞌɨ ajàŋ mə o lə̀ə njoo jya, nnɨŋtə ghu aa tâ mə̀ yə. Kaa ò ka waꞌà nɨ̂ m̀bìì ghɛɛ̀ a nlə̀ə̂ ǹjoò jâ.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ŋ̀gàŋnlèntə̂ ǹjoo wa a swoŋ a atu yu mə, ‘Mə̀ ka ghɨ̀rə̀ aa mə akə mə Taà ghà a lɔ̀ɔ ŋkwɛrə àtû àfàꞌà yû a mbo mə̀ aa ɛ? Kaa mə̀ sɨ̀ nɨ mɨ̀tɨ̀ɨ̀ tswê a ntoŋ ɨdɨ̀gə̀; àtû ya a kɨɨ̀ ǹdɨrə mə mbə mə̀ ghɛɛ̀ ŋ̀ka nlɔɔ nɨ̂ ǹjoò. ");
INSERT INTO bfd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mə̀ zî ànnù yìi mə mə̀ ka ghɨ̀rə̀, mə tâ bə̀ ka ŋkwɛrə gha a mɨlaꞌa bo ajàŋ mə mbə bɨ fiꞌi gha a afàꞌà.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Maa ajàŋ, a twoŋ ŋgàŋmɨkarə mɨ taà yì wa yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ̂. M̀betə a mbo yì ǹtsyàmbìì mə, ‘O tswa Taà ghà aa nɨ̀ àkə̀ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A kwiꞌi mə ‘Nɨ̂ ŋ̀kàꞌà mɨwurə ŋkhɨ̀ yî fùùrə̀.’ A swoŋ ghu mbo mə, ‘Àâ àŋwàꞌànə̂ yô a yuà, wàŋsə nzi ntswe a nzyɛ, ŋkwensə mbàŋnə ŋwàꞌànə̀ mə o tswa nìi laa nɨ̀ ŋ̀kàꞌà mɨwurə mɨ̀ghum mi ntaà.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ǹtɨgə ŋghɛɛ nɨ̂ m̀bìì m̀betə a mbo àyòŋtə̀ mə, ‘O tswa Taà aa nɨ̀ àkə̀ aa ɛ?’ A kwiꞌi mə ‘Nɨ ŋkàꞌa ansaŋ ŋkhɨ̀ yî fùùrə̀.’ A swoŋ ghu mbo mə, ‘Àâ àŋwàꞌànə̂ yô a yuà, bàŋnə ntɨgə ŋŋwàꞌànə̀ ghu mə o tswa nìi aa nɨ̂ ŋ̀kàꞌâ ànsaŋ mɨghum mi nɨfwaà.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tâfàꞌà yì wa à lɛ mbeentə ŋgàŋàfàꞌà yì yî m̀bɨ mà ghû nloŋ mɨtsyɛ̀ mìi mə à lɛ ntswe nɨ mu aà. Nɨ̀ yə mə bə̀ bɨ mbi bù bɨ tswe nɨ̀ mɨ̀tsyɛ̀ a ŋghɨ̀rə̂ jyaa ɨnnù ǹtsyatə bɔɔ bɨ Nwî bìi mə bɨ tswe a mûm ŋ̀kàꞌà aà.” ");
INSERT INTO bfd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu a ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ a mbo bo mə, “Nɨ̀ ka ŋghɨrə ɨkaꞌà juu nɨ̂ ǹjoo mbi jù ta a yi mbɨꞌɨ a mbɛ̀ɛ bù bɨ kwɛrə̀ ghuu a mɨlaꞌa mìi mɨ lwiꞌi nɨ̂ŋkoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ŋù yìi mə à fàꞌa nɨ̂ ǹtɨɨ̀ yi tsɨ̀m nɨ̂ ǹjoo jìi mə kəꞌətə aa, à zî àjàŋ yìi mə mbə yu kɨ̂ ǹlentə njoo jìi mə ɨ ghaꞌatə aa nɨ̂ ǹtɨɨ̀ yi tsɨ̀mə̀; ŋù yìi mə a jɨ ŋkòbə̀ nɨ̂ ɨ̀nnù jî kə̀ꞌə̀tə̀ à ka kɨɨ jɨ ŋkòbə̀ mə mbə bɨ maꞌatə mə tâ à lentə njoo jî wè. ");
INSERT INTO bfd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","M̀bə a bə mə kaa nɨ̀ sɨ njoo mbi jù nɨ̂ ǹtɨɨ̀ ghuu tsɨ̀m lentə boŋ mbə bɨ tɨgə̀ m̀maꞌatə mə tâ nɨ̀ ka nlentə njoo annù nɨ̂koŋ jìi mə à nɨ njoo aburə aa mə akə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mbə nɨ̀ tuu njoo ŋû dàŋ nɨ̂ ǹtɨɨ̀ ghuu tsɨ̀m kɨ lèntə̀, boŋ ŋù yìi mə à ka fa ghuu nɨ̂ ǹjoo jìi mə à nɨ̂ juu aa à nɨ wò aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kaa mbə ŋgàŋàfàꞌà à waꞌà a mbo bɨ̀tà bɨ afàꞌà bi baa ka mfaꞌa; ǹloŋ mə à ka bàà yî mɔ̀ꞌɔ ɨ bàŋnə kɔ̀ŋ yì mɔ̀ꞌɔ̂; kə̀ a kâ m̀faꞌa a mbo yì mɔ̀ꞌɔ nɨ̂ ǹtɨɨ̀ yi tsɨ̀m, m̀baŋnə ntsaꞌa nɨ yì mɔ̀ꞌɔ̂. Kaa mbə ò waꞌǎ a mbo Nwì bo bɨ̀ a mbô ŋ̀kabə ka mfaꞌa.” ");
INSERT INTO bfd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","BaFarɨsai, bìi mə bɨ lɛ ŋkɔ̌ŋ ŋkabə siꞌi siꞌi aa, bɨ yùꞌù mə̂ ma yuù ànnù mə Yesu à lɛ nswoŋ aa, ŋ̀wyɛ waa. ");
INSERT INTO bfd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","La Yesu a swoŋ a mbo bo mə, “À nɨ bù bìi mə nɨ lɔ̀ɔ ndɨ̀ꞌɨ mə ànnù yuu a tsinə a nsi miꞌi bə̀ aà, lâ Nwìŋgɔ̀ŋ à zi mɨ̀ntɨɨ̀ muu; ǹloŋ mə ànnù yìi mə bàmɨsɔ̀ŋ bɨ mɔ̀ɔ̀ntə̀ nɨ mə à nɨ ànnù yî wè kə̀ ŋ̀kɨ mbə ayoo atɨ̀ndùù aa, à bàŋnə mbə ayoo yìi mə Nwì bàà aà. ");
INSERT INTO bfd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Bɨ̀nɔ̀ŋsə̀ bɨ Moses bo bɨ̀ ɨ̀nnù jìi mə ŋgǎŋntoo Nwì ɨ lɛ ŋŋwàꞌànə̀ aa, ɨ lɛ sɨ saꞌa bə̀ ŋ̀kɔꞌɔ nyweꞌe aa a noò Jɔn; ǹlɔgɨnə maa noò, ànnù yìi mə bɨ tɨgə nswoŋə aa à nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya nloŋə annù nɨfɔ̀ Nwì yìi mə bɨ làànsə̀ aà. Bə̀ bɨ̀tsɨ̀m bɨ gaansə̀ nɨ̀ mɨ̀tɨ̀ɨ̀ myaa a ŋkuu ghu nɨ̂ àdàꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lâ a yaŋsə a mbo abùrə̀ bô ǹsyɛ a ntsyâ, ǹtsyatə mə mbə bɨ bwɛsə̀ tsiꞌì muntsìrə̂ ànnù a mum nɔ̀ŋsə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“M̀bə ŋùmbâŋnə a fiꞌi ŋgwɛ̂ yì a nda yu mbu nyɔꞌɔ yî dàŋ boŋ à ghɨ̀rə aa annǔ mâghàbə̀; ŋùmbâŋnə̀ yìi mə à yɔ̀ꞌɔ mâŋgyɛ̀ yìi mə ndoò yì à fùrə aa, a kɨ̂ ŋ̀ghɨrə aa annǔ mâghàbə̀. ");
INSERT INTO bfd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ŋ̀gàŋkabə yì mɔ̀ꞌɔ à lɛ ntswe ghu yìi mə à lɛ sɨ wɛꞌɛ nɨ̂ ɨ̀tsə̀ꞌə atɨ̀ndùù jìi mə ɨ lɛ mbɔ̀ŋ mbɔŋ aa, ŋkɨ nnaŋsə njɨ nìi tsiꞌì sɨgɨ̀nə̀ a njwî tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ŋ̀gàŋàfumə yî mɔ̀ꞌɔ yìi mə ɨ̀kǔm yi ɨ lɛ mbə Lazarus, ɨ̀làꞌà ɨ luu ghu nu aa, à lɛ sɨ nɔ̀ŋə̀ ghu ntsǔbùꞌù, ");
INSERT INTO bfd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ǹyəꞌətə mə mbə yu kâ ǹsyɛ nɨ̂ ŋ̀kùgə̀ mɨjɨ jìi mə ɨ lɛ sɨ lò a atu atɛtə ŋgàŋkabə wa ŋwòkə̀ aa njɨ; m̀bu ŋghɛ̀ɛ̀ ghu, mbu ɨ lɛ sɨ zì ǹlwa nɨ̂ ɨ̀làꞌà ji jyâ. ");
INSERT INTO bfd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ŋ̀gàŋàfum wa à lɛ ŋkwo baangel bɨ lɔgə̀ yi ŋghɛɛ nɨ ghu a mbɛ̀ɛ Abraham. Ŋ̀gàŋkabə wa à lɛ ŋkɨ ŋkwo bɨ twiŋə̀ yi; ");
INSERT INTO bfd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","a sɨgə ŋghɛ̀ɛ̀ a alaꞌa bɨ̀ku bɨ bə̂ ǹtɨgə nyə nɨ̂ ŋ̀gɨꞌɨ ghu. À tswè mə̂ ghu aa, ŋ̀ŋɛntə miꞌì mi nyə Abraham a sàꞌa aghaꞌa, Lazarus a tswê ghu mbɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","À yə̀ mə̂, ǹtwoŋ tsiꞌì nɨ̀tɨ̀ɨ̀ mə, ‘Taà ghà Abraham, ko mɨlɨ̀ŋnə̀ ghà ǹtoo a Lazarus tâ à tsutə mûswɛ̂bô yì a mûm ŋ̀kì ǹzi ntsùtə̌ aləə̀ ya ghu; ǹloŋ mə mə̀ burə ntswe tsiꞌì a mûm ŋ̀gɨꞌɨ yì ŋ̀wè fàa mum mɔꞌɔ.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Lâ Abraham a kwiꞌi ghu mbo mə, ‘Mû ghà, ò wàꞌàtə mə a mûm ǹtswêntɨ̀ɨ yò ò lɛ ntswe nɨ̂ ǹjoo jì sɨgɨ̀nə̀, Lazarus a bâŋnə̀ ǹyə nɨ̂ ŋ̀gɨꞌɨ̀; lâ tsɨtsɔ̀ŋ à tswe a mûm ɨ̀bɔ̀ŋ, m̀fwɛtə falà, ò bâŋnə̀ ŋkurə nɨ̂ ŋ̀gɨꞌɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lâ m̀bu ŋghɛ̀ɛ̀ ghu, ma mùꞌù àtaa a tswe a tɨtɨ̀ɨ bìꞌì nɨ wò, ŋ̀kɨŋə nɨ mə tâ ŋù tsuu faà lǒ dàŋsə zǐ a mbɛ̀ɛ wò; tâ ŋù tsuu fyaa njii ɨ lǒ kɨɨ dàŋə zì faà.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ŋ̀gàŋkabə wa a swoŋ mə, ‘Taà ghà, mbə a bə la boŋ mə̀ bùꞌû m̀bo a mbo wò mə ta ò too yi a mbo bɔɔ bɨ maà, ");
INSERT INTO bfd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ǹloŋ mə mə̀ tswe nɨ̀ bɔɔ bɨ maà bi ntaà, mə mbə a ghɛɛ̀ ŋ̀waꞌasə waa, mbɨ̀ꞌɨ̀ bɨ yî ŋ̀kɨ zi ŋkuu fàa adɨgə ŋgɨꞌɨ mə mə̀ tswe ghu aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","La Abraham a kwiꞌi ghu mbo mə, ‘Bo tswe nɨ̀ àŋwàꞌànə Moses bo bɨ̀ jǐ ŋgǎŋntoo Nwî, a bɔŋ mə tâ bo ka nyuꞌu annù yìi mə ɨ swoŋə aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ŋ̀gàŋkabə wa a ghɛɛ̀ nî m̀bìì ǹswoŋ mə, ‘Ŋ̀gaŋ, Taà Abraham; ŋù à bə lǒ fàa alaꞌa bɨ̀ku bɨ bə̂ ghɛ̀ɛ̀ a mbo bo boŋ bo ka bəŋkə mɨ̂ntɨɨ̀ myaa.’ ");
INSERT INTO bfd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A kwiꞌi ghu mbo mə, ‘M̀bə bo tuu annù yìi mə Moses bo bɨ̀ ŋ̀gǎŋntoo Nwî jya swoŋ aa kɨ yuꞌu, boŋ kaa mbə bɨ waꞌǎ kɨ̀ m̀bii, mə mbə ŋù à tɛꞌɛ nlo bə a alaꞌa bɨ̀ku bɨ bə̂ ǹzi ŋghàà a mbo bo.’” ");
INSERT INTO bfd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu a bu nswoŋə a mbo ŋ̀gǎŋyəgə̂nnù ji mə, “Ɨ̀nnù jìi mə ɨ kwàꞌànə̀ bə̂ mə bɨ̀ ka ŋghɨrə ɨbɨ aa ɨ tswe nɨ̀ ǹzî, lâ ŋ̀gɨꞌɨ yì ŋ̀wè a a nu ŋù yìi mə ɨ tsyà ghu njɨ̀m ǹzì aà! ");
INSERT INTO bfd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A bɔŋ aa mə boŋ bɨ kwerə̀ ŋ̀gɔ̀ꞌɔ̀ àbaa ghu ntɔŋ, mmaꞌa yi a ŋkì mɨyaa, ntsyatə ajàŋ yìi mə mbə bɨ maꞌàtə̀ a ghɨrə̀, ŋù yì ŋ̀kə̀gə ghu yi mɔ̀ꞌɔ a ghɨrə̀ ɨ̀bɨ̂. ");
INSERT INTO bfd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Maa ajàŋ, nɨ̀ ka ntsyɛsə ghuu. “M̀bə mumaà ghò a fansə annù a mbo wò, ò wenə yi, a bəŋkə ntɨɨ̀ yi, ò liꞌìnə̀ ɨ̀bɨ̂ yi. ");
INSERT INTO bfd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","M̀bə a fansə annù a mbo wò ŋgaa ji sàmbaa a njwi yì m̀fùùrə̀, ŋ̀kɨ ŋka nzi tsiꞌì ŋ̀gaa tsɨ̀m ǹswoŋə nɨ mə, ‘Mə̀ jə̀ŋnə̂, mə̀ ka kwensə, lìꞌìnə ɨfansənnû jyâ,’ boŋ ò tswe nɨ̀ ǹlìꞌìnə ɨ̀fansənnù ji.” ");
INSERT INTO bfd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ŋ̀gǎŋntoo Mmàꞌàmbi jya ɨ lɛ swoŋ ghu mbo mə, “Ghɨ̀rə mə tâ àbìintɨɨ̀ yìꞌi a kuꞌusə ŋghaꞌatə!” ");
INSERT INTO bfd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","M̀màꞌàmbi a swoŋ a mbo bo mə, “Nɨ̀ lɛ mbaa ntswe nɨ̂ àbìintɨɨ tâ à ghaꞌatə mbə tsiꞌì tsǒ àbùrə mâghum, bəə boŋ mbə nɨ̀ swoŋ a mbo àtǐ ajɔ̀ɔ̀ yû mə, ‘Dunə nlo ntɨgə ŋghɛɛ ntəə a mûm ŋkì mɨyaa!’ A yuꞌunə̀ ghuu. ");
INSERT INTO bfd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“M̀bə ŋù nɨ̀bù yî mɔ̀ꞌɔ a tswe nɨ̀ ŋ̀gàŋàfàꞌâ yì yìi mə a lɨgə nsoò yì, kə̀ ǹtsee nɨ̂ m̀bî ji, m̀bə a lo a afɔ̀ ŋ̀kwɛɛ, boŋ à ka swoŋ ghu mbo aa mə tâ à waŋsə nzì ǹjɨ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ò ka waꞌà bàŋnə̀ ǹswoŋ aa bə mə, ‘Wàŋsə nlaa mɨjɨ̂ ma mǐ ŋkwɛ̂fɔ̀, ŋ̀wɛꞌɛ atsə̀ꞌə afàꞌà ǹzi ntsyàsə̀ mɨjɨ mya ta mə̀ jɨ ŋkɨ nno mbɔŋ tâ ò ghɛɛ njɨ moò mɨjɨ ŋkɨ nno aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ò ka tɛꞌɛ baa fa tsiꞌì mɨyà ghu mbo ǹloŋ mə à ghɨ̀rə nyuꞌunə gho, ŋghɨ̀rə annù ya mə ò ghɨ̀rə nswoŋ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A kɨ mbə aa tsiꞌì ma mùu ajàŋ a mbo bù; nɨ̀ yɨ ŋghɨ̀rə ɨnnù tsɨ̀m jìi mə bɨ swoŋ mə tâ nɨ̀ ghɨrə aa, nɨ̀ swoŋə̀ bə mə, ‘Bìꞌì bə aa tsiꞌì ŋ̀gàŋəfàꞌà; bìꞌi ghɨrə aa tsiꞌì ànnù yìi mə bìꞌì tɛꞌɛ ntswe nɨ̂ m̀fàꞌa aà.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nòò yìi mə Yesu à lɛ sɨ kɔꞌɔ ŋghɛɛ nɨ a Yerusalem aa, à lɛ ntsyǎ a tɨtɨ̀ɨ Samaria bo Galilea. ");
INSERT INTO bfd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","À lɛ ŋghɛ̀ɛ̀ ŋ̀ka ŋkuu a mum àlaꞌa yǐ mɔꞌɔ ŋgàŋə̂kɨ̀kwen ji nɨghum ɨ zî ǹtsiꞌi yi, ǹtəə a sàꞌa aghaꞌa, ");
INSERT INTO bfd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ǹtɔŋnə nswoŋ mə, “Yesu, Masa, ko mɨlɨ̀ŋnə̀ yìꞌì!” ");
INSERT INTO bfd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nòò yìi mə à lɛ nyə waa laa nswoŋə a mbo bo mə, “Nɨ̀ ghɛɛ ndɨ̀ꞌɨ mɨ̀bɨ̀ɨ̀ mɨ nû muu a mbô ŋ̀gǎŋmàꞌa Nwì.” Bo kà mə̂ aa ŋghɛɛ aa mɨbɨ̀ɨ̀ mɨ nû myaa mɨ laà. ");
INSERT INTO bfd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ŋù yì mɔ̀ꞌɔ a tɨtɨ̀ɨ bo, à tɨ̀ mə yə mə nû yì ɨ̀ làa aa, mbu ŋkarə mbɨɨ, ntɔŋnə ŋghaꞌasə nɨ̂ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ǹsɨ̀gə ŋwo a mɨkòrə Yesu, mfa mbɨꞌɨkə̀ ghu mbô. Ŋù ma ghû à lɛ mbə ŋû baSamaria. ");
INSERT INTO bfd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu à yə̀ mə̂ laà aa mbetə mə, “Tɨgə mə̀ ghɨ̀rə ŋghùrə̀ aa bə̀ bi nɨghum aa ɛ? Bə̀ bi bùꞌû bɨ fə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","A ghɨ̀rə̂ àkə̀ mə tâ à tɨgə mbɨɨ tsiꞌì ŋù atoo ghù a mfa mbɨꞌɨkə a mbo Nwì aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu à lɛ ntɨgə mbu nswoŋ a mbo ŋù àtoo wa mə, “Bɨ̀ɨ̀nə ŋka ŋghɛ̀ɛ̀ ghô; wa àbìintɨɨ̀ yo a ghɨ̀rə̀ mə̂ ò tɨɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","BaFarɨsai bî mɔꞌɔ lɛ mbetə noò yìi mə ànnù nɨfɔ̀ Nwî a ka yǐ zì ghu aa a mbo Yesu, a kwiꞌi a mbo bo mə, “Kaa annù nɨfɔ̀ Nwî a ka yǐ waꞌà kà ǹzi aa nɨ̀ ɨ̀lènsə̀ jìi mə bɨ yə nɨ miꞌì. ");
INSERT INTO bfd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaa ŋù tsù à ka yǐ waꞌà kà ǹswoŋə nɨ mə, ‘Yə̂, â yuà!’ kə̀, ‘Yê nɨ̀, â yiì!’ ǹloŋ mə ànnù nɨfɔ̀ Nwî a tswe a tɨtɨ̀ɨ bù.” ");
INSERT INTO bfd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu a bû ǹswoŋ a mbo ŋ̀gǎŋyəgə̂nnù ji mə, “Nòò yî mɔ̀ꞌɔ a zì mə nɨ̀ ka yǐ kɨ yə̀ꞌə̀tə a nyə Ǹjwi Mu Ŋù ya yì mɔ̀ꞌɔ kaa waꞌà yə̂. ");
INSERT INTO bfd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bə̀ ka yǐ tswe ghu mə bɨ ka yǐ tɨgə swoŋə a mbo bù mə, ‘Yə fiì!’ kə̀ ‘Yə faà!’ Lâ nɨ̀ tsuu waa yòŋə̀ mə nɨ̌ ghɛ̀ɛ a nyə̂. ");
INSERT INTO bfd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ǹloŋ mə tsǒ ajàŋ yìi mə mbə̌ŋ ŋwàꞌàkə̀ ŋ̀keꞌetə nɨ̂ m̀bɛ̀ɛ̀ àbùrè ŋ̀ghɛɛ mfɛ̀ꞌɛ̀ nɨ̂ m̀bɛ̀ɛ̀ yî mɔ̀ꞌɔ aa, à nɨ̂ àjàŋ yìi mə Mù Ŋù à ka yǐ bə wa Njwi yu aà. ");
INSERT INTO bfd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lâ à tswe nɨ̀ m̀fòo yə ŋgɨꞌɨ yì ŋ̀ghàꞌàtə̀, ta nɨ̀wàà nɨ bə̂ buà kɨ ntuu yi. ");
INSERT INTO bfd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tsǒ ajàŋ yìi mə a lɛ mbə a noò Noah, a nɨ̂ àjàŋ yìi mə a ka yǐ kɨɨ bə a noò Mu Ŋù aà. ");
INSERT INTO bfd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bə̀ lɛ sɨ jɨ, ǹno, ǹyɔꞌɔkə, m̀fakə nɨ̂ bɔɔ̀ byaa a nda nɨ̀yɔꞌɔ, ŋghɛɛ nyweꞌe wa njwi mə Noah à lɛ ŋkuu wa mûm àbaŋ, mbə̀ŋ yî ǹtɨ̀ɨ̀ ya ɨ tɨgə̀ ǹzi mbwɛsə waa bɨtsɨ̀mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A lɛ ŋkɨ mbə aa tsiꞌì maa ajàŋ wa noò Lot, bo lɛ sɨ jɨ, ǹno, ǹyuu, m̀fee, mbe nɨ mɨ̀jɨ, ŋ̀ghurə nɨ mɨ̀laꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lâ ǹjwi ya mə Lot à lɛ mfɛ̀ꞌɛ̀ a alaꞌa Sodom aa, mɔꞌɔ bo sulfur lɛ nlò a aburə nsɨgə ŋghɔꞌɔ waa bɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","À nɨ̂ àjàŋ mə a ka yǐ bə wa njwi mə Mu Ŋù à ka yǐ fɛ̀ꞌɛ yɛntə aà. ");
INSERT INTO bfd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“A yi mbə maa njwi, tâ ŋù yìi mə à tswe a atu nda, ǹjoò ji ɨ tswê a mûm ǹda aa, tâ tsuu lǒ bǔ sɨgə a nlɔ̀gə̂; tâ ŋù yìi mə à tswe a mûm ǹsòò aa, tâ à tsuu a ndùgə bǔ bɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nɨ̀ waꞌatə annù ya mə a lɛ ŋghɨ̀rə ŋgwɛ Lot laà. ");
INSERT INTO bfd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ŋù yìi mə a lɔ̀ɔ nyweensə̂ ǹtswêntɨ̀ɨ yì aa, à ka bwɛsə; ŋù yìi mə a bwesə ntswêntɨ̀ɨ̀ yì aa, à ka bàŋnə tswe nɨ yu. ");
INSERT INTO bfd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mə̀ swòŋə a mbo bù mə, à ka yǐ bə nɨ̂tugə maa lɛ tâ bə̀ bi baa nɔŋə a ɨkuu yî fùùrə̀, tâ bɨ̀ zi nlɔ̀gə̀ yî m̀fùùrə̀, m̀maꞌatə̀ yî mɔ̀ꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bàŋgyɛ̀ bi baa ka yǐ tswe kɨ ghɔ̀ꞌɔ abaa, tâ bɨ̀ zi nlɔ̀gə̀ yî m̀fùùrə̀ m̀maꞌatə̀ yî mɔ̀ꞌɔ̂.  ");
INSERT INTO bfd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","M̀bâŋnə̀ ji baa ɨ ka yǐ tswe a mûm ǹsòò tâ bɨ̀ zi nlɔ̀gə̀ yî mɔ̀ꞌɔ, mmàꞌàtə̀ yî mɔ̀ꞌɔ̂.” ");
INSERT INTO bfd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ŋ̀gǎŋyəgə̂nnù Yesu jya ɨ betə̀ yi mə, “Ma juù ɨ̀nnù ɨ ka yǐ fɛ̀ꞌɛ̀ aa fə, Mmàꞌàmbî?” Yesu a kwiꞌi mə, “Àdɨ̀gə̀ yìi mə àku ŋû a nɔŋ ghu aa, bɨ̀maghoo ghotə ghu.” ");
INSERT INTO bfd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu a naa nɨ̀ghàà a mbo ŋ̀gǎŋyəgə̂nnù ji a ndɨ̀ꞌɨ mə bo tswe nɨ̀ ŋ̀ka ntsàꞌàtə̀ Nwî ŋ̀gɔ̀ŋ bɨ̀nòò bɨtsɨ̀m tɨ kaà. ");
INSERT INTO bfd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ǹnaa nswoŋ a mbo bo mə, “M̀fɔ̀ kɔrə̀ yî mɔ̀ꞌɔ a alaꞌà àtoo yǐ mɔꞌɔ, kaa à lɛ ŋwaꞌà nìi Nwî bɔꞌɔ̀, kaa ŋkɨꞌɨ̀ nìi ɨkum a nu ŋù kɨɨ ntwoŋə. ");
INSERT INTO bfd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ŋ̀kwiꞌi màŋgyɛ̀ yî mɔ̀ꞌɔ à lɛ ŋkɨ ntswe maa alaꞌa, ǹzì ghu mbo nyə̀ꞌə̀ ǹswoŋə nɨ mə, ‘Kwɛrə atû ya a mbo ŋ̀gàŋkɨbàâ jyâ.’ ");
INSERT INTO bfd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kaa m̀fɔ̀ kɔrə̀ wa a waꞌà yuꞌutə̀. Atɨɨ noò yî mɔꞌɔ a tsyà mə̂, màŋgyɛ̀ wa a kɨɨ̀ ǹzi tsiꞌì zì, a swoŋ mə, ‘Ka mə kaa mə̀ sɨ naa Nwì bɔꞌɔ kaa kɨꞌɨ̀ nɨ̀ ɨ̀kùm a nu ŋù twoŋə̀ aa, ");
INSERT INTO bfd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mə̀ ka kwɛtə mâŋgyɛ̀ ghû ǹloŋ mə a fa ŋgɨꞌɨ a mbo mə̀ aà, mə̀ bə tsuu kwɛtə boŋ à ka kɨ dɨꞌɨ nàâ tâ mə̀ waꞌà kwàŋə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","M̀màꞌàmbi a swoŋ mə, “Nɨ̀ yuꞌu ànnù yìi mə m̀fɔ̀ kɔrə̀ tɨ̀ bɔꞌɔ̀ Nwî ma ghû à swòŋə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","M̀bə Nwì a tɨgə̀ ŋ̀aꞌǎ bə̂ bi bìi mə bɨ yə̀ꞌə̀ a mbo yu nɨtugə nɨ̀ àsìꞌìnə̀ kwɛtə̀ aa mə akə aa ɛ? M̀bə a swuŋ nû yì a ŋkwɛtə bo aa mə akə lɛ? ");
INSERT INTO bfd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mə̀ swòŋə a mbo bù mə à ka wàŋsə kwɛtə waa. Lâ, nòò yìi Mu Ŋù à ka yǐ zì aa, à ka yǐ yə abìintɨɨ fàa nsyɛ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu a naa nɨ̀ghàà nî nǎnaa a mbo bə̀ bìi mə bɨ kwɛ̀ɛ̀ nɨ̂ ǹtɨɨ̀ waa, nswoŋə nɨ mə à nɨ bo bìi mə bo bɔŋ ntsyà bî mɔꞌɔ aa, nswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bə̀ bî mɔꞌɔ bi baa bɨ lɛ ŋghɛ̀ɛ̀ a ndâmàꞌanwì a ntsàꞌàtə Nwì ghu, yì mɔ̀ꞌɔ a bə ŋù baFarɨsai, yì mɔ̀ꞌɔ a bə ŋgàŋkwɛrə tax. ");
INSERT INTO bfd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bɨ ghɛ̀ɛ̀ mə̂, ŋù baFarɨsai wa, a naŋsə nlɔɔ adɨgə yi ntəə ghu, ntsaꞌatə Nwî ǹswoŋ mə, ‘Nwì, mə̀ fâ m̀bɨꞌɨkə a mbo wò mə kaa mə̀ sɨ̀ gha tsiꞌì tsǒ bə̀ bî mɔꞌɔ bì bə̂, bìi mə bo twɛɛ nɨ̂ ǹjoo bə̀ ŋ̀kwɛrə, m̀bə ŋgǎŋntswɛɛ̀ ɨ̀baŋnənnù, ŋ̀kɨ mbə ŋgàŋəjɨrə̀ aà, kə̀ tsiꞌì tsǒ ŋgàŋkwɛrə tax wi mə à təə filì aà. ");
INSERT INTO bfd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mə siꞌisə ɨbɨɨnû gha tɨ̀ jɨ̂ a njwi ji baa a atû ŋ̀gyà. Ǹyatə nɨ̂ ǹjoò ja ɨ̀tɨɨ ji nɨghum, m̀fa nɨ̂ yì fùùrə̀ a mbo Nwì.’ ");
INSERT INTO bfd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ŋ̀gàŋkwɛrə tax wa a burə̀ ŋ̀ghɛntə yi àghaꞌa a saꞌà, a təə ghu, kaa ntɛꞌɛ waꞌà miꞌì mi a ndəŋ ŋŋɛntə̀, ǹnɔŋsə abô yi a ntsù mɨbɛ̌ yu, ǹswoŋ mə, ‘Nwìŋgɔ̀ŋ, ko mɨlɨ̀ŋnə̀ ghà ŋ̀gàŋghɨ̀rə ɨnnù jî bɨ̂.’ ");
INSERT INTO bfd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mə̀ swǒŋ a mbo bù mə, Nwì à lɛ mbàŋnə̀ ǹlɔgə aa ma ghuù ŋû nɨ ŋù yìi mɨ̀nnû mi tsinə aa ntsyatə yî m̀bìì wâ. Ǹloŋ mə ŋù yìi mə a ŋɛɛ ɨbɨɨnû yi a ndə̀ŋ aa, bɨ sɨgɨsə yi a nsyɛ̂. Ŋù yìi a bàŋnə̀ sɨgɨsə ɨbɨ̀ɨnû yì a nsyɛ aa, bɨ ŋɛntə nìi a ndəŋə.” ");
INSERT INTO bfd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bə̀ bi mɔꞌɔ lɛ nzì nɨ bôŋkhə mə tâ à nɔŋsə mbô mi a atu bo, lâ ŋ̀gǎŋyəgə̂nnù ji ɨ yə ŋwenə waa. ");
INSERT INTO bfd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lâ Yesu a bâŋnə̀ twoŋə waa mə tâ bɨ̀ zi nɨ bɔɔ bya a mbo yu, ǹswoŋ mə, “Nɨ̀ maꞌatə bɔɔ bya tâ bɨ̀ zi a mbo mə̀, ǹtsuu waa kɨ kɨ̀ŋə̀ bə̂; ǹloŋ mə annù nɨfɔ̀ Nwî a tswe aa a mbo bə̀ tsǒ bo. ");
INSERT INTO bfd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋ mə, ŋù yìi mə à sɨ annù nɨfɔ̀ Nwî tsiꞌì tsǒ mûŋkə̂ kwɛrə aa, kaa à ka yǐ waꞌà ghu kuù.” ");
INSERT INTO bfd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ǹtsyàsə̀ baYuda yî mɔ̀ꞌɔ a betə̀ Yesu mə, “Ǹdɨ̀ꞌɨ̀nnù yî sɨgɨ̀nə̀, mbə mə̀ ghɨrə̀ mə akə yǐ njɨ ɨlòŋ yìi ɨ lwiꞌi nɨ̂ŋkoŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu a betə ghu mbo mə, “Ò twòŋə gha nɨ ŋù yî sɨgɨ̀nə̀ aa a ya aa ɛ? Kaa ŋù yî sɨgɨ̀nə̀ à sɨ̀ ghu tswê, ǹtsyatə Nwî yuyu. ");
INSERT INTO bfd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ò zî ǹdɨꞌɨ Nwî jyâ, mə, ‘Tsee annǔ mâghàbə̀ kɨ ghɨ̀rə̀. Tsee yə̀rə̀. Tsee ŋû zwitə. Tsee abǎŋnənnù tswɛɛ. Ka nyuꞌunə taà ghò bo ǹdè ghò.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A swoŋ a mbo Yesu mə, “Mə̀ lə̀ə̀ mə ndɨꞌɨ mà jû tsiꞌì tsɨ̀m, ǹlɔgɨnə a noò yìi mə̀ lɛ mburə mûŋkhə aà.” ");
INSERT INTO bfd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu à yùꞌù mə̂ maa ajàŋ aa, ntɨgə nswoŋ ghu mbo mə, “Ànnù yî fùùrə̀ a boŋə a mbo wò. Fèe njoò tsɨ̀m jìi ò tswe nɨ ju aa, nyatə ŋkabə ya a mbo ŋgàŋə̂fum, boŋ ò ka tɨgə tswe nɨ̂ àfùꞌù a aburə. Ǹzi ŋka nyòŋə̀ nàâ.” ");
INSERT INTO bfd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","À yùꞌù mə laà, nû yì naŋsə mbɨꞌɨ nloŋ mə à lɛ naŋsə mbə ŋ̀gàŋkabə yì ŋ̀wè aà. ");
INSERT INTO bfd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu a liì yi nswoŋ mə, “A tsyanə a mbo ŋgàŋkabə a ŋkuu a mûm ànnù nɨfɔ̀ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A fwaatə a mbo kamɛl a ntsurə a nɨliꞌi nɨ nsaꞌa, ntsyatə a mbo ŋgàŋkabə a ŋkuu a mum ànnù nɨfɔ̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bə̀ bìi bɨ lɛ nyuꞌu ma yû ànnù aa, bɨ lɛ ntɨgə mbetə nɨ mə, “Ŋù yìi mbə a yweenə̀ aa a tɨgə̀ m̀bə wo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A swoŋ a mbo bo mə, “Ànnù yìi mə a tsyanə a mbo bə̀ aa, kaa a sɨ̀ a mbo Nwì tsyânə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peta a swoŋ mə, “Tɨgə ò yə mə bìꞌì maꞌatə̂ ǹdùgə̂ jiꞌi ntɨgə nyoŋə nòo?” ");
INSERT INTO bfd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A kwiꞌi a mbo bo mə, “Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂koŋ mə, ŋù ǹtsɨ̀m yìi mə à màꞌàtə ndâ yì, nɨ̂ ŋ̀gwɛ̂ yì, nɨ bɔɔ bɨ maà bi, nɨ taà yì, nɨ̂ ǹdè yì, nɨ bɔɔ̀ bi, nloŋ annù nɨfɔ̀ Nwî aa, ");
INSERT INTO bfd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","à ka yǐ bǔ kwɛrə njoo mà jû tâ ɨ̀ kɔꞌɔ ntsya ndùù yìi mə à màꞌàtə aa, ɨ kɨɨ bǔ tswe nɨ̂ ǹtswêntɨ̀ɨ̀ yìi ɨ̀ lwìꞌi nɨ̂ŋkoŋ aa a noò ǹjɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu à lɛ nswùŋtə ŋgǎyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa, bo bo ghɛ̂ntə̀ a swoŋ a mbo bo mə, “Yə̂ nɨ̀, àjàŋə mə bìꞌinə̀ kɔꞌɔ ŋghɛɛ a Yerusalem laà aa, ŋ̀gɔ̀ŋ ɨ̀nnǔ tsɨ̀m jìi mə ŋgǎŋntoo Nwì ɨ lɛ ŋŋwàꞌànə̀ ǹloŋə Mu Ŋù aa ɨ ka fɛ̀ꞌɛ bòòntə̀. ");
INSERT INTO bfd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ǹloŋ mə bɨ ka tswa yi ɨ fa a mbo bɨ̀tɨ̀zi Nwî tâ bɨ̀ tɨgə ŋwyɛ nìi, ǹnɨŋə nɨ̂ àdɨ̀rə atu ghu atu, ntutə nɨ mɨ̀twyɛ ghu nû. ");
INSERT INTO bfd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bɨ ka ghɔ̀ɔ̀ yi, ɨ zwitə yi, lâ a tɨ bə nɨ̂ ǹjwi ji tarə a bû m̀bɨɨnə a nɨwô.” ");
INSERT INTO bfd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kaa ŋgǎŋyəgə̂nnù ji lɛ ŋwaꞌǎ annù ya yì tsu yìi mə à lɛ nswoŋ aa yuꞌù. Bɨ lɛ nlɔ̀ꞌɔ̀sə njiꞌì mɨ̀ghàà ma mû a mbo bo. Kaa bo waꞌà waa annù yìi mə à lɛ sɨ ghàà aa burə̀ ǹzi zi. ");
INSERT INTO bfd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu à lɛ nzì ŋ̀ka ŋkuꞌu a Yeriko, m̀fə̀ꞌə̀nə̀ yî mɔ̀ꞌɔ a tswê a mbɛ̀ɛ̀ mânjì, ǹlɔɔ nɨ̂ ǹjoò. ");
INSERT INTO bfd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","À yùꞌù mə̂ àkùrə̀ bə̂ a kâ ǹjuꞌu ǹtsyà aa, a betə̀ mə, “Àa ghɨ̀rə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bɨ swoŋ ghu mbo mə, “Yesu mu Nazareth a tsyǎ.” ");
INSERT INTO bfd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A tɔŋnə̀ nswoŋ mə, “Yesu, mu David, ko mɨlɨ̀ŋnə̀ ghà!” ");
INSERT INTO bfd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bə̀ bìi mə bɨ lɛ ntəəntə ghu mbìì aa, bɨ wenə̀ yi nswoŋ mə tâ à kutə ntsù yi. Lâ a kuꞌùsə̀ ŋ̀ghɛɛ bə nɨ̀ m̀bìì ǹtɔŋnə nswoŋ mə, “Mu David, ko mɨlɨ̀ŋnə̀ ghà!” ");
INSERT INTO bfd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu a tɨgə̀ ǹtəə nswoŋ mə tâ bɨ̀ zi nɨ̂ m̀fə̀ꞌə̀nə̀ wâ. Bɨ zî nɨ ghu, Yesu a betə̀ yi mə, ");
INSERT INTO bfd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O lɔ̀ɔ̀ mə mə̀ ghɨrə aa àkə̀ a mbo wò aa ɛ?” A kwiꞌi mə, “M̀màꞌàmbî, mə lɔ̀ɔ mbǔ ŋka nyə ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu a swoŋ ghu mbo mə, “Ka nyə ɨdɨgə! Wâ àbìintɨɨ̀ yo a ghɨ̀rə̀ mə̂ ò tɨɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A kɨ̂ ǹlɔgɨnə ŋka nyə ɨdɨgə, ǹtɨgə nyoŋə nìi, ŋghaꞌasə nɨ̂ Nwî. Bə̀ bɨ̀tsɨ̀m bìi bɨ lɛ nyə yi aa bɨ ghaꞌasə̀ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu à lɛ ŋkuu ŋka ntsya a mûm àlaꞌa Yeriko, ");
INSERT INTO bfd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ǹdɨ̀ɨ̂ ŋ̀gǎŋkwɛrə bɨ̀taksì yî mɔ̀ꞌɔ à lɛ ntswe ghu, ɨ̀kǔm yì a bə Zacchaeus, a bə̂ ŋ̀gàŋkabə̀. ");
INSERT INTO bfd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","À lɛ ŋka nlɔɔ a nyə ŋù yìi mə Yesu à nɨ ghu aà, la kaa waꞌà yə̂, ǹloŋ mə à lɛ mbə ŋû yî ŋ̀ghùꞌù ŋghuꞌu, ǹtswe a tɨtɨ̀ɨ nnɔ̀ɔ̀ bə̂ ɨ kɨŋə̀ nìi aà. ");
INSERT INTO bfd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","À lɛ ntsyà ǹtɨgə ŋkhə ŋghɛ̀ɛ̀ nɨ̂ m̀bìì, ŋ̀ghɛɛ ŋkɔꞌɔ a atu ati sycamore tǎ yə Yesu ǹloŋ mə à lɛ ntswe nɨ̂ tsyǎ aa maa mbɛ̀ɛ̀ àdɨ̀gə̀. ");
INSERT INTO bfd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu à zì mə̂ ǹyweꞌe maa adɨgə, ǹlentə̂ ǹdəŋ nswoŋ a mbo Zacchaeus mə, “Zacchaeus, wàŋsə nsɨgə a nsyɛ̂ ǹloŋ mə mə̀ ka lɛ a nda wò siì.” ");
INSERT INTO bfd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus a tɨgə nlo wa atu ati waŋsə sɨgə, ŋkwɛrə Yesu nɨ nɨ̀dorə̀. ");
INSERT INTO bfd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bə̀ bya bɨ̀tsɨ̀m bɨ yə̀ mə̂, ǹlɔgɨnə ŋka nwurəkə mə, “À ghɛ̀ɛ ŋkuu a nda ŋù ŋghɨ̀rə̂ ɨ̀nnù jì bɨ̂ a ghantə yu!” ");
INSERT INTO bfd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchaeus à lɛ ntɨgə mbɨɨnə ntəə a ndəŋ nswoŋ a mbô M̀màꞌàmbi mə, “Yə mbǎ Mmàꞌàmbi, mə̀ ka yàtə njoò ja ɨ fa atɨɨ yì fùùrə̀ a mbô ŋ̀gàŋə̂fum; bɛɛ a bə mə mə̀ lɛ njɨtə ŋkòbə̀ a nu ŋù tsù ŋ̀kwɛrə ayoò yi boŋ mə̀ ka bènsə̀ fu ŋgaa ji nɨkwà.” ");
INSERT INTO bfd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu a tɨgə̀ ǹswoŋ ghu mbo mə, “Bə̀ bɨ nda buà bɨ ywèènə̀ mə̂ ǹloŋ mə ŋû ghû à kɨ mbə mu Abraham. ");
INSERT INTO bfd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ǹloŋ mə Mu Ŋù à lɛ nzì aa a nlɔ̀ɔ bə̀ bìi mə bɨ lɛ mbwɛ aa ɨ yweensə waa.” ");
INSERT INTO bfd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Àjàŋ mə bə̀ bya bɨ lɛ sɨ yuꞌutə ɨnnù ma juà aa, a tɨgə̀ ǹnaa nɨghàà nî nǎnaa a mbo bo, ǹloŋ mə à lɛ tɨ bə aa boŋ à ghɛ̀ɛ̀ mə̂ ǹtɨgə ŋkuu a Yerusalem, bə̀ kɨɨ̀ m̀mɔɔntə nɨ mə ànnù nɨfɔ̀ Nwî ya a ka burə zì tsiꞌì maa noò. ");
INSERT INTO bfd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","À lɛ nswoŋ mə, “Mûntɔꞌɔ yì mɔ̀ꞌɔ à lɛ ntswe nɨ̂ ŋ̀ghɛ̀ɛ a alaꞌa yǐ mɔꞌɔ tâ bɨ̀ yɔꞌɔ yi nɨ̂ m̀fɔ̀ tâ à bɔŋ mbǔ bɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","M̀bɔŋ tâ à fɛꞌɛ, a lɛ ntwoŋ ŋgǎŋfàꞌâ ji ji nɨghum, m̀fa abàꞌatə ŋkabə gold a bo yì mɔ̀ꞌɔ yî mɔ̀ꞌɔ̂, ǹswoŋ a mbo bo mə, ‘Nɨ̀ ghɛɛ ŋka ntaŋə mɨtaa nɨ ju nyweꞌe a njwi yìi mə̀ ka bǔ bɨ̀ɨ̀ aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lâ ŋ̀gàŋalaꞌà ji jya ɨ lɛ sɨ bàà yi. À fɛ̀ꞌɛ̀ mə̂ ŋ̀ghɛɛ, bo tɨgə̀ ǹtoo bə̂ mə bɨ̀ yôŋə yi nswoŋ mə, ‘Kaa bìꞌì sɨ kɔ̀ŋə̀ mə tâ m̀bâ ghû à bə mfɔ̀ yìꞌì.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bɨ lɛ nyɔꞌɔ mbâ wa a nɨ̂ m̀fɔ̀, a bû m̀bɨ̀ɨ̀ fu. À bɨ̀ɨ̀ mə̂ aa ntɨgə nswoŋ bɨ ntwoŋ ŋ̀gǎŋfàꞌâ ji jya mə à lɛ mfa ŋkabə ya a mbo bo aa a nzî ǹjɨ̀m mɨ̀tàà yìi mə bɨ lɛ ntaŋ mɨtaa ntswe nɨ yu aà. ");
INSERT INTO bfd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yì ǹtsyàmbìì a zî ǹswoŋ ghu mbo mə, ‘Taà, mə̀ tàŋ mə̂ mɨtaa nɨ̂ ŋ̀kabə ya àbìì a yôŋ m̀bə ɨbaꞌatə ŋkabə ji nɨghumə̀.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A swoŋ ghu mbo mə, ‘Wa ò ghɨ̀rə sɨgɨ̀nə̀ mbâ ŋ̀gàŋàfàꞌà yî ǹsɨgɨ̀nə̀! Tsǒ mə ò fàꞌa nɨ̀ ǹtɨɨ̀ ghô tsɨ̀m nɨ mûntsìrə̂ ŋ̀kabə aa, mə̀ ka ghɨ̀rə tâ ò tɨgə nsaꞌa njɔ̀ꞌɔ̌ alaꞌa ji nɨghumə̀.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ŋ̀gàŋàfàꞌà wa yìi à ywèꞌe bɨ baa aa a zî ǹswoŋ mə, ‘Taà, mə̀ tàŋ mə̂ mɨtaa nɨ̂ ŋ̀kabə̀ yò ya àbìì a yôŋ m̀bə ɨbaꞌatə ŋkabə ji ntaà.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A swoŋ ghu mbo mə, ‘Ò ka tswe a atu ǹjɔ̀ꞌɔ̌ alaꞌa ji ntaà.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ŋ̀gàŋàfàꞌà yìi à ywèꞌe bi tarə aa a zî ǹswoŋ mə, ‘Taà, ŋ̀kabə̀ yò ya ɨ̀ yuà, mə̀ lɛ ŋkwerə a mûm àsàꞌa atsə̀ꞌə̀ ŋ̀ghɛɛ naŋsə nləə; ");
INSERT INTO bfd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","mə̀ lɛ sɨ bɔꞌɔ nɨ̂ gho nloŋ mə ò nɨ ŋù yìi mə o tsəꞌə siꞌi; ǹlɔgə nɨ̂ ǹjoo jìi kaa ò lɛ ŋwaꞌà lə̀ə̀ aa, ŋkɨɨ mfuꞌu nɨ mɨ̀jɨ mìi kaa ò lɛ ŋwaꞌà bè aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A swoŋ ghu mbo mə, ‘Mə̀ ka lɔ̀gə̀ aa tsiꞌì nɨ̀ghàà nìi nɨ fɛꞌɛ a ntsǔ wò aa, ɨ saꞌa gho ghu mba abùꞌù yî bɨ̂! Ò lɛ nzi mə mə tsəꞌə, ǹlɔgə nɨ̂ ǹjoo a adɨgə yìi mə mə̀ lɛ ŋwaꞌà ghu lə̀ə̀, ŋkɨɨ mfuꞌu nɨ mɨ̀jɨ a adɨgə yìi mə mə̀ lɛ ŋwaꞌà ghu bê aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ò lɛɛ̀ ŋ̀ghɛɛ ntɨgə waꞌǎ ŋkabə̀ yà ya a bank ghɛɛ̀ ǹləə, mə mə̀ tɨ bɨ̀ɨ mə̀ kwɛrə̀ ŋ̀kabə̀ ya bo bɨ̀ ǹjɨ̀m yì aa a ya ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","A tɨgə̀ ǹswoŋ a mbo bə̀ bya mə bɨ lɛ ntəə wa adɨgə aa mə, ‘Kwɛrə ŋkabə ya ghu mbo mfa a mbo ŋù wa yìi à tswe nɨ ɨ̀bàꞌatə ŋkabə jya ji nɨghum aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","(Bo swoŋ ghu mbo mə, ‘Taà, wa à tswe nɨ̀ ɨ̀bàꞌatə ŋkabə ji nɨghumə̀!’) ");
INSERT INTO bfd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Mə̀ swòŋə a mbo bù mə, ŋù yìi mə à tswe nɨ̂ ǹjoo aa, bɨ ka kùꞌùsə̀; lâ ŋù yì mə à sɨ̀ nɨ̂ ǹjoo tswe aa, bɨ ka màŋsə kwɛrə, ɨ kwɛrə mûtsirə̂ yìi mə à tswe nɨ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A ŋghɛ̀ɛ nɨ ŋ̀gàŋkɨ̂bàâ ja jù, jìi mə bo lɛ sɨ lɔ̀ɔ̀ mə mə̀ tsuu mfɔ̀ wàà bə aa, nɨ̀ lɔgə waa nzi nɨ bo, nzwitə a nsi mə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu à swòŋ mə̂ laà ǹtsya mbìì ǹtɨgə ŋkɔꞌɔ ŋghɛɛ a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","À ghɛ̀ɛ̀ mə̂ ŋ̀ka nyweꞌe a mbɛ̀ɛ Betfage bo Bethany, wa atu ntaꞌa mə bɨ lɛ sɨ twoŋə nɨ Olive aa, ntoo ŋgǎŋyəgə̂nnù ji ji baa, ");
INSERT INTO bfd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ǹswoŋ mə, “Nɨ̀ ghɛɛ fìi nɨ mû àlaꞌa mə a tswe a mbìì bù aa, nɨ̀ bə ghɛ̀ɛ kɨ kuu bo nɨ̀ ka yə mu jàkasì tâ bɨ̀ tɨŋnə, tâ à bə yìi kaa ŋù à lɛɛ̀ ŋ̀waꞌà ghu atu kɔꞌɔ aà; nɨ̀ yə, nɨ̀ fɛɛ̀ ǹzi nɨ ghu faà. ");
INSERT INTO bfd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bɛɛ ŋù tsù a betə ghuu mə, ‘Nɨ fɛ̀ɛ mu jakàsì ghuà aa a ya aa ɛ?’ nɨ̀ swoŋ mə, ‘A lɔ̀ɔ Mmàꞌàmbi.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bo bya bìi mə à lɛ ntoo aa bɨ lɛ ŋghɛ̀ɛ̀ ɨ̀nnù kɨ̂ m̀fɛꞌɛ tsiꞌì wa ajàŋ mə à lɛ nswoŋ a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bo ghɛ̀ɛ̀ mə̂ ŋ̀ka mfɛɛ mu jàkâsì wa, m̀bɔ̂ŋ yì a zî m̀betə waa mə, “Nɨ fɛ̀ɛ mu jàkâsì ghû aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bo swoŋ mə, “M̀màꞌàmbi a lɔ̀ɔ̀.” ");
INSERT INTO bfd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bo lɛ nlɔ̀gə̀ ǹzi nɨ ghu a mbo Yesu, ǹnɔŋsə ɨtsə̀ꞌə̂ jyaa wa njɨ̌m mu jàkâsì, ŋ̀ghɨrə Yesu a kɔꞌɔ ntswe ghu. ");
INSERT INTO bfd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","À kà mə̂ aa ŋghɛɛ bo tɨgə̀ ǹsaŋtə ɨtsə̀ꞌə̂ jyaa wa mânjì. ");
INSERT INTO bfd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","À ghɛ̀ɛ̀ mə̂ ŋ̀ka nyweꞌe a ajàŋ yìi mə à ka tɨgə sɨgə ntaꞌa Olive aa, nnɔ̀ɔ ŋgǎŋyəgə̂nnù ji jya tsɨ̀m ɨ lɔgɨ̀nə̀ ŋ̀ka ndorɨtə, ntɔŋnə ŋghaꞌasə nɨ̂ Nwî ǹloŋ ɨ̀nnù jî wè jî wè jìi à lɛ ŋghɨ̀rə̀ bo yə aà, ");
INSERT INTO bfd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ǹswoŋə nɨ mə, “Bìꞌinə̀ ghaꞌasə Mfɔ̀ yìi mə a zì nɨ̂ ɨ̀kǔm M̀màꞌàmbî aà! M̀bɔɔnə a aburə, tâ nɨ̀ghaꞌa tswe a mbo Nwì!” ");
INSERT INTO bfd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","BaFarɨsai bî mɔꞌɔ bìi mə bɨ lɛ ntswe wa atɨtɨ̀ɨ nnɔ̀ɔ̀ bə̂ aa swoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨnnù, wenə ŋgǎŋyəgə̂nnù jo jù.” ");
INSERT INTO bfd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A kwiꞌi mə, “Mə̀ swòŋ a mbo bù mə, ‘À lɛ mbaa bə yìi mə bo ma bû kutə mɨ̀ntsû myaa bəə boŋ tsiꞌì ŋ̀gɔ̀ꞌɔ̀ jû ka bàŋnə tɨgə tɔŋnə ŋghaꞌasə nɨ̂ Nwî.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","À zì mə̂ ŋka ŋkoontə, nyə mûm àlaꞌa ya, nyəꞌə nloŋə atu alaꞌa ya, ");
INSERT INTO bfd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ǹswoŋ mə, “Ò lɛ mbaa ghəə̀ zî, sii, ayoo yìi mə a zì nɨ̂ m̀bɔɔnə aà! La tsɨtsɔ̀ŋ a ləəntə a nsi miꞌi wò! ");
INSERT INTO bfd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nòò a zǐ mə ŋgàŋkɨbàâ jo ka yǐ jìꞌi ŋkya ɨ karɨsə gho ghu, ɨ kɨ̀ŋə̀ gho ghu a mbɛ̀ɛ̀ tsɨ̀m ");
INSERT INTO bfd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ɨ zwitə ghuu bu bɨ̀ bɔɔ buu, kaa waꞌǎ ŋgɔ̀ꞌɔ̀ yî tsù bû m̀maꞌatə tâ ɨ̀ nɔŋə a atu yì mɔ̀ꞌɔ̂; ǹloŋ mə kaa ò lɛ nyə noò wa yìi mə Nwì à lɛ nzì a nyweensə wò ghu aa, kaa waꞌà zi aà!” ");
INSERT INTO bfd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","À lɛ ntɨgə ŋghɛɛ ŋkuu a ndâmàꞌanwì ǹlɔgɨnə ŋka mfurə bə̂ bìi bɨ lɛ sɨ fèe njoo ghu aa, ");
INSERT INTO bfd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ǹswoŋə nɨ mə, “Bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ mə, ‘Ǹdâ yà ɨ̀ ka yǐ bə aa àdɨ̀gə ntsàꞌàtə Nwì’; lâ nɨ̀ ghɨ̀rə̀ mə̂ ɨ tɨgə̀ m̀bə adɨgə nlə̀ə̀ntə bɨ̀yərə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","À lɛ sɨ tɨgə ndɨꞌɨ nɨ̂ ànnù Nwî wa mûm ǹdâmàꞌanwì a njwî tsɨ̀mə̀. Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀, nɨ bɨ̀tsyàsə̀, bɨ lɛ ŋka nlɔɔ yi mə bɨ zwitə, ");
INSERT INTO bfd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","lâ kaa waꞌà mânjì yə nloŋ mə bə̀ bì ghàꞌàtə̀ lɛ sɨ yòŋə̀ ǹlɔɔ nɨ̂ ǹyùꞌû ɨ̀nnù jìi mə à lɛ sɨ swoŋə aà. ");
INSERT INTO bfd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A bə njwi yì mɔ̀ꞌɔ Yesu a kuu a ndâmàꞌanwì, ŋ̀ka ndɨꞌɨ nɨ̂ ànnù ghu a mbo bə̀, ŋ̀kɨɨ nsɛɛnsə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀, bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə bo bɨ̀ bɨ̀tà bɨ alaꞌa bɨ zì m̀betə yi mə, ");
INSERT INTO bfd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Naŋsə nswoŋ a mbo bìꞌì, O ghɨ̀rə ɨnnù juà jìi mə o ghɨ̀rə̀ aa nɨ̂ àdàꞌa wo ɛ? A adaꞌa ma yû a mbo wò aa, a fâ wò ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A kwiꞌi a mbo bo mə, “Mə̀ ka kɨɨ betə ghuu nɨ̂ àbetə̀: Swoŋə nɨ̀ ghâ, ");
INSERT INTO bfd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jɔn à lɛ nlɔ̀gə adaꞌa aa fə a ŋka mmurə bə̌ ŋkì aa ɛ? A lɛ nlò aa mbo Nwì kə̀ a mbo bə̀ aa ɛ? Nɨ̀ kwiꞌi tâ mə̀ yuꞌu.” ");
INSERT INTO bfd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bo ghaànə̀ a tɨtɨ̀ɨ bo nswoŋ mə, “M̀bə bìꞌinə̀ kwiꞌi mə a lɛ nlò aa a mbo Nwì boŋ à ka betə yiꞌinə̀ mə, ‘Nɨ̀ lɛɛ̀ ǹtɨgə waꞌǎ annù yìi mə à lɛ sɨ swoŋə bii aa a ya aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Lâ m̀bə bìꞌinə̀ swoŋ mə a lɛ nlò aa a mbo bə̀ boŋ bə̀ bû bɨtsɨ̀m ka tumntə yiꞌinə̀ nɨ̂ ŋ̀gɔ̀ꞌɔ̀, ǹloŋ mə bo naŋsə mbii mə Jɔn à laa mbə ŋgàŋntoò Nwì.” ");
INSERT INTO bfd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Maa ajàŋ bo tɨgə̀ ŋ̀kwiꞌi mə kaa bo lɛ ŋwaꞌǎ adɨgə yìi mə a lɛ nlò ghu aa zî. ");
INSERT INTO bfd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu a tɨgə̀ ǹswoŋ a mbo bo mə, “Kaa mə̀ ka waꞌà ŋû yìi mə̂ à fa adaꞌa mə̀ ghɨrə̀ nɨ̂ ɨ̀nnù jû ghu aa a mbo bù kɨ nswoŋə.” ");
INSERT INTO bfd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu a naa nɨ̀ghàà nî nǎnaa a mbo bo mə, “Ŋù yì mɔ̀ꞌɔ à lɛ mbě akò mɨlùꞌû yi, nlɛsə a mbo bə̀, m̀fɛꞌɛ ŋghɛ̀ɛ̀ ǹtswe a atoo dàŋ àghaꞌa a saꞌà ");
INSERT INTO bfd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","nòò ŋ̀kyǎ mɨ̀ntà mɨ ati mɨlùꞌù mya à kùꞌù mə̂, a too ŋ̀gàŋàfàꞌâ yì mə à ghɛɛ ŋkwɛrə mɨ̂ntà mɨ ati mɨlùꞌù mya mǐ mɔꞌɔ a mbo bɨ̀lɛnsə bɨ akò byâ, lâ bɨ̀lɛnsə bɨ akò bya bɨ tswâ yi ŋghɔɔ, ntsyàsə̀ yi a bɨɨ̀ tsiꞌì m̀bô m̀bô. ");
INSERT INTO bfd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A bû ǹtoo ŋgàŋàfàꞌà wa yì mɔ̀ꞌɔ, bɨ kɨ̂ ŋ̀ghɔɔ yi, nnɨŋ ndɨ̀rə̂ àtu ghu atu, ntsyasə yi a bɨɨ̀ tsiꞌì m̀bô m̀bô. ");
INSERT INTO bfd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A kuꞌùsə̀ mbo ntoo ŋgàŋàfàꞌà yìi mə à yweꞌe ji tarə̀, bɨ tswâ ma ghû ǹnɨŋ ɨlaꞌa ghu nu mmaꞌa yi a abɛɛ. ");
INSERT INTO bfd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Mbɔ̂ŋ àkò wa a swoŋ mə, ‘Mə̀ ka ghɨ̀rə̀ aa mə akə tsɨ̂tsɔ̀ŋ aa ɛ? Mə̀ ka too mû ghà yî m̀bâŋnə̀ ghû mə mə̀ nàŋsə ŋkɔ̀ŋ aà, nòò tsù bɨ yə̂ yi mbɔꞌɔtə.’ ");
INSERT INTO bfd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lâ bɨ̀lɛnsə bɨ akò bya bɨ yə̀ mə̂ yi, ǹswoŋ bo nɨ bo mə, ‘Àâ ǹjɨ̂nda yì à ghûlà, bìꞌinə̀ zwitə yi tâ ǹjoo jù ɨ̀ tɨgə mbə jìꞌinə̀.’ ");
INSERT INTO bfd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bo lɛ ntɨgə ntswa yi, mmaꞌa a abɛɛ wa njɨ̀m ŋ̀kya mɨlùꞌù ǹzwitə yi. Ma mùu ajàŋ nɨ̀ mɔ̀ɔ̀ntə mə m̀bɔŋə̀ àkò mɨlùꞌù wa à ka ghɨ̀rə mə akə a nu bo aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","À ka zǐ zwitə bɨ̂lɛnsə bɨ akò ma bya, ɨ lɛnsə akò yi ya a mbo badàŋ.” Àjàŋ mə bə̀ bya lɛ nyuꞌu ma mùu ajàŋ aa, ntɨgə nswoŋ mə, “Kaa mbə Nwìŋgɔ̀ŋ a waꞌà biì.” ");
INSERT INTO bfd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu a lêntə̀ waa mbetə mə, “Nɨ̀ghàà nɨ Nwî nulà nɨ tɨgə̀ ǹswoŋ aa mə akə aa ɛ? ‘Tsiꞌì ŋ̀gɔ̀ꞌɔ̀ ya mə bɨ̀bɔɔ bɨ nda bɨ lɛ ntuu aa, ɨ̀ bə̀ŋ mə̂ ǹtɨgə ŋgɔ̀ꞌɔ̀ nɨ̀buu nɨ nda yì ŋ̀wè.’ ");
INSERT INTO bfd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ŋù ǹtsɨ̀m yìi mə à wo a nɨ̂ ŋ̀gɔ̀ꞌɔ̀ ma ya aa, à ka bəgɨkə; lâ bɛɛ mə ɨ wo a nu ŋù bəə boŋ ɨ̀ ka ghɔ̀ꞌɔ̀ yi.” ");
INSERT INTO bfd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ŋ̀gǎŋndɨ̀ꞌɨ Nɔ̀ŋsə̀ nɨ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì ghə̀ə ɨ tswa yi maà noò, lâ m̀baŋnə mbɔꞌɔ miꞌi mɨ bə̂ byâ. Bo lɛ nzi mə à lɛ nnaa nɨghàà nya aa nloŋ ŋgaà yàà. ");
INSERT INTO bfd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bo tɨgə̀ ǹlɔɔ nɨ̂ àbwarə, ǹtɨgə nlɔɔ bɨ̂tswɛ̀rə̀, ǹtoo ghu njɨ̀m mə bɨ̀ zi ŋka mbagɨ̀lə mbetə nìi nɨ mɨ̀ghàà tâ tsyà ghu ɨ tswa yi ɨ fa a mbo Gûmnàà yìi à lɛ ntswe nɨ̂ àdàꞌà a atu bo aa tâ à saꞌa yi. ");
INSERT INTO bfd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bɨ tɨgə̀ ǹzi mbetə yi mə, “Ǹdɨ̀ꞌɨ̀nnù, bìꞌì zi mə annù yìi o ghàà ŋ̀kɨɨ ndɨꞌɨ aa a kuꞌunə̂, ŋ̀kɨ nzi mə kaa ò sɨ nândènə̀ a tɨtɨ̀ɨ bə̀ tɛꞌɛ, ǹdɨꞌɨ aa tsiꞌì mâŋjì yìi mə Nwì a lɔ̀ɔ mə bə̀ ka ntswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A kuꞌunə nɨ nɔ̀ŋsə̀ yiꞌinə̀ a ntu tax a mbo Kaisa kə̀ ŋ̀gaŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lâ à lɛ nzi mɨtsyɛ̀ mìi mə bo lɛ sɨ lobɨtə aà, ǹswoŋ a mbo bo mə, ");
INSERT INTO bfd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nɨ̀ zi nɨ̂ ŋ̀kabə̀ silva tâ mə̀ yə.” Bɨ zî nɨ yu, a betə̀ waa mə, “A tswê àtu wo bo bɨ̀ ɨ̀kǔm wo fàa nɨ̂ ŋ̀kabə aa ɛ?” Bo kwiꞌi mə, “Àa yì Kaisa.” ");
INSERT INTO bfd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A swoŋ a mbo bo mə, “Ma la a bə mə nɨ̀ ka mfa njoo jìi mə à nɨ jî Kaisa aa a mbo Kaisa, ŋ̀kɨɨ mfa nɨ̂ ǹjoo jìi mə à nɨ jî Nwî aa a mbo Nwì.” ");
INSERT INTO bfd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kaa bo lɛ ŋwaꞌǎ ajàŋ mə mbə bɨ tsyâ ǹtswa yi a nsi bə̀ ǹloŋ annù yìi mə à swòŋə aa zî, ànnù a ghaꞌà waa, bɨ kutə̀ mɨ̀ntsǔ myaa. ");
INSERT INTO bfd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","BaSadukai bî mɔꞌɔ bìi mə bɨ swoŋə nɨ mə kaa bə̀ sɨ a nɨ nɨ̀wo yweenə aa, ");
INSERT INTO bfd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bo lɛ nzì m̀betə yi mə, “Ǹdɨ̀ꞌɨ̀nnù, Moses à lɛ mfa ndɨꞌɨ a mbo bìꞌì mə, mbə̂ ǹdɨm ŋù a kwo tɨ mu, mumaà yì a lɔgə̀ ŋ̀gwɛ̂ yì wa njwe bɔɔ bo yu a mbô ǹdɨ̂m yì wâ. ");
INSERT INTO bfd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bɔɔ bɨ ma bî mɔꞌɔ lɛ ntswe ghu bi sàmbaa, yì ǹtsyàmbìì a yɔꞌɔ̀ mâŋgyɛ̀ ŋ̀kwo tɨ mu; ");
INSERT INTO bfd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","yì àyòŋtə̀ a bû ǹyoŋ ŋyɔꞌɔ mâŋgyɛ̀ wa, ");
INSERT INTO bfd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","yìi à yweꞌe bi tarə aa, a kɨ̂ ǹlɔgə mâŋgyɛ̀ wa, bo bya bi sàmbaa bɨ kɨ̂ lɔgə mâŋgyɛ̀ wa tsiꞌì bɨ̀tsɨ̀m ŋ̀kɨ ŋkwokə tɨ mû. ");
INSERT INTO bfd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","À tɨ̀ mə tɨ bə a njɨ̀m màŋgyɛ̀ wa a kɨ̂ ŋ̀kwo yìi ŋgaa. ");
INSERT INTO bfd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tsǒ mə a lɛ mbə ma mùu ajàŋ aa, nòò yìi bə̀ ka yǐ yweenə nɨ nɨ̀wo aa, màŋgyɛ̀ ghû à ka yǐ tɨgə bə aa yì wò aa ɛ? Tsǒ mə bo bya bi sàmbaa lɛ nyɔꞌɔ yi aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu a kwiꞌi a mbo bo mə, “Bə̀ bî fàa ŋgùꞌù bɨ yɔꞌɔkə, bɨ fâ nɨ̀ bɔɔ bâŋgyɛ̀ a ndâ nɨ̀yɔꞌɔ; ");
INSERT INTO bfd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lâ bə̀ bìi mə bɨ kuꞌunə a mbɨ̀ɨ̀nə nɨ nɨwo ɨ tswe ntɨ̀ɨ̀ maa ŋgùꞌû m̀bi yìi mə ɨ zì aa, kaa baa yǐ waꞌà kà ǹyɔꞌɔ, kaa waꞌǎ bâŋgyɛ̀ a ndâ nɨ̀yɔꞌɔ ka mfa. ");
INSERT INTO bfd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bo ka yǐ bə aa tsiꞌì tsǒ baangel kaa kɨꞌɨ̀ kà ŋ̀kwo. Bo bə aa bɔɔ bɨ Nwî ǹloŋ mə bo bɨɨnə nɨwo aà. ");
INSERT INTO bfd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lâ a ŋghɛ̀ɛ nɨ̂ ànnǔ nyweenə nɨwo, Moses à lɛ mfɨ̀gɨ̀tə̀ wa nɨ̂ àdɨ̀gə aŋwàꞌànə̀ ya mə a ghàà ǹloŋə atsùgə ɨti ya mə mɔꞌɔ ɨ lɛ sɨ khɨ ghu aà, ǹloŋ mə maa adɨgə, à lɛ ntwoŋə Mmàꞌàmbi a nɨ Nwìŋgɔ̀ŋ Abraham, nɨ Nwìŋgɔ̀ŋ Isaac, bo bɨ̀ nɨ Nwìŋgɔ̀ŋ Yakob. ");
INSERT INTO bfd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kaa à laa waꞌà Nwîŋgɔ̀ŋ bɨku bɨ bə̂ bə̂, à bə aa Nwìŋgɔ̀ŋ bə̀ bìi bɨ tswe bɨtɨ̀ɨ̀. Ǹloŋ mə bə̀ bɨtsɨ̀m bɨ tswe bɨ̀tɨ̀ɨ̀ aa ghu mbô.” ");
INSERT INTO bfd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ jya jǐ mɔꞌɔ bɨ lɛ ntɨgə nswoŋ mə, “Ǹdɨ̀ꞌɨ̀nnù, ò fâ àkwiꞌi yì sɨgɨ̀nə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ǹloŋ mə bo lɛ ntɨgə mbɔꞌɔ a mbǔ ŋghɛ̀ɛ nɨ̀ m̀bìì a mbetə̂ yi nɨ̂ ɨ̀nnù. ");
INSERT INTO bfd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu a betə̀ waa mə, “M̀bə bɨ swoŋ mə Àyɔꞌɔ̀ Nwì wa à nɨ mu David aa mə akə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ǹloŋ mə David yu mbɔŋ à swòŋə a mûm àŋwàꞌànə̀ bɨ Psalm mə, ‘M̀màꞌàmbi a swoŋ a mbô M̀màꞌàmbî ghà mə: Tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ mə̀ nî màꞌà, ");
INSERT INTO bfd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ǹyweꞌe a noò yìi mə mə̀ ka yǐ ghɨ̀rə ŋgàŋkɨbàâ jò nɨ̂ àtɛtə̀ mɨkòrə̂ mo aà.’ ");
INSERT INTO bfd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ma mùu ajàŋ m̀bə David a ka ntwoŋə yi nɨ̂ M̀màꞌàmbi, a tɨgə̀ m̀bu ntsyà aa la mbə mu David aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Àjàŋ mə bə̀ bɨ̀tsɨ̀m lɛ sɨ yuꞌutə annù yìi à lɛ sɨ swoŋə aa, Yesu a swoŋ a mbo ŋgǎŋyəgə̂nnù ji mə, ");
INSERT INTO bfd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nɨ̀ ka ntsyɛsə ghuu nloŋ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀, bo kɔ̀ŋə̀ nɨ̂ ŋ̀ka ŋwɛꞌɛ ǹdàŋə ɨtsə̀ꞌə̀ ŋ̀karə nɨ ju, ŋkɨɨ ŋkɔŋə nɨ mə tâ bə̀ ka ntsaꞌatə nɨ̂ waa nɨ̂ àghuꞌusə̀ a mɨtaa; ŋ̀kɔŋə a ntswe nɨ̂ ɨ̀lə̀ŋ jìi ɨ tswe a mbìì aa a ndâŋghòtə̂, ŋ̀kɨɨ ŋkɔŋə nɨ̂ ɨ̀lə̀ŋ jìi ɨ kɔꞌɔnə aa a adɨgə adinà. ");
INSERT INTO bfd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bo nɨ̀ꞌɨ̀ nɨ bɨ̀kwìꞌì bɨ bâŋgyɛ̀, ŋ̀kwɛrə nɨ̂ ǹjoò jyaa nɨ mɨ̀laꞌà myaa, m̀bagɨlə ntsaꞌatə nɨ̂ Nwî nɨ̂ ǹdaŋə mɨghàà. Wa ŋgɨꞌɨ yìi ɨ̀ ka yǐ kuu a nu bo aa ɨ̀ ka yǐ swèrə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu a tswê a mûm ǹdâmàꞌanwì ŋ̀ŋɛntə atû yi nlentə nyə ajàŋ yìi mə ŋgǎŋkabə ɨ lɛ sɨ nɨŋə nɨ̂ ŋ̀kabə a mûm ŋ̀kòm mmàꞌanwì aà. ");
INSERT INTO bfd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","À lɛ ŋkɨ nyə ŋkwiꞌi màŋgyɛ̀ yî mɔ̀ꞌɔ yìi mə à lɛ mbə ŋgàŋàmfum aa a tsyâ ǹnɨŋ ɨbàꞌatə ŋkabə copper ji baà, ǹdùû yi ɨ bə tsǒ kabà yî m̀fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu a swoŋ mə, “Mə̀ swoŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, ŋ̀kwiꞌi màŋgyɛ̀ ghû mə à nɨ ŋgàŋàfum aa, à nɨ̌ŋ ŋkabə fàa mûm ŋ̀kòm ǹtsyatə bə̂ bɨ̀tsɨ̀m; ");
INSERT INTO bfd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ǹloŋ mə bo swatə aa tsiꞌì mûntsirə̂ a nɨ ŋkabə yìi bo luu nɨ̀ yù aa mmaꞌa Nwî nɨ yu. Lâ màŋgyɛ̀ ghû mə̂ à nɨ ŋgàŋàfum aa, à kɔ̀ɔ̀ntə aa ŋ̀kabə̀ ǹtsɨ̀m yìi mə à tswe nɨ yu aa mfa.” ");
INSERT INTO bfd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bo bî mɔꞌɔ bɨ lɛ sɨ ghàà nɨ̂ ànnù ǹloŋ ajàŋ yìi mə bɨ lɛ ŋghùrə ndâmàꞌanwì nɨ̂ ŋ̀gɔ̀ꞌɔ̀ jìi ɨ lɛ naŋsə mbɔŋ mbɔ̀ŋ aa, bo bɨ̀ nɨ njoo jìi mə bə̀ lɛ mfa a mmàꞌa Nwì ghu aà. Bo kà mə̂ aa ghaa laa, Yesu a swoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ǹjoo mà jû tsɨ̀m mə nɨ yə aa, ǹjwi yì mɔ̀ꞌɔ ɨ zì mə Kaa tsiꞌì ŋ̀gɔ̀ꞌɔ̀ yî m̀fùùrə̀ kaa ɨ̀ ka yǐ waꞌǎ a atu yì mɔ̀ꞌɔ bû nɔŋə. Bɨ ka yǐ sàꞌà tsiꞌì tsɨ̀m màꞌànə a nsyɛ̂.” ");
INSERT INTO bfd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bo bə̀tə yi mə, “Ǹdɨ̀ꞌɨ̀nnù, naŋsə nwoŋ tâ bìꞌì yuꞌu, ɨ̀nnù ma jû ɨ ka yǐ fɛ̀ꞌɛ̀ aa a noò àkə̀ aa ɛ? Àlə̀nsə̀ yìi mə a ka yǐ dɨ̀ꞌɨ mə nòò m̀fɛ̀ꞌɛ̂ ɨ̀nnù ma jû à tɨ̀gə̂ ŋ̀kuꞌu aa, a nɨ aa akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A swoŋ a mbo bo mə, “Nɨ̀ ka ntsyɛsə ghuu tsee lǒ lə̀ə̀ tâ ŋù tsù à bweꞌesə ghuu; ǹloŋ mə bə̀ bì ghàꞌàtə̀ ka yǐ zì nɨ̂ ɨ̀kǔm gha, ɨ kɨ swoŋə nɨ mə, ‘Mə̀ nɨ yu wâ!’, ‘Nòò wa à kòòntə̀ mə̂!’ Nɨ̀ tsuu waa kɨ yòŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bɛɛ mə nɨ̀ yuꞌu mə bɨ màꞌa ntsò, kə̀ bɛɛ mə nɨ̀ yuꞌu annù ǹloŋ ɨ̀yɔ̀ŋ, nɨ̀ tsuu kɨ bɔꞌɔ siꞌi siꞌi bə̂; ǹloŋ mə ɨnnù ma jû ɨ tswe nɨ̀ m̀fòo mfɛ̀ꞌɛ yaꞌa; kaa mbî ɨ̀ ka yǐ waꞌa aa tsiꞌì ma mùu noò ghɛnsə̀ ǹlwiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu a ghɛɛ̀ nɨ̂ m̀bìì a nswoŋ a mbo bo mə, “Ɨ̀too ɨ ka yǐ kɨ màꞌa ntsò bo bɨ̀ jǐ mɔꞌɔ, tâ ɨ̀too jìi mə bɨfɔ̀ buꞌutə aa tâ ɨ̀ kɨ ŋka mmaꞌanə bo bɨ̀ jǐ mɔꞌɔ̀; ");
INSERT INTO bfd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ǹsyɛ̂ ɨ̀ ka yǐ kɨ tsɨ̀gɨ̀nə̀ tsiꞌì nɨ̀ mɨ̀tɨ̀ɨ̀, tâ mɨ̀kwenə̀ à kuu alaꞌa, tâ mɨ̀ghɔ̀ɔ̀ mɨ ŋkwǒŋ bə̀ tâ mɨ̀ fɛꞌɛ a ɨdɨgə ɨdɨgə; ɨ̀nnù jî swèrə̀ ǹswerə bo bɨ̀ ɨ̀lènsə̀ jî wè ɨ ka yǐ kɨ fɛ̀ꞌɛ a mbàꞌà nɨ̀kàŋ. ");
INSERT INTO bfd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","M̀bɔŋ tâ ma juù ɨ̀nnù ɨ̀ ka mfɛꞌɛ, boŋ bɨ ka yǐ kɨ baŋtə nɨ̂ ghuu, ɨ kɨɨ tsɔꞌɔ nɨ̂ àkòrə̂ yuu. Bɨ ka yǐ kɨ tswatə nɨ̂ ghuu ɨ fa nɨ a ndaŋghotə tâ bɨ̀ ka nsaꞌa, ɨ kɨɨ màꞌà nɨ̂ ghuu a ndâtsaŋə̀. Bɨ ka yǐ kɨ ghɛ̀ɛ̀ nɨ̂ bù a nsi bɨ̀fɔ̀ bo bɨ̀Gûmnàà ǹloŋə annǔ Ɨkûm ghâ. ");
INSERT INTO bfd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma yû a ka yǐ fa abwarə a mbo bù mə nɨ̀ swoŋ annǔ yâ. ");
INSERT INTO bfd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","M̀bə a fɛꞌɛ ma mùu ajàŋ nɨ̀ tsuu kɨ taŋtə annù yìi mə nɨ̀ ka ghɨ̀rə swoŋ fiꞌisə ɨbɨ̀ɨ nû ghuu ghu aa mbɔŋ tâ nòò à kuꞌu; ");
INSERT INTO bfd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ǹloŋ mə mə̀ ka yǐ fa nɨghàà bo bɨ̀ mɨ̀tsyɛ̀ a mbo bù, a ajàŋ yìi mə kaa mbə bə̀ bìi mə bɨ nɨŋ ɨsaꞌa a nu bù aa kaa mbə bɨ waꞌà lɨ̀gɨ̀tə̀ kə̀ kɨ ntuu. ");
INSERT INTO bfd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tsiꞌì bɨ̀taà buu nɨ bɨ̀ndê buu, nɨ bɔɔ bɨ maà buu, nɨ bǎŋgwɛ̀ꞌɛ̂ buu, bo bɨ̀ ɨ̀kàꞌâ juu, bɨ ka yǐ fèè ghuu. Bɨ ka yǐ tswatə ghuu bî mɔꞌɔ fa mə bɨ̀ zwitə. ");
INSERT INTO bfd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bə̀ bɨ̀tsɨ̀m ka yǐ bàà ghuu nloŋ ɨkûm ghâ. ");
INSERT INTO bfd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lâ kaa tsiꞌì ɨ̀nòŋə̀tû yùù yî m̀fùùrə̀ kaa m̀bə yɨ waꞌà bwɛ̂. ");
INSERT INTO bfd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nɨ̀ bə tǎŋntɨɨ ɨ bii ŋgɨꞌɨ boŋ nɨ̀ ka yweensə mɨbɨ̀ɨ̀ mɨ nû muu. ");
INSERT INTO bfd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“M̀bə nɨ̀ yǐ nyə ŋgǎŋntsò ɨ karɨsə Yerusalem, nɨ̀ zì mə nòò ǹta ŋgɨꞌɨ ghu à kòòntə̀ mə̂. ");
INSERT INTO bfd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Maà noò tâ bə̀ bìi mə bɨ tswe a alaꞌa Yudea aa bɨ fɛꞌɛ ŋkhəkə ŋkɔꞌɔ ŋghɛɛ a ɨtu mɨ̂ntaꞌà, tâ bìi mə bɨ tswe a mûm ǹjɔ̀ꞌɔ̀ àlaꞌa aa bɨ̀ fɛꞌɛkə, tâ bìi mə bɨ tswe a mbɛ̀ɛ ɨfɔ̀ aa tâ bɨ̀ tsuu bu ŋkuu a mûm ǹjɔ̀ꞌɔ̀ àlaꞌà; ");
INSERT INTO bfd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ǹloŋ mə ǹjwi mà jû à ka yǐ bə aa noò yìi Nwì à ka yǐ ndɨ̌ ŋgɨꞌɨ a nu bə̀ bi, a nlwensə ɨnnù tsɨ̀m jìi mə bɨ ŋwaꞌanə a mum nɨ̀ghàà nɨ Nwî aà. ");
INSERT INTO bfd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wɛɛ! Ŋ̀gɨꞌɨ̀ bɨ̀maburə̀ bi atoꞌo bo bɨ̀ yì bìi mə bɨ nɔŋsə bɔɔ maa nɨ̂ ǹjwi ma jya aà! Ǹloŋ mə ŋ̀gɨꞌɨ yì ŋ̀wè ɨ̀ ka yǐ tswe fàa atu nsyɛ̂, tâ Nwì à dɨꞌɨ alwintɔŋə̀ yi a nu bə̀ ma bû. ");
INSERT INTO bfd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bɨ ka yǐ zwitə bə̂ bî ghàꞌàtə̀ nɨ munwî ǹtsò, ɨ tɨgə tswatə waa nɨ̂ ɨ̀bùꞌu ntsò, ɨ ghɛ̀ɛ̀ nɨ bo ɨtoo ɨtoò; tâ bɨ̀tɨ̀zî Nwî bɨ kuu Yerusalem ɨ naŋsə kɨ kwàrə, ɨ tɨgə nnɨ̀ꞌɨ̀ nɨ̂ bə̀, ɨ yweꞌe noò yìi mə Nwì à lə̀ə mə tâ bo ghɨrə ma yû ànnù aa, à zi mmɛ̀. ");
INSERT INTO bfd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ɨ̀lènsə̀ ɨ ka yǐ kɨ fɛ̀ꞌɛ a nɨ nɨ̀nòò, bo bɨ̀ a nɨ sàŋ bo bɨ̀ nɨ mɨ̀njɔ̀ŋ. Tâ bə̂ a ɨtoo ɨtoo bɨ̀ tswe a mûm ŋ̀gɨꞌɨ tâ ɨ̀tu jyaa buurə a ajàŋ yìi mə bɨ yə mɨyaa bo bɨ̀ ɨ̀kàŋə ŋkì ɨ tɨgə burə juꞌu aà. ");
INSERT INTO bfd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bə̀ ka yǐ tɨgə bɔꞌɔ nloŋ ɨ̀nnù jìi mə ɨ fɛ̀ꞌɛ̀ a mbi aa, ɨ tɨgə wòkə̀ tsiꞌì tsǒ ɨ̀ku njoò; ǹloŋ mə bɨ ka yǐ tsɨ̀gə ɨdaꞌa tsɨ̀m jìi ɨ tswe a aburə aà. ");
INSERT INTO bfd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Maà noò tâ bɨ̀ yə a Mu Ŋù tâ à ka nzi nɨ a mûm m̀bàꞌà nɨ mɨ̀dàꞌà nɨ nɨ̀ghaꞌa nì wè. ");
INSERT INTO bfd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","M̀bə nɨ̀ yi nyə ma juù ɨ̀nnù ɨ lɔgɨnə ŋka mfɛꞌɛ, nɨ̀ bɨɨ̀nə̀ ǹtəə ŋŋɛntə ɨtû juu a ndəŋ nloŋ mə nòò ǹtsùꞌû àtû yuu à kà mə̂ aa ŋkoontə aà.” ");
INSERT INTO bfd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu a ghɛɛ̀ nɨ̂ m̀bìì ǹnaa nɨghàà nuà a mbo bo: “Lèntə nɨ̀ àti figə̀ bo bɨ̀ ɨ̀tì jî mɔꞌɔ; ");
INSERT INTO bfd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","a yi mbə noò yìi ntaà ji ɨ fìꞌìsə̀ mə ɨyə̀ŋ jî fii aa, nɨ̀ zi mə nòò ǹtsû m̀bə̀ŋ à tɨ̀gə a abô. ");
INSERT INTO bfd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","A kɨ̂ mbə nɨ a ŋgɨ̌ŋ ŋgɨ̀ŋ mə, nɨ̀ bə yə tâ ɨ̀nnù juà ɨ̀ ka mfɛꞌɛ boŋ nɨ̀ zi mə nòò ànnù nɨfɔ̀ Nwî à kòòntə̀ mə̂. ");
INSERT INTO bfd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mə̀ swoŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, kaa nɨ̀wàà nɨ bə̂ nuà nɨ ka waꞌà tsyà tɨ ghə̂ ɨ̀nnù ma jû tsɨ̀m ɨ fɛ̀ꞌɛ̀ mə̂. ");
INSERT INTO bfd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Àbùrə̀ bo ǹsyɛ̂ ka yǐ tsyà, lâ kaa tâ nɨ̀ghàâ na nɨ̀ waꞌà tsyà. ");
INSERT INTO bfd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nɨ̀ ka ntsyɛsə ghuu ntsuu mɨbɨ̀ɨ̀ mɨ nû muu bo bɨ̀ noò ghùù siꞌi siꞌi kɨ fa nloŋ annǔ mɨjɨ bo bɨ̀ a ŋka nnô, bo bɨ̀ ɨ̀nnù jìi mə ɨ nwùgə̀ nɨ̂ ghuu fàa mûm ǹtswêntɨ̀ɨ̀ aa boŋ ǹjwi mà ya ɨ̀ ka yǐ wìꞌìkə̌ tswa ghuu tsǒ mâtaà. ");
INSERT INTO bfd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ǹloŋ mə ǹjwi mà ya ɨ̀ ka yǐ zì aa a mbo bə̀ bɨ̀tsɨ̀m bìi mə bɨ tswe fàa atu nsyɛ aà. ");
INSERT INTO bfd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nɨ̀ ka nstwe nɨkərə̀ a ŋgɔ̀ŋ bɨ̀nòò bɨtsɨ̀mə̀, ǹtsaꞌatə nɨ̂ Nwî mə mbə a fa mɨ̀tɨ̀ɨ̀ mìi mə mbə nɨ̀ yî ŋ̀khə ɨnnù ma jû tsɨ̀m mə ɨ ka yǐ kɨ fɛ̀ꞌɛ̀ aà, tǎ bàŋnə təə a nsi Mu Ŋù.” ");
INSERT INTO bfd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu à lɛ sɨ dɨ̀ꞌɨ̀ nɨ nɨ̀ghàà nɨ Nwî a ndâmàꞌanwî a njwî tsɨ̀mə̀. M̀baŋnə ŋghɛ̀ɛ̀ ǹlɛ nɨ̂ ǹtaꞌa yìi mə bɨ lɛ sɨ twoŋə nɨ Olive aa nɨ̀tugə̀. ");
INSERT INTO bfd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tsiꞌǐ a mbàꞌa mbàꞌà bə̀ bɨ̀tsɨ̀m lɛ sɨ zǐ a ndâmàꞌanwì a nyuꞌu ànnù yìi mə à lɛ sɨ dɨ̀ꞌɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nòò ŋ̀kùrə̂ àbaa tɨ kɔꞌɔ wa, noò wa yìi mə bɨ lɛ sɨ twoŋə nɨ Passa aa, à lɛ ŋkùꞌù, ");
INSERT INTO bfd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ bɨ kâ m̀bɔꞌɔ bə̀ bya ntɨgə nlɔɔ nɨ̂ àjàŋ mə bɨ ka ŋeꞌesə zwitə Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satan à lɛ ŋkuu a atoꞌo Judas wa yìi mə bɨ lɛ sɨ twoŋə nɨ Iscariot aà, m̀bə ŋ̀gàŋyəgə̂nnù Yesu wa yì mɔ̀ꞌɔ a tɨtɨ̀ɨ bya nɨ̀ghûm ǹtsò baa aà. ");
INSERT INTO bfd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas à lɛ nlò ŋ̀ghɛɛ yi, ŋ̀ghɛɛ ntaŋtə bo bɨ̀ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌanwì bo bɨ̀ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmbɛ̂ ǹdâmàꞌa Nwì a ajàŋ yìi mə yu ka fèè Yesu a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bo lɛ nnaŋsə ndorɨtə tsiꞌì m̀bə̂ ànnù, m̀bii mə bo ka fa ŋkabə ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas à lɛ ŋkɨ mbii, ǹtɨgə nlɔgɨnə ŋka nlɔɔ nɨ̂ mânjì yìi mə mbə yu feè Yesu a mbo bo tɨ ghə̀ mə bə̀ zî. ");
INSERT INTO bfd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ǹjwi ɨ̀ lɛ ŋkùꞌù àjàŋ mə bɨ taŋtə annǔ njwî Abaa tɨ kɔꞌɔ, ŋ̀wa nɨ̂ mû m̀bînjə̀rə̀ Passa aa, ");
INSERT INTO bfd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu a too Peta bo Jɔn, ǹswoŋ a mbo bo mə, “Nɨ̀ ghɛɛ ntaŋtə mɨjɨ mɨ Passa, a ajàŋ mə bìꞌinə̀ ka jɨ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bo betə̀ yi mə, “Bìꞌi ghɛɛ taŋtə aa fə ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu a kwiꞌi a mbo mə, “A ajàŋ mə nɨ ka kɨ kuu ghɛ̀ɛ a njɔ̀ꞌɔ̀ àlaꞌa aa, nɨ ka yə ŋû tâ à beꞌe àntɔ̀ɔ̀ ŋ̀kì, nɨ̀ yə, nɨ̀ yoŋə̀ yi nyoŋ ŋkuu a nda yìi à ka kuu ghu aà. ");
INSERT INTO bfd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nɨ̀ kuu nɨ̀ swoŋ a mbo m̀bɔ̂ŋ ǹda wa mə, ‘Ǹdɨ̀ꞌɨ̀nnnù à bètə mə, ǹjaꞌà ǹda yìi bìꞌi bɨ̀ ŋ̀gǎŋyəgə̂nnù ja ka jɨ Passa ghu aa ɨ̀ fə̀ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Boŋ à ka dɨ̀ꞌɨ njaꞌà ǹda yì ŋwè yî mɔ̀ꞌɔ a ndəŋ yìi mə ǹjoo ɨ tswe ghu aa tâ nɨ̀ naŋsə.” ");
INSERT INTO bfd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bo lɛ ŋghɛ̀ɛ̀ ǹyə ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m tsiꞌì wa ajàŋ mə Yesu à lɛ nswoŋ a mbo bo aa, ntɨgə nnaŋsə njoo njɨ Passa jyâ. ");
INSERT INTO bfd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nòò ǹjɨ Passa wa à kùꞌù mə̂, Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji bo tswê a atu atɛtɛ̀, ");
INSERT INTO bfd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","a swoŋ a mbo bo mə, “Mə̀ ghɨ̀rə naŋsə nlɔɔ mə mə jɨ mɨjɨ mɨ Passa biꞌinə̀ ɨ bɔ̌ŋ yə ŋgɨꞌɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mə̀ swoŋ a mbo bù mə kaa mə̀ ka yi waꞌà mɨjɨ mà mû bù ǹjɨ ɨ yweꞌe a noò yìi mə ànnù nɨfɔ̀ Nwî a ka yǐ zǐ tâ ǹjiꞌì ànnù yìi bɨ jɨ ghu aa tâ ɨ̀ naŋsə nlaa.” ");
INSERT INTO bfd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yɛɛsɔ̂ à lɔgə̀ ǹdɔ̂ŋ mɨ̀lùꞌù m̀fa mbɨꞌɨkə a mbo Nwì ǹswoŋ mə, “Nɨ̀ ko nno ŋkwɛrɨnə nɨ yu. ");
INSERT INTO bfd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mə̀ swoŋ a mbo bù tsiꞌǐ annù nɨ̂koŋ mə, kaa mə̀ ka yǐ waꞌa mɨlùꞌù bû ǹno, ǹyweꞌe noò yìi mə ànnù nɨfɔ̀ Nwî a ka yǐ zì aà.” ");
INSERT INTO bfd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A tɨgə̀ m̀bu nlɔ̀gə abaa, mfa mbɨꞌɨkə a mbo Nwì, m̀batə mfa a mbo bo, ǹswoŋ mə, “À nɨ̂ ɨ̀bɨ̀ɨnû gha ɨ ghuà, yìi mə̀ ka fa a atu bù aà. Nɨ̀ tɨgə ŋghɨrə ma mùu ajàŋ ŋ̀waꞌatə nɨ̂ ghâ.” ");
INSERT INTO bfd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tsiꞌì maa ajàŋ, a kɨ̂ m̀fa ndɔŋ ya a mbo bo a noò mə bo jɨ̀ mə̂ mɨjɨ mya màŋsə̀ aa, nswoŋ mə, “Ǹdɔŋ yulà, à nɨ̂ àkàà yî fii yìi mə Nwì à wàrə bǔ bo nɨ̂ àləə nû ya yìi mə bɨ ka saansə a atu bù aà. ");
INSERT INTO bfd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Lâ, yə̂ nɨ̀, ŋù yìi mə à fèe gha aa, à tswe fàa atu atɛtə̀ ǹjɨ biꞌi yu, ");
INSERT INTO bfd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Lâ ànnù ma yû a ka yə Mu ŋù aa tsiꞌǐ ajàŋ yìi mə bɨ lɛɛ̀ ǹtɛꞌɛ ntaŋtə nləə aà, lâ ŋ̀gɨꞌɨ yì ǹswèrə̀ a nu ŋù yìi mə à fèe yi aà.” ");
INSERT INTO bfd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bo lɔgɨ̀nə̀ ǹtɨgə mbetə nlɔɔ a tɨtɨ̀ɨ bo mə m̀bə a naŋsə̀ m̀bə aà wò yìi mə mbə à ghɨrə̀ ma yu ànnù aa lɛ! ");
INSERT INTO bfd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Àswùŋnə̀ a lɛ mfɛ̀ꞌɛ̀ a tɨtɨ̀ɨ ŋgǎŋyəgə̂nnù Yesu, bo lɔɔ̀ nɨ̀ ǹzi mə ŋù yìi mə à nɨ ŋû yì ŋ̀wè àkɔꞌɔ̀ntsɨrə a tɨtɨ̀ɨ bo aa nɨ̂ wò ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu a swoŋ a mbo mə, “Bɨ̀fɔ̀ bɨ bɨ̂tɨzî Nwî bo buꞌutə bə̂ byaa laa bùꞌùtə̀. Bɨ twoŋə̀ nɨ̀ bɨ̀tà bɨ alaꞌà byaa laa nɨ̂ ŋ̀gǎŋghɨ̀rə̂ ɨ̀bɔ̀ŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lâ tâ à tsuu maa ajàŋ bə a mbo bù. A kuꞌunə mə ŋù yìi mə à nɨ akɔꞌɔ̀ntsɨrə a tɨtɨ̀ɨ bù aa tâ à bə tsiꞌì tsǒ mûŋkhə yìi mə à kə̀ꞌə nsɨgə nlwiꞌisə. Tâ bɨ̀tsyàsə̀ a tɨtɨ̀ɨ bù bɨ̀ bə tsiꞌì tsǒ ŋ̀gàŋəfàꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A ghàꞌàtə wò aa ɛ? Ŋù yìi mə à tswe a atu atɛtə̀ ǹjɨ aa kə̀ ŋù yìi mə a tsyàsə̀ mɨjɨ aa ɛ? A laa mə à nɨ ŋù wa mə à tswe njɨ aà. Lâ mə̀ bàŋnə ntswe a tɨtɨ̀ɨ bù aa tsiꞌì tsǒ ŋù ǹtsyàsə mɨjɨ̂. ");
INSERT INTO bfd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nɨ̀ tswè mə̂ biꞌinə̀ a mûm ŋ̀gɨꞌì ǹtsɨ̀m yìi mə mə yə aà. ");
INSERT INTO bfd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tsǒ mə Taà ghà à fà mə̂ mɨdaꞌa a mbo mə̀ mə tâ mə̀ ka nsaꞌa mbi yù aa, mə̀ kɨ mfa ma myaà mɨ̀dàꞌà a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nɨ̀ ka yǐ kɨ jɨ kɨɨ nno a atu atɛtə̌ mə̀ a mûm ànnù nɨfɔ̌ mə̀. Nɨ̀ ka yǐ kɨɨ ŋŋaŋnə nɨ̂ ɨ̀bə̀rə̀ ɨ kɨ saꞌa nɨ̂ ɨ̀tsə baIsrael jya nɨ̀ghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, yuꞌutə̂! Satan à lɛ mbetə mə yu yweꞌetə ghuu tǎ səgə ghuu tsǒ abaa, ");
INSERT INTO bfd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","lâ mə̀ tsàꞌàtə̀ mə̂ Nwî a atu wò, Simon, mə tâ àbìintɨɨɨ̀ yo tsuu lǒ bɔrə. Bɛɛ ò bə̀ŋkə gho mbɨ̀ɨ̀ a nu mə̀, ò lɨgɨ̀nə̀ ǹnɨŋ mɨdaꞌa a nu bɨ̀lɨ̂m bô.” ");
INSERT INTO bfd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peta a kwiꞌi mə, “Mmàꞌàmbî, mə̀ tàŋtə mə mə̀ ka kuu atsaŋ bìꞌiò, ɨ kɨɨ kwo biꞌiò.” ");
INSERT INTO bfd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu a kwiꞌi ghu mbo mə, “Mə̀ swoŋ a mbo wò Peta mə, m̀bɔŋ tâ àŋkə̀gə̀ à tɔŋ nɨ̂tugə sìi, boŋ ò tùù mə̂ gha ŋ̀gàà ji tarə nswoŋ mə kaa ò sɨ̀ gha zî.” ");
INSERT INTO bfd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu a betə ŋ̀gǎŋyəgə̂nnù ji mə, “Nòò wa mə mə̀ lɛ ntoo ghuu nswoŋ a mbo bù mə nɨ̀ tsuu abɔsà lɔ̀gə, ǹtsuu abàà lɔ̀gə̀, ŋ̀kɨ tsuu ntam nlɔ̀gə aa, nɨ̀ lɛ mbaa mboŋə ayoò yì tsu aa ɛ?” Bo kwiꞌi mə, “Ŋ̀gaŋ.” ");
INSERT INTO bfd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu a swoŋ a mbo bo mə, “Lâ, tsɨ̂tsɔ̀ŋ ŋù yìi mə à tswe nɨ̂ àbɔsà yi nɨ̂ àbàa yi aa, tâ à lɨgɨnə nlɔ̀gə̀. Ŋù yìi mə à sɨ̀ nɨ munwî ǹtsò tswe aa, tâ à fee akûtə̀ yi nyuu ghu. ");
INSERT INTO bfd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ǹloŋ mə, mə̀ swoŋ a mbo bù mə, annù yuà yìi mə aŋwàꞌànə̀ Nwî a swoŋ aa mə: ‘À yə̂ ŋ̀gɨꞌɨ tsiꞌì tsǒ ŋ̀gàŋmbùꞌû ɨ̀nnù jî bɨ’ aa, ka bòòntə̀ m̀bɨꞌɨ ŋgaà yà, ǹloŋ mə ŋ̀gɔ̀ŋ ɨ̀nnǔ tsɨ̀m jìi mə bɨ lɛ ŋŋwàꞌànə̀ m̀bɨꞌɨ ŋgaà yà aa ɨ kà mə̂ aa mfɛꞌɛ mbòòntə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ŋ̀gǎŋyəgə̂nnù ji ɨ swoŋ mə, “Yə̂, bɨ̀munwi bɨ ntsò bi baa bɨ̂ bulà, M̀màꞌàmbî.” A kwiꞌi mə, “Wa a kùꞌù mə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu à lɛ màꞌàtə̌ njɔ̀ꞌɔ̀ àlaꞌà Yerusalem m̀fɛꞌɛ yi, tsiꞌǐ ajàŋ yìi mə à lɛ sɨ ghaꞌasə ŋghɨrə aà, m̀fɛꞌɛ ŋghɛ̀ɛ̀ yi a atu ntaꞌa Olive. Ŋ̀gǎŋyəgə̂nnù ji ɨ lɛ nyòŋə̀ yi bo bo kɔꞌɔ ŋghɛ̀ɛ̀ ghu. ");
INSERT INTO bfd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","À kɔ̀ꞌɔ̀ mə̂ ŋ̀kuu ghu, nswoŋ a mbo bo mə, “Nɨ̀ ka ntsaꞌatə Nwî tǎ waꞌà a ŋkɨ̀rə̀ Satan lô ŋ̀wo.” ");
INSERT INTO bfd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","À swòŋ mə̂ laà, m̀maꞌatə waa ŋghɛntə, àghaꞌa a bɔɔ̀ ǹsaꞌatə tsiꞌì mûntsìrə̂, ǹswɛtə mɨkuꞌutə̂ mi a nsyɛ, ǹtsàꞌàtə̀ Nwî ");
INSERT INTO bfd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ǹswoŋ mə, “Taà, m̀bə ò bii boŋ ò tse kwɛrə ndɔ̂ŋ ŋ̀gɨꞌɨ yù a mbo mə̀ ǹlɔꞌɔsə. Lâ mə kɔ̀ŋ aa a ŋghɨ̀rə bə̂ ànnù yìi mə o lɔ̀ɔ̀ aà; kaa waꞌà bə à yìi mə mə lɔ̀ɔ̀ aa bə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Angel à lɛ nlò a aburə nsɨgə mfa mɨtɨ̀ɨ̀ ghu mbô,  ");
INSERT INTO bfd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tsǒ mə ntɨɨ̀ yi ɨ lɛ mburə nluu nɨ̂ àjəŋnə̀ aa, a bû ŋ̀gaansə mɨtɨ̀ɨ̂ mi ŋkuꞌusə ntsàꞌàtə̀ Nwî tsiꞌì nɨ̀tɨ̀ɨ̀ nɨ̀tɨ̀ɨ̀, ǹlɨgɨnə, àlɨ̀gɨ̀nə̀ yìi mə a lɛ mfɛ̀ꞌɛ̀ ghu nu aa a tɨgə̀ ǹsɨgə ntsɨɨŋkə, mbə tsǒ ɨ̀tàa aləə̀. ");
INSERT INTO bfd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","À lò mə̂ wa adɨgə ntsàꞌàtə Nwì m̀bɨɨ nzì fu wa mbɛ̀ɛ ŋgǎŋyəgə̂nnù ji jya, ǹyə waa bɨ bwii nloŋ mə àjəŋnə̀ yìi mə a lɛ nluu a ntɨɨ bo aa a lɛ ŋghɨ̀rə̀ bo bɔrə̀. ");
INSERT INTO bfd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A betə̀ a mbo bo mə, “Nɨ bwii aa àkə̀ aa ɛ? Nɨ̀ bɨɨnə ntswe ŋka ntsaꞌatə Nwî tǎ waꞌà a ŋkɨ̀rə̀ Satan lô ŋ̀wo.” ");
INSERT INTO bfd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu à kà mə̂ aa ŋghaa laà, kaa mburə tɨ màŋsə̀, ǹnɔ̀ɔ̀ bə̂ ɨ ywunə̀ ǹzi, Judas, ŋù yì mɔ̀ꞌɔ wa tɨtɨ̀ɨ ŋgàŋyəgə̂nnù Yesu jya nɨ̀ghûm ǹtsò baa, à lɛ mbə yu yìi mə à lɛ ntsyǎ mbìì yàà, ǹdɨꞌɨ nɨ̂ mânjì a mbo bo. Judas à zì mə̂, ǹtsya ŋghɛ̀ɛ̀ a mbɛ̀ɛ Yesu mə yu nɔŋ mɨghə̀gə̂ mi. ");
INSERT INTO bfd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","La Yesu a betə ghu mbo mə, “Judas, ǹnɔ̌ŋ mɨ̀ghə̀gə̀ mɨ Mu Ŋù à laa mbə mânjì yìi mə ò tse tsyà ghu ɨ fèè yi aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ŋ̀gǎŋyəgə̂nnù jya jìi mə bo bɨ̀ Yesu lɛ ntswe aa, bɨ yə̀ mə annù yìi mə a lɛ ntswe ghu aa, mbetə yi mə, “M̀màꞌàmbî, o lɔ̀ɔ mə tâ bìꞌì to waa nɨ bɔɔnwi biꞌi aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ŋù nɨ̀bǒ wàà yî mɔ̀ꞌɔ a burə̀ ǹlɔgə munwi ŋkwyɛ atôŋnə̌ abùꞌu ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè yî màꞌà ghu nlɔꞌɔsə. ");
INSERT INTO bfd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lâ Yesu a swoŋ a mbo bo mə, “Wa a kùꞌù mə̂!” Ŋ̀ghɛnsə abô yi mmɔɔntə atôŋnə̀ ŋû wa ghu ŋghurə yi. ");
INSERT INTO bfd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu a tɨgə̀ ǹswoŋ a mbo bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bo bɨ̀ a mbo bɨ̀tsyàsə̀ bɨ ŋgǎŋmbɛ̂ ǹdâmàꞌanwì bya nɨ a mbo bɨ̀tà bɨ alaꞌa bya bìi mə bɨ lɛ nzì a ntswa yu aa mə, “Nɨ̀ zi nɨ̀ nwi ntsò a bɔ̀ꞌɔ nɨ mɨ̀buꞌu aa a ntswa mə̀ tsǒ nɨ̀ zi a mbaŋnə àŋgâmɨghee aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tɨgə mə̀ kɨ̀ sɨ tswe biꞌinə̀ a ndâmàꞌanwì aa tsiꞌǐ njwi njwi aa ɛ? Tɨgə boŋ nɨ̀ lɛ mbaa ntswa gha aa maà noò. Lâ tsɨ̀tsɔ̀ŋ à nɨ nòò ghùù, nòò yìi mə ŋù wa yìi mə a saꞌa mfii ɨdɨ̀gə̀ à fa mɨdaꞌa a mbo bù aà.” ");
INSERT INTO bfd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bɨ lɛ ntswa Yesu ǹlɔgə yi ŋghɛɛ nɨ ghu a ndùgə ŋgàŋmàꞌa Nwì yî ŋ̀wè. Bɨ lɔ̀gə̀ mə̂ yi ŋka ŋghɛɛ nɨ ghu aa, Peta a tɨgə̀ ǹyoŋə, ǹyoŋ aa tsiꞌǐ a sàꞌa aghaꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bɨ lɛ ŋŋètə mɔꞌɔ a tɨtɨ̀ɨ ǹsàŋàbɛ̀ɛ̀ yâ, Peta a yôŋ ǹtɨgə ŋghɛɛ tsitə bə̂ bya bìi mə bɨ lɛ ntswe ghu aa, bo bo tɨgə̀ ǹyɔꞌɔtə. ");
INSERT INTO bfd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ŋ̀gàŋàfàꞌa ŋgàŋmàꞌa Nwì wa yì màŋgyɛ̀ yî mɔ̀ꞌɔ à yə̀ mə yi a tswê wa adɨgə mɔꞌɔ aa, ǹtɛꞌɛ miꞌì mi ghu nu nlìì, ǹswoŋ mə, “Ŋù ghulà mə, à ghɨ̀rə ŋkɨ tswe bo bɨ̀ Yesu!” ");
INSERT INTO bfd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lâ Peta a tuu nswoŋ mə, “Màŋgyɛ̀, tsiꞌì ǹzî yi, kaa mə̀ sɨ̀ yi burə nzi zi!” ");
INSERT INTO bfd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mu fɨ̀bàŋtə̀ à bù mə̂ ŋ̀ghə̀ə kɨ bə, ŋù yî mɔ̀ꞌɔ a yə̂ Peta, ǹswoŋ mə, “Tɨgə ò bə aa ŋù nɨ̀bò wàà yî mɔ̀ꞌɔ aa ɛ?” Lâ Peta a kwiꞌi mə, “M̀bâ ghulà, wa kaa mə̀ sɨ̀ ghu bə̂!” ");
INSERT INTO bfd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nòò à bù mə̂ ǹtsya yî m̀fùùrə̀, ŋù yî mɔ̀ꞌɔ a bû ǹzi nlɨ̀gɨ̀nə̀ ǹswoŋ tsiꞌì nɨ̀tɨ̀ɨ̀ mə, “Tsiꞌǐ annù nɨ̂ŋkoŋə̀, ŋù ghûlà à ghɨrə ntswe bo bɨ̀ Yesu, ǹloŋ mə à nɨ mu Galilea aà!” ");
INSERT INTO bfd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lâ Peta a kwiꞌi mə, “Kaa mə̀ sɨ̌ annù yìi mə o ghàà ǹswoŋ aa zî!” Tsiꞌì maa noò mə à kà mə aa kwiꞌi laa, àŋkə̀gə̀ a tɔŋə̀. ");
INSERT INTO bfd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","M̀màꞌàmbi a karɨkə̀ yi ntɛꞌɛ miꞌì mi ntsinə nlii Peta, Peta a waꞌatə̀ ànnù ya mə Mmàꞌàmbî à ghɨrə nswoŋ ghu mbo aa mə, “M̀bɔŋ tâ àŋkə̀gə̀ à tɔŋ ŋgaa ji baa nɨ̂tugə sìi, lɛ boŋ ò tùù mə̂ ghâ ŋ̀gàà ji tarə̀!” ");
INSERT INTO bfd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peta à lɛ mfɛ̀ꞌɛ̀ ǹghɛɛ a abɛɛ, ǹnaŋsə nyəꞌə tsiꞌǐ mbə̂ ànnù. ");
INSERT INTO bfd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bə̀ bya bìi mə bɨ lɛ sɨ bɛ nɨ̂ Yesu aa bɨ lɛ sɨ tɨgə ŋwyɛ nìi ŋ̀kɨɨ ŋghɔɔ nìi. ");
INSERT INTO bfd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ǹlɔgə atsə̀ꞌə̀ ŋ̀kwerə miꞌì mi ghu, m̀betə nìi mə, “A gho aa a ghɔ̀ɔ̂ wò? Twi ŋû yìi mə à ghɔ̀ɔ gho aà!” ");
INSERT INTO bfd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bo lɛ ŋkɨ mbu nswoŋ ɨnnù jî ghàꞌàtə̀ m̀bəgɨtə yi ghu. ");
INSERT INTO bfd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Àbɛ̀ɛ̀ a fùꞌù mə̂ bɨ̀tà bɨ alaꞌa nɨ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì a bɔ̀ꞌɔ nɨ ŋgǎŋndɨ̀ꞌɨ nɔ̀ŋsə̀ boòntə̀, bɨ lɔgə̀ Yesu ǹzi nɨ ghu a nsi ŋgǎŋndasaꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bo betə̀ ghu mbo mə, “Ò laa mbə Àyɔꞌɔ̀ Nwì wa aa ɛ? Bɛɛ ò bə aa ghu, ò swoŋ bìꞌì yuꞌù!” A kwiꞌi mə, “Mə̀ tɛ̀ꞌɛ swoŋ a mbo bù boŋ kaa nɨ̀ sɨ̀ biì. ");
INSERT INTO bfd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kə̀ m̀bə mə̀ tɛꞌɛ mbetə ghu nɨ̂ àbetə boŋ mbə kaa nɨ̀ waꞌà kɨ̀ ŋ̀kwiꞌi. ");
INSERT INTO bfd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lâ ǹlɔgɨnə sii, Mu Ŋù à ka tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ Nwì yìi à tswe nɨ mɨ̀dàꞌà aa nî màꞌà.” ");
INSERT INTO bfd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bo bɨtsɨ̀m bɨ betə̀ mə, “Ma la a bə mə ò nɨ Mu Nwì aa ɛ?” A kwiꞌi mə,“Nɨ̀ swòŋ mə!” ");
INSERT INTO bfd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bo tɨgə̀ ǹswoŋ mə, “Kaa bìꞌì sɨ bɨ̂yəfə bi dàŋ bu nlɔ̀ɔ̀! Tsiꞌì bìꞌì, bìꞌì yùꞌù mə yìꞌi ŋgaa annù yìi mə à swǒŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ǹnɔ̀ɔ̀ bə̂ bya bɨ̀tsɨ̀m ɨ bɨɨ̀nə̀ ǹlɔgə Yesu ŋ̀ghɛɛ mfa a mbo Pilato ");
INSERT INTO bfd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ǹlɔ̀gɨ̀nə̀ ŋ̀ka nɨŋ ɨnnù ghu nû: “Bìꞌì lɛ ntswa mbâ ghû a buurə̀ nɨ̂ àlaꞌa, ǹswoŋə nɨ a mbo bə̀ mə tâ bo tsuu bɨ̂tâx a mbo Kaisa kɨ tu; ŋ̀kɨɨ nswoŋə nɨ mə yu laa mbə Àyɔꞌɔ̀ Nwì wa yìi à nɨ mfɔ̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato a tɨgə̀ m̀betə yi mə, “Ò bə aa mfɔ̀ baYuda aa ɛ?” Yesu a kwiꞌi mə, “Ò swòŋ mə̂ maa ajàŋə̀!” ");
INSERT INTO bfd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato a bû ǹswoŋ a mbo bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ nnɔ̀ɔ̀ bə̂ wa mə, “Kaa mə̀ sɨ̌ njiꞌì ànnù yìi mə mbə mə̀ nɨ̂ŋ ɨsaꞌa a nu ŋù ghu aa zî.” ");
INSERT INTO bfd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bo bû ŋ̀kweensə nswoŋ tsiꞌì nɨ̀tɨ̀ɨ̀ mə, “Ɨ̀nnù jìi mə a dɨ̀ꞌɨ̀ aa, ɨ ghɨ̀rə̀ mə̂ bə̀ tɨgə̀ ǹyɔŋə mbùùrə̀ nɨ̂ ɨ̀dɨ̀gə̀ a mbùꞌù àlaꞌa Yudea ntsɨ̀mə̀. À lɛ nlɔ̀gɨ̀nə̀ aa a Galilea, à kɨ̀ mə̂ ǹtɨgə nzi faà tsɨ̂tsɔ̀ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato à tɨ̀ mə yuꞌu maa ajàŋ, m̀betə mə, “Ŋù ghuà à nɨ mu Galilea ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","À tɨ̀ mə yuꞌu mə Yesu à lɛ nlò aa wa mbùꞌù àlaꞌa mə Herod à lɛ sɨ saꞌa aa, ǹtoo yi a mbo Herod, yìi mə à lɛ ntswe a Yerusalem maa noò aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod à lɛ ndorɨtə siꞌi a nyə Yesu, ǹloŋ mə à lɛɛ̀ ǹtɛꞌɛ nyuꞌu ɨnnù tsiꞌì tɛ̀tɛ̀ ǹloŋ ŋgaà yì ǹtɨgə nlɔɔ nɨ̂ ǹyə̂ yi aà. À lɛ sɨ waꞌatə nɨ mə Yesu à ka ghɨ̀rə alènsə̀ yî mɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Maa ajàŋ, Herod a tɨgə̀ m̀betə ɨbetə̀ jî ghàꞌàtə̀ a mbo Yesu. Kaa Yesu a waꞌà yî tsu kwiꞌì. ");
INSERT INTO bfd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ bɨ fɛꞌɛ̀ ǹzi ntəə a mbìì, ǹnaŋsə nnɨŋ ɨnnù jî tɨ̀ɨ̀ tɨɨ a nu Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod bo bɨ̀ bɨ̀sogyɛ̀ bi bɨ lɔgɨ̀nə̀ ntɨgə ntsaꞌa nɨ̂ Yesu ŋ̀kɨɨ ŋwyɛ nii; ǹlɔgə atsə̀ꞌə̀ yî sɨgɨ̀nə̀ m̀maꞌa ghu nu, m̀bu ntoo yi fu a mbo Pilato. ");
INSERT INTO bfd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ǹlɔgɨnə maa njwi, Herod bo Pilato bo boònsə̀ ǹtɨgə mbə ɨkaꞌa, ǹloŋ mə à lɛ tɨ bəə aa bo bânə̀. ");
INSERT INTO bfd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato a tɨgə̀ ǹtwoŋ bɨlɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì, bo bɨ̀ bɨ̀saꞌa bɨ alaꞌa bo bɨ̀ bə̀ bya, ");
INSERT INTO bfd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ǹswoŋ a mbo bo mə, “Bù ghɨrə nzì nɨ ŋù ghû ǹswoŋ mə a bùùrə ɨdɨgə. Tsɨ̂tsɔ̀ŋ, mə̀ lèntə̀ mə annù yi faà, a nsi bù, ǹyə mə kaa à sɨ̌ annù ya yì tsu mə bǔ nɨŋə ghu nu aa fànsə̀. ");
INSERT INTO bfd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod à lɛ ŋkɨ nyə mə kaa à sɨ̌ annù yî tsu fânsə̀, m̀bu ntoo yi fu a mbo bìꞌinə̀. Kaa ŋù ghû à sɨ̌ annù yî tsu yìi mə a kuꞌunə mə mbə bɨ zwitə̀ yi ghu aa fànsə̀. ");
INSERT INTO bfd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Maa ajàŋ, mə̀ ka ghɨ̀rə bɨ̀ ghɔɔ yi ntɨgə mmaꞌatə yi tâ à ghɛɛ.” (( ");
INSERT INTO bfd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","À lɛ swoŋ laa nloŋ mə a yi mbə ma mùu njwî ɨ̀kòò aa bə̀ betə a fiꞌisə̀ ŋ̀gàŋàtsaŋ yì m̀fùùrə̀ m̀fa a mbo bo.)) ");
INSERT INTO bfd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ǹnɔ̀ɔ̀ wa tsiꞌì tsɨ̀m ɨ yəꞌə̀ ǹswoŋ mə, “Zwitə yi! Fiꞌisə Barabas, mfa a mbo bìꞌì.” ");
INSERT INTO bfd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Bɨ lɛ nɨŋə Barabas a ndâtsaŋ aa nloŋ mə à lɛ ghɨ̀rə̀ àlaꞌa a buùrə̀, bə̀ tɨgə̀ ǹto ntuu nɨ̂ Kaisa, a kɨ̂ ǹzwitə ŋû.) ");
INSERT INTO bfd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato à lɛ nlɔ̀ɔ̀ mə yu fiꞌisə Yesu; maa ajàŋ, a bû ǹtsaꞌasə nnɔ̀ɔ̀ wâ. ");
INSERT INTO bfd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bo bâŋnə̀ ǹtɔŋnə nswoŋ mə, “Kwèèntə̀ yi! Kwèèntə̀ yi!” ");
INSERT INTO bfd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato a swoŋ a mbo bo a nɨ̂ ŋ̀gaa yìi mə ɨ̀ yweꞌe ji tarə aa mə, “Nɨ lɔ̀ɔ̀ mə bɨ̀ kweentə yi aa a ya? Ànnù yî bɨ yìi mə à bùꞌù aa à nɨ̂ àkə̀ aa ɛ? Kaa mə̀ sɨ̀ ghâ ànnù yìi mə à ghɨ̀rə mə mbə bɨ zwitə̀ yi aa yə̂! Mə̀ ka ghɨ̀rə tâ bɨ̀ ghɔɔ yi mmaꞌatə.” ");
INSERT INTO bfd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lâ bo bû ŋ̀kuꞌusə ntɔŋnə ghaa bə nɨ̀ mɨ̀tɨ̀ɨ̀ ǹswoŋ mə tâ bɨ̀ kweentə Yesu, bo ghɛɛ̀ nɨ̂ m̀bìì ŋ̀ka ntɔŋnə nyweꞌe a noò yìi mə Pilato à lɛ mbii mə bɨ̀ kweentə yi aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato a tɨgə̀ ǹswoŋ mə tâ bɨ̀ ghɨrə annù ya yìi mə bo lɛ sɨ betə aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A fiꞌisə̀ ŋû wa mə bo lɛ sɨ betə aa, wa yìi mə bɨ lɛ nnɨŋ a ndâtsaŋ nloŋ mə à lɛ ŋghɨ̀rə̀ àlaꞌa a buùrə̀, a kɨ̂ ǹzwitə ŋû aà, m̀baŋnə mfa Yesu a mbo bo mə̂ bo ghɨrə ajàŋ yìi mə bo lɛ sɨ lɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bɨ̀sogyɛ̀ bɨ lɛ nlɔ̀gə̀ Yesu ŋ̀ghɛɛ nɨ ghu, bɨ kà mə̂ aa ŋghɛɛ aa, mbòò Simon ŋù Cyrene, yìi à lɛ sɨ kwɛɛ nìi a afɔ̀ aà. Bo lɛ ntswa yi, m̀beꞌesə yi nɨ̂ àbàŋnə̀ bàŋnə̀ Yesu ya, ŋghɨ̀rə̀ a tɨgə̀ ǹyoŋə ghu njɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ǹnɔ̀ɔ̀ bə̂ bî ghàꞌàtə̀ bɨ lɛ sɨ kɨɨ nyoŋə nii; bàŋgyɛ̀ bî mɔꞌɔ bɨ lɛ ntswe a tɨtɨ̀ɨ bo, ǹyəꞌə nɨ̂ Yesu, ǹtɔŋnə mboꞌo tsiꞌì nɨ̀tɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu a bəŋkə̀ yi nyə waa nswoŋ mə, “Bàŋgyɛ̀ bɨ Yerusalem! Nɨ̀ tsee bə̂ gha kɨ yə̀ꞌə̀, nɨ̀ ka nyəꞌə bə̂ ɨ̀bɨɨnû ghuu bo bɨ̀ bɔɔ̀ buu. ");
INSERT INTO bfd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ǹloŋ mə nòò yì mɔ̀ꞌɔ a zì mə bə̀ ka yǐ tɨgə swoŋə nɨ mə, ‘A bɔ̀ŋə ànnù bâŋgyɛ̀ bìi mə bɨ lɛɛ̀ ŋ̀waꞌà nɨ bɔɔ tswə̂ aà, tsiꞌì bìi mə bɨ lɛɛ̀ ŋ̀waꞌǎ bɔɔ bì bɔrə kweꞌe aà, kə̀ kɨ nnɔŋsə aà!’ ");
INSERT INTO bfd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","À nɨ nòò wa mə bə̀ ka yǐ tɨgə swoŋə nɨ a mbo mɨ̀ntaꞌa mə, ‘Wǒ a nu bìꞌì!’ Ɨ kɨɨ swoŋə nɨ a mbo mɨ̀ntaꞌa mì kə̀gə mə, ‘Lɔ̀ꞌɔ̀sə̀ yiꞌi!’ ");
INSERT INTO bfd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ǹloŋ mə m̀bə bɨ ka ŋghɨrə laà nɨ̂ àtì yî fwɛ, boŋ bɨ ka yǐ tɨgə ghɨ̀rə̀ aa mə a kə a noò yìi mə àtì ya a yòò mə̂ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bɨ lɛ ŋkɨ mfiꞌisə ŋgàŋəfànə̀ ji baa a ŋkwèèntə waa bɨ̀ Yesu. ");
INSERT INTO bfd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bɨ ghɛ̀ɛ̀ mə̂ ǹyweꞌe wa adɨgə mə bɨ lɛ sɨ twoŋə nɨ “Àkwɛ̀ɛ atu” aa, ŋ̀kwèèntə̀ Yesu ghu bo bɨ̀ ŋ̀gàŋəfànə̀ jya ji baà, yì m̀fùùrə̀ ghu mbɛ̀ɛ̀ a bô ŋ̀kwàbə̀, yì mɔ̀ꞌɔ ghu mbɛ̀ɛ̀ a bô màꞌà. ");
INSERT INTO bfd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu a swoŋ mə, “Taà, lìꞌìnə ɨfansənnù jyaa! Ǹloŋ mə kaa bo sɨ̌ annù yìi mə bo ghɨ̀rə̀ aa zî aà.” Bɨ lɛ nyàtə ɨtsə̀ꞌə̂ ji a tɨtɨ̀ɨ bo ǹtumə nɨ̂ ɨ̀bìrə̀ ghu. ");
INSERT INTO bfd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bə̀ bya bɨ lɛ ntəə wa adɨgə nyə nɨ̂ ɨ̀nnù jìi ɨ lɛ sɨ fɛ̀ꞌɛ̀ aà; la bɨ̀saꞌa bɨ alaꞌa bɨ baYuda bɨ lɛ sɨ bàŋnə̀ ŋ̀wyɛ nìi nswoŋə nɨ mə: “À lɛ nyweensə nɨ̂ badàŋ, tâ à yweensə ɨbɨɨnû yi la tsɨ̀tsɔ̀ŋə̀ mə m̀bə a bə Àyɔꞌɔ̀ Nwì yìi mə Nwì à lɛ ntsɔꞌɔ aà!” ");
INSERT INTO bfd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bɨ̀sogyɛ̀ bya bɨ lɛ sɨ kɨɨ ŋwyɛ nɨ̂ yi; ǹtɨgə ŋghɛɛ mfa mɨlùꞌù mî tsə̀ꞌə̀ ghu mbô, ");
INSERT INTO bfd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ǹswoŋ mə, “Yweensə ɨbɨɨ nû ghô mə m̀bə ò bə Mfɔ̀ baYuda!” ");
INSERT INTO bfd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bɨ lɛ ŋŋwàꞌànə annù m̀bɛɛ wa atu ati bàŋnə̀ bàŋnə̀ ghu atu mə: “À nɨ M̀fɔ̀ baYuda à ghuà.” ");
INSERT INTO bfd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ŋ̀gàŋàfànə̀ wa yì mɔ̀ꞌɔ a kɨ̂ m̀bəgɨtə Yesu ǹswoŋ mə: “Ò laa waꞌǎ Ayɔꞌɔ̀ Nwì wa bə aa ɛ? Yweensə ɨbɨɨnû gho ŋkɨ nyweensə yiꞌi!” ");
INSERT INTO bfd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yì mɔ̀ꞌɔ wa à bâŋnə̀ ŋ̀wenə yi, ǹswoŋ mə, “Ò sɨ Nwî bɔꞌɔ aa ɛ? Bɨ ghɨrə ntsə̀rə ɨsaꞌa gho aa a ŋgɨ̌ŋ ŋgɨ̀ŋ tsǒ yi. ");
INSERT INTO bfd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bɨ ghɨrə ntsə̀rə̂ yiꞌiǒ ɨsaꞌa aa ɨ kuꞌùnə̀ nɨ̂ ànnù yìi mə sɨ̀ lɛ ŋghɨ̀rə̀ aà; lâ ŋ̀ghɛɛ nɨ yu, kaa à sɨ̌ annù fânsə̀.” ");
INSERT INTO bfd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A tɨgə̀ m̀bu nswoŋ a mbo Yesu mə, “Ò yi ò waꞌatə̀ gha mbǎ Yesu, wa noò yìi mə ò ka yǐ zì tsǒ m̀fɔ̀ aà!” ");
INSERT INTO bfd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu a swoŋ ghu mbo mə, “Mə̀ swɔ̀ŋə a mbo wò tsiꞌǐ annù nɨ̂koŋ mə, tsiꞌì sìi, ò ka ghɨ̀rə tswe a pàràdisò biꞌiò.” ");
INSERT INTO bfd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nòò à sìꞌì mə̂, ɨ̀tugə ɨ fii ŋkusə alaꞌà tsɨ̀m ŋ̀ghɛɛ nyweꞌe a nɨ nòò ǹyəŋ nòò. ");
INSERT INTO bfd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Àtsə̀ꞌə̀ ya yìi mə a lɛ ŋkwàsə mûm ǹdâmàꞌanwì aa, a lɛ mbòꞌònə̀ a tɨtɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu a tɔŋnə̀ ǹyəꞌə nɨ̂ tɨ̀ɨ̀ ǹswoŋ mə, “Taà, mə̀ nɨ̀ŋ mə azwì ya a mbo wò!” À swòŋ mə̂ laà, ǹtɨgə ntsɨɨ. ");
INSERT INTO bfd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Àtu bɨ̀sogyɛ̀ ya a yə̀ mə annù yìi mə a fɛꞌɛ aa, ŋ̀ghaꞌasə Nwî, ǹswoŋ mə, “Tsiꞌì ànnù nɨ̂ŋkoŋə̀, à lɛ mbə aa ŋû yìi ɨnnǔ ji tsinə!” ");
INSERT INTO bfd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bə̀ bya bɨ̀tsɨ̀m bìi mə bɨ lɛ mbòò a nyə̂ ànnù yìi mə à lɛ mfɛ̀ꞌɛ̀ aa, bɨ lɛ nlò ntɨgə ŋkwɛɛ waa a ndùgə bo, ŋ̀wɛtə mbô myaa nloŋ mə mɨ̀ntɨɨ̀ myaa lɛ nluu nɨ̂ àjəŋnə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ nzi Yesu aa, bo bɨ̀ bàŋgyɛ̀ bya mə bɨ lɛ nlǒ a Galilea ǹyoŋə yi aa, bɨ lɛ ntəə a sàꞌa aghaꞌa nyə annù ma yâ. ");
INSERT INTO bfd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ŋù yî mɔ̀ꞌɔ à lɛ ntswe ghu, ɨ̀kǔm yi ɨ bə Joseph, m̀bə ŋû yî mɔꞌɔ a tɨtɨ̀ɨ ŋgǎŋndasaꞌa, m̀bə ŋù yî sɨ̀gɨ̀nə̀ yìi mə ànnù yi lɛ ntsinə, bə̀ kɨɨ mbɔꞌɔ nìi. ");
INSERT INTO bfd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kaa à lɛ ŋwaꞌǎ annù ya mə bɨ lɛ ntsə̀rə̀ ŋ̀kɨ ghɨrə aa, biì. À lɛ nlǒ a alaꞌa Arimathea, a mbùꞌu Yudea, ǹyuꞌutə nɨ̂ ànnù nɨ̀fɔ̀ Nwî. ");
INSERT INTO bfd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","À lɛ ntɨgə ŋghɛɛ a mbɛ̀ɛ Pilato, m̀betə aku Yesu ya mə yu lɔ̀gə ɨ ghɛ̀ɛ twiŋə. ");
INSERT INTO bfd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ǹtɨgə nsɨgɨsə akû yi ya a nsyɛ, ǹlɨm nɨ̂ àtsə̀ꞌə̀ yî fùꞌù yî sɨgɨ̀nə̀, ŋ̀ghɛɛ nnɨŋ yi a mum nɨ̀syɛ̀ nìi mə à lɛ ntoŋ a mum alâŋsə ŋgɔ̀ꞌɔ̀, kaa bɨ burə̀ tɨ̀ ŋû ghu twiŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ǹjwi mà yû ɨ̀ lɛ mbə aa njwi yìi bə̀ lɛ sɨ naŋsə nɨ̂ ǹjoo nloŋ mə njwîŋgɔ̀ŋ ɨ̀ lɛ ntɨgə ŋkuꞌu aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bàŋgyɛ̀ bya mə bɨ lɛ nlǒ a Galilea ǹyoŋə Yesu aa, bɨ lɛ ŋghɛ̀ɛ̀ bo bɨ̀ Joseph, ǹyə nɨsyɛ̀ nya mə bɨ lɛ nnɨŋ aku Yesu ghu aa bo bɨ̀ àjàŋ yìi bɨ lɛ nlə̀ə̀ yi aà. ");
INSERT INTO bfd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bo lɛ ntɨgə ŋkwɛɛ ŋghɛɛ a ndùgə̀, ǹtaŋtə mɨghurə mì lùmtə̀ nɨ̂ ǹjoo aghɔ̀ꞌɔ̀ ŋ̀ghɛɛ a nɔꞌɔ ɨ̀bɨɨnû Yesu wa ghu. À bə̀ mə̂ wa njwîŋgɔ̀ŋ bo mɨɨ̀ntə̀, a ajàŋ yìi mə nɔ̀ŋsə̀ à lɛ ndɨ̀ꞌɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","À lò mə̂ m̀bə tsiꞌǐ a tɨ̀tugə a mbàꞌa mbàꞌà a njwî yì ǹtsyàmbìì a mûm ŋ̀gyà bàŋgyɛ̀ bya bɨ fɛꞌɛ̀ ŋ̀ghɛɛ wa ntsù nɨsyɛ̀, bo kà mə̂ aa ŋghɛɛ aa, ntugɨtə mɨghurə mì lùmtə̀ mya mìi bo lɛ nnaŋsə aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bo ghɛ̀ɛ̀ mə̂, ǹyə mə bɨ tìì mə̂ ŋ̀gɔ̀ꞌɔ̀ ya mə ɨ̀ lɛ ntswe wa ntsù nɨsyɛ̀ aa nlɔ̀ꞌɔ̀sə̀. ");
INSERT INTO bfd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bo lɛ ntɨgə ŋkuu ŋghɛɛ wa a mûm nɨ̀syɛ̀ la kaa waꞌǎ aku Yesu ya ghu yə̂. ");
INSERT INTO bfd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bo lɛ ntɨgə mbu mfɛ̀ꞌɛ̀ ǹtəə wa adɨgə, ànnù a tsyâ waa. Bo tə̀ə̀ mə ntɨgə ŋwaꞌa nɨ̂ ànnù ma yû aa, m̀bâŋnə̀ ji baa jìi mə ɨ lɛ ŋwɛꞌɛ ɨtsə̀ꞌə̀ jî fùꞌù jìi mə ɨ lɛ sɨ ŋwèènə̀ tsiꞌì ŋ̀wèènə̀ aa, ɨ wiꞌìkə̀ ǹzi ntəə a mbɛ̀ɛ bo. ");
INSERT INTO bfd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nɨ̀bɔꞌɔ nì wè nɨ tswâ bâŋgyɛ̀ byâ, bo tɨgə̀ ŋ̀wo nsɨgɨtə a nsi mbâŋnə̀ jyâ; bo betə̀ waa mə, “Nɨ lɔ̀ɔ̀ ŋû yìi mə à tswe ntɨ̀ɨ̀ a tɨtɨ̀ɨ bɨ̀ku bɨ bə̂ aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wa kaa à sɨ̀ faà mə tswə̂; à bɨ̀ɨ̀nə̀ mə a nɨwô. Nɨ̀ sɨ̌ annù ya yìi mə à lɛ nswoŋ a mbo bù wa noò mə à lɛ ntswe a Galilea aa burə kɨ waꞌatə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","À lɛ nswoŋ mə, ‘Bɨ tswe nɨ̀ m̀fa Mu Ŋù a mbo bə̀ bî bɨ̂, tâ bɨ̀ kweentə yi a ati bàŋnə̀ bàŋnə̀, lâ tâ à bu mbɨ̀ɨ̀nə̀ fu a nɨwo a nɨ̂ ǹjwi ji tarə̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bàŋgyɛ̀ bya bɨ yùꞌù mə̂ laà, ǹtɨgə mbɔŋ ŋwaꞌatə annù ma ya yìi mə Yesu à lɛ ntɛꞌɛ nswoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ǹtɨgə nlo wa ntsù nɨsyɛ̀ m̀bu mbɨ̀ɨ̀ ǹswoŋ ɨnnù tsɨ̀m a mbo ŋgǎŋyəgə̂nnù Yesu jya nɨ̀ghûm ǹtsò mɔ̀ꞌɔ bo bɨ̌ a mbo àbùgə̀ bə̂ bi mɔꞌɔ̂. ");
INSERT INTO bfd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bàŋgyɛ̀ ma bû, à lɛ mbə aa, Mary Magdalene, nɨ Joanna, abɔ̀ꞌɔ nɨ Mary ǹdè bɨ̀ Jɛms. Bo ma bû nɨ bàŋgyɛ̀ bî mɔꞌɔ bìi mə bɨ lɛ ntswe bo bo aa, lɛ ntɨgə nswoŋ ɨnnù ma jû a mbo Ŋ̀gǎŋntoo Kristo jya. ");
INSERT INTO bfd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lâ bo bâŋnə̀ ǹlentə ɨnnù jya mə bàŋgyɛ̀ bya lɛ nswoŋ aa tsǒ ɨ̀tɨ̀rə̀ ɨ̀nnù, kaa waꞌa waa biì. ");
INSERT INTO bfd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lâ Peta a bɨɨ̀nə̀ ŋ̀ka ŋkhə tsiꞌì khə̀, ŋ̀ghɛɛ wa nɨsyɛ̀; ŋ̀ghɛɛ nsɨgɨtə nlii ghu mum, nyə tsiꞌì ɨ̀tsə̀ꞌə̀ jî fùꞌù jya mə bɨ lɛ twiŋ yi ghu aà. Ǹlo ǹtɨgə mbu ŋka mbɨɨ nìi fu, atû yi a burə̀ m̀burə nloŋ annù ya yìi mə a lɛ mfɛ̀ꞌɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tsiꞌì maa njwi, ŋgǎŋyəgə̂nnǔ Yesu ji baa ɨ lɛ sɨ ghɛ̀ɛ̀ a nɨkurə nǐ mɔ̀ꞌɔ mə bɨ lɛ sɨ twoŋə nɨ Emmaus aà; a nlǒ a Yerusalem ɨ ghɛ̀ɛ kùꞌu a Emmaus à lɛ mbə tsǒ bɨ̀ malə̀ bi sàmbaà. ");
INSERT INTO bfd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bo kà mə̂ aa ŋghɛɛ aa, ntaŋə nɨ̂ ŋ̀gàn ǹloŋ ɨ̀nnù jya jìi ɨ lɛ mfɛ̀ꞌɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bo kà mə̂ aa ntaŋ ŋgàn ya aa, Yesu yumbɔŋ a zì bo bo tɨgə̀ ŋ̀ghɛnə, ");
INSERT INTO bfd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nwì à lɛ ŋkɨ̌ŋ miꞌì myaa mə tâ bo tsuu zi mə à nɨ yu. ");
INSERT INTO bfd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A betə̀ mə, “Nɨ zìnə̀ ǹtaŋə nɨ̂ ŋ̀gàn ǹswoŋə aa mə akə aa ɛ?” Bo tɨgə̀ ǹtəə nɨ̂ àjəŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ŋù nɨ̀bò waa yî mɔ̀ꞌɔ, ɨ̀kǔm yi ɨ bə Cleopas, a betə̀ yi mə, “Ò bə aa ŋ̀gɨ̀ɨ̀ a Yerusalem mə ò sɨ̌ annù yìi mə a kɨ̀ fɛ̀ꞌɛ ghu a nɨ mɨ̀tugə mɨ njwi mulà zi aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A betə̀ waa mə, “Làꞌa annǔ akə aa ɛ?” Bo kwiꞌi ghu mbo mə, “Ànnù ǹloŋə Yesu mu Nazareth wa, mə à kɨ̀ bə ŋgàŋntoò Nwì, ŋ̀ghɨrə nɨ̂ ɨ̀nnù jî wè ŋ̀kɨɨ nswoŋə nɨ̂ ɨ̀nnù jî wè a nsi miꞌi Nwì bo bɨ̀ bə̀. ");
INSERT INTO bfd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì biꞌi bo bɨ̀ bɨ̀saꞌa bɨ alaꞌa bɨ kɨ̀ fa yi, bɨ tsərə̀ ɨ̀saꞌà yi mə tâ à kwo, ŋ̀kweentə yi a ati bàŋnə̀ bàŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bìꞌì lɛ sɨ waꞌatə nɨ mə a ka yǐ tsuꞌu yu ɨ tsuꞌu atu baIsrael. À bə̀ mə njwi ji tarə ajàŋ mə yulà ànnù a kɨ̀ fɛ̀ꞌɛ aa. ");
INSERT INTO bfd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A mbu ŋghɛ̀ɛ̀ ghu, bàŋgyɛ̀ bî mɔꞌɔ a tɨtɨ̀ɨ bìꞌì bɨ swoŋ annù yî mɔꞌɔ a tsyâ yiꞌi. Bo ghɨrə ŋghɛ̀ɛ̀ wa ntsù nɨsyɛ̀ a tɨ̀tugə a mbàꞌa mbàꞌà, ");
INSERT INTO bfd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kaa ŋkɨꞌɨ̌ akû yi ghu yə̂. M̀bu mbɨ̀ɨ̀ ǹtɨgə nswoŋə nɨ mə ǹjə̀ə̀ təə təə ɨ̀ ghɨ̀rə nlɛ waa bo yə̂ baangel bɨ swoŋ a mbo bo mə à tswêntɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bə̀ bî mɔꞌɔ a tɨtɨ̀ɨ bìꞌì kɨ̂ ŋ̀ghɛɛ wa ntsù nɨsyɛ̀ ŋ̀kɨ nyə tsiꞌì wa ajàŋ mə bàŋgyɛ̀ bya ghɨrə nswoŋ aa, la kaa waꞌǎ Yesu bâŋnə̀ ǹyə.” ");
INSERT INTO bfd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","A swoŋ a mbo bo mə, “Nɨ̀ tsɨŋtə aà àkə̀ bə laà aa ɛ? Kaa mbə nɨ̀ waꞌà kɨ̀ ŋ̀waŋsə mbii ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi ŋgǎŋntoo Nwì ɨ lɛ nswoŋ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A lɛ ŋwaꞌa bə aa mə Kristo wa à tswe nɨ̀ ǹyə̂ ŋ̀gɨꞌɨ a nɨ ma juù ɨ̀nnù ɨ kuu a mûm nɨ̀ghaꞌa yu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A tɨgə̀ ǹlɔgɨnə a nɨ̂ àŋwàꞌànə Moses, nɨ̂ ŋ̀ŋwàꞌànə ŋgǎntoo Nwì tsɨ̀m, ǹtɔꞌɔtə ɨnnù jìi mə bɨ lɛ ŋŋwàꞌànə̀ a mûm àŋwàꞌànə Nwî tsɨ̀m ǹloŋ ŋgaà yì aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bo ghɛ̀ɛ̀ mə̂ ŋ̀kuꞌu wa nɨkurə nìi bo lɛ sɨ ghɛ̀ɛ̀ ghu aa, a ghɨrə̀ tsiꞌì tsǒ yu ka kɨ ghɛ̀ɛ̀ nɨ̂ m̀bìì, ");
INSERT INTO bfd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","bo tswâ yi nswoŋ ghu mbo mə, “Lɛ biꞌinə̀ ǹloŋ mə nòò ŋ̀kwɛ̂fɔ̀ à kùꞌù mə̂, nòò a tsyâ aà.” A tɨgə̀ ŋ̀kuu bo bo tswê. ");
INSERT INTO bfd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nòò yìi bo bo kà mə̂ aa njɨ aa, a lɔgə̀ àbaa, nnɨŋ mbɔɔnə ghu, mbatə mfa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Miꞌì myaa ŋaꞌanə̀ bo zi mə à nɨ yu Yesu, a wiꞌìkə̀ m̀bwɛ yi. ");
INSERT INTO bfd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bo tɨgə̀ ǹswoŋə bo nɨ bo mə, “Mɨ̀ntɨɨ̀ miꞌinə̀ ghɨrə mbaa kɨꞌɨ̀ khɨ̂ wâ noò mə a ghɨ̀rə̀ ŋ̀ghaa a mbo bìꞌinə̀ a mânjì, ǹtɔꞌɔtə nɨ nɨ̀ghàà nɨ Nwî aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bo bɨɨ̀nə̀ tsiꞌì maa noò m̀bɨɨ ŋghɛ̀ɛ̀ fu a Yerusalem, ŋghɛɛ ntsiꞌi ŋgǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò mɔ̀ꞌɔ bo bɨ̀ bə̀ bìi bo bo lɛ tswe aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bo swoŋ a mbo bo mə, “Wa Mmàꞌàmbi à bɨ̀ɨ̀nə̀ mə̂ tsiꞌì ànnù nɨ̂ŋkoŋə̀, à zì mə̂ ǹdɨꞌɨ ɨbɨɨ nû yi a mbo Simon.” ");
INSERT INTO bfd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bo lɛ ŋkɨ ntɨgə nswoŋ ɨnnù jya mə ɨ lɛ mfɛ̀ꞌɛ a mânjì aa, bo bɨ̀ àjàŋ mə bo lɛ mbù ǹzi yi wâ noò mə à lɛ mbàtə abaa ya mfa a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Àjàŋ mə bo lɛ mburə kɨ ghàà aa, Yesu yumbɔŋ a wiꞌikə̀ ǹtəə a tɨtɨ̀ɨ bo ((ǹswoŋ mə, “M̀bɔɔnə a mbo bù”)). ");
INSERT INTO bfd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bo lɛ ntsɨ̀gɨ̀nə̀, nɨ̀bɔꞌɔ nɨ tswâ waa, bo waꞌatə̀ mə bo yə aà ŋ̀kû. ");
INSERT INTO bfd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu a betə̀ a mbo bo mə, “Nɨ bɔꞌɔ aa àkə̀ aa ɛ? Àlɨ̀gɨ̀tə̀ a burə a mɨ̂ntɨɨ bù aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yə̂ nɨ̌ mbô ma bo bɨ̀ mɨ̀kòrə̂ mâ. Yə̂ nɨ̌ mə à nɨ tsiꞌì mə̀. Mɔ̀ɔ̀ntə nɨ̀ gha boŋ nɨ̀ ka zi, ǹloŋ mə kaa ŋ̀ku à sɨ̀ nɨ̂ ǹjyǎnu bo bɨ̀ ɨ̀kwɛ̀ɛ̀ tswê tsiꞌì tsǒ mə nɨ̀ yə mə̀ tswê nɨ ju aà.” ");
INSERT INTO bfd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","À lɛ nswoŋ maa ajàŋ aa ndɨꞌɨ mbô mi bo bɨ̀ mɨ̀kòrə̂ mi a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nɨ̀dorə lɛ nluu a ntɨɨ bo siꞌi siꞌi bo waꞌa mə à laà mmɨrə mbə annù aa ɛ! Yesu a betə̀ waa mə, “Nɨ̀ tswe nɨ̀ àyoò tsu faà a njɨ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bo fa fɨ̀bwɛ̀ fî làà ghu mbo, ");
INSERT INTO bfd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a kwɛrə ŋkurə a nsi bo. ");
INSERT INTO bfd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ǹswoŋ a mbo bo mə, “Tɨgə àa tsiꞌì ɨ̀nnù jya mə mə̀ lɛ nswoŋ a mbo bù wa noò mə bìꞌinə̀ lɛ ntswe aà. Ŋ̀gɔ̀ŋ ɨ̀nnu tsɨ̀m jìi mə bɨ ŋwaꞌanə nloŋ ŋgaà yà a mûm àŋwàꞌànə Moses, nɨ̂ ŋ̀ŋwàꞌànə ŋgǎŋntoo Nwì nɨ bɨ̀Psalm aa, ɨ tswe nɨ̀ m̀fɛ̀ꞌɛ mbòòntə̂.” ");
INSERT INTO bfd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A tɨgə̀ ŋ̀ŋaꞌa mɨ̂ntɨɨ̀ myaa, ànnù Nwî a naŋsə̀ ǹlaa a atu bo. ");
INSERT INTO bfd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A swoŋ a mbo bo mə, “Bɨ lɛ ŋŋwàꞌànə̀ aa mə, Àyɔꞌɔ̀ Nwì à ka yǐ yə ŋgɨꞌɨ, ɨ yweenə nɨ nɨ̀wo a nɨ̂ ǹjwi ji tarə̂. ");
INSERT INTO bfd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tâ bɨ̀ tɨgə swoŋə nɨ̂ ànnù Nwî ŋ̀kɛꞌɛnə nɨ mə tâ bə̀ bəŋkə mɨ̂ntɨɨ̀ myaa, tâ Nwì à liꞌinə ɨfansənnù jyaa nɨ̂ Ɨ̀kǔm yi, ǹlɔgɨnə a Yerusalem ŋ̀ghɛɛ nyweꞌe a ɨtoo ɨtoò. ");
INSERT INTO bfd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wa nɨ̀ nɨ bɨ̂yəfə nɨ̂ ɨ̀nnù ma jû. ");
INSERT INTO bfd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mə̀, nɨ̂ àtu ɨbɨɨ nû gha, mə ka too a ayoo ya mə Taà ghà à lɛ ŋkàꞌà mə a ka yǐ sɨgə kuu a nu bù aà. Lâ nɨ̀ ka lɨ̀gɨ̀nə tswe a njɔ̀ꞌɔ̀ àlaꞌa kɨ bɛ ɨ yweꞌe noò yìi mə àdàꞌà a ka lô a aburə ɨ sɨgə ɨ kuu a nu bù aà.” ");
INSERT INTO bfd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu a lɔgə̀ waa bo bo fɛꞌɛ̀ wa njɔ̀ꞌɔ̀ àlaꞌa ŋghɛɛ nyweꞌe a alaꞌa Bethany, a sâŋtə̀ m̀bô mi, nnɨŋ mbɔɔnə a nu bo. ");
INSERT INTO bfd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","À kà mə̀ aa nnɨŋ mbɔɔnə a nu bo aa, bɨ tɨgə̀ ǹlɔgə yi ŋkɔꞌɔ ŋghɛɛ nɨ ghu a aburə. ");
INSERT INTO bfd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bo tɨgə̀ ŋ̀ghaꞌasə nìi, ntɨɨ̀ waa ɨ luu nɨ̀ nɨ̀dorə, bo tɨgə̀ m̀bù m̀bɨɨ waa fu a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ǹtɨgə ntswe nɨ a ndâmàꞌanwì a ŋgɔ̀ŋ bɨ̀nòò bɨtsɨ̀m, ŋ̀ghaꞌasə nɨ̂ Nwî.");
INSERT INTO bfd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nɨ̀ghàà lɛ ntswe a nlɔ̀gɨ̀nə̂, nɨ̀ghàà ma nû nɨ lɛ ntswe aa bo Nwì a nlɔ̀gɨ̀nə̀. Nɨ̀ghàà nya nɨ kɨ̂ m̀bə Nwî. ");
INSERT INTO bfd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nɨ̀ghàà nyâ lɛ ntswe bo Nwì a nlɔ̀gɨ̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nwì à lɛ nnaŋsə njoò tsɨ̀m ǹtsya aa a njɨ̌m nɨ̀ghàà ma nû. Kaa àyoò tsu a sɨ̀ tswê mə Nwì à lɛ naŋsə tɨ nu. ");
INSERT INTO bfd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ǹtswêntɨ̀ɨ̀ ɨ̀ lɛ sɨ fɛ̀ꞌɛ̀ aa a nɨ nɨ̀ghàà ma nû. Ǹtswêntɨ̀ɨ̀ ya ɨ zî nɨ̂ ŋ̀kàꞌà a mbo bə̀. ");
INSERT INTO bfd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ŋ̀kàꞌà wa ɨ ta a mûm m̀fiì ɨ̀dɨ̀gə̀, lâ kaa m̀fìì ìdɨ̀gə̀ ɨ̀ lɛɛ̀ waꞌà bwɛtə̀. ");
INSERT INTO bfd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nwì à lɛ ntoo ŋû yî mɔ̀ꞌɔ ɨ̀kǔm yi ɨ bə Jɔn. ");
INSERT INTO bfd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","À lɛ nzì a mbə ayəfə nloŋ ŋkàꞌà wâ bo bɨ̀ a nswoŋ ànnù yìi mə yu lɛ nzi nloŋ yi aa, tâ bə̀ bɨ̀tsɨ̀m yuꞌu, ǹtsya ghu njɨ̀m nnɨŋ mɨ̂ntɨɨ̀ myaa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yu yumbɔŋ kaa à lɛ waꞌǎ ŋkàꞌà wa bə̂, lâ ǹzi aa a mbə àyəfə a mbo ŋ̀kàꞌà wâ. ");
INSERT INTO bfd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ŋ̀kàꞌa annù nɨ̂koŋ wa ɨ ghûlà, m̀bə ŋkàꞌà yìi mə ɨ zǐ a mûm m̀bi, ǹta ŋkeꞌetə nɨ̂ bə̀ bɨ̀tsɨ̀mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nɨ̀ghàà nya nɨ lɛ ntswe a mûm m̀bî, la ka mə Nwì à lɛ nnaŋsə njoò tsɨ̀m ǹtsya aa ghu nu aa, kaa m̀bi ɨ waꞌà yi bâŋnə̀ ǹzi. ");
INSERT INTO bfd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","À lɛ nzì a alaꞌa yu, la kaa bə̀ bi bɨ waꞌà yi kwɛrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A mbo bə̀ bìi mə bɨ lɛ ŋkwɛrə yi, ŋkɨ nɨŋ mɨ̂ntɨɨ̀ myaa ghu nu aa, a fâ àdàꞌà mə tâ bo tɨgə mbə bɔɔ bɨ Nwî bî jwě jwe. ");
INSERT INTO bfd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kaa bɨ lɛ waꞌà bɔɔ bɨ Nwî bə aa ajàŋ yìi mə ŋù mɨ̀sɔ̀ŋ a jwe mu a mûm ǹjyǎnu aa, kə̌ ajàŋ yìi mə ŋùmbâŋnə̀ a lɔ̀ɔ̀ aa bə̂, ǹloŋ mə Nwìŋgɔ̀ŋ yumbɔŋ à lɛ ntɨgə ŋghɨrə mə tâ bo bə bɔɔ̀ bî. ");
INSERT INTO bfd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nɨ̀ghàà nya lɛ mbəŋ ntɨgə ŋûmɨ̀sɔ̀ŋ, ǹluu nɨ̂ ɨ̀bɔ̀ŋ bo bɨ̀ ànnù nɨ̂ŋkoŋ, ǹtɨgə ntswe a tɨtɨ̀ɨ bìꞌì. Biꞌì lɛ nyə nɨghaꞌà ni nî ŋ̀wèènə̀, nɨ̀ghaꞌa nìi mə à lɛ ŋkwɛrə a mbo Tà, Nwìŋgɔ̀ŋ, tsiꞌì tsǒ njoŋ Mû yi aà. ");
INSERT INTO bfd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔn à lɛ mbə ayəfə, ǹswoŋə nɨ̂ ànnù ǹloŋ ŋgaà yì, ǹtɔŋnə tsiꞌì nɨ̀tɨ̀ɨ̀ ǹswoŋ nɨ mə, “à nɨ yu wa yìi mə mə̀ lɛ sɨ ghàà a mbo bù ǹloŋ yi, nswoŋə nɨ mə, yu yìi mə a yòŋə a njɨ̌m mə aa, à kɔ̀ꞌɔ̀nə ntsyàtə̀ ghâ, ǹloŋ mə à lɛ mfòò ǹtswe mbɔŋ tâ bɨ̀ jwe ghâ.” ");
INSERT INTO bfd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ǹyoŋə nɨ̂ àjàŋ yìi mə à lùu nɨ̂ ɨ̀bɔ̀ŋ aa, à nɨ̀ŋ mə mbɔɔnə a nu bìꞌinə̀ bɨ tsɨ̀mə̀. M̀fa nɨ̂ m̀bɔɔnə a mbo bìꞌinə̀ a ayòŋnə̀ nɨ àyòŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nwì à lɛ ntsyà aa a mbo Moses m̀fa nɔ̂ŋsə̀ a mbo bìꞌinə̀, lâ ɨ̀bɔ̀ŋ bo bɨ̀ ànnù nɨ̂koŋ a bâŋnə̀ ǹzi aa a njɨ̌m Yesu Kristo. ");
INSERT INTO bfd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kaa ŋù tsù à lɛɛ̀ waꞌà Nwî yə̂. À kɨ mmɛ̌ tsiꞌì ǹjoŋ Mû yì yìi mə, à tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ Taà yì aa, mə à ghɨrə mə tâ bɨ̀ zi yi. ");
INSERT INTO bfd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yulà à nɨ̂ ɨ̀nnù yìi mə Jɔn à lɛ nswoŋ tsǒ àyəfə a noò yìi mə bɨ̀tsyàsə bɨ baYuda bìi mə bɨ lɛ ntswe a Yerusalem bɨ lɛ ntoo ŋ̀gǎŋmàꞌa Nwì jî mɔꞌɔ bo bɨ̀ bɔɔ bɨ Levi mə tâ bɨ̀ ghɛɛ mbetə Jɔn mə, “Ò bə aa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jɔn à lɛ mfa àkwiꞌi a mbo bo a fɛꞌɛ̀ ǹlaa. Ŋ̀ghaa tsiꞌì nɨ̀ ǹsi nɨ̀ ǹsi nswoŋ mə, “Kaa mə̀ sɨ̌ Ayɔꞌɔ̀ Nwì wa bə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bo ghɛɛ̀ nɨ̂ m̀bìì m̀betə yi mə, “Ò tɨgə̀ m̀bə aa wò aa ɛ? Ò bə aa Elijah aa ɛ?” Jɔn a kwiꞌi mə, “Ŋ̀gaŋ kaa, mə̀ sɨ̀ yu bə̂.” Bɨ bû m̀betə yi mə, “Ò bə aa ŋ̀gàŋntoò Nwì wa mə bɨ yuꞌutə aa ɛ?” Jɔn a kwiꞌi mə, “Ŋ̀gaŋ.” ");
INSERT INTO bfd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ŋ̀gǎŋntoo jya ɨ ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ mə, “Tɨgə nswoŋ ŋû yìi mə ò nɨ ghu aà ǹloŋ mə bìꞌì tswe nɨ̀ m̀bɨɨ nɨ̀ àkwiꞌi ŋkɨ̀ɨ̀ a mbo bə̀ bìi mə bɨ too yiꞌi aà. Ò swǒŋ mə akə nloŋ atu ɨbɨ̀ɨnû gho aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jɔn a fa àkwiꞌi a mbo bo nyoŋə nɨ̂ ànnù yìi mə a tswe a mûm àŋwàꞌànə ŋ̀gàŋntoò Nwì Yesaiah aà: “‘Mə̀ nɨ̂ ǹjì ŋù mɔ̀ꞌɔ yìi mə a tɔŋnə a atu ntaꞌa mɨ̀wɛ̀ɛ̀ mɨwɛ̀ɛ̀ ǹswoŋə nɨ mə, Nɨ̀ naŋsə mânjì M̀màꞌàmbî ŋ̀ghɨrə tâ à tsinə!’ ” ");
INSERT INTO bfd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ǹtoo jya mə baFarɨsai lɛ ntoo a mbo Jɔn aa, ");
INSERT INTO bfd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ɨ tɨgə̀ m̀betə yi mə, “M̀bə ò tsuu aa Àyɔꞌɔ̀ Nwì wa bə, ǹtsuu Elijah bə, ǹtuu ŋ̀gàŋntoò Nwì wa kɨɨ bə, ò tɨgə̀ m̀murə nɨ̂ bə̀ a ŋkì aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jɔn a kwiꞌi a mbo mə, “Mə murə bə̂ aa tsiꞌǐ ŋkì, lâ yu wa mə à təə a tɨtɨ̀ɨ bù aa, kaa nɨ̀ sɨ̀ yi zî. ");
INSERT INTO bfd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ka mə à yòŋə a njɨ̌m mə̀ aa, kaa mə̀ sɨ̀ kuꞌùnə̀ mə mbə mə̀ fɛ̀ɛ̀ mɨ̀ŋkɨ̀rə̀ mɨ ntâm mi.” ");
INSERT INTO bfd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ɨ̀nnù ma jû ɨ̀ tsɨ̀m ɨ lɛ mfɛ̀ꞌɛ̀ aa a alaꞌa Bethany, a mbɛ̀ɛ̀ àghəŋə ŋkì Jordan, a njii nsàꞌà nòò, a adɨgə yìi mə Jɔn à lɛ sɨ murə bə̂ ghu a ŋkì aà. ");
INSERT INTO bfd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Àbɛ̀ɛ̀ a kà mə aa mfuꞌu Jɔn a yə̂ Yesu a zî ghu mbɛ̀ɛ̀, a swoŋ mə, “Nɨ̀ yə Mûmbînjə̀rə̀ Nwì wâ, yìi mə a bèꞌe ɨbɨ mbî ǹtsɨ̀mə̀ ǹlɔꞌɔsə aà! ");
INSERT INTO bfd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","À nɨ yu wa yìi mə mə̀ lɛ sɨ ghàà ǹloŋ ŋgaa yì aà, mə, ‘Ŋù mɔ̀ꞌɔ a yòŋə a njɨ̌m mə̀ yìi mə à tsyàtə ghâ, ǹloŋ mə à lɛ ntswe mbɔŋ tâ bɨ̀ jwe gha aà.’ ");
INSERT INTO bfd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tsiꞌì mə̀mbɔŋ kaa mə̀ lɛ waꞌà yi zî, ka mə mə̀ lɛ nzì m̀murə nɨ̂ bə̌ a ŋkì a ŋghɨ̀rə mə tâ baIsrael bɨ̀ zi yi aà.” ");
INSERT INTO bfd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jɔn a ghɛɛ̀ nɨ̂ m̀bìì a mbə ayəfə a nɨ̂ ànnù yìi mə a lɛ mfɛ̀ꞌɛ̀ ǹloŋ Yesu aà: “Mə̀ yə̂ Àzwì Nwî a lô a aburə tsiꞌì tsǒ bugɨrəmɨ̀kuu nsɨgə ntswe ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kaa mə̀ lɛ ŋwaꞌà zi mə à lɛ mbə yu ma wâ, lâ Nwì yìi mə à lɛ ntoo gha mə tâ mə̀ ka murə nɨ̂ bə̀ a ŋkì aa, boŋ à lɛɛ̀ ǹswoŋ a mbo mə̀ mə, ‘Ŋù yìi mə ò yə Azwì Nwì a lo a aburə nsɨgə ntswe ghu nu aa, à nɨ yu wa yìi mə à ka kɨ murə bə̂ aa bə a mûm Àzwì Nwî.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jɔn a tɨgə̀ ŋ̀ghɛɛ nɨ̂ m̀bìì ǹswoŋ mə, “mə̀ yə̀ mə̂, ŋ̀kɨ mbə ayəfə mə à laa mbə Mu Nwì.” ");
INSERT INTO bfd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Àbɛ̀ɛ̀ a lò mə̂ m̀fuꞌu, Jɔn a bû ǹtəə bô ŋ̀gǎŋyəgə̂nù ji ji baa, ");
INSERT INTO bfd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ǹyə Yesu a kâ ǹtsya a swoŋ mə, “Nɨ̀ yə Mû M̀bînjə̀rə̀ Nwì wâ!” ");
INSERT INTO bfd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ŋ̀gǎŋyəgə̂nnù Jɔn jya ji baa bɨ yùꞌù mə̂ a swoŋ ma laà aa, nlo ŋghɛ̀ɛ̀ ntɨgə nyoŋə Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu à kà mə̂ aa ŋkarɨkə, nyə ajàŋ mə bɨ yòŋə̀ nìi aa, mbetə waa mə, “Nɨ lɔ̀ɔ̀ aa àkə̀ aa ɛ?” Bo kwiꞌi ghu mbo mə, “Rabbi” (ǹjiꞌì nɨ̀ghàà ma nû ɨ bə aa Ǹdɨ̀ꞌɨ̀nnù), “o tswe aa a fə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu a kwiꞌi a mbo bo mə, “Nɨ̀ zi nyə.” Bo tɨgə̀ ǹyoŋə yi ŋghɛɛ nyə adɨgə yìi mə à lɛ sɨ tswe ghu aa, bo bo tɨgə̀ ǹsiꞌi maa njwî, ǹloŋ mə à lɛ tɨ bə aa boŋ nòò à tɨgə̂ ǹyəŋə. ");
INSERT INTO bfd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ŋù yì mɔꞌɔ a tɨtɨ̀ɨ bo ma bya mə bɨ lɛ nyuꞌu annù ya yìi mə Jɔn à lɛ nswoŋ a mbo bo aa à lɛ mbə Andrew, muma bɨ̀ Simon Peta. ");
INSERT INTO bfd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew à lò mə̂ a mbɛ̀ɛ Yesu aa, mfòò ǹyə mumaà yì Simon, ǹswoŋ ghu mbo mə, “Bìꞌì yə̀ mə̂ Ayɔꞌɔ̀ Nwì wa.” (Àyɔꞌɔ̀ Nwì a bə aa Kristo nɨ nɨ̀ghàà nɨ Grikia.) ");
INSERT INTO bfd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrew à kà mə aa maŋsə aa, ntɨgə nlɔgə mumaà yi Simon ŋ̀ghɛɛ nɨ ghu a mbo Yesu. Yesu à yə̀ mə̂ yi aa, ǹlii yi a nsi sɨgɨ̀nə̀, ǹswoŋ mə, “ɨ̀kǔm gho à nɨ Simon, mu Jɔn, lâ ǹlɔgɨnə tsɨtsɔ̀ŋ, bɨ ka tɨgə twoŋə nɨ̂ gho nɨ Cephas.” (Cephas ghû à kɨ mbə aa Peta, ǹjiꞌì ɨ̀kùm ghû ɨ̀ bə aa “ŋ̀gɔ̀ꞌɔ̀.”) ");
INSERT INTO bfd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Àbɛ̀ɛ̀ a kà mə̂ aa mfuꞌu, Yesu a taŋtə̀ a ŋghɛ̀ɛ a Galilea. À kà mə aa ŋghɛɛ aa, nyə Philip a mânjì, ǹswoŋ ghu mbo mə, “Ka nyòŋə̀ ghâ.” ");
INSERT INTO bfd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip à lɛ nlò aa a Bethsaida, àlaꞌa yìi mə Peta bo Andrew lɛ ŋkɨ mfɛꞌɛ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip a ghɛɛ̀ ǹyə Nathanael, ǹswoŋ gho mbo mə, “Bìꞌì yə̀ mə̂ ŋû wa mə Moses à lɛ ŋŋwàꞌànə̀ ǹloŋ ŋgaa yì a nɨ̂ àŋwàꞌànə̀ nɔ̂ŋsə̀ aà, ŋ̀gǎŋtoo Nwî ɨ kɨ̂ ŋ̀ŋwaꞌanə annù ǹloŋ ŋgaa yì aà. Àa Yesu mu Joseph ŋù Nazareth.” ");
INSERT INTO bfd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael a betə ghu mbo mə, “M̀bə ànnù yî sɨgɨ̀nə̀ yî tsu a fɛꞌɛ̀ a alaꞌa Nazareth aa ɛ?” Philip a kwiꞌi ghu mbo mə, “Zǐ nyə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu à yə̀ mə̂ Nathanael a kâ ǹzi a mbɛ̀ɛ yu aa, a swoŋ nloŋ ŋgaa Nathanael mə, “Nɨ yə mu baIsrael yî ànnù nɨ̂ŋkoŋə̀, yìi mə kaa àbaŋnənnù kaa a sɨ̀ ghu nu tswə̂ aà!” ");
INSERT INTO bfd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael a betə̀ yi mə, “Ò tsyà aa mə akə nzi gha aa ɛ?.” Yesu a kwiꞌi ghu mbo mə, “Mə̀ ghɨrə nyə gho wa noò mə ò ghɨ̀rə ntswe wa a njiꞌì àtǐ figə̀ m̀bɔŋ tâ Philip à zi ntwoŋə gho aà.” ");
INSERT INTO bfd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael a swoŋ gho mbo mə, “Rabbi, wa ò nɨ Mu Nwì! Ò nɨ M̀fɔ̀ baIsrael!” ");
INSERT INTO bfd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu a swoŋ ghu mbo mə, “Ò bii maa ajàŋ aa nloŋ bə mə mə̀ swǒŋ mə mə̀ ghɨrə nyə gho wa noò mə ò ghɨ̀rə ntswe wa a njiꞌì àtì figə̀ aa ɛ? Ò ka yə ɨnnù jî wè jìi mə ɨ tsyatə ma yû!” ");
INSERT INTO bfd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ a mbo bo mə, “Mə swoŋ tsiꞌì ànnù nɨ̂koŋ a mbo bù mə, nɨ̀ ka yə tâ àbùrə̀ à ŋaꞌanə, tâ baangel bɨ Nwî tâ bɨ̀ ka ŋkɔꞌɔ ŋkɨɨ nsɨgə a nu Mu Ŋù.” ");
INSERT INTO bfd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ǹjwî ɨ tsyà mə ji baa, nɨ̀yɔꞌɔ nɨ tswê a Cana a alaꞌa Galilea. Ǹdè bɨ̀ Yesu à lɛ ntswe wa adɨgə nɨyɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bɨ lɛ ŋkɨ ntwoŋə Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnû ji ma mùu adɨgə nɨyɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bɨ nò mə̂ mɨlùꞌù mìi mɨ lɛ ntswe wa adɨgə nɨyɔꞌɔ aa màŋsə̀, ǹdè bɨ Yesu a swoŋ ghu mbo mə, “Kaa bo sɨ̀ nɨ mɨ̀lùꞌù bû ǹtswe.” ");
INSERT INTO bfd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu a kwiꞌi ghu mbo mə, “Màŋgyɛ̀, kaa ò sɨ̀ nɨ̂ ǹswoŋə̂ ànnù yìi mə mə̀ ka ghɨ̀rə̀ aa tswê. Kaa nòò ghà à burə tɨ̀ kùꞌù.” ");
INSERT INTO bfd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ǹdè bɨ̀ Yesu a swoŋ a mbo bə̀ bìi mə bɨ lɛ sɨ jɛꞌɛ nɨ̂ bə̀ wa adɨgə nɨyɔꞌɔ aa mə, “Bɛɛ a swoŋə annù yìi mə à swòŋ aa, nɨ̀ ghɨrə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bàntɔ̀ɔ̀ bìi mə bɨ lɛ naŋsə nɨ̂ ŋ̀gɔ̀ꞌɔ̀ aa, bɨ lɛ ntəəntə ghu; àntɔ̀ɔ̀ wa yì m̀fùùrə̀ a burə̀ m̀faŋ mbə ajàŋ yìi mə mbə ŋ̀kì ɨ kuu ghu bɨ̂gallon tsiꞌì tsǒ mɨ̀ghum mi mbaa, kə̀ mɨ̀ghum mi ntarə mbɔŋ nluu. Ǹloŋ mə annù Nwî baIsrael a tswe nɨ̀ bɨ̀nɔ̀ŋsə̀ nloŋ ajàŋ yìi mə bɨ sìꞌìtə nû jyaa aà. ");
INSERT INTO bfd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu a swoŋ a mbo bə̀ bya mə bɨ lɛ sɨ jɛꞌɛ nɨ̂ bə̀ aa mə, “Lwensə nɨ̀ bântɔ̀ɔ̀ bù nɨ̂ ŋ̀kì!” Bo lwensə̀ bântɔ̀ɔ̀ bya nɨ̀ ŋ̀kì ɨ kɔꞌɔ nluu ntɨgə nlərə. ");
INSERT INTO bfd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A bû ǹswoŋ a mbo bo mə, “Tsɨ̂tsɔ̀ŋ, tuꞌutə̂ nɨ̀ ŋ̀kì wa yǐ mɔꞌɔ ŋghɛ̀ɛ̀ m̀fa nɨ̀ a mbo ŋù yìi mə a taŋtə nɨyɔꞌɔ nù aà.” Bo tɨgə̀ ǹtuꞌutə nlɔgə ŋghɛ̀ɛ̀ m̀fa ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A yweꞌetə̀ ŋ̀kì wâ, yìi mə a tɨ bə aa boŋ ɨ bə̀ŋ mə̂ ǹtɨgə mɨlùꞌù aà, ǹyweꞌetə, kaa waꞌǎ adɨgə yìi mə mɨ̀lùꞌù mya mɨ lo ghu aa zî (lâ bə̀ bya mə bɨ lɛ ntuꞌu ŋkì wa aa lɛ nzi). À ywèꞌètə̀ mə̂, ǹtwoŋə ndoo mûŋgèn wa ");
INSERT INTO bfd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ǹswoŋ ghu mbo mə, “Bɨ fòò m̀fa aa mɨ̀lùꞌù mìi mə mɨ naŋsə mbɔ̀ŋ aa mə tâ bɨ̀ no, bɛɛ mə bə̀ ghɨrə naŋsə nno nyurə, bɨ tɨgə̀ m̀bɔŋ lɔ̀gə̀ mìi mə mɨ sɨ̀ naŋsə̀ m̀bɔŋ aa nzì nɨ mu. Lâ ò ghɨ̀rə̀ mə̂ m̀baŋnə nlə̀ə̀ mɨlùꞌù mìi mə mɨ bɔŋ mbɔ̀ŋ aa, mbɔŋ ntɨgə zì nɨ mu bə tsɨ̀tsɔ̀ŋ!” ");
INSERT INTO bfd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu à lɛ ŋghɨ̀rə alènsə̀ ma yû, mə a lɛ mbə alènsə̀ yi yî ǹtsyambìì aa, a Cana, a alaꞌa Galilea. À lɛ ghɨ̀rə̀ ma yuà àlènsə laa ndɨ̀ꞌɨ̀ nɨghaꞌà ni, ŋ̀gǎŋyəgə̂nnù ji ɨ nɨŋ mɨ̀ntɨɨ̀ myaa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma yû a tsyà mə̂, Yesu, nɨ̂ ǹdè yì nɨ bɔɔ bɨ maà bi bi mbâŋnə̀, a bɔ̀ꞌɔ nɨ̂ ŋ̀gǎŋyəgə̂nnù ji, lô ǹsɨgə ŋghɛɛ a Kapernaum, ǹtswe ghu njwi jì tsu mbɔŋ bǔ lǒ kɔꞌɔ ghɛ̀ɛ̀ a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ǹjwî ǹjɨ Passa baYuda ɨ̀ lɛ ntɨgə a abô, Yesu a tɨgə̀ ǹlo ŋkɔꞌɔ ŋghɛɛ a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","À kɔ̀ꞌɔ̀ mə̂, ŋ̀kuu ŋghɛɛ a mûm ǹdâmàꞌanwì, ǹyə bə̂ bɨ feè nɨ̂ nàà, nɨ̂ m̀binjə̀rə̀ nɨ bɨ̀bugɨrəmɨ̀kuù ghu; ŋ̀gǎŋkwensə ŋkabə ɨ kɨ̂ ǹtswe ghu yaa ŋgaa nɨ̂ ŋ̀kabə̀ yàà a atu ɨtɛtə̀. ");
INSERT INTO bfd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu a ghɛɛ̀ ǹlɔɔ mɨ̂ndɨgə, ntwɛɛ, ŋghɨrə aŋkaàntə̀ ghu, ŋ̀ghɛɛ mfurə naà jya ghu mə tâ ɨ̀ fɛꞌɛkə wa a ndâmàꞌanwì. M̀furə mbinjə̀rə̀ jya bo bɨ̀ ǹnàà jya, ǹtii ɨtɛtə̌ ŋgǎŋkwensə ŋkabə jya mmàꞌànə̀, ǹjaꞌa ŋkabə yàà yâ. ");
INSERT INTO bfd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ǹswoŋ a mbo bə̀ bya bìi mə bɨ lɛ sɨ fèə̀ nɨ bɨ̀bugɨrəmɨ̀kuu aa mə, “Nɨ̀ lɔgə mfɛ̀ꞌɛ̀ nɨ bu! Nɨ̀ tsuu tɨgə ghɨ̀rə tâ ǹdâ Taà tɨgə adɨgə mɨtaa!” ");
INSERT INTO bfd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ŋ̀gǎŋyəgə̂nnù ji ɨ yə̀ mə annù yìi mə Yesu à lɛ ŋghɨ̀rə̀ aa, ŋwaꞌatə ànnù yìi mə a tswe a mûm àŋwàꞌànə̀ Nwî aa mə, “Taà Nwìŋgɔ̀ŋ, mə̀ nàŋsə ŋkɔ̀ŋə annǔ ndâ yô, a tswe a ntɨɨ mə̀ m̀bərə ghu tsǒ mɔꞌɔ!” ");
INSERT INTO bfd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bɨ̀tsyàsə̀ bɨ baYuda bya bìi mə bɨ lɛ ntswe ghu aa, betə̀ Yesu mə, “Àlènsə̀ yìi mə mbə ò ghɨrə̀ a ndɨ̀ꞌɨ a mbo bìꞌì mə ò tswe nɨ̂ àdàꞌà a ŋghɨ̀rə ànnù yuà yìi mə ò ghɨ̀rə aa, a nɨ yuu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu a kwiꞌi a mbo bo mə, “Sàꞌâ nɨ̌ ndâmàꞌanwì yulà, boŋ mə̀ ka bǔ bɨ̀ɨ̀nsə̀ fu a njɨ̌m njwi ji tarə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bo betə̀ yi mə, “Bìꞌì lɔgə aa ɨ̀lòò mɨghum mi nɨkwà ǹtsò ǹtoꞌo a mbɔɔ ǹdâmàꞌanwì yulà ghu! Ò swoŋ mə mbə ò lɔgə̀ ǹjwi ji tarə a mbǔ mbɨ̀ɨ̀nsə̀ ghu fu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lâ ǹdâmàꞌanwì yìi mə Yesu à lɛ sɨ swoŋ aa ɨ̀ lɛ mbàŋnə̀ m̀bə aa ɨ̀bɨ̀ɨnû yi. ");
INSERT INTO bfd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nòò wa yìi mə Yesu à lɛɛ̀ m̀bɨɨnə nɨwo aa, ŋ̀gǎŋyəgə̂nnù ji ɨ tɨgə̀ ŋ̀waꞌatə mə à lɛ mbaa nswoŋə malâ; ma yû a tɨgə ŋ̀ghɨrə mə tâ bo bii annù yìi mə àŋwàꞌànə̀ Nwî a swoŋ aa, ŋkɨ mbii annù ya yìi mə Yesu à lɛ nswoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nòò wa yìi mə Yesu à lɛ tswe a Yerusalem a njwî ǹjɨ Passa aa, bə̀ bî ghàꞌàtə̀ bɨ lɛ nnɨŋ mɨ̂ntɨɨ̀ myaa ghu nû ǹloŋ mə bo lɛ nyə ɨ̀lènsə̀ jìi mə à lɛ ŋghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lâ Yesu kaa lɛ waꞌǎ ɨbɨɨ nû yi a mbo bo fâ, ǹloŋ mə à lɛ nzi ajàŋ mə bə̀ bɨ̀tsɨ̀m bə aà. ");
INSERT INTO bfd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kaa ŋù tsù à lɛ ŋwaꞌà bù ǹtswe nɨ̂ ǹswòŋə ànnǔ tsu ghu mbo nloŋ ŋûmɨ̀sɔ̀ŋ, ǹloŋ mə à lɛ nzi annù yìi mə a lɛ ntswe a ntɨɨ ŋù ntsɨ̀mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ǹtsyàsə̀ baYuda yî mɔ̀ꞌɔ à lɛ ntswe ghu yìi mə ɨ̀kǔm yi lɛ mbə Nicodemus, a kɨ̂ m̀bə ŋû baFarɨsai. ");
INSERT INTO bfd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","À lɛ nzì a mbɛ̀ɛ Yesu nɨ̂tugə yì mɔ̀ꞌɔ nswoŋ ghu mbo mə, “Rabbi, bìꞌì zi mə ò laa mbə ǹdɨ̀ꞌɨ̀nnù yìi mə Nwì à lɛ ntoo aà. Kaa mbə ŋù waꞌǎ ɨlènsə̀ juà mə o ghɨ̀rə̀ aa ka ŋghɨrə tɨ ghə̂ Nwì à tswe bo yu.” ");
INSERT INTO bfd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu à lɛ ŋkwiꞌi mə, “Mə̀ swoŋ tsiꞌǐ annù nɨ̂koŋ a mbo wò mə kaa mbə ŋù waꞌǎ annù nɨfɔ̀ Nwî yə tɨ ghə bɨ bu ŋkwatə njwe yi.” ");
INSERT INTO bfd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus a betə mə, “Mbə bɨ bû ǹjwe a ndɨɨ yìi mə à kwì mə̂ aa mə akə lɛ? Kaa mbə a waꞌà bù ŋ̀kwatə ŋkuu a toꞌo ǹdè yì tâ bɨ̀ bu njwe yi!” ");
INSERT INTO bfd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu a kwiꞌi mə, “Mə̀ swǒŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo wò mə kaa mbə ŋù tsù a waꞌà a mûm ànnù nɨfɔ̀ Nwî kuu tɨ ghə̌ mə bɨ jwe yì nɨ̂ ŋ̀kì bo Àzwì. ");
INSERT INTO bfd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ŋù yìi mə bɨ jwe yi a mûm ǹjyǎnù aa, à nɨ̂ ǹjyǎnû, lâ ŋù yìi bɨ jwe yi a mûn Àzwi aa à nɨ̂ àzwì. ");
INSERT INTO bfd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tsuu yɛrə mə mə̀ swǒŋ mə bɨ tswe nɨ̀ mbǔ ŋkwatə njwe ghuu bɨtsɨ̀mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fɨ̀fə̀rə̀ a tsyà ŋ̀ghɛɛ aa a adɨgə yìi mə à kɔ̀ŋə aà; a yi tɨ tsyà aa, ò yuꞌù nɨ̀ ŋ̀kòô yì, kaa waꞌǎ adɨgə yìi mə à lo ghu aa, kə̀ adɨgə yìi mə a tsyà ŋ̀ghɛɛ ghu aa zî. A kɨ mbə aa tsiꞌì maa ajàŋ nɨ ŋù yìi mə Àzwì a jwe yi aà.” ");
INSERT INTO bfd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus a betə mə, “M̀bə ajàŋə annù ma yû a fɛꞌɛ̀ aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu a kwiꞌi mə, “Ò nɨ̂ ŋ̀gàŋndɨ̀ꞌɨnnù baIsrael yî ŋ̀wè kaa waꞌà ma juù ɨ̀nnù zi aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mə̀ swǒŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo wò mə, bìꞌi swoŋ aa annù yìi mə bìꞌì zi, ŋ̀kɨɨ ŋkɛꞌɛnə nɨ̂ ànnù yìi mə bìꞌì yə aa, kaa ŋù nɨ̀bù kaa waꞌà kɔ̀ŋə̀ nɨ̂ ǹyuꞌu ǹtoò yìꞌì yâ. ");
INSERT INTO bfd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","M̀bə mə̀ ka nswoŋ ɨnnù jìi mə ɨ tswe fàa mbi aa, nɨ̀ tsuu bii, boŋ mbə nɨ̀ tɨgə̀ mbii ɨ̀nnǔ aburə jìi mə mə swoŋ aa mə akə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kaa ŋù tsù à lɛɛ̀ ŋ̀waꞌà yi a aburə kɨ ŋkɔꞌɔ, ǹtsyatə Mu Ŋù, yu wa yìi mə à lɛ nlò a aburə nsɨgə aà.” ");
INSERT INTO bfd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tsǒ mə Moses à lɛ lɔ̀gə no ya mə bɨ lɛ ŋghɨ̀rə̀ nɨ̂ àtɨ̀ɨ̀ ŋ̀kɔꞌɔ mbɛnə a atu ati a ntaꞌa mɨwɛ̀ɛ̀ aa, a nɨ̂ àjàŋ yìi mə bɨ ka yǐ kɨɨ ŋŋɛɛ Mu Ŋù a ndəŋə, ");
INSERT INTO bfd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mə tâ ŋù tsɨ̀m yìi mə à nɨ̌ŋ ntɨɨ̀ yi ghu nu aa, tâ à tswe nɨ̂ ǹtswêntɨ̀ɨ̀ yìi me ɨ̀ lwìꞌi nɨ̂ŋkoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ǹloŋ mə Nwìŋgɔ̀ŋ à lɛ ŋkɔ̌ŋ mbi siꞌi siꞌi, m̀fa njoŋ Mû yì yî mɔ̀ꞌɔtə, mə ŋù ǹtsɨ̀m yìi mə à nɨ̌ŋ ntɨɨ̀ yi ghu nu aa, tâ à yi ntsee lǒ kwo, lâ m̀baŋnə ntswe nɨ̂ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌi nɨ̂ŋkoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kaa Nwì à lɛ ŋwaꞌǎ Mû yì fàa mbi too aa mə tâ à zi ŋka saꞌa mbî, à lɛ ntoo aa mə tâ à zi nyweensə mbî. ");
INSERT INTO bfd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ŋù yìi mə à nɨ̌ŋ ntɨɨ̀ yi a nu Mu Nwì aa kaa bɨ sɨ̌ ɨsaꞌa ghu nu nnɨŋə̀; lâ ŋù yìi mə kaa à sɨ̌ ntɨɨ̀ yì ghu nu nɨŋə aa, bɨ nɨ̀ŋ mə ɨsaꞌa ghu nû, ǹloŋ mə kaa à sɨ̌ ntɨɨ̀ yì a nu njoŋ Mu Nwì wa nɨŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ɨ̀saꞌa ɨ kuu a nu bə̀ aa laà: Mə ŋ̀kàꞌà ɨ zì mə̂ a mûm m̀bi, la bə̀ bâŋnə̀ ŋ̀kɔŋ ɨtugə ǹtsyatə ŋkàꞌà, ǹloŋ mə bo ghɨ̀rə ɨnnù jî bɨ aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ŋù ǹtsɨ̀m yìi mə a ghɨ̀rə ɨnnù jî bɨ aa, a bàa ŋkàꞌà, kaa waꞌà kɔ̀ŋ nɨ̂ m̀fɛ̀ꞌɛ nzǐ a mbɛ̀ɛ̂ ŋ̀kàꞌà, ǹloŋ mə kaa à sɨ kɔ̀ŋə̀ mə tâ bɨ̀ yə ɨnnù jî bɨ̂ ji jya aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lâ ŋù yìi mə a ghɨ̀rə ɨnnù nɨ̂ŋkoŋ aa, a fɛ̀ꞌɛ̀ ǹzi nɨ a mbɛ̀ɛ̂ ŋ̀kàꞌà mə tâ bɨ̀ naŋsə nyə mə yu ghɨ̀rə ɨnnû ji nyuꞌunə aa Nwì. ");
INSERT INTO bfd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu à màŋsə̀ mə̂, bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji ŋghɛɛ a mbùꞌu alaꞌa Yudea, bo bo tswe ghu nɨ̂ ǹdùù noò yî mɔꞌɔ, a murə̀ nɨ̂ bə̀ a ŋkì. ");
INSERT INTO bfd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔn à lɛ sɨ kɨɨ mmurə nɨ̂ bə̀ a ŋkì maa noò a alaꞌa Aenon yìi mə a lɛ ntswe ŋkoontə a mbɛ̀ɛ̀ àlaꞌa Salem aa, ǹloŋ mə ŋ̀kì yìi mə ɨ lɛ ntswe maa adɨgə aa ɨ lɛ ŋghaꞌatə. Bə̀ lɛ sɨ tɨgə ŋghɛɛ ghu mbo, a murə̀ nɨ̀ waa a ŋkì. ");
INSERT INTO bfd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Maa noò kaa bɨ burə̀ tɨ̀ Jɔn a atsaŋ nɨŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Maà noò ŋ̀gǎŋyəgə̂nnù Jɔn ɨ lɛ ŋka nswuŋnə bo bɨ̀ ŋù baYuda yî mɔ̀ꞌɔ nloŋ ajàŋ mə nɔ̀ŋsə̀ baYuda à lɛ nlə̀ə̀ mə bɨ̀ ka nsiꞌitə nû aà. ");
INSERT INTO bfd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bo màꞌàtə̀ mə̂ ŋû wa, ntɨgə nlo ŋghɛ̀ɛ a mbɛ̀ɛ Jɔn, ǹswoŋ ghu mbo mə, “Rabbi, ŋù wa mə bǔ yu lɛ ntswe a mbɛ̀ɛ ŋkì Jordan, a mbɨ̌ nsàꞌa nòò aà, mə ò lɛ ŋka nswoŋə nɨ̂ ànnù ǹloŋ ŋgaà yì aa, a tɨgə mmurə nɨ̂ bə̀ a ŋkì tsɨ̂tsɔ̀ŋə̀, bə̀ bɨ̀tsɨ̀m bɨ tɨgə̀ ŋ̀ghɛɛ ghu mbô!” ");
INSERT INTO bfd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jɔn a kwiꞌi mə, “Kaa mbə ŋù a waꞌà nɨ̂ ànnǔ tsu tswê tɨ ghə̌ mə a lo aa a aburə. ");
INSERT INTO bfd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bù bumbɔŋ nɨ̀ laa mbə bɨ̂yəfə bâ, a ajàŋ mə mə̀ lɛ nswoŋ mə, ‘Kaa mə sɨ̀ Ayɔꞌɔ̀ Nwì wa bə̂. La bɨ lɛ ntoo gha aa mə tâ mə̀ tsya mbìì yì.’ ");
INSERT INTO bfd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mûŋgèn à tswe aa a mbo ndoo mûŋgen, lâ ǹsûkàꞌa ndoo mûŋgèn wa yìi mə à təə ghu mbɛ̀ɛ̀ ǹyuꞌu a ghaà aa, a dorɨtə nɨ a nyuꞌu ǹjì ndoo mûŋgèn wâ. Maa ajàŋ nɨ̀dorə̀ nâ nɨ kɨ̀ mə̂ ǹluu. ");
INSERT INTO bfd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ǹloŋ mə nɨ̀ghaꞌà ni nɨ tswe nɨ̀ ŋ̀ka ŋghɛ̀ɛ̀ nɨ̂ m̀bìì tâ mə̀ baŋnə ŋka mbɨntə nɨ a njɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nɨ̀ghaꞌa nɨ ŋû yìi mə à lo a aburə nsɨgə aa, nɨ tsyatə nî bə̂ bɨ̀tsɨ̀mə̀. Ŋù yìi mə à lo fàa nsyɛ aa, à tswe aa fàa nsyɛ̂, ŋ̀kɨɨ nswoŋ aa ɨ̀nnù jìi mə ɨ tswe fàa nsyɛ aà, lâ ŋù yìi mə à lo a aburə nsɨgə aa, à tsyàtə bə̀ bɨ̀tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A swoŋə aa ɨ̀nnù jìi mə à yə ŋkɨ yuꞌu aà, lâ kaa tsiꞌì ŋù yì m̀fùùrə̀ kaa a waꞌà nɨ̂ ǹtoò yì ya kwɛrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lâ ŋù yìi mə à kwɛ̀rə ntoo yì ya mbii aa, a dɨ̀ɨ̀ntə̀ aa mə Nwì a swoŋ aa annù nɨ̂ŋkoŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ŋù wa yìi mə Nwì à lɛ ntoo aa, a swoŋə aa nɨ̀ghàà nɨ Nwî, ǹloŋ mə Nwì a naŋsə nlwensə nìi nɨ̂ Àzwî yi kaa waꞌà lɨŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nwì a kɔ̀ŋə Mû yì. À kɨ̀ mə̂ ǹnɨ̀ŋ ɨ̀nnù tsɨ̀m ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ŋù yìi mə à nɨ̌ŋ ntɨɨ̀ yì a nu Mu Ŋù aa, à tswè mə̂ nɨ̂ ǹtswêntɨ̀ɨ̀ ya yìi mə ɨ̀ lwìꞌi nɨ̂ŋkoŋ aà. Ŋù yìi mə à sɨ yi yuꞌunə aa, kaa à ka yǐ waꞌà nɨ̂ ǹtswêntɨ̀ɨ̀ tswê, ǹtɔ̀ŋ Nwî ɨ̀ ka yǐ kɨ lwi ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","BaFarɨsai bo lɛ nyuꞌu mə bə̀ bî ghàꞌàtə̀ lɛ sɨ yòŋə̀ nɨ̂ Yesu, a kɨɨ̀ m̀murə nɨ̂ bə̀ bî ghàꞌàtə̀ nɨ a ŋkì ǹtsyatə nɨ̂ Jɔn ");
INSERT INTO bfd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(A nsswoŋə ànnù nɨ̂ŋkoŋ, kaa Yesu à lɛ ŋkɨꞌɨ̀ nɨ̌ ŋû tsù a ŋkì murə̀. A lɛ sɨ murə tsiꞌì ŋ̀gǎŋyəgə̂nnù ji murə nɨ̂ bə̀ a ŋkì.) ");
INSERT INTO bfd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Àjàŋ mə Yesu à lɛ yuꞌu bɨ kâ ǹswoŋə maa ajàŋ aa, a màꞌàtə̀ àlaꞌa Yudea ŋ̀ghɛɛ fu a Galilea. ");
INSERT INTO bfd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","À lɛ ntswe nɨ̂ ǹtsyà aa nɨ̂ àlaꞌa Samaria a ŋghɛ̀ɛ ghu. ");
INSERT INTO bfd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","À ghɛ̀ɛ̀ mə̂ ŋ̀ka ntsya a alaꞌa Samaria, ŋ̀kuu a nɨkurə Sychar, nìi mə nɨ lɛ ŋkòòntə a mbɛ̀ɛ nsòò wa yìi mə Yakob à lɛ mmàꞌàtə̀ a mbo mû yì Joseph aà. ");
INSERT INTO bfd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ŋ̀kì yî ntǒŋ Yakob wa ɨ lɛ ntswe maa adɨgə. À tɨ̀ mə tɨ bə a nsiꞌi nòò, Yesu a kaa a nɨ nɨ̀təə nya, ǹsɨgɨtə ntswe maa mbɛ̀ɛ̀ ŋ̀kì yî tòŋ ŋ̀ka mɨɨntə. ");
INSERT INTO bfd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Màŋgyɛ̀ Samaria yî mɔ̀ꞌɔ à lɛ nzì a ntuꞌu ŋ̀kì. Yesu a swoŋ ghu mbo mə, “Fa ŋkì a mbo mə tâ mə̀ no.” ");
INSERT INTO bfd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A lɛ tɨ bə aa boŋ ŋ̀gǎŋyəgə̂nnù ji ɨ kùù mə̂ ŋ̀ghɛɛ a mûm nɨ̀kurə a nyuu mɨ̀jɨ ghu. ");
INSERT INTO bfd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Màŋgyɛ̀ wa a kwiꞌi ghu mbo mə, “Ò nɨ ŋù baYuda, mə̀ bə ŋù baSamaria, ò tɨgə̀ ǹlɔɔ ŋkì a mbo mə̀ aa mə akə aa ɛ?” À lɛ nswoŋ laa nloŋ mə baYuda bo bɨ̀ baSamaria kaa bo lɛ sɨ waꞌà jɨnə aà. ");
INSERT INTO bfd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu a kwiꞌi ghu mbo mə, “Ò ghɨrə baa zi ayoo yìi mə Nwì a fa aa, ɨ kɨɨ zi ŋû yìi mə a betə ŋkì a mbo wò aa, boŋ ò laa mbetə yi mə tâ à fa ŋkǐ ntswêntɨ̀ɨ̀ mbo wò.” ");
INSERT INTO bfd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Màŋgyɛ̀ wa a kwiꞌi ghu mbo mə, “Taà, kaa ò sɨ̀ nɨ̂ àbɔkɛ tswê, ŋ̀kì yî tòŋ ghû ɨ kɨ̂ ǹtso siꞌi, ò ka lɔ̀gə ŋkǐ ntswêntɨ̀ɨ̀ aa fə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ɨ ŋkì yî tòŋ ghû aa a lɛ mfa Ta bɨ̀ taà yìꞌì, Yakob a mbo bìꞌì, yumbɔŋ nɨ bɔɔ̀ bi, a bɔ̀ꞌɔ bɨ̀ nàâ ji, bo lɛ nno ŋkì ghû. O lɔ̀ɔ̂ ǹswǒŋ mə ò kɔ̀ꞌɔ̀nə ntsyà a taà yìꞌì Yakob aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu a kwiꞌi ghu mbo mə, “Ŋù yìi mə à no ŋkì ghûlà aa, ǹjì ŋ̀kì ɨ̀ ka yǐ bǔ yaŋə yi. ");
INSERT INTO bfd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lâ, ŋù yìi mə à no ŋkì yìi mə mə̀ ka fa ghu mbo aa, kaa ǹjì ŋ̀kì ɨ̀ ka yǐ waꞌà yi bû ǹyaŋə. Ŋ̀kì wa yìi mə mə̀ ka fa ghu mbo aa, ɨ ka bəŋ ɨ tɨgə naŋəbɨrə ghu nu, ɨ tɨgə jwe nɨ̂ ŋ̀kì yìi mə ɨ fa nɨ̂ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌi nɨ̂koŋ aa ghu mbô.” ");
INSERT INTO bfd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Màŋgyɛ̀ wa a kwiꞌi ghu mbo mə, “Taà fa ŋkì ma wa a mbo mə̀; tǎ tâ ǹjì ŋ̀kì ɨ̀ yi ŋwaꞌà gha bù ǹyaŋə, tâ mə̀ waꞌà faà bû ŋ̀ka nzi a ntuꞌu ŋ̀kì.” ");
INSERT INTO bfd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu a swoŋ ghu mbo mə, “Ghɛ̀ɛ ntwoŋə ndoò ghò tâ bu yu zi.” ");
INSERT INTO bfd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A kwiꞌi a mbo Yesu mə, “Kaa mə̀ sɨ̀ nɨ̂ ǹdoo tswê.” Yesu a swoŋ ghu mbo mə, “Ò swòŋ aa tsiꞌì ànnù nɨ̂ŋkoŋ mə kaa ò sɨ̀ nɨ̂ ǹdoo tswê. ");
INSERT INTO bfd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ò yɔ̀ꞌɔ̀ mə̂ aa mbâŋnə̀ ji ntaà, lâ ŋùmbâŋnə̀ yìi mə bù yu tswe tsɨtsɔ̀ŋ aa, kaa à sɨ̌ ndoò ghò bə̂. Ò swòŋ aa tsiꞌì ànnù nɨ̂koŋ a mbo mə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A swoŋ a mbo Yesu mə, “Taà, mə̀ yə̂. Ò nɨ ŋgàŋntoò Nwì. ");
INSERT INTO bfd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bɨ̀tà bɨ bɨ̂taà biꞌi a Samaria, bɨ lɛ sɨ ghaꞌasə Nwî aa fàa atu ntaꞌa laà, lâ bù baYuda, nɨ̀ swoŋ mə bɨ ka ŋghaꞌasə Nwî aa tsiꞌì a Yerusalem.” ");
INSERT INTO bfd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu a swoŋ ghu mbo mə, “Bii annù yìi mə mə swoŋ aa mba mâŋgyɛ̀. Nòò à ka yǐ kùꞌù mə kaa nɨ ka yǐ waꞌǎ Taà aa fàa a atu ntaꞌa bù ŋ̀ka ŋghaꞌasə, kaa waꞌǎ aa a Yerusalem kɨɨ mbu ŋghaꞌasə. ");
INSERT INTO bfd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bù baSamaria, kaa nɨ̀ sɨ̌ ŋû yìi mə nɨ ghaꞌasə aa naŋsə̀ ǹzi. Lâ bìꞌì baYuda, bìꞌì zi ŋû yìi mə bìꞌi ghaꞌasə aà ǹloŋ mə annǔ nyweensə̂ m̀bi a tsyà aa a njɨ̌m baYuda ǹzi. ");
INSERT INTO bfd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lâ nòò a kùꞌù ǹzi, kə̀ à kùꞌù mə̂, mə, bə̀ bìi mə bɨ naŋsə ŋ̀ghàꞌàsə̀ Nwì aa, bɨ ka yǐ tɨgə ghaꞌasə Ta aa a mûm Àzwì, ɨ kɨ ghaꞌasə nii aa tsiꞌǐ annù nɨ̂ŋkoŋə̀. Ma yû a bə̂ m̀buu bə̂ bìi mə Nwì a kɔ̀ŋə mə tâ bɨ̀ ka ŋghaꞌasə nii laà. ");
INSERT INTO bfd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nwìŋgɔ̀ŋ à laa mbə Azwì, mbə bə̀ kɨ̂ ŋ̀ka ŋghaꞌasə yi aa tsiꞌǐ a mûm Àzwì bo bɨ̀ annù nîŋkoŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Màŋgyɛ̀ wa a swoŋ ghu mbo mə, “Mə̀ zi mə Àyɔꞌɔ̀ Nwì wa (mə bɨ twoŋə nɨ Kristo aa) à ka yǐ zì, bɛɛ a zi aa boŋ à ka swoŋ ŋgɔ̀ŋ ɨ̀nnǔ tsɨ̀m a mbo bìꞌì.” ");
INSERT INTO bfd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu a kwiꞌi ghu mbo mə, “À nɨ mə̀, mə̀ ghuà yìi mə ghàà a mbo wò aà.” ");
INSERT INTO bfd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","À tɨ̀ mə tɨ bə maa nòò aa, ŋ̀gǎŋyəgə̂nnù ji jya ɨ bɨɨ̀. Ànnù naŋsə̀ ŋ̀ghaꞌa waa ajàŋ mə bo lɛ nyə Yesu a ghaànə̀ bo màŋgyɛ̀ aà. Lâ, kaa ŋù nɨ̀bò wàà a lɛ ŋwaꞌǎ ntsù yi ŋŋaꞌa a mbetə mə, “O lɔ̀ɔ̀ aa àkə̀ aa ɛ?” Kə̀ ŋ̀kɨ mbetə yi mə, “O ghàà bu yu aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Maà noò, màŋgyɛ̀ wa à lɛ mmàꞌàtə antɔ̀ɔ̀ ŋ̀kî yì wa, m̀bu ŋkuu ŋghɛɛ fu a mûm nɨ̀kurə, ǹswoŋ a mbo bə̀ bìi mə bɨ lɛ tswe ghu aa mə, ");
INSERT INTO bfd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nɨ̀ zi nyə ŋû yì mɔ̀ꞌɔ mə à swǒŋ ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi mə mə̀ lɛɛ̀ ŋ̀ghɨrə fàa atu nsyɛ̀ aà! À laà m̀bə Ayɔꞌɔ̀ Nwì wa aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bo lɛ mmàꞌàtə̀ nɨkurə nya ntɨgə ŋghɛɛ nyə Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Maa noò ŋ̀gǎŋyəgə̂nnù Yesu ɨ lɛ sɨ lətə nɨ̂ Yesu, ǹswoŋə nɨ mə, “Rabbi, bɔɔ njɨ mû àyoò!” ");
INSERT INTO bfd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A kwiꞌi a mbo bo mə, “Mə̀ tswe nɨ̀ mɨ̀jɨ a njɨ mìi mə kaa nɨ̀ sɨ̌ annǔ tsu zi nloŋ mɨjɨ mà myâ.” ");
INSERT INTO bfd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ŋ̀gǎŋyəgə̂nnù ji ɨ lɔgɨ̀nə̀ ǹtɨgə mbetə nɨ̂ waa bo nɨ bo mə, “Ŋù tsù à ghɨ̀rə̂ m̀bàâ ǹzi mfa mɨjɨ ghu mbo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu a swoŋ a mbo bo mə, “Mɨ̀jɨ̂ ma à nɨ̂ ŋ̀ka yuꞌunə annù yìi mə ŋù yìi à tòo gha aa a lɔ̀ɔ̀ aà; ŋ̀kɨ mbə mmàŋsə ɨfàꞌà yìi mə à fa a mbo mə̀ mə mə̀ faꞌa aà. ");
INSERT INTO bfd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nɨ̌ swoŋə nɨghàà nî mɔꞌɔ mə, ‘Bɨ̀sàŋ bɨ burə bi nɨkwà tâ bɨ̀ fuꞌu mɨjɨ̂.’ Lâ, mə̀ swǒŋ a mbo bù mə nɨ̀ ŋɛntə miꞌì muu, nlii mɨ̂nsòò ghu. Mɨ̀jɨ mɨ bè mə̂, nòò m̀fùꞌu a kuꞌù. ");
INSERT INTO bfd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ŋù yìi mə a fùꞌù mɨjɨ aa, bɨ twu nìi, a ghotə̀ nɨ̀ mɨ̀jɨ mya nloŋ aà ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌi nɨ̂ŋkoŋ aà. Ma yû a bə mə ŋù yìi mə a bè mɨjɨ aa, bo ŋù yìi mə a fùꞌù aa, bo dorɨtə bɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nɨ̀ghàà nulà nɨ swoŋ aa tsiꞌì ànnù nɨ̂ŋkoŋ mə, ‘Ŋù yî mɔ̀ꞌɔ a bě, ŋù yî mɔ̀ꞌɔ a bâŋnə̀ m̀fuꞌu.’ ");
INSERT INTO bfd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mə̀ tòo ghuu mə tâ nɨ̀ ghɛɛ mfùꞌù mɨjɨ nɨ̂ mɨ̀nsòò mìi mə kaa nɨ̀ lɛ ŋwaꞌà ghu faꞌà. Â lɛ mfàꞌà badàŋ ghu. Nɨ̀ ka tɨgə jɨ abìi afàꞌâ yaa.” ");
INSERT INTO bfd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","BaSamaria bî ghàꞌàtə̀ maa mûm nɨ̀kurə lɛ nnɨŋ mɨ̂ntɨ̀î myaa a nu Yesu, ǹloŋ mə màŋgyɛ̀ wa à lɛ nswoŋ mə, “À ghɨ̀rə nswoŋ ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi mə mə̀ lɛɛ̀ ŋ̀ghɨrə fàa a atu nsyɛ aà.” ");
INSERT INTO bfd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","BaSamaria bya bɨ zì mə̂ ǹyə yi aa, mbuꞌu mbo mə tâ Yesu à tswe bo bo. Yesu a tswê bo bo njwi ji baà. ");
INSERT INTO bfd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bə̀ bî ghàꞌàtə̀ kuꞌùsə̀ nɨŋ mɨ̂ntiɨ̀ myaa ghu nu nloŋ ntoo yìi mə à lɛ sɨ swoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ǹtɨgə nswoŋ a mbo màŋgyɛ̀ wa mə, “Bìꞌì bii tsɨ̀tsɔ̀ŋ aa kaa waꞌà bù ǹyoŋ aa bə nɨ̂ ànnù ya mə ò ghɨ̀rə nswoŋ aà, bìꞌì bii aa nloŋ mə ɨ̀tu bɨ̀ɨnû yiꞌi, bìꞌì yùꞌù mə̂ nɨghàâ ni, ǹnaŋsə nzi mə à laa mbə ŋgàŋyweensə̂ m̀bî.” ");
INSERT INTO bfd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ǹjwi jya ji baa ɨ tsyà mə̂, Yesu a bû m̀maꞌatə ŋghɛ̀ɛ a Galilea. ");
INSERT INTO bfd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ǹloŋ mə yumbɔŋ à lɛɛ̀ ǹswoŋ mə, “Kaa bɨ sɨ̌ ŋgàŋntoò Nwì a mûm àlaꞌa bo ghuꞌusə.” ");
INSERT INTO bfd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","À zì mə̂ ŋ̀kuu a Galilea, bə̀ kwɛrə̀ yi tsiꞌì sɨgɨ̀nə̀ ǹloŋ mə nòò yìi mə bo lɛ ŋghɛ̀ɛ̀ a adɨgə Passa a Yerusalem aa, bo lɛ nyə ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi mə à lɛ ŋghɨrə maa noò Passa aà nloŋ mə bobɨmbɔŋ, bo lɛ ŋkɨ ŋghɛɛ ghu. ");
INSERT INTO bfd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Maa noò Yesu bû m̀bɨ̀ɨ̀ fu a Cana, a mbùꞌu Galilea, fya adɨgə mə à lɛ mbəŋ ŋkì ghu ɨ tɨgə̀ mɨ̀lùꞌù aà. Ŋ̀gàŋàfàꞌa gûmnàà yî mɔ̀ꞌɔ à lɛ ntswe a Kapernaum, mû yì a ghɔɔ̀. ");
INSERT INTO bfd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","À yùꞌù mə̂ mə Yesu à lò mə̂ a Yudea ǹzi a Galilea aa, ŋ̀ghɛɛ ghu mbɛ̀ɛ̀ ǹtwoŋə yi mə tâ bo yu ghɛɛ a Kapernaum, tâ à ghurə mû yì wa mə à lɛ sɨ ghɔ̀ɔ̀ ǹtɨgə tsiꞌì a ŋkwo aà. ");
INSERT INTO bfd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu a swoŋ ghu mbo mə, “Kaa mbə ŋù nɨ̀bǒ ghùù a waꞌà bii tɨ̀ ghə̂ mə à yə̂ ɨ̀lènsə̀ bo bɨ̀ ɨ̀nnǔtsyâmbô.” ");
INSERT INTO bfd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ŋ̀gàŋàfàꞌà yî ŋ̀wè wa a bû ŋ̀kuꞌusə nswoŋ ghu mbo mə, “Taà, zǐ sɨ̀ ghɛɛ mbɔŋ tâ mû ghà ghû à kwo.” ");
INSERT INTO bfd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu a swoŋ ghu mbo mə, “Ghɛ̀ɛ̂, wa mû ghò wa à ka tswe ntɨ̀ɨ̀.” A bii nɨ̀ghàà nɨ Yesu nya, ŋghɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nòò yìi mə à lɛ ntswe a mânjì ŋ̀ghɛɛ nɨ a ndùgə yu aa, ŋ̀gàŋàfàꞌa yì a zî m̀boo yi nɨ̂ ŋ̀kɨ̀ɨ̀ mə, “Wa mû ghò wa à tɨ̀ɨ̀ mə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A betə̌ ŋgàŋàfàꞌâ yì wa mə, “À kɨ̀ lɔ̀gɨnə ŋka mfwɛtə aa a noò àkə̀ aa ɛ?” A kwiꞌi ghu mbo mə, “À kɨ̀ bə aa a yɔɔ, a noò yìi mə nòò à kɨ̀ bɔ̀ɔ yə̀ŋtə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ta bɨ̀ mu wa a waꞌatə̌ mə à kɨ̀ bə aa maa àbàŋtə̀ noò mə Yesu à kɨ̀ swòŋə a mbo yu mə, “Wa mû ghò wa à ka tswe ntɨ̀ɨ̀.” Yu bô ŋ̀gwɛ̀ꞌɛ̀ yì, bo tɨgə̀ nɨŋ mintɨɨ̀ myaa a nu Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma yû à lɛ mbə àlènsə ɨnnù yìi mə ɨ yweꞌe ji baa, jìi mə Yesu à lɛ ŋghɨ̀rə̀ a noò yìi mə à lɛ mbù ǹlo a Yudea, ǹzi a Galilea aà. ");
INSERT INTO bfd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma yû a tsyà mə̂, ǹjwî ǹjɨ̂ ɨ̀kòò baYuda ɨ kuꞌù, Yesu a kɔꞌɔ ŋghɛ̀ɛ̀ a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Àtsùmə ntaꞌa yî mɔꞌɔ à tswe a Yerusalem, a kəꞌə̀ Ǹtsǔbùꞌù M̀binjə̀rə̀, ǹtswe nɨ ɨdɨgə ŋkuu ghu jìi mə bɨ lɛ ŋghùrə̀ nɨ̂ ǹtəꞌə aa, ji ntaà. Bɨ twoŋə̀ nɨ̂ ŋ̀kì ma wa nɨ nɨ̀ghàà nɨ baHeber aa nɨ Bethzatha. ");
INSERT INTO bfd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ŋ̀gàŋmɨghɔ̀ɔ̀ jî ghàꞌàtə̀ ɨ lɛ mburə lùù ghu, ǹnɔŋkə nnɔ̀ŋkə̀ wa nɨ̂ mɨ̀ntsù mɨ àbùꞌù myâ, bɨ̀fə̀ꞌə̀nə̀, bɨ̀bwènkə̀, bo bìi mə ɨ̀dɨgə nû jyaa ɨ lɛ ŋkwokə aà. Bɨ lɛ ntswetə ghu nyuꞌutə nɨ mə tâ ŋ̀kì wa ɨ̀ ka njwuꞌu, ");
INSERT INTO bfd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ǹloŋ mə angel M̀màꞌàmbi à lɛ sɨ sɨgə nzi nɨ a ŋgaa ŋgaa ŋkuu ntsɨgə nɨ̂ ŋ̀kì wa ɨ tɨgə njwuꞌu. Ŋù yî ǹtsyàmbìì yìi mə à lɛ nsɨgə ŋkuu wa a mûm ŋ̀kì wa noò mə ɨ lɔ̀gɨ̀nə̀ mə̂ ŋ̀ka jwuꞌu ŋghɛ̀ɛ̀ aa, nɨ̀ghɔ̀ɔ̂ nìi nɨ lɛ ntswe ghu nu aa, kə̀ tɛꞌɛ mbə aa mbuu ghuu, nɨ lɛ mfwɛtə. ");
INSERT INTO bfd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ŋùmbâŋnə̀ yî mɔ̀ꞌɔ à lɛ ntswe ghu mə à lɛ tɨ bə aa boŋ à ghɔ̀ɔ̀ mə̂ a atû ɨ̀lòò mɨghum mi ntarə ntsò nɨ̀fwaa. ");
INSERT INTO bfd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu à yə̂ yi ajàŋ mə à lɛ nnɔ̀ŋ ghu aa, nzi mə ŋùmbâŋnə̀ wa à ghɔ̀ɔ̀ mə̂ àghaꞌa a burə̀ ǹsaꞌa. À yə mə̂ laà, m̀betə ghu mbo mə, “O lɔ̀ɔ̀ mə tâ bɨ̀ ghurə gho aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ŋù nɨ̀ghɔ̀ɔ̀ wa a kwiꞌi mə, “Taà, kaa mə̀ sɨ̀ nɨ ŋù faà tswê mə mbə a nɨŋə̀ gha fàa mûm àtsùm a noò yìi mə ŋkì wa ɨ lɔgɨnə ŋka njwuꞌu aà. Mə̀ yi ŋghə̀ə mə mə kwèꞌètə kɨ kuu ghu aa boŋ ŋù yì dàŋ à bàŋnə̀ mə̂ m̀foo ntsyǎmbìì ŋ̀kuu ghu tɨ mə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu a swoŋ ghu mbo mə, “Bɨ̀ɨ̀nə ntəə mbwɛɛ matà gho wa ŋka ntəə ŋghɛ̀ɛ̀ nòô.” ");
INSERT INTO bfd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ŋùmbâŋnə̀ wa a burə̀ ŋ̀ghɛnsə ntɨ̀ɨ̀ tsiꞌì maà noò, m̀bwɛɛ matà yì wa ntɨgə ntəə nii. Ma yuà ànnù a lɛ mfɛ̀ꞌɛ̀ aa a njwîŋgɔnə̀. ");
INSERT INTO bfd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ma mùu ajàŋ, bɨ̀tà bɨ alaꞌa bɨ baYuda bɨ tɨgə̀ nswoŋə nɨ a mbo ŋu wa mə bɨ lɛ ŋghùrə̀ aa mə, “Sìi à laa mbə njwîŋgɔ̀ŋə̀, kaa nɔ̀ŋsə̀ yìꞌinə̀ à sɨ bii mə tâ ò beꞌe matà gho.” ");
INSERT INTO bfd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A kwiꞌi mə, “Ŋù wa mə à ghɨ̀rə ŋghùrə gha aa, a ghɨ̀rə nswoŋ a mbo mə̀ mə, ‘Bwɛɛ matà ghò wa ŋka ŋghɛ̀ɛ̀ nòô.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bo betə̀ ghu mbo mə, “M̀bâ ma ghû yiì mə à ghɨ̀rə nswoŋ a mbo wò mə tâ ò bwɛɛ a matà gho ŋka ntəə ŋghɛɛ noo laa, à ghɨrə mbə aa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lâ kaa ŋù wa mə bɨ ghɨrə ŋghurə yi aa, kaa waꞌà yi ŋù yìi mə à lɛ mbə ghu aa zî, ǹloŋ mə nnɔ̀ɔ̀ bə̂ lɛ ntswe maa adɨgə, Yesu a tɨgə̀ ǹtsurɨtə yi a tɨtɨ̀ɨ bo mfɛꞌɛ ŋghɛ̀ɛ̀ yi. ");
INSERT INTO bfd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A tɨ bə nɨ a njɨ̀m, Yesu a yə̂ yi a ndâmàꞌanwì ǹswoŋ ghu mbo mə, “Yə ajàŋ mə ò tɨ̀ɨ̀ mə̂ tsɨ̂tsɔ̀ŋ laà aâ! Tsuu ɨnnù jî bɨ bǔ kɨ ghɨ̀rə̀ tǎ tâ ŋ̀gɨꞌɨ yìi mə ɨ̀ bǔ ntsyàtə aa tâ ɨ̀ tsuu gho bǔ tsiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ŋù wa a tɨgə̀ ǹlo ŋghɛ̀ɛ̀ ǹswoŋ a mbo bɨ̀tà bɨ alaꞌa bɨ baYuda bya mə a yi aa a ghɨ̀rə ŋghùrə̀ Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ma yuà ànnù a ghɨrə̀ mə tâ bɨ̀ tɨgə nlɔgɨnə ŋka ntsɔꞌɔ nɨ̂ àkòrə̀ Yesu, nloŋ mə à lɛ ŋghùrə̀ ŋû a njwîŋgɔ̀ŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu a kwiꞌi ambo bo mə, “Taà ghà a fàꞌà tsiꞌǐ ŋgɔ̀ŋ bɨnòò bɨ̂tsɨ̀m, nyi nyweꞌe siì, mə̀mbɔŋ, mə kɨɨ mfaꞌa yaa ŋgaa.” ");
INSERT INTO bfd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ma nuà nɨ̀ghàà nɨ ghɨrə̀ mə tâ bɨ̀tà bɨ alaꞌa bɨ baYuda bya tâ bo bu ŋkùꞌùsə̀ ǹlɨ̀gɨ̀tə nû yàà a nlɔ̀ɔ a nzwitə yu, mbɨꞌɨ mə kaa à lɛ ŋkɨꞌɨ̀ aa tsiꞌì nɔ̀ŋsə̀ ǹjwîgɔ̀ŋ wô, à lɛ ŋkɨ ntwoŋə Nwî nɨ Taà yì, ǹdɨꞌɨ nɨ mə yu bə aa ŋgɨ̌ŋ ŋgɨ̀ŋ bo Nwì. ");
INSERT INTO bfd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu a swoŋ a mbo bo mə, “Mə̀ swoŋ a mbo bù tsiꞌì ànnù nɨ̂ŋkɔŋ mə, kaa annù yî tsu a sɨ̀ ghu tswê mə mbə Mu Ŋù a ghɨ̀rə̀ tsiꞌì nɨ atû yi yumbɔŋə̀, mbə a kɨɨ̀ ŋ̀ghɨrə aa tsiꞌì ànnù yìi mə à yə Taà yì a ghɨrə̀ aà. Ànnù yìi mə Tà a ghɨ̀rə̀ aa, à kɨ mbə tsiꞌì ma ya mə Mû yì a ghɨ̀rə̀. ");
INSERT INTO bfd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ǹloŋ mə Tà à kɔ̀ŋə a Mû yì, ǹdɨꞌɨ nɨ̂ ɨ̀nnù tsɨ̀m jìi mə yumbɔŋ yu ghɨ̀rə̀ aa ghu mbô. À ka ghɛ̀ɛ̀ nɨ̂ m̀bìì a ndɨ̀ꞌɨ ɨnnù jìi mə ɨ bu mburə mbə jî wè jî wè ǹtsyatə a yulà aa, tâ à ka ŋghɨrə, tâ nɨ̀ yə, tâ ànnù a tsya ghuu. ");
INSERT INTO bfd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tsǒ ajàŋ mə Tà a yweensə bɨku bɨ bə̂, m̀fa nɨ̂ ǹtswêntɨ̀ɨ̀ a mbo bo aa, à kɨ mbə ŋgɨ̌ŋ ŋgɨ̀ŋ a ajàŋ mə Mu Nwì a fa nɨ̂ ǹtswêntɨ̀ɨ̀ a mbo bə̀ a ajàŋ mə yu lɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tà yumbɔŋ kaa sɨ̌ ŋû tsù saꞌa, lâ à bàŋnə mfa adaꞌa a mbo Mû yì mə tâ à tɨgə nsaꞌa bə̂ bɨ̀tsɨ̀mə̀ ");
INSERT INTO bfd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tǎ tâ bə̀ bɨ̀tsɨ̀m tâ bɨ̀ tɨgə mbɔꞌɔ nɨ̂ Mu a ŋgɨ̌ŋ ŋgɨ̀ŋ a ajàŋ mə bɨ kɨɨ mbɔꞌɔ nɨ̂ Ta aà. Ŋù ntsɨ̀m yìi mə à sɨ a Mu bɔꞌɔ aa, kaa sɨ Ta wa yi mə à lɛ ntoo yìi aa kɨɨ mbɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mə̀ swǒŋ a mbo bù tsiꞌì ànnù nɨ̂ŋkoŋ mə, ŋù ǹtsɨ̀m yìi mə à yùꞌu nɨghàâ na nnɨŋ ntɨɨ̀ yi a nu yu wa yìi mə à lɛ ntoo gha aa, à tswe nɨ̀ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌi nɨ̂ŋkoŋ aà, kaa bɨ waꞌǎ ɨ̀saꞌa ghu nu nɨŋə̀, la à bàŋǹə̀ mə̂ m̀fɛꞌa ntsǔ nɨwo ŋkuu a mûm ǹtswêntɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mə̀ swǒŋ a mbo bù tsiꞌì ànnù nɨ̂ŋkoŋ mə, nòò à tswe ghu mə a zì, wa à tɛ̀ꞌɛ̀ mə nzi, mə bɨ̀ku bɨ bə̂ ka yǐ yuꞌu njì Mu Nwì, tâ bə̀ bìi mə bɨ yuꞌu aa, tâ bɨ̀ tswe ntɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tsǒ ajàŋə mə Tà yumbɔŋ à tswe nɨ̀ tswêntɨ̀ɨ̀ m̀fa nɨ a mbo bə̀ aa, à kɨ ŋghɨ̀rə̀ mə tâ Mu, yumbɔŋ à tswe nɨ̂ ǹtswêntɨ̀ɨ̀ ŋ̀kɨɨ mfa nɨ a mbo bə̀. ");
INSERT INTO bfd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","À kɨ̀ mə̂ m̀fa adaꞌa ghu mbo mə tâ à ka nsaꞌa nɨ̂ bə̀ ǹloŋ mə à nɨ Mu Ŋù aà. ");
INSERT INTO bfd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nɨ tsuu kɨ yɛrə nloŋ yuà ànnù, ǹloŋ mə nòò a tswe ghu mə a zì, mə bə̀ bɨ̀tsɨ̀m bìi mə bɨ tswekə a mɨsyɛ̀ aa, bɨ ka yi yuꞌu njì yì, ");
INSERT INTO bfd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bɛɛ mə bɨ yuꞌu aa, bɨ fɛꞌɛ̀kə̀ a mɨsyɛ̀. Bya bìi mə bɨ lɛ ŋghɨ̀rə ɨnnù jî sɨgɨ̀nə̀ aa, tâ bɨ̀ bɨɨnə ntswe bɨtɨ̀ɨ̀, tâ bya bìi mə bɨ lɛ ŋghɨ̀rə ɨbɨ aa, tâ bɨ̀ bɨɨnə tâ bɨ̀ nɨŋ ɨsaꞌa a nu bo. ");
INSERT INTO bfd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kaa mə̀mbɔŋ, kaa mbə mə̀ waꞌǎ annù tsu ghɨrə̀ tsiꞌǐ a atu mə̀, mə saꞌa nɨ mɨsaꞌa nyoŋ aa tsiꞌǐ ajàŋ mə Nwì a swoŋə nɨ a mbo mə̀ aà, ma yû a ghɨrə nɨ mə tâ mə̀ ka ntsərə mɨsaꞌa nɨ mânjì yìi mə à kùꞌùnə aà, ǹloŋ mə kaa mə̀ sɨ ghɨ̀rə̀ aa bə annù yìi mə mə lɔ̀ɔ̀ aà, mə ghɨ̀rə aa tsiꞌǐ annù yìi mə yu yìi mə à lɛ ntoo gha aa, a lɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“M̀bə mə̀ ka nswoŋə nɨ̂ ɨ̀nnù ǹloŋ ŋgaa yà mə̂mbɔŋ, a mfɨ̀gɨ̀tə ŋù yìi mə mə̀ nɨ ghu aa, boŋ mbə bɨ tse swoŋ mə kaa annù ya yìi mə mə swoŋə aa kaa a sɨ̌ annù nɨ̂ŋkoŋ bə̂. ");
INSERT INTO bfd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lâ ŋù yî mɔ̀ꞌɔ à tswe ghu mə à nɨ àyəfə nloŋ ŋgaa yà, mə̀ zî nɨ mə annù yìi mə a swoŋə nloŋ ŋgaa yà aa, a nɨ̂ ànnù nɨ̂ŋkoŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bǔmbɔŋ, tɨgə nɨ̀ lɛ mbaa ntoo bə̂ a nu Jɔn, a swoŋə̀ ànnù a mbo bù ǹloŋ annù nɨ̂ŋkoŋə̀? ");
INSERT INTO bfd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kaa a sɨ̀ bə aa bə mə ŋùmɨ̀sɔ̀ŋ à tswe nɨ̀ m̀bə ayəfə nloŋ ŋgaà yà; mə swoŋə laà aa tǎ tâ nɨ̀ yuꞌu nyweenə. ");
INSERT INTO bfd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔn ma ghû a lɛ mbə aa ŋ̀kàꞌà, ŋ̀khɨ, nta, nɨ̀ lɛ ŋka ŋkɔŋə nɨ̂ ǹtswe ŋka ndorɨtə wa a mûm ŋ̀kàꞌa yu a nɨ mû àtɨɨ noò. ");
INSERT INTO bfd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Lâ mə̀ tswe nɨ̀ àyəfə yìi mə a tɨnsə ntsyàtə̌ annù yìi mə Jɔn à lɛ sɨ swoŋə nloŋ ŋgaa yà aà. Mɨ̀fàꞌà mìi mə mə fàꞌà aà, mɨ̀fàꞌà mìi mə Taà ghà à fâ àdàꞌà mə mə̀ ka mfaꞌa ghu aa, ma mû mɨ fɨ̀gɨ̀tə̀ nɨ̂ ŋû yìi mə mə̀ nɨ ghu aà, mə â too Tà ǹtoo ghâ. ");
INSERT INTO bfd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tà yìi mə à lɛ ntoo gha aà, yumbɔŋ à kɨ̀ mə̂ ǹswoŋə annù ǹloŋ ŋgaa yà. Kaa nɨ̀ lɛɛ̀ ŋ̀waꞌǎ njì yì yuꞌù, kaa waꞌǎ nsî yi kɨ nyə. ");
INSERT INTO bfd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kaa nɨghàâ na nɨ sɨ a mûm bù lwiꞌi aa nloŋ mə kaa nɨ̀ sɨ̌ ntɨɨ̀ ghuu a nu yu wa yìi mə à lɛ ntoo aa nɨŋə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nɨ naŋsə nyəgə nɨ̂ àŋwàꞌànə̀ Nwî aa nloŋ mə nɨ mɔ̀ɔ̀ntə̀ nɨ mə à nɨ nu mə nɨ fa nɨ̂ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ tswe nɨ̂ŋkoŋ aa a mbo bù. Lâ a bə nu mə nɨ ghàà ǹloŋ ŋgaa yà aà, ");
INSERT INTO bfd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nɨ̀ bâŋnə ntuu a nzǐ a mbo mə̀ mə tâ mə̀ fa ntswêntɨ̀ɨ̀ a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kaa mə̀ sɨ nɨghaꞌà na aa a mbo bə̀ kwɛrə. ");
INSERT INTO bfd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lâ mə̀ zi ghuu, mə̀ zi mə kaa nɨ̀ sɨ Nwî naŋsə ŋkɔŋə. ");
INSERT INTO bfd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mə̀ zǐ aa nɨ̂ Ɨ̀kùm Taà ghà la kaa nɨ̀ waꞌà gha kwɛrə̀; ŋù dàŋ à bə bàŋnə̌ zǐ nɨ̂ ɨ̀kǔm yi yumbɔŋ boŋ nɨ̀ ka bàŋnə kwɛrə yi. ");
INSERT INTO bfd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bù bìi mə nɨ̂ kɔŋə̀ nɨ ŋ̀kwɛrə nɨghaꞌa bə a mbo bù nɨ bù aa, kaa waꞌà bàŋnə̀ laŋtə nɨ nɨ̀ghaꞌa nìi mə nɨ lò nɨ aa a mbo Nwì yìi mə à kɨ mbə tsiꞌì yù mɛ̀ mɛ aa, m̀bə nɨ tɨgə̀ ǹtsya aa la nnɨŋ ntɨɨ̀ ghuu a nu mə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nɨ̀ tsuu lǒ kɨ mmɔ̀ɔ̀ntə̀ nɨ mə mə̀ ka nɨŋ ghuu a ɨsaꞌa a nsi miꞌi Tà; à nɨ Moses mə à ka nɨŋ ghuu a saꞌà, làꞌà Moses wa yìi mə nɨ̀ bìi yi, ŋwaꞌatə nɨ mə à ka kwɛtə ghuu aà. ");
INSERT INTO bfd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","A lɛ mbaa mbə mə nɨ̀ nàŋsə mbii a Moses boŋ nɨ̀ kɨ mbii ghâ, ǹloŋ mə àŋwàꞌànə̀ yìi mə à lɛ ŋŋwàꞌànə̀ aa, a ghàa annù ǹloŋ ŋgaa yà. ");
INSERT INTO bfd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lâ, m̀bə nɨ̀ tsuu annù yìi mə à lɛ ŋŋwàꞌànə̀ aa ɨ bii, boŋ mbə nɨ tɨgə̀ ǹtsya aa la mbii annù yìi mə mə swoŋə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma yû a ghə̀ mə kɨ tsyǎ, Yesu a toò àtsumə ntaꞌa Galilea, ŋ̀ghɛɛ fìi njii. Bɨ lɛ sɨ kɨɨ ntwoŋə aa nɨ̂ atsùmə ntaꞌa Tiberias. ");
INSERT INTO bfd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ǹnɔ̀ɔ̀ bə̂ yî ghàꞌàtə̀ ɨ lɛ sɨ yòŋə̀ nìi, ǹloŋ mə bɨ lɛ nyə ɨlènsə̀ jìi mə à lɛ sɨ ghɨ̀rə̀ ŋ̀ghurə nɨ mɨ̀ghɔ̀ɔ̀ a nu bə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu a kɔꞌɔ ŋghɛ̀ɛ̀ a atu ntaꞌa nsɨgɨtə ntswe ghu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji. ");
INSERT INTO bfd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nòò ǹjɨ Passa, àdina baYuda ya, à lɛ ŋkòòntə̀. ");
INSERT INTO bfd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu a karɨkə̀ yi, nyə nnɔ̀ɔ̀ bə̂ wa mə ɨ lɛ sɨ yòŋə̀ nìi aa, mbetə Philip mə, “M̀bə bìꞌinə̀ yuu mɨjɨ aà fə̀, ǹjɛꞌɛ bə̂ buà ghu bɨtsɨ̀m aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","À lɛ mbetə maa ajàŋ aa tsiꞌǐ a ŋkwàꞌànə Philip ǹloŋ mə à lɛ nzi annù yìi mə yu tswe nɨ̀ ŋ̀ghɨ̀rə aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip a kwiꞌi mə, “A mbo bìꞌinə̀ a nyuu abaa tâ à kuꞌunə ajàŋ mə mbə ŋù a bɔɔ nyweꞌetə tsiꞌì mû ŋ̀kùgə̀, bìꞌinə̀ ka kɨ lɔ̀ɔ ɨbàꞌatə ŋkabə silva ŋkhɨ̀ ji baa mbɔŋ tâ à kuꞌu.” ");
INSERT INTO bfd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ŋ̀gàŋyə̀gə̂nnù yì yî mɔ̀ꞌɔ, yìi ɨkûm yi ɨ lɛ mbə Andrew, a bə muma bɨ Simon Peta aa, ");
INSERT INTO bfd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","a swoŋ mə, “Mûmbâŋnə̀ yî mɔ̀ꞌɔ à tswe falà nɨ̂ ŋ̀kya abaa mɨsàŋ ji ntaà, nɨ̂ m̀bwɛ̀ mi mbaà. Lâ kaa mbə ma yû waꞌà bə̂ bû bɨtsɨ̀m jɛꞌɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu a swoŋ mə, “Ghɨ̀rə tâ bo tswe a nsyɛ̂.” (Ŋ̀gɛ̀ɛ̀ yî ŋ̀ghàꞌàtə̀ ɨ̀ lɛ ntswe maa adɨgə.) Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntswe a nsyɛ aa, bɨ lɛ mbə mbâŋnə̌ ntsùꞌù ji ntaà. ");
INSERT INTO bfd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu a tɨgə̀ ǹlɔgə abaa ya, ǹtsàꞌàtə̀ Nwî, ǹyatə a mbo bə̀ bya mə bɨ lɛ ntswe a nsyɛ aa, ŋkɨ ghɨrə a ŋgɨ̌ŋ ŋgɨ̀ŋ nɨ̂ m̀bwɛ̀ mya, ŋù ǹtsɨ̀m a jɨ nywurə. ");
INSERT INTO bfd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nòò yìi mə bɨ màŋsə̀ mə a njɨ aa, a swoŋ a mbô ŋ̀gǎŋyəgə̂nnù ji mə, “Nɨ̀ ghotə ǹnwùgə̀ jìi ɨ tɨgə mburə aà, ǹloŋ mə kaa a sɨ̀ bɔ̂ŋ tâ bìꞌinə̀ m̀meꞌe yî tsu.” ");
INSERT INTO bfd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bo lɛ ŋghotə nnwùgə abaa mɨsaŋ jya ŋ̀kya ji ntaà mə bə̀ bya lɛ njɨ aa, ɨ luu ŋ̀kyɛ̀ nɨghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bɨ yə̀ mə alènsə̀ ma yû mə Yesu à lɛ ŋghɨ̀rə̀ aa, ǹtɨgə nswoŋə nɨ mə, “Tsiꞌì ànnù nɨ̂ŋkoŋə̀, à nɨ ŋgàŋntoò Nwì wa mə à lɛ ntswe nɨ̂ ǹzǐ fàa mbi aa à ghulà mə.” ");
INSERT INTO bfd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu à lɛ nzi mə bo lɛ ntswe nɨ̂ ǹzǐ ntswâ yi, ɨ gaansə yi ɨ yɔꞌɔ nɨ̂ m̀fɔ̀, ǹtɨgə mbu ŋkɔꞌɔ yi fu wa atu ntaꞌa tsiꞌì yùyu. ");
INSERT INTO bfd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nòò ŋ̀kwɛ̂fɔ̀ à lɛ ŋkùꞌù ŋ̀gǎŋyəgə̂nnù Yesu jya ɨ bû ǹsɨgə ŋghɛɛ waa fu wa atsùmə ntaꞌà. ");
INSERT INTO bfd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ŋ̀kuu a mûm àkànuꞌu mbu ntoo mbɨɨ fu a mbɛ̀ɛ̀ Kapernaum. Ɨ̀tugə ɨ lɛ mfii tɨ ghə̌ mə Yesu à bù mə̂ ǹzi ntsiꞌi waa. ");
INSERT INTO bfd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A bə maa nòò, àfìsə̀ yî wè a kâ ǹtsya ntsɨ̀gə̀ nɨ̂ ŋ̀kì wâ. ");
INSERT INTO bfd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","A tɨ bə aa lɛ boŋ ŋgǎŋyəgə̂nnù ji jya ɨ kùù mə wa mûm ŋ̀kì ŋ̀ghɛɛ nyweꞌe nɨ bɨ̀kìlo metres bi ntaà kə̀ bi ntoꞌo, ǹyə Yesu a kâ ǹtəə a atu ŋkì ǹzi, à zì mə̂ ka ŋkoontə wa mbɛ̀ɛ àkànuꞌu, nɨ̀bɔꞌɔ nì wè nɨ tswâ waa. ");
INSERT INTO bfd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“Nɨ̀ tsuu kɨ bɔꞌɔ bə̂, wâ à nɨ mə̂,” Yesu a swoŋ a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bo yə̀ mə̂ mə à laa mbə Yesu aa, ntɨgə̀ ǹlɔgə yǐ wa a mûm àkànuꞌu, bo bo tɨgə̀ ŋ̀ghə̀ə kɨ wìꞌìkə̀ ǹyweꞌe wa adɨgə yìi mə bo lɛ sɨ ghɛ̀ɛ̀ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Àbɛ̀ɛ̀ a fùꞌù mə̂, ǹnɔ̀ɔ̀ bə̂ wa mə ɨ lɛ mburə wa njii ŋ̀kì yî mɔ̀ꞌɔ aa ɨ yə mə àkànuꞌu a lɛ ntɨgə ntswe wa adɨgə aa tsiꞌì yì fùùrə̀, ŋ̀kɨ nyə mə kaa Yesu à lɛ ŋwaꞌà wa a mûm àkànuꞌu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji kuù; ǹyə mə ŋgǎŋyəgə̂nnù ji jya ɨ lɛ mbàŋnə̀ ǹtoo ŋghɛɛ waa tsiꞌì bò bo. ");
INSERT INTO bfd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɨ̀kànuꞌu jî mɔꞌɔ ɨ lɛ mbù ǹlo a Tìberias ǹzì a aghəŋə ŋkì, wa mbɛ̀ɛ̀ àdɨgə mə M̀màꞌàmbi à lɛ mfa mbɨꞌɨkə a mbo Nwì, ǹjɛꞌɛ nnɔ̀ɔ̀ bə̂ nɨ̂ àbaa ya ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Àjàŋ mə ǹnɔ̀ɔ̀ bə̂ wa ɨ lɛ waꞌǎ Yesu yə, kaa waꞌǎ ŋgǎŋyəgə̂nnù ji jya kɨ nyə aa, bo lɛ ntɨgə ŋkuu ɨkànuꞌu ma jya nyoŋə a Kapernaum a nlɔ̀ɔ yu. ");
INSERT INTO bfd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bɨ tòò mə̂ ŋ̀ghɛɛ ŋghɛ̀ɛ̀ ǹyə Yesu wa njii yî mɔ̀ꞌɔ aa, ǹswoŋ ghu mbo mə, “Rabbi, ò tsyà aa mə akə ntɨgə bə faà aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu a kwiꞌi a mbo bo mə, “Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə nɨ lɔ̀ɔ̀ nàa laa nloŋ aa abaa ya mə nɨ̀ kɨ̀ kùrə nywurə aà, kaa nɨ̀ sɨ nàa lɔ̀ɔ̀ aa nloŋ mə nɨ̀ kɨ yə̂ àlènsə̀ ya mə mə̀ kɨ̀ ghɨ̀rə aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nɨ̀ tsuu kɨ fàꞌà ǹloŋə aa bə mɨ̀jɨ mìi mə mbə mɨ bɨꞌɨ aa bə̂, nɨ̀ ka mfaꞌa nloŋ bə mɨ̀jɨ mìi mə mɨ lwìꞌi nɨ̂ŋkoŋ aà. Mamû a bə mɨ̀jɨ mìi Mu Ŋù à ka fa a mbo bù aà, ǹloŋ mə Nwìŋgɔ̀ŋ Tà à nɨ̀ŋ mə awenə̀ yi ghu nu, mbeentə yi.” ");
INSERT INTO bfd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bo tɨgə̀ m̀betə yi mə, “M̀bə bìꞌì ghɨrə̀ aa mə akə tǎ kɨ fàꞌa afàꞌà Nwìŋgɔ̀ŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu a kwiꞌi mə, “Àfàꞌà Nwìŋgɔ̀ŋ à nɨ mə tâ nɨ̀ nɨŋ ntɨɨ̀ ghuu a nu yu wa yìi mə yu too aà.” ");
INSERT INTO bfd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bo betə̀ yi mə, “Àlènsə̀ yìi mə ò ka ghɨ̀rə̀ aa, à nɨ yuu, mə mbə bìꞌì yə mbii gho aa ɛ? Ò ka ghɨ̀rə aa àkə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bɨ̀tà bɨ bɨ̂taà biꞌi bɨ lɛ njɨ mana a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ a ajàŋ mə àŋwàꞌànə̀ Nwî a swoŋə nɨ mə, ‘À lɛ mfa abaa yìi mə a lɛ lò a aburə nsɨgə aa a mbo bo.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu a kwiꞌi a mbo bo mə, “Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə kaa a sɨ bə aa mə a lɛ mfa Moses mfa abaa ya mə a lɛ nlǒ aburə nsɨgə aà. A baŋnə mbə aa mə a abaa yìi mə à nɨ̂ àbaa tsiꞌǐ annù nɨ̂ŋkoŋ, ǹlo a aburə aa, a fa Taà gha a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ǹloŋ mə abaa yìi mə Nwì a fa aa, à nɨ yu wa yìi mə à lo a aburə nsɨgə mfa nɨ̂ ǹtswêntɨ̀ɨ̀ a mbô m̀bi aà.” ");
INSERT INTO bfd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bo swoŋ ghu mbo mə, “Taà, tɨgə mfa nɨ̂ àbaa mà ya a mbo bìꞌì a ŋgɔ̀ŋ bɨ̀nòò bɨtsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu a swoŋ a mbo bo mə, “Mə̀ laa mbə abaa ntswêntɨ̀ɨ̀, ŋù yìi mə à zi a mbo mə̀ aa, kaa ǹjì ɨ̀ ka yi waꞌà yi bû ǹyaŋə. Ŋù yìi mə à nɨ̌ŋ ntɨɨ̀ yi a nu mə̀ aa, kaa ǹjì ŋ̀kì ɨ̀ ka yǐ waꞌà yi bû ǹyaŋə. ");
INSERT INTO bfd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mə̀ kɨ̀ baa nswǒŋ a mbo bǔ mə, nɨ̀ yə̀ mə̂ ghâ, la kaa ŋkɨꞌɨ̀ ghuu biì. ");
INSERT INTO bfd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ŋù ǹtsɨ̀m yìi mə Taà a fa a mbo mə̀ aa, à ka zǐ a mbo mə̀. Kaa mbə mə̀ waꞌà ŋû tsù yìi mə a zǐ a mbɛ̀ɛ mə̀ aa furə̀ bə̂. ");
INSERT INTO bfd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ǹloŋ mə kaa mə̀ sɨ̌ aburə lô ǹsɨgə aa a ŋghɨ̀rə à yaà ànnù yìi mə mə lɔ̀ɔ̀ aà. Mə̀ bàŋnə nsɨgə aa a ŋghɨ̀rə ànnù yìi mə yu wa yìi mə à tòo gha aa a lɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ànnù yìi mə ŋù yìi mə à tòo gha a lɔ̀ɔ̀ aa, à nɨ mə, tâ mə̀ tsuu lǒ mmàꞌàtə tâ ŋù wa yì tsù mə à fa a mbo mə̀ aa tâ à bwɛ. Mə̀ bàŋnə ntswe nɨ̀ ǹywèènsə waa nɨ nɨwo a njwî ǹlwìꞌì ǹjɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ǹloŋ mə ànnù yìi mə Taà ghà a lɔ̀ɔ̀ aa, a bə aa mə ŋ̀gɔ̀ŋ ŋù ǹtsɨ̀m yìi mə à yə Mu yì ǹnɨ̌ŋ ntɨɨ̀ yi ghu nu aa, a ka tswe nɨ̂ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌì nɨ̂ŋkoŋə̀ aà, tâ mə̀ yi nyweensə yi nɨ nɨ̀wo a njwî ǹlwìꞌìnjɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bə̀ bya bɨ lɛ nlɔ̀gɨ̀nə̀ ǹtɨgə nnurəkə nloŋ mə à lɛ nswoŋ mə, “Mə̀ nɨ àbaa yìi mə a lo a aburə nsɨgə aà.” ");
INSERT INTO bfd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bo lɔgɨ̀nə̀ ǹtɨgə mbetə nɨ mə, “Ŋù ghû à sɨ Yesu mu Joseph wa bə aa ɛ? Bìꞌinə̀ zi a Taà yì ŋ̀kɨ nzi ndè yì, a tɨgə̀ ǹtsya aa mə akə nswoŋ mə yu lo aa a aburə nsɨgə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu a swoŋ a mbo bo mə, “Kɛntə nɨ̀ a annurəkə̀ ya mə nɨ nurəkə a tɨtɨ̀i bù aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wa mbə ŋù a waꞌǎ a mbo mə̀ zî tɨ ghə̌ mə Tà yìi mə à too gha aa à swùŋtə yi, tâ mə̀ yi ntɨgə nyweensə yi nɨ nɨ̀wo a njwî ǹlwìꞌìnjɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ŋ̀gǎŋntoo Nwî ɨ lɛ ŋŋwàꞌànə mə, ‘Nwìŋgɔ̀ŋ à ka yi tɨgə kɨ dɨ̀ꞌɨ̀ waa bɨtsɨ̀mə̀.’ Ŋù ntsɨ̀m yìi mə à yùꞌu annu yìi mə Taà a swoŋ, ǹyəgə aa, à nɨ yu yìi mə à ka zǐ a mbo mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kaa a sɨ̀ bə aa mə ŋù tsù à lɛɛ̀ ǹyə Ta bə̂. Yu wa yìi mə à lo a mbo Nwì aa, a kɨ mbə tsiꞌì yù yìi mə à lɛɛ̀ ǹyə Ta. ");
INSERT INTO bfd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mə swoŋ a mbo bù tsiꞌǐ annù nɨ̂koŋ mə ŋù yìi mə à bìi aa, à ka yi tswe nɨ̂ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌì nɨ̂ŋkoŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mə̀ nɨ̂ àbaa ntswêntɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bɨ̀tà bɨ bɨ̂taà buu bɨ lɛ njɨ mana wa a ntaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀, lâ ŋ̀kɨ ŋkwokə. ");
INSERT INTO bfd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Àbaa ya mə a lǒ a aburə nsɨgə aa, à nɨ m̀buu yǐ mɔꞌɔ yìi mə ŋù à bə kurə boŋ kaa à ka yǐ waꞌà kwô. ");
INSERT INTO bfd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mə̀ nɨ̂ àbaa ntswêntɨ̀ɨ̀ ya yìi mə a lo a aburə nsɨgə aà. Ŋù yìi mə à kùrə abaa mà yû aa, a ka tɨgə tswe ntɨ̀ɨ̀ ɨ lwìꞌì nɨ̂ ŋ̀koŋə̀. Àbaa yìi mə mə̀ ka fa aa, à nɨ ǹjyǎnû yà yìi mə mə̀ ka fa mə tâ m̀bi tswe ntɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma yû a ghɨrə̀ mə tâ àswùŋnə̌ nlwîntɔ̀ŋ tâ à lɔgɨnə a tɨtɨ̀ɨ bo. “Mbə ŋù ghû a naŋsə̀ m̀fa njyǎ nû yì mə tâ bìꞌinə̀ kurə aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu a swoŋ a mbo bo mə, “Mə̀ swǒŋ a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, mbə nɨ̀ tsuu njyǎnû Mu Ŋù ɨ kurə ɨ kɨɨ nno a aləə̀ yi, boŋ kaa mbə nɨ̀ waꞌà nɨ̂ ǹtswêntɨ̀ɨ̀ a mûm nu bù tswê. ");
INSERT INTO bfd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ŋù ǹtsɨ̀m yìi mə à kurə njyǎnû yà, ŋ̀kɨ nno aləə nû ya aa, à tswe nɨ̀ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ tswe nɨ̂ŋkoŋə̀ aà; mə̀ ka yǐ kɨɨ yweensə yi a njwî ǹlwìꞌìnjɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ǹloŋ mə njyǎnû yà ɨ̀ laa mbə ŋgòtə̀ mɨjɨ̀, àləə nû ya a kɨ̂ m̀bə ŋgòtə̀ ayoò yì nò. ");
INSERT INTO bfd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ŋù yìi mə à jɨ njyǎnû yà ŋ̀kɨ nno àləə̂ ya aa, à lwiꞌi a mûm nu mə̀, mə̀ kɨ̂ ǹlwiꞌi ghu mûm nû. ");
INSERT INTO bfd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tà yìi mə à tswe ntɨ̀ɨ̀ aa, à tòo ghâ, mə̀ kɨ̂ ǹtswentɨ̀ɨ̀ ǹloŋ ŋgaa yì. À kɨ mbə ŋgɨ̌ŋ ŋgɨ̀ŋ mə ŋù yìi mə à kùrə gha aa, à kɨ ntswe ntswêntɨ̀ɨ̀ m̀bɨꞌɨ ŋgaà yà. ");
INSERT INTO bfd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Àbaa ya yìi mə a lo a aburə nsɨgə aa kaa a sɨ̀ bə aa tsiꞌì tsǒ àbaa ya yìi mə bɨ̀tà bɨ bɨ̂taà buu bɨ lɛ ŋkurə ŋkɨ mbu ŋkwo aà. Ŋù yìi mə à kùrə abaa mà yû aa, a ka tswe ntɨ̀ɨ̀ ɨ lwìꞌì nɨ̂ŋkoŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu à lɛ nswoŋə ma yû aa a noò yìi à lɛ sɨ dɨ̀ꞌɨ annù a ndâŋghòtə a Kapernaum aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ŋ̀gǎŋyəgə̂nnù ji jî ghàꞌàtə̀ jìi mə ɨ lɛ nyuꞌu ma yû ànnù aa, bɨ lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka nswoŋə nɨ mə, “Àjàŋ annù yulà mə a dɨ̀ꞌɨ̀ aa, a tɨɨ siꞌi; m̀bə wò tse yuꞌutə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu à zi mə bo lɛ sɨ nurəkə nloŋə annù ma yû. M̀betə waa mə, “Mâ yû a ka ghɨ̀rə mə tâ nɨ̀ lwisə ntɔŋ mmaꞌatə gha aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","M̀bə nɨ̀ ghɨrə ntɨgə nyə Mu Ŋù a bu ŋkɔꞌɔ ŋghɛɛ fu a adɨgə yìi mə à lɛ ntɛꞌɛ ntswe ghu a mbìì aa, nɨ̀ bu mə akə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Àyoo yìi mə a fa ntswêntɨ̀ɨ̀ aa, à nɨ̂ Àzwì Nwî. Kaa mɨ̀dàꞌà mɨ njyǎnu kaa mɨ sɨ annǔ tsu burə ŋkwɛtə nɨ̂ kwɛ̀tə̀. Mɨ̀ghàà mû mə mə̀ ghàa a mbo bù aa, mɨ nɨ̂ Àzwì ŋ̀ki mbə ntswêntɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lâ kaa bù bî mɔꞌɔ, nɨ̀ waꞌà biì.” Yesu lɛ nswoŋ ma laa nloŋ mə, ǹlɔgɨnə a nlɔ̀gɨ̀nə, à lɛ nzi bə̂ bìi mə kaa bɨ ka yi waꞌà yǐ bii aà, ŋ̀kɨ nzi ŋû yìi mə à lɛ ntswe nɨ̂ m̀fee yi aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A kuꞌùsə̀ ǹswoŋ mə, “À nɨ̂ ǹjiꞌì ànnù yìi mə mə̀ ghɨ̀rə nswoŋ a mbo bù mə kaa mbə ŋù a waꞌǎ a mbo mə̀ zî tɨ ghə̌ mə Tà à fa àbwarə ghu mbô aà.” ");
INSERT INTO bfd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ǹloŋ ma yû ànnù, ŋ̀gǎŋyəgə̂nnù Yesu jî ghàꞌàtə̀ ɨ lɛ mbɨ̀ɨ̀ waa, kaa ŋkɨꞌɨ̀ bo bo bû ŋ̀karə. ");
INSERT INTO bfd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu a bû ŋ̀karəkə yi mbetə ŋgǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa mə, “Ŋ̀gàà yùù ɨ̀ bə la aa ɛ? Nɨ̀ ka kɨɨ mmàꞌàtə̀ gha aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peta a kwiꞌi ghu mbo mə, “M̀màꞌàmbî, bìꞌì ka tɨgə mmàꞌàtə gho, ɨ ghɛ̀ɛ̀ a mbo wò aa ɛ? Ò tswe nɨ̀ nɨ̀ghàà nya mə nɨ fa ntwêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌì nɨ̂ŋkoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tsɨ̂tsɔ̀ŋ bìꞌì bìì mə̂, ŋ̀kɨ nzi mə, ò laa mbə Yu wa yìi mə à Laa màŋsə̀, ǹlo a mbo Nwì aà.” ");
INSERT INTO bfd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu a kwiꞌi a mbo bo mə, “A lɛ ŋkɨꞌɨ̀ mə̂ tsɔꞌɔ ntsɔꞌɔ ghuu nɨghûm ǹtsò baa aa ɛ? Lâ ŋù yî m̀fùùrə̀ a tɨtɨ̀ɨ bù à nɨ̂ Devil.” ");
INSERT INTO bfd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","À lɛ sɨ ghàa annù ma yû ǹloŋə aa Judas mu Simon Iscariot, ǹloŋ mə, ka mə Judas à lɛ mbə ŋû yî mɔ̀ꞌɔ a tɨtɨ̀ɨ ŋ̀gǎŋyəgə̂nnù ji jya nɨ̀ghûm ǹtsò baa, à lɛ ntswe nɨ̂ m̀fèê yi. ");
INSERT INTO bfd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma yû a kà mə̂ aa ntsya, Yesu a lô, ŋ̀ghɛɛ̀ a Galilea ntɨgə ŋkarə ghu. Kaa waꞌà kɔ̀ŋə̀ kɨ karə a Yudea, ǹloŋ mə bɨ̀tà bɨ alaꞌa bɨ baYuda bɨ lɛ sɨ lɔ̀ɔ nzwìtə̂ yi aà. ");
INSERT INTO bfd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma mùu noò Ǹjwî ǹjɨ̀ Ɨ̀kòo mɨ̂ntàŋ baYuda ɨ̀ lɛ ntɨgə a abo, ");
INSERT INTO bfd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","bɔɔ bɨ ma bɨ Yesu bɨ swoŋ ghu mbo mə, “Lò faà, ŋ̀ghɛɛ a Yudea, tǎ tâ ŋ̀gǎŋyəgə̂nnù jo ɨ̀ ka nyə ɨnnù jû mə o ghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ǹloŋ mə ŋù yìi mə a lɔ̀ɔ̀ mə tâ bɨ̀ zi yi aa, kaa à sɨ aa a adɨgə yî lə̀ə̀ntə̀ faꞌa. Tsǒ mə o ghɨ̀rə ɨnnù jû aa, ghɨ̀rə tâ m̀bi yə ghô.” ");
INSERT INTO bfd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bo lɛ nswoŋ laa nloŋ mə tsiꞌì bo bɔɔ bɨ maà bi bya kaa bo lɛ ŋwaꞌà ǹtɨɨ̀ waa ghu nu nɨŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu a swoŋ a mbo bo mə, “Kaa ghàà nòò à burə tɨ̀ kùꞌù, lâ nòò tsɨ̀m à kùꞌùnə a mbo bù a mfàꞌa annù. ");
INSERT INTO bfd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kaa m̀bə m̀bi waꞌà ghuu ka mbaa, lâ ɨ bàà nàâ, ǹloŋ mə mə swoŋ nɨ mə bɨ ghɨ̀rə̀ nɨ̂ ɨ̀nnù jî bɨ̂ aà. ");
INSERT INTO bfd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nɨ̀ kɔꞌɔ ŋghɛɛ wa adɨgə dinà; Kaa mə̀ ka waꞌà ghu ghɛɛ̀ ǹloŋ mə ghàà nòò à burə tɨ̀ kùꞌù.” ");
INSERT INTO bfd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","À swòŋ mə̂ laa, ntɨgə ntswe yi tsiꞌǐ a Galilea. ");
INSERT INTO bfd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bɔɔ bɨ maà bi bɨ kɔ̀ꞌɔ̀ mə̂ ŋ̀ghɛɛ wa adɨgə ɨ̀kòò aa, Yesu a tɨgə̀ m̀bu ŋŋeꞌesə ŋyoŋ, kaa waꞌà ghɨ̀rə̂ bə̀ yə yi. ");
INSERT INTO bfd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bɨ̀tà bɨ alaꞌa bɨ baYuda bɨ lɛ sɨ lɔ̀ɔ̀ nìi wa adɨgə ɨ̀kòò. Bo lɛ sɨ betə nɨ mə, “Yesu à fə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ǹnɔ̀ɔ̀ bə̂ wa ɨ lɛ sɨ tsùtə̀ ŋ̀ghaa nloŋ ŋgaà yì. Bə̀ bî mɔꞌɔ bɨ lɛ sɨ swoŋə nɨ mə, “À nɨ ŋù yî ǹsɨgɨ̀nə̀.” Bǐ mɔꞌɔ swoŋə̀ nɨ mə, “Ŋ̀gaŋ, a bweꞌesə aa bə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lâ kaa ŋù tsù à lɛ ŋwaꞌà kà ŋ̀ghaa nɨ̂ ǹsi nɨ̀ ǹsî, ǹloŋ mə bo lɛ sɨ bɔꞌɔ nɨ̂ bɨ̀tà bɨ alaꞌa bɨ baYuda bya aà. ");
INSERT INTO bfd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ǹjwî ɨ̀kòò jya ɨ lɔ̀ɔ̀nə̀ mə̂ a tɨtɨ̀ɨ̀, Yesu a kɔꞌɔ ŋghɛ̀ɛ̀ a ndâmàꞌanwì, ǹlɔgɨnə ŋka ndɨꞌɨ annù Nwî. ");
INSERT INTO bfd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","BaYuda bya bɨ lɛ yɛrə siꞌi siꞌi, ǹswoŋ mə, “Ŋù ghû à tsyà aa la naŋsə nzi aŋwàꞌànə̀ laà, tɨ ghə̌ mə à lɛ ŋghɛɛ a ndâŋwàꞌànə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu a kwiꞌi mə, “Ànnù yû mə mə dɨ̀ꞌɨ̀ aa, a lo aa a mbo Nwì yìi à tòo gha aa, kaa à sɨ̌ annù ya bə̂; ");
INSERT INTO bfd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ŋù yìi mə a kɔ̀ŋ a ŋka ŋghɨ̀rə ànnù yìi mə Nwì a lɔ̀ɔ̀ aa, à ka zi mə ànnù yìi mə mə dɨ̀ꞌɨ̀ aa, a lo aa a mbo Nwì, kaa mə̀ waꞌǎ aa nɨ̂ àdàꞌâ ya ghàà. ");
INSERT INTO bfd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ŋù yìi mə a ghàà nɨ̂ àdàꞌâ yi aa, a lɔ̀ɔ̀ aà ŋ̀kwɛrə nɨghaꞌa a mbo yu yumbɔŋ. Lâ ŋù yìi mə a lɔ̀ɔ̀ bə̂ ŋ̀ghàꞌàsə yu wa yìi mə à tòo yi aa, a swoŋ ànnù nɨ̂ŋkoŋ, kaa waꞌà ŋ̀gàŋàbǎŋnənnù bə̂. ");
INSERT INTO bfd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tɨgə Moses à lɛ mbaa, mfa nɔ̂ŋsə̀ a mbo bù aa ɛ? Lâ kaa ŋù nɨbù yî tsù a waꞌà nɨ̀ nɔ̂ŋsə̀ ma wa lə̀ə̀. Lâ bù tɨgə̀ ǹlɔɔ nɨ̂ ǹzwìtə mə̀ aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bə̀ bya kwiꞌi mə, “Àzwì yî bɨ a tswe a atoꞌo wò! A lɔɔ wo a nzwitə wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu a kwiꞌi mə, “Mə̀ kɨ̀ ghɨ̀rə̂ ànnù yî fùùrə̀ bù bɨ̀tsɨm tɨgə̀ ǹyɛrə. ");
INSERT INTO bfd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses à lɛ mfa nɔ̂ŋsə̀ (ka mə à lɛ nlò aa a mbo bɨ̀tà bɨ bɨ̂taà buu aa), nɨ̀ ŋêtə̀ nɨ̂ bɔɔ a njwîŋgɔ̀ŋ tâ lə̀ə nɔ̂ŋsə̀ ma ghû. ");
INSERT INTO bfd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","M̀bə bɨ ka ŋŋetə nɨ̂ bɔɔ a njwîŋgɔ̀ŋ, tǎ waꞌǎ nɔ̂ŋsə̀ Moses wa wò, nɨ̀ tɨgə̀ ǹlwisə nɨ̂ ǹtɔ̀ŋ a nu mə̀ mə mə̀ ghùrə ŋû nû yǐ ntsɨ̀m ɨ tswêntɨ̀ɨ̀ a njwîŋgɔ̀ŋ aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nɨ̀ kɛntə a ŋka ntsə̀rə mɨ̀saꞌa nyòŋə̀ naa ɨ̀nnù jìi mə nɨ̀ yə abɛɛ abɛɛ aà, nɨ̀ ka ntsərə mɨsaꞌa nyòŋə̀ nɨ̂ bə ànnù nɨ̂ŋkoŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","BaYerusalem bya bǐ mɔꞌɔ bɨ swoŋ mə, “À sɨ̀ ŋû wa mə bɨ̀tà bɨ alaꞌa bɨ baYuda bɨ lɔ̀ɔ a nzwitə aa à ghulà bə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yə̂ nɨ̀! À ghû mə a ghàà tsiꞌì nɨ̂ ǹsi nɨ̀ ǹsî, kaa bɨ waꞌà nɨ̀ ànnǔ tsǔ ghu atu bù ǹswoŋə! A laà m̀bə aà mə bɨ̀tà bɨ alaꞌa bù bɨ zì mə̂ mə àa tsiꞌì Àyɔꞌɔ̀ Nwì wa lɛ? ");
INSERT INTO bfd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ayɔꞌɔ̀ Nwì wa, à bə zǐ boŋ kaa ŋù tsù à sɨ̌ adɨ̀gə̀ yìi mə à lo ghu aa zî, lâ bìꞌinə̀ bɨtsɨ̀m zî àdɨ̀gə̀ yìi mə m̀bâ ghû à lo ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu a tɨgə̀ ǹnaŋsə nswoŋ wâ nòò mə à lɛ sɨ dɨ̀ꞌɨ annù wa mûm ǹdâmàꞌanwì aa mə, “Nɨ̀ ǹnaŋsə nzi gha, ŋkɨ nzi adɨgə yìi mə mə̀ lo ghu aa ɛ? Kaa mə̀ sɨ̀ fàa atu nsyɛ aa nɨ̀ àtû ya zì, yu wa yìi mə à tòo gha aa, à nɨ̂ ànnù nɨ̂ŋkoŋə̀. La kaa nɨ̀ waꞌà yi zî. ");
INSERT INTO bfd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mə̀ zi yi, ǹloŋ mə mə̀ lò aa ghu mbô, a gha aa â kɨ̂ ǹtoo yu aà.” ");
INSERT INTO bfd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","À swòŋ mə̂ laa, bɨ tɨgə̀ ǹlɔɔ mə bɨ baŋnə yi, lâ kaa ŋù tsù à lɛ waꞌǎ abô yi ghɛ̂nsə̀ ǹtswa yi ghu nloŋ mə kaa nòò yì kaa à lɛ mburə tɨ kùꞌù aà. ");
INSERT INTO bfd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","La bə̀ bî ghàꞌàtə̀ bɨ lɛ mbàŋnə̀ m̀bii yi; ǹswoŋ mə, “Nòò yìi mə Àyɔꞌɔ̀ Nwì wa à ka yi zì aa, a ka yi ghɨ̀rə ɨlènsə̀ tâ ɨ̀ tsyàtə ŋù ghû aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","BaFarɨsai bɨ lɛ nyuꞌu ajàŋ mə nnɔ̀ɔ̀ wa ɨ lɛ sɨ tsùmnə̀ nɨ̂ ɨ̀nnù jya nloŋ ŋgaa Yesu aa, bo a bɔ̀ꞌɔ nɨ bɨ̀lɨ̀ɨ bɨ ŋgǎmàꞌa Nwì tɨgə̀ ǹtoo ŋ̀gǎŋmbɛ̂ ǹdâmàꞌa Nwì mə tâ bo ghɛɛ ntswa Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu a tɨgə̀ ǹswoŋə a mbo bo mə, “Wa mə̀ ka tɨgə tswe biꞌinə̀ aa, tsiꞌì a atu mû àtɨɨ noò, ɨ bɔ̌ŋ lǒ ghɛ̀ɛ a mbɛ̀ɛ yu wa yìi mə à lɛ ntoo gha aà. ");
INSERT INTO bfd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɨ̀ ka yǐ tɨgə kɨ lɔ̀ɔ̀ gha kaa waꞌà gha bù ǹyə; kaa mbə nɨ̀ waꞌǎ wa adɨgə mə mə̀ ka ghɛɛ tswe ghu aa kɨ nyoŋə.” ");
INSERT INTO bfd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","BaYuda bya bɨ tɨgə̀ ǹswoŋə bo nɨ bo mə, “M̀bâ ghû a lɔ̀ɔ ŋghɛ̀ɛ̀ aa fə mə mbə bìꞌinə̀ waꞌà yi bû ǹyə aa ɛ? À ka ghɛ̀ɛ̀ aà a nɨ̂ ɨ̀laꞌa baGrikia jya mə bə̂ bìꞌinə̀ lɛ njàꞌànə̀ ŋ̀ghɛɛ ghu aa, ɨ tɨgə dɨ̀ꞌɨ̀ nɨ̂ baGrikìa bya ghu aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A swoŋə nɨ mə bìꞌinə̀ ka yi kɨ lɔ̀ɔ̀ nɨ̂ yi kaa waꞌà yi yə̂, ŋ̀kɨɨ nswoŋə nɨ mə kaa mbə bìꞌinə̀ waꞌǎ wa adɨgə yìi mə yu ka yǐ ghɛ̀ɛ tswe ghu aa ghɛ̀ɛ̀. Ma yû ànnù a dɨ̀ꞌɨ̀ aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","À bə̀ mə̂ nɨ̂ ǹjwî ǹlwìꞌìnjɨ̀m, mə lɛ ŋkɨ mbə njwi yì ŋ̀wè wa noò Ɨkòò Mɨ̂ntàŋ aa, Yesu a bɨɨ̀nə̀ ǹtəə a ndəŋ ntɔŋnə nswoŋ mə, “Ŋù yìi mə ǹjì ŋ̀kì ɨ yaŋə nɨ̂ yi aa, tâ à zi a mbo mə̀ ǹno ŋkì. ");
INSERT INTO bfd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ǹloŋ mə a ka bə ajaŋ mə àŋwàꞌànə̀ Nwî a swoŋ aa mə, ‘Ŋù yìi mə à nɨ̌ŋ ntɨɨ̀ yi a nu mə̀ aa, mɨ̀ŋkì mɨ tswêntɨ̀ɨ̀ mî ghàꞌà ŋ̀ghaꞌa, mɨ ka tɨgə fɛ̀ꞌɛ̀ ghu ntɨɨ̀.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu à lɛ nswoŋə ma yû ànnù aa nloŋ Azwî Nwì yìi mə bə̀ bìi mə bɨ lɛ nɨŋ mɨ̂ntɨɨ̀ myaa ghu nu aa, bɨ lɛ ntswe nɨ̂ ŋ̀kwɛ̀rə aà. À lɛ tɨ bə maà noò aa, kaa Nwì a burə̀ tɨ Azwì yi fâ, ǹloŋ mə kaa Yesu à lɛ mburə tɨ kɔꞌɔ ŋkwɛrə annù nɨfɔ̀ yi a mbo Nwì aà. ");
INSERT INTO bfd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bə̀ bî mɔꞌɔ wa atɨtɨ̀ɨ ǹnɔ̀ɔ̀ bə̂ bya yùꞌù mə̂ laa, nswoŋ mə, “Ŋù ghûlà a nɨ tsiꞌì ŋ̀gàŋntoò Nwì wa!” ");
INSERT INTO bfd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bo bî mɔꞌɔ swoŋ mə, “À nɨ tsiꞌì Àyɔꞌɔ̀ Nwì wâ.” La bǐ mɔꞌɔ bâŋnə̀ ǹswoŋ mə, “Kaa Àyɔꞌɔ̀ Nwì wa kaa à ka yǐ waꞌǎ aa a Galilea lô! ");
INSERT INTO bfd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","A tswe a mûm àŋwàꞌànə Nwì mə Àyɔꞌɔ̀ Nwì à ka yǐ lò aa a ŋgwɛ̀ꞌɛ M̀fɔ̀ David, tâ bɨ̀ jwe yi aa a Bethlehem, wa alaꞌa David.” ");
INSERT INTO bfd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Maa ajàŋ, ǹnɔ̀ɔ̀ wa ɨ lɛ ntɨgə nyatə waa nloŋə Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bo bî mɔꞌɔ bɨ lɛ sɨ lɔ̀ɔ ntswâ yi, la kaa ŋù tsù waꞌà yi nɨ̂ àbo mɔ̀ɔ̀ntə̀. ");
INSERT INTO bfd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nòò yìi mə ŋ̀gǎŋmbɛ̂ ǹdâmàꞌanwì jya ɨ lɛ mbù m̀bɨɨ aa, bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ baFarɨsai bo betə̀ mə, “Nɨ̀ ghɨ̀rə waꞌà yi tswa nzì nɨ ghu aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ŋ̀gǎŋmbɛ̂ ǹdâmàꞌanwì jya ɨ kwiꞌi mə, “kaa bìꞌì lɛɛ̀ waꞌà ŋù tsù yə̂ mə ghàà tsiꞌì tsǒ ŋù ma ghû!” ");
INSERT INTO bfd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","BaFarɨsai bya swoŋ a mbo bo mə, “A bə mə à kɨ̀ mə̂ m̀bweꞌesə a ghuu aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kə̀ nɨ̀ yə mə ŋù tsù a tɨtɨ̀ɨ bɨ̀tsyàsə̀ kə̀ baFarɨsai à nɨ̌ŋ ǹtɨɨ̀ yi ghu nu aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ǹnɔ̀ɔ̀ bə̂ ghû mə kaa sɨ̀ nɔ̂ŋsə̀ Moses zi aa bɨ tɨ̀gə̀ mə̂ m̀beꞌe ndɔ̀ɔ̀ Nwì!” ");
INSERT INTO bfd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ŋù baFarɨsai wa yì mɔ̀ꞌɔ a tɨtɨ̀ɨ bo à lɛ mbə Nicodemus, wa mə à lɛ ŋghɛ̀ɛ̀ ǹyə Yesu nɨ̂tugə aà. A tɨgə̀ ǹswoŋə a mbo bo bî mɔꞌɔ bya mə, ");
INSERT INTO bfd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nɔ̀ŋsə̀ yìꞌinə̀ à laa ndɨ̀ꞌɨ mə mbə bɨ tsərə̌ ɨsaꞌa ŋû tɨ yuꞌu ànnù yìi mə à swǒŋ, kə̀ ǹlɔɔ nyə annù yìi mə à ghɨ̀rə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bo kwiꞌi mə, “Ɨ̀ɨ̀ɨ̂! Ò kɨ nlò aa a alaꞌa Galilea aa ɛ? Naŋsə nyəgə nɨghàà nɨ Nwî bəə boŋ ò ka yə mə kaa ŋ̀gàŋntoò Nwì kaa à lɛɛ̀ waꞌà a Galilea lô.” ");
INSERT INTO bfd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bɨ màŋsə̀ mə̂, bə̀ bɨ̀tsɨ̀m tɨgə̀ ǹlo ŋghɛ̀ɛ̀ŋkə̀ a ndugə bo. ");
INSERT INTO bfd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu a bâŋnə̀ ǹlo ŋkɔꞌɔ ŋghɛɛ a atu ntaꞌa Olive. ");
INSERT INTO bfd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Àbɛ̀ɛ̀ a fùꞌù mə̂, a bə tsiꞌì a tɨ̀tugə, Yesu a bû ŋ̀ghɛɛ fu a ndâmàꞌanwì. Bə̀ bɨ̀tsɨ̀m zî ǹtswe ŋkarɨsə yi, a tswê a nsyɛ nlɔ̀gɨ̀nə̀ ŋ̀ka ndɨꞌɨ waa. ");
INSERT INTO bfd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ bo bɨ̀ baFarɨsai zî nɨ màŋgyɛ̀ yî mɔ̀ꞌɔ yìi mə bɨ lɛ ntswa a adɨgə mâghàbə̀, ǹzi ntɛꞌɛ a nsi Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ǹswoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨ̀nnù, bìꞌì ghɨrə ntswa mâŋgyɛ̀ ghuà a ghɨrə̀ nɨ̀ ànnǔ mâghàbə̀. ");
INSERT INTO bfd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nɔ̀ŋsə̀ Moses à lɛ nswoŋ mə tâ bɨ̀ tumtə ajàŋ mâŋgyɛ̀ ma yû ǹzwitə. Ò swǒŋ ŋ̀gaa yò mə bɨ̀ ghɨrə ghu mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bo lɛ nswoŋ laà aa a ŋkwàꞌànə Yesu tǎ tswe nɨ̂ ànnù yìi mə mbə bɨ tsyâ ghu mfa afɨ̀rə̂ yi. Bɨ̀ swòŋ mə̂ laà aa, Yesu a bâŋnə̀ ǹtuŋnə ŋka ŋwaꞌanə nɨ muswɛ̂bô yì a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bɨ ghɛ̀ɛ̀ mə̂ nɨ̂ m̀bìì ŋ̀ka betə nìi nɨ̂ ɨ̀betə̀ aa, a bɨɨ̀nə̀ ǹtəə nswoŋ a mbo bo mə, “Ŋù nɨ̀bù yìi mə à lɛɛ̀ ŋ̀waꞌǎ annǔ tsu fânsə̀ aa, tâ foo ntumə yi nɨ̂ ŋ̀gɔ̀ꞌɔ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","À swòŋ mə̂ laa, mbu ntuŋnə mbu ŋka ŋŋwaꞌanə nɨ muswɛ̂bô yì fu. ");
INSERT INTO bfd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bo yùꞌù mə annù ya mə à ghɨ̀rə nswoŋə aa, ǹtɨgə mfɛꞌɛkə yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ̂, ǹlɔgɨnə nɨ bɨ̀lɨ̀ɨ bìi mə bɨ lɛ ntswe a tɨtɨ̀ɨ bo aà. Ǹtɨgə mmaꞌatə Yesu tsiꞌì yùyù, mâŋgyɛ̀ wa a burə̀ ǹtəə ghu nsî. ");
INSERT INTO bfd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu a ŋŋɛntə̀ àtû yi ǹswoŋ ghu mbo mə, “Màŋgyɛ̀, bə̀ by bɨ fə̀ aa ɛ? Ŋù tsù à sɨ̀ ghu bû ǹtswe a nnɨ̂ŋ ɨ̀saꞌa anu wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Màŋgyɛ̀ wa a kwiꞌi mə, “Kaa ŋù tsù à sɨ̀ ghu tswê, M̀màꞌàmbî.” Yesu a tɨgə̀ ǹswoŋ mə, “Kaa mə̀ ka waꞌǎ ɨsaꞌa a nu wò kɨ nnɨŋə. Lâ, ghɛ̀ɛ̀ ghô, ǹtsuu ɨnnù jî bɨ bǔ kɨ ghɨ̀rə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu a bû ǹswoŋ a mbo bə̀ ma bya mə, “Mə̀ laa mbə ŋkàꞌa fàa m̀bî. Ŋù ǹtsɨ̀m yìi mə a yòŋə̀ nɨ̂ gha aa, kaa à ka waꞌǎ a mûm m̀fii ɨdɨ̀gə̀ ka ntəə, à ka bàŋnə ɨ tswe nɨ̂ ŋ̀kàꞌa ntswêntɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","BaFarɨsai swoŋ ghu mbo mə, “Ò bə kɨ swoŋə annù ǹloŋ ŋgaà yò wò m̀bɔŋ boŋ ànnù yìi mə o swoŋ aa, kaa a sɨ̌ annù nɨ̂ŋkoŋ bə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu a kwiꞌi mə, “Ka mə mə swoŋ annù ǹloŋ ŋgaà yà aa, ànnù yìi mə mə swoŋə aa, à nɨ̂ ànnù nɨ̂ŋkoŋə̀, ǹloŋ mə mə̀ zî àdɨgə̀ yìi mə mə̀ lo ghu aa, ŋkɨ nzi adɨgə yìi mə mə ghɛ̀ɛ̀ ghu aà. Lâ kaa bù sɨ̌ adɨgə yìi mə mə̀ lo ghu aa, kə̌ adɨgə yìi mə mə ghɛ̀ɛ̀ ghu aa zî. ");
INSERT INTO bfd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Nɨ tsə̀rə̀ mɨsaꞌa aa tsǒ bə̀; lâ, kaa mə̀ sɨ ɨsaꞌa ŋû tsərə. ");
INSERT INTO bfd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lâ mə̀ bə tɛꞌɛ kɨ tsə̀rə ɨsaꞌà tsə̀rə̀ boŋ mə̀ ka tsə̀rə aa tsiꞌǐ annù nɨ̂ŋkoŋə̀, ǹloŋ mə kaa mə̀ sɨ̌ aa tsiꞌì mə̀ mə̀ tsərə, mə tsə̀rə̀ aa bìꞌi yu wa yìi mə à lɛ ntoo gha aà. ");
INSERT INTO bfd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bɨ ŋwaꞌanə a mum nɔ̀ŋsə bù mə, ànnù yìi mə bɨ̀yəfə bi baa bɨ bii aa, à nɨ̂ ànnù nɨ̂ŋkoŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mə swoŋə nɨ̂ ànnù ǹloŋ ŋgaa yà aa, Taà ghà yìi mə à lɛ ntoo gha aa, a kɨɨ̀ ǹswoŋə nɨ̂ ànnù ǹloŋ ŋgaà yà.” ");
INSERT INTO bfd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bɨ betə̀ yi mə, “Taà ghò à tswe aa fə aa ɛ?” Yesu a kwiꞌi mə, “Kaa nɨ̀ sɨ̀ gha zî, kaa nɨ̀ sɨ̀ Taà ghà kɨ nzi; nɨ̀ laa bə zi gha boŋ nɨ̀ kɨ nzi Taà.” ");
INSERT INTO bfd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu à lɛ nswoŋ ma jû ɨ̀nnù aa wa noò mə à lɛ sɨ dɨ̀ꞌɨ annù Nwî a mûm ǹdâmàꞌa Nwì, ntswe aa a mbɛ̀ɛ̀ ǹjaꞌà ǹda yìi mə ŋ̀kòm ŋ̀kabə̀ m̀màꞌanwì ɨ̀ lɛ ntswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu a bû ǹswoŋ a mbo bə̀ bya mə, “Mə ka lǒ ghɛ̀ɛ̀ ghâ, tâ nɨ̀ tɨgə nlɔɔ nɨ̂ gha kɨkaŋ, ɨ yi kwo a mûm ɨ̀bɨ bù; àdɨ̀gə̀ yìi mə mə ghɛ̀ɛ̀ ghu aa, kaa mbə nɨ̀ waꞌà ghu ghɛɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bɨ̀tà bɨ alaꞌa bɨ baYuda bya swoŋ mə, “À ka baa zwitə aà ɨ̀bɨ̀ɨ nû yì, ǹloŋ mə a swoŋə nɨ mə àdɨgə̀ yìi mə yu ka ghɛ̀ɛ̀ ghu aa, kaa m̀bə bìꞌinə̀ waꞌà ghu ghɛɛ̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A swoŋ a mbo bo mə, “Nɨ̀ lò aa fàa atu nsyɛ̂, lâ mə̀ bâŋnə̀ ǹlo aa a aburə, nɨ̀ lò aa fàa mbî, kaa mə̀ waꞌǎ aa fàa mbi lò. ");
INSERT INTO bfd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mə̀ swǒŋ mə, nɨ̀ ka kwo a mûm ɨ̀bɨ bù aa nloŋ mə nɨ̀ bə tsuu bii mə ‘mə̀ nɨ ghu wa mə mə̀ nɨ ghu aa,’ bəə boŋ nɨ̀ ka kwo a mûm ɨ̀bɨ bù.” ");
INSERT INTO bfd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bo betə̀ Yesu mə, “Ò bə aa wò aa ɛ?” A kwiꞌi mə, “Yu wa mə, mə̀ tɛ̀ꞌɛ̀ mə̂ ǹswoŋ ǹlɔgɨnə a mbìì aà. ");
INSERT INTO bfd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mə̀ tswe nɨ̀ ɨ̀nnù jî ghàꞌàtə̀ a nswoŋə nloŋə ghuu, ɨ̀nnù jî ghàꞌàtə̀ ǹloŋə annǔ nnɨŋ ɨsaꞌa a nu bù. La, yu wa yìi mə à lɛ ntoo gha aa, a swoŋ aa tsiꞌì ànnù nɨ̂ŋkoŋə̀, mə̀ kɨɨ̀ ǹswoŋ aa ànnù yìi mə mə̀ yùꞌu ghu mbo aa, a mbô m̀bî.” ");
INSERT INTO bfd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu à lɛ nswoŋ ma laa kaa bo waꞌà zi mə à lɛ sɨ ghàà a mbo bo nloŋ aa ŋgaa Nwìŋgɔ̀ŋ Tà. ");
INSERT INTO bfd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","A tɨgə̀ ǹswoŋ a mbo bo mə, “Nòò yìi mə nɨ̀ ka yi ŋɛɛ Mu Ŋù a ndəŋ aa, nɨ̀ ka yǐ zi mə ‘mə̀ nɨ ghu wa mə mə̀ nɨ ghu aà.’ Nɨ̀ ka yǐ zi mə kaa mə̀ sɨ annù tsu nɨ àdàꞌâ ya ghɨ̀rə̀, ɨ kɨɨ zɨ mə mə swoŋ aa tsiꞌì ànnù yìi mə Taà ghà à dɨ̀ꞌɨ mə tâ mə̀ swoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ŋù wa yìi mə à lɛ ntoo gha aa, à tswe bìꞌi yu, kaa à sɨ̀ gha màꞌàtə̀ mə tâ mə̀ tswe tsiꞌì mə̀ mə̀, ǹloŋ mə mə ghɨ̀rə aa, tsiꞌì ànnù yìi mə a bɔ̀ŋə̀ nɨ̂ yi aà.” ");
INSERT INTO bfd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bə̀ bî ghàꞌàtə̀ bìi mə bɨ lɛ nyuꞌu ɨnnù jya jìi mə Yesu à lɛ nswoŋ aa, bo lɛ nnɨŋ mɨ̂ntɨɨ̀ myaa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu a tɨgə̀ ǹswoŋ a mbo baYuda bya bìi mə bɨ lɛ nnɨŋ mɨ̂ntɨɨ̀ mya ghu nu aa mə, “Nɨ̀ bə kɨ yuꞌu nɨghàâ na ɨ lwìꞌì ghu mum, bəə boŋ nɨ̀ ka tɨgə bə ŋgǎŋyəgə̂nnù jya tsiꞌì ànnù nɨ̂ŋkoŋə̀; ");
INSERT INTO bfd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ɨ naŋsə zi annù nɨ̂ŋkoŋ, tâ ànnù nɨ̂koŋ ya à ghɨrə tâ nɨ̀ tsuu ɨbùꞌù bǔ bə.” ");
INSERT INTO bfd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bo kwiꞌi mə, “Bìꞌì lo aa a ŋgwɛ̀ꞌɛ Abraham, kaa bìꞌì lɛɛ̀ ŋ̀waꞌǎ ɨbùꞌù ŋû tsù kɨ mbə. Ò tsya aa la ntɨgə nswoŋ mə, ‘Kaa nɨ̀ ka waꞌǎ ɨbùꞌù bǔ mbə aa ɛ?’ ” ");
INSERT INTO bfd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu a swoŋ a mbo bo mə, “Mə̀ swǒŋ tsiꞌì ànnù nɨ̂koŋ a mbo bù mə, ‘Ŋù yìi a ghɨ̀rə ɨnnù jî bɨ aa, à nɨ̂ àbùꞌù a mbô ɨ̀nnù jî bɨ̂. ");
INSERT INTO bfd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kaa àbùꞌù a sɨ̌ a mûm ŋ̀gwɛ̀ꞌɛ̀ nɨ̂koŋ tswe, a ŋgwɛ̀ꞌɛ̀ aa a lwìꞌì jwe jwe ŋ̀gwɛ̀ꞌɛ̀ wâ. ");
INSERT INTO bfd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ma mùu ajàŋ wa Mu à laa bə fiꞌi gho a ndâ àbùꞌù bəə boŋ kaa ò ka waꞌǎ abùꞌù bù m̀bə bə̂. ");
INSERT INTO bfd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mə̀ zi mə nɨ̀ fɛ̀ꞌɛ̀ aa a ŋgwɛ̀ꞌɛ Abraham. Lâ nɨ lɔ̀ɔ nzwitə mə̀ aa loŋ mə kaa nɨ̀ sɨ annù yìi mə mə dɨ̀ꞌɨ̀ aa kwɛrə aà. ");
INSERT INTO bfd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mə swoŋ aa ànnù yìi mə mə̀ yə a mbo Taà aà. La nɨ̀ bâŋnə̀ ŋ̀ghɨrə aa annù yìi mə taà ghùù a swoŋə nɨ a mbo bù aà.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bo kwiꞌi ghu mbo mə, “Taà yìꞌì à nɨ aa, Abraham.” Yesu a kwiꞌi mə, “À laa mbə mə nɨ̀ bə aa bɔɔ bɨ Abraham, boŋ nɨ ghɨ̀rə mbuu ɨnnù jìi mə à lɛ sɨ ghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Lâ nɨ̀ bâŋnə̀ ǹlɔɔ nɨ̂ ǹzwìtə mə̀, ŋù yìi mə mə̀ nɨ̀ ghu wa yìi mə mə̀ swǒŋ annù nɨ̂ŋkoŋ ya mə mə̀ lɛ nyuꞌu a mbo Nwì a mbo bù aà! Ma yû kaa à sɨ̌ annù mə Abraham à lɛ ŋghɨ̀rə̀ bə̂! ");
INSERT INTO bfd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nɨ ghɨ̀rə aa annù yìi mə taà ghùù à lɛ ŋkɨ ŋghɨrə aà.” Bo kwiꞌi mə, “Kaa bìꞌì sɨ̌ bɔɔ bɨ àkwàrə̀ bə̂, bìꞌì tswe aa tsìꞌì nɨ̀ Tà yî mɔ̀ꞌɔtə̂, a bə Nwì.” ");
INSERT INTO bfd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu a swoŋ mə, “À laa bə mə Nwì à nàŋsə mbə aa tsiꞌì Taà ghùù, bəə boŋ nɨ kɔ̀ŋə̀ nɨ̂ ghâ, ǹloŋ mə mə̀ lò aa a mbɛ̀ɛ Nwì ǹzi ntswe faà tsɨ̂tsɔ̀ŋə̀. Kaa mə̀ lɛ ŋwaꞌǎ aa nɨ̀ àtû ya zì, a gha aa a lɛ ntoo Nwî. ");
INSERT INTO bfd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nɨ̀ sɨ̌ annù yìi mə mə swoŋə zi aa a ya aa ɛ? Tɨgə a ghɨrə aa mə kaa nɨ̀ sɨ lɔ̀ɔ̀ a nyuꞌu nɨ̀ghàâ na aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nɨ̀ bə aa bɔɔ bɨ taà ghùù, Satan, nɨ kɨɨ nlɔɔ ŋghɨ̀rə aa annù yìi mə taà ghùù a ghɨ̀rə̀ aà. Ǹlɔgɨnə tsiꞌì a mbìi mbìì, taà ghùù à lɛ mbə aa ŋ̀gàŋnzwìtə bə̂. Kaa bo ànnù nɨ̂ŋkoŋ sɨ̀ nɨ̂ ànnǔ tsu tswê, ǹloŋ mə kaa annù nɨ̂ŋkoŋ kaa a sɨ̀ ghu nu tswê. A yi tɨ swoŋə abǎŋnənnù aa, a ghɨrə̀ aa tsiꞌǐ annù yìi mə a tswe ghu nû aa, ǹloŋ mə à bə aa ŋ̀gàŋàbǎŋnənnù, ŋ̀kɨ mbə aa tǎ bɨ̀ ɨ̀bǎŋnənnù. ");
INSERT INTO bfd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","La tsǒ mə mə swoŋ aa annù nɨ̂ŋkoŋ aa, kaa nɨ̀ waꞌà biì. ");
INSERT INTO bfd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ŋù nɨ̀bù yìi mə à tse swoŋ mə mə̀ ghɨ̀rə annù yî bɨ aa, à nɨ wò aa ɛ? M̀bə mə ka nswoŋə aa ànnù nɨ̂ŋkoŋ nɨ̀ tɨgə̀ waꞌà bii aa a ya aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ŋù yìi mə à tswe bo Nwì aa, a yuꞌu nɨghàà nɨ Nwî, lâ, kaa nɨ̀ sɨ̀ aa bǔ bɨ̀ Nwì tswê, à nɨ annù yìi a ghɨrə kaa nɨ̀ waꞌà nɨ̀ Nɨ̀ghàà nɨ Nwî yuꞌù aà.” ");
INSERT INTO bfd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","BaYuda betə̀ Yesu mə, “Bìꞌì ghɨ̀rə̂ ǹtɛꞌɛ mbaa waꞌà swoŋ mə, ò nɨ ŋù Samaria, àzwì yî bɨ a kɨ̂ ǹtswe a atoꞌo wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu a kwiꞌi mə, “Kaa àzwì yî bɨ kaa a sɨ̌ a atoꞌo mə̀ tswê. Mə ghaꞌasə aa bə Taà, lâ nɨ̀ bâŋnə̀ ǹtsaꞌa nɨ̂ ghâ. ");
INSERT INTO bfd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kaa mə̀ sɨ aa nɨ̀ghaꞌà na lɔ̀ɔ̀. La ŋù yì mɔ̀ꞌɔ à tswe ghu mə a lɔ̀ɔ̀ nɨghaꞌà na ŋkɨɨ nsaꞌa nɨ̂ ɨ̀saꞌâ ghâ. ");
INSERT INTO bfd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mə̀ swoŋ tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, ŋù yìi mə a lə̀ə nɨghàâ na aa, kaa à ka yǐ waꞌà nɨwo burə nyə yə.” ");
INSERT INTO bfd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","BaYuda bya bɨ swoŋ ghu mbo mə, “Bìꞌì nàŋsə̀ mə̂ nzi tsɨ̂tsɔ̀ŋ mə demon à tswe a toꞌo wò. Abraham à lɛ ŋkwo, ŋ̀gǎŋntoo Nwî ɨ kɨ ŋkwokə, lâ ò bâŋnə̀ ǹswoŋə nɨ mə, ŋù yìi mə a lə̀ə̀ nɨghàâ no aa, kaa à ka yǐ waꞌǎ nɨwo yweꞌetə̀! ");
INSERT INTO bfd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Taà yìꞌì Abraham à lɛɛ̀ ŋ̀kwo, o lɔ̀ɔ̀ aà ǹswoŋ mə ò tsyàtə Abraham aa ɛ? Ŋ̀gǎŋntoo Nwî tsɨ̀m ɨ lɛɛ̀ ŋ̀kɨ ŋkwokə. Ò mɔ̀ɔ̀ntə mə ò bə aa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu a kwiꞌi mə, “Mə̀ laa kɨ lɔ̀ɔ̀ aà nɨ̀ghaꞌà na mə̀mbɔŋ boŋ nɨ̀ghaꞌà na nya nɨ ka tsyà tsiꞌì àdàŋə̀ àdàŋə̀. Ŋù yìi mə a ghaꞌasə nɨ̂ gha aa, à laa mbə aa Taà, wa yìi mə nɨ twoŋə nɨ Nwìŋgɔ̀ŋ ghùù aà. ");
INSERT INTO bfd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kaa nɨ̀ tɛꞌɛ waꞌà yi zî, la mə̀ zi yi. M̀bə mə̀ swoŋ mə, mə̀ sɨ̀ yi zi, boŋ mə̀ bə aa ŋgàŋàbǎŋnənnù tsǒ bù. Lâ mə̀ zi yi, ŋ̀kɨɨ nləə nɨ nɨ̀ghàâ ni. ");
INSERT INTO bfd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taà ghùù Abraham à lɛ ndorɨtə a nyə nòò yìi mə mə̀ lɛ ntswe nɨ̂ zi ghu aà; à lɛ ŋkɨ nyə, ŋkɨ ndorɨtə.” ");
INSERT INTO bfd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bo swoŋ ghu mbo mə, “Kaa ò bùrə tɨ ɨlòò mɨghum mi ntaà bə, m̀baŋnə nswoŋ mə, ò lɛɛ̀ ǹyə Abraham aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu a kwiꞌi mə, “Mə̀ swǒŋ tsiꞌǐ annù nɨ̂koŋ a mbo bù mə, ‘m̀bɔŋ tâ bɨ̀ jwe Abraham boŋ mə̀ nɨ yu wa mə nɨ ghu aà.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","À swòŋ mə̂ laà, bɨ bwɛɛ̀ ŋ̀gɔ̀ꞌɔ̀ ǹlɔɔ mə bɨ tumtə yi ghu, a bə̀ə̀rə̀ m̀bwɛ yi, ǹtɨgə mfɛꞌɛ yi wa mûm ǹdâmàꞌanwì. ");
INSERT INTO bfd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu à kà mə aa ntsya, nyə ŋû yìi mə bɨ lɛ njwe a fəꞌə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ŋ̀gǎŋyəgə̂nnù ji ɨ betə̀ yi mə, “Rabbi, àa ɨ̀bɨ wo mə ɨ lɛ ŋghɨ̀rə̀ bɨ jwê ŋû ghû a fəꞌə̀ aa ɛ? Ɨbɨ ɨ lɛ mbaa aà m̀bə aà ɨ̀ yi kə̀ yì taà yì bô ǹdè yì aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu a kwiꞌi a mbo bo mə, “Kaa àfə̀ꞌə̂ yi a sɨ̀ nɨ̂ ànnǔ tsu tswê ǹloŋ ɨbɨ̂ yi kə̀ yì taà yì bô ǹdè yì bə̂. À fə̀ꞌə̀ aa mə tâ bɨ̀ tsya a njɨ̌m àfə̀ꞌə̂ yi, nyə mɨdaꞌa mɨ Nwî. ");
INSERT INTO bfd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tsǒ mə nòò à burə a siꞌinə aa, a kuꞌunə mə tâ bìꞌinə̀ ka mfaꞌa ɨfàꞌà yu wa yìi mə à too gha aà; ɨ̀tugə ɨ fii nzi ajàŋ yìi mə kaa ŋù à kaa waꞌǎ ɨfàꞌà bû ŋ̀ka mfaꞌa. ");
INSERT INTO bfd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","M̀bə yìi mə̀ tswe fàa mûm m̀bi aa, mə̀ nɨ̂ ŋ̀kàꞌa m̀bî.” ");
INSERT INTO bfd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu à swòŋ mə̂ ma mùu ajàŋ aa, ǹtwu mɨtwyɛ a nsyɛ, ntaꞌanə atsɨtsaꞌa ghu; ǹlɔgə atsɨ̀tsaꞌa ya, nyɔꞌɔ miꞌi mɨ ŋû wa ghu, ");
INSERT INTO bfd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ǹswoŋ ghu mbo mə, “Ghɛɛ nsìꞌi nsî gho a mûm àtsòòlə Siloam.” (Ǹjiꞌì ɨ̀kùm ma ghû ɨ̀ bə aa mə “ǹtoò.”) Maa ajàŋ, ŋù wa a ghɛɛ̀, ǹsiꞌi nsî yi, m̀bu ŋka mbɨɨ ntɨgə nyə nɨ̂ ɨ̀dɨ̀gə̀. ");
INSERT INTO bfd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bǎmbɛ̀ɛ̀ ǹdùgə bi bo bɨ̀ bə̀ bìi mə bɨ lɛ sɨ yə nìi, a lɔɔ̀ nɨ̂ ǹjoo a mbii aa, bɨ betə̀ mə, “À sɨ̀ ŋû wa mə à kɨ̀ sɨ tswe nɨ a mbɛ̀ɛ̀ mânjì ǹlɔɔ nɨ̂ ǹjoo aa à ghuà bə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bǐ mɔꞌɔ bɨ kwiꞌi mə, “À nɨ ghu,” la bǐ mɔꞌɔ bɨ swoŋ mə, “Ŋ̀gaŋ kaa à sɨ̀ ghu bə̂; à bə aa bə finə.” La ŋù wa yumbɔŋ a bâŋnə̀ ǹswoŋ mə, “Mə̀ bə aa ŋù ma wâ.” ");
INSERT INTO bfd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bo betə̀ yi mə, “Ò tsya aa mə akə mbɔŋ miꞌì mo ŋaꞌanə tsɨ̂tsɔ̀ŋə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A kwiꞌi a mbo bo mə, “Ŋù wa mə bɨ twoŋə nɨ Yesu aa, à ghɨrə ŋghɨ̀rə atsɨtsaꞌa, nyɔꞌɔ miꞌì ma ghu, ǹswoŋ mə tâ mə̀ ghɛɛ nsiꞌi nsî gha a atsòòlə Siloam. Mə̀ ghɛ̀ɛ̀ mə̂, ŋ̀ghɛsə ǹsìꞌì ǹsî gha aa, ǹlɔ̀gɨ̀nə̀ ǹtɨgə nyə ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bɨ betə̀ yi mə, “Yesu ghuu, à fə̀ aa ɛ?” A kwiꞌi mə, “Kaa mə̀ sɨ̀ zî.” ");
INSERT INTO bfd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bɨ lɔgə̀ ŋû wa mə à lɛ mfə̀ꞌə̀ ǹlɔgɨnə a mbɔrə aa, ŋghɛ̀ɛ̀ nɨ ghu a mbo baFarɨsai. ");
INSERT INTO bfd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ǹjwi ya mə Yesu à lɛ ntaꞌanə atsɨtsaꞌa ŋghùrə mfə̀ꞌə̀nə̀ wa ghu, a lɔgɨ̀nə̀ ǹtɨgə nyə ɨdɨgə aa, ɨ̀ lɛ mbə aa ǹjwîŋgɔ̀ŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","BaFarɨsai, yaa ŋgaa, bɨ ghɛɛ̀ nɨ̂ m̀bìì ŋkɨ mbetə ŋû wa mə à tsyà aa mə akə mbɔŋ kɨ yə ɨdɨgə lɛ. A kwiꞌi a mbo bo mə, “À ghɨrə nyɔꞌɔtə miꞌî ma nɨ̀ àtsɨtsaꞌa; à yɔ̀ꞌɔ̀tə̀ mə̀ aa, mə̀ siꞌì ǹsî gha, ǹtɨgə nyə nɨ̂ ɨ̀dɨ̀gə̀ tsɨ̂tsɔ̀ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","BaFarɨsai bî mɔꞌɔ bɨ swoŋ mə, “Kaa ŋù yìi mə à ghɨ̀rə annù ma yû aa kaa mbə waꞌà aa mbo Nwì lô, ǹloŋ mə kaa à sɨ nɔ̂ŋsə̀ ǹjwîŋgɔ̀ŋ ləə aà.” La bo bî mɔꞌɔ bɨ betə̀ mə, “M̀bə ŋù yìi mə à nɨ ŋgàŋghɨ̀rə̂ ɨ̀nnù jî bɨ a kâ ŋ̀ghɨrə ɨlènsə̀ tsiꞌì tsǒ juà aa mə akə aa ɛ?” Ma mùu ajàŋ, àyàtə̀ a lɛ ntɨgə mfɛ̀ꞌɛ̀ a tɨtɨ̀ɨ bo. ");
INSERT INTO bfd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","BaFarɨsai bû ŋ̀ghɛɛ nɨ̂ m̀bìì m̀betə ŋû wa mə, “Tsǒ mə à ghɨ̀rə ŋŋaꞌa miꞌì mo aa, ò swǒŋ mə akə nloŋ ŋgaà yì aa ɛ?” Ŋù wa a kwiꞌi a mbo bo mə, “À nɨ ŋ̀gàŋntoò Nwì.” ");
INSERT INTO bfd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kaa Bɨ̀saꞌa bɨ alaꞌa bɨ baYuda bɨ lɛ waꞌà kɔ̀ŋ mə mbə bɨ bii mə ŋù wa à lɛ mfòò m̀fəꞌə mbɔ̌ŋ bǔ kɨ yə ɨdɨgə ɨ yweꞌe a noò yìi mə bɨ lɛ ntwoŋə taà yì bô ǹdè yì, ");
INSERT INTO bfd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","m̀betə waa mə, “Ŋù ghû àa tsiꞌì mû ghùù aa ɛ? Nɨ̀ swǒŋ mə bɨ lɛ njwe yi aa a fəꞌə̀, à tɨgə̀ ǹtsya aa la tsɨ̂tsɔ̀ŋ m̀bɔŋ kɨ yə ɨdɨgə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Taà yì bô ǹdè yì kwiꞌi mə, “Bìꞌì zi mə à nɨ mû yìꞌì, ŋ̀kɨ nzi mə bìꞌì lɛ njwe yi aa a fəꞌə̀, ");
INSERT INTO bfd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","lâ kaa bìꞌì sɨ̌ ajàŋ yìi mə à tsya mbɔŋ kɨ yə ɨdɨgə tsɨ̂tsɔ̀ŋ aa zî. Kaa waꞌǎ ŋû yìi mə à ŋàꞌa miꞌì mi aa kɨ nzi. Nɨ̀ betə yi; à tɨ̀gə̂ ǹdɨ̀ɨ̂, m̀bə à tse kwiꞌi yumbɔŋə̀!” ");
INSERT INTO bfd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Taà yì bô ǹdè yì lɛ nswoŋ ma mùu ajàŋ aa nloŋ mə bɨ lɛ sɨ bɔꞌɔ bɨsaꞌa bɨ alaꞌa bɨ baYuda, ǹloŋ mə à lɛ tɨ bə aa, boŋ bô tàŋtə̀ mə̂ mə, ŋù tsù yìi mə à bìi, nswoŋ mə Yesu à nɨ̂ Àyɔꞌɔ̀ Nwì wa aa, boŋ bɨ ka fiꞌi yi a mûm ǹdâŋghòtə bo. ");
INSERT INTO bfd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","A bə̂ ǹjiꞌì ànnù yìi mə taà yì bô ǹdè yì lɛ nswoŋ mə, “À tɨgə̂ ǹdɨ̀ɨ̂; nɨ̀ betə yi aà.” ");
INSERT INTO bfd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bo bû ŋ̀kwatə ntwoŋə ŋû wa mə bɨ lɛ njwe a fəꞌə̀ aa ŋgaa yìi mə ɨ̀ yweꞌe ji baa aa, nswoŋ ghu mbo mə, “Ghaꞌasə Nwî, ǹswoŋə annù nɨ̂ŋkoŋə̀ yô! Bìꞌì zi mə ŋù ghû mə à ghɨ̀rə ŋghùrə̀ gho aa, à nɨ̂ ŋ̀gàŋghɨ̀rə ɨ̀nnù jî bɨ̂.” ");
INSERT INTO bfd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ŋù wa a kwiꞌi mə “Kaa mə̀ sɨ̀ gha zi mə ŋù ghû à nɨ ŋgàŋghɨ̀rə ɨ̀nnù jî bɨ kə̀ à sɨ̀ ghu bə̂. Ànnù yî fùùrə̀ yìi mə mə̀ zi aa a nɨ mə; mə̀ lɛ mfə̀ꞌə̀, lâ, tsɨtsɔ̀ŋ, mə yə ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bo betə mə, “À ghɨ̀rə ŋghɨ̀rə̀ aa mə akə a nu wò aa ɛ? À ghɨ̀rə ŋŋaꞌa miꞌì mo aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A kwiꞌi a mbo bo mə, “Tɨgə mə̀ bà mə aa nswoŋ a mbo bù, kaa nɨ̀ waꞌà nɨ̀ ghuu kɔŋə̀ nɨ a nyuꞌutə̀! Ǹjiꞌì ànnù yìi mə nɨ bù ǹlɔɔ mə mə̀ kwatə aa, à nɨ̂ àkə̀ aa ɛ? À bə tsò nɨ kɨɨ nlɔɔ nɨ̂ m̀bə̂ ŋ̀gǎŋyəgə̂nnù ji aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","À kwìꞌì mə̂ laà aa, bɨ bəgɨ̀tə̀ yi, ǹswoŋ mə, “Ò nɨ ŋ̀gàŋyəgə̂nnù m̀bâ ma wa yì mɔ̀ꞌɔ̂; la a mbo bìꞌì, bìꞌì bə aa ŋgǎŋyəgə̂nnǔ Moses. ");
INSERT INTO bfd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bìꞌì zi mə Nwì à lɛ ŋghàà a mbo Moses; lâ ŋ̀ghɛɛ nɨ̂ m̀bâ ghû, kaa bìꞌì tɛꞌɛ waꞌǎ adɨgə yìi mə à lo ghu aa zî.” ");
INSERT INTO bfd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ŋù wa a kwiꞌi a mbo bo mə, “Ànnù muù à nɨ̂ ànnu mə a tsya ghâ. Kaa nɨ̀ sɨ adɨgə yìi mə à lo ghu aa zi, la a bâŋnə̀ ŋ̀ghurə gha nɨ̀ àfə̀ꞌə̂ ya! ");
INSERT INTO bfd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","“La bìꞌinə̀ zi tsiꞌì sɨgɨ̀nə̀ mə kaa Nwì à sɨ annù a mbo ŋgǎŋghɨ̀rə ɨnnù jî bɨ yuꞌutə; La ŋu yìi mə a bɔꞌɔ nìi ŋkɨɨ ŋghɨrə nɨ̂ ɨ̀nnù jìi mə a lɔ̀ɔ̀ aà, Nwi a yuꞌutə annu ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","“Ǹlɔgɨnə a mbèꞌènə mbi, kaa ŋù tsù à lɛɛ̀ ŋ̀waꞌà yuꞌu mə ŋù tsù à lɛɛ̀ ŋ̀ŋaꞌa miꞌi mɨ ŋû yìi mə bɨ lɛ njwe a fəꞌə aa a kâ ǹyə ɨdɨgə! ");
INSERT INTO bfd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","M̀bə ŋù ghû a tsuu aa a mbo Nwǐ lǒ, boŋ kaa mbə a waꞌà zî àjàŋ yìi mə mbə yu ghɨrə̀ ànnù tsiꞌì tsǒ yuà.” ");
INSERT INTO bfd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bo kwiꞌi ghu mbo mə, “Bɨ lɛ njwe gho aa a mûm ɨ̀bɨ yìi ɨ swerə, ò tɨgə̀ ǹlɔɔ aà ŋ̀ka ndɨ̀ꞌɨ̂ yiꞌi aa ɛ?” Bɨ swòŋ mə̂ laa aa, mfurə yi a mûm ǹdâŋghòtə bo. ");
INSERT INTO bfd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu à yùꞌù mə annù yìi mə a lɛ mfɛ̀ꞌɛ̀ aa, ǹlɔɔ ŋû wa, m̀betə yi mə, “Ò nɨ̌ŋ ǹtɨɨ̂ gho a nu Mu Ŋù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ŋù wa a kwiꞌi ghu mbo mə, “Swoŋə ŋû yìi mə Mu Ŋù à nɨ ghu aa, a mbo mə̀, Taà ghà, tǎ tâ mə̀ bii yi.” ");
INSERT INTO bfd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu a swoŋ ghu mbo mə, “Ò yə̀ mə̂ yi, wa à nɨ yu yìi mə a ghàà a mbo wò tsɨ̂tsɔ̀ŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ŋù wa a swɛ̂tə̀ mɨ̀kùꞌùtə̂ mi a nsi Yesu ǹswoŋ ghumbo mə, “M̀màꞌàmbî, mə̀ bìî!” ");
INSERT INTO bfd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu a swoŋ mə, “Mə̀ lɛ nzì fàa mbi aa mə bɨ ka nsaꞌa bə̂, mə tâ bɨ̀fə̀ꞌə̀nə̀ ka nyə ɨdɨgə, tâ bə̀ bìi mə bɨ bàŋnə̀ ǹyə ɨdɨgə aa, tâ bɨ̀ fəꞌə.” ");
INSERT INTO bfd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","BaFarɨsai bî mɔꞌɔ bìi mə bɨ lɛ ntswe ghu nyuꞌu ajàŋ yìi mə à swoŋ ma mùu ajàŋə̀ aa, m̀betə̀ ghu mbo mə, “Bìꞌì mɔ̀ɔ̀ntə mə kaa ò sɨ lɔ̀ɔ̀ aà ǹswòŋə mə bìꞌì kɨ mfə̀ꞌə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu a kwiꞌi a mbo bo mə, “À laa bə mə nɨ̀ fə̀ꞌə boŋ kaa ɨ̀saꞌa ɨ sɨ a nu bu kuu; la mbə yìi mə nɨ bàŋnə̀ m̀mɔɔntə nɨ mə nɨ yə ɨdɨgə aa, àa ǹjiꞌì ànnù yìi mə ɨ̀saꞌa ɨburə a nu bù aà.” ");
INSERT INTO bfd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu a swoŋ mə, “Mə swoŋ aa tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù; ŋù yìi mə à sɨ bə a ntsǔ ŋkya tsyà ŋ̀kuu nɨ a ŋkya mbînjə̀rə̀, m̀baŋnə ŋkɔꞌɔ nɨ bə a atu ŋkya ŋkuu aa, à nɨ̂ ǹyə̀rə̂, ŋ̀kɨ mbə aŋgâmɨghee. ");
INSERT INTO bfd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ŋù yìi mə a tsyǎ a ntsǔ ŋkya, ŋkuu nɨ a ŋkya mbi aa, à nɨ̂ ǹtsèèmbî. ");
INSERT INTO bfd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ŋù yìi mə a bɛ ntsǔ ŋkya aa, a ŋaꞌà nɨ̀ ǹtsǔ ŋkya ghu mbô; m̀bi jya ɨ yuꞌù nɨ̀ ǹjì yì, a twoŋ nɨ̂ waa a kumə; ǹtɨgə ntsyasə nɨ̂ waa ɨ fɛꞌɛ̀. ");
INSERT INTO bfd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nòò yìi mə à fìꞌìsə̀ mə̂ waa laa, a kâ ŋ̀ghɛɛ nɨ a mbìì, m̀bi jya ɨ tɨgə̀ ǹyoŋə, ǹloŋ mə ɨ zî ǹjì yì aà. ");
INSERT INTO bfd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ŋ̀gɨ̀ɨ̀ à bə zì boŋ kaa ɨ sɨ̀ yi yoŋə̀, m̀baŋnə ŋkhə̀ nɨ̂ yi khə̀, ǹloŋ mə kaa ɨ sɨ̌ njì ŋ̀gɨ̀ɨ̀ zi aà.” ");
INSERT INTO bfd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu à lɛ nswoŋ nɨghàà nî nǎnaa ma nû a mbo bo, la kaa bo waꞌǎ annù yìi mə à lɛ sɨ swoŋ a mbɔ bo aa zî. ");
INSERT INTO bfd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu a bû ŋ̀kwatə nswoŋ mə, “Mə swoŋə aa tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù: Mə̀ nɨ ntsǔbùꞌu mbînjə̀rə̀. ");
INSERT INTO bfd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntsyǎ mbìì yà aa, à nɨ bɨ̀yèrə ŋkɨ mbə bâŋgâmɨghee. La kaa mbi jya ɨ lɛ waꞌǎ njì yàà yuꞌutə̀. ");
INSERT INTO bfd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mə̀ nɨ̂ ǹtsǔbùꞌù. Ŋù yìi mə à tsyà nɨ mə̀ ŋ̀kuu aà, à ka yweenə; àa kɨ kuu ɨ kɨɨ fɛ̀ꞌɛ, ɨ kɨɨ yə nɨ̂ ŋ̀gɛ̀ɛ̀ yî ǹsɨgɨ̀nə̀ a ŋkurə̂. ");
INSERT INTO bfd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ǹyərə a kɨɨ nzi aa tsiꞌǐ a nyə̀rə, ɨ zwitə, ɨ kɨɨ ta ŋgɨꞌɨ ghu. Lâ mə̀ zǐ aa mə tâ bɨ̀ tswe nɨ ǹtswêntɨ̀ɨ̀, ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ luu aà. ");
INSERT INTO bfd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mə̀ nɨ ǹtsèèmbi yì ǹsɨgɨ̀nə̀. Ǹtsèèmbî yì ǹsɨgɨ̀nə̀ a kɔ̀ŋə̀ nɨ̂ mfâ ǹtswêntɨ̀ɨ̂ yì m̀bɨꞌɨ ŋkwitu mbinjə̀rə̂ ji. ");
INSERT INTO bfd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ŋ̀gàŋàfàꞌà yìi mə bɨ twu nìi twu, kaa a waꞌǎ ntsèèmbi bə, kaa waꞌǎ mbɔ̂ŋ m̀bi kɨ mbə aa, à bə yə naàŋgwyɛ̀ tâ ɨ̀ ka nzi, boŋ à màꞌàtə̂ m̀bi jya ŋkhə̀ yi; nààŋgwyɛ̀ ya ɨ kô m̀bi jya, àbùgə̀ a kɨ̂ ǹjaꞌanə. ");
INSERT INTO bfd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","“Ŋù wa mə bɨ twu nìi twu aa, a khə̀ nìi aa nloŋ mə kaa mbi jya sɨ̌ ji bə, kaa a waꞌà kɨ̀ɨ̀ ǹlaŋtə nɨ̂ ànnù ǹloŋ ŋgaa yàà aà. ");
INSERT INTO bfd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Mə̀ nɨ̂ ǹtsèèmbi yì ǹsɨgɨ̀nə̀, mə̀ zi mbî jâ, ɨ kɨ̂ ǹzi ghâ, ");
INSERT INTO bfd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","a kɨ̂ mbə ajàŋ yìi mə Taà ghà à zi gha mə̀ kɨ̂ ǹzi Taà ghà aà. Mə̀ kɔ̀ŋə̂ m̀fâ ǹtswə̂ntɨ̀ɨ̂ yà ɨ kwo mbɨ̀ꞌɨ ŋkwitû waa. ");
INSERT INTO bfd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","M̀bî ja jǐ mɔꞌɔ ɨ tswe ghu jìi mə kaa ɨ sɨ̀ mûm àkàrə mbi yulà tswê. Mə̀ tswe nɨ̀ ŋ̀kɨ nlɔ̀gə̂ waa ɨ kɨɨ zì nɨ ju; ɨ ka tɨgə yuꞌu nɨ̂ ǹjì yà, ɨ tɨgə bə akàrə mbi yì fùùrə̀, ɨ kɨɨ tswe nɨ̂ ǹtsèèmbi yì m̀fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ǹjiꞌì ànnu yìi Taà ghà à kɔ̀ŋə gha aa à nɨ mə mə kɔ̀ŋə mfâ ǹtswêntɨ̀ɨ̂ yà tǎ bɔ̌ŋ bǔ kwɛrə fu. ");
INSERT INTO bfd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kaa ŋù tsù m̀bə waꞌǎ ntswêntɨ̀ɨ̂ yà a mbo mə̀ kwɛrə̀. Mə̀ aa fa ntswêntɨ̀ɨ̂ yà aa tsiꞌǐ a ŋkɔ̀ŋə mə̀. Mə tswe nɨ̀ mɨ̀dàꞌà mə mbə mə̀ fâ, ŋ̀kɨ ntswe nɨ mɨ̀dàꞌà mə mbə mə̀ bû ŋ̀kwɛrə fu. Àâ ànnù yìi mə Taà ghà à swǒŋ mə ta mə̀ aa ŋghɨrə aà.” ");
INSERT INTO bfd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma nuà nɨ̀ghàà nɨ bû ǹzi nɨ̂ ǹyàtə a tɨtɨ̀ɨ baYuda byâ. ");
INSERT INTO bfd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bo bî ghàꞌàtə̀ lɛ sɨ swoŋə nɨ mə, “À tswe nɨ̀ àzwì yî bɨ̂! A baanə aà bàànə̀! Nɨ yuꞌutə nɨ̂ ànnù yìi mə a swoŋ aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","La bǐ mɔꞌɔ bɨ swoŋə̀ nɨ mə, “Ŋù yìi mə à tswe nɨ̂ àzwì yî bɨ aa kaa mbə waꞌà lalà ka ŋghaa! M̀bə àzwì yî bɨ a ghɨrə̀ bɨ̀fə̀ꞌə̀nə̀ ka ǹyə ɨdɨgə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","À lɛ mbə maà noò laa, a bə nòò m̀fəꞌə̀, ŋ̀kɨ bə noò yìi mə bɨ lɛ sɨ jɨ ɨkoò Ǹsìꞌìtə̂ ǹdâmàꞌanwì a Yerusalem aà. ");
INSERT INTO bfd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu à lɛ sɨ ghantə ntəə ŋkɔꞌɔ mbu nsɨgə wa adɨgə mə bɨ lɛ sɨ twoŋə nɨ̂ Ǹtsǔbuꞌu Solomon aà. ");
INSERT INTO bfd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","BaYuda bɨ ghotə̀ ŋ̀karɨsə yi mbetə yi mə, “Ò ka lə̀ə̀ yiꞌi a njɨm ɨ yweꞌe aa a noò àkə̀ aa ɛ? Swoŋ tâ à laa atu bìꞌì: Ò bə aa Àyɔꞌɔ̀ Nwì wa aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu a kwiꞌi a mbo bo mə, “Mə̀ fòò mə̂ ǹswoŋ a mbo bù la kaa nɨ̀ waꞌǎ annù yìi mə mə̀ swòŋ aa biì. Mɨ̀fàꞌà mìi mə mə fàꞌa nɨ̂ ɨ̀kǔm Taà ghà aa, mɨ dɨ̀ꞌɨ̀ nɨ̂ ŋû yìi mə mə̀ nɨ ghu aà; ");
INSERT INTO bfd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","la kaa nɨ̀ waꞌà biì ǹloŋ mə kaa nɨ̀ sɨ̌ mbînjə̀rə̂ ja bə aà. ");
INSERT INTO bfd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","M̀binjə̀rə̂ ja ɨ yuꞌu nɨ̂ ǹjì yà; mə̀ zî waa, ɨ kɨɨ̀ ǹyoŋə nàâ. ");
INSERT INTO bfd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mə̀ fa nɨ̂ ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌi nɨ̂ŋkoŋ aa a mbo bo, kaa tâ bo yi waꞌà kwô bə̂. Kaa ŋù tsù kaa a yǐ waꞌà waa a mbo mə̀ twɛɛ ŋkwɛrə. ");
INSERT INTO bfd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taà ghà yìi mə à fa waa a mbo mə̀ aa, à tswe nɨ̀ àdàꞌà ǹtsyatə njoò ɨ̀tsɨ̀mə̀, kaa ŋù tsù sɨ̀ ghu tswê yìi mə mbə a twɛɛ̀ waa a mbo Taà ghà ŋ̀kwɛrə. ");
INSERT INTO bfd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mə̀ nɨ Taà ghà, bìꞌi yu bə aa ayoo yì fùùrə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","BaYuda bya bɨ yùꞌù mə̂ ma la aa, mbwɛɛ ŋgɔ̀ꞌɔ̀ mə bɨ bǔ tumtə yi ghu. ");
INSERT INTO bfd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu a swoŋ a mbo bo mə, “Mə̀ ghɨ̀rə̀ mə ɨ̀nnù jî ghàꞌàtə̀ jǐ sɨgɨ̀nə a nsi miꞌi bù, jìi mə Taà ghà à fa mə tâ mə̀ ghɨrə; àa yuu annù a tɨtɨ̀ɨ ɨ̀nnù ma jû yìi mə a ghɨrə ǹtɔ̀ŋə̂ ghuu ɨ lwî nɨ̀ tɨgə̀ ǹlɔɔ a tumtə gha aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bo kwiꞌi ghu mbo mə, “Kaa bìꞌì sɨ lɔ̀ɔ̀ a ntumtə̂ gho aa nloŋə ànnù yî sɨgɨ̀nə̀ ma yû yî tsu mə ò ghɨ̀rə aà. Lâ bìꞌi lɔ̀ɔ ntumtə̂ gho aa nloŋ mə ò bə̀gɨ̀tə Nwî! Ò bə aa tsiꞌì ŋùmɨ̀sɔ̀ŋ lâ m̀baŋnə ntɨgə nlɔɔ nɨ̂ ǹlɔ̀gə̂ ɨ̀bɨ̀ɨnû gho mə ò bə aa Nwì!” ");
INSERT INTO bfd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu a kwiꞌi a mbo bo mə, “Tɨgə bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ nɔ̂ŋsə̂ buu mə Nwì à lɛ nswoŋ mə, ‘Nɨ̀ nɨ bɨ̀nwì’? ");
INSERT INTO bfd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bìꞌinə̀ zi mə kaa mbə bɨ waꞌǎ annù yìi mə a tswe a mûm àŋwàꞌànə Nwì aa kwensə̀; mbə Nwì a twoŋ bə̀ bya mə à lɛ mfa ntoò yì a mbo bo aa nɨ bɨ̀nwì, ");
INSERT INTO bfd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","a tsyâ aa mə akə nɨ̀ swoŋ a mbo yu wa yìi mə Tà a tsɔꞌɔ nɨ̂ àyoo afàꞌâ yi, ntoo fàa mûm m̀bi aa, mə a bə̀gɨ̀tə Nwî, ǹloŋ mə à swòŋə mə, ‘Mə̀ nɨ Mu Nwì’ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mbə a bə yìi mə kaa mə sɨ ɨ̀nnù jìi mə Taà ghà à swǒŋ mə tâ mə̀ ka ŋghɨrə aa ghɨ̀rə̀, nɨ̀ tsuu mɨ̂ntɨɨ̀ muu a nu mə̀ nnɨŋə. ");
INSERT INTO bfd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lâ m̀bə mə̀ ka ŋghɨrə aa ma juù ɨ̀nnù, ka mə nɨ̀ sɨ̀ gha bii aa, a kuꞌùnə̀ mə boŋ nɨ̀ laa mbii ɨnnù jìi mə mə ghɨ̀rə̀ aà, tǎ zi ŋgaa yî mɔ̀ꞌɔ mə Taà ghà à tswe a mûm mə̀, mə̀ kɨ̂ ntswe a mum Taà.” ");
INSERT INTO bfd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bɨ bû ǹlɔɔ mə bɨ baŋnə yi, a wiꞌìkə̀ m̀bwɛ yi a tɨtɨ̀ɨ bo. ");
INSERT INTO bfd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu a bû ǹlo ndàŋsə̀ ǹtoo a njii ŋ̀kǐ Jordan, wa adɨgə mə Jɔn à lɛ sɨ murə bə̂ ghu a ŋkì aà, ǹtɨgə ntswe ghu. ");
INSERT INTO bfd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bə̀ bî ghàꞌàtə̀ lɛ nzì ghu mbô. Bo lɛ sɨ swoŋə nɨ mə, “Jɔn, kaa à lɛ waꞌǎ ɨ̀lènsə̀ ghɨrə̀, lâ ɨ̀nnù tsɨ̀m jìi mə à lɛ nswoŋ nloŋ ŋgaa ŋù ghuà aa, ɨ fɛ̀ꞌɛ̀ mə̂ ǹlaa.” ");
INSERT INTO bfd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bə̀ bî ghàꞌàtə̀ bìi mə bɨ lɛ nzì ghu aa bɨ nɨŋ mɨ̂ntɨɨ̀ myaa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ŋù yî mɔ̀ꞌɔ à lɛ ntswe ghu, ɨ̀kûm yi ɨ bə Lazarus, ǹtswe nɨ a alaꞌa Bethany, ŋ̀ghɨrə ŋwò nɨghɔ̀ɔ̀. Bethany ghû à lɛ mbə alaꞌa yìi mə Mary bo mumaà yì Martha lɛ sɨ tswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mary ma ghû, à nɨ wa mə à lɛ ŋkùrə̀ mɨghurə mɨ àtɨ̀ndùù mya a mɨkòrə Yesu ǹtɨgə nyɛꞌɛ nɨ̂ ɨ̀nǒŋtû ji aà. Lazarus ghû mə à lɛ sɨ ghɔ̀ɔ̀ aa, a lɛ mbə mumaà yì yî m̀bâŋnə̀.) ");
INSERT INTO bfd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bɨ̀jààntə̀ bi bya bɨ lɛ ntoo ŋkɨ̀ɨ̀ a mbo Yesu ǹswoŋ ghu mbo mə, “M̀màꞌàmbî, ǹsûkàꞌâ ghò wa mə ò kɔ̀ŋə aa a ghɔ̀ɔ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nòò yìi mə Yesu à lɛ nyuꞌu ŋkɨ̀ɨ̀ ghu aa, nswoŋ mə, “Kaa nɨ̀ghɔ̀ɔ̀ nɨ Lazarus nû kaa nɨ ka waꞌà aa nɨ nɨ̀wo lwìꞌìsə̀; nɨ̀ghɔ̀ɔ̀ nû nɨ zi aa mə nɨ zì nɨ nɨ̀ghaꞌa a mbo Nwì, ɨ kɨɨ bə mânjì yìi mə Mu Ŋù a ka kɨɨ kwɛrə nìi nɨghaꞌa ghu.” ");
INSERT INTO bfd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu à lɛ ŋkɔ̀ŋə̀ Martha nɨ mumaà yì Mary nɨ Lazarus. ");
INSERT INTO bfd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ka mə à lɛ ŋkɔ̀ŋə̀ waa tsiꞌǐ annù aa, à kwɛ̀rə̀ mə̂ ŋ̀kɨ̀ɨ̀ nɨghɔ̀ɔ̀ Lazarus wa aa, m̀bu ntswe maa adɨgə njwi ji baà. ");
INSERT INTO bfd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ǹjwi jya ji baa ɨ tsyà mə aa, a swoŋ a mbo ŋgǎŋyəgə̂nnù ji jya mə, “Nɨ̀ ghɨrə bìꞌinə̀ bu mbɨ̀ɨ̀ ŋ̀ghɛɛ fu a alaꞌa Yudea.” ");
INSERT INTO bfd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ kwiꞌi ghu mbo mə, “Rabbi, ò wàꞌàtə mə kaa aghaꞌa a burə tɨ̀ sàꞌàtə̀ mə, bə̀ bɨ adɨgə ma bya kɨ lɔ̀ɔ ntùmtə wò nɨ̂ ŋ̀gɔ̀ꞌɔ̀, ò bû ǹlɔɔ nɨ̂ m̀bɨɨ ghɛ̀ɛ̀ ghu aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu a swoŋə a mbo bo mə, “Tɨgə ɨ̀bàŋtə̀ noò ɨ tswe nɨ̂ ǹjwi aa nɨ̀ghûm ǹtsò baa aa ɛ? Maa ajàŋ, ŋù ǹtsɨ̀m yìi mə a karə a siꞌinə aa, kaa à sɨ mɨkòrə̂ mi tumtə ŋwo, ǹloŋ mə a yə nɨ̂ ŋ̀kàꞌa mbi ghù aà. ");
INSERT INTO bfd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lâ ŋù yìi mə a zì nɨ̂ ɨ̀tugə aa, a fɨɨ̀ŋkə̀ ŋ̀wo, ǹloŋ mə kaa à sɨ̀ nɨ̂ ŋ̀kàꞌà tswê.” ");
INSERT INTO bfd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu à swòŋ mə̂ ma la aa, m̀bù ŋ̀kuꞌusə mə, “Ǹsûkàꞌa yìꞌinə̀ Lazarus a bwii aa bwìì, lâ mə ka ghɛ̀ɛ ɨ tsɨ̀gɨ̀tə̀ yi tâ à bɨɨnə fɨlô.” ");
INSERT INTO bfd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ŋ̀gǎŋyəgə̂nnù ji ɨ kwiꞌi ghu mbo mə, “M̀màꞌàmbî, m̀bə a ka mbwii aa bwìì boŋ à ka bǔ bɨ̀ɨ̀nə ɨ tswe fu ntɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu à lɛ sɨ lɔ̀ɔ̀ aà ǹswoŋ mə Lazarus à kwô aa kwò, lâ ŋ̀gǎŋyəgə̂nnù ji ɨ bâŋnə̀ m̀mɔɔntə mə Yesu a swoŋ aa tsiꞌì fɨ̀lo fì bwìì. ");
INSERT INTO bfd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu a tɨgə̀ ŋ̀ghɛɛ nɨ̂ m̀bìì ǹlaansə a mbo bo mə, “Lazarus à kwò mə̂, ");
INSERT INTO bfd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lâ ǹloŋ ŋkwitû ghuu, mə̀ dòrɨ̀tə mə kaa mə̀ ghɨ̀rə ŋwaꞌà biꞌi yu tswê aa, tǎ tâ nɨ̀ tsya ghu mbii. Tsɨ̂tsɔ̀ŋ nɨ̀ ghɨrə bìꞌinə̀ ghɛɛ ghu mbɛ̀ɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas, wa mə bɨ lɛ sɨ twoŋə nɨ mu bɨ̀nwì aa, a swoŋ a mbo ŋgǎŋyəgə̂nnù Yesu jya jǐ mɔꞌɔ mə, “Nɨ̀ ghɨrə tâ bìꞌinə̀ yoŋə ndɨ̀ꞌɨ̀nnù yiꞌinə̀ tâ bìꞌinə̀ nɨ̀bo ghɛɛ tà a bə nɨwo, bìꞌinə̀ nɨ̀bò kwô!” ");
INSERT INTO bfd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nòò yìi mə Yesu à lɛ nzì ŋkuꞌu a Bethany aa, nyə mə à lɛ tɨ bə aa boŋ Lazarus à kwò mə̂, bɨ twiŋə̀ yi, ǹjwi ɨ tsyâ ji nɨkwà. ");
INSERT INTO bfd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A nlǒ a Bethany ŋghɛɛ nyweꞌe a Yerusalem à lɛ mbə tsǒ bɨmalə̀ bi baà, ");
INSERT INTO bfd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","maa ajàŋ baYuda bî ghàꞌàtə̀ bɨ lɛ nzì a mbɛ̀ɛ Martha bo Mary a nləꞌətə mɨ̀ntɨɨ̀ myaa nloŋ annù nɨwo mumaà wàà wâ. ");
INSERT INTO bfd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nòò yìi mə Martha à lɛ nyuꞌu mə Yesu a zì aa, mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ a mbòô yi, la Mary a bâŋnə̀ ǹtswe a ndâ. ");
INSERT INTO bfd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha à ghɛ̀ɛ̀ mə̂ m̀boo Yesu aa nswoŋ ghu mbo mə, “M̀màꞌàmbî, ò kɨ̀ baa tswe faà boŋ kaa mumaà gha ghû kaa à sɨ̀ kwô! ");
INSERT INTO bfd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lâ mə̀ zi tsiꞌǐ annù nɨ̂ŋkoŋ mə, tsiꞌì tsɨ̀tsɔ̀ŋ ò bə betə annù yìi mə o lɔ̀ɔ̀ aa, boŋ Nwì à ka fa a mbo wò.” ");
INSERT INTO bfd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu a swoŋ ghu mbo mə, “Mumaà ghò ghû à ka bǔ bɨ̀ɨ̀nə̀ fu.” ");
INSERT INTO bfd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha a kwiꞌi ghu mbo mə, “Mə̀ zi mə à ka yǐ bɨ̀ɨ̀nə̀ fu a noò yìi mə bɨku bɨ bə̂ ka yǐ yweenə nɨwo a njwî ǹlwìꞌìnjɨ̀mə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu a swoŋ ghu mbo mə, “Mə̀ nɨ ǹywèènə nɨ̀ nɨ̀wo, ŋkɨ mbə ntswêntɨ̀ɨ̀. Ŋù ǹtsɨ̀m yìi mə à nɨ̌ŋ ntɨɨ̀ yì a nu mə̀ aa, à ka tswe ntɨ̀ɨ̀, ka mə mbə a tɛꞌɛ ŋkwo kwo. ");
INSERT INTO bfd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ŋù ǹtsɨ̀m yìi mə à ntswe ntɨ̀ɨ̀ ŋ̀kɨ nɨŋ ntɨɨ̀ yì a nu mə̀ aa, kaa à ka yǐ waꞌà kwô. Ò bii ma yû ànnù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha a kwiꞌi mə, “Ɨ̀ɨ̀ŋə, M̀màꞌàmbî, mə̀ bìî! Mə̀ bìi mə ò laa mbə Ayɔꞌɔ̀ Nwì, m̀bə Mu Nwì, wa yìi mə à lɛ ntswe nɨ̂ m̀fɛ̀ꞌɛ fàa mbi aà.” ");
INSERT INTO bfd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha à swòŋ mə̂ ma mùu ajàŋ aa, ŋ̀ŋeꞌesə mbɨɨ ŋghɛ̀ɛ a ntwoŋ mumaà yì Mary. À ghɛ̀ɛ̀ mə̂ aa nswoŋ ghu mbo mə, “Ǹdɨ̀ꞌɨ̀nnù à zì mə̂, à laa ŋkɨɨ mbetə nɨ̂ ghô.” ");
INSERT INTO bfd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary à yùꞌù mə̂ aa mburə mbɨɨnə mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ a mbòô yi. ");
INSERT INTO bfd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(À lɛ sɨ bə maa noò aa boŋ kaa Yesu kaa à burə tɨ̀ wa ǹjɔ̀ꞌɔ̀ àlaꞌa ŋghɛ̀ɛ̀ ŋ̀kuu, lâ m̀burə aa tsiꞌì wa adɨgə mə Martha à ghɨ̀rə mmàꞌàtə̀ yi ghu aà.) ");
INSERT INTO bfd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","BaYuda bìi mə bɨ lɛ ntswe a mûm ǹda bo Mary wa adɨgə nɨwo aa, bɨ yə̀ mə̂ a jàŋ yìi mə à bɨ̀ɨ̀nə ŋka mfɛꞌɛ ŋghɛ̀ɛ̀ aa, m̀mɔɔntə mə a ghɛ̀ɛ̀ aa wa atu nɨsyɛ̀ a nyə̀ꞌə ghu, ǹtɨgə nyoŋə nìi. ");
INSERT INTO bfd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary à ghɛ̀ɛ̀ mə̂ ŋ̀kuꞌu wa adɨgə yìi mə Yesu à lɛ ntswe ghu aa, nyə yi, ŋ̀wò ghu mɨkòrə̀, ǹswoŋ mə, “M̀màꞌambî, ò kɨ̀ baa bə tswe faà boŋ kaa mumaà ghà ghû kaa à sɨ̀ kwô!” ");
INSERT INTO bfd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu à yə̀ mə̂ àjàŋ yìi mə Mary bo bɨ̀ bə̀ bya mə bo bo zi aa, bɨ yə̀ꞌə̀nə̀ aa ǹjəŋnə ŋkɨ ŋko mɨlɨ̀ŋnə̀ wàà tsiꞌǐ annù nɨ̂ŋkoŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu a betə̀ waa mə, “Nɨ̀ twìŋə yi aa fə aa ɛ?” Bo kwiꞌi ghu mbo mə, “M̀màꞌàmbî, zǐ nyə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu a yəꞌə̀. ");
INSERT INTO bfd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bə̀ bìi mə bɨ lɛ ntswe ghu aa bɨ swoŋ mə, “Nɨ̀ yə̂ àjàŋ yìi à lɛ ŋkɔ̀ŋə̀ yi aà!” ");
INSERT INTO bfd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","La bo bî mɔꞌɔ bɨ swoŋ mə, “À lɛ mbaa waꞌà ghɨ̀rə̀ tâ bɨ̀fə̀ꞌə̀nə̀ ka nyə ɨ̀dɨ̀gə̀ aa ɛ? À kɨ̀ waꞌà kɨ̀ ǹzi a ajàŋ yìi mə mbə yu ghɨrə̀ Lazarus a tswe tɨ kwo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Àjəŋnə̀ a bû ǹtswa Yesu tsiꞌǐ mbə̂ ànnù, a ghɛɛ̀ wa atu nɨsyɛ̀ mə bɨ lɛ ntwiŋə Lazarus ghu aà (nɨ̀syɛ̀ ma nû lɛ mbə aa àbùꞌù mə bɨ to a mûm ŋ̀gɔ̀ꞌɔ̀, ŋ̀kɨ ŋkusə ntsù yi nɨ̂ ŋ̀gɔ̀ꞌɔ̀). ");
INSERT INTO bfd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu à zì mə̂ ghu aa, nswoŋ a mbo bo mə, “Nɨ̀ lɔꞌɔsə ŋgɔ̀ꞌɔ̀ ya wa ntsù nɨ̀syɛ̀!” Martha, ǹjààntə ŋkû ŋù wa, a kwiꞌi ghu mbo mə, “M̀màꞌàmbî, àyàꞌà a ka lùm siꞌi siꞌi ǹloŋ mə à nɨ njwi ji nɨkwà tsɨ̂tsɔ̀ŋ a jàŋ yìi mə bɨ kɨ̀ twìŋə aà!” ");
INSERT INTO bfd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu, a swoŋ ghu mbo mə, “Mə̀ ghɨrə mbaa waꞌǎ a mbo wò swoŋ mə, ò ka yə nɨghaꞌa nɨ Nwî, mə mbə wò bii aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bo lɔꞌɔ̀sə̀ ŋ̀gɔ̀ꞌɔ̀ ya mə bɨ lɛ ŋkusə ntsù nɨsyɛ̀ nya ghu aà. Yesu a ŋɛntə̀ miꞌì mi a ndəŋ nswoŋ mə, “Taà ghà, mə̀ fa mbɨꞌɨkə a mbo wò, ǹloŋ mə o yuꞌutə nɨ̂ ànnù yìi mə mə swoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mə̀ zi mə o yuꞌutə nɨ̂ ànnù yìi mə mə swoŋ aa ŋgɔ̀ŋ bɨ̀nòò bɨ̂tsɨ̀mə̀, lâ mə lɔ̀ɔ a nswoŋə yulà ànnù tsɨ̂tsɔ̀ŋ aa nloŋ ŋkwitu nnɔ̀ɔ̀ bə̂ bûlà faà, tǎ tâ bo bii mə a gha aa a tòo wò.” ");
INSERT INTO bfd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","À màŋsə̀ mə̂ a nswoŋ ma mùu ajàŋ aa, ǹtwoŋə Lazarus tsiꞌì nɨ̂ ǹjì yî ǹtɨ̀ɨ̀, mə, “Lazarus, fɛ̀ꞌɛ nzî!” ");
INSERT INTO bfd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazarus, a fɛꞌɛ̀, m̀burə nɨ̂ ɨ̀tsə̀ꞌə̀ jya jìi mə bɨ lɛ lɨmtə mbô mi, nɨ mɨ̀kòrə̂ mi, a bɔ̀ꞌɔ nsî yi ghu mbɔŋ ntwiŋ aà. Yesu a swoŋ a mbo bo mə, “Nɨ̀ fɛɛ ɨtsə̀ꞌə̀ jya ghu nu, m̀màꞌàtə̀ yi tâ à ghɛɛ.” ");
INSERT INTO bfd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","BaYuda bya bì ghàꞌàtə̀ mə bɨ lɛ nzǐ a mbɛ̀ɛ Mary wa adɨgə nɨwo aa, bɨ lɛ nyə annù ya yìi mə Yesu à lɛ ŋghɨ̀rə̀ aa, nnɨŋ mɨ̂ntɨɨ̀ myaa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","La bo bî mɔꞌɔ bɨɨ̀ ŋ̀ghɛɛ a mbo baFarɨsai ǹswoŋə annù yìi mə Yesu à lɛ ŋghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Maa ajàŋ, baFarɨsai bo bɨ̀ bɨlɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì, bɨ ghɛɛ̀ m̀boonsə bo bɨ̀ ŋ̀gǎŋndasaꞌa, ǹswoŋ mə, “Bìꞌinə̀ ka ghɨ̀rə̀ aa mə akə aa ɛ? Nɨ̀ yə ɨ̀leǹsə̀ jî ghàꞌà ŋ̀ghaꞌa mə ŋù ghû a ghɨ̀rə̀ aà! ");
INSERT INTO bfd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bìꞌinə̀ bə màꞌàtə̀ yi tâ à ka ŋghɛɛ nɨ̂ m̀bìì ma mùu ajàŋ boŋ bə̀ bɨ̀tsɨ̀m ka bii annù yi, tâ bɨ̀tà bɨ alaꞌa bɨ baRoma bɨ̀ zi nta ŋgɨꞌɨ nɨ̂ ǹdâmàꞌanwì yìꞌinə̀ bo bɨ̀ àlaꞌà yiꞌinə̀!” ");
INSERT INTO bfd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ŋù nɨ̀bò yî mɔ̀ꞌɔ yìi mə ɨ̀kǔm yi ɨ lɛ mbə Kaifas, m̀bə ŋgàŋmàꞌa Nwì yî ŋ̀wè maa alòò aa, a swoŋ mə, “Ɨ̀tɨ̀rə ndə jî tsu! ");
INSERT INTO bfd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nɨ̀ sɨ̀ zi mə a bɔŋtə mə tâ nɨ̀ zwitə a ŋû yî m̀fùùrə̀ a atu àbùgə̀ bə̂, ǹtsyatə ajàŋ yìi mə mbə nɨ̀ zwitə̀ àlaꞌà tsɨ̀m aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tsiꞌì ànnù nɨ̂ŋkoŋə̀, kaa à lɛ waꞌǎ annù ma yû swoŋ aa nɨ̂ ɨ̀tu ɨbɨ̀ɨnû yi bə̂; m̀bə yìi mə à lɛ mbə ŋgàŋmàꞌanwì yî ŋ̀wè maa alòò aa, Àzwì Nwì a lɛ ŋghɨ̀rə̀ mə tâ à fìꞌisə ma yû ànnù ǹswoŋ ǹloŋ mə Yesu à lɛ ntswe nɨ̂ ŋ̀kwo a atu baYuda aà, ");
INSERT INTO bfd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kaa tâ à waꞌǎ aa tsiꞌì baYuda bobo bə̂, à lɛ ŋkɨ ntswe nɨ̂ ŋ̀ghòtə bə̀ bɨ Nwî bìi mə bɨ jaꞌanə a mûm m̀bi yǔ ntsɨ̀mə̀ aa, ta tâ bo bə ɨbɨ̀ɨnu yì fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ǹlɔgɨnə maa njwi, bɨ̀saꞌa bɨ alaꞌa bɨ baYuda bɨ tɨgə̀ ǹtaŋ ajàŋ mə bɨ ka zwitə yi. ");
INSERT INTO bfd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Maa ajàŋ, Yesu kaa à lɛ sɨ waꞌà bù ŋkarə a tɨtɨ̀ɨ baYuda nyɛ̀ntə, à lɛ mbàŋnə̀ m̀maꞌatə ŋghɛ̀ɛ a mbɛ̀ɛ̀ àdɨ̀gə̀ yî mɔꞌɔ, a mbɛ̀ɛ̀ ǹtaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀, bɨ twoŋə̀ nɨ̂ ɨ̀kùmə alaꞌa wa nɨ Ephraim, bo bɨ̀ ŋgǎŋyəgə̂nnù ji bɨ tɨgə̀ ǹtswe ghu. ");
INSERT INTO bfd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nòò ɨ̀kòò Passa à lɛ ntɨgə ŋkoontə, bə̀ bî ghàꞌàtə̀ lô a alaꞌa ŋkɔꞌɔ ŋghɛɛ a Yerusalem a nlə̀ə nû jyaa ɨ̀ laa ajaŋ mə nɔ̀ŋsə̀ à lɛ ndɨ̀ꞌɨ̀ aa, mbɔŋ tâ nòò ɨ̀kòò wa kuꞌu. ");
INSERT INTO bfd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Àjàŋ yìi mə bo lɛ sɨ lɔ̀ɔ̀ nɨ̂ Yesu aa, bo bòòntə̀ mə̂ a ndâmàꞌanwì aa, ǹtɨgə mbetə nɨ̂ waa bo nɨ bo mə, “Nɨ̀ mɔ̀ɔ̀ntə mə akə aa ɛ? Nɨ̀ laà mɔɔntə mə à ka zì faa adɨgə ɨkòò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","À lɛ tɨ bə aa boŋ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ baFarɨsai, bɨ tsə̀rə̀ mə̂ mə mbə ŋù tsù a zi adɨgə yìi mə Yesu à tswe ghu aa, a zî ŋ̀kɛꞌɛnə, ta tâ bɨ̀ baŋnə yi. ");
INSERT INTO bfd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ǹjwi ɨ lɛ ntɨgə mburə aa ji ntoꞌo mbɔŋ tâ ǹjwî Passa ɨ̀ zi. Yesu à lɛ nzì a Bethany, wa adɨgə mə Lazarus wa yìi mə à lɛ nyweensə a nɨwo à lɛ sɨ tswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bɨ lɛ nnaŋsə mɨjɨ ghu mbô. Lazarus bo Yesu tswê a atu atɛtə̀, Martha a tɨgə̀ m̀fa nɨ mɨ̀jɨ a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mary à lɛ nlɔ̀gə atɨɨ ntsɨŋ mɨghurə mì lùmtə̀ mi atɨ̀ndùù mìi mə mɨ lɛ nnaŋsə mbə tsiꞌì mì narda aa, ntswentə a mɨkòrə Yesu, ǹlɔgə ɨnǒŋtû ji ntɨgə nyɛꞌɛ ghu. Àyàꞌà mɨghurə ya a lɛ mfɛ̀ꞌɛ̀ ǹluu wa mûm ǹdâ. ");
INSERT INTO bfd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariot, ŋ̀gàŋyə̀gə̂nnù yì yî mɔ̀ꞌɔ mə à lɛ ntswe nɨ̂ m̀fèê yi aa, a swoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bɨ ghɨrə waꞌà mɨghurə mù lɔgə̀ m̀fee nɨ àbaꞌatə ŋkabə silva ŋkhɨ̀ ji tarə, ǹlɔgə ŋkabə ya ŋkwɛtə ŋgàŋə̂fumə ghu aa a ya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kaa à lɛ waꞌà ma mùu ajàŋ swoŋ aa nloŋ mə à lɛ sɨ ko mɨlə̀ŋnə̀ ŋ̀gàŋə̂mfumə, à lɛ swoŋ aa nloŋ mə à lɛ mbə nyə̀rə aà. Tsǒ mə abàa ŋkabə aa à lɛ sɨ lə̀ə̀ yu aa, à lɛ sɨ ŋeꞌesə mfiꞌitə nɨ yì mɔ̀ꞌɔ̂. ");
INSERT INTO bfd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu a tɨgə̀ ǹswoŋ mə, “Màꞌàtə̀ yi! Màꞌàtə̀ yi tâ à ləə mɨ̀ghurə mù a nyɔꞌɔ mə ghu a njwi yìi mə bɨ ka yǐ twiŋə gha ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bu bɨ̀ ŋ̀gàŋə̂mfumə tswe aa tsiꞌì bɨ̀nòò bɨtsɨ̀mə̀, lâ kaa mə̀ ka yǐ waꞌa a tɨtɨ̀ɨ bù aa a ŋgɔ̀ŋ bɨ̀nòò bɨtsɨ̀m tswê.” ");
INSERT INTO bfd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ǹnɔ̀ɔ̀ bə̂ yìi mə ɨ lɛ mburə ŋghaꞌa ŋghaꞌa aa, ɨ lɛ nyuꞌu mə Yesu à lɛ ntswe a Bethany, ǹtɨgə ŋghɛɛ ghu. Kaa bɨ lɛ ŋwaꞌà ghu kâ ŋ̀ghɛɛ laà aa nloŋ tsiꞌì Yesu, bɨ lɛ ŋkɨɨ ŋghɛɛ aa a nyə Lazarus, wa yìi mə Yesu à lɛ nyweensə nɨwo aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bɨ lɛ ntɨgə ntaŋtə nɨ̂ àjàŋ yìi mə bɨ ka kɨɨ zwitə Lazarus, ");
INSERT INTO bfd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ǹloŋ mə â lɛ ŋghɨ̀rə̀ yu mə tâ baYuda bî ghàꞌàtə̀ tâ bɨ̀ ka maꞌatə nɨ̂ waa m̀bàŋnə̀ ŋghɛɛ nɨ a mbo Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Àbɛ̀ɛ̀ a fùꞌù mə̂, ǹnɔ̀ɔ̀ bə̂ yî ghàꞌàtə̀ yìi mə ɨ lɛ nzì a njɨ̂ ɨ̀kòò Passa aa, ɨ lɛ nyuꞌu mə Yesu a kuu a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bɨ lɛ ntɨgə ŋghɛɛ nlɔ̀ɔ ɨjaŋ mɨghə ŋ̀ghɛɛ nɨ ju a ŋkwɛrə yu ghu. Bo lɛ sɨ tɨgə ntɔŋnə nswoŋə nɨ mə, “Hosiana! Bìꞌinə̀ ghaꞌasə yu wa yìi mə a zì nɨ̂ Ɨ̀kǔm Mmàꞌàmbi aà! Bìꞌinə̀ ghaꞌasə a Mfɔ̀ baIsrael ma ghû!” ");
INSERT INTO bfd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu à lɛ lɔ̀gə jakasì ŋ̀kɔꞌɔ ghu atû, a fɛꞌɛ̀ tsiꞌì wa ajàŋ yìi mə bɨ ŋwaꞌanə a mûm àŋwàꞌànə̀ Nwî aa mə, ");
INSERT INTO bfd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tsuu kɨ bɔꞌɔ mbâ, wô, ǹjɔ̀ꞌɔ̀ àlaꞌà Sion! M̀fɔ̀ ghò à wiì mə a zì, ŋ̀kɔꞌɔ a atu mu jàkasì aà.” ");
INSERT INTO bfd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Maà noò, kaa ŋgǎŋyəgə̂nnù ji kaa ɨ lɛ waꞌǎ njiꞌì ànnù ma yu zî. Lâ nòò wa yìi mə Yesu à lɛɛ̀ ǹyweenə nɨwo ŋ̀kuu a mum nɨ̀ghaꞌà ni aa, bo lɛ ŋwaꞌatə mə àŋwàꞌànə Nwî a lɛ nswoŋ annù ma yû ǹloŋ ŋgaà yì, ŋ̀kɨ tɨgə ŋwaꞌatə ajàŋ yìi mə bɨ lɛ ŋghɨ̀rə̀ ma yû ànnù ghu nû aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bə̀ bya bìi mə bɨ lɛ ntswe bo bɨ̀ Yesu wa noò mə à lɛ nzì twoŋə Lazarus mə tâ à fɛꞌɛ wa mum nɨ̀syɛ̀, ǹyweensə yi nɨwo aa, bɨ lɛ ŋghɛ̀ɛ̀ ǹswoŋ annù yìi mə bo lɛ nyə aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","À nɨ ànnù yìi mə a lɛ ŋghɨ̀rə̀ ǹnɔ̀ɔ̀ bə̂ wa ɨ zî a mbòo Yesu aà. Bo lɛ nzì aa nloŋ àlènsə̀ ma ya mə à lɛ ŋghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","BaFarɨsai bìi mə bɨ lɛ ntswe ghu aa, bɨ lɛ sɨ tɨgə nswoŋə bo nɨ bo mə, “Kaa ànnù yìi mə bìꞌinə̀ ghɨ̀rə̀ aa kaa a sɨ nɨ mbìì ghɛɛ! Yə̂ nɨ̀ àjàŋ yìi mə m̀bî ǹtsɨ̀m ɨ yòŋə̀ ghu njɨ̀m liì aà!” ");
INSERT INTO bfd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","BaGrikia bî mɔꞌɔ bɨ lɛ ntswe a tɨtɨ̀ɨ bə̀ bìi bɨ lɛ ŋkɔꞌɔ ŋghɛɛ a Yerusalem a mmii Nwì wâ noò ɨ̀kòò. ");
INSERT INTO bfd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bo ghɛɛ̀ ǹswoŋ a mbo Philip (wa mə à lɛ nlô a Bethsaida a Galilea aà), mə, “Taà, bìꞌi lɔ̀ɔ a nyə Yesu.” ");
INSERT INTO bfd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip a ghɛɛ̀ ǹswoŋ a mbo Andrew bo bya bi baa kɨ̂ ǹghɛɛ nswoŋ a mbo Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu a kwiꞌi a mbo bo mə, “Nòò à kùꞌù mə̂ mə Mu Ŋù à ka kwɛrə nɨghaꞌà. ");
INSERT INTO bfd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mə̀ swǒŋ tsiꞌǐ annù nɨ̂ŋkoŋ a mbo bù mə, m̀bə bɨ tuu mbùmə ànsaŋ a nsyɛ bweꞌe tâ ɨ̀ kwo mfəərə boŋ ɨ̀ ka tswe tsiꞌì yùyù, kaa waꞌà sɛnə̀. Bɛɛ mə ɨ kwo boŋ ɨ̀ ka tɨgə təŋ mbùmə ànsaŋ jî ghàꞌàtə̀. ");
INSERT INTO bfd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ŋù yìi mə a kɔ̌ŋ ntswêntɨ̀ɨ̂ yi aa à ka bàŋnə bwɛsə, lâ ŋù yìi mə a bàa ntswêntɨ̀ɨ̂ yi fàa nsyɛ aa, a bàŋnə ləə aa lə̀ə̀ ɨ yǐ tswe nɨ̂ ǹtswêntɨ̀ɨ̀ yìi ɨ̀ lwìꞌi nɨ̂koŋə aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ŋù yìi mə a kɔ̌ŋ a ŋka mfàꞌa a mbo mə̀ aa, à tswe nɨ̀ ŋ̀ka nyòŋə̀ nɨ̂ ghâ, tâ ŋgàŋàfàꞌâ ghà a kɨ ntswe a adɨgə yìi mə mə̀ tswe ghu aà. Taà ghà à ka yǐ kɨɨ ŋentə a ŋû ǹtsɨ̀m yìi mə a fàꞌa a mbo mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ǹtɨɨ̀ gha ɨ luu nɨ̀ àjəŋnə̀, mə̀ ka swoŋ aa mə akə aa ɛ? Mə̀ ka swoŋ aa mə ‘Taà, tsee bii tâ ghuà nòò ŋ̀gɨꞌɨ à yə gha aa ɛ?’ Ŋ̀gaŋ mə̀ lɛ nzì ǹloŋ aa nòò ŋ̀gɨꞌɨ mà ghû. ");
INSERT INTO bfd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taà, ghaꞌasə Ɨkûm ghô!” À swòŋ mə̂ laa, ǹjì ɨ ghaà a aburə nswoŋ mə, “Mə̀ tɛ̀ꞌɛ̀ mə̂ ŋ̀ghaꞌasə, mə̀ ka kùꞌùsə bǔ ghaꞌasə.” ");
INSERT INTO bfd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ǹnɔ̀ɔ̀ bə̂ wa mə ɨ lɛ ntəə maa adɨgə aa, ɨ lɛ nyuꞌu njì yâ, bǐ mɔꞌɔ swoŋ mə, a kǔm mbə̀ŋə̀, bi mɔꞌɔ bɨ swoŋ mə, “Angel à ghàa ghu mbô!” ");
INSERT INTO bfd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu a swoŋ a mbo bo mə, “Ǹjì yû kaa ɨ̀ sɨ̀ ghaà ǹloŋ aa ŋgaa yà, ɨ̀ ghaa nloŋ aa ŋgaa yùù. ");
INSERT INTO bfd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nòò yìi mə bɨ ka saꞌa ɨsaꞌa mbi ghu aa, à kùꞌù mə̂. Bɨ ka sɨgɨsə ŋû yìi mə a saꞌa mbi yù aa a aləŋə nɨfɔ̀, ɨ furə yi tâ à fɛꞌɛ. ");
INSERT INTO bfd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nòò yìi mə bɨ ka ŋɛntə ghâ a ndəŋə, ɨ lɔ̀ꞌɔ̀sə aa fàa atu nsyɛ aa, mə̀ ka swùŋ bə̂ bɨtsɨ̀m tâ bɨ̀ zi a mbo mə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","À lɛ nswoŋ laà m̀fɨgɨtə aa ajàŋə̀ nɨwo yìi mə à lɛ ntswe nɨ̂ ŋ̀kwo aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ǹnɔ̀ɔ̀ bə̂ wa ɨ kwiꞌi mə, “Nɔ̀ŋsə̀ yìꞌì à swoŋ mə Àyɔꞌɔ̀ Nwì wa à ka yǐ tswe aa nɨ̀ŋkoŋə̀. Ò bû ǹtsya aa la nswoŋ mə bɨ ka ŋɛntə Mu Ŋù a ndəŋ aa ɛ? Mu Ŋù ma ghû à bu mbə aa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu a kwiꞌi mə, “Ŋ̀kàꞌà ɨ ka bǔ tswe bu bo aa tsiꞌǐ a atu mû àtɨɨ noò. Nɨ̀ ka ntəə a mûm ŋ̀kàꞌà fàa noò mə nɨ̀ tswe nɨ ghu aa, mə tâ ɨ̀tugə tsuu ghuu fii; ǹloŋ mə ŋù yìi mə a təə nɨ̂tugə aa kaa à sɨ̌ adɨgə yìi mə yu ghɛ̀ɛ̀ ghu aa zî. ");
INSERT INTO bfd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nɨ̀ nɨŋ mɨ̂ntɨɨ̀ muu a nû ŋ̀kàꞌà ghû fàa noò mə nɨ̀ tswe nɨ ghu aa, tǎ bə bɔɔ bɨ ŋkàꞌà.” Yesu à swòŋ mə̂ laà aa, nlo yi a tɨtɨ̀ɨ bo ŋghɛɛ nlə̀ə̀ntə̀. ");
INSERT INTO bfd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ka mə à lɛ ŋghɨ̀rə ɨ̀lènsə jî ghàꞌà ŋ̀ghaꞌa a tɨtɨ̀ɨ bo aa, kaa bo lɛ waꞌǎ mɨ̂ntɨɨ̀ myaa ghu nu nɨŋə̀; ");
INSERT INTO bfd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","mə tâ ànnù yìi mə ŋgàŋntoò Nwì Yesaiah à lɛ nswoŋ aa, tâ à fɛꞌɛ mbòòntə̀ mə, “Taà, wò à lɛ mbii ntoo ya mə bìꞌì lɛ nswoŋə aa ɛ? Nwì à lɛ ndɨ̀ꞌɨ̀ mɨdaꞌâ mi aa a mbo wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Maa ajàŋ kaa bo lɛ ŋwaꞌà mɨ̂ntɨɨ̀ myaa ghu nu nɨŋə̀ ǹloŋ mə Yesaiah à lɛ ŋkɨ nswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nwì à màꞌà mə afə̀ꞌə̀ a miꞌi bo, ŋ̀kɨ mfɨɨ mɨtsyɛ̀ myaa, mə tâ miꞌì myaa tsuu ɨdɨgə kɨ yə, tâ ɨ̀tû jyaa ɨ̀ tsuu ɨnnù kɨ zi, tǎ waꞌà waa lò m̀bəŋkə̀ nzi ntsiꞌi gha tâ mə̀ ghurə waa.” ");
INSERT INTO bfd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaiah à lɛ nswoŋ laa nloŋ mə à lɛ nyə nɨghaꞌa ni ǹtɨgə mbɔŋ swoŋə ma yuù ànnù ǹloŋə yi aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ka mə à lɛ mbə ma mùu ajàŋ aa, bɨ̀tà bɨ alaꞌa bî ghàꞌàtə̀ bɨ lɛ nnɨŋ mɨ̂ntɨɨ̀ myaa a nu Yesu, la kaa waꞌà bàŋnə̀ ǹswoŋə nɨ a mbo bə̀ ǹloŋ mə bo lɛ sɨ bɔꞌɔ nɨ mə baFarɨsai ka furə waa a ndâŋghòtə̂. ");
INSERT INTO bfd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bo lɛ kɔ̀ŋ mə tâ bə̀ ka mbeentə waa, ntsyatə nlɔ̀ɔ mə tâ Nwì à beentə waa. ");
INSERT INTO bfd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu a tɔŋnə̀ ǹswoŋ mə, “Ŋù yìi mə à nɨ̌ŋ ntɨɨ̀ yi a nu mə̀ aa, kaa à sɨ̀ aa tsiꞌǐ a nu mə̀ nɨŋə̀, à kɨ nnɨŋə aa a nu yu wa yìi mə à lɛ ntoo gha aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ŋù yìi mə à yə gha aa, à yə aa yu wa yìi mə à lɛ ntoo gha aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mə̀ zi fàa mbi aa tsiꞌì tsǒ ŋkàꞌà, mə ŋù ǹtsɨ̀m yìi mə à nɨ̌ŋ ntɨɨ̀ yì a nu mə̀ aa tâ à tsuu a mûm ɨ̀tugə lwìꞌì. ");
INSERT INTO bfd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ŋù yìi mə a yuꞌu ntoò ya kaa waꞌà lə̀ə̀ aa, kaa mə̀ sɨ ɨsaꞌa ghu nu nɨŋə, nloŋ mə kaa mə̀ lɛ ŋwaꞌà fàa mbi zì aa a ntsɔꞌɔtə mɨ̀saꞌà, mə̀ lɛ nzì aa a nyweensə m̀bî. ");
INSERT INTO bfd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ŋù yìi mə à tùu gha kaa waꞌa nɨghàâ na kwɛrə aa, à tswe nɨ̂ ànnù yii a ka saꞌa yi, nɨ̀ghàà nìi mə mə̀ swòŋə aa, nɨ ka yǐ saꞌa yi a njwî ǹlwìꞌìnjɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","A bə laà aa nloŋ mə ànnù yìi mə mə̀ swòŋ aa, kaa mə̀ sɨ aa nɨ̀ à yaà àdàꞌà swoŋə, a fa Taà ghà yìi mə à lɛ ntoo gha aa mfa nɨ̂ ànnu yìi mə mə̀ tswe nɨ̂ ŋ̀ghàa ŋkɨ swoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","“Mə̀ zi mə ànnù yìi mə Taà a swoŋ aa, a fa ntswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌi nɨ̂ŋkoŋ aà. Maa ajàŋ mə swoŋ aa annù yìi mə Taà à swǒŋ mə tâ mə̀ swoŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","À lɛ mbə a njwi yìi mə àbɛ̀ɛ̀ a ka tɨgə fuꞌu tâ bɨ̀ jɨ mɨjɨ mɨ Passa, lɛ boŋ Yesu à zì mə̂ mə nòò yì fàa mbi à kòòntə̀ mə̂ a ajaŋ mə yu ka bǔ mmàꞌàtə mbi yù ɨ ghɛ̀ɛ̀ yi fu a mbɛ̀ɛ Taà yì aà. Àjàŋ mə à lɛ sɨ kɔ̀ŋ bə̂ bi bìi mə à lɛ mbə̂ bi fàa mbi aa, à lɛ naŋsə ŋkɔŋ waa ŋkɔꞌɔ nlwiꞌisə. ");
INSERT INTO bfd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu bo bɨ̀ ŋgǎŋyəgə̂nnù ji lɛ sɨ jɨ mɨjɨ mɨ ŋkwɛɛ̀fɔ̀ a atu atɛtə̀, lɛ boŋ Satan à nɨ̀ŋ mə adɨꞌɨtə̀ yî bɨ a ntɨɨ Yuda mu Simon Iscariot mə tâ à fee yi. ");
INSERT INTO bfd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu à lɛ nzi mə Taà yì à fà mə ŋgɔ̀ŋ joò tsɨ̀m fàa mbi a mbo yu, ŋkɨ nzi mə àjàŋ mə yu lɛ nlò a mbo Nwì ǹzi aa, yu ka bǔ lǒ ghɛ̀ɛ̀ yi fu ghu mbɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","À lɛ ntɨgə mbɨɨnə wa atu atɛtə̀, ǹtsɔꞌɔ akutə̀ yi nləə, nlɔgə tawòlə̀ ǹlɨmtə a atìi yu. ");
INSERT INTO bfd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ǹlɔgə ŋkì ǹnɨŋ nɨ̂ àkaŋ nlɔ̀gɨ̀nə̀ ŋ̀ka nsiꞌi mɨkòrə̀ mɨ ŋgǎŋyəgə̂nnù ji ghu ŋkɨɨ nyɛꞌɛ nɨ tawòlə̀ wa mə à lɛ lɨmtə a atìi yu aà. ");
INSERT INTO bfd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","À kà mə̂ aa nsiꞌi laa, ǹzì ǹyweꞌe a nu Simon Peta, a betə̀ mə, “M̀màꞌàmbî o lɔ̀ɔ̀ aà ǹsìꞌi mɨ̀kòrə̂ ma aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu a kwiꞌi ghu mbo mə, “Kaa ò sɨ̌ annù yìi mə mə ghɨ̀rə̀ aa tsɨ̀tsɔ̀ŋ zî, la ò ka yǐ bɔ̌ŋ zi aa a noò ǹjɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peta a swoŋ ghu mbo mə, “Tâ à tsuu bə mə nòò tsù à tswê ghu mə ò ka yǐ sìꞌì mɨkòrə̂ mâ.” Yesu a swoŋ ghu mbo mə, “M̀bə mə̀ tsuu mɨkòrə̂ mo sìꞌi bəə boŋ kaa sɨ̀ ka waꞌà nɨ̂ ànnù bû ǹtswe.” ");
INSERT INTO bfd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peta a swoŋ mə, “M̀màꞌàmbî tsuu tsiꞌì mɨkòrə̂ ma mumu sìꞌì, kɨ nsìꞌi mbô ma bo bɨ̀ àtû yâ.” ");
INSERT INTO bfd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu a swoŋ ghu mbo mə, “Ŋù ǹtsɨ̀m yìi mə à sìꞌi nû yì aa, à laà ǹsɨgɨ̀nə̀ kaa ŋkɨꞌɨ̀ nɨ̂ m̀bu ŋkwatə nsiꞌi bû ǹtswe; à tɨ̀gə ntswe aa tsiꞌì nɨ̀ ǹsìꞌìtə mɨ̀kòrə̂ mi. Wa bù bɨtsɨ̀m nɨ̀ laà, a kɨ̂ ǹtɨgə mmɛ tsiꞌì ŋù yî m̀fùùrə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","À lɛ tɨ bə aa Yesu à zî ŋû yìi à ka fèè yi aà, a bə̂ ǹjiꞌì ànnù yìi mə à lɛ nswoŋ mə kaa bo lɛ ŋwaꞌà bɨtsɨ̀m laa aà. ");
INSERT INTO bfd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu à màŋsə̀ mə̂ a nsìꞌi mɨ̀korə̂ myaa mya aa, mbù ŋ̀wɛꞌɛ akutə̀ yi ya fu mbɨɨnə mbɨ̀ɨ̀ ǹtswe yi fu wa atu atɛtə̀. M̀betə waa mə, “Nɨ̀ zî ǹjiꞌì ànnù yû yìi mə mə̀ ghɨ̀rə a nu bù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ǹswoŋ a mbo bo mə, “Nɨ twoŋə nàa nɨ ǹdɨ̀ꞌɨ̀nnù, ŋ̀kɨɨ ntwoŋə nàa nɨ M̀màꞌàmbî ghùù, a kuꞌùnə̀ maa ajàŋ nloŋ mə àa ŋù yìi mə mə̀ nɨ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","M̀bə̀ mə̀, M̀màꞌàmbî ghùù ŋ̀kɨ mbə ndɨ̀ꞌɨ̀nnù ghùù, lâ ǹsiꞌi mɨkòrə̂ muu, ma mùu ajàŋ, a kuꞌùnə̀ mə tâ nɨ̀ ka nsiꞌi mɨkòrə̂ muu bu nɨ bù. ");
INSERT INTO bfd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wa mə̀ dɨ̀ꞌɨ̀ aa ànnù a mbo bù mə tâ nɨ̀ ka mfɨgɨnə ajàŋ annù ma yû mə mə̀ ghɨ̀rə sii aà. ");
INSERT INTO bfd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mə̀ swoŋ tsiꞌǐ annù nɨ̂koŋ a mbo bù mə kaa abùꞌù a sɨ̌ Masa yì tsyâ. Kaa ŋgàŋntoo a waꞌà ŋû yìi mə à tòo yi a kɨ̀ ǹtsya. ");
INSERT INTO bfd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tsǒ mə nɨ̀ zì mə̂ ɨ̀nnù mà jû tsɨ̂tsɔ̀ŋə aa, m̀bɔɔnə a mbo bù mə mbə nɨ̀ kâ m̀faꞌa nɨ ju. ");
INSERT INTO bfd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kaa mə̀ sɨ ɨnnù ma jû swoŋə aa nloŋ ŋgaa yùù bɨtsɨ̀mə̀, mə̀ zi bə̀ bìi mə mə̀ tɛ̀ꞌɛ ntsɔꞌɔ aà. Lâ nɨ̀ghàà nɨ Nwî nya mə nɨ swoŋ nɨ mə, ‘Ŋù yìi mə bìꞌiyu jɨnə aa, à ka bəŋ tɨgə bàà nàâ’ aa nɨ tswe nɨ̀ m̀fɛ̀ꞌɛ mbòòntə̀. ");
INSERT INTO bfd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mə swoŋ a mbo bù tsɨ̂tsɔ̀ŋ aa mə tǎ bɛɛ mə a ghɨrə mfɛ̀ꞌɛ̀ ma la, nɨ̀ bii mə mə̀ laa mbə yu wa yìi mə à nɨ ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂koŋ mə, ŋù yìi mə à kwɛ̀rə ŋû yìi mə mə̀ tòo yi aa, à kɨ ŋkwɛrə aà ghâ, ŋù yìi mə à kwɛ̀rə gha aa, à kɨ ŋkwɛrə aa yu wa yìi mə à lɛ ntoo gha aà.” ");
INSERT INTO bfd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu à màŋsə̀ mə̂ a nswoŋə ma juù ɨ̀nnù aa, ǹtɨɨ̀ yi ɨ naŋsə̀ ǹluu nɨ̂ àjəŋnə̀, a swoŋ nɨ̀ ǹsi nɨ̀ ǹsi mə, “Mə̀ swòŋə a mbo bù tsiꞌǐ annù nɨ̂ŋkoŋ mə, ŋù yì mɔ̀ꞌɔ a tɨtɨ̀ɨ bù à ka ghɨ̀rə fèè ghâ.” ");
INSERT INTO bfd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ànnù a lɛ ŋghaꞌa ŋgǎŋyəgə̂nnù ji jya, bɨ tɨgə̀ ǹlenə waa bo nɨ bo. ");
INSERT INTO bfd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ŋ̀gàŋyègə̂nnù yi wa yì mɔ̀ꞌɔ, yìi mə à lɛ nnaŋsə ŋkɔŋə aa, à lɛ ntswe nnaŋsə nyoŋ ŋkɔ̀ɔ̀ntə̀ ghu mbɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peta a tɛꞌɛ miꞌì mi ghu nu nswoŋ ghu mbo mə, “Betə yi mə a ghàà aa nloŋ ŋgaa wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ma waà ŋ̀gàŋyəgə̂nnù yì, a lô ǹyoŋtə nyəkətə ghu nu, m̀betə yi mə, “M̀màꞌàmbî, ŋù ma ghû, a nɨ̀ wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu a kwiꞌi mə, “Ŋù yìi mə mə̀ ka tsùtə abaa a nɨ̂ ǹjyà ɨ fa ghu mbo aa, à nɨ ghu.” À kwìꞌì mə̂ laà aa, ntɨgə nlɔgə abàꞌa abaa ntsùtə̀ m̀fa a mbo Judas mu Simon Iscariot. ");
INSERT INTO bfd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Àjàŋə Judas à lɛ ŋghɛ̀sə̀ ŋ̀kwɛrə abaa ya aa, Satan a kuu ghu ntɨɨ̀. Yesu a swoŋ ghu mbo mə, “Wàŋsə̀, ghɨ̀rə annù yìi mə o lɔ̀ɔ ŋghɨ̀rə aà!” ");
INSERT INTO bfd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kaa àbùgə̀ bə̂ yìi a lɛ ntswe wa atu tɛtə aa, kaa bo lɛ waꞌǎ njiꞌì ànnù ma yû yìi mə Yesu à lɛ nswoŋ ghu mbo aa zî. ");
INSERT INTO bfd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tsǒ mə Judas à lɛ sɨ lə̀ə abàa ŋkabə aa, ŋgǎŋyəgə̂nnù Yesu jya jǐ mɔꞌɔ ɨ waꞌatə̌ mə, Yesu à lɛ ntswe aà ǹtoo yi aa mə tâ à ghɛɛ nyuu njoo jìi mə bo ka jɨ ɨkòò wa aa ghu; kə̀ mə tâ à ghɛɛ mfa ayoo a mbo ŋ̀gàŋə̂fumə. ");
INSERT INTO bfd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas à kwɛ̀rə̀ mə abaa ya aa, mburə mmaꞌatə tsiꞌì maa noò m̀fɛꞌɛ. Ɨ̀tugə ɨ fiì. ");
INSERT INTO bfd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas à màꞌàtə̀ mə aa, Yesu a swoŋ mə, “Tsɨ̂tsɔ̀ŋ, bɨ ghàꞌàsə̀ mə̂ Mu Ŋù. Tsɨ̂tsɔ̀ŋ bɨ tsyà mə̂ ghu nu, ŋghaꞌasə Nwî. ");
INSERT INTO bfd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","M̀bə bɨ ghaꞌasə Nwî ǹtsya ghu nu, bəə boŋ Nwì à ka kɨɨ ghaꞌasə yi ɨ tsyà a nu yu Nwîŋgɔ̀ŋ, ɨ kɨɨ burə ghɛ̀sə ghaꞌasə yi ŋgaa yî m̀fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bɔɔ̀ bâ, kaa mə̀ ka waꞌǎ biꞌinə̀ bù ǹtswe tâ àghaꞌa saꞌatə; mə̀ bə lǒ boŋ nɨ̀ ka tɨgə lɔ̀ɔ̀ nàâ, lâ mə̀ swoŋ a mbo bù tsiꞌǐ ajàŋə mə lɛ nswoŋə a mbo baYuda aa, mə̀ swòŋə a mbo bù tsɨ̂tsɔ̀ŋ mə, ‘Kaa mbə nɨ̀ waꞌǎ adɨgə yìi mə mə ghɛ̀ɛ̀ ghu aa ghɛ̀ɛ̀.’ ");
INSERT INTO bfd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mə̀ fâ ǹdɨꞌɨ yì m̀fii a mbo bù. Nɨ̀ ka ŋkɔŋnə ghu bo nɨ bù. A ŋgɨ̌ŋ ŋgɨ̀ŋ a ajàŋ mə mə kɨɨ ŋkɔŋə ghuu aa, nɨ̀ ka ŋkɔŋə ghuu bu nɨ bù. ");
INSERT INTO bfd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nɨ̀ bə kɨ kɔ̀ŋnə̀ ghuu bu nɨ bù boŋ bə̀ bɨ̀tsɨ̀m ka zi mə nɨ̀ laa mbə ŋgǎŋyəgə̂nnù jyâ.” ");
INSERT INTO bfd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peta a betə̀ yi mə, “M̀màꞌàmbî, o ghɛ̀ɛ̀ aa a fə aa ɛ?” Yesu a kwiꞌi ghu mbo mə, “Kaa mbə ò waꞌǎ a adɨgə yìi mə mə ghɛ̀ɛ̀ ghu aa tsɨ̀tsɔ̀ŋ yoŋə̀, lâ à ka yǐ kɨ bə a njɨ̀m tâ ò yoŋə ghâ.” ");
INSERT INTO bfd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peta a swoŋ ghu mbo mə, “M̀màꞌàmbî, m̀bə mə̀ waꞌà gho tsɨ̀tsɔ̀ŋ yoŋə̀ aa a ya aa ɛ? Wâ à tɛꞌɛ bə bə̂ ànnù nɨwo, boŋ mə̀ ka fa ntswêntɨ̀ɨ̂ yà mbɨꞌɨ ŋkwîtû yò.” ");
INSERT INTO bfd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu a betə̀ yi mə, “Ò ka naŋsə fa ntswêntɨ̀ɨ̂ yò m̀bɨꞌɨ ŋkwîtû ghâ aa ɛ? Mə̀ swòŋə a mbo wò tsiꞌǐ annù nɨ̂ŋkoŋ mə mbɔŋ tâ àŋkə̀gə̀ à tɔŋ nɨ̂tugə sìi boŋ ò tùù mə̂ gha ŋgàà ji tarə̀.” ");
INSERT INTO bfd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu a swoŋ a mbô ŋ̀gǎŋyəgə̂nnù ji mə, “Tâ mɨ̀ntɨɨ̀ muu tsuu kɨ tsɨ̀gɨ̀nə̀, tâ nɨ̀ tsuu kɨ jəŋnə, nɨ̀ nɨŋ mɨ̂ntɨɨ̀ muu a nu Nwì, ŋ̀kɨ nɨŋ a nu mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wa ǹjaꞌa nda ɨ burə nluu a nda Taà tsiꞌǐ mbə ànnù. Wa mə̀ ka ghɛ̀ɛ ɨ naŋsə adɨgə yìi nɨ̀ ka yǐ yǒŋ tswe ghu aà. A sɨ̀ laà aa bə boŋ kaa mə̀ sɨ swoŋ mə mə ghɛ̀ɛ̀ aa a nnaŋsə àdɨ̀gə̀ a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mə̀ bə ghɛ̀ɛ nnaŋsə adɨgə, boŋ mə̀ ka bǔ bɨ̀ɨ lɔ̀gə̀ ghuu tâ bù zi ntswe biꞌinə̀ maa adɨgə mə mə̀ tswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nɨ̀ zi mânjì yìi mə a ghɛ̀ɛ̀ maa adɨgə aà.” ");
INSERT INTO bfd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas a swoŋ mə, “M̀màꞌàmbî, kaa bìꞌì sɨ̌ adɨgə yìi mə o ghɛ̀ɛ̀ ghu aa zî; m̀bə̂ bìꞌì tɨgə̀ ǹzi mânjì yìi mə a ghɛ̀ɛ̀ ghu aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu a kwiꞌi mə, “Mə̀ nɨ mânjì, m̀bə annù nɨ̂ŋkoŋ, ŋ̀kɨ mbə ntswêntɨ̀ɨ̀. Kaa m̀bə ŋù waꞌǎ a mbɛ̀ɛ Taà ghɛɛ̀ tsiꞌì tɨ̀ ghə̂ à tsya a nu mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","A lɛ mbaa bə mə nɨ̀ zi gha, boŋ nɨ̀ kɨ nzi Taà. Lâ ɨ lɔ̀gɨ̀nə̀ tsɨ̂tsɔ̀ŋ nɨ̀ zi yi, nɨ̀ kɨ̀ mə̂ ǹyə yi.” ");
INSERT INTO bfd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip a swoŋ a mbo Yesu mə, “M̀màꞌàmbî, àyoo yìi mə bìꞌi tɨgə nlɔɔ tsɨ̂tsɔ̀ŋə̀ aa à nɨ tsiꞌi mə tâ ò dɨꞌɨ Ta a mbo bìꞌì tâ nû yi bɔŋə.” ");
INSERT INTO bfd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu a kwiꞌi mə, “Bìꞌinə̀ nàŋsə̀ mə̂ ǹtswe aa a nɨ nòò yî ǹsyà, kaa ò waꞌà gha zi aa ɛ, Philip? Ŋù yìi à yə gha aa, à yə̀ mə̂ Taà. Ò tɨgə̀ m̀bu ntsyà aa la nswoŋ mə tâ mə̀ dɨꞌɨ Taà a mbo bù aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Philip, ò sɨ̀ bii mə mə̀ tswe aa mum Taà, Taà a kɨ̂ ǹtswe a mum mə̀ aa ɛ? Ɨ̀nnù jû mə mə swoŋ nɨ a mbo bù aa, kaa mə̀ sɨ aa nɨ̂ àtu ya swoŋə, à nɨ̂ ɨ̀fàꞌà Taà ghà yìi mə à tswe a mum mə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bii nɨ̀ mə mə̀ tswe aa mum Taà, Taà a kɨ̂ ǹtswe a mum mə̀; a tuu laa bə, nɨ̀ tɨgə̀ m̀bii nloŋ bə̂ mɨ̀fàꞌà mû mə nɨ̀ yə mə̀ faꞌà aà.” ");
INSERT INTO bfd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yesu a bû ǹswoŋ mə, “Mə̀ swoŋ a mbo bù tsiꞌì ànnù nɨ̂ŋkoŋ mə, ŋù yìi mə à nɨ̌ŋ ntɨɨ̀ yi a nu mə̀ aa, a ka kɨɨ kɨ fàꞌà mɨfàꞌà muà mə mə fàꞌà aà; ɨ tɛꞌɛ bàŋnə̀ ɨ kɨ fàꞌa ɨnnù jìi mə ɨ tɨnsə ntsyà aà, ǹloŋ mə mə ghɛ̀ɛ̀ a mbɛ̀ɛ Taà laa aà. ");
INSERT INTO bfd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mə̀ bə ghɛ̀ɛ̀ boŋ mə̀ ka kɨ ghɨ̀rə̀ nɨ̂ ɨ̀nnù tsɨ̀m jìi mə nɨ bətə nɨ̂ Ɨ̀kǔm gha aà, mə tâ bɨ yə nɨghaꞌa nɨ Taà ǹtsya a njɨ̌m Mû yì. ");
INSERT INTO bfd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nɨ̀ bə betə annǔ tsu nɨ̂ Ɨ̀kǔm ghâ bəə boŋ mə̀ ka ghɨ̀rə̀. ");
INSERT INTO bfd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nɨ̀ bə kɔ̀ŋə̀ gha, boŋ nɨ̀ ka kɨ lə̀ə ndɨꞌɨ̀ jâ. ");
INSERT INTO bfd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tâ mə̀ betə a Taà mə tâ à too ŋgàŋkwɛtə̀ ghùù yî dàŋə̀, yìi à ka tɨgə lwìꞌi bu bo. ");
INSERT INTO bfd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","À nɨ̂ Àzwǐ annù nɨ̂ŋkoŋə̀. Kaa m̀bə̂ m̀bi yù waꞌà yi kwɛrə̀; ǹloŋ mə kaa m̀bi yù kaa sɨ nìi yə, kaa waꞌà yi kɨ nzi. Lâ, nɨ̀ zi yi, nloŋ mə a tswe a tɨtɨ̀ɨ bù, ǹtswe nɨ a mum bù.” ");
INSERT INTO bfd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yesu a bû ǹswoŋ mə, “Mə̀ bə ghɛ̀ɛ boŋ kaa mə ka waꞌà ghuu tsiꞌì bù bu maꞌàtə̀; mə̀ ka bǔ bɨ̀ɨ̀ fu a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A nɨ mû àtɨɨ noò kaa mbî kaa ɨ̀ ka waꞌǎ gha bù ŋ̀ka nyə, lâ tâ bù ka nyə nɨ̂ ghâ; tsǒ mə mə̀ tswe ntɨ̀ɨ̀ aà, nɨ̀ ka kɨɨ tswe bɨtɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","À ka yǐ bə maa njwi, tâ nɨ̀ zi mə mə̀ tswe aa a mûm Taà, nɨ̀ kɨ̂ ǹtswe a mum mə̀, mə̀ kɨ̂ ǹtswe a mum bù. ");
INSERT INTO bfd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ŋù ǹstsɨ̀m yìi mə a yuꞌu ndɨꞌɨ̀ ja ŋkɨɨ nləə aa, à nɨ ŋù yìi mə a kɔ̀ŋə̀ gha aà. Taà à ka kɨɨ kɨ kɔ̀ŋə̀ ŋû ǹtsɨ̀m yìi mə a kɔ̀ŋə̀ gha aa; tâ mə̀ kɨɨ ŋkɔŋ yi, ŋkɨ ndɨꞌɨ ɨbɨɨnû gha ghu mbô.” ");
INSERT INTO bfd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, (kaa sɨ̌ Judas Iscariot bə̂) a swoŋ mə, “Taà, m̀bə ò dɨꞌɨ̀ ɨ̀bɨɨnû gho aa mə akə a mbo bìꞌì kaa waꞌǎ a mbô m̀bi bàŋnə̀ ǹdɨꞌɨ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu a kwiꞌi ghu mbo mə, “Ŋù ǹtsɨ̀m yìi mə à kɔ̀ŋə gha aa, a yuꞌunə ndɨꞌɨ̂ jâ. Taà a kɨɨ̀ ǹtɨgə ŋkɔŋə nìi, Taà nɨ mə̀, bìꞌì zî ŋ̀ghurə ndùgə̀ bìꞌibo tɨgə̀ ǹtswe ghu. ");
INSERT INTO bfd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","“Ŋù yìi mə à sɨ̀ gha kɔ̀ŋ aa, kaa à sɨ ndɨꞌɨ̀ ja lə̀ə̀; kaa ɨ̀nnù jû mə nɨ yuꞌu aa kaa ɨ sɨ̌ ndɨꞌɨ̀ jǎ bə̂, ɨ lo aa a mbo Taà wa yìi mə à lɛ ntoo gha aà. ");
INSERT INTO bfd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mə swoŋ ɨnnù ma jû tsɨ̀m a mbo bù tsɨ̂tsɔ̀ŋ mə mə̀ bùrə ntswe biꞌinə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lâ Ŋ̀kwɛtə̀ wa, Àzwì Nwî ya yìi mə a laa màŋsə̀ aa, yìi mə Taà à ka yǐ too nɨ̂ Ɨ̀kǔm gha aa, a ka yǐ tɨgə dɨ̀ꞌɨ ɨnnù tsɨ̀m a mbo bù, ɨ ghɨ̀rə nɨ̀ tɨgə ŋwaꞌatə nɨ̂ ɨ̀nnù jìi mə mə lɛ nswoŋ a mbo bù aà. ");
INSERT INTO bfd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Mə̀ lə̀ə̂ m̀bɔɔnə a mbo bù, mə fa aa tsiꞌì m̀bɔɔnə̂ yà a mbo bù. Kaa mə̀ sɨ fa aa ajàŋ yìi mə m̀bi ɨ fa aà. Tâ mɨ̀ntɨɨ̀ mùu tsee lǒ kɨ tsɨ̀gɨ̀nə̀, nɨ̀ tsuu kɨɨ kɨ bɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tɨgə nɨ̀ ghɨ̀rə mbaa nyuꞌu ajàŋ mə mə̀ ghɨ̀rə nswoŋ mə, M̀ə̀ ka ghɛ̀ɛ ɨ bɔ̌ŋ bǔ bɨ̀ɨ ɨ zǐ fu a mbo bù aà.’ À bə bə yìi mə nɨ̀ kɔ̀ŋə gha, boŋ nɨ̀ ka kɨ dorɨtə nloŋ mə mə ghɛ̀ɛ̀ a mbɛ̀ɛ Taà aà; ɨ kɨ dorɨtə aa nloŋ mə Taà à tsyàtə gha aà. ");
INSERT INTO bfd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mə̀ swòŋə ɨ̀nnù jû a mbo bù m̀bɔŋ tâ ɨ̀ fɛꞌɛ aa mə, bɛɛ ɨ yi mfɛ̀ꞌɛ̀, nɨ̀ yə mbii. ");
INSERT INTO bfd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kaa mə̀ ka waꞌǎ a mbo bù nɨ nòò yî ǹsyà bû ŋ̀ghaa, nloŋ mə ŋù yìi mə a saꞌa mbi yù aa, a zì. La kaa à sɨ̀ nɨ̂ àdàꞌà a atu mə̀ tswê. ");
INSERT INTO bfd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Mə ghɨ̀rə̀ aa ànnù yìi mə Taà a swoŋ aà, mə tâ m̀bi zi mə mə̀ kɔ̀ŋə Taà. “Nɨ̀ zi bìꞌinə̀ maꞌatə adɨgə yuà ǹlo yiꞌinə̀. ");
INSERT INTO bfd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mə̀ nɨ̂ àti mɨlùꞌù yi annù nɨ̂ŋkoŋə̀, Taà ghà a bə ŋù wa yìi mə a fàꞌà a ŋkya mɨlùꞌù aà. ");
INSERT INTO bfd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","A kwàrə ntaa tsɨ̀m jìi mə ɨ tswe a nu mə̀ kaa waꞌà nɨ̀ mɨ̀ntà koonə̀ aa, m̀futə nɨ̂ ǹtaà tsɨ̀m jìi mə ɨ koonə mɨ̂ntà aa mə tâ ɨ̀ koonə mɨ̂ntà mɨ̀ ghaꞌatə. ");
INSERT INTO bfd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nɨ̀ghàà nɨ Nwî nìi mə mə̀ dɨ̀ꞌɨ̀ mə̂ a mbo bù aa, nɨ ghɨ̀rə̀ mə̂ mə tâ nɨ̀ laa. ");
INSERT INTO bfd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nɨ̀ lwiꞌi a mum mə̀ tâ mə̀ kɨ nlwiꞌi a mum bù. Tsǒ mə kaa mbə ǹtaà àtì mɨlùꞌù waꞌà mɨ̂ntà koonə̀ tɨ ghə̂ ɨ̀ tsugɨ̀nə nɨ mâtì aa, a kɨ̀ mbə ŋgɨ̌ŋ ŋgɨ̀ŋ mə kaa mbə nɨ̀ waꞌà mɨ̂ntà koonə tɨghə mə nɨ̀ lwìꞌi a mûm nu mə. ");
INSERT INTO bfd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mə̀ nɨ àtì mɨlùꞌù, nɨ̀ bə ǹtaà ji. Ŋù ǹtsɨ̀m yìi mə à lwìꞌi a mum mə̀ mə̀ kɨ̂ ǹlwiꞌi ghu mum aa, à ka koonə mɨ̂ntà mî ghàꞌàtə̀; ǹloŋ mə kaa mbə nɨ̀ waꞌǎ annù tsu ghɨrə̀ tɨ mə̀. ");
INSERT INTO bfd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mbə ŋù tsuu a mum mə̌ lwìꞌi, bɨ bəgə nlɔ̀ꞌɔ̀sə̀ kaa waꞌǎ ntaà yà bû m̀bə; ɨ tɨgə̀ ǹyoo, bɨ ghotə̀ ŋ̀ghɛɛ mmaꞌa a mum mɔꞌɔ a khɨ̂. ");
INSERT INTO bfd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nɨ̀ bə lwìꞌi a mum mə̀ tâ nɨ̀ghàâ na kɨ nlwiꞌi a mum bù, boŋ nɨ̀ ka betə ŋgɔ̀ŋ ǹjoò tsɨ̀m jìi mə nɨ lɔ̀ɔ̀ aa, ɨ tswe nɨ ju. ");
INSERT INTO bfd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bə̀ yə nɨghaꞌa nɨ Taà ǹyoŋə aa ajàŋ yìi mə nɨ koonə mɨ̂ntà mî ghàꞌàtə̀ aà; ǹtsya ma mùu ajàŋ, nɨ̀ tɨgə̀ m̀bə ŋgǎŋyəgə̂nnù jyâ. ");
INSERT INTO bfd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mə̀ kɔ̀ŋə ghuu a ŋgɨ̌ŋ ŋgɨ̀ŋ a ajaŋ yìi mə Taà ghà à kɔ̀ŋə gha aà; nɨ̀ lwiꞌi a mûm àkɔ̀ŋnə̀ yâ. ");
INSERT INTO bfd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nɨ̀ bə kɨ yuꞌu ndɨꞌɨ̀ ja, boŋ nɨ̀ lwìꞌi a mûm àkɔ̀ŋə̂ yâ, a ŋgɨ̌ŋ ŋgɨ̀ŋ a ajàŋ yìi mə̀ yùꞌùnə ndɨꞌɨ Taà ŋ̀kɨ nlwiꞌi a mûm àkɔ̀ŋnə̀ yi aà. ");
INSERT INTO bfd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mə̀ swoŋ ɨ̀nnù juà a mbo bù aa mə tâ nɨ̀dorə̀ na tâ nɨ̀ tswe a mbo bù tǎ tâ nɨ̀dorə̀ nuu kɨ nluu. ");
INSERT INTO bfd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ǹdɨꞌɨ̀ yà a mbo bù ɨ̀ nɨ mə: Nɨ̀ ka kɔŋnə ghuu bu nɨ bù a ajàŋ yìi mə mə̀ kɔ̀ŋə ghuu aà. ");
INSERT INTO bfd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Àkɔ̀ŋnə̀ yìi mə mbə ŋù a tswê nɨ yu a nû ɨ̀kàꞌâ ji yìi mə a tsyatə akɔ̀ŋnə tsɨ̀m aa, à nɨ̂ m̀fâ ǹtswêntɨ̀ɨ̂ yì ǹloŋ ŋkwitû waa. ");
INSERT INTO bfd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nɨ̀ nɨ̂ ɨ̀kàꞌâ ja aa a ajàŋ yìi mə mbə nɨ̀ ka ŋghɨrə ɨnnù jìi mə mə̀ swǒŋ mə tâ nɨ̀ ka ŋghɨrə aà. ");
INSERT INTO bfd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kaa mə̀ sɨ ghuu aa nɨ̂ ŋ̀gǎŋəfàꞌà bu ntwoŋə ǹloŋ mə kaa ŋ̀gàŋàfàꞌà kaa à sɨ̌ annù yìi mə tâfàꞌâ yì a ghɨ̀rə̀ aa zî. Mə̀ bàŋnə ntwoŋə ghuu aa nɨ̂ ɨ̀kàꞌâ jâ, ǹloŋ mə mə̀ swòŋ mə ɨnnù jìi mə mə lɛ nyuꞌu a mbo Taà ghà a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kaa a gha aa a lɛ ŋwaꞌà bu tsɔꞌɔ̀; a ghuu aa a lɛ mbàŋnə̀ ǹtsɔꞌɔ mə̂, ǹtoo ghuu mə tâ nɨ̀ ghɛɛ ŋka ŋkoonə mɨ̂ntà mî ghàꞌàtə̀; tâ mɨ̀ bə mɨ̂ntà mìi mə mɨ lwìꞌì nɨ̂ŋkoŋ aà. Ma mùu ajàŋ, tâ Taà ghà à tɨgə fa nɨ̂ ǹjoò tsɨ̀m jìi mə nɨ betə nɨ̂ ɨ̀kǔm gha aa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ǹdɨꞌɨ yìi mə mə̀ fa a mbu bù aa à nɨ mə, nɨ ka ŋkɔŋnə ghuu bu nɨ bù. ");
INSERT INTO bfd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“M̀bə̂ m̀bi ɨ ka mbaa ghuu, nɨ̀ zi mə ɨ̀ lɛɛ̀ m̀foo mbàà ghâ. ");
INSERT INTO bfd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nɨ̀ lɛ mbaa bə aa bə̀ bɨ mbi bù boŋ m̀bi yù ɨ kɔ̀ŋə̀ yìi mbuu bə̂. Lâ ǹloŋ mə kaa nɨ̂ sɨ̀ aa bə̀ bɨ mbi bu bə, mə̀ tsɔ̀ꞌɔ ghu aa a mûm mbi aa, a bə̂ ǹjiꞌì ànnù yìi mə m̀bi ɨ bàà nɨ̂ ghuu aà. ");
INSERT INTO bfd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nɨ̀ waꞌatə annù yìi mə mə̀ lɛ nswoŋ a mbo bù aà; ‘Kaa m̀bə ŋ̀gàŋàfàꞌà a waꞌǎ tâfàꞌà yì tsyâtə̀.’ M̀bə a bə mə bɨ lɛ sɨ ntsɔꞌɔ akòrə̂ ya, boŋ bɨ ka yǐ kɨɨ kɨ tsɔꞌɔ a yuu; m̀bə a bə mə bɨ lɛ sɨ yuꞌunə nɨ̂ ànnù yìi mə mə̀ lɛ sɨ dɨ̀ꞌɨ̀ aa, boŋ bɨ ka yǐ kɨɨ kɨ yuꞌunə nɨ̂ ànnù yìi mə nɨ kɨɨ ndɨꞌɨ aà. ");
INSERT INTO bfd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lâ bɨ ka yǐ ghɨ̀rə ɨnnù ma jû ɨ tsɨ̀m a nu bù ǹloŋ ŋgaà yà ǹloŋ mə kaa bɨ sɨ̌ ŋû yìi mə à tòo ghaa aa zî. ");
INSERT INTO bfd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mə̀ lɛ mbaa tuu zǐ ɨ̀ swoŋə ɨnnù jî bɨ̂ jyaa boŋ bo lɛ ŋkwo waa mbuꞌù; lâ, m̀bə yìi mə mə̀ lɛɛ̀ ǹzi ŋghɨ̀rə̀ bo zî ɨ̀bɨ̂ waa aa, kaa mbə bɨ waꞌǎ bù ǹswoŋ mə bo sɨ̌ ɨbɨ ghɨ̀rə̀. ");
INSERT INTO bfd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ŋù ǹtsɨ̀m yìi mə a bàà nàa laa, a kɨɨ mbaa nɨ̂ Taà ghà. ");
INSERT INTO bfd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ɨ̀nnù jî yɛ̌yɛrə jìi mə mə̀ lɛ ŋghɨ̀rə a tɨtɨ̀ɨ bo jìi mə ŋù dàŋ a mbìi mə̀ kaa à lɛɛ̀ ŋ̀waꞌà ghɨ̀rə̀ aa, ɨ lɛ mbaa tuu bə, boŋ kaa bɨ lɛ ŋwaꞌǎ ɨbɨ ghɨ̀rə̀. Lâ tsɨ̂tsɔŋ̀, bɨ yə̀ mə̂ ɨnnù jî yɛ̌yɛrə jya mə mə̀ lɛ ŋghɨ̀rə̀ aa, m̀baa gha ŋkɨ mbaa Taà ghà. ");
INSERT INTO bfd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma yuà ànnù a lɛ ntswe nɨ̂ m̀fɛ̀ꞌɛ tǎ lwensə annù yìi mə bɨ lɛ ŋŋwàꞌànə̀ a mûm àŋwàꞌànə nɔ̂ŋsə̀ yaa aà, mə, ‘Bɨ lɛ mbàà gha tɨ̀ ǹjiꞌì.’ ");
INSERT INTO bfd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Lâ ŋ̀gàŋkwɛtə̀ wa mə mə̀ ka too yi tâ à lo a mbo Taà ghà ǹzi a mbo bù aa, yu wa yìi mə à nɨ Azwì annù nɨ̂ŋkoŋ aa, à bə zǐ boŋ à ka kɨ swoŋə nɨ̂ ànnù ǹloŋ ŋgaà yà. ");
INSERT INTO bfd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tâ bù bûmbɔŋ nɨ̀ kɨɨ ntɨgə nswoŋə nɨ̂ ɨ̀nnù nloŋ ŋgaà yà ǹloŋ mə nɨ̀ tswe biꞌinə̀ ǹlɔgɨnə tsiꞌǐ nlɔgɨ̀nə aà. ");
INSERT INTO bfd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mə̀ swǒŋ juà ɨ̀nnù a mbo bù aa mə tâ nɨ̀ tswa abìintɨɨ̀ yuu ǹtsuu màꞌàtə̀ tâ à wo. ");
INSERT INTO bfd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Baa tɨgə furə nɨ̂ ghuu a nda ŋghotə bù, nòò a kɨɨ nzi, yìi mə ŋù à bə zwitə ghuu boŋ a bàŋnə̀ m̀mɔɔntə bə mə yu fàꞌà aa àfàꞌà yî sɨgɨ̀nə̀ a mbo Nwì. ");
INSERT INTO bfd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bə̀ ka yǐ kɨ ghɨ̀rə̀ ma juù ɨ̀nnù a nu bù aa nloŋ mə kaa bɨ sɨ̀ Taà ghà zi, kaa waꞌà gha kɨ nzi. ");
INSERT INTO bfd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","La mə̀ swoŋ ma juu ɨnnù a mbo bù aa mə tà bɛɛ nòò wa a yi ŋkùꞌù mə bɨ ka yǐ kɨ ghɨ̀rə̀ ma juù ɨ̀nnù a nu bù aa, boŋ nɨ̀ ka kɨ waꞌatə mə mə̀ lɛɛ̀ m̀baa ŋ̀kɛ̀ꞌɛ̀nə̀ a mbo bù. “Kaa mə̀ lɛ ŋwaꞌà juà ɨ̀nnù a mbo bù swoŋ a nlɔ̀gɨ̀nə̂ aa nloŋ mə mə̀ lɛ ntswe biꞌinə̀. ");
INSERT INTO bfd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","La tsɨ̂tsɔ̀ŋ mə ghɛ̀ɛ̀ fu a mbo ŋù yìi mə à lɛ ntoo gha aà. Lâ kaa ŋù nɨ̀ bù yî tsù à sɨ̀ ghu tswê a mbetə̀ mə mə ghɛ̀ɛ̀ aa fə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","La tsɨ̂tsɔ̀ŋ mə mə̀ swòŋ mə a mbo bù aa, mɨ̀ntɨɨ̀ muu mɨ luu nɨ̀ àjəŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mə swoŋ aa tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù mə, a bɔŋtə a mbo bù mə tâ mə̀ ghɛɛ, ǹloŋ mə mə̀ bə tsuu ghɛ̀ɛ̀ boŋ ŋ̀gàŋkwɛ̀tə ghùù wa kaa à ka waꞌà zì. Lâ mə̀ bə ghɛ̀ɛ̀ boŋ mə̀ ka too yi tâ à zi a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nòò yìi mə Àzwì Nwî ka zì aa, a ka ghɨ̀rə tâ a laa a mbo bə̀ bɨ mbi bù mə ɨ̀nnù jìi mə bo waꞌatə nloŋ ɨ̀nnù jî bɨ bo bɨ̀ ànnǔ ŋghɨ̀rə ɨ̀nnù jìi ɨ tsinə aa, a bɔ̀ꞌɔ nɨ̂ àjàŋ yìi mə Nwì à ka yǐ saꞌa mbi aa, kaa ɨ sɨ̀ kuꞌùnə̀. ");
INSERT INTO bfd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ɨ̀nnù jìi bo waꞌatə nloŋ ɨbɨ kaa ɨ sɨ̀ kuꞌùnə̀ aa nloŋ mə ka bo sɨ̀ mɨ̂ntɨɨ̀ myaa a nu mə̀ nɨŋ aà; ");
INSERT INTO bfd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ɨ̀nnù jìi mə bo kɨɨ ŋwaꞌatə nloŋ ŋghɨ̀rə ɨ̀nnù jìi ɨ tsinə aa kaa ɨ waꞌà kɨ̀ ŋ̀kuꞌunə aa nloŋ mə mə bù ŋ̀ghɛɛ nàa fu a mbɛ̀ɛ Taà ghà kaa tâ nɨ̀ waꞌà gha bù ǹyə; ");
INSERT INTO bfd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ɨ̀nnù jìi mə bo kɨɨ ŋwaꞌatə nloŋ ajàŋ yìi mə Nwì à ka yǐ kɨ tsɔꞌɔtə mɨsaꞌa aa kaa waꞌà kɨ ŋkuꞌunə aa, nloŋ mə Nwì à fòò mə̂ ǹtsərə ɨsaꞌa mfɔ̀ mbi ghù. ");
INSERT INTO bfd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mə̀ tswe nɨ̀ ɨ̀nnù jî ghàꞌàtə̀ a nswoŋ a mbo bù, jìi mə mə̀ bə swoŋ boŋ a ka tsyànə̀ a nyuꞌu tâ à kuu a atu bù. ");
INSERT INTO bfd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lâ nòò yìi mə Àzwǐ annù nɨ̂ŋkoŋ ya a zi aa, a ka ghɨ̀rə tâ nɨ̀ zi annù nɨ̂ŋkoŋ tsiꞌì tsɨ̀mə̀. Kaa a ka yǐ waꞌà kà ŋ̀ghaa aa nɨ̂ àtû yì, a ka yǐ kɨ swoŋ aa tsiꞌǐ ànnù yìi mə a yùꞌu aà; ɨ kɛ̀ꞌɛ̀nə̀ nɨ̂ ɨ̀nnù jìi mə ɨ ka yǐ fɛ̀ꞌɛ̀ aa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A ka yǐ kɨ ghaꞌasə nɨ̂ ghâ ǹloŋ mə a ka yǐ kɨ lɔ̀gə ɨnnù jìi mə à nɨ̂ ja aa ɨ tɨgə kɛ̀ꞌɛ̀nə̀ nɨ a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ǹjoò tsɨ̀m jìi mə Taà ghà à tswe nɨ ju aa, à nɨ aa mbə̂ jâ; à nɨ̂ ǹjiꞌì ànnù yìi mə mə̀ swǒŋ mə a ka yǐ tɨgə lɔ̀gə̀ nɨ̂ ɨ̀nnù jìi mə à nɨ̂ jâ aa ɨ tɨgə kɛ̀ꞌɛ̀nə̀ nɨ a mbo bù aà. ");
INSERT INTO bfd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“A nɨ mû àbàŋntə̀, kaa nɨ̀ ka waꞌà gha bù ǹyə lâ àbàŋtə̀ a bu tɨ tsyà nɨ̀ yə̂ ghâ.” ");
INSERT INTO bfd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ŋ̀gǎŋyəgə̂nnù Yesu jî mɔꞌɔ ɨ lɔgɨ̀nə̀ ǹtɨgə mbetə nɨ̂ waa bo nɨ bo mə, “Ǹjiꞌì ànnù muù mə à swòŋə aa ɨ̀ bə aa mə akə aa ɛ? À swòŋ a mbo bìꞌinə̀ mə a nɨ mû àbàŋtə̀ kaa tâ bìꞌinə̀ waꞌà yi yə̂, la àbàŋtə̀ yî mɔꞌɔ a bu tɨ tsyà bìꞌinə̀ bǔ nyə yi; ŋ̀kɨɨ nswoŋ nɨ mə ‘A bə ma mùu ajàŋ aa nloŋ mə mə ghɛ̀ɛ̀ aa a mbo Taà ghà.’ ");
INSERT INTO bfd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bo swoŋ mə ǹjiꞌì ‘mû àbàŋtə̀ ghû’ ɨ̀ bə aà àkə̀ aa ɛ? Kaa bìꞌì sɨ̌ atû yiꞌi nɨ̂ ànnù yìi mə a swoŋ aa zî!” ");
INSERT INTO bfd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu à lɛ nzi annù yìi mə bo lɛ sɨ lɔ̀ɔ mbetə yi ghu aà, ǹtɨgə nswoŋ a mbo bo mə, “Mə̀ ghɨ̀rə nswoŋ mə, ‘a nɨ mû àbàŋtə̀ kaa tâ nɨ̀ waꞌà gha yə̂, bɛɛ mə̂ àbàŋtə̀ yî mɔꞌɔ a bu tɨ tsyà, nɨ̀ bû ǹyə gha fu.’ À nɨ̂ ànnù yìi mə bǔ betə nɨ̂ ghuu bu nɨ bù ghu aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mə swoŋ aa tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù: Nɨ̀ ka yǐ kɨ yə̀ꞌə ɨ lɨ̀ nɨ mɨ̀làà, tâ m̀bi ɨ̀ ka mbaŋnə ndorɨtə; nɨ ka yǐ kɨ jəŋnə, lâ tâ àjəŋnə̀ yuu tâ à baŋnə mbəŋkə ntɨgə nɨdorə̀. ");
INSERT INTO bfd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nòò yìi mə màŋgyɛ̀ à tsɨ̀gə mu aa, a jəŋnə nloŋ mə nòò ŋ̀gɨꞌɨ yì à kùꞌù mə̂; la nòò yìi mə à jwè mə mu wa aa, a liꞌìnə̀ ǹyàŋə̂ ǹtsɨ̀m, ǹtɨgə ndorɨtə mə yu jwè mə a mu yì m̀fii a mûm m̀bî. ");
INSERT INTO bfd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Àa tsiꞌì ŋ̀gɨ̌ŋ ŋgɨ̀ŋ a ajàŋ yìi mə a tswe a mbo bù aà; tsɨ̂tsɔ̀ŋ nɨ jəŋnə, lâ mə̀ ka bǔ kwatə ɨ zǐ a mbo bù, ta mɨ̀ntɨɨ̀ muu luu nɨ nɨ̀dorə̀, àjàŋ nɨdorə yìi mə kaa mbə ŋù tsù a waꞌà a mbo bù kwɛrə aà. ");
INSERT INTO bfd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nòò yìi mə ǹjwi mà ya ɨ̀ ka yǐ zì aa kaa nɨ̀ ka yǐ waꞌǎ ayoo yì tsǔ a mbo mə̀ bû ŋ̀ka mbetə. Mə swoŋ aa tsiꞌì ànnù nɨ̂ŋkoŋ a mbo bù: Taà ghà à ka fa ŋgɔ̀ŋ njoò tsɨ̀m jìi mə nɨ betə nɨ̂ ɨ̀kǔm ghâ aà. ");
INSERT INTO bfd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ǹzi nyweꞌe tsɨ̂tsɔ̀ŋ, kaa nɨ̀ burə tɨ̌ ayoò tsu betə̀ nɨ̂ ɨ̀kǔm ghâ; nɨ̀ bə betə boŋ nɨ̀ ka kwɛrə, tǎ tâ nɨ̀dorə̀ nuu tâ nɨ̀ luu. ");
INSERT INTO bfd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mə̀ lɔ̀gə̀ aa mɨ̀ghàà mî nǎnaa ŋkɛꞌɛnə ɨnnù juà ghu a mbo bù. La nòò à tswe ghu mə kaa mə̀ ka waꞌǎ a mbo bù aa nɨ̀ mɨ̀ghàà mî nǎnaa bû ŋ̀ka ŋghaa, ɨ tɨgə ghàà a mbo bù aa nɨ̂ ǹsi nɨ̀ ǹsi nloŋə Taà. ");
INSERT INTO bfd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ǹjwi mà ya ɨ̀ ka yǐ kùꞌu aa, tâ nɨ̀ tɨgə mbetə nìi nɨ̂ ɨ̀kǔm ghâ; kaa mə̀ sɨ swoŋ aa mə mə̀ ka yǐ kɨ betə nìi a ŋkwitu bù, ");
INSERT INTO bfd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","nloŋ mə Taà ghà yumbɔŋ à kɔ̀ŋə ghuu. À kɔ̀ŋə ghuu aa nloŋ mə nɨ̀ kɨ ŋkɔ̀ŋə̀ ghâ, ŋkɨ mbii mə mə̀ lɛ nlò aa ghu mbo nzì. ");
INSERT INTO bfd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mə̀ lɛ nlò aa a mbo Taà ghà m̀fɛꞌɛ fàa mbî; tsɨ̂tsɔ̀ŋ, mə màꞌàtə mbi yù m̀bu mbɨ̀ɨ̀ nɨ̂ gha fu a mbo Taà ghà.” ");
INSERT INTO bfd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ŋ̀gǎŋyəgə̂nnù ji ɨ tɨgə̀ ǹswoŋ ghu mbo mə, “Tsɨ̂tɔ̀ŋ o ghàà a mbo bìꞌì nɨ̂ ǹsi nɨ̀ ǹsî, kaa waꞌà nɨ nɨ̀ghàà bû ǹnaa. ");
INSERT INTO bfd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tsɨ̂tsɔ̀ŋ bìꞌì zi mə ò zǐ ɨnnù tsiꞌì tsɨ̀mə̀; kaa bə̀ sɨ̀ nɨ̂ ŋ̀ka mbetə̂ gho nɨ̀ ànnù tswê. Ma yû a ghɨrə mə tâ bìꞌì bii mə ò lɛ nlò aa mbo Nwì ǹzi.” ");
INSERT INTO bfd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu a kwiꞌi a mbo bo mə, “Nɨ̀ bìì mə̂ tsɨ̂tsɔ̀ŋə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nòò à tɨ̀gə a abô, nòò wa à tɛ̀ꞌɛ̀ mə̂ ŋ̀kuꞌu, mə baa jàꞌà ghuu tâ ŋù à ghɛɛ nɨ̂ yìi mbɛ̀ɛ̀, tâ ŋù à ghɛɛ nɨ̂ yìi mbɛ̀ɛ̀, ɨ tɨgə mmàꞌàtə̀ gha, mə̀ mə̀. Lâ kaa mə̀ sɨ̀ aa tsiꞌì mə̀ mə̀ naŋsə̀ ǹtswe, nloŋ mə Taà à tswe bìꞌi yu. ");
INSERT INTO bfd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mə̀ swǒŋ ma juù ɨ̀nnù a mbo bù aa mə tâ nɨ̀ tswe nɨ̂ m̀bɔɔnə, a ajàŋ yìi mə mbə bìꞌinə̀ tswê nɨ̂ ànnù yî mɔꞌɔtə̂ aà. Tsǒ mə nɨ̀ tswê a mûm m̀bi aa, nɨ̀ ka yə ŋgɨꞌɨ̀. Lâ nɨ̀ taŋ ntɨɨ̀! Wa mə̀ tsyà mə mbî!” ");
INSERT INTO bfd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu à màŋsə̀ mə̂ a nswoŋ ma jû ɨ̀nnù, ŋ̀ŋɛɛ miꞌì mi, nlii aburə, ǹswoŋ mə, “Taà ghà, nòò à kùꞌù mə̂. Ghaꞌasə Mû ghò tǎ tâ Mû ghò à kɨ ŋghaꞌasə ghô. ");
INSERT INTO bfd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ò lɛ mfa mɨdaꞌa ghu mbo mə tâ à ka mbuꞌutə ŋgɔ̀ŋ mu ŋǔ ntsɨ̀m, tǎ ɨ fa ntswêntɨ̀ɨ̀ yìi mə ɨ̀ tswe nɨ̂ŋkoŋ aa a mbo bo bìi mə ò lɛ mfa ghu mbo aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ǹtswêntɨ̀ɨ̀ yìi mə ɨ̀ lwìꞌi nɨ̂ŋkoŋ aa, ɨ̀ laa mbə a nzi wò, wò Nwîŋgɔ̀ŋ yî mɔ̀ꞌɔtə̀ yìi ò nɨ Nwîŋgɔ̀ŋ tsiꞌǐ annù nɨ̂ŋkoŋ aà, ŋ̀kɨ mbə a nzi Yesu Kristo, yìi mə ò lɛ ntoo aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mə̀ ghàꞌàsə̀ mə̂ gho fàa atu nsyɛ̂; mə̀ màŋsə̀ mə afàꞌà yìi mə ò lɛ mfa mə tâ mə̀ faꞌa aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Taà ghà! Ghaꞌasə a gha tsɨ̂tsɔ̀ŋ a mbɛ̀ɛ wò, tsiꞌì nɨ̂ nɨ̀ghaꞌa nya mə mə̀ lɛ ntswe nɨ nu biꞌiò m̀bɔŋ ta ò naŋsə mbi aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mə̀ ghɨ̀rə mə tâ bə̀ bya bìi mə ò lɛ ntsɔꞌɔ fàa mûm m̀bi mfa a mbo mə̀ aa, mə tâ bɨ̀ zi ghô. Bo lɛ mbə aa bə̀ bô, la ò fâ waa a mbo mə̀. Bo yuꞌunə nɨghàâ nô, ");
INSERT INTO bfd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tsɨtsɔ̀ŋ bo zi mə ŋgɔ̀ŋ ǹjoò tsɨ̀m jìi mə ò lɛ mfa a mbo mə̀ aa ɨ lo aa a mbo wò. ");
INSERT INTO bfd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mə̀ fà mə ntoo yìi mə ò lɛ ntoo gha nɨ̀ yù aa a mbo bo, bo kɨ̂ ŋ̀kwɛrə; bo zi tsiꞌì sɨgɨ̀nə̀ mə mə̀ lɛ nlò aa a mbo wò ǹzi, ŋkɨ mbii mə a gha aa a tòo wò. ");
INSERT INTO bfd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Mə tsàꞌàtə̀ nòo ŋwaꞌatə nɨ̂ waa, kaa mə̀ sɨ nòo tsàꞌàtə aa nloŋ mbî ǹtsɨ̀mə̀; mə tsàꞌàtə̀ nòo nloŋ aa bo bya mə ò fa a mbo mə̀ aà, ǹloŋ mə bo laa mbə bə̂ bô. ");
INSERT INTO bfd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bə̀ bɨ̀tsɨ̀m bo bɨ̀ ǹjoò tsɨ̀m jìi mə mə̀ tswe nɨ ju aa, à nɨ̂ jô, jìi mə ò kɨ ntswe nɨ ju aa, ɨ bə̂ jâ; bɨ kɨɨ̀ ntsya aa a njɨ̌m bo nyə nɨ̂ nɨ̀ghaꞌà nâ. ");
INSERT INTO bfd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tsɨ̂tsɔ̀ŋ mə bù m̀bɨɨ nzì fu a mbo wò; kaa mə̀ ka waꞌà fàa mûm mbì bù ntswe, lâ bo ka ghɛ̀ɛ̀ nɨ̂ m̀bìì a ntswe fàa mûm m̀bî. Taà ghà yìi mə à làa màŋsə̀ aa, bɛ waa nɨ mɨ̀dàꞌà mya mìi mə mɨ tswe a nɨ̂ ɨ̀kǔm gho aà, ɨ̀kùm wa yìi mə ò lɛ mfa a mbo mə̀ aà, mə tâ bo tswe nɨ̂ ànnù yî fùùrə̀, tsǒ mə sɨ̀ kɨ ntswe nɨ̂ ànnù yî fùùrə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nòò yìi mə mə̀ kɨ̀ tswe biꞌi bo aa, mə̀ kɨ̀ sɨ bɛ waa nɨ àdàꞌà yìi mə a tswe nɨ̂ ɨ̀kǔm gho aà, ɨ̀kùm wa yìi mə ò lɛ mfa a mbo mə̀ aà. Mə̀ kɨ̀ lɛ mbɛ waa kaa tsiꞌì ŋù nɨ̀bò wàà yî m̀fùùrə̀ kaa a waꞌà bwɛ̂, a kɨ̂ m̀mɛ yu wa yì m̀fùùrə̀ mə à lɛ ntswe nɨ̂ m̀bwɛ aà, mə tâ ànnù yìi mə a lɛ ntswe a mûm àŋwàꞌànə Nwì aa, tâ à fɛꞌɛ mbòòntə̀. ");
INSERT INTO bfd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tsɨ̂tsɔ̀ŋ mə bù m̀bɨɨ fu a mbo wò. Mə swoŋ nɨ̂ ɨ̀nnù juà aa a ajàŋ yìi mə bùrə a mûm m̀bi aa mə tâ nɨ̀dorə̀ na tswe a mûm ǹtɨɨ bo nluu. ");
INSERT INTO bfd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mə̀ lɛ mfa ntoò yò a mbo bo, lâ m̀bi ɨ bàà waa, nloŋ mə kaa bo sɨ̀ bə̂ bɨ mbi bù bə̂ aà, tsiꞌǐ ajàŋ yìi mə kaa mə̀ sɨ ŋû m̀bi ghù kɨ̂ m̀bə aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kaa mə̀ sɨ lɔ̀ɔ aa mə ta ò fiꞌi waa fàa mûm m̀bi nlɔ̀ꞌɔ̀sə̀, mə bàŋnə̀ ǹlɔɔ aa mə tâ ò bɛ a waa a mbo ŋgàŋmbùꞌû ɨ̀nnù jî bɨ wâ. ");
INSERT INTO bfd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tsiꞌì a ŋgɨ̌ŋ ŋgɨ̀ŋ a ajàŋ yìi mə kaa mə̀ sɨ̀ ŋû m̀bi bù bə aa, kaa bo sɨ̀ bə̂ bɨ mbi bù kɨ mbə. ");
INSERT INTO bfd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tsɔꞌɔ waa nləə tâ bo tɨgə bə̂ bo a njɨ̌m àjàŋ yìi mə bo ka zi annù nɨ̂ŋkoŋ aà; nɨ̀ghàâ no nɨ laa mbə annù nɨ̂ŋkoŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mə̀ tòo waa a mûm m̀bî, tsiꞌì àjàŋ yìi mə ò lɛ ŋkɨ ntoo gha a mûm m̀bi aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mə̀ tɨgə ntsɔꞌɔ ɨbɨ̀ɨnû gha nlə̀ə̀ aa tsiꞌì tsǒ àyoo mmàꞌanwì a mbo wò, ǹloŋ ŋkwi atû waa, mə tâ bo kɨ mbə njoo mmàꞌanwì ji annù nɨ̂ŋkoŋ a mbo wò. ");
INSERT INTO bfd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kaa mə̀ sɨ nɨ̂ gho tsàꞌàtə̀ ŋ̀waꞌatə aa tsiꞌì waa, mə kɨɨ ŋwaꞌatə nɨ̂ bya bìi mə bɨ kɨ nnɨŋ mɨ̂ntɨɨ̀ myaa a nu mə̀, ǹtsya a njɨ̌m ntoo yìi mə bo yuꞌu nɨ a ntsǔ ŋgǎŋyəgə̂nnù ja aa. ");
INSERT INTO bfd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mə lɔɔ nɨ mə tâ bo tswe nɨ̂ ànnù yî fùùrə̀. Taà ghà! Mə kɔ̀ŋə̀ nɨ mə tâ bo tswe a mum bìꞌìô, tsiꞌì a ajàŋ yìi mə ò tswe a mum mə̀, mə̀ kɨ̂ ǹtswe a mum wò aà. Mə lɔɔ nɨ mə tâ bo tswe nɨ̂ ànnù yî fùùrə̀, tǎ tâ m̀bi bii mə a gha aa a too wò. ");
INSERT INTO bfd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mə̀ fa nɨ̀ghaꞌa nya nìi mə ò lɛ mfa a mbo mə̀ aa a mbo bo, mə tâ bo tswe nɨ̂ ànnù yî fùùrə̀, tsiꞌì a ajàŋ yìi mə wò nɨ mə̀ sɨ̀ nɨ ayoo yì fùùrə̀ aà; ");
INSERT INTO bfd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mə̀ tswe a mum bo, ò kɨ̂ ǹtswe a mum mə̀, tâ bo naŋsə mboonsə mbə ayoo yì fùùrə̀, tâ m̀bi ɨ̀ tsya ghu nzi mə a gha aa a lɛ ntoo wô, ŋ̀kɨ ŋkɔŋə waa a ajàŋ yìi mə ò kɔ̀ŋə gha aà. ");
INSERT INTO bfd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Taà ghà! Ò fa waa a mbo mə̀, mə̀ kɔŋə̀ nɨ mə tâ bo tswe a adɨgə yìi mə mə̀ tswe ghu aa, tǎ yə nɨghaꞌà nâ, nɨ̀ghaꞌa nya nìi mə ò fa a mbo mə̀ aà; ǹloŋ mə ò lɛ ŋkɔ̀ŋə̀ gha mbɔŋ nnaŋsə mbi yù. ");
INSERT INTO bfd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taà ghà yìi mə ɨ̀nnù jo tsinə aa, kaa mbi ɨ̀ sɨ gho zî, la mə̀ zi ghô, buà bû kɨ̂ ǹzi mə a gha aa a tòo wò. ");
INSERT INTO bfd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mə̀ ghɨrə bo zî ghô, màa kɨɨ ghɛ̀ɛ̀ nɨ̂ m̀bìì a ŋghɨ̀rə mə tâ bo zi ghô, tǎ tâ àkɔ̀ŋnə̀ yìi mə ò tswe nɨ yu a nu mə̀ aa, tâ à tswe a nu bo, tǎ tâ mə̀ kɨ ntswe a mum bo.” ");
INSERT INTO bfd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Àjàŋ mə Yesu à lɛ mmàŋsə̀ a ntsàꞌàtə Nwì ma mùu ajàŋ aa, ǹlo bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji ǹtoo mutswàgə̀ ŋ̀kì wa yìi mə bɨ twoŋə nɨ Kidron aà; ŋ̀kya ati mɨ̂ntà yî mɔ̀ꞌɔ ɨ lɛ ntswe ghu, Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji jya bɨ kuu ŋghɛ̀ɛ̀ wa a mûm ŋ̀kyâ. ");
INSERT INTO bfd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas mə à lɛ mfèè yi aa, à lɛ nzi adɨgə ma yû ǹloŋ mə a nɨ bɨ̀nòò bî ghàꞌàtə̀, Yesu bo bɨ̀ ŋ̀gǎŋyəgə̂nnù ji lɛ sɨ bòòntə ghu. ");
INSERT INTO bfd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tsǒ mə à lɛ nzi aa, à lɛ nlɔ̀gə akùrə̀ bɨ̂sogyɛ̀ bo bɨ̀ ŋ̀gǎŋmbɛ̂ ǹdâmàꞌanwì jìi mə ŋ̀gàŋmàꞌa Nwì yî ŋwè bo bɨ̀ baFarɨsai lɛ ntoo aa, bo bo ghɛɛ̀ ghu, bo kà mə̂ aa ŋghɛɛ aa, ntugɨtə njoo mɨtsəꞌə nɨ bɨ̀lâm nɨ mɨ̀ŋkàꞌà. ");
INSERT INTO bfd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tsǒ mə Yesu à lɛ nzi ŋgɔ̀ŋ ɨ̀nnù tsɨ̀m jìi mə bo lɛ sɨ lɔ̀ɔ a ŋghɨ̀rə̀ aà, m̀maꞌatə ŋgǎŋyəgə̂nnù ji jya, m̀fɛꞌɛ yòŋtə a mbɛ̀ɛ bo, m̀betə waa mə, “Nɨ lɔ̀ɔ̀ aà wò ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bo kwiꞌi ghu mbo mə, “Bìꞌi lɔ̀ɔ̀ aa Yesu, mu Nazareth wâ.” Yesu a swoŋ a mbo bo mə, “Mə̀ ghulà.” Judas, mə à lɛ mfèè yi aa, à lɛ ŋkɨ ntəə bo bo. ");
INSERT INTO bfd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Àjàŋ mə Yesu à lɛ nswoŋ mə, “Mə̀ ghulà aa,” bo khə̀tə̀ m̀bɨɨ nɨ̂ ǹjɨ̀m, ŋ̀wokə a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu a kuꞌùsə̀ m̀betə waa mə, “Baa nɨ̀ swǒŋ mə nɨ lɔ̀ɔ̀ aà wò lɛ?” Bo kwiꞌi mə, “A Yesu, mu Nazareth wâ.” ");
INSERT INTO bfd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu a bû ǹswoŋ a mbo bo mə, “Tɨgə mə̀ bà mə̂ aa nswoŋ a mbo bù mə ‘mə̀ ghulà.’ Lâ mbə a bə yìi mə nɨ lɔ̀ɔ̀ aà gha, nɨ̀ maꞌàtə bulà bə̀ bɨ ghɛɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","À lɛ nswoŋ ma la aa, tǎ ghɨ̀rə tâ ànnù yìi mə à lɛɛ̀ ǹtɛꞌɛ nswoŋ aa, tâ à boontə, mə “Taà ghà, kaa ŋù wa yì tsù mə ò lɛ mfa a mbo mə̀ aa, kaa yi tsù à sɨ̀ bwɛ̂.” ");
INSERT INTO bfd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peta à lɛ ŋwɛꞌɛ munwî ǹtsò; à lɛ ntsɔꞌɔ munwi wa a mbaꞌa, ŋ̀kwyɛ atôŋnə̌ àbùꞌu ŋgàŋmàꞌa Nwì yî ŋwè yî màꞌà ǹlɔꞌɔsə. Ɨ̀kǔm àbùꞌù ma yû ɨ lɛ mbə Malkus. ");
INSERT INTO bfd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu a swoŋ a mbo Peta mə, “Sɔꞌɔ munwi ghò wa fu a mbaꞌà! Ò wàꞌàtə mə mə̀ ka waꞌǎ ndɔ̂ŋ ŋ̀gɨꞌɨ yìi mə Taà ghà à fa a mbo mə̀ aa no aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Bɨ̀sogyɛ̀ bya bo bɨ̀ ǹdɨɨ̀ wàà, nɨ ŋgǎŋmbɛ ndâmaꞌanwì bɨ lɛ ntswa Yesu ŋ̀kwerə yi. ");
INSERT INTO bfd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ǹlɔgə yi ŋghɛɛ nɨ ghu a mbo Annas. Annas à lɛ mbə ntsi Kaifas yìi à lɛ mbə ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè maa alòò aà. ");
INSERT INTO bfd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifas ma ghû à lɛ mbə yu yìi mə à lɛ ndɨꞌɨtə bɨ̂tà bɨ alaꞌa bɨ baYuda mə a bɔŋ mə tâ ŋù yî m̀fùùrə̀ à kwo nloŋ atu nnɔ̀ɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Peta bo ŋ̀gàŋyə̀gə̂nnù Yesu wa yì mɔ̀ꞌɔ bo lɛ nyòŋə̀ Yesu. Ǹgàŋmàꞌa Nwì yî ŋ̀wè wa à lɛ naŋsə nzi ŋ̀gàŋyə̀gə̂nnù ma ghû tsiꞌì sɨgɨ̀nə̀. Ǹyoŋə Yesu bo yu kuu ŋghɛ̀ɛ̀ a mûm ǹsàŋdâ ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè wâ. ");
INSERT INTO bfd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peta à lɛ mbàŋnə̀ ǹtəə a mbɛɛ a tsǔbùꞌù. Ŋ̀gàŋyə̀gə̂nnù Yesu ma ghû mə ŋgàŋmàꞌa Nwi yî ŋ̀wè à lɛ nzi aa à lɛ mfɛ̀ꞌɛ̀ ŋ̀ghaa a mbo mumàŋgyɛ̀ yìi mə à lɛ ntəə wa tsǔbùꞌù aa, ǹlɔgə Peta bo yu kuù. ");
INSERT INTO bfd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mumàŋgyɛ̀ wa a ntsǔbùꞌù a betə̀ Peta mə, “Ò sɨ̌ ŋgàŋyə̀gə̂nnǔ mbâ yî kɨ mbə aa ɛ?” Peta a kwiꞌi ghu mbo mə, “Ŋ̀gaŋ, kaa mə̀ sɨ̀ ghu bə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Àjàŋ mə m̀fəꞌə ɨ lɛ sɨ ko aa, ŋ̀gǎŋàfàꞌǎ ŋgàŋmaꞌa Nwì wa nɨ ŋ̀gǎŋmbɛ̂ ɨ̀dɨ̀gə̀, bɨ lɛ ŋŋètə mɔꞌɔ nɨ̂ ŋ̀kyɛ, ntəə ghu, ǹtɨgə nyɔꞌɔtə. Peta à lɛ ŋghɛ̀ɛ̀ ǹtəə bo bo ŋ̀kɨɨ nyɔꞌɔtə mɔꞌɔ wâ yìi ŋgaa. ");
INSERT INTO bfd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ŋ̀gàmàꞌanwì yî ŋ̀wè wa à lɛ mbetə Yesu nɨ ɨ̀betə̀ ǹloŋ ŋgǎŋyəgə̂nnù ji bo bɨ̀ ǹloŋə ànnù yìi mə à lɛ sɨ dɨ̀ꞌɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu a kwiꞌi ghu mbo mə, “Mə ghàà aa a nsi bə̀ bɨ̀tsɨ̀mə̀. Ŋ̀gɔ̀ŋ ɨ̀nnǔ tsɨ̀m jìi mə mə dɨ̀ꞌɨ̀ aa, mə̀ lɛ sɨ dɨ̀ꞌɨ̀ a ndâmàꞌanwì bo bɨ̀ a ndâŋghotə̂, a bə ɨ̀dɨ̀gə tsɨ̀m jìi mə bə̀ bɨ̀tsɨ̀m bòòntə̀ ghu aà, kaa mə̀ lɛɛ̀ ŋ̀kɨ̀ꞌɨ̌ annù tsu a lɔ̀ꞌɔ̀sə̀ burə swoswoŋ bə̂. ");
INSERT INTO bfd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ò tɨgə̀ m̀bu mbetə nɨ̂ gha nɨ̀ ɨ̀betə̀ aa a ya ɛ? Betə bə bə̀ bulà bìi mə bɨ lɛ nyuꞌu annù yìi mə lɛ sɨ swoŋ aà. Wa bo zî ànnù yìi mə mə̀ lɛ sɨ swoŋ a mbo bo aà.” ");
INSERT INTO bfd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Àjàŋ mə Yesu à lɛ nswoŋ ma mùu ajàŋ aa, ŋ̀gàŋmbɛ ɨdɨ̀gə̀ wa yì mɔ̀ꞌɔ a zwî àbo ghu atu, m̀bətə yi mə, “A swǒŋ wò a mbo wò mə tâ ò ka ŋghaa a mbo ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè ma mùu ajàŋ ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu a swoŋ ghu mbo mə, “M̀bə a bə yìi mə mə̀ swòŋə̂ ànnù yî bɨ yì tsu, ò kɛꞌɛ̀nə̀ a mbo bə̀ bù mə bɨ təə faà aà, m̀bə a bə mə ɨ̀nnù jìi mə mə̀ swòŋə̀ aa ɨ kuꞌunə, ò tɨgə̀ m̀bu mfɛɛ gha aa a ya ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ma mùu noò Annas à lɛ nlɔ̀gə̀ yi tsiꞌì wa ajàŋ yìi mə bɨ lɛ ŋkwerə yi aa, ǹtsyasə a mbo Kaifas yìi mə à lɛ mbə ŋgàŋmàꞌa Nwì yî ŋwè aà. ");
INSERT INTO bfd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Peta à lɛ mburə ntəə wa adɨgə nyɔꞌɔtə nɨ̂ mɔꞌɔ wa; bə̀ bî mɔꞌɔ bɨ betə̀ yi mə, “Ò laa ŋkɨꞌɨ̀ ŋ̀gàŋyə̀gə̂nnù m̀bâ wî yî mɔ̀ꞌɔ bə aa ɛ?” Peta a tuù yi nswoŋ mə, “Kaa mə̀ sɨ̀ ghu bə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Àbùꞌu ŋgàŋmàꞌa Nwì ya yî mɔꞌɔ, mbə ndɨm ŋù wa mə Peta à lɛ ŋkwyɛ̌ atôŋnə̀ yi aa, a betə̀ mə, “Mə̀ ghɨ̀rə mbaa kɨꞌɨ̀ gho yə ò tswê bǔ bo wa a mûm ŋ̀kya aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peta a kuꞌùsə̀ ǹtuu yi nswoŋ mə, “Ŋ̀gaŋ!” Tsiꞌì maa noò àkə̀gə̀ a tɔŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bɨ lɛ nlɔ̀gə̀ Yesu ŋ̀ghɛɛ nɨ ghu a ntɔꞌɔ Gûmnàà, maa noò a burə̀ aa tsiꞌǐ mbàꞌa mbàꞌà. BaYuda kaa bo lɛ ŋwaꞌà waa wa mûm ǹtɔꞌɔ kuù, ǹloŋ mə bɨ lɛ nlɔ̀ɔ̀ mə bɨ baꞌatə nɨ̂ ɨ̀bɨɨnû waa lə̀ə tâ ɨ̀ laa a nyòŋə nɨ nɔ̀ŋsə̀ wàà tǎ jɨ mɨjɨ mɨ Passa. ");
INSERT INTO bfd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato à lɛ ntɨgə mbaŋnə mfɛ̀ꞌɛ̀ a abɛɛ mbetə waa mə, “Nɨ̀ swǒŋ mə ŋù ghû à ghɨ̀rə̀ aa akə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bo kwiꞌi ghu mbo mə, “À ghɨrə mbaa tsuu annǔ fànsə̀ boŋ kaa bìꞌì sɨ̀ nɨ ghu a mbɛ̀ɛ wò zî.” ");
INSERT INTO bfd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato a swoŋ ghu mbo mə, “Mbə a bə la, nɨ̀ lɔgə yi ŋghɛɛ ntsɔꞌɔtə ɨsaꞌà yi nyoŋ a nɨ nɔ̀ŋsə̀ ghùù.” Bo kwiꞌi ghu mbo mə, “Kaa bìꞌì sɨ̀ nɨ̂ àdàꞌà mə mbə bìꞌì zwitə̀ ŋû tswê.” ");
INSERT INTO bfd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A lɛ mfɛ̀ꞌɛ̀ lâ là aa mə tâ à boontə nɨ nɨ̀ghàà nìi mə Yesu à lɛ sɨ swoŋə nloŋ ajàŋə̀ nɨwo yìi mə yu lɛ ntswe nɨ̂ ŋ̀kwo aà. ");
INSERT INTO bfd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato à lɛ mbù ŋ̀kuu ŋghɛɛ fu wa mûm ǹtɔꞌɔ, ǹtwoŋə Yesu m̀betə yi mə, “Ò bə aa m̀fɔ̀ baYuda aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu a betə̀ yi mə, “Nɨ̀ghàà nû mə o betə gha ghu aà, à nɨ̂ no kə̀ a swoŋ bə̀ ǹswoŋ a mbo wò aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato a bəŋ mbetə yi mə, “Mə̀ laa mbə ŋû baYuda aa ɛ? A fa bə̌ bo mfa gho a mbo mə̀ bo bɨ̀ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌ Nwì. Ò nàŋsə mfànsə aà àkə̀ ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu a swoŋ mə, “Kaa ànnù nɨfɔ̀ ya kaa a sɨ̀ aa fàa a nɨ yula mbi tswê. À ghɨ̀rə mbaa mbə mə ànnù nɨfɔ̀ ya a tswe aa fàa nɨ yulà mbi, boŋ ŋgǎŋkòrə̂ jâ ɨ to fɨ̀kɔ̀rə̀ kaa bɨ kɨꞌɨ̀ gha a mbo bɨ̀tà bɨ baYuda fâ. Ŋ̀gaŋ, kaa ànnù nɨfɔ̀ ya kaa a sɨ̀ aa fàa nɨ yulà m̀bi tswê.” ");
INSERT INTO bfd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato a betə̀ yi mə, “La a bə mə ò nɨ mfɔ̀ aa ɛ?” Yesu a kwiꞌi mə, “ò swòŋ mə̂ mə mə̀ nɨ̂ m̀fɔ̀. Bɨ lɛ njwe gha mə̀ fɛꞌɛ̀ fàa mbi aa nloŋ ŋkwitu ànnù yî fùùrə̀, a ŋka ŋghàâ ànnù ǹloŋə ànnù nɨ̂koŋə̀. Ŋù ǹtsɨ̀m yìi mə à tswe a mûm ànnù nɨ̂koŋə aa a yuꞌutə annù yìi mə mə swoŋə aà.” ");
INSERT INTO bfd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato a betə̀ mə, “Ànnù nɨ̂ŋkoŋ à nɨ̂ àkə̀ aa ɛ?” Pilato a bû m̀fɛꞌɛ ŋghɛ̀ɛ̀ ǹyə bə̂ bya, nswoŋ a mbo bo mə, “Kaa mə̀ sɨ̌ annù tsu yə mə mbə a ghɨrə̀ mə tâ mə̀ nɨŋ ŋgɨꞌɨ ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lâ ǹyoŋə a nɨ nɔ̀ŋsə̀ yìi mə nɨ̀ tswe nɨ ghu aa, mə fiꞌisə nɨ ŋgàŋàtsaŋ yì m̀fùùrə̀ a mbo bù, a njwî Passa. Nɨ̀ kɔ̌ŋ mə tâ mə̀ fiꞌisə Mfɔ̀ baYuda ghû aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bo tɔŋnə̀ ǹswoŋ mə, “Ŋ̀gaŋ, kaa mbə a kɨꞌɨ̀ yu bə̂! Bìꞌi lɔ̀ɔ̀ mə tâ ò fiꞌisə aa Barabas!” (Barabas à lɛ mbə aŋgâmɨghee). ");
INSERT INTO bfd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato à lɔgə̀ Yesu m̀fa yi bɨ ghɔɔ̀ yi. ");
INSERT INTO bfd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bɨ̀sogyɛ̀ bya bɨ lɔ̀ɔ mɨ̂ndɨgə mɨ njɔ̂ŋ ǹjɔŋ mbaꞌa tsǒ àtsə̀ꞌətu nɨfɔ̀ ǹsosə ghu atû. Ǹtɨgə ǹlɔgə atsə̀ꞌə̀ yî bagɨtə yi atɨ̀ndùù ŋ̀wɛꞌɛ ghu nû. ");
INSERT INTO bfd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bo tɨgə̀ ǹtsya mmii nìi nswoŋə nɨ mə, “O lɛlɛ lɛɛ̀! M̀fɔ̀ baYuda à kɨ̀ kwɛ̀ɛ̂! À kwɛ̀ɛ̂!” Lâ m̀baŋnə mfɛɛ nɨ mɨ̀ghàꞌa mi. ");
INSERT INTO bfd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato à lɛ bù m̀fɛꞌɛ ŋghɛ̀ɛ̀ a mbo nnɔ̀ɔ̀ bə̂ wa nswoŋ a mbo bo mə, “Yə̂ nɨ̀, mə̀ ka fɛ̀ꞌɛ zì nɨ ghu a nsi bù tâ nɨ̀ zi mə kaa mə̀ sɨ̀ annù yìi mə à ghɨ̀rə mə mbə nɨ nɨŋ ŋ̀gɨꞌɨ ghu nu aa yə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu a tɨgə̀ m̀fɛꞌɛ nɨ àtsə̀ꞌə̀ yî bagɨtə ya bo bɨ̀ nɨ̂ àtsèꞌətu njɔ̂ŋjɔŋ ya a atu yu. Pilato a swoŋ a mbo bə̀ bya mə, “Ŋù wa à ghulà.” ");
INSERT INTO bfd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ ŋ̀gǎŋmbɛ̂ ǹdâmàꞌanwi bɨ yə̀ mə̂ yi aa, ntɔŋnə nswoŋ mə, “Kwèèntə yi a ati bàŋnə̀ bàŋnə̀.” Pilato a swoŋ a mbo bo mə, “Nɨ̀ lɔgə yi la ŋkwèèntə̀ tsiꞌì bù, kaa mə̀ sɨ̌ njiꞌì ànnù yìi mə mbə mə̀ nɨŋ ŋ̀gɨꞌɨ ghu nu aa yə̂.” ");
INSERT INTO bfd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ǹnɔ̀ɔ̀ wa ɨ kwiꞌi mə, “Bìꞌì tswe nɨ̀ nɔ̀ŋsə̀ yìꞌì mə a dɨ̀ꞌɨ̀ nɨ mə a kuꞌunə mə tâ à kwo, ǹloŋ mə a swoŋə nɨ mə yu nɨ Mu Nwì aà.” ");
INSERT INTO bfd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato à yùꞌù mə̂ ma mùu ajàŋ, nɨ̀bɔꞌɔ nɨ kuꞌùsə̀ ǹtswâ yi. ");
INSERT INTO bfd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A bû ŋ̀kuu ŋghɛɛ fu wa a mûm ǹtɔꞌɔ, m̀betə Yesu mə, “Baa ò lò aa fə aa ɛ?” Kaa Yesu a waꞌǎ akwiꞌi ghu mbo fâ. ");
INSERT INTO bfd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato à swoŋ ghu mbo mə, “O nàꞌà nàa ɛ? Ò sɨ̀ zi mə mə̀ tswe nɨ̀ mɨ̀dàꞌà mìi mə mbə mə̀ swoŋ mə tâ bɨ̀ maꞌatə gho, kə̀ a nswoŋ mə tâ bɨ̀ kweentə gho a ati bàŋnə̀ bàŋnə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu a kwiꞌi mə, “A bə aa mə, ò tswe nɨ̀ mɨ̀dàꞌà a atu mə̀ aa nloŋ mə Nwì à fa a mbo wò aà. Lâ ŋù wa mə à ghɨrə mbàŋnə̀ zi mfa gha a mbo wò aa, à yìi annù a bɨꞌɨ ntsyâ yô.” ");
INSERT INTO bfd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato à yùꞌù mə̂ ma mùu ajàŋ aa, nyweꞌetə a nlɔ̀o mânjì a màꞌàtə Yesu ghu. Lâ ǹnɔ̀ɔ̀ bə̂ wa ɨ kuꞌùsə̀ ǹtɔŋnə nswoŋ mə, “Ò bə màꞌàtə̀ yi bəə boŋ kaa ò sɨ̌ nsûkàꞌa Kaisa bə̂. Ŋù ǹtsɨ̀m yìi mə a swoŋə nɨ mə yu nɨ m̀fɔ̀ aa, à nɨ̂ ŋù àtɨ̀ɨ atu a mbo Kaisa.” ");
INSERT INTO bfd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato à yùꞌù mə̂ ma muù mɨ̀ghàà aa, ǹlɔgə Yesu m̀fɛꞌɛ ntswe nɨ̂ àlə̀ŋə nsaꞌa mɨ̀saꞌa a sàanə yìi mə bɨ lɛ nlɨ̀gə̀ nɨ̂ŋgɔꞌɔ, (a nɨ nɨ̀ghàà nɨ baHeber, bɨ twoŋə nɨ Gabbatha). ");
INSERT INTO bfd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","À lɛ sɨ bə maa noò aa a tɨgə̀ ŋ̀kuꞌu a ntɨ̀ɨ̂ àsìꞌìnə̀ m̀bɔŋ tâ àbɛ̀ɛ̀ fuꞌu a njwî Passa. Pilato a swoŋ a mbo bə̀ bya mə, “Mfɔ̀ ghùù wa à ghulà.” ");
INSERT INTO bfd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bo kuꞌùsə̀ ǹtɔŋnə swoŋ mə, “Zwitə yi, zwitə yi nlɔꞌɔsə̂, kwèèntə̀ yi a ati bàŋnə̀ bàŋnə̀!” Pilato a betə waa mə, “Nɨ lɔ̀ɔ mə tâ mə̀ kweentə mfɔ̀ ghùù a ati bàŋnə̀ bàŋnə̀ aa ɛ?” Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bɨ kwiꞌi ghu mbo mə, “M̀fɔ̀ yìi mə bìꞌì zi aa, à kɨ mbə aa tsiꞌì Kaisa.” ");
INSERT INTO bfd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilato a tɨgə̀ ǹlɔgə Yesu m̀fa a mbo bo mə tâ bɨ̀ kweentə yi a ati bàŋnə̀ bàŋnə̀. Maa ajàŋ bɨ tɨgə̀ ǹlɔgə Yesu ŋ̀ghɛɛ nɨ ghu. ");
INSERT INTO bfd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","À lɛ mfɛ̀ꞌɛ̀ m̀beꞌe ati bàŋnə̀ bàŋnə̂ yi ya yumbɔŋ ŋ̀ghɛɛ ŋkùꞌù a adɨgə yìi mə bɨ lɛ sɨ twoŋə nɨ̂ àkwɛɛ atu ŋû aa (a nɨ nɨ̀ghàà nɨ baHeber, bɨ twoŋə̀ nɨ Golgotha). ");
INSERT INTO bfd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bɨ tɨgə̀ ŋ̀kweentə yi a ati bàŋnə̀ bàŋnə̀ maa adɨgə bo bɨ̀ bə̀ bî mɔꞌɔ bi baà, ŋù yî mɔ̀ꞌɔ a tswê fàa mbɛ̀ɛ̀ laà, yì mɔ̀ꞌɔ a kɨ̂ ǹtswe fàa mbɛ̀ɛ̀ laà, Yesu a tɨgə̀ ǹtswe a tɨtɨ̀ɨ bo. ");
INSERT INTO bfd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato à lɛ ŋŋwàꞌànə̀ wa atu ati bàŋnə̀ bàŋnə̀ mə, “Yesu mu Nazareth, M̀fɔ̀ baYuda.” ");
INSERT INTO bfd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bə̀ bî ghàꞌàtə̀ bɨ lɛ ntwoŋə ma yuù àŋwàꞌànə̀ ǹloŋ mə àdɨgə̀ yìi mə bɨ lɛ ŋkwèèntə̀ Yesu ghu aa, kaa a lɛ ŋwaꞌà sàꞌà siꞌi a nlǒ a njɔ̀ꞌɔ̀ àlaꞌà. Bɨ lɛ ŋŋwàꞌànə̀ ma yuù aa nɨ nɨ̀ghàà nɨ baHeber, nɨ nì baRoma a bɔ̀ꞌɔ nɨ nì ba Grikia. ");
INSERT INTO bfd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bya bɨ swoŋ a mbo Pilato mə, “Tsuu ŋwàꞌànə̀ mə, ‘M̀fɔ̀ baYuda’ Bàŋnə ŋŋwàꞌànə̀ bə mə ‘À swǒŋ mə yu nɨ m̀fɔ̀ baYuda.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato a kwiꞌi mə, “Ànnù yìi mə mə̀ ŋwàꞌànə aa, mə̀ ŋwàꞌànə̀ mə̂!” ");
INSERT INTO bfd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nòò yìi mə bɨ̀sogyɛ̀ bya bɨ lɛ ŋkwèèntə̀ Yesu a ati bàŋnə̀ bàŋnə̀ aa, bɨ lɛ nlɔ̀gə ɨtsə̀ꞌə̀ ji nyatə mbɛ̀ɛ̀ ji nɨkwà, sogyɛ̀ yî m̀fùùrə̀ a lɔgə̀ m̀bɛ̀ɛ̀ yî m̀fùùrə̀ yì mɔ̀ꞌɔ a kɨ̂ ǹlɔgə mbɛ̀ɛ̀ yî mɔ̀ꞌɔ̂. Bo lɛ ŋkɨ nlɔgə mândaŋə atsə̀ꞌə̀ yî màꞌà ya mə bɨ lɛ mbaꞌa kaa adɨ̀gə̀ yìi mə bɨ yàtə̀ ghu kaa a waꞌà ghu tswê aa. ");
INSERT INTO bfd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bɨ̀sogyɛ̀ bya bɨ swoŋ nɨ̀ bò nɨ bo mə, “Kaa a sɨ̀ kuꞌùnə̀ mə tâ bìꞌinə̀ satə, bìꞌinə̀ tum ɨbìrə̀ ghu, nyə ŋû yìi mə à ka jɨ aà. A lɛ mfɛ̀ꞌɛ̀ lâlà aa mə tâ annù yii bɨ̀ lɛ ŋŋwàꞌànə a nɨ nɨ̀ghàà nɨ Nwî aa tâ à boontə ajàŋ yìi mə bɨ lɛ nswoŋ aa mə: ‘Bo lɛ nyàtə ɨtsèꞌə̂ ja a tɨtɨ̀ɨ bo, m̀maꞌa ɨbìrə̀ nɨ tɔ̀gə̀ ghà.’ ” ");
INSERT INTO bfd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bə bî mɔꞌɔ bɨ̀ lɛ ntəə nyontə a mbɛ̀ɛ̀ àti bàŋnə̀ bàŋnə Yesu; à lɛ mbə aa ǹdè yi, bo bɨ̀ muma bɨ̀ ǹdè yì yî màŋgyɛ̀, nɨ Mary, ŋ̀gwɛ Cleopas, a bɔ̀ꞌɔ bɨ̀ Mary Magdalene. ");
INSERT INTO bfd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu a yə ndè yì a bɔ̀ꞌɔ bɨ̀ ŋ̀gàŋyə̀gə̂nnù yì wa mə à lɛ ŋkɔ̀ŋ kɔŋ aa a ajàŋ mə bo lɛ ntəə ghu aà. Ǹtɨgə nswoŋ a mbo ndè yì mə, “Ǹdè, mû ghò yî m̀bâŋnə̀ à walà.” ");
INSERT INTO bfd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ŋ̀kɨ ntɨgə nswoŋ a mbo ŋ̀gàŋyə̀gə̂nnù yì wa mə, “Ǹdè ghò à walà.” Ǹlɔgɨnə maa nòò, ŋ̀gàŋyə̀gə̂nnù yì wa a tɨgə̀ ǹlɔgə yi, bo yu tɨgə̀ ǹtswe a ndùgə yu. ");
INSERT INTO bfd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma juù ɨ̀nnu ɨ tsyà mə̂, tsǒ mə Yesu à lɛ nzi mə ŋ̀gɔ̌ŋ ɨnnù tsɨ̀m ɨ mɛ̀ mə̂ aa, a ŋghɨ̀rə mə tâ nɨ̀ghàà nɨ Nwî nɨ̀ boontə, a swoŋ mə, “Ǹjì ŋ̀kǐ yaŋə nàâ.” ");
INSERT INTO bfd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Baꞌa yî mɔ̀ꞌɔ à lɛ ntəə ghu nɨ̂ ǹtsəꞌə̀ mɨ̀lùꞌù, bɨ lɔɔ̀ kûntsa nnɨŋ ghu, ǹsosə a atû ŋ̀kɨ̀ŋkàꞌà ŋ̀kɔꞌɔsə ghu aghoŋə ntsù. ");
INSERT INTO bfd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu a no mɨ̀lùꞌù mya, nswoŋ mə, “A mɛ̀ mə̂.” Ǹswyɛ atû yi, nnɨŋə azwì yi a mbo Nwì, ǹtsɨɨ. ");
INSERT INTO bfd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","BaYuda bɨ lɛ nlɔntə a mbo Pilato mə tâ à beentə tâ bo ghɛɛ mbəgɨtə mɨkaꞌa mɨ bə̂ bya bìi mə bɨ lɛ ŋkwèèntə̀ waa aa tǎ lɔ̀gə ɨkû jyaa jya wa ati bàŋnə̀ bàŋnə̀ ɨ sɨgɨsə. Bo lɛ mbetə maa ajàŋ aa nloŋ mə ǹjwi ya ɨ̀ lɛ mbə Friday, kaa bo waꞌà kɔ̀ŋə̀ nɨ mə tâ ɨ̀ku jya tâ ɨ̀ lo ntswe wa ati bàŋnə̀ bàŋnə̀ a njwîŋgɔ̀ŋə̀. Ǹloŋ mə ma yaà ǹjwîŋgɔ̀ŋ mə ɨ̀ lɛ sɨ zì aa, ɨ̀ lɛ naŋsə mbə yî làànlaa a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bɨ̀sogyɛ̀ bya bɨ lɛ ntɨgə ŋghɛɛ mbəgɨtə mɨkaꞌa mɨ ŋû ǹtsyàmbìì, ŋ̀kɨ mbu mbəgɨtə mî ŋû yì mɔ̀ꞌɔ wa yìi mə bɨ lɛ ŋkwèèntə̀ waa bo bɨ̀ Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lâ àjàŋ mə bɨ lɛ nzì a nu Yesu aa, bo lɛ nyə mə à tɛ̀ꞌɛ̀ mə̂ ŋ̀kwo yi, kaa ǹjiꞌì m̀bə̀gɨ̀tə mɨ̀kàꞌâ mi kaa ɨ waꞌà bù m̀bə. ");
INSERT INTO bfd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ŋ̀ù sogyɛ̀ wa yì mɔ̀ꞌɔ à lɛ nlɔ̀gə nɨkɔ̂ŋ ni nso m̀bɛ̀ɛ̀ ŋgeè Yesu ghu, ŋ̀kì bo bɨ̀ àləə ɨ burə̀ ŋ̀khənə nsɨgə mfɛꞌɛ ghu. ");
INSERT INTO bfd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ŋù wa yìi mə à lɛ nyə ma yuù ànnù a fɛꞌɛ̀ aa, à nɨ̂ àyəfə, ànnù yìi mə à lɛ nswoŋ aa à nɨ ànnù nɨ̂ŋkoŋə̀. A kɨ̂ ǹzi mə yu swoŋ aà ànnù nɨ̂ŋkoŋə̀. A swoŋə ma yuù ànnù aa mə mbə nɨ̀ kɨ̂ m̀bii.) ");
INSERT INTO bfd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bɨ lɛ ghɨ̀rə̀ ma la aa mə tâ nɨ̀ghàà nɨ Nwî tâ nɨ̀ boontə mə, “Kaa bɨ ka yǐ waꞌǎ akwɛɛ̀ yi yî tsu burə mbəbəgə.” ");
INSERT INTO bfd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nɨ̀ghàà nɨ Nwî nî mɔ̀ꞌɔ nɨ kɨ̂ ǹswoŋ mə, “Bə̀ ka yǐ kɨ tɛꞌɛ miꞌì myaa a nu yu wa yìi mə bɨ lɛ nsò aà.” ");
INSERT INTO bfd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma yû a tsyà mə̂, Joseph yìi mə à lɛ nlò a alaꞌa Arimathea, a betě Pilato mə mbə yu lɔgə̀ àku Yesu lɛ. (Joseph à lɛ mbə ŋgàŋnyə̀gə̂nnù Yesu yî mɔ̀ꞌɔ yìi mə à lɛ sɨ yòŋə̀ nìi bə alɔ̀ꞌɔ̀sə̀ ǹloŋ mə à lɛ sɨ bɔꞌɔ bɨ̂tà bɨ alaꞌa bɨ baYuda aà.) Pilato à lɛ mbeentə mə tâ à lɔgə aku Yesu. Joseph à tɨgə̀ ǹlɔgə ŋghɛ̀ɛ̀ nɨ yu. ");
INSERT INTO bfd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus wa yìi mə à lɛ ntɛꞌɛ ŋghɛɛ ŋghɛ̀ɛ̀ ǹyə Yesu nɨ̂tugə aa, à lɛ nyòŋə̀ Joseph bo yu ghɛɛ̀ wa nlɔ̀gə àku yi. Bo yu kà mə̂ aa ŋghɛɛ aa, ǹtugɨtə bɨ̂kilo bɨ mɨghurə mì lùmtə̀ mɨghum mi ntarə, mìi mə bɨ lɛ naŋsə nɨ̂ ǹjoo jì lùmtə̀ jî mɔꞌɔ jìi mə bɨ twoŋə nɨ məə̀ nɨ aloe aà. ");
INSERT INTO bfd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","M̀bâŋnə̀ ma jû ji baa, bo lɛ ŋghɛ̀ɛ̀ ǹlɔgə aku Yesu ǹlɨmtə nɨ̂ àtsə̀ꞌə̀ yî fùꞌù yî sɨgɨ̀nə̀ ŋ̀kɨ nɨŋ nɨ mɨ̀wurə mì lùmtə̀, nyoŋə a ajaŋ mə, a nɨ nɔ̀ŋsə̀ baYuda, bɨ lɛ sɨ naŋsə nɨ̂ àku ŋû m̀bɔŋ twiŋə aà. ");
INSERT INTO bfd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ŋ̀kya mɨ̂ntà mɨ ati yî mɔꞌɔ ɨ lɛ ntswe wa adɨgə mə bɨ lɛ nzwitə Yesu ghu aà. Nɨ̀syɛ̀ nî fii nǐ mɔꞌɔ nɨ lɛ ntswe wa mûm ŋ̀kya nìi mə kaa bɨ lɛ mburə tɨ ŋû ghu twiŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tsǒ mə àbɛ̀ɛ̀ à lɛ ntɨgə ntswe nɨ̂ m̀fuꞌu aa a njwîŋgɔ̀ŋ aa, ŋ̀kɨ nloŋ mə nɨ̀syɛ̀ nya nɨ lɛ ntswe ŋkoontə maa adɨgə aa, bɨ tɨgə̀ ǹtwiŋə Yesu ghu. ");
INSERT INTO bfd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","À lò mə̂ m̀bə tsiꞌǐ a tɨ̀tugə a mbàꞌa mbàꞌà a njwi yì ǹtsyambìì a mûm ŋ̀gyà, kaa ɨ̀dɨ̀gə̀ ɨ burə tɨ̀ naŋsə̀ ǹlaa, Mary Magdalene a ghɛɛ̀ wa a ntsù nɨsyɛ̀, ǹyə mə bɨ tìì mə alâŋsəŋgɔ̀ꞌɔ̀ ya yìi mə bɨ lɛ ŋkusə ntsù nɨsyɛ̀ wa ghu aa, nlɔ̀ꞌɔ̀sə̀. ");
INSERT INTO bfd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A khə̂ ŋghɛɛ nyə Simon Peta bo bɨ̀ ŋ̀gàŋyə̀gə̂nnù Yesu wa yìi mə à lɛ naŋsə ŋkɔŋ aa, ǹswoŋ a mbo bo mə, “Bɨ lɔ̀gə̀ mə̂ M̀màꞌàmbi wa mûm nɨ̀syɛ̀ ǹlɔꞌɔsə, kaa bìꞌì waꞌǎ adɨgə yìi mə bɨ ləə ghu aa zî.” ");
INSERT INTO bfd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peta nɨ ŋ̀gàŋyə̀gə̂nnù Yesu yî mɔ̀ꞌɔ wa bo yu ghɛ̀ɛ̀ wa ntsù nɨsyɛ̀. ");
INSERT INTO bfd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bo lɛ sɨ khə̀ bɨtsɨ̀mə̀, lâ ŋ̀gàŋyə̀gə̂nnù yì mɔ̀ꞌɔ wa à khə̂ ǹtsya Peta ŋ̀waŋsə ŋghɛ̀ɛ̀ ǹyweꞌe wa ntsù nɨsyɛ̀. ");
INSERT INTO bfd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ǹyəŋtə atû yi nlii mûm nɨ̀syɛ̀ ya ghu, ǹyə atsə̀ꞌə̀ yî fùꞌù ya yìi mə bɨ lɛ nlɨmtə Yesu ghu aa, lâ kaa ŋkɨꞌɨ̀ yi wa mûm nɨ̀syɛ̀ kuù. ");
INSERT INTO bfd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Peta a yoŋə̀ a njɨ̀m m̀burə ntsya ŋkuu wa mûm nɨ̀syɛ̀, ǹyə atsə̀ꞌə̀ yî fùꞌù ya yìi mə bɨ lɛ nlɨmtə nû yì ghu aà, ");
INSERT INTO bfd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","bo bɨ̀ àtsə̀ꞌə̀ ya yìi mə bɨ lɛ nlɨmtə atu Yesu ghu aà. Kaa a lɛ ŋwaꞌǎ a bɔ̀ꞌɔ ya yìi mə bɨ lɛ nlɨmtə mbɨ̀ɨ̀ nû yì ghu aa nɔ̀ŋə̀, bɨ lɛ ŋkərə nnɔŋsə tsiꞌǐ atu yu. ");
INSERT INTO bfd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ŋ̀gàŋyə̀gə̂nnù Yesu wa yìi à lɛ mfòò ŋ̀ghɛɛ nyweꞌe wa ntsù nɨsyɛ̀ aa, a kɨ̂ ŋ̀kuu ghu nyə, mbii. ");
INSERT INTO bfd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Kaa àtû yaa a lɛ mburə tɨ naŋsə̀ ǹlaa wa nɨ nɨ̀ghàà nɨ Nwî nya mə nɨ nswoŋə nɨ mə à ka yǐ bɨ̀ɨ̀nə̀ nɨ nɨ̀wô aà.) ");
INSERT INTO bfd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ŋ̀gǎŋyəgə̂nnù ji jya ɨ lɛ mbù ǹtɨgə mbɨɨ ŋghɛ̀ɛ̀ waa a ndùgə̀. ");
INSERT INTO bfd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary à lɛ ntəə wa ntsù nɨsyɛ̀ a a bɛɛ nyəꞌə, à kà mə̂ aa nyəꞌə aa, ǹyəŋtə atû yi ŋka nlii nɨ̂ mûn nɨ̀syɛ̀ ya ghu ");
INSERT INTO bfd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ǹyə baangel bi baa bɨ wɛꞌɛ̀ ɨ̀tsə̀ꞌə̀ jî fùꞌù ǹtswe wa adɨgə mə bɨ lɛ nɔ̀ŋsə̌ aku Yesu ghu aà, yì mɔ̀ꞌɔ a tswə̂ ghu atu, yì mɔ̀ꞌɔ a kɨ̂ ǹtswe ghu mɨkòrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A betə ghu mbo mə, “O yə̀ꞌə̀ aà à kə̀ lɛ mâŋgyɛ̀?” A kwiꞌi ghu mbo mə, “Bɨ lɔ̀gə̀ mə Ŋgàŋmàꞌâ ghà ŋ̀ghɛɛ nɨ ghu, kaa mə̀ waꞌǎ adɨgə yìi mə bɨ ləə ghu aa zî.” ");
INSERT INTO bfd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","À ghə̀ mə̂ mə yu kɨ karətə yi, ǹyə Yesu a təə maa mbɛ̀ɛ̀ kaa a waꞌà bàŋnə̀ ǹzi mə à nɨ Yesu. ");
INSERT INTO bfd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu a betə ghu mbo mə, “O yə̀ꞌə̀ aà à kə̀ ɛ mâŋgyɛ̀? O lɔ̀ɔ̀ aà wò ɛ?” A lɛ sɨ waꞌatə nɨ mə à laa mbə mbɔ̂ŋ ŋ̀kya wâ, ǹtɨgə ŋkwiꞌi ghu mbo mə, “Taà m̀bə a bə yìi mə ò lɔ̀ꞌɔ̀sə̀ mə̂ yi, ò dɨꞌɨ̀ àdɨ̀gə̀ yìi mə ò ləə yi ghu aa a mbo mə̀ tâ mə̀ ghɛɛ nlɔ̀gə̀ yi.” ");
INSERT INTO bfd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu a twoŋtə̀ yi mə, “Mary!” A karətə̀ yi ŋka nlii Yesu, ǹswoŋ nɨ nɨ̀ghàà nɨ baHeber mə, “Rabboni” (ǹjiꞌì nɨ̀ghàà ma nû ɨ bə mə “ǹdɨ̀ꞌɨ̀nnù”). ");
INSERT INTO bfd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu a swoŋ ghu mbo mə, “Tsùù gha lǒ mɔ̀ɔ̀ntə̀ bə̂, ǹloŋ mə kaa mə̀ burə tɨ bù m̀bɨɨ ŋghɛ̀ɛ̀ fu a mbɛ̀ɛ Taà. Lâ ghɛ̀ɛ a mbo bɨ̀lɨ̂m ba, ǹswoŋ a mbo bo mə, mə bù ŋ̀kɔꞌɔ ŋghɛɛ fu a mbo yu wa yìi mə à nɨ Taà ghà ŋ̀kɨ mbə Taà ghùù aà, m̀bə Nwîŋgɔ̀ŋ ghà ŋ̀kɨ mbə Nwîgɔ̀ŋ ghùù aà.” ");
INSERT INTO bfd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene à lɛ mbù ŋ̀ghɛɛ a mbo ŋ̀gǎŋyəgə̂nnù ji jya ǹswoŋ a mbo bo mə yu yə̀ mə Mmàꞌàmbî ŋ̀kɨ ŋkɛꞌɛnə ɨ̀nnù jya mə à lɛ nswoŋ ghu mbo aa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A bə a nɨ̀tugə maa njwî ǹtsyàmbìì, ŋ̀gǎŋyəgə̂nnù ji jya ɨ ghotə̀ a nda yì mɔ̀ꞌɔ, m̀fɨ̀ɨ abàꞌà ǹloŋ mə bo lɛ sɨ bɔꞌɔ bɨtà bɨ alaꞌa bɨ baYuda aà. Yesu a wiꞌìkə̀ ǹtəə a tɨtɨ̀ɨ bo nswoŋ a mbo bo mə, “M̀bɔɔnə a nu bù.” ");
INSERT INTO bfd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","À swòŋ mə̂ ma mùu ajàŋ aa, ndɨꞌɨ̀ m̀bô mi mya nɨ m̀bɛ̀ɛ̀ ŋ̀gee yì ya a mbo bo. Ŋ̀gǎŋyəgə̂nnù ji jya ɨ lɛ mburə nluu nɨ nɨ̀dorə a ajàŋ mə bo lɛ nyə Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu a kuꞌùsə̀ ǹswoŋ a mbo bo mə, “M̀bɔɔnə a nu bù. Àjàŋ mə Taà ghà à lɛ ntoo gha aa, mə kɨ ntoo ghuu.” ");
INSERT INTO bfd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","À swòŋ mə̂ ma mùu ajàŋ aa, m̀fəꞌə waa nɨ̂ àzwì ǹswoŋ mə, “Nɨ̀ kwɛrə Àzwì Nwî! ");
INSERT INTO bfd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","M̀bə nɨ̀ yi nlìꞌìnə ɨfansənnù ŋû boŋ baa kɨɨ lìꞌìnə̀, bɛɛ nɨ̀ tsuu lìꞌinə boŋ kaa baa waꞌà kɨ̀ ǹliꞌinə.” ");
INSERT INTO bfd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomas yìi mə à lɛ mbə ŋgàŋyə̀gə̂nnù Yesu wa yì mɔꞌɔ a tɨtɨ̀ɨ bya nɨ̀ghûm ǹtsò baa, bɨ kɨɨ̀ ǹtwoŋə nìi nɨ mu bɨ̀nwì aa, kaa à lɛ ŋwaꞌǎ atɨtɨ̀ɨ bo tswê wâ noò mə Yesu à lɛ nzì aà. ");
INSERT INTO bfd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ŋ̀gǎŋyəgə̂nnù Yesu jya jǐ mɔꞌɔ ɨ lɛ nswoŋ gho mbo mə, “Bìꞌì yə̀ mə Mmàꞌàmbî.” Thomas a kwiꞌi a mbo bo mə, “M̀bə mə̀ ghɨrə tsuu ɨbùꞌu mbɛɛ jya ghu mbo yə, ɨ tsuu bɨswɛbɨmbô ba wa nɨ̂ ɨ̀bùꞌu mbɛɛ mà jya kɨɨ nɨŋ, ɨ tsuu abô ya wa nɨ àbùꞌù ya a mbɛ̀ɛ̀ ŋ̀gee yu nɨŋ, kaa mə̀ waꞌà biì.” ");
INSERT INTO bfd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ŋ̀gyà ɨ̀ tsyà mə̂ yî m̀fùùrə̀ ŋ̀gǎŋyəgə̂nnù ji jya ɨ bû ǹtswe a mûm ǹda ntsetə abàꞌà, Thomas a kɨ̂ ǹtswe a tɨtɨ̀ɨ bo. Bɨ lɛ mfɨ̀ɨ abàꞌà. Lâ Yesu a wiꞌìkə̀ ǹtəə a tɨtɨ̀ɨ bo nswoŋ mə, “M̀bɔɔnə a nu bù.” ");
INSERT INTO bfd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ǹtɨgə nswoŋ a mbo Thomas mə, “Nɨŋə muswɛ̂bô ghò falà, ŋ̀kɨ naŋsə nlentə mbô mâ! Kɨ nàsə abô yo nnɨŋ fàa mbɛ̀ɛ̀ ŋ̀gee mə̀. Kɛntə nlɨ̀gɨ̀tə̂ ànnù yo yâ, m̀biì.” ");
INSERT INTO bfd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas a swoŋ ghu mbo mə, “M̀màꞌàmbî nɨ Nwìŋgɔ̀ŋ ghà.” ");
INSERT INTO bfd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu a betə̀ ghu mbo mə, “Tɨgə ò bìì aa nloŋ mə ò yə gha aà? M̀bɔɔnə a mbo bə̀ bìi mə bɨ bii tɨ yə̂ gha aa.” ");
INSERT INTO bfd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu à lɛ ŋghɨ̀rə ɨlènsə̀ jî mɔꞌɔ jì ghàꞌàtə a nsi ŋgǎŋyəgə̂nnù ji, jìi mə kaa bɨ sɨ̀ fàa mum yulà àŋwàꞌànə̀ ŋwaꞌànə̀. ");
INSERT INTO bfd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lâ bɨ ŋwaꞌanə julà ɨ̀nnù aa mə tâ nɨ̀ bii mə Yesu à nɨ Àyɔꞌɔ̀ Nwì, m̀bə Mu Nwì tǎ tsyǎ a njɨ̌m ajàŋ yìi mə nɨ̀ bìi yi aa ɨ tswe nɨ ǹtswêntɨ̀ɨ̀ nɨ̂ ɨ̀kǔm yi. ");
INSERT INTO bfd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma yû ànnù a kà mə̂ aa ntsya, a bû ǹdɨꞌɨ ɨbɨɨnû yi a mbo ŋ̀gǎŋyəgə̂nnù ji jî mɔꞌɔ a mbɛ̀ɛ̀ ŋ̀kì mɨyaa Tiberias. À lɛ ndɨꞌɨ yi aa lalà. ");
INSERT INTO bfd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peta, Thomas yìi mə à lɛ mbə nɨmfaꞌa aa, bo bɨ̀ Nathanael, yìi mə à lɛ nlo a Cana a mbùꞌu Galilea aa, bɔɔ bɨ Zebedee, nɨ ŋgǎŋyəgə̂nnù ji ji baa, bɨ lɛ mbòòntə̀ ǹtswe a adɨgə yî fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peta a swoŋ a mbo bo mə, “Mə̀ ka ghɛ̀ɛ̀ gha a ŋkô m̀bwɛ̀.” Bo bɨ̀tsɨ̀m kɨ̂ ǹswoŋ mə, “Bìꞌì ka yòŋə̀ gho tâ bìꞌinə̀ ghɛɛ.” Bo lɛ ntɨgə ŋkuu abaŋ ŋghɛ̀ɛ̀. Bo ghɛ̀ɛ̀ mə̂ aa, nlɛ nlə nlə nɨ̂tugə wa tsiꞌì tsɨ̀m kaa waꞌǎ fɨbwɛ̀ kô. ");
INSERT INTO bfd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Àbɛ̀ɛ̀ a kà mə̂ aa mfuꞌu, Yesu a zî ǹtəə a ghəŋə ŋkì; la kaa ŋgǎŋyəgə̂nnù ji jya kaa ɨ waꞌà zi mə à bə aa Yesu mə à təə wa aghəŋə ŋkì. ");
INSERT INTO bfd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu a swoŋ a mbo bo mə, “Bɔɔ̀ bâ, nɨ̀ kò mə mbwɛ̀ mî tsu aa ɛ?” Bo kwiꞌi mə, “Ŋ̀gaŋ.” ");
INSERT INTO bfd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu a swoŋ a mbo bo mə, “Nɨ̀ maꞌa ambunjyâ yuu ya a mbɛ̀ɛ̀ àbômàꞌà, bəə boŋ nɨ̀ ka ko mbwɛ̀.” Bo lɛ mmàꞌà, m̀bwɛ̀ kuu nluu ghu, bo tɨgə̀ ǹswuŋə kɨkaŋ. ");
INSERT INTO bfd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ŋ̀gàŋyə̀gə̂nnù Yesu wa mə à lɛ ŋkɔ̀ŋ yi ŋkɔŋə aa, a swoŋə a mbo Peta mə, “À nɨ̂ M̀màꞌàmbî!” Simon Peta à yùꞌù mə mə à nɨ̂ M̀màꞌambi aa, ŋ̀wɛꞌɛ atsə̀ꞌə̂ yi yî màꞌà (ǹloŋ mə à lɛ sɨ bə aa a tsɔꞌɔ, wa noò mə à lɛ sɨ fàꞌà aà), ǹnaŋ wa mûm ŋ̀kì. ");
INSERT INTO bfd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ŋ̀gǎŋyəgə̂nnù Yesu jî mɔꞌɔ jya ɨ lɛ ntɨgə ntii àkànuꞌu ya, ŋkɨ nswuŋə ambunjya ya yìi mə mbwɛ̀ mya lɛ nluu ghu aa, nzi a mbɛ̀ɛ̀ àghəŋə ŋkì. À tɨ bə aa kaa àghaꞌa aghənə ŋkì a lɛ ŋwaꞌà bù nsaꞌa, a lɛ mbə aa tsiꞌì tsǒ bɨ̀metre ŋkhɨ̀ yî fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bô fɛ̀ꞌɛ̀ mə̀ wa aghəŋə ŋkì, ǹyə mɔꞌɔ, ɨ ghəꞌə̀, m̀bwɛ̀ bo bɨ̀ àbaa nɔ̂ŋtə̀ wa nɨ mɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu a swoŋ a mbo bo mə, “Nɨ̀ zi nɨ̂ m̀bwɛ̀ mya mǐ mɔꞌɔ mə nɨ̀ ko tsɨ̂tsə̀ŋə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peta a ghɛɛ̀ ŋ̀kuu wa a mûm àkànuꞌu, ǹswuŋə ambunjya ya ŋkɔꞌɔsə a ntaꞌa, m̀bwɛ̀ mî fàŋkə̀ luu ghu, m̀bə ŋkhɨ̀ yî mɔꞌɔ nɨ mɨ̀ghum mi ntaà ǹtsò tarə̀. Ka mə m̀bwɛ̀ mya lɛ nluu wa mûm àmbunjya aa kaa a lɛ ŋwaꞌà sàꞌàkə̀. ");
INSERT INTO bfd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu a swoŋ a mbo bo mə, “Nɨ̀ zi mfàꞌàtə ntsû ghuu.” Kaa ŋù nɨ̀ bò a lɛ waꞌà yi betə̀ mə, “Ò bə aà wò aa ɛ?” Ǹloŋ mə bo bɨtsɨ̀m lɛ nzi mə à nɨ̂ M̀màꞌàmbi aà. ");
INSERT INTO bfd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu à lɛ ntɨgə nlɔgə abaa ya bô m̀bwɛ̀ mya mfa a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ma mùu noò, à lɛ mbə aa ŋgàà yìi ɨ̀ yweꞌe ji tarə aa, nlɔgɨnə ajàŋ mə Yesu à lɛ nyweenə nɨwo aa, mə à lɛ ndɨ̀ꞌɨ ɨbɨɨnû yi a mbô ŋ̀gǎŋyəgə̂nnù ji. ");
INSERT INTO bfd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nòò yìi mə bo lɛ mmàŋsə a mfàꞌàtə̂ ǹtsû waa aa Yesu a swoŋ a mbo Simon Peta mə, “Simon, mu Jɔn, ò kɔ̀ŋə gha ntsyàtə̀ bə̂ buà bɨtsɨ̀m faà aa ɛ?” A kwiꞌi mə, “Ɨ̀ɨ̀ŋə, M̀màꞌàmbî, ò zi mə mə̀ kɔ̀ŋə ghô.” Yesu a swoŋ ghu mbo mə, “Ka njɛꞌɛ bɔɔ bɨ mbinjə̀rə̂ jâ.” ");
INSERT INTO bfd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu a bû ǹswoŋ ghu mbo a nɨ̂ ŋ̀gàà yìi ɨ̀ ywèꞌe ji baa aa, mə, “Simon, mu Jɔn, ò kɔ̀ŋə gha aa ɛ?” A kwiꞌi mə, “Ɨ̀ɨ̀ŋə, M̀màꞌàmbî, ò zi mə mə̀ kɔ̀ŋə ghô.” Yesu a swoŋ ghu mbo mə, “Ka mbɛ bɔɔ bɨ mbinjə̀rə̂ jâ.” ");
INSERT INTO bfd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu a bû ǹswoŋ ghu mbo ŋgaa yìi mə ɨ̀ ywèꞌe ji tarə aa, mə, “Simon, mu Jɔn, ò kɔ̀ŋə gha aa ɛ?” Peta à lɛ njəŋnə nloŋ mə à lɛ mbetə yi nyweꞌe ŋgaa ji tarə mə, “Ò kɔ̀ŋə gha aa ɛ?” Ǹtɨgə nswoŋ ghu mbo mə, “M̀màꞌàmbî, ò zî ɨ̀nnù tsiꞌì tsɨ̀mə̀; ò zi mə mə̀ kɔ̀ŋə ghô.” Yesu a swoŋ ghu mbo mə, “Ka njɛꞌɛ mbinjə̀rə̂ jâ. ");
INSERT INTO bfd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mə̀ swòŋə a mbo wò tsiꞌǐ annù nɨ̂koŋ mə nòò yìi mə ò lɛ mburə mûŋgwàꞌà aa, ò lɛ sɨ wɛꞌɛ nɨ̂ ɨ̀tsəꞌə̂ jo, ǹtaŋtə nɨ̂ nû yò, m̀bɨɨnə ŋghɛ̀ɛ̀ nɨ adɨgə yìi mə ò kɔ̀ŋə aa; la nòò yìi mə ò ka yǐ lwènə̀ aa, ò ka yì kɨ nàsə mbô mo tâ ŋù dàŋ à tɨgə ŋwɛꞌɛ nɨ̂ ɨ̀tsə̀ꞌə̀ a nu wò, ǹlɔgə nɨ̂ gho ŋghɛ̀ɛ̀ nɨ ghu a adɨgə yìi mə kaa ò sɨ̀ kɔŋə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesu à lɛ swoŋ ma yû ànnù m̀fɨgɨtə aa m̀buù nɨ̀wo yìi mə Peta à ka yǐ kwo ghu a ŋghɨ̀rə mə tâ Nwì à kwɛrə nɨghaꞌa ghu.) Yesu a tɨgə̀ m̀bu nswoŋ ghu mbo mə, “Ka nyòŋə̀ nɨ̂ ghâ!” ");
INSERT INTO bfd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peta a karəkə̀ yi, nyə ŋgàŋyəgə̂nnù Yesu yî mɔ̀ꞌɔ wa, wa yìi mə à lɛ ŋkɔ̀ŋə̀ yi aa, tsiꞌì wa yìi mə à lɛ nyəgɨtə a ntsǔntɨɨ Yesu, wa noò mə bo lɛ sɨ jɨ mɨjɨ mɨ Pasa mi nlwìꞌì ǹjɨ̀m mya mbetə mə, “M̀màꞌàmbî, ŋù yìi mə à ka fèè gho aa, à nɨ̂ wò aà?.” ");
INSERT INTO bfd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peta à yə̀ mə̂ yi aa, mbetə Yesu mə, “M̀màꞌàmbî, ànnù ghuà ŋù a ka yǐ bə aa mə akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu a kwiꞌi ghu mbo mə, “M̀bə mə̀ kɔŋ mə tâ à tswe ntɨ̀ɨ̀, ǹyweꞌe a noò yìi mə mə̀ ka yǐ bǔ bɨɨ aa, boŋ ma ya a yə gho aa nɨ̀ àkə̀ aa ɛ? Ka nyòŋə̀ nɨ̂ ghâ!” ");
INSERT INTO bfd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ma mùu ajàŋ, ŋ̀gǎŋyəgə̂nnù Yesu jya ɨ lɛ ntɨgə nlaansə nɨ̂ a tɨtɨ̀ɨ bɔɔ bɨ Kristo nɨ mə kaa ŋgàŋyə̀gə̂nnù Yesu ma ghû kaa à ka yǐ waꞌà bù ŋ̀kwo. La kaa Yesu kaa à lɛ ŋwaꞌà swoŋ aa mə kaa à ka yǐ waꞌà kwô; à lɛ mbàŋnə̀ ǹswoŋ aa mə, “M̀bə mə̀ kɔŋ mə tâ à tswe ntɨ̀ɨ̀ ǹyweꞌe a noò yìi mə mə̀ ka yǐ bǔ bɨ̀ɨ̀ aa, ma ya a yə̂ gho aa nɨ̀ àkə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ŋ̀gàŋyə̀gə̂nnù Yesu ma ghû à nɨ yu yìi mə à lɛ nswoŋ ɨnnù ma jû tsǒ àyəfə, ŋ̀kɨ ŋŋwaꞌanə aà; bìꞌì kɨ mbii mə ɨ̀nnù ma jû mə à lɛ nswoŋə aa, à nɨ̂ ànnù nɨ̂koŋə̀. ");
INSERT INTO bfd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu à lɛ mbù ŋ̀ghɨrə ɨnnù jî ghàꞌàtə̀ jìi mə bɨ lɛ mbaa kɨ lɔ̀ɔ̀ a ŋŋwàꞌànə tsiꞌì tsɨ̀m, boŋ kaa mə̀ sɨ̀ mɔɔ̀ntə mə mbə m̀bi yǔ ntsɨ̀m ɨ ghaꞌa ŋkùꞌùnə a ŋkuu ŋ̀ŋwàꞌànə̀ ma jya ghu.");
INSERT INTO bfd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Taà Theophilus, a nɨ àŋwàꞌànə̀ yî ǹtsyàmbìì ya mə mə̀ kɨ̀ lɛ ŋŋwàꞌànə̀ a mbo wò aa, mə̀ lɛ nswoŋə ɨnnù tsɨ̀m jìi mə Yesu à lɛ ŋghɨ̀rə̀ ŋ̀kɨ ndɨꞌɨ, ǹlɔgɨnə a noò yìi mə à lɛ mbèꞌènə̀ àfàꞌâ yi ghu aa, ");
INSERT INTO bfd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ŋ̀kɔꞌɔ yweꞌe a noò yìi mə Nwì à lɛ lɔ̀gə̀ yi ŋkɔꞌɔ ghɛɛ nɨ ghu a aburə aà. M̀bɔŋ tâ Yesu tâ à kɔꞌɔ ŋghɛɛ a aburə, à lɛ ndɨꞌɨtə ŋgǎŋtoò ji jya mə à lɛ ntsɔꞌɔ aa nɨ̂ Azwì Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nòò wa mə bɨ lɛ ndɨ̌ ŋgɨꞌɨ ghu nu, a kwo mbù ǹyweenə nɨ nɨ̀wo aa, à lɛ mbù ǹtswe fàa atu nsyɛ njwi mɨ̀ghum mi nɨkwà, ǹdɨꞌɨ ɨbɨ̀ɨnû yì a mbo bo ŋgaa jî ghàꞌàtə̀ nɨ mânjì yìi mə kaa m̀bə bɨ waꞌà manə mə yu lɛ ntswe ntɨ̀ɨ̀. Bo lɛ nyə yi a nɨ̂ ŋgàà jî ghàꞌàtə̀ ma jû aa, a swoŋə̂ nɨ̂ ɨ̀nnù a mbo bo nloŋ annù nɨfɔ̀ Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma mùu noò yìi mə bo bo lɛ ntswe aa, a swoŋ a mbo bo ŋ̀kwantə mə, “Tâ nɨ̀ tsuu Yerusalem lo màꞌàtə̀ bə̂. Nɨ̀ tswe ghu ŋka nyuꞌutə nɨ̂ àyoo ya yìi mə mə̀ lɛ nswoŋ a mbo bu mə Taà à lɛ ŋkàꞌà mə yu ka fa a mbo bu aà. ");
INSERT INTO bfd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jɔn à lɛ sɨ murə nɨ̂ bə̂ aa a mûm ŋ̀kì, lâ a njɨ̌m njwi jì tsu, Nwì à ka bàŋnə murə ghu aa bə a mûm Àzwì Nwî.” ");
INSERT INTO bfd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesu bo bɨ̀ ŋ̀gǎŋntoò ji jya le mbòòntə̀ ǹtswe a adɨgə yî fùùrə̀. Bo bo tswè mə̂ aa, bo betə ghu mbo mə, “M̀màꞌàmbî à ka yǐ bə aa ma mùu noò m̀bɔŋ tâ ò bu mbènsə annù nɨfɔ̀ baIsrael a mbo bo tǎ tâ bo ka nsaꞌa nɨ̂ m̀bi yù aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu a kwiꞌi a mbo bo mə, “Kaa à sɨ adɨgə yuu bə̂ a nzi noò kə̌ njwi yìi mə a lə̀ə bə Taà ghà nɨ̂ àdàꞌǎ yi aà. ");
INSERT INTO bfd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lâ nɨ̀ ka kwɛrə mɨdaꞌa a noo yìi mə Àzwì Nwî a sɨgə ŋkuu a nu bù aà. Tâ nɨ̀ tɨgə bə bɨ̂yəfə ba a Yeresalem, nɨ a abùꞌu Yudea tsɨ̀m bo bɨ a Samaria, nlo ghu ŋghɛɛ a mbî ǹtsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu à swòŋ mə̂ ma mùu ajàŋ, Nwì a ghɨrə̂ a tɨgə̀ ŋ̀kɔꞌɔ ghɛɛ nìi a aburə, ŋ̀gǎŋntoò ji jya təə ntɨgə nlii, m̀bàꞌà ɨ tɨgə̀ ǹlogə yi a ghɛɛ̀ m̀bwɛ a miꞌi bo. ");
INSERT INTO bfd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bo tɨgə̀ ǹtəə wa adɨgə ǹtɨgə nlii nɨ aburə, a ajaŋ yìi mə a kɔꞌɔ ghɛɛ aà. Bo kà mə̂ aa nlii aa, bə̀ bî mɔꞌɔ bi baa bɨ zî ǹtəə a mbɛ̀ɛ bo ŋwɛꞌɛ ɨtsə̀ꞌə̀ jî fùꞌù, ");
INSERT INTO bfd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","m̀bètə waa mə “Bə̀ bɨ Galilea, nɨ̀ təə faà ǹlii nɨ̂ àburə aa a ya aa ɛ? Yesu ma ghû mə bɨ lɔgə ŋkɔꞌɔ ŋghɛɛ nɨ ghu a aburə aa, à ka yi bu bɨ̀ɨ̀ tsiꞌì ma mùu ajàŋ mə nɨ̀ yə a kɔꞌɔ ghɛ̀ɛ̀ a aburə aà.” ");
INSERT INTO bfd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bo lɛ ntɨgə nlo wa ntaꞌa Olives m̀bu mbɨ̀ɨ̀ fu a Yeresalem, a nlo ghu ŋghɛɛ nyweꞌe a Yeresalem a bə tsǒ kilo metre yî m̀fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bo bɨ̀ɨ̀ mə̂ ŋ̀kuu a Yeresalem, ŋ̀kɔꞌɔ ghɛɛ wa njaꞌà ǹdâ nɨ̀kàŋ a ǹdəŋ wa adɨgə yìi mə bo lɛ sɨ tswe ghu aà. Bo ma bû lɛ mbə aa Peta nɨ Jɔn nɨ Jɛms nɨ Andrea, Philip nɨ Thomas, Bartolomeo nɨ Mateo, Jɛms mu Alfeus nɨ Simon yìi mə bɨ lɛ sɨ kɨɨ ntwoŋə nɨ Zealot aa, nɨ Judas mu Jɛms. ");
INSERT INTO bfd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bo ma bû bɨ tsɨ̀m bo lɛ mbòònsə̀ waa mbii bɨtsɨ̀m mə bo ka kɨ tsàꞌàtə̀ nɨ̂ Nwî kaa waꞌà Kaà, bo bo nɨ bàŋgyɛ̀ bya mə bɨ lɛ sɨ yòŋə̀ nɨ njɨ̌m Yesu aa, a bɔ̀ꞌɔ Mary, ǹdè bɨ̀ Yesu, nɨ bɔɔ bɨ ma bɨ Yesu bî m̀bàŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma mùu noò ŋ̀gǎŋmbii Kristo tsǒ ŋ̀khɨ̀ nɨ mɨ̀ghum mimbaa, bo lɛ ŋghotə waa ntswe a adɨgə yî fùùrə̀, bo ghòtə̀ mə̂ waa ntswe aa, Peta a təə̀ a ǹdəŋ ǹswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bɔɔ bɨ maà, ànnù yìi mə àŋwàꞌànə̀ Nwî a swoŋə aa, a lɛ ntswe nɨ̂ m̀fɛ̀ꞌɛ mbòòntə̂ tsiꞌì a ajaŋ yìi mə Àzwì Nwî a lɛ nswoŋ, m̀bɔŋ tâ à fɛꞌɛ, a mbo David mə tâ à swoŋ ǹloŋ Judas Iskariot yìi mə à lɛ ŋghɛ̀ɛ̀ ǹdɨꞌɨ Yesu a mbo bə̀ bya mə bɨ lɛ ntswa yi aà. ");
INSERT INTO bfd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas yumbɔŋ à lɛ mbə ŋǔ yì mɔ̀ꞌɔ a tɨtɨ̀ɨ bìꞌinə̀, ǹloŋ mə bɨ lɛ ntsɔꞌɔ yi mə tâ bìꞌinə̀ nɨ̀ bo ka mfaꞌa aà. ");
INSERT INTO bfd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas à lɛ nlɔ̀gə ŋkabə ya yìi mə à lɛ ŋkwɛrə nloŋə annù yî bɨ yìi mə à lɛ ŋghɨ̀rə̀ aa, ŋ̀ghɛ̀ɛ̀ ǹyuu adɨgə nsyɛ ghu. À lɛ wò nɨ mɨ̀tumfuꞌu ma mùu adɨgə, àtòꞌô yi a bwinə̀ a tɨtɨ̀ɨ̀, mɨ̀tô mi mɨ̂tsɨ̀m mɨ zwu mfɛ̀ꞌɛ̀kə̀. ");
INSERT INTO bfd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntswe a Yerusalem aà bɨ lɛ nyuꞌu annù ma yû, ǹtɨ̀gə mfa ɨkum adɨgə ma ya nɨ nɨ̀ghàà nɨ alàꞌà nyaa nɨ Akeldama, ma la bə mə, Àdɨ̀gənsyɛ̌ Àlə̀ə). ");
INSERT INTO bfd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","A fɛꞌɛ̀ ma mùu ajaŋ aa nloŋ mə bɨ lɛ ŋŋwàꞌànə̀ a mûm àŋwàꞌànə̀ bɨ̂ Psalms mə, ‘Tâ ǹdùgə̂ yì tâ ɨ̀ təə ŋɛꞌɛ, tâ ŋù tsù tâ tsuu ghu yǐ lǒ kɨ tswe bə̂.’ Bɨ kɨ̂ m̀bu ŋŋwàꞌànə̀ ghu mə, ‘Tâ ŋù dàŋə̀ à lɔgə adɨgə afàꞌâ yi.’ ");
INSERT INTO bfd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ma mùu ajàŋ, a kuꞌunə mə tâ bìꞌinə̀ tsɔꞌɔ ŋù yì mɔꞌɔ yìi mə à kɨ̀ tswe biꞌinə̀ nɨ̀ bò a ŋgɔ̀ŋ bɨ̀nòò bɨ̂tsɨ̀m mə M̀màꞌàmbi Yesu à kɨ̀ sɨ fɛ̀ꞌɛ̀ ŋ̀karə ŋghɛɛ mbù m̀bɨɨ nɨ̂ tɨtɨ̀ɨ bìꞌinə̀ fàa atu nsyɛ aa, ");
INSERT INTO bfd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ǹlɔgɨnə nɨ nòò wa mə Jɔn à lɛ sɨ murə nɨ̂ bə̂ a ŋkì aa, ŋ̀ghɛɛ nyweꞌe nɨ noò wa yìi mə bɨ lɛ nlɔ̀gə̀ Yesu ŋ̀kɔꞌɔ ŋghɛɛ nɨ ghu a aburə aà. Ŋù ma ghû à ka kɨɨ bə àyəfə, tsǒ bìꞌinə̀, kɨ swoŋ nɨ a mbo bə̌ ajàŋ yìi mə Yesu à lɛ nyweenə nɨ nɨ̀wo aà.” ");
INSERT INTO bfd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bo lɛ ndɨ̀ꞌɨ̀ bə̂ bi baa, Joseph yìi mə bɨ lɛ sɨ twoŋə nɨ Barsabas, ɨ̀kǔm yi yî mɔꞌɔ ɨ kɨ̂ m̀bə Justus aa, bo Matias. ");
INSERT INTO bfd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bo lɛ ntɨgə ntsaꞌatə Nwî nswoŋ mə, “M̀màꞌàmbî, wò yìi mə ò zi mɨ̂ntɨɨ mɨ bə̂ bɨ̀tsɨ̀m aa, tɨgə mfɨ̀gɨ̀tə̀ ŋû yìi mə ò tsɔ̀ꞌɔ aa, fàa tɨtɨ̀ɨ bə̀ bua bi baa ");
INSERT INTO bfd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mə tâ à lɔgə adɨgə afàꞌa ŋgǎŋntoo Kristo, yìi mə Judas à lɛ mmàꞌàtə̀ a ŋghɛɛ a adɨgə yìi mə yu kɔŋə aa.” ");
INSERT INTO bfd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bo tsàꞌàtə̀ mə̂ Nwɨ̀ laa, ntɨgə mmaꞌa ɨbìrə̀ a ntsɔꞌɔ ŋù yìi mə à nɨ ghu aa, wa tɨtɨ̀ɨ bə̀ bya bi baà. Ŋù yìi mə bɨ lɛ ntsɔꞌɔ aa à lɛ mbə Matias. Bɨ tɨgə̀ nlɔgə yi nnɨŋ mə tâ à tɨgə mbə ŋû yî mɔꞌɔ wa tɨtɨ̀ɨ ŋgǎŋntoo jya nɨ̀ghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ǹjwî Pentekost ɨ̀ kùꞌù mə̂, ŋgǎŋmbii Kristo jya ɨ ghotə̀ waa ntswe tsiꞌì àdɨ̀gə̀ yî fùùrə̀. ");
INSERT INTO bfd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bô tswè mə̂, ŋ̀ghəə kɨ yə, àyoò tsu a juꞌù a nɨkàŋ ŋ̀koo tsǒ àfìsə̀ yî wè yìi mə a tsyà aa, ǹzi ŋkuu nlwensə nda ya mə bo lɛ ntswe ghu aa tsiꞌì ntsɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bo yə̂ ǹjoo jǐ mɔꞌɔ ɨ zî m̀bə tsǒ ǹlwà mɔꞌɔ, ǹkɨrə tsǒ ɨ̀ləə; ɨ yâtə̀ waa ŋghɛɛ ntəəntə a nu bo yî mɔ̀ꞌɔ yɨ̂ mɔ̀ꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Àzwì Nwî a lɛ ŋkuu nluu a nu bo bɨtsɨ̀m; bo tɨgə nlɔgɨnə ŋka ghaa mɨghàà mɨ ɨtoo jǐ dàŋ, ǹyoŋə nɨ ajaŋ yìi mə Àzwi Nwî a lɛ ndɨ̀ꞌɨ̀ a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","BaYuda bìi mə bɨ lɛ sɨ bɔꞌɔ nɨ̂ Nwi aa, bo lɛ nlò a ɨtoò tsɨ̀m fàa m̀bi ǹzi ǹtɨgə ntswe a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bo yùꞌù mə̂ ǹjì ayoo ya a ajaŋ yìi mə a lɛ sɨ jùꞌù aà, ǹnɔ̀ɔ̀ bə̂ bî ghàꞌà ghaꞌa zî ŋ̀ghotə, ànnu a tsyâ waa ǹloŋ mə ŋù ǹtsɨ̀m yìi mə à lɛ ntswe ghu aa à lɛ nyuꞌu ŋgǎŋmbii Kristo jya ɨ ghaà nɨ nɨ̀ghàà nɨ alaꞌà nyaa. ");
INSERT INTO bfd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ànnù a lɛ ntsyà waa, a kɨ̂ m̀burə mbə tsiꞌì ànnù yî yɛ̌yɛrə a mbo bo, bo tɨgə̀ m̀betə nɨ mə, “bə̀ buà bɨ tsɨ̀m mə bɨ ghàà laà aa bɨ sɨ̀ aa baGalilea bə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A tɨgə̀ ǹtsya aa la ŋù ǹtsɨ̀m a tɨtɨ̀ɨ bìꞌinə̀ a yuꞌù nɨ̀ waa bo ghàà nɨ nɨ̀ghàà nɨ alaꞌà nyaa aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bìꞌinə̀ lo aa a ɨtoo ɨtoò, a Partia, Media, ŋ̀kɨ lo a Elam; ǹlo a Mesopotamia, a Yudea, bo bɨ a Kapadosia; ǹlo a Pontus nɨ Asia; ");
INSERT INTO bfd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","a Frigia nɨ Pamfilia, a Egipto, ǹlo a ɨdɨgə jî mɔꞌɔ a Libya, a mbɛ̀ɛ Cyrene, bìꞌinə̀ bî mɔꞌɔ bɨ lô a Roma, ");
INSERT INTO bfd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","baYuda bo bɨ bìi mə bo kwensə annùnwi yaa ǹtɨgə bə baYuda; bìꞌinə̀ bî mɔꞌɔ bɨ lô a Kreta bo bɨ a Arabia, lâ bìꞌinə̀ yuꞌù bo ghaà nɨ mɨ̀ghàà mɨ ɨlaꞌa miꞌinə̀, ǹswoŋə nɨ̂ ɨ̀nnù jî wè jìi mə Nwì a fàꞌà aà.” ");
INSERT INTO bfd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ànnù lɛ ntsyà waa bɨ̂tsɨ̀m, ɨ̀tû jyaa ɨ buùrə̀, bo tɨgə̀ m̀betə nɨ̂ waa bo nɨ bo mə, “Ma yuù ànnù a bə àa mə akə?” ");
INSERT INTO bfd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lâ bə̀ bî mɔꞌɔ a tɨtɨ̀ɨ bo bɨ bâŋnə̀ ŋ̀ka ŋwyɛ nɨ̂ waa, ǹswoŋə nɨ mə, “Bo no aa mɨ̀lùꞌù mî fii siꞌi siꞌi, mɨ tɨgə̀ ŋ̀kɔꞌɔ nɨ atu bo.” ");
INSERT INTO bfd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bə̀ byâ kà mə̂ aa ŋghaa laà, Peta a təə a ǹdəŋ bo bɨ̀ ǹgǎǹntoo jǐ mɔꞌɔ jya nɨ̀ghûm ǹtsò mɔꞌɔ, ŋ̀ŋɛntə njì yì a ndəŋ ŋ̀ghaa a mbo bo nswoŋ mə, “Bù baYuda bo bɨ̀ bù bə̀ bɨ̀tsɨ̀m bìi mə nɨ tswe a Yerusalem, naŋsə nyuꞌutə nɨ̀ tâ mà tɔꞌɔtə annu yìi mə a tswe ghu aa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kaa bə̀ buà kaa bo sɨ aa mɨ̀lùꞌù baanə̀, a ajàŋ yìi mə nɨ waꞌatə aà, ǹloŋ mə à nɨ aa tsiꞌì bɨ̀nòò bi nɨbùꞌu tsɨtsɔ̀ŋə̀. ");
INSERT INTO bfd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tâ nɨ̀ yuꞌu ànnù yìi mə ŋ̀gàŋtoò Nwì Yoel à lɛ nswoŋ nloŋ annù ma yû aà, ");
INSERT INTO bfd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nwì à swoŋ mə, à ka yǐ bə a noò ǹjɨ̀m tâ mə̀ swiꞌi Àzwi ya a nu bə̀ bɨ̀tsɨ̀m. Bɔɔ buu bi mbâŋnə̀ bo bɨ̀ bì bâŋgyɛ̀ tâ bo ka nswoŋ nɨ̂ ɨ̀nnù jìi mə mə̀ ka yǐ kɨ nɨŋə nɨ a ntɨɨ bo aà, tâ ǹjə̀ə̀ təə təə tâ ɨ̀ ka nlɛ nɨ̂ bɔɔ ŋgwaꞌa buu, tâ ǹjə̀ə̀ tâ ɨ̀ ka nlɛ nɨ̂ bɨ̂lɨ̀ɨ̂ buu ");
INSERT INTO bfd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɨ̀ɨ̀ŋə, wa mə̀ ka yǐ swìꞌi Àzwǐ ya a nu ɨ̀bùꞌû ja ji mbâŋnə̀ bo bɨ̀ jì bâŋgyɛ̀ a nɨ̂ ǹjwi ma jyâ, tâ bo ka nswoŋə nɨ̂ ɨ̀nnù jìi mə mə̀ nɨ̀ŋə a ntɨɨ bo aà. ");
INSERT INTO bfd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mə̀ ka yǐ ghɨ̀rə ɨnnǔ tsyǎmbô a aburə a ndəŋə, ɨ ghɨ̀rə ɨlènsə̀ fàa atu nsyɛ̂, a jiꞌì nɨ̀kàŋ; nɨ̀ ka yǐ yə aləə bo bɨ̀ mɔꞌɔ nɨ̂ m̀bàꞌà fɨ̀lɨ̂. ");
INSERT INTO bfd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nɨ̀nòò à ka yǐ bəŋ ɨ tɨgə fii tsǒ ɨ̀tugə tâ sàŋə̀ tâ à bəŋ ntɨgə mbaŋə tsǒ àləə̀, m̀bɔŋ tâ ǹjwî M̀màꞌàmbî, làꞌa njwî yì ŋ̀wè ya mə ka yǐ tsyǎ njwî tsɨ̀m aa, mbɔŋ tâ ɨ̀ zi. ");
INSERT INTO bfd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Maa noò, ŋù ǹtsɨ̀m yìi mə ka yǐ twoŋ ɨkum Mmàꞌambi aa, à ka yǐ yweenə.’ ");
INSERT INTO bfd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“BaIsrael, yuꞌutə̂ nɨ̀ ànnù yìi mə mə̀ ka swoŋ aa. Nɨ̀ zi mə Nwì à lɛ ndɨ̀ꞌɨ̀ mə Yesu mu Nazareth à nɨ ŋù yìi mə yu tsɔꞌɔ aa nɨ ɨ̀nnù jî wè bo bɨ̀ ɨ̀nnǔ tsyǎmbô bo bɨ a bɔ̀ꞌɔ ɨ̀lènsə̀ jìi mə Nwì yumbɔŋ à lɛ ŋghìrə̀ mə tâ yu Yesu tâ à ghɨrə a tɨtɨ̀ɨ bù aà. ");
INSERT INTO bfd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nwì à lɛ naŋsə nləə ŋ̀kɨ nzi mə bɨ ka yǐ fa Yesu ma ghû a mbo bù. Bɨ fà mə̂, nɨ ghɨ̀rə mə tâ bə̀ bî bɨ tâ bɨ̀ kweentə yi a ati bàŋnə̀ bàŋnə̀, ǹzwitə yi ghu. ");
INSERT INTO bfd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lâ Nwì a yweensə̀ yi a nɨ̀wo, ŋ̀kɛtə mɨ̂ŋkɨ̀rə̀ mɨ ŋgɨꞌɨ̀ nɨ̀wo yìi mə à lɛ yə aa, ǹloŋ mə kaa nɨ̀wo nɨ lɛ ŋwaꞌà nɨ̂ àdàꞌà a ntswa yu nləə a nɨsyɛ̀ tswê bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ǹloŋ mə David à lɛ nswoŋ nloŋ ŋgaà yì mə, ‘Mə̀ lɛ sɨ yə nɨ̂ M̀màꞌàmbi a tswe a mbìi mə a ŋgɔ̀ŋ bɨ̀nòò bɨ̀tsɨ̀m; tsǒ mə à tswe a mbɛ̀ɛ̀ àbo mə yî màꞌà aa, kaa m̀bə ǹtɨɨ̀ gha ɨ waꞌà ka ntsɨgɨnə bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ma mùu ajàŋ, ǹtɨɨ̀ gha ɨ tswe nɨ̀ nɨ̀dorə̀, mə̀ tɨgə̀ ŋ̀ghaa nɨ nɨ̀dorə; tâ ǹjyǎnû yà tâ ɨ̀ tswe ntɨgə nyuꞌutə nɨ̂ ŋ̀kàꞌa yìi mə Nwî à lɛ ŋkàꞌà aà, ");
INSERT INTO bfd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ǹloŋ mə kaa ò ka yǐ waꞌǎ ntɨɨ̀ gha màꞌàtə̀ tâ ɨ̀ tswe a alaꞌa bɨ̀ku bɨ bə̂ àa bə̂ kaa mbə ò waꞌà kɨ̀ m̀maꞌatə ŋgàŋàfàꞌâ ghò yìi mə à fâ ɨ̀bɨ̀ɨnû yi a mbo wò aa, tâ à bwɛ bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ò dɨ̀ꞌɨ̀ mə̂ mânjì yìi mə mbə mə̀ tsyâ ghu ntswe ntɨ̀ɨ̀ aa a mbo mə̀; ò kà ghɨ̀rə tâ ǹtɨɨ̀ gha tâ ɨ̀ luu nɨ nɨ̀dorə a noò yìi mə mə̀ tswe a nsi miꞌi wò aà.’ ");
INSERT INTO bfd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Bɔɔ bɨ maà, m̀bə mə̀ tse ghàà a mbo bù tsiꞌì nɨ̀ nsi nɨ̀ nsi nloŋə tâtsə̂ yiꞌinə̀, David. À lɛ ŋkwo bɨ kɨ̂ ǹtwiŋə yi, nɨ̀syɛ̂ ni nɨ kɨ̂ ǹtswe faà ǹzi nyweꞌe siì. ");
INSERT INTO bfd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David à lɛ mbə ŋ̀gàŋntoò Nwì ŋ̀kɨ nzi mə Nwì à lɛɛ̀ ŋ̀kaꞌa a mbo yu mə yu Nwî yu ka yǐ tswesə mu David yî mɔ̀ꞌɔ ghu aləŋə nɨfɔ̀. ");
INSERT INTO bfd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David à lɛ nyə annù yìi mə Nwì à lɛ ntswe nɨ̂ ŋghɨ̀rə aa, m̀bɔŋ tâ à fɛꞌɛ mbòòntə̀, ǹtɨgə ŋghaa nloŋ a ajàŋ yìi mə Kristo, Àyɔꞌɔ̀ Nwi wa, à ka yǐ yweenə nɨ nɨ̀wo, tâ Nwì tâ à waꞌà yi maꞌàtə̀ tâ à tswe a alaꞌa bɨ̀ku bɨ bə̂, kaa waꞌà kɨ̀ mbii mə tâ ǹjyǎnû yì ɨ̀ bwɛ aa bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nwì a ywèènsə̀ mə̂ Yesu ma ghû nɨ nɨ̀wo. Bìꞌì bɨ tsɨ̀m bìꞌì yə̂ yi nɨ miꞌì miꞌi a ajàŋ yìi mə à lɛ nyweenə nɨ nɨ̀wo aà. ");
INSERT INTO bfd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tsɨ̂tsɔ̀ŋ, Nwì à kɔ̀ꞌɔ̀sə yi a ǹdəŋ, a adɨgə nɨfɔ, ǹtswesə yi a mbɛ̀ɛ̀ nɨ̀kwɛɛ yu Taà yì nî màꞌà, m̀fa Àzwì Nwî yìi mə à lɛ ŋkàꞌà mə yu ka yǐ fa aa ghu mbô. Àyoo ya mə nɨ̀ yə ŋ̀kɨ yuꞌu a koò aa, à bə aa Àzwì Nwî ma yâ mə Kristo à swìꞌi a nu bìꞌì. ");
INSERT INTO bfd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ǹloŋ mə David yumbɔŋ kaa à lɛ ŋwaꞌà a aburə kɔꞌɔ ŋghɛ̀ɛ̀, yumbɔŋ à lɛ mbàŋnə̀ ǹswoŋ mə, ‘M̀màꞌàmbi à swòŋə a mbo M̀màꞌàmbî ghà: Tswe a mbɛ̀ɛ̀ nɨ̀kwɛɛ mə̀ nî màꞌà, ");
INSERT INTO bfd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ǹyweꞌe a noò yìi mə mə̀ ka ghɨ̀rə tâ ŋ̀gàŋkɨ̂bàâ jo tâ ɨ̀ bəŋ ntɨgə mbə tsǒ àkəꞌə ntɛtɛ mɨ̀kòrə̂ mô.’ ");
INSERT INTO bfd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ma mùu ajàŋ, a bɔŋ mə tâ baIsrael bɨtsɨ̀m tâ bɨ naŋsə nzi mə Nwì à lə̀ə̀ mə̂ Yesu ma ghû mə nɨ̀ lɛ ŋkwèèntə̀ a ati bàŋnə̀ bàŋnə̀ aa nɨ̂ M̀màꞌàmbi bo bɨ̀ Àyɔꞌɔ̀ Nwì.” ");
INSERT INTO bfd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bə̀ bya bo yùꞌù mə̂ laà, ànnù ya a sô ǹtɨɨ̀ waa, ɨ luu nɨ̂ àjəŋnə̀, bo tɨgə̀ m̀betə Peta bo bɨ̀ ŋ̀gǎŋntoo jǐ mɔꞌɔ jya mə, “Bɔɔ bɨ maà biꞌi, m̀bə bìꞌì tɨgə̀ ŋghɨrə aa mə akə ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peta a kwiꞌi a mbo bo mə, “Nɨ̀ bəŋkə mɨ̂ntɨɨ̀ muu, ŋ̀kwɛrə ŋkì bu bɨtsɨ̀m nɨ̂ ɨ̀kǔm Yesu Kristo, tâ Nwì à liꞌinə ɨbɨ̂ ghuu, ŋ̀kɨ ntəŋə ghuu nɨ̂ Àzwì Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ma yu ànnù à nɨ̂ ànnù yìi mə Nwì à lɛ ŋkàꞌà a mbo bù bo bɨ̀ a mbo bɔɔ̀ buu, a mbo bə̀ bɨ̀tsɨ̀m bìi mə bɨ tswe a sàꞌa aghaꞌà, bo bɨ̀ a mbo ŋù ǹtsɨ̀m yìi mə Taà yìꞌì Nwîŋgɔ̀ŋ a twǒŋ mə à zi a mbɛ̀ɛ yu aà.” ");
INSERT INTO bfd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peta à lɛ ntɨgə mbu nswoŋ ɨnnù jî ghàꞌàtə̀ a mbo bo a ajàŋ yìi mə bo lɛ nyuꞌu ŋ̀kɨ nyə aa, ǹdɨꞌɨtə nɨ̂ waa nswoŋə nɨ mə, “Tsuꞌu nɨ̀ àtû yuu a mbo nɨ̀wàà nɨ bə̂ buà bìi mə à nɨ bə̀ bî bɨ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bə̀ bî ghàꞌàtə̀ bɨ lɛ nyuꞌu ànnù yìi mə Peta à lɛ swoŋ aa, m̀bii, ŋ̀kwɛrə ŋkì. Bə̀ bìi mə bɨ lɛ ŋkwɛrə ŋkì maa njwi aa bɨ lɛ mbə ntsùꞌù ji tarə̂, ǹdùù waa ma bû ɨ tɨgə̀ ŋ̀kuꞌusə ŋghotə̂ bɔɔ bɨ Kristo byâ. ");
INSERT INTO bfd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ǹlɔgɨnə maa njwi bo lɛ nnɨŋ atû yaa nɨ̂ ɨ̀nnù jìi mə ŋgǎŋntoo jya ɨ lɛ sɨ dɨ̀ꞌɨ̀ aa, ǹnaŋsə nyəgə, m̀boonsə wa bo ntswê ŋ̀ghɨrə nɨ̂ ɨ̀nnù jyaa nɨ̂ àbo yì mɔꞌɔ a mûm ŋ̀ghòtə, m̀batə nɨ̂ abaa ŋkurə bo bɨtsɨ̀m, ŋ̀kɨɨ ntsaꞌatə nɨ̂ Nwî bo bɨtsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ngǎŋntoò Kristo jya bo lɛ sɨ ghɨ̀rə ɨ̀nnǔtsyâmbô bo bɨ̀ ɨ̀nnù jî yɛ̌yɛrə, ma yû a ghɨrə̀ mə tâ nɨ̀bɔꞌɔ nɨ̀ tswa bə̂ bɨ̀tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ nnɨ̀ŋ ntɨɨ̀ waa a nu Yesu aa, bɨ lɛ mbòònsə̀ waa, ŋ̀ghotə nɨ̂ waa ntswe nɨ̂ àdɨgə yî fùùrə̀, m̀boonsə nɨ̂ ǹjoò jyaa, àyoò yaa a bə yi mɔꞌɔtə̂. ");
INSERT INTO bfd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bo lɛ sɨ fèntə nɨ̂ ɨ̀dɨgə nsyɛ̂ jyaa bo bɨ̀ ǹjoo jìi mə bo lɛ ntswe nɨ ju aa, ǹzi mfakə nɨ̂ ŋ̀kabə yìi mə bo fentə njoò jyaa jya ghu aa, a mbo bə̀ bìi mə bɨ lɛ sɨ boŋ nɨ̂ njoo aà. ");
INSERT INTO bfd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bo bɨtsɨ̀m lɛ sɨ ghɛ̀ɛ̀ nɨ ndâmàꞌanwì tsiꞌì ǹjwî tsɨ̀m, m̀batə nɨ̂ àbaa a mɨlaꞌa bo, ǹyatə nɨ̂ mɨ̀jɨ̂ myaa ǹjɨ ndorɨtə nɨ̂ ǹtɨɨ̀ waa tsɨ̀m; ");
INSERT INTO bfd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ŋ̀ghaꞌasə nɨ̂ Nwî, bə̀ bɨ̀ tsɨ̀m bɨ kɔŋə̀ nɨ̂ waa. M̀màꞌàmbi a lɛ sɨ yweensə nɨ̂ bə̀, ŋ̀kuꞌusə nɨ̂ ǹdùù waa ghu tsiꞌì ǹjwî tsɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Peta bo Jɔn lɛ sɨ kɔꞌɔ ŋghɛɛ a ndâmàꞌanwì a noò ǹtsàꞌàtə Nwì, a nɨ bɨ̀nòò bi tarə a siꞌinə a njwi yì mɔ̀ꞌɔ; ");
INSERT INTO bfd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bə̀ lɛ mbèꞌè ŋû yî mɔ̀ꞌɔ yìi mə à lɛ mbwenkə nlɔgɨnə a atoꞌo aa nzì nɨ ghu. Bɨ lɛ sɨ zì maꞌatə nɨ mbwenkə ma ghû tsiꞌì ǹjwî tsɨ̀m a tsǔbùꞌu ndâmàꞌanwì wa yìi mə bɨ lɛ sɨ twoŋə nɨ Ntsǔbùꞌu yî m̀bɔ̀ŋ mbɔŋ aà mə tâ à tswe ghu ntɨgə nlɔntə nɨ̂ ŋ̀kabə a mbo bə̀ bìi mə bɨ lɛ sɨ zi a ŋkuu a ndâmaꞌanwì aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","M̀bwènkə̀ wa à yə̀ mə̂ Peta bo Jɔn bo zî ŋghəə kɨ kuu a ndâmàꞌanwì ǹlɔntə ŋkabə a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peta bo Jɔn bo tɛꞌɛ miꞌì myaa ghu nu nswoŋ mə, “Ka nlìì nɨ̂ yiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A tɨgə̀ ǹtɛꞌɛ miꞌì mi a nu bo ǹtɨgə ŋwaꞌatə nɨ mə bo ka fa ŋkabə a bo yu. ");
INSERT INTO bfd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","La Peta a swoŋ ghu mbo mə, “Kaa mə sɨ nɨ silva kə̀ nɨ gold tswê, lâ mə̀ ka bàŋnə fa ayoo yìi mə mə̀ tswe nɨ yu aà: Mə̀ swǒŋ a mbo wò nɨ̂ ɨ̀kǔm Yesu mu Nazareth mə tâ ò bɨɨnə ŋka ntəə.” ");
INSERT INTO bfd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","À swòŋ mə̂ ma mùu ajàŋ, ǹtswa nɨkwɛɛ nɨ mbwenkə wa nì màꞌà a bɨɨ̀nə̀ ǹtəə. Mɨ̀kàꞌâ mi bo bɨ̀ miꞌi mɨ mɨkòrə̂ mi mɨ burə̀ ǹtɨɨ mbə ajàŋ yìi mə mbə a tɨgə̀ ǹtəə tsiꞌì sɨgɨ̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A lɨ m̀bɨ̀ɨ̀nə̀ ǹtəə, ǹlo ntɨgə ntəə nyoŋə waa bo bo tɨgə̀ ŋ̀kuu ŋghɛɛ a ndâmàꞌanwì. A tɨgə̀ ǹlɨtə ntəə ŋghaꞌasə nɨ̂ Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bə̀ bɨ̀ tsɨ̀m bɨ yə̂ yi a ajàŋ yìi mə à lɛ sɨ təə ŋghɛɛ ŋghaꞌasə nɨ̂ Nwî aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bɨ̂ yə̂ yi, ǹzi mə à nɨ ŋù wa mə à lɛ sɨ tswe wa Ǹtsǔbùꞌu ndâmàꞌanwì yî bɔ̀ŋ mbɔŋ ǹlɔɔ nɨ̂ ŋ̀gabə aà; ànnù a burə̀ ǹtɨgə ntsya waa tsiꞌì tsyà a nyə̂ ànnù yìi mə a lɛ mfɛ̀ꞌɛ̀ ghu nu aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tsǒ mə ŋù wa a lɛ nyòŋ ǹtɨgə mbanə nɨ njɨ̌m Peta bo Jɔn aa, bə̀ bɨ̀tsɨ̀m bɨ lɛ ntɨgə nywunə nzi mbòòntə̀ a mbɛ̀ɛ̀ bo wa nɨ potico yìi mə bɨ lɛ sɨ twoŋə nɨ yì Solomon aà, mɨ̀tsyɛ̂ myaa mɨ burə̀ m̀burə tsiꞌì bùrə̀. ");
INSERT INTO bfd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peta à yə̀ mə̂ ma mùu ajàŋ, ŋ̀ghaa a mbo bə̀ bya ǹswoŋ mə, “BàIsrael, nɨ yɛrə ǹloŋ annù yuà laa a ya? Nɨ lìì yiꞌi laà laa a ya? Nɨ̀ mɔ̀ɔ̀ntə mə bìꞌì ghɨrə annù ma yû aa nɨ̂ àdàꞌâ yiꞌi, kə̀ nɨ̀ laà ŋ̀kɨ mɔɔntə mə bìꞌì ghɨrə mə tâ ŋù ghû bɨɨnə ŋka ntəə aa nloŋ mə mɨ̀nnǔ miꞌi mə tsinə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nwìŋgɔ̀ŋ bɨ̀ Abraham nɨ Isaac nɨ Yakob, Nwìŋgɔ̀ŋ bɨ̀ taà yiꞌinə̀, à ghàꞌàsə Ŋgàŋàfàꞌâ yì Yesu yìi mə nɨ̀ lɛ nlɔ̀gə̀ yi mfa mə bɨ̀ zwitə, ntuu yi a nsi Pilato, ka mə Pilato à lɛ nlɔ̀ɔ̀ mə yu màꞌàtə̀ yi tâ ghɛɛ yi aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nɨ̀ tuù Mu Nwì yìi mə à laa màŋsə̀, mɨ̀nnû mi mɨ tsinə̀ aà, ǹswoŋ mə tâ bɨ̀ baŋnə mfa ŋû yìi mə à zwitə ŋû aa a mbo bù. ");
INSERT INTO bfd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nɨ̀ zwitə̀ Ŋû yìi mə a fa ntswêntɨ̀ɨ̀ a mbo bə̀, Yesu yìi mə Nwì à lɛ nyweensə nɨwo aà. Bìꞌì nɨ bɨ̀yəfə nɨ̂ ànnù ma yû. ");
INSERT INTO bfd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ŋù ghulà mə nɨ̀ yə, ŋ̀kɨ nzi yi aa, a ghɨ̀rə̂ Ɨ̀kǔm Yesu, a ghɨ̀rə̂ àjàŋ yìi mə à nɨ̌ŋ ǹtɨɨ̀ yi a nɨ Ɨ̀kǔm Yesu aa, mə tâ à tswe nɨ mɨ̀tɨ̀ɨ̀. A ghɨ̀rə àbìintɨɨ yìi mə ŋù ghû à tswe nɨ yu nloŋ Yesu aa mə tâ à tɨɨ, m̀burə naŋsə ntɨɨ a ajàŋ yìi mə nɨ̀ yə a tswə̂ a nsi miꞌi bu bɨ̂tsɨ̀m laà aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bɔɔ bɨ maà, lâ tsɨ̂tsɔ̀ŋ mə̀ zi mə nɨ̀ lɛ ŋghɨ̀rə annù yìi mə nɨ̀ lɛ ŋghɨ̀rə aa tɨ̀ zî, a ajàŋ yìi mə bɨ̀saꞌa bɨ àlaꞌà buu bɨ lɛ ŋghɨ̀rə aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lâ ànnù yìi mə Nwì à lɛ ŋghɨ̀rə̀ ŋ̀gǎŋntoò ji tsɨ̀m ɨ foò nswoŋ tsiꞌì tɛ̀tɛ̀ aa, mə Àyɔꞌɔ̀ Nwì wa à tswe nɨ̀ nyə̂ ŋ̀gɨꞌɨ aa, à nɨ yu mə a kɨ̀ mə̂ m̀fɛꞌɛ mbòòntə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tsǒ mə a bə ma mùu ajàŋ aa, a bɔŋ mə mə tâ nɨ̀ bəŋkə mɨ̂ntɨɨ̀ muu, m̀bu mbɨ̀ɨ̀ fu a mbɛ̀ɛ Nwì, tâ à yɛꞌɛ ɨbɨ̂ ghu nlɔꞌɔsə ");
INSERT INTO bfd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","tǎ tâ M̀màꞌàmbi à ghɨrə tâ mɨ̀ntɨɨ̀ muu mɨ̀ fwɛtə, tâ à kɨ ntoo Ayɔꞌɔ̀ Nwì wa yìi mə à lɛɛ̀ ǹtsɔꞌɔ aa, a mbo bu, làꞌa Yesu ");
INSERT INTO bfd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","yìi mə à tswe nɨ̀ ntswe a aburə ɨ yweꞌe a nòò yìi mə Nwì à ka yi naŋsə ɨ̀nnù, ɨ ghɨ̀rə tâ m̀bi ɨ̀ bu mbɔ̀ŋ fu tsiꞌì a ajàŋ yìi mə ɨ̀ lɛ mbə a mbìì aà, ɨ ghɨ̀rə tâ ɨ̀nnù tsɨ̀m ɨ̀ kɨ mfɛꞌɛ mbòòntə̀ a ajàŋ yìi mə ŋgǎŋntoo Nwî jìi ɨ lɛ mfa mɨbɨ̀ɨ̀ mɨ nû myaa a mbo Nwì ɨ lɛ nswoŋə a ŋguꞌu aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses à lɛ nswoŋ mə, ‘M̀màꞌàmbi Nwìŋgɔ̀ŋ à ka yi ghɨ̀rə tâ ŋ̀gàŋntoò Nwì tâ à fɛꞌɛ a tɨ̂tɨ̀ɨ̀ bɔɔ bɨ maà buu tsǒ mə̀. Nɨ̀ ka yǐ kɨ yuꞌunə nìi, ɨ kɨ ghɨ̀rə̀ nɨ̂ ɨ̀nnù tsɨ̀m jìi mə a swoŋə aà. ");
INSERT INTO bfd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ŋù yìi mə à sɨ annù yìi mə ŋgàŋntoò Nwì ma ghû a swoŋ aa yuꞌu aa, a kuꞌunə mə tâ bɨ̀ zwitə, m̀fiꞌisə yi a tɨtɨ̀ɨ bə̀ bɨ Nwî.’ ");
INSERT INTO bfd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ŋ̀gǎŋntoo Nwî tsɨ̀m, ǹlɔgɨnə a nu Samuel ŋ̀ghɛɛ nyweꞌe nɨ bìi mə bɨ lɛ nyòŋ ghu njɨ̀m aa, bɨ lɛ ŋghàà ǹswoŋ ɨnnǔ njwi mà jû. ");
INSERT INTO bfd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nɨ̀ nɨ bɔɔ bɨ ŋgǎŋntoo Nwî, Nwì à lɛ ŋkɨ ŋwarə akàà ya bo bɨ̀ bɨ̀taà buu aa nloŋ atû yuu. Nwì à lɛ nswoŋ à mbo Abraham mə, ‘Mə̀ ka yi nɨŋ mbɔɔnə a atu ŋ̀gwɛ̀ꞌɛ̀ mu ŋù ntsɨ̀m fàa nsyɛ ɨ yòŋə̀ aa a njɨ̌m bɔɔ̀ buu.’ ");
INSERT INTO bfd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nwì à tsɔ̀ꞌɔ̀ mə Ŋgàŋàfàꞌâ yì, a ajàŋ yìi mə à lɛ nswoŋ aa, m̀foo ntoo yi a mbo bù, a nnɨŋ mbɔɔnə a nu bù, a ŋghɨ̀rə mə tâ ŋù ǹtsɨ̀m a tɨtɨ̀ɨ bù tâ à bəŋ ntɨɨ̀ yi, m̀maꞌatə ɨnnù jî bɨ jìi mə a ghɨ̀rə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bo kà mə̂ aa ŋghaa laa a mbo bə̀ bya, ŋ̀gǎŋmàꞌa Nwì bo bɨ̀ tamândoo ŋgǎŋmbɛ̂ ǹdâmàꞌanwì nɨ baSadukai zî ntsitə waa ");
INSERT INTO bfd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ǹtɔ̀ŋâ waa ɨ lɛ sɨ lwǐ a nu Peta bo Jɔn ǹloŋ mə bo lɛ sɨ dɨ̀ꞌɨ̀ nɨ̂ ànnù Nwî a mbo bə̀ bya, ǹswoŋə nɨ a mbo bo mə Yesu à lɛ nyweenə nɨwô, ma la a bə mə bə̀ ka yǐ kɨɨ yweenə nɨwô. ");
INSERT INTO bfd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bo lɛ ntswa Peta bo Jɔn; tsǒ mə̂ à lɛ mbə noò ŋ̀kwɛ̂fɔ̀ aa, bɨ tɨgə̀ ŋ̀ghɛɛ nnɨŋə waa a ndâtsaŋ, ǹləə mə tâ àbɛ̀ɛ̀ fuꞌu. ");
INSERT INTO bfd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lâ bə̀ bî ghàꞌàtə̀ bìi bɨ lɛ nyuꞌu nɨghàà nɨ Nwî nya aa, bɨ lɛ bii annu ma yâ. Ǹdùu mbâŋnə̀ tsɨ̂tsɔ̀ŋ ɨ tɨgə̀ ŋ̀ghɛɛ tsǒ ǹtsùꞌù ji ntaà. ");
INSERT INTO bfd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Àbɛ̀ɛ̀ fùꞌù mə̂, bɨ̀saꞌa bɨ alaꞌa byaa nɨ bɨ̀lɨ̀ɨ bɨ alaꞌa abɔ̀ꞌɔ ŋgǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ bɨ ghotə̀ ǹtswe a Yerusalem ");
INSERT INTO bfd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","bo bɨ̀ Annas, Ŋ̀gàŋmàꞌanwì yî ŋwè, nɨ Kaifas, nɨ Jɔn nɨ Alexander nɨ bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ mfɛ̀ꞌɛ̀ a ŋgwɛ̀ꞌɛ ŋ̀gàŋmàꞌanwì yî ŋ̀wè aà. ");
INSERT INTO bfd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bo ghòtə̀ mə̂ ǹtswe, ǹlɔgə Peta abɔ̀ꞌɔ Jɔn ǹtɛꞌɛ a tɨtɨ̀ɨ bo, m̀betə waa mə, “Nɨ̀ kɨ̀ ghɨ̀rə ànnù ya aa nɨ mɨ̀dàꞌà mɨ wo, kə̀, nɨ̀ kɨ̀ ghɨ̀rə aa nɨ ɨ̀kǔm wo aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Àzwì Nwî a kuu nluu a ntɨɨ Peta, a swoŋ a mbo bo mə, “Bɨ̀saꞌa bɨ alàꞌà nɨ bɨ̀lɨ̀ɨ bɨ alaꞌà, ");
INSERT INTO bfd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Bɛɛ mə nɨ̀ tɨ betə yiꞌi nɨ ɨ̀nnù sii aa nloŋ ànnù yî sɨgɨ̀nə̀ yìi mə bìꞌì ghɨrə a nu m̀bwɛ̀nkə̀ wa aa, bɛɛ nɨ̀ tɨ lɔ̀ɔ̀ aà ǹzi a ajàŋ yìi bìꞌì tsya mbɔ̀ŋ ŋ̀ghɨ̀rə̀ tâ ŋù ghû tɨɨ aa, ");
INSERT INTO bfd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","a bɔŋ mə tâ ŋù ǹtsɨ̀m, nɨ bə̀ bɨ̀tsɨ̀m bìi mə bɨ tswe a Israel, a kuꞌunə mə tâ nɨ̀ zi mə bìꞌì ghurə ŋû ghû mə nɨ̀ yə a təə a tɨtɨ̀ɨ bù laa, nɨ̀ Ɨ̀kǔm Yesu Kristo Mû Nazareth yìi mə nɨ̀ lɛ ŋkwèèntə̀ a ati bàŋnə̀ bàŋnə̀, yu wa yìi mə Nwì à lɛ nyweensə nɨwo aà. ");
INSERT INTO bfd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘À nɨ ŋ̀gɔ̀ꞌɔ̀ ya mə bǔ bɨbɔɔ bɨ nda nɨ̀ lɛ ntuu aa, mə ɨ̀ bə̀ŋ mə̂ ǹtɨgə ŋgɔ̀ꞌɔ̀ nɨ̀buu yì ŋ̀wè.’ ");
INSERT INTO bfd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kaa ŋù tsù kaa sɨ̀ ghu tswe mə mbə bɨ tsyâ ghu njɨ̀m ǹyweenə, ǹtsyastə Yesu Kristo, ǹloŋ mə kaa ɨ̀kùm yî tsu kaa ɨ sɨ̀ fàa atu nsyɛ tswə̂ a tɨtɨ̀ɨ bə̂ mə Nwì à fa mə mbə ɨ tse yweensə yiꞌinə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ànnù lɛ ntsya waa a ajàŋ yìi mə bo lɛ nyə ataŋə ntɨɨ yìi mə Peta nɨ Jɔn lɛ sɨ ghàà ghu aa, a lɛ mburə ghaꞌa waa tsiꞌì ghàꞌà ǹloŋ mə bo lɛ nzi mə bo lɛ mbə aa tsiꞌì bə̀ bɨ adàŋə̀ àdàŋə̀ bìi mə kaa bɨ lɛɛ̀ ŋ̀waꞌǎ a ndâŋwàꞌànə̀ ghɛɛ aà. Lâ bô yə̀ mə̂ laà aa, ŋwaꞌatə mə Peta bo Jɔn lɛ mbaa mbə aa ŋgàŋəkòrə̀ Yesu. ");
INSERT INTO bfd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lâ a ajàŋ yìi mə bɨ lɛ nyə ŋû wa yìi mə bo lɛ ŋghùrə̀ a təə a mbɛ̀ɛ bo aa, kaa bə̀ bya kaa bɨ waꞌà nɨ ànnù yî àdàŋ a ŋghàa bù ǹtswe. ");
INSERT INTO bfd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bo lɛ ntɨgə nswoŋ a mbo Peta nɨ Jɔn mə tâ bo fɛꞌɛ wa ndâ ǹsaꞌa mɨ̀saꞌa, bo fɛ̀ꞌɛ̀ mə̂, bɨ tɨgə̀ ŋ̀ghaanə bo nɨ bo ");
INSERT INTO bfd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ǹswoŋ mə, “Bìꞌinə̀ ka ghɨ̀rə̀ mə akə nɨ̀ bə̀ buà aa ɛ? Bə̀ bɨ̀tsɨ̀m fàa Yerusalem bɨ zi mə bo ghɨrə alènsə̀ yî wè, kaa m̀bə bìꞌinə̀ waꞌǎ annù ma yû tuù. ");
INSERT INTO bfd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lâ a ŋghɨ̀rə mə tâ ànnù ma yû tâ waꞌà lò bu nsɛɛnə ŋghɛɛ a tɨtɨ̀ɨ bə̀, a bɔŋ mə tâ bìꞌinə̀ ghaantə waa, ŋ̀waꞌasə nswoŋ mə tâ bo tsuu ànnù a mbo ŋù tsù burə bǔ kɨ swoswoŋ nɨ ɨ̀kǔm Yesu.” ");
INSERT INTO bfd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bo ghàànə̀ mə̂ laà, ǹtwoŋə waa, ǹghaa a mbo bo ŋwaꞌasə nswoŋ mə tâ bo tsuu annù yî tsu burə bǔ kɨ ghaghàà, kə̀ kɨ dɨ̀ꞌɨ̀ nɨ ɨ̀kǔm Yesu. ");
INSERT INTO bfd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lâ Peta nɨ Jɔn kwiꞌi a mbo bo mə, “A ka zi tsiꞌì bù mə, a nsi miꞌi Nwì, a kuꞌunə aa a nyuꞌunə bù kə̌ Nwî lɛ; ");
INSERT INTO bfd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Lâ a ŋghɛɛ nɨ ŋ̀gàâ yìꞌì, bìꞌì tswe nɨ̀ ŋ̀kà ǹswoŋ aa tsiꞌì ànnù yìi mə bìꞌì yə ŋkɨ yuꞌu aà.” ");
INSERT INTO bfd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bo bù mə̂ ŋ̀kaꞌatə waa, m̀maꞌatə waa mə tâ bo ghɛɛ waa; kaa ŋwaꞌà àjàŋ yìi mə mbə bo nɨ̂ŋ ɨ̀saꞌa a nu bo aa zî, ǹloŋ mə bə̀ bɨ̀ tsɨ̀m lɛ sɨ ghaꞌasə nɨ̂ Nwî ǹloŋ annù ya yìi mə a lɛ mfɛ̀ꞌɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɨ̀lòò ŋû waa yìi mə bo lɛ ŋghùrə̀ nɨ ànnù yî àyɛ̌yɛrə aa ɨ lɛ ntsyàtə mɨghum mi nɨkwà. ");
INSERT INTO bfd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bɨ màꞌàtə̀ mə̂ waa, bo lô ŋ̀ghɛɛ a mbɛ̀ɛ bɨ̀lɨ̂m byaa nswoŋ annù yìi mə bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì bo bɨ̀ bɨ̀lɨ̀ɨ bɨ alaꞌa bɨ lɛ nswoŋ a mbo bo aà. ");
INSERT INTO bfd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bo yùꞌù mə̂, ŋ̀ŋɛntə njǐ jyaa a ndəŋ bo bɨ̂tsɨ̀m, ǹtsaꞌatə Nwî ǹswoŋ mə, “M̀màꞌàmbi yìi mə à kɔ̀ꞌɔntsɨrə aa, ǹnàŋsə̂ àbùrə̀ bô ǹsyɛ nɨ̀ mɨ̀yàà nɨ̂ ŋ̀gɔ̀ŋ ǹjoò tsɨ̀m jìi mə ɨ tswe ghu aa, ");
INSERT INTO bfd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wò yìi mə ò lɛ ŋghɨ̀rə̀ taà yìꞌì David, ŋ̀gàŋàfàꞌâ ghò a ghaà ǹswoŋ ànnù yìi mə Àzwì Nwî a lɛ lɛnsə gho mbo aa mə, ‘Mɨ̀ntɔŋ muu mɨ lwì, nɨ̀ kwɛɛ̀ nɨ̀ mɨ̀ntɨɨ̀ muu aa a ya aa ɛ, bɨ̂tɨzi Nwî? Ŋ̀gwɛ̀ꞌɛ̀ bə̂, nɨ kwàꞌàtə̀ nɨ̂ ɨ̀nnǔ dàŋə̀ àdàŋə̀ a atu bù aa a ya? ");
INSERT INTO bfd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bɨ̀fɔ̀ bɨ mbi bù bɨ taŋtə nû yàà bo bɨ̀ bɨ̀saꞌa bɨ ɨlaꞌa, ànnù yaa bo a bə yǐ mɔꞌɔ, ǹzi a nto M̀màꞌàmbi bo bɨ̀ Àyɔꞌɔ̀nwì wâ.’ ");
INSERT INTO bfd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tsiꞌǐ annù nɨ̂ŋkoŋ Herod nɨ Pilato a bɔꞌɔ nɨ bɨ̀tɨ̀zî Nwî bo bɨ̀ bàIsrael bɨ̀ lɛ ŋghotə fàa a mûm àlaꞌa, ǹtaŋ mɨnàŋ a atu Yesu ŋ̀gàŋàfàꞌâ gho yìi mə à laa maŋsə̀ aa, m̀bə yu wa yìi mə ò lɛ nyɔꞌɔ aa, ");
INSERT INTO bfd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","a ŋghɨ̀rə̂ ànnù yìi mə ò lɛ ŋkàꞌà nɨ̂ àdàꞌà yo, ǹlə̀ə̀ mə a ka yi fɛ̀ꞌɛ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","M̀màꞌàmbî, yə la tsɨ̂tsɔ̀ŋ a ajàŋ yìi mə bɨ kàꞌàtə̀ nɨ̂ yiꞌi aà, fa atàŋəntɨɨ a mbo bìꞌì, ŋ̀ghɨrə tâ ŋ̀gǎŋfàꞌâ jo ɨ̀ ghaa nɨ̂ mɨ̀dàꞌà, ");
INSERT INTO bfd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tâ ò ghɛnsə abo yo ŋghɨ̀rə̀ tâ àdàꞌà yo tâ ghurə bə̂, ŋ̀ghɨrə ɨlènsə ɨnnù a bɔꞌɔ nɨ ɨ̀nnǔ tsyâmbô nɨ̂ ɨ̀kǔm Mu gho Yesu yìi mə à laa màŋsə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bo màŋsə̀ mə a ntsàꞌàtə Nwì laà, àdɨgə̀ ya yìi mə bo lɛ ŋghotə ghu aa a tsɨ̂gɨ̀nə̀, Àzwì Nwî a kuu nluu a ntɨɨ bo, bo ghaà ǹswoŋə ànnù Nwî tsiꞌì nɨ̂ àtàŋəntɨɨ̀. ");
INSERT INTO bfd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ànnù bə̀ bya bìi mə bɨ lɛ nnɨŋ ntɨɨ waa a nu Yesu Kristo aa, a lɛ mbə tsiꞌì yǐ mɔꞌɔ, ǹtɨɨ̀ wa ɨ bə yǐ mɔꞌɔ, kaa ŋù nɨ̀bò yî tsù kaa a waꞌà lò ǹswoŋ mə àyoo yi à nɨ tsiꞌì yi bə̂. Bo lɛ mbòònsə njoò jyaa, ayoo yaa a tɨgə̀ m̀bə tsiꞌì ayoo mɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ŋ̀gǎŋtoo Yesu jya ɨ lɛ ŋghɛ̀ɛ̀ nɨ̂ m̀bìì a ghàa tsiꞌì nɨ̂ àdàꞌà yî wè ǹswoŋ nɨ̂ àjàŋ yìi mə bo zi tsiꞌì ànnù nɨ̂ŋkoŋ mə M̀màꞌàmbi Yesu à ywèènə nɨ nɨ̀wo aà. Ɨ̀bɔ̀ŋ Nwî ɨ lɛ tswe a mbo bo bɨ̂tsɨ̀m, m̀fa nɨ̂ àdàꞌà a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kaa ŋù tsù kaa à lɛ ŋwaꞌà a tɨtɨ̀ɨ bo tswe mə à lɛ sɨ boŋ ayoò, ǹloŋ mə bo bɨ̂tsɨ̀m bìi mə bɨ lɛ ntswe nɨ̂ ɨ̀dɨ̀gə nsyɛ kɨ̀ nɨ̂ mɨ̀laꞌa aa, bo lɛ mfèèŋkə̀, ǹlɔgə ŋkabə yìi mə bɨ fee ghu aa, ");
INSERT INTO bfd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nzì nnɔŋsə a mɨkòrə ŋgǎŋtoo Kristo jya, bo tɨgə̀ ǹlɔgə nyàtə̀ a mbo bə̀ bɨ̀tsɨ̀m bìi bɨ lɛ sɨ bɔŋə ayoo aà. ");
INSERT INTO bfd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma mùu noò, Joseph, mə bɨ lə njwe yi a Cyprus, a bə ŋù ŋ̀gwɛ̀ꞌɛ̀ Levi, ŋ̀gǎŋntoo Kristo jya ɨ tswê ɨ̀kǔm yi nɨ Barnabas aa (njiꞌì ɨ̀kùm ma ghû ɨ bə mə, Mu yìi mə a ləꞌətə ntɨɨ bə̂ aà) ");
INSERT INTO bfd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","a kɨ̂ m̀fee adɨgə nsoo yi, ǹlɔgə ŋkabə ya yìi mə à lɛ mfee ghu aa, nzì nnɔŋsə a mɨkòrə ŋgǎŋntoo Kristo jyâ. ");
INSERT INTO bfd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lâ ŋù yî mɔ̀ꞌɔ, ɨ̀kǔm yi ɨ bə Anania, bô ŋ̀gwɛ̂ yì, Safira lɛ mfèe adɨgə nsyɛ̂ yaa. ");
INSERT INTO bfd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bo fèè mə̂, Anania a fiꞌitə̀ ŋ̀kabə̀ àdɨ̀gə̀ ya ǹlə̀ə̀, ŋ̀gwɛ̂ yì wa a kɨ̂ ǹzi, à fìꞌìtə̀ mə̂ ǹləə aa, ǹtɨgə nlɔgə àbùgə ŋkabə ya ŋghɛ̀ɛ̀ ǹnɔŋsə a mɨkòrə ŋgǎŋntoo Kristo jyâ. ");
INSERT INTO bfd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lâ Peta a betə̀ yi mə, “Ànania, a ghɨ̀rə̂ àkə̀ ò maꞌàtə̀ Satan a kuu a ntɨɨ wò ŋ̀ghɨrə ò swoŋ àbǎŋnənnù a mbo Àzwì Nwî, a ajàŋ yìi mə ò fìꞌìtə abùgə ŋkabə adɨgə ya nlə̀ə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","M̀bɔŋ tâ ò fee adɨgə ya, tɨgə a lɛ mbə aa à yô aa ɛ? Nòò wa mə ò fèè mə̂ aa, ŋ̀kabə ya mə ò fèe ghu aa, ɨ waꞌà kɨ̂ m̀bə aa tsiꞌì yò aa ɛ? A tɨgə̀ ǹlo ŋghɨ̀rə akə mə tâ ò waꞌatə ma yû àjàŋ annù a ntɨɨ wò aa ɛ? Kaa ò sɨ̌ abǎŋnənnù aa a mbo bə̀ swoŋə̀, ò tswɛɛ ɨ̀bǎŋnənnù aa a mbo Nwì.” ");
INSERT INTO bfd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania à yùꞌù mə annù ma yû, ŋ̀wo a nsyɛ ŋkwo. Bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ nyuꞌu aa, nû jyaa ɨ swerə̀ siꞌi siꞌi. ");
INSERT INTO bfd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bɔɔjɔ̀ŋ bɨ zî ǹlɨm akû yi ya ǹtɨgə nlɔgə mfɛ̀ꞌɛ̀ ŋghɛɛ ntwiŋə. ");
INSERT INTO bfd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bɨ̀nòò ghəə kɨ tsyà bi tarə, ŋ̀gwɛ̂ yì a zî, kaa waꞌà annù yìi mə a fɛꞌɛ aa zî. ");
INSERT INTO bfd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peta a swoŋ ghu mbo mə, “Mə̂mbà, naŋsə nswoŋə ghâ, nɨ̀ kɨ̀ fèê àdɨ̀gə nsyɛ̂ yùu ya aa nɨ̂ ǹdùu ŋkabə kɨ̀kyɛ̀ aa ɛ?” A swoŋ mə, “Ɨ̀ɨ̀ŋə, àa tsiꞌì ǹdùù yìi mə bìꞌì kɨ̀ fèe ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peta a tɨgə̀ ǹswoŋ ghu mbo mə, “A ghɨ̀rə̂ àkə̀ mə tâ bû ǹdoò ghò taŋtə a kwàꞌànə Azwǐ Mmàꞌàmbi aa ɛ? Yə̂ mɨkòrə̀ mɨ bə̂ bìi bɨ twìŋ mə̂ ǹdoo ghò aà, bo biì a ntsǔndâ, bo ka kɨɨ bèꞌè gho fɛ̀ꞌɛ̀ nɨ wò.” ");
INSERT INTO bfd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","À kɨ̂ m̀burə wo tsiꞌì maa noò a nsi mɨkorə Peta ŋ̀kwo. Bɔɔjɔ̀ŋ bya bɨ̂ kùù mə̂, ǹyə mə à kwò mə̂ aa, ǹtɨgə ŋkɨ mbeꞌe yi mfɛꞌɛ ŋghɛ̀ɛ̀ ǹtwiŋ a mbɛ̀ɛ ndoò yì. ");
INSERT INTO bfd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nɨ̀bɔꞌɔ nɨ̀ wè nɨ lɛ mburə tswa ŋghotə bɔɔ bɨ Kristo bɨtsɨ̀m bo bɨ̀ bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ nyuꞌu annù ma yû aà. ");
INSERT INTO bfd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ŋ̀gǎŋntoo Kristo jya ɨ lɛ sɨ ghɨ̀rə̀ nɨ̂ ɨ̀nnù jî yɛ̌yɛrə bo bɨ̀ ɨ̀nnǔtsyǎmbo a tɨtɨ̀ɨ bə̀. Ŋ̀gǎŋmbii Kristo jyâ ɨ̀ tsɨ̀m ɨ lɛ sɨ bòòntə̀ wa a ntsǔmbùꞌù yìi mə bɨ lɛ nsɨ twoŋ nɨ Ǹtsǔbùꞌù Solomon aà. ");
INSERT INTO bfd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kaa tsiꞌì mə tâ ŋù tsù yìi mə à lɛ waꞌà ŋû nɨ̀bò wàà bə aa tâ à tswe nɨ̂ àtàŋə ntɨɨ a nzi ŋkuu wa mûm ŋ̀ghotə̂ yàà, ka mə bo lɛ sɨ swoŋ nɨ̂ ɨ̀nnù jî sɨgɨ̀nə̀ ǹloŋ ŋghotə̂ bɔɔ bɨ Kristo ma yû aa. ");
INSERT INTO bfd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Lâ ǹdùù bə̂ bìi mə bɨ lɛ sɨ nɨ̂ŋ nɨ̂ ntɨɨ̀ waa a nu M̀maꞌambî Yesu aa ɨ lɛ sɨ kùꞌùsə̀ ghaꞌatə nɨ̂ ghàꞌàtə̀ ŋ̀ghɛɛ nɨ mbìì; ǹnɔ̀ɔ mbâŋnə̀ bo bɨ̀ yì bâŋgyɛ̀ ɨ zî ǹkuu ŋ̀kuꞌusə nɨ̂ ǹdùù waa. ");
INSERT INTO bfd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɨ̀nnù jya jìi mə ŋgǎŋntoo Kristo jya ɨ lɛ sɨ ghɨ̀rə̀ aa, ɨ ghɨrə̂ bə̀ tɨgə̀ beꞌe nɨ̂ ŋ̀gàŋmɨghɔ̀ɔ̀ m̀fɛꞌɛ nnɔ̀ŋsə̀ nɨ a bɨ̂ndômânjì a nɨ mɨkuu bo bɨ a nɨ bɨ̀matà, ta bɛɛ mə Peta a tɛꞌɛ tɨ tsyǎ tsyǎ, àlɨləŋə̂ yi a wô a nu bǐ mɔꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bə̀ lɛ sɨ kɨɨ nlo nɨ mum ɨlaꞌa jìi mə ɨ lɛ ntswe a mbɛ̀ɛ̀ Yerusalem aa mfɛ̀ꞌɛ̀ ǹzi nɨ̂ ŋ̀gàŋmɨghɔ̀ɔ̀ bo bɨ̀ bə̀ bìi mə bɨ lɛ ntswe nɨ̂ ɨ̀zwì jî bɨ̂ aa, ǹzì bɨ ghurə̀ nɨ̂ waa bɨ tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ǹgàŋmàꞌa Nwì yî ŋwè bo bɨ̀ ŋ̀gàŋəkòrə̂ ji, jìi mə ɨ lɛ ŋkɨ bə ŋgǎŋ ghotə baSadukai bìi mə bɨ lɛ tswe maa nɨkurə aa, lɛ nluu nɨ̂ àghə̀ꞌə̀nə̀ ǹloŋ ŋgǎŋntoo jyâ; ǹtɨgə nlɔɔ ŋghɨ̀rə̂ ànnù a nu bo. ");
INSERT INTO bfd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bo lɛ ntɨgə ntswa ŋgǎŋntoo jya ŋghɛ̀ɛ̀ ǹnɨŋə waa a ndâtsaŋə̀. ");
INSERT INTO bfd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lâ a ghɨrə̀ m̀bə nɨ̂tugə angel M̀màꞌàmbi a zî ŋ̀ŋaꞌa ɨbàꞌa ndâtsaŋ ya m̀fiꞌisə waa, nswoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nɨ̀ ghɛɛ ŋghɛ̀ɛ̀ ǹtəə a mûm ǹdâmàꞌanwì ŋkɛꞌɛnə annù tsɨ̀m nloŋ ntswêntɨ̀ɨ̀ yî mfii yuà mə. ");
INSERT INTO bfd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bo yùꞌù mə̂ laà, àbɛ̀ɛ̀ a fuꞌu, bo tɨgə̀ ŋ̀ghɛɛ wa a ndâmàꞌanwì tsiꞌì a tɨ̀tugə tɨ̀tugə, ŋ̀ka ndɨꞌɨ nɨ̂ ànnù Nwî a mbo bə̀ ghu.” Ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè a zî bo bɨ̀ ŋ̀gàŋəkorə̂ jɨ tsɨ̀m twoŋə̀ ǹghòtə bɨ̀lɨ̀ɨ bɨ àlaꞌa baYuda bɨtsɨ̀m, ta tâ ŋ̀gǎŋSenendrio tsɨ̀m tâ bɨ̀ boontə. Bɨ bòòntə̀ mə̂, ntoo bə̂ mə tâ bo ghɛɛ mfiꞌi ŋgǎŋntoo jya wa ndâtsaŋ zi nɨ ju. ");
INSERT INTO bfd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ŋ̀gǎŋfàꞌà jya mə bɨ lɛ ntoo aa ɨ ghɛ̀ɛ̀ mə̂, ŋ̀ghɛɛ kaa waꞌa ŋgǎŋntoo jya wa a ndâtsaŋ yə̂, ǹtɨgə mbu mbɨ̀ɨ̀ ǹswoŋ mə: ");
INSERT INTO bfd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Bìꞌì ghɛɛ nyə bɨ naŋsə̀ m̀fɨɨŋkə ɨ̀bàꞌa ndâtsaŋ jyâ tsɨ̀m, ŋ̀gǎŋmbɛ̂ ɨ̀dɨ̀gə̀ ɨ kɨ̂ ǹtəəntə ghu mbɛ nɨ mɨ̀ntsù mɨ ɨ̀bùꞌù myâ. Bìꞌì ghɛɛ̀ ŋ̀ŋaꞌa ndâtsaŋ ya kaa waꞌà ŋû ghu bâŋnə̀ yə̂.” ");
INSERT INTO bfd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tamândoò ŋ̀gǎŋmbɛ̂ ǹdâmàꞌa Nwì bo bɨ̀ bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌanwì bo yùꞌù mə̂ laà, ànnù a tsyâ waa, bo tɨgə̀ ŋ̀waꞌa mə kə̀ ma yû ànnù ka yǐ bə aa mə akə lɛ. ");
INSERT INTO bfd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ŋù yî mɔꞌɔ a zî ǹswoŋ a mbo mə, “Bə̀ bya mə nɨ̀ kɨ̀ nɨ̌ŋ a atsaŋ aa bo təə a mûm ǹdâmàꞌanwì ǹdɨꞌɨ nɨ̂ ànnù a mbo bə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tamândoo wa bo bɨ̀ ŋ̀gǎŋbɛ̂ ǹdâmàꞌanwì jya bo ghɛ̀ɛ̀ ǹlɔgə waa tsiꞌì à bɔɔ̀ bɔɔ, kaa waꞌà bə nɨ̂ mɨ̀dàꞌà lɔgə̀ bə̂, ǹloŋ mə bo lɛ sɨ bɔꞌɔ nɨ mə mbə bə̀ bɨ tumtə̀ waa nɨ̂ ŋ̀gɔ̀ꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bo tswà mə̂ waa nzi nɨ bu, ǹtɛꞌɛ wa a nsi Senendrio. Ŋ̀gàŋmàꞌa Nwì yî ŋ̀wè a betə̀ waa mə ");
INSERT INTO bfd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tɨgə bìꞌì kɨ̀ baa nswoŋ a mbo bù, ŋ̀kwantə mə tâ nɨ̀ tsuu annù nɨ̂ ɨ̀kǔm ŋû ghû kɨ dɨ̀ꞌɨ̀ aa ɛ? Yə nɨ̀ a ajàŋ yìi mə ànnù ya mə nɨ dɨ̀ꞌɨ̀ aa, a bàŋnə̀ mə nsɛɛnə a Yerusalem tsɨ̀m! Tɨgə nɨ lɔ̀ɔ̀ aà ǹnɨŋə̀ àləə ŋû ghû a atu bìꞌì?” ");
INSERT INTO bfd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Lâ Peta bo ŋgǎŋntoo jǐ mɔꞌɔ jya bo kwiꞌi mə, “A bɔŋ a nyuꞌunə Nwì ǹtsyatə bə̂.” ");
INSERT INTO bfd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nwìŋgɔ̀ŋ Ta bɨ̀ bɨ̀taà biꞌi à lɛ nyweensə Yesu wa yìi mə nɨ̀ lɛ ŋkwèèntə̀ yi a atibàŋnə̀bàŋnə̀ ǹzwitə yi aà. ");
INSERT INTO bfd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nwì a lɛ ŋŋɛntə yi a ndəŋ ntswesə yi a mbɛ̀ɛ̀ nɨ̀kwɛɛ yu nî màꞌà, a tɨgə̀ bə̂ Ŋ̀gàŋntsyàsə bə̀ ŋ̀kɨ mbə Ŋgàŋyweensə bə̀, ɨ ghɨrə mə tâ bàIsrael tâ bo bəŋkə mîntɨɨ̀ myaa tâ Nwì à liꞌinə ɨfansənnù jyaa. ");
INSERT INTO bfd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bìꞌì nɨ bɨ̀yəfə nɨ̂ ɨ̀nnù ma jû, Àzwì yî Làà yìi mə Nwì à fa a mbo bə̀ bìi mə bɨ yuꞌunə nìi aa a kɨ̂ m̀bə ayəfə. ");
INSERT INTO bfd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bo yùꞌù mə laà mɨ̀ntɔ̂ŋ myaa mɨ lwî, bɨ lɔɔ̀ mə bɨ zwitə ŋgǎŋntoo jyâ. ");
INSERT INTO bfd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lâ ŋù baFarɨsai yî mɔꞌɔ a tɨtɨ̀ɨ bo ŋ̀gàŋSenendrio, ɨ̀kǔm yi ɨ bə Gamaliel, ǹdɨ̀ꞌɨ nɔ̀ŋsə Moses yìi mə bə̀ bɨ̀tsɨ̀m bɨ lɛ sɨ yuꞌunə aa, a təə̀ a ndəŋ ǹswoŋ bɨ ghɨrə̀ ŋ̀gǎŋntoo jya fɛꞌɛ̀ a abɛɛ a nɨ mû àtɨɨ noò. ");
INSERT INTO bfd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bo fɛ̀ꞌɛ̀ mə̂, a swoŋ a mbo ŋgǎŋSenendrio bya mə, “BaIsrael, nɨ̀ tsyɛsə ghuu nɨ̂ ànnù yìi mə nɨ lɔ̀ɔ a ŋghɨ̀rə̀ a nu bə̀ buà aà. ");
INSERT INTO bfd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","À kɨ̀ lɛ mbə a noò mɔꞌɔ Tadeous a bɨɨ̀nə̀ ǹswoŋ mə yu nɨ ŋù yì ŋwè yî tsù, m̀bâŋnə̀ jî mɔꞌɔ tsǒ ŋkhɨ̀ ji nɨ kwà, ɨ ghɛɛ̀ ǹtsitə yi. Lâ bɨ yî ǹzwitə yi, bə̀ bya mə bɨ lɛ sɨ yòŋə̀ ghu njɨ̀m aa bɨ sɛ̀ɛ̀nə̀ waa, kaa ŋ̀ghòtə̂ yì ya kaa ɨ waꞌà nɨ̂ ànnù yî tsu fɛꞌɛ̀. ");
INSERT INTO bfd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","À ghə̀ mə tɨ bə a noò ǹjɨ̀m, Judas, mu baGalilea, a kɨ̂ mfɛꞌɛ yìi ŋgaa, wa noò ǹsəŋ bə̂, ŋ̀ghɨrə ǹnɔ̀ɔ̀ bə̂ ɨ kɨɨ̀ ǹyoŋə ghu njɨ̀m. Judas ma ghû à lɛ ŋkwo, ǹnɔ̀ɔ̀ bə̂ bya mə ɨ lɛ sɨ yòŋə̀ nìi laa ɨ lɛ ŋkɨ nsɛɛnə waa. ");
INSERT INTO bfd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","A ŋghɛ̀ɛ a nɨ yuà ànnù, mə̀ swǒŋ a mbo bù mə tâ nɨ̀ tsuu ànnu yî tsu a nu bə̀ bû lǒ ghɨ̀rə̀ bə̂, tâ nɨ̀ fiꞌisə abô yuu a nu bo. M̀bə ànnù yìi mə bo lɔ̀ɔ ŋghɨ̀rə aa, a bə aa ànnù yìi mə a kàꞌa ŋùmɨ̀sɔ̀ŋ boŋ a ka wò. ");
INSERT INTO bfd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lâ bɛɛ a bə yìi mə ànnù yìi mə bo lɔ̀ɔ ŋghɨrə aa, a lo aa a mbo Nwì boŋ kaa mbə nɨ̀ waꞌà mânjì a mbo bo kɨɨ bə̂. M̀bə nɨ̀ ghaꞌa ghuu a nu bo boŋ mbə a tɨgə̀ m̀baŋnə mfɛ̀ꞌɛ̀ mə nɨ to aa bǔ bɨ̀ Nwì.” ");
INSERT INTO bfd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliel à ghàà mə̂ laà, baSenendrio bya bɨ yuꞌù àdɨꞌɨtə̀ yi yâ, ǹtwoŋə ŋgǎŋntoo jya ɨ kuu nzi, bo ghɔɔ̀ waa, ǹswoŋ a mbo bo ŋkwantə mə tâ bo tsuu ànnù nɨ̂ ɨ̀kǔm Yesu bu kɨ dɨ̀ꞌɨ̀ bə̂; ǹtɨgə mmaꞌatə waa mə tâ bo ghɛɛ waa. ");
INSERT INTO bfd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ŋ̀gǎŋntoo jya bo fɛꞌɛ̀ wa a tɨtɨ̀ɨ baSenendrio jya, ǹtɨgə ndorə ŋghɛɛ nloŋ mə Nwì à lɛ nlèntə̀ waa nyə mə bo kuꞌunə a ŋkwɛrə ǹdɨ̀rə̀tu ǹloŋ ɨ̀kǔm Yesu aà. ");
INSERT INTO bfd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bo fɛ̀ꞌɛ̀ ŋ̀ghɛɛ nɨ̂ m̀bìì ǹtɨgə ndɨꞌɨ nɨ̂ bə̂, ǹsɛɛnsə nɨ̂ ǹtɔɔ yì nsɨgɨ̀nə̀ ǹswoŋə nɨ a mbo bo mə Yesu à nɨ yu wa yìi mə Nwì à yɔ̀ꞌɔ̀ aà, tsiꞌì ǹjwî tsɨ̀m, a mûm ǹdâmàꞌanwì bo bɨ̀ a mɨlaꞌa bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma mùu noò, ǹdùu ŋgǎŋyəgə̂nnù Yesu ɨ lɛ sɨ ghaꞌatə ŋghɛɛ nɨ̂ m̀bìì. Àyɔ̀ŋə̀ a lɛ mfɛ̀ꞌɛ̀ a tɨtɨ̀ɨ bo, baYuda bìi mə bɨ lɛ sɨ ghàà nɨghàà nɨ Grikia aa bo lɛ sɨ ghààntə̀ nɨ̂ baYuda bìi mə bɨ lɛ ntswe a ndùgə̀ ǹloŋ mə kaa bɨ lɛ sɨ waꞌà nɨ̂ bɨ̀kwìꞌì bɨ bâŋgyɛ̀ byaa lêntə̀ a mfa myaa mɨjɨ̂ bo bɨ̀ ǹjoò tsɨ̀m jìi mə bɨ lɛ sɨ yàtə̀ a njwî tsɨ̀m aà. ");
INSERT INTO bfd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ŋ̀gǎŋyəgə̂nnù jya nɨ̀ghûm ǹtsò baa ɨ lɛ ŋghotə ŋgǎŋyəgə̂nnù jya ji mɔꞌɔ ɨ̀ tsɨ̀m, ǹswoŋə a mbo bo mə, “Kaa a sɨ̀ bɔ̂ŋ mə tâ bìꞌinə̀ maꞌatə a nswoŋə ànnù Nwî m̀baŋnə ŋghɛ̀ɛ̀ ŋ̀ka nyatə mɨjɨ̂. ");
INSERT INTO bfd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bɔɔ bɨ maà, a kuꞌunə mə tâ nɨ̀ lentə a tɨtɨ̀ɨ bù, ǹtsɔꞌɔtə mbâŋnə̀ ji sàmbaa jìi mə bɨ beentə nɨ̂ waa, tâ à bə bə̂ bìi mə bɨ luu nɨ̂ Àzwì bo bɨ̀ nɨ̀ mɨ̀tsyɛ̀, tâ bìꞌinə̀ fa ɨfàꞌà ma ghû a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bìꞌinə̀ ka bàŋnə fa ɨbɨ̀ɨnû yìꞌinə̀ tsɨ̀m a ntsàꞌàtə Nwì bo bɨ̀ a nswoŋə ànnù Nwî.” ");
INSERT INTO bfd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ànnù ma yû a lɛ mbɔŋ a nu bə̀ bya bɨ̀ tsɨ̀m, bo tɨgə̀ tsɔꞌɔ Stephen, ŋù yìi mə à lɛ nluu nɨ̂ àbìintɨɨ bo bɨ̂ Àzwì Nwî, nɨ Philip, nɨ Prochorus, nɨ Nicanor, nɨ Timon, nɨ Parmenas, nɨ Nicolaus, mu baAntiokia yìi mə a lɛ ntɨgə bəŋ mbə ŋû baYuda aà. ");
INSERT INTO bfd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bɨ lɛ twoŋ bə̂ ma bû, ǹtɛꞌɛ waa a nsi ŋgǎŋtoo Kristo jya, ǹnɔ̀ŋsə̀ mbo a atu bo, ntsaꞌatə Nwî a atu bo. ");
INSERT INTO bfd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ànnù Nwî a lɛ ntɨgə nsɛɛnə ŋghɛ̀ɛ̀ nɨ̂ m̀bìì, ǹdùu ŋgǎŋyəgə̂nnù Yesu a Yerusalem ɨ kuꞌùsə̀ ŋ̀ghaꞌatə tsiꞌì ànnù, ǹgǎŋmàꞌa Nwì jî ghàꞌàtə̀ ɨ nɨ̂ŋ mɨ̀ntɨɨ̀ myaa a nu Kristo ntɨgə yuꞌunə nɨ̂ ànnù yi. ");
INSERT INTO bfd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen yìi mə à lɛ nluu nɨ̂ ɨ̀bɔ̀ŋ bo bɨ̂ mɨ̀dàꞌà mɨ Nwî aa, à lɛ sɨ ghɨ̀rə̀ nɨ̂ ɨ̀nnǔtsyâmbo bo bɨ̂ ɨ̀lènsə̀ jî wè a tɨtɨ̀ɨ bə̀. ");
INSERT INTO bfd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lâ bə̀ bî mɔꞌɔ bɨ lɛ nlɔ̀gɨ̀nə̀ ŋ̀ka nlɨgɨtə nɨ̂ ànnù yìi mə Stephen à lɛ sɨ swoŋə ŋkɨɨ ŋghɨ̀rə̀ aà; bɨ lɛ mbə bǎndâŋghòtə baYuda (yìi mə bɨ lɛ sɨ twoŋə nɨ yì bə̀ bìi mə bɨ fɛꞌɛ a ndâbùꞌù aa), ǹlo a Cyrene bo bɨ Alexandria. Ma buù bə̀ nɨ bî mɔꞌɔ bìi mə bɨ lɛ nlò a Cilicia bo bɨ̀ a Asia aa, bɨ lɛ nlɔ̀gɨ̀nə̀ ǹtɨgə nyɔŋə bo bɨ̀ Stephen. ");
INSERT INTO bfd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lâ Azwì Nwì a lɛ mfa mɨ̀tsyɛ̀ a mbo Stephen nɨ mânjì yìi mə à lɛ ghàà m̀burə ŋkutə mɨ̂ntsǔ myaa. ");
INSERT INTO bfd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bo tɨgə̀ ŋ̀ŋeꞌesə ŋghɛɛ ntotə bə̂ mə tâ bɨ̀ swoŋ mə, “Bìꞌì lɛ nyuꞌu a ghàà nɨ nɨ̀ghàà nɨ atsaꞌa mbə̀gɨ̀tə̀ nɨ̂ Moses bo Nwì ghu.” ");
INSERT INTO bfd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bo ghɨrə̀ bə̀ bo bɨ̀ bɨ̀lɨ̀ɨ bɨ alaꞌa, nɨ ŋ̀gǎŋdɨ̀ꞌɨ nɔ̀ŋsə̀ lwîsə̀ ntɔ̀ŋ ŋ̀ghɛɛ tswa Stephen ǹlɔgə ŋghɛ̀ɛ̀ nɨ ghu a nsi baSenendrio ");
INSERT INTO bfd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ǹlɔɔ bə̂ mə tâ bo zi mbə bɨ̂yəfə, ŋ̀ghɨrə bo fɛꞌɛ̀ ǹtəə ǹtswɛɛ ɨbǎŋnənnù ǹswoŋ mə, “Ŋù ghuà a ghàà mɨghàà mî bɨ, m̀bəgɨtə nɨ̂ àdɨ̀gə̀ Nwî yû bo bɨ nɔ̀ŋsə̀ ghu. ");
INSERT INTO bfd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ǹloŋ mə bìꞌì lɛ nyuꞌu a swoŋə̀ nɨ mə Yesu mu baNazareth wa a ka yi sàꞌa adɨgə yû, ɨ kɨɨ kwensə bɨ̂nɔ̀ŋsə̀ bya mə Moses à lɛ mfa a mbo bìꞌinə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bə̀ bya bɨ̀tsɨ̀m mə bɨ lɛ ntswe wa ndâ Senendrio aà, bɨ lɛ ŋghəə kɨ lə̀ntə̀, ǹyə ǹsi Stephen ɨ bəŋ ntɨgə mbə tsǒ nsi angel. ");
INSERT INTO bfd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ŋ̀gàŋmàꞌa Nwì yî ŋwè a betə̀ Stephen mə, “Àa tsiꞌì ànnùnɨ̂ ŋkoŋ mə bɨ swoŋ laà lɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen a swoŋ mə, “Yuꞌutə̂ nɨ̀ bɨ̂taà nɨ bɔɔ bɨ maà, Nwì yìi mə a ŋwèènə̀ aà, à lɛ mfɛ̀ꞌɛ̀ ǹtsiꞌi taà yiꞌinə̀ Abraham, wa a noò wa mə à lɛ ntswe a Mesopotamia aa, maà noò kaa a burə tɨ̀ a Haran ka ǹtswe, ");
INSERT INTO bfd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ǹswoŋ ghu mbo mə, ‘Màꞌàtə alaꞌà yuu bo bɨ̀ ŋ̀gwɛ̀ꞌɛndâ ghô, m̀fɛꞌɛ ŋghɛ̀ɛ̀ a adɨgə yìi mə mə̀ ka fɨ̀gɨ̀tə̀ a mbo wò aà.’ ");
INSERT INTO bfd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","A tɨgə̀ maꞌatə alaꞌa baKaldea, ŋ̀ghɛɛ ntɨgə ntswe a Haran. Taà yì à lɛɛ̀ ŋ̀kwo, Nwì a ghɨrə̀ yi a fɛꞌɛ̀ ǹzi fàa alaꞌa yuà mə nɨ̀ tswe ghu tsɨ̂tsɔ̀ŋ aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kaa Nwì kaa à lɛ ŋwaꞌa adɨgə nsyɛ ghu mbo fa mə tâ à bə̂ yi bə̂; kàa tsiꞌì mû àdɨ̀gə̀ yìi mə à ghàꞌàtə mbə ntɛꞌɛ̀ àkòrə̂ yi ghu aa bə̂. Lâ Nwì à lɛ ŋkàꞌà mə yu ka yǐ fa alaꞌa mà yû ghu mbo tâ tɨgə mbə̂ à yi bo bɨ̀ à yi bɔɔ̀ bi bìi bɨ ka yǐ yòŋ ghu njɨ̀m aà, ka mə a lɛ sɨ bə maà noò kaa a waꞌà nɨ mu tswe aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nwì à lɛ nswoŋ ghu mbo aa mə, ‘m̀fòrə̀ yì ɨ̀ ka yǐ ghɛɛ bə bɨ̂gɨ̀ɨ̀ a alaꞌa badàŋ tâ bɨ̀ ghɨrə waa nɨ̂ ɨ̀bùꞌû jyaa, ɨ dɨ ŋgɨꞌɨ a mbo bo ɨlòò ŋkhɨ̀ ji nɨ kwà.’ ");
INSERT INTO bfd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nwì a swoŋ mə, ‘Lâ mə̀ ka yǐ nɨŋ ɨsaꞌa a nu bə̀ bìi mə bo ka yǐ ghɨ̀rə̀ waa nɨ̂ ɨ̀bùꞌù aà, a yi tɨ bə a njɨ̀m boŋ bo ka yi fɛ̀ꞌɛ zǐ mmii gha fàa adɨgə laà.’ ");
INSERT INTO bfd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nwì a lɛ ŋwàrə akàà bo Abraham ǹləə annǔ ŋŋètə bɔɔ mbâŋnə̀ tsǒ alènsə̀. Abraham a jwe Isaac ǹtɨgə ŋŋetə yi a nɨ̂ ǹjwi ji nɨfwaà. Isaac a jwî Yakob, Yakob yìi ŋgaa a tɨgə̀ ǹjwe bɨ̂tà bɨ ŋgwɛ̀ꞌɛ̀ biꞌinə̀ bya nɨ̀ghûm ǹtsò baà. ");
INSERT INTO bfd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Bɨ̀tabê biꞌinə̀ bɨ lɛ ntswe nɨ̂ àghə̀ꞌə̀nə̀ a nu Joseph, m̀fee yi a alaꞌa Egipto, lâ Nwì a tswə̂ bo yu, ");
INSERT INTO bfd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","m̀fiꞌi yi a mûm ŋ̀gɨꞌɨ, m̀fa mɨtsyɛ ghu mbo ŋghɨrə Pharoah M̀fɔ̀ baEgipto a kɔŋə̀ yi ǹtɨgə ghɨrə a bə Gûmnàà, ǹtɨgə nsaꞌa nɨ̂ àlaꞌa baEgipto bo bɨ̀ ndâ Pharoah ntsɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ǹjì ɨ̀ lɛ ŋkuu a alaꞌa baEgipto tsɨ̀m bo bɨ̀ a alaꞌa Cana, ǹnɨŋ ŋgɨꞌɨ yì ŋ̀wè a nu bə̀, ŋ̀ghɨrə bɨ̀taà biꞌinə̀ bɨ tɨgə̀ ǹlɔɔ nɨ̂ mɨ̀jɨ kɨkaŋ. ");
INSERT INTO bfd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakob a yuꞌu mə mɨjɨ mɨ lɛ tswe a alaꞌa baEgipto, ǹtoo bɨ̂taà biꞌinə̀ ghu a ŋgaa yî ǹtsyàmbìì. ");
INSERT INTO bfd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bo bù mə̂ ŋ̀ghɛɛ ghu a ŋgaa yìi ɨ̀ yòŋtə aa, Joseph a ghɨrə̀ bɔɔ bɨ maà bi bɨ zî yi, ŋ̀kɨ ŋghɨrə Pharoah a zî ŋgwɛ̀ꞌɛ̀ yì. ");
INSERT INTO bfd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Joseph a swoŋ mə tâ bɨ̀ ghɛɛ ntwoŋ taà yì Yakob bo bɨ̀ ŋ̀gwɛ̀ꞌɛ̀ yǐ ntsɨ̀m, ɨ̀tu bə̂ mɨghum mi sàmbaa ntsò ntaà. ");
INSERT INTO bfd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakob a sɨgə ŋghɛ̀ɛ̀ a alaꞌa baEgipto, ǹyi ŋkwo ghu, yubɔŋ bo bɨ̀ bɨ̀taà biꞌinə̀, ");
INSERT INTO bfd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","bo kwò mə̂ ghu, bɨ bèꞌè ɨ̀kû jyaa ŋkɔꞌɔ nɨ ju a Shechem, ǹtwiŋə waa wa nɨsyɛ̀ nya mə Abraham a lɛ nyuu nɨ ŋkabə a mbo bɔɔ bɨ Hamor a Shechem aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Lâ nòò à kà mə̂ ŋ̀kuꞌu mə tâ Nwì tâ ghɨrə ànnù yìi mə à lɛ ŋkàꞌà a mbo Abraham aa, ǹdùù bə̂ biꞌinə̀ a alaꞌa Egipto ɨ burə̀ ŋ̀ghaꞌàtə tsiꞌì ghàꞌatə̀ ŋ̀ghɛɛ nɨ̂ m̀bìì ");
INSERT INTO bfd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ǹyweꞌe a noò yìi mə mfɔ̀ yî mɔꞌɔ yìi mə kaa à lɛ ŋwaꞌà Joseph zi aa, à lɛ ŋkɔꞌɔ ntɨgə nsaꞌa nɨ̂ àlaꞌa baEgipto. ");
INSERT INTO bfd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A lɛ ntaŋə mɨ̂nàŋ a atu bə̂ biꞌinə̀, ǹdɨ ŋgɨꞌɨ a nu bɨ̀taà biꞌinə̀ ǹtswa nɨ̂ waa nɨ̂ àdàꞌà mə tâ bo meꞌe bɔɔ̀ byaa a abɛɛ mə tâ bɨ̀ kwokə. ");
INSERT INTO bfd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","À lɛ mbə aa ma mùu noò mə bɨ lɛ njwe Moses, a burə̀ m̀bə tsiꞌì mu yìi mə à lɛ mbɔŋ a yə ŋkɨ bɔŋ a nsi miꞌi Nwì aà. Bɨ lɛ ŋkoꞌo yì a ndùgə bo a nɨ bɨ̀sàŋ bi tarə̀. ");
INSERT INTO bfd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nòò wa yìi mə bɨ lɛ nlɔ̀gə̀ yì a ndùgə bo mfɛꞌɛ ŋghɛ̀ɛ̀ ǹləə a abɛɛ a adɨgə dàŋ aa, mu Pharoah yî màŋgyɛ̀ a lɔgə̀ yi nɨ mû yì ǹtɨgə ŋkoꞌo yi. ");
INSERT INTO bfd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bɨ lɛ ndɨ̀ꞌɨ̀ yi nɨ mɨ̀tsyɛ̀ mɨ baEgipto mɨ tsɨ̀m, a naŋsə̀ ǹzi nɨghàà tsiꞌì sɨgɨ̀nə̀ ŋ̀kɨɨ ŋghɨrə nɨ̂ ɨ̀nnù jî wè jî wè. ");
INSERT INTO bfd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nòò yìi mə Moses à yì mə mbə ɨlòò mɨghum mi nɨkwà aa, ŋ̀waꞌatə mə yu ghɛɛ ghantə bɔɔ bɨ maà bi, bɔɔ bɨ baIsrael. ");
INSERT INTO bfd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","À ghɛ̀ɛ̀ mə̂, ǹyə ŋû baEgipto a kâ ŋ̀ku nɨ mu maà yì yî mɔ̀ꞌɔ. À yə̀ mə̂ laa, ŋ̀ghɛɛ a ŋkwiꞌinə̂, ǹtswa ŋû baEgipto wa ŋkù ǹzwitə nloŋ ŋgɨꞌɨ ya yìi mə à lɛ sɨ nɨŋ a nu mu maà yì ŋù baIsrael wa aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","À lɛ sɨ ghɨ̀rə̀ laa ŋwaꞌatə nɨ mə bɔɔ bɨ maà bi bɨ ka zi mə Nwì ka kwɛtə tâ yù fiꞌi waa wa a mûm ŋ̀gɨꞌɨ̀, lâ kaa bo waꞌà zî. ");
INSERT INTO bfd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Àbɛ̀ɛ̀ fùꞌù mə a zî ǹyə bɔɔ baIsrael bî mɔꞌɔ bɨ kâ ǹyɔŋə, a lɔɔ̀ mə yu fààtə̀ waa tǎ tâ bo tsuu kɨ yɔ̀ŋə̀, ǹswoŋ mə, ‘Bɨ̀sû bâ, nɨ̀ tsuu kɨ to, tɨgə nɨ̀ laa mbə bɔɔ bɨ ma aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lâ ŋù wa yìi mə à lɛ nlɔ̀gɨ̀nə̀ fɨkɔ̀rə̀ fya aa, a tiì Moses lɔ̀ꞌɔ̀sə̀ m̀betə ghu mbo mə, ‘A gho aà a lə̀ə wò mə ta ò tɨgə mbuꞌutə yiꞌi ŋkɨɨ ntsɔꞌɔtə nɨ̂ mɨ̀saꞌà miꞌi aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","O bù ǹlɔɔ aa nzwìtə mə̀ tsǒ mə ò kɨ̀ zwìtə ŋû baEgipto wa a yɔɔ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","À kwìꞌì mə̂ laà, Moses a fɛꞌɛ̀ wa alaꞌa baEgipto ŋ̀khə ŋghɛ̀ɛ̀ a alaꞌa Midia ǹtɨgə ntswe ghu nɨ̂ ŋ̀gɨ̀ɨ̀, ǹjwe bɔɔ mbâŋnə̀ ghu bi baà. ");
INSERT INTO bfd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ɨ̀lòò mɨghum mi nɨkwà ɨ̂ tsyà mə̂, angel Nwìŋgɔ̀ŋ a zî ǹtsiꞌi Moses, ǹtswe a mum àtsùgə ɨti yìi mə mɔꞌɔ ɨ lɛ sɨ bərə ghu aa, a ntaꞌa mɨwɛ̀ɛ̀ wa a mbɛ̀ɛ̀ ǹtaꞌa Sinai. ");
INSERT INTO bfd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses à yə̀ mə̂, ànnù a burə̀ ǹtsya yi, a ghɛ̂ntə a ntəə ghu mbɛ̀ɛ̀ ta naŋsə lèntə̌ yə. À kà mə̂ aa ŋghɛɛ ghu nyuꞌu njì M̀màꞌàmbi a swoŋ mə, ");
INSERT INTO bfd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mə̀ nɨ Nwìŋgɔ̀ŋ bɨ̀ taà buu, Nwɨ̀ŋgɔ̀ŋ Abraham, yì Isaac, nɨ yì Yakob.’ Moses yùꞌù mə̂, nû yì ɨ swerə̀, a tɨgə̀ m̀benə baꞌà bàꞌà; kaa a waꞌà nɨ̂ ǹtɨɨ bu ntswe a lèntə̂ àdɨ̀gə̀ yâ. ");
INSERT INTO bfd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","M̀màꞌàmbi a swoŋ ghu mbo mə, ‘Tsɔꞌɔtə ntam jo jyâ, ǹloŋ mə àdɨ̀gə̀ yuà mə ò təə ghu aa, à nɨ̂ àdɨgə nsyɛ yî làà maŋsə. ");
INSERT INTO bfd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wa mə̀ lìì mə̂ ǹyə mbuu ŋgɨꞌɨ yìi mə bə̂ ba a alaꞌa baEgito bɨ yə aà. Mə̀ yùꞌû àjàŋ yìi mə bo yə̀ꞌə ŋgɨꞌɨ yàà aa, ǹsɨgə nzi a fiꞌi bo wa mûm ŋ̀gɨꞌɨ̀. Zì faà la tsɨ̂tsɔ̀ŋə̀. Mə̀ ka too gho a alaꞌa baEgito.’ ");
INSERT INTO bfd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“À lɛɛ̀ ŋ̀kɨ mbə aa tsiꞌì Moses ma ghû mə bɔɔ bɨ maà yì lɛ ntuu, m̀betə ghu mbo mə, ‘A gho aà a lə̀ə wò mə tâ ò tɨgə mbuꞌutə yiꞌi ŋkɨɨ ntsɔꞌɔtə nɨ̂ mɨ̀saꞌà miꞌi aa ɛ?’ mə Nwì à lɛɛ̀ ǹtoo mə tâ ghɛɛ ŋka nsaꞌa nɨ̂ bɔɔ baIsrael, ɨ kɨɨ fiꞌisə waa a mûm ŋ̀gɨꞌɨ̀. Angel wa mə à lɛ nzì ǹtsiꞌi yi wa mûm àtsùgə ŋ̀gɛ̀ɛ̀ mə a lɛ sɨ khɨ aa, a tswê ghu mbo, ŋ̀kwɛtə nɨ̂ yi. ");
INSERT INTO bfd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","À nɨ Moses ma ghû mə à lɛ ghɨ̀rə ɨlensə ɨnnù bo bɨ̀ ɨ̀nnǔtsyâmbo a alaꞌa baEgipto bo bɨ̀ wa Mɨyaa yî m̀bagɨtə bo nɨ a antaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ a atû ɨ̀lòò mɨghum mi nɨkwà. ");
INSERT INTO bfd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","À nɨ Moses ma ghû mə à lɛ nswoŋ a mbo bɔɔ baIsrael mə, ‘Nwì à ka yǐ ghɨ̀rə tâ ŋ̀gàŋtoò yì yî mɔ̀ꞌɔ tsǒ mə̀ tâ bu mfɛ̀ꞌɛ̀ a tɨtɨ̀ɨ bɔɔ bɨ maà buu aà.’ ");
INSERT INTO bfd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","À nɨ yu mə à lɛ ntswe bo bɨ̀ ŋ̀ghòtə̂ bɔɔ baIsrael bya wa antaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ ŋ̀kɨ tswe bo bɨ̀ bɨ̀taà biꞌinə̀, a bɔ̀ꞌɔ angel wa mə à lɛ ŋghàà ghu mbo a ntaꞌa Sinai aà. À lɛ ŋkwɛrə ntoò Nwì yìi mə ɨ fa ntswêntɨ̀ɨ̀ a mbo bə̀ aa, a mfa a mbo bìꞌinə̀. ");
INSERT INTO bfd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lâ bɨ̀taà biꞌinə̀ bɨ lɛ ntuu a yuꞌunə yi, ǹtuu yi, ŋ̀kwensə ntɨɨ̀ waa, m̀bəŋ m̀bu tɨgə nlii nɨ̂ m̀bɨ̀ɨ̂ waa fu a alaꞌa baEgipto; ");
INSERT INTO bfd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ǹtɨgə nswoŋ a mbo Aaron mə, ‘Ghɨ̀rə bɨ̂nwì m̀fa a mbo bìꞌì tâ bɨ̀ ka ŋghɛɛ nɨ a mbìi bìꞌì, ǹtsyasə nɨ̂ yiꞌi. Kaa bìꞌì sɨ̌ annù yìi mə a ghɨrə Moses ghû yìi mə à lɛ ntsyàsə̀ yiꞌi bìꞌì fɛꞌɛ̀ a alaꞌa baEgipto aa zî.’ ");
INSERT INTO bfd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bo tɨgə̀ m̀bɔɔ fɨ̂ŋkobə fɨ bə tsǒ mû m̀bɔ̀ŋ ma mùu noò, ǹtɨgə nzwitə nɨ̂ naà m̀maꞌa nɨ̂ fɨ̀ŋkobə mà fû ghu, ǹtɨgə ndorɨtə nloŋ fɨ̂ŋkobə mà fû mə bo lɛ naŋsə nɨ̂ m̀bô myaa aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Laà, Nwì a tuù waa, m̀maꞌatə waa mə tâ bo fa ɨbɨ̀ɨ nû waa, ǹtɨgə ŋghaꞌasə nɨ̂ ǹtsǔ ntsò yìi mə ɨ tswe a aburə aà, ma yû a yôŋ aa ajàŋ yìi mə bɨ ŋwaꞌanə a mûm àŋwàꞌànə ŋgǎŋtoo Nwì aà: ‘Nɨ̀ lɛ mbaa nzwitə nɨ̂ naà a mmàꞌa mə̀ ghu wa atû ǹdùu ɨlòò jya mɨ̀ghum mi nɨkwà mə nɨ̀ lɛ ntswe ghu wa antaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀ aa ɛ, baIsrael? ");
INSERT INTO bfd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tɨgə nɨ̀ lɛ sɨ bèꞌè aa ǹtàŋ nwî Molok bo bɨ̀ fɨ̀ŋjɔ̀ŋ fɨ nwî Refən, mɨ̀ŋkobə mìi mə nɨ̀ lɛ nnaŋsə mə nɨ kɨ mii aà; ma mùu ajàŋ, mə̀ ka fiꞌi ghuu ɨ ghɨ̀rə tâ nɨ̀ fɛꞌɛ ŋghɛ̀ɛ̀ a mbii alaꞌa baBabilon.’ ");
INSERT INTO bfd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ǹtàŋ wa mə ɨ lɛ sɨ fɨ̀gɨ̀tə̀ nɨ mə Nwì a tswe bo bɨ̀ bə̀ bi aa, ɨ lɛ ntswe a mbo bɨ̀taà biꞌinə̀ wa antaꞌa mɨwɛ̀ɛ̀ mɨwɛ̀ɛ̀. Bɨ lɛ ghùrə̀ ǹyoŋ aa tsiꞌì àjàŋ yìi mə Nwì a lɛ mfɨ̀gɨ̀tə̀ a mbo Moses mə tâ à ghurə aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","À yì mə̂ tɨ bə a njɨ̀m bɨ̀taà biꞌinə̀ bo bɨ̀ Joshua bɨ tɨgə̀ ǹlɔgə ntàŋ ma ghû ŋ̀kuu nɨ ghu fàa alaꞌa, wa noò mə bɨ lɛ ntɨgə nzi kwɛrə ɨdɨgə ɨlaꞌa ɨtoo jya jìi mə Nwì à lɛ mfurə waa, bɨ fɛꞌɛ̀kə̀ aà. Ǹtàŋ wa ɨ lɛ ntɨgə tswe fàa alaꞌa nlɔ̀gɨ̀nə̀ aa maa noò ǹzi nyweꞌe a noò yìi mə David a lɛ mbə mfɔ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ǹsi David ɨ lɛ mbɔ̀ŋ bo Nwì a lɔntə̀ mə tâ Nwì tâ à maꞌatə tâ yù bɔɔ nda a mbo yu Nwì Yakob. ");
INSERT INTO bfd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lâ à lɛɛ̀ m̀baŋnə ntɨgə mbə aa bə Solomon mə Nwì à lɛ mbeentə mə tâ à tɨgə mbɔɔ nda ma yû ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Lâ Nwì yìi mə nɨ̂ Àkɔꞌɔ̀ntsɨrə aa, kaa sɨ aa mûm mɨ̀laꞌa mìi mə â bɔ̀ɔ bə̂ nɨ̂ m̀bô myaa aa tswe bə̂; ma yuù ànnù a yôŋ aa tsiꞌì nɨ nɨ̀ghàà nìi mə ŋ̀gàŋtoò Nwì à lɛ nswoŋ aa, mə, ");
INSERT INTO bfd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘M̀màꞌàmbî Nwìŋgɔ̀ŋ à swǒŋ mə, àbùrə̀ a nɨ̂ àbə̀rə̂ yâ, ǹsyɛ̂ ɨ bâŋnə̀ m̀bə akəꞌə ntɛtə ǹtsaꞌà jâ. M̀bə ò tɨgə̀ m̀bu naŋsə mbɔɔ aà àjàŋə nda yuu a mbo mə̀ aa ɛ? Àdɨ̀gə̀ yìi mə mbə mə̀ tswê ghu m̀mɨɨntə aa, a fə̀ aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tɨgə njoo mà jû tsiꞌì tsɨ̀m aa a lɛ nnaŋsə mə̀ aa ɛ?’ ");
INSERT INTO bfd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Nɨ̀ burə naŋsə ntɨɨ atu bə laà aa a ya aa ɛ? Mɨ̀ntɨɨ̀ muu mɨ burə mbə bə mì bɨ̂tɨ̀zi Nwî aa a ya aa ɛ? Nɨ̀ kùtə̂ ɨ̀tôŋnə̀ juu kaa waꞌà kɔ̀ŋ a nyuꞌù ǹtoò Nwì aa a ya aa ɛ? Nɨ kɨɨ ntɨɨ nɨ̂ àtu a mbo Àzwì Nwî tsɨ̂tsɔ̀ŋ aa tsiꞌǐ ajàŋ yìi mə bɨ̀taà buu bɨ lɛ sɨ ghɨ̀rə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ŋ̀gàŋntoò Nwì yî tsù à tswe ghu mə bɨ̀taà buu lɛ ŋwaꞌà àkòrə̂ yi ka ntsɔꞌɔ aa ɛ? Bo lɛ nzwitə ŋgǎŋntoo Nwî jya jìi mə ɨ lɛ nswoŋ, àghaꞌa â bùrə̀ mə̂ nsaꞌa ǹsàꞌà aa, mə yu wa yìi mə annû yi a tsinə aa à ka yǐ zì aà. Tsɨ̂tsɔ̀ŋ nɨ̀ kɨ̀ mə̂ m̀fee yi, ǹtswa yi nzwitə. ");
INSERT INTO bfd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tɨgə a lɛ ŋkwɛrə bu ŋkwɛrə nɔ̂ŋsə̀ Nwî wa mə baangel bɨ lɛ mfa a mbo bu aa ɛ? Lâ a ghɨ̀rə̂ àkə̀ kaa nɨ̀ waꞌà yuꞌunə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ŋ̀gǎŋsenadrio bya bɨ yùꞌù mə annù yìi mə Stephen à lɛ nswoŋ aa, mɨ̀tɔ̂ŋ myaa naŋsə̀ nlwinə, bɨ tɨgə̀ ŋ̀kurə nɨ mɨ̀sɔ̀ŋə̂ myaa ghu nû. ");
INSERT INTO bfd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lâ Àzwì Nwî yìi mə a laa màŋsə̀ aa, a lɛ ŋkuu lwensə Stephen, a tɛꞌɛ miꞌì mi ntɨgə nlii nɨ̂ àbùrə̀ ghu, à kà mə̂ aa nlii, nyə nɨghaꞌa nɨ Nwî nìi mə nɨ ŋwèènə̀ aa, ŋ̀kɨ nyə Yesu a təə a mbɛ̀ɛ̀ nɨ̀kwɛɛ Nwì nî màꞌà. ");
INSERT INTO bfd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","À yə̀ mə̂ laà, ǹswoŋ mə, “Yə̂ nɨ̀, mə̀ yə̂ àbùrə̀ a ŋaꞌanə̀, mə̀ yə Mu Ŋù a təə a mbɛ̀ɛ̀ nɨ̀kwɛɛ Nwì nî màꞌà!” ");
INSERT INTO bfd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bo yùꞌù mə̂ laà, ǹtɔŋnə mboꞌo, ǹlɔgə mbô myaa ŋkutə ɨtôŋnə̀ jyaa ghu, ǹywunə ŋkhənə tsiꞌì bɨ̀ tsɨ̀m ŋghɛɛ a mbɛ̀ɛ Stephen, ");
INSERT INTO bfd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ǹtswa yi nswuŋ mfɛ̀ꞌɛ̀sə̀ wa a mûm àlaꞌa ŋghɛɛ mmàꞌà a abɛɛ, ǹtɨgə ntumtə yi nɨ̂ ŋ̀gɔ̀ꞌɔ̀. Bɨ̀yəfə bìi mə bɨ lɛ ntswe ghu aa, bɨ lɛ ntsɔꞌɔtə ɨtsə̀ꞌə̂ jyaa nnɔŋsə a mɨkòrə mûjɔ̀ŋ yî mɔ̀ꞌɔ, ɨ̀kùmə̂ yi ɨ bə Saul. ");
INSERT INTO bfd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bɨ kà mə̂ aa tumtə nɨ̂ Stephen aa, a tsaꞌàtə̀ Nwî ǹswoŋ mə, “M̀màꞌàmbî Yesu, lɔ̀gə ntɨɨ̀ ghâ!” ");
INSERT INTO bfd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ǹswɛtə mɨkuꞌutə̂ mi a nsyɛ, ǹtɔŋnə ŋghaa tsiꞌì nɨ̀ mɨ̀tɨ̀ɨ̀ ǹswoŋ mə, “M̀màꞌàmbî, tsùu annù yî bɨ yuà a nu bo lǒ nɨŋ bə̂.” À ghàà mə̂ nswoŋ laà, m̀burə ntsɨɨ. ");
INSERT INTO bfd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul à lɛ beentə mə tâ bɨ̀ zwitə Stephen. Tsiꞌì maa njwi, bɨ lɔgɨ̀nə̀ ǹtɨgə ntsɔꞌɔ nɨ̂ àkòrə ŋghotə bɔɔ bɨ Kristo a Yerusalem tsiꞌì nɨ̀ mɨ̀tɨ̀ɨ̀. Bo bɨtsɨ̀m bɨ tɨgə̀ m̀fɛꞌɛkə ŋkhə̀kə̀ ǹsɛɛnə ŋghɛ̀ɛ̀ a mbùꞌù àlaꞌa baYudea bo bɨ̀ yì baSamaria. Ǹtɨgə mmaꞌatə tsiꞌì ŋ̀gǎŋntoo Kristo a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bə̀ bî mɔꞌɔ bìi mə bɨ lɛ sɨ yuꞌunə nɨ̂ Nwî aa bɨ lɛ ntɨgə nlɔgə Stephen ŋghɛɛ ntwiŋ, ŋ̀kɨ nyəꞌə yi tsiꞌǐ a mbə̂ ànnù. ");
INSERT INTO bfd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lâ Saul à lɛ mburə nlɔɔ mə yu burə ta ŋgɨꞌɨ a nu ŋghòtə tsiꞌì tà. À lɛ mfɛ̀ꞌɛ̀ ŋ̀ghɛɛ ntɨgə ŋkuu nɨ mɨlaꞌa mɨlaꞌa, m̀fiꞌi nɨ̂ bɔɔ bɨ Kristo ghu, bàŋgyɛ̀ bo bɨ̀ m̀bâŋnə̀, m̀maꞌa nɨ̂ waa a ndâtsaŋə̀. ");
INSERT INTO bfd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ŋ̀gǎŋmbii Kristo jìi mə bɨ lɛ mbùꞌù waa nsɛɛnsə aa, bɨ lɛ ŋghɛ̀ɛ̀ ǹtɨgə nswoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya tsiꞌì ɨdɨgə tsɨ̀m. ");
INSERT INTO bfd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip à lɛ nsɨgə ŋghɛɛ a mûm àlaꞌa baSamaria ǹtɨgə nswoŋə nɨ̂ ànnǔ a mbo bə̀ ghu nloŋə Ayɔꞌɔ̀ Nwì wâ. ");
INSERT INTO bfd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ǹnɔ̀ɔ̀ bə̂ yìi mə ɨ lɛ ntswe ghu aa, ɨ naŋsə̀ ǹtɨgə yuꞌutə nɨ̂ ànnù ya yìi mə Philip à lɛ sɨ swoŋ aà nɨ̂ ǹtɨɨ̀ waa tsɨ̀m. Bo bɨtsɨ̀m lɛ sɨ yuꞌu annù ya mə à lɛ sɨ swoŋ aa ŋ̀kɨɨ nyə nɨ̂ ɨ̀lènsə̀ jìi mə à lɛ sɨ ghɨ̀rə̀ aà; ");
INSERT INTO bfd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ɨ̀zwì jî bɨ ɨ lɛ sɨ tɨgə fɛꞌɛkə nɨ nu bə̀ bî ghàꞌàtə̀ bìi mə bɨ lɛ ntswe nɨ̂ ɨ̀zwì jî bɨ aa, ǹyəꞌə tsiꞌì nɨ̀tɨ̀ɨ̀. Bə̀ bî ghàꞌàtə̀ bìi mə ɨ̀dɨgə nû jyaa ɨ lɛ ntɨ̀ɨ̀ ŋkoꞌonə aa, bo bɨ̀ bɨ̀bwènkə̀ bɨ kɨ̂ ǹtɨ̀ɨ̀. ");
INSERT INTO bfd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Maa ajàŋ nɨ̀dorə nì wè nɨ lɛ ntswe maa mûm àlaꞌà. ");
INSERT INTO bfd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ŋù yî mɔ̀ꞌɔ à lɛ ntswe a alaꞌa Samaria, ɨ̀kǔm yi ɨ bə Simon, a ghɨrə̀ nɨ̀ majìkə̂ m̀burə mfumsə bə̂ bɨ tsɨ̀m ghu, ǹswoŋə nɨ mə yu nɨ ŋù yî ŋwè, ");
INSERT INTO bfd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bə̀ bɨtsɨ̀m wa alaꞌa, bì kə̀gə bo bɨ̀ bì wè, bɨ biì ànnù yi ǹswoŋə nɨ mə “Wa ŋù ghûlà, wâ à nɨ mɨ̀dàꞌà mɨ Nwî mya mə bɨ swoŋə nɨ mə mɨ tɨɨ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bɨ lɛ sɨ bii nɨ̂ ànnù yìi mə à lɛ sɨ swoŋ aa nloŋ mə à lɛ mfumsə waa nɨ majìgə̂ yì wa nɨ nòò yî ǹsyà aà. ");
INSERT INTO bfd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nòò wa mə bɨ lɛ nyuꞌu ŋ̀kɨ mbii ntoo yì nsɨgɨ̀nə ya mə Philip à lɛ nzi nɨ yu nloŋə annù nɨfɔ̀ Nwî bo bɨ̀ Yesu Kristo aà, bo lɛ ŋkwɛrə ŋkì, m̀bâŋnə̀ bo bɨ̀ bàŋgyɛ̀. ");
INSERT INTO bfd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon, nɨ̂ àtu ɨbɨ̀ɨ nû yi, à lɛ ŋkɨ mbii yìi ŋgaa bɨ murə̀ yi ŋkì, bɨ̀ mùrə̀ mə̂ yi ŋkì aa, a tɨgə̀ ǹzinə bo Philip, ǹyə nɨ̂ ɨ̀lensə ɨnnù bo bɨ̀ ɨ̀nnù jî yɛyɛrə jìi mə Philip à lɛ sɨ ghɨ̀rə̀ aa, ànnù a tsyâ yi. ");
INSERT INTO bfd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ŋ̀gǎŋntoò Kristo jya mə ɨ lɛ ntswe a Yerusalem aa, ɨ yuꞌu mə bə̀ bìi mə bɨ lɛ ntswe a Samaria bɨ bìì mə̂ nɨghàà nɨ Nwî aa, ntɨgə ntoo Peta bo Jɔn a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Peta bo Jɔn bo ghɛ̀ɛ̀ mə̂ ghu, ǹtsaꞌatə Nwî a atu bə̀ bya bìi mə bɨ lɛ mbii Yesu aa mə tâ bo kwɛrə Azwì Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","À lɛ tɨ bə ma mùu noò aa boŋ kaa Àzwì Nwî a burə tɨ̌ a nu ŋù nɨ̀bò sɨgə̀ bə̂. Bɨ lɛ mmurə waa aa tsiꞌǐ ŋkì nɨ ɨ̀kǔm Mmàꞌàmbî Yesu. ");
INSERT INTO bfd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peta bo Jɔn nɔ̂ŋsə̀ m̀bô myaa a atu bo,bo kwɛrə̀ Àzwì Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon à yə̀ mə̂ mə bə̌ kwɛrə Azwì Nwî a ajàŋ mə ŋgǎŋntoo Kristo jya ɨ nɔ̀ŋsə̀ nɨ̂ m̀bô myaa a atu bo aa, m̀fâ ŋ̀kabə a mbo Peta bo Jɔn, ");
INSERT INTO bfd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ǹswoŋ mə, “Nɨ̀ kɨ mfa mɨdaꞌa ma mû a mbo mə̀, mə ŋù yì tsù yìi mə mə̀ nɔ̀ŋsə maà m̀bo ghu atu aa, tâ à kɨ ŋkwɛrə Azwì Nwî.” ");
INSERT INTO bfd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peta a kwiꞌi ghu mbo mə, “Tâ ò kwo nɨ̂ ŋ̀kabə̀ yò ya mbwɛ mə mbə ò mɔɔntə mə mbə ò yuu mɨ̀təŋnə̀ mɨ Nwî nɨ̂ ŋ̀kabə̀! ");
INSERT INTO bfd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kaa ò sɨ̀ nɨ̂ ànnǔ tsu a mûm àfàꞌa yiꞌi tswê ǹloŋ mə kaa ntɨɨ̀ ghô sɨ̀ a nsi miꞌi Nwì laa aà. ");
INSERT INTO bfd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bəŋkə ntɨɨ̀ gho lâ, m̀maꞌatə annù yî bɨ mà yû mə ò tàŋtə aà, m̀buꞌu mbo a mbo M̀màꞌàmbi mə, nòò tsù, m̀bə a liꞌinə̀ ɨ̀fansənnù jo nloŋə annù ma yû mə ò wàꞌàtə a ntɨɨ wò aà. ");
INSERT INTO bfd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ǹloŋ mə mə̀ yə mə ò tswe nɨ̀ fɨ̀buu fìi fɨ lwì siꞌi, ò bə ŋgàŋàtsaŋ a mbo ɨ̀nnù jî bɨ̂.” ");
INSERT INTO bfd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon a swoŋ a mbo Peta bo Jɔn mə, “Mə̀ buꞌu tsiꞌì m̀bo, tsàꞌàtə̀ Nwîŋgɔ̀ŋ ǹloŋ ŋkwitû gha mə ànnù ma yû yî tsu mə nɨ̀ swoŋ aa, mə tâ à tsuu a nu mə̌ lǒ fɛ̀ꞌɛ̀.” ");
INSERT INTO bfd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peta bo Jɔn bìì mə̂ ànnù Yesu nɨ̂ ǹsi nɨ nsi ŋkɨ maŋsə a nsɛ̀ɛ̀nsə ntoò ya nloŋə Mmàꞌàmbi, mbù m̀bɨɨ fu a Yerusalem. Bo kà mə̂ aa bɨɨ aa, ntɨgə nswoŋə nɨ̂ ǹtoo yì nsɨgɨ̀nə̀ ya a ɨtoo jì ghàꞌàtə̀ a mûm àlaꞌa Samaria. ");
INSERT INTO bfd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Angel M̀màꞌàmbi a swoŋ a mbo Philip mə, “Taŋtə nû yò, ǹsɨgə ŋghɛ̀ɛ̀ nɨ mânjì yìi mə à lo a Yerusalem ŋ̀ghɛɛ nɨ a Gaza aa,” (mânjì ma ghû kaa bɨ sɨ ghu burə aa kɨ tsyà). ");
INSERT INTO bfd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Philip a taŋtə̀ nû yì ŋ̀ghɛɛ. Sɔ̀ŋ ŋù bàEthiopia yî mɔꞌɔ, m̀bə ŋgàŋàfàꞌà yî ŋwè a mbo Kandɛse, M̀fɔ̀ màŋgyɛ̀ baEthiopia, yìi mə à lɛ sɨ lə̀ə̀ nɨ̂ ŋ̀kabə yì aa, à lɛ ŋghɛ̀ɛ̀ a Yerusalem aa a mmii Nwì. À lò mə wa Yerusalem ");
INSERT INTO bfd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","mbu ntɨgə ŋkwɛɛ nìi fu a alaꞌa Ethiopia aa ŋkuu kalɨgə. À kà mə̂ aa ghɛɛ wa mum kalɨgə yi wa aa, ntɨgə ntwoŋə nɨ̂ àdɨgə aŋwàꞌànə̀ yi mɔꞌɔ a mûm àŋwàꞌànə ntoò Nwì Yesaiah. ");
INSERT INTO bfd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Àzwì Nwî a swoŋ a mbo Philip mə, “Khə̀tə nyòŋtə fìi mbɛ̀ɛ kalɨgə.” ");
INSERT INTO bfd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philip a khə̀tə̀ mə̂ nyoŋ aa, nyuꞌu a twoŋə̀ nɨ̂ àdɨgə àŋwàꞌànə̀ yî mɔꞌɔ a mûm àŋwàꞌànə ŋgàŋtoò Nwì Yesaiah, m̀betə̀ yi mə, “O yuꞌu nɨ̂ ànnù yìi mə o twoŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A kwiꞌi mə, “M̀bə mə̀ yuꞌu aa mə akə tɨ ghə mə ŋù à tɔ̀ꞌɔ̀tə a mbo mə̀ aa ɛ?” Ǹswoŋ a mbo Philip mə tâ à kɔꞌɔ ntswe bo yu wa mum kalɨgə. ");
INSERT INTO bfd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Àdɨ̀gə àŋwàꞌànə̀ Nwî yìi mə à lɛ sɨ twoŋ aa a lɛ mbə yulà, “À lɛ mbə tsǒ m̀bînjə̀rə̀ yìi mə bɨ lɔgə ŋghɛ̀ɛ̀ a ŋwà aà, kə̀ tsiꞌì tsǒ mû m̀bînjə̀rə̀ yìi mə bɨ kɔɔ ɨnòŋə̂ ji kaa a waꞌà yə̀ꞌə̀ aà. A ŋgɨ̌ŋ ŋgɨ̀ŋ, kaa à lɛ ŋwaꞌà ànnù tsu ghaà bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bɨ lɛ ndɨ̀rɨ̀sə atu yi kaa waꞌǎ ɨsaꞌà yi nɨ̂ ànnù nɨ̂ŋkoŋ saꞌà. M̀bə wò a swoŋə̀ ànnù ǹloŋə ŋ̀gwɛ̀ꞌɛ̀ yì aa ɛ? Ǹloŋ mə ǹtswêntɨ̀ɨ̀ yì fàa atu nsyɛ ɨ̀ lwìꞌì mə̂ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ŋ̀gàŋàfàꞌa Mfɔ̀ Ethiopia wa a betə̀ Philip mə, “Ŋ̀gàŋtoò Nwì ghû a ghàà laà ǹloŋ aa wò aa ɛ? A ghàà aa nloŋ ŋgaa yì kə̀ nloŋ ŋgaa ŋùdàŋ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philip a tɨgə̀ ǹlɔgɨnə ŋka ŋghaa, ǹlɔgɨnə nɨ̂ àdɨ̀gə aŋwàꞌànə̀ ma yû a nswoŋ ntoò Yesu yî ǹsɨgɨ̀nə̀ ya ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Àjàŋ mə bo yu lɛ sɨ tɨgə nzinə nsɨgə ŋghɛɛ wa a mânjì aa, bo lɛ ŋghɛ̀ɛ̀ ǹyweꞌe a adɨgə yìi mə ŋ̀kì lɛ ntswe ghu, ŋ̀gàŋàfàꞌa Mfɔ̀ Ethiopia wa a swoŋ a mbo Philip mə, “Ŋ̀kì ghûlà, àyoo yìi mə mbə a kɨɨ mə tâ bɨ̀ tsuu a gha a ŋkǐ murə aa, à nɨ̂ à kə̀ aa ɛ?”  ");
INSERT INTO bfd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip a swoŋ ghu mbo mə, “M̀bə bɨ tɨ murə gho a ŋkì mə mbə ò bii nɨ̂ ǹtɨɨ̀ ghô tsɨ̀mə̀.” A kwiꞌi mə, “Mə̀ bìi mə Yesu Kristo à nɨ Mu Nwì.” ");
INSERT INTO bfd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","À lɛ ntɨgə nswoŋ kalɨgə wa a təə̀, bo Philip fɛ̀ꞌɛ̀ ǹsɨgə ŋkuu wa mûm ŋ̀kì, Philip a tɨgə̀ m̀murə yi wa a ŋkì. ");
INSERT INTO bfd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nòò wa mə bɨ lɛ mfɛ̀ꞌɛ̀ wa a mûm ŋkì aa, Àzwǐ Mmàꞌàmbi a lɔgə̀ Philip ŋ̀ghɛɛ nɨ ghu. Ŋ̀gàŋàfàꞌa Mfɔ̀ Ethiopia wa a ghə mə yu kɨ lèntə̀, kaa waꞌà yi bû ǹyə, lâ ǹlo ntɨgə ŋghɛɛ nìi, ǹluu nɨ nɨ̀dorə. ");
INSERT INTO bfd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip à ghə̀ mə̂ mə yu kɨ yə, ǹtɨgə ntswe yi bə a alaꞌa Azotus. À tsyà mə̂ ghu ŋka ŋghɛɛ aa, ǹtɨgə nsɛɛnsə nɨ̂ ǹtoo yì ǹsɨgɨnə̀ ya a nɨ̂ ɨ̀toò tsɨ̀m jìi mə ɨ lɛ ntswe a mânjì aa, m̀bɔŋ ŋghɛɛ kùꞌu a alaꞌà Kaisaria. ");
INSERT INTO bfd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul à lɛ mbù ŋ̀ghɛɛ nɨ̂ m̀bìì m̀miꞌi tsiꞌì àtû yi, ŋ̀kaꞌatə nɨ̂ ŋ̀gǎŋyəgə̂nnù M̀màꞌàmbi jyâ, ǹswoŋə nɨ mə yu ka zwitə waa. À lɛ ŋghɛ̀ɛ̀ a mbɛ̀ɛ ŋgàŋmàꞌa Nwì yî ŋ̀wè ");
INSERT INTO bfd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ǹswoŋ ghu mbo mə tâ à ŋwaꞌanə àŋwàꞌànə̀ yìi mə a fɨ̀gɨ̀tə̀ ŋû yìi mə yu nɨ ghu aa, m̀fa mə tâ yù ghɛɛ mfa a mbo ndaŋghotə baYuda a Damascus; tǎ bɛɛ mə yu ghɛɛ nyə bə̂ bî tsu, m̀bâŋnə̀ kə̀ bàŋgyɛ̀, bìi mə bɨ yòŋə̀ Mânjì wa aa, yu tswatə̀ waa, ŋkwerə mbɨɨ nɨ bu a Yerusalem tsǒ ŋgàŋətsaŋə̀. ");
INSERT INTO bfd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saul à fɛ̀ꞌɛ̀ mə̂ ŋ̀ka ŋghɛɛ a mânjì, ŋ̀ghɛɛ ntɨgə ŋkuu a Damascus, ŋ̀ghəə kɨ yə, ŋ̀kàꞌà yî mɔꞌɔ ɨ wiꞌìkə̀ nlo a aburə, ŋ̀ŋwaꞌakə nsɨgə ŋkeꞌe adɨgə ya mə à lɛ ntəə ghu aa, ŋkarɨsə. ");
INSERT INTO bfd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A wô a nsyɛ nyuꞌu njì ŋù ɨ ghaà ghu mbo nswoŋ mə, “Saul, Saul! O tsɔꞌɔ akòrə̂ ya aa nloŋ akə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A betə̌ mə, “Àâ wò wò lɛ, Mmàꞌàmbî?” “À nɨ mə̀ Yesu wa yìi o tsɔꞌɔ akòrə̂ ya aà,” ǹjì ŋù wa ɨ kwiꞌi ghu mbô. ");
INSERT INTO bfd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","‘Lâ, bɨ̀ɨ̀nə ŋkuu ŋghɛ̀ɛ wa njɔ̀ꞌɔ̀ àlaꞌa. Wa bɨ ka swoŋ ànnù yìi mə ò ka ghɨ̀rə̀ aa a mbo wò.’ ");
INSERT INTO bfd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bə̀ bya bìi mə bo bɨ̀ Saul lɛ sɨ zìnə̀ aa lɛ ntəəntə tsiꞌì a tsǐtsi. Bo lɛ nyuꞌu ǹjì ŋù wa kaa kɨꞌɨ̀ ŋû bâŋnə̀ nyə. ");
INSERT INTO bfd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul a bɨɨnə̀ wa a nsyɛ, ŋŋaꞌa miꞌì mi, lâ kaa ŋkɨꞌɨ̀ nɨ̀ ɨ̀dɨ̀gə̀ bâŋnə̀ nyə. Maa ajàŋ bɨ tɨgə̀ ǹtswa nɨkwɛɛ̀ ni ŋghɛɛ nɨ ghu a alaꞌa Damascus. ");
INSERT INTO bfd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","À lɛ ntswe njwi ji tarə kaa waꞌà nɨ̀ ɨ̀dɨ̀gə̀ yə̂. A nɨ̂ àtɨɨ noò ma yû kaa à lɛ ŋkɨꞌɨ̌ ayoò tsǔ jɨ, kaa ŋkɨꞌɨ̌ ayoò tsǔ kɨ nno. ");
INSERT INTO bfd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ŋ̀gàŋyə̀gə̂nnù Yesu yî mɔ̀ꞌɔ à lɛ ntswe a Damascus, ɨ̀kǔm yi ɨ bə Ananias. Ǹjə̀ə̀ təə təə ɨ̀ lɛ nlɛ yi, a yə Mmàꞌàmbi a twoŋtə̀ yi mə, “Ananias,” a bii mə, “Mə̀ ghuà, a Mmàꞌàmbî ” ");
INSERT INTO bfd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","M̀màꞌàmbi a swoŋ gho mbo mə, “Bɨ̀ɨ̀nə ntaŋtə nû yò ŋ̀ghɛɛ a Mfâŋnə̀ yî Tsìnə̀, a nda Judas, m̀betə mə, ‘Ŋù wa mə à lo a alaꞌa Tarsus, ɨ̀kǔm yi ɨ bə Saul aa, à fə̀ lɛ?’ Wa à tswe ghu, ǹtsaꞌatə nɨ̂ Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ǹjə̀ə̀ təətəə ɨ̀ kɨ̀ mə̂ ǹlɛ yi a yə̂ ŋû yì mɔ̀ꞌɔ, ɨ̀kǔm yi ɨ bə Ananias, a kuu nnɔ̀ŋsə̌ mbo mi ghu nu mə tâ à bu ŋka nyə ɨdɨgə.” ");
INSERT INTO bfd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias a kwiꞌi mə, “Taà, bə̀ bî ghàꞌàtə̀ bɨ ghàà mə a mbo mə nloŋə ŋû ma ghû, ǹswoŋə nɨ̂ m̀buu ŋgɨꞌɨ yìi mə ŋù ma ghû à dɨ a nu bə̀ bo a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tsîtsɔ̀ŋ à zi a alaꞌa Damascus aa nɨ̀ àdàꞌà yìi mə à kwɛ̀rə a mbo bɨ̀lɨ̀ɨ bɨ ŋgǎŋmàꞌa Nwì mə yu zǐ baŋtə bə̂ bɨ̀tsɨ̀m bìi mə bɨ twoŋə nɨ̂ ɨ̀kǔm gho aà.” ");
INSERT INTO bfd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","M̀màꞌàmbi a swoŋ ghu mbo mə, “Ghɛ̀ɛ̂! Ǹloŋ mə mə̀ tsɔ̀ꞌɔ̀ mə̂ yi mə tâ à ka mfaꞌa a mbo mə̀, a ŋghɨ̀rə mə tâ bɨ̀tɨ̀zî Nwî bo bɨ̀fɔ̌ byaa, bo bɨ̀ baIsrael, tâ bɨ̀ zi ɨkûm ghà. ");
INSERT INTO bfd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tsiꞌì mə̀, nɨ̂ ɨ̀tu ɨ̀bɨɨ nû gha, mə̀ ka dɨ̀ꞌɨ ŋgɔ̀ŋ ŋgɨꞌɨ̀ tsɨ̀m yìi mə à ka tɨgə yə mbɨꞌɨ ŋkwitû gha aà.” ");
INSERT INTO bfd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","“Maa ajàŋ, Ananias a ghɛ̀ɛ̀ ŋ̀kuu wa a mûm nda mə Saul à lɛ ntswe ghu aa, ǹnɔŋsə mbô mi ghu nu, ǹtwoŋtə yi mə, ‘Ndɨ̂m ghà, Saul,’ Mmàꞌambi à too ghâ, m̀bə Yesu wa yumbɔŋ mə à kɨ̀ zi a mbo wò, wa a noò mə ò kɨ̀ sɨ zì faà aà. À too gha mə m̀bə ò bû ǹyə ɨdɨgə, tâ Àzwì Nwî kɨ nlwensə ghô.” ");
INSERT INTO bfd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tsiꞌì maa noo, ǹjoo ji mɔꞌɔ, tsiꞌì tsǒ ɨ̀bàrə mbwɛ̀, ɨ lô a miꞌi Saul ŋ̀wokə, a bû ŋ̀ka nyə ɨdɨgə. Ǹtɨgə mbɨɨnə ntəə bɨ murə̂ yi a ŋkì; ");
INSERT INTO bfd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","àjàŋ yìi mə à lɛ njɨ mɨjɨ aa, mɨ̀tɨ̀ɨ̂ mi mɨ bû ŋ̀kuu fu. Saul à lɛ ntswe mɨtugə mɨ njwi mǐ mɔꞌɔ bo bɨ̀ ŋ̀gǎŋyəgə̂nnù Yesu jya a alaꞌa Damascus. ");
INSERT INTO bfd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","M̀bɨɨnə ntsinə ŋghɛɛ a ndaŋghòtə baYuda, ǹlɔgɨnə ŋka nswoŋ nɨ mə Yesu à nàŋsə mbə aa tsiꞌì Mu Nwì wâ. ");
INSERT INTO bfd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ŋù ǹtsɨ̀m yìi mə à lɛ nyuꞌu aa, ànnù kôntsu a kô ǹtsǔ yi, bo tɨgə̀ ǹlɔgɨnə ŋka mbetə nɨ mə, “À sɨ̀ yu wa yìi mə à kɨ̀ sɨ zwitə nɨ̂ bə̀ bìi mə bɨ twoŋə nɨ̂ ɨ̀kǔm Yesu a Yerusalem aa bə aa ɛ? Tɨgə à kɨ nzì faà aa ǹloŋ aa tsiꞌì ànnù ma ya, mə yu zǐ baŋtə bə̂ ma bya ɨ bɨɨ fa a mbo bɨ̀lɨɨ bɨ ŋgǎŋmaꞌa Nwì aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lâ Saul a kuꞌùsə̀ nnɨŋtə mɨ̀tɨ̀ɨ̂ mi nswoŋ nɨ̂ ànnù Nwî tsiꞌì nɨ̀ mɨ̀dàꞌà, ɨ̀lènsə ɨnnù jìi mə à lɛ sɨ fa, a ndɨ̀ꞌɨ mə Yesu à lɛ nnaŋsə mbə Ayɔꞌɔ̀ Nwì wa aa, ɨ lɛ ntɨ̀ɨ̀ siꞌi siꞌi a mbo baYuda bìi mə bɨ lɛ ntswe a Damascus aa a nlɨ̀gɨ̀tə̂. ");
INSERT INTO bfd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mɨ̀tugə mɨ njwi mì ghàꞌàtə̀ mǐ mɔꞌɔ mɨ tsyà mə̂, baYuda bɨ boòntə̀ ǹtaŋtə a ajàŋə bɨ ka zwitə Saul, ");
INSERT INTO bfd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","lâ bɨ lɛ ŋkɛ̀ꞌɛ̀nə annù yìi mə bɨ taŋtə aa ghu mbô. Bo tɨgə̀ m̀bɛ nɨ ntsǔŋkya njɔ̀ꞌɔ̀ àlaꞌa wa nɨ̂ tugə bo bɨ̌ siꞌinə mə bɨ zwitə̀ yi. ");
INSERT INTO bfd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","A yî m̀bə a nɨ̂tugə yî mɔꞌɔ, ŋ̀gǎŋàkòrə̀ Saul, bɨ lɔgə̀ yi m̀bwi mborə a nɨ̂ ŋ̀kya wa mə bɨ lɛ mbɔɔ ŋkarɨsə a alaꞌa ya ghu aa, ǹnɨŋə yi a mûm ŋ̀kyɛ̀ ǹtɨgə mfɛꞌɛsə nsɨgɨsə a njɨ̀m ŋ̀kyâ. ");
INSERT INTO bfd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul a ghɛɛ̀ a alaꞌa Yerusalem, ǹywiŋtə mə yu kuu a tɨtɨ̀ɨ ŋgǎŋyəgə̂nnù Yesu, lâ kaa bo lɛ waꞌà waa bii mə à nɨ̂ ŋ̀gàŋyə̀gə̂nnù Yesu, bo bɨ tsɨ̀m lɛ sɨ bɔꞌɔ nìi. ");
INSERT INTO bfd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas à lɛ nzì ŋkwɛtə yi, ǹlɔgə yi ŋkuu nɨ ghu a tɨtɨ̀ɨ ŋgǎŋtoo Kristo jyâ. À kùù mə aa, ǹtɔꞌɔtə a mbo bo a ajàŋ yìi mə Saul à lɛ nyə Mmàꞌàmbi a mânjì aa, ŋ̀kɨ nswoŋ ajàŋə mə Mmàꞌàmbi à lɛ ŋghàà ghu mbo aà. À lɛ ŋkɨ ŋkɛꞌɛnə a mbo bo a ajàŋ yìi mə Saul à lɛ nswoŋ ànnù Nwî nɨ̂ Ɨ̀kǔm Yesu a mbo bo a Damascus kaa kɨꞌɨ̀ bɔꞌɔ aà. ");
INSERT INTO bfd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Maa ajǎŋ, Saul a tɨgə̀ ǹtswe bo bo, ǹtɨgə ŋghaa ŋkarə nɨ̂ ɨ̀dɨ̀gə̀ jî ghàꞌàtə̀ a Yerusalem, ǹswoŋə nɨ̂ ànnù Nwî nɨ ɨ̀kǔm Mmàꞌàmbi kaa kɨꞌɨ̀ bɔꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","À lɛ sɨ ghàà ŋ̀kɨɨ nswuŋnə bo bɨ̀ baYuda bìi mə bɨ lɛ sɨ ghàà nɨghàà nɨ baGrikia aa, bo lɛ ywiŋtə mə bɨ zwitə yi. ");
INSERT INTO bfd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Àjàŋ mə bɔɔ bɨ Kristo bɨ lɛ nzi ma yû aa, bo lɔgə̀ Saul, ǹsɨgə ŋghɛɛ nɨ ghu a alaꞌa Kaisaria, ǹtɨgə ntsyasə yi a ghɛ̀ɛ̀ a Tarsus. ");
INSERT INTO bfd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A bə̂ àjàŋ yìi mə a lɛ ntɨgə mbə aa, ŋ̀ghotə a alaꞌa Yudea, bo bɨ a Galilea, nɨ Samaria, ɨ tswe nɨ̀ m̀bɔɔnə nɨ̂ àtɨɨ noò. Ǹyoŋ a njɨ̌m a ajàŋ yìi mə Àzwì Nwî a lɛ ntswe ghu aà, mɨ̀tɨ̀ɨ̀ mɨ lɛ ŋkuu ghu, ɨ kɨɨ̀ ŋ̀kwe a nɨ̂ ǹdùù bə̂ ŋ̀ghaꞌatə ŋghɛɛ a ajàŋ yìi mə bo lɛ sɨ nzì nɨ̂ àkòrə̀ nɨt təə̀ yaa m̀ɔꞌɔ nɨ̂ M̀màꞌàbi aà. ");
INSERT INTO bfd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peta à lɛ sɨ ghaa ŋkarə nɨ ɨdɨgə tsɨ̀m, a bə a noò mɔ̀ꞌɔ a ghɛɛ̀ mə yu ghɛ̀ɛ ghantə bə̂ bɨ Nwî bìi mə bɨ lɛ ntswe a Lydda. ");
INSERT INTO bfd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","À ghɛ̀ɛ̀ mə̂ ghu aa, ntsiꞌi ŋû yî mɔ̀ꞌɔ yìi mə ɨ̀kǔm yi lɛ mbə Aeneas, a bə̂ m̀bwɛ̀nkə̀, lɛ boŋ à tsyà mə ɨlòò ji nɨfwaa kaa a kɨꞌɨ a mbɨɨnə a kuu zî. ");
INSERT INTO bfd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peta a swoŋ ghu mbo mə, “Aeneas! Yesu Kristo à ghɨ̀rə̀ mə̂ ò tɨɨ̀. Bɨ̀ɨ̀nə̂ a ndəŋ nnaŋsə ɨkuù ghô.” Tsiꞌì maa noò, Aeneas a lɨ mbɨ̀ɨ̀nə̀. ");
INSERT INTO bfd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ŋ̀gɔ̀ŋ bə̀ bɨ̀tsɨ̀m bìi mə bɨ lɛ ntswe a alaꞌa Lydda aa, bo bɨ a alaꞌa Sharon aa, bɨ yə̂ yi, m̀bəŋkə mɨ̂ntɨɨ̀ myaa mbii Mmàꞌàmbî. ");
INSERT INTO bfd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Màŋgyɛ̀ yî mɔ̀ꞌɔ à lɛ ntswe a alaꞌa Joppa, m̀bə ŋgàŋyə̀gə̂nnù Yesu, ɨ̀kǔm yi ɨ bə Tabita, (ɨ̀kǔm yi nɨ nɨ̀ghàà nɨ bakGrikia ɨ lɛ mbə Dorcas, ǹjiꞌì ɨ̀kûm yì wa ɨ bə mə ŋ̀gyâ). À lɛ sɨ naŋsə ŋghɨrə nɨ̂ ɨ̀nnù jî sɨgɨ̀nə̀, mfa ŋ̀gɔ̀ŋ nòò yi ntsɨ̀m a ŋkwɛtə̂ ŋ̀gǎŋgɨꞌɨ̀. ");
INSERT INTO bfd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A bə maà noò a wô nɨ̀ghɔ̀ɔ̀, ŋ̀kwo. Bɨ lɛ nsìꞌì yi nnɔŋsə nɨ̂ ǹdânɨ̀kàŋ yî mɔ̀ꞌɔ. ");
INSERT INTO bfd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kaa aghaꞌa Joppa kaa a lɛ waꞌà sàꞌà siꞌi a nlǒ a Lydda ŋghɛɛ ghu. Àjàŋə̀ mə ŋgǎŋyəgə̂nnù Yesu jya a Joppa ɨ lɛ nyuꞌu mə Peta à tswe a Lydda aa, bo lɛ ntoo mbâŋnə̀ ji baa mə bɨ̀ ghɛɛ nlɛnsə ŋ̀kɨ̀ɨ̀ ghulà ghu mbô, “Bìꞌì buꞌû m̀bô, wàŋsə nzǐ ntsiꞌi yiꞌi.” ");
INSERT INTO bfd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Maa ajàŋ, Peta a burə̀ m̀bɨɨnə ŋghɛɛ bo bo. Bo bo ghɛ̀ɛ̀ mə̂ kuꞌu ghu, bɨ lɔgə̀ yi ŋkɔꞌɔ ŋghɛɛ nɨ ghu wa a ndanɨ̀kàŋ. Bɨ̀kwìꞌì bɨ bâŋgyɛ̀ bɨ tsɨ̀m bɨ lɛ nzì ŋkarɨsə yi, ǹtɨgə nyəꞌə, ǹdɨꞌɨ nɨ̂ ɨ̀tsə̀ꞌə̀ jî màꞌà, bo bɨ̀ ɨ̀kutə̀ jìi mə Dorcas à lɛ sɨ ta a mbo bo a noò yìi mə à lɛ ntswe ntɨ̀ɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peta a furə̀ waa mə tâ bɨ̀ fɛꞌɛkə wa mûm ǹjaꞌànda ya yìi mə bo lɛ ntswe ghu aa tsiꞌì bɨ̀ tsɨ̀m. Ǹswɛtə mɨkuꞌutə̂ mi a nsyɛ, ǹtsàꞌàtə̀ Nwî, m̀bəŋkə nlii aku ŋû ya nswoŋ mə, “Tabitha, bɨ̀ɨ̀nə a ndəŋə!” A ŋaꞌatə̀ miꞌì mi nyə Peta ghu, m̀bɨɨnə ntswe. ");
INSERT INTO bfd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peta a nânsə̀ abô yi ntswa yi ghu, a bɨɨ̀nə̀ ǹtəə. A tɨgə̀ ǹtwoŋ bə̂ bɨ Nwî bya bo bɨ̀ bɨ̀kwìꞌì bya, m̀bu ndɨ̀ꞌɨ̀ yi a mbo bo a ajàŋ yìi mə à tswe ntɨ̀ɨ̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ŋ̀gàn ma yû ɨ̀ lɛ nsɛ̀ɛ̀nə̀ ŋ̀karɨsə alaꞌa Joppa tsiꞌì tsɨ̀m. Bə̀ bî ghàꞌàtə̀ bɨ biì M̀màꞌàmbî. ");
INSERT INTO bfd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peta à lɛ ntɨgə ntswe mɨtugə mɨ njwi mì ghàꞌàtə̀ a Joppa bo bɨ̀ ŋ̀gàŋ nùgê ŋ̀gùù yìi ɨ̀kûm yi ɨ lɛ mbə Simon aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ŋù yî mɔ̀ꞌɔ à lɛ ntswe a alaꞌa Kaisaria ɨ̀kǔm yi ɨ bə Cornelius, m̀bə atu ndâmânjɔ̀ŋ bɨ̀sogyɛ̀ (tsǒ 100) bìi mə bɨ lɛ nlo alaꞌa Itali aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","À lɛ sɨ ghaꞌasə nɨ̂ Nwî ŋ̀kɨɨ mbɔꞌɔ nìi bo bɨ̀ ŋ̀gwɛ̀ꞌɛ̀ yì, ŋ̀kɨɨ ntsaꞌatə nɨ̂ Nwî ŋ̀gɔ̀ŋ bɨ̀nòò bɨtsɨ̀m; m̀fa nɨ̂ ǹjoo jì ghàꞌàtə ŋ̀kwɛtə nɨ̂ baYuda bìi mə bə lɛ mbə ŋgàŋəfumə aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","À lɛɛ̀ m̀bə nɨ bɨ̀nòò bi tarə a njwi yì mɔ̀ꞌɔ, ǹjə̀ə̀ təə təə ɨ lɛ̂ yi a yə̂ angel Nwì a zî ǹtwoŋtə yi mə, “Cornelius!” ");
INSERT INTO bfd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A tɛꞌɛ miꞌì mi a nu angel wa, mbɔꞌɔ, ǹswoŋ mə, “Taà, à nɨ̂ à kə̀?” Angel wa a kwiꞌi mə, “Wa Nwì à bèèntə̀ mə atsàꞌàtə̀ yo yâ bo bɨ̀ ǹjoo jìi mə o fa nɨ a mbo ŋ̀gàŋə̌fumə aà, ǹtɨgə ŋwaꞌatə a gho nlɔɔ nɨ̂ m̀fâ àkwiꞌì. ");
INSERT INTO bfd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tsɨ̂tsɔ̀ŋ, too bə̂ a alaꞌa Joppa a nu ŋù yì mɔꞌɔ yìi mə ɨ̀kǔm yi nɨ Simon Peta aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","À nɨ̂ ŋ̀gɨ̀ɨ̀ a nda Simon, ŋù nùgə ŋ̀gùù yìi mə ndùgə̂ yì ɨ̀ tswe a aghəŋə mɨyaa aà.” ");
INSERT INTO bfd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angel wa mə à lɛ ŋghàà ghu mbo aa à lò mə̂, Cornelius a twoŋ ŋ̀gǎŋəfàꞌâ ji ji baa bo ŋù sogyɛ̀ yìi mə à lɛ sɨ bɛ nìi ŋkɨ mbə ŋû yìi à lɛ sɨ bɔꞌɔ Nwî yii ŋgaa aa, ");
INSERT INTO bfd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ǹswoŋ ɨnnù tsɨ̀m a mbo bo, ǹtɨgə ntoo wa a Joppa. ");
INSERT INTO bfd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Àbɛ̀ɛ̀ a fùꞌù mə̂ aa, bo ghɛɛ̀, ŋ̀ghɛɛ ŋka nyweꞌe a Joppa, Peta a ŋkɔꞌɔ ŋghɛɛ a atunda a noò ǹsiꞌi noò a ntsàꞌàtə Nwì. ");
INSERT INTO bfd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","À kɔ̀ꞌɔ̀ mə̂ ŋ̀ghɛɛ ŋka ntsaꞌatə Nwî aa, ǹji ka nyaŋə nìi, a ka nlɔɔ ayoo a njɨ̂. Lâ nòò yìi mə bɨ kà mə̂ aa laa mɨjɨ mya aa, ǹjə̀ə̀ təə təə ɨ kâ ǹlɛ nìi. ");
INSERT INTO bfd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A yə̂ àbùrə̀ a ŋaꞌanə̀, a yə̂ àyoo yìi mə a lɛ sɨ kɨrə tsiꞌì tsǒ àbàꞌa atsə̀ꞌə̀, bɨ ntswa mɨbuù mi mi nɨkwà aa, a sɨgə̀ nɨ atu nsyɛ ghu nsî. ");
INSERT INTO bfd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","M̀buu naà ŋ̀gɛ̀ɛ tsɨ̀m bo bɨ̀ ǹjoò tsɨ̀m jìi mə ɨ ŋàŋnə̀ a nsyɛ aa, nɨ bɨ̀sɨŋ bɨtsɨ̀m bìi mə bɨ darə nɨkàŋ aa, ɨ lɛ ntswe wa nɨ àbàꞌa atsə̀ꞌə̀. ");
INSERT INTO bfd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ǹjì ŋù yî mɔ̀ꞌɔ ɨ ghaà ǹswoŋ mə, “Peta, bɨ̀ɨ̀nə nzwitə ŋkurə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peta a swoŋ mə, “Ŋ̀ŋyâ gha Mmàꞌàmbî! Kaa mə̀ lɛɛ̀ waꞌǎ ayoo adàŋə̀ yî tsu kə̀ ǹjoo jì fwɛ̀ ma jû jî tsu mɨ sɨ̀ laa aa kurə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ǹjì ya ɨ kuꞌùsə̀ ǹswoŋ ghu mbo mə, “Kaa a sɨ̀ bɔ̂ŋ mə tâ ò ka ntwoŋ njoo jìi mə Nwì à nàŋsə ŋghɨ̀rə̀ ɨ laa aa nɨ̂ ǹjoo jì fwɛ̀ bə̂.” ");
INSERT INTO bfd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Àjàŋ annù ma yû a lɛ ŋkwatə ŋghɨrə ŋgaa ji tarə, bɨ tɨgə̀ ǹlɔgə abàꞌa atsə̀ꞌə̀ ya ŋkɔꞌɔ ŋghɛɛ nɨ yu a aburə nɨ̂ ŋ̀koŋə̀. ");
INSERT INTO bfd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peta à kà mə̂ aa ŋkwaꞌatə nɨ̂ àtu yi nloŋ njiꞌì ǹjə̀ə̀ ma yû aa, boŋ bə̀ bya mə Cornelius à lɛ ntoo aa, bɨ̂ lɔ̀ɔ̀ mə ndâ Simon ya ǹzì ǹtɨgə ntəə a ntsǔ ŋkyâ. ");
INSERT INTO bfd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ǹtwoŋ nɨ̂ tɨ̀ɨ̀, m̀betə mə, “Ngɨ̀ɨ̀ yî tsù à tswe fàa ndùgə̀ yìi mə ɨ̀kǔm yi à nɨ Simon Peta aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","À lɛ mbə ma mùu noò aa, Peta a burə̀ kɨ kwàꞌàtə atû yi nloŋ njiꞌì ǹjə̀ə̀ təə təə yâ. Àzwì Nwî a swoŋ ghu mbo mə, “Yə̂, bə̀ bi tarə bɨ təə a ntsǔbùꞌù ǹlɔɔ nɨ̂ ghô. ");
INSERT INTO bfd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bɨɨnə la, ǹtsuu noò ɨ ghɛ̀nsə̀, ǹyoŋə waa tâ bǔ bo ghɛɛ, ǹloŋ mə a waa aa tòo mə̂.” ");
INSERT INTO bfd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peta a bɨɨ̀nə̀ m̀fɛꞌɛ ghɛ̀ɛ̀ ŋ̀kwɛtə bə̂ bya nswoŋ a mbo mə, “À nɨ mə̀ ŋù wa mə nɨ lɔ̀ɔ̀ aà. Nɨ̀ zì aa a ya ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bɨ kwiꞌi ghu mbo mə, “A too tamânjɔ̀ŋ bɨ̀sogyɛ̀ wa yìi ɨ̀kǔm yi ɨ nɨ Cornelius aa ntoo yiꞌi a mbo wò. Tamânjɔ̀ŋ ma ghû a nɨ ŋù yìi mə ɨnnû ji ɨ tsinə a kɨɨ̀ mbɔꞌɔ nɨ̂ Nwî. BaYuda bɨtsɨ̀m kɨɨ̀ m̀beentə nìi tsiꞌì a annù nɨ̂koŋə̀. Angel Nwì yìi à laa màŋsə̀ aa à swoŋ ghu mbo mə tâ à twoŋə gho tâ ò zi a nda yu, tâ à yuꞌu ànnù yìi mə ò tswe nɨ̂ ǹswòŋə̀ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peta a lɔgə̀ bə̀ bya bo bo kuu a nda yu ntɨgə nlɛ ghu. Àbɛ̀ɛ̀ a fùꞌù mə̂, a taŋtə̀ nû yì bo bo tɨgə̀ ŋ̀ghɛɛ. Bɔɔ bɨ Kristo bî mɔꞌɔ a Joppa bɨ lɛ nyòŋə̀ waa bo bo ghɛɛ̀. ");
INSERT INTO bfd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bɨ lɔgə̀ ǹjwi yì m̀fùùrə̀ ŋ̀ghɛɛ ŋkùꞌù a Kaisaria, a adɨgə yìi mə Cornelius bo bɨ̀ ŋ̀gwɛ̀ꞌɛ̀ yì nɨ ɨ̀kàꞌâ ji jìi mə à lɛ twoŋ aa, bɨ lɛ ntswe ghu nyuꞌutə aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Àjàŋ yìi mə Peta à lɛ nzi ghə mə yu kuu aa, Cornelius a fɛ̀ꞌɛ̀ mboo yi, ŋ̀wo ghu mɨkòrə̀ a kùu kuu mmii yi. ");
INSERT INTO bfd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lâ Peta a ŋɛɛ̀ yi mbɨɨnsə swoŋ ghu mbo mə, “Təə a ǹdəŋə, mə̀mbɔŋ mə̀ laa ŋkɨ mbə tsiꞌì ŋùmɨ̀sɔ̀ŋə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peta a lɔgɨ̀nə̀ ǹtɨgə ŋghaa a mbo Cornelius a ajàŋ yìi mə bo yu tɨgə ŋkuu ŋghɛɛ wa a nda aà. À kùù mə̂ ǹyə mə bə̀ bî ghàꞌàtə̀ lɛ ŋghotə ghu, ");
INSERT INTO bfd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ǹswoŋ a mbo bo mə, “Bù bɨtsɨ̀m nɨ̀ zî sɨgɨ̀nə̀ mə, ǹyoŋə nɨ̂ ànnù Nwî baYuda, kaa mbə ŋù BaYuda a waꞌà bɨ̂tɨ̀zî Nwì ka ŋghantə kə̀ ka mboonsə ntswe a adɨgə yî fùùrə̀ bo bo. Lâ Nwìŋgɔ̀ŋ à dɨ̀ꞌɨ̀ mə a mbo mə̀ mə tâ mə̀ tsùu ŋù tsù ɨ lɔ̀gə̀ nɨ ŋù àdàŋə̀ àdàŋə̀, kə̀ nɨ ŋù yìi à sɨ̀ laa aa bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","À nɨ̂ ǹjiꞌì ànnù yìi mə ò ghɨ̀rə ntoo mə bɨ̀ twoŋə gha mə̀ wâŋsə̀ ǹzi kaa waꞌà jɨ̀ŋkə̀ bə aà. Mə tɨgə nlɔɔ aà m̀bètə wò mə ò tɛꞌɛ ntwoŋ gha aa a ya ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius a swoŋ ghu mbo mə, “Tsɨ̂tsɔ̀ŋ à nɨ njwi ji tarə a nɨ̂ àjàŋ noò yulà mə mə̀ lɛ sɨ tsàꞌàtə̀ nɨ̂ Nwî a mûm ǹda mə̀, nɨ bɨ̀nòò bi tarə a siꞌinə. Mə̀ wìꞌìkə̀ mə̂ ghə̀ə kɨ yə, ŋù a təə a nsi mə̀ ŋ̀wɛꞌɛ ɨtsə̀ꞌə̀ jî ŋ̀wèènə̀ ");
INSERT INTO bfd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ǹswoŋ a mbo mə̀ mə, ‘Cornelius! Nwìŋgɔ̀ŋ à yùꞌù mə atsàꞌàtə̀ yô, ŋ̀kɨɨ nyə nɨ̂ àfàꞌâ yô a ajàŋə mə o fa nɨ̂ ǹjoo ŋkwɛtə bə̀ bìi mə bɨ lɔ̀ɔ njoo aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Too ŋû tâ à ghɛɛ a Joppa ǹlɔɔ Simon yìi bɨ twoŋə nɨ Peta aà. Simon Peta ma ghû à nɨ̂ ŋ̀gɨ̀ɨ̀ ǹtswe a nda Simon yìi mə a nwugə ŋgùù, ǹdâ yì ɨ tswê a aghəŋə ŋkì aà.’ ");
INSERT INTO bfd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","À nɨ̂ ǹjiꞌì ànnù yìi mə mə̀ lɛ mburə ntoo bə̂ ǹswoŋ mə tâ ò zi aà, ò yuꞌu ŋkɨ waŋsə nzi nɨ̂ àbɔ̀ŋentɨɨ̀. Tsɨ̂tsɔ̀ŋ bìꞌinə̀ tswe faà bɨ tsɨ̀m aa a nsi miꞌi Nwì ǹyuꞌutə nɨ a nyuꞌu ànnǔ tsɨ̀m yìi mə Mmàꞌàmbi à fɨ̀gə̀tə̀ a mbo wò mə ta ò swoŋ aà.” ");
INSERT INTO bfd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peta a lɔgɨ̀nə̀ ŋ̀ka ŋghaa nswoŋə nɨ mə, “Mə̀ zi tsiꞌì sɨgɨ̀nə̀ mə Nwìŋgɔ̀ŋ a lèntə̀ bə̂ bɨ tsɨ̀m aa tsiꞌì ŋ̀gɨ̌ ŋgɨ̀ŋ. ");
INSERT INTO bfd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","A nɨ̂ ɨ̀toò tsɨ̀m a kwɛrə nɨ̂ ŋù ǹtsɨ̀m yìi mə a bɔꞌɔ nìi ŋkɨɨ ŋghɨrə nɨ̂ ànnù yìi a tsinə aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nɨ̀ zî ǹtoo yìi mə à lɛ ntoo a mbo baIsrael aà, ǹsɛɛnsə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya yìi mə ɨ fa mbɔɔnə aa, ntsya a njɨ̌m Yesu Kristo yìi mə à nɨ̂ M̀maꞌàmbî m̀bî ǹtsɨ̀m aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nɨ̀ zî ànnù yî wè yìi mə a lɛ mfɛ̀ꞌɛ̀ a mbùꞌu Yudea ntsɨ̀m aà, ǹlɔgɨnə a Galilea wâ nòò mə Jɔn à lɛ sɨ sɛ̀ɛ̀nsə̀ nɨ̂ ǹtoo ya nswoŋ nɨ mə tâ bə̀ bəŋkə mɨ̂ntɨɨ̀ myaa ŋkwɛrə ŋkì aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nɨ̀ zî ànnù ǹloŋə Yesu mu Nazareth, a ajàŋ yìi mə Nwì à lɛ yɔꞌɔ yi nɨ̂ Azwì yî Làà ŋ̀kɨ mfa mɨdaꞌa ghu mbo aà. À lɛ sɨ tɨgə ŋghɛɛ a ɨdɨgə tsɨ̀m ŋ̀ghɨrə nɨ̂ ɨ̀nnù jî sɨgɨ̀nə̀ ŋ̀kɨɨ ŋghurə nɨ̂ mɨ̀ghɔ̀ɔ̀ a nu bə̀ bìi mə Devil a lɛ kwerə waa aà, ǹloŋ mə Nwì à lɛ ntswe bo yu aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Biꞌinə̀ nɨ bɨ̀yəfə nɨ ɨ̀nnù tsɨ̀m jìi mə à lɛ ŋghɨ̀rə̀ a alaꞌa baYuda bo bɨ̀ a Yerusalem aà. Bɨ lɛ ntɨgə nzwitə yi, ŋ̀kweentə yi a ati bàŋnə̀ bàŋnə̀. ");
INSERT INTO bfd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lâ Nwìŋgɔ̀ŋ a bû mbɨɨnsə yi a nɨ nɨ̀wo a njɨ̌m njwi ji tarə, ŋ̀ghɨrə kaa bə̀ bɨ̀tsɨ̀m kaa waꞌà yi yə, ");
INSERT INTO bfd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","a kɨ̂ ǹyə tsiꞌì bɨ̀yəfə bìi mə Nwì à lɛɛ̀ m̀foo ntsɔꞌɔ waa aa, m̀bə biꞌinə̀ bìi mə bìꞌinə̀ lɛ sɨ jɨ ŋkɨɨ nno biꞌinə̀ bɨ̀ yù wa noò mə à lɛ mbɨ̀ɨ̀nə̀ nɨ nɨ̀wo aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","À lɛ mfa ndɨꞌɨ a mbo bìꞌinə̀ mə tâ bìꞌinə̀ tɨgə nsɛɛnsə nɨ̂ ǹtoo yì ǹsɨ̀gɨ̀nə̀ ya a mbo bə̀ bɨ̀tsɨ̀m, ŋ̀kɨɨ mbii nɨ̂ ǹsi nɨ̀ ǹsi mə à nɨ yu yìi mə Nwì à tsɔ̀ꞌɔ mə tâ yù à bə ŋgŋ̀ntsɔ̀ꞌɔ̀tə mɨ̀saꞌa mɨ bə̂ bɨ̀tɨ̀ɨ̀ bo bɨ̀ bɨ̀ku bɨ bə̂. ");
INSERT INTO bfd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ŋ̀gǎŋtoo Nwî ɨ tsɨ̀m ɨ lɛ sɨ ghàa ɨnnù ǹloŋ ŋgaà yì, ǹswoŋə nɨ mə, ŋù ǹtsɨ̀m yìi mə à nɨ̌n ntɨɨ̀ yi ghu nu aa, Nwì à ka lìꞌìnə ɨbɨ̂ yi, a njɨ̌m ɨkǔm yi.” ");
INSERT INTO bfd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tsiꞌì wa a nòò mə Peta à lɛ mburə kɨ ghàà aa, Àzwì Nwî a sɨgə a nu bɨ̀ bɨ tsɨ̀m bìi mə bɨ lɛ ntəə maa adɨgə nyuꞌutə nɨ̂ ànnù yìi mə à lɛ sɨ sɨ swoŋə aà. ");
INSERT INTO bfd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","À lɛ mbə annù yî yɛ̌yɛrə a mbo baYuda bìi mə bɨ lɛ nnɨŋ ntɨɨ̀ waa a nu Yesu, ǹlo a alaꞌa Joppa ǹyoŋə Peta aa, a nyə mə Nwì à lɛ ŋkɨ nswiꞌi mɨtəŋnə̂ mi mìi mə à nɨ Azwì yî Làà aa, a nu bɨ̀tɨ̀zî Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ǹloŋ mə bo lɛ nyuꞌu bo tɨgə̀ ŋ̀ghaa nɨ mɨ̀ghàà mî fii, ŋkɨɨ ŋghaꞌasə nɨ̂ Nwî. Peta a ghaà nɨ̂tɨ̀ɨ̀ ǹswoŋ mə: ");
INSERT INTO bfd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Bə̀ bulà bo kwɛrə aà Àzwì Nwî, tsiꞌì wa ajàŋ mə bìꞌinə lɛ ŋkɨ ŋkwɛrə aà. Ŋù tsù à tswe ghu mə mbə a tsuꞌunə̀ waa mə tâ bo tsuu ŋkǐ kwɛrə aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Maa ajàŋ a tɨgə̀ ǹswoŋ a mbo bo mə tâ bo kwɛrə ŋkì nɨ̂ ɨ̀kǔm Yesu Kristo. À màŋsə̀ mə aa bɨ tɨgə̀ ǹswoŋ ghu mbo mə tâ à bu ntswe bo bo mɨtugə mɨ jwi mi mɔꞌɔ mbɔŋ màꞌàtə. ");
INSERT INTO bfd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ŋ̀gǎŋntoo Kristo jya a bɔꞌɔ bɨ̀lɨ̂m byaa a mbùꞌù Yudea aa bɨ lɛ nyuꞌu mə bɨ̀tɨ̀zi Nwî bɨ kɨ̀ mə̂ m̀bii nɨghàà nɨ Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peta à bù mə̂ ŋkɔꞌɔ ghɛɛ fu a Yerusalem, bə̀ bya bìi mə bɨ lɛ sɨ lɔ̀ɔ̀ nɨ mə tâ bɨ̀ ka ŋŋetə nɨ̂ bɨ̀tɨ̀zi Nwî aa, bɨ lɛ ntɨgə ntswa yi nɨ̂ ɨ̀saꞌa, ŋ̀ghaantə ");
INSERT INTO bfd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nswoŋə nɨ mə, “A gho aà a kɨ̀ ghɨ̀rə̂ àkə̀ ò ghɛɛ̀ a nda bɨ̀tɨ̀zi Nwî bìi mə bɨ̂ sɨ̀ waa ŋêtə̀ aa ɛ? Ò ghɛ̀ɛ̀ mə̂ ghu, m̀bii njɨ mɨjɨ bu bo!” ");
INSERT INTO bfd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lâ Peta a lɔgɨ̀nə̀ ǹtɔꞌɔtə ɨnnù tsɨ̀m a mbo bo tsiꞌì àjàŋ yìi mə ɨ lɛ mfɛ̀ꞌɛ̀ aà: ");
INSERT INTO bfd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mə̀ kɨ̀ sɨ tsàꞌàtə̀ Nwî a njɔ̀ꞌɔ̀ alaꞌa Joppa, mə̀ kà mə̂ aa ntsaꞌatə aa, ǹjə̀ə̀ təə təə ɨ lɛ̂ gha, mə̀ yə̂ àyoò tsu a lô a aburə ŋka nsɨgə, m̀bə tso àbàꞌa atsə̀ꞌə̀ yìi mə a burə ŋghaꞌatə aa, bɨ tswa nɨ mɨ̀buù mi mi nɨkwà, a sɨgə nzì ǹtəə a mbɛ̀ɛ mə̀. ");
INSERT INTO bfd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mə̀ ləŋtə̀ ǹyə mbuu naà tsɨ̀m ghu, nàà jî màꞌàtə̀, nàa ŋgɛ̀ɛ̀ jìi mə nɨ naà mɨtsəꞌə aa, bo bɨ̀ ǹjoo jìi mə ɨ ŋàŋnə̀ a nsyɛ aa, bo bɨ̀ bɨ̀sɨŋ bɨtsɨ̀m bìi mə bɨ dàrə̀ nɨkàŋ aà. ");
INSERT INTO bfd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mə̀ yə̀ mə̂ aa, nyuꞌu njì ŋù ɨ ghaà ǹswoŋ a mbo mə̀ mə, ‘Peta, bɨ̀ɨ̀nə nzwitə nkurə̀!’ ");
INSERT INTO bfd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lâ mə̀ swoŋ mə, ‘Ŋ̀nyâ ghâ, mə̀ tùu ghâ, Taà. Ǹloŋ mə kaa mə̀ lɛɛ̀ ŋwaꞌǎ ayoo adàŋə̀ àdàŋə̀ yî tsu kə̌ njoo jì fwɛ̀ ma jû jî tsu jɨ̂.’ ");
INSERT INTO bfd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lâ ǹjì ya ɨ bû ŋ̀ghaa, a aburə, ŋgaa yìi ɨ̀ yweꞌe ji baa aa, nswoŋ mə, ‘Kaa a sɨ̀ bɔ̂ŋ mə tâ ò ka ntwoŋ njoo jìi mə Nwì à nàŋsə, ŋ̀ghɨ̀rə̀ ɨ laa aa nɨ̂ ǹjoo jì fwɛ̀.’ ");
INSERT INTO bfd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Àjàŋ annù ma yû a lɛ ŋkwatə ŋghɨrə ŋgaa ji tarə, bɨ tɨgə̀ ǹlɔgə njoo jya tsɨ̀m m̀bu ŋkɔꞌɔ ŋghɛɛ nɨ ju fu a aburə. ");
INSERT INTO bfd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mə̀ ghə̀ə kɨ yə tsiꞌì maa noò, m̀bâŋnə̀ jî mɔꞌɔ ji tarə ɨ zî ŋ̀kuu wa a nda yìi mə bìꞌì lɛ ntswe ghu aà, ǹlo aa a alaꞌa Kaisaria, a ajàŋ mə bɨ too waa a nu mə̀. ");
INSERT INTO bfd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bo zì mə̂, Àzwì Nwî a swoŋ a mbo mə̀ mə tâ mə̀ lo ŋghɛ̀ɛ̀, ǹtsuu lǒ kɨ jɨ̀ŋkə̀ bə̂. Bɨ̀lɨ̂m ba buà bi ntoꞌo mə bɨ lo a Kaisaria aa, bɨ lɛ nyòŋə̀ gha bìꞌibo ghɛɛ̀ ŋ̀kuu wa nda ŋù wâ. ");
INSERT INTO bfd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Bìꞌì ghɛ̀ɛ̀ mə̂ ŋ̀kuu ghu nda, a swoŋ àjàŋ yìi mə yu lɛ nyə angel wa a zî ǹtəə a nda yu, ǹswoŋ mə, ‘Too bə̂ a Joppa tâ bo ghɛɛ ntwoŋ Simon Peta mə tâ à zi; ");
INSERT INTO bfd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","à bə zì boŋ à ka swoŋ ntoo yìi mə wò nɨ̂ ŋ̀gwɛ̀ꞌɛ̀ ǹdâ yò, bù bɨ tsɨ̀m ka tsyà ghu ɨ yweenə aà.’ ");
INSERT INTO bfd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","À swòŋ mə̂ laà, mə̀ lɔgɨ̀nə̀ ŋ̀ka ŋghaa a mbo bo, mə̀ kà mə aa ghaa, Àzwì Nwî a sɨgə ŋkuu a nu bo, tsiꞌì wa ajàŋ yìi mə a lɛ ŋkɨ nsɨgə ŋkuu a nu bìꞌinə̀ a mbìì aà. ");
INSERT INTO bfd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma mùù àjàŋ, mə̀ tɨgə̀ ŋ̀waꞌatə a ajàŋ yìi mə Mmàꞌàmbî Yesu à lɛ nswoŋ aa, mə, ‘Bə̀ lɛ sɨ kwɛrə aà ŋ̀kì a mbo Jɔn, lâ nɨ̀ ka yǐ bàŋnə tɨgə kwɛrə aa bə̂ Àzwì Nwî.’ ");
INSERT INTO bfd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","A naŋsə nlaa tsiꞌì sɨgɨ̀nə̀ mə à nɨ aa tsiꞌì mɨ̀təŋnə̀ mya mìi mə Nwì à lɛ mfa a mbo bìꞌinə a noò yìi mə bìꞌinə̀ lɛ nnɨŋ mɨ̂ntɨɨ̀ mìꞌinə̀ a nu Mmàꞌàmbî Yesu Kristo aa mə Nwì à kɨ̀ kɨ ntəŋə bɨ̂tɨ̀zî Nwì bû ghu. M̀bə a bə aa mùu ajàŋ, mə̀ tɨgə̀ m̀bu mbə wò yî dàŋə̀ mə mbə mə̀ tsyâ ŋ̀kɨɨ annù yìi mə Nwì à kɨ̀ ghɨ̀rə a nu bo aa, mə tâ à tsuu lǒ ghɨ̀rə̀ aa ɛ?” ");
INSERT INTO bfd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Àjàŋ yìi mə bɨ lɛ nyuꞌu Peta a swoŋ lâlà aa, bo lɛ ntɨgə ŋkɛntə waa, kaa waꞌà ɨsaꞌa ghu nu bù nlɔɔ. Ǹlɔgɨnə ntɨgə ŋghaꞌasə nɨ̂ Nwî, ǹswoŋə nɨ mə, “Nwì à kɨ̀ mə̂ m̀bii mfa abwarə a mbo bɨ̀tɨ̀zi Nwî mə tâ bo bəŋkə mɨ̂ntɨɨ̀ myaa ntswe nɨ̂ ǹtswêntɨ̀ɨ̀.” ");
INSERT INTO bfd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bə̀ bya bìi mə bɨ lɛ nsɛ̀ɛ̀nə̀ ǹloŋ mə bɨ lɛ ntɨgə ntsɔꞌɔ nɨ̂ àkòrə̀ yaa wa noò mə bɨ lɛ nzwitə Stephen aa, bɨ lɛ mfɛ̀ꞌɛ̀kə̀ ŋghɛɛŋkə a ɨdɨgə ɨdɨgə. Bǐ mɔꞌɔ bɨ lɛ ŋghɛ̀ɛ̀ŋkə̀ a Fonikia, bo bɨ̀ a Cyprus, bi mɔꞌɔ bɨ kɨ̂ ŋ̀ghɛɛŋkə a Antiokia. A ajàŋ yìi mə bɨ lɛ ntɨgə nsɛɛnə ŋghɛ̀ɛ̀ laà aa, bɨ lɛ ntɨgə nswoŋə nɨ̂ ànnù Nwî nɨ̂ ɨ̀too mà jû, lâ ǹswoŋə nɨ̂ ǹtoo ma yû tsiꞌì a mbo baYuda. ");
INSERT INTO bfd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lâ bǐ mɔꞌɔ a tɨtɨ̀ɨ bo bìi mə bɨ lɛ nlò a Cyprus bo bɨ̀ a Cyrene aa, bɨ lɛ ŋghɛ̀ɛ̀ a Antiokia, ǹlɔgɨnə ntɨgə ŋkɨɨ nswoŋə nɨ̂ ànnù Nwî a mbo baGrikia, ǹswoŋə nɨ̂ ǹtoo yì ǹsɨgə̀nə̀ ya nloŋ Mmàꞌàmbî Yesu a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","M̀màꞌàmbî à lɛ nnɨŋ abô yi nɨ̂ ànnù ma yû mə bo lɛ sɨ swoŋ aa, ŋ̀ghɨrə bə̀ bî ŋ̀ghàꞌà ghaꞌa bɨ bəŋkə mɨ̀ntɨɨ̀ myaa nnɨŋ a nu M̀màꞌàmbî. ");
INSERT INTO bfd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ŋ̀ghòtə a Yerusalem ɨ̀ lɛ nyuꞌu annù ma yû yìi mə a lɛ mfɛ̀ꞌɛ̀ a Antiokia. Bɨ yùꞌù mə̂, ǹtoo Barnabas a Antiokia. ");
INSERT INTO bfd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","À ghɛ̀ɛ̀ mə̂ ghu, ǹyə ajàŋ yìi mə Nwì à lɛ nnɨŋ mbɔɔnə a nu bə̀ ghu aa, ǹtɨgə ndorɨtə; ǹdɨꞌɨtə waa bɨtsɨ̀m ǹswoŋ mə tâ bo tɛꞌɛ atû yaa nɨ̂ ànnù Nwî, ŋ̀ka yoŋə nɨ̂ M̀màꞌàmbi nɨ̂ ǹtɨɨ̀ waa tsɨ̀mə̀. ");
INSERT INTO bfd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas à lɛ mbə ŋû yî ǹsɨgɨ̀nə̀, ǹluu nɨ̂ Àzwì yî Làà, bo bɨ̀ nɨ̂ àbìintɨɨ̀. Bə̀ bî ghàꞌà ŋ̀ghaꞌa bɨ lɛ ntɨgə mbəŋkə mɨ̂ntɨɨ̀ myaa, ǹzi a mbɛ̀ɛ Mmàꞌàmbî. ");
INSERT INTO bfd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas à lɛ ntɨgə mbu nlò ŋ̀ghɛɛ a Tarsus a nlɔ̀ɔ Saul ghu. ");
INSERT INTO bfd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","À ghɛ̀ɛ̀ mə̂ ǹlɔɔ nyə, ntɨgə nlɔgə nzì nɨ ghu a Antiokia. A atû ɨ̀lòò yî fùùrə̀ bo ma bû bi baa bo lɛ ntɨgə mboontə bo bɨ̀ ŋ̀ghòtə ya a Antiokia, ǹdɨꞌɨ nɨ̂ ǹnɔ̀ɔ̀ bə̂ yî ghàꞌàtə̀ ghu. À lɛ mbə aa a Antiokia mə bɨ lɛ mfòò ǹlɔgɨnə ntɨgə twoŋə nɨ̂ ŋ̀gǎŋyəgə̂nnù Yesu jya nɨ bɨ̀Krisènə̀. ");
INSERT INTO bfd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ma mùu noò ŋ̀gǎŋntoo Nwî jî mɔꞌɔ ɨ lɛ nlò a Yerusalem ǹsɨgə nzi a Antiokia. ");
INSERT INTO bfd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yì mɔ̀ꞌɔ yìi mə ɨ̀kǔm yi ɨ lɛ mbə Agabus aa, a bɨɨ̀nə̀ ǹtəə a ndəŋ ŋghaa nɨ̂ àdàꞌa Azwì, ǹswoŋ annù yìi mə Àzwì a lɛ mɨ̀tə̀ ghu mbo aa, ǹswoŋ mə mɨ̀kwenə̀ yî ŋ̀wè à ka kuu a mbî ǹtsɨ̀m. (Ma yuù ànnù a lɛ mfɛ̀ꞌɛ̀ aa a noò yìi mə Klaudius à lɛ mbə Kaisa aà.) ");
INSERT INTO bfd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ŋ̀gǎŋyəgə̂nnù Yesu jya ɨ lɛ nlə̀ə̀ mə tâ ŋù nɨ̀bò waa yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ tâ à gaansə mɨtɨ̀ɨ̂ mi ntoo ayoo yìi mə mbə a fa aa, tâ bɨ̀ kwɛtə bɨlɨ̂m byaa bìi mə bɨ lɛ ntswe a Yudea aa ghu. ");
INSERT INTO bfd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bɨ lɛ ghɨ̀rə̀ ma yuù ànnù, ǹtɨgə ntoo Saul bo Barnabas bo ghɛɛ̀ m̀fa ŋkabə yìi mə bɨ lɛ ntswaꞌatə aa a mbo bɨ̀lɨ̀ɨ bɨ ndânwì. ");
INSERT INTO bfd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","À lɛ mbə ma mùu noò aa M̀fɔ̀ Herod a lɔgɨ̀nə̀ ŋ̀ka ntsɔꞌɔ nɨ̂ àkòrə bə̀ bî mɔ̀ꞌɔ a ŋghotə. ");
INSERT INTO bfd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","À lɛ ŋghɨ̀rə̀ bɨ tswâ Jɛms muma bɨ̀ Jɔn ǹzwitə nɨ munwî ǹtsò. ");
INSERT INTO bfd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A yə mə mayû ànnù a lɛ mbɔ̀ŋ baYuda, m̀bû ŋ̀ghɨrə bɨ tswâ Peta. (Mayû ànnù a lɛ mfɛ̀ꞌɛ̀ aa a noò ǹjwî Àbaa Tɨkɔꞌɔ̀). ");
INSERT INTO bfd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bɨ tswà mə̂ Peta aa, ŋghɛ̀ɛ̀ ǹnɨŋ yi a ndâtsaŋə̂, m̀fa yi a mbô ɨ̀khɨ̀rə̀ bɨ̂sogyɛ̀ bi nɨkwà ji nɨkwà mə bɨ̀ ka mbɛ. Herod à lɛ nlə̀ə̀ mə yu ka fiꞌisə yi tâ bɨ̀ saꞌa yi a nsi bə̀ aa a noò yìi mə bɨ̂ jɨ̀ mə̂ Passa aà. ");
INSERT INTO bfd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ma mùu ajàŋ, bɨ lɛ ntɨgə nləə Peta wa ndâtsaŋə̂. Lâ ŋ̀ghòtə ɨ̀ lɛ sɨ tsàꞌàtə̀ nɨ̂ Nwî tsiꞌì nɨ̀tɨ̀ɨ̀ ghu atu, kaa waꞌà kaà. ");
INSERT INTO bfd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","À bə̀ mə̂ nɨ̂tugə a njwi yìi mə àbɛ̀ɛ̀ ka fuꞌu tâ Herod swoŋ tâ bɨ̀ fiꞌisə yi aa, Peta a nɔ̂ŋ m̀bwii a tɨtɨ̀ɨ bɨ̀sògyɛ̀ bi baa, bɨ tɨ̂ŋnə̀ yi nɨ bɨ̀tsɛ̂n bi baà. Ŋ̀gǎŋmbɛ̂ àtsaŋ ɨ lɛ ŋkɨ təəntə a tssǔbùꞌù, m̀bɛ nɨ̂ ɨ̀dɨ̀gə̀. ");
INSERT INTO bfd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Angel M̀màꞌàmbi à lɛ ŋwìꞌìkə̀ ǹzi ntəə wa ndâtsaŋ, ŋ̀kàꞌà ɨ ta ghu, ŋ̀ghɨrə ɨ̀dɨ̀gə̀ ɨ fuꞌù. Angel wa a tswâ àbɛ̀ꞌɛ̀ Peta ǹtsɨgɨtə a bɨɨ̀nə̀, a swoŋ ghu mbo mə, “Wàŋsə mbɨ̀ɨ̀nə̂!” Bɨ̀tsɛ̂n bya bɨ fɛɛ̀ŋkə̀ ghu mbo ŋwòkə̀. ");
INSERT INTO bfd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angel wa a swoŋ ghu mbo mə, “Wɛꞌɛ ɨtsə̀ꞌə̂ jo bo bɨ̀ ǹtâm jô.” Peta a ghɨ̀rə̀ tsiꞌì maa ajàŋ mə à swòŋ aà. Angel wa a bû ǹswoŋ ghu mbo mə, “Lɨm akutə̀ yo ya a nu wò ŋ̀ka nyoŋə nàâ.” ");
INSERT INTO bfd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peta a yoŋə̀ yi bo yu fɛꞌɛ̀ wa ndâtsaŋə̀. Kaa Peta à lɛ waꞌà zi mə ànnù yìi mə a lɛ sɨ fɛ̀ꞌɛ̀ aa a lɛ mbə aa tsiꞌì ànnù nɨ̂ŋkoŋə̀. À lɛ mbàŋnə̀ ŋ̀ka mɔɔntə bə nɨ mə â lɛ sɨ lɛ nɨ̂ ǹjə̀ə̀ təə təə nlɛ nìi. ");
INSERT INTO bfd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bo yu ghɛɛ̀ ǹtsya akhɨ̀rə̀ bɨ̂sogyɛ̀ bɨ mbɛ̂ ɨ̀dɨ̀gə yi mbìì, ŋ̀kɨ mbu ntsyà yî àyòŋtə̀, m̀bɔŋ ŋghɛɛ fɛ̀ꞌɛ̀ wa nɨ̂ ǹtsǔbùꞌu atɨɨ wa yìi mə ɨ lɛ sɨ lìì nɨ mûm àlaꞌa aà. Bo zì mə̂ ǹyweꞌe ghu, àbàꞌà ya a ghɛsə̀ ŋ̀ŋaꞌanə tsiꞌì yumbɔŋ a mbo bo, bo tɨgə̀ ǹtsya mfɛ̀ꞌɛ̀ ŋ̀kuu a mfâŋnə̀ yî mɔ̀ꞌɔ ntɨgə nsɨgə ŋghɛɛ ghu. Bo yu kà mə̂ aa ntəə wa mfâŋnə̀ ǹsɨgə ŋghɛɛ aa, angel wa a wiꞌìkə̀ m̀maꞌatə yi. ");
INSERT INTO bfd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Àtu Peta a wiꞌìkə̀ ǹlaa, a zî ànnù yìi mə a ghɨrə yi aa, ǹswoŋ mə, “Tsɨ̂tsɔ̀ŋ mə̀ zi mə à nɨ̂ tsiꞌì ànnù nɨ̂ŋkoŋə̀! A too M̀màꞌàmbi ntoo angel yì mə tâ à zi ŋkwɛrə gha a mbo Herod, ɨ ghɨrə tâ mə̀ tsuu annù yìi mə baYuda bɨ kàꞌà nɨ mə bɨ ka ghɨ̀rə̀ a nu mə aa lo yə.” ");
INSERT INTO bfd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","À yə̀ mə̂ laà, ǹtɨgə ŋghɛɛ a nda Mary, ǹdè bɨ̀ Jɔn wa yìi ɨkǔm yi yî mɔꞌɔ lɛ mbə Mark aà. Bə̀ lɛ ŋghotə ghu tsiꞌì bî ghàꞌàtə̀ ǹtswe ghu ǹtsaꞌatə nɨ̂ Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","À ghɛ̀ɛ̀ mə̂ ghu, ŋ̀kwɛntə ntsǔ abàꞌà yi abɛɛ, mumàŋgyɛ̀ yìi mə à lɛ sɨ fàꞌà wa nda, ɨ̀kǔm yi ɨ bə Rhoda aà, a bii, nzì a ŋŋaꞌa àbàꞌà yâ. ");
INSERT INTO bfd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","À zì mə̂ ǹyuꞌu njì Peta ǹzi, ǹtɨɨ̀ yi ɨ burə̀ ǹnaŋsə nluu nɨ nɨ̀dorə a baŋnə̀ m̀maꞌatə Peta, kaa waꞌǎ abàꞌà ya ŋaꞌa mə tâ à kuu, mbu ŋkhə̀ m̀bɨɨ fu a nswoŋə a mbo bə̀ bya mə Peta à təə a ntsǔndâ. ");
INSERT INTO bfd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bə̀ bya bɨ yùꞌù mə̂ laà, ǹswoŋ ghu mbo mə, “O baanə aà bàànə̀?” La a kuꞌusə̀ ŋ̀ghaa tsiꞌì nɨ̀ tɨ̀ɨ̀ ǹswoŋ mə à nɨ tsiꞌì ànnù nɨ̂ŋkoŋə̀. À bù mə̂ ǹswoŋ laà, bo tɨgə̀ ǹswoŋ mə, “À nɨ angel yì.” ");
INSERT INTO bfd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bo lɛ sɨ ghàà laà aa, Peta a bâŋnə̀ ǹtəə wa ntsǔnda ŋkwɛ̀ntə̀. Bo ghɨ̀rə̀ mə̂, ŋ̀ghɛɛ ŋŋaꞌa abàꞌà yâ. Bo ŋàꞌà mə̂ ǹyə yi, ànnù a burə̀ ǹtsya waa! ");
INSERT INTO bfd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peta a kɔꞌɔsə̀ àbô yi ndɨꞌɨ mə tâ bo tsuu kɨ ghàà, ǹtɨgə ntɔꞌɔtə a mbo bo a ajàŋ yìi mə Mmàꞌàmbi à lɛ ŋghɨ̀rə̀ angel yì a zî m̀fiꞌi yi wa ndâtsaŋə aà. À tɔ̀ꞌɔ̀tə̀ mə̂ m̀maŋsə, ǹswoŋ a mbo bo mə, “Nɨ̀ tɨgə nswoŋ a mbo Jɛms bo bɨ̀ a mbo bɨ̀lɨ̂m bìꞌinə̀.” Ǹtɨgə nlo ŋghɛ̀ɛ̀ yi a adɨgə dàŋ. ");
INSERT INTO bfd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Àbɛ̀ɛ̀ fùꞌù mə̂, ɨ̀dɨ̀gə̀ ɨ tɨgə̀ ǹtsaꞌa tsiꞌì tsàꞌà a tɨtɨ̀ɨ bɨ̀sogyɛ̀ bya, bo tɨgə̀ ŋ̀waꞌa nɨ mə a Peta aa a ghɨ̀rə̂ àkə̀ lɛ! ");
INSERT INTO bfd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod a swoŋ bɨ lɔɔ̀ Peta, ǹlɔɔ kaa waꞌà yə̂. A tɨgə̀ ŋ̀ghɨrə bɨ twoŋ bɨ̀sogyɛ̀ bya, a betə waa yî mɔ̀ꞌɔ yî mɔ̀ꞌɔ ànnù yìi mə a ghɨrə mə tâ bɨ̀ waꞌǎ Peta bû ǹyə aà; ŋ̀ghɨrə bɨ zwitə̀ waa bɨ tsɨ̀m. Ma yuà ànnù à fɛ̀ꞌɛ̀ mə̂, Herod a lô a Yudea ǹsɨgə ŋghɛɛ a Kaisaria ǹtswe ghu. ");
INSERT INTO bfd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ǹtɔ̀ŋ Herod ɨ lɛ sɨ naŋsə nlwi nɨ a nu baTai bo bɨ̀ baSidon, bo tɨgə̀ ǹghotə waa ŋ̀ghɛɛ a nyə yu. Bɨ̀ ghɛ̀ɛ̀ mə̂, m̀foo yə mə bo lətə Blastus yìi mə à lɛ mbə ŋ̀gàŋafàꞌà yî ŋ̀wè a mbo Herod, ǹlentə nɨ̂ ǹtɔꞌɔ aa, ŋghɨrə mə tâ à kwɛtə waa. Bo ghɨ̀rə̀ mə̂ laà, ǹtɨgə ŋghɛɛ a mbɛ̀ɛ Herod mə tâ à ghɨrə tâ bo bo tswe nɨ̂ m̀bɔɔnə, ǹloŋ mə mɨ̀jɨ̂ myaa mɨ lɛ sɨ lò aa a alaꞌa mfɔ̀ Herod aà. ");
INSERT INTO bfd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bɨ lɛ ŋkàꞌa njwi yì mɔ̀ꞌɔ Herod a wɛꞌɛ ɨ̀tsə̀ꞌə̀ nɨfɔ̂ ji, ŋ̀kɔꞌɔ ŋŋaŋnə̀ a abə̀rə yu, ŋ̀ghaa a mbo bə̀ byâ. ");
INSERT INTO bfd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","À ghàà mə aa, bɨ tɨgə̀ m̀bwitə nɨ̂ yi, ǹtɔŋnə nswoŋ nɨ mə, “Kaa à sɨ̌ njì ŋù yulà bə̂, à nɨ̂ ǹjì nwì!” ");
INSERT INTO bfd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Angel Nwìŋgɔ̀ŋ à lɛ mburə ŋghɛnsə nzwitə Herod ŋgaa yî m̀fùùrə̀ nloŋ mə kaa à lɛ waꞌà Nwî ghaꞌasə̀ aà. Ɨ̀ŋɔ̀ŋnə̀ ɨ kuu ghu nu, ŋ̀kurə yi, a tɨgə̀ ŋ̀kwo. ");
INSERT INTO bfd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ànnù Nwî a lɛ ŋghɛ̀ɛ̀ nɨ̂ m̀bìì ǹsɛɛnə, bə̀ bì ghàꞌàtə bɨ biì Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas bo Saul bɨ lɛ mmàŋsə ɨfàꞌâ waa yìi mə bɨ lɛ ntoo waa mə bɨ̀ zi mfaꞌa aa, ǹtɨgə nlo Yerusalem ŋghɛɛ waa. Bo kà mə̂ aa ŋghɛɛ aa, nlɔ̀gə̀ Jɔn Mark bo bo ghɛɛ̀. ");
INSERT INTO bfd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Maa noò a nɨ̂ ŋ̀ghotə a Antiokia, ŋ̀gǎŋntoo Nwì bo bɨ̀ ŋ̀gǎŋndɨ̀ꞌɨ ànnù Nwî jî mɔꞌɔ ɨ lɛ ntswe ghu: Barnabas, Simeon yìi mə bɨ lɛ sɨ twoŋ nìi nɨ nîŋgà aa, Lucius yìi mə à lɛ mbə ŋû Cyrene aa, Manaen mə lɛ ŋkwe bo Herod yìi mə à lɛ mbə Gûmnàà aa, nɨ̀ Saul. ");
INSERT INTO bfd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Maa noò bo lɛ sɨ ghaꞌasə nɨ̂ Nwî ŋ̀kɨɨ ntswe tɨ jɨ̂, Àzwì Nwî a swoŋ a mbo bo mə, “Nɨ̀ tsɔꞌɔ Barnabas bo Saul mfa a mbo mə̀ a mfàꞌâ àfàꞌà yìi mə mə twoŋə waa mə tâ bo ghɛɛ mfàꞌà aà.” ");
INSERT INTO bfd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Maa ajàŋ bo tɨgə̀ ǹtswe tɨ jɨ, ǹtsàꞌàtə̀ Nwî, ǹnɔŋsə mbô myaa a atu bo, ǹtɨgə ntoo waa. ");
INSERT INTO bfd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Àzwì Nwî a tòò mə̂ waa laa, Barnabas bo Saul sɨgə ŋghɛ̀ɛ̀ a Seleucia ǹtɨgə ŋkuu abaŋ ghu ŋghɛɛ a kɨ̂ŋ ŋ̀kì a Cyprus. ");
INSERT INTO bfd_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bo ghɛ̀ɛ̀ mə̂ ŋ̀kuꞌu a Salamis aa, ǹswoŋ nɨghàà nɨ Nwî ghu a mûm ǹdâŋghotə̂ baIsrael. Bo lɛ nlɔ̀gə̀ Jɔn Mark mə tâ à ka ŋkwɛtə waa. ");
INSERT INTO bfd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bɨ dàŋsə̀ mə̂ kɨ̂ŋkì wa ŋ̀ghɛ̀ɛ̀ ǹyweꞌe a Paphos, ǹtsiꞌi ŋù majìkə̀ yî mɔꞌɔ mə ɨ̀kǔm yi ɨ lɛ mbə BarJesus, BarJesus ma ghû à lɛ mbə ŋû baYuda yìi mə à lɛ mbə ŋgaŋntoo Nwî m̀bweꞌesə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","À lɛ mbə nsûkàꞌa Gûmnàà yìi mə ɨ̀kǔm yi ɨ lɛ mbə Sergius Paulus aà, Gûmnàà ma ghû à lɛ mburə mbə tsiꞌì ŋù mɨ̀tsyɛ̀. À lɛ ntwoŋ Barnabas bo Saul mə tâ bo zi nyə yi, ǹloŋ mə à lɛ sɨ lɔ̀ɔ nyuꞌu nɨ̀ghàà nɨ Nwî aà. ");
INSERT INTO bfd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lâ Elymas, ŋù ŋ̀ghɨrə majìkə̀ wa (ǹloŋ mə à nɨ̂ ǹjiꞌì ɨ̀kǔm yi nɨ nɨ̀ghàà nɨ Grikia aà) a tuu, ǹlɔ̀ɔ̀ nɨ mə tâ Gûmnàà wa tâ tsuu ànnù yìi mə Saul bo Barnabas lɛ nzì nɨ yuu aa bii. ");
INSERT INTO bfd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lâ Saul yìi mə bɨ kɨɨ ntwoŋ nìi nɨ Paul aa, a luu nɨ̀ Àzwì Nwî, ǹtɛꞌɛ nɨliꞌì ni a nu ŋû majìkə̀ wa ");
INSERT INTO bfd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ǹswoŋ mə, “Mu Devil ghulà! Ò nɨ ŋùkɨ̀bàa ɨ̀nnù tsɨ̀m jìi mə ɨ tsinə aà. Ò luu nɨ̀ ɨ̀bəŋ mbweꞌesə̀ tsɨ̀m nɨ̂ àbɨ̀ꞌɨntɨɨ̀, ǹlɔɔ nɨ̂ ŋ̀ka mbəŋkə ànnù nɨ̂ŋkoŋ Mmàꞌàmbi a nɨ àbǎŋnənnù! Kaa mbə ò waꞌà kɛntə aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tsɨ̂tsɔ̀ŋ, ǹdɔɔ Nwì ɨ̀ ka kuu a atu wò; ò ka fə̀ꞌə, kaa waꞌà nɨ̂nòò bû ŋ̀ka nyə nɨ nòò yî mɔ̀ꞌɔ̂.” À ghɛ̀sə̀ mə̂ ǹswoŋ laà ŋ̀ghəə yu kɨ màŋsə̀, àfə̀ꞌə̀ a kuu ghu miꞌi, a tɨgə̀ m̀mɔɔrə nɨ̂ ɨ̀dɨ̀gə̀ ǹlɔɔ nɨ̂ ŋû mə tâ à tswa abo yi ntɨgə ntsyasə. ");
INSERT INTO bfd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gûmnàà wa à yə̀ mə annù yìi mə a lɛ mfɛ̀ꞌɛ̀ aa, ǹnɨŋtɨɨ̀ yi a nu Kristo ǹloŋ mə à lɛ nyɛrə siꞌi siꞌi a nɨ̂ ànnù yìi mə Paul à lɛ ndɨ̀ꞌɨ̀ ǹloŋə Mmàꞌàmbi aà. ");
INSERT INTO bfd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul bo bɨ̀ ŋ̀gàŋəkòrə̂ ji bo bû ŋ̀kuu abaŋ ŋghɛɛ a Perga, yìi mə à lɛ mbə mûm àlaꞌa yì ŋ̀wè a Pamphilia aà. Bo kùù mə̂ ghu aa, Jɔn Mark a maꞌàtə̀ waa ghu mbu mbɨ̀ɨ̀ fu a Yerusalem. ");
INSERT INTO bfd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bo lô a Perga ǹtɨgə ŋghɛɛ nɨ̂ m̀bìì ŋ̀ghɛɛ ŋkuu a Perga, a alaꞌa Pisidia. À bə̀ mə a ǹjwîŋgɔ̀ŋ àlaꞌa aa, bo ghɛɛ̀ ŋ̀kuu a ndâŋghòtə baIsrael, ǹtswe a nsyɛ̂. ");
INSERT INTO bfd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bɨ twòŋ mə nɔ̂ŋsə̀ Moses bo bɨ̀ ŋ̀ŋwàꞌànə ŋgǎŋntoo Nwî, ɨtu ndâŋghotə ya ɨ toò ŋ̀kɨ̀ɨ̀ a mbo bo mə: “Bɨ̀lɨ̂m biꞌi, bìꞌi lɔ̀ɔ mə tâ nɨ̀ ghaa a mbo bə̀ bû, mə mbə nɨ̀ tswe nɨ̂ ǹdɨꞌɨtə̀ yìi mə mbə ɨ kwɛtə̀ waa.” ");
INSERT INTO bfd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul a bɨɨ̀nə̀ ǹtəə a ndəŋ, ŋ̀ŋɛntə mbô mi, ntsɨmsə nda, ǹlɔ̀gɨ̀nə̀ ŋ̀ka ŋghaa, ǹswoŋ mə: “Bɨ̀lɨ̂m ba baIsrael nɨ bù bìi mə nɨ bɔꞌɔ nɨ̂ Nwì aa, nɨ̀ yuꞌutə. ");
INSERT INTO bfd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nwìŋgɔ̀ŋ baIsrael à lɛ ntsɔꞌɔ bɨ̂tà bɨ bɨ̂taà biꞌinə̀, ŋ̀ghɨrə bo bə ŋ̀gwɛ̀ꞌɛ̀ àlaꞌa yì wè wa noò mə bo lɛ ntswe a alaꞌa Egipto tsiꞌì tsǒ bɨ̀gɨ̀ɨ̀ aà. Nwìŋgɔ̀ŋ à lɛ mfiꞌisə waa a alaꞌa Egipto nɨ mɨ̀dàꞌà mi mya mì wè. ");
INSERT INTO bfd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ǹtswa ntɨɨ̀ yi a nu bo a njɨ̌m ɨ̀lòò mɨghum mi nɨkwà a ntaꞌa mɨwɛ̀ɛ̀ mɨ wɛ̀ɛ̀. ");
INSERT INTO bfd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","À lɛ mbwɛsə ɨtoo ji sàmbaa a alaꞌa Kanaan, ǹtɨgə mfa nsyɛ̂ ɨ̀too mà jya a mbo baIsrael. ");
INSERT INTO bfd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Bo tswê ghu tsǒ ɨ̀lòô ŋ̀khɨ̀ ji nɨkwà nɨ mɨ̀ghum mi ntaà. À tɨ̀ mə tɨ bə a njɨ̀m a fa bɨ̀saꞌa bɨ alaꞌa a mbo bo ŋ̀kɔꞌɔ nyweꞌe a noò ŋ̀gàŋtoò Nwì Samuel. ");
INSERT INTO bfd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ma mùu noò bo lɛ mbetə Nwî mə tâ à fa mfɔ̀ a mbo bo, a tɨgə̀ m̀fa Saul yìi mə à lɛ mbə mu Kish, ǹlo a ŋgwɛ̀ꞌɛ Benjamin aa, mə tâ à bə mfɔ̀ wàà nɨ̂ ɨ̀lòò mɨghum mi nɨkwà. ");
INSERT INTO bfd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nwì à lɛɛ̀ m̀fiꞌi yi aa, ntɨgə ŋghɨrə David nɨ̂ m̀fɔ̀. Yuà ànnù à nɨ ànnù yìi mə Nwì yumbɔŋ à lɛ nswoŋ nloŋ ŋgaa yì aà: ‘Mə̀ lii nyə mə David mu Jesse à nɨ ŋù yìi mə ǹtɨɨ̀ gha ɨ dorɨtə ghu nu aà, m̀bə ŋû yìi mə à ka ghɨ̀rə ɨnnù tsɨ̀m jìi mə mə lɔ̀ɔ̀ aà.’ ");
INSERT INTO bfd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","À lɛ ntɨgə mbə Yesu yìi mə à lɛ mfɛ̀ꞌɛ a ŋgwɛ̀ꞌɛ David aa, mə Nwì à lɛ ŋghɨ̀rə̀ a tɨgə̀ mbə Ŋgàŋywèènsə baIsrael, a ajàŋ yìi mə a lɛɛ̀ m̀foo ŋkàꞌà aà. ");
INSERT INTO bfd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","M̀bɔŋ tâ Yesu à ka nlɔgɨnə ɨfàꞌâ yi, lɛ boŋ Jɔn à kà mə̂ aa nswoŋ nɨ a mbo baIsrael bɨtsɨ̀m mə, tâ bo bəŋkə mɨ̂ntɨɨ̀ myaa, m̀maꞌatə ɨnnù jî bɨ̂ jyaa ŋkwɛrə ŋkì. ");
INSERT INTO bfd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nòò yìi mə Jɔn à lɛ ŋka maŋsə ɨfàꞌâ yi aa, ǹswoŋ a mbo bo mə, ‘Nɨ̀ mɔ̀ɔ̀ntə mə mə̀ nɨ aa wò ɛ? Kaa mə̀ sɨ̀ yu wa mə nɨ yuꞌutə aa bə̂. Lâ, yə̂ nɨ̀! Yu wa mə a yòŋə a njɨ̌m mə̀ aa, kaa mə̀ sɨ̀ kuꞌùnə̀ a ajàŋ yìi mə mbə mə̀ fɛɛ̀ mɨ̀kɨ̀rə̀ mɨ ntam jìi ɨ tswe ghu mɨkòrə̀ aà.’ ");
INSERT INTO bfd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Bɨ̀lɨ̂m ba baIsrael, bɔɔ bɨ ŋgwɛ̀ꞌɛ̀ Abraham nɨ bù bə̀ bìi mə nɨ bɔꞌɔ nɨ̂ Nwî aà, ǹtoo mà yû yìi mə ɨ̀ nɨ yî ǹywèènsə bə̀ aa, ɨ̀ zì mə a mbo bìꞌinə̀ tsɨ̂tsɔ̀ŋ. ");
INSERT INTO bfd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ǹloŋ mə bə̀ bìi mə bɨ lɛ ntswe a Yerusalem aa, nɨ bɨ̀tsyàsə̂ byaa kaa bɨ lɛ waꞌà zi mə à nɨ ŋù ǹywèènsə bə̀; kaa waꞌà kɨ̀ɨ̀ nɨ̂ ànnù yìi mə nɨghàà nɨ ŋgǎŋntoo Nwî nìi mə bɨ lɛ sɨ twoŋ a njwiŋgɔ̌ŋ tsɨ̀m nɨ swoŋə̀ ǹloŋ ŋgaa yì aa yuꞌù. Bɨ lɛ ŋghɨ̀rə̀ nɨghàà nɨ ŋgǎŋntoo Nwî nɨ fɛꞌɛ̀ boontə nyoŋə ajàŋ yìi mə bɨ lɛ nzwitə yi aà. ");
INSERT INTO bfd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ka mə bɨ lɛ waꞌǎ annù tsu yə yìi mə Yesu à lɛ fànsə̀ mə mbə bɨ zwitə̀ yi aa, bɨ lɛ nswoŋ a mbo Pilato mə tâ à ghɨrə tâ bɨ̀ zwitə yi. ");
INSERT INTO bfd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bɨ màŋsə̀ mə a ghɨ̀rə ɨ̀nnù tsɨ̀m jìi mə àŋwàꞌànə̀ Nwî a lɛ nswoŋ nloŋ ŋgaa yì aa, bɨ sɨgɨsə̀ yi wa ati bàŋnə̀ bàŋnə̀ ŋ̀ghɛɛ nlə̀ə̀ yi nɨsyɛ̀. ");
INSERT INTO bfd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lâ Nwì a yweensə̀ yi nɨ nɨ̀wô; ");
INSERT INTO bfd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ǹjwi jì ghàꞌàtə̀ jìi mə ɨ lɛ sɨ tɨgə nyoŋə aa, a dɨꞌɨ̀ ɨ̀bɨ̀ɨ nû yi a mbo bə̀ bìi mə bo bo lɛ nlǒ a Galilea ŋ̀kɔꞌɔ a Yeruselem aa, bìi mə bo tɨgə mbə bɨ̂yəfə̂ bi a mbo bə̀ bɨ̀ tsɨ̀m aà. ");
INSERT INTO bfd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Bìꞌi zi aa nɨ̀ ǹtoo yì ǹsɨgɨ̀nə̀ ma yû a mbo bù: Ànnù ya mə Nwì à lɛ ŋkàꞌà mə yu ka ghɨ̀rə̀ a mbo bɨ̀tà bɨ bɨ̂taà bìꞌinə̀ aa, ");
INSERT INTO bfd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","à ghɨ̀rə̀ mə a mbo bìꞌinə̀ bìi mə bìꞌinə̀ nɨ bɔɔ̀ byaa a njɨ̀mə àjàŋ yìi mə à ywèènsə Yesu, a bû ǹtswe ntɨ̀ɨ̀ aà. A ajàŋ yìi mə bɨ ŋwaꞌanə nɨ̂ àŋwàꞌànə̀ bɨ̂Psalm bi baa, mə, ‘Ò nɨ mû ghà, sìi mə̀ tɨgə taà ghò’ ");
INSERT INTO bfd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yuà a kɨ̂ m̀bə annù yìi mə Nwì à lɛ nswoŋ nloŋ ajàŋ mə yu ka yǐ yweensə yi nɨ nɨ̀wô, tâ à waꞌà a mum nɨ̀syɛ̀ bwɛ̂ aà: ‘Ma ka fa mbɔɔnə ya yìi mə ɨ̀ nɨ̂ yà m̀bə yî ànnù nɨ̂ŋkoŋ yìi mə mə̀ lɛ ŋkàꞌà a mbo David aa, a mbo wò.’ ");
INSERT INTO bfd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tsiꞌì ànnù nɨ̂ŋkoŋ a ajàŋ yìi mə à kɨ nswoŋ a nɨ̂ àdɨ̀gə aŋwàꞌànə̀ yî mɔꞌɔ aa mə, ‘kaa ò ka waꞌà màꞌàtə̀ tâ ŋ̀gàŋàfàꞌâ ghò, yu wa yìi mə à làa màŋsə̀ aa, tâ à bwɛ nɨsyɛ̀.’ ");
INSERT INTO bfd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ǹloŋ mə David à lɛ ŋghɨ̀rə annù yìi mə Nwì a lɔ̀ɔ̀ aa, a nɨ yìi ŋgùꞌù aa, ntɨgə ŋkwo, bɨ twiŋə̀ yi bo bɨ̀ bɨ̀taà bi, ɨ̀bɨ̀ɨnû yi ɨ bwɛ̂ a nɨsyɛ̀. ");
INSERT INTO bfd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lâ yu wa yìi mə Nwì à lɛ nyweensə nɨ nɨ̀wo aa kaa à lɛ waꞌǎ a nɨsyɛ̀ bwɛ̂. ");
INSERT INTO bfd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Bìꞌi lɔ̀ɔ̀ mə tâ nɨ̀ zi mbâ bɨlɨ̂m ba baIsrael, mə bìꞌì tsya aa a njɨ̌m Yesu ma ghû ǹzi a nswoŋ ànnù a mbo bù ǹloŋ ànnǔ lìꞌìnə ɨfansə ɨnnù. ");
INSERT INTO bfd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ǹlɔɔ nɨ mə nɨ̀ zi mə ŋù ǹtsɨ̀m yìi mə à nɨ̌ŋ ntɨɨ̀ yi ghu nu aa, ɨ̀nnù tsɨ̀m jìi mə à fànsə a ǹyòŋə nɨ nɔ̀ŋsə̀ Moses aa, kaa ɨ ka waꞌà yi bǔ ntswa. ");
INSERT INTO bfd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nɨ̀ tsyɛsə lâ m̀bɨ̀ꞌɨ̀ ɨ̀nnù jìi mə ŋ̀gǎŋntoo Nwî ɨ lɛ nswoŋ aa, ɨ tswâ ghuu; ");
INSERT INTO bfd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Yə̂ nɨ̀, làꞌà bu bìi mə nɨ tsaꞌa nɨ̂ nɨ̀ghàà nɨ Nwî ŋ̀wyɛ aa, nɨ̀ ka tsɨŋ tsɨŋ hɛɛ kwo! Ǹloŋ mə ànnù yìi mə mə ghɨ̀rə a nsi bù sii aa, à nɨ ànnù yìi mə kaa nɨ̀ ka yǐ waꞌà biì, ka mə ŋù tɛꞌɛ ntɔꞌɔtə tɔꞌɔtə a mbo bù!’” ");
INSERT INTO bfd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nòò yìi mə Paul bo Barnabas lɛ màŋsə̀ ŋ̀ka mfɛꞌɛ wa ndâŋghòtə aa, bə̀ bya bɨ swoŋ a mbo bo mə tâ bo bu mbɨ̀ɨ̀ a njwîŋgɔ̀ŋ yìi mə ɨ bù ǹzi aa, ta bǔ swoŋ ɨnnù ma jû jî ghàꞌàtə̀ a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bɨ kà mə̂ aa nsɛɛnə wa ndâŋghòtə, baYuda bî ghàꞌàtə̀ bo bɨ̀ bə̀ bɨ ɨtoo dàŋ bìi mə bɨ lɛ mbii annù Nwì baYuda aa, bɨ yoŋə̌ Paul bo Barnabas. Bo tɨgə̀ ŋ̀ghaa a mbo bo ndɨꞌɨtə waa mə tâ bo ghɛɛ nɨ̂ m̀bìì a mûm ɨ̀bɔ̀ŋ Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bə̀ bɨ̀ tsɨ̀m bìi mə bɨ lɛ ntswe wa a mûm àlaꞌa aa, bɨ lɛ nzì a nyuꞌu nɨ̀ghàà nɨ Nwî a nɨ̂ ǹjwîŋgɔ̀ŋ yìi mə ɨ̀ lɛ nyòŋtə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nòò yìi mə baYuda lɛ nyə nnɔ̀ɔ̀ bə̂ wa aa, bɨ lɛ nluu nɨ̂ àghə̀ꞌə̀nə̀; ǹlɔgɨnə ntɨgə nlɨgɨtə nɨ̂ ànnù yìi mə Paul à lɛ sɨ swoŋ aa, ŋ̀kɨɨ mbəgɨtə nɨ̂ yi. ");
INSERT INTO bfd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lâ Paul nɨ Barnabas bâŋnə̀ m̀bu ŋghaa bə nɨ̀ mɨ̀tɨ̀ɨ̀ nɨ̂ àtàŋəntɨɨ nswoŋ mə “A lɛ ŋkùꞌùnə̀ mə tâ nɨ̀ghàà nɨ Nwî nɨ̀ foo nzì a mbo bù. Lâ àjàŋ yìi mə nɨ̀ tuu ŋkɨ lentə mə kaa nɨ̀ sɨ̀ kuꞌùnə̀ a njɨ ɨ̀lòŋ yìi mə ɨ tswe nɨ̂ŋkoŋ aa, bìꞌì ka màꞌàtə̀ ghuu tɨgə ghɛ̀ɛ̀ tsɨ̂tsɔ̀ŋ a mbô bɨ̀tɨ̀zî Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ǹloŋ mə à nɨ ǹdɨꞌɨ yìi mə M̀màꞌàmbî à lɛ mfa a mbo bìꞌì aà, mə: ‘Mə̀ ghɨ̀rə ghuu mə tâ nɨ̀ bə ŋkàꞌà a mbo bɨ̀tɨ̀zî Nwî, ɨ tɨgə ghɨ̀rə̀ nɨ mə tâ bə̀ bɨ̀tsɨ̀m bɨ̀ yweenə ŋghɛɛ nyweꞌe a nlwìꞌî m̀bî.’” ");
INSERT INTO bfd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nòò yìi mə bɨ̀tɨ̀zî Nwî bɨ lɛ nyuꞌu ma mùu ajàŋ aa, ǹdorə tsiꞌǐ mbə̂ ànnù, ŋ̀ghaꞌasə Mmàꞌàmbi nloŋ nɨghàâ ni ma nû. Bə̀ bìi mə Nwì à lɛɛ̀ m̀foo ntsɔꞌɔ waa mə tâ bɨ̀ yi njɨ ɨlòŋ yìi mə ɨ lwiꞌi nɨ̀ŋkoŋ aa, bɨ nɨŋ mɨ̀ntɨɨ̀ myaa a nu Kristo. ");
INSERT INTO bfd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nɨ̀ghàà nɨ Mmàꞌàmbi nɨ sɛɛ̀nə̀ ŋ̀ghɛɛ ɨdɨgə tsɨ̀m maa m̀bùꞌù. ");
INSERT INTO bfd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lâ baYuda ghɛɛ̀ ǹswugɨtə bɨtà bɨ alaꞌa bɨ baYuda bo bɨ bàŋgyɛ̀ bî wè bìi mə bɨ lɛ sɨ bɔꞌɔ nɨ̂ Nwî aà. Bo lɔgɨ̀nə̀ ǹtɨgə ntsɔꞌɔ nɨ̂ àkòrə Paul bo Barnabas, m̀furə waa a mûm àlaꞌa bo. ");
INSERT INTO bfd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bo tɨgə̀ ǹyɛtə nsyɛ̂ a mɨkòrə bo, a ndɨꞌɨ mə a fùrə bo furə waa, ǹtɨgə ŋghɛɛ waa a Ikonium. ");
INSERT INTO bfd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Lâ ŋ̀gǎŋyəgə̂nnù Yesu jìi mə bɨ lɛ ntswe a Antiokia aa, ɨ lɛ nluu nɨ nɨ̀dorə bo Àzwì Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Bo lɛ ŋghɛ̀ɛ̀ nɨ̂ m̀bìì tsiꞌì maa ajàŋ a alaꞌa Ikonium. Paul bo Barnabas bo ghɛɛ̀ ŋ̀kuu a ndâŋghotə baIsrael ŋ̀ghaa nɨ mânjì yìi mə bə̀ bì ghàꞌàtə̀, baYuda bo bɨ̀ baGrikia, bɨ lɛ mbii annù Nwî. ");
INSERT INTO bfd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lâ baYuda bìi mə bɨ lɛ waꞌà waa bii aa, bɨ lɛ ntotə bɨ̂tɨ̀zî Nwî bya, mbɨsə mɨ̂ntɨɨ̀ myaa a nu bɔɔ bɨ Kristo. ");
INSERT INTO bfd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ŋ̀gǎŋntoo Kristo jya lɛ ntswe ghu a nɨ nòò yî ǹsyà, ǹswoŋə nɨ nɨ̀ghàà nɨ Mmàꞌàmbi nɨ̂ àtàŋə ntɨɨ̀. M̀màꞌàmbi a dɨꞌɨ̀ nɨ̂ ǹsi mə ǹtoò yì yî ǹsɨgɨ̀nə̀ ya mə bɨ lɛ sɨ swoŋ nloŋ ɨbɔ̀ŋ yi aa, à nɨ̂ ànnù nɨ̂ŋkoŋə̀. M̀fa mɨdaꞌa a mbo bo mə tâ bo ka ŋghɨrə ɨlensə ɨnnù bo bɨ̀ ɨ̀nnǔtsyâmbô. ");
INSERT INTO bfd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bə̀ bìi mə bɨ lɛ ntswe maa njɔ̀ꞌɔ̀ àlaꞌa aa, bɨ lɛ nyàtə̀ m̀bɛ̀ɛ̀ baa, bì mɔꞌɔ biì ànnù yìi mə baYuda lɛ sɨ swoŋ aa, bǐ mɔꞌɔ bɨ kɨ̂ŋ mbii ànnù yìi mə ŋgǎŋntoo Kristo jya ɨ lɛ sɨ swoŋ aà. ");
INSERT INTO bfd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bɨ̀tɨ̀zî Nwî bî mɔꞌɔ nɨ baYuda bo bɨ̀ bɨ̀lɨɨ̀ byaa bɨ taŋ mɨnàŋ mə bɨ dɨ̌ ŋgɨꞌɨ a nu bo, ɨ tumtə waa nɨ̂ ŋ̀gɔ̀ꞌɔ̀. ");
INSERT INTO bfd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bo yuꞌu ntɨgə mfɛꞌɛ ŋkhə̀ ŋghɛɛ waa a ɨlaꞌa Lystra bo Derbe, jìi mə ɨ lɛ ntswe a Lycaonian aa, bo bɨ nɨ̂ ɨ̀too jìi mə ɨ lɛ ntswe maa mbɨ̂ àdɨ̀gə̀ aa, ");
INSERT INTO bfd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ǹtɨgə nswoŋə nɨ̂ ǹtoo yì ǹsɨgɨ̀nə̀ ya ghu. ");
INSERT INTO bfd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ŋùmbâŋnə̀ yî mɔꞌɔ à lɛ ntswe a alaꞌa Lystra yìi mə à lɛ mbwenkə ǹlɔgɨnə a noò yìi mə bɨ lɛ njwe yi ghu aa, kaa a lɛɛ̀ waꞌà bùrə̀ ǹtəə təə. ");
INSERT INTO bfd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","À lɛ ntswe ghu nnaŋsə nyuꞌutə nɨ nɨ̀ghàà nìi mə Paul à lɛ sɨ swoŋ aà. Paul à lɛ nyə mə à nɨ̌ŋ ntɨɨ̀ yi ghu, ŋ̀kɨ ntswe nɨ̂ àbìintɨɨ mə mbə bɨ tsuꞌù yi. Paul à yə̀ mə̂ laa, ǹtɨgə ntɛꞌɛ miꞌì mi ghu nû. ");
INSERT INTO bfd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ǹtɔŋnə nswoŋ ghu mbo mə, “Bɨ̀ɨ̀nə ntsinə ntəə nɨ mɨ̀kòrə̂ mô.” Ŋùmbâŋnə̀ wa a lɨ mbɨ̀ɨ̀nə̀, ǹtɨgə ŋghantə. ");
INSERT INTO bfd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Àjàŋə mə nnɔ̀ɔ̀ bə̀ wa ɨ lɛ nyə annù ya mə Paul à lɛ ŋghɨ̀rə̀ aa, bo lɛ nlɔ̀gɨ̀nə̀ ǹtɨgə ntɔŋnə nɨ nɨ̀ghàà nɨ Lyacaonian nyaa nya nswoŋə nɨ mə, “Bɨ̀nwì bə̀ŋkə̀ mə̂ waa ntɨgə mbə tsǒ bə̀, ǹsɨgə ntɨgə ntswe a tɨtɨ̀ɨ bìꞌinə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bo fâ ɨ̀kǔm Barnabas mə à nɨ Zeus, ŋ̀kɨ ntɨgə ntwoŋ Paul nɨ Hermes, ǹloŋ mə à lɛ mbə yu yìi mə à lɛ mbə ndɨɨ wàà, ŋ̀ghaa nɨ tsùsə̀ àtû wàà laa. ");
INSERT INTO bfd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ŋ̀gàŋmàꞌanwì Zeus wa yìi mə ǹdâmàꞌa yì ɨ̀ lɛ ŋghɛ̀sə̀ ǹtswe tsiꞌì wa mbɛ̀ɛ̀ àlaꞌa aa, à lɛ nzì nɨ̂ m̀bɔ̀ŋ bo bɨ̀ nɨ̀kya nɨ bɨ̂flawa, ǹloŋ mə bo bɨ̀ nnɔ̀ɔ̀ bə̂ wa bɨ lɛ lɔ̀ɔ̀ mə bo maꞌa ŋgǎŋntoo Kristo jya tsiꞌì tsǒ Nwì. ");
INSERT INTO bfd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lâ ŋ̀gǎŋntoo Kristo jya, Barnabas bo Paul, bɨ yùꞌù mə annù ya mə bɨ lɛ sɨ lɔ̀ɔ̀ a ŋghɨ̀rə̀ aa, ǹsatə ɨtsə̀ꞌə̂ jyaa, ŋ̀khə ŋkuu ntəə wa tɨtɨ̀ɨ nnɔ̀ɔ̀ bə̂ wa, ŋ̀ŋɛntə njì yàà m̀betə waa mə, ");
INSERT INTO bfd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nɨ̌ ghɨ̀rə yulà ànnù aa a ya ɛ? Bìꞌì kɨ mbə aa tsiꞌì bàmɨsɔ̀ŋə̀ tsǒ bù. Bìꞌì zi faà aa a ŋkɛ̀ꞌɛ̀nə ǹtoo yì ǹsɨgɨ̀nə̀ a mbo bù, mə tâ nɨ̀ bəŋkə ghuu, m̀maꞌatə njoo adàŋə̀ àdàŋə̀ ǹzi a mbo M̀màꞌàmbi yìi mə à tswe ntɨ̀ɨ̀ aà. À nɨ yu yìi mə à lɛ nnaŋsə aburə nɨ̂ ǹsyɛ, nɨ̂ ŋ̀kì mɨyaa, bo bɨ̀ ŋ̀gɔ̀ŋ ǹjoò tsɨ̀m jìi mə ɨ tswe ghu aà. ");
INSERT INTO bfd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","À lɛ mbə mbìì aa, a maꞌàtə̀ bə̀ bɨ ɨtoo bɨ̀ tsɨ̀m mə tâ ŋù à ka ŋghɛɛ nɨ̂ yìi mânjì, ŋù à ka ŋghɛɛ nɨ̂ yì. ");
INSERT INTO bfd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lâ, a dɨꞌɨ̀ nɨ̂ àlèsə̀ mə yu tswe ghu ŋgɔ̀ŋ bɨ̀nòò bɨ̀tsɨ̀m, ǹyoŋə a njɨ̌m ɨ̀nnù jî sɨgɨ̀nə̀ jìi mə a ghɨ̀rə̀ aà. A too nɨ̂ m̀bə̀ŋ a mbo bù, ɨ lô a aburə nsɨgə ntsu nɨ̂ mɨ̀jɨ̂ muu nɨ nòò yìi mə à kùꞌùnə aà. A fa nɨ mɨ̀jɨ a mbo bù ŋ̀kɨɨ nlwensə nɨ mɨ̀ntɨɨ̀ muu nɨ nɨ̀dorə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ka mə bo lɛ nswoŋ laa, a lɛ ntsyànə̀ a mbô ŋ̀gǎŋntoo Kristo jya a ŋkɨŋə mə tâ bɨ̀ tsuu waa màꞌà tsǒ Nwì. ");
INSERT INTO bfd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","BaYuda bǐ mɔꞌɔ bɨ lɛ nlò a Antiokia yìi mə à lɛ ntswe a Pisidia aa, bo bɨ̀ a Ikonium, nzi mbəŋkə atu bə̂ bya bɨ biì ǹjɨ̀m yàà, ǹtɨgə ntumtə Paul nɨ̂ ŋ̀gɔ̀ꞌɔ̀, ǹswuŋə yi mfɛꞌɛ nɨ ghu a mûm àlaꞌa ŋwaꞌatə mə à kwò mə̂. ");
INSERT INTO bfd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nòò yìi mə bɔɔ bɨ Kristo bɨ lɛ nzì ntswe ghu mbɛ̀ɛ̀ ŋ̀karɨsə aa, a bɨɨ̀nə̀ m̀bu ŋkuu ŋghɛɛ fu a mûm àlaꞌà. Àbɛ̀ɛ̀ a fùꞌù mə yu nɨ Barnabas bo ghɛɛ̀ a alaꞌa Derbe. ");
INSERT INTO bfd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul nɨ Barnabas bo lɛ nswoŋ ntoo yì ǹsɨgɨ̀nə̀ ya a alaꞌa Derbe, ŋ̀ghɨrə ŋgǎŋyəgənnù Yesu jî ghàꞌàtə̀ ghu. Ǹtɨgə nlo ghu mbu bɨ̀ɨ̀ a Lystra bo bɨ Ikonium nɨ Antiokia yìi mə à lɛ ntswe a Pisidia aà. ");
INSERT INTO bfd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bo lɛ nnɨŋ mɨtɨ̀ɨ̀ a nu bɔɔ bɨ Kristo bìi mə bɨ lɛ ntswe ghu aa, ǹdɨɨntə waa mə tâ bo tswa abìintɨɨ̀ yaa tsiꞌì ànnù nɨ̂ŋkoŋə̀. Ǹswoŋə nɨ mə, “A kuꞌunə mə tâ bìꞌì tsya a mûm ŋ̀gɨꞌɨ yì ŋghàꞌàtə̀ m̀bɔŋ ŋkuuu a mûm ànnù nɨfɔ̀ Nwî.” ");
INSERT INTO bfd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bo yi ŋghɛ̀ɛ̀ nɨ yulà ŋ̀ghòtə bɨ tsɔꞌɔtə̀ bɨ̀lɨ̀ɨ bɨ ndânwì ghu, ǹsiꞌisə ɨbɨɨnû waa tɨ jɨ, ǹtsaꞌatə Nwî, ǹnɨŋə waa a mbô M̀màꞌàmbi yìi mə bo lɛ ntswe nɨ̂ ǹnɨŋ mɨ̀ntɨɨ̀ myaa ghu nu aà. ");
INSERT INTO bfd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bo tsyà mə a alaꞌa Pisidia mmaŋsə, ǹtɨgə ŋkuu a Pamphilia. ");
INSERT INTO bfd_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ma mùu alaꞌa, bo swoŋ ntoo yì nsɨgɨ̀nə̀ ya a alaꞌa Perga, ǹtɨgə nlo ŋghɛ̀ɛ̀ a alaꞌa Attalia. ");
INSERT INTO bfd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bo lò mə̂ ghu ntɨgə ŋkuu a abaŋə ŋkì, m̀bu mbɨ̀ɨ̀ ŋ̀ghɛɛ fu a Antiokia, wa adɨgə mə bɨ lɛ ntɛꞌɛ ntsɔꞌɔ waa ghu, ntsaꞌatə Nwî a atu bo mə tâ à kwɛtə waa a nɨ̂ ɨ̀fàꞌà yìi bɨ lɛ ŋghɛ̀ɛ̀ mfaꞌa aà. ");
INSERT INTO bfd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bo zì mə̂ ǹyweꞌe a Antiokia aa, ŋ̀ghotə bandânwì bɨtsɨ̀m, ŋ̀kɛꞌɛnə ŋgɔ̀ŋ ɨ̀nnǔ tsɨ̀m jìi mə Nwìŋgɔ̀ŋ à lɛ ŋghɨ̀rə a nu bo aa, bo bɨ̀ àjàŋ mə à lɛ ŋŋaꞌa mânjì mə tâ bɨ̀tɨ̀zî Nwî tâ bɨ̀ bii yii aà. ");
INSERT INTO bfd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bo lɛ ntɨgə ntswe ma mùu alaꞌa bo bɨ̀ ŋ̀gǎŋyəgə̂nnù Yesu ntɨgɨtə. ");
INSERT INTO bfd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bə̀ bî mɔꞌɔ bɨ lɛ nlò a Yudea ǹsɨgə a Antiokia, ǹlɔgɨnə ŋka ndɨꞌɨ nɨ̂ ɨ̀nnù a mbo bɔɔ bɨ Kristo bya mə, “Kaa nɨ̀ ka yǐ waꞌà yweenə̀ mə mbə bɨ tsuu ghuu ŋə̀tə a nyòŋə nɨ nɔ̀ŋsə̀ Moses.” ");
INSERT INTO bfd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul bo Barnabas bo lɨgɨ̀tə̀, ǹswuŋnə bo bo tsiꞌǐ annù nɨ̂ŋkoŋə̀. Tsǒ mə a lɛ mbə laa, bɨ swoŋ mə tâ Paul bo Barnabas bo bə̀ bî mɔꞌɔ a Antiokia tâ bo kɔꞌɔ ŋghɛɛ a Yerusalem ŋghɛɛ nyə ŋgǎŋtoo jya ghu nɨ bɨ̀lɨ̀ɨ bɨ ndânwì tâ bo bo ghaanə nloŋ ma yaà ànnù. ");
INSERT INTO bfd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ŋ̀ghòtə ɨ̀ lɛ ntɨgə tsyasə waa mə tâ bo ghɛɛ. Bo kà mə̂ aa ŋghɛɛ, ǹtsya a alaꞌa Phonisia bo Samaria, ŋ̀kɛꞌɛnə a mbo bə̀ a ajàŋ mə bɨ̀tɨ̀zî Nwì bɨ bə̀ŋkə̀ mə̂ mɨ̂ntɨɨ̀ mya ǹzi a mbo Nwì. Ma yu ànnù a ghɨ̀rə̀ ǹtɨɨ bɔɔ bɨ Kristo ɨ luu nɨ̀ nɨ̀dorə̀. ");
INSERT INTO bfd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bo ghɛ̀ɛ̀ mə̂ ŋ̀kuu a Yerusalem, ŋ̀ghòtə ɨ kwərə̀ waa tsiꞌì nɨ̀ nɨ̀dorə̀. Ŋ̀gǎŋtoo Kristo nɨ bɨ̀lɨ̀ɨ bɨ ndânwì bɨ kɨ̂ ŋ̀kwɛrə waa nɨ nɨ̀dorə, bo tɨgə̀ ǹswoŋ ŋkɔ̀ŋ ɨ̀nnù tsɨ̀m jìi Nwì à ghɨ̀rə ntsyǎ a nu bo aa, a mbo bo. ");
INSERT INTO bfd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lâ ŋ̀gǎŋmbii Kristo jî mɔꞌɔ jìi mə ɨ lɛ mbə baFarɨsai aa, bo lɛ mbɨ̀ɨ̀nə̀ ǹtəə a ndəŋ nswoŋ mə, “A kuꞌunə mə tâ bɨ̀ lɨgɨnə ŋŋètə̀ bɨtɨ̀zî Nwî ŋ̀kɨ ŋghɨrə mə tâ bo ka nyuꞌunə nɔ̂ŋsə̀ Moses.” ");
INSERT INTO bfd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ŋ̀gǎŋtoo Kristo jya bo bɨ̀lɨ̀ɨ bɨ ndânwì bɨ tɨgə̀ m̀boontə ntswe a nlèntə ma yuù annù. ");
INSERT INTO bfd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bo swùŋnə̀ mə̂ ghu àghaꞌa a saꞌàtə̀, Peta a təə a ndəŋ nswoŋ mə, “Bɨ̀lɨ̂m bâ, nɨ̀ zi mə àghaꞌa a sàꞌà mə̂ a ajàŋ mə Nwì à lɛ ntsɔꞌɔ gha a tɨtɨ̀ɨ bù ǹtoo mə tâ mə̀ ghɛɛ nswoŋ ntoo yì ǹsɨgɨ̀nə̀ a mbo bɨ̀tɨ̀zî Nwî mə mbə bo yuꞌu mbii. ");
INSERT INTO bfd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nwɨ̀ŋgɔ̀ŋ yumbɔŋ yìi mə à zi mmɔ̀ɔ̀ntə̀ ŋû ǹtsɨ̀m aa, a dɨ̀ꞌɨ̀ mə yu beentə ànnǔ bɨ̀tɨ̀zî yî Làà, m̀fa Azwì Nwî a mbo bo, tsiꞌi ajàŋ mə à lɛ ŋkɨ mfa a mbo bìꞌinə̀ aà. ");
INSERT INTO bfd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kaa à lɛ ŋwaꞌǎ ndènə̀ a tɨtɨ̀ɨ bo nɨ bìꞌinə̀ tɛꞌɛ̀. À lɛ nsìꞌi ntɨɨ̀ waa a njɨ̌m àbìintɨɨ̀ yaa. ");
INSERT INTO bfd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tsɨ̂tsɔ̀ŋ, a tɨgə̀ ŋ̀ghɨrə akə mə tâ nɨ̀ ka ŋkwaꞌanə Nwî, m̀beꞌesə nɨ̂ ŋ̀gǎŋyəgə̂nnù Yesu nɨ̂ àbèꞌè yìi mə kaa bɨ̀ta bɨ bɨ̂taà biꞌinə̀ bɨ̂mbɔŋ lɛ ŋwaꞌǎ a mbèꞌe zi, mə kaa bìꞌinə, nɨ̂ yìꞌinə ŋgaa kaa bìꞌinə̀ sɨ̌ a mbèꞌe kɨ nzi aa ɛ? ");
INSERT INTO bfd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ŋ̀gàŋə ghâ, bìꞌinə̀ bìì mə̂ bìꞌinə̀ ka yǐ yweenə aa a njɨ̌m ɨbɔ̌ŋ Mmàꞌàmbî yìꞌinə̀ Yesu tsiꞌǐ a ajàŋ yìi bo ka yǐ kɨɨ yweenə ghu aà.” ");
INSERT INTO bfd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ŋ̀ghòtə ya tsiꞌì ǹtsɨ̀m ɨ̀ lɛ siꞌi mə swee nyuꞌu annù yìi mə Barnabas bo Paul lɛ ŋkɛ̀ꞌɛ̀nə̀ aa, nɨ ɨ̀lènsə̀ a bɔ̀ꞌɔ nɨ̂ ɨnnǔtsyâmbo jìi mə Nwì à lɛ ŋghɨ̀rə̀ a tɨtɨ̀ɨ bɨ̀tɨ̀zî Nwî ǹtsya a njɨ̌m bo aà. ");
INSERT INTO bfd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bo màŋsə̀ mə̂ ŋ̀ghaa aa, Jɛms a ŋɛntə̀ ǹjì yì ŋ̀ghaa, nswoŋ mə, “Yuꞌutə nɨ̀ ànnù yìi mə mə swoŋ aa mba bɨlɨ̂m bâ. ");
INSERT INTO bfd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon à nàŋsə̀ mə̂ a ntɔꞌɔtə ajàŋ yìi mə Nwì à lɛ ndɨ̀ꞌɨ̀ àjàŋ yìi mə annù bɨ tɨ̀zî Nwî lɛ nnaŋsə ntswe a nu yu, ǹzi mfiꞌi bə̂ bî mɔꞌɔ a tɨtɨ̀ɨ bo mə tâ bɨ̀ bə bi. ");
INSERT INTO bfd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ma yuà ànnù a boòntə̀ nɨ̂ ànnù yìi mə ǹtoonwî ɨ lɛ nswoŋ a mûm àŋwàꞌànə Nwî aa mə, ");
INSERT INTO bfd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘M̀màꞌàmbi à swoŋ mə, ma yû ka yǐ tsyǎ tâ mə̀ bu mbɨ̀ɨ̀, mbɨ̀ɨ̀nsə ntǎŋ Mfɔ̀ David yìi mə ɨ wò mə aa, ɨ bu ghurə mɨtsyə̂ mi ɨ ghɨ̀rə tâ mɨ̀ bu nnaŋsə ntsinə ntəə ");
INSERT INTO bfd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ma mùu ajàŋ tâ àbùgə ŋgwɛ̀ꞌɛ̀ mu ŋù ǹtsɨ̀m ɨ̀ tɨgə nlɔɔ nɨ Mmàꞌm̀bî bo bɨ̀ ɨ̀toò tsɨ̀m jìi mə bɨ twoŋə waa nɨ̂ Ɨ̀kùmə̂ ghâ aà. ");
INSERT INTO bfd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","À nɨ̂ àjàŋ yìi mə Mmàꞌàmbi yìi mə à lɛɛ̀ ǹtɛꞌɛ ŋghɨrə bɨ zî ma yuà ànnù a ŋguꞌu aa, à swòŋə.’ ” ");
INSERT INTO bfd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jɛms a ghɛɛ̀ nɨ̂ m̀bìì ǹswoŋ mə, “À nɨ̂ àmɔ̀ɔ̀ntə̂ ya mə tâ bìꞌinə̀ tsuu ŋgɨꞌɨ a mbo bɨ̀tɨ̀zî Nwî bya mə bɨ bəŋkə waa mbɨɨ a mbo Nwì aa kɨ fa. ");
INSERT INTO bfd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","A kuꞌunə bə mə bìꞌinə̀ ŋwaꞌanə aŋwàꞌànə̀ ǹtoo a mbo bo nswoŋ mə tâ bo tsuu mɨjɨ mìi mə bɨ maꞌa mɨ̂ŋkobə ghu aa kɨ jɨ. Ŋ̀kɨ nswoŋ mə tâ bo maꞌatə annǔ jɨrə̀, ŋ̀kɨ tsuu naà yìi mə bɨ twɛɛ bə̂ ǹtɔ̀ŋ yi aa kɨ kurə, ǹtsuu aləə kɨɨ kɨ jɨ. ");
INSERT INTO bfd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ǹloŋ mə àghaꞌa a sàꞌà mə̂ a ajàŋ yìi mə bɨ twoŋə nɨ̂ nɔ̂ŋsə̀ Moses a mûm ŋ̀ghòtə a njwîŋgɔ̀ŋ baIsrael tsɨ̀mə̀, ŋ̀kɨɨ swoŋə nɨ̂ ànnǔ yi a mûm àlaꞌà tsɨ̀mə̀.” ");
INSERT INTO bfd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ŋ̀gǎŋtoo Kristo jya nɨ bɨ̀lɨ̀ɨ bɨ ndânwì nɨ ŋ̀ghotə ya ǹtsɨ̀m bɨ lɛ ntɨgə mbii mə bo tsɔꞌɔ bə̂ bî mɔꞌɔ a tɨtɨ̀ɨ bo ɨ too waa bo bɨ̀ Barnabas nɨ Paul a Antiokia. Bo lɛ ntsɔꞌɔ bə̂ bi baa bìi bɨ lɛ mbə bɨ̂tsyàsə̀ a tɨtɨ̀ɨ bo aà, a bə Judas yìi mə bɨ lɛ sɨ twoŋ nìi nɨ Barsabas aa, ŋkɨ mbə Silas; ");
INSERT INTO bfd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ǹtɨgə ntoo waa nɨ̂ àŋwàꞌànə̀ yulà: “Bìꞌì, ŋ̀gǎŋtoo Kristo nɨ bɨ̀lɨ̀ɨ bɨ ndânwì nɨ bɨ̀lɨ̂m buu bɨtsàꞌàtə̀ ghuu bɨlɨ̂m biꞌi bɨ tsɨ̀m bìi mə bɨ nɨ bɨ̀tɨ̀zi Nwì aa, bìi mə bɨ tswe a Antiokia nɨ Syria bo nɨ a Cilicia aà. ");
INSERT INTO bfd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bìꞌì yuꞌu mə bə̀ bî mɔꞌɔ bɨ lɛ mfɛ̀ꞌɛ̀ a tɨtɨ̀ɨ bìꞌì ǹzi mfa nɨ̂ ŋ̀gɨꞌɨ a mbo bù, ŋ̀ghɨrə mɨ̀ntɨɨ̀ muu mɨ tsəꞌə̀ ǹloŋ annù yìi mə bɨ lɛ nswoŋ aà. Lâ kaa bìꞌì lɛ ŋwaꞌà waa too bə̂, kaa kɨꞌɨ̀ ǹdɨꞌɨ yì tsù a mbo bo kɨ mfa. ");
INSERT INTO bfd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ǹloŋ ma yû ànnù, bìꞌì bòòntə̀ mə̂ m̀biinə tsiꞌì bɨ̀tsɨ̀m mə bìꞌì ka tsɔꞌɔ bə̂ ɨ too a mbo bù, tâ bo ghɛɛ bo bɨ̀ bɨ̀lɨ̂m biꞌi Barnabas bo Paul bìi mə bìꞌinə̀ kɔŋə. ");
INSERT INTO bfd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","B