﻿USE sofia;
DROP TABLE IF EXISTS sofia.bex_vpl;
CREATE TABLE bex_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bex_vpl WRITE;
INSERT INTO bex_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Di bi tisaki mo Bɔkoꞌba oꞌba mïtɔrɔ ni ti dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tine dɔliŋɔ ŋgï du tara kinza bi tɔ mo, mandölu ma dɔ kiteli na kutuꞌbö dɔ matïrï ꞌba mini. Kina Nyï Kɔtɔ Laka ꞌba Bɔkoꞌba na koloma rɔ tiliŋgere kebe bi dɔ mini. ");
INSERT INTO bex_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tine Bɔkoꞌba iya te, “Iꞌdi bi kɔpɔ këdï.” Kina bi kɔpɔ kɔdɔ ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Bɔkoꞌba ti mï këyï gɔ ame bo koŋgɔ ꞌdeni këdï laka, na bo koza bi kɔpɔ yaga di rɔ mandölu. ");
INSERT INTO bex_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Bo ïdëkï bi kɔpɔ rɔ bi këzë kina bo ïdëkï mandölu nima ŋgï rɔ korɔndɔ. Tine na dɔkɔpiyari kiteli dɔŋbɔ kuyï rönï. Ama na rɔ töꞌdö ma dɔgba. ");
INSERT INTO bex_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Tine Bɔkoꞌba iya te, “Iꞌdi a mɔtɔ këdï mï zana mini ꞌdɔ koza mï mini yaga bi rïyö.” ");
INSERT INTO bex_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kina bo koꞌdɔ a mɔtɔ koza mini ame bërï di rɔ ma koloma tɔrɔ ꞌdɔ kaꞌdi nima. Kina koꞌdɔ rönï ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Bɔkoꞌba ïdëkï wa nima rɔ mïtɔrɔ. Tine na dɔkɔpiyari kiteli dɔŋbɔ kuyï rönï. Ama na rɔ töꞌdö ma dɔ rïyö. ");
INSERT INTO bex_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Tine Bɔkoꞌba iya te, “Iꞌdi mini ma bërï nime kotɔtɔ kpënnï bi kɔtɔ, kina iꞌdi yayi ma sari kɔdɔ.” Kina koꞌdɔ rönï ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Bo ïdëkï yayi ma sari rɔ dɔyayi, kina bo ïdëkï mini ma kotɔtɔ kpënnï bi kɔtɔ naga nima rɔ yöpö. Bɔkoꞌba ti mï këyï gɔ ame bo koŋgɔ ꞌdeni këdï laka. ");
INSERT INTO bex_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Tine Bɔkoꞌba iya te, “Iꞌdi dɔyayi koja dɔkomali wa ma këdï kötu naga, dɔkomali wa ma këdï kana rɔ ꞌjɔ ti ma këdï kana ꞌbënnï rɔ döŋgërï naga.” Kina koꞌdɔ rönï ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Dɔyayi oja dɔkomali wa ma këdï kötu naga, dɔkomali wa ma këdï kana rɔ ꞌjɔ ti ma këdï kana ꞌbënnï rɔ döŋgërï naga ꞌdɔ lïjë pili kana gɔ kïnë lïjë ga. Bɔkoꞌba ti mï këyï gɔ ame bo koŋgɔ ꞌdeni këdï laka. ");
INSERT INTO bex_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Tine na dɔkɔpiyari kiteli dɔŋbɔ kuyï rönï. Ama na rɔ töꞌdö ma dɔ mota. ");
INSERT INTO bex_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Tine Bɔkoꞌba iya te, “Iꞌdi bi kɔpɔ këdï mïtɔrɔ gɔ koza bi këzë di rɔ korɔndɔ. Iꞌdi lïjë këdï rɔ akileme bi këzë ti kɔmɔ kɔɔ gbï ti töꞌdö ꞌba ꞌdɔ karama pili kisaki rönnï. ");
INSERT INTO bex_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Iꞌdi lïjë toyi bi di mïtɔrɔ kako dɔyayi.” Kina koꞌdɔ rönï ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bɔkoꞌba iꞌdi bi kɔpɔ löbu këdï rïyö. Bo iꞌdi kada ꞌbënï rɔ ma löbu rɔ ŋere ꞌba dɔ bi këzë, tine nyepe ꞌbënï rɔ ŋere ꞌba dɔ korɔndɔ. Kina bo kiꞌdi këlu ni gbï. ");
INSERT INTO bex_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Bo iꞌdi bi kɔpɔ naga nime mïtɔrɔ ꞌdɔ koyi bi dɔyayi ");
INSERT INTO bex_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ꞌdɔ këdï rɔ ŋere ꞌba dɔ bi këzë ni ti korɔndɔ, gɔ koza bi kɔpɔ yaga di rɔ bi kölu. Bɔkoꞌba ti mï këyï gɔ ame bo koŋgɔ ꞌdeni këdï laka. ");
INSERT INTO bex_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Tine na dɔkɔpiyari kiteli dɔŋbɔ kuyï rönï. Ama na rɔ töꞌdö ma dɔ sowɔ. ");
INSERT INTO bex_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Tine Bɔkoꞌba iya te, “Iꞌdi wa ame ga ti dïdï yïmo ne konzi koso mï mini, kina iꞌdi yali köpu ti kebe tɔrɔ.” ");
INSERT INTO bex_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kina Bɔkoꞌba koꞌba dɔkomali kuruku löbu ꞌba mï mini ti wa mɔtɔ ga ame ti dïdï yïmo ne ame ga pili këdï kele kebe mï mini ti dɔkomali yali pili. Bɔkoꞌba ti mï këyï gɔ ame bo koŋgɔ ꞌdeni këdï laka. ");
INSERT INTO bex_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kina bo koꞌdɔ yëyï zïnnï, iya te, “Arake konzi kogba mï mini, kina yali gɔ kara konzi mï dɔyayi.” ");
INSERT INTO bex_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Tine na dɔkɔpiyari kiteli dɔŋbɔ kuyï rönï. Ama na rɔ töꞌdö ma dɔ muyï. ");
INSERT INTO bex_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Tine Bɔkoꞌba iya te, “Iꞌdi dɔyayi koja dɔkomali yërï pili, yërï ꞌba liŋɔ ti ꞌba mökö, ti wa ma titi ma këdï kele kebe bërï naga.” Kina koꞌdɔ rönï ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bɔkoꞌba oꞌba dɔkomali yërï ꞌba liŋɔ pili ti ꞌba mökö, ti wa ma titi ame ga pili këdï kele kebe bërï mï dɔyayi naga. Bɔkoꞌba ti mï këyï gɔ ame bo koŋgɔ ꞌdeni këdï laka. ");
INSERT INTO bex_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tine Bɔkoꞌba iya te, “Iꞌdi doꞌba bilaka lesi kɔzɔ ze te, ꞌdɔ lïjë këdï ti közï kakpa dɔ kenze ꞌba mï mini, dɔ yali ma këdï köpu kebe tɔrɔ, dɔ yërï ꞌba liŋɔ ti ꞌba mökö, pili dɔ wa ma këdï kele kebe bërï mï dɔyayi naga.” ");
INSERT INTO bex_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kina bo koꞌba bilaka lesi gɔ kïnë abo ꞌba Bɔkoꞌba ꞌdɔ lïjë këdï kɔzɔ bo tara. Bo oꞌba lïjë rɔ bɔtɔni ni ti ꞌja. ");
INSERT INTO bex_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kina bo koꞌdɔ yëyï zïnnï, iya te, “Arake konzi kogba mï dɔyayi pili, kindaꞌbake közï kakpa ꞌba dɔmo. Miꞌdi ye tëdï ti közï kakpa dɔ kenze ꞌba mï mini, dɔ yali ma këdï köpu kebe tɔrɔ, dɔ wa pili ma ti dïdï ame ga këdï kiliŋgere mï dɔyayi.” ");
INSERT INTO bex_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Bo iya te, “Miꞌdi wa ame ga këdï kana rɔ ꞌjɔ ne ꞌdeni ziye mï dɔyayi pili gbï ti ma këdï kana rɔ döŋgërï naga ziye rɔ akonyo. ");
INSERT INTO bex_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tine zi yërï ꞌba mï dɔyayi pili, ti yali ma këdï köpu kebe tɔrɔ, ti wa ma titi këdï kele kebe bërï mï dɔyayi ame ga pili ti dïdï yïmo ne, miꞌdi mbili wa ma kunzï ꞌdeni zïnnï rɔ akonyo.” Kina koꞌdɔ rönï ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Bɔkoꞌba oŋgɔ wa ame ga pili bo koꞌba ne, kina bo ti mï këyï gɔmo. Tine na dɔkɔpiyari kiteli dɔŋbɔ kuyï rönï. Ama na rɔ töꞌdö ma dɔ modɔɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tine ote toꞌba mïtɔrɔ ni ti dɔyayi ꞌdeni pili ti wa mo ga ame bo kiyija ne. ");
INSERT INTO bex_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mï töꞌdö dɔ modɔmorïyö tine Bɔkoꞌba ote ndɔbɔ pili abo ga ma bo koꞌdɔ ꞌdeni, na bo kindawo rɔ bo mï töꞌdö nima. ");
INSERT INTO bex_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gɔ köꞌdu mo na bo koꞌdɔ yëyï zi töꞌdö dɔ modɔmorïyö koweli yaga rɔ töꞌdö ma laka, römöyï mï kada nima na bo Bɔkoꞌba kindawo rɔ bo di pötö ndɔbɔ pili abo ga ame bo koꞌdɔ ꞌba toꞌba wa pili ne. ");
INSERT INTO bex_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tisaki ame ꞌdɔ kiꞌdi mïtɔrɔ ni ti dɔliŋɔ koꞌba rönï ne na kɔzɔ wa nima tara. Mï kada ma ŋere Bɔkoꞌba koꞌba mïtɔrɔ ni ti dɔliŋɔ, ");
INSERT INTO bex_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","a mɔtɔ rɔ ŋgërï ni inza kina kupö ötu dë gbï römöyï bo iꞌdi tɔrɔ dë gba kaꞌdi, kina bɔtɔ mɔtɔ inza gbï ma ꞌdɔ korɔꞌdɔ yayi. ");
INSERT INTO bex_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tine mini oloma tunzuꞌdï kako di mï yayi bërï kiyaꞌji dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tine na ŋere Bɔkoꞌba kogba yayi di mï dɔyayi koꞌba rɔ bilaka, kina bo kome lili ꞌba tiꞌdi dïdï kano mo kina bilaka nima ŋgï ti dïdï yïmo. ");
INSERT INTO bex_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tine na ŋere Bɔkoꞌba kïdïyë nyaka mï Edene kapa kari yïbï. Kina bo kiꞌdi bilaka tönë bo koꞌba ne koloma yïmo yayi. ");
INSERT INTO bex_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Bo iꞌdi dɔkomali ŋgërï ma kïnë kele ame ga këdï kana döŋgërï ma kele rɔ akonyo ne kötu di mï yayi mï gɔ bi nima yayi. Mï zana nyaka nima ŋgërï ëdï yayi rɔ ŋgërï ꞌba tiꞌdi dïdï tine mɔtɔ rɔ ŋgërï ꞌba tiꞌdi ꞌdɔ tikali wa ma laka ni ti wa ma kënyë. ");
INSERT INTO bex_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yöpö oga rönï kɔlɔ kebe mï Edene kiyaꞌji mï nyaka nima. Di gönyï Edene yayi na koza dönï sowɔ. ");
INSERT INTO bex_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Yöpö ma dɔgba mo na rɔ ame kïdëkï rɔ Pisona ne, ɔlɔ ꞌbënï kebe mï dɔyayi ꞌba Awila. ");
INSERT INTO bex_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gɔ bi nima na ti yamo ma köbököbö ma laka kulöwö teyi gbï ti ama kato kele ti lele ma kïnë köbö naga. ");
INSERT INTO bex_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Yöpö ma mï rïyö mo na rɔ Giyona, ɔlɔ ꞌbënï kebe mï dɔyayi ꞌba Kusa pili. ");
INSERT INTO bex_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tine yöpö ma mï mota mo na rɔ Idekele, ɔlɔ ꞌbënï kebe kapa Asura ma kari yïbï. Yöpö ma mï sowɔ mo na rɔ Epurate. ");
INSERT INTO bex_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kina ŋere Bɔkoꞌba kiꞌdi bilaka tönë mï nyaka ꞌba Edene yayi toꞌdɔ ndɔbɔ yïmo gbï toŋgɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ŋere Bɔkoꞌba ose gɔmo zi bɔ nima, iya te, “Döŋgërï ꞌba mï nyaka nime pili onyo rɔ dɔ ŋgölö, ");
INSERT INTO bex_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","tine ŋgërï ꞌba ꞌdɔ tiꞌdi tikali wa ma laka ni ti wa ma kënyë nima kinza konyo dë, ɔdɔ konyo mï kada mo tɔ nima yɔ na këddï kölë ŋgï yaga.” ");
INSERT INTO bex_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tine ŋere Bɔkoꞌba iya te, “Ele dë ꞌdɔ bɔ nime koloma ŋge kutu nï te, mëdï moꞌdɔ lëpï bo ma koriya ti bo ꞌdɔ koꞌdɔ ndɔbɔ ti bo.” ");
INSERT INTO bex_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kina Bɔkoꞌba kogba yayi di mï dɔyayi koꞌba dɔkomali yërï pili rɔ gɔmo ti yali pili koꞌde kako zi bilaka tönë ꞌdɔ koŋgɔ ɔdɔ bo ti kïdëkï möyï mo ga rɔ waꞌdi. Gɔ köꞌdu mo na möyï ame ga pili bo kïdëkï wa naga nima timo ne na kɔrɔ ŋgï rɔ möyï mo ga. ");
INSERT INTO bex_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kina bɔ nima koyi möyï ŋgï dɔ yali pili kpaki ti yërï pili. Tine ma kɔtɔ mɔtɔ mo te inza du rɔ lëpï ma laka ame ŋgï ꞌdɔ koꞌdɔ ndɔbɔ ti bo. ");
INSERT INTO bex_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tine na ŋere Bɔkoꞌba kiꞌdi töꞌdö ma kinza kiya kindaꞌba bɔ tönë ŋgï. Kina ɔdɔ bɔ nima köꞌdö ꞌdeni tara tine na bo kogba kɔmɔ liye mo ma kɔtɔ di kpa yɔki mo kololi pötö mo teyi. ");
INSERT INTO bex_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kina bo koꞌba liye tönë bo kogba ne rɔ ꞌja koꞌde kako zi bɔ nima. ");
INSERT INTO bex_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Bɔ tönë iya te, “Ee, ame na ꞌdeni rɔ kiliŋba di mï kiliŋba ma, yida di mï yida rɔma, ti kïdëkï möyï nï rɔ ꞌja, römöyï ogba lɔko di rɔ bɔtɔni.” ");
INSERT INTO bex_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Gɔ köꞌdu mo na me ꞌdɔ köꞌbö ꞌdeni zi bɔtɔni këdï kënyï di yɔki ꞌbu nï ni ti mönï, kari kodɔꞌbɔ rönï ti ꞌja ꞌbënï kina lïjë kpaki rïyö ꞌdeni rɔ a kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mï kada nima bɔ nima lïjë ti ꞌja mo nima kpaki rɔ gɔ ŋbululu, tine rönnï aya dë. ");
INSERT INTO bex_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Murë na rɔ yërï ma kënyë kandi kebe yërï ma laki mɔtɔ ga ame pili ŋere Bɔkoꞌba koꞌba ne. Bo ititi ꞌja nima, iya te, “Bɔkoꞌba iya ŋgï ziye rɔ ma laka tëgë kinza konyoke döŋgërï ꞌba mï nyaka nime dë?” ");
INSERT INTO bex_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ꞌJa nima iya te, “Döŋgërï ꞌba mï nyaka nime pili dëdï donyo, ");
INSERT INTO bex_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tine ŋgërï ma mï zana nyaka nime ꞌdë Bɔkoꞌba iya te kinza donyo dë, kina kinza dosa rɔmo dë gbï. Ɔdɔ donyo dëdï dölë.” ");
INSERT INTO bex_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Murë iya zi ꞌja nima, iya te, “Bëtï na, ölëke dë. ");
INSERT INTO bex_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bɔkoꞌba iya tara römöyï bo ikali ɔdɔ konyoke kɔmɔye ëdï kɔpɔ këddïke gbï kɔzɔ bo Bɔkoꞌba tara tikali wa ma laka ni ti wa ma kënyë.” ");
INSERT INTO bex_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kina ɔdɔ ꞌja nima koŋgɔ ŋgërï tönë ŋgï rɔ akonyo ma laka, kïnë mo gbï rɔ ma kele, kina gbï rɔ ŋgërï ame këdï kiꞌdi wa tikali lende tine, lɔko iteꞌde ma kana mo ŋgï konyo, kina lɔko kiꞌdi mɔtɔ gbï zi mëꞌdë nï konyo. ");
INSERT INTO bex_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kina ɔdɔ lïjë konyo ꞌdeni tine kömönnï ɔpɔ ŋgï lïjë kikali ma lïjë këdï rɔ gɔ ŋbululu. Kina lïjë kuru mbili këlu ŋgï kutuꞌbö gönnï. ");
INSERT INTO bex_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mï dɔkɔpiyari ꞌdeni tine na lïjë kuwö birɔ ŋere Bɔkoꞌba këdï kiliŋgere kebe mï nyaka yayi. Kina lïjë kusu dönnï ŋgï yaga di zi bo mï löŋgö ŋgërï. ");
INSERT INTO bex_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tine ŋere Bɔkoꞌba ïdëkï bɔ nima, iya te, “Ëddï yala?” ");
INSERT INTO bex_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Bo iya te, “Muwö birɔ yï di mï nyaka bine na ma rɔ tikere römöyï mëdï rɔ gɔ ŋbululu kina me musu dɔma yaga di zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Bɔkoꞌba iya te, “Yë na kiya zïyï kiya te ëddï rɔ gɔ ŋbululu? Döŋgërï tönë mose gɔmo zïyï miya te kinza konyo dë ne na konyo ꞌdeni?” ");
INSERT INTO bex_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Bɔ nima iya te, “ꞌJa nime kiꞌdi lɔko tö bine ne lɔko iꞌdi döŋgërï nima ꞌdeni zö monyo.” ");
INSERT INTO bex_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kina ŋere Bɔkoꞌba kititi ꞌja nima, iya te, “Waꞌdi na me koꞌdɔ te ne?” ꞌJa nima iya te, “Murë na kuꞌbölu ma kiꞌdi monyo.” ");
INSERT INTO bex_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ŋere Bɔkoꞌba ilende zi murë, iya te, “Gɔ köꞌdu nime koꞌdɔ ne nï ꞌdeni ti sönö di mï löŋgö yërï ma laki naga nime pili. Ti kele ꞌbëyï ti dɔ mïyï. Ti konyo ꞌbëyï rɔ lupu mï kada ꞌba loma ꞌbï pili. ");
INSERT INTO bex_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mëdï miꞌdi ye koꞌjike rɔye ti ꞌja nime. Mï löŋgö kupö yï ti köꞌbö rɔ ya ti ꞌbënï. Lïjë ti kututu döyï kina ti kuyï kpëyï koga burutu lïjë.” ");
INSERT INTO bex_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tine Bɔkoꞌba iya zi ꞌja nima, iya te, “Mëdï miꞌdi gomɔ ma löbu këdï zïyï mï löyö, kina ti köyö kole ŋgï rɔ ma kɔꞌɔ ti gomɔ. Tine pele tara nï gba ꞌbiri toꞌdɔkɔ mëꞌdë yï. Kina bo ti këdï rɔ bɔ döyï.” ");
INSERT INTO bex_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tine zi bɔtɔni mo bo iya te, “Ebe kuwö dɔ ꞌja ꞌbï kiꞌdi konyo döŋgërï nime mose gɔmo zïyï, miya te, kinza konyo dë ne. Gɔ köꞌdu mo sönö ëdï ꞌdeni mï yayi. Ti koꞌdɔ ndɔbɔ ti gomɔ tiꞌdi yayi koja akonyo zïyï mï kada ꞌba loma ꞌbï pili. ");
INSERT INTO bex_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Yayi ti koja kono ti wuru kina ti konyo dɔyilo ꞌba yï mökö. ");
INSERT INTO bex_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ti koꞌdɔ ndɔbɔ ti tende ꞌba röyï tiꞌdi yayi koja akonyo zïyï ŋbö kömö mï kada ꞌbï kileki mï yayi nime kogba yi di yïmo ne. Nï yayi na kina ti kileki gbï mï yayi.” ");
INSERT INTO bex_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Bilaka nima rɔ Adama ne ïdëkï möyï ꞌja abo nima rɔ Awa, ꞌjɔ ꞌba lende mo tëgë “Ma dïdï,” römöyï lɔko na rɔ ma ꞌba bilaka lesi pili. ");
INSERT INTO bex_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kina ŋere Bɔkoꞌba koꞌdɔ kilaka rɔ bɔŋgɔ zi Adama ni ti ꞌja abo kusu gönnï. ");
INSERT INTO bex_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tine ŋere Bɔkoꞌba omeri iya te, “Bilaka nime ꞌdeni kɔzɔ ze tikali wa ma laka ni ti ma kënyë. Ola bo dë kpe bine kinza bo kari koja közï bo kiteꞌde döŋgërï ma ꞌba tiꞌdi dïdï nima ra gbï konyo kinza kiꞌdi bo koloma köꞌbö rɔ ŋburuŋburu.” ");
INSERT INTO bex_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kina bo koga Adama ni ŋgï yaga di mï nyaka ꞌba Edene kari torɔꞌdɔ yayi ma tönë kogba bo di yïmo ne. ");
INSERT INTO bex_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Bo oga bilaka nima yaga di mï nyaka nima yayi kina bo kiꞌdi malayika ꞌba toda bi kapa ma kari yïbï gbï ti mbele ma köbö rɔ paꞌdo köꞌbö tuyï kpënï kuŋguŋgu dɔ bi toko toda bi di rɔ ŋgërï ꞌba tiꞌdi dïdï nima. ");
INSERT INTO bex_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adama ni indaꞌba dönnï ti ꞌja abo Awa kina lɔko kɔmɔ köyö kole bɔtɔni. Lɔko iya te, “Moꞌja kole ꞌdeni ti kɔnyi ꞌba Bɔkoꞌba.” Kina lɔko kïdëkï möyï mo ŋgï rɔ Kayina, ame kiya te “Moꞌja ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Di pötö mo ꞌböwu na lɔko köyö löndö mo Abele. Tine Abele rɔ bɔ koda kamölö, Kayina ꞌba bo rɔ bɔ korɔꞌdɔ nyaka. ");
INSERT INTO bex_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mï kada mɔtɔ tine na Kayina koꞌde wa ꞌba mï nyaka abo rɔ kpa közï zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abele oꞌde ꞌba bo rɔ kole kamölö abo ame ga rɔ dɔ tapi ne, kumu koꞌde bi ma lakalaka mo ga rɔ kpa közï zi Bɔkoꞌba. Kina Bɔkoꞌba ti mï këyï rɔ Abele kutï gɔ kpa közï kiꞌdi mo, ");
INSERT INTO bex_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","tine ilagi yaga di rɔ Kayina ti kpa közï kiꞌdi ma ꞌba bo. Gɔ köꞌdu mo na Kayina kënyï ŋgï rɔ ꞌdïrï koworo rönï. ");
INSERT INTO bex_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Bɔkoꞌba iya te zi Kayina, “Waꞌdi na nï rɔ ꞌdïrï tara gɔmo? Waꞌdi na koworo röyï kulöwö tara gɔmo? ");
INSERT INTO bex_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ma këdï koꞌdɔ ra laka dëne inza kutï göyï? Kina me ɔdɔ koꞌdɔ dë laka lende kënyë orɔ dönï ꞌdeni ŋɔli kpadörï ꞌbï, oꞌdɔkɔ ꞌdɔ kaꞌda yi ne tine ti kaꞌda bo ŋgï.” ");
INSERT INTO bex_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayina iya te zi bɔ löndö bo Abele, “Ako dari mï nyaka.” Di mï nyaka yayi na Kayina kuyï kpënï ŋgï dɔ löndö bo Abele kupö yaga. ");
INSERT INTO bex_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Bɔkoꞌba ititi bo, iya te, “Löndö yï Abele ëdï yala?” Bo iya te, “Mikali dë. Ma na rɔ mambïlëŋï ꞌba löndö ma mo?” ");
INSERT INTO bex_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Bɔkoꞌba iya te, “Gɔ waꞌdi na koꞌdɔ wa nime te? Birɔ ꞌba roma löndö yï udu ꞌdeni di mï yayi ŋbö kömö mbili ma kɔzɔ birɔ ame këdï kudu ꞌdɔ kopi dɔkolo mo ne. ");
INSERT INTO bex_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Usönö yi ꞌdeni di mï yayi nime kobe kpënï ꞌdeni tuwë roma löndö yï di közïyï ne. ");
INSERT INTO bex_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ɔdɔ korɔꞌdɔ pele inza koja wa kpe zïyï. Ti koloma rɔ bɔ kinza liŋɔ tulë kebe mï dɔyayi.” ");
INSERT INTO bex_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayina iya zi Bɔkoꞌba, iya te, “Karama nime kodɔ dɔma ne ꞌdeni ŋgï rɔ dɔ kiteli mɔꞌbɔ dë ꞌdɔ tombi mo. ");
INSERT INTO bex_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Oga ma ꞌdeni tɔne yaga di rɔ torɔꞌdɔ yayi, kina gbï ꞌdeni yaga di kömöyï. Ma ꞌdeni rɔ bɔ kinza liŋɔ tulë kebe mï dɔyayi, bɔtɔ mɔtɔ ame kondɔsɔ tö ne ti kupö ma ŋgï.” ");
INSERT INTO bex_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bɔkoꞌba iya te, “Inza tara, ɔdɔ bɔtɔ mo kupö yi, mëdï modɔ karama ma dɔ kiteli dɔmo ŋbö mï modɔmorïyö kpa dɔkolo mo.” Kina Bɔkoꞌba koꞌdɔ kïnë rɔ Kayina ꞌdɔ kota gɔmo di zi bɔtɔ ame kondɔsɔ timo ne di bi tupö mo. ");
INSERT INTO bex_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kina Kayina kënyï ŋgï kari yaga di kɔmɔ Bɔkoꞌba kari koloma mï dɔyayi mɔtɔ kïdëkï rɔ “Tulë” kapa Edene ma kari yïbï. ");
INSERT INTO bex_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayina ni indaꞌba dönnï ti ꞌja abo di yayi na lɔko kɔmɔ köyö Enoka. Mï kada nima na Kayina kubö gawo koyi möyï kole abo Enoka dɔmo. ");
INSERT INTO bex_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kina Enoka köyö Irada, Irada öyö Mëkuyëlë, Mëkuyëlë öyö Mëtusëla, Mëtusëla öyö Lemeke. ");
INSERT INTO bex_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Tine Lemeke ogbe ꞌja rïyö rɔ Ada ni ti Zila. ");
INSERT INTO bex_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada öyö Yabala, bo na rɔ yï lïŋgï ꞌba ya ma kindaꞌba kabi ꞌba yërï këdï koloma mï rö kilaka naga. ");
INSERT INTO bex_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Möyï löndö bo rɔ Yubala, bo na rɔ yï lïŋgï ꞌba ya ame ga rɔ bɔ komba tɔmo gbï rɔ bɔ tome more ne. ");
INSERT INTO bex_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila öyö Tubalakayina, bo na rɔ bɔ kuku wa pili di mï ꞌbïlëŋï ni ti yamo. Lëmï bo möyï mo rɔ Nama. ");
INSERT INTO bex_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemeke oba zi ꞌja abo ga, iya te, “Ada kpe ti Zila, uwöke dɔma. Ojeke mbili ye gɔ wa ma mëdï miya. Mupö bilaka mɔtɔ ꞌdeni gɔ toꞌdɔ wëtö rɔma. Mupö yɔbi ꞌdeni römöyï bo omba ma. ");
INSERT INTO bex_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ne ɔdɔ topi dɔkolo Kayina këdï ti karama mï modɔmorïyö, dɔkolo ꞌba Lemeke ti këdï ŋgï kulöwö mï konzi.” ");
INSERT INTO bex_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Di pötö tölë ꞌba Abele nima Adama ni indaꞌba dönnï ꞌdeni ꞌböwu ti ꞌja ꞌbënï, kina lɔko köyö kole kiꞌdi möyï mo rɔ Sete, ame tëgë “Oja gɔmo,” römöyï lɔko iya te, “Bɔkoꞌba oja gɔ kole mɔtɔ ꞌdeni zö pötö Abele ame Kayina kupö ne.” ");
INSERT INTO bex_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kina Sete köyö kole kiꞌdi möyï mo rɔ Enosa. Mï kada naga nima tine na ꞌjaa bilaka kisaki tïdëkï möyï kɔtɔ laka ꞌba Bɔkoꞌba mï mötu koꞌdɔ. ");
INSERT INTO bex_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Kupö Adama ga na kɔzɔ a nime te. Mï kada ma Bɔkoꞌba koꞌba bilaka lesi, bo oꞌba lïjë kɔzɔ bo tara. ");
INSERT INTO bex_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Bo oꞌba lïjë rɔ bɔtɔni ni ma ti ꞌja. Kina bo koꞌdɔ yëyï zïnnï kïdëkï möyï dönnï rɔ bilaka lesi. ");
INSERT INTO bex_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kina ɔdɔ Adama koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku rïyö kɔdɔ dɔmo ꞌbutë mota (130) tine, bo öyö kole gbï kɔzɔ kïnë bo tara. Kina bo kiꞌdi möyï mo rɔ Sete. ");
INSERT INTO bex_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Di pötö töyö Sete nime, Adama oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku ꞌbutë döömu dɔɔkɔtɔ (800) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu dɔɔmota kɔdɔ dɔmo ꞌbutë mota (930). ");
INSERT INTO bex_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Kina ɔdɔ Sete koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku rïyö kɔdɔ dɔmo muyï (105) tine, na bo köyö Enosa. ");
INSERT INTO bex_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Di pötö töyö Enosa nime Sete oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku ꞌbutë döömu dɔɔkɔtɔ kɔdɔ dɔmo modɔmorïyö (807) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu dɔɔmota kɔdɔ dɔmo ꞌbutë dɔmorïyö (912). ");
INSERT INTO bex_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Kina ɔdɔ Enosa koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë sowɔ (90) tine, na bo köyö Kenana. ");
INSERT INTO bex_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Di pötö töyö Kenana nime Enosa oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku ꞌbutë döömu dɔɔkɔtɔ kɔdɔ dɔmo ꞌbutë döömu (815) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu dɔɔmota kɔdɔ dɔmo muyï (905). ");
INSERT INTO bex_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kina ɔdɔ Kenana koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö (70) tine, na bo köyö Makalele. ");
INSERT INTO bex_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Di pötö töyö Makalele nime Kenana oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku ꞌbutë döömu dɔɔkɔtɔ kɔdɔ dɔmo ꞌbutë sowɔ (840) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu dɔɔmota kɔdɔ dɔmo ꞌbutë (910). ");
INSERT INTO bex_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Kina ɔdɔ Makalele koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë döömu (65) tine, na bo köyö Yarada. ");
INSERT INTO bex_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Di pötö töyö Yarada nime Makalele oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku ꞌbutë döömu dɔɔkɔtɔ kɔdɔ dɔmo ꞌbutë mota (830) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu dɔmorïyö kɔdɔ dɔmo ꞌbutë sowɔ döömu (895). ");
INSERT INTO bex_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kina ɔdɔ Yarada koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku mota kɔdɔ dɔmo ꞌbutë dɔmorïyö (162) tine, na bo köyö Enoka. ");
INSERT INTO bex_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Di pötö töyö Enoka nime Yarada oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku ꞌbutë döömu dɔɔkɔtɔ (800) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu dɔmosowɔ kɔdɔ dɔmo ꞌbutë dɔmorïyö (962). ");
INSERT INTO bex_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kina ɔdɔ Enoka koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë döömu (65) tine, na bo köyö Metosela. ");
INSERT INTO bex_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Di pötö töyö Metosela nime Enoka öꞌbö nduwë mï rɔ kodɔꞌbɔ ti Bɔkoꞌba ŋbö kɔmɔ kɔɔ kuluku modɔɔkɔtɔ (300), kina bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Kada ꞌba loma ꞌba Enoka pili kɔmɔ kɔɔ kuluku modɔmorïyö kɔdɔ dɔmo ꞌbutë döömu (365). ");
INSERT INTO bex_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Bo oloma köꞌbö mï rɔ kodɔꞌbɔ ti Bɔkoꞌba, kina tine bo ari kinda dë kpe bo ölu ŋgï liwo römöyï Bɔkoꞌba ogba bo ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Kina ɔdɔ Metosela koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku mota kɔdɔ dɔmo ꞌbutë mota döömu dɔmorïyö (187) tine, na bo köyö Lemeke. ");
INSERT INTO bex_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Di pötö töyö Lemeke nime Metosela oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku ꞌbutë döömu kɔdɔ dɔmo ꞌbutë mota dɔmorïyö (782) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu dɔmosowɔ kɔdɔ dɔmo ꞌbutë döömu dɔmosowɔ (969). ");
INSERT INTO bex_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Kina ɔdɔ Lemeke koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku mota kɔdɔ dɔmo ꞌbutë mota dɔmorïyö (182) tine, na bo köyö kole. ");
INSERT INTO bex_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kina bo kiꞌdi möyï mo rɔ Nowa, ame kiya te “Kɔnyi,” römöyï bo iya te, “Kole nime ti koꞌde kɔnyi zize di mï gomɔ ꞌba ndɔbɔ ze ga ame dëdï doꞌdɔ mï yayi nime Bɔkoꞌba kusönö ꞌdeni ne.” ");
INSERT INTO bex_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Di pötö töyö Nowa nime Lemeke oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku ꞌbutë dɔɔkɔtɔ kɔdɔ dɔmo ꞌbutë sowɔ döömu (595) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ ꞌba loma abo ꞌdeni pili kuluku ꞌbutë döömu kɔdɔ dɔmo ꞌbutë rïyö döömu dɔmorïyö (777). ");
INSERT INTO bex_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kina ɔdɔ Nowa koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku ꞌbutë (500) tine, na bo köyö kole mota rɔ Seme ni ti Ama ti Yepete. ");
INSERT INTO bex_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kina ɔdɔ bilaka lesi kara ꞌdeni mï dɔyayi köyö yïtötï tine, ");
INSERT INTO bex_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","kole ame ga rɔ ꞌba Bɔkoꞌba ne oŋgɔ yïtötï ꞌba bilaka lesi ele ŋgï rɔ mbëmbë, kina lïjë kako kigeli ma kele mo ga rɔ ꞌja zïnnï. ");
INSERT INTO bex_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Gɔ köꞌdu mo na Bɔkoꞌba kiya te, “Minza mola dïdï ma kpe koloma rɔ ŋburuŋburu mï bilaka, lïjë yida rɔ ꞌba dɔyayi na. Kada ꞌba loma ꞌbënnï ti kɔrɔ ŋge kuluku rïyö kɔdɔ dɔmo ꞌbutë rïyö (120).” ");
INSERT INTO bex_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mï kada naga nima kina gbï di pötö mo kolowani ꞌba bilaka mɔtɔ ga oloma mï dɔyayi, lïjë na rɔ kupö köyö ꞌba kole ꞌba Bɔkoꞌba ga ma ti yïtötï ꞌba bilaka lesi. Lïjë na koloma rɔ goŋga ma dɔ kïlëbï mï kada ma mɔlo tönë ga. ");
INSERT INTO bex_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kina ɔdɔ Bɔkoꞌba koŋgɔ lende kënyë kirasi ꞌba bilaka ꞌdeni ŋgï rɔ mbëmbë mï dɔyayi tine, meri ꞌba mï bilaka köꞌbö ŋgï rɔ ma kölu kote kada pili, ");
INSERT INTO bex_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","bo ti meri gɔ ame bo koꞌba bilaka ka le ndeŋi kiꞌdi mï dɔyayi ne. Köꞌdu mo ɔꞌɔ ŋbö kɔdɔ dökïꞌdï bo ");
INSERT INTO bex_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","kina bo kiya te, “Mëdï mote dɔ bilaka naga nime moꞌba ne yaga di mï dɔyayi nime, kpaki ti dɔkomali yërï ti wa ma titi ti ma këdï kele kebe mï dɔyayi bërï naga ti yali pili. Ma ti meri gɔ ame moꞌba lïjë ka le ndeŋi.” ");
INSERT INTO bex_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tine Bɔkoꞌba ti mï këyï rɔ Nowa. ");
INSERT INTO bex_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Ame na rɔ lende ꞌba Nowa. Kole abo ga mota rɔ Seme ni ti Ama ti Yepete. Nowa na rɔ bɔ lende laka ame ŋge kɔtɔ kpökï di mï löŋgö bilaka ꞌba mï kada naga nima kinza lende kirasi mɔtɔ. Bo öꞌbö nduwë mï rɔ kodɔꞌbɔ ti Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tine ya ma laki pili lende kënyë mo ga idari ꞌdeni kɔmɔ Bɔkoꞌba, közï kasi koꞌdɔ ꞌbënnï ogba mï dɔyayi ꞌdeni ŋgï kpaki ti rönï. ");
INSERT INTO bex_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Bɔkoꞌba oŋgɔ dɔyayi irasi rönï ꞌdeni ti lende kënyë, römöyï loma ꞌba bilaka ꞌba dɔyayi pili ꞌdeni ŋgï rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kina Bɔkoꞌba kilende zi Nowa, iya te, “Moꞌdɔkɔ ꞌdeni tote dɔ kupö bilaka lesi pili yaga, römöyï közï kasi koꞌdɔ ꞌbënnï ogba mï dɔyayi ꞌdeni. Gɔ köꞌdu mo mëdï mote dönnï kpaki yaga ti dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Oꞌdɔ sorope ma löbu zïyï di mï ŋgërï ma kandi. Oke mï rö mo ga kolo yïmo ti zïbïtï gbï kebe gɔmo yaga. ");
INSERT INTO bex_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Sorope mo nima oꞌdɔ kɔzɔ a nime te. Gɔ ma kakpa mo iꞌdi këdï dɔkɔmɔ kumögu kuluku rïyö kɔdɔ dɔmo ꞌbutë mota dɔɔmota (133). Gɔmo ma köꞌbö mo iꞌdi këdï dɔkɔmɔ kumögu ꞌbutë rïyö dɔmorïyö. Tïyöbu ma kari tɔrɔ mo iꞌdi këdï dɔkɔmɔ kumögu ꞌbutë dɔɔmota. ");
INSERT INTO bex_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ubö dɔmo kola bi gböŋö mbowa mï löŋgö dɔ ma tɔrɔ mo. Oꞌdɔ kpadörï mo kebe yɔki mo. Oke mï rö ma kalo mo bi mota rɔ dɔ kudöꞌdu. ");
INSERT INTO bex_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mëdï miꞌdi mini koso dɔyayi kote dɔ wa ma ti dïdï yïmo naga nime dɔyayi bërï bine ne pili yaga. Wa ꞌba mï dɔyayi nime pili ëdï kölë yaga. ");
INSERT INTO bex_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tine mëdï moꞌdɔ pɔri löŋgö ze tïyï. Nï ꞌdɔ këkï mï sorope ti ꞌja ꞌbï ti kole ꞌbï ga ti ꞌja ꞌba kole ꞌbï ga. ");
INSERT INTO bex_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ogba dɔkomali wa ma ti dïdï yïmo naga nime me rɔ rïyörïyö tïyï mï sorope gɔ lïjë kɔmɔ. Ogba dɔkomali yali pili ti yërï mo ga ti wa ma titi ti ma këdï kele kebe bërï mï dɔyayi naga. Ogba bɔtɔni mo kɔtɔ ti ꞌja mo teyi. Dɔkomali wa naga nime pili rɔ rïyörïyö iꞌdi këkï kɔtɔ tïyï mï sorope gɔ lïjë kɔmɔ. ");
INSERT INTO bex_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ogba dɔkomali akonyo pili kikeki mï sorope zïyï gbï zïnnï.” ");
INSERT INTO bex_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kina Nowa koꞌdɔ ŋgï pili kɔzɔ wa ma Bɔkoꞌba kose gɔmo zi bo. ");
INSERT INTO bex_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kina Bɔkoꞌba kilende zi Nowa, iya te, “Ëkï mï sorope ti bilaka ꞌbï ga pili, römöyï moŋgɔ ꞌdeni nï na ŋge kɔtɔ kpökï rɔ ma laka di mï löŋgö bilaka pili ꞌba dɔyayi nime. ");
INSERT INTO bex_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ogba di mï dɔkomali yërï ma kɔpɔ rɔ akumu naga nime modɔmorïyö pili rɔ rïyörïyö, bɔtɔni mo kɔtɔ ti ꞌja mo teyi. Tine ma kinza rɔ ma kɔpɔ rɔ akumu naga ogba bɔtɔni mo kɔtɔ ti ꞌja mo teyi pili di mï dɔkomali lïjë nima rɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kina ogba di mï dɔkomali yali pili gbï modɔmorïyö rɔ rïyörïyö ꞌdɔ lïjë nima pili kɔmɔ rɔ dɔ kupö mï dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Di pötö töꞌdö dɔ modɔmorïyö kisaki di mï kada nime tɔne mëdï miꞌdi tɔrɔ kaꞌdi mï dɔyayi kote kada kote korɔndɔ ŋbö töꞌdö mo dɔ ꞌbutë sowɔ. Wa ma ti dïdï yïmo naga nime pili moꞌba mï dɔyayi nime bine ne mëdï mote dɔmo yaga di mï dɔyayi.” ");
INSERT INTO bex_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kina Nowa koꞌdɔ ŋgï pili kɔzɔ wa ma Bɔkoꞌba kose gɔmo zi bo. ");
INSERT INTO bex_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mï kada nima mini koso kako dɔyayi ne, kɔmɔ kɔɔ ꞌba loma ꞌba Nowa ꞌdeni kuluku ꞌbutë dɔmorïyö (600). ");
INSERT INTO bex_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Kina Nowa ni ti ꞌja abo ti kole abo ga kpaki ti ꞌja ꞌba kole abo ga këkï ŋgï mï sorope tɔmɔ di zi mini koso nima. ");
INSERT INTO bex_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tine dɔkomali yërï ma kɔpɔ rɔ akumu naga kpaki ti ma kinza rɔ ma kɔpɔ naga ti yali ni pili, dɔkomali wa naga nime ëkï pili mï sorope rɔ rïyörïyö, bɔtɔni mo kɔtɔ ti ꞌja mo teyi kɔzɔ wa ma Bɔkoꞌba kose gɔmo zi Nowa. ");
INSERT INTO bex_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Di pötö töꞌdö dɔ modɔmorïyö tine na mini koso kako ŋgï dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mï kɔmɔ kɔɔ kuluku ꞌbutë dɔmorïyö (600) ꞌba loma ꞌba Nowa mï töꞌdö dɔ ꞌbutë döömu dɔmorïyö ꞌba nyepe ma mï rïyö tine na kɔmɔ mini löbu ame ga pili bïcï yayi bërï ne kulömö ŋgï yaga, bi gböŋö ꞌba mïtɔrɔ pili urögö rönnï ŋgï yaga, ");
INSERT INTO bex_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","tɔrɔ kindaꞌba taꞌdi mï dɔyayi kote kada kote korɔndɔ ŋbö töꞌdö mo dɔ ꞌbutë sowɔ. ");
INSERT INTO bex_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mï kada kɔtɔ mo nima na Nowa ni këkï ŋgï mï sorope ti ꞌja abo ti kole mota abo ga, Seme ni ti Ama ti Yepete ti ꞌja ꞌbënnï ga kpaki mota. ");
INSERT INTO bex_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Dɔkomali yërï ꞌba liŋɔ pili ti ꞌba mökö ti wa ma titi ti ma këdï kele kebe mï dɔyayi bërï naga kpaki ti yali mo ga ëkï kɔtɔ tïnnï mï sorope. ");
INSERT INTO bex_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Wa ame ga pili ti dïdï yïmo ne me rɔ rïyörïyö, bɔtɔni mo kɔtɔ ti ꞌja mo teyi di mï dɔkomali mo ga pili rɔ gɔmo ako zi Nowa këkï kɔtɔ mï sorope ti bo kɔzɔ wa ma Bɔkoꞌba kose gɔmo zi bo. Kina Bɔkoꞌba kurögö kpadörï ꞌba sorope ŋgï teyi. ");
INSERT INTO bex_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mini nima oso ŋbö töꞌdö mo dɔ ꞌbutë sowɔ mï dɔyayi, kina koso ŋgï kombi sorope kïyökö tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mini ozoli rönï ŋgï kalo rɔ ma kënyë kina sorope kïyökö ŋgï koloma tiliŋgere kebe dɔ mini. ");
INSERT INTO bex_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tine na kozoli rönï ŋgï rɔ mbëmbë dɔ dɔyayi kalo kindiyɔ dɔ döku ma löbu ꞌba dɔliŋɔ naga nime pili. ");
INSERT INTO bex_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Kina koto ŋgï nduwë tozoli rönï ŋbö kalo kindiyɔ dɔ döku ma löbu naga dɔkɔmɔ kumögu modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Tine dɔkomali wa ame ga pili mï dɔyayi ti dïdï yïmo ne ölë ꞌdeni kote, dɔkomali yali pili ti yërï mo ga kpaki ti bilaka lesi. Wa ame ga pili mï dɔyayi ti tawo yïmo ne ölë kote dönnï me yaga. ");
INSERT INTO bex_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ŋere Bɔkoꞌba ote dɔ wa ꞌba mï dɔyayi nime ame ga pili ti dïdï yïmo ne me yaga, bilaka lesi kpaki ti dɔkomali yërï pili ti wa ma titi ma këdï kele kebe mï dɔyayi bërï naga ti yali mo ga, bo ote dɔmo pili yaga di mï dɔyayi. Nowa na ŋge kɔmɔ ti ya ame ga ti bo mï sorope yayi ne. ");
INSERT INTO bex_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mini nima öꞌbö rɔ ma koso dɔ dɔyayi ŋbö töꞌdö mo dɔ kuluku mota (150). ");
INSERT INTO bex_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tine Bɔkoꞌba ëdï nduwë komeri Nowa ni ti dɔkomali yërï ꞌba mökö kpaki ti ꞌba liŋɔ ame ga ti bo mï sorope yayi ne. Kina Bɔkoꞌba kiꞌdi lili ma kembe koloma tome mï dɔyayi, na mini kiꞌdi ŋgï tulöku. ");
INSERT INTO bex_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kɔmɔ mini löbu ame ga bïcï yayi kpaki ti bi gböŋö ꞌba mïtɔrɔ urögö rönnï ŋgï teyi, kina tɔrɔ ma këdï kaꞌdi koya ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kina mini koloma ŋgï nduwë totɔ kari bërï di mï dɔyayi. Di pötö töꞌdö dɔ kuluku mota (150) tine mini otɔ ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Mï töꞌdö dɔ ꞌbutë döömu dɔmorïyö ꞌba nyepe ma modɔmorïyö na sorope kari kïkëtï rönï dɔ döku löbu ꞌba Ararata. ");
INSERT INTO bex_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kina mini koloma ŋgï nduwë rɔ totɔ ŋbö kömö mï nyepe ma ꞌbutë. Mï töꞌdö ma dɔndende ꞌba nyepe ꞌbutë tine na dɔ döku ma löbu naga kinda yaga. ");
INSERT INTO bex_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Di pötö töꞌdö dɔ ꞌbutë sowɔ na Nowa kurögö bi gböŋö ꞌba sorope ma tönë bo koꞌdɔ ne ");
INSERT INTO bex_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kina bo koja gora kari yaga. Tine gora ari köꞌbö ëꞌbënï ŋgï nduwë töpu kebe bi tɔ tɔne ga yayi ŋbö mini kulöku kote di dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kina Nowa koja matukpuru ꞌböwu kari toŋgɔ mo ɔdɔ mini otɔ ꞌdeni kote di dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tine matukpuru ari koꞌja bi mɔtɔ dë ame gɔ kiꞌdi ndïnï teyi. Kina matukpuru kileki ŋgï kari zi bo mï sorope römöyï mini ëdï gba mï dɔyayi pili. Nowa oja közï bo gɔ matukpuru kotɔ kileki mï sorope gönï yayi. ");
INSERT INTO bex_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Bo oloma koꞌdɔ töꞌdö ꞌböwu dɔ modɔmorïyö na bo kileki koja matukpuru ꞌböwu kari yaga. ");
INSERT INTO bex_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mï dɔkɔpiyari ꞌdeni tine na matukpuru kuyï dönï kileki kako zi bo mï sorope yayi ti mbili ꞌjöwu ma kunzï kpënï. Gɔ köꞌdu mo na Nowa kikali ŋgï mini ulöku ꞌdeni kote di dɔ dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Bo oloma koꞌdɔ töꞌdö ꞌböwu dɔ modɔmorïyö na bo koja matukpuru ꞌböwu kari yaga. Ama tine matukpuru uyï dönï dë kpe kileki kako zi bo mï sorope. ");
INSERT INTO bex_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Mï kɔmɔ kɔɔ kuluku ꞌbutë dɔmorïyö kɔdɔ dɔmo kɔtɔ (601) ꞌba loma ꞌba Nowa, mï töꞌdö ma dɔndende ꞌba nyepe ma dɔgba tine mini ulöku ꞌdeni yaga di dɔ dɔyayi. Kina Nowa kunyë dɔ sorope koŋgɔ bi kari yaga tine, bo oꞌja dɔyayi këlë ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mï töꞌdö dɔ ꞌbutë rïyö döömu dɔmorïyö ꞌba nyepe ma mï rïyö tine, dɔyayi ëlë ꞌdeni kututu yaga. ");
INSERT INTO bex_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kina Bɔkoꞌba kilende zi Nowa, iya te, ");
INSERT INTO bex_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ɔdɔ yaga di mï sorope ti ꞌja ꞌbï ti kole ꞌbï ga ti ꞌja ꞌba kole ꞌbï ga. ");
INSERT INTO bex_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Oja dɔkomali yali naga nima ti yërï mo ga pili ti wa ma titi ti ma këdï kele kebe mï dɔyayi bërï naga nima tïyï mï sorope yayi ne kɔdɔ yaga ꞌdɔ lïjë kari kara konzi kogba mï dɔyayi.” ");
INSERT INTO bex_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kina Nowa kɔdɔ yaga di mï sorope ti ꞌja abo ti kole abo ga ti ꞌja ꞌba kole abo ga. ");
INSERT INTO bex_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Dɔkomali wa ame ga këdï kiliŋgere kebe mï dɔyayi ne, yërï pili rɔ gɔmo kpaki ti wa ma titi ti ma këdï kele kebe mï dɔyayi bërï naga ti yali pili ɔlɔ pili yaga di mï sorope gɔ kïnë mo ga ma gege. ");
INSERT INTO bex_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kina Nowa koꞌba bi ꞌba akumu zi Bɔkoꞌba na bo kogba rɔ kɔtɔkɔtɔ di mï dɔkomali yërï ma kɔpɔ rɔ akumu naga nima gbï ti yali mo ga koŋma rɔ akumu zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kina ɔdɔ Bɔkoꞌba kumë tato kele mo ꞌdeni tine, bo iya ti mï bo, kiya te, “A mɔtɔ minza musönö yayi kpe gɔ lende koꞌdɔ ꞌba bilaka, römöyï meri ꞌba mï bilaka lesi rɔ ꞌba köꞌdu kënyë kisaki mɔlo rɔ dɔ kole titi. A mɔtɔ minza mote dɔ wa pili ꞌba dɔyayi kpe kɔzɔ ame moꞌdɔ gïrï nime ne. ");
INSERT INTO bex_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Dɔyayi ti koloma nduwë köꞌbö ti kada ꞌba tïdïyë wa gbï ti kada ꞌba tumu mo, kada ꞌba bi këyï gbï ti bi kututu, yëꞌbu gbï ti lɔwa kina kada gbï ti korɔndɔ.” ");
INSERT INTO bex_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kina Bɔkoꞌba koꞌdɔ yëyï zi Nowa ni ti kole abo ga, iya te, “Arake konzi kogba mï dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dɔkomali yërï ꞌba mï dɔyayi pili ti yali mo ga kpaki ti wa ma titi ti ma këdï kele kebe mï dɔyayi bërï naga ti kenze ꞌba mï mini ti köꞌbö rɔ ma kere ye. Miꞌdi lïjë pili ꞌdeni kɔmɔ közïye. ");
INSERT INTO bex_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Miꞌdi lïjë ꞌdeni kpaki ti mbili wa ma kunzï naga nime ziye rɔ akonyo tonyo mo. ");
INSERT INTO bex_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Wa ma ŋge ꞌdɔ konyoke dë na rɔ yida ame gba ti roma mo rɔmo ne. Mota gɔmo römöyï dïdï ëdï mï roma. ");
INSERT INTO bex_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ɔdɔ bilaka mo koja dïdï ꞌba lëpï nï, mëdï modɔ karama mo dɔ bɔ mo. Kuruku ame ga pili koja dïdï ꞌba bilaka mëdï modɔ karama mo dɔmo rɔ tölë. ");
INSERT INTO bex_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Bɔtɔ ame kupö bilaka lesi lëpï nï, ti bilaka mɔtɔ kupö bo gbï tara. Ma Bɔkoꞌba moꞌba bilaka ꞌdeni gɔ kïnë ma ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kina arake ti konzi kogba mï dɔyayi nime pili.” ");
INSERT INTO bex_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bɔkoꞌba ilende gbï zi Nowa ni ti kole abo ga, iya te, ");
INSERT INTO bex_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Mëdï ꞌdeni moꞌdɔ lömu ma mï löŋgö ze tiye kpaki ti kupö ye ga ma di pötö ye, ");
INSERT INTO bex_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kina gbï ti dɔkomali wa ma ti dïdï yïmo, dɔkomali yali pili ti yërï mo ga ꞌba liŋɔ ti ꞌba mökö pili rɔ gönnï, dɔkomali wa konzi naga nime kɔdɔ yaga di mï sorope kɔtɔ tïyï ne. ");
INSERT INTO bex_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Moꞌdɔ lömu ꞌdeni mï löŋgö ze tiye a mɔtɔ minza mote dɔ wa ma ti dïdï yïmo naga nime kpe ti mini koso. A mɔtɔ rɔ mini koso inza kako kpe kote dɔ dɔyayi yaga. ");
INSERT INTO bex_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mëdï miꞌdi akileme ꞌba lömu ma ŋburuŋburu mo nime moꞌdɔ mï löŋgö ze tiye kpaki ti dɔkomali wa ma ti dïdï yïmo naga nime nduwë kala gɔ kupö ma di yïꞌböwu naga, ");
INSERT INTO bex_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ti muruwö kanya ma azumulï mïtɔrɔ rɔ kïnë ꞌba pɔri ma, ma ti dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ɔdɔ kiya te miꞌdi pɔli kutuꞌbö dɔ dɔyayi na kanya nime kileme rönï ꞌdeni yïmo, ");
INSERT INTO bex_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mëdï momeri lömu ma nime moꞌdɔ ꞌdeni tiye kpaki ti dɔkomali wa ma ti dïdï yïmo naga nime ne ŋgï. Kina a mɔtɔ rɔ mini koso inza kpe kako kote dɔ wa ma ti dïdï yïmo naga nime yaga. ");
INSERT INTO bex_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ɔdɔ azumulï ma kɔdɔ ꞌdeni kileme rönï mï pɔli mëdï momeri lömu ma ŋburuŋburu ma nime moꞌdɔ ꞌdeni mï löŋgö ze ma ti dɔkomali wa ma ti dïdï yïmo naga nime mï dɔyayi pili ne ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ame na rɔ kïnë lömu ma moꞌdɔ ꞌdeni mï löŋgö ze ma ti dɔkomali wa ma ti dïdï yïmo pili.” ");
INSERT INTO bex_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Kole ꞌba Nowa ame ga kɔdɔ ti bo yaga di mï sorope na rɔ Seme ni ti Ama ti Yepete. Kole ꞌba Ama na rɔ Kanana. ");
INSERT INTO bex_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Kole mota ꞌba Nowa naga nime lïjë na rɔ yï lïŋgï ꞌba bilaka ꞌba dɔyayi nime pili. ");
INSERT INTO bex_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa rɔ bɔ korɔꞌdɔ nyaka, kina bo kïdïyë mɔwɔ këdï koꞌdɔ rɔ layi naga. ");
INSERT INTO bex_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mï kada mɔtɔ na bo kuwë layi mo ŋgï kupö bo köꞌdö rɔ gɔ ŋbululu mï rö kilaka abo. ");
INSERT INTO bex_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ama ꞌbu ꞌba Kanana ako koꞌja ꞌbu nï rɔ gɔ ŋbululu, kina bo kari kïyöyö gɔmo zi löndö bo ma rïyö naga nima. ");
INSERT INTO bex_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kina Seme ni ti Yepete kogba bɔŋgɔ ŋgï kuruwö dɔpora lïjë kari ti gönnï kutuꞌbö dɔ sari ꞌba rɔ ꞌbu nnï, ti kömönnï rɔ ma kuyï mökö kinza lïjë koꞌja ra. ");
INSERT INTO bex_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kina ɔdɔ Nowa kindiŋi ꞌdeni di pötö layi abo kikali wa ma kole abo ma titi koꞌdɔ zi bo tine, ");
INSERT INTO bex_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","bo iya te, “Sönö këdï dɔ Kanana. Bo ti köꞌbö rɔ atɔli zi löndö bo ga.” ");
INSERT INTO bex_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Bo ileki gbï kiya te, “Akïlëlu këdï zi Bɔkoꞌba ma koŋgɔ gɔ Seme. Kanana ti koloma rɔ atɔli zi Seme. ");
INSERT INTO bex_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Bɔkoꞌba kiꞌdi Yepete kara, kupö bo ga ti koloma ti bilaka ꞌba Seme ga. Kanana ti koloma rɔ atɔli zi bo.” ");
INSERT INTO bex_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Di pötö mini koso nima Nowa oloma koꞌdɔ kɔmɔ kɔɔ ꞌböwu kuluku modɔmorïyö (350). ");
INSERT INTO bex_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mï kada ma bo këdï kölë tine kɔmɔ kɔɔ abo ꞌdeni pili kuluku ꞌbutë döömu dɔmosowɔ (950). ");
INSERT INTO bex_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ame na rɔ kupö kole ꞌba Nowa ga ma lïjë Seme ni ti Ama ti Yepete köyö di pötö mini koso. ");
INSERT INTO bex_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Kole ma ꞌba Yepete ga na rɔ Gomere ni ti Magogo ti Madayi ti Yawana ti Tubala ti Maseke ti Tirasa. ");
INSERT INTO bex_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Kole ma ꞌba Gomere ga na rɔ Asekenaza ni ti Ripata ti Togaruma. ");
INSERT INTO bex_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Kole ma ꞌba Yawana ga na rɔ Elisa ni ti Sepaniya ti Kupurïyö ti Rodo. ");
INSERT INTO bex_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ya naga nime lïjë na rɔ yï lïŋgï ꞌba ya ma koloma dɔ kpa yöpö gbï mï döötu naga. Ame na rɔ kupö Yepete ga mï kpa gɔli mo ga ma koloma mï dɔliŋɔ ꞌbënnï ga ma gege kilende kpënnï ga pili rɔ ꞌberiꞌberi. ");
INSERT INTO bex_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kole ma ꞌba Ama ga na rɔ Kusa ni ti Ezipeto ti Libiya ti Kanana. ");
INSERT INTO bex_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kole ma ꞌba Kusa ga na rɔ Seyiba ni ti Awila ti Sabeta ti Rama ti Sabeteka. Kole ma ꞌba Rama ga na rɔ Seba ni ti Dedana. ");
INSERT INTO bex_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusa ari köyö Nimoroda, ame bo na koloma dɔgba rɔ bɔ tigɔ ma kaꞌda yayi mï dɔyayi nime. ");
INSERT INTO bex_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Bo na koloma rɔ rïrï ma dɔ kiteli kɔmɔ Bɔkoꞌba tupö yërï. Gɔ köꞌdu mo na ꞌdɔ këdï kiya te, “Kɔzɔ Nimoroda rɔ rïrï ma dɔ kiteli kɔmɔ Bɔkoꞌba bi tupö yërï.” ");
INSERT INTO bex_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kpa yayi abo na kisaki di Babele kala Ereke kebe Akada pili mï dɔyayi ꞌba Babele. ");
INSERT INTO bex_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Di mï dɔyayi nima yayi na bo kari Asura kari kubö gawo ꞌba Nïnëwë ni ti Robotayira ti Kala ");
INSERT INTO bex_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ti Resene mï löŋgö Nïnëwë ni ti gawo löbu ꞌba Kala. ");
INSERT INTO bex_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ezipeto na köyö kupö bilaka naga nima kïdëkï rɔ Ludïya ni ti Anama ti Laba ti Napetuma ");
INSERT INTO bex_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ti Paterusa ti Kasulu ti Kurëtë ame kupö bilaka ꞌba Pilisitiya kɔdɔ kako di teyi ne. ");
INSERT INTO bex_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kole ma dɔndende ꞌba Kanana ga na rɔ Sidona ni ti Ete. ");
INSERT INTO bex_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanana na gbï köyö kupö bilaka naga nima kïdëkï rɔ Yebusa ni ti Amora ti Girigasa ");
INSERT INTO bex_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ti Iwa ti Aruka ti Sina ");
INSERT INTO bex_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ti Aruwa ti Zemara ti Amata. Kupö Kanana naga nime pili ïyëyï rönnï rɔ gege ");
INSERT INTO bex_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","kina dɔ maga ꞌba eꞌbe Kanana kala ŋgï di Sidona ŋbö kömö Gerara ŋgɔsi ŋgila Gaza di kapa ma kari dɔ roꞌɔ. Tine kapa ma kari yïbï ala ŋbö kebe Sodomo ni ti Gomora ti Adoma ti Zeboyimo ŋbö kömö ŋgɔsi ŋgila Lasa. ");
INSERT INTO bex_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ame na rɔ kupö Ama ga mï kpa gɔli mo ga ma koloma mï dɔliŋɔ ꞌbënnï ga ma gege kilende kpënnï ga pili rɔ ꞌberiꞌberi. ");
INSERT INTO bex_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seme bɔ löndö ꞌba Yepete ni ma löbu na köyö kupö bilaka pili ame kïdëkï rɔ Ebere ne. ");
INSERT INTO bex_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Kole ma ꞌba Seme ga na rɔ Elama ni ti Asura ti Arupakasada ti Ludu ti Arama. ");
INSERT INTO bex_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Kole ma ꞌba Arama ga na rɔ Uzu ni ti Ulu ti Getere ti Mesa. ");
INSERT INTO bex_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Kole ma ꞌba Arupakasada na rɔ Sela, kina Sela köyö Ebere. ");
INSERT INTO bex_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebere öyö kole rïyö, möyï ma kɔtɔ rɔ Pelege, ame kiya te “Rɔ koza,” römöyï mï kada abo na bilaka ꞌba dɔyayi koza mïnnï. Möyï löndö bo na rɔ Yekotana. ");
INSERT INTO bex_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Kole ꞌba Yekotana ga na rɔ Alimodada ni ti Selepa ti Azalamaweta ti Jera ");
INSERT INTO bex_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ti Adorama ti Uzala ti Dikala ");
INSERT INTO bex_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ti Obala ti Abimayele ti Seba ");
INSERT INTO bex_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ti Opira ti Awila ti Jobaba. Ya naga nime pili rɔ kupö Yekotana ga. ");
INSERT INTO bex_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Dɔyayi ma lïjë koloma teyi na kala ŋbö di Mesa kömö Separa mï dɔyayi kuruŋgu ma kileki kapa kari yïbï. ");
INSERT INTO bex_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ame na rɔ kupö Seme ga mï kpa gɔli mo ga ma koloma mï dɔliŋɔ ꞌbënnï ga ma gege kilende kpënnï ga pili rɔ ꞌberiꞌberi. ");
INSERT INTO bex_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ya naga nime na rɔ kupö kole ꞌba Nowa ga mï kpa gɔli mo ga ma gege pili gɔ yï lïŋgï mo ga. Kupö lïjë na me kïyëyï rönï mï dɔyayi di pötö mini koso rɔ bilaka ꞌba dɔliŋɔ nime pili. ");
INSERT INTO bex_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ma dɔgba tönë bine bilaka ꞌba dɔliŋɔ nime pili ilende kpa ŋge kɔtɔ, mï ꞌbö ꞌba lende mo ga inza rɔ ꞌberiꞌberi. ");
INSERT INTO bex_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kina ɔdɔ bilaka lesi koloma ꞌdeni rɔ tilaki kebe yïbï tine, lïjë ari kömö mï bi pëpëlë mï dɔyayi ꞌba Babele kina lïjë koloma ŋgï yayi. ");
INSERT INTO bex_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tine lïjë ilende rɔ gɔ rönnï, iya te, “Ako doꞌbake töꞌbu gɔ doŋmake kele kandi.” Kina lïjë koꞌba töꞌbu ŋgï tine zïbïtï na rɔ wa ꞌba ꞌdɔ tora kɔmɔ mo timo. ");
INSERT INTO bex_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Lïjë iya te, “Ako doꞌbake gawo zize gbï ti tëlï ndende ma kakpa ŋbö kota mïtɔrɔ ꞌdɔ kiꞌdi möyï ze kïlëbï kinza ditaꞌbake ra kote mï dɔyayi pili.” ");
INSERT INTO bex_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kina Bɔkoꞌba kako bërï toŋgɔ gawo ti tëlï ndende nima bilaka naga nima koꞌba ne. ");
INSERT INTO bex_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Na bo kiya ti mï bo, kiya te, “Ya naga nima lïjë pili rɔ bilaka kɔtɔ, kina lïjë ilende kpa gbï ŋge kɔtɔ. Ame na ꞌdeni rɔ tisaki ꞌba wa ma lïjë këdï koꞌdɔ kada mɔtɔ. A mɔtɔ ame lïjë koꞌdɔkɔ toꞌdɔ mo inza konya dönnï kpe. ");
INSERT INTO bex_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ako dari bërï tudölö mï kpënnï yaga kinza lïjë kuwö mï lende kiya ꞌbënnï ga ra kpe rɔ gɔ rönnï.” ");
INSERT INTO bex_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kina Bɔkoꞌba kïyëyï lïjë ŋgï di yayi kitaꞌba kote mï dɔyayi nime pili lïjë kola toꞌba gawo tönë. ");
INSERT INTO bex_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Gɔ köꞌdu mo na kïdëkï möyï mo rɔ Babele, ame kiya te “Kudölö,” römöyï di yayi na Bɔkoꞌba kudölö mï kpa bilaka ꞌba dɔyayi nime pili, kina di yayi na gbï bo kïyëyï lïjë kitaꞌba kote mï dɔyayi nime ne. ");
INSERT INTO bex_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ame na rɔ kupö Seme ga. Kina ɔdɔ Seme koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku rïyö (100) tine, na bo köyö Arupakasada. Ama na ꞌdeni rɔ rïyö ꞌba kɔɔ ma di pötö mini koso. ");
INSERT INTO bex_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Di pötö töyö Arupakasada nime bo oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku ꞌbutë (500) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kina ɔdɔ Arupakasada koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë mota döömu tine, na bo köyö Sela. ");
INSERT INTO bex_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Di pötö töyö Sela nime Arupakasada oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku modɔɔmota kɔdɔ dɔmo mota (403) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kina ɔdɔ Sela koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë mota tine, na bo köyö Ebere. ");
INSERT INTO bex_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Di pötö töyö Ebere nime Sela oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku modɔɔmota kɔdɔ dɔmo mota (403) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kina ɔdɔ Ebere koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë mota dɔmosowɔ tine, na bo köyö Pelege. ");
INSERT INTO bex_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Di pötö töyö Pelege nime Ebere oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku modɔɔmota kɔdɔ dɔmo ꞌbutë mota (430) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kina ɔdɔ Pelege koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë mota tine, na bo köyö Ru. ");
INSERT INTO bex_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Di pötö töyö Ru nime Pelege oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku sowɔ kɔdɔ dɔmo modɔmosowɔ (209) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kina ɔdɔ Ru koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë mota dɔmorïyö tine, na bo köyö Seruga. ");
INSERT INTO bex_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Di pötö töyö Seruga nime Ru oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku sowɔ kɔdɔ dɔmo modɔmorïyö (207) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kina ɔdɔ Seruga koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë mota tine, na bo köyö Nawura. ");
INSERT INTO bex_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Di pötö töyö Nawura nime Seruga oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku sowɔ (200) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kina ɔdɔ Nawura koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë rïyö döömu dɔmosowɔ tine, na bo köyö Tera. ");
INSERT INTO bex_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Di pötö töyö Tera nime Nawura oloma ꞌböwu koꞌdɔ kɔmɔ kɔɔ kuluku rïyö kɔdɔ dɔmo ꞌbutë döömu dɔmosowɔ (119) bo köyö kole bɔtɔni mɔtɔ ga gbï ti yïtötï. ");
INSERT INTO bex_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kina ɔdɔ Tera koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö (70) tine, na bo köyö Abarama ni ti Nawura ti Arana. ");
INSERT INTO bex_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ame na rɔ kupö Tera ga. Kole abo ga na rɔ Abarama ni ti Nawura ti Arana. Kole ma ꞌba Arana na rɔ Lɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Arana ölë di mï gawo ꞌbënnï Ura mï dɔyayi ꞌba Babele gba kota ꞌbu nnï këdï ti kömönï. ");
INSERT INTO bex_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abarama ogbe Sarayi, tine Nawura ogbe ꞌba bo rɔ Mileka nyiti ꞌba Arana. Kole ꞌba Arana mɔtɔ na gbï rɔ Yiseka. ");
INSERT INTO bex_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tine löyö iꞌdi rönï dë zi Sarayi lɔko ɔrɔ gbɔ ŋgï rɔ kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera ogba kole abo Abarama ni ti kole ꞌba kole abo Lɔtɔ kole ꞌba Arana ti Sarayi ꞌja ꞌba kole abo Abarama kënyï tïnnï di Ura di mï dɔyayi ꞌba Babele tari mï dɔyayi ꞌba Kanana. Tine lïjë ari kömö Arana na lïjë koloma ŋgï kileke bina. ");
INSERT INTO bex_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ari kölë di Arana yayi koꞌja kɔmɔ kɔɔ ꞌba loma abo këdï ꞌdeni pili kuluku sowɔ kɔdɔ dɔmo muyï (205). ");
INSERT INTO bex_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bɔkoꞌba ilende zi Abarama, iya te, “Ënyï di mï dɔyayi ꞌbe di mï löŋgö bilaka ꞌbï ga, di mï liŋɔ ꞌba ꞌbu yï kari mï dɔyayi ame mëdï mileme zïyï ne. ");
INSERT INTO bex_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ti miꞌdi kupö bilaka ma konzi kɔdɔ di mïyï. Ti moꞌdɔ yëyï ma laka zïyï miꞌdi möyï yï kïlëbï, ꞌdɔ këddï rɔ yëyï zi bilaka. ");
INSERT INTO bex_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ti moꞌdɔ yëyï ma laka zi bilaka ame ga këdï koꞌdɔ yëyï zïyï. Tine ti mulömu bɔtɔ ma kulömu yi. Ti moꞌdɔ yëyï ma laka tïyï pili dɔ bilaka ꞌba dɔyayi.” ");
INSERT INTO bex_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kina Abarama kënyï ŋgï kari kɔzɔ ma Bɔkoꞌba kiya zi bo tara. Kina Lɔtɔ ënyï gbï kari kɔtɔ ti bo. Mï kada nima Abarama kënyï di Arana ne kɔmɔ kɔɔ abo ëdï ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö döömu (75). ");
INSERT INTO bex_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abarama ogba ꞌja abo Sarayi ni ti Lɔtɔ kole ꞌba löndö bo ti wa ame ga pili lïjë këdï timo kpaki ti atɔli ame ga lïjë koꞌja di Arana yayi ne tari timo mï dɔyayi ꞌba Kanana. Kina ɔdɔ lïjë kömö ꞌdeni mï dɔyayi ꞌba Kanana yayi tine, ");
INSERT INTO bex_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","bo ari nduwë kebe mï dɔyayi nima ŋbö bo kömö ŋgila ŋgërï koro ꞌba Mɔre mï Sekeme. Mï kada mo nima eꞌbe Kanana ëdï gba koloma mï dɔyayi nima yayi. ");
INSERT INTO bex_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kina Bɔkoꞌba kileme rönï zi Abarama, kiya te, “Yayi nime na mëdï miꞌdi zi kupö yï ga.” Kina Abarama koꞌba bi ꞌba akumu yayi zi Bɔkoꞌba ame kileme rönï ꞌdeni zi bo ne. ");
INSERT INTO bex_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Di pötö mo tine na bo kolɔlɔ nduwë kari kapa dɔ roꞌɔ kari dɔyayi kuruŋgu ma kileki kapa Betele ma kari yïbï. Kina bo kari koga taya abo yayi mï löŋgö Betele ni ti Ayi. Betele kebe kapa ma kari dɔ tɔrɔ tine Ayi kebe kapa mo ma kileki yïbï. Di yayi bo oꞌba bi ꞌba akumu gbï bo koloma tumötu Bɔkoꞌba di teyi. ");
INSERT INTO bex_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kina bo koloma tolɔlɔ ŋgï nduwë di yayi kari kapa dɔyayi ꞌba Kanana ma kileki dɔ roꞌɔ. ");
INSERT INTO bex_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tine sëyï ma kënyë ari kilaꞌba ŋgï mï dɔyayi nima yayi. Gɔ köꞌdu mo na Abarama kari ŋbö Ezipeto ꞌdɔ toloma titi mbowa yayi. ");
INSERT INTO bex_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kina ɔdɔ bo kari kömö ꞌdeni dɔ maga ꞌdɔ tari ŋgï Ezipeto tine, bo iya zi ꞌja abo Sarayi, bo iya te, “Nï na me kele kulöwö te, ");
INSERT INTO bex_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ɔdɔ Ezipeto koꞌja yi lïjë ëdï kiya te nï ꞌja ma na, kina lïjë ti kupö ma ŋgï yaga kola yi koloma. ");
INSERT INTO bex_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Iya zïnnï, iya te, nï lëmï ma na kina lïjë ti kola ma moloma ꞌdɔ koꞌdɔ ma laka gɔ köꞌdu ꞌbï.” ");
INSERT INTO bex_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kina ɔdɔ bo kumu dɔ maga nima ꞌdeni kɔdɔ Ezipeto tine, bilaka ꞌba Ezipeto oŋgɔ ꞌja nima ele ŋgï rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kina ɔdɔ turu ma löbu mɔtɔ ga ꞌba bɔ dɔliŋɔ ma löbu ꞌba Ezipeto nima koꞌja lɔko ꞌdeni tara tine, lïjë ari ŋgï kubï gɔ tele mo zi bo. Kina koto lɔko ŋgï kari liŋɔ abo. ");
INSERT INTO bex_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Gɔ köꞌdu mo na bɔ nima koloma ŋgï rɔ toꞌdɔ Abarama rɔ ma laka kiꞌdi dɔtumu ꞌba kamölö ni ti banya teyi ti sa ni ti akaca gbï ti atɔli ni ti gamele. ");
INSERT INTO bex_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tine gɔ köꞌdu nima bo kogba Sarayi ꞌja ꞌba Abarama ne, na Bɔkoꞌba kodɔ rɔkɔꞌɔ ma kinza kiya naga ŋgï dɔ bo kpaki ti bilaka ꞌba mï liŋɔ abo ga. ");
INSERT INTO bex_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kina bo koja laja gɔ Abarama, kiya teyi, iya te, “Waꞌdi na me koꞌdɔ zö te ne? Gɔ waꞌdi na kiya dë zö te, lɔko ꞌja ꞌbï na? ");
INSERT INTO bex_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Gɔ waꞌdi na kiya te lɔko lëmï yï na kiꞌdi mogba lɔko rɔ ꞌja zö? ꞌJa ꞌbï na me, ogba lɔko kënyï kari yaga di bine.” ");
INSERT INTO bex_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Bɔ dɔliŋɔ nima iꞌdi lende mo zi bilaka abo ga kogba Abarama koja yaga di mï dɔyayi nima kari ti ꞌja abo Sarayi kpaki ti wa ame ga ꞌdeni rɔ ꞌba bo ne. ");
INSERT INTO bex_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kina Abarama kɔdɔ yaga di mï dɔyayi ꞌba Ezipeto ti ꞌja abo kpaki ti wa ame ga pili rɔ ꞌba bo ne. Lɔtɔ ari gbï kɔtɔ ti bo, lïjë kari mï dɔyayi ꞌba Kanana ma kileki kapa dɔ roꞌɔ. ");
INSERT INTO bex_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Tine Abarama ꞌdeni rɔ bɔ wa ti dɔtumu ꞌba yërï ame ga pili rɔ ꞌba liŋɔ ne rɔ ma konzi gbï ti yamo rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Di yayi na bo kënyï nduwë tolɔlɔ kari yɔki Betele, ŋbö bo kari kömö gɔ bi ma tönë mï löŋgö Betele ni ti Ayi bo koga taya abo pa dɔpara teyi ne. ");
INSERT INTO bex_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Gɔ bi nima na gbï tönë bo koꞌba bi ꞌba akumu zi Bɔkoꞌba teyi, na bo kari kumötu Bɔkoꞌba yayi. ");
INSERT INTO bex_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lɔtɔ ma tönë kari ti Abarama ne ëdï ꞌdeni gbï ti dɔtumu ꞌba yërï rɔ ma konzi ti bilaka ma ꞌba bo ga. ");
INSERT INTO bex_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Gɔ köꞌdu mo na gɔ bi inza kpe ŋgölö rönnï di mï dɔyayi nima yayi ꞌdɔ toloma bi kɔtɔ, römöyï yërï ꞌbënnï ga onzi ꞌdeni ŋgï rɔ mbëmbë, gɔ bi ꞌba mɔli ɔꞌbɔ dë kpe zïnnï todɔꞌbɔ dönnï teyi. ");
INSERT INTO bex_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kina lamo kuꞌdu rönï ŋgï mï löŋgö bɔ koda yërï ꞌba Abarama ga ti bɔ koda yërï ma ꞌba Lɔtɔ ga. Mï kada nima eꞌbe Kanana ti eꞌbe Pereze ga ëdï gba koloma mï dɔyayi nima. ");
INSERT INTO bex_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kina Abarama kilende zi Lɔtɔ, iya te, “Ze rɔ löndö, kinza diꞌdi lamo dë këdï mï löŋgö ze ma ze tïyï ala gbï mï löŋgö bɔ koda yërï ꞌbama ga ma ti ꞌbëyï. ");
INSERT INTO bex_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dɔyayi na me pili kömöyï, oza röyï gbɔ yaga di rɔma. Oza kapa ma koꞌdɔkɔ, ɔdɔ koꞌdɔkɔ tari dɔ kapa gali ti mileki ꞌbama te dɔ kapa dörï. Ne ala ari te dɔ kapa dörï ti mileki ꞌbama te dɔ gali.” ");
INSERT INTO bex_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lɔtɔ ombi kömönï koŋgɔ yayi ame pili mï bi kïlëdë ꞌba kpa yöpö Yaradene ŋbö kala Zora na ti mini teyi rɔ mbëmbë kɔzɔ nyaka ꞌba Bɔkoꞌba tönë mï Edene, gbï kɔzɔ dɔyayi ꞌba Ezipeto. Wa nime mɔlo gba kota kinza ma Bɔkoꞌba kote dɔ Sodomo ni ti Gomora dë. ");
INSERT INTO bex_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kina Lɔtɔ koza ꞌba bo rɔ yayi ame pili mï bi kïlëdë ꞌba yöpö Yaradene, na bo kënyï kari ŋgï nduwë kapa ma kileki yïbï. Toza rɔ ma ya rïyö naga nime koza rönnï na kɔzɔ wa nima tara. ");
INSERT INTO bex_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abarama oloma ꞌba bo mï dɔyayi ꞌba Kanana, tine Lɔtɔ ari ꞌba bo koloma mï löŋgö gawo ma mï bi kïlëdë naga nima, kina bo kari koga taya abo ŋgɔsi ŋgila Sodomo. ");
INSERT INTO bex_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tine bilaka ꞌba mï gawo nima lende kënyë mo ŋgï rɔ dɔ kiteli kɔmɔ Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Di pötö Lɔtɔ kari ꞌdeni tine na Bɔkoꞌba kilende zi Abarama, iya te, “Di mï gɔ bi nima këddï teyi ne, ombi kömöyï koŋgɔ bi toko dɔ kapa ꞌba bi pili. ");
INSERT INTO bex_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Yayi nime koŋgɔ ne mëdï miꞌdi pili zïyï ti kupö yï ga ꞌdɔ köꞌbö ŋburu rɔ ëꞌbï. ");
INSERT INTO bex_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ti miꞌdi kupö yï ga konzi kɔzɔ lupu ꞌba dɔyayi. Ɔdɔ bɔ mo kïtëtë lupu ꞌba mï dɔyayi nime ꞌdeni kote tine na bo ti kɔꞌbɔ ꞌjaa tïtëtë kupö yï ga. ");
INSERT INTO bex_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ënyï kiliŋgere kote mï dɔyayi nime pili römöyï mëdï miꞌdi zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kina Abarama kolɔlɔ taya abo ŋgï kari ŋgila ŋgërï koro ꞌba Mamore mï Eborona. Kina bo kari koꞌba bi ꞌba akumu yayi zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mï kada ꞌba Amorapela ŋere ꞌba Babele ni lïjë ti Ariyɔko ŋere ꞌba Elesara ti Kedarolamera ŋere ꞌba Elama ti Tidala ŋere ꞌba Goyima, ŋere sowɔ naga nime ");
INSERT INTO bex_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","alo ya dɔ Bera ŋere ꞌba Sodomo ni lïjë ti Birasa ŋere ꞌba Gomora ti Sinaba ŋere ꞌba Adoma ti Semebere ŋere ꞌba Zeboyimo ti ŋere ꞌba Bela ame kïdëkï möyï mo gbï rɔ Zora ne. ");
INSERT INTO bex_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ŋere muyï naga nime indaꞌba mïnnï kodɔꞌbɔ rönnï kpa ya mï bi kïlëdë ꞌba Sidimi ame ꞌdeni leꞌjete rɔ Pöpö Mëlö ne. ");
INSERT INTO bex_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kɔmɔ kɔɔ mo ꞌdeni ꞌbutë dɔmorïyö ame Kedarolamera na koloma rɔ bɔ dönnï pili. Tine mï kɔmɔ kɔɔ ma ꞌbutë dɔɔmota na lïjë kënyï tonyo burutu bo. ");
INSERT INTO bex_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mï kɔmɔ kɔɔ ꞌbutë dɔmosowɔ na Kedarolamera ni ti ŋere ame ga ti bo ne kalo ti bɔ ya ꞌbënnï ga kaꞌda eꞌbe Repa ga di Asetoro Karanayima, kina gbï ti eꞌbe Zuza ga di Ama ti eꞌbe Eme ga di mï bi pëpëlë ꞌba Kiriyatayima ");
INSERT INTO bex_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ti eꞌbe Ori ga di dɔ kuruŋgu ꞌba Edome koga gɔmo ŋbö kala Eleparana kapa ma kari yï mökö. ");
INSERT INTO bex_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kina lïjë kuyï kpënnï ꞌböwu di yayi kileki kari te mï Kadesa ame kïdëkï möyï mo pa rɔ Enemisapata ne. Di yayi na lïjë kaꞌda eꞌbe Amaleke ga pili di mï dɔyayi ꞌbënnï gbï ti eꞌbe Amora ame ga koloma ꞌbënnï mï Azazona Tamara ne. ");
INSERT INTO bex_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kina ŋere ꞌba Sodomo ni ti ꞌba Gomora ti ꞌba Adoma ti ꞌba Zeboyimo ti ꞌba Bela ame gbï kïdëkï rɔ Zora ne kotɔtɔ bɔ ya ꞌbënnï ga ŋgï kari kpa ya mï bi kïlëdë ꞌba Sidimi. ");
INSERT INTO bex_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ŋere muyï naga nime alo ya dɔ ŋere ma sowɔ ame ga rɔ Kedarolamera ŋere ꞌba Elama ni lïjë ti Tidala ŋere ꞌba Goyima ti Amorapela ŋere ꞌba Babele ti Ariyɔko ŋere ꞌba Elesara. ");
INSERT INTO bex_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Tine bi kïlëdë ꞌba Sidimi mo nima ŋgï lɔ ti gö ꞌba zïbïtï. Kina ɔdɔ ŋere ꞌba Sodomo ni ti ꞌba Gomora këdï koꞌdɔ tiriŋa yaga di zi ya tine, lïjë ilaꞌba ŋgï mï gö tönë ga. Ŋere ma mota na ŋge kolɔlɔ kɔmɔ kari dɔ kuruŋgu. ");
INSERT INTO bex_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kina ŋere sowɔ naga nima kolɔ wa ame ga pili mï Sodomo ni ti Gomora ne ŋgï kpaki ti wa ma konyo kari timo. ");
INSERT INTO bex_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lïjë indaꞌba Lɔtɔ kole ꞌba löndö ꞌba Abarama ma tönë këdï koloma Sodomo yayi ne ŋgï gbï kpaki ti wa mo ga kari timo. ");
INSERT INTO bex_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tine bɔ mɔtɔ ame kɔmɔ di mï ya nima na kako kiya lende mo zi Abarama bɔ Ebere tönë këdï koloma ŋgila ŋgërï koro ꞌba Mamore eꞌbe Amora ne. Mamore ni ti löndö bo ga Esekole ni ti Anera na kindaꞌba mïnnï ꞌdeni ti Abarama. ");
INSERT INTO bex_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kina ɔdɔ Abarama kuwö ꞌdeni kiya te indaꞌba kole ꞌba löndö bo ꞌdeni kɔzɔ a nima tara tine, na bo kotɔtɔ bɔ toꞌdɔ ya abo ga ame pili mï liŋɔ abo yayi ne ŋgï. Lïjë ëdï pili kuluku modɔɔkɔtɔ kɔdɔ dɔmo ꞌbutë döömu dɔɔmota (318). Kina lïjë kari tozi gɔ ya naga nima ŋbö kömö Dana. ");
INSERT INTO bex_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Rɔ mï korɔndɔ ꞌdeni tine na bo koza bilaka abo ga rɔ dɔtumu kuru dɔ ya naga nima koꞌdɔ ya timo kaꞌda koga gɔmo ŋbö kala Oba kapa Damaseke ma kileki dɔ tugbu tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kina bo kotɔtɔ wa ame ga pili ya naga nima kolɔ ne kileki timo gbï ti Lɔtɔ kole ꞌba löndö bo ti wa mo ga ti ꞌja ma kindaꞌba kpaki ti ꞌbɔki mɔtɔ ga. ");
INSERT INTO bex_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Di pötö tileki ꞌba Abarama di bi taꞌda ŋere Kedarolamera ni na ŋere ꞌba Sodomo kari turë dɔ bo mï bi kïlëdë ꞌba Sawe ame kïdëkï möyï mo gbï rɔ bi kïlëdë ꞌba ŋere. ");
INSERT INTO bex_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kina Malekisedeke ŋere ꞌba Salema ame bo gbï rɔ bɔ akumu ꞌba Bɔkoꞌba ma mïtɔrɔ ne kako ti maŋgolɔꞌbɔ ni ti layi ");
INSERT INTO bex_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","koꞌdɔ yëyï dɔ Abarama, kiya te, “Bɔkoꞌba ꞌba mïtɔrɔ ame koꞌba mïtɔrɔ ni ti dɔyayi ne koꞌdɔ yëyï zi Abarama. ");
INSERT INTO bex_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Akïlëlu këdï zi bo Bɔkoꞌba ꞌba mïtɔrɔ ame kiꞌdi yi kaꞌda bɔ ya ꞌbï ga ne.” Kina Abarama kiꞌdi kapa ma ꞌbutë ꞌba wa pili zi Malekisedeke. ");
INSERT INTO bex_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ŋere ꞌba Sodomo nima ilende zi Abarama, iya te, “Ileki bilaka ma ga zö, tine wa naga nima pili ogba zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tine Abarama ileki dɔmo zi ŋere ꞌba Sodomo nima, iya te, “Mulömu rɔma kɔmɔ ŋere Bɔkoꞌba ꞌba mïtɔrɔ bɔ koꞌba mïtɔrɔ ni ti dɔyayi, ");
INSERT INTO bex_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","a mɔtɔ minza mogba alato ꞌbï ala kabi ꞌba wari ꞌbï ala ëꞌbï ma kɔtɔ mɔtɔ te, kinza kari kiya ra te, ‘Ma na miꞌdi Abarama rɔ bɔ mɔri.’ ");
INSERT INTO bex_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Minza mogba ëꞌbï ma kɔtɔ mɔtɔ te, tine ŋge rɔ wa ame ga bilaka ma ga konyo ꞌdeni. Ne iꞌdi bɔ pɔri ma ga Anera ni ti Esekole ti Mamore kogba bi gomɔ ꞌba rönnï.” ");
INSERT INTO bex_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Di pötö mo na lende ꞌba Bɔkoꞌba kako zi Abarama ti nyï koꞌde dɔ bo, iya te, “Abarama, kinza kere dë. Ma na rɔ makëtï ꞌba titata yi di zi wa ma kënyë. Mëdï miꞌdi kpa közï zïyï rɔ mbëmbë.” ");
INSERT INTO bex_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tine Abarama ileki dɔmo, iya te, “Yö, ŋere Bɔkoꞌba, lende laka waꞌdi na ti kpa közï ꞌbï mo nima koꞌdɔ zö koꞌja möꞌbö ꞌdeni ŋgï kinza kole ɔtɔ ne ya? Bɔ ma këdï kari kindaꞌba apötö ma na ŋgï ti këdï rɔ Elizara ꞌba Damaseke nime. ");
INSERT INTO bex_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Iꞌdi kole ɔtɔ dë gbï zö yɔ, atɔli nime köyö mï liŋɔ ma ne na ŋgï këdï kari kindaꞌba apötö ma.” ");
INSERT INTO bex_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kina bo kuwö Bɔkoꞌba kilende ꞌböwu zi bo, iya te, “Atɔli nima inza kindaꞌba apötö yï. Kole ꞌba gbagba yï na ko këdï kindaꞌba apötö yï.” ");
INSERT INTO bex_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kina Bɔkoꞌba koto bo kari yaga, iya te, “Ombi kömöyï mïtɔrɔ kiyɔzɔ tïtëtë këlu naga nime te, kupö yï ga na ti konzi tara.” ");
INSERT INTO bex_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abarama iꞌdi dɔ bo gɔ lende ꞌba Bɔkoꞌba kina me kiꞌdi Bɔkoꞌba kïdëkï Abarama rɔ bɔ lende laka. ");
INSERT INTO bex_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Bɔkoꞌba ilende zi bo, iya te, “Ma na rɔ Bɔkoꞌba ame koꞌde yi di Ura di mï dɔyayi ꞌba Babele ꞌdɔ tiꞌdi yayi nime zïyï gɔ këddï rɔ bɔ dɔmo.” ");
INSERT INTO bex_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abarama iya te, “Yö, ŋere Bɔkoꞌba, ti mikali tondo ma mëdï moloma rɔ bɔ dɔmo?” ");
INSERT INTO bex_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Bɔkoꞌba iya te, “Oꞌde rokɔ sa ti rokɔ banya ti kole kamölö, yërï naga nime pili rɔ ma kɔmɔ kɔɔ mo ga ŋge gba mota ti matukpuru gbï ti kole matukpuru.” ");
INSERT INTO bex_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kina Abarama koꞌde yërï naga nime kumu kotopa yïmo rïyö, bo kiyija kapa mo ga pili rɔ ma koriya mindalo rïyö rɔ lömu löŋgö lïjë ti Bɔkoꞌba. Tine bo otopa mï yali mo ga dë. ");
INSERT INTO bex_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Raŋga ako koꞌdɔkɔ togɔ yida naga nima, tine Abarama oga lïjë ŋgï yaga di teyi. ");
INSERT INTO bex_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kina ɔdɔ kada këdï kösö ꞌdeni tine na töꞌdö ma kinza kiya kindaꞌba Abarama ŋgï. Mandölu ma dɔ kiteli utuꞌbö bo ŋgï gbï ti tikere ma mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kina Bɔkoꞌba kilende zi bo, iya te, “Rɔ ma laka kupö yï ga ti koloma rɔ bɔ löwö mï dɔyayi löwö. Lïjë ti koloma rɔ atɔli yayi koꞌdɔ kpɔŋi rönnï ŋbö kɔmɔ kɔɔ kuluku modɔɔmota (400). ");
INSERT INTO bex_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tine ti modɔ karama dɔ bilaka ꞌba dɔyayi mo naga nima koꞌdɔ kpɔŋi rönnï ne. Kina ɔdɔ lïjë këdï kɔdɔ ꞌdeni yaga di mï dɔyayi löwö nima, lïjë ti kogba wa ŋgï tïnnï rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ne ꞌbëyï ti kari ëꞌbï ꞌjaa liya zi ꞌbu yï ga ti mï këyï. Ti kusu yi ꞌjaa ndɔ koꞌja köndë ëꞌbï ꞌdeni kote. ");
INSERT INTO bex_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kupö yï ga ti kileki ꞌjaa kako bine mï kada ꞌba kupö ma mï sowɔ ma koloma mï dɔyayi löwö nima yayi römöyï minza moga eꞌbe Amora ga titi yaga di bine, tine ꞌjaa ŋbö ɔdɔ lende kirasi ꞌbënnï ꞌdeni rɔ mbëmbë ꞌdɔ kodɔ karama mo dönnï.” ");
INSERT INTO bex_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kina ɔdɔ kada kösö ꞌdeni gɔ bi kölu tine, na Bɔkoꞌba kako ŋgï ti kete paꞌdo ti paꞌdo dɔ kali kako ŋgï kudö kebe mï löŋgö yida naga nima. ");
INSERT INTO bex_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mï kada nima na Bɔkoꞌba koꞌdɔ lömu ti Abarama, iya te, “Miꞌdi yayi nime ꞌdeni pili zi kupö yï ga, kisaki mɔlo di kpa dɔ maga ꞌba Ezipeto kala kpa yöpö ꞌba Epurate, ");
INSERT INTO bex_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ame rɔ dɔyayi ꞌba bilaka naga nima kïdëkï rɔ Kene ti Keneze ti Kadamono ");
INSERT INTO bex_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ti Ete ti Pereze ti Repa ");
INSERT INTO bex_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ti Amora ti Kanana ti Girigasa kina gbï ti Yebusa.” ");
INSERT INTO bex_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi ꞌja ꞌba Abarama öyö kole ma kɔtɔ te dë du zi bo. Tine lɔko ëdï ti atɔli ꞌbënï yayi rɔ yïtö ꞌba Ezipeto kïdëkï möyï mo rɔ Agara. ");
INSERT INTO bex_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kina lɔko kilende zi mëꞌdë nï Abarama, iya te, “Bɔkoꞌba na me koꞌjɔŋɔ ma ꞌdeni kinza töyö kole. Atɔli ma nima öꞌdö timo, mɔtɔga lɔko na ti köyö kole zö.” Kina Abarama kutï ŋgï gɔ lende ꞌba Sarayi nima. ");
INSERT INTO bex_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Di pötö ma Abarama koloma ꞌdeni koꞌdɔ kɔmɔ kɔɔ ꞌbutë mï dɔyayi ꞌba Kanana tine, na ꞌja abo Sarayi kiꞌdi atɔli ꞌbënï Agara yïtö ꞌba Ezipeto nima ŋgï rɔ ꞌja zi bo. ");
INSERT INTO bex_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abarama öꞌdö ti Agara kina kɔmɔ ŋgï. Kina ɔdɔ lɔko koŋgɔ ꞌdeni lɔko kɔmɔ kɔzɔ wa nima tara tine, lɔko ŋgï rɔ dɔ kombi kebe toŋgɔ Sarayi ŋgï kɔzɔ wa ma yawa. ");
INSERT INTO bex_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi iya zi Abarama, iya te, “Ee, lende kënyë nime koꞌdɔ rɔma ne ti kileki döyï. Ma na tönë miꞌdi atɔli ma nime zïyï, kina me lɔko koꞌja ꞌdeni lɔko kɔmɔ, lɔko oŋgɔ ma ꞌdeni ŋgï kɔzɔ wa ma yawa. Bɔkoꞌba koꞌdɔ burë nime mï löŋgö ze tïyï, ɔdɔ ꞌba yë na laka.” ");
INSERT INTO bex_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tine Abarama ileki zi Sarayi, iya te, “Lɔko atɔli ꞌbï na, nï ti közï kakpa dönï. Oꞌdɔ lɔko ŋgï kɔzɔ wa ma koꞌdɔkɔ toꞌdɔ mo tara.” Kina Sarayi koloma ŋgï toꞌdɔ Agara rɔ ma kënyë, na Agara kënyï kiriŋa ŋgï di zïnï. ");
INSERT INTO bex_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malayika ꞌba Bɔkoꞌba ari kondɔsɔ ti Agara di kpa daa di mï mökö gɔ kɔri kari Surö, ");
INSERT INTO bex_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","kilende zïnï, iya te, “Agara atɔli ꞌba Sarayi, ako di yala kina ëddï kari yala?” Lɔko iya te, “Mëdï miriŋa di zi Sarayi bɔ dɔma.” ");
INSERT INTO bex_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malayika nima iya zïnï, iya te, “Ileki kari zi Sarayi bɔ döyï kuwö dönï.” ");
INSERT INTO bex_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kina malayika kileki gbï kiya te, “Mëdï miꞌdi kupö yï ga kara konzi rɔ mbëmbë bi ꞌba tïtëtë mo konya dɔ. ");
INSERT INTO bex_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kole nima mïyï ne ëddï köyö rɔ kole bɔtɔni kïdëkï möyï mo rɔ Yisamele, ame kiya te ‘Bɔkoꞌba uwö ꞌdeni,’ römöyï Bɔkoꞌba uwö lisa ꞌbï ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bo ti koloma rɔ kuruku kɔzɔ akaca ꞌba mökö naga tara. Bo ti koloma köꞌbö rɔ ya ti bilaka pili kina bilaka pili ti köꞌbö gbï rɔ ya ti bo. Bo ti koloma ꞌberi yaga di mï löŋgö wado abo ga pili.” ");
INSERT INTO bex_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agara ititi rönï, iya te, “Bɔkoꞌba na me ŋgï moꞌja rɔ ma laka? Mëdï moloma gba rɔ ma kïdïdï di pötö mo ne?” Gɔ köꞌdu mo na lɔko kïdëkï möyï Bɔkoꞌba ame kileme rönï zïnï ne rɔ “Bɔkoꞌba ma koŋgɔ ma.” ");
INSERT INTO bex_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kina ma ꞌdɔ kiꞌdi bilaka kïdëkï möyï daa nima mï löŋgö Kadesa ni ti Berede ne rɔ “Daa ꞌba bɔ dïdï ame koŋgɔ ma ne.” ");
INSERT INTO bex_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agara öyö kole zi Abarama kina bo kiꞌdi möyï mo rɔ Yisamele. ");
INSERT INTO bex_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Mï kada mo nima kɔmɔ kɔɔ ꞌba Abarama ëdï ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë mota döömu dɔɔkɔtɔ (86). ");
INSERT INTO bex_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kina ɔdɔ kɔmɔ kɔɔ ꞌba Abarama këdï ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë sowɔ döömu dɔmosowɔ (99) tine, na Bɔkoꞌba kileme rönï zi bo, iya te, “Ma na rɔ Bɔkoꞌba bɔ tigɔ dɔ kiteli. Uwö dɔma, kina öꞌbö nduwë toꞌdɔ wa ma kodɔrɔ gɔ kɔmɔ ma. ");
INSERT INTO bex_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mëdï moꞌdɔ lömu ma tïyï miꞌdi kupö yï ga konzi rɔ mbëmbë.” ");
INSERT INTO bex_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kina Abarama kudë dɔ bo bërï mëmë mo kosa yayi. Bɔkoꞌba iya te, ");
INSERT INTO bex_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Moꞌdɔ lömu ma ꞌdeni tïyï, ti këddï rɔ ꞌbu löbu ꞌba bilaka ꞌba dɔꞌbe ma konzi. ");
INSERT INTO bex_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Möyï yï inza kpe rɔ Abarama, tine ꞌdeni rɔ Abarayama, ame kiya te ‘ꞌBu ꞌba dɔꞌbe,’ römöyï moꞌdɔ yi ꞌdeni rɔ ꞌbu löbu ꞌba bilaka ꞌba dɔꞌbe ma konzi. ");
INSERT INTO bex_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ti miꞌdi kupö ma konzi kɔdɔ di mïyï mɔtɔ ga koloma rɔ bɔ dɔliŋɔ ma löbu. Mëdï miꞌdi kupö yï ga konzi koloma rɔ bilaka ꞌba dɔꞌbe ma konzi. ");
INSERT INTO bex_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ti miꞌdi lömu ma köꞌbö mï löŋgö ze tïyï gbï ti kupö yï ga nduwë kala gɔ kupö lïjë ga ma di yïꞌböwu yayi. Ti miꞌdi lömu nime köꞌbö rɔ ŋburuŋburu, moloma rɔ Bɔkoꞌba zïyï kina gbï zi kupö yï ga. ");
INSERT INTO bex_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mëdï miꞌdi yayi nime këddï koloma yïmo rɔ bɔ löwö ne zïyï kina gbï zi kupö yï ga. Dɔyayi ꞌba Kanana nime pili ti koloma köꞌbö ŋburu rɔ yayi ꞌba kupö yï ga, kina ti möꞌbö gbï rɔ Bɔkoꞌba zïnnï.” ");
INSERT INTO bex_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kina Bɔkoꞌba kilende gbï zi Abarayama, iya te, “Nï gbï ꞌdɔ kutï toro lömu nime mï löŋgö ze tïyï ne, nï Abarayama kpaki ti kupö yï ga nduwë kala gɔ kupö lïjë ga ma di yïꞌböwu yayi. ");
INSERT INTO bex_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Lömu ame ꞌdɔ koro gɔ köꞌbö mï löŋgö ze tïyï gbï ti kupö yï ga ne, kina me. Bɔtɔni pili ame ga rɔ kupö yï ne ꞌdɔ koꞌdɔ dölëtï ꞌba akilele. ");
INSERT INTO bex_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ziye pili tilele dɔ ꞌbana ꞌba rɔye ꞌdɔ köꞌbö rɔ kïnë ꞌba lömu nime mï löŋgö ze tïyï ne. ");
INSERT INTO bex_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Kisaki di mï kada nime tɔne nduwë kari dɔgba, ziye tilele kole bɔtɔni pili mï töꞌdö dɔ modɔɔmota di pötö kada ꞌba töyö mo. Kole bɔtɔni ame ga nduwë kala gɔ kupö yï ga ma di yïꞌböwu yayi kpaki ti atɔli ma köyö mï liŋɔ ꞌbï ala ma kugö ti yamo ꞌbï ga ame lïjë rɔ bɔ löwö kinza rɔ kupö ꞌba mïyï ne pili ꞌdɔ tilele mo. Ame na rɔ kïnë ꞌba lömu ma mï yida rɔye ꞌdɔ kileme lömu nime moꞌdɔ tïyï ne öꞌbö ꞌdeni rɔ ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Bɔtɔni ame kilele dë ne inza kpe rɔ ꞌbama römöyï bo oro lömu ma dë.” ");
INSERT INTO bex_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kina Bɔkoꞌba kilende ꞌböwu zi Abarayama, iya te, “Kinza kïdëkï möyï ꞌja ꞌbï Sarayi dë kpe rɔ Sarayi, tine möyï nï ꞌdeni rɔ Sara. ");
INSERT INTO bex_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mëdï moꞌdɔ yëyï ma laka zïnï lɔko köyö kole zïyï. Mëdï moꞌdɔ yëyï zïnï lɔko koloma rɔ ma ꞌba bilaka ꞌba dɔꞌbe ma konzi. Bɔ dɔliŋɔ ma löbu ti kɔdɔ di mï kupö nï ga.” ");
INSERT INTO bex_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kina Abarayama kudë dɔ bo bërï mëmë mo kosa yayi. Tine bo ögö kiya ti mï bo, iya te, “Bɔtɔni ame kɔmɔ kɔɔ mo ꞌdeni kuluku rïyö (100) ne, ti köyö kole yɔ? Sara ame kɔmɔ kɔɔ mo ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë sowɔ (90) ne ti köyö kole yɔ?” ");
INSERT INTO bex_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kina bo kiya zi Bɔkoꞌba, iya te, “Dëne ꞌdɔ kiꞌdi Yisamele ra gbɔ ꞌdɔ koloma rɔ bi dɔma.” ");
INSERT INTO bex_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bɔkoꞌba iya te, “Inza tara, ꞌja ꞌbï Sara ëdï köyö kole zïyï kiꞌdi möyï mo rɔ Yisika. Kina ti mulömu lömu ma nime köꞌbö ti bo nduwë rɔ ŋburuŋburu kala gɔ kupö bo ga ma di yïꞌböwu. ");
INSERT INTO bex_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ne muwö akititi ꞌbï ma gɔ lende ꞌba Yisamele ꞌdeni, ti moꞌdɔ yëyï zi bo miꞌdi kole konzi zi bo, kupö bo kara rɔ mbëmbë. Bo ti këdï rɔ ꞌbu ꞌba ŋere ꞌbutë dɔmorïyö. Kina ti miꞌdi kupö bo ŋgï kara rɔ bilaka ꞌba dɔꞌbe ma löbu. ");
INSERT INTO bex_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tine ti mulömu lömu ma köꞌbö ti Yisika ame Sara këdï köyö zïyï ti kɔɔ kabate ne.” ");
INSERT INTO bex_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kina ɔdɔ Bɔkoꞌba kote tilende ꞌdeni zi Abarayama kɔzɔ a nime te tine, na bo kari ëꞌbënï ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mï kada kɔtɔ mo nima na Abarayama kuwö dɔ Bɔkoꞌba, bo kogba kole abo Yisamele kilele kpaki ti bɔtɔni ame ga pili mï liŋɔ abo ne ti atɔli ma köyö mï liŋɔ abo ga pili ti ma bo kugö ti yamo abo naga. ");
INSERT INTO bex_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Mï kada nima kilele Abarayama ne kɔmɔ kɔɔ abo ëdï ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë sowɔ döömu dɔmosowɔ (99). ");
INSERT INTO bex_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Tine kɔmɔ kɔɔ ꞌba kole abo Yisamele ëdï ꞌdeni ꞌbutë dɔɔmota. ");
INSERT INTO bex_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Mï kada kɔtɔ nima na kilele Abarayama ni kpaki ti kole abo Yisamele pili ");
INSERT INTO bex_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ti atɔli ma köyö mï liŋɔ abo ga kpaki ti ame ga bo kugö ti yamo di zi bɔ löwö ne. ");
INSERT INTO bex_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Bɔkoꞌba ileme rönï zi Abarayama di ŋgila ŋgërï koro ꞌba Mamore koꞌja Abarayama këdï koloma kpadörï ꞌba rö kilaka abo ꞌdeni mï zana kada ma kata. ");
INSERT INTO bex_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Bo ombi kɔmɔ bo koꞌja bilaka mota këdï kɔrɔ yayi. Kina ɔdɔ bo koꞌja lïjë ꞌdeni tara tine, na bo kiriŋa ŋgï kurë dönnï, bo kudë dɔ bo bërï mëmë bo kosa yayi. ");
INSERT INTO bex_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Bo iya te, “Ŋere ma ga, momaꞌjo rɔma ziye kinza kitelike dë di dɔliŋɔ ma. Ma na me bine toja laja ziye. ");
INSERT INTO bex_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Iꞌdike moꞌde mini kurögöke ndïye timo, kindawoke rɔye mbowa bïcï ŋgërï nime bine ");
INSERT INTO bex_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ꞌdɔ moma akonyo ɔtɔ ga ziye konyoke. Di pötö mo tine ti karike eꞌbe ꞌjaa nduwë dɔ liŋgere ꞌbe, kɔzɔ ame kutïke ꞌdeni tako toŋgɔ ma bɔ laja ꞌbe ne, iꞌdike moja laja ziye.” Na ya naga nima kiya te, “Ele, oꞌdɔ kɔzɔ ma kiya.” ");
INSERT INTO bex_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kina Abarayama köpu welo kari rö zi Sara ꞌdë yayi, iya te, “Ogba sapiya welo kiyari ruzu ma kele koŋma rɔ maŋgolɔꞌbɔ.” ");
INSERT INTO bex_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kina bo kiriŋa kari mï jɔlɔ kope kole sa ma kɔnɔ laka, kiꞌdi zi bɔ laja koꞌdɔ welo. ");
INSERT INTO bex_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kina bo kogba wï ma kërï gbï ti ma kara ti yida mo tönë koꞌde kutë kɔmɔ ya naga nima. Kina bo koloma ŋgï rɔ toja laja zïnnï di bïcï ŋgërï nima yayi, lïjë konyo kpënnï. ");
INSERT INTO bex_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Lïjë ititi bo, iya te, “ꞌJa ꞌbï Sara ëdï yala?” Bo iya te, “Lɔko ëdï rö bine.” ");
INSERT INTO bex_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Bɔ ma kɔtɔ di mï löŋgö ya naga nima, iya te, “Mëdï mileki mako kabate ti kɔɔ, kina ꞌja ꞌbï Sara ti köyö kole ŋgï.” Sara ëdï kpadörï kebe gɔ bo yayi këdï kuwö lende nime. ");
INSERT INTO bex_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abarayama ni kpaki rïyö ti Sara öndë ꞌdeni gɔmo kɔwɔ. Kina Sara inza gbï kpe ti a dɔ ꞌja. ");
INSERT INTO bex_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Gɔ köꞌdu mo na lɔko kögö, kiya te, “Ze ame döndë ꞌdeni rɔ korɔꞌbɔ kɔzɔ a nime te kpaki rïyö ti mëꞌdë ma ne, ti mebe ꞌböwu toꞌdɔkɔ töꞌdö ti mëꞌdë?” ");
INSERT INTO bex_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kina Bɔkoꞌba nima kititi Abarayama, iya te, “Gɔ waꞌdi na Sara kögö kiya te, ‘Ti möyö kole ŋgï koꞌja möndë ama ꞌdeni?’ ");
INSERT INTO bex_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","A mɔtɔ ëdï ma toꞌdɔ mo konya dɔ Bɔkoꞌba? Kɔzɔ kada ame mose köꞌdu mo ne, mëdï mileki mï kpa dökïkërï, kina Sara ti kɔmɔ kole ŋgï.” ");
INSERT INTO bex_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tine Sara ꞌdeni rɔ tikere, na lɔko kandi gɔmo, iya te, “Mögö dë.” Bo iya te, “Inza tara, ögö ko rɔ ma laka.” ");
INSERT INTO bex_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ya naga nima ënyï di yayi kuyï kömönnï kari dɔ Sodomo. Kina Abarayama kari tïnnï koto gönnï gɔ kɔri. ");
INSERT INTO bex_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Bɔkoꞌba iya ti mï bo, iya te, “Minza musu dɔ wa ma mëdï mari toꞌdɔ mo nime di zi Abarayama. ");
INSERT INTO bex_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kupö bo ga na ti këdï rɔ bɔ tigɔ gbï rɔ ma dɔ kiteli. Kina ti bo na ti koꞌdɔ yëyï ma laka zi bilaka pili. ");
INSERT INTO bex_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Bo na rɔ bɔ ame migeli ꞌdeni ꞌdɔ bo kiꞌdi kole abo ga kpaki ti kupö bo ga kuwö dɔma gɔ lïjë koꞌdɔ wa ma kodɔrɔ ame rɔ ma laka ne. Kina ɔdɔ lïjë koꞌdɔ ꞌdeni tine ti moꞌdɔ wa ame ga mulömu ꞌdɔ toꞌdɔ mo zi Abarayama ne ŋgï.” ");
INSERT INTO bex_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kina bo kiya zi Abarayama, iya te, “Lëbï ꞌba lende kënyë ꞌba Sodomo ni ma ti Gomora udu ꞌdeni kömö mbili ma. Lende kënyë ꞌbënnï ꞌdeni ŋgï rɔ dɔ kiteli. ");
INSERT INTO bex_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mëdï mari toŋgɔ mo, ɔdɔ ëdï ŋgï kɔzɔ lëbï mo ame muwö ne tara ya. Ne ɔdɔ kinza tara ti mikali gbï.” ");
INSERT INTO bex_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kina ya ma rïyö kënyï ŋgï nduwë kari kapa yɔki Sodomo, tine Bɔkoꞌba ileke ꞌba bo ti Abarayama yayi. ");
INSERT INTO bex_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kina Abarayama kese ŋgɔsi ŋgila Bɔkoꞌba kititi, kiya te, “Ti kote dɔ bɔ lende laka gbï yaga kɔtɔ ti bɔ lende kënyë? ");
INSERT INTO bex_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ɔdɔ bɔ lende laka këdï kuluku kɔtɔ mï gawo nima, ti kote dɔmo gbï yaga? Ti kɔmɔ gawo nima dë gɔ köꞌdu ꞌba bilaka kuluku kɔtɔ naga nima yïmo yayi ne? ");
INSERT INTO bex_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Rɔ ma laka mikali inza kote dɔ bɔ lende laka pili yaga kɔtɔ ti bɔ lende kënyë. Toꞌdɔ mo tara inza kari du te laka. Ɔdɔ koꞌdɔ kɔzɔ a nima tara ëddï kodɔ gomɔ dɔ bɔ lende laka kpaki ti bɔ lende kënyë. Toꞌdɔ mo tara inza du te rɔ ma laka. Nï bɔ koꞌdɔ burë ꞌba dɔyayi pili na rɔ bɔ koꞌdɔ wa ma kodɔrɔ.” ");
INSERT INTO bex_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Bɔkoꞌba iya te, “Ɔdɔ moꞌja bɔ lende laka këdï kuluku kɔtɔ mï Sodomo yayi, mëdï mɔmɔ gawo nima pili gɔ köꞌdu ꞌbënnï.” ");
INSERT INTO bex_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abarayama ileki ꞌböwu kiya zi Bɔkoꞌba, iya te, “Momaꞌjo rɔma zïyï Bɔkoꞌba ola ma gɔ tilende zïyï rɔ dɔ kïtëwu. Minza rɔ ɔtɔ, ma ŋgï rɔ lupu ni ma ti buruku. ");
INSERT INTO bex_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ne ɔdɔ ma muyï konye rönnï yaga di kɔmɔ bɔ lende laka naga nima, ti kote dɔ gawo nima pili yaga gɔ köꞌdu ꞌba ya ma muyï naga nima kinza kpe teyi ne?” Bo iya te, “Ɔdɔ moꞌja bɔ lende laka yayi ꞌbutë sowɔ döömu, minza mote dɔmo.” ");
INSERT INTO bex_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abarayama ititi ꞌböwu, iya te, “Ne ɔdɔ koꞌja bɔ lende laka ŋge ꞌbutë sowɔ yayi?” Bo iya te, “Ɔdɔ bɔ lende laka këdï yayi ꞌbutë sowɔ, minza mote dɔmo.” ");
INSERT INTO bex_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abarayama iya te, “Bɔkoꞌba, momaꞌjo rɔma zïyï, kinza kënyï dë rɔ ꞌdïrï tö, iꞌdi milende gbï. Ne ɔdɔ koꞌja ŋge ꞌbutë mota?” Bo iya te, “Ɔdɔ moꞌja bɔ lende laka ꞌbutë mota yayi minza moꞌdɔ.” ");
INSERT INTO bex_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abarayama iya te, “Bɔkoꞌba, momaꞌjo rɔma zïyï, ola ma gɔ tilende zïyï rɔ dɔ kïtëwu. Ne ɔdɔ koꞌja këdï ŋge ꞌbutë rïyö yayi?” Bo iya te, “Minza mote dɔ gawo nima ɔdɔ ma ꞌbutë rïyö këdï yayi.” ");
INSERT INTO bex_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abarayama iya te, “Bɔkoꞌba, kinza kënyï dë rɔ ꞌdïrï tö, iꞌdi ma milende ŋge mï kɔtɔ na ti. Ne ɔdɔ koꞌja ŋge ꞌbutë?” Bo iya te, “Minza mote dɔmo ɔdɔ këdï ŋge ꞌbutë.” ");
INSERT INTO bex_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Di pötö bo kote tilende ꞌdeni ti Abarayama na Bɔkoꞌba kari abo ŋgï tine na Abarayama kileki ŋgï liŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Malayika rïyö naga nima ari kömö Sodomo rɔ mï dɔkɔpiyari, koꞌja Lɔtɔ këdï koloma kpa reki yayi. Kina ɔdɔ bo koꞌja lïjë ꞌdeni tara tine na bo kënyï ŋgï kurë dönnï kudë dɔ bo bërï kömönnï. ");
INSERT INTO bex_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Bo iya te, “Ŋere ma ga, ma na me bine ꞌdɔ toja laja ziye. Momaꞌjo rɔma ziye akoke liŋɔ ma gɔ kurögöke ndïye köꞌdöke, mɔlo ŋbɔ tine ti karike eꞌbe ꞌjaa.” Lïjë iya te, “Inza tara, dëdï döꞌdö eze yaga bi kɔpɔ nime bine.” ");
INSERT INTO bex_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tine bo oloma toꞌdɔ atiri gönnï rɔ gögö na lïjë kari ŋgï gbɔ liŋɔ abo. Bo iꞌdi koŋma maŋgolɔꞌbɔ koꞌdɔ akonyo ma koŋmi zi ya naga nima konyo kpënnï. ");
INSERT INTO bex_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tine gba kota kinza lïjë köꞌdö bërï na bɔtɔni ꞌba mï gawo nima kotɔtɔ rönnï ŋgï pili yayi, yɔbi kpaki ti bulöbu mo ga otɔtɔ rönnï ŋgï me kuru dɔ rö nima toko teyi. ");
INSERT INTO bex_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kina lïjë kïdëkï Lɔtɔ kititi, iya te, “Bilaka naga nime kako mï dɔkɔpiyari nime liŋɔ ꞌbï bine ne lïjë ëdï yala? Oja lïjë yaga zize dayi gɔ döꞌdö tïnnï.” ");
INSERT INTO bex_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lɔtɔ ɔdɔ kari zïnnï yaga yayi, kurögö kpadörï teyi ti gönï, ");
INSERT INTO bex_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","kilende zïnnï, iya te, “Löndö ma ga, momaꞌjo rɔma ziye, kinza koꞌdɔke lende ma kënyë ma tara ga dë. ");
INSERT INTO bex_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mëdï ti yïtötï rïyö bine ame lïjë gba kikali a mɔtɔ rɔ bɔtɔni dë, iꞌdike moja lïjë ziye bine koꞌdɔke ɔtɔ nima mïye ne zïnnï. Ne kinza koꞌdɔke a mɔtɔ dë zi ya naga nime, römöyï lïjë ako ꞌdeni rɔ ŋba mï gɔ bi ꞌba loma ma.” ");
INSERT INTO bex_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tine lïjë iya te, “Ese yaga di kɔmɔze, nï bɔ löwö nime, nï yë na ꞌdɔ kebe tiꞌdi lende zize? Dëdï doꞌdɔ wa kënyë tɔne zïyï kebe ma doꞌdɔkɔ ꞌdɔ toꞌdɔ mo zïnnï.” Kina lïjë kiꞌdi tïtïŋï Lɔtɔ ŋgï rɔ ma kënyë, lïjë kese ꞌdeni ꞌdɔ todowe kpadörï. ");
INSERT INTO bex_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tine na ŋba naga nima koja közïnnï ŋgï gɔ Lɔtɔ kotɔ kileki rö, kurögö kpadörï teyi. ");
INSERT INTO bex_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kina ŋba tönë ga kïyölu kɔmɔ bilaka naga nima gɔ kpadörï yayi ne ŋgï pili yaga kinza lïjë koꞌja kpadörï nima ra gbï. ");
INSERT INTO bex_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ŋba naga nima ititi Lɔtɔ, iya te, “Ëddï ti bilaka ꞌbï mɔtɔ ga bine? Ɔdɔ bɔ lanzo yï ga ti kole ꞌbï ga ti yïtötï ꞌbï ga ti ma wado ꞌbï ga këdï mï gawo nime bine, otɔtɔ lïjë koja yaga, ");
INSERT INTO bex_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","römöyï dëdï doꞌdɔkɔ tote dɔ gɔ bi nime yaga. Lëbï ꞌba lende kënyë mbëmbë ꞌba bilaka ꞌba gɔ bi nime ömö ꞌdeni zi Bɔkoꞌba, kina me koja ze ꞌdeni tote dɔ gɔ bi nime.” ");
INSERT INTO bex_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lɔtɔ ënyï kari zi bɔ lanzo bo ga ame këdï koꞌdɔkɔ togbe yïtötï abo ga ne, iya te, “Ënyï kɔdɔke yaga welo di mï gɔ bi nime, Bɔkoꞌba oꞌdɔkɔ ꞌdeni tote dɔ gawo nime.” Tine lïjë iya te bo ëdï ka kïndëndë dönnï. ");
INSERT INTO bex_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mï kano bi ꞌdeni tine malayika naga nima iya te, “Lɔtɔ, ënyï welo kogba ꞌja ꞌbï ni ti yïtötï rïyö ꞌbï naga nime kɔdɔke yaga di bine, kinza kote dɔye ra kɔtɔ mï karama nime këdï kodɔ dɔ gawo nime ne.” ");
INSERT INTO bex_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tine Lɔtɔ ëdï gba kicayi kina malayika naga nima kindaꞌba közï bo ti ꞌja abo kpaki ti yïtötï abo ga koja yaga di mï gawo nima, römöyï Bɔkoꞌba ti mï këyï rɔ mbëmbë rɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kina ɔdɔ malayika koja lïjë ꞌdeni gɔ kɔri tine, bɔ ma kɔtɔ iya te, “Iriŋake tɔmɔ dïdï ye. Kinza koŋgɔke bi dë kileki yïꞌböwu kina kinza kɔrɔke dë gbï mï bi kïlëdë bine. Iriŋake ŋbö dɔ döku tɔmɔ rɔye kinza kote dɔye.” ");
INSERT INTO bex_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lɔtɔ iya te, “Inza tara, ŋere ma ga, ");
INSERT INTO bex_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","oꞌdɔke ma ꞌdeni kele kulöwö kɔmɔke dïdï ma. Dɔ döku nima ɔwɔ kënyë, tölë löbu nime ëdï kuru dɔma kupö ma gba kota kinza mömö yayi. ");
INSERT INTO bex_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ma laka mo gawo titi nime na ŋɔli ꞌdɔ tiriŋa teyi, iꞌdi ma miriŋa yayi, kɔzɔ ame koŋgɔ bo ka ŋgï rɔ gɔ bi ma titiyi kina ti mɔmɔ ŋgï yayi.” ");
INSERT INTO bex_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malayika iya te, “Ele, mutï ꞌdeni gɔ lende kiya ꞌbï, minza mote dɔ bi nima kpe yaga. ");
INSERT INTO bex_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Oꞌdɔ röyï welo kiriŋa yayi, minza moꞌdɔ a mɔtɔ titi gba kota kinza kömö yayi.” Gɔ köꞌdu nima Lɔtɔ kiya te bi nima ŋge titiyi ne, na kiꞌdi kïdëkï möyï mo ŋgï rɔ Zora, ame kiya te “Titi.” ");
INSERT INTO bex_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lɔtɔ ari kömö yayi ꞌdeni ti kada këdï kiꞌdi kpënï. ");
INSERT INTO bex_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kina Bɔkoꞌba kodɔ paꞌdo ŋgï ti kulugbï döku ma këdï kilaŋma kako di mïtɔrɔ dɔ gawo ꞌba Sodomo ni ti Gomora. ");
INSERT INTO bex_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kina kote dɔ gawo naga nima ŋgï pili yaga kpaki ti bi kïlëdë mo pili ti bilaka mo ga ti wa ame ga kötu mï gɔ bi nima yayi. ");
INSERT INTO bex_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tine ꞌja ꞌba Lɔtɔ uyï kömönï kileki yïꞌböwu na lɔko kɔrɔ ŋgï kïyï yayi rɔ döku ꞌba mëlö. ");
INSERT INTO bex_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mɔlo mï dɔŋbɔ mo nima na Abarayama kënyï kari gɔ bi tönë bo kɔrɔ pa kɔmɔ Bɔkoꞌba di teyi ne. ");
INSERT INTO bex_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Bo oŋgɔ bi kari dɔ Sodomo ni ti Gomora ti dɔyayi pili ma mï bi kïlëdë nima, tine bo oꞌja kötu na ŋgï këdï kanyo gulïyï di dɔyayi nima yayi kɔzɔ kötu ꞌba lïndï tara. ");
INSERT INTO bex_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mï kada nima Bɔkoꞌba këdï kote dɔ gawo ꞌba mï bi kïlëdë naga nima Lɔtɔ koloma teyi ne, bo iꞌdi akititi ꞌba Abarayama tönë dë du te kudölu di dɔ bo. Bo oja Lɔtɔ ŋgï yaga di mï tölë löbu nima. ");
INSERT INTO bex_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lɔtɔ rɔ tikere di bi toloma mï Zora, kina bo kënyï ŋgï yaga di yayi ti yïtötï rïyö abo naga nima kari koloma mï tïꞌbörö ꞌba döku. ");
INSERT INTO bex_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tine na nyiti ma löbu mo kënyï kiya zi lëmï nï ma titi, iya te, “ꞌBu ze na me köndë ꞌdeni. Kina me bɔtɔni ɔtɔ inza gbï mï dɔyayi nime bine yɔ ꞌdɔ kogbe ze kɔzɔ dölëtï ꞌba bilaka lesi pili. ");
INSERT INTO bex_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ako diꞌdi ꞌbu ze kuwë layi gɔ döꞌdö tïnï ꞌdɔ döyö kole ti bo.” ");
INSERT INTO bex_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mï korɔndɔ nima na lïjë kiꞌdi bo kuwë layi, na nyiti ma löbu mo kari köꞌdö ti bo. Tine layi upö bo ꞌdeni ŋgï iꞌdi bo ikali gɔmo dë. ");
INSERT INTO bex_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mï bi këzë ma di gɔmo na, nyiti ma löbu mo tönë kako kiya zi lëmï nï ma titi, iya te, “Möꞌdö ti ꞌbu ze ti korɔndɔ ene, ako diꞌdi bo gbï kuwë layi tɔne gɔ kari köꞌdö tïnï ꞌdɔ döyö kole ti bo.” ");
INSERT INTO bex_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kina lïjë kiꞌdi bo kuwë layi gbï mï korɔndɔ ama, na nyiti ma titi mo kari köꞌdö ŋgï ti bo, tine layi upö bo ꞌdeni gbï iꞌdi bo ikali gɔmo dë. ");
INSERT INTO bex_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Wa nime na kiꞌdi yïtötï ꞌba Lɔtɔ ga kɔmɔ kpaki rïyö köyö kole ti bo. ");
INSERT INTO bex_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nyiti ma löbu mo öyö kole bɔtɔni kiꞌdi möyï mo rɔ Mowaba, bo na rɔ yï lïŋgï ꞌba bilaka naga nima kïdëkï rɔ Mowaba ame ga leꞌjete ne. ");
INSERT INTO bex_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nyiti ma titi mo öyö gbï rɔ kole bɔtɔni, na lɔko kiꞌdi möyï mo rɔ Benami. Bo na rɔ yï lïŋgï ꞌba bilaka naga nima kïdëkï rɔ Amona ame ga leꞌjete ne. ");
INSERT INTO bex_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abarayama ënyï di Mamore yayi kolɔlɔ kari kapa dɔ roꞌɔ. Kina bo kari koloma mï löŋgö Kadesa ni ti Surö. Koꞌja bo koloma ꞌdeni mï Gerara yayi tine ");
INSERT INTO bex_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","na bo kiya te ꞌja abo Sara nima lëmï bo na. Gɔ köꞌdu mo na Abimeleke ŋere ꞌba Gerara koja laja gɔ Sara kogba koto kari liŋɔ abo rɔ ꞌja zi bo. ");
INSERT INTO bex_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mï korɔndɔ ma dɔ kɔtɔ mɔtɔ na Bɔkoꞌba kiꞌdi nyï koꞌde dɔ Abimeleke, iya te, “Ëddï kölë, ꞌja nima kogba ne lɔko ꞌja ꞌba bɔ mɔtɔ na.” ");
INSERT INTO bex_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tine Abimeleke osa rɔ Sara dë gba, na bo kileki kiya zi Bɔkoꞌba, iya te, “Bɔkoꞌba, ti kupö ma ŋgï ti bilaka ma ga kinza ma mirasi lende ɔtɔ? ");
INSERT INTO bex_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abarayama na kiya te ꞌja nime lëmï bo na. Kina lɔko iya gbï te bɔ nima löndö nï na. Dökïꞌdï ma ti közö rɔ ma kɔpɔ di mï lende nime moꞌdɔ ne. Inza du te rɔ lende kirasi zö.” ");
INSERT INTO bex_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kina Bɔkoꞌba kilende zi bo di mï nyï nima, iya te, “Mikali ꞌdeni dökïꞌdï yï rɔ ma kɔpɔ di mï lende nima. Gɔ köꞌdu mo na ma mota yi di bi tirasi lende zö kiꞌdi kosa rɔ ꞌja nima dë ne. ");
INSERT INTO bex_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ileki lɔko kari zi mëꞌdë nï. Bo bɔ kumë lende ma na kina bo ti kititi ma ŋgï göyï ꞌdɔ kɔmɔ. Ne ɔdɔ kileki lɔko dë rɔ ma laka ëddï kölë pili ti bilaka ꞌbï ga.” ");
INSERT INTO bex_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mɔlo mï dɔŋbɔ mo na Abimeleke kïdëkï bɔ laja abo ga kïyëtï gɔ köꞌdu nime teyi. Kina lïjë ŋgï pili rɔ tikere. ");
INSERT INTO bex_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleke ïdëkï Abarayama kititi, iya te, “Waꞌdi na me koꞌdɔ zize te ne? Wali kënyë waꞌdi na moꞌdɔ zïyï kiꞌdi koꞌde tölë löbu nime dɔma kpaki ti bilaka ꞌba dɔliŋɔ ma nime? Wa nime koꞌdɔ zö ne bɔtɔ mɔtɔ ame ŋgï gɔ koꞌdɔ lende ma tara inza du te.” ");
INSERT INTO bex_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleke ititi Abarayama, iya te, “Waꞌdi na komeri kiꞌdi koꞌdɔ lende nime zö te?” ");
INSERT INTO bex_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abarayama iya te, “Moꞌdɔ tara römöyï momeri ꞌbama miya te bilaka ꞌba mï dɔyayi nime ere Bɔkoꞌba dë kina mɔtɔga lïjë ti kupö ma ŋgï ꞌdɔ lïjë kogba ꞌja ma. ");
INSERT INTO bex_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ne rɔ ma laka lɔko ŋgï rɔ lëmï ma, nyiti ꞌba baba tine mönï na ꞌberi kina me mogbe lɔko rɔ ꞌja ma. ");
INSERT INTO bex_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Gɔ köꞌdu mo na mï kada ma Bɔkoꞌba koja ma yaga di mï liŋɔ ꞌba ꞌbu ma tari tulë mï dɔyayi löwö ne na miya zïnï, miya te, ‘Akɔꞌɔ ma ꞌdɔ kileme zö na me. Mï gɔ bi pili ame ga dömö teyi iya zi bilaka mo ga te ma löndö yï na.’” ");
INSERT INTO bex_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kina Abimeleke kileki Sara ŋgï zi Abarayama kogba kamölö ni ti sa ti atɔli kiꞌdi zi bo. ");
INSERT INTO bex_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleke iya te, “Dɔyayi ma na me pili kömöyï. Oloma kapa ma koꞌdɔkɔ.” ");
INSERT INTO bex_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Bo ileki kiya zi Sara, iya te, “Oŋgɔ, miꞌdi yamo ꞌdeni kuluku ꞌbutë rïyö (1,000) zi löndö yï ꞌdɔ kileme yi rɔ ma kɔpɔ kɔmɔ bilaka naga nime pili. Bilaka pili ti kikali ŋgï irasi lende ɔtɔ dë du te.” ");
INSERT INTO bex_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abarayama ititi Bɔkoꞌba gɔ Abimeleke na Bɔkoꞌba kileŋo Abimeleke ŋgï pili ti ꞌja mo ga kpaki ti yïtötï ma rɔ atɔli abo ga, ");
INSERT INTO bex_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","römöyï Bɔkoꞌba ɔrɔ ꞌja liŋɔ ꞌba Abimeleke ꞌdeni pa me kinza köyö kole gɔ köꞌdu nima bo kogba Sara ꞌja ꞌba Abarayama ne. ");
INSERT INTO bex_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Bɔkoꞌba oꞌdɔ yëyï zi Sara kɔzɔ ame bo kiꞌdi köꞌdu mo tara. ");
INSERT INTO bex_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kina lɔko kɔmɔ köyö kole zi Abarayama mï töndë abo nima mï kada ma Bɔkoꞌba kose gɔmo zi bo tönë. ");
INSERT INTO bex_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abarayama ïdëkï möyï kole nima Sara köyö zi bo ne rɔ Yisika. ");
INSERT INTO bex_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kina bo kilele kole abo Yisika mï töꞌdö dɔ modɔɔmota kɔzɔ ma Bɔkoꞌba kose gɔmo zi bo tara. ");
INSERT INTO bex_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Kɔmɔ kɔɔ ꞌba Abarayama ꞌdeni kuluku rïyö (100) mï kada nima köyö Yisika ne. ");
INSERT INTO bex_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara iya te, “Bɔkoꞌba iꞌdi ma ꞌdeni tögö rɔ lɔŋɔ. Bɔtɔ ame pili kuwö lende nime ti kögö gbï kɔtɔ tö.” ");
INSERT INTO bex_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Lɔko iya te, “Yë na ti kiya ꞌböwu te zi Abarayama, Sara ti kiꞌdi mba kpa kole yɔ? Kina me möyö kole ꞌdeni zi bo mï töndë abo nime.” ");
INSERT INTO bex_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kina ɔdɔ kole kïyöbu ꞌdeni tine na Abarayama koꞌdɔ karama ma löbu ŋgï mï kada ꞌba tola gɔ mba ꞌba kole. ");
INSERT INTO bex_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Sara ari koꞌja Yisamele kole ame Agara yïtö ꞌba Ezipeto köyö zi Abarayama ne këdï koꞌdɔ dede rɔ kole ꞌbënï Yisika. Kina lɔko kiya zi Abarayama, iya te, “Oga ꞌja atɔli nime yaga ti kole ꞌbënï nime. Kole ꞌbënï nime inza koloma rɔ bɔ dɔ apötö yï kɔtɔ ti kole ma Yisika.” ");
INSERT INTO bex_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kina Abarayama ŋgï rɔ meri gɔ lende ꞌba kole abo Yisamele. ");
INSERT INTO bex_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tine Bɔkoꞌba iya zi bo, iya te, “Kinza koloma dë rɔ meri gɔ lende ꞌba kole ꞌbï ti ꞌja atɔli ꞌbï nime. Oꞌdɔ wa ame ga Sara kiya zïyï ne, römöyï Yisika na këdï koja dɔ kupö yï. ");
INSERT INTO bex_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kina ti miꞌdi kupö kole ꞌba ꞌja atɔli nima gbï kara rɔ dɔꞌbe ma löbu römöyï bo kole ꞌbï na gbï.” ");
INSERT INTO bex_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kina Abarayama kënyï mɔlo mï dɔŋbɔ kogba kilaka ꞌba mini ti maŋgolɔꞌbɔ kiꞌdi zi Agara kowe dɔkɔnyɔ mo koga kari bitɔ ga yayi ti kole nima gɔmo. Kina lɔko kari ŋgï tilaki kebe mï mökö ꞌba Berasaba. ");
INSERT INTO bex_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kina ɔdɔ mini ꞌba mï kilaka nima kote rönï ꞌdeni tine, na lɔko kola kole tönë ŋgï yï ꞌjöwu mɔtɔ yayi. ");
INSERT INTO bex_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kina lɔko kënyï di dɔmo kari koloma caki rɔ ma kɔwɔ kɔzɔ bi ꞌba toꞌbe kɔmo naga tara, römöyï lɔko iya te, “Moꞌdɔkɔ dë ꞌdɔ moŋgɔ kole ma këdï kölë di kɔmɔ ma.” Koꞌja lɔko koloma ꞌdeni caki yayi na lɔko kebe tudu. ");
INSERT INTO bex_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Bɔkoꞌba uwö kole nima këdï kudu na malayika ꞌba Bɔkoꞌba kilende zi Agara di mïtɔrɔ, iya te, “Agara, gɔ waꞌdi? Kinza kere dë. Bɔkoꞌba uwö dɔ kole nima ꞌdeni di gɔ bi ma bo këdï teyi. ");
INSERT INTO bex_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ënyï kari kindaꞌba közï bo tɔrɔ. Mëdï miꞌdi dɔꞌbe ma löbu kɔdɔ di mï bo.” ");
INSERT INTO bex_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kina Bɔkoꞌba kiyɔpɔ kɔmɔ Agara kiꞌdi lɔko koꞌja daa ꞌba mini, kina lɔko kari kunö mini mï kilaka tönë kiꞌdi zi kole nima kuwë. ");
INSERT INTO bex_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Bɔkoꞌba oloma laka ti kole tönë ŋbö kïyöbu. Bo oloma mï mökö kutu rɔ bo rɔ bɔ koꞌbe kanya közï kikaka. Mï mökö ꞌba Parana na bo koloma teyi. ");
INSERT INTO bex_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ma bo ari kogbe ꞌja zi bo di mï yïtötï ꞌba Ezipeto. ");
INSERT INTO bex_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mï kada nima na Abimeleke ni ti Pikolo bɔ dɔ bɔ kanya abo kako kiya zi Abarayama, iya te, “Bɔkoꞌba ëdï nduwë tïyï mï wa ame ga pili këddï koꞌdɔ ne. ");
INSERT INTO bex_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kina me ulömu röyï zö kɔmɔ Bɔkoꞌba bine kinza koꞌdɔ ꞌbölu mɔtɔ dë zö ala zi kole ma ga. Moloma dɔ mï kɔtɔ tïyï kina me gbï ꞌdɔ koloma dɔ mï kɔtɔ tö pili ti bilaka ꞌba dɔyayi nime këddï koloma yïmo ne.” ");
INSERT INTO bex_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abarayama iya te, “Mëdï mulömu rɔma.” ");
INSERT INTO bex_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kina Abarayama kënyï konyɔ köꞌdu ꞌba daa mɔtɔ bɔ laja ꞌba Abimeleke ga kolɔ ꞌdeni di zi bo. ");
INSERT INTO bex_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tine Abimeleke iya te, “Mikali bɔ koꞌdɔ wa naga nime dë. Iya lende mo dë gbï zö yɔ, tuwö mo na ꞌjaa me tɔne zö.” ");
INSERT INTO bex_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kina Abarayama kiꞌdi kamölö ni ti sa zi Abimeleke, kina lïjë kpaki rïyö koꞌdɔ pɔri ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abarayama oza rokɔ kamölö modɔmorïyö ꞌberi yaga di mï dɔtumu yërï abo ga. ");
INSERT INTO bex_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleke iya te, “ꞌJɔ ꞌba rokɔ kamölö modɔmorïyö naga nime koza yaga ne rɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abarayama iya te, “Rokɔ kamölö modɔmorïyö naga nime ako kogba di közö, ꞌdɔ këddï rɔ bɔ kodɔrɔ yï lende ma, ame ma na mole daa nime.” ");
INSERT INTO bex_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kina kïdëkï möyï bi nima ŋgï rɔ Berasaba, ame kiya te “Daa ꞌba lömu,” römöyï bi nima na lïjë koꞌdɔ lömu di teyi. ");
INSERT INTO bex_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kina Abimeleke ni ti Pikolo bɔ dɔ bɔ kanya abo kënyï ŋgï kileki mï dɔyayi ꞌba Pilisitiya. ");
INSERT INTO bex_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abarayama ari kïdïyë ŋgërï mɔtɔ Berasaba yayi gɔ lömu nima, bo koloma toꞌdɔ mötu zi Bɔkoꞌba ma ŋburuŋburu di ŋgila mo. ");
INSERT INTO bex_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abarayama oloma kada dɔ konzi mï dɔyayi ꞌba Pilisitiya. ");
INSERT INTO bex_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Di pötö mo ꞌdeni yayi na Bɔkoꞌba kiyɔzɔ meri ꞌba Abarayama kïdëkï kiya te, “Abarayama.” Tine Abarayama ileki dɔmo, iya te, “Ma na me.” ");
INSERT INTO bex_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Bɔkoꞌba iya te, “Ogba kole kɔtɔ ꞌbï nima rɔ Yisika kɔꞌɔ bo kulöwö ne kari timo dɔ döku ꞌba Moriya. Ari ti bo ꞌdɔ kumu bo zö yayi rɔ akumu mï gɔ bi ame mëdï mileme zïyï ne.” ");
INSERT INTO bex_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mɔlo ŋbɔ mï bi këzë ma di gɔmo na Abarayama koga ŋgërï ꞌba toŋma akumu kudödu gɔ akaca. Bo ogba Yisika ni ti bɔ koja laja rïyö ti bo. Kina lïjë kënyï ŋgï dɔmo tari gɔ bi ame Bɔkoꞌba kiya ꞌdeni zi bo ne. ");
INSERT INTO bex_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mï töꞌdö dɔ mota ꞌdeni tine na Abarayama kombi kɔmɔ bo koꞌja dɔ döku nima kinda rɔ ma kɔwɔ. ");
INSERT INTO bex_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Bo iya zi bɔ laja abo naga nima, bo iya te, “Olomake tötï ti akaca nime bine. Ze ti kole titi nime dëdï dari dɔgba toꞌdɔ mötu zi Bɔkoꞌba ti dileki ꞌjaa dako ziye bine.” ");
INSERT INTO bex_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abarayama ogba ŋgërï ꞌba toŋma akumu nima kiꞌdi dɔ kole abo Yisika, tine bo indaꞌba ꞌba bo rɔ kulu ni ti kpa kolɔlɔ paꞌdo ꞌba ꞌdɔ tulöꞌjö mo. Kina ɔdɔ lïjë këdï kari ꞌdeni tara tine, ");
INSERT INTO bex_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisika iya te, “Baba.” Abarayama iya te, “Tondo ya, kole ma?” Yisika ititi, iya te, “Moꞌja paꞌdo ëdï bine ti ŋgërï, ne yida ꞌba tumu mo ëdï yala?” ");
INSERT INTO bex_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abarayama iya te, “Kole ma, Bɔkoꞌba ti koja gɔmo zize.” Kina Abarayama ni kari ŋgï nduwë ti Yisika. ");
INSERT INTO bex_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kina ɔdɔ lïjë kari kömö ꞌdeni dɔ gɔ bi nima Bɔkoꞌba kiya zi bo ne tine na Abarayama koꞌba bi ꞌba akumu kiyija kpa ŋgërï mo ga dɔmo. Kina bo kudödu Yisika ŋgï kuꞌdu dɔ kpa ŋgërï ꞌba akumu nima. ");
INSERT INTO bex_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abarayama ombi közï bo ꞌdɔ tumu kole abo, ");
INSERT INTO bex_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","tine na malayika ꞌba Bɔkoꞌba kïdëkï bo di mïtɔrɔ, iya te, “Abarayama, Abarayama.” Bo iya te, “Ma na me.” ");
INSERT INTO bex_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malayika nima iya te, “Kinza kosa közïyï dë rɔ kole titi nima. Kinza koꞌdɔ wa ma kɔtɔ mɔtɔ dë zi bo, römöyï mikali ꞌdeni ŋgï oro Bɔkoꞌba. Ame moꞌja ꞌdeni kilagi dë di bi tumu kole kɔtɔ ꞌbï nime zö ne.” ");
INSERT INTO bex_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abarayama oŋgɔ bi kileki gɔ bo na bo koꞌja kamölö ꞌdeni kazo mo kilaka mï morogo yayi. Kina bo kari kogba kamölö nima ŋgï koŋma rɔ akumu gɔ bi ꞌba kole abo Yisika. ");
INSERT INTO bex_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abarayama ïdëkï möyï gɔ bi nima rɔ “Bɔkoꞌba ti koja gɔmo.” Kina me nduwë kömö mï kada nime tɔne, bilaka këdï kiya te, “Di dɔ döku ꞌba Bɔkoꞌba bo ti koja gɔmo.” ");
INSERT INTO bex_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kina malayika ꞌba Bɔkoꞌba kïdëkï Abarayama ꞌböwu di mïtɔrɔ, ");
INSERT INTO bex_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","iya te, “Wa nime koꞌdɔ ꞌdeni ame koꞌjɔŋɔ kole kɔtɔ ꞌbï nime dë di zö ne, gɔ köꞌdu mo mulömu rɔma ti möyï ma Bɔkoꞌba ");
INSERT INTO bex_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mëdï moꞌdɔ yëyï zïyï kupö yï ga konzi kɔzɔ këlu ꞌba mïtɔrɔ kina gbï kɔzɔ yayi lida ꞌba kpa mini löbu. Kupö yï ga ti kaꞌda bɔ ya ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kina ti kupö yï ga na ti koꞌdɔ yëyï zi bilaka ma konzi ꞌba dɔyayi nime pili, römöyï uwö dɔma ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abarayama ileki kari zi bɔ laja abo naga nima, kina lïjë kënyï di yayi bo kari koloma Berasaba. ");
INSERT INTO bex_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Di pötö lende naga nime na Abarayama kuwö lende mo, iya te, “Mileka öyö kole ꞌdeni gbï ti löndö yï Nawura. ");
INSERT INTO bex_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Lïjë na rɔ Uzu kole ma dɔgba ti bɔ löndö bo Buzu, ti Kemuwele ꞌbu ꞌba Arama ");
INSERT INTO bex_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ti Kesede ti Azo ti Pilidasi ti Jidalapa ti Betowele.” ");
INSERT INTO bex_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betowele na köyö Rebeka. Kole modɔɔmota naga nime Mileka ni na köyö ti Nawura löndö ꞌba Abarayama. ");
INSERT INTO bex_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Tine ꞌja ꞌba Nawura mɔtɔ ame kïdëkï möyï mo rɔ Rewoma ne na köyö ꞌbënï Teba ni ti Gama ti Takasa ti Maka. ");
INSERT INTO bex_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara oloma koꞌdɔ kɔmɔ kɔɔ kuluku rïyö kɔdɔ dɔmo ꞌbutë rïyö döömu dɔmorïyö (127) tine ");
INSERT INTO bex_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","na lɔko kölë ŋgï di mï Eborona mï dɔyayi ꞌba Kanana yayi. Abarayama ari tudu ꞌja abo Sara, ");
INSERT INTO bex_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","kina bo kënyï di dɔ ŋgila töku nima yayi kari zi Ete bɔ dɔyayi naga nima, kiya te, ");
INSERT INTO bex_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ma na me rɔ bɔ löwö mëdï moloma mï löŋgö ye bine, iꞌdike yayi mɔtɔ zö ꞌdɔ musu töku ma nime teyi.” ");
INSERT INTO bex_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ete naga nima ileki dɔmo zi Abarayama, iya te, ");
INSERT INTO bex_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Löbu ze, uwö dɔze, nï rɔ ŋere ma löbu mï löŋgö ze bine. Usu töku ꞌbï mï gö ꞌba tusu töku ame koꞌdɔkɔ ne bɔtɔ mɔtɔ inza ma ꞌdɔ kota gɔ gö ꞌba tusu töku di zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kina Abarayama kënyï kudë dɔ bo bërï kɔmɔ Ete naga nima, ");
INSERT INTO bex_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","kiya te, “Ɔdɔ kutïke ŋgï dɔmo zö ꞌdɔ musu töku ma nime bine, uwöke dɔma, ititike Eporona kole ꞌba Zora ");
INSERT INTO bex_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ꞌdɔ bo kugö tïꞌbörö ꞌba Makapela ame rɔ abo dɔ kpa nyaka abo ꞌdë yayi ne zö. Ititike bo ꞌdɔ bo kugö zö gɔ ndögö mo ma gɔ kɔmɔ bo di kɔmɔye pili bine ꞌdɔ köꞌbö rɔ ama tusu töku ma ga teyi.” ");
INSERT INTO bex_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eporona gbagba bo ëdï gbï koloma mï löŋgö Ete mɔtɔ naga nima kpa reki nima yayi. Kina bo kënyï kilende kiya rɔ ma kembe mbili bilaka kuwö pili, iya te, ");
INSERT INTO bex_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Uwö te, löbu ma, mëdï miꞌdi nyaka nime pili zïyï ti tïꞌbörö mo. Mëdï miꞌdi zïyï di kɔmɔ bilaka ma naga nime bine kusu töku ꞌbï yïmo.” ");
INSERT INTO bex_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tine Abarayama ënyï kudë dɔ bo bërï kɔmɔ bilaka bɔ dɔyayi naga nima ");
INSERT INTO bex_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","kilende rɔ ma kembe bilaka kuwö pili, kiya zi Eporona, iya te, “Momaꞌjo rɔma zïyï, uwö dɔma. Iꞌdi ma mugö nyaka nime pili rɔ tugö. Utï dɔ ndögö mo ꞌdɔ musu töku ma nime yayi.” ");
INSERT INTO bex_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eporona ileki dɔmo zi Abarayama, iya te, ");
INSERT INTO bex_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Löbu ma, uwö te. Ndögö ꞌba nyaka ŋge ti yamo kuluku sowɔ. Ama ti koꞌdɔ waꞌdi mï löŋgö ze tïyï? Usu töku ꞌbï ŋgï yïmo.” ");
INSERT INTO bex_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abarayama utï dɔmo tara na bo kiyija yamo zi Eporona kɔzɔ ame bo kiya mbili Ete naga nima pili kuwö ne tara. Yamo nima pili rɔ kïnë ame kiyari ꞌdeni mɔlo rɔ ꞌba ndögö ne. ");
INSERT INTO bex_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Wa nime na ꞌdɔ kiꞌdi nyaka ꞌba Eporona ame mï Makapela kapa Mamore ma kari yïbï ne köꞌbö rɔ wa ꞌba Abarayama. Nyaka nima ti tïꞌbörö mo kpaki ti ŋgërï mo ga ma yïmo yayi ŋbö kömö dɔ kpa nyaka. ");
INSERT INTO bex_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ete naga nima pili kpa reki yayi ne ikali rɔ nyaka ꞌba Abarayama. ");
INSERT INTO bex_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kina Abarayama kusu ꞌja abo Sara mï tïꞌbörö ꞌba tusu töku nima yayi mï dɔyayi ꞌba Kanana. ");
INSERT INTO bex_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Gɔ köꞌdu nime na ꞌdɔ kiꞌdi nyaka ꞌba Ete naga nima ti tïꞌbörö ꞌba tusu töku mo koloma ŋgï köꞌbö rɔ nyaka ꞌba Abarayama tusu töku teyi. ");
INSERT INTO bex_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Mï kada nime tine Abarayama öndë ꞌdeni gɔmo kɔwɔ. Kina Bɔkoꞌba oꞌdɔ yëyï ꞌdeni zi bo mï wa pili. ");
INSERT INTO bex_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kina bo kilende zi bɔ laja abo ma löbu mo ame rɔ bɔ dɔ wa ꞌba mï liŋɔ abo ga ne, bo iya te, “Ulömu röyï ti mbola ma, usu közïyï teyi. ");
INSERT INTO bex_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Moꞌdɔkɔ ꞌdɔ kulömu röyï ti möyï ŋere Bɔkoꞌba ꞌba mïtɔrɔ ni ma ti dɔyayi kinza kogbe ꞌja dë zi kole ma Yisika di mï yïtötï ꞌba Kanana dɔyayi nime mëdï moloma teyi ne. ");
INSERT INTO bex_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tine ileki kari mï dɔyayi ma köyö ma teyi zi wado ma ga ꞌdɔ kogbe ꞌja zi kole ma di yayi.” ");
INSERT INTO bex_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Bɔ laja nima ititi bo, iya te, “Ne ɔdɔ nyiti mo koꞌdɔkɔ dë tako tö mï dɔyayi nime bine, ꞌdɔ moja kole ꞌbï kileki kari mï dɔyayi ma kako di teyi nima?” ");
INSERT INTO bex_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abarayama iya te, “Oŋgɔ, kinza koja kole ma dë du te kileki yayi. ");
INSERT INTO bex_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ŋere Bɔkoꞌba ꞌba mïtɔrɔ ame kogba ma di mï liŋɔ ꞌba ꞌbu ma di mï dɔyayi ma köyö ma teyi ne, ilende koꞌdɔ lömu zö, iya te, ‘Mëdï miꞌdi yayi nime zi kupö yï ga.’ Kina bo ti koja malayika abo ŋgï dɔgba kömöyï, ꞌdɔ koꞌja ꞌja zi kole ma di yayi. ");
INSERT INTO bex_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ne ɔdɔ nyiti mo na koꞌdɔkɔ dë tako tïyï tine lömu nime inza kpe döyï. Tine kinza kiꞌdi kole ma dë du te kileki kari yayi.” ");
INSERT INTO bex_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kina bɔ laja nima kusu közï bo mï mbola Abarayama kulömu rɔ bo toꞌdɔ wa ma Abarayama kose gɔmo nima. ");
INSERT INTO bex_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bɔ laja nima ogba gamele ꞌba löbu abo Abarayama ga ꞌbutë gbï ti kpa közï ma kele di zi bo, kina bo kënyï di yayi kari mï gawo ame Nawura këdï koloma teyi kapa Mesopotamiya ma kari dɔ tugbu tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kina ɔdɔ bo kömö ꞌdeni yayi tine na bo kiꞌdi gamele abo ga köꞌdö bërï kpa daa nima dɔ kpa gawo nima yayi ne. Mï dɔkɔpiyari ꞌdeni rɔ bi ꞌba tako ꞌba ꞌja gɔ mini tine, ");
INSERT INTO bex_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","na bo kebe toꞌdɔ mötu, kiya te, “Ŋere Bɔkoꞌba ꞌba löbu ma Abarayama, iꞌdi wa nime tɔne ne koꞌdɔ rönï laka zö. Mititi yi iꞌdi wa ma laka koꞌdɔ rönï zi löbu ma kɔzɔ ame kiꞌdi köꞌdu mo ne tara. ");
INSERT INTO bex_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ma na me ꞌdeni kpa daa ame yïtötï ꞌba bilaka ꞌba mï gawo nime pili këdï kako tunö mini di teyi. ");
INSERT INTO bex_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ɔdɔ miya zi ma kɔtɔ mɔtɔ, miya te, ‘Unö mini kiꞌdi zö muwë,’ kina ɔdɔ lɔko kiya te, ‘Me uwë, kina mëdï miꞌdi gbï zi gamele ꞌbï ga,’ lɔko na gɔ kiꞌdi këdï rɔ ame kigeli ꞌdeni rɔ ꞌja zi bɔ laja ꞌbï Yisika ne. Ɔdɔ koꞌdɔ rönï te, na ti mikali ŋgï köꞌdu ꞌbï ma tönë kose gɔmo zi löbu ma ne uyï yïmo dë.” ");
INSERT INTO bex_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tine gba kota kinza bo kote lende nime na Rebeka kömö ŋgï. Lɔko na rɔ nyiti ꞌba Betowele ame Mileka köyö zi Nawura löndö ꞌba Abarayama ni ne. Kina lɔko kömö ŋgï ti kete mini dɔkɔnyɔ nï. ");
INSERT INTO bex_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Lɔko rɔ nyiti ma kele rɔ dɔ kiteli ame gbï gba kikali bɔtɔni dë. Lɔko ëkï mï daa kunö mini ꞌbënï lɔko këkï yaga. ");
INSERT INTO bex_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kina bɔ laja nima kiriŋa kurë dönï, iya te, “Iꞌdi mini zö muwë di mï kete ꞌbï nima.” ");
INSERT INTO bex_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Lɔko iya te, “Löbu ma, me uwë.” Kina lɔko kombi welo di dɔkɔnyɔ nï kiꞌdi kpa bɔ nima kuwë. ");
INSERT INTO bex_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kina ɔdɔ lɔko kiꞌdi mini ꞌdeni zi bɔ nima kuwë kɔꞌbɔ bo tine, lɔko iya te, “Mëdï miꞌdi gbï zi gamele ꞌbï ga kuwë kɔꞌbɔ lïjë.” ");
INSERT INTO bex_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kina lɔko köpu welo kodɔ mini mï gɔ bi ꞌba tuwë mini ꞌba yërï, lɔko kileki ꞌböwu welo kari mï daa ŋbö lɔko kunö mini kɔꞌbɔ gamele ꞌba bɔ nima. ");
INSERT INTO bex_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tine bɔ nima ëdï kɔrɔ le yayi toŋgɔ mo ɔdɔ Bɔkoꞌba oꞌdɔ lende laka ꞌdeni ŋgï mï liŋgere abo nima ya. ");
INSERT INTO bex_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kina ɔdɔ gamele kote tuwë mini ꞌdeni na bɔ nima kogba wa ꞌba kano ma kele ame ndögö mo kitigɔ kulöwö ne kiꞌdi zi nyiti nima gbï ti ŋbëlë ma kele rïyö ꞌdo, kolɔ kɔnyɔ mo ga. ");
INSERT INTO bex_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Bo ititi lɔko, iya te, “Nï nyiti ꞌba yë na? Ti doꞌja bi ꞌba töꞌdö ŋgï di liŋɔ ꞌba ꞌbu yï yayi?” ");
INSERT INTO bex_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Lɔko iya te, “Ma nyiti ꞌba Betowele ame Mileka köyö zi Nawura ne na. ");
INSERT INTO bex_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Dëdï ti akonyo ꞌba yërï gbï ti mɔli zïnnï ꞌdɔ töꞌdö dɔmo. Kina rö ëdï gbï zïyï töꞌdö teyi.” ");
INSERT INTO bex_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kina bɔ nima kolɔdɔ bërï koꞌdɔ mötu zi Bɔkoꞌba, iya te, ");
INSERT INTO bex_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Yëëꞌdï këdï zïyï Bɔkoꞌba ꞌba löbu ma Abarayama gɔ ame kuyï mï köꞌdu ma kose zi löbu ma Abarayama dë ne. Oꞌde ma ꞌdeni te dɔ wado ꞌba löbu ma Abarayama naga nime.” ");
INSERT INTO bex_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nyiti nima ënyï kiriŋa kileki kari liŋɔ zi mönï, lɔko kari kïyëtï gɔ köꞌdu naga nime koꞌdɔ rönï ne pili zi ya ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lɔko ëdï ti löndö nï yayi möyï mo rɔ Labana. Kina bo kënyï ŋgï kiriŋa kari kpa daa toŋgɔ bɔ laja ꞌba Abarayama nima. ");
INSERT INTO bex_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labana oꞌja wa ꞌba kano ni ti ŋbëlë naga nima kɔnyɔ lëmï bo ne ꞌdeni kina bo uwö lende ma bɔ nima kiya lɔko koloma rɔ tïyëtï mo ne ꞌdeni gbï. Bo ari koꞌja bɔ nima këdï kɔrɔ ŋgila gamele abo ga kpa daa yayi. ");
INSERT INTO bex_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Bo iya te, “Ako liŋɔ, nï ame Bɔkoꞌba koꞌdɔ yëyï ma laka ꞌdeni döyï ne. Ëddï kɔrɔ mökö bine gɔ waꞌdi? Mëdï ti rö ndö zïyï mï liŋɔ ma ꞌdë yayi kina gɔ bi ëdï gbï zi gamele ꞌbï ga.” ");
INSERT INTO bex_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kina bɔ nima kari ŋgï liŋɔ, na Labana kope akombi yaga di gɔ gamele naga nima kiꞌdi akonyo ti mɔli ꞌba töꞌdö dɔmo teyi. Kina bo koꞌde mini zi bɔ nima lïjë kurögö ndïnnï ti ya ame ga ti bo ne. ");
INSERT INTO bex_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kina ɔdɔ koꞌde akonyo ꞌdeni zïnnï tine bɔ nima iya te, “Minza monyo kpama titi, tine ꞌjaa ŋbö ɔdɔ miya lende ame mako timo ne ꞌdeni.” Labana iya te, “Iya lende ꞌbï.” ");
INSERT INTO bex_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Bɔ nima iya te, “Ma bɔ laja ꞌba Abarayama na. ");
INSERT INTO bex_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Bɔkoꞌba oꞌdɔ yëyï ꞌdeni rɔ mbëmbë zi löbu ma koꞌdɔ bo rɔ bɔ wa. Bɔkoꞌba iꞌdi dɔtumu ma konzi ꞌba kamölö ni ti banya ti sa ti yamo rɔ mbëmbë ti atɔli ma konzi ꞌdeni zi bo gbï ti gamele ni ti akaca. ");
INSERT INTO bex_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara ꞌja ꞌba löbu ma Abarayama ari köyö kole zi bo koꞌja bo köndë ꞌdeni. Kina me bo kiꞌdi wa ame ga pili bo këdï timo ne ꞌdeni teyi. ");
INSERT INTO bex_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Bo iꞌdi mulömu rɔma ꞌdɔ muwö dɔ köꞌdu kiꞌdi abo. Bo iya te, ‘Kinza kogbe ꞌja dë zi kole ma di mï yïtötï ꞌba Kanana dɔyayi nime mëdï moloma yïmo ne. ");
INSERT INTO bex_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tine ileki kari liŋɔ ꞌba ꞌbu ma mï löŋgö wado ma ga ꞌdɔ kari kogbe ꞌja zi kole ma di yayi.’ ");
INSERT INTO bex_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mititi bo, miya te, ‘Ne ɔdɔ nyiti mo koꞌdɔkɔ dë tako tö?’ ");
INSERT INTO bex_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Bo ileki dɔmo zö, bo iya te, ‘Bɔkoꞌba ame möꞌbö tuwö dɔmo ne ti koja malayika abo kari tïyï kiꞌdi wa koꞌdɔ rönï pili zïyï rɔ ma laka. Ëddï kari koꞌja ꞌja zi kole ma di mï löŋgö wado ma ga ame rɔ bilaka ꞌba ꞌbu ma ga ne. ");
INSERT INTO bex_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tine ɔdɔ kari zi wado ma naga nima kina ɔdɔ kiya te lïjë na kilagi tine, ti këddï ëꞌbï rɔ ma kɔpɔ di mï lömu nime.’ ");
INSERT INTO bex_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kina me mömö kpa daa bine ti kada ne, na mititi ŋere Bɔkoꞌba, miya te, ‘Ŋere Bɔkoꞌba ꞌba löbu ma Abarayama, momaꞌjo rɔma zïyï wa nime mëdï moꞌdɔ tɔne ne iꞌdi koꞌdɔ rönï laka zö. ");
INSERT INTO bex_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ma na me ꞌdeni kpa daa bine. Ɔdɔ nyiti mɔtɔ kako tunö mini nime mëdï mïdëkï mini di zïnï gɔ lɔko kiꞌdi zö muwë di mï kete ꞌbënï. ");
INSERT INTO bex_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ɔdɔ lɔko kutï dɔmo kina lɔko koꞌdɔkɔ gbï tiꞌdi mini zi gamele ma ga, lɔko na gɔ kiꞌdi këdï rɔ nyiti ame kigeli ꞌdeni rɔ ꞌja zi kole ꞌba löbu ma ne.’ ");
INSERT INTO bex_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tine gba kota ma kinza mote mötu nime di yïmö, na Rebeka kömö ŋgï ti kete mini dɔkɔnyɔ nï, lɔko këkï kari mï daa tunö mini. Mïdëkï mini di zïnï, miya te, ‘Iꞌdi mini zö muwë.’ ");
INSERT INTO bex_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kina lɔko kodi dɔkɔnyɔ nï ŋgï welo kiꞌdi mini zö, kiya te, ‘Me uwë, kina ti miꞌdi mini gbï zi gamele ꞌbï ga.’ Kina muwë mini, lɔko kiꞌdi gbï zi gamele ma ga kuwë. ");
INSERT INTO bex_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kina mititi lɔko, miya te, ‘Nï nyiti ꞌba yë na?’ Lɔko iya te, lɔko nyiti ꞌba Betowele kole ꞌba Nawura ame Mileka köyö ne na. Kina musu wa kano nï, molɔ ŋbëlë kɔnyɔ nï. ");
INSERT INTO bex_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tine na molɔdɔ moꞌdɔ mötu mïlëlu Bɔkoꞌba ꞌba löbu ma Abarayama, gɔ ame bo koꞌde ma ꞌdeni kɔri ma laka kiꞌdi moꞌja nyiti ꞌba wado ꞌba löbu ma ꞌdeni rɔ ꞌja zi kole mo ne. ");
INSERT INTO bex_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kina me ɔdɔ koꞌdɔkɔke ŋgï toꞌdɔ mo ꞌdɔ këdï laka zi löbu ma, iyake zö, ne ɔdɔ dɔmo kinza, iyake gbï zö ꞌdɔ muyï kɔmɔ ma mari te dɔ dörï ala mɔtɔ mileki te dɔ gali.” ");
INSERT INTO bex_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labana ni ti Betowele ileki dɔmo, iya te, “Köꞌdu nime ako di zi Bɔkoꞌba dinza ti a mɔtɔ ꞌdɔ tiya mo. ");
INSERT INTO bex_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka na me kömöyï, ogba lɔko kari tïnï. Iꞌdi lɔko rɔ ꞌja zi kole ꞌba löbu ꞌbï kɔzɔ ame Bɔkoꞌba kiya ne tara.” ");
INSERT INTO bex_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kina ɔdɔ bɔ laja ꞌba Abarayama nima kuwö lende nima ꞌdeni tara tine na bo kolɔdɔ ŋgï bërï bo koꞌdɔ mötu zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kina bo koja bɔŋgɔ ni ti sïtërï ti wa ꞌba mbili ma kileŋo di mï yamo ma köbököbö naga, bo kiꞌdi zi Rebeka. Bo iꞌdi kpa közï ma ndögö mo kitigɔ kulöwö naga gbï zi löndö ꞌba Rebeka ni ti ma mo. ");
INSERT INTO bex_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kina bɔ nima ti bilaka ame ga ti bo ne konyo kpënnï kuwë wa lïjë köꞌdö yayi. Mï dɔŋbɔ tine na bo kiya te, “Iꞌdike ma mileki mari zi löbu ma.” ");
INSERT INTO bex_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tine löndö ꞌba Rebeka ni ti ma mo iya te, “Iꞌdi nyiti nime koloma titi koꞌdɔ töꞌdö kɔzɔ dɔ ndö tara, ala dɔ ꞌbutë tize bine. Di pötö mo tine ti lɔko kari ꞌjaa.” ");
INSERT INTO bex_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tine bɔ nima ileki dɔmo zïnnï, iya te, “Kinza kiꞌdike ze dë digabi bine. Bɔkoꞌba iꞌdi liŋgere ma ꞌdeni këdï laka, iꞌdike mari zi löbu ma.” ");
INSERT INTO bex_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Lïjë iya te, “Iꞌdi dïdëkï nyiti gɔ dititi lɔko.” ");
INSERT INTO bex_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kina lïjë kïdëkï Rebeka kititi, iya te, “Ti kari ti bɔ nime?” Lɔko iya te, “Yëë, mëdï mari.” ");
INSERT INTO bex_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kina lïjë kiꞌdi Rebeka ni ti nyiti ame mɔlo rɔ bɔ laja ꞌbënï ne kari kɔtɔ ti bɔ nima kpaki ti bilaka abo ga. ");
INSERT INTO bex_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kina lïjë koꞌdɔ lömu ma laka zi Rebeka, iya te, “Nï lëmï ze, ti koloma rɔ ma ꞌba tïndï ꞌba bilaka ma konzi. Kupö yï ga ti köꞌbö taꞌda bɔ ya ꞌbënnï ga.” ");
INSERT INTO bex_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kina Rebeka ni ti yïtötï bɔ laja ꞌbënï naga nima kileŋo rönnï ŋgï këkï dɔ gamele kari kɔtɔ ti bɔ laja ꞌba Abarayama nima. Kina lïjë kënyï ŋgï dɔmo di yayi. ");
INSERT INTO bex_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Yisika ako ꞌdeni di kpa daa ame kïdëkï rɔ, “Daa ꞌba Bɔkoꞌba bɔ dïdï ame koŋgɔ ma ne.” Bo ëdï koloma mï dɔyayi ꞌba Kanana ma kapa kileki dɔ roꞌɔ. ");
INSERT INTO bex_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Bo ënyï ꞌdeni rɔ mï dɔkɔpiyari kari bi liŋgere mï nyaka na bo koꞌja gamele ŋgï këdï rɔ tako. ");
INSERT INTO bex_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kina ɔdɔ Rebeka koꞌja Yisika ꞌdeni tara tine na lɔko këkï ŋgï bërï di dɔ gamele, ");
INSERT INTO bex_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","lɔko ititi bɔ laja ꞌba Abarayama nima, iya te, “Yë mo na me ꞌdë këdï kako rɔ mï nyaka zize yöyï ne?” Bɔ nima iya te, “Bo na rɔ löbu ma.” Kina lɔko kogba bɔŋgɔ ꞌba dönï ŋgï lɔko kolo kömönï timo. ");
INSERT INTO bex_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Bɔ laja nima ïyëtï gɔ wa ame ga bo koꞌdɔ ne pili zi Yisika. ");
INSERT INTO bex_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kina Yisika kogbe Rebeka rɔ ꞌja abo koꞌde mï rö ma tönë ma bo Sara koloma pa teyi ne. Yisika ɔꞌɔ Rebeka rɔ mbëmbë kina kïyëyï dökïꞌdï bo ŋgï di gɔ meri ꞌba tölë ꞌba ma bo. ");
INSERT INTO bex_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abarayama ogbe ꞌja mɔtɔ möyï mo rɔ Ketora. ");
INSERT INTO bex_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Lɔko na köyö Zimarana ni ti Yokezana ti Medana ti Midiyana ti Yisebaka ti Suwa. ");
INSERT INTO bex_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokezana na rɔ ꞌbu ꞌba Seba ni ti Dedana. Kupö Dedana ga na rɔ bilaka naga nima kïdëkï rɔ Asura ni ti Letosa ti Luma. ");
INSERT INTO bex_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Kole ma ꞌba Midiyana ga na rɔ Epa ni ti Epera ti Anoko ti Abida ti Elida. Ya naga nime pili rɔ kupö ma kɔdɔ di zi Ketora ga. ");
INSERT INTO bex_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Yisika na Abarayama kiꞌdi ꞌdɔ këdï rɔ bɔ dɔ apötö bo ga. ");
INSERT INTO bex_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tine koꞌja bo këdï gba ti kɔmɔ bo, bo iꞌdi kpa közï zi kole ꞌba ꞌja abo mɔtɔ naga nima, kina bo koga lïjë ŋgï yaga di ŋgila kole abo Yisika yayi, lïjë kari mï dɔyayi ma kileki kapa kari yïbï. ");
INSERT INTO bex_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abarayama ari kölë ꞌjaa koꞌja bo köndë ꞌdeni kote, kɔmɔ kɔɔ abo këdï ꞌdeni kuluku mota kɔdɔ dɔmo ꞌbutë rïyö döömu (175). ");
INSERT INTO bex_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kole abo ga Yisika ni ti Yisamele usu bo mï tïꞌbörö ꞌba Makapela kapa Mamore ma kari yïbï mï nyaka ꞌba Eporona kole ꞌba Zora ame di eꞌbe Ete ne. ");
INSERT INTO bex_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Nyaka nime na tönë Abarayama kugö di zi eꞌbe Ete ga. Kina kusu Abarayama gbï yayi ŋgila ꞌja abo Sara. ");
INSERT INTO bex_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Di pötö tölë ꞌba Abarayama na Bɔkoꞌba koꞌdɔ yëyï zi kole abo Yisika koꞌja bo këdï koloma ŋgila daa ame kïdëkï rɔ “Daa ꞌba Bɔkoꞌba bɔ dïdï ame koŋgɔ ma” ne. ");
INSERT INTO bex_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Yisamele ma tönë Agara yïtö ꞌba Ezipeto atɔli ꞌba Sara köyö zi Abarayama ne na köyö kole naga nime. ");
INSERT INTO bex_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ame na rɔ möyï kole mo ga ma kiyija pili gɔ töyö mo. Nebayota na rɔ kole ma dɔgba ꞌba Yisamele, kina Kedara ni ti Adabele ti Mibesama ");
INSERT INTO bex_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ti Misama ti Duma ti Masa ");
INSERT INTO bex_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ti Adada ti Tema ti Yetora ti Napisa ti Kedema. ");
INSERT INTO bex_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Kole ꞌba Yisamele naga nime lïjë na rɔ yï lïŋgï ꞌba kpa gɔli ma ꞌbutë dɔmorïyö ame möyï lïjë na pili kïlëbï dɔ dɔliŋɔ mo ga gbï ti bi ꞌba toda yërï mo ga ne. ");
INSERT INTO bex_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Kɔmɔ kɔɔ ꞌba loma ꞌba Yisamele pili kuluku rïyö kɔdɔ dɔmo ꞌbutë mota döömu dɔmorïyö (137) kina bo kölë ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Kupö Yisamele ga oloma ꞌbënnï mï dɔyayi ꞌba Awila ni ti Surö kapa Ezipeto ma kari yïbï mï löŋgö mo ma ti Asura. Ya naga nime oloma ꞌbënnï köꞌbö caki yaga di dɔ ŋgila kupö Abarayama mɔtɔ naga nima. ");
INSERT INTO bex_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ame na rɔ lende ꞌba Yisika kole ꞌba Abarayama. ");
INSERT INTO bex_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kɔmɔ kɔɔ ꞌba Yisika ëdï ꞌdeni ꞌbutë sowɔ mï kada ma bo kogbe Rebeka nyiti ꞌba Betowele bɔ Arama tönë koloma Padanarama ne. Löndö ꞌba Rebeka na rɔ Labana. ");
INSERT INTO bex_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tine Rebeka öyö kole dë kina Yisika kititi Bɔkoꞌba gɔ köꞌdu mo. Kina Bɔkoꞌba kileki dɔ akititi abo ŋgï kiꞌdi Rebeka kɔmɔ. ");
INSERT INTO bex_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kole roŋa na mïnï, tine gba kinza lɔko köyö dë na kole naga nima koloma ŋgï tunyöpö di mïnï. Lɔko iya te, “Gɔ waꞌdi na wa ma te ga koꞌdɔ rönï zö?” Lɔko ari kititi Bɔkoꞌba gɔ köꞌdu mo. ");
INSERT INTO bex_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kina Bɔkoꞌba kileki dɔmo zïnï, iya te, “Dɔꞌbe rïyö na ma mïyï. Ëddï köyö bilaka rïyö mɔtɔ ga ma köꞌbö toꞌji rönnï. Bɔ ma kɔtɔ ti këdï ti tigɔ kebe bɔ mɔtɔ. Bɔ ma löbu mo ti koja laja zi ma titi mo.” ");
INSERT INTO bex_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kina ɔdɔ kada ꞌba löyö kömö ꞌdeni zïnï tine, lɔko öyö rɔ kole roŋa. ");
INSERT INTO bex_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kole ma dɔgba mo rɔ ma kasi rɔmo pili rɔ sunë kɔzɔ sunë ꞌba rɔ yërï tara. Kina lïjë kiꞌdi möyï mo rɔ Esawu, ame kiya te “Rɔ köyu.” ");
INSERT INTO bex_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tine na köyö kole ma mï rïyö mo közïmo kindaꞌba burutu Esawu ꞌdeni könyö teyi. Kina kiꞌdi möyï bo ŋgï rɔ Yakoba, ame kiya te “Indaꞌba.” Mï kada nima köyö lïjë ne kɔmɔ kɔɔ ꞌba Yisika ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë (60). ");
INSERT INTO bex_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kina ɔdɔ kole naga nima kïyöbu ꞌdeni tine, Esawu ꞌba bo rɔ bɔ koꞌbe kanya gɔti mo köꞌbö rɔ laki mökö. Tine Yakoba ꞌba bo le rɔ ma këyï gɔti mo rɔ loma liŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esawu na Yisika kɔꞌɔ laka römöyï bo rɔ lɔŋɔ gɔ tonyo yida ame ga Esawu këdï kupö ne. Tine Rebeka ɔꞌɔ ꞌbënï rɔ Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mï kada ma dɔ kɔtɔ mɔtɔ tine Esawu ömö di bi laki mökö kako koꞌja Yakoba këdï tuꞌdï monzo. ꞌBö oꞌdɔ bo ꞌdeni ŋgï sowa ");
INSERT INTO bex_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","kina bo kiya zi Yakoba te, “ꞌBö upö ma ꞌdeni, wa kasi nima kuꞌdï ne iꞌdi zö.” Gɔ köꞌdu nime na kïdëkï möyï bo rɔ Edome, ame kiya te “Akasi.” ");
INSERT INTO bex_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakoba iya te, “Ti miꞌdi zïyï ɔdɔ kiya te kiꞌdi rɔ löbu ꞌbï ꞌba tëdï rɔ kole ma dɔgba nima zö.” ");
INSERT INTO bex_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu iya te, “ꞌBö na me kɔdɔ ꞌdeni rɔma, rɔ löbu ma ꞌba tëdï rɔ kole ma dɔgba nime ti koꞌdɔ waꞌdi zö?” ");
INSERT INTO bex_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakoba iya te, “Ulömu röyï titi dɔgba zö.” Kina bo kulömu rɔ bo ŋgï kugö rɔ löbu abo ꞌba tëdï rɔ kole ma dɔgba nima zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kina Yakoba kiꞌdi maŋgolɔꞌbɔ zi bo ti monzo nima bo konyo, bo kuwë wa, na bo kënyï ŋgï nduwë kari abo. Wa ma Esawu kiꞌdi kɔꞌɔ rɔ bo kulöwö di dɔ rɔ löbu abo ꞌba tëdï rɔ kole ma dɔgba nima na ŋge nime. ");
INSERT INTO bex_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ꞌBö mɔtɔ ari kilaꞌba ꞌböwu mï dɔyayi nima ꞌberi di gɔ ma tönë pa mï kada ꞌba Abarayama ne. Kina Yisika kënyï ŋgï kari Gerara zi Abimeleke ŋere ꞌba Pilisitiya. ");
INSERT INTO bex_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Bɔkoꞌba ɔdɔ kileme rönï zi Yisika, iya te, “Kinza kari dë ŋbö Ezipeto, oloma mï dɔyayi nime miya zïyï toloma teyi ne. ");
INSERT INTO bex_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Oloma mï dɔyayi nime bine kina ti möꞌbö nduwë tïyï. Ti moꞌdɔ yëyï zïyï römöyï yayi nime na mëdï miꞌdi pili zïyï ti kupö yï ga. Mëdï moꞌdɔ wa ma tönë ga mulömu mɔlo zi ꞌbu yï Abarayama bine ne. ");
INSERT INTO bex_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mëdï miꞌdi kupö yï ga kara konzi kɔzɔ këlu ꞌba mïtɔrɔ. Kina ti miꞌdi yayi nime pili zïnnï. Kina ti kupö yï ga na ti koꞌdɔ yëyï dɔ bilaka pili ꞌba dɔyayi nime. Mëdï moꞌdɔ yëyï zïyï ");
INSERT INTO bex_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","römöyï Abarayama uwö dɔma koro köꞌdu kiꞌdi ma ga pili rɔ gɔmo.” ");
INSERT INTO bex_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Mï kada ma Yisika këdï koloma Gerara yayi na ");
INSERT INTO bex_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","bilaka ma yayi kititi ꞌja abo Rebeka di zi bo, tine bo iya te, “Lɔko lëmï ma na.” Bo ere tiya mo rɔ ꞌja abo kinza bilaka naga nima kupö bo ra gɔ köꞌdu ꞌbënï römöyï lɔko ele kulöwö. ");
INSERT INTO bex_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kina ɔdɔ bo koloma ꞌdeni gɔmo kɔwɔ yayi tine, mï kada mɔtɔ na Abimeleke ŋere ꞌba Pilisitiya kuyï kɔmɔ bo koŋgɔ bi di bi gböŋö ꞌba rö koꞌja Yisika ni kindaꞌba közïnnï ꞌdeni ti Rebeka. ");
INSERT INTO bex_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kina Abimeleke kïdëkï Yisika kititi, iya te, “Dëmba lɔko ꞌja ꞌbï na? Ne gɔ waꞌdi na kiya te lɔko lëmï yï na?” Yisika iya te, “Römöyï momeri miya te mɔtɔga bilaka ti kupö ma ɔdɔ miya te lɔko ꞌja ma na.” ");
INSERT INTO bex_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleke iya te, “Waꞌdi na me koꞌdɔ zize te ne? Mɔtɔga dëne bilaka ma naga nime öꞌdö ꞌdeni ti ꞌja ꞌbï. Ma këdï ra tara dëne nï na ti kɔrɔ rɔ bɔ kiꞌdi ze doꞌdɔ lende kënyë nime.” ");
INSERT INTO bex_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tine na Abimeleke kose gɔmo zi bilaka pili, iya te, “Bɔtɔ ame kosa közïnï rɔ bɔ nime ala rɔ ꞌja mo ëdï kupö yaga.” ");
INSERT INTO bex_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yisika orɔꞌdɔ nyaka mï dɔyayi nima yayi. Kina mï kɔmɔ kɔɔ mo nima bo kumu ŋgï rɔ mbëmbë kebe dɔ kupö ma bo kïdïyë römöyï Bɔkoꞌba oꞌdɔ yëyï ꞌdeni zi bo. ");
INSERT INTO bex_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kina mɔri abo nima koto ŋgï nduwë tïyöbu ŋbö bo kari këdï rɔ bɔ mɔri. ");
INSERT INTO bex_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Bo ꞌdeni ti dɔtumu ꞌba kamölö ni ti sa gbï ti atɔli ma konzi. Gɔ köꞌdu mo na bilaka ꞌba Pilisitiya naga nima kombi mïnnï ŋgï rɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kina lïjë kïdïrï daa ame ga bɔ laja ꞌba ꞌbu bo Abarayama ga kole gba kota bo këdï ti kömönï ne ŋgï me teyi. ");
INSERT INTO bex_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleke ilende zi Yisika, iya te, “Ënyï yaga di mï dɔyayi ze nime. Nï ꞌdeni rɔ bɔ tigɔ ma dɔ kiteli kebe ze pili.” ");
INSERT INTO bex_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kina Yisika kënyï ŋgï kari koga taya abo mï bi pëpëlë ꞌba Gerara, bo koloma yayi. ");
INSERT INTO bex_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Bo ole daa ma tönë ga kole pa mï kada ꞌba ꞌbu bo Abarayama ne, ame bilaka ꞌba Pilisitiya kïdïrï ꞌdeni teyi di pötö tölë ꞌba Abarayama. Möyï ame ga mɔlo ꞌbu bo kiꞌdi dɔ daa naga nima na gbï bo kïdëkï timo. ");
INSERT INTO bex_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Bɔ laja ꞌba Yisika ga ole daa mï bi pëpëlë nima yayi na lïjë koꞌja mini di teyi. ");
INSERT INTO bex_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tine bɔ koda kamölö ma mï dɔyayi ꞌba Gerara yayi ako kamo tïnnï, iya te, “Mini ze na me.” Gɔ köꞌdu mo na Yisika kiꞌdi möyï daa nima rɔ “Lamo.” ");
INSERT INTO bex_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bɔ laja ꞌba Yisika ga ari kole daa mɔtɔ ꞌböwu, kina lamo kuꞌdu rönï gbï gɔ lende mo na bo kïdëkï möyï mo rɔ “Ndoꞌji.” ");
INSERT INTO bex_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Bo olɔlɔ di yayi kari kole daa mɔtɔ. Ama tine na lamo kinza kpe teyi. Kina bo kiꞌdi möyï mo rɔ “Dɔ ŋgölö.” Bo iya te, “Bɔkoꞌba iꞌdi dɔ ŋgölö ꞌdeni zize toloma mï dɔyayi nime bine gɔ doꞌjake wa laka nduwë di teyi.” ");
INSERT INTO bex_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Di yayi na bo kënyï kari Berasaba. ");
INSERT INTO bex_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kina Bɔkoꞌba kɔdɔ kileme rönï zi bo mï korɔndɔ mo nima, iya te, “Ma na rɔ Bɔkoꞌba ꞌba ꞌbu yï Abarayama. Kinza kere dë, mëdï tïyï. Mëdï moꞌdɔ yëyï zïyï miꞌdi kupö yï kara konzi gɔ köꞌdu kiꞌdi ma ame mose zi bɔ laja ma Abarayama ne.” ");
INSERT INTO bex_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kina Yisika koꞌba bi ꞌba akumu yayi koꞌdɔ mötu zi Bɔkoꞌba di teyi. Bo oga taya abo yayi na bɔ laja abo ga kole daa mɔtɔ gbï. ");
INSERT INTO bex_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ŋere Abimeleke ni ënyï di Gerara lïjë ti Awuzata bɔ tiꞌdi lende zi bo ti Pikolo bɔ dɔ bɔ kanya abo lïjë kari toŋgɔ Yisika. ");
INSERT INTO bex_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Tine bo iya zïnnï, iya te, “Akoke toŋgɔ ma tɔne gɔ waꞌdi? Oꞌja tönë oꞌjike ma kogake ma yaga di mï dɔyayi ꞌbe ꞌdi.” ");
INSERT INTO bex_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Lïjë iya te, “Leꞌjete dikali ꞌdeni rɔ ma laka Bɔkoꞌba ëdï tïyï. Kina me diya te gɔ doꞌdɔ pɔri tïyï. Doꞌdɔkɔ yi gɔ kulömu röyï ");
INSERT INTO bex_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kinza koꞌdɔ wa ma kënyë mɔtɔ dë zize, gbï kɔzɔ ame doꞌdɔ wa ma kënyë mɔtɔ dë zïyï ne tara. Doloma doꞌdɔ kɔmɔ kele döyï doja yi kari liya ti mï këyï. Kina me dikali ꞌdeni rɔ ma laka Bɔkoꞌba oꞌdɔ yëyï ꞌdeni zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Yisika oꞌdɔ karama zïnnï lïjë konyo kpënnï kuwë wa. ");
INSERT INTO bex_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mɔlo mï bi këzë ma di gɔmo tine na lïjë koꞌdɔ lömu mï löŋgö lïjë. Yisika oꞌdɔ mötö gbɔ zïnnï kina lïjë kari ŋgï di rɔ bo liya ti mï këyï. ");
INSERT INTO bex_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mï kada mo nima na bɔ koja laja ꞌba Yisika ga kako kiya lende ꞌba daa ame lïjë kole ne zi bo, iya te, “Doꞌja mini ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kina bo kiꞌdi möyï mo rɔ Saba, ame ꞌjɔ ꞌba lende mo tëgë, “Lömu.” Wa nime na ꞌdɔ kiꞌdi kïdëkï möyï gawo nima rɔ Berasaba ne. ");
INSERT INTO bex_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Tine Esawu kɔmɔ kɔɔ abo ꞌdeni ꞌbutë sowɔ na bo kogbe ꞌja ŋgï rïyö di mï yïtötï ꞌba eꞌbe Ete, Yudïta nyiti ꞌba Beri ti Basemata nyiti ꞌba Elone. ");
INSERT INTO bex_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Tine lende koꞌdɔ ꞌbënnï iꞌdi Yisika ni ti Rebeka ŋgï köꞌbö rɔ meri. ");
INSERT INTO bex_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kina ɔdɔ Yisika köndë ꞌdeni kɔmɔ mo kölu tine, na bo kïdëkï Esawu kole abo ma dɔndende mo kako zi bo. Bo ïdëkï, iya te, “Kole ma.” Esawu iya te, “Ma na me.” ");
INSERT INTO bex_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Bo iya te, “Oŋgɔ ma na me möndë ꞌdeni mɔtɔga ti mölë gïrï naga nime. ");
INSERT INTO bex_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ogba kanya ti bölö ꞌbï kɔdɔ kari mökö toꞌbe yida zö. ");
INSERT INTO bex_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kina gɔ koꞌdɔ akonyo koŋmi tönë ga moꞌdɔkɔ ne koꞌde kako zö monyo ꞌdɔ moꞌdɔ yëyï zïyï gba kota kinza mölë.” ");
INSERT INTO bex_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Tine Rebeka ëdï kuwö lende nima Yisika këdï kiya zi Esawu ne. Kina ɔdɔ Esawu kari ꞌdeni toma yida toꞌbe mo di yï mökö tine, ");
INSERT INTO bex_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","na lɔko kiya zi Yakoba, iya te, “Muwö ꞌbu yï koloma tiya mo zi löndö yï Esawu gïrï nime, iya te, ");
INSERT INTO bex_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Oꞌde yida koꞌdɔ akonyo koŋmi tönë ga koꞌde zö monyo ꞌdɔ moꞌdɔ yëyï zïyï kɔmɔ Bɔkoꞌba gba kota kinza mölë.’ ");
INSERT INTO bex_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kina me kole ma, uwö dɔma koꞌdɔ wa ame ga miya zïyï ne. ");
INSERT INTO bex_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ari mï jɔlɔ koꞌde kole banya ma kɔnɔ rïyö ꞌdɔ moꞌdɔ rɔ akonyo koŋmi ma ꞌbu yï koꞌdɔkɔ nima ");
INSERT INTO bex_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ꞌdɔ koto kari zi bo konyo gɔ bo koꞌdɔ yëyï zïyï gba kinza bo kölë.” ");
INSERT INTO bex_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tine Yakoba ileki dɔmo, iya te, “Löndö ma Esawu rɔmo rɔ sunë, ma ꞌbama rɔma kinza sunë, ");
INSERT INTO bex_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","mɔtɔga ꞌbu ma ti komomo rɔma kikali mëdï mïndëndë bo. Kina mëdï moꞌde ŋgï rɔ sönö na za dɔma kola yëyï mo tönë.” ");
INSERT INTO bex_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma bo iya te, “Kole ma, sönö nima kileki dɔma. Lende ma nime na ŋge kuwö dɔmo kari koꞌde banya naga nima kako zö.” ");
INSERT INTO bex_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kina bo kari ŋgï gɔmo koꞌde kako zi ma bo koꞌdɔ rɔ akonyo koŋmi ame ꞌbu bo koꞌdɔkɔ ne. ");
INSERT INTO bex_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kina lɔko kogba bɔŋgɔ ma laka ꞌba Esawu ame lɔko këdï kikeki rö gönï yayi ne, kolɔ rɔ Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kina lɔko kogba kilaka banya tönë ga kolo kɔnyɔ bo ga gbï kebe gɔ bi ꞌba mugu bo ma kinza sunë teyi. ");
INSERT INTO bex_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kina lɔko kiꞌdi akonyo koŋmi tönë ti maŋgolɔꞌbɔ mo ga ame lɔko koꞌdɔ ne közï kole ꞌbënï Yakoba kari timo. ");
INSERT INTO bex_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakoba ari zi ꞌbu bo Yisika, kiya te, “Baba.” ꞌBu bo iya te, “Ma na me. Nï kole ma, ma rɔ yë mo na?” ");
INSERT INTO bex_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakoba iya te, “Ma Esawu kole dɔndende ꞌbï na. Moꞌdɔ ꞌdeni kɔzɔ ma kiya zö. Ënyï tɔrɔ konyo yida ma moꞌdɔ ꞌdeni zïyï nime ꞌdɔ koꞌdɔ yëyï zö.” ");
INSERT INTO bex_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tine Yisika ititi, iya te, “Ari koꞌja ŋgï welo te tondo ga ya, kole ma?” Yakoba ileki dɔmo, iya te, “Ŋere Bɔkoꞌba ꞌbï na kiꞌdi koꞌdɔ rönï ŋgï laka zö.” ");
INSERT INTO bex_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yisika iya zi Yakoba, iya te, “Ese ŋgɔsi ŋgila ma bine ꞌdɔ momomo röyï, gɔ mikali ɔdɔ nï kole ma Esawu na ŋgï.” ");
INSERT INTO bex_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakoba ese ŋgɔsi zi ꞌbu bo. Yisika omomo rɔ bo, iya te, “Mugu yï udu rɔ mugu Yakoba, tine kɔnyɔ yï ga rɔ kɔnyɔ Esawu.” ");
INSERT INTO bex_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yisika ikali dë kpe rɔ Yakoba römöyï kɔnyɔ bo ga ꞌdeni rɔ sunë kɔzɔ kɔnyɔ löndö bo Esawu. Tine gba kinza bo koꞌdɔ yëyï nime zi Yakoba, ");
INSERT INTO bex_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","bo ileki kititi, iya te, “Nï Esawu na ŋgï?” Yakoba iya te, “Ma na ŋgï.” ");
INSERT INTO bex_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yisika iya te, “Kole ma, oꞌde yida nima zö monyo ꞌdɔ moꞌdɔ yëyï zïyï.” Kina Yakoba koꞌde yida tönë ŋgï zi ꞌbu bo konyo, bo koꞌde layi gbï zi ꞌbu bo kuwë. ");
INSERT INTO bex_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Yisika iya zi bo, iya te, “Kole ma, ese ŋgɔsi kome mbili ma.” ");
INSERT INTO bex_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kina Yakoba kese ŋgɔsi kome mbili ꞌbu bo. Yisika umë tato ꞌba bɔŋgɔ ꞌba kole abo na bo kiya te, “Tato kele ꞌba rɔ kole ma ŋgï kɔzɔ nyaka ame Bɔkoꞌba koꞌdɔ yëyï teyi ne. ");
INSERT INTO bex_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Bɔkoꞌba koja solɔrɔ zïyï di mïtɔrɔ kiꞌdi nyaka ꞌbï kolɔꞌbɔ. Bo koja gɔ nyönyu rɔ mbëmbë zïyï ti layi. ");
INSERT INTO bex_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Bilaka pili ti koja laja zïyï. Kina lïjë pili ti kolɔdɔ bërï kömöyï. Ti këddï ti közï kakpa dɔ löndö yï ga pili. Kupö eꞌbe möyï ga ti kolɔdɔ bërï kömöyï. Lömu këdï dɔ bilaka ame ga pili kulömu yi, tine yëyï këdï dɔ bilaka ame ga pili koꞌdɔ yëyï zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisika ote toꞌdɔ yëyï nime. Kina mbowa di pötö Yakoba kënyï kari ꞌdeni tine na löndö bo ma löbu Esawu kömö ŋgï di bi toꞌbe yida. ");
INSERT INTO bex_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Bo oꞌdɔ akonyo ma koŋmi gbï koꞌde kako zi ꞌbu bo Yisika. Bo iya zi ꞌbu bo, iya te, “Baba, ënyï tɔrɔ konyo yida nime moꞌde zïyï ne gɔ koꞌdɔ yëyï zö.” ");
INSERT INTO bex_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yisika ititi, iya te, “Nï yë mo na?” Bo iya te, “Ma Esawu, kole dɔndende ꞌbï na.” ");
INSERT INTO bex_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kina rɔ Yisika kiꞌdi tïlëꞌdï ŋgï pili rɔ ma kënyë. Yisika iya te, “Yë mo na me pa kupö yida koꞌdɔ koꞌde zö bine monyo gba kinza kako dë moꞌdɔ yëyï ꞌdeni teyi ne? Yëyï nima öꞌbö ꞌdeni ŋburu rɔ abo.” ");
INSERT INTO bex_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lende nime Esawu kuwö te na bo kudu ŋgï rɔ ma kembe rɔ monɔ ma kënyë. Bo ileki kiya zi ꞌbu bo, iya te, “Oꞌdɔ yëyï gbï zö, baba.” ");
INSERT INTO bex_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yisika iya te, “Löndö yï ako bine kïndëndë ma ꞌdeni kogba yëyï ꞌbï.” ");
INSERT INTO bex_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu iya te, “Wa nime na dë ŋgï kïdëkï möyï bo rɔ Yakoba gɔmo ne? Mï rïyö abo ma bo kuꞌbölu ma na ꞌdeni me. Bo ogba rɔ löbu ma ꞌba tëdï rɔ kole ma dɔgba bine kina me bo kogba yëyï ma ꞌdeni gbï. Yëyï mɔtɔ inza kpe zö?” ");
INSERT INTO bex_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yisika ileki dɔmo zi Esawu, iya te, “Moꞌdɔ bo ꞌdeni rɔ löbu ꞌba döyï. Kina miꞌdi löndö bo ga ꞌdeni pili rɔ bɔ laja zi bo. Miꞌdi nyönyu ni ti layi ꞌdeni zi bo. Tine waꞌdi na gɔ moꞌdɔ gbɔ zïyï ya, kole ma?” ");
INSERT INTO bex_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu iya te, “Baba, ëddï ŋge ti yëyï kɔtɔ kpökï? Oꞌdɔ yëyï gbï zö.” Kina Esawu koloma ŋgï tudu rɔ ma kembe. ");
INSERT INTO bex_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Yisika ileki dɔmo zi bo, iya te, “Nyaka ꞌbï inza kolɔꞌbɔ. Solɔrɔ inza kako zïyï di mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tine ti koloma ꞌbëyï gɔ mbele ꞌba közïyï, ti këddï rɔ bɔ laja zi löndö yï. Ne ɔdɔ konyo burutu bo, ti kolɔ röyï ŋgï yaga di kɔmɔ közï bo.” ");
INSERT INTO bex_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esawu oꞌji Yakoba ŋgï rɔ ma kënyë gɔ ame ꞌbu bo kiꞌdi yëyï abo zi Yakoba ne. Bo omeri ti mï bo, iya te, “Kada ꞌba tölë ꞌba ꞌbu ze ɔwɔ dë kpe, kina ꞌdɔ mupö Yakoba yaga.” ");
INSERT INTO bex_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Lende kiya ꞌba Esawu nime ari kömö zi Rebeka, kina lɔko koja laja gɔ Yakoba kiya teyi, iya te, “Löndö yï Esawu ëdï kiteri ꞌdɔ tupö yi gɔ wa nime koꞌdɔ zi bo ne. ");
INSERT INTO bex_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kina me kole ma, oꞌdɔ wa ame ga miya ne. Ënyï welo kiriŋa kari zi löndö ma Labana mï Arana ");
INSERT INTO bex_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","koloma titi yayi ŋbö tiyeli ꞌba löndö yï kote rönï. ");
INSERT INTO bex_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ɔdɔ ya ꞌba löndö yï kote rönï ꞌdeni dɔ bo kudölu di gɔ wa ma koꞌdɔ zi bo nime tine, na ti moja laja ꞌjaa göyï. Gɔ waꞌdi na ꞌdɔ kpe kole ma ga koteke dɔye ŋgï kpaki rïyö di zö mï kada kɔtɔ teyi?” ");
INSERT INTO bex_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka iya zi Yisika, iya te, “Lende ꞌba ꞌja ꞌba Esawu rɔ yïtötï ꞌba eꞌbe Ete naga nime ɔdɔ ꞌdeni rɔma. Ɔdɔ kiya te Yakoba kogbe yïtötï ꞌba Ete ya naga nime gbï ti mölë gbɔ yaga.” ");
INSERT INTO bex_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kina Yisika kïdëkï Yakoba koꞌdɔ yëyï teyi, iya te, “Kinza kogbe yïtötï ꞌba Kanana naga nime dë. ");
INSERT INTO bex_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ënyï kari Padanarama liŋɔ ꞌba ꞌbu yï löbu Betowele ꞌdɔ kogbe nyiti ꞌba lano yï Labana ma kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bɔkoꞌba bɔ tigɔ dɔ kiteli koꞌdɔ yëyï zïyï kiꞌdi kole konzi zïyï gɔ këddï rɔ yï lïŋgï ꞌba bilaka ꞌba dɔꞌbe ma konzi. ");
INSERT INTO bex_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bo koꞌdɔ yëyï zïyï ti kupö yï ga kɔzɔ ma bo koꞌdɔ yëyï zi Abarayama. Yayi nime këddï koloma yïmo ame Bɔkoꞌba kiꞌdi ꞌdeni zi Abarayama ne ti këddï rɔ bɔ dɔmo.” ");
INSERT INTO bex_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yisika oja Yakoba kari Padanarama zi Labana kole ꞌba Betowele bɔ Arama tönë. Labana na rɔ löndö ꞌba Rebeka ma ꞌba Yakoba ni ti Esawu. ");
INSERT INTO bex_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawu ikali Yisika oꞌdɔ yëyï ꞌdeni zi Yakoba koja kari Padanarama ꞌdɔ kogbe ꞌja di yayi. Kina gbï di bi toꞌdɔ yëyï nima Yisika iya zi Yakoba kinza kogbe ꞌja dë di mï löŋgö yïtötï ꞌba Kanana. ");
INSERT INTO bex_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Kina me Yakoba kuwö dɔ ꞌbu bo ni ti ma bo ꞌdeni kënyï kari Padanarama. ");
INSERT INTO bex_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Gɔ köꞌdu nime na Esawu kikali ŋgï ꞌbu bo Yisika oꞌdɔkɔ wa mɔtɔ rɔ yïtötï ꞌba Kanana naga nima dë du te. ");
INSERT INTO bex_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kina bo kari zi Yisamele kole ꞌba Abarayama, bo kari kogbe nyiti mo Malata lëmï ꞌba Nebayota ꞌböwu rɔ ꞌja abo mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakoba ënyï di Berasaba kari nduwë kapa Arana. ");
INSERT INTO bex_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kada ari kösö dɔ bo bi mɔtɔ na bo köꞌdö ŋgï yï mökö yayi. Bo ogba kulugbï döku mɔtɔ bo kitaka dɔ bo timo. Kina ɔdɔ bo köꞌdö ꞌdeni tine ");
INSERT INTO bex_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","na nyï koꞌde dɔ bo tëgë, bo oꞌja bi tëkï kïdëyï di dɔyayi dɔndende mo kömö ŋbö mïtɔrɔ. Kina malayika koloma tïlëlë rönnï kebe gɔmo kako bërï, kari tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tine na bo koꞌja Bɔkoꞌba këdï kɔrɔ ŋgila bo yayi, kina Bɔkoꞌba kilende zi bo, iya te, “Ma na rɔ ŋere Bɔkoꞌba ma koŋgɔ gɔ ꞌbu yï löbu Abarayama ni ti ꞌbu yï Yisika. Dɔyayi nime këddï köꞌdö teyi ne mëdï miꞌdi zïyï ti kupö yï ga. ");
INSERT INTO bex_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Lïjë ti konzi kɔzɔ lupu kogba mï kapa ꞌba dɔyayi pili. Kina ti kupö yï na ti koꞌdɔ yëyï zi bilaka pili ꞌba dɔyayi. ");
INSERT INTO bex_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mëdï möꞌbö tïyï moŋgɔ göyï di mï gɔ bi ame ga pili këddï kari teyi ne, moꞌde yi kileki mï dɔyayi nime bine. Minza mola yi du kinza ma moꞌdɔ wa ame miꞌdi köꞌdu mo ꞌdɔ toꞌdɔ mo ne.” ");
INSERT INTO bex_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakoba indiŋi di bi töꞌdö, kiya te, “Wu, Bɔkoꞌba ëdï ŋgï mï gɔ bi nime, ma na mikali dë.” ");
INSERT INTO bex_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Bo rɔ tikere, na bo kiya te, “Gɔ bi waꞌdi na koro te? Ala mɔtɔga liŋɔ ꞌba Bɔkoꞌba na, ala kpadörï ꞌba mïtɔrɔ na?” ");
INSERT INTO bex_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakoba ënyï mɔlo mï dɔŋbɔ kogba kulugbï döku nima bo kitaka dɔ bo pa timo ne kïdëyï dɔmo tɔrɔ, kina bo kogba ꞌbu kodɔ dɔmo. ");
INSERT INTO bex_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Bo iꞌdi möyï gɔ bi nima rɔ Betele, tine gawo ma ŋgɔsi ŋgila gɔ bi mo nima yayi, möyï mo ïdëkï pa rɔ Luza. ");
INSERT INTO bex_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakoba oꞌdɔ lömu zi Bɔkoꞌba, iya te, “Ɔdɔ nï Bɔkoꞌba koloma ŋgï tö koŋgɔ gɔma di mï liŋgere ma nime mëdï mari teyi ne, koja gɔ akonyo zö gbï ti bɔŋgɔ tusu mo rɔma, ");
INSERT INTO bex_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kileki ma ŋbö mï liŋɔ ꞌba ꞌbu ma ti mï këyï, nï na ti köꞌbö ŋgï rɔ ŋere Bɔkoꞌba ma rɔ ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kina döku nime mïdëyï dɔmo ne ti këdï ŋgï rɔ bi ꞌba toꞌdɔ mötu zïyï di teyi. Wa ame ga pili kiꞌdi zö ti miꞌdi kapa ma ꞌbutë mo zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakoba ari nduwë mï liŋgere abo nima kala mï dɔyayi ma kapa kari yïbï. ");
INSERT INTO bex_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Bo ari kömö mï löwu mɔtɔ ti daa teyi dɔtumu ꞌba kamölö mota köꞌdö ꞌdeni bërï kpamo yayi. Daa nima na këdï kiꞌdi mini zi kamölö naga nima di teyi. Tine döku ma kutuꞌbö kpa daa mo nima timo rɔ ma löbu, ");
INSERT INTO bex_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ɔdɔ bɔ koda kamölö naga nima kotɔtɔ rönnï ꞌdeni pili tine, na ꞌjaa lïjë koloma tululu döku nima yaga kiꞌdi mini zi kamölö ꞌbënnï ga, kina lïjë kululu ꞌjaa ꞌböwu kileki gɔ bi mo. ");
INSERT INTO bex_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakoba ititi bɔ koda kamölö naga nima, iya te, “Kpe di gɔ bi ma yala ga ya, löndö?” Lïjë iya te, “Ze di Arana.” ");
INSERT INTO bex_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Bo ileki kititi lïjë, iya te, “Ikalike bɔ mɔtɔ rɔ Labana kole ꞌba Nawura?” Lïjë iya te, “Yëë, dikali bo.” ");
INSERT INTO bex_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Bo ititi lïjë, iya te, “Bo ëdï le?” Lïjë iya te, “Bo ëdï le. Nyiti abo Rayile na me ꞌdë këdï rɔ tako ti kamölö abo ga.” ");
INSERT INTO bex_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Bo iya te, “Kada gba mbiri bi ꞌba totɔtɔ dɔ kamölö mï jɔlɔ na dë gba. Iꞌdike mini zïnnï lïjë kari tonyo kpënnï.” ");
INSERT INTO bex_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Lïjë iya te, “Inza tara, dëdï doda bɔ koda kamölö mɔtɔ ga kotɔtɔ rönnï pili titi kako tine, na ꞌjaa gɔ dululu döku yaga diꞌdi mini zi kamölö.” ");
INSERT INTO bex_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Koꞌja Yakoba këdï gba tilende ti ya naga nima, na Rayile kömö ŋgï ti kamölö ꞌba ꞌbu nï römöyï lɔko na rɔ bɔ koda mo. ");
INSERT INTO bex_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kina ɔdɔ Yakoba koꞌja Rayile kömö ꞌdeni ti kamölö ꞌba lano bo Labana ga tara tine, na bo kari ŋgï kululu döku tönë yaga di kpa daa nima kiꞌdi mini zi kamölö naga nima. ");
INSERT INTO bex_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kina bo kumötö Rayile bo kudu rɔ ma kembe. ");
INSERT INTO bex_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Bo iya te, “Ma lano ꞌba ꞌbu yï na. Ma kole ꞌba Rebeka na.” Kina Rayile kiriŋa ŋgï kari kiya lende mo zi ꞌbu nï. ");
INSERT INTO bex_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kina ɔdɔ Labana kuwö lende ꞌba kole ꞌba lëmï bo ꞌdeni tara tine, na bo kiriŋa kurë dɔmo kiramo kome mbili mo, bo koꞌde kako liŋɔ. Yakoba ïyëtï gɔ lende naga nime pili zi Labana. ");
INSERT INTO bex_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Tine Labana ileki dɔmo, iya te, “Rɔ ma laka nï roma ma na.” Yakoba oloma koꞌdɔ nyepe kɔtɔ yayi, ");
INSERT INTO bex_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","kina Labana kiya zi bo, iya te, “Ëddï koꞌdɔ ndɔbɔ zö rɔ ma sari gɔ ame ze rɔ wado ne, tine moꞌdɔkɔ dë ꞌdɔ köꞌbö toꞌdɔ mo tara. Iya wa ame koꞌdɔkɔ ne gɔ mopi zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labana ëdï ti yïtötï rïyö, möyï ma löbu mo rɔ Leya, tine ma titi mo möyï mo rɔ Rayile. ");
INSERT INTO bex_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ele ŋge di kɔmɔ mo, tine Rayile ele ꞌbënï ŋgï rɔ mbëmbë kpaki ti yida rɔmo. ");
INSERT INTO bex_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakoba ɔꞌɔ Rayile, gɔ köꞌdu mo na bo kiya te, “Mëdï moꞌdɔ ndɔbɔ kɔmɔ kɔɔ modɔmorïyö zïyï ꞌdɔ kiꞌdi Rayile zö mogbe.” ");
INSERT INTO bex_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labana ileki dɔmo, iya te, “Ma laka mo na ꞌdɔ miꞌdi lɔko zïyï di dɔ ame ꞌdɔ miꞌdi lɔko zi bilaka mɔtɔ ne. Oloma tö bine.” ");
INSERT INTO bex_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakoba oꞌdɔ ndɔbɔ kɔmɔ kɔɔ modɔmorïyö gɔ Rayile, tine inda ŋgï di zi bo kɔzɔ töꞌdö dɔ ndö tara römöyï bo ɔꞌɔ lɔko rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kina Yakoba kiya zi Labana, iya te, “Kɔɔ ꞌba ndɔbɔ ma ote rönï ꞌdeni, iꞌdi ꞌja ma zö.” ");
INSERT INTO bex_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labana oja karama ꞌba gbe kose bilaka ꞌba mï gɔ bi nima yayi pili kotɔtɔ rönnï kako yïmo. ");
INSERT INTO bex_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tine mï korɔndɔ mo nima, Leya na za Labana koꞌde koja gɔ Yakoba köꞌdö timo. ");
INSERT INTO bex_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labana iꞌdi nyiti atɔli abo mɔtɔ möyï mo rɔ Zilepa zi nyiti abo Leya rɔ bɔ laja. ");
INSERT INTO bex_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mï dɔŋbɔ tine, na Yakoba koŋgɔ za ꞌböwu rɔ Leya. Kina bo kënyï kari kititi Labana, iya te, “Waꞌdi na me koꞌdɔ zö te ne? Moꞌdɔ ndɔbɔ nime zïyï gɔ Rayile, gɔ waꞌdi na kebe kïndëndë ma?” ");
INSERT INTO bex_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labana iya te, “Mï dölëtï ꞌbeze bine, ogbe nyiti ma titi dë dɔgba kola nyiti ma löbu. ");
INSERT INTO bex_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ne oda töꞌdö dɔ modɔmorïyö ꞌba karama ꞌba gbe nime kote rönï titi ꞌdɔ miꞌdi Rayile gbï zïyï, ɔdɔ koꞌdɔkɔ toꞌdɔ ndɔbɔ gbï zö kɔmɔ kɔɔ modɔmorïyö mɔtɔ.” ");
INSERT INTO bex_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakoba utï gɔmo. Kina ɔdɔ töꞌdö dɔ modɔmorïyö ꞌba karama ꞌba gbe nima kote rönï ꞌdeni tine, na Labana kogba nyiti abo Rayile kiꞌdi gbï rɔ ꞌja zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labana iꞌdi nyiti atɔli abo mɔtɔ möyï mo rɔ Bila zi Rayile rɔ bɔ laja. ");
INSERT INTO bex_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakoba öꞌdö gbï ti Rayile, tine Rayile na bo kɔꞌɔ rɔ dɔ kiteli kebe Leya. Kina bo koꞌdɔ ndɔbɔ ꞌböwu zi Labana kɔmɔ kɔɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kina ɔdɔ Bɔkoꞌba koŋgɔ Yakoba kɔꞌɔ Leya dë laka kɔzɔ a nima tara tine, na Bɔkoꞌba koja gɔ löyö ŋgï zïnï. Rayile ɔrɔ ꞌbënï ŋgï rɔ kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya ɔmɔ köyö rɔ kole bɔtɔni, kina lɔko kiꞌdi möyï mo rɔ Rubënï, ame kiya te “Oŋgɔ lisa,” römöyï lɔko iya te, “Bɔkoꞌba oŋgɔ lisa ma ꞌdeni, mëꞌdë ma ti kɔꞌɔ ma nati.” ");
INSERT INTO bex_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kina lɔko kɔmɔ ꞌböwu köyö kole mɔtɔ. Lɔko iya te, “Bɔkoꞌba uwö ꞌdeni ma kɔꞌɔ ma dë kina me bo kiꞌdi kole nime ꞌdeni gbï zö.” Kina lɔko kiꞌdi möyï mo rɔ Simona, ame kiya te “Uwö.” ");
INSERT INTO bex_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lɔko ɔmɔ ꞌböwu köyö kole mɔtɔ. Kina lɔko kiya te, “Ame tine, mëꞌdë ma ëdï kodɔꞌbɔ rönï köꞌbö tö römöyï möyö kole ꞌdeni mota zi bo.” Na lɔko kiꞌdi möyï mo rɔ Lëwë, ame kiya te “Odɔꞌbɔ.” ");
INSERT INTO bex_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lɔko ɔmɔ ꞌböwu köyö kole mɔtɔ. Kina lɔko kiya te, “Ame tine ti mïlëlu Bɔkoꞌba.” Na lɔko kiꞌdi möyï mo rɔ Yuda, ame kiya te “Lëlu.” Tine na lɔko kɔrɔ ŋgï, lɔko öyö kole mɔtɔ dë kpe titi di gɔ ama. ");
INSERT INTO bex_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kina ɔdɔ Rayile koŋgɔ ꞌdeni lɔko köyö kole dë zi Yakoba kɔzɔ a nima tara tine, na lɔko kombi mïnï ŋgï rɔ lëmï nï. Gɔ köꞌdu mo na lɔko kiya zi Yakoba, iya te, “Ɔdɔ kiꞌdi kole dë zö ti mölë yaga.” ");
INSERT INTO bex_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakoba ënyï rɔ ꞌdïrï tïnï, kiya te, “Ma na rɔ Bɔkoꞌba? Oꞌja Bɔkoꞌba na kiꞌdi löyö dë zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Lɔko iya te, “Bila nyiti bɔ laja ma na me, öꞌdö timo ꞌdɔ lɔko köyö kole zö. Tïnï na ti mëdï rɔ ma ꞌba kole.” ");
INSERT INTO bex_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kina lɔko kiꞌdi Bila rɔ ꞌja zi mëꞌdë nï, kina bo köꞌdö timo. ");
INSERT INTO bex_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila ɔmɔ köyö kole zi Yakoba, ");
INSERT INTO bex_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","kina Rayile kiya te, “Bɔkoꞌba oꞌdɔ burë ma ꞌdeni laka. Bo uwö akititi ma ꞌdeni bo kiꞌdi kole zö.” Kina lɔko kiꞌdi möyï mo rɔ Dana, ame kiya te “Burë.” ");
INSERT INTO bex_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila ɔmɔ ꞌböwu köyö kole mɔtɔ zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rayile iya te, “Moꞌdɔ ya ꞌdeni ti lëmï ma rɔ ma kënyë ŋbö maꞌda.” Kina lɔko kiꞌdi möyï mo rɔ Napatali, ame kiya te “Ya.” ");
INSERT INTO bex_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kina ɔdɔ Leya koŋgɔ lɔko kɔrɔ ꞌdeni di bi töyö kole tara tine na lɔko kogba Zilepa bɔ laja ꞌbënï kiꞌdi zi Yakoba rɔ ꞌja. ");
INSERT INTO bex_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kina Zilepa köyö kole zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya iya te, “Mëdï ti gɔ kele.” Kina lɔko kiꞌdi möyï mo rɔ Gada, ame kiya te “Gɔ kele.” ");
INSERT INTO bex_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilepa ɔmɔ ꞌböwu köyö kole mɔtɔ zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya iya te, “Ma ꞌdeni rɔ lɔŋɔ. ꞌJa ma laki pili ti kïdëkï ma rɔ bɔ lɔŋɔ.” Kina lɔko kiꞌdi möyï mo rɔ Asera, ame kiya te “Lɔŋɔ.” ");
INSERT INTO bex_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mï kada ꞌba tumu nyönyu na Rubënï kari koꞌja liŋga ꞌba löyö di mï nyaka kogba kako timo liŋɔ kiꞌdi zi ma bo Leya. Rayile iya zi Leya, iya te, “Iꞌdi liŋga nima kole ꞌbï koꞌja ne zö.” ");
INSERT INTO bex_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tine Leya ileki dɔmo, iya te, “Mëꞌdë ma nima kolɔ ne ɔꞌbɔ yi dë gba? Kina me këddï kiteri ꞌböwu ꞌdɔ togba liŋga nime kole ma koꞌja ne?” Rayile iya te, “Ɔdɔ kiꞌdi liŋga nima zö, Yakoba ëdï köꞌdö göyï mï korɔndɔ nime tɔne.” ");
INSERT INTO bex_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kina mï dɔkɔpiyari koꞌja Yakoba këdï kileki ꞌdeni kako di mï nyaka tine na, Leya kurë dɔ bo, kiya te, “Ëddï kako köꞌdö tɔne gɔma römöyï mugö yi ꞌdeni di zi Rayile ti liŋga nime kole ma koꞌja ne.” Kina Yakoba köꞌdö tïnï mï korɔndɔ nima. ");
INSERT INTO bex_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bɔkoꞌba ileki dɔ akititi ꞌba Leya kiꞌdi lɔko kɔmɔ köyö kole ma mï muyï ꞌbënï zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lɔko iya te, “Bɔkoꞌba iꞌdi kpa közï ꞌdeni zö römöyï miꞌdi bɔ laja ma zi mëꞌdë ma.” Kina lɔko kiꞌdi möyï mo rɔ Yisakara, ame kiya te “Kpa közï.” ");
INSERT INTO bex_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya ɔmɔ ꞌböwu köyö kole ma mï modɔɔkɔtɔ zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lɔko iya te, “Bɔkoꞌba iꞌdi kpa közï ma dɔ kiteli ꞌdeni zö. Mëꞌdë ma ëdï koꞌdɔkɔ ma, römöyï möyö kole ꞌdeni modɔɔkɔtɔ zi bo.” Kina lɔko kiꞌdi möyï mo rɔ Zebolona, ame kiya te “Toꞌdɔkɔ.” ");
INSERT INTO bex_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Di gɔmo na lɔko köyö nyiti kiꞌdi möyï mo rɔ Dina. ");
INSERT INTO bex_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Bɔkoꞌba oŋgɔ Rayile koja gɔ löyö teyi. ");
INSERT INTO bex_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Kina lɔko kɔmɔ köyö kole. Lɔko iya te, “Bɔkoꞌba ogba rɔ kaya ꞌdeni yaga di dɔma. ");
INSERT INTO bex_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Bɔkoꞌba koja gɔ kole mɔtɔ tɔ kpe gbï zö.” Kina lɔko kiꞌdi möyï mo rɔ Yesepa, ame kiya te “Mɔtɔ gbï.” ");
INSERT INTO bex_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Di pötö töyö Yesepa na Yakoba kiya zi Labana, iya te, “Iꞌdi mileki mari mï dɔyayi ze. ");
INSERT INTO bex_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Iꞌdi ꞌja ma ga ti kole ma ga ame moꞌdɔ ndɔbɔ gɔmo zïyï ne ꞌdɔ mari. Ikali ndɔbɔ ame moꞌdɔ zïyï ne ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tine Labana iya te, “Iꞌdi miya lende nime. Mumë ꞌdeni ti ꞌbɔsi ma, Bɔkoꞌba ëdï koꞌdɔ yëyï dɔma nime gɔ köꞌdu ꞌbï. ");
INSERT INTO bex_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Iya wa ma koꞌdɔkɔ ꞌdɔ mopi zïyï. Kina mëdï miꞌdi ŋgï pili zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakoba iya te, “Ikali ndɔbɔ laka ame moꞌdɔ zïyï ne ꞌdeni kina ikali ma yërï ꞌbï ga kara ꞌdeni gbï mï ndɔbɔ koꞌdɔ ma. ");
INSERT INTO bex_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Mï kada ma tönë mako ne yërï ꞌbï ga ŋgï ndö te, ne oŋgɔ te kina me kara ꞌdeni ŋgï leꞌjete konzi rɔ mbëmbë. Kina Bɔkoꞌba oꞌdɔ yëyï ꞌdeni gbï nduwë zïyï di mï gɔ bi ame ga moloma tari teyi. Kina me kada ma ꞌbama ömö ꞌdeni ꞌdɔ moŋgɔ gɔ wa ma rɔ ꞌba gbagba ma ga.” ");
INSERT INTO bex_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labana ititi, iya te, “Waꞌdi na gɔ mopi zïyï?” Yakoba iya te, “Moꞌdɔkɔ a mɔtɔ dë gɔ kopi zö. Mëdï möꞌbö nduwë toŋgɔ gɔ yërï ꞌbï ga ɔdɔ kutï gɔ lende nime. ");
INSERT INTO bex_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Iꞌdi milaki kebe mï löŋgö yërï ꞌbï naga nima ꞌdɔ migeli kole kamölö ma kölu naga ti kole banya ma kumöru naga. Wa naga nime na ŋge moꞌdɔkɔ. ");
INSERT INTO bex_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ti kikali laka ma ꞌjaa ɔdɔ kako toŋgɔ yërï ame ga mogba ꞌdeni ne kada mɔtɔ. Ɔdɔ koꞌja banya ame ga kinza rɔ ma kumöru ne ti kamölö ame ga kinza rɔ ma kölu ne mï löŋgö ꞌbama naga nime ti kikali ŋgï rɔ ꞌbögö.” ");
INSERT INTO bex_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labana iya te, “Ele, doꞌdɔ kɔzɔ ame kiya ne tara.” ");
INSERT INTO bex_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tine mï kada mo nima na Labana kigeli banya ma kumöru naga kpaki ti ame ga ti kïnë ma kaŋmi rɔmo ne ti kamölö ma kölu naga me yaga. Kina bo kiꞌdi kole abo ga toda mo ");
INSERT INTO bex_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","tine na bo kënyï kari tïnnï kiliŋgere ŋbö töꞌdö dɔ mota koto yaga rɔ ma kɔwɔ di ŋgila ama ga ti Yakoba ne. Yakoba oloma nduwë toda kɔsɔ yërï ꞌba Labana naga nima. ");
INSERT INTO bex_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kïnë ŋgërï mota mɔtɔ ga yayi Yakoba ënyï koke dɔŋgila ma kaꞌji mo ga rɔ nyigbara kopepe yɔkɔ mo yaga kola rɔmo rɔ ma kumöru. ");
INSERT INTO bex_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Bo ako timo kuruwö kɔmɔ yërï naga nima kpa gɔ bi ame lïjë këdï kuwë mini di teyi. Bo uruwö yayi römöyï yërï naga nima bi ꞌba tëkï mo na di kpa mini. ");
INSERT INTO bex_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Gɔ köꞌdu mo na banya ame ga këkï di yayi kuyï kömönnï dɔ ŋgërï naga nima ne köyö kole ŋgï me rɔ ma kumöru. ");
INSERT INTO bex_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakoba oza kamölö mo ga yaga di rɔ banya kina bo kiꞌdi lïjë kuyï kömönnï kari dɔ yërï ma kumöru ti ma kölu ame ga mï löŋgö yërï ꞌba Labana ga yayi ne. Wa nime na kiꞌdi Yakoba këdï ti dɔtumu ꞌba yërï koza ꞌberi yaga di rɔ ꞌba Labana ga. ");
INSERT INTO bex_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ɔdɔ yërï ma kɔnɔ naga këdï këkï na Yakoba kuruwö ŋgërï naga nima kɔmɔ mo di kpa gɔ bi ꞌba tuwë mini yayi ꞌdɔ lïjë këkï di mï löŋgö mo. ");
INSERT INTO bex_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tine bo uruwö dë kɔmɔ yërï ma kilike naga. Gɔ köꞌdu mo na yërï ma kilike naga ŋgï me rɔ ꞌba Labana, tine ma kɔnɔ naga ŋgï me rɔ ꞌba Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kina Yakoba koloma ŋgï rɔ bɔ mɔri ti dɔtumu ꞌba kamölö ni ti banya rɔ ma konzi, gbï ti atɔli ti gamele ti akaca. ");
INSERT INTO bex_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakoba ari kuwö köꞌdu mo kole ꞌba Labana ga këdï rɔ tiya mo, iya te, “Yakoba otɔtɔ wa ꞌba ꞌbu ze ga ꞌdeni kote. Wa ꞌba ꞌbu ze ga na me bo koꞌdɔ mɔri ꞌdeni timo.” ");
INSERT INTO bex_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Bo oŋgɔ gbï Labana inza kpe rɔ ma laka ti bo kɔzɔ ma dɔgba. ");
INSERT INTO bex_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kina Bɔkoꞌba kilende zi Yakoba, iya te, “Ileki kari mï dɔyayi ꞌbe mï löŋgö eꞌbe ꞌbu yï ga. Mëdï möꞌbö tïyï.” ");
INSERT INTO bex_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kina Yakoba koja laja gɔ Rayile ni ti Leya kako zi bo mï löwu nima bo këdï koda kamölö abo ga yïmo yayi ne. ");
INSERT INTO bex_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Kina bo kiya zïnnï, iya te, “Moŋgɔ ꞌdeni ꞌbu ye inza kpe rɔ ma laka tö kɔzɔ ma dɔgba. Ne Bɔkoꞌba ꞌba ꞌbu ma ni ëdï tö. ");
INSERT INTO bex_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ikalike ꞌdeni ma moꞌdɔ ndɔbɔ zi ꞌbu ye ti tigɔ ma pili. ");
INSERT INTO bex_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tine pele tara bo öꞌbö nduwë tuyï dɔŋgala zö. Kpa közï ꞌba ndɔbɔ ame mëdï moꞌdɔ ne bo uyï yïmo mï ꞌbutë, tine Bɔkoꞌba na këdï kitata ma di zi bo. ");
INSERT INTO bex_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ɔdɔ bo kiya te, ‘Banya ma kumöru naga nima këdï pili rɔ kpa közï zïyï,’ kina banya köyö ŋgï me rɔ ma kumöru. Kina ɔdɔ bo kiya te, ‘Banya ma kuꞌdu kïnë kaŋmi naga nima këdï pili rɔ kpa közï zïyï,’ kina banya köyö ŋgï me rɔ ma kuꞌdu kïnë kaŋmi. ");
INSERT INTO bex_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bɔkoꞌba ogba yërï ꞌdeni me di zi ꞌbu ye kiꞌdi zö. ");
INSERT INTO bex_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Mï kada ame rɔ bi ꞌba töyö ma laka ꞌba yërï ne, nyï oꞌde dɔma mombi kɔmɔ ma moꞌja moꞌde banya ame ga këdï këkï ne ꞌdeni me rɔ ma kumöru ti ma kuꞌdu kïnë kaŋmi. ");
INSERT INTO bex_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malayika ꞌba Bɔkoꞌba ïdëkï ma di mï nyï nima, iya te, ‘Yakoba.’ Miya te, ‘Ma na me.’ ");
INSERT INTO bex_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Malayika nima iya zö, iya te, ‘Ombi kömöyï koŋgɔ moꞌde ame ga pili këdï këkï ne ꞌdeni me rɔ ma kumöru ti ma kuꞌdu kïnë kaŋmi, römöyï moꞌja wa ma Labana këdï koꞌdɔ zïyï ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ma na rɔ Bɔkoꞌba ma tönë kɔdɔ kileme rönï zïyï di Betele, tönë ꞌdɔ kïdëyï döku yayi kodɔ ꞌbu dɔmo kulömu röyï gbï zö ne. Ënyï di mï dɔyayi nime kileki kari mï dɔyayi ma köyö yi teyi.’ ” ");
INSERT INTO bex_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rayile ni ti Leya ileki dɔmo zi Yakoba, iya te, “Wa mɔtɔ inza kpe zize ame gɔ dogba rɔ apötö di zi ꞌbu ze. ");
INSERT INTO bex_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Bo oꞌdɔ ze kɔzɔ bɔ löwö, bo kugö ze mökö. Kina me bo kïyölu yamo ꞌba dɔze ꞌdeni pili yaga. ");
INSERT INTO bex_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Wa naga nime pili Bɔkoꞌba kogba yaga di zi ꞌbu ze ne, eze ga na zi kole ze ga. Wa ame Bɔkoꞌba kiya zïyï ne oꞌdɔ ŋgï.” ");
INSERT INTO bex_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakoba iꞌdi kole abo ga ti ꞌja abo ga dɔ gamele ");
INSERT INTO bex_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","bo kënyï dɔmo di yayi ti wa ame ga pili bo koꞌja di Padanarama yayi ne, kina bo koga dɔtumu ꞌba yërï abo ga pili kɔmɔ bo tari mï dɔyayi ꞌba Kanana zi ꞌbu bo Yisika. ");
INSERT INTO bex_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tine mï tënyï ꞌbënnï Labana ari ꞌdeni mɔlo bi kɔwɔ tumu sunë kamölö abo ga kina Rayile kuꞌbögö akoro ꞌba ꞌbu nï ŋgï kari timo. ");
INSERT INTO bex_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakoba ïndëndë Labana kënyï ŋgï kinza ma bo kose gɔ bo kiya te bo ëdï ꞌdeni kari. ");
INSERT INTO bex_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Bo iriŋa di yayi ti wa ame ga pili rɔ ꞌba bo ne bo kumu dɔ yöpö Epurate bo kuyï kɔmɔ bo kari yɔki dɔyayi kuruŋgu ꞌba Gilada. ");
INSERT INTO bex_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Di pötö töꞌdö dɔ mota tine na Labana kuwö köꞌdu mo ꞌjaa iya te, Yakoba iriŋa ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kina bo kotɔtɔ bilaka abo ga lïjë kozi gɔ Yakoba ŋbö töꞌdö dɔ modɔmorïyö kari kota gɔmo mï dɔyayi kuruŋgu ꞌba Gilada. ");
INSERT INTO bex_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mï korɔndɔ mo nima na Bɔkoꞌba kako kilende zi Labana ti nyï, iya te, “Iꞌdi kömöyï kandi laka kinza kiya wa ma kënyë mɔtɔ dë zi Yakoba.” ");
INSERT INTO bex_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakoba oga taya abo ꞌdeni dɔ kuruŋgu yayi tine na Labana ni ti bilaka ma ꞌba bo ga koga taya gbï yayi. ");
INSERT INTO bex_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labana iya zi Yakoba, iya te, “Waꞌdi na me koꞌdɔ te kuꞌbölu ma kogba yïtötï ma ga kënyï timo kɔzɔ ꞌbɔki ma kindaꞌba di mï ya? ");
INSERT INTO bex_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Gɔ waꞌdi na kuꞌbölu ma kusu röyï kinza kose göyï zö? Ma këdï kiya ra dëne ꞌdɔ moja yi gɔ kɔri ti lɔŋɔ ti ŋgala ti birɔ ꞌba tɔmo ni ti lërï. ");
INSERT INTO bex_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ne gɔ waꞌdi na kënyï ŋgï kinza ma kiꞌdi mome mbili yïtötï ma ga ti kole ꞌbënnï ga moꞌdɔ mötö zïnnï? Lende dɔ rumö nime koꞌdɔ ne. ");
INSERT INTO bex_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mëdï ti tigɔ ꞌba ꞌdɔ toꞌdɔ yi rɔ ma kënyë, ne Bɔkoꞌba ꞌba ꞌbu yï ilende zö ti korɔndɔ ene, iya te, miꞌdi kɔmɔ ma kandi laka kinza miya wa ma kënyë mɔtɔ dë zïyï. ");
INSERT INTO bex_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mikali ꞌdeni lende ꞌba liŋɔ ꞌbe na kɔꞌɔ röyï kiꞌdi yi këddï kari. Ne gɔ waꞌdi na kuꞌbögö akoro ma?” ");
INSERT INTO bex_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakoba iya te, “Ma rɔ tikere römöyï miya te mɔtɔga ti kolɔ yïtötï ꞌbï ga yaga di zö. ");
INSERT INTO bex_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ne ɔdɔ kiya te koꞌja akoro ꞌbï nima di zi bilaka mɔtɔ bine, bɔ mo tɔ nima ëdï kölë tɔne yaga. Bilaka ze ga na me, oma wa ame ga rɔ ꞌbëyï ne kigeli yaga ꞌdɔ kömönnï pili koꞌja.” Yakoba ikali dë ma Rayile na kuꞌbögö akoro ꞌba Labana nima. ");
INSERT INTO bex_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labana ɔdɔ koma mï rö kilaka ꞌba Yakoba, bo kolɔlɔ kari koma mï ꞌba Leya, bo kari ꞌböwu koma mï ꞌba Bila ni ti Zilepa. Tine bo oꞌja akoro abo naga nima dë du te. Kina bo kari kɔdɔ mï rö ꞌba Rayile toma yïmo. ");
INSERT INTO bex_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rayile ogba akoro naga nima ꞌdeni kusu dɔmo mï kilaka bi loma ꞌba gɔ gamele kiꞌdi ꞌdeni rö yayi lɔko koloma dɔmo. Labana oma mï rö nima pili tine oꞌja akoro abo dë du te. ");
INSERT INTO bex_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rayile iya zi ꞌbu nï, iya te, “Ŋere ma, kinza kënyï dë rɔ ꞌdïrï tö gɔ ame mënyï dë tɔrɔ zïyï ne, römöyï mëdï ti a dɔ ꞌja.” Gɔ köꞌdu mo na Labana koma ŋgï le koꞌja akoro naga nima dë. ");
INSERT INTO bex_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kina Yakoba kënyï ŋgï rɔ ꞌdïrï ti Labana kititi, iya te, “Lende kënyë waꞌdi na moꞌdɔ? Wa ma mirasi zïyï kiꞌdi koga gɔma kulöwö rɔ ma kututu gɔmo ne na rɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wa ma ga na me koma yïmo ꞌdeni me, ne ëꞌbï ma koꞌja di mï löŋgö mo ga bine ëdï yala? Ne ɔdɔ këdï, oja yaga bine kɔmɔ bilaka ꞌbï ga ti ꞌbama ga koŋgɔ gɔ lïjë kiya lende ma laka mo mï löŋgö ze tïyï. ");
INSERT INTO bex_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Mï kɔmɔ kɔɔ ꞌbutë rïyö naga nime moꞌdɔ tïyï ne kamölö ti banya ꞌbï ga öꞌbö dë kinza töyö, monyo muruku ma kɔtɔ te dë di mï löŋgö dɔtumu ꞌba yërï ꞌbï ga. ");
INSERT INTO bex_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ame ga kuruku kindaꞌba mopi gɔ bi mo ŋgï teyi moꞌde lende mo dë gbï yɔ kako zïyï. Ame ga kuꞌbögö rɔ mï korɔndɔ ala rɔ mï kada ne mopi gɔ bi mo teyi kɔzɔ ma kiya zö toꞌdɔ mo. ");
INSERT INTO bex_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","41","Mï kɔmɔ kɔɔ ꞌbutë rïyö naga nime moꞌdɔ tïyï ne, kada oŋma ma rɔ gɔ bi këzë pili, bi këyï okpe yïmö kote korɔndɔ a mɔtɔ rɔ töꞌdö kindaꞌba kɔmɔ ma dë. Moꞌdɔ ndɔbɔ zïyï kɔmɔ kɔɔ ꞌbutë dɔmosowɔ gɔ yïtö rïyö ꞌbï naga nime, kina me moꞌdɔ ꞌböwu kɔmɔ kɔɔ modɔɔkɔtɔ gɔ kiꞌdi dɔtumu ꞌba yërï ꞌbï mɔtɔ ga zö. Ne pele öꞌbö tuyï mï kpa közï ma mï ꞌbutë. ");
INSERT INTO bex_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ma kiya te Bɔkoꞌba ꞌba ꞌbu ma Abarayama ame bo na gbï Yisika kere ne kinza gɔma dëne me oja ma ꞌdeni mari rɔ közï sari. Bɔkoꞌba oŋgɔ gomɔ ma ti ndɔbɔ ame moꞌdɔ zïyï ne kina ma bo kamo döyï ti korɔndɔ ene.” ");
INSERT INTO bex_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labana ileki dɔmo zi Yakoba, iya te, “Yïtötï ma ga na pili ma. Kole naga nima pili rɔ kole ma ga. Dɔtumu ꞌba yërï naga nima pili rɔ ama ga. Wa naga nime pili këddï koŋgɔ ne me rɔ ama ga. Tine a mɔtɔ inza ma ꞌdɔ moꞌdɔ tota gɔ yïtötï ma naga nime ti kole ma lïjë köyö naga nime di zïyï. ");
INSERT INTO bex_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ako doꞌdɔ lömu tïyï. Ako dotɔtɔ kulugbï döku dulu dɔmo bine ꞌdɔ koloma rɔ kïnë ꞌba lömu nime doꞌdɔ ꞌdeni mï löŋgö ze tïyï ne.” ");
INSERT INTO bex_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kina Yakoba kogba döku kïdëyï dɔmo tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Bo iꞌdi bilaka abo ga kotɔtɔ kulugbï döku kulu dɔmo. Kina lïjë konyo kpënnï di ŋgila döku nima kulu dɔmo yayi ne. ");
INSERT INTO bex_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labana ïdëkï möyï gɔ bi nima rɔ Yegara Saduta, tine Yakoba ïdëkï rɔ Galede. ");
INSERT INTO bex_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labana iya zi Yakoba, iya te, “Döku nime ꞌdeni rɔ lende kileme mï löŋgö ze tïyï.” Gɔ köꞌdu mo na kïdëkï möyï gɔ bi nima ŋgï rɔ Galede, ame kiya te “Döku ꞌba akileme.” ");
INSERT INTO bex_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Labana ileki gbï, kiya te, “Bɔkoꞌba kiꞌdi kömönï nduwë köꞌbö toŋgɔ ze mï rɔ koza ze nime.” Gɔ köꞌdu nime na kïdëkï möyï gɔ bi nima ŋgï rɔ Mizapa, ame kiya te “Kilaŋga koda wa.” ");
INSERT INTO bex_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labana iya te, “Ɔdɔ koꞌdɔ yïtötï ma naga nime rɔ ma kënyë ala ebe kogbe ꞌja mɔtɔ ga ame muwö köꞌdu mo dë pele, zïyï tikali mo laka kɔmɔ Bɔkoꞌba ëdï toŋgɔ ze. ");
INSERT INTO bex_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Döku nime mulu dɔmo ti ma mïdëyï dɔmo nime ");
INSERT INTO bex_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ti köꞌbö rɔ lende kileme mï löŋgö ze tïyï. A mɔtɔ minza miteli dɔ döku nime mari moꞌdɔ ya tïyï kina a mɔtɔ inza kiteli dɔ döku nime gbï ala ma mïdëyï dɔmo nime kako koꞌdɔ ya tö. ");
INSERT INTO bex_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bɔkoꞌba ꞌba Abarayama ti ꞌba Nawura ti Bɔkoꞌba ꞌba ꞌbu nnï ga koŋgɔ lende nime mï löŋgö ze tïyï.” Yakoba ulömu rɔ bo ti möyï Bɔkoꞌba ame ꞌbu bo Yisika kere ne ");
INSERT INTO bex_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","kina bo kumu roma zi Bɔkoꞌba dɔ döku nima yayi. Bo ïdëkï bilaka abo ga kako tonyo akonyo nima lïjë köꞌdö dɔ kuruŋgu nima yayi. ");
INSERT INTO bex_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mɔlo mï dɔŋbɔ na Labana kome mbili yïtö abo ga ti kole ꞌbënnï ga bo kumötö lïjë gbɔ na bo kuyï dɔ bo ŋgï kileki liŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakoba ënyï di yayi kari nduwë mï liŋgere abo nima, kina malayika mɔtɔ ga ꞌba Bɔkoꞌba kako kondɔsɔ ti bo. ");
INSERT INTO bex_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kina ɔdɔ Yakoba koꞌja lïjë ꞌdeni tara tine, bo iya te, “Dɔtaya ꞌba Bɔkoꞌba na me.” Kina bo kïdëkï möyï gɔ bi nima ŋgï rɔ Manama, ame kiya te “Taya rïyö.” ");
INSERT INTO bex_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakoba oja bɔ laja abo mɔtɔ ga kari dɔgba kɔmɔ bo zi löndö bo Esawu mï dɔyayi ꞌba Edome. ");
INSERT INTO bex_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Bo ose zïnnï ꞌdɔ lïjë kïyëtï kpa bo zi Esawu, kiya te, “Ma Yakoba bɔ laja ꞌbï, moloma ꞌdeni migabi ti Labana ŋbö kömö mï kada nime tɔne. ");
INSERT INTO bex_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ma ꞌdeni ti sa ti akaca ti dɔtumu ꞌba kamölö ni ti banya gbï ti atɔli, kina me mëdï mose lende nime zïyï löbu ma ꞌdɔ kiꞌdi mïyï këyï rɔma.” ");
INSERT INTO bex_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Bɔ laja naga nima ileki kako zi Yakoba, kiya te, “Dari ꞌdeni dömö zi bɔ löndö yï Esawu. Bo ëdï ꞌdeni ndö gɔ kɔri tako turë döyï. Bo ëdï ti bilaka abo ga kuluku modɔɔmota (400) ti bo.” ");
INSERT INTO bex_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kina Yakoba ŋgï rɔ tikere rɔ mbëmbë, na bo koza bilaka abo ga ti kamölö abo ga ti banya ti sa ti gamele kpaki bi rïyö. ");
INSERT INTO bex_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Bo omeri ɔdɔ kiya te Esawu kömö dɔtumu ma kɔtɔ kote dɔmo ma kɔtɔ nima ti kɔmɔ kiriŋa yaga. ");
INSERT INTO bex_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakoba ititi Bɔkoꞌba, iya te, “Bɔkoꞌba ꞌba ꞌbu ma löbu Abarayama ti ꞌba ꞌbu ma Yisika, uwö akititi ma. Iya ꞌdeni tönë zö ꞌdɔ mileki mari mï dɔyayi ze zi eꞌbe ꞌbu ma ga, kina gɔ koꞌdɔ wa ma laka gbï zö. ");
INSERT INTO bex_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ma bɔ laja ꞌbï nime, ma ŋgï wötï rɔ bɔ lende kënyë, mï këyï ꞌbï ti köꞌdu laka ꞌbï ame kileme zö ne ma gbagba ma mɔꞌbɔ dë. Mï kada ma tönë mumu dɔ yöpö ꞌba Yaradene mëdï mari ne, ma ŋge ti përï adɔkotɔni közö. Ne kina me tɔne mëdï mileki ꞌdeni ti dɔtumu rïyö naga nime. ");
INSERT INTO bex_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Momaꞌjo rɔma zïyï, okɔnyi ma di zi bɔ löndö ma Esawu. Ma rɔ tikere rɔ mbëmbë mɔtɔga bo ëdï kako kote dɔze kpaki ti ꞌja ti kole titi. ");
INSERT INTO bex_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ne nï Bɔkoꞌba iya ꞌdeni tönë bine, iya te, ëddï kiꞌdi wa koꞌdɔ rönï pili laka zö kiꞌdi kupö ma konzi kɔzɔ ꞌjɔ yayi lida ꞌba kpa mini löbu ame bɔtɔ kɔꞌbɔ dë tïtëtë mo ne.” ");
INSERT INTO bex_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakoba öꞌdö mï gɔ bi nima yayi, na bo koza wa ame ga bo këdï timo ne kiꞌdi rɔ kpa közï zi Esawu. ");
INSERT INTO bex_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Bo oza ma banya kuluku sowɔ (200) ti moꞌde ꞌbutë rïyö, ma kamölö kuluku sowɔ (200) ti moꞌde ꞌbutë rïyö, ");
INSERT INTO bex_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ma gamele ꞌbutë mota ti kole mo ga, ma sa ꞌbutë sowɔ ti ŋgulö ꞌbutë, ma akaca ꞌbutë rïyö ti bɔtɔni mo ga ꞌbutë. ");
INSERT INTO bex_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Bo oza rɔ dɔtumu kiꞌdi bɔ laja abo ga rɔ bɔ dɔmo. Bo iya zïnnï, iya te, “Arike nduwë dɔgba kɔmɔ ma. Olake löŋgö dɔtumu mo naga nime këdï rɔ ma kɔwɔ ti ma këdï kako di gɔmo.” ");
INSERT INTO bex_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Bo ose zi bɔ laja ma dɔgba nima, iya te, “Ɔdɔ bɔ löndö ma Esawu kondɔsɔ tïyï kititi yi, kiya te, ‘Ŋere ꞌbï rɔ yë? Kina ëddï kari yala? Yërï ꞌba yë ga na me kömöyï ne?’ ");
INSERT INTO bex_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ileki dɔmo zi bo, iya te, ‘Wa ꞌba bɔ laja ꞌbï Yakoba ga na, kina me bo koja rɔ kpa közï kiꞌdi zi ŋere abo Esawu. Kina Yakoba gbagba bo mo ëdï yïꞌböwu.’ ” ");
INSERT INTO bex_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Bo ose köꞌdu nime gbï te zi bɔ laja ma mï rïyö mo ti ma mï mota mo nduwë kala rɔ gönnï nima pili këdï kona yërï naga nima ne, bo iya te, “Ɔdɔ kondɔsɔke ti Esawu, iyake tara zi bo. ");
INSERT INTO bex_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kina iyake gbï te, Yakoba gbagba bo mo ëdï yïꞌböwu.” Bo omeri, bo iya te, “Mɔtɔga ti mïyëyï dökïꞌdï Esawu ti wa naga nime ꞌdɔ ɔdɔ mëdï mömö pele zi bo yayi tine mï bo ëyï ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Bo oja kpa közï kiꞌdi naga nima tötï kari dɔgba kɔmɔ bo, tine bo ileke ꞌba bo titi töꞌdö mï taya yayi. ");
INSERT INTO bex_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mï korɔndɔ kɔtɔ mo nima na bo kënyï dɔmo kogba ꞌja rïyö abo ga ti ꞌja ma rïyö ame ga rɔ bɔ laja ne ti kole ꞌbutë dɔɔkɔtɔ abo ga lïjë kumu tɔro ꞌba Yaboko. ");
INSERT INTO bex_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Bo oja lïjë pili kumu dɔ tɔro nima ti wa ame ga pili bo këdï timo ne, ");
INSERT INTO bex_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","tine bo na kileke ꞌba bo kutu bo yïꞌböwu. Kina bilaka mɔtɔ kako kunyöpö ti bo ŋbö kömö mï kano bi këzë. ");
INSERT INTO bex_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kina ɔdɔ bɔ nima koŋgɔ ꞌdeni bo kaꞌda Yakoba dë kpe tara tine na bo kokpe dɔꞌbötöru mo ŋgï, na kpa dɔꞌbötöru Yakoba kogba rönï ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Bo iya te, “Ola ma mari, gɔ bi ëdï ꞌdeni këzë.” Yakoba iya te, “Minza mola yi titi. Oꞌdɔ yëyï zö.” ");
INSERT INTO bex_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Bo iya te, “Möyï yï rɔ yë?” Yakoba iya te, “Möyï ma rɔ Yakoba.” ");
INSERT INTO bex_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Bo iya te, “Möyï yï inza kpe rɔ Yakoba, tine ꞌdeni rɔ Yisarele, ame kiya te ‘Nyöpö ti Bɔkoꞌba,’ römöyï unyöpö ꞌdeni ti Bɔkoꞌba gbï ti bilaka lesi ŋbö kaꞌda.” ");
INSERT INTO bex_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakoba ititi bo, iya te, “Momaꞌjo rɔma zïyï, iya möyï yï zö.” Bo iya te, “Waꞌdi na koꞌdɔkɔ tikali möyï ma gɔmo?” Kina bo koꞌdɔ yëyï zi Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakoba iya te, “Bɔkoꞌba na me moꞌja mëdï moloma gba di pötö mo ti kɔmɔ ma?” Kina bo kïdëkï möyï gɔ bi nima rɔ Penowele, ame kiya te “Kɔmɔ Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakoba ënyï di Penowele yayi këdï kiteli pele tine kada ëdï ꞌdeni kiꞌdi kpënï. Tine bo ëdï ꞌdeni kujë kaꞌbo römöyï dɔꞌbötöru bo. ");
INSERT INTO bex_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Gɔ köꞌdu mo na me nduwë ŋbö koꞌja kabate kupö Yisarele konyo lërï ame kpa dɔmoso ꞌba dɔꞌbötöru ne dë, römöyï kpa dɔmoso nima na kokpe Yakoba di teyi. ");
INSERT INTO bex_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakoba ombi kɔmɔ bo koꞌja Esawu këdï rɔ tako ti bilaka abo ga kuluku modɔɔmota (400). Kina Yakoba koza kole abo ga ŋgï zi ꞌja abo ga Leya ni ti Rayile ti ꞌja ma rïyö ma rɔ bɔ koja laja mo naga nima. ");
INSERT INTO bex_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Bo iꞌdi bɔ laja naga nima na kösö dɔgba ti kole ma ꞌbënnï ga, tine na bo kiꞌdi Leya ti kole ma ꞌbënï ga Rayile na yïꞌböwu ti kole ꞌbënï Yesepa. ");
INSERT INTO bex_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakoba gbagba bo mo na kösö dɔgba zïnnï kari turë dɔ bɔ löndö bo Esawu ti tudë dɔ bo bërï ŋbö mï modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tine Esawu iriŋa kurë dɔ bo kiramo bo kome mbili mo. Kina lïjë kpaki rïyö koloma ŋgï tudu. ");
INSERT INTO bex_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kina ɔdɔ Esawu kuyï kɔmɔ bo koꞌja ꞌja naga nima këdï kako ti kole titi tara tine, bo ititi, iya te, “Yë mo ga na me tïyï ne?” Yakoba iya te, “Ŋere ma, ya naga nime kole ma Bɔkoꞌba koꞌdɔ mï këyï koja gɔmo zö na.” ");
INSERT INTO bex_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kina ꞌja ma rɔ bɔ laja naga nima kömö ŋgï ti kole ma ꞌbënnï ga kako kolɔdɔ bërï. ");
INSERT INTO bex_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Na Leya kömö ti kole ma ꞌbënï ga, rɔ ŋburuŋburu mo na Rayile ni ti Yesepa kömö lïjë kolɔdɔ pili bërï. ");
INSERT INTO bex_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu ileki kititi, iya te, “Ne dɔtumu ame ga mondɔsɔ timo di dɔgba ꞌdë yayi ne ꞌjɔ ꞌba lende mo tëgë rɔ waꞌdi?” Yakoba iya te, “Ŋere ma, moꞌdɔ ama ꞌdɔ tïyëyï dökïꞌdï yï timo.” ");
INSERT INTO bex_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawu iya te, “Inza tara, löndö ma, mëdï ti ꞌbama ga, iꞌdi ame ga koloma rɔ ꞌbëyï.” ");
INSERT INTO bex_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakoba iya te, “Inza tara, momaꞌjo rɔma zïyï, ɔdɔ mïyëyï dökïꞌdï yï ꞌdeni ŋgï utï dɔ kpa közï kiꞌdi ma naga nime, kogba di közö. Rɔ ma laka toꞌja kïnë yï nime ŋgï zö kɔzɔ toꞌja kïnë Bɔkoꞌba römöyï indaꞌba ma ꞌdeni ti mï këyï. ");
INSERT INTO bex_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Momaꞌjo rɔma zïyï utï dɔ kpa közï kiꞌdi ma naga nime moꞌde zïyï ne. Bɔkoꞌba oꞌdɔ mï këyï ꞌdeni kiꞌdi wa ma mëdï rɔ leri mo naga pili zö.” Yakoba oloma nduwë toꞌdɔ atiri mo ŋbö Esawu kutï dɔmo. ");
INSERT INTO bex_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esawu iya te, “Dënyï ti dari, mëdï mösö dɔgba zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakoba iya te, “Ikali gbï kole titi rɔ ma keŋme kina mëdï gbï momeri kamölö ti sa ame ga kole mo ga këdï gba kulu mba ne, ɔdɔ debe toga lïjë kulöwö rɔ ma kembe pele ŋge mï töꞌdö dɔ kɔtɔ nime lïjë pili ëdï kölë ŋgï kote. ");
INSERT INTO bex_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Momaꞌjo rɔma zïyï, ari tötï ti mokɔkɔ rɔma ꞌjaa mozi ndɔ gɔ liŋgere ꞌba yërï naga nime gbï ti kole titi ti dari dota göyï Edome.” ");
INSERT INTO bex_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu iya te, “Ne ɔdɔ këdï tara iꞌdi mola bilaka ma mɔtɔ ga kileke tïyï bine.” Tine Yakoba iya te, “ꞌDɔ lïjë kileke bine gɔ waꞌdi? Moꞌdɔkɔ ŋge tïyëyï dökïꞌdï yï.” ");
INSERT INTO bex_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kina Esawu kileki ŋgï mï kada nima kari Edome ");
INSERT INTO bex_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","tine Yakoba ari ꞌba bo za Suköta bo kubö rö zi bo yayi, kina bo kubö jɔlɔ gbï zi yërï abo ga. Gɔ köꞌdu mo na kïdëkï möyï bi nima ŋgï rɔ Suköta, ame kiya te “Jɔlɔ.” ");
INSERT INTO bex_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Di mï tileki ꞌba Yakoba di Padanarama nima bo ako laka ŋbö kömö Sekeme mï dɔyayi ꞌba Kanana na bo koga taya abo mï nyaka mɔtɔ ŋgɔsi dɔ ŋgila gawo nima yayi. ");
INSERT INTO bex_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Bo ugö kapa ꞌba nyaka nima bo koloma yïmo ne di zi bɔ Amoro mɔtɔ ꞌbu ꞌba Sekeme. Ndögö mo ti yamo kïsï kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kina bo koꞌba bi ꞌba akumu yayi kïdëkï möyï mo rɔ bi ꞌba akumu ꞌba Bɔkoꞌba ꞌba Yisarele. ");
INSERT INTO bex_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Mï kada ma dɔ kɔtɔ mɔtɔ na Dina nyiti ꞌba Yakoba ame Leya köyö ne kënyï kari toŋgɔ ꞌja mɔtɔ ga ꞌba mï dɔyayi ꞌba Kanana yayi. ");
INSERT INTO bex_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekeme kole ꞌba Amoro eꞌbe Iwa oꞌja lɔko di yayi. Amoro na rɔ ŋere ꞌba dɔyayi nima. Kina Sekeme kari ŋgï kindaꞌba lɔko rɔ gbörökötö köꞌdö timo. ");
INSERT INTO bex_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Dökïꞌdï bo oꞌdɔkɔ nyiti nima kina bo koloma ŋgï tilende teyi ꞌdɔ tïyëyï dökïꞌdï mo. ");
INSERT INTO bex_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Bo iya zi ꞌbu bo Amoro, iya te, “Moꞌdɔkɔ ꞌdɔ kogbe nyiti nime zö rɔ ꞌja.” ");
INSERT INTO bex_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakoba ari kuwö köꞌdu mo odɔ laŋa ꞌdeni rɔ nyiti abo. Tine kole abo ga ëdï toda yërï abo ga mï löwu, gɔ köꞌdu mo na bo kogbɔ dökïꞌdï bo ŋbö koda lïjë. ");
INSERT INTO bex_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Köꞌdu mo ari kömö zi kole ꞌba Yakoba ga di mï löwu kina lïjë kënyï ŋgï kako. Lende mo ïlëꞌdï ŋgï rönnï mïnnï kata rɔ ma kënyë gɔ tiꞌja nima Sekeme koꞌdɔ rönnï lïjë eꞌbe Yisarele ti toꞌdɔ köꞌdu ma yawa ma tara ga zi nyiti ꞌba Yakoba ne. Amoro ënyï kari zi Yakoba ꞌdɔ tiya lende nima, ");
INSERT INTO bex_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","bo iya zi Yakoba ni, iya te, “Kole ma Sekeme ɔꞌɔ nyiti ꞌbe sowa. Momaꞌjo rɔma ziye, iꞌdike lɔko zi bo kogbe. ");
INSERT INTO bex_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Doꞌdɔke pɔri mï löŋgö ze gɔ dogbeke rɔze nduwë tiye. ");
INSERT INTO bex_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kina gbï ꞌdɔ kolomake tize mï dɔyayi nime bine. Ti kolomake mï gɔ bi ame ga pili koꞌdɔkɔke kugöke ndögö rɔ dɔ ŋgölö gɔ këddïke gbï rɔ bɔ mɔri.” ");
INSERT INTO bex_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekeme ileki gbï kiya zi ꞌbu ꞌba nyiti ti löndö mo ga, iya te, “Iꞌdike mïye këyï rɔma. Mëdï mopi wa ame ga pili koꞌdɔkɔke ne ziye. ");
INSERT INTO bex_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Iyake wa ma koꞌdɔkɔke ꞌdɔ miꞌdi zïnï kina odoweke gbe ꞌbe gbï kɔzɔ ame mïye koꞌdɔkɔ ne tara. Wa ame ga pili kïtëtëke mëdï mopi ziye ɔdɔ kiya te kiꞌdike lɔko ŋgï zö mogbe.” ");
INSERT INTO bex_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kole ꞌba Yakoba ga ileki dɔmo rɔ dɔŋgala zi Sekeme ni ti ꞌbu bo Amoro römöyï bo odɔ laŋa ꞌdeni rɔ lëmï nnï Dina. Gɔ köꞌdu mo na lïjë kiya te, ");
INSERT INTO bex_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Diꞌdi lëmï ze dë zi bilaka ame kilele dë ne kogbe, kinza koꞌde rɔ kaya rɔze. ");
INSERT INTO bex_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ti dutï ŋge dɔmo ɔdɔ koꞌdɔke gbï kɔzɔ ꞌbeze kileleke bɔtɔni pili rɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ɔdɔ këdï ꞌdeni tara tine na ti dutï ꞌjaa togbe rɔze tiye. Ti doloma mï löŋgö ye bine dodɔꞌbɔ rɔze rɔ bilaka kɔtɔ tiye. ");
INSERT INTO bex_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ne ɔdɔ kutïke dë gɔ lende ze nime kileleke bɔtɔni ꞌbe ga dëdï dogba nyiti ze dënyï yaga di bine.” ");
INSERT INTO bex_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amoro ni ti kole abo Sekeme ŋgï ti mï këyï gɔ lende nima. ");
INSERT INTO bex_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Gɔ ame Sekeme kɔꞌɔ Dina nyiti ꞌba Yakoba kulöwö ne iꞌdi bo dë kpe kicayi toꞌdɔ dölëtï nima. Bo na gbï rɔ bɔ ame bilaka ꞌbënï ga pili koro rɔ dɔ kiteli. ");
INSERT INTO bex_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kina lïjë kako mï kpa reki ꞌba gawo ꞌbënnï kilende zi bilaka ꞌbënnï ga, iya te, ");
INSERT INTO bex_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ya naga nime rɔ ma laka tize. Diꞌdike lïjë koloma mï dɔyayi nime bine kugö ndögö rɔ dɔ ŋgölö. Yayi nime ïyöbu kënyë ëdï kɔꞌbɔ ze kpaki tïnnï. Dogbeke yïtö ꞌbënnï ga gɔ lïjë kogbe yïtö ꞌbeze ga gbï. ");
INSERT INTO bex_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tine ya naga nime oꞌdɔkɔ toloma todɔꞌbɔ rönnï tize rɔ bilaka kɔtɔ ɔdɔ kiya te doꞌdɔke ŋgï gbï kɔzɔ ꞌbënnï dileleke bɔtɔni pili rɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Doꞌdɔke tara ꞌdɔ yërï ꞌbënnï naga nima ti wa ꞌbënnï ga këdï pili rɔ eze ga. Dutïke dɔmo zïnnï gɔ lïjë koloma mï löŋgö ze bine.” ");
INSERT INTO bex_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bilaka ꞌba mï gawo nima pili utï ŋgï gɔ lende ꞌba Amoro ni ti kole abo Sekeme, kina kilele bɔtɔni ma mï löŋgö lïjë yayi ŋgï pili rɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mï töꞌdö dɔ mota koꞌja ya naga nima këdï gba dɔ wëtö ꞌba akilele nima na kole ꞌba Yakoba ga ma rïyö, Simona ni ti Lëwë ame lïjë na rɔ löndö ꞌba Dina ne, kogba mbele ꞌbënnï ga ŋgï lïjë kusu rönnï kari mï gawo nima kupö bɔtɔni mo ga me yaga. ");
INSERT INTO bex_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Lïjë upö Amoro ni gbï ti kole abo Sekeme. Kina lïjë kogba Dina di rö ꞌba Sekeme yayi lïjë kënyï kari ëꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Di pötö löpö nima na kole ꞌba Yakoba mɔtɔ ga kako kolɔ wa ꞌba mï gawo nima ŋgï pili kpa dɔkolo laŋa nime kodɔ rɔ lëmï nnï ne. ");
INSERT INTO bex_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Lïjë otɔtɔ kamölö mo ga ti sa ni ti akaca kpaki ti wa ꞌba mï gawo nima pili ti ꞌba mï nyaka. ");
INSERT INTO bex_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Lïjë ogba wa ame ga rɔ ꞌba mɔri ꞌba ya naga nima ŋgï pili ti ꞌja mo ga ti kole titi kpaki ti wa ꞌba mï liŋɔ mo ga lïjë kari timo. ");
INSERT INTO bex_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakoba iya zi Simona ni ti Lëwë, iya te, “Oꞌdeke wali ꞌdeni dɔma, Kanana naga nime ti Pereze ꞌbënï kpaki ti bilaka ame ga pili këdï koloma mï dɔyayi nime ëdï kënyï toꞌji ma. Bilaka ma ga na me konzi dë, ɔdɔ kiya te ya naga nima kotɔtɔ rönnï kalo ya dɔma, lïjë ëdï kote dɔze ŋgï pili ti bilaka ma ga.” ");
INSERT INTO bex_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tine Simona ni ti Lëwë ileki dɔmo, iya te, “Doꞌdɔkɔ dë gɔ koꞌdɔ lëmï ze kɔzɔ ꞌja ame ga rɔ bɔ lende yawa ne tara.” ");
INSERT INTO bex_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Bɔkoꞌba ilende zi Yakoba, iya te, “Ënyï kari Betele gɔ koloma yayi. Oꞌba bi ꞌba akumu zö yayi, ma na rɔ Bɔkoꞌba ma tönë kileme rönï zïyï mï kada ma këddï kiriŋa di zi löndö yï Esawu ne.” ");
INSERT INTO bex_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakoba iya zi bilaka abo ga ti ya ame ga pili ti bo ne, iya te, “Uꞌduke akoro ꞌba bɔ löwö naga nime kogbake ne mökö. Urögöke rɔye kusuke bɔŋgɔ ma kɔpɔ rɔye. ");
INSERT INTO bex_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Dëdï dënyïke di bine darike Betele gɔ mari moꞌba bi ꞌba akumu yayi zi Bɔkoꞌba ame kokɔnyi ma mï kada ꞌba gomɔ ma bo köꞌbö nduwë tö di mï gɔ bi ame ga pili mari teyi ne.” ");
INSERT INTO bex_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kina lïjë kotɔtɔ akoro ame ga pili lïjë këdï timo ne ŋgï koꞌde zi Yakoba kpaki ti kaga mo ga kina bo kusu ŋgï bïcï ŋgërï nima yayi ŋgɔsi ŋgila Sekeme. ");
INSERT INTO bex_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mï tënyï ꞌbënnï na Bɔkoꞌba kiꞌdi tikere ma löbu ŋgï kilaꞌba zi bilaka ꞌba mï gawo ma ŋgɔsi yayi naga nima, gɔ köꞌdu mo na lïjë oga gɔ eꞌbe Yakoba ga dë. ");
INSERT INTO bex_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakoba ako ti bilaka abo ga pili mï Luza ame ꞌdeni leꞌjete rɔ Betele ne, mï dɔyayi ꞌba Kanana. ");
INSERT INTO bex_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Bo oꞌba bi ꞌba akumu zi Bɔkoꞌba yayi na bo kiꞌdi möyï Bɔkoꞌba ꞌba Betele dɔmo römöyï Bɔkoꞌba ɔdɔ pa kileme rönï zi bo di yayi mï kada ma bo këdï kiriŋa di zi löndö bo Esawu. ");
INSERT INTO bex_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Di yayi na Debora bɔ laja ꞌba Rebeka kölë kina kusu lɔko bïcï ŋgërï nima yayi kapa Betele ma kari dɔ roꞌɔ. Kina kïdëkï möyï gɔ bi nima ŋgï rɔ “Ŋgërï ꞌba Monɔ.” ");
INSERT INTO bex_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Bɔkoꞌba ɔdɔ kileme rönï ꞌböwu zi Yakoba koꞌja bo kileki ꞌdeni di Padanarama. Kina Bɔkoꞌba koꞌdɔ yëyï zi bo, ");
INSERT INTO bex_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","iya te, “Möyï yï rɔ Yakoba, tine kisaki di mï kada nime tɔne nduwë kari dɔgba ti kïdëkï möyï yï rɔ Yisarele.” Kina kïdëkï möyï bo ŋgï rɔ Yisarele. ");
INSERT INTO bex_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Bɔkoꞌba iya zi bo, iya te, “Ma na rɔ Bɔkoꞌba bɔ tigɔ dɔ kiteli. Öyö kole kara konzi rɔ mbëmbë. Kupö bilaka ma konzi ti kɔdɔ di mïyï. Ti këdï rɔ yï lïŋgï ꞌba bɔ dɔliŋɔ ma konzi. ");
INSERT INTO bex_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mëdï miꞌdi yayi nime miꞌdi zi Abarayama ni ti Yisika ne zïyï kina gbï zi kupö yï ga ma di yïꞌböwu.” ");
INSERT INTO bex_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kina Bɔkoꞌba kënyï ŋgï kari ëꞌbënï. ");
INSERT INTO bex_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Gɔ bi nima Bɔkoꞌba kilende ti bo di teyi ne na bo kogba döku kïdëyï dɔmo yayi, bo kodɔ layi gbï ti ꞌbu dɔmo bo kulömu zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kina bo kïdëkï möyï gɔ bi nima ŋgï rɔ Betele. ");
INSERT INTO bex_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakoba ni ënyï ti bilaka abo ga di Betele yayi tari, tine gba kota lïjë këdï rɔ ma kɔwɔ di ŋgila Eporata na kada ꞌba löyö kömö ŋgï zi Rayile, tine ꞌdeni ŋgï rɔ gomɔ ma löbu zïnï. ");
INSERT INTO bex_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kina ɔdɔ gomɔ ꞌbënï ꞌdeni ŋgï rɔ ma kënyë tine, ꞌja bɔ bulï mo iya te, “Rayile, kinza kere dë kole bɔtɔni mɔtɔ na.” ");
INSERT INTO bex_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tine lɔko ëdï ꞌdeni kölë. Koꞌja lɔko këdï ꞌdeni kulöku na lɔko kiꞌdi möyï kole ꞌbënï nima ŋgï rɔ Benoni, tine ꞌbu mo iꞌdi möyï mo rɔ Benyimona. ");
INSERT INTO bex_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rayile ölë na kusu lɔko kɔri kari Eporata yayi. Gɔ bi mo nima na me ꞌdeni leꞌjete rɔ Beteleme ne. ");
INSERT INTO bex_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kina Yakoba kogba döku kïdëyï rɔ raba dɔ dögö Rayile yayi ame këdï gba nduwë koꞌja kabate ne. ");
INSERT INTO bex_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yakoba iteli nduwë ŋbö bo kari koga taya abo ŋgila Migidala Edere. ");
INSERT INTO bex_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mï kada nima Yakoba këdï koloma mï dɔyayi nima yayi ne na Rubënï kari köꞌdö ti Bila ame rɔ ꞌja ꞌba ꞌbu bo mɔtɔ ne. Yakoba uwö lende mo kina bo ŋgï rɔ ꞌdïrï. Yakoba ëdï ꞌdeni ti kole ꞌbutë dɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Kole ma köyö ꞌba Leya ga na rɔ Rubënï kole ma rɔ dɔndende ꞌba Yakoba, kina ti Simona ni ti Lëwë ti Yuda ti Yisakara ti Zebolona. ");
INSERT INTO bex_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Kole ma köyö ꞌba Rayile ga na rɔ Yesepa ni ti Benyimona. ");
INSERT INTO bex_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Kole ma köyö ꞌba Bila nyiti bɔ laja ꞌba Rayile ga na rɔ Dana ni ti Napatali. ");
INSERT INTO bex_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Kole ma köyö ꞌba Zilepa nyiti bɔ laja ꞌba Leya ga na rɔ Gada ni ti Asera. Kole naga nime öyö pili di Padanarama. ");
INSERT INTO bex_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakoba ari zi ꞌbu bo Yisika mï Mamore ŋgɔsi ŋgila Eborona, gɔ bi ma tönë pa Abarayama ni koloma teyi ti Yisika ne. ");
INSERT INTO bex_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Kɔmɔ kɔɔ ꞌba loma ꞌba Yisika ꞌdeni kuluku mota kɔdɔ dɔmo ꞌbutë mota (180) mï kada ma bo këdï kölë. ");
INSERT INTO bex_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Bo ölë koꞌja bo köndë ꞌdeni kote kina kole abo ga Esawu ni ti Yakoba kusu bo ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ame na rɔ möyï kupö Esawu ga ame kïdëkï bo gbï rɔ Edome ne. ");
INSERT INTO bex_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu ogbe ꞌja di mï löŋgö yïtötï ꞌba Kanana. Lïjë na rɔ Ada nyiti ꞌba Elone di eꞌbe Ete ni ti Olibama nyiti ꞌba Ana kole ꞌba Zibeyona di eꞌbe Iwa. ");
INSERT INTO bex_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esawu ogbe ꞌja mɔtɔ gbï rɔ Basemata nyiti ꞌba Yisamele ame rɔ lëmï ꞌba Nebayota ni ne. ");
INSERT INTO bex_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada na köyö Elipaza. Basemata öyö Ruwëlë, ");
INSERT INTO bex_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","tine Olibama na köyö ꞌbënï Yusa ni ti Yalama ti Kora. Kole ꞌba Esawu naga nime öyö pili di mï dɔyayi ꞌba Kanana. ");
INSERT INTO bex_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kina Esawu kotɔtɔ ꞌja abo ga ti kole abo ga ti yïtötï abo ga kpaki ti bilaka ame ga pili mï liŋɔ abo ne ti yërï pili ti wa ame ga bo koꞌja di mï dɔyayi ꞌba Kanana yayi ne, kina bo kënyï kari mï dɔyayi mɔtɔ rɔ ma kɔwɔ di dɔ ŋgila löndö bo Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bo ënyï di yayi römöyï dɔyayi nima lïjë koloma teyi ti löndö bo Yakoba ne ɔꞌbɔ lïjë dë kpe, yërï ꞌbënï ga onzi ꞌdeni ŋgï rɔ mbëmbë gɔ bi ɔꞌbɔ lïjë dë kpe todɔꞌbɔ dönnï. ");
INSERT INTO bex_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kina Esawu kari koloma mï dɔyayi kuruŋgu ꞌba Seyira ame kïdëkï gbï rɔ Edome ne. ");
INSERT INTO bex_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ame na rɔ kupö Esawu yï lïŋgï ꞌba kupö bilaka naga nime kïdëkï lïjë rɔ Edome ma këdï koloma mï dɔyayi kuruŋgu ꞌba Seyira. ");
INSERT INTO bex_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Ada ꞌja ꞌba Esawu öyö kole kɔtɔ zi bo rɔ Elipaza. Elipaza öyö kole bɔtɔni muyï rɔ Temana ni ti Omara ti Zepo ti Gatama ti Kenaza. ꞌJa abo mɔtɔ ame rɔ Timina ne na köyö Amaleke. Basemata ꞌja ꞌba Esawu öyö kole kɔtɔ zi bo rɔ Ruwëlë. Ruwëlë öyö kole sowɔ rɔ Nata ni ti Zera ti Sama ti Miza. ");
INSERT INTO bex_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ꞌJa ꞌba Esawu ame rɔ Olibama nyiti ꞌba Ana kole ꞌba Zibeyona ne öyö kole mota zi bo rɔ Yusa ni ti Yalama ti Kora. ");
INSERT INTO bex_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dɔꞌbe ame ga pili kɔdɔ di zi Esawu ne na me ga. Elipaza kole dɔndende ꞌba Esawu na rɔ yï lïŋgï ꞌba bilaka naga nime, Temana ni ti Omara ti Zepo ti Kenaza ");
INSERT INTO bex_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ti Kora ti Gatama kina gbï ti Amaleke. Ya naga nime pili rɔ kupö bilaka ma kɔdɔ di zi Ada ꞌja ꞌba Esawu. ");
INSERT INTO bex_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ruwëlë kole ꞌba Esawu na rɔ yï lïŋgï ꞌba dɔꞌbe naga nime, Nata ni ti Zera ti Sama kina gbï ti Miza. Ya naga nime pili rɔ kupö bilaka ma kɔdɔ di zi Basemata ꞌja ꞌba Esawu. ");
INSERT INTO bex_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dɔꞌbe naga nime na rɔ ma kɔdɔ di zi ꞌja ꞌba Esawu ame rɔ Olibama nyiti ꞌba Ana. Lïjë na rɔ Yusa ni ti Yalama ti Kora. ");
INSERT INTO bex_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ya naga nime pili rɔ kupö bilaka ma kɔdɔ di zi Esawu. ");
INSERT INTO bex_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ame na rɔ kupö Seyira eꞌbe Ori ame lïjë na rɔ bɔ dɔyayi nima ne. Lotana ni ti Sobala ti Zibeyona ti Ana ");
INSERT INTO bex_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ti Disona ti Ezere ti Disana. Ya naga nime na rɔ yï lïŋgï ꞌba eꞌbe Ori mï kpa gɔli mo ga ma gege ame koloma mï dɔyayi ꞌba Edome. ");
INSERT INTO bex_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotana na rɔ ꞌbu ꞌba Ori ni ti Emana. Lëmï ꞌba Lotana na rɔ Timina. ");
INSERT INTO bex_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobala na rɔ ꞌbu ꞌba Alawana ni ti Manata ti Ebala ti Sepo ti Onama. ");
INSERT INTO bex_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Kole ma ꞌba Zibeyona ga rïyö rɔ Aya ni ti Ana. Ana nime na tönë koꞌja mini kututu këdï kulöwu di mï yayi mï kada ma bo këdï yï mökö toda akaca ꞌba ꞌbu bo ga ne. ");
INSERT INTO bex_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Kole ꞌba Ana na rɔ Disona kina nyiti abo na gbï rɔ Olibama. ");
INSERT INTO bex_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Kole ꞌba Disona ga na rɔ Amedana ni ti Ezebana ti Yiterana ti Korana. ");
INSERT INTO bex_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Kole ꞌba Ezere ga na rɔ Bilana ni ti Zawana ti Akana. ");
INSERT INTO bex_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disana na rɔ ꞌbu ꞌba Uzu ni ti Arana. ");
INSERT INTO bex_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Kpa gɔli ꞌba eꞌbe Lotana ni ti Sobala ti Zibeyona ti Ana ");
INSERT INTO bex_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ti Disona ti Ezere ti Disana na rɔ kupö eꞌbe Ori ma koloma mï dɔyayi ꞌba Edome. ");
INSERT INTO bex_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mɔlo gba kinza bɔ dɔliŋɔ këdï mï dɔyayi ꞌba Yisarele ya naga nime na koloma rɔ bɔ dɔliŋɔ ꞌba Edome nduwë rɔ ma kolɔlɔ. ");
INSERT INTO bex_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela kole ꞌba Bɔra di mï gawo ꞌba Dinaba na koloma rɔ bɔ dɔliŋɔ ꞌba Edome. ");
INSERT INTO bex_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Di pötö tölë ꞌba Bela na Jobaba kole ꞌba Zera di mï gawo ꞌba Bozara kindaꞌba kïtï ꞌba bɔ dɔliŋɔ nima. ");
INSERT INTO bex_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Di pötö tölë ꞌba Jobaba na Usama di mï dɔyayi ꞌba Temana kindaꞌba kïtï nima. ");
INSERT INTO bex_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Di pötö tölë ꞌba Usama na Adada kole ꞌba Bedada di mï gawo ꞌba Awita kindaꞌba kïtï nima. Adada na kaꞌda bilaka ꞌba Midiyana mï ya ma di mï dɔyayi ꞌba Mowaba. ");
INSERT INTO bex_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Di pötö tölë ꞌba Adada na Samala di mï gawo ꞌba Meseraka kindaꞌba kïtï nima. ");
INSERT INTO bex_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Di pötö tölë ꞌba Samala na Sawola di mï Robota di kpa yöpö Epurate kindaꞌba kïtï nima. ");
INSERT INTO bex_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Di pötö tölë ꞌba Sawola na Bala Anana kole ꞌba Akobora kindaꞌba kïtï nima. ");
INSERT INTO bex_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Di pötö tölë ꞌba Bala Anana na Adara di mï gawo ꞌba Pawu kindaꞌba kïtï nima. Möyï ꞌja abo na rɔ Metabele nyiti ꞌba Matorede nyiti ꞌba Mesaba. ");
INSERT INTO bex_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esawu na rɔ yï lïŋgï ꞌba kupö bilaka naga nima kïdëkï lïjë rɔ Edome ne. Möyï nnï ga na me pili ti kpa gɔli ꞌbënnï ga ti gɔ bi ma lïjë koloma teyi. Lïjë na rɔ eꞌbe Timina ni ti Alawana ti Yetete ");
INSERT INTO bex_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ti Olibama ti Ela ti Pinona ");
INSERT INTO bex_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ti Kenaza ti Temana ti Mibizara ");
INSERT INTO bex_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ti Magadile ti Irama. Esawu na rɔ yï lïŋgï ꞌba bilaka ꞌba Edome naga nime, gɔ bi ma lïjë koloma teyi di mï dɔyayi nima yayi ïdëkï pili ti möyï kpa gɔli ꞌbënnï ga ma gege. ");
INSERT INTO bex_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Di pötö tölë ꞌba Yisika kole abo Yakoba oloma nduwë köꞌbö mï Kanana dɔliŋɔ ma ꞌbu bo koloma mɔlo teyi. ");
INSERT INTO bex_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","3","Tine lende ꞌba kole ꞌba Yakoba ga na kɔzɔ a nime te. Yesepa na rɔ kole ma Yakoba köyö koꞌja rɔ bo kandi ꞌdeni. Kina bo kɔꞌɔ Yesepa ŋgï rɔ dɔ kiteli pili di dɔ kole abo mɔtɔ naga nima. Kina ɔdɔ Yesepa kɔmɔ kɔɔ abo këdï ꞌdeni ꞌbutë döömu dɔmorïyö tine bo oloma tiliŋgere ti löndö bo ga ame Yakoba köyö ti ꞌja abo ga Bila ni ti Zilepa ne. Lïjë ëdï koda kamölö ni ti banya ꞌba Yakoba, tine lende koꞌdɔ ꞌbënnï ele dë. Kina Yesepa köꞌbö nduwë toꞌde lende mo zi ꞌbu nnï. Gɔ köꞌdu ꞌba akɔꞌɔ ame bo kɔꞌɔ Yesepa kulöwö ne mï kada mɔtɔ tine na bo kiꞌdi bɔŋgɔ kele kakpa kilala yayi ŋgï zi Yesepa. ");
INSERT INTO bex_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kina ɔdɔ ya mɔtɔ naga nima koŋgɔ ꞌbu nnï kɔꞌɔ Yesepa ꞌdeni ŋgï rɔ dɔ kiteli tara tine lïjë iꞌdi ŋgï tombi mïnnï rɔ Yesepa. Lïjë ilende dë kpe zi bo rɔ mugu këyï. ");
INSERT INTO bex_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Mï kada mɔtɔ na nyï koꞌde dɔ Yesepa, kina ɔdɔ bo kïyëtï gɔmo zi löndö bo ga tine iꞌdi lïjë koꞌji bo ŋgï rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Bo iya te zïnnï, “Uwöke tɔ ma, nyï oꞌde dɔma ti korɔndɔ ene ");
INSERT INTO bex_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","tëgë dëdïke pili mï nyaka tudödu kolɔkɔ. Kina dɔ kolɔkɔ ma ꞌbama kënyï kɔrɔ ŋgï tɔrɔ kɔzɔ bilaka lesi tara, kina dɔ kolɔkɔ ma ꞌbeye ga kako ŋgï kuru dɔ ꞌbama tönë lïjë kolɔdɔ ŋgï pili bërï kɔzɔ bilaka ame kolɔdɔ bërï kɔmɔ ŋere ne tara.” ");
INSERT INTO bex_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Bɔ löndö bo ga iya te, “Mï nyï ꞌbï nima iya te oꞌdɔkɔ toꞌdɔ röyï rɔ ŋere dɔze? Inza koꞌdɔ du te.” Kina lïjë koꞌji bo ŋgï rɔ ma kënyë gɔ köꞌdu ꞌba nyï nima kina gbï gɔ ame bo kiya lende ꞌba rönnï ne. ");
INSERT INTO bex_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mï kada mɔtɔ na nyï koꞌde ꞌböwu dɔ Yesepa. Kina bo kïyëtï gɔmo gbï zi bɔ löndö bo ga. Bo iya te, “Nyï mɔtɔ oꞌde dɔma gbï tëgë kada ni ti nyepe ako ti këlu ꞌbutë dɔɔkɔtɔ kolɔdɔ bërï kɔmɔ ma.” ");
INSERT INTO bex_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Bo ari kïyëtï gɔ lende nima gbï zi Yakoba. Ɔdɔ Yakoba kuwö lende nima ꞌdeni tara tine, bo iya te, “Kole ma, waꞌdi na tara? Mï nyï ꞌbï nima iya te ze ti möyï ti löndö yï ga ti dolɔdɔ bërï kömöyï?” ");
INSERT INTO bex_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kina löndö ꞌba Yesepa ga kombi mïnnï ŋgï rɔ bo rɔ ma kënyë. Tine Yakoba öꞌbö ꞌba bo nduwë tomeri gɔ lende nima. ");
INSERT INTO bex_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mï kada mɔtɔ na löndö ꞌba Yesepa ga kënyï kari yï mökö bi liŋgere toda yërï ꞌba Yakoba ga. Lïjë ari ŋbö mï dɔyayi ꞌba Sekeme. ");
INSERT INTO bex_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kina Yakoba kiya te zi Yesepa, “Löndö yï ga ëdï toda yërï ma ga mï dɔyayi ꞌba Sekeme. Mëdï moja yi kari toŋgɔ lïjë.” Yesepa iya te, “Ele, muwö ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yakoba iya te, “Ari koŋgɔ löndö yï ga ti yërï ma ga ꞌdɔ kako kïyëtï lende mo zö.” Kina Yakoba koja bo ŋgï di kpa tɔro ꞌba Eborona yayi kari dɔyayi ꞌba Sekeme. ");
INSERT INTO bex_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Di mï tömö abo Sekeme bɔ mɔtɔ oꞌja bo këdï kiliŋgere ŋgï sowa kebe yï mökö. Bɔ nima iya te, “Waꞌdi na këddï koma?” ");
INSERT INTO bex_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Bo iya te, “Mëdï moma gɔ löndö ma ga, lïjë oloma toda yërï ꞌbënnï pa bine. Iya zö te ꞌdi, baba, lïjë ëdï yala?” ");
INSERT INTO bex_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Bɔ nima iya te, “Lïjë ënyï ꞌdeni di bine. Muwö lïjë koloma tiya mo tëgë lïjë oꞌdɔkɔ tari Dotana.” Kina Yesepa kari ŋgï nduwë gɔ löndö bo ga, bo kari koꞌja lïjë Dotana. ");
INSERT INTO bex_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kina ɔdɔ bo kömö ꞌdeni lïjë oꞌja bo mɔlo di bi kɔwɔ na lïjë kususu kpënnï ŋgï rɔ bo ꞌdɔ tupö mo yaga. ");
INSERT INTO bex_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Lïjë iya te, “Bɔ tönë koꞌdɔ rɔ bo rɔ bɔ nyï koꞌde dɔ bo ne, bo na me ꞌdë këdï kako. ");
INSERT INTO bex_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bi abo nati, dupöke bo yaga duꞌduke töku bo mï daa bine, ꞌdɔ dari diyake te kuruku na kindaꞌba bo ꞌdeni konyo bo. Ti doŋgɔke ɔdɔ waꞌdi na ti koꞌdɔ rönï gɔ nyï abo nima ya?” ");
INSERT INTO bex_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kina ɔdɔ bɔ löndö bo Rubënï kuwö lende nima ꞌdeni tara, bo oꞌdɔkɔ tokɔnyi Yesepa di zi lïjë. Kina bo kiya te, “Kinza dupöke bo dë rɔ tupö, ");
INSERT INTO bex_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","duꞌduke bo mï daa kalo nime mï mökö bine. Kinza dosake közïze dë rɔ bo.” Bo oꞌdɔkɔ tokɔnyi Yesepa di zi lïjë ꞌdɔ bo koja kileki kari zi ꞌbu nnï. ");
INSERT INTO bex_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kina ɔdɔ Yesepa kömö ꞌdeni zïnnï yayi tine lïjë indaꞌba bo ŋgï kolɔ bɔŋgɔ yaga di rɔ bo, bɔŋgɔ kele kakpa kilala yayi tönë. ");
INSERT INTO bex_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kina lïjë kogba bo ŋgï kuꞌdu mï daa nima mini mo kulöku ꞌdeni yaga mɔlo di yïmo ne. ");
INSERT INTO bex_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tine mbowa di pötö mo kota bɔ löndö ꞌba Yesepa naga nima këdï gba tonyo akonyo na lïjë koꞌja eꞌbe Yisamele mɔtɔ ga ŋgï këdï kari dɔ liŋgere kebe yayi. Ya naga nima ëdï kiliŋgere rɔ ma konzi kako di Gilada këdï kari Ezipeto ti gamele ꞌbënnï ga kombi a ꞌba ndögö ꞌbënnï ga ame ti dɔkomali wɔwɔ ma kato kele kulöwö yïmo. ");
INSERT INTO bex_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kina Yuda kiya zi bɔ löndö bo ama ga, iya te, “Ɔdɔ dupöke Yesepa pele dandike gɔmo, waꞌdi na ti doꞌjake di gɔmo? ");
INSERT INTO bex_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bo löndö ze na, kinza doꞌdɔke ɔtɔ dë zi bo, ze ame aa rɔ kole ꞌba ꞌbu kɔtɔ ne. Zize ŋgï togba bo tugö bo zi Yisamele naga nime.” Kina löndö bo ama ga kutï ŋgï pili gɔ lende nima. ");
INSERT INTO bex_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Eꞌbe Yisamele naga nima ömö yayi ti Midiyana mɔtɔ ga ame rɔ bɔ ndögö ne. Kina kole ꞌba Yakoba ga kotɔ Yesepa ŋgï yaga di mï daa kari kugö zi ya naga nima ti yamo ꞌbutë rïyö. Kina bilaka naga nima kogba Yesepa ŋgï kari timo Ezipeto. ");
INSERT INTO bex_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kina ɔdɔ Rubënï kileki kari yayi tine bo oꞌja Yesepa inza kpe mï daa. Kina bo ŋgï ti meri rɔ ma kënyë, bo kirica bɔŋgɔ yaga di rɔ bo römöyï lende nima ata ꞌdeni dökïꞌdï bo sowa. ");
INSERT INTO bex_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kina bo kari zi löndö bo ga, bo iya te, “Bɔ titi nime inza kpe ꞌdë, ti moꞌdɔ rɔma tɔne tondo?” ");
INSERT INTO bex_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kina lïjë kënyï kupö banya kusu bɔŋgɔ ꞌba Yesepa mï roma mo. ");
INSERT INTO bex_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kina lïjë kari ti bɔŋgɔ nima kileme zi ꞌbu nnï Yakoba, iya te, “Doꞌja a nime di mökö, ɔdɔ tara ne bɔŋgɔ ꞌba kole ꞌbï Yesepa na dë ya?” ");
INSERT INTO bex_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kina Yakoba kikali bɔŋgɔ nima ŋgï. Bo iya te, “Buꞌbu, bɔŋgɔ ꞌba kole ma na. Kuruku tɔ ne ga upö bo ꞌdeni ŋgï kirica mï bo rɔ kɔtɔkɔtɔ.” ");
INSERT INTO bex_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kina Yakoba kudu ŋgï kirica bɔŋgɔ ma laka yaga di rɔ bo kolɔ rɔ bɔŋgɔ ꞌba monɔ. Kina bo koloma ŋgï tudu kole abo Yesepa rɔ gɔ kɔwɔ. ");
INSERT INTO bex_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kole abo ga ako pili ti yïtötï mo ga tuyë kɔmɔ bo. Tine bo oꞌdɔkɔ abo lende ꞌba kɔmɔ kuyë ꞌbënnï dë. Bo iya te, “Inza tara, kole ma na me kölë ꞌdeni, moꞌdɔkɔ gbï ꞌdɔ mölë yaga. Meri abo ëdï kupö ma.” Kina bo koloma ŋgï rɔ kɔmɔ tɔlɔ gɔ lende ꞌba Yesepa. ");
INSERT INTO bex_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Dëmba mï kada mo nima ne bilaka ꞌba Midiyana naga nima oto Yesepa ꞌdeni ŋbö kari Ezipeto kugö zi Potiparo rɔ atɔli. Potiparo nima na rɔ bɔ laja ꞌba bɔ dɔliŋɔ ma löbu ꞌba Ezipeto, bo na rɔ bɔ dɔ bɔ kanya ꞌba bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mï kɔmɔ kɔɔ mo nima na Yuda kënyï di mï löŋgö löndö bo ga kari koloma ti bɔ mɔtɔ möyï mo rɔ Ira bɔ Adolama mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Di liŋɔ ꞌba bɔ nima yayi na bo kari koꞌja nyiti mɔtɔ rɔ yïtö ꞌba Kanana. Möyï ꞌbu mo ïdëkï rɔ Suwa. Bo ogbe nyiti nima ");
INSERT INTO bex_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","tine na lɔko kɔmɔ ŋgï köyö kole bɔtɔni kina kiꞌdi möyï mo rɔ Ere. ");
INSERT INTO bex_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Lɔko ɔmɔ ꞌböwu gbï di gɔmo köyö rɔ kole bɔtɔni kina lɔko kiꞌdi möyï mo rɔ Onana. ");
INSERT INTO bex_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Di gɔmo ꞌböwu lɔko ari köyö kole ma mï mota gbï rɔ kole bɔtɔni kina lɔko kiꞌdi möyï mo rɔ Sela. Mï kada nima Yuda ëdï koloma Keziba. ");
INSERT INTO bex_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kina ɔdɔ Ere kole ma dɔndende nima kïyöbu ꞌdeni tine Yuda ogbe ꞌja teyi möyï mo rɔ Tamara. ");
INSERT INTO bex_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tine Ere oꞌdɔ lende kënyë ŋgï rɔ mbëmbë. Kina ɔdɔ Bɔkoꞌba koŋgɔ lende kënyë ꞌba Ere ꞌdeni ŋgï kulöwö tara yɔ na kupö bo ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kina Yuda kilende zi kole abo ma mï rïyö mo nima kïdëkï möyï mo rɔ Onana ne. Bo iya te, “ꞌJɔkɔ yï nima ɔdɔ gɔmo kindaꞌba közïmo ꞌdɔ köyöke kole ꞌdɔ kiꞌdi dɔ löndö yï ame kölë ne kudu timo.” ");
INSERT INTO bex_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tine Onana ikali kole naga nima bo këdï köyö ti ꞌja ꞌba löndö bo nima inza kïlëbï dɔ bo kada mɔtɔ. Gɔ köꞌdu mo na ɔdɔ lïjë këdï köꞌdö ti Tamara bo ebe tiꞌdi wa dɔ bɔtɔni abo kolɔdɔ za bërï mï yayi, römöyï kinza bo köyö kole ra ti ꞌja ꞌba löndö bo nima. ");
INSERT INTO bex_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kina Bɔkoꞌba kënyï ŋgï rɔ ꞌdïrï ti Onana gɔ lende koꞌdɔ abo nima kina kupö bo ŋgï gbï yaga. ");
INSERT INTO bex_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yuda rɔ meri gɔ lende ꞌba kole rïyö abo naga nime. Gɔ köꞌdu mo na kiꞌdi bo kere ŋgï kinza Sela kari kölë ra gbï kɔzɔ a nima tara. Kina bo kiya te zi Tamara, “Ileki kari liŋɔ ꞌba ꞌbu yï koloma yayi rɔ makuruꞌbë ŋbö Sela kïyöbu.” Kina Tamara kileki ŋgï kari koloma liŋɔ ꞌba ꞌbu nï. ");
INSERT INTO bex_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mï kɔmɔ kɔɔ mɔtɔ ꞌböwu yayi na ꞌja ꞌba Yuda tönë rɔ nyiti ꞌba Suwa ne kölë ŋgï. Kina ɔdɔ bo kote tudu ꞌja abo ꞌdeni tine lïjë ënyï ti bɔ murë bo Ira tari Timana toŋgɔ bilaka abo ga ame këdï tumu sunë kamölö abo ga yayi ne. ");
INSERT INTO bex_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kina ɔdɔ Tamara kuwö lende mo kiya te lanzo nï Yuda ëdï koꞌdɔkɔ tari Timana tumu sunë kamölö abo ga tine, ");
INSERT INTO bex_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","lɔko ikali Sela kole ꞌba lanzo nï ïyöbu ꞌdeni kɔmɔ mo kɔpɔ, kina me lanzo nï oꞌdɔkɔ dë todɔ kpënï zi kole nime ꞌdɔ kɔdɔ gönï. Tine na lɔko kolɔ bɔŋgɔ ꞌba monɔ ŋgï yaga di rönï, lɔko kisali rönï kolɔ bɔŋgɔ rönï kolo mɔtɔ dönï kola ŋge rɔ kömönï. Kina lɔko kënyï ŋgï kari koloma kpa kɔri ŋɔli ŋgila gawo ꞌba Enayima kpa gɔ kɔri kari Timana. ");
INSERT INTO bex_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kina ɔdɔ Yuda kömö ꞌdeni koꞌja lɔko këdï koloma kpa kɔri tine bo omeri ꞌba bo, bo iya te bɔ rɔnyɔ na, römöyï lɔko olo kömönï ꞌdeni liyɔ teyi ti bɔŋgɔ. ");
INSERT INTO bex_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bo ikali dë kpe rɔ ꞌja ꞌba kole abo. Kina bo kilende zïnï, iya te, “Ako zö, moꞌdɔkɔ yi.” Lɔko iya te, “Waꞌdi na ti kiꞌdi zö?” ");
INSERT INTO bex_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Bo iya te, “Ti moja kole banya kako zïyï.” Lɔko iya te, “Waꞌdi na ti kiꞌdi zö tötï ꞌdɔ mikali timo ëddï koja banya kako zö?” ");
INSERT INTO bex_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Bo iya te, “Waꞌdi na koꞌdɔkɔ?” Lɔko iya te, “Iꞌdi wa ꞌba tugu möyï yï nima zö pili ti kabi mo. Kina iꞌdi përï adɔkotɔni ꞌbï nima gbï zö.” Kina ɔdɔ bo kiꞌdi wa naga nime ꞌdeni pili zïnï tine na bo köꞌdö ŋgï tïnï na lɔko kombi mï ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kina lɔko kënyï ŋgï di gɔ bi nima yayi kari ëꞌbënï. Lɔko ari kope bɔŋgɔ kolo ꞌbënï nima ŋgï yaga, lɔko kolɔ ꞌba monɔ tönë kileki rönï. ");
INSERT INTO bex_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kina Yuda koja bɔ murë bo Ira kari ti banya ꞌdɔ tari tiꞌdi mo zi bɔ rɔnyɔ tönë lïjë koꞌja di gɔ kɔri ne ꞌdɔ bo kotɔtɔ wa ma tönë ga bo kiꞌdi tötï teyi ne kako timo. Tine Ira ari koꞌja lɔko kinza kpe yayi. ");
INSERT INTO bex_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Bo ititi bilaka ꞌba gɔ bi nima yayi, bo iya te, “ꞌJa bɔ rɔnyɔ nime koloma kpa kɔri ŋɔli ŋgila gawo ꞌba Enayima bine ne, lɔko ari ꞌdeni yala?” Lïjë iya te, “ꞌJa bɔ rɔnyɔ ɔtɔ inza gɔ bi ze nime bine.” ");
INSERT INTO bex_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kina Ira kileki ŋgï kari zi Yuda. Bo iya te, “Mari moꞌja lɔko dë. Bilaka ame ga yayi ne iya zö tëgë, ꞌja bɔ rɔnyɔ ɔtɔ inza du te mï gɔ bi ꞌbënnï nima.” ");
INSERT INTO bex_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda iya te, “Iꞌdi lɔko kogba wa naga nima ka yayi. Doma gönï dë towa kinza koꞌde rɔ kaya rɔze. Moja banya zïnï kina me kari koꞌja lɔko dë, embe dë gbï.” ");
INSERT INTO bex_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mï mota ꞌba nyepe ma di pötö lende tönë na bɔ mɔtɔ kako zi Yuda, kiya te, “Tamara ꞌja ꞌba kole ꞌbï oꞌdɔ rönï ꞌdeni ŋgï rɔ bɔ rɔnyɔ kina me lɔko kɔmɔ ꞌdeni di mï kɔri ꞌba yërï koꞌdɔ ꞌbënï nima.” Yuda iya te, “Ari kindaꞌba nï kupö yaga kuꞌdu lɔko mï paꞌdo ma löbu kilaŋma yaga.” ");
INSERT INTO bex_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kina ɔdɔ lïjë kogba nï ꞌdeni këdï kari ꞌdɔ tupö mo tine, lɔko oja laja kari gɔ Yuda. Lɔko iya te, “Oŋgɔ wa naga nime te, wa ꞌba tugu möyï ti kabi mo ga pili ti përï adɔkotɔni nime. Ikali bɔ dɔmo? Bɔ dɔ wa naga nime na me kiꞌdi kole yïmö.” ");
INSERT INTO bex_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda ikali wa naga nima na bo kodɔ kpa bo ŋgï gɔ lende mo. Bo iya te, “Lende ꞌbënï ele ꞌdeni kiteli ꞌbama. Dëne ꞌdɔ miꞌdi lɔko ra zi kole ma Sela, ne kina me miꞌdi lɔko dë yɔ.” Tine Yuda ileki dë kpe köꞌdö ti Tamara. ");
INSERT INTO bex_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kina ɔdɔ kömö ꞌdeni mï kada ꞌba löyö ꞌbënï tine ikali ŋgï kole roŋa na mïnï. ");
INSERT INTO bex_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tine koꞌja lɔko këdï koꞌdɔ töyö ꞌdeni yɔ na kole ma kɔtɔ koja közïnï ŋgï yaga. Kina bɔ bulï mo kudödu kabi kasi közïmo. Lɔko iya te, “Kole nime na köyö dɔgba.” ");
INSERT INTO bex_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tine kole mo tönë ënyï kotɔ ëꞌbënï kɔnyɔ nï ꞌböwu kileki mïyö, kole mɔtɔ na za ꞌböwu köyö dɔgba. Bɔ bulï nima iya te, “Awo, oꞌdɔ ꞌbëyï ka ŋgï ti tigɔ na ma kiꞌdi kïtïrï kpa kɔri zïyï.” Gɔ köꞌdu mo na lïjë kiꞌdi möyï bo rɔ Pereze. ꞌJɔ ꞌba lende mo tëgë, “Tïtïrï kpa kɔri.” ");
INSERT INTO bex_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Tine mbowa di pötö mo na köyö kole ma tönë kudödu kabi kasi közïmo ne ŋgï. Kina lïjë kiꞌdi möyï mo rɔ Zera. ");
INSERT INTO bex_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yisamele tönë ga oto Yesepa ŋbö kari Ezipeto kari kugö zi bɔ mɔtɔ rɔ Potiparo löbu ꞌba turu ma kɔtɔ ꞌba bɔ dɔliŋɔ ꞌba Ezipeto nima rɔ bɔ dɔ bɔ kanya ne. ");
INSERT INTO bex_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tine Bɔkoꞌba ëdï nduwë ti Yesepa di yayi tokɔnyi mo ꞌdɔ wa pili ame ga bo këdï koꞌdɔ ne kari nduwë rɔ ma kodɔrɔ. Kina Yesepa koloma ŋgï rɔ atɔli ꞌba mï liŋɔ ꞌba Potiparo. ");
INSERT INTO bex_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kina ɔdɔ Potiparo koŋgɔ ꞌdeni Bɔkoꞌba këdï kokɔnyi Yesepa mï ndɔbɔ koꞌdɔ abo ga pili kiꞌdi ndɔbɔ abo këdï kari rɔ ma kodɔrɔ tine, ");
INSERT INTO bex_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","lende mo oŋmi ŋgï dökïꞌdï Potiparo rɔ mbëmbë. Kina bo kiꞌdi Yesepa ŋgï rɔ bɔ laja abo kose gɔ liŋɔ abo pili zi Yesepa ꞌdɔ koŋgɔ gɔ wa pili ame ga këdï mï liŋɔ yayi ne. ");
INSERT INTO bex_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mï kada nima Potiparo kiꞌdi Yesepa ꞌdeni rɔ bɔ koŋgɔ gɔ wa pili ꞌba mï liŋɔ abo ga ne, Bɔkoꞌba okɔnyi Potiparo gbï kiꞌdi lende mo ga pili kari rɔ ma kodɔrɔ kpaki ti wa ꞌba mï liŋɔ pili ti ꞌba mï nyaka. Bo okɔnyi Potiparo gɔ köꞌdu ꞌba Yesepa. ");
INSERT INTO bex_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kina Potiparo kiꞌdi abo ga ŋgï pili közï Yesepa ꞌdɔ koŋgɔ gɔmo bo omeri a mɔtɔ dë kpe gɔ lende ꞌba wa ꞌba mï liŋɔ abo ga tine ŋge kɔtɔ rɔ akonyo ma bo koꞌdɔkɔ tonyo mo. Yesepa rɔ kole ma kele rɔ ma kënyë, ");
INSERT INTO bex_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","gɔ köꞌdu mo na mbowa te yɔ ꞌja ꞌba Potiparo iꞌdi kömönï ŋgï dɔ bo. Mï kada mɔtɔ tine na lɔko kënyï kiya zi Yesepa, tëgë, “Ako köꞌdö tö.” ");
INSERT INTO bex_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tine Yesepa ilagi abo ŋgï. Bo iya te, “Buꞌbu, ma ame aa mï liŋɔ bine, mëꞌdë yï na gbï rɔ ŋere ma ame leꞌjete bo komeri a mɔtɔ dë kpe gɔ wa ꞌba mï liŋɔ abo. Bo kose gɔ abo ga ꞌdeni pili zö, ");
INSERT INTO bex_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","bo kiꞌdi ma ꞌdeni ti közï kakpa mbiri dɔ liŋɔ abo nime gbï kɔzɔ ꞌba bo. Bo oꞌjɔŋɔ gɔ wa ma kɔtɔ mɔtɔ te dë di zö tine ŋge kɔtɔ rɔ nï ꞌja abo. Lende ame ꞌdeni te ne ꞌdɔ mari moꞌdɔ köꞌdu ma yawa ma tara ga totondo? Ti kinza rɔ lende kënyë ma löbu kɔmɔ Bɔkoꞌba?” ");
INSERT INTO bex_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bo ilagi abo ŋgï kɔzɔ a nima tara. Kina ɔdɔ ꞌja nima köꞌbö pele tokpasi bo kote kada pili ꞌdɔ töꞌdö tïnï bo oꞌdɔkɔ abo dë. ");
INSERT INTO bex_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mï kada ma dɔ kɔtɔ mɔtɔ koꞌja Yesepa kɔdɔ ꞌdeni rö mɔtɔ bi ndɔbɔ, kina bɔ laja mɔtɔ ga inza gbï ti bo yayi, ");
INSERT INTO bex_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","na ꞌja tönë kënyï kikapo bɔŋgɔ ma kakpa ꞌba rɔ bo ŋgï, lɔko iya te, “Ako köꞌdö tö.” Na bo kolɔ rɔ bo ŋgï kola bɔŋgɔ ꞌba rɔ bo közï ꞌja tönë bo kiriŋa abo kɔdɔ yaga. ");
INSERT INTO bex_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kina ɔdɔ lɔko koŋgɔ Yesepa kiriŋa ꞌdeni kari yaga kola bɔŋgɔ nima tara tine ");
INSERT INTO bex_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","na lɔko kulörï ŋgï rɔ ma kembe kïdëkï bɔ laja ꞌbënï ga. Lɔko iya te, “Wuwu, atɔli Ebere nima mëꞌdë ma koꞌde bine ne, bo ëdï ꞌdeni leꞌjete kuyï dɔ giliti kuruku zize. Bo ɔdɔ gɔma bine gïrï nime tëgë ꞌdɔ bo köꞌdö tö. Kina me mulörï rɔ ma kembe, ");
INSERT INTO bex_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","bo kuwö mëdï mulörï yɔ na ma bo kiriŋa ŋgï kari yaga yayi kola bɔŋgɔ ꞌba rɔ bo me bine.” ");
INSERT INTO bex_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Lɔko ikeki bɔŋgɔ ꞌba Yesepa nima ŋbö kidabi mëꞌdë nï Potiparo kileki kako liŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kina lɔko kïyëtï lende mo zi bo, iya te, “Atɔli Ebere ꞌbï nima koꞌde bine ne, bo ënyï ŋgï tɔne kɔdɔ kari gɔma rö ma ꞌdë yayi toꞌdɔ lende yawa rɔma. ");
INSERT INTO bex_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mulörï dönï rɔ ma kembe na bo kiriŋa ŋgï kɔdɔ yaga kola bɔŋgɔ abo tö bine.” ");
INSERT INTO bex_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Lende nime iꞌdi Potiparo ŋgï rɔ ꞌdïrï ");
INSERT INTO bex_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","kiꞌdi bɔ kanya kindaꞌba Yesepa koto kari mï maboso ꞌba bɔ dɔliŋɔ. Kina Yesepa koloma ŋgï yayi tara. ");
INSERT INTO bex_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tine pele di mï maboso yayi Bɔkoꞌba ëdï nduwë kokɔnyi bo. Kina ɔdɔ bɔ dɔ maboso nima koŋgɔ ndɔbɔ ꞌba Yesepa ga ꞌdeni ŋgï pili rɔ ma laka tara tine, ");
INSERT INTO bex_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","bo iꞌdi Yesepa ŋgï mbiri dɔ bilaka ame ga këdï mï maboso yayi ne toŋgɔ gɔ ndɔbɔ koꞌdɔ ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Bɔ dɔ maboso nima omeri a mɔtɔ dë kpe gɔ lende ꞌba wa ame ga bo kose gɔmo ꞌdeni pili zi Yesepa ne. Bo ikali ŋgï rɔ ma laka Bɔkoꞌba ëdï ti Yesepa tokɔnyi mo kiꞌdi ndɔbɔ koꞌdɔ mo ga këdï kari pili rɔ ma kodɔrɔ. ");
INSERT INTO bex_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Mï kada ma dɔ kɔtɔ mɔtɔ na bɔ dɔliŋɔ ꞌba Ezipeto ame kïdëkï rɔ Paro ꞌbënnï mo ne kënyï ŋgï rɔ ꞌdïrï ti bilaka löbu rïyö mɔtɔ ga ma këdï koꞌdɔ ndɔbɔ zi bo. Bɔ ma kɔtɔ rɔ bɔ dɔ bɔ koti layi zi bo, tine bɔ mɔtɔ rɔ löbu ꞌba dɔ ya ma këdï koŋma maŋgolɔꞌbɔ zi bo. Bo ënyï tïnnï rɔ ꞌdïrï gɔ lende koꞌdɔ ꞌbënnï ");
INSERT INTO bex_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","kina bo kiꞌdi lïjë ŋgï mï maboso mï liŋɔ ꞌba bɔ dɔ bɔ kanya abo. Maboso nima na gbï Yesepa këdï yïmo. ");
INSERT INTO bex_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kina bɔ dɔ bɔ kanya nima kiꞌdi Yesepa ŋgï ꞌdɔ koja laja zi bilaka löbu rïyö naga nima di mï maboso yayi. Kina Yesepa koloma ŋgï rɔ toja laja zïnnï. Kina ɔdɔ lïjë koloma ꞌdeni yayi tara tine, ");
INSERT INTO bex_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","mï kada ma dɔ kɔtɔ mɔtɔ rɔ mï korɔndɔ na nyï koꞌde ŋgï dɔ bilaka löbu rïyö tönë ga di mï maboso yayi. Nyï mo ga pili rɔ ꞌberiꞌberi, kina ꞌjɔ ꞌba lende mo ga gbï pili rɔ ꞌberiꞌberi. ");
INSERT INTO bex_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yesepa ako rɔ mï dɔŋbɔ koꞌja lïjë koloma ꞌdeni ŋgï rɔ dɔ lisa. ");
INSERT INTO bex_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Bo iya te, “Waꞌdi na këddï koŋgɔke bi ꞌbawo tɔne tara gɔmo?” ");
INSERT INTO bex_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Lïjë iya te, “Nyï na koꞌde dɔze ti korɔndɔ ene kina me bɔtɔ bɔ kikali tïyëtï ꞌjɔ ꞌba lende mo ga zize inza.” Bo iya te, “Rɔ ma laka Bɔkoꞌba na këdï kiꞌdi bilaka kikali tïyëtï ꞌjɔ ꞌba nyï. Ïyëtïke gɔ nyï ꞌbe mo naga nima te zö.” ");
INSERT INTO bex_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kina bɔ ma tönë rɔ bɔ dɔ bɔ koti layi zi bɔ dɔliŋɔ ne kënyï ŋgï tïyëtï gɔ nyï ma ꞌba bo zi Yesepa, iya te, “Moꞌja mɔwɔ këdï koꞌdɔ rɔ layi, ");
INSERT INTO bex_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","dɔŋgila mo ga mota. Tine mari moꞌja këdï ꞌdeni rɔ tomo. Tëgë me mbowa te yɔ kina kumöru ŋgï kana ŋgï kasi welo. ");
INSERT INTO bex_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kösu ꞌba bɔ dɔliŋɔ ëdï közö kina miteꞌde ma kana mo ŋgï muzï tɔlɔ mo kolɔdɔ mï kösu kina mari miꞌdi ŋgï zi bɔ dɔliŋɔ.” ");
INSERT INTO bex_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yesepa iya te, “ꞌJɔ ꞌba lende ꞌba nyï ꞌbï nima kina me, dɔŋgila ŋgërï mota naga nima koꞌja ne, töꞌdö dɔ mota na. ");
INSERT INTO bex_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tine di pötö töꞌdö dɔ mota nime bɔ dɔliŋɔ ëdï koja yi yaga di mï maboso bine kileki yi mï ndɔbɔ ꞌbï ma mɔlo kari toti layi zi bo kɔzɔ ma dɔgba tara. ");
INSERT INTO bex_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ne ɔdɔ kope yi ꞌdeni yaga di mï gomɔ mbëmbë ꞌba maboso nime, momaꞌjo rɔma zïyï kinza kiꞌdi lende ma dë kudölu di döyï. Ari kokɔnyi ma ti tïyëtï gɔ lende ma zi bɔ dɔliŋɔ ꞌdɔ kiꞌdi bo kope ma gbï yaga di mï maboso nime. ");
INSERT INTO bex_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ma ꞌbama moꞌdɔ lende kënyë ɔtɔ dë yɔ, indaꞌba ma di dɔyayi ze ꞌba Ebere koꞌde ma Ezipeto bine. Di bine gbï moꞌdɔ lende kënyë ɔtɔ dë gbï yɔ kina me koꞌde ma ŋgï kako mï maboso bine.” ");
INSERT INTO bex_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kina bɔ ma löbu mɔtɔ nima ame pa rɔ bɔ koꞌdɔ maŋgolɔꞌbɔ zi bɔ dɔliŋɔ ne, ɔdɔ bo koŋgɔ ꞌdeni nyï nima ꞌjɔ ꞌba lende mo kïyëtï rönï ŋgï rɔ ma kele tara tine, bo iya te zi Yesepa, “Nyï oꞌde gbï dɔma tëgë mëdï mombi gbërë ꞌba maŋgolɔꞌbɔ mota dɔma. ");
INSERT INTO bex_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tine mï gbërë ame dɔ ama ga ne dɔkomali maŋgolɔꞌbɔ ëdï yïmo ame koꞌde ꞌdeni zi bɔ dɔliŋɔ ne. Kina yali kako ŋgï koloma togɔ maŋgolɔꞌbɔ mo naga nima.” ");
INSERT INTO bex_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yesepa iya te, “ꞌJɔ ꞌba lende ꞌba nyï ꞌbï nima kina kɔzɔ a nime te. Gbërë mota naga nima kombi ne töꞌdö dɔ mota na. ");
INSERT INTO bex_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tine di pötö töꞌdö dɔ mota bɔ dɔliŋɔ ëdï koja yi yaga di mï maboso nime kari kosi mugu yï dɔ ŋgërï tɔrɔ kölë yaga. Kina yali ti kako ŋgï kogɔ yida yï pili yaga.” ");
INSERT INTO bex_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mï töꞌdö dɔ mota na bɔ dɔliŋɔ koja ŋbele ꞌba kada ꞌba töyö bo ŋgï yaga, bo kïdëkï bilaka löbu abo ga pili kako yïmo. Kina bo kiꞌdi koꞌde ya rïyö tönë ga ŋgï di mï maboso kako kɔrɔ kɔmɔ ŋba abo naga nima. ");
INSERT INTO bex_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Bɔ ma tönë rɔ bɔ koti layi ne bo ileki ŋgï mï ndɔbɔ mo ma mɔlo kisaki toti layi mï kada nima. ");
INSERT INTO bex_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tine bɔ ma tönë rɔ bɔ koŋma maŋgolɔꞌbɔ ne bo iꞌdi ŋgï kupö yaga ti tosi mugu mo dɔ ŋgërï tɔrɔ. Lende naga nime oꞌdɔ rönnï ŋgï zi ya rïyö tönë ga te kɔzɔ lende tönë ga Yesepa kiya zïnnï ne. ");
INSERT INTO bex_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tine bɔ ma tönë rɔ bɔ koti layi ne omeri a mɔtɔ dë kpe gɔ lende ꞌba Yesepa. Dɔ bo udölu ŋgï di gɔ lende ꞌba Yesepa. ");
INSERT INTO bex_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Mï rïyö ꞌba kɔɔ ma di pötö mo na nyï koꞌde ŋgï dɔ bɔ dɔliŋɔ ꞌba Ezipeto nima mï kada ma dɔ kɔtɔ mɔtɔ. Nyï oꞌde dɔ bo tëgë bo ëdï kɔrɔ kpa yöpö ame kïdëkï möyï mo rɔ Nayile ne. ");
INSERT INTO bex_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kina sa ma kɔnɔ modɔmorïyö mɔtɔ ga kɔdɔ ŋgï di mï yöpö kari tonyo mɔli. Sa naga nima ti yëyï rönnï rɔ ma laka kɔnɔ rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tine na sa modɔmorïyö mɔtɔ ga rɔ ma kilike gɔꞌdɔgɔꞌdɔ kɔdɔ ŋgï gbï di mï yöpö kari kɔrɔ ŋgila ma kɔnɔ tönë ga. ");
INSERT INTO bex_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kina sa ma kilike naga nima kindiyɔ sa ma kɔnɔ tönë ga ŋgï pili yaga. Kina bo kindiŋi ŋgï yaga di bi töꞌdö. ");
INSERT INTO bex_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Bo ileki köꞌdö kina nyï mɔtɔ koꞌde ꞌböwu dɔ bo, tëgë bo oꞌja dɔ nyönyu modɔmorïyö köyö pili dɔ kumögu kɔtɔ. Dɔ nyönyu mo ga rɔ ma löbu gbölögbölö. ");
INSERT INTO bex_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tine na dɔ nyönyu modɔmorïyö mɔtɔ ga köyö ŋgï gbï yayi. Nyönyu mo naga nima lili ma kututu oꞌdɔ ꞌdeni kolomba yaga, lïjë ꞌbënnï titititi yiliyili. ");
INSERT INTO bex_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kina dɔ nyönyu ma yiliyili naga nima kënyï kindiyɔ dɔ nyönyu ma löbu tönë ga ŋgï pili yaga. Bɔ dɔliŋɔ indiŋi di bi töꞌdö kikali ŋgï rɔ nyï na koꞌde dɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mï dɔŋbɔ mo na bo ŋgï ti meri rɔ mbëmbë gɔ lende ꞌba nyï nima koꞌde dɔ bo ne. Kina bo kïdëkï bɔ kikali lende abo ga pili kako zi bo ti bɔ ꞌbɔsi ma kata naga. Kina bo kïyëtï gɔ nyï abo tönë ga ŋgï pili zïnnï. Tine bɔtɔ ma kɔtɔ mɔtɔ te di mï löŋgö lïjë nima pili ikali ꞌjɔ ꞌba lende mo dë du te. ");
INSERT INTO bex_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Mï kada mo nima na bɔ ma tönë rɔ bɔ koti layi zi bo ne kako kiya zi bo, iya te, “Ŋere, mï kada tönë mirasi lende zïyï ");
INSERT INTO bex_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ꞌdɔ kënyï rɔ ꞌdïrï tize ze ti bɔ ma tönë rɔ löbu ꞌba bɔ koŋma maŋgolɔꞌbɔ kindaꞌba ze kiꞌdi mï maboso liŋɔ ꞌba bɔ dɔ bɔ kanya ne, ");
INSERT INTO bex_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","mï kada nima dëdï yayi nyï oꞌde dɔze kpaki rïyö mï korɔndɔ kɔtɔ. Nyï mo ga pili rɔ ꞌberiꞌberi kina ꞌjɔ ꞌba lende mo ga gbï pili rɔ ꞌberiꞌberi. ");
INSERT INTO bex_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tine bɔ Ebere mɔtɔ ëdï tize mï maboso yayi rɔ bɔ laja ꞌba bɔ dɔ bɔ kanya mo nima. Kina dïyëtï gɔ nyï ze naga nima zi bo na bo kiya ꞌjɔ ꞌba lende mo ga ŋgï pili zize. ");
INSERT INTO bex_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kina lende tönë ga koꞌdɔ rönnï ŋgï pili kɔzɔ wa ame ga bo kiya zize ne tara. ꞌBama ileki ma ŋgï mï ndɔbɔ ma, ma mɔlo kina ꞌba bɔ ma tönë osi mugu mo ŋgï dɔ ŋgërï tɔrɔ kölë yaga.” ");
INSERT INTO bex_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kina ɔdɔ bɔ dɔliŋɔ kuwö lende ꞌba bɔ koti layi abo nima ꞌdeni tara tine, bo oja laja ŋgï kari gɔ Yesepa ꞌdɔ koꞌde kako zi bo. Kina kari ŋgï welo gɔ Yesepa koja yaga di mï maboso kumu sunë yaga di dɔmo kiꞌdi kisali rɔ bo kolɔ bɔŋgɔ ma laꞌja. Kina koꞌde bo ŋgï kako kɔrɔ kɔmɔ bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Bɔ dɔliŋɔ iya te, “Nyï oꞌde dɔma kina me bɔ kïyëtï ꞌjɔ ꞌba lende mo zö inza. Kina me bilaka mɔtɔ kiya lende ꞌbï zö bine tëgë ɔdɔ bilaka kïyëtï gɔ nyï ꞌbënnï ga zïyï, iya ꞌjɔ ꞌba lende mo ga ŋgï pili zïnnï.” ");
INSERT INTO bex_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yesepa iya te, “Ti gbagba ma mikali dë, ne Bɔkoꞌba na kikali tïyëtï ꞌjɔ ꞌba lende rɔ ma laka.” ");
INSERT INTO bex_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kina bɔ dɔliŋɔ kënyï ŋgï tïyëtï gɔ nyï abo tönë ga zi Yesepa. Bo iya te, “Nyï nime oꞌde dɔma tëgë mëdï mɔrɔ kpa yöpö Nayile. ");
INSERT INTO bex_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kina sa modɔmorïyö kɔdɔ ŋgï di mï yöpö kari tonyo dɔ mɔli di kpa yöpö yayi. Sa mo naga nima ti yëyï rönnï rɔ ma kɔnɔ. ");
INSERT INTO bex_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kina sa ma modɔmorïyö mɔtɔ ga kɔdɔ gbï di mï yöpö kozi kari gɔ ama ga yayi. Lïjë ꞌbënnï rɔ ma kilike gɔꞌdɔgɔꞌdɔ kɔmɔ rögbö mo ga kinda ŋgï yaga saŋiyi. Kïnë sa ma kilike kɔzɔ a nime te moꞌja dë gba mɔlo mï dɔyayi nime bine. ");
INSERT INTO bex_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kina sa ma kilike tönë ga kindiyɔ sa ma kɔnɔ tönë ga ŋgï pili yaga. ");
INSERT INTO bex_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tine ikali dë gbï kɔzɔ iya te lïjë indiyɔ ma kɔnɔ naga nima tara, lïjë öꞌbö ŋgï te rɔ ma kilike. Kina mindiŋi yaga di bi töꞌdö. ");
INSERT INTO bex_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nyï mɔtɔ oꞌde ꞌböwu dɔma tëgë moꞌja dɔ nyönyu modɔmorïyö köyö ꞌdeni dɔ kumögu kɔtɔ pili rɔ ma löbu gbölögbölö. ");
INSERT INTO bex_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kina dɔ nyönyu modɔmorïyö mɔtɔ ga köyö ꞌböwu gbï yayi. Lïjë ꞌbënnï titi yiliyili lili ma kututu oꞌdɔ ꞌdeni kolomba yaga. ");
INSERT INTO bex_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kina dɔ nyönyu ma titi tönë ga kënyï kindiyɔ dɔ nyönyu ma löbu tönë ga ŋgï pili yaga. Nyï naga nime koꞌde dɔma ne na kɔzɔ a nima tara. Kina me mïyëtï gɔmo zi bɔ ꞌbɔsi ma kata naga tine lïjë ikali ꞌjɔ ꞌba lende mo dë du te.” ");
INSERT INTO bex_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yesepa iya te, “Nyï rïyö naga nima koꞌde döyï ne ꞌjɔ ꞌba lende mo ŋge kɔtɔ. Wa ame ga Bɔkoꞌba koꞌdɔkɔ toꞌdɔ mo ne na ma kileme ꞌdeni zïyï. ");
INSERT INTO bex_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sa modɔmorïyö ma kɔnɔ naga nima ileme kɔmɔ kɔɔ modɔmorïyö. Kina dɔ nyönyu ma löbu gbölögbölö naga nima ileme kɔmɔ kɔɔ gbï modɔmorïyö. ꞌJɔ ꞌba lende mo ŋge kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sa ma kilike naga nima kɔdɔ di mï yöpö kozi gɔ ya ama ga ne ileme kɔmɔ kɔɔ gbï modɔmorïyö. Kina dɔ nyönyu ma titi rɔ ma kolomba di zi lili ma kututu naga nima ileme kɔmɔ kɔɔ gbï modɔmorïyö. Sëyï ëdï kako koꞌdɔ ŋbö kɔmɔ kɔɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Lende nima na kɔzɔ wa nima miya zïyï ne tara, ŋere. Bɔkoꞌba ëdï kileme wa ame ga bo koꞌdɔkɔ toꞌdɔ mo ne zïyï. ");
INSERT INTO bex_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dɔgba mo akonyo ëdï kɔdɔ rɔ mbëmbë ŋbö kɔmɔ kɔɔ modɔmorïyö mï dɔliŋɔ pili ꞌba Ezipeto. ");
INSERT INTO bex_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kina di pötö mo na sëyï ma löbu këdï kilaꞌba ŋgï dɔyayi. Mï kada mo nima dɔ bilaka ti kudölu me di gɔ bi konyo löbu, kina ꞌbö ti kirasi dɔliŋɔ ŋgï mï kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ꞌBö ti koꞌdɔ bilaka ꞌdeni ŋgï rɔ mbëmbë, dönnï kudölu di gɔ kada ma tönë ga akonyo këdï rɔ ma konya ne. ");
INSERT INTO bex_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nyï nima oꞌde döyï mï rïyö gɔ kileme ŋgï zïyï rɔ ma laka Bɔkoꞌba oꞌdɔkɔ ꞌdeni toꞌdɔ lende nima, bo uyï yïmo dë kpe. Kina kada mo ɔwɔ dë gbï.” ");
INSERT INTO bex_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Yesepa ileki gbï kiya zi bɔ dɔliŋɔ, kiya te, “Kina ma ꞌdeni kɔzɔ wa nima tara, ŋere, ma laka mo na ꞌdɔ koŋgɔ bilaka mɔtɔ ame kikali lende ne gɔ kiꞌdi bo këdï mbiri dɔ dɔliŋɔ nime. ");
INSERT INTO bex_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Oꞌdɔkɔ zïyï gbï toŋgɔ bilaka löbu mɔtɔ ga gɔ koŋgɔ gɔ wa laka mï kɔmɔ kɔɔ modɔmorïyö ame ga akonyo këdï kɔdɔ teyi rɔ mbëmbë ne. Mï kɔmɔ kɔɔ naga nima iꞌdi bilaka koza kapa ma muyï ꞌba ëꞌbënnï ga ꞌdɔ bilaka löbu naga nima kotɔtɔ ");
INSERT INTO bex_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","kikeki mï mata kote mï gawo pili ꞌba dɔliŋɔ nime. Kina ꞌdɔ lïjë këdï ti közï kakpa ꞌba toda bi rɔmo laka mï kɔmɔ kɔɔ ame ga akonyo këdï gba rɔ mbëmbë ne. ");
INSERT INTO bex_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tine ɔdɔ sëyï nima kilaꞌba ꞌdeni mï dɔliŋɔ gɔ koꞌdɔ kɔmɔ kɔɔ modɔmorïyö, nyönyu nima na ti kokɔnyi bilaka ꞌba dɔyayi nime kinza ꞌbö kote dɔ dɔliŋɔ nime ra.” ");
INSERT INTO bex_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kina bɔ dɔliŋɔ ni kpaki ti bilaka ma löbu abo ga kutï ŋgï gɔ lende ꞌba Yesepa nime. Lïjë iya te, “Lende nima ëdï laka.” ");
INSERT INTO bex_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tine bɔ dɔliŋɔ iya zi bilaka naga nima, iya te, “Bɔ nime Bɔkoꞌba ëdï ti bo. Oꞌjake bɔtɔ mɔtɔ ra kɔzɔ bo te?” ");
INSERT INTO bex_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kina bo kileki zi Yesepa, bo iya te, “Doŋgɔ ꞌdeni Bɔkoꞌba na me kileme lende nime zïyï ne tine bɔtɔ mɔtɔ ame gɔ kikali lende kulöwö rɔ dɔ kiteli di döyï ne inza. ");
INSERT INTO bex_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nï na miꞌdi yi ꞌdeni gɔ këddï mbiri dɔ dɔliŋɔ ma nime. Bilaka pili ꞌba dɔliŋɔ nime ti koro yi ŋgï. Bɔtɔ mɔtɔ inza mbiri di döyï ŋge kɔtɔ rɔ ma bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Tɔne miꞌdi yi ꞌdeni gɔ këddï ti közï kakpa dɔ dɔliŋɔ ꞌba Ezipeto nime.” ");
INSERT INTO bex_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kina bɔ dɔliŋɔ kogba wa ꞌba dɔkole közï bo ŋgï kolɔ dɔkole közï Yesepa. Wa nima na rɔ a ꞌba tugu möyï ꞌba ŋere abo timo. Bo ogba bɔŋgɔ ma kele rɔ dɔ kiteli kolɔ rɔ Yesepa gbï ti amugu ame kileŋo di mï yamo ma köbö ne. ");
INSERT INTO bex_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Aribiya abo ame kosani na këdï kotɔ ne bo iꞌdi ma kɔtɔ gbï zi Yesepa. Kïnë aribiya nima mɔtɔ ma kele kiteli inza ŋge kɔtɔ rɔ ame rɔ ꞌba bo ne. Bo iꞌdi zi Yesepa gɔ kiliŋgere timo. Ɔdɔ kiya te Yesepa këdï kari bi mo nima bilaka mɔtɔ ga kari tötï dɔgba tuwöwö mo, kiya te, “Ileŋoke kɔri laka.” Tiꞌdi ma bɔ dɔliŋɔ kiꞌdi Yesepa rɔ turu ma löbu toŋgɔ gɔ dɔyayi pili ꞌba Ezipeto na kɔzɔ a nima tara. ");
INSERT INTO bex_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Bo ileki kiya gbï zi Yesepa, iya te, “Ma bɔ dɔliŋɔ miya ꞌdeni zi bilaka pili ꞌba Ezipeto nime, bɔtɔ mɔtɔ inza koꞌdɔ wa ma titi mɔtɔ te, pele ŋge rɔ tombi közï ala tombi ndï, tine ŋge kɔtɔ ɔdɔ nï na kiya zi bɔ mo tɔ nima ꞌdɔ koꞌdɔ.” ");
INSERT INTO bex_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kina bo kiꞌdi möyï Yesepa ŋgï rɔ Zepenata Peneya rɔ kpënnï Ezipeto. Kina bo kiꞌdi Asenata nyiti ꞌba Potipera bɔ kata ame koloma mï gawo ꞌba Ɔno ne ŋgï rɔ ꞌja zi Yesepa. Kina Yesepa koloma ŋgï tiliŋgere kote mï dɔyayi ꞌba Ezipeto toŋgɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Mï kada nima Yesepa kisaki toꞌdɔ ndɔbɔ nime ti bɔ dɔliŋɔ ꞌba Ezipeto ne kɔmɔ kɔɔ abo ëdï ꞌdeni ꞌbutë mota. Bo ënyï kiliŋgere kote bi pili mï dɔyayi nima toŋgɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kina mï kada ꞌba kɔmɔ kɔɔ modɔmorïyö naga nima wa ꞌba mï nyaka ɔdɔ ŋgï rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Mï kada nima nyönyu këdï kɔdɔ rɔ mbëmbë ne, Yesepa otɔtɔ kikeki mï mata kote dɔ gawo pili. Mï gawo pili rɔ kɔtɔkɔtɔ otɔtɔ rɔ nyönyu ma mï nyaka ma ŋɔliŋɔli ŋgila mo. ");
INSERT INTO bex_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kina nyönyu ame kulu mï mata ne ŋgï rɔ mbëmbë kɔzɔ yayi lida ꞌba kpa mini löbu. Lïjë ikali dë kpe tiyari mo. ");
INSERT INTO bex_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mï kada naga nima gba kinza sëyï kilaꞌba dë Yesepa öyö kole ꞌdeni rïyö ti ꞌja abo Asenata. ");
INSERT INTO bex_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Bo iya te, “Bɔkoꞌba iꞌdi dɔma ꞌdeni kudölu di gɔ gomɔ pili ame ga moꞌja ne. Bo iꞌdi dɔma kudölu ꞌdeni gbï di gɔ lende ꞌba liŋɔ ꞌba ꞌbu ma.” Gɔ köꞌdu mo na ꞌdɔ bo kiꞌdi möyï kole abo ma dɔndende mo rɔ Manase, ame kiya te “Udölu.” ");
INSERT INTO bex_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Bo iya gbï te, “Bɔkoꞌba iꞌdi ma ꞌdeni möyö kole mï dɔyayi nime moꞌja gomɔ kulöwö di teyi ne.” Gɔ köꞌdu mo na bo kiꞌdi möyï kole abo ma mï rïyö mo rɔ Eporima, ame kiya te “Iꞌdi löyö.” ");
INSERT INTO bex_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kɔmɔ kɔɔ modɔmorïyö naga nima wa ꞌba mï nyaka këdï kɔdɔ kulöwö teyi ne ari kote rönnï gbɔ ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kina kɔmɔ kɔɔ modɔmorïyö ꞌba sëyï tönë kisaki ŋgï toꞌdɔ bilaka kɔzɔ lende tönë Yesepa kiya ne. Mï kada naga nima ꞌbö ilaꞌba ꞌdeni mï dɔliŋɔ mɔtɔ ga pili, tine Ezipeto na ŋge gba akonyo këdï teyi. ");
INSERT INTO bex_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ꞌBö isaki ŋgï gbï toꞌdɔ bilaka ꞌba Ezipeto tine na lïjë kari zi bɔ dɔliŋɔ tokpasi bo gɔ bo kiꞌdi akonyo zïnnï. Bo iya te, “Arike zi Yesepa, wa ame ga pili bo kiya ziye ne oꞌdɔke.” ");
INSERT INTO bex_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kina ɔdɔ sëyï kilaꞌba ꞌdeni mï dɔyayi pili tine na Yesepa kope kpa mata tönë ga pili bo kikeki nyönyu yïmo ne ŋgï yaga tugö mo zi Ezipeto. Bo ugö zïnnï römöyï ꞌbö ëdï ꞌdeni koꞌdɔ lïjë rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mï kada naga nima bilaka ako Ezipeto di dɔliŋɔ mɔtɔ ga pili tugö nyönyu di zi Yesepa römöyï sëyï ilaꞌba ꞌdeni gbï mï dɔliŋɔ ma ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakoba ꞌbu ꞌba Yesepa uwö lëbï mo gbï di liŋɔ abo ma nyönyu këdï mï dɔyayi ꞌba Ezipeto. Bo iya zi kole abo ga, bo iya te, “Waꞌdi na këddï kolomake ꞌbeye te gɔmo? ");
INSERT INTO bex_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Muwö lende mo tëgë nyönyu ëdï Ezipeto. Ënyï kari kugöke nyönyu zize di yayi kinza ꞌbö kupö ze.” ");
INSERT INTO bex_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kina kole ꞌba Yakoba ga ma ꞌbutë kënyï ŋgï kari Ezipeto tugö nyönyu di yayi. ");
INSERT INTO bex_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tine Yakoba ota gɔ kole abo Benyimona bɔ löndö Yesepa di bi tari. Bo ere römöyï kinza wa ma kënyë mɔtɔ kari kömö ra gbï dɔmo di yayi. Gɔ köꞌdu mo na bo koꞌdɔkɔ dë tiꞌdi Benyimona kari ti löndö bo naga nima. ");
INSERT INTO bex_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kole ꞌba Yakoba ga ari ti bilaka ꞌba dɔliŋɔ mɔtɔ ga tari tugö nyönyu di Ezipeto. Lïjë ari römöyï sëyï ame kilaꞌba ꞌdeni dɔyayi ꞌbënnï ꞌba Kanana ne. ");
INSERT INTO bex_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mï kada nima Yesepa na ꞌdeni rɔ turu löbu mbiri dɔ dɔyayi ꞌba Ezipeto. Bo na rɔ bɔ kugö nyönyu zi bilaka pili. Kina bɔ löndö bo tönë ga kako kɔdɔ ŋgï mï gɔ bi ame bo këdï teyi ne. Tine na lïjë kako ŋgï kolɔdɔ bërï kɔmɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kina ɔdɔ Yesepa koꞌja lïjë ꞌdeni tine, bo ikali lïjë ŋgï rɔ löndö bo ga. Tine bo oꞌdɔ abo rɔ bo le kɔzɔ iya te bo ikali lïjë dë tara. Bo ilende rɔ ma kisili gönnï, bo iya te, “Akoke di yala?” Lïjë iya te, “Dako di Kanana ꞌdɔ tugö nyönyu di bine.” ");
INSERT INTO bex_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kina Yesepa kikali ŋgï rɔ ma laka omba ya naga nima löndö bo ga na, tine lïjë ikali bo dë kpe. ");
INSERT INTO bex_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kina bo komeri gɔ lende ꞌba nyï ma tönë ga koꞌde dɔ bo mɔlo gɔ lende ꞌba löndö bo ga ne ŋgï. Kina bo kiya te zïnnï, “Kpe bɔ kore na, akoke toŋgɔ dɔliŋɔ ze nime gɔ kikalike kɔri ame ꞌdɔ kaloke ya dɔze timo ne.” ");
INSERT INTO bex_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Lïjë iya te, “Ŋere, inza tara. Ze ꞌbeze ŋgï kɔzɔ kole ꞌbï ga tara. Dako eze ŋge gɔ nyönyu ꞌdɔ dugö di bine. ");
INSERT INTO bex_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ze nime pili rɔ kole ꞌba ꞌbu kɔtɔ, rɔ ma laka ze bɔ dɔ kïndëndë na dë. Dako dë bine kɔzɔ bɔ kore tara.” ");
INSERT INTO bex_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Bo iya te, “Inza tara, mikali rɔ ma laka akoke toŋgɔ kɔri ame gɔ kaloke ya timo dɔze ne.” ");
INSERT INTO bex_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Lïjë iya te, “Ŋere, ze nime dëdï ꞌbutë dɔmorïyö pili rɔ kole ꞌba ꞌbu kɔtɔ. Ze kole ꞌba bulöbu mɔtɔ këdï koloma Kanana na. Löndö ze ma kɔtɔ ölë ꞌdeni kina tundu mo na kileke liŋɔ ti ꞌbu ze.” ");
INSERT INTO bex_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Bo iya te, “Mikali ꞌdeni rɔ ma laka ëdï kɔzɔ lende nime miya bine ne kpe bɔ kore na ꞌbiri. ");
INSERT INTO bex_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ne ti miyɔzɔ lende ꞌbe nima. Mulömu rɔma kɔmɔye pili ti möyï ŋere, ɔdɔ kiya te koꞌdeke löndö ye ma titi tɔ nima dë a mɔtɔ inza kombike ndïye di gɔ bi nime bine. ");
INSERT INTO bex_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Kina oŋgɔke bɔ mɔtɔ leꞌjete di mï löŋgö ye bina gɔ kileki kari koꞌde bɔ löndö ye nima kako bine. Kpe ya mɔtɔ mo naga nima ilekeke ꞌbeye bine rɔ ꞌbɔki ŋbö bo kuyï dɔ bo. Ɔdɔ kiya te koꞌdɔke dë te mëdï mikali ŋgï rɔ ma laka, omba kpe bɔ kore na.” ");
INSERT INTO bex_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kina bo kiꞌdi lïjë ŋgï pili mï maboso koloma yayi ŋbö töꞌdö dɔ mota. ");
INSERT INTO bex_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mï töꞌdö dɔ mota na bo kiya zïnnï, bo iya te, “Ma rɔ bɔ koro Bɔkoꞌba. Wa ame ga pili mëdï miya ziye ne oꞌdɔke kina ti kɔmɔke ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ɔdɔ kiya te kinzake ŋgï rɔ ma laka rɔ bɔ dɔ kïndëndë iꞌdike bɔ ma kɔtɔ kileke bine rɔ ꞌbɔki, kina gɔ kpe ya mɔtɔ mo naga nima kotoke nyönyu ame ga kugöke ꞌdeni ne kari zi bilaka ꞌbe ame ga rɔ ꞌbö di pötö ye ꞌdë ne. ");
INSERT INTO bex_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kina gɔ kari kakoke ti bɔ löndö ye ma titi nima koꞌdeke bo kako bine. Tine na ti mikali ŋgï rɔ ma laka omba lende ꞌbe ëdï rɔ ma kodɔrɔ kina minza mupö ye kpe.” Kina lïjë kutï ŋgï gɔ lende abo nima. ");
INSERT INTO bex_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Lïjë ebe tiya mo rɔ gɔ rönnï, tëgë, “Rɔ ma laka Bɔkoꞌba ëdï ꞌdeni kiꞌdi gomɔ nime dɔze gɔ köꞌdu ꞌba lende kënyë tönë doꞌdɔke mɔlo zi bɔ löndö ze Yesepa ne. Mï kada nima bo oloma tomaꞌjo rɔ bo zize gɔ dolake bo gbɔ. Ne duwöke lende ꞌba rɔ komaꞌjo abo dë gbï yɔ, ma doŋgɔke gomɔ ꞌba rɔ bo pele rɔ mbëmbë dititike lende mo dë gbï yɔ. Kina me leꞌjete doꞌjake gomɔ mo ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubënï iya te, “Miya dë su ziye mï kada tönë miya te kinza koꞌdɔke ɔtɔ dë zi bɔ titi nima? Ne oꞌja uwöke lende ma dë ꞌdi. Kina ma dɔkolo ꞌba löpö tönë na me Bɔkoꞌba këdï ꞌdeni kiꞌdi gomɔ mo dɔze.” ");
INSERT INTO bex_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Dëmba Yesepa uwö lende kiya ꞌbënnï nima ꞌdeni le, tine lïjë ikali dë römöyï pa bɔ mɔtɔ na koloma tiyari kpënnï zi bo rɔ kpa Ezipeto. ");
INSERT INTO bex_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kina ɔdɔ bo kuwö lende ꞌbënnï nima ꞌdeni tara tine, bo ënyï ŋgï kɔdɔ yaga bi monɔ. Bo ileki kako kilende ꞌböwu zïnnï kina bo kigeli Simona ŋgï di mï löŋgö lïjë, bo kiꞌdi kudödu di kɔmɔ lïjë pili te. ");
INSERT INTO bex_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kina Yesepa koja bɔ laja abo ga kari tiyari nyönyu mï sorowali ꞌba löndö bo naga nima. Bo iya gbï zi bɔ laja naga nima gɔ kogba yamo ame ga lïjë kugö nyönyu timo ne kileki kiꞌdi kpa sorowali mo ga. Kina bo koja bɔ laja abo ga ŋgï kari kiꞌdi akonyo zïnnï gɔ lïjë konyo di gɔ kɔri. Kina koꞌdɔ ŋgï pili kɔzɔ lende nima tara. ");
INSERT INTO bex_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Bɔ löndö Yesepa naga nima udödu sorowali ꞌbënnï ga ŋgï gɔ akaca ꞌbënnï ga lïjë kösö dɔmo. ");
INSERT INTO bex_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Lïjë iliŋgere ŋbö kari kömö gɔ bi ame lïjë koꞌdɔkɔ töꞌdö teyi ne. Bɔ mɔtɔ ope kpa sorowali ꞌba bo togba nyönyu tiꞌdi mo zi akaca abo. Tine bo oŋgɔ te, yamo abo ëdï kpa sorowali yayi. ");
INSERT INTO bex_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Bo iya te zi bɔ löndö bo ga, “Yamo ma tönë mugö nyönyu timo ne lïjë ileki ꞌdeni ꞌböwu zö. Oŋgɔke tɔma kina me kpa sorowali ma dayi.” Kina ɔdɔ lïjë koŋgɔ wa nima ꞌdeni tara lïjë ënyï ŋgï pili rɔ tikere. Lïjë iya te, “Wë, waꞌdi na Bɔkoꞌba këdï koꞌdɔ kulöwö zize te nime?” ");
INSERT INTO bex_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kina lïjë kari ŋgï nduwë liŋɔ zi ꞌbu nnï Yakoba mï Kanana. Ɔdɔ lïjë kömö ꞌdeni yayi tine lïjë ïyëtï gɔ wa ame ga koꞌdɔ rönnï zïnnï di Ezipeto ne pili zi bo. Lïjë iya te, ");
INSERT INTO bex_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Bɔ ame rɔ löbu ꞌba dɔ Ezipeto mo ne ilende ŋgï rɔ ma kisili gɔze, bo iya te tëgë ze bɔ kore na doꞌdɔkɔ toŋgɔ kɔri ame gɔ dalo ya timo dɔ dɔyayi ꞌbënnï ne. ");
INSERT INTO bex_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kina dileki diya zi bo, diya te, ze bɔ kore na dë, ze bilaka ma sari na. ");
INSERT INTO bex_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Diya te ze nime pili rɔ löndö kɔtɔ ꞌbutë dɔmorïyö rɔ kole ꞌba ꞌbu kɔtɔ, kina löndö ze ma kɔtɔ ölë ꞌdeni tundu mo na kileke liŋɔ ꞌdë yayi ti ꞌbu ze mï dɔyayi ꞌba Kanana. ");
INSERT INTO bex_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kina bɔ löbu mo nima omeri dë du te mï lende kiya ze. Bo iya te, ‘Ti miyɔzɔ lende ꞌbe nima, ɔdɔ këddïke rɔ bilaka ma sari iꞌdike bɔ ma kɔtɔ kileke tö bine. Kpe ya mɔtɔ mo naga nima ileki karike ti nyönyu tokɔnyi bilaka ꞌbe ga timo kinza ꞌbö kupö lïjë ra. ");
INSERT INTO bex_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kina ari koꞌdeke bɔ löndö ye ma titi nima kakoke timo bine gɔ mikali omba kpe eꞌbe rɔ bilaka ma sari. Kina ti mileki bɔ löndö ye ame kileke bine rɔ ꞌbɔki ne ŋgï ziye gɔ kugöke ndögö nduwë di bine.’ ” ");
INSERT INTO bex_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Lïjë ïyëtï gɔ lende nime pili te zi ꞌbu nnï, kina lïjë kope kpa sorowali ꞌbënnï ga ŋgï. Tine lïjë oꞌja yamo ꞌbënnï ga pili di kpa sorowali ꞌbënnï ga rɔ kɔtɔkɔtɔ. Kina ɔdɔ lïjë koꞌja yamo ꞌbënnï ga ꞌdeni pili tara tine, lïjë ŋgï rɔ tikere rɔ ma kënyë gɔ lende mo. ꞌBu nnï gbï ŋgï rɔ tikere, ");
INSERT INTO bex_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","bo iya te zïnnï, “Waꞌdi na këddï kolɔlɔke kole ma naga nime kari mökö di rɔma teyi? Yesepa ölu ꞌdeni gbï kina me Simona kölu ꞌdeni gbï, kina me ꞌböwu koꞌdɔkɔke ꞌdeni gbï gɔ kogbake Benyimona gbï yaga di zö. Waꞌdi na këddï kodɔke gomɔ rɔma kulöwö te gɔmo?” ");
INSERT INTO bex_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubënï iya te, “Iꞌdi Benyimona közö mari timo. Mëdï moŋgɔ gɔ bo laka mileki ti bo zïyï bine. Minza mola a mɔtɔ kömö rɔ bo. Kina ɔdɔ kiya te mileki bo dë kako zïyï bine ogba kole bɔtɔni rïyö ma naga nime kupö yaga kpa dɔkolo mo.” ");
INSERT INTO bex_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tine ꞌbu nnï utï dë gɔ lende nima. Bo iya te, “Kole ma nime inza kari tiye. Löndö bo ölë ꞌdeni gbï, bo na me kola ŋge kɔtɔ. Ɔdɔ a mɔtɔ kari kömö dɔ bo di bi liŋgere nima yayi lisa ma kënyë na koꞌdeke ꞌdeni zö. Möndë ama ꞌdeni, meri mo na ŋgï këdï kosɔsɔ ma.” ");
INSERT INTO bex_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tine sëyï nima kilaꞌba mï dɔyayi ꞌba Kanana ne ꞌdeni ŋgï rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kina ɔdɔ eꞌbe Yakoba ga konyo nyönyu ma tönë kugö kako timo di Ezipeto ne ꞌdeni kote tine, bo iya zi kole abo ga, bo iya te, “Arike Ezipeto tugö nyönyu zize.” ");
INSERT INTO bex_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Kole abo Yuda iya te, “Turu löbu ꞌba Ezipeto mo nima tönë dari yayi ne bo ilende zize rɔ ma kisili. Bo iya te ɔdɔ doꞌde bɔ löndö ze ma titi nime dë, a mɔtɔ bo oꞌdɔkɔ dë kpe gɔ bo koꞌja kïnë ze kɔmɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kina me ɔdɔ kiya te kodɔ kpa bɔ löndö ze ma titi nima ꞌdeni gɔ kari tize, dëdï dari ŋgï dugö nyönyu dako timo zïyï. ");
INSERT INTO bex_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ne ɔdɔ kutï dë gɔ lende ze nime ti dari yayi rɔ ma totondo ga? Bɔ nima iya te a mɔtɔ bo oꞌdɔkɔ dë gɔ bo koꞌja kïnë ze kɔmɔ bo, ɔdɔ kiya te doꞌde bɔ löndö ze ma titi nime dë.” ");
INSERT INTO bex_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakoba iya te, “Ne ꞌdi, waꞌdi na kiyake zi bo kiyake te ëddïke ti löndö ye mɔtɔ gɔmo? Gɔ waꞌdi na koꞌdɔke lende tara, këddï kiꞌdike ma ŋgï milisa kulöwö te gɔmo?” ");
INSERT INTO bex_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Lïjë iya te, “Bɔ mo nima oloma ŋgï tititi ze rɔ aliri gɔ lende ꞌba bilaka ze ga pili. Bo ititi ze tëgë ɔdɔ ꞌbu ze ëdï. Kina bo kititi ze gbï tëgë ɔdɔ dëdï ti löndö ze mɔtɔ. Gɔ köꞌdu mo na me kiꞌdi ꞌdɔ diya lende ꞌba Benyimona zi bo gɔmo ne, gɔ akititi ame bo këdï kititi ze timo. Ne dikali tondo ma bo koꞌdɔkɔ gɔ doꞌde bɔ löndö ze kako zi bo?” ");
INSERT INTO bex_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda iya te, “Baba, iꞌdi bɔ titi nima közö gɔ bo kari tize. Kina gɔ dënyï dari ꞌdɔ dako dɔmɔ bilaka ze ga di zi sëyï löbu nime. Ne ɔdɔ kinza tara ꞌbö ëdï kote dɔze kpaki ti kole titi ze ga. ");
INSERT INTO bex_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mëdï moŋgɔ gɔ kole ꞌbï Benyimona laka, mëdï miꞌdi dïdï ma gbï këdï kɔzɔ ꞌba bo tara. Ɔdɔ kiya te, mileki dë moꞌde bo kako zïyï bine iꞌdi lende mo kɔrɔ dɔma ŋbö mölë. ");
INSERT INTO bex_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Oŋgɔ te, ma kiya te dako dë ŋgï dumu dɔze bine kɔzɔ a nime te, dëne me dileki ꞌdeni mï rïyö na me.” ");
INSERT INTO bex_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Yakoba iya te, “Ele, ileŋoke rɔye kɔzɔ ame mëdï miya ziye ne. Ogbake wa ma laka ꞌba dɔyayi nime gɔ kiꞌdike mï akombi ꞌbe ga gɔ kotoke kari zi turu löbu nima rɔ kpa közï kiꞌdi. Ogbake tagi ti dɔkomali wɔwɔ ma kato kele mɔtɔ ga ti döŋgërï ma kana mɔtɔ ga kɔzɔ pisitaki ni ti alomonda. ");
INSERT INTO bex_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Arike ti yamo rɔ mbëmbë kebe dɔ ma dɔgba tönë ꞌdɔ kilekike ma tönë ga kiꞌdi kpa sorowali ꞌbe ga ne. Mɔtɔga dɔ bɔ mɔtɔ na kudölu kiꞌdi yayi kinza kikali gɔmo. ");
INSERT INTO bex_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kina arike ti löndö ye Benyimona laka zi turu löbu nima. ");
INSERT INTO bex_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mï Bɔkoꞌba tigɔ dɔ kiteli këyï rɔye bɔ nima koŋgɔ ye ŋgï rɔ bɔ lisa. Kina gɔ bo kiꞌdi Benyimona kileki kako tiye ti Simona ame kileke yayi ne. Ne oŋgɔ ꞌbama, ɔdɔ kiya te Bɔkoꞌba bo kogba kole pele di rɔma ama ndɔbɔ abo na.” ");
INSERT INTO bex_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kina kole ꞌba Yakoba ga kogba wa tönë ga ŋgï kari timo rɔ kpa közï kiꞌdi zi turu ma löbu ꞌba Ezipeto nima. Lïjë ogba yamo gbï mbiri kebe dɔ ma dɔgba tönë. Kina lïjë kënyï ti Benyimona tari Ezipeto. Ɔdɔ lïjë kömö ꞌdeni yayi tine lïjë ari ŋgï toŋgɔ bɔ löbu mo tönë ame rɔ Yesepa ne. ");
INSERT INTO bex_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kina ɔdɔ Yesepa koꞌja Benyimona ꞌdeni këdï tïnnï tine, bo iya zi bɔ laja ame këdï koŋgɔ gɔ wa ꞌba mï liŋɔ abo ne, tëgë, “Oto ya naga nime kari liŋɔ ma. Omba kole yërï ɔtɔ ga koꞌdɔ akonyo gɔ dari donyo tɔne tïnnï mï zana kada.” ");
INSERT INTO bex_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kina bɔ laja nima koꞌdɔ ŋgï kɔzɔ ma Yesepa kiya, koto ya naga nima ŋgï kari liŋɔ ꞌba Yesepa. ");
INSERT INTO bex_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kina ɔdɔ lïjë koŋgɔ bɔ laja nima këdï koto lïjë ꞌdeni kari liŋɔ ꞌba bɔ löbu tönë lïjë ŋgï rɔ tikere. Lïjë ebe tiya mo rɔ gɔ rönnï, iya te, “Ëdï koꞌde ze ꞌdeni bine gɔ lende ꞌba yamo tönë ga kileki kpa sorowali ze ga ne. Bɔ löbu nima oꞌdɔkɔ ꞌdeni ꞌdɔ kindaꞌba ze koꞌdɔ ze rɔ bɔ ndɔbɔ ꞌba mï liŋɔ abo kpaki ti akaca ze ga.” ");
INSERT INTO bex_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kina ɔdɔ lïjë kömö ꞌdeni kpa reki ꞌba liŋɔ nima lïjë iya zi bɔ laja nima, iya te, ");
INSERT INTO bex_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ŋere, tönë dako dɔgba bine tugö nyönyu ne koꞌja dëdï dileki ꞌdeni dari liŋɔ, ");
INSERT INTO bex_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","dari dömö gɔ bi ame doꞌdɔkɔ töꞌdö teyi na dope kpa sorowali ze ga doꞌja yamo ma tönë ga dugö nyönyu timo ne ꞌböwu di kpa sorowali ze ga. Yamo ma dugö nyönyu timo ne pili rɔ gɔmo, kina me dileki ꞌdeni timo. ");
INSERT INTO bex_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kina dako ꞌdeni gbï ti yamo mɔtɔ ame gɔ dugö nyönyu mɔtɔ gbï timo. Dikali dë ɔdɔ yë mo na kileki yamo ze naga nima kpa sorowali ze ga mï kada nima.” ");
INSERT INTO bex_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bɔ laja nima iya te, “Olomake ti mï këyï, kinza kereke dë. Bɔkoꞌba ma këdï koŋgɔ gɔye ti ꞌbu ye na ma kileki yamo ꞌbe ga pili kpa sorowali ne. Yamo ma tönë ga kugöke nyönyu timo ne mogba ꞌdeni mɔlo mï kada mo nima.” Kina bo kari ŋgï koꞌde Simona kako zïnnï. ");
INSERT INTO bex_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Bɔ laja tönë ogba löndö ꞌba Yesepa naga nima koja rö ꞌba Yesepa, bo koꞌde mini zïnnï turögö ndïnnï timo gɔ dölëtï ꞌbënnï, bo kiꞌdi akonyo gbï zi akaca ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Lïjë oloma yayi ŋbö kömö mï zana kada tileŋo rönnï ti kpa közï ꞌbënnï ga römöyï lïjë uwö ꞌdeni tëgë bɔ löbu nima ëdï kako tonyo akonyo bi kɔtɔ tïnnï. ");
INSERT INTO bex_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kina ɔdɔ Yesepa kileki ꞌdeni kako liŋɔ tine, lïjë ënyï ŋgï ti kpa közï kiꞌdi ꞌbënnï ga kɔdɔ timo gɔ bo rö ma bo këdï yïmo kari kiꞌdi zi bo. Kina lïjë kolɔdɔ ŋgï bërï kɔmɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Bo iya te, “Ëddïke tondo? Kina ꞌbu ye ma tönë ꞌdeni rɔ bulöbu köndë kiyake lende mo zö bine ne, bo ëdï tondo? Bo ëdï gba ti kɔmɔ bo?” ");
INSERT INTO bex_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Lïjë iya te, “Yëë ŋere, ꞌbu ze ëdï laka gba ti kɔmɔ bo.” Kina lïjë kolɔdɔ ꞌböwu bërï kɔmɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yesepa ileki koŋgɔ dönnï, kina ɔdɔ bo koꞌja bɔ löndö bo Benyimona ame rɔ kole ꞌba ma bo ko ne tine, bo iya te, “Bɔ nime na rɔ bɔ löndö ye ma titi mo tönë kiyake lende mo zö bine ne?” Kina bo kiya te zi Benyimona, “Kole ma, Bɔkoꞌba koloma tïyï laka.” ");
INSERT INTO bex_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kina bo kënyï ŋgï welo kɔdɔ kari yaga. Dökïꞌdï bo ata ꞌdeni rɔ ma kënyë gɔ lende nima bo koꞌja kïnë bɔ löndö bo ne. Bo iꞌdi toma gɔ bi ame gɔ bo kari kudu di teyi, kina bo kɔdɔ ŋgï rö ꞌba töꞌdö abo kari tudu yayi. ");
INSERT INTO bex_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bo urögö kɔmɔ bo kogbɔ dökïꞌdï bo, kina bo kɔdɔ kako yaga. Bo iya zi bɔ laja abo, iya te, “Oꞌde akonyo kako zize.” ");
INSERT INTO bex_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Bo oloma dɔ gɔ bi loma ma ꞌba bo kiꞌdi löndö bo ga koloma dɔ tarabiza mɔtɔ kuyï kömönnï kari dɔ bo. Tine Ezipeto ame ga këdï konyo akonyo gbï tïnnï yayi ne oloma ꞌbënnï gbï ꞌberi. Dölëtï ꞌbënnï ꞌba Ezipeto na tara. Lïjë oloma dë tonyo kpënnï bi kɔtɔ ti Ebere, ëdï rɔ lende ma koro zïnnï. ");
INSERT INTO bex_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kina Yesepa kiyija löndö bo ga ŋgï koloma bërï. Dɔgba bo iꞌdi kole ma löbu mo kina bo kiꞌdi bɔ ma köyö gɔmo ŋbö kari kömö zi kole ma rɔ tundu mo. Kina ɔdɔ lïjë koŋgɔ Yesepa këdï kiyija lïjë ꞌdeni ŋgï koko tine lende mo igayi lïjë ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Bɔ laja naga nima ombi akonyo di dɔ tarabiza ma ꞌba Yesepa koꞌde kako zi löndö bo ga. Tine akonyo ma kiꞌdi zi Benyimona ebe ꞌba ya ama ga ŋbö mï muyï. Kina lïjë koloma ŋgï yayi tonyo akonyo, tuwë layi ŋgï rɔ lɔŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yesepa iꞌdi lende mo zi bɔ laja abo ma löbu mo, iya te, “Ari kunzö nyönyu mï sorowali ꞌba ya naga nime, unzö koso yïmo kɔzɔ wa ame lïjë koꞌdɔkɔ tombi mo ne tara. Ileki yamo ma lïjë kugö nyönyu timo naga nima kiꞌdi kpa sorowali ꞌbënnï ga me rɔ kɔtɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kina ogba kösu sïtërï kiꞌdi mï sorowali ꞌba bɔ ma titi nima ti yamo abo ame bo kugö nyönyu timo ne.” Kina bɔ laja tönë koꞌdɔ ŋgï kɔzɔ a nima tara. ");
INSERT INTO bex_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kina ɔdɔ bi këzë ꞌdeni tine löndö ꞌba Yesepa naga nima ösö ŋgï kɔri tari ti akaca ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kina ɔdɔ lïjë kari ꞌdeni gba mbowa yɔ na Yesepa kënyï kiya te zi bɔ laja abo, “Ënyï kozi gɔ ya naga nime ꞌdë, ari kiya zïnnï, iya te, ‘Ŋere ma oꞌdɔ lende laka ziye, waꞌdi na koꞌdɔke lende kënyë zi bo gɔmo? ");
INSERT INTO bex_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Waꞌdi na kuꞌbögöke kösu abo nima kileŋo di mï sïtërï ne gɔmo? Kösu nima na ŋere ma këdï kuwë wa timo, kina gbï rɔ ꞌbɔsi abo. Lende koꞌdɔ ꞌbe nima ele dë.’ ” ");
INSERT INTO bex_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Bɔ laja nima ozi gönnï kari kota gönnï kiya lende tönë ga Yesepa kose ne ŋgï pili zïnnï. ");
INSERT INTO bex_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Lïjë iya te, “Ŋere, waꞌdi na kiya lende tara gɔmo? Dulömu rɔze, a ma tara doꞌdɔ dë du te. ");
INSERT INTO bex_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ikali dë me tönë dari doꞌja yamo di kpa sorowali ze ga ne dako timo di dɔyayi ꞌba Kanana dileki zïyï bine? Ne gɔ waꞌdi na kari kiya te duꞌbögö wa ma kileŋo di mï sïtërï ma kele gɔmo di mï liŋɔ ꞌba ŋere ꞌbï? ");
INSERT INTO bex_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ɔdɔ kiya te koꞌja di zi bɔ mɔtɔ di mï löŋgö ze bine, bɔ mo ti kölë kpamo. Kina ze mɔtɔ mo ga ti döꞌbö bine rɔ bɔ ndɔbɔ zïyï.” ");
INSERT INTO bex_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Bɔ laja nima iya te, “Ti këdï ŋgï tara. Tine bɔ ame moꞌja kösu nima di zi bo ne, bo na ŋge ti kileki rɔ bɔ ndɔbɔ zö bine, kpe ya mɔtɔ mo naga nima ti karike eꞌbe, römöyï oꞌdɔke ꞌbeye wa ma kënyë mɔtɔ dë.” ");
INSERT INTO bex_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kina lïjë kënyï ŋgï welo kutë sorowali ꞌbënnï ga pili bërï kope kpamo ga yaga. ");
INSERT INTO bex_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kina bɔ laja nima kiꞌdi ŋgï toma yïmo. Bo isaki dɔgba di dɔ sorowali ꞌba bɔ ma löbu mo kari timo ŋbö kömö dɔ ꞌba bɔ ma titi mo, kina kari koꞌja kösu nima ŋgï di mï sorowali ma ꞌba Benyimona. ");
INSERT INTO bex_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kina ɔdɔ lïjë koŋgɔ ꞌdeni tara tine, lïjë ŋgï rɔ meri, kirica bɔŋgɔ yaga di rönnï gɔ lende ꞌba gomɔ mbëmbë nime këdï koꞌdɔ rönï zïnnï ne. Kina lïjë kudödu sorowali ꞌbënnï ga ŋgï gɔ akaca, lïjë kuyï dönnï kileki mï gawo. ");
INSERT INTO bex_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kina ɔdɔ Yuda ni ti bɔ löndö bo ga kuyï dönnï ꞌdeni kako mï gawo, lïjë ileki ꞌböwu kari liŋɔ ꞌba Yesepa. Lïjë ari koꞌja Yesepa këdï gba liŋɔ. Kina lïjë kari kolɔdɔ ŋgï bërï kɔmɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Bo iya te, “Waꞌdi ga na me koꞌdɔke bine te ne? Ma nime, ma bɔ kumë lende kɔzɔ ꞌbɔsi na, ikalike dë?” ");
INSERT INTO bex_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda iya te, “Ŋere, tine gɔ diya tondo? Dikali dë kpe tiya a mɔtɔ. Dikali dë kpe ma ꞌdɔ dileme laka ze zïyï. Lende kënyë nime ze na dë doꞌdɔ, Bɔkoꞌba na këdï kodɔ karama dɔze gɔ lende ꞌba wa ma kënyë ame ga doꞌdɔ ꞌdeni mɔlo ne. Kina me ꞌdeni doꞌdɔkɔ ŋgï gɔ dileke pili zïyï bine rɔ bɔ ndɔbɔ ꞌbï ga tine dë ŋge kɔtɔ rɔ bɔ ame koꞌja kösu nima di teyi ne.” ");
INSERT INTO bex_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yesepa iya te, “Inza tara, minza moꞌdɔ tara. Bɔ nima koꞌja kösu di zi bo ne bo na këdï kileke ŋge bine. Kpe ya mɔtɔ naga nima inzake ti lende ɔtɔ, ileki karike zi ꞌbu ye.” ");
INSERT INTO bex_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kina Yuda kese ŋgï ŋɔli dɔ ŋgila bo, kiya te, “Ŋere, iꞌdi milende tɔ kpe mbowa tïyï ꞌdi. Kinza kënyï dë rɔ ꞌdïrï tö. Moŋgɔ ꞌdeni ŋgï nï na rɔ ŋere ma löbu mbiri kɔzɔ bɔ dɔliŋɔ ꞌba Ezipeto nime. ");
INSERT INTO bex_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Lende ma na kɔzɔ a nime te. Mï kada tönë dɔgba bine ne gɔ koloma tititi ze kiya te, ɔdɔ ꞌbu ze ëdï kina dëdï ti löndö mɔtɔ, ");
INSERT INTO bex_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","diya te ꞌbu ze ëdï kina dëdï gbï ti löndö ze ame rɔ tundu mo ne ame ꞌbu ze köyö koꞌja rɔ bo kandi ꞌdeni. Löndö ꞌba kole nime ölë ꞌdeni, bo na ŋge ma kola kɔtɔ zi ma bo. Kina ꞌbu ze kɔꞌɔ bo ŋgï rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kina me tönë kiya te gɔ doꞌde kole nima kako zïyï gɔ koŋgɔ bo. ");
INSERT INTO bex_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Dileki zïyï diya te, ‘Bo inza kënyï di dɔ ŋgila ꞌbu ze. Ɔdɔ bo kënyï di dɔ ŋgila ꞌbu ze, ꞌbu ze inza kɔmɔ.’ ");
INSERT INTO bex_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ne iya zize mï kada nima yayi, iya te ɔdɔ kiya te bɔ titi nime kako dë tize a mɔtɔ oꞌdɔkɔ dë gɔ koꞌja kïnë ze dɔrɔ kpe kömöyï. ");
INSERT INTO bex_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kina dileki dari dïyëtï gɔ lende kiya ꞌbï tönë ga ŋgï pili zi ꞌbu ze. ");
INSERT INTO bex_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kina me ꞌböwu ꞌbu ze kiya te gɔ dako tugö nyönyu di Ezipeto bine. ");
INSERT INTO bex_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Diya te zi bo ɔdɔ kole titi nime kari dë tize a mɔtɔ dinza dari. Inza koꞌdɔkɔ gɔ dɔrɔ kɔmɔ turu löbu ꞌba dɔliŋɔ nima ɔdɔ kiya te kole nime kari dë tize. ");
INSERT INTO bex_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ꞌBu ze iya te, ‘Kɔzɔ ikali ꞌja ma ama öyö kole ŋge rïyö zö. ");
INSERT INTO bex_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kina me mɔtɔ kari ëꞌbënï ꞌdeni mɔlo bitɔ tɔ ne ga moꞌja kɔmɔ mo dë gbï yɔ mɔlo nime. Mɔtɔga kuruku ꞌba yï mökö ti konyo ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kina me koꞌdɔkɔke ꞌdeni gbï togba ma titi nime yaga di zö. Ɔdɔ a mɔtɔ kömö dɔmo di yayi lisa ma löbu na koꞌdeke ꞌdeni zö. Möndë ama ꞌdeni meri abo na ŋgï këdï kosɔsɔ ma.’ Lende ma ꞌbu ze kiya zize na kɔzɔ a nime te. ");
INSERT INTO bex_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Kina me ɔdɔ kiya te dari dileki ra rɔ ma sari kinza kole nime, kina ɔdɔ ꞌbu ze koꞌja bo kinza tize bo ëdï kölë ŋgï. Ëdï ꞌdeni ŋgï kɔzɔ iya te dïdï abo ti ꞌba kole nime ꞌdeni ŋgï rɔ akɔtɔ. Ɔdɔ bo koꞌja kole nime kinza tize yɔ na bo këdï kölë ŋgï. Lisa nime doꞌde ꞌdeni dɔ bo ne na këdï kupö bo ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ŋere, ma na mëdï moŋgɔ gɔ kole nime, miya ꞌdeni mɔlo zi ꞌbu ma, miya te, ‘Ɔdɔ mileki dë ti bo, lende mo ti kɔrɔ dɔma ŋbö mölë.’ ");
INSERT INTO bex_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kina me momaꞌjo rɔma zïyï iꞌdi ma na mileke bine toꞌdɔ ndɔbɔ zïyï pötö bɔ nime. Iꞌdi kole nime kileki kari liŋɔ ti löndö bo ga. ");
INSERT INTO bex_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ne ma ꞌbama gɔ mileki tondo mari zi ꞌbu ze rɔ ma sari kinza kole nime? Rɔma aga ꞌdeni di bi tari toŋgɔ lisa ꞌba ꞌbu ze.” ");
INSERT INTO bex_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Kina ɔdɔ Yesepa kuwö lende kiya ꞌba Yuda nime ꞌdeni te tine, bo ikali dë kpe togbɔ dökïꞌdï bo di kɔmɔ bɔ laja abo ga. Kina bo kapi ŋgï rɔ ma kembe dönnï, tëgë, “Ɔdɔke yaga di gɔze bine.” Bilaka naga nima ɔdɔ ŋgï pili yaga kola Yesepa ni ŋge yayi ti bɔ löndö bo ga. Kina bo kebe ŋgï tileme rɔ bo zïnnï, bo iya te, “Ma löndö ye na.” ");
INSERT INTO bex_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Kina bo kiꞌdi ŋgï tudu rɔ ma kembe na Ezipeto naga nima kuwö monɔ ꞌba dɔ bo ŋgï ŋbö di yaga. Gɔ köꞌdu mo na lende mo kari ŋgï ŋbö kömö liŋɔ ꞌba bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yesepa iya zi löndö bo naga nima, iya te, “Ma Yesepa na. ꞌBu ze ëdï gba ti kömönï?” Tine lïjë ikali dë kpe tileki dɔ lende abo, rönnï ëdï ꞌdeni ŋgï kïlëꞌdï gɔ köꞌdu ame lende mo kigayi lïjë ꞌdeni ne. ");
INSERT INTO bex_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kina ɔdɔ Yesepa koŋgɔ rönnï këdï kïlëꞌdï ꞌdeni kulöwö tara tine bo iya zïnnï gɔ lïjë kiyese ŋgɔsi dɔ ŋgila bo. Bo iya te, “Ma Yesepa na, ma löndö ye ma tönë kugöke mɔlo zi bɔ ndögö ne na. Kina me koꞌde ma kako mï dɔyayi ꞌba Ezipeto bine. ");
INSERT INTO bex_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ne kinza kereke dë komerike kaga rɔye, kina kinza kiꞌdike dökïꞌdï ye dë kata rɔye gɔ lende kënyë tönë koꞌdɔke zö mï kada nima yayi ne. Bɔkoꞌba na koja ma kako dɔgba kɔmɔye bine ꞌdɔ tokɔnyi ye kɔzɔ a nime te kinza ꞌbö kupö ye ra. ");
INSERT INTO bex_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kɔmɔ kɔɔ mo ꞌdeni rïyö ame ꞌbö kilaꞌba ꞌdeni mï dɔyayi nime. Kina ola kɔsɔ mo ga ꞌdeni gba muyï ame bilaka inza kikali gbï torɔꞌdɔ nyaka ala tumu nyönyu. ");
INSERT INTO bex_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Rɔ ma laka Bɔkoꞌba na me koꞌdɔ lende löbu abo nime, bo koja ma kako dɔgba kɔmɔye bine gɔ kiꞌdi ye ti bilaka pili ꞌbe ga kɔmɔke di zi gomɔ nime ꞌdɔ kiꞌdi kupö ye kara gba nduwë. ");
INSERT INTO bex_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kpe na dë me kojake ma bine, tine Bɔkoꞌba na koja ma. Bo oꞌdɔ ma rɔ löbu mï liŋɔ ꞌba bɔ dɔliŋɔ, kina me bo koꞌdɔ ma ꞌdeni rɔ turu löbu mbiri dɔ dɔyayi ꞌba Ezipeto nime.” ");
INSERT INTO bex_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Bo ileki gbï kiya zïnnï, bo iya te, “Kina ënyïke ti, kilekike welo karike zi ꞌbu ze. Ari kiyake zi bo, iyake te ma kole abo Yesepa na. Kina me leꞌjete mëdï mose kpama kari zi bo, miya te, ‘Bɔkoꞌba oꞌdɔ ma ꞌdeni rɔ löbu ꞌba dɔ dɔyayi ꞌba Ezipeto. Ako welo gɔ koloma tö bine. ");
INSERT INTO bex_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ako ti kole ꞌbï ga pili ti kole ꞌba kole ꞌbï ga, ti yërï ꞌba mï liŋɔ ꞌbï ga pili ti wa ame ga këddï timo ne. Gɔ bi ëdï zïyï bine toloma teyi kapa Gosene. Bi nime na ŋgɔsi ŋgila liŋɔ ma gɔ kako kolomake teyi. ");
INSERT INTO bex_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ti möꞌbö nduwë tiꞌdi wa ame ga këddï rɔ leri mo ne zïyï di yayi, römöyï sëyï nime ëdï gba koꞌdɔ kɔmɔ kɔɔ muyï. Dëne mɔtɔga ꞌbö löbu nime ti kote dɔye pili ti bilaka ꞌbï ga, kpaki ti yërï ꞌba mï liŋɔ ꞌbï ga.’ Ndose ma nime ari kiyake tara zi ꞌbu ze. ");
INSERT INTO bex_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Rɔ ma laka ikalike ma ꞌdeni pili, kina nï bɔ löndö ma Benyimona ikali ꞌdeni ma Yesepa bɔ löndö yï na. ");
INSERT INTO bex_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ari kiyake zi ꞌbu ze, iyake te mëdï ꞌdeni ti közï kakpa mbiri dɔ Ezipeto. A mɔtɔ ga ame pili koꞌjake bine ne iyake lende mo gbï zi bo. Ari koꞌdeke bo kako welo bine.” ");
INSERT INTO bex_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tine na Yesepa kiramo Benyimona ŋgï bo kudu rɔ ma kënyë. Kina Benyimona kiramo bo gbï kebe tudu. ");
INSERT INTO bex_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kina Yesepa kebe ŋgï tiramo löndö bo ama ga pili rɔ kɔtɔkɔtɔ nduwë ti monɔ. Kina lïjë kiꞌdi ŋgï tilende ti bo. ");
INSERT INTO bex_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Lende nima ari kömö zi bɔ dɔliŋɔ tëgë löndö ꞌba Yesepa ga ako ꞌdeni, kina bɔ dɔliŋɔ ni ŋgï pili ti mï këyï ti bɔ laja abo ga. ");
INSERT INTO bex_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Bo iya zi Yesepa, iya te, “Iya zi löndö yï naga nima gɔ lïjë kudödu akombi ꞌbënnï ga gɔ akaca lïjë kileki kari liŋɔ ꞌbënnï mï dɔyayi ꞌba Kanana. ");
INSERT INTO bex_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kina gɔ lïjë kari koꞌde ꞌbu nnï ti bilaka ꞌbënnï mɔtɔ ga pili kileki timo bine. Ti miꞌdi kapa yayi ꞌba Ezipeto ma laka rɔ dɔ kiteli zïnnï gɔ lïjë koloma teyi. Kina ti miꞌdi akonyo ma laka gbï zïnnï rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Mï dɔyayi nime bine dëdï ti aribiya ame ga sa na këdï kotɔ ne, kina ꞌdɔ lïjë kogba kari timo gɔ ꞌja ti kole titi ꞌbënnï ga pili këkï yïmo kako bine, kina ꞌdɔ ꞌbu yï kako gbï bine kɔzɔ a nima tara. ");
INSERT INTO bex_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Iya zïnnï kinza lïjë kiꞌdi mïnnï kombi dë gɔ lende ꞌba wa ꞌbënnï ga. Ɔdɔ kiya te lïjë kömö Ezipeto bine wa ma laka ꞌba dɔyayi nime lïjë ti këdï pili timo.” ");
INSERT INTO bex_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kole ꞌba Yakoba ga oꞌdɔ pili kɔzɔ lende kiya ꞌba bɔ dɔliŋɔ nima tara. Yesepa iꞌdi aribiya nima zïnnï kɔzɔ lende kiya ꞌba bɔ dɔliŋɔ tara. Kina bo kiꞌdi akonyo gbï zïnnï gɔ lïjë konyo di gɔ kɔri. ");
INSERT INTO bex_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Bo iꞌdi bɔŋgɔ ma kele me zïnnï. Tine ꞌba Benyimona bo iꞌdi yamo kuluku modɔɔkɔtɔ ti bɔŋgɔ ma kele muyï. ");
INSERT INTO bex_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kina bo kako gbï ti wa naga nime koꞌde zi ꞌbu bo, ame akaca ꞌbutë na kombi wa ma kele ꞌba mï dɔyayi ꞌba Ezipeto, kina akaca gbï ꞌbutë ame ga kombi nyönyu zi bo ti a mɔtɔ ga ame gɔ bo konyo di gɔ kɔri ne. ");
INSERT INTO bex_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Bo oja lïjë gɔ kɔri, bo iya te, “Kinza kamoke dë rɔ gɔ rɔye di gɔ kɔri.” ");
INSERT INTO bex_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Bɔ löndö ꞌba Yesepa naga nima ënyï di Ezipeto yayi kileki kari Kanana. Lïjë ari kömö liŋɔ zi ꞌbu nnï ");
INSERT INTO bex_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","na lïjë kiya te, “Yesepa ëdï gba ti kömönï, bo na ꞌdeni rɔ turu löbu mbiri dɔ Ezipeto.” Kina ɔdɔ Yakoba kuwö lende nime te tine bo otɔ ŋgï rɔ gɔ bo. Bo iꞌdi dɔ bo dë gɔ lende kiya ꞌbënnï nima. ");
INSERT INTO bex_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Lïjë ïyëtï gɔ lende ame ga pili Yesepa kose ne zi bo. Tine ŋbö bo kari koꞌja aribiya ame ga Yesepa koja gɔ bo tari timo Ezipeto ne, tine na ꞌjaa dökïꞌdï bo këyï. ");
INSERT INTO bex_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Bo iya te, “Ee, kina ꞌdeni, rɔ ma laka kole ma Yesepa ëdï gba ŋgï ti kömönï. Mëdï mari toŋgɔ bo du titi ti kɔmɔ ma gba kinza mölë dë.” ");
INSERT INTO bex_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakoba otɔtɔ abo ga pili kënyï ŋgï di yayi kari ŋbö kömö Berasaba. Kina ɔdɔ bo kömö ꞌdeni Berasaba tine na bo kumu roma ŋgï zi Bɔkoꞌba ꞌba ꞌbu bo Yisika. ");
INSERT INTO bex_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kina Bɔkoꞌba kileme rönï ŋgï zi Yakoba rɔ mï korɔndɔ kïdëkï bo, kiya te, “Yakoba, Yakoba.” Yakoba utï, iya te, “Ma na me bine.” ");
INSERT INTO bex_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Bɔkoꞌba iya te, “Ma Bɔkoꞌba na, ma na moloma toŋgɔ gɔ ꞌbu yï Yisika bine. Kinza kere dë di bi tari Ezipeto. Gɔ bi nima na mëdï mari miꞌdi kupö yï kara di teyi rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kina ti moloma gbï tïyï yayi gɔ mileki kupö yï ga ꞌjaa kako mï yayi nime bine. Tine nï ꞌbëyï ɔdɔ kölë kada mɔtɔ Yesepa na ti kokoko yi.” ");
INSERT INTO bex_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kina Yakoba kënyï ŋgï di Berasaba yayi. Kole abo ga iꞌdi bo mï aribiya ma tönë bɔ dɔliŋɔ ꞌba Ezipeto koja ne. Lïjë iꞌdi ꞌja ꞌbënnï ga kpaki ti kole titi mï aribiya naga nima gɔ kiliŋgere timo. ");
INSERT INTO bex_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kina lïjë kënyï ŋgï pili ti yërï ꞌba mï liŋɔ ꞌbënnï ga ti wa ame ga pili lïjë koꞌja di Kanana ne, lïjë kari Ezipeto. Yakoba ari pili ti bilaka abo ga, ");
INSERT INTO bex_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","kole abo ga ti kole ꞌba kole abo ga ti yïtötï abo ga pili ti yïtötï ꞌba kole abo ga. Lïjë pili ösö gɔ bo kari Ezipeto. ");
INSERT INTO bex_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakoba nime na kïdëkï möyï mo mɔtɔ gbï rɔ Yisarele. Möyï bilaka abo ga ame kari ti bo Ezipeto ne kina me ga. Rubënï ame rɔ kole ꞌba Yakoba ma dɔndende mo ne, ");
INSERT INTO bex_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ti kole abo ga Anoko ni ti Palo ti Ezerona ti Karomi. ");
INSERT INTO bex_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simona ti kole abo ga Yemowele ni ti Yamina ti Oda ti Yakina ti Zowara kina gbï ti Sawola ame yïtö ꞌba dɔyayi ꞌba Kanana na köyö ne. ");
INSERT INTO bex_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lëwë ti kole abo ga Gerosona ni ti Kowata ti Merari. ");
INSERT INTO bex_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda ti kole abo ga Sela ni ti Pereze ti Zera. Kole abo mɔtɔ mo ga Ere ni ti Onana ölë ꞌdeni mɔlo di dɔyayi ꞌba Kanana yayi. Kina Pereze kari köyö kole rïyö rɔ Ezerona ni ti Amola. ");
INSERT INTO bex_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yisakara ti kole abo ga Tola ni ti Puwa ti Yabo ti Simerona. ");
INSERT INTO bex_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebolona ti kole abo ga Serede ni ti Elone ti Yalele. ");
INSERT INTO bex_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Kole ꞌba Yakoba naga nime ma bo köyö ti Leya koꞌja bo këdï koloma Padanarama na. Bo öyö nyiti gbï ti Leya möyï mo rɔ Dina. Kina kupö bilaka lesi ame ga pili kɔdɔ di zi Leya ne ëdï ꞌbutë mota dɔɔmota. ");
INSERT INTO bex_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kole ꞌba Yakoba mɔtɔ ga ame kari ti bo Ezipeto ne kina me ga. Gada ti kole abo ga Zipeyona ni ti Agi ti Sunï ti Eziboni ti Eri ti Arodi ti Areli. ");
INSERT INTO bex_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asera ti kole abo ga Yimena ni ti Yisewa ti Yisewi ti Beriya ti nyiti abo Sera ti kole ꞌba Beriya ga ame ga rɔ Eberi ni ti Malekele. ");
INSERT INTO bex_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Kole ꞌba Yakoba naga nime ma bo köyö ti Zilepa ame Labana kiꞌdi gɔ kari koja laja zi nyiti abo Leya na. Kina kupö bilaka lesi ame ga pili kɔdɔ di zi Zilepa ne ëdï ꞌbutë döömu dɔɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakoba öyö kole gbï rïyö ti ꞌja abo ame rɔ Rayile ne, möyï mo ga na rɔ Yesepa ni ma ti Benyimona. ");
INSERT INTO bex_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Tine Yesepa öyö kole ꞌdeni rïyö di Ezipeto rɔ Manase ni ti Eporima. Bo öyö lïjë ti ꞌja abo Asenata nyiti ꞌba Potipera bɔ kata ame këdï koloma mï dɔyayi ꞌba Ɔno ne. ");
INSERT INTO bex_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyimona öyö kole gbï rɔ Bela ni ti Bekere ti Asebele ti Gera ti Namana ti Eyi ti Rose ti Mupïma ti Wupïma ti Arada. ");
INSERT INTO bex_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Kina kupö bilaka lesi ame ga pili kɔdɔ di zi Rayile ne ëdï ꞌbutë dɔmosowɔ. ");
INSERT INTO bex_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Kole ꞌba Yakoba mɔtɔ ga ame kari ti bo Ezipeto ne kina me ga. Dana ti kole abo Wusïma. ");
INSERT INTO bex_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napatali ti kole abo ga Jazele ni ti Gunï ti Jereze ti Silema. ");
INSERT INTO bex_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Kole ꞌba Yakoba naga nime ma bo köyö ti Bila ame Labana kiꞌdi gɔ kari toja laja zi nyiti abo Rayile na. Kina kupö bilaka lesi ame ga pili kɔdɔ di zi Bila ne ëdï modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Kupö Yakoba ga ame kari ti bo Ezipeto ne ëdï pili bi kɔtɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë döömu dɔɔkɔtɔ (66) rɔ dönnï kinza ꞌja ꞌba kole abo ga teyi. ");
INSERT INTO bex_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tine Yesepa öyö kole ꞌdeni rïyö di Ezipeto yayi kina kiꞌdi bilaka ꞌba Yakoba ga ame ga kari Ezipeto ne kodɔꞌbɔ rönnï pili bi kɔtɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö (70). ");
INSERT INTO bex_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakoba oja Yuda kari dɔgba kiya zi Yesepa gɔ kurë dönnï Gosene. Kina ɔdɔ lïjë kömö ꞌdeni Gosene tine ");
INSERT INTO bex_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yesepa ënyï ŋgï kileŋo aribiya abo ma tönë kosani na këdï kotɔ ne bo kari tileme rɔ bo zi ꞌbu bo di Gosene yayi. Toꞌja ma bo koꞌja ꞌbu bo na bo kiramo ŋgï bo kudu rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakoba iya zi bo, iya te, “Moꞌja kömöyï ꞌdeni kina mikali ꞌdeni ŋgï rɔ ma laka ëddï gba ti kömöyï. Ne ɔdɔ tölë kömö pele dɔma yïmö ëyï ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kina Yesepa kebe ŋgï tilende zi löndö bo ga ti bilaka pili mɔtɔ ga ꞌba ꞌbu bo. Bo iya te, “Mëdï mari miya zi bɔ dɔliŋɔ ꞌba Ezipeto, miya te, ‘Löndö ma ga ako ꞌdeni zö ti bilaka pili ꞌba ꞌbu ma ga ame këdï mɔlo mï dɔyayi ꞌba Kanana ne.’ ");
INSERT INTO bex_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mëdï mari miya zi bo, miya te, kpe bɔ koda kamölö ni ti sa na kina me kakoke ꞌdeni ti sa ꞌbe ga pili ti kamölö mo ga pili ti wa ꞌbe ga. ");
INSERT INTO bex_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kina ɔdɔ kiya te bɔ dɔliŋɔ kïdëkï ye bo ëdï kari kititi ye, kiya te, ɔdɔ ndɔbɔ ꞌbe ga rɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Kina gɔ kiyake zi bo, iyake te, ndɔbɔ ꞌbe mɔlo këddïke gba rɔ ma titi ŋbö kömö mï kada nime tɔne na rɔ toda kamölö ni ma ti sa. Kina ꞌbu ye löbu ga oꞌdɔ ndɔbɔ nima gbï tara bine. Ari kiyake zi bo tara kina bo ti kiꞌdi ye ŋgï kolomake mï yayi ꞌba Gosene nime.” Yesepa iya tara römöyï Ezipeto lende ꞌbënnï lïjë oꞌdɔkɔ dë toloma bi kɔtɔ ti bɔ koda yërï. ");
INSERT INTO bex_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Kina Yesepa kigeli löndö bo ga ma muyï kari timo zi bɔ dɔliŋɔ. Bo iya zi bɔ dɔliŋɔ, iya te, “ꞌBu ma ni ti löndö ma ga ënyï ꞌdeni di Kanana kako bine. Lïjë ako ꞌdeni ti yërï ꞌbënnï ga kpaki ti wa ꞌbënnï ga kina me lïjë kömö ꞌdeni Gosene.” Kina bo kileme löndö bo ga ma muyï nima zi bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Bɔ dɔliŋɔ ititi lïjë, iya te, “Ndɔbɔ ꞌbe rɔ waꞌdi?” Lïjë iya te, “Ŋere, ze rɔ bɔ koda yërï, kina ꞌbu ze löbu ga ma mɔlo gbï tara. ");
INSERT INTO bex_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Dako ꞌdeni gɔ doloma titi mbowa bine römöyï sëyï ilaꞌba ꞌdeni rɔ ma kënyë mï dɔyayi ꞌba Kanana, mɔli inza kpe yayi zi kamölö ze ga gɔ konyo. Kina me dëne gɔ kiꞌdi ze doloma Gosene bine.” ");
INSERT INTO bex_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Bɔ dɔliŋɔ iya zi Yesepa, iya te, “ꞌBu yï ni ti löndö yï ga na me kako ꞌdeni zïyï bine, ");
INSERT INTO bex_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","moꞌdɔkɔ gɔ lïjë koloma mï gɔ bi ame lïjë koꞌdɔkɔ toloma teyi di mï dɔyayi ꞌba Ezipeto nime ne. Ne oŋgɔ, yayi ma laka di mï dɔyayi ꞌba Ezipeto nime na rɔ Gosene, zïnnï ꞌdɔ toloma yayi. Kina ɔdɔ bɔ mɔtɔ këdï mï löŋgö lïjë ame kikali ndɔbɔ ꞌba toŋgɔ gɔ yërï rɔ ma laka iꞌdi bo koŋgɔ gɔ yërï ꞌba ma naga nime gbï.” ");
INSERT INTO bex_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yesepa oꞌde ꞌbu bo Yakoba gbï kako kileme zi bɔ dɔliŋɔ. Kina Yakoba koꞌdɔ yëyï zi bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Bɔ dɔliŋɔ ititi bo, iya te, “Kɔmɔ kɔɔ ꞌbï ëdï ꞌdeni ndö?” ");
INSERT INTO bex_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakoba iya te, “Kɔmɔ kɔɔ ma onzi dë gba laka, ëdï ꞌdeni ŋge kuluku rïyö kɔdɔ dɔmo ꞌbutë mota (130). Ne gomɔ na moꞌja ꞌdeni ŋgï rɔ ma kënyë. Kɔmɔ kɔɔ ma ame moloma dɔyayi bine ne onzi dë kɔzɔ ꞌba ꞌbu ma löbu ni tara.” ");
INSERT INTO bex_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kina Yakoba koꞌdɔ yëyï ŋgï gbï ꞌböwu zi bɔ dɔliŋɔ kina bo kɔdɔ ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yesepa iꞌdi ꞌbu bo ni ti löndö bo ga koloma Ezipeto yayi mï gɔ bi mɔtɔ ŋgɔsi ŋgila gawo ꞌba Ramese. Bo iꞌdi nyaka zïnnï di yayi gɔ koloma ŋburu rɔ ëꞌbënnï kɔzɔ lende ame bɔ dɔliŋɔ kiya ne tara. Gɔ bi nima na yayi mo kele ŋgï rɔ dɔ kiteli pili kebe dɔyayi mɔtɔ ga ꞌba Ezipeto nima. ");
INSERT INTO bex_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Bo iꞌdi akonyo gbï zi ꞌbu bo ni ti löndö bo ga pili ti bilaka mɔtɔ ga ame ꞌba ꞌbu bo ne rɔ mbëmbë kɔzɔ wa ame ga lïjë koꞌdɔkɔ ne tara. ");
INSERT INTO bex_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Sëyï nima ꞌdeni ŋgï rɔ mbëmbë a mɔtɔ rɔ akonyo inza kpe mï dɔyayi pili. Kina bilaka ma Kanana ti ma mï Ezipeto ꞌbö ɔdɔ ꞌdeni ŋgï rɔmo rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kina lïjë koloma ŋgï nduwë tugö nyönyu di zi Yesepa rɔ mbëmbë, bo kotɔtɔ yamo ꞌbënnï ga ŋgï pili kikeki liŋɔ ꞌba bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tine na kari kömö mï kada ame ga yamo kote rönï ꞌdeni di zi bilaka pili, a mɔtɔ rɔ yamo inza kpe mï dɔyayi ꞌba Ezipeto pili ti ꞌba Kanana. Kina Ezipeto kotɔtɔ rönnï kako zi Yesepa tokpasi bo, iya te, “Yamo ze ga ote rönï ꞌdeni pili, iꞌdi akonyo zize kinza kola ze dë dölë.” ");
INSERT INTO bex_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Bo iya te, “Ɔdɔ yamo ꞌbe ga kote rönï ꞌdeni oꞌdeke yërï ꞌba liŋɔ ꞌbe ga gɔ kugöke akonyo timo ziye.” ");
INSERT INTO bex_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Mï kɔmɔ kɔɔ nima na bilaka koꞌde kosani ꞌbënnï ga ti kamölö ni ti banya ti sa ti akaca zi Yesepa kutë di zïnnï ti akonyo. ");
INSERT INTO bex_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kina ɔdɔ kari kömö ꞌdeni mï kɔmɔ kɔɔ mɔtɔ ꞌböwu tine na bilaka tönë ga kako gbï zi Yesepa. Lïjë iya te, “Ŋere, oŋgɔ leꞌjete kɔzɔ ikali yamo ze ga ote rönnï ꞌdeni me. Kina me yërï ze ga diꞌdi ꞌdeni kpaki zïyï. Dinza kpe ti a mɔtɔ, ame kileke zize bine gɔ dugö akonyo timo di zïyï ola ꞌdeni ŋge kɔtɔ rɔ yida rɔze ni ti nyaka ame ga dëdï timo ne. ");
INSERT INTO bex_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kinza kola ze dë dölë, ɔdɔ kiya te ꞌbö kupö ze nyaka ze ga ëdï kulë ŋgï kada mɔtɔ rɔ wa ma yawa. Domaꞌjo rɔze zïyï iꞌdi akonyo zize dugö ti yida rɔze ni ma ti nyaka ame ga dëdï timo ne. Kina ze mo ti doloma ŋgï rɔ bɔ ndɔbɔ zi bɔ dɔliŋɔ, tine nyaka ze ga ti koloma rɔ wa ꞌba bɔ dɔliŋɔ. Iꞌdi nyönyu zize gɔ dɔmɔ rɔze timo kina gɔ dari dulï mɔtɔ ga gbï mï nyaka ze ga. Kina nyaka ze ga inza kikali kpe tulë rɔ wa ma yawa.” ");
INSERT INTO bex_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kina Yesepa kugö nyaka ꞌba Ezipeto naga nima ŋgï ꞌdoyi rɔ gɔmo pili rɔ a ꞌba bɔ dɔliŋɔ. Lïjë ugö nyaka ꞌbënnï ga mökö römöyï ꞌbö ꞌdeni ŋgï rɔ ma kënyë tïnnï. Kina nyaka ŋgï pili rɔ nyaka ꞌba bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Kina Yesepa kugö bilaka naga nima ŋgï pili di mï dɔyayi ꞌba Ezipeto yayi rɔ bɔ ndɔbɔ zi bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nyaka ꞌba bɔ kata na ŋge Yesepa kugö dë römöyï bɔ dɔliŋɔ ëdï nduwë kiꞌdi akonyo zïnnï. Gɔ köꞌdu mo na ma kiꞌdi lïjë kinza kugö nyaka ma ꞌbënnï ga ne. ");
INSERT INTO bex_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Tine na Yesepa kiya zi bilaka naga nima, bo iya te, “Oŋgɔke te, leꞌjete mugö yida rɔye ꞌdeni pili ti nyaka ꞌbe ga rɔ wa ꞌba bɔ dɔliŋɔ. Kupö na me mëdï miꞌdi ziye arike timo kulïke mï nyaka ꞌbe ga, ");
INSERT INTO bex_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","kina ɔdɔ kiya te kpa dɔlili kömö ꞌdeni ozake kapa ma muyï ꞌba wa ame ga pili kɔdɔ ziye di mï nyaka ꞌbe ga ne gɔ kiꞌdike zi bɔ dɔliŋɔ. Tine gɔ kɔsɔ mo ga koloma rɔ eꞌbe ꞌdɔ këdï rɔ kupö gbï rɔ akonyo ziye ti bilaka ꞌbe ga ti kole titi ꞌbe ga.” ");
INSERT INTO bex_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Bilaka naga nima iya te, “Nï na me kɔmɔ ze ꞌdeni di mï tölë ꞌba ꞌbö löbu nime, ti doloma ŋgï rɔ bɔ ndɔbɔ zi bɔ dɔliŋɔ.” ");
INSERT INTO bex_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Wa nime na Yesepa kiꞌdi köꞌdu zi bilaka pili gɔ koza kapa ma muyï ꞌba wa ame ga lïjë kotɔtɔ di mï nyaka ne kiꞌdi zi bɔ dɔliŋɔ. Köꞌdu kiꞌdi nime öꞌbö nduwë te zi Ezipeto. Nyaka ꞌba bɔ kata na ŋge kileke kinza rɔ ꞌba bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tine Yisarele oloma ꞌbënnï mï yayi ꞌba Gosene di Ezipeto yayi. Lïjë ari koꞌdɔ rönnï ŋgï rɔ bɔ wa di yayi, lïjë köyö kole rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakoba oloma Ezipeto yayi ŋbö kɔmɔ kɔɔ ꞌbutë döömu dɔmorïyö, ŋbö kɔmɔ kɔɔ abo kari kömö kuluku rïyö kɔdɔ dɔmo ꞌbutë sowɔ döömu dɔmorïyö (147). ");
INSERT INTO bex_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kina ɔdɔ bo kɔꞌbɔ tölë ꞌdeni tine na bo kïdëkï kole abo Yesepa kako ŋgï zi bo. Kina bo kiya zi Yesepa, bo iya te, “Ɔdɔ kɔꞌɔ ma ŋgï ako kusu közïyï mï mbola ma kulömu röyï timo. Ulömu gɔ koꞌdɔ wa ame ga pili mititi yi toꞌdɔ mo ne. Ulömu röyï kiya te a mɔtɔ inza kusu ma Ezipeto bine, ");
INSERT INTO bex_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","tine gɔ kari kusu ma bi kɔtɔ ti baba löbu ni. Ɔdɔ mölë ꞌdeni ombi töku ma di Ezipeto bine kari kusu ma gɔ bi ame kusu ꞌbu ma löbu ga teyi ne.” Yesepa iya te, “Ti moꞌdɔ ŋgï kɔzɔ lende kiya ꞌbï tara.” ");
INSERT INTO bex_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakoba iya te, “Ulömu ꞌdɔ koꞌdɔ kɔzɔ wa nima tara.” Tine na Yesepa koꞌdɔ lömu ŋgï. Kina Yakoba koꞌdɔ yëëꞌdï ŋgï zi Bɔkoꞌba di dɔ laŋgiri yayi. ");
INSERT INTO bex_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yesepa uwö lende mo tëgë ꞌbu bo Yakoba ëdï dɔ rɔkɔꞌɔ, kina bo kënyï ŋgï kari ti kole abo ga Manase ni ti Eporima kari toŋgɔ Yakoba. ");
INSERT INTO bex_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kina ɔdɔ Yakoba kuwö kiya te Yesepa ömö ꞌdeni tine na bo kinzinzi rɔ bo ŋgï kënyï koloma tɔrɔ dɔ laŋgiri. ");
INSERT INTO bex_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Bo ilende zi Yesepa, iya te, “Mɔlo bine Bɔkoꞌba bɔ tigɔ dɔ kiteli ileme rönï zö. Mï kada nima mëdï Luza mï dɔyayi ꞌba Kanana. Bɔkoꞌba oꞌdɔ lömu ma laka zö, ");
INSERT INTO bex_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","iya te, ‘Ti miꞌdi yi köyö kole konzi gɔ kupö yï ga kara koloma rɔ kpa dɔꞌbe ma konzi. Ti miꞌdi yayi nime zi kupö yï ga köꞌbö ŋburu rɔ ëꞌbënnï.’ Lende ma Bɔkoꞌba kiya zö na tara. ");
INSERT INTO bex_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Kina me mëdï miya zïyï kole rïyö ꞌbï naga nime, Eporima ni ti Manase, ti koloma rɔ kole ma ga. Öyö lïjë Ezipeto bine gba kinza mako dë zïyï bine, ne lïjë ti koloma rɔ kole ma ga rɔ ma koriya ti Rubënï ni ti Simona. ");
INSERT INTO bex_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kina ɔdɔ kiya te kari köyö kole mɔtɔ ga gbï ꞌböwu tine, lïjë ti koloma rɔ kole ꞌbï ga inza kpe rɔ ꞌbama. Lïjë ti koꞌja apötö di zi Eporima ni ti Manase. ");
INSERT INTO bex_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mëdï moꞌdɔ lende nime gɔ köꞌdu ꞌba möyï Rayile ame kölë mï dɔyayi ꞌba Kanana ꞌdë yayi mï kada ma dëdï dako di Padanarama. Koꞌja dömö ꞌdeni ŋgɔsi ŋgila Eporata na lɔko kölë ŋgï tine ma rɔ meri rɔ mbëmbë gɔ lende mo. Musu nï yayi kpa kɔri kari Eporata.” Eporata nima, möyï mo ma leꞌjete na ꞌdeni rɔ Beteleme. ");
INSERT INTO bex_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kina ɔdɔ Yakoba koꞌja kole rïyö ꞌba Yesepa naga nima tine, bo ititi, iya te, “Yë mo ga na me ne?” ");
INSERT INTO bex_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yesepa iya te, “Kole ma ga na. Lïjë ame Bɔkoꞌba kiꞌdi zö di Ezipeto bine ne na.” Yakoba iya te, “Oꞌde lïjë kako ŋgɔsi zö bine gɔ moꞌdɔ yëyï dönnï.” ");
INSERT INTO bex_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakoba ꞌdeni rɔ bulöbu köndë kɔmɔ mo oꞌja bi dë kpe laka. Kina Yesepa koꞌde kole rïyö abo naga nima ŋgï kako ŋɔli zi ꞌbu bo. Yakoba iramo lïjë kome mbili mo. ");
INSERT INTO bex_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Bo iya zi Yesepa, iya te, “Mɔlo momeri miya te minza moꞌja yi kpe. Ne kina me moꞌja yi ꞌdeni ti kole ꞌbï ga, Bɔkoꞌba na koꞌdɔ lende laka nime ꞌdeni zö.” ");
INSERT INTO bex_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kina Yesepa kiyese kole abo naga nima yaga di rɔ Yakoba na bo kërë bërï kɔmɔ ꞌbu bo. ");
INSERT INTO bex_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Tine na bo koꞌde kole abo ga kako ꞌböwu ŋɔli zi Yakoba, bo iꞌdi Eporima dɔ gali Yakoba, Manase na bo kiꞌdi dɔ dörï. ");
INSERT INTO bex_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tine Yakoba oja közï bo ma dörï na kiꞌdi dɔ Eporima ame za rɔ kole ma titi ne. Kina bo kiꞌdi közï bo ma gali dɔ Manase ma tönë rɔ kole ma löbu mo ne. ");
INSERT INTO bex_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kina bo koloma ŋgï kɔzɔ wa nima tara toꞌdɔ yëyï zi Yesepa. Bo iya te, “Bɔkoꞌba koꞌdɔ lende laka zi kole naga nime. Bo ame ꞌbu ma löbu Abarayama ni ti Yisika koro bo ne. Bo na me koloma toŋgɔ gɔma ŋbö kömö mï kada nime tɔne, bo koꞌdɔ lende laka abo gbï zi kole naga nime. ");
INSERT INTO bex_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Malayika ꞌba Bɔkoꞌba koꞌdɔ lende laka gbï zïnnï. Bo na kɔmɔ ma kinza lende kënyë ɔtɔ kömö dɔma. Kole naga nime na ti kiꞌdi möyï ma ti möyï baba löbu Abarayama ni ti Yisika kïlëbï. Kupö lïjë ti kara konzi rɔ mbëmbë.” ");
INSERT INTO bex_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kina ɔdɔ Yesepa koŋgɔ Yakoba kiꞌdi közï bo ma dörï za dɔ Eporima tine mï bo indili dë kpe. Kina bo kombi közï Yakoba ma dörï yaga di dɔ Eporima ꞌdɔ tiꞌdi mo dɔ Manase. ");
INSERT INTO bex_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Bo iya te, “Baba, inza tara, oŋgɔ te kole ma dɔndende mo na me. Bo na gɔ kiꞌdi közïyï ma dörï dɔ bo.” ");
INSERT INTO bex_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tine Yakoba utï dë gɔ lende nima. Bo iya te, “Kole ma, mikali ꞌdeni ŋgï Manase na rɔ kole ma dɔndende, bo ti koloma rɔ ꞌbu ꞌba kpa roba ma löbu. Tine bɔ löndö bo Eporima ame rɔ kole ma titi ne ti këdï ŋgï mbiri di dɔ bo. Kupö Eporima ti këdï rɔ kpa roba ma konzi.” ");
INSERT INTO bex_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yakoba oꞌdɔ yëyï ꞌböwu zi kole naga nima, iya te, “Kupö Yisarele pili ti koꞌdɔ yëyï kada mɔtɔ ti möyï ye, kiya te, ‘Bɔkoꞌba koꞌdɔ lende laka zïyï kɔzɔ ma koꞌdɔ zi Eporima ni ti Manase.’ ” Kɔri ma Yakoba kiꞌdi Eporima këdï dɔgba zi Manase na me te. ");
INSERT INTO bex_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yakoba iya zi Yesepa, iya te, “Leꞌjete mɔꞌbɔ tölë ꞌdeni, ne Bɔkoꞌba ti koloma tiye. Bo ti kogba ye kileki ye yïꞌböwu kari dɔyayi ꞌba ꞌbu ye löbu ga. ");
INSERT INTO bex_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Yayi ꞌba Sekeme miꞌdi ꞌdeni zïyï Yesepa, dë zi löndö yï ga. Gɔ bi kɔꞌdɔ nima eꞌbe Amora ga na pa rɔ bɔ dɔmo, kina molɔ di zïnnï ti ya.” ");
INSERT INTO bex_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakoba ïdëkï kole abo ga pili kako zi bo, bo iya te, “Otɔtɔke rɔye kakoke gɔ miya wa ame ga pili këdï kömö ziye kada mɔtɔ ndɔ yayi ne ziye.” Kina bo koloma ŋgï toba ŋgala nime zïnnï. ");
INSERT INTO bex_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Kole ꞌba Yakoba ga ako kojeke mbili ye. Ako kuwöke lende kiya ꞌba ꞌbu ye Yisarele. ");
INSERT INTO bex_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubënï kole dɔndende ma, nï na rɔ tigɔ ma. Nï na möyö yi dɔgba gba ti tigɔ ma ame ꞌba dɔ yɔbi ma. Nï na mbiri di dɔ kole ma ama ga pili, tigɔ ꞌbï iteli ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tigɔ ꞌbï kɔzɔ dölölö ꞌba mini koso tara. Tine inza këddï kpe mbiri kiteli ya ama ga. Römöyï ebe köꞌdö ti ꞌja ꞌba ꞌbu yï kodɔ rɔ kaya rɔ ꞌbu yï. ");
INSERT INTO bex_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simona kpe ti Lëwë, kpe rɔ löndö dökïꞌdï ye kɔtɔ. Indaꞌbake mbele ꞌbe ga ŋgï koꞌdɔke ya. ");
INSERT INTO bex_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Minza modɔꞌbɔ rɔma tiye mï kpa kususu ꞌbe. Minza moloma tiye ɔdɔ kotɔtɔke kpeye. Eꞌbe rɔ ya kupöke bilaka. Okeke ndï ŋgulö sa ŋgï bërï rɔ ma sari. ");
INSERT INTO bex_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ya kënyë ꞌbe nima ti dökïꞌdï kënyë ꞌbe nima ti koꞌdɔ ye nduwë rɔ kpa sönö. Ti mïyëyï ye rɔ kɔtɔkɔtɔ mï dɔyayi ꞌba Yisarele. Ti moza mï kpa roba ꞌbe ga titititi. ");
INSERT INTO bex_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, löndö yï ga pili ti kïlëlu yi. Ti kaꞌda bɔ ya ꞌbï ga. Löndö yï ga ti kolɔdɔ bërï zïyï. ");
INSERT INTO bex_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Nï kɔzɔ tabïyö ꞌbɔꞌbi ame kindaꞌba yida. Bo ileki kako timo liŋɔ na bo köꞌdö ŋgï bërï. Yë na ti kilaŋa rönï kari koŋbeŋbe kpa bo? Yë na ti kilaŋa rönï kari koŋbeŋbe kpëyï? ");
INSERT INTO bex_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda, përï ꞌba ŋere ti köꞌbö közïyï. Kupö yï na ti köꞌbö ŋburu rɔ ŋere ŋbö bɔ dɔ ŋere mo kako. Bilaka pili ti koro bo. ");
INSERT INTO bex_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Bo ti këdï rɔ bɔ mɔri ma löbu. Mɔwɔ këdï koꞌdɔ rɔ layi ti këdï zi bo rɔ mbëmbë. Bo ti kosi dɔ akaca abo yɔki mɔtɔ ga. Layi mo ti këdï rɔ mbëmbë. Bo ti kurögö bɔŋgɔ abo ga timo. ");
INSERT INTO bex_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Kɔmɔ bo öꞌbö ŋgï rɔ ma kasi di zi layi. Kiliŋba kpa bo aŋmi ŋgï ŋböwö di bi tuwë wï. ");
INSERT INTO bex_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebolona, ti koloma köꞌbö kpa mini löbu. Sorope ti köꞌbö tusuru kpa götö abo. Dɔ maga abo ti këdï rɔ ma kɔwɔ ŋbö kömö Sidona. ");
INSERT INTO bex_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Yisakara ŋgï kɔzɔ akaca ma kitigɔ ame köꞌdö mï löŋgö akombi abo ga. ");
INSERT INTO bex_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tine ɔdɔ bo koŋgɔ bi ꞌba rɔ kindawo mo kele, dɔyayi mo kele na bo kodi gɔ bo tombi akombi. Öꞌbö tutörï bo mï ndɔbɔ kɔzɔ atɔli. ");
INSERT INTO bex_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dana ti këdï rɔ ŋere dɔ bilaka abo ga. Lïjë roba kɔtɔ ꞌba Yisarele naga na. ");
INSERT INTO bex_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Bo kɔzɔ murë ame köꞌdö kpa kɔri ne. Bo oga ndï kosani bɔ dɔmo kilaꞌba bërï. ");
INSERT INTO bex_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Bɔkoꞌba, mëdï molɔꞌbɔ ꞌbama ŋgï gɔ nï na kɔmɔ ma. ");
INSERT INTO bex_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada, bɔ akolɔ ti kota kpëyï, tine ti kuyï kpëyï koga lïjë. ");
INSERT INTO bex_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asera, akonyo ꞌbï ti köꞌbö rɔ a ma laka. Akonyo ꞌbï ti köꞌbö rɔ ma koŋmi kɔzɔ akonyo ꞌba ŋere. ");
INSERT INTO bex_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napatali, nï ꞌbëyï kɔzɔ gole riŋa mbëmbë, ame köyö kole ma kele ne. ");
INSERT INTO bex_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yesepa, nï ꞌbëyï kɔzɔ ŋgërï ame kötu kpa daa ne. Dɔŋgila mo ga aꞌba kari dɔ reki. Bo ana rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Bɔ ya ꞌbï ga ti kota kpëyï. Lïjë ti koga göyï ti kanya. ");
INSERT INTO bex_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tine ti kindaꞌba kanya ꞌbëyï kitigɔ. Közïyï inza kïlëꞌdï. Tigɔ abo ꞌba Bɔkoꞌba ti kiꞌdi kɔnyɔ yï köꞌbö rɔ ma kitigɔ. Bo na rɔ Bɔkoꞌba ame koloma toŋgɔ gɔ Yakoba bine ti tigɔ abo, kɔzɔ bɔ koda kamölö tara ne. Bo na rɔ döku ꞌba kɔnyi zi Yisarele. ");
INSERT INTO bex_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Bɔkoꞌba ꞌba ꞌbu yï na kokɔnyi yi. Bo na ti tigɔ dɔ kiteli. Bo koꞌdɔ yëyï zïyï. Bo kiꞌdi tɔrɔ kaꞌdi zïyï. Bo kiꞌdi mini kulöwu zïyï di mï yayi. Bo koja gɔ löyö zi ꞌja ꞌbï ga. Bo kiꞌdi mba mo ga kïlërï. ");
INSERT INTO bex_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Yëyï ma ꞌba ꞌbu yï ele kiteli yëyï ꞌba mini këyï ma kɔlɔ di mï döku löbu. Lïjë döku naga nime ëdï mɔlo bine di bi tisaki ꞌba dɔliŋɔ nime. Yëyï naga nime kotɔŋi rönnï pili ti dɔ Yesepa. Oza bo ꞌdeni di mï löŋgö löndö bo ga. ");
INSERT INTO bex_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyimona ꞌba bo rɔ bïlö wölïwölï ma kembe. Bo öꞌbö ꞌba bo tupö yida tonyo mo ŋgï rɔ kɔmɔ kada pili.” ");
INSERT INTO bex_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ŋgala ma Yakoba koꞌdɔ lömu timo dɔ kole ꞌbutë dɔmorïyö abo ga na me. Ya naga nime lïjë na rɔ yï lïŋgï ꞌba kpa roba ꞌbutë dɔmorïyö ꞌba Yisarele. Bo oꞌdɔ lömu pili zïnnï rɔ kɔtɔkɔtɔ gɔ wa ame ga koriya tïnnï. ");
INSERT INTO bex_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Kina Yakoba kose kpa bo ma ŋburuŋburu mo ŋgï zi kole abo ga, bo iya te, “Mëdï mozi ꞌdeni gɔ töku ne baba ni. Tine moꞌdɔkɔ ꞌdɔ kombike töku ma kilekike timo mï dɔyayi ꞌba Kanana. Ari kusuke ma bi kɔtɔ ti baba ni mï tïꞌbörö ma tönë mï nyaka ꞌba Makapela ne. Ëdï kebe kapa Mamore ma kari yïbï. Gɔ bi nima pa mɔlo bine rɔ bi ꞌba Eporona eꞌbe Ete. Tine Abarayama ugö ꞌdeni di zïnï tusu bilaka abo ga yïmo. ");
INSERT INTO bex_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Bi nima na kusu Abarayama ni ti ꞌja abo Sara teyi, gbï ti Yisika ni ti ꞌja abo Rebeka. Kina musu ꞌja ma Leya gbï yayi. ");
INSERT INTO bex_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nyaka nima ꞌbu ze löbu ugö ꞌdeni di zi eꞌbe Ete kpaki ti tïꞌbörö mo.” ");
INSERT INTO bex_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kina ɔdɔ Yakoba kote tose gɔ lende naga nime ꞌdeni zi kole abo ga kɔzɔ a nime te tine, bo öꞌdö ŋgï bërï yɔ na bo kulöku ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yesepa ulöru dɔ töku ꞌbu nnï kiramo koloma tudu. ");
INSERT INTO bex_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Bo ënyï kiꞌdi lende mo zi bilaka ame ga kikali ndɔbɔ ꞌba wɔwɔ ne ꞌdɔ kosa ꞌbu ti wɔwɔ rɔ töku ꞌbu bo gɔ koloma kinza kato. ");
INSERT INTO bex_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Bilaka naga nima oloma toꞌdɔ mo nduwë ŋbö töꞌdö dɔ ꞌbutë sowɔ, römöyï kada ꞌba toꞌdɔ mo na tara. Ezipeto gbï udu Yakoba ŋbö töꞌdö dɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö (70). ");
INSERT INTO bex_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kina ɔdɔ kada ꞌba monɔ kote rönï ꞌdeni tine, Yesepa iya zi bilaka löbu ꞌba bɔ dɔliŋɔ naga nima, iya te, “Ari kiyake lende ma zi bɔ dɔliŋɔ. Ari kiyake te, ");
INSERT INTO bex_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","mï kada ma ꞌbu ma këdï koꞌdɔ ꞌdeni tölë bo iꞌdi ma mulömu rɔma gɔ mari musu bo ŋbö gɔ bi ame bo kileŋo ꞌdeni mï dɔyayi ꞌba Kanana ne. Ititike bɔ dɔliŋɔ gɔ bo kodɔ kpama mari tusu ꞌbu ma, ti muyï dɔma ꞌjaa mako bine.” ");
INSERT INTO bex_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Bɔ dɔliŋɔ utï dɔmo zi Yesepa, iya te, “Ari kusu ꞌbu yï kɔzɔ ame kulömu röyï ꞌdeni mɔlo ne tara.” ");
INSERT INTO bex_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kina Yesepa kënyï ŋgï kari Kanana tusu ꞌbu bo. Bilaka löbu ꞌba bɔ dɔliŋɔ naga nima ari kɔtɔ ti Yesepa gbï ti bilaka ma kɔmɔ kɔpɔ ꞌba Ezipeto mɔtɔ ga, ");
INSERT INTO bex_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","gbï ti bilaka abo ga pili ti bɔ löndö bo ga kpaki ti bilaka ꞌba ꞌbu bo ga. Kole titi na ŋge kileke Gosene yayi ti yërï ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kina bilaka mɔtɔ ga ari gbï tïnnï këkï ꞌbënnï dɔ kosani ti ya mɔtɔ ga ame këkï ꞌbënnï mï aribiya ma kosani këdï kotɔ naga. Lïjë pili rɔ tïndï ma löbu. ");
INSERT INTO bex_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Lïjë umu yöpö ꞌba Yaradene kari kömö bi ꞌba tomba nyönyu ꞌba Atada. Lïjë oloma bina töꞌdö dɔ modɔmorïyö tudu Yakoba ti monɔ rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kina ɔdɔ Kanana ame mo ga këdï koloma yayi ne koꞌja lïjë këdï kudu rɔ mbëmbë tine lïjë iya te, “Wu, Ezipeto ëdï ꞌdeni tudu rɔ ma kënyë.” Kina lïjë kïdëkï möyï gɔ bi nima ŋgï rɔ Abele Misarima, ame ꞌjɔ ꞌba lende mo tëgë “Monɔ ꞌba Ezipeto.” Bi mo nima ɔwɔ dë di ŋgila yöpö ꞌba Yaradene. ");
INSERT INTO bex_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kole ꞌba Yakoba ga oꞌdɔ kɔzɔ ame bo kose gɔmo zïnnï ne tara. ");
INSERT INTO bex_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Lïjë ombi töku bo kari timo dɔyayi ꞌba Kanana kari kusu mï tïꞌbörö mï nyaka ꞌba Makapela, ame kebe kapa Mamore ma kari yïbï ne. Nyaka nima ti tïꞌbörö mo na rɔ ame Abarayama kugö di zi Eporona bɔ Ete tönë tusu töku abo ga yïmo. ");
INSERT INTO bex_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kina ɔdɔ Yesepa kusu ꞌbu bo ꞌdeni yayi tine, bo ileki kari Ezipeto ti löndö bo ga pili ti bilaka ame ga kari ti bo bi ꞌba monɔ nima yayi ne. ");
INSERT INTO bex_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Di pötö Yakoba kölë ꞌdeni löndö ꞌba Yesepa ga ŋgï rɔ tikere. Lïjë oloma tiya mo rɔ gɔ rönnï, iya te, “Mɔtɔga Yesepa ti kënyï komeri gɔ lende kënyë ma tönë ga doꞌdɔke zi bo ne, bo kileki koꞌdɔ dɔkolo ma gbï zize.” ");
INSERT INTO bex_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kina lïjë koja laja zi Yesepa, iya te, “Gba bine kinza ꞌbu ze kölë dë bo ose gɔ lende zize ");
INSERT INTO bex_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","tëgë gɔ diya zïyï ꞌdɔ kola ze gɔ lende kënyë ame doꞌdɔ zïyï ne. Kina me leꞌjete domaꞌjo rɔze zïyï ꞌdɔ kola ze gɔ lende kënyë ze. Ze gbï doro Bɔkoꞌba ma koŋgɔ gɔ ꞌbu ze.” Kina ɔdɔ Yesepa kuwö lende nime te tine na bo kudu ŋgï. ");
INSERT INTO bex_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kina löndö bo ga kako zi bo kolɔdɔ bërï kɔmɔ bo, kiya te, “Nï na rɔ bɔ dɔze.” ");
INSERT INTO bex_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Bo iya te, “Kinza kereke dë. Ma Bɔkoꞌba na dë gɔ miya burë ꞌbe. ");
INSERT INTO bex_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Rɔ ma laka kpe na koꞌdɔke lende kënyë zö. Tine Bɔkoꞌba iꞌdi lende laka ꞌdeni kɔdɔ di mï lende kënyë nima gɔ bilaka ma konzi kɔmɔ di mï tölë. ");
INSERT INTO bex_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kinza kereke dë, mëdï moŋgɔ gɔye ti bilaka ꞌbe ga pili.” Lende nime na Yesepa kïyëyï dökïꞌdï löndö bo ga timo kiꞌdi lïjë koloma dë kpe rɔ tikere. ");
INSERT INTO bex_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yesepa oloma koꞌdɔ kɔmɔ kɔɔ konzi ti eꞌbe ꞌbu bo ga mï Ezipeto yayi. Mï kada ꞌba tölë abo tine kɔmɔ kɔɔ abo ꞌdeni kuluku rïyö kɔdɔ dɔmo ꞌbutë (110). ");
INSERT INTO bex_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Bo oꞌja kole ꞌba kole ꞌba Eporima ga ti kɔmɔ bo. Kina gbï Makira kole ꞌba Manase öyö kole tine Yesepa ogba rɔ kole ꞌba mï liŋɔ abo ga. ");
INSERT INTO bex_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bo iya te zi löndö bo ga, “Mɔꞌbɔ tölë ꞌdeni, ne Bɔkoꞌba ti koŋgɔ gɔye. Bo ti kako kogba ye ꞌjaa di dɔyayi nime bo kileki ye karike dɔyayi ma tönë bo kulömu ꞌdɔ tiꞌdi mo zi Abarayama ni ti Yisika ti Yakoba ne.” ");
INSERT INTO bex_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kina bo kiꞌdi ya ëꞌbënnï ga kulömu rönnï. Bo iya te, “Ulömuke rɔye ɔdɔ Bɔkoꞌba kako kogba ye këdï kileki ye kari dɔyayi nima ombike töku ma karike timo.” ");
INSERT INTO bex_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tine na bo kölë ŋgï. Kɔmɔ kɔɔ abo ꞌdeni kuluku rïyö kɔdɔ dɔmo ꞌbutë (110). Kina bilaka abo ga kosa ꞌbu ŋgï ti wɔwɔ rɔ töku bo gɔ koloma kinza kato. Kina lïjë kiꞌdi töku bo ŋgï mï sandu di Ezipeto yayi.");
INSERT INTO bex_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Kole ꞌba Yakoba tönë ga kari ti bo Ezipeto, mɔtɔ nï ti bɔ bɔyi ꞌbï ga ne möyï lïjë na me. ");
INSERT INTO bex_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubënï ti Simona ti Lëwë ti Yuda ");
INSERT INTO bex_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ti Yisakara ti Zebolona ti Benyimona ti ");
INSERT INTO bex_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dana ti Napatali ti Gada ti Asera. ");
INSERT INTO bex_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Kupö Yakoba ame ga kari ti bo kömö yayi ne ëdï pili kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö. Tine Yesepa ëdï ꞌba bo ꞌdeni mɔlo yayi. ");
INSERT INTO bex_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kina ɔdɔ lïjë koloma ꞌdeni Ezipeto yayi kɔmɔ kɔɔ mo konzi tine tölë ari kupö Yesepa ni ti löndö bo naga nima ŋgï kpaki ti ya ma kako tïnnï tönë ga. ");
INSERT INTO bex_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Tine kupö lïjë ara ꞌdeni ŋgï konzi kogba mï dɔyayi ꞌba Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kina bɔ dɔliŋɔ mɔtɔ ꞌba Ezipeto ame ꞌberi kinza kikali Yesepa dë ne na ꞌdeni dɔ kïtï. ");
INSERT INTO bex_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Bɔ dɔliŋɔ mo nima kïdëkï gbï rɔ Paro ꞌbënnï mo ne ënyï kilende zi bilaka abo ga, iya te, “Oŋgɔke te, Yisarele naga nima lïjë na ma kara ꞌdeni ŋgï konzi rɔ ma kënyë rɔ lende rɔze. ");
INSERT INTO bex_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Oꞌdɔkɔ zize ꞌdɔ toŋgɔ bi dönnï doꞌdɔke a mɔtɔ zïnnï römöyï lïjë ëdï koto tara ŋgï nduwë rɔ mbëmbë kina ɔdɔ ya na kömö yɔ na lïjë këdï kodɔꞌbɔ rönnï ŋgï ti bɔ ya kileki ꞌböwu tupö ze gɔ lïjë kënyï kiriŋa ëꞌbënnï ŋgï.” ");
INSERT INTO bex_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kina Ezipeto naga nima kiꞌdi turu ꞌba toŋgɔ gɔ Yisarele ŋgï kota kpamo ti ndɔbɔ ma kïrïndï tïdïrï mo timo. Iꞌdi lïjë koꞌba gawo ꞌba Pitomo ni ti Ramese rɔ bi ꞌba tikeki wa abo ꞌba bɔ dɔliŋɔ ꞌba Ezipeto mo nima. ");
INSERT INTO bex_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tine gomɔ löbu nime këdï kodɔ pele rönnï rɔ mbëmbë te nime na lïjë kara ŋgï rɔ dɔ kiteli nati kogba mï dɔyayi ꞌba Ezipeto nima ti rönnï kiꞌdi Ezipeto ŋgï rɔ tikere. ");
INSERT INTO bex_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Kina kodɔ ŋgï zi Ezipeto nati rɔ tupö Yisarele ti ndɔbɔ ma kinza kiya naga. ");
INSERT INTO bex_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ari kömö ŋgï mï lende ma kata kulöwö mo zi Yisarele kiꞌdi ye ꞌbeye ŋgï rɔ bɔ toꞌdɔ ndɔbɔ ꞌba toꞌba rö ꞌbënnï ga ti nyaka ꞌbënnï ga koꞌdɔ ye dë kpe ŋgï nati koꞌde bilaka lesi. ");
INSERT INTO bex_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kina bɔ dɔliŋɔ mo nima ënyï kilende zi bɔ bulï ma löbu rïyö mɔtɔ ga ꞌba Ebere kïdëkï möyï mo rɔ Sipora ni ti Powa, iya te, ");
INSERT INTO bex_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ɔdɔ këddï kindaꞌbake kole ꞌba Ebere naga nima, ɔdɔ koꞌjake köyö rɔ bɔtɔni upöke yaga tine ɔdɔ këdï rɔ nyiti na kolake.” ");
INSERT INTO bex_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tine bɔ bulï naga nima ere ëꞌbënnï Bɔkoꞌba gbï lïjë ari dë ŋgï koꞌdɔ kɔzɔ lende nima bɔ dɔliŋɔ kiya zïnnï ne. Ɔdɔ köyö pele rɔ kole bɔtɔni lïjë ola ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tine na bɔ dɔliŋɔ kïdëkï bɔ bulï rïyö naga nima kititi, iya te, “Waꞌdi na këddï koꞌdɔke tara këddï kolake kpa kole bɔtɔni ꞌba Ebere naga nima këdï gba ꞌbiri kunzï ne?” ");
INSERT INTO bex_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ꞌJa tönë ga ileki kiya te, “Ŋere, ꞌja ꞌba Ebere naga nime inza kɔzɔ ꞌja ꞌbeye ga ꞌba Ezipeto. Löyö ꞌbënnï ïdësï dë. Ɔdɔ dëdï dömö pele dako doꞌja köyö ꞌdeni mɔlo.” ");
INSERT INTO bex_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Bɔkoꞌba ti mï këyï rɔ bɔ bulï naga nima römöyï lïjë ere bo. Kina bo kiꞌdi kupö ŋgï gbï zïnnï lïjë kara konzi. Kina Yisarele koto tara ŋgï nduwë rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kina bɔ dɔliŋɔ kiꞌdi köꞌdu mo ŋgï zi bilaka abo ga pili, iya te, “Kole ꞌba Ebere ame ga koꞌjake köyö rɔ kole bɔtɔni ne, ogbake kuꞌduke gɔ yöpö. Tine ɔdɔ këdï rɔ nyiti olake.” ");
INSERT INTO bex_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Mï kada mo naga nima na bɔ mɔtɔ di mï kupö eꞌbe Lëwë, ꞌja abo gbï di mï kupö lïjë kɔtɔ nima ");
INSERT INTO bex_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","köyö ŋgï rɔ kole bɔtɔni. Kina ɔdɔ lɔko koŋgɔ kole ꞌbënï nima kele ŋgï kulöwö tara tine na lɔko kogba ŋgï koloma rɔ tusu dɔmo ŋbö nyepe mota. ");
INSERT INTO bex_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kina ɔdɔ kole kari kandi ꞌdeni lɔko kɔꞌbɔ dë kpe tusu dɔmo tara tine na lɔko koꞌde kee ma kuꞌjö di mï mɔli rïtï ŋgï lɔko kora kɔmɔ mo teyi ti zïbïtï. Na lɔko koꞌba kole tönë ŋgï yïmo lɔko kari kutë mï liya mï yöpö. ");
INSERT INTO bex_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Tine lëmï mo ɔrɔ caki yaga rɔ ma kɔwɔ toŋgɔ wa ma këdï koꞌdɔ tömö dɔ kole nima. ");
INSERT INTO bex_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kina nyiti ꞌba bɔ dɔliŋɔ kari ŋgï kpa yöpö yayi turögö rönï. Kina koꞌja bɔ laja ꞌbënï ga këdï kiliŋgere kebe dɔ kpa götö yayi yɔ na kömönï kilaꞌba ŋgï rɔ kee tönë. Na lɔko koja nyiti ma rɔ bɔ laja ꞌbënï mo ŋgï kari koꞌde. ");
INSERT INTO bex_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Nyiti nima ari koꞌde zïnï na lɔko kombi dɔmo kina koꞌja ŋgï rɔ kole na yïmo këdï kudu koꞌde lisa ŋgï kömönï. Lɔko iya te, “Kole ꞌba Ebere naga nime na.” ");
INSERT INTO bex_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Lëmï mo tönë ako kititi lɔko iya te, “ꞌDɔ moma bɔ kiꞌdi mba kpamo ziye di mï löŋgö ꞌja ꞌba Ebere ya?” ");
INSERT INTO bex_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Nyiti ꞌba bɔ dɔliŋɔ mo tönë iya te, “Yëë, ari koꞌde.” Kina lɔko kari ŋgï koꞌde ko rɔ ma mo. ");
INSERT INTO bex_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nyiti ꞌba bɔ dɔliŋɔ iya zi ꞌja nima te, “Ogba kole nime kulu ama zö. Mëdï mopi gïrïsï zïyï gɔmo.” Kina ꞌja nima kogba kole nima ŋgï kari timo kulu. ");
INSERT INTO bex_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kina ɔdɔ kole kiliŋgere ꞌdeni kandi tine na lɔko kogba ŋgï koto kiꞌdi zi nyiti ꞌba bɔ dɔliŋɔ rɔ kole ꞌbënï. Lɔko iꞌdi möyï mo rɔ Musa. ꞌJɔ ꞌba lende mo tëgë, “Motɔ ama di yï mini.” ");
INSERT INTO bex_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mï kada ma dɔ kɔtɔ mɔtɔ yayi koꞌja Musa kïyöbu ꞌdeni na bo kënyï kari toŋgɔ bilaka ꞌbënnï ga Yisarele. Bo ari koꞌja lïjë këdï mï ndɔbɔ kïrïndï. Tine na bo kari koꞌja bɔ Ezipeto mɔtɔ ŋgï këdï rɔ tomba bɔ Yisarele mɔtɔ, bilaka ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Bo oŋgɔ bɔtɔ inza ŋgɔsi yayi yɔ na bo kupö bɔ Ezipeto nima ŋgï bo kusu dɔ töku mo mï yayi lida. ");
INSERT INTO bex_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mï bi këzë ma di pötö mo na bo kari koꞌja Yisarele ma rïyö mɔtɔ ga këdï bi ꞌdïrï. Bo ënyï kititi bɔ ma koma ꞌdïrï mo nima, bo iya te, “Ëddï komba Yisarele lëpï yï tara gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Bɔ nima ileki dɔmo zi Musa, iya te, “Nï, yë na koꞌdɔ yi rɔ ŋere dɔze toꞌdɔ burë ze? Ëddï koꞌdɔ ꞌdɔ kupö ma gbï kɔzɔ ma tönë kupö bɔ Ezipeto nima bine ne?” Kina Musa ŋgï rɔ tikere. Bo omeri iya te, “Wa nime moꞌdɔ ne ëdï kinda yaga.” ");
INSERT INTO bex_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kina ɔdɔ lende mo kömö mbili bɔ dɔliŋɔ tine bo iteri ŋgï ꞌdɔ tupö Musa yaga. Tine na Musa kënyï kiriŋa ŋgï kari Midiyana. Bo ari kömö yayi bo koloma kpa daa. ");
INSERT INTO bex_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Tine bɔ akumu mɔtɔ ꞌba Midiyana yayi ëdï ti yïtötï modɔmorïyö. Kina yïtötï naga nima kömö ŋgï tunö mini gbï todɔ mini mï wörï zi kamölö ꞌba ꞌbu nnï ga tuwë mo. ");
INSERT INTO bex_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Bɔ koda kamölö mɔtɔ ga ömö ŋgï gbï yayi koloma rɔ toga yïtötï tönë ga yaga. Kina Musa kako ŋgï koꞌdɔ kpërï gönnï kunö mini zi kamölö ma ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kina ɔdɔ yïtötï naga nima kuyï dönnï ŋgï kömö welo liŋɔ zi ꞌbu nnï Yetoro tine bo ënyï kititi lïjë iya te, “Ma tɔne ömöke ŋgï mɔlo te gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Lïjë iya te, “Bɔ Ezipeto mɔtɔ na kokɔnyi ze bo kunö mini zize gbï zi kamölö ze ga.” ");
INSERT INTO bex_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Bo ileki kititi yïtötï abo naga nima, bo iya te, “Ne bo ëdï yala? Olake bo mökö gɔ waꞌdi? Oꞌdeke bo kako liŋɔ gɔ bo konyo kpa bo.” ");
INSERT INTO bex_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa utï ŋgï dɔmo toloma ti bulöbu nima. Kina bo kogba nyiti abo mɔtɔ rɔ Zipora ŋgï kiꞌdi rɔ ꞌja zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora öyö rɔ kole bɔtɔni zi Musa kina bo kiꞌdi möyï mo ŋgï rɔ Geresomo, ame kiya te “Bɔ löwö”, römöyï bo omeri bo iya te, “Ma ꞌdeni rɔ bilaka mï dɔyayi löwö nime.” ");
INSERT INTO bex_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Di pötö kɔmɔ kɔɔ konzi ꞌdeni yayi tine na bɔ dɔliŋɔ ꞌba Ezipeto mo tönë kari kölë ŋgï. Tine pele Yisarele gba nduwë mï ndɔbɔ kïrïndï nima tileri di kpamo topapa kɔnyi. Kina monɔ ꞌbënnï di kpa közï lisa ma këdï koꞌdɔ rönnï ne kömö ŋgï mbili Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Bɔkoꞌba uwö monɔ ꞌbënnï na bo komeri lömu abo ma tönë bo koꞌdɔ mɔlo ti Abarayama ni ti Yisika ti Yakoba ne ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Bo oŋgɔ lisa ꞌba bilaka abo ga Yisarele kina lende mo kɔꞌɔ ŋgï rɔ bo. ");
INSERT INTO bex_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mï kada ma dɔ kɔtɔ mɔtɔ koꞌja Musa këdï rɔ toda kamölö ꞌba Yetoro bɔ lanzo bo bɔ akumu ꞌba Midiyana nima tine, na bo kona kamölö ŋgï kari timo rɔ ma kɔwɔ ŋbö yï mökö ndï döku koro mɔtɔ yayi kïdëkï möyï mo rɔ Sinayi. ");
INSERT INTO bex_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Di yayi na malayika ꞌba Bɔkoꞌba kɔdɔ ŋgï zi bo rɔ paꞌdo köbö mï zana morogo. Musa oŋgɔ lende nima paꞌdo nima öbö pele tara tine morogo mo ilaŋma dë gbï yɔ. ");
INSERT INTO bex_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Bo omeri bo iya te, “Sëgë waꞌdi ga na te? Morogo mo ilaŋma dë rɔ ma totondo mo ga tara? Iꞌdi mari te ŋgɔsi toŋgɔ mo.” ");
INSERT INTO bex_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kina ɔdɔ ŋere Bɔkoꞌba koŋgɔ bo kese ꞌdeni ŋgɔsi toŋgɔ mo tara tine, na kïdëkï bo ŋgï di mï morogo yayi iya te, “Musa, Musa.” Musa iya te, “Ma na me.” ");
INSERT INTO bex_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Bɔkoꞌba iya te, “Kinza kese dë kpe kulöwö ꞌde. Otɔ wari yaga di ndïyï römöyï bi nima këddï kɔrɔ teyi, yayi koro na.” ");
INSERT INTO bex_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Bɔkoꞌba ënyï kileki ꞌböwu gbï kiya te, “Ma na rɔ Bɔkoꞌba ꞌba ꞌbu yï löbu Abarayama ni ti Yisika ti Yakoba.” Kina Musa kusu kɔmɔ bo ŋgï bërï römöyï bo ere di bi toŋgɔ Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ŋere Bɔkoꞌba iya te, “Rɔ ma laka moꞌja lisa ꞌba bilaka ma ga ꞌdeni di Ezipeto. Muwö ꞌdeni ma lïjë këdï kudu di kpa közï gomɔ ꞌba turu bɔ koŋgɔ gönnï ga. Kina lende ꞌbënnï ɔꞌɔ ꞌdeni rɔma. ");
INSERT INTO bex_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kina me mako ꞌdeni bërï tɔmɔ lïjë di közï Ezipeto naga nima ꞌdɔ moꞌde lïjë kako yaga di mï dɔyayi nima kako mï yayi ma laka ame tagi ni ti wï sa kambi di teyi kɔzɔ sëgë ne. Bi nima Kanana naga nima ti Ete ti Amora ti Pereze ti Iwa ti Yebusa këdï koloma teyi ne. ");
INSERT INTO bex_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Monɔ ꞌba bilaka ma ga Yisarele ömö ꞌdeni mbili ma kina moꞌja kpɔŋi ame Ezipeto këdï koꞌdɔ rönnï ne ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kina me ari, mëdï moja yi kari zi bɔ dɔliŋɔ ꞌbënnï ꞌba Ezipeto mo nima ꞌdɔ koꞌde lïjë bilaka ma ga yaga di mï dɔyayi abo nima.” ");
INSERT INTO bex_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Tine Musa ënyï kileki dɔmo zi Bɔkoꞌba iya te, “Ma yë na gɔ mari zi bɔ dɔliŋɔ moꞌde Yisarele yaga di Ezipeto?” ");
INSERT INTO bex_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Bɔkoꞌba iya te, “Ti mëdï tïyï. Akileme ꞌba ame ma na mëdï moja yi ne ti këdï kɔzɔ a nime te, ɔdɔ kari koꞌde lïjë ꞌdeni ti kako kumötuke ma dɔ döku nime bine.” ");
INSERT INTO bex_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa iya te, “Ne ɔdɔ mari zïnnï miya te, ‘Bɔkoꞌba ꞌba ꞌbu ye löbu ga ma mɔlo na me koja ma ziye,’ ne ɔdɔ lïjë kënyï kititi ma kiya te, ‘Möyï bo rɔ yë?’ gɔ miya tondo ga zïnnï?” ");
INSERT INTO bex_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Bɔkoꞌba iya te, “Ma na rɔ bɔ ame rɔ ma mo ne. Kina ꞌdɔ kiya zïnnï kɔzɔ a nime te, ‘Bɔ ame kïdëkï rɔ ma mo ne, bo na me koja ma ziye.’ ");
INSERT INTO bex_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kina ꞌdɔ kiya gbï zïnnï Yisarele, ‘Bɔ ma kïdëkï rɔ ma mo tönë, ŋere Bɔkoꞌba ꞌba ꞌbu ye löbu Abarayama ni ti Yisika ti Yakoba na me koja ma ziye.’ Möyï nime na ꞌdɔ dɔ kupö pili ame ga këdï köyö pele kɔwɔ yayi ne kïdëkï ma nduwë timo rɔ ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ari kotɔtɔ dɔ löbu ꞌba Yisarele kilende zïnnï kiya te, ‘Ŋere Bɔkoꞌba ꞌba ꞌbu ye löbu ga Abarayama ni ti Yisika ti Yakoba ɔdɔ kileme rönï zö kiya te, “Moŋgɔ ye ꞌdeni kina moꞌja wa ame Ezipeto këdï koꞌdɔ ziye ne ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ne momeri ꞌdeni gɔ moꞌde ye yaga di mï kpɔŋi nima Ezipeto këdï koꞌdɔ kulöwö rɔye ne moꞌde ye kako mï dɔyayi ꞌba Kanana ꞌba Ete ꞌba Amora ꞌba Pereze ꞌba Iwa ti ꞌba Yebusa ni. Yayi ma laka ame wï sa ni ti tagi kambi ŋgï di teyi kɔzɔ sëgë ne.”’ ");
INSERT INTO bex_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Löbu ꞌba Yisarele ti kuwö döyï. Kina ꞌdɔ karike tïnnï zi bɔ dɔliŋɔ ꞌba Ezipeto mo nima kiyake zi bo te, ‘Ŋere Bɔkoꞌba ze ꞌba Ebere ɔdɔ ꞌdeni kileme rönï zize. Iꞌdi ze dari yï mökö rɔ liŋgere ꞌba töꞌdö dɔ mota tumu roma zi bo ŋere Bɔkoꞌba ze.’ ");
INSERT INTO bex_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ne rɔ ma laka mikali bɔ dɔliŋɔ nima inza kodɔ kpeye tari, tine ꞌjaa ŋbö ɔdɔ kpa közö Bɔkoꞌba na kɔdɔ ꞌdeni rɔ bo. ");
INSERT INTO bex_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ti moja közö ti tigɔ ma modɔ karama dɔ Ezipeto ti wa ame ga pili lende mo ga kigayi wa ne. Di pötö mo tine na bo ti kodɔ kpeye ꞌjaa karike. ");
INSERT INTO bex_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mï kada mo nima ti miꞌdi Ezipeto koro ye ꞌdɔ ɔdɔ këddï kɔdɔke kinza bilaka ma ga kari ra rɔ közï sari kinza a ꞌba mɔri. ");
INSERT INTO bex_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ꞌJa ꞌba Yisarele pili ti kari kokpasi yamo ma köbököbö ti sïtërï ni ti bɔŋgɔ di zi ꞌja ꞌba Ezipeto ame ga liŋɔ mo ŋgɔsi tïnnï ne ala ma këdï tïnnï liŋɔ kɔtɔ. Kina ti kiꞌdi ŋgï zïnnï. Kina ꞌdɔ kiꞌdike dɔ kole ꞌbe ga ti yïtötï ꞌbe ga kombi a ꞌba mɔri ꞌba Ezipeto naga nime konake karike timo.” ");
INSERT INTO bex_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa ititi iya te, “Ne ɔdɔ lïjë kiꞌdi dönnï dë gɔ lende ma kuwö lende ma dë gbï gɔ moꞌdɔ tondo? Ɔdɔ lïjë kiya te, ‘Bëtï ꞌbï na ka, Bɔkoꞌba ɔtɔ ɔdɔ dë zïyï’?” ");
INSERT INTO bex_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ŋere Bɔkoꞌba iya te, “Waꞌdi na ma kindaꞌba közïyï ne?” Bo iya te, “Përï na.” ");
INSERT INTO bex_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Bɔkoꞌba iya te, “Uꞌdu bërï.” Bo ogba kuꞌdu bërï kina kuyï rönï ŋgï rɔ murë na bo kiriŋa ŋgï yaga di teyi. ");
INSERT INTO bex_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Bɔkoꞌba iya te, “Oja közïyï kindaꞌba di dɔ giliti mo.” Kina bo koja közï bo ŋgï gɔmo kindaꞌba di dɔ giliti mo na kuyï rönï ŋgï kileki yaga rɔ përï közï bo. ");
INSERT INTO bex_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Bɔkoꞌba iya zi bo te, “Na ꞌdɔ kari koꞌdɔ te zïnnï gɔ kileme zïnnï ŋere Bɔkoꞌba ꞌba ꞌbu nnï löbu ga Abarayama ni ti Yisika ti Yakoba ɔdɔ ꞌdeni ŋgï kileme rönï zïyï.” ");
INSERT INTO bex_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Bɔkoꞌba iya ꞌböwu zi bo te, “Usu közïyï mï bɔŋgɔ ꞌbï.” Bo usu közï bo tine ɔdɔ bo kotɔ yaga dayi oꞌbeꞌbe ꞌdeni ŋgï me yaga rɔ mönyu ma kinza kiya. ");
INSERT INTO bex_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Bɔkoꞌba iya te, “Usu közïyï kileki mï bɔŋgɔ ꞌba röyï.” Bo usu tine ɔdɔ bo kotɔ yaga dayi a tönë kora gɔ közï bo ne olɔ ꞌdeni ŋgï pili yaga közï bo kileki gɔ bi mo kɔzɔ yida rɔ bo ma laki. ");
INSERT INTO bex_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Bɔkoꞌba iya zi Musa te, “Ɔdɔ kiya te lïjë kiꞌdi dönnï dë lïjë kutï dë pele gɔ, gɔ kotɔ ma dɔndende nima ma mï rïyö nime lïjë ti kiꞌdi dönnï gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ne ɔdɔ lïjë kiꞌdi dönnï dë gɔmo kpaki rïyö lïjë kuwö lende ꞌbï dë, ogba mini di mï yöpö nima yayi kodɔ bërï dɔ yayi ma këlë. Kina ti mini nima kuyï rönï ŋgï rɔ roma.” ");
INSERT INTO bex_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa ënyï kileki zi Bɔkoꞌba, iya te, “Yö, ŋere, ma mɔꞌbɔ dë tilende laka. Lende ma ndɔ. Kpama rɔ ma kilali. Mɔlo pele gba kinza kilende dë zö ŋbö kömö mï kada nima tɔne ma bɔ kpa kitigɔ ɔtɔ na dë.” ");
INSERT INTO bex_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Bɔkoꞌba iya zi bo te, “Yë na kiꞌdi kpa dɔ bilaka lesi? Kina yë na këdï kuꞌbë mbili bilaka ala kudödu kpamo teyi? Yë na kiꞌdi kɔmɔ dɔ bilaka lesi ala kïyölu yaga? Tara ne ma ŋere Bɔkoꞌba nime na dë? ");
INSERT INTO bex_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ari ti mokɔnyi yi tilende kina ti miyandi yi ti wa ma ꞌdɔ kiya.” ");
INSERT INTO bex_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tine Musa iya te, “Yö, ŋere, momaꞌjo rɔma zïyï oja rɔ bilaka mɔtɔ na ꞌdɔ kari toꞌdɔ wa nime.” ");
INSERT INTO bex_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Dökïꞌdï Bɔkoꞌba ënyï kata ŋgï rɔ Musa kiya te, “Ne bɔ löndö yï Arona kupö Lëwë mo nima tondo? Mikali bo rɔ bɔ kpa kikali lende. Bo ëdï ꞌdeni rɔ tako turë döyï, bo ti këdï ti dökïꞌdï këyï ɔdɔ bo koꞌja yi. ");
INSERT INTO bex_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ti kilende zi bo kiꞌdi lende kpa bo. Ti mokɔnyi ye kpaki rïyö tilende kina ti miyandi ye gbï ti wa ma ꞌdɔ koꞌdɔke. ");
INSERT INTO bex_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Bo na ti kilende zi bilaka naga nima tine ti këdï kɔzɔ nï na kilende kina ti këddï ꞌbëyï kɔzɔ Bɔkoꞌba tilende zi bo. ");
INSERT INTO bex_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ogba përï nime közïyï kari timo ꞌdɔ koto toꞌdɔ gɔ kotɔ nduwë timo.” ");
INSERT INTO bex_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kina Musa kënyï ŋgï kileki kari zi Yetoro bɔ lanzo bo kari kiya teyi te, “Iꞌdi mari toŋgɔ ya eꞌbe ze ga di Ezipeto, ɔdɔ lïjë ëdï ŋgï na ya.” Yetoro iya te, “Ari, kɔri ti köbö zïyï.” ");
INSERT INTO bex_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Tine Bɔkoꞌba iya ꞌdeni zi Musa di Midiyana yayi iya te, “Ënyï kileki kari Ezipeto. Bilaka tönë ga kiteri tupö yi ne lïjë ölë ꞌdeni pili.” ");
INSERT INTO bex_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kina Musa kogba ꞌja abo ni ŋgï ti kole abo ga kiꞌdi dɔ akaca lïjë kënyï dɔmo tari Ezipeto. Bo ogba përï ꞌba Bɔkoꞌba tönë közï bo. ");
INSERT INTO bex_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Bɔkoꞌba iya zi Musa te, “Ɔdɔ kileki ꞌdeni kömö Ezipeto gɔ kotɔ ame ga miꞌdi tigɔ mo ꞌdeni zïyï ne oꞌdɔ pili kɔmɔ bɔ dɔliŋɔ ꞌbënnï mo nima. Ne ti mogbɔ dökïꞌdï bo ꞌdɔ bo kota gɔ bilaka ma ga Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ari kiya zi bo te, ‘Yisarele na rɔ kole dɔndende ma ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Kina me mëdï miya zïyï, “Iꞌdi kole ma nime kari ꞌdɔ bo kari kumötu ma.” Ne nï ebe kota gɔ bo kina ti mupö kole dɔndende ma ꞌbëyï.’” ");
INSERT INTO bex_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Di bi ma Musa ni köꞌdö teyi di gɔ kɔri yayi na Bɔkoꞌba kalo ya ŋgï dɔ Musa koꞌdɔ tupö mo. ");
INSERT INTO bex_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tine na ꞌja abo Zipora kogba döku ma kapa ŋgï koke kpa ꞌbana ꞌba kole abo timo lɔko kogba kosa ndï Musa timo. Lɔko iya te, “Rɔ ma laka nï ŋgï rɔ mëꞌdë ꞌba roma zö.” ");
INSERT INTO bex_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Lɔko iya tara römöyï gɔ köꞌdu ꞌba dölëtï ꞌbënnï ꞌba akilele. Kina Bɔkoꞌba kola Musa ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ŋere Bɔkoꞌba iya ꞌdeni zi Arona te, “Ënyï kari yï mökö turë dɔ Musa.” Kina bo kënyï ŋgï dönnï kari kondɔsɔ ti Musa dɔ döku koro mo tönë na lïjë koloma ŋgï gbɔ rɔ tumötö rönnï ti tiramo rönnï. ");
INSERT INTO bex_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kina Musa kïyëtï gɔ wa ame ga pili Bɔkoꞌba kiya zi bo gɔ tileki abo Ezipeto ꞌdɔ bo kari kiya ne ŋgï pili zi Arona. Gɔ kotɔ ame ga gbï Bɔkoꞌba kose gɔmo ꞌdeni zi bo ꞌdɔ bo kari koꞌdɔ ne bo iya gɔmo gbï pili zi Arona. ");
INSERT INTO bex_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kina Musa ni ti Arona kari kotɔtɔ dɔ löbu ꞌba Yisarele ŋgï pili bërï. ");
INSERT INTO bex_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Kina Arona kora gɔ wa ame ga ŋere Bɔkoꞌba kose zi Musa ne ŋgï pili zïnnï. Kina bo koꞌdɔ gɔ kotɔ mo tönë ga ŋgï kɔmɔ lïjë Yisarele naga nima pili. ");
INSERT INTO bex_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Kina lïjë kiꞌdi dönnï ŋgï gɔmo. Kina ɔdɔ lïjë kuwö ꞌdeni Bɔkoꞌba ŋgï ti lende ꞌbënnï sowa koŋgɔ lisa ꞌbënnï ꞌdeni tara tine kina lïjë kolɔdɔ ŋgï bërï tïlëlu Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Di pötö mo ꞌdeni na Musa ni ti Arona kënyï ŋgï kari zi bɔ dɔliŋɔ ꞌba Ezipeto mo nima, kiya te, “Ame na rɔ lende ma ŋere Bɔkoꞌba ze ꞌba Yisarele kiya. ‘Ola bilaka ma naga nime kari ꞌdɔ lïjë koꞌdɔ karama zö di yï mökö.’” ");
INSERT INTO bex_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Bɔ dɔliŋɔ iya zïnnï te, “Ŋere Bɔkoꞌba mo bo rɔ yë gɔ muwö dɔ bo mola Yisarele kari? Mikali a mɔtɔ rɔ ŋere Bɔkoꞌba dë kina a mɔtɔ ŋgï rɔ Yisarele ꞌdɔ kombi ndïnnï di bine kari bitɔ inza.” ");
INSERT INTO bex_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa ni ti Arona ileki kiya te, “Bɔkoꞌba ze ꞌba Ebere ɔdɔ kileme rɔ bo ꞌdeni zize. Kina me ola ze ŋge dari rɔ liŋgere ꞌba töꞌdö dɔ mota mï mökö tumu roma zi bo ŋere Bɔkoꞌba ze kinza bo kote dɔze ti rɔkɔꞌɔ mɔtɔga ti ya.” ");
INSERT INTO bex_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Bɔ dɔliŋɔ ꞌba Ezipeto nima ileki zïnnï iya te, “Musa kpe ti Arona, oꞌdɔkɔke totɔ bilaka naga nime yaga di kpa ndɔbɔ ꞌbënnï ga gɔ waꞌdi? Kpe, ilekike mï ndɔbɔ ꞌbe ga. ");
INSERT INTO bex_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kpe nima kupö ye kara ꞌdeni ŋgï mï dɔyayi ꞌba Ezipeto nime kɔzɔ mɔli ne. Kina me kpe këddï kiterike ꞌböwu ꞌbiri gɔ lïjë kɔrɔ di mï ndɔbɔ.” ");
INSERT INTO bex_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mï kada kɔtɔ mo nima na bɔ dɔliŋɔ kiꞌdi köꞌdu mo ŋgï zi turu ꞌba gönnï ga ti makuŋgu mo ga, iya te, ");
INSERT INTO bex_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kinza kiꞌdike koꞌde wuyö dë kpe zïnnï toꞌba töꞌbu timo. Iꞌdike lïjë na kari koma wuyö ꞌbënnï ga zïnnï. ");
INSERT INTO bex_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Tine iꞌdike bɔ kɔtɔ koꞌba ko kɔzɔ ma mɔlo tönë lïjë koloma pa rɔ toꞌba mo koꞌja këdï koꞌde wuyö zïnnï bine ne tara, kɔmɔ mo kileke dë rɔ cologaki. Ndɔbɔ ɔꞌbɔ lïjë dë rɔ tɔꞌbɔ na ma lïjë këdï kititi ma tëgë gɔ miꞌdi lïjë kari tumu roma zi Bɔkoꞌba ꞌbënnï tɔ nima ne. ");
INSERT INTO bex_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Iꞌdike ndɔbɔ ma kinza kiya na zïnnï kinza lïjë kebe ra tiꞌdi dönnï gɔ bëtï goꞌdeꞌde mbëmbë tɔ naga nima.” ");
INSERT INTO bex_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kina turu ꞌba gönnï mo naga nima ti makuŋgu mo ga kari ŋgï kiya te, “Bɔ dɔliŋɔ iya te kinza diꞌdi koꞌde wuyö dë kpe ziye. ");
INSERT INTO bex_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kpe na ꞌdɔ kari komake eꞌbe di bi tɔ ame ga koꞌjake di teyi. Tine ndɔbɔ ꞌbe ŋburu kɔzɔ ma dɔgba kola dë rɔ cologaki.” ");
INSERT INTO bex_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kina Yisarele naga tönë kitaꞌba ga ŋgï kpaya kote mï dɔyayi ꞌba Ezipeto nima toma a ma ꞌdɔ koꞌdɔ rɔ wuyö. ");
INSERT INTO bex_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Turu ꞌba gönnï mo ga öꞌbö ŋgï ŋburu rɔ tembe dönnï gɔ lïjë koꞌba töꞌbu konzi mï kada kɔtɔ kɔzɔ ma tönë lïjë koloma pa rɔ toꞌdɔ mo koꞌja këdï koꞌde wuyö zïnnï rɔ toꞌde ne. ");
INSERT INTO bex_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Makuŋgu ꞌba dɔ ndɔbɔ ame ga kiꞌdi di mï Yisarele ne ote dë kömö kɔzɔ ma kiya rönï mo nima. Kina komba ya ga ŋgï rɔ ma kënyë kititi kpënnï, iya te, “Iꞌdike dë koꞌba töꞌbu tipiyara ene kina gbï tɔne kömö gɔ ma mɔlo gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Makuŋgu naga nima ënyï kari kititi bɔ dɔliŋɔ, iya te, “Oꞌdɔ ze atɔli ꞌbï ga kulöwö te gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bɔtɔ oꞌde wuyö dë gbï yɔ zize, ze na dëdï doma eze gɔ dɔze. Tine pele tara lïjë iteri tëgë gɔ doꞌba töꞌbu konzi kɔzɔ ma dɔgba tönë ga. Oŋgɔ lende nime te, këdï komba ze atɔli ꞌbï ga dëmba tine bilaka ꞌbï ga na dɔmo kele dë.” ");
INSERT INTO bex_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Bɔ dɔliŋɔ ënyï kiya zïnnï iya te, “Tïkëpï. A nima na tönë kako kititike ma bine tëgë gɔ miꞌdi ye karike tumu roma zi ŋere Bɔkoꞌba ꞌbe ne. ");
INSERT INTO bex_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Tïkëpï. Ilekike mï ndɔbɔ. Bɔtɔ koꞌde wuyö dë ziye. Ne a mɔtɔ rɔ kɔmɔ töꞌbu ma kɔtɔ kinza köꞌbö dë rɔ cologaki.” ");
INSERT INTO bex_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Makuŋgu ꞌba Yisarele naga nima ari koŋgɔ ŋgï te wa ënyë ꞌdeni ame kiteri ꞌdeni zïnnï di mï wuyö nime koꞌde dë pele zïnnï gɔ kɔmɔ töꞌbu ꞌba mï kada dɔ kɔtɔ mɔtɔ ame kose zïnnï ne köꞌbö dë rɔ cologaki ne. ");
INSERT INTO bex_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Kina ɔdɔ lïjë kɔdɔ ꞌdeni yaga di mï liŋɔ ꞌba bɔ dɔliŋɔ yayi tine lïjë oꞌja Musa ni ti Arona ŋgï yayi këdï rɔ toda lïjë. ");
INSERT INTO bex_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Na lïjë kiya zi Musa ni te, “Kpe, lende ꞌbe nima ŋere Bɔkoꞌba oꞌja ꞌdeni. Bo ti kodɔ karama mo ꞌbasi dɔye. Ososoke bɔ dɔliŋɔ ni ti turu abo ga ꞌdeni ŋgï koꞌji ze leꞌjete kɔzɔ ɔtɔ këdï kupö ze ꞌdeni yaga nati.” ");
INSERT INTO bex_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa ënyï kileki zi ŋere Bɔkoꞌba, iya te, “Yö ŋere, oꞌde gomɔ kulöwö dɔ bilaka naga nime te gɔ waꞌdi? Ne oja ma ka le mako gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Mɔlo tönë gɔ mari milende zi bɔ dɔliŋɔ ti möyï yï ne kina me bo këdï kodɔ gomɔ ꞌdeni ŋgï rɔ ma kënyë rɔ bilaka ꞌbï ga. Ne nï ꞌdɔ kokɔnyi lïjë bilaka ꞌbï ga tɔ yɔ ne inza yɔ.” ");
INSERT INTO bex_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ŋere Bɔkoꞌba ënyï kileki kilende zi Musa iya te, “Ti koŋgɔ wa ma mëdï moꞌdɔ zi bɔ dɔliŋɔ ꞌba Ezipeto nima ꞌdeni. Ti tigɔ ma bo ti kope közï bo di gönnï ꞌdɔ lïjë kari. Ti tigɔ ma bo ti koga lïjë yaga di mï dɔyayi abo nima.” ");
INSERT INTO bex_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Bɔkoꞌba ënyï ꞌböwu gbï kiya zi Musa te, “Ma na rɔ ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mɔdɔ ꞌdeni tönë ga bine mileme rɔma zi Abarayama zi Yisika zi Yakoba rɔ Bɔkoꞌba tigɔ dɔ kiteli. Ne mï kada naga nima yayi mileme rɔma dë zïnnï ti möyï koro ma nime kïdëkï rɔ ‘Ma na rɔ bɔ ame rɔ ma mo ne.’ ");
INSERT INTO bex_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Moꞌdɔ lömu ma ꞌdeni gbï tïnnï gɔ miꞌdi dɔyayi ꞌba Kanana zïnnï ame lïjë këdï koloma teyi kɔzɔ bɔ löwö ne. ");
INSERT INTO bex_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kina me gbï tine tileri ꞌba Yisarele di kpa közï gomɔ ꞌba Ezipeto ömö ꞌdeni mbili ma. Kina ma momeri gɔ lömu ma tönë ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ne oŋgɔ, ari kiya zïnnï Yisarele te, ‘Ma na rɔ ŋere Bɔkoꞌba ꞌbe ti moja ye yaga di mï akïrïndï nima Ezipeto këdï kïdïrï ye timo ne. Ti mope ye yaga rɔ dɔ ŋgölö di mï atɔli nima këddïke yïmo zïnnï ne. Ti moja közö ti tigɔ ma modɔ karama ma kinza kiya dönnï mɔmɔ ye timo yaga. ");
INSERT INTO bex_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ti mogba ye rɔ ꞌbama ga moloma rɔ Bɔkoꞌba ꞌbe. Kina ti kikalike ma ŋgï ma na rɔ ŋere Bɔkoꞌba ꞌbe ame koꞌde ye yaga di mï akïrïndï ꞌba Ezipeto ame lïjë koloma rɔ tïdïrï ye timo ne. ");
INSERT INTO bex_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ti moꞌde ye mï yayi ma tönë mombi közö tɔrɔ mulömu ꞌdeni lipo tiꞌdi mo zi Abarayama zi Yisika zi Yakoba ne. Ti miꞌdi ziye rɔ eꞌbe. Ma na rɔ ŋere Bɔkoꞌba.’” ");
INSERT INTO bex_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa ari kora gɔ wa naga nime pili zi Yisarele tine lïjë uwö dɔ bo dë kpe römöyï dökïꞌdï nnï idaki ꞌdeni ŋgï di zi közï kënyë ame Ezipeto këdï koꞌdɔ rönnï ne. ");
INSERT INTO bex_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Bɔkoꞌba iya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ari kiya zi bɔ dɔliŋɔ nima ꞌdɔ bo kiꞌdi Yisarele kënyï yaga di mï dɔliŋɔ abo.” ");
INSERT INTO bex_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Tine Musa ileki kiya zi Bɔkoꞌba, iya te, “Yisarele mo ga na me ꞌdeni bine kuwö dɔma dë, tine bɔ dɔliŋɔ na ti kari kuwö ꞌba bo lende ma totondo koꞌja mëdï milende rɔ kpa kilali?” ");
INSERT INTO bex_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Bɔkoꞌba ose ꞌdeni zi Musa ni ti Arona te, “Ari kiyake zi Yisarele ti bɔ dɔliŋɔ ꞌba Ezipeto nima te ma na mose ziye ꞌdɔ kojake Yisarele yaga di mï dɔyayi ꞌba Ezipeto.” ");
INSERT INTO bex_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Kpa gɔli ꞌbënnï mo ga na me. Rubënï kole dɔndende ꞌba Yisarele ëdï ti kole bɔtɔni sowɔ, Anoka, Palo, Ezerona kina ti Karomi. Lïjë na rɔ kpa gɔli ꞌba eꞌbe Rubënï ga. ");
INSERT INTO bex_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simona ëdï ti kole bɔtɔni modɔɔkɔtɔ, Yemowele, Yamina, Oda, Yakina, Zowara kina ti Sawola ame yïtö ꞌba Kanana na köyö ne. Lïjë na rɔ kpa gɔli ꞌba eꞌbe Simona ga. ");
INSERT INTO bex_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lëwë ëdï ti kole bɔtɔni mota, Gerosona, Kowata kina ti Merari. Lïjë na rɔ kpa gɔli ꞌba eꞌbe Lëwë ga. Kɔmɔ kɔɔ ꞌba loma ꞌba Lëwë pili kuluku rïyö kɔdɔ dɔmo ꞌbutë mota döömu dɔmorïyö (137). ");
INSERT INTO bex_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerosona ëdï ti kole bɔtɔni rïyö, Libini ni ti Simi, lïjë gbï ti kpa gɔli ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kowata ëdï ti kole bɔtɔni sowɔ ꞌdo, Amarama, Yisara, Eborona kina ti Uzïyëlë. Kɔmɔ kɔɔ ꞌba loma ꞌba Kowata pili kuluku rïyö kɔdɔ dɔmo ꞌbutë mota dɔɔmota (133). ");
INSERT INTO bex_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari ëdï ti kole bɔtɔni rïyö, Mali ni ti Musï. Lïjë ya naga nime na rɔ kpa gɔli ꞌba eꞌbe Lëwë ga kari nduwë rɔ yï roba ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amarama ari kogbe Yɔkobede lëmï ꞌba ꞌbu nnï ni kina ma ꞌdɔ köyö Arona ni ti Musa ne. Kɔmɔ kɔɔ ꞌba loma ꞌba Amarama pili kuluku rïyö kɔdɔ dɔmo ꞌbutë mota döömu dɔmorïyö (137). ");
INSERT INTO bex_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yisara ëdï ti kole bɔtɔni mota, Kora, Nepege kina ti Zikiri. ");
INSERT INTO bex_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzïyëlë ëdï ti kole bɔtɔni mota, Misale, Elisapana kina ti Siteri. ");
INSERT INTO bex_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arona ari kogbe Eliseba nyiti ꞌba Aminadaba lëmï ꞌba Nasona ni. Lɔko na köyö Nadaba ni ti Abïwu ti Elizara gbï ti Itomara. ");
INSERT INTO bex_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora ëdï ti kole bɔtɔni mota, Asira, Elikana ni ti Abisapa. Lïjë na rɔ kpa gɔli ꞌba eꞌbe Kora ga. ");
INSERT INTO bex_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elizara kole ꞌba Arona ari kogbe nyiti ꞌba Pitiyele ma kɔtɔ mɔtɔ kina ma ꞌdɔ köyö Pinasa ne. Kupö eꞌbe Lëwë naga nima ꞌbu nnï löbu mo ga na kiyija rönï kɔzɔ a nime te, mɔtɔ nï ti kpa gɔli ꞌbï. ");
INSERT INTO bex_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Arona ni lïjë ti Musa kɔtɔ nime na me ꞌdɔ Bɔkoꞌba kiya zïnnï te, “Oja dɔ kupö Yisarele yaga di mï dɔyayi ꞌba Ezipeto ne.” ");
INSERT INTO bex_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Arona ni lïjë ti Musa kɔtɔ mo nime lïjë na tönë kari kiya lende ꞌba toja Yisarele yaga di mï dɔyayi ꞌba Ezipeto zi bɔ dɔliŋɔ mo ne. ");
INSERT INTO bex_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mï kada nima ŋere Bɔkoꞌba kilende zi Musa di Ezipeto ne, iya te, ");
INSERT INTO bex_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Ma na rɔ ŋere Bɔkoꞌba. Ïyëtï wa ame ga miya zïyï ne pili zi bɔ dɔliŋɔ ꞌba Ezipeto nima.” ");
INSERT INTO bex_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Tine Musa ënyï kileki kiya te, “Koꞌja mëdï milende rɔ kpa kilali nime bɔ dɔliŋɔ mo ti kuwö dɔmo totondo mo ga?” ");
INSERT INTO bex_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ŋere Bɔkoꞌba ilende zi Musa iya te, “Oŋgɔ, moꞌdɔ yi ꞌdeni kɔzɔ Bɔkoꞌba tara zi bɔ dɔliŋɔ. Kina Arona bɔ löndö yï na ti këdï kɔzɔ bɔ kumë lende tara tilende zi bo. ");
INSERT INTO bex_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ïyëtï gɔ wa ame ga mose zïyï ne pili zi Arona ꞌdɔ bo kari kiya zi bɔ dɔliŋɔ ꞌdɔ kiꞌdi Yisarele kɔdɔ yaga di mï dɔyayi abo nima. ");
INSERT INTO bex_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tine ti miꞌdi dökïꞌdï bɔ dɔliŋɔ këddï. Gɔ kotɔ mbëmbë naga nime ɔdɔ moꞌdɔ pele, ");
INSERT INTO bex_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","bo inza konyɔ lende mo bo kutï gɔ lende ꞌbï. Kina ti mutuꞌbö közö dɔ Ezipeto ti tigɔ ma moja bilaka ma ga Yisarele yaga rɔ dɔtumu mï kpa gɔli mo ga di mï dɔyayi ꞌbënnï nima. ");
INSERT INTO bex_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kina ti lïjë Ezipeto kikali ŋgï ma na rɔ ŋere Bɔkoꞌba gɔ ame mileme kpa közö ꞌdeni zïnnï moja bilaka ma ga Yisarele yaga di mï dɔyayi ꞌbënnï nime ne.” ");
INSERT INTO bex_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa ni ti Arona ari koꞌdɔ kɔzɔ ma Bɔkoꞌba kose gɔmo zïnnï tara. ");
INSERT INTO bex_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mï kada naga nima lïjë këdï kilende zi bɔ dɔliŋɔ ne, kɔmɔ kɔɔ ꞌba Musa ëdï ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë mota, ꞌba Arona ꞌdeni kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë mota dɔɔmota. ");
INSERT INTO bex_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Bɔkoꞌba iya zi Musa ni ti Arona te, ");
INSERT INTO bex_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ɔdɔ bɔ dɔliŋɔ kiya ziye te, ‘Oꞌdɔke gɔ kotɔ te,’ iya zi Arona kogba përï abo kuꞌdu bërï kɔmɔ bɔ dɔliŋɔ. Kina ti kuyï rönï ŋgï rɔ murë.” ");
INSERT INTO bex_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kina Musa ni ti Arona kari koꞌdɔ ŋgï kɔzɔ ma Bɔkoꞌba kose zïnnï. Arona ogba përï abo kuꞌdu bërï kɔmɔ bɔ dɔliŋɔ ni lïjë ti turu abo ga kina përï nima kuyï rönï ŋgï rɔ murë. ");
INSERT INTO bex_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Bɔ dɔliŋɔ iꞌdi kotɔtɔ bɔ kata ꞌba mï dɔyayi ꞌba Ezipeto yayi koꞌde kako kina lïjë koꞌdɔ ŋgï gbï kɔzɔ ꞌba Arona tara ti dɔŋgala ma ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Lïjë uꞌdu përï ma ꞌbënnï ga bërï na kuyï rönï ŋgï gbï rɔ murë. Tine përï ma ꞌba Arona tönë ënyï kindiyɔ ma ꞌbënnï naga nima ŋgï pili yaga. ");
INSERT INTO bex_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pele tara, dökïꞌdï bɔ dɔliŋɔ ëddï ŋgï bo kuwö lende ꞌbënnï dë kɔzɔ köꞌdu tönë Bɔkoꞌba kiya mɔlo zi Musa ne tara. ");
INSERT INTO bex_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Bɔkoꞌba iya zi Musa te, “Bɔ dɔliŋɔ dökïꞌdï mo ëddï kulöwö bo oꞌdɔkɔ dë tope közï bo di gɔ Yisarele ꞌdɔ kari. ");
INSERT INTO bex_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ënyï ŋbɔ kurë dɔ bo kɔri mini. Ari koda bo kpa yöpö yayi. Ogba përï kuyï rönï rɔ murë tönë tïyï. ");
INSERT INTO bex_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kina ꞌdɔ kiya zi bo te, ‘Ŋere Bɔkoꞌba ꞌba Yisarele na me koja ma tiya mo zïyï te, “Ola bilaka ma ga kari ꞌdɔ lïjë kari kumötu ma di yï mökö. Ne mɔlo nime nï, uwö dɔmo dë yɔ.”’ ");
INSERT INTO bex_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ne nï, ŋere Bɔkoꞌba iya te ti kikali bo ꞌdeni ŋgï rɔ ŋere Bɔkoꞌba mo gɔ wa ma bo këdï koꞌdɔ zïyï. Kina me oŋgɔ mëdï momba dɔ mini ti përï nime. Ti mini pili ꞌba mï yöpö nime kuyï rönï yaga rɔ roma. ");
INSERT INTO bex_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ti kenze ni kölë, mini kato, Ezipeto inza kɔꞌbɔ kpe tuwë mini ꞌba yöpö nime.” ");
INSERT INTO bex_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Bɔkoꞌba iya zi Musa te, “Ilende zi Arona bo kombi përï nima tɔrɔ dɔ yöpö kpaki ti gbögbö mo ga ti putï ni rɔ gɔ mini ame ga pili mï dɔyayi ꞌba Ezipeto ne. Kina ti mini kuyï rönï me rɔ roma ma mï ꞌbɔrɔ kpaki ti ma mï bi ŋgaŋi ꞌba döku.” ");
INSERT INTO bex_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa ni ti Arona ari koꞌdɔ ŋgï kɔzɔ ma Bɔkoꞌba kose zïnnï. Arona ombi përï tönë tɔrɔ komba dɔ mini ꞌba mï yöpö nima timo di kɔmɔ bɔ dɔliŋɔ ni ti turu abo ga te kina mini kuyï rönï ŋgï rɔ roma. ");
INSERT INTO bex_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kenze ꞌba mï yöpö kölë ŋgï pili mini kato kënyë bɔtɔ kɔꞌbɔ dë kpe tuwë mo. Roma ŋgï kote gɔ bi pili mï dɔyayi ꞌba Ezipeto yayi. ");
INSERT INTO bex_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Tine bɔ kata ꞌba Ezipeto yayi ako koꞌdɔ gbï tara ti dɔŋgala ma ꞌbënnï ga. Kina dökïꞌdï bɔ dɔliŋɔ köꞌbö ŋgï rɔ ma këddï. Bo uwö lende ꞌba Musa ni ti Arona dë kpe nati kɔzɔ ma tönë Bɔkoꞌba kiya ꞌdeni mɔlo zi Musa ne tara. ");
INSERT INTO bex_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Bo ënyï abo za kusë kileki kari liŋɔ abo bo konyɔ lende mo dë. ");
INSERT INTO bex_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Kina Ezipeto kebe ŋgï rɔ tiyagba mini di mï yayi lida römöyï mini ꞌba yöpö ele dë kpe. ");
INSERT INTO bex_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kina ɔdɔ töꞌdö mo kiteli ꞌdeni dɔ modɔmorïyö di pötö a löbu nime Bɔkoꞌba koꞌdɔ mï yöpö nima ne tine, ");
INSERT INTO bex_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","na Bɔkoꞌba kënyï kilende zi Musa iya te, “Ari zi bɔ dɔliŋɔ kiya zi bo te, ‘Ŋere Bɔkoꞌba iya te, “Ola bilaka ma ga kari ꞌdɔ lïjë kumötu ma. ");
INSERT INTO bex_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ɔdɔ kilagi mëdï modɔ karama dɔ dɔliŋɔ ꞌbï nime pili ti nyɔꞌdɔ koso lɔ yïmo. ");
INSERT INTO bex_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nyɔꞌdɔ ti koso lɔ mï yöpö kpaki kebe mï liŋɔ ꞌbï pili kebe rö ꞌbï kebe dɔ a töꞌdö ꞌbï ga kote mï liŋɔ ꞌba turu ꞌbï naga nima rɔ gɔ bilaka ꞌbï ga pili kpaki kebe mï akirisi wa ꞌba ꞌja ꞌbï kebe mï sele ni kpaki. ");
INSERT INTO bex_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Lïjë ti köꞌbö töpu röyï rɔ bilaka ꞌbï ga ti turu ꞌbï ga pili.”’” ");
INSERT INTO bex_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kina Bɔkoꞌba kilende zi Musa iya te, “Iya zi Arona kombi përï abo tɔrɔ dɔ yöpö ni ti gbögbö ti putï mo ga pili koja nyɔꞌdɔ mï dɔyayi ꞌba Ezipeto.” ");
INSERT INTO bex_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kina Arona koja kɔnyɔ bo ŋgï kombi tɔrɔ dɔ mini pili ꞌba mï Ezipeto. Kina nyɔꞌdɔ ŋgï setiyi kote mï dɔyayi nima. ");
INSERT INTO bex_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tine bɔ kata ni ako gbï koꞌdɔ dɔŋgala ma ꞌbënnï ga lïjë koja nyɔꞌdɔ gbï tara. ");
INSERT INTO bex_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Bɔ dɔliŋɔ ïdëkï Musa ni ti Arona kilende teyi, iya te, “Ilendeke zi ŋere Bɔkoꞌba kogba nyɔꞌdɔ naga nime yaga di rɔma ti bilaka ma ga. Kina ti mola bilaka ꞌbe ga ŋgï kari tumu roma zi bo Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa ileki zi bɔ dɔliŋɔ, iya te, “Ma ti mï këyï ꞌdɔ tititi Bɔkoꞌba gɔ lende ꞌbï gbï ti turu ꞌbï ga kpaki ti bilaka ꞌbï ga. Tine kada mo na koza zö. Nyɔꞌdɔ naga nima ti kölu ŋgï pili liwo yaga kola ŋge rɔ ma mï yöpö.” ");
INSERT INTO bex_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Bɔ dɔliŋɔ ileki dɔmo, iya te, “Ilende zi Bɔkoꞌba tïlëndö.” Musa iya te, “Ti moꞌdɔ ŋgï tara kɔzɔ ame kititi ne kina nï ti kikali ŋgï rɔ ma laka Bɔkoꞌba ꞌberi mɔtɔ inza kɔzɔ ŋere Bɔkoꞌba ze ꞌba Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Nï, kpe ti turu ꞌbï ga ti bilaka ꞌbï ga pili inza koꞌjake kïnë a mɔtɔ rɔ nyɔꞌdɔ kpe ŋgila ye, tine ŋge rɔ ame ga mɔlo mï yöpö ne.” ");
INSERT INTO bex_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kina Musa ni ti Arona kënyï ŋgï di yayi. Tine na Musa kari kilende ŋgï zi Bɔkoꞌba ꞌdɔ kona nyɔꞌdɔ tönë ga bo koꞌde dɔ bɔ dɔliŋɔ ne yaga. ");
INSERT INTO bex_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Kina Bɔkoꞌba koꞌdɔ ŋgï kɔzɔ ame Musa kititi ne tara. Nyɔꞌdɔ tönë ga ma kebe rö ti ma kpa liŋɔ ni ti ma mï nyaka naga ölë ŋgï me yaga. ");
INSERT INTO bex_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kina bilaka koloma ŋgï rɔ tulu dɔmo kɔzɔ kurugumu tara kato kogba mï dɔyayi. ");
INSERT INTO bex_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tine ɔdɔ bɔ dɔliŋɔ koŋgɔ nyɔꞌdɔ tönë ga kölë ꞌdeni tara tine dökïꞌdï bo ileki këddï ŋgï ꞌböwu yaga kɔzɔ lende tönë Bɔkoꞌba kiya mɔlo zi Musa ne tara. ");
INSERT INTO bex_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ŋere Bɔkoꞌba iya zi Musa te, “Iya zi Arona kombi përï abo tɔrɔ komba lupu timo. Kina lupu ꞌba mï dɔyayi ꞌba Ezipeto nime pili ti kuyï rönï ŋgï rɔ duru gɔ banya.” ");
INSERT INTO bex_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Musa ni ti Arona oꞌdɔ kɔzɔ a nime te. Arona ombi közï bo tɔrɔ komba lupu ti përï kina duru gɔ banya kɔdɔ ŋgï setiyi tonyo bilaka kpaki ti yërï mo ga. Lupu ꞌba mï dɔyayi ꞌba Ezipeto nima pili ënyï kuyï rönï ŋgï yaga rɔ duru gɔ banya. ");
INSERT INTO bex_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Tine ɔdɔ bɔ kata ni kako gbï kiyɔzɔ toꞌdɔ mo ti dɔŋgala ma ꞌbënnï ga tine pele lïjë ɔꞌbɔ dë. Kina duru gɔ banya koloma ŋgï rɔ tonyo bilaka kpaki ti yërï mo ga. ");
INSERT INTO bex_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Bɔ kata naga nima ileki kiya zi bɔ dɔliŋɔ te, “Akoꞌdɔ ꞌba Bɔkoꞌba na.” Tine bɔ dɔliŋɔ dökïꞌdï mo ëddï ŋgï kuwö dɔ Musa ni dë kɔzɔ lende tönë Bɔkoꞌba kiya mɔlo zi Musa ne tara. ");
INSERT INTO bex_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kina Bɔkoꞌba kënyï kilende zi Musa, iya te, “Ënyï mɔlo mï dɔŋbɔ kurë dɔ bɔ dɔliŋɔ kɔri mini kiya zi bo te, ‘Bɔkoꞌba iya te, “Ola bilaka ma ga kari ꞌdɔ lïjë kumötu ma. ");
INSERT INTO bex_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ɔdɔ kope közïyï dë di gönnï kola lïjë kari mëdï moja kɔŋɔ döyï nï kpe ti turu ꞌbï naga nima ti bilaka ꞌbï ga pili. Mï liŋɔ ꞌbe ga ꞌba Ezipeto ti koso lɔ rɔ kɔŋɔ meꞌde kote dɔyayi. ");
INSERT INTO bex_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Tine minza miꞌdi lïjë kömö Gosene gɔ bi ꞌba bilaka ma ga Yisarele ꞌdɔ kikali ŋgï omba ma ŋere Bɔkoꞌba mëdï ŋgï mï dɔyayi nime. ");
INSERT INTO bex_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ti moꞌdɔ geli löŋgö ye ti bilaka ma ga. Kɔŋɔ nime miya ne ëdï kodowe bi tïlëndö.”’” ");
INSERT INTO bex_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kina Bɔkoꞌba koja sëyï ꞌba kɔŋɔ ma kinza kiya ŋgï mï dɔyayi ꞌba Ezipeto koso kebe mï liŋɔ ꞌba bɔ dɔliŋɔ mo ti ꞌba turu abo ga kɔŋɔ kirasi mï dɔyayi nima ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Kina bɔ dɔliŋɔ kïdëkï Musa ni ti Arona ŋgï kilende teyi, iya te, “Ari kumuke roma zi Bɔkoꞌba ꞌbe tɔ nima mï dɔyayi ꞌba Ezipeto bine.” ");
INSERT INTO bex_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Tine Musa ileki zi bo, iya te, “Tara inza kako römöyï yërï ame dëdï dumu rɔ roma zi Bɔkoꞌba ze ne inza koꞌdɔ dökïꞌdï bilaka ꞌbï ga ꞌba Ezipeto laka. Ɔdɔ lïjë kari koꞌja ze dëdï toꞌdɔ wa ame koꞌdɔ dökïꞌdï nnï dë laka kɔzɔ a nime te mɔtɔga lïjë ti kuꞌdu ze gɔmo ti döku kupö ze yaga. ");
INSERT INTO bex_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Toꞌdɔ mo oꞌdɔkɔ gɔ dari ŋbö mï zana mökö rɔ liŋgere ꞌba kada dɔ mota na gɔ dari dumu roma zi ŋere Bɔkoꞌba ze di yayi kɔzɔ ame mo bo kose zize ne tara.” ");
INSERT INTO bex_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Bɔ dɔliŋɔ iya te, “Ti miꞌdi ye karike tumu roma zi Bɔkoꞌba ꞌbe nima yï mökö yayi. Tine kinza karike dë kɔwɔ. Kina ititi Bɔkoꞌba ti gɔma.” ");
INSERT INTO bex_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa iya te, “Tari ma di bine na ti mititi ŋere Bɔkoꞌba göyï ꞌdɔ kɔŋɔ kitaꞌba yaga tïlëndö di röyï gbï di rɔ turu ꞌbï ga ti bilaka ꞌbï ga pili. Tine kinza kebe kïndëndë dɔze dë kpe gbï rɔ tïndëndë kebe ꞌböwu kota gɔ bilaka ze ga di bi tari tumu roma zi ŋere Bɔkoꞌba ze.” ");
INSERT INTO bex_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Kina Musa kënyï ŋgï di yayi kari kititi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Kina Bɔkoꞌba koꞌdɔ ŋgï zi bo kɔzɔ a ma bo kititi. Kɔŋɔ tönë ga itaꞌba ŋgï di rɔ bɔ dɔliŋɔ ni ti turu abo ga ti bilaka abo ga pili. Kïnë kɔŋɔ ma gɔkɔ ꞌdɔ koꞌja te, ari kinza kpe. ");
INSERT INTO bex_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Tine bɔ dɔliŋɔ ebe kogbɔ dökïꞌdï bo ꞌböwu gbï kebe kilagi tola ya naga nima kari. ");
INSERT INTO bex_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kina Bɔkoꞌba kilende zi Musa iya te, “Ari kilende zi bɔ dɔliŋɔ, iya te, ‘Ŋere Bɔkoꞌba ꞌba Ebere iya te, “Ola bilaka ma ga kari gɔ lïjë kumötu ma. ");
INSERT INTO bex_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ɔdɔ köꞌbö nduwë tota gönnï kope közïyï dë di gönnï, ");
INSERT INTO bex_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ti tigɔ ma ꞌba Bɔkoꞌba ti moꞌde rɔkɔꞌɔ ame ŋgï rɔ sëyï ma kinza kiya ne dɔ yërï ꞌba mï dɔyayi ꞌbï nime. Rɔkɔꞌɔ nima ti kilaꞌba dɔ kosani ꞌbe ga ti akaca ꞌbe ga ti gamele ti sa ti kamölö gbï ti banya ꞌbe ga. ");
INSERT INTO bex_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ti moꞌdɔ geli mï löŋgö yërï ma ꞌba Yisarele ti ma ꞌbeye ꞌba Ezipeto. Yërï ꞌba Yisarele ma kɔtɔ mɔtɔ te inza kölë. ");
INSERT INTO bex_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ma ŋere Bɔkoꞌba miꞌdi kada mo ꞌdeni ꞌdɔ kisaki rönï di mï tïlëndö.”’” ");
INSERT INTO bex_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kina mï bi këzë mo nima yɔ na Bɔkoꞌba koꞌdɔ ŋgï ko tara. Yërï ꞌba Ezipeto pili ölë tine ꞌba Yisarele ma kɔtɔ te ölë dë. ");
INSERT INTO bex_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Bɔ dɔliŋɔ oja bilaka kari liŋɔ ꞌba Yisarele toŋgɔ lende nima, tine lïjë ari koꞌja yërï ꞌba Yisarele ma kɔtɔ te kölë dë. Pele tara dökïꞌdï bɔ dɔliŋɔ oꞌdɔ dë gbï yɔ ma kpiti bo kola ya naga nima kari. ");
INSERT INTO bex_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kina Bɔkoꞌba kilende zi Musa ni ti Arona iya te, “Unzöke kötu ma këdï kululu rönï kumu rö naga lɔ közïye ꞌdɔ Musa kulï tɔrɔ mï lili di kɔmɔ bɔ dɔliŋɔ te. ");
INSERT INTO bex_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ti kanyo kɔzɔ lupu tara kote mï dɔyayi ꞌba Ezipeto. Kina ti kuyï rönï ŋgï rɔ kurëkurë ame ꞌböŋö mo kunyölö kɔzɔ ɔtɔ ne rɔ bilaka lesi kpaki ti yërï mo ga.” ");
INSERT INTO bex_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kina lïjë kunzö buruku ŋgï di kɔmɔ paꞌdo lïjë kɔrɔ timo kɔmɔ bɔ dɔliŋɔ. Musa ulï tɔrɔ mï lili kina kurëkurë kebe ŋgï toꞌbe bilaka lesi kpaki ti yërï mo ga. ");
INSERT INTO bex_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bɔ kata mo ga tönë ömö dë kpe nati kɔmɔ Musa römöyï kurëkurë naga nima koꞌbe bilaka ꞌba Ezipeto pili ne oꞌbe lïjë ꞌdeni gbï. ");
INSERT INTO bex_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Tine Bɔkoꞌba ogbɔ dökïꞌdï bɔ dɔliŋɔ kuwö dɔ Musa ni dë kɔzɔ a tönë Bɔkoꞌba kiya ꞌdeni zi Musa ne tara. ");
INSERT INTO bex_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kina Bɔkoꞌba kilende zi Musa iya te, “Ënyï mɔlo ŋbɔ kurë dɔ bɔ dɔliŋɔ ꞌdɔ kiya zi bo te, ‘Lende ma ŋere Bɔkoꞌba ꞌba Ebere kiya na kɔzɔ a nime te, “Nï, ola bilaka ma ga kari gɔ lïjë kumötu ma. ");
INSERT INTO bex_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Dëne ame mo tine ti modɔ karama ma kïrïndï döyï gbï dɔ turu ꞌbï naga nima rɔ gɔ bilaka ꞌbï ga pili ti tigɔ ma ꞌdɔ kikali ŋgï rɔ ma laka bɔtɔ ma kɔzɔ ma te inza mï dɔliŋɔ nime. ");
INSERT INTO bex_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Dëne ma mëdï mombi közö ra mokɔsɔ ye kpe ti bilaka ꞌbï naga nima ti rɔkɔꞌɔ ma kinza kiya naga mona ye ꞌdeni ꞌdoyi yaga di mï dɔliŋɔ nime. ");
INSERT INTO bex_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ne mogbɔ yi ꞌdeni tötï gɔ mileme tigɔ ma zïyï ꞌdɔ möyï ma kïlëbï kote mï dɔyayi nime. ");
INSERT INTO bex_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ne nï ëddï kogbɔ röyï gba dɔ bilaka ma ga koꞌdɔkɔ dë tola lïjë kari. ");
INSERT INTO bex_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tïlëndö ŋgï kabate ti moja ꞌdëꞌdï ti pïwu ma kinza kiya ame koꞌdɔ rönï dë mɔlo mï dɔyayi ꞌba Ezipeto nime di bi tisaki mo ne. ");
INSERT INTO bex_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Iya ꞌdɔ koꞌde yërï ame ga yaga mï löwu ne ti wa pili ma yaga naga kako rö. Römöyï ꞌdëꞌdï nime ëdï koꞌbe bilaka kpaki ti wa ame ga pili kola yaga ne kölë ꞌdoyi.”’” ");
INSERT INTO bex_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Turu ꞌba bɔ dɔliŋɔ mo nima mɔtɔ ga ma rɔ ma koro lende ꞌba Bɔkoꞌba naga ari ŋgï welo koꞌde yërï ti atɔli ꞌbënnï ga ame ga këdï yaga ne kako rö. ");
INSERT INTO bex_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Tine ya ma kudölï lende ꞌba Bɔkoꞌba naga ola wa ma ꞌbënnï ga ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kina Bɔkoꞌba kiya zi Musa te, “Oja közïyï kari mïtɔrɔ ꞌdɔ ꞌdëꞌdï kaꞌdi te mï dɔyayi ꞌba Ezipeto nime dɔ bilaka lesi mo ga kpaki ti yërï mo ga ti a ꞌba mï nyaka ni.” ");
INSERT INTO bex_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Kina ɔdɔ Musa kombi përï tönë koja tɔrɔ tine, na Bɔkoꞌba koja tɔrɔ këbï ŋgï ti ꞌdëꞌdï tɔrɔ kunyï kapi koꞌbe mï yayi. ");
INSERT INTO bex_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ŋere Bɔkoꞌba oja pïwu ma kinza kiya ŋgï ti ꞌdëꞌdï ti tɔrɔ kapi kunyï kilaka kote bi toko. Ame na rɔ pïwu ma kinza kiya ma koꞌdɔ rönï mï dɔyayi ꞌba Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Kote mï dɔyayi ꞌba Ezipeto pili ꞌdëꞌdï nima oꞌbe wa ame ga kola yaga ne ŋgï ꞌdoyi, bilaka lesi kpaki ti yërï mo ga. Omba nyönyu ꞌdoyi bërï di mï nyaka kurö ŋgërï me. ");
INSERT INTO bex_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosene ame Yisarele këdï koloma teyi ne na ŋge kɔtɔ pïwu löbu nima kömö dë teyi. ");
INSERT INTO bex_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kina bɔ dɔliŋɔ mo tönë koja laja gɔ Musa ni ti Arona, iya te, “Ame mo tine ma na moꞌdɔ lende kënyë ꞌdeni. Lende ꞌba Bɔkoꞌba na rɔ ma laka. Ma mo gbï ze ti bilaka ma ga dölu lende ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ititi Bɔkoꞌba gɔze. Tɔrɔ kapi ti ꞌdëꞌdï löbu nime ɔꞌbɔ ze ꞌdeni. Miya ꞌdeni ŋgï mëdï miꞌdi ye karike. Olomake dë kpe bine.” ");
INSERT INTO bex_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa iya te, “Ɔdɔ mëdï mɔdɔ ꞌdeni yaga kpa reki tine ti mombi közö ꞌjaa milende zi Bɔkoꞌba. Kina ti tɔrɔ kapi nima ti ꞌdëꞌdï mo kɔrɔ ŋgï ꞌdɔ nï kikali ŋgï dɔliŋɔ nime a ꞌba Bɔkoꞌba na. ");
INSERT INTO bex_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ne rɔ ma laka mikali ŋgï nï kpe ti turu ꞌbï ga ereke ŋere Bɔkoꞌba dë gba.” ");
INSERT INTO bex_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Kirilewo ni ti mana ꞌdëꞌdï nima irasi ŋgï mï kɔtɔ yaga. Römöyï ota mana köyö ꞌdeni tine kirilewo kumöru ꞌbënï ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Tine tala ni ti dërï na kɔmɔ römöyï lïjë ëdï ꞌbënnï gba kïyöbu. ");
INSERT INTO bex_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa ënyï di mï liŋɔ ꞌba bɔ dɔliŋɔ yayi bo kɔdɔ ꞌdeni yaga kpa reki na bo kombi közï bo ŋgï tɔrɔ kititi Bɔkoꞌba. Kina tɔrɔ kapi tönë ti ꞌdëꞌdï mo ti tɔrɔ ma këdï kaꞌdi koya ŋgï wiŋi yaga. ");
INSERT INTO bex_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tine ɔdɔ bɔ dɔliŋɔ koŋgɔ tɔrɔ koya ꞌdeni ɔtɔ kinza kpe tara tine, lïjë ebe koꞌdɔ lende kënyë ꞌböwu ti turu abo ga lïjë kogbɔ dökïꞌdï nnï. ");
INSERT INTO bex_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Dökïꞌdï bo ebe kitigɔ ŋgï ꞌböwu gɔ Yisarele bo kope közï bo dë di gɔmo gɔ kari kɔzɔ lende tönë Bɔkoꞌba kiya ꞌdeni mɔlo zi Musa ne. ");
INSERT INTO bex_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ŋere Bɔkoꞌba ënyï kilende zi Musa iya te, “Ari zi bɔ dɔliŋɔ. Miꞌdi dökïꞌdï nnï lïjë ti turu abo naga nima ꞌdeni këddï ꞌdɔ moꞌdɔ gɔ kotɔ ma naga nime mï löŋgö lïjë ");
INSERT INTO bex_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ꞌdɔ kïyëtï rönï ꞌjaa zi kole ꞌbe ga gbï zi kole ꞌba kole ꞌbe ga ma, ma ŋere Bɔkoꞌba mileme wa zi Ezipeto moꞌdɔ gɔ kotɔ ma mï löŋgö lïjë ꞌdɔ kikalike ŋgï ma na rɔ ŋere Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kina Musa ni ti Arona kënyï ŋgï kari zi bɔ dɔliŋɔ kiya te, “Ame na rɔ lende ma ŋere Bɔkoꞌba ꞌba Ebere kiya, ‘Nï, ti köꞌbö ŋbö kinza tileki röyï bërï zö nyanya ga? Ola bilaka ma ga kari gɔ lïjë kumötu ma. ");
INSERT INTO bex_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ɔdɔ kota gönnï di bi tari mëdï moja mömï kako mï dɔliŋɔ ꞌbï nime tïlëndö. ");
INSERT INTO bex_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ti mömï kora dɔyayi mïyöwö kïnë yayi kinda dë. Ti lïjë kitene kɔsɔ wa ame ga kɔmɔ di kpa ꞌdëꞌdï tönë ti ŋgërï ma kunzï mï nyaka ꞌbe ga ꞌdoyi yaga. ");
INSERT INTO bex_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mömï ti koso lɔ mï rö ꞌbï ti rö ꞌba turu ꞌbï naga nime rɔ gɔ rö ꞌba bilaka ꞌbï ga ꞌba Ezipeto pili. Wa ame mɔlo ꞌbu yï ni ti ꞌbu yï löbu ga koꞌja dë ti koꞌja mï kada ma tɔne.’” Kina Musa kënyï ŋgï di ŋgila bɔ dɔliŋɔ yayi kari abo. ");
INSERT INTO bex_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ya ma mï turu ꞌba bɔ dɔliŋɔ mo nima ënyï kilende zi bo iya te, “Bɔ nima ꞌdɔ bo köꞌbö togba dɔ bilaka nduwë tara ŋbö nyanya ga? Iꞌdi lïjë kari tumötu ŋere Bɔkoꞌba ꞌbënnï nima. Dɔyayi ꞌba Ezipeto nime kirasi rönï ꞌdeni ne ikali dë gba?” ");
INSERT INTO bex_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kina koꞌde Musa ni ti Arona ꞌböwu kileki kako zi bɔ dɔliŋɔ. Na bo kiya zïnnï te, “Ari kumötuke ŋere Bɔkoꞌba ꞌbe nima.” Tine bo ileki kiya te, “Iꞌdi mititi ye titi, yë ga na këdï kari?” ");
INSERT INTO bex_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa iya te, “Dëdï dɔlɔ ꞌdoyi ti bɔ bɔyi ze ga ti bulöbu kpaki ti yɔbi mo ga ti yïtötï pili ti yërï ze ga römöyï ꞌdɔ dari doꞌdɔ karama zi ŋere Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Bɔ dɔliŋɔ iya te, “Ee, ti mulömu ziye ti möyï Bɔkoꞌba, minza mola ye karike ti ꞌja ꞌbe ga ti bɔ bɔyi ꞌbe ga. Mikali ꞌdeni ëddï koꞌdɔke tënyï mökö toꞌdɔ ya. ");
INSERT INTO bex_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ɔdɔ koꞌdɔkɔke, bɔtɔni na ŋge ti kari tumötu ŋere Bɔkoꞌba.” Lende nime na lïjë koga Musa ni ti Arona ŋgï timo yaga di kɔmɔ bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kina Bɔkoꞌba kiya zi Musa te, “Ombi közïyï tɔrɔ dɔ dɔyayi ꞌba Ezipeto ꞌdɔ mömï kokpayi rönï mï dɔyayi ꞌbënnï nima ꞌdɔ kitene kɔsɔ wa ame ga kɔmɔ di kpa ꞌdëꞌdï a ma kunzï naga nima me ꞌdoyi yaga.” ");
INSERT INTO bex_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa ombi közï bo yɔ na Bɔkoꞌba kiꞌdi lili ma kembe ŋgï kebe tome di yïbï kako mï dɔyayi kote kada nima kpaki ti korɔndɔ mo. Mï dɔŋbɔ mo tine lili nima oꞌde mömï ꞌdeni ŋgï rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ako ŋgï rɔ dɔtumu ma konzi rɔ tïndï koso lɔ mï dɔyayi nima. Ame na rɔ dɔtumu ꞌba mömï ame bɔtɔ koꞌja dë mɔlo kina inza koꞌja gbï kpe di gɔ ame. ");
INSERT INTO bex_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ora dɔ yayi ŋgï mï kɔtɔ kïyölu kïnë yayi yaga. Kina lïjë kitene kɔsɔ wa ame ga kɔmɔ di kpa ꞌdëꞌdï ne ŋgï ꞌdoyi yaga kpaki ti döŋgërï ma kana ni. Kïnë a mɔtɔ rɔ ma kunzï rɔ ma kaꞌji te kari kinda dë kpe ma kɔtɔ te mï dɔyayi ꞌba Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kina bɔ dɔliŋɔ kïrëŋgë ŋgï welo kïdëkï Musa ni ti Arona kiya teyi te, “Mirasi lende ꞌdeni kënyë zi ŋere Bɔkoꞌba ꞌbe gbï ziye. ");
INSERT INTO bex_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ne olake ma gɔ lende kënyë ma ame mï kɔtɔ ꞌböwu. Ititike ŋere Bɔkoꞌba ꞌbe gɔma ꞌdɔ bo kombi gomɔ löbu kïrïndï nime yaga di dɔma.” ");
INSERT INTO bex_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa ni ënyï di ŋgila bɔ dɔliŋɔ yayi na lïjë kititi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Kina Bɔkoꞌba kiꞌdi lili tönë ŋgï kuyï tome ꞌbato rɔ ma kembe kako di dɔ tɔrɔ. Kina kome mömï tönë ga ŋgï kote kona koto kari mï mini löbu kola mï dɔyayi ꞌba Ezipeto ŋgï nati rɔ ma sari kïnë mömï ma kɔtɔ te kinda dë kpe. ");
INSERT INTO bex_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Tine Bɔkoꞌba iꞌdi dökïꞌdï bɔ dɔliŋɔ köꞌbö rɔ ma këddï koꞌdɔkɔ dë tope közï bo di gɔ Yisarele ꞌdɔ kari. ");
INSERT INTO bex_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kina Bɔkoꞌba kilende zi Musa iya te, “Oja közïyï mïtɔrɔ ꞌdɔ mandölu kako mï dɔyayi ꞌba Ezipeto nime rɔ mandölu ame komomo te kikali ŋgï te.” ");
INSERT INTO bex_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa ombi közï bo tɔrɔ na mandölu ma kinza kiya kutuꞌbö dɔyayi ꞌba Ezipeto ŋgï ŋbö töꞌdö mo dɔ mota. ");
INSERT INTO bex_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Bɔtɔ koꞌja kïnë lëpï nï dë ala koja ndïyï mbowa kari bi mɔtɔ ŋbö töꞌdö mo dɔ mota. Tine bi ame Yisarele këdï teyi ne le rɔ ma kɔpɔ. ");
INSERT INTO bex_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kina bɔ dɔliŋɔ kïdëkï Musa kilende teyi iya te, “Arike pili ti ꞌja ꞌbe ga ti bɔ bɔyi ꞌbe ga tumötu Bɔkoꞌba. Tine yërï ꞌbe ga pili rɔ gɔmo olake kileke bine.” ");
INSERT INTO bex_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa ileki dɔmo iya te, “Ola ze dogba yërï tize gɔ dari doŋma rɔ akumu zi Bɔkoꞌba ze. ");
INSERT INTO bex_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Yërï ze ga pili rɔ gɔmo kari tize ma kɔtɔ mɔtɔ kileke dë bine. Römöyï mɔtɔ mo ga na dëdï dari dumötu ŋere Bɔkoꞌba ze timo. Tine ɔdɔ dari dömö ꞌdeni yayi tine, na ꞌjaa dëdï dikali ma yala ga na gɔ dumötu ŋere Bɔkoꞌba timo.” ");
INSERT INTO bex_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Tine Bɔkoꞌba iꞌdi dökïꞌdï bɔ dɔliŋɔ ŋgï köꞌbö rɔ ma këddï koꞌdɔkɔ dë tola Yisarele kari. ");
INSERT INTO bex_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Bo ënyï kiya zi Musa te, “Ënyï yaga di kɔmɔ ma bine. Kïnë yï nima kinza kiꞌdi moꞌja dë kpe kɔmɔ ma. Mï kada mo tɔ nima këddï koꞌja kɔmɔ ma tölë ꞌbï na ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa iya te, “Ŋgï kɔzɔ lende kiya ꞌbï, minza mako kpe kömöyï bine.” ");
INSERT INTO bex_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ŋere Bɔkoꞌba iya ꞌdeni zi Musa te, “Mëdï moja gomɔ ŋge mï kɔtɔ nati dɔ bɔ dɔliŋɔ ꞌba Ezipeto nima lïjë ti bilaka abo ga. Di pötö mo na ti bo kola ye ŋgï karike. Bo ti koga ye yaga di bine ŋburu mï kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ari kiya zi Yisarele, bɔtɔni mo ga kpaki ti ꞌja kokpasi wa ma kileŋo di mï sïtërï ni ti yamo ma köbököbö naga di zi pɔri ꞌbënnï ga.” ");
INSERT INTO bex_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Bɔkoꞌba iꞌdi dökïꞌdï Ezipeto pili ŋgï rɔ ma koŋmi rɔ Yisarele. Turu ꞌba Ezipeto ti bilaka ma sari mo ga pili oŋgɔ Musa ŋgï rɔ a löbu. ");
INSERT INTO bex_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kina Musa kiya zi bɔ dɔliŋɔ te, “Ame na rɔ lende kiya ꞌba ŋere Bɔkoꞌba, bo iya te, ‘Mï zana korɔndɔ ꞌdeni ti milaki kote mï Ezipeto toko. ");
INSERT INTO bex_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Kole dɔndende pili ma mï Ezipeto ti kölë yaga kisaki di dɔ kole dɔndende ꞌbï ꞌba bɔ dɔliŋɔ ame ꞌdɔ kindaꞌba kïtï ꞌba bɔ dɔliŋɔ ne ŋbö kömö dɔ kole dɔndende ꞌba atɔli bɔ lisa ame këdï kuwu ndöwu ꞌbënï ti közïnï ne gbï ti dɔndende kole ꞌba yërï ni pili. ");
INSERT INTO bex_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Birɔ ti kuwu ma kinza kiya ti kogba mï Ezipeto, kuwu ame kinza te mɔlo di bi tisaki mo kina mɔtɔ kinza kpe gbï te ne. ");
INSERT INTO bex_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tine ma mï löŋgö Yisarele bï pele inza kugbö ala lïjë ti yërï ꞌbënnï ga kudu. Kina ti kikalike ŋgï omba ma ŋere Bɔkoꞌba moꞌdɔ geli löbu ꞌdeni mï löŋgö Ezipeto di rɔ Yisarele.’” ");
INSERT INTO bex_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Musa ileki gbï kiya te, “Turu ꞌbe naga nima pili ti kako kolɔdɔ bërï kɔmɔ ma kiya te, ‘Arike ti bɔtɔ ꞌbï ame pili kösö göyï ne.’ Kina ti mënyï mari ŋgï.” Lende nima ata ꞌdeni ŋgï dökïꞌdï Musa sowa na bo kënyï ŋgï di yayi kari abo. ");
INSERT INTO bex_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Bɔkoꞌba iya ꞌdeni mɔlo zi Musa te, “Bɔ dɔliŋɔ nima ti köꞌbö tilagi lende ꞌbï tara ꞌdɔ moꞌdɔ gɔ kotɔ ma mï konzi mï dɔyayi ꞌba Ezipeto.” ");
INSERT INTO bex_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa ni ti Arona oꞌdɔ gɔ kotɔ naga nime pili kɔmɔ bɔ dɔliŋɔ, tine Bɔkoꞌba iꞌdi dökïꞌdï bo köꞌbö rɔ ma këddï. Bo oꞌdɔkɔ dë tope közï bo di gɔ Yisarele kola kari yaga di mï dɔyayi abo. ");
INSERT INTO bex_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Bɔkoꞌba ose zi Musa ni ti Arona di Ezipeto yayi iya te, ");
INSERT INTO bex_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Nyepe nime na ꞌdɔ këdï rɔ nyepe ma dɔndende mï kɔmɔ kɔɔ ziye. ");
INSERT INTO bex_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ari kiyake ndose nime zi Yisarele pili. Mï töꞌdö dɔ ꞌbutë ꞌba nyepe nime nï mɔtɔ ogba kamölö ꞌbɔꞌbi ala banya ziye dɔ kulumutu ꞌbï. ");
INSERT INTO bex_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ne ɔdɔ kiya te konzike dë di kpa kulumutu ꞌbe odɔꞌbɔke rɔye ti ya ma ŋgɔsi ŋgila ye naga nima. Ame ɔdɔ koŋgɔke dɔ ꞌbö mo koriya ꞌdeni laka ziye ꞌdɔ konyoke yërï nima pili kɔꞌbɔ ye ne. ");
INSERT INTO bex_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Yërï ma ꞌdɔ koŋgɔke mo ga rɔ ma kɔmɔ kɔɔ mo ꞌdeni kɔtɔ naga rɔmo piyɔpiyɔ kinza a mɔtɔ rɔmo. Tine ꞌdɔ këdï ŋge rɔ banya ti kamölö. ");
INSERT INTO bex_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Oŋgɔke gɔmo laka ŋbö kömö mï töꞌdö dɔ ꞌbutë dɔmosowɔ mo. Kina gɔ Yisarele pili kumu ɔdɔ kada kösö ꞌdeni kpɔki bërï nima. ");
INSERT INTO bex_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Tine gɔ lïjë kogba roma mo kosa gɔ kpadörï ti lëꞌbërë ꞌbënnï ga ame lïjë këdï konyo yida nima yïmo ne. ");
INSERT INTO bex_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mï korɔndɔ mo nima lïjë konyo yida nima rɔ ma kilaŋma ti akaŋga gɔmo ti maŋgolɔꞌbɔ ame kinza laŋga gɔmo ne. ");
INSERT INTO bex_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kinza bɔtɔ mɔtɔ konyo yida nima dë rɔ ma kïdïdï ala kuꞌdï rɔ tuꞌdï ti tɔlɔ gɔmo. Tine oŋma ŋge rɔ toŋma dɔ paꞌdo, dɔmo ga ti kolɔŋbɔ mo ga pili ti a ꞌba yïmo koŋma rɔ toŋma. ");
INSERT INTO bex_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kinza kola kɔsɔ mo dë bi këzë dɔmo. Ɔdɔ kɔsɔ mo kola gba omɔ paꞌdo dɔmo kilaŋma kulötö yaga. ");
INSERT INTO bex_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ɔdɔ këddï konyoke ꞌdeni nima mɔtɔ nï ti bɔŋgɔ ꞌbï ga ndö röyï kusu a ndïyï ga ꞌdeni përï ꞌbï közïyï. Kina ꞌdɔ konyoke welowelo. Karama ma kïdëkï rɔ Pasaka ꞌba toro ma, ma ŋere Bɔkoꞌba timo na. ");
INSERT INTO bex_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Mï korɔndɔ kɔtɔ mo nima mëdï milaki kebe mï Ezipeto pili tupö kole dɔndende ꞌbënnï ga ti ꞌba bilaka lesi kpaki ti ꞌba yërï mo ga. Kina ti modɔ karama dɔ akoro ꞌbënnï ꞌba Ezipeto naga nima pili rɔ gɔmo. Ma na rɔ ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Roma nima na ti këdï rɔ akileme zö tikali rö ꞌbe ga timo. Ɔdɔ moꞌja roma yɔ na ti miteli ŋgï nduwë dɔgba. Gomɔ kënyë nime mëdï modɔ dɔ Ezipeto ne inza kosa rɔye. ");
INSERT INTO bex_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ame na ti këdï rɔ kada ma löbu ziye toro mo nduwë kala gɔ kole ꞌbe ga ma kɔwɔ yayi koꞌdɔke karama mo nduwë rɔ ŋburuŋburu zö ma ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mï töꞌdö dɔ modɔmorïyö nima onyoke ŋge rɔ maŋgolɔꞌbɔ ame kinza laŋga gɔmo ne. Mï dɔndende ꞌba kada mo nima otɔtɔke laŋga pili yaga di mï rö ꞌbe ga. Bɔtɔ ame konyo a ma ti laŋga gɔmo mï töꞌdö dɔ modɔmorïyö nime koga yaga di mï löŋgö Yisarele bo këdï rɔ bɔ löwö. ");
INSERT INTO bex_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Mï dɔndende ꞌba kada mo nima akoke pili mï mötu ma löbu kina gbï mï töꞌdö dɔ modɔmorïyö mo. Mï kada dɔ rïyö naga nime kinza koꞌdɔke a mɔtɔ rɔ ndɔbɔ dë, tine ŋge rɔ ndɔbɔ ꞌba akonyo ꞌba kpeye. ");
INSERT INTO bex_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Oꞌdɔke karama nime këdï konyo maŋgolɔꞌbɔ mo kinza laŋga gɔmo ne nduwë römöyï bo na rɔ kada ame moja dɔ kupö ye yaga di mï Ezipeto yïmo. Oꞌdɔke karama nime nduwë kala zi dɔ kupö ye ga ma kɔwɔ yayi ŋbö rɔ ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mï dɔndende ꞌba nyepe mo nima onyoke ŋge rɔ maŋgolɔꞌbɔ ma kinza laŋga gɔmo, kisaki di mï töꞌdö dɔ ꞌbutë dɔmosowɔ ŋbö kömö mï töꞌdö dɔ ꞌbutë rïyö dɔɔkɔtɔ mo. ");
INSERT INTO bex_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Dɔ modɔmorïyö nime pili a mɔtɔ rɔ laŋga kudö dë mï rö ꞌbe ga. Bɔtɔ mɔtɔ ame konyo a ma ti laŋga gɔmo di mïye ala rɔ bɔ loma ꞌbe koga ŋgï yaga di mï kupö Yisarele ŋburu rɔ bɔ löwö. ");
INSERT INTO bex_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ɔdɔ këddï koloma pele ŋbö rɔ ma kɔwɔ bitɔ tɔ ne, a ma ti laŋga gɔmo kinza konyo dë.” ");
INSERT INTO bex_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kina Musa kotɔtɔ dɔ löbu ꞌba Yisarele ŋgï pili kiya teyi te, “Nï mɔtɔ ari koŋgɔ kole yërï ziye kpa kulumutu ꞌbï ꞌdɔ kumuke karama ꞌba Pasaka. ");
INSERT INTO bex_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Oꞌdɔ roma mo mï lebe. Ogba kuyu kusu yïmo ꞌdɔ kosa roma nima kpadörï ꞌbï ti rɔ lëꞌbërë mo ga. Kina kinza bɔtɔ mɔtɔ kɔdɔ dë yaga mï korɔndɔ mo nima ŋbö bi këzë titi. ");
INSERT INTO bex_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Römöyï ɔdɔ ŋere Bɔkoꞌba këdï kozi tupö kole dɔndende ꞌba Ezipeto, bo koꞌja roma kpadörï ꞌbe ga yɔ na bo ti kiteli ŋgï dɔgba. Bo inza kiꞌdi malayika ꞌba tölë nima kpe kɔdɔ rö ꞌbe ga kupö ye. ");
INSERT INTO bex_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Köꞌdu kiꞌdi nime ziye toro mo nduwë kala gɔ kupö ye ga rɔ ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kina ɔdɔ kiya te kari kömöke ꞌdeni mï dɔyayi ame bo Bɔkoꞌba kulömu tiꞌdi mo ziye ne, oꞌdɔke lende koro nime. ");
INSERT INTO bex_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kina ɔdɔ kole ꞌbe ga kititi ye kiya te, ‘Lende ꞌba waꞌdi na?’ ");
INSERT INTO bex_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ïyëtïke zïnnï te, ‘Lende ꞌba toro ŋere Bɔkoꞌba na. Römöyï mï kada nima bo kote dɔ kole dɔndende ꞌba Ezipeto ne bo onye ze kiteli di dɔze.’” Kina Yisarele naga nima kolɔdɔ ŋgï bërï kïlëlu Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kina lïjë kari koꞌdɔ wa nima Bɔkoꞌba kose zi Musa ni ti Arona ne ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Mï zana korɔndɔ mo nima na Bɔkoꞌba kote dɔ kole dɔndende ꞌba Ezipeto ŋgï pili yaga kisaki di dɔ kole ꞌba bɔ dɔliŋɔ ame mo ŋgï ko gɔ na kindaꞌba kïtï di pötö ꞌbu bo ne ŋbö kömö dɔ kole ꞌba ya ma kudödu ꞌdeni kuꞌdu mï maboso naga ti kole ꞌba yërï ꞌbënnï ga pili. ");
INSERT INTO bex_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kina bɔ dɔliŋɔ ni ti turu abo ga ti bilaka ꞌba mï Ezipeto pili kindiŋi ŋgï mï korɔndɔ mo nima kuwu kudu ŋgï kogba mï Ezipeto pili. Römöyï liŋɔ ma kɔtɔ te ileke dë kinza töku teyi. ");
INSERT INTO bex_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Mï korɔndɔ mo nima na bɔ dɔliŋɔ kïdëkï Musa ni ti Arona ŋgï kilende teyi iya te, “Ënyï ti Yisarele ꞌbï naga nima yaga di mï dɔyayi ma nime kari kumötuke Bɔkoꞌba ꞌbe nima kɔzɔ ame kiteri ne. ");
INSERT INTO bex_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ogbake yërï ꞌbe ga pili tiye karike timo. Tine ititi Bɔkoꞌba koꞌdɔ yëyï zö.” ");
INSERT INTO bex_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ezipeto ututu ŋgï kpa bïcï ya naga nima ꞌdɔ kënyï welo kɔdɔ yaga di mï dɔyayi ꞌbënnï. Lïjë iya te, “Arike, kinza dölë kote.” ");
INSERT INTO bex_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kina Yisarele ŋgï gölïgölï, mɔtɔ otope lagini ꞌbï ame kodɔ laŋga dë gba gɔmo ne ŋgï mï kole sele kudödu mï bɔŋgɔ kukölö dɔkɔnyɔ yï. ");
INSERT INTO bex_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Yisarele oꞌdɔ ꞌdeni kɔzɔ ma tönë Musa kiya zïnnï ne kïdëkï yamo ma köbököbö ti sïtërï ni ti bɔŋgɔ di zi Ezipeto naga nima. ");
INSERT INTO bex_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Bɔkoꞌba iꞌdi mï bilaka naga nima ŋgï këdï rɔ ma koŋmi rɔ Yisarele. Kina kiꞌdi wa ame ga lïjë kïdëkï ne ŋgï pili zïnnï. A nime na ꞌdɔ kiꞌdi Yisarele kombi wa ꞌba mɔri ꞌba mï dɔyayi ꞌba Ezipeto ŋgï kari timo ne. ");
INSERT INTO bex_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Yisarele ënyï ŋgï dɔmo ti ndïnnï di Ramese tari Suköta. Bɔtɔni ꞌberi rɔ dönnï ëdï kɔzɔ kuluku kpa mota bi sowɔ kɔdɔ dɔmo kuluku kpa rïyö bi ꞌbutë sowɔ (600,000) kola ꞌja ni ma ti kole titi kïtëtë dë yïmo. ");
INSERT INTO bex_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Bilaka ma konzi mɔtɔ ga ame kinza rɔ kupö Yisarele ne ti yërï ma konzi kɔzɔ ɔtɔ ɔlɔ ŋgï kɔtɔ tïnnï. ");
INSERT INTO bex_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Lagini kinza laŋga gɔmo tönë ga na lïjë koloma rɔ toꞌbɔ mo rɔ maŋgolɔꞌbɔ römöyï toga lïjë di Ezipeto yayi nima ömö ŋgï tuguꞌdu kinza ma lïjë kileŋo rönnï togba akonyo ma laka zïnnï. ");
INSERT INTO bex_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Loma ꞌba Yisarele mï Ezipeto yayi nima ŋbö kɔmɔ kɔɔ kuluku modɔɔmota kɔdɔ dɔmo ꞌbutë mota (430). ");
INSERT INTO bex_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Di pötö kɔmɔ kɔɔ nime kote rönï ꞌdeni mï kada mo nima na bilaka ꞌba Bɔkoꞌba kënyï ŋgï dɔmo di Ezipeto rɔ dɔtumu gɔ kpa gɔli mo ga. ");
INSERT INTO bex_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Korɔndɔ nima na rɔ ame Bɔkoꞌba koda lïjë yïmo koja yaga di Ezipeto. Kina kulömu korɔndɔ nima ŋgï ŋburu zi Yisarele rɔ korɔndɔ ꞌba bi koda. ");
INSERT INTO bex_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ŋere Bɔkoꞌba iya zi Musa ni ti Arona te, “Köꞌdu kiꞌdi ꞌba karama ꞌba Pasaka nime na kɔzɔ a nime te. Bilaka ame ga rɔ bɔ löwö ne konyo akonyo mo dë. ");
INSERT INTO bex_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Tine atɔli ame ga ɔdɔ kpe na kugöke eꞌbe ꞌdeni ne ti konyo ɔdɔ kilele bo ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Bilaka ame kako rɔ ŋba ala mï ndɔbɔ ne konyo dë. ");
INSERT INTO bex_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Akonyo mo konyo aa mï rö mo ame kuꞌdï yïmo ne kombi dë kari timo yaga bi mɔtɔ. Yida mo tɔ nima kinza kodowe mï kiliŋba mo ma kɔtɔ te dë. ");
INSERT INTO bex_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kupö Yisarele pili rɔ gɔmo koꞌdɔ karama nime. ");
INSERT INTO bex_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Tine bilaka ame kilele dë gba ne konyo akonyo mo dë. Ɔdɔ bɔ löwö ma koloma ꞌdeni mï löŋgö ye naga nima kiteri toꞌdɔ karama nime, ileleke bɔtɔni mo ga titi dɔgba yaga gɔ lïjë këdï yaga rɔ kupö Yisarele gɔ lïjë kako ti tonyo karama ꞌba Pasaka. ");
INSERT INTO bex_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Lende nime ziye kupö Yisarele kpaki ti bɔ löwö ma koloma ꞌdeni mï löŋgö ye naga.” ");
INSERT INTO bex_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Yisarele pili rɔ gɔmo uwö dɔ lende ame ga pili Bɔkoꞌba kose zi Musa ni ti Arona ne ŋgï koro koꞌdɔ ko tara. ");
INSERT INTO bex_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mï kada nima na Bɔkoꞌba koꞌde Yisarele ŋgï yaga di mï Ezipeto rɔ dɔtumu gɔ kpa gɔli mo ga. ");
INSERT INTO bex_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ŋere Bɔkoꞌba iya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Kole dɔndende ame ga rɔ bɔtɔni ne pili kulömu zö. Kole dɔ tapi ꞌba Yisarele pili ama ga na, di mï bilaka lesi kpaki ti yërï mo ga.” ");
INSERT INTO bex_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kina Musa kilende zi bilaka ꞌba Yisarele iya te, “Kada ꞌba tɔdɔ di mï Ezipeto di mï loma rɔ atɔli nime ziye tiꞌdi mo këdï ŋburu dɔye. Römöyï Bɔkoꞌba na koja ye di yïmo ti tigɔ dɔ kiteli abo. Wa ame ti laŋga gɔmo ne kinza konyoke dë mï kada mo nima. ");
INSERT INTO bex_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tɔne mï nyepe ma dɔgba nime kïdëkï möyï mo rɔ Abibi ne tënyï ꞌbe na ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Bɔkoꞌba ti koto ye mï yayi ꞌba Kanana ni ti Ete ti Amora ti Iwa ti Yebusa yayi ma tönë bo kulömu ꞌdeni mɔlo tiꞌdi mo zi ꞌbu ye löbu ga ꞌdɔ tiꞌdi mo ziye ne, yayi ma laka ame tagi ni ti wï sa kambi di teyi kɔzɔ sëgë ne. Ɔdɔ bo koto ye ꞌdeni yayi ziye toꞌdɔ karama nime mï nyepe mo nima. ");
INSERT INTO bex_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mï töꞌdö dɔ modɔmorïyö mo naga nima onyoke ŋge rɔ maŋgolɔꞌbɔ ame kinza laŋga gɔmo ne. Mï kada ame mo ꞌdeni rɔ dɔ modɔmorïyö mo na ꞌdɔ koꞌdɔke karama mo zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mï töꞌdö dɔ modɔmorïyö mo nima onyoke ŋge rɔ wa ma sari kinza laŋga gɔmo naga. Wa ame ga ti laŋga gɔmo ne kïnë mo kinda dë mï rö ꞌbe ga ala mï dɔyayi ꞌbe. ");
INSERT INTO bex_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mï kada mo nima iyake zi kole ꞌbe ga te, ‘Moꞌdɔ a nime te gɔ wa ma ŋere Bɔkoꞌba koꞌdɔ zö gɔ tɔdɔ ma yaga di mï Ezipeto.’ ");
INSERT INTO bex_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Lende koro nime iꞌdike këdï dɔye kɔzɔ mbero ame kore döyï ala közïyï köꞌbö kinza kölu dë ne tara. ꞌDɔ köꞌdu kiꞌdi abo köꞌbö ŋburu dɔ kpeye. Römöyï ŋere Bɔkoꞌba na koja ye yaga di mï Ezipeto ti tigɔ dɔ kiteli abo. ");
INSERT INTO bex_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Karama nime ziye nduwë toꞌdɔ mo rɔ kɔmɔ kɔɔ mï kada mo ame Bɔkoꞌba koza ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Di pötö ma Bɔkoꞌba koꞌde ye ꞌdeni mï dɔyayi ꞌba Kanana kiꞌdi ziye kɔzɔ ame bo kulömu ꞌdeni ziye ti ꞌbu ye löbu ga ne, ");
INSERT INTO bex_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ziye tiꞌdi kole dɔ tapi pili ame ga rɔ bɔtɔni ne zi bo. Dɔ tapi ꞌba yërï ꞌbe ga ame ga rɔ bɔtɔni ne gbï pili rɔ abo ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Dɔ tapi ꞌba akaca zïyï tutë gɔmo ti kole kamölö. Ne ɔdɔ kutë gɔmo dë upö yaga. Kole ma dɔndende ꞌbe ga gbï tara tutë gɔmo rɔ tutë. ");
INSERT INTO bex_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tine kɔwɔ kada mɔtɔ yayi ɔdɔ kole ꞌbe ga kititi ye, kiya te, ‘Waꞌdi mo ga na tara?’ Iyake te, ‘Ŋere Bɔkoꞌba na koꞌde ze dɔdɔ yaga di mï Ezipeto ti tigɔ dɔ kiteli abo di mï loma rɔ atɔli. ");
INSERT INTO bex_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mï kada nima bɔ dɔliŋɔ ꞌba Ezipeto kota gɔze tëgë kinza dari dë ne na ŋere Bɔkoꞌba kupö kole dɔndende ŋgï ꞌdoyi yaga di mï Ezipeto, ꞌba bilaka lesi kpaki ti ꞌba yërï mo ga. Gɔ köꞌdu mo na me ꞌdɔ kiꞌdi dëdï dumu kole dɔndende ꞌba wa pili zi bo ŋere Bɔkoꞌba rɔ roma ne. Tine ma rɔ bilaka lesi mo ga dutë gɔmo yaga.’ ");
INSERT INTO bex_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kina ꞌdɔ köꞌbö kɔzɔ mbero közïye ala kpa dɔye naga tara ame lende mo kudölu dë ne, Bɔkoꞌba na koja ze yaga di mï Ezipeto ti tigɔ dɔ kiteli abo.” ");
INSERT INTO bex_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mï kada mo nima bɔ dɔliŋɔ ꞌba Ezipeto kope közï bo di gɔ Yisarele kola kari ne, Bɔkoꞌba oto lïjë dë kudö kebe gɔ kɔri ma ŋgɔsi ame kebe mï dɔyayi ꞌba Pilisitiya ne. Römöyï Bɔkoꞌba iya te, “Ɔdɔ ya naga nime kari koŋgɔ ya kënyë ꞌdeni tïnnï lïjë ti kënyï kebe ꞌböwu kuyï dönnï kileki Ezipeto.” ");
INSERT INTO bex_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kina Bɔkoꞌba koto lïjë ŋgï koga tïnnï za te rɔ mï mökö kari kpa Yöpö Kasi. Yisarele mï tënyï ꞌbënnï di Ezipeto lïjë ndö ti jama ꞌba közïnnï ga. ");
INSERT INTO bex_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa iꞌdi kombi kiliŋba Yesepa teyi römöyï Yesepa iꞌdi bilaka ꞌbënnï ga ꞌdeni kulömu rönnï mɔlo gɔ lïjë kombi kiliŋba bo kileki timo. Bo iya zïnnï te, “Rɔ ma laka ŋere Bɔkoꞌba ti kako kokɔnyi ye. Kina gɔ kombike kiliŋba ma di mï dɔyayi nime karike timo.” ");
INSERT INTO bex_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tënyï ꞌbënnï di Suköta lïjë ari koga taya Etama ŋgɔsi dɔ kpa mökö. ");
INSERT INTO bex_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Rɔ mï kada Bɔkoꞌba ösö dɔgba zïnnï rɔ pɔli kakpa tokɔkɔ lïjë mï liŋgere nima. Tine ma rɔ mï korɔndɔ bo ösö dɔgba zïnnï rɔ paꞌdo ma kakpa toyi bi zïnnï. Oꞌdɔ tara zïnnï römöyï gɔ lïjë kiliŋgere kote kada kpaki ti korɔndɔ mo gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Pɔli kakpa rɔ mï kada ti paꞌdo mo ma rɔ mï korɔndɔ nima oloma ŋgï nduwë köꞌbö ŋburu dɔgba kömönnï. ");
INSERT INTO bex_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kina Bɔkoꞌba kiya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Iya zi Yisarele kileki koga taya ŋgɔsi ŋgila Pirota mï löŋgö Migedola ni ma ti Yöpö Kasi. Lïjë koga taya ꞌbënnï yayi rɔ ma koriya ti Bala Zepona. ");
INSERT INTO bex_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Römöyï bɔ dɔliŋɔ ꞌba Ezipeto ti komeri kiya te, ‘Yisarele tönë ga ëdï kïlïkö dönnï ꞌdeni konyɔpi rönnï bina yayi lida ukpë kpënnï ꞌdeni.’ ");
INSERT INTO bex_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kina ti miꞌdi mï bɔ dɔliŋɔ nima këddï bo kiꞌdi koga gɔye. Tine ma na ti moꞌdɔ a löbu zi bo ti bɔ ya abo naga nima. Kina ti lïjë Ezipeto kikali ŋgï ma na rɔ ŋere Bɔkoꞌba.” Kina Yisarele koꞌdɔ ŋgï kɔzɔ a nime te. ");
INSERT INTO bex_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tine ɔdɔ kari kiya zi bɔ dɔliŋɔ ꞌba Ezipeto mo nima kiya te Yisarele iriŋa ꞌdeni tine na lïjë ti turu abo ga kuyï meri mɔtɔ ŋgï. Lïjë iya te, “Waꞌdi ga na me doꞌdɔke te dolake Yisarele naga nime kari? Yë ga na ti koꞌdɔ ndɔbɔ zize?” ");
INSERT INTO bex_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kina bo kiyija aribiya ꞌba ya ŋgï ndö bo kogba bɔ ya abo ga ti bo. ");
INSERT INTO bex_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Bo igeli rɔ aribiya ma laka naga kuluku ꞌbutë dɔmorïyö (600) gbï ti aribiya mɔtɔ ga ꞌba Ezipeto ti bɔ këlu pili dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Bɔkoꞌba iꞌdi mï bo këddï kebe toga gɔ Yisarele koꞌja ya naga nima këdï kari ëꞌbënnï ꞌdeni yaga rɔ dɔ mɔri. ");
INSERT INTO bex_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Bɔ kanya ꞌba Ezipeto naga nima ma dɔ aribiya ti ma dɔ kosani gbï ti bɔ kanya ma ti ndïnnï mo ga ari kota gɔ Yisarele koꞌja lïjë koga taya ꞌdeni Pirota kɔmɔ Bala Zepona ŋgɔsi kpa yöpö yayi. ");
INSERT INTO bex_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tine ɔdɔ bɔ dɔliŋɔ ni kömö ꞌdeni ŋgɔsi yayi tine na Yisarele koꞌja lïjë ŋgï këdï rɔ tozi gönnï. Kina tikere kindaꞌba Yisarele ŋgï kebe tudu zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Lïjë iya zi Musa te, “Dögö na kinza mï dɔyayi ꞌba Ezipeto na me koꞌde ze tölë yï mökö bine? Gɔ waꞌdi na koꞌdɔ lende nime te zize koꞌde ze bine di Ezipeto? ");
INSERT INTO bex_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Diya dë du tönë mɔlo zïyï diya te ola ze doꞌdɔ ndɔbɔ ka zi Ezipeto? Toꞌdɔ ndɔbɔ zïnnï ti ame ꞌdɔ dölë mökö bine ne, ma yala na laka?” ");
INSERT INTO bex_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa iya zïnnï te, “Kinza kereke dë. Ogbɔke dökïꞌdï ye. Ti koŋgɔke tɔne ma Bɔkoꞌba këdï kɔmɔ ye. Ezipeto naga nima inza koꞌjake kïnë mo kpe. ");
INSERT INTO bex_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Bɔkoꞌba na këdï koꞌdɔ ya tïnnï gɔye. ꞌBeye ogbɔke le rɔ dökïꞌdï ye.” ");
INSERT INTO bex_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Tine na Bɔkoꞌba kileki zi Musa iya te, “Ëddï kuduke zö gɔ waꞌdi? Iya zi Yisarele lïjë kari nduwë dɔgba. ");
INSERT INTO bex_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ombi përï nima közïyï ne tɔrɔ koja kari dɔ yöpö nima ꞌdɔ mini koza mïnï yaga rïyö gɔ Yisarele kumu kebe mï dɔyayi ma këlë. ");
INSERT INTO bex_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mëdï mogbɔ dökïꞌdï Ezipeto naga nima gɔ lïjë kozi nduwë gɔye. Kina ti mileme tigɔ ꞌba akaꞌda ma ti bɔ dɔliŋɔ ni ti bɔ kanya abo naga nima bo kona ti bo ne kpaki ti kosani mo ga. ");
INSERT INTO bex_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kina ti lïjë Ezipeto kikali ŋgï ma na rɔ ŋere Bɔkoꞌba ɔdɔ kiya te mileme tigɔ ma ꞌdeni ŋgï zïnnï ti bɔ dɔliŋɔ ꞌbënnï mo kpaki ti aribiya ꞌba ya abo naga nima ti worota ma dɔ kosani mo ga.” ");
INSERT INTO bex_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kina malayika ꞌba Bɔkoꞌba mo tönë kösö dɔgba kɔmɔ Yisarele ne kuyï rönï ŋgï kileki kebe gönnï yïꞌböwu. Pɔli kakpa mo tönë dɔgba ne ileki ŋgï gbï kebe gönnï ");
INSERT INTO bex_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","kuruwö rönï mï löŋgö lïjë ti Ezipeto. Mï korɔndɔ nima pili pɔli nima oꞌdɔ mandölu kapa ma zi Ezipeto tine kiyɔpɔ bi zi Yisarele. Kina kiꞌdi ŋgï bɔtɔ bɔ ya mɔtɔ kese dë ŋgɔsi rönnï mï korɔndɔ nima. ");
INSERT INTO bex_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa ombi közï bo tɔrɔ dɔ yöpö kina mï korɔndɔ mo nima na Bɔkoꞌba kiꞌdi lili ma kembe ŋgï kënyï tome kako di yïbï kulöku mini nima tö yaga kola dɔyayi rɔ ma këlë. ");
INSERT INTO bex_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Mini löbu nima oza mïnï ŋgï rïyö Yisarele kumu kebe dɔyayi sari. Kpa mini këdï ŋgëŋï te kapa dɔ gali gbï dɔ dörï. ");
INSERT INTO bex_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ezipeto tönë ga oga gönnï ŋgï nduwë. Kina kosani ꞌba bɔ dɔliŋɔ tönë ga ti aribiya mo ga kpaki ti worota mo ga kɔdɔ ŋgï gɔ Yisarele mï zana mini löbu nima yayi. ");
INSERT INTO bex_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Mɔlo mï kano bi na Bɔkoꞌba kuyï kɔmɔ bo ŋgï dɔ bɔ kanya ꞌba Ezipeto naga nima di mï pɔli paꞌdo tönë kïlïkö dɔmo yaga. ");
INSERT INTO bex_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Bɔkoꞌba iꞌdi ndï aribiya ꞌbënnï ga kiŋgiꞌdɔ dɔ yayi tari koloma yaga zïnnï rɔ gomɔ. Ezipeto naga nima iya te, “Dënyïke yaga di rɔ Yisarele naga nime Bɔkoꞌba na këdï koꞌdɔ ya ꞌdeni tize gönnï.” ");
INSERT INTO bex_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kina Bɔkoꞌba kiya zi Musa te, “Ombi közïyï tɔrɔ ꞌdɔ mini nima kileki kutuꞌbö rönï dɔ Ezipeto naga nima ti aribiya ꞌbënnï ga kpaki ti worota ꞌba dɔ kosani mo naga nima.” ");
INSERT INTO bex_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kina Musa kombi közï bo ŋgï tɔrɔ dɔ mini nima. Kina koꞌja bi këzë ꞌdeni yaga nima na mini kileki ŋgï piꞌdi bi ꞌbënï ma mɔlo. Ezipeto tönë ga ꞌdeni ŋgï nzïkï dɔ mini ŋere Bɔkoꞌba ona lïjë ꞌdeni pili gɔ mini löbu nima. ");
INSERT INTO bex_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mini ɔlɔ ŋgï koꞌboli dɔ aribiya ꞌbënnï tönë ga kpaki ti worota mo ga. Ezipeto naga nima kozi gɔ Yisarele ŋbö mï zana mini yayi ne ma kɔtɔ mɔtɔ mo te ɔmɔ dë. ");
INSERT INTO bex_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Tine Yisarele umu ma ꞌbënnï le kebe mï dɔyayi sari koꞌja mini këdï ŋgëŋï dɔ gali nnï gbï kapa dɔ dörï. ");
INSERT INTO bex_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mï kada nima na ŋere Bɔkoꞌba kɔmɔ Yisarele ŋgï di zi Ezipeto lïjë koꞌja ti kömönnï te, ma Ezipeto kölë ŋgï kote dönnï mï mini kïyökö ꞌjaa kebe kpa götö. ");
INSERT INTO bex_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Kina ɔdɔ Yisarele koꞌja tigɔ löbu nima ŋere Bɔkoꞌba koꞌdɔ zi Ezipeto ne ꞌdeni tara tine, lïjë pili ŋgï rɔ ma kere Bɔkoꞌba kiꞌdi dönnï gɔmo gbï ti Musa bɔ laja abo. ");
INSERT INTO bex_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kina Musa ni ti Yisarele pili koloma ŋgï rɔ toba ŋgala nime zi ŋere Bɔkoꞌba, kiya te, “Ti moba ŋgala zi Bɔkoꞌba gɔ akaꞌda ti tigɔ dɔ kiteli abo. Kosani ni ti bɔ dɔmo ga bo ululu ꞌdeni mï mini löbu. ");
INSERT INTO bex_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Bɔkoꞌba na rɔ tigɔ ma gbï rɔ ŋgala zö. Bo ako ꞌdeni bo kɔmɔ ma. Bo na rɔ ŋere Bɔkoꞌba ma. Kina ti mïlëlu bo. Ŋere Bɔkoꞌba ꞌba ꞌbu ma ti moba rɔ löbu dɔ kiteli abo. ");
INSERT INTO bex_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Bɔkoꞌba na rɔ bɔ ya. Möyï bo na rɔ ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Bo ululu aribiya ꞌba bɔ dɔliŋɔ ꞌdeni ti bɔ kanya mo ga gɔ mini löbu. Bɔ këlu ma lakalaka mo ga ari ꞌdeni ŋgï pili gɔ mini. ");
INSERT INTO bex_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mini kalo nima indiyɔ dönnï ꞌdeni. Lïjë önzu ŋgï bïcï mini bërï kɔzɔ kulugbï döku. ");
INSERT INTO bex_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yö, ŋere Bɔkoꞌba, dörï yï embe sowa. Dörï yï ïyëyï mï bɔ koꞌdɔ ya tïyï ga ŋgï kɔtɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ti tigɔ dɔ kiteli ꞌbï na kïtïŋï bɔ ŋbörï ꞌbï ga ꞌdeni bërï. Okpekpe kpa ya ꞌbï ꞌdeni rönnï köbö koŋma lïjë yaga kɔzɔ wuyö. ");
INSERT INTO bex_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Tawo ꞌbï iꞌdi mini löbu ŋgï kɔrɔ kulu dönï bi kɔtɔ kɔzɔ tëlï. Mï zana mini ma kalo kulöwö tönë ileki ŋgï këlë yaga. ");
INSERT INTO bex_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kuruku bɔ ya ze naga nima ögö iya te, ‘Dëdï doga gönnï dota kpënnï. Ti doza mï a ꞌba mɔri ꞌbënnï ga dogba kɔzɔ ma doꞌdɔkɔ togba mo. Ti dotɔ mbele ze ga dotɔtɔ ëꞌbënnï ga ꞌdoyi.’ ");
INSERT INTO bex_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ne oŋgɔ Bɔkoꞌba, tawo ꞌbï ma mï kɔtɔ le te na kona Ezipeto ŋgï gɔ mini löbu. Lïjë önzu ŋgï kɔzɔ yamo mï mini löbu. ");
INSERT INTO bex_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Bɔkoꞌba ma yala na këdï kɔzɔ nï ŋere Bɔkoꞌba? Nï ma koro rɔ mbëmbë nime. Yë na ti kɔꞌbɔ toꞌdɔ gɔ kotɔ kɔzɔ ꞌbëyï? ");
INSERT INTO bex_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ombi közïyï tɔrɔ na yayi kindiyɔ bɔ ya ze ga ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ti akɔꞌɔ ꞌbï ame lipo mï kɔtɔ ne ti kokɔkɔ bilaka ame ga kutë gɔmo ne ŋgï. Ti kogbɔ lïjë ŋgï ti tigɔ ꞌbï koto lïjë mï dɔyayi ma laka ꞌbï. ");
INSERT INTO bex_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Laki ti kuwö kina ti rönnï kïlëꞌdï ŋgï tikere kindaꞌba Pilisitiya ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ŋere ꞌba Edome ti këdï dɔ tikere. Rɔ kïlëꞌdï ti kindaꞌba ŋere ꞌba Mowaba. Bilaka ame ga rɔ Kanana mo ga ne ti kolɔkpɔ ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Tikere ni ti rɔ kïlëꞌdï ti kindaꞌba lïjë ŋgï. Ti tigɔ ꞌbï lïjë ti kɔrɔ ŋgï te kɔzɔ döku ŋbö bilaka ꞌbï ga kiteli, ŋbö bilaka ꞌbï ga ame kutë gɔmo ꞌdeni ne kiteli lïjë. ");
INSERT INTO bex_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kina ti koꞌde lïjë bilaka ꞌbï ga kako koloma dɔ döku koro ꞌbï, gɔ bi ame nï na kileŋo ꞌdeni rɔ bi ꞌba loma ꞌbï ne. Bi ꞌba mötu mo közïyï na kileŋo. ");
INSERT INTO bex_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Rɔ löbu ꞌbï ꞌba ŋere Bɔkoꞌba ti köꞌbö rɔ ŋburuŋburu.” ");
INSERT INTO bex_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mï kada nima koꞌja kosani ꞌba Ezipeto ti aribiya mo ga kɔdɔ ꞌdeni mï zana mini löbu yɔ na Bɔkoꞌba kiꞌdi mini löbu kileki ŋgï koꞌboli dönnï. Tine Yisarele umu ꞌbënnï ꞌdeni kari kebe mï dɔyayi ma këlë. ");
INSERT INTO bex_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kina Miriyama bɔ kumë lende ꞌba Bɔkoꞌba lëmï ꞌba Arona ni kogba kaliseye ŋgï ꞌja mɔtɔ ga kulölï gönï toba ŋgala tomba kaliseye tusï mo. ");
INSERT INTO bex_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Lɔko oba iya te, “Oba ŋgala zi Bɔkoꞌba gɔ akaꞌda ti tigɔ dɔ kiteli abo. Kosani ni ti bɔ dɔmo ga bo ululu ꞌdeni mï mini löbu.” ");
INSERT INTO bex_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kina Musa kokɔkɔ Yisarele ŋgï di kpa Yöpö Kasi yayi lïjë kari mï mökö ꞌba Surö. Lïjë iliŋgere ŋbö kada dɔ mota koꞌja a mɔtɔ rɔ mini dë. ");
INSERT INTO bex_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Lïjë ari kömö Mara, tine mini mo rɔ ma kata bɔtɔ kɔꞌbɔ tuwë mo dë. Gɔ köꞌdu mo na ma ꞌdɔ kiꞌdi kïdëkï möyï mo rɔ Mara ne ama kiya te “Ata”. ");
INSERT INTO bex_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kina bilaka naga nima kebe ŋgï tilende rɔ Musa, iya te, “Waꞌdi na gɔ duwë?” ");
INSERT INTO bex_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa udu zi Bɔkoꞌba na Bɔkoꞌba kileme ŋgërï mɔtɔ ŋgï zi bo. Bo ogba ŋgërï tönë kuꞌdu mï mini nima na këyï ŋgï yaga. Kina Bɔkoꞌba kiꞌdi köꞌdu kiꞌdi ŋgï zi Yisarele toloma gɔmo, bo kiyɔzɔ lïjë gbï di yayi. ");
INSERT INTO bex_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ŋere Bɔkoꞌba ose zïnnï te, “Ɔdɔ kuwöke dɔma laka ma ŋere Bɔkoꞌba ꞌbe koroke köꞌdu kiꞌdi ma ame ga mose ziye ne pili a mɔtɔ rɔ rɔkɔꞌɔ ma tönë ga moꞌde dɔ Ezipeto ne minza modɔ dɔye. Römöyï ma na rɔ Bɔkoꞌba bɔ yëyï ꞌba yida rɔye.” ");
INSERT INTO bex_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Di yayi na lïjë kënyï kari Elima bi ma ti daa teyi ꞌbutë dɔmorïyö ŋgërï mbere kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö kɔrɔ kpamo yayi. Kina lïjë koga taya ꞌbënnï ŋgï yayi ŋgɔsi kpa mini nima. ");
INSERT INTO bex_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Mï töꞌdö dɔ ꞌbutë döömu ꞌba nyepe ma mï rïyö di pötö tɔdɔ ꞌba dɔtumu ꞌba Yisarele naga nima yaga di mï Ezipeto na lïjë kënyï ŋgï pili dɔmo di Elima yayi kari mï mökö ꞌba Sini mï löŋgö Elima ni ma ti Sinayi. ");
INSERT INTO bex_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Di yï mökö ꞌdeni yayi na bilaka naga nima pili kebe ga tilende rɔ Musa ni ma ti Arona. ");
INSERT INTO bex_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Lïjë iya te, “Ma këddï kolake ze ra dölë eze di kpa közï Bɔkoꞌba mï Ezipeto dëne ëdï kele sowa. Doloma ŋgɔsi te dɔŋgila kete ꞌba yida donyo akonyo ame ga pili doꞌdɔkɔ ne. Ne kpe ari kugbëꞌduke gɔze koꞌdeke ze mï mökö bine zi ꞌbö tote dɔze.” ");
INSERT INTO bex_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kina Bɔkoꞌba kiya zi Musa te, “Ti miꞌdi maŋgolɔꞌbɔ kaꞌdi kako ziye di mïtɔrɔ. Kina ꞌdɔ bilaka pili kɔdɔ kari kutöꞌdu akonyo ꞌba mï kada dɔ kɔtɔ nima ŋge zïnnï. Ti miyɔzɔ lïjë kɔzɔ a nime te gɔ moŋgɔ ɔdɔ lïjë ti kuwö dɔma na ŋgï ya. ");
INSERT INTO bex_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mï töꞌdö dɔ modɔɔkɔtɔ lïjë ti kutöꞌdu kebe ma mï kada ma laki naga nima pili ŋbö mï rïyö.” ");
INSERT INTO bex_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kina Musa ni ti Arona kari kiya ŋgï zi Yisarele pili iya te, “Ti dɔkɔpiyari ti kikalike ŋgï ŋere Bɔkoꞌba na koꞌde ye di Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Mï dɔŋbɔ dayi ti koꞌjake tigɔ ꞌba Bɔkoꞌba ŋgï römöyï bo uwö lende ꞌbe ame këddï kilendeke rɔ bo ne ꞌdeni. Ze yë na ꞌdɔ kebeke tilende rɔze?” ");
INSERT INTO bex_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa ileki gbï zïnnï iya te, “Ti kikalike ŋgï rɔ ma laka ŋere Bɔkoꞌba ëdï kiꞌdi yida ziye mï dɔkɔpiyari tonyo mo. Kina bo ti kiꞌdi maŋgolɔꞌbɔ ziye mï dɔŋbɔ kɔzɔ ma koꞌdɔkɔke. Römöyï bo uwö lende ꞌbe ame këddï kilendeke rɔ bo ne ꞌdeni. Ze yë na? Lende ꞌbe nima inza kilendeke rɔze, tine ëddï kilendeke rɔ bo ŋere Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kina Musa kiya zi Arona te, “Iya zi Yisarele pili kako kɔmɔ ŋere Bɔkoꞌba römöyï bo uwö lende ꞌbënnï ma lïjë këdï kilende rɔ bo ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Koꞌja Arona këdï gba rɔ tilende zi Yisarele naga nima na lïjë kombi kömönnï kari yɔki mökö te na lïjë koꞌja bi nzari ꞌba rɔ Bɔkoꞌba ŋgï kiyɔpɔ mï pɔli ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Bɔkoꞌba iya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Muwö lende ꞌba Yisarele ma lïjë këdï kilende rɔma ꞌdeni. Iya zïnnï, mï bi pïpïrï lïjë ti konyo yida. Tine rɔ mï dɔŋbɔ lïjë ti kïtëkpë ti maŋgolɔꞌbɔ. Kina ti lïjë kikali ŋgï ma na rɔ ŋere Bɔkoꞌba ꞌbënnï.” ");
INSERT INTO bex_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Mï dɔkɔpiyari mo nima na matikpiri kako ŋgï kutuꞌbö taya ŋbuku. Tine mï dɔŋbɔ mo solɔrɔ na köyö ꞌdeni ŋgï kuru dɔ taya ꞌbënnï nima toko teyi. ");
INSERT INTO bex_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kina ɔdɔ solɔrɔ nima koya ꞌdeni na kola ŋgï rɔ a mɔtɔ kɔzɔ kulötu naga tara kora dɔ yayi ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tine ɔdɔ lïjë koꞌja tara lïjë ebe tititi rönnï iya te, “Waꞌdi ga na te?” Römöyï lïjë ikali dë waꞌdi mo ga na tara. Kina Musa kiya zïnnï te, “Maŋgolɔꞌbɔ mo tönë ŋere Bɔkoꞌba kiꞌdi ziye tonyo mo ne na. ");
INSERT INTO bex_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Lende ma bo kose mo na te, ‘Nï bɔ mɔtɔ utöꞌdu kɔꞌbɔ gɔ mïyï. Ɔdɔ këddïke ndö kpa liŋɔ ꞌbe utöꞌduke gbërë me rɔ kɔtɔkɔtɔ koriya ti gɔye.’” ");
INSERT INTO bex_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Yisarele oꞌdɔ ŋgï kɔzɔ ma kiya rönnï zïnnï nima tara. Mɔtɔ ga utöꞌdu ŋbaŋi tine ya mɔtɔ ga utöꞌdu ꞌbënnï ŋge mbowa. ");
INSERT INTO bex_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Tine ɔdɔ kebe ꞌböwu tiyari mo ti gbërë nï mɔtɔ ame ꞌbëyï pele mbiri oriya aa ti ꞌba bɔ ame kutöꞌdu ꞌbënï ŋge mbowa ne. Mɔtɔ utöꞌdu ŋgï kɔzɔ a ma mïyï koꞌdɔkɔ. ");
INSERT INTO bex_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kina Musa kose gɔmo zïnnï pili iya te, “Kinza nï mɔtɔ kikeki kɔsɔ mo dë köꞌdö ŋbö koda dɔŋbɔ.” ");
INSERT INTO bex_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tine ya mɔtɔ ga uwö dë ikeki kɔsɔ mo ŋbö koda ŋbɔ. Kina ɔdɔ bi këzë ŋbɔ dayi öyö kuru ꞌdeni kato dë kpe kele. Kina dökïꞌdï Musa kata ŋgï rönnï kɔzɔ ɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Rɔ kɔmɔ lëndö löbu nime pili, mɔtɔ ari kutöꞌdu ëꞌbï ŋgï zïyï kɔzɔ ma mïyï koꞌdɔkɔ. Tine ɔdɔ kada kata ꞌdeni kɔsɔ ma kileke mökö naga ebe kara ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Mï töꞌdö dɔ modɔɔkɔtɔ tine na bɔ kɔtɔ kutöꞌdu ŋgï ŋbö gbërë rïyö zïyï. Kina bɔ dönnï mo ga kako kiya lende mo zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kina bo kileki zïnnï, iya te, “Lende kiya ꞌba ŋere Bɔkoꞌba na te, ‘Tïlëndö kada ꞌba rɔ kindawo na, kada ma koro rɔ dɔ kiteli zö Bɔkoꞌba. Wa ame ga rɔ ꞌba tïlëndö ne uꞌdïke mɔlo tɔne. Kɔsɔ mo ame ga këdï ne olake koda tïlëndö.’” ");
INSERT INTO bex_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kina lïjë kola ŋgï köꞌdö koda bi këzë mɔtɔ kɔzɔ ame Musa kiya zïnnï ne tara. Tine ato dë gbï ala köyö kuru. ");
INSERT INTO bex_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mï dɔŋbɔ mo nima na Musa kiya zïnnï te, “Onyoke ti yaga tɔne römöyï tɔne kada ꞌba rɔ kindawo na zi Bɔkoꞌba inza koꞌjake ɔtɔ kpe bërï. ");
INSERT INTO bex_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ziye tutöꞌdu mo ŋge mï töꞌdö dɔ modɔɔkɔtɔ. Tine mï töꞌdö dɔ modɔmorïyö ame rɔ kada ꞌba rɔ kindawo ne inza koꞌjake ɔtɔ.” ");
INSERT INTO bex_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Tine pele ya mɔtɔ ga ënyï ꞌbiri mï töꞌdö dɔ modɔmorïyö mo nima kari toŋgɔ bi mo. Tine lïjë ari koꞌja ɔtɔ kinza. ");
INSERT INTO bex_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kina Bɔkoꞌba kiya zi Musa te, “Ti köꞌböke tilagi köꞌdu kiꞌdi ma ti ndose ma ŋbö nyanya? ");
INSERT INTO bex_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Iꞌdike këdï dɔye ma Bɔkoꞌba moza kada ꞌba rɔ kindawo ꞌdeni yaga ziye na ma ꞌdɔ mï töꞌdö dɔ modɔɔkɔtɔ miꞌdi ye kutöꞌduke akonyo ꞌba kada dɔ rïyö ꞌdo ne. Mï kada ꞌba rɔ kindawo nï mɔtɔ zïyï toloma gɔ bi ꞌbï ma këddï teyi. Bɔtɔ kɔdɔ dë yaga.” ");
INSERT INTO bex_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Mï töꞌdö dɔ modɔmorïyö na bilaka kindawo rönnï ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Yisarele ïdëkï möyï maŋgolɔꞌbɔ ꞌbënnï nima rɔ mani. Wa aŋmi ŋgï kɔzɔ kölu kaŋmi naga tara tine rɔ ma kindili kɔzɔ lëmbërë ma koŋma ti tagi gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa iya te, “Ame na rɔ ndose ꞌba Bɔkoꞌba, ‘Ogba gbërë kɔtɔ ꞌba mani ꞌdɔ kikeki zi dɔ kupö ye ma di yïꞌböwu naga nima ꞌdɔ lïjë koꞌja kïnë maŋgolɔꞌbɔ ma, ma Bɔkoꞌba moloma tiꞌdi mo ziye di yï mökö mï kada ma moꞌde ye di Ezipeto.’” ");
INSERT INTO bex_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kina Musa kilende zi Arona iya te, “Ogba kete kodɔ gbërë ꞌba mani yïmo ꞌdɔ kutë gɔ bi ꞌba tumötu ŋere Bɔkoꞌba ꞌdɔ kikeki koda dɔ kupö ze ga ma di yïꞌböwu.” ");
INSERT INTO bex_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kina kɔzɔ wa ame Bɔkoꞌba kose ꞌdeni zi Musa ne tara, Arona ogba mani nima ŋgï kïdëyï kɔmɔ sandu koro ꞌba köꞌdu kiꞌdi yayi tikeki mo. ");
INSERT INTO bex_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Yisarele onyo mani ŋbö kɔmɔ kɔɔ ꞌbutë sowɔ ŋbö lïjë kari kömö dɔyayi ma lïjë këdï kari koloma teyi mo tönë. Lïjë ako ti tonyo mani ŋbö lïjë kömö timo kpa dɔ maga ꞌba Kanana. ");
INSERT INTO bex_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Gbërë ꞌbënnï mo naga nima ꞌbutë na këdï koso mï löꞌdï. ");
INSERT INTO bex_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kina Yisarele pili kënyï ŋgï dɔmo di mökö ꞌba Sini yayi kari nduwë rɔ ma kolɔlɔ kɔzɔ ma Bɔkoꞌba kose zïnnï. Lïjë ari koga taya Rapidimi, tine mini ari kinza ꞌböwu bi mo. ");
INSERT INTO bex_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kina lïjë kebe ŋgï tamo ti Musa iya te, “Iꞌdi mini zize duwë.” Musa ileki dɔmo zïnnï iya te, “Ëddï kamoke tö gɔ waꞌdi? Gɔ waꞌdi na këddï kiyɔzɔke ŋere Bɔkoꞌba te?” ");
INSERT INTO bex_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tine koda oꞌdɔ lïjë ꞌdeni ŋgï sowa na lïjë koloma ŋgï rɔ tamo ti Musa, iya te, “Gɔ waꞌdi na kari kugbëꞌdu gɔze koꞌde ze di Ezipeto ꞌdɔ dëdï dölë ꞌdeni dote dɔze mï mökö te ti bɔyi titi ze ga kpaki ti yërï ze ga?” ");
INSERT INTO bex_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kina Musa kudu zi Bɔkoꞌba, iya te, “ꞌDɔ moꞌdɔ tondo zi bilaka naga nime? Lïjë ꞌdeni ŋgï ndö ꞌdɔ tuꞌdu ma ti döku.” ");
INSERT INTO bex_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Bɔkoꞌba ënyï kileki dɔmo zi Musa iya te, “Ari dɔgba kɔmɔ Yisarele naga nima. Ogba bulöbu ꞌbënnï mɔtɔ mo ga tïyï. Kina ogba përï ꞌbï tönë komba dɔ yöpö timo ne tïyï. ");
INSERT INTO bex_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ari. Ti mɔrɔ dɔgba zïyï yayi ŋgila döku mɔtɔ di Sinayi. Omba yɔki mo kina ti mini kɔdɔ ŋgï di yïmo zi bilaka tuwë mo.” Kina Musa kari koꞌdɔ ŋgï kɔzɔ a nime te di kɔmɔ löbu ꞌba Yisarele naga nima pili. ");
INSERT INTO bex_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kina Musa koyi möyï bi nima ŋgï rɔ Masa ame kiya te “Iyɔzɔ” gbï rɔ Meriba ame kiya te “Lamo” römöyï bi nima na Yisarele kamo ti Musa di teyi kiyɔzɔ Bɔkoꞌba koloma tititi mo, iya te, “Bɔkoꞌba ëdï ŋgï tize na ala bo inza?” ");
INSERT INTO bex_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Koꞌja Yisarele këdï koloma Rapidimi yayi na Amaleke kalo ya ŋgï dönnï. ");
INSERT INTO bex_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa iya zi Yësuwa te, “Ogba bilaka tïyï kari koꞌdɔ ya ti Amaleke naga nime tïlëndö. Mëdï mari ma ꞌbama mɔrɔ dɔ döku tɔrɔ ti përï tönë Bɔkoꞌba kose zö ꞌdɔ mombi ne.” ");
INSERT INTO bex_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yësuwa oꞌdɔ ŋgï kɔzɔ ma Musa kiya zi bo kari toꞌdɔ ya ti Amaleke naga nima. Tine Musa ni ti Arona ti Uru ari këkï ga ma ꞌbënnï tɔrɔ dɔ döku. ");
INSERT INTO bex_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ɔdɔ Musa kombi közï bo tɔrɔ na Yisarele kiꞌdi ŋgï taꞌda bɔ ya ꞌbënnï Amaleke naga nima. Tine ɔdɔ bo kileki közï bo bërï na Amaleke naga nima kuyï ŋgï ꞌböwu gburu tïnnï ꞌdɔ taꞌda lïjë. ");
INSERT INTO bex_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kina ɔdɔ kɔnyɔ Musa kidaki ꞌdeni Arona ni ti Uru oꞌde döku ŋgï kiꞌdi bo koloma dɔmo lïjë kɔrɔ ꞌbënnï ŋgila bo togbɔ kɔnyɔ bo köꞌbö tɔrɔ ŋbö kada kösö. ");
INSERT INTO bex_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kina Yësuwa kaꞌda Amaleke naga nima ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kina ŋere Bɔkoꞌba kiya zi Musa te, “Akaꞌda nime ugu bërï ꞌdɔ köꞌbö kinza kudölu. Iya gɔmo zi Yësuwa. Ma Bɔkoꞌba mëdï mote dɔ Amaleke naga nima pili yaga.” ");
INSERT INTO bex_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa oꞌba bi ꞌba akumu yayi bo kiꞌdi möyï mo rɔ “Bɔkoꞌba na rɔ bero ma.” ");
INSERT INTO bex_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Bo iya te, “Ombike bero ꞌba Bɔkoꞌba ŋbö tɔrɔ. Bo ti köꞌbö toꞌdɔ ya nduwë ti Amaleke rɔ ŋburuŋburu.” ");
INSERT INTO bex_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetoro bɔ akumu ꞌba Midiyana bɔ lanzo Musa tönë uwö lende ꞌba wa ame ga Bɔkoꞌba koꞌdɔ zi Musa gbï ti bilaka abo ga Yisarele ne ꞌdeni. Kina bo uwö ꞌdeni gbï ma Bɔkoꞌba koja Yisarele ꞌdeni yaga di mï dɔyayi ꞌba Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kina bo kako ŋgï koꞌde gɔ nyiti abo Zipora ꞌja ꞌba Musa mo tönë bo koja ꞌdeni pa kari zi bɔ lanzo bo yayi bine ne ");
INSERT INTO bex_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","4","ti kole rïyö mo tönë ga Geresomo ni ti Elizara. Musa iꞌdi möyï kole abo mɔtɔ nima rɔ Geresomo ame kiya te “Bɔ löwö” römöyï bo iya te, “Ma moloma ꞌdeni rɔ bɔ löwö mï dɔyayi löwö.” Kina bo kiꞌdi möyï mɔtɔ mo nima rɔ Elizara ame kiya te “Bɔkoꞌba okɔnyi ma ꞌdeni” römöyï bo omeri bo iya te, “Bɔkoꞌba ꞌba ꞌbu ma ni na rɔ bɔ kɔnyi ma. Bo ɔmɔ ma ꞌdeni di kpa kulu ꞌba bɔ dɔliŋɔ ꞌba Ezipeto.” ");
INSERT INTO bex_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetoro ni ti nyiti abo ti kole mo naga nima ako kota Musa ni koga taya ꞌdeni mï mökö ŋgɔsi ŋgila döku koro ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Musa uwö gɔ kose ꞌba Yetoro ni ma lïjë këdï kako ꞌdeni mɔlo na bo kari ");
INSERT INTO bex_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ŋgï turë dönnï. Bo ari kudë dɔ bo bërï kɔmɔ bɔ lanzo bo, bo kiramo na lïjë koloma ŋgï rɔ tumötö rönnï. Kina bo koꞌde lïjë ŋgï liŋɔ mï bi loma ma ꞌba bo. ");
INSERT INTO bex_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Kina Musa koloma ŋgï rɔ tïyëtï gɔ wa ame ga Bɔkoꞌba koꞌdɔ zi Ezipeto gbï ti bɔ dɔliŋɔ ꞌbënnï mo gɔ lende ꞌba bilaka abo ga Yisarele ne ŋgï zi bɔ lanzo bo Yetoro kina gbï ti gomɔ ame ga koꞌja lïjë di gɔ kɔri ti ma Bɔkoꞌba kokɔnyi lïjë di yïmo. ");
INSERT INTO bex_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetoro ŋgï ti mï këyï di bi tuwö lende laka nime Bɔkoꞌba koꞌdɔ ꞌdeni zi Yisarele kɔmɔ, koja yaga di mï Ezipeto ne. ");
INSERT INTO bex_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetoro iya te “Akïlëlu këdï zi bo Bɔkoꞌba bɔ kɔmɔ ye di kpa közï Ezipeto ti bɔ dɔliŋɔ ꞌbënnï mo. Akïlëlu këdï zi bo Bɔkoꞌba ame bo kɔmɔ bilaka abo ga Yisarele ꞌdeni di mï loma rɔ atɔli ne. ");
INSERT INTO bex_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Rɔ ma laka mikali ꞌdeni bo ŋere Bɔkoꞌba na rɔ dɔ kiteli kebe akoro ni pili. Römöyï bo ileme wa ꞌdeni zi Ezipeto bɔ koꞌdɔ kpɔŋi rɔ bilaka abo tönë ga.” ");
INSERT INTO bex_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Kina Yetoro koꞌde akoŋma ŋgï gbï ti a mɔtɔ ga tumu mo zi Bɔkoꞌba. Kina Arona ni ti löbu ꞌba Yisarele mɔtɔ ga kari ŋgï tonyo akonyo koro nima kɔtɔ ti bo kɔmɔ Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mï bi këzë ma di gɔmo na Musa kutë kïtï abo ŋgï toꞌdɔ burë ꞌba bilaka ma kirasi lende naga. Kina bo koto ŋgï tara ŋbö kada kösö dɔ bo. ");
INSERT INTO bex_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kina ɔdɔ bɔ lanzo bo Yetoro koŋgɔ lende nima ꞌdeni tara tine, bo ititi Musa iya te, “Waꞌdi ga na këddï koꞌdɔ tara? Gɔ waꞌdi na nï ŋge kɔtɔ kutu yï bi toꞌdɔ burë kiꞌdi bilaka konzi naga nime këdï kolɔꞌbɔ ŋbö kada kösö dɔmo?” ");
INSERT INTO bex_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa ileki zi bo, iya te, “Römöyï bilaka naga nime lïjë ako zö toma akoꞌdɔkɔ ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ɔdɔ mɔtɔ ga këdï ti lende mbowa mï löŋgö nnï na ma ga këdï koꞌde zö ꞌdɔ modɔrɔ ndïmo zïnnï mïyëtï gɔ ndose ti köꞌdu kiꞌdi ꞌba Bɔkoꞌba zïnnï.” ");
INSERT INTO bex_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Bɔ lanzo bo Yetoro ileki dɔmo zi bo, iya te, “Wa nima këddï koꞌdɔ ne ele dë. ");
INSERT INTO bex_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Loma nima ëdï kodɔ gomɔ rɔye kïyëndë ye. Ndɔbɔ nima ïrïndï sowa. Ɔꞌbɔ dë ŋge zi bɔ kɔtɔ na ꞌdɔ koꞌdɔ kutu nï. ");
INSERT INTO bex_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Uwö lende ꞌbama ma mëdï miya zïyï. Bɔkoꞌba koloma kɔtɔ tïyï, nï ꞌbëyï oloma ŋge rɔ bɔ kɔmɔ bilaka naga nima mï löŋgö lïjë ti Bɔkoꞌba toꞌde lende ꞌbënnï kɔmɔ bo. ");
INSERT INTO bex_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Iyandi bilaka naga nima ti ndose ti köꞌdu kiꞌdi ꞌba Bɔkoꞌba kileme loma ma laka zïnnï ti a ma gɔ lïjë koꞌdɔ. ");
INSERT INTO bex_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tine igeli ya mɔtɔ ga di mïnnï rɔ ya ame ga bilaka kiꞌdi dönnï gɔ lende mo gbï rɔ bɔ koro Bɔkoꞌba ne koꞌdɔkɔ a mɔtɔ rɔ kɔmɔ kugö dë gbï, gɔ koza lïjë këdï rɔ bɔ dɔtumu ꞌba bilaka ma kuluku ꞌbutë rïyö ti ma kuluku rïyö ti ma kuluku kɔtɔ ti ma ꞌbutë. ");
INSERT INTO bex_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Lïjë na gɔ këdï rɔ bɔ koꞌdɔ burë ꞌba bilaka, tine lende ma kïrïndï kaꞌda lïjë naga na ꞌjaa ꞌdɔ koꞌde zïyï. Ma mbowa naga lïjë kote yayi ꞌdɔ kiꞌdi röyï kawo. Lïjë kokɔnyi yi kombi akïrïndï nima mbowa yaga di döyï. ");
INSERT INTO bex_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ɔdɔ koꞌdɔ ŋgï te kina ɔdɔ këdï rɔ ndose abo ꞌba Bɔkoꞌba mo gomɔ inza kɔdɔ kulöwö röyï. Kina gbï bilaka pili ti kileki ŋgï liŋɔ ꞌbënnï ga ti mï këyï.” ");
INSERT INTO bex_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa uwö lende kiya ꞌba bɔ lanzo bo nime na bo koꞌdɔ ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Bo oŋgɔ bilaka ma laka naga di mï löŋgö Yisarele koza rɔ bɔ dɔtumu ꞌba bilaka ma kuluku ꞌbutë rïyö, ma kuluku rïyö, ma kuluku kɔtɔ ti ma ꞌbutë. ");
INSERT INTO bex_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Lïjë na koloma nati rɔ bɔ toꞌdɔ burë ꞌba bilaka. Lende ma kitigɔ naga na ꞌjaa koto kari dɔgba zi Musa, tine ma mbowa naga lïjë ote ŋgï yayi. ");
INSERT INTO bex_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kina Musa koto gɔ bɔ lanzo bo Yetoro ŋgï kɔri bo kileki kari mï dɔyayi ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Mï mota ꞌba nyepe ꞌbënnï ꞌba Yisarele ma lïjë kɔdɔ timo yaga di mï Ezipeto mï töꞌdö ma dɔndende ꞌba nyepe mo nima na rɔ tömö ꞌbënnï Sinayi. ");
INSERT INTO bex_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Di pötö tënyï ꞌbënnï di Rapidimi kako mï mökö ŋgila dɔ döku Sinayi na lïjë koga taya ŋgï yayi. ");
INSERT INTO bex_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Kina Musa këkï ŋgï kari tɔrɔ dɔ döku tilende ti Bɔkoꞌba. Kina Bɔkoꞌba kïdëkï bo di dɔ döku tɔrɔ yayi, iya te, “Ari kiya kɔzɔ a nime te zi Yisarele kupö eꞌbe Yakoba naga nima, ");
INSERT INTO bex_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Kpe, oꞌjake wa ma moꞌdɔ zi Ezipeto ꞌdeni ti kɔmɔye. Kina oꞌjake ꞌdeni gbï ma mombi ye kɔzɔ yagi tara dɔ kakala ma moꞌde ye zö. ");
INSERT INTO bex_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ɔdɔ kiya te kuwöke dɔma ŋgï kindaꞌbake lömu ma nime tiye ne, kpe na ti këddïke rɔ a löbu zö di mï löŋgö bilaka konzi ꞌba dɔliŋɔ nime. Dɔliŋɔ nime pili a ma na. ");
INSERT INTO bex_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Tine kpe ti këddïke zö rɔ ꞌbama ga ame moweli ꞌdeni rɔ bɔ akumu ma.’ Lende naga nime ari timo kiya zïnnï lïjë Yisarele.” ");
INSERT INTO bex_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kina Musa kileki ŋgï kako kotɔtɔ dɔ bulöbu ꞌba Yisarele pili bërï kora gɔ lende naga nime Bɔkoꞌba kose ne teyi. ");
INSERT INTO bex_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Kina lïjë pili kutï ŋgï gɔmo, iya te, “Wa ame ga pili ŋere Bɔkoꞌba kose ne ti doꞌdɔ ŋgï tara.” Kina Musa kuyï dɔ bo ti kpënnï nima kari kïyëtï zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Bɔkoꞌba ileki zi Musa, iya te, “Mëdï mako ziye yayi mï zana pɔli ma këddï, ꞌdɔ bilaka naga nima kuwö ma mëdï milende tïyï gɔ lïjë kiꞌdi dönnï gɔ lende ꞌbï.” Kina Musa kileki kïyëtï gɔ wa ame bilaka naga nima kiya ne ŋgï zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kina Bɔkoꞌba kiya zi bo te, “Ari kileŋo bilaka naga nima ndö rɔ ma kɔpɔ kisaki di mï tɔne gbï tïlëndö. Iꞌdi lïjë kurögö bɔŋgɔ ꞌbënnï ga lïjë kiyada rönnï ndö ");
INSERT INTO bex_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","koda töꞌdö dɔ mota mo nima. Römöyï mï kada mo nima ma ŋere Bɔkoꞌba mëdï mako bërï dɔ döku ꞌba Sinayi kɔmɔ Yisarele pili te. ");
INSERT INTO bex_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tine iya gɔmo zïnnï koꞌdɔ maga zïnnï kinza bɔtɔ kese dë kulöwö ŋgɔsi ꞌde ŋgila döku nime. Iya zïnnï, kinza lïjë këkï dë dɔmo ala kosa ndïmo ma di bërï. Bɔtɔ ame kosa rɔ döku nima, kupö ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Uꞌdu bo yaga ti döku mɔtɔga koꞌbe bo ti kɔmo, kinza bɔtɔ kosa rɔ bo dë ti közïnï. Rɔ gɔ wa ame ga pili kosa rɔ döku nima, ala bo rɔ yërï ala bilaka lesi, kupö ŋgï yaga. Tine ɔdɔ kiya te kome mï tɔtɔti ꞌdeni rɔ ma kembe na ꞌjaa ꞌdɔ bilaka naga nima këkï tɔrɔ dɔ döku bine.” ");
INSERT INTO bex_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kina Musa kileki kari kiꞌdi bilaka tönë ga ŋgï kileŋo rönnï, lïjë kurögö bɔŋgɔ ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Bo iya zïnnï gɔ lïjë këdï ndö rɔ ma kɔpɔ mï töꞌdö ma rɔ dɔ mota mo. Kinza bɔtɔ köꞌdö dë ti ꞌja. ");
INSERT INTO bex_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mï dɔŋbɔ ꞌba töꞌdö ma rɔ dɔ mota mo nima yɔ na birɔ tɔrɔ këbï ti tɔrɔ kapi kudu ŋgï pɔli ma këddï koꞌboli dɔ döku tönë ŋgï. Kina kome tɔtɔti ŋgï rɔ ma kembe, bilaka ame ga pili mï taya yayi ne rɔmo kebe ŋgï tïlëꞌdï. ");
INSERT INTO bex_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kina Musa kösö ŋgï dɔgba zïnnï tari turë dɔ Bɔkoꞌba lïjë kari kɔrɔ ndï döku bërï yayi. ");
INSERT INTO bex_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Döku kïdëkï rɔ Sinayi mo nima kötu utuꞌbö dɔmo ꞌdeni ŋgï ŋbuku römöyï Bɔkoꞌba ëkï ꞌdeni kako dɔmo yayi mï paꞌdo. Kötu anyo ŋgï di dɔmo kɔzɔ kötu ꞌba lïndï döku löbu nima kiyaya rönï ŋgï pili rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kina birɔ tɔtɔti mo tönë koŋbeki bi ŋgï nati nduwë rɔ dɔ kiteli. Musa ilende, kina birɔ mugu Bɔkoꞌba kudu ŋgï kileki dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Bɔkoꞌba ëkï kako dɔ döku ꞌba Sinayi tɔrɔ yayi na bo kïdëkï Musa ŋgï kari zi bo. Musa ëkï kari tɔrɔ yayi ");
INSERT INTO bex_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","na Bɔkoꞌba kiya zi bo te, “Ëkï kileki bërï kiya zïnnï lïjë bilaka naga nima kinza bɔtɔ kese dë kako ŋgɔsi ndï döku tëgë toŋgɔ ma Bɔkoꞌba. Ame kako ti kölë yaga. ");
INSERT INTO bex_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ya ame ga pele rɔ bɔ akumu këdï kese ŋgɔsi ŋgila ma ne lïjë kileŋo rönnï kɔpɔ kinza modɔ karama dönnï.” ");
INSERT INTO bex_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa ileki zi Bɔkoꞌba, iya te, “Lïjë inza këkï tɔrɔ dɔ döku bine römöyï ose gɔmo ꞌdeni mɔlo zïnnï koꞌdɔ maga ꞌdeni mɔlo kpa bi ꞌbï ame koweli ꞌdeni rɔ ma koro ne.” ");
INSERT INTO bex_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Bɔkoꞌba iya te, “Ëkï kileki bërï kari koꞌde Arona tïyï tɔrɔ bine. Tine kinza bɔ akumu ni ti bilaka ma laki naga nima kumu dɔ maga nima dë tako zö bine kinza modɔ karama dönnï.” ");
INSERT INTO bex_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kina Musa këkï ŋgï kileki kari bërï zi bilaka naga nima kïyëtï gɔ wa ame ŋere Bɔkoꞌba kiya zïnnï ne. ");
INSERT INTO bex_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kina Bɔkoꞌba koloma ŋgï rɔ tiya lende naga nime zïnnï te, ");
INSERT INTO bex_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ma na rɔ ŋere Bɔkoꞌba ꞌbe ame koja ye yaga di mï Ezipeto di mï loma rɔ atɔli. ");
INSERT INTO bex_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Kinza koꞌdɔke a mɔtɔ dë rɔ Bɔkoꞌba ziye ꞌberi di gɔma. ");
INSERT INTO bex_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Kinza koꞌdɔke a mɔtɔ dë rɔ akoro ziye kɔzɔ kïnë a mɔtɔ ame mïtɔrɔ ala mï dɔyayi bërï bine ala mï mini löbu tara. ");
INSERT INTO bex_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kina kinza kolɔdɔke dë bërï kulömuke kpeye zïnnï. Römöyï ma ŋere Bɔkoꞌba ꞌbe ma ti mï kombi gɔye. Ti modɔ karama ꞌba lende kënyë dɔ ꞌbu ma koꞌji ma naga kala gɔ kole mo ga ma mï mota ŋbö kala gɔ ma mï sowɔ mo ga. ");
INSERT INTO bex_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Tine ti mileme akɔꞌɔ ma zi dɔ kupö ma konzi ame ga kɔꞌɔ ma koro köꞌdu kiꞌdi ma gbï ne. ");
INSERT INTO bex_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Kinza kirasi möyï ma ŋere Bɔkoꞌba ꞌbï dë rɔ ma sari mï lende kënyë. Römöyï bɔtɔ ame kirasi möyï ma ŋere Bɔkoꞌba mï lende kënyë ne minza mola du tara di bi todɔ karama dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Töꞌdö ꞌba kada ꞌba rɔ kindawo iꞌdi këdï döyï zïyï rɔ töꞌdö ma koro gbï kɔtɔ laka. ");
INSERT INTO bex_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Oꞌdɔ ndɔbɔ ꞌbï ga ŋge mï töꞌdö dɔ modɔɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Tine töꞌdö dɔ modɔmorïyö mo nima kada ꞌba rɔ kindawo na zö ma ŋere Bɔkoꞌba. Mï kada mo nima kinza kosa ndɔbɔ mɔtɔ dë. Nï gbagba yï mo ala kole ꞌbï ala nyiti ꞌbï ala atɔli ꞌbï ga ala yërï ꞌbï ga ala bɔtɔ ma rɔ bɔ löwö ame këdï tïyï liŋɔ ne kinza kosa ndɔbɔ mɔtɔ dë. ");
INSERT INTO bex_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Römöyï mï töꞌdö dɔ modɔɔkɔtɔ na ma Bɔkoꞌba mote toꞌba mïtɔrɔ ni yïmo ti dɔyayi ti mini löbu ni pili ti wa mo ga ame yïmo ne. Tine ma Bɔkoꞌba mindawo rɔma mï töꞌdö ma rɔ dɔ modɔmorïyö mo. Kina me mulömu töꞌdö dɔ modɔmorïyö ꞌdeni miꞌdi këdï rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Oro ꞌbu yï ni ti möyï. Römöyï ꞌdɔ koloma göyï kɔwɔ mï dɔyayi nime ma ŋere Bɔkoꞌba ꞌbï miꞌdi zïyï ne. ");
INSERT INTO bex_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Kinza koꞌdɔ röyï dë rɔ bɔ közï roma. ");
INSERT INTO bex_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Kinza koꞌdɔ yërï dë. ");
INSERT INTO bex_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Kinza koꞌdɔ ꞌbögö dë. ");
INSERT INTO bex_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Kinza kunzö lende dë rɔ bëtï kpa lëpï yï mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Kinza kombi mïyï dë rɔ liŋɔ ꞌba lëpï yï mɔtɔ. Kinza kombi mïyï dë rɔ ꞌja abo ala rɔ atɔli abo ala rɔ ŋgulö sa abo ala rɔ akaca abo ala rɔ ɔtɔ ame ga pili rɔ abo ne.” ");
INSERT INTO bex_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Kina ɔdɔ bilaka naga nima koꞌja tɔrɔ këbï ti ma kapi mo nime ꞌdeni lïjë kuwö birɔ tɔtɔti kötu kanyo kutuꞌbö dɔ döku ꞌdeni tara tine na rönnï kebe ŋgï tïlëꞌdï di zi tikere. Lïjë ɔrɔ ŋbö rɔ ma kɔwɔ ");
INSERT INTO bex_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","kiya zi Musa te, “Nï mo na ŋge doꞌdɔkɔ gɔ kilende zize, Musa. Ti duwö döyï. Tine kinza kiꞌdi Bɔkoꞌba na dë kpe kako kilende zize kinza dölë.” ");
INSERT INTO bex_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa ileki zïnnï te, “Kinza kereke dë. Bɔkoꞌba ako tiyɔzɔ ye gɔ tikere abo këdï mïye kitata ye di mï toꞌdɔ lende kënyë.” ");
INSERT INTO bex_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Bilaka naga nima ileke ꞌbënnï ŋbö rɔ ma kɔwɔ. Musa na ŋge kese kari ŋgila bi kölu kɔzɔ pɔli nima Bɔkoꞌba këdï yïmo ne. ");
INSERT INTO bex_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kina Bɔkoꞌba kilende zi Musa, iya te, “Ari kiya zïnnï Yisarele te, ‘Kpe, oꞌjake ꞌdeni ti kɔmɔye ma milende ziye di mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kinza koꞌdɔke ɔtɔ mɔtɔ dë kpe rɔ Bɔkoꞌba ziye ꞌberi di gɔma di mï sïtërï ala di mï yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Yayi na koꞌbake rɔ bi ꞌba toŋma akumu zö ꞌdɔ koŋmake akumu ꞌbe ga dɔmo zö. Yërï ma këdï koŋma pili koꞌdo ti ma këdï koŋma ŋge rɔ bi koro mo naga gɔ koŋmake zö dɔmo. Gɔ bi ame pili migeli ꞌdeni ziye tïdëkï möyï ma di teyi ti mako ŋgï moꞌdɔ yëyï dɔye. ");
INSERT INTO bex_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ɔdɔ këddï koꞌbake bi ꞌba akumu zö ti döku kinza koꞌbake dë ti döku ame ga kïtëꞌdï dɔ kpamo ne. Römöyï ɔdɔ kosa rɔmo ꞌdeni ti jama irasi ꞌdeni yaga rɔ tiꞌda di zö. ");
INSERT INTO bex_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tine kinza koꞌbake bi ꞌba akumu dë zö ti bi tëkï teyi. Römöyï ɔdɔ këddï kombi ndïyï tëkï dɔmo a titi ꞌba röyï ga ti kebe kinda za ꞌböwu yaga pili dɔmo.’ ");
INSERT INTO bex_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ame na rɔ köꞌdu kiꞌdi ma, ma Bɔkoꞌba, gɔ nï Musa kiꞌdi zïnnï lïjë Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ɔdɔ nï mɔtɔ kugö Ebere rɔ atɔli zïyï, iꞌdi bo koꞌdɔ ndɔbɔ ŋge zïyï kɔmɔ kɔɔ modɔɔkɔtɔ. Tine mï modɔmorïyö ꞌba kɔɔ mo nima ope bo kari abo kinza topi ɔtɔ zïyï gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ɔdɔ koꞌde bo ŋge kɔtɔ kutu bo, iꞌdi bo gbï kileki kari abo kutu bo. Ne ɔdɔ bo kako mɔlo ti ꞌja abo iꞌdi bo kari timo. ");
INSERT INTO bex_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ne ɔdɔ kiya te nï na ꞌjaa kogbe ꞌja zi bo, kole ti yïtö ma bo köyö nima kpaki ti ꞌja mo ëꞌbï na, ogba yaga iꞌdi bo kari abo ŋge kutu bo. ");
INSERT INTO bex_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ne ɔdɔ bo kiya ti kpa bo te lende ꞌba kole abo ga ti ꞌja abo ɔꞌɔ rɔ bo, bo koꞌdɔkɔ yi löbu abo nima gba nduwë, ");
INSERT INTO bex_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","nï bɔ dɔ bo mo nima oto bo kari rö ꞌba Bɔkoꞌba kiꞌdi bo kɔrɔ gɔ kpadörï ala lëꞌbërë kumö mbili bo. Kina gɔ bo köꞌbö ŋgï nati ŋburu rɔ atɔli zïyï. ");
INSERT INTO bex_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Nï mɔtɔ ɔdɔ bɔ mo kugö nyiti abo zïyï rɔ atɔli kinza kope dë kpe kola kari kɔzɔ ꞌba bɔtɔni. ");
INSERT INTO bex_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Tine ɔdɔ lɔko na kari kele dë kömöyï rɔ ꞌja nï bɔ kugö nï mo nima iꞌdi ꞌbu nï kutë gönï yaga di zïyï rɔ tutë. Kinza kebe kugö nï dë zi bɔ löwö römöyï ɔdɔ koꞌdɔ tara irasi lende ꞌdeni ti a nima koꞌdɔ zïnï ne. ");
INSERT INTO bex_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Tine ɔdɔ kiteri nï mɔlo rɔ ꞌja zi kole ꞌbï, indaꞌba nï laka kɔzɔ nyiti ꞌbï tara. ");
INSERT INTO bex_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Nï mɔtɔ ɔdɔ kebe kogbe ꞌja mɔtɔ ꞌböwu kinza kiꞌdi ꞌja ꞌbï ma dɔgba nima kileri ɔtɔ mɔtɔ dë pele rɔ akonyo ni ti bɔŋgɔ ꞌba rönï gbï ti akoꞌdɔkɔ ame tönë koloma pa toꞌdɔ mo zïnï ne. ");
INSERT INTO bex_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ɔdɔ koꞌdɔ a mota naga nime dë zïnï lɔko kënyï ëꞌbënï yaga. Kina kinza kopi ɔtɔ dë gbï zïyï. ");
INSERT INTO bex_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Bɔtɔ ame kupö bilaka ne, kupö bo gbï yaga. ");
INSERT INTO bex_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ne ɔdɔ kiya te közï bo na kɔmɔ rɔ tɔmɔ rɔmo bo kiriŋa abo kari mï bi ame ma Bɔkoꞌba na mileme ziye ne. ");
INSERT INTO bex_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ne bɔ ame kupö bilaka ŋgï ti lende ꞌba mï bo kinza közï bo na dë kɔmɔ rɔmo ne, otoke bo yaga ala pele di ŋgila bi ꞌba akumu ma kupöke bo yaga. ");
INSERT INTO bex_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Bɔtɔ ame komba ꞌbu bo ni ti ma bo kupö bo yaga. ");
INSERT INTO bex_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Bɔtɔ ame kindaꞌba lëpï bo mɔtɔ rɔ ꞌbɔki ꞌdɔ tugö mo mökö ala kogba rɔ atɔli ne kupö bo yaga. ");
INSERT INTO bex_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Bɔtɔ ame kulömu ꞌbu bo ni ti ma bo ne, kupö yaga. ");
INSERT INTO bex_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Ɔdɔ ya mɔtɔ ga kamo lïjë komba rönnï koga dɔ bɔ ma kɔtɔ ti közï ala ti döku bɔ mo kölë dë, bɔ lamba nima inza ti a mɔtɔ ꞌdɔ koꞌdɔ teyi. Tine bo koŋgɔ ŋge rɔ gɔ bɔ ma bo koga dɔmo nima bo kopi dɔ töꞌdö ame ga bɔ nime koꞌdɔ bërï di kpa ndɔbɔ ne. Bo koŋgɔ gɔ bɔ nima ŋbö rɔmo kele kokɔkɔ rönï. ");
INSERT INTO bex_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Bɔtɔ ame komba atɔli abo ti ŋgërï kulöku ŋgï kölë közï bo ne, odɔ karama dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ne ɔdɔ atɔli mo nima kënyï di dɔ lamba nima mï töꞌdö dɔ kɔtɔ ala dɔ rïyö kinza kodɔ karama dë dɔ bo römöyï atɔli abo na. ");
INSERT INTO bex_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ɔdɔ ya mɔtɔ ga ame këdï komba ga rönnï ne közïmo kɔmɔ rɔ ꞌja kɔmɔ, na ɔdɔ ꞌja mo nima koja kole ŋgï yaga tine ɔtɔ kosa rönï dë, lïjë bɔtɔ mo naga nima kopi wa ame mëꞌdë ꞌba ꞌja nima kiteri di zïnnï burë kutï ꞌdeni gbï gɔmo ne. ");
INSERT INTO bex_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ne ɔdɔ kiya te wëtö këdï rɔ ꞌja nima topi mo kɔzɔ wa ame lïjë koꞌdɔ ne. Ala rɔ tölë dɔmo konyo gbï ti tölë. ");
INSERT INTO bex_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ɔdɔ këdï rɔ kɔmɔ gbï ti kɔmɔ, kiliŋba kpa gbï ti kiliŋba kpa, kɔnyɔ dɔmo konyo gbï ti kɔnyɔ, ndï gbï ti ndï, ");
INSERT INTO bex_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","tilaŋma gbï ti tilaŋma, wëtö gbï ti wëtö, kina tïbï gbï ti tïbï. ");
INSERT INTO bex_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ɔdɔ bɔ mo komba atɔli abo kitikɔ kɔmɔ mo bo kope ŋgï kola kari kpa dɔkolo kɔmɔ mo nima bo kitikɔ ꞌdeni ne. ");
INSERT INTO bex_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kina ɔdɔ bo kotɔ rɔ kpamo gbï tara bo kope ŋgï kola kari. ");
INSERT INTO bex_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ɔdɔ ŋgulö sa ꞌbï ꞌba mɔtɔ koga bilaka kupö kuꞌdu ti döku kölë yaga. Kina kinza bɔtɔ konyo yida mo dë. Tine kinza koꞌdɔ ɔtɔ dë zi bo bɔ dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ne ɔdɔ ŋgulö mo nima këdï pa toꞌdɔ ya ti bilaka bɔ dɔmo kuwö lende mo tine bo na koꞌdɔkɔ dë tosi dɔmo bërï, na ɔdɔ kari kupö bilaka tara uꞌdu ŋgulö mo nima ti döku kupö yaga kina bo bɔ dɔmo mo nima kupö bo gbï yaga. ");
INSERT INTO bex_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ne ɔdɔ kiteri zi bo topi mo rɔ yamo bo kopi gɔ bo kɔzɔ ame kiteri di zi bo ne tara. ");
INSERT INTO bex_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ɔdɔ ŋgulö sa mo nima koga pele rɔ kole ma titiyi ala nyiti kina ꞌdɔ koꞌdɔ pili tara. ");
INSERT INTO bex_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ne ɔdɔ kiya te ŋgulö mo nima kari koga rɔ atɔli bɔ dɔmo kopi yamo ꞌbutë mota zi bɔ dɔ atɔli nima. Kina ŋgulö mo nima kuꞌdu ti döku kupö yaga. ");
INSERT INTO bex_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ɔdɔ bɔtɔ mɔtɔ kari kombi toto yaga di dɔ gö kola rɔ gböŋö ala bo na kole kola tara, ɔdɔ sa ala akaca ꞌba bɔtɔ kilaꞌba yïmo ");
INSERT INTO bex_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","bo kopi yamo zi bɔ dɔ yërï mo nima. Tine yida ma kölë mo nima bo bɔ gö mo nima kogba abo. ");
INSERT INTO bex_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ɔdɔ ŋgulö ꞌbï ꞌba mɔtɔ kari koga ꞌba lëpï yï kupö, ŋgulö ma koga wa mo nima ugöke mökö kozake mï yamo mo ti bɔ lëpï yï nima koga ꞌba bo ꞌdeni kölë ne. Kina yida ma kölë mo nima ozake yïmo kpe ti bo. ");
INSERT INTO bex_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ne ɔdɔ ŋgulö mo nima këdï ꞌdeni mɔlo rɔ bɔ ꞌdïrï, tine nï bɔ dɔmo na koꞌdɔkɔ dë tosi dɔmo bërï opi ŋgulö mɔtɔ zi bɔ dɔmo kpa ꞌba bo nima kogba yida ma kölë nima zïyï. ");
INSERT INTO bex_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ɔdɔ bɔ mo kari kuꞌbögö sa ꞌba bɔ mɔtɔ kugö mökö ala kumu bërï bo kopi sa muyï kpamo. Ne ɔdɔ bo kuꞌbögö rɔ kamölö bo kopi kamölö gbï sowɔ kpamo. ");
INSERT INTO bex_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ɔdɔ koꞌja bɔ ꞌbögö këdï kodowe kpadörï ꞌbï rɔ mï korɔndɔ na komba ŋgï kölë, roma bo inza kileki rɔ lende kënyë döyï. ");
INSERT INTO bex_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ne ɔdɔ kiya te këdï rɔ mï kada ti këdï ŋgï rɔ lende kënyë zïyï. Bɔ ꞌbögö kopi wa ame ga bo kuꞌbögö ne. Tine ɔdɔ ɔtɔ kinza zi bo, bo mo na ko kugö bo mökö ꞌdɔ kopi timo. ");
INSERT INTO bex_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ɔdɔ bo kuꞌbögö rɔ yërï na kari kota gba këdï rɔ ma kïdïdï ɔdɔ këdï rɔ sa ala akaca ala kamölö bo kopi bi mo teyi rïyö. ");
INSERT INTO bex_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ɔdɔ bɔ mɔtɔ kola yërï abo ga kari konyo wa di mï nyaka ꞌba bɔ mɔtɔ bo kopi ti a ma laka ꞌba mï nyaka ma ꞌba bo. ");
INSERT INTO bex_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ɔdɔ bɔ mɔtɔ kusu paꞌdo na kolɔlɔ kari koŋma nyönyu ꞌba bɔ mɔtɔ di bërï ala gba di mï nyaka bɔtɔ bɔ kusu paꞌdo mo nima kopi. ");
INSERT INTO bex_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ɔdɔ bɔ mɔtɔ kiꞌdi yamo ala abo mɔtɔ ga gɔ lëpï bo mɔtɔ tikeki mo na kari kuꞌbögö, ɔdɔ kindaꞌba bɔ ꞌbögö mo bo kopi mï rïyö. ");
INSERT INTO bex_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ne ɔdɔ kindaꞌba bɔ ꞌbögö mo dë bɔ ma kuꞌbögö di zi bo mo nima kari rö ꞌba Bɔkoꞌba kulömu rɔ bo a nima bo na dë konyo tine uꞌbögö ŋgï rɔ tuꞌbögö. ");
INSERT INTO bex_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Wa ame ga pili kölu kɔzɔ sa ala akaca ala kamölö ala bɔŋgɔ, bɔ ama kiya te, ‘Ama na,’ lïjë nima kpaki rïyö kari rö ꞌba Bɔkoꞌba. Kina bɔ ame kari koꞌja kinza rɔ abo ne kopi mï rïyö zi bɔ ma rɔ bɔ dɔmo mo nima. ");
INSERT INTO bex_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ɔdɔ bɔ mɔtɔ kiꞌdi yërï abo tötï zi bɔ mɔtɔ toŋgɔ gɔmo, na kari kölu ala a mɔtɔ koꞌdɔ ala kuꞌbögö bɔtɔ koꞌja gɔmo dë, ");
INSERT INTO bex_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","lende mo kote rönï löŋgö nnï ti lömu kɔmɔ Bɔkoꞌba, kiya te, bo na dë köꞌdö dɔ a ꞌba lëpï bo nima. Kina bo kopi ɔtɔ dë teyi. Kina kinza bɔ dɔmo kititi dë gbï kpe. ");
INSERT INTO bex_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ne ɔdɔ kiya te kuꞌbögö rɔ tuꞌbögö bo kopi zi bɔ dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ne ɔdɔ kuruku na konyo, sɔnzɔ mo bo koꞌde ꞌdɔ koꞌja. Kina bo inza kopi ɔtɔ kpe gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ne ɔdɔ nï mɔtɔ koꞌde yërï ꞌba lëpï yï mɔtɔ tötï zïyï, ɔdɔ ɔtɔ mɔtɔ koꞌdɔ ala kölë kinza kɔmɔ bo koꞌja dë, zïyï topi mo zi bo bɔ dɔmo nima. ");
INSERT INTO bex_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ne ɔdɔ bo bɔ dɔmo mo këdï teyi, opi ɔtɔ dë. Kina gbï tara ɔdɔ koꞌde ꞌdɔ topi töꞌdö mo naga nima ti gïrïsï, ɔdɔ ɔtɔ mɔtɔ kari kömö dɔmo gïrïsï ma kopi nima na kote lende mo ꞌdeni mɔlo. ");
INSERT INTO bex_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ɔdɔ bɔ mɔtɔ kari kirasi nyiti ame gba kïlïbö dë ne köꞌdö timo, iꞌdi bo koꞌdɔ gbe mo ŋgï bo kogbe abo rɔ ꞌja. ");
INSERT INTO bex_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ne ɔdɔ ꞌbu ꞌba nyiti mo na koꞌdɔkɔ dë bɔ köꞌdö ti nyiti abo nima kopi yamo zi bo kɔzɔ gbe ꞌba dɔ nyiti tara. ");
INSERT INTO bex_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","ꞌJa ame koꞌdɔ rönï rɔ bɔ kata ne, upöke yaga. ");
INSERT INTO bex_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Bɔtɔni ame kari köꞌdö za ti yërï ne, upöke yaga. ");
INSERT INTO bex_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Bɔtɔ ame kari kumu roma za zi akoro kola ma ŋere Bɔkoꞌba ne, odɔke karama dɔmo kupöke bo yaga. ");
INSERT INTO bex_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Kinza koꞌdɔke kpɔŋi dë rɔ bɔ löwö. Römöyï kpe olomake gbï tönë bine rɔ bɔ löwö mï Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kinza koꞌdɔke kpɔŋi dë rɔ makuruꞌbë ni ti kiriꞌbala mo ga. ");
INSERT INTO bex_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ɔdɔ koꞌdɔke na lïjë kudu zö ma ŋere Bɔkoꞌba ti mileki dɔ monɔ ꞌbënnï ");
INSERT INTO bex_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","mupö ye yaga mï ya ꞌdɔ ꞌja ma ꞌbeye ga koloma gbï rɔ makuruꞌbë kole ꞌbe ga kileki yaga rɔ kiriꞌbala. ");
INSERT INTO bex_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ɔdɔ kiꞌdi yamo rɔ tötï zi bɔ lisa ma mɔtɔ kinza kiꞌdi bo dë kopi zïyï ti a mɔtɔ dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ɔdɔ kindaꞌba bɔŋgɔ kolɔ rɔ bɔ mɔtɔ kpa wali ꞌbï ileki zi bo gba kota kada kinza kösö dë. ");
INSERT INTO bex_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Römöyï gɔmo na ma ŋge kɔtɔ zi bo tutuꞌbö mo dɔ bo. Kina ɔdɔ kogba ꞌdeni yaga bo ti kutuꞌbö waꞌdi dɔ bo? Ɔdɔ bo kudu zö mëdï muwö römöyï ma rɔ bɔ mï këyï. ");
INSERT INTO bex_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Kinza kiya kpa kënyë dë rɔ ma Bɔkoꞌba. Kina kinza kulömu bɔ ame rɔ löbu ꞌba dɔye ne dë gbï. ");
INSERT INTO bex_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Iꞌdi kpa közï zö di mï wa ame ga pili këddï kumu di mï nyaka ꞌbï kɔzɔ nyönyu ni ne. Kole bɔtɔni ꞌbï ame rɔ dɔndende mo ne iꞌdi zö. ");
INSERT INTO bex_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Kina kole ma rɔ dɔndende ꞌba yërï ꞌbï ga gbï tara. Kole bɔtɔni ame köyö rɔ dɔndende ne koꞌdɔ töꞌdö ŋge dɔ modɔmorïyö ti ma mo, tine mï töꞌdö dɔ modɔɔmota mo nima koꞌde zö. ");
INSERT INTO bex_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Kpe ꞌdeni rɔ bilaka ma koro ma ga. Kina kinza konyoke yida kpa kuruku dë. Uꞌduke zi bï. ");
INSERT INTO bex_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Kinza kebe dë tilaki ti lende rɔ bëtï. Kina kinza kunzö bëtï dë gbï tandi gɔ lende ti bɔ lende kënyë. ");
INSERT INTO bex_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Kinza kebe dë tösö gɔ bilaka ma konzi ɔdɔ lïjë këdï koꞌdɔ lende kënyë ala kpënnï këdï kandi di mï burë. ");
INSERT INTO bex_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kinza koꞌdɔ mï koŋmi dë ŋge rɔ bɔ lisa ni di kɔmɔ kïtï ꞌba burë. ");
INSERT INTO bex_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ɔdɔ kari kömö dɔ sa ala akaca ꞌba bɔ ya ꞌbï kölu ra mökö ogba kileki zi bo. ");
INSERT INTO bex_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kina ɔdɔ koꞌja akaca abo kidaki ra di bïcï akïrïndï okɔnyi kombi dɔmo tɔrɔ. Kinza kebe kiteli dë ŋgï di dɔŋgila mo kari ëꞌbï nduwë. ");
INSERT INTO bex_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Kinza kandi dë gɔ lende laka ꞌba bɔ lisa ɔdɔ bo kako ꞌdeni kɔmɔ kïtï ꞌba burë. ");
INSERT INTO bex_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kinza kebe kususu bɔtɔ dë rɔ bëtï. Kina kinza kiꞌdi dë kupö bilaka ame abo ŋgï rɔ ma sari kinza lende ɔtɔ ne. Römöyï ma ŋere Bɔkoꞌba ti modɔ karama dɔ bɔtɔ ame pili këdï koꞌdɔ kïnë lende kënyë ma kɔzɔ a naga nime te ne. ");
INSERT INTO bex_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kinza kutï dë dɔ kɔmɔ kugö. Römöyï kɔmɔ kugö ndɔbɔ abo rɔ tïyölu kömöyï ŋgï di dɔ lende laka kirasi kɔri di zi ya ame ga rɔ bɔ lende laka ne. ");
INSERT INTO bex_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Kinza kebeke dë toꞌdɔ kpɔŋi rɔ bɔ löwö. Römöyï kpe ikalike kpa loma rɔ bɔ löwö ꞌdeni tönë bine di yida rɔye di mï Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Nyaka ꞌbï orɔꞌdɔ ŋge kɔmɔ kɔɔ modɔɔkɔtɔ kumu a mo ga. ");
INSERT INTO bex_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Tine mï modɔmorïyö ꞌba kɔɔ mo nima ola kari mökö ꞌdɔ kindawo rönï. Kina kinza kebe kumu taŋga ame ga kötu yïmo ne dë. Römöyï ꞌdɔ bɔ lisa ni kumu kɔsɔ ma kileke mo ga koloma ꞌjaa zi yërï ni. Rɔ gɔ nyaka ꞌbe ga pili na koꞌdɔke lende mo ga te. ");
INSERT INTO bex_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Oꞌdɔ ndɔbɔ ꞌbï ŋge dɔ modɔɔkɔtɔ mï töꞌdö dɔ modɔmorïyö. Tine mï töꞌdö ma rɔ dɔ modɔmorïyö mo nima kinza koꞌdɔ ndɔbɔ ɔtɔ dë. Römöyï ꞌdɔ atɔli ꞌbï ga ti bɔ löwö ꞌbï ame ga këdï koꞌdɔ ndɔbɔ zïyï ne kpaki ti yërï ꞌbï ga kindawo rönnï. ");
INSERT INTO bex_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Wa ame ga pili ma ŋere Bɔkoꞌba mëdï miya ziye ne, uwöke. Kinza kebe kulömuke kpeye dë zi akoro ni ala kïdëkïke möyï nnï dɔ kpeye. ");
INSERT INTO bex_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Oꞌdɔke karama mï mota zö mï kɔmɔ kɔɔ kɔtɔ toro ma ŋere Bɔkoꞌba timo. ");
INSERT INTO bex_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Mï nyepe ma dɔgba ꞌba tɔdɔ ꞌbe di Ezipeto mo tönë kïdëkï möyï mo rɔ nyepe ꞌba Abibi ne, oꞌdɔke karama ꞌba maŋgolɔꞌbɔ kinza laŋga gɔmo zö ti kɔri mo tönë ga mose ziye ne. Kinza konyoke maŋgolɔꞌbɔ ma ti laŋga gɔmo dë mï töꞌdö dɔ modɔmorïyö mo nima. Kina kinza kako dë ŋgï rɔ ma sari zö tumötu ma ŋere Bɔkoꞌba ꞌbï. Ako ti kpa közï kiꞌdi. ");
INSERT INTO bex_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Oꞌdɔke karama ꞌba kpa dɔlili ti wa laꞌja ma kumuke di mï nyaka. Oꞌdɔke karama ꞌba loma mï ŋgöŋgöbö zö di pötö totɔtɔ wa ꞌdeni kote yaga di mï nyaka. ");
INSERT INTO bex_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Mï kada ꞌba karama mota naga nime rɔ gɔ kɔmɔ kɔɔ pili kpe bɔtɔni kɔlɔke me tumötu ma, ma ŋere Bɔkoꞌba ꞌbe. ");
INSERT INTO bex_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ɔdɔ kumu roma zö kinza koꞌde maŋgolɔꞌbɔ mo dë ti laŋga gɔmo. Yërï ame ga kumu zö mï karama naga nime ne kinza kola ꞌbu mo ga dë köꞌdö ŋbö bi këzë dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Rɔ gɔ kɔɔ pili dɔndende ꞌba nyönyu ma kumuke di mï nyaka oꞌdeke kako mï rö ma ꞌba Bɔkoꞌba. Kinza kuꞌdï kole banya ala kole kamölö dë ti mba ꞌba ma mo. ");
INSERT INTO bex_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Oŋgɔke, ti moja malayika ma dɔgba ziye kɔmɔye tokɔkɔ ye ŋbö koꞌde ye mï gɔ bi ma mileŋo ꞌdeni ziye. ");
INSERT INTO bex_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ojeke mbili ye kuwöke dɔ bo. Kinza kamoke dë dɔ bo römöyï ma na moja bo kari ti möyï ma. Kina mï bo inza këyï rɔ bɔtɔ ame kamo dɔ bo ne. ");
INSERT INTO bex_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ne ɔdɔ kiya te kuwöke dɔ bo koꞌdɔke wa ma mose naga, ma na ti moꞌdɔ ya gɔye ti bɔ ya ꞌbe ga pili. ");
INSERT INTO bex_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Bo na ti kösö dɔgba ziye koꞌde ye mï dɔyayi ꞌba Amora ni ti ꞌba Ete ti ꞌba Pereze ti ꞌba Kanana ti ꞌba Iwa gbï ti ꞌba Yebusa. Ti mona lïjë ꞌdoyi yaga. ");
INSERT INTO bex_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tine kpe kinza kolɔdɔke dë bërï kulömuke kpeye zi akoro ꞌbënnï ga. Kina kinza kindaꞌbake mötu koꞌdɔ ꞌbënnï ga dë gbï. Tine icacake dɔmo kitikɔke mï toto koro ꞌbënnï mo ga yaga. ");
INSERT INTO bex_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ma ŋere Bɔkoꞌba ꞌbe na ŋge kumötuke. Kina yëyï ma ti këdï ŋgï ziye dɔ akonyo ni ti mini. Ti mogba rɔkɔꞌɔ yaga di mï löŋgö ye. ");
INSERT INTO bex_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Kina ꞌja ma kɔtɔ mɔtɔ te di mï löŋgö ye ti yërï ꞌbe ga roma inza kolɔdɔ di rɔmo ala kɔrɔ rɔ kɔtɔ. Ti miꞌdi gɔ loma ꞌbe ga kɔwɔ. ");
INSERT INTO bex_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ti modɔ tikere mïnnï lïjë bɔ kiteri ya tiye naga nima. Ti mïlïkö dönnï yaga rɔ gɔ rönnï. Ti miꞌdi lïjë kuyï kpënnï kiriŋa yaga di ziye. ");
INSERT INTO bex_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ti moja makalïgbögbö ma dɔgba kɔmɔye mï Iwa naga nima ti Kanana ꞌbënï pili ti Ete mo ga ꞌdɔ koga lïjë yaga di kɔri ziye. ");
INSERT INTO bex_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Tine minza moga lïjë ŋgï yaga mï kɔmɔ kɔɔ kɔtɔ römöyï kinza dɔyayi nima kari koloma ra rɔ yï mökö kuruku köyö koso yïmo ziye. ");
INSERT INTO bex_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Tine ti moga lïjë yaga mbowambowa ziye ŋbö karake titi kɔꞌbɔke tindaꞌba dɔyayi nima pili. ");
INSERT INTO bex_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ti miꞌdi kpa dɔ maga ꞌba yayi ꞌbe këdï ŋbö kebe kpa Yöpö Kasi kala kpa mini löbu koga rɔ yï mökö kudö te kala kpa yöpö Epurate. Ti miꞌdi közï kakpa ziye dönnï lïjë bilaka ꞌba mï dɔyayi mo naga nima pili. Kina ti kogake lïjë ŋgï yaga mï tari ꞌbe nima. ");
INSERT INTO bex_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kinza koꞌdɔke lömu dë tïnnï ala ti akoro ꞌbënnï mɔtɔ ga. ");
INSERT INTO bex_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kinza kiꞌdike lïjë bilaka naga nima dë koloma ga mï dɔyayi ꞌbe. Ɔdɔ kolake lïjë ti kiꞌdi ye koꞌdɔke lende kënyë zö ma ŋere Bɔkoꞌba. Ɔdɔ kebe kulömuke kpeye zi akoro ꞌbënnï ga ti këdï rɔ laŋba ma löbu ziye.” ");
INSERT INTO bex_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ŋere Bɔkoꞌba iya zi Musa te, “Nï Musa kpe ti Arona ti Nadaba ti Abïwu ti löbu ꞌba Yisarele ma kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö mɔtɔ ga, akoke zö dɔ döku tɔrɔ bine. Lïjë ama ga kumötu ꞌbënnï ŋbö rɔ ma kɔwɔ yayi. ");
INSERT INTO bex_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Tine nï Musa na ŋge kɔtɔ gɔ kese ŋgɔsi zö. Kina kinza bɔtɔ mɔtɔ këkï dë kako tïyï tɔrɔ bine.” ");
INSERT INTO bex_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kina ɔdɔ Musa kileki kari kiya lende naga nime zïnnï Yisarele tine lïjë pili utï ŋgï gɔmo, iya te, “Wa ame ga pili ŋere Bɔkoꞌba kose ne ti doꞌdɔ ŋgï.” ");
INSERT INTO bex_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kina Musa kugu wa ame ga pili ŋere Bɔkoꞌba kiya ne ŋgï bërï. Mɔlo mï dɔŋbɔ na bo kënyï ŋgï kari koꞌba bi ꞌba akumu ndï döku yayi. Bo ïdëyï dɔ döku ꞌbutë dɔmorïyö yayi kileme kpa gɔli ꞌba Yisarele mo tönë ga. ");
INSERT INTO bex_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Kina bo koja kole yɔbi ŋgï kari koŋma akumu ma koꞌdo gbï ti ma koŋma ŋge rɔ bi koro mo zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Roma sa ma kumu mo nima Musa ogba mbowa mï gberi tine kɔsɔ mo bo ulï rɔ bi ꞌba akumu mo nima. ");
INSERT INTO bex_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kina bo kogba buku ꞌba lömu mo tönë bo kebe tïdëkï köꞌdu kiꞌdi mo ga zi bilaka naga nima kina lïjë pili kutï ŋgï kiya te, “Ti doꞌdɔ wa pili ame ga ŋere Bɔkoꞌba kose ne ŋgï. Kina ti duwö dɔmo gbï.” ");
INSERT INTO bex_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Roma mo tönë Musa ogba kulï rönnï, kiya te, “Ame na rɔ roma ꞌba lömu ma bo Bɔkoꞌba koꞌdɔ ꞌdeni tiye kɔzɔ ame bo kiya bine ne.” ");
INSERT INTO bex_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kina Musa ni ti Arona ti Nadaba ti Abïwu ti löbu ꞌba Yisarele ma kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë rïyö mo tönë ga kari ŋgï ");
INSERT INTO bex_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","koꞌja kïnë Bɔkoꞌba ꞌba Yisarele ti kömönnï. Bi ndï bo bërï ŋgï kɔzɔ olo ꞌdeni ti a mɔtɔ ga kɔzɔ kïnë kïlïꞌdï ꞌdöyï naga tara kese kɔzɔ mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tine Bɔkoꞌba oꞌdɔ ɔtɔ dë zi bilaka naga nima. Lïjë oꞌja kïnë Bɔkoꞌba lïjë koloma gba tonyo kpënnï. ");
INSERT INTO bex_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Bɔkoꞌba iya zi Musa te, “Ako zö tɔrɔ dɔ döku bine, koloma bine. Kina ti miꞌdi lere ꞌba ndose ma ti köꞌdu kiꞌdi ma dɔmo ŋgï zïyï, ame ma na mugu ꞌdeni zïnnï toꞌdɔ mo.” ");
INSERT INTO bex_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kina Musa ni kënyï ŋgï dɔmo lïjë ti Yësuwa bɔ gɔ bo. Kina Musa këkï ŋgï tari tɔrɔ dɔ döku koro ꞌba Bɔkoꞌba nima. ");
INSERT INTO bex_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Bo iya zi löbu ꞌbënnï mo ga te, “Odake ze bine ŋbö dileki. Arona ni ti Uru na me tiye bine. Bɔtɔ ame këdï ti lende kako zïnnï.” ");
INSERT INTO bex_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kina ɔdɔ Musa këkï ꞌdeni dɔ döku koro ꞌba Sinayi mo nima tɔrɔ yayi tine na pɔli kutuꞌbö dɔmo ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Rɔ löbu ꞌba Bɔkoꞌba oloma ŋgï dɔ döku yayi. Pɔli utuꞌbö dɔ döku nima ŋbö töꞌdö mo dɔ modɔɔkɔtɔ. Mï dɔ modɔmorïyö mo tine na Bɔkoꞌba kïdëkï Musa ŋgï di mï pɔli nima. ");
INSERT INTO bex_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ma di zïnnï Yisarele ma laki ꞌdë rɔ löbu ꞌba Bɔkoꞌba nima inda ŋgï kɔzɔ paꞌdo ma këdï kilaŋma naga tara dɔ döku tɔrɔ yayi. ");
INSERT INTO bex_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Kina Musa këkï ŋgï kɔdɔ mï pɔli nima tɔrɔ dɔ döku yayi. Kina bo kari koꞌdɔ ŋgï yayi ŋbö töꞌdö dɔ ꞌbutë sowɔ, kpaki ti kada mo ti korɔndɔ ꞌbënï. ");
INSERT INTO bex_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ŋere Bɔkoꞌba ilende zi Musa iya te, ");
INSERT INTO bex_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Iya zi Yisarele, lïjë koꞌde kpa közï kiꞌdi zö. Wa ame ga pili lïjë koꞌde ne ogba kɔzɔ ame mɔtɔ mï bo koꞌdɔkɔ tiꞌdi mo tara. ");
INSERT INTO bex_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kpa közï kiꞌdi ame ꞌdɔ kogba di zïnnï ne na me ga, yamo ma köbököbö, sïtërï, ꞌbïlëŋï, ");
INSERT INTO bex_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo, ti sunë banya, ");
INSERT INTO bex_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ti kilaka kamölö ma kinyanyi ꞌdeni kasi liyi, ti kilaka ma kinyanyi ꞌdeni keŋme laka, ti ŋgërï kono, ");
INSERT INTO bex_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ti ꞌbu ꞌba toyi mo, agbaꞌji ꞌba mï ꞌbu kondi rɔ gbï ti ꞌba akato kele, ");
INSERT INTO bex_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","gbëyï ma ŋbɔwɔ ti lele ma kele mɔtɔ ga ame ꞌdɔ kulölï rɔ nyama ꞌba bɔ akumu mo tönë gbï ti bɔŋgɔ ꞌba kpa dɔŋgoꞌdo bo. ");
INSERT INTO bex_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Iꞌdi lïjë koꞌdɔ rö kilaka ma koro zö ma ŋere Bɔkoꞌba ꞌdɔ moloma mï löŋgö lïjë. ");
INSERT INTO bex_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Rö nime ti jama ꞌba yïmo ga oꞌdɔ pili gɔ wa ame mëdï mileme zïyï ne. ");
INSERT INTO bex_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Iꞌdi lïjë koꞌdɔ sandu zö di mï ŋgërï kono. Gɔmo ma kakpa dɔkɔmɔ kolɔkɔ ꞌbutë dɔɔkɔtɔ. Töꞌbö mo dɔkɔmɔ kolɔkɔ modɔmorïyö. Kina ma kakpa kari tɔrɔ mo gbï tara. ");
INSERT INTO bex_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Yïmo ma di mïyö ora ti yamo ma köbököbö ŋbö kala kebe gɔmo ma yaga. Kina gɔ kïyöru dɔ kpamo ti yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Oŋgo yamo köbököbö rɔ kano mo kutötï rɔ rïyörïyö gɔ ndïmo naga nima kpaki sowɔ rɔ bi ꞌba tombi mo timo. ");
INSERT INTO bex_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ŋgërï ꞌba tombi mo oꞌdɔ di mï kono kina ꞌdɔ komba rɔmo ti yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kina ꞌdɔ kusu mï kano mo tönë ga gɔ kapa ndïmo ga ne. ");
INSERT INTO bex_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ŋgërï mo naga nime koloma ꞌbënnï ŋburu köꞌbö yïmo bɔtɔ kotɔ dë yaga. ");
INSERT INTO bex_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Kina ꞌdɔ kiꞌdi lere rïyö mo tönë ga mugu köꞌdu kiꞌdi ma ꞌdeni dɔmo ne mï sandu nima. ");
INSERT INTO bex_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Oꞌdɔ a dɔmo di mï yamo ma köbököbö. Gɔmo ma kakpa dɔkɔmɔ kolɔkɔ ꞌbutë dɔɔkɔtɔ. Kina ma köꞌbö mo dɔkɔmɔ kolɔkɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Uku bikoro sasa rïyö ti kakala dɔmo di mï yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ma kɔtɔ kebe kapa a ꞌba dɔmo ma kileki te mɔtɔ kebe kapa ma bine. Oꞌdɔ lïjë kambi kɔtɔ ti a dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Sasa mo naga nima oꞌdɔ mɔtɔ kuyï kömönï kari dɔ lëpï nï tine koŋgɔ bi bërï. Oꞌdɔ dɔ a dɔmo tɔrɔ kakala lïjë kutuꞌbö sandu nima. ");
INSERT INTO bex_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Iꞌdi lere rïyö mo tönë ga mï sandu yayi kutuꞌbö dɔmo teyi ti a dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Kina ti mako mondɔsɔ tïyï mï löŋgö sasa naga nima miꞌdi köꞌdu kiꞌdi ma pili zïyï zi Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Oꞌdɔ tarabiza zö di mï ŋgërï kono. Gɔ ma kakpa mo dɔkɔmɔ kolɔkɔ modɔmosowɔ. Gɔ ma köꞌbö mo dɔkɔmɔ kolɔkɔ muyï. Ma kakpa kari tɔrɔ mo dɔkɔmɔ kolɔkɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ora rɔmo ti yamo ma köbököbö kïyöru dɔ kpamo ti yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Dɔtara kpamo ma kɔꞌdɔ kari tɔrɔ oꞌdɔ koriya ti dɔkole közï ma zana nime. Kina ꞌdɔ kïyöru dɔ kpamo gbï ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Oꞌdɔ kano ꞌba ꞌdɔ tombi mo timo këdï di mï yamo köbököbö. Utötï kano mo naga nime gɔ ndïmo ga ma sowɔ naga nima. ");
INSERT INTO bex_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Oꞌdɔ bi mo ga ŋgɔsi ŋgila dɔtara ꞌba kpamo tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Oꞌdɔ ŋgërï ꞌba tombi mo di mï kono komba rɔmo teyi ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Oꞌdɔ gata mo ga ti kösu mo ti gberi mo ti lebe ꞌba todɔ layi mo. Wa naga nime pili oꞌdɔ di mï yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kina maŋgolɔꞌbɔ koro köꞌbö ŋburu tiꞌdi mo zö dɔ tarabiza mo nime. ");
INSERT INTO bex_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Oꞌdɔ a ꞌba tïdëyï lamba di mï yamo ma köbököbö. Uku ndïmo ti dɔdɔrɔ mo rɔ tuku. Döwöru ma kiyada timo mo ga ti mbili ma këdï komo mo ga oꞌdɔ kambi kɔtɔ timo. ");
INSERT INTO bex_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kapa mo ga kpaki rïyö oꞌdɔ ti dɔŋgila rɔ motamota teyi. ");
INSERT INTO bex_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Dɔŋgila ma konza mo naga nima këdï ti döwöru me rɔ motamota ti ma komo mo ga teyi. ");
INSERT INTO bex_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Dɔdɔrɔ mo këdï ti döwöru sowɔ teyi ti ma komo mo ga. ");
INSERT INTO bex_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Dɔŋgila ma konza mo naga nima këdï pili ti mbili ma komo kpa ŋgoriya mo ga. ");
INSERT INTO bex_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Mbili mo ma komo nima ti dɔŋgila mo ga ti akïdëyï lamba mo nima kuku kambi kɔtɔ di mï yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Oꞌdɔ lamba modɔmorïyö dɔ akïdëyï mo nima ꞌdɔ lïjë kiyɔpɔ bi ma dɔgba nima. ");
INSERT INTO bex_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Oꞌdɔ makara mo ti akunzö buruku mo di mï yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kilɔ ꞌba yamo köbököbö ꞌbutë mota döömu na ꞌdɔ koꞌdɔ pili rɔ wa naga nime. ");
INSERT INTO bex_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Oŋgɔ laka ꞌdɔ koꞌdɔ rönï kɔzɔ wa ame tönë mileme zïyï di dɔ döku bine ne. ");
INSERT INTO bex_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Oꞌdɔ rö kilaka zö, yïmo ma mïyö di mï bɔŋgɔ ma kele kudöꞌbö ꞌbutë kuꞌjö di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo. Ïyöru ti kïnë sasa tönë ga ti kakala dɔmo ne. ");
INSERT INTO bex_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Oꞌdɔ bɔŋgɔ mo naga nima takpa mo ga këdï pili rɔ ma koriya dɔkɔmɔ kumögu ꞌbutë dɔmorïyö. Töꞌbö mo dɔkɔmɔ kumögu rïyö. ");
INSERT INTO bex_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ma muyï iyoso kpamo pili bi kɔtɔ rɔ mindalo. Kina ꞌdɔ koꞌdɔ kapa ma muyï mɔtɔ nima gbï tara. ");
INSERT INTO bex_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Oꞌdɔ bɔŋgɔ kese rɔ kano teyi kora rɔ gɔ mindalo ꞌba dɔ kpamo ma yaga nima. ");
INSERT INTO bex_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Oꞌdɔ rɔ ma dɔgba mo kuluku kɔtɔ. Kina ꞌdɔ koꞌdɔ mɔtɔ ga gbï kuluku kɔtɔ rɔ mindalo ma mï rïyö mo, tulölï mo timo. ");
INSERT INTO bex_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Oꞌdɔ moŋgɔ kuluku kɔtɔ di mï yamo köbököbö tiyoso kpa ma dɔgba nima ti ma mï rïyö mo timo ꞌdɔ këdï rɔ akɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Oꞌdɔ gɔmo ma yaga di mï bɔŋgɔ kudöꞌbö ꞌbutë dɔɔkɔtɔ ma kuꞌjö di mï sunë banya. ");
INSERT INTO bex_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Oꞌdɔ lïjë pili rɔ ma koriya. Takpa mo dɔkɔmɔ kumögu ꞌbutë dɔɔmota töꞌbö mo dɔkɔmɔ kumögu rïyö. ");
INSERT INTO bex_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Uru kpa ma muyï kiyoso bi kɔtɔ rɔ mindalo. Kina ma modɔɔkɔtɔ ama uru kiyoso kpamo ꞌberi rɔ mindalo mɔtɔ. Kapa ma rɔ modɔɔkɔtɔ mo nima uköku yïmo teyi mï rïyö kebe kapa kpadörï mo. ");
INSERT INTO bex_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kapa ma rɔ mindalo ma yïꞌböwu mo nima oꞌdɔ kano rɔmo kuluku kɔtɔ. Kina ꞌdɔ koꞌdɔ kano gbï kuluku kɔtɔ rɔ mindalo mɔtɔ mo nima. ");
INSERT INTO bex_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Oꞌdɔ moŋgɔ kuluku kɔtɔ di mï ꞌbïlëŋï tiyoso kpamo timo rɔ akɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kɔsɔ kapa mo ma kola nima owe kileki kebe kapa mo ma yïkundö. ");
INSERT INTO bex_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kɔsɔ ma dɔkɔmɔ kolɔkɔ muyï mo naga nima oꞌdɔ kolɔkɔ kuru kapa mo ga toko gɔ kutuꞌbö dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Oꞌdɔ akutuꞌbö dɔmo mɔtɔ ga gbï ꞌböwu rïyö teyi. Ma kɔtɔ di mï kilaka kamölö ame kinyanyi ꞌdeni rɔmo kasi liyi ne. Kina mɔtɔ rɔ kilaka ma kinyanyi ꞌdeni keŋme laka naga ꞌdɔ bo na këdï kebe gɔmo ma yaga. ");
INSERT INTO bex_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Oꞌdɔ nzora ꞌba rö kilaka nime ma rɔ dɔdɔrɔ mo di mï ŋgërï kono. ");
INSERT INTO bex_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Takpa mo ga këdï pili dɔkɔmɔ kumögu sowɔ. Ma köꞌbö mo dɔkɔmɔ kolɔkɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Oꞌdɔ lösï rïyö ndïmo ga ꞌdɔ kïdëyï timo. Nzora naga nima pili rɔ gɔmo këdï ti lösï teyi. ");
INSERT INTO bex_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Oꞌdɔ nzora ꞌbutë rïyö kapa mo ma kari dɔ roꞌɔ. ");
INSERT INTO bex_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kina oꞌdɔ akïdëyï mo ga ꞌbutë sowɔ tutötï mo timo di mï sïtërï. Nzora kɔtɔ këdï ti akïdëyï mo rïyö ndïmo. ");
INSERT INTO bex_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Oꞌdɔ nzora ꞌbutë rïyö kapa mo ma kari dɔ tugbu. ");
INSERT INTO bex_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Kina oꞌdɔ akïdëyï mo ga ꞌbutë sowɔ tïdëyï mo timo. Nzora kɔtɔ këdï ti akïdëyï mo rïyö ndïmo. ");
INSERT INTO bex_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Yïkundö mo ame kileki te kapa dɔ tɔrɔ ne oꞌdɔ nzora teyi modɔɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kina gɔ dɔ kumu mo ga oꞌdɔ nzora rïyö teyi. ");
INSERT INTO bex_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Nzora ꞌba gɔ dɔ kumu mo naga nima iyoso kpamo di bërï di zana mo kina gbï di dɔmo ma tɔrɔ. Nzora ma rïyö ꞌba toza mï dɔ kumu mo naga nime na koꞌdɔ tara. ");
INSERT INTO bex_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Nzora modɔɔmota ti akïdëyï mo di mï sïtërï ꞌbutë döömu dɔɔkɔtɔ ndïmo ga pili rɔ rïyörïyö. ");
INSERT INTO bex_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Oꞌdɔ moꞌba teyi ꞌbutë döömu di mï ŋgërï kono. Muyï kapa ma kɔtɔ, ");
INSERT INTO bex_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","muyï kapa ama, kina ma muyï mɔtɔ kebe yïkundö mo ame kileki te kapa dɔ tɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Moꞌba ma zana mo kisaki mɔlo di bine kuŋguŋgu ŋbö kala kapa mo ma ꞌdë. ");
INSERT INTO bex_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Nzora mo naga nima omba yɔki mo ti yamo köbököbö koꞌdɔ kano yɔki mo tusu moꞌba mo ga kebe yïmo. Moꞌba mo ga omba yɔki mo gbï ti yamo ma köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Rö kilaka nime zïyï toꞌdɔ mo gɔ kïnë mo ame mileme zïyï di dɔ döku tɔrɔ bine ne. ");
INSERT INTO bex_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Oꞌdɔ bɔŋgɔ di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo rɔ bɔŋgɔ kuröbö. Kina ꞌdɔ kïyöru rɔmo ti kïnë sasa naga tönë ti kakala dɔmo ne. ");
INSERT INTO bex_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Owe dɔ lëꞌbërë sowɔ ma mï zana mo yayi komba rɔmo teyi ti yamo ma köbököbö. Iyoso kpamo ti moŋgɔ kutötï ndïmo bërï ti akïdëyï mo sowɔ di mï sïtërï. ");
INSERT INTO bex_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Osi kpamo ma di tɔrɔ dɔ mindalo ꞌba moŋgɔ ma kiyija nima. Kina ꞌdɔ kutë sandu ꞌba lömu ma mo tönë gönyï mo ma kari yïkundö. Bɔŋgɔ kuröbö nima na koza bi ma koro timo di rɔ bi ma koro rɔ dɔ kiteli mo. ");
INSERT INTO bex_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Sandu ꞌba lömu nima utuꞌbö dɔmo teyi ti a dɔmo tönë. ");
INSERT INTO bex_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Kebe kɔmɔ bi koro rɔ dɔ kiteli mo nima ma kileki kapa yaga na ꞌdɔ kïdëyï tarabiza mo tönë teyi kapa mo ma kileki dɔ tugbu. A ꞌba tïdëyï lamba mo na kïdëyï te kapa kileki dɔ roꞌɔ. ");
INSERT INTO bex_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Akpadörï mo oꞌdɔ rɔ bɔŋgɔ kuröbö di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kiyada kïyöru laka. ");
INSERT INTO bex_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Bɔŋgɔ kuröbö ame oꞌdɔ lëꞌbërë muyï teyi di mï ŋgërï kono komba yamo köbököbö rɔmo kiyoso kpamo ti moŋgɔ yamo köbököbö. Oꞌdɔ akïdëyï mo muyï di mï ꞌbïlëŋï teyi. ");
INSERT INTO bex_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Oꞌdɔ bi ꞌba akumu di mï ŋgërï kono rɔ dɔ ꞌbaga kapa mo ga kpaki rɔ ma koriya dɔkɔmɔ kumögu rïyö. Tine takpa mo ma kari tɔrɔ këdï dɔkɔmɔ kumögu kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Oꞌdɔ dɔ dɔ kumu mo ga kpaki sowɔ rɔ ma kapa kɔzɔ biti. Oꞌba kambi kɔtɔ timo kora rɔmo ti ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Oꞌdɔ akunzö buruku mo ti körë ti lebe ti jakira ꞌba tuyï gɔ yida mo timo ti gata ꞌba tombi paꞌdo mo. Jama naga nime pili oꞌdɔ di mï ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Oꞌdɔ kayikayi kɔmɔ ŋgurögbö di mï ꞌbïlëŋï ti kano ꞌba tombi mo timo sowɔ teyi. ");
INSERT INTO bex_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kayikayi mo nima usu kebe bïcï dɔmo ma kɔꞌdɔ mo tönë ŋbö kömö zana mo. ");
INSERT INTO bex_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Oꞌdɔ ŋgërï kombi mo ga di mï kono komba ꞌbïlëŋï rɔmo. ");
INSERT INTO bex_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Kina ꞌdɔ kusu mï kano mo tönë ga rɔ dɔ kumu sowɔ ꞌba bi ꞌba akumu mo nima yayi ne, ꞌdɔ tombi mo timo. ");
INSERT INTO bex_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Oꞌdɔ bi ꞌba akumu nime di mï ŋgërï kola yïmo rɔ gböŋö di mï zana mo kɔzɔ ame tönë mileme zïyï di dɔ döku bine ne. ");
INSERT INTO bex_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Tine ꞌba rö ma mo tönë oꞌdɔ kali ꞌba rɔmo di mï bɔŋgɔ rɔ bɔŋgɔ kuröbö ma kele. Kapa mo ma kari dɔ roꞌɔ oꞌdɔ këdï dɔkɔmɔ kumögu ꞌbutë sowɔ dɔmosowɔ. ");
INSERT INTO bex_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Kïkëtï gɔmo ti dɔdɔrɔ ꞌbïlëŋï ꞌbutë rïyö ti akïdëyï mo ga gbï ꞌbutë rïyö ndïmo. Moŋgɔ mo ga ti bi kïyöru mo koꞌdɔ di mï sïtërï. ");
INSERT INTO bex_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kapa mo ma kari te dɔ tugbu ꞌdë këdï gbï tara. ");
INSERT INTO bex_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Kapa mo ma kileki te dɔ tɔrɔ këdï dɔkɔmɔ kumögu ꞌbutë rïyö dɔmorïyö ti dɔdɔrɔ mo ga ꞌbutë gbï ti akïdëyï mo ga. ");
INSERT INTO bex_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kapa mo ame kileki te yïbï ti kpadörï mo teyi ne këdï gbï tara dɔkɔmɔ kumögu ꞌbutë rïyö dɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Kapa kpadörï mo naga nima kpaki rïyö këdï dɔkɔmɔ kumögu modɔmorïyö ti dɔdɔrɔ mota ti akïdëyï mo ga. ");
INSERT INTO bex_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Akpadörï mo oꞌdɔ gɔ ma kakpa mo dɔkɔmɔ kumögu modɔɔmota di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kïyöru rɔmo kumöru. Kïkëtï gɔmo ti dɔdɔrɔ sowɔ ti akïdëyï mo ga teyi. ");
INSERT INTO bex_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Dɔdɔrɔ ꞌba kali mo ga ame kiyija toko ne ïyöru rɔmo pili ti sïtërï. Moŋgɔ mo ga këdï di mï sïtërï tine akïdëyï mo ga na di mï ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Gɔ ma kakpa mo këdï dɔkɔmɔ kumögu ꞌbutë sowɔ dɔmosowɔ. Töꞌbö mo këdï dɔkɔmɔ kumögu ꞌbutë rïyö dɔmorïyö. Ma kakpa kari tɔrɔ mo këdï dɔkɔmɔ kumögu rïyö. Bɔŋgɔ kuröbö nime koꞌdɔ di mï bɔŋgɔ ma kele tine akïdëyï mo ga na di mï ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Jama ꞌba ndɔbɔ timo mï rö nime ti akutötï mo ga ti ꞌba kali ꞌba rɔmo ga këdï di mï ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ose zïnnï Yisarele lïjë koꞌde ꞌbu ma laka zïyï ꞌdɔ koyi nduwë rɔ kɔmɔ lëndö ɔdɔ bi kölu ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Arona ni ti kole abo ga kïdëyï lamba nime mï rö ma yayi kebe kɔmɔ bɔŋgɔ kuröbö mo tönë ma yaga kɔmɔ sandu ꞌba lömu. Lamba nima köꞌbö ŋburu rɔ töbö tara kɔmɔ ma di mï rö ma yayi këzë dɔmo tayi. Köꞌdu kiꞌdi nime Yisarele köꞌbö nduwë toro mo toꞌdɔ mo te rɔ gɔ dɔ kupö nnï ga rɔ ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ogba bɔ löndö yï Arona ni ti kole abo ga Nadaba ni ti Abïwu ti Elezara ti Itomara koza lïjë yaga di mï löŋgö Yisarele rɔ bɔ akumu toja laja zö ma ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Oꞌdɔ bɔŋgɔ ꞌba bɔ akumu zi Arona gɔ kiꞌdi bo koyo rɔ bo gɔmo gbï ti tele mo. ");
INSERT INTO bex_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ose bɔ miri ame ga pili miꞌdi akikali mo ꞌdeni teyi ne. Kina ꞌdɔ kiya zïnnï lïjë koꞌdɔ bɔŋgɔ rɔ Arona nime gɔ kulömu bo rɔ bɔ akumu toja laja zö mï ndɔbɔ ma nime. ");
INSERT INTO bex_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Iya zïnnï gɔ lïjë koꞌdɔ bɔŋgɔ ꞌba kpa dɔŋgoꞌdo ti nyama mo ti bëbë ma löbu kakpa mo ti ma kolɔ rɔ kïyöru rɔmo kele ti yima ꞌba dɔ ti lapo mo ma ꞌdɔ bo koga gɔmo. Bɔŋgɔ ꞌba bɔ akumu nime koꞌdɔ zi bɔ löndö yï Arona ni ti kole abo ga gɔ lïjë këdï rɔ bɔ akumu toja laja zö. ");
INSERT INTO bex_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Bɔ koꞌdɔ mo naga nima kogba sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Oꞌdɔ nyama mo di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kïyöru rɔmo laka. ");
INSERT INTO bex_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kabi rïyö ꞌba dɔkɔnyɔ mo ga ma ꞌdɔ kosi kpamo timo bërï kuru kpamo. ");
INSERT INTO bex_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Gasi ma kele kuꞌjö di mï kïnë kɔtɔ mo nima gbï kiyoso kpamo yɔki nyama mo ꞌdɔ kambi kɔtɔ timo. ");
INSERT INTO bex_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ogba lele ma ŋbɔwɔ ne rïyö koꞌde bɔ miri koga möyï kole ꞌba Yakoba ga rɔmo, ");
INSERT INTO bex_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","rɔ ma kiyija gɔ töyö mo ga, modɔɔkɔtɔ rɔ ama kina gbï modɔɔkɔtɔ rɔ mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Oꞌde bɔ miri koga möyï kole ꞌba Yakoba ga rɔ lele naga nime koꞌbaꞌba ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Kina ꞌdɔ kuru rɔ kapa kabi ꞌba dɔkɔnyɔ mo naga nima kpa nyama ne gɔ kileme kpa gɔli ꞌbutë dɔmorïyö ꞌba Yisarele gɔ Arona kombi möyï lïjë dɔkɔnyɔ bo ꞌdɔ dɔma ma ŋere Bɔkoꞌba köꞌbö ŋburu gönnï kinza kudölu lïjë bilaka ma ga ra. ");
INSERT INTO bex_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Oꞌdɔ yamo köbököbö rɔmo ");
INSERT INTO bex_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","kosi kpa nyɔri rɔmo kopi kɔzɔ gaꞌda naga tara. ");
INSERT INTO bex_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Oꞌdɔ bɔŋgɔ ꞌba kpa dɔŋgoꞌdo zi bɔ dɔ bɔ akumu rɔ akileme akoꞌdɔkɔ ꞌba Bɔkoꞌba. Kïnë mo këdï gbï di mï a kɔtɔ nima koꞌdɔ rɔ nyama ne gbï kpaki ti tïyöru mo ga. ");
INSERT INTO bex_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Gɔmo këdï rɔ ma köꞌbö rɔ ma koriya dɔkɔmɔ kolɔkɔ rïyö rɔ dɔ ꞌbaga gɔ kuköku mïnï rïyö. ");
INSERT INTO bex_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Döku ndögö kitigɔ kulöwu naga ulölï rɔ mindalo sowɔ dɔ kpamo. Mindalo ma dɔgba mo iꞌdi mboro ni ti ma kïnë dɔŋɔte ti ma kese teyi. ");
INSERT INTO bex_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mindalo ma mï rïyö mo iꞌdi ma kïnë biliwa ti ma rɔ yëwë ti ma kilindekilinde teyi. ");
INSERT INTO bex_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mindalo ma mï mota mo iꞌdi ma kese tïyötïyö ti ma kumöru ti ma liyi teyi. ");
INSERT INTO bex_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mindalo ma mï sowɔ mo iꞌdi ma kïdïdï ti ma kïnë wölïwölï ti ma kïnë kïlïꞌdï ꞌdöyï teyi. Koꞌbaꞌba pili ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Lele ꞌbutë dɔmorïyö naga nime pili rɔ gɔmo rɔ kɔtɔkɔtɔ koga möyï kole ꞌbutë dɔmorïyö ꞌba Yakoba ga rɔmo ꞌdɔ kileme kpa gɔli ꞌba Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Bɔŋgɔ ꞌba kpa dɔŋgoꞌdo mo nima oꞌdɔ nyɔri yamo köbököbö rɔmo kɔzɔ gaꞌda naga tara. ");
INSERT INTO bex_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Oꞌdɔ magbaya rïyö kuru dɔ kpamo ma tɔrɔ nima, ");
INSERT INTO bex_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ꞌdɔ kosi kpa nyɔri rïyö mo tönë ga rɔmo. ");
INSERT INTO bex_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Kpamo ma kapa mɔtɔ osi rɔ yamo köbököbö mo tönë ga. Osi rɔ ma kileki te dɔ kapa mo ma kɔmɔ dɔkɔnyɔ kabi ꞌba nyama mo nima. ");
INSERT INTO bex_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Oꞌdɔ magbaya yamo köbököbö mɔtɔ ga gbï kuru kpa dɔgali bɔŋgɔ ꞌba dɔŋgoꞌdo mo tönë ŋgɔsi kpa nyama ma kapa bërï kebe mïyö. ");
INSERT INTO bex_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Oꞌdɔ magbaya mɔtɔ ga gbï ꞌböwu rïyö kuru kpa kabi ꞌba dɔkɔnyɔ nyama mo nima ŋgɔsi kpa dɔmoso mo tine mbowa tɔrɔ bi dɔ gasi kuꞌjö kele mo tönë. ");
INSERT INTO bex_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Magbaya ꞌba kpa bɔŋgɔ ꞌba dɔŋgoꞌdo mo tönë osi kpamo rɔ ꞌba nyama ti kabi kese ꞌdɔ ma ꞌba dɔŋgoꞌdo mo nima këdï kebe dɔ gasi mo, kinza koloma ra rɔ ma kuŋgölö. ");
INSERT INTO bex_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ɔdɔ Arona këdï kɔdɔ kari mï bi ma koro mo nima bo kolɔ bɔŋgɔ ꞌba kpa dɔŋgoꞌdo mo nima ti möyï kpa gɔli ꞌba Yisarele mo tönë ga rɔmo ne. Römöyï ꞌdɔ ma ŋere Bɔkoꞌba möꞌbö nduwë kinza dɔma kudölu lïjë bilaka ma ga ra. ");
INSERT INTO bex_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Döku ꞌjɔ lɔzɔ mo tönë ga kïdëkï rɔ Urïmu ni ti Tumïmï ne iꞌdi mï bɔŋgɔ ꞌba kpa dɔŋgoꞌdo mo nima ꞌdɔ Arona kombi ti bo ɔdɔ bo këdï kako zö mï bi koro ma rɔ akileme akoꞌdɔkɔ ma zïnnï Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Bëbë ma löbu mo nima na ꞌdɔ kusu titi gba bërï mï nyama mo yayi ame koꞌdɔ di mï sunë ma kese. ");
INSERT INTO bex_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Tine kola bi gböŋö teyi ꞌba dɔ, kolo dɔtara kpamo kitigɔ kinza kirica. ");
INSERT INTO bex_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Dɔ kpamo ma koŋgo kebe kapa mo ma bërï nima iyija ŋgoloŋgolo kese ti ma ŋbɔwɔ ti sunë kasi kujölu yïmo ti lalaŋa yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ɔdɔ Arona këdï kari mï ndɔbɔ ꞌba akumu zö bo kolɔ bɔŋgɔ nime rɔ bo. Ɔdɔ bo këdï kako zö mï bi ma koro ma ala ɔdɔ bo këdï kɔdɔ yaga gɔ kuwö birɔ bo, lalaŋa këdï kozɔ. Kina inza kupö bo kpe. ");
INSERT INTO bex_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Oꞌdɔ dökulë yamo köbököbö kugu rɔmo te, ‘Ulömu ꞌdeni zi Bɔkoꞌba.’ ");
INSERT INTO bex_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kina ꞌdɔ kudödu dɔ yima ma tönë kpa dɔ Arona ti kabi kese. ");
INSERT INTO bex_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Arona kolɔ wa naga nime kpa dɔ bo ꞌdɔ ma ŋere Bɔkoꞌba mutï gɔ kpa közï kiꞌdi ame ga pili Yisarele këdï kiꞌdi zö ne. Ɔdɔ lïjë kɔcɔ ra pele zö di bi tiꞌdi mo ti mutï ŋgï dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Uꞌjö bɔŋgɔ kolɔ rɔ zi Arona di mï alato kirilewo koꞌdɔ yima mo gbï di mï kïnë kɔtɔ mo nima kina ꞌdɔ koꞌdɔ lapo mo gbï teyi kiyada rɔmo kïyöru kele. ");
INSERT INTO bex_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Oꞌdɔ bɔŋgɔ ma kolɔ rɔ ti lapo mo ga ti adɔ zi kole ꞌba Arona ga gɔ lïjë koyo rönnï gɔmo gbï ti tele mo. ");
INSERT INTO bex_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Olɔ bɔŋgɔ nime rɔ löndö yï Arona ni lïjë ti kole abo ga. Kina ꞌdɔ kondi ꞌbu rönnï koꞌdɔ lïjë rɔ bɔ akumu toja laja zö. ");
INSERT INTO bex_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Oꞌdɔ ridi zïnnï di bi kabi ŋbö kömö gɔ gölö bërï kinza atiti ꞌba rönnï ga kinda ra yaga. ");
INSERT INTO bex_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Bɔŋgɔ naga nime Arona ni ti kole abo ga köꞌbö tolɔ mo ɔdɔ lïjë këdï kari mï rö ma mo tönë ala kese ŋgila bi ꞌba akumu toꞌdɔ mo mï bi koro mo nima. Römöyï kinza mupö lïjë ra gɔ tola atiti ꞌba rönnï ga kinda yaga. Köꞌdu kiꞌdi nime köꞌbö ŋburu tara zi Arona ni ti kole abo ga. ");
INSERT INTO bex_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","A ma ꞌdɔ koꞌdɔ tiꞌdi lïjë timo rɔ bɔ akumu zö na me. Ogba ŋgulö sa ame këdï gba kënyï ne ti moꞌde kamölö rïyö pili rɔ ame ga kinza bɔti mɔtɔ rɔmo ne. ");
INSERT INTO bex_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ogba ruzu ma kele tine kinza kiꞌdi laŋga dë gɔmo. Oꞌdɔ maŋgolɔꞌbɔ ti ꞌbu gɔmo. Kina ꞌdɔ koꞌdɔ mɔtɔ gbï kinza ꞌbu gɔmo. Tine mɔtɔ ga koꞌdɔ kɔzɔ lëmbërë naga tara kosa ꞌbu rɔmo. ");
INSERT INTO bex_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Iꞌdi maŋgolɔꞌbɔ naga nime mï kee koto zö ɔdɔ këdï kumu ŋgulö mo tönë ti kamölö rïyö mo naga nima ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Oꞌde Arona ni ti kole abo ga kako kpadörï ꞌba rö ma mo tönë. Kina ꞌdɔ kiya zïnnï lïjë kurögö rönnï yaga kɔpɔ. ");
INSERT INTO bex_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kina ꞌdɔ kolɔ bɔŋgɔ ꞌba bɔ akumu mo nima rɔ Arona, ma kolɔ rɔmo ti bëbë ma löbu mo tönë këdï kolɔ kebe mï nyama mo titi dɔgba ne. Kina ꞌdɔ kolɔ nyama mo dɔmo kiꞌdi gasi mo ti ꞌba dɔŋgoꞌdo mo gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Iꞌdi yima mo tönë dɔ bo kudödu dökulë koro mo nima kugu ꞌdeni rɔmo te ‘Ulömu ꞌdeni zi Bɔkoꞌba’ ne dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kina ꞌdɔ kogba ꞌbu kondi mo tönë kodɔ dɔ bo kondi rɔ bo. ");
INSERT INTO bex_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kina ꞌdɔ koꞌde kole abo mo ga kolɔ bɔŋgɔ kolɔ rɔ rɔmo. ");
INSERT INTO bex_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Lapo mo tönë ga oga ꞌbömbö lïjë kudödu adɔ dönnï. Tiꞌdi Arona ni ti kole abo ga zö rɔ bɔ akumu na ꞌdɔ koꞌdɔ te. Lïjë nime nduwë rɔ kupö nnï ga köꞌbö rɔ bɔ akumu zö toja laja ma. ");
INSERT INTO bex_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Kina ꞌdɔ koꞌde ŋgulö sa mo tönë kako kpadörï ma yayi. Kina ꞌdɔ kiya zi Arona ni ti kole abo ga kiꞌdi közïnnï dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Upö ŋgulö sa nima kɔmɔ ma yayi kpadörï ꞌba rö ma. ");
INSERT INTO bex_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ogba roma mo kusu dɔkole közïyï yïmo kosa dɔ biti ꞌba bi ꞌba akumu. Kina ꞌdɔ kodɔ kɔsɔ roma mo bërï bi ndïmo yayi. ");
INSERT INTO bex_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tine ogba ꞌbu mo ma kambi ame ga kora rönï kebe rɔ a ꞌba yïmo ga ne ti kapa luru mo ma laka ti dɔꞌjɔ mo ga kpaki rïyö ti ꞌbu mo ga rɔmo koŋma zö dɔ bi ꞌba akumu yayi. ");
INSERT INTO bex_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Tine yida mo ga ti kilaka mo ti tokpe mo ga ari koŋma ŋbö yaga mökö di mï taya. Kina rɔ kpa közï kiꞌdi ꞌba tombi lende kënyë ꞌba bɔ akumu. ");
INSERT INTO bex_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ogba moꞌde kamölö ma kɔtɔ kiya zi Arona ni ti kole abo ga kiꞌdi közïnnï dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Upö kogba roma mo kulï kapa bi ꞌba akumu nima kpaki sowɔ. ");
INSERT INTO bex_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ilele yïmo kurögö tokpe mo ga ti wato mo ga kodɔꞌbɔ pili bi kɔtɔ ti dɔmo ni ti kapa mɔtɔ mo ga. ");
INSERT INTO bex_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kina ꞌdɔ koŋma pili dɔ bi ꞌba akumu yayi rɔ akoŋma zö ma ŋere Bɔkoꞌba. Tato kele mo ti kïyëyï dökïꞌdï ma ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ogba moꞌde kamölö mɔtɔ mo nima kiya zi Arona ni ti kole abo ga kiꞌdi közïnnï dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Upö kogba roma mo kosa monda mbili Arona ni ma kapa dörï lïjë ti kole abo ga. Ondi rɔ dɔkole ndïnnï ga ti dɔkole közïnnï ga ma löbu ma dɔ kapa dörï. Kɔsɔ roma mo nima ulï rɔ bi ꞌba akumu kebe dɔ kapa mo ga pili sowɔ. ");
INSERT INTO bex_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ogba kɔsɔ roma mo ame dɔ bi ꞌba akumu ne ti ꞌbu kondi rɔmo tönë kinzanza rɔ Arona kebe rɔ bɔŋgɔ ꞌbënnï ga pili lïjë ti kole abo ga. Kina ꞌdɔ kulömu bo pili ti kole abo ga ti bɔŋgɔ abo zö. ");
INSERT INTO bex_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Bi kambi ꞌba kamölö mo nima umu yaga, giliti ma kambi mo nima ti ꞌbu ma kora rɔ a ꞌba yïmo ga ti kapa luru mo ma laka mo ti dɔꞌjɔ mo ga kpaki rïyö ti ꞌbu mo ga rɔmo ti wato mo ma kapa dörï. ");
INSERT INTO bex_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kina ꞌdɔ kogba dɔkomali maŋgolɔꞌbɔ mo tönë ga kiꞌdi ꞌdeni zö yayi ne di yïmo rɔ kɔtɔkɔtɔ. Ma koꞌdɔ ti ꞌbu gɔmo nima ogba kɔtɔ, ma kinza ꞌbu gɔmo mo nima ogba gbï kɔtɔ kina ma kɔzɔ lëmbërë mo tönë ogba gbï kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Iꞌdi akonyo naga nime közï Arona ni ti kole abo ga, kina ꞌdɔ kiya zïnnï lïjë kulömu zö rɔ kpa közï kiꞌdi zö ma ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kina ꞌdɔ kogba di közïnnï koŋma dɔ bi ꞌba akumu yayi kɔtɔ ti akoŋma mo tönë. Tato kele mo ïyëyï dökïꞌdï ma, ma ŋere Bɔkoꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ogba dɔŋgoꞌdo kamölö mo nima kulömu zö rɔ kpa közï kiꞌdi ma koro. Dɔŋgoꞌdo mo nime ma ꞌbëyï na. ");
INSERT INTO bex_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ɔdɔ këdï kiꞌdi bɔ akumu, oweli dɔŋgoꞌdo ti wato kamölö ma kulömu ꞌdeni zö rɔ kpa közï kiꞌdi ma koro mo tönë ꞌberi zi bɔ akumu. ");
INSERT INTO bex_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Meri ma ame ꞌdɔ köꞌbö ŋburu kinza kuyï yïmo na me zïnnï lïjë bilaka ma ga Yisarele. Ɔdɔ lïjë kumu akumu dɔŋgoꞌdo mo ga ti wato mo ga ꞌba bɔ akumu mo na. Ame na rɔ kpa közï kiꞌdi ꞌbënnï ꞌba bilaka zö ma ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Bɔŋgɔ ꞌba Arona nime di pötö tölë abo kolɔlɔ ꞌjaa nduwë kiꞌdi zi kole abo ga. Zïnnï tusu mo ꞌjaa ɔdɔ kiꞌdi lïjë ꞌdeni rɔ bɔ akumu. ");
INSERT INTO bex_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Kole ꞌba Arona mo ame kindaꞌba pötö bo rɔ bɔ akumu tari mï rö koro ma ꞌba ŋere Bɔkoꞌba toja laja zö mï bi koro ma mo nima ne kolɔ bɔŋgɔ nima titi ŋbö dɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ogba yida kamölö mo nima kumu rɔ Arona ni ti kole abo ga mï tiꞌdi lïjë rɔ bɔ akumu ne kiꞌdi kïlëꞌdï mï bi koro mo yayi. ");
INSERT INTO bex_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kina ꞌdɔ lïjë konyo di kpadörï mo bine ti kɔsɔ maŋgolɔꞌbɔ mo tönë ga mï kee yayi ne. ");
INSERT INTO bex_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Lïjë konyo wa ma kumu rönnï tileŋo lïjë kɔpɔ rɔ bɔ akumu nima. Bɔ akumu ni na ŋge ꞌdɔ konyo römöyï bi ma koro mo na. ");
INSERT INTO bex_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ɔdɔ kɔsɔ yida mo ti maŋgolɔꞌbɔ mo ga kileke konyo rönnï dë kote kinza kola dë kpe köꞌdö ꞌdɔ konyo ꞌjaa ŋbɔ. Oŋma yaga römöyï a koro na. ");
INSERT INTO bex_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Dölëtï ꞌba tiꞌdi wa rɔ bɔ akumu nime oꞌdɔ rɔ Arona ni ŋbö dɔ modɔmorïyö koꞌdɔ kɔzɔ ame mose zïyï ne. ");
INSERT INTO bex_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Bi këzë ma dɔ kɔtɔ kiteli dë kinza ma kumu ŋgulö yïmo rɔ akumu. Römöyï ꞌdɔ kola lïjë gɔ lende kënyë ꞌbënnï ga. Kina gɔ kileŋo dɔ bi ꞌba akumu gbï timo yaga rɔ ma kɔpɔ. Ondi ꞌbu rɔ bi ꞌba akumu nima gɔ këdï yaga rɔ ma kɔpɔ. ");
INSERT INTO bex_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Oto toꞌdɔ mo nduwë te ŋbö dɔ modɔmorïyö gɔ bi ꞌba akumu këdï ŋgï rɔ ma koro. Kina ɔtɔ ame kako kosa rɔmo ti këdï rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ziye kpe dɔ kupö ame ga këdï kako ne, umuke kole kamölö ma kɔmɔ kɔɔ mo ga ꞌdeni kɔtɔ ne nduwë rɔ rïyörïyö zö rɔ kɔmɔ lëndö dɔ bi ꞌba akumu ma. ");
INSERT INTO bex_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kumu kɔtɔ rɔ mï dɔŋbɔ tine kɔtɔ rɔ mï dɔkɔpiyari. ");
INSERT INTO bex_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kamölö ma dɔgba mo oꞌde ti kilɔ kɔtɔ ꞌba ruzu ma kele kuturö ti ꞌbu kizaza rïyö. Odɔ kizaza layi rïyö bërï rɔ yëyï zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kamölö mɔtɔ mo nima umu rɔ mï dɔkɔpiyari. Kina gɔ koꞌde wa naga nime gbï ŋgila mo zö ma ŋere Bɔkoꞌba. Tato kele mo ïyëyï dökïꞌdï ma, ma ŋere Bɔkoꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Kina ꞌdɔ köꞌbö nduwë tara zi dɔ kupö ame ga këdï kako ne, akoŋma zö ma ŋere Bɔkoꞌba nime koꞌdɔ zö kpadörï ma nime. Di bina na ti mondɔsɔ ti bilaka ma ga milende tïyï. ");
INSERT INTO bex_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ti mondɔsɔ tïnnï lïjë bilaka ma ga Yisarele bina. Bi nzari ꞌba kɔmɔ ma ti koꞌdɔ bi nima ŋgï yaga rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ti moꞌdɔ rö nima ti bi ꞌba akumu mo yaga rɔ ma koro. Kina ti moweli Arona ni ti kole abo ga zö rɔ bɔ akumu toja laja zö. ");
INSERT INTO bex_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ti moloma mï löŋgö lïjë Yisarele mëdï rɔ ŋere Bɔkoꞌba ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kina lïjë ti kikali ma ŋgï rɔ ŋere Bɔkoꞌba ꞌbënnï ame koja lïjë yaga di Ezipeto ꞌdɔ moloma mï löŋgö lïjë. Ma na rɔ ŋere Bɔkoꞌba ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Oꞌdɔ bi ꞌba akumu toŋma akato kele dɔmo di mï ŋgërï kono ");
INSERT INTO bex_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","rɔ dɔ ꞌbaga rɔ ma koriya dɔkɔmɔ kolɔkɔ muyï. Takpa mo ma kari tɔrɔ këdï dɔkɔmɔ kolɔkɔ modɔmosowɔ. Gɔ dɔ kumu mo ga kpaki sowɔ oꞌdɔ rɔ ma kapa kɔzɔ biti kambi kɔtɔ timo. ");
INSERT INTO bex_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ora rɔmo pili kebe dɔmo ma di tɔrɔ ti biti mo ga ti yamo köbököbö. Kina gɔ kïyöru dɔ kpamo ga gbï ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Oꞌdɔ kano rïyö rɔmo di mï yamo köbököbö kebe kpa bïcï ma kïyöru mo nima kebe gɔ dɔ kapa mo ga kpaki rïyö tombi mo timo. ");
INSERT INTO bex_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Oꞌdɔ ŋgërï kombi mo ga di mï kono komba rɔmo ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ïdëyï bi ꞌba akumu ame yaga kebe kɔmɔ bɔŋgɔ kuröbö mo tönë kɔmɔ sandu ꞌba lömu yayi ne. Bi nima na ti mako mondɔsɔ tïyï teyi. ");
INSERT INTO bex_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Rɔ gɔ dɔŋbɔ ꞌba kɔmɔ lëndö löbu nime pili Arona köꞌbö toŋma akato kele dɔ bi ꞌba akumu nime ɔdɔ bo këdï kako tileŋo lamba naga nime. ");
INSERT INTO bex_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kina gɔ bo koꞌdɔ gbï tara mï dɔkɔpiyari mo ga ɔdɔ bo këdï kiꞌdi paꞌdo dɔ lamba mo naga nime. Toŋma akato kele nime köꞌbö ŋburu tara rɔ kɔmɔ lëndö löbu nime kɔrɔ dë. ");
INSERT INTO bex_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kinza kebe koŋma kïnë agbaꞌji ame ma ŋere Bɔkoꞌba moꞌdɔkɔ dë ne dë dɔ bi ꞌba akumu nime. Kinza koŋma yida ma kumu rɔ kpa közï ala nyönyu mo ga dë gbï dɔmo. A mɔtɔ rɔ layi kinza kodɔ dë gbï dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Arona kondi roma kamölö ma kumu gɔ tombi lende kënyë naga rɔ biti mo naga nime ŋge mï kɔtɔ mï kɔmɔ kɔɔ kɔtɔ. Kina ꞌdɔ köꞌbö toꞌdɔ mo nduwë te rɔ gɔ dɔ kupö ma këdï kako naga nime rɔ gɔ kɔmɔ kɔɔ löbu nime pili. Bi ꞌba akumu nime kulömu yaga mï kɔtɔ rɔ ma koro zö ma ŋere Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ŋere Bɔkoꞌba iya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ɔdɔ këddï kugu möyï Yisarele tïtëtë mo, iya zïnnï mɔtɔ kopi gɔ dïdï nï di zö ti yamo kinza koꞌde dɔ kututu dönï mï möyï kugu nime. ");
INSERT INTO bex_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Bɔtɔ ame kɔꞌbɔ ꞌdeni ꞌdɔ kugu möyï mo ne kopi kɔzɔ ma kiteri mo nima gɔ ndögö mo ma kɔrɔ ꞌdeni dɔmo. Lïjë pili kopi rɔ kpa közï kiꞌdi zö ma ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Bilaka ame pili kïtëtë ꞌdeni mï möyï kugu nime kisaki di dɔ ma kɔmɔ kɔɔ mo ꞌbutë rïyö nduwë kala dɔgba kopi yamo nime zö. ");
INSERT INTO bex_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Kinza kiꞌdi dë bɔ mɔri kopi kebe bɔ ma rɔ lisa tine lïjë pili kopi rɔ ma koriya. ");
INSERT INTO bex_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ogba yamo nime lïjë Yisarele këdï kopi ne koꞌdɔ ndɔbɔ ma timo mï rö ma bine. Awada nime ꞌba tutë gɔ dïdï nnï timo na. Kina ti miꞌdi lende mo ŋgï këdï dɔma zö tɔmɔ lïjë.” ");
INSERT INTO bex_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ŋere Bɔkoꞌba iya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Oꞌdɔ wörï ꞌbïlëŋï ti bi kïdëyï mo teyi gbï di mï ꞌbïlëŋï. Utë mï löŋgö rö ma nima ma ti bi ꞌba akumu. Kina gɔ kunö mini yïmo. ");
INSERT INTO bex_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Arona ni ti kole abo ga kurögö közïnnï ti ndïnnï ti mini mo nime ");
INSERT INTO bex_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ɔdɔ lïjë këdï koꞌdɔ tɔdɔ tari mï rö ma ala ŋgila bi ꞌba akumu mo toŋma kpa közï kiꞌdi mo ga zö. ");
INSERT INTO bex_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Lïjë kurögö közïnnï ti ndïnnï kinza mupö lïjë ra. Köꞌdu kiꞌdi nime lïjë kindaꞌba nduwë koro köꞌbö rɔ ŋburuŋburu rɔ gɔ dɔ kupö nnï ga.” ");
INSERT INTO bex_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ŋere Bɔkoꞌba iya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ogba agbaꞌji kato kele naga nime koꞌdɔ ꞌbu kondi rɔ. Ogba a kïdëkï rɔ murï ne kilɔ modɔɔkɔtɔ, yɔkɔ ŋgërï kïdëkï rɔ girifa ne ma kato koŋmi mo kilɔ mota, matuŋburu kilɔ mota, ");
INSERT INTO bex_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kono kilɔ modɔɔkɔtɔ kiyari gɔ ndögö mo ma kɔrɔ ꞌdeni dɔmo. Odɔ kizaza rïyö ꞌba ꞌbu ma kele gɔmo ");
INSERT INTO bex_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","koꞌdɔ ꞌbu kato kele rɔ a ꞌba tondi mo. ");
INSERT INTO bex_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ꞌBu kondi mo nime na ꞌdɔ kondi rɔ rö ma, rɔ sandu ꞌba lömu, ");
INSERT INTO bex_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","rɔ tarabiza mo pili ti jama mo ga, rɔ akïdëyï lamba ni pili ti jama mo ga, rɔ bi ꞌba akumu ma ꞌba toŋma akato kele mo nima, ");
INSERT INTO bex_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kina ma ꞌba toŋma yida mo nima gbï kpaki ti jama ma ꞌba bo ga, rɔ wörï kurögö közï mo tönë kpaki ti bi kïdëyï mo. ");
INSERT INTO bex_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ulömu kɔzɔ a nime te zö kina ti lïjë këdï ŋgï pili rɔ ma koro. Kina bɔtɔ ala ɔtɔ ame kako kosa rɔmo ti toro mo koꞌbe ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Kina ondi ꞌbu mo nime gbï rɔ Arona ni ti kole abo ga ꞌdɔ lïjë këdï rɔ bɔ akumu zö mï ndɔbɔ ma. ");
INSERT INTO bex_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Iya zïnnï lïjë Yisarele, ‘ꞌBu kondi koro ma nime köꞌbö nduwë toꞌdɔ mo tara mï ndɔbɔ ma rɔ ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tine kinza kinzanzake dë rɔ bilaka ma sari. Kina kinza nï mɔtɔ kotɔtɔ dɔ amo naga nime dë gbï koꞌdɔ ꞌbëyï zïyï tara. ꞌBu koro na. Kina iꞌdike köꞌbö rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Bɔtɔ ame koꞌdɔ kïnë mo ala kosa rɔ bɔtɔ ame kinza rɔ bɔ akumu ne bo inza kpe rɔ bilaka ma.’” ");
INSERT INTO bex_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ŋere Bɔkoꞌba iya zi Musa te, “Ogba dɔkomali agbaꞌji kato kele naga nime pili rɔ gɔmo rɔ ma koriya, tagi ꞌba lɔkpɔ, yɔkɔ kïlïꞌdï, akïlërï ti ꞌboŋa ma kato kele naga, ");
INSERT INTO bex_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","koꞌdɔ akato kele kɔzɔ riya. Odɔ tikɔꞌdɔ gɔmo ꞌdɔ köꞌbö rɔ ma laka rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Uꞌbë mɔtɔ yaga rɔ ruzu kari timo kinzanza mï rö ma yayi kɔmɔ sandu ꞌba lömu mo nima. Bi nima na ti mako mondɔsɔ tïyï teyi. Akato kele nime këdï rɔ a koro ziye. ");
INSERT INTO bex_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kinza koꞌdɔke agbaꞌji mɔtɔ dë ziye kɔzɔ a nime te. Iꞌdike ŋge këdï rɔ a ma koro ame kulömu ꞌdeni zö ne. ");
INSERT INTO bex_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Bɔtɔ ame koꞌdɔ kïnë mo zi bo ala rɔ riya bo inza kpe rɔ bilaka ma.” ");
INSERT INTO bex_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ŋere Bɔkoꞌba iya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Moza Bezalele kole ꞌba Urï kole ꞌba kole ꞌba Uru ꞌdeni di mï kupö eꞌbe Yuda. ");
INSERT INTO bex_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Miꞌdi Nyï Kɔtɔ Laka ma ꞌdeni lɔ mï bo. Miꞌdi akikali ti miri ꞌba toꞌdɔ wa pili ꞌdeni zi bo, ");
INSERT INTO bex_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","tose wa rɔ miri toꞌdɔ mo di mï yamo köbököbö ni ti sïtërï gbï ti ꞌbïlëŋï ");
INSERT INTO bex_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kina mɔtɔ gbï toga lele ti tose ŋgërï ni pili rɔ gɔ ndɔbɔ ꞌba közï. ");
INSERT INTO bex_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Moza Oliba kole ꞌba Asamaka di mï kupö eꞌbe Dana ꞌdeni ꞌdɔ këdï rɔ bɔ gɔ Bezalele toꞌdɔ ndɔbɔ nime ti bo. Kina miꞌdi akikali mo ti tigɔ ꞌdeni gbï zi bɔ miri mɔtɔ naga nima ꞌdɔ lïjë koꞌdɔ wa ma tönë ga pili mose gɔmo zïyï tiya mo zïnnï ꞌdɔ toꞌdɔ mo ne, ");
INSERT INTO bex_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","rö kilaka ma nime ti sandu mo ti a dɔmo ti jama mo ga pili, ");
INSERT INTO bex_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ti tarabiza mo ti jama mo ga pili, ti akïdëyï lamba mo tönë di mï yamo köbököbö ne ti jama mo ga pili, ti bi ꞌba akumu ma ꞌba toŋma akato kele mo tönë ");
INSERT INTO bex_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","gbï ti ma ꞌba toŋma yida ꞌba akumu mo dɔmo nima kpaki ti jama mo ga pili, ti wörï ꞌba turögö közï mo tönë ti bi ꞌba tïdëyï mo, ");
INSERT INTO bex_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ti bɔŋgɔ koro ꞌba rɔ bɔ akumu zi Arona ni ti kole abo ga zïnnï tolɔ mo ɔdɔ lïjë këdï kari toja laja ma, ");
INSERT INTO bex_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ti ꞌbu kondi mo tönë ti agbaꞌji kato kele mo tönë gbï mï gɔ bi ma koro mo ne. Wa naga nime toꞌdɔ mo këdï pili kɔzɔ ma tönë miya zïyï ne.” ");
INSERT INTO bex_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Bɔkoꞌba ose zi Musa ");
INSERT INTO bex_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","gɔ bo kiya zi Yisarele te, “Oroke kada ꞌba rɔ kindawo ma. Römöyï na rɔ akileme mï löŋgö ye tö ma ŋere Bɔkoꞌba nduwë mï kada ma këdï kako naga nime ꞌdë gɔ kinda ŋgï omba moza ye ꞌdeni rɔ ꞌbama ga. ");
INSERT INTO bex_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ziye toro kada ꞌba rɔ kindawo römöyï kada ma koro kɔtɔ laka ma na. Bɔtɔ ame koro dë kebe koꞌdɔ ndɔbɔ mï kada nime ne kupö ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Töꞌdö ëdï ꞌdo zïyï dɔ modɔɔkɔtɔ toꞌdɔ ndɔbɔ yïmo. Tine töꞌdö ma rɔ dɔ modɔmorïyö mo nima ꞌba rɔ kindawo na ŋge, ulömu ꞌdeni zö. Bɔtɔ ame kosa ndɔbɔ közï bo mï kada nime kupö yaga. ");
INSERT INTO bex_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kpe Yisarele indaꞌbake lende ꞌba kada nime rɔ akileme ꞌba lömu ma, ma ŋere Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Akileme ma ŋburuŋburu na mï löŋgö ze tiye kpe Yisarele. Römöyï ma ŋere Bɔkoꞌba moꞌba mïtɔrɔ ni ti dɔyayi ꞌdeni pili mï töꞌdö dɔ modɔɔkɔtɔ. Tine mï töꞌdö ma rɔ dɔ modɔmorïyö mo mɔrɔ ndɔbɔ pili ꞌdeni mindawo rɔma.” ");
INSERT INTO bex_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kina ɔdɔ Bɔkoꞌba kote tilende ꞌdeni ti Musa di dɔ döku Sinayi yayi na bo kiꞌdi lere rïyö ꞌba köꞌdu kiꞌdi mo tönë ga bo kugu ꞌdeni ti közï bo ne ŋgï zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Tine ɔdɔ Yisarele naga nima lïjë koŋgɔ ꞌdeni Musa kigabi ŋgï dɔ döku bitɔ tɔ ne ga yayi kileki dë kpe welo tine, na lïjë kotɔtɔ rönnï ŋgï kari zi Arona kiya te, “Ako koꞌdɔ akoro zize ꞌdɔ kokɔkɔ ze. Musa bɔ koꞌde ze yaga di mï Ezipeto mo nime dikali abo dë waꞌdi na kömö ꞌdeni zi bo di bitɔ yayi.” ");
INSERT INTO bex_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Arona ileki zïnnï te, “Ari kotɔtɔke yamo köbököbö di mbili ꞌja ꞌbe ga ti yïtötï ꞌbe ga ti kole ꞌbe ga koꞌdeke kako zö dayi.” ");
INSERT INTO bex_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kina lïjë pili kari kotɔtɔ ambili ŋgï koꞌde kako zi Arona. ");
INSERT INTO bex_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kina bo kogba a tönë ga ŋgï koꞌdɔ rɔ akoro zïnnï. Bo uku kɔzɔ kïnë kole sa naga nima tara. Kina lïjë kebe nati tiya mo rɔ gɔ rönnï tëgë, “Yisarele, mïtɔrɔ ꞌbe mo tönë koꞌde ye yaga di mï Ezipeto ne bo na me.” ");
INSERT INTO bex_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Tine ɔdɔ Arona koŋgɔ ꞌdeni tara bo oꞌba bi ꞌba akumu kebe kɔmɔ a nima yayi. Na bo kuwöwö zïnnï te, “Tïlëndö, karama ma löbu ëdï bine zi ŋere Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kina ŋgï mɔlo mï bi këzë mo nima na bilaka naga nime koꞌde akoŋma ŋgï kako gbï ti akumu. Kina lïjë koloma ŋgï nati rɔ tonyo kpënnï tuwë mo. Tine ari kuyï rönï za ꞌböwu ŋgï yaga di dɔmo rɔ lende yawa. ");
INSERT INTO bex_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Bɔkoꞌba iya zi Musa te, “Ëkï kileki kari bërï. Bilaka ꞌbï tönë ga koꞌde lïjë kako yaga di mï Ezipeto ne dönnï ele dë kpe. ");
INSERT INTO bex_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Lïjë ebe ꞌdeni ŋgï kuyï kpënnï yaga welo di zö lïjë koꞌdɔ akoro zïnnï kuku kɔzɔ kïnë kole sa naga nima tara. Kina me lïjë këdï ꞌdeni rɔ tumötu mo lïjë kumu roma teyi. Lïjë ebe ꞌdeni bi tiya mo te, ‘Yisarele, mïtɔrɔ ꞌbe mo tönë koꞌde ye yaga di mï Ezipeto ne bo na me.’” ");
INSERT INTO bex_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Bɔkoꞌba iya zi Musa te, “Bilaka naga nima mikali lende ꞌbënnï ꞌdeni. Lïjë ŋgï rɔ a dɔ kitigɔ tɔ ne ga. ");
INSERT INTO bex_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kina me nï, kinza koꞌdɔ kpërï dë kpe zö. Ola lïjë zö gɔ mileme wa zïnnï mote dönnï yaga. Kina ti miꞌdi yi ŋgï kara rɔ kpa dɔꞌbe ma kinza kiya.” ");
INSERT INTO bex_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tine Musa ebe tomaꞌjo rɔ bo zi ŋere Bɔkoꞌba abo, iya te, “Yö ŋere Bɔkoꞌba, iꞌdi mïyï ŋgï kata kulöwö te gɔ waꞌdi rönnï lïjë bilaka ꞌbï naga nime kɔmɔ lïjë ꞌdeni ti tigɔ ꞌbï koja lïjë yaga di mï Ezipeto ne? ");
INSERT INTO bex_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Gɔ waꞌdi na ꞌdɔ kiꞌdi Ezipeto kebe ꞌböwu togora gönnï kiya te oꞌde lïjë ka tote dönnï yï mökö kɔmɔ döku bine? Iꞌdi mïyï tɔ kpe këyï rönnï. Kinza koꞌde dɔ kote dë dönnï lïjë bilaka ꞌbï ga. ");
INSERT INTO bex_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Lömu ꞌbï ma tönë koꞌdɔ ti bɔ laja ꞌbï ga Abarayama ni ti Yisika ti Yakoba ne, omeri gɔmo te. Lömu ꞌbï ma tönë koꞌdɔ ꞌdeni zïnnï ꞌdɔ kiꞌdi kupö lïjë kara kɔzɔ këlu ꞌba mïtɔrɔ ne, omeri gɔmo te. Kina gbï lömu ꞌbï ma tönë koꞌdɔ gɔ yayi nime tiꞌdi mo zi dɔ kupö lïjë ga rɔ ëꞌbënnï rɔ ŋburuŋburu ne, omeri gɔmo te.” ");
INSERT INTO bex_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kina Bɔkoꞌba kola a tönë ga bo komeri ꞌdɔ tote dɔ bilaka abo ga yaga timo ne ŋgï gbɔ. ");
INSERT INTO bex_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Musa ënyï ꞌdeni këdï rɔ tëkï tako bërï di dɔ döku ti lere rïyö mo tönë ga Bɔkoꞌba kugu köꞌdu kiꞌdi abo ga ꞌdeni dɔmo ne. Bɔkoꞌba na koꞌdɔ lere nima kugu köꞌdu kiꞌdi abo ga dɔmo ti közï bo kebe kapa mo ga kpaki rïyö. ");
INSERT INTO bex_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yësuwa uwö birɔ dɔ kudu, na bo kiya zi Musa te, “Ya ëdï mï taya.” ");
INSERT INTO bex_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa ileki zi bo te, “Birɔ ya inza tara. Römöyï udu dë kɔzɔ birɔ akaꞌda ala birɔ gɔ koga. Birɔ ŋgala ma këdï koba na za muwö ꞌbama.” ");
INSERT INTO bex_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kina ɔdɔ Musa ni kako kömö ꞌdeni ŋgɔsi ŋgila taya bo koꞌja kïnë kole sa nima ti ŋgala kusï tara tine na mï bo kata ŋgï bo kuꞌdu lere tönë ga ŋgï bërï kilaꞌba kitikɔ yaga ndï döku yayi. ");
INSERT INTO bex_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kina bo kako kogba kole sa ꞌbënnï mo tönë lïjë kuku ne ŋgï kuꞌdu dɔ paꞌdo kilaŋma yaga. Na bo kosono ŋgï kodɔ mï mini kiꞌdi kpa Yisarele naga nima kuwë. ");
INSERT INTO bex_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Bo ititi Arona, iya te, “Waꞌdi na ya naga nime koꞌdɔ zïyï kiꞌdi yi kusu kpënnï mï lende kënyë löbu dɔ kiteli nime?” ");
INSERT INTO bex_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Arona iya te, “Kinza kembe dë ka rɔ ꞌdïrï tö. Bilaka naga nime ndörö ꞌbënnï ma gɔ lende kënyë ikali ëꞌbï ꞌdeni gbï mɔlo. ");
INSERT INTO bex_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Lïjë na kalo dɔma bine, kiya te, ‘Oꞌdɔ akoro zize gɔ kösö dɔgba zize. Musa bɔ koꞌde ze yaga di Ezipeto nime dikali abo dë waꞌdi na kömö ꞌdeni zi bo di bitɔ yayi.’ ");
INSERT INTO bex_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kina me mënyï miya zïnnï te, ‘Nï bɔ ame këddï ti ambili yamo köbököbö ogba yaga koꞌde kako.’ Kina ma lïjë koꞌde kako zö mogba muꞌdu mï paꞌdo na kɔdɔ ŋgï rɔ kole sa nima.” ");
INSERT INTO bex_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa oŋgɔ Arona ola bilaka naga nima ꞌdeni dɔmo kaya kebe todɔ laŋa rönnï kɔmɔ bɔ ya ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Kina bo kɔrɔ ŋgï yaga kpa reki bo kuwöwö dɔ bo rɔ ma kembe kiya te, “Lïjë ame ga rɔ ꞌba Bɔkoꞌba ne kako bine.” Kina kupö eꞌbe Lëwë ga kɔlɔ ŋgï kuru bo bërï. ");
INSERT INTO bex_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kina bo kiya zïnnï te, “Nï mɔtɔ ŋere Bɔkoꞌba ꞌba Yisarele iꞌdi köꞌdu mo ꞌdeni zïyï, indaꞌba mbele ꞌbï kisaki di kapa taya ma bine ŋbö kala ꞌdë, upö löndö yï, bɔ murë yï ti bɔ pɔri yï.” ");
INSERT INTO bex_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Kina eꞌbe Lëwë naga nima pili koꞌdɔ ŋgï kɔzɔ ma Musa kiya zïnnï. Bilaka ma kupö mï kada nima ëdï pili kɔzɔ kuluku ꞌbutë bi modɔɔkɔtɔ (3000) tara. ");
INSERT INTO bex_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa ileki zi eꞌbe Lëwë naga nima te, “Tɔne, ulömuke rɔye ꞌdeni rɔ bɔ akumu zi ŋere Bɔkoꞌba ti löpö nime kupöke kole ꞌbe ga ti löndö ye ga ne. Bɔkoꞌba oꞌdɔ yëyï ꞌdeni dɔye.” ");
INSERT INTO bex_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mï bi këzë ma di pötö mo na Musa kiya zi bilaka naga nima te, “Oꞌdɔke lende kënyë ma dɔ kiteli ꞌdeni. Mëdï mileki mari dɔ döku tɔrɔ zi ŋere Bɔkoꞌba. Mɔtɔga ti miꞌdi bo kola ye gɔ lende kënyë ꞌbe nime.” ");
INSERT INTO bex_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kina Musa kuyï dɔ bo kileki kari zi ŋere Bɔkoꞌba kiya te, “Bilaka tönë ga oꞌdɔ lende kënyë ma rɔ dɔ kiteli ꞌdeni. Lïjë uku akoro zïnnï di mï yamo köbököbö lïjë koloma rɔ tumötu mo. ");
INSERT INTO bex_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Momaꞌjo rɔma zïyï ola lïjë gɔmo. Ne ɔdɔ kola lïjë dë kpe gɔ lende kënyë nime, möyï ma mo na kore gbɔ yaga di mï buku ꞌbï ame kugu möyï bilaka ꞌbï ga yïmo ne.” ");
INSERT INTO bex_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ŋere Bɔkoꞌba ileki dɔmo zi Musa te, “Lïjë bɔtɔ bɔ kirasi lende mo naga nima na ti more möyï nnï yaga di mï buku ma. ");
INSERT INTO bex_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ne ari kokɔkɔ lïjë koto bi mo tönë miya ne. Malayika ma ti koda bi di rɔye. Ne kada mo ti kömö ꞌdeni ame ꞌdɔ modɔ karama dönnï lïjë bilaka naga nima gɔ lende kënyë ꞌbënnï ga.” ");
INSERT INTO bex_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kina Bɔkoꞌba koja rɔkɔꞌɔ ŋgï dɔ Yisarele römöyï lïjë ebe kiꞌdi Arona koꞌdɔ akoro zïnnï di mï yamo köbököbö kɔzɔ kïnë kole sa naga tara. ");
INSERT INTO bex_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kina ŋere Bɔkoꞌba kilende zi Musa iya te, “Ënyï di bine tïnnï lïjë bilaka naga nima koꞌde lïjë di Ezipeto ne karike mï dɔyayi ma mulömu tiꞌdi mo ziye mo tönë, dɔyayi mo tönë mulömu tiꞌdi mo zi Abarayama zi Yisika zi Yakoba gbï zi dɔ kupö lïjë ga ne. ");
INSERT INTO bex_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ti moja malayika kari dɔgba kɔmɔye ꞌdɔ koga Kanana naga nima ti Amora ti Ete ti Pereze ti Iwa ti Yebusa mo ga pili yaga. ");
INSERT INTO bex_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ëddï karike nime mï yayi ma laka ame wï sa ni ti tagi kambi di teyi kɔzɔ sëgë. Tine minza mari tiye römöyï kpe rɔ bilaka dɔ kitigɔ tɔ ne ga. Ɔdɔ mari tiye ti mote dɔye gɔ kɔri.” ");
INSERT INTO bex_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kina ɔdɔ bilaka naga nima kuwö ꞌdeni te tine na lïjë kudu ŋgï kolali yamo ma köbököbö ꞌdoyi yaga di rönnï. ");
INSERT INTO bex_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Römöyï ŋere Bɔkoꞌba iꞌdi köꞌdu mo ꞌdeni zi Musa kiya zïnnï te, “Kpe rɔ bilaka dɔ kitigɔ tɔ ne ga. Ma mëdï mari ra tiye pele ŋgɔsi te dëne ti mote dɔye ŋgï yaga. Kina me ti olalike yamo köbököbö ꞌba tiyada rɔye timo naga nime ꞌdoyi yaga di rɔye gɔ momeri dɔma gɔ wa ma ꞌdɔ moꞌdɔ ziye.” ");
INSERT INTO bex_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kina Yisarele kolali yamo köbököbö ŋgï ꞌdoyi yaga di rönnï di ndï döku Sinayi yayi. ");
INSERT INTO bex_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Tine Musa ëdï nduwë rɔ tombi rö kilaka kiliŋgere timo. Bi ame lïjë koga taya teyi bo ogba rö kilaka nima kutötï mbowa sege yaga di ŋgila mo. Bo ïdëkï möyï mo rɔ “Rö ꞌba tondɔsɔ.” Bɔ ame koꞌdɔkɔ tikali akoꞌdɔkɔ ꞌba Bɔkoꞌba kako teyi bina. ");
INSERT INTO bex_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ɔdɔ Musa këdï kari ꞌdeni teyi yayi bilaka pili ɔdɔ kɔrɔ yaga kpadörï ꞌbënnï ga toŋgɔ gɔ bo ŋbö bo kɔdɔ yïmo. ");
INSERT INTO bex_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ɔdɔ bo kɔdɔ ꞌdeni yïmo na pɔli kakpa mo tönë kako kutuꞌbö rönï ŋgï kpadörï mo. Kina ŋere Bɔkoꞌba ti kebe ŋgï rɔ toloma tilende ti bo di yïmo yayi. ");
INSERT INTO bex_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tine ɔdɔ lïjë koŋgɔ pɔli nima ꞌdeni kutuꞌbö rönï kpadörï dɔ Musa tara na lïjë kënyï kolɔdɔ ŋgï bërï. ");
INSERT INTO bex_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kina ŋere Bɔkoꞌba koloma ŋgï rɔ tilende ti Musa di dɔ kɔmɔ dɔ kɔmɔ te, kɔzɔ nï bilaka ame këddï kilende ti lëpï yï mɔtɔ ne. Di pötö mo tine Musa ileki ꞌjaa kako mï taya. Tine kole yɔbi ame rɔ bɔ gɔ bo mo kïdëkï möyï mo rɔ Yësuwa, kole ꞌba Nunu ne oloma ma ꞌba bo ŋgï köꞌbö ŋburu mï rö ꞌba Bɔkoꞌba yayi. ");
INSERT INTO bex_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa ënyï kileki zi Bɔkoꞌba iya te, “Ëdï ŋgï rɔ ma laka kɔzɔ lende kiya ꞌbï tara zö ꞌdɔ mokɔkɔ bilaka naga nime mï dɔyayi nima. Ne oŋgɔ a mɔtɔ ëdï gba kɔtɔ bine ame kola kinza kiya dë. Yë na këdï kari tize? Iya ꞌdeni te ikali ma laka, nï Bɔkoꞌba ti mï këyï tö. ");
INSERT INTO bex_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ne ɔdɔ kiya te këdï ŋgï tara ïyëtï gɔ meri ꞌbï ga ma koꞌdɔkɔ toꞌdɔ mo zö, römöyï gɔ möꞌbö toja laja zïyï tïyëyï dökïꞌdï yï. Kina omeri gbï te nï na koza dɔ kupö nime ꞌdeni zïyï rɔ ëꞌbï ga.” ");
INSERT INTO bex_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ŋere Bɔkoꞌba iya te, “Ti mari tiye miꞌdi ye kaꞌdake bɔ ya ꞌbe ga.” ");
INSERT INTO bex_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa iya zi Bɔkoꞌba te, “Ɔdɔ tari ꞌbï tize kinza, kinza kiꞌdi dombi ndïze dë dari bitɔ di mï gɔ bi nime bine. ");
INSERT INTO bex_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ti kikali tondo ma këddï ti mï këyï rɔ bilaka ꞌbï ga gbï tö, ɔdɔ kiya te kari dë tize? Kïnë yï mo ɔdɔ këdï tize na ti koza ze ꞌberi yaga di rɔ bilaka ma laki ꞌba dɔyayi nime.” ");
INSERT INTO bex_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Bɔkoꞌba iya zi Musa te, “Ti moꞌdɔ ŋgï zïyï kɔzɔ ma kititi. Römöyï nï mikali yi ꞌdeni laka ma ti mï këyï tïyï.” ");
INSERT INTO bex_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa iya te, “Iꞌdi ma moŋgɔ bi nzari ꞌba kömöyï te.” ");
INSERT INTO bex_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Bɔkoꞌba iya te, “Ti miꞌdi rɔ löbu ma kinda kömöyï kïdëkï möyï koro ma zïyï. Ma na rɔ ŋere Bɔkoꞌba. Ti mileme mï koŋmi ma ti mï këyï ma zïnnï lïjë ame ga migeli ꞌdeni ne. ");
INSERT INTO bex_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Tine minza miꞌdi yi koꞌja kɔmɔ ma. Römöyï bɔtɔ ma kɔtɔ mɔtɔ te oꞌja kɔmɔ ma dë kebe koloma gba ꞌböwu ꞌbiri rɔ ma kïdïdï.” ");
INSERT INTO bex_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ŋere Bɔkoꞌba iya gbï zi Musa te, “Ne ame na rɔ bi ma ŋgɔsi ŋgila ma, zïyï tɔrɔ dɔ döku nime. ");
INSERT INTO bex_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ɔdɔ tigɔ dɔ kiteli ma kudö kebe bina ti mïdëyï yi mï bi ŋgaŋi ꞌba döku mutuꞌbö yi ti közö ŋbö miteli di röyï. ");
INSERT INTO bex_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kina ɔdɔ miteli yi ꞌdeni tine na ti mombi közö ꞌjaa yaga di döyï gɔ koꞌja ŋge rɔ gɔma tine kɔmɔ ma koꞌja dë.” ");
INSERT INTO bex_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ŋere Bɔkoꞌba iya zi Musa te, “Ose lere rïyö kɔzɔ ma dɔgba tönë ga. Kina ti mugu lende tönë ga dɔ ma dɔgba kitikɔ tönë ga ne dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ileŋo röyï ndö mï dɔŋbɔ tïlëndö kako kota ma tɔrɔ dɔ döku Sinayi. ");
INSERT INTO bex_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kinza bɔtɔ mɔtɔ kako dë tïyï. Kina a mɔtɔ rɔ kïnë bɔtɔ kinda dë kapa dɔ döku nima yayi. Yërï ma kɔzɔ kamölö ni ti banya ni konyo kpënnï dë gbï ndï döku yayi.” ");
INSERT INTO bex_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kina Musa kose lere ŋgï rïyö kɔzɔ ma dɔgba tönë ga na bo kari ŋgï timo tɔrɔ dɔ döku Sinayi yayi mɔlo rɔ mï dɔŋbɔ kɔzɔ ma ŋere Bɔkoꞌba kiꞌdi köꞌdu mo zi bo tara. ");
INSERT INTO bex_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kina Bɔkoꞌba kako ŋgï bërï di mïtɔrɔ ti pɔli kɔrɔ ŋgila Musa yayi kïdëkï möyï koro abo mo tönë rɔ ŋere Bɔkoꞌba ne. ");
INSERT INTO bex_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Bo udö kebe kɔmɔ Musa yayi bo iya te, “Ma ŋere Bɔkoꞌba ma na rɔ Bɔkoꞌba ꞌba mï koŋmi bɔ toŋgɔ lisa. Mënyï dë gbï welo rɔ ꞌdïrï. Mileme akɔꞌɔ ma dɔ kiteli ma ame kinza kote rönï dë ne ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Akɔꞌɔ ma na köꞌbö ꞌdeni ŋburu tara tola wa gɔ lende kirasi ni ti lende kënyë. Tine minza mola karama ꞌba lende kirasi ꞌba ꞌbu löbu ni gbï di bi todɔ mo dɔ kole ꞌba kole mo ga ma mï mota ŋbö kala gɔ ma mï sowɔ mo ga.” ");
INSERT INTO bex_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Kina Musa kolɔdɔ ŋgï bërï kumötu ");
INSERT INTO bex_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","kiya te, “Ɔdɔ kiya te mïyï këyï ꞌdeni ŋgï rɔma momaꞌjo rɔma zïyï ari tize. Bilaka naga nime uwö mbili dë. Tine ola ze gɔ lende kirasi ti lende kënyë ze ga. Kina utï kogba ze rɔ ma ꞌbëyï ga.” ");
INSERT INTO bex_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kina ŋere Bɔkoꞌba kileki zi Musa iya te, “Mëdï moꞌdɔ lömu ma tiye kpe bilaka ma ga Yisarele. Gɔ kotɔ ame ga koꞌdɔ rönnï dë mɔlo mï löŋgö dɔ kupö ma kɔtɔ mɔtɔ di mï dɔyayi nime ne ti moꞌdɔ ziye koꞌjake ti kɔmɔye. Bilaka ame ga këddï kolomake mï löŋgö mo ne ti koꞌja tuwï ꞌba akoꞌdɔ ma ꞌba Bɔkoꞌba ma mëdï moꞌdɔ gɔye ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Köꞌdu kiꞌdi nime mëdï miꞌdi ziye tɔne ne uwöke dɔmo. Ti moga lïjë bɔtɔ naga nima pili yaga di kɔmɔye, Amora ni ti Kanana mo ga ti Ete ti Pereze ti Iwa kpaki ti Yebusa ꞌbënï ti moga yaga. ");
INSERT INTO bex_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Tine iꞌdike kɔmɔye kandi laka kinza koꞌdɔke lömu dë tïnnï lïjë bilaka ꞌba mï dɔyayi mo nima këddï karike teyi ne. Römöyï lende kënyë ꞌbënnï ti kari koloma yaga ziye rɔ abari. ");
INSERT INTO bex_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ma laka mo ziye titikɔ bi ꞌba toŋma akumu zi akoro ꞌbënnï ga yaga, kicacake mï toto koro mo ga yaga kogake sari ꞌba akoro Asera ꞌbënnï mo bërï. ");
INSERT INTO bex_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kinza kebeke dë tulömu kpeye zi a mɔtɔ römöyï ma Bɔkoꞌba ame möyï ma rɔ Mï Kombi ne ma ti mï kombi gɔye. ");
INSERT INTO bex_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Iꞌdike kɔmɔye kandi laka kinza koꞌdɔke lömu dë tïnnï lïjë bilaka ꞌba mï dɔyayi nima. Römöyï ɔdɔ kiya te lïjë këdï tulömu kpënnï zi akoro ꞌbënnï naga nima lïjë kumu roma teyi, lïjë ti kose ye gbï todɔꞌbɔ rɔye tïnnï konyoke akonyo mo ga. ");
INSERT INTO bex_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kina ti kole ꞌbe ga kogbe yïtötï ꞌbënnï ga ŋgï gbï kiꞌdi kole ꞌbe ga pele koro ma, ma ŋere Bɔkoꞌba dë kpe kebe za tulömu kpënnï zi akoro ꞌba ya naga nima. ");
INSERT INTO bex_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Kinza koꞌdɔke akoro yamo dë ziye kumötuke gbï. ");
INSERT INTO bex_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Karama ꞌba tonyo maŋgolɔꞌbɔ kinza laŋga gɔmo tönë na ꞌdɔ kindaꞌbake lende mo kiꞌdike këdï dɔye. Kɔzɔ ma mose ziye tönë tara konyoke maŋgolɔꞌbɔ ma kinza laŋga gɔmo dɔ modɔmorïyö mï nyepe ꞌba Abibi. Römöyï nyepe nime na kënyïke yïmo di Ezipeto. ");
INSERT INTO bex_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Kole dɔndende ꞌbe ga pili ti ꞌba yërï ꞌbe ga ma ꞌbama na. ");
INSERT INTO bex_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tine ma rɔ akaca naga utëke gɔmo yaga ti kamölö. Ne ɔdɔ kutë gɔmo dë, upö yaga. Kole dɔndende ꞌbe ga pili utëke gɔmo yaga. Kina kinza bɔtɔ mɔtɔ kako dë kɔmɔ ma rɔ ma sari kinza kpa közï kiꞌdi. ");
INSERT INTO bex_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Töꞌdö ëdï dɔ modɔɔkɔtɔ zïyï toꞌdɔ ndɔbɔ ꞌbï ga yïmo. Tine töꞌdö ame rɔ dɔ modɔmorïyö mo ne kinza koꞌdɔ ndɔbɔ dë yïmo. Ɔdɔ këdï pele rɔ bi dɔ rɔꞌdɔ ala kpa dɔlili zïyï tindawo röyï mï kada nime. ");
INSERT INTO bex_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Karama ꞌba kpa dɔlili ame këdï koꞌdɔ ti bi dɔ tumu nyönyu ne iꞌdike lende mo köꞌbö dɔye. Kina gbï karama ma tönë rɔ ꞌba loma bïcï ŋgöŋgöbö këdï koꞌdɔ di pötö totɔtɔ wa ꞌdeni kote yaga di mï nyaka ne kinza kiꞌdike lende mo dë kudölu di dɔye. ");
INSERT INTO bex_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Rɔ gɔye bɔtɔni pili, akoke tïlëlu ma, ma ŋere Bɔkoꞌba ꞌbe ꞌba Yisarele mï mota mï kɔmɔ kɔɔ kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Kina ɔdɔ moga dɔ kupö bilaka naga nima ꞌdeni yaga di kɔmɔye miyese gɔ dɔ maga ꞌbe ꞌdeni kɔwɔ, bɔtɔ mɔtɔ inza kɔꞌbɔ kpe ꞌdɔ tiyɔzɔ talo ya dɔye ꞌdɔ taꞌda ye mï kada ꞌba karama mota naga nime. ");
INSERT INTO bex_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ɔdɔ kumuke roma zö kinza koꞌdeke maŋgolɔꞌbɔ ma ti laŋga gɔmo dë teyi. Kina kinza kola kɔsɔ akonyo ꞌba karama ꞌba Pasaka nime dë gbï köꞌdö ŋbö bi këzë dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Rɔ gɔ kɔmɔ kɔɔ pili zïyï toꞌde a laꞌja ꞌba mï nyaka ꞌbï kako mï rö koro ꞌba ŋere Bɔkoꞌba ꞌbï. Tine kinza kebe kuꞌdï kole banya ala kole kamölö dë ti mba ꞌba ma mo.” ");
INSERT INTO bex_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kina Bɔkoꞌba kiya zi Musa te, “Lende naga nime ugu bërï, römöyï na moꞌdɔ lömu ma ꞌdeni gɔmo tïyï gbï zïnnï lïjë Yisarele pili.” ");
INSERT INTO bex_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa oloma koꞌdɔ töꞌdö ŋbö dɔ ꞌbutë sowɔ ti ŋere Bɔkoꞌba yayi kinza konyo a mɔtɔ rɔ akonyo ala kuwë mini. Kina Bɔkoꞌba kugu lömu abo mo ŋgï dɔ lere. Ïdëkï möyï mo ꞌdeni rɔ köꞌdu kiꞌdi ꞌbutë. ");
INSERT INTO bex_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Tine ɔdɔ Musa kuyï dɔ bo ꞌdeni kömö di dɔ döku Sinayi ti lere mo tönë ga kugu köꞌdu kiꞌdi mo ga ꞌdeni dɔmo ne bo ikali dë dëmba dɔ kɔmɔ bo ꞌdeni rɔ ma köbö römöyï bo oloma rɔ tilende ti Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kina ɔdɔ Arona ni ti Yisarele pili koŋgɔ te dɔ kɔmɔ bo ꞌdeni ŋgï rɔ ma köbö, kina lïjë kere ŋgï di bi tese ŋɔli rɔ bo. ");
INSERT INTO bex_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Tine bo ïdëkï lïjë na Arona ni ti löbu mo ga kuyï dönnï kako zi bo, bo koloma rɔ tilende tïnnï. ");
INSERT INTO bex_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Di pötö mo tine na bilaka pili kako ꞌjaa nati zi bo, bo kebe tiya gɔ köꞌdu kiꞌdi nima Bɔkoꞌba kiꞌdi zi bo di dɔ döku Sinayi ne pili zïnnï. ");
INSERT INTO bex_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kina ɔdɔ Musa kote tilende ꞌdeni pili tïnnï tara tine na bo kogba bɔŋgɔ kolo ŋgï kutuꞌbö dɔ kɔmɔ bo. ");
INSERT INTO bex_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tine ɔdɔ bo kari ꞌdeni kɔdɔ mï rö koro mo tönë tilende zi Bɔkoꞌba bo ogba bɔŋgɔ nima ŋgï yaga ŋbö ɔdɔ bo këdï kileki ꞌdeni tine na ꞌjaa bo kolo kileki teyi. Ɔdɔ bo kɔdɔ ꞌdeni yaga na bo kebe gbɔ tïyëtï gɔ wa ame ga ŋere Bɔkoꞌba kose ne zïnnï Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Kina lïjë koŋgɔ dɔ kɔmɔ bo ma këdï köbö ŋgï. Musa öꞌbö ŋburu ti bɔŋgɔ nima rɔ ma kutuꞌbö kpa dɔ bo ŋbö ɔdɔ bo këdï kɔdɔ ꞌdeni mï rö koro ꞌba Bɔkoꞌba tine na ꞌjaa bo kogba yaga. ");
INSERT INTO bex_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa otɔtɔ dɔ Yisarele pili kiya teyi te, “Wa ma ŋere Bɔkoꞌba kose ziye toꞌdɔ mo na me. ");
INSERT INTO bex_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Nï mɔtɔ zïyï toꞌdɔ ndɔbɔ ꞌbï ga ŋge mï töꞌdö dɔ modɔɔkɔtɔ. Tine töꞌdö ma rɔ dɔ modɔmorïyö mo nima iꞌdi këdï rɔ kada ma koro zïyï, kada ꞌba rɔ kindawo ꞌba ŋere Bɔkoꞌba na. Bɔtɔ mɔtɔ ame kebe koꞌdɔ ndɔbɔ mï kada nime kupö yaga. ");
INSERT INTO bex_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Pele ŋge rɔ paꞌdo, kinza kulöꞌjöke dë mï rö ꞌbe ga mï kada nime.” ");
INSERT INTO bex_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa iya zi Yisarele te, “Wa ma ꞌdɔ koꞌdɔke na me. ");
INSERT INTO bex_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nï mɔtɔ wa ame këddï timo ogba kiꞌdi rɔ kpa közï kiꞌdi zi ŋere Bɔkoꞌba ꞌbï. Nï ame mïyï koꞌdɔkɔ ne oꞌde yamo köbököbö rɔ kpa közï kiꞌdi zi Bɔkoꞌba gbï ti wa ma kɔzɔ sïtërï ni ti ꞌbïlëŋï ");
INSERT INTO bex_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ti sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo ti sunë banya, ");
INSERT INTO bex_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ti kilaka kamölö ma kinyanyi ꞌdeni kasi liyi, ti kilaka ma kinyanyi ꞌdeni keŋme laka, ti ŋgërï kono ");
INSERT INTO bex_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ti ꞌbu ꞌba toyi mo, agbaꞌji ꞌba mï ꞌbu kondi rɔ ti ꞌba akato kele, ");
INSERT INTO bex_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ti gbëyï ma ŋbɔwɔ ti lele ma kele mɔtɔ ga ame gɔ kulölï kpa nyama mo ne ti bɔŋgɔ ꞌba kpa dɔŋgoꞌdo mo tönë. ");
INSERT INTO bex_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Bilaka ame ga rɔ bɔ miri di mï löŋgö ye kako koꞌdɔ wa naga nime pili Bɔkoꞌba kose ne, ");
INSERT INTO bex_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","rö koro ꞌba Bɔkoꞌba mo tönë ti a ꞌba dɔmo ga gbï ti a ꞌba gɔmo ma kebe yaga ti moŋgɔ mo ga gbï ti nzora mo ga ti moꞌba mo ga ti dɔdɔrɔ mo ga ti akïdëyï mo ga, ");
INSERT INTO bex_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sandu ꞌba lömu mo tönë ti ŋgërï ꞌba tombi mo ga, a dɔmo ti bɔŋgɔ kuröbö ꞌba turöbö mo koke bi ma koro mo nima timo yaga mo tönë, ");
INSERT INTO bex_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tarabiza mo ti ŋgërï mo ga kpaki rɔ gɔ jama mo ga, maŋgolɔꞌbɔ ma kiꞌdi zi Bɔkoꞌba ");
INSERT INTO bex_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ti akïdëyï lamba ꞌba toyi mï rö mo nima tönë kpaki ti jama mo ga, lamba mo ga ti ꞌbu mo, ");
INSERT INTO bex_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","bi ꞌba akumu ꞌba ꞌdɔ toŋma akato kele dɔmo mo ti ŋgërï ꞌba tombi mo ga, ꞌbu kondi mo ti agbaꞌji kato kele mo tönë ga ti bɔŋgɔ kuröbö ꞌba kpadörï mo, ");
INSERT INTO bex_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","bi ꞌba akumu ꞌba toŋma akumu dɔmo ti kayikayi ꞌbïlëŋï mo tönë teyi, ti ŋgërï ꞌba tombi mo kpaki rɔ gɔ jama mo ga, ti wörï kurögö közï mo tönë ti bi kïdëyï mo, ");
INSERT INTO bex_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ti bɔŋgɔ kuröbö ma kuröbö rɔ kali ꞌba rɔmo mo tönë ga kpaki ti dɔdɔrɔ mo ga pili ti akïdëyï mo ga, gbï ti ꞌba kpadörï mo, ");
INSERT INTO bex_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ti akutötï mo ga ti kabi ꞌba rö koro nime ti ꞌba kali ꞌba rɔmo ga, ");
INSERT INTO bex_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","kina gbï ti bɔŋgɔ koro ma ꞌdɔ bɔ akumu mo ga kolɔ rönnï ɔdɔ lïjë këdï kari toja laja mï bi ma koro mo nima, ti bɔŋgɔ koro rɔ Arona ni ti kole abo ga.” ");
INSERT INTO bex_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kina ɔdɔ Yisarele naga nime pili kitaꞌba ꞌdeni kari di ŋgila Musa bina tine, ");
INSERT INTO bex_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","mɔtɔ ame yïmo koꞌdɔkɔ ne ari koꞌde wa ŋgï rɔ kpa közï kiꞌdi toꞌdɔ ndɔbɔ ꞌba rö koro ꞌba Bɔkoꞌba ꞌbënnï timo. Wa ame ga pili koꞌdɔkɔ ꞌdɔ tumötu Bɔkoꞌba timo ti ma ꞌdɔ koꞌdɔ rɔ bɔŋgɔ koro ꞌba rɔ bɔ akumu mo ga, lïjë oꞌde ŋgï pili kako. ");
INSERT INTO bex_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bilaka ame ga pili dökïꞌdï mo koꞌdɔkɔ ne ala rɔ bɔtɔni ala rɔ ꞌja oꞌde wa ma kɔzɔ yamo köbököbö ni ti a mbili ti a dɔkole közï ni ti a mugu ti dɔkomali wa ma kele naga ŋgï pili kiꞌdi rɔ kpa közï zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bilaka ame ga pili këdï ti sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo ti sunë banya ti kilaka kamölö ma kinyanyi ꞌdeni kasi liyi naga ti kilaka ma kinyanyi ꞌdeni keŋme laka naga oꞌde ŋgï kako. ");
INSERT INTO bex_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ya ame ga pili kɔꞌbɔ tireke wa ma kɔzɔ sïtërï ni ti ꞌbïlëŋï ni ne oꞌde kpa közï kiꞌdi ma ꞌbënnï ga ŋgï gbï kako zi Bɔkoꞌba. Bilaka ame ga këdï ti ŋgërï kono ma kele kɔꞌbɔ ꞌdɔ toꞌdɔ ndɔbɔ nima timo ne oꞌde ŋgï gbï kako. ");
INSERT INTO bex_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ꞌJa ame ga pili rɔ bɔ kopiri alato ne oꞌde dɔkomali sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Sunë banya ma kopiri naga lïjë oꞌde gbï kako. ");
INSERT INTO bex_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Löbu mo ga oꞌde lele ma ndögö kitigɔ naga ŋgï ma kïnë mo ŋbɔwɔ ti ma kele mɔtɔ ga gbï tulölï mo kpa nyama mo tönë ti bɔŋgɔ ma ꞌba kpa dɔŋgoꞌdo mo. ");
INSERT INTO bex_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Lïjë oꞌde agbaꞌji ŋgï ti ꞌbu ꞌba mï lamba ti ma kondi mo tönë ti akato kele mo ga. ");
INSERT INTO bex_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Rɔ gɔ bilaka ame ga pili yïmo koꞌdɔkɔ tiꞌdi kpa közï kiꞌdi zi Bɔkoꞌba kɔzɔ ma Musa kose ne oꞌde ŋgï kako. ");
INSERT INTO bex_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kina Musa kileki kiya gbï zïnnï te, “Bɔkoꞌba oweli Bezalele kole ꞌba Urï kole ꞌba kole ꞌba Uru di mï kupö eꞌbe Yuda ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Bɔkoꞌba odɔ Nyï Kɔtɔ Laka abo ꞌdeni lɔ mï Bezalele kiꞌdi miri ꞌba toꞌdɔ wa naga nime ti akikali mo ꞌdeni pili teyi. ");
INSERT INTO bex_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Kina ti bo koꞌdɔ wa naga nime di mï yamo köbököbö ni ti sïtërï ti ꞌbïlëŋï ");
INSERT INTO bex_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","toga mï lele ti toꞌbaꞌba wa ti tose ŋgërï ni pili rɔ gɔ ndɔbɔ ꞌba közï. ");
INSERT INTO bex_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Bɔkoꞌba iꞌdi ndɔbɔ naga nime ꞌdeni zi Bezalele ni ti Oliba kole ꞌba Asamaka di mï kupö eꞌbe Dana kina ꞌdɔ lïjë kiyandi ya mɔtɔ ga gbï toꞌdɔ mo tara. ");
INSERT INTO bex_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Akikali ti miri pili ꞌba akose ti akokpiri ti löꞌjö ame gɔ kuꞌjö bɔŋgɔ koꞌdɔ kele di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo pili rɔ gɔ kïnë bɔŋgɔ mɔtɔ ga, Bɔkoꞌba iꞌdi ꞌdeni pili zïnnï. Lïjë ti kɔꞌbɔ ŋgï toꞌdɔ ndɔbɔ ꞌba közï pili rɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kina Bezalele ni ti Oliba ti bɔ miri mɔtɔ mo naga nima Bɔkoꞌba kiꞌdi tigɔ ꞌba akikali ꞌba ndɔbɔ nime ꞌdeni teyi ne kako ŋgï. Kina gɔ lïjë koꞌdɔ wa ame pili kɔꞌbɔ ꞌdɔ toꞌdɔ rö koro nima timo ne ŋgï ko kɔzɔ ndose mo ma Bɔkoꞌba kose tönë tara.” ");
INSERT INTO bex_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Kina Musa kotɔtɔ dönnï lïjë bɔ miri mo naga nima ŋgï, Bezalele ni ti Oliba gbï ti bɔ miri pili mɔtɔ mo ga tönë, lïjë ma Bɔkoꞌba kiꞌdi akikali ti tigɔ ꞌba ndɔbɔ nima ꞌdeni zïnnï mo tönë ga lïjë kutï ꞌdeni ꞌdɔ tako toꞌdɔ mo ne. ");
INSERT INTO bex_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Wa mo ga ame pili Yisarele kireke dɔmo ꞌdeni ꞌdɔ toꞌdɔ ndɔbɔ nima timo ne lïjë ako ŋgï kogba di zi Musa kari timo. Tine Yisarele öꞌbö ŋgï toꞌde kpa közï kiꞌdi rɔ kɔmɔ kada löbu nime, ");
INSERT INTO bex_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ŋbö bɔ miri mo naga nima kënyï kako ");
INSERT INTO bex_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","kiya zi Musa te, “Bilaka oꞌde kpa közï ꞌdeni kebe dɔ ame doꞌdɔkɔ gɔ doꞌdɔ ndɔbɔ nime timo kɔzɔ ma Bɔkoꞌba kose.” ");
INSERT INTO bex_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kina Musa kiꞌdi kari kuwöwö lende mo ŋgï kote mï taya pili kinza bɔtɔ kireke wa dë kpe dömöyï ndɔbɔ ꞌba rö koro nima. ");
INSERT INTO bex_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Wa ame ga pili kireke ne ɔꞌbɔ ndɔbɔ nima ꞌdeni kebe gbï. ");
INSERT INTO bex_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bɔ miri ma rɔ dɔ kiteli di mï löŋgö lïjë bɔ ndɔbɔ mo naga nima na koꞌdɔ rö koro mo tönë. Lïjë oꞌdɔ di mï bɔŋgɔ ma kudöꞌbö ꞌbutë kuꞌjö di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kïyöru ti kïnë sasa ti kakala dɔmo tönë ga. ");
INSERT INTO bex_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Takpa mo ga pili rɔ ma koriya dɔkɔmɔ kumögu ꞌbutë dɔmorïyö töꞌbö mo dɔkɔmɔ kumögu rïyö. ");
INSERT INTO bex_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ma muyï lïjë uru kpamo kiyoso pili teyi rɔ mindalo kɔtɔ. Kina lïjë koꞌdɔ gbï tara ti kapa ma muyï mɔtɔ nima. ");
INSERT INTO bex_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Lïjë oꞌdɔ kano rɔmo di mï bɔŋgɔ kese kiyija kebe dɔ kpa mindalo mo ga ma yaga. ");
INSERT INTO bex_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Lïjë iyija kano mo ga kuluku kɔtɔ gɔ mindalo ma dɔgba kina gbï tara gɔ mindalo ma rɔ mï rïyö mo. ");
INSERT INTO bex_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Lïjë oꞌdɔ moŋgɔ teyi kuluku kɔtɔ di mï yamo köbököbö tosi kpamo timo bi kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","A dɔmo ma kebe gɔmo ma yaga lïjë oꞌdɔ di mï bɔŋgɔ kudöꞌbö ꞌbutë dɔɔkɔtɔ ma kuꞌjö di mï sunë banya. ");
INSERT INTO bex_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Lïjë oꞌdɔ pili rɔ ma koriya takpa mo dɔkɔmɔ kumögu ꞌbutë dɔɔmota, töꞌbö mo dɔkɔmɔ kumögu rïyö. ");
INSERT INTO bex_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ma muyï lïjë uru kpamo kiyoso bi kɔtɔ rɔ mindalo, kina ma modɔɔkɔtɔ ama gbï ꞌberi rɔ mindalo mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Lïjë oꞌdɔ kano kuluku kɔtɔ kiyija kpa mindalo ma dɔgba mo nima kebe kapa dɔ kpamo ma kileki yïꞌböwu. Kina lïjë koꞌdɔ kano mɔtɔ ga gbï ꞌböwu kuluku kɔtɔ kiyija kpa mindalo mɔtɔ mo nima. ");
INSERT INTO bex_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Lïjë oꞌdɔ moŋgɔ kuluku kɔtɔ di mï ꞌbïlëŋï ꞌdɔ kosi kpamo timo kiyoso bi kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Kina lïjë koꞌdɔ a dɔmo ma kebe yaga ꞌböwu gbï rïyö teyi, ma kɔtɔ di mï kilaka kamölö ame kinyanyi ꞌdeni rɔmo kasi liyi ne, kina mɔtɔ gbï di mï kilaka ma kinyanyi ꞌdeni keŋme laka naga ꞌdɔ bo na këdï kebe gɔmo ma yaga. ");
INSERT INTO bex_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Nzora ꞌba rö koro nima lïjë oꞌdɔ di mï ŋgërï kono. ");
INSERT INTO bex_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Takpa mo ga pili dɔkɔmɔ kumögu sowɔ, töꞌbö mo dɔkɔmɔ kolɔkɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Lösï këdï rɔ rïyörïyö mï ndïmo ga gɔ kïdëyï timo. Nzora naga nime pili rɔ gɔmo këdï ti lösï teyi. ");
INSERT INTO bex_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Lïjë oꞌdɔ nzora ꞌbutë rïyö zi kapa mo ma kileki te dɔ roꞌɔ ");
INSERT INTO bex_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ti akïdëyï mo ga ꞌbutë sowɔ di mï sïtërï tutötï mo timo. Akïdëyï mo ga këdï rɔ rïyörïyö ndï ma kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Lïjë oꞌdɔ nzora ꞌbutë rïyö dɔ kapa mo ma kileki te dɔ tugbu ");
INSERT INTO bex_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ti akïdëyï mo ga ꞌbutë sowɔ di mï sïtërï rɔ rïyörïyö ndï nzora kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ma kebe yïkundö mo kileki te kapa dɔ tɔrɔ lïjë oꞌdɔ nzora teyi modɔɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Tine gɔ dɔ kumu mo ga lïjë oꞌdɔ nzora teyi kpaki rɔ rïyörïyö. ");
INSERT INTO bex_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Nzora ma rïyö ꞌba dɔ kumu mo naga nima iyoso kpamo di bërï ŋbö kala tɔrɔ. Rɔ gɔ nzora ꞌba dɔ kumu mo naga nima kpaki rɔ gɔmo na lïjë koꞌdɔ tara. ");
INSERT INTO bex_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nzora pili modɔɔmota ti akïdëyï mo ga di mï sïtërï ꞌbutë döömu dɔɔkɔtɔ rɔ rïyörïyö ndïmo ga. ");
INSERT INTO bex_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Lïjë oꞌdɔ moꞌba teyi ꞌbutë döömu di mï ŋgërï kono, ");
INSERT INTO bex_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","muyï gɔ nzora ma kapa ama, muyï gɔ ma kileki te kapa dɔ roꞌɔ kina gbï muyï gɔ kapa ma rɔ yïkundö mo tönë kileki te kapa dɔ tɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Moꞌba ma zana mo ame kuruwö mï löŋgö nzora mo naga nime ne kuŋguŋgu di bine ŋbö kala gɔ kapa mo ma ꞌdë. ");
INSERT INTO bex_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Lïjë omba rɔ nzora mo ga teyi ti yamo köbököbö ti kano yɔki mo tusu moꞌba mo ga kebe yïmo ame komba rɔmo ra gbï ti yamo köbököbö ne. ");
INSERT INTO bex_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Lïjë oꞌdɔ bɔŋgɔ kuröbö mo tönë di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kïyöru ti kïnë sasa ti kakala dɔmo naga. ");
INSERT INTO bex_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Lïjë oꞌdɔ lëꞌbërë sowɔ di mï ŋgërï kono komba rɔmo teyi ti yamo köbököbö towe bɔŋgɔ kuröbö mo tönë dɔmo, kosi kpamo ga ti moŋgɔ yamo köbököbö. Kina lïjë koꞌdɔ akïdëyï mo ga di mï sïtërï sowɔ tutötï lëꞌbërë mo naga nima timo. ");
INSERT INTO bex_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Akpadörï ꞌba rö koro nima lïjë oꞌdɔ rɔ bɔŋgɔ kuröbö di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kïyöru rɔmo kiyada. ");
INSERT INTO bex_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Lïjë oꞌdɔ lëꞌbërë muyï zi bɔŋgɔ kuröbö ame kosi kpamo ti moŋgɔ. Dɔmo ma tɔrɔ ti ndïmo ma di bërï komba yamo köbököbö teyi ti akïdëyï mo ga muyï rɔ ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalele oꞌdɔ sandu ꞌba lömu nima di mï ŋgërï kono. Gɔmo ma kakpa mo dɔkɔmɔ kolɔkɔ ꞌbutë dɔɔkɔtɔ. Töꞌbö mo dɔkɔmɔ kolɔkɔ modɔmorïyö. Takpa mo ma kari tɔrɔ gbï tara. ");
INSERT INTO bex_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Yïmo ti gɔmo ma yaga bo ora ti yamo köbököbö bo kïyöru dɔ kpamo. ");
INSERT INTO bex_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Bo oꞌdɔ kano ꞌba tombi mo timo ga sowɔ teyi di mï yamo köbököbö kosi kapa gɔ ndïmo ga kpaki sowɔ rɔ rïyörïyö. ");
INSERT INTO bex_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Bo oꞌdɔ ŋgërï ꞌba tombi mo ga di mï kono bo komba yamo köbököbö rɔmo, ");
INSERT INTO bex_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","bo kusu kebe mï kano mo tönë ga kapa ꞌba sandu mo nima kpaki rïyö ne. ");
INSERT INTO bex_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Bo oꞌdɔ a dɔmo di mï yamo ma köbököbö, takpa mo dɔkɔmɔ kolɔkɔ ꞌbutë dɔɔkɔtɔ, töꞌbö mo dɔkɔmɔ kolɔkɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Bo uku sasa ti kakala dɔmo naga rïyö di mï yamo köbököbö, ");
INSERT INTO bex_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","kɔtɔ kapa ame kɔtɔ kapa ama. Bo uku kambi kɔtɔ ti a dɔmo nima. ");
INSERT INTO bex_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Sasa mo naga nime mɔtɔ kuyï kömönï kari dɔ lëpï nï tine koŋgɔ bi bërï kakala mo ga kutuꞌbö dɔ sandu nima. ");
INSERT INTO bex_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bo oꞌdɔ tarabiza mo di mï ŋgërï kono, takpa mo dɔkɔmɔ kolɔkɔ modɔmosowɔ, töꞌbö mo dɔkɔmɔ kolɔkɔ muyï, takpa mo ma kari tɔrɔ dɔkɔmɔ kolɔkɔ modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Bo ora rɔmo ti yamo köbököbö bo kïyöru dɔ kpamo ga. ");
INSERT INTO bex_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Bo oꞌdɔ dɔtara kpamo ma kɔꞌdɔ koriya ti dɔkole közï ma zana nime bo kïyöru dɔ kpamo ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Bo oꞌdɔ kano ꞌba tombi mo timo sowɔ teyi di mï yamo köbököbö bo kosi kebe gɔ ndïmo naga nima kpaki sowɔ. ");
INSERT INTO bex_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","A ꞌba tombi tarabiza nima bo oꞌdɔ ŋgɔsi kpa dɔtara mo tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Bo oꞌdɔ ŋgërï ꞌba tombi mo timo di mï kono bo komba rɔmo ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Bo oꞌdɔ lebe yamo köbököbö zi tarabiza nima, gata mo ga ti kösu mo ga ti gberi mo ga ti lebe ꞌba todɔ layi mo ga timo. ");
INSERT INTO bex_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bo oꞌdɔ akïdëyï lamba mo di mï yamo köbököbö. Bo uku ndïmo ti dɔdɔrɔ mo di mï yamo köbököbö ti döwöru ꞌba tiyada mo ga ti mbili ma këdï komo mo ga kambi kɔtɔ timo. ");
INSERT INTO bex_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Dɔŋgila konza pili rɔ motamota di gɔ dɔ kapa mo ga kpaki rïyö. ");
INSERT INTO bex_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Dɔŋgila mo naga nima pili rɔ gɔmo ma kɔtɔ ti döwöru ma kiyada timo mo tönë ga mota dɔmo ti ma komo mo ga teyi. ");
INSERT INTO bex_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Dɔdɔrɔ mo ti döwöru ꞌba tiyada mo timo mo tönë sowɔ teyi ti ma komo mo ga. ");
INSERT INTO bex_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Kpa dɔŋgoriya ma konza mo naga nima rɔ motamota ne kpaki ti ma komo mo teyi. ");
INSERT INTO bex_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ma komo mo nima ti dɔŋgila mo ga ti akïdëyï lamba mo nima ambi pili rɔ akɔtɔ kuku ꞌdeni di mï yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bo oꞌdɔ lamba modɔmorïyö dɔ akïdëyï mo nima. Kina bo kuku makara mo ga ŋgï ti akunzö buruku mo ga di mï yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kilɔ ꞌbutë mota döömu ꞌba yamo köbököbö na ma bo kote dɔ ndɔbɔ ꞌba akïdëyï lamba nima ti jama mo ga. ");
INSERT INTO bex_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bo oꞌdɔ bi ꞌba toŋma akato kele dɔmo di mï ŋgërï kono rɔ dɔ ꞌbaga dɔ kapa mo ga pili rɔ ma koriya dɔkɔmɔ kolɔkɔ muyï. Tine takpa mo ma kari tɔrɔ dɔkɔmɔ kolɔkɔ modɔmosowɔ. Biti ꞌba gɔ dɔ kumu sowɔ mo naga nima bo oꞌdɔ kambi kɔtɔ timo. ");
INSERT INTO bex_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Dɔmo ma di tɔrɔ ti rɔmo ga kpaki ti biti mo ga bo ora rɔmo ti yamo köbököbö bo kïyöru dɔ kpamo ga toko teyi. ");
INSERT INTO bex_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Bo oꞌdɔ kano ꞌba tombi mo rïyö teyi di mï yamo köbököbö. Bo oꞌdɔ kano mo naga nima ŋgɔsi kpa bïcï ma kïyöru mo nima kebe gɔ dɔ kapa mo ga kpaki rïyö tusu ŋgërï ꞌba tombi mo ga yïmo. ");
INSERT INTO bex_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Bo oꞌdɔ ŋgërï ꞌba tombi mo di mï kono bo komba rɔmo ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Kina bo koꞌdɔ ꞌbu koro ꞌba tondi mo rɔmo tönë ŋgï gbï ti akato kele mo ga kudölö yïmo kɔzɔ riya tara. ");
INSERT INTO bex_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bo oꞌdɔ bi ꞌba toŋma akumu mo di mï ŋgërï kono rɔ dɔ ꞌbaga, kapa mo ga dɔkɔmɔ kumögu rïyö. Tine takpa mo ma kari tɔrɔ dɔkɔmɔ kumögu kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Bo oꞌdɔ biti teyi kebe kapa gɔ dɔ kumu mo ga kpaki sowɔ kambi kɔtɔ timo. Bo ora rɔmo pili ti ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Kina bo koꞌdɔ jama mo ga gbï teyi. Bo oꞌdɔ akunzö buruku mo ga ti körë mo ga ti lebe mo ga ti jakira mo ga ti gata ꞌba paꞌdo mo ga. Jama naga nime pili bo oꞌdɔ di mï ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Bo oꞌdɔ kayikayi di mï ꞌbïlëŋï kusu kebe bïcï dɔmo ma kɔꞌdɔ mo nima ŋbö kömö mï zana mo. ");
INSERT INTO bex_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Bo oꞌdɔ kano ꞌba tombi mo timo ga sowɔ kiꞌdi kebe gɔ dɔgali mo ga. ");
INSERT INTO bex_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Bo oꞌdɔ ŋgërï ꞌba tombi mo timo ga gbï teyi bo komba rɔmo ti ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Kina bo kusu ŋgï mï kano mo naga nima. Bi ꞌba toŋma akumu ame lïjë oꞌdɔ di mï ŋgërï kola yïmo rɔ gböŋö. ");
INSERT INTO bex_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bo oꞌdɔ wörï kurögö közï mo tönë ti akïdëyï mo di mï mandara ꞌba ꞌja ma këdï koꞌdɔ ndɔbɔ kpadörï ꞌba rö koro nima. ");
INSERT INTO bex_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Tine ꞌba rö koro mo nima lïjë ari koꞌdɔ kali rɔmo di mï bɔŋgɔ ma kele naga. Kapa mo ma kari te dɔ roꞌɔ dɔkɔmɔ kumögu ꞌbutë sowɔ dɔmosowɔ ");
INSERT INTO bex_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","kïkëtï ti dɔdɔrɔ ꞌbïlëŋï ꞌbutë rïyö gbï ti akïdëyï mo ga. Moŋgɔ mo ga gbï teyi ti bi kïyöru mo ga di mï sïtërï. ");
INSERT INTO bex_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kali nima kapa mo ama gbï rɔ ma koriya ti ame kileki te kapa dɔ tugbu ne. ");
INSERT INTO bex_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Kapa mo ma kileki te dɔ tɔrɔ lïjë oꞌdɔ dɔkɔmɔ kumögu ꞌbutë rïyö dɔmorïyö ti dɔdɔrɔ mo ga ti akïdëyï mo ga gbï teyi. Kina gbï ti moŋgɔ ti kabi mo ga teyi koꞌdɔ di mï sïtërï. ");
INSERT INTO bex_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Kapa ma kileki te yïbï ti kpadörï mo teyi ne gbï dɔkɔmɔ kumögu ꞌbutë rïyö dɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kapa kpadörï mo ma kileki te lïjë oꞌdɔ bɔŋgɔ kuröbö mo ga teyi dɔkɔmɔ kumögu modɔmorïyö. Dɔdɔrɔ mo ga mota ti akïdëyï mo ga teyi. ");
INSERT INTO bex_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Kina lïjë koꞌdɔ kapa mo ma kari ꞌdë nima gbï tara ti dɔdɔrɔ ti akïdëyï mo ga teyi. ");
INSERT INTO bex_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Bɔŋgɔ kuröbö mo naga nima lïjë koꞌdɔ toko rɔ kali nima ne pili di mï bɔŋgɔ ma kele. ");
INSERT INTO bex_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Akïdëyï ꞌba ndï dɔdɔrɔ mo ga di mï ꞌbïlëŋï, tine moŋgɔ mo ga ti bi kïyöru mo ga ti a ma komba dɔ dɔdɔrɔ mo ga di mï sïtërï. Dɔdɔrɔ mo naga nima pili rɔ gɔmo ti bi kïyöru rɔmo di mï sïtërï. ");
INSERT INTO bex_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Bɔŋgɔ kuröbö ma rɔ akpadörï mo di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kiyada kïyöru rɔmo kele. Töꞌbö mo dɔkɔmɔ kumögu modɔɔmota tine takpa mo dɔkɔmɔ kumögu rïyö koriya ti dɔ bɔŋgɔ kuröbö ma laki mɔtɔ ga ꞌba kali mo nima. ");
INSERT INTO bex_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ïkëtï ti dɔdɔrɔ sowɔ ti akïdëyï mo ga teyi pili di mï ꞌbïlëŋï. Tine moŋgɔ mo ga ti a ma komba dɔ dɔdɔrɔ mo ga na di mï sïtërï. ");
INSERT INTO bex_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Akutötï rö koro nima ti ꞌba kali mo ga pili oꞌdɔ di mï ꞌbïlëŋï. ");
INSERT INTO bex_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Akiyija ꞌba wa ame ga koꞌdɔ rɔ rö koro nima kiꞌdi lere rïyö ꞌba köꞌdu kiꞌdi ꞌbutë mo tönë ga yïmo ne na me ga. Musa na kose gɔ wa naga nime pili zi kupö eꞌbe Lëwë tïtëtë mo kɔzɔ a nime te. Itomara kole ꞌba Arona na kiꞌdi mbiri rɔ bɔ dönnï tïtëtë mo. ");
INSERT INTO bex_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalele kole ꞌba Urï kole ꞌba kole ꞌba Uru di mï kupö eꞌbe Yuda na koꞌdɔ wa naga nime pili Bɔkoꞌba kose zi Musa ne. ");
INSERT INTO bex_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bɔ gɔ bo Oliba kole ꞌba Asamaka di mï kupö eꞌbe Dana na rɔ bɔ tose mo ga gbï rɔ bɔ toga yïmo gbï rɔ bɔ tuꞌjö bɔŋgɔ di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo. ");
INSERT INTO bex_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Yamo köbököbö ame ga pili kireke kulömu zi Bɔkoꞌba ne ëdï kilɔ kuluku ꞌbutë rïyö gɔ akiyari mo. ");
INSERT INTO bex_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Sïtërï ëdï pili kilɔ kuluku ꞌbutë bi modɔɔkɔtɔ kɔdɔ dɔmo kuluku modɔɔmota kora dɔmo ꞌbutë mota (3,430) gɔ akiyari mo ma bilaka ma kugu möyï mo naga nima kireke. ");
INSERT INTO bex_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Wa naga nime pili ma bilaka mo ga kireke na, mɔtɔ opi kɔzɔ ma koꞌdɔkɔ zïyï tara gɔ akiyari mo. Bɔtɔni ame ga kɔmɔ kɔɔ mo kisaki ꞌdeni di dɔ ꞌbutë rïyö kugu möyï mo ne ëdï pili kuluku kpa mota bi sowɔ kɔdɔ dɔmo kuluku kpa rïyö bi ꞌbutë sowɔ dɔɔkɔtɔ kora dɔmo kuluku ꞌbutë rïyö dɔɔkɔtɔ (603,550). ");
INSERT INTO bex_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Di mï sïtërï mo nima ma kilɔ kuluku ꞌbutë bi modɔɔkɔtɔ kɔdɔ dɔmo kuluku modɔɔmota (3,400) na koꞌdɔ pili rɔ akïdëyï mo ma kuluku rïyö ꞌba rɔ rö koro mo nima ti ꞌba bɔŋgɔ kuröbö mo ga, ma kɔtɔ ombi ŋbö kilɔ ꞌbutë mota dɔmosowɔ, pili rɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kɔsɔ mo ma kileke kilɔ ꞌbutë mota nima na Bezalele koꞌdɔ bi kïyöru ti moŋgɔ ꞌba gɔ dɔdɔrɔ mo ga di yïmo. Kina gbï bo koꞌdɔ rɔ a ꞌba dɔ dɔdɔrɔ mo ga. ");
INSERT INTO bex_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ꞌBïlëŋï ma kireke kulömu zi Bɔkoꞌba ëdï pili kilɔ kuluku ꞌbutë sowɔ döömu dɔɔmota kora dɔmo ꞌbutë rïyö döömu (2,425). ");
INSERT INTO bex_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Kina Bezalele koꞌdɔ akïdëyï ꞌba kpadörï ꞌba rö koro mo nima gbï di yïmo ti bi ꞌba toŋma akumu ma di mï ꞌbïlëŋï mo nima ti kayikayi ꞌbïlëŋï mo tönë ti jama pili ꞌba bi ꞌba akumu. ");
INSERT INTO bex_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Kina ma bo koꞌdɔ akïdëyï kali mo tönë ga gbï di yïmo ti ꞌba kpadörï mo ga ti akutötï rö koro nima pili ti ꞌba kali mo. ");
INSERT INTO bex_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo mo tönë ga na lïjë koꞌdɔ bɔŋgɔ ꞌba rɔ bɔ akumu mo ga ŋgï ma ꞌdɔ lïjë kolɔ ɔdɔ lïjë këdï kari toja laja mï bi ma koro mo. Lïjë oꞌdɔ bɔŋgɔ koro ꞌba bɔ akumu rɔ Arona ni kɔzɔ ma Bɔkoꞌba kose zi Musa tara. ");
INSERT INTO bex_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Lïjë oꞌdɔ nyama mo di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo gbï ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Lïjë uku yamo köbököbö kore yaga ndendendende kuꞌjö kɔtɔ ti sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo mo tönë. ");
INSERT INTO bex_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Lïjë oꞌdɔ kabi ꞌba dɔkɔnyɔ rïyö kpa nyama mo nima kosi kpamo dɔ kapa mo ga ꞌdɔ kuru kpamo timo. ");
INSERT INTO bex_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Gasi kuꞌjö kele mo tönë koꞌdɔ ra gbï di mï kïnë wa kɔtɔ mo nima ne iyoso kpamo gbï yɔki nyama mo nima ꞌdɔ kambi kɔtɔ timo kɔzɔ ma Bɔkoꞌba kose zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Lele kïnë ŋbɔwɔ mo tönë ga lïjë ileŋo koga möyï kole ꞌbutë dɔmorïyö ꞌba Yakoba ga rɔmo koꞌbaꞌba ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Lïjë uru rɔ kapa kabi ꞌba dɔkɔnyɔ nyama mo nima gɔ kileme kpa gɔli ꞌbutë dɔmorïyö ꞌba Yisarele, kɔzɔ ma Bɔkoꞌba kose zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Lïjë oꞌdɔ bɔŋgɔ ma kpa dɔŋgoꞌdo mo gbï di mï kïnë akɔtɔ nima koꞌdɔ nyama mo di yïmo ne gbï ti kïnë akïyöru kɔtɔ mo nima. ");
INSERT INTO bex_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Oꞌdɔ yaga rɔ ma köꞌbö rɔ dɔ ꞌbaga kuköku yïmo rïyö teyi. Takpa mo ti töꞌbö mo pili dɔkɔmɔ kolɔkɔ rïyö. ");
INSERT INTO bex_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Lïjë ulölï mindalo ꞌba döku ndögö kitigɔ naga sowɔ rɔmo. Mindalo ma dɔgba mo lïjë iꞌdi mboro ni ti ma kïnë dɔŋɔte ti ma kese na teyi. ");
INSERT INTO bex_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Mindalo ma rïyö mo lïjë iꞌdi ma kïnë biliwa ti ma yëwë ti ma kilindekilinde teyi. ");
INSERT INTO bex_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Mindalo ma mota mo lïjë iꞌdi ma kese tïyötïyö ti ma kumöru ti ma liyi teyi. ");
INSERT INTO bex_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Mindalo ma rɔ mï sowɔ mo lïjë iꞌdi ma kïdïdï ti ma kïnë wölïwölï ti ma kïnë kïlïꞌdï ꞌdöyï teyi. Lïjë koꞌbaꞌba pili ti yamo köbököbö. ");
INSERT INTO bex_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Di mï döku ꞌbutë dɔmorïyö naga nima pili oga möyï kole ꞌbutë dɔmorïyö ꞌba Yakoba ga rɔmo rɔ kɔtɔkɔtɔ ꞌdɔ kileme kpa gɔli ꞌbutë dɔmorïyö ꞌba Yisarele. ");
INSERT INTO bex_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Lïjë oꞌdɔ nyɔri yamo köbököbö kpa bɔŋgɔ ꞌba dɔŋgoꞌdo mo nima koꞌdɔ kɔzɔ gaꞌda naga tara. ");
INSERT INTO bex_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Lïjë oꞌdɔ yamo köbököbö koꞌbaꞌba mo ga rïyö gbï ti magbaya rïyö. Magbaya rïyö mo naga nima lïjë uru kpa bɔŋgɔ ꞌba dɔŋgoꞌdo mo ma tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Kina lïjë kosi kpa nyɔri yamo köbököbö mo tönë ga ŋgï rɔmo. ");
INSERT INTO bex_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Tine kapa ꞌba kpamo ama lïjë osi rɔ yamo köbököbö koꞌbaꞌba mo tönë ga rɔ kabi ꞌba dɔkɔnyɔ mo yayi kebe kɔmɔ ne. ");
INSERT INTO bex_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Lïjë oꞌdɔ magbaya yamo köbököbö rïyö kuru kpa bɔŋgɔ ꞌba dɔŋgoꞌdo mo nima ma kapa bërï kebe mïyö ŋgɔsi kpa nyama. ");
INSERT INTO bex_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Lïjë oꞌdɔ magbaya mɔtɔ ga ꞌböwu gbï rïyö kuru kpa kabi ꞌba dɔkɔnyɔ nyama mo ma bërï ŋgɔsi kpa dɔgali mo tine mbowa tɔrɔ bi dɔ gasi kuꞌjö kele mo tönë. ");
INSERT INTO bex_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kɔzɔ ame Bɔkoꞌba kose ꞌdeni zi Musa ne tara na lïjë kosi kpa magbaya ꞌba bɔŋgɔ ꞌba dɔŋgoꞌdo mo ŋgï ti ma ꞌba nyama mo ti kabi kese ꞌdɔ bɔŋgɔ ma ꞌba dɔŋgoꞌdo nima koloma tɔrɔ dɔ gasi mo kinza kuŋgölö ra. ");
INSERT INTO bex_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bëbë ma löbu mo ame kebe mï nyama mo yayi ne oꞌdɔ pili di mï sunë ma kese. ");
INSERT INTO bex_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Bi gböŋö ꞌba dɔmo uru kpamo kitigɔ teyi kinza kirica ra. ");
INSERT INTO bex_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","25-26","Dɔ kpamo ma koŋgo kebe kapa mo ma bërï lïjë iyija ŋgoloŋgolo kese ti ma ŋbɔwɔ ti ma kasi kujölu yïmo ti lalaŋa yamo köbököbö kɔzɔ ame Bɔkoꞌba kose zi Musa ne. ");
INSERT INTO bex_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Lïjë oꞌdɔ bɔŋgɔ kolɔ rɔ zi Arona ni ti kole abo ga, ");
INSERT INTO bex_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ti yima kolo dɔmo ga ti a dɔmo ga ti ridi mo ga ");
INSERT INTO bex_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","gbï ti lapo di mï sunë kamölö ma kopiri ꞌdeni koꞌdɔ kïnë mo ga rɔ ma kese, ma ŋbɔwɔ ti ma kasi ti alato kirilewo kïyöru rɔmo kele ne kɔzɔ ma Bɔkoꞌba kose zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Lïjë oꞌdɔ dökulë ꞌba tileme tulömu wa zi Bɔkoꞌba di mï yamo köbököbö. Lïjë kugu rɔmo te, “Ulömu ꞌdeni zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Lïjë udödu kpa dɔ yima mo nima ti kabi kese kɔzɔ ma Bɔkoꞌba kose zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ndɔbɔ ꞌba toꞌdɔ rö koro ꞌba Bɔkoꞌba ote rönï ŋgï pili kɔzɔ a nime te. Yisarele oꞌdɔ wa pili ŋgï ko kɔzɔ ma Bɔkoꞌba kose zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Lïjë oꞌdɔ rö koro nima koto kari zi Musa ti jama mo ga pili, moŋgɔ mo ga ti nzora mo ga ti moꞌba mo ga ti dɔdɔrɔ mo ga ti akïdëyï mo ga, ");
INSERT INTO bex_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kilaka kamölö ma kutï rɔmo kasi liyi rɔ ꞌba dɔmo mo tönë ga ti a ꞌba dɔmo ma rɔ kilaka ma kinyanyi keŋme laka mo tönë ga, ti bɔŋgɔ kuröbö mo ga ");
INSERT INTO bex_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ti sandu ꞌba lömu mo tönë ti lere rïyö ꞌba köꞌdu kiꞌdi mo tönë ga yïmo, ŋgërï kombi mo ga ti a dɔmo, ");
INSERT INTO bex_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tarabiza mo ti jama mo ga pili ti maŋgolɔꞌbɔ ma kiꞌdi zi Bɔkoꞌba mo, ");
INSERT INTO bex_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","akïdëyï lamba mo di mï yamo köbököbö ne ti lamba mo ga ti jama mo ga pili ti ꞌbu mo ga, ");
INSERT INTO bex_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","bi ꞌba akumu ma di mï yamo köbököbö ti ꞌbu kondi rɔmo tönë ti agbaꞌji kato kele mo ga ti bɔŋgɔ kuröbö ꞌba kpadörï mo, ");
INSERT INTO bex_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","bi ꞌba akumu ma di mï ꞌbïlëŋï mo ti kayikayi mo ti ŋgërï ꞌba tombi mo ga ti jama mo ga pili, wörï kurögö közï mo ti akïdëyï mo, ");
INSERT INTO bex_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","bɔŋgɔ kuröbö ꞌba kali mo ti dɔdɔrɔ mo ga ti akïdëyï mo ga, bɔŋgɔ kuröbö ma ꞌba kpadörï ꞌba kali mo ti kabi mo ga ti akutötï mo ga pili, ");
INSERT INTO bex_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","gbï ti bɔŋgɔ koro ma ꞌdɔ bɔ akumu mo ga kolɔ di mï bi ma koro mo nima, bɔŋgɔ koro rɔ Arona bɔ akumu ni lïjë ti kole abo ga. ");
INSERT INTO bex_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Yisarele oꞌdɔ wa naga nime ꞌdeni pili kɔzɔ ma Bɔkoꞌba kose zi Musa. ");
INSERT INTO bex_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa oŋgɔ gɔmo lïjë oꞌdɔ ꞌdeni ko kɔzɔ ma Bɔkoꞌba kose zi bo. Kina bo koꞌdɔ yëyï ŋgï zïnnï. ");
INSERT INTO bex_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kina ŋere Bɔkoꞌba kiya zi Musa te, ");
INSERT INTO bex_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Mï töꞌdö ma dɔndende ꞌba nyepe ma dɔgba nime zïyï tutötï rö ꞌba tondɔsɔ, rö koro ma ꞌba Bɔkoꞌba nime. ");
INSERT INTO bex_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Utë sandu ꞌba lömu mo tönë ti köꞌdu kiꞌdi ꞌbutë yïmo ne mï zana mo yayi. Kina ꞌdɔ kowe bɔŋgɔ kuröbö mo tönë kebe kɔmɔ mo. ");
INSERT INTO bex_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Oꞌde tarabiza mo tönë yïmo kiyija jama mo ga dɔmo. Oꞌde akïdëyï lamba mo tönë yïmo yayi kiyija lamba mo ga dɔmo. ");
INSERT INTO bex_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Utë bi ꞌba akumu ma di mï yamo köbököbö mo tönë kɔmɔ sandu ꞌba lömu mo nima yayi. Kina ꞌdɔ kowe bɔŋgɔ kuröbö ꞌba kpadörï mo teyi. ");
INSERT INTO bex_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Utë bi ꞌba akumu ma ꞌba toŋma kpa közï kiꞌdi dɔmo nima kɔmɔ rö koro nima ma yaga. ");
INSERT INTO bex_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Utë wörï kurögö közï mo tönë mï löŋgö bi ꞌba akumu ni ti rö koro kunö mini lɔ yïmo. ");
INSERT INTO bex_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Utötï kali ꞌba rɔmo ga toko kowe bɔŋgɔ kuröbö ꞌba kpadörï mo teyi. ");
INSERT INTO bex_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Kina ꞌdɔ kulömu rö koro nima kpaki ti jama mo ga ti tondi ꞌbu koro mo tönë rɔmo kina ti këdï ŋgï pili rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kina ꞌdɔ kulömu bi ꞌba akumu mo ga pili ti jama mo ga ti tondi ꞌbu rɔmo. Kina ti lïjë këdï ŋgï rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kina ꞌdɔ kulömu wörï kurögö közï nima gbï tara ti akïdëyï mo. ");
INSERT INTO bex_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Oꞌde Arona ni ti kole abo ga kpadörï ꞌba rö koro bina kina ꞌdɔ kiꞌdi lïjë kurögö rönnï tileŋo rönnï kɔpɔ. ");
INSERT INTO bex_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Olɔ bɔŋgɔ ꞌba bɔ akumu mo tönë rɔ Arona kondi ꞌbu mo rɔ bo. Kina ꞌdɔ kiꞌdi bo kɔzɔ a nime te toja laja rɔ bɔ akumu ma zö. ");
INSERT INTO bex_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Oꞌde kole abo mo ga kolɔ bɔŋgɔ kolɔ rɔ rönnï. ");
INSERT INTO bex_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Kina ꞌdɔ kondi ꞌbu gbï rönnï kɔzɔ ma kondi rɔ ꞌbu nnï, ꞌdɔ lïjë koja laja zö rɔ bɔ akumu ma ga. ꞌBu kondi nime ti kiꞌdi kupö lïjë köꞌbö rɔ bɔ akumu zö nduwë mï kada ma këdï kako naga nime ꞌdë.” ");
INSERT INTO bex_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Kina Musa koꞌdɔ wa pili ŋgï kɔzɔ ma ŋere Bɔkoꞌba kose zi bo. ");
INSERT INTO bex_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Mï töꞌdö ma dɔndende mï nyepe ma dɔgba ꞌba mï kɔmɔ kɔɔ ma rɔ rïyö mo di pötö tɔdɔ ꞌbënnï yaga di mï Ezipeto na rö koro ꞌba Bɔkoꞌba kutötï rönï ŋgï. ");
INSERT INTO bex_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa utötï akïdëyï mo ga bërï kiyija nzora mo ga kudödu moꞌba mo ga kïdëyï dɔdɔrɔ mo ga. ");
INSERT INTO bex_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Bo uröbö dɔ rö nima ti ma kebe gɔmo ma yaga kɔzɔ ma Bɔkoꞌba kose zi bo. ");
INSERT INTO bex_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Kina bo kogba lere rïyö ꞌba köꞌdu kiꞌdi mo tönë ga ŋgï kiꞌdi mï sandu mo. Bo usu ŋgërï ꞌba tombi mo mï kano mo tönë ga koꞌdɔ yɔki sandu mo nima ne. Kina bo kogba a dɔmo kutuꞌbö teyi. ");
INSERT INTO bex_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kina bo kutë sandu ꞌba köꞌdu kiꞌdi nima mï rö koro yayi bo kowe bɔŋgɔ kuröbö mo koza bi ma ꞌba sandu mo nima timo yaga kɔzɔ ma Bɔkoꞌba kose. ");
INSERT INTO bex_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Bo ïdëyï tarabiza mo yïmo yayi kebe kapa mo ma kileki te dɔ tugbu gönyï bɔŋgɔ kuröbö mo tönë ma kako te yaga. ");
INSERT INTO bex_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Kina bo kiꞌdi maŋgolɔꞌbɔ mo ga ŋgï dɔmo yayi kɔmɔ Bɔkoꞌba, kɔzɔ ma Bɔkoꞌba kose zi bo. ");
INSERT INTO bex_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Bo iꞌdi akïdëyï lamba mo tönë kebe ŋgila tarabiza mo nima kapa ma kari te dɔ roꞌɔ. ");
INSERT INTO bex_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Kina bo kiꞌdi lamba mo ga ŋgï dɔmo yayi kɔmɔ Bɔkoꞌba, kɔzɔ ma Bɔkoꞌba kose zi bo. ");
INSERT INTO bex_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Bo iꞌdi bi ꞌba akumu ma di mï yamo köbököbö tönë rö yayi kebe kɔmɔ bɔŋgɔ kuröbö mo nima. ");
INSERT INTO bex_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Kina bo koŋma agbaꞌji kato kele mo tönë ŋgï dɔmo kɔzɔ ma Bɔkoꞌba kose zi bo. ");
INSERT INTO bex_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Kina bo kowe bɔŋgɔ kuröbö ꞌba kpadörï mo ŋgï teyi. ");
INSERT INTO bex_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Bo utë bi ꞌba toŋma akumu ma ꞌba kpa közï kiꞌdi nima yaga kebe gɔ bɔŋgɔ kuröbö ꞌba kpadörï mo. Kina bo kumu kpa közïmo ga dɔmo yayi ti a ma kɔzɔ nyönyu ni kɔzɔ ma Bɔkoꞌba kose zi bo. ");
INSERT INTO bex_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Bo ïdëyï wörï ꞌba turögö közï mo tönë mï löŋgö bi ꞌba akumu ni ti rö koro nima, ti mini lɔ yïmo. ");
INSERT INTO bex_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa ni ti Arona ti kole ꞌba Arona ga urögö ga közïnnï ti ndïnnï bina ");
INSERT INTO bex_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ɔdɔ lïjë këdï koꞌdɔ tɔdɔ mï rö koro ꞌba Bɔkoꞌba kɔzɔ ma Bɔkoꞌba kose. ");
INSERT INTO bex_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Musa utötï kali toko rɔ rö koro nima ti bi ꞌba akumu mo. Kina bo kowe bɔŋgɔ kuröbö ꞌba kpadörï mo ŋgï teyi. Bo kote ndɔbɔ mo pili kɔzɔ a nime te. ");
INSERT INTO bex_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kina pɔli kako kutuꞌbö dɔ rö koro nima ŋgï bi nzari ꞌba bi kɔpɔ ꞌba Bɔkoꞌba kogba yïmo ŋgï ti rönï. ");
INSERT INTO bex_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Kina kiꞌdi Musa ŋgï kɔdɔ dë rö yayi. ");
INSERT INTO bex_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Yisarele öꞌbö tunyë taya ꞌbënnï ŋge kolɔlɔ dɔgba ɔdɔ kiya te pɔli nima kënyï kokpe mïnï ꞌdeni tɔrɔ di dɔ rö koro nima. ");
INSERT INTO bex_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ne ɔdɔ koloma le lïjë ogbɔgbɔ rönnï dë. ");
INSERT INTO bex_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Mï kada ꞌba liŋgere ꞌbënnï nima pili lïjë öꞌbö toꞌja pɔli ꞌba Bɔkoꞌba dɔ rö koro nima rɔ mï kada. Tine ma rɔ mï korɔndɔ paꞌdo na köbö dɔmo mï pɔli mo nima.");
INSERT INTO bex_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ame na rɔ möyï ꞌbu löbu ꞌba Yësu Kurïsïtö kupö Dawidi kupö Abarayama. ");
INSERT INTO bex_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarayama na köyö Yisika, Yisika na köyö Yakoba, Yakoba na köyö Yuda ni ti löndö bo ga. ");
INSERT INTO bex_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda na köyö Pereze ni ti Zera ame mönnï na rɔ Tamara ne. Pereze na köyö Ezerona, Ezerona na köyö Rami. ");
INSERT INTO bex_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rami na köyö Aminadaba, Aminadaba na köyö Nasona, Nasona na köyö Salamono. ");
INSERT INTO bex_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamono na köyö Bɔwaza ame ma mo rɔ Raba ne. Bɔwaza na köyö Obede ame ma mo rɔ Ruta ne. Obede na köyö Yisayi. ");
INSERT INTO bex_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yisayi na köyö Dawidi bɔ dɔliŋɔ. Dawidi na köyö Solomo ame ma mo rɔ makuruꞌbë pötö Uriya ne. ");
INSERT INTO bex_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomo na köyö Rebama, Rebama na köyö Abiya, Abiya na köyö Asa. ");
INSERT INTO bex_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa na köyö Yesopata, Yesopata na köyö Yorama, Yorama na köyö Uzïya. ");
INSERT INTO bex_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzïya na köyö Yotama, Yotama na köyö Aza, Aza na köyö Ezikiya. ");
INSERT INTO bex_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezikiya na köyö Manase, Manase na köyö Amona, Amona na köyö Yosiya. ");
INSERT INTO bex_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya na köyö Yekoniya ni ti löndö bo ga mï kada ꞌba tindaꞌba bilaka kari Babele. ");
INSERT INTO bex_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Di pötö tindaꞌba bilaka kari Babele na Yekoniya köyö Salatele, Salatele na köyö Zerobabele, ");
INSERT INTO bex_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerobabele na köyö Abiyuda, Abiyuda na köyö Elekima, Elekima na köyö Azora, ");
INSERT INTO bex_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azora na köyö Zadoka, Zadoka na köyö Akimi, Akimi na köyö Eliyuda, ");
INSERT INTO bex_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda na köyö Elezara, Elezara na köyö Matana, Matana na köyö Yakoba, ");
INSERT INTO bex_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoba na köyö Yesepa ame bo na rɔ mëꞌdë ꞌba Mariya ma ꞌba Yësu ma kïdëkï rɔ Kurïsïtö ne. ");
INSERT INTO bex_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tine ꞌbu löbu ma kisaki di zi Abarayama ŋbö kömö zi Dawidi ëdï pili ꞌbutë dɔmosowɔ. Kina ma kisaki di zi Dawidi ŋbö kömö mï kada ꞌba tindaꞌba bilaka kari Babele ëdï pili ꞌbutë dɔmosowɔ. Kina ma kisaki di mï kada ꞌba tindaꞌba bilaka kari Babele ŋbö kömö zi Kurïsïtö ëdï gbï pili ꞌbutë dɔmosowɔ. ");
INSERT INTO bex_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tine töyö Yësu Kurïsïtö na kɔzɔ a nime te. Ɔdɔ kïlïbö ma bo Mariya ꞌdeni ꞌdɔ togbe mo zi Yesepa tine gba kinza lïjë kodɔꞌbɔ dönnï dë lɔko ari kikali rönï lɔko ɔmɔ ꞌdeni ti tigɔ ꞌba Nyï Kɔtɔ Laka. ");
INSERT INTO bex_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tine mëꞌdë nï Yesepa rɔ bɔ lende laka, kina bo oꞌdɔkɔ dë ꞌdɔ tuburu lɔko kɔmɔ bilaka ma konzi. Kina bo komeri ŋgï ꞌdɔ tope lɔko lowo. ");
INSERT INTO bex_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kina ɔdɔ bo koꞌdɔ meri mo ꞌdeni tara tine, Bɔkoꞌba iꞌdi nyï koꞌde ŋgï dɔ bo kina malayika ꞌba Bɔkoꞌba kilende zi bo, iya te, “Yesepa kupö Dawidi, kinza kere dë di bi togba Mariya zïyï liŋɔ rɔ ꞌja ꞌbï. Römöyï kole nima mïnï ne Nyï Kɔtɔ Laka na kiꞌdi lɔko kɔmɔ. ");
INSERT INTO bex_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lɔko ti köyö kole kina ti kïdëkï möyï mo rɔ Yësu. Römöyï bo na ti kɔmɔ bilaka abo ga yaga di mï lende kënyë ꞌbënnï ga.” ");
INSERT INTO bex_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wa naga nime oꞌdɔ rönnï ꞌdeni ꞌdɔ këdï kɔzɔ wa ma tönë ga Bɔkoꞌba kiꞌdi bɔ kumë lende abo ga kiya ꞌdeni mɔlo ne tara. Ame kiya te, ");
INSERT INTO bex_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nyiti mɔtɔ gba rɔ yïtö ti kɔmɔ ꞌdeni köyö kole. Kina ti kïdëkï möyï mo rɔ Imanuwëlë.” Ame ꞌjɔ ꞌba lende ꞌba möyï nima iya te, “Bɔkoꞌba ëdï tize.” ");
INSERT INTO bex_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kina ɔdɔ Yesepa koŋgɔ bi tine bo ogbe Mariya ŋgï kɔzɔ ma malayika ꞌba Bɔkoꞌba kiya zi bo. ");
INSERT INTO bex_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tine Yesepa ni indaꞌba dönnï dë titi ti Mariya ŋbö lɔko köyö kole. Kina bo kiꞌdi möyï mo ŋgï rɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Öyö Yësu ꞌdeni Beteleme mï dɔyayi ꞌba Yudayi mï kada ꞌba Erode bɔ dɔliŋɔ. Kina bɔ lende kikali mɔtɔ ga ako ra di bïcï tɔrɔ ŋbö kömö Yerosalema. ");
INSERT INTO bex_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Lïjë ititi, tëgë, “Kole nime köyö bine rɔ ŋere ꞌba Yudayi ne, bo ëdï yala ga? Këlu abo doꞌja ꞌdeni di bïcï tɔrɔ, kina me dako tïlëlu bo.” ");
INSERT INTO bex_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kina ɔdɔ Erode kuwö lende nime ꞌdeni te tine, mï bo ënyï kombi ŋgï kina bilaka ꞌba Yerosalema mɔtɔ ga yïmo ombi ꞌdeni gbï. ");
INSERT INTO bex_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kina bo kari kïdëkï löbu ꞌba bɔ akumu ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ŋgï pili gɔ kako zi bo, kina bo kititi lïjë, bo iya te, “Ɔdɔ tara ne Kurïsïtö ame Bɔkoꞌba këdï koja kako di mïtɔrɔ ne ëdï köyö bo yala ga ya?” ");
INSERT INTO bex_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lïjë iya te, “Ëdï köyö Kurïsïtö mï Beteleme mï dɔyayi ꞌba Yudayi bine. Römöyï bɔ kumë lende ꞌba Bɔkoꞌba mɔtɔ ugu lende nime ꞌdeni mɔlo ame kiya te, ");
INSERT INTO bex_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nï, Beteleme, dɔyayi ꞌba Yudayi nime, inza ꞌbëyï kulöwö wötï titiyi bërï di mï dɔyayi ꞌba Yudayi nime. Bilaka ma löbu ti kɔdɔ ꞌdeni di mïyï ame gɔ kokɔkɔ bilaka ma ga ꞌba Yisarele.’” ");
INSERT INTO bex_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kina Erode kïdëkï bɔ lende kikali tönë ga ŋgï lowo kako zi bo gɔ lïjë kiya kada ꞌba tɔdɔ ꞌba këlu nima zi bo. ");
INSERT INTO bex_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kina bo kënyï koja lïjë ŋgï kari, bo iya te, “Arike Beteleme toma gɔ kole nima. Ɔdɔ koꞌjake bo ꞌdeni ako kiyake lende mo zö gɔ mari gbï tïlëlu bo.” ");
INSERT INTO bex_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Kina ɔdɔ lïjë kuwö lende kiya ꞌba Erode nima ꞌdeni tine lïjë ënyï ŋgï tari. Kina lïjë koꞌja këlu mo tönë lïjë koꞌja mɔlo di yïbï ne ŋgï. Kina ɔdɔ lïjë koꞌja ꞌdeni tara tine lïjë ŋgï ti mï këyï rɔ mbëmbë. Këlu nima ösö nduwë dɔgba zïnnï ŋbö kari kɔrɔ dɔ bi ame kole Yësu këdï teyi ne. ");
INSERT INTO bex_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kina lïjë kɔdɔ ŋgï kari koꞌja kole ni këdï rö yayi ti ma mo. Kina lïjë kolɔdɔ ŋgï bërï tïlëlu bo. Kina lïjë kunyë kpa sandu ꞌbënnï ga ŋgï, lïjë kiꞌdi kpa közï kiꞌdi ꞌbënnï ga zi kole nima. Kpa közï kiꞌdi mo ga rɔ yamo köbököbö, ti akato kele ti wɔwɔ kele mɔtɔ kïdëkï möyï mo rɔ murï. ");
INSERT INTO bex_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tine na Bɔkoꞌba kiyandi lïjë ŋgï ti nyï kinza lïjë kileki dë kpe kebe dɔ Erode. Kina lïjë kileki ŋgï kari dɔyayi ꞌbënnï ti kɔri ma löwö mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kina ɔdɔ ya naga nima kari ꞌdeni tine, Bɔkoꞌba iꞌdi nyï koꞌde ŋgï dɔ Yesepa, kina malayika kiya zi bo, iya te, “Erode oꞌdɔkɔ toma gɔ kole nime ꞌdɔ bo kupö yaga. Ënyï ti kole nime ti ma mo kiriŋa kari Ezipeto. Oloma yayi ŋbö ma na ꞌjaa ti miya zïyï gɔ kileki.” ");
INSERT INTO bex_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kina Yesepa kënyï ŋgï mï korɔndɔ nima kiriŋa kari Ezipeto ti kole tönë ti ma mo. ");
INSERT INTO bex_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Lïjë ari ꞌdɔ toloma Ezipeto yayi ŋbö kömö mï kada ꞌba tölë ꞌba Erode. Loma ꞌbënnï yayi nima ëdï ꞌdeni kɔzɔ lende ꞌba Bɔkoꞌba ame tönë bo kiya ꞌdeni mɔlo ti bɔ kumë lende abo mɔtɔ, kiya te, “Mïdëkï kole ma ꞌdeni kako di Ezipeto.” ");
INSERT INTO bex_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kina ɔdɔ Erode kikali ꞌdeni bɔ lende kikali naga nima ïndëndë dɔ bo ꞌdeni kɔzɔ a nima tara tine, mï bo ënyï kata ŋgï. Kina bo koja bɔ kanya abo ga ŋgï kari mï dɔliŋɔ pili ꞌba Beteleme tupö kole titi ame ga pili rɔ bɔtɔni ne, ame kɔmɔ kɔɔ mo ga këdï ꞌdeni rïyö ŋbö kömö dɔ ame ga köyö mï kɔmɔ kɔɔ mo nima ne. Tisaki mo di dɔ ame ga kɔmɔ kɔɔ mo ga këdï ꞌdeni rïyö ne römöyï gɔ lende ꞌba kada ꞌba tɔdɔ ꞌba këlu ame bo kuwö lende mo di zi bɔ lende kikali naga nima ne. ");
INSERT INTO bex_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tupö kole titi ꞌba Beteleme naga nime ëdï ꞌdeni kɔzɔ lende ꞌba Bɔkoꞌba ame bo kiya ꞌdeni mɔlo ne tara, ame Yeremaya kumë ꞌdeni mɔlo kiya te, ");
INSERT INTO bex_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Birɔ ëdï kudu mï Rama, birɔ ꞌba monɔ ni ti kuwu. Rayile na këdï kudu gɔ kole ꞌba kole ꞌbënnï ga. Lïjë ölë ꞌdeni pili kina lɔko oꞌdɔkɔ dë kpe gɔ kuyë kömönï.” ");
INSERT INTO bex_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tine Yesepa ni ëdï ꞌdeni koloma mï Ezipeto. Kina ɔdɔ Erode kölë ꞌdeni tine, na Bɔkoꞌba kiꞌdi nyï koꞌde ŋgï dɔ Yesepa, kina malayika kɔdɔ ŋgï zi bo, ");
INSERT INTO bex_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kiya te, “Ënyï di bine ti kole titi nime ti ma mo kileki kari mï dɔyayi ꞌba Yisarele. Bilaka ma tönë ga yayi koꞌdɔkɔ tupö kole nime ne lïjë ölë ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kina bo kënyï ŋgï ti kole tönë ti ma mo, bo kileki kari mï dɔyayi ꞌba Yisarele. ");
INSERT INTO bex_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tine bo ari kuwö ꞌböwu tëgë kole ꞌba Erode, ame kïdëkï möyï mo rɔ Arokelawo ne, na ꞌdeni rɔ ŋere ꞌba Yudayi. Kina bo kere ŋgï di bi tari toloma mï Yudayi. Kina Bɔkoꞌba kiꞌdi nyï mɔtɔ koꞌde gbï dɔ bo, kiya zi bo gɔ bo kari koloma Galilaya. ");
INSERT INTO bex_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kina ɔdɔ bo kömö ꞌdeni yayi tine, bo ari koloma ꞌdeni mï gawo mɔtɔ kïdëkï rɔ Nazareta. Loma mï Nazareta nima ëdï ꞌdeni kɔzɔ lende ꞌba Bɔkoꞌba ame bo kiya ꞌdeni mɔlo ne tara, ame bilaka mɔtɔ ga kumë lende mo ꞌdeni, kiya te, “Bɔ nima ti kïdëkï bo ꞌdeni rɔ bilaka ꞌba Nazareta.” ");
INSERT INTO bex_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mï kada naga nima yayi Yowani bɔ bapatisi ɔdɔ ꞌdeni yï mökö mï dɔyayi ꞌba Yudayi. Kina bo kisaki ꞌdeni tuwöwö laja ꞌba Bɔkoꞌba zi bilaka. ");
INSERT INTO bex_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Iya te, “Otɔke dɔye di mï lende kënyë ꞌbe ga römöyï ŋere löbu ꞌba Bɔkoꞌba ëdï ꞌdeni ŋɔli.” ");
INSERT INTO bex_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowani nime na tönë Yesaya bɔ kumë lende ꞌba Bɔkoꞌba kiya lende mɔlo gɔ köꞌdu mo, ame bo kiya te, “Bɔ mɔtɔ ëdï kuwöwö dɔ bo di yï mökö kiya te, ‘Ileŋoke kɔri zi ŋere. Odɔrɔke gɔ kɔri zi bo.’” ");
INSERT INTO bex_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bɔŋgɔ ꞌba rɔ Yowani oꞌdɔ di mï sunë gamele. Kina kilaka na bo kudödu ꞌbömbö bo rɔ gasi. Akonyo abo ga rɔ mömï ni ti tagi ꞌba mï ꞌbɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bilaka ɔlɔ ꞌdeni kari zi bo di mï Yerosalema, di mï dɔliŋɔ ꞌba Yudayi pili kina gbï di mï liŋɔ ame ga pili ŋgɔsi kpa yöpö ꞌba Yaradene ne. ");
INSERT INTO bex_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Lïjë odɔ kpënnï gɔ lende kënyë ꞌbënnï ga kina bo kodɔ mini ꞌba bapatisi ŋgï dönnï mï yöpö ꞌba Yaradene. ");
INSERT INTO bex_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tine ɔdɔ bo koŋgɔ ya ma kïdëkï rɔ Parosi ni ti Sadoke ma konzi ꞌdeni këdï kako zi bo mï bapatisi tine, bo iya te, “Kpe kole ꞌba murë naga nime, yë na kuꞌbölu ye tiriŋa di kpa ya nime këdï kako dɔye ne? ");
INSERT INTO bex_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Oꞌdɔke wa ame ga ꞌdɔ kileme otɔke dɔye ꞌdeni di mï lende kënyë ꞌbe ga ne. ");
INSERT INTO bex_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kinza kebeke dë tomeri mo ti kɔmɔke di mï gomɔ nima gɔ ame kiyake te kpe kupö Abarayama na ne. Rɔ ma laka miya ziye Bɔkoꞌba ti kikali ŋgï togba döku naga nime koꞌdɔ rɔ kupö zi Abarayama. ");
INSERT INTO bex_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Goroŋa ëdï ꞌdeni ndö ndï ŋgërï toga mo bërï ti ŋgiraꞌda mo. Ŋgërï ame ga pili kana a ma laka dë ne ti koga bërï kuꞌdu mï paꞌdo. ");
INSERT INTO bex_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mëdï moꞌdɔ ꞌbama bapatisi ŋge dɔye ti mini ꞌdɔ kileme dɔ kotɔ. Tine bɔ ma këdï kako di pötö ma nime, bo na mbiri di dɔma, pele rɔ tombi wari abo mɔꞌbɔ dë. Bo ti koꞌdɔ ꞌba bo bapatisi dɔye ti Nyï Kɔtɔ Laka gbï ti paꞌdo. ");
INSERT INTO bex_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Bo ëdï ti kïzërï abo ꞌdɔ tubö nyönyu timo. Bo ti kotowa dɔkandilere abo, bo kiꞌdi nyönyu abo ga mï mata tine turu mo bo ti koŋma yaga ti paꞌdo ame kinza kölu dë ne.” ");
INSERT INTO bex_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kina Yësu kako di Galilaya kömö kpa yöpö ꞌba Yaradene zi Yowani ꞌdɔ koꞌdɔ bapatisi dɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tine Yowani oma tota bo, iya te, “Ako za ꞌböwu zö, oꞌja ma na ꞌdɔ mari zïyï ꞌdɔ koꞌdɔ bapatisi dɔma ꞌdï?” ");
INSERT INTO bex_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tine Yësu ileki dɔmo iya te, “Iꞌdi këdï tötï tara. Römöyï ti toꞌdɔ mo te na ti doꞌdɔ ŋgï kɔzɔ akoꞌdɔkɔ abo ꞌba Bɔkoꞌba tara.” Kina Yowani kutï ŋgï gɔmo. ");
INSERT INTO bex_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kina ɔdɔ koꞌdɔ bapatisi ꞌdeni dɔ Yësu bo këdï kɔdɔ yaga di mï mini tine na mïtɔrɔ kurögö rönï ŋgï zi bo. Kina bo koꞌja Nyï Kɔtɔ Laka ꞌba Bɔkoꞌba këdï kako bërï dɔ bo di mïtɔrɔ kɔzɔ matukpuru tara. ");
INSERT INTO bex_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kina birɔ kudu ŋgï di mïtɔrɔ kiya te, “Ame na rɔ kole ma. Mɔꞌɔ bo ꞌdeni kulöwö. Ma ti mï këyï rɔ mbëmbë gɔ lende abo.” ");
INSERT INTO bex_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kina Nyï Kɔtɔ Laka koto Yësu ŋgï kari yï mökö ꞌdɔ Satani kiyɔzɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kina ɔdɔ bo koꞌdɔ töꞌdö ꞌdeni dɔ ꞌbutë sowɔ bo konyo ɔtɔ dë tine bo ꞌdeni rɔ ꞌbö. ");
INSERT INTO bex_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kina Satani kako ŋgï zi bo kiya te, “Ɔdɔ këddï ŋgï rɔ kole ꞌba Bɔkoꞌba ilende zi kulugbï döku naga nime ꞌdɔ kuyï rönnï rɔ maŋgolɔꞌbɔ zïyï.” ");
INSERT INTO bex_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tine Yësu ileki dɔmo, iya te, “Ugu ꞌdeni mï buku ꞌba Bɔkoꞌba iya te, ‘Bilaka oloma dë ŋge kɔtɔ gɔ akonyo tine ti lende ame ga pili këdï kɔdɔ di kpa Bɔkoꞌba ne.’” ");
INSERT INTO bex_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kina Satani koto Yësu ŋgï kari Yerosalema gawo kɔtɔ laka nima, kina kiꞌdi bo ŋbö dɔ kumu rö löbu ꞌba Bɔkoꞌba, ");
INSERT INTO bex_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kina kiya zi bo, iya te, “Ɔdɔ këddï ŋgï rɔ kole ꞌba Bɔkoꞌba ola röyï bërï. Römöyï ugu ꞌdeni mï buku ꞌba Bɔkoꞌba iya te, ‘Bo ti kiꞌdi lende zi malayika abo ga gɔ köꞌdu ꞌbï ꞌdɔ lïjë kikapo yï kinza koga ndïyï ra yɔki döku ma kɔtɔ mɔtɔ.’” ");
INSERT INTO bex_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tine Yësu ileki dɔmo iya te, “Ugu ꞌdeni gbï iya te, ‘Kinza kiyɔzɔ ŋere Bɔkoꞌba ꞌbï dë.’” ");
INSERT INTO bex_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kina Satani koto bo ꞌböwu ŋbö dɔ döku ma kakpa rɔ dɔ kiteli kina kileme dɔliŋɔ nime ti tele mo ga pili zi bo, ");
INSERT INTO bex_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","iya te, “Wa naga nime pili ti miꞌdi zïyï ɔdɔ kolɔdɔ bërï zö kumötu ma.” ");
INSERT INTO bex_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yësu ileki dɔmo zi bo, iya te, “Ese yaga di rɔma Satani. Römöyï ugu ꞌdeni iya te, ‘Ŋere Bɔkoꞌba ꞌbï na ŋge kɔtɔ ꞌdɔ kumötu kulömu kpëyï teyi.’” ");
INSERT INTO bex_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kina Satani kola bo ŋgï na malayika kako ŋgï tokɔnyi bo. ");
INSERT INTO bex_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kina ɔdɔ Yësu kuwö ꞌdeni kiya te iꞌdi Yowani ꞌdeni mï maboso tine, na bo kënyï ŋgï kari Galilaya. ");
INSERT INTO bex_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tine bo oloma dë Nazareta bo ari ŋgï nduwë Kaparanoma. Ame rɔ gawo ma kpa pöpö ꞌba Galilaya mï dɔyayi ꞌba Zebolona ni ti Napatali. ");
INSERT INTO bex_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Oꞌdɔ rönï ꞌdeni ꞌdɔ këdï kɔzɔ ma tönë Yesaya bɔ kumë lende ꞌba Bɔkoꞌba kiya ne tara. Ame kiya te, ");
INSERT INTO bex_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ya ma mï dɔyayi ꞌba Zebolona ni ti Napatali, ti ya ma kpa kɔri mini löbu ti ya ma gönyï yöpö ꞌba Yaradene ti bilaka ꞌba Galilaya dɔyayi ma ti bɔ löwö yïmo, ");
INSERT INTO bex_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","lïjë ame ga pili këdï koloma mï bi kölu ne oꞌja bi kɔpɔ ma löbu ꞌdeni. Bi kɔpɔ oyi rönï ꞌdeni dɔ ya ma këdï koloma mï mandölu ꞌba tölë naga.” ");
INSERT INTO bex_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mï kada nima yayi Yësu isaki ꞌdeni tuwöwö laja abo zi bilaka, iya te, “Otɔke dɔye di mï lende kënyë ꞌbe ga römöyï ŋere löbu ꞌba Bɔkoꞌba ëdï ꞌdeni ŋɔli.” ");
INSERT INTO bex_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kina ɔdɔ Yësu këdï ꞌdeni kiliŋgere kebe kpa pöpö ꞌba Galilaya tine, na bo kari koꞌja atoyi rïyö mɔtɔ ga ŋgï, Simona ma kïdëkï rɔ Pïtörö ni ti löndö bo Andareya këdï ga rɔ tugu kenze di mï pöpö ti duru. ");
INSERT INTO bex_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kina Yësu kiya zïnnï, iya te, “Ösöke gɔma, ti miꞌdi ye rɔ atoyi ꞌba toꞌde bilaka kako zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kina lïjë kola duru ꞌbënnï ga ŋgï lïjë kösö gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kina ɔdɔ bo kari nduwë dɔgba di yayi tine bo ari koꞌja löndö ma rïyö mɔtɔ ga gbï, Yakoba ni ti Yowani kole ꞌba Zebedayo ga këdï mï sorope ti ꞌbu nnï tileŋo duru ꞌbënnï. Kina ɔdɔ Yësu kïdëkï lïjë tine, ");
INSERT INTO bex_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","lïjë ënyï ŋgï kola sorope ti ꞌbu nnï yayi, lïjë kösö gɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yësu iliŋgere kote mï Galilaya toko tiyandi kɔmɔ bilaka mï rö ꞌba mötu ꞌba Yudayi, tuwöwö laja laka ꞌba ŋere löbu ꞌba Bɔkoꞌba, gbï tileŋo bilaka ame ga pili këdï ti dɔkomali rɔkɔꞌɔ mɔtɔ ga ne. ");
INSERT INTO bex_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Lëbï abo ote mï dɔyayi ꞌba Surïya ꞌdeni, kina bilaka koloma ŋgï rɔ toꞌde bɔ rɔkɔꞌɔ pili kako zi bo. Bilaka ame ga pili ti dɔkomali rɔkɔꞌɔ ma gege ti ya ma ti abërï naga kpaki ti bɔ nökï ni ti ya ma keŋme bërï naga oꞌde ꞌdeni pili kako zi bo kina bo kileŋo lïjë ꞌdeni pili. ");
INSERT INTO bex_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tïndï ma konzi ꞌba bilaka ösö ꞌdeni gɔ bo di Galilaya ni ti Gawo ꞌButë, gbï di Yerosalema gbï di mï Yudayi, kina gbï di mï dɔyayi ma gönyï Yaradene. ");
INSERT INTO bex_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kina ɔdɔ Yësu koŋgɔ tïndï ꞌdeni tara tine bo ëkï ŋgï kari koloma dɔ döku tɔrɔ. Bɔ kösö gɔ bo ga ako zi bo ");
INSERT INTO bex_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na bo koloma ŋgï rɔ tiyandi lïjë kpaki ti tïndï naga nima, kiya te, ");
INSERT INTO bex_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Lïjë ame ga rɔ rumö na laka römöyï ŋere löbu ꞌba Bɔkoꞌba nime na rɔ ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lïjë ame ga ti monɔ na laka römöyï ti kïyëyï lïjë ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lïjë ame ga koꞌdɔ dɔ kombi dë na laka römöyï lïjë ti koꞌja wa ma Bɔkoꞌba kulömu ꞌdeni zi bilaka abo ga ne ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Lïjë ame ga mïnnï löbu gɔ toꞌdɔ akoꞌdɔkɔ ꞌba Bɔkoꞌba na laka römöyï Bɔkoꞌba ti kiꞌdi ꞌdeni ŋgï kɔꞌbɔ lïjë. ");
INSERT INTO bex_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Lïjë ame ga rɔ bɔ mï koŋmi na laka römöyï Bɔkoꞌba ti koꞌdɔ mï koŋmi gbï zïnnï. ");
INSERT INTO bex_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lïjë ame ga dökïꞌdï nnï ŋge kɔtɔ gɔ lende ꞌba Bɔkoꞌba na laka römöyï lïjë ti koꞌja Bɔkoꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Lïjë ame ga rɔ bɔ lata toꞌdɔ lende këyï mï löŋgö bilaka na laka römöyï Bɔkoꞌba ti kïdëkï lïjë ꞌdeni rɔ kole abo ga. ");
INSERT INTO bex_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lïjë ame ga bilaka këdï koꞌdɔ közï kasi zïnnï gɔ lende laka ꞌba Bɔkoꞌba na laka römöyï ŋere löbu ꞌba Bɔkoꞌba na rɔ ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kpe ame bilaka këdï kitiꞌja ye koꞌdɔ közï kasi ziye kiya kpa kënyë rɔye rɔ mbëmbë römöyï kpe bɔ kösö gɔma ga na ne, kpe na laka. ");
INSERT INTO bex_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kina olomake rɔ lɔŋɔ ti mï këyï römöyï Bɔkoꞌba ulu kpa közï ma löbu ꞌdeni koda ye mïtɔrɔ. Bɔ kumë lende ꞌba Bɔkoꞌba ma tönë ga koloma dɔgba bine bilaka oꞌdɔ közï kasi gbï teyi kɔzɔ ꞌbeye te.” ");
INSERT INTO bex_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kpe ꞌbeye ëddïke kɔzɔ tikɔꞌdɔ tara zi bilaka lesi ꞌba mï dɔyayi nime. Ne tine ɔdɔ tikɔꞌdɔ kote tulöwu ma kiyɔkɔ ꞌbënï ꞌdeni ti koꞌdɔ ꞌböwu kileki kiyɔkɔ totondo mo ga ya? Ele dë kpe ŋburu mï kɔtɔ, tine ꞌdeni ŋgï ꞌdɔ tuꞌdu mo mökö tututu dɔmo ti ndï. ");
INSERT INTO bex_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kina ëddïke gbï kɔzɔ bi kɔpɔ ꞌba dɔliŋɔ nime. Gawo ame kubö ꞌdeni dɔ kuruŋgu ne ikali dë kpe tusu dɔmo. ");
INSERT INTO bex_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kina bilaka iꞌdi paꞌdo dë gbï dɔ lamba kogba kutuꞌbö dɔmo ti kete. Tine ëdï kiꞌdi lamba ŋgï dɔ a ꞌba tïdëyï mo ꞌdɔ kiyɔpɔ gɔ bi pili mï rö yayi. ");
INSERT INTO bex_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kina gbï tara ꞌdɔ bi kɔpɔ ꞌbe kiyɔpɔ gɔ bi kɔmɔ bilaka gɔ lïjë koꞌja wa ma laka ame ga këddï koꞌdɔke ne. Römöyï ꞌdɔ lïjë kïlëlu ꞌbu ye ame mïtɔrɔ ne gɔ köꞌdu mo.” ");
INSERT INTO bex_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kinza komerike dë te mako ꞌdeni tuburu köꞌdu kiꞌdi ꞌba Musa ni ti akiyandi ꞌba bɔ kumë lende ꞌba Bɔkoꞌba. Mako dë tuburu mo tine mako ꞌdɔ toꞌdɔ mo këdï ŋgï kɔzɔ ame lïjë kiya ne. ");
INSERT INTO bex_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iꞌdike lende nime këdï dɔye, kɔzɔ mïtɔrɔ ni ma ti dɔyayi ame köꞌbö ꞌdeni ŋburu ne tara, gɔ bi ma titi ꞌdeki mɔtɔ di mï köꞌdu kiꞌdi nime inza kölu kɔtɔ te. Tine ŋbö koꞌdɔ rönï ko kɔzɔ ame kiya rönï ne. ");
INSERT INTO bex_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Gɔ köꞌdu mo na bilaka ame kuwö dɔ köꞌdu kiꞌdi nime dë ala pele ŋge rɔ kapa ma mbowa mo mɔtɔ, kina bo kutu ya mɔtɔ ga gbï toꞌdɔ mo tara ne ti kïdëkï bo ŋgï wötï titiyi di mï ŋere löbu ꞌba Bɔkoꞌba. Kina gbï tara, bɔ ame kuwö dɔmo kina bo kutu ya mɔtɔ ga gbï toꞌdɔ mo tara ne bo ti këdï ŋgï rɔ löbu mï ŋere löbu ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kina me miya ziye inza kɔꞌbɔke tɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba ɔdɔ kiya te kogbɔke rɔye dë ŋgï laka kebe bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ti Parosi ni bi toꞌdɔ wa ame ga pili Bɔkoꞌba koꞌdɔkɔ ne.” ");
INSERT INTO bex_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Uwöke ꞌdeni tönë mɔlo bine, iya te, ‘Kinza koꞌdɔ röyï dë rɔ bɔ közï roma. Bɔtɔ ame kupö bilaka ti koto ŋgï mï bi ꞌba burë.’ ");
INSERT INTO bex_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tine kina me miya ziye, bɔtɔ ame rɔ ꞌdïrï ti löndö mɔtɔ ti koꞌde ŋgï mï gɔ bi ꞌba burë. Bɔtɔ ame kiya zi löndö mɔtɔ kiya te, ‘Nï wa yawa nime,’ ti koꞌde ŋgï kɔmɔ kïtï ꞌba burë ma löbu. Bɔtɔ ame kiya zi löndö mɔtɔ kiya te, ‘Nï rumö yawa nime,’ bo irasi lende ꞌdeni ꞌdɔ tuꞌdu bo mï paꞌdo ꞌba Gehena. ");
INSERT INTO bex_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Gɔ köꞌdu mo na nï bɔ mɔtɔ ɔdɔ këddï koto kpa közï ꞌbï ꞌdeni tiꞌdi mo dɔ bi ꞌba akumu zi Bɔkoꞌba kina lende mo köyö mïyï lende mɔtɔ këdï mbowa mï löŋgö ye ti löndö mɔtɔ, ");
INSERT INTO bex_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ola kpa közï ꞌbï tötï yayi kileki titi kari koteke lende nima yaga. Kina ꞌdɔ kako ꞌjaa kiꞌdi kpa közï ꞌbï zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ɔdɔ bɔ mɔtɔ kindaꞌba yi toto yi mï bi ꞌba burë, ote lende nima welo yaga ti bo gba kota kinza kömö mï bi ꞌba burë. Römöyï ɔdɔ kiya te kömö ꞌdeni yayi bo ëdï kiꞌdi yi ŋgï közï bɔ burë kina lïjë këdï kiꞌdi yi ŋgï közï bɔ kanya kina këdï koto yi ŋgï mï maboso. ");
INSERT INTO bex_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kina ti koloma ŋgï yayi ŋbö kopi taripa ꞌba karama ma kodɔ döyï nima ŋgï titi du. Rɔ ma laka mëdï miya ziye.” ");
INSERT INTO bex_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Uwöke ꞌdeni iya te kinza koꞌdɔ yërï dë. ");
INSERT INTO bex_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tine kina me mëdï miya ziye, bɔtɔ mɔtɔ ame koŋgɔ ꞌja mɔtɔ pele ŋge ti kɔmɔ bo kina meri ꞌba mï bo kiteri ꞌja nima ꞌdeni, bo oꞌdɔ yërï ꞌdeni ti ꞌja nima ti mï bo. ");
INSERT INTO bex_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gɔ köꞌdu mo na, ɔdɔ kömöyï ma dörï na kiꞌdi yi koꞌdɔ lende kënyë, iyagba bo yaga kuꞌdu mökö. Tuꞌdu ŋge rɔ kapa yï ma kɔtɔ mökö ëdï laka rɔ dɔ kiteli di dɔ ame ꞌdɔ kuꞌdu yi pili mï paꞌdo ꞌba Gehena ne. ");
INSERT INTO bex_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kina ɔdɔ közïyï ma dörï na kiꞌdi yi koꞌdɔ lende kënyë, oke bo yaga kuꞌdu mökö. Tuꞌdu ŋge rɔ kapa yï ma kɔtɔ mökö ëdï laka rɔ dɔ kiteli di dɔ ame ꞌdɔ koto yi pili mï paꞌdo ꞌba Gehena ne.” ");
INSERT INTO bex_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Iya ꞌdeni gbï te ɔdɔ bɔ mɔtɔ koga ꞌja abo ꞌdɔ bo kugu waraga ꞌba tëyï kiꞌdi teyi. ");
INSERT INTO bex_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tine kina me miya ziye, ɔdɔ bɔtɔ mɔtɔ koga ꞌja abo gɔ lende mɔtɔ ꞌberi di gɔ kɔmɔ kolɔlɔ ꞌba töꞌdö ti rɔ, bo irasi lende ꞌdeni. Bo na kiꞌdi ꞌja nima ꞌdeni ꞌdɔ koꞌdɔ yërï ɔdɔ lɔko kari kogbe mëꞌdë mɔtɔ ꞌböwu. Kina mëꞌdë mɔtɔ mo ame kari kogbe lɔko ꞌböwu ne oꞌdɔ yërï ꞌdeni gbï.” ");
INSERT INTO bex_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Uwöke ꞌdeni tönë mɔlo bine, iya te, ‘Kinza kïyëyï mï lömu ꞌbï dë. Tine oꞌdɔ wa ame kulömu röyï ꞌdeni zi Bɔkoꞌba ꞌdɔ toꞌdɔ mo ne.’ ");
INSERT INTO bex_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kina me mëdï miya ziye, ɔdɔ kiꞌdike köꞌdu ꞌba a mɔtɔ kinza koꞌdɔke lömu dë teyi. Kinza kulömuke rɔye dë ti mïtɔrɔ römöyï kïtï ꞌba Bɔkoꞌba na. ");
INSERT INTO bex_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kina kinza kulömuke rɔye dë ti dɔyayi römöyï bi tïdëyï ndï bo na. Tine kinza kulömuke rɔye dë gbï ti Yerosalema römöyï gawo ꞌba Bɔkoꞌba bɔ dɔliŋɔ ma löbu na. ");
INSERT INTO bex_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kinza kulömuke rɔye dë gbï ti dɔye ga römöyï inza kɔꞌbɔke tuyï sunë ma kɔtɔ kaŋmi yaga ala kileki ꞌböwu kölu. ");
INSERT INTO bex_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iꞌdike lende kiya ꞌbe köꞌbö ŋge rɔ, ‘Yëë’ ala ‘Ee’. Wa mɔtɔ ame ꞌberi di gɔ ame ako di zi Satani.” ");
INSERT INTO bex_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Uwöke ꞌdeni, iya te, ‘Ɔdɔ kitikɔ kɔmɔ bɔ mɔtɔ ꞌdɔ kitikɔ kömöyï gbï. Kina ɔdɔ kotɔ kpa bɔ mɔtɔ ꞌdɔ kotɔ kpëyï gbï.’ ");
INSERT INTO bex_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tine kina me mëdï miya ziye. Nï bɔ mɔtɔ, ɔdɔ bɔtɔ mɔtɔ kirasi lende mɔtɔ zïyï kinza kopi dɔkolo mo dë. Ɔdɔ bɔtɔ mɔtɔ kokɔsɔ lɔꞌbɔ yï ma kapa dörï uyï kapa ma gali gbï zi bo ꞌdɔ bo kokɔsɔ. ");
INSERT INTO bex_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ɔdɔ bɔtɔ mɔtɔ koto yi zi bɔ burë ꞌdɔ kogba bɔŋgɔ ꞌba röyï iꞌdi bo kogba ma këdï kolɔ dɔmo gbï. ");
INSERT INTO bex_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɔdɔ bɔ kanya kiꞌdi yi tombi wa tari timo mayile kɔtɔ, tine ombi koto ŋbö mayile rïyö. ");
INSERT INTO bex_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Iꞌdi wa zi bilaka ame koꞌdɔkɔ wa di zïyï ne. Kina iꞌdi gbï zi bɔ ma koꞌdɔkɔ togba mo tötï ꞌdɔ kileki ꞌjaa ne.” ");
INSERT INTO bex_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Uwöke ꞌdeni iya te, ‘Ɔꞌɔ lëpï yï ga kina oꞌji bɔ ya ꞌbï ga.’ ");
INSERT INTO bex_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tine kina me mëdï miya ziye, ɔꞌɔke bɔ ya ꞌbe ga kina oꞌdɔke mötu gɔ ya ma këdï koꞌdɔ közï kasi ziye naga. ");
INSERT INTO bex_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ɔdɔ koꞌdɔke te ti këddïke ŋgï rɔ kole ꞌba ꞌbu ye ame mïtɔrɔ ne. Römöyï bo iꞌdi kada abo ꞌdeni keze dɔ bɔ lende kënyë ni kpaki ti bɔ lende laka. Kina bo iꞌdi tɔrɔ kaꞌdi ꞌdeni zi bɔ koꞌdɔ lende kënyë ni kpaki ti bɔ koꞌdɔ lende laka. ");
INSERT INTO bex_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ne ɔdɔ kɔꞌɔke ŋge rɔ ya ame ga kɔꞌɔ ye ne, ꞌdɔ Bɔkoꞌba kiꞌdi kpa közï ziye gɔ waꞌdi? Bɔ kireke awada ni oꞌdɔ gbï tara. ");
INSERT INTO bex_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne ɔdɔ löndö ye ga na ŋge kumötöke rɔ ma laka, lende laka waꞌdi na koꞌdɔke kulöwö bine di dɔ ꞌba ya ma laki? Ya ma kikali Bɔkoꞌba dë naga oꞌdɔ gbï tara. ");
INSERT INTO bex_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kina me olomake ti mï kɔtɔ rɔ ma laka kɔzɔ ꞌba ꞌbu ye ame mïtɔrɔ ne tara.” ");
INSERT INTO bex_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ziye tikali mo laka, kinza kebeke dë toꞌdɔ lende laka ꞌbe kɔmɔ bilaka ꞌdɔ koꞌja. Ɔdɔ koꞌdɔke tara inza koꞌjake a mɔtɔ du te gɔmo di zi ꞌbu ye ame mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tine ɔdɔ nï mɔtɔ këddï kiꞌdi wa zi bɔ lisa kinza kome more dë dɔmo kɔzɔ ꞌba bɔ kɔmɔ kandi naga nima këdï koꞌdɔ mï rö ꞌba mötu ala gɔ kɔri ꞌdɔ bilaka koro lïjë gɔmo ne tara. Rɔ ma laka miya ziye kpa közï ꞌbënnï na ꞌdeni pili ma. ");
INSERT INTO bex_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tine ɔdɔ këddï kiꞌdi wa zi bɔ lisa kinza kiꞌdi bɔtɔ ame pele ŋgɔsi ŋgila yi ne kikali gɔmo dë. ");
INSERT INTO bex_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ne ꞌdɔ këdï ŋgï liwo. Kina ꞌbu yï Bɔkoꞌba ame koꞌja wa ma koꞌdɔ liwo nima ne ti kiꞌdi kpa közïmo ŋgï zïyï.” ");
INSERT INTO bex_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tine ɔdɔ këddï koꞌdɔke mötu kinza këddïke dë kɔzɔ bɔ kɔmɔ kandi naga nima. Römöyï akoꞌdɔkɔ ꞌbënnï ma dɔ kiteli mo na rɔ tɔrɔ toꞌdɔ mötu mï rö ꞌba mötu ala kpa dɔkoka kɔri ꞌdɔ bilaka koꞌja lïjë. Rɔ ma laka miya ziye kpa közï ꞌbënnï na ꞌdeni pili ma. ");
INSERT INTO bex_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ne ɔdɔ këddï koꞌdɔ mötu ɔdɔ rö ꞌbï kurögö kpadörï teyi ꞌdɔ koꞌdɔ mötu zi ꞌbu yï Bɔkoꞌba ame bɔtɔ koꞌja dë ne. Kina ꞌbu yï Bɔkoꞌba ame koꞌja wa ma koꞌdɔ liwo nima ne ti kiꞌdi kpa közïmo ŋgï zïyï. ");
INSERT INTO bex_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kina ɔdɔ këddï koꞌdɔ mötu kinza kebe dë tojolo lende ma kinza ꞌjɔ mo naga rɔ gɔ kɔwɔ kɔzɔ ꞌba ya ma kinza kikali Bɔkoꞌba dë naga. Römöyï lïjë omeri ꞌbënnï tëgë ti kuwö lïjë gɔ lende konzi ꞌbënnï naga nima. ");
INSERT INTO bex_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kinza këddïke dë gbï kɔzɔ lïjë römöyï ꞌbu ye Bɔkoꞌba ikali wa ma koꞌdɔkɔke nima ꞌdeni mɔlo gba kinza kititike dë. ");
INSERT INTO bex_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tine na ꞌdɔ kumötuke kɔzɔ a nime te, ‘ꞌBu ze nï ame mïtɔrɔ ne, möyï yï köꞌbö rɔ ma koro. ");
INSERT INTO bex_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Iꞌdi ŋere löbu ꞌbï kako, akoꞌdɔkɔ ꞌbï koꞌdɔ rönï mï dɔliŋɔ kɔzɔ ma këdï koꞌdɔ rönï mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Oja gɔ akonyo ꞌba mï kada ma tɔne zize. ");
INSERT INTO bex_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ola ze gɔ lende kirasi ze ga kɔzɔ ma dëdï dola lëpï ze ga ma kirasi lende zize naga tara. ");
INSERT INTO bex_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kinza koto ze dë mï bi ꞌba akiyɔzɔ. Tine olɔ ze di zi bo bɔ ma kënyë nime.’ ");
INSERT INTO bex_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Römöyï ɔdɔ kolake bilaka gɔ lende ame lïjë kirasi ziye, ꞌbu ye ame mïtɔrɔ ne ti kola ye gbï gɔ lende kirasi ꞌbe ga. ");
INSERT INTO bex_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ne ɔdɔ kolake bilaka dë gɔ lende kënyë ꞌbu ye ame mïtɔrɔ ne inza kola ye gbï gɔ lende kënyë ꞌbe ga.” ");
INSERT INTO bex_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ɔdɔ këddï koroke kpeye kinza kebeke dë tirasi kɔmɔye kɔzɔ ꞌba bɔ kɔmɔ kandi naga nima. Lïjë upupu rönnï tulëtulë ꞌdɔ laki pili kikali lïjë ëdï rɔ toro kpënnï. Rɔ ma laka miya ziye kpa közï ꞌbënnï na ꞌdeni pili ma. ");
INSERT INTO bex_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tine ɔdɔ këddï koroke kpeye, urögöke kɔmɔye kosake ꞌbu, kujëke dɔye, ");
INSERT INTO bex_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kinza ya ma laki kikali ra ma këddï koroke kpeye ꞌdɔ ꞌbu ye ame koꞌja kïnë mo dë ne na ŋge kikali. Kina ꞌbu ye ame koꞌja wa ma koꞌdɔke liwo nima ti kiꞌdi kpa közïmo ŋgï ziye.” ");
INSERT INTO bex_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kinza kuluke kpa wa dë ziye mï dɔliŋɔ nime bine, ame madɔböndï ni këdï kirasi wa di teyi, kina gbï ame a mo ga këdï koromaro ne, kina gbï ame bɔ ꞌbögö këdï kuꞌbögö wa di teyi ne. ");
INSERT INTO bex_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tine ma laka mo ꞌdɔ kuluke kpa wa ziye mïtɔrɔ gɔ bi ame madɔböndï kirasi wa dë di teyi a mo ga koromaro dë bɔ ꞌbögö kuꞌbögö dë gbï ne. ");
INSERT INTO bex_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Römöyï gɔ bi ame kulu kpa wa ꞌdeni teyi ne na dökïꞌdï yï ti köꞌbö ŋburu gɔmo.” ");
INSERT INTO bex_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kömöyï na rɔ lamba ꞌba röyï. Ɔdɔ kömöyï këdï rekereke, yida röyï pili ti këdï ŋgï mï bi kɔpɔ ma löbu. ");
INSERT INTO bex_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne ɔdɔ kömöyï kele dë, yida röyï pili ti këdï ŋgï mï bi kölu. Tine ɔdɔ dökïꞌdï ame rɔ bi kɔpɔ ꞌba rɔ dïdï yï ne na këdï ꞌdeni za rɔ bi kölu ti këdï ŋgï zïyï rɔ mandölu ma kinza kiya.” ");
INSERT INTO bex_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Bilaka kɔtɔ ikali dë ꞌdɔ këdï rɔ bɔ laja zi ŋere rïyö. Bo ti kɔꞌɔ ŋge rɔ ma kɔtɔ tine bo ti koꞌji mɔtɔ. Bo ti kodɔ mï bo zi mɔtɔ tine rɔ yögö zi ma kɔtɔ. Kina gbï tara, inza kɔꞌbɔ toja laja zi Bɔkoꞌba gbï zi a ꞌba dɔliŋɔ nime. ");
INSERT INTO bex_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Gɔ köꞌdu mo na me mëdï miya ziye, kinza kolomake dë ti kɔmɔ kïlëꞌdï gɔ köꞌdu ꞌba akonyo ni ti akuwë ame rɔ a ꞌba tulu yida rɔye timo ne. Kina gbï kinza kolomake dë ti kɔmɔ kïlëꞌdï gɔ köꞌdu ꞌba bɔŋgɔ tusu mo rɔye. Ma komerike ꞌbeye, dïdï na dë kebe akonyo? Kina gbï yida rɔ na dë kebe bɔŋgɔ? ");
INSERT INTO bex_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oŋgɔke yali ni te, lïjë orɔꞌdɔ ɔtɔ dë gbï, kina lïjë umu ɔtɔ dë gbï kiꞌdi mï mata. Tine pele tara ꞌbu ye ame mïtɔrɔ ne na këdï kulu lïjë. Ma komerike, kpe na dë kulöwö mbiri rɔ dɔ kiteli di dɔ yali? ");
INSERT INTO bex_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Bɔtɔ mɔtɔ ikali dë ꞌdɔ tiyese gɔ loma abo kɔwɔ mbowa mï dɔyayi nime ti kɔmɔ kïlëꞌdï ꞌba gɔ wa. ");
INSERT INTO bex_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tine ëddï kolomake ti kɔmɔ kïlëꞌdï gɔ köꞌdu ꞌba bɔŋgɔ gɔ waꞌdi? Oŋgɔke döwöru ni te, lïjë oꞌdɔ ndɔbɔ dë gbï toma bɔŋgɔ rönnï. ");
INSERT INTO bex_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tine rɔ ma laka miya ziye, bɔ dɔliŋɔ Solomo pele ti wa mbëmbë abo naga nima usu bɔŋgɔ ma kele kebe döwöru ni dë. ");
INSERT INTO bex_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ne ɔdɔ Bɔkoꞌba na këdï kiyada mɔli ni ame këdï koꞌja tɔne bine, tine tïlëndö dayi kusu paꞌdo ꞌdeni yïmo kilaŋma yaga ne bo ti kola ye kinza tusu bɔŋgɔ rɔye? Kpe bɔ kinza kiꞌdike dɔye laka gɔ lende ꞌba Bɔkoꞌba naga nime. ");
INSERT INTO bex_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kina me miya ziye, kinza kolomake dë ti kɔmɔ kïlëꞌdï tiya mo te, ‘Ti monyo tɔne di yala?’ ala, ‘Ti muwë di yala? Kina gbï ti moꞌja bɔŋgɔ di yala?’ ");
INSERT INTO bex_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Wa naga nime na ya ma kinza kikali Bɔkoꞌba dë naga këdï kulö dönnï ŋburu gɔmo. ꞌBu ye Bɔkoꞌba ame mïtɔrɔ ne ikali ꞌdeni ma koꞌdɔkɔke wa naga nime pili. ");
INSERT INTO bex_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tine wa ma ꞌdɔ kulö döyï rɔ mbëmbë toma kɔri mo na rɔ ŋere löbu ꞌba Bɔkoꞌba nime gbï ti wa ma bo koꞌdɔkɔ di zïyï. Kina bo ti koja gɔ wa mɔtɔ naga nima ŋgï pili zïyï. ");
INSERT INTO bex_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kina gbï kinza kolomake dë ti kɔmɔ kïlëꞌdï gɔ wa ꞌba tïlëndö. Kɔmɔ kïlëꞌdï ma tïlëndö koloma ëꞌbënï gbï tötï koda bo yayi. Kinza koꞌdeke gomɔ ꞌba kada mɔtɔ dë korake dɔ a ma kada nima këdï koꞌde ne.” ");
INSERT INTO bex_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kinza koꞌdɔ burë ꞌba bɔtɔ mɔtɔ dë. Ɔdɔ koꞌdɔ ti koꞌdɔ burë ꞌbï gbï. ");
INSERT INTO bex_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Römöyï kɔri ame këddï koꞌdɔ burë ꞌba bilaka timo ne na gbï Bɔkoꞌba ti koꞌdɔ burë ꞌbï timo. Ndï lende ame këddï kodɔrɔ rɔ bilaka ne na ti kodɔrɔ ꞌbëyï gbï timo tara. ");
INSERT INTO bex_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne gɔ waꞌdi na kebe toŋgɔ pörï di kɔmɔ lëpï yï mɔtɔ konyɔ lende ꞌba kpa kulugbu ma löbu nima kömöyï ne dë? ");
INSERT INTO bex_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ti kiya rɔ ma tondo zi löndö nima, kiya te, ‘Iꞌdi miyagba pörï nima yaga di kömöyï,’ koꞌja këddï ꞌbëyï ti kpa kulugbu kömöyï? ");
INSERT INTO bex_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nï bɔ kɔmɔ kandi nime, iyagba kpa kulugbu nima titi dɔgba yaga di kömöyï ꞌdɔ koꞌja bi laka tiyagba pörï nima yaga di kɔmɔ löndö yï mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kina kinza kiꞌdi laja ma kɔtɔ laka dë zi bï, römöyï lïjë ti kileki kuyï kpënnï kirica mïyï yaga. Kinza kuꞌdu wa ma kele ꞌbï dë bërï kɔmɔ baꞌdo, lïjë ti kututu dɔmo ti ndïnnï kirasi yaga.” ");
INSERT INTO bex_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ititi kina ti kiꞌdi ŋgï zïyï. Oma kina ti koꞌja ŋgï. Ukökö kina ti kurögö kpadörï ŋgï zïyï. ");
INSERT INTO bex_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Römöyï lïjë ame ga pili kititi ne, iꞌdi ŋgï teyi. Kina lïjë ame ga pili koma ne, oꞌja ŋgï. Kina zi ame ga kukökö ne, urögö ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yë na ɔdɔ kole abo kïdëkï maŋgolɔꞌbɔ bo kënyï kogba za rɔ kulugbï döku kiꞌdi teyi? ");
INSERT INTO bex_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ala mɔtɔ ɔdɔ kole abo kïdëkï kenze bo kogba za rɔ murë kiꞌdi teyi? ");
INSERT INTO bex_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ne ɔdɔ kpe ame rɔ bɔ lende kënyë ne kikalike tiꞌdi wa ma laka zi kole ꞌbe ga tara, ꞌbu ye ame rɔ ma laka mïtɔrɔ ne ti kiꞌdi wa ma laka rɔ dɔ kiteli ŋgï zïnnï lïjë ame ga kititi di zi bo ne. ");
INSERT INTO bex_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wa ame ga koꞌdɔkɔ ꞌdɔ lëpï yï ga koꞌdɔ zïyï ne oꞌdɔ gbï zïnnï. Römöyï wa nime na köꞌdu kiꞌdi ni kpaki ti bɔ kumë lende ꞌba Bɔkoꞌba ni kɔrɔ dɔmo.” ");
INSERT INTO bex_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Arike tɔdɔ kebe kpadörï ma titiyi römöyï ma löbu nima ari mï gɔ bi ꞌba tölë dɔ kote. Kina kɔri mo gbï ŋgï rɔ ma kïtëwu. Ya ma këdï kari kebe gɔmo lïjë rɔ ma konzi. ");
INSERT INTO bex_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tine kpadörï ma këdï kari mï gɔ bi ꞌba dïdï ma ŋburuŋburu ŋge titiyi, kina kɔri mo gbï rɔ gomɔ. Ya ma koꞌja mo ga ŋge mbowa.” ");
INSERT INTO bex_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Iꞌdike kɔmɔye kandi laka di zi bɔ kumë lende ma dɔ kïndëndë naga nima. Römöyï lïjë ëdï kako ziye kɔzɔ kamölö di rönnï ma yaga, tine di mïnnï lïjë rɔ kuruku wölïwölï ma kënyë. ");
INSERT INTO bex_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ti kikalike lïjë di mï wa ma lïjë këdï koꞌdɔ. Römöyï kono ana maa dë, kina ŋgɔpɔliŋga ana këlu dë gbï. ");
INSERT INTO bex_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kina gbï tara, ŋgërï ma laꞌja ana ꞌbënï gbï rɔ döŋgërï ma laka. Kina ŋgërï ame rɔ götö ne ana ꞌbënï gbï rɔ döŋgërï ma kënyë. ");
INSERT INTO bex_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ŋgërï ma laꞌja ikali dë tana döŋgërï ma kënyë, kina ŋgërï ma götö ikali dë tana döŋgërï ma laka. ");
INSERT INTO bex_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ŋgërï ame ga pili kana döŋgërï ma laka ɔtɔ dë ne ti koga yaga kuꞌdu mï paꞌdo. ");
INSERT INTO bex_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kina me ꞌdɔ kikalike bɔ kumë lende ma dɔ kïndëndë naga nima di mï wa ma lïjë këdï koꞌdɔ.” ");
INSERT INTO bex_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bilaka ame ga köꞌbö toꞌdɔ kpa koŋmi tïdëkï ma rɔ ŋere ŋere ne inza kömö kɔtɔ te mï ŋere löbu ꞌba Bɔkoꞌba. Tine ya ame ga ŋge këdï koꞌdɔ wa ame ꞌbu ma, ma mïtɔrɔ nime koꞌdɔkɔ ne na ŋge ti kömö yïmo. ");
INSERT INTO bex_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mï kada ꞌba burë nima bilaka ma konzi ti kiya ꞌdeni zö te, ‘Ŋere, ŋere, ze na dë tönë doloma tiya laja ꞌba Bɔkoꞌba ti möyï yï ne ya? Kina ti möyï yï na dë gbï tönë doloma tiꞌdi nökï ma konzi kitaꞌba yaga di dɔ bilaka, kina doloma gbï toꞌdɔ gɔ kotɔ ma löbu naga ya?’ ");
INSERT INTO bex_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tine ti mileki miya zïnnï, miya te, ‘Mikali ye dë kɔtɔ te, arike yaga di rɔma, kpe bɔ koꞌdɔ lende kënyë naga nime.’” ");
INSERT INTO bex_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kina me ꞌdeni, bɔ ame kuwö lende ma nime kina koꞌdɔ ŋgï tara ti këdï kɔzɔ bɔ ma kandi ame koꞌba rö abo dɔ döku ne. ");
INSERT INTO bex_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ame tɔrɔ kaꞌdi mini koso, kina lili pïwu kome kïkëtï rönï yɔki rö nima, tine ulöru dë römöyï isaki toꞌba gbɔndɔ mo ꞌdeni di dɔ döku. ");
INSERT INTO bex_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ne bɔ ame kuwö lende ma nime tine koꞌdɔ dë tara ne ëdï kɔzɔ bɔ rumö ame koꞌba rö abo dɔ yayi lida ne. ");
INSERT INTO bex_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ame tɔrɔ kaꞌdi mini koso, kina lili pïwu kome kïkëtï rönï yɔki rö nima yɔ na kurö ŋgï. Tine tulöru mo ti këdï ŋgï rɔ ma kënyë rɔ dɔ kiteli.” ");
INSERT INTO bex_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kina ɔdɔ Yësu kote tiya lende naga nime ꞌdeni tine tïndï naga nima otɔ ŋgï rɔ gönnï rɔ mbëmbë gɔ köꞌdu ꞌba akiyandi abo. ");
INSERT INTO bex_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Römöyï bo iyandi wa ꞌdeni ŋgï kɔzɔ bɔ közï kakpa, tine inza kɔzɔ ꞌba bɔ kɔmɔ kiyandi ni tara. ");
INSERT INTO bex_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kina ɔdɔ Yësu këkï ꞌdeni bërï di dɔ döku tine tïndï ma konzi ösö ŋgï gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kina bɔ mɔtɔ ame roma kilaꞌba ꞌdeni rɔmo ne kako ŋgï kolɔdɔ bërï kɔmɔ Yësu, kiya te, “Ŋere, ɔdɔ koꞌdɔkɔ ŋgï ti kileŋo ma ŋgï yaga rɔ ma kɔpɔ.” ");
INSERT INTO bex_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kina Yësu koja közï bo kosa rɔ bɔ nima, kiya te, “Moꞌdɔkɔ ꞌdeni ŋgï, ileŋo yi ꞌdeni.” Kina rɔkɔꞌɔ tönë kola bɔ nima ŋgï welo. ");
INSERT INTO bex_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kina Yësu kose zi bo, iya te, “Uwö te, kinza kari kiya lende nime dë zi bɔtɔ mɔtɔ, tine ari zi bɔ akumu ꞌdɔ bo kinyeli röyï. Kina ꞌdɔ kiꞌdi kpa közï ꞌba akileŋo kɔzɔ ame Musa kiꞌdi köꞌdu mo mɔlo ne tara. Ame ꞌdɔ kileme zi bilaka pili ileŋo yi ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kina ɔdɔ Yësu kɔdɔ ꞌdeni mï Kaparanoma bɔ dɔ bɔ kanya mɔtɔ ꞌba Romo ako zi bo komaꞌjo rɔ bo zi Yësu, ");
INSERT INTO bex_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kiya te, “Ŋere, bɔ laja ma ëdï rɔ rɔkɔꞌɔ dɔ sora liŋɔ ma ꞌdë yayi. Ëdï ŋgï kilisa sowa, uyï rönï dë gbï.” ");
INSERT INTO bex_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yësu iya te, “Ti mari tileŋo bo.” ");
INSERT INTO bex_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tine bɔ dɔ bɔ kanya nime ileki dɔmo, iya te, “Ŋere, mɔꞌbɔ dë ꞌdɔ tiꞌdi yi kako mï gɔ bi ꞌba loma ma. Tine iya ŋge ti kpëyï kina ti kileŋo bɔ laja ma nima ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Römöyï mikali közï kakpa ꞌbï ëdï gbï kɔzɔ ꞌbama ame mëdï bïcï közï kakpa ti bɔ kanya ŋbaŋi kpa bïcö ne. Ɔdɔ milende zi mɔtɔ, miya te, ‘Ari,’ kina kari ŋgï. Ɔdɔ milende zi mɔtɔ, miya te, ‘Ako,’ kina kako ŋgï. Kina gbï ɔdɔ milende zi bɔ laja ma, miya te, ‘Oꞌdɔ wa nime,’ kina koꞌdɔ ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kina ɔdɔ Yësu kuwö lende ꞌba bɔ nime ꞌdeni te tine, lende mo igayi bo ŋgï. Kina bo kiya zi bɔ kösö gɔ bo ga, iya te, “Rɔ ma laka miya ziye, moꞌja bɔtɔ dë di mï bilaka ꞌba Yisarele ame kiꞌdi dönï gɔ lende ma kɔzɔ bɔ nime te. ");
INSERT INTO bex_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rɔ ma laka mëdï miya ziye, ma konzi ti kako di mï dɔyayi ma kapa yïbï ti dɔ tɔrɔ kodɔꞌbɔ rönnï ti Abarayama ni ti Yisika ti Yakoba mï lɔŋɔ ꞌba ŋbele ꞌba ŋere löbu ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tine ya ame ga mɔlo rɔ kole ꞌba mï ŋere löbu nima ne ti kuꞌdu ꞌdeni ŋbö yaga mï gɔ bi kölu ame rɔ bi ꞌba monɔ ni ti kpa kunyï.” ");
INSERT INTO bex_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kina Yësu kileki kiya zi bɔ dɔ bɔ kanya tönë, iya te, “Ari liŋɔ, wa ame komeri ꞌdeni mïyï gɔ tigɔ ma ne ti koꞌdɔ rönï ꞌdeni ŋgï tara zïyï.” Kina kileŋo bɔ laja ꞌba bɔ dɔ bɔ kanya tönë ŋgï mï saa nima. ");
INSERT INTO bex_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kina ɔdɔ Yësu kari ꞌdeni kɔdɔ rö ꞌba Pïtörö tine bo ari koꞌja mese ꞌba Pïtörö këdï köꞌdö dɔ sora yayi ti zëyï. ");
INSERT INTO bex_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kina bo kosa közïmo yɔ na zëyï nima kola ŋgï, na lɔko kënyï ŋgï kari toja laja zi bo. ");
INSERT INTO bex_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mï dɔkɔpiyari tine na koꞌde ya ma konzi ame ga këdï ti nökï ne ŋgï kako zi bo. Kina bo kamo ŋgï dɔ nökï ni kitaꞌba yaga di dɔmo. Kina bo kileŋo ya ame ga pili rɔ rɔkɔꞌɔ ne ŋgï gbï. ");
INSERT INTO bex_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bo oꞌdɔ wa nime ꞌdeni ꞌdɔ këdï kɔzɔ ma tönë Yesaya bɔ kumë lende ꞌba Bɔkoꞌba kiya ne. Ame kiya te, “Bo gbagba bo na kombi rɔkɔꞌɔ ze ga ꞌdeni kpaki yaga.” ");
INSERT INTO bex_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kina ɔdɔ Yësu koŋgɔ tïndï ꞌdeni këdï kuru bo bërï tara tine na bo kilende ŋgï zi bɔ kösö gɔ bo ga ꞌdɔ kumu kari gönyï pöpö ma kapa mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kina bɔ kɔmɔ kiyandi mɔtɔ ꞌba köꞌdu kiꞌdi kako ŋgï zi bo, kiya te, “Bɔ kɔmɔ kiyandi, ti mösö ŋgï nduwë göyï ŋbö bi tɔ ame këddï kari pele teyi.” ");
INSERT INTO bex_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yësu ileki dɔmo, iya te, “Kiraba ni pele ëdï ti gö ꞌbënnï ga, kina yali ni gbï ëdï ti rö ꞌbënnï ga. Tine kole ꞌba bilaka lesi inza ꞌba bo ti bi mɔtɔ ame gɔ bo koꞌba dɔ bo teyi tindawo rɔ bo.” ");
INSERT INTO bex_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bɔ mɔtɔ ame rɔ bɔ kösö gɔ bo ne ako kiya te, “Löbu ma, iꞌdi mileki titi tusu ꞌbu ma.” ");
INSERT INTO bex_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yësu iya te, “Ösö gɔma, ola töku ni kusu töku lëpï nnï ga.” ");
INSERT INTO bex_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kina Yësu ni këkï ŋgï mï sorope ti bɔ kösö gɔ bo ga tari rɔ dɔ mini. ");
INSERT INTO bex_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mbowa yɔ na pïwu kiꞌdi ŋgï tome kebe dɔ pöpö yayi. Lili pïwu nima iꞌdi ŋgï toŋbeŋbe sorope koꞌdɔ ꞌdɔ könzu bërï. Tine Yësu ëdï bi töꞌdö. ");
INSERT INTO bex_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kina lïjë kari ŋgï kindiŋi bo, kiya te, “Ŋere, okɔnyi ze, dëdï ꞌdeni dölë.” ");
INSERT INTO bex_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tine bo iya te, “Ëddï kereke gɔ waꞌdi? Kpe bɔ kinza kiꞌdike dɔye laka gɔ lende ma naga nime.” Kina bo kënyï tɔrɔ kamo dɔ lili ni ti mini kikagba nima ꞌdɔ kɔrɔ. Kina kɔrɔ ŋgï liwo. ");
INSERT INTO bex_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kina lïjë pili kotɔ ŋgï rɔ gönnï, iya te, “Bɔ nime, bo waꞌdi ga na? Lili ni ti mini löbu ni kpaki rɔ wa kuwö dɔ bo.” ");
INSERT INTO bex_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kina ɔdɔ Yësu kömö ꞌdeni kapa pöpö mɔtɔ mï dɔyayi ꞌba Gadara tine na ya mɔtɔ ga rïyö rɔ bɔ nökï kondɔsɔ ŋgï ti bo di yayi. Ya rïyö naga nima ëdï kako di kpa tïꞌbörö ꞌba tusu töku. Ya naga nima nökï ilaꞌba ꞌdeni dɔmo koworo ŋgï rɔ ma kënyë. Gɔ köꞌdu mo na bɔtɔ ilaŋa rönï dë kpe tudö kebe yayi. ");
INSERT INTO bex_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kina lïjë kulörï ŋgï rɔ ma kembe, iya te, “Nï kole ꞌba Bɔkoꞌba nime, waꞌdi na koꞌdɔkɔ di zize? Ako ꞌdeni tote dɔze tötï gba kinza kada mo kömö?” ");
INSERT INTO bex_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tïndï ꞌba baꞌdo ꞌba liŋɔ ëdï tonyo kpënnï ŋɔli yayi, ");
INSERT INTO bex_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kina nökï naga nima komaꞌjo rönnï ŋgï zi Yësu, iya te, “Ɔdɔ këddï koga ze yaga oja ze dari mï baꞌdo naga nime ꞌdë.” ");
INSERT INTO bex_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kina bo kiya zïnnï, iya te, “Arike.” Kina ɔdɔ lïjë kari kilaꞌba ŋgï dɔ baꞌdo tönë ga yɔ, kina baꞌdo naga nima kënyï ŋgï pili kiriŋa kari bi kuluŋï ꞌba pöpö kilaꞌba mï mini kote dönnï pili yaga. ");
INSERT INTO bex_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bɔ koda baꞌdo naga nima iriŋa kari kiya köꞌdu mo mï gawo. Kina lïjë kïyëtï gɔ wa ma koꞌdɔ rönï nima gbï pili ti lende ꞌba bɔ nökï tönë ga. ");
INSERT INTO bex_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kina bilaka ꞌba mï gawo nima kɔlɔ ŋgï pili kako toŋgɔ Yësu. Kina ɔdɔ lïjë koꞌja bo ꞌdeni tine lïjë ititi bo ꞌdɔ bo kënyï kari yaga di mï dɔyayi ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kina Yësu këkï ŋgï mï sorope kumu dɔ pöpö kileki kari mï gawo ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Di yayi na ya mɔtɔ ga koꞌde bɔ mɔtɔ ame keŋme ꞌdeni bërï ne ŋgï kako zi bo. Bɔ nima rɔ ma köꞌdö dɔ sora. Kina ɔdɔ Yësu koŋgɔ ꞌdeni lïjë kikali ŋgï bo ëdï ti tigɔ tileŋo bɔ nima tine, bo ilende zi bɔ nima, iya te, “Kole ma, ogbɔ dökïꞌdï yï, ola yi ꞌdeni gɔ lende kënyë ꞌbï ga.” ");
INSERT INTO bex_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kina bɔ kɔmɔ kiyandi mɔtɔ ga ame këdï yayi ne kënyï ŋgï tomeri mo ti mïnnï, iya te, “Bɔ nime ëdï kudölï Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tine Yësu ikali meri ꞌbënnï nima ŋgï na bo kiya te, “Ëddï komerike lende ma kënyë ma tara ga mïye gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma yala na kïtëwu ꞌdɔ tiya mo? ‘Ola yi ꞌdeni gɔ lende kënyë ꞌbï,’ ala ꞌdɔ kiya te, ‘Ënyï kiliŋgere’? ");
INSERT INTO bex_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ne ziye tikali mo rɔ ma laka kole ꞌba bilaka lesi ëdï ti tigɔ dɔliŋɔ bine tola bilaka gɔ lende kënyë.” Kina bo kiya zi bɔ keŋme bërï nima, iya te, “Ënyï tɔrɔ kombi sora ꞌbï kari liŋɔ.” ");
INSERT INTO bex_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kina bɔ tönë kënyï ŋgï tɔrɔ kari liŋɔ. ");
INSERT INTO bex_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tine ɔdɔ tïndï koꞌja bɔ nima ꞌdeni tara tine lïjë ŋgï rɔ tikere. Na lïjë kebe ŋgï tïlëlu Bɔkoꞌba gɔ tiꞌdi közï kakpa ma kɔzɔ a nima tara zi bilaka lesi. ");
INSERT INTO bex_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kina ɔdɔ Yësu kiteli ꞌdeni di yayi na bo kari koꞌja Matayo bɔ kireke awada koloma ꞌdeni mï gɔ bi ꞌba tireke awada. Kina Yësu kiya zi Matayo, iya te, “Ösö gɔma.” Kina Matayo kënyï ŋgï kösö gɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tine ɔdɔ Yësu ni ti bɔ kösö gɔ bo ga koloma ꞌdeni tonyo akonyo di liŋɔ ꞌba Matayo yayi na bɔ kireke awada ma konzi ti bɔ lende kënyë mɔtɔ ga kotɔtɔ rönnï ŋgï yayi kodɔꞌbɔ rönnï ti Yësu ni. ");
INSERT INTO bex_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kina ɔdɔ Parosi mɔtɔ ga koꞌja ꞌdeni tara tine lïjë ititi bɔ kösö gɔ Yësu ga, iya te, “Bɔ kɔmɔ kiyandi ꞌbe nima ëdï konyo wa bi kɔtɔ ti bilaka ma tara ga gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tine ɔdɔ Yësu kuwö lende ꞌbënnï nima ꞌdeni tara, bo iya te, “Bɔ rɔkɔꞌɔ na ŋge kari zi bɔ kiꞌdi wɔwɔ. Ya ma kinza ti rɔkɔꞌɔ naga ari ëꞌbënnï dë. ");
INSERT INTO bex_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ari koŋgɔke ꞌjɔ ꞌba lende nime kugu mï buku ꞌba Bɔkoꞌba kiya te, ‘Mï këyï na moꞌdɔkɔ di zi bilaka, tine inza rɔ akumu.’ Kina me ma mako dë tïdëkï bɔ lende laka, mako gɔ bɔ lende kënyë.” ");
INSERT INTO bex_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bɔ kösö gɔ Yowani bɔ bapatisi ga ako zi Yësu kititi, kiya te, “Ze ꞌbeze ti Parosi ni dëdï doro kpeze nduwë, ne gɔ waꞌdi na bɔ kösö göyï ga koro ꞌbënnï kpënnï dë?” ");
INSERT INTO bex_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yësu iya te, “Ma komerike ꞌbeye, ŋba ꞌba mï gbe ti koloma rɔ meri koꞌja mëꞌdë ꞌba nyiti këdï gba tïnnï? Tine inza tara, kada mo ti kömö ꞌdeni ame ꞌdɔ kogba mëꞌdë ꞌba nyiti yaga di mï löŋgö lïjë. Kina lïjë ti koro kpënnï ꞌjaa mï kada mo nima. ");
INSERT INTO bex_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kina gbï bɔtɔ mɔtɔ uru bɔŋgɔ ma laꞌja dë yɔki bɔŋgɔ ma mɔlo. Römöyï bɔŋgɔ ma laꞌja ti kosoŋi rönï ŋgï kirica ma mɔlo nima koꞌdɔ bi gböŋö ma löbu. ");
INSERT INTO bex_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kina bɔtɔ mɔtɔ odɔ layi ma laꞌja dë gbï mï kilaka ma mɔlo ꞌba layi. Römöyï kilaka ti kotopa ŋgï yaga layi nima kolɔdɔ mökö. Kina kilaka mo këdï kirasi rönï ŋgï. Tine layi ma laꞌja ëdï kodɔ gbï mï kilaka ma laꞌja kina ꞌdɔ lïjë pili koloma laka.” ");
INSERT INTO bex_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Koꞌja Yësu këdï gba rɔ tiya lende nime na bɔ mɔtɔ rɔ turu ꞌba Yudayi kako ŋgï zi bo kilaꞌba bërï kɔmɔ bo kïlëlu bo, iya te, “Nyiti ma ölë ꞌdeni gïrï nime tine ako kiꞌdi közïyï rönï na lɔko ti kïdïdï ŋgï ꞌböwu.” ");
INSERT INTO bex_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kina Yësu ni kënyï ŋgï ti bɔ kösö gɔ bo ga kari ti bɔ nima. ");
INSERT INTO bex_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kina ꞌja mɔtɔ ame roma köꞌbö tolɔdɔ ŋgï di rɔmo kɔmɔ kɔɔ mo ꞌdeni ŋbö ꞌbutë dɔmorïyö ne kako ŋgï kosa kpa bɔŋgɔ ꞌba rɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Römöyï lɔko omeri kiya ti mïnï te, “Ɔdɔ mosa pele ŋge rɔ kpa bɔŋgɔ ꞌba rɔ bo, ti kileŋo ma ŋgï kɔpɔ.” ");
INSERT INTO bex_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kina Yësu kuyï kɔmɔ bo koꞌja ꞌja nima. Na bo kiya te, “Nyiti ma, ogbɔ dökïꞌdï yï. Tiꞌdi döyï gɔ tigɔ ma na kileŋo yi ꞌdeni.” Kina kileŋo ꞌja nima ŋgï mï saa nima. ");
INSERT INTO bex_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kina ɔdɔ Yësu kari kömö mï liŋɔ ꞌba turu tönë, bo ari koꞌja bɔ kome more ni ti tïndï ma këdï kome kuwu ni ti bɔ tonyo kökö ni pili yayi. ");
INSERT INTO bex_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kina bo kiya zïnnï, iya te, “Kpe nima pili ɔdɔke yaga, nyiti titi nime ölë dë rɔ tölë tine lɔko ëdï bi töꞌdö.” Tine lïjë ögö bo ŋgï rɔ laŋa. ");
INSERT INTO bex_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kina ɔdɔ koga tïndï naga nima ꞌdeni yaga tine, na Yësu kɔdɔ ŋgï rö gɔ töku nima kindaꞌba közïmo. Kina lɔko kënyï ŋgï tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kina lëbï ꞌba lende nime kïyëlë rönï ŋgï kote mï dɔliŋɔ nima toko. ");
INSERT INTO bex_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kina ɔdɔ Yësu kënyï ꞌdeni di yayi na bɔ kɔmɔ kölu ma rïyö mɔtɔ ga kösö ŋgï gɔ bo ti tulörï kiya te, “Kole ꞌba Dawidi bɔ dɔliŋɔ, iꞌdi mïyï kpe këyï rɔze.” ");
INSERT INTO bex_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kina ɔdɔ bo kari kɔdɔ ꞌdeni rö tine na bɔ kɔmɔ kölu tönë ga kako ŋgï zi bo. Kina bo kititi lïjë, bo iya te, “Ikalike ŋgï rɔ ma laka ti mɔꞌbɔ tileŋo ye?” Lïjë iya te, “Yëë, ŋere.” ");
INSERT INTO bex_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kina bo kosa kömönnï, bo kiya te, “Koꞌdɔ rönï ziye kɔzɔ ame kiꞌdike dɔye ꞌdeni gɔmo ne tara.” ");
INSERT INTO bex_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kina kömönnï kɔpɔ ŋgï yaga. Tine Yësu ose gɔmo kitigɔ zïnnï, iya te, “Kinza kari kiyake lende nime dë zi bɔtɔ mɔtɔ.” ");
INSERT INTO bex_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tine lïjë ari kïyëlë lëbï ꞌba Yësu ŋgï kote mï dɔliŋɔ nima toko. ");
INSERT INTO bex_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Koꞌja ya tönë ga këdï kënyï ꞌdeni tari tine na ya mɔtɔ ga koꞌde bɔ nökï mɔtɔ ame kpamo kudödu rönï ꞌdeni teyi ne ŋgï kako zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tine ɔdɔ koga nökï nima ꞌdeni yaga yɔ na bɔ tönë kiꞌdi tilende ŋgï. Kina köꞌdu mo kigayi tïndï naga nima ŋgï pili. Lïjë iya te, “Doꞌja a ma te dë mɔlo mï dɔyayi ꞌba Yisarele.” ");
INSERT INTO bex_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tine Parosi ni iya te, “Ŋere ꞌba nökï na kiꞌdi közï kakpa nima zi bo toga nökï timo.” ");
INSERT INTO bex_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yësu ënyï kiliŋgere pili toko kote mï gawo ti dɔliŋɔ ma titi naga tiyandi kɔmɔ bilaka mï rö ꞌba mötu, kina gbï tuwöwö laja laka ꞌba ŋere löbu ꞌba Bɔkoꞌba. Bo ileŋo ya ma këdï ti dɔkomali rɔkɔꞌɔ ma konzi naga ꞌdeni pili. ");
INSERT INTO bex_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kina ɔdɔ bo koꞌja tïndï ꞌdeni tine meri ꞌba lisa ꞌbënnï ma bo koŋgɔ oso ŋgï lɔ dökïꞌdï bo. Römöyï ïlïkö dönnï ꞌdeni ŋgï kinza bɔ kokɔkɔ lïjë kɔzɔ kamölö ame bɔ koda mo kinza ne tara. ");
INSERT INTO bex_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kina bo kiya zi bɔ kösö gɔ bo ga, bo iya te, “Wa ꞌba kpa dɔlili nime ŋgï kpaya. Tine bɔ ndɔbɔ ꞌba rɔmo ga onzi dë. ");
INSERT INTO bex_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ititike bo ŋere bɔ dɔmo ꞌdɔ bo koja bɔ ndɔbɔ mï nyaka abo nime.” ");
INSERT INTO bex_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yësu ïdëkï bɔ kösö gɔ bo ga ma ꞌbutë dɔmorïyö naga nima bi kɔtɔ. Kina bo kiꞌdi közï kakpa zïnnï ꞌdɔ toga nökï kitaꞌba yaga timo di dɔ bilaka, kina gbï ꞌdɔ tileŋo rɔkɔꞌɔ ma konzi. ");
INSERT INTO bex_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bɔ laja ma ꞌbutë dɔmorïyö naga nime möyï mo ga na me. Ma dɔgba mo Simona ame kïdëkï möyï mo gbï rɔ Pïtörö ne, kina ti löndö bo Andareya ti Yakoba kole ꞌba Zebedayo ti löndö bo Yowani. ");
INSERT INTO bex_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pïlïpö ni ti Batolimayo ti Tɔma ti Matayo bɔ kireke awada ti Yakoba kole ꞌba Alapayo ti Tadayo ");
INSERT INTO bex_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ti Simona bɔ koꞌdɔ ya gɔ dɔyayi ꞌbënnï ti Yuda Isikarita ame kususu Yësu ne. ");
INSERT INTO bex_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yësu oja ya ꞌbutë dɔmorïyö naga nima kari ti ndose nime kiya te, “Kinza kɔdɔke dë mï dɔliŋɔ ꞌba bɔ löwö ma kinza rɔ Yudayi naga. Kina kinza kɔdɔke dë gbï mï gawo ꞌba Somorona ni. ");
INSERT INTO bex_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tine arike ŋge zi kamölö ꞌba Yisarele naga nime kölu ꞌdeni ne. ");
INSERT INTO bex_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kina ꞌdɔ kari kuwöwöke zïnnï, kiya te, ‘Ŋere löbu ꞌba Bɔkoꞌba ëdï ꞌdeni ŋgɔsi.’ ");
INSERT INTO bex_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kina ꞌdɔ kileŋoke bɔ rɔkɔꞌɔ kindiŋike töku ni. Ileŋoke bɔ mönyu ni, kina ꞌdɔ kogake nökï gbï kitaꞌba yaga di dɔ bilaka. Ogbake ꞌdeni di zö rɔ ma sari kinza topi ɔtɔ teyi, kina ꞌdɔ kari kiꞌdike gbï rɔ ma sari kinza topi ɔtɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kinza kogbake gïrïsï dë tiye. ");
INSERT INTO bex_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kina kinza kogbake mboꞌda ꞌba kpasi dë teyi. Kina kinza kogbake bɔŋgɔ mɔtɔ ala wari mɔtɔ ala përï adɔkotɔni mɔtɔ dë tiye. Römöyï bɔ ndɔbɔ pili ëdï ti bi gomɔ ꞌba rönnï. ");
INSERT INTO bex_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɔdɔ kömöke mï gawo ala liŋɔ mɔtɔ omake rɔ bilaka ame laka koꞌdɔkɔ tota ye rɔ ŋba ne. Kina ꞌdɔ kolomake liŋɔ abo ŋbö kënyïke di gɔ bi nima. ");
INSERT INTO bex_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tine ɔdɔ kömöke mï liŋɔ iyake te, ‘Lende këyï koloma tiye.’ ");
INSERT INTO bex_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ɔdɔ bilaka ꞌba liŋɔ mo nima kota ye rɔ ŋba olake lende këyï ꞌbe nima koloma tïnnï. Ne ɔdɔ lïjë kota ye dë ogbake eꞌbe yaga di zïnnï. ");
INSERT INTO bex_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kina ɔdɔ kömöke mï gawo ala liŋɔ mɔtɔ ga ame bilaka mo ga koga ye koꞌdɔkɔ dë tuwö lende ꞌbe ënyïke di teyi. Kina ꞌdɔ kombake lupu mo yaga di ndïye rɔ lömu rönnï. ");
INSERT INTO bex_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rɔ ma laka miya ziye mï kada ꞌba burë mï Bɔkoꞌba ti këyï rɔ mbëmbë rɔ bilaka ꞌba Sodomo ni ti Gomora di dɔ bilaka ꞌba gɔ bi mo tɔ nima.” ");
INSERT INTO bex_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Uwöke te, mëdï moja ye nime kɔzɔ kamölö tara mï löŋgö wölïwölï ma konzi. Tine iꞌdike kɔmɔye kandi kɔzɔ kɔmɔ murë kina gbï liya rɔ rumö kɔzɔ matukpuru. ");
INSERT INTO bex_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Oŋgɔke rɔye laka römöyï ya mɔtɔ ga ëdï ame lïjë ti kindaꞌba ye koto ye mï gɔ bi ꞌba burë. Kina lïjë ti komba ye gbï di mï rö ꞌba mötu ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ti kususu ye koꞌde ye kɔmɔ kïtï ꞌba bɔ dɔliŋɔ ni ti turu ma löbu naga gɔ lende ma kina ti kïyëtïke laja kɔtɔ laka ma nime zïnnï kina gbï zi bɔ löwö. ");
INSERT INTO bex_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tine ɔdɔ koꞌde ye mï gɔ bi ꞌba burë kinza kiꞌdike kɔmɔye kïlëꞌdï dë gɔ wa ma ꞌdɔ kiyake ala kïyëtïke zïnnï. Römöyï wa ame ga këddï kiyake ne Bɔkoꞌba ti kiꞌdi ŋgï ziye mï saa mo nima. ");
INSERT INTO bex_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Römöyï kpe na dë këddï kilendeke tine Nyï Kɔtɔ Laka ꞌba ꞌbu ye na këdï kiꞌdi lende ma këddï kiyake mo ga kpeye. ");
INSERT INTO bex_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mï kada mo nima bilaka ti kebe togba löndö lïjë ga kiꞌdi mï tölë. Kina ꞌbu ti koꞌdɔ gbï tara zi kole ꞌbënnï ga. Kina kole ti kebe gbï tuyï kpënnï dɔ ꞌbu nnï ga ti mönnï ga tiꞌdi mo mï tölë. ");
INSERT INTO bex_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Laki pili ti koꞌji ye gɔ köꞌdu ma. Ne bɔ ame kiꞌdi mï bo këddï teyi ŋbö kömö mï kada ꞌba tote mo ti kɔmɔ ŋgï di mï tölë. ");
INSERT INTO bex_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kina ɔdɔ lïjë këdï koꞌdɔ közï kasi ziye di mï gawo mɔtɔ olɔlɔke kiriŋake gbï karike mï gawo mɔtɔ. Römöyï rɔ ma laka miya ziye inza koteke mï gawo ꞌba Yisarele pili gba kota kinza kole ꞌba bilaka lesi kileki kako dɔliŋɔ nime. ");
INSERT INTO bex_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kina oŋgɔke, kole ꞌba sukulu inza mbiri di dɔ bɔ kɔmɔ kiyandi abo, kina bɔ laja inza gbï mbiri di dɔ bɔ ma rɔ bɔ dɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kina ꞌdɔ kole ꞌba sukulu këdï ti mï këyï tëdï kɔzɔ bɔ kɔmɔ kiyandi abo, kina ꞌdɔ bɔ laja gbï kɔzɔ bɔ ma rɔ bɔ dɔ bo nima. Kina me ɔdɔ kitiꞌja bɔ dɔliŋɔ ꞌdeni kïdëkï rɔ Belezebola, tine bilaka ꞌba liŋɔ abo ga ti kïdëkï ŋgï ti möyï ma kënyë rɔ dɔ kiteli.” ");
INSERT INTO bex_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kina kinza kereke bilaka dë. Wa ame ga pili rɔ ma kusu leꞌjete ne ti kiyagba ꞌdeni ŋgï yaga. Kina wa ame ga pili rɔ mulugu ne ti kumö yïmo ꞌdeni kikali yaga. ");
INSERT INTO bex_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wa ame ga mëdï miya liwo ziye ne ti kileki kiyake gɔmo ꞌdeni yaga bi kɔpɔ. Kina wa ame ga kuwöke liwo ne ti kuwöwöke ꞌdeni ŋgï di dɔ rö tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kina me kinza kereke ya ma këdï kupö ŋge rɔ yida rɔ kinza kupö dïdï naga nima dë. Tine Bɔkoꞌba ame këdï kote ꞌba bo dɔ yida rɔ ni kpaki ti dïdï mï paꞌdo ꞌba Gehena ne na ŋge ꞌdɔ kereke. ");
INSERT INTO bex_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ne oŋgɔke, ndögö ꞌba silɔ rïyö ŋge ti taripa kɔtɔ. Tine pele silɔ ma kɔtɔ mɔtɔ ölu dë lowo kinza ma ꞌbu ye kikali gɔmo. ");
INSERT INTO bex_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kina sunë ꞌba dɔye gbï bo ikali gɔmo me. ");
INSERT INTO bex_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kinza kereke dë. Kpe na rɔ dɔ kiteli zi bo kebe silɔ ma konzi.” ");
INSERT INTO bex_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Lïjë ame ga kiya yaga bi kɔpɔ, kiya te lïjë ꞌbama na ne, ti moꞌdɔ gbï tara zïnnï kɔmɔ ꞌbu ma ame mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ne lïjë ame ga kilagi ma yaga bi kɔpɔ ne ti milagi lïjë gbï tara kɔmɔ ꞌbu ma ame mïtɔrɔ ne.” ");
INSERT INTO bex_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kinza komerike dë te mako toꞌdɔ lende këyï mï dɔliŋɔ. Tine inza tara, mako dë toꞌde lende këyï mï dɔliŋɔ tine ya na moꞌde. ");
INSERT INTO bex_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mako tososo kpa kole tënyï rɔ ꞌdïrï ti ꞌbu nnï ga, kina yïtötï gbï ꞌdɔ kënyï rɔ ꞌdïrï ti mönnï ga. Kina ꞌja ꞌba kole ni ꞌdɔ kënyï rɔ ꞌdïrï ti mese lïjë ga. ");
INSERT INTO bex_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bɔ ya ma kënyë ꞌbëyï ꞌba bɔ mɔtɔ ti këdï aa rɔ bilaka ꞌba mï liŋɔ ꞌbï. ");
INSERT INTO bex_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kina me bilaka ame kɔꞌɔ ꞌbu bo ni ti ma bo rɔ dɔ kiteli di dɔma ne ɔꞌbɔ dë tëdï rɔ bɔ kösö gɔma. Kina gbï tara bɔ ame kɔꞌɔ kole abo ala nyiti abo rɔ dɔ kiteli di dɔma ne ɔꞌbɔ dë tëdï rɔ bɔ kösö gɔma. ");
INSERT INTO bex_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bɔ ame koꞌdɔkɔ dë tileŋo rɔ bo tölë gɔ lende ma ɔꞌbɔ dë tëdï rɔ bɔ kösö gɔma. ");
INSERT INTO bex_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bɔ ame koꞌdɔkɔ tɔmɔ dïdï bo ti kïyölu dɔmo ŋgï yaga. Tine bɔ ma kïyölu dɔ dïdï bo gɔ lende ma ti kɔmɔ ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Bɔ ame kota ye rɔ ŋba ota ma ꞌdeni gbï. Kina bɔ ame kota ma rɔ ŋba bo ota bɔ ame koja ma ne ꞌdeni gbï. ");
INSERT INTO bex_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bɔ ame kota bɔ laja ꞌba Bɔkoꞌba rɔ ŋba ne ti koꞌja kpa közïmo gbï kɔzɔ ꞌba bɔ laja nima. Kina gbï bɔ ame kota bɔ lende laka römöyï bɔ nima ëdï rɔ ma laka ne ti koꞌja kpa közï mo gbï kɔzɔ ꞌba bɔ lende laka. ");
INSERT INTO bex_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ti kikalike ꞌdeni ŋgï rɔ ma laka bɔtɔ ame kiꞌdi pele ŋge rɔ mini kuwë zi bɔ kösö gɔma ma titi ɔtɔ mɔtɔ römöyï bo bɔ kösö gɔma na ne ti koꞌja kpa közïmo ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kina ɔdɔ Yësu kote tose ndose naga nime ꞌdeni zi bɔ kösö gɔ bo ga tine, na bo kënyï ŋgï di yayi kari tiyandi kɔmɔ bilaka gbï ti tuwöwö laja laka abo mï dɔliŋɔ ma ŋgɔsiŋgɔsi yayi. ");
INSERT INTO bex_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ɔdɔ Yowani bɔ bapatisi kuwö wa ame ga Kurïsïtö këdï koꞌdɔ ne ꞌdeni tara di mï maboso yayi tine na bo koja bɔ laja abo ga ŋgï kari zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kina lïjë kititi Yësu, iya te, “Nï mo na rɔ bɔ ma tönë këdï kako di pötö ma ne? Ala ꞌdɔ doje kɔmɔze gba gɔ bɔ mɔtɔ?” ");
INSERT INTO bex_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yësu ileki dɔmo zïnnï, iya te, “Ilekike zi Yowani kïyëtïke wa ame ga kuwöke kina koꞌjake gbï ne zi bo kɔzɔ a nime te. ");
INSERT INTO bex_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iyɔpɔ kɔmɔ bɔ kɔmɔ kölu ni ꞌdeni. Kina bɔ kaꞌbo ni iliŋgere ꞌdeni. Ileŋo bɔ mönyu ni ꞌdeni yaga rɔ ma kɔpɔ. Bɔ mbili kuꞌbë ni uwö bi ꞌdeni. Töku ni indiŋi ꞌdeni kina laja laka uwöwö rönï ꞌdeni zi bɔ lisa ni. ");
INSERT INTO bex_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lïjë ame ga lende ma kïlïkö dë dönnï ne na ti yëyï.” ");
INSERT INTO bex_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Di pötö bɔ laja ꞌba Yowani ga kari ꞌdeni na Yësu koloma tiya lende ꞌba Yowani zi tïndï naga nima. Bo iya te, “Me karike yï mökö zi Yowani ne waꞌdi na karike toŋgɔ mo? Mbili mɔli ma këdï kudë dönï di zi lili? ");
INSERT INTO bex_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Waꞌdi na karike toŋgɔ mo? Bɔ kusu bɔŋgɔ kele? Tine bɔ kusu bɔŋgɔ kele ni ëdï koloma ꞌbënnï mï liŋɔ ꞌba bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ne arike toŋgɔ waꞌdi? Bɔ kumë lende ꞌba Bɔkoꞌba? Yëë, rɔ ma laka oꞌjake bɔ ame kebe bɔ kumë lende ꞌba Bɔkoꞌba pili ne ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Römöyï Yowani na tönë kugu lende mo mï buku ꞌba Bɔkoꞌba kiya te, ‘Bɔkoꞌba iya te, “Mëdï moja bɔ laja ma kari dɔgba kömöyï tileŋo kɔri zïyï.”’ ");
INSERT INTO bex_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rɔ ma laka miya ziye, kole köyö ꞌba ꞌja mɔtɔ inza mbiri di dɔ Yowani. Tine bɔ ame titiyi mï ŋere löbu ꞌba Bɔkoꞌba ne na mbiri di dɔ Yowani. ");
INSERT INTO bex_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Di mï kada ma Yowani kisaki tuwöwö lende ꞌba Bɔkoꞌba ŋbö kömö mï kada nime tɔne, ma konzi ëdï koꞌdɔ ꞌdeni ŋgï rɔ ya ꞌdɔ tɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba. Lïjë ëdï koꞌdɔkɔ ꞌdɔ tindaꞌba mo ꞌdeni ŋgï rɔ gbörökötö. ");
INSERT INTO bex_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kina mɔlo ŋbö kömö mï kada ꞌba Yowani bɔ kumë lende ꞌba Bɔkoꞌba ga pili ti köꞌdu kiꞌdi ꞌba Musa ileme lende ꞌba ŋere löbu ꞌba Bɔkoꞌba nime ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma këddï koꞌdɔkɔke ra ŋgï tiꞌdi dɔye gɔ lende ꞌbënnï, Yowani na rɔ Eliya bɔ kumë lende ame këdï kileki kako dɔgba ne. ");
INSERT INTO bex_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bɔ ame këdï ti mbili ne iꞌdike bo kuwö lende nime. ");
INSERT INTO bex_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ti miyari ye kpe bilaka ma leꞌjete naga nime ti waꞌdi? Kpe ŋgï kɔzɔ kole titi ame ga koloma mï gɔ bi ꞌba ndögö. Ame dɔtumu mɔtɔ kulörï zi mɔtɔ kiya te, ");
INSERT INTO bex_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Domba dɔkole mbili pele ziye, odoweke gɔye dë gbï yɔ. Kina me ducï lërï ꞌba tölë pele ziye, uduke dë gbï yɔ.’ ");
INSERT INTO bex_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Römöyï Yowani ako bine koro kpa bo, kuwë a ma kata naga dë, iyake te, ‘Yowani bɔ nökï na.’ ");
INSERT INTO bex_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kina me kole ꞌba bilaka lesi kako konyo kpa bo kuwë wa iyake te, ‘Oŋgɔke yayi, bo ŋgï rɔ bɔ kpa ŋböŋbö bɔ kuwë layi bɔ pɔri ꞌba bɔ kireke awada ni ti bɔ lende kënyë mɔtɔ ga.’ Ne tine akikali ꞌba Bɔkoꞌba ti kinda ꞌdeni yaga di mï ndɔbɔ mo.” ");
INSERT INTO bex_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bilaka ꞌba mï gawo naga nime Yësu koꞌdɔ gɔ kotɔ kulöwö yïmo ne otɔ dönnï dë du te. Kina bo kënyï tose kpa gawo naga nima, ");
INSERT INTO bex_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","kiya te, “Buꞌbu zïyï Korazina, kina buꞌbu gbï zïyï Betesayida. Römöyï ma kiya te këdï koꞌdɔ gɔ kotɔ naga nime koꞌdɔ mïyï ne ra mï Tura ni ti Sidona dëne, bilaka mo ga otɔ dönnï ꞌdeni mɔlo kolɔ bɔŋgɔ ꞌba monɔ rönnï, kosa buruku rönnï ꞌdɔ kileme ma lïjë kotɔ dönnï ꞌdeni di mï lende kënyë ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Rɔ ma laka miya ziye mï kada ꞌba burë kada mɔtɔ Bɔkoꞌba ti kiꞌdi mï bo këyï rɔ mbëmbë rɔ Tura ni ti Sidona di dɔye. ");
INSERT INTO bex_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne nï ꞌbëyï Kaparanoma oꞌdɔkɔ tombi röyï ꞌdeni ŋbö mïtɔrɔ? Ne ti kuꞌdu yi ꞌdeni ŋgï bërï mï paꞌdo ꞌba Gehena. Römöyï ma kiya te gɔ kotɔ naga nime koꞌdɔ mïyï ne na këdï koꞌdɔ ra mï Sodomo dëne Sodomo ëdï gba koꞌja kabate. ");
INSERT INTO bex_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kina ꞌdɔ kikali rɔ ma laka mï kada ꞌba burë Bɔkoꞌba ti kiꞌdi mï bo këyï rɔ mbëmbë rɔ Sodomo di döyï.” ");
INSERT INTO bex_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mï kada nima yayi Yësu iya te, “Mïlëlu yi ꞌbu ma, ŋere ꞌba dɔ mïtɔrɔ ni ti dɔyayi römöyï wa ame kusu dɔmo di zi bɔ akikali ni ne ileme ꞌdeni zi ma kinza kikali ɔtɔ dë naga. ");
INSERT INTO bex_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ꞌBu ma, rɔ ma laka wa nime na koꞌdɔkɔ ꞌdɔ koꞌdɔ rönï te.” ");
INSERT INTO bex_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kina bo kiya te zi bilaka naga nima, “ꞌBu ma iꞌdi wa pili ꞌdeni zö tine bɔtɔ ikali ma kole dë, ꞌbu ma na ŋge kikali. Kina bɔtɔ ikali ꞌbu ma dë gbï tine ma kole ma na ŋge mikali ti ya ame ga migeli ꞌdeni ꞌdɔ tileme bo teyi ne. ");
INSERT INTO bex_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kpe ame ga ꞌdeni pili rɔ gomɔ di zi akïrïndï ne akoke zö. Kina ti mɔmɔ ye ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ombike kpa kulugbu ma mugu ye ame rɔ akiyandi ma ne. Römöyï dökïꞌdï ma na liya rɔ rumö kinza dɔ kombi. Kina ti koꞌjake rɔ kindawo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Römöyï kpa kulugbu ma nime miꞌdi ziye ne embe dë kina tombi mo ŋgï kinza gomɔ.” ");
INSERT INTO bex_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mbowa di pötö mo mï kada ꞌba rɔ kindawo na Yësu ni këdï kiliŋgere kebe mï nyaka ꞌba nyönyu. Bɔ kösö gɔ bo ga ꞌdeni rɔ ꞌbö kina lïjë kiꞌdi ŋgï tomborozi dɔ nyönyu tonyo ꞌjɔ mo. ");
INSERT INTO bex_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kina ɔdɔ Parosi ni koꞌja ꞌdeni tara tine na lïjë kebe ŋgï tititi Yësu, iya te, “Oŋgɔ te, wa nima bɔ kösö göyï ga këdï koꞌdɔ ne lïjë ëdï rɔ tïyëyï mï köꞌdu kiꞌdi ꞌba kada ꞌba rɔ kindawo.” ");
INSERT INTO bex_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bo ileki zïnnï, iya te, “Ïdëkïke wa ma tönë Dawidi koꞌdɔ mï kada nima yayi ne dë? Ame lïjë rɔ ꞌbö ti bilaka abo ga ne. ");
INSERT INTO bex_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bo ari ŋgï mï rö löbu ꞌba Bɔkoꞌba kina lïjë ti bilaka abo ga konyo maŋgolɔꞌbɔ koro ame kiꞌdi zi Bɔkoꞌba ne ŋgï di yayi. Wa nima inza rɔ ma laka zïnnï mï köꞌdu kiꞌdi ꞌba Bɔkoꞌba ꞌdɔ tonyo mo. Tine bɔ akumu ni na ŋge ꞌdɔ konyo. ");
INSERT INTO bex_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kina ïdëkïke dë gbï di mï köꞌdu kiꞌdi ꞌba Musa? Ame kiya te mï kada ꞌba rɔ kindawo pili bɔ akumu ame mï rö löbu ꞌba Bɔkoꞌba ne ïyëyï köꞌdu kiꞌdi ꞌba kada ꞌba rɔ kindawo. Tine pele inza rɔ lende kënyë zïnnï. ");
INSERT INTO bex_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kina me mëdï miya ziye wa mɔtɔ ma kebe rö löbu ꞌba Bɔkoꞌba ëdï bine. ");
INSERT INTO bex_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ugu ꞌdeni mï buku ꞌba Bɔkoꞌba iya te, ‘Mï këyï na moꞌdɔkɔ di zi bilaka tine inza rɔ akumu.’ Ma këddï kikalike ꞌjɔ ꞌba lende nime ra, dëne inza kodɔke karama dɔ bilaka ame kirasi ɔtɔ dë ne. ");
INSERT INTO bex_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Römöyï kole ꞌba bilaka lesi na rɔ ŋere ꞌba dɔ kada ꞌba rɔ kindawo.” ");
INSERT INTO bex_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yësu ënyï ꞌdeni di yayi kari mï rö ꞌba mötu mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kina bo kari koꞌja bɔ mɔtɔ közïmo keŋme ꞌdeni rɔ kilawo ŋgï di yayi. Tine ya mɔtɔ ga ëdï yayi ame këdï koma kɔri ꞌba ꞌdɔ tususu Yësu gɔ tirasi wa mɔtɔ. Kina lïjë kititi bo, iya te, “Ëdï ŋgï rɔ ma laka mï köꞌdu kiꞌdi ze ꞌdɔ tileŋo bilaka tɔne mï kada ꞌba rɔ kindawo?” ");
INSERT INTO bex_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yësu ileki dɔmo zïnnï iya te, “Ɔdɔ kamölö ꞌbï ꞌba bɔ mɔtɔ kilaꞌba mï gö ma kalo mï kada ꞌba rɔ kindawo, ti kari dë kindaꞌba kotɔ yaga di mï gö mï kada ꞌba rɔ kindawo nima? ");
INSERT INTO bex_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tine bilaka lesi ni ma ti kamölö, yë na mbiri? Ɔdɔ këdï ꞌdeni tara köꞌdu kiꞌdi ze iꞌdi ze ꞌdeni tokɔnyi bilaka mï kada ꞌba rɔ kindawo.” ");
INSERT INTO bex_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kina bo kiya zi bɔ kɔnyɔ keŋme rɔ kilawo nima, bo iya te, “Oja gɔ közïyï.” Kina bɔ nima koja ŋgï na kileki ŋgï rɔ ma laka kɔzɔ ma kapa ama. ");
INSERT INTO bex_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tine Parosi ni ënyï ŋgï di yayi kari tususu kpënnï ꞌdɔ tupö Yësu. ");
INSERT INTO bex_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kina ɔdɔ Yësu kuwö ꞌdeni këdï kususu kpa rɔ bo tara tine na bo kënyï ŋgï kari abo yaga di yayi. Kina tïndï ma konzi kösö ŋgï gɔ bo. Tine bo ileŋo ya ame ga ti rɔkɔꞌɔ ne ŋgï pili. ");
INSERT INTO bex_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kina bo kose zïnnï kinza lïjë kïyëlë lende abo dë zi ya mɔtɔ ga. ");
INSERT INTO bex_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bo oꞌdɔ wa nime ꞌdeni ꞌdɔ këdï kɔzɔ wa ma tönë Yesaya bɔ kumë lende ꞌba Bɔkoꞌba kiya ne tara. ");
INSERT INTO bex_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ame kiya te, “Bo na rɔ bɔ laja ma ame moweli ꞌdeni ne. Bo na mɔꞌɔ ꞌdeni kulöwö kina ma gbï ti mï këyï rɔ mbëmbë gɔ köꞌdu abo. Ti miꞌdi Nyï Kɔtɔ Laka ma koloma dɔ bo kina bo ti kuwöwö burë ma mëdï moꞌdɔ dɔ, dɔ kupö pili. ");
INSERT INTO bex_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bo inza koꞌdɔ kowasa ala kulörï rɔ ma kembe. Bɔtɔ inza kuwö mugu bo këdï kulörï kebe gɔ kɔri. ");
INSERT INTO bex_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bo ti kiliya rɔ bo zi lïjë ame ga pili rɔ rumö ne, mï këyï abo ti këdï zi lïjë ame ga pili rɔ lisa ne. Bo ti köꞌbö toꞌdɔ mo ŋbö bo koꞌde akoꞌdɔkɔ kodɔrɔ ꞌba Bɔkoꞌba nime ndïmo këddï. ");
INSERT INTO bex_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kina bilaka pili ꞌba dɔliŋɔ nime ti kiꞌdi kömönnï ŋgï dɔ bo.” ");
INSERT INTO bex_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kina ya mɔtɔ ga koꞌde bɔ nökï kɔmɔ kölu mɔtɔ ame kpamo kudödu rönï ꞌdeni gbï teyi ne ŋgï zi Yësu. Kina Yësu kileŋo bɔ nima ŋgï kpamo kope rönï yaga tilende. Kina kɔmɔ mo kɔpɔ ŋgï gbï yaga. ");
INSERT INTO bex_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kina tïndï naga nima pili kotɔ ŋgï rɔ gönnï gɔ wa ame Yësu koꞌdɔ ne. Lïjë ititi rönnï rɔ gɔ rönnï, iya te, “Bɔ nima bo na ti këdï rɔ kupö Dawidi bɔ dɔliŋɔ mo tönë?” ");
INSERT INTO bex_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tine ɔdɔ Parosi ni kuwö ꞌdeni tara tine, lïjë iya te, “Bo oga nökï naga nima yaga römöyï ŋere ꞌbënnï Belezebola na kiꞌdi tigɔ mo zi bo toꞌdɔ mo.” ");
INSERT INTO bex_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yësu ikali wa nima lïjë këdï komeri ne ꞌdeni kina bo kiya te, “Dɔliŋɔ ame koza mïnï ꞌdeni rïyö toꞌdɔ ya rɔ gɔ rönnï ne igabi dë kpe ëdï kïyëyï rönï ŋgï. Kina gawo ala liŋɔ mɔtɔ ame koza mïnï ꞌdeni toꞌdɔ ya rɔ gɔ rönnï ne ëdï kitaꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kina me ɔdɔ Satani na ꞌdeni koga bɔ laja abo ga yaga di dɔ bilaka bo oza rɔ bo ꞌdeni toꞌdɔ ya ti gbagba bo kina lïjë këdï kitaꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ne ɔdɔ mëdï ꞌdeni moga nökï ti közï kakpa ꞌba Belezebola tine, lëpï ye naga nima ëdï koga ꞌbënnï ti waꞌdi? Ndɔbɔ ꞌbënnï nima na ti kodɔrɔ bïcï lende rɔye. ");
INSERT INTO bex_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tine ɔdɔ moga nökï ꞌdeni ti tigɔ ꞌba Nyï Kɔtɔ Laka ꞌba Bɔkoꞌba, rɔ ma laka ŋere löbu abo ako ꞌdeni mï dɔyayi. ");
INSERT INTO bex_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Oŋgɔke te, bɔ mɔtɔ ti kari kɔdɔ tondo mï rö ꞌba bɔ tigɔ mɔtɔ kolɔ wa mo ga? Rɔ ma laka ɔdɔ bo kudödu bɔ nima dë titi dɔgba bo inza kolɔ wa mo. ");
INSERT INTO bex_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Bɔ ame koꞌdɔkɔ ma dë ëdï rɔ ndoꞌji tö. Kina bɔ ame kotɔtɔ kpamo dë tö ëdï ꞌba bo tïyëyï yïmo. ");
INSERT INTO bex_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Gɔ köꞌdu nime na ꞌdɔ miya ziye, ti kola bilaka gɔ köꞌdu kënyë pili, kina gbï gɔ wa ma kënyë ame ga pili lïjë kiya ne. Tine bɔ ame kiya kpa kënyë rɔ Nyï Kɔtɔ Laka ne, inza kola du te gɔ lende kënyë nime. ");
INSERT INTO bex_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bɔ ame kiya kpa bo gɔ kole ꞌba bilaka lesi ne ti kola gɔ lende kënyë, tine bɔ ame kiya kpënï gɔ Nyï Kɔtɔ Laka ne inza kola pele gïrï nime ala mï kada ma ŋburuŋburu.” ");
INSERT INTO bex_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Oŋgɔke te, ŋgërï ma laꞌja ëdï kana ꞌbënï rɔ döŋgërï ma laka, kina ŋgërï ma götö ëdï kana ꞌbënï rɔ döŋgërï ma kënyë. Ëdï kikali ŋgërï gɔ kïnë ame bo këdï kana ne. ");
INSERT INTO bex_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kpe kole ꞌba murë naga nime, ti kɔꞌbɔke tiya wa ma laka tondo koꞌja këddïke rɔ wa kënyë? Römöyï kpa ëdï koja ꞌbënï wa ame koso ꞌdeni mï dökïꞌdï ne. ");
INSERT INTO bex_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bɔ lende laka ëdï koja gbï rɔ wa ma laka di mï mata ꞌba lende laka abo. Kina bɔ lende kënyë ëdï koja ꞌbënï gbï rɔ wa ma kënyë di mï mata ꞌba lende kënyë abo. ");
INSERT INTO bex_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Rɔ ma laka miya ziye, mï kada ꞌba burë ëdï kititi kpa bilaka pili ꞌdɔ kïyëtï gɔ lende yawa ame ga pili lïjë kiya ne. ");
INSERT INTO bex_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Lende ꞌbï ꞌba bɔ mɔtɔ na ti kileme yi di mï burë nima rɔ ma laka ala rɔ ma kënyë.” ");
INSERT INTO bex_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kina bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ti Parosi mɔtɔ ga kënyï kiya zi Yësu iya te, “Bɔ kɔmɔ kiyandi, doꞌdɔkɔ ꞌdɔ toŋgɔ lende ꞌba gɔ kotɔ ma këddï koꞌdɔ.” ");
INSERT INTO bex_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tine bo ileki dɔmo iya te, “Kpe bɔ titi ma leꞌjete nime kpe ŋgï rɔ ma kënyë, ereke Bɔkoꞌba dë. Gɔ waꞌdi na kiterike ꞌdɔ toꞌja gɔ kotɔ? Ne inza kileme du te ziye. Tine gɔ kotɔ ma ꞌdɔ kileme ziye na ŋge tönë rɔ ꞌba Yona bɔ kumë lende ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kɔzɔ ame Yona koꞌdɔ töꞌdö dɔ mota mï kenze löbu ne, ti kole ꞌba bilaka lesi koꞌdɔ töꞌdö gbï dɔ mota tara bïcï yayi bërï. ");
INSERT INTO bex_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mï kada ꞌba burë bilaka ꞌba Nïnëwë ti kënyï kɔrɔ kɔmɔ kïtï ꞌba burë tususu ye kpe bɔ titi ma leꞌjete naga nime. Römöyï mï kada ma Yona kuwöwö laja nima zïnnï lïjë otɔ dönnï ŋgï di mï lende kënyë ꞌbënnï ga. Kina me rɔ ma laka mëdï miya ziye wa mɔtɔ ëdï bine ame kebe Yona. ");
INSERT INTO bex_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mï kada ꞌba burë ꞌja bɔ dɔliŋɔ ꞌba Seba tönë ti kɔrɔ kɔmɔ kïtï ꞌba burë todɔrɔ bïcï lende rɔye kpe bɔ titi ma leꞌjete naga nime. Römöyï lɔko ako tönë ŋbö rɔ ma kɔwɔ di dɔliŋɔ ꞌbënï tuwö akikali mbëmbë ꞌba Solomo. Kina me rɔ ma laka mëdï miya ziye bɔ mɔtɔ ëdï bine ame kebe Solomo.” ");
INSERT INTO bex_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ɔdɔ nökï kitaꞌba ꞌdeni di dɔ bilaka ënyï kari mï gɔki toma bi ꞌba rɔ kindawo zi bo. Tine ɔdɔ bo koꞌja dë yɔ, ");
INSERT INTO bex_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","na bo kiya zi gbagba bo, iya te, ‘Ti mileki mari mï rö ma nime mënyï di yïmo ne.’ Bo ileki kari koꞌja mï rö tönë ꞌdeni rɔ ma sari kotowa yïmo ꞌdeni kɔpɔ kiyija wa mo ga pili rɔ ma laka. ");
INSERT INTO bex_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kina bo kileki ŋgï kari koꞌde nökï ma modɔmorïyö mɔtɔ ga ame kënyë ŋgï rɔ dɔ kiteli kebe bo ne. Kina lïjë kako koloma ŋgï yayi. Tine na kɔsɔ loma ꞌba bɔ nima këdï kënyë ŋgï rɔ dɔ kiteli kebe ma dɔgba. Wa nime na këdï koꞌdɔ rönï tara zi bilaka bɔ lende kënyë ma leꞌjete naga nime.” ");
INSERT INTO bex_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yësu ëdï gba kilende na ma bo ni ti löndö bo ga kömö ŋgï. Lïjë ɔrɔ yaga koja laja gɔ bo ꞌdɔ bo kako kilende tïnnï. ");
INSERT INTO bex_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kina bɔ mɔtɔ yayi kiya zi Yësu, iya te, “Oŋgɔ te, möyï ni ti löndö yï ga na me ꞌdë yaga lïjë oꞌdɔkɔ tilende tïyï.” ");
INSERT INTO bex_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yësu ileki dɔmo, iya te, “Yë na rɔ iya? Kina yë mo ga na rɔ löndö ma ga?” ");
INSERT INTO bex_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kina bo kileme bɔ kösö gɔ bo ga, na bo kiya te, “Iya ni ti löndö ma ga na rɔ ya naga nime. ");
INSERT INTO bex_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bɔ ame koꞌdɔ wa ame ꞌbu ma, ma mïtɔrɔ koꞌdɔkɔ ꞌdɔ bo koꞌdɔ ne na rɔ löndö ma ti lëmï ma ga gbï rɔ iya.” ");
INSERT INTO bex_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mï kada kɔtɔ mo nima na Yësu kënyï di liŋɔ kari kpa pöpö, bo koloma tiyandi bilaka di yayi. ");
INSERT INTO bex_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kina bilaka kotɔtɔ rönnï ŋgï zi bo yayi rɔ tïndï ma kinza kiya. Na bo kari këkï abo ŋgï koloma mï sorope dɔ mini. Tine na tïndï naga nima kɔrɔ ꞌbënnï ŋgï yaga dɔ kpa götö. ");
INSERT INTO bex_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kina bo koloma ŋgï tiya wa ma konzi zïnnï rɔ dɔŋgala. Bo iya te, “Bɔ mɔtɔ ɔdɔ ꞌdeni kari tulï kupö abo. ");
INSERT INTO bex_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kina ɔdɔ bo këdï koto ꞌdeni tulï mo tine kupö mɔtɔ ga ilaꞌba ŋgï dɔ kpa kɔri. Kina yali kako kogɔ ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mɔtɔ ga ilaꞌba ꞌbënnï dɔ kirigɔyɔ ame yayi mo kalo dë ne. Kina kötu ŋgï welo römöyï yayi mo alo dë. ");
INSERT INTO bex_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tine ɔdɔ kada keze mbowa yɔ na koŋma ŋgï kututu yaga römöyï ŋgiraꞌda mo alo dë. ");
INSERT INTO bex_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kupö mɔtɔ ga ilaꞌba ꞌbënnï bïcï kono. Kina ɔdɔ kono kïyöbu yɔ na kuböwu ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tine kupö mɔtɔ ga ilaꞌba ꞌbënnï mï yayi ma laka, kina kïyöbu ŋgï kana. Mɔtɔ ga ana ŋbaŋi, mɔtɔ ga ana laka, mɔtɔ ga ana mbowa. ");
INSERT INTO bex_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bɔ ame këdï ti mbili ne iꞌdike bo kuwö lende nime.” ");
INSERT INTO bex_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kina bɔ kösö gɔ bo ga kako zi bo kititi bo, iya te, “Ëddï kiya lende rɔ dɔŋgala zi bilaka naga nime gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bo ileki dɔmo zïnnï, iya te, “ꞌBeye Bɔkoꞌba iꞌdi akikali ꞌba ŋere löbu abo ame rɔ ma kusu ne ꞌdeni ziye. Tine ꞌbënnï iꞌdi dë zïnnï. ");
INSERT INTO bex_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Römöyï bɔ ame këdï pele timo Bɔkoꞌba ti kiꞌdi gbï dɔmo, ꞌdɔ bo këdï timo rɔ mbëmbë. Tine bɔ ame kinza timo ne ti kogba yaga di teyi. Ɔdɔ ma titi mɔtɔ këdï pele yayi ti kopepe yaga di zi bo. ");
INSERT INTO bex_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wa nime ꞌdɔ kiꞌdi ma mëdï milende zïnnï rɔ dɔŋgala ne, römöyï lende ꞌba Bɔkoꞌba nime lïjë oŋgɔ pele tine lïjë oꞌja dë, lïjë uwö pele tine lïjë uwö dë laka kina ɔdɔ dë gbï dönnï. ");
INSERT INTO bex_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ëdï ꞌdeni kɔzɔ lende tönë Yesaya kumë gɔ köꞌdu ꞌbënnï ne tara. Ame kiya te, ‘Bilaka naga nima ti kuwö ŋgï rɔ tuwö tine inza kɔdɔ du te dönnï. Lïjë ti koŋgɔ ŋgï rɔ toŋgɔ tine lïjë inza koꞌja du te. ");
INSERT INTO bex_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Römöyï kpa kɔri ꞌba döku dönnï ïdïrï ꞌdeni teyi. Mbili lïjë uꞌbë ꞌdeni, kina lïjë otomo kömönnï ꞌdeni gbï teyi. Ma kiya te kinza tara dëne lïjë ëdï koꞌja ti kömönnï kuwö gbï ti mbili nnï lende mo kɔdɔ dönnï gɔ lïjë kotɔ dönnï kako zö ꞌdɔ mileŋo lïjë.’ ");
INSERT INTO bex_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tine kpe ꞌbeye na laka römöyï kɔmɔye oꞌja ꞌdeni kina mbili ye uwö ꞌdeni gbï. ");
INSERT INTO bex_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rɔ ma laka miya ziye bɔ kumë lende ꞌba Bɔkoꞌba ti bɔ lende laka ma konzi oloma ꞌdeni ti kɔmɔ kiꞌdi ꞌdɔ toꞌja wa naga nime këddï koꞌjake ne, tine lïjë oꞌja dë du te. Kina lïjë oloma ꞌdeni gbï ti kɔmɔ kiꞌdi ꞌdɔ tuwö mo kɔzɔ ame këddï kuwöke ne, tine lïjë uwö dë du te. ");
INSERT INTO bex_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kina me ojeke mbili ye ti kuwöke ꞌjɔ ꞌba dɔŋgala ꞌba bɔ kulï kupö nime. ");
INSERT INTO bex_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bɔ ame kuwö lende ꞌba ŋere löbu ꞌba Bɔkoꞌba pele tine kɔdɔ dë dɔmo ne, bo na kɔzɔ kupö ame kilaꞌba dɔ kpa kɔri ne. Kina Satani kako ŋgï kolɔ lende nima yaga di mï dökïꞌdï bo. ");
INSERT INTO bex_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kupö ma kilaꞌba dɔ kirigɔyɔ na rɔ ya ame ga kindaꞌba lende ꞌba Bɔkoꞌba ŋgï ti mï këyï di bi tuwö mo. ");
INSERT INTO bex_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tine ŋgiraꞌda mo alo dë mïnnï. Kina kiꞌdi ŋgï kigabi dë. Kina ɔdɔ gomɔ ala közï kasi ma koꞌdɔ zïnnï gɔ laja nime kömö yɔ, na lïjë koga kpënnï ŋgï gɔmo. ");
INSERT INTO bex_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kina kupö ma kilaꞌba bïcï kono na rɔ ya ame ga kuwö laja laka nime pele tine kɔmɔ kïlëꞌdï ꞌba gɔ wa ꞌba dɔliŋɔ nime ti tɔꞌɔ mɔri koꞌdɔ uböwu ŋgï yaga di mïnnï. Kina kiꞌdi lïjë ŋgï kana ɔtɔ dë kpe. ");
INSERT INTO bex_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kupö ma kulï mï yayi ma laka na rɔ ya ame ga kuwö laja nime kiꞌdi kɔdɔ dönnï. Kina lïjë kana ŋgï mɔtɔ ga rɔ mbëmbë, mɔtɔ ga ana laka, mɔtɔ ga ana mbowa.” ");
INSERT INTO bex_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yësu iya dɔŋgala mɔtɔ zïnnï, iya te, “Ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ wa nime te. Bɔ mɔtɔ ari kulï kupö nyönyu ma laka mï nyaka abo. ");
INSERT INTO bex_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mï korɔndɔ ꞌdeni tine na bɔ ya kako ŋgï kulï ꞌjɔ beli mï löŋgö mo. Kina bo kari abo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kina ɔdɔ nyönyu kïyöbu ꞌdeni këdï köyö tine na beli kinda ŋgï kiꞌdi gbï töyö mï löŋgö mo. ");
INSERT INTO bex_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kina bɔ laja ꞌba bɔ tönë kako kiya zi bo, iya te, ‘Kupö ma laka na tönë kulï mï nyaka ꞌbï, ne beli naga nima ako di yala?’ ");
INSERT INTO bex_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bo ileki dɔmo, iya te, ‘Bɔ ya na koꞌdɔ lende nima.’ Lïjë ititi bo, iya te, ‘Oꞌdɔkɔ ꞌdɔ dari dotɔ beli naga nima yaga?’ ");
INSERT INTO bex_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Bo iya te, ‘Inza tara. Ɔdɔ kari kotɔke ëddï kotɔke nyönyu ma laka gbï timo. ");
INSERT INTO bex_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tine olake nyönyu ni ti beli naga nima kana kpaki bi kɔtɔ ŋbö kömö mï kada ꞌba tumu wa di mï nyaka. Kina ti miya ꞌjaa zi bɔ kumu nyönyu ꞌdɔ lïjë kotɔtɔ kpa beli naga nima titi dɔgba kudödu bi kɔtɔ rɔ dɔ koŋma yaga. Kina ꞌdɔ lïjë kumu nyönyu ma kiꞌdi mï mata.’” ");
INSERT INTO bex_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yësu iya dɔŋgala mɔtɔ gbï zïnnï, iya te, “Ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ ꞌjɔ ꞌba ŋgërï mɔtɔ ame wötï titiyi ne tara tine ɔdɔ bilaka kogba kari kulï mï nyaka ");
INSERT INTO bex_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","na kïyöbu ŋgï rɔ ŋgërï ma löbu ame yali ni kako kubö rö ꞌbënnï ga ŋgï dɔŋgila mo.” ");
INSERT INTO bex_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yësu iya dɔŋgala mɔtɔ gbï zïnnï, iya te, “Ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ laŋga ame ꞌja kogba pele mbowa kuturö ti ruzu koso mï a ma mbiri kiꞌdi ŋgï pili köꞌbu ne.” ");
INSERT INTO bex_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Wa naga nime pili Yësu oloma ꞌdeni rɔ tiya mo rɔ dɔŋgala zi tïndï naga nima. Bo iya a mɔtɔ dë zïnnï du te kinza dɔŋgala teyi. ");
INSERT INTO bex_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bo oꞌdɔ ꞌdeni tara ꞌdɔ këdï kɔzɔ wa ma tönë bɔ kumë lende ꞌba Bɔkoꞌba kiya ne, “Ti milende zïnnï rɔ dɔŋgala. Wa ame ga kikali dë mɔlo di bi tisaki ꞌba dɔliŋɔ nime ne ti miya zïnnï.” ");
INSERT INTO bex_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kina ɔdɔ Yësu kënyï ꞌdeni di mï löŋgö tïndï naga nima bo kari ꞌdeni liŋɔ tine na bɔ kösö gɔ bo ga kako ŋgï zi bo kititi bo, iya te, “Ïyëtï ꞌjɔ ꞌba dɔŋgala ꞌba beli ꞌba mï nyaka nime te zize.” ");
INSERT INTO bex_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yësu ileki dɔmo, iya te, “Bɔ kulï kupö nima na rɔ kole ꞌba bilaka lesi. ");
INSERT INTO bex_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tine nyaka mo nima na rɔ dɔliŋɔ, kina kupö nyönyu mo nima na rɔ bilaka ꞌba ŋere löbu ꞌba Bɔkoꞌba, kina beli mo nima na rɔ bilaka ꞌba Satani. ");
INSERT INTO bex_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kina bɔ ya ma kako kulï kupö beli mo nima na rɔ Satani. Kada ꞌba tumu wa di mï nyaka na rɔ ŋburuŋburu ꞌba dɔliŋɔ. Kina bɔ kumu nyönyu mo ga na rɔ malayika. ");
INSERT INTO bex_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kina gbï kɔzɔ ame këdï kotɔtɔ kpa beli koŋma yaga ne tara, ti këdï gbï kɔzɔ wa nima tara mï ŋburuŋburu ꞌba dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kole ꞌba bilaka lesi ti koja malayika abo ga kari kutöꞌdu bɔ dɔ kirasi ni ti bɔ lende kënyë ni yaga di mï ŋere löbu abo. ");
INSERT INTO bex_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kina malayika ti kuꞌdu lïjë ŋgï mï paꞌdo ꞌba tölë dɔ kote ꞌdɔ lïjë kudu kunyï kpënnï yayi. ");
INSERT INTO bex_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tine bɔ lende laka ni ti këdï rɔ löbu ma dɔ kiteli ame köbö kɔzɔ kada tara mï dɔliŋɔ ꞌba ꞌbu nnï. Bɔ ame këdï ti mbili ne iꞌdike bo kuwö lende nime.” ");
INSERT INTO bex_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ wa nime te. Bɔ mɔtɔ ari kömö ŋgï dɔ yamo adalamini sököwö kusu dɔmo ꞌdeni mï nyaka. Kina bo kitiri dɔmo ŋgï tötï teyi. Bo ꞌdeni ŋgï rɔ lɔŋɔ na bo kari kugö wa ame ga bo këdï timo ne ŋgï me mökö, kina bo kileki ŋgï kari kugö nyaka tönë ti yamo yïmo ne rɔ abo. ");
INSERT INTO bex_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kina ŋere löbu ꞌba Bɔkoꞌba ëdï gbï kɔzɔ wa nime te. Bɔ ndögö mɔtɔ iꞌdi toma tiyi nyileki ma kele. ");
INSERT INTO bex_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tine ɔdɔ bo kari koꞌja ame kele ŋgï rɔ dɔ kiteli ne ꞌdeni tine, bo ari ŋgï kugö abo ga me mökö na bo kileki ŋgï kari kugö tiyi nyileki tönë. ");
INSERT INTO bex_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kina ŋere löbu ꞌba Bɔkoꞌba ëdï gbï kɔzɔ wa nime te. Atoyi mɔtɔ ga uꞌdu duru ꞌbënnï mï mini na kunzö kenze ŋgï rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kina ɔdɔ koso ꞌdeni yïmo tine na lïjë kotɔ ŋgï yaga dɔ kpa götö lïjë koloma bërï tigeli ma laka mo ga. Ma laka mo ga uꞌdu mï kee tine ma kënyë mo ga uꞌdu ŋgï mökö. ");
INSERT INTO bex_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kina ti këdï gbï tara mï kada ꞌba ŋburuŋburu ꞌba dɔliŋɔ. Malayika ti kako kigeli bɔ lende kënyë yaga di mï löŋgö bɔ lende laka. ");
INSERT INTO bex_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kina lïjë ti kuꞌdu bɔ lende kënyë ŋgï mï paꞌdo ꞌba tölë dɔ kote ꞌdɔ lïjë kudu kunyï kpënnï yayi.” ");
INSERT INTO bex_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yësu ititi lïjë, iya te, “Ikalike wa naga nima ra?” Lïjë iya te, “Yëë.” ");
INSERT INTO bex_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kina bo kileki kiya zïnnï, bo iya te, “Bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ame ga pili kuyï rönnï ꞌdeni rɔ bɔ laja mï ŋere löbu ꞌba Bɔkoꞌba ne ëdï kɔzɔ bɔ mɔri ame koja wa ma mɔlo ni ti ma laꞌja yaga di mï mata abo ne tara.” ");
INSERT INTO bex_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kina ɔdɔ Yësu kote tiya dɔŋgala naga nime ꞌdeni tine na bo kënyï ŋgï di gɔ bi nima ");
INSERT INTO bex_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bo kileki kari Nazareta mï dɔyayi ꞌbënnï. Bo oloma tiyandi kɔmɔ bilaka mï rö ꞌba mötu kina bilaka pili kotɔ ŋgï rɔ gönnï. Lïjë iya te, “Bɔ nima oꞌja akikali ma te di yala? Kina bo ikali toꞌdɔ gɔ kotɔ löbu naga nime di yala? ");
INSERT INTO bex_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bɔ nime bo na dë rɔ kole ꞌba bɔ kose ŋgërï tönë? Ma bo na dë rɔ Mariya? Löndö bo ga na dë rɔ Yakoba ni ti Yesepa ti Simona ti Yuda? ");
INSERT INTO bex_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lëmï bo ga na dë me gbï këdï koloma tize bine ne? Ne bo oꞌja wa naga nime te di yala?” ");
INSERT INTO bex_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kina lïjë kilagi lende abo ŋgï. Yësu ileki kiya zïnnï te, “Rɔ ma laka, bilaka ꞌba mï gɔ bi ma laki pili rɔ ma koro bɔ kumë lende. Tine bilaka ꞌba dɔyayi abo ga ti ma wado abo ga oro bo dë.” ");
INSERT INTO bex_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kina ŋgï bo oꞌdɔ gɔ kotɔ ma konzi dë kpe di yayi römöyï lïjë iꞌdi dönnï dë gɔ lende abo. ");
INSERT INTO bex_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mï kada nima yayi na Erode bɔ dɔliŋɔ ꞌba Galilaya kuwö lëbï ꞌba Yësu. ");
INSERT INTO bex_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kina bo kiya zi bɔ laja abo ga, iya te, “Yowani bɔ bapatisi na. Bo na kënyï ꞌdeni ꞌböwu kɔdɔ yaga di mï tölë. Kina me kiꞌdi bo këdï koꞌdɔ gɔ kotɔ naga nime ne.” ");
INSERT INTO bex_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Römöyï Erode bo na kindaꞌba Yowani tönë mɔlo bine kiꞌdi kudödu kuꞌdu mï maboso. Bo oꞌdɔ gɔ köꞌdu ꞌba Erodiya ꞌja ꞌba bɔ löndö bo Pïlïpö. ");
INSERT INTO bex_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Römöyï Yowani oloma tiya mo zi Erode, iya te, “Tuyï kɔmɔ ꞌja ꞌba löndö ele dë. Tïyëyï mï köꞌdu kiꞌdi ꞌba Bɔkoꞌba na.” ");
INSERT INTO bex_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bo oꞌdɔkɔ tupö Yowani yaga tine bo ere bilaka ꞌbënnï ga ꞌba Yudayi römöyï lïjë iya Yowani rɔ bɔ kumë lende ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tine mï kada ꞌba karama ꞌba töyö Erode na nyiti ꞌba Erodiya kari kusï ŋgala ŋgï kɔmɔ ŋba ꞌba mï karama naga nima pili. Kina tusï ŋgala ꞌbënï kiꞌdi Erode ŋgï këdï ti mï këyï rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Gɔ köꞌdu mo na bo kulömu rɔ bo zïnï, iya te, “Mulömu rɔma ꞌdeni, wa mɔtɔ ame kititi ne ti miꞌdi ŋgï zïyï.” ");
INSERT INTO bex_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kina mönï kiya ŋgï zïnï ꞌdɔ lɔko kari kititi Erode, kiya te, “Dɔ Yowani bɔ bapatisi na kiꞌdi zö gïrï nime mï kitaꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Lende nime iꞌdi Erode ŋgï rɔ meri. Tine gɔ lömu ame bo kulömu rɔ bo ꞌdeni kɔmɔ ŋba abo ga pili ne, na bo kiꞌdi lende mo ŋgï ꞌdɔ koꞌdɔ kɔzɔ wa ma lɔko koꞌdɔkɔ nima tara. ");
INSERT INTO bex_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kina bo kiꞌdi ŋgï kari koke dɔ Yowani di mï maboso, ");
INSERT INTO bex_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","kina koꞌde ŋgï mï kitaꞌba kiꞌdi zi nyiti tönë koto kari zi mönï. ");
INSERT INTO bex_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kina bɔ kösö gɔ bo ga kako kombi töku bo ŋgï kari kusu. Na lïjë kari kiya lende mo ŋgï zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kina ɔdɔ Yësu kuwö meri ꞌba Erode nima bo kiya ne ꞌdeni tara tine na lïjë kënyï ŋgï di yayi këkï mï sorope kari rɔ dönnï mï gɔ bi ame bɔtɔ kinza teyi ne. Tine ɔdɔ bilaka kuwö lende abo ꞌdeni tara na lïjë kënyï ŋgï di mï liŋɔ kozi ꞌbënnï ti ndïnnï kebe dɔ kpa götö. ");
INSERT INTO bex_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kina ɔdɔ Yësu këkï ꞌdeni yaga di mï sorope tine bo oŋgɔ bilaka ëdï ꞌdeni ŋgï kako rɔ tïndï. Kina ɔdɔ bo koŋgɔ lisa ꞌbënnï ꞌdeni tara tine, na bo kileŋo ya ma rɔ rɔkɔꞌɔ naga ŋgï pili. ");
INSERT INTO bex_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Koꞌja kada këdï kösö ꞌdeni tine na bɔ kösö gɔ bo ga kako zi bo kiya te, “Kada inza kpe, bi nime rɔ yï mökö. Oja bilaka naga nime kari mï liŋɔ mɔtɔ ga ma ŋgɔsi bine ꞌdɔ lïjë kari kugö akonyo zïnnï di yayi.” ");
INSERT INTO bex_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bo iya te, “Lïjë kari dë bi tɔ, kpe na ꞌdɔ kiꞌdike akonyo zïnnï.” ");
INSERT INTO bex_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lïjë iya te, “Dinza ti ɔtɔ bine tine ŋge rɔ maŋgolɔꞌbɔ muyï ti kenze rïyö.” ");
INSERT INTO bex_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Bo iya te, “Oꞌdeke kako zö dayi.” ");
INSERT INTO bex_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kina bo kiya ŋgï ꞌdɔ bilaka naga nima pili koloma bërï dɔ mɔli. Kina bo kogba maŋgolɔꞌbɔ muyï tönë ŋgï ti kenze rïyö mo naga nima, na bo koŋgɔ bi kari mïtɔrɔ, bo kileki yëëꞌdï mo zi Bɔkoꞌba. Na bo konye yïmo kiꞌdi zi bɔ kösö gɔ bo ga kari koza zi tïndï tönë ga. ");
INSERT INTO bex_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kina lïjë pili konyo ŋgï kïtëkpë lïjë. Kina bɔ kösö gɔ bo ga kari kutöꞌdu kɔsɔ ma kileke bërï mo ga ŋgï koso mï kee ꞌbutë dɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bilaka naga nima konyo ne bɔtɔni mo ga ëdï pili kuluku ꞌbutë bi ꞌbutë (5000). Kina ꞌja ëdï gbï ti kole titi ame kïtëtë dë yïmo. ");
INSERT INTO bex_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yësu iꞌdi bɔ kösö gɔ bo ga këkï mï sorope ꞌdɔ lïjë kumu tötï kari dɔgba gönyï pöpö. Tine na bo kileke ꞌba bo tötï tïyëyï tïndï naga nima gɔ lïjë kari ëꞌbënnï ti. ");
INSERT INTO bex_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Di pötö mo koꞌja bo kïyëyï tïndï naga nima ꞌdeni kari tine na bo kënyï ŋgï kari dɔ döku rɔ dɔ kutu bo tilende ti Bɔkoꞌba. Mï kpalila ꞌdeni tine bo ëdï ꞌdeni ŋgï ŋge kutu bo yayi. ");
INSERT INTO bex_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kina sorope ëdï ëꞌbënï ꞌdeni gbï ŋbö rɔ ma kɔwɔ mï zana mini lili këdï koŋbeŋbe rɔ ma kënyë. Römöyï lili nima ëdï kome kako di kɔmɔ mo. ");
INSERT INTO bex_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mï kano bi ꞌdeni na Yësu kari kömö ŋgï zïnnï yayi bo këdï kiliŋgere kebe dɔ mini. ");
INSERT INTO bex_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tine ɔdɔ lïjë koꞌja bo ꞌdeni këdï kiliŋgere kebe dɔ mini tara tine na koꞌde tikere ŋgï zïnnï. Kina lïjë kulörï rɔ ma kembe rɔ kɔmɔ ꞌba tikere, kiya te, “Sëgë na.” ");
INSERT INTO bex_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kina Yësu kënyï kilende zïnnï, iya te, “Ogbɔke dökïꞌdï ye. Ma na. Kinza kereke dë.” ");
INSERT INTO bex_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kina Pïtörö kënyï kiya zi bo, iya te, “Ŋere, ɔdɔ këdï ŋgï rɔ nï na, ïdëkï ma te miliŋgere kebe dɔ mini mari zïyï yayi.” ");
INSERT INTO bex_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yësu iya te, “Ako.” Kina Pïtörö këkï ŋgï di mï sorope kiꞌdi tiliŋgere kebe dɔ mini kari zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tine ɔdɔ bo koꞌja lili ꞌdeni tara na koꞌde tikere ŋgï zi bo. Kina bo kiꞌdi ŋgï tönzu kari bërï mï mini, na bo kulörï kopapa kiya te, “Ŋere, okɔnyi ma.” ");
INSERT INTO bex_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kina Yësu koja közï bo ŋgï welo kikapo bo, kiya te, “Gɔ waꞌdi na kiꞌdi döyï dë gba laka gɔ lende ma? Ikali dë ma mëdï mɔmɔ yi?” ");
INSERT INTO bex_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kina ɔdɔ lïjë këkï ꞌdeni mï sorope yɔ na lili tönë kɔrɔ ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kina ya ma mï sorope yayi naga nima koloma ŋgï tïlëlu bo, iya te, “Rɔ ma laka nï na ŋgï rɔ kole ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lïjë umu dɔ pöpö nima ŋbö lïjë kömö mï dɔyayi ꞌba Genesareta. ");
INSERT INTO bex_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kina bilaka mo ga kikali Yësu ŋgï, na lïjë koja laja ŋgï gɔ bɔ rɔkɔꞌɔ ame ga pili toko mï dɔyayi nima yayi ne ꞌdɔ koꞌde zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Lïjë omaꞌjo rönnï zi bo ꞌdɔ ya ma rɔ rɔkɔꞌɔ naga kosa ŋge pele rɔ dɔ kpa bɔŋgɔ abo. Kina bɔ rɔkɔꞌɔ ma konzi ame ga kosa dɔ kpa bɔŋgɔ ꞌba rɔ bo nima ne kileŋo ŋgï pili di dɔ rɔkɔꞌɔ mo ga. ");
INSERT INTO bex_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parosi mɔtɔ ga ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ako di Yerosalema zi Yësu kititi, iya te, ");
INSERT INTO bex_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gɔ waꞌdi na bɔ kösö göyï ga koro akiyandi ꞌba ꞌbu ze löbu ga dë? Römöyï lïjë ëdï ꞌdeni konyo akonyo ŋgï tara kinza toꞌdɔ dölëtï ꞌba közï kurögö.” ");
INSERT INTO bex_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yësu ileki dɔmo zïnnï, iya te, “Ne gɔ waꞌdi na kïyëyïke mï köꞌdu kiꞌdi ꞌba Bɔkoꞌba ꞌdɔ toꞌdɔ akiyandi ꞌba gbagba ye ga? ");
INSERT INTO bex_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Römöyï Bɔkoꞌba iya te, ‘Oro ꞌbu yï ni ti möyï,’ kina mɔtɔ gbï, ‘Bɔtɔ ame kumu kpa bo gɔ ꞌbu bo ni ti ma bo ne kölë yaga.’ ");
INSERT INTO bex_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tine ebe kiyake te, ɔdɔ bɔ mɔtɔ këdï ti wa ame ꞌdɔ bo kokɔnyi ma bo ni ti ꞌbu bo timo kina ɔdɔ bo kiya ꞌdeni te, ‘Wa nima mulömu ꞌdeni ꞌdɔ tiꞌdi mo zi Bɔkoꞌba,’ ");
INSERT INTO bex_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","bine iyandike bo ꞌdeni za ꞌböwu ꞌdɔ bo koro ꞌbu bo ni ti ma bo dë kpe tokɔnyi mo ti wa nima. A nime na kïyëyïke mï köꞌdu kiꞌdi ꞌba Bɔkoꞌba ꞌdeni ꞌdɔ toꞌdɔ köꞌdu kiꞌdi ꞌba gbagba ye ga. ");
INSERT INTO bex_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kpe bɔ kɔmɔ kandi naga nime, Yesaya umë lende ŋgï rɔ ma laka gɔ köꞌdu ꞌbe ame kiya te, ");
INSERT INTO bex_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bilaka naga nime lïjë oro ma ŋere Bɔkoꞌba ŋge ti kpënnï tine mïnnï ŋbö rɔ ma kɔwɔ di zö. ");
INSERT INTO bex_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mötu ꞌbënnï ka rɔ a yawa, römöyï köꞌdu kiꞌdi ꞌbënnï ꞌba bilaka lesi na za lïjë kebe tiyandi mo kiya rɔ lende ma ꞌba Bɔkoꞌba.’” ");
INSERT INTO bex_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kina Yësu kïdëkï tïndï naga nima ŋgï kako zi bo kilende teyi, iya te, “Ojeke mbili ye kuwöke lende nime ꞌdɔ kɔdɔ dɔye. ");
INSERT INTO bex_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wa ma këdï kari mï bilaka iꞌdi bilaka dë këdï rɔ ma kënyë kɔmɔ Bɔkoꞌba. Tine wa ma këdï kɔdɔ di kpa bilaka na këdï kiꞌdi bilaka rɔ ma kënyë di kɔmɔ bo.” ");
INSERT INTO bex_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kina bɔ kösö gɔ bo ga kako zi bo, iya te, “Ikali ra? Lende nima kiya ne ilaꞌba ŋgï rɔ ma kënyë mï Parosi ni.” ");
INSERT INTO bex_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Bo ileki dɔmo zïnnï, iya te, “Ŋgërï ame ga pili kinza rɔ ma kïdïyë ꞌba ꞌbu ma ame mïtɔrɔ ne ti kotɔ yaga. ");
INSERT INTO bex_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kinza kupöke rɔye dë gɔ lende ꞌbënnï. Lïjë ꞌbënnï nima bɔ kɔmɔ kölu ma këdï kiteri tokɔkɔ bɔ kɔmɔ kölu lëpï nnï ga na. Ne ɔdɔ bɔ kɔmɔ kölu kebe tokɔkɔ bɔ kɔmɔ kölu mɔtɔ, lïjë nima kpaki rïyö ti kilaꞌba ŋgï mï gö.” ");
INSERT INTO bex_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kina Pïtörö kënyï kititi bo, iya te, “Ïyëtï ꞌjɔ ꞌba dɔŋgala nime kiya ne zize.” ");
INSERT INTO bex_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yësu ileki dɔmo zïnnï, iya te, “Kpe gba gbï tara ikalike ɔtɔ dë? ");
INSERT INTO bex_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ikalike dë wa ame kɔdɔ kari di kpa bilaka ne ari ŋgï mï tokpe kuwu rönï di yayi kiteli ëꞌbënï kɔdɔ yaga di mï yida rɔ? ");
INSERT INTO bex_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tine wa ame këdï kɔdɔ yaga di kpa bilaka ne ɔdɔ ꞌbënï kako di mï dökïꞌdï. Lïjë na rɔ wa ma këdï kiꞌdi bilaka këdï rɔ ma kënyë kɔmɔ Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Römöyï wa ma këdï kɔdɔ di mï dökïꞌdï na rɔ meri ma kënyë naga ti akupö ti yërï ti töꞌdö ti rɔ ame rɔ ma kënyë ne ti ꞌbögö ti susu bëtï ti tiꞌja. ");
INSERT INTO bex_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wa naga nime na rɔ wa ma këdï kiꞌdi bilaka këdï rɔ ma kënyë kɔmɔ Bɔkoꞌba. Ne tonyo akonyo tara kinza turögö közï kɔzɔ ame lïjë Parosi ni kiya ziye ne iꞌdi bilaka dë këdï kɔtɔ te rɔ ma kënyë kɔmɔ Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kina Yësu kënyï ŋgï di yayi kari mï gɔ bi ma ŋgɔsi ŋgila gawo ꞌba Tura ni ti Sidona. ");
INSERT INTO bex_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Di yayi na ꞌja mɔtɔ rɔ bilaka ꞌba Kanana ame këdï koloma mï dɔyayi nima yayi kako ŋgï zi bo ti tulörï, iya te, “Ŋere kole ꞌba Dawidi, iꞌdi mïyï këyï rɔma. Nökï ëdï ꞌdeni ŋgï koŋbeŋbe nyiti ma rɔ ma kënyë.” ");
INSERT INTO bex_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tine Yësu ileki lende mɔtɔ dë kiya zïnï. Kina bɔ kösö gɔ bo ga kako kilende zi bo, iya te, “Oja ꞌja nime kari yaga di rɔze. Lɔko ëdï kozi nduwë gɔze ti tulörï.” ");
INSERT INTO bex_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bo ileki dɔmo, iya te, “Oja ma ŋge mako mï dɔliŋɔ nime gɔ kamölö ꞌba Yisarele ma kölu ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kina ɔdɔ ꞌja tönë kuwö ꞌdeni tara na lɔko kako kilaꞌba ŋgï kolɔdɔ bërï kɔmɔ Yësu, kiya te, “Ŋere, okɔnyi ma.” ");
INSERT INTO bex_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bo ileki dɔmo zïnï, iya te, “Tuꞌdu akonyo ꞌba kole ziye bï ele dë.” ");
INSERT INTO bex_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ꞌJa tönë ileki dɔmo, iya te, “Ŋere, rɔ ma laka, pele tara bï ëdï konyo ruruzu ma këdï kilayi bërï di dɔ tarabiza ꞌba bɔ dönnï ga.” ");
INSERT INTO bex_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kina Yësu kileki dɔmo zïnï, iya te, “ꞌJa, iꞌdi döyï ꞌdeni rɔ ma laka gɔ lende ma, ne koꞌdɔ rönï ŋgï zïyï tara.” Kina kileŋo nyiti ꞌbënï tönë ŋgï mï saa nima. ");
INSERT INTO bex_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yësu ënyï di yayi kari nduwë kebe kpa pöpö ꞌba Galilaya. Kina bo kari këkï ŋgï dɔ kuruŋgu bo koloma bërï. ");
INSERT INTO bex_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kina tïndï ma kinza kiya kɔlɔ ŋgï kako zi bo. Lïjë oꞌde ya ma rɔ kaꞌbo naga ti bɔ kɔmɔ kölu ni ti ya ma keŋme bërï naga ti bɔ kpa kudödu ni ti bɔ rɔkɔꞌɔ mɔtɔ ga. Lïjë oꞌde pili koꞌba kɔmɔ Yësu. Kina bo kileŋo lïjë ŋgï pili. ");
INSERT INTO bex_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kina ɔdɔ bilaka naga nima koŋgɔ bɔ kpa kudödu ni këdï kilende ꞌdeni, ya ma keŋme bërï naga ꞌdeni laka, bɔ kaꞌbo ni këdï kiliŋgere ꞌdeni, bɔ kɔmɔ kölu ni këdï koꞌja bi ꞌdeni, lende mo igayi lïjë ŋgï. Kina lïjë kebe ŋgï tïlëlu Bɔkoꞌba ꞌba Yisarele. ");
INSERT INTO bex_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kina Yësu kïdëkï bɔ kösö gɔ bo ga kako zi bo, iya te, “Moŋgɔ lisa ꞌba rɔ bilaka naga nime ꞌdeni, lïjë oꞌdɔ töꞌdö ꞌdeni dɔ mota tö bine, akonyo ꞌbënnï ga ote rönï ꞌdeni. Moꞌdɔkɔ dë toja lïjë ŋgï kari tara ti ꞌbö kinza ma lïjë konyo ɔtɔ, römöyï kinza lïjë kari kidaki gɔ kɔri.” ");
INSERT INTO bex_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bɔ kösö gɔ bo ga ititi bo, iya te, “Ti doꞌja akonyo di yala di yï mökö nime ma ꞌdɔ kɔꞌbɔ tïndï ꞌba bilaka naga nime?” ");
INSERT INTO bex_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bo ileki kititi lïjë, iya te, “Akonyo waꞌdi ga na këddïke timo bina?” Lïjë iya te, “Dëdï ŋge ti maŋgolɔꞌbɔ modɔmorïyö, ti kole kenze titi tɔ ne ga.” ");
INSERT INTO bex_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kina Yësu kiꞌdi ꞌdɔ tïndï naga nima koloma bërï. ");
INSERT INTO bex_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kina bo kogba maŋgolɔꞌbɔ modɔmorïyö tönë ga ŋgï ti kenze mo ga, bo kileki yëëꞌdï mo zi Bɔkoꞌba. Kina bo konye yïmo ŋgï kiꞌdi zi bɔ kösö gɔ bo ga kari kiꞌdi zi bilaka tönë ga. ");
INSERT INTO bex_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kina lïjë pili konyo ŋgï kɔꞌbɔ lïjë. Kina bɔ kösö gɔ bo ga kako ŋgï kotɔtɔ kɔsɔ ma kileke mo ga koso mï kee modɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bilaka naga nima konyo ne bɔtɔni mo ga ëdï pili kuluku ꞌbutë bi modɔɔmota (4000). Kina ꞌja ëdï gbï ti kole titi ame kïtëtë dë yïmo. ");
INSERT INTO bex_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kina ɔdɔ Yësu kïyëyï bilaka naga nima ꞌdeni kari tine, na bo këkï ŋgï mï sorope kari mï dɔyayi ꞌba Magadana. ");
INSERT INTO bex_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parosi mɔtɔ ga ti Sadoke ako zi Yësu ꞌdɔ toꞌba bo. Kina lïjë kititi bo ꞌdɔ bo koꞌdɔ gɔ kotɔ ame ꞌdɔ kileme tigɔ ꞌba Bɔkoꞌba di mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tine Yësu ileki dɔmo zïnnï, iya te, “Kpe bilaka, ɔdɔ kada këdï kösö ëꞌbënï ꞌdeni iyake te, ‘Ma tïlëndö kada ëdï keze römöyï mïtɔrɔ rɔ ma kasi.’ ");
INSERT INTO bex_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kina gbï mɔlo mï dɔŋbɔ iyake te, ‘Tɔrɔ ëdï kaꞌdi tɔne römöyï mïtɔrɔ ꞌdeni rɔ ma kasi gbï ti pɔli kölu.’ Kina me ꞌdeni ikalike tïyëtï kɔmɔ pɔli ma këdï kuyï rönï tïlëndö rɔ ma kasi ala rɔ ma kölu. Tine inza kɔꞌbɔke tïyëtï wa ma këdï koꞌdɔ rönï mï kada naga nime. ");
INSERT INTO bex_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gɔ waꞌdi na kpe bɔ titi ma leꞌjete nime ŋgï rɔ ma kënyë kereke Bɔkoꞌba dë te? Ebeke tititi ma ꞌdɔ toꞌdɔ gɔ kotɔ ziye, tine minza mileme du te ziye. Gɔ kotɔ ma ꞌdɔ kileme ziye na ŋge tönë rɔ ꞌba Yona bɔ kumë lende ꞌba Bɔkoꞌba.” Kina Yësu kënyï ŋgï kari abo di ŋgila lïjë. ");
INSERT INTO bex_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kina ɔdɔ Yësu ni kari ꞌdeni kumu dɔ pöpö kömö gönyï ma kapa mɔtɔ tine, bɔ kösö gɔ bo ga ari koŋgɔ dönnï udölu ꞌdeni di bi togba maŋgolɔꞌbɔ kako timo. ");
INSERT INTO bex_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yësu iya zïnnï, iya te, “Iꞌdike kɔmɔye kandi laka di zi laŋga ꞌba Parosi ni ti Sadoke ni.” ");
INSERT INTO bex_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kina bɔ kösö gɔ bo tönë ga koloma ŋgï rɔ tiya mo rɔ gɔ rönnï, lïjë iya te, “Bo ëdï kiya lende nima tara gɔ ame dakoke dë ti maŋgolɔꞌbɔ ne ya?” ");
INSERT INTO bex_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tine Yësu ikali wa nima lïjë këdï kiya ne ꞌdeni mɔlo. Kina bo kiya zïnnï, iya te, “Kpe bɔ kinza kiꞌdike dɔye dë gba laka gɔ lende ma naga nime. Gɔ waꞌdi na këddï kiyake lende ꞌba maŋgolɔꞌbɔ ame kakoke dë timo ne rɔ gɔ rɔye gɔmo? ");
INSERT INTO bex_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lende nime ɔdɔ dë gba dɔye? Omerike lende ꞌba maŋgolɔꞌbɔ muyï tönë monye yïmo kiꞌdike zi bilaka kuluku ꞌbutë bi ꞌbutë (5000) ne dë? Utöꞌduke kɔsɔ mo koso mï kee ndö? ");
INSERT INTO bex_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kina gbï maŋgolɔꞌbɔ modɔmorïyö tönë ga miꞌdi zi bilaka kuluku ꞌbutë bi modɔɔmota (4000) ne, utöꞌduke kɔsɔ mo koso mï kee ndö? ");
INSERT INTO bex_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ne gɔ waꞌdi na kiꞌdike dë këdï dɔye, lende ꞌba maŋgolɔꞌbɔ na dë me mëdï miya ziye bine ne? Iꞌdike kɔmɔye kandi laka di zi laŋga ꞌba Parosi ni ti Sadoke ni.” ");
INSERT INTO bex_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kina lende mo kɔdɔ ꞌjaa dönnï Yësu inza kiya zïnnï ꞌdɔ lïjë kiꞌdi kömönnï kandi laka di zi laŋga ꞌba gɔ maŋgolɔꞌbɔ, tine ꞌdɔ lïjë kiꞌdi kömönnï kandi laka di zi akiyandi ꞌba Parosi ni ti Sadoke ni. ");
INSERT INTO bex_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kina ɔdɔ Yësu ni kari ꞌdeni mï dɔyayi ma ŋgɔsi ŋgila gawo ꞌba Kayisariya Pïlïpö, na bo kititi bɔ kösö gɔ bo ga, iya te, “Bilaka ëdï kiya kole ꞌba bilaka lesi rɔ yë?” ");
INSERT INTO bex_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lïjë ileki dɔmo, iya te, “Ya mɔtɔ ga iya te nï Yowani bɔ bapatisi na. Ya mɔtɔ ga iya te nï Eliya mo na, mɔtɔ ga iya te nï Yeremaya ala bɔ kumë lende ꞌba Bɔkoꞌba ma kɔtɔ mɔtɔ na.” ");
INSERT INTO bex_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Bo ileki kititi lïjë, iya te, “Ne kpe ꞌbeye iyake ma rɔ yë?” ");
INSERT INTO bex_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Pïtörö ileki dɔmo, iya te, “Nï na rɔ Kurïsïtö kole ꞌba Bɔkoꞌba ame koja kako di mïtɔrɔ ne.” ");
INSERT INTO bex_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yësu ileki dɔmo, iya te, “Yëëꞌdï këdï zïyï Simona kole ꞌba Yowani. Römöyï akikali kodɔrɔ nime bilaka lesi na dë kiꞌdi zïyï, tine ako di zi ꞌbu ma ame mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pïtörö, rɔ ma laka miya zïyï, nï na rɔ döku. Döku nime na ti moꞌba kanisa ma dɔmo ame pele rɔ tölë dɔ kote inza kikali taꞌda mo. ");
INSERT INTO bex_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ti miꞌdi kpadörï ꞌba ŋere löbu ꞌba Bɔkoꞌba zïyï. Lende ame këddï kudödu zi bilaka ꞌba mï dɔyayi bine Bɔkoꞌba udödu ꞌdeni gbï mɔlo di mïtɔrɔ. Kina wa ame kodɔ kpamo di mï dɔyayi bine, Bɔkoꞌba odɔ kpamo ꞌdeni gbï mɔlo di mïtɔrɔ.” ");
INSERT INTO bex_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tine Yësu ose gɔmo zi bɔ kösö gɔ bo ga kinza lïjë kari kiya dë zi bɔtɔ ma kɔtɔ mɔtɔ kiya te, bo na rɔ Kurïsïtö ame Bɔkoꞌba koja kako di mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mï kada nima na Yësu kisaki ŋgï tiya mo yaga bi kɔpɔ zi bɔ kösö gɔ bo ga, kiya te, “Ti mari mï Yerosalema kina löbu ꞌba bilaka ni ti ꞌba bɔ akumu ni ti bɔ kɔmɔ kiyandi mo ga kpaki ti kodɔ gomɔ rɔma ŋbö lïjë kupö ma. Tine mï töꞌdö dɔ mota Bɔkoꞌba ti kiꞌdi ma mënyï mɔdɔ yaga di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kina Pïtörö kogba Yësu ŋgï kese timo sege yaga, bo kowasa lende nima yaga di kpa Yësu, iya te, “Ŋere, Bɔkoꞌba kitata yaga di röyï, koꞌdɔ rönï dë zïyï.” ");
INSERT INTO bex_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kina Yësu kuyï kɔmɔ bo dɔ Pïtörö, iya te, “Nï Satani nime, ese yaga di rɔma. Nï ꞌbëyï wa ꞌba turökpö rönï gɔ kɔri ma na. Meri ꞌbï nima ꞌba bilaka lesi na, ꞌba Bɔkoꞌba na dë.” ");
INSERT INTO bex_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kina Yësu koloma ŋgï rɔ tiya mo zi bɔ kösö gɔ bo ga, iya te, “Bɔtɔ ame koꞌdɔkɔ tösö gɔma ne, iꞌdike bo komba gɔ bo zi gbagba bo, bo kombi gomɔ abo bo kösö gɔma pele ŋbö mï tölë. ");
INSERT INTO bex_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Römöyï bɔ ame kiteri tɔmɔ dïdï bo ne ti kupö ŋgï. Tine ame kupö dïdï bo gɔ lende ma ne ti kɔmɔ ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɔdɔ bɔ mɔtɔ komɔmi dɔliŋɔ löbu nime pele pili zi bo, tine bo kupö dɔ dïdï bo, waꞌdi na bo ti koꞌja gɔmo? Bo inza koꞌja wa mɔtɔ gɔmo. Ɔdɔ bo kölë ꞌdeni wa mɔtɔ inza kpe ame ꞌdɔ bo kiꞌdi tutë gɔ dïdï bo timo. ");
INSERT INTO bex_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tine kole ꞌba bilaka lesi ti kako ti malayika abo ga mï tigɔ ꞌba ꞌbu bo. Kina bo ti kopi ŋgï zïyï nï bɔ mɔtɔ gɔ ndɔbɔ ꞌbï ma koꞌdɔ. ");
INSERT INTO bex_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rɔ ma laka miya ziye, ya mɔtɔ ga ëdï mï löŋgö ye bine ame tako ꞌba kole ꞌba bilaka lesi ame bo këdï kako rɔ ŋere ꞌba dɔ wa pili ne, ti kako kota lïjë gba kinza kinene wa mɔtɔ möyï mo rɔ tölë.” ");
INSERT INTO bex_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mï töꞌdö dɔ modɔɔkɔtɔ di pötö mo na Yësu kënyï ŋgï kogba Pïtörö ni ti Yakoba ti löndö bo Yowani, bo koto lïjë kari dɔ döku ma löbu rɔ dönnï. ");
INSERT INTO bex_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kina ŋgï koꞌja lïjë këdï koŋgɔ Yësu tine kïnë bo uyï rönï ꞌdeni ꞌberi. Kɔmɔ bo öbö ꞌdeni ŋgï kɔzɔ kada. Kina bɔŋgɔ ꞌba rɔ bo aŋmi ꞌdeni ŋgï köbö yaga kɔzɔ mandara. ");
INSERT INTO bex_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kina lïjë koꞌja Musa ni ti Eliya kɔdɔ ꞌdeni yayi këdï kilende ti bo. ");
INSERT INTO bex_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kina Pïtörö kënyï kilende kiya zi Yësu, iya te, “Ŋere, ele sowa ame dëdï ꞌdeni bine. Ɔdɔ koꞌdɔkɔ ŋgï, ti mubö ŋgöŋgöbö mota bine, kɔtɔ zïyï kɔtɔ zi Musa kina ma kɔtɔ ꞌdɔ këdï zi Eliya.” ");
INSERT INTO bex_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kota bo këdï gba tilende na pɔli mɔtɔ rɔ ma köbö kako ŋgï kutuꞌbö lïjë. Kina birɔ kudu ŋgï di mï pɔli nima, iya te, “Bo na rɔ kole ma ame mɔꞌɔ kulöwö ne, ma ti mï këyï gɔ lende abo. Uwöke dɔ bo.” ");
INSERT INTO bex_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kina ɔdɔ bɔ kösö gɔ Yësu naga nima kuwö birɔ nima ꞌdeni tara odɔ tikere ŋgï mïnnï lïjë kënyï kilaꞌba kutuꞌbö kömönnï bërï. ");
INSERT INTO bex_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yësu ako kosa rönnï, kiya te, “Ënyïke tɔrɔ. Kinza kereke dë.” ");
INSERT INTO bex_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kina lïjë kombi kömönnï tɔrɔ tine lïjë oꞌja bɔtɔ dë kpe, Yësu na ꞌdeni ŋge kutu bo yayi. ");
INSERT INTO bex_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kina ɔdɔ lïjë këdï këkï ꞌdeni kako bërï di dɔ döku tine, Yësu ose zïnnï, iya te, “Kinza kari kiyake lende ꞌba wa naga nime koꞌjake ne dë titi zi bɔtɔ ma kɔtɔ mɔtɔ. Tine ꞌdɔ kiyake ꞌjaa ɔdɔ Bɔkoꞌba kiꞌdi kole ꞌba bilaka lesi ꞌdeni ꞌböwu kënyï kɔdɔ yaga di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lïjë ititi bo, iya te, “Ne gɔ waꞌdi na bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni kiya te, Eliya na këdï kako titi dɔgba kina ꞌjaa ti Kurïsïtö kako?” ");
INSERT INTO bex_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yësu ileki dɔmo zïnnï, iya te, “Rɔ ma laka Eliya na këdï kako titi dɔgba ꞌdɔ bo kiyija wa pili ndö. ");
INSERT INTO bex_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tine rɔ ma laka miya ziye, Eliya ako ꞌdeni bine, tine bilaka ikali bo dë. Lïjë oꞌdɔ bo ŋgï kɔzɔ wa ma lïjë koꞌdɔkɔ ëꞌbënnï toꞌdɔ mo tara. Kina lïjë ti koꞌdɔ kole ꞌba bilaka lesi gbï kilisa di közïnnï tara.” ");
INSERT INTO bex_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kina bɔ kösö gɔ bo tönë ga kikali ŋgï Yowani bɔ bapatisi na bo këdï kiya lende mo. ");
INSERT INTO bex_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kina ɔdɔ lïjë kileki ꞌdeni kako kömö zi tïndï naga nima na bɔ mɔtɔ kako ŋgï kolɔdɔ bërï kɔmɔ Yësu, ");
INSERT INTO bex_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kiya te, “Ŋere, iꞌdi mïyï këyï rɔ kole ma. Kole ma ëdï ti abërï këdï koŋma ŋgï rɔ ma kënyë kebe mï paꞌdo ni, kebe mï mini ni. ");
INSERT INTO bex_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kina me moꞌde bo kako zi bɔ kösö göyï naga nime tine lïjë ɔꞌbɔ dë tileŋo mo.” ");
INSERT INTO bex_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yësu ileki dɔmo, iya te, “Kpe bilaka ma leꞌjete naga nime, kpe bɔ kinza kiꞌdike dɔye dë gɔ lende ma naga nime, kpe bɔ lende kënyë naga nime. ꞌDɔ möꞌbö tiye bine ŋbö nyanya? Kina ꞌdɔ mogbɔ dökïꞌdï ma di zi gomɔ ꞌbe nime ŋbö nyanya? Oꞌdeke kole nima kako zö dayi.” ");
INSERT INTO bex_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kina Yësu kamo ŋgï dɔ nökï nima na kënyï ŋgï di dɔ kole tönë. Kina kileŋo kole tönë ŋgï mï saa nima. ");
INSERT INTO bex_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kina bɔ kösö gɔ Yësu ga kako liya zi bo, kiya te, “Dɔꞌbɔ ꞌbeze dë toga mo yaga gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yësu ileki dɔmo, iya te, “Römöyï iꞌdike dɔye dë gba laka gɔ lende ma. Rɔ ma laka miya ziye, ɔdɔ kiꞌdike dɔye ꞌdeni pele ŋge mbowa gɔ lende ma ti kiyake ŋgï zi döku nime, kiyake te, ‘Ese di bine kari ꞌdë.’ Kina döku nime ti kese ŋgï. Kina gbï wa mɔtɔ inza konya dɔye kpe.” ");
INSERT INTO bex_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kina ɔdɔ bɔ kösö gɔ Yësu ga këdï ꞌdeni pili bi kɔtɔ Galilaya tine na Yësu kiya zïnnï, iya te, “Ti kususu kole ꞌba bilaka lesi kiꞌdi zi bilaka, ");
INSERT INTO bex_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kina lïjë ti kupö bo ŋgï. Tine mï töꞌdö dɔ mota Bɔkoꞌba ti kiꞌdi bo kënyï kɔdɔ yaga di mï tölë.” Gɔ köꞌdu mo na bɔ kösö gɔ bo ga ŋgï dɔ meri rɔ kɔmɔ tɔlɔ. ");
INSERT INTO bex_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kina ɔdɔ Yësu ni kömö ꞌdeni Kaparanoma, bɔ kireke awada ꞌba rö löbu ꞌba Bɔkoꞌba ako kititi Pïtörö, iya te, “Bɔ dɔye nima bɔ kopi awada ꞌba rö löbu ꞌba Bɔkoꞌba na?” ");
INSERT INTO bex_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pïtörö iya te, “Kina ŋgï tara.” Kina ɔdɔ Pïtörö kɔdɔ ꞌdeni rö, tine na Yësu kititi bo dɔgba, iya te, “Simona, meri ꞌbï tondo ga? Ëdï kireke awada ꞌba bɔ dɔliŋɔ ꞌba dɔyayi nime di zi yë mo ga? Di zi kole ꞌba bɔ dɔliŋɔ ala di zi bɔ löwö?” ");
INSERT INTO bex_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pïtörö iya te, “Ëdï kireke di zi bɔ löwö.” Yësu iya te, “Tine kole ꞌba bɔ dɔliŋɔ ireke ɔtɔ dë di teyi. ");
INSERT INTO bex_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ne doꞌdɔkɔ dë ꞌdɔ bilaka naga nime komeri lende kënyë rɔze. Ari kpa pöpö kuꞌdu jibada yïmo. Otɔ kenze ma dɔgba ame kindaꞌba jibada ne yaga. Kina ɔdɔ kobenye kpamo ëddï koꞌja yamo di kpamo. Kina ꞌdɔ kogba yamo nima kari timo kopi zïnnï rɔ awada ze ꞌba rö löbu ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mï kada nima na bɔ kösö gɔ Yësu ga kako zi bo kititi bo, iya te, “Yë na rɔ dɔ kiteli mï ŋere löbu ꞌba Bɔkoꞌba?” ");
INSERT INTO bex_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kina bo kïdëkï kole titi mɔtɔ ŋgï kiꞌdi kɔrɔ kömönnï. ");
INSERT INTO bex_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kina bo kiya te, “Rɔ ma laka miya ziye, ɔdɔ kilekike rɔye dë ŋgï kɔzɔ kole titi nime tɔdɔ ziye mï ŋere löbu ꞌba Bɔkoꞌba inza du te. ");
INSERT INTO bex_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bɔ ame kileki rɔ bo ꞌdeni titiyi kɔzɔ kole titi nime ne na rɔ dɔ kiteli mï ŋere löbu ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bɔ ame kota kole titi ma kɔzɔ a nime te rɔ ŋba gɔ köꞌdu ma ne, ma na bo kota ma ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ne bɔ ame këdï kiꞌdi kole titi ma kɔzɔ a nime te ame ga kiꞌdi dönnï ꞌdeni gɔ lende ma ne kebe kilaꞌba mï lende kënyë, ma laka mo dëne ɔꞌbɔ ꞌdɔ kudödu toto kuwu ndöwu ma löbu mugu bɔ tɔ nima ꞌdɔ kïtïŋï bo timo mï mini löbu ma kalo. ");
INSERT INTO bex_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Buꞌbu ziye kpe bilaka ꞌba dɔliŋɔ gɔ wa ma konzi ame ga këdï kiꞌdi bilaka kɔcɔ yaga di mï kɔri ma nime ne. Ëdï ŋgï tara ꞌdɔ lïjë wa naga nima këdï bine. Tine buꞌbu zi bɔ ame kiꞌdi bilaka tɔcɔ yaga ne. ");
INSERT INTO bex_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ɔdɔ közïyï ala ndïyï na kiꞌdi yi koꞌdɔ lende kënyë, oke yaga kuꞌdu mökö. Ti këdï rɔ ma laka zïyï ꞌdɔ këddï ti dïdï ma ŋburuŋburu rɔ bɔ közï kɔtɔ ala rɔ bɔ ndï kɔtɔ di dɔ ame ꞌdɔ kuꞌdu yi mï paꞌdo ma ŋburuŋburu kpaki ti közïyï ga ti ndïyï ga ne. ");
INSERT INTO bex_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kina ɔdɔ kömöyï na kiꞌdi yi koꞌdɔ lende kënyë iyagba yaga kuꞌdu mökö. Ti këdï rɔ ma laka zïyï ꞌdɔ këddï ti dïdï ma ŋburuŋburu rɔ bɔ kɔmɔ kɔtɔ di dɔ ame ꞌdɔ kuꞌdu yi mï paꞌdo ꞌba tölë dɔ kote ti kömöyï ga kpaki rïyö ne.” ");
INSERT INTO bex_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Oŋgɔke laka kinza kudölïke lïjë wa titi naga nime dë. Rɔ ma laka miya ziye malayika ꞌbënnï ga öꞌbö ŋgï ŋburu kɔmɔ ꞌbu ma Bɔkoꞌba di mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ti komerike tondo? Ɔdɔ bɔ mɔtɔ këdï ti kamölö kuluku rïyö, kina ma kɔtɔ mɔtɔ kölu yaga di kɔmɔ mo, tara ne bo ti kola ma konzi naga nima dë ŋgï mökö mï löwu yayi bo kari toma ma kɔtɔ nima kölu ne ya? ");
INSERT INTO bex_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Rɔ ma laka miya ziye, ɔdɔ bo kari koꞌja ꞌdeni, bo ti këdï ŋgï ti lɔŋɔ rɔ mbëmbë rɔ dɔ kiteli gɔmo di dɔ lɔŋɔ ma bo këdï timo gɔ ma konzi naga nima kölu dë ne. ");
INSERT INTO bex_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kina gbï tara ꞌbu ye ame mïtɔrɔ ne oꞌdɔkɔ dë ꞌdɔ lïjë wa titi naga nime ma kɔtɔ mo kölu yaga.” ");
INSERT INTO bex_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ɔdɔ löndö yï mɔtɔ kirasi lende zïyï ari kïyëtï gɔ lende kirasi abo liya zi bo. Tine iyake ŋge dɔye rïyö ti bo. Kina ɔdɔ bo kuwö döyï ꞌdeni ɔmɔ bo ꞌdeni di mï lende kirasi. ");
INSERT INTO bex_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ne ɔdɔ bo kuwö döyï dë ogba bɔ mɔtɔ ala bilaka ma rïyö mɔtɔ ga ŋgila yï römöyï ꞌdɔ bɔ kodɔrɔ bïcï lende mo këdï rïyö ala mota, kɔzɔ ma buku ꞌba Bɔkoꞌba kiya tara. ");
INSERT INTO bex_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tine ɔdɔ bo kuwö dönnï dë gbï ari kïyëtï gɔmo pili mï kanisa. Kina ɔdɔ bo kuwö dɔ kanisa dë gbï tine oꞌdɔ bo ŋgï nati kɔzɔ bɔ löwö kɔzɔ bɔ lende kënyë naga tara. ");
INSERT INTO bex_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Rɔ ma laka miya ziye lende ame këddï kudöduke di mï dɔyayi bine Bɔkoꞌba udödu ꞌdeni gbï mɔlo di mïtɔrɔ. Kina gbï lende ame kodɔke kpamo di mï dɔyayi bine Bɔkoꞌba odɔ kpamo ꞌdeni gbï di mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kina me mëdï miya gbï ziye, ɔdɔ bilaka ma rïyö di mï löŋgö ye bine kutï ꞌdeni gɔ wa mɔtɔ ame ꞌdɔ kititike ꞌbu ma ame mïtɔrɔ ne gɔmo bo ti koꞌdɔ ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Römöyï ɔdɔ bilaka rïyö ala mota kotɔtɔ kpënnï dömöyï ma, ti mëdï ŋgï mï löŋgö lïjë.” ");
INSERT INTO bex_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kina Pïtörö kako zi Yësu kititi, iya te, “Ŋere, ɔdɔ löndö mɔtɔ köꞌbö nduwë toꞌdɔ lende kënyë zö, ꞌdɔ mola bo gɔmo ŋbö mï ndö? Mï modɔmorïyö?” ");
INSERT INTO bex_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yësu iya te, “Inza tara, ola dë ŋge mï modɔmorïyö, tine ola bo nduwë gɔmo ŋbö mï kuluku ma kinza kiya. ");
INSERT INTO bex_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Römöyï ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ lende ꞌba bɔ dɔliŋɔ mɔtɔ ame koꞌdɔkɔ toŋgɔ gɔ akikeki ꞌba bɔ laja abo ga ne. ");
INSERT INTO bex_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kina ɔdɔ bo kisaki toꞌdɔ mo ꞌdeni tara tine na koꞌde bɔ mɔtɔ ame konyo yamo ꞌdeni ŋgï ame tïtëtë mo ŋgï rɔ kuluku ma kinza kiya ne. ");
INSERT INTO bex_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bɔ laja nima inza ti wa mɔtɔ ma ꞌdɔ kɔꞌbɔ topi wali nima timo. Kina bɔ dɔliŋɔ nima kiꞌdi lende mo ŋgï ꞌdɔ tugö bɔ nima pili mökö ti ꞌja mo ga ti kole mo ga kpaki ti wa mo ga ꞌdɔ kopi kpa wali nima. ");
INSERT INTO bex_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tine bɔ laja tönë ënyï kolɔdɔ bërï kɔmɔ bɔ dɔliŋɔ nima, kiya te, ‘Ŋere, iꞌdi mïyï këdï liya rɔ ma këyï rɔma. Ti mopi wa ꞌbï naga nima ꞌdeni ŋgï pili zïyï.’ ");
INSERT INTO bex_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mï bɔ dɔliŋɔ ëyï ŋgï rɔ bɔ laja nima kina kola bo ŋgï gɔ wali tönë kope bo kari abo. ");
INSERT INTO bex_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tine bɔ tönë ari kondɔsɔ ti bɔ laja lëpï bo mɔtɔ ame wali abo këdï gɔmo ŋge kuluku ndö tara. Kina bo kindaꞌba ŋgöŋgörö bɔ nima ŋgï, iya te, ‘Opi wali ma tönë göyï ne.’ ");
INSERT INTO bex_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tine bɔ laja lëpï bo nima olɔdɔ bërï komaꞌjo rɔ bo zi bɔ tönë, iya te, ‘Iꞌdi mïyï këdï liya rɔ ma këyï rɔma. Ti mopi wa ꞌbï naga nime ꞌdeni ŋgï pili zïyï.’ ");
INSERT INTO bex_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pele bo upupu mï bo ŋgï bërï bo koto bɔ tönë kuꞌdu mï maboso, ꞌdɔ koloma yayi ŋbö ɔdɔ bɔ nima kopi wali nima pili. ");
INSERT INTO bex_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kina ɔdɔ bɔ laja mɔtɔ ga koꞌja ꞌdeni tara lïjë ŋgï rɔ meri rɔ mbëmbë, kina lïjë kari kïyëtï gɔmo ŋgï pili zi bɔ dɔliŋɔ tönë. ");
INSERT INTO bex_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kina bɔ dɔliŋɔ kïdëkï bɔ tönë ŋgï, iya te, ‘Nï bɔ laja kënyë kulöwö nime, mola yi bine gɔ wali tönë ga römöyï omaꞌjo röyï zö. ");
INSERT INTO bex_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne gɔ waꞌdi na kiꞌdi mïyï dë këyï rɔ bɔ laja lëpï yi nima kɔzɔ ame miꞌdi yïmö këyï röyï ne tara?’ ");
INSERT INTO bex_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bɔ dɔliŋɔ ŋgï rɔ ꞌdïrï ti bo kina kiꞌdi lende ŋgï zi bɔ kanya ꞌba gɔ maboso ꞌdɔ kuꞌdu bɔ nima mï maboso komba ŋbö bo kopi wali nima kote.” ");
INSERT INTO bex_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kina Yësu kileki zïnnï, iya te, “Wa nime na ti ꞌbu ma ame mïtɔrɔ ne koꞌdɔ gbï tara ziye ɔdɔ kolake lëpï ye ga dë di mï dökïꞌdï ye.” ");
INSERT INTO bex_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kina ɔdɔ Yësu kote tiya wa naga nime ꞌdeni tine, na bo kënyï ŋgï di Galilaya kari mï kapa dɔyayi ꞌba Yudayi ame gönyï yöpö ꞌba Yaradene ne. ");
INSERT INTO bex_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kina tïndï ꞌba bilaka kozi ŋgï gɔ bo, na bo kileŋo ya ma ti rɔkɔꞌɔ naga ŋgï di yayi. ");
INSERT INTO bex_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parosi mɔtɔ ga ako zi bo tiyɔzɔ bo ti akititi, iya te, “Tara ne köꞌdu kiꞌdi odɔ kpamo ŋgï ꞌdɔ bɔ mɔtɔ koga ꞌja ꞌbï ŋgï gɔ lende mɔtɔ ga pili ya?” ");
INSERT INTO bex_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yësu ileki dɔmo zïnnï, iya te, “Ïdëkïke dë du di mï buku ꞌba Bɔkoꞌba? Ame kiya te, di bi tisaki mo bɔ ma koꞌba lïjë iꞌdi lïjë rɔ bɔtɔni ni ma ti ꞌja. ");
INSERT INTO bex_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kina bo kiya te gɔ köꞌdu nime, ‘Bɔtɔni ti kolɔlɔ di yɔki ꞌbu bo ni ti ma bo, lïjë kari kodɔꞌbɔ rönnï ti ꞌja abo. Kina lïjë kpaki rïyö ꞌdeni rɔ akɔtɔ.’ ");
INSERT INTO bex_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lïjë inza kpe rïyö tine ꞌdeni rɔ akɔtɔ. Kina wa ame Bɔkoꞌba kodɔꞌbɔ ꞌdeni rɔ akɔtɔ ne kinza bilaka kebe koza yïmo dë kpe yaga.” ");
INSERT INTO bex_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parosi naga nima ënyï kititi bo, iya te, “Ne gɔ waꞌdi na Musa kiꞌdi köꞌdu mo kiya te ɔdɔ bɔ mɔtɔ koga ꞌja abo ꞌdɔ bo kugu waraga ꞌba tëyï kiꞌdi teyi?” ");
INSERT INTO bex_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yësu iya te, “Musa odɔ kpamo ziye ꞌdɔ kogake ꞌja ꞌbe ga yaga römöyï minyi ꞌbe idari ꞌdeni. Tine ma di bi tisaki mo inza tara. ");
INSERT INTO bex_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Rɔ ma laka miya ziye, bɔ ame koga ꞌja abo gɔ lende mɔtɔ ꞌberi di gɔ kɔmɔ kolɔlɔ ꞌba töꞌdö ti rɔ ne oꞌdɔ yërï ꞌdeni ɔdɔ bo kebe kari kogbe ꞌja mɔtɔ gbï.” ");
INSERT INTO bex_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kina bɔ kösö gɔ bo ga kititi bo, iya te, “Ne ɔdɔ köꞌdu ꞌba mï löŋgö ꞌja ni ti bɔtɔni na ꞌdeni tara tine, ꞌdɔ bilaka kogbe ꞌja dë kpe ma?” ");
INSERT INTO bex_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yësu ileki dɔmo zïnnï, iya te, “Akiyandi ꞌba töꞌbö kinza togbe ꞌja nime iya rönï dë zi bilaka pili rɔ buru, tine ŋge zi lïjë ame ga Bɔkoꞌba kiꞌdi ꞌdeni zïnnï ne. ");
INSERT INTO bex_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Römöyï kɔri ꞌba lende mo ga ëdï ŋbaŋi ame kiꞌdi bilaka këdï koloma kinza togbe ꞌja ne. ꞌBa ya mɔtɔ ga öyö lïjë mɔlo tara. ꞌBa ya mɔtɔ ga bilaka na koꞌdɔ lïjë tara. Kina ya mɔtɔ ga oꞌdɔkɔ ꞌbënnï togbe ꞌja dë gɔ köꞌdu ꞌba ŋere löbu ꞌba Bɔkoꞌba. Kina iꞌdike lïjë ame ga kɔꞌbɔ tutï gɔ akiyandi nime ne, koꞌdɔ ŋgï tara.” ");
INSERT INTO bex_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bilaka mɔtɔ ga oꞌde kole titi kako zi Yësu ꞌdɔ bo kiꞌdi közï bo dönnï, bo koꞌdɔ mötu gɔ lende ꞌbënnï. Tine bɔ kösö gɔ bo ga ota bilaka naga nima. ");
INSERT INTO bex_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kina Yësu kiya te, “Kinza kotake kole titi naga nime dë, olake lïjë kako zö. Römöyï lïjë ame ga kɔzɔ a nime te ne ŋere löbu ꞌba Bɔkoꞌba na rɔ ꞌbënnï.” ");
INSERT INTO bex_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kina bo kiꞌdi közï bo ŋgï dönnï na bo kiteli ŋgï nduwë di yayi. ");
INSERT INTO bex_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kina bɔ mɔtɔ kako zi Yësu kititi, iya te, “Bɔ kɔmɔ kiyandi, wa ma laka waꞌdi na gɔ moꞌdɔ ꞌdɔ moꞌja dïdï ma ŋburuŋburu?” ");
INSERT INTO bex_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yësu iya te, “Ititi ma gɔ wa ma laka gɔ waꞌdi? Bɔkoꞌba na ŋge kɔtɔ rɔ ma laka. Ɔdɔ koꞌdɔkɔ tëdï ti dïdï ma ŋburuŋburu oro köꞌdu kiꞌdi abo.” ");
INSERT INTO bex_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bɔ nima iya te, “Köꞌdu kiꞌdi ma tondo mo ga?” Yësu iya te, “Kinza koꞌdɔ röyï dë rɔ bɔ közï roma. Kinza koꞌdɔ yërï dë. Kinza koꞌdɔ ꞌbögö dë. Kinza kususu bɔtɔ mɔtɔ dë rɔ bëtï. ");
INSERT INTO bex_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kina oro ꞌbu yï ni ti möyï. Kina gbï ɔꞌɔ bilaka lesi lëpï yï mɔtɔ kɔzɔ ame kɔꞌɔ yida röyï ne tara.” ");
INSERT INTO bex_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yɔbi nima iya te, “Moro köꞌdu kiꞌdi naga nima ꞌdeni mɔlo kpaki rɔ gɔmo. Tine waꞌdi na kola gba zö ꞌdɔ moꞌdɔ?” ");
INSERT INTO bex_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yësu iya zi bo, iya te, “Ɔdɔ koꞌdɔkɔ ŋgï ꞌdɔ këddï rɔ ma laka kinza a ma kënyë mɔtɔ mïyï ari kugö wa ꞌbï ga me yaga ꞌdɔ koza gïrïsï mo zi bɔ lisa. Kina ti këddï ŋgï ti wa rɔ mbëmbë mï dɔyayi ꞌba mïtɔrɔ. Kina ti ꞌdɔ kako kösö gɔma.” ");
INSERT INTO bex_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kina ɔdɔ yɔbi tönë kuwö lende nima ꞌdeni tara tine, bo ënyï abo ŋgï kari ti meri, römöyï bo bɔ wa mbëmbë na. ");
INSERT INTO bex_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kina Yësu kebe tiya mo zi bɔ kösö gɔ bo ga, bo iya te, “Rɔ ma laka miya ziye, ti këdï rɔ gomɔ zi bɔ wa gɔ kɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kina me mëdï mileki gbï miya gɔmo ziye, tɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba ti këdï rɔ ma kitigɔ zi bɔ wa ni kɔzɔ tɔdɔ ꞌba gamele di bi gböŋö ꞌba bïcï libira tara.” ");
INSERT INTO bex_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kina ɔdɔ bɔ kösö gɔ bo ga kuwö lende nime ꞌdeni te tine, lende mo igayi lïjë ŋgï sowa. Kina lïjë kebe tititi mo, iya te, “Tine yë na ti kɔmɔ ti di mï tölë ya?” ");
INSERT INTO bex_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yësu oŋgɔ bi dönnï, iya te, “Wa nime bilaka lesi ɔꞌbɔ dë toꞌdɔ mo, tine Bɔkoꞌba na kɔꞌbɔ toꞌdɔ wa pili.” ");
INSERT INTO bex_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kina Pïtörö kënyï kileki dɔmo, iya te, “Oŋgɔ te, ne ze ꞌbeze nime dola wa pili ꞌdeni dösö göyï. Tine waꞌdi na ti doꞌja di gɔmo?” ");
INSERT INTO bex_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yësu ileki dɔmo zïnnï, iya te, “Kina me ziye ꞌdɔ kikalike laka, ɔdɔ kole ꞌba bilaka lesi kari koloma ꞌdeni dɔ kïtï ma dɔ kiteli abo mï dɔliŋɔ ma kileŋo rɔ ma laꞌja nime tine, kpe bɔ kösö gɔma ma ꞌbutë dɔmorïyö naga nime ti kolomake ꞌdeni gbï dɔ kïtï rɔ löbu dɔ kpa gɔli ma ꞌbutë dɔmorïyö ꞌba Yisarele. ");
INSERT INTO bex_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kina ti lïjë ame ga pili kola liŋɔ ala löndö ala lëmï ala ꞌbu ni ti ma ala kole ala nyaka gɔ lende ma ne, ti koꞌja ꞌdeni ŋgï rɔ mbëmbë kebe dɔ ame ga lïjë kola ne. Kina lïjë ti koꞌja kpa közïmo ꞌdeni ŋgï rɔ dïdï ma ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tine ame ga rɔ löbu ne ti kileki ꞌdeni titiyi. Kina ame ga titiyi ne ti këdï ꞌdeni ŋgï rɔ löbu.” ");
INSERT INTO bex_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ lende ꞌba bɔ nyaka mɔtɔ ame kënyï mɔlo mï dɔŋbɔ kari toma bilaka ꞌba ꞌdɔ koꞌdɔ ndɔbɔ mï nyaka abo ne tara. ");
INSERT INTO bex_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kina ɔdɔ lïjë kutï dɔ lende ꞌbënnï ꞌdeni bi kɔtɔ ti bɔ ndɔbɔ abo ga ꞌdɔ bo kopi yamo kuluku kɔtɔkɔtɔ zïnnï mï kada kɔtɔ tine, bo oja lïjë ŋgï kari bi ndɔbɔ mï nyaka abo nima. ");
INSERT INTO bex_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kina bo kënyï kari ꞌböwu mï gɔ bi ꞌba ndögö koꞌja ndï kada këdï ꞌdeni modɔmosowɔ. Kina bo kari koꞌja ya mɔtɔ ga ŋgï këdï kɔrɔ le yayi rɔ ma sari kinza ndɔbɔ. ");
INSERT INTO bex_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kina bo kënyï kilende zïnnï, bo iya te, ‘Kpe nime gbï, arike toꞌdɔ ndɔbɔ mï nyaka ma ꞌdë yayi, ti mopi wa ma kɔꞌbɔ gɔ kɔmɔye ŋgï ziye.’ ");
INSERT INTO bex_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kina lïjë kari ŋgï. Kina mï zana kada ꞌdeni bo ari koꞌdɔ gbï tara. Mï kɔmɔ kada ꞌdeni bo ari koꞌdɔ gbï tara. ");
INSERT INTO bex_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kina koꞌja ndï kada këdï ꞌdeni kɔzɔ muyï tara tine, na bo kari koꞌja ya mɔtɔ ga gbï këdï gba kɔrɔ le rɔ ma sari mï gɔ bi ꞌba ndögö yayi. Kina bo kënyï kilende zïnnï, bo iya te, ‘Ëddï kɔrɔke kada kösö dɔye bine rɔ ma sari kinza ndɔbɔ mo gɔ waꞌdi?’ ");
INSERT INTO bex_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Lïjë iya te, ‘Bɔtɔ iꞌdi ndɔbɔ dë du te zize.’ Bo iya te, ‘Laka, arike gbï toꞌdɔ ndɔbɔ mï nyaka ma.’ ");
INSERT INTO bex_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kina ɔdɔ kada kösö ꞌdeni tine bɔ dɔ nyaka tönë ilende zi makuŋgu abo, iya te, ‘Ari kïdëkï bɔ ndɔbɔ naga nime ꞌdë ꞌdɔ kopi yamo ꞌbënnï zïnnï. Isaki di dɔ ya ma koꞌde di yïꞌböwu naga nima ŋbö kömö dɔ ya ma koꞌde dɔgba naga nima.’ ");
INSERT INTO bex_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ya ma tönë ga kisaki ndɔbɔ koꞌja ndï kada këdï ꞌdeni muyï ne, indaꞌba yamo kuluku kɔtɔkɔtɔ kpaki rɔ gönnï. ");
INSERT INTO bex_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kina ɔdɔ ya ma koꞌde dɔgba tönë ga kömö ꞌdeni tine, lïjë omeri ꞌbënnï tëgë lïjë ëdï kunzö yamo tɔne rɔ ma kënyë. Tine lïjë pili rɔ gönnï indaꞌba ga me kuluku kɔtɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kina ɔdɔ lïjë kindaꞌba yamo ꞌdeni pili tine lïjë ebe ŋgï toŋboro rönnï zi bɔ dɔ nyaka tönë. ");
INSERT INTO bex_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Lïjë iya te, ‘Ya ma koꞌde ꞌjaa di yïꞌböwu naga nime oꞌdɔ ꞌbënnï ndɔbɔ ŋge saa kɔtɔ. Ne ze ꞌbeze nime dupö rɔze timo loyi dɔ kada kata nime ebe kopi yamo ꞌbënnï gbï aa koriya ti ꞌbeze.’ ");
INSERT INTO bex_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bɔ dɔ nyaka nima iya zi bɔ ma kɔtɔ mɔtɔ di mï löŋgö lïjë yayi, iya te, ‘Bɔ ŋba ma, uwö te. Muꞌbölu ye dë rɔ tuꞌbölu. Kpe na kutïke dɔ lende nime kɔtɔ tö ꞌdɔ koꞌdɔke ndɔbɔ kada kösö dɔ yamo kuluku kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kina me ꞌdeni, ogbake yamo ꞌbe ga ma kindaꞌbake, karike liŋɔ. Ma na moꞌdɔkɔ ꞌdɔ topi mo zi ya ma koꞌde di yïꞌböwu naga nima gbï kɔzɔ ꞌbeye. ");
INSERT INTO bex_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mëdï ti közï kakpa ꞌdɔ toꞌdɔ wa ame moꞌdɔkɔ toꞌdɔ mo ne ti yamo ma. Mï koŋmi ma nime moꞌdɔ ne na kënyë mïye?’” ");
INSERT INTO bex_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yësu iya te, “Kina gbï tara, ame ga leꞌjete yïꞌböwu ne ti këdï ꞌdeni dɔgba. Kina ame ga leꞌjete dɔgba ne ti kileki ꞌdeni yïꞌböwu.” ");
INSERT INTO bex_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kina ɔdɔ Yësu ni këdï kari ꞌdeni Yerosalema tine, bo ogba bɔ kösö gɔ bo ga yaga ꞌberi rɔ dönnï. Kina bo koloma rɔ tiya mo zïnnï di gɔ kɔri yayi, ");
INSERT INTO bex_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","bo iya te, “Uwöke te, dëdï darike nime mï Yerosalema kina ti kindaꞌba kole ꞌba bilaka lesi kiꞌdi zi löbu ꞌba bɔ akumu ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni. Kina lïjë ti kodɔ karama ŋgï dɔ bo rɔ tölë. ");
INSERT INTO bex_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kina lïjë ti kogba bo ŋgï kiꞌdi zi bɔ löwö todɔ laŋa rɔ bo komba bo kina ti kutötï bo ŋgï. Tine mï töꞌdö dɔ mota bo ti kënyï kɔdɔ ꞌdeni ŋgï yaga di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ꞌJa ꞌba Zebedayo ënyï kako ti kole rïyö ꞌbënï ga zi Yësu. Kina lɔko kolɔdɔ ŋgï bërï komaꞌjo rönï zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yësu iya te, “Waꞌdi na koꞌdɔkɔ?” Lɔko iya te, “Rɔ ma laka ɔdɔ kari koloma ꞌdeni rɔ bɔ dɔliŋɔ, iꞌdi kole rïyö ma naga nime ma kɔtɔ koloma dɔ dörï yï kina mɔtɔ dɔ gali yï.” ");
INSERT INTO bex_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yësu ileki dɔmo zïnnï, iya te, “Wa nima kititike ne ikalike dë. Ti kɔꞌbɔke tuwë wa di mï kösu ꞌba gomɔ ame mëdï muwë wa di yïmo ne?” Lïjë iya te, “Dëdï dɔꞌbɔ.” ");
INSERT INTO bex_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yësu iya te, “Rɔ ma laka ti kuwëke wa ŋgï di mï kösu ma. Tine tiꞌdi wa toloma dɔ dörï ma ti dɔ gali ma nima ndɔbɔ ma na dë, ꞌbu ma na këdï kiꞌdi ya ame ga bo kileŋo ꞌdeni ne koloma teyi.” ");
INSERT INTO bex_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kina ɔdɔ bɔ kösö gɔ bo ma ꞌbutë naga nima kuwö lende nime ꞌdeni, lïjë ënyï ŋgï rɔ ꞌdïrï ti löndö rïyö naga nima. ");
INSERT INTO bex_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kina Yësu kïdëkï lïjë ŋgï pili bi kɔtɔ, kina bo kiya te, “Ikalike ꞌdeni laka löbu ma ꞌba bɔ löwö ni oꞌdɔ ga rönnï ŋgï rɔ ŋere rɔ a löbu dönnï. ");
INSERT INTO bex_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ne ma ꞌbeye inza tara. Bɔtɔ ame koꞌdɔkɔ gɔ bo këdï rɔ löbu di mï löŋgö ye ne, bo kileki rɔ bo yaga rɔ bɔ laja ziye. ");
INSERT INTO bex_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kina ɔdɔ bɔ ma kɔtɔ di mï löŋgö ye koꞌdɔkɔ ꞌdɔ bo na këdï rɔ bɔ dɔye, ma laka na ꞌdɔ bo këdï rɔ atɔli ziye pili. ");
INSERT INTO bex_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kina ꞌdɔ këdï gbï kɔzɔ tako nime kole ꞌba bilaka lesi kako ne, bo ako dë ꞌdɔ bilaka koja laja zi bo, tine bo ako toja laja zi bilaka kina gbï ꞌdɔ tiꞌdi dïdï bo ꞌdɔ tutë gɔ bilaka ma konzi timo di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kina ɔdɔ Yësu ni këdï kënyï ꞌdeni ti bɔ kösö gɔ bo ga di Yereko yayi tine, na tïndï ma kinza kiya kösö ŋgï gönnï. ");
INSERT INTO bex_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tine bɔ kɔmɔ kölu ma rïyö mɔtɔ ga ame këdï koloma kpa kɔri yayi ne uwö ꞌdeni Yësu na ma këdï kari ne. Kina lïjë kiꞌdi ŋgï tulörï rɔ ma kembe, kiya te, “Ŋere, kole ꞌba Dawidi, iꞌdi mïyï këyï rɔze.” ");
INSERT INTO bex_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tine tïndï naga nima amo dönnï gɔ lïjë kudumö yaga. Tine pele na lïjë kulörï ŋgï rɔ ma kembe rɔ dɔ kiteli, kiya te, “Ŋere, kole ꞌba Dawidi, iꞌdi mïyï këyï rɔze.” ");
INSERT INTO bex_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kina Yësu kɔrɔ ŋgï kïdëkï lïjë, bo iya te, “Oꞌdɔkɔke ꞌdɔ moꞌdɔ waꞌdi ziye?” ");
INSERT INTO bex_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lïjë ileki dɔmo zi bo iya te, “Ŋere, doꞌdɔkɔ ꞌdɔ kiyɔpɔ kɔmɔze yaga.” ");
INSERT INTO bex_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yësu oŋgɔ lisa ꞌba rönnï kina bo kosa kömönnï ŋgï, kina kömönnï kɔpɔ ŋgï yaga koꞌja bi. Kina lïjë kösö ŋgï gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kina ɔdɔ Yësu ni kömö ꞌdeni ŋgɔsi ŋgila Yerosalema tine, na lïjë kari ŋgï Betepage ame ŋgila döku ꞌba Bilaya ne. Di yayi na Yësu koja ya ma rïyö mɔtɔ ga di mï löŋgö bɔ kösö gɔ bo ga kari dɔgba ");
INSERT INTO bex_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ti ndose nime, iya te, “Arike mï liŋɔ nime ꞌdë dɔgba kɔmɔye ne, ti kari koꞌjake akaca kosi dɔmo ꞌdeni bërï yayi ti kole mo ŋgila mo. Kina ꞌdɔ kopeke koꞌdeke kako zö bine. ");
INSERT INTO bex_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kina ɔdɔ bɔtɔ mɔtɔ kiya a mɔtɔ ziye gɔmo, iyake te, ‘Ŋere na koꞌdɔkɔ lïjë.’ Kina bo ti kola ŋgï karike timo.” ");
INSERT INTO bex_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wa nime oꞌdɔ rönï ꞌdeni ꞌdɔ këdï kɔzɔ lende ma tönë bɔ kumë lende kiya ne. ");
INSERT INTO bex_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ame kiya te, “Iya te zi bilaka ꞌba Yerosalema, ‘Oŋgɔke te, bɔ dɔliŋɔ ꞌbe na me ꞌdë këdï rɔ tako ziye. Bo abo le liya, bo ëkï ꞌdeni dɔ akaca. Bo oloma ꞌdeni dɔ kole akaca.’ “ ");
INSERT INTO bex_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kina ya tönë ga Yësu koja ne kari koꞌdɔ wa ame bo kiya zïnnï ne ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Lïjë oꞌde akaca nima ti kole mo, lïjë koꞌba bɔŋgɔ ꞌbënnï ga gɔmo. Kina Yësu këkï ŋgï koloma dɔmo tari timo. ");
INSERT INTO bex_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tïndï ma konzi oꞌba bɔŋgɔ kileŋo mï kɔri timo tine ya mɔtɔ ga oga ꞌbënnï rɔ ꞌjöwu koꞌba teyi. ");
INSERT INTO bex_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kina tïndï ame ga kösö kebe gɔ Yësu ti ya ma dɔgba mo ga pili ulörï kiya te, “Yëëꞌdï këdï zïyï kole ꞌba Dawidi. Yëyï këdï dɔ bɔ ame kako ti möyï ŋere Bɔkoꞌba ne. Akïlëlu këdï zi Bɔkoꞌba mïtɔrɔ.” ");
INSERT INTO bex_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kina ɔdɔ Yësu këdï kɔdɔ ꞌdeni mï Yerosalema tine, bilaka ꞌba mï gawo yayi pili ënyï kozɔ timo, iya te, “Yë mo na ya?” ");
INSERT INTO bex_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tine tïndï naga nima ileki dɔmo, iya te, “Ame na rɔ Yësu bɔ kumë lende di mï Nazareta ꞌba Galilaya.” ");
INSERT INTO bex_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kina Yësu kɔdɔ ŋgï mï reki ꞌba rö löbu ꞌba Bɔkoꞌba, na bo kënyï ŋgï toga bilaka ame ga këdï tugö wa yayi ne me yaga. Bo kïtïŋï dɔ tarabiza ꞌba bɔ kutë gïrïsï ni bërï, gbï ti gbaꞌda ꞌba bɔ kugö matukpuru ni. ");
INSERT INTO bex_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bo iya zïnnï, iya te, “Ugu ꞌdeni mï buku ꞌba Bɔkoꞌba iya te, ‘Rö löbu ma nime ti kïdëkï rɔ rö ꞌba mötu.’ Ne kina kebe kuyïke ꞌdeni za rɔ bi ꞌba bɔ ꞌbögö.” ");
INSERT INTO bex_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tine bɔ kɔmɔ kölu ni ti bɔ kaꞌbo ni ako zi bo mï reki ꞌba rö löbu ꞌba Bɔkoꞌba yayi, kina bo kileŋo lïjë ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kina ɔdɔ löbu ꞌba bɔ akumu ni ti bɔ kɔmɔ kiyandi ni koꞌja gɔ kotɔ naga nima bo koꞌdɔ ne ꞌdeni tara tine, kina gbï ti ame kole titi këdï kulörï ꞌdeni timo di yayi, kiya te, “Yëëꞌdï këdï zïyï kole ꞌba Dawidi,” ne tine lende mo ënyë ŋgï mïnnï. ");
INSERT INTO bex_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kina lïjë kënyï kititi bo, iya te, “Uwö wa nima lïjë këdï kiya ne ra?” Yësu iya te, “Yëë, muwö ra. Ne lende nime kugu mï buku ꞌba Bɔkoꞌba ne ïdëkïke dë su? Ame kiya te, ‘Nï Bɔkoꞌba iꞌdi akïlëlu ma laka ꞌdeni kɔdɔ di kpa kole titi ni ti kole kuru ame ga gba dɔ mba ne.’” ");
INSERT INTO bex_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kina Yësu kënyï ŋgï di ŋgila lïjë yayi kari abo yaga di mï gawo nima. Bo ari Betaniya, bo köꞌdö yayi. ");
INSERT INTO bex_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Di bi tileki abo kako mï gawo rɔ mï dɔŋbɔ tine, bo ꞌdeni rɔ ꞌbö. ");
INSERT INTO bex_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kina bo koꞌja ŋgërï këlu dɔ kpa kɔri yayi. Kina bo kɔcɔ ŋgï kari toŋgɔ mo. Tine bo oꞌja ɔtɔ dë dɔmo, ŋge rɔ mbili mo. Kina bo kilende zi ŋgërï nima, bo iya te, “Nï, inza kana a mɔtɔ kpe döyï bina.” Kina ŋgï ŋgala te yɔ na ŋgërï tönë kölë ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bɔ kösö gɔ bo ga oꞌja lende nime kina lende mo kigayi lïjë ŋgï. Lïjë iya te, “Ŋgërï këlu nime ututu ŋgï ŋgala te totondo mo ga?” ");
INSERT INTO bex_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bo ileki dɔmo zïnnï, iya te, “Rɔ ma laka miya ziye, ɔdɔ kiꞌdike dɔye ŋgï rɔ ma laka gɔ lende ma kinza kïlïköke dɔye dë, ti kɔꞌbɔke ŋgï toꞌdɔ wa ame kebe ma koꞌdɔ rönï zi ŋgërï këlu nime. Ɔdɔ kiyake pele te zi döku nime, ‘Nï, ënyï kuꞌdu röyï mï mini löbu.’ Rɔ ma laka, ti koꞌdɔ rönï ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ɔdɔ kiꞌdike dɔye ꞌdeni ŋgï gɔ lende ma, wa ame ga pili këddï kititike ti mötu ti koꞌjake ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kina ɔdɔ Yësu kɔdɔ ꞌdeni mï reki ꞌba rö löbu ꞌba Bɔkoꞌba këdï kiyandi kɔmɔ bilaka tine, na löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni kako ŋgï zi bo. Lïjë kititi bo iya te, “Közï kakpa ꞌba yë na me këddï koꞌdɔ wa naga nime timo ne? Yë mo na kiꞌdi közï kakpa nime zïyï?” ");
INSERT INTO bex_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bo iya te, “Ti mititi ye gbï ti akititi mɔtɔ kɔtɔ bine, ɔdɔ kilekike dɔmo ꞌdeni zö ti miya gɔ közï kakpa ꞌba bɔtɔ nime mëdï moꞌdɔ wa naga nime timo ne ꞌjaa ziye.” ");
INSERT INTO bex_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kina bo kititi lïjë, bo iya te, “Közï kakpa ꞌba todɔ mini ꞌba bapatisi dɔ bilaka nime Yowani koloma toꞌdɔ mo ne ako di zi yë? Ako di zi Bɔkoꞌba ala di zi bilaka lesi?” Kina lïjë koloma ŋgï rɔ towasa mo rɔ gɔ rönnï, lïjë iya te, “Ɔdɔ diyake te ako di zi Bɔkoꞌba, bo ti kiya te, ‘Ne iꞌdike dɔye dë gɔ lende abo gɔ waꞌdi?’ ");
INSERT INTO bex_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ne ɔdɔ diyake te ako di zi bilaka lesi, ele dë gbï. Ze rɔ tikere di zi tïndï konzi naga nime. Römöyï lïjë pili omeri ꞌdeni Yowani na rɔ bɔ kumë lende ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kina lïjë kileki ŋgï kiya zi Yësu tëgë, “Dikali dë.” Kina bo kileki zïnnï, bo iya te, “Ma gbï minza miya közï kakpa tɔ nime mëdï moꞌdɔ wa naga nime timo ne ziye.” ");
INSERT INTO bex_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Kina me omerike dɔŋgala nime te. Bɔ mɔtɔ ëdï ti kole abo ga rïyö. Kina bo kënyï kari zi kole abo ma löbu mo bo kiya te, ‘Kole ma, ari tɔne toꞌdɔ ndɔbɔ mï nyaka ze.’ ");
INSERT INTO bex_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tine kole nima iya te, ‘Moꞌdɔkɔ ama dë.’ Ne di pötö mo ꞌböwu bo ari komeri dɔ bo kina bo kënyï ŋgï kari. ");
INSERT INTO bex_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kina ꞌbu nnï tönë kënyï kari kiya lende nima gbï tara zi kole ma titi mo. Bo iya te, ‘Yëë, baba, mëdï mari.’ Tine bo ebe kari abo dë du te. ");
INSERT INTO bex_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ma komerike ꞌbeye di mï löŋgö ya rïyö naga nime kole ma yala na koꞌdɔ akoꞌdɔkɔ ꞌba ꞌbu nnï?” Löbu tönë ga iya te, “Kole ma dɔgba nima.” Yësu iya te, “Rɔ ma laka miya ziye, bɔ kireke awada ni ti ꞌja bɔ rɔnyɔ ni na ti kɔdɔ dɔgba di ziye mï ŋere löbu ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Römöyï Yowani bɔ bapatisi ako ꞌdeni kileme kɔri ma laka ziye ꞌdɔ kösöke gɔmo. Tine iꞌdike eꞌbe dɔye dë yɔ gɔ lende abo. Ne bɔ kireke awada ni ti ꞌja bɔ rɔnyɔ ni iꞌdi dönnï ꞌdeni gɔmo. Wa naga nime koꞌjake pele tara otɔke dɔye dë yɔ kiꞌdike dɔye gɔ lende mo.” ");
INSERT INTO bex_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yësu iya te, “Uwöke dɔŋgala mɔtɔ tɔ ma. Bɔ mɔtɔ ïdïyë mɔwɔ këdï koꞌdɔ rɔ layi naga ŋgï rɔ nyaka. Kina bo kigaga reki kuru dɔmo toko, bo koꞌdɔ bi ꞌba tuzï layi mo yayi, bo kole kilaŋga ꞌba toda mo, bo kiꞌdi bɔ ndɔbɔ toꞌdɔ ndɔbɔ yïmo yayi, bo kënyï abo kari mï dɔyayi mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kina ɔdɔ kada ꞌba titeꞌde mo kömö ꞌdeni tine, bo oja bɔ laja abo ga kari ꞌdɔ koꞌde döŋgërï ma ꞌba bo. ");
INSERT INTO bex_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kina bɔ ndɔbɔ tönë ga kindaꞌba bɔ laja abo naga nima ŋgï komba ma kɔtɔ, kupö mɔtɔ kina kuꞌdu ma kɔtɔ ti döku. ");
INSERT INTO bex_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kina bo kënyï koja bɔ laja mɔtɔ ga ꞌböwu konzi kiteli ma dɔgba tönë. Kina bɔ ndɔbɔ naga nima koꞌdɔ lïjë ŋgï gbï tara. ");
INSERT INTO bex_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Rɔ ŋburuŋburu mo na bo koja kole abo ŋgï kari zïnnï, bo iya te, ‘Ame kole ma na lïjë ëdï koro.’ ");
INSERT INTO bex_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tine ɔdɔ bɔ ndɔbɔ naga nima lïjë koꞌja kole nima ꞌdeni, lïjë iya rɔ gɔ rönnï, iya te, ‘Bɔ nime bo na këdï koloma rɔ bɔ dɔ nyaka nime kada mɔtɔ di pötö ꞌbu bo. Ako dupöke bo yaga ꞌdɔ nyaka nime köꞌbö ŋgï ŋburu rɔ eze.’ ");
INSERT INTO bex_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kina lïjë kindaꞌba bo ŋgï kuꞌdu ŋbö yaga di mï nyaka nima na lïjë kupö bo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ma komerike ꞌbeye ɔdɔ bɔ dɔ nyaka kako waꞌdi na ti bo koꞌdɔ zi ya naga nima?” ");
INSERT INTO bex_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lïjë iya te, “Bo ëdï kote dɔ bilaka dökïꞌdï kënyë naga nima ŋgï pili yaga. Kina bo ti kari koꞌde bilaka mɔtɔ ga ꞌjaa ꞌdɔ kako koꞌdɔ ndɔbɔ yïmo. Ya ame ga ꞌdɔ kutï tiꞌdi döŋgërï ma ꞌba bo ko mï kada mo ne.” ");
INSERT INTO bex_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yësu iya te, “Ïdëkïke dë su di mï buku ꞌba Bɔkoꞌba? Ame kiya te, ‘Döku tönë bɔ koꞌba rö ni kilagi pa di rɔmo ne na kileki ꞌdeni rɔ döku ma laka rɔ dɔ kiteli mï gbɔndɔ ꞌba rö. Ame wa koꞌdɔ ꞌba Bɔkoꞌba na. Dotɔke ŋgï rɔ gɔze.’” ");
INSERT INTO bex_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Kina Yësu kileki gbï kiya zïnnï, bo iya te, “Rɔ ma laka miya ziye, ti kogba ŋere löbu ꞌba Bɔkoꞌba yaga di ziye kiꞌdi zi bilaka ma laka ame ga kutï toꞌdɔ akoꞌdɔkɔ mo ne.” ");
INSERT INTO bex_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kina ɔdɔ löbu ꞌba bɔ akumu ni ti Parosi ni kuwö lende nime ꞌdeni te tine, lïjë ikali ŋgï Yësu ëdï rɔ tiya lïjë. ");
INSERT INTO bex_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kina lïjë koꞌdɔkɔ ŋgï tindaꞌba bo, tine lïjë ere tïndï naga nima römöyï tïndï naga nima pili iya Yësu rɔ bɔ kumë lende ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yësu ebe ŋgï tilende zi bilaka naga nima rɔ dɔŋgala. ");
INSERT INTO bex_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Bo iya te, “Ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ a nime te. Mï kada ma dɔ kɔtɔ mɔtɔ bɔ dɔliŋɔ mɔtɔ ëdï ꞌdeni koꞌdɔ karama ꞌba gbe ꞌba kole abo. ");
INSERT INTO bex_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kina bo koja bɔ laja abo ga ŋgï kari tiya mo zi ŋba ame ga pili ꞌdɔ kako mï karama nima ne gɔ lïjë kako. Tine lïjë ilagi ëꞌbënnï ŋgï tako. ");
INSERT INTO bex_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kina bo koja bɔ laja abo mɔtɔ ga ꞌböwu ti ndose nime, kiya te, ‘Ari kiyake zi ŋba naga nima, mileŋo rɔma ꞌdeni ndö. Mumu ŋgulö ꞌdeni gbï ti muruku ma kɔnɔ naga. Wa pili ëdï ꞌdeni ndö, lïjë kako ti mï karama nime.’ ");
INSERT INTO bex_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tine ŋba mo naga nima onyɔ lende abo nima dë kɔtɔ te, lïjë usë ëꞌbënnï za ti kɔri ꞌbënnï ga. Mɔtɔ ari abo za mï nyaka abo, mɔtɔ ari abo za mï ndɔbɔ abo, ");
INSERT INTO bex_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","kina yɔ ya mɔtɔ mo ga indaꞌba ꞌbënnï bɔ laja naga nima ŋgï komba kupö yaga. ");
INSERT INTO bex_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kina kata ŋgï mï bɔ dɔliŋɔ bo koja bɔ kanya abo ga ŋgï kari kote dɔ bɔ kupö wa naga nima koŋma gawo mo yaga. ");
INSERT INTO bex_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kina bo kïdëkï bɔ laja abo ga ŋgï, bo kiya zïnnï, bo iya te, ‘Wa ꞌba karama ꞌba gbe ma ëdï ꞌdeni ndö tine ŋba ma tönë ga kose ne ɔꞌbɔ dë ꞌdɔ kɔdɔ yïmo. ");
INSERT INTO bex_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Arike kpa dɔkoka kɔri ꞌdɔ kotɔtɔke ma konzi kako mï karama nime kɔzɔ ame koꞌjake ne tara.’ ");
INSERT INTO bex_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kina bɔ laja naga nima kari ŋgï dɔkoka kɔri kotɔtɔ bilaka ame ga pili lïjë koꞌja ne, ma laka kpaki ti ma kënyë. Kina mï rö ꞌba karama nima koso ŋgï lɔ ti ŋba. ");
INSERT INTO bex_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kina ɔdɔ bɔ dɔliŋɔ kari ꞌdeni toŋgɔ ŋba abo naga nima tine bo ari koꞌja bɔ mɔtɔ yayi rɔ ma sari kinza bɔŋgɔ ꞌba gbe rɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kina bo kititi bɔ nima iya te, ‘Bɔ pɔri ma, ako ꞌbëyï di yala kɔdɔ bine kinza bɔŋgɔ ꞌba gbe röyï tara?’ Tine bɔ nima ileki dɔmo dë du te. ");
INSERT INTO bex_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kina bɔ dɔliŋɔ kiya ŋgï zi bɔ laja abo ga, iya te, ‘Indaꞌbake bo kudöduke közï bo ti ndï bo kuꞌduke bo yaga mï bi kölu ꞌdɔ bo kari kudu kunyï kpa bo yayi.’” ");
INSERT INTO bex_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yësu iya te, “Ti kïdëkï ꞌdeni ŋgï ŋbaŋi tine ma ndö na ŋge ti kigeli di yïmo.” ");
INSERT INTO bex_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parosi mɔtɔ ga ari kususu kpënnï ꞌdɔ toꞌba Yësu ti akititi mɔtɔ ga. ");
INSERT INTO bex_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kina lïjë koja bɔ kösö gönnï mɔtɔ ga ti bilaka ꞌba Erode ga ŋgï kari zi bo. Kina lïjë kari kiya te, “Bɔ kɔmɔ kiyandi, dikali ŋgï nï na rɔ bɔ kiya lende ma kodɔrɔ. Kina nï na ŋgï rɔ bɔ kiyandi kɔri ꞌba lende ꞌba Bɔkoꞌba nime rɔ ma kodɔrɔ zi bilaka, kugö kpëyï dë gbï zi bɔtɔ. Römöyï di zïyï bilaka pili rɔ ma koriya. ");
INSERT INTO bex_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kina me iya te zize, tara ne ëdï ŋgï rɔ ma laka mï kɔri ꞌba köꞌdu kiꞌdi ꞌba Bɔkoꞌba ꞌdɔ topi awada zi bɔ dɔliŋɔ ma löbu ꞌba Romo, ala tondo?” ");
INSERT INTO bex_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tine Yësu ikali dɔŋgala ꞌbënnï nima ꞌdeni mɔlo, kina bo kiya te, “Kpe bɔ kɔmɔ kandi naga nime, ëddï kiyɔzɔke ma gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ilemeke gïrïsï ꞌba topi awada nime te zö.” Kina lïjë koꞌde kïnë gïrïsï mo ŋgï zi bo. ");
INSERT INTO bex_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kina bo kititi lïjë, iya te, “Kïnë yë mo ti möyï yë na me rɔmo ne?” ");
INSERT INTO bex_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lïjë iya te, “Kïnë ti möyï bɔ dɔliŋɔ ꞌba Romo na.” Yësu iya te, “Kina me, wa ame ga rɔ ꞌba bɔ dɔliŋɔ ne opike abo zi bo. Kina wa ame ga rɔ ꞌba Bɔkoꞌba ne opike zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kina ɔdɔ lïjë kuwö ꞌdeni tara tine lïjë otɔ ŋgï rɔ gönnï. Kina lïjë kënyï ŋgï kari di rɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mï kada kɔtɔ mo nima na Sadoke mɔtɔ ga kako kiya zi Yësu tëgë a mɔtɔ rɔ tɔdɔ ꞌba töku di mï tölë inza. ");
INSERT INTO bex_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kina lïjë kititi bo, iya te, “Bɔ kɔmɔ kiyandi, Musa ugu lende iya te, ɔdɔ bɔ mɔtɔ kölë ŋgï kinza köyö kole dë, bɔ löndö mo kɔdɔ gɔ ꞌja mo nima ꞌdɔ lïjë köyö kole pötö bɔ ma kölë nima. ");
INSERT INTO bex_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ne oŋgɔ te, ya mɔtɔ ga modɔmorïyö rɔ löndö kɔtɔ oloma pa bine. Kole ma dɔgba mo ogbe ꞌja kina bo kölë ŋgï kola ꞌja nima kinza köyö kole. Kina bo kola makuruꞌbë abo tönë ŋgï zi löndö bo. ");
INSERT INTO bex_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kina lende kɔtɔ nime koꞌdɔ rönï ŋgï gbï tara zi löndö bo ma mï rïyö mo ŋbö kömö zi ma mï modɔmorïyö mo. ");
INSERT INTO bex_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kina di pötö lïjë nima pili na ꞌja tönë kölë ŋgï gbï. ");
INSERT INTO bex_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tine mï tɔdɔ ꞌba töku di mï tölë lɔko ti këdï rɔ ꞌja ꞌba yë? Ame ya naga nime pili modɔmorïyö kogbe lɔko ꞌdeni ne ya?” ");
INSERT INTO bex_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yësu ileki dɔmo zïnnï, iya te, “Kpe öluke lende ꞌdeni sowa. Römöyï ikalike buku ꞌba Bɔkoꞌba dë kina tigɔ abo ꞌba Bɔkoꞌba ikalike dë gbï. ");
INSERT INTO bex_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mï kada ame ɔdɔ töku ni kɔdɔ ꞌdeni di mï tölë lïjë ogbe ꞌja dë kpe kina ꞌja gbï ogbe mëꞌdë dë kpe. Lïjë pili ꞌdeni ŋgï kɔzɔ malayika ꞌba mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ïdëkïke lende nime Bɔkoꞌba kiya ziye gɔ lende ꞌba tɔdɔ ꞌba töku ne dë du? Ame bo kiya te, ");
INSERT INTO bex_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ma na rɔ Bɔkoꞌba ꞌba Abarayama, Bɔkoꞌba ꞌba Yisika kina gbï rɔ Bɔkoꞌba ꞌba Yakoba.’ Gɔ köꞌdu mo na dikali ŋgï lïjë inza kpe rɔ töku Bɔkoꞌba ïdïdï lïjë ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kina ɔdɔ tïndï naga nima kuwö lende nime ꞌdeni te tine lende ꞌba akiyandi abo nima igayi lïjë ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kina ɔdɔ Parosi ni kuwö ꞌdeni Yësu kaꞌda Sadoke naga nima tara tine, na lïjë kotɔtɔ rönnï ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kina bɔ ma kɔtɔ di mï löŋgö lïjë ame bo na rɔ bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ne kari ŋgï tiyɔzɔ Yësu ti akititi. ");
INSERT INTO bex_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Bo iya te, “Bɔ kɔmɔ kiyandi, köꞌdu kiꞌdi ꞌba Bɔkoꞌba ma yala na kulöwö rɔ dɔ kiteli?” ");
INSERT INTO bex_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yësu iya te, “‘Ɔꞌɔ ŋere Bɔkoꞌba ꞌbï ti mïyï pili ti tigɔ ꞌbï pili kina gbï ti meri ꞌba döyï pili.’ ");
INSERT INTO bex_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ame na rɔ köꞌdu kiꞌdi ame kulöwö rɔ dɔ kiteli ne. ");
INSERT INTO bex_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kina köꞌdu kiꞌdi mɔtɔ ma kulöwö ame rɔ ma mï rïyö mo na me, ‘Ɔꞌɔ lëpï yï mɔtɔ kɔzɔ ame kɔꞌɔ yida röyï ne tara.’ ");
INSERT INTO bex_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Köꞌdu kiꞌdi rïyö naga nime na köꞌdu kiꞌdi ꞌba Musa ni pili ti akiyandi ꞌba bɔ kumë lende ni kɔrɔ dɔmo.” ");
INSERT INTO bex_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kina ɔdɔ Parosi mɔtɔ ga kotɔtɔ rönnï ꞌdeni bi kɔtɔ tine, Yësu ititi lïjë, ");
INSERT INTO bex_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","iya te, “Ma di mï meri ꞌbe Kurïsïtö ame Bɔkoꞌba këdï koja ne bo di mï kupö yë mo ga?” Lïjë iya te, “Bo di mï kupö Dawidi.” ");
INSERT INTO bex_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yësu ënyï kileki zïnnï, iya te, “Ne ɔdɔ këdï tara gɔ waꞌdi na Nyï Kɔtɔ Laka kiꞌdi Dawidi ꞌböwu kïdëkï bo rɔ ŋere abo? Römöyï Dawidi iya te, ");
INSERT INTO bex_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ŋere Bɔkoꞌba iya zi ŋere ma, iya te, “Oloma dɔ dörï ma bine ŋbö miꞌdi yi kaꞌda bɔ ya ꞌbï ga.”’ ");
INSERT INTO bex_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ne ɔdɔ Dawidi kebe kïdëkï bo ꞌdeni ꞌböwu rɔ ŋere abo tine bo ti kileki ꞌböwu rɔ kole zi Dawidi totondo mo ga?” ");
INSERT INTO bex_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bɔtɔ mɔtɔ ɔꞌbɔ dë kpe tileki dɔ lende nime zi Yësu. Kina ŋgï di gɔmo pele bɔtɔ mɔtɔ ilaŋa rönï dë kpe tititi kpa Yësu. ");
INSERT INTO bex_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kina Yësu kilende zi tïndï naga nima gbï ti bɔ kösö gɔ bo ga. ");
INSERT INTO bex_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Bo iya te, “Parosi ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni na ꞌdeni rɔ bɔ dɔ köꞌdu kiꞌdi ꞌba Musa. ");
INSERT INTO bex_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kina laka ꞌdɔ kuwöke dönnï ti, kösöke gɔ wa ame ga pili lïjë këdï kiya ziye ne. Tine kinza kogbake görö ꞌba wa ma lïjë këdï koꞌdɔ naga nima dë. Römöyï lïjë oꞌdɔ wa ame ga lïjë këdï kiyandi kɔmɔ bilaka timo ne dë kɔtɔ te. ");
INSERT INTO bex_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lïjë iꞌdi akïrïndï ame ga bɔtɔ kɔꞌbɔ dë tombi mo ne dɔ bilaka. Pele tara ꞌdɔ lïjë koja dɔkole közïnnï ma kɔtɔ ra pele ŋge kokɔnyi tombi mo timo ne inza yɔ. ");
INSERT INTO bex_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Lïjë öꞌbö toꞌdɔ wa pili ŋge ꞌdɔ bilaka koŋgɔ lïjë gɔmo. Oŋgɔ ma lïjë koꞌdɔ dökulë ꞌbënnï ga ame lïjë këdï kulölï rɔ makpɔtɔ titi ame lende ꞌba mï buku ꞌba Bɔkoꞌba na kugu yïmo ne kudöꞌbö te, gbï ti ma kudödu kɔnyɔ mo ga. Kina oŋgɔ gbï bi nziya ꞌba kpa bɔŋgɔ ꞌbënnï ga ma kidakpa te. ");
INSERT INTO bex_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Akoꞌdɔkɔ ꞌbënnï mï kada ꞌba karama rɔ tikiti rönnï ŋgila bɔ dɔ karama ꞌdɔ bilaka koro lïjë. Kina gbï di mï rö ꞌba mötu bi koꞌdɔkɔ ꞌbënnï rɔ kïtï ma laka naga nima dɔgba ne. ");
INSERT INTO bex_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kina ɔdɔ lïjë këdï kiliŋgere kebe mï bi ꞌba ndögö akoꞌdɔkɔ ꞌbënnï ꞌdɔ bilaka pili kumötö lïjë kɔzɔ bɔ rɔ koro, kïdëkï lïjë rɔ bɔ kɔmɔ kiyandi. ");
INSERT INTO bex_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kinza kiꞌdike dë bilaka kebe tïdëkï ye rɔ bɔ kɔmɔ kiyandi römöyï kpe pili rɔ löndö, kina bɔ kɔmɔ kiyandi ꞌbe ëdï ŋge kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kina kinza kïdëkïke bɔtɔ mɔtɔ dë di dɔyayi bine rɔ baba. Römöyï ëddïke ŋge ti ꞌbu kɔtɔ kpökï mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kinza kiꞌdike bɔtɔ kïdëkï ye dë gbï rɔ löbu. Römöyï löbu ꞌbe na ŋge kɔtɔ kpökï rɔ Kurïsïtö ame Bɔkoꞌba këdï koja ne. ");
INSERT INTO bex_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Römöyï bɔ ame mbiri löbu di mï löŋgö ye ne bo na gɔ këdï rɔ bɔ laja ziye. ");
INSERT INTO bex_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kina bɔ ma köꞌbö toꞌdɔ rɔ bo rɔ wa löbu ti kileki ꞌdeni bërï, kina bɔ ma kileki rɔ bo bërï ti kombi ꞌdeni tɔrɔ.” ");
INSERT INTO bex_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Buꞌbu ziye kpe bɔ kɔmɔ kiyandi ni ti Parosi ni, kpe bɔ kɔmɔ kandi naga nime. Uꞌbëke kpadörï ꞌba dɔyayi ꞌba mïtɔrɔ ka le rɔ ma sari di zi bilaka kinza ma kɔdɔke dë teyi yɔ. Kina me olake ya ma koꞌdɔkɔ tɔdɔ teyi naga dë kpe gbï yɔ ꞌdɔ kɔdɔ. ");
INSERT INTO bex_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Buꞌbu ziye kpe bɔ kɔmɔ kiyandi ni ti Parosi ni, kpe bɔ kɔmɔ kandi naga nime. Ilakike kpaki kebe gönyï mini löbu kebe mï dɔyayi pili toma bilaka kɔtɔ ŋge ame ꞌdɔ kiꞌdi dönï gɔ lende ꞌbe. Kina ɔdɔ koꞌjake ꞌdeni kina kiꞌdike bo ŋgï kilaꞌba mï lende kënyë ame rɔ dɔ kiteli kebe ꞌbeye ma ꞌdɔ kuꞌdu ye gɔmo mï paꞌdo ꞌba Gehena ne. ");
INSERT INTO bex_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Buꞌbu ziye kpe bɔ kɔmɔ kölu kiterike tokɔkɔ lëpï ye naga nime. Mï akiyandi ꞌbe iyake te ɔdɔ bɔ mɔtɔ kulömu rɔ bo ti rö löbu ꞌba Bɔkoꞌba lömu nima oꞌdɔ ɔtɔ dë. Ne ɔdɔ bo kulömu rɔ bo ti yamo köbököbö ꞌba mï rö löbu ꞌba Bɔkoꞌba nima, lömu nima udödu bo ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kpe bɔ kɔmɔ kölu rumö naga nime. Wa ma yala na kulöwö rɔ dɔ kiteli? Yamo köbököbö ꞌba yïmo ala rö löbu ꞌba Bɔkoꞌba mo na ma kiꞌdi yamo mo nima këdï kulöwö rɔ ma koro? ");
INSERT INTO bex_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kina gbï iyake te ɔdɔ bɔ mo kulömu rɔ bo ti bi ꞌba akumu lömu abo nima oꞌdɔ ɔtɔ dë. Ne ɔdɔ bo kulömu rɔ bo ti kpa közï ma kiꞌdi dɔmo mo, lömu nima udödu bo ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kpe bɔ kɔmɔ kölu naga nime, wa ma yala na kulöwö rɔ dɔ kiteli? Kpa közï ma kiꞌdi dɔmo, ala bi ꞌba akumu mo na ma kiꞌdi kpa közï kiꞌdi mo këdï rɔ ma koro? ");
INSERT INTO bex_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Römöyï bɔ ame kulömu rɔ bo ꞌdeni ti bi ꞌba akumu, bo ulömu rɔ bo ꞌdeni timo kpaki ti kpa közï kiꞌdi ma dɔmo. ");
INSERT INTO bex_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kina gbï ɔdɔ bo kulömu rɔ bo ti rö löbu ꞌba Bɔkoꞌba, bo ulömu rɔ bo ꞌdeni timo gbï ti Bɔkoꞌba ame bo na këdï koloma yïmo yayi ne. ");
INSERT INTO bex_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kina gbï ɔdɔ bɔ mo kulömu rɔ bo ti mïtɔrɔ bo ulömu rɔ bo ꞌdeni ti kïtï löbu ꞌba Bɔkoꞌba gbï ti bo Bɔkoꞌba mo ma këdï koloma dɔmo. ");
INSERT INTO bex_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Buꞌbu ziye kpe bɔ kɔmɔ kiyandi ni ti Parosi ni, kpe bɔ kɔmɔ kandi naga nime, dɔdoro ame ga pele wötï ne iꞌdike kapa ma ꞌbutë mo gbï zi Bɔkoꞌba. Tine akiyandi ma dɔ kiteli di mï köꞌdu kiꞌdi ame rɔ toꞌdɔ burë rɔ ma kodɔrɔ gbï ti mï koŋmi ti lende koꞌdɔ laka ne na kolake za yaga. Wa naga nime na ꞌdɔ koꞌdɔke ra pili kinza tola mɔtɔ mo. ");
INSERT INTO bex_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kpe bɔ kɔmɔ kölu kiterike tokɔkɔ lëpï ye naga nime. Kina ŋgï tara, ebeke toga kɔŋɔ na yaga di dɔ mini ziye tine gamele na kuwëke kindiyɔke timo. ");
INSERT INTO bex_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Buꞌbu ziye kpe bɔ kɔmɔ kiyandi ni ti Parosi ni, kpe bɔ kɔmɔ kandi naga nime. Gɔ kösu ti gɔ kitaꞌba ꞌbe ga na ŋge kurögöke rɔ ma kɔpɔ, tine yïmo lɔ ti wa ame ga koꞌdeke ti közï kasi ti mï kututu ꞌbe ga ne. ");
INSERT INTO bex_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kpe Parosi kɔmɔ kölu naga nime, mï kösu ꞌbe ga na ꞌdɔ kurögöke titi dɔgba kina gɔmo ti këdï ŋgï gbï rɔ ma kɔpɔ. ");
INSERT INTO bex_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Buꞌbu ziye bɔ kɔmɔ kiyandi ni ti Parosi ni, kpe bɔ kɔmɔ kandi naga nime. Kpe ŋgï kɔzɔ dögö ma koꞌba kaŋmi kele naga tara. Ame kinda rɔ ma kele di yaga tine yïmo yayi lɔ ti kiliŋba töku ma keŋme ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kina gbï tara di rɔye yaga indake rɔ bilaka ma laka tine mïye lɔ ti kɔmɔ kandi ni ti lende kënyë. ");
INSERT INTO bex_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Buꞌbu ziye bɔ kɔmɔ kiyandi ni ti Parosi ni, kpe bɔ kɔmɔ kandi naga nime. Ileŋoke dögö bɔ kumë lende ꞌba Bɔkoꞌba kele rɔ dɔ kiteli, kina kïyöruke raba ꞌba ya ma rɔ bɔ lende laka naga ŋgï rɔ mbëmbë. ");
INSERT INTO bex_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kina gbï iyake te ma këddïke ra ti ꞌbu ye löbu ga mï kada nima yayi dëne inza kodɔꞌbɔke rɔye tïnnï toꞌdɔ wa naga nime lïjë koꞌdɔ ne. Ame lïjë kupö bɔ kumë lende naga nime ne. ");
INSERT INTO bex_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kina me kilemeke rɔye ꞌdeni rɔ kole ꞌba kole ꞌba bɔ akupö tönë ga. ");
INSERT INTO bex_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kina ti oteke kɔsɔ eꞌbe ame ꞌbu ye löbu ga kisaki bïcï mo ꞌdeni mɔlo ziye ne. ");
INSERT INTO bex_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kpe kole ꞌba murë naga nime, rɔ ma tondo mo na ꞌdɔ kɔmɔke kinza ma kodɔ karama ꞌba Gehena dɔye? ");
INSERT INTO bex_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne kina me mëdï miya ziye, ti moja bɔ kumë lende ti bɔ kikali lende ti bɔ kɔmɔ kiyandi mɔtɔ ga kako ziye. Kina ti kupöke mɔtɔ ga, kutötïke mɔtɔ ga gbï kina ti kombake mɔtɔ ga di mï rö ꞌba mötu kuwïtïke nduwë rɔ ma kolɔlɔ di mï gawo. ");
INSERT INTO bex_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kina gɔ köꞌdu mo roma bɔ lende laka pili ti kileki dɔye, kisaki mɔlo di rɔ roma Abele bɔ lende laka ŋbö kömö mï roma Zakariya kole ꞌba Barakiya ame kupöke mï löŋgö rö löbu ꞌba Bɔkoꞌba ma ti bi ꞌba akumu ne. ");
INSERT INTO bex_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Rɔ ma laka miya ziye roma bɔ lende laka naga nime ti kileki dɔye kpe bilaka ma leꞌjete naga nime.” ");
INSERT INTO bex_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Buꞌbu zïyï nï Yerosalema, Yerosalema, ote dɔ bɔ kumë lende ni ꞌdeni kuꞌdu bɔ laja ꞌba Bɔkoꞌba ma koja zïyï naga ti döku. Ti mopi rɔma ŋgï ŋbö mï ndö göyï na ꞌjaa ꞌdɔ mokoko kole ꞌbï naga nima yï soromo ma kɔzɔ ꞌba töru ame kokoko kole ꞌbënï ga ne tara? Tine öꞌbö tuꞌdöŋï döyï mökö. ");
INSERT INTO bex_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kina me ti kola rö ꞌbï ꞌdeni zïyï rɔ roba. ");
INSERT INTO bex_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rɔ ma laka miya zïyï, inza koꞌja ma kpe ŋbö kiya te, ‘Yëyï këdï dɔ bɔ ame kako ti möyï ŋere Bɔkoꞌba ne.’” ");
INSERT INTO bex_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kina ɔdɔ Yësu kɔdɔ ꞌdeni yaga di mï reki ꞌba rö löbu ꞌba Bɔkoꞌba bo këdï kari ꞌdeni tine, na bɔ kösö gɔ bo ga kebe ŋgï tubï gɔ rö koꞌba nima zi bo. ");
INSERT INTO bex_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tine bo iya te, “Oŋgɔke ꞌdeni laka? Rɔ ma laka mëdï miya ziye, mï kada mo dayi döku ma kɔtɔ inza kileke mï gɔ bi ꞌbënï. Bɔ ya ti kïtïŋï ꞌdoyi bërï.” ");
INSERT INTO bex_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kina ɔdɔ Yësu kari ꞌdeni dɔ döku ꞌba Bilaya tine na bɔ kösö gɔ bo ga kako zi bo rɔ dönnï tititi bo. Lïjë iya te, “Ïyëtï te zize, wa naga nime ti koꞌdɔ rönnï nyanya ga? Kina waꞌdi mo ga na ti koꞌdɔ rönnï ame ꞌdɔ këdï rɔ akileme ꞌba tako ꞌbï ame rɔ ŋburuŋburu ꞌba dɔliŋɔ ne?” ");
INSERT INTO bex_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yësu ileki dɔmo zïnnï, iya te, “Olomake ti bi koda kinza kiꞌdike bɔtɔ kuꞌbölu ye dë. ");
INSERT INTO bex_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Römöyï ma konzi ti kako ti möyï ma kiya te, ‘Ma na rɔ Kurïsïtö.’ Kina lïjë ti kuꞌbölu ma konzi mɔtɔ ga ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ti kuwöke birɔ ya di ŋgɔsi kina gbï ti lëbï mo ma di bi kɔwɔ. Tine kinza kereke dë römöyï wa naga nime pili ti koꞌdɔ rönnï titi, tine ŋburuŋburu ꞌba dɔliŋɔ na dë gba. ");
INSERT INTO bex_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Römöyï bilaka ame ga rɔ kupö kɔtɔ ne ti kënyï ꞌdeni toꞌdɔ ya ti bilaka mɔtɔ. Kina dɔliŋɔ ti kënyï gbï toꞌdɔ ya ti dɔliŋɔ mɔtɔ. Kina sëyï ti kïzïkïzï ti këdï ꞌdeni ŋgï mï gɔ bi pili. ");
INSERT INTO bex_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wa naga nime pili ti koꞌdɔ rönnï ŋgï tara rɔ tisaki ꞌba gomɔ kɔzɔ tisaki ꞌba tɔꞌɔ ꞌba kole. ");
INSERT INTO bex_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kina lïjë ti kebe tindaꞌba ye koto zi bɔ burë ni ꞌdɔ kodɔ karama dɔye kupö ye yaga. Laki pili ti koꞌji ye gɔ lende ma. ");
INSERT INTO bex_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kina ma konzi mɔtɔ ga di mïye ti koga kpënnï gɔma kebe tususu lëpï nnï ga koꞌji gbï. ");
INSERT INTO bex_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kina bɔ kumë lende dɔ kïndëndë ma konzi ti kënyï ŋgï kuꞌbölu ma konzi mɔtɔ ga. ");
INSERT INTO bex_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lende kënyë ti kitaꞌba ꞌdeni kote gɔ bi kina ti akɔꞌɔ ꞌba ya ma konzi kölu ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tine bɔ ame kiꞌdi mï bo këddï teyi ŋbö kömö mï kada ꞌba tote mo ti kɔmɔ ŋgï di mï tölë. ");
INSERT INTO bex_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kina laja laka ꞌba ŋere löbu ꞌba Bɔkoꞌba nime ti kïyëlë rönï ꞌdeni ŋgï toko mï dɔliŋɔ nime, römöyï ꞌdɔ bɔtɔ ga pili kuwö, kina ꞌjaa ti ŋburuŋburu ꞌba dɔliŋɔ nime kömö.” ");
INSERT INTO bex_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kina ti koꞌjake kuruku kënyë tönë Danyele bɔ kumë lende ꞌba Bɔkoꞌba kiya köꞌdu mo ne ꞌdeni. Bo ti kari kɔrɔ mï rö löbu ꞌba Bɔkoꞌba kirasi yaga. (Ame ugu zi bɔ kïdëkï mo ga ꞌdɔ kikali.) ");
INSERT INTO bex_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kina ꞌdɔ ya ame ga mï Yudayi ne kiriŋa ti kusu dönnï mï döku. ");
INSERT INTO bex_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bɔ ame këdï yaga tindawo rɔ bo ne kinza dɔ bo kïlëyï dë kpe tɔdɔ titi rö togba wa abo ga. ");
INSERT INTO bex_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kinza bɔ ame këdï ꞌdeni mï nyaka ne kileki dë kpe kari liŋɔ togba bɔŋgɔ abo. ");
INSERT INTO bex_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ti këdï rɔ gomɔ ma löbu mï kada mo nima zi ꞌja ame ga rɔ ma kɔmɔ ne. Kina ti këdï gbï rɔ gomɔ ma löbu zi ꞌja ame ga ti kole gba këdï kulu mba ne. ");
INSERT INTO bex_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tine ititike Bɔkoꞌba kinza bo kiꞌdi kada ꞌba riŋa ꞌbe nime dë këdï mï kada ꞌba bi këyï ame rɔ alïrï ne. Kina kinza kiꞌdi dë gbï këdï mï kada ꞌba rɔ kindawo. ");
INSERT INTO bex_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Römöyï gomɔ ꞌba mï kada mo nima ti këdï ŋgï rɔ dɔ kiteli di dɔ gomɔ mɔtɔ ga ame pele këdï koꞌdɔ rönnï bine mɔlo di bi tisaki mo ne tara ŋbö kömö mï kada nime tɔne. Kina a mɔtɔ ma kɔzɔ ame te inza kpe nati. ");
INSERT INTO bex_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tine Bɔkoꞌba ileki gɔ töꞌdö mo ꞌdeni ŋge mbowa. Ma kinza tara, dëne bɔtɔ inza kɔmɔ. Tine Bɔkoꞌba ti kileki gɔ töꞌdö mo ꞌdeni ŋge tara gɔ köꞌdu ꞌba ya ame ga bo kigeli ꞌdeni ne. ");
INSERT INTO bex_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kina ɔdɔ bɔtɔ kiya pele ziye, kiya te, ‘Oŋgɔ te, Kurïsïtö na me,’ ala ‘Kina me ꞌdë,’ kinza kiꞌdi döyï dë gɔmo kɔtɔ te. ");
INSERT INTO bex_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Römöyï ya mɔtɔ ga ti kebe ꞌdeni tidewo rönnï tëgë lïjë na rɔ Kurïsïtö. Kina bɔ kumë lende dɔ kïndëndë mɔtɔ ga ti kënyï ꞌdeni gbï, kina lïjë ti koꞌdɔ gɔ kotɔ ma kinza kiya naga ꞌdeni gbï ti wa ame ga köꞌdu mo ga kigayi bilaka ne, römöyï ꞌdɔ tiyɔzɔ tuꞌbölu ya ame ga pele rɔ ma Bɔkoꞌba kigeli ꞌdeni ne timo. ");
INSERT INTO bex_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kina me uwöke laka mëdï miya ame ꞌdeni ziye mɔlo gba tötï te. ");
INSERT INTO bex_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kina ꞌdɔ ɔdɔ bilaka këdï kiya pele te, ‘Bo ëdï yï mökö ꞌdë yayi,’ kinza karike eꞌbe dë. Ala kiya te, ‘Bo ëdï rö bine,’ kinza kiꞌdike eꞌbe dɔye dë gɔmo. ");
INSERT INTO bex_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Römöyï tako ꞌba kole ꞌba bilaka lesi ëdï kako kɔzɔ kpa tɔrɔ kunyï ame köbö di yïbï ŋbö kala dɔ tɔrɔ ne tara. ");
INSERT INTO bex_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bi ame ti töku teyi raŋga ti kotɔtɔ kpënnï ŋgï teyi.” ");
INSERT INTO bex_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tine welo di pötö gomɔ ꞌba mï kada mo naga nima na kada ti kuyï rönï ŋgï rɔ ma kölu kina nyepe gbï aŋmi dë kpe. Kina ti kiyaya këlu ni ꞌdeni kilayi bërï di mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kina kïnë akileme ꞌba tako ꞌba kole ꞌba bilaka lesi ti kinda ŋgï mïtɔrɔ. Kina dɔ kupö pili ꞌba dɔliŋɔ nime ti koꞌja kïnë kole ꞌba bilaka lesi ꞌdeni këdï kako ti pɔli ꞌba mïtɔrɔ mï tigɔ ꞌba löbu dɔ kiteli abo kina ti lïjë kudu ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Birɔ tɔtɔti ma kembe ti kudu. Kina bo ti koja malayika abo ga mï dɔ kumu sowɔ ꞌba dɔliŋɔ nime tutöꞌdu ya ame ga bo kigeli ꞌdeni ne. Kina lïjë ti kutöꞌdu ŋgï di mï kapa dɔliŋɔ ma te ŋbö kömö ꞌdë.” ");
INSERT INTO bex_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Iꞌdike ŋgërï këlu kiyandi ye. Ɔdɔ koŋgɔ rɔ dɔŋgila mo ga këdï köyö solɔrɔ ꞌdeni mbili mo këdï kunzï nima ikali ŋgï kpa dökïkërï ɔwɔ dë kpe. ");
INSERT INTO bex_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kina gbï tara ɔdɔ koŋgɔke wa naga nime ꞌdeni këdï koꞌdɔ rönnï nima ziye tikali mo ŋgï kada ꞌba tako ꞌba kole ꞌba bilaka lesi ɔwɔ dë kpe. ");
INSERT INTO bex_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rɔ ma laka mëdï miya ziye, wa naga nime ti koꞌdɔ rönnï gba kota bilaka ma leꞌjete naga nime kote dönnï dë. ");
INSERT INTO bex_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mïtɔrɔ ni ti dɔliŋɔ ti kiteli tine lende ma inza kote rönï du kɔtɔ te.” ");
INSERT INTO bex_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tako ꞌba kada mo nima bɔtɔ ma kɔtɔ ikali dë. Malayika ꞌba mïtɔrɔ pele ikali dë. Kina kole ꞌba Bɔkoꞌba pele ikali dë gbï. Bo Bɔkoꞌba ꞌbu na ŋge kikali abo. ");
INSERT INTO bex_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tako ꞌba kole ꞌba bilaka lesi ti këdï ŋgï kɔzɔ wa ma koꞌdɔ rönï mï kada ꞌba Nowa. ");
INSERT INTO bex_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Römöyï gba kinza mini koso kako dë dɔyayi, bilaka oloma ꞌdeni rɔ tonyo kpënnï tuwë wa gbï togbe rönnï kala ŋbö kömö mï kada nima Nowa këkï mï sorope ne. ");
INSERT INTO bex_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Lïjë ikali a mɔtɔ ma këdï koꞌdɔ rönï dë ŋbö mini koso kudï lïjë pili yaga. Kina ti këdï ŋgï gbï tara mï kada ꞌba tako ꞌba kole ꞌba bilaka lesi. ");
INSERT INTO bex_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mï kada mo nima bilaka rïyö ti këdï ꞌdeni mï nyaka tine ti kogba mɔtɔ kola ma kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kina gbï tara ꞌja rïyö ti këdï ꞌdeni dɔ toto, tine ti kogba mɔtɔ kola ma kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kina ti olomake ti bi koda römöyï ikalike kada ame ŋere ꞌbe këdï kako yïmo ne dë. ");
INSERT INTO bex_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kina kɔzɔ ma kikalike, ma kiya te bɔ dɔ liŋɔ këdï kikali kada ame bɔ ꞌbögö këdï kako yïmo ne ra, dëne bo inza köꞌdö. Bo ti koloma rɔ ma koŋgɔ bi ti bi koda kinza bɔ ꞌbögö kodowe bi ra mï rö abo. ");
INSERT INTO bex_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kina kpe gbï tara olomake ndö ti bi koda römöyï kole ꞌba bilaka lesi ëdï kako mï kada ame komerike dë ꞌdɔ bo kako yïmo ne.” ");
INSERT INTO bex_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Omerike lende ꞌba bɔ laja ma laka rɔ bɔ lende kikali tɔ ma. Bo na rɔ bɔ ame bɔ dönnï kiꞌdi bo mbiri dɔ lëpï bo ga toŋgɔ gɔmo ꞌdɔ tiꞌdi akonyo ꞌbënnï zïnnï mï saa ma laka mo. ");
INSERT INTO bex_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ti këdï rɔ lɔŋɔ ma löbu zi bɔ laja nima ɔdɔ bɔ dönnï kako koꞌja bo këdï toꞌdɔ mo tara. ");
INSERT INTO bex_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rɔ ma laka miya ziye, bo ti kiꞌdi bɔ laja nima ŋgï ꞌdɔ këdï mbiri dɔ wa ꞌba mï liŋɔ abo ga pili. ");
INSERT INTO bex_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ne ɔdɔ bɔ laja nima këdï rɔ bɔ laja ma kënyë bo ti kiya zi gbagba bo, bo kiya te, ‘Aa, löbu ma ëdï kigabi yayi, bo inza kako ca.’ ");
INSERT INTO bex_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kina bo kebe ŋgï tomba bɔ laja lëpï bo naga nima, bo konyo kpa bo kari tuwë mo ti bɔ layi ni. ");
INSERT INTO bex_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kina löbu ti kömö ŋgï mï kada ame bo komeri dë ꞌdɔ löbu abo nima kömö yïmo ne. ");
INSERT INTO bex_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kina löbu abo nima ti komba bo ŋgï kuꞌdu bo mï löŋgö bɔ kɔmɔ kandi ni mï bi ꞌba monɔ ni ti kpa kunyï.” ");
INSERT INTO bex_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yësu iya te, “Mï kada mo nima ŋere löbu ꞌba Bɔkoꞌba ti këdï kɔzɔ dɔŋgala ꞌba yïtötï ꞌbutë mɔtɔ ga tara, ame lïjë kogba lamba ꞌbënnï ga lïjë kari turë dɔ ꞌjɔkɔ ne. ");
INSERT INTO bex_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tine ma muyï rɔ rumö, ma muyï mɔtɔ ga na rɔ bɔ lende kikali. ");
INSERT INTO bex_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ya ma rɔ rumö naga nime ogba lamba ꞌbënnï ga tine ogba ꞌbu mɔtɔ dë teyi. ");
INSERT INTO bex_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tine ya ma rɔ bɔ lende kikali mo ga ogba ꞌbu ꞌbënnï ga teyi mï guru. ");
INSERT INTO bex_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kina ɔdɔ ꞌjɔkɔ nima kigabi ꞌdeni kömö dë titi welo tine, lïjë pili iꞌdi ga tinano ŋgï, kina köꞌdö ga ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mï zana bi ꞌdeni tine na birɔ kudu ŋgï, iya te, ‘ꞌJɔkɔ ömö ꞌdeni. Ɔdɔke turë dɔmo.’ ");
INSERT INTO bex_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kina yïtötï ꞌbutë tönë ga kënyï ŋgï tileŋo lamba ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kina ya ma rɔ rumö tönë ga kënyï kiya zi ya ma rɔ bɔ lende kikali naga nima, iya te, ‘Iꞌdike ꞌbu ꞌbeye mɔtɔ zize, römöyï lamba ꞌbeze ga ëdï ꞌdeni kölu.’ ");
INSERT INTO bex_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tine ya ma rɔ bɔ lende kikali naga nima ileki dɔmo, iya te, ‘Ame ɔꞌbɔ ze dë kpaki tiye, ne laka arike zi bɔ ndögö ꞌdɔ kugöke zi gbagba ye.’ ");
INSERT INTO bex_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kina yïtötï ma rumö tönë ga kënyï ŋgï kari tugö ꞌbu. Tine di pötö lïjë kari ꞌdeni yɔ na ꞌjɔkɔ kömö ŋgï. Kina yïtötï ma muyï tönë ga këdï ꞌbënnï ꞌdeni ndö ne kɔdɔ ŋgï kɔtɔ ti bo mï karama ꞌba gbe kina kurögö kpadörï ŋgï teyi. ");
INSERT INTO bex_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mbowa ꞌdeni tine na yïtötï ma tönë ga kömö ŋgï kina lïjë kïdëkï, iya te, ‘Ŋere, ŋere, urögö kpadörï zize.’ ");
INSERT INTO bex_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ꞌJɔkɔ ileki dɔmo, iya te, ‘Mikali ye dë kɔtɔ te.’” ");
INSERT INTO bex_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yësu ileki gɔmo, iya te, “Kina ti olomake ti bi koda römöyï kada ꞌba tako ꞌba ŋere ꞌbe ikalike dë.” ");
INSERT INTO bex_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mï kada mo nima ŋere löbu ꞌba Bɔkoꞌba ti këdï kɔzɔ bɔ mɔri mɔtɔ ame kënyï kari dɔ liŋgere ne tara. Di mï tënyï abo bo ïdëkï bɔ laja abo ga kako zi bo. Kina bo kose gɔ wa abo ga ŋgï pili zïnnï. ");
INSERT INTO bex_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Bo oza yamo me zïnnï rɔ gege kɔzɔ ame ꞌdɔ lïjë kɔꞌbɔ toŋgɔ gɔmo ne tara. Bo iꞌdi ꞌba bɔ mɔtɔ kïsï ꞌbutë, ꞌba bɔ mɔtɔ kïsï sowɔ kina ꞌba bɔ mɔtɔ kïsï rïyö. Kina bo kënyï ŋgï kari dɔ liŋgere abo nima. ");
INSERT INTO bex_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kina bɔ ma tönë kogba ꞌba bo kïsï ꞌbutë ne koloma ŋgï toꞌdɔ ndɔbɔ nduwë timo bo kiꞌdi dɔmo köyö teyi ꞌböwu kïsï ꞌbutë. ");
INSERT INTO bex_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kina bɔ ma kogba kïsï sowɔ tönë koꞌdɔ gbï tara, bo iꞌdi dɔmo köyö gbï teyi kïsï sowɔ. ");
INSERT INTO bex_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tine bɔ ma tönë kogba ꞌba bo kïsï rïyö ne, ari kole gö ŋgï na bo kusu yamo ꞌba ŋere abo nima koloma le te yïmo yayi. ");
INSERT INTO bex_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kina koꞌja gɔmo kigabi ꞌdeni tara tine na bɔ dönnï tönë kileki ŋgï kako tititi gɔ yamo tönë ga di zïnnï. ");
INSERT INTO bex_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kina bɔ laja ma tönë kogba kïsï ꞌbutë ne kako ŋgï kɔmɔ bo, kina bo koꞌde kïsï ꞌbutë mɔtɔ ŋgï gbï kiꞌdi dɔmo, iya te, ‘Ŋere ma, iꞌdi yamo tönë zö kïsï ꞌbutë, oŋgɔ te kina me miꞌdi dɔmo köyö ꞌdeni teyi gbï kïsï ꞌbutë.’ ");
INSERT INTO bex_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ŋere abo iya te, ‘Ele sowa, nï bɔ laja ndɔbɔ laka nime, oloma ꞌdeni laka toŋgɔ gɔ wa mbowa nime, na laka ti miꞌdi yi këddï ti közï kakpa toŋgɔ gɔ wa ma mbiri. Ako koloma kɔtɔ tö bine mï lɔŋɔ ma nime.’ ");
INSERT INTO bex_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kina bɔ laja ma tönë kogba kïsï sowɔ ne kako ŋgï kɔmɔ bo, iya te, ‘Ŋere ma, iꞌdi yamo tönë zö kïsï sowɔ, oŋgɔ te kina me miꞌdi dɔmo köyö ꞌdeni teyi gbï kïsï sowɔ.’ ");
INSERT INTO bex_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ŋere abo iya te, ‘Ele sowa, nï bɔ laja koꞌdɔ ndɔbɔ laka nime, oloma ꞌdeni laka toŋgɔ gɔ wa ma mbowa nime, ne laka ti miꞌdi yi këddï ti közï kakpa toŋgɔ gɔ wa ma mbiri. Ako koloma kɔtɔ tö bine mï lɔŋɔ ma nime.’ ");
INSERT INTO bex_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kina bɔ laja ma tönë kogba kïsï rïyö ne kako ŋgï kɔmɔ bo, iya te, ‘Ŋere ma, mikali yi nï rɔ bɔ mï kata, gɔ bi ame ga nï na dë pele kulï kupö teyi ne, umu amo ga ŋgï zïyï. Wa ame ga nï na dë pele kubö yïmo ne omɔmi ŋgï zïyï. ");
INSERT INTO bex_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mere lende ꞌbï ga kina mari mole gö ŋgï mikeki yamo ꞌbï tönë yïmo. Kina me, ëꞌbï na me ogba yayi.’ ");
INSERT INTO bex_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tine ŋere abo ileki dɔmo, iya te, ‘Nï bɔ laja dɔ kënyë bɔ tïkëpï nime. Ikali ma mumu wa di gɔ bi ame ga ma na dë mulï kupö mo ne? Kina ikali ma momɔmi wa ame ga ma na dë mubö ne? ");
INSERT INTO bex_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ne ma këdï tara oto yamo ma nime dë gɔ waꞌdi zi bɔ ndögö ꞌdɔ bo kugö wa timo ꞌdɔ mako moꞌja dɔmo köyö ꞌdeni mbowa teyi?’ ");
INSERT INTO bex_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kina ŋere kilende ŋgï zi bɔ laja abo ga, iya te, ‘Ogbake yamo nima yaga di zi bo ꞌdɔ kiꞌdike zi bɔ nime ti kïsï ꞌbutë rïyö ne. ");
INSERT INTO bex_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Römöyï bɔ ame këdï pele timo rɔ mbëmbë ti kogba gbï kiꞌdi doroꞌdo dɔmo ꞌdɔ bo këdï timo rɔ dɔ kiteli. Ne bɔ ame kinza timo ma mbowa ame zi bo yayi ne ti kogba yaga. ");
INSERT INTO bex_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kina ogbake bɔ laja yawa nime kuꞌduke bo yaga mï bi kölu bi ꞌba monɔ ni ti kpa kunyï.’” ");
INSERT INTO bex_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kina me miya ziye, ɔdɔ kole ꞌba bilaka lesi këdï kako ꞌdeni mï löbu abo ti malayika pili, bo ti koloma ꞌdeni dɔ kïtï dɔ kiteli abo. ");
INSERT INTO bex_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kina ti kotɔtɔ bilaka ꞌba dɔ kupö naga nime ꞌdeni pili di mï dɔ kumu sowɔ ꞌba dɔliŋɔ nime koꞌde kako kɔmɔ bo. Kina bo ti koza lïjë ꞌdeni di rɔ lëpï nnï kɔzɔ bɔ koda wa ma këdï koza kamölö di rɔ banya tara. ");
INSERT INTO bex_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bo ti kiꞌdi bɔ lende laka dɔ dörï bo tine bo ti kiꞌdi ama ga dɔ gali bo. ");
INSERT INTO bex_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kina bo ti kilende zi lïjë ame ga dɔ dörï bo ne, iya te, ‘Akoke kpe ame ꞌbu ma Bɔkoꞌba koꞌdɔ yëyï ꞌdeni dɔye ne. Ako kindaꞌbake dɔliŋɔ ame kileŋo ꞌdeni ziye mɔlo di bi tisaki ꞌba dɔliŋɔ nime ne. ");
INSERT INTO bex_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Römöyï ma rɔ ꞌbö kpe na kiꞌdike akonyo zö. Ma ti koda mini kpe na kiꞌdike zö muwë. Ma rɔ bɔ löwö kpe na kotake ma rɔ ŋba. ");
INSERT INTO bex_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma rɔ ma sari rɔ gɔ ŋbululu kpe na kusuke bɔŋgɔ rɔma. Kina mëdï dɔ rɔkɔꞌɔ kpe na kakoke toŋgɔ gɔma, mï maboso kpe na kakoke tori ma.’ ");
INSERT INTO bex_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tine bɔ lende laka naga nima ti kënyï kititi bo, iya te, ‘Wu ŋere, doꞌja yi rɔ ꞌbö ala ti koda mini nyanya mo ga na diꞌdi akonyo zïyï ala mini zïyï kuwë ya? ");
INSERT INTO bex_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Doꞌja yi rɔ bɔ löwö nyanya mo ga na dota yi rɔ ŋba liŋɔ ze, ala rɔ ma sari rɔ gɔ ŋbululu na dusu bɔŋgɔ röyï ya? ");
INSERT INTO bex_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Doꞌja yi dɔ rɔkɔꞌɔ nyanya mo ga ala mï maboso na dako tori yi ya?’ ");
INSERT INTO bex_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tine ŋere ti kileki dɔmo, iya te, ‘Rɔ ma laka miya ziye, wa naga nime kolomake toꞌdɔ mo pele zi löndö ma kɔtɔ mɔtɔ ame ga wötï rɔ lisa ne ma na koꞌdɔke ꞌdeni zö.’ ");
INSERT INTO bex_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kina bo ti kënyï kilende zi ya ama ga dɔ gali ne, iya te, ‘Ënyïke karike yaga di rɔma, kpe ame kulömu ye ꞌdeni tari mï paꞌdo ma ŋburuŋburu ame kileŋo ꞌdeni zi Satani ni ti malayika ma ꞌba bo ga ne. ");
INSERT INTO bex_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Römöyï mëdï pele rɔ ꞌbö iꞌdike ɔtɔ dë zö, ma ti koda mini iꞌdike dë zö muwë. ");
INSERT INTO bex_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma rɔ bɔ löwö kina otake ma dë yɔ rɔ ŋba, ma rɔ ma sari rɔ gɔ ŋbululu usuke bɔŋgɔ dë rɔma. Ma dɔ rɔkɔꞌɔ kina gbï mï maboso orike ma dë.’ ");
INSERT INTO bex_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tine lïjë ti kititi gbï, iya te, ‘Wu ŋere, doꞌja yi nyanya mo ga rɔ ꞌbö ala ti koda mini ala rɔ bɔ löwö ala rɔ ma sari rɔ gɔ ŋbululu ala dɔ rɔkɔꞌɔ ala mï maboso kina dokɔnyi yi dë ya?’ ");
INSERT INTO bex_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kina ŋere ti kileki dɔmo, iya te, ‘Rɔ ma laka miya ziye, wa naga nime oꞌdɔke dë du zi löndö ma kɔtɔ mɔtɔ ga ame wötï rɔ lisa ne, ma na ma koꞌdɔke dë ꞌdeni gbï zö.’ ");
INSERT INTO bex_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kina lïjë ti kari ꞌbënnï ŋgï mï paꞌdo ma ŋburuŋburu, tine bɔ lende laka ni ti kari ꞌbënnï ŋgï mï dïdï ma ŋburuŋburu.” ");
INSERT INTO bex_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kina ɔdɔ Yësu kote tiyandi wa naga nime ꞌdeni pili tine na bo kiya zi bɔ kösö gɔ bo ga, iya te, ");
INSERT INTO bex_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kɔzɔ ma kikalike töꞌdö ꞌba karama ꞌba Pasaka ola ꞌdeni ŋge dɔ rïyö. Kina ti kiꞌdi kole ꞌba bilaka lesi ꞌdeni ŋgï közï ya mɔtɔ ga kutötï bo.” ");
INSERT INTO bex_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mï kada mo nima na löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni kotɔtɔ kpënnï ŋgï liŋɔ ꞌba Kayapa bɔ dɔ bɔ akumu. ");
INSERT INTO bex_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kina lïjë kususu kpënnï ŋgï ꞌdɔ tindaꞌba Yësu lowo kupö yaga. ");
INSERT INTO bex_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tine lïjë iya te, “Kinza doꞌdɔke dë mï kada ꞌba karama nime kinza bilaka koꞌdɔ ayayi.” ");
INSERT INTO bex_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kina ɔdɔ Yësu këdï ꞌdeni Betaniya mï liŋɔ ꞌba bɔ mɔtɔ kïdëkï rɔ Simona Bɔ Mönyu tine, ");
INSERT INTO bex_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","na ꞌja mɔtɔ kako ŋgï ti kizaza ma kele ꞌba ꞌbu ame ndögö kitigɔ kulöwö naga. Kina lɔko kinzanza ŋgï dɔ Yësu di kpa akonyo yayi. ");
INSERT INTO bex_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tine ɔdɔ bɔ kösö gɔ bo ga koꞌja tara lïjë ënyï ŋgï rɔ ꞌdïrï. Lïjë iya te, “Irasi wa nime te gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ꞌBu nime oꞌja dëne ꞌdɔ kugö ra mökö gɔ koꞌja yamo timo rɔ mbëmbë ꞌdɔ kokɔnyi bɔ lisa timo.” ");
INSERT INTO bex_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tine Yësu ikali lende ꞌbënnï nima ꞌdeni mɔlo, kina bo kileki zïnnï, bo iya te, “Ëddï koŋbeŋbeke ꞌja nima gɔ waꞌdi? Lɔko oꞌdɔ wa ma kele rɔ mbëmbë ꞌdeni zö. ");
INSERT INTO bex_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Römöyï bɔ lisa ni ëdï koloma nduwë tiye bine. Ne ma ꞌbama minza möꞌbö tiye bine. ");
INSERT INTO bex_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lɔko odɔ ꞌbu nime ꞌdeni rɔma ꞌdɔ kileŋo rɔma ndö koda dɔ tusu ma. ");
INSERT INTO bex_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rɔ ma laka mëdï miya ziye, gɔ bi ame ga pili laja laka ma nime këdï kïyëlë rönï teyi mï dɔliŋɔ nime ne, wa nime lɔko koꞌdɔ ne ti kiya ꞌdeni nduwë tomeri gönï timo.” ");
INSERT INTO bex_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kina bɔ ma kɔtɔ di mï löŋgö ya ma ꞌbutë dɔmorïyö tönë ga ame mo kïdëkï möyï mo rɔ Yuda Isikarita ne kënyï ŋgï kari zi löbu ꞌba bɔ akumu ni. ");
INSERT INTO bex_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Bo iya te, “Waꞌdi ga na ti kiꞌdike zö ɔdɔ miꞌdi közï Yësu ziye?” Kina lïjë kïtëtë gïrïsï siliŋbi ŋgï ꞌbutë mota kiꞌdi zi bo. ");
INSERT INTO bex_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kina ŋgï mï saa mo nima na Yuda kiꞌdi ŋgï toma kɔri ma laka ame ꞌdɔ bo kiꞌdi közï Yësu timo zïnnï ne. ");
INSERT INTO bex_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kina mï kada ma dɔndende ꞌba karama ma këdï konyo maŋgolɔꞌbɔ mo kinza laŋga gɔmo nima na bɔ kösö gɔ Yësu ga kako zi bo kiya te, “Oꞌdɔkɔ ꞌdɔ dileŋo gɔ bi ꞌba tonyo karama nime zïyï yala?” ");
INSERT INTO bex_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bo iya te, “Arike mï gawo yayi zi bɔ tönë ꞌdɔ kiyake zi bo te, ‘Bɔ kɔmɔ kiyandi iya te, kada abo ꞌdeni ŋɔli bo ti koꞌdɔ karama nime liŋɔ ꞌbï ti bɔ kösö gɔ bo ga.’” ");
INSERT INTO bex_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kina lïjë kari koꞌdɔ ŋgï kɔzɔ lende ame bo kose gɔmo zïnnï ne tara. Lïjë ileŋo a ꞌba karama ŋgï yayi. ");
INSERT INTO bex_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mï dɔkɔpiyari ꞌdeni na Yësu ni koloma ŋgï bërï kpa akonyo lïjë ti bɔ kösö gɔ bo ga ma ꞌbutë dɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kina ɔdɔ lïjë këdï ꞌdeni kpa akonyo tine na bo kiya te, “Rɔ ma laka mëdï miya ziye, bɔ ma kɔtɔ mɔtɔ di mï löŋgö ye nima bina na këdï kari kususu ma.” ");
INSERT INTO bex_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kina lïjë ŋgï pili rɔ meri lïjë kebe tititi bo me rɔ kɔtɔkɔtɔ, iya te, “Ma mo na dë ŋgï ɔtɔ ya, ŋere?” ");
INSERT INTO bex_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yësu iya te, “Bɔ ame ŋgï këdï kusu közï bo aa mï lebe kɔtɔ tö ne na ŋgï këdï kususu ma. ");
INSERT INTO bex_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kole ꞌba bilaka lesi ëdï kölë ŋgï kɔzɔ lende ma tönë kugu mï buku ꞌba Bɔkoꞌba gɔ köꞌdu abo ne tara. Tine buꞌbu zi bɔ ma kususu bo nima. Ma laka mo dëne ꞌdɔ köyö bo dë ka ndeŋi.” ");
INSERT INTO bex_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kina Yuda bɔ ma kari kususu bo mo tönë kënyï kititi iya te, “Ma na dë ŋgï ɔtɔ ya, ŋere?” Yësu iya te, “Nï na kiya ëꞌbï tara.” ");
INSERT INTO bex_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kina ɔdɔ lïjë këdï ꞌdeni kpa akonyo yayi tine, na Yësu kogba maŋgolɔꞌbɔ ŋgï kileki yëëꞌdï mo zi Bɔkoꞌba na bo konye ŋgï kiꞌdi zi bɔ kösö gɔ bo ga. Bo iya te, “Me, ogba konyo. Ame na rɔ yida rɔma.” ");
INSERT INTO bex_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kina bo kogba kösu bo kileki yëëꞌdï mo. Kina bo kiꞌdi zïnnï, bo iya te, “Rɔ gɔye pili uwëke di yïmo. ");
INSERT INTO bex_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Römöyï ame na rɔ roma ma ame kulöwu ꞌdeni gɔ ma konzi tola mo gɔ lende kënyë. Ame kina lömu ꞌba Bɔkoꞌba kɔrɔ ꞌdeni dɔmo ne. ");
INSERT INTO bex_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Minza muwë akuwë nime kpe, tine ti muwë ma laꞌja ꞌjaa tiye mï kada mo di mï ŋere löbu ꞌba ꞌbu ma.” ");
INSERT INTO bex_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kina ɔdɔ lïjë koba ŋgala ꞌdeni na lïjë kari ŋgï dɔ döku ꞌba Bilaya. ");
INSERT INTO bex_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kina Yësu kiya zïnnï, iya te, “Mï korɔndɔ nime tɔne ëddï kiriŋake me di rɔma. Römöyï ugu ꞌdeni mɔlo mï buku ꞌba Bɔkoꞌba iya te, ‘Ti mupö bɔ koda kamölö yaga, kina dɔtumu ꞌba kamölö ti kitaꞌba ŋgï.’ ");
INSERT INTO bex_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ne ɔdɔ mënyï mɔdɔ ꞌdeni yaga di mï tölë ti mari dɔgba kɔmɔye mï Galilaya.” ");
INSERT INTO bex_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pïtörö ënyï kiya zi bo, iya te, “Ma ꞌbama minza mola göyï ɔdɔ ya ma laki pili kola göyï pele.” ");
INSERT INTO bex_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yësu ileki dɔmo zi Pïtörö, iya te, “Rɔ ma laka mëdï miya zïyï, mï korɔndɔ nime tɔne gba kinza gɔŋgɔ kidapa dë, ëddï koga kpëyï gɔ lende ma ŋbö mï mota, kiya te ikali ma dë.” ");
INSERT INTO bex_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pïtörö iya te, “Ɔdɔ koꞌdɔkɔ pele tupö ma kɔtɔ tïyï minza moga kpama.” Kina bɔ kösö gɔ Yësu mɔtɔ mo naga nima kiya gbï pili tara. ");
INSERT INTO bex_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kina Yësu kënyï kari ŋgï tïnnï mï gɔ bi mɔtɔ kïdëkï rɔ Getesemane. Kina bo kiya zïnnï, bo iya te, “Olomake tötï bine, mëdï mari mbowa dɔgba tilende zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bo ogba Pïtörö ni ti kole rïyö ꞌba Zebedayo ga kari timo. Kina meri kiꞌdi toso ŋgï mï bo kumïkï bo. ");
INSERT INTO bex_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kina bo kiya ŋgï zïnnï, bo iya te, “Meri oso ꞌdeni ŋgï yïmö kɔzɔ ëdï kupö ma. Olomake bine ti bi koda kɔtɔ tö.” ");
INSERT INTO bex_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kina bo kari mbowa dɔgba na bo kolɔdɔ bërï kutuꞌbö kɔmɔ bo bërï tilende zi Bɔkoꞌba. Bo iya te, “Baba, ɔdɔ ꞌdɔ kɔꞌbɔ ŋgï toꞌdɔ mo tara, iyese kösu ꞌba gomɔ nime yaga di kɔmɔ ma. Tine kinza koꞌdɔ dë gɔ akoꞌdɔkɔ ma tine oꞌdɔ ŋge gɔ akoꞌdɔkɔ ꞌbï.” ");
INSERT INTO bex_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kina ɔdɔ bo kileki kako zi bɔ kösö gɔ bo tönë ga tine bo ako koꞌja lïjë köꞌdö ꞌdeni. Kina bo kiya zi Pïtörö, bo iya te, “Kpe nime, gɔ waꞌdi na kɔꞌbɔke dë toda bi tö pele ŋge mï saa kɔtɔ ya? ");
INSERT INTO bex_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Olomake ti bi koda ti mötu koꞌdɔ kinza koto ye ra mï akiyɔzɔ. Rɔ ma laka mï oꞌdɔkɔ ŋgï tine yida rɔ tigɔ mo inza.” ");
INSERT INTO bex_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kina bo kari ꞌböwu ꞌdeni rɔ mï rïyö mo nati tilende zi Bɔkoꞌba. Bo iya te, “Baba, ɔdɔ kiya te tiyese kösu nima yaga koꞌdɔ rönï rɔ a ma kinza ne ꞌdɔ muwë ŋgï titi du, iꞌdi akoꞌdɔkɔ ꞌbï koꞌdɔ rönï.” ");
INSERT INTO bex_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kina bo kileki ꞌböwu kako koꞌja bɔ kösö gɔ bo tönë ga këdï gbï bi töꞌdö. Römöyï lïjë ëdï ꞌdeni ŋgï kinano rɔ tinano. ");
INSERT INTO bex_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kina bo kënyï ꞌböwu kari tilende zi Bɔkoꞌba ꞌdeni rɔ mï mota mo nati, gbï tiya lende kɔtɔkɔtɔ tönë ga. ");
INSERT INTO bex_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kina bo kileki kako gbï zïnnï, bo kiya te, “Ëddïke gba bi töꞌdö tindawo rɔye? Saa mo ɔꞌbɔ ꞌdeni ame ꞌdɔ kiꞌdi kole ꞌba bilaka lesi közï bɔ lende kënyë. ");
INSERT INTO bex_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ënyïke tɔrɔ darike. Oŋgɔke te, bɔ ma kususu ma mo tönë bo ömö ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kina ɔdɔ Yësu këdï gba kilende te tine, na Yuda kömö ŋgï. Bo rɔ ma kɔtɔ mɔtɔ di mï löŋgö ya ma ꞌbutë dɔmorïyö naga nima. Bo ako ti tïndï ꞌba bilaka ma konzi gɔ bo, ya mɔtɔ ga ꞌbënnï ti mbele mɔtɔ ga ti mɔbɔ. Ya naga nima löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka na koja lïjë. ");
INSERT INTO bex_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda bo iya dɔŋgala mo ga ꞌdeni mɔlo zïnnï te, “Bɔ ame ɔdɔ koŋgɔke mari mome mbili mo nima bo na. Kina ꞌdɔ kindaꞌbake bo ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kina bo kako zi Yësu, bo kiya te, “Ŋere ma, mötö zïyï.” Kina bo kome mbili Yësu ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yësu iya te, “Bɔ pɔri ma, ako titi gɔ waꞌdi?” Kina lïjë kako kindaꞌba Yësu ŋgï nyowi. ");
INSERT INTO bex_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kina bɔ mɔtɔ ame këdï ti Yësu yayi ne kënyï ŋgï kotɔ mbele abo koga dɔ bɔ laja mɔtɔ ꞌba bɔ dɔ bɔ akumu timo. Kina koke mbili mo ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tine Yësu iya te, “Ileki mbele ꞌbï gɔ bi mo. Römöyï lïjë ame ga pili kindaꞌba mbele ti kölë dɔ mbele. ");
INSERT INTO bex_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Omeri ꞌbëyï iya te, ɔdɔ mititi ꞌbu ma bo ti kokɔnyi ma dë? Ɔdɔ mititi, bo ëdï koja tïndï ꞌba malayika ma konzi ŋgï kako welo zö. ");
INSERT INTO bex_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ne ɔdɔ këdï ꞌdeni tara ꞌböwu dëne ti koꞌdɔ rönï tondo kɔzɔ lende ame kugu mï buku ꞌba Bɔkoꞌba ame kiya te ꞌdɔ koꞌdɔ rönï te ne?” ");
INSERT INTO bex_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kina Yësu kilende zi tïndï tönë ga, iya te, “Akoke ti mbele ni ti mɔbɔ tindaꞌba ma kɔzɔ bɔ ꞌbögö tara ya? Me moloma tiyandi bilaka rɔ kɔmɔ kada mï reki ꞌba rö löbu ꞌba Bɔkoꞌba ne indaꞌbake ma dë di yayi gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ne ame oꞌdɔ rönï ꞌdeni ꞌdɔ këdï kɔzɔ lende ma tönë bɔ kumë lende ni kugu mï buku ꞌba Bɔkoꞌba ne.” Kina bɔ kösö gɔ bo ga kitaꞌba ëꞌbënnï ŋgï kiriŋa kola bo. ");
INSERT INTO bex_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bɔ kindaꞌba Yësu naga nima oto bo kari liŋɔ ꞌba Kayapa bɔ dɔ bɔ akumu. Gɔ bi nima na bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ti löbu ꞌba bilaka ni kotɔtɔ dönnï ꞌdeni teyi. ");
INSERT INTO bex_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tine Pïtörö ozi nduwë gɔ Yësu rɔ ma kɔwɔ ŋbö bo kɔdɔ mï liŋɔ ꞌba bɔ dɔ bɔ akumu nima. Bo ɔdɔ mï liŋɔ koloma ŋgila bɔ kanya naga nima yayi toŋgɔ ŋburuŋburu ꞌba lende nima. ");
INSERT INTO bex_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kina löbu ꞌba bɔ akumu ni ti turu naga nima pili kotɔŋi rönnï rö yayi ne koloma ŋgï toma lende bëtï mɔtɔ ame ꞌdɔ kodɔrɔ bïcï lende timo rɔ Yësu ne, ꞌdɔ kupö bo gɔmo. ");
INSERT INTO bex_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tine bɔ kodɔrɔ bïcï lende ma bëtï ma konzi mɔtɔ ga ako pele lïjë oꞌja lende ma kodɔrɔ ɔtɔ mo dë du te. Kina rɔ ŋburuŋburu mo na ya ma rïyö mɔtɔ ga kako ");
INSERT INTO bex_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kiya te, “Bɔ nime iya te, bo ëdï kɔꞌbɔ tïyëyï rö löbu ꞌba Bɔkoꞌba yaga kina bo ti koꞌba kileki teyi mï töꞌdö dɔ mota.” ");
INSERT INTO bex_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kina bɔ dɔ bɔ akumu nima kënyï kititi bo, iya te, “Inza ti dɔ lende kileki mɔtɔ gɔ susu nime ya naga nime këdï koꞌdɔ röyï ne?” ");
INSERT INTO bex_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tine Yësu utï abo dë. Kina bɔ dɔ bɔ akumu nima kileki kiya zi bo, iya te, “Ulömu röyï di kɔmɔ ma bine ti möyï Bɔkoꞌba bɔ dɔ dïdï, kiya zize ɔdɔ nï na ŋgï rɔ Kurïsïtö kole ꞌba Bɔkoꞌba ame koja di mïtɔrɔ ne.” ");
INSERT INTO bex_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yësu iya te, “Nï na kiya ëꞌbï tara. Ne rɔ ma laka mëdï miya ziye, ti koꞌjake kole ꞌba bilaka lesi ꞌdeni koloma kada mɔtɔ dɔ dörï Bɔkoꞌba tigɔ dɔ kiteli këdï kako bërï di mïtɔrɔ ti pɔli.” ");
INSERT INTO bex_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kina ɔdɔ bɔ dɔ bɔ akumu nima kuwö lende nime te yɔ na bo kirica bɔŋgɔ ŋgï yaga di rɔ bo, bo iya te, “Uwöke dölï abo nima ꞌdeni? Doꞌdɔkɔ a mɔtɔ rɔ bɔ kodɔrɔ bïcï lende rɔ bo dë kpe. Kpe nime pili uwöke dölï abo nima ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tine waꞌdi na komerike ꞌbeye gɔmo?” Lïjë iya te, “Bo irasi lende ꞌdeni, bo kölë ŋgï yaga.” ");
INSERT INTO bex_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kina lïjë kotoꞌbi woro ŋgï kɔmɔ bo kina komba bo ŋgï. Ya ma kokɔsɔ bo naga nima ebe tiya mo tëgë, ");
INSERT INTO bex_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nï Kurïsïtö, umë te zize, yë na kokɔsɔ yi?” ");
INSERT INTO bex_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tine Pïtörö ëdï gba mï liŋɔ yayi. Kina nyiti mɔtɔ ame rɔ bɔ laja ꞌba bɔ dɔ bɔ akumu ne kako kiya te, “Oꞌja nï gbï ti Yësu ꞌba Galilaya ꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tine Pïtörö andi gɔmo di kɔmɔ lïjë pili, iya te, “Mikali eꞌbe tɔ nima këddï kiyake ne dë.” ");
INSERT INTO bex_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kina bo kënyï kari yaga kpa reki. Kina nyiti mɔtɔ ame gbï rɔ bɔ laja yayi ne kako gbï koꞌja bo. Kina lɔko kiya zi ya ama ga yayi ne tëgë, “Bɔ nime bo gbï ti Yësu ꞌba Nazareta.” ");
INSERT INTO bex_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kina bo kileki dɔmo gbï kandi gɔmo kiya te, “Mulömu rɔma, rɔ ma laka mikali bɔ nima dë.” ");
INSERT INTO bex_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kina mbowa ꞌböwu na ya ma këdï kɔrɔ yayi naga nima kako zi bo, iya te, “Rɔ ma laka nï lëpï ꞌba bɔ nima na gbï römöyï kpa nima këddï kilende timo ne na kileme yi ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tine Pïtörö iya te, “Ece mïtɔrɔ ne, mikali bɔ nima dë.” Kina gɔŋgɔ kidapa ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kina Pïtörö komeri gɔ lende ꞌba Yësu tönë ŋgï, ame bo kiya te, “Gba kinza gɔŋgɔ kidapa dë ti koga kpëyï gɔma mï mota.” Kina bo kënyï ŋgï kari kudu rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mɔlo mï dɔŋbɔ mo nima na löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni kususu kpënnï ŋgï rɔ Yësu ꞌdɔ kupö yaga. ");
INSERT INTO bex_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kina lïjë kudödu bo ŋgï koto kari zi Pilato turu bɔ dɔliŋɔ ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kina ɔdɔ Yuda bɔ susu tönë kuwö ꞌdeni kodɔ kpa Yësu ꞌdeni tupö mo tara tine, bo otɔ dɔ bo ŋgï di mï lende kënyë abo nima. Kina bo kari ŋgï ti gïrïsï ꞌbutë mota tönë kileki zi löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni. ");
INSERT INTO bex_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Bo iya te, “Moꞌdɔ lende kënyë ꞌdeni sowa ti tususu bɔ kinza kirasi ɔtɔ nime ꞌdɔ kupö yaga.” Lïjë iya te, “Ama ndɔbɔ ze na dë kpe, ꞌbëyï na ꞌdeni yayi.” ");
INSERT INTO bex_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kina Yuda kulï gïrïsï nima ŋgï bërï mï rö löbu ꞌba Bɔkoꞌba yayi. Kina bo kɔdɔ ŋgï kari kosi mugu bo yaga. ");
INSERT INTO bex_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Löbu ꞌba bɔ akumu ni utöꞌdu gïrïsï nima, tine lïjë iya te, “Gïrïsï nime ꞌdeni rɔ gïrïsï ꞌba roma. Inza kpe rɔ ma laka mï kɔri ꞌba köꞌdu kiꞌdi ze ꞌdɔ tiꞌdi mo mï yamo ꞌba rö löbu ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kina ɔdɔ lïjë kote lende mo ꞌdeni kɔrɔ dɔmo tine, lïjë ari kugö nyaka kënyë ꞌba bɔ laꞌba mɔtɔ ŋgï timo, ꞌdɔ këdï rɔ bi ꞌba tusu bɔ löwö teyi. ");
INSERT INTO bex_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Gɔ köꞌdu mo na ꞌdɔ kïdëkï nyaka nima rɔ nyaka ꞌba roma nduwë ŋbö koꞌja kabate ne. ");
INSERT INTO bex_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kina me oꞌdɔ rönï ꞌdeni ꞌdɔ këdï kɔzɔ wa ma tönë Yeremaya bɔ kumë lende ꞌba Bɔkoꞌba kiya ne tara, ame kiya te, “Lïjë ogba gïrïsï siliŋbi ꞌbutë mota ko gɔ ndögö ame bilaka mo ga Yisarele ni kɔrɔ ꞌdeni dɔmo ꞌdɔ kugö bo timo ne. ");
INSERT INTO bex_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kina lïjë kiꞌdi kugö nyaka ꞌba bɔ laꞌba ŋgï timo kɔzɔ ame ŋgï Bɔkoꞌba kiꞌdi köꞌdu mo zö ne.” ");
INSERT INTO bex_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tine Yësu ɔrɔ ꞌdeni kɔmɔ Pilato turu bɔ dɔliŋɔ yayi. Kina bo kënyï kititi Yësu, iya te, “Nï na rɔ ŋere bɔ dɔliŋɔ ꞌba Yudayi?” Yësu iya te, “Nï na kiya ëꞌbï tara.” ");
INSERT INTO bex_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kina ɔdɔ löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni kebe pele tususu bo tine bo ileki dɔmo dë. ");
INSERT INTO bex_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kina Pilato kiya te, “Uwö lende naga nime këdï kususu yi timo ne dë?” ");
INSERT INTO bex_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tine Yësu ileki dɔ lende nima dë kɔtɔ te. Gɔ köꞌdu mo na lende mo kigayi Pilato ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Römöyï mï kada ꞌba karama ꞌba Pasaka pili turu bɔ dɔliŋɔ nima öꞌbö nduwë tope bilaka kɔtɔ yaga di mï maboso rɔ bɔ ame bilaka kiteri ꞌdɔ koja ne. ");
INSERT INTO bex_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tine mï kada nima yayi bɔ maboso ma dɔ kïlëbï mɔtɔ kïdëkï möyï mo rɔ Yësu Baraba ëdï mï maboso yayi. ");
INSERT INTO bex_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kina ɔdɔ tïndï kotɔtɔ rönnï ꞌdeni yayi Pilato ititi lïjë, iya te, “Bɔ ma yala na koꞌdɔkɔke ꞌdɔ moja ziye? Yësu Baraba, ala Yësu ame kïdëkï rɔ Kurïsïtö ne?” ");
INSERT INTO bex_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Römöyï bo ikali rɔ ma laka löbu ꞌba Yudayi ni ombi mïnnï rɔ Yësu na ma lïjë kiꞌdi közïmo zi bo ne. ");
INSERT INTO bex_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kina kota Pilato këdï gba dɔ kïtï ꞌba burë yayi tine na ꞌja abo koja laja ŋgï zi bo, iya te, “Kinza koꞌdɔ a ma kɔtɔ mɔtɔ te dë zi bɔ kinza kirasi ɔtɔ nima, römöyï ti korɔndɔ ene nyï oŋbeŋbe ma sowa gɔ köꞌdu abo.” ");
INSERT INTO bex_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tine löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni ocɔ ŋgï zi tïndï naga nima ꞌdɔ kititi Baraba na ꞌdɔ kope, tine ꞌdɔ kupö Yësu yaga. ");
INSERT INTO bex_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato ënyï kititi tïndï naga nima ꞌböwu gbï, iya te, “Di mï löŋgö ya rïyö naga nime, bɔ ma yala na koꞌdɔkɔke ꞌdɔ mope ziye?” Lïjë iya te, “Baraba.” ");
INSERT INTO bex_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato iya te, “Ne ꞌdɔ moꞌdɔ waꞌdi zi Yësu ame kïdëkï rɔ Kurïsïtö ne ya?” Lïjë pili iya te, “Utötï bo.” ");
INSERT INTO bex_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tine Pilato ileki kititi, iya te, “Ne lende kënyë waꞌdi na bo kirasi ya?” Tine lïjë ulörï ŋgï rɔ ma kembe, iya te, “Utötï bo.” ");
INSERT INTO bex_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kina ɔdɔ Pilato koŋgɔ lende nima ꞌdeni ŋgï dɔmo kinza tara tine, za ꞌdɔ koꞌde ayayi, kina bo kogba mini ŋgï kurögö közï bo timo di kɔmɔ tïndï naga nima. Bo iya te, “Közö rɔ ma kɔpɔ di mï roma bɔ nime. Omake eꞌbe rɔye timo.” ");
INSERT INTO bex_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tïndï naga nima pili ileki dɔmo, iya te, “Roma bo kɔrɔ ka ŋgï dɔze gbï dɔ kole ze ga.” ");
INSERT INTO bex_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kina Pilato kope Baraba ŋgï zïnnï. Tine bo iꞌdi komba Yësu ŋgï ti nyɔꞌbɔ, bo kiꞌdi zi bɔ kanya ꞌdɔ kari kutötï. ");
INSERT INTO bex_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kina bɔ kanya naga nima koto Yësu ŋgï kari mï liŋɔ ꞌba turu bɔ dɔliŋɔ nima. Kina dɔtumu ꞌba bɔ kanya kotɔtɔ rönnï ŋgï pili kuru dɔ bo yayi. ");
INSERT INTO bex_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kina lïjë kolɔ bɔŋgɔ ꞌba rɔ bo ŋgï yaga lïjë kolɔ bɔŋgɔ kasi ꞌba ŋere rɔ bo. ");
INSERT INTO bex_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kina lïjë koꞌdɔ kono ŋgï kɔzɔ a ꞌba dɔ ŋere tara kutuꞌbö dɔ bo. Kina lïjë kiꞌdi kulöru közï bo ma dörï. Kina lïjë kolɔdɔ bërï kɔmɔ bo tögö bo rɔ laŋa, kiya te, “Mötö zïyï, bɔ dɔliŋɔ ꞌba Yudayi.” ");
INSERT INTO bex_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lïjë otoꞌbi woro rɔ bo lïjë kogba kulöru nima komba dɔ bo timo. ");
INSERT INTO bex_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kina ɔdɔ lïjë kote tögö bo ꞌdeni rɔ laŋa tine, lïjë olɔ bɔŋgɔ tönë ŋgï yaga di rɔ bo na lïjë kileki kolɔ bɔŋgɔ ma mɔlo ꞌba bo tönë ŋgï rɔ bo. Kina lïjë kari ŋgï ti bo tutötï bo. ");
INSERT INTO bex_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Di gɔ kɔri na dönnï kondɔsɔ ŋgï ti bɔ mɔtɔ di Kurënë möyï mo rɔ Simona. Kina bɔ kanya naga nima kutörï bo ŋgï tombi ŋgërï ꞌba tari tutötï Yësu dɔmo nima. ");
INSERT INTO bex_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kina lïjë kömö ŋgï gɔ bi mɔtɔ ame kïdëkï rɔ Gɔlɔgɔta, ꞌjɔ ꞌba lende mo tëgë, “Kulöŋbö dɔ.” ");
INSERT INTO bex_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kina lïjë kiꞌdi layi mɔtɔ kudölö yïmo ti wɔwɔ ꞌba rɔ kïdïkï ŋgï kpa Yësu. Tine ɔdɔ bo kinene ꞌdeni tara bo uwë dë kpe. ");
INSERT INTO bex_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kina lïjë kutötï bo ŋgï, lïjë koza bɔŋgɔ abo ga rɔ gɔ rönnï ti tuꞌdu mo ti bödö. ");
INSERT INTO bex_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kina lïjë koloma ŋgï yayi toda bo. ");
INSERT INTO bex_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lïjë iꞌdi akugu ame rɔ susu ꞌba rɔ bo ne bi dɔ bo dɔ ŋgërï tɔrɔ yayi, ame kugu ꞌdeni, kiya te, “Yësu Ŋere Bɔ Dɔliŋɔ ꞌBa Yudayi.” ");
INSERT INTO bex_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ya mɔtɔ ga rïyö rɔ bɔ akolɔ utötï gbï ŋgila bo yayi. Mɔtɔ dɔ dörï bo kina mɔtɔ dɔ gali bo. ");
INSERT INTO bex_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bilaka ame ga pili këdï kudö kebe gɔ kɔri nima ne ombamba dönnï zi bo kitiꞌja bo, ");
INSERT INTO bex_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","iya te, “Nï bɔ kiteri titikɔ rö löbu ꞌba Bɔkoꞌba ꞌdɔ kubö kileki teyi mï töꞌdö dɔ mota nime, ɔdɔ këddï ŋgï rɔ kole ꞌba Bɔkoꞌba olɔ röyï këkï bërï di dɔ ŋgërï nima.” ");
INSERT INTO bex_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kina löbu ꞌba bɔ akumu ni ti bɔ kɔmɔ kiyandi ni ti löbu ꞌba bilaka ni koloma gbï tögö bo rɔ laŋa tara. ");
INSERT INTO bex_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Lïjë iya te, “Bo ɔmɔ ya ma laki tine bo ikali dë tɔmɔ gbagba bo. Bo na dë rɔ bɔ dɔliŋɔ ꞌba Yisarele mo tönë? Ɔdɔ bo këkï ꞌdeni bërï di dɔ ŋgërï nima ti diꞌdi dɔze ŋgï pili gɔ lende abo. ");
INSERT INTO bex_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bo iꞌdi dɔ bo ꞌdeni gɔ lende ꞌba Bɔkoꞌba, bo kiya rɔ bo tëgë bo kole ꞌba Bɔkoꞌba na. Ne ti doŋgɔke tɔne ɔdɔ Bɔkoꞌba ti kɔmɔ bo ya.” ");
INSERT INTO bex_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kina gbï tara bɔ akolɔ ame pele kutötï ŋgila bo yayi ne ënyï gbï kitiꞌja bo kɔzɔ a nima tara. ");
INSERT INTO bex_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mï zana kada kodɔrɔ ꞌdeni tine na mandölu kutuꞌbö dɔliŋɔ ŋgï kömö ŋbö ndï kada mota. ");
INSERT INTO bex_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kina ɔdɔ ndï kada kömö ꞌdeni mota rɔ mï dɔkɔpiyari tine, na Yësu kapi ŋgï rɔ ma kembe, tëgë, “Eli, eli, lama sabakatani.” Ame ꞌjɔ ꞌba lende mo tëgë, “Bɔkoꞌba ma, Bɔkoꞌba ma, ola ma ꞌdeni gɔ waꞌdi ga?” ");
INSERT INTO bex_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ya mɔtɔ ga ame këdï kɔrɔ yayi ne uwö köꞌdu koꞌdɔ nima, na lïjë kiya te, “Bo ëdï kïdëkï Eliya.” ");
INSERT INTO bex_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kina bɔ mɔtɔ kiriŋa ŋgï kogba lipɔ kusu mï layi ma koꞌbaꞌba, kogba kiraki dɔ kolɔkɔ kiꞌdi kpa bo tëgë ꞌdɔ bo kunzulu. ");
INSERT INTO bex_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tine ya mɔtɔ ga iya te, “Ɔrɔ te. Ti doŋgɔke ɔdɔ Eliya ti kako kɔmɔ bo ya.” ");
INSERT INTO bex_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kina Yësu kapi ŋgï gbï rɔ ma kembe kina bo kulöku ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kina bɔŋgɔ ma koke mï rö löbu ꞌba Bɔkoꞌba timo tönë kotopa ŋgï di tɔrɔ ŋbö kömö bërï. Dɔyayi iyaya rönï kina döku ma konzi kitikɔ ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Dögö ni unyë rönnï ŋgï rɔ gböŋö kina töku bilaka ma konzi ame ga rɔ bɔ kiꞌdi dönnï gɔ lende ꞌba Bɔkoꞌba ne kënyï kɔdɔ ŋgï kïdïdï yaga. ");
INSERT INTO bex_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lïjë ɔdɔ yaga di mï dögö ꞌbënnï ga. Kina ɔdɔ Yësu kɔdɔ ꞌdeni di mï tölë tine na lïjë kari ŋgï mï Yerosalema gawo kɔtɔ laka tönë, ame bilaka ma konzi koꞌja lïjë ꞌdeni di yayi. ");
INSERT INTO bex_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tine ɔdɔ bɔ dɔ bɔ kanya naga nima ti bɔ kanya abo ga ame këdï koda Yësu yayi ne koꞌja kïzïkïzï nima ꞌdeni tara ti wa ame ga pili koꞌdɔ rönï ne tine, lende mo oꞌde tikere ŋgï zïnnï. Lïjë iya te, “Rɔ ma laka bɔ nime ŋgï rɔ kole ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ꞌJa ma konzi mɔtɔ ga ëdï gbï yayi toŋgɔ Yësu di bi kɔwɔ. Lïjë nima na rɔ ame ga kösö gɔ bo di Galilaya koloma toja laja zi bo ne. ");
INSERT INTO bex_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ꞌJa mɔtɔ mo ga na rɔ Mariya Magadala ti Mariya ma ꞌba Yakoba ni ti Yesepa gbï ti ꞌja mɔtɔ ame rɔ ma ꞌba kole ꞌba Zebedayo ga ne. ");
INSERT INTO bex_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mï dɔkɔpiyari ꞌdeni na bɔ mɔri mɔtɔ di Arimataya kömö ŋgï. Bɔ nima möyï bo rɔ Yesepa, bo gbï rɔ bɔ kösö gɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kina bo kari ŋgï zi Pilato tititi töku Yësu. Kina Pilato kiꞌdi köꞌdu mo ŋgï ꞌdɔ kiꞌdi töku nima zi Yesepa kombi. ");
INSERT INTO bex_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kina bo kogba ŋgï kolo mï bɔŋgɔ kaŋmi ame rɔ ma laꞌja ne. ");
INSERT INTO bex_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kina bo koto ŋgï kari kusu mï tïꞌbörö ꞌba tusu töku abo ame bo koga ꞌdeni rɔ ma laꞌja yɔki döku ne. Kina bo kululu döku ma löbu ŋgï kpamo na bo kari abo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magadala ni ti Mariya mɔtɔ mo tönë ëdï ga koloma rɔ ma koriya ti kpa tïꞌbörö nima yayi. ");
INSERT INTO bex_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kina ɔdɔ kömö ꞌdeni mï bi këzë mɔtɔ ame rɔ kada ꞌba rɔ kindawo ne tine löbu ꞌba bɔ akumu ni ti Parosi ni otɔtɔ rönnï ŋgï zi Pilato. ");
INSERT INTO bex_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Lïjë iya te, “Ŋere, domeri tönë bine bɔ bëtï nima këdï gba ti kɔmɔ bo, bo iya te, ‘Mï töꞌdö dɔ mota ti mënyï mɔdɔ ꞌböwu di mï tölë.’ ");
INSERT INTO bex_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kina me ma laka mo zïyï ꞌdɔ kiꞌdi köꞌdu mo gɔ koda bi laka di rɔ dögö nima ŋbö kömö di pötö töꞌdö dɔ mota, römöyï kinza bɔ kösö gɔ bo ga kari kuꞌbögö töku bo ra yaga lïjë kebe tiya mo zi bilaka tëgë, ‘Bo ɔdɔ ꞌdeni di mï tölë.’ Kina ɔdɔ koꞌdɔ rönï ŋgï tara bëtï ma di yïꞌböwu nime ëdï kënyë ŋgï kebe ma dɔgba tönë.” ");
INSERT INTO bex_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato iya te, “Ogbake bɔ kanya kari kiꞌdike koda bi laka di rɔ dögö nima kɔzɔ ame kikalike tara.” ");
INSERT INTO bex_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kina lïjë kari ŋgï toda dögö nima laka gbï ti tora gɔ döku ꞌba kpamo teyi. Kina lïjë kiꞌdi bɔ kanya ŋgï gbï yayi toda bi. ");
INSERT INTO bex_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kina mɔlo mï kano bi ꞌba töꞌdö ma dɔndende ꞌba di pötö kada ꞌba rɔ kindawo nima na Mariya Magadala ni ti Mariya mɔtɔ mo nima kari ga ŋgï toŋgɔ kpa tïꞌbörö tönë. ");
INSERT INTO bex_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kina tëgë me tondo te yɔ na kïzïkïzï ma kinza kiya kiꞌdi dönï ŋgï. Malayika ꞌba Bɔkoꞌba ako bërï di mïtɔrɔ, kina kululu döku tönë kpa tïꞌbörö nima ne ŋgï yaga bo koloma dɔmo. ");
INSERT INTO bex_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kïnë bo ŋgï rɔ ma köbö kɔzɔ tɔrɔ kunyï tara, kina bɔŋgɔ ꞌba rɔ bo aŋmi ŋgï kɔzɔ paro. ");
INSERT INTO bex_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tikere abo iꞌdi bɔ kanya bɔ këdï koda bi naga nima ŋgï rɔmo ga kïlëꞌdï kilaꞌba bërï kɔzɔ töku. ");
INSERT INTO bex_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tine malayika nima ilende zi ꞌja naga nima, iya te, “Kinza kereke dë römöyï mikali ëddïke rɔ toma Yësu tönë kutötï ne. ");
INSERT INTO bex_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bo inza kpe bine, bo ënyï ꞌdeni kɔdɔ yaga di mï tölë ko kɔzɔ ma tönë bo kiya ꞌdeni mɔlo ne tara. Ako koŋgɔke gɔ bi ame koꞌba töku bo pa teyi ne. ");
INSERT INTO bex_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kina arike welo kiyake zi bɔ kösö gɔ bo ga, iyake te, bo ënyï ꞌdeni kɔdɔ yaga di mï tölë. Kina me bo këdï kari ꞌdeni tötï dɔgba kömönnï mï Galilaya, ti lïjë kari koꞌja bo ꞌjaa yayi. Ame na rɔ wa ma ꞌdɔ miya ziye.” ");
INSERT INTO bex_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kina lïjë kënyï ŋgï di kpa tïꞌbörö yayi rɔ rikamba gbï ti tikere. Tine lïjë lɔ ti lɔŋɔ na lïjë kiriŋa ŋgï tiya mo zi bɔ kösö gɔ bo ga. ");
INSERT INTO bex_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kina tëgë me tondo te yɔ na Yësu kondɔsɔ ŋgï tïnnï di gɔ kɔri yayi. Bo iya te, “Mötö ziye.” Kina lïjë kako kindaꞌba ndï bo na lïjë kïlëlu bo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tine bo iya te, “Kinza kereke dë. Ari kiyake zi löndö ma ga ꞌdɔ lïjë kari Galilaya, kina lïjë ti koꞌja ma ŋgï di yayi.” ");
INSERT INTO bex_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kina ɔdɔ ꞌja naga nima kari ëꞌbënnï ꞌdeni tine na bɔ kanya ma tönë ga këdï koda bi yayi ne mɔtɔ ga kënyï ŋgï kari mï gawo kïyëtï gɔ wa naga nima pili koꞌdɔ rönï ne zi löbu ꞌba bɔ akumu ni. ");
INSERT INTO bex_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kina löbu ꞌba bɔ akumu ni kotɔtɔ rönnï ŋgï ti löbu ꞌba bilaka ni tususu kpënnï. Lïjë odɔ gïrïsï ŋgï rɔ mbëmbë zi bɔ kanya naga nima ");
INSERT INTO bex_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kina lïjë kususu kpa bɔ kanya naga nima, iya te, “Arike, ɔdɔ bɔtɔ kititi ye iyake te, bɔ kösö gɔ bo ga na kako kuꞌbögö töku bo rɔ mï korɔndɔ koꞌja töꞌdö kindaꞌba ye ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kina ɔdɔ kiya te lëbï mo kömö kɔzɔ a nime te mbili Pilato, ti dïyëyï kpa lende nima ŋgï koꞌdɔ ɔtɔ dë kpe ziye.” ");
INSERT INTO bex_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kina bɔ kanya naga nima kogba gïrïsï tönë ŋgï lïjë kari koꞌdɔ kɔzɔ ame kiya ꞌdeni zïnnï ne tara. Gɔ köꞌdu mo na lende nime këdï gba nduwë kïlëbï mï löŋgö Yudayi koꞌja kabate ne. ");
INSERT INTO bex_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kina bɔ kösö gɔ Yësu ma ꞌbutë dɔɔkɔtɔ naga nima kënyï ŋgï kari dɔ döku tönë mï Galilaya gɔ bi ma Yësu kiya zïnnï tari teyi. ");
INSERT INTO bex_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kina ɔdɔ lïjë koꞌja bo ꞌdeni tine, lïjë ïlëlu bo ŋgï. Tine pele lende nima gba rɔ ma kïlïkö dɔ ya mɔtɔ ga. ");
INSERT INTO bex_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kina Yësu kese ŋgɔsi kiya te, “Bɔkoꞌba iꞌdi közï kakpa pili ꞌba mïtɔrɔ ti ꞌba dɔyayi ꞌdeni zö. ");
INSERT INTO bex_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kina arike ti kiꞌdike dɔ kupö bilaka ꞌba dɔliŋɔ nime pili këdï rɔ bɔ kösö gɔma. Oꞌdɔke bapatisi dönnï mï möyï ꞌbu ma Bɔkoꞌba gbï ti kole ti Nyï Kɔtɔ Laka. ");
INSERT INTO bex_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iyandike lïjë tuwö dɔ wa ame ga pili mose gɔmo ꞌdeni ziye ne. Kina ti möꞌbö ŋgï tiye ŋbö mï kada ma ŋburuŋburu ꞌba dɔliŋɔ.”");
INSERT INTO bex_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ame na rɔ tisaki ꞌba laja laka ꞌba Yësu Kurïsïtö kole ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kina kisaki kɔzɔ ma tönë Yesaya bɔ kumë lende ꞌba Bɔkoꞌba kugu ne tara. Ame tönë Bɔkoꞌba kiya te, “Oŋgɔ, ti moja bɔ laja ma kari dɔgba kömöyï tileŋo gɔ kɔri zïyï. ");
INSERT INTO bex_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bo na këdï kuwöwö dɔ bo di yï mökö kiya te, ‘Ileŋoke kɔri zi ŋere. Odɔrɔke gɔ kɔri zi bo.’” ");
INSERT INTO bex_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kina Yowani kɔdɔ ŋgï yï mökö tobapatisi bilaka, gbï tuwöwö mo zïnnï gɔ lïjë kotɔ dönnï di mï lende kënyë ꞌbënnï ga kobapatisi lïjë gɔ Bɔkoꞌba kola lïjë gɔmo. ");
INSERT INTO bex_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kina bilaka kɔlɔ ŋgï di Yudayi, pili di mï Yerosalema kari zi bo. Lïjë ari kodɔ kpënnï ŋgï pili gɔ lende kënyë ꞌbënnï ga na bo kobapatisi lïjë ŋgï mï yöpö Yaradene. ");
INSERT INTO bex_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yowani, bɔŋgɔ ꞌba rɔ bo uꞌjö di mï sunë gamele, ti gasi ꞌbana bo koga ꞌbömbö bo. Akonyo abo ga rɔ mömï ni ti tagi ꞌba mï ꞌbɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kina bo kiya zi bilaka naga nima te, “Bɔ mɔtɔ ëdï kozi kako di gɔma. Bo na mbiri löbu di dɔma. Pele rɔ kabi ꞌba wari ndï bo ma mɔꞌbɔ dë tëdë bërï tope kpamo. ");
INSERT INTO bex_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Moꞌdɔ ma ꞌbama bapatisi ꞌdeni dɔye ti mini. Tine ma ꞌba bo, bo ti kobapatisi ye ti Nyï Kɔtɔ Laka.” ");
INSERT INTO bex_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mï kada nima na Yësu kako ŋgï di Nazareta di mï Galilaya zi Yowani, kina kobapatisi bo ŋgï mï yöpö Yaradene. ");
INSERT INTO bex_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tine ɔdɔ Yësu këdï kɔdɔ ꞌdeni yaga di mï mini bo oja mïtɔrɔ konye rönï ꞌdeni yaga rɔ gböŋö, Nyï Kɔtɔ Laka këdï kɔkɔ ŋgï kako dɔ bo kɔzɔ matukpuru tara. ");
INSERT INTO bex_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kina birɔ kudu ŋgï kako di mïtɔrɔ kiya te, “Nï na rɔ kole ma. Mɔꞌɔ yi ꞌdeni kulöwö. Ma ti mï këyï rɔ mbëmbë gɔ lende ꞌbï.” ");
INSERT INTO bex_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kina Nyï Kɔtɔ Laka koto Yësu ŋgï kari yï mökö, ");
INSERT INTO bex_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","bo koꞌdɔ töꞌdö dɔ ꞌbutë sowɔ yï mökö yayi. Kina Satani koloma ŋgï rɔ tiyɔzɔ bo. Bo oloma ŋgï mï löŋgö wa ꞌba yï mökö. Tine malayika na koloma rɔ toja laja zi bo tokɔnyi bo. ");
INSERT INTO bex_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kina di pötö mo koꞌja kiꞌdi Yowani ꞌdeni mï maboso na Yësu kako ŋgï mï Galilaya tuwöwö laja laka ꞌba Bɔkoꞌba, ");
INSERT INTO bex_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kiya te, “Kada mo ömö ꞌdeni. Kina ŋere löbu ꞌba Bɔkoꞌba ëdï ꞌdeni ŋɔli. Otɔke dɔye di mï lende kënyë ꞌbe ga kiꞌdike dɔye gɔ laja laka ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mï tudö abo kebe kpa pöpö ꞌba Galilaya na bo kari koꞌja Simona ni ŋgï yayi ti bɔ löndö bo Andareya këdï ga rɔ tuꞌdu duru mï pöpö, römöyï lïjë atoyi na. ");
INSERT INTO bex_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kina bo kilende zïnnï, iya te, “Ösöke gɔma, ti miꞌdi ye rɔ atoyi ꞌba toꞌde bilaka kako zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kina lïjë kola duru ꞌbënnï ga ŋgï yayi lïjë kösö gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mï tari abo mbowa dɔgba di bina na bo kari koꞌja kole ꞌba Zebedayo ga ŋgï, Yakoba ni ti bɔ löndö bo Yowani. Lïjë oloma ꞌdeni mï sorope këdï ga rɔ tileŋo duru ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bo ïdëkï lïjë, na lïjë kënyï kola ꞌbu nnï Zebedayo ŋgï mï sorope yayi ti bɔ ndɔbɔ, lïjë kösö ŋgï gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yësu ni ari Kaparanoma. Mï kada ꞌba rɔ kindawo na bo kari ŋgï kɔdɔ mï rö ꞌba mötu bo kiꞌdi tiyandi kɔmɔ bilaka. ");
INSERT INTO bex_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tine lïjë otɔ ŋgï rɔ gönnï. Römöyï akiyandi abo ŋgï kɔzɔ ꞌba bɔ közï kakpa, inza kɔzɔ ma ꞌba bɔ kɔmɔ kiyandi ni tara. ");
INSERT INTO bex_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bɔ mɔtɔ rɔ bɔ nökï ëdï mï rö ꞌba mötu yayi. Kina bo kënyï kulörï ŋgï rɔ ma kembe kiya te, ");
INSERT INTO bex_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Waꞌdi ꞌbï tize, nï Yësu ꞌba Nazareta nime? Ako ꞌdeni tote dɔze nati? Mikali yi ꞌdeni. Nï na rɔ bɔ laja ma kɔtɔ laka ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yësu amo dɔ nökï nima, iya te, “Udumö yaga. Kina itaꞌba yaga di dɔ bɔ nima.” ");
INSERT INTO bex_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kina nökï mo nima koŋma bɔ nima ŋgï kulörï rɔ ma kembe, kina kɔdɔ ŋgï yaga di dɔmo. ");
INSERT INTO bex_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kina lende mo kigayi lïjë ŋgï pili kiꞌdi lïjë ŋgï kebe tititi rönnï rɔ gɔ rönnï, kiya te, “Waꞌdi ga na te? Akiyandi laꞌja nati? Bɔ nime ŋgï ti közï kakpa bo kamo dɔ nökï te yɔ kuwö dɔ bo ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tine na lëbï ꞌba lende ꞌba Yësu kitaꞌba ŋgï welo kote mï dɔyayi ꞌba Galilaya yayi. ");
INSERT INTO bex_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yësu ni ɔdɔ di mï rö ꞌba mötu yayi ti Yakoba ni ti Yowani kari liŋɔ ꞌba Simona ni ti Andareya. ");
INSERT INTO bex_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tine lïjë ömö yayi koꞌja mese ꞌba Simona këdï ti zëyï köꞌdö ꞌdeni bërï dɔ sora. Iya lende mo zi Yësu, ");
INSERT INTO bex_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","kina bo kari ŋgï kindaꞌba közïmo kombi dɔmo tɔrɔ. Kina zëyï nima kitaꞌba ŋgï yaga di rönï lɔko kënyï toja laja zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mï dɔkɔpiyari mo nima koꞌja kada kösö ꞌdeni na koꞌde bɔ rɔkɔꞌɔ ŋgï pili kako zi bo kpaki ti bɔ nökï ni. ");
INSERT INTO bex_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bilaka pili ꞌba mï tïrï otɔtɔ rönnï ŋgï liŋɔ ꞌba Simona yayi. ");
INSERT INTO bex_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kina Yësu kileŋo bilaka ame ga pili ti dɔkomali rɔkɔꞌɔ ma gege ne ŋgï, bo kiꞌdi nökï kitaꞌba ŋgï yaga di dɔ ma konzi ame ga rɔ bɔ nökï ne. Tine bo ota gɔ lende di zi nökï ni römöyï lïjë ikali bo. ");
INSERT INTO bex_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mï bi këzë ma di gɔmo mɔlo mï kano bi na bo kënyï ŋgï kari abo yï mökö rɔ dɔ kutu bo tumötu. ");
INSERT INTO bex_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kina Simona ni ti ya mɔtɔ mo naga nima koloma ŋgï rɔ toma bo. ");
INSERT INTO bex_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lïjë ari koꞌja bo na lïjë kiya zi bo te, “Bilaka pili ëdï rɔ toma göyï.” ");
INSERT INTO bex_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tine bo ileki dɔmo kiya zïnnï te, “Darike mï liŋɔ ma dɔgba naga ꞌdɔ mari muwöwö laja nime gbï yayi, römöyï kina rɔ ndɔbɔ ma mako dömöyï mo.” ");
INSERT INTO bex_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kina bo kiliŋgere ŋgï kote mï dɔyayi ꞌba Galilaya nima toko ti tuwöwö lende ꞌba Bɔkoꞌba mï rö ꞌba mötu ꞌbënnï ga pili, bo kiꞌdi nökï kitaꞌba ŋgï yaga di dɔ bɔ nökï ma konzi. ");
INSERT INTO bex_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kina bɔ mönyu mɔtɔ kako ŋgï zi Yësu kolɔdɔ bërï komaꞌjo rönï zi bo, iya te, “Ɔdɔ koꞌdɔkɔ ŋgï ti kileŋo ma ŋgï yaga rɔ ma kɔpɔ.” ");
INSERT INTO bex_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yësu oŋgɔ lisa ꞌba rɔ bɔ nima, na bo koja közï bo ŋgï kosa rɔmo, kiya te, “Moꞌdɔkɔ ꞌdeni ŋgï, ileŋo yi ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kina mönyu kilayi ŋgï di rɔ bɔ nima rɔmo kɔpɔ ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tine Yësu ose gɔmo kitigɔ zi bɔ nima koja kari, kiya te, ");
INSERT INTO bex_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kinza kari kiya lende nime dë zi bɔtɔ, ari kileme röyï zi bɔ akumu ꞌba Bɔkoꞌba ni. Kina ꞌdɔ kiꞌdi a ꞌba akileŋo mo tönë Musa kiꞌdi köꞌdu mo ne, ꞌdɔ kileme ileŋo yi ꞌdeni kɔpɔ.” ");
INSERT INTO bex_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tine pele bɔ nima ari ŋgï koloma rɔ tïyëtï mo, tïyëlë lende ꞌba Yësu. Kina ŋgï iꞌdi bi ꞌba tɔdɔ mï gawo kari kele dë kpe zi Yësu. Kina bo koloma abo ŋgï köꞌbö yaga mökö di mï gawo. Na bilaka koloma ŋgï rɔ tɔlɔ kari zi bo di mï gɔ bi pili. ");
INSERT INTO bex_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mï töꞌdö dɔ ndö tara di pötö mo na bo kileki ŋgï kari Kaparanoma. Kina lëbï mo kote gɔ bi nima ŋgï toko ma bo këdï ꞌdeni liŋɔ mɔtɔ yayi. ");
INSERT INTO bex_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kina bilaka kɔlɔ ŋgï rɔ tïndï kako zi bo koso lɔ mï rö nima bi gböŋö ma titi te kari kinza kpe rɔ bo. Kina bo koloma ŋgï rɔ tuwöwö lende ꞌba Bɔkoꞌba zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na koꞌde bɔ mɔtɔ ame keŋme ꞌdeni mɔlo bërï ne ŋgï kako zi bo, bilaka sowɔ na kombi. ");
INSERT INTO bex_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tine bilaka oso ꞌdeni ŋgï bi gböŋö ma titi te inza kpe zïnnï ꞌdɔ tɔdɔ timo toto bɔ nima kari ŋgɔsi zi Yësu. Kina lïjë këkï ŋgï dɔ rö tɔrɔ kiteŋe gɔ bi koja bɔ nima kebe teyi kpaki ti laŋba ma köꞌdö dɔmo mo koꞌba bërï te kɔmɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kina ɔdɔ Yësu koŋgɔ ꞌdeni lïjë kiꞌdi dönnï gɔ lende abo tara tine, na bo kilende ŋgï zi bɔ keŋme bërï nima, kiya te, “Kole ma, ola yi ꞌdeni gɔ lende kënyë ꞌbï ga.” ");
INSERT INTO bex_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dëmba tine bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi mɔtɔ ga ëdï yayi, na lïjë kebe ŋgï rɔ tomeri mo ti mïnnï, kiya te, ");
INSERT INTO bex_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bɔ nime ilaŋa rɔ bo kiya lende tara gɔ waꞌdi zi Bɔkoꞌba? Oꞌja dölï na ꞌdï. Bɔkoꞌba na ŋge kɔtɔ rɔ bɔ tola wa gɔ lende kënyë.” ");
INSERT INTO bex_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yësu ikali meri ꞌbënnï nima ŋgï, na bo kiya zïnnï te, “Kpe, ëddï komerike lende nima tara mïye gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma yala na kïtëwu ꞌdɔ tiya mo zi bɔ keŋme bërï nima? ‘Ola yi ꞌdeni gɔ lende kënyë ꞌbï,’ ala ꞌdɔ kiya te, ‘Ënyï kombi laŋba ꞌbï kiliŋgere.’ ");
INSERT INTO bex_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ne ziye tikali mo rɔ ma laka kole ꞌba bilaka lesi ëdï ŋgï ti tigɔ dɔliŋɔ bine tola bilaka gɔ lende kënyë.” Kina bo kiya ŋgï te zi bɔ keŋme bërï nima, ");
INSERT INTO bex_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nï, milende zïyï, ënyï kombi laŋba ꞌbï kari liŋɔ.” ");
INSERT INTO bex_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kina bɔ nima kënyï ŋgï di kömönnï pili te kombi laŋba abo kari timo. Lende mo igayi lïjë ŋgï pili na lïjë kebe ŋgï rɔ tïlëlu Bɔkoꞌba, kiya te, “Wa ma te doꞌja dë gba mɔlo.” ");
INSERT INTO bex_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yësu ileki ꞌböwu kari kpa pöpö ꞌba Galilaya, na tïndï kotɔtɔ rönnï ŋgï zi bo yayi. Na bo koloma ŋgï rɔ tiyandi lïjë. ");
INSERT INTO bex_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kina ɔdɔ bo kënyï ꞌdeni tiliŋgere kebe yayi tine na bo kari koꞌja bɔ kireke awada mɔtɔ kïdëkï rɔ Lëwë kole ꞌba Alapayo, koloma ꞌdeni mï bi ꞌba tireke awada. Bo iya te, “Ösö gɔma.” Kina Lëwë kënyï ŋgï kösö gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kina lïjë kari ŋgï tonyo kpënnï liŋɔ ꞌba Lëwë. Bɔ kireke awada ma konzi ti bɔ lende kënyë mɔtɔ ga ëdï gbï yayi tonyo wa bi kɔtɔ ti Yësu ni ti bɔ kösö gɔ bo ga. Römöyï ma konzi ꞌbënnï ösö ꞌdeni gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kina ɔdɔ bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi mɔtɔ ga ame lïjë gbï rɔ Parosi ne koꞌja Yësu ꞌdeni këdï rɔ tonyo wa bi kɔtɔ ti bɔ lende kënyë ni ti bɔ kireke awada tara tine, lïjë ënyï kititi bɔ kösö gɔ bo ga, kiya te, “Yësu ëdï konyo wa bi kɔtɔ ti bɔ lende kënyë ni ti bɔ kireke awada gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yësu uwö lende ꞌbënnï nima ꞌdeni, na bo kileki zïnnï, kiya te, “Bɔ rɔkɔꞌɔ na ŋge kari zi bɔ kiꞌdi wɔwɔ. Ya ma kinza ti rɔkɔꞌɔ naga ari ëꞌbënnï dë. Kina me ma mako dë tïdëkï bɔ lende laka, mako gɔ bɔ lende kënyë.” ");
INSERT INTO bex_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bɔ kösö gɔ Yowani bɔ bapatisi ga ti Parosi ni ëdï koro kpënnï. Kina ya mɔtɔ ga kako zi Yësu kititi bo, iya te, “Gɔ waꞌdi na bɔ kösö gɔ Yowani ga ti bɔ kösö gɔ Parosi ni këdï koro kpënnï, tine ma ꞌbëyï ga koro kpënnï dë gɔmo?” ");
INSERT INTO bex_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yësu ileki dɔmo zïnnï, iya te, “Ma komerike ꞌbeye ŋba ꞌba mï karama ꞌba gbe ti koro kpënnï koꞌja mëꞌdë ꞌba nyiti këdï mï löŋgö lïjë? Inza tara. ");
INSERT INTO bex_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tine kada mo ti kömö ꞌdeni ame gɔ kindaꞌba mëꞌdë ꞌba nyiti yaga di mï löŋgö lïjë, kina ti lïjë koro kpënnï ꞌjaa. ");
INSERT INTO bex_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Rɔ ma laka bɔtɔ uru bɔŋgɔ ma laꞌja dë yɔki bɔŋgɔ ma mɔlo. Ɔdɔ koꞌdɔ tara ma laꞌja nima ti kosoŋi rönï kirica ma mɔlo mo ŋgï yaga koꞌdɔ bi gböŋö ma löbu kulöwö. ");
INSERT INTO bex_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kina bɔtɔ mɔtɔ odɔ layi ma laꞌja dë gbï mï kilaka ꞌba layi ame köndë ꞌdeni ne. Ɔdɔ koꞌdɔ tara layi ti kotopa kilaka köndë nima ŋgï, kina layi ni kpaki ti kilaka mo nima ti kirasi rönnï ŋgï yaga. Tine ma laka mo todɔ layi ma laꞌja gbï mï kilaka ma laꞌja ꞌba layi.” ");
INSERT INTO bex_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mï kada ꞌba rɔ kindawo ma dɔ kɔtɔ mɔtɔ, Yësu ni këdï kudö ti bɔ kösö gɔ bo ga kebe mï nyaka ꞌba nyönyu, na bɔ kösö gɔ bo ga koloma ŋgï rɔ tomborozi dɔ nyönyu ma kana kebe tonyo mo. ");
INSERT INTO bex_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parosi ni ënyï kiya zi Yësu te, “Oŋgɔ te, gɔ waꞌdi na bɔ kösö göyï ga këdï koꞌdɔ wa ame kari dë gɔ köꞌdu kiꞌdi ꞌba kada ꞌba rɔ kindawo ne tara gɔmo?” ");
INSERT INTO bex_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yësu ënyï kileki dɔmo zïnnï iya te, “Kpe, wa tönë ꞌbu ze löbu Dawidi koꞌdɔ mï kada ma lïjë ti ya ma ti bo këdï rɔ ꞌbö ne, ïdëkïke dë? ");
INSERT INTO bex_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ame tönë koꞌdɔ rönï mï kada ma Abiyatara na këdï rɔ bɔ dɔ bɔ akumu ne. Maŋgolɔꞌbɔ koro mo tönë kiꞌdi ꞌdeni zi Bɔkoꞌba, mï köꞌdu kiꞌdi mo ꞌdɔ bɔ akumu na ŋge konyo, bilaka ma sari konyo dë ne, Dawidi ɔdɔ ŋgï mï rö ꞌba Bɔkoꞌba konyo, kogba mɔtɔ ga kiꞌdi gbï zi ya ma ti bo.” ");
INSERT INTO bex_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kina Yësu kileki gɔmo gbï kiya zïnnï te, “Iꞌdi kada ꞌba rɔ kindawo rɔ a laka zi bilaka lesi. Tine iꞌdi bilaka lesi dë gɔ köꞌdu ꞌba kada ꞌba rɔ kindawo. ");
INSERT INTO bex_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kina kole ꞌba bilaka lesi na gbï rɔ ŋere ꞌba dɔ kada ꞌba rɔ kindawo.” ");
INSERT INTO bex_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yësu ileki kari mï rö ꞌba mötu. Tine bɔ mɔtɔ ëdï yayi közïmo kölë ꞌdeni rɔ kilawo. ");
INSERT INTO bex_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ya mɔtɔ ga ëdï gbï yayi, lïjë oloma ꞌdeni ŋgï rɔ toŋgɔ mo ɔdɔ Yësu kileŋo bɔ nima mï kada ꞌba rɔ kindawo nima gɔ lïjë kari kususu bo timo. ");
INSERT INTO bex_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yësu ïdëkï bɔ közï kölë rɔ kilawo nima kiya teyi te, “Ako kɔrɔ kɔmɔze pili bine.” ");
INSERT INTO bex_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kina bo kënyï kititi bilaka naga nima, bo iya te, “Ma yala na rɔ ma laka mï köꞌdu kiꞌdi ꞌba kada ꞌba rɔ kindawo ꞌdɔ toꞌdɔ mo? Toꞌdɔ lende laka ala toꞌdɔ a ma rɔ ma kënyë na teyi? Tɔmɔ dïdï, ala tupö mo yaga?” Tine lïjë udumö ŋgï pili liwo. ");
INSERT INTO bex_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kina bo kuyï kɔmɔ bo koŋgɔ dönnï pili toko, dökïꞌdï bo ga ata ꞌdeni rönnï. Tine lende kinza kuwö ꞌbënnï nima iꞌdi bo ŋgï këdï rɔ meri. Kina bo kilende ŋgï zi bɔ nima, iya te, “Oja gɔ közïyï.” Bɔ nima oja yɔ na kileki ŋgï rɔ ma laka gɔ bi mo. ");
INSERT INTO bex_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kina Parosi ni kɔdɔ ŋgï di mï rö ꞌba mötu yayi kari kotɔtɔ ga kpënnï ti bilaka ꞌba Erode ga toma kɔri ꞌba ꞌdɔ tupö Yësu timo. ");
INSERT INTO bex_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yësu ënyï ŋgï ti bɔ kösö gɔ bo ga kari kpa pöpö, na bilaka kɔlɔ ŋgï rɔ tïndï kari zïnnï yayi. Lïjë ɔlɔ kako di Galilaya yayi, di Yudayi, ");
INSERT INTO bex_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","di Yerosalema, di Edome, di gönyï yöpö ꞌba Yaradene, ya mɔtɔ ga ako di mï dɔliŋɔ ꞌba Tura ni ti Sidona. Lïjë ɔlɔ kako zi bo gɔ lëbï ꞌba wa ame lïjë kuwö bo këdï koꞌdɔ ne. ");
INSERT INTO bex_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bilaka ŋgï rɔ tïndï ma kinza kiya. Na Yësu kiya ŋgï zi bɔ kösö gɔ bo ga ꞌdɔ lïjë koꞌde sorope gɔ bo këkï yïmo kinza komoti bo ra. ");
INSERT INTO bex_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Römöyï bo ileŋo bɔ rɔkɔꞌɔ ma konzi ŋgï, kina ma konzi mɔtɔ ga këdï gba nduwë komoti rönnï tari tosa rɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kina ɔdɔ ya ma rɔ bɔ nökï ni koꞌja ma ꞌbënnï kïnë bo te na kilaꞌba ŋgï bërï kɔmɔ bo ti tulörï, kiya te, “Nï na rɔ kole ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tine bo amo ŋgï dönnï kinza lïjë kuwöwö gɔ bo dë yaga. ");
INSERT INTO bex_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yësu ënyï ŋgï këkï kari dɔ kuruŋgu tɔrɔ, na bo kïdëkï bilaka ma bo koꞌdɔkɔ naga ŋgï kako zi bo. ");
INSERT INTO bex_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na bo koza ma ꞌbutë dɔmorïyö ŋgï di yïmo rɔ ame mo ga bo kïdëkï rɔ bɔ laja abo ne. Kina bo kiya zi lïjë te, “Kpe nime, moza ye ꞌdeni ꞌdɔ këddïke tö, ꞌdɔ moja ye gbï tari tuwöwö lende zi bilaka, ");
INSERT INTO bex_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","miꞌdi közï kakpa ziye toga nökï timo yaga.” ");
INSERT INTO bex_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Lïjë ma ꞌbutë dɔmorïyö ma bo koza mo ga na me, Simona ame Yësu kiꞌdi möyï bo mɔtɔ gbï rɔ Pïtörö ne, ");
INSERT INTO bex_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ti Yakoba ni ti löndö bo Yowani kole ꞌba Zebedayo ga. Yësu iꞌdi möyï dönnï rɔ Bonerega, ame ꞌjɔ ꞌba lende mo tëgë, “Bɔ tɔrɔ kapi.” ");
INSERT INTO bex_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kina ti Andareya ni ti Pïlïpö ti Batolimayo ti Matayo ti Tɔma ti Yakoba kole ꞌba Alapayo ti Tadayo ti Simona bɔ koꞌdɔ ya gɔ dɔyayi ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Kina ti Yuda Isikarita ame kina kari kususu Yësu zi turu ne. ");
INSERT INTO bex_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yësu ileki kari liŋɔ, na tïndï ma kinza kiya kotɔtɔ rönnï ŋgï gbï kako zi bo kola bi ꞌba tonyo akonyo pele kari kinza kpe zïnnï ti bɔ kösö gɔ bo ga. ");
INSERT INTO bex_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kina ɔdɔ lëbï mo kari kömö ꞌdeni kɔzɔ a nime te zi eꞌbe ma bo ga tine, na lïjë kënyï ŋgï kako gɔ bo. Römöyï bilaka ëdï ꞌdeni ŋgï rɔ tiya mo te, “Rumö na kilaꞌba ꞌdeni dɔ bo.” ");
INSERT INTO bex_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi mɔtɔ ga ame kako di Yerosalema ne oloma ŋgï rɔ tiya mo te, “Belezebola ŋere ꞌba nökï na kilaꞌba ꞌdeni dɔ bo. Ŋere ꞌba nökï ni na kiꞌdi közï kakpa nima zi bo toga nökï ma laki timo yaga.” ");
INSERT INTO bex_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kina Yësu kïdëkï bilaka naga nima ŋgï kako zi bo, bo koloma rɔ tiya mo zïnnï rɔ dɔŋgala. Bo iya te, “Ti Satani kebe koga Satani lëpï bo mɔtɔ tondo ga? ");
INSERT INTO bex_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɔdɔ dɔliŋɔ kɔtɔ kebe koza mïnï ꞌdeni kebe toꞌdɔ ya rɔ gɔ rönnï dɔliŋɔ nima ëdï kitaꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɔdɔ kpa gɔli kɔtɔ koza mïnï kebe toꞌdɔ ya rɔ gɔ rönnï, kpa gɔli nima ëdï kitaꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kina gbï tara ɔdɔ Satani koza mïnnï ꞌdeni kebe toꞌdɔ ya rɔ gɔ rönnï, gɔmo inza kɔwɔ kpe dɔliŋɔ ꞌbënnï nima ëdï kitaꞌba gïrï nime. ");
INSERT INTO bex_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Bɔtɔ mɔtɔ ikali dë ma ꞌdɔ kari kɔdɔ mï rö ꞌba bɔ tigɔ mɔtɔ kolɔ amo ga. Tine ŋge ɔdɔ kudödu bɔ tigɔ nima ꞌdeni titi gba bërï tine na ꞌjaa ti kolɔ amo ga. ");
INSERT INTO bex_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kpe omerike lende nime laka. Dɔkomali lende kënyë ma laki naga nima pili ti kola bilaka ŋgï gɔmo kpaki ti kpa kënyë ma lïjë koꞌdɔ. ");
INSERT INTO bex_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ne bɔtɔ ame kirasi lende kiya kpënï rɔ ma kënyë gɔ Nyï Kɔtɔ Laka ne, inza kola ŋgï du lipo. Lende kënyë ma ŋburuŋburu na bo koꞌdɔ ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yësu iya lende nime te römöyï lïjë iya te nökï na këdï koꞌdɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kina ma ꞌba Yësu ni ti löndö bo ga kömö ŋgï. Lïjë ɔrɔ yaga koja laja kari gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tïndï oloma ꞌdeni kuru bo bërï na kari kiya zi bo te, “Möyï ni ti löndö yï ga ëdï yaga ꞌdë yayi, lïjë oꞌdɔkɔ yi ꞌdɔ kari zïnnï.” ");
INSERT INTO bex_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yësu ileki dɔmo zïnnï iya te, “Yë ga na rɔ iya ni ma ti löndö ma mo ga?” ");
INSERT INTO bex_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bo uyï kɔmɔ bo koŋgɔ dɔ bilaka naga nima koloma yayi ne, na bo kileki kiya te, “Lïjë nime na rɔ iya ni ma ti löndö ma ga. ");
INSERT INTO bex_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bɔtɔ ame koꞌdɔ akoꞌdɔkɔ ꞌba Bɔkoꞌba ne na rɔ löndö ma ga, rɔ lëmï ma ga gbï rɔ iya ma.” ");
INSERT INTO bex_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yësu ako ꞌböwu gbï koloma rɔ tiyandi bilaka di kpa pöpö ꞌba Galilaya. Bilaka ako ŋgï zi bo rɔ tïndï ma kinza kiya, kina bo kari këkï koloma ŋgï mï sorope mbowa mï zana mini. Tïndï naga nima ɔrɔ ŋgï yaga kpa götö yayi, ");
INSERT INTO bex_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","kina bo koloma ŋgï rɔ tiyandi lïjë ti dɔŋgala ma konzi. Mï akiyandi abo, bo iya te, ");
INSERT INTO bex_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Uwöke, bɔ kulï kupö mɔtɔ ɔdɔ ꞌdeni kari tulï kupö abo mï nyaka. ");
INSERT INTO bex_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Di bi tulï mo mɔtɔ ga ilaꞌba ŋgï dɔ kpa kɔri, kina yali kako ŋgï kogɔ yaga. ");
INSERT INTO bex_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kupö mɔtɔ ga ilaꞌba ma ꞌbënnï dɔ kirigɔyɔ ame yayi mo kalo dë laka ne. Kina kötu ŋgï welo römöyï yayi mo alo dë. ");
INSERT INTO bex_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tine ɔdɔ kada keze yɔ na koŋma ŋgï kututu yaga römöyï ŋgiraꞌda mo alo dë. ");
INSERT INTO bex_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kupö mɔtɔ ga ilaꞌba ma ꞌbënnï ŋgï mï löŋgö kono. Tine ɔdɔ kono kebe kïyöbu yɔ na kuböwu ŋgï yaga köꞌbö rɔ azurupu. ");
INSERT INTO bex_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kina kupö mɔtɔ ga kilaꞌba ma ꞌbënnï ŋgï mï yayi ma laka. Na kötu ŋgï kïyöbu laka ŋbö kana. Mɔtɔ mo ga ana ŋge mbowa, mɔtɔ ga ana laka tine mɔtɔ ga ana ŋgï kulöwö.” ");
INSERT INTO bex_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kina Yësu kileki gɔmo kiya zïnnï te, “Bɔ ame ti mbili ne iꞌdike bo kuwö lende nime.” ");
INSERT INTO bex_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Di pötö mo koꞌja Yësu këdï ꞌdeni kutu bo tine, na ya mɔtɔ ga ame kuwö lende nima ne ti bɔ kösö gɔ bo ga kako ŋgï zi bo. Lïjë ako kititi bo ꞌdɔ bo kïyëtï mï ꞌjɔ ꞌba dɔŋgala naga nima zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yësu ileki dɔmo zïnnï iya te, “Kpe, akikali ꞌba a ma rɔ ma kusu mï ŋere löbu ꞌba Bɔkoꞌba nime iꞌdi ꞌdeni ziye. Tine ma ꞌbënnï ꞌba ya mɔtɔ ga naga nima ti milende zïnnï nduwë rɔ dɔŋgala. ");
INSERT INTO bex_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Römöyï kɔzɔ ma tönë kugu ne, ‘Gɔ lïjë koŋgɔ pele, tine lïjë koꞌja dë. Lïjë kuwö pele, tine lïjë kikali dë. Römöyï kinza lïjë kebe kotɔ dönnï ra lïjë kileki kako zö ma ŋere Bɔkoꞌba, kinza mola lïjë ra gɔ lende kënyë ꞌbënnï ga.’” ");
INSERT INTO bex_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kina Yësu kititi lïjë kiya te, “Kpe gbï ikalike mï ꞌjɔ ꞌba dɔŋgala nime dë? Tine gɔ kikalike mï ꞌjɔ ꞌba dɔŋgala mɔtɔ mo ga ꞌjaa tondo mo ga? ");
INSERT INTO bex_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bɔ kulï kupö nima na rɔ bɔ kuwöwö lende ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kupö ma kilaꞌba dɔ kpa kɔri na rɔ ya ame ga kuwö ŋgï tine, Satani ako ŋgï welo kogba yaga di mï dökïꞌdï mo ne. ");
INSERT INTO bex_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kupö ma kilaꞌba dɔ kirigɔyɔ na rɔ ame ga kuwö yɔ kindaꞌba ŋgï ti mï këyï ne. ");
INSERT INTO bex_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tine ŋgiraꞌda mo na kalo dë mïnnï kina ŋgï gɔmo igabi dë. Ɔdɔ gomɔ ni ti közï kasi ꞌba gɔmo kömö yɔ na lïjë koga kpënnï ŋgï gɔmo. ");
INSERT INTO bex_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kupö ma kilaꞌba mï löŋgö kono na rɔ ame ga kuwö ŋgï kindaꞌba laka, ");
INSERT INTO bex_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tine kɔmɔ kïlëꞌdï ꞌba gɔ wa ꞌba dɔliŋɔ, mɔri ni ti mï löbu gɔ ama konzi mɔtɔ ga kuböwu ŋgï yaga kana ɔtɔ dë. ");
INSERT INTO bex_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tine kupö ma kilaꞌba mï yayi ma laka na rɔ ame ga kuwö kutï ŋgï kindaꞌba laka ne. Kina lïjë na ma kana ŋgï, mɔtɔ ga mbowa, mɔtɔ ga laka, tine mɔtɔ mo ga kulöwö.” ");
INSERT INTO bex_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kina Yësu koloma ŋgï nduwë rɔ tiya mo zïnnï te, “Me bɔtɔ mɔtɔ ebe kogba lamba ra kutuꞌbö dɔmo yaga teyi ti löꞌdï ala kusu bïcï sora? Rɔ ma laka lamba ëdï kutë dɔ a ꞌba tïdëyï mo. ");
INSERT INTO bex_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kina me ꞌdeni ɔtɔ ame yaga rɔ ma kusu ne ti koja ŋgï yaga bi kɔpɔ. Ɔtɔ ame kutuꞌbö dɔmo teyi ne ti kombi dɔmo ꞌdeni ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kina ti, bɔ ame ti mbili ne, iꞌdike bo kuwö lende nime.” ");
INSERT INTO bex_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bo ileki gbï kiya zïnnï te, “Wa ame këdï kiya ziye ne ojeke mbili ye laka gɔmo tuwö mo. Wa ma këddï kiyarike timo na ti Bɔkoꞌba kiyari gbï timo ziye. Kina ti bo kiꞌdi dɔmo ꞌdeni ŋgï teyi ziye. ");
INSERT INTO bex_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Römöyï bɔ ame këdï timo ne ti kiꞌdi gbï teyi. Kina bɔ ame kinza timo ne ma titi tɔ nima zi bo ne ti kopepe ꞌdeni ŋgï yaga.” ");
INSERT INTO bex_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Bo ileki gbï ꞌböwu kiya zïnnï te, “Ŋere löbu ꞌba Bɔkoꞌba ëdï kɔzɔ lende ꞌba bɔ mɔtɔ ame kulï kupö mï nyaka bo kari koloma abo ŋgï köꞌdö nati ne. ");
INSERT INTO bex_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tine kupö naga nima ötu ëꞌbënnï ŋgï gɔ dönnï kïyöbu kinza ma bo kikali gɔmo. ");
INSERT INTO bex_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yayi na ŋgï koja ëꞌbënï. Dɔgba mo ötu rɔ dɔ biti kina kïyöbu ŋgï köyö kana dɔmo. ");
INSERT INTO bex_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tine ɔdɔ bo koŋgɔ kandi ꞌdeni yɔ na bo kiꞌdi kulu ŋgï mugu mo römöyï bo ikali kada ꞌba tumu mo na ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kina bo kileki kiya gbï te, “Ŋere löbu ꞌba Bɔkoꞌba nime ti kiyari ŋgï ti waꞌdi ga? Dɔŋgala ma tondo mo ga na ŋgï gɔ kiyari timo? ");
INSERT INTO bex_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ti këdï ŋgï kɔzɔ ꞌjɔ ꞌba a mɔtɔ ame titiyi ꞌdeki ne. Tine ɔdɔ kogba kulï mï yayi, ");
INSERT INTO bex_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","na kebe kïyöbu ŋgï yaga rɔ ŋgërï ma löbu. Kina dɔŋgila mo ga konza ŋgï yali ni kako kubö rö ꞌbënnï ga dɔ mbëlï mo.” ");
INSERT INTO bex_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mï akiyandi ꞌba Yësu ga pili bo ilende zïnnï ti dɔŋgala. Bo oꞌde dɔŋgala ꞌba lende mo zïnnï ti wa ma lïjë kikali laka. ");
INSERT INTO bex_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Zi ma laki naga nima bo iya wa pili zïnnï rɔ dɔŋgala. Tine ɔdɔ lïjë këdï ꞌdeni rɔ dönnï ti bɔ kösö gɔ bo ga tine na bo kebe ꞌjaa tïyëtï mï ꞌjɔ ꞌba lende mo ga pili zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mï dɔkɔpiyari mo nima na Yësu kiya ŋgï te zi bɔ kösö gɔ bo ga, “Ënyïke, dumuke darike gönyï pöpö ma ꞌdë.” ");
INSERT INTO bex_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kina lïjë kënyï ŋgï kola tïndï naga nima yayi lïjë këkï gɔ bo mï sorope, tumu dɔ mini nima kari gönyï pöpö ma kapa mɔtɔ. Sorope mɔtɔ ga ari gbï tïnnï yayi. ");
INSERT INTO bex_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kina lili ma kembe rɔ pïwu kiꞌdi ŋgï tome, na mini kiꞌdi ŋgï rɔ tikagba ꞌdɔ koso gönnï mï sorope. ");
INSERT INTO bex_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yësu ëdï kebe kapa sorope ma yïꞌböwu yayi köꞌdö ꞌdeni kitaka dɔ bo ti bɔŋgɔ. Kina bɔ kösö gɔ bo ga kari kindiŋi bo ŋgï kiya zi bo te, “Bɔ kɔmɔ kiyandi, ma ꞌbëyï omeri lende ze dë kpe ɔdɔ dëdï pele dölëke nati?” ");
INSERT INTO bex_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kina bo kindiŋi ŋgï yaga, bo kamo dɔ lili nima, bo kilende zi mini kikagba nima kiya te, “Ɔrɔ yaga.” Kina lili ni ti mini kikagba nima kɔrɔ ŋgï bi koꞌdɔ liwo. ");
INSERT INTO bex_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bo ileki kiya zïnnï te, “Kpe, ëddï kereke gɔ waꞌdi? Kpe gba iꞌdike dɔye dë gɔ lende ma?” ");
INSERT INTO bex_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kina lïjë ŋgï rɔ ma kere bo. Lïjë ebe tititi rönnï kiya te, “Bɔ nime bo waꞌdi ga na? Lili ni ti mini ni ŋgï kpaki rɔ akuwö dɔ bo?” ");
INSERT INTO bex_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lïjë umu ŋgï kari kömö gönyï pöpö mï dɔyayi ꞌba Gerasa. ");
INSERT INTO bex_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kina koꞌja Yësu këdï këkï di mï sorope kako yaga yɔ na dɔ bo kondɔsɔ ŋgï ti bɔ nökï mɔtɔ këdï rɔ tako di mï löŋgö dögö yayi. ");
INSERT INTO bex_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Bɔ nima nökï ilaꞌba ꞌdeni ŋgï mɔlo dɔmo kiꞌdi këdï koloma ꞌdeni ŋgï ŋburu köꞌbö mï löŋgö dögö. Bɔtɔ mɔtɔ inza kpe ame ꞌdɔ kɔꞌbɔ togbɔ bo bërï. Pele rɔ tudödu bo ti ziŋgiri onya dɔ ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Römöyï pa oloma rɔ tudödu közï bo ga komba ziŋgiri ndï bo. Tine bo öꞌbö ŋgï tïyëyï wa naga nima di rɔ bo, bo kodowe ziŋgiri ni yaga di ndï bo. Kina ŋgï bɔtɔ mɔtɔ inza kpe ame ꞌdɔ kɔꞌbɔ togbɔ bo bërï. ");
INSERT INTO bex_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kote kada löbu nime kpaki ti korɔndɔ mo ga bo öꞌbö ŋgï mï löŋgö dögö dɔ döku tulörï, bo kore rɔ bo ga ti döku. ");
INSERT INTO bex_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tine ɔdɔ bo koꞌja Yësu ŋgï ŋbö di bi kɔwɔ yɔ na bo kiriŋa ŋgï kurë dɔmo bo kari kolɔdɔ bërï kɔmɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kina bo kulörï ŋgï rɔ ma kembe kiya te, “Waꞌdi ꞌbï na tö, nï Yësu kole ꞌba Bɔkoꞌba tigɔ dɔ kiteli? Momaꞌjo rɔma zïyï ti möyï Bɔkoꞌba, kinza kodɔ gomɔ dë dɔma.” ");
INSERT INTO bex_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bo iya tara römöyï Yësu ilende zi nökï nima iya te, “Nï nökï nime ɔdɔ yaga di mï bɔ nime.” ");
INSERT INTO bex_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yësu ititi bo iya te, “Nï, möyï yï rɔ yë?” Bo iya te, “Möyï ma rɔ Tïndï. Ze rɔ ma konzi.” ");
INSERT INTO bex_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kina nökï naga nima kebe ŋgï tomaꞌjo rönnï zi Yësu kinza bo koga lïjë dë yaga di mï dɔliŋɔ nima. ");
INSERT INTO bex_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tine tïndï ꞌba baꞌdo ꞌba liŋɔ ëdï rɔ tonyo kpënnï ndï döku yayi. ");
INSERT INTO bex_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kina nökï naga nima komaꞌjo rönnï ŋgï zi Yësu, iya te, “Oja ze dari dilaꞌba dɔ baꞌdo naga nime ꞌdë.” ");
INSERT INTO bex_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yësu utï dɔmo zïnnï, iya te, “Ɔdɔke karike.” Kina nökï naga nima kɔdɔ ŋgï lïjë kari kilaꞌba dɔ baꞌdo tönë ga. Tumu ꞌba baꞌdo nima tïtëtë mo ëdï pili kɔzɔ kuluku ꞌbutë sowɔ tara (2000). Kina kënyï kiriŋa ŋgï di dɔ kulöŋgö kɔꞌdɔ nima kari kilaꞌba mï pöpö kote dönnï ŋgï pili yaga. ");
INSERT INTO bex_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kina bɔ koda baꞌdo mo naga nima kiriŋa ŋgï kari kiya lende mo mï gawo pili zi ya ma kebe gɔ nyaka naga. Kina bilaka kɔlɔ ŋgï kako toŋgɔ wa ma koꞌdɔ rönï nima. ");
INSERT INTO bex_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lïjë ako ŋgï koꞌja Yësu ni ti bɔ tönë pa ti tïndï ꞌba nökï dɔmo ne koloma ꞌdeni yayi ti bɔŋgɔ rönï dɔmo kele ꞌdeni. Kina lende mo koꞌde tikere ŋgï za zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tine ya ame ga koꞌja ti kömönnï ne na kebe ꞌjaa rɔ tïyëtï wa ma koꞌdɔ rönï zi bɔ nökï nima gbï ti tïndï ꞌba baꞌdo naga nima zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kina lïjë koloma ŋgï rɔ tomaꞌjo rönnï zi Yësu ꞌdɔ bo kënyï kari yaga di mï dɔyayi ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kina ɔdɔ bo këdï koꞌdɔ ꞌdeni tari tëkï mï sorope tine na bɔ nökï tönë kako ŋgï komaꞌjo rönï zi bo ꞌdɔ tari kɔtɔ tïnnï. ");
INSERT INTO bex_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tine bo ileki kiya zi bɔ nima te, “Ari liŋɔ zi bilaka ꞌbe ga, kina ꞌdɔ kïyëtï gɔ wa ame ga ŋere Bɔkoꞌba koꞌdɔ zïyï ne zïnnï, gbï ti mï këyï ame bo koꞌdɔ ꞌdeni zïyï ne.” ");
INSERT INTO bex_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kina bɔ tönë pa rɔ bɔ nökï ne kari ŋgï koloma rɔ tïyëtï wa ame Yësu koꞌdɔ zi bo ne pili kote mï dɔyayi nima kïdëkï möyï mo rɔ Gawo ꞌButë ne. Kina bilaka mo ga kotɔ ŋgï rɔ gönnï. ");
INSERT INTO bex_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kina ɔdɔ Yësu kumu ꞌdeni kileki kako gönyï pöpö ama tine na tïndï kotɔtɔ rönnï ŋgï zi bo kpa götö yayi. ");
INSERT INTO bex_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kina ɔdɔ bɔ mɔtɔ möyï mo rɔ Yayiro rɔ bɔ dɔ rö ꞌba mötu kako koꞌja Yësu tine na bo kilaꞌba ŋgï bërï bi ndï Yësu, ");
INSERT INTO bex_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","komaꞌjo rönï zi bo, kiya te, “Nyiti titi ma ꞌdeni ŋgï ŋgɔsi tölë, ako tɔ kpe kiꞌdi közïyï rɔmo ꞌdɔ kileŋo nï, lɔko kɔmɔ yaga di dɔ rɔkɔꞌɔ nime.” ");
INSERT INTO bex_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kina Yësu kënyï ŋgï tari kɔtɔ ti bɔ nima. Tine tïndï ma kinza kiya ari ŋgï kɔtɔ tïnnï këdï komoti bo. ");
INSERT INTO bex_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ꞌJa mɔtɔ ëdï yayi roma köꞌbö tolɔdɔ ŋgï di rɔmo kɔmɔ kɔɔ mo ꞌdeni ŋbö ꞌbutë dɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lɔko ilisa ꞌdeni timo kulöwö kebe zi bɔ wɔwɔ ma konzi kote gïrïsï ꞌdeni ŋgï di közïnï. Tine ma kɔtɔ mɔtɔ mo okɔnyi nï dë du te, kina koꞌdɔ ŋgï konye. ");
INSERT INTO bex_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Lɔko uwö lëbï ꞌba Yësu ꞌdeni na lɔko kako ŋgï kebe gɔ bo rɔ mï löŋgö bilaka konzi nima, na lɔko kosa kpa bɔŋgɔ ꞌba rɔ bo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Römöyï lɔko omeri ꞌdeni kiya te, “Ɔdɔ kiya te mosa pele ŋge rɔ kpa bɔŋgɔ ꞌba rɔ bo ti kileŋo ma ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mï tosa nima lɔko kosa kpa bɔŋgɔ nima yɔ na roma ꞌbënï tönë koke kpënï ŋgï, lɔko kikali gɔmo di mï yida rönï, ileŋo nï ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tine Yësu ikali gɔmo ŋgï ma tigɔ kɔdɔ di mï yida rɔ bo, kina bo kuyï kɔmɔ bo ŋgï kititi bilaka konzi naga nima, kiya te, “Yë na kosa rɔ bɔŋgɔ ma?” ");
INSERT INTO bex_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bɔ kösö gɔ bo ileki dɔmo zi bo iya te, “Tïndï nime kuru yi ne oŋgɔ te, ne rɔ ma tondo mo ga na këddï kititi ma ꞌbëyï ꞌböwu kiya te, ‘Yë na kosa rɔ bɔŋgɔ ma?’” ");
INSERT INTO bex_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tine Yësu ëdï nduwë gba rɔ toŋgɔ bɔtɔ nima kosa rɔ bo ne. ");
INSERT INTO bex_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ꞌJa tönë ikali gɔ wa ma koꞌdɔ rönï nime ꞌdeni na lɔko kako ŋgï ti tikere ti rɔ kïlëꞌdï kilaꞌba bërï bi ndï Yësu, lɔko kïyëtï gɔ wa ma koꞌdɔ rönï zïnï. ");
INSERT INTO bex_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yësu ileki zïnï iya te, “Nyiti ma, tiꞌdi döyï gɔ tigɔ ma na kileŋo yi ꞌdeni. Ari ti, ti mï këyï rɔkɔꞌɔ nima kola yi yaga.” ");
INSERT INTO bex_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kota Yësu këdï gba rɔ tilende zi ꞌja nima na bɔ laja kömö ŋgï di liŋɔ ꞌba bɔ tönë rɔ Yayiro ne. Lïjë iya zi bo te, “A ꞌba nyiti ꞌbï tönë, bilaka ënyë ꞌdeni kinza komaꞌjo bɔ kɔmɔ kiyandi dë ka kpe ndeŋi.” ");
INSERT INTO bex_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yësu uyï mbili bo le mökö di zi lende ꞌbënnï nime. Bo ileki kiya zi Yayiro te, “Kinza kere dë, tigɔ ma na kiꞌdi döyï gɔmo.” ");
INSERT INTO bex_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yësu ola bilaka ma konzi naga nima dë kpe kari tïnnï, bo ogba ŋge rɔ Pïtörö ni ti Yakoba ni ti bɔ löndö bo Yowani. ");
INSERT INTO bex_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lïjë ari ŋgï kömö liŋɔ ꞌba Yayiro bɔ dɔ rö ꞌba mötu nima yayi kari koꞌja bilaka ŋgï këdï bi monɔ, lende konya ŋgï ŋbaŋi, këdï kome kuwu ni konyo kökö. ");
INSERT INTO bex_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kina ɔdɔ Yësu kɔdɔ ŋgï ꞌdeni mï liŋɔ yayi tine, bo iya zïnnï te, “Waꞌdi ga na lende konya ŋgï ŋbaŋi te gɔmo? Ëddï kuduke gɔ waꞌdi? Nyiti titi nime ölë dë rɔ tölë tine lɔko ëdï ŋge köꞌdö.” ");
INSERT INTO bex_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kina lïjë kögö bo ŋgï rɔ laŋa. Bo oga lïjë ŋgï pili kɔdɔ yaga. Kina bo kogba ꞌbu mo ni ti ma mo ti bɔ kösö gɔ bo ga ma mota mo tönë ga ŋgï lïjë kɔdɔ rö gɔ töku nima yayi. ");
INSERT INTO bex_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bo indaꞌba közïmo kilende teyi te, “Talita kumï.” Ame ꞌjɔ ꞌba lende mo tëgë, “Nyiti titi, milende zïyï, ënyï tɔrɔ.” ");
INSERT INTO bex_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kina töku tönë kindiŋi ŋgï kënyï tɔrɔ kebe tiliŋgere. Kɔmɔ kɔɔ ꞌbënï ꞌdeni ꞌbutë dɔmorïyö. Kina lende mo kigayi bilaka ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tine Yësu ose gɔmo kitigɔ zïnnï kinza lïjë kiya lende mo dë zi bɔtɔ mɔtɔ. Kina bo kiya zi ma mo ni te, “Iꞌdike akonyo zïnï lɔko konyo.” ");
INSERT INTO bex_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yësu ënyï di yayi kileki kari mï dɔyayi ꞌbënnï. Tine bɔ kösö gɔ bo ga ozi ŋgï kɔtɔ kari ti bo. ");
INSERT INTO bex_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mï kada ꞌba rɔ kindawo na bo koloma ŋgï rɔ tiyandi wa mï rö ꞌba mötu yayi. Kina ma konzi ame ga pili kuwö ne kotɔ ŋgï rɔ gönnï. Lïjë ebe rɔ tititi mo kiya te, “Bɔ nime bo oꞌja a naga nime kulöwö te di yala? Bo oꞌja akikali naga nime te di yala ga? Gɔ kotɔ löbu naga nime bo ëdï koꞌdɔ ŋgï te totondo ga? ");
INSERT INTO bex_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tara ne bo na dë rɔ bɔ kose ŋgërï tönë kole ꞌba Mariya? Löndö bo mɔtɔ mo ga na dë me rɔ Yakoba ni ti Yose ti Yuda ti Simona ne? Lëmï bo ga na dë me gbï tize bine ne?” Kina lïjë kilagi lende abo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yësu ënyï kileki kiya zïnnï te, “Rɔ ma laka, bilaka ꞌba mï gɔ bi ma laki pili rɔ ma koro bɔ kumë lende. Tine bilaka ꞌba dɔyayi abo ga, ti ma wado abo ga oro bo dë.” ");
INSERT INTO bex_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kina ŋgï bo oꞌdɔ gɔ kotɔ ma löbu dë kpe kulöwö yayi, tine bɔ rɔkɔꞌɔ ma ndö te na ŋge bo kiꞌdi közï bo rɔmo kileŋo. ");
INSERT INTO bex_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lende ꞌbënnï lïjë ame ga rɔ ꞌba bo ne kiꞌdi dönnï dë gɔ lende abo ne ebe kigayi bo ŋgï yaga. Bo ënyï ŋgï kari mï tïrï mɔtɔ ga yayi koloma rɔ tiyandi kɔmɔ bilaka. ");
INSERT INTO bex_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kina bo kïdëkï lïjë ma ꞌbutë dɔmorïyö mo tönë ga ŋgï bi kɔtɔ koja lïjë kari rɔ rïyörïyö tuwöwö lende ꞌba Bɔkoꞌba. Bo iꞌdi tigɔ ŋgï zïnnï taꞌda nökï ni timo. ");
INSERT INTO bex_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tine bo ose zïnnï kinza lïjë kogba a mɔtɔ dë kari timo mï liŋgere ꞌbënnï nima. Tine lïjë kogba ŋge rɔ përï. Kinza lïjë kogba maŋgolɔꞌbɔ dë tïnnï ala mboꞌda ꞌba kpasi ala yamo kiŋgali dɔmo kpa bɔŋgɔ. ");
INSERT INTO bex_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lïjë kusu wari ŋge ndïnnï, kogba mɔtɔ dë rɔ tötï teyi. ");
INSERT INTO bex_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bo ose zïnnï te, “Liŋɔ ame kolomake ꞌdeni teyi, olomake yïmo ŋbö kënyïke di mï gawo nima. ");
INSERT INTO bex_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tine gɔ bi ame ga koꞌdɔkɔ dë tuwö lende ꞌbe kilagi ye koga ye ne, ënyïke ombake lupu mo yaga di ndïye rɔ lömu rönnï.” ");
INSERT INTO bex_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kina lïjë kari ŋgï koloma rɔ tuwöwö mo zi bilaka ꞌdɔ kotɔ dönnï di mï lende kënyë. ");
INSERT INTO bex_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lïjë iꞌdi nökï ŋgï kitaꞌba yaga di dɔ ma konzi. Kina lïjë kondi ꞌbu ŋgï kileŋo bɔ rɔkɔꞌɔ ma konzi timo. ");
INSERT INTO bex_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kina bɔ dɔliŋɔ Erode kuwö lende mo ŋgï gbï römöyï lëbï ꞌba Yësu ogba mï dɔyayi nima ꞌdeni. Ya mɔtɔ ga iya te, “Yowani bɔ bapatisi na kɔdɔ ꞌdeni yaga di mï tölë, kina ma kiꞌdi bo ŋgï këdï ti tigɔ kulöwö tara ne.” ");
INSERT INTO bex_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tine ya mɔtɔ ga iya ma ꞌbënnï te, “Eliya na.” Kina ya mɔtɔ ga iya ma ꞌbënnï te, “Bɔ kumë lende ꞌba Bɔkoꞌba ma kɔzɔ ma dɔgba tönë ga mɔlo bine ne na.” ");
INSERT INTO bex_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kina ɔdɔ Erode kuwö lende mo ꞌdeni tara tine, bo iya te, “Yowani ma tönë miꞌdi koke dɔmo yaga ne bo na me kɔdɔ ꞌdeni gbï.” ");
INSERT INTO bex_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erode bo na tönë kiꞌdi kindaꞌba Yowani kudödu kuꞌdu mï maboso ne. Erode bo oꞌdɔ lende nima tara gɔ köꞌdu ꞌba Erodiya ꞌja ꞌba bɔ löndö bo Pïlïpö ame bo Erode kebe kuyï kɔmɔ mo ꞌdeni yaga ne. ");
INSERT INTO bex_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Römöyï Yowani oloma rɔ tiya mo nduwë zi bo te, “Tuyï kɔmɔ ꞌja ꞌba löndö ele dë. Tïyëyï mï köꞌdu kiꞌdi ꞌba Bɔkoꞌba na.” ");
INSERT INTO bex_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kina Erodiya mo tönë kindaꞌba tiyeli ŋgï rɔ Yowani kiteri tupö mo yaga. Tine kɔri ꞌba tupö bo lɔko oꞌja dë, ");
INSERT INTO bex_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","römöyï Erode gbï rɔ ma kere Yowani. Bo ikali ŋgï Yowani bɔ lende laka ꞌba Bɔkoꞌba na. Kina bo kogba Yowani ŋgï ŋge kuꞌdu tara mï maboso. Tine lende kiya ꞌba Yowani ga këdï kiꞌdi bo pele ŋgï rɔ meri, bo oꞌdɔkɔ tuwö mo nduwë. ");
INSERT INTO bex_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tine kina kari koꞌdɔ rönï ŋgï yaga rɔ gɔ kele zi Erodiya. Mï kada mo nima Erode oja karama ꞌba kada ꞌba töyö bo ŋgï kose bilaka ma rɔ löbu mï turu abo nima ŋgï pili ti bɔ dɔ bɔ kanya ni ti bɔ mɔri ma mï Galilaya. ");
INSERT INTO bex_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kina nyiti ꞌba Erodiya kako kusï ŋgala ŋgï kɔmɔ ŋba naga nima. Kina lende mo koŋmi ŋgï sowa dökïꞌdï Erode ni pili ti ŋba abo naga nima. Kina bɔ dɔliŋɔ Erode kënyï ŋgï kiya zi nyiti nima te, “Ɔtɔ ame koꞌdɔkɔ ne, ïdëkï di zö, kina ti miꞌdi ŋgï zïyï.” ");
INSERT INTO bex_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bo oꞌdɔ lömu ŋgï yïmo zïnï kiya te, “Ɔtɔ ame kïdëkï di zö ti miꞌdi ŋgï zïyï. Ala ëdï pele rɔ kapa ꞌba dɔliŋɔ ma nime na kïdëkï, ti miꞌdi ŋgï zïyï.” ");
INSERT INTO bex_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kina lɔko kari ŋgï kititi mönï kiya te, “ꞌDɔ waꞌdi na mïdëkï?” Mönï iya te, “Dɔ Yowani bɔ bapatisi na kari kïdëkï.” ");
INSERT INTO bex_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kina lɔko kiriŋa ŋgï welo kari kiya zi bɔ dɔliŋɔ Erode te, “Dɔ Yowani bɔ bapatisi na kiꞌdi zö gïrï nime bine mï kitaꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Erode ŋgï rɔ meri gɔ lende mo, tine gɔ lömu ame bo koꞌdɔ ꞌdeni kɔmɔ ŋba abo ga ne bo ɔꞌbɔ dë kpe tuyï yïmo. ");
INSERT INTO bex_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kina bo koja bɔ kanya ŋgï kari koꞌde dɔ Yowani. Bɔ kanya nima ari ŋgï mï maboso yayi koke dɔ Yowani ");
INSERT INTO bex_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","koꞌde mï kitaꞌba kiꞌdi zi nyiti nima. Kina lɔko koto ŋgï kari zi mönï. ");
INSERT INTO bex_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tine ɔdɔ bɔ kösö gɔ Yowani ga kuwö lende mo ꞌdeni tara yɔ na lïjë kako ŋgï gɔ töku bo kombi kari kusu. ");
INSERT INTO bex_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bɔ laja tönë ga ileki ŋgï kako kïyëtï gɔ wa ame ga pili lïjë koꞌdɔ kiyandi gbï ne ŋgï zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tine tïndï öꞌbö ŋgï ŋburu ŋbaŋi tïnnï këdï kari mɔtɔ ga këdï kako nduwë yïmo, kola bi ꞌba tonyo ɔtɔ ga dë kpe zi Yësu ni ti bɔ kösö gɔ bo ga. Kina bo kiya ŋgï zi bɔ kösö gɔ bo ga te, “Ënyïke, darike titi mbowa yaga bi mɔtɔ rɔ dɔze gɔ kindawoke rɔye.” ");
INSERT INTO bex_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kina lïjë kënyï ŋgï këkï mï sorope tari titi mbowa yaga rɔ dönnï. ");
INSERT INTO bex_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tine ma konzi oꞌja lïjë ŋgï këdï rɔ tari na kikali lïjë ŋgï. Kina bilaka kënyï ŋgï pili di mï gawo ma yayi naga nima kiriŋa kurë dönnï kömö ŋgï gba gɔ bi ma lïjë këdï kari teyi mo tönë. ");
INSERT INTO bex_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kina ɔdɔ Yësu këkï di mï sorope tine bo oꞌja bilaka ꞌdeni ŋgï yayi rɔ tïndï ma kinza kiya. Lende ꞌbënnï oꞌde lisa ŋgï kɔmɔ bo römöyï lïjë ŋgï kɔzɔ kamölö ame ga bɔ koda mo kinza ne tara. Na bo koloma ŋgï rɔ tiyandi lïjë ti lende ma konzi. ");
INSERT INTO bex_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kina ɔdɔ kada këdï koꞌdɔ ꞌdeni tösö tine na bɔ kösö gɔ bo ga kako ŋgï zi bo kiya te, “Oŋgɔ te, gɔ bi nime bine rɔ yï mökö, kada inza kpe. ");
INSERT INTO bex_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Oja bilaka naga nima lïjë kari mï liŋɔ ti mï tïrï ma ŋgɔsi bine gɔ lïjë kari kugö ɔtɔ ga zïnnï tonyo mo.” ");
INSERT INTO bex_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bo ënyï kileki dɔmo zïnnï te, “Kpe na kiꞌdike zïnnï lïjë konyo.” Lïjë ititi bo iya te, “Oꞌdɔkɔ gɔ dari dugö akonyo ti kïsï rïyö tiꞌdi mo zïnnï?” ");
INSERT INTO bex_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Bo ititi lïjë iya te, “Ëddïke ti maŋgolɔꞌbɔ ndö bina? Ari koŋgɔke te.” Kina ɔdɔ lïjë kari koŋgɔ ꞌdeni tine lïjë ako kiya te, “Dëdï timo muyï, ti kenze mo ga rïyö teyi.” ");
INSERT INTO bex_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bo iya zïnnï lïjë kiyija bilaka naga nima koloma bërï rɔ dɔtumu dɔ mɔli ma kunzï. ");
INSERT INTO bex_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bilaka naga nima oloma ŋgï rɔ dɔtumu, mɔtɔ ga kuluku rïyö mɔtɔ ga kuluku kɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kina bo kogba maŋgolɔꞌbɔ muyï tönë ga ŋgï ti kenze rïyö mo tönë ga, bo koŋgɔ bi mïtɔrɔ kileki yëëꞌdï zi Bɔkoꞌba. Kina bo konye yïmo ŋgï bo kiꞌdi zi bɔ kösö gɔ bo ga lïjë kari koza zi bilaka naga nima. Kina bo koza kenze rïyö mo tönë ga ŋgï gbï pili gɔmo. ");
INSERT INTO bex_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kina bilaka naga nima pili rɔ gɔmo konyo ŋgï kïtëkpë lïjë. ");
INSERT INTO bex_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bɔ kösö gɔ bo ga ari kutöꞌdu kɔsɔ ma kileke bërï mo ga ŋgï koso mï kee ꞌbutë dɔmorïyö. ");
INSERT INTO bex_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bilaka naga nima konyo a nima ne tïtëtë mo bɔtɔni mo ga ŋbö kuluku ꞌbutë bi ꞌbutë (5000). ");
INSERT INTO bex_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kina bo kiꞌdi bɔ kösö gɔ bo ga ŋgï këkï mï sorope ꞌdɔ lïjë kari tötï dɔgba gönyï pöpö mï Betesayida. Bo ileke ma ꞌba bo ŋgï titi tiꞌdi bilaka naga nima gɔ kɔri. ");
INSERT INTO bex_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Di pötö lïjë kari ꞌdeni na bo kari ŋgï dɔ döku tumötu. ");
INSERT INTO bex_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mï dɔkɔpiyari mo tine sorope ꞌdeni ŋgï ŋbö mï zana mini, bo këdï ma ꞌba bo gba kutu bo yï mökö. ");
INSERT INTO bex_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bo oŋgɔ lïjë ëdï ŋgï rɔ tilisa ti tugë sorope, römöyï lili ëdï kome za kako di kömönnï. Mï kano bi ꞌdeni tine na bo kiꞌdi tako ŋgï zïnnï bo këdï kiliŋgere kebe dɔ mini. Bo iteri ꞌdɔ bo kiteli kebe ŋgila lïjë. ");
INSERT INTO bex_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tine lïjë oꞌja bo ŋgï na lïjë kembe ŋgï rɔ tulörï, kiya te, “Sëgë na.” ");
INSERT INTO bex_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Römöyï lïjë nima pili oꞌja bo na koꞌde tikere ŋgï sowa zïnnï. Tine bo ënyï kileki zïnnï te, “Ogbɔke dökïꞌdï ye. Ma na. Kinza kereke dë.” ");
INSERT INTO bex_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bo ëkï ŋgï mï sorope gönnï yayi na lili tönë kɔrɔ ŋgï. Kina lende mo kebe kigayi lïjë ŋgï, ");
INSERT INTO bex_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","römöyï minyi ꞌbënnï lende ꞌba maŋgolɔꞌbɔ nima pele ɔdɔ dë dönnï. ");
INSERT INTO bex_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Di yayi na lïjë kako kömö ŋgï kpa götö mï dɔyayi ꞌba Genesareta kudödu sorope yayi. ");
INSERT INTO bex_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Koꞌja lïjë këdï këkï gba rɔ tëkï yaga di mï sorope te, na bilaka kikali Yësu ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kina lëbï abo kitaꞌba ŋgï kote mï gɔ bi nima, na koloma ŋgï rɔ tombi bɔ rɔkɔꞌɔ ni ti laŋba kɔlɔ kari timo bi ame kuwö ꞌdeni bo këdï teyi ne. ");
INSERT INTO bex_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mï liŋɔ ti gawo ame ga pili bo kudö kebe teyi ne, oꞌde bɔ rɔkɔꞌɔ ŋgï koꞌba nduwë rɔ kpa kɔri. Lïjë omaꞌjo rönnï ŋgï zi bo ꞌdɔ bo kiꞌdi lïjë tɔ kpe kosa kpa bɔŋgɔ ꞌba rɔ bo. Kina ame ga pili kosa kpa bɔŋgɔ ꞌba rɔ bo ne, ileŋo ŋgï di dɔ rɔkɔꞌɔ mo ga. ");
INSERT INTO bex_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kina Parosi ni ti bɔ kɔmɔ kiyandi mɔtɔ ga ame kako di Yerosalema ne kotɔtɔ ga rönnï ŋgï ŋgila Yësu. ");
INSERT INTO bex_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lïjë oꞌja ꞌdeni bɔ kösö gɔ bo mɔtɔ ga këdï konyo wa ŋgï tara kinza ma lïjë koꞌdɔ dölëtï ꞌba közï kurögö dë. ");
INSERT INTO bex_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Römöyï Parosi ni ti Yudayi pili onyo wa dë tara kinza ma kurögö közï titi dɔgba gɔ dölëtï mo ma mɔlo tönë. ");
INSERT INTO bex_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wa ame ga pele kugö di mï bi ꞌba ndögö ne, urögö titi dɔgba na ꞌjaa konyo. Dölëtï ma konzi mɔtɔ ga ëdï gbï zïnnï ŋbaŋi toro mo, kɔzɔ ꞌba turögö rɔ kösu ni ti kete ni ti gata. ");
INSERT INTO bex_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kina Parosi ni ti bɔ kɔmɔ kiyandi naga nima kënyï kititi Yësu, kiya te, “Gɔ waꞌdi na bɔ kösö göyï ga koro dölëtï ma mɔlo ꞌba ꞌbu ze löbu ga dë, lïjë këdï konyo wa ŋgï tara kinza ma lïjë kurögö közïnnï dë?” ");
INSERT INTO bex_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yësu ileki dɔmo zïnnï, iya te, “Kpe bilaka bɔ kɔmɔ kandi naga nime, Yesaya na ŋgï kikali tumë lende gɔ köꞌdu ꞌbe. Ame tönë bo kugu kiya te, ‘Bilaka naga nime lïjë oro ma ŋere Bɔkoꞌba ŋge ti kpënnï, tine mïnnï ŋbö rɔ ma kɔwɔ di zö. ");
INSERT INTO bex_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mötu ꞌbënnï ka rɔ a yawa, römöyï köꞌdu kiꞌdi ꞌbënnï ꞌba bilaka lesi na za lïjë kebe tiyandi mo kiya rɔ lende ma ꞌba Bɔkoꞌba na.’ ");
INSERT INTO bex_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kpe ebe kolake köꞌdu kiꞌdi ꞌba Bɔkoꞌba za yaga kösöke gɔ dölëtï ꞌba bilaka lesi. ");
INSERT INTO bex_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kɔmɔ kandi nima ziye ne, ebeke tilagi lende ꞌba Bɔkoꞌba le yaga rɔ ma këyï, tine dölëtï ꞌbe ga na kubïke gɔmo liki. ");
INSERT INTO bex_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Römöyï Musa ugu ꞌdeni mï köꞌdu kiꞌdi iya te, ‘Oro ꞌbu yï ni ti möyï. Bɔtɔ ame kumu kpa bo gɔ ꞌbu bo ni ti ma bo ne kölë yaga.’ ");
INSERT INTO bex_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ne ma ꞌbeye ebe kiyake te, ɔdɔ nï mɔtɔ këddï pele ti wa ꞌdɔ kokɔnyi ꞌbu yï ni ti möyï timo, ɔdɔ kiya ꞌdeni te ëdï rɔ Korobano, ame ꞌjɔ ꞌba lende mo tëgë ꞌdeni rɔ ꞌba Bɔkoꞌba ne, ");
INSERT INTO bex_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","iꞌdi bo ŋgï dë kpe tokɔnyi lïjë. ");
INSERT INTO bex_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kina kiꞌdi ye ŋgï kirasike mï lende ꞌba Bɔkoꞌba gɔ köꞌdu ꞌba dölëtï ꞌbe ga ti wa ma konya mɔtɔ ga ame këddï koꞌdɔke ne.” ");
INSERT INTO bex_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kina Yësu kïdëkï bilaka ma konzi ŋgï kako zi bo, bo kiya zïnnï te, “Kpe pili ojeke mbili ye kuwöke dɔma laka. ");
INSERT INTO bex_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Wa ame ga pili këdï kari di yaga mï bilaka ne iꞌdi bɔtɔ dë këdï rɔ tiꞌda di kɔmɔ Bɔkoꞌba. Tine wa ame ga këdï kɔdɔ kako yaga di mï bilaka ne na këdï kiꞌdi bilaka rɔ tiꞌda.” ");
INSERT INTO bex_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kina ɔdɔ bo kënyï ꞌdeni di mï löŋgö tïndï naga nima bo kari kɔdɔ ꞌdeni rö tine, na bɔ kösö gɔ bo ga kako ŋgï zi bo tititi bo gɔ ꞌjɔ ꞌba dɔŋgala nima. ");
INSERT INTO bex_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Bo ileki zïnnï iya te, “Kpe gbï gba tara ikalike lende dë kebe lïjë ma laki mo naga nima? Ikalike dë su, wa ame këdï kɔdɔ di yaga kari mï bilaka ne iꞌdi bɔtɔ dë rɔ tiꞌda di kɔmɔ Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Römöyï ari dë mï dökïꞌdï, tine ari ŋge mï tokpe na koja ŋgï kɔdɔ yaga di mï yida rɔ.” Mï lende kiya nime bine, Yësu odɔrɔ gɔmo ꞌdeni akonyo pili rɔ gɔmo rɔ ma kele zi bilaka tonyo mo. ");
INSERT INTO bex_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kina bo koto nati ŋgï nduwë tiya mo zïnnï te, “Wa ame ga këdï kɔdɔ kako yaga di mï bilaka ne na këdï kiꞌdi bilaka rɔ tiꞌda di kɔmɔ Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Römöyï di mï dökïꞌdï bilaka na meri kënyë ꞌba toꞌdɔ ꞌbögö ni ti löpö ");
INSERT INTO bex_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ti yërï ti mï kombi ti dɔkomali wa ma rɔ tiꞌda naga pili këdï kɔdɔ ti ꞌbölu ni ti lende kinza rɔ kaya ti mï kututu ti kore ti dɔ kombi ni ti lende koꞌdɔ dɔ rumö. ");
INSERT INTO bex_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wa kënyë naga nime pili ëdï kɔdɔ di mï bilaka lesi, kina lïjë na këdï kiꞌdi bilaka rɔ tiꞌda di kɔmɔ Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kina Yësu kënyï ŋgï di yayi kari mï dɔyayi ꞌba Tura. Bo ari koloma liŋɔ mɔtɔ, tine bo oꞌdɔkɔ dë gɔ bilaka ma konzi kikali ma bo këdï yayi. Pele na lëbï abo kitaꞌba ŋgï welo. ");
INSERT INTO bex_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ꞌJa mɔtɔ yayi nyiti mo rɔ nökï uwö lende ꞌba Yësu na lɔko kako ŋgï kilaꞌba bërï bi ndï Yësu. ");
INSERT INTO bex_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Lɔko inza rɔ Yudayi, öyö nï mï Pönïkë mï dɔyayi ꞌba Surïya. Lɔko ako komaꞌjo rönï zi Yësu ꞌdɔ koga nökï yaga di dɔ nyiti ꞌbënï. ");
INSERT INTO bex_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tine Yësu ileki dɔmo zïnï iya te, “Ma laka mo zize tiꞌdi akonyo gba zi kole titi. Inza rɔ ma laka togba akonyo ꞌba kole titi tuꞌdu mo zi bï.” ");
INSERT INTO bex_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lɔko ileki dɔmo te, “Ŋere, pele rɔ ruruzu ame ga këdï kilayi bërï di kpa kole titi ne ola ŋgï zi bï.” ");
INSERT INTO bex_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kina Yësu kileki dɔmo ŋgï zïnï iya te, “Rɔ ma laka gɔ dɔ lende kileki ꞌbï nima, ari ti liŋɔ, nökï itaꞌba ꞌdeni di dɔ nyiti ꞌbï.” ");
INSERT INTO bex_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lɔko ari koꞌja nyiti ꞌbënï tönë köꞌdö ꞌdeni dɔ bi ꞌba töꞌdö. Rɔ ma laka nökï mo tönë ola ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yësu ënyï ŋgï di mï dɔyayi ꞌba Tura yayi kumu kebe mï Sidona kari nduwë kpa pöpö ꞌba Galilaya. Bo ari ti kɔri ame kudö te kebe mï dɔyayi ma kïdëkï rɔ Gawo ꞌButë ne. ");
INSERT INTO bex_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ya mɔtɔ ga oꞌde bɔ mɔtɔ mbili mo kuꞌbë ëꞌbënï ꞌdeni mɔlo teyi kpamo kudödu ŋgï kako zi Yësu. Lïjë omaꞌjo rönnï zi bo ꞌdɔ bo kiꞌdi közï bo rɔmo bo kileŋo. ");
INSERT INTO bex_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kina Yësu kogba bɔ nima ŋgï kari timo mbowa yaga di mï löŋgö tïndï, bo kiꞌdi dɔkole közï bo mbili mo. Bo otoꞌbi woro kosa rɔ dɔndeꞌde bɔ nima. ");
INSERT INTO bex_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kina bo kombi kɔmɔ bo ŋgï mïtɔrɔ bo kawo rɔ ma kembe, bo kiya te, “Epata.” Ame ꞌjɔ ꞌba lende mo tëgë, “Urögö röyï yaga rɔ gböŋö.” ");
INSERT INTO bex_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kina mbili bɔ tönë kapi ŋgï kpamo kope rönï yaga, kebe ŋgï tilende rɔ ma laka. ");
INSERT INTO bex_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tine Yësu ose gɔmo zïnnï kinza lïjë kari kiya lende mo dë zi bɔtɔ mɔtɔ. Bo ose gɔmo pele kitigɔ te nime, lïjë ari kïyëlë lende abo ŋgï kulöwö rɔ dɔ kiteli. ");
INSERT INTO bex_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kina lende mo kigayi lïjë ame ga pili kuwö ne ŋgï rɔ mbëmbë. Kina lïjë kebe ŋgï rɔ tiya mo te, “Yësu oꞌdɔ lende kele sowa, bo iꞌdi bɔ mbili kuꞌbë ni kuwö bi yaga, bɔ kpa kudödu ni kilende.” ");
INSERT INTO bex_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mï kada naga nima yayi ꞌböwu gbï na tïndï ma kinza kiya kotɔtɔ rönnï ŋgï kako zi Yësu. Kina ɔdɔ ɔtɔ kinza kpe zïnnï tonyo mo tine na Yësu kïdëkï bɔ kösö gɔ bo ga ŋgï kako zi bo. Na bo kiya zïnnï te, ");
INSERT INTO bex_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ma rɔ meri gɔ lende ꞌba bilaka naga nime römöyï lïjë oꞌdɔ töꞌdö ꞌdeni ŋbö dɔ mota tö bine, ɔtɔ inza kpe zïnnï tonyo mo. ");
INSERT INTO bex_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ɔdɔ kiya te moja lïjë ŋgï kari tara ti ꞌbö mɔtɔ ga ëdï kidaki gɔ kɔri. Ya mɔtɔ ga di mï löŋgö lïjë nima bina ako ŋbö di bi kɔwɔ.” ");
INSERT INTO bex_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bɔ kösö gɔ bo ga ileki zi bo iya te, “Bi na me rɔ yï mökö, ti koꞌja akonyo di yala ꞌdɔ kɔꞌbɔ bilaka konzi naga nime?” ");
INSERT INTO bex_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bo ileki kititi lïjë, iya te, “Ëddïke ti maŋgolɔꞌbɔ ndö bina?” Lïjë iya te, “Modɔmorïyö.” ");
INSERT INTO bex_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kina bo kiya ŋgï zi bilaka naga nima ꞌdɔ koloma bërï. Kina bo kogba maŋgolɔꞌbɔ modɔmorïyö mo tönë ga ŋgï, bo kileki yëëꞌdï mo zi Bɔkoꞌba, na bo konye yïmo ŋgï kiꞌdi zi bɔ kösö gɔ bo ga, lïjë kari koza zi bilaka naga nima. Kina lïjë kari koza ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Lïjë ëdï gbï ti kole kenze mbowa yayi. Kina bo kogba ŋgï gbï kileki yëëꞌdï mo, na bo kiya gbï zi bɔ kösö gɔ bo ga ꞌdɔ lïjë kari gbï timo koza zi bilaka naga nima. ");
INSERT INTO bex_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Bilaka naga nima pili rɔ gɔmo onyo ŋgï kïtëkpë. Tïtëtë mo ëdï pili kɔzɔ kuluku ꞌbutë bi modɔɔmota (4000) tara. Kina bɔ kösö gɔ bo ga kari kutöꞌdu kɔsɔ ma kileke bërï mo ga ŋgï koso mï kee modɔmorïyö. Yësu iꞌdi bilaka naga nima ŋgï gɔ kɔri, ");
INSERT INTO bex_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kina lïjë ti bɔ kösö gɔ bo ga këkï ŋgï mï sorope tumu tari mï dɔyayi ꞌba Dalamanota. ");
INSERT INTO bex_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kina Parosi ni kako ŋgï koloma rɔ toꞌdɔ kowasa ti Yësu, toꞌba bo timo. Lïjë iteri bo gɔ bo koꞌdɔ gɔ kotɔ ame gɔ kileme tigɔ ꞌba Bɔkoꞌba di mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tine bo awo ŋgï rɔ ma kembe, bo kiya zïnnï te, “Gɔ waꞌdi na dɔ kupö ma leꞌjete nime këdï kiteri ma ꞌbënnï gɔ kotɔ di mï dɔyayi ꞌba mïtɔrɔ? Rɔ ma laka mëdï miya ziye, inza kileme du te zïnnï, lïjë bilaka naga nima.” ");
INSERT INTO bex_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kina bo kënyï ŋgï këkï mï sorope lïjë kileki gönyï pöpö ma kapa mɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dɔ bɔ kösö gɔ bo ga udölu ꞌdeni di bi togba maŋgolɔꞌbɔ zïnnï. Kɔsɔ mo ola ꞌdeni ŋge kɔtɔ mï sorope yayi. ");
INSERT INTO bex_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bo iya zïnnï te, “Kpe, iꞌdike kɔmɔye kandi laka di zi laŋga ꞌba Parosi ni ti ꞌba Erode.” ");
INSERT INTO bex_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kina lïjë kebe ŋgï rɔ tiya mo rɔ gɔ rönnï te, “Bo ëdï kiya tara gɔ ame dinzake ti maŋgolɔꞌbɔ ne?” ");
INSERT INTO bex_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tine Yësu ikali meri ꞌbënnï nima ŋgï. Na bo kiya zïnnï te, “Kpe nime, gɔ waꞌdi na këddï kiyake lende ꞌba maŋgolɔꞌbɔ ma kinza gɔmo? Kpe gba ikalike tigɔ ma dë kiꞌdike dɔye gɔmo? Kpe ŋgï rɔ wa dɔ kïrïndï tɔ ne ga? ");
INSERT INTO bex_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ëddïke ŋgï ti kɔmɔ, tine oꞌjake dë? Ëddïke ŋgï ti mbili, tine uwöke dë? ");
INSERT INTO bex_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Me tönë monye mï maŋgolɔꞌbɔ muyï zi bilaka kuluku ꞌbutë bi ꞌbutë (5000) konyo ne lende mo udölu ꞌdeni di dɔye? Utöꞌduke kɔsɔ ma kileke mo ga koso mï kee ndö?” Lïjë iya te, “Kee ꞌbutë dɔmorïyö.” ");
INSERT INTO bex_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bo iya te, “Kina me ma tönë gbï monye mï maŋgolɔꞌbɔ modɔmorïyö zi ma kuluku ꞌbutë bi modɔɔmota (4000) tönë ga ne, utöꞌduke kɔsɔ mo koso mï kee ndö?” Lïjë iya te, “Kee modɔmorïyö.” ");
INSERT INTO bex_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kina bo kileki zïnnï te, “Pele te nime gba kpe iꞌdike dɔye dë gɔ tigɔ ma?” ");
INSERT INTO bex_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lïjë ari kömö Betesayida na ya mɔtɔ ga yayi koꞌde bɔ kɔmɔ kölu mɔtɔ ŋgï kako zi Yësu. Lïjë omaꞌjo rönnï zi bo ꞌdɔ bo kosa rɔ bɔ nima kileŋo. ");
INSERT INTO bex_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tine bo indaꞌba közï bɔ kɔmɔ kölu nima ŋgï kokɔkɔ kari timo mbowa yaga di mï gawo. Bo otoꞌbi woro kɔmɔ mo bo kiꞌdi közï bo dɔmo, na bo kititi kiya te, “Oꞌja ɔtɔ?” ");
INSERT INTO bex_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bɔ nima urë kɔmɔ bo koŋgɔ, na kiya te, “Yëë, moꞌja bilaka tine lïjë inda ŋgï kɔzɔ ŋgërï naga tara këdï kiliŋgere.” ");
INSERT INTO bex_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yësu ileki ꞌböwu kiꞌdi közï bo kɔmɔ bɔ nima. Bɔ nima ulö kɔmɔ bo ŋgï koŋgɔ gɔ bi na kɔmɔ mo kɔpɔ ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yësu oja bo kileki kari liŋɔ kose gɔmo zi bo te, “Nï, kinza kileki dë kari mï gawo nime.” ");
INSERT INTO bex_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yësu ni ti bɔ kösö gɔ bo ga ënyï ŋgï tari mï dɔyayi ꞌba Kayisariya Pïlïpö. Di gɔ kɔri na bo koloma ŋgï rɔ tititi lïjë kiya te, “Iyake zö te. Bilaka ëdï kiya ma rɔ yë?” ");
INSERT INTO bex_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lïjë iya te, “Ya mɔtɔ ga iya te nï Yowani bɔ bapatisi na. Ya mɔtɔ ga iya te nï Eliya na. Tine ya mɔtɔ ga iya ma ꞌbënnï te nï bɔ kumë lende ma kɔtɔ mɔtɔ na.” ");
INSERT INTO bex_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kina bo kileki kititi lïjë kiya te, “Ne kpe ma ꞌbeye iyake ma rɔ yë?” Pïtörö ënyï kileki dɔmo ŋgï iya te, “Nï na rɔ Kurïsïtö mo tönë Bɔkoꞌba këdï koja ne.” ");
INSERT INTO bex_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tine bo ënyï kose gɔmo ŋgï kitigɔ zïnnï kinza lïjë kari kiya lende mo dë zi bɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yësu ebe ŋgï rɔ tiyandi bɔ kösö gɔ bo ga. Mï akiyandi abo, bo iya te, “Rɔ ma laka, kole ꞌba bilaka lesi ti kombi gomɔ ꞌdeni ŋgï rɔ mbëmbë. Löbu ꞌba bilaka ni ti bɔ dɔ bɔ akumu ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ti kilagi ꞌdeni ŋgï yaga di rɔ bo. Kina ti kupö bo ŋgï. Tine mï töꞌdö dɔ mota bo ti kɔdɔ ꞌdeni ŋgï yaga di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Lende nima bo iya ŋgï zïnnï yaga bi kɔpɔ kɔzɔ a nime te. Kina Pïtörö kako kogba bo ŋgï kese ti bo mbowa yaga tileki lende zi bo. ");
INSERT INTO bex_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tine na bo kënyï kuyï kɔmɔ bo ŋgï bo koŋgɔ dɔ bɔ kösö gɔ bo ga toko, na bo kamo ŋgï dɔ Pïtörö, kiya te, “Ese yaga di rɔma, nï Satani. Meri ꞌbï nima ꞌba bilaka lesi na, ꞌba Bɔkoꞌba na dë.” ");
INSERT INTO bex_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bo ïdëkï bɔ kösö gɔ bo ga ŋgï kako kɔtɔ zi bo kpaki ti tïndï naga nima, na bo koloma ŋgï rɔ tiya mo zïnnï te, “Bɔtɔ ame koꞌdɔkɔ tösö gɔma ne, iꞌdike bo komba gɔ bo zi gbagba bo, bo kombi gomɔ abo bo kösö gɔma pele ŋbö mï tölë. ");
INSERT INTO bex_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Römöyï bɔ ame kiteri tɔmɔ dïdï bo ne ti kupö ŋgï. Tine ame kupö dïdï bo gɔ lende ma gbï ti laja laka nime ne ti kɔmɔ ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Waꞌdi na ti nï mɔtɔ koꞌja di gɔmo ɔdɔ kiya te komɔmi dɔliŋɔ löbu nime pele ꞌdoyi tine kupö dɔ dïdï yï? ");
INSERT INTO bex_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A mɔtɔ inza ame ꞌdɔ nï mɔtɔ kiꞌdi topi gɔ dïdï yï timo. ");
INSERT INTO bex_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bɔtɔ ame rɔmo kaya ma mï kada ꞌba bɔ lende kënyë kinza koro Bɔkoꞌba naga nime ne, ti rɔ kole ꞌba bilaka lesi kaya gbï ꞌdeni tara di rɔmo mï kada ma bo këdï kako ꞌdeni mï rɔ löbu ꞌba ꞌbu bo ti malayika kɔtɔ laka abo ga.” ");
INSERT INTO bex_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kina bo kileki kiya zïnnï te, “Rɔ ma laka mëdï miya ziye, ya mɔtɔ ga di mï löŋgö ye nima inza kinene a mɔtɔ rɔ tölë titi du gba kota kinza ma ŋere löbu ꞌba Bɔkoꞌba kako ra ti tigɔ mo.” ");
INSERT INTO bex_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Di pötö töꞌdö dɔ modɔɔkɔtɔ na Yësu kënyï kogba Pïtörö ni ti Yakoba ti Yowani, lïjë këkï ŋge rɔ dönnï nime kari dɔ döku tɔrɔ. Tine di yayi na ɔdɔ lïjë koŋgɔ Yësu tine, kïnë bo uyï rönï ꞌdeni ŋgï ꞌberi, ");
INSERT INTO bex_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","bɔŋgɔ ꞌba rɔ bo kaŋmi ŋgï köbö kebe akurögö ꞌba bilaka ꞌba dɔliŋɔ nime pili. ");
INSERT INTO bex_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ya mota ma rɔ bɔ kösö gɔ bo naga nima oꞌja Eliya ni ŋgï ti Musa këdï ꞌdeni rɔ tilende ti Yësu. ");
INSERT INTO bex_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kina Pïtörö kënyï kiya zi Yësu te, “Bɔ kɔmɔ kiyandi, ele sowa ame dëdï bine ne. Iꞌdi doꞌdɔ ŋgöŋgöbö mota, kɔtɔ zïyï, kɔtɔ zi Musa kina kɔtɔ zi Eliya.” ");
INSERT INTO bex_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Lïjë pili ꞌdeni ŋgï rɔ tikere, lende naga nima bo këdï kiya pele ne bo ikali gɔmo dë. ");
INSERT INTO bex_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kina pɔli kako kutuꞌbö lïjë ŋgï ŋbuku. Kina birɔ kudu ŋgï di mï pɔli nima, kiya te, “Ame na rɔ kole ma. Mɔꞌɔ bo kulöwö, uwöke dɔ bo.” ");
INSERT INTO bex_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tine ɔdɔ lïjë kënyï kuyï kömönnï koŋgɔ bi toko ꞌböwu yayi, bɔtɔ inza kpe, Yësu na ꞌdeni ŋge kola kɔtɔ tïnnï yayi. ");
INSERT INTO bex_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kina ɔdɔ lïjë këdï këkï ꞌdeni kako bërï di dɔ döku yayi, Yësu ose gɔmo kitigɔ zïnnï kinza lïjë kari kiya lende nime lïjë koꞌja ne dë zi bɔtɔ ma kɔtɔ mɔtɔ. Tine gɔ lïjë kiya ꞌjaa ŋbö ɔdɔ kole ꞌba bilaka lesi kɔdɔ ꞌdeni yaga di mï tölë. ");
INSERT INTO bex_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kina lïjë kiꞌdi lende nime ŋgï köꞌbö ŋge mï löŋgö lïjë. Tine lïjë oloma rɔ tititi mo rɔ gɔ rönnï, kiya te, “Waꞌdi ga na rɔ tɔdɔ di mï tölë?” ");
INSERT INTO bex_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lïjë ititi Yësu, kiya te, “Gɔ waꞌdi na bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni kiya te Eliya na këdï kako titi dɔgba di zi Kurïsïtö ma Bɔkoꞌba këdï koja?” ");
INSERT INTO bex_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yësu ileki dɔmo zïnnï te, “Rɔ ma laka Eliya ako ꞌdeni titi dɔgba tileŋo wa pili ndö. Kina me buku ꞌba Bɔkoꞌba kiya te, ‘Kole ꞌba bilaka lesi ti kombi gomɔ rɔ mbëmbë bilaka kilagi di rɔmo.’ ");
INSERT INTO bex_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ne rɔ ma laka ti miya ziye, Eliya ako ꞌdeni tine bilaka oꞌdɔ wa ꞌdeni ŋgï zi bo kɔzɔ ma lïjë koꞌdɔkɔ toꞌdɔ mo, kɔzɔ ma tönë mo kugu ne tara.” ");
INSERT INTO bex_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kina ɔdɔ Yësu ni këkï ꞌdeni bërï kako kömö zi bɔ kösö gɔ bo ma laki naga nima tine, lïjë ako koꞌja tïndï ma kinza kiya koso ꞌdeni ŋgï yayi ti bɔ kɔmɔ kiyandi ni këdï koꞌdɔ kowasa tïnnï. ");
INSERT INTO bex_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bilaka naga nima lïjë oꞌja Yësu këdï kako na lïjë kotɔ ŋgï rɔ gönnï kiriŋa kurë dɔ bo tumötö bo. ");
INSERT INTO bex_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yësu ititi bɔ kösö gɔ bo ga iya te, “Waꞌdi na këddï koꞌdɔke kowasa mo tïnnï?” ");
INSERT INTO bex_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bɔ mɔtɔ di mï löŋgö tïndï naga nima ënyï kileki kiya te, “Bɔ kɔmɔ kiyandi, kole ma nime nökï udödu kpamo ꞌdeni ŋgï teyi, kina me moꞌde kako zïyï. ");
INSERT INTO bex_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nökï nime ɔdɔ kebe toꞌdɔ bo, oŋma bo ŋgï bërï koja surupu di kpa bo, bo konyo dɔ tuŋgu bo ŋgï teyi ndïŋïndïŋï, rɔ bo kitigɔ ŋgï yaga gbörökötö. Kina me mititi bɔ kösö göyï naga nime ꞌdɔ lïjë koga nökï nime yaga tine lïjë ɔꞌbɔ dë.” ");
INSERT INTO bex_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yësu ileki kiya zïnnï te, “Kpe bilaka ma leꞌjete naga nime bɔ kinza kikali tiꞌdi dɔye gɔ lende ma nime. Gɔ moloma ŋgï ŋbö nyanya ga tiye na? ꞌDɔ mogbɔ dökïꞌdï ma ŋgï ŋbö nyanya ga di ziye na? Oꞌdeke kole nima kako zö dayi.” ");
INSERT INTO bex_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lïjë oꞌde kole nima kako zi bo. Kina nökï koꞌja kïnë Yësu te, na koŋma kole nima ŋgï bërï, kululu, surupu köꞌbu di kpamo. ");
INSERT INTO bex_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yësu ititi ꞌbu ꞌba kole nima, iya te, “Nökï nime isaki bo nyanya ga?” Bo ileki dɔmo tëgë, “Mɔlo gba rɔ dɔ kole titi. ");
INSERT INTO bex_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mï kada mɔtɔ ga ebe tuꞌdu bo mï paꞌdo, mɔtɔ ga oŋma bo ŋgï mï mini, ꞌdɔ kupö bo ŋgï yaga. Ne ɔdɔ kɔꞌbɔ ŋgï toꞌdɔ mo, oŋgɔ lisa ꞌba rɔze kokɔnyi ze.” ");
INSERT INTO bex_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yësu ileki kiya zi bo te, “Gɔ waꞌdi na kiya te ɔdɔ mɔꞌbɔ ŋgï? A mɔtɔ inza ame ꞌdɔ konya dɔ bilaka ame ga pili kiꞌdi dönnï ꞌdeni gɔ tigɔ ꞌba Bɔkoꞌba ne.” ");
INSERT INTO bex_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kina ꞌbu ꞌba kole nima kënyï ŋgï kulörï rɔ ma kembe kiya te, “Ma miꞌdi dɔma ꞌdeni ŋgï gɔmo, tine okɔnyi ma kogbɔ ma laka yïmo.” ");
INSERT INTO bex_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yësu oŋgɔ bilaka ëdï ꞌdeni ŋgï kosoŋi kulöwö kako ŋgila lïjë. Kina bo kamo ŋgï dɔ nökï nima kiya te, “Nï nökï kuꞌbë mbili kudödu kpa nima, moga yi, ɔdɔ yaga ŋburu mï kɔtɔ kinza kileki dë kpe dɔ bɔ nime.” ");
INSERT INTO bex_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kina nökï kënyï kapi ŋgï rɔ ma kembe koŋma bɔ nima ŋgï rɔ ma kënyë, kina kitaꞌba ŋgï yaga di dɔmo. Bɔ nima öꞌdö ŋgï yayi kɔzɔ töku. Kina bilaka ama ga yayi ne kebe ŋgï rɔ tiya mo tëgë, “Bo ölë ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tine Yësu indaꞌba közï bo, na bo kënyï ŋgï tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kina ɔdɔ Yësu ni këdï ꞌdeni rɔ dönnï rö ti bɔ kösö gɔ bo ga tine, na lïjë kebe tititi bo iya te, “Gɔ waꞌdi na dɔꞌbɔ ma ꞌbeze dë toga nökï yaga?” ");
INSERT INTO bex_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yësu ileki dɔmo zïnnï iya te, “A mɔtɔ inza ame ꞌdɔ kɔꞌbɔ toga mo timo, tine ŋge kɔtɔ ti mötu.” ");
INSERT INTO bex_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lïjë ënyï ŋgï di bi nima yayi kudö te kebe mï Galilaya. Yësu oꞌdɔkɔ dë ꞌdɔ bilaka kikali gɔ bi ma lïjë këdï teyi, ");
INSERT INTO bex_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","römöyï bo oꞌdɔkɔ tiyandi bɔ kösö gɔ bo ga. Mï akiyandi abo zïnnï bo iya te, “Ti kiꞌdi közï kole ꞌba bilaka lesi ꞌdeni ŋgï zi bilaka mɔtɔ ga, kupö bo yaga. Tine mï töꞌdö dɔ mota bo ti kɔdɔ ŋgï yaga di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Akiyandi abo nima bɔ kösö gɔ bo ga ikali mï ꞌjɔ ꞌba lende mo dë. Tine lïjë ere ꞌdeni di bi tititi bo. ");
INSERT INTO bex_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lïjë ako kömö Kaparanoma, kina ɔdɔ lïjë këdï ꞌdeni liŋɔ tine, Yësu ititi bɔ kösö gɔ bo ga iya te, “Waꞌdi na kolomake rɔ toꞌdɔ kowasa mo di gɔ kɔri yayi ne?” ");
INSERT INTO bex_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lïjë ileki dɔmo dë römöyï pa di gɔ kɔri yayi lïjë oloma rɔ towasa mo yë na rɔ löbu di mï löŋgö lïjë nima bina. ");
INSERT INTO bex_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yësu oloma bërï kïdëkï ma ꞌbutë dɔmorïyö naga nima kako zi bo. Kina bo kiya zïnnï te, “Bɔtɔ ame koꞌdɔkɔ tëdï rɔ löbu ne, iꞌdike bo kileki rɔ bo bërï yaga rɔ bɔ laja zi ya ma laki.” ");
INSERT INTO bex_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bo ogba kole titi mɔtɔ kiꞌdi kɔrɔ kömönnï yayi, bo kindaꞌba rɔmo na bo kiya zïnnï te, ");
INSERT INTO bex_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bɔtɔ ame koja laja zi kole ma te dömöyï ma ne, ma na bo koja laja ꞌdeni zö. Kina bɔtɔ ame koja laja zö, bɔ ame koja ma ne na ma ꞌdeni gbï bo koja laja teyi.” ");
INSERT INTO bex_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yowani ënyï kiya zi bo te, “Doꞌja bɔ mɔtɔ këdï koga nökï ti möyï yï, kina dota gɔmo ꞌdeni di zi bo diya te kinza bo koꞌdɔ dë römöyï bo inza rɔ ma kɔtɔ ꞌbeze mɔtɔ.” ");
INSERT INTO bex_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yësu iya te, “Kinza kotake gɔmo dë di zi bo. Römöyï bɔtɔ ame këdï koꞌdɔ gɔ kotɔ ꞌdeni ti möyï ma ne inza kileki ꞌböwu kiya ma rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bɔtɔ ame koꞌji ze dë ne kina rɔ ꞌbeze. ");
INSERT INTO bex_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Omerike gɔ lende nime laka. Bɔtɔ ame kiꞌdi pele ŋge rɔ mini kuwë ziye römöyï kpe ꞌba Kurïsïtö na ne ti koꞌja kpa közï ꞌba gɔmo ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Bɔtɔ ame kebe kiꞌdi a titi ma kɔzɔ a naga nime te ame kiꞌdi dönnï ꞌdeni gɔ lende ma ne kebe kilaꞌba mï lende kënyë, ma laka mo dëne gɔ kudödu rɔ toto kuwu ndöwu ma löbu mugu bɔ mo gɔ kïtïŋï bo timo mï mini löbu. ");
INSERT INTO bex_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ɔdɔ közïyï na kiꞌdi yi koꞌdɔ lende kënyë, oke yaga. Ti këdï rɔ ma laka rɔ dɔ kiteli zïyï tɔdɔ mï dïdï ma ŋburuŋburu ti közï kɔtɔ, di dɔ ame ꞌdɔ kari kuꞌdu yi mï Gehena paꞌdo kinza kölu nima ti közïyï këdï rïyö ne. ");
INSERT INTO bex_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ɔdɔ ndïyï na kiꞌdi yi koꞌdɔ lende kënyë, oke yaga. Ti këdï rɔ ma laka zïyï ꞌdɔ tɔdɔ mï dïdï ma ŋburuŋburu rɔ bɔ ndï kɔtɔ di dɔ ame ꞌdɔ kari kuꞌdu yi mï Gehena ti ndïyï këdï rïyö ne. ");
INSERT INTO bex_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ɔdɔ kömöyï na kiꞌdi yi koꞌdɔ lende kënyë, iyagba yaga. Ti këdï rɔ ma laka zïyï tɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba rɔ bɔ kɔmɔ kɔtɔ di dɔ ame ꞌdɔ kari kuꞌdu yi mï Gehena ti kömöyï këdï rïyö ne. ");
INSERT INTO bex_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Gɔ bi nime rɔ Gehena ne kuru ma këdï konyo bilaka mo ga ölë dë kina paꞌdo mo öꞌbö ŋburu tara kölu dë.” ");
INSERT INTO bex_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kina bo kiya gbï te, “Ti kileŋo bilaka pili ꞌdeni ŋgï ti paꞌdo gɔ këdï laka kɔzɔ tikɔꞌdɔ ame këdï kileŋo wa ne tara. ");
INSERT INTO bex_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tikɔꞌdɔ ele ma. Ne ɔdɔ tikɔꞌdɔ kote tulöwu ma kiyɔkɔ mo ꞌdeni ti kɔꞌbɔ ꞌböwu tiꞌdi mo kileki rɔ ma kiyɔkɔ tondo ga? Nï mɔtɔ iꞌdi gbagba yï këdï rɔ tikɔꞌdɔ. Olomake ti mï këyï rɔ gɔ rɔye.” ");
INSERT INTO bex_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Di yayi na bo kënyï ŋgï kari mï dɔyayi ꞌba Yudayi. Bo umu kari gönyï yöpö ꞌba Yaradene, na bilaka kɔlɔ ŋgï rɔ tïndï kako zi bo. Kina bo koloma ŋgï rɔ tiyandi lïjë kɔzɔ ma mɔlɔ tara. ");
INSERT INTO bex_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kina Parosi ni kako ma ꞌbënnï ŋgï tititi bo toꞌba bo timo. Lïjë ititi bo, iya te, “Tara ne ëdï ŋgï rɔ ma laka mï köꞌdu kiꞌdi na ꞌdɔ toga ꞌja?” ");
INSERT INTO bex_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bo ileki kititi lïjë te, “Waꞌdi na Musa kiya mï köꞌdu kiꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lïjë iya te, “Musa odɔ kpamo zi bɔtɔni ꞌdɔ kugu waraga ꞌba tëyï kiꞌdi zi ꞌja ame bo këdï koga ne.” ");
INSERT INTO bex_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yësu ileki dɔmo zïnnï te, “Musa ugu köꞌdu kiꞌdi nima tara ziye, römöyï minyi ꞌbe idari ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tine ma di bi tisaki mo inza tara. Ugu ꞌdeni, iya te, ‘Bɔkoꞌba oꞌba lïjë rɔ bɔtɔni ni ma ti ꞌja. ");
INSERT INTO bex_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gɔ köꞌdu mo na kiꞌdi bɔtɔni këdï kënyï kolɔlɔ di yɔki ꞌbu bo ni ti ma bo, lïjë kari kodɔꞌbɔ ga rönnï ti ꞌja abo. ");
INSERT INTO bex_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kina lïjë kpaki rïyö ꞌdeni rɔ akɔtɔ.’ Lïjë inza kpe rïyö, tine ꞌdeni yaga ŋgï rɔ akɔtɔ. ");
INSERT INTO bex_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kina wa ame Bɔkoꞌba kodɔꞌbɔ ꞌdeni rɔ a kɔtɔ ne kinza bɔtɔ mɔtɔ kebe koza yïmo dë kpe yaga.” ");
INSERT INTO bex_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kina koꞌja lïjë kileki ꞌdeni kari liŋɔ tine, na bɔ kösö gɔ bo ga kënyï kititi bo gɔ lende nima. ");
INSERT INTO bex_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bo iya zïnnï te, “Nï mɔtɔ ame koga ꞌja ꞌbï kebe kari kogbe mɔtɔ ne, oꞌdɔ yërï ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kina gbï ꞌja ame kënyï di gɔ mëꞌdë nï kari kogbe mëꞌdë mɔtɔ ne, yërï na lɔko koꞌdɔ ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ya mɔtɔ ga oꞌde kole titi kako zi bo ꞌdɔ bo kiꞌdi közï bo dɔmo. Tine bɔ kösö gɔ bo ga ota gɔmo kinza kiꞌdi lïjë dë kako zi bo. ");
INSERT INTO bex_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kina ɔdɔ Yësu koꞌja lende nima tara tine, bo ënyï ŋgï rɔ ꞌdïrï. Bo iya zi bɔ kösö gɔ bo ga te, “Olake kole titi kako zö kinza kotake lïjë dë, römöyï lïjë ame ga te ne ŋere löbu ꞌba Bɔkoꞌba na rɔ ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rɔ ma laka miya ziye, bɔtɔ ame kindaꞌba ŋere löbu ꞌba Bɔkoꞌba dë kɔzɔ kole titi ne inza kɔdɔ du te yïmo.” ");
INSERT INTO bex_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kina bo kogba kole titi naga nima ŋgï bo kiꞌdi közï bo dɔmo koꞌdɔ yëyï zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tine koꞌja Yësu ni këdï koꞌdɔ ꞌdeni tösö dɔmo tari yɔ, na bɔ mɔtɔ kako ŋgï rɔ riŋa kolɔdɔ bërï kɔmɔ bo te, komaꞌjo rönï zi bo, kiya te, “Bɔ kɔmɔ kiyandi ma laka, waꞌdi na gɔ moꞌdɔ ꞌdɔ moꞌja dïdï ma ŋburuŋburu?” ");
INSERT INTO bex_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yësu ileki kiya zi bo te, “Gɔ waꞌdi na kïdëkï ma rɔ ma laka? Bɔtɔ mɔtɔ inza laka, tine Bɔkoꞌba na ŋge kɔtɔ kpökï laka. ");
INSERT INTO bex_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ikali köꞌdu kiꞌdi ꞌdeni, ame kiya te, ‘Kinza koꞌdɔ röyï dë rɔ bɔ közï roma. Kinza koꞌdɔ yërï dë. Kinza koꞌdɔ ꞌbögö dë. Kinza kususu bɔtɔ dë rɔ bëtï. Kinza koꞌdɔ ꞌbölu dë. Oro ꞌbu yï ni ti möyï.’” ");
INSERT INTO bex_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bɔ nima ileki dɔmo, iya te, “Bɔ kɔmɔ kiyandi, wa naga nima pili moꞌdɔ ꞌdeni mɔlo dɔ yɔbi ma.” ");
INSERT INTO bex_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yësu oŋgɔ dɔ bɔ nima, bɔ ɔꞌɔ bɔ nima. Na bo kileki kiya teyi te, “A mɔtɔ ëdï kɔtɔ ame kɔmɔ gba di zïyï ꞌdɔ toꞌdɔ mo. Ari kugö akonzi ꞌbï naga nima mökö koza gïrïsï mo ga zi bɔ lisa. Kina ti kulu kpamo ꞌdeni ŋgï zïyï mïtɔrɔ. Kina ꞌdɔ kako ti kösö gɔma.” ");
INSERT INTO bex_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lende nime bɔ nima kuwö kɔzɔ a nime te yɔ, na bo kuyï kɔmɔ ma löwö ŋgï bo kari abo. Römöyï bɔ nima bo rɔ bɔ mɔri ti wa ŋbaŋi. ");
INSERT INTO bex_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yësu uyï kɔmɔ bo koŋgɔ dɔ bɔ kösö gɔ bo ga, na bo kiya zïnnï te, “Ti këdï rɔ ma kitigɔ zi bɔ wa ni ꞌdɔ kɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lende nime igayi bɔ kösö gɔ bo ga ŋgï. Tine Yësu oto nduwë tiya mo zïnnï te, “Kole ma ga, tɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba ti këdï rɔ ma kitigɔ. ");
INSERT INTO bex_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tɔdɔ mï ŋere löbu ꞌba Bɔkoꞌba ti këdï rɔ ma kitigɔ zi bɔ wa ni kebe tɔdɔ ꞌba gamele kebe mï bi gböŋö ꞌba bïcï libira.” ");
INSERT INTO bex_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lende nime igayi lïjë ŋgï mï kɔtɔ, kina lïjë kileki gɔmo kiya zi bo te, “Ne ma ꞌdeni tara tine ne, yë ga na ti kɔmɔ di mï tölë?” ");
INSERT INTO bex_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yësu oŋgɔ dönnï kina bo kileki kiya zïnnï te, “Wa naga nime ma di zi bilaka lesi na ŋge kinda rɔ a ma ꞌdɔ koꞌdɔ rönï dë. Tine ma di zi Bɔkoꞌba embe dë römöyï bo na kɔꞌbɔ toꞌdɔ wa pili.” ");
INSERT INTO bex_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pïtörö ënyï kiya zi bo te, “Oŋgɔ te, ze ꞌbeze nime dola wa pili ꞌdeni me dösö göyï.” ");
INSERT INTO bex_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yësu iya te, “Yëë, rɔ ma laka miya ziye, bɔtɔ ame kola liŋɔ, kola löndö, kola lëmï, kola ma bo ni ti ꞌbu bo, kola kole, kola nyaka dömöyï ma gbï gɔ laja kɔtɔ laka nime ne, ");
INSERT INTO bex_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ti koꞌja ŋgï mï kada ma gïrï naga nime rɔ dɔ kiteli. Bo ti koꞌja wa naga nime pili rɔ mbëmbë kebe dɔ ame gbï ti közï kasi ꞌba gɔmo. Kina mï kada ma këdï kako nime ꞌdë bo ti këdï ŋgï ti dïdï ma ŋburuŋburu. ");
INSERT INTO bex_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tine ma konzi ame ga pa dɔgba ne ti kileki ꞌdeni yïꞌböwu, kina ma yïꞌböwu na ti këdï ꞌdeni dɔgba.” ");
INSERT INTO bex_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Di gɔ kɔri lïjë këdï ꞌdeni rɔ tari Yerosalema, Yësu na kösö ŋgï dɔgba. Kina lende mo kigayi bɔ kösö gɔ bo ga ŋgï, koꞌde tikere ŋgï pili zi bilaka ame ga këdï kozi gɔ bo ne. Tine bo ari kogba lïjë ma ꞌbutë dɔmorïyö mo naga nima ŋgï ꞌberi yaga rɔ dönnï, bo koloma rɔ tiya gɔ wa ma këdï kari koꞌdɔ rönï zi bo zïnnï, ");
INSERT INTO bex_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","bo iya zïnnï te, “Kpe, uwöke tɔma. Dëdï darike nima ŋbö mï Yerosalema. Kina di yayi na ti kiꞌdi közï kole ꞌba bilaka lesi ŋgï zi bɔ dɔ bɔ akumu ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni. Tine na ti lïjë kodɔ karama mo ŋgï dɔ bo rɔ tölë. Lïjë ti kiꞌdi bo zi ma rɔ bɔ löwö mo ga ");
INSERT INTO bex_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","kodɔ laŋa rɔ bo, kotoꞌbi woro rɔ bo, komba bo kupö bo yaga. Tine mï töꞌdö dɔ mota bo ti kënyï kɔdɔ ꞌdeni ŋgï yaga di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakoba ni ti Yowani, kole ꞌba Zebedayo ga ako zi Yësu kiya te, “Bɔ kɔmɔ kiyandi, a mɔtɔ ëdï bine doꞌdɔkɔ yi ꞌdɔ koꞌdɔ zize.” ");
INSERT INTO bex_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yësu iya te, “Waꞌdi na koꞌdɔkɔke gɔ moꞌdɔ ziye?” ");
INSERT INTO bex_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Lïjë iya te, “Ɔdɔ kari koloma ꞌdeni dɔ kïtï mï ŋere löbu ꞌbï, doꞌdɔkɔ ꞌdɔ kiꞌdi ze doloma tïyï, ma kɔtɔ dɔ dörï yï, ma kɔtɔ dɔ gali yï.” ");
INSERT INTO bex_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yësu ileki zïnnï te. “Wa nima kititike ne ikalike dë. Kpe, ti kɔꞌbɔke tuwë wa di mï kösu ꞌba gomɔ nime mëdï mari muwë ne? Ti kɔꞌbɔke gɔ kobapatisi ye ti kɔri nime kobapatisi ma timo ne?” ");
INSERT INTO bex_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lïjë iya te, “Ti dɔꞌbɔ ŋgï.” Yësu iya te, “Rɔ ma laka kpe ti kuwëke ŋgï di mï kösu mo ma mëdï muwë di yïmo, kina ti kobapatisi ye ŋgï kɔzɔ ma ꞌbama. ");
INSERT INTO bex_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tine lende ꞌba tiꞌdi wa toloma dɔ dörï ma ala dɔ gali ma nima, ndɔbɔ ma na dë. Bɔkoꞌba na këdï kiꞌdi gɔ bi nima zi bilaka mo ga ame bo kileŋo ꞌdeni dömöyï mo ne.” ");
INSERT INTO bex_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kina ɔdɔ kɔsɔ ya ma ꞌbutë naga nima kuwö lende nima ꞌdeni tara tine, lïjë ënyï ŋgï rɔ ꞌdïrï ti Yakoba ni ti Yowani. ");
INSERT INTO bex_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kina Yësu kïdëkï lïjë ŋgï pili kako bi kɔtɔ zi bo. Bo iya zïnnï te, “Ikalike ꞌdeni laka, löbu ma ꞌba bɔ löwö ni oꞌdɔ ga rönnï ŋgï rɔ ŋere rɔ a löbu dönnï. ");
INSERT INTO bex_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tine ma ꞌbeye inza tara. Bɔtɔ ame koꞌdɔkɔ gɔ bo këdï rɔ löbu di mï löŋgö ye ne, bo kileki rɔ bo yaga rɔ bɔ laja ziye. ");
INSERT INTO bex_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kina bɔ ame kiteri ꞌdɔ bo na këdï rɔ bɔ dɔye ne, bo kileki rɔ bo yaga rɔ atɔli ziye pili. ");
INSERT INTO bex_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Römöyï kole ꞌba bilaka lesi pele ako dë ꞌdɔ koja laja teyi, tine bo na ꞌdɔ koja laja zi bilaka, kina gbï tiꞌdi dïdï bo tutë gɔ ma konzi timo di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lïjë ako kömö Yereko. Tine koꞌja Yësu ni ti bɔ kösö gɔ bo ga ti tïndï ma këdï kari tïnnï naga nima këdï kiteli ꞌdeni kebe yayi tine, bɔ kɔmɔ kölu mɔtɔ yayi möyï mo rɔ Batimayo kole ꞌba Timayo, ëdï kolɔꞌbɔ kpa gɔ kɔri yayi tokpasi wa. ");
INSERT INTO bex_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kina ɔdɔ bo kuwö ꞌdeni kiya te, Yësu ꞌba Nazareta na, kina bo kulörï ŋgï rɔ ma kembe, kiya te, “Yësu kole ꞌba Dawidi, iꞌdi mïyï këyï rɔma.” ");
INSERT INTO bex_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bilaka ma konzi iꞌdi tamo dɔ bo gɔ bo kudumö yaga. Tine na bo kulörï ŋgï kulöwö rɔ ma kembe, kiya te, “Yësu kole ꞌba Dawidi, iꞌdi mïyï këyï rɔma.” ");
INSERT INTO bex_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kina Yësu kɔrɔ ŋgï kiya te, “Iꞌdike bo kako dayi.” Kina lïjë kïdëkï bɔ kɔmɔ kölu tönë ŋgï, iya te, “Ögö ti, ënyï tɔrɔ, bo ëdï kïdëkï yi.” ");
INSERT INTO bex_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kina bɔ nima kogbagba ŋgï kulï bɔŋgɔ yaga di dɔ bo, kënyï kari zi Yësu. ");
INSERT INTO bex_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yësu ititi bo iya te, “Waꞌdi na koꞌdɔkɔ gɔ moꞌdɔ zïyï?” Bɔ kɔmɔ kölu nima iya te, “Bɔ kɔmɔ kiyandi, ma moꞌdɔkɔ toꞌja gɔ bi.” ");
INSERT INTO bex_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yësu iya te, “Laka, ari ti, tiꞌdi döyï gɔ tigɔ ma ileŋo yi ꞌdeni.” Kina kɔmɔ bɔ nima kɔpɔ ŋgï yaga, bo kösö gɔ Yësu di gɔ kɔri yayi. ");
INSERT INTO bex_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kina ɔdɔ lïjë kari ꞌdeni kömö ŋgɔsi ŋgila Yerosalema mï gawo ꞌba Betepage ni ti Betaniya tine, na lïjë kari ŋgï dɔ döku ꞌba Bilaya. Yësu oja bɔ kösö gɔ bo ga ma rïyö ");
INSERT INTO bex_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kari dɔgba ti ndose nime, kiya te, “Kpe arike mï gawo nima dɔgba kɔmɔye ne. Di bi tömö ꞌbe yayi ti kari koꞌjake kole akaca kosi dɔmo ꞌdeni bërï, rɔ ame gba bɔtɔ këkï dë dɔmo ne. Opeke koꞌdeke kako bine. ");
INSERT INTO bex_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ɔdɔ bɔtɔ kititi ye kiya te, ‘Ëddï kopeke gɔ waꞌdi?’ Iyake te, ‘Ŋere na koꞌdɔkɔ, bo ëdï kileki gïrï naga nime.’” ");
INSERT INTO bex_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lïjë ari ŋgï koꞌja kole akaca kosi dɔmo ꞌdeni yaga kpa reki yayi. Kina ɔdɔ lïjë këdï koꞌdɔ tope mo tine, ");
INSERT INTO bex_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ya mɔtɔ ga ame këdï kɔrɔ yayi ne ititi lïjë iya te, “Waꞌdi na këddï koꞌdɔke tara, këdï kopeke akaca nima?” ");
INSERT INTO bex_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Lïjë ileki dɔmo ŋgï kɔzɔ ma tönë Yësu kose zïnnï ne tara. Kina bilaka naga nima kola ŋgï lïjë kari timo. ");
INSERT INTO bex_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lïjë oꞌde akaca nima kako zi Yësu na lïjë koꞌba bɔŋgɔ ꞌbënnï ga ŋgï gɔmo. Kina Yësu këkï ŋgï koloma dɔmo. ");
INSERT INTO bex_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tine bilaka ma konzi mɔtɔ ga oꞌba bɔŋgɔ ma ꞌbënnï ga mï gɔ kɔri, ya mɔtɔ ga oga ma ꞌbënnï rɔ mbili mbïrö ni di mï nyaka koꞌba gɔ kɔri. ");
INSERT INTO bex_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kina bilaka konzi naga nima mɔtɔ ga kösö ꞌdeni dɔgba mɔtɔ ga kebe gɔ bo yïꞌböwu ne kiꞌdi ŋgï tulörï timo rɔ ma kembe, kiya te, “Akïlëlu këdï zi Bɔkoꞌba. Yëyï këdï dɔ bɔ ame kako ti möyï bo ŋere Bɔkoꞌba ne. ");
INSERT INTO bex_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yëyï ꞌba Bɔkoꞌba këdï dɔ ŋere löbu ame këdï kako ne kɔzɔ ꞌba ꞌbu ze löbu Dawidi. Akïlëlu këdï zi bo Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yësu ɔdɔ Yerosalema na bo kiteli ŋgï kari mï reki ꞌba rö löbu ꞌba Bɔkoꞌba. Kina ɔdɔ bo koŋgɔ wa mo naga nima ꞌdeni pili tine, na bo kari ŋgï ti bɔ kösö gɔ bo ga ma ꞌbutë dɔmorïyö naga nima mï Betaniya, römöyï kada inza kpe. ");
INSERT INTO bex_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mï bi këzë ma di gɔmo koꞌja lïjë këdï kileki ꞌdeni kako di Betaniya tine ꞌbö oꞌdɔ Yësu ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bo oꞌja ŋgërï këlu kinda di bi kɔwɔ ti mbili dɔmo. Kina bo kɔcɔ ŋgï kari toŋgɔ mo, bo iya te mɔtɔga bo ti koꞌja ma kana mo. Tine bo ari koꞌja ŋge rɔ mbili na kutu ëꞌbënnï römöyï kada ꞌba tana ꞌba këlu na dë gba. ");
INSERT INTO bex_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kina bo kiya ŋgï zi ŋgërï këlu nima te, “Nï, bɔtɔ inza konyo ɔtɔ mɔtɔ kpe di döyï.” Lende nima bo iya pili mbili bɔ kösö gɔ bo ga kuwö. ");
INSERT INTO bex_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lïjë ako kömö Yerosalema na bo kari ŋgï kɔdɔ mï reki ꞌba rö löbu ꞌba Bɔkoꞌba. Bo ari koꞌja bɔ ndögö koso ꞌdeni yayi na bo koloma ŋgï rɔ toga lïjë yaga, bo kïtïŋï dɔ tarabiza ꞌba bɔ kutë gïrïsï ni ti gbaꞌda ꞌba bɔ kugö matukpuru ni bërï. ");
INSERT INTO bex_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bo embe ŋgï kola bɔtɔ dë kpe kombi wa dönnï kudö timo kebe yayi. ");
INSERT INTO bex_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kina bo koloma ŋgï rɔ tiyandi lïjë kiya zïnnï te, “Uwöke dë me tönë kugu ne? Iya te, ‘Rö löbu ma nime ti kïdëkï rɔ rö ꞌba mötu zi dɔ kupö pili.’ Ne kina me ꞌböwu kpe kebe kuyïke yaga rɔ tïꞌbörö ꞌba bɔ ꞌbögö.” ");
INSERT INTO bex_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bɔ dɔ bɔ akumu ni ti bɔ kɔmɔ kiyandi ni uwö lende mo na lïjë kiꞌdi ŋgï toma kɔri ꞌba ꞌdɔ tupö Yësu timo. Tine lïjë ere di rɔ bo römöyï akiyandi abo igayi ma konzi ꞌdeni ŋgï pili. ");
INSERT INTO bex_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mï dɔkɔpiyari ꞌdeni na Yësu ni kënyï ŋgï di mï gawo yayi ti bɔ kösö gɔ bo ga lïjë kileki kari. ");
INSERT INTO bex_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mɔlo mï dɔŋbɔ ma di pötö mo koꞌja lïjë këdï kudö rɔ gɔ kɔri nima, lïjë oꞌja ŋgërï këlu tönë kölë ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pïtörö omeri gɔ lende tönë ŋgï, na bo kiya zi Yësu te, “Bɔ kɔmɔ kiyandi, oŋgɔ te. Ŋgërï këlu tönë kulömu ne ölë ꞌdeni.” ");
INSERT INTO bex_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yësu ileki dɔmo zïnnï iya te, “Rɔ ma laka miya ziye, iꞌdike dɔye gɔ lende ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bɔtɔ ame kiya zi döku nime te, ‘Nï, ënyï kari kuꞌdu röyï mï mini löbu,’ ɔdɔ kiya te dökïꞌdï bo kidaki dë bo kiꞌdi dɔ bo ŋgï gɔmo, rɔ ma laka ti koꞌdɔ rönï ŋgï tara. ");
INSERT INTO bex_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kina me mëdï miya ziye, wa ame ɔdɔ kititike ti mötu ziye tiꞌdi dɔye gɔmo, oꞌjake ꞌdeni, kina ëdï ꞌdeni rɔ eꞌbe. ");
INSERT INTO bex_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Kina ɔdɔ kɔrɔke ꞌdeni këddï kumötuke, olake lëpï ye ga ame kirasi lende ꞌdeni ziye, römöyï ꞌdɔ ꞌbu ye ame mïtɔrɔ ne kola ye gbï gɔ lende kirasi ꞌbe ga.” ");
INSERT INTO bex_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lïjë ako kömö mï Yerosalema, kina koꞌja Yësu këdï kiliŋgere ꞌdeni kebe mï reki ꞌba rö löbu ꞌba Bɔkoꞌba yayi, na bɔ dɔ bɔ akumu ni ti bɔ kɔmɔ kiyandi ni ti löbu ꞌba bilaka ni ");
INSERT INTO bex_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kako kititi bo kiya te, “Közï kakpa ꞌba yë na me këddï koꞌdɔ wa naga nime timo ne? Yë na kiꞌdi közï kakpa ꞌba toꞌdɔ wa naga nime te zïyï?” ");
INSERT INTO bex_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yësu iya te, “Iꞌdike mititi ye ŋge kɔtɔ, ɔdɔ kilekike dɔmo ꞌdeni zö na ꞌjaa ti mileki dɔ akititi ꞌbe nima. ");
INSERT INTO bex_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iyake zö te, közï kakpa ꞌba bapatisi nime Yowani koloma tönë rɔ toꞌdɔ mo ne ako di yala? Yë na kiꞌdi zi bo, Bɔkoꞌba na kiꞌdi ala bilaka lesi na kiꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kina lïjë koloma ŋgï rɔ towasa mo rɔ gɔ rönnï. Lïjë iya te, “Ɔdɔ diyake te ako di zi Bɔkoꞌba bo ti kiya te, ‘Ne gɔ waꞌdi na kpe kiꞌdike dɔye dë gɔ lende ꞌba Yowani?’ ");
INSERT INTO bex_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɔdɔ diyake te ako di zi bilaka lesi ele dë gbï.” Lïjë ëdï kere di zi bilaka konzi naga nima römöyï lïjë pili omeri ŋgï rɔ ma laka Yowani rɔ bɔ kumë lende ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kina lïjë kileki dɔmo ŋgï zi Yësu te, “Dikali dë.” Yësu iya zïnnï te, “Kina gbï ma minza miya ziye közï kakpa ꞌba yë na me mëdï moꞌdɔ wa naga nime timo.” ");
INSERT INTO bex_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kina Yësu koloma ŋgï rɔ tilende zïnnï rɔ dɔŋgala, bo iya te, “Bɔ mɔtɔ ïdïyë mɔwɔ këdï koꞌdɔ rɔ layi naga ŋgï rɔ nyaka, bo kigaga reki kuru dɔmo, bo kole gö ꞌba tuzï layi mo, bo kole kilaŋga ꞌba toda mo. Kina bo koꞌde bɔ ndɔbɔ ŋgï kiꞌdi yïmo bo kënyï kari dɔ gawo ma kɔwɔ. ");
INSERT INTO bex_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kina ɔdɔ kada ꞌba titeꞌde mo kömö ꞌdeni tine, na bo koja bɔ laja abo mɔtɔ ŋgï kari ꞌdɔ koꞌde ma ꞌba bo. ");
INSERT INTO bex_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tine bɔ ndɔbɔ naga nima omba bɔ laja nima ŋgï koga kileki rɔ közï sari. ");
INSERT INTO bex_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bo oja bɔ laja mɔtɔ gbï kari. Kina bɔ ndɔbɔ naga nima komba ŋgï koga dɔmo koꞌdɔ kënyë kɔmɔ. ");
INSERT INTO bex_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bo oja mɔtɔ gbï kari. A ma tine lïjë omba ŋgï kupö yaga. Kina lïjë koloma ŋgï nduwë rɔ toꞌdɔ bɔ laja ma konzi mɔtɔ ga nduwë tara, mɔtɔ ga lïjë omba rɔ tomba, mɔtɔ ga lïjë upö ŋgï yaga. ");
INSERT INTO bex_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Rɔ ŋburuŋburu mo tine bɔtɔ mɔtɔ ari kinza kpe zi bo ꞌdeni ŋge rɔ kole kɔtɔ abo ame bo kɔꞌɔ kulöwö ne, na bo koja ŋgï. Bo omeri, bo iya te, ‘Ame rɔ kole ma ne lïjë ëdï koro.’ ");
INSERT INTO bex_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tine bɔ ndɔbɔ naga nima iya ŋgï rɔ gɔ rönnï te, ‘Bɔ këdï kari koloma rɔ bɔ dɔ nyaka nime kada mɔtɔ di pötö ꞌbu bo mo tönë ne bo na me, ako dupöke bo yaga ꞌdɔ nyaka nime koloma ŋgï ŋburu rɔ eze.’ ");
INSERT INTO bex_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kina lïjë kindaꞌba bo ŋgï kupö bo kuꞌdu töku mo yaga di mï nyaka nima.” ");
INSERT INTO bex_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yësu ileki kititi bilaka naga nima yayi ne kiya te, “Ma komerike ꞌbeye, waꞌdi na ti bɔ dɔ nyaka nima kari koꞌdɔ? Rɔ ma laka bo ti kari ŋgï kote dɔ bɔ ndɔbɔ naga nima pili yaga, bo koꞌde rɔ bilaka ma löwö na kako toꞌdɔ ndɔbɔ yïmo. ");
INSERT INTO bex_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ïdëkïke dë su me tönë kugu mï buku ꞌba Bɔkoꞌba kiya te, ‘Döku tönë bɔ koꞌba rö ni kilagi pa di rɔmo ne na kileki ꞌdeni rɔ döku ma laka rɔ dɔ kiteli mï gbɔndɔ ꞌba rö.’ ");
INSERT INTO bex_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ame wa koꞌdɔ ꞌba ŋere Bɔkoꞌba na. Dotɔke ŋgï rɔ gɔze.” ");
INSERT INTO bex_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kina löbu ꞌba Yudayi ni koloma ŋgï rɔ toma kɔri ꞌba ꞌdɔ tupö bo timo. Römöyï lïjë ïyënï rönnï tëgë Yësu ëdï rɔ tiya dɔŋgala nima rönnï. Tine lïjë ere tïndï naga nima yayi ne. Kina lïjë kitaꞌba ŋgï yaga di ŋgila bo. ");
INSERT INTO bex_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kina lïjë kari koja Parosi mɔtɔ ga ŋgï ti bilaka mɔtɔ ga ꞌba Erode ŋgï kako zi bo tokɔ kpa bo. ");
INSERT INTO bex_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lïjë ako kititi bo kiya te, “Bɔ kɔmɔ kiyandi, dikali ŋgï nï lende ꞌbï ga na rɔ ma kodɔrɔ. Mï lende kiya ꞌbï zi bilaka ere bɔtɔ dë, lende ꞌbï ga pili rɔ ma koriya zi ma titi kpaki ti ma löbu mo ga. Köꞌdu ꞌba Bɔkoꞌba na këddï kiyandi bilaka timo rɔ ma kodɔrɔ. Iya zize te, tara ne ëdï ŋgï rɔ ma laka mï köꞌdu kiꞌdi ꞌba Bɔkoꞌba ꞌdɔ topi awada zi bɔ dɔliŋɔ ma löbu ꞌba Romo? Ala tondo?” ");
INSERT INTO bex_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yësu ikali dɔŋgala ꞌbënnï nima ꞌdeni mɔlo na bo kileki kiya zïnnï te, “Kpe, ëddï koꞌbake ma gɔ waꞌdi? Oꞌdeke gïrïsï siliŋbi mo te dayi moŋgɔ te.” ");
INSERT INTO bex_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Lïjë oꞌde zi bo na bo kititi lïjë iya te, “Kïnë yë ti möyï yë na me kugu rɔmo ne?” Lïjë iya te, “Bɔ dɔliŋɔ ꞌba Romo na.” ");
INSERT INTO bex_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bo iya zïnnï te, “Laka, wa ame rɔ ꞌba bɔ dɔliŋɔ ne opike zi bɔ dɔliŋɔ. Tine ame rɔ ꞌba Bɔkoꞌba ne opike zi Bɔkoꞌba.” Kina lende abo kigayi lïjë ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kina ya ma rɔ Sadoke ni lïjë ma komeri ꞌbënnï kiya te a mɔtɔ inza rɔ tɔdɔ ꞌba töku di mï tölë naga kako ŋgï zi Yësu. Lïjë ititi bo iya te, ");
INSERT INTO bex_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bɔ kɔmɔ kiyandi, Musa ugu iya te ɔdɔ löndö yï mɔtɔ kölë kola ꞌja abo kinza ti kole, indaꞌba közïmo ꞌdɔ köyöke bi dɔ löndö yï nima. ");
INSERT INTO bex_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tine ya mɔtɔ ga pa bine rɔ löndö kɔtɔ modɔmorïyö. Bɔ ma löbu mo ogbe ꞌja kina kölë ŋgï kola kinza ti kole. ");
INSERT INTO bex_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kole ma mï rïyö mo indaꞌba közïmo kina bo kölë ŋgï gbï kola nï kinza ti kole. Bɔ ma rɔ mï mota mo indaꞌba közïmo, ");
INSERT INTO bex_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","kina ŋgï gbï tara nduwë rɔ gönnï nima pili kpaki modɔmorïyö kinza ma köyö kole. Rɔ ŋburuŋburu mo na ꞌja mo tönë kari kölë ŋgï gbï. ");
INSERT INTO bex_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tine mï kada ꞌba tɔdɔ ꞌba töku di mï tölë ti lɔko këdï rɔ ꞌja ꞌba yë, ya modɔmorïyö naga nima na ma ꞌdeni pili rɔ mëꞌdë nï?” ");
INSERT INTO bex_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yësu ileki dɔmo zïnnï iya te, “Kpe, öluke lende ꞌdeni ŋgï sowa. Buku ꞌba Bɔkoꞌba ikalike dë. Ikalike a mɔtɔ rɔ tigɔ abo dë gbï yɔ. ");
INSERT INTO bex_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bilaka ame ga këdï kɔdɔ di mï tölë ne a mɔtɔ inza kpe zïnnï rɔ, rɔ kogbe. Lïjë ꞌdeni ŋgï kɔzɔ malayika ꞌba mï dɔyayi ꞌba mïtɔrɔ naga tara. ");
INSERT INTO bex_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kina ma gɔ lende ꞌba tɔdɔ ꞌba töku di mï tölë, kpe ïdëkïke dë su di mï akugu ꞌba Musa ma tönë paꞌdo köbö zi bo dɔ morogo Bɔkoꞌba kiya zi bo te, ‘Ma na rɔ Bɔkoꞌba ꞌba Abarayama, Bɔkoꞌba ꞌba Yisika, Bɔkoꞌba ꞌba Yakoba.’ ");
INSERT INTO bex_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ne kina me dikali ŋgï lïjë inza kpe rɔ töku, Bɔkoꞌba ïdïdï lïjë ꞌdeni. Kpe öluke lende ꞌdeni sowa.” ");
INSERT INTO bex_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bɔ kɔmɔ kiyandi mɔtɔ ame këdï yayi rɔ tuwö kowasa ꞌbënnï nima ne, ënyï ŋgï kako ŋgɔsi. Kina ɔdɔ bo koŋgɔ Yësu ŋgï kileki dɔ lende rɔ ma kodɔrɔ zi ya naga nima kɔzɔ a nima tara tine, bo ënyï kititi Yësu iya te, “Köꞌdu kiꞌdi ꞌba Bɔkoꞌba ma yala na kulöwö rɔ dɔ kiteli?” ");
INSERT INTO bex_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yësu ileki dɔmo te, “Köꞌdu kiꞌdi ma kulöwö rɔ dɔ kiteli mo na tönë kiya te, ‘Kpe Yisarele, uwöke. Ŋere Bɔkoꞌba ze na ŋge kɔtɔ rɔ Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ziye tɔꞌɔ ŋere Bɔkoꞌba ꞌbe ti dökïꞌdï ye pili ti dïdï ye pili ti meri ꞌba dɔye pili ti tigɔ ꞌbe ga pili.’ ");
INSERT INTO bex_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma rɔ mï rïyö mo na me, ‘Ziye tɔꞌɔ lëpï ye ga gbï kɔzɔ ma kɔꞌɔke yida rɔye ga tara.’ Köꞌdu kiꞌdi mɔtɔ ma kulöwö rɔ dɔ kiteli di dɔ ame inza.” ");
INSERT INTO bex_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi nima ënyï kileki dɔmo ŋgï zi Yësu iya te, “Bɔ kɔmɔ kiyandi, ele sowa. Rɔ ma laka kɔzɔ a kiya ꞌbï, ŋere Bɔkoꞌba ŋge kɔtɔ, Bɔkoꞌba ꞌberi mɔtɔ inza. ");
INSERT INTO bex_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kina gɔ ze bilaka lesi dɔꞌɔke Bɔkoꞌba ti dökïꞌdï ze pili, ti meri ꞌba dɔze pili, ti tigɔ ꞌba mïze ga pili. Kina gɔ nï mɔtɔ kɔꞌɔ lëpï yï gbï kɔzɔ ma kɔꞌɔ yida röyï tara. Köꞌdu kiꞌdi rïyö naga nime na rɔ dɔ kiteli kebe tumu roma ni pili zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yësu oŋgɔ dɔ lende kileki ꞌba bɔ nima ŋgï ti lende kikali mo kulöwö. Na bo kënyï kiya zi bɔ nima te, “Nï, inza kpe gba ŋbö rɔ ma kɔwɔ di rɔ ŋere löbu ꞌba Bɔkoꞌba.” Di pötö lende nime bɔtɔ mɔtɔ ilaŋa rönï dë kpe tititi Yësu. ");
INSERT INTO bex_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kina ɔdɔ Yësu këdï ꞌdeni rɔ tiyandi wa di mï reki ꞌba rö löbu ꞌba Bɔkoꞌba tine, bo iya te, “Rɔ ma tondo mo ga na bɔ kɔmɔ kiyandi ni këdï kiya te Kurïsïtö ame Bɔkoꞌba këdï koja ne di mï kupö Dawidi? ");
INSERT INTO bex_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawidi na tönë kiya ti Nyï Kɔtɔ Laka teyi te, ‘Ŋere Bɔkoꞌba iya zi ŋere ma te, “Oloma dɔ dörï ma bine ŋbö miꞌdi yi kaꞌda bɔ ya ꞌbï ga.”’ ");
INSERT INTO bex_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawidi mo na me kïdëkï bo ꞌdeni rɔ ŋere. Ne rɔ ma tondo mo na ꞌdɔ ŋere ꞌba Dawidi mo tönë kileki ꞌböwu rɔ kole zi bo?” ");
INSERT INTO bex_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mï akiyandi abo zïnnï bo iya te, “Kpe iꞌdike kɔmɔye kandi laka di zi bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni. Akoꞌdɔkɔ ꞌbënnï rɔ tiliŋgere ti bɔŋgɔ kidakpa ꞌbënnï naga nima rönnï. Tumötö lïjë kɔzɔ bɔ rɔ koro naga tara di mï bi ꞌba ndögö na lende mo kɔꞌɔ rönnï. ");
INSERT INTO bex_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Akiteri ꞌbënnï rɔ kïtï ma löbu naga di mï rö ꞌba mötu ti bi ma laka di mï ŋbele. ");
INSERT INTO bex_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lïjë bɔ këdï kodɔ gomɔ rɔ makuruꞌbë tote dɔ amo naga nima. Mötu koꞌdɔ ꞌbënnï rɔ gögö tileme rönnï timo. Lïjë nime, kada mɔtɔ karama ma këdï kodɔ dönnï na rɔ dɔ kiteli.” ");
INSERT INTO bex_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yësu ari koloma ŋgɔsi ŋgila sandu ꞌba tuꞌdu kpa közï kiꞌdi di mï reki ꞌba rö löbu ꞌba Bɔkoꞌba yayi. Tïndï këdï kɔlɔ rɔ tuꞌdu kpa közï kiꞌdi ꞌbënnï ga ne bo ëdï le rɔ toŋgɔ mo. Ma rɔ bɔ mɔri ma konzi ni ako kuꞌdu yamo ŋgï ŋbaŋi. ");
INSERT INTO bex_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tine ꞌja ma rɔ makuruꞌbë bɔ lisa mɔtɔ ako kuꞌdu ma ꞌbënï rɔ taripa rïyö. ");
INSERT INTO bex_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bo ïdëkï bɔ kösö gɔ bo ga kako zi bo, na bo kiya zïnnï te, “Rɔ ma laka miya ziye, makuruꞌbë, ꞌja bɔ lisa nime, lɔko na kuꞌdu kpa közï kiꞌdi kebe bilaka naga nime pili. ");
INSERT INTO bex_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Römöyï lïjë ma laki naga nima onye ŋge mbowa di rɔ wa mbëmbë ꞌbënnï ga. Ne ma ꞌbënï inza tara, gɔ rɔmo na ma ꞌdeni pili lɔko kuꞌdu ne, mɔtɔ inza kpe.” ");
INSERT INTO bex_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kina ɔdɔ Yësu ni këdï kɔdɔ ꞌdeni yaga di mï reki ꞌba rö löbu ꞌba Bɔkoꞌba yayi tine, bɔ kösö gɔ bo ga ma kɔtɔ ako kiya zi bo te, “Bɔ kɔmɔ kiyandi, oŋgɔ te. Oŋgɔ döku naga nime ma kiyija koꞌba kele te.” ");
INSERT INTO bex_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yësu ileki dɔmo zïnnï iya te, “Rö löbu naga nima këdï koŋgɔke koꞌba tara ne, kada mo ɔdɔ kömö ꞌdeni dayi döku ma kɔtɔ mɔtɔ mo te inza kileke rɔ ma kudöꞌdu dɔ lëpï nï. Bɔ ya ëdï kïtïŋï ꞌdoyi bërï.” ");
INSERT INTO bex_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kina ɔdɔ bo kari koloma ꞌdeni bërï dɔ döku ꞌba Bilaya ame kuyï kömönï kari te dɔ rö löbu ꞌba Bɔkoꞌba ne tine, na Pïtörö ni ti Yakoba ti Yowani ti Andareya kako rɔ dönnï kititi bo kiya te, ");
INSERT INTO bex_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Iya zize. Kada nima ti këdï nyanya ga? Kina akileme mo ame gɔ kinda timo kada mo ëdï ꞌdeni ŋgɔsi na rɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yësu oloma rɔ tiya mo zïnnï te, “Iꞌdike kɔmɔye kandi laka kinza bɔtɔ mɔtɔ kuꞌbölu ye ra. ");
INSERT INTO bex_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ma konzi mɔtɔ ga ti kako ti möyï ma kiya te, ‘Ma na rɔ Kurïsïtö.’ Kina ti lïjë kuꞌbölu ma konzi ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tine ɔdɔ kuwöke birɔ ya di ŋgɔsi ti lëbï mo ma di bi kɔwɔ kinza kereke dë. Wa naga nima pili ëdï koꞌdɔ rönnï tine ŋburuŋburu ꞌba dɔliŋɔ na dë gba. ");
INSERT INTO bex_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Römöyï dɔyayi ti kënyï ꞌdeni toꞌdɔ ya rɔ gɔ rönnï, kina dɔliŋɔ ti kënyï ꞌdeni toꞌdɔ ya rɔ gɔ rönnï. Kïzïkïzï ti këdï ꞌdeni mï gɔ bi ma konzi. Kina ꞌbö ni ti sëyï ti këdï ꞌdeni. Wa naga nime pili te gba tisaki mo na kɔzɔ mï kɔꞌɔ ꞌba löyö naga tara. ");
INSERT INTO bex_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ne kpe iꞌdike kɔmɔye kandi laka. Ti kindaꞌba ye ꞌdeni koto ye kɔmɔ kïtï ꞌba burë. Ti komba ye ꞌdeni di mï rö ꞌba mötu. Kina ti lïjë koto ye ꞌdeni kiꞌdi ye kɔrɔke kɔmɔ ŋere ni ti bɔ dɔliŋɔ ni gɔ köꞌdu ma, todɔrɔ bïcï lende ꞌba laja laka nime. ");
INSERT INTO bex_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tine dɔgba mo laja laka na ti kuwöwö rönï titi toko. ");
INSERT INTO bex_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kina ɔdɔ lïjë kindaꞌba ye koto ye kɔmɔ kïtï ꞌba burë, kinza kiꞌdike kɔmɔye kïlëꞌdï dë gɔ wa ma ꞌdɔ kari kiyake. Wa ame kiꞌdi rönï ziye ꞌdɔ tiya mo mï kada nima ne na kiyake. Römöyï wa ame këdï kari kiyake ne ti këdï pili rɔ ma kako di zi Nyï Kɔtɔ Laka. ");
INSERT INTO bex_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bilaka ti kiꞌdi löndö nnï ga ꞌdeni tupö mo yaga. Kina ti ꞌbu ni koꞌdɔ ꞌdeni gbï tara zi kole ꞌbënnï ga. Kina ti kole kebe kuyï kpënnï ꞌdeni gbï rɔ ma köyö lïjë ga tupö mo yaga. ");
INSERT INTO bex_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Laki pili ti koꞌji ye gɔ lende ma. Tine bɔ ame kiꞌdi mï bo këddï teyi ŋbö kömö mï kada ꞌba tote mo ti kɔmɔ ŋgï di mï tölë.” ");
INSERT INTO bex_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kina ɔdɔ kiya te koŋgɔke kuruku kënyë tönë kɔdɔ ꞌdeni mï gɔ bi ame mɔlo kinza rɔ bi abo ne tine, (ame ugu zi bɔ kïdëkï mo ga ꞌdɔ kikali) iꞌdike lïjë ame ga mï Yudayi ne kiriŋa ti kusu dönnï mï döku. ");
INSERT INTO bex_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kinza bɔ ame këdï yaga tindawo rɔ bo ne kïlëyï dɔ bo dë kpe kɔdɔ titi rö togba abo ga. ");
INSERT INTO bex_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kinza bɔ ame këdï ꞌdeni mï nyaka ne kileki dë kpe kari liŋɔ togba bɔŋgɔ abo. ");
INSERT INTO bex_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mï kada mo nima gomɔ ꞌba ꞌja ame ga rɔ ma kɔmɔ ti ma këdï ti kole dɔ közïnnï naga na ti kënyë ma ꞌbënnï ŋgï kulöwö. ");
INSERT INTO bex_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Umötuke zi Bɔkoꞌba kinza bo kiꞌdi koꞌdɔ rönï dë mï kada ꞌba bi këyï ame rɔ alïrï ne. ");
INSERT INTO bex_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Römöyï gomɔ ꞌba mï kada nima ti kënyë ꞌbënï ꞌdeni ŋgï rɔ dɔ kiteli kebe gomɔ mɔtɔ ga ame pele këdï koꞌdɔ rönnï mï dɔliŋɔ nime bine mɔlo kako di bi tisaki mo ŋbö kömö mï kada nime tɔne. Kina gomɔ mɔtɔ ma ꞌdɔ këdï kɔzɔ ame te inza kpe nati. ");
INSERT INTO bex_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tine Bɔkoꞌba ileki gɔ kada mo ꞌdeni ŋge mbowa. Ma kiya te kinza tara dëne bɔtɔ mɔtɔ inza kɔmɔ. Bo ileki gɔ kada mo ŋge ꞌdeni mbowa tara gɔ köꞌdu ꞌba bilaka abo ga ame bo koweli ꞌdeni ne. ");
INSERT INTO bex_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kina ɔdɔ kiya te bɔtɔ mɔtɔ kako kiya pele ziye te, ‘Oŋgɔ te, Kurïsïtö na me bine,’ ala ‘Kina ma ꞌdë,’ kinza kiꞌdike dɔye dë gɔmo. ");
INSERT INTO bex_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Römöyï ya mɔtɔ ga ma kidewo rönnï tëgë lïjë rɔ Kurïsïtö ti bɔ kumë lende ma dɔ kïndëndë mɔtɔ ga ti kɔdɔ ꞌdeni. Kina ti lïjë koꞌdɔ gɔ kotɔ ma kinza kiya naga ŋgï tiyɔzɔ tuꞌbölu ame ga pele Bɔkoꞌba koweli ꞌdeni ne timo. ");
INSERT INTO bex_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kpe, iꞌdike kɔmɔye kandi laka. Wa pili na me ga mïyëtï gɔmo ꞌdeni mɔlo ndö te ziye.” ");
INSERT INTO bex_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Di pötö kada ꞌba gomɔ naga nima, kïnë kada ti kuyï rönï ꞌdeni ŋgï yaga rɔ ma kölu, kina nyepe gbï inza kaŋmi kpe. ");
INSERT INTO bex_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kina ti kiyaya këlu ni ꞌdeni kilayi kako bërï di mïtɔrɔ. ");
INSERT INTO bex_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kina ti kole ꞌba bilaka lesi ti kɔdɔ ŋgï tako ti pɔli mï tigɔ ꞌba löbu dɔ kiteli abo. ");
INSERT INTO bex_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kina ti bo koja malayika ŋgï kari mï dɔ kumu sowɔ ꞌba dɔliŋɔ nime tutöꞌdu bilaka ame ga pili rɔ ꞌba Bɔkoꞌba ne. Kina ti lïjë kutöꞌdu ŋgï yaga ꞌdoyi di mï dɔliŋɔ nime. ");
INSERT INTO bex_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iꞌdike ŋgërï këlu kiyandi ye. Ɔdɔ koŋgɔ rɔ dɔŋgila mo ga këdï köyö solɔrɔ ꞌdeni, mbili mo këdï kunzï nima ikali ŋgï kpa dökïkërï ɔwɔ dë kpe. ");
INSERT INTO bex_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kina gbï tara ɔdɔ koŋgɔke wa naga nime ꞌdeni këdï koꞌdɔ rönnï nima, ziye tikali mo ŋgï kada ꞌba tako ꞌba kole ꞌba bilaka lesi ɔwɔ dë kpe. ");
INSERT INTO bex_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Omerike lende nime laka. Wa naga nime ti koꞌdɔ rönnï kota bilaka ma leꞌjete naga nime mɔtɔ ga kölë dë gba. ");
INSERT INTO bex_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mïtɔrɔ ni ti dɔliŋɔ ti kiteli ꞌdeni. Tine lende ma inza kiteli du ma kɔtɔ te. ");
INSERT INTO bex_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tako ꞌba kada mo nima bɔtɔ ma kɔtɔ mɔtɔ ikali dë. Pele rɔ malayika ꞌba mï dɔyayi ꞌba mïtɔrɔ ikali dë. Kina kole ꞌba Bɔkoꞌba pele ikali dë gbï. Bo Bɔkoꞌba ꞌbu na ŋge kikali abo. ");
INSERT INTO bex_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kina iꞌdike kɔmɔye kandi laka kolomake ti bi koda römöyï kada mo ikalike dë. ");
INSERT INTO bex_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ti këdï kɔzɔ lende ꞌba bɔ mɔtɔ ame kënyï ŋgï kari dɔ ŋba ne tara. Mï tari abo bo ose gɔ liŋɔ zi bɔ laja abo ga. Bo oza ndɔbɔ pili rɔ kɔtɔkɔtɔ zïnnï toꞌdɔ mo, bo kiꞌdi bɔ ma ꞌdɔ koda gɔ bi ŋgï toda bi laka di rɔ liŋɔ. ");
INSERT INTO bex_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kina ti, odake bi laka römöyï kada ꞌba tako abo ꞌba ŋere ꞌbe ikalike dë. Ɔdɔ ti bo kömö mï dɔkɔpiyari ala mï zana korɔndɔ, ala mï kano bi, ala rɔ mï dɔŋbɔ, kpe ikalike dë. ");
INSERT INTO bex_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Odake bi laka kinza bo kako kömö ra ŋgï tuguꞌdu kota ye këddïke bi töꞌdö. ");
INSERT INTO bex_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tine a ma mose ziye pili na me, olomake ti bi koda.” ");
INSERT INTO bex_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ame tine kada ꞌba karama ꞌba Pasaka mo tönë ola töꞌdö mo ꞌdeni ŋge dɔ rïyö nati. Karama ꞌba tonyo maŋgolɔꞌbɔ kinza laŋga gɔmo mo tönë. Tine bɔ dɔ bɔ akumu ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ëdï rɔ toma kɔri ꞌba ꞌdɔ tindaꞌba Yësu ŋgï liwo kupö yaga. ");
INSERT INTO bex_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Römöyï lïjë omeri iya te, “Doꞌdɔke dë mï kada ꞌba karama kinza tïndï kënyï ra koꞌdɔ ayayi.” ");
INSERT INTO bex_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kina ɔdɔ bo këdï ꞌdeni Betaniya liŋɔ ꞌba bɔ mɔtɔ kïdëkï rɔ Simona Bɔ Mönyu tine, lïjë këdï ꞌdeni kpa akonyo na ꞌja mɔtɔ kako ŋgï ti kizaza ma kele ꞌba ꞌbu kato ndögö kitigɔ kulöwö naga. Lɔko itikɔ kpamo ŋgï yaga lɔko koloma rɔ tinzanza mo dɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tine ënyë ŋgï mï ya mɔtɔ ga yayi kebe tomeri mo te, “Lɔko ëdï kirasi ꞌbu nima gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma lɔko këdï kugö ra mökö oꞌja dëne ëdï koꞌde yamo ŋbö kuluku modɔɔkɔtɔ gbï ti dɔmo teyi ꞌdi gɔ lɔko kokɔnyi bɔ lisa ni timo.” Kina lïjë koloma ŋgï rɔ togba dökïꞌdï ꞌja nima timo. ");
INSERT INTO bex_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kina Yësu kileki zïnnï te, “Kpe, ëddï kogbake dökïꞌdï ꞌja nima gɔ waꞌdi? Olake nï. A ma laka kulöwö na me lɔko koꞌdɔ ꞌdeni zö. ");
INSERT INTO bex_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bɔ lisa ni ëdï koloma nduwë tiye bine, ɔdɔ koꞌdɔkɔke ti koꞌdɔke lende laka ꞌdeni ŋgï zïnnï. Ne ma ꞌbama minza möꞌbö tiye bine. ");
INSERT INTO bex_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wa ame ŋgï lɔko kɔꞌbɔ toꞌdɔ mo ne na ma lɔko koꞌdɔ ꞌdeni zö. Lɔko ileŋo yida rɔma ꞌdeni mɔlo ndö koda dɔ tusu ma. ");
INSERT INTO bex_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne rɔ ma laka miya ziye, wa nime lɔko koꞌdɔ ne ti kïyëlë rönï ꞌdeni ŋgï kote mï gɔ bi ame ga pili laja laka ma nime këdï kuwöwö rönï teyi ne tomeri gönï timo.” ");
INSERT INTO bex_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kina Yuda Isikarita ma kɔtɔ di mï löŋgö ya ma ꞌbutë dɔmorïyö mo naga nima ne kënyï ŋgï kari zi bɔ dɔ bɔ akumu ni tususu Yësu zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kina ɔdɔ lïjë kuwö lende ma bo kiya zïnnï tara tine na mïnnï koŋmi ŋgï lïjë kose ꞌdɔ topi yamo zi bo. Kina Yuda koloma ŋgï nati rɔ toma kɔri ma laka ame gɔ bo kiꞌdi közï Yësu timo zïnnï ne. ");
INSERT INTO bex_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mï kada ma dɔndende ꞌba karama ma këdï konyo maŋgolɔꞌbɔ mo kinza laŋga gɔmo nima tine, mï kada ame ꞌdeni rɔ ꞌba tumu kamölö mo ne, na bɔ kösö gɔ bo ga kako kititi bo, iya te, “Oꞌdɔkɔ gɔ dari dileŋo gɔ bi ꞌba tonyo karama zïyï yala?” ");
INSERT INTO bex_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kina bo koja ya ma rïyö di mï löŋgö lïjë ŋgï kari ti ndose nime, bo iya te, “Arike mï gawo yayi, di bi tömö ꞌbe dɔye ti kondɔsɔ ti bɔ mɔtɔ ti kete mini dönï. Ozike gɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Liŋɔ ame bo kɔdɔ teyi ne ari kiyake zi bɔ dɔ liŋɔ mo te, ‘Bɔ kɔmɔ kiyandi iya te, “Rö ma yala na ꞌdɔ dako donyo karama ꞌba Pasaka nime yïmo ti bɔ kösö gɔma ga?”’ ");
INSERT INTO bex_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kina ti bo kileme rö tɔrɔ löbu ŋgï ziye ti jama mo ga kiyija ꞌdeni ndö ziye kina gɔ kileŋoke gɔ bi zize yayi.” ");
INSERT INTO bex_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kina bɔ kösö gɔ bo naga nima kari ŋgï mï gawo yayi koꞌja wa pili ŋgï kɔzɔ ma bo kose zïnnï. Kina lïjë kileŋo bi ꞌba tonyo karama ŋgï zïnnï yayi. ");
INSERT INTO bex_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mï dɔkɔpiyari ꞌdeni na Yësu ni ti bɔ kösö gɔ bo ga ma ꞌbutë dɔmorïyö kako ŋgï yayi. ");
INSERT INTO bex_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kina ɔdɔ lïjë këdï ꞌdeni kpa akonyo tine, bo iya zïnnï te, “Rɔ ma laka mëdï miya ziye, bɔ ma kɔtɔ mɔtɔ di mï löŋgö ye nima bina na këdï kari kususu ma. Bɔ ma kɔtɔ ame ŋgï këdï konyo wa bi kɔtɔ tö ne.” ");
INSERT INTO bex_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kina lïjë ŋgï rɔ meri lïjë kebe rɔ tititi bo pili rɔ gönnï nima kiya te, “Ma mo na dë ŋgï ɔtɔ ya?” ");
INSERT INTO bex_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bo ileki dɔmo te, “Bɔ ma kɔtɔ mɔtɔ ŋgï di mï löŋgö ye kpe ma ꞌbutë dɔmorïyö naga nime. Bɔ ma kɔtɔ mɔtɔ ame ŋgï këdï kusu közïnï mï lebe kɔtɔ tö ne. ");
INSERT INTO bex_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kole ꞌba bilaka lesi ëdï kölë ŋgï kɔzɔ lende ma tönë kugu mï buku ꞌba Bɔkoꞌba gɔ köꞌdu abo ne tara. Tine buꞌbu zi bɔ ma kususu bo nima. Ma laka mo dëne ꞌdɔ köyö bo dë ka ndeŋi.” ");
INSERT INTO bex_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kina ɔdɔ lïjë këdï ꞌdeni kpa akonyo yayi tine, na Yësu kogba maŋgolɔꞌbɔ ŋgï bo kileki yëëꞌdï mo zi Bɔkoꞌba bo konye yïmo kiꞌdi zi bɔ kösö gɔ bo ga. Bo iya te, “Me, ogba konyo. Ame na rɔ yida rɔma.” ");
INSERT INTO bex_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kina bo kogba kösu gbï kileki yëëꞌdï mo bo kiꞌdi ŋgï zïnnï lïjë pili kuwë di yïmo. ");
INSERT INTO bex_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bo ileki kiya zïnnï te, “Ame na rɔ roma ma ame kulöwu ꞌdeni gɔ ma konzi, lömu ꞌba Bɔkoꞌba kɔrɔ ꞌdeni dɔmo ne. ");
INSERT INTO bex_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rɔ ma laka miya ziye akuwë nime minza muwë kpe titi tine ꞌjaa ŋbö rɔ ma laꞌja di mï ŋere löbu ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kina ɔdɔ lïjë koba ŋgala ꞌdeni tine na lïjë kari ŋgï dɔ döku ꞌba Bilaya. ");
INSERT INTO bex_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yësu iya zïnnï te, “Kpe pili ti kiriŋake ꞌdeni ŋgï kolake ma. Römöyï buku ꞌba Bɔkoꞌba iya ꞌdeni tönë mɔlo bine te, ‘Ti mupö bɔ koda kamölö mo yaga kina ti kamölö kitaꞌba ŋgï.’ ");
INSERT INTO bex_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tine ɔdɔ mɔdɔ ꞌdeni yaga di mï tölë mëdï mari nduwë tötï dɔgba kɔmɔye mï Galilaya.” ");
INSERT INTO bex_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pïtörö iya te, “Ɔdɔ kiya te ya ma laki kiriŋa pele pili, ma ꞌbama minza mola göyï.” ");
INSERT INTO bex_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yësu ileki zi bo iya te, “Rɔ ma laka mëdï miya zïyï, nï mï korɔndɔ nime tɔne, gba kota gɔŋgɔ kidapa dë mï rïyö ëddï koga kpëyï gɔma mï mota kiya te ikali ma dë.” ");
INSERT INTO bex_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pïtörö ileki gɔmo kiya rɔ ma kitigɔ te, “Ɔdɔ këdï pele rɔ tölë ti mölë kɔtɔ tïyï. Minza moga kpama göyï.” Kina lïjë kiya ŋgï pili kɔzɔ a nima tara. ");
INSERT INTO bex_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kina lïjë kako ŋgï kömö gɔ bi mɔtɔ kïdëkï möyï mo rɔ Getesemane. Yësu iya zi bɔ kösö gɔ bo ga te, “Kpe, olomake tötï bine mëdï mari toꞌdɔ mötu.” ");
INSERT INTO bex_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bo ogba Pïtörö ni ti Yakoba ti Yowani kari ti bo. Meri oso ŋgï mï bo kumïkï bo. ");
INSERT INTO bex_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kina bo kiya zïnnï te, “Meri oso ꞌdeni ŋgï lɔ mï dökïꞌdï ma kɔzɔ ëdï koꞌdɔ ꞌdeni ŋgï tupö ma yaga. Olomake tötï mbowa bine rɔ ma koŋgɔ bi ti bi koda.” ");
INSERT INTO bex_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bo ari mbowa dɔgba na bo kolɔdɔ ŋgï bërï tumötu, dëne ꞌdɔ kiyese gomɔ nima ra yaga di zi bo. ");
INSERT INTO bex_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Bo umötu kiya te, “Baba, ꞌbu ma, nï na kɔꞌbɔ wa pili. Kösu nima ogba yaga di kɔmɔ ma. Tine iꞌdi koꞌdɔ rönï gɔ akoꞌdɔkɔ ꞌbï, kinza gɔ akoꞌdɔkɔ ma.” ");
INSERT INTO bex_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bo ileki kako koꞌja bɔ kösö gɔ bo ga ma mota mo tönë ga köꞌdö ꞌdeni. Bo iya zi Pïtörö te, “Simona, ëddï bi töꞌdö? Ɔꞌbɔ dë toda bi pele ŋge saa kɔtɔ? ");
INSERT INTO bex_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Olomake ti bi koda ti mötu koꞌdɔ kinza koto ye ra mï akiyɔzɔ. Rɔ ma laka mï oꞌdɔkɔ ŋgï tine yida rɔ tigɔ mo inza.” ");
INSERT INTO bex_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kina bo kileki ŋgï kari ꞌböwu gbï tumötu gɔ lende kɔtɔkɔtɔ naga nima. ");
INSERT INTO bex_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bo ileki kako koꞌja lïjë köꞌdö ꞌdeni gbï römöyï lïjë ëdï ꞌdeni ŋgï kinano. Kina ŋgï lïjë ikali dë kpe tileki dɔ lende zi bo. ");
INSERT INTO bex_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mï mota mo tine na bo kako kiya zïnnï te, “Kpe, ëddïke eꞌbe gba bi töꞌdö tindawo rɔye? Ɔꞌbɔ ꞌdeni, kada mo ömö ꞌdeni. Ususu kole ꞌba bilaka lesi ꞌdeni kiꞌdi közï bɔ lende kënyë ni. ");
INSERT INTO bex_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ënyïke, darike. Oŋgɔke bɔ kususu ma mo tönë ömö ꞌdeni ŋgɔsi.” ");
INSERT INTO bex_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gba kota Yësu këdï kilende te yɔ na Yuda kömö ŋgï. Bo rɔ ma kɔtɔ di mï löŋgö ya ma ꞌbutë dɔmorïyö naga nima. Bo ako ti bilaka rɔ ma konzi gɔ bo, ya mɔtɔ ga ti mbele, mɔtɔ ga ti mɔbɔ. Bɔ dɔ bɔ akumu ni ti bɔ kɔmɔ kiyandi ni ti löbu ꞌba bilaka ni na koja lïjë. ");
INSERT INTO bex_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bɔ susu mo nima iya dɔŋgala ꞌba tindaꞌba Yësu timo ꞌdeni mɔlo zïnnï te, “Bɔ ame ɔdɔ koŋgɔke mari mome mbili mo nima bo na. Kina ꞌdɔ kindaꞌbake bo ŋgï karike ti bo yaga.” ");
INSERT INTO bex_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kina ɔdɔ bo kömö tïnnï yɔ na bo kilapo Yësu ŋgï, bo kiya te, “Ŋere ma.” Kina bo kome mbili Yësu ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kina bilaka abo naga nima kolɔdɔ ŋgï dɔ Yësu kindaꞌba ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tine bɔ ma kɔtɔ di mï löŋgö ya ama ga ti Yësu yayi ne otɔ mbele abo ŋgï koga dɔ bɔ laja mɔtɔ ꞌba bɔ dɔ bɔ akumu timo koke mbili mo ŋgiꞌbɔ yaga. ");
INSERT INTO bex_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yësu iya zïnnï te, “Kpe, gɔ waꞌdi na kakoke tindaꞌba ma kɔzɔ tindaꞌba bɔ ꞌbögö tara gɔmo, ti mbele ni ti mɔbɔ? ");
INSERT INTO bex_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rɔ kɔmɔ kada löbu nime pili mëdï moloma tiye mï reki ꞌba rö löbu ꞌba Bɔkoꞌba yayi tiyandi kɔmɔ bilaka ne, indaꞌbake ma dë mɔlo di yayi gɔ waꞌdi? Ne oꞌdɔ rönï ꞌdeni ꞌdɔ këdï kɔzɔ ma tönë kugu mɔlo mï buku ꞌba Bɔkoꞌba ne tara.” ");
INSERT INTO bex_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kina bɔ kösö gɔ bo ga kitaꞌba ŋgï pili di rɔ bo kiriŋa ga ëꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bɔ mɔtɔ gba rɔ yɔbi ti bɔŋgɔ kiŋaki rɔ bo na ŋge kösö gɔ Yësu yayi. Lïjë oꞌdɔkɔ tindaꞌba bo, ");
INSERT INTO bex_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na bo kolɔ rɔ bo ŋgï kiriŋa rɔ gɔ ŋbululu kola bɔŋgɔ nima zïnnï yayi. ");
INSERT INTO bex_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kina koto Yësu ŋgï kari liŋɔ ꞌba bɔ dɔ bɔ akumu. Na löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni kotɔtɔ rönnï ŋgï yayi. ");
INSERT INTO bex_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tine Pïtörö ozi ꞌdeni rɔ ma kɔwɔ nduwë ŋbö kari kɔdɔ gönnï liŋɔ ꞌba bɔ dɔ bɔ akumu nima yayi. Bo ari koloma ꞌdeni këdï rɔ tubï rɔ bo kɔmɔ paꞌdo ŋgila bɔ kanya mo naga nima yayi. ");
INSERT INTO bex_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bɔ dɔ bɔ akumu ni ti dɔ tumu ꞌbënnï nima pili oloma ga ŋgï rɔ toma kɔri ꞌba wa ame gɔ kodɔrɔ bïcï lende timo rɔ Yësu gɔ kupö bo yaga gɔmo ne. Tine lïjë oꞌja lende ɔtɔ dë di rɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ya ma konzi mɔtɔ ga ako pele ti susu bëtï mɔtɔ ga, tine lende ꞌbënnï pili oriya dë. ");
INSERT INTO bex_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kina ya mɔtɔ ga kënyï tɔrɔ tususu bo rɔ bëtï kiya te, ");
INSERT INTO bex_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Duwö bo koloma rɔ tiya mo te, ‘Rö löbu ꞌba Bɔkoꞌba nime rɔ akoꞌba ꞌba bilaka lesi ne ti mitikɔ yaga. Kina mï töꞌdö dɔ mota ti moꞌba ŋgï kileki gɔ bi mo rɔ ame közï bilaka lesi na dë koꞌdɔ.’” ");
INSERT INTO bex_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pele tara susu ꞌbënnï naga nima oriya dë. ");
INSERT INTO bex_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kina bɔ dɔ bɔ akumu mo nima kënyï ŋgï tɔrɔ mï löŋgö lïjë yayi, bo ititi Yësu kiya te, “Nï inza ti lende mɔtɔ tileki mo gɔ susu nime këdï koꞌdɔ kulöwö röyï ne?” ");
INSERT INTO bex_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tine Yësu udumö ŋgï le kileki dɔ lende nima dë. Bɔ dɔ bɔ akumu nima ileki kititi bo ꞌböwu te, “Nï na rɔ Kurïsïtö kole ꞌba Bɔkoꞌba bɔ yëyï mo tönë ne?” ");
INSERT INTO bex_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yësu ileki dɔmo te, “Ma na. Kina ti kari koꞌjake kole ꞌba bilaka lesi ꞌdeni koloma dɔ dörï Bɔkoꞌba tigɔ dɔ kiteli. Ti koꞌjake ꞌdeni ma bo këdï kako bërï ti pɔli di mïtɔrɔ.” ");
INSERT INTO bex_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kina bɔ dɔ bɔ akumu nima kirica bɔŋgɔ ŋgï yaga di rönï, kiya te, “Kpërï waꞌdi mɔtɔ na ꞌdɔ koma kpe ꞌböwu di kpa bilaka mɔtɔ todɔrɔ bïcï lende timo rɔ bo? ");
INSERT INTO bex_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kpe pili uwöke lende dölï abo nima ꞌdeni. Meri ꞌbe tondo?” Kina lïjë pili kodɔ karama ŋgï dɔ Yësu gɔ kupö yaga. ");
INSERT INTO bex_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kina ya mɔtɔ mo ga kebe ŋgï totoꞌbi woro rɔ Yësu, lïjë kudödu kɔmɔ bo teyi, lïjë komba bo, kititi kiya te, “Umë zize te, yë na komba yi?” Kina bɔ kanya mo ga kogba bo ŋgï koloma rɔ tokɔsɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pïtörö ëdï gba mï liŋɔ nima yayi. Nyiti bɔ laja ꞌba bɔ dɔ bɔ akumu mo nima ako koꞌja Pïtörö këdï rɔ tubï rɔ bo yayi. ");
INSERT INTO bex_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Lɔko oŋgɔ dɔ Pïtörö, na lɔko kiya te, “Oꞌja kɔzɔ nï nime gbï rɔ bɔ kösö gɔ Yësu ꞌba Nazareta nime ꞌdi?” ");
INSERT INTO bex_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pïtörö andi gɔmo kiya te, “Lende ꞌbï tɔ nima këddï kiya ne mikali dë.” Na bo kënyï ŋgï kari yaga kpa reki. ");
INSERT INTO bex_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nyiti mo tönë ako koꞌja bo kina lɔko kebe gbï rɔ tiya mo zi bɔ kanya ma këdï kɔrɔ yayi nima te, “Bɔ nime bo gbï rɔ ma kɔtɔ ꞌbënnï mɔtɔ.” ");
INSERT INTO bex_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kina Pïtörö kandi ŋgï gbï gɔmo. Mbowa ꞌböwu ya ma këdï kɔrɔ yayi mo nima, iya te, “Rɔ ma laka nï gbï rɔ ma kɔtɔ mɔtɔ ꞌbënnï römöyï nï di Galilaya.” ");
INSERT INTO bex_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kina Pïtörö kënyï ŋgï kulömu rɔ bo, kileki kiya te, “Ece mïtɔrɔ ne, bɔtɔ ꞌbï tɔ nima këddï kiya lende mo ne mikali dë.” ");
INSERT INTO bex_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kina gɔŋgɔ kidapa ŋgï rɔ mï rïyö mo nati. Kina Pïtörö komeri gɔ lende kiya ꞌba Yësu tönë ŋgï. Ame bo kiya te, “Gba kota gɔŋgɔ kidapa dë mï rïyö ti koga kpëyï gɔma mï mota.” Kina Pïtörö koga monɔ ŋgï bërï. ");
INSERT INTO bex_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mɔlo mï dɔŋbɔ mo nima na löbu ꞌba bɔ akumu ni ti löbu ꞌba bilaka ni ti bɔ kɔmɔ kiyandi ꞌba köꞌdu kiꞌdi ni ti tumu ꞌbënnï nima pili kotɔtɔ ga rönnï ŋgï yayi tudödu ndï lende bi kɔtɔ. Kina lïjë kiꞌdi kudödu Yësu ŋgï kogba koto zi Pilato turu bɔ dɔliŋɔ. ");
INSERT INTO bex_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato ititi iya te, “Nï na rɔ ŋere bɔ dɔliŋɔ ꞌba Yudayi nime ne?” Tine Yësu ileki dɔmo te, “Nï na kiya ëꞌbï tara.” ");
INSERT INTO bex_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kina bɔ dɔ bɔ akumu ni kako ŋgï koloma rɔ tususu Yësu gɔ lende ma konzi. ");
INSERT INTO bex_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato ënyï ꞌböwu kititi bo, iya te, “Inza ti lende mɔtɔ tileki mo? Oŋgɔ susu ꞌba röyï ma konya te.” ");
INSERT INTO bex_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tine Yësu udumö ŋgï kileki dɔmo dë. Kina lende mo kigayi Pilato ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mï kada ꞌba karama ꞌba Pasaka ꞌbënnï nima nduwë rɔ kɔmɔ kɔɔ Pilato oloma nduwë rɔ toja bilaka yaga kɔtɔ di mï maboso rɔ ame lïjë kiteri ꞌdɔ bo kope ne. ");
INSERT INTO bex_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mï kada nima bɔ mɔtɔ rɔ Baraba ëdï mï maboso yayi. Lïjë na koboso gɔ toꞌdɔ ayayi tupö bilaka. ");
INSERT INTO bex_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kina ɔdɔ tïndï kako ꞌdeni kititi Pilato tope bɔ mɔtɔ zïnnï di mï maboso tara ");
INSERT INTO bex_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","bo ititi lïjë iya te, “Ŋere bɔ dɔliŋɔ ꞌba Yudayi nime na koꞌdɔkɔke gɔ mope ziye?” ");
INSERT INTO bex_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato ikali rɔ ma laka bɔ dɔ bɔ akumu ni iꞌdi Yësu zi bo tupö mo yaga römöyï mïnnï ombi rɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tine bɔ dɔ bɔ akumu ni ososo kpa ya ma konzi ꞌdeni ꞌdɔ kititi Baraba na gɔ kope yaga di mï maboso zïnnï. ");
INSERT INTO bex_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ileki ꞌböwu kititi tïndï naga nima te, “Waꞌdi na koꞌdɔkɔke gɔ moꞌdɔ zi bɔ ame kïdëkï rɔ ŋere bɔ dɔ liŋɔ ꞌba Yudayi ne?” ");
INSERT INTO bex_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kina lïjë pili kulörï ŋgï timo rɔ ma kembe kiya te, “Utötï bo yaga.” ");
INSERT INTO bex_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato iya te, “Gɔ waꞌdi? Lende kënyë waꞌdi na bo kirasi?” Tine lïjë ulörï ŋgï kozɔ timo rɔ ma kembe kiya te, “Utötï bo yaga.” ");
INSERT INTO bex_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato oꞌdɔkɔ ꞌdɔ mïnnï koŋmi rɔ bo, na bo kope Baraba ŋgï yaga zïnnï di mï maboso. Kina bo kiꞌdi bɔ kanya ŋgï komba Yësu gɔ lïjë kari ti kutötï bo. ");
INSERT INTO bex_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bɔ kanya naga nima ogba Yësu ŋgï kari timo mï liŋɔ ꞌba turu bɔ dɔliŋɔ nima yayi. Kina lïjë kïdëkï dɔtumu ꞌba bɔ kanya ꞌbënnï nima ŋgï pili kako. ");
INSERT INTO bex_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lïjë ogba bɔŋgɔ kasi kolɔ rɔ bo, lïjë koꞌdɔ kono ŋgï kɔzɔ a ꞌba dɔ ŋere tara kutuꞌbö dɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kina lïjë koloma ŋgï nati tumötö bo kiya te, “Mötö zïyï ŋere bɔ dɔliŋɔ ꞌba Yudayi.” ");
INSERT INTO bex_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Lïjë omba dɔ bo ŋgï ti kolɔkɔ lïjë kotoꞌbi woro rɔ bo. Lïjë olɔdɔ bërï kɔmɔ bo tïlëlu bo rɔ laŋa. ");
INSERT INTO bex_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kina ɔdɔ lïjë kote tögö bo ꞌdeni rɔ laŋa tara tine, na lïjë kolɔ bɔŋgɔ kasi nima ŋgï yaga di rɔ bo, kolɔ ma ꞌba bo ma mɔlo mo kileki rɔ bo. Kina lïjë kogba bo ŋgï tari ti bo tutötï bo. ");
INSERT INTO bex_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Di gɔ kɔri yayi na dönnï kondɔsɔ ŋgï ti bɔ mɔtɔ möyï mo rɔ Simona di Kurënë, këdï kako abo mï gawo di mï nyaka. Kina lïjë kiꞌdi bo ŋgï tombi ŋgërï ꞌba tutötï Yësu. Bo na rɔ ꞌbu ꞌba Alesandoro ni ti Rupusa. ");
INSERT INTO bex_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kina lïjë kari ŋgï ti Yësu kömö timo gɔ bi kïdëkï rɔ Gɔlɔgɔta mo tönë ame ꞌjɔ ꞌba lende mo tëgë, “Kulöŋbö dɔ” ne. ");
INSERT INTO bex_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lïjë ogba layi kudölö yïmo ti wɔwɔ mɔtɔ kïdëkï rɔ murï kiꞌdi kpa bo tuwë mo, tine bo uwë dë. ");
INSERT INTO bex_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kina lïjë kutötï bo ŋgï lïjë koza bɔŋgɔ abo ga rɔ gɔ rönnï. Lïjë oloma ŋgï rɔ tuꞌdu mo ti bödö gɔ kikali ɔdɔ yë na ti kïdïlï ama ya. ");
INSERT INTO bex_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ote tutötï bo koꞌja ndï kada kömö ꞌdeni modɔmosowɔ. ");
INSERT INTO bex_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ugu susu ꞌba rɔ bo kiꞌdi tɔrɔ yayi kɔzɔ a nime te, “Ŋere Bɔ Dɔliŋɔ ꞌBa Yudayi.” ");
INSERT INTO bex_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Utötï bɔ akolɔ mɔtɔ ga gbï rïyö ꞌdo ŋgila bo yayi. Kɔtɔ dɔ dörï bo tine ma kɔtɔ dɔ gali bo. ");
INSERT INTO bex_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bilaka ame ga pili këdï kudö kebe yayi ne ombamba dɔ zi bo kose dɔ bo kiya te, “Nï bɔ kiteri titikɔ rö löbu ꞌba Bɔkoꞌba gɔ kubö kileki gɔ bi mo mï töꞌdö dɔ mota tönë, nï na? ");
INSERT INTO bex_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ee, olɔ röyï këkï bërï di dɔ ŋgërï nima te.” ");
INSERT INTO bex_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɔ dɔ bɔ akumu ni ti bɔ kɔmɔ kiyandi ni oloma gbï rɔ tose dɔ bo, kiya te, “Bo ɔmɔ ya ma laki di mï tölë tine bo ikali dë tɔmɔ rɔ bo. ");
INSERT INTO bex_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iꞌdike Kurïsïtö ŋere bɔ dɔliŋɔ ꞌba Yudayi këkï ti bërï gïrï nime di dɔ ŋgërï nima, doꞌja ti kɔmɔze gɔ diꞌdi dɔze ti nati gɔ lende abo.” Ya ma kutötï ŋgila bo yayi naga nima ebe gbï kitiꞌja bo. ");
INSERT INTO bex_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mï zana kada kodɔrɔ ꞌdeni tine na mandölu kutuꞌbö gɔ bi ŋgï ŋbö kömö kɔzɔ saa mota tara. ");
INSERT INTO bex_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kina ɔdɔ ndï kada kömö ꞌdeni mota tine na Yësu kapi ŋgï rɔ ma kembe, tëgë, “Eloyi, Eloyi, lama sabakatani.” Ame ꞌjɔ ꞌba lende mo tëgë, “Bɔkoꞌba ma, Bɔkoꞌba ma, ola ma ꞌdeni ŋgï gɔ waꞌdi ga?” ");
INSERT INTO bex_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ya ma këdï kɔrɔ yayi mo naga nima uwö, lïjë iya te, “Bo ëdï kïdëkï Eliya.” ");
INSERT INTO bex_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kina bɔ mɔtɔ kiriŋa ŋgï kogba lipɔ kusu mï layi koꞌbaꞌba, kiraki dɔ kolɔkɔ kiꞌdi kpa bo tuwë mo, kiya te, “Ti doŋgɔke ɔdɔ Eliya ti kako kombi bo bërï di bina ya?” ");
INSERT INTO bex_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yësu api ŋgï rɔ ma kembe, kina bo kulöku ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kina bɔŋgɔ ma koke mï rö löbu ꞌba Bɔkoꞌba timo tönë kotopa ŋgï di tɔrɔ ŋbö kömö bërï. ");
INSERT INTO bex_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kina ɔdɔ bɔ dɔ bɔ kanya ma këdï kɔrɔ yayi mo nima koŋgɔ tulöku ꞌba Yësu ŋgï tara tine, bo iya te, “Rɔ ma laka bɔ nime ŋgï rɔ kole ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ꞌJa mɔtɔ ga ëdï gbï kɔrɔ rɔ ma kɔwɔ mbowa yayi këdï rɔ toŋgɔ mo. ꞌJa mɔtɔ mo ga lïjë na rɔ Mariya Magadala ni ti Salome ti Mariya ma ꞌba Yakoba ma titi ni ti Yose. ");
INSERT INTO bex_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lïjë ma tönë ga kösö gɔ bo di Galilaya koloma rɔ toja laja zi bo ne. ꞌJa ma konzi mɔtɔ ga ame kako ti bo Yerosalema ne ëdï gbï yayi. ");
INSERT INTO bex_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mï dɔkɔpiyari mo nima ame kina rɔ kada ꞌba rɔ kileŋo koda kada ꞌba rɔ kindawo ne, ");
INSERT INTO bex_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yesepa di Arimataya turu ma löbu mɔtɔ, ame bo këdï gbï ti kɔmɔ kiꞌdi gɔ ŋere löbu ꞌba Bɔkoꞌba ne, bo ënyï ŋgï ti mï këddï kari zi Pilato kititi ꞌdɔ kodɔ kpa töku Yësu zi bo tari tusu mo. ");
INSERT INTO bex_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tine ɔdɔ Pilato kuwö kiya te Yësu ölë ꞌdeni ŋgï welo tara tine, lende mo igayi bo ŋgï. Kina bo kïdëkï bɔ dɔ bɔ kanya mo nima kititi, ma Yësu kölë ꞌdeni ŋgï rɔ ma laka. ");
INSERT INTO bex_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kina ɔdɔ bo kuwö ꞌdeni di zi bɔ dɔ bɔ kanya nima, Yësu kölë ꞌdeni kina bo kodɔ kpa töku mo ŋgï zi Yesepa ꞌdɔ kombi kari kusu. ");
INSERT INTO bex_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yesepa ari ŋgï kugö bɔŋgɔ kaŋmi. Kina bo kombi töku Yësu ŋgï bërï di dɔ ŋgërï koꞌba mï bɔŋgɔ kaŋmi nima kolo yïmo, bo kari kusu mï tïꞌbörö ame koga ꞌdeni yɔki döku yayi tusu töku teyi ne. Kina bo kululu döku mo ŋgï kiꞌdi kpamo. ");
INSERT INTO bex_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tine Mariya Magadala ni ti Mariya ma ꞌba Yose ni lïjë oꞌja gɔ bi nima kusu Yësu teyi ne ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Di pötö kada ꞌba rɔ kindawo nima, na Mariya Magadala ni ti Salome ti Mariya ma ꞌba Yakoba ni kugö akato kele ŋgï tari tosa mo rɔ töku. ");
INSERT INTO bex_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kina lïjë kënyï ŋgï mɔlo mï dɔŋbɔ mo nima kari ndï dögö yayi. Lïjë ari kömö yayi gba ti kada këdï kiꞌdi kpënnï. ");
INSERT INTO bex_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Di gɔ kɔri lïjë oloma rɔ tiya mo rɔ gɔ rönnï te, “Yë na ti kululu döku mo tɔne yaga di kpamo zize?” ");
INSERT INTO bex_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tine ɔdɔ lïjë kombi kömönnï koŋgɔ tine, ululu döku löbu mo tönë ꞌdeni yaga di kpamo. ");
INSERT INTO bex_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kina ɔdɔ lïjë kari kɔdɔ yayi lïjë ari ŋgï koꞌja kole yɔbi mɔtɔ koloma ꞌdeni dɔ kapa dörï yayi ti bɔŋgɔ kaŋmi rɔ bo. Kina tikere kindaꞌba lïjë ŋgï. ");
INSERT INTO bex_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bo iya zïnnï te, “Kinza kereke dë. Yësu ꞌba Nazareta nime kutötï ne na këddï komake? Bo ɔdɔ ꞌdeni di mï tölë. Bo inza kpe bine. Oŋgɔke bi ma lïjë koꞌba bo pa teyi na me. ");
INSERT INTO bex_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ari kiyake zi bɔ kösö gɔ bo ga zi Pïtörö ni te, bo ari ꞌdeni tötï dɔgba kömönnï mï Galilaya. Kina ti lïjë kari koꞌja bo yayi kɔzɔ ma tönë bo kiya zïnnï ne.” ");
INSERT INTO bex_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kina ꞌja naga nima kɔdɔ ŋgï di mï tïꞌbörö yayi, lïjë kiriŋa ŋgï nduwë kari. Römöyï rönnï ëdï ꞌdeni ŋgï kïlëꞌdï di zi tikere. Lïjë iya lende mo dë kpe zi bɔtɔ mɔtɔ di zi tikere. ");
INSERT INTO bex_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mï tɔdɔ ꞌba Yësu di mï tölë mï töꞌdö ma dɔgba mo nima, bo ileme rɔ bo titi dɔgba zi Mariya Magadala. Lɔko na tönë bo koga nökï modɔmorïyö kitaꞌba yaga di dɔmo ne. ");
INSERT INTO bex_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kina lɔko kari kiya ŋgï zi ya ma rɔ bɔ kösö gɔ bo mo ga, ame lïjë këdï ꞌdeni ŋgï bi monɔ ne. ");
INSERT INTO bex_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lïjë uwö lɔko kiya pele te bo ɔdɔ ꞌdeni lɔko koꞌja ti kömönï nima, lïjë iꞌdi dönnï dë gɔmo. ");
INSERT INTO bex_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Di pötö mo ꞌböwu na bo kɔdɔ ŋgï kileme rɔ bo ꞌböwu ti kïnë ma ꞌberi mɔtɔ zi ya ma rïyö mɔtɔ ga di gɔ kɔri. ");
INSERT INTO bex_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ya naga nima ileki kiya zïnnï lïjë mɔtɔ mo naga nima, pele lïjë iꞌdi dönnï dë gɔmo. ");
INSERT INTO bex_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Rɔ ŋburuŋburu mo tine na bo kɔdɔ ŋgï kileme rɔ bo zïnnï lïjë ma ꞌbutë dɔɔkɔtɔ naga nima pili bi kɔtɔ, koꞌja lïjë këdï rɔ tonyo kpënnï. Bo amo dönnï gɔ ame lïjë kiꞌdi dönnï dë gɔ lende ꞌba bilaka ame ga koꞌja bo kɔdɔ ꞌdeni di mï tölë pele kiya lende mo zïnnï ne. ");
INSERT INTO bex_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bo iya zïnnï te, “Kpe arike mï dɔliŋɔ pili kuwöwöke laja laka ꞌba Bɔkoꞌba zi dɔ kupö pili. ");
INSERT INTO bex_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kina bɔtɔ ame ga kiꞌdi dönnï gɔmo kobapatisi ne ti kɔmɔ ŋgï. Tine ame ga kiꞌdi dönnï dë gɔmo ne ti kodɔ karama ŋgï dɔmo. ");
INSERT INTO bex_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma kiꞌdi dönnï ꞌdeni gɔmo mo naga ti këdï ꞌdeni ŋgï ti tigɔ. Lïjë ti koga nökï ŋgï yaga ti möyï ma. Lïjë ti kilende rɔ kpa löwö. ");
INSERT INTO bex_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Lïjë indaꞌba murë pele, kono lïjë pele, inza koꞌdɔ ɔtɔ zïnnï. Ɔdɔ lïjë kiꞌdi közïnnï rɔ bɔ rɔkɔꞌɔ ti kileŋo ŋgï.” ");
INSERT INTO bex_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kina ɔdɔ ŋere Yësu kote tilende ꞌdeni pili tïnnï kɔzɔ a nime te tine, na kogba bo ŋgï kari mïtɔrɔ, kari koloma dɔ dörï Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kina bɔ kösö gɔ bo ga kari ŋgï kuwöwö laja nime kote mï gɔ bi pili. Kina ŋere Yësu köꞌbö ŋgï tïnnï kiꞌdi tigɔ zïnnï gɔ bilaka kikali ŋgï lïjë ëdï kiya lende ma laka.");
INSERT INTO bex_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kina kɔzɔ ame ya ma konzi mɔtɔ ga kiyɔzɔ ꞌdeni tugu wa ame ga koꞌdɔ rönnï mï löŋgö ze bine ne tara ");
INSERT INTO bex_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ame ŋgï ꞌdeni kɔzɔ ma lïjë bɔ koꞌja mo ti kömönnï di bi tisaki mo ga kari kuwöwö ꞌdeni kïyëtï zize ne. ");
INSERT INTO bex_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kina kɔzɔ ame moloma ꞌdeni mɔlo rɔ tinyeli mo pili rɔ gɔmo ne, moŋgɔ ma laka mo na ꞌdeni gbï zö ꞌdɔ tugu mo miyija gɔmo zïyï, Tewopilo turu löbu, ");
INSERT INTO bex_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ꞌdɔ kiꞌdi kikali wa naga nima kiyandi yi timo ne na rɔ ma laka. ");
INSERT INTO bex_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mï kada nima Erode këdï rɔ bɔ dɔliŋɔ ꞌba Yudayi ne, bɔ mɔtɔ, möyï mo rɔ Zakariya, rɔ bɔ akumu ꞌba Bɔkoꞌba ëdï yayi. Bo di mï löŋgö bɔ akumu ame ga rɔ dɔtumu ꞌba Abiya ne. Kina ꞌja abo Alizebete gbï di mï kupö Arona. ");
INSERT INTO bex_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Lïjë kpaki rïyö rɔ bɔ lende laka kɔmɔ Bɔkoꞌba. Köꞌdu kiꞌdi ꞌba Bɔkoꞌba pili lïjë oꞌdɔ ꞌdeni koꞌbaꞌba dɔ ꞌbö mo. ");
INSERT INTO bex_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tine lïjë inza ti kole, römöyï Alizebete ɔrɔ ꞌdeni rɔ kɔtɔ. Kina lïjë kpaki rïyö öndë ga ꞌdeni ŋgï sowa. ");
INSERT INTO bex_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kina ɔdɔ kömö ꞌdeni mï kada ame ndɔbɔ ꞌba toŋma akumu kilaꞌba zi tumu ma ꞌba Zakariya ni ne tine ");
INSERT INTO bex_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bo na koza bo ŋgï gɔ dölëtï ꞌbënnï ꞌba bɔ akumu tari mï rö löbu ꞌba Bɔkoꞌba toŋma akato kele. ");
INSERT INTO bex_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tine ɔdɔ kada ꞌba toŋma mo kömö ꞌdeni bɔ mötu ma laki pili otɔŋi ꞌbënnï rönnï ŋgï yaga yayi bi mötu. ");
INSERT INTO bex_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kina malayika ꞌba Bɔkoꞌba kɔdɔ ŋgï zi bo di rö yayi kɔrɔ ŋgila bi ꞌba toŋma akato kele nima dɔ kapa mo ma dörï. ");
INSERT INTO bex_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kina ɔdɔ bo koꞌja malayika nima ꞌdeni tara tine ënyï koꞌde tikere ŋgï mï bo. ");
INSERT INTO bex_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tine malayika nima ënyï kiya zi bo, iya te, “Zakariya, kinza kere dë, akititi ꞌbï Bɔkoꞌba uwö ꞌdeni. ꞌJa ꞌbï Alizebete ti köyö kole zïyï, ꞌdɔ kiꞌdi möyï mo rɔ Yowani. ");
INSERT INTO bex_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti këddï ŋgï ꞌdeni ti mï këyï ti lɔŋɔ ma mbëmbë. Kina ma konzi mɔtɔ ga ti këdï ꞌdeni gbï rɔ lɔŋɔ gɔ töyö bo. ");
INSERT INTO bex_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bo ti këdï rɔ löbu ma dɔ kiteli di kɔmɔ Bɔkoꞌba. A mɔtɔ rɔ layi ala a ma kata naga inza kudö kpa bo. Bo ti këdï lɔ ti Nyï Kɔtɔ Laka mɔlo di bi töyö bo. ");
INSERT INTO bex_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bo ti koꞌde bilaka ꞌba Yisarele ma konzi ꞌdeni ŋgï kileki kako zi ŋere Bɔkoꞌba ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bo ti kari dɔgba kɔmɔ ŋere ti tigɔ ꞌba Nyï Kɔtɔ Laka kɔzɔ ꞌba Eliya, tileki dökïꞌdï ꞌbu ni todɔꞌbɔ mo kɔtɔ ti kole, ma kinza kuwö dɔ Bɔkoꞌba naga tuyï dökïꞌdï mo këdï rɔ bɔ lende laka, tileŋo lïjë ame ga rɔ ꞌba ŋere ne ndö koda dɔ bo.” ");
INSERT INTO bex_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tine Zakariya ënyï kileki zi malayika nima, iya te, “Ti mikali tondo? Ma na me ꞌdeni rɔ ma köndë kina ꞌja ma gbï öndë ꞌdeni sowa.” ");
INSERT INTO bex_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malayika nima iya te, “Ma na rɔ Gabërëlë. Ma na rɔ bɔ tɔrɔ kɔmɔ Bɔkoꞌba, kina me koja ma zïyï ti laja laka nime. ");
INSERT INTO bex_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lende nime ti koꞌdɔ rönï ŋgï ko tara mï kada mo yayi, ne kina me kilagi tiꞌdi döyï gɔmo, kpëyï ti kudödu rönï teyi koloma tara kinza kilende dë ŋbö kömö mï kada mo ame këdï koꞌdɔ rönï yïmo ne.” ");
INSERT INTO bex_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tine bɔ mötu ma laki ëdï ꞌbënnï kolɔꞌbɔ yaga yayi toda Zakariya ti meri, iya te, “Waꞌdi ga na koꞌdɔ rönï ꞌdeni zi bo di rö yayi kiꞌdi bo kigabi kulöwö te?” ");
INSERT INTO bex_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kina ɔdɔ bo kɔdɔ yaga tine bo ilende dë kpe gönnï. Kina lïjë kikali ŋgï bo oꞌja bikoro tɔ ne ꞌdeni di mï rö löbu ꞌba Bɔkoꞌba yayi. Römöyï bo oloma ŋgï rɔ tilende zïnnï ti közï bo, kpa bo ilende dë kpe. ");
INSERT INTO bex_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kina ɔdɔ dɔ töꞌdö ꞌba ndɔbɔ abo kote rönï ꞌdeni tine bo ileki ŋgï kari liŋɔ abo. ");
INSERT INTO bex_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Di pötö mo yɔ na ꞌja abo Alizebete kɔmɔ ŋgï. Tine lɔko öꞌbö tusu dönï rö ŋbö nyepe muyï. Lɔko oloma tiya mo te, ");
INSERT INTO bex_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Bɔkoꞌba na koꞌdɔ wa nime ꞌdeni zö. Leꞌjete bo ileme mï koŋmi abo ꞌdeni zö bo kombi rɔ kaya tönë ꞌdeni yaga di dɔma gɔ dɔma këdï ti rɔ ma kïtëwu mï löŋgö lëpï ma ga.” ");
INSERT INTO bex_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mï modɔɔkɔtɔ ꞌba nyepe ma di pötö tɔmɔ ꞌba Alizebete na Bɔkoꞌba koja malayika Gabërëlë ŋgï kari Nazareta gawo mɔtɔ ꞌba mï Galilaya. ");
INSERT INTO bex_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Oja bo kari zi nyiti mɔtɔ yayi möyï mo rɔ Mariya. Nyiti nime bɔ mɔtɔ rɔ Yesepa di mï kupö Dawidi na kïlïbö ꞌdeni ꞌdɔ togbe mo rɔ ꞌja. ");
INSERT INTO bex_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malayika nima ari kömö kiya zïnï, iya te, “Mötö zïyï nï ame ꞌdeni ti lende këyï ne. Bɔkoꞌba ëdï tïyï.” ");
INSERT INTO bex_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Lende nime oꞌde tikere ŋgï zi Mariya, lɔko iya te, “Lende waꞌdi ga na te?” ");
INSERT INTO bex_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tine malayika ilende zïnï, iya te, “Mariya, kinza kere dë. Mï Bɔkoꞌba oŋmi ꞌdeni röyï. ");
INSERT INTO bex_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ti kɔmɔ köyö kole bɔtɔni, kina ti kiꞌdi möyï mo rɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bo ti këdï rɔ löbu kina ti kïdëkï bo rɔ kole ꞌba Bɔkoꞌba tigɔ dɔ kiteli. Ŋere Bɔkoꞌba ti kiꞌdi közï kakpa ꞌba ꞌbu bo löbu Dawidi ꞌdeni ŋgï zi bo. ");
INSERT INTO bex_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kina bo ti köꞌbö rɔ bɔ dɔ kupö Yakoba rɔ ŋburuŋburu. Ŋere löbu abo ote rönï dë.” ");
INSERT INTO bex_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariya ënyï kileki zi malayika nima, iya te, “A mo nime ꞌdɔ këdï tondo, ma ama ga mikali bɔtɔni dë ne?” ");
INSERT INTO bex_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malayika nima iya te, “Nyï Kɔtɔ Laka ti kako döyï kina tigɔ ꞌba Bɔkoꞌba ame rɔ dɔ kiteli ne ti kutuꞌbö yi ꞌdeni ŋgï. Kina kole kɔtɔ laka nime këdï köyö ne ti kïdëkï ŋgï rɔ kole ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oŋgɔ Alizebete ꞌja löbu köndë wado ꞌbï tönë bilaka kiya lɔko rɔ kɔtɔ ne te, ëdï ꞌdeni ti nyepe modɔɔkɔtɔ rɔ ma kɔmɔ ꞌdɔ köyö kole. ");
INSERT INTO bex_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Römöyï a mɔtɔ inza ame toꞌdɔ mo konya dɔ Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariya ileki dɔmo, iya te, “Ma a ꞌba közï Bɔkoꞌba na. Koꞌdɔ rönï ŋgï zö kɔzɔ a nima kiya ne.” Kina malayika nima kënyï ŋgï kari di ŋgila nï yayi. ");
INSERT INTO bex_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Welo di pötö mo na Mariya kënyï ŋgï kari mï gawo mɔtɔ mï dɔyayi kuruŋgu ꞌba Yudayi. ");
INSERT INTO bex_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Lɔko ari kömö liŋɔ ꞌba Zakariya yayi kumötö Alizebete. ");
INSERT INTO bex_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kina ɔdɔ Alizebete kuwö akumötö ꞌba Mariya tine kole okpe rönï ŋgï di mïnï. Alizebete ŋgï lɔ ti Nyï Kɔtɔ Laka, ");
INSERT INTO bex_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kina lɔko kapi ŋgï rɔ ma kembe, iya te, “Nï na rɔ ꞌja ame ti yëyï laka ꞌba Bɔkoꞌba di mï löŋgö ꞌja ma laki pili. Kina kole nima këdï köyö ne ti këdï ŋgï ti yëyï laka. ");
INSERT INTO bex_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ne omaꞌjo ma ka le gɔ waꞌdi kiꞌdi ma ꞌba ŋere ma kako toŋgɔ ma? ");
INSERT INTO bex_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Römöyï tuwö ame muwö mötö koꞌdɔ ꞌbï yɔ na kole kokpe rönï ŋgï di yïmö rɔ lɔŋɔ. ");
INSERT INTO bex_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nï ame kiꞌdi döyï gɔ lende ma Bɔkoꞌba kiya zïyï koꞌdɔ rönï ŋgï tara ne, nï na ti yëyï.” ");
INSERT INTO bex_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya iya te, “Dökïꞌdï ma ïlëlu ŋere Bɔkoꞌba, ");
INSERT INTO bex_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kina dïdï ma iliya ŋgï römöyï Bɔkoꞌba ɔmɔ ma ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bo oꞌba ŋalo ma, ma bɔ laja wötï rɔ lisa abo nime ꞌdeni. Di mï tɔne nduwë kari dɔgba bilaka pili ti kïdëkï ma rɔ lɔko ame ti yëyï ne. ");
INSERT INTO bex_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Römöyï Bɔkoꞌba tigɔ dɔ kiteli oꞌdɔ lende löbu ꞌdeni zö. Möyï bo na kɔtɔ laka. ");
INSERT INTO bex_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mï koŋmi abo itaꞌba ꞌdeni koloma ti dɔ kupö ame ga pili kere bo ne nduwë rɔ ma kolɔlɔ. ");
INSERT INTO bex_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ti tigɔ abo na me bo kileme ndɔbɔ dɔ kiteli abo nime ꞌdeni. Bo ïyëyï mï bɔ dɔ kombi ni ꞌdeni kitaꞌba rɔ kɔtɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bo ogba ŋere ni ꞌdeni yaga di dɔ kïtï, tine bo ombi ya ma wötï rɔ lisa naga ꞌdeni tɔrɔ. ");
INSERT INTO bex_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bo iꞌdi tëkpë ma laka ꞌdeni zi bɔ ꞌbö ni, tine bo oga bɔ wa ni ꞌdeni kari rɔ közï sari. ");
INSERT INTO bex_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Bo okɔnyi bilaka ꞌba Yisarele bɔ laja abo ga ꞌdeni. Mï koŋmi abo bo ileme ꞌdeni zi Abarayama ti dɔ kupö mo ga rɔ ŋburuŋburu kɔzɔ ame bo kiya ꞌdeni mɔlo zi ꞌbu ze löbu mo ga ne tara.” ");
INSERT INTO bex_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya oloma koꞌdɔ kɔzɔ nyepe mota tara titi ti Alizebete yayi tine na lɔko kënyï kileki ꞌjaa ti kari liŋɔ ꞌbënnï. ");
INSERT INTO bex_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kina ɔdɔ kömö ꞌdeni mï kada ꞌba löyö ꞌba Alizebete tine na lɔko köyö ŋgï rɔ kole bɔtɔni. ");
INSERT INTO bex_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ya ma mï tïrï ti ma wado ꞌbënï ga pili uwö lëbï ꞌba mï koŋmi nima Bɔkoꞌba koꞌdɔ zïnï ne, kina lïjë ŋgï gbï pili rɔ lɔŋɔ gɔmo. ");
INSERT INTO bex_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mï töꞌdö dɔ modɔɔmota ꞌdeni na lïjë kako ŋgï toꞌdɔ dölëtï ꞌba akilele rɔ kole nima. Lïjë iteri ꞌbënnï ꞌdɔ möyï ꞌbu mo Zakariya na koyi dɔmo. ");
INSERT INTO bex_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tine ma bo ënyï kiya te, “Inza tara, iꞌdi möyï bo rɔ Yowani.” ");
INSERT INTO bex_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lïjë ënyï kileki kiya zïnï, iya te, “Möyï ma tara inza mɔlo mï kupö ye.” ");
INSERT INTO bex_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kina lïjë kilende zi ꞌbu mo ti közïnnï kititi bo gɔ lende ꞌba möyï kole nima, ɔdɔ bo ti koꞌdɔkɔ ꞌba bo ꞌdɔ kïdëkï rɔ yë. ");
INSERT INTO bex_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bo ileme ꞌdɔ koꞌde akugu wa zi bo, kina bo kugu ŋgï kiya te, “Möyï bo rɔ Yowani.” Kina lende mo kigayi bilaka naga nima ŋgï pili. ");
INSERT INTO bex_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kina ŋgï yɔ na kpa bo kope rönï ŋgï dɔndeꞌde bo kebe tilende tïlëlu Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kina tikere kindaꞌba bilaka ame ga ꞌba mï tïrï ne ŋgï pili lende mo kïyëlë rönï ŋgï kote mï dɔyayi kuruŋgu ꞌba Yudayi nima toko. ");
INSERT INTO bex_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bɔtɔ ame kuwö lende löbu nime koꞌdɔ rönï ne ŋgï ti meri mo iya te, “Kole nime ti këdï tondo ga kada mɔtɔ?” Römöyï ileme ꞌdeni ŋgï rɔ ma laka tigɔ löbu ꞌba Bɔkoꞌba ëdï dɔ kole nime. ");
INSERT INTO bex_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ꞌBu bo Zakariya ŋgï lɔ ti Nyï Kɔtɔ Laka kina bo koloma ŋgï tumë lende ꞌba Bɔkoꞌba kiya te, ");
INSERT INTO bex_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Akïlëlu këdï zi ŋere Bɔkoꞌba ꞌba Yisarele römöyï bo ako ꞌdeni kɔmɔ bilaka abo ga yaga. ");
INSERT INTO bex_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bo iꞌdi bɔ kɔnyi ma dɔ kiteli ꞌdeni zize di mï kupö bɔ laja abo Dawidi, ");
INSERT INTO bex_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kɔzɔ ame bo kiya ꞌdeni mɔlo tönë bine ti bɔ kumë lende abo ga ne. ");
INSERT INTO bex_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ame ꞌdɔ bo kɔmɔ ze di közï bɔ ya ze ga gbï di zi bɔ ndoꞌji ze ga ne. ");
INSERT INTO bex_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bo iya te bo ti kileme mï koŋmi ŋgï zi ꞌbu ze löbu ga, dɔ bo inza kudölu di gɔ lömu koro abo nime ");
INSERT INTO bex_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","bo kulömu ꞌdeni zi ꞌbu ze Abarayama ne. ");
INSERT INTO bex_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bo ulömu ꞌdeni ꞌdɔ bo kɔmɔ ze di zi bɔ ya ze ga ꞌdɔ kiꞌdi dojake laja zi bo rɔ dɔ ŋgölö kinza tikere, ");
INSERT INTO bex_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","rɔ bɔ lende laka rɔ ma kɔpɔ di kɔmɔ bo mï kada ꞌba loma ze ga pili. ");
INSERT INTO bex_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tine nï ꞌbëyï kole ma, ti kïdëkï yi rɔ bɔ kumë lende ꞌba Bɔkoꞌba tigɔ dɔ kiteli. Römöyï ti kari ꞌbëyï dɔgba kɔmɔ ŋere tileŋo kɔri teyi, ");
INSERT INTO bex_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","tiya mo zi ya ame ga rɔ ꞌba bo ne ma këdï kɔmɔ lïjë di mï tölë kola lïjë gɔ lende kënyë ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ŋere Bɔkoꞌba ze ti koꞌdɔ ŋgï ti mï këyï abo. Bo ori ze ꞌdeni ti bi kɔpɔ abo ame kiyɔpɔ bi ꞌdeni zize kɔzɔ kada ame këdï kɔdɔ rɔ mï dɔŋbɔ ne tara, ");
INSERT INTO bex_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ꞌdɔ kiyɔpɔ bi zi lïjë ame ga mï bi kölu ꞌba tölë ne, kina gbï ꞌdɔ kokɔkɔ ndïze mï kɔri ꞌba lende këyï.” ");
INSERT INTO bex_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kina kole nima kïyöbu ŋgï kɔmɔ mo kandi ꞌdeni. Tine na bo kari koloma ŋgï köꞌbö yï mökö ŋbö bo kɔdɔ ꞌjaa yaga bi kɔpɔ zi bilaka ꞌba Yisarele ");
INSERT INTO bex_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mï kada mo naga nima yayi na Kayisara Agusïtö, bɔ dɔliŋɔ ma löbu ꞌba Romo, kiꞌdi lende ŋgï ꞌdɔ tugu möyï bilaka ꞌba mï dɔyayi abo ga pili. ");
INSERT INTO bex_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ame na rɔ möyï kugu ma dɔgba ame koꞌdɔ rönï mï kada nima Kurïnö këdï rɔ turu bɔ dɔliŋɔ ꞌba Surïya ne. ");
INSERT INTO bex_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kina bilaka pili mɔtɔ ari ŋgï mï gawo ꞌbe tugu möyï yï. ");
INSERT INTO bex_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kina Yesepa kënyï ŋgï gbï di Nazareta di mï Galilaya kari Beteleme gawo ꞌba ꞌbu bo löbu Dawidi bɔ dɔliŋɔ mï dɔyayi ꞌba Yudayi römöyï bo di mï kupö Dawidi. ");
INSERT INTO bex_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Lïjë ari ti Mariya mo tönë kïlïbö ꞌdeni zi bo rɔ ꞌja ne. Tine lɔko ꞌdeni rɔ ma kindasi. ");
INSERT INTO bex_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Koꞌja lïjë këdï ꞌdeni yayi yɔ na kada ꞌba löyö ꞌbënï kömö ŋgï zïnï. ");
INSERT INTO bex_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kina lɔko köyö kole dɔndende ꞌbënï ŋgï rɔ bɔtɔni. Kina lɔko kolo ŋgï mï bɔŋgɔ lɔko koꞌba mï bi ꞌba tonyo akonyo ꞌba yërï römöyï gɔ bi inza kpe zïnnï mï rö ꞌba ŋba. ");
INSERT INTO bex_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mï dɔyayi nima yayi bɔ koda kamölö mɔtɔ ga ëdï ꞌbënnï yï mökö toŋgɔ gɔ kamölö ꞌbënnï ga rɔ mï korɔndɔ. ");
INSERT INTO bex_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malayika ꞌba Bɔkoꞌba ako kɔdɔ zïnnï na bi kɔpɔ ꞌba Bɔkoꞌba kiyɔpɔ bi ŋgï lëwu yaga di rönnï. Kina lïjë ŋgï rɔ tikere rɔ ma kënyë. ");
INSERT INTO bex_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tine malayika nima ënyï kilende zïnnï, iya te, “Kinza kereke dë. Laja laka ꞌba lɔŋɔ löbu nime këdï kako zi bilaka pili ne na moꞌde ziye. ");
INSERT INTO bex_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mï kada nime tɔne öyö bɔ kɔnyi ꞌdeni ziye mï gawo ꞌba Dawidi. Bo na rɔ Kurïsïtö ŋere ze bɔ kɔnyi mo tönë këdï koja kako di mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ame na rɔ akileme mo ꞌdɔ kikalike ŋgï lende ma nime ëdï rɔ ma laka. Ti kari koꞌjake kole kuru kolo ꞌdeni mï bɔŋgɔ koꞌba ꞌdeni mï bi ꞌba akonyo ꞌba yërï.” ");
INSERT INTO bex_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kina ŋgï yɔ na tïndï ꞌba malayika ma konzi ꞌba mïtɔrɔ kɔdɔ ŋgï ŋgila malayika ma tönë yayi tïlëlu Bɔkoꞌba, iya te, ");
INSERT INTO bex_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Rɔ löbu këdï ŋbö zi Bɔkoꞌba mïtɔrɔ. Mï dɔyayi bërï bine lende këyï ëdï ꞌdeni zi lïjë ame ga mï bo koŋmi rɔmo ne.” ");
INSERT INTO bex_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kina ɔdɔ malayika naga nima kënyï ꞌdeni di rönnï yayi kileki kari mïtɔrɔ tine bɔ koda kamölö naga nima ënyï kiya rɔ gɔ rönnï, iya te, “Darike te Beteleme toŋgɔ ɔtɔ nime koꞌdɔ rönï ŋere Bɔkoꞌba kiya lende mo zize ne.” ");
INSERT INTO bex_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kina lïjë kënyï ŋgï dɔmo rɔ rikamba tari Beteleme. Tine lïjë ari koꞌja Mariya ni ti Yesepa ŋgï yayi ti kole kuru köꞌdö ꞌdeni mï bi ꞌba tonyo akonyo ꞌba yërï. ");
INSERT INTO bex_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kina ɔdɔ lïjë koꞌja bo ꞌdeni tara tine na lïjë kebe ŋgï nati tïyëtï gɔ lende ame ga malayika kiya zïnnï gɔ köꞌdu ꞌba kole nima ne. ");
INSERT INTO bex_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kina ya ame ga pili kuwö lende kiya ꞌba bɔ koda kamölö naga nima ne kotɔ ŋgï rɔ gönnï. ");
INSERT INTO bex_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tine Mariya indaꞌba ꞌbënï lende naga nima ŋgï kikeki köꞌbö mïnï. ");
INSERT INTO bex_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bɔ koda kamölö tönë ga uyï dönnï ŋgï rɔ lɔŋɔ ti tïlëlu Bɔkoꞌba gɔ wa ame ga pili lïjë kuwö koꞌja gbï ŋgï te kɔzɔ ma kiya rönï zïnnï tara ne. ");
INSERT INTO bex_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kina ɔdɔ kömö ꞌdeni mï töꞌdö dɔ modɔɔmota ꞌba kole nime ꞌdɔ toꞌdɔ dölëtï ꞌba akilele rɔmo tine oyi möyï mo ŋgï rɔ Yësu, möyï mɔlo tönë malayika kiꞌdi dɔ bo gba kinza kɔmɔ bo dë ne. ");
INSERT INTO bex_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kina ɔdɔ kada ꞌba toꞌdɔ dölëtï ꞌbënnï mï rö löbu ꞌba Bɔkoꞌba kɔzɔ gɔ köꞌdu kiꞌdi mo ame Musa kugu ne kömö ꞌdeni tine Yesepa ni ti Mariya oto kole nima ŋgï kari Yerosalema ꞌdɔ kulömu zi Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Lïjë oꞌdɔ kɔzɔ ame kugu ꞌdeni mɔlo mï köꞌdu kiꞌdi ꞌba Bɔkoꞌba, kiya te, “Kole bɔtɔni ame ga pili rɔ dɔndende ne kulömu zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kina gbï lïjë ari ti kole matukpuru rïyö ꞌdɔ toŋma mo rɔ akumu zi Bɔkoꞌba kɔzɔ ame köꞌdu kiꞌdi mo kiya ne. ");
INSERT INTO bex_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tine bɔ mɔtɔ kïdëkï möyï mo rɔ Simona ëdï Yerosalema yayi rɔ bɔ lende laka bɔ koro köꞌdu kiꞌdi ꞌba Bɔkoꞌba pili. Nyï Kɔtɔ Laka ëdï dɔ bo, bo köꞌbö ti kɔmɔ kiꞌdi gɔ kɔnyi ꞌba Bɔkoꞌba zi Yisarele. ");
INSERT INTO bex_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kina Nyï Kɔtɔ Laka ileme ꞌdeni mɔlo zi bo, bo inza kinene a mɔtɔ rɔ tölë titi du tine ꞌjaa ŋbö ɔdɔ bo koꞌja Kurïsïtö mo nime Bɔkoꞌba këdï koja zïnnï ne ꞌdeni ŋgï du titi. ");
INSERT INTO bex_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mï kada mo nima na Nyï Kɔtɔ Laka kiꞌdi bo ŋgï kari mï reki ꞌba rö löbu ꞌba Bɔkoꞌba. Kina ɔdɔ ꞌbu ꞌba Yësu ni ti ma bo Mariya koꞌde bo ꞌdeni kako mï rö löbu ꞌba Bɔkoꞌba ꞌdɔ toꞌdɔ wa ame ga köꞌdu kiꞌdi koꞌdɔkɔ ne rɔ bo tine ");
INSERT INTO bex_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simona ombi bo ŋgï közï bo kïlëlu Bɔkoꞌba, iya te, ");
INSERT INTO bex_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ŋere ma, iꞌdi bɔ laja ꞌbï ꞌdeni ꞌdɔ kari abo nati liya ti mï këyï kɔzɔ köꞌdu ꞌbï tara. ");
INSERT INTO bex_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Römöyï kɔnyi ꞌbï moꞌja ꞌdeni ti kɔmɔ ma ");
INSERT INTO bex_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ame kileŋo ꞌdeni ꞌdɔ kɔmɔ bilaka ꞌba dɔliŋɔ pili koꞌja ne, ");
INSERT INTO bex_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","bi kɔpɔ ma ꞌdɔ kileme lende ꞌbï zi bɔ löwö gbï ti rɔ löbu ꞌba bilaka ꞌbï ga Yisarele.” ");
INSERT INTO bex_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tine ꞌbu ꞌba kole nima ti ma mo otɔ ŋgï rɔ gönnï gɔ lende nima kiya rönï tara rɔ kole nima ne. ");
INSERT INTO bex_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simona oꞌdɔ yëyï ŋgï dönnï. Tine bo ileki kiya zi Mariya, bo iya te, “Kole nime iꞌdi ꞌdeni ꞌdɔ ma konzi di mï Yisarele kolɔkpɔ yaga timo kina ꞌdɔ ma konzi mɔtɔ ga kaya yaga timo. Bo na ti këdï rɔ akileme ma kako di zi Bɔkoꞌba gɔ bilaka kiya kpënnï rɔmo. ");
INSERT INTO bex_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Meri ame ga rɔ ma kusu mï dökïꞌdï ma konzi ne ti kileme ꞌdeni yaga. Ne nï, dökïꞌdï yï ti kulörö ꞌdeni ti meri.” ");
INSERT INTO bex_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ꞌJa mɔtɔ möyï mo rɔ Ana nyiti ꞌba Panuwëlë di mï kupö Asera rɔ bɔ kumë lende ꞌba Bɔkoꞌba ëdï gbï yayi. Lɔko öndë ꞌdeni. Pa mɔlo dɔ yïtö ꞌbënï ogbe lɔko koꞌdɔ ŋge kɔmɔ kɔɔ modɔmorïyö ti mëꞌdë nï yɔ na mëꞌdë nï kölë ŋgï. ");
INSERT INTO bex_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kina me lɔko oꞌdɔ ꞌdeni ŋbö kɔmɔ kɔɔ kuluku kɔtɔ kɔdɔ dɔmo ꞌbutë mota dɔmosowɔ (84) rɔ makuruꞌbë. Tine na lɔko köꞌbö ꞌbënï ŋgï ŋburu mï rö löbu ꞌba Bɔkoꞌba. Lɔko öꞌbö ŋgï yayi kote kada kote korɔndɔ toja laja zi Bɔkoꞌba toro kpënï gbï tumötu. ");
INSERT INTO bex_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lɔko ömö dɔ Yesepa ni mï saa nima na lɔko koꞌdɔ yëë ma ŋgï zi Bɔkoꞌba. Kina lɔko koloma ŋgï tiya lende ꞌba kole nima zi lïjë ame ga pili këdï ti kɔmɔ kiꞌdi mo ma gɔ Bɔkoꞌba kɔmɔ bilaka ꞌba Yisarele di mï tölë ne. ");
INSERT INTO bex_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kina ɔdɔ Mariya ni ti Yesepa kote toꞌdɔ dölëtï ꞌba rɔ kole nima ꞌdeni gɔ köꞌdu kiꞌdi ꞌba Bɔkoꞌba mo tine na lïjë kileki ŋgï kari Galilaya mï gawo ꞌbënnï Nazareta. ");
INSERT INTO bex_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kina kole tönë kïyöbu ŋgï di yayi kɔmɔ mo kandi yaga. Tine bo ŋgï lɔ ti akikali, yëyï ꞌba Bɔkoꞌba ëdï dɔ bo. ");
INSERT INTO bex_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Rɔ gɔ kɔmɔ kɔɔ pili ꞌbu bo ni öꞌbö nduwë tari Yerosalema mï karama ꞌba Pasaka. ");
INSERT INTO bex_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kina ɔdɔ kɔmɔ kɔɔ abo këdï ꞌdeni ꞌbutë dɔmorïyö tine na lïjë kënyï ŋgï gbï kari mï karama nima kɔzɔ ma mɔlo tara. ");
INSERT INTO bex_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tine koꞌja karama kote rönï ꞌdeni ꞌbu bo ni ti ma bo këdï kileki kari liŋɔ na kole mo tönë rɔ Yësu ne kileke ŋgï mï Yerosalema yayi. Tine ꞌbu bo ni ti ma bo ikali ga gɔmo dë. ");
INSERT INTO bex_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lïjë omeri ꞌbënnï tëgë mɔtɔga bo ti këdï mï löŋgö bilaka konzi naga nima këdï kari kɔtɔ tïnnï ne. Lïjë iliŋgere ꞌdeni ŋbö kada kösö, na lïjë kiꞌdi ŋgï nati toma gɔ bo kebe zi ma wado ꞌbënnï ga ti bɔ pɔri nnï ga. ");
INSERT INTO bex_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kina ɔdɔ lïjë koꞌja bo dë tine lïjë uyï dönnï ŋgï kileki toma bo di Yerosalema. ");
INSERT INTO bex_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mï töꞌdö dɔ mota ꞌdeni tine na lïjë kari koꞌja bo mï reki ꞌba rö löbu ꞌba Bɔkoꞌba bo koloma ꞌdeni mï löŋgö bɔ kɔmɔ kiyandi ni tuwö lende ꞌbënnï ga gbï tititi lïjë. ");
INSERT INTO bex_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Akikali abo ti dɔ lende kileki abo igayi ya ame ga pili koloma rɔ tuwö mo ne ŋgï. ");
INSERT INTO bex_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kina ɔdɔ ꞌbu bo ni ti ma bo koꞌja bo ꞌdeni tara tine lïjë otɔ ŋgï rɔ gönnï. Kina ma bo kënyï kilende zi bo, iya te, “Kole ma, oꞌdɔ ze te gɔ waꞌdi? Ze ŋgï rɔ meri sowa ti ꞌbu yï, dëdï toma göyï.” ");
INSERT INTO bex_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Bo ileki dɔmo zïnnï, iya te, “Ëddï komake ma rɔ toma gɔ waꞌdi? Ikalike dë ma ꞌdɔ mëdï mï rö ꞌba ꞌbu ma?” ");
INSERT INTO bex_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tine lende nima bo këdï kiya zïnnï ne lïjë ikali ꞌjɔ mo dë. ");
INSERT INTO bex_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kina bo kënyï ŋgï kari tïnnï Nazareta, bo koloma kuwö dönnï. Tine ma bo ikeki ꞌbënï wa tönë ga ŋgï köꞌbö mïnï. ");
INSERT INTO bex_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kina Yësu kïyöbu ŋgï ti akikali kpaki ti mï këyï ꞌba Bɔkoꞌba gbï ti ꞌba bilaka lesi. ");
INSERT INTO bex_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mï kada ma Tiberiya koꞌdɔ ꞌdeni kɔmɔ kɔɔ ꞌbutë döömu dɔ kïtï rɔ bɔ dɔliŋɔ ma löbu ꞌba Romo, Pɔnitiyo Pilato na rɔ turu ꞌba dɔ Yudayi. Erode na ꞌba bo rɔ ŋere ꞌba Galilaya kina bɔ löndö bo Pïlïpö na rɔ ŋere ꞌba Ituriya ni ti Turakoniti, kina Lusaniya na rɔ ŋere ꞌba Abilene, ");
INSERT INTO bex_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","tine Ana ni ti Kayapa na rɔ bɔ dɔ bɔ akumu. Mï kada mo naga nima na Bɔkoꞌba kiꞌdi lende abo ŋgï zi Yowani kole ꞌba Zakariya di yï mökö. ");
INSERT INTO bex_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na bo kilaki ŋgï pili kote mï dɔyayi ame ga kpa yöpö ꞌba Yaradene yayi ne toko tuwöwö laja ꞌba bapatisi ꞌba dɔ kotɔ gɔ Bɔkoꞌba kola wa gɔ lende kënyë. ");
INSERT INTO bex_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ëdï ꞌdeni kɔzɔ lende ma tönë kugu mï buku ꞌba Yesaya bɔ kumë lende ꞌba Bɔkoꞌba ne tara, ame kiya te, “Bɔ mɔtɔ ëdï kuwöwö dɔ bo di yï mökö kiya te, ‘Ileŋoke kɔri zi ŋere. Odɔrɔke gɔ kɔri zi bo. ");
INSERT INTO bex_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gbögbö pili kïdïrï teyi. Kuruŋgu ni ti döku ni koga dɔmo me koriya yaga. Kɔri ma kaŋgo naga kodɔrɔ gɔmo yaga. Kɔri ma kinyawo naga koꞌdɔ gɔmo kopiyari yaga. ");
INSERT INTO bex_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kina bilaka lesi pili ti koꞌja kɔnyi ꞌdeni ŋgï di zi Bɔkoꞌba.’” ");
INSERT INTO bex_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yowani oloma rɔ tilende zi tïndï naga nima këdï kako zi bo mï bapatisi ne, bo iya te, “Kpe kole ꞌba murë naga nime, yë na kuꞌbölu ye tiriŋa di kpa ya löbu ꞌba Bɔkoꞌba nime këdï kako dɔye ne? ");
INSERT INTO bex_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Oꞌdɔke wa ame rɔ ꞌba dɔ kotɔ di mï lende kënyë ne. Kinza kebeke dë tiya mo te, ‘Abarayama na rɔ ꞌbu ze.’ Oꞌdɔ ɔtɔ dë römöyï rɔ ma laka miya ziye, Bɔkoꞌba ti kikali toꞌdɔ kulugbï döku naga nime rɔ kole zi Abarayama. ");
INSERT INTO bex_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Oŋgɔke, goroŋa ëdï ꞌdeni ndö ndï ŋgërï. Ŋgërï ame ga kana a ma laka dë ne ti koga bërï kuꞌdu mï paꞌdo.” ");
INSERT INTO bex_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bilaka naga nima ënyï kititi bo, iya te, “Ne waꞌdi na gɔ doꞌdɔ nati?” ");
INSERT INTO bex_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yowani ileki dɔmo zïnnï, iya te, “Bɔ ame këdï ti bɔŋgɔ kolɔ rɔ rïyö kogba mɔtɔ kɔtɔ kokɔnyi bɔ ame kinza du ti ɔtɔ ne timo. Kina ꞌdɔ bɔ ame këdï ti akonyo ne koꞌdɔ gbï tara.” ");
INSERT INTO bex_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ya mɔtɔ ga ame rɔ bɔ kireke awada ni ako gbï zi bo mï bapatisi. Kina lïjë kititi bo gbï, iya te, “Bɔ kɔmɔ kiyandi, waꞌdi ga na gɔ doꞌdɔ?” ");
INSERT INTO bex_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Bo iya te, “Kinza kogba dë kebe dɔ ame kose zïyï ne.” ");
INSERT INTO bex_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bɔ kanya mɔtɔ ga ako kititi bo, iya te, “Ne waꞌdi ga na gɔ doꞌdɔ ꞌbeze?” Bo iya te, “Kinza kolɔ a ꞌba bɔtɔ dë. Kina kinza kunzö bëtï dë kpa bɔtɔ gɔ kopi wa zïyï. Bi gomɔ ꞌba röyï ma këdï kopi zïyï iꞌdi lende mo kɔꞌbɔ yi.” ");
INSERT INTO bex_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bilaka ŋgï mï kada naga nima yayi pili ti kɔmɔ kiꞌdi gbï ti meri mo iya te mɔtɔga Yowani na ti këdï rɔ Kurïsïtö mo tönë Bɔkoꞌba këdï koja ne ɔtɔ. ");
INSERT INTO bex_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tine Yowani ënyï kileki dɔmo zïnnï pili rɔ gönnï, iya te, “Mëdï moꞌdɔ ꞌbama bapatisi ŋge dɔye ti mini. Tine bɔ mɔtɔ ma ti tigɔ dɔ kiteli kebe ma ti kako ꞌdeni. Ma pele mɔꞌbɔ dë tope kpa kabi ꞌba wari abo. Bo ti koꞌdɔ bapatisi dɔye ti Nyï Kɔtɔ Laka gbï ti paꞌdo. ");
INSERT INTO bex_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kïzërï abo ëdï közï bo. Bo ti kona di mï dɔkandilere abo bo kubö nyönyu ma laka mo kiꞌdi mï mata. Tine turu mo bo ti koŋma yaga ti paꞌdo ame köꞌbö ŋgï kinza kölu dë ne.” ");
INSERT INTO bex_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yowani uwöwö laja laka zi bilaka naga nima ti kɔri ꞌba lende ma konzi. ");
INSERT INTO bex_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Tine ꞌdeni kɔwɔ yayi ɔdɔ Yowani kebe tileki lende zi ŋere Erode gɔ lende ꞌba Erodiya ꞌja ꞌba löndö bo, gbï gɔ lende kënyë ma konzi mɔtɔ ga ame bo këdï koꞌdɔ ne tine, bo odɔꞌbɔ ndïmo ŋgï ti lende kënyë abo nima na bo kuꞌdu Yowani ŋgï mï maboso. ");
INSERT INTO bex_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mï kada ꞌba bapatisi nima Yowani koloma rɔ toꞌdɔ mo dɔ bilaka konzi naga nima ne na kobapatisi Yësu ŋgï gbï. Kina koꞌja Yësu këdï kumötu yɔ na mïtɔrɔ kurögö rönï ŋgï yaga rɔ gböŋö. ");
INSERT INTO bex_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kina Nyï Kɔtɔ Laka kɔkɔ ŋgï kako dɔ bo kïnë mo kɔzɔ kïnë matukpuru tara. Kina birɔ kudu ŋgï di mïtɔrɔ, iya te, “Nï na rɔ kole ma. Mɔꞌɔ yi ꞌdeni kulöwö. Ma ti mï këyï rɔ mbëmbë gɔ lende ꞌbï.” ");
INSERT INTO bex_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mï kada nima Yësu kisaki ndɔbɔ ꞌba laja laka ne kɔmɔ kɔɔ abo ëdï ꞌdeni ꞌbutë mota. Kɔzɔ ma bilaka komeri bo rɔ kole ꞌba Yesepa kole ꞌba Eli ");
INSERT INTO bex_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","kole ꞌba Matata kole ꞌba Lëwë kole ꞌba Maleki kole ꞌba Yanayi kole ꞌba Yesepa ");
INSERT INTO bex_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","kole ꞌba Matatiyo kole ꞌba Amosa kole ꞌba Numa kole ꞌba Esili kole ꞌba Nagayi ");
INSERT INTO bex_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","kole ꞌba Mata kole ꞌba Matatiyo kole ꞌba Semayini kole ꞌba Yoseke kole ꞌba Yoda ");
INSERT INTO bex_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","kole ꞌba Yowanana kole ꞌba Resa kole ꞌba Zerobabele kole ꞌba Salatele kole ꞌba Neri ");
INSERT INTO bex_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","kole ꞌba Maleki kole ꞌba Adi kole ꞌba Kosama kole ꞌba Elimada kole ꞌba Ere ");
INSERT INTO bex_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","kole ꞌba Yësuwa kole ꞌba Elizara kole ꞌba Yorima kole ꞌba Matata kole ꞌba Lëwë ");
INSERT INTO bex_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","kole ꞌba Simona kole ꞌba Yuda kole ꞌba Yesepa kole ꞌba Yonama kole ꞌba Elekima ");
INSERT INTO bex_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","kole ꞌba Meliya kole ꞌba Mena kole ꞌba Matata kole ꞌba Natana kole ꞌba Dawidi ");
INSERT INTO bex_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","kole ꞌba Yisayi kole ꞌba Obede kole ꞌba Bowaza kole ꞌba Salamono kole ꞌba Nasona ");
INSERT INTO bex_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","kole ꞌba Aminadaba kole ꞌba Rami kole ꞌba Ezerona kole ꞌba Pereze kole ꞌba Yuda ");
INSERT INTO bex_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","kole ꞌba Yakoba kole ꞌba Yisika kole ꞌba Abarayama kole ꞌba Tera kole ꞌba Nawura ");
INSERT INTO bex_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","kole ꞌba Seruga kole ꞌba Ru kole ꞌba Pelege kole ꞌba Ebere kole ꞌba Sela ");
INSERT INTO bex_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","kole ꞌba Kayinana kole ꞌba Arupakasada kole ꞌba Seme kole ꞌba Nowa kole ꞌba Lemeke ");
INSERT INTO bex_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","kole ꞌba Metosela kole ꞌba Enoka kole ꞌba Yarada kole ꞌba Makalele kole ꞌba Kayinana ");
INSERT INTO bex_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kole ꞌba Enosa kole ꞌba Sete kole ꞌba Adama ma rɔ kole ꞌba Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mï kada nima Yësu kileki kako di kpa Yaradene ne bo ŋgï lɔ ti Nyï Kɔtɔ Laka. Kina Nyï Kɔtɔ Laka koto bo ŋgï kari yï mökö ");
INSERT INTO bex_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","na Satani koloma ŋgï rɔ tiyɔzɔ bo töꞌdö mo ŋbö dɔ ꞌbutë sowɔ. Bo koloma ŋgï tara kinza tonyo ɔtɔ. Kina rɔ ŋburuŋburu mo tine bo ꞌdeni rɔ ꞌbö. ");
INSERT INTO bex_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kina Satani kako ŋgï kilende zi bo, iya te, “Ɔdɔ këddï ŋgï rɔ kole ꞌba Bɔkoꞌba ilende zi kulugbï döku nime kuyï rönï rɔ maŋgolɔꞌbɔ.” ");
INSERT INTO bex_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tine bo ileki dɔmo, iya te, “Ugu ꞌdeni mï buku ꞌba Bɔkoꞌba iya te, ‘Bilaka oloma dë ŋge kɔtɔ gɔ akonyo.’” ");
INSERT INTO bex_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satani oto bo kari kileme dɔliŋɔ nime pili toko zi bo ");
INSERT INTO bex_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","kilende zi bo, iya te, “Ti miꞌdi közï kakpa mo ti amo ga ŋgï zïyï römöyï ama ga na. Iꞌdi ꞌdeni zö kina ti miꞌdi zi bɔtɔ ame moꞌdɔkɔ tiꞌdi mo teyi ne. ");
INSERT INTO bex_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kina me ɔdɔ kumötu ma wa naga nime pili ti këdï rɔ ëꞌbï.” ");
INSERT INTO bex_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bo ileki dɔmo iya te, “Ugu ꞌdeni mï buku ꞌba Bɔkoꞌba iya te, ‘Ŋere Bɔkoꞌba ꞌbï na ŋge kɔtɔ ꞌdɔ kumötu kulömu kpëyï teyi.’ “ ");
INSERT INTO bex_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kina Satani koto bo ꞌböwu kari Yerosalema kiꞌdi bo kɔrɔ ŋbö tɔrɔ dɔ kumu rö löbu ꞌba Bɔkoꞌba, kina kilende zi bo iya te, “Ɔdɔ këddï ŋgï rɔ kole ꞌba Bɔkoꞌba ola röyï bërï di bine. ");
INSERT INTO bex_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Römöyï ugu ꞌdeni mï buku ꞌba Bɔkoꞌba iya te, ‘Bo ti kiꞌdi köꞌdu ꞌbï zi malayika abo ga ꞌdɔ koda bi laka di röyï.’ ");
INSERT INTO bex_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kina ugu ꞌdeni gbï iya te, ‘Lïjë ti kako kikapo yi ŋgï tɔrɔ dɔ közïnnï kinza koga ndïyï ra yɔki döku.’” ");
INSERT INTO bex_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bo ileki dɔmo iya te, “Iya ꞌdeni te, ‘Kinza kiyɔzɔ ŋere Bɔkoꞌba ꞌbï dë.’” ");
INSERT INTO bex_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tine ɔdɔ Satani kote tiyɔzɔ Yësu ꞌdeni kɔzɔ a nime te tine bo ola Yësu ŋgï tötï tara nati. ");
INSERT INTO bex_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kina Yësu kileki ŋgï kari Galilaya lɔ ti Nyï Kɔtɔ Laka na lëbï abo kïyëlë rönï ŋgï kote mï dɔyayi nima toko. ");
INSERT INTO bex_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bo oloma tiyandi wa di mï rö ꞌba mötu ꞌbënnï ga kina ma konzi kïlëlu bo ŋgï. ");
INSERT INTO bex_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na bo kari ŋgï Nazareta gawo ma tönë kulu bo yïmo ne. Mï kada ꞌba rɔ kindawo na bo kari ŋgï mï rö ꞌba mötu kɔzɔ ndɔbɔ abo ga nduwë tara. Bo ënyï tɔrɔ tïdëkï wa ");
INSERT INTO bex_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","na kogba buku ꞌba Yesaya bɔ kumë lende ŋgï kiꞌdi zi bo. Na bo kitenye ŋgï koꞌja bi ma tönë kugu kiya te, ");
INSERT INTO bex_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nyï Kɔtɔ Laka ꞌba Bɔkoꞌba ëdï dɔma römöyï bo ondi ꞌdeni zö tuwöwö laja kɔtɔ laka zi bɔ lisa ni. Bo oja ma ꞌdeni tiꞌdi dɔ ŋgölö zi bɔ mï maboso ni, kina gbï tiyɔpɔ kɔmɔ bɔ kɔmɔ kölu ni tope ya ma këdï kokɔ rönnï di zi kpɔŋi naga yaga rɔ dɔ ŋgölö ");
INSERT INTO bex_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kina gbï tuwöwö kɔɔ ꞌba mï koŋmi ꞌba ŋere Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kina bo kuköku mï buku mo nima ŋgï teyi bo kileki kiꞌdi zi lëwï mo na bo koloma ŋgï bërï tiyandi wa. Kina bilaka pili ꞌba mï rö ꞌba mötu yayi kodɔ kömönnï ŋgï dɔ bo. ");
INSERT INTO bex_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kina bo kileki kiya zïnnï, iya te, “Wa nime kugu bine ne na me koꞌdɔ rönï ꞌdeni tɔne kuwöke.” ");
INSERT INTO bex_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lïjë pili oloma ŋgï rɔ tiya lende abo rɔ ma laka, lende koŋmi ame ga këdï kɔdɔ di kpa bo ne iꞌdi lïjë ŋgï kotɔ rɔ gönnï. Lïjë ebe tititi rönnï, iya te, “Tara ne, ɔdɔ bo na dë rɔ kole ꞌba Yesepa mo tönë ya?” ");
INSERT INTO bex_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yësu ileki dɔmo zïnnï, iya te, “Rɔ ma laka ti koꞌdeke lende ꞌba mumë nime rɔma, ame kiya te, ‘Bɔ wɔwɔ, ileŋo gbagba yï. Wa ame ga duwö koloma rɔ toꞌdɔ mo Kaparanoma ne oꞌdɔ gbï mï dɔyayi ma ꞌbëyï bine.’” ");
INSERT INTO bex_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bo ileki gbï kiya zïnnï te, “Rɔ ma laka miya ziye, bilaka ame rɔ bɔ kumë lende ne ya ëꞌbënnï ga oloma dë toro mo. ");
INSERT INTO bex_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Rɔ ma laka miya ziye, mï kada ꞌba Eliya makuruꞌbë ëdï ŋgï ŋbaŋi mï Yisarele. Ne mï kada ame kora kɔmɔ pɔli teyi koꞌdɔ ŋbö kɔmɔ kɔɔ mota kɔdɔ dɔmo nyepe modɔɔkɔtɔ kinza tɔrɔ kaꞌdi dë sëyï ꞌba ꞌbö kilaꞌba mï dɔyayi nima pili ne, ");
INSERT INTO bex_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pele tara oja Eliya dë kari zi makuruꞌbë ꞌba Yisarele tine ŋge zi makuruꞌbë mɔtɔ ame rɔ bɔ löwö këdï koloma Zarepata mï dɔyayi ꞌba Sidona ne. ");
INSERT INTO bex_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kina gbï tara mï kada ꞌba Elisa bɔ kumë lende bɔ mönyu ëdï ŋgï ŋbaŋi mï dɔyayi ꞌbënnï ꞌba Yisarele tine pele tara ileŋo ma kɔtɔ mɔtɔ te dë di mï löŋgö mo. Namana ŋbö rɔ bɔ löwö di Surïya na ŋge Elisa kileŋo.” ");
INSERT INTO bex_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kina ɔdɔ bilaka naga nima mï rö ꞌba mötu yayi ne kuwö lende naga nime bo kiya ne ꞌdeni tine, mïnnï ënyï ŋgï pili kata rɔ bo. ");
INSERT INTO bex_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kina lïjë kënyï ŋgï tïtïŋï bo yaga di mï gawo. Lïjë koto bo ŋgï kari bi kulïŋï ꞌba döku nima ti gawo nima dɔmo ne ꞌdɔ tïtïŋï bo bërï di bi kulïŋï nima. ");
INSERT INTO bex_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tine bo olo abo rɔ bo ŋgï di mï löŋgö tïndï naga nima bo kari abo ŋgï nduwë yaga. ");
INSERT INTO bex_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na bo kari ŋgï Kaparanoma gawo mɔtɔ gbï mï Galilaya yayi. Mï kada ꞌba rɔ kindawo na bo kiꞌdi ŋgï tiyandi bilaka ");
INSERT INTO bex_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tine lïjë otɔ ŋgï rɔ gönnï gɔ akiyandi abo römöyï bo iyandi wa ŋgï kɔzɔ bɔ közï kakpa tara. ");
INSERT INTO bex_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bɔ nökï mɔtɔ ëdï mï rö ꞌba mötu yayi. Kina nökï nima kënyï ŋgï kulörï rɔ ma kembe, iya te, ");
INSERT INTO bex_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Waꞌdi ꞌbï tize, nï Yësu ꞌba Nazareta nime? Ako ꞌdeni tote dɔze nati? Mikali yi ꞌdeni. Nï na rɔ bɔ laja ma kɔtɔ laka ꞌba Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tine Yësu ënyï kamo dɔ nökï nima, iya te, “Udumö yaga. Kina itaꞌba yaga di dɔ bɔ nima.” Nökï tönë ënyï ŋgï koŋma bɔ nima bërï kömönnï pili te kina kitaꞌba ŋgï yaga di dɔmo koꞌdɔ ɔtɔ dë teyi. ");
INSERT INTO bex_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kina lende mo kigayi bilaka naga nima ŋgï pili lïjë kebe tiya mo rɔ gɔ rönnï, iya te, “Akiyandi ma tondo mo ga na te? Bo amo le dɔ nökï ni ti közï kakpa ti tigɔ te na lïjë kitaꞌba ŋgï yaga.” ");
INSERT INTO bex_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kina lëbï ꞌba Yësu kïyëlë rönï ŋgï kote mï dɔyayi nima toko. ");
INSERT INTO bex_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yësu ënyï di mï rö ꞌba mötu yayi kari liŋɔ ꞌba Simona. Tine mese ꞌba Simona ëdï yayi ti zëyï ŋgï timo rɔ ma kututu. Kina lïjë kiya lende mo zi Yësu ꞌdɔ kokɔnyi. ");
INSERT INTO bex_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kina bo kari ŋgï kɔrɔ kpa laŋgiri ꞌba ꞌja nima bo kilende zi zëyï nima ꞌdɔ kola lɔko yaga. Kina zëyï nima kola lɔko ŋgï, lɔko kënyï tɔrɔ koloma toja laja zïnnï. ");
INSERT INTO bex_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kina ɔdɔ kada këdï kösö ꞌdeni tine na bilaka koꞌde bɔ rɔkɔꞌɔ ma konzi mɔtɔ ga ame ti dɔkomali rɔkɔꞌɔ ma gege ne ŋgï kako zi Yësu. Kina bo koloma ŋgï tiꞌdi közï bo rönnï tileŋo lïjë pili rɔ kɔtɔkɔtɔ. ");
INSERT INTO bex_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tine nökï ni ebe ꞌbënnï titaꞌba yaga di dɔ bilaka ti tulörï, kiya te, “Nï na rɔ kole ꞌba Bɔkoꞌba.” Tine bo amo dönnï kola lïjë dë kilende römöyï lïjë ikali bo rɔ Kurïsïtö ame kako di mïtɔrɔ ne. ");
INSERT INTO bex_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Koꞌja bi këdï këzë ꞌdeni na Yësu kënyï ŋgï kari abo kutu bo yï mökö. Bilaka ebe toma gɔ bo, tine ɔdɔ lïjë kari koꞌja bo ꞌdeni lïjë oloma tota bo ꞌdɔ bo kari dë kpe bitɔ di zïnnï bina. ");
INSERT INTO bex_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ne tine bo iya te, “Mëdï mari tiya laja laka ꞌba ŋere löbu ꞌba Bɔkoꞌba nime gbï mï gawo mɔtɔ ga römöyï lende mo na me koja ma gɔmo.” ");
INSERT INTO bex_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kina bo köꞌbö ŋgï nduwë rɔ tiyandi bilaka di mï rö ꞌba mötu ꞌba Yudayi ni. ");
INSERT INTO bex_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mï kada ma Yësu këdï kɔrɔ kpa pöpö ꞌba Genesareta tïndï kuru bo ꞌdeni toko bërï tuwö lende ꞌba Bɔkoꞌba, ");
INSERT INTO bex_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","bo oꞌba kɔmɔ bo ŋgï bo koꞌja sorope rïyö mɔtɔ ga këdï ꞌdeni kpa götö yayi, atoyi mo ga ari ꞌdeni turögö rɔ duru ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kina bo kari këkï ŋgï mï ma kɔtɔ ame rɔ ꞌba Simona ne, bo iya zi Simona ꞌdɔ koto sorope nima kari dɔgba mbowa yaga di dɔ kpa götö. Kina bo koloma ŋgï bërï mï sorope yayi tiyandi bilaka. ");
INSERT INTO bex_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kina ɔdɔ bo kote tilende ꞌdeni tine bo ënyï kiya zi Simona, bo iya te, “Oto sorope kari mï zana mini ma kalo ꞌdɔ kuꞌduke duru ꞌbe tugu kenze.” ");
INSERT INTO bex_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tine Simona ileki dɔmo, iya te, “Ŋere, dopi rɔze ꞌdeni tuꞌdu mo ti korɔndɔ ene ŋbö bi këzë dɔze rɔ yawa kinza ma doꞌja ma kɔtɔ te. Ne gɔ lende kiya ꞌbï ti muꞌdu duru nima ŋgï.” ");
INSERT INTO bex_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kina ɔdɔ lïjë kuꞌdu yɔ na kilaka kenze ŋgï ŋbaŋi, duru koma tirica. ");
INSERT INTO bex_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kina lïjë koꞌdɔ közïnnï ŋgï zi lëpï nnï ama ga mï sorope mɔtɔ yayi ne gɔ kako tokɔnyi lïjë. Kina lïjë kope kenze ŋgï koza koso mï sorope naga nima kpaki rïyö kiꞌdi sorope pili koma za ꞌböwu tönzu bërï. ");
INSERT INTO bex_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tine ɔdɔ Simona Pïtörö koŋgɔ ꞌdeni te bo ako ŋgï kolɔdɔ bërï kɔmɔ Yësu. Bo iya te, “Ŋere, ese yaga di rɔma. Ma bɔ lende kënyë na.” ");
INSERT INTO bex_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Römöyï kenze nima kilaka zïnnï ne na lende mo kigayi lïjë ꞌdeni ŋgï pili. ");
INSERT INTO bex_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lende mo igayi lëpï bo ama ga Yakoba ni ti Yowani kole ꞌba Zebedayo ga ꞌdeni gbï. Kina Yësu kënyï kileki kiya zi Simona, iya te, “Kinza kere dë. Kisaki di mï kada nime tɔne ti këddï rɔ atoyi ꞌba toꞌde bilaka zi Bɔkoꞌba.” ");
INSERT INTO bex_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kina lïjë kilala sorope ꞌbënnï ga ŋgï yaga dɔ kpa götö, lïjë kola wa pili yayi lïjë kösö ŋgï nati gɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kina ɔdɔ Yësu këdï ꞌdeni mï gawo mɔtɔ yayi tine na bɔ mɔtɔ mönyu konyo rɔmo ga ꞌdeni ŋgï pili röwë kiꞌdi dönï ŋgï. Bo ako kilaꞌba rɔ kpa kutuꞌbö kɔmɔ Yësu bërï bo komaꞌjo rɔ bo, iya te, “Ŋere, ɔdɔ koꞌdɔkɔ ŋgï ti kileŋo ma ŋgï yaga rɔ ma kɔpɔ.” ");
INSERT INTO bex_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yësu oja közï bo kosa rɔ bɔ nima, kiya te, “Moꞌdɔkɔ ꞌdeni ŋgï, ileŋo yi ꞌdeni.” Kina mönyu tönë kola bɔ nima ŋgï. ");
INSERT INTO bex_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tine Yësu ose gɔmo zi bo, iya te, “Kinza kari kiya lende mo dë titi zi bɔtɔ tine ari kileme röyï zi bɔ akumu ꞌdɔ bo kinyeli röyï gɔ kileme ŋgï ileŋo yi ꞌdeni rɔ ma kɔpɔ. Kina gɔ koꞌde akumu kɔzɔ ame Musa kiꞌdi köꞌdu mo ꞌdeni ne tara.” ");
INSERT INTO bex_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ne pele lëbï ꞌba Yësu ïyëlë rönï ŋgï nduwë rɔ mbëmbë. Kina bilaka koloma ŋgï rɔ tɔlɔ rɔ tïndï kako tuwö akiyandi abo gbï ꞌdɔ bo kileŋo lïjë di dɔ rɔkɔꞌɔ ꞌbënnï ga. ");
INSERT INTO bex_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tine Yësu öꞌbö tusu rɔ bo kari titi mbowa yï mökö rɔ dɔ kutu bo toꞌdɔ mötu. ");
INSERT INTO bex_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mï kada ma dɔ kɔtɔ mɔtɔ koꞌja bo këdï rɔ tiyandi bilaka Parosi ni ti bɔ kɔmɔ kiyandi mɔtɔ ga ame kako di mï gawo ꞌba mï dɔyayi ꞌba Galilaya ni ti Yudayi gbï di Yerosalema ëdï yayi. Tigɔ ꞌba Bɔkoꞌba ëdï ti Yësu tileŋo bɔ rɔkɔꞌɔ timo. ");
INSERT INTO bex_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kina ya mɔtɔ ga koꞌde bɔ keŋme bërï mɔtɔ këdï kombi ti sora ŋgï. Lïjë oꞌdɔkɔ toto bɔ nima kari koꞌba bërï kɔmɔ Yësu rö yayi. ");
INSERT INTO bex_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tine ɔdɔ lïjë koꞌja kɔri ꞌba ꞌdɔ toꞌdɔ mo tara dë kpe römöyï tïndï oso ꞌdeni ŋgï kola kɔri dë kpe zïnnï, na lïjë kuyï rönnï ŋgï këkï tɔrɔ dɔ rö lïjë kumö bi koja bɔ nima di teyi kako bërï mï zana tïndï naga nima koꞌba kɔmɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kina ɔdɔ Yësu koŋgɔ ya naga nima kiꞌdi dönnï ꞌdeni gɔ tigɔ abo tara tine bo ilende ŋgï zi bɔ nima, bo iya te, “Bɔ pɔri ma, ola yi ꞌdeni gɔ lende kënyë ꞌbï ga.” ");
INSERT INTO bex_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kina Parosi ni ti bɔ kɔmɔ kiyandi mo tönë ga koloma ŋgï rɔ tomeri mo ti mïnnï, iya te, “Bɔ nime bo yë na bo këdï koꞌdɔ dölï kiyari rɔ bo ti Bɔkoꞌba te? Bɔkoꞌba na ŋge kɔtɔ rɔ bɔ tola bilaka gɔ lende kënyë.” ");
INSERT INTO bex_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Meri ꞌbënnï ti akititi ꞌbënnï nima, Yësu ikali ꞌdeni. Kina bo kileki kititi lïjë, bo iya te, “Ëddï komerike wa naga nima tara mï dökïꞌdï ye gɔ waꞌdi? ");
INSERT INTO bex_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma yala na kïtëwu ꞌdɔ tiya mo? ‘Ola yi ꞌdeni gɔ lende kënyë ꞌbï,’ ala ꞌdɔ kiya te, ‘Ënyï tɔrɔ kiliŋgere.’ ");
INSERT INTO bex_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ne ziye tikali mo rɔ ma laka kole ꞌba bilaka lesi ëdï ti tigɔ mï dɔliŋɔ nime bine tola bilaka gɔ lende kënyë.” Kina bo kënyï kiya zi bɔ keŋme bërï tönë, bo iya te, “Milende zïyï, ënyï tɔrɔ kombi sora ꞌbï kari liŋɔ.” ");
INSERT INTO bex_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kina bɔ tönë kënyï ŋgï kɔrɔ tɔrɔ di kömönnï pili te, bo kombi sora abo tönë bo koloma rɔ töꞌdö dɔmo ne bo kari ŋgï nduwë liŋɔ ti tïlëlu Bɔkoꞌba. ");
INSERT INTO bex_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kina lende mo kigayi bilaka pili ŋgï kiꞌdi yi nï bɔ mɔtɔ kebe ŋgï tïlëlu Bɔkoꞌba. Lïjë ŋgï pili rɔ tikere na lïjë kebe ŋgï tiya mo te, “Doꞌja a löbu ꞌdeni tɔne.” ");
INSERT INTO bex_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Di gɔmo na Yësu kari koꞌja bɔ kireke awada mɔtɔ kïdëkï möyï mo rɔ Lëwë koloma ꞌdeni mï bi ꞌba tireke awada. Kina Yësu kiya zi bo te, “Ösö gɔma.” ");
INSERT INTO bex_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kina Lëwë kënyï kola wa pili ŋgï bo kösö gɔ Yësu. ");
INSERT INTO bex_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lëwë oꞌdɔ ŋbele ma löbu liŋɔ abo zi Yësu. Na bɔ kireke awada ma konzi ti ya mɔtɔ ga koloma ŋgï rɔ tonyo kpënnï ti Yësu ni yayi. ");
INSERT INTO bex_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tine na Parosi ni ti bɔ kɔmɔ kiyandi ꞌbënnï ga koloma ŋgï rɔ tiya mo zi bɔ kösö gɔ bo ga, iya te, “Ëddï konyoke kpeye kuwëke wa bi kɔtɔ ti bɔ kireke awada ni ti bɔ lende kënyë naga nima gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tine Yësu ileki dɔmo zïnnï, iya te, “Bɔ rɔkɔꞌɔ na ŋge kari zi bɔ kiꞌdi wɔwɔ. Ya ma kinza ti rɔkɔꞌɔ naga ari ëꞌbënnï dë. ");
INSERT INTO bex_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mako dë tïdëkï bɔ lende laka, mako gɔ bɔ lende kënyë ꞌdɔ kotɔ dönnï.” ");
INSERT INTO bex_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ya mɔtɔ ga ënyï kititi bo, iya te, “Bɔ kösö gɔ Yowani ga ti ꞌba Parosi ni öꞌbö rɔ toro kpënnï toꞌdɔ mötu, ne ma ꞌbëyï ga oro ꞌbënnï kpënnï dë gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yësu ileki dɔmo zïnnï iya te, “Ma komerike ꞌbeye ŋba ame kako mï karama ꞌba gbe ne ti koro kpënnï koꞌja mëꞌdë ꞌba nyiti këdï tïnnï? Inza tara, ");
INSERT INTO bex_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","tine kada mo ti kömö ꞌjaa ame ꞌdɔ kogba mëꞌdë ꞌba nyiti yaga di mï löŋgö lïjë kina lïjë ti koro kpënnï ꞌjaa mï kada mo nima.” ");
INSERT INTO bex_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kina bo koloma ŋgï rɔ tiya dɔŋgala nime zïnnï, iya te, “Bɔtɔ irica kapa bɔŋgɔ ma laꞌja dë kuru ma köndë timo. Ɔdɔ bɔ mo koꞌdɔ tara, ti kirasi ma laꞌja nima, tine akuru ma di yɔki ma laꞌja inza koriya ti ma mɔlo nima. ");
INSERT INTO bex_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kina gbï tara, bɔtɔ odɔ layi ma laꞌja dë mï kilaka layi ma köndë. Ɔdɔ koꞌdɔ tara layi laꞌja ti kotopa kilaka layi köndë nima ŋgï yaga, kina layi ni kpaki ti kilaka mo nima këdï kirasi rönnï ŋgï. ");
INSERT INTO bex_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tine layi ma laꞌja todɔ mo mï kilaka ma laꞌja. ");
INSERT INTO bex_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kina gbï bɔtɔ inza koꞌdɔkɔ layi ma laꞌja kpe ɔdɔ bo kuwë ma mɔlo ꞌdeni, römöyï bo ti kiya te, ‘Ma mɔlo nime na kele.’” ");
INSERT INTO bex_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mï kada ꞌba rɔ kindawo ma dɔ kɔtɔ mɔtɔ Yësu ni ëdï kudö kebe mï nyaka ꞌba nyönyu kina bɔ kösö gɔ bo ga kebe ŋgï tomborozi dɔ nyönyu kinyanyi közïnnï lïjë koloma rɔ tonyo mo. ");
INSERT INTO bex_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kina Parosi mɔtɔ ga kënyï kititi, iya te, “Ëddï kïyëyïke mï köꞌdu kiꞌdi ꞌba kada ꞌba rɔ kindawo gɔ waꞌdi?” ");
INSERT INTO bex_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tine Yësu ileki dɔmo zïnnï, iya te, “Ïdëkïke wa tönë Dawidi koꞌdɔ mï kada ma lïjë këdï rɔ ꞌbö ti bilaka abo ga ne dë? ");
INSERT INTO bex_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mï kada nima Dawidi ɔdɔ ŋgï mï rö löbu ꞌba Bɔkoꞌba kogba maŋgolɔꞌbɔ koro ame köꞌdu kiꞌdi kota gɔmo di zi bilaka ma sari tine ŋge zi bɔ akumu ni na ꞌdɔ konyo ne. Dawidi onyo kiꞌdi gbï zi bilaka abo ga.” ");
INSERT INTO bex_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kina Yësu kileki kiya ꞌböwu zïnnï, iya te, “Kole ꞌba bilaka lesi na rɔ ŋere ꞌba dɔ kada ꞌba rɔ kindawo.” ");
INSERT INTO bex_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mï kada ꞌba rɔ kindawo mɔtɔ na bo kari ŋgï kɔdɔ mï rö ꞌba mötu koloma tiyandi wa. Tine bɔ mɔtɔ ëdï yayi közïmo ma dörï ölë ꞌdeni rɔ kilawo. ");
INSERT INTO bex_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kina Parosi ni ti bɔ kɔmɔ kiyandi ni ëdï rɔ toma kɔri ꞌba ꞌdɔ tususu Yësu. Gɔ lende mo na lïjë këdï koje kömönnï koŋgɔ ɔdɔ Yësu ti kileŋo bɔ nima mï kada ꞌba rɔ kindawo nima ya. ");
INSERT INTO bex_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tine Yësu ikali meri ꞌbënnï nima ꞌdeni na bo kiya zi bɔ közï kölë rɔ kilawo tönë, bo iya te, “Ënyï tɔrɔ kɔrɔ kɔmɔze pili bine.” Kina bɔ nima kënyï ŋgï kɔrɔ. ");
INSERT INTO bex_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kina Yësu kiya zïnnï te, “Mititi ye, ma yala na kutï dönï ti köꞌdu kiꞌdi ꞌba kada ꞌba rɔ kindawo, toꞌdɔ lende laka zi bilaka ala toꞌdɔ lende kënyë na teyi, tɔmɔ dïdï ala tupö mo yaga?” ");
INSERT INTO bex_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bo uyï kɔmɔ bo koŋgɔ dönnï pili na bo kilende zi bɔ nima, bo iya te, “Oja gɔ közïyï.” Bo oja yɔ na közï bo tönë kileŋo rönï ŋgï rɔ ma laka. ");
INSERT INTO bex_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tine lende mo ata ŋgï mïnnï sowa na lïjë koloma ŋgï rɔ tiya mo rɔ gɔ rönnï, waꞌdi na gɔ lïjë koꞌdɔ ŋgï zi Yësu. ");
INSERT INTO bex_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mï kada ma dɔ kɔtɔ mɔtɔ na Yësu kënyï ŋgï kari dɔ döku tilende ti Bɔkoꞌba këzë dɔ bo. ");
INSERT INTO bex_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mï dɔŋbɔ mo ꞌdeni tine na bo kïdëkï bɔ kösö gɔ bo ga ŋgï bo koza ya ma ꞌbutë dɔmorïyö di mï löŋgö mo bo kïdëkï lïjë rɔ bɔ laja. ");
INSERT INTO bex_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lïjë na rɔ Simona ame bo kïdëkï rɔ Pïtörö ne ti löndö bo Andareya ti Yakoba ti Yowani ti Pïlïpö ti Batolimayo ");
INSERT INTO bex_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ti Matayo ti Tɔma ti Yakoba kole ꞌba Alapayo ti Simona ame kïdëkï rɔ Zelote (bɔ koꞌdɔ ya gɔ dɔyayi ꞌbënnï) ");
INSERT INTO bex_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ti Yuda kole ꞌba Yakoba ti Yuda Isikarita ame kebe kususu Yësu ne. ");
INSERT INTO bex_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bo ëkï kari tïnnï bërï mï dɔyayi ma koriya na bo kɔrɔ ŋgï. Tïndï ame ga rɔ bɔ kösö gɔ bo ne ti bilaka ma konzi ame ga di mï dɔyayi ꞌba Yudayi pili ti Yerosalema gbï di mï gawo ꞌba Tura ni ti Sidona ame ga kpa mini löbu ne ëdï kpaki yayi. ");
INSERT INTO bex_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Lïjë ako tuwö lende abo gbï ti rɔkɔꞌɔ ꞌdɔ tileŋo mo. Kina ŋgï ya ame ga nökï këdï kodɔ gomɔ rɔmo kulöwö naga ileŋo ŋgï gbï. ");
INSERT INTO bex_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bilaka naga nima pili oꞌdɔkɔ tosa rɔ bo römöyï tigɔ ëdï kɔdɔ di rɔ bo kileŋo lïjë. ");
INSERT INTO bex_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Bo oŋgɔ dɔ bɔ kösö gɔ bo naga nima na bo kiya te, “Kpe ame ga rɔ lisa ne na laka römöyï ŋere löbu ꞌba Bɔkoꞌba na rɔ ꞌbeye. ");
INSERT INTO bex_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kpe ame ga gïrï nime rɔ ꞌbö ne na laka römöyï ti kɔꞌbɔ ye ꞌdeni. Kpe ame ga rɔ monɔ gïrï nime ne na laka römöyï ti kögöke ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kpe ame ga ɔdɔ bilaka koꞌji ye kitiꞌja ye kilagi ye kiya ye rɔ a ma kënyë gɔ lende ꞌba kole ꞌba bilaka lesi ne na laka. ");
INSERT INTO bex_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Iliyake mï kada mo nima köpuke rɔ lɔŋɔ römöyï kpa közï ma löbu ëdï ziye mïtɔrɔ. Ya naga nima ꞌbu nnï löbu ga oloma gbï rɔ toꞌdɔ bɔ kumë lende ꞌba Bɔkoꞌba tönë ga bine tara. ");
INSERT INTO bex_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tine buꞌbu ziye kpe bɔ wa ni, römöyï oteke rɔ kindawo ti lɔŋɔ ma ꞌbeye ꞌdeni mɔlo gïrï nime. ");
INSERT INTO bex_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Buꞌbu ziye kpe ame ga rɔ tëkpë gïrï nime ne, ti këddïke ꞌdeni ꞌbasi rɔ ꞌbö. Buꞌbu ziye kpe ame ga rɔ tögö gïrï nime ne, ti kuduke ꞌdeni. ");
INSERT INTO bex_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Buꞌbu ziye kpe ame ga bilaka pili këdï kiya lende ꞌbe rɔ ma laka ne römöyï kina ꞌbu nnï löbu ga koꞌdɔ bɔ kumë lende dɔ kïndëndë ni gbï tara bine. ");
INSERT INTO bex_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kina me mëdï miya ziye kpe ame ga këddï kuwöke lende naga nime mëdï miya ne. Ɔꞌɔ bɔ ya ꞌbï ga kina oꞌdɔ lende laka zi lïjë ame ga koꞌji yi ne. ");
INSERT INTO bex_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Oꞌdɔ yëyï dɔ lïjë ame ga kulömu yi ne kina 