﻿USE sofia;
DROP TABLE IF EXISTS sofia.beu_vpl;
CREATE TABLE beu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES beu_vpl WRITE;
INSERT INTO beu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Halomang-halomang angu, Lahatala Ana por-alolang anga, bot burang atela angdo ening. Sengmuse por-alolang anga Lahatala Ana metma alolang angami mea, bot burang angu, Ana metma atela angdo mi mea. ");
INSERT INTO beu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Aarunge halomang angu, por-alolang anga emenghula jar edadenang, mang ava aojang lamal, meke aanamang daeri angu, bae ue jedung, bot na iiba bae por-alolang anga taang jedung. Kua-kete ba por-alolang emeke ba bae aanamang jedung angu, vengtering. Bot Lahatala ERoh Hamulang angu, por-alolang emeke ba bae aanamang jedung, emenghula jar edadenang, ava aojang lamal angu ba taang lamal. ");
INSERT INTO beu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Angmuse Lahatala Ana gahing vengbanang hula, “Jara angu, por-alolang anga taang hengi.” Lahatala Ana gahing vengbanang aulang muse, jara angu por-alolang anga taang iila. ");
INSERT INTO beu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Lahatala Ana uuling ateing se, jara angu por-alolang anga taang iila muse, Omi sanang, se Ana vengpikir hula, jara ba Ana ening iila angu, aaung angu ebele. Seng angmuse, Lahatala Ana jara angu metma kete angu veng, ening atatara. Senge nu-nut ejol veng. ");
INSERT INTO beu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Lahatala Ana jara angu ene maveng hula, ꞌbir-jalaꞌ, bot kete angu Lahatala Ana ene maveng hula, ꞌbir-kuaꞌ. Bir-kua va iila, bir-jala ma muse, angu ba ved ehalomang. ");
INSERT INTO beu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Seng angmuse, Lahatala Ana bot gahing vengbanang hula, “Mana osing eele Na malekang ening metma atelat hama angdo mi mea, senge jar angu ening atatara hengi. Aulang senge, jar doe atela angdo mi, bot jar ae alolang anga di mi.” Lahatala Ana gahing vengbanang aulang muse, jar angu tatarat baang aaru. ");
INSERT INTO beu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mana osing eele ba atelat hama angdo mi angu, Lahatala Ana ene maveng hula, ꞌburangꞌ. Bir-kua va iila, bir-jala ma muse, anguba ved emiaaru. ");
INSERT INTO beu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Lahatala Ana bot gahing vengbanang hula, “Jar ba ae burang iivang anga, emangpi malekang taing vengkumpul mana nu mi, senge por-alolang emeke aanamang daeri angu ava-apaleteng hengi.” Lahatala Ana gahing vengbanang aulang muse, por-aloalang emeke aanamang daeri angu, ava apaleteng iila. ");
INSERT INTO beu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Angmuse por-alolang emeke aanamang daeri angu, Lahatala Ana ene maveng hula, ꞌaadang-taataꞌ; bot jar ba taing vengkumpul mana nu mi angu, Lahatala Ana ene maveng hula, ꞌtangꞌ. Aadang-taata, bot tang angu, Lahatala Ana uuling ateing muse, Ana vengpikir hula, emangpi ba Ana ening iila angu, aaung. ");
INSERT INTO beu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Angmuse Lahatala Ana bot gahing vengbanang hula, “Aadang-taata angu, te, bot dadi-napa malekang taang bilang hengi. Te ba eihi veng, ekokal veng, bot te rupa-rupa ang naung, malekang bilang hengi. Senge te ang naung nu-nut eihi veng, erupa angu eamulung.” Lahatala Ana gahing vengbanang aulang muse, jadit aulang iila. ");
INSERT INTO beu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Te rupa-rupa ba aadang-taata taang bilang angu, etatabi toang, base te ang naung nu-nut eihi veng, erupa angu eamulung. Te ba aadang-taata taang ang naung Lahatala Ana uuling ateing muse, Omi sanang, se emangpi ba Ana ening iila angu, etatabit aaung angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Bir-kua vai iila, bir-jala ma muse, anguba ved emitue. ");
INSERT INTO beu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Angmuse Lahatala Ana bot gahing vengbanang hula, “Malekang na jara toang doe burang atela angdo mi jehi, senge bir-jala, bot bir-kua angu ening atatara hengi. Aulang senge na jara ang naung metma etanda ening hula, eningse ved taing telul, kua taing telul, uuru taing telul, bot tung di malekang taing telul. Na jara ang naung malekang doe burang atela angdo mi jehi, senge ejara angu por-alolang anga vengjara hengi. Uanguveng Lahatala Ana gahing vengbanang aulang sengmuse, emangpi angu, jadit aulang iila. ");
INSERT INTO beu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Lahatala Ana na jara eele aaru ening metma burang mi mea. Emieele angu ene vedeng, bot emihamang angu ene uuru. Vedeng angu, bir-jala angu parenta, aarunge uuru angu, bir-kua angu parenta. Lahatala Ana bot iid di ening metma burang mi mea. ");
INSERT INTO beu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Lahatala Ana na jara ang naung emangpi vengator metma burang mi meat aulang, senge ejara angu por-alolang anga vengjara. ");
INSERT INTO beu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Bot aulang senge, na jara ang naung bisa, bir-jala bir-kua angu parenta, bot bir-jala bir-kua angu ening atatara. Lahatala Ana uuling ateing se, na jara ba Ana ening iila ang naung, emangpi aaung. ");
INSERT INTO beu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Bir-kua va iila, bir-jala ma muse, anguba ved emibuta. ");
INSERT INTO beu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Lahatala Ana bot gahing vengbanang hula, “Binanta rupa-rupa ba kiki-eele angu, toang-rae malekang tang omimi, bot moar omimi aabeta hengi. Bot dung rupa-rupa angu, malekang por-alolang anga taang aalilit burang osing angmi lamal hengi.” ");
INSERT INTO beu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Angmuse binanta eele tang omimi, bot aab rupa-rupa ba tang omimi, bot moar omimi ang naung, Lahatala Ana ening. Bot dung rupa-rupa ba burang mi aalili ang naung di, Lahatala Ana ening. Lahatala Ana uuling ateing se, binanta eele tang omimi, aab rupa-rupa, bot dung rupa-rupa burang mi aalili ba Ana ening iila ang naung, emangpi aaung. ");
INSERT INTO beu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Seng angmuse, aaung-hama ba kuat-daeri ue omimi angu Lahatala Ana metma mainang, bot mateng hula, “Binanta eele tang omimi, bot aab rupa-rupa ba tang omimi, bot moar omimi ang naung, malekang ajait toang-rae, senge tang omi angu ening aaving, bot moar omi angu ening aaving. Bot dung rupa-rupa ba burang mi aalili ang naung di, malekang ajait ening toang-rae hengi.” ");
INSERT INTO beu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Bir-kua va iila, bir-jala ma muse, anguba ved emi iising. ");
INSERT INTO beu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Angmuse Lahatala Ana bot gahing vengbanang hula, “Binanta rupa-rupa angu, malekang aadang-taata angu taang emana mi aabeta hengi. Benangba binanta gariang, binanta balevang, bot binanta ba meke taang eera ang naung, nu-nut erupa angu eamulung emangpi Lahatala Ana ening.” Lahatala Ana uuling ateing se, binanta ba Ana ening iila ang naung, emangpi aaung. ");
INSERT INTO beu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Lahatala Ana bot gahing vengbanang hula, “Ni malekang nehe ening irupa angu emenghula Nirupa anga edadenang hengi. Senge aab tang omimi, dung burang mi aalili, binanta aamunang, binanta balevang ba aadang-taata taang, bot binanta meke taang eera ang naung, emangpi ini bisa vengurus.” ");
INSERT INTO beu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Angmuse Lahatala Ana nehe ang naung ening, emenghula Aing edadenang. Nehe jangu, bot nehe mehal di Lahatala Ana ening, Erupa angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nehe ba Lahatala Ana ing ening iila ang naung, aaung-hama ba kuat-daeri ue omimi angu Ana metma mainang, bot Ana iat mateng hula, “Iini malekang tabaning-tahelit ening toang-rae, ening por-alolang anga aaving hengi. Senge por-alolang anga, aab tang omimi ang naung, dung burang mi aalili ang naung, bot binanta rupa-rupa ba aadang-taata taang ang naung emangpi, nehe ang naung ini bisa vengurus. ");
INSERT INTO beu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Angmuse Lahatala Ana bot mateng hula, “Iini vengmeet aaung-aaung! Te rupa-rupa ba ae por-alolang taang anga, benangba: Te eiipi veng angu, te ekokal veng angu, bot te ba eva aloal veng angu, Na metma mainang, senge iini adang metma iimod ening. ");
INSERT INTO beu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Aarunge binanta rupa-rupa ba por-alolang taang, dung rupa-rupa ba burang mi aalili, bot binanta meke taang eera ba eng-hara veng ang naung emangpi, te ba eiipi veng, eva aloal veng, bot dadi-napa aloal angu, Na metma mainang, senge ini adang metma imod ening.” Lahatala Ana mateng aulang muse, emangpi angu jadit aulang iila. ");
INSERT INTO beu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Emangpi ba Lahatala Ana ening iila angu, Ana uuling ateing muse, Omi etatabit sanang, se emangpi ba Ana ening iila angu, etatabit aaung angu ebele. Bir-kua va iila, bir-jala ma muse, anguba ved emi taling. ");
INSERT INTO beu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Lahatala Ana por-alolang anga, burang atela angdo, bot emangpi ba omimi angu ening angu, aulang. ");
INSERT INTO beu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Emangpi angu Lahatala Ana vengkarajang sengmuse, ved emi bititu angu Lahatala Ana barinti. ");
INSERT INTO beu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Karajang ba Lahatala Ana ening iila ang naung, ved emi bititu angu, Ana bot bae taang ening niang, se emangpi angu, Ana ening sengila angu ebele. Angmuse ved emi bititu angu Lahatala Ana miari, sengilaba ved angu Ana ening hamulang-kadulang. ");
INSERT INTO beu_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Uanguveng Lahatala Ana por-alolang anga, burang atela angdo, bot emangpi ba omimi angu ening angu, esarenta angu aulang. ");
INSERT INTO beu_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Uanguveng LAHATALA Ana por-alolang anga, bot burang atela angdo ening angu, ");
INSERT INTO beu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","dadi-napa, abuar maang, bot te iiba bae aadang-taata angu taang bilang di jedung, se Lahatala Ana bae aanuar metma por-aloalang anga taang at hela jedung, bot nehe iiba bae por-alolang emeke angu vengkarajang jedung angu ebele. Aarunge uanguveng angu, bano-kaana angu por-alolang anga emeke angu taang da, sengilaba por-alolang emeke angu ening abareka. ");
INSERT INTO beu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Uanguveng anguba, LAHATALA Ana meke banakung angu kabingdena medi, sengmuse Ana vengkarajang metma nehe nu ening. Bot Lahatala Ana Eeng-hara aabetang angu metma nehe angu aming boor angu mi apu. Angmuse nehe angu aabeta. ");
INSERT INTO beu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Seng angmuse ved danangoa angmi, LAHATALA Ana Eden mi bir nu ening. Bot nehe ba Ana ening iila angu, Ana aing metma Eden mi bir angu mi amihing. ");
INSERT INTO beu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Angmuse te rupa-rupa ba aalus ae por-alolang taang, bot eihi angu nehe bisa adang, bot tamaa angu, LAHATALA Ana ot bir angu mi bilang. LAHATA Ana bot te rupa aaru ot bir angu ehahama angu, mi bilang. Te rupa nu angu, kalo nehe eihi angu adang se, ini aabetat aulang ejehing-emeang. Aarunge te erupa nu angu, kalo nehe eihi angu adang se, aaung di ini uuling ateing, bot jasi di ini uuling ateing. ");
INSERT INTO beu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Bot moar nu ejar angu, ue Eden mi halu, senge bir angu ening abareka. Angmi angu, moar angu ana atang paul baang buta. ");
INSERT INTO beu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Moar ehalomang angu, ene Pison. Aing angu halut Hawila aabang eoang angu emangpi migoleng. Angmi angu, mas toang. ");
INSERT INTO beu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Mas ba aabang angu mi angu, hamulang. Bot te epuha manema, bot var huling di ue aabang angu mi. ");
INSERT INTO beu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Moar emiaaru angu, ene Gihon. Aing angu halut Kus aabang eoang angu emangpi migoleng. ");
INSERT INTO beu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Moar emitue angu, ene Tigris. Aing angu halut Asyur aabang eved danangoa angmi, metma Asyur aabang angu eha ening. Moar emibuta angu, ene Efrat. ");
INSERT INTO beu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nehe ba LAHATALA Ana aing ening iila angu, Ana aing metma Eden mi amihing, senge ana bir angu vengurus aaung-aaung. ");
INSERT INTO beu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Angmuse LAHATALA Ana parenta anga metma nehe angu at mateng hula, “Te ba ae bir anga omimi anga, emangpi eihi angu, aana bisa adang. ");
INSERT INTO beu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Aarunge te nu bir anga ehahama mi tahi, benangba; Te aaung di ue omimi, bot jasi di ue omimi angu, aana ekang eihi angu adang ekang. Kalo aana eihi angu adang se, aana malekang aamina.” ");
INSERT INTO beu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","LAHATALA Ana bot mateng hula, “Nehe anga kalo ana enangkolang aabeta se, bae aaung niang. Eserang omi vengbaa nu, Na malekang ening metma maenang hengi.” ");
INSERT INTO beu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Angmuse LAHATALA Ana binanta rupa-rupa ba por-alolang anga taang, bot dung burang mi aalili angu ening, sengmuse LAHATALA Ana emangpi angu iat nehe angu ebele ila, senge nehe angu ana iene maveng. Base, binanta ba eeng-hara veng ae por-alolang anga taang, bot dung ba burang mi aalili ang naung, nehe angu ana nu-nut iene vengbanang tatalang metma mainang angse, iene angu aulang. Binanta rupa-rupa ba aamunang-balevang, bot dung burang mi aalili angu, nehe angu ana iene maveng iila, aarunge aing angu, nehe nu omi vengbaa metma eserang ening angu, ana bae harak jedung. ");
INSERT INTO beu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Angmuse LAHATALA Ana nehe angu aing ening ana tiat udut aaneil. Uanguveng nehe angu ana tiat udu sehi muse, LAHATALA Ana abar-kusing angu nu medi, sengmuse emana angu bale eaabua metma vengtering. ");
INSERT INTO beu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nehe angu abar-kusing ba LAHATALA Ana medi angu, Ana vengkarajang metma nehe jangu nu ening, sengmuse nehe jangu angu Lahatala Ana at ila metma nehe angu enang. ");
INSERT INTO beu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Uuling nehe jangu angu ateing muse, nehe angu ana mateng hula, “Yaa! Aing anga hengi! Anga ba nomi vengbaa! Ekira anga emenghula nekira edadenang. Bot eaabua anga emenghula neaabua edadenang. Aing anga nehe mehal mi ba aing medi base, na ene maveng hula, ꞌnehe janguꞌ.” ");
INSERT INTO beu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Angu ebele, nehe mehal angu ana malekang iva-imang angu iadu, senge ila ejangu angu at aabeta, se oleve angu, aabetat ening nu kolang iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Uanguveng angu, nehe angu ejangu oleve idura, aarunge oleve uuling itateing di, ini bae rasat iava-aaloring niang. ");
INSERT INTO beu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Binanta ba LAHATALA Ana ening metma por-alolang anga taang iila anga, duming angu ba etatabit pintar putar-bele. Minu adana, duming angu ana nehe jangu angu adangtaaning hula, “Misavaka se Lahatala Ana iihapat hula, ꞌTe ba ae bir anga omimi anga, emangpi iini ekang eihi angu adang ekang ka?ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Angmuse nehe jangu angu, ana duming etaaning angu ebalet hula, “Niang! Te ba ae bir anga omimi anga, emangpi angu ni bisa eihi angu adang! Aarunge te nu bir anga ehahama mi angu ba, Lahatala Ana venghapat hula, iini ekang eihi angu adang ekang, bot ekang dei di ekang, eningse iini aamina.” ");
INSERT INTO beu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Aarunge duming angu ana nehe jangu ehur angu ebalet hula, “Iini bae aamina niang! ");
INSERT INTO beu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Lahatala Ana iihapat aulang angu, Ana ateing iila, kalo te angu iini eihi angu adang se, iini pintar emenghula Aing edadenang. Eningse aaung di iini ateing, bot jasi di iini ateing.” ");
INSERT INTO beu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Angmuse nehe jangu angu ana uuling ateing se, te angu etatabit aalus, bot eihi angu di, etatabit omi vengravak-sehi. Nehe jangu angu ana vengpikir hula, “Kalo te eihi anga na adang se, eningse na pintar.” Angmuse ana atang taning te eihi angu medit adang. Bot ana baning ila metma emehal di enang, base emehal di adang. ");
INSERT INTO beu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nehe jangu angu emehal oleve te eihi angu adang sengmuse, ieng angu tabuka, bot ini uuling ateing se, oleve idura. Angmuse oleve tevaa medit metma iboa angu vengtering. ");
INSERT INTO beu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Uanguveng ved baa muse, nehe mehal angu ejangu oleve vengmee se, LAHATALA Ana ue bir omi angumi lamal. Angmuse oleve ila te apolil tamaang, senge LAHATALA Ana ekang uuling iateing ekang. ");
INSERT INTO beu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Aarunge LAHATALA Ana nehe mehal angu earu, bot adangtaaning hula, “Ee! Aana ue taang mi?” ");
INSERT INTO beu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nehe mehal angu ana LAHATALA Etaaning angu ebalet hula, “Na Aamal angu vengmee se, Aana ae angami muse, na etatabit nuangmari, se na nedura angu ebele. Base na ae tamaang.” ");
INSERT INTO beu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Angmuse Lahatala Ana mateng hula, “Nuba ba aat mateng vengbanang hula, aana eedura? Te eihi ba Na venghapa tilat hula, oot ekang adang ekang angu, aana adang iila ka?” ");
INSERT INTO beu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nehe mehal angu ana Lahatala Ehur angu ebalet hula, “Nehe jangu ba Aana metma manenang nabar-vengapina anguba, te eihi angu baning hoa metma manenang, base na adang!” ");
INSERT INTO beu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Angmuse Lahatala Ana nehe jangu angu at mateng hula, “Naba ba aana ening iila ba anga?” Nehe jangu angu ana Lahatala Ehur angu ebalet hula, “Duming anguba naajajala! Angu ebele, na te eihi angu medit adang.” ");
INSERT INTO beu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Angmuse LAHATALA Ana duming angu at mateng vengbanang hula, “Aana ening alang iila base, binanta aamunang, bot binanta balevang banaha mi ang naung ihahama mi angu, aaing angaba Na kutuk metma maeenang. Angase sampe aana aamina angu, aana aatou ba metma eera, bot kalo aana jedung aabeta sehi se, meke kajala anguba metma eemod ening. ");
INSERT INTO beu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Angase Na ening nehe jangu anga ooleve iiomi metma tealalil alolang-niang. Bot ooleve iitabaning ang naung di aulang. Base, eningse aana nehe jangu anga, ia-kudavali angu mitapurut ening amusing. Bot nehe jangu anga etabaning ang naung, eningse ini oong angu bait ening amusing.” ");
INSERT INTO beu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Angmuse Lahatala Ana nehe jangu angu at mateng hula, “Eningse iia-tamadi esusa angu Na ening etatabi toang, bot kalo aana vaal vengajai se, aana etatabit dira. Aulang aarunge, oomi angu kilang eemehal angu aing midadanang alolang-niang, base aing ba aaing vengator.” ");
INSERT INTO beu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Angmuse Lahatala Ana nehe mehal angu at mateng hula, “Aana eejangu ehur anguba eamulung, aarunge aana bae Neparenta angu eamulung niang, bot te ba Na venghapat hula, ekang eihi angu adang ekang angu, aana adang iila. Base, angase Na hukung metma maeenang, bot hukung angu Na metma meke ba eningse aana vengkarajang angu di taang mea. Angase aana jedung aabeta sehi se, aana malekang meke angu vengkarajang etatabit susa-lala, senge aana bisa naadang. Bot karajang aulang, senge aana bisa aabeta. ");
INSERT INTO beu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Aana namuding-natapa se, abuar maang, abilu maang malekang aaing tangi, senge namuding-natapa eihi angu aana bisa medi, bot teihi banaha mi anguba, metma eemod ening. ");
INSERT INTO beu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Aana etatabit karajang eekira metma vengboar, bot eetarung hela, senge aana bisa mod harak adang. Aana malekang karajang aulang sampe vengaamina, senge nehe bale aaing metma meke mi taloul. Aaing angu meke banakung ba Na metma aaing ening. Base kalo aana aamina se, aana malekang bale ila metma meke banakung ening.” ");
INSERT INTO beu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Angmuse nehe mehal angu ana ejangu angu ene maveng, ene ꞌHawaꞌ (evengbanang tarang se hula, ꞌaabetaꞌ), se aing angu, nehe ba aabeta ang naung emangpi iva angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bot LAHATALA Ana binanta ebuar metma pakiang ening, sengmuse Ana metma nehe mehal angu ejangu oleve inang ini pake. ");
INSERT INTO beu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Angmuse Lahatala Ana mateng hula, “Nehe anga naung, angase taang ba aaung, bot taang ba jasi di ini ateing iila, emenghula Ping edadenang. Angu ebele, misavaka ini bot iatang taning te aabetang eihi angu di medit adang, senge ini aabetat aulang ejehing-emeang.” ");
INSERT INTO beu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Angmuse LAHATALA Ana iaterit kaluar metma Eden bir angu eahalang ila mana aabeung mi, senge ini meke angu vengkarajang metma iabetang adana. ");
INSERT INTO beu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Lahatala Ana nehe ang naung iaterit kaluar sengmuse, Ana Egahingvala sorga mi ebet-veng gahing hoa, senge Eden bir eved danangoa angmi jaga. Kalevang ba huring-jara angu, gahingvala sorgami ebet-veng ang naung ini pinat tahi, senge viaha maso angu vengtering. Aulang senge nehe ang naung, ini ekang bale maso te aabetang eihi angu, medit adang ekang. ");
INSERT INTO beu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Angmuse nehe angu ana ejangu Hawa abung tia muse, ejangu Hawa atou veng. Angmuse ana vaal mehal nu vengajai. Hawa ana mateng hula, “LAHATALA Ana noangmoling, angu ebele na vaal mehal nu vengajai tila.” Hawa ana oal mehal angu ene maveng, ene Kain (evengbanang tarang se hula, ꞌat kaluarꞌ). ");
INSERT INTO beu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hawa bot taang vaal mehal nu vengajait maveng. Angmuse ana oal mehal angu ene maveng, ene Habel. Uanguveng Kain, bot Habel oleve eele tila muse, Habel aing binanta ba terang. Aarunge Kain aing maada-pina. ");
INSERT INTO beu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Minu adana, Kain ana emaada-epina angu eihi iiba baning ila sadaka ening metma LAHATALA Enang. ");
INSERT INTO beu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Angmuse Habel di ejumba emutu ba eboa eere-eere angu medi, sengmuse euumung angu ana baning ila sadaka ening metma LAHATALA Enang. Uuling ateing aulang muse, LAHATALA Omi etatabit sanang metma Habel adana, bot Habel esadaka angu di, Lahatala Ana Omi metma vengmea. ");
INSERT INTO beu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Aarunge Kain angu, Lahatala Omi bae aing vengsanang niang, bot esadaka angu di, Lahatala Ana bae Omi metma vengmea niang. Angu ebele Kain ana etatabit omi alil, bot apang omi angu etatabit jasi. ");
INSERT INTO beu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Angmuse LAHATALA Ana Kain at mateng hula, “Ee, Kain! Etatalang ba aana oomi alil aulang, bot aapang omi angu di, jasit aulang angu? ");
INSERT INTO beu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kalo aana aaung ening se, aapang omi angu bae taladil niang ka? Aarunge kalo aana bae aaung ening niang se, jasi-ahala angu ue aapang taang iila. Ana etatabit oomi aajajala, senge oot jasi-ahala angu ening. Base, kalo oomi ue hula jasi-ahala ening se, eeomi aulang angu aana malekang atobang metma eeola!” ");
INSERT INTO beu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Minu adana, Kain ana ekaku Habel asenang hula, “Kaku Habel! Ma senge pi ila bir mi lamal-lamal.” Uanguveng oleve bir mi lamal sehi muse, eateing-niangse Kain ana ekaku Habel angu buet ameang. ");
INSERT INTO beu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Angmuse LAHATALA Ana Kain adangtaaning hula, “Ee, Kain! Eekaku Habel benang ue taang mi?” Kain ana Lahatala Etaaning angu ebalet hula, “Habel ana ue taang mi di, na bae ateing niang! Aana ateing hula, naing nekaku ebuangvala ka?” ");
INSERT INTO beu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Angmuse Lahatala Ana Kain at mateng hula, “Etatalang ba aana jasi-ahala ening aulang angu? Emangpi ba aana ening angu, Na ateing iila! Bot eekaku eve ba meke mi moring Nearu sehi angu, Na vengmee tila! ");
INSERT INTO beu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Base, angase kutuk angu aaing taang hela, se aana aatang metma eekaku Habel etaning aing buet ameang, bot eve angu metma meke mi bokong iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kalo aana maada-pina se, meke angu bae eihi aaung metma maenang niang iila. Angase aana por-alolang anga taang lamal ila-hoa, emenghula nehe hoang-manang ba lamal eabetang aalaping angu edadenang.” ");
INSERT INTO beu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Angmuse Kain ana LAHATALA Ehur angu ebalet hula, “Ah! Nimang Lahatala! Etatalang ba Aana hukung etatabi tamadit aulang angu metma manenang, sampe na tevang jadi niang alang anga? ");
INSERT INTO beu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Angase Aana naterit metma bir anga eahalang iila, base eningse na bae uuling Aateing niang iila. Angase na lamal ila-hoa emenghula nehe hoang-manang edadenang, base na ila taang mi nehe iiba naing harak se, tantu ini nameang.” ");
INSERT INTO beu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Aarunge LAHATALA Ana Kain ehur angu ebalet hula, “Bae aulang niang! Nuba ba Kain ameang se, Na aing hukung ebale metma maenang mibititu!” Angmuse LAHATALA Ana tanda metma Kain apang mi mea, senge nehe iiba aing harak dise, nehe bae ameang niang. ");
INSERT INTO beu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Angmuse Kain ana lamal mana angu eahalang, ila LAHATALA Eola. Ana lamal ila Eden bir eved danangoa angmi, mana nu ene Nod angu mi. Nod angu evengbanang tarang se hula, ꞌLamal ila-hoaꞌ. Angmuse Kain ana angumi mihi. ");
INSERT INTO beu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Angmuse Kain ana jangu medi. Ana ejangu abung tia muse, ejangu atou veng. Kain ejangu ana vaal mehal nu vengajai muse, ini ene maveng, ene Henok. Bot Kain ana bendar nu bakung atahing muse, ana bendar angu ene maveng hula, Henok, oal ene angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Angmuse Henok ana Irad vengajai. Irad ana Mehuyael vengajai. Mehuyael ana Metusael vengajai. Bot Metusael ana Lamek vengajai. ");
INSERT INTO beu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek ana jangu aaru medi. Nu ene Ada, bot nu ene, Sila. ");
INSERT INTO beu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada oal angu nu ene, Yabal. Yabal etabaning ang naung, ini binanta ba terang. Bot ini aabetat iava-asorong lamal ila mana nu mi, hoa mana nu mi, base ini sukat teeng ening, senge mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal ekaku angu, ene Yubal. Yubal etabaning ang naung, ini sukat musik kecapi at mamulal, bot huling apu. ");
INSERT INTO beu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek ejangu Sila di vaal vengajai. benangba, Tubal-Kain. Tubal-Kain etabaning ang naung, sukat oola bai. Base oola, bot tembaga ang naung, ini bait metma na rupa-rupa angu ening. Tubal-Kain ekaku jangu engu, ene Naema. ");
INSERT INTO beu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Minu adana, Lamek ana ava tajaning. Angu ebele ana ejangu aaru angu iapangaadang mi mateng hula, “Ada, bot Sila ooleve, iing ba Lamek ejangu ang naung, iiavel hele, senge nemateng anga vengmee hengi! Vede nehe mehal-kaneng nu naing buet sampe vavarang, angu ebele na aing marasit ameang iila. ");
INSERT INTO beu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Base nehe ba hula Kain ameang angu, hukung aing vengbaat mibititu. Aarunge nuba ba hula nameang se, ing angu hukung ing vengbaat mi 77.” ");
INSERT INTO beu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam ana ejangu Hawa abung tia muse, Hawa ana vaal mehal nu vengajai. Angmuse ini vaal angu ene maveng, ene Set (evengbanang tarang se hula, ꞌtaning metma manenangꞌ), Angu ebele, Hawa ana mateng hula, “Lahatala Ana vaal anga taning metma manenang, senge Habel ba Kain ana buet ameang iila angu, etelul ening.” ");
INSERT INTO beu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Luung niang muse, Set di vaal mehal nu vengajai. Angmuse ini vaal angu ene maveng, ene Enos. Uanguveng Enos ejamang mi anguba, nehe mulai LAHATALA Ene vengbanang, bot Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Uanguveng Lahatala Ana manusia ening angu, Ana ing ening emenghula Erupa angu edadenang. Lahatala Ana ing ening mehal, bot jangu. Seng angmuse Ana iarut hula, “manusia”, bot Ana aaung-hama ba bae ebale veng niang angu, metma mainang. Manusia halomang angu ene Adam. Angaba Adam etabaning ang naung iene. ");
INSERT INTO beu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam euumur mitung 130 muse, ana vaal mehal nu vengajai. Vaal angu erupa angu, emenghula aing edadenang. Angmuse Adam ana oal mehal angu ene maveng, ene Set. ");
INSERT INTO beu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam ana Set vengajai sengmuse, ana aabetat mitung 800 maveng. Angu ebele, Adam ana vaal mehal, bot val jangu di, taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Base, Adam euumur mitung 930 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ana aabetat eeumur mitung 105 muse, ana vaal mehal nu vengajai, ene Enos. ");
INSERT INTO beu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Bot Set ana jedung aabetat mitung 807 maveng. Angu ebele, Set ana vaal mehal, bot vaal jangu di, taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Base, Set euumur mitung 912 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos euumur mitung 90 muse, ana vaal mehal nu vengajai, ene Kenan. ");
INSERT INTO beu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Bot Enos ana jedung aabetat mitung 815, maveng. Angu ebele, Enos ana vaal mehal, bot vaal jangu di taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Uanguveng Enos euumur mitung 905 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan euumur mitung 70 muse, ana vaal mehal nu vengajai, ene Mahalalel. ");
INSERT INTO beu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Angmuse Kenan ana jedung aabetat mitung 840 maveng. Angu ebele, Kenan ana vaal mehal, bot vaal jangu di taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Base, Kenan euumur mitung 910 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel euumur mitung 65 muse, ana vaal ehal nu vengajai, ene Yarid. ");
INSERT INTO beu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Angmuse Mahalalel ana jedung aabetat mitung 830 maveng. Angu ebele, Mahalalel ana vaal mehal, bot vaal jangu di taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Base, Mahalalel euumur mitung 895 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yarid euumur mitung 162 muse, ana vaal mehal nu vengajai, ene Henok. ");
INSERT INTO beu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Angmuse Yarid jedung aabetat mitung 800 maveng. Angu ebele, Yarid ana vaal mehal, bot vaal jangu di taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Base, Yarid euumur mitung 962 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok euumur mitung 65 muse, ana vaal mehal nu vengajai, ene Metusalak. ");
INSERT INTO beu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Angmuse Henok ana Lahatala At aabetat eluung mitung 300 maveng. Angu ebele, Henok ana vaal mehal, bot vaal jangu di taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Bot Henok ana Lahatala At aabetat alolang-niang. Angu ebele Henok euumur mitung 365 muse, ana ue-niang, se Lahatala Ana aing ohit sorga mi mida angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusalak euumur mitung 187 muse, ana vaal mehal nu vengajai, ene Lamek. ");
INSERT INTO beu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Angmuse Metusalak ana jedung aabetat mitung 782 maveng. Angu ebele Metusalak ana vaal mehal, bot vaal jangu di taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Base, Metusalak euumur mitung 969 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek euumur mitung 182 muse, ana vaal mehal nu vengajai. ");
INSERT INTO beu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Angmuse Lamek ana vaal angu ene maveng, ene Noh (emenghula hur kokal nu angu edadenang, evengbanang tarang se hula, ꞌtomi ening sanangꞌ), angu ebele Lamek ana mateng hula, “Por-alolang ba Lahatala Ana kutuk metma taang mea tila anga, pi taang karajang etatabit susa-lala dise, vaal anga eningse ana tomi angu ening sanang.” ");
INSERT INTO beu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Angmuse Lamek ana jedung aabetat mitung 595 maveng. Angu ebele Lamek ana vaal mehal, bot vaal jangu di taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Base, Lamek euumur mitung 777 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noh ana aabetat euumur mitung 500 muse, ana vaal mehal tue vengajai. Benangba, Sem, Yafed, bot Ham. ");
INSERT INTO beu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Uanguveng manusia ba por-alolang taang angu, taang maveng toang iila muse, ini vaal jangu toang vengajai. ");
INSERT INTO beu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Angmuse Lahatala oal mehal ang naung ini uuling iateing se hula, manusia oal jangu ang naung mahena-mahena muse, jangu taang ba ini suka se, ini medit metma ijangu ening. ");
INSERT INTO beu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Angmuse LAHATALA Ana mateng hula, “NeRoh ba manusia ang naung iat aabeta angu, angase bae iat aabetat aulang ejehing-emeang niang iila. Se manusia ang naung ini bae aabetat molo niang iila angu ebele. Angase ini malekang aamina. Base, eningse ini aabetat iuumur angu mitung 120 kolang.” ");
INSERT INTO beu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Jamang angu, bot jamang ba miamulung ang naung di, nehe karangboru ang naung ue por-alolang anga taang aabeta tila. Uanguveng, Lahatala oal mehal ang naung, ini manusia oal jangu ang naung medit metma ijangu ening angu, ini nehe balolu-eele, bot nehe lumul-kavasar ang naung vengajai. Ing ba metma malibal ekapala ening ang naung, bot ingba metma nehe ene veng ening, sarenta tura-tura ang naung mi angu. ");
INSERT INTO beu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Uanguveng angu, LAHATALA Ana uuling ateing se, manusia por-alolang taang angu, etatabit jasi-ahala angu ba omimi aabeta. Manusia ang naung mang jasi-ahala anguba vengpikir alolang-niang. ");
INSERT INTO beu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Angmuse Lahatala Ana etatabit manasal, se Ana manusia angu ening metma por-alolang anga taang iila angu ebele. Angu ening Lahatala Omi etatabit dira. ");
INSERT INTO beu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Angu ebele, Lahatala Ana mateng hula, “Manusia ba Na ing ening metma por-alolang anga taang iila ang naung, emangpi Na malekang hapot bia. Manusia, dung burang mi aalili, bot binanta eabeung ang naung di, emangpi Na hapot bia, senge ini ekang por-alolang anga taang aabeta ekang. Na manasal, se Na ing ening iila angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Aarunge Noh ba enangkolang ening LAHATALA Omi sanang base, LAHATALA Ana aaung-hama metma maenang. ");
INSERT INTO beu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noh eaabetang esarenta angu alang: Noh ana vaal mehal tue vengajai, benangba Sem, Yafet, bot Ham. Jamang angu veng angu, Noh ba enangkolang aabetat molo-molo, ana bae jasi-ahala iiba ening niang. Bot Noh ana Lahatala At aabeta. ");
INSERT INTO beu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Aarunge manusia aabeung ba aabetat por-alolang taang angu, Lahatala Ana uuling iateing se, emangpi angu jasi-ahala ba omimi aabeta. Taang-taang mi angu, nehe emangpi eabetang elamal-atahi angu, etatabi tarahak-etavetang. ");
INSERT INTO beu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Angmuse Lahatala Ana Noh at mateng hula, “Taang-taang mi angu, Na uuling ateing se, manusia ang naung emangpi jasi-ahala anguba omi aabeta. Base, Na vengputus iilat hula, por-alolang anga, bot emangpi ba ue omimi angu, hapot bia. ");
INSERT INTO beu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Base, angase aana kampal nu ening. Te daeri ene gofir anguba aana metma kampal angu vengkarajang, bot eomimi angu, aana malekang ening kamar-kamar. Bot kampal eomi oa, amota oa angu, aana malekang aspal metma pakal. ");
INSERT INTO beu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kampal angu aana ening eaavening angu meter 133, eberang angu meter 22, bot ebalolu angu meter 13. ");
INSERT INTO beu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Aana malekang Kampal angu eodo pasang. Aarunge aana ening sengila se, eodo ataang angu veng adut meter vengdena. Bot eviaha angu metma abar oa angumi pasang. Kampal angu aana malekang ening omi tue. Omi nu alolang, omi nu hama mi, bot omi nu atela. ");
INSERT INTO beu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Venganit aaung-aaung! Eningse Na etatabit Jar eele at hela metma por-alolang anga vengtering, senge emangpi ba burang iivang aabetat enghara veng ang naung, ening amusing-ajela. Emangpi ba ae por-alolang taang anga, eningse aaminat miosing. ");
INSERT INTO beu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aarunge aaing angu, eningse Na Nepalai angu metma aat palai, senge aaing, bot eejangu, bot ooal ang naung, bot iidat jangu ang naung, iing emangpi hama-hamat kampal angu maso. ");
INSERT INTO beu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Binanta rupa-rupa ba aabetat enghara veng ang naung, emangpi aana malekang ila pasang nu medi, lotal, bot manarang, senge iat lamal kampal angu maso, aulange ini bisa aat hama-hamat aabeta. Binanta gariang rupa-rupa, dung rupa-rupa ba burang mi aalili, bot binanta ba aadang-taata taang eera ang naung, emangpi aana malekang pasang na-nut iat kampal angu maso, senge ini bisa aabeta. ");
INSERT INTO beu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Bot naba ba bisa adang angu, aana malekang akumpul, senge emangpi baning kampal angu maso, aulange metma iimod ening, bot metma binanta ang naung di imod ening.” ");
INSERT INTO beu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Angmuse emangpi ba Lahatala Ana vengparenta tila angu, Noh ana vengkarajang eamulung. ");
INSERT INTO beu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Angmuse LAHATALA Ana Noh at mateng hula, “Taang-taang mi angu, Na uuling ateing se, nehe ba aabetat jamang anga mi angu, aaing ba eenangkolang Napangaadang mi aabetat molo-molo. Angu ebele, aaing, bot eejangu-eevaal ang naung, aaungba kampal angu maso. ");
INSERT INTO beu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Binanta ba iini bae vengpalula niang, bot iini biasat metma Napangaadang mi sadaka ening angu, aana malekang pasang bititu medi. Dung rupa-rupa burang mi aalili ang naung di, aana malekang pasang bititu medi. Aarunge binanta ba iini vengpalula angu, aana pasang na-nut medi, senge emangpi iat kampal angu maso. Aulang senge, itabaning angu eningse bisa por-alolang anga taang aabeta. ");
INSERT INTO beu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Venganit aaung-aaung! Mietang bititu maveng se, aanuar eele angu Na at hela por-alolang anga taang ebarinti vengniang, eluung bir-kua ari buta, bot bir-jala ari buta. Aulang senge, emangpi ba Na ening aadang-taata taang aabeta ang naung, ening ini aaminat miosing.” ");
INSERT INTO beu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Angmuse emangpi ba LAHATALA Ana vengparenta angu, Noh ana eamulung vengkarajang. ");
INSERT INTO beu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Uanguveng jar eeele hela por-alolang vengtering angu, Noh euumur pas mitung 600. ");
INSERT INTO beu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Jar eele hela por-alolang anga vengtering angu ebele, Noh ejangu oleve, bot oal ang naung, bot idat jangu ang naung, ing emangpi kampal angu maso, aulang senge ini bisa aabeta. ");
INSERT INTO beu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","LAHATALA Eparenta angu eamulung, binanta ba nehe vengpalula, bot bae vengpalula niang, dung rupa-rupa ba burang mi aalili, bot binanta ba aadang-taata taang eera ang naung, emangpi pasang na-nut hoa Noh aing harak, angmuse ana iat kampal angu maso. ");
INSERT INTO beu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mietang bititu tila muse, jar eele angu hela por-alolang anga vengtering. ");
INSERT INTO beu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Uanguveng angu, Noh euumur pas mitung 600, uuru emi aaru, ved emi arinu belta bititu muse, ved uanguveng anguba, burang eviaha ang naung emangpi ava abaleleng, sengmuse jar eele ava abokong hela. Bot jar ba meke iivang teding ang naung, emangpi ava apehak halut kaluar. ");
INSERT INTO beu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Bot aanuar eele hela ebarinti vengniang, eluung bir-kua ari buta, bot bir-jala ari buta. ");
INSERT INTO beu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ved uanguveng angu di, Noh ejangu oleve, oal tue angu, Sem, Yafet bot Ham, bot idat jangu ang naung, ing emangpi kampal angu maso. ");
INSERT INTO beu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Binanta gariang, binanta balevang, binanta ba aadang-taata taang eera, dung burang mi aalili, binanta aabeung ba ekura veng, bot ebet veng ang naung, ");
INSERT INTO beu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","bot emangpi ba aabetat enghara veng ang naung, pasang na-nut hoa ing veng hama-haamat kampal angu maso, emenghula Lahatala Ana vengparentat metma Noh veng at hubai tila angu edadenang. Ing emangpi masot sengmuse, LAHATALA Ana kampal eviaha angu amota oat vengtering. ");
INSERT INTO beu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Jar eele angu por-alolang anga taang hela alolang-niang, eluung mietang ari buta. Jar angu taang mamidang-mamidang, angmuse kampal angu por taang ava ahelit mida. Uanguveng jar angu taang mamaveng-mamaveng, bot etatabi taang mamidang-mamidang, angmuse kampal angu jar taang teding lamal. ");
INSERT INTO beu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Jar angu taang mamidang-mamidang alolang-niang aabu-dol ang naung vengtering, ebalolu meter bititu. ");
INSERT INTO beu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Angmuse manusia, bot binanta gariang, binanta balevang, binanta ba aadang-taata taang eera, dung rupa-rupa ba burang mi aalili, bot emangpi ba enghara veng aadang taata taang aabeta ang naung, aaminat miosing. Aarunge Noh, bot emangpi ba aing veng hama-hamat kampal omimi anguba aabeta. ");
INSERT INTO beu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Jar angu por alolang anga taang teding eluung, mietang ratunu ari iising. ");
INSERT INTO beu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Aarunge Noh, bot binanta emangpi ba aing veng kampal omimi angu Lahatala Ana bae vengtajebing niang. Angmuse, Lahatala Ana eenar ot por-alolang anga taang boning, senge jar eele angu ening ava-holong. ");
INSERT INTO beu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Jar eng ba meke iivang teding ang naung emangpi Lahatala Ana vengtering, bot burang viaha ang naung di emangpi Lahatala Ana vengtering, angmuse aanuar eele ba hela angu, barinti. ");
INSERT INTO beu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Angmuse jar ba por-alolang vengtering angu ava-holong alolang-niang. Bot mietang ratunu ari iising angu sengila muse, jar angu bae talalu balolu niang iila. ");
INSERT INTO beu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pas uuru emi bititu, ved emi arinu belta bititu uuru angu omimi muse, kampal angu dol balolu nu ene Ararat angu taang patang. ");
INSERT INTO beu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Uuru emi arinu ved ehalomang uuru angu omimi muse, jar angu ava holong hela iila, angu ebele, dol balolu ang naung etupa angu, mulai uuling ateing iila. ");
INSERT INTO beu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mietang ari buta angu lakal iila muse, Noh ana kampal eganela-viaha angu nu buka. ");
INSERT INTO beu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Angmuse Noh ana dung karu nu lapas. Dung karu angu aalilit ila-hoa sampe jar angu taata muse, ana bae bale kampal taang Noh ebele ila niang. ");
INSERT INTO beu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Angmuse Noh ana bot dung molola nu lapas, senge ateing hula, jar angu etatabit ava-holong hela iila ee, niang. ");
INSERT INTO beu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Aarunge jar angu jedung por-alolang anga emangpi vengtering sehi, angu ebele dung molola angu bae mana iiba harak mimihi niang. Base dung angu bale aalilit kampal taang ila muse, Noh ana atang taning dung angu medit metma kampal mi maso. ");
INSERT INTO beu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noh ana ading mietang bititu muse, ana bot kampal taang dung molola angu bale lapas. ");
INSERT INTO beu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ved hula baa muse, dung molola angu bale hoa Noh aing harak, bot te saitun evaa varat nu ana tapurut medit metma ai mi baning hoa. Angmuse Noh ana ateing iilat hula, jar ba por-alolang taang angu etatabit ava-holong hela iila. ");
INSERT INTO beu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noh ana bot ading sampe mietang bititu muse, ana bot bale dung molola angu lapas. Aarunge dung molola angu bae bale Noh ebele hoa niang iila. ");
INSERT INTO beu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Uanguveng Noh euumur pas mitung 601, uuru ehalomang, ved ehalomang uuru angu omimi muse, jar ba por-alolang taang teding angu, etatabi taata tila. Angmuse Noh ana kampal eganela-viaha ang naung emangpi buka, bot ana eng uuling se, meke ang naung taata tila. ");
INSERT INTO beu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Uuru emiaaru, ved emi ari aaru belta bititu, uuru angu omimi muse, por-alolang angu etatabi taata tila. ");
INSERT INTO beu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Angmuse Lahatala Ana Noh at mateng hula, ");
INSERT INTO beu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Angase iing emangpi ba kampal taang angu, aaung ba kaluar. ");
INSERT INTO beu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Binanta ba aaing veng hama-hamat kampal taang angu, benangba: binanta gariang, binanta balevang, binanta ba meke taang eera, bot dung rupa-rupa ang naung, emangpi iat kaluar! Senge ini por-alolang anga taang lamal tabaning-taheli tatoang-tatoang, por-alolang anga ening aaving.” ");
INSERT INTO beu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Angmuse Noh ejangu oleve, oal ang naung, bot oal ejangu ang naung, ing emangpi hama-hamat kampal taang kaluar hela. Binanta ba kampal taang ang naung di, emangpi nu-nut irupa angu eamulung hama-hamat kampal angu taang kaluar hela. ");
INSERT INTO beu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Angmuse Noh ana sadaka edoru ohit metma LAHATALA Enang. Binanta ba nehe bae vengpalula niang ang naung, Noh ana iiba medi, sengmuse ana metma sadaka ening doru angu taang edet atepul, senge banang tarima kasi metma LAHATALA Enang. ");
INSERT INTO beu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Uanguveng LAHATALA Ana sadaka emanema angu rasa muse, Omi etatabit sanang. Angmuse Lahatala Ana Omimi vengpikir hula, “Angase manusia angu ini jasi-ahala angu ba ening dise, Na bae kutuk metma por-alolang anga enang niang iila. Masiking kiki sehi mi ini mang jasi-ahala anguba vengpikir dise, emangpi ba aabeta angu, Na bae ening amusing-ajelat emenghula Na ening iila angu edadenang niang. ");
INSERT INTO beu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Por-alolang anga jedung ue sehi se, ooras namuding-natapa, bot ooras eihi avaning; ooras tutung, bot ooras kajavi; ooras bir taata, bot ooras aanuar; bir-kua, bot bir-jala angu, malekang taing telul ebarinti veng niang.” ");
INSERT INTO beu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Angmuse Lahatala Ana Eaaung-Ehama ba bae ebale vengniang angu metma Noh, bot oal ang naung imampi mainang, bot Ana iat mateng hula, “Iini tabaning-tahelit ening toang-rae, senge por-alolang anga ening ana aaving. ");
INSERT INTO beu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Binanta balevang ba por-alolang taang, dung burang mi aalili, bot aab tang omimi ang naung, eningse emangpi iing veng iuangmari. Emangpi angu Na metma iiatang mi abaang, senge iing ba ing vengator. ");
INSERT INTO beu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Binanta ang naung emangpi euumung angu iini bisa adang, bot te ang naung eihi angu di iini bisa adang. Emangpi angu, Na metma maiinang. ");
INSERT INTO beu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Aarunge binanta ba enghara jedung veng sehi angu, iini ekang eve angu adang ekang, se binanta enghara angu, ue eve angu omimi. ");
INSERT INTO beu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Manusia angu Na ening Nerupa angu eamulung. Angu ebele, ekang manusia angu ameang ekang, bot eve angu ekang abokong ekang. Kalo manusia, bot binanta ba manusia angu ening ana aamina se, Na malekang ebale angu metma iadana, base ing di malekang ing ening ini aamina. Hukung anga Naing ba vengbanang. ");
INSERT INTO beu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Base, iini malekang tabaning-tahelit ening toang-rae, garet ahala-taanang ahala, senge por-alolang anga bale ening ana aaving.” ");
INSERT INTO beu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Lahatala Ana bot taang mateng hula, ");
INSERT INTO beu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Angase Na etatabit Nepalai angu metma iiat palai, sampe iitabaning ang naung di ing taang. ");
INSERT INTO beu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Emangpi ba iiat hama-hamat por-alolang taang aabeta ang naung, benangba binanta gariang, binanta balevang, bot dung burang mi aalili ang naung, bot emangpi ba iiat hama-hamat kampal taang kaluar ang naung di, palai anga metma iadana. ");
INSERT INTO beu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Base Nepalai angu Na metma iiat palait hula alang: Angase emangpi ba aabeta angu, jar eele bae ing ening ini aamina niang iila, bot por-alolang anga, jar eele bae ening amusing-ajela niang iila. ");
INSERT INTO beu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ne katambe angu Na metma burang mi mea, senge metma tanda ening hula, Nepalai ba Na metma iiat palai, bot metma emangpi ba aabetat por-alolang taang ang naung iat palai tila angu, Na bae vengtajebing niang aulang ejehing-emeang. ");
INSERT INTO beu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Kalo Na bano at hoa por-alolang anga taang, bot katambe angu bano omimi ava apaleteng se, angu metma Nevengani ening, senge Na Nepalai angu venganit hula: eningse jar eele bae emangpi ba aabeta angu ening ini aamina niang, bot jar eele angu bae por-alolang anga di ening amusing-ajela niang iila. Aulang base, Nepalai angu bae eseng veng niang, kilang iing parta, bot emangpi ba aabetat enghara veng ang naung di ing parta.” ");
INSERT INTO beu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh oal naung ba at hama-hamat kampal angu taang kaluar, benangba Sem, Yafet, bot Ham. (Ham angu, Kanaan imang). ");
INSERT INTO beu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nehe emangpi ba aabetat por-alolang anga aaving anga, inang tue anga itabaning mi hoa. ");
INSERT INTO beu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh angu ekarajang ba maada-pina. Aing ba halomang-halomang anggor ebir ening. ");
INSERT INTO beu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Minu adana, Noh ana anggor na sampe veng naboa. Angu ebele ana edurat eteeng omimi tia. ");
INSERT INTO beu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham Kanaan imang angu, ana uuling imang ana edura angu ateing muse, ana bihit kaluar hela ekaku Sem, bot Yafet oleve iat sarenta. ");
INSERT INTO beu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Angmuse Sem, bot Yafet oleve noang nu medit metma iabea mi ahele, sengmuse oleve iamota venglamal teeng mi maso, senge noang angu metma imang aing vengtering. Ening aulang base, oleve bae uuling imang ana edura angu ateing niang. Seng angmuse oleve kaluar hela. ");
INSERT INTO beu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Uanguveng Noh enaboa angu barinti tila muse, naba ba oal iia ening metma adana angu ana vengmee. ");
INSERT INTO beu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Angmuse Noh ana mateng hula, “Ee! Aaing ba Kanaan imang angu! Na kutuk metma maeenang! Eningse aaing metma eekaku ang naung imalea ening! ");
INSERT INTO beu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","LAHATALA Aing tajaning! Senge Ana Eaaung-Ehama bae ebale veng niang angu metma Sem enang! Aarunge Kanaan angu, malekang metma Sem emalea ening. ");
INSERT INTO beu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Lahatala Ana Yafet emihing-mana angu ening berang; Bot Yafet etabaning ang naung, malekang Sem etabaning ang naung iat aabetat tominu-tahanu. Aarunge Kanaan angu, malekang metma Yafet emalea ening.” ");
INSERT INTO beu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Jar eele hela barinti sengmuse, Noh ana aabetat mitung 350 maveng. ");
INSERT INTO beu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Base, Noh euumur mitung 950 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Jar eele hela angu barinti muse, Noh oal ang naung ini vaal vengajai. Angaba Sem, Yafet, bot Ham, Noh oal ang naung itabaning. ");
INSERT INTO beu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet etabaning, benangba, Gomer, Magog, Madai, Yawan, Tubal, Mesek, bot Tiras. Nu-nut ihur eamulung vengmateng, aabetat iaabang-ilelang eamulung, bot imihing-mana eamulung. Gomer etabaning, benangba, Askenas, Rifat, bot Togarma. Yawan etabaning, benangba, Elisa, Tarsis, Kitim enehe ang naung, bot Dodanim ba tang eadil mi mihi angu. ");
INSERT INTO beu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham etabaning, benangba, Kus, Misraim, Put, bot Kanaan. ");
INSERT INTO beu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus etabaning, benangba, Seba, Hawila, Sabta, Raema, bot Sabteka. Raema etabaning, benangba, Syeba, bot Dedan. ");
INSERT INTO beu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ana vaal mehal nu vengajai angu ene Nimrod. Aing ba kapala malibal halomang-halomang, bot Nimrod ana etatabit lumul-kavasar. ");
INSERT INTO beu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Elumul-kavasar angu Lahatala ba metma maenang. Base ana etatabit pintar binanta vengkori. Angu ebele nehe biasat vengbanang hula, “Aaing Lahatala Apangaadang mi lumul-kavasar emenghula Nimrod edadenang.” ");
INSERT INTO beu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod eparenta halomang-halomang angu, mulai Babel, Erek Akad, bot Kalne mi. Bendar ba Nimrod ana parenta anga naung emangpi ue Sinear mi. ");
INSERT INTO beu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Angmi muse, ana ila bendar Asyur di parenta. Angmuse ana bendar Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO beu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","bot Resen ba ue bendar Niniwe, bot Kala ehahama mi angu bakung atahing. Anga emangpi anga naung bendar eele. ");
INSERT INTO beu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim etabaning, benangba, nehe Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO beu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim, bot Kaftorim ang naung. Filistin enehe ang naung idat-imang ba, Kasluhim enehe ang naung. ");
INSERT INTO beu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan oal mutu, benangba, Sidon. Het enehe, ");
INSERT INTO beu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi enehe, Amori enehe, Girgasi enehe, ");
INSERT INTO beu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi enehe, Arki enehe, Sini enehe, ");
INSERT INTO beu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi enehe, Semari enehe, bot Hamati enehe ang naung, idat-imang ba Kanaan angu. Kanaan etabaning ang naung aabeta tare-teapahing, base ini teolat mihi. ");
INSERT INTO beu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Angu ebele, imihing-mana angu, mulai Sidon mi, ila Gerar mi, sampe ila Gasa mi. Bot Sodom mi, Gomora mi, Adma mi, Seboim mi, bot sampe ila Lasa mi. ");
INSERT INTO beu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ing emangpi angu, Ham etabaning. Nu-nut ihur eamulung vengmateng, aabetat iaabang-ilelang eamulung, bot imihing-mana eamulung. ");
INSERT INTO beu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Eber etabaning ang naung idat-imang ba, Sem Yafet ekaku mutu angu. ");
INSERT INTO beu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem etabaning, benangba, Elam, Asyur, Arpaksad, Lud, bot Aram. ");
INSERT INTO beu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram etabaning, benangba, Us, Hul, Gerar, bot Mas. ");
INSERT INTO beu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad ana Sela vengajai. Bot Sela ana Eber vengajai. ");
INSERT INTO beu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ana vaal mehal aaru vengajai. Emutu angu ene, Pelek (evengbanang tarang se hula, ꞌtaing paulꞌ), se uanguveng angu nehe ang naung ini taing paul mihit por-alolang anga miipi angu ebele. Pelek ekaku iia angu ene, Yoktan. ");
INSERT INTO beu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan etabaning, benangba, Almodad, Selef, Hasar-Mawet, Yera, ");
INSERT INTO beu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO beu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO beu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, bot Yobab. Ing anga naung emangpi, Yoktan etabaning. ");
INSERT INTO beu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Imihing-mana eved danangoa angu aabu-dol, benangba mulai Mesa mi, sampe ila Sefar mi. ");
INSERT INTO beu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ing emangpi angu, Sem etabaning. Nu-nut ehur eamulung vengmateng, aabetat iaabang-ilelang eamulung, bot imihing-mana eamulung. ");
INSERT INTO beu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Anga naung emangpi anga, Noh oal-idat. Nu-nut itabaning eamulung, bot iaabang-ilelang eamulung. Bot ing anga naung ba, jar eele barinti sengmuse, ini tarae-teapahing lamal mihit por-alolang anga ening aaving anga. ");
INSERT INTO beu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tura-tura angu, nehe ba por-alolang taang aabeta ang naung emangpi hur nu kolang vengmateng. ");
INSERT INTO beu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Uanguveng angu, nehe iiba angu tahit lamal ila ved danangoa angmi muse, ini Sinear mi bir babira nu harak, angmuse ini angumi mihi. ");
INSERT INTO beu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Ing emangpi itomi nu bot itat mateng hula, “Kaku naung! Mahe pi bendar eele nu ening. Pi malekang batu bata vengkarajang, bot iiat ening aaung-aaung. Senge pi aspal paket pasang metma taing taang amihing. Bot hava odo balolu nu etupa angu sampe burang mi, pi bakung atahing, senge pi piene aalaping. Aulang senge, ping emangpi aabetat bangsa eele nu kolang omimi, bot pi ekang por-alolang anga taang tarae-teapahing ekang.” ");
INSERT INTO beu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Angmuse LAHATALA Ana hela bendar ba ini ening, bot hava odo balolu ba ini bakung atahing angu euuling. ");
INSERT INTO beu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Angmuse Lahatala Ana mateng hula, “Manusia anga naung ing emangpi aabetat bangsa nu kolang, bot ini hur nu kolang vengmateng. Anga uhavede sehi se, ini ening alang. Kalo ing emangpi aabetat nu kolang alang sampe tobang-tiangaaru se, naba ba ini bae ening niang. Base mulai vede angase, naba ba ini veng iomit hula ening angu, emangpi bae lamal niang. ");
INSERT INTO beu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Lebe miaaung Pi hela ing ening ini tarae-teapahing, senge ini hur tatarat vengmateng. Aulang senge ing emangpi nu-nut ekang itaing manggarati ekang.” ");
INSERT INTO beu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Angmuse Lahatala Ana hela ing ening ini tarae-teapahing, bot ihur angu ening tarahak-tavetang. Base ini tarae-teapahing lamal mihit por-alolang anga miipi. Bot ini bae bendar angu taang ening niang iila. ");
INSERT INTO beu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Angu ebele bendar angu ini ene maveng hula, Babel, (evengbanang tarang se hula, ꞌTarahak-tavetangꞌ), se angumi ba LAHATALA Ana ihur angu ening tarahak-tavetang, bot ing ening ini tarae-teapahing ila por-alolang anga miipi angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Anga Sem etabaning. Sem euumur pas mitung 100, bot jar eele hela barintit mitung aaru muse, ana vaal mehal nu vengajai, ene Arpaksad. ");
INSERT INTO beu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Angmuse Sem ana jedung aabetat mitung 500 maveng, angu ebele vaal mehal, bot vaal jangu di Sem ana taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad euumur mitung 35 muse, ana vaal mehal nu vengajai, ene Sela. ");
INSERT INTO beu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Angmuse Arpaksad jedung aabetat mitung 403 maveng, angu ebele vaal mehal, bot vaal jangu di Arpaksad ana taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela euumur mitung 30 muse, ana vaal mehal nu vengajai, ene Eber. ");
INSERT INTO beu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Angmuse Sela jedung aabetat mitung 403 maveng, angu ebele vaal mehal, bot vaal jangu di Sela ana bot taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber euumur mitung 34 muse, ana vaal mehal nu vengajai, ene Pelek. ");
INSERT INTO beu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Angmuse Eber ana jedung aabetat mitung 430 maveng, angu ebele vaal mehal, bot vaal jangu di Eber ana bot taang vengajai. ");
INSERT INTO beu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek euumur mitung 30 muse, ana vaal mehal nu vengajai, ene Rehu. ");
INSERT INTO beu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Angmuse Rehu ana jedung aabetat mitung 209 maveng, angu ebele vaal mehal, bot vaal jangu di Pelek ana bot taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu euumur mitung 32 muse, ana vaal mehal nu vengajai, ene Seruk. ");
INSERT INTO beu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Angmuse Rehu ana jedung aabetat mitung 207 maveng, angu ebele vaal mehal, bot vaal jangu di Rehu ana tang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk euumur mitung 30 muse, ana vaal mehal nu vengajai, ene Nahor. ");
INSERT INTO beu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Angmuse Seruk ana jedung aabetat mitung 200 maveng, angu ebele vaal mehal, bot vaal jangu di Seruk ana taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor euumur mitung 29 muse, ana vaal mehal nu vengajai, ene Tera. ");
INSERT INTO beu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Angmuse Nahor ana jedung aabetat mitung 119 maveng, angu ebele vaal mehal, bot vaal jangu di ana bot taang vengajait maveng. ");
INSERT INTO beu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera eumur mitung 70 muse, ana vaal mehal tue vengajai, benangba, Abram, Nahor, bot Haran. ");
INSERT INTO beu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Anga Tera etabaning. Tera ana vaal mehal tue vengajai benangba, Abram, Nahor, bot Haran. Haran ana vaal mehal nu vengajai, ene Lot. ");
INSERT INTO beu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Uanguveng Tera Haran imang angu jedung aabeta sehi se, Haran ana eaabang Ur-Kasdim mi aamina. ");
INSERT INTO beu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram, bot Nahor oleve jangu medi. Abram ejangu angu, ene Sarai. Nahor ejangu angu, ene Milka, Haran oal. Haran di vaal mehal nu vengajai, ene Yiska. ");
INSERT INTO beu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Aarunge Sarai angu atou pamar-jasi, base ana bae vaal veng niang. ");
INSERT INTO beu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Minu adana, Tera ana oal Abram, bot idat jangu Sarai, bot idat Lot, iat lamal kaluar iaabang Ur eahalang, senge hula Kanaan mi ila. Aarunge ini ila Haran aabang mi muse, ini angumi mihi. ");
INSERT INTO beu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ila Haran mi muse, Tera euumur pas mitung 205, angmuse Tera ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","LAHATALA Ana Abram at mateng hula, “Abram! Aaungba aana tahit lamal iimang ehava omi, eeaabang-eelelang, bot eehava omi enehe ang naung iadu, senge mana nu eningse Na metma eetubing angu mi ila. ");
INSERT INTO beu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Eningse aaung-hama ba bae ebale veng niang angu, Na metma maeenang. Base eetabaning angu eningse toang-rae, senge metma bangsa eele ening, base eene angu taang-taang mi dise nehe malekang vengbanang. Bot aana Neamulung base, nehe aabeung ang naung di eningse emangpi aaung-hama ba bae ebale veng niang angu metma ioa. ");
INSERT INTO beu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nehe ba aaung-hama ening metma aadana angu, eningse Na aaung-hama ba bae ebale veng niang angu metma mainang. Aarunge nehe ba kutuk metma aadana angu, eningse Na kutuk metma mainang. Vengmeet aaung-aaung! Aana aabetat aaung-hama angu ebele, eningse bangsa ba ae por-alolang taang anga, emangpi aaung-hama angu harak. ");
INSERT INTO beu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Angmuse Abram ana tahit lamal LAHATALA Eparenta angu eamulung, bot Lot di at hama-hamat ila. Uanguveng Abram ana Haran mi tahit lamal angu euumur pas mitung 75. Abram ana ejangu Sarai, ekaku oal Lot, bot nehe ba Haran mi ana ing metma emalea ening ang naung, emangpi iat ila. Bot epasaka ang naung di emangpi ana baning. Angmuse Abram iimal ini tahit lamal ila Kanaan mi, mana ba Lahatala Ana matubing iila angu mi. ");
INSERT INTO beu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ila Kanaan mi muse, Abram ana lamal mana angu migoleng, sampe ila aabang nu ene Sikem angu abung. Angmuse ini More mi te eele nu ue angmi tahi angu abung mihit vengtahang. Uanguveng angu, Kanaan enehe ang naung di jedung angmi mihi sehi. ");
INSERT INTO beu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Angumi, LAHATALA Ana Ava metma Abram etubing, bot at mateng hula, “Aabang anga eningse Na metma eetabaning ang naung inang.” Angmuse Abram ana angumi sadaka edoru nu ohit metma LAHATALA ba Ava metma etubing iila angu Enang. ");
INSERT INTO beu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Angmuse Abram iimal bot iava asorong ila Betel eved danagoa angmi dol nu angu taang. Ini Betel aabang, bot Ai aabang ehahama angmi teeng dodu, sengmuse mi mihit vengtahang. Angumi Abram ana bot sadaka edoru nu ohi, bot ana LAHATALA Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Seng angmuse Abram bot tahit lamal taang olat maveng, sampe ila kanaan etang eoa, mana nu ene Negeb angu mi. ");
INSERT INTO beu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Uanguveng Kanaan mi angu, malapal-tabonggal eele hela muse, Abram ana lamal taang olat maveng, sampe ila Masir aabang mi. Senge ini angumi mihit vengtahang. ");
INSERT INTO beu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Uanguveng ini ila hula Masir aabang maso muse, Abram ana ejangu Sarai at mateng hula, “Na ateing se, aaing anga aapang angu etatabit mahena. ");
INSERT INTO beu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kalo Masir enehe ang naung ini uuling aateing se, ini hula, aaing nejangu, base ini nameang senge ini aaing medi. ");
INSERT INTO beu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Base lebe miaaung aana iat mateng hula, aaing angu, nekaku. Ening aulang senge, ini aaung anguba ening metma nadana, bot ini ekang nameang ekang, se aaing angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram ila Masir mi tila muse, Masir enehe ang naung uuling iateing se, nehe jangu angu etatabit mahena. ");
INSERT INTO beu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Bot uanguveng raja Firaun enehe ang naung uuling Sarai ateing muse, ini Firaun apangaadang mi Sarai emahena angu tajaning. Angu ebele nehe jangu angu ini at ila raja eistana mi. ");
INSERT INTO beu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Raja Firaun ana etatabit Sarai aing suka, se Sarai etatabit mahena angu ebele. Base raja Firaun ana Abram aing sambut aaung-aaung, bot ana binanta jumba, aib, arbo-sapi, keledei, bot unta metma Abram enang. Raja Firaun ana malea mehal, bot malea jangu di metma Abram enang. ");
INSERT INTO beu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Aarunge LAHATALA Ana kutuk rupa-rupa metma raja Firaun, bot enehe ba eistana mi ang naung emangpi ing taang mea, se ana Abram ejangu at ila eistana mi angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Angmuse raja Firaun ana Abram earu bot adangtaaning hula, “Abram! Naba ba aana ening metma nadana anga? Etatalang ba aana bae vengbanang hula, nehe jangu angu eejangu niang? ");
INSERT INTO beu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Bot etatalang ba aana vengbanang hula, aing eekaku, angu ebele na aing medit metma nejangu ening? Angase aaungba aana eejangu anga aing medit at ila, senge napangaadang anga eahalang!” ");
INSERT INTO beu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Angmuse raja Firaun ana enehe inang aaeedeng ing parentat iot Abram, bot ejangu oleve, bot epasaka ang naung emangpi veng, ing aantar kaluar, ila aabang angu eahalang. ");
INSERT INTO beu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Angmuse Abram ana lamal Masir aabang eahalang, sengilaba bale ila Negeb mi. Ejangu Sarai, bot epasaka ang naung di emangpi ana baning ila. Ekaku oal Lot di at hama-hamat ila. ");
INSERT INTO beu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram angu, etatabit kavasa. Ebinanta gariang, bot mas-perak di etatabi toang. ");
INSERT INTO beu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mana nu mi Abram ana mihit vengtahang seng angse, ana bot ava asorong lamal ila mana aabeung mi. Base Negeb mi muse, Abram ana bot ava asorong lamal ila Betel aabang, bot Ai aabang ehahama, mana ba ana tura eteeng metma mi atahing iila angu mi. ");
INSERT INTO beu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Bot Abram ana tura angmi sadaka edoru ohi tila, base ana angumi LAHATALA Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot ba Abram at lamal hama-hamat ila angu di, ebinanta gariang toang, bot emalea di toang. ");
INSERT INTO beu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Aarunge mana ba ini mi mihi angu bae berang niang, bot oleve ipasaka etatabi toang, base oleve bae bisa hama-hamat angumi mihi niang. Angu ebele Abram eterangvala, bot Lot eterangvala ang naung ini tota, se dadi-napa ba mana angu mi angu, ibinanta ang naung emangpi adang di, bae ing vengpas niang angu ebele. (Uanguveng angu, Kanaan enehe, bot Feris enehe ang naung di, jedung ue angmi mihi sehi.) ");
INSERT INTO beu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Angmuse Abram ana oal Lot at mateng hula, “Poleve anga imang-vaal. Base poleve ekang tota ekang, bot piterangvala ang naung di ekang tota ekang. ");
INSERT INTO beu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mana anga eoang anga berang. Angu ebele lebe miaaung poleve tatara. Base kalo aana bajaul eoat ila se, naing tene eoat ila. Kalo aana tene eoat ila se, naing bajaul eoat ila.” ");
INSERT INTO beu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Angmuse Lot ana apang ohit uuling se, kakura-omi ba Yarden moar eoang mi angu ejar toang, sampe Soar aabang mi. Mana angu etatabit aabua emenghula LAHATALA Ebir edadenang, bot emenghula Masir aabang edadenang. (Uanguveng angu, bendar Sodom, bot Gomora angu LAHATALA Ana bae ening amusing-ajela jedung, base emeke angu jedung aabua.) ");
INSERT INTO beu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Angu ebele Lot ana kakura-omi ba Yarden moar eoang mi angu vengtalail medi, sengmuse ana lamal ved danangoat ila, bot Abram oleve tatara. ");
INSERT INTO beu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram aing kilang Kanaan mi mihi, aarunge Lot aing ila aabang ba kakura-omi Yarden moar mi, bendar Sodom abung angu mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Aarunge bendar Sodom enehe ang naung etatabit jasi-ahala angu ba ening, bot ini bae LAHATALA angu eamulung niang. ");
INSERT INTO beu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Uanguveng Lot ana Abram at tatara tila muse, LAHATALA Ana Abram at mateng hula, “Abram! Mana ba aana mi tahi angu, bot mana aabeung ang naung di, aanake emangpi euuling migoleng, ved baangoa, ved danangoa, ujangoa, bot tangoa. ");
INSERT INTO beu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mana ba aana uuling ateing ang naung, eningse emangpi Na metma maeenang, bot metma eetabaning ang naung inang, senge metma iipasaka ening aulang ejehing-emeang. ");
INSERT INTO beu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Bot eetabaning angu eningse Na ening toang-rae, etoang angu emenghula meke kajala angu edadenang. Base eetabaning etoang angu nehe garet jadi niang, bot taanang jadi niang. ");
INSERT INTO beu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Angase aava vengharaka, senge lamal mana anga migoleng, eaavening, bot etukang angu eamulung. Se emangpi angu, eningse Na metma maeenang angu ebele!” ");
INSERT INTO beu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Seng angmuse Abram ana bot eteeng angu asorong, sengilaba ila Hebron aabang abung, Mamre mi te eele abung angmi mihi. Angmuse Abram ana sadaka edoru ohi, bot angmi LAHATALA Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Uanguveng raja buta anga ijamang mi. Benagba: Amrafel, Sinear aabang eraja. Ariok, Elasar aabang eraja. Kedarlaomer, Elam aabang eraja. Bot Tideal, Goim aabang eraja. ");
INSERT INTO beu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Raja anga naung ini tominu senge, Bera, Sodom aabang eraja. Birsa, Gomora aabang eraja. Sinab, Adema aabang eraja. Semeber, Seboim aabang eraja. Bot Bela aabang eraja (benangba Soar aabang) ang naung iat malibal. Raja buta angu ini malibal raja iising aabeung angu ing lavang. ");
INSERT INTO beu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Raja iising angu ing emangpi itominu sengmuse itentara veng hoa Sidim ekakura-omi angu mi, (angase mana angu ini ene vengbanang hula Tang aamina). ");
INSERT INTO beu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ini itat malibal angu alang: Tura angu, raja iising anga ini Raja Kedarlaomer aing vengtou sampe mitung 12. Aarunge tung emi 13 muse, raja iising anga bale tahit raja Kedarlaomer aing lavang. ");
INSERT INTO beu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Angu ebele, tung emi 14 muse, Raja Kedarlaomer, bot eserang raja tue angu itentara veng hoa muse, ini aabang aaeedeng enehe ang naung iat malibal ening iora-vengholong. Benangba: Rafaim enehe Asterot-Karnaim aabang mi, Susim enehe Ham aabang mi, Emim enehe Sawe-Kiryataim aabang mi, ");
INSERT INTO beu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","bot Hori enehe ba Seir edol taang, sampe mana osing ba El Paran eadil mi angu mi. ");
INSERT INTO beu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Angmuse ini bale En Mispat mi ila. (Angase mana angu ene Kades). Seng angmuse raja buta angu ini bot Amalek enehe ang naung iaabang, bot Amori enehe ba Haseson-Tamar eaabang mi mihi ang naung di, ing ening ini iora-vengholong. ");
INSERT INTO beu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Angmuse raja iising angu ini itentara vengator, sengmuse ini hoa kakura-omi Sidim mi angu mi, raja buta angu iat malibal. ");
INSERT INTO beu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kakura-omi Sidim mi angu, taang-taang mi angu aspal ekolang toang. Uanguveng ini malibal angu, Sodom eraja etentara, bot Gomora eraja etentara ang naung ini tahit bihi muse, iiba aspal ekolang angu omimi baa. Bot iiba angu bihit dol taang mida. ");
INSERT INTO beu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Base raja buta ba uuntung angu, metma etentara veng angu ini Sodom, bot Gomora epasaka, bot emod ang naung emangpi rampas medi, sengmuse ini ila. ");
INSERT INTO beu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram ekaku oal Lot di raja buta angu ini adoi, bot epasaka ang naung di emangpi ini rampas medi, sengmuse ini at ila. Se Lot di Sodom mi mihi angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Angmuse nehe nu ava lapas bihit hoa na angu metma Abram, Ibrani enehe angu veng at sarenta. Uanguveng angu, Abram ana Amori enehe nu ene Mamre angu, ete eele Mamre mi angu abung mihi. Mamre ekaku angu, nu ene Eskol, bot nu ene Aner. Ing angu, Abram epartei. ");
INSERT INTO beu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Uanguveng Abram ana vengmee se hula, ekaku oal angu di raja buta angu ini adoit at ila tila muse, ana enehe ba pintar malibal ang naung ing kumpul. Ingba ehava omimi ing vengajai ang naung emangpi inang 318. Angmuse ini ila raja buta angu iaterit sampe ila Dan aabang mi. ");
INSERT INTO beu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Bir-kakua muse, Abram, bot enehe ang naung ini taing paul, senge nehe ang naung iat malibal. Abram iimal ini raja buta angu ing lavang, bot iaterit ila sampe Hoba aabang, bendar Damsik eutaraoa angmi. ");
INSERT INTO beu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Angmuse Abram ana Lot aing medi, Lot epasaka ang naung, bot Lot enehe ang naung di emangpi Abram ana medi, sengmuse ana iat bale. Nehe aabeung ang naung di, Abram ana iat bale. ");
INSERT INTO beu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Uanguveng Abram ana raja buta angu ing ening ini iora-vengholong sengmuse, ana bale hoa. Angmuse Sodom eraja angu ana hoa kakura-omi Sawe mi angu, mi Abram aing sambut. (Nehe biasat mana angu ene vengbanang hula, Raja Ekakura-omi). ");
INSERT INTO beu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Uanguveng angu, Melkisedek ba bendar Salem eraja. Ana roti, bot anggur baning hoa metma Abram enang. Meliksedek angu di Lahatala ba Eele-Balolu angu, Ana aing metma agama ebuangvala ening. ");
INSERT INTO beu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Angmuse Melkisedek ana aaung-hama vengbanang metma Abram enang hula, “Lahatala ba Eele-Balolu, Aing ba por-burang ening angu, Ana aaung-hama ba bae ebale veng niang angu metma maeenang. Lahatala ba Eele-Balolu angu Aing tajaning-Aing palevang, se Ana raja buta angu metma aatang mi abaang, bot aana ing ening ini iora-vengholong iila angu ebele.” Angmuse emangpi ba Abram ana rampas medit baning bale hoa angu, ebaang arinu angu ana vengator metma Melkisedek enang. ");
INSERT INTO beu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Angmuse sodom eraja angu ana Abram at mateng hula, “Nimang Abram. Pasaka emangpi ba aana bale rampas medit baning hoa ang naung, biar emangpi metma eeoa. Aarunge na aabanang, senge nenehe ang naung ba aana bale metma menenang hengi.” ");
INSERT INTO beu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Aarunge Abram ana Sodom eraja ehur angu ebalet hula, “Lahatala ba Eele-Balolu, Aing ba por-burang ening angu, na Apangaadang mi sumpa. ");
INSERT INTO beu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Eepasaka ba na baning hoa angu, na bae nu medit metma neoa di niang. Api etupa, bot sapatu esar vengdena angu di, na bae nu medi di niang. Aulang senge, eningse aana ekang vengbanang hula, ꞌNaing ba ening ba, Abram ana kavasa angu ekangꞌ. ");
INSERT INTO beu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kalo naing anga, na bae na iiba parlu niang. Aarunge taang ba nenehe ang naung ini pake tila se, angu pi bae vengbanang niang iila. Angu sengila. Aarunge Aner, Eskol, bot Mamre, neserang tue anga, biar ini nu-nut ibaang angu medit baning ila.” ");
INSERT INTO beu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Angmuse LAHATALA Ana Ava metma Abram etubing. Bot Lahatala Ana Abram at mateng hula, “Abram! Aana ekang uuangmari ekang. Nehe ba iomi metma eealalil ang naung, eningse emangpi angu, Naing ba Napang metma iadana. Bot eningse uuntung eele angu Na metma maeenang.” ");
INSERT INTO beu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Angmuse Abram ana Lahatala At mateng hula, “Eee, Nimang Lahatala. Naba ba Aana hula metma manenang se, naing anga bae vaal veng niang. Aana bae tabaning metma manenang niang, base kalo na aamina se, nemalea Eliasar Damsik enehe anguba eningse nehava mi mihi. Bot emangpi angu eningse nemalea anguba medi.” ");
INSERT INTO beu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Aarunge LAHATALA Ana Abram at mateng hula, “Bae aulang niang! Eningse ooal mamolo anguba metma eemana mi, bot eepasaka ang naung eningse ooal anguba medi. Aarunge eemalea angu niang.” ");
INSERT INTO beu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Angmuse LAHATALA Ana Abram at kaluar, bot Ana Abram at mateng hula, “Abram! Aanake burang euuling, senge iid burang mi angu gare. Kalo iid etoang angu aana bisa gare se, eetabaning etoang angu, eningse emenghula iid burang mi angu edadenang!” ");
INSERT INTO beu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Angmuse Abram ana omi metma LAHATALA Emateng angu vengaanamang. Base LAHATALA Ana bae Abram eomi angu vengtajebing niang, se Abram ana aaung anguba ening angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","LAHATALA Ana bot Abram at mateng hula, “Naing anga ba Lahatala. Naing ba Ur-Kasdim aabag mi aat lamal kaluar, bot aabang anga metma maeenang, senge metma eepasaka ening angu.” ");
INSERT INTO beu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aarunge Abram ana mateng hula, “Ya Nimang LAHATALA! Tatalang senge na bisa ateing hula, aabang anga eningse metma nepasaka ening?” ");
INSERT INTO beu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Lahatala Ana Abram at mateng hula, “Angase aana malekang binanta anga naung medit metma maNenang. Benangba; Sapi manarang nu euumur mitung tue, aib manarang nu euumur mitung tue, jumba manarang nu euumur mitung tue, dung kurung-kurung nu, bot dung molola oal nu.” ");
INSERT INTO beu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Angmuse Abram ana ila binanta ang naung emangpi medit metma LAHATALA Enang. Sapi, aib, bot jumba angu Abram ana nu-nut akahit ening oang aaru, sengmuse ana metma meke taang taingveng piling mea, ening baris aaru. Aarunge dung ang naung Abram ana bae akahit ening aaru niang. ");
INSERT INTO beu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Uanguveng dung balevang ba lumul ang naung hoa hula binanta ang naung euumung angu adang muse, Abram ana iateri. ");
INSERT INTO beu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ved ba muse, Abram ana tiat udu. Abram ana iipal na se hula, kua-kete hela aing vengtering, angu ebele ana etatabit uangmari. ");
INSERT INTO beu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Angmuse LAHATALA Ana Abram at mateng hula, Abram! Aana venganit aaung-aaung! Eningse aana aabetat sampe bomat etatabi senge aana aamina. Bot eningse nehe aaing taloul aaung-aaung. Aarunge eetabaning ang naung eningse ini ila aabang aabeung nu, bae iaabang mamolo niang angu mi mihi, senge ing metma nehe hoangmanang ening. Bangsa ba ue aabang angu mi angu, eningse ini eetabaning ang naung ing metma imalea ening, bot ing ening susa-lala sampe mitung ratu buta. Aarunge bangsa ba ing metma imalea ening angu, eningse Na ing hukung. Sengilaba Na angumi eetabaning ang naung iat lamal kaluar, bot pasaka toang eningse ini baning bale. ");
INSERT INTO beu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eetabaning emibuta angu, eningse Na ing vengator, senge ini bale hoa angami. Amori enehe ang naung angase ini aabang anga mi mihi sehi. Nehe anga naung etatabit jasi-ahala anguba ening, aarunge bae ekanap mi jedung. Ooal-iidat ang naung kalo ini bale hoa angami tila se, Na ing pake, senge Amori enehe ang naung ing ening ini musi-jela. Se sampe uanguveng angse, Amori enehe ang naung ijasi-ahala angu ekanap mi tila, angu ebele Na ing hukung.” ");
INSERT INTO beu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Uanguveng angu ved baa tila, bot hula bir-kua muse, mibaroti se, aad huring nu ebanak veng, bot muhu viling nu veng, ue lamal uumung baris aaru ehahama angu milakal. ");
INSERT INTO beu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Uanguveng anguba LAHATALA Ana Epalai angu metma Abram veng at mateng. Lahatala Ana mateng hula, “Abram! Na aat palai. Mana anga eoang anga eningse Na metma eetabaning ang naung inang, mulai Masir, sampe Efrat moar angu mi, ");
INSERT INTO beu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","benangba, Keni enehe, kenas enehe, Kadmon enehe, ");
INSERT INTO beu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het enehe, Feris enehe, Refaim enehe, ");
INSERT INTO beu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori enehe, Kanaan enehe, Girgasi enehe, bot Yebus enehe ang naung imeke angu.” ");
INSERT INTO beu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Sarai Abram ejangu angu, bae vaal veng niang. Sarai emalea jangu nu Masir enehe angu, ene Hagar. Minu adana, Sarai ana emehal Abram at mateng hula, “Nimang! Aana ateing se, LAHATALA Ana nevaal emana angu vengtering, base na bae vaal vengajai niang. Angu ebele, lebe miaaung aana nemalea Hagar angu abung tia, misavaka aing ba vaal nu vengajait metma manenang.” Angmuse Abram ana ejangu Sarai emateng angu eamulung. Uanguveng angu, Abram ana Masir mi bale hoa Kanaan mi mihit mitung arinu tila. Base Sarai ana emalea Hagar angu metma emehal Abram enang, senge metma ejangu gariang ening. ");
INSERT INTO beu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram ana Hagar abung tia muse, Hagar atou veng. Aarunge uanguveng Hagar ateing hula atou veng iila muse, Hagar ana bae emanaing Sarai angu aing paduli niang. ");
INSERT INTO beu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Angu ebele, Sarai ana emehal Abram at mateng hula, “Naing ba nemalea angu metma maeenang senge metma eejangu gariang ening. Aarunge nehe jangu angu uhavede ateing hula ana oora tila muse, ana bae naing padulu niang iila. Naba ba ana ening metma nadana anga, emangpi angu aaing ba malekang vengurus! Angase LAHATALA ba poleve pi parkara anga vengputus. Aulang senge aana ateing!” ");
INSERT INTO beu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Angmuse Abram ana ejangu Sarai ehur angu ebalet hula, “Eemalea angu, aaing ba aing parenta senge ana eamulung. Base, naba ba aana ateing hula aaung se, ening metma adana!” Angmuse Sarai ana bae Hagar at aaung niang iila, angu ebele Hagar ana tahit bihit Sarai eahalang. ");
INSERT INTO beu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar ana bihit sampe ila mana osing eele nu angu mi muse, LAHATALA Egahingvala sorga mi nu hoa jar eng ba via Sur mi ila mi angu, abung angmi aing harak. ");
INSERT INTO beu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Angmuse Lahatala Egahingvala sorga mi angu ana Hagar adangtaaning hula, “Ee! Hagar, Sarai emalea! Etatalang ba aana ae angami? Aana taang mi ba hoa, bot aana hula taang mi ila?” Hagar ana Lahatala Egahingvala sorga mi angu ebalet hula, “Na bihit nemanaing Sarai eahalang.” ");
INSERT INTO beu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Angmuse LAHATALA Egahingvala sorga mi angu ana Hagar asenang hula, “Aaung ba aana bale eemanaing angu ebele ila. Ana ening tatalang metma aadana dise, aana malekang vengtahang. ");
INSERT INTO beu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Uuangmari ekang. Eetabaning angu, eningse na ening etatabi toang-rae, base etoang angu nehe garet jadi niang. ");
INSERT INTO beu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Angase aatou veng iila. Luung niang se, aana vaal mehal nu vengajai. Base aana malekang ene maveng, ene Ismael (evengbanang tarang se hula, ꞌLahatala Ana vengmeeꞌ), se naba ba eemanaing ana ening metma aadana angu, LAHATALA Ana vengmee tila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Vaal mehal ba aana vengajai angu kalo ana eele se, elamal-etahi angu emenghula keledei balevang edadenag. Nuba-nuba di, eningse ana ing lavang, base nehe emangpi angu eningse bale tahit aing lavang. Bot emihing mana mi angu, ana bae ekaku ang naung iat aabetat aaung niang.” ");
INSERT INTO beu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Vengmeet aulang muse, Hagar ana omimi mateng hula, “LAHATALA ba neuuling, bot Aing ba naing jaga angu, na uuling ateing iila.” Hagar ana Lahatala ba at mateng iila angu Ene vengbanang hula, “Lahatala ba naing paduli.” ");
INSERT INTO beu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Angu ebele jar eng vede angu nehe ene maveng hula, Beer Lahai Roi, evengbanang tarang se hula, “Lahatala ba aabeta, Aing ba naing paduli tila angu, Ejar eng.” Jar eng angu ue Kades aabang, bot Beret aabang ehahama angu mi. Angase, jar eng angu jedung ue. ");
INSERT INTO beu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Angmuse Hagar ana bale ila. Hagar ana vaal mehal nu vengajai muse, Abram ana vaal angu ene maveng, ene Ismael. ");
INSERT INTO beu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram euumur mitung 86 muse, Hagar ana Ismael aing vengajait metma Abram enang. ");
INSERT INTO beu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Uanguveng Abram euumur mitung 99 muse, LAHATALA Ana Ava metma etubing. Lahatala Ana Abram at mateng hula, “Naing anga, Lahatala ba Mikavasa angu. Aana malekang aabetat NeNomi anguba eamulung, bot aabetat molo-molo. ");
INSERT INTO beu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Na hula Nepalai angu metma aat palai, bot eetabaning angu ening toang-rae.” ");
INSERT INTO beu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Angmuse Abram ana kuku muding, bot tout hela meke mi. Bot Lahatala Ana at mateng hula, ");
INSERT INTO beu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Na Nepalai angu metma aat palait hula, alang: eningse aaing metma bangsa toang idat-imang ening. Angu ebele, angase eene bae Abram niang iila, (evengbanang tarang se hula, ꞌnehe boma ene vengꞌ), aarunge angase eene Abraham, (evengbanang tarang se hula, ꞌbangsa toang idat-imangꞌ). ");
INSERT INTO beu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ooal-iidat angu eningse Na ening etatabi toang-rae. Senge metma bangsa toang ening, bot eetabaning ang naung eningse toang Na ing ohit metma raja ening. ");
INSERT INTO beu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nepalai anga Na metma aaing parta, bot metma eetabaning ang naung di ing partat aulang ejehing-emeang, senge Naing metma eeLahatala ening, bot metma eetabaning ang naung di, iLahatala ening. ");
INSERT INTO beu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Meke Kanaan mi ba aana ae mi mihit emenghula nehe hoang manang edaenang anga, emangpi eningse Na metma maeenang, bot metma eetabaning ang naung inang, senge metma ipasaka ening aulang ejehing-emeang. Bot eningse Naing metma iLahatala ening. ");
INSERT INTO beu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Aarunge Nepalai anga di, aaing, bot eetabaning ang naung, iini malekang pinat aanamang. Benangba, nehe mehal ang naung, emangpi malekang sunat. ");
INSERT INTO beu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Base, angase aana malekang sunat. Senge sunat angu metma poleve palai tila angu etanda ening, eeaabetang omimi. Angu ebele, nehe mehal ba euumur mietang tuaru tila angu, emangpi malekang sunat. Benangba, nehe mehal ba ue iihahama mi tabaning-taheli angu. Eehava omi enehe, eemalea, bot aabang aabeung enehe ba aana belit metma eemalea ening ang naung, emangpi malekang sunat. Base Nepalai angu kilang iiaabua omi mi jehit aulang ejehing-emeang. ");
INSERT INTO beu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nehe mehal ba bae sunat niang angu, malekang iihahama angumi ening ana ue niang, se ana bae Nepalai angu eamulung niang angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Angmuse Lahatala Ana bot Abraham at mateng hula, “Eejangu Sarai angu, angase aana ekang earut hula, Sarai ekang, aarunge earut hula, Sara. ");
INSERT INTO beu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Eningse aaung-hama ba bae ebale veng niang angu Na metma eejangu Sara enang, senge ana vaal mehal nu vengajait metma maeenang. Eningse eejangu Sara angu aing metma bangsa toang iva ening, bot eningse etabaning angu toang Na ing ohit metma raja ening.” ");
INSERT INTO beu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Angmuse Abraham ana tout hela meke mi, bot palela, sengilaba ana omimi mateng hula, “Nehe mehal ba boma tila, euumur mitung 100 emenghula naing edadenang alang anga di, oma bisa jedung vaal veng sehi ka? Bot nejangu Sara di memet lolobahi tila, euumur mitung 90 tila se, tatalang senge ana bisa vaal veng?” ");
INSERT INTO beu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Angmuse Abraham ana Lahatala At hubait hula, “Ah, Nimang Lahatala. Biar nepasaka ang naung Ismael ba medi di aaung.” ");
INSERT INTO beu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Aarunge Lahatala Ana Abraham at mateng hula, “Niang! Eningse eejangu Sara ba vaal mehal nu vengajait metma maeenang. Base aana ene maveng, ene Isak. Nepalai angu eningse hela aing taang, bot Isak etabaning ang naung di ing taang, aulang ejehing-emeang. ");
INSERT INTO beu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Naba ba aana banang metma Ismael adana angu, Na vengmee tila. Andi aaung-hama ba bae ebale veng niang angu, Na metma maenang. Etabaning angu di, eningse Na ening toang-rae, bot etabaning ang naung eningse iiba metma lelang 12 ekapala ening. Bot etabaning angu di, eningse metma bangsa eele nu ening. ");
INSERT INTO beu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aulang aarunge Nepalai anga, ooal Isak ba tung nu, oma ooras alang se eejangu Sara ana aing vengajai anguba, Na metma aing parta.” ");
INSERT INTO beu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mateng aulang sengmuse, Lahatala Ana mida Abraham eahalang. ");
INSERT INTO beu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Seng angmuse, ved uanguveng angu di, Abraham ana sunat, Lahatala Eparenta angu eamulung. Abraham ana oal Ismael di earu, bot nehe mehal ba ue ehava omimi, bot nehe ba ana seeng metma ing belit metma emalea ening ang naung di, emangpi ana iaru, seng muse ana ing sunat. Uanguveng angu, Abraham euumur mitung 99 muse ana sunat. Bot Ismael euumur mitung 13 muse, Abraham ana aing sunat. ");
INSERT INTO beu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Uanguveng angu, Abraham ana te eele ba Mamre mi angu abung angmi mihi. Minu adana, ved alil Abraham ana eteeng eviaha mi mihi sehi se, Lahatala Ana Ava metma etubing. ");
INSERT INTO beu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Uanguveng Abraham ana apang ohit uuling se, nehe tue ue apangaadangoa angmi tahi sehi. Abraham ana uuling iateing muse, ana uuser-uuser bihit va ing sambut. Angmuse Abraham ana kuku muding, tout hela meke mi, ");
INSERT INTO beu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","bot mateng hula, “Nimang iimal! Kalo iiomi nejahi se, iini ekang lamal milalu ekang. ");
INSERT INTO beu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nimang iimal iini te eele anga iivang mihit miaari, senge jar kabingdena metma iia laming hengi. ");
INSERT INTO beu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Eningse na mod vengharakat iini adang, senge iini bisa bale daeri. Aulang senge, iini bot lamal milalu di aaung. Se nimang iimal iini hoa nemana angami naing harak iila angu ebele.” Angmuse Nehe tue angu ini Abraham ehur angu ebalet hula, “Angu di aaung. Naba ba aana vengbanang angu, ni eamulung.” ");
INSERT INTO beu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Angmuse Abraham ana bihit teeng mi maso ejangu Sara at mateng hula, “Uuser! Tarigu aaung angu sak nu medit aado, senge metma roti ening.” ");
INSERT INTO beu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham ana bot bihit ila esapi oal eboa eere nu medi, sengmuse ana metma emalea nu enang ot vengkarajang, senge euumung angu doat ening aaung-aaung. ");
INSERT INTO beu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sengmuse Abraham ana susu, keju, bot uumung ba doat liang iila angu, medit metma nehe tue angu inang ini adang. Uanguveng nehe tue angu te eele iivang angmi mihit naadang sehi muse, Abraham ana iabung tahit iuuling, senge ing vengbalenta. ");
INSERT INTO beu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nehe tue angu ini Abaraham adangtaaning hula, “Abraham! Eejangu Sara ue taang mi?” Abraham ana nehe tue itaaning angu ebalet hula, “Ana doe teeng omimi.” ");
INSERT INTO beu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Angmuse nehe tue angu, nu mateng hula, “Na etatabit aat mateng! Tung nu Na bale hoa aaing harak se, uanguveng anguba eejangu Sara ana vaal mehal nu vengajai tila.” Ini mateng aulang angu, Sara ana ue tundil amotaoa tahit vengmee. ");
INSERT INTO beu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Uanguveng angu, Abraham, bot ejangu Sara oleve etatabit boma-memet iila, bot Sara di euuru hoa angu, aamina tila. ");
INSERT INTO beu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Base, ini mateng aulang angu Sara ana vengmee muse, ana omimi pelela. Bot Sara ana vengpikir hula, “Aah! Naing anga memet lolobahi tila, nemehal di bomat lolobai tila se, tatalange ni bisa taing suka, bot tabung tia, senge ni bisa vaal veng?” ");
INSERT INTO beu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Angmuse LAHATALA Ana Abraham adangtaaning hula, “Etatalang ba Sara ana palela? Ana vengpikir hula, naba ba Na vengbanang anga, eningse jadi niang, se ana memet iila angu ebele ka? ");
INSERT INTO beu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Naing anga ba LAHATALA! Naba ba Na vengbanang iila angu, ana malekang jadi! Venganit aaung-aaung! Tung nu kalo Na bale hoa angami se, Sara ana vaal mehal nu vengajai tila.” ");
INSERT INTO beu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Vengmeet aulang muse, Sara ana uangmari. Angmuse Sara ana iat akal mateng hula, “Na bae palela niang!” Aarunge Lahatala Ana Sara ehur angu ebalet hula, “Niang, etabi aana vede palela.” ");
INSERT INTO beu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Angmuse nehe tue angu hula tahit lamal bendar Sodom mi ila. Base Abraham ana ing aantar sampe ila via hahama mi. Angmi angu, ini bisa uuling bendar Sodom angu ateing. ");
INSERT INTO beu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Angmuse LAHATALA Ana Omimi vengpikir hula, “Lebe miaaung, Na hula bendar Sodom ening amusing-ajela angu, Na ekang metma Abraham veng eamaang ekang. Biar Na metma veng at sarenta hengi. ");
INSERT INTO beu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Se etabaning angu eningse metma bangsa eele ening, bot ana aabetat aaung-hama, base bangsa toang por-alolang taang angu eningse emangpi aaung-hama metma ioa angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Se Na aing vengtalail iila, senge oal-idat, bot etabaning ang naung emangpi ana iavomung-iapahang, iot LAHATALA Evia aabetang angu ba eamulung, bot aabetat aaung-hama anguba ening angu ebele. Aulang senge palai ba LAHATALA Ana metma Abraham at palai tila angu, Ana bisa ening akanap.” ");
INSERT INTO beu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Seng angmuse LAHATALA Ana Abraham at hubait hula, “Bendar Sodom, bot Gomora ijasi-iahala angu etatabi tamadi, bot ilamal-itahi angu ening nehe toang bau-pei angu, Na vengmee tila. ");
INSERT INTO beu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Angu ebele, Na hela, senge uuling ateing hula, ilamal-itahi ba ening nehe toang bau-pei angu, etatabit aulang ee, niang? Na malekang uuling Neng taang ateing hengi.” ");
INSERT INTO beu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Angmuse nehe aaru angu ini lamal milalut bendar Sodom mi ila. Aarunge Abraham aing jedung angmi LAHATALA Apangaadang mi tahi sehi. ");
INSERT INTO beu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham ana lamal va Lahatala abung-abung, sengmuse ana Lahatala Asenang hula, “Tatalang Nimang? Nehe ba aabetat aaung-hama, bot nehe ba aabetat jasi-ahala ang naung emangpi angu, Aana hula ing ening ini hama-hamat musi-jela ka? ");
INSERT INTO beu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kalo nehe ba aaung-hama ening angu inang 50 ue bendar angu omimi se, ing di Nimang Aana ing ening ini musi-jela ka? Ee niang, ini ue bendar angu omimi base, Nimang Aana bae bendar angu ening amusing-ajela niang. ");
INSERT INTO beu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nimang, Aana ekang ening aulang ekang! Nehe jasi-ahala ening ang naung Aana hula iameang anguba, nehe aaung-hama ening ang naung di iat hama-hamat aamina se, nehe aaung ang naung di emenghula nehe jasi-ahala ening angu edadenang ka? Aaingba por-burang anga eHakim, se etatalang ba Aana nehe hukung bae molo niang?” ");
INSERT INTO beu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Angmuse LAHATALA Ana mateng hula, “Kalo bendar Sodom mi angu, nehe ba aaung-hama ening angu inang 50 ue angumi se, Na bae bendar angu hukung niang, se ing angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham ana mateng hula, “Nimang, naing anga manusia bodo-kamuke, bae na iiba ateing niang. Na banang Aana naing aampong, senge na taang mateng kabingdena hengi. ");
INSERT INTO beu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Misavaka nehe ba aaung-hama ening angu bae sampe inang 50 niang, aarunge inang 45 kolang se, Aana jedung hula bendar angu ening amusing-ajela, se inang iising niang angu ebele ka?” Lahatala Ana mateng hula, “Kalo nehe ba aaung-hama ening angu, inang 45 ue angumi se, Na bae bendar angu ening amusing-ajela niang.” ");
INSERT INTO beu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Angmuse Abraham ana bot taang Lahatala Asenang hula, “Kalo nehe ba aaung-hama ening angu inang 40 kolang se, tatalang, Nimang?” Lahatala Ana Abraham ebalet hula, “Kalo nehe ba aaung-hama ening angu, inang 40 ue angumi se, Na bae ing hukung niang.” ");
INSERT INTO beu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham ana Lahatala Asenang alolang-niang hula, “Nimang Aana ekang Oomi alil ekang. Misavaka nehe ba aaung-hama ening angu, inang 30 kolang se, tatalang?” Lahatala Ana Abraham ebalet hula, “Kalo nehe ba aaung-hama ening angu, inang 30 ue angumi se, Na bae jadit ing hukung niang.” ");
INSERT INTO beu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham ana bot taang mateng hula, “Nimang! Na etatabit nava ening barani, senge Aat mateng. Kalo nehe ba aaung-hama ening angu inang 20 kolang se, tatalang?” Angmuse Lahatala Ana Abraham ebalet hula, “Kalo nehe ba aaung-hama ening angu, inang 20 ue angumi se, Na bae bendar angu ening amusing-ajela niang.” ");
INSERT INTO beu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Evengtahimi Abraham ana Lahatala At mateng hula, “Nimang! Na hula taang mateng minu maveng, base ekang Oomi alil ekang! Kalo nehe ba aaung-hama ening angu, inang 10 kolang se, tatalang?” Angmuse Lahatala Ana Abraham ebalet hula, “Kalo nehe ba aaung-hama ening angu, inang 10 ue angumi se, Na bae bendar angu ening amusing-ajela niang.” ");
INSERT INTO beu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","LAHATALA Ana Abraham at mateng sengmuse, Ana lamal milalu, bot Abraham aing bale emihing mana mi ila. ");
INSERT INTO beu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Uanguveng Lahatala Ana jedung Abraham at mateng sehi se, Egahingvala aaru angu, ini lamal milalut ila bendar Sodom mi. Ini ila bendar Sodom mi se, ved hula baa. Uanguveng angu, Lot ana jedung ue bendar Sodom eviaha maso eele angumi mihi sehi. Lot ana uuling nehe aaru angu iateing muse, ana lamal va ing sambut. Angmuse Lot ana nehe aaru angu iapangaadang mi kuku muding. ");
INSERT INTO beu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Lot ana nehe aaru angu iat mateng hula, “Nimang iimal! Mahe, iini nehava mi miaarit jar metma iia laming, senge bir-kua anga iini angami tia. Tobang kuaveng senge, iini lamal milalu.” Aarunge nehe aaru angu ini Lot ehur angu ebalet hula, “Niang! Vede bir-kua anga, ni bendar anga elapang mi tia.” ");
INSERT INTO beu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Aarunge Lot ana iasenang alolang-niang, angmuse ini ila ehava mi mihit vengtahang. Angmuse Lot ana roti ba bae bibit maveng niang angu iia, sengmuse ini adang hama-hama. ");
INSERT INTO beu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nehe aaru angu bae tia jedung se, bendar Sodom enehe mehal ang naung, boma-kuar, nu bae ihava mi mihi niang, aarunge emangpi hoa Lot ehava angu goleng tahi. ");
INSERT INTO beu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ini moring Lot adangtaaning hula, “Ee, Lot! Nehe mehal aaru vede angu, ini ue taang mi? Iat kaluar hela angami, senge ni hula iat tia!” ");
INSERT INTO beu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Angmuse Lot ana kaluar hela viaha mi ing harak, aarunge ana amotaoa angmi tundil angu vengtering. ");
INSERT INTO beu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Lot ana Sodom enehe ang naung iat mateng hula, “Kaku naung! Iini ekang jasi ening metma nehe aaru angu iadana ekang. ");
INSERT INTO beu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Iini ateing se, noal jangu aaru angu, nehe mehal bae ing dei di jedung. Base, kalo iini vengjali se, biar oleve na iat kaluar hela metma maiinang, senge iini naba ba ening metma iadana di aaung. Aarunge iini ekang naiiba ening metma nehe aaru angu iadana ekang. Se pihada eamulung se, na malekang ing jagat aaung-aaung angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Aarunge Sodom enehe ang naung ini moring hula, “Aana ekang nehe aaru angu ing tahang ekang! Aaing angu nehe hoang-manang ba ae angami! Aaing nehe aabeung, base aana ekang ning vengator ekang. Aaungba aana tahit lamal mana anga eahalang. Angase ni aaing ening lebe mitamadi nehe aaru angu mi iataangoa!” Angmuse nehe mehal ang naung ini Lot atobang, ini hama-hamat va hula tundil angu jambat ening ajasing. ");
INSERT INTO beu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Aarunge nehe aaru Lot ehava mi angu, ini iatang taning hela Lot aing masiring hava omimi maso, sengmuse ini tundil angu vengtering. ");
INSERT INTO beu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Angmuse nehe aaru angu ini Sodom enehe ba hava eviaha mi ang naung, boma-kuar, emangpi ieng angu ening akete, angu ebele ini hava eviaha valaping di, bae harak niang. ");
INSERT INTO beu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Angmuse nehe aaru angu ini Lot at mateng hula, “Lot! Eenehe aabeung taang ba jedung ae bendar anga mi? Kalo ooal mehal, ooal jangu, iidat mehal, iidat jangu, bot nuba-nuba di, aaungba aana iat lamal kaluar, mana anga eahalang! Angase ni hula mana anga ening amusing-ajela. Bau-pei toang LAHATALA Apangaadang mi, metma bendar anga adana tila. Angu ebele LAHATALA Ana ning gahing niot ening amusing-ajela!” ");
INSERT INTO beu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Angmuse Lot ana kaluar ila nehe mehal aaru ba hula, oal jangu aaru angu medi angu ing harak. Lot ana iat mateng hula, “Vengmeet aaung-aaung! Angase aaungba iini tahit lamal kaluar mana anga eahalang, se LAHATALA Ana hula bendar anga ening amusing-ajela angu ebele!” Aarunge nehe mehal aaru angu ini hula, Lot ana mang mamulal mateng. ");
INSERT INTO beu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Emikuaveng vedeng hula da muse, Lahatala Egahingvala aaru angu, ini Lot aing paksa, senge ini uuser lamal kaluar. Ini Lot at mateng hula, “Lot! Aaungba tahit eejangu, bot ooal jangu aaru angu, iat lamal kaluar, senge iini ekang bendar anga enehe ba jasi-ahala ang naung iat hama-hamat aamina ekang.” ");
INSERT INTO beu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Uanguveng Lot jedung pati-pati sehi, aarunge LAHATALA Ana hula ing ening lohi. Angu ebele Lahatala Egahingvala aaru angu ini Lot atang, ejangu atang, bot oal jangu aaru angu iatang angu vengpina, sengmuse iat lamal kaluar bendar angu eahalang. ");
INSERT INTO beu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kaluar ila bendar angu eahalang muse, Lahatala Egahingvala aaru angu, nu Lot at mateng hula, “Uuser bihi, senge iini bisa lohi! Ekang bale iiamota oat uuling ekang! Bot ekang kakura-omi ba Yordan moar mi angu mi barinti ekang. Bihit lalut ila dol angdo taang, senge iini ekang aamina ekang!” ");
INSERT INTO beu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Aarunge Lot ana ebalet hula, “Adoo, nimang! Ekang aulang ekang! ");
INSERT INTO beu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nimang aana etatabit ning ening lohi tila. Aarunge dol angdo etatabit ola! Misavaka ni bae ila angdo mi jedung se, aaminang angu via mi ning harak, base ning di aamina. ");
INSERT INTO beu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Aabang nu moe angmomi angmo, bae ola niang. Aabang angu kiki nu. Base kalo nimang aana jali se, ni bihit aabang angmomi ila, senge ni ekang aamina ekang.” ");
INSERT INTO beu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Angmuse Lahatala Egahingvala angu ana Lot at mateng hula, “Yoo! Aana banang aulang base, Aabang ba aana vengbanang angu, eningse na bae ening amusing-ajela niang. ");
INSERT INTO beu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Base, iini uuser bihit angmomi ila! Iini bae ila aabang angmomi jedung se, na bae na iiba ening jedung.” Mulai uanguveng angmuse, aabang angu nehe ene maveng hula, Soar, evengbanang tarang se hula, ꞌkikiꞌ. ");
INSERT INTO beu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Uanguveng vedeng da iila muse, Lot iimal bihit ila Soar aabang mi tila. ");
INSERT INTO beu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Mibaroti se, LAHATALA Ana aad huring, bot balirang tutung burang mi, metma bendar Sodom, bot Gomora vengbokong hela. ");
INSERT INTO beu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Bendar, bot aabang ba ue kakura-omi Yordan moar eoang mi ang naung, emangpi LAHATALA Ana ening amusing-ajela, bot ening midodu-milala. Bot emangpi ba angumi aabeta angu, benangba: manusia, binanta, bot dadi-napa, bot te ang naung, emangpi viling musi-jelat miosing. ");
INSERT INTO beu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Aarunge uanguveng Lot iimal bihit ila hula iava ening lohi angu, Lot ejangu ana bale amotaoat uuling. Angmuse aing metma iihal-eera ening. ");
INSERT INTO beu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Emikuaveng muse, Abraham ana bale ila mana ba uanguveng ana mi tahit LAHATALA Asenang angu mi, ");
INSERT INTO beu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","sengmuse ana eng metma bendar Sodom, bot Gomora, bot kakura-omi Yordan moar eoang mi angu euuling se, taang-taang mi angu, aad-banak oopol-oopol mida burang mi. Bot emangpi angu, viling musi-jelat miosing iila. ");
INSERT INTO beu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Uanguveng Lahatala Ana bendar ba kakura-omi Yordan moar eoang mi, bot bendar ba Lot emihing mana ang naung ening amusing-ajela angu, palai ba Lahatala Ana metma Abraham at palai angu, Ana vengani. Angu ebele, Lahatala Ana Lot at lamal kaluar metma bendar ba Ana ening amusing-ajela, bot ening midodu-milala angu eahalang. ");
INSERT INTO beu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Uanguveng Lot ana Soar aabang mi angu uangmari. Angu ebele aing, bot oal jangu aaru angu, ini iava asorong ila dol taang. Angmuse ini angumi pa nu mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Minu adana, jangu emutu angu ana ekaku iia angu at hubait hula, “Kaku! Timang ana boma tila, bot mana anga mi anga, nehe mehal iiba bae bisa pibele hoa senge ping medi niang. ");
INSERT INTO beu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Base lebe miaaung pi anggur metma timang enang ana na, sampe veng naboa, senge pi abung tia. Aulang senge, pi bisa timang etabaning angu hamua.” ");
INSERT INTO beu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Angmuse bir-kua angu, oleve anggur metma imang enang ana na, sampe naboa. Sengmuse jangu emutu angu ana masot mida imang abung tia. Aarunge boma Lot ana etatabit naboa, base naba ba ana ening metma oal jangu adana tila angu, ana bae vengkaruang niang. ");
INSERT INTO beu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Emitobang muse, jangu emutu angu ana bot ekaku iia angu at hubait hula, “Kaku! Vede bir-kua angu, na timang abung tia tila. Angu ebele, misabantar bir-kua anga di, pi anggur metma timang enang ana na, senge aana masot mida abung tia. Aulang senge, pi bisa timang etabaning angu hamua.” ");
INSERT INTO beu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Base, bir-kua angu di ini ening imang ana naboa, sengmuse jangu iia angu ana masot mida imang abung tia. Aarunge boma Lot ana etatabit naboa, base naba ba ana ening metma oal jangu adana tila angu, ana bae vengkaruang niang. ");
INSERT INTO beu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ening aulang, base Lot oal jangu aaru angu iatou veng. ");
INSERT INTO beu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Jangu emutu angu ana vaal mehal nu vengajai muse, ana ene maveng, ene Moab (emenghula hur kokal aabeung nu angu edadenang, evengbanang tarang se hula, ꞌimang abung hoaꞌ). Aingba Moab enehe ang naung idat-imang. ");
INSERT INTO beu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Angmuse jangu iia angu di, ana vaal mehal nu vengajai. Ana ene maveng, ene Ben Ami (evengbanang tarang se hula, ꞌvaal nenehe abung hoaꞌ). Aingba Amon enehe ang naung, idat-imang. ");
INSERT INTO beu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Angmuse Abraham ana Mamre mi ava asorong ila Negep mi, sengmuse ana Kades aabang, bot Syur aabang ehahama angumi mihi. Abraham ana Gerar aabang mi mihit metma nehe hoang-manang ening. ");
INSERT INTO beu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham ana Gerar aabang enehe ang naung iat hubait hula, Sara angu, ekaku jangu. Angmuse Abimelek, Gerar eraja angu, ana enehe ang naung ing gahing iot hoa Sara at eistana mi ila. ");
INSERT INTO beu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Aarunge bir kua muse, iipal omimi Lahatala Ana Ava metma Abimelek etubing, bot at mateng hula, “Abimelek! Angase aana malekang aamina! Se nehe jangu ba aana aing medit at hoa angu, ana mehal veng iila angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Aarunge Abimelek ana bae Sara aing dei di jedung. Angu ebele iipal omimi ana Lahatala ehur angu ebalet hula, “Nimang! Bangsa ba bae eahalang veng niang di, Aana hula iameang ka? Abraham ba ena vengbanang se hula, nehe jangu angu, ekaku! Bot nehe jangu angu di ena vengbanang hula, Abraham angu ekaku. Base na nehe gahing iot ila nehe jangu angu at hoa, aarunge nomi anga molo-molo, bot natang anga di hamulang. Na bae nehe jangu angu aing dei di jedung. Angu ebele, Nimang, Aana ekang naing ening ahala ekang!” ");
INSERT INTO beu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Angmuse iipal omimi angu, Lahatala Ana bot Abimelek at mateng hula, “Etabi! Na ateing se, aana na angu ening, aarunge oomi angu molo-molo. Angu ebele, Naingba oomi angu vengtahang, senge aana ekang nehe jangu angu aing dei ekang. Bot aulang senge, aana ekang ahalang ening metma Nadana ekang. ");
INSERT INTO beu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Base, angase nehe ejangu angu, aana melekang at bale ila emehal enang. Emehal angu Nehurvala. Eningse ana sambajang metma maeenang, senge aana ekang aamina ekang. Aarunge kalo nehe ejangu angu, aana bae at bale ila emehal enang niang se, aana vengaanit aaung-aaung! Eningse aaing, bot eenehe ang naung, iing emangpi malekang aamina.” ");
INSERT INTO beu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Emitobang kukuaveng muse, Abimelek ana emalea ang naung emangpi iaru, bot iipal angu ana metma veng iat sarenta. Angmuse ing emangpi iuangmarit etatabi. ");
INSERT INTO beu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Bot Abimelek ana Abraham earu, sengmuse ana Abraham adangtaaning hula, “Ahalang naba ba na ening metma aadana tila, angu ebele aana silaka ening metma nadana, bot metma neparenta di adanat alang anga? Anga aana jasi-ahala ening metma nadana tila. ");
INSERT INTO beu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Eeomi tatalang ba, aana na alang anga ening metma niadana anga?” ");
INSERT INTO beu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Angmuse Abraham ana mateng hula, “Nimang raja! Na vengnomit hula, nehe emangpi ba angami anga, bae Lahatala Apang-ateing niang. Base, misavaka ini nameang, senge nejangu angu ini aing medi. ");
INSERT INTO beu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bot etatabi aing angu nekaku. Se aing angu noleve nimang nu. Aarunge aing iva angu aabeung. Aulang aarunge na aing medit metma nejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Base, kalo Lahatala Ana niot kaluar niava asorong lamal nimang ehava omi angu ehalang se, na nejangu at mateng hula, ꞌKalo aana etatabit oomi metma nejahi se, pi ila mana-mana ang naung mi, nehe naing vengtaaning se, aana vengbanang hula, poleve iia-mutu.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Angmuse Abimelek ana jumba-aib, arbo-sapi, bot malea jangu, malea mehal medi, sengmuse emangpi ana metma Abraham enang. Bot Sara, Abraham ejangu angu di, Abimelek ana bale metma Abraham enang. Angmuse Abimelek ana Abraham at mateng hula, “Neaabang anga na bukat metma aadana, angu ebele, mana taang ba aana suka se, mi mihi.” Angmuse Abimelek ana Sara di at mateng hula, “Seeng perak ribunu na bajar metma eekaku Abraham enang iila. Angu metma ebukti ening, senge eenehe ang naung ini ateing hula, na bae jasi-ahala iiba ening metma aadana niang. Bot aulang senge, nehe emangpi ekang aaing ening ahala ekang.” ");
INSERT INTO beu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Halomang mi, LAHATALA Ana nehe jangu ba Abimelek eistana mi ang naung emangpi ivaal emana angu vengtering iila, base ini bae vaal veng niang, se Abimelek ana Abraham ejangu Sara at eistana mi ila angu ebele. Aarunge uanguveng Abimelek ana bale Sara aing metma emehal Abraham enang muse, Abraham ana sambajang Lahatala Abanang, metma nehe jangu ang naung iadana. Angu ebele, Lahatala ana bale nehe jangu ang naung ivaal emana angu buka. Base ini bot bale vaal veng. ");
INSERT INTO beu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Lahatala Ana Sara eaabetang angu uuling ateing, emenghula Ana vengbanang iila angu edadenang. Angu ebele, Lahatala Ana aaung-hama ening metma Sara adana, naba ba Ana vengpalai tila angu eamulung. Abraham ana boma tila, aarunge luung niang se, Sara ana atou veng. Angmuse Sara ana vaal mehal nu vengajait metma Abraham enang, ejol ba Lahatala Ana vengbanang iila angu eamulung. Abraham ana oal angu ene maveng, ene Isak (evengbanang tarang se hula, ꞌana palelaꞌ). Isak euumur ved tuaru muse, Abraham ana aing sunat, Lahatala Eparenta angu eamulung. Uanguveng Sara ana Isak aing vengajait metma Abraham enang angu, Abraham euumur mitung 100 tila. Angmuse Sara ana mateng hula, “Lahatala Ana ening na palela, se nomi sanang iila angu ebele. Base angase, nehe ba na anga vengmee ang naung, ing emangpi nat hama-hamat palela.” Nemehal noleve boma-memet lolobahi tila. Angu ebele, nehe emangpi veng iomit hula, angase na bae bisa vaal veng niang iila. Aarunge Lahatala ana ening angase na bisa vaal mehal nu vengajait metma nemehal enang iila. ");
INSERT INTO beu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isak ana bilang aaeele-aaeele muse, ini aing sole. Uanguveng hula Isak aing sole angu, Abraham ana pesta eele ening. ");
INSERT INTO beu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Uanguveng angu, Sara ana uuling ateing se, Hagar oal Ismael angu, ue oal Isak oleve mamulal sehi. Angmuse Sara ana emehal Abraham at mateng hula, “Malea ba Masir mi hoa angu, aaungba oal oleve iateri! Se malea oal angu, ana bae noal Isak at hama-hamat pasaka ang naung medi niang, aarunge emangpi angu malekang metma noal Isak ba eooa angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sara emateng angu vengmee muse, Abraham omi etatabit dira, bot ekubang sar angu mang hula sia, se Ismael angu di oal angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Aarunge Lahatala Ana Abraham at mateng hula, “Abraham! Ekang oomi dirat metma eemalea angu oal oleve iadana ekang. Emangpi ba Sara ana vengbanang angu aana malekang venghele, bot ening eamulung, se eetabaning ba Na metma veng aat palai tila angu, Isak ba at lamal angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Aarunge eemalea oal angu di, etabaning angu, eningse Na metma bangsa nu ening, se andi ooal angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Emitobang kukuaveng muse, Abraham ana mod ening, bot jar botil nu medit metma Hagar enang. Bot vaal angu Abraham ana ohit metma Hagar abea taang, sengmuse ana iot lamal ila. Angmuse Hagar ana oal angu at ila por osing eele ba Beer Syeba abung angu migoleng lamal. ");
INSERT INTO beu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Uanguveng ijar ba botil mi angu osing iila muse, Hagar ana oal angu aing metma te kiki nu angu iivang atiang, ");
INSERT INTO beu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","sengmuse ana ila oal angu eolat mihi. Oma meter ari iising aulang. Se ana vengpikir hula, “Kalo noal anga aamina, na uuling ateing se, na vengtahang jadi niang.” Angmuse ana angumi mihit baut hanuring. ");
INSERT INTO beu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ismael ana bau angu, Lahatala Ana amal angu vengmee. Angmuse Lahatala Egahingvala sorga mi angu, burang mi Hagar earut hula, “Hagar! Etatalang ba aana susat aulang angu? Ekang uuangmari ekang. Ooal Ismael ana emana mi tiat bau angu, Lahatala Ana amal angu vengmee tila. ");
INSERT INTO beu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Aaungba tahit ila vaal angu aing ohi, bot amunang, senge omi angu ening sanang. Eningse Na aing metma bangsa eele nu ening.” ");
INSERT INTO beu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Angmuse Lahatala Ana Hagar eng angu ening tarang, base jar eng nu ue angmi angu, ana uuling ateing. Angmuse Hagar ana jar angu iihit metma ebotil angu mi, sengmuse ana metma oal Ismael enang ana na. ");
INSERT INTO beu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Lahatala Ana Ismael at toang-pina, angu ebele Ismael ana bilang taang aaeele-aaeele. Ismael, bot iva oleve padang Paran mi mihi. Ismael angu, aing pintar na atapa. Ismael iva ana Masir jangu nu at hoa maenang ana medit metma ejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Uanguveng angu, raja Abimelek, bot ekapala malibal nu ene, Pikhol angu oleve hoa Abraham aing harak. Raja Abimelek ana Abraham at mateng hula, “Abraham! Ni ateing iilat hula, Lahatala Ana etatabi aat toang-pina. Angu ebele naba ba aana ening ang naung, emangpi jadi angu. ");
INSERT INTO beu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Angu ebele na banang, angase Lahatala Apangaadang mi, aana nat sumpat hula, aana bae putar-bale metma nadana niang, bot metma noal-nidat ang naung di iadana niang. Aaing nehe hoang-manang ba ae aabang angami. Base aana malekang aaung angu ba ening metma niadana, emenghula na aaung ening metma aadana tiila angu edadenang.” ");
INSERT INTO beu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Angmuse Abraham ana Abimelek ehur angu ebalet hula, “Angase na aat sumpa.” ");
INSERT INTO beu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Aarunge Abraham ana ava manasal metma Abimelek adana, angmuse ana Abimelek at mateng hula, “Nimang raja! Eemalea ang naung ini ne jar eng nu rampas medi tila.” ");
INSERT INTO beu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek ana Abraham ehur angu ebalet hula, “Ah! Na angu na bae ateing niang. Nuba ba ening aulang se, aana turangmi vengbanang niang angu? Na anga na uhavede vengmee.” ");
INSERT INTO beu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Angmuse Abraham ana jumba, bot sapi medi, sengmuse emangpi ana metma Abimelek enang. Sengilaba Abraham, bot Abimelek oleve itat palai. Aarunge jumba ba Abraham ana metma Abimelek enang angu, jumba emanarang bititu angu Abraham ana vengtalail eapahing atahing. ");
INSERT INTO beu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Angmuse Abimelek ana Abraham adangtaaning hula, “Abraham! Jumba bititu ba aana vengtalail eapahing atahing angu, metma naba ening?” ");
INSERT INTO beu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham ana Abimelek etaaning angu ebalet hula, “Nimang raja! Jumba bititu anga aana malekang natang mi tarima, senge metma tanda-bukti ening hula, nimang raja aana mangakut vengbanang iilat hula, naing ba jar eng angu aanang.” ");
INSERT INTO beu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Abraham, bot Abimelek oleve angumi itat sumpa, angu ebele mana angu ini ene maveng hula, Beer Syeba. Evengbanang tarang se hula, ꞌJar eng sumpaꞌ. ");
INSERT INTO beu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ini Beer Syeba mi itat palai sengmuse, raja Abimelek, bot ekapala malibal Pikhol oleve bale iaabang Filistin mi ila. ");
INSERT INTO beu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Angmuse Abraham ana te tamareska nu metma Beer Syeba mi muding. Angu metma Abraham evengani ening, senge ana angumi Lahatala ba aabetat ejehing-emeang angu, Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Bot Abraham aing metma nehe hoang-manang ening, Filistin enehe ang naung iabang mi mihit luung. ");
INSERT INTO beu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Luung niang muse, Lahatala Ana Abraham aing soba, senge ateing hula, Abraham ana etatabit Lahatala Eamulung ee, niang. Lahatala Ana Abraham earut hula, “Abraham!” Angmuse Abraham ana madut hula, “Ya Nimang, Aaing ba neLahatala.” ");
INSERT INTO beu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Angmuse Lahatala Ana Abraham at mateng hula, “Ooal nu kakolang Isak, ba aana etatabit oomi metma ejahi angu, aing medit at ila Moria mi dol nu eningse Na metma eetubing angu taang, senge aing metma sadaka ening edet atepul metma maNenang.” ");
INSERT INTO beu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Emitobang kukuaveng muse, aad metma sadaka ede ang naung Abraham ana patai, bot parta, sengmuse ana metma ekeledei angu taang mea. Angmuse Abraham, bot Isak, bot Abraham emalea nehe aaru, imampi lamal mana ba Lahatala Ana vengbanang iila angu mi ila. ");
INSERT INTO beu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Uanguveng ini lamal ved tue tila muse, Abraham ana apang ohit uuling se, mana angu ana olami uuling ateing. ");
INSERT INTO beu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Angmuse Abraham ana emalea aaru angu iat mateng hula, “Ooleve, bot keledei anga veng angami mihi. Naing, bot noal anga, noleve angmomi va Lahatala Aing somba, seng angse ni bale angami ma.” ");
INSERT INTO beu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Seng angmuse, aad ba hula metma sadaka ede angu, Abraham ana ohit metma oal Isak abea taang mea, senge Isak ana tevang. Abraham aing duri, bot aad-viling metma atang mi baning, sengmuse oleve lamal hama-hama. ");
INSERT INTO beu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Uanguveng Abraham, bot oal Isak oleve lamal sehi muse, Isak ana imang earut hula, “Nimang!” Angmuse Abraham ana Isak ebalet hula, “Tatalang, noal?” Isak ana imang adangtaaning hula, “Nimang. Pi hula sadaka ede. Aarunge angami anga aad metma sadaka ede angu ae tila se, jumba ba pi metma sadaka ening angu, ue taang mi?” ");
INSERT INTO beu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Angmuse Abraham ana Isak etaaning angu ebalet hula, “Noal! Jumba vaal angu eningse Lahatala ba vengharaka, senge metma sadaka ening edet atepul metma maEnang.” Base oleve lamal hama-hamat alolang-niang. ");
INSERT INTO beu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ila mana ba Lahatala Ana vengbanang angu mi tila muse, Abraham ana angumi doru ohi. Aad ba hula metma sadaka ede angu ana metma doru angu taang piling mea. Sengmuse oal Isak angu, ana ia-atang parta, bot aing metma aad angu taang alal-biat atiang. ");
INSERT INTO beu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Seng angmuse Abraham ana atang taning duri medit hula oal angu sabelet ameang. ");
INSERT INTO beu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Aarunge mibaroti se, LAHATALA Egahingvala sorga mi nu burang mi moring Abraham earut hula, “Abraham, Abraham!” Abraham ana madut hula, “Ya Nimang, Aaing ba neLahatala!” ");
INSERT INTO beu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Angmuse nehe amal angu Abraham at mateng hula, “Aana ekang ooal angu ameang ekang, bot aana ekang na iiba ening metma adana ekang! Angase Na ateing iilat hula, aana etatabit Lahatala Eomi angu eamulung. Angu ebele, ooal mehal nu kakolang angu, aana hula metma sadaka ening Lahatala enang di, oomi bae uunang-uunang niang angu.” ");
INSERT INTO beu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Angmuse Abraham ana amota oat uuling se, jumba lotal nu amu te kakiri mi baat ue tahi sehi. Base Abraham ana jumba angu medit metma oal etelul ening, senge sadaka ening edet atepul metma Lahatala Enang. ");
INSERT INTO beu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Angmuse Abraham ana mana angu ene maveng hula, ꞌNaba ba parlu angu, eningse Lahatala Ana vengharakat metma mapinang.ꞌ Angu ebele, angase nehe vengbanang hula, “Lahatala Edol taang angu, naba ba pi parlu se, Lahatala Ana vengharakat metma piadana.” ");
INSERT INTO beu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Angmuse Lahatala Egahingvala sorga mi angu, bot burang mi moring emiaaru Abraham at mateng hula, ");
INSERT INTO beu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“LAHATALA Ana vengbanang hula, ꞌNene angu Na metma Nava at sumpa. Se aana ening aulang iila, bot ooal mehal nu kakolang angu aana hula metma maNenang di, oomi bae uunang-uunang niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Base aaung-hama ba bae ebale veng niang angu, eningse toang-rae Na metma maeenang, bot metma eetabanig ang naung di inang. Eetabaning angu eningse Na ening etatabi toang-rae, garet jadi niang, taanang jadi niang, emenghula iid burang mi, bot bahi tang omimi angu edadenang. Bot nehe ba omi metma eetabanig ang naung, ialalil angu, eningse ini ing ening iora-vengholong, senge eetabaning ang naung ini iabang-ilelang angu mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Aaing, bot eetabaning ang naung Neparenta angu eamulung base, bangsa emangpi ba por-alolang taang anga, aaung-hama ba bae ebale veng niang angu, eningse Na metma mainang.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Angmuse Abraham, bot oal Isak oleve bale emalea aaru angu ibele ila ing harak, sengmuse ini hama-hamat bale Beer Syeba mi ila. Ila angmomi muse, Abraham iimal angumi mihi. ");
INSERT INTO beu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Seng angmuse, Abraham ana hoja vengmee se hula, ekaku Nahor ejangu Milka ana vaal mehal aaedeng vengajait metma Nahor enang iila. ");
INSERT INTO beu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Nahor oal mutu angu ene, Us. Us ekaku ba miamulung angu ene, Bus. Bot Kemuel (aing ba Aram imang) angu. ");
INSERT INTO beu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Bot Kesed, Haso, Pildas, Yidlaf, bot Betuel. ");
INSERT INTO beu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel ba Ribka vengajai angu. Inang tuaru anga ba Milka ana ing vengajait metma Abraham ekaku Nahor enang angu. ");
INSERT INTO beu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Aarunge Nahor ejangu gariang ene, Reuma, angudi vaal vengajait metma Nahor enang, benangba; Teba, Gaham, Tahas, bot Maaka. ");
INSERT INTO beu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara euumur mitung 127 muse, ana aamina. Uanguveng Sara aamina angu, Abraham iimal ini ue Kiryat-Arba aabang (benangba Hebron) Kanaan mi angu, mi mihi. Base Abraham ana hoa ejangu Sara aamina angu ebau-epei. ");
INSERT INTO beu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Angmuse Abraham ana tahit ejangu eahalang, sengmuse ana Het aabang enehe ang naung ibele ila iat mateng hula, ");
INSERT INTO beu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Naing anga nehe hoangmanang ba ae iihahama angami. Base, kalo iini jali se, iimeke nu metma manenang, na metma daang emana ening. Senge nejangu ebaring angu, na aantar hoa metma mi taloul hengi. ");
INSERT INTO beu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Angmuse Het aabang enehe ang naung ini Abraham ehur angu ebalet hula, ");
INSERT INTO beu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Nimang! Aana ning venghele hengi. Aana nihahama mi mihit eluung alang anga, ni etatabit aaing aada emenghula raja eele nu edadenang. Base ni daang emana ba ue ang naung aana vengtalail taang ba oomi vengbaa se, eejangu ba aamina angu, aana aing metma angumi taloul. Ni vengjali, nehe nu bae eebanang angu atobang niang.” ");
INSERT INTO beu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham ana ihur angu vengmee muse, ana aloming tahi, bot tout-hela por manaing Het aabang mi ang naung ing aada. ");
INSERT INTO beu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Abraham ana iat mateng hula, “Kalo nemateng vede angu iini veng iiemeng-ajali tilat hula, nejangu ba aamina tila angu na aing aantar hoa taloul se, iini noang-moling boma Sohar oal Efron at mateng bot abanang, ");
INSERT INTO beu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","senge kalo bisa se, epa ba ene Makpela, ue ebir eadil mi angu, ana aabalit metma manenang, senge na metma ni daang emana ening ae iihahama angami.” ");
INSERT INTO beu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Uanguveng angu, Efron di ue Het aabang enehe ang naung ihahama mi. Base Efron ana Abraham emateng angu vengmee muse, ana Abraham ehur angu ebale. Het aabang enehe toang-rae ba hoa angmi ang naung ini Efron emateng angu vengmee. ");
INSERT INTO beu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Efron ana mateng hula, “Bae aulang niang, nimang! Aana naing venghele hengi. Bir angu, bot pa ba ene Makpela angu, na mang metma maeenang. Nehe toang-rae anga naung iapangaadang mi meke angu na mang metma maeenang, senge eejangu ba aamina angu, aana aing metma angumi taloul.” ");
INSERT INTO beu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Angmuse Abraham ana bot Het aabang enehe ang naung iapangaadang mi tout-hela. ");
INSERT INTO beu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Abraham ana nehe toang-rae ang naung iapangaadang mi Efron at mateng hula, “Aulang di aaung, aarunge kalo aana jali se, bir angu ebili angu na bajar metma maeenang, angu aana malekang nabung medi, senge nejangu ba aamina angu, na aing metma angmomi taloul.” ");
INSERT INTO beu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Angmuse Efron ana Abraham ehur angu ebalet hula, “Nimang! Naing venghele hengi. Meke kabingdena angu ebili seeng perak ratu buta kolang. Seeng kabingdena aulang angu, egunang naba metma piadana? Aaungba aana ila, senge eejangu ba aamina angu at hoa angumi taloul.” ");
INSERT INTO beu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Meke angu ebili ba Efron ana vengbanang angu, Abraham ana tarima. Base, Efron ebanang angu eamulung, Het aabang enehe toang ang naung metma esaksi ening, iapangaadang mi, Abraham ana seeng perak ratu buta angu garet metma Efron enang. ");
INSERT INTO beu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Ening aulang base, Efron ebir ba Makpela mi, Mamre eved danangoa angmi (benangba Hebron) angu, metma Abraham ebaang ening. Abraham ana bir angu beli angu, pa ba ue omimi, bot te ba ue bir angu omimi ang naung, emangpi metma Abraham eoa. Efron ana Ebir angu metma Abraham enang angu, Het aabang eboma ang naung emangpi metma esaksi ening hula, meke angu, bot emangpi ba ue omimi angu, metma Abraham ebaang ening iila. Seng angmuse, Abraham ana ila ejangu Sara aing metma pa ba Makpela mi, (benangba Hebron) Kanaan mi angu, mi taloul. ");
INSERT INTO beu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ening aulang base, Het aabang enehe ang naung ibir angu, bot pa ba ue omimi angu, angase metma Abraham ebaang ening iila. Base ana metma edaang emana ening. ");
INSERT INTO beu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham euumur aavening, angu ebele ana etatabit boma tila. LAHATALA Ana Abraham at toang-pina, base ana aabetat tening-rama. ");
INSERT INTO beu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham ana emalea miboma ba ue ehava omimi epasaka ang naung emangpi vengurus angu earu, bot at mateng hula, “Vengmeet aaung-aaung! LAHATALA ba por-burang ening angu, na banang, Ene angu aana metma nat sumpat hula, eningse aana bae Kanaan jangu vengtaaning metma noal Isak enang ana medit ejangu ening niang. ");
INSERT INTO beu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Aarunge aana malekang ila neaabang mamolo, bot nehava omi enehe ang naung iabung, senge jangu nu vengtaaning at hoa metma noal Isak enang ana medit ejangu ening.” ");
INSERT INTO beu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Angmuse malea angu ana Abraham at mateng hula, “Nimang! Aarunge nehe jangu angu, ana kalo eat bae namulung angami hoa niang se, tatalang? Kalo aulang se, na malekang ooal Isak di at eeabang mamolo angumi ila senge, jangu angu ana medi ee, tatalang?” ");
INSERT INTO beu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aarunge Abrahama ana emalea angu at mateng hula, “Vengaanit aaung-aaung! Biar tatalang di, aana bae noal Isak at bale angmomi ila niang! ");
INSERT INTO beu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Aana ekang oomi vang-vang ekang. Lahatala ba Mikavasa doe burang mi angu, Aing ba nearu, bot nat kaluar metma neaabang mamolo angu eahalang, bot nat lamal hoa por anga taang iila. Aing ba nat mateng, bot nat palai tilat hula, ꞌEningse meke anga emangpi Na metma eetabaning ang naung inang.ꞌ Lahatala angu, eningse Aing ba Egahingvala sorga mi angu gahing hoa aapang-pina, senge aana bisa angmomi nehe jangu nu at hoa, metma noal Isak ejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Aarunge kalo nehe jangu angu, ana eat bae aamulung angami hoa niang se, sumpa anga bae aaing taang jehi niang iila. Aarunge biar tatalang di, aana ekang noal Isak at angmomi ila ekang.” ");
INSERT INTO beu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Angmuse malea angu ana atang metma Abraham aput iivang mea, sengmuse ana Abraham at sumpat hula, eningse Abraham eomi angu emangpi ana ening eamulung. ");
INSERT INTO beu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Seng angmuse malea angu ana emanaing eunta angu arinu vengtalail medi. Barang ebili eele ba rupa-rupa ang naung ana medit metma unta ang naung vengeea, sengmuse ana lamal Mesopotamia Nahor ebendar angu mi ila. ");
INSERT INTO beu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Angmuse Abraham emalea angu ila bendar angu mi. Ana eunta ang naung emangpi metma bendar eadil mi, jar eng nu ue angu abung miari. Ved baa angu adana, nehe jangu kaneng ang naung ini hoa jar eng angu mi jar iihi. ");
INSERT INTO beu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Angmuse Abraham emalea angu ana sambajang hula, “LAHATALA, nemanaing Abraham eLahatala. Aana noangmoling, senge nelamal Vede ved anga, bisa egunang veng. Oomi aaung angu, metma nemanaing Abraham etubing, bot epalai ba ana metma veng nat palai angu, Aana vengaani. Base, biar Isak etenangeli angu, vede anga na aing harak. ");
INSERT INTO beu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Na ae jar eng anga eadil mi tahi. Bot bendar anga ejangu kaneng ang naung ini ae hoa hula, angami jar iihi. ");
INSERT INTO beu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Base na banang alang: Nehe jangu taang ba na at mateng hula, ꞌEejar eala angu miadingkir, senge na eejar angu kudi na hengi.ꞌ Kalo ana nehur ebalet hula, ꞌNimang jar ae ba na. Bot nimang eeunta ang naung di, eningse na jar metma mainang ini na.ꞌ Kalo jadit aulang se, na ateing iilat hula, nehe jangu angu ba Aana aing vengtalail metma Eemalea Isak ejangu ening! Bot aulang senge, na ateing hula, Oomi aaung angu Aana metma nemanaing Abraham etubing iila.” ");
INSERT INTO beu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Abraham emalea angu ana sambajang bae seng jedung se, Ribka ana ejar aala angu metma abea taang tevang hoa. Ribka angu, Abraham ekaku iia Nahor, bot Milka oleve idat. Ribka imang angu ene Betuel. Ribka angu etatabit mahena, jedung aana-aana, bot nehe mehal nu at tia di jedung. Ribka ana hela jar eng angmi jar iihit metma ejar eaala angu mi, sengmuse ana bale da. ");
INSERT INTO beu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Angmuse Abraham emalea angu ana bihit va Ribka aing harak, sengmuse ana Ribka at mateng hula, “Eejar aala mi angu metma manenang, senge na kudi na hengi.” ");
INSERT INTO beu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nehe jangu angu ana Abraham emalea ehur angu ebalet hula, “Nimang, jar ae ba na!” Angmuse nehe jangu angu, ana uuser-uuser ejar aala angu at hela atang mi pina, sengmuse metma Abraham emalea angu enang ana na. ");
INSERT INTO beu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nehe jangu angu ana jar metma Abraham emalea angu enang ana na sengmuse, ana mateng hula, “Nimang! Eeunta ang naung di, na jar iihit metma mainang ini na, sampe emangpi iobo-aamunang.” ");
INSERT INTO beu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Angmuse jar ba vede nehe jangu angu eaala mi angu, ana uuser-uuser metma binanta eparak angu mibokong. Sengmuse ana bot bale bihit hela jar eng mi jar iihit baning da metma Abraham emalea eunta ang naung emangpi inang ini na. ");
INSERT INTO beu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nehe jangu ekarajang angu, Abraham emalea ana taimang-taimang tahit eng metma euuling, senge ateing hula, “Lahatala Ana ening elamal angu, egunang veng ee, niang!” ");
INSERT INTO beu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Unta ang naung emangpi jar nat iobo-aamunang sengmuse, Abraham emalea ana kila mas, bot salaka mas pasang nu medi, bot ana metma nehe jangu angu, atang aaru angu mi. ");
INSERT INTO beu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Angmuse Abraham emalea ana nehe jangu angu adangtaaning hula, “Aaing nuba oal se vengbanang, senge na ateing hengi! Na iimang ehava mi tiat miarit vengtahang se, bisa ee niang?” ");
INSERT INTO beu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Angmuse nehe jangu angu, ana Abraham emalea ehur angu ebalet hula, “Nimang ene Betuel. Nidat boma angu ene, Nahor. Bot nidat memet angu ene, Milka. ");
INSERT INTO beu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nihava mi angu, tiang-mana toang, bot binanta emod di toang.” ");
INSERT INTO beu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Vengmeet aulang muse, Abraham emalea angu, ana kuku-muding LAHATALA Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Bot ana mateng hula, “Nemanaing Abraham eLahatala angu, na Aing tajaning-Aing palevang! Se Ana etatabit Omi metma nemanaing Abraham ejahi, bot Aing ba nat toang-pinat hoa nemanaing ekaku ang naung ihava mi angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Angmuse nehe jangu angu, ana bihit ila naba ba jadi angu, metma ihava omi enehe ang naung emangpi veng iat sarenta. ");
INSERT INTO beu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka ekaku mehal angu, ene Laban. Uanguveng Laban ana kila mas, bot salaka mas ba ekaku Ribka atang mi angu uuling ateing, bot naba ba Ribka ana vengsarenta angu vengmee muse, Laban ana uuser-uuser bihit ila Abraham emalea angu aing harak. Laban ana ila se, Abraham emalea angu, bot eunta ang naung veng, jedung ue jar eng abung angmi tahi sehi. ");
INSERT INTO beu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Angmuse Laban ana Abraham emalea angu at mateng hula, “Mahe, pi hava mi ila! LAHATALA Ana aat toang-pina, angu ebele aana bisa hoa angami tila. Etatalang ba aana amota oa angami tahi! Na hava vengharakat metma aadana tila. Eeunta ang naung imana, bot imod di, na vengharaka tila.” ");
INSERT INTO beu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Angmuse Abraham emalea ana Laban amulung ila, Betuel ehava mi maso. Barang ba unta taang ang naung, Laban iimal ini Abraham emalea angu oang-moling at hela. Sengmuse ini jar medit metma Abraham emalea, bot enehe ang naung inang, senge ini metma ia laming. ");
INSERT INTO beu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Aarunge uanguveng, nehe ba hava mi ang naung ini meja taang mod vengharaka muse, Abraham emalea ana mateng hula, “Na banang, pi bae naadang jedung se, palai ba na baning hoa anga, na metma veng iiat hubai hengi.” Angmuse Laban ana Abraham emalea ehur angu ebalet hula, “Naba palai se, mang vengbanang!” ");
INSERT INTO beu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Angmuse Abraham emalea ana mateng hula, “Naing anga, iidat boma Abraham emalea. ");
INSERT INTO beu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","LAHATALA Ana etatabit Eaaung-Ehama ba bae ebale veng niang angu metma nemanaing Abraham enang, angu ebele ana etatabit kavasa. Jumba, aib, arbo, sapi, mas, perak, malea mehal, malea jangu, unta bot keledei, emangpi angu Lahatala Ana metma nemanaing Abraham enang iila. ");
INSERT INTO beu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Bot nemanaing Abraham ejangu Sara oleve angu, boma tila, memet iila, aarunge memet Sara ana vaal mehal nu vengajait metma nemanaing Abraham enang. Nemanaing epasaka ang naung, emangpi ana metma oal mehal angu enang iila. ");
INSERT INTO beu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nemanaing Abraham ana not sumpat hula, ꞌAana ekang Kanaan jangu vengtaaning metma noal Isak enang ana medit ejangu ening ekang. ");
INSERT INTO beu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Aarunge aana malekang nimang ehava mi ila, nekaku ang naung iabung senge, jangu nu vengtaaning at hoa metma noal Isak ejangu ening.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Na nemanaing Abraham ehur angu ebalet hula, ꞌNehe jangu angu, misavaka ana eat bae namulung hoa niang se, tatalang?ꞌ ");
INSERT INTO beu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Aarunge nemanaing Abraham ana mateng hula, ꞌLAHATALA ba na Eomi angu eamulung alolang-niang angu, eningse Aingba Egahingvala sorga mi gahing hoa aat toang-pina, senge ening eelamal angu egunang veng. Aulang senge aana bisa nimang ehava mi, nekaku ang naung iabung jangu nu medit at hoa, metma noal Isak ejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kalo aana jangu angu at angami hoa iila se, eesumpa angu bae aaing taang jehi niang iila. Aarunge kalo nekaku ang naung ini bae jangu angu lapas ana angami hoa niang dise, eesumpa angu bae aaing taang jehi niang iila.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Angu ebele, na vede hoa jar eng abung angu, na sambajang hula, ꞌNimang LAHATALA, nemanaing Abraham eLahatala. Nelamal anga Aana ening egunang veng, senge na bisa Isak etenangeli angu, aing harak. ");
INSERT INTO beu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nimang Lahatala, na ae jar eng abung ngami tahi. Bot bendar anga ejangu kaneng ang naung, ae hoa angami jar iihi. Base, na banang alang: Kalo nehe jangu taang ba na at mateng hula, “Eejar ba aala mi angu, kudi manenang na na hengi.” ");
INSERT INTO beu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kalo nehe jangu angu, ana nehur ebalet hula, “Nimang, jar ae ba na! Bot nimang eeunta ang naung di, emangpi na jar iihit metma mainang ini na.” Kalo jadit aulang se, na ateing iilat hula, nehe jangu anguba Lahatala Ana aing vengtalalil iila, senge metma nemanaing Abraham oal angu ejangu ening!ꞌ ");
INSERT INTO beu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Na sambajang bae evengtahi mi jedung se, Ribka ana eaala jar emana angu metma abea taang tevang hoa, bot ana jar eng angu mi hela, senge jar iihi. Ribka ana jar iihit seng bale da muse, na abanang hula, ꞌEejar ba aala mi angu, kudi manenang, senge naing na hengi.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ribka ana ejar aala ba abea taang angu uuser-uuser at hela, sengmuse ana mateng hula, ꞌNimang, jar ae ba na! Bot eeunta ang naung di, emangpi na jar iihit metma mainang ini na.ꞌ Angmuse na jar na, bot neunta ang naung di emangpi jar na. ");
INSERT INTO beu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Angmuse na Ribka adangtaaning hula, ꞌAaing iimang ene nuba se, vengbanang senge na ateing hengi!ꞌ Ribka ana nehur ebalet hula, ꞌNimang ene Betuel. Nidat boma angu ene Nahor. Bot nidat memet angu ene Milka.ꞌ Angmuse kila aming e angu na metma aming veng ahele, bot salaka pasang nu na metma atang mi. ");
INSERT INTO beu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Angmuse na angmi kuku-muding Lahatala Aing somba, bot mateng hula, ꞌnemanaing Abraham eLahatala angu, na Aing tajaning-Aing palevang! se Aingba napang-pinat hoa angami nemanaing ehava omi enehe ang naung ing harak, senge ioal jangu angu at ila metma nemanaing oal angu, ejangu ening angu ebele.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Base angase, kalo nimang iimal hula iiomi aaung angu metma nemanaing Abraham etubing se, metma veng nat mateng tarang. Bot kalo jadi niang dise, metma veng nat mateng tarang, senge na ateing hula, na malekang taang adang ila hengi.” ");
INSERT INTO beu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Angmuse Laban, bot Betuel oleve Abraham emalea ehur angu ebalet hula, “Kalo LAHATALA Ana vengator aulang iila se, eaaung ejasi angu ni metma veng aat mateng jadi niang. ");
INSERT INTO beu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Eeng uuling, Ribka ana ue aapangaadang mi. Aaung ba aing medit at ila, senge aing metma eemanaing Abraham oal angu ejangu ening, naba ba LAHATALA Ana vengbanang iila angu eamulung.” ");
INSERT INTO beu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Uanguveng Abraham emalea ana Laban, bot Betuel oleve imateng angu vengmee muse, ana tout hela meke mi banang tarima kasi metma LAHATALA Enang. ");
INSERT INTO beu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Angmuse, Abraham emalea ana barang mas-perak, bot pakiang aalus ang naung at kaluar, bot metma Ribka enang. Ribka ekaku Laban, bot iva oleve angu, Abraham emalea ana atangoang ebili eele ang naung, metma mainang. ");
INSERT INTO beu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Seng angmuse, Abraham emalea, bot enehe ang naung, ini mihit naadang hama-hama, bot ini angmi tia. Kukuaveng ini tahi muse, Abraham emalea ana hava manaing angu at hubait hula, “Kalo iini jali se, aaungba ning lapas, senge ni nemanaing ebele ila.” ");
INSERT INTO beu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Aarunge Ribka ekaku Laban, bot iva oleve mateng hula, “Etatalang ba iini hula uuser-uuser ila angu? Vengkilange nioal jangu angu ana jedung niabung mihit ved arinu maveng hengi. Seng angse, ana at ila.” ");
INSERT INTO beu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Aarunge Abraham emalea ana ihur angu ebalet hula, “Ekang naing tahang ekang! LAHATALA Ana nelamal anga ening egunang veng iila. Angu ebele aaungba ning lapas, senge ni nemanaing ebele ila.” ");
INSERT INTO beu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Angmuse Ribka ekaku Laban, bot iva oleve Abraham emalea ehur angu ebalet hula, “Kalo aulang se, nioal jangu angu pi earut adangtaaning hengi. Ana hula tatalang?” ");
INSERT INTO beu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Angmuse ini Ribka earut adangtaaning hula, “Ribka! Angase aana vengjalit nehe anga amulung ila ee, niang?” Ribka ana ekaku, bot iva oleve itaaning angu ebalet hula, “Na vengjali.” ");
INSERT INTO beu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Angmuse Ribka, bot emalea jangu ba Ribka kiki sehi ana aing vengurus angu, Laban iimal ing lapas, senge ini Abraham emalea, bot enehe ang naung iamulung ila. Bot ini aaung-hama vengbanang metma Ribka enang hula, “Ribka! Ni banang, Lahatala Ana aaing veng base, aana vaal vengajai toang-toang, senge eningse eetabaning angu, ribu-ribu, bot laksa-laksa. Bot nehe ba omi metma eetabaning ang naung ialalil angu, eningse eetabaning ang naung ini malekang ening ini iora-vengholong, bot iabang-ilelang angu eetabaning ang naung ini medit metma ioa.” ");
INSERT INTO beu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Angmuse Ribka, bot emalea jangu ang naung ini inaosing taloul, bot unta hila, sengmuse ini Abraham emalea, bot enehe ang naung iamulung. ");
INSERT INTO beu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ved uangu adana, Isak ana jar eng ba Beer Lahai Roi mi angu, mi bale hoa muse, ana Negep aabang mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ved hahela muse, Isak ana teeng mi kaluar hela lamal-lamal. Isak ana apang ohit uuling ateing se, unta toang ue hoa. ");
INSERT INTO beu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Uanguveng Ribka di apang ohit uuling Isak ateing muse, ana uuse-uuser eunta angu taang hela. ");
INSERT INTO beu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Angmuse Ribka ana Abraham emalea angu adangtaaning hula, “Nimang! Nehe mehal nu lamal pibele hoa sehi angu, nuba?” Abraham emalea ana Ribka etaaning angu ebalet hula, “Aing ba nemanaing kuar angu.” Angmuse Ribka ana esalinda medi, bot metma apang vengtering. ");
INSERT INTO beu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Angmuse Abraham emalea ana emangpi angu metma Isak veng at sarenta. ");
INSERT INTO beu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak ana Ribka at iva eteeng mi maso, sengmuse Isak ana Ribka aing medit metma ejangu ening. Isak ana etatabit omi metma Ribka ejahi, angu ebele iva aamina angu, omi bae vengsusa niang iila. ");
INSERT INTO beu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham ana bot taang jangu nu medit metma ejangu ening, ene Ketura. ");
INSERT INTO beu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura ana vaal vengajait metma Abraham enang angu, iene benangba: Simram, Yoksan, Medan, Midian, Isbak, bot Sua. ");
INSERT INTO beu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan oal benangba; Seba, bot Dedan. Dedan etabaning ba; Asyur enehe ang naung, Letus enehe ang naung, bot Leum enehe ang naung. ");
INSERT INTO beu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian oal naung benangba; Efa, Efer, Henok, Abida, bot Eldaa. Ing emangpi angu, Ketura etabaning. ");
INSERT INTO beu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Abraham jedung aabeta sehi angu, ana epasaka ang naung emangpi metma oal Isak enang iila. Aarunge ejangu Hagar, bot Ketura oleve ioal ang naung, Abraham ana atangoang ba paul metma nu-nut inang, senge metma ipasaka ening. Seng angmuse ana ing gahing iot tahit lamal Isak eahalang ila Kanaan eved danangoa angmi mihi, senge ini Isak eola. ");
INSERT INTO beu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham euumur mitung 175 muse, ana aamina. Uanguveng ana aamina angu, ana etatabit boma tila, bot oong di etatabit bala tila. ");
INSERT INTO beu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Angmuse oal Isak, bot Ismael oleve aing metma Makpela epa ba, Mamre abung angu, mi taloul. Pa angu, turangmi Abraham ana Het aabang enehe nu ene Sohar angu, oal ene Efron angu abung beli tila. Tura Abraham ejangu Sara di, ini aing metma pa angu mi taloul. ");
INSERT INTO beu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham ana aamina tila muse, Lahatala Ana Eaaung-Ehama ba bae ebale veng niang angu metma oal Isak enang, angu ebele Isak ana aabetat tening-rama. Bot Isak ana jar eng Lahai Roi angu, abung mihi. ");
INSERT INTO beu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Angaba Ismael esarenta. Ismael angu, Abraham bot ejangu gariang ene Hagar angu oleve ioal. Hagar angu, Sara emalea. Masir enehe. ");
INSERT INTO beu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael oal mehal angu, inang arinu belta aalu. Anga iene ba mitamulung, mutu sampe iia, benangba; Nebayot, Kedar, Abdel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis, bot Kedma. Ismael oal mehal ang naung, ing metma bangsa arinu belta aalu eidat-imang ening. Nu-nut eaabang veng. Bot ini nu-nut iaabang angu ene maveng, iene angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael euumur mitung 137 muse, ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Aarunge etabaning ang naung, emangpi bae itat sanang niang. Angu ebele ini tarae-teapahing mihi, mulai Hawila mi sampe ila Syur ba Masir abung angu mi. ");
INSERT INTO beu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Anga Isak Abraham oal angu esarenta. Abraham ba Isak aing vengajai. ");
INSERT INTO beu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak euumur mitung ari buta muse, ana Ribka Betuel oal, Laban ekaku jangu ba Padan Aram mi angu, medit metma ejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak ana sambajang LAHATALA Abanang, metma ejangu Ribka adana, se Ribka atou pamar-jasi angu ebele. Lahatala ana Isak ebanang angu akanap muse, ejangu Ribka ana atou veng. ");
INSERT INTO beu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Aarunge vaal aaru ba Ribka ana vengtoda, base vaal ang naung ini Ribka atou mi tatatobang alolang-niang. Angmuse Ribka ana mateng hula, “Kalo vaal aaru alang se, tatalang senge na bisa aabeta?” Angmuse Ribka ana Lahatala Abanang, senge Lahatala ana via metma etubing. ");
INSERT INTO beu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Lahatala ana Ribka at mateng hula, “Bangsa aaru ba eningse toang-tahit alolang-niang angu, ue aatou mi. Bangsa nu angu eningse lebe midaeri, bangsa nu angu mi ataangoa. Eningse vaal ba iia angu lebe midaeri, vaal mutu angu mi ataang oa. Bot vaal ba mutu angu eningse metma vaal iia angu emalea ening.” ");
INSERT INTO beu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Base, ejol mi tila muse, Ribka ana vaal mehal aaru takohal vengajai. ");
INSERT INTO beu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Vaal ba mutu angu kaluar se, ehul angu tena, bot eboa angu emangpi eamudi veng, emenghula kondo eamudi veng angu edadenang. Angu ebele ini vaal angu ene maveng hula, Esau, (evengbanang tarang se hula, ꞌeamudi vengꞌ. ");
INSERT INTO beu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Seng angmuse ekaku iia angu kaluar. Aarunge atang angu ana metma ekaku mutu Esau ekudavali angu vengpina. Angu ebele ini vaal angu ene maveng hula, Yakob, (evengbanang tarang se hula, ꞌkudavaliꞌ. Uanguveng Esau bot Yakob oleve ing vengajai angu, Isak euumur mitung 60. ");
INSERT INTO beu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Angmuse Esau, bot Yakob oleve taang aaele-aaele. Esau ekarajang ba binanta vengkori. Bot ana sukat banaha mi mihi. Aarunge Yakob angu papaumang, bot ana sukat hava ba mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak ana sukat binanta banaha mi angu euumung adang. Angu ebele ana omi metma Esau ejahit milebe. Aarunge Ribka aing omi metma Yakob ejahit milebe. ");
INSERT INTO beu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ved nu adana, Esau ana uhavede dadi mi binanta vengkori ba hoa se, Yakob ana taur doa sehi. Esau etatabit lusu, bot etatabit malapal. ");
INSERT INTO beu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Angu ebele Esau ana Yakob at hubait hula, “Kaku! Eetaur tena ba aana doa angu, kabingdena metma manenang, senge na adang hengi! Na etatabit malapal anga.” (Angu ebele ini Esau earut hula, Edom, evengbanang tarang se hula, ꞌtenaꞌ.) ");
INSERT INTO beu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Angmuse Yakob ana Esau ehur angu ebalet hula, “Kaku, na vengjali! Aarunge eemutu angu aana malekang metma manenang hengi. ");
INSERT INTO beu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau ana Yakob ehur angu ebalet hula, “Nemutu angu egunang naba! Aaungba aana medi, senge taur tena angu uuser ohit manenang na adang. Misabantar se, na malapal aamina.” ");
INSERT INTO beu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Aarunge Yakob ana ekaku Esau at mateng hula, “Kaku! Aana malekang nat sumpat hula, eemutu angu aana metma manenang iila hengi.” Angmuse Esau ana Yakob at sumpa, bot ana emutu angu ohit metma Yakob enang. ");
INSERT INTO beu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Seng angmuse Yakob ana taur tena angu bot roti veng metma Esau enang. Esau ana adang sengmuse, ana tahit lamal. Esau ana vengomit hula, emutu angu bae egunang veng niang. Angu ebele ana ening aulang. ");
INSERT INTO beu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Minu adana angu, malapal-tabonggal eele hela aabang angu mi, emenghula uanguveng Abraham jedung aabeta sehi angu edadenang. Angu ebele, Isak ana Abimelek Filistin enehe ang anung iraja angu ebele ila abanang, senge kalo bisa se ana Gerar mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Angmuse LAHATALA Ana Ava metma Isak etubing, bot at hubai hula, “Aana ekang Masir mi ila ekang. Aabang ba eningse Na metma veng aat hubai, anguba aana mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Aabang anga ba aana mi mihi, emenghula nehe hoangmanang edadenang, eningse Na aat toang-pina, bot aaung-hama ba bae ebale veng niang angu, metma maeenang. Eetabaning angu, eningse Na ening toang-rae, emenghula iid burang mi angu edadenang. Bot aabang anga eningse Na metma maeenang, bot metma eetabaning ang naung emangpi inang. Eetabaning ang naung ini aabetat Neamulung angu ebele, eningse bangsa-bangsa ba por-alolang taang angu, emangpi aaung-hama metma ioa. Se Nepalai ba Na metma Abraham veng at palai tila angu, Na ening akanap angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Emangpi anga Na ening, se iimang Abraham ana NeNomi angu eamulung, Neparenta angu eamulung, bot Nevi-via angu eamulung iila angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Base Isak ana Gerar mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Uanguveng nehe ba mana angu mi ang naung ini Isak ejangu Ribka angu aing vengtaaning muse, Isak ana ihur ebalet hula, “Ribka angu, nekaku jangu.” Isak ana uangmarit hula, kalo ana vengbanang hula Ribka angu ejangu se, misavaka aabang angu enehe ang naung ini ameang, se Ribka angu etatabit mahena angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak ana aabang angu mi mihit luung iila. Ved nu adana, Abimelek Filistin enehe ang naung iraja angu ana jendela mi uuling ateing se, Isak bot ejangu Ribka oleve ue taing karavang tamiku sehi. ");
INSERT INTO beu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Angmuse Abimelek ana Isak eaaru, bot at mateng hula, “Isak! Na etatabit ateing iilat hula, aing angu eejangu! Aarunge etatalang ba aana vengbanang hula, aing angu eekaku?” Angmuse Isak ana Abimelek ehur angu ebalet hula, “Alang, Nimang! Na nuangmari, se kalo na vengbanang hula aing nejangu se, misavaka nehe nameang.” ");
INSERT INTO beu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Aarunge Abimelek ana mateng hula, “Etatalang ba aana ening alang metma niada nagu? Kalo nehe angami anga naung nu ejangu angu at tia se, aana malekang ning ening ahala!” ");
INSERT INTO beu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Angmuse Abimelek ana parenta kaluar metma bangsa angu miipit vengbanang hula, “Iing emangpi vengaanit aaung-aaung! Nuba ba nehe anga, bot ejangu anga oleve ing galakang se, nehe angu na aing hukung ameang.” ");
INSERT INTO beu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Tung angu omimi, Isak ana aabang angu mi namuding. Naba ba ana muding angu, eihi miratunu. Se LAHATALA Ana Eaaung-Ehama metma maenang angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isak ekavasa angu taang maveng alolang-niang, angu ebele ana etatabit kavasa. ");
INSERT INTO beu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Esapi, bot ejumba, eaib etatabi toang. Bot emalea di etatabi toang. Base Filistin enehe ang naung ini iomi metma ealalil. ");
INSERT INTO beu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Jar eng ba tura Isak imang Abraham ejamang mi, Abraham emalea ang naung aanang angu toang. Aarunge angase, Filistin enehe ang naung ini, jar eng ang naung emangpi meke metma vengtering iila. ");
INSERT INTO beu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Angmuse raja Abimelek ana Isak at mateng hula, “Isak! Lebe miaaung, aana tahit lamal aabang anga eahalang. Se eekavasa angu lebe mieele, mi niataang oa tila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Base, Isak ana mana angumi ava asorong, bot bale ila Gerar moar mi teeng dodu, sengmuse ana angumi mihi. ");
INSERT INTO beu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Angmuse jar eng ba Abraham ejamang mi nehe aanang, bot Filistin enehe ang naung ini meke metma vengtering angu, emangpi Isak ana bale aanang. Bot Isak ana jar eng ang naung emangpi iene maveng, tura imang Abraham ana iene maveng angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak emalea ang naung ini Gerar moar mi jar aanang angu, jar eng halu adana, base jar angu etatabit aaving. ");
INSERT INTO beu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Angmuse Gerar aabang eterangvala ang naung ini Isak eterangvala ang naung iat tota, se jar eng angu ebele. Gerar aabang eterangvala ang naung ini vengbanang hula, “Anga ni jar!” Angu ebele Isak ana jar eng angu ene maveng hula, Esek, evengbanang tarang se hula, ꞌvengtotaꞌ. Se ini angmomi Isak at tota angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Angmuse Isak emalea ang naung ini bot jar eng nu aanang, aarunge ini bot jar angu vengtota. Angu ebele Isak ana jar eng angu ene maveng hula, Sitna, evengbanang tarang se hula, ꞌtaing lavangꞌ. ");
INSERT INTO beu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isak ana lamal mana angu eahalang, sengmuse ana bot jar eng aabeung aanang. Aarunge jar eng angu, ini bae vengtota niang. Angu ebele Isak ana jar eng angu ene maveng hula, Rehobot, evengbanang tarang se hula, ꞌmana berangꞌ. Bot Isak ana mateng hula, “Angase Lahatala Ana mana berang metma mapinang pi mi mihi tila. Senge mana angami, pi bisa tabaning-taheli bot taang maveng toang.” ");
INSERT INTO beu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mana angu mi, Isak ana bot tahit lamal, sengmuse ana ila Beer Syeba mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kua angu veng, LAHATALA Ana Ava metma Isak etubing, bot at mateng hula, “Isak! Naing anga, iimang Abraham eLahatala. Base, aana ekang uuangmari ekang, se Na aat toang-pina angu ebele. Eningse aaung-hama angu, Na metma maeenang, bot eetabaning angu Na ening toang-rae, se emangpi angu Na metma iimang Abraham at palai tila angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Angmuse Isak ana mana angumi doru ohi. Bot ana banang tarima kasi metma Lahatala Enang. Ana mana angumi teeng dodu, bot ini mana angu mi mihi. Angmuse emalea ang naung ini angumi jar aanang. ");
INSERT INTO beu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Minu adana, raja Abimelek ana Gerar mi ba hoa, sengmuse ana Isak aing harak. Eserang Asuhat, bot ekapala malibal ene Pikhol angu, ana iat hama-hamat hoa. ");
INSERT INTO beu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aarunge Isak ana iat mateng hula, “Nimang raja! Tura iini iiomi metma nealalil, bot iini naterit kaluar iiaabang angu eahalang iila. Etatalang ba iini nebele hoa, bot naing harak?” ");
INSERT INTO beu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Angmuse ini Isak ehur angu ebalet hula, “Ni ateing iilat hula, Lahatala Ana aat toang-pina. Angu ebele, aaungba pi tat sumpa, bot pi tat palait hula alang: ");
INSERT INTO beu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Aana bae jasi iiba ening metma niada niang, emenghula ning di bae jasi iiba ening metma aadana niang angu edadenang. Ni etatabit niomi aaung metma aadana, angu ebele tura aana kaluar niaabang anga eahalang angu, ni aat toang-aaung ba aana lamal angu. Bot ni etatabit ateing hula, LAHATALA ba, Eaaung-Ehama bae ebale veng niang angu metma maeenang.” ");
INSERT INTO beu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Angmuse Isak ana pesta ening metma iadana, bot ini naadang-jalnat hama-hama. ");
INSERT INTO beu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Emitobang kukuaveng muse, ini itat sumpa, bot tominu-tahanu, sengmuse Isak ana ing lapas ini ila. ");
INSERT INTO beu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ved uanguveng angu, Isak emalea ba jar aanang ang naung hoa, sengmuse ini Isak at hubait hula, “Nimang! Ni jar harak iila.” ");
INSERT INTO beu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Angmuse Isak ana jar angu ene maveng hula, Syeba, evengbanang tarang se hula, ꞌsumpaꞌ. Angu ebele, angase bendar angu ini ene maveng, Beer Syeba angu. ");
INSERT INTO beu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau euumur mitung ari buta tila muse, ana Het aabang jangu aaru medit metma ejangu ening. Nu angu ene Yudit, imang angu ene Beeri. Bot nu angu ene Basmat, imang angu ene Elon. ");
INSERT INTO beu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nehe jangu aaru angu, ini ening Isak bot ejangu Ribka oleve iomi etatabit susa. ");
INSERT INTO beu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Uanguveng Isak ana boma tila muse, eng angu etatabit moro, base ana bae uuling bir ateing niang. Oal mutu Esau ba ana etatabit omi metma ejahi angu ana earut hula, “Esau! Aana angami ma hengi!” Angmuse Esau ana imang ebalet hula, “Tatalang, nimang?” ");
INSERT INTO beu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak ana mateng hula, “Eeng uuling! Na boma tila. Nejol aamina angu, na bae ateing niang. ");
INSERT INTO beu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Angu ebele, ee aba, bot eeuumat-aburit ang naung medi, senge ila dadi mi binanta nu vengkorit baning hoa metma manenang hengi. ");
INSERT INTO beu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Aana vengkarajang doat ening tamaa-tamaa ne nomi suka angu eamulung, seng angse baning ma metma manenang, senge na adang. Senge na bae aamina jedung anga ba, aaung-hama angu na vengbanang metma maeenang.” ");
INSERT INTO beu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aarunge naba ba Isak ana vengbanang metma oal Esau veng at hubai angu, Ribka ana vengmee. Angu ebele Esau ana ila dadi mi binanta vengkori tila muse, ");
INSERT INTO beu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribka ana oal Yakob at hubait hula, “He, Yakob! Vede iimang ana eekaku Esau at hubai angu, na vengmee tila. Iimang ana Esau at hubait hula alang: ");
INSERT INTO beu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ꞌAana ila binanta nu vengkorit baning hoa, vengkarajang doat ening tamaa-tamaa, senge metma manenang na adang. Na adang seng se, na bae aamina jedung anga ba, aaung-hama angu na LAHATALA Apangaadang mi vengbanang metma maeenang.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Base angase, aana nehur anga vengmeet aaung-aaung! Bot naba ba na vengparenta angu, aana malekang etatabit eamulung. ");
INSERT INTO beu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Angase aana ila pijumba-aib emana angu mi senge, aib hamang iboa aalus angu, aaru medit baning hoa. Eningse na vengkarajang doat ening tamaa-tamaa iimang eomi suka angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kalo na doat sengila se, aana baning va metma iimang enang ana adang, senge ana bae aamina jedung anga, aaung-hama angu ana vengbanang metma maeenang. Ening aulang senge, aaung-hama angu metma aaing ba eeoa. Bae eekaku Esau niang.” ");
INSERT INTO beu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Angmuse Yakob ana iva at hubait hula, “Niva! Nekaku Esau eboa angu eamudi veng, aarunge naing neboa anga dula! ");
INSERT INTO beu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Misavaka nimang ana naing panahing neboa angu dei muse, eningse nimang ana hula, na aajajala. Base aaung-hama bae metma neoa niang, aarunge kutuk ba metma neoa!” ");
INSERT INTO beu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Aarunge Ribka ana Yakob at hubait hula, “Aaing oomi ekang vang-vang ekang! Emangpi angu naing ba vengator! Kalo iimang ana aaing kutuk se, biar kutuk angu naing ba tevang! Base nemateng anga venghele, senge ila aib ang naung medi.” ");
INSERT INTO beu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Angmuse Yakob ana ila aib ang naung medit baning hoa metma iva enang. Seng angmuse iva ana vengkarajang doat ening tamaa-tamaa, imang eomi suka angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Angmuse Ribka ana oal mutu Esau epakiang aalus angu medi, sengmuse ana metma oal Yakob enang ot pake. ");
INSERT INTO beu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Bot aib ebuar angu Ribka ana medit metma Yakob atang aaru, bot obo angu baloli. ");
INSERT INTO beu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Seng angmuse mod tamaa, bot roti ba Ribka ana ening iila angu, ana metma Yakob enang. ");
INSERT INTO beu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakob ana mod angu aantar baning imang emana mi mida, sengmuse ana imang at hubait hula, “Nimang! Na hoa iila anga.” Angmuse Isak ana ebalet hula, “Ya noal, aaing ba nuba?” ");
INSERT INTO beu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob ana imang ehur angu ebalet hula, “Naing ba Esau, ooal mutu angu! Naba ba nimang aana vede vengbanang angu, na eamulung ening aulang iila. Aaungba tahit mihi, senge binanta ba na vengkorit baning hoa doa tila anga adang. Adang seng angse, aaung-hama angu, vengbanang metma manenang!” ");
INSERT INTO beu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Angmuse Isak ana oal angu at hubait hula, “Noal, binanta angu aana bisa uuser-uuser harak aulang?” Aarunge Yakob ana imang ehur angu ebalet hula, “LAHATALA ba nimang aana Aing somba angu ba, ening na uuser binanta angu harak ba angu.” ");
INSERT INTO beu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isak ana Yakob at hubait hula, “Aana ma nabung-nabung, senge na eeboa angu panahing hengi! Aaing anga, etatabit Esau ee, niang?” ");
INSERT INTO beu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakob ana va imang abung-abung muse, imang ana mulai aing panahing. Sengmuse Isak ana mateng hula, “Amal anga, Yakob amal! Aarunge atang anga, Esau atang.” ");
INSERT INTO beu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isak ana bae uuling Yakob apang ateing niang, aarunge Yakob atang angu eamudi veng emenghula Esau atang edadenang base, Isak hula aaung-hama angu vengbanang metma maenang. Aarunge uanguveng Isak hula aaung-hama angu vengbanang metma Yakob enang muse, ");
INSERT INTO beu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isak ana bot bale Yakob adangtaaning hula, “Aaing anga, etatabit Esau ee, niang?” Yakob ana imang etaaning angu ebalet hula, “Etabi nimang!” ");
INSERT INTO beu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Angmuse Isak ana mateng hula, “Aana mod angu at ma metma nabung amihing, senge uumung ba aana vengkorit baning hoa doa tila angu, na adang. Na adang senge, aaung-hama angu na vengbanang metma maeenang.” Base Yakob ana mod angu metma imang abung amihing muse, imang ana adang. Yakob ana anggur di baning hoa metma imang enang ana na. ");
INSERT INTO beu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Seng angmuse Isak ana Yakob at hubait hula, “Noal! Ma nabung-nabung anga mi, senge namiku.” ");
INSERT INTO beu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakob ana va imang abung-abung muse, ana imang amiku. Uanguveng Isak ana Yakob epakiang ehara angu rasa muse, Ana aaung-hama angu vengbanang metma Yakob enang hula, “Noal ehara anga, etatabit emenghula dadi napa ba, LAHATALA Ana Eaaung-Ehama bae ebale veng niang metma vengbokong iila, ehara angu edadenang. ");
INSERT INTO beu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Lahatala Ana Emopung burang mi angu metma aaing vengbokong, senge eemeke ba aana vengkarajang angu, ening aabua! Senge aara-gandum, bot anggur eihi angu, Ana metma maeenang toang-rae. ");
INSERT INTO beu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Bangsa-bangsa ang naung eningse emangpi aaing vengtou, bot lelang-lelang ba bangsa ang naung mi angu, eningse emangpi aaing aada-aaing somba. Eekaku ang naung, eningse emangpi aana ing parenta, bot eningse ing emangpi aapangaadang mi aaing vengtou. Nehe ba kutuk metma maeenang angu, eningse kutuk angu bale metma iadana. Bot nehe ba aaung-hama vengbanang metma aadana angu, eningse ing di aaung-hama angu harak.” ");
INSERT INTO beu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak ana aaung-hama angu vengbanang metma Yakob enang sengmuse, Yakob ana uhavede kaluar imang eahalang se, ekaku Esau ila binanta vengkori benang, hoa iila. ");
INSERT INTO beu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau di mod tamaa-tamaa angu vengharaka sengmuse, ana baning va metma imang enang. Bot ana imang at hubait hula, “Nimang! Aaungba tahit mihi, senge uumung ba na ila vengkorit baning hoa doa tila anga adang. Adang seng angse, aaung-hama angu vengbanang metma manenang.” ");
INSERT INTO beu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aarunge Isak omi iipi-sehi angmuse ana taaning hula, “Ee! Aaing anga nuba?” Esau ana imang etaaning angu ebalet hula, “Naing anga, Esau! Ooal mutu angu.” ");
INSERT INTO beu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Angmuse Isak ana etatabit mibaroti, bot mateng hula, “Kalo aulang se, nuba ba uumung angu vengkori, bot baning hoa metma manenang iila angu? Aana bae hoa jedung muse, emangpi angu na adang iila. Bot aaung-hama angu na vengbanang metma maenang iila. Base aaung-hama ba aing veng iila angu, na bale medit jadi niang iila.” ");
INSERT INTO beu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau ana imang ehur angu vengmeet aulang muse, omi etatabit dira, bot ana baut etatabi, sengmuse ana amal aelet imang at mateng hula, “Adoo! Nimang ee! Aaung-hama angu vengbanang metma nandi manenang hengi, nimang!” ");
INSERT INTO beu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aarunge Isak ana Esau ehur angu ebalet hula, “Eekaku Yakob hoa naajajala, bot aaung-hama ba metma eeoa angu, taavit medi tila.” ");
INSERT INTO beu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Angmuse Esau ana mateng hula, “Ana naajajalat miaaru tila. Ehalomang angu, ana naajajalat nemutu angu rampas medi. Bot angase ana aaung-hama ba metma nadana angu di rampas medi. Ana ening aulang angu ba ene, ꞌYakobꞌ angu. Nimang, kalo aulang se, aaung-hama aabeung metma nadana iiba, bae ue niang ka?” (Ene Yakob angu, evengbanang tarang se hula, ꞌkudavali vengpinaꞌ. Aarunge evengbanang tarang aabeung angu hula, ꞌnehe aajajalaꞌ.) ");
INSERT INTO beu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Angmuse Isak ana Esau ehur angu ebalet hula, “Na aing ohit metma eemanaing ening iila. Bot ekaku emangpi angu na metma maenang, senge metma emalea ening. Bot aaung-hama angu na vengbanang metma maenang iila base, aara-gandum, bot anggur eipi angu, bae oang-kurang niang. Base, noal ee! Angase aaung-hama taang ba jedung ae, senge na metma maeenang?” ");
INSERT INTO beu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau ana imang ehur angu vengmeet aulang, aarunge ana imang abanang alolang-niang hula, “Aaung-hama nu kakolang anguba nimang aaing veng ka? Aaung-hama aabeung ue se, metma manenang hengi. Biar kiki nu di aaung!” Bot Esau ana baut amal aelet etatabi. ");
INSERT INTO beu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Angmuse Isak ana Esau ebalet hula, “Etatabit emihing mana angu, eningse meke aabua ba ae por-alolang taang anga eola, se mopung burang mi angu, bae eemeke angu venghorung ening abareka niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Eekalevang anguba, eningse aaing ening aabeta. Biar tatalang dise, aaing metma eekaku emalea ening. Aarunge kalo aana etatabit aing lavang se, eningse aana bisa lohit metma eekaku atang angu eahalang.” ");
INSERT INTO beu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau ana etatabit omi metma ekaku Yakob elalalil, se aaung-hama angu imang ana metma ekaku Yakob enang iila angu ebele. Angmuse Esau ana ava at mateng hula, “Luung niang se, nimang ana aamina. Base uanguveng anguba, na malekang nekaku Yakob angu ameang!” ");
INSERT INTO beu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Esau emateng angu nehe metma Ribka at hubai muse, ana oal Yakob eaaru, bot at mateng hula, “Eekaku Esau ana omi metma eealalili hula malekang aameang. Base nehur anga venghele, bot aava vengharaka, senge bihit Haran mi iimaela Laban ebele ila. ");
INSERT INTO beu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ila angmomi iimaela Laban abung mihit laluung, sampe eekaku Esau ealil ");
INSERT INTO beu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","bot eamara metma aadana angu mitalolang, bot naba ba aana ening metma adana tila angu ana vengtajebing. Eningse na nehe gahing iot ila, senge aat bale hoa. Ooleve hama-hamat napangaadang mi ue niang ved nu omimi se, na etatabit neea!” ");
INSERT INTO beu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Angmuse Ribka ana Isak at hubait hula, “Esau ejangu Het aabang enehe anga naung na iat aabeta angu, nedada tila! Kalo Yakob di Het aabang enehe ba medit metma ejangu ening se, lebe miaaung na mang aamina.” ");
INSERT INTO beu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Angmuse Isak ana Yakob earu, sengmuse ana Lahatala Eaaung-ehama angu metma maenang, bot avomung-apahang hula, “Vengmeet aaung-aaung! Aana ekang Kanaan jangu medit metma eejangu ening ekang. ");
INSERT INTO beu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Aava vengharaka, Padan Aram mi ila, iidat boma Betuel ehava mi. Aana ila senge iiva ekaku Laban oal jangu ang naung, nu medit metma eejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Eningse Lahatala ba Eele-Balolu angu Ana Eaaung-Ehama ba bae ebale veng niang angu metma maeenang, senge aana tabaning-taheli ooal-iidat angu ening toang-rae, bot eetabaning angu metma bangsa-bangsa ening. ");
INSERT INTO beu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Na Lahatala Abanang, senge Epalai ba, Ana metma iidat boma Abraham at palai tila angu, Ana metma maeenang, bot metma eetabaning ang naung di inang. Senge aabang ba turangmi Lahatala Ana metma iidat boma Abaraham at palai tila, bot aana ae mi mihit emenghula nehe hoangmanang edadenang anga, Ana metma maeenang. ");
INSERT INTO beu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isak ana mateng sengmuse, ana Yakob aing lapas Padan Aram mi imaela Laban ebele ila, idat boma Betuel ehava mi. ");
INSERT INTO beu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau ana vengmee se hula, Isak ana Lahatala Eaaung-Ehama angu vengbanang metma Yakob enang iila, bot ana ehapat hula ot ekang Kanaan jangu medit metma ejangu ening ekang. Bot Esau vengmee se hula, Isak ana Yakob at hubait hula, ot ila Padan Aram mi, senge Laban oal jangu ang naung ba nu medit metma ejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Bot Yakob ana iva, bot imang oleve ihur angu eamulung base, ana lamal Padan Aram mi ila tila. ");
INSERT INTO beu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Angmuse Esau di ava rasa se hula, kalo ana Kanaan jangu medit metma ejangu ening se, imang bae suka niang. ");
INSERT INTO beu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Base Esau ana Ismael ebele ila, sengmuse ana Ismael oal jangu ene Mahalat angu medit metma ejangu ening. Mahalat angu, Ismael Abraham oal angu, oal jangu. Nebayot ekaku jangu. ");
INSERT INTO beu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Angmuse Yakob ana Beer Syeba mi tahit lamal, Padan Aram mi ila. ");
INSERT INTO beu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yakob ana lamal ila mana nu mi se, ved baa tila, angmuse ana angumi tia. Uanguveng ana hula tia muse, var nu ue mana angu mi jehi angu, ana medit metma oong emea ening. ");
INSERT INTO beu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kua angu adana, Yakob ana iipal na. Ana uuling ateing se, via nu ae por-alolang taang tahi, etupa angu aavening ila doe burang mi. Bot Lahatala Egahingvala sorga mi ang naung ue via angu oat mida-hela sehi. ");
INSERT INTO beu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Iipal omimi angu, Yakob ana uuling ateing se, Lahatala Ana ue abar oa angmi tahi, bot mateng hula, “Naing anga ba iidat boma Abraham eLAHATALA, bot iimang Isak eLAHATALA. Meke ba ae mana anga mi anga, eningse Na metma maeenang, bot metma eetabaning ang naung di emangpi mainang. ");
INSERT INTO beu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Eningse eetabaning ang naung etoang angu, emenghula meke-labutung edadenang. Bot eningse ini lamal tarae-teapahing ila mana-mana ang naung emangpi mi. Aaing bot eetabaning ang naung aabetat Lahatala Eamulung base, nehe ba por-alolang taang ang naung di, emangpi Lahatala Eaaung-Ehama ba bae ebale veng niang angu harak. ");
INSERT INTO beu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Vengaanit aaung-aaung! Aana lamal ila taang mi dise, Na etatabit aat toang-pina, bot Na aaing jaga. Eningse Na bot aat bale hoa aabang anga mi, aarunge Na bae aaing bia niang, bot naba ba Na metma aat palai tila angu, Na malekang ening metma aadana. ");
INSERT INTO beu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Uanguveng Yakob ana mibaroti tahit mihi muse, ana mateng hula, “Na uhavede ateing hula, LAHATALA Ana etatabit ae mana angami, aarunge na bae ateing niang!” ");
INSERT INTO beu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakob ana uangmari, angmuse ana mateng hula, “Ah! Mana anga ening piaamudi tahi. Anga bae aabeung niang, aarunge Lahatala Ehava, bot sorga aabang hamulang angu, eviaha ae angami.” ");
INSERT INTO beu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Emikuaveng muse, var ba Yakob ana paket metma oong emea angu ana medi, sengmuse ana bakung atahing, senge metma tanda ening. Sengmuse Yakob ana iipil metma var angu taang bokong, bot ana Lahatala Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yakob ana mana angu ene maveng hula, Betel, evengbanang tarang se hula, ꞌLahatala Ehavaꞌ. (Tura mana angu ene, Lus). ");
INSERT INTO beu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Angmuse Yakob ana sumpat hula, “Kalo Lahatala Ana nat toang-pina, bot nelamal anga Ana kilang naing jaga, mod-jal bot pakiang metma manenang, ");
INSERT INTO beu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","bot Ana nat bale aaung-hamat ila nimang ehava mi se, Lahatala angu, na Aing metma neLahatala ening. ");
INSERT INTO beu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Bot var ba na bakung atahing metma tanda ening anga, metma Lahatala ehava ening. Bot emangpi ba Lahatala Ana metma manenang angu, baang arinu se, na baang nu bale metma Lahatala Enang.” ");
INSERT INTO beu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Angmuse Yakob ana angmi tahit lamal ved danangoa adang ila. ");
INSERT INTO beu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ved nu adana, ana eng uuling se, jar eng nu ue dadi mi, aabang nu abung angu, ana ateing. Bot jar eng abung angu jumba-aib kumpul tue ue tia sehi, se jar angu ba nehe metma jumba-aib ang naung inang ini na angu ebele. Aarunge var halala eele nu nehe metma jar eng angu vengtering. ");
INSERT INTO beu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Base, jumba-aib ang naung kalo emangpi nehe terang ila jar eng angu abung iila se, terangvala ang naung ini var angu aoring metma jar eng angu eahalang, senge jar angu metma jumba-aib ang naung inang ini na. Seng angse, ini bot bale var angu metma jar eng angu vengtering. ");
INSERT INTO beu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakob ana terangvala ang naung iadangtaaning hula, “Kaku naung! Iing anga, taang mi ba hoa?” Angmuse terangvala ang naung ini Yakob ebalet hula, “Ning anga, Haran aabang enehe.” ");
INSERT INTO beu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakob ana bot iadangtaaning hula, “Nimaeela Laban angu, iini apang-ateing ka? Aing angu Nahor oal.” Angmuse terangvala ang naung ini hula, “Ni apang-ateing.” ");
INSERT INTO beu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakob ana bot taaning hula, “Ana ue aaung-aaung ee, niang? Terangvala ang naung ini Yakob ebalet hula, “Ana aaung-aaung. Aarunge eeng uuling, oal jangu Rahel ana ejumba-aib ang naung terang hoa senge hula, angami jar metma mainang ini na.” ");
INSERT INTO beu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Angmuse Yakob ana terangvala ang naung iat mateng hula, “Ved jedung balolu sehi. Anga bae ooras binanta kumpul jedung. Base, binanta ba kumpul angami tila angu, aaung ba iini jar metma mainang ini na. Seng angse, iini bale ing terang ila dadi mi, senge ini bot dadi adang.” ");
INSERT INTO beu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Aarunge terangvala ang naung ini Yakob ehur angu ebalet hula, “Terangvala ang naung ini bae binanta ang naung emangpi terang hoa angami jedung se, ni bae ening aulang niang. Ni malekang iading ini hoa angami senge, ni hama-hamat var angu aoring metma jar eng angu eahalang, bot jar angu metma binanta ang naung inang ini na. ");
INSERT INTO beu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob ana jedung terangvala ang naung iat mateng sehi se, Rahel ana imang ejumba-aib ang naung terang hoa mana angumi. Se aing ba biasat binanta ang naung terang angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Uanguveng Yakob ana uuling ateing se, Rahel ana ejumba-aib ang naung terang hoa muse, ana lamal va abung, bot var ba jar eng vengtering angu aoring. Sengmuse ana jar metma imaela Laban ebinanta ang naung inang ini na. ");
INSERT INTO beu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Angmuse Yakob ana Rahel amiku, bot baut etatabi. ");
INSERT INTO beu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakob ana Rahel at sarentat hula, “Kaku! Naing anga, iimang ekaku Ribka oal.” Angmuse Rahel ana bihit ila imang veng at sarenta. ");
INSERT INTO beu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban ana ekaku Ribka oal Yakob ehoja angu vengmeet aulang muse, ana bihit ila Yakob aing sambut. Uanguveng Laban ana Yakob aing harak muse, ana aing karavang, bot amiku, sengmuse ana at ehava mi ila. Angmuse Yakob ana elamal-etahi angu metma Laban veng at sarenta. ");
INSERT INTO beu_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Laban ana Yakob at mateng hula, “Etatabit poleve anga, venu-dingnu!” ");
INSERT INTO beu_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Yakob ana Laban abung mihit eluung miuuru nu muse, ");
INSERT INTO beu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban ana at mateng hula, “Poleve anga teaaiiba, aarunge kalo aana karajang paraseng metma manenang se, na nea. Naba ba metma eeseva ening se, aana vengbanang.” ");
INSERT INTO beu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban angu oal jangu aaru. Ehalomang angu ene Lea, emiaaru angu ene Rahel. ");
INSERT INTO beu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea eng angu sibal. Aarunge Rahel angu, etatabit mehena, bot eboa angu di etatabit aalus. ");
INSERT INTO beu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob ana Rahel aing suka. Angu ebele ana Laban at hubait hula, “Na hula aabung karajang eluung mitung bititu, senge ooal jangu emiaaru, Rahel angu aana metma manenang.” ");
INSERT INTO beu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Angmuse Laban ana Yakob ehur angu ebalet hula, “Rahel angu na bae metma nehe aabeung enang niang. Lebe miaaung, na metma maeenang! Base, aana angami mihi, senge karajang metma menenang.” ");
INSERT INTO beu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Angmuse Yakob ana karajang eluung mitung bititu, senge hula Rahel aing medit metma ejangu ening. Aarunge Yakob ana etatabit Rahel aing suka base, eluung mitung bititu angu, ana rasa se emenghula ved aaeedeng kolang edadenang. ");
INSERT INTO beu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Mitung bititu muse, Yakob ana Laban at hubait hula, “Na karajang ejol mi tila. Aaung ba netenangeli angu metma manenang, senge na aing medit metma nejangu ening.” ");
INSERT INTO beu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Angmuse nehe ba mana angu mi ang naung, emangpi Laban ana iajali, sengmuse ana pesta ening. ");
INSERT INTO beu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Kua angu, Laban ana bae Rahel metma Yakob enang niang, aarunge ana Lea ba at ila metma Yakob enang. Angmuse Yakob ana Lea at tia. Bot Laban ana emalea jangu nu ene Silpa angu metma Lea enang, senge metma Lea emalea ening. Aarunge emikuaveng muse, Yakob ana ateing se, angu Lea! Angmuse Yakob ana Laban at hubait hula, “Naba ba aana ening metma nadana tila anga? Na aabung karajang nekira metma vengboar eluung mitung bititu, senge aana Rahel metma manenang! Etatalang ba aana naajajala angu?” Laban ana Yakob ehur angu ebalet hula, “Yakob! Ekang oomi alil ekang! Nihada angami angu eamulung se, nehe bae ening aulang niang. Ekaku ba mieele angu mehal medi jedung se, ekaku kiki angu bae eturat mehal medi niang. Base, noal anga epesta angu, aana melekang akanap mietang bititu hengi. Eningse Rahel angu di na metma maeenang aana medi, aarunge aana malekang karajang mitung bititu maveng metma manenang hengi.” ");
INSERT INTO beu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob ana ening Laban ehur angu eamulung. Pesta mietang bititu metma Lea adana angu Yakob ana eamulung sengmuse, Laban ana oal Rahel benang di metma Yakob enang, senge ana medit metma ejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban ana emalea jangu nu ene Bilha angu metma Rahel enang, senge metma Rahel emalea ening. ");
INSERT INTO beu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Angmuse Yakob ana Rahel di at tia. Yakob ana omi metma Rahel ejahit milebe, Lea mi ataang oa. Angmuse Yakob ana bot karajang eluung mitung btitu metma Laban enang. ");
INSERT INTO beu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Lahatala Ana ateing se, Yakob ana bae omi metma Lea ejahi niang muse, Ana Lea evaal emana angu buka, base ana vaal vengajai, aarunge Rahel angu karboa, base ana bae vaal vengajai niang. ");
INSERT INTO beu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea atou veng muse, ana vaal mehal nu vengajai. Lea ana vaal angu ene maveng, Ruben (evengbanang tarang se hula, ꞌeeng uuling, vaal aeꞌ), se ana hula, “Nesusa angu LAHATALA Ana etatabit uuling ateing. Angu ebele, angase nemehal di hula eng metma neuuling.” ");
INSERT INTO beu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea bot atou veng muse, ana vaal mehal nu vengajai. Lea ana vaal angu ene maveng, Simon (evengbanang tarang se hula, ꞌnehe vengmee tilaꞌ), se ana hula, “Nemehal ana bae eng metma neuuling niang angu, LAHATALA Ana vengmee tila. Angu ebele, Ana vaal nu taang metma manenang maveng.” ");
INSERT INTO beu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Angmuse Lea bot atou veng. Ana bot vaal mehal nu vengajai muse, ana vaal angu ene maveng, Lewi, se ana hula, “Vaal anga na vengajai muse, neparkara angu sengila. Angase nemehal ana malekang nat aabetat aaung-hama, se vaal mehal tue na vengajait metma maenang iila angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea bot atou veng. Angmuse ana vaal mehal nu vengajai. Lea ana vaal angu ene maveng, Yahuda (evengbanang tarang se hula, ꞌtajaningꞌ, se ana hula, “Angase na LAHATALA Aing tajaning!” Seng angmuse, Lea ana bae vaal veng niang iila. ");
INSERT INTO beu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Aarunge Rahel ana ateing se, ana bae vaal vengajait metma Yakob enang niang muse, ana omi metma ekaku Lea angu ekakurang. Angmuse ana Yakob at hubait hula, “Vaal metma manenang hengi! Kalo niang se, aaungba na aamina.” ");
INSERT INTO beu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Aarunge Yakob ana Rahel ealil, bot mateng hula, “Naing ba Lahatala ba, na evaal emana angu vengtahang ka!?” ");
INSERT INTO beu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahel ana Yakob at mateng hula, “Aaungba aana nemalea jangu Bilha angu aing medi. Aana abung tia, senge ana vaal vengajait metma manenang, aulange nandi netabanaing veng.” ");
INSERT INTO beu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Angmuse Rahel ana emalea Bilha angu metma Yakob enang, sengmuse Yakob ana abung tia. ");
INSERT INTO beu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha atou veng muse, ana vaal mehal nu vengajai. ");
INSERT INTO beu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Angmuse Rahel ana mateng hula, “Nesambajang angu Lahatala ana vengmee tila. Neparkara angu Lahatala Ana vengputus molo-molot metma manenang iila.” Angmuse ana vaal angu ene maveng, ene Dan (evengbanang tarang se hula, ꞌparkara vengputusꞌ). ");
INSERT INTO beu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha bot atou veng muse, ana bot vaal mehal nu vengajai. ");
INSERT INTO beu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Angmuse Rahel ana mateng hula, “Na etatabit nekaku at taing gomol muse, na uuntung iila.” Angu ebele ana vaal angu ene mavang, ene Naftali (evengbanang tarang se hula, ꞌtaing gomolꞌ.) ");
INSERT INTO beu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea ana ateing se ana bae vaal veng niang iila muse, Lea ana emalea jangu Silpa angu metma Yakob enang ana medi muse, ");
INSERT INTO beu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silpa ana vaal mehal nu vengajait metma Yakob enang. ");
INSERT INTO beu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Angmuse Lea ana mateng hula, “Neaabetang aaung-hama tila.” Angmuse ana vaal angu ene maveng, ene Gad (evengbanang tarang se hula, ꞌaabetang aaungꞌ). ");
INSERT INTO beu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpa bot vaal mehal emiaaru vengajait metma Yakob enang. ");
INSERT INTO beu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Angmuse Lea ana mateng hula, “Angase na sanang iila! Eningse nehe jangu ang naung emangpi itat mateng hula, na sanang iila.” Angu ebele ana vaal angu ene maveng, ene Aser (evengbanang tarang se hula, ꞌsanangꞌ). ");
INSERT INTO beu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ooras aara-gandum avaning muse, Ruben ana ila aahing mi lamal-lamal. Te nu ene dudaim eiipi angu nehe metma obat ening se, nehe bisa vaal veng angu, Ruben ana dadi mi harak. Angmuse Ruben ana dudaim eiipi angu medit baning hoa metma iva Lea enang. Rahel ana uuling ateing muse, ana Lea at mateng hula, “Kaku! Dudaim eiipi ba Ruben ana baning hoa angu, iiba manenang hengi.” ");
INSERT INTO beu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Aarunge Lea ana Rahel ehur angu ebalet hula, ꞌNemehal angu aana aing medit eluung alang anga, bae kanap jedung ka? Base, angase aana bot hula noal edudaim eiipi angu di medi angu ka? Aarunge Rahel ana mateng hula, “Kalo aulang se, vede kua anga, aana Yakob abung tia, senge metma ooal edudaim eiipi angu bajar. Angmuse Lea ana vengjali.” ");
INSERT INTO beu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ved baa muse, Yakob ana dadi mi bale hoa. Angmuse Lea ana Yakob aing harak, bot at mateng hula, “Vede kua anga, aana malekang nabung tia! Se aaing angu, na metma noal edudaim eiipi vengbajar iila.” Base, kua angu Yakob ana Lea abung tia. ");
INSERT INTO beu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Angmuse Lahatala ana Lea esambajang angu vengmee. Angu ebele Lea atou veng muse, ana vaal mehal emiiising vengajait metma Yakob enang. ");
INSERT INTO beu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Le ana vaal angu ene maveng, ene Isaskar (evengbanang tarang se hula, ꞌnedira angu vengbajarꞌ), se ana hula, “Nedira angu, Lahatala Ana vengbajar iila, se na nemalea Silpa metma nemehal enang ana medi angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea bot atou veng muse, ana bot vaal mehal emitaling vengajait metma Yakob enang. ");
INSERT INTO beu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Le ana mateng hula, “Lahatala Ana hadia aalus metma manenang iila. Base, nemehal ana malekang naing aada, se vaal mehal taling na vengajait metma maenang iila angu ebele.” Angmuse Lea ana vaal angu ene maveng, ene Sebulon (evengbanang tarang se hula, ꞌaing aadaꞌ). ");
INSERT INTO beu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Seng angmuse Lea ana vaal jangu nu vengajai. Lea ana vaal angu ene maveng, ene Dina. ");
INSERT INTO beu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Lahatala Ana Rahel aing vengani muse, Ana esambajang angu vengmee. Angu ebele Lahatala Ana Rahel evaal emana angu buka. ");
INSERT INTO beu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Angmuse Rahel ana atou veng. Base Rahel ana vaal mehal nu vengajai. Rahel ana mateng hula, “Neaaloring-nemaniang angu, Lahatala Ana venghapo tila.” ");
INSERT INTO beu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rahel ana vaal angu ene maveng, ene Yusup (evengbanang tarang se hula, ꞌana manenang mavengꞌ), se ana hula, “Na banang senge, Lahatala Ana vaal mehal nu taang manenang maveng.” ");
INSERT INTO beu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel ana Yusup aing vengajai sengmuse, Yakob ana Laban at hubait hula, “Nimang! Angase na hula bale neaabang-nelelang mi ila. Base, aana malekang vengjali, senge na lamal. ");
INSERT INTO beu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nejangu-nevaal ang naung metma manenang, senge na iat ila. Na etatabit karajang nekira metma vengboar metma maeenang eluung alang anga, ing angu ba metma netarung hela angu ebili ening.” ");
INSERT INTO beu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Aarunge Laban ana Yakob ehur angu ebalet hula, “Noal! Na ateing iilat hula, aana nabung aabeta, bot aana nekarajang ang naung vengkarajang, angu ba Lahatala Ana Eaaung-Ehama ba bae ebale vengniang angu metma manenang anga. Base, aana malekang oomi metma nejahi hengi. ");
INSERT INTO beu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Angu ebele aana karajang angu, eeseva eedeng se, vengbanang senge na eamulung bajar metma maeenang.” ");
INSERT INTO beu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Angmuse Yakob ana Laban ehur angu ebalet hula, “Nimang! Na aabung karajang eluung alang anga, nedira angu aana ateing iila. Eebinanta ang naung na jagat aaung-aaung, angu ebele taang toang maveng. ");
INSERT INTO beu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Uanguveng na bae hoa jedung angu, eepasaka angu etoang bae aulang niang. Aarunge na hoa angami muse, Lahatala Ana Eaaung-Ehama ba bae ebale veng niang angu metma maeenang, angu ebele angase eepasaka angu taang toang maveng iila. Base, taveding senge na karajang metma nejangu-nevaal ang naung iadana?” ");
INSERT INTO beu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Angmuse Laban ana Yakob adangtaaning hula, “Kalo aulang se, naba ba na malekang ening metma aadana hengi?” Yakob ana Laban etaaning angu ebalet hula, “Aana ekang na iiba metma manenang ekang. Na jedung eebinanta ang naung jaga bot gariang sehi, aarunge aana vengjali senge na nu anga na ening. ");
INSERT INTO beu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Vede ved anga na ila eebinanta ang naung ehahama mi, senge binanta ba kaana, mititik-mititik, bot hulak ang naung emangpi na vengtalail medi, senge metma nedira angu eseva ening. ");
INSERT INTO beu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ved eveang senge aana ateing hula, na ening angu molo ee niang. Binanta ba bae mititik-mititik niang, bae hulak niang, bot bae kaana niang, kalo ue binanta ba na medi ang naung ehahama mi se, aana ateing iilat hula, angu na eebinanta ba taavi.” ");
INSERT INTO beu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Angmuse Laban ana mateng hula, “Yo! Kalo aulang se, ening eemateng angu eamulung.” ");
INSERT INTO beu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Aarunge ved uanguveng angu, Laban ana binanta ba mititik-mititik, hulak, bot jumba kaana ang naung emangpi vengtalail metma oal ang naung inang senge iot vengurus. ");
INSERT INTO beu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Angmuse Laban oal ang naung ini binanta ang naung emangpi baning ila mana nu Yakob eola, tia venglamal se ved tue angu, mi gariang. Angmuse Yakob aing Laban ebinanta ealehil ba ue angmi angu gariang. ");
INSERT INTO beu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Angmuse Yakob ana te rupa tue ene; hawar, badam, bot berangan, eatang varat angu patait baning hoa, sengmuse ana te atang angu bit ening hulak. ");
INSERT INTO beu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Te atang ba Yakob ana bit ening hulak ang naung, ana metma parak ba binanta ang naung mi jar na angu, mi mea. Binanta ang naung hoa jar na se, ini sukat mana angumi taing taang-baa. ");
INSERT INTO beu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kalo binanta ang naung, te atang ba hulak ang naung abung taing taang-baa se, ioal ang naung iamudi angu eningse iiba mititik-mititik, bot iiba hulak. ");
INSERT INTO beu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Uanguveng Laban ebinanta ang naung hula taing taang-baa se, Yakob ana iapang angu eebang metma binanta ba mititik-mititik, bot hulak ang naung iadana. Base ioal ang naung emangpi mititik-mititik, bot hulak. Yakob ana ening aulang, base ebinanta angu taang toang maveng. Angmuse Yakob ana ebinanta ang naung vengtalail medit metma Laban ebinanta ang naung eahalang. ");
INSERT INTO beu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kalo binanta daeri ang naung taing taang-baa se, Yakob ana te atang hulak ang naung metma iapang oat iparak angu mi mea. ");
INSERT INTO beu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Aarunge Yakob ana ateing, kalo binanta ba moleng ang naung taing taang-baa se, te atang ang naung ana bae metma parak angu mi mea niang. Base, binanta ba moleng ang naung metma Laban eoa. Aarunge binanta edaeri ang naung emangpi metma Yakob eoa. ");
INSERT INTO beu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yakob ana ening aulang, angu ebele epasaka angu taang toang maveng. Yakob ejumba, eaib, eunta, ekeledei, bot emalea di, etatabi toang. ");
INSERT INTO beu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakob ana vengmee se, Laban oal ang naung aing vengmateng hula, “Yakob ana timang epasaka ang naung emangpi medit metma epasaka ening iila” ");
INSERT INTO beu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Bot Yakob ana ateing se, idat mehal Laban apang-omi metma adana angu di, bae emenghula tura angu edadenang niang. Bot bae at aaung emenghula tura angu edadenang niang iila. ");
INSERT INTO beu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Angmuse Lahatala ana Yakob at mateng hula, “Angase, ejol mi tila. Aana malekang bale iiva-iimang ebele ila. Eningse Na aat lamal hama-hama.” ");
INSERT INTO beu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Angmuse Yakob ana nehe gahing ila ejangu Rahel, bot Lea oleve iaru, senge hoa dadi mi ebinanta emana angmi aing harak. ");
INSERT INTO beu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Angmuse Yakob ana ejangu aaru angu iat mateng hula, “Na ateing se, iimang apang-omi metma nadana angu, bae emenghula tura angu edadenang niang. Bot ana bae nat aaung emenghula tura angu edadenang niang iila. Aarunge Lahatala ba nimang ana Aing somba angu, ue nat toang-pina. ");
INSERT INTO beu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ooleve ateing se, eluung alang anga, na etatabit karajang nekira metma vengboar, metma iimang adana tila! ");
INSERT INTO beu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Aarunge iimang ana naajajala, bot neseva angu ana aboit mi arinu metma nadana. Aulang aarunge Lahatala Ana bae vengkilang iimang ana jasi ening metma nadana niang. ");
INSERT INTO beu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Uanguveng angu iimang ana mateng hula, ꞌBinanta ba mititi-mititik angu ba metma eeseva eningꞌ, base binanta ang naung ajai se, ioal ang naung emangpi mititik-mititik. Bot ana mateng hula, ꞌAngase, binanta ba hulak angu ba metma eeseva eningꞌ, base binanta ang naung ajai se, ioal ang naung emangpi hulak. ");
INSERT INTO beu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Lahatala Ana ening aulang, senge iimang ebinanta ang naung emangpi Ana medit metma manenang. ");
INSERT INTO beu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Minu adana, binanta ang naung iooras mi hula taing taang-baa muse, na iipal na se hula, binanta lotal emangpi ba binanta manarang ang naung taang-baa angu, iiba migaris-migaris, iiba mititik-mititik, bot iiba angu hulak. ");
INSERT INTO beu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Angmuse Lahatala Egahingvala sorga mi nu, iipal omimi nearut hula, ꞌYakob!ꞌ Angmuse na madut hula, ꞌYa Nimang, Aaing ba neLahatala!ꞌ ");
INSERT INTO beu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Angmuse Ana nat hubait hula, ꞌEeng uuling hengi! Binanta lotal emangpi ba binanta manarang ang naung taang-baa angu, iiba migaris-migaris, iiba mititik-mititik, bot iiba angu hulak. Emangpi angu Naing ba vengator ening aulang, se naba ba iidat mehal Laban ana ening metma aadana angu, Na ateing ila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Naing anga ba Lahatala, tura Betel mi aaing harak iila angu. Tura aana var ohit metma tugu ening, bot iipil metma vengbokong, senge Naing somba tila angu. Angase aana malekang aava vengharaka, bot lamal aabang anga eahalang, senge bale iiva-iimang eaabang angmo mi ila.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Angmuse Rahel, bot Lea oleve Yakob ehur angu ebalet hula, “Nimang! Nipasaka iiba bae ue nimang ehava mi niang iila. Base, naba ba aana vengbanang angu, ni eamulung! ");
INSERT INTO beu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ning anga, nimang ana ning tabenung iila. Bot ni bili-pala ang naung, nimang ana paket miosing iila. Base ana ning ening emenghula nehe hoangmanang edadenang. ");
INSERT INTO beu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Aarunge pasaka ba Lahatala Ana nimang abung medi metma maeenang angu, angase metma nipasaka ening, bot metma nioal ang naung ipasaka ening. Base, Lahatala Ana aat mateng hula tatalang se, pi ening anguba eamulung!” ");
INSERT INTO beu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Angmuse Yakob ana enaosing ang naung emangpi vengtaloul. Ana ejangu-evaal ang naung emangpi iat mida unta taang. Ebinanta, bot epasaka ba ana Padan Aram mi harak ang naung emangpi ana baning, sengmuse ini lamal Kanaan mi, imang Isak ebele ila. ");
INSERT INTO beu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Uanguveng angu, Laban ana ila ejumba eamudi gunti. Angmuse aaneda epatung ba Laban ana somba ang naung, Rahel ana taavit medi. ");
INSERT INTO beu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob iimal tahit lamal angu, ana bae metma idat mehal veng at mateng niang. Aarunge Yakob ana veng amaang. ");
INSERT INTO beu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakob ana epasaka ang naung emangpi baning lamal. Ini lamal ila Efrat moar angu lakal sengmuse, ini bot lamal Gilead dol adang ila. ");
INSERT INTO beu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mietang tue muse, Laban ana vengmee se hula, Yakob ana bihit eabang mi ila tila. ");
INSERT INTO beu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Angmuse Laban ana enehe ang naung iaru, senge bihit Yakob aterit ila. Ini bihit Yakob aterit sampe mietang bititu, sengmuse Laban ana Gilead dol taang Yakob aing harak. ");
INSERT INTO beu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kua angu adana, Lahatala Ana iipal omimi Laban at mateng hula, “Laban! Kalo aana Yakob at mateng se, hur euling senge vengbanang metma Yakob at hubai.” ");
INSERT INTO beu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Uanguveng Laban iimal ila Yakob aing harak se, Yakob ana dol angu taang eteeng dodu tila. Angmuse Laban iimal di iteeng metma dol angu taang dodu. Bae Yakob iimal iteeng angu eola niang. ");
INSERT INTO beu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Angmuse Laban ana Yakob aing harak, bot at mateng hula, “Ee, Yakob! Naba ba aana ening metma nadana tila anga? Etatalang ba aana naajajala, bot noal jangu ang naung aana iat bihit emenghula ing nehe jasi edadenang angu? ");
INSERT INTO beu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Etatalang ba aana bihit eeabang mi ila di, aana vengtaimang angu? Aana hula eeabang mi ila se, etatalang ba aana metma veng nat mateng senge, pi pesta ening suka-naverat hama-hama, bot na dal ohit huling-tambur metma aaing aantar senge aaing lapas aana ila niang? ");
INSERT INTO beu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Bot etatalang ba aana bae ooras metma manenang senge, na noal-nidat ang naung iamikut aaung-aaung senge ing lapas niang angu? Eekarajang anga, etatabit kamuke! ");
INSERT INTO beu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Angase na bisa aaing ening aana silaka! Aarunge Lahatala ba iimang ana Aing somba angu, vede kua anga Ana nehapa tilat hula, kalo na aat mateng se, hur euuling senge metma veng aat mateng. ");
INSERT INTO beu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Na manggaratit hula, angase aana bale eeabang mi ila, se oomi etatabit iimang aing midadanang angu ebele. Aarunge neaaneda epatung ba na somba ang naung, etatalang ba aana taavit baning ila angu?” ");
INSERT INTO beu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Angmuse Yakob ana Laban ehur angu ebalet hula, “Na nuangmari. Se na vengnomit hula, misavaka aana ooal jangu ang naung ing tahang. Angu ebele na tahit lamal di, na vengtaimang angu.” ");
INSERT INTO beu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Aarunge Yakob bae ateing niang hula, ejangu Rahel ba imang eaaneda epatung ang naung taavit medi. Angu ebele Yakob ana Laban at hubait hula, “Eeaaneda epatung ang naung, aana valaping, senge ue nuba abung se, ekang nehe angu aing vengkilang ana aabeta ekang! Bot ne naosing ang naung emangpi aana parisa, senge eepasaka aabeung di iiba ue se, aana medi. Aulang senge, pinehe anga naung ing emangpi metma esaksi ening.” ");
INSERT INTO beu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Angmuse Laban ana Yakob eteeng, ejangu Lea eteeng, bot Yakob ejangu gariang aaru angu, iteeng angu mi masot parisa, aarunge eaaneda epatung ang naung ana bae harak niang. Lea eteeng mi kaluar hela sengmuse, Laban ana Rahel eteeng mi maso. ");
INSERT INTO beu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Aarunge Rahel ana imang eaaneda epatung ang naung amaang metma noang ba unta amota emea angu mi maso, sengmuse ana noang angu taang mihi. Laban ana Rahel eteeng omi angu parisat miipi, aarunge eaaneda epatung ang naung, ana bae harak niang. ");
INSERT INTO beu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel ana imang at hubait hula, “Nimang! Ekang oomi alil ekang. Na bae bisa aapangaadang mi naloming tahi niang, se neuuru hoa angu ebele.” Angmuse Laban ana bot taang valaping, aarunge patung ang naung ana bae harak niang. ");
INSERT INTO beu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakob omi etatabit alil, angmuse ana Laban at mateng hula, “Jasi-ahala tatalang ba na ening metma aadana tila? Angu ebele, aana bihit naterit emenghula naing nehe jasi edadenang angu? ");
INSERT INTO beu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Aana nenaosing ang naung emangpi parisa tila se, eepasaka naba ba ue nehava omi epasaka angu veng? Angase aana metma angami nenehe, bot eenehe ang naung iapangaadang mi mea, senge ing ba vengputus metma poleve piadana. ");
INSERT INTO beu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Eluung mitung ari aaru anga, na etatabit karajang metma maeenang. Eebinanta emanarang ang naung, nu bae vaar-bia di niang, bot elotal ang naung, na bae nu ameang adang di niang! ");
INSERT INTO beu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Binanta balevang hoa binanta ang naung nu adang se, na bae metma veng aat mateng niang, aarunge na emana. Bot bir-kua niang ba bir-jala nehe hoa binanta ang naung taavi se, aana naing manda, senge eebinanta ba nehe taavi tila angu malekang emana hengi. ");
INSERT INTO beu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Eebinanta ang naung na etatabit vengjaga. Angu ebele, nabae tiat udu di niang. Bir-jala se ved naing veng alil, bot bir-kua se kajavi naing vengbaa, aarunge na bae paduli niang. ");
INSERT INTO beu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mitung ari aaru angu, etabit na eehava mi aabeta! Na karajang mitung arinu belta buta, senge ooal jangu aaru angu aana metma manenang. Bot na karajang mitung taling maveng, senge binanta ang naung aana bisa metma manenang. Karajang eluung aulang, aarunge aana neseva angu aboit mi arinu. ");
INSERT INTO beu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kalo, Lahatala ba nidat boma Abraham, bot nimang Isak oleve Aing somba angu, Ana bae nat hama-hamat aabeta niang se, angase aana naing vengkilang na natang osing bale ila. Aarunge nesusa-nelala, bot nekarajang ang naung emangpi Lahatala Ana Eng metma euuling. Angu ebele vede kua anga, Lahatala Ana eehapa angu.” ");
INSERT INTO beu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Angmuse Laban ana Yakob ehur angu ebalet hula, “Alang! Jangu aaru anga, noal. Vaal mehal ba ini vengajai ang naung emangpi nidat, bot binanta anga naung di, emangpi nebinanta. Naba ba aana angami uuling ateing anga naung, emangpi ne. Base, naba ba angase na ening metma noal-nidat anga naung iadana? Na bae ing tahang jadi niang. ");
INSERT INTO beu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Angu ebele, angase mahe poleve tat palai. Palai angu metma poleve pihahama angmi pisaksi ening, senge pi aabetat palai angu eamulung.” ");
INSERT INTO beu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Angmuse Yakob ana var eele nu medit angumi bakung atahing, metma etanda ening. ");
INSERT INTO beu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Angmuse Yakob ana enehe ang naung ing gahing iot var akumpul, bot ini var angu ening akadoru, angmuse ing emangpi var kadoru angu abung mihit naadang hama-hama. ");
INSERT INTO beu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban ana var kadoru angu ene maveng hula, Yegar Sahaduta. Aarunge Yakob ana var kadoru angu ene maveng hula, Galeed. ");
INSERT INTO beu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Angmuse Laban ana mateng hula, “Var kadoru anga, vede angase metma poleve pihahama mi pisaksi ening.” Angu ebele mana angu ene, Galeed. ");
INSERT INTO beu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban ana bot mana angu ene maveng hula, Mispa (emenghula hur kokal eaabeung angu edadenang, evengbanang tarang se hula, ꞌmana jaga ba baloluꞌ), se Laban ana mateng hula, “Eningse LAHATALA ba poleve ping jaga, senge pi teola dise, pi bae pi palai angu taang tahi niang. ");
INSERT INTO beu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kalo aana noal anga naung jasi metma iadana, senge aana jangu aabeung medi se, tantu na bae ateing niang. Aarunge vengani! Lahatala ba metma poleve pisaksi ening. ");
INSERT INTO beu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Laban ana bot Yakob at mateng hula, Aanake eeng metma var ba tahi angu, bot var kadoru angu euuling. Vengani! Var anga naung di, metma poleve pihahama mi ha ening. Aana bae var anga naung lakal senge, jasi ening metma nadana niang. Bot nandi bae var anga naung lakal senge, jasi ening metma aadana niang. ");
INSERT INTO beu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Iidat boma Abraham eLahatala, nidat boma Nahor eLahatala, bot iimang Isak eLahatala, angu ba metma Poleve pitat palai anga, ehakim ening. Eningse Aing ba poleve pi parkara ang naung vengputus.” Angmuse Yakob ana Lahatala ba imang Isak ana aing somba angu, Ene metma ava sumpa. ");
INSERT INTO beu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Bot Yakob ana ebinanta sabele, sengmuse dol angu taang ede, sadaka ening metma Lahatala Enang. Angmuse Yakob ana enehe ang naung emangpi iajalit naadang hama-hama, bot ing emangpi dol angu taang tia. ");
INSERT INTO beu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Emitobang kukuaveng muse, Laban ana oal-idat ang naung emangpi iamiku, bot Lahatala Eaaung-Ehama ba bae ebale veng niang angu, ana vengbanang metma iadana, sengmuse ana lamal bale eaabang mi ila. ");
INSERT INTO beu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakob iimal lamal milalu. Angmuse Lahatala Egahingvala sorga mi ang naung hoa Yakob aing harak. ");
INSERT INTO beu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Uanguveng Yakob ana uuling Lahatala Egahingvala sorga mi ang naung iateing muse, ana mateng hula, “Anga naung Lahatala Etentara ba mana anga mi angu! Angu ebele Yakob ana mana angu ene maveng, ene Mahanaim (evengbanang tarang se hula, ꞌaaring mana aaruꞌ). ");
INSERT INTO beu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Angmuse Yakob ana egahingvala ang naung ing gahing imaturat ila Edom aabang (benangba Seir) angu mi, ekaku Esau aing harak. ");
INSERT INTO beu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob ana egahingvala ang naung ing parentat hula, “Iini ila nekaku Esau at hubait hula alang: ꞌNimang Esau! Eemalea Yakob ana aada-haromat panatut metma maeenang vengbanang hula alang: Tura na tahit lamal ila angu, eluung alang anga na timaela Laban ehama mi mihi. Bot na angmi mihit emenghula nehe hoangmanang edadenang. ");
INSERT INTO beu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Angase naing ba eemalea anga, ne arbo-sapi, aib-jumba, etatabi toang naing veng. Nemalea mehal, bot nemalea jangu di etatabi toang. Na hula hoa aaing harak. Angu ebele na nehe gahing ematurat hoa vengbanang, senge aana oomi metma nejahi, bot aana naing tarima.ꞌ ” Angmuse gahingvala ang naung ini ila Esau at hubai. ");
INSERT INTO beu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Angmuse gahingvala ang naung ini bale hoa Yakob aing harak, bot at hubait hula, “Ni ila eekaku Esau aing harak, bot ni at hubai tila. Angase ana ue hoa via mi tila. Nehe mehal ratu buta aing aantar hoa, senge hula aaing harak.” ");
INSERT INTO beu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Vengmeet aulang muse, Yakob omi bae sanang niang, bot ana uangmarit etatabi. Angmuse ana enehe ang naung, bot ebinanta ang naung emangpi paul, ening rombongan aaru. ");
INSERT INTO beu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Se ana vengpikir hula, “Kalo Esau hoa, senge ana rombongan ehalomang angu at tahi sehi se, rombongan emiaru angu bisa bihit iava ening lohi.” ");
INSERT INTO beu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Angmuse Yakob ana sambajang hula, “Nimang Lahatala, nidat boma Abraham eLahatala, bot nimang Isak eLahatala. Naing venghele hengi. Aaing ba tura nat mateng iilat hula, aaung ba aana bale eeabang mi ila, senge eekaku-eeserang ang naung ing harak, aulange aaung-hama ba bae ebale veng niang angu, Na metma maeenang. ");
INSERT INTO beu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Eeomi nejahi, bot Eekalaka ba Aana ening metma nadana angu, na natang metma etaning medit jadi niang. Tura na lamal Yarden moar lakal angu, doba ba na metma natang mi baning. Aarunge angase na bale hoa anga, manusia rombongan aaru, bot binanta veng, na ae baning. ");
INSERT INTO beu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Angu ebele, na banang, senge Aana naing ening lohit metma nekaku Esau atang angu eahalang. Na nuangmari, misavaka nekaku Esau hoa se, ana nameang, bot nejangu-nevaal anga naung di emangpi ana iameang. ");
INSERT INTO beu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nimang Lahatala, Aaing ba nat palai tilat hula, aaung-hama ba bae ebale veng niang angu, Aana metma manenang, bot Aana ening netabaning angu toang-rae, emenghula bahi tang omimi angu edadenang, nehe garet jadi niang, bot taanang jadi niang.” ");
INSERT INTO beu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Angmuse bir-kua angu, Yakob iimal ini mana angu mi tia. Bot naba ba ue aing veng angu ana medit vengharaka, senge atangoang ening metma ekaku Esau enang, ");
INSERT INTO beu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","benangba; Aib manarang ratu aaru, aib lotal ari aaru, jumba manarang ratu aaru, jumba lotal ari aaru, ");
INSERT INTO beu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","unta oal ari tue ba jedung kono na sehi, bot iva veng, sapi manarang ari buta, sapi lotal arinu, keledei manarang ari aaru, bot keledei lotal arinu. ");
INSERT INTO beu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yakob ana binanta ang naung emangpi ening atatara, senge ening kumpul na-nu. Angmuse ana emalea ang naung iot kumpul na-nut jaga. Ana iat mateng hula, “Iini iimaturat lamal. Eningse na iiamota oat iiamulung. Aarunge iini vengjaga, senge kumpul nu angu, malekang kumpul nu angu eolat lamal.” ");
INSERT INTO beu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakob ana emalea ba etura angu aing parentat hula, “Kalo nekaku Esau ana aaing harak, bot ana aadangtaaning hula, ꞌAana taang mi ila? Eemanaing angu ene nuba? Bot iiomi oa angu, nuba ebinanta?ꞌ ");
INSERT INTO beu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Iini ebalet hula, ꞌAnga naung eemalea Yakob ebinanta. Anga atangoang ba ana pananut metma nimang eenang. Ana ue niamulung hoa sehi.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Yakob emalea ba binanta kumpul eabeung ang naung iat lamal angu di, Yakob ana ing parentat hula, “Kalo iini Esau aing harak iila se, binanta ba na metma natangoang ening ang naung, iini metma maenang. Bot iini at hubait hula, na ue iiamota oat iiamulung.” Yakob ana vengomit hula, binanta ba nehe ematurat baning ila metma Esau enang ang naung, eningse ening Esau omi angu abalea, base ana malekang Yakob aing tarima. ");
INSERT INTO beu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Base Yakob ana binanta ang naung panatut ematura. Aarunge bir-kua angu, Yakob aing jedung angumi mihi. ");
INSERT INTO beu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bir-kua angu Yakob ana tahi, sengmuse ana ejangu aaru angu, bot ejangu gariang aaru angu, oal inang arinu belta nu angu ing vengator, sengmue ana iat lamal ila moar Yabok edenaveng angmi. ");
INSERT INTO beu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Yakob ana ejangu-evaal ang naung iat lamal ila moar edenaveng angmi sengmuse, ana bot epasaka ang naung di emangpi baning ila moar edenaveng angmi. ");
INSERT INTO beu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Aarunge Yakob aing enangkolang jedung mana angu mimihi. Angmuse nehe mehal nu hoa Yakob at taing gomol sampe bir-jala papeang. ");
INSERT INTO beu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Uanguveng nehe mehal angu ateing se ana bae Yakob aing uuntung niang iila muse, ana Yakob asiang angu vengbue, angmuse Yakob asiang kira angu tebelung. ");
INSERT INTO beu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Angmuse nehe mehal angu ana Yakob at mateng hula, “Aaungba naing lapas, senge na ila. Kabingdena maveng se vedeng da.” Aarunge Yakob ana nehe mehal angu at mateng hula, “Aana bae aaung-hama angu vengbanang metma manenang jedung se, na bae aaing lapas niang!” ");
INSERT INTO beu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Angmuse nehe mehal angu ana Yakob adangtaaning hula, “Aaing eene nuba?” Yakob ana ebalet hula, “Naing nene Yakob.” ");
INSERT INTO beu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Angmuse nehe mehal angu ana Yakob at mateng hula, “Angase, eene angu nehe bae vengbanang Yakob niang iila. Aarunge nehe vengbanang hula, Israel, se aana aava-vengtueng manusia aing lavang, bot Lahatala di Aing lavang, aarunge aana uuntung iila angu ebele.” (Yakob ene Israel angu evengbanang tarang se hula, ꞌLahatala At taing gomolꞌ.) ");
INSERT INTO beu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Angmuse Yakob ana nehe mehal angu adangtaaning hula, “Eene angu di vengbanang hengi. Aaing eene nuba?” Aarunge nehe mehal angu ana Yakob etaaning angu ebalet hula, “Etatalang ba aana nene vengtaaning? Angmuse ana angmi aaung-hama ba bae ebale vengniang angu vengbanang metma Yakob adana. ");
INSERT INTO beu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Angmuse Yakob ana mateng hula, “Na uuling Lahatala Apang ateing iila, aarunge Ana bae nenghara angu medi niang.” Angu ebele, Yakob ana mana angu ene maveng, ene Peniel, evengbanang tarang se hula, ꞌLahatala Apangꞌ. ");
INSERT INTO beu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Uanguveng Yakob ana lamal mana angu eahalang iila muse, ana eng uuling se vedeng da iila. Aarunge Yakob asiang kira angu tebelung, base ana lamal heku. ");
INSERT INTO beu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Angu ebele, angase Israel enehe ang naung binanta euumung ba asiang mi angu, ini bae adang niang. Se Lahatala Ana Yakob asiang kira angu vengbuet ening tebelung angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakob ana apang ohit eng uuling se, nehe ratu buta ue hama-hamat Esau aing aantar hoa. Angmuse Yakob ana oal ang naung iiba metma Lea enang, iiba metma Rahel enang, bot iiba metma ejangu gariang aaru angu inang. ");
INSERT INTO beu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yakob ana vengator ejangu gariang aaru angu metma ioal ang naung veng iturat lamal. Lea bot oal ang naung veng angu hamami iamulung, Rahel bot oal Yusup oleve angu iamota oat iamulung. ");
INSERT INTO beu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Aarunge Yakob aing ejangu bot ioal ang naung iomi oat lamal. Uanguveng ini lamal ila hula Esau abung muse, Yakob ana iakuku muding, bot tout hela meke mi, sampe mibititu. ");
INSERT INTO beu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Aarunge Esau ana uuling ekaku Yakob ateing muse, ana bihit ila ekaku Yakob aing harak, sengmuse ana aing karavang, bot amiku. Angmuse oleve itobo kalavang baut etatabi. ");
INSERT INTO beu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Uanguveng Esau ana uuling nehe jangu ang naung, bot ioal ang naung iateing muse, ana taaning hula, “Nehe ba aaing veng anga naung, nuba?” Angmuse Yakob ana Esau ebalet hula, “Ing anga naung emangpi, vaal ba Lahatala Ana metma naing ba eemalea anga manenang angu.” ");
INSERT INTO beu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Seng angmuse Yakob ejangu gariang aaru angu, bot ioal ang naung ini hoa Esau aing aada. ");
INSERT INTO beu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea, bot oal ang naung di ini hoa Esau abung, bot aing aada. Yusup bot Rahel oleve di hoa Esau abung, sengmuse ini aing aada. ");
INSERT INTO beu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Angmuse Esau ana taaning hula, “Nehe toang-rae, bot binanta ba aana vede panatu angu, eomi hula tatalang?” Yakob ana Esau ebalet hula, “Emangpi angu, na hula metma maeenang, senge aana oomi metma nejahi, bot naing tarima.” ");
INSERT INTO beu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Aarunge Esau ana Yakob ebalet hula, “Nandi nepasaka toang. Base aana ekang na iiba metma manenang ekang.” ");
INSERT INTO beu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Angmuse Yakob ana ekaku Esau ebalet hula, “Kaku, ekang aulang ekang! Na uuling aapang ateing angmuse, emenghula na uuling Lahatala Apang ateing angu edadenang. Angu ebele aana malekang natangoang angu medi, senge metma tanda ening hula, aana etatabit oomi metma nejahi, bot aana naing tarima tila. ");
INSERT INTO beu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Base na banang, natangoang ba na baning hoa metma maeenang iila angu aana tarima. Se Lahatala Ana etatabit Eaaung-Ehama ba bae ebale veng niang angu metma nadana, angu ebele naba ba na parlu angu emangpi naing veng.” Yakob ana ekaku Esau asenang alolang-niang muse, Esau ana Yakob atangoang ang naung tarima. ");
INSERT INTO beu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Angmuse Esau ana mateng hula, “Kalo aulang se, aaung ba iiava vengharaka, senge pi lamal. Na iing aantar ila.” ");
INSERT INTO beu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Aarunge Yakob ana ebalet hula, “Kaku! Aanake ateing hengi. Vaal anga naung jedung kakili, ini bae daeri niang. Bot binanta anga naung di toang uhavede ajai. Angu ebele, kalo pi paksat iot uuser lamal se, ved nu kolang omimi muse, binanta anga naung emangpi aaminat miosing. ");
INSERT INTO beu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Base, lebe miaaung, nimang aaing eeturat lamal. Eningse ning emangpi lamal pati-pati iiamulung, binanta elamal, bot vaal anga naung ilamal angu eamulung, senge ni ila Seir mi nimang aaing harak.” ");
INSERT INTO beu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Angmuse Esau ana mateng hula, “Kalo aulang se, nehe ba naing aantar anga naung, iiba aat mihi, senge ini via metma iitubing.” Aarunge Yakob ana Esau ebalet hula, “Kaku, aana oomi metma nejahi, bot aana naing tarima tila. Base, ekang ening aulang ekang! ");
INSERT INTO beu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Yakob ana mateng aulang muse, ved uangu veng angu Esau ana iadu, bot ana lamal Seir mi ila. ");
INSERT INTO beu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Aarunge Yakob ana lamal Sukot adang ila. Ila Sukot mi muse, Yakob ana hava ening ini mi mihi, bot ebinanta ang naung di, emangpi ana elapa ening. Angu ebele, mana angu ini ene maveng, ene Sukot (evengbanang tarang se hula, ꞌhava mimihit vengtahangꞌ). ");
INSERT INTO beu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakob iimal Padan Aram mi lamal Sikem aabang ba Kanaan mi angu ebele ila angu, ini bae via mi susa iiba harak niang. Ila Sikem mi muse, ini aabang angu eved-danangoa angmi teeng dodut mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yakob ana Hemor, Sikem imang angu abung meke nu beli, senge metma iteeng angu emana ening. Meke angu ebili seeng perak ratunu. ");
INSERT INTO beu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Angmi angu, Yakob ana sadaka emana ening metma Lahatala Enang. Sengmuse ana mana angu ene maveng, ene El-Elohe-Israel, evengbanang tarang se hula, ꞌIsrael eLahatala angu, Lahatala aabetaꞌ. ");
INSERT INTO beu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Minu adana, Yakob bot Lea oleve ioal jangu Dina angu, ana nehe jangu kaneng ba aabang angu mi ang naung ibele ila. ");
INSERT INTO beu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Aabang angu eraja angu, ene Hemor, Hewi aabang enehe. Hemor oal mehal angu, ene Sikem. Uanguveng Sikem ana uuling Dina ateing muse, ana Dina at bihi, bot aing vengbuha. ");
INSERT INTO beu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Aarunge Sikem omi etatabit Dina aing midadanang, base Sikem ana Dina at mateng Dina omi ening sanang, senge Dina di omi metma sikem aing midadanang. ");
INSERT INTO beu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Angmuse Sikem ana imang at mateng hula, “Nimang! Aana ila Dina iva-imang at mateng, senge na aing medit metma nejangu ening.” ");
INSERT INTO beu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakob ana vengmee se hula, Sikem ana oal jangu Dina aing vengbuha tila, aarunge uanguveng angu, Yakob oal mehal ang naung emangpi ila dadi mi ibinanta jaga. Angu bele Yakob ana mang veng taimang, bot ana oal ang naung emangpi iading, sampe ini vengbale. ");
INSERT INTO beu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Angu ebele, Sikem imang Hemor ana Yakob ebele ila aing harak, senge hula at mateng. ");
INSERT INTO beu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Hemor, bot Yakob oleve itat mateng sehi se, Yakob oal benang naung dadi mi bale hoa. Ini vengmee se hula, Sikem ana Israel ehahama mi jasi-ahala ening iila, bot Yakob oal jangu angu vengbuha tila muse, iomi etatabit dira, bot ini alil etatabi. Se jasi-ahala aulang angu, ini bae tarima niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Angmuse Hemor ana iat mateng hula, “Noal Sikem omi angu etatabit iioal jangu angu aing suka. Angu ebele, na banang iini vengjali, senge noal Sikem ana iioal jangu angu aing medit metma ejangu ening. ");
INSERT INTO beu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kalo bisa se, pioal ang naung ini taing medi. Nioal mehal ang naung ini iioal jangu ang naung medi, bot iioal mehal ang naung ini nioal jangu ang naung medi. ");
INSERT INTO beu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Angase iini angami ning vengmihi. Aabang anga etatabit berang metma iioa. Base iing ba vengtalail hula taang mi mihi, bot omimi aabeta.” ");
INSERT INTO beu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Angmuse Sikem ana vaal jangu angu imang, bot ekaku mehal ang naung iat mateng hula, “Iiomi metma nejahi, senge naba ba iini banang se, na metma maiinang. Seeng metma iioal jangu angu eaaloring-emaniang angu vengtering, bot ebili-pala angu iini eedeng vengbanang di, na bajar metma maiinang. Aarunge iini vengjali, senge iioal jangu angu na aing medit metma nejangu ening hengi.” ");
INSERT INTO beu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Angmuse Yakob oal mehal ang naung ini ateing iilat hula, Sikem ana ikaku jangu Dina angu aing ening aaloring-maniang iila. Base Yakob oal ang naung ini akal mateng metma Sikem, bot Hemor oleve ihur angu ebale. ");
INSERT INTO beu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Yakob oal ang naung ini Sikem, bot Hemor oleve iat mateng hula, “Nehe mehal ba bae sunat niang angu, ni bae nioal jangu angu metma maenang ana medi niang! Angu ening niavaaloring! ");
INSERT INTO beu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aarunge, kalo evia anga iini eamulung se, iibanang angu ni veng niemeng-ajali. Benangba; Inehe ba mehal ang naung, kiki-eele, emangpi malekang sunat ning edadenang hengi. ");
INSERT INTO beu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ening aulang senge, ni bisa nioal jangu ang naung metma maiinang iini medi, bot ning di bisa iioal jangu ang naung ing medi. Bot ni bisa angami iing vengmihi, senge ping metma bangsa nu ening. ");
INSERT INTO beu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Aarunge kalo iini iiat bae nihur angu venghele niang, bot iini iiat bae sunat niang se, nioal jangu angu ni at ila, bot ni tahit lamal aabang anga eahalang.” ");
INSERT INTO beu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Angmuse Hemor, bot Sikem oleve Yakob oal ang naung imateng angu tarima. ");
INSERT INTO beu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikem ana eomi angu vengtahang jadi niang iila, se ana etatabit Yakob oal jangu angu aing suka angu ebele. Bot Sikem angu, enehe ba aabang angu mi ang naung emangpi etatabit aing aada. ");
INSERT INTO beu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Angmuse Hemor, bot Sikem oleve ila aabang eviaha maso angu mi, aabang angu enehe ang naung emangpi iat mateng. Oleve mateng hula, ");
INSERT INTO beu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Kaku naung! Israel enehe angu naung ini hula piat aabeta tominu-tahanu. Base vengkilange ini piat hama-hamat aabang anga mi mihi, bot omimi lamal iaabetang angu vengkarajang. Aabang anga etatabit berang metma ping emangpi pioa. Eningse pi bisa ioal jangu kaneng ang naung medit metma pijangu ening, bot ing di bisa pioal jangu kaneng ang naung medit metma ijangu ening. ");
INSERT INTO beu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Aarunge via nu anga ba ini banang hula piot eamulung, senge ini bisa piat hama-hamat mihit metma bangsa nu ening. Benangba; ping mehal ang naung emangpi malekang sunat ing edadenang hengi. ");
INSERT INTO beu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kalo pi iat hama-hamat aabeta tila se, ibinanta, bot ipasaka ang naung emangpi metma pioa. Base lebe miaaung pi iomi angu tarima, senge ini piat hama-hamat mihi.” ");
INSERT INTO beu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Nehe ba mana angu mi taing vengkumpul ang naung, emangpi Hemor, bot Sikem oleve imateng angu tarima. Angmuse nehe mehal ba aabang angu mi ang naung emangpi sunat. ");
INSERT INTO beu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ved emitue, nehe mehal ba sunat ang naung emangpi ibata angu jedung dira sehi se, Yakob oal aaru, Simon, bot Lewi oleve ipeda, bot iaring medi, sengmuse ini aabang angu maso. Angmuse nehe mehal ang naung emangpi ini iameang miosing. ");
INSERT INTO beu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hemor, bot sikem oleve di ini iameang, sengmuse ini Sikem ehava mi Dina aing medit at ila. ");
INSERT INTO beu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Angmuse Yakob oal eaabeung ang naung hoa aabang angu epasaka ang naung emangpi rampas medi. Ini etatabit alil, se ikaku jangu angu nehe aing ening jasi tila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Aib-jumba, arbo-sapi, keledei, bot naba ba ue aabang omimi, aabang amotaoa, emangpi angu ini rampas medi. ");
INSERT INTO beu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nehe jangu, bot ioal ang naung emangpi ini iat ila. Aabang angu epasaka ebili eele ang naung, bot naba ba hava omimi ang naung emangpi ini medi. ");
INSERT INTO beu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Uanguveng Yakob ana na angu ateing muse, ana Simon, bot Lewi oleve iat hubait hula, “Iini naing ening silaka, bot nene angu ening amanisat metma aabang anga enehe ang naung itubing iila! Eningse Kanaan enehe, Peris enehe, bot nehe ba ae aabang anga mi ang naung, emangpi iomi metma pialalil. Ing inehe toang. Aarunge ping anga kabingdena kolang. Kalo ini itominu senge piat tahi se, pi malekang tora-vengholalong, bot ini piameang miosing.” ");
INSERT INTO beu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Aarunge Yakob oal ang naung ini alil imang ehur angu ebalet hula, “Nimang! Etatalang ba ini nikaku jangu angu aing ening emenghula nehe jangu aver aanamang edadenang!” ");
INSERT INTO beu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Angmuse Lahatala Ana Yakob at mateng hula, “Aava veng haraka, senge Betel mi ila, bot angumi mihi. Naing anga Lahatala ba aana tura bihit aava metma eekaku Esau eahalang, senge Na Nava metma eetubing angu. Angu ebele aana ila angmomi se, aana malekang sadaka edoru angu ening metma maNenang.” ");
INSERT INTO beu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Angmuse Yakob ana ehava omi enehe ang naung emangpi iat mateng hula, “Aaneda ba ue iihahama mi ang naung iini malekang metma iiahalang, bot iidiri-iiababahi angu ening ahamulang, senge iipakiang ang naung telul. Mahe pi tava vengharaka, senge pi Betel mi ila angmomi mihi. Tura na susa omimi angu, Lahatala Ana noangmoling iila. Base ila angumi senge sadaka edoru angu na ening metma Lahatala Enang. Aulang senge pi Lahatala angu ba Aing somba.” ");
INSERT INTO beu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Angmuse ing emangpi iaaneda ba ing veng ang naung, bot iaantil ba iaver mi ang naung emangpi metma Yakob enang. Angmuse na ang naung emangpi Yakob ana metma Sikem aabang abung angmi, te eele nu angu iivang taloul. ");
INSERT INTO beu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Sengmuse ing emangpi tahit lamal. Uanguveng ini lamal angu, Lahatala Ana jonga-baroti metma bendar-bendar ba ing venggoleng jehi angu enehe ang naung iomimi, angu ebele ini bae baranit jasi ening metma iadana niang. ");
INSERT INTO beu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Base Yakob bot enehe ang naung ing emangpi lamal aaung-hamat sampe ila Kanaan por taang, Betel (ba tura ene, Lus) angu mi. ");
INSERT INTO beu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ila angumi muse, Yakob ana var ba metma sadaka edoru angu ening, sengmuse ana mana angu ene maveng, ene El Betel, (evengbanang tarang se hula, ꞌBetel eLahatalaꞌ). Se uanguveng Yakob ana bihit ava metma ekaku eahalang angu, Lahatala Ana angumi Ava metma Yakob etubing angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Betel aabang abung angu, te eele nu angu nehe ene maveng hula, Alon Bakut. Evengbanang tarang se hula, ꞌte eele bau-pei emanaꞌ. Ene aulang, se Ribka iva ababaning, ene Debora angu, aamina muse, nehe aing metma te angu iivang taloul angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Uanguveng Yakob ana Padan Aram mi bale hoa muse, Lahatala ana bot Ava metma etubing, bot Ana Eaaung-Ehama angu metma maenang. ");
INSERT INTO beu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Lahatala Ana Yakob at hubait hula, “Mulai vede angase, eene bae Yakob niang iila. Aarunge Na eene maveng, eene Israel. ");
INSERT INTO beu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Naing anga, Lahatala ba Mikavasa angu. Base, aana tabaning-taheli, senge ooal-iidat angu ening toang-rae! Eetabaning angu eningse metma bangsa-bangsa ening, bot raja-raja ang naung eningse aana malekang vengajai. ");
INSERT INTO beu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Aabang anga Na metma iidat boma Abraham enang, bot metma iimang Isak enang iila, angase Na metma maeenang, bot metma eetabaning ang naung di inang. ");
INSERT INTO beu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Lahatala Ana Yakob at hubait aulang sengmuse, Ana mida Yakob eahalang. Angmuse Yakob ana var ohit metma tugu ening, mana angu mi atahing, aulange metma Lahatala Epalai angu etanda ening. Yakob ana anggor ejar, bot iipil metma tugu angu vengbokong, sengmuse ana Lahatala Aing somba. ");
INSERT INTO beu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Mana ba Lahatala Ana mi Yakob at hubai angu, Yakob ana ene maveng hula, Betel. ");
INSERT INTO beu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Seng angmuse Yakob iimal ini tahil lamal Betel eahalang. Uanguveng ini lamal ila Efrata (benangba Betlehem) angu abung muse, Rahel ejol ajai mi tila. Aarunge ana ajai angu etatabit susa. ");
INSERT INTO beu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Rahel ana jedung vaal angu veng umi etatabit susa sehi se, aabiangvala ana at mateng hula, “Ekang uuangmari ekang! Oomi ening aanamang, anga di vaal mehal ba aana vengajai!” ");
INSERT INTO beu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Uanguveng Rahel ana hula eeng abang muse, ana vaal angu ene maveng, ene Ben-Oni, (evengbanang tarang se hula, ꞌvaal ba nesusa-lala omimi hoaꞌ). Seng angmuse Rahel ana aamina. Aarunge Yakob ana vaal angu ene maveng, ene Benyamin, (evengbanang tarang se hula, ꞌvaal atang teneꞌ). ");
INSERT INTO beu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Angmuse ini Rahel aing metma via ba Efrata aabang adang ila angu, eadil angmi taloul, (angase aabang angu ini ene maveng hula Betlehem). ");
INSERT INTO beu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakob ana var nu metma tugu ening, Rahel edaang angu taang bakung atahing. Rahel edaang evar tugu angu, angase jedung ue. ");
INSERT INTO beu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Seng angmuse Yakob iimal ini bot iava asorong ila mana nu ene Migdal-Eder angu mi iteeng ening. ");
INSERT INTO beu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Uanguveng Yakob iimal ini aabang angu mi mihi sehi se, Ruben ana imang ejangu gariang, Bilha angu, at tia. Angmuse Yakob ana na angu vengmee. Yakob oal mehal angu inang arinu belta aalu. ");
INSERT INTO beu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea oal naung benangba; Ruben (Yakob oal mutu), Simon, Lewi, Yahuda, Isaskar, bot Sebulon. ");
INSERT INTO beu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel oal naung benangba; Yusup, bot Benyamin. ");
INSERT INTO beu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel emalea Bilha angu oal naung benangba; Dan, bot Naftali. ");
INSERT INTO beu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea emalea Silpa angu oal naung benangba; Gad, bot Aser. Vaal ang naung ing emangpi Padan Aram mi ing vengajai. ");
INSERT INTO beu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Angmuse Yakob ana ila Mamre ba Kiryat-Arba aabang abung angu, mi imang Isak euuling, (aabang ba angase, ene Hebron) angu. Tura idat boma Abraham di angumi mihi. ");
INSERT INTO beu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak ana aabetat euumur mitung 180 sengmuse, ana aamina. Angmuse oal Esau, bot Yakob oleve aing taloul. ");
INSERT INTO beu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Anga naung ba Esau etabaning. Esau ene aabeung angu, Edom. ");
INSERT INTO beu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ana Kanaan jangu aaru medit metma ejangu ening. Nu angu ene Ada. Het aabang enehe nu ene, Elon angu oal jangu. Emiaaru angu ene Oholibama. Hewi aabang enehe nu ene, Anah angu oal jangu. bot idat boma angu ene Sibeon. ");
INSERT INTO beu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau ana bot Ismael oal jangu ene Basmat angu di medit metma ejangu ening. Basmat ekaku mehal angu ene Nebayot. ");
INSERT INTO beu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau ejangu ehalomang, ene Ada angu, ana Elifas vengajai. Basmat ana Rehuel vengajai. ");
INSERT INTO beu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama ana Yeus, Yalam, bot Kora vengajai. Esau oal ang naung emangpi Kanaan mi ing vengajai. ");
INSERT INTO beu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau ana ava asorong ila aabang aabeung nu mi, ekaku Yakob eahalang. Ejangu-evaal, bot nehe ba ekarajang pina ang naung, ebinanta, bot epasaka ba Kanaan mi ang naung emangpi ana baning. ");
INSERT INTO beu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ibinanta bot ipasaka ang naung etatabi toang amara, angu ebele Esau ana ekaku Yakob at tatara, se mana ba ini mi mihi angu, ing emangpi mi mihit jadi niang iila. ");
INSERT INTO beu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Angu ebele Esau (benang ba Edom) angu, ana ila mana nu dol taang ene Seir angu, mimihi. ");
INSERT INTO beu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Anga Esau ba nehe hula, ꞌEdom eneheꞌ angu, etabaning. Ini mana dol taang nu ene Seir angu, mimihi. ");
INSERT INTO beu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau ejangu ene Ada angu, ana vaal mehal nu vengajai, ene Elifas. Elifas oal mehal inang iising. Benangba; Teman, Omar, Sefo, Gatam, bot Kenas. Elifas ejangu gariang angu, ene Timna. Timna ana vaal mehal nu vengajai, ene Amalek. Esau ejangu Basmat ana vaal mehal nu vengajai, ene Rehuel. Rehuel oal mehal inang buta. Benangba; Nahat, Sera, Syama, bot Misa. ");
INSERT INTO beu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau ejangu Oholibama, benangba Ana oal, Sibeon idat angu, ana vaal mehal tue vengajai. Benangba; Yeus, Yalam, bot Kora. ");
INSERT INTO beu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau oal-idat ang naung ini tarae-teapahing lelang toang ening. Nu-nut elelang ekapala veng. Esau oal mutu Elifas oal ang naung, metma lelang Teman ekapala ening, lelang Omar ekapala ening, lelang Sefo ekapala ening, lelang Kenas ekapala ening, lelang Kora ekapala ening, lelang Gatam ekapala ening, bot lelang Amalek ekapala ening. Ing emangpi angu, Esau bot ejangu Ada oleve itabaning. ");
INSERT INTO beu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau oal ene Rehuel, oal ang naung metma lelang Nahat ekapala ening, lelang Sera ekapala ening, lelang Syama ekapala ening, bot lelang Misa ekapala ening. Ing emangpi angu, Esau bot ejangu Basmat oleve itabaning. ");
INSERT INTO beu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau ejangu Ada oleve ioal ang naung metma, lelang Yeus ekapala ening, lelang Yalam ekapala ening, lelang Kora ekapala ening. ");
INSERT INTO beu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Lelang ang naung emangpi Esau ba nehe hula, Edom enehe angu etabaning. ");
INSERT INTO beu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Mana angu mi angu di, Hori enehe nu ue, ene Seir. Oal ang naung tarae-teapahing metma lelang toang ening. Nu-nut elelang angu ekapala veng. Seir oal ang naung metma, lelang Lotan ekapala ening, lelang Sobal ekapala ening, lelang Sibeon ekapala ening, lelang Anah ekapala ening, lelang Disyon ekapala ening, lelang Eser ekapala ening, bot lelang Disyan ekapala ening. ");
INSERT INTO beu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan oal benangba; Hori, bot Heman. (Lotan ekaku jangu angu ene, Timna). ");
INSERT INTO beu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal oal naung benangba; Alwan, Manahat, Ebal, Sefo, bot Onam. ");
INSERT INTO beu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon oal naung benangba; Aya, bot Anah. Anah angaba, imang ekeledei ang naung terang ila bir-babira eele ba nehe bae mi mihi niang angu mi muse, ana jar eng tutung harak angu. ");
INSERT INTO beu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah oal jangu angu ene, Oholibama. Bot oal mehal benangba; Disyon. Disyon oal naung benangba; Hemdan, Esban, Yitran, bot Keran. ");
INSERT INTO beu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser oal naung benangba; Bilhan, Saawan, bot Akan. ");
INSERT INTO beu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disyan oal naung benangba, Us, bot Aran. ");
INSERT INTO beu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Base, Hori enehe ang naung ilelang angu ekapala benangba; Lotan, Sobal, Sibeon, Anah, Disyon, Eser, bot Disyan. Ing emangpi anga naung Seir aabang mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Uanguveng Israel mi angu raja bae ue jedung se, Edom aabang mi angu, eraja veng iila. Iene angu mitamulung, benangba; ");
INSERT INTO beu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor oal, ene Bela angu, ini aing songgar metma bendar Dinhaba eraja ening. ");
INSERT INTO beu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Uanguveng Bela aamina muse, Yobab ba metma raja ening, Bela aing telul. Yobab imang angu ene Sera, Bosra aabang enehe. ");
INSERT INTO beu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab aamina muse, Husam ba metma raja ening, Yobab aing telul. Husam angu, Teman enehe ang naung iaabang mi ba hoa. ");
INSERT INTO beu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam aamina muse, Hadad ba metma raja ening, Husam aing telul. Hadad imang angu, ene Bedad, Awit aabang enehe. (Aing ba uanguveng Moab mi Midian enehe ang naung iat malibal ba, ana ing ening ini iora-vengholong angu.) ");
INSERT INTO beu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad aamina muse, Samla ba metma raja ening, Hadad aing telul. Samla angu, Masreka aabang enehe. ");
INSERT INTO beu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla aamina muse, Saul ba metma raja ening, Samla aing telul. Saul angu, Rehobot aabang ba moar adil mi angu enehe. ");
INSERT INTO beu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul aamina muse, Baal-Hanan ba metma raja ening, Saul aing telul. Saul imang angu, ene Akbor. ");
INSERT INTO beu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hanan aamina muse, Hadar ba metma raja ening, Baal-Hanan aing telul. Hadar angu, Pau aabang enehe. Hadar ejangu angu ene, Mehetabel. Mehetabel imang angu ene, Matret. Bot Hadar idat boma angu ene, Mesahab. ");
INSERT INTO beu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Base, angaba Esau etabaning ang naung ilelang-lelang angu ekapala. Benangba; Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, bot Iram. Ing emangpi nu-nut iaabang angu ene maveng iene angu eamulung. Anga naung emangpi Esau ba nehe ene vengbanang hula, Edom, etabaning angu esarenta. ");
INSERT INTO beu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Anga Yakob iimal isarenta. Tura angu, Yakob ana bale ila Kanaan por taang mihi. Angu turangmi imang Isak emihing mana. ");
INSERT INTO beu_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Yakob ejangu Rahel ana vaal nu veng ajai angu, ini ene maveng ene Yusup. Yusup eumur mitung arinu belta bititu muse, ana jedung kuar, base ana biasat ila ekaku naung ba Bilha bot Silpa oleve Yakob ejangu aaru angu ioal ang naung iat hama-hamat jumba bot aib ang naung terang. Yusup anga, ana sukat ekaku ang naung ilamal-itahi angu, baning hoa metma imang veng at hubai. ");
INSERT INTO beu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Uanguveng, Yusup aing veng ajai angu, Yakob ana boma tila. Angu ebele ana omi metma oal ang naung emangpi ijahi, aarunge ana omi metma Yusup ejahi angu milebe, se Yusup anga aing veng ajai angu ana boma tila angu ebele. Angu ebele, Yakob ana nehe ot kondo aavening aalus nu ening, metma Yusup enang. ");
INSERT INTO beu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yakob ana omi metma Yusup ejahit milebe angu ekaku ang naung uuling ateing muse, ini iomi metma Yusup ealil etetabi, bot ini bae at mateng aaung niang iila. ");
INSERT INTO beu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Bir-kua nu adana, Yusup ana iipalna. Angmuse ana iipal angu metma ekaku ang naung veng iat hubait hula, “Iini vengmee hengi! Na iipalna se hula, ping emangpi bir mi aara gandum edadenang angu parta sehi se, ne aara gandum ba na parta tila angu molo tahi. Angmuse iing emangpi iiara gandum ba iini parta tila angu hoa ne angu veng goleng tahi, bot tout hela ne angu somba.” Vengmeet aulang muse, ekaku ang naung iomi taang alil maveng metma adana. ");
INSERT INTO beu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Angmuse ekaku ang naung ini at mateng hula, “Ee! Aana hula aaing metma raja ening senge ning parenta, ka?” Yusup ana eiipal angu vengsarenta bot mateng aulang anguba, ekaku ang naung ini taang etatabit iomi metma ealalil. ");
INSERT INTO beu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Angmuse Yusup ana bot bale iipalna angu, ana metma ekaku ang naung veng iat hubait hula, “Kaku naung! Na bot bale iipalna tila. Na uuling ateing se, ved, uuru, bot iid arinu belta nu angu naing veng tou bot naing somba.” ");
INSERT INTO beu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yusup ana iipal angu metma imang bot ekaku ang naung veng iat sarenta sengmuse, imang ana ehapat etatabit hula, “Eeiipal angu, tatalang ba aulang angu! Eeomi hula, iiva noleve, bot eekaku ang naung, ning emangpi hoa senge iia angu amiku? Eeomi tatalang ba angu!” ");
INSERT INTO beu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Base Yusup ekaku ang naung iomi alil etatabit metma adana. Aarunge imang ana iipal angu veng pikir bae eseng veng niang. ");
INSERT INTO beu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Minu adana, Yusup ekaku ang naung ila Sikem aabang abung angmi imang eaib bot ejumba ang naung terang. ");
INSERT INTO beu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Angmuse Yakob ana Yusup at mateng hula, “Yusup! Eekaku ang naung ila Sikem aabang abung angmi aib bot jumba ang naung terang. Base mahe na aaing gahing, senge aana ibele ila iuling hengi.” Yusup ana ebalet hula, “Ya, nimang.” ");
INSERT INTO beu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Angmuse Yakob ana mateng hula, “Aana ila senge, eekaku ang naung iuuling, bot aib jumba ang naung di iuuling hengi, ini ue aaung-aaung ee niang. Seng angse, aana bale hoa senge metma veng nat mateng.” Angmuse Yakob ana Yusup ot lamal Hebron emoar angu eahalang, sengmuse ana sampe ila Sikem mi. ");
INSERT INTO beu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Uanguveng Yusup ana bir babira angu mi lamal migoleng ekaku ang naung ing aalaping sehi se, ana nehe mehal nu aing harak, angmuse nehe angu ana Yusup adangtaaning hula, “Aana naba aalaping?” ");
INSERT INTO beu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusup ana ebalet hula, “Na nekaku ang naung ing aalaping. Aanake metma netubing hengi, ini ue taang eoat aib bot jumba ang naung terang?” ");
INSERT INTO beu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Angmuse, nehe angu ana Yusup at hubait hula, “Ini bae angami niang. Na vengmee se ini itajalit hula, mahe pi Dotan mi ila.” Angmuse Yusup ana ekaku ang naung iamulung ila Dotan mi muse, ana ing harak. ");
INSERT INTO beu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Olami sehi muse, Yusup ekaku ang naung uuling ateing iila. Aarunge ana bae ila iabung jedung muse, ini itominu senge via valaping hula ameang. ");
INSERT INTO beu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ini nu-nut itat mateng hula, “Iieng uuling hengi. Nehe sukat iipalna benang hoa iila! ");
INSERT INTO beu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Angase mahe pi ameang, senge pi aing metma jar eng taata nu angu mi bia. Eningse pi timang at mateng hula, binanta balevang nu aing adang ameang iila! Senge eiipal ang naung pi venguuling hula, eningse jadi tatalang!” ");
INSERT INTO beu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Uanguveng Yusup ekaku Ruben ana na angu vengmeet aulang muse, eomi hula malekang Yusup aing ening lohi hengi. Angu ebele ana ekaku ang naung iat mateng hula, “Pi ekang pikaku angu ameang ekang! ");
INSERT INTO beu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Bot pi ekang eve angu abokong ekang. Miaaung pi aing metma jar eng taata angu mi bia, aarunge ekang na iiba ening metma adana ekang.” Ruben ana mateng aulang, se eomi hula Yusup aing ening lohi, senge at bale imang ebele ila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusup ana uhavede ila ekaku ang naung ing harak muse, ini aing pina, sengmuse ekondo aavening aalus ba ana pake angu ini aahit medi. ");
INSERT INTO beu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Angmuse ini at ila aing metma jar eng taata nu angu omimi alolang hela. ");
INSERT INTO beu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Angmuse ini mihit naadang. Ini naadang sehi se, rombongan nu binanta eele ene unta angu veng hoa, ini uuling ateing. Rombongan angu Ismael enehe ang naung ikavila ba Gilead aabang mi barang metma iunta vengeeat Masir mi ila. Barang ba kavila ang naung metma unta vengeea angu benang ba, te manema, pandu, bot obat ang naung. ");
INSERT INTO beu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Angmuse Yahuda ana ekaku ang naung iat hubait hula, “Kaku naung! Kalo pikaku kiki angu pi ameang, bot eve angu pi veng amaang se, euuntung naba? ");
INSERT INTO beu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Mahe pi aing aabalit metma Ismael enehe anga naung inang, aarunge pi ekang na iiba ening metma adana ekang. Pi ening tatalang metma adana dise, aing ba pikaku kiki, bot pive-piding edena. Angu ebele pi ekang aing ening susa ekang!” Angmuse Yahuda ekaku ang naung emangpi emateng angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Uanguveng Midian enehe dagang ang naung angumi lakal muse, Yusup ekaku ang naung ini jar eng taata angumi aing masiring kaluar. Angmuse ini aing aabalit metma Ismael enehe ang naung inang, ebili seeng perak ari aaru. Angmuse Ismael enehe ang naung ini Yusup at Masir mi ila. ");
INSERT INTO beu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ini Yusup aing aabali angu, Ruben bae ateing niang. Angu ebele uanguveng ana bale ila jar eng taata angu mi muse, ana etatabit mibaroti bot omi mang etatabit susa, angmuse ana epakiang eboa mi angu abahak, se Yusup bae ue niang iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Angmuse ana bale ekaku ang naung ibele ila bot iat mateng hula, “Adoo! Pikaku angu ue niang iila! Angase na taang adang ila hengi?” ");
INSERT INTO beu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Angmuse ini Yusup ekondo aavening aalus angu medi bot aib nu sabelet ameang, sengmuse kondo angu ini metma aib eve angu mi abaang. ");
INSERT INTO beu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Seng angmuse kondo aalus ba ve veng angu ini baning ila metma imang enang, bot at hubait hula, “Nimang! Kondo anga ni harak. Aanake euuling hengi. Misavaka have nikaku Yusup ekondo.” ");
INSERT INTO beu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Uanguveng Yakob ana kondo angu medit euuling muse, ana ateing iila. Angmuse ana mateng hula, “Adooo! Anga etabit noal ekondo benang. Binanta ai-jasi banaha mi ang naung aing adang iila. Ajee! Noal benang aamina tila!” ");
INSERT INTO beu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ateing aulang muse, Yakob ana ekondo pake sehi angu abahak, sengmuse ana napaher jasi ba metma aha balal, se omi etatabit susa angu ebele. Angmuse ved kakanap ana oal angu ebaut alolang-niang. ");
INSERT INTO beu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Oal mehal bot oal jangu ang naung emangpi hoa amunang, aarunge Yakob ana eat bae ing venghele niang. Ana mateng hula, “Niang! Angase na aamina di, na noal anga ebaut alolang-niang, se nabae aing veng tajebing niang angu ebele.” Yakob ana omi susat metma oal Yusup adana, bot ana Yusup ebau angu aulang. ");
INSERT INTO beu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Uanguveng Yakob jedung susat aulang sehi se, Midian enehe dagang ang naung ila Masir mi tila. Angmuse ini Yusup at ila metma nehe nu ene Potifar angu oang aabali. Potifar anga, nehe ba raja Firaun eistana mi aing jaga ang naung inehe eele. ");
INSERT INTO beu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Uanguveng angu, Yahuda ana ekaku ang naung iadu, sengmuse ana ila aabang Adulam mi nehe nu ene Hira angu abung mihi. ");
INSERT INTO beu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Angumi Kanaan boma nu ene Sua, oal jangu kaneng nu angu Yahuda ana at tenangeli, angmuse oleve taing medi. ");
INSERT INTO beu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nehe jangu angu atou veng muse ana vaal mehal nu vengajai, ini ene maveng, ene Er. ");
INSERT INTO beu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Seng angmuse nehe jangu angu bot atou veng, angmuse ana bot vaal mehal nu vengajai angu ini ene maveng, ene Onan. ");
INSERT INTO beu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nehe jangu angu ana bot taang vaal mehal nu vengajait maveng, angmuse ini ene maveng, ene Sela. Uanguveng Sela aing vengajai angu, Yahuda ana ue Kesib aabang mi. ");
INSERT INTO beu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Vaal ehalomang, ene Er angu eele tila muse, Yahuda ana nehe jangu nu ene Tamar angu, vengtaaning metma maenang, angmuse oleve taing medi. ");
INSERT INTO beu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Aarunge Er Yahuda oal mutu angu, ana etatabit jasi-ahala ening metma Lahatala Apangaadang mi. Angu ebele, Lahatala Ana aing hukung ening ana aamina. Er ana aamina angu ana bae vaal veng jedung, base etabaning iiba niang. ");
INSERT INTO beu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Angmuse, Yahuda ana oal emiaaru ene Onan angu at mateng hula, “Onan! Eekaku mutu angu bae vaal veng jedung se, ana aamina tila. Base angase, aana eekaku mutu ejangu angu ebele ila bot aing medi, senge aana bisa tabaning-tahelit metma eekaku mutu angu enang.” ");
INSERT INTO beu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan ana hada angu ateing iila. Aarunge ana eat bae tabaning-tahelit metma ekaku mutu Er angu enang niang. Base ved kakanap Onan ana Tamar abung tia se, ana enabing angu metma osingmi bia, senge Tamar ekang vaal veng ekang. ");
INSERT INTO beu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Aarunge Onan ekarajang aulang angu, etatabit jasi-ahalat metma Lahatala Apangaadang mi. Angu ebele andi Lahatala Ana aing hukung ameang. ");
INSERT INTO beu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Angmuse Yahuda ana idat jangu Tamar at hubait hula, “Miaaung aana bale iiva-iimang ebele ila. Aulange noal Sela ana eele tila se, aana bale hoa senge ooleve taing medi” Se Yahuda ana vengpikir hula, misavaka oal Sela ana Tamar medi se, andi aaminat emenghula ekaku aaru angu edadenang. Angmuse Tamar ana iva-imang ebele ila. ");
INSERT INTO beu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Luung niang se, boma Sua oal, Yahuda ejangu benang di aamina. Base ana ejangu angu ebau-epei sampe evengtahi mi. Angmuse Yahuda ana eserang Hira Adulam enehe angu earu, senge oleve nehe ba Timna aabang mi Yahuda ejumba ang naung eamudi gunti angu ibele ila. ");
INSERT INTO beu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Base nehe Tamar at hubait hula, “Iidat mehal Yahuda ana hoa Timna evia mi tila. Ana hoa neheba ejumba ang naung eamudi gunti angu ing vengurus.” ");
INSERT INTO beu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Angmuse Tamar ana epakiang kalabal angu aahit mea, sengmuse ana ava ening amahena bot pakiang aalus pake, bot salinda metma ong angu vengtering sengmuse ana ila viaha masot Enaim aabang mi senge ila Timna evia mi angu, mi mihi. Tamar ana ateing se, Sela ana eele tila, aarunge idat mehal Yahuda ana bae aing metma Sela ejangu ening niang. Angu ebele ana akal aalaping senge ebaang angu medi. ");
INSERT INTO beu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Uanguveng Yahuda ana uuling ateing muse, ana vengpikir hula angu misavaka have nehe jangu aver aanamang, se Tamar ana ava ening amahena, bot apang di vengtering angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Angmuse Yahuda ana nehe jangu ba via adil mi mihi angu ebele va, bot at mateng hula, “Mahe poleve tia.” Se Yahuda ana ateing hula, angu bae idat jangu Tamar niang angu ebele. Angmuse Tamar ana taaning hula, “Kalo poleve tia se, aana naba ba metma manenang?” ");
INSERT INTO beu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda ana vengbanang hula, “Eningse na aib nu panatut metma maenang.” Angmuse Tamar ana ebalet hula, “Aarunge aana malekang na nu metma venggade, senge taveding aana aib angu panatut hoa se, na angu aana bale medi.” ");
INSERT INTO beu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Angmuse Yahuda ana bot taaning hula, “Nababa na metma venggade?” Tamar ana ebalet hula, “Cap esar veng oobo mi hili angu, bot doba aatang mi angu mea.” Vengmeet aulang muse, Yahuda ana na ang naung emangpi metma ma enang, sengmuse oleve ila tia. Sengmuse Tamar ana ila epakiang aalus ang naung, bot salinda ba apang vengtering angu bukat mea, sengmuse ana bot bale epakiang kalabal angu pake. Luung niang muse, Tamar atou veng iila. ");
INSERT INTO beu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yahuda ana eserang Hira Adulam aabang enehe angu abanang ot oang moling, senge aib angu baning ila metma nehe jangu angu enang. Yahuda ana eserang angu at mateng hula, “Aana aib anga baning ila Enaim mi metma nehe jangu aver aanamang angu enang, senge ne barang ba ana ue pina angu bale medi.” Hira ana ila angmo mi muse, ana nehe jangu angu vengtaaning, aarunge ana bae nehe jangu angu aing harak niang. ");
INSERT INTO beu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ana nehe ba angmi ang naung iadangtaaning hula, “Nehe jangu aver aanamang Enaim mi ba biasat via adil mi mihi angu, iini have ateing? Ana taang mi, ee?” Aarunge ini ebalet hula, “Nimang, nehe jangu aver aanamang iiba bae angami niang.” ");
INSERT INTO beu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Base Hira ana bale Yahuda ebele ila, bot at hubait hula, “Nehe jangu angu na bae aing harak niang. Na aing aalaping, aarunge nehe angmomi ang naung vengbanang hula, nehe jangu aver aanamang iiba bae mana angu mi niang.” ");
INSERT INTO beu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Angmuse Yahuda ana Hira ebalet hula, “Vengkilang barang ang naung ana pina! Senge nehe ekang ping ening maniang ekang, bot ekang ening tava aaloring ekang! Aib angu na etatabit panatu tila, aarunge aana bae nahe jangu angu aing harak niang.” ");
INSERT INTO beu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Oma mi uuru tue muse, nehe ila Yahuda at hubait hula, “Iidat jangu Tamar angu, ana ava ening metma nehe jangu aver aanamang ening, angu ebele angase ana atou veng iila.” Angmuse Yahuda ana alil etatabi, bot ana nehe angu at mateng hula, “Ila nehe jangu angu at hoa, senge aing metma aad mi edet ana aamina!” ");
INSERT INTO beu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Uanguveng ini ila Tamar at hoa muse, ana cap angu, bot doba angu at kaluar. Sengmuse ana nehe gahing iot baning ila metma idat mehal etubing, bot at hubait hula, “Nehe mehal ba barang anga naung aing veng angu, aing ba naing ening na natou veng anga.” ");
INSERT INTO beu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda ana barang ang naung parisa sengmuse, ana ateing iilat hula, angu ebarang. Angmuse ana mateng hula, “Etabi! Nehe jangu angu bae ahala niang. Aarunge naing ba ahala. Se na malekang aing metma noal Sela angu enang senge oleve taing medi hengi. Aarunge na bae ening aulang niang. Aaungba mang aing lapas!” Angmuse Yahuda ana bot bae Tamar aing medi niang iila. ");
INSERT INTO beu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar ejol ajai mi muse ateing se, vaal takohal ue atou mi. ");
INSERT INTO beu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Uanguveng ana hula ajai muse, vaal takohal enu angu ana atang taning kaluar. Base bidan ana api tena metma atang angu vengparta, sengmuse ana mateng hula, “Eningse anga ba ematurat kaluar.” ");
INSERT INTO beu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Aarunge vaal angu ana bale atang angu at maso. Angmuse ekaku takohal mehal angu ba ematurat kaluar. Angmuse bidan ana vaal angu at hubait hula, “Aaing anga etatabit daeri! Angu ebele aana eekaku angu aseka senge eematurat kaluar!” Angmuse ini vaal angu ene maveng ene, Peres (evengbanang tarang se hula, ꞌasekat kaluarꞌ). ");
INSERT INTO beu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Seng angmuse, ekaku mehal ba api tena metma atang vengparta tila angu kaluar. Angmuse Ini ene maveng ene, Sera (evengbanang tarang se hula, ꞌHuring tenaꞌ). ");
INSERT INTO beu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Yusup angu Ismael enehe ang naung ini at ila Masir mi tila. Angmuse tentara ba raja Firaun eistana mi jaga ang naung ikapala ene Potifar angu, ana Ismael enehe ang naung iatang mi Yusup aing belit metma ehava mi emalea ening. Aarunge Lahatala Ana Yusup aing veng, angu ebele emangpi ba ana vengkarajang angu, iiba bae ahala di niang. Base ana emanaing Masir enehe angu ehava mi mihi. ");
INSERT INTO beu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar ana ateing se Lahatala Ana Yusup aing veng, bot emangpi ba Yusup ana vengkarajang angu iiba bae ahala di niang muse, ");
INSERT INTO beu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifar ana aing suka. Angmuse ana Yusup aing songgar metma ehava mi mandor ening, bot epasaka ang naung emangpi ana metma Yusup atang mi abaang, senge ana vengurus. ");
INSERT INTO beu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Uanguveng Potifar ana Yusup aing metma ehava omimi epasaka ang naung emangpi vengurus angmuse, Lahatala Ana Eaaung-Ehama metma Masir enehe angu ehava omi angmi, angu ebele epasaka ba ehava omimi, bot ebir mi ang naung tatoang-tatoang. ");
INSERT INTO beu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifar ana epasaka ang naung metma Yusup atang mi abaang senge Yusup ana vengurus aaung-aaung angmuse, Potifar ana bae na iiba vengpikir niang iila, aarunge ana enaadang angu ba enangkolang vengpikir. Yusup angu etatabit mahena, bot elamal-etahi angu di aalus. ");
INSERT INTO beu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mietang aaedeng muse, Yusup emanaing ejangu angu ana uuling Yusup ateing muse, ana etatabit aing suka. Angmuse ana Yusup at mateng hula, Mahe poleve tiat hama-hama. ");
INSERT INTO beu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Aarunge Yusup ana eat bae Potifar ejangu ehur angu venghele niang. Ana at mateng hula, “Ekang ening aulang ekang. Na mulai angami karajang muse, hava omi anga ekarajang angu, nemanaing Potifar ana bae na iiba vengator niang iila. Epasaka ang naung emangpi ana metma natang mi abaang iila. ");
INSERT INTO beu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hava omimi anga, andi eparenta angu bae minataangoa niang. Emangpi angu ana metma natang mi abaang iila, aarunge aaing angu niang, se aaing ejangu angu ebele. Tatalang senge na bisa jasi-ahala eelet alang anga vengkarajang, bot ening metma Lahatala Adana? ");
INSERT INTO beu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Masiking ved kakanap nehe jangu angu ana Yusup asenang alolang-niang, aarunge Yusup ana eat bae aing venghele niang, bot ana bae at tiat hama-hama senge aing medi niang. ");
INSERT INTO beu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ved nu adana, Yusup ana hula hava omimi maso senge karajang se, nehe aabeung iiba bae ue hava omimi niang. ");
INSERT INTO beu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Angmuse emanaing ejangu angu ana Yusup ekondo angu vengpina, sengmuse ana Yusup at mateng hula, “Mahe poleve tia.” Aarunge Yusup ana ea, angu ebele ana ekondo angu vengkilang ue nehe jangu angu atang mi pina, sengmuse ana bihit kaluar. ");
INSERT INTO beu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Uanguveng Potifar ejangu ana ateing se Yusup ekondo angu jedung ue atang mi pina sehi, aarunge Yusup ana bihit kaluar iila muse, ");
INSERT INTO beu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","ana nehe ba angmi karajang ang naung emangpi iaru, sengmuse ana iat mateng hula, “Iieng uuling hengi! Ibrani enehe ba ini at hoa anga, ana ping ening maniang. Ana nebele hoa naing pina senge hula nat tia, aarunge na moring namal aele. Ana vengmee se na moring namal aele muse, ana ekondo angu metma nabung mea sengilaba ana bihit kaluar. ");
INSERT INTO beu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Yusup ekondo angu Potifar ejangu ana metma abung meat sampe emehal hoa. ");
INSERT INTO beu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hur ba ana metma nehe karajang ang naung veng iat mateng iila angu ba, ana bale metma emehal Potifar veng at sarentat hula, “Malea Ibrani enehe ba aana at hoa angu, ana vede nebele hoa senge hula nat tia. ");
INSERT INTO beu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Aarunge na moring namal aele muse, ekondo angu ana metma nabung mea, sengilaba ana bihit kaluar. ");
INSERT INTO beu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifar ana uhavede ejangu esarenta angu vengmeet hula, eemalea angu ana ening aulang-alang metma nadana muse, Potifar ana alil etatabi. ");
INSERT INTO beu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Angmuse Potifar ana Yusup adoi, bot aing metma bui mi maso, raja ana nehe tahang se emana angu mi. ");
INSERT INTO beu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Aarunge Lahatala Ana Yusup at toang-pina, bot Eomi aaung angu Ana kilang metma adana, bot Lahatala Ana ening bui ekapala angu ana omi metma Yusup ejahi. ");
INSERT INTO beu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Angu ebele bui ekapala angu ana nehe ba bui mi ang naung, bot karajang ba angmi angu ana emangpi metma Yusup atang mi abaang, senge aing ba vengurus. ");
INSERT INTO beu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Base emangpi ba bui ekapala angu ana metma Yusup atang mi abaang iila angu, ana bae vengpikir niang iila. Bot Lahatala Ana Yusup at toang-pina, angu ebele karajang ba ana bui mi vengkarajang angu, emangpi lamal molo. ");
INSERT INTO beu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Emangpi ba metma Yusup adana angu sengila muse, nehe aaru ba Masir eraja eistana mi balenta angu, nu raja ejar na vengurus, bot nu raja eroti vengurus angu, ini ahalang ening metma imanaing Masir eraja angu adana. Angmuse raja Firaun ana alil etatabit metma ebalentavala aaru angu iadana. Base ana oleve ing tahang metma nehe ba raja aing jaga ang naung ekapala angu ehava mi, bui ba ini Yusup aing metma mi maso angu mi. ");
INSERT INTO beu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Bui ekapala angu ana Yusup aing metma oleve ing veng hama-hamat mana nu mi, senge Yusup ana ing vengbalenta. Base oleve nehe angmi ing tahang eluung mitung aaedeng. ");
INSERT INTO beu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nehe aaru ba, nu raja ejar na vengurus, bot nu raja eroti vengurus senge nehe ing tahang metma bui mi angu, kua nu adana muse oleve nu-nut iipalna. Bot oleve i iipal angu, nu-nut evengbanang tarang angu bae hama niang. ");
INSERT INTO beu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kukuaveng Yusup ana ibele hoa bot ana uuling iateing se, oleve iomi etatabit susa. ");
INSERT INTO beu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Angmuse Yusup ana oleve iadangtaaning hula, “Etatalang ba vede ved anga, ooleve iiapang omi angu bae sanang niang aulang angu?” ");
INSERT INTO beu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Angmuse oleve Yusup ebalet hula, “Noleve iipalna, aarunge iipal angu nehe iiba bae evengbanang tarang ateing niang.” Angmuse Yusup ana oleve iat mateng hula, “Manusia iiba bae iipal ang naung evengbanang tarang ateing niang, aarunge Lahatala ba ateing. Iipal angu iini aake metma veng nat sarenta hengi.” ");
INSERT INTO beu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Angmuse nehe ba raja ejar na vengurus angu ana eiipal angu metma Yusup veng at sarentat hula, “Ne iipal angu na uuling ateing se, anggor te eela nu ue napangaadang mi tahi. ");
INSERT INTO beu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Eatang angu kalambal tue. Te angu uhavede eva aloal se, ebuma di perek, bot eiipi tena angu di barat vengoopol. ");
INSERT INTO beu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Bot na ateing se, raja Firaun egalas anggur emana angu ue natang mi pina, base anggur eiipi angu na medit ejar angu aadit metma raja egalas angu mi, sengmuse na taning metma raja enang senge ana na.” ");
INSERT INTO beu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Angmuse Yusup ana at mateng hula, “Iipal angu evengbanang tarang se, alang: anggur ete atang kalambal tue angu evengbanang hula, mietang tue. ");
INSERT INTO beu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mietang tue se, raja Firaun ana bui mi aaing kaluar, bot ana eeahalang angu vengahi, senge aana bot bale eekarajang tura angu pina. Raja ejar na angu eningse aana vengurus emenghula tura angu edadenang. ");
INSERT INTO beu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aarunge kalo eeabetang angu aaung iila se, aana malekang naing vengani. Neaabetang elamal-etahi angu aana metma raja veng at sarenta, senge ana nandi naing ening lohit metma bui anga eahalang. ");
INSERT INTO beu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Se, kalo emolo angu eamulung se, tura nehe Ibrani ang naung iaabang mi angu, ini mang naing taavit nat angami hoa. Bot Masir mi anga di, na bae jasi-ahala iiba ening niang. Aarunge eateing-niang se, ini naing metma bui mi, emenghula naing anga nehe jasi edadenang.” ");
INSERT INTO beu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nehe ba roti vengurus angu ateing se, nehe jar vengurus eiipal evengbanang tarang angu aalus aulang muse, andi Yusup at sarentat hula, “Nandi iipalna se hula, na ue roti ota tue metma noong taang aroda. ");
INSERT INTO beu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ota emi atela angu, raja eroti eapapahing ang naung ue mi, aarunge dung ang naung hoa muse, roti ba ota mi ang naung noong taang adang miosing.” ");
INSERT INTO beu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Angmuse Yusup ana ebalet hula, “Iipal angu evengbanang tarang se alang: ota tue angu evengbanang hula, mietang tue. ");
INSERT INTO beu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mietang tue se, raja Firaun ana nehe gahing iot oong angu patait medi. Bot eebaring angu ini metma ludung nu venghele, senge dung ang naung hoa eeaabua angu adang miosing.” ");
INSERT INTO beu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mietang tue muse, raja Firaun etung mi, base ana etung mi angu epesta eele ening metma nehe eele ba aing iivang karajang ang naung inang. Angmuse ana parentat nehe ila bui mi nehe ba jar na vengurus, bot roti vengurus angu oleve iat hoa enehe ang naung iapangaadang mi. ");
INSERT INTO beu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Angmuse nehe ba jar na vengurus angu, raja Firaun ana bale aing metma ekarajang tura angu mi, senge ana bale raja ejar na angu vengurus. ");
INSERT INTO beu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Aarunge nehe ba raja eroti vengurus angu, ini at ila aing helet ameang. Emangpi angu jadit emenghula Yusup ana vengbanang iila angu edadenang. ");
INSERT INTO beu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aarunge nehe ba raja ejar na vengurus benang, ana bae Yusup aing vengani niang iila. Ana etatabit Yusup aing vengtajebing iila. ");
INSERT INTO beu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tung aaru lakal muse, raja Firaun ana iipalna se hula, ana ue Nil Moar eadil angmi tahi sehi. ");
INSERT INTO beu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Mibaroti se, sapi bititu iboa eere-eere, ibuar angu di dula-lengga, jar moar angumi kaluar, bot ue moar eadil angmi dadi-napa adang sehi. ");
INSERT INTO beu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Raja Firaun ana bot taang ateing se, sapi bititu aabeung bot jar moar angmi kaluar, aarunge iboa angu mang kira-taata, bot ibuar angu di mang karutu-karutu. Sapi bititu ba iboa kira-taata ang naung jar moar angmi kaluar muse, ue sapi ba iboa eere-eere ang naung iabung tahi sehi. ");
INSERT INTO beu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Angmuse sapi bititu ba iboa kira-taata ang naung, ini sapi bititu ba iboa eere-eere ang naung adang. Angmuse raja Firaun ana oang-jonga. ");
INSERT INTO beu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Raja Firaun ana bot bale tiat udu muse, ana bot taang iipalna. Eiipal omimi angu ana uuling ateing se, aara-gandum kelang bititu eihi aaving-aaving bot taata tila angu, eela nu mi bilang ue tahi sehi. ");
INSERT INTO beu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ana bot taang uuling ateing se, aara-gandum kelang bititu eabeung bot bilang. Aarunge ekelang ang naung mang kabasi, bot eihi bae mi niang, bot eenar etutung vengbaa base, mang marota bot taata. ");
INSERT INTO beu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Angmuse aara-gandum kelang bititu ba eihi bae mi niang angu, aara-gandum ba vede eihi aaving-aaving angu muut miosing. Angmuse raja Firaun ana oang-jonga, bot ana ateing se hula, ana iipalna tila. ");
INSERT INTO beu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Emikuaveng muse, raja Firaun ana rasa se bae sanang niang. Angu ebele ana nehe gahing iot ila nehe ilavali, bot nehe hur adang ba Masir mi ang naung emangpi iaru. Angmuse raja Firaun ana eiipal angu metma iat vengsarenta, aarunge eiipal angu nehe nu bae evengbanang tarang angu metma veng at hubait jadi niang. ");
INSERT INTO beu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Angmuse nehe ba raja Firaun ejar na vengurus angu, ana raja at hubait hula, “Nimang raja. Vede anga na malekang neahalang anga maangku. ");
INSERT INTO beu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tura nimang raja aana nehe ba roti vengurus angu noleve nialil, angmuse aana noleve ning metma nehe istana jaga ang naung ikapala angu ehava mi, bui ba ue angmi angu mi maso. ");
INSERT INTO beu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Bir-kua nu adana muse, noleve iipalna, aarunge ni iipal angu evengbanang tarang bae hama niang. ");
INSERT INTO beu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Bui omimi angu Ibrani aabang enehe kuar nu ue niat hama-hama. Nehe ba istana jaga ang naung ikapala angu ana aing metma ebalentavala ening. Ni iipal angu ni metma veng at sarenta muse, ana iipal evengbanang tarang angu metma veng niat hubai. ");
INSERT INTO beu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Angmuse emangpi angu jadit emenghula naba ba ana vengbanang angu edadenang, benangba; Nimang raja aana bale naing metma nekarajang tura angu pina, aarunge nehe ba roti vengurus angu aana aing hukung ameang angu!” ");
INSERT INTO beu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Angmuse raja Firaun ana nehe gahing ila Yusup aing medi, bot aing kaluar metma bui angu eahalang. Yusup ana ava vengpiling bot epakiang telul sengmuse, ana ila raja apangaadang mi. ");
INSERT INTO beu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Angmuse raja Firaun ana Yusup at hubait hula, “Na iipalna tila, aarunge iipal angu nehe nu bae evengbanang tarang angu metma veng nat hubait jadi niang. Nehe nu nat hubait hula, aana bisa iipal evengbanang tarang angu metma veng nat hubai.” ");
INSERT INTO beu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Angmuse Yusup ana raja Firaun ehur angu ebalet hula, “Nimang raja, bae naing niang, aarunge Lahatala ba bisa iipal evengbanang tarang angu metma veng aat hubai.” ");
INSERT INTO beu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Raja Firaun ana mateng hula, “Na iipalna se hula, na ue Nil Moar eadil angmi tahi sehi. ");
INSERT INTO beu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Mibaroti se, sapi bititu iboa eere-eere, bot ibuar angu di dula-lengga, jar moar angumi kaluar muse, ue moar eadil angmi dadi-napa adang sehi. ");
INSERT INTO beu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Angmuse sapi bititu aabeung bot jar moar angmi kaluar, aarunge iboa angu mang kira-taata, bot ibuar angu di mang karutu-karutu. Masir mi anga, sapi ba iboa kira-taatat aulang angu na bae uuling ateing di jedung! ");
INSERT INTO beu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Sapi bititu ba iboa kira-taata angu, ini vede sapi bititu ba iboa eere-eere angu adang. ");
INSERT INTO beu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ini adang miosing, aarunge iboa angu mang kilang taatat eaulang. Angmuse na noang-jonga. ");
INSERT INTO beu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Na bale tiat udu muse, na bot taang iipalna. Na uuling ateing se, aara-gandum kelang bititu eihi aaving-aaving, bot taata tila, eela nu mi bilang ue tahi sehi. ");
INSERT INTO beu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Na bot uuling ateing se, aara-gandum kelang bititu bot bilang, aarunge ekelang ang naung mang kabasi, eihi bae mi niang, bot eenar etutung vengbaa base, mang marota, bot taata. ");
INSERT INTO beu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Angmuse aara-gandum kelang bititu ba bae eihi mi niang ang naung, vede aara-gandum kelang bititu ba eihi aaving-aaving ang naung muut miosing. ");
INSERT INTO beu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Angmuse Yusup ana raja Firaun at hubait hula, “Nimang raja. Iipal aaru angu evengbanang tarang hama sehi. Naba ba eningse Lahatala hula ening angu, Ana metma nimang raja veng aat hubai tila. ");
INSERT INTO beu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sapi bititu ba iboa eere-eere angu tung bititu, bot aara gandum ba eihi aaving-aaving angu di tung bititu. Aaru angu evengbanang tarang angu hama. ");
INSERT INTO beu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sapi bititu kira-taata ba iveat kaluar angu, bot aara gandum kelang bititu eihi mi niang, bot eenar etutung vengbaa base mang marota bot taata angu, benangba, ooras malapal-tabonggal mitung bititu. ");
INSERT INTO beu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Emenghula na vede vengbanang iila angu edadenang. Naba ba eningse Lahatala hula ening angu, Ana metma nimang raja veng aat hubai. ");
INSERT INTO beu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mitung bititu omimi angu, eningse mana emangpi ba Masir mi anga ooras barang-ubal angu harak. ");
INSERT INTO beu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Seng angse, ooras malapal-tabonggal mitung bititu angu hoa ping harak. Base, ooras barang-ubal angu pi bae ateing niang, bot pi vengtajebing iila. Eningse ooras malapal-tabonggal angu etatabit eele, angu ebele, Masir por anga miiipi angu, mod iiba bae ue niang. ");
INSERT INTO beu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nimang raja eeiipal angu jadit miaaru, base angu evengbanang tarang se hula, Lahatala Ana vengator aulang iila. Base luung niang se, naba ba Ana vengator iila angu, malekang jadi. ");
INSERT INTO beu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Angu ebele, miaaung nimang raja aana nehe hur adang ba bisa na emangpi angu vengurus angu, nu aing vengtalail. Seng angse nimang raja aana aing songgar, senge ana Masir por anga vengurus. ");
INSERT INTO beu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Nimang raja, aana bot malekang nehe aabeung di ing songgar, senge aara gandum ba ooras barang-ubal mitung bititu omimi nehe aaturi angu, emangpi ini bisa baang iising medi. ");
INSERT INTO beu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ini malekang nimang raja eeparenta angu eamulung, senge aara gandum ba ooras barang-ubal mitung bititu omimi nehe aaturi angu, medit aabang ba ae Masir mi anga miiipi. Seng angse, aara gandum angu ini malekang metma paraha mi amihing aabang ang naung kanap, bot jagat aaung-aaung. ");
INSERT INTO beu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Aara gandum ba vengharaka tila angu eningse metma pimod ening, senge ooras malapal-tabonggal mitung bititu ba hoa Masir mi angu adana. Ening aulang senge, nehe iiba bae malapal-tabonggal angu veng aamina niang.” ");
INSERT INTO beu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Raja Firaun, bot nehe eele ba aing iivang ang naung emangpi Yusup eomi angu, veng iemeng-ajali. ");
INSERT INTO beu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Angmuse raja Firaun ana iat mateng hula, “Kalo pi nehe aabeung aalaping se, nehe iiba emenghula Yusup edadenang anga, pi bae harak niang. Se Yusup anga Lahatala ERoh hamulang aing veng angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Angmuse raja Firaun ana Yusup at mateng hula, “Lahatala Ana emangpi anga metma veng aat hubai tila. Base angu evengbanang tarang se hula, aaing ba hur adang, bot emangpi angu aana bisa vengator. Nehe iiba bae aaing edadenang niang. ");
INSERT INTO beu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Angu ebele, angase na aaing songgar metma gubernur ening, senge neoorang ang naung emangpi malekang eeparenta angu eamulung. Aarunge naing ba lebe miaatang oa.” ");
INSERT INTO beu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Angmuse raja Firaun ana ekila cap angu atang tuba mi aahit medi, sengmuse ana metma Yusup atang tuba angu mi maso. Bot raja Firaun ana mateng hula, “Anga metma etanda ening hula, angase na aaing songgar metma gubernur ening Masir anga miiipi tila.” Bot raja Firaun ana kondo aavening aalus nu metma Yusup enang ana pake, bot rante mas di nu metma Yusup obo mi hele. ");
INSERT INTO beu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Angmuse raja Firaun ana parenta ekuda kereta emiaaru angu metma Yusup enang ana taang mihi, bot nehe ba raja aing jajaga emieele angu ana ing gahing iot kuda kereta eomi-oa angmi lamal, senge moring vengbanang hula, “Oo, Via vengebang oo! Via vengebang, senge nehe eele ana lamal se, iini aing haromat!” Raja Firaun ana Yusup aing songgar metma Masir mi gubernur ening angu, nehe ening aulang metma Yusup adana. ");
INSERT INTO beu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Raja Firaun ana Yusup at mateng hula, “Naing anga ba raja. Aarunge na neoorang ba ae Masir mi anga naung emangpi iat hubai tilat hula, kalo aana bae eemeng-ajali niang se, nehe nu ana bae na iiba ening jadi niang.” ");
INSERT INTO beu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Angmuse raja Firaun ana Yusup ene maveng Masir ene eamulung hula, Sepnat Panea. Bot raja Firaun ana boma Potifera agama ebuangvala nu bendar On mi angu, oal jangu kaneng nu ene Asnat angu, metma Yusup enang ana medi, senge metma ejangu ening. Raja Firaun ana Yusup aing songgar metma Masir mi gubernur ening angu, ana ening aulang metma Yusup adana. ");
INSERT INTO beu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Uanguveng Yusup ana hoa raja Firaun apangaadang mi senge ana mulai karajang angu, euumur mitung aritue. Yusup ana raja Firaun apangaadang mi bale ila muse, ana lamal Masir angu miiipi, mana ang naung emangpi migoleng. ");
INSERT INTO beu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ooras barang-ubal mitung bititu omimi angu, bir ang naung emangpi eaara-gandum etatabi toang. ");
INSERT INTO beu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Aara-gandum angu Yusup ana akumpul, bot ana metma bendar ang naung kanap taloul mea. Bendar ang naung kanap, Yusup ana bir ang naung emangpi eaara-gandum angu akumpul, bot metma bendar angu mi taloul mea. ");
INSERT INTO beu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Aara-gandum ba Yusup ana akumpul angu etatabi toang, emenghula bahi tang omimi angu edadenang, angu ebele etoang angu nehe uukur jadi niang, bot garet jadi niang iila. ");
INSERT INTO beu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ooras malapal-tabonggal angu hoa jedung muse, Yusup ejangu Asnat boma Potifera oal angu, ana vaal mehal aaru veng ajai. ");
INSERT INTO beu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Angmuse Yusup ana mateng hula, “Susa-lala ba tura na nimang ehava mi kaluar senge na harak angu, emangpi Lahatala ana ening na vengtajebing iila.” Angu ebele Yusup ana oal mehal mutu angu ene maveng, ene Manase (evengbanang tarang se hula ꞌvengtajebingꞌ. ");
INSERT INTO beu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Bot Yusup ana oal mehal emiaaru angu ene maveng, ene Efraim. Bot ana mateng hula, “Mana angami na susa-lala toang harak iila. Aarunge Lahatala Eaaung-Ehama ba bae ebale veng niang angu, Ana metma manenang, angu ebele mana angami na vaal veng iila. ");
INSERT INTO beu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mitung bititu ooras barang-ubal ba Masir enehe ang naung omimi aabeta angu evengtahi mi tila. ");
INSERT INTO beu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Angmuse mitung bititu ooras malapal-tabonggal angu hoa, emenghula Yusup ana vengbanang iila angu edadenang. Malapal-tabonggal angu, mana aabeung mi ang naung nehe emangpi harak iila. Aarunge mana emangpi ba Masir miiipi ang naung, mod etatabi toang. ");
INSERT INTO beu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Uanguveng Masir enehe ang naung mulai malapal-tabonggal angu harak muse, ini hoa raja Firaun abung mod banang. Angmuse raja Firaun ana iot ila Yusup aing harak, senge ana parenta tatalang se, ini ening Yusup eparenta angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Aarunge ooras malapal-tabonggal angu etatabi taang eelet maveng, angu ebele mana emangpi ba Masir miiipi ang naung di malapal-tabonggal angu harak. Angmuse Yusup ana melang ang naung emangpi buka, senge aara gandum angu metma Masir enehe ang naung ioang aabali. ");
INSERT INTO beu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bot taang-taang mi angu, mana kanap nehe hoa Masir mi Yusup abung mod beli. Se malapal-tabonggal angu etatabit eele angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Uanguveng Yakob ana vengmee se, nehe hula Masir mi angu aara-gandum ue muse, ana oal ang naung iat mateng hula, “Etatalang ba iini iiamal-amet mihit aulang angu? ");
INSERT INTO beu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Na vengmee se hula, Masir mi angu aara-gandum moe. Lebe miaung iini angmomi ila aara-gandum angu beli, senge pi ekang malapal aamina ekang.” ");
INSERT INTO beu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Angmuse Yusup ekaku inang arinu angu iava vengharaka sengmuse, ini ila Masir mi mod beli. ");
INSERT INTO beu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Aarunge Banyamin Yusup ekaku iia angu, Yakob ana bae ot ekaku ang naung imampi ila niang. Se Yakob ana uangmarit hula, “Misavaka oal angu ana via mi silaka.” ");
INSERT INTO beu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Malapal-tabonggal ba Kanaan mi angu di etatabit eele, angu ebele Yakob oal ang naung bot nehe toang aabeung ang naung di, iat hama-hamat hoa Masir mi mod beli. ");
INSERT INTO beu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Uanguveng angu, Yusup ba Masir mi gubernur iila. Base kalo nehe taang-taang mi hoa hula aara-gandum beli se, Yusup ba aabalit metma mainang. Angu ebele, Yusup ekaku ang naung hoa aing harak muse, ini Yusup apangaadang mi kuku muding, bot tout iapang hela meke mi aing haromat. ");
INSERT INTO beu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Uanguveng Yusup ana uuling ekaku ang naung iateing muse, ana iapang ateing iila, aarunge ana ebabakeng ening emenghula ana bae iapang ateing niang edadenang. Angmuse Yusup ana haratangmi iadangtaaning hula, “Iing anga, taangmi ba hoa?” Angmuse Yusup ekaku ang naung ini ebalet hula, “Ning anga Kanaan mi ba hoa. Ni hoa hula angami mod beli.” Etabit Yusup ana ekaku ang naung iapang ateing, aarunge ing bae apang ateing niang. ");
INSERT INTO beu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Angmuse Yusup ana eiipal tura metma iadana angu mivengani. Angu ebele ana iat mateng hula, “Iini akal mateng! Iini iibabakeng hoa iieng uuling hula, aabang anga nehe ue vengjaga ee niang. Aulang senge iini ila, bot bale hoa niat malibal!” ");
INSERT INTO beu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Aarunge Yusup ekaku ang naung ini ebalet hula, “Niang, Nimang! Ning eemalea anga naung hoa hula mod ba beli. ");
INSERT INTO beu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ning anga iia-mutu, imang nu oal. Bot ning anga nehe aaung. Ni bae nibabakeng hoa angami nieng uuling niang.” ");
INSERT INTO beu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Aarunge Yusup ana bot taang iat mateng hula, “Iini akal mateng! Iini hoa iieng uuling hula, aabang anga etatabit nehe ue vengjaga ee niang!” ");
INSERT INTO beu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Angmuse ini Yusup ehur angu ebalet hula, “Ning eemalea anga naung iia-mutu ninang arinu belta aalu, imang nu oal, moe Kanaan mi. Nikaku nu angu turang mi aamina tila, bot nikaku iia angu angase moe nimang at mihi. ");
INSERT INTO beu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Angmuse Yusup ana ekaku ang naung ibalet hula, “Aaung iila! Emenghula vede na metma veng iiat mateng iila angu edadenang! Iini iibabakeng hoa angami iieng uuling hula, aabang anga nehe ue vengjaga ee niang. ");
INSERT INTO beu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Na malekang iing uuji hengi. Raja Firaun ene na metma iing sumpat hula, kalo iikaku iia angu ana bae angami hoa niang se, iini bae lamal aabang anga eahalang niang. ");
INSERT INTO beu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Base, nehe nu ana malekang ila iikaku iia angu at angami hoa. Iing aabeung angu, na iing tahang angami mihi, aulang senge na bisa ateing hula, iimateng angu etabi ee niang. Kalo niang se, raja Firaun ene omimi, na vengbanang hula, iing anga etatabit nehe omi jasi.” ");
INSERT INTO beu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Angmuse Yusup ana ekaku ang naung ing metma bui mi ing tahang, eluung mietang tue. ");
INSERT INTO beu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Emietang tue muse, Yusup ana ekaku ang naung iat mateng hula, “Naing anga, Lahatala angu na Aing veng nuangmari, bot Eomi angu na eamulung. Base naba ba na vengbanang se, iini malekang ening aulang senge iini bisa aabeta. ");
INSERT INTO beu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kalo iing anga etatabit nehe omi aaung se, iikaku nu ana malekang bui angami kilang mihi. Aarunge iing aabeung angu, iini mod baning ila metma iihava omi enehe ba malapal sehi angmo naung inang. ");
INSERT INTO beu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Seng angse, iini malekang iikaku iia angu at nebele hoa. Angu ba metma ebukti ening, senge na ateing hula iimateng angu etabi. Aulang senge na ekang iing hukung iiameang ekang.” Vengmeet aulang muse, Yusup ekaku ang naung ini ehur angu veng iemeng-ajali. ");
INSERT INTO beu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Angmuse ing emangpi itat mateng hula, “Ahalang ba tura pi ening metma pikaku kiki adana angu, ebale ba angase pi harak iila. Tura pi ateing se, ana etatabit susa-lala, angu ebele ana banang hula piot oangmoling, aarunge pibae aing paduli niang. Angu ebele esusa-elala benang ba angase ebale angu jadit metma piadana anga.” ");
INSERT INTO beu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Angmuse Ruben ana mateng hula, “Nekaku naung! Aulang angu ba, tura na iihapat hula, ekang ahalang ening metma vaal angu adana ekang, aarunge iini bae nehur angu venghele niang. Angu ebele, eve angu etamadi ba angase jadit metma piadana anga.” ");
INSERT INTO beu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Naba ba Yusup ekaku ang naung ini vengmateng angu ana manggarati, aarunge na angu ini bae vengkaruang niang. Se ini hurvala nu pake senge ihur angu metma Yusup veng at hubai angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ini itat mateng angu Yusup ana vengmee muse, ana ava medit iahalang, sengmuse ana bau. Yusup ana baut sengmuse, ana bot bale ekaku ang naung ibele hoa iat mateng. Angmuse Yusup ana Simon aing medi, sengila ba ana nehe ot iapangaadang mi langi metma Simon ia mi. ");
INSERT INTO beu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Angmuse Yusup ana parenta, senge nehe aara-gandum metma ekaku ang naung ikarong ba ini baning hoa angu mi, bot iseeng ang naung bale metma nu-nut ekarong aha angu mi. Ana bot nehe gahing mod di metma ekaku ang naung inang, senge ila via mi se, ini bisa adang. Angmuse nehe ening Yusup eparenta angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Yusup ekaku ang naung, aara-gandum ba ini beli tila angu metma ikeledei angu taang mea, sengmuse ini angmi tahit lamal. ");
INSERT INTO beu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ini ila via mi se bir kua tila, base ini miari. Angmuse ikaku nu angu ana ekarong angu buka, senge hula mod metma ekeledei angu enang ana adang. Aarunge ana uuling ateing se, eseeng angu ue ekarong aha angu mi. ");
INSERT INTO beu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Angmuse ana mibaroti, bot ana ekaku ang naung iat mateng hula, “Kaku naung! Neseeng angu nehe bale metma manenang. Iini euuling hengi! Ae nekarong aha anga mi.” Uuling ateing aulang muse, ing emangpi iomi iipi sehi, bot iuangmarit etatabi. Angmuse ini itadang taaning hula, “Naba ba Lahatala Ana bot ening metma tadana tila?” ");
INSERT INTO beu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ini lamal milalut ila Kanaan mi muse, na emangpi ba nehe ening metma iadana ang naung, ini metma imang at veng sarenta. Ini sarentat hula, ");
INSERT INTO beu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","gubernur ba Masir mi angu ana etatabit mateng haratang metma niadana, bot ana niat mateng hula, ni nibabakeng ila nieng uuling hula, aabang angu nehe ue vengjaga ee niang. ");
INSERT INTO beu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Aarunge ehur angu ni ebalet hula, ꞌNing anga nehe aaung. Ni bae nibabakeng hoa angami nieng uuling niang. ");
INSERT INTO beu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ning anga iia-mutu ninang arinu belta aalu, imang nu oal. Nikaku nu angu ue niang iila, bot nikaku iia angu moe Kanaan mi nimang at mihi.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Angmuse gubernur angu ana mateng hula, ꞌKalo aulang se na malekang iing uuji, senge iini mateng hula iing nehe omi aaung angu, etabi ee niang! Iikaku nu melekang angami mihi. Aarunge Iing aabeung ang naung aara-gandum baning ila metma iihava omi enehe ba malapal ang naung inang, senge ini ekang malapal aamina ekang. ");
INSERT INTO beu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Iini ila se, iini malekang iikaku iia angu at angami hoa. Aulang senge na ateing hula, iini bae iibabakeng hoa angami iieng uuling niang, aarunge iing anga etatabit nehe omi aaung. Ening aulang senge, iikaku ba na aing tahang angu na aing lapas, bot na iing vengkilang iini bisa aabang anga mi mihi.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Uanguveng ini ikarong ang naung veng aosing se, iseeng ba ini hula metma mod beli angu, ue nu-nut ekarong mi ini uuling ateing. Uuling ateing aulang muse, Yakob bot oal ang naung ing emangpi iuangmarit etatabi. ");
INSERT INTO beu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Angmuse Yakob ana oal ang naung iat mateng hula, “Iini hula ening noal ang naung emangpi ue niang. Yusup ue niang iila. Simon di ue niang iila. Bot angase iini hula Benyamin di at ila. Iini hula ening not aamina ba ae anga!” ");
INSERT INTO beu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Angmuse Ruben ana imang at hubait hula, “Nimang! Benyamin angu metma manenang senge na at ila. Eningse na at bale hoa aing metma nimang enang. Kalo na bae at bale hoa niang se, noal mehal aaru angu, nimang aana iameang di aaung.” ");
INSERT INTO beu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Aarunge Yakob ana Ruben ehur angu ebalet hula, “Niang! Benyamin angu ana bae iiat hama-hamat angmo mi ila niang. Se ekaku Yusup aamina tila, angase aing ba enangkolang angu ebele. Kalo andi via mi silaka se, na boma tila anga iini hula ening na susat etatabi senge aamina.” ");
INSERT INTO beu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Malapal-tabonggal ba Kanaan mi angu taang maveng eele. ");
INSERT INTO beu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Bot aara-gandum ba Yakob oal ang naung Masir mi baning hoa angu osing iila muse, Yakob ana oal ang naung iat mateng hula, “Noal naung! Iini bot bale Masir mi ila, senge aara-gandum belit baning hoa hengi.” ");
INSERT INTO beu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Angmuse Yahuda ana imang at hubait hula, “Nimang! Gubernur ba Masir mi angu ana etatabi niat mateng metma nivengani ening iilat hula, kalo nikaku iia Benyamin angu, ni bae at hama-hamat ila niang se, ni ekang ila apangaadang mi, bot ana uuling niateing ekang! ");
INSERT INTO beu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Base kalo nimang aana vengjali, senge Benyamin ana niat hama-hama se, ni ila mod beli. ");
INSERT INTO beu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Aarunge kalo nimang aana eea, senge Benyamin ana bae niat hama-hamat ila niang se, ning di bae ila mod beli niang. Se gubernur angu ana mateng iilat hula, kalo ni bae Benyamin at ila niang se, ni ekang ila apangaadang mi ekang angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Angmuse Yakob ana oal ang naung iat mateng hula, “Etatalang ba iini nehe angu at hubait hula iikaku nu jedung ue, senge ening na susat alang anga?” ");
INSERT INTO beu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Angmuse ini imang ehur angu ebalet hula, “Nehe angu ana nilamal-nitahi angu metma veng niadangtaaning, bot pihava omi enehe ang naung di, ana vengtaaning alolang-niang hula, ꞌIimang jedung aabeta sehi, ee niang? Bot iikaku iia mehal aabeung jedung ue, ee niang?ꞌ Base, etaaning ang naung emangpi ni vengpaksat ebalet molo-molo. Se nuba ba ateing hula, eningse nikaku angu ana hula niot malekang at angmo mi ila hengi?” ");
INSERT INTO beu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Angmuse Yahuda ana bot imang at mateng hula, “Nimang! Aaung ba aana vengjali, senge vaal angu ana niamulung bot ni hama-hamat uuser ila mod beli, senge ping emangpi ekang malapal aamina ekang. Na aing jaga, kalo na iiba jadit metma adana se, naing ba napang metma adana. Kalo na bae at bale hoa aing metma nimang enang niang se, etamadi angu na tevang sampe vengaamina. ");
INSERT INTO beu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kalo pi bae ooras ading eluung alang niang se, ni oma ila-hoa miaaru tila.” ");
INSERT INTO beu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Angmuse imang ana iat mateng hula, “Kalo aulang se, iini malekang ening alang. Pi por anga ehasil ba aaung angu iini ila medi, benangba: kai-hali, dupa, te manema, taung-jal, pandu, arani bot taur ang naung. Seng angse iini metma iikarong ang naung mi, senge metma iiatang-oang ening baning ila metma gubernur angu enang. ");
INSERT INTO beu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Iini malekang seeng baning milebe, se iiseeng ba tura iini uuling ateing se, ue iikarong aha mi angu, iini malekang bale baning ila angu ebele. Uangu nehe ang naung ini oma ening mitasala. ");
INSERT INTO beu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Iikaku Benyamin angu di iini at ila. Angu ebele iiava vengharaka, senge iini uuser bale nehe angu ebele ila. ");
INSERT INTO beu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Na banang, Lahatala ba Eele-Balolu angu Ana ening gubernur angu ana omi metma iijahi, senge Benyamin bot Simon oleve angu ana bisa metma maiinang, senge iini hama-hamat bale hoa. Aarunge naing anga, kalo noal ang naung ini malekang ue-niang hengi se, kilange esusa-elala angu na tevang alolang niang di aaung.” ");
INSERT INTO beu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Angmuse Yusup ekaku ang naung ini iatang-oang ang naung, bot iseeng milebe ang naung medi, senge baning Masir mi ila. Benyamin di ini at hama-hamat lamal Masir mi ila. Ila angmomi muse, ini ila Yusup apangaadang mi. ");
INSERT INTO beu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Uanguveng Yusup ana Benyamin bot ekaku ang naung uuling iateing muse, ehava omi ebalentavala ang naung ekapala angu, ana at mateng hula, “Nehe anga naung iat nehava mi ila! Ved hahama se, ini nat naadang hama-hama. Angu ebele, binanta nu iini malekang sabelet ameang, senge vengharakat ening aaung-aaung.” ");
INSERT INTO beu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Angmuse nehe angu ana ening Yusup eparenta angu eamulung. Bot ana Yusup ekaku ang naung iat Yusup ehava mi ila. ");
INSERT INTO beu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Uanguveng Yusup ekaku ang naung nehe iat ila Yusup ehava mi muse, ini iuangmarit etatabi, bot ini itat mateng hula, “Nehe piat angami hoa anga, seeng ba tura halomang pi baning hoa angami angu, pi bale ila se ue pikarong mi angu ebele. Ini piat angami hoa, senge eateing-niang se ini piadoi, senge pikeledei ang naung ini medi, bot ini ping metma imalea ening,” ");
INSERT INTO beu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Angu ebele, ila Yusup ehava eela mi bae hava maso jedung muse, Yusup ekaku ang naung ini balentavala ang naung ikapala angu at mateng hula, ");
INSERT INTO beu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Nimang! Ni hula aat mateng hengi. Tura ni hoa angami mod beli. ");
INSERT INTO beu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Aarunge ni bale ila via mi bir kua muse, ni miaari. Angmuse nikarong ang naung ni buka senge hula ni keledei ang naung iahi se, ni uuling ateing se, niseeng ba ni hula metma mod beli ang naung ue nu-nut ekarong aha mi. Ni bae ateing niang hula, nuba ba metma angumi mea! Angase, seeng ang naung emangpi ni ae bale baning hoa, senge metma nimang enang. Seeng eabeung di ni ae baning hoa, senge bot metma mod beli.” ");
INSERT INTO beu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Angmuse balentavala ang naung ikapala angu ana ibalet hula, “Ekang iiuangmari ekang! Bot ekang iiomi vang-vang ekang! IiLahatala, bot iidat-iimang ang naung iLahatala angu, Aing ba Eaaung-Ehama bae ebale veng niang angu metma iiadana, bot iiseeng angu bale metma iikarong mi angu. Iiseeng ba iini metma aara-gandum beli angu, na tarima tila.” Angmuse nehe angu ana Simon aing kaluar, bot at hoa metma mainang. ");
INSERT INTO beu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Seng angmuse ing emangpi Yusup ehava mi maso. Ini masot hava mi muse, balentavala ang naung ikapala angu ana jar metma Yusup ekaku ang naung inang, senge ini metma ia laming. Bot ana mod metma mainang, senge ini metma ikeledei ang naung iahi. ");
INSERT INTO beu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Seng angmuse Yusup ekaku ang naung ini iatang-oang ang naung vengharaka, senge ved hahama Yusup ana hoa se, ini metma Yusup enang. Se balentavala ang naung ikapala angu ana iat mateng iilat hula, “Ved hahama se, ini Yusup at naadang hama-hama angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Uanguveng Yusup ana hoa hava mi muse, ekaku ang naung iatang-oang angu ini metma Yusup enang, bot ini Yusup apangaadang mi kuku muding aing sombat iapang hela meke mi. ");
INSERT INTO beu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Angmuse Yusup ana iadangtaaning hula, “Tatalang! Iing emangpi aaung-aaung, ee niang? Bot iimang ba iini metma veng nat sarentat hula, ana boma tila angu, andi aaung-aaung, ee niang?” ");
INSERT INTO beu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Angmuse ini Yusup etaaning angu ebalet hula, “Eemalea ba, nimang angu, ana aaung-aaung, Nimang.” Bot ini tout hela Yusup aing somba. ");
INSERT INTO beu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Uanguveng Yusup ana uuling Benyamin ateing muse, ana mateng hula, “Anga iikaku iia ba tura iini metma veng nat sarenta angu, ka?” Angmuse Yusup ana Benyamin at mateng hula, “Noal! Na banang, Lahatala Ana Eaaung-Ehama ba bae ebale veng niang angu metma maeenang.” ");
INSERT INTO beu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusup omi etatabit ekaku Benyamin angu aing midadanang, se ana etatabit omi metma ekaku Benyamin ejahi angu ebele. Yusup omi ba ekaku Benyamin aing midadanang angu ana vengtahang jadi niang muse, ana ava medit ekaku ang naung iahalang ila ekamar mi maso, bot ana baut etatabi. ");
INSERT INTO beu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yusup ana baut sengmuse, ana apang hiat ening ahamulang, bot ana omi ening adia-adia sengmuse ana kaluar ekaku ang naung ing harak. Bot ana emalea ang naung ing gahing iot mod vengharaka. ");
INSERT INTO beu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Angmuse Yusup aing enangkolang emeja taang naadang. Yusup ekaku ang naung, ing meja aabeung taang naadang. Bot Masir enehe ba iat naadang hama-hama ang naung, ini imeja aabeung nu taang naadang. Se Masir enehe ang naung, kalo ini Ibrani enehe ang naung ing venggaot mihit naadang se, ini hula, angu ini maniang iila. ");
INSERT INTO beu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusup ekaku ang naung ini Yusup omi oa angmi mihit naadang. Ini mihit piling-piling iuumur eamulung, mulai mutu mi, sampe iia. Uanguveng nehe ing vengator senge ini mihit piling-piling aulang angu, ini uuling ateing muse, ing emangpi mijonga. ");
INSERT INTO beu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Angmuse Yusup ana balentavala ang naung iot mod ba emeja taang angu medi, senge metma ekaku ang naung inang ini adang. Mod ba ing emangpi tarima angu, etoang angu hama. Aarunge Benyamin emod angu lebet mi iising, ekaku ang naung imod angu mi ataang oa. Angmuse ing emangpi suka-navera, bot Yusup at hama-hamat naadang sampe iatou veng barang. ");
INSERT INTO beu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Seng angmuse, Yusup ana balentavala ang naung ikapala angu at mateng hula, “Aara-gandum angu metma nehe ang naung nu-nut ikarong angu mi, bot iseeng ang naung di bale metma nu-nut ekarong aha mi aara-gandum angu taang mea. ");
INSERT INTO beu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Negalas perak angu di aana metma ikaku iia eseeng aara gandum ebili angu veng senge, metma ekarong angu mi.” Angmuse nehe angu ana ening Yusup eparenta angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Emitobang kukuaveng sehi muse, Yusup ana ekaku ang naung ing lapas, bot ikeledei ang naung ana metma mainang, senge ini mod baning ila metma inehe ang naung inang. ");
INSERT INTO beu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Aarunge ini lamal ila bendar eola jedung muse, Yusup ana balentavala ang naung ikapala angu at hubait hula, “Aana uuser bihit nehe ang naung iamulung ila. Kalo aana ila ing harak iila se, iat mateng hula, ꞌEtatalang ba gubernur angu ana aaung ening metma iiadana tila se, iini jasi ba ening metma eaaung angu ebalet aulang angu? ");
INSERT INTO beu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Etatalang ba iini nemanaing egalas perak angu taavit baning hoa angu? Galas angu nemanaing ana mi jar na, bot ana paket metma eaajimat ening. Iini etatabit ahalang eele ening metma nemanaing angu adana tila!” ");
INSERT INTO beu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Uanguveng balentavala ang naung ikapala angu ana ila Yusup ekaku ang naung ing harak muase, naba ba Yusup vengbanang angu ana metma veng iat hubai. ");
INSERT INTO beu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Angmuse ini ehur angu ebalet hula, “Nimang eeomi hula tatalang? Ning eemalea anga naung na aulang ening angu, metma niola. ");
INSERT INTO beu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nimang aana ateing iilat hula, seeng ba nikarong mi aara gandum taang jehi ang naung ni bale baning hoa metma nimang eenang iila. Base tatalang senge, ni bisa gubernur ehava mi mas-perak ang naung taavi! ");
INSERT INTO beu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nimang aana parisa! Ning anga naung aana ateing hula, galas perak angu ue nuba ba ekarong mi se, aana aing hukung ameang! Bot ning aabeung ang naung metma eemalea ening di aaung.” ");
INSERT INTO beu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Angmuse balentavala ang naung ikapala angu ana iat hubait hula, “Yo, iimateng angu molo. Aarunge galas perak angu na ateing ue nuba ekarong mi se, aing angu ba metma nemalea ening, iing aabeung ang naung bale ila.” ");
INSERT INTO beu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Angmuse ing emangpi uuser-uuser ikarong ang naung at hela, sengmuse nu-nut ekarong angu buka. ");
INSERT INTO beu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Bot balentavala ang naung ikapala angu ana karong ang naung nu-nut parisat aalus-aalus, mulai mutu ekarong mi sampe iia ekarong mi se, galas perak angu ue Benyamin ekarong mi. ");
INSERT INTO beu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ateing aulang muse, Benyamin ekaku ang naung iomi etatabit susa, angu ebele ini ipakiang ang naung abahak. Bot ini ikarong ang naung bale at mida ikeledei ang naung taang mea, sengmuse ini bale bendar mi ila. ");
INSERT INTO beu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Uanguveng Yahuda bot ekaku ang naung imampi bale ila Yusup ehava mi se, Yusup ana jedung ue angmi, angmuse ing eng emangpi Yusup apangaadang mi kuku muding aing somba. ");
INSERT INTO beu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Angmuse Yusup ana iat mateng hula, “Etatalang ba iini ening alang metma nadana? Iini bae ateing niang hula, nehe ba naing edadenang alang anga, kalo ana etebahi angu pake se, karajang jasi ba iini ening angu ana bae uuling ateing niang ka? ");
INSERT INTO beu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Angmuse Yahuda ana mateng hula, “Angase naba ba ni vengbanang metma nimang eehur angu ebale, bot tatalang senge ni bisa vengbanang hula, ni bae ahala niang. Lahatala Ana ni ahalang ang naung ebale metma maninang iila. Angu ebele, kalo nimang aana hula, galas perak angu ue nuba ekarong mi se aing angu ba aing tahang angu, lebe miaaung nimang aana ning emangpi ning tahang, senge ning emangpi metma eemalea ening.” ");
INSERT INTO beu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Aarunge Yusup ana iat mateng hula, “Niang! Na bae ening aulang niang. Galas perak angu na ateing ue nuba ekarong mi se, aing angu ba metma nemalea ening! Iing aabeung ang naung lohi, base iini bale iimang ebele ila!” ");
INSERT INTO beu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Angmuse Yahuda ana lamal va Yusup abung sengmuse ana mateng hula, “Nimang gubernur! Na hula mateng kabingdena. Na ateing se, aaing angu emenghula raja Firaun edadenang. Angu ebele, na banang aana ooras kabingdena metma manenang senge na hur nu vengbanang metma nimang veng aat hubai hengi. ");
INSERT INTO beu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nimang gubernur aana niadangtaaning iilat hula, ꞌIimang jedung aabeta sehi, bot iikaku di iiba jedung ue, ee niang?ꞌ ");
INSERT INTO beu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Angmuse eetaaning angu ni ebale tilat hula, ꞌNimang jedung aabeta sehi, aarunge ana boma tila, bot nikaku iia di nu ue. Uanguveng nikaku iia aing veng ajai angu, nimang ana boma tila. Nikaku iia angu ekaku nu oleve iva nu angu, turangmi aamina tila. Base angase, nikaku iia angu enangkolang. Angu ebele, nimang ana etatabit omi metma ejahi.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nimang gubernur aana niat hubai tilat hula, niot malekang nikaku iia angu at eebele hoa, senge aana uuling eeng taang ateing hengi. ");
INSERT INTO beu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Aarunge ni Nimang gubernur eehur angu ebalet hula, vaal angu ana bae imang eahalang jadi niang, kalo ana imang eahalang se, imang ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Angmuse Nimang gubernur aana hula, ꞌKalo iini bae iikaku iia angu at hoa niang se, iini bot ekang bale hoa napangaadang anga mi ekang.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Seng angmuse ni bale ila Nimang gubernur eehur angu emangpi metma nimang veng at hubai. ");
INSERT INTO beu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Angmuse nimang ana bot ning gahing hoa mod beli. ");
INSERT INTO beu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Aarunge nimang ehur angu ni ebalet hula, ꞌNimang! Ni bae bisa bale angmomi ila niang. Se gubernur angu ana mateng iilat hula, kalo iini bae iikaku iia angu at hoa niang se, iini ekang bale hoa napangaadang anga mi ekang. Base nikaku iia angu di ana malekang nimampi hama-hama, senge ni lamal.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Angmuse nimang ana bot mateng hula, ꞌIini ateing iilat hula, nejangu Rahel ana vaal aaru kolang veng ajait metma manenang. ");
INSERT INTO beu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Vaal ehalomang angu ue niang iila, bot na vengbanang iilat hula, oma binanta balevang ba aing adang iila. Angu ebele angase, na bae uuling ateing niang iila. ");
INSERT INTO beu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Vaal iia anga di, kalo iini nabung aing medit at ila, bot andi silaka se, iini ening na taang susat maveng, base na mang aamina.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Angu ebele, Nimang gebernur. Kalo na bale nimang ebele ila, bot bae nikaku iia anga at hama-hamat ila niang se, eningse nimang ana malekang aamina. Se vaal angu kalo ana bae nimang abung niang angse, nimang ana aabetat jadi niang angu ebele. Bot nimang di etatabit boma tila, angu ebele kalo ni taang ening ana susat maveng angse, ana malekang aamina. ");
INSERT INTO beu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Bot, naing ba eemalea anga na nimang at palai tilat hula, kalo na bae vaal angu at bale ebele ila niang se, etamadi angu naing ba tevang veng aamina. ");
INSERT INTO beu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Base na banang, Nimang gubernur: Naing ba eemalea anga, angami mihit metma vaal angu aing telul, senge naing metma Nimang gubernur eemalea ening. Senge biar vaal angu ana ekaku ang naung iat hama-hamat bale ila. ");
INSERT INTO beu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kalo vaal angu ana bae niat hama-hamat ila niang se, tatalang senge na bisa bale nimang ebele ila. Se nimang ana susat sampe veng aamina angu, kalo na uuling ateing se, na vengtahang jading angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Uanguveng angu, Yusup eomi angu ana bae nehe toang ang naung iapangaadang mi vengtahang jadi iang iila. Angu ebele ana nehe toang ang naung iot kaluar, sengmuse ana ava metma ekaku ang naung itubing. ");
INSERT INTO beu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Seng angmuse Yusup ana baut amal aelet etatabi. Angu ebele Masir enehe ang naung vengmee, bot nehe ba raja Firaun eistana mi ang naung di vengmee. ");
INSERT INTO beu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Angmuse Yusup ana ekaku ang naung iat mateng vengbanang hula, “Naing anga ba iikaku Yusup benang! Timang jedung aabeta sehi ka?” Vengmeet aulang muse, Yusup ekaku ang naung ini iuangmarit etatabi, angu ebele Yusup ehur angu ini ebalet jadi niang. ");
INSERT INTO beu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Angmuse Yusup ana ekaku ang naung iat mateng hula, “Iini ma peang-peang hengi.” Angmuse ekaku ang naung ini ma Yusup abung-abung. Angmuse Yusup ana bot ekaku ang naung iat mateng hula, “Naing anga iikaku Yusup, ba iini metma Masir enehe ang naung ioang aabali angu. ");
INSERT INTO beu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Etabit iini naing aabali tila. Aarunge angase ekang iiuangmari ekang, bot ekang iiva manasal ekang. Lahatala ba hula ening aulang, senge na nematurat hoa angami nehe toang eabetang angu vengator, senge ini ekang malapal aamina ekang. ");
INSERT INTO beu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Angase ooras malapal-tabonggal anga mitung aaru tila, bot mitung iising maveng hengi angu, nehe bae meke bale niang, namuding-natapa niang, bot bae na iiba avaning di niang. ");
INSERT INTO beu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Angu ebele, naba ba pi bae manggarati niang anga Lahatala Ana ening, bot Ana nematurat nat angami hoa, senge iing bot iioal-iidat ang naung bisa abetat aaung-hama. ");
INSERT INTO beu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Base, ual-hula iing ba ening na ae angami anga, aarunge Lahatala ba ening. Aing ba naing ening na bisa Masir angami gubernur anga, bot bisa raja Firaun eistana omi angu vengurus anga. Bot Lahatala ba ening, angu ebele nehe iiba bae eelet minataang oa niang anga. ");
INSERT INTO beu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Angase iini uuser bale timang ebele ila, bot at mateng vengbanang hula, ꞌOoal Yusup benang jedung aabeta sehi! Lahatala Ana aing ening Masir mi gubernur iila. Ooal Yusup ana hula oot uuser-uuser ila Masir mi aing harak hengi. ");
INSERT INTO beu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Eningse nimang aana Gosen mi mihi, aulange ekang ooal Yusup eola ekang. Mana angu aaung, bot berang. Base nimang ooal-iidat ang naung bisa angmi aabeta. Aulang di eejumba, eeaib, eesapi, bot nimang eepasaka ang naung emangpi. ");
INSERT INTO beu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kalo nimang aana Gosen mi mihi se, ooal Yusup ana bisa angmomi aing gariang. Se ooras malapal-tabonggal anga mitung iising jedung maveng hengi. Base eningse Yusup ana vengator, senge nimang bot eehava omi enehe ang naung, bot nimang eebinanta ang naung emangpi na-nu ekang iioang kurang ekang.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusup ana bot iat mateng hula, “Angase iini uuling iieng taang ateing iila. Bot nekaku Benyamin di ateing iilat hula, naing ba Yusup benang, bot hur ba na vengbanang anga nai mi kaluar metma iiat hubai. ");
INSERT INTO beu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Angu ebele timang veng at sarentat hula, neparenta ae Masir mi anga etatabit eele. Bot naba ba iini uuling iieng taang ateing iila ang naung di emangpi metma timang veng at sarenta. Seng angse, uuser timang at angami hoa!” ");
INSERT INTO beu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Angmuse Yusup ana ekaku Benyamin obo kalavang bau, bot Benyamin di ekaku Yusup abea mi hilit bau. ");
INSERT INTO beu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusup jedung bau sehi angmuse, ana ekaku ang naung di emangpi nu-nut iamiku, bot iobo kalavang. Seng angmuse, Yusup ekaku ang naung ini mulai Yusup at sasarenta. ");
INSERT INTO beu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Uanguveng, raja Firaun eistana mi nehe hoja vengmee se hula, Yusup ekaku ang naung ue hoa muse, raja Firaun bot nehe ba aing iivang karajang ang naung di emangpi iomi sanang. ");
INSERT INTO beu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Angmuse raja Firaun ana Yusup at mateng hula, “Eekaku ang naung iat meteng, senge iot aara-gandum metma ikeledei ang naung vengeeat baning Kanaan mi ila. ");
INSERT INTO beu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Seng angse, iimang bot ihava omi enehe ang naung emangpi iat angami hoa. Eningse mana ba emeke aabua ae Masir mi anga na metma mainang ini mi mihi, senge ini bisa meke angu vengkarajang, bot eihi angu adang. ");
INSERT INTO beu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Bot iat mateng senge ini angami kereta aaedeng baning ila, metma iimang, bot ijangu-ivaal ang naung vengeeat iat angami hoa. ");
INSERT INTO beu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ipasaka ba ini baning angami hoa jadi niang ang naung, iot ekang vengiomi susa ekang, se aaung-hama ba ae Masir anga, eningse emangpi metma ioa angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yakob oal ang naung ini ening raja Firaun eparenta angu eamulung. Angmuse Yusup ana kereta aaedeng, bot ekaku ang naung imod via mi di ana vengator metma mainang, raja Firaun eparenta angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusup ana pakiang hiba di pasang na-nut metma ekaku ang naung inang. Aarunge ekaku Benyamin angu ana seeng perak ratu tue, bot pakiang hiba pasang iising metma maenang. ");
INSERT INTO beu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na ebili veng Masir mi angu Yusup ana metma keledei lotal arinu vengeea, senge panatut ila metma imang enang. Aara-gandum, roti, bot mod rupa-rupa angu di, Yusup ana bot metma keledei manarang arinu vengeea, senge imang iimal Masir mi hoa se, metma imod via mi ening ");
INSERT INTO beu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Angmuse Yusup ana ekaku ang naung ing lapas ini ila, bot ana iat mateng metma ivengani ening hula, “Iini ekang via mi iitat natataanang ekang!” ");
INSERT INTO beu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Angmuse Yusup ekaku ang naung ini lamal Masir eahalang, ila Kanaan mi imang aing harak. ");
INSERT INTO beu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ila Kanaan mi muse, ini imang at hubait hula, “Nimang! Ooal Yusup benang, jedung aabeta sehi. Angase aing metma nehe eele ening, Masir mi parenta pina!” Yakob ana vengmeet aulang, aarunge ana omi metma naababeung, bot ana bae ihur angu e etabit vengbanang niang. ");
INSERT INTO beu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Aarunge uanguveng ini Yusup ehur ang naung emangpi metma imang veng at hubai sengmuse, kereta ba Yusup ana panatu senge metma imang aing eeat Masir mi ila angu ana uuling ateing muse, uahvede omi sanang, bot ana ihur angu e etabit vengbanang. ");
INSERT INTO beu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Angmuse ana mateng hula, “Adoo! Noal Yusup benang jedung aabeta sehi. Aulang senge nomi anga sanang! Angase na malekang ebele ila uuling neng taang ateing senge, na aamina di aaung.” ");
INSERT INTO beu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Angmuse Yakob ana enaosing taloul, sengmuse ini tahit lamal Kanaan eahalang. Ini lamal ila Berseba aabang mi muse, Yakob ana binanta nu sadaka ening metma Lahatala ba tura imang Isak ana Aing somba angu Enang. ");
INSERT INTO beu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Bir-kua nu adana muse, Lahatala Ana Ava metma Yakob etubing, emenghula ana iipal na edadenang. Yakob ana vengmee se, Lahatala ana earut hula, “Yakob! Yakob!” Angmuse Yakob ana madut hula, “Ya Nimang!” ");
INSERT INTO beu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Angmuse Lahatala Ana Yakob at mateng hula, “Naing anga Lahatala ba turangmi iimang ana Naing somba angu. Masir mi ila angu, aana ekang uuangmari ekang. Angmomi eningse eetabaning angu, Na metma bangsa eele ening. ");
INSERT INTO beu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Na aat toangpinat ila Masir mi, bot Naing anga ba eningse eetabaning ang naung iat toangpinat bale hoa Kanaan por anga taang. Eeabetang angu evengtahi mi, bot aana aamina se, ooal Yusup ba atang metma eetaning.” ");
INSERT INTO beu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Angmuse Yakob bot oal ang naung ini tahit lamal Berseba aabang eahalang. Oal ang naung ini at mida kereta ba raja Firaun ana panatut hoa angu taang, bot ijangu-ivaal ang naung di emangpi. ");
INSERT INTO beu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Ipasaka ba Kanaan mi ini metma ioa tila, bot ibinanta ang naung emangpi ini baning. Yakob ana etabaning ang naung mijangu-mimehal, emangpi iat Masir mi ila. ");
INSERT INTO beu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob ehava omi enehe ba ana iat hama-hamat Masir mi ila benangba: Ruben, vaal mutu angu. ");
INSERT INTO beu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben oal naung benangba: Henok, Palu, Hesron, bot Karmi. ");
INSERT INTO beu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simon, bot oal naung benangba: Yamuel, Yamin, Ohad, Yakin, bot Sohar. Bot Saul, iva angu Kanaan jangu. ");
INSERT INTO beu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi, bot oal naung benangba: Gerson, Kehat bot Merari. ");
INSERT INTO beu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda, bot oal naung benangba: Sela, Peres, bot Sera. Yahuda oal eabeung ba iene Er, bot Onan angu, Kanaan mi aamina tila. Bot Peres oal naung benangba: Hesron, bot Hamul. ");
INSERT INTO beu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar, bot oal naung benangba: Tola, Pua, Ayub, bot Simron. ");
INSERT INTO beu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon, bot oal naung benangba: Sered, Elon, bot Yahleel. ");
INSERT INTO beu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ing emangpi angu, uanguveng ini Mesepotamia mi mihi sehi angu ba, Yakob ejangu Lea ana ing veng ajai. Bot ikaku jangu nu angu ene Dina. Base Yakob bot ejangu Lea oleve itabaning angu emangpi inang ari tue belta tue. ");
INSERT INTO beu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad, bot oal naung benangba: Sifion, Hagi, Suni, Esbon, Eri, Arodi, bot Areli. ");
INSERT INTO beu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser, bot oal naung benangba: Yimna, Yiswa, Yiswi, Beria, bot ikaku jangu nu ene Sera. Bot Beria oal naung benangba: Heber, bot Malkiel. ");
INSERT INTO beu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ing emangpi angu inang arinu belta taling. Ing angu, Yakob bot ejangu ene Silpa angu oleve itabaning. Silpa angu, malea ba Laban ana metma oal jangu Lea, Yakob ejangu enang angu. ");
INSERT INTO beu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakob ejangu ene Rahel angu, ana vaal aaru veng ajai, benangba: Yusup bot Benyamin. ");
INSERT INTO beu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusup ana Masir mi vaal aaru veng benangba: Manase, bot Efraim. Ejangu ene Asnat ba vaal aaru angu veng ajai. Ejangu imang angu ene Potifera. Aing angu bendar On mi kapala agama. ");
INSERT INTO beu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin, bot oal naung benangba: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, bot Ared. ");
INSERT INTO beu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ing angu, Yakob bot ejangu Rahel oleve itabaning. Ing emangpi inang arinu belta buta. ");
INSERT INTO beu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Yakob ejangu nu ene Bilha angu, oleve ioal ba, Dan, bot Naftali. Dan oal angu, ene Husim. ");
INSERT INTO beu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali, bot oal naung benangba: Yasel, Guni, Yeser, bot Silem. ");
INSERT INTO beu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob ejangu Bilha oleve itabaning angu, emangpi inang bititu. Bilha angu malea ba Laban ana metma oal jangu Rahel, Yakob ejangu enang angu. ");
INSERT INTO beu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakob etabaning ba at hama-hamat Masir mi ila angu, ing emangpi inang ari taling belta taling. Idat jangu ang naung maveng jedung. ");
INSERT INTO beu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Bot Yusup oal aaru ba Masir mi ing veng ajai angu maveng. Base Yakob ehava omi enehe ba uanguveng ila Masir mi angu, ing emangpi inang ari bititu. ");
INSERT INTO beu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ini lamal ila Masir abung muse, Yakob ana Yahuda aing gahing ot ematurat ila Yusup earu, senge Yusup ot hoa Gosen mi imang aing harak. Uanguveng ini ila Gosen mi tila muse, ");
INSERT INTO beu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusup ana ekereta taang hoa angumi imang aing harak. Uanguveng ini taing harak muse, Yusup ana imang aing karavang, bot ana baut etatabit luung. ");
INSERT INTO beu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Angmuse Yakob ana Yusup at mateng hula, “Angase na aamina di aaung! Se na uuling aateing iila, bot na ateing se, aana jedung aabeta angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Angmuse Yusup ana ekaku ang naung emangpi iat hubait hula, “Na malekang ila raja Firaun at hubait hula, nekaku, bot nimang ehava omi enehe ba Kanaan mi ang naung emangpi nebele hoa iila. ");
INSERT INTO beu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Bot eningse na vengbanang hula, iing anga naung emangpi biasat jumba, bot sapi gariang. Angu ebele, iibinanta, bot iipasaka ang naung, emangpi iini baning hoa iila. ");
INSERT INTO beu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Misavaka raja Firaun ana iiaru, bot ana iiadangtaaning hula, iini biasat naba karajang ba vengkarajang, ");
INSERT INTO beu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","se iini ehur ebalet hula, iing emangpi anga, kiki sehi mi binanta ba gariang, emenghula iidat-iimang ang naung edadenang. Ening aulang senge, eningse ana iiot Gosen eooang angmi mihi.” Yusup ana ekaku ang naung iat hubait aulang, se Masir enehe ang naung, nehe ba terangvala angu ini iat aabeta se, ini rasat maniang. ");
INSERT INTO beu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Angmuse Yusup ana ekaku ang naung inang iising iat hama-hamat ila raja Firaun apangaadang mi. Yusup ana raja Firaun at mateng hula, “Nimang, bot nekaku naung ba Kanaan mi angu emangpi hoa iila. Ijumba, aib, sapi, bot ipasaka ang naung di emangpi ini baning hoa. Angase ing emangpi ae Gosen eooang angu mi tila.” Angmuse Yusup ana ekaku ang naung ing metma raja Firaun etubing. ");
INSERT INTO beu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Angmuse raja Firaun ana iadangtaaning hula, “Iikarajang ba naba?” Ini raja Firaun ehur angu ebalet hula, “Ning anga terangvala, emenghula nidat-nimang ang naung edadenang. ");
INSERT INTO beu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kanaan mi angu malapal-tabonggal etatabi, base dadi-napa metma ni jumba, bot ni aib ang naung enang di iiba niang. Angu ebele, ni hoa hula aabang anga mi mihit metma nehe hoangmanang ening. Base kalo bisa se nimang raja aana vengjali, senge ni Gosen eooang angmi mihi.” ");
INSERT INTO beu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Angmuse raja Firaun ana Yusup at mateng hula, “Iimang, bot eekaku ang naung angase ing emangpi ae angami tila. ");
INSERT INTO beu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Base Masir aabang anga, ini bisa metma iabang mamolo ening. Masir aabang anga mi angu, Gosen eooang angu na ateing se, lebe miaaung. Angu ebele, biar ini Gosen eooang angba mi mihi. Bot nehe ba binanta gariang aaung angu aana ing vengator, senge ini bisa ne binanta ang naung vengurus.” ");
INSERT INTO beu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusup ana imang di at hoa raja Firaun apangaadang metma raja etubing. Angmuse Yakob ana sambajang Lahatala Abanang, senge Lahatala Ana Eaaung-Ehama ba bae ebale veng niang angu, metma raja Firaun enang. ");
INSERT INTO beu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Angmuse raja Firaun ana Yakob adangtaaning hula, “Eeuumur mitung eedeng iila?” ");
INSERT INTO beu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob ana raja Firaun ehur angu ebalet hula, “Na aabetat neuumur mitung ratu nu ari tue tila, aarunge na bae kilang mana nu mi niang. Nidat-nimang ang naung di bae mana nu mi aabeta niang. Aarunge neuumur angu kalo metma iuumur angu vengsudi se, neuumur angu lebe mitukang. Bot neaabetang angu etatabit susa ba aaving.” ");
INSERT INTO beu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Angmuse Yakob ana raja Firaun apalait hula lamal. Aarunge bae lamal jedung muse, Yakob ana bot Lahatala Abanang, senge Lahatala Ana Eaaung-Ehama ba bae ebale veng niang angu, taang metma raja Firaun enang. ");
INSERT INTO beu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Angmuse Yusup ana mana vengator metma imang, bot ekaku ang naung inang ini mi mihi. Bot meke aabua ba Masir mi ue Gosen eooang mi angu, ana vengator metma ma inang, senge metma ipasaka ening raja Firaun eparenta angu eamulung. (Mana angu eningse ini ene maveng, ene ꞌRamesesꞌ.) ");
INSERT INTO beu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Bot Yusup ana mod vengator metma imang, ekaku, bot ijangu-ivaal ang naung inang, itoang angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Uanguveng angu, ooras malapal-tabonggal angu taang eelet maveng, angu ebele taang-taang mi angu mod iiba niang iila. Mesir mi, bot Kanaan mi angu, nehe emangpi iomi bae na-nu vengaanamang di niang iila. Nehe emangpi ia-atang barea, bot bae na iiba ening jadi niang, se malapal angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ved kakanap nehe hoa Yusup abung aara-gandum beli se, seeng ang naung emangpi ana akumpul, senge metma raja Firaun ehava mi taloul mea. ");
INSERT INTO beu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Seeng ba Mesir mi, bot Kanaan mi ang naung miosing iila muse, Mesir enehe ang naung ini hoa Yusup at mateng hula, “Mod metma maninang hengi, senge ni ekang malapal aamina ekang. Se ni seeng osing iila angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Angmuse Yusup ana ibalet hula, “Kalo iiseeng iiba niang iila se, iibinanta ang naung baning hoa manenang, senge na mod metma vengtelul.” ");
INSERT INTO beu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Angmuse ini ibinanta ang naung baning hoa metma Yusup enang, bot Yusup ana mod metma ma inang. Benangba ikuda, ijumba, iaib, isapi, bot ikeledei ang naung. Base tung uangu veng angu, Yusup ana mod vengharakat metma iadana angu, ini ibinanta ang naung ba metma vengtelul. ");
INSERT INTO beu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tung angu miahibul iila muse, tung emiaaru angu ini Yusup ebele hoa, bot Yusup at mateng hula, “Nimang gubernur! Ni bae metma eeamaang niang. Ni seeng osing iila, bot ni binanta ang naung emangpi ni baning hoa metma nimang eenang iila muse, angase na iiba bae ning veng niang iila. Angase ni meke, bot ni boa iipi anga ba ae. ");
INSERT INTO beu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ekang vengkilang ni aapangaadang mi aamina ekang. Kalo ni aamina se, nuba ba meke ang naung vengkarajang? Aaungba aana ning beli, senge ning metma raja Firaun emalea ening. Bot ni meke ang naung di aana medi senge metma epasaka ening. Nabing metma maninang senge ni bisa aabeta, bot ekang aamina ekang. Bot aulang senge meke ang naung di ekang osing jehi ekang.” ");
INSERT INTO beu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ooras malapal-tabonggal angu taang eelet maveng, angu ebele Masir enehe ang naung ini imeke ang naung emangpi aabali. Angmuse Yusup ana Masir mi meke ang naung emangpi beli, senge metma raja Firaun epasaka ening. ");
INSERT INTO beu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Angu ebele Masir enehe ang naung, tupa dena mi ila tupa dena mi angu, emangpi ing metma raja Firaun emalea ening. ");
INSERT INTO beu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Aarunge kapala agama ang naung imeke angu Yusup ana bae beli niang, se kapala agama ang naung raja Firaun ana mod metma mainang alolang-niang, angu ebele ini mod angu veng aabeta. Base ini bae imeke ang naung aabali niang. ");
INSERT INTO beu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusup ana erayat ang naung iat mateng hula, “Vede ved anga na iing belit metma raja Firaun emalea ening iila. Bot iimeke ang naung di na belit metma raja Firaun enang iila. Base nabing anga iini medi, senge baning ila metma meke ang naung mi muding. ");
INSERT INTO beu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Eihi angu eooras mi iini avaning se, baang iising angu iini baning hoa metma raja Firaun enang, bot baang buta angu, iini iiba metma nabing ening iimeke ang naung mi muding, bot iiba metma iijangu-iivaal, bot nehe ba ue iihava omi mi ang naung iing emangpi iimod ening.” ");
INSERT INTO beu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Angmuse ini Yusup ehur angu ebalet hula, “Aana ning ening aabeta tila, angu ebele ni tarima kasi vengbanang metma maenang. Angase biar ning metma raja Firaun emalea ening.” ");
INSERT INTO beu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusup ana Masir mi na angu metma hada evia-via ening, metma meke adana. Base aara-gandum ba nehe avaning angu, ini malekang baang iising baning hoa metma raja Firaun enang. Baang buta angu ini paket metma iabetang adana. Aarunge kapala agama ang naung imeke angu, raja Firaun ana bae beli niang. Hada evia-via aulang angu, angase ini jedung pake sehi. ");
INSERT INTO beu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Uanguveng angmuse, Israel enehe ang naung ini Masir mi Gosen eooang angmi mihi. Bot ing metma aabang angu enehe ening. Ini etatabit kavasa, bot ini tabaning-taheli, angu ebele ini taang tatoang-tatoang. ");
INSERT INTO beu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Bot Masir mi angu, Yakob ana jedung aabetat mitung arinu belta bititu, base eaabetang angu euumur emangpi mitung ratunu aributa belta bititu. ");
INSERT INTO beu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Uanguveng Yakob ejol aamina angu peang iila muse, ana oal Yusup earu, bot at mateng vengbanang hula, “Noal ee! Luung niang se, Lahatala Ana nearut bale ila. Base kalo aana etatabit oomi metma nejahi se, aatang metma naput iivang angmi pina senge aana nat sumpa, aulange aana ekang naing metma Masir angami taloul ekang. ");
INSERT INTO beu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nenomi hula tidat-timang ang naung iat hama-hamat imana sanang angu mi. Angu ebele aana malekang nat ila metma idaang emana angu mi, senge naing taloul.” Angmuse Yusup ana imang ehur angu ebalet hula, “Nimang ee! Kalo eeomi aulang iila se, na eeomi angu eamulung.” ");
INSERT INTO beu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Angmuse Yakob ana Yusup at mateng hula, “Kalo aulang se, aana malekang nat sumpa hengi, senge na ateing hula aana nenomi angu eamulung.” Angmuse Yusup ana imang at sumpa, imang eomi angu eamulung. Sengmuse Yakob ana etiang mana oong oa angmi ia kuku muding, senge sambajang tarima kasi vengbanang metma Lahatala Enang. ");
INSERT INTO beu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Luung niang muse, nehe hoa Yusup at mateng vengbanang hula, imang ana dila tamadi. Angmuse Yusup ana oal aaru, Manase bot Efraim oleve iat idat boma Yakob ebele ila euling. ");
INSERT INTO beu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Uanguveng nehe Yakob at mateng hula Yusup iimal ebele hoa iila muse, ana ava vengdaeri bakung tahit etiang mana taang mihi. ");
INSERT INTO beu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Angmuse ana Yusup at mateng hula, “Noal ee! Lahatala ba Ekavasa etatabit eele angu, Ana tura Lus aabang ba Kanaan mi angu, mi Ava metma netubing, bot Eaaung-Ehama ba bae ebale veng niang angu, Ana metma manenang iila. ");
INSERT INTO beu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Bot Ana nat mateng vengbanang hula, ꞌOoal-iidat angu eningse Na ening ini taang tatoang-tatoang, bot eningse ing metma bangsa eele ening. Bot aabang anga eningse Na metma eetabaning ang naung inang, senge metma ipasaka ening aulang ejehing-emeang.ꞌ ");
INSERT INTO beu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Angase ooal aaru, Efraim bot Manase oleve ba na bae eebele hoa Masir mi jedung se aana ing veng ajai tila angu, ing metma noal ening. Efraim angu di noal, bot Manase angu di noal, emenghula Ruben bot Simon oleve angu edadenang. ");
INSERT INTO beu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Bot eetabaning ba eningse aana taang veng ajai angu, aaing ba metma ooal ening. Aarunge pasaka ang naung paul se, iene angu vengbanang ikaku aaru iene angu eamulung. ");
INSERT INTO beu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Naing anga, uanguveng ni Mesepotamia mi bale Kanaan mi ila via mi Efrata aabang ba Kanaan mi angu abung muse, iiva Rahel ana aamina. Uanguveng angu nomi etatabit susa! Base na aing metma via ba Efrata aabang adang ila angu eadil angmi taloul.” (Aabang angu, angase nehe ene maveng ene Betlehem.) ");
INSERT INTO beu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Uanguveng Yakob ana uuling Yusup oal ang naung iateing muse, ana Yusup adangtaaning hula, “Anga naung nuba oal?” ");
INSERT INTO beu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusup ana imang etaaning angu ebalet hula, “Anga naung noal ba Lahatala Ana metma angami manenang angu.” Angmuse Yakob ana mateng hula, aana iat ma nabung-nabung, senge na Lahatala Abanang Ana Eaaung-Ehama ba bae ebale veng niang angu metma mainang. ");
INSERT INTO beu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakob ana boma tila, bot eng di moro tila, base ana bae uuling aaung niang iila. Angu ebele Yusup ana oal ang naung iat va imang abung-abung, sengmuse imang ana ing karavang bot iamiku. ");
INSERT INTO beu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Angmuse Yakob ana Yusup at mateng hula, “Na vengnomit hula eluung alang base, na bae uuling apang ateing niang iila. Aarunge angase, Lahatala Ana ening miaaung-mihama, angu ebele eetabaning angu na bisa uuling iateing.” ");
INSERT INTO beu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Angmuse Yusup ana oal ang naung iasorong metma Yakob eahalang, sengmuse Yusup ana imang apangaadang mi iakuku muding, bot tout hela apang meke mi. ");
INSERT INTO beu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Seng angmuse Yusup ana oal ang naung ing pinat iat va imang abung-abung iatahing. Yusup ana oal ehalomang, Manase, angu aing metma Yakob etene oa angmi atahing; bot oal emiaaru, Efraim, angu aing metma Yakob ebajaul oa angmi atahing. ");
INSERT INTO beu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Aarunge uanguveng Yakob ana hula Lahatala Eaaung-ehama ba bae ebale veng niang angu vengbanang metma oleve mainang muse, Yakob ana atang tene angu taning metma Efraim oong taang mea, bot atang bajaul angu ana taning metma Manase oong taang mea. ");
INSERT INTO beu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Angmuse Yakob ana sambajang Lahatala Abanang Eaaung-Ehama ba bae ebale veng niang angu metma Yusup enang, vengbanang hula, “Iidat boma Isak imang Abraham, bot iidat boma Isak angu, oleve aabetat Lahatala Eomi angu ba eamulung alolang-niang. Lahatala angu ba Ana naing gariang, bot na jedung kuar sehi sampe boma anga, Aing ba metma ne terangvala ening. ");
INSERT INTO beu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Aing angu ba naing metma jasi-ahala toang-rae angu eahalang iila. Base na banang senge, Eaaung-Ehama ba bae ebale veng niang angu Ana metma vaal anga naung inang, bot itabaning ang naung di inang. Aulang senge, kalo ini sambajang Lahatala Abanang se, idat boma Abraham ene, idat boma Isak ene, bot nene angu, ini bae vengtajebing niang. Bot itabaning angu eningse taang tatoang-tatoang, base metma por-alolang anga taang bangsa eele ening.” ");
INSERT INTO beu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Uanguveng Yusup ana uuling ateing se imang ana atang tene angu metma Efraim oong taang mea muse, Yusup ana ateing hula angu bae aaung niang, angu ebele ana imang atang angu vengpina bot asorong metma Manase oong angu taang mea. ");
INSERT INTO beu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusup ana imang at hubait hula, “Nimang! Ekang ening aulang ekang. Manase anga ba vaal mutu. Efraim angu vaal iia. Base nimang aatang tene angu aana malekang metma Manase ba oong taang mea hengi, se aing ba mutu angu ebele.” ");
INSERT INTO beu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aarunge Yakob ana oal Yusup ehur angu ebalet hula, “Noal ee! Na ateing. Na ateing hula, eningse Manase di aing metma bangsa eele nu ening, bot eningse andi kavasa-bisa. Aarunge eningse ekaku Efraim angu lebe mikavasa-mibisa mi ataang oa, bot Efraim etabaning angu eningse toang-rae, base metma bangsa toang ening.” ");
INSERT INTO beu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Angmuse Yakob ana Lahatala Eaaung-Ehama ba bae ebale veng niang angu vengbanang metma vaal aaru angu inang hula, “Kalo Israel enehe ang naung ini Lahatala Abanang, Eaaung-Ehama ba bae ebale veng niang angu metma nehe enang se, ini Lahatala Abanang hula, ꞌLahatala Eaaung-Ehama ba bae ebale veng niang angu Ana metma maeenang, emenghula Ana metma Efraim bot manase oleve inang angu edadenang.ꞌ ” Base Yakob ana Efraim ene ba ematurat vengbanang, Manase ene angu evea. ");
INSERT INTO beu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Angmuse Yakob ana Yusup at hubait hula, “Noal ee! Luung niang se, na aamina. Aarunge Lahatala Ana kilang iiat toang-pina, bot eningse Ana iiat bale iidat-iimang ang naung iaabang mi ila. ");
INSERT INTO beu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Bot angase, naba ba na metma maeenang angu milebe, na metma eekaku ang naung inang angu mi ataang oa. Dol balolu Kanaan mi ba tura na Amori enehe ang naung iat malibal medi angu di, na metma maeenang maveng.” ");
INSERT INTO beu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Angmuse Yakob ana oal ang naung emangpi iaru, bot iat mateng hula, “Noal naung! Iini hoa naing vengkumpul, senge naba ba eningse iini jedung aabeta sehi harak angu, elamal-etahi na metma nu-nut veng iiat hubai.” ");
INSERT INTO beu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Angmuse Yakob ana oal ang naung iat mateng hula, “Iing ba Yakob oal ang naung! Ma naing venggoleng tahi. Iiavel hele, senge naing ba iimang Israel anga hula iiat mateng. ");
INSERT INTO beu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! Aaing ba noal mutu! Aaing ba nekuat-nedaeri bot aaing ba nedoba-netalakang. Nehe etatabit aaing aada. ");
INSERT INTO beu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Aaing ba halut emenghula jar edadenang, aarunge eemutu angu baa tila. Angase aaing eegunang veng niang iila, se aana netiang mana taang mida senge nejangu Bilha angu at tia netiang mana angu ening akarita tila angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simon bot Lewi! Ooleve angu iia-mutu! Ooleve angu eningse iini peda-aring ba medi, senge nehe toang ing ening susa-lala. ");
INSERT INTO beu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Neboa-iipi angu ekang ila jasi-ahala ba iini vengtominu angu omimi hela ekang, bot noramana angu ekang ila naba ba iini vengkarajang angu vengpina ekang. Se iialil-iiamara angu ebele, iini nehe ameang iila, bot iini iiaveing-eera mi adang senge sapi ia euurat di patait asia tila. ");
INSERT INTO beu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Base, iialil-iiamara angu angase bale metma iiadana, bot iini iiaveing-eera mi adang angu angase iing ba bale rasa. Eningse Lahatala Ana ening iitabaning angu tarae-teapahing, senge ini tasirang ila mana ba Israel mi angu mi iipi. ");
INSERT INTO beu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! Aaing eene angu evengbanang tarang se hula, ꞌtajaningꞌ. Eekaku ang naung eningse ini aaing tajaning, bot ini aaing vengtou senge aaing aada. Nehe ba iomi metma eealalil ang naung, eningse aana aatang angu metma ing pariku, base ini ioong ohit jadi niang. ");
INSERT INTO beu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahuda, aaing angu emenghula singa lumul edadenang, base ana bisa ena mod aalaping adang. Bot emenghula singa lotal bot singa manarang ba iava asising tia, bot ioal jaga tia se, nehe iiba bae baranit ing dei niang angu edadenang. Aandi aulang. Nehe aaing veng iuangmari, base ini bae ening rupa-rupat metma aadana niang. ");
INSERT INTO beu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nehe ba parenta pina angu bae Yahuda elelang omi angu eahalang niang, bot parenta evia-via angu bae ehahama angmi ava asorong niang. Eningse enehe nu lebe Mieele-Mibalolu angu Ana hoa, senge mihit parenta pina se, bangsa-bangsa emangpi Aing vengtou, bot Aing venghele. ");
INSERT INTO beu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Eningse eeabetang angu etatabit sanang. Na nu bae eeganasing niang. Naba ba aana hula vengkarajang se, emangpi angu aana bisa ening. Eebinanta, bot eebir ang naung eiihi angu di taang tatoang-tatoang. ");
INSERT INTO beu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Eenaadang-eejar na ang naung, tamaa-tengge, bot bae eseng veng niang. ");
INSERT INTO beu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! Aaing por ba metma eepasaka ening angu, etatabit berang, bot tang abung, eha angu bendar Sidon vengjehi. Kampal taang-taang mi aalarit hoa se, ini eeoolol angu mi miari, bot ilivang metma eeoolol angu mi abaang teding. ");
INSERT INTO beu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! Aaing emenghula keledei ba kuat-daeri angu edadenang, aarunge oong angu etatabit aanamang. Kalo aana via omi hahama mi tia tila se, nuba ba bisa aaing paksat oot tahi, senge ana lamal milalu. Aarunge kalo aana uuling aaring mana bot aabang mura-rame nu ateing iila se, nehe bae gahing niang di aana barang metma aabea taang tevang, senge mi ila. ");
INSERT INTO beu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! Aaing eene angu evengbanang tarang se hula, ꞌhakimꞌ. Aaing bot eetabaning ang naung ba eningse eelelang omi eparkara ang naung vengputus, bae dena vengtamadi niang. Eelelang angu di, Israel elelang ba nu. ");
INSERT INTO beu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Aaing angu di pintar emenghula duming erasong veng ba via adil mi vagal tia angu edadenang. Kalo nehe kuda taang mihit angmi lakal se, aana kuda amota oat ia angu mitapuru, base nehe ba kuda taang angu baat amota oat hela. ");
INSERT INTO beu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ya NIMANG LAHATALA! Na banang senge Aana Eeaung-Eehama ba bae ebale veng niang angu metma ning emangpi maninang. ");
INSERT INTO beu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! Aaing eene angu pi vengmee se emenghula hula, ꞌaat tahiꞌ edadenang. Eningse nehe ba iomi jasi ang naung ini eebele hoa aat tahi, aarunge aana bale iat tahi, bot ing ening ini iora-vengholong. ");
INSERT INTO beu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Aaing eemaada-eepina eihi angu eningse etatabit aaung. Base enaadang-eejalna angu bae ganasing niang. Angu ebele aana roti ba tamaa-tamaa angu ening, senge raja ang naung hoa aabung beli. ");
INSERT INTO beu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! Aaing emeghula aarohing manarang ba lohit lamal angu edadenang. Nehe iiba bae aaing vengator jadi niang. Eningse vaal ba aana veng ajai ang naung mahena-mahena. ");
INSERT INTO beu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusup! Aaing emenghula te uhavede eihi veng jar eng eela mi bilang angu edadenang. Eatang angu bilang tembok balolu ang naung taang mida. ");
INSERT INTO beu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nehe omi jasi ang naung eningse ini iomi jasi angu metma aadana, emenghula ini uumat-aburit metma aatapa angu edadenang. ");
INSERT INTO beu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Aarunge Lahatala ba na Aing somba angu Ana ooangmoling, bot Ana aatang angu ening adaeri, base aana bale eeuumat-aburit angu metma iatapa. Aana bisa ing uuntung, se Lahatala Ana ooangmoling angu ebele. Lahatala Ekavasa angu etatabit eele! Aing ba metma neterangvala ening, Ana naing liko, bot naing jaga. Angu ebele neaabetang angu na metma Aing ba Aing veng Apina. ");
INSERT INTO beu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Eningse Aing ba aaing liko, bot aaing jaga. Bot Eaaung-Ehama bae ebale veng niang ba, doe burang mi, ae por-alolang taang, bot tabaning-taheli ening tatoang-tatoang, bot aabetat mona-majalung angu eningse Ana metma maeenang ");
INSERT INTO beu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Lahatala Eaaung-Ehama ba aulang angu Ana turang mi metma manenang iila, etoang-erae angu aabu-dol ang naung di mikabing. Base emangpi angu eningse totut hela oong angu taang, se aaing ba lebe mieele-mibalolu, eekaku ang naung emangpi mi iataang oa angu ebele. ");
INSERT INTO beu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! Aaing emenghula jabar balevang ba malapal angu edadenang. Kukuaveng se, ana ila emod adang angu vengkori senge adoit medit adang. Bir kua se, ana ila ealehil angu metma oal ang naung vengpaul. Eetabaning angu di eningse lumul-kavasar aulang!” ");
INSERT INTO beu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yakob ana oal ang naung iaabetang elamal-etahi angu metma veng iat hubait aulang, nu-nut etabaning angu eamulung. Ing emangpi angu ba metma Israel elelang arinu belta aalu ening. ");
INSERT INTO beu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Angmuse Yakob ana oal ang naung iat palait hula, “Luung niang se na aamina. Base kalo na aamina se, iini malekang nat ila metma iidat boma Abraham edaang angu mitaloul. Daang angu ue pa omimi, Makpela aabang bot Mamre aabang ba Kanaan mi angu abung. Pa angu, bot bir angu, turangmi iidat boma Abraham ana Het aabang enehe nu ene Efron angu abung beli, senge metma edaang emana ening. ");
INSERT INTO beu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Iidat boma Abraham, bot ejangu Sara angu, nehe ing metma angumi taloul. Iidat boma Isak, bot ejangu Ribka oleve di nehe ing metma angumi taloul. ");
INSERT INTO beu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Bot nejangu Lea di na aing metma angumi taloul. Base iini malekang naing metma nejangu Lea abung angmi taloul. Bir angu, bot pa ba moe angmomi angu, turangmi iidat boma Abraham ana Het aabang enehe ang naung iabung beli tila.” ");
INSERT INTO beu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob ana oal ang naung iapalait aulang sengmuse, ana ia aaru angu ahelit etiang mana taang mida, angmuse ana aamina. ");
INSERT INTO beu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Angmuse Yusup ana ava abaang hela imang apang angu karavang baut etatabi, bot ana imang amikut alolang-niang. ");
INSERT INTO beu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Seng angmuse Yusup ana nehe ba baring veng a urus ang naung ing parentat iot jal-manema metma imang avela. ");
INSERT INTO beu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Angmuse nehe ba baring veng a urus ang naung ini jal-manema metma Yakob ebaring angu avelat mietang aributa. Bot Masir enehe ang naung ini Yakob ebaring angu ebaut sampe mietang ari bititu, emenghula inehe eele aamina angu edadenang. ");
INSERT INTO beu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Emietang ari bititu muse, Yusup ana nehe ba raja Firaun eistana mi ang naung iat hubait hula, “Na iabanang iini nehur anga metma raja Firaun veng at hubait hula alang: ");
INSERT INTO beu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ꞌUanguveng nimang ana hula aamina muse ana not palait hula, ebaring angu malekang baning ila Kanaan mi taloul. Angu ebele na banang raja ana vengjali, senge na nimang at ila angmomi aing taloul sengila se, na bale angami hoa.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Angmuse raja Firaun ana mateng hula, “Kalo aana imang at sumpat aulang iila se, aaung ba aana iimang at angmomi ila aing taloul.” ");
INSERT INTO beu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Angmuse Yusup ana lamal angmomi ila imang aing taloul. Nehe ba raja Firaun eistana mi karajang, bot Masir eboma-boma ang naung emagpi Yusup amulung. ");
INSERT INTO beu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusup ekaku ang naung, bot nehe ba ikarajang pina ang naung di emangpi Yusup amulung ila Yakob aing taloul. Aarunge Ijangu-ivaal, bot ibinanta ang naung ini kilang ing metma Gosen mi iamihing. ");
INSERT INTO beu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tentara ba kereta baning, bot kuda baning di, toang Yusup amulung angmomi ila. Angu ebele nehe ba lamal Yusup amulung angu etetabit via aavening. ");
INSERT INTO beu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ini lamal Yarden moar lakal ila mana nu ene Goren-Haatad angu mi muse, Yusup bot nehe toang ba amulung ang naung emangpi imang eaamina angu ebau-epei. Angu ebele ini bau-pei angu etatabit oorang-dumung. Ini angmi bau-pei mietang bititu omimi. ");
INSERT INTO beu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Uanguveng Kanaan enehe ba angmi ang naung uuling iateing muse, ini mateng hula, “Masir enehe ang naung ini bau-pei anga ba etatabit oorang-dumung.” Angu ebele mana ba Yarden moar edenaveng angmi angu, ini ene maveng ene Abel-Misraim. Evengbanang tarang se hula, ꞌMasir enehe ang naung bau-peiꞌ. ");
INSERT INTO beu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Angmuse Yakob oal ang naung ening naba ba ana metma iat palai tila eamulung. ");
INSERT INTO beu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Yakob oal ang naung ini at ila Kanaan mi muse, ini aing metma Makpela aabang ba Mamre aabang eved danang-oang angmi, pa ba Abraham ana beli metma edaang emana ening angu mi taloul. Mana angu turangmi Abraham ana Het aabang enehe nu ene Efron angu abung beli tila. ");
INSERT INTO beu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusup ana Yakob aing taloul sengmuse, ekaku ang naung, bot nehe toang ba iamulung ila angmomi ang naung emangpi bale Masir mi ila. ");
INSERT INTO beu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Uanguveng ini bale ila Masir mi muse, Yusup ekaku ang naung ateing se imang ue niang iila, angu ebele ini etatabit iuangmari. Angmuse ini itat mateng hula, “Kaku naung! Iini vengpikir hengi! Jasi ba tura pi ening metma Yusup adana angu, misavaka ana ebale metma tadana se, pi ening tatalang?” ");
INSERT INTO beu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Angu ebele ini itominu sengmuse nehe gahing ila Yusup at mateng hula alang: “Timang bae aamina jedung angu, ana ehur anga metma veng niat mateng iila. ");
INSERT INTO beu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Base iini malekang Yusup at mateng hula, ꞌAhalang ba eekaku ang naung ini tura ening metma aadana tila ang naung, aana malekang metma eetajebing ening.ꞌ Se ning anga di Lahatala ba timang ana Aing somba angu Emalea. Angu ebele angase ni hoa aabanang, senge aana ni ahalang angu metma eetajebing ening.” Nehe hoa Yusup at mateng aulang muse, ana baut etatabi. ");
INSERT INTO beu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Angmuse ekaku ang naung di hoa apangaadang mi iakuku muding, bot mateng hula, “Biar aana ning metma eemalea ening di aaung.” ");
INSERT INTO beu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Aarunge Yusup ana ekaku ang naung iat mateng hula, “Iini ekang iiuangmari ekang! Lahatala angu ba Ana bisa nehe hukung. Aarunge naing anga niang. ");
INSERT INTO beu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tura angu etabit iini tominu, senge hula jasi angu ening metma nadana. Aarunge iiomi ba jasi angu emangpi Lahatala Ana aboi, senge Ana ening emangpi angu aaung-hama, emenghula angase jadi anga edadenang. Benang ba Ana naing songgar metma nehe eele ening, senge nehe toang bisa aabetat aaung-hama. ");
INSERT INTO beu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Base na iiat mateng, ekang iiuangmari ekang. Iing bot iioal ang naung, emangpi angase na iing gariang.” Yusup ana ehur metma ekaku ang naung veng iat mateng aulang, senge ening iomi angu sanang. ");
INSERT INTO beu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Angmuse Yusup bot ekaku ang naung ing emangpi kilang Masir mi mihi. Yusup ana aabetat euumur mitung ratunu arinu. ");
INSERT INTO beu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusup ana Efraim oal-idat ang naung itabaning emitue ang naung di uuling iateing. Bot Manase idat, Makir oal ang naung di Yusup ba ing gariang. ");
INSERT INTO beu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusup ana ekaku ang naung iat mateng hula, “Kaku naung! Na rasa se, ne ved aamina angu peang iila. Aarunge na nomi vengaanamang hula, Lahatala Ana kilang iing gariang. Bot eningse Aing ba iiat lamal aabang anga eahalang, senge iiat bale ila aabang ba Ana metma tidat boma Abraham, tidat boma Isak, bot timang Yakob veng iat palai tila angu mi maso.” ");
INSERT INTO beu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Bot Yusup ana ekaku ang naung iabanang iot at sumpat hula, “Iini malekang nat palai hengi. Kalo ejol angu mi, Lahatala Ana iiat bale aabang angu ebele ila se, iini malekang nekira ang naung baning ila.” ");
INSERT INTO beu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Angmuse Yusup ana Masir mi aamina, euumur mitung ratunu arinu. Yusup ebaring angu nehe jal-manema metma vengbokong, sengmuse ini metma ebaring piti angu mi mea. ");
INSERT INTO beu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anga sarenta aaung-hama. Anga, Lahatala Oal Ene Yesus Kristus. Aing angu ba turang jamang mi Lahatala matubing iila. Esarenta halomang angu alang: ");
INSERT INTO beu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yesus bae Ekarajang at lamal jedung se, Lahatala Ana nehe nu aing gahing, ene Yohanis. Yohanis malekang ila via vengharakat metma Yesus Ehoa angu adana. Turangmi Lahatala Ana Ehur vala nu ot vengbanang iila. Aing angu ene boma Yesaya. Ana metma esurat mi hurak vengbanang hula: “Vengmee o! Na Nenehe aing gahing, ila via vengharakat metma ma Eenang. ");
INSERT INTO beu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Eningse nehe angu ila mana taimang ba nehe bae ue mi niang angmi, senge ana moring hula: ꞌNehe emangpi iiava vengharaka, via ening aaung, metma Lahatala Ehoa angu adana! Via ening ahama, senge Aing tarima.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Ang muse Yohanes hoa via vengharakat metma Yesus enang. Yohanis angu nehe earu se hula, aing angu nehe Sasarani. Ana mana taimang ba mi aabeta. Ekondo angu unta eamudi ba nehe ening. Esape buar angu binanta ebuar ba nehe ening. Emod aadang angu kebet bot taung jal. Yohanis eabetang angu, emenghula tura boma Elia eabetang angu edadenang. Uangu adana nehe toang rae bendar Yerusalem mi, bot propinsi Yudea enehe ang naung, emangpi hoa Yohanis emana angmi aing harak. Ini hoa Yohanis euling e, bot ehur angu vengmee. Yohanis iat mateng hula, “Iini malekang iiava vengbaroti e, Lahatala Ana iiahalang angu vengahi bot iiat aaung-hama. Malekang iing sarani, aulange hula iini Lahatala angu At aaung-hama tila.” Yohanis emateng angu vengmee muse, iahalang ang naung emangpi ini vengbanang, seng muse Yohanis ana Yarden moar mi ing sarani. ");
INSERT INTO beu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana iat mateng hula, “Nehe mieele mibalolu nu bae naing edadenang niang, eningse Ana hoa. Metma Egahing vala ening di, naing anga bae gahing vala angu at hama niang. ");
INSERT INTO beu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naing mang jar ba metma iing sarani, aarunge Aing angu Ana ening miaaung-mihama, bot Lahatala ERoh hamulang angu Ana metma iiomimi.” ");
INSERT INTO beu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Uangu adana, Yesus Ana Nasaret aabang propinsi Galilea mi angu mi hoa, Yohanis Aing harak. Ang muse Yohanis ana Yarden moar mi Aing sarani. ");
INSERT INTO beu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus Ana jar mi bale da, mibaroti se, burang viaha baleleng. Lahatala ERoh emenghula dung molola edadenang hela Aing taang. ");
INSERT INTO beu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bot Lahatala Amal vengbanang hula, “Aaing anguba, Noal Nomi Eejahi. Aaing anguba Nomi ening aeele.” ");
INSERT INTO beu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ang muse, Lahatala ERoh Yesus at lamal ila mana taimang nu mi. ");
INSERT INTO beu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mana angumi Ana binanta balevang ang naung ihahama mi aabetat mietang aributa. Angumi, setang enehe eele hoa aajajalat hula abaang, aarunge bae jadi niang. Ang muse Lahatala Egahing vala sorga mi hoa Aing vengbalenta. ");
INSERT INTO beu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ved evaila angu, Yohanis nehe Sasarani angu nehe at ila bui mi, aarunge Yesus Ana Galilea mi ila Lahatala Ehur aaung-hama angu metma nehe avomung-apahang. ");
INSERT INTO beu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ana vengbanang hula, “Vengmee o! Angase Lahatala Ehoa peang iila! Angase nehe emangpi ateing hula Lahatala ba Eparenta pina tila. Angu ebele iini malekang iiava vengbaroti! Sengila ba, iiomi metma Yesus Esarenta aaung-hama anguba vengaanamang.” ");
INSERT INTO beu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ved nu adana, Yesus Ana dano Galilea eadil angmi lamal. Nehe nu ene Simon bot ekaku ene Andrias Ana ing harak. Ole ue aab dalang sehi, se angu ikarajang ved kakanap. ");
INSERT INTO beu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus iarut vengbanang hula, “Ee! Ma Namulung! Ooleve angu aab ba aalaping, aarunge eningse ooleve Na ening metma nehe vavalaping.” ");
INSERT INTO beu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Vengmeet Yesus mateng aulang muse, oleve idalang angu mea, sengila ba tahit lamal Yesus Amulung. ");
INSERT INTO beu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus bot taang lamal se, Ana uuling Sabadeus oal ang naung iateing. Mutu angu ene Yakobus, bot ekaku kiki angu ene Yohanis. Oleve ue je mi ipoko vengpiling sehi. ");
INSERT INTO beu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus iarut vengbanang hula, “Ee! Ma Namulung.” Ang muse, imang bot nehe ba imampi karajang ang naung oleve iadu, sengila ba ini Yesus Amulung. ");
INSERT INTO beu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ang muse, Yesus bot nehe buta ba Amulung angu, ini ila bendar Kapernaum mi. Uangu adana nehe Yahudi ang naung ived Lahatala tajaning, Yesus mida ihava hamulang mi nehe toang angu iavomung-iapahang. ");
INSERT INTO beu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yesus iavomung-iapahang angu vengmee muse, ing emangpi mijonga, se naba ba Ana vengbanang elamal-etahi angu etatabit Lahatala Eomi ang ba Eamulung, bae Yahudi eguru agama ang naung edadenang niang. ");
INSERT INTO beu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Uangu adana, nehe setang apang taang di nu ue. Andi nehe Yahudi ehava hamulang angmi mida. Ang muse setang ba apang taang angu moring hula, ");
INSERT INTO beu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“He! Yesus, Nasaret Enehe! Aana naba ba ening metma ni adana! Aana hoa hula ning ening jasi ka? Ni ateing se Aaing ang ba hamulang kadulang turangmi Lahatala hula Aaing gahing hoa angu.” ");
INSERT INTO beu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aarunge Yesus etatabit ateri senge vengbanang hula, “Taimang! Nehe angu eola.” ");
INSERT INTO beu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ang muse setang angu ana nehe angu ajajoat etatabi, seng muse ana nehe angu eola. ");
INSERT INTO beu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nehe toang rae ba hava hamulang omimi angu mijonga, e itaat mateng hula, “Ee! Anga naba e? Ana setang di iot nehe eola se, ini Eamulung. Anga na uhavede ba nu, Boma ang Emateng angu etatabi!” ");
INSERT INTO beu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ang muse ini vengsarentat lamal mana kanap, ila propinsi Galilea eabang ang miipi. ");
INSERT INTO beu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ini nehe Yahudi ehava hamulang angmi bale hela muse, Yesus Ana Simon bot Andrias ole ihava mi masot mida. Yakobus bot Yohanis ole di iamulung. ");
INSERT INTO beu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon idat jangu angu dilat tajoa tiang mana mi tia sehi. Base Yesus bot Egahing vala ang naung imampi hava mi mida muse, nehe vengbanang hula, “Memet angu ae dilat tajoa sehi.” ");
INSERT INTO beu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ang muse, Yesus mida memet ang euling, atang angu vengpina aing bakung amihing muse, edilang tajoa angu mona tila. Ang muse memet angu kaluar hela ing vengbalenta. ");
INSERT INTO beu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Vedba muse, nehe ba dila, bot setang iapang taang ang naung nehe iat Yesus ebele hoa, banang ot ing ening mona. ");
INSERT INTO beu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ang muse bendar nu enehe ang naung emangpi hoa hava eela angmi taing vengkumpul. ");
INSERT INTO beu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nehe na-nut edilang angu emangpi Yesus Ana ening mona. Bot nehe ba setang iapang taang ang naung Ana aterit metma iola. Ana bae setang ang naung ing vengkilang iot mateng niang, se ini Ateing iila. ");
INSERT INTO beu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Emikuaveng birkete sehise, Yesus Ana hava angumi tahit lamal hela. Ana ila mana taimang nu mi Lahatala oleve itat mateng. ");
INSERT INTO beu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon iimal tahi se, Yesus bae ue niang, ang muse ini ila Aing aalaping. ");
INSERT INTO beu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ini Aing harak muse, At mateng vengbanang hula, “Nimang, nehe toang ae Aaing aalaping sehi.” ");
INSERT INTO beu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aarunge Ana ihur ebalet hula, “Angu di aaung. Aarunge miaaung pi bendar aabeung taing vengjehi ang naung di mi ila hengi. Se Na hula Lahatala Ehur aaung-hama angu metma ing di iavomung-iapahang. Anguba Nekarajang.” ");
INSERT INTO beu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Seng ang muse, Ana bot lamal propinsi Galilea angu miiipi, Lahatala Ehur aaung-hama angu metma nehe avomung-apahang, ihava hamulang ang naung omimi. Bot setang di Ana aterit nehe ang naung iola. ");
INSERT INTO beu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uangu adana, nehe dilang hapeburang aing ening nu, Mutu Yesus Ebele hoa. Ana Yesus apang aadang mi iakuku muding senge Yesus Abanang hula, “Nimang e, Na ateing hula, Aaing ba malekang noang moling, aulange nedilang anga ana bae ue niang, senge nehe ekang nejajahi ening ekang. Ba Aana jali hengi.” ");
INSERT INTO beu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ang muse Yesus Ana omi metma nehe dilang hapeburang aing ening angu ejahi, Ana Atang taning metma aing pina senge at mateng hula, “Na vengjali! Aaungba aana mona!” ");
INSERT INTO beu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mibaroti se, nehe angu edilang hapeburang angu bae ue niang, muse ana mona. ");
INSERT INTO beu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus Ana nehe angu ot ila, bot at mateng evengani ening hula, ");
INSERT INTO beu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Venganit aaung-aaung! Aana mona tila, aarunge aana ekang nehe iiba at mateng ekang! Aana malekang boma Musa eparenta tura angu eamulung. Base aana ila aava metma agama ebuang vala ang naung itubing, e ini ateing hula aana etatabit mona tila, e jedung. Seng ang se aana malekang sadaka baning hoa metma Lahatala Enang, e nehe ateing hula aana etatabit mona tila.” ");
INSERT INTO beu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aarunge nehe angu kaluar hela muse, ana ila vengsarentat mana ang naung migoleng. Anguba nehe toang Yesus Aing aalaping hula Aing harak. Base Ana bendar mi bae Apang matubing jadi niang. Ana mana taimang aabang eola ba mi mihi, aarunge taang-taang mi nehe harut ebele hoa hula Aing harak hengi. ");
INSERT INTO beu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ved aaedeng lakal muse, Yesus bot bale ila Kapernaum mi. Ang muse ini vengbanang mana kanap hula Ana hoa hava mi tila. ");
INSERT INTO beu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Base nehe emangpi hoa Aing vengkumpul hava omimi taing eetek, hela hava eela di mi. Ang muse Yesus Ana Lahatala Eomi angu metma iavomung-iapahang. ");
INSERT INTO beu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana mateng sehise, nehe kuningkivil nu nehe buta aing tevang Yesus ebele ila. ");
INSERT INTO beu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Aarunge nehe toang angu ebele, inang buta angu bae at ila Yesus Apang aadang mi jadi niang. Nehe buta angu hava taang mida Yesus Ong adana angmi hava angu arahak. Hava angu baleleng muse, inang buta nehe kuningkivil angu ebihi emi alolang hela Yesus Apang aadang mi. ");
INSERT INTO beu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iomi etatabit Aing vengaanamang aulang angu Yesus uuling ateing muse, Ana nehe kuningkivil angu at mateng hula, “Noal! Eeahalang angu Na vengahi tila.” ");
INSERT INTO beu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aarunge angmi angu Yahudi eguru agama di aaedeng mihi sehi. Ini Yesus Emateng angu vengmee muse, iomi Ekakurang. ");
INSERT INTO beu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ang muse ini iomimi taaning hula, “Etatalang ba nehe angu mateng aulang angu? Lahatala ang ba bisa nehe eahalang vengahi. Aarunge nehe anga Emateng angu emenghula aing ba Lahatala edadenang. Ana Lahatala Ehura tila!” ");
INSERT INTO beu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aarunge Yesus iomi angu ateing iila. Ang muse Ana iat mateng hula, “Iini ekang vengiiomit aulang ekang! ");
INSERT INTO beu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Hur aaru anga Na metma iiat mateng. Taang ba mivila? Na bisa nehe anga at mateng hula, ꞌEeahalang angu vengahi tila.ꞌ Na bot bisa vengbanang hula, ꞌAaungba tahi! Eebihi angu tevang e ila.ꞌ Ba angase Na nehe anga ot tahit lamal aulange iini ateing hula, Naing anga ba Manusia Emamolo, turangmi Lahatala matubing iila angu, bot Nandi Nekavasa ue metma nehe eahalang vengahi.” Ang muse, Yesus Ana nehe kuningkivil angu at mateng hula, ");
INSERT INTO beu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Aana vengmee! Angase aana mona tila! Base tahit eebihi angu tevang e, aaungba ila.” ");
INSERT INTO beu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Vengmeet Yesus mateng aulang, mibaroti se nehe angu tahit ebihi angu tevang e lamal kaluar hela. Nehe emangpi ba angmi angu uuling ieng taang ateing bot mijonga, senge mateng hula, “Lahatala angu bae mura niang o! Na alang anga pi uhavede uuling ateing!” ");
INSERT INTO beu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ang muse, Yesus bot bale ila dano Galilea eadil angmi. Nehe toang hoa Aing harak, seng ang muse Lahatala Eomi angu Ana metma iavomung-iapahang. ");
INSERT INTO beu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nehe nu angmi angu Alfius oal, ene Lewi. Aing angu ekarajang ba bea mamedi metma Roma eparenta enang. Yesus angmi lamal sehise, Ana uuling Lewi ateing ang muse, Ana earut hula, “Ee! Ma, Namulung!” Lewi vengmeet Yesus earut aulang muse, ana tahit Amulung. ");
INSERT INTO beu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Seng ang muse, Yesus iimal Lewi ehava mi mihit naadang, Lewi eserang bea mamedi ang naung di imampi hama-hamat naadang. Nehe toang ba angmi angu iiba angu nehe Yahudi ang naung hula ing angu nehe jasi. Ing di ue iat naadang. Nehe toang ba mihit naadang angu, etoang angu iomi vengaariak hula Yesus Aing vengmee hengi. ");
INSERT INTO beu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nehe Farisi eguru agama di inang aaedeng ue. Ini uuling se, Yesus Ana nehe bea mamedi, bot nehe ba jasi-ahala ang naung iat mihit naadang muse, ini Egahing vala ang naung iadang taaning hula, “Etatalang ba iiGuru angu nehe ba bea mamedi, bot nehe jasi-ahala ang naung iat naadang angu?” ");
INSERT INTO beu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aarunge Yesus itaaning angu vengmee muse, Ana ibalet hula, “Nehe dila angu ba ana dokter aalaping, aarunge bae nehe ba mona angu niang. Na hoa angu nehe jasi-ahala angu ba ing vengbalenta, bae nehe ba ava rasat hula aing nehe aaung-hama bot eele balolu ang naung ibele hoa niang.” ");
INSERT INTO beu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nehe Yahudi eagama aabeung di nu ue, nehe iene vengbanang hula Farisi. Minu adana, nehe Farisi ang naung kanempel. Ini ateing se nehe ba Yohanis nehe Sasarani egahing vala ang naung di kanempel. Aarunge ini ateing se, nehe ba Yesus Egahing vala ang naung bae kanempel ing edadenang niang. Ang muse nehe Farisi enehe ang naung hoa Yesus Aing harak, senge Adang taaning hula, “Nimang. Ning kanempel sehi. Yohanis enehe ang naung di kanempel. Aarunge, Aaing Eegahing vala ang naung etatalang ba bae kanempel niang?” ");
INSERT INTO beu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aarunge Yesus ibalet hula, “Etabit iini ateing, nehe taingmedi-taingpina ehada ening se, nehe ba hoa ang naung bae kanempel niang, aarunge ini naadang iatou vengbarang. Mehal muring angu ue angmi ang se, ini malekang naadang hama-hama. ");
INSERT INTO beu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aarunge eningse, mehal muring angu nehe aabeung hoa adoit at ila se, eserang ang naung iomi etatabit dira, senge ini kanempel.” ");
INSERT INTO beu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ang muse Yesus bot kolil nu vengbanang hula, “Nehe bae nahiba metma kondo paher veng atabiling harota niang. Eningse pi vengbai se nahiba angu rupuk, kondo paher angu ening takahit miele. ");
INSERT INTO beu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aulang di nehe bae tua uhavede metma bolu puping mi niang. Eningse bolu angu takahi, tua angu halut osing. Base tua uhavede medi angu malekang metma bolu hiba ba mi.” Anguba Yesus vengbanang hula, Evomung-epahang uhavede angu ekang metma nehe Farisi ivomung-ipahang tura angu venggao ekang. ");
INSERT INTO beu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nehe Yahudi ang naung ived hamulang adana, Yesus lamal aara-gandum bir nu milakal. Ang muse Egahing vala ang naung aara-gandum eihi angu iiba aaturit medi, senge adang. ");
INSERT INTO beu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aarunge nehe Farisi ang naung uuling iateing muse, ini Yesus At mateng hula, “Etatalang ba Eegahing vala ang naung bae piagama elamal-etahi angu eamulung niang? Ini aara-gandum aaturi angu ved hamulang ba nehe bae karajang niang angu adana! Ini ekang ening aulang ekang!” ");
INSERT INTO beu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ana ibalet hula, “Etatalang ba iini bae boma Daud esarenta tura angu vengani niang? Uangu adana, boma Abiatar ba agama Yahudi ebuang vala ang naung ekapala. Boma Daud bot nehe ba eamulung ang naung imampi malapal etatabi muse, ini Lahatala Ehava hamulang angmi mida, roti ba nehe metma Lahatala Enang iila angu medit adang. Angu malekang agama ebuang vala ang naung ba inang kolang adang, aarunge nehe aabeung ekang adang ekang. Boma Daud iimal adang di nehe iiba bae ing ening ahala niang.” ");
INSERT INTO beu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ang muse Yesus bot iat mateng hula, “Iini ekang vengtajebing ekang. Lahatala ved hamulang ening angu aaung-hama ue omimi metma nehe emangpi adana. Aarunge Ana bae nehe emangpi ening angu metma ved hamulang elamal-etahi ang ba enang kolang adana niang. ");
INSERT INTO beu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Naing anga etatabit Manusia Emamolo ba turangmi Lahatala matubing iila angu. Base Naing anga ba bisa vengbanang hula, taang ba ved hamulang omimi vengkarajang bot taang ba bae vengkarajang niang.” ");
INSERT INTO beu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ang muse, Yesus bot bale ila Yahudi ehava hamulang mi. Angmi angu Ana uuling se nehe nu ue, atang dena angu aamina. ");
INSERT INTO beu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Angmi angu di, nehe aaedeng hula Yesus Evia aalaping Aing ening ahala. Base ini ieng metma Aing taang meat bae alolang niang aulange, ateing hula ved hamulang adana angu Ana bisa nehe angu aing ening mona e, niang. ");
INSERT INTO beu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ang muse Yesus Ana nehe atang dena aamina angu earut hula, “Ma niapang aadang anga mi tahi.” Yesus earut aulang muse, ana ma iapang aadang mi tahi. ");
INSERT INTO beu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ang muse Yesus Ana nehe ang naung emangpi iadang taaning hula, “Piagama elamal-etahi eamulung se, naba ba ved hamulang omimi pi ening? Pi aaung-hama ba ening e, jasi-ahala ba ening? Pi nehe ening mona e, nehe ameang?” Aarunge ini mang taimang. ");
INSERT INTO beu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nehe ang naung iagama elamal-etahi anguba eamulung mieele, aarunge ini bae iomi metma nehe ba atang dena aamina angu ejahi niang. Anguba Yesus Omi etatabit dira. Ang muse Ana omi alil Eng metma ing emangpi iuling, senge Ana nehe angu at mateng hula, “Aaungba, aatang angu horuk!” Nehe angu ana atang horuk muse, mibaroti se, atang angu mang mona. ");
INSERT INTO beu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ang muse, nehe Farisi ang naung hava hamulang angmi kaluar hela ila. Ini ila nehe ba Herodes eamulung ang naung imampi tominu, aulange Yesus Evia aalaping Ameang. ");
INSERT INTO beu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ved nu adana, Yesus bot Egahing vala ang naung imampi ila dano Galilea eadil mi. Aarunge naba ba Ana ening angu nehe toang vengmee tila, angu ebele aabang-aabang ba angmi angu enehe ang naung hoa Amulung. Ini propinsi Galilea, propinsi Yudea, bot propinsi Idumea mi hoa. Nehe eabeung ang naung bendar Yerusalem, bendar Sidon bot bendar Tirus mi hoa. Bot nehe iiba angu Yarden eved danang oa angmi hoa. Ing emangpi Yesus Aing aalaping hoa hula Aing harak. ");
INSERT INTO beu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Aarunge nehe toang amara angu ebele, Yesus Ana Egahing vala ang naung iot je nu vengharaka, senge Ana je ba taang nehe toang angu iat mateng, aulange ing emangpi vengmee, bot Ana bae bir apolil niang. ");
INSERT INTO beu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Turang mi Ana nehe dila toang ening mona tila. Angu ebele, angase nehe dila ba toang angu hoa taing eetek tasekat lamal malekang Aing dei hengi. ");
INSERT INTO beu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nehe ba setang iapang taang ang naung uuling ateing muse, ini bat hela iakuku muding Yesus Apang aadang mi. Ang muse ini moring hula, “Aaing anga etatabit Lahatala Oal!” ");
INSERT INTO beu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aarunge Ana ihapat etatabit hula, “Iini ekang nehe iiba iat mateng hula, Naing anga nuba ekang!” ");
INSERT INTO beu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ang muse Yesus Ana dol nu taang mida. Nehe aaedeng ba Omi vengba angu Ana iarut Ebele hoa. ");
INSERT INTO beu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ang muse Ana inang arinu belta aalu vengtalail. Ana iat mateng hula, “Na iing vengtalail e iini Namulung. Na iing vengtalail aulange iini ila Lahatala Evomung-epahang angu metma nehe toang emangpi vengimaring. ");
INSERT INTO beu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bot Nekavasa angu Na metma ma iinang senge, nehe ba setang iapang taang ang naung iini setang angu aterit iola.” ");
INSERT INTO beu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Nehe arinu belta aalu angu iene alang: Simon (ba Yesus ene maveng Petrus), Yakobus, Yohanis, (Yakobus bot ekaku Yohanis oleve angu, Sabadeus oal. Oleve Yesus iene maveng ꞌBoanergesꞌ, evengbanang se, ꞌemenghula burang dumung edadenangꞌ.) Andrias, Pelipus, Bertelemius, Mateos, Tomas, Yakobus (ba Alpius oal angu), Tadius, Simon (ba partei Selot eamulung angu), bot Yudas Iskariot (aing ba eningse Yesus Evia aalaping abaang angu). ");
INSERT INTO beu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ang muse, Yesus bot Egahing vala ang naung dol angu taang bale hela muse, ini hava nu mi mida. Aarunge nehe toang rae bot hoa Aing vengkumpul, anguba Yesus iimal bae naadang jadi niang. ");
INSERT INTO beu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ateing aulang muse, nehe nu mateng hula, “Iini Yesus euling hengi. Ana Apang ahala tila.” Yesus Ehava omi enehe ang naung vengmee se nehe Aing vengbanang aulang muse, ini hoa hula Aing medit At ila. ");
INSERT INTO beu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Uangu adana, guru agama ba Yerusalem mi ang naung hoa, senge nehe angmi ang naung iat mateng hula, “Ee! Iini ekang Yesus angu Eamulung ekang. Setang enehe eele ba nehe earut hula Balsebul anguba apang taang, bot kavasa metma ma Enang ba Ana setang di ateri angu.” ");
INSERT INTO beu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus vengmeet ini mateng aulang muse, Ana ing emangpi iaru e, iat mateng hula, “Bae Nenomi adana niang! Tatalange, setang enehe eele angu ana ava ateri! ");
INSERT INTO beu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aabang nu omimi enehe ang naung itat tota bot iomi teahalang se, tatalange aabang omi angu tening bot aabang angu kilang eaing sehi! ");
INSERT INTO beu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bot hava nu omimi enehe ang naung iomi teahalang se, tatalange ihava omi angu tening bot hava omi angu kilang eaing sehi! ");
INSERT INTO beu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Setang ang naung di aulang, nu omi metma nu ealalil se, ini malekang tarae-teapahing base ini tibarakang-temarai bot bae taing harak niang! ");
INSERT INTO beu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nehe hula hoa nehe daeri nu ehava mi na taavi se, ana malekang nehe daeri angu aing partat ematura, senge ana nehe epasaka angu taavi. ");
INSERT INTO beu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Base Na iiat mateng minu: Lahatala Ana vengharakat nehe eahalang vengahi. Bot nehe iiba hura mananti bot jasi-ahala ening metma nehe aabeung adana di, Lahatala kilang vengharakat iahalang aulang angu vengahi. ");
INSERT INTO beu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aarunge nehe ba Lahatala ERoh hamulang ehura emananti angu, aing eahalang angu por venghola di, Lahatala bae vengahi niang!” ");
INSERT INTO beu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ini Aing vengbanang hula, “Nehe angu setang apang taang iila!” Angu ebele Yesus vengbanang aulang. ");
INSERT INTO beu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ang muse, Yesus Iva bot Ekaku ang naung, hoa hava angumi hula Aing harak. Angmo mi ini via eela ba mi tahi e nehe ot Earu. ");
INSERT INTO beu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yesus mihit nehe toang angu iavomung-iapahang sehise, nehe hoa At mateng hula, “Nimang! Iiva bot Eekaku ang naung ae via eela mi Aading sehi. Ini hula Aaing harak.” ");
INSERT INTO beu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aarunge Yesus ibalet hula, “Niva bot Nekaku mamolo angu, nuba?” ");
INSERT INTO beu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ang muse nehe toang ba mihit Aing venggoleng angu Ana iuling, senge iat mateng hula, “Iing emangpi anga ba Niva bot Nekaku Neserang emamolo. ");
INSERT INTO beu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nehe ba Lahatala Eomi angu eamulung, aing angu ba, etatabit Nekaku bot Neserang.” ");
INSERT INTO beu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ved nu adana, Yesus bot ila dano Galilea mi. Ang muse nehe toang rae hoa Aing vengkumpul. Ana mida je nu angmi teding angu taang mihi e, nehe ang naung iavomung-iapahang. Nehe ba aadang taang ang naung emangpi Aing venghele. ");
INSERT INTO beu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ang muse Ana iavomung-iapahang kolil mi mateng toang rae vengbanang hula, ");
INSERT INTO beu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Iini vengmeet aaung-aaung! Nehe nu ana ila ebir mi nabing varehak. ");
INSERT INTO beu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nabing ba ana varehak angu, iiba via mi baa. Ang muse dung hoa tapurut adang miosing. ");
INSERT INTO beu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iiba angu meke var mamaung mi baa. Aarunge meke kabing dena angu ebele, nabing angu luung niang se, hupa, ");
INSERT INTO beu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","aarunge ved eng da tutung muse, nabing hupa ang naung marotat aaminat miosing, se ebariking bae meke omimi hela niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nabing iiba angu namaang omimi baa. Base namaang angu nabing hupa ang naung hangkit ening aamina, angu ebele eiihi vengniang. ");
INSERT INTO beu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aarunge nabing iiba angu meke aabua omimi baa. Nabing angu bilang lohung ahembal base eiihi veng. Eiihi veng angu iiba mi aritue, iiba mi aritaling, bot iiba angu mi ratunu. ");
INSERT INTO beu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Base nehe ba aver veng angu, venghelet aaung-aaung metma iiomimi!” ");
INSERT INTO beu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ved nu adana Yesus enangkolang, Egahing vala arinu belta aalu angu, bot nehe aaedeng aabeung ba Evomung-epahang vengmee tila angu, hoa Yesus Aing harak. Ini Abanang Ot kolil emateng tarang angu metma veng iat mateng. ");
INSERT INTO beu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aarunge Yesus ibalet hula, “Iini hula Lahatala Eomi angu etatabit ateing hengi, angu ebele kolil angu emateng tarang Na metma veng iiat mateng. Aarunge nehe aabeung se, kolil ang ba Na metma ing aajar. ");
INSERT INTO beu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nehe aabeung ang naung ilamal-itahi angu emenghula turangmi Lahatala Ehur vala hurak iila angu edadenang. Vengbanang hula, ꞌIni uuling ateing iila, aarunge emenghula ini bae uuling ateing niang angu edadenang. Ini vengmee tila, aarunge ini bae metma iomimi taloul niang. Misavaka ini Lahatala angu iomi metma vengaanamang, e iahalang ang naung Lahatala vengahi.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ang muse, kolil emateng tarang angu Yesus metma veng iat mateng hula, “Ee! Iini bae kolil anga emateng tarang ateing niang se, tatalang e kolil aabeung ang naung di emateng tarang angu iini ateing? ");
INSERT INTO beu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Base emateng tarang angu alang: Nehe ba nabing varehak angu, emenghula nehe ba Lahatala Ehur aaung-hama vengmaring angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nabing ba via mi baa senge dung hoa adang miosing angu, emenghula nehe ba Lahatala Ehur vengmee angu edadenang. Aarunge bae luung niang se setang enehe eele angu hoa, hur aaung-hama angu omimi medi angu. ");
INSERT INTO beu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nabing ba meke var mamaung omimi baa angu emenghula nehe ba Lahatala Ehur vengmee bot metma iomimi angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aarunge Lahatala Ehur angu ini bae iomi metma vengaanamang niang, angu ebele ba bae iomimi jehit luung niang. Base nehe iajajasing bot ihura imananti Lahatala Ehur angu ebele se, ini Lahatala Ehur angu bia bot bae eamulung niang iila. ");
INSERT INTO beu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bot nabing ba namaang omimi baa angu emenghula, nehe ba Lahatala Ehur ang vengmee tila angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Aarunge ini iapang metma na aabeung tamaa tengge omimi angu ba adana. Base tamaa tengge angu Lahatala Ehur ba ue iomimi angu asekat metma iola, base aaung-hama angu bae metma ioa niang. ");
INSERT INTO beu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aarunge nabing ba meke aabua omimi baa angu emenghula nehe ba Lahatala Ehur angu vengmeet aaung-aaung bot metma iomimi senge Lahatala Eomi anguba eamulung angu edadenang. Base ini aaung-hama anguba ening emenghula nabing ba bilang eiihi veng angu edadenang. Eiihi veng angu iiba mi aritue, iiba mi aritaling, bot iiba angu mi ratunu.” ");
INSERT INTO beu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus jedung je taang se Ana bot kolil nu taang metma iat mateng vengbanang hula, “Iini ateing e, niang? Nehe pelita tubing se ota metma vengtering bot metma tiang mana iivang amihing e, niang? Hula amihing aulang se, ana bae jara niang. Nehe malekang metma mana atela ba mi amihing e ana jara. ");
INSERT INTO beu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Base naba ba nehe amaang angu, eningse ana ava apaleteng. Bot naba ba nehe bae vede anga ateing niang angu eningse nehe uuling ateing. ");
INSERT INTO beu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Base nehe ba aver veng angu, venghelet aaung-aaung metma iiomimi!” ");
INSERT INTO beu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Seng ang muse Ana bot taang mateng hula, “Veng iiomit aaung-aaung! Iilamal-iitahi ba iini ening metma nehe aabeung adana angu, eningse nehe di bale ening aulang metma iiadana. Bot eningse Lahatala di ening metma iiadana angu mitamadi. ");
INSERT INTO beu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nehe ba Lahatala Eomi angu etatabit aalaping angu eningse ana taang omi veng, base hur aaung-hama angu ana ateing. Aarunge nehe ba Lahatala Eomi veng ea angu, eningse ana mang taang bodo kamuke.” ");
INSERT INTO beu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ang muse Yesus bot taang mateng hula, “Nehe ba Lahatala Eabang omimi aabeta angu taang maveng emenghula nabing ba nehe metma ebir mi varehak angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nehe angu ana bale ila, tia tahi, omi metma naababeung nabing angu ana bae vengani niang iila. Aarunge nabing angu hupat bilang taang eelet maveng. ");
INSERT INTO beu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nabing angu meke aabua mi base ana atang paul, ebuma veng, bot eiihi di veng. ");
INSERT INTO beu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Base aara taata tila se bir manaing angu hoa senge talail. Nehe ba Lahatala Eabang omimi aabeta angu di aulang. Emangpi angu Lahatala ba ening.” ");
INSERT INTO beu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ang muse, Yesus bot hula, “Na kolil nu vengbanang maveng alang: Nehe ba Lahatala Eabang omimi aabeta angu emenghula naba edadenang. Halomang ang se ing kabing dena kolang, aarunge bae luung niang se ini tatoang-tatoang. ");
INSERT INTO beu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Angu emenghula nabing kokal kiki nu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pi nabing angu muding iila se, ana bilang aing metma te eele ening. Base dung ang naung hoa ekumbu omi angmi eiiri ening.” ");
INSERT INTO beu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Angu Yesus Evomung-epahang elamal-etahi metma kolil mi iat mateng iomi angu eamulung. ");
INSERT INTO beu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nehe ang naung iavomung-iapahang se, Ana kolil mi mateng aulang. Aarunge metma Egahing vala ang naung iadana se, kolil angu emateng tarang di emangpi Ana metma iat mateng. ");
INSERT INTO beu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Vedba di, Yesus jedung ue je angu taang mihi. Ang muse Egahing vala ang naung Ana iajalit hula, “Ma e pi aalarit dano edenaveng angmo mi va.” ");
INSERT INTO beu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ang muse ini Yesus at hama-hamat je taang mida. Nehe toang rae angu ini iadut ue angmi, seng ang muse ini aalari. Aarunge nehe iiba angu je aabeung taang iamulung. ");
INSERT INTO beu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Uangu adana Yesus Ana banole metma Ong emea ue je ealap mi tiat udu sehi. Bae luung niang se eenar eele boning hoa. Uumba eele jar metma ije angu mit hula aaving. Ang muse Egahing vala ang naung iuangmarit etatabi. Ang muse ini hela amehal vengbanang hula, “Nimang! Tahi hengi! Pi hula hola ba ae anga! Aarunge Aana bae nioang moling niang angu!” ");
INSERT INTO beu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Vengmeet aulang muse, Yesus tahit eenar eele angu ehapat hula, “Taimang!” Seng ang muse Ana bot uumba eele angu di ehapat hula, “Aaungba Tening!” Ana mateng aulang muse, eenar eele angu bae ue niang bot uumba eele angu tening. ");
INSERT INTO beu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ang muse Yesus Ana Egahing vala ang naung ihapat vengbanang hula, “Etatalang ba iini iiuangmarit aulang angu? Iini bae iiomi metma Naing vengaanamang niang, ka?” ");
INSERT INTO beu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ing emangpi iuangmari bot mijongat etatabi, e itat mateng hula, “Aing anga nuba ba Ana mateng se eenar bot uumba di Eamulung?” ");
INSERT INTO beu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus bot Egahing vala ang naung ila dano Galilea edenaveng angmi. Bir angu ene Gerasa. ");
INSERT INTO beu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Ang mi angu, nehe mehal nu setang apang taang ana vengbuning. Ana baring aabang ba mi aabeta. Kua-jala ana edurat basiar lamal aabu goleng moring bae alolang niang. Bot ana var metma eboa angu buet ening aibat. Aarunge ana etatabit daeri. Rante oola ba pake di nehe iiba bae aing partat jadi niang. Nehe ia atang partat bae alolang niang, aarunge ana asinga bot langi oola ia mi angu ana abora. Ana etatabit daeri angu ebele nehe nu bae aing tahang jadi niang. Yesus bot Egahing vala ang naung imampi je taang hela aadang taata mi tahi muse, nehe buning angu ola mi uuling iateing. Ang muse ana bihit Yesus apang aadang mi iakuku muding. ");
INSERT INTO beu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Nehe angu apang ang ateing aulang muse, Yesus mateng hula, “He! Setang jasi! Aana nehe anga eola!” Ang muse nehe angu moring etatabit hula, “He! Aana naba ba ening metma na dana? Na ateing Aaing ba Yesus, Lahatala ba mikavasa angu Oal. Na banang e, Aana ekang na jasing ekang.” ");
INSERT INTO beu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ang muse Yesus adang taaning hula, “Eene nuba?” Nehe angu ebalet hula, “Naing nene Legion, se ning anga toang amarat ribu iising alehil emenghula tentara ibatalyon angu edadenang.” ");
INSERT INTO beu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ang muse setang ang naung nehe angu ot Yesus abanang e, iot ekang mana angu eola ekang. ");
INSERT INTO beu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mana angu bae eola niang nehe ue be jaga. Be etoang angu oma ribu aaru ini ue dol ehahama mi lamal naadang sehi. ");
INSERT INTO beu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ang muse setang ang naung Yesus abanang hula, “Ning gahing e, ni ila be ang naung ing maso.” ");
INSERT INTO beu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Vengmeet ibanang aulang muse Yesus vengjali. Ang muse setang ang naung bihit nehe angu eola e, ila be ang naung ing maso. Ang muse be ang naung bihit tibarakang-temarait ila bir haduring mi hela jar omimi aaminat miosing. ");
INSERT INTO beu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ateing aulang muse nehe ba be jajaga ang naung iuangmarit etatabi. Ang muse ini bihit ila vengbanang aabang angmi angu miiipi. Ang muse nehe toang rae hoa euling. ");
INSERT INTO beu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ini hoa Yesus Aing harak bot ini uuling se, nehe ba setang apang taang ang di ue mihi sehi. Ana mona tila bot ana pakiang di pake tila. Ateing aulang muse ing emangpi iuangmarit etatabi, se ini ateing hula nuba ba setang angu aterit nehe angu eola. Se aing angu etatabit nehe nu bae at hama niang. ");
INSERT INTO beu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ang muse ing emangpi ila vengmaring mana kanap hula, ini uuling ieng taang ateing se, nehe buning angu mona tila bot be ang naung aaminat miosing. ");
INSERT INTO beu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ang muse aabang angmi angu enehe ang naung hoa Yesus abanang e mana angu eola. ");
INSERT INTO beu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus hula je taang mida se, nehe ba vede setang apang taang angu hoa abanang andi Amulung. ");
INSERT INTO beu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aarunge Yesus eea. Ana vengbanang hula, “Miaaung aana ila naba ba Lahatala ening ma enang angu metma eenehe ang naung iat mateng. Bot hula Lahatala etatabit omi metma eejahi.” ");
INSERT INTO beu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ang muse nehe angu ila mana nu ebendar arinu ini biasat vengbanang hula, ꞌDekapolisꞌ. Angu migoleng naba ba Yesus ening ma enang angu ana vengsarenta. Nehe toang rae ba esarenta ang vengmee angu ini mijongat etatabi e hula, “Etabi o!” ");
INSERT INTO beu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ang muse Yesus iimal aalarit ila dano edenaveng angmi. Ini je taang hela muse, nehe toang hoa Aing vengkumpul. ");
INSERT INTO beu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Angmi angu nehe nu ene Yairus. Aing angu aabang angmi nehe Yahudi ehava hamulang ekapala. Uuling Yesus ateing muse ana apang aadang mi iakuku muding ");
INSERT INTO beu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","e, banang hula, “Nimang ee! Noal jangu kaneng nu etung arinu belta aalu moe dilat aamina heng. Aana ila aing ening mona hengi.” ");
INSERT INTO beu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ang muse Yesus eamulung Yairus ehava mi ila. Aarunge ini lamal muse nehe toang amulung e, asekat tene bajaul. ");
INSERT INTO beu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nehe toang angu ehahama mi, nehe jangu nu euuru hoa eseng vengniang, tung arinu belta aalu tila. ");
INSERT INTO beu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Epasaka emangpi ana metma ilavali ang naung ing sevat miosing. Aarunge iiba bae aing ening mona niang e, edilang angu mang taang maveng. ");
INSERT INTO beu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Nehe jangu angu Yesus Esarenta vengmee toang iila angu ebele ana nehe toang angu iasekat ila Yesus Amota oa angmi. Ana omimi vengpikir hula, “Ekondo ang ba dei di se, na malekang mona.” Ana Yesus Ekondo angu dei muse, mibaroti se edilang ve horung angu bae ue niang iila. Rasa se ana etatabit mona tila. ");
INSERT INTO beu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Uangu veng Yesus Ava rasa se, Edaeri omimi angu ue kaluar hela. Ana bale tahit nehe toang angu iuling, senge Ana iadang taaning hula, “Nuba ba Nekondo dei angu?” ");
INSERT INTO beu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Egahing vala ang naung Ebalet hula, “Nimang! Eena ateing hengi. Nehe toang alang anga, senge Aana taaning hula, ꞌNuba ba Nekondo ang dei angu?ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aarunge Yesus iuling bae alolang niang e ateing hula nuba ba vede Aing dei angu. ");
INSERT INTO beu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vengmeet Yesus taaning aulang muse nehe jangu angu uangmarit etatabi. Ang muse ana Yesus apang aadang mi iakuku muding bot mangakut vengbanang hula, “Nimang! Naing ba Eekondo ang dei angu.” ");
INSERT INTO beu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ang muse Yesus ebalet vengbanang hula, “Aana etatabit oomi metma Naing vengaanamang ebele, aana mona tila, base aaungba tahit aanamang ila.” ");
INSERT INTO beu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus mateng sehise nehe nu Yairus ehava mi hoa vengbanang hula, “Ajee! Oal jangu kaneng benang aamina tila. Base ekang Nimang Guru Aing ening susa ekang. Aaungba ekang Ot ila ekang.” ");
INSERT INTO beu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aarunge Yesus bae nehe angu emateng ang venghele niang. Ana Yairus at mateng hula, “Aaing ekang uuangmari ekang. Oomi metma Lahatala ang ba vengaanamang.” ");
INSERT INTO beu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ang muse Yesus Ana lamal, Egahing vala aabeung ang naung Ana iot ekang amulung ekang. Aarunge Petrus, Yakobus bot ekaku Yohanis Ana iot amulung, ang muse ini lamal. ");
INSERT INTO beu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ila Yairus ehava mi, ini uuling se nehe toang rae angu iiba ue balenta sehi, bot vengmee se iiba baut nataanang. ");
INSERT INTO beu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus mida hava omimi, senge Ana taaning hula, “Etatalang ba iini etatabit oorang bot baut nataanang alang anga? Val anga bae aamina niang. Ana mang tiat udu.” ");
INSERT INTO beu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ini vengmeet Yesus Emateng aulang ebele, ing emangpi Aing vengpalelat ejajahi ening. Ang muse Ana iot kaluar hela. Val ang imang, iva bot Egahing vala inang tue angu Ana iaru, e ini val angu ekamar mi maso. ");
INSERT INTO beu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ang muse Yesus Ana val angu atang vengpina senge Ana Aram ehur mi at mateng hula, “Talita kum!” Evengbanang hula, “Noal! Aaungba tahi!” ");
INSERT INTO beu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Mibaroti se val angu tahit lamal. Ang muse Yesus Ana iva aing gahing hula, “Aaungba val anga mod ma enang ana adang.” Naba ba jadi angu ateing muse, nehe emangpi mijongat etatabi. Aarunge Yesus etatabit ihapat vengbanang hula, “Iini ekang nehe iiba at mateng hula, Na aing ening bale aabeta tila ekang.” ");
INSERT INTO beu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ang muse, Yesus bot Egahing vala ang naung imampi bale ila Eabang Nasaret mi tila. ");
INSERT INTO beu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Uangu veng angu nehe Yahudi ang naung ived sambajang, Yesus masot mida nehe Yahudi ang naung ihava hamulang mi iavomung-iapahang. Ved angu adana nehe toang hoa sambajang. Aulang ini Emateng ang vengmee muse, ini mijonga he vengbanang hula, “Hur alang anga taang mi ba nehe ma enang ba anga? Andi Ekavasa veng! Etatalang ba Ana bisa aulang e? ");
INSERT INTO beu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aing angu mang teveng molang ba ue. Iva Maria angu pi ateing, bot Ekaku naung ba Yakobus, Yoses, Yudas bot Simon. Andi Ekaku jangu inang aaedeng ue. Ping emangpi aabang nu mi aabeta!” Angu ebele ing emangpi iomi Ealalil bot ini bae Aing venghele niang. ");
INSERT INTO beu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ang muse Yesus iat mateng hula, “Ang etabi! Lahatala Ehur vala mana aabeung mi hoa ang ba nehe vengaariak aing aada, aarunge eabang mamolo mi se nehe bae vengaariak aing aada niang.” ");
INSERT INTO beu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Aarunge nehe ang naung iomi etatabit aanamang, anguba ini bae Yesus Eetabit vengbanang niang. Angu ebele Ana mijonga, bot Ana bae Ekavasa angmi matubing niang. Ana mang nehe dila nu aaru kolang ing ening mona. ");
INSERT INTO beu_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Ang muse, Yesus Ana aabang taing vengjehi ang naung mi ila, Lahatala Ehur hamulang angu metma nehe veng iavomung-iapahang. ");
INSERT INTO beu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Egahing vala arinu belta aalu angu Ana iaru, sengila ba ing gahing nehe aaru taing veng lamal Lahatala Ehur aaung-hama angu vengmaring. Ana Ekavasa angu ma inang, aulange ini setang di ateri. ");
INSERT INTO beu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ana iat mateng hula, “Iini ekang na toang baning lamal ekang. Mod di ekang baning ekang, seng, bot taas. Aarunge doba, sendal bot kondo nu kolang baning. ");
INSERT INTO beu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nehe iing tarimat hava nu mi se, iini malekang angmi mihi, ila jol iini bale angu venghili. ");
INSERT INTO beu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aarunge ila mana nu mi, senge nehe angmi ang naung bae iing tarima niang, bot bae iing venghele niang se, aaungba tahit lamal. Senge iat mateng vengbanang hula, ꞌIini bae ning venghele niang, base etamadi angu iing ba tevang!ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Seng ang muse, ini ila Lahatala Ehur aaung-hama angu vengmaring. Ini nehe toang ang naung iavomung-iapahang iot iava vengbaroti, malekang Lahatala Eomi ang ba eamulung. ");
INSERT INTO beu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ini setang di ateri, bot ini iipil metma nehe ba dila ang naung ing bara bot Lahatala veng Abanang ing ening mona. ");
INSERT INTO beu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Uangu adana, taang-taang mi angu nehe Yesus ateing iila. Ekavasa ba nehe vengsarenta angu raja Herodes di vengmee tila. Nehe iiba hula, “Yohanis nehe Sasarani angu bale aabeta Yesus Omi mi! Angu ebele, Ana nananiang ba emenghula tanda herang edadenang ang naung emangpi ening.” ");
INSERT INTO beu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aarunge nehe aabeung ang naung hula, “Niang! Anga Elia ba bale aabetat Omi mi. Ee niang, Lahatala Ehur vala aabeung ba tura ang naung.” ");
INSERT INTO beu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Raja Herodes vengmee se ini Yesus aing veng mateng aulang muse, ana ibalet hula, “Anga oma Yohanis nehe Sasarani ba tura na nehe gahing ong patait medi angu. Angase ana bale aabeta tila!” ");
INSERT INTO beu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Raja Herodes gahing aulang, se ana etatabit omi metma Yohanis ealalil. Esarenta angu alang: raja Herodes ana ekaku Filipus ejangu ene Herodias angu aing medit ejangu ening. Se Filipus bot Herodias oleve taingbia jedung. Angu ebele Yohanis ehapat bae alolang niang hula, “Nimang raja ekang eekaku ejangu angu aing medi ekang. Se angu pi hada Yahudi ang lakal iila!” Aarunge Herodes mang aing medi. Seng muse ana nehe gahing ila Yohanis adoit at ila bui mi. ");
INSERT INTO beu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yohanis ehapat bae alolang niang aulang ang ba nehe jangu angu omi metma ealalil hula, malekang ameang hengi. Aarunge ejol mi jedung se, Herodes aing metma bui mi. ");
INSERT INTO beu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Bot tentara ang naung ana iot aing jagat aaung-aaung. Herodes ana Yohanis aing veng ong avavili. Ana ateing hula, Lahatala ba aing gahing. Bot aing angu nehe aaung. Herodes ana jalit Yohanis emateng ang venghele. Aarunge mi na-nu se ana emateng angu venghele se omi bae sanang niang. ");
INSERT INTO beu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ang muse ved nu adana, memet Herodias ana jol harak omi alil angu ebale. Ved angu veng, raja Herodes etung mi. Ini nehe eele ang naung imaring iot hoa etung mi angu venglebal. Nehe ba hoa angu, parenta enehe eele, tentara enehe eele, bot Galilea ehada eboma ang naung. ");
INSERT INTO beu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lebal ehahama mi se, memet Herodias oal jangu kaneng angu mida tojang. Etojang angu etatabit aalus, angu ba Herodes bot nehe ba hoa ang naung ing ening sanang. Ang muse Herodes ana val jangu angu earut adang taaning hula, “Aana naba ba banang se, mang vengbanang! Aulange na metma ma enang. ");
INSERT INTO beu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne parenta ang ba aana banang paul baang aaru di, na ma enang. Na Lahatala Ene omimi metma aat palai.” ");
INSERT INTO beu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ang muse val jangu angu ila iva adang taaning hula, “Niva! Aanake hula naba aaung-aaung ba na nimang veng abanang hengi?” Ang muse iva ebalet hula, “Noal! Aaungba aana ila Yohanis ong anguba banang.” ");
INSERT INTO beu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Seng muse, val jangu angu hoa Herodes harak vengbanang hula, “Nimang! Na banang Yohanis ong angu metma dulang mi, vede anga ba baning hoa ma nenang!” ");
INSERT INTO beu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes vengmeet aulang muse, omi iipi sehi. Aarunge epalai angu ana bae bale abingit jadi niang, se nehe emangpi vengmee tila angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ang muse, ana tentara enehe eele nu gahing ila bui mi Yohanis ong angu patait medi. ");
INSERT INTO beu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Seng muse Yohanis ong angu ini metma dulang mi baning hoa val jangu angu enang. Ana dulang angu medi muse ana abaning ila iva enang. ");
INSERT INTO beu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nehe ba Yohanis eamulung ang naung vengmeet hula ini Yohanis ong angu medit baning ila tila muse, ini hoa ebaring angu medi, baning ila taloul. Yohanis aamina esarenta angu aulang. ");
INSERT INTO beu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jol nu adana, Yesus Egahing vala ba Ana ing gahing angu, emangpi bale hoa Aing harak. Emangpi ba ini ening iila, bot naba ba ini metma nehe emaring angu ini metma At mateng. ");
INSERT INTO beu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aarunge angu adana, nehe toang rae ila-hoa Yesus Aing aalaping. Angu ba Aing bot Egahing vala ang naung imampi bae naadang jadi niang. Ang muse Yesus Ana Egahing vala ang naung iat mateng hula, “Ma pi ila mana taimang aalaping, e pi miaarit kabing dena hengi.” ");
INSERT INTO beu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Angu ebele, ini je taang mida, he ila mana taimang aabang eola aalaping. ");
INSERT INTO beu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aarunge nehe toang ang naung uuling se Yesus iimal ije angu ue aadang amulung. Ang muse ini aadang taang lamal, ini iturat ila mana ba Yesus hula mi ila angu mi. ");
INSERT INTO beu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus je taang hela muse, Ana ateing se nehe toang rae ading sehi. Ang muse Omi etatabit ijahi, se ing emangpi bae ateing niang hula ening tatalang, emenghula jumba val bae eterang vala veng niang angu edadenang. Ang muse Ana Lahatala Eomi angu metma iavomung-iapahang ");
INSERT INTO beu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","ila ved veng ba. Ang muse Egahing vala ang naung At mateng hula, “Nimang! Miaaung Aana nehe anga naung iot ila aabang papeang ang naung mi mod aalaping, se vedba tila bot angami anga mod niang ba ae.” ");
INSERT INTO beu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aarunge Yesus iat mateng hula, “Ejehi! Iing ba malekang iahi.” Ang muse ini bale Yesus adang taaning hula, “Aah! Nehe toang alang anga ni iahi se, ni malekang seng toang emenghula nehe egaji mitung nu edadenang metma mod beli hengi. Taang mi e seng toang aulang angu ni harak?” ");
INSERT INTO beu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus ihur ebalet hula, “Iini ila ateing hengi, nuba ba mod baning.” Ini ila ateing muse, ini bale hoa vengbanang hula, “Angami roti iipi iising, bot aab aaru kolang ba ae.” ");
INSERT INTO beu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ang muse, nehe toang angu emangpi Yesus iot taing vengkumpul dadi taang mihi. ");
INSERT INTO beu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ini taing veng mihi iiba ratu nanu, bot iiba ari aaising. ");
INSERT INTO beu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ang muse roti iipi iising bot aab aaru angu Yesus Ana medi. Ana apang ohit burang euling banang tarima kasi metma Lahatala enang. Seng muse Ana roti angu ening atatara, taning metma Egahing vala ang naung inang, e ini metma nehe toang angu veng paul. Aab aaru angu di Ana paul aulang metma ma inang. ");
INSERT INTO beu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ang muse ing emangpi adang iatou vengbarang. ");
INSERT INTO beu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Naadang seng muse, Egahing vala ang naung mod ealehil angu akumpul se, ota arinu belta aalu aaving. ");
INSERT INTO beu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nehe emangpi oma ribu iising. Angu nehe mehal ba naadang angu. Nehe jangu bot kakaneng ang naung veng taanang jedung. ");
INSERT INTO beu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Seng ang muse, Yesus Egahing vala arinu belta aalu angu iot je taang mida, iturat Betsaida aabang dano edenaveng angmi ila. Aarunge Aing jedung angmi mihi, e Ana nehe toang angu iot ila. ");
INSERT INTO beu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ing emangpi ila tila muse, Ana dol nu taang mida Lahatala Oleve Itat mateng. ");
INSERT INTO beu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Birkua muse, Yesus bale hela. Ana uuling se Egahing vala ang naung ije angu ila dano ehahama mi tila. Aarunge ini beat at aamina at aabeta sehi, se ini eenar eele sogo angu ebele. Jala papeang muse, Yesus iamulung ila. Aarunge Ana mang jar taang lamal. Ana hula ije angu milakal muse, ini uuling Ateing. Ini mijongat etatabi. Ang muse ini itadang taaning hula, “He! Angu naba, e? Nehe oramana e, naba?” Aarunge Yesus iat mateng hula, “Ee! Ekang iiuangmari ekang! Anga Naing.” ");
INSERT INTO beu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesus mida je taang muse, eenar eele angu mang tening. Egahing vala ang naung emangpi mijongat etatabi. ");
INSERT INTO beu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yesus Ekavasa ba Ana metma nehe ribu iising alehil iahi angu, ini uuling ateing iila, aarunge ini bae Ekavasa angu iomi metma vengaanamang aaung jedung. ");
INSERT INTO beu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ini ila dano edenaveng angmi muse, ini bendar Genesaret eoolol angmi teding. ");
INSERT INTO beu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ini je taang hela muse, nehe toang uuling iateing. Ang muse ini moring vengbanang hula, “Oo! Yesus hoa iila oo!” ");
INSERT INTO beu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Ing emangpi bihit ila itaat mateng mana kanap, ang muse ing emangpi nehe dila ang naung tevang hoa. Ini mang vengmeet hula Yesus ue mana nu mi ang se, ini hama-hamat nehe dila ang naung iat hoa bir babira mi iatiang. Ini veng iomit hula, “Nehe dila ang naung Yesus Ekondo tupa ang ba dei dise, ini malekang mona.” Deit aulang muse ini mona tila. ");
INSERT INTO beu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nehe Farisi ang naung bot guru agama inang aaedeng Yerusalem mi hoa Yesus Aing harak. ");
INSERT INTO beu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Nehe Farisi ang naung Yahudi ehada angu pinat aanamang. Base nehe hula naadang se, malekang iatang hiat ihada angu eamulung. Aulang di, ong mi hoa se, ini malekang vela hengi. Angu ebele idampur enaosing: Aala, piring, galas, ceret, emangpi malekang hiat hada angu eamulung, senge mi naadang. Nehe Yahudi aabeung ang naung hada angu bae eamulung niang se, nehe Farisi ang naung alil. Angu ebele, Yesus Egahing vala ang naung naadang di bae iatang hiat ihada angu eamulung niang, uuling ateing muse nehe Farisi ang naung alil. Ang muse ini hoa Yesus Aing ening ahalat hula, “Etatalang ba Aaing Eegahing vala ang naung naadang jedung se, bae iatang hia niang angu? Angu ini nidat-nimang ihada angu bae eamulung niang iila!” ");
INSERT INTO beu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Aarunge Yesus ibalet hula, “Iing anga, nehe mateng aabeung se, iini vengkarajang aabeung! Turang mi boma Yesaya Lahatala Ehur angu hurak vengbanang hula, ꞌNehe anga naung Naing tajaning, ibar tupa ba taang, aarunge bae iomimi da niang. Ini ening aulang di, parasumang. Ini Nenomi angu bae eamulung niang, aarunge ini nehe ang naung iomi ang ba eamulung.ꞌ Iing di hama sehit aulang. ");
INSERT INTO beu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Iini Lahatala Eomi angu at hela mea, bae eamulung niang, e iini nehe ang naung ihada ang ba eamulung. Iini etatabit pintar ening aulang! ");
INSERT INTO beu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Turang mi boma Musa ana Lahatala eparenta angu metma iiat mateng hula, ꞌIiva-Iimang angu ing aada.ꞌ Bot taang vengbanang hula, ꞌNuba ba hur jasi-ahala metma iva-imang adana se, malekang aing hukung ameang.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Lahatala vengbanang aulang, aarunge iing vengbanang aabeung. Iini hula, ꞌNehe nu ana na-nu metma Lahatala At palai tila se, iva bot imang ue susa di, na angu ekang metma ma inang ekang, se metma Lahatala At palai tila angu ebele.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Angu ebele Na vede hula, iini Lahatala Eomi angu bia tila, e iini lamal tahi aabeung metma telul. Lamal tahi toang iini ening aulang iila.” ");
INSERT INTO beu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ang muse, nehe aabeung angmi angu Yesus iaru e hula, “Iiavel hele hengi, e iini manggarati. ");
INSERT INTO beu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Naba ba nehe ai mi senge atou mi hela angu, bae nehe ening karita niang. Aarunge naba ba nehe omimi da, ai mi kaluar hela angu ba nehe ening karita. ");
INSERT INTO beu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Base nehe ba aver veng angu, venghelet aaung-aaung metma iiomimi!” ");
INSERT INTO beu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Seng muse Yesus bot Egahing vala ang naung imampi lamal nehe ang naung iola, e ila hava nu mi mida. Ang muse Egahing vala ang naung kolil angu emateng tarang veng taaning. ");
INSERT INTO beu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesus ibalet hula, “Iing di bae manggarati niang, e? Emateng tarang se, alang: naba ba nehe adang, angu aaung. Aarunge naba ba nehe omimi da, angu ba jasi. Naba ba pi adang angu, tatou mi hela, seng ang se bale kaluar hela. (Mutu Yesus Eomi hula naba ba adang aaung angu, emangpi nehe bisa adang. Bae ahala niang.) ");
INSERT INTO beu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aarunge naba ba nehe omimi da, anguba nehe ening karita, bot nehe ening metma Lahatala eola, anguba Lahatala Ana Eea bot bae aing veng sanang niang. ");
INSERT INTO beu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Se jasi-ahala toang nehe omimi da angu ebele! Anguba: Uukur jasi, nehe veng ahala, taavi, nehe ameang, ");
INSERT INTO beu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","maroa, nehe veng buha, jasi-ahala, nehe at akal, omi suka eamulung, omi kurang, mateng nehe abaang, oang uuring, bae aada ateing niang bot ong aanamang. ");
INSERT INTO beu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jasi-ahala aulang ang naung ba, nehe omimi da. Angu ba nehe ening karita. Bot angu ba nehe ening metma Lahatala eola.” ");
INSERT INTO beu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Seng muse, Yesus iimal mana angu eahalang, e ila bendar nu ene Tirus angmi. Ila angmi muse, ini hava nu mi mida, se Yesus hula ekang nehe iiba iot ateing hula Ana ue angmi ekang angu ebele. Aarunge Ana bae tamaang jadi niang. ");
INSERT INTO beu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Memet nu bae Yahudi enehe niang di ue angmi. Aing angu nehe poe Fenisia propinsi Siria mi angu, mi aing veng ajai. Ana vengmeet Yesus hoa iila muse, ana ila Yesus abanang hula, ot setang ba oal jangu apang taang angu aterit eola. ");
INSERT INTO beu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aarunge Yesus kolil mi mateng hula, “Kakaneng ang naung malekang iturat naadang, senge ekakabing angu biat jabar enang.” Hur ang eomi hula, Yesus malekang Enehe Yahudi ang naung iturat ioang moling senge, bot nehe aabeung oang moling. ");
INSERT INTO beu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aarunge memet angu ebalet hula, “Etabi, Nimang! Aarunge jabar angu di ue meja iivang. Kakaneng ang naung ipiring mi horung hela ang ba jabar di adang.” Eomi hula, kakaneng ang naung naadang se, jabar di naadang. Biar Yesus Enehe oang moling dise, Ana malekang nehe aabeung di oang moling. ");
INSERT INTO beu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Vengmeet aulang muse, Yesus at mateng hula, “Aaa! Memet, aana mateng molo tila! Base aaungba aana ila, setang ba ooal apang taang angu eola tila.” ");
INSERT INTO beu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ang muse memet angu ila ehava mi se, oal angu tiat udu sehi. Setang angu etabit eola tila. ");
INSERT INTO beu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Seng muse, Yesus iimal bendar Tirus angu eahalang, ini via oolol amulung ang ba oat bendar Sidon lakal. Ang mi, ini lamal tarus ila dano Galilea mi. Bot ini taang lamal ila bir nu ebendar arinu ini biasat hula, ꞌDekapolisꞌ angmi. ");
INSERT INTO beu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nehe nu hur ahala bot aver di kebe ue angmi. Eserang ang naung at Yesus ebele ila. Ini banang Yesus Atang metma nehe angu aing taang mea, e aing ening mona. ");
INSERT INTO beu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ang muse nehe toang angu Yesus Ana iot angmi mihi e, Enang kolang nehe angu at ila. Yesus Ana Atang tuba metma nehe angu aver aarupi mi taning. Bot Ana purung metma Atang tuba mi muse, nehe angu ajabur ang dei. ");
INSERT INTO beu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus apang ohit burang euling, eeng masiling aavening, senge Ana nehe angu at mateng hula, “Efata”, (evengbanang hula, “Aaungba baleleng!”) ");
INSERT INTO beu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ana vengbanang aulang muse, nehe ang aver angu mang jara. Ajabur ba aanamang angu di, mang balea, ang muse ana mateng aaung. ");
INSERT INTO beu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Seng muse, ole bale nehe toang angmi ila. Yesus ihapat hula, “Vengmee o! Iini ekang nehe at mateng hula, nehe angu Na aing ening mona tila ekang.” Yesus etatabit ihapat aulang, aarunge ini ila taang-taang mi vengsarenta. ");
INSERT INTO beu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nehe toang rae ba sarenta ang vengmee angu, ini mijongat etatabi. Ini itat mateng hula, “Bae mura niang o! Na emangpi nehe anga bisa ening aaung. Nehe aver kebe bisa vengmee, nehe hur ahala bisa mateng.” ");
INSERT INTO beu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Ved nu adana, nehe toang hoa taing vengkumpul, e Yesus aing vengmee. Ini amulung ved tue tila, angu ebele imod osing. Ang muse Yesus Egahing vala ang naung iarut iat mateng hula, “Nehe toang anga Nomi etatabit ijahi. Iiba anga ola mi hoa, e ini taing vengkumpul ved tue tila, anguba imod osing. Miaaung ini ekang iatou osing ila ekang. Misavaka ini via mi ajebing.” ");
INSERT INTO beu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Egahing vala ang naung Ehur ebalet hula, “Nimang, mana anga aabang eola. Base nehe toang alang anga pi bae iahit jadi niang!” ");
INSERT INTO beu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aarunge Yesus iadang taaning hula, “Iiroti edeng ba ue?” Ini ebalet hula, “Nimang. Roti iipi bititu kolang ni taloul mea ba ae.” ");
INSERT INTO beu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nehe toang angu Yesus Ana iot meke taang mihi. Ang muse Ana roti iipi bititu ang medi, e banang tarima kasi metma Lahatala enang. Seng muse Ana atang metma roti angu ening atatara, e metma Egahing vala ang naung inang. Ini baning ila paul metma nehe toang ang naung inang. ");
INSERT INTO beu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ing di bot iaab aaedeng ue. Yesus bot banang tarima kasi Lahatala enang metma aab angu adana. Ang muse Ana bot Egahing vala ang naung iot ila paul metma nehe toang ang naung inang. ");
INSERT INTO beu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ing emangpi oma ribu buta. Ini naadang iatou vengbarang. Naadang seng muse Egahing vala ang naung ila mod ealehil angu akumpul, ota bititu aaving. Ang muse ing emangpi Yesus Ana iot ila. ");
INSERT INTO beu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ini ila tila muse, Yesus bot Egahing vala ang naung imampi je taang mida, e mana nu ene Dalmanuta angmi ila. ");
INSERT INTO beu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yesus iimal ila Dalmanuta mi muse, nehe aaedeng Farisi eamulung hoa Aing harak. Ini At natataanang hula Aing ening ahala. Ini Abanang hula, “Nimang! Tanda nu matubing e ni ateing hula Aaing angu etatabit Lahatala Ekavasa ue Aaing veng.” ");
INSERT INTO beu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus eeng masiling aavening e, vengbanang hula, “Iini mateng aulang Na vengmee se, Na manasal! Etatalang ba iini tanda herang banang? Ekang aulang ekang! Tanda herang mang ae, aarunge Na bae ening ma iinang niang.” ");
INSERT INTO beu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Seng muse, Yesus lamal iahalang e, bale je taang mida Egahing vala ang naung imampi dano edenaveng angmi ila. ");
INSERT INTO beu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus iimal ila dano ehama mi se, Egahing vala ang naung mi vengani, hula ini tajebing bae mod baning niang. Ini roti iipi nu kolang baning. ");
INSERT INTO beu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Vengmeet ini roti veng mateng muse, Yesus hula, “Iini malekang vengani! Raja Herodes bot nehe Farisi ivomung-ipahang jasi angu iini ekang eamulung ekang. Ivomung-ipahang ba jasi angu ini metma nehe iomi taang emenghula bibit roti nehe gaot metma roti ening angu edadenang.” ");
INSERT INTO beu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vengmeet Ana mateng aulang muse, Egahing vala ang naung iomi iipi sehi. Ini itaat mateng hula, “Boma angu naba ba veng mateng e? Ana mateng aulang angu, pi oma bae roti baning niang angu ebele.” ");
INSERT INTO beu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aarunge Yesus iomi ang ateing. Base Ana iat mateng hula, “Etatalang ba iini mang roti ba veng mateng! Iini Nenomi ang bae ateing niang ka? Iiomi angu mang iipi sehi! ");
INSERT INTO beu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Iini uuling iieng taang ateing, bot iiaver vengmee tila, aarunge bae manggarati niang. Emenghula iini bae ateing niang edadenang! Iini veng tajebing iila ");
INSERT INTO beu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","roti iipi iising ba Na ening atatarat metma nehe ribu iising iahi angu, tura ealehil iini akumpul angu ota eedeng?” Ini vengbanang hula, “Ota arinu belta aalu, Nimang.” ");
INSERT INTO beu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus bot taaning hula, “Iini jedung vengani sehi e, niang? Tura Na roti ening atatarat metma nehe ribu buta iahi angu, iini ealehil akumpul angu ota eedeng?” Ini vengbanang hula, “Bititu, Nimang!” ");
INSERT INTO beu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ang muse Yesus hula, “Etabi! Iini uuling iieng taang ateing iila, aarunge etatalang ba iini bae manggarati niang hula, Nekavasa angu taang mi hoa?” ");
INSERT INTO beu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ang muse Yesus iimal ila Betsaida aabang mi. Ang mi angu nehe eng kete nu, nehe at Yesus Ebele hoa. Ini banang hula Yesus ot Atang metma nehe eng kete angu aing deit ening mona. ");
INSERT INTO beu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus Ana nehe angu atang vengpina at aabang eolat ila. Ana eng angu vengpurung senge, Atang metma eng angu taang mea. Ana adang taaning hula, “Tatalang, eeng angu jara tila e, jedung?” ");
INSERT INTO beu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nehe angu uuling tene bajaul, senge vengbanang hula, “Na uuling se nehe lamal sehi, aarunge emenghula te ba ue lamal edadenang.” ");
INSERT INTO beu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus bale Atang metma nehe ang eng angu taang mea. Ang muse, ana bot uuling se, eng angu mang jara. Bot ana etatabit mona. ");
INSERT INTO beu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus nehe angu ot ila, senge Ana at mateng hula, “Aana ila aarunge via aabeung oa! Ekang Betsaida mi ila ekang.” ");
INSERT INTO beu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ang muse, Yesus bot Egahing vala ang naung imampi lamal Kaisaria Filipi eabang ang migoleng. Via mi lamal sehise, Yesus iadang taaning hula, “Nehe ang naung isarenta eamulung se, ini hula Naing anga nuba?” ");
INSERT INTO beu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ini Ebalet hula, “Iiba hula ꞌYohanis nehe sasaraniꞌ. Iiba hula, ꞌBoma Eliaꞌ, ba Lahatala Ehur vala tura angu. Eabeung hula Aaing angu, Latahala Ehur vala tura ang ba nu.” ");
INSERT INTO beu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesus bot bale iadang taaning hula, “Aarunge iing hula Naing anga nuba?” Petrus Ebalet hula, “Nimang anga ba Kristus! Lahatala turangmi matubing iila angu.” ");
INSERT INTO beu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aarunge Yesus ihapat hula, “Iini ekang nehe iiba at mateng ekang!” ");
INSERT INTO beu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesus bot Egahing vala ang naung iat mateng ehalomang vengbanang hula, “Naing anga ba Manusia Emamolo, turangmi Lahatala matubing iila. Na malekang susalala toang harak, se hada eboma-boma, agama Yahudi ebuang vala ekapala ang naung, bot guru agama ang naung emangpi Natobang bot bae Neamulung niang. Angu ebele eningse ini Nameang. Aarunge mietang aaru se Nabale aabeta.” ");
INSERT INTO beu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus iat mateng tarang aulang, aarunge Petrus ana Yesus Atang vengpina, senge Ehapat hula, “Nimang ekang mateng aulang ekang! Na bae vengkilang ini iatang ohit metma Aadana niang.” ");
INSERT INTO beu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Petrus mateng aulang, bae Lahatala Eomi eamulung niang. Yesus bale Egahing vala aabeung ang naung iuling, senge Ana Petrus ehapat etatabit hula, “He! Ola iila! Angu setang enehe eele emateng! Aana mang manusia eomi ang ba vengpikir, Lahatala Eomi angu aana bae vengpikir niang!” ");
INSERT INTO beu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ang muse Yesus Ana nehe aabeung ang naung iarut hoa Egahing vala ang naung imampi taing vengkumpul. Ana iavomung-iapahang hula, “Nuba ba vengjalit hula Namulung se, ana malekang vengtahang Namulung ved kakanap! Eomi angu ana malekang metma etajebing ening, e Lahatala Eomi angu ba eamulung. Nehe hula ameang dise, ana malekang vengtahang emenghula nehe leut tevang vengaamina angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nuba ba eabetang por alolang taang ang ba enangkolang vengomi, eningse eabetang angu bae ue niang! Aarunge nuba ba Namulung bot Lahatala Eomi angu metma nehe avomung-apahang, eningse aabetang ejajehing Lahatala abung angu ana harak. ");
INSERT INTO beu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pasaka por alolang e angu emangpi aaing veng di Lahatala aatobang se, bae egunang niang. ");
INSERT INTO beu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bot pasaka angu emangpi aana metma eeoa di, bae metma ooramana aabetat ejajehing angu vengtelul jadi niang! ");
INSERT INTO beu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Iini vengani! Nehe por alolang taang ang naung, angase jasi-ahala angu ba ening toang amara. Ini bae Lahatala Eomi angu Eamulung niang. Base nuba ba Naing veng avaaloring Nevomung-nepahang angu bae eamulung niang se, Nandi aing veng Navaaloring bae Nimang Apang aadang mi aing mangaku niang. Naing anga ba Manusia Emamolo. Eningse Na sorga mi bale hoa. Lahatala Egahing vala hamulang sorga mi ang naung Nat hama-hama, Nimang Ekavasa eele angmi hoa, he nehe ateing hula Naing anga nuba. ");
INSERT INTO beu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nevomung-nepahang anga iini ekang veng tajebing ekang. Iing emangpi ba ae anga, iiba bae aamina jedung se, ini malekang Lahatala Ekavasa Eparenta omimi metma nehe toang eabetang adana angu uuling ateing. Angu ebele ini hula Lahatala Ekavasa angu hoa iila.” ");
INSERT INTO beu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mietang taling seng muse, Yesus Ana Petrus, Yakobus, bot Yohanis iajali e, inang buta hama-hamat dol balolu nu nehe bae mi niang angu taang mida. Inang butapi mida dol taang muse, inang tue ateing se Yesus Ava aboi. ");
INSERT INTO beu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bot Ekondo angu majaat huring jara. Por alolang taang anga na iiba bae majaat Ekondo angu edadenang niang. ");
INSERT INTO beu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Inang tue mibarotit ateing se, Yesus Ana boma Elia bot boma Musa oleve iat mateng sehi. ");
INSERT INTO beu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ang muse inang tue iuangmarit etatabi bot iomi iipi sehi, anguba Petrus ana samamamateng. Base ana Yesus At mateng hula, “Nimang! Ninang tue angami anga mang aalus! Ba miaaung ni teeng tue ahami. Nu Nimang e, nu boma Musa e, bot nu boma Elia e.” ");
INSERT INTO beu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Seng ang muse, bano di hela ing vengtering. Bot ini vengmee se nehe amal bano omimi hoa vengbanang hula, “Iini venghelet aaung-aaung! Yesus anga ba Noal Nomi Ejahi. Base iini malekang Aing ba Eamulung!” ");
INSERT INTO beu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Inang tue nehe amal angu vengmee muse, ini mijonga bot uuling se, nehe iiba bae ue niang. Aarunge Yesus enangkolang ba ue. ");
INSERT INTO beu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Seng ang muse, Yesus bot Egahing vala tue angu ini dol angu taang bale hela. Yesus ihapat vengbanang hula, “Naba ba iini vede uuling ateing iila angu, ekang metma nehe iiba iat mateng ekang. Naing anga ba Manusia Emamolo turangmi Lahatala matubing iila angu, malekang aamina hengi. Aarunge eningse Na bale aabeta, senge iini nehe toang angu iat mateng.” ");
INSERT INTO beu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ini Yesus Epalai angu pinat aaung-aaung, base ini bae nehe iiba iat mateng niang. Aarunge inang tue itadang taaning hula, “Eomi hula tatalang, ba Ana hula ꞌaamina se, bot bale aabetaꞌ? Angu tatalang, e?” ");
INSERT INTO beu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ang muse ini Adang taaning hula, “Guru agama ang naung hula, ꞌBoma Elia malekang hoa hengi, senge Kristus hoa.ꞌ Aarunge Nimang Eomi se, tatalang?” ");
INSERT INTO beu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus ihur ebalet hula, “Angu etabi. Boma Elia malekang hoa hengi, e ana via ening metma Kristus adana. Turangmi nehe Lahatala Esurat hamulang mi hurak metma Manusia Emamolo ba Kristus angu adana tila, aarunge etatalang ba iini bae manggaratit aaung jedung? Ini hurak vengbanang iilat hula eningse Ana hoa, aarunge nehe Aing ening susalala bot malekang Ameang. ");
INSERT INTO beu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Iini malekang iiavel helet aaung-aaung! Boma Elia angu turangmi hoa iila. Aarunge nehe aing ening susalala, iomi eamulung. Angu di emenghula naba ba turangmi boma ang naung hurak vengbanang iila angu edadenang.” ");
INSERT INTO beu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus bot Egahing vala tue angu bale gahing vala aabeung ang naung imampi taing harak, ini ateing se, nehe toang hoa taing vengkumpul iila. Nehe toang angu hoa hula gahing vala aabeung ba guru agama ang naung imampi natataanang angu iuling. ");
INSERT INTO beu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nehe toang ang naung uuling Yesus Ateing muse, ini mibaroti, se ini hula Ana have jedung doe dol taang. Ang muse ini bihit ila Aing harak. ");
INSERT INTO beu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus iadang taaning hula, “Iini angami naba ba veng natataanang?” ");
INSERT INTO beu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nehe nu hoa At mateng hula, “Nimang, vengmee hengi! Na noal mehal anga at hoa iila ba, Aana aing ening mona hengi. Ana hur ahala, se setang apang taang angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Setang angu aing maso tila se, ana noal anga aing metma meke mi abaang. Senge purung kukur di ai mi hela, bot aveing eera toangtadang. Bot eboa iipi angu kadadang emenghula te edadenang. Eegahing vala ang naung na iabanang iot noang moling e, setang angu ateri, aarunge ini bae ening jadi niang.” ");
INSERT INTO beu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Vengmeet aulang muse, Yesus ialil vengbanang hula, “Ee! Iini bae iomi Naing vengaanamang niang! Na iiavomung-iiapahang bae alolang niang, aarunge iini bae manggaratit aaung niang. Na iiat aabetat hama-hamat anga vengjehi di, iini bae iiomi metma Naing vengaanamang niang! Na iing vengkilang iiomi eamulung ila taveding hengi? Aaungba, val angu at angami ma!” ");
INSERT INTO beu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ang muse ini val angu abaning at Yesus Ebele ma. Aarunge setang angu uuling Yesus ateing muse, ana val angu aing metma meke mi abaang hela agoning lamal bot purung kukur di ai mi hela. ");
INSERT INTO beu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ang muse Yesus Ana val angu imang adang taaning hula, “Ooal anga taveding mi ening alang?” Imang vengbanang hula, “Kiki sehi mi aulang.” ");
INSERT INTO beu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Setang angu luung iila hula mang noal anga ameang. Ana noal anga at ila aad mi abaang bae alolang niang bot at ila jar mi aholang. Ba Nimang noang moling hengi! Misavaka bisa se, Aana Oomi ni jahi e, noal anga ening mona hengi. ");
INSERT INTO beu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus ebalet hula, “Etatalang ba aana hula ꞌmisavaka bisaꞌ? Na bisa emangpi angu ening, aarunge nehe omi metma Naing vengaanamang hengi!” ");
INSERT INTO beu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ang muse, boma angu mateng bot bau e, vengbanang hula, “Nimang etabi na nomi Aaing vengaanamang iila. Aarunge Aana noang moling e, nenomi Aaing vengaanamang angu ening adaeri!” ");
INSERT INTO beu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus uuling se, nehe toang hoa taing vengkumpul angmi muse, Ana setang angu parentat hula, “He setang jasi! Aana aaungba val angu eola e, ana bisa vengmee, bot ana bisa mateng. Aana ekang bale aing maso ekang!” ");
INSERT INTO beu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Vengmeet Yesus mateng aulang muse, setang angu kalilit etatabi. Ana ening val angu abaang hela aing masiring lamal, senge setang angu val ang eola. Ang muse val angu ajebing emenghula nehe aamina edadenang. Anguba nehe angmi ang naung itat mateng hula, “Hee! Ana aamina tila!” ");
INSERT INTO beu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aarunge Yesus val angu atang ang vengpina e aing bakung muse, ana mang tahi. ");
INSERT INTO beu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ang muse Yesus bot Egahing vala ang naung imampi mana angu eahalang, e ila hava nu mi mida. Angumi ini Yesus adang taaning hula, “Nimang! Etatalang ba vede ni setang angu bae aterit jadi niang angu?” ");
INSERT INTO beu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ang muse Yesus iat mateng hula, “Vengmeet aaung-aaung! Setang ang naung etatabit jasi, base iini bae sambajang Lahatala ot iioang moling niang se, iini bae bisat setang aulang angu aterit jadi niang.” ");
INSERT INTO beu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ang muse, Yesus bot Egahing vala ang naung ini mana angu eahalang, e ila propinsi Galilea mi. Ila angmi muse, Yesus eat hula, nehe ot ateing hula Ana bae ue angmi niang, ");
INSERT INTO beu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","se Ana mang hula Egahing vala ang naung ba iavomung-iapahang angu ebele. Ana iat mateng hula, “Bae luung niang se, ini hula Naing aabalit metma nehe aabeung enang. Senge ini ening Nameang, Naing ba Manusia Emamolo angu, eningse Na aamina, aarunge mietang aaru se, Na bale aabeta.” ");
INSERT INTO beu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus iat mateng aulang, aarunge Egahing vala ang naung iomi mang iipi sehi. Ini bae baranit adang taaning hula Yesus Eomi angu naba. ");
INSERT INTO beu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ang muse bot, Yesus iimal lamal ila Kapernaum mi. Aulang ini mida hava mi muse, Yesus Egahing vala ang naung iadang taaning hula, “Vede iini via omimi veng taat tadoi angu naba?” ");
INSERT INTO beu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aarunge iiba bae Ehur ebale niang, se vede via mi angu ini veng taat tadoit hula ing emangpi angu nuba ba mieele. ");
INSERT INTO beu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ang muse Yesus mihit iavomung-iapahang hula, “Nuba ba hula mieele hengi se, ana malekang etatabit ava ening kiki, bot nehe toang angu vengbalenta.” ");
INSERT INTO beu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ang muse val kiki nu angmi angu Yesus aing medit abaning e ila ihahama mi, senge Ana mateng hula, ");
INSERT INTO beu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nuba ba Namulung e, nehe ba ava ening alolang emenghula val anga edadenang angu vengbalenta se, evengbanang hula, nehe angu ana Nandi Naing vengbalenta sehi. Bot ana Nimang ba Naing gahing por alolang taang hela angu di Aing vengbalenta sehi.” ");
INSERT INTO beu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ang muse, Yohanis ba Yesus Egahing vala angu, kalak vengbanang hula, “Nimang! Minu angu ni ateing se, nehe nu Eene metma setang ateri. Aarunge ni ehapa, se aing angu bae pinehe niang.” ");
INSERT INTO beu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aarunge Yesus ibalet hula, “Ee! Iini ekang ehapa ekang. Se nuba ba Nene angu metma tanda herang ening se, ana bae Nene ening ajasing niang. ");
INSERT INTO beu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Naba ba ana ening angu Lahatala Eomi eamulung angse aing angu di piiiba. ");
INSERT INTO beu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Base venganit aaung-aaung! Nuba ba ateing hula iing angu Kristus Eamulung, senge ini iioang moling se, idira angu Lahatala bae veng tajebing niang. Emenghula ana jar osing ang ba galas nu ma iinang iini na di se, Lahatala bae aing veng tajebing niang.” ");
INSERT INTO beu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ang muse Yesus bot iat mateng hula, “Nuba ba jasi-ahala metma kakaneng ang naung itubing, e kakaneng ang naung bae iomi metma Naing vengaanamang niang se, nehe angu malekang ava vengani! Miaaung var eele nu, medit metma obo angu vengparta, senge aing metma tang mi aholang. ");
INSERT INTO beu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hula aana aatang baning metma jasi-ahala ening se, aatang angu patait bia! Miaaung aatang dena kolang di aana sorga Lahatala Eabang hamulang angmi e, aatang aarupi aana baning lamal, aarunge nehe aaing metma naraka aad huring eele angmi bia. ");
INSERT INTO beu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naraka angu, susalala emana. Eaad huring angu bae eaamina vengniang, bot iib toang rae ba angmi ening amanisa angu di bae eseng vengniang. ");
INSERT INTO beu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Hula aana iia angu baning lamal jasi-ahala ening se, iia angu patait bia! Miaaung iia dena kolang di aana baning sorga Lahatala Eabang hamulang angmi e, iia aarupi aana baning lamal, aarunge nehe aaing biat metma naraka aad huring eele angmi. ");
INSERT INTO beu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naraka angu, susalala emana. Eaad huring angu bae eaamina vengniang, bot iib toang rae ba angmi ening amanisa angu di bae eseng vengniang. ");
INSERT INTO beu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Hula aana eeng angu baning uuling jasi-ahala ening se, eeng angu doket bia! Miaaung eeng dena kolang di aana sorga Lahatala Eabang hamulang angmi, e eeng aarupi aarunge nehe aaing metma naraka aad huring eele angmi bia. ");
INSERT INTO beu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ꞌNaraka angu, etatabit susalala emana. Eaad huring angu bae eaamina vengniang. Bot iib toang rae ba angmi ening amanisa angu di bae eseng vengniang.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nevomung-nepahang anga, etatabit tamadi. Base nuba ba hula Namulung se, ana malekang veng tahang Namulung tarus, emenghula nehe iihal metma aab venggao senge hei, aulang e ana tahang luung bot ekang manisa ekang angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Iihal angu aaung. Aing angu mod ening tamaa. Aarunge iihal angu bae email niang iila se, bae egunang niang, base pi mang bia. Iing di malekang ening emenghula iihal angu edadenang, senge aabetat iiomi metma tejahi. Base, iini ekang taat tadoit hula nuba ba eele, nuba ba kiki ekang!” ");
INSERT INTO beu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ang muse Yesus iimal ila propinsi Yudea, bot mana aabeung ba Yarden moar eved danang oa angmi. Taang-taang mi angu nehe toang harut ebele hoa Aing vengkumpul. Ana iavomung-iapahang emenghula etura angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nehe Farisi inang aaedeng hoa hula Aing ening abaang. Ini adang taaning hula, “Piagama elamal-etahi eamulung se, nehe mehal nu jangu medi tila ana bale aing bia e, niang?” ");
INSERT INTO beu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus ibalet hula, “Vengani hengi! Jangu mehal taingmedi elamal-etahi ba boma Musa metma ma pinang angu tatalang?” ");
INSERT INTO beu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ini Yesus Ehur Ebalet hula, “Taingmedi-taingpina elamal-etahi boma Musa ening angu hula, nehe bisa taingbia, aarunge malekang taingbia angu esurat ening metma ejangu enang hengi.” ");
INSERT INTO beu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus ibalet vengbanang hula, “Ee! Vengmee hengi! Iiong aanamang angu ebele, ba boma Musa ana hurak aulang! ");
INSERT INTO beu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sarenta halomang-halomang ba tura Lahatala Ana por-burang ening angu iini ekang veng tajebing ekang! Ue hurak vengbanang hula, ꞌLahatala manusia ening, mehal bot jangu. ");
INSERT INTO beu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Angu ebele ba mehal angu ana malekang imang bot iva angu oleve iat tatara, e ila ejangu at aabetat ening nu, ");
INSERT INTO beu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","base olevepi aabetat tominu-tahanu ening nu kolang.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aulang base, Lahatala ba ening olevepi nu tila se, nehe nu ekang ing ening tatara ekang!” ");
INSERT INTO beu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ang muse, Yesus bot Egahing vala ang naung imampi mida hava nu mi. Angmi angu gahing vala ang naung, ini Yesus Evomung-epahang vede angu vengtaaning. ");
INSERT INTO beu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus ihur ebalet vengbanang hula, “Nuba ba ejangu at tatara senge bot jangu aabeung medi se, angu ana buha tila! ");
INSERT INTO beu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ejangu di aulang! Ana emehal angu at tatara, senge bot mehal aabeung medi se, angu di buha!” ");
INSERT INTO beu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Minu adana, nehe iiba ue ioal ang naung iat Yesus ebele ila e, Abanang ot Lahatala Eaaung-ehama angu metma ma inang. Aarunge Yesus Egahing vala ang naung ihapa. ");
INSERT INTO beu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus uuling ateing aulang muse, Ana Egahing vala ang naung ialil vengbanang hula, “Vengkilang e kakaneng ang naung Nebele hoa! Ekang ihapa ekang! Nehe ba emenghula ing edadenang angu ba, Lahatala Enehe. ");
INSERT INTO beu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iini venganit aaung-aaung! Nuba ba hula hoa Lahatala Aing harak se, ini malekang iomi Aing vengaariak, emenghula kakaneng ba iva-imang vengaariak angu edadenang. Hula bae aulang niang se, ing bae bisat metma Lahatala Enehe ening niang.” ");
INSERT INTO beu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Seng ang muse, Yesus Ana kakaneng ang naung iabaning bot Atang metma nu-nut iong taang mea e, Lahatala Eaaung-ehama angu metma ma inang. ");
INSERT INTO beu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus iimal bot hula lamal se, nehe kavasa nu bihit hoa e, hula Aing harak. Ana Yesus apang aadang mi tout hela senge taaning hula, “Nimang Guru, na Aaing aada, Aaing ba mieele! Na hula taaning kabing dena. Alang, Nimang. Na malekang ening tatalang e, na ateing etatabit hula, na bisa Lahatala At aabetat ejajehing sorga Lahatala Eabang hamulang angmi?” ");
INSERT INTO beu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus ebalet vengbanang hula, “Etatalang ba aana Nat mateng hula, ꞌNaing ba mieeleꞌ? Nehe iiba bae mieele niang, aarunge Lahatala ba mieele. ");
INSERT INTO beu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aana ateing iila, Lahatala Eparenta tura angu hula, Ekang nehe ameang ekang; Ekang nehe veng buha ekang; Ekang taavi ekang; Ekang saksi putar-balek angu ening ekang; Ekang nehe akal nehe kabule senge ekavasa angu medi ekang; Bot iiva-iimang angu di ing aada.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nehe angu ebalet vengbanang hula, “Etabi Nimang Guru! Mehal kaneng mi, na parenta angu emangpi eamulung iila.” ");
INSERT INTO beu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus omi metma nehe angu ejahi. Ang muse Ana hula, “Etabi! Aarunge na-nu aana bae ening jedung. Angase aana ila eekavasa ang naung emangpi aabalit miosing. Senge eseeng angu paul metma nehe masiking bot nehe ba susalala ang naung inang. Seng ang se aana hoa e aaungba Namulung. Eningse Lahatala Ana ebale kavasa aabeung metma ma enang sorga Lahatala Eabang hamulang angmi.” ");
INSERT INTO beu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nehe angu Yesus Emateng ang vengmeet aulang muse, omi mang iipi sehi. Ana kavasat etatabi angu ebele ana bale ila, aarunge omi mang dirat etatabi. ");
INSERT INTO beu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ang muse Yesus Ana Egahing vala ang naung iuling, senge iat mateng hula, “Vengmee! Nehe ba kavasa angu etatabit misusa senge ana sorga Lahatala Eabang hamulang angmi maso!” ");
INSERT INTO beu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Vengmeet Ana mateng aulang muse, Egahing vala ang naung iomi iipi sehi. Aarunge Yesus taang mateng hula, “Vengmeet aaung-aaung! Nehe ba hula metma Lahatala Enehe ening angu etatabit susa! Ekang vengoomit hula angu mang vila ekang. ");
INSERT INTO beu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hula binanta unta eele nu batul bor mi maso e mida elapa mi se, nehe kavasa nu bisa sorga Lahatala Eabang hamulang angmi maso e metma Lahatala Enehe ening.” ");
INSERT INTO beu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus Emateng aulang angu, ening ing emangpi bot iomi taang iipi sehi. Ang muse ini itadang taaning hula, “Hula etabit aulang se, nuba ba bisa Lahatala At aabetat ejajehing angu harak e?” ");
INSERT INTO beu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus Ana ing emangpi iuling, senge Ana hula, “Naba ba manusia bae ening jadi niang angu, emangpi Lahatala bisa ening!” ");
INSERT INTO beu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Seng ang muse, Petrus ai ohit mateng hula, “Nimang, ning anga na emangpi angu ni mea tila, senge ni Aamulung ba anga. Aarunge eningse naba ba metma ni ooa?” ");
INSERT INTO beu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus ibalet hula, “Na iiat mateng alang: Nehe ba Namulung e, lamal Lahatala Ehur aaung-hama angu vengmaring metma nehe at mateng mana kanap, angu ebele ba ehava, bot eiiamutu, bot iva-imang, bot oal, bot ebir, bot ekarajang, bot ehava omi ekavasa ang naung emangpi ana mea, eningse ana ebale medit mi ratunu alehil. Na emangpi ba ana mea tila angu, eningse ana bale medit mitoang mirae. Ana Namulung angu ebele, eningse nehe ajajasing. Aarunge ila por-burang evengtahi mi se, ana Lahatala At aabetat ejehing-emeang. Angu ebale ba angu! ");
INSERT INTO beu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Vengani ee! Nehe ba ava ening eele balolu angu, hula Lahatala Eomi Eamulung se, aing anguba mikiki. Aarunge nehe ba ava ening alolang-alolang angu, hula Lahatala Eomi Eamulung se, aing anguba mieele.” ");
INSERT INTO beu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus iimal bot lamal Yerusalem mi ila muse, Yesus ba lamal Etura. Egahing vala bot nehe aabeung ang naung Amulung. Ana turangmi vengbanang hula eningse nehe Yerusalem mi Ameang angu ini vengani muse, Egahing vala ang naung iomi iipi sehi bot iuangmari. Yesus ateing aulang muse, Ana Egahing vala ang naung iaru, sengila ba nehe hula Yerusalem mi naba ba ening metma Adana angu bot metma veng iat mateng. ");
INSERT INTO beu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ana vengbanang hula, “Iini vengmee! Angase pi Yerusalem mi ila. Naing anga Manusia Emamolo ba turangmi Lahatala matubing iila angu. Aarunge eningse angmo mi ini Naing aabali, metma agama Yahudi ebuang vala ekapala ang naung bot guru agama ang naung inang. Seng angse ini Naing hukung vengaamina metma ma Nenang, bot ini Naing biat metma nehe ba bae Lahatala ateing niang angu inang. ");
INSERT INTO beu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Seng angse ini mateng Nehura Nemananti. Ini Naing vengpurung. Bot ini Neboa angu varisik, senge ini Naing ening Naaamina. Na etatabit aamina, aarunge emietang aaru se, Na bale aabeta.” ");
INSERT INTO beu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ang muse, Yakobus bot Yohanis, ba Sabadeus oal angu, Yesus ebele hoa. Oleve Abanang hula, “Nimang Guru! Nole hula niomi metma veng Aat mateng.” ");
INSERT INTO beu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus iadang taaning hula, “Naba ba oole hula vengbanang?” ");
INSERT INTO beu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ole Ebalet hula, “Alang, Nimang! Eningse, hula Aana mihit Eeparenta pina tila se, nibanang nole metma Aabung mi mihi. Nu Eetene oa, nu Eebajaul oa e, nole di parenta pina.” ");
INSERT INTO beu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus ihur ebalet hula, “Naba ba oole vengbanang angu ooleve bae manggarati niang. Naing anga, eningse Nasusalala toang harak. Base, tatalang? Ooleve di hula bisa susalala angu Nat tevang hama-hamat ila vengaamina, ka?” ");
INSERT INTO beu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Oleve Ebalet hula, “Noleve di bisa, Nimang!” Yesus bot bale oleve iat mateng hula, “Etabi, ooleve di eningse susalala angu tevang emenghula Naing edadenang. ");
INSERT INTO beu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aarunge eningse nuba ba mihit Netene oa bot Nebajaul oa angu bae Naing ba vengbanang niang. Angu Lahatala ba vengbanang. Nuba ba mana angu mi mihi angu Ana etatabit vengbanang iila. ");
INSERT INTO beu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gahing vala aabeung ang naung vengmee Yakobus bot Yohanis oleve Yesus Abanang aulang muse, ini alil etatabi. ");
INSERT INTO beu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ang muse Yesus Ana ing emangpi iaru, e Ana hula, “Alang! Iini ateing iila! Nehe eele ba parenta pina ang naung angu, eningse nehe toang rae ba ini parenta angu mang ing pariku, anguba nehe toang rae angu ini bae iava vengbutil jadi niang. Bot aabang-aabang ba enehe eele bae Lahatala ateing niang angu, ini parentat iomi eamulung metma nehe toang rae angu iadana, base nehe toang rae angu bae iong ohit jadi niang. ");
INSERT INTO beu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aarunge iing anga ekang ening aulang ekang! Base iing anga nuba ba hula mieele hengi se, ana malekang ava ening emenghula jongos edadenang, senge nehe aabeung vengbalenta. ");
INSERT INTO beu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bot nuba ba hula aing metma nehe eele ening hengi se, ana malekang ava ening malea molo. ");
INSERT INTO beu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Naing anga ba Manusia Emamolo angu, Na hoa bae nehe ot Naing vengbalenta niang, aarunge Na hoa nehe toang rae angu vengbalenta. Na hoa Neabetang angu emangpi metma nehe toang angu ing sai, e ing ening lohit metma ijasi-iahala angu eola.” ");
INSERT INTO beu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus bot Egahing vala ang naung, nehe toang rae angu imampi ila bendar Yeriko mi. Ini hula lamal milalu muse, nehe eng kete nu via adil mi mihit na banang sehi. Ene Bartimeus, ba boma Timeus oal angu. ");
INSERT INTO beu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ana vengmeet hula angmi lamal angu Yesus ba Nasaret Enehe angu ba ue, ang muse ana moring hula, “Yesus! Daud etabaning! Na Aading luung iila! Oomi metma nejahi hengi!” ");
INSERT INTO beu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vengmeet ana moring aulang muse, nehe ang naung ehapat hula, “Ee! Taimang!” Aarunge ana mang taang moring hula, “Yesus Daud etabaning! Oomi metma nejahi!” ");
INSERT INTO beu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ang muse Yesus angmi tahi, senge Ana hula, “Iini at angami ma!” Ang muse ini ebele va at mateng hula, “Aaungba aana taimang! Nimang Guru Ana eearu. Aaungba ma!” ");
INSERT INTO beu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Vengmeet aulang muse, Bartimeus ana enoang angu aahit mea, senge uuser-uuser tahit va Yesus Aing harak. ");
INSERT INTO beu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus adang taaning hula, “Aana hula tatalang?” Nehe eng kete angu Ebalet hula, “Nimang ee! Na banang e, na bisa uuling.” ");
INSERT INTO beu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus bot at mateng hula, “Aana oomi metma Naing vengaanamang hula Nabisa aaing ening mona, angu ebele angase aana mona tila! Aaungba ila!” Ang muse eng benang mang mona. Seng ang muse ana Yesus Amulung lamal. ");
INSERT INTO beu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Angmi ini ila bendar Yerusalem abung muse, ini aabang aaru Betfage bot Betania ba Saitun dol eadil mi angu mi. Angmi angu Yesus bot Egahing vala ang naung miarit kabing dena. Ang muse Ana Egahing vala aaru iot iturat ila. ");
INSERT INTO beu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ana hula, “Ooleve iiturat aabang angmo mi ila. Ila angmo mi maso se, binanta keledei oal nu angmi kobong tahi angu ooleve uuling ateing. Nehe nu bae aing taang mihi di jedung. Ooleve ila esar angu vengahi, senge aing tedot angami hoa. ");
INSERT INTO beu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aarunge nehe iiadang taaning hula, ꞌEtatalang ba oole keledei angu vengahit tedot ila angu?ꞌ Hula aulang se, oole ebalet vengbanang hula, ꞌNimang Ana aing pake. Paket seng muse, Ana bale panatut hoa.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ang muse, oleve ila, e uuling ateing se, keledei oal angu hava nu via adil mi tahi angu eela mi kobong tahi sehi. Ang muse oleve esar angu vengahi e, tedot hoa. ");
INSERT INTO beu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Aarunge nehe ba angmi tahi angu ole iadang taaning hula, “Ee! Etatalang ba oole keledei angu vengahit tedot ila angu?” ");
INSERT INTO beu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ang muse ole ibalet vengbanang hula, “Niguru hula aing pake. Hula paket seng se, aulange ni bale tedot hoa.” Ang muse ini vengkilang keledei angu ole tedot ila. ");
INSERT INTO beu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ole tedot ila Yesus Enang. Seng ang muse ini inoang talaling angu metma keledei angu taang pepa, senge Yesus mida taang mihi. ");
INSERT INTO beu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aulang ini hula bendar maso muse, nehe toang rae angu inoang talaling bot isalinda ang naung medit metma via mi pepa. Nehe iiba ila via adil mi palam eva patait metma via omimi pepat mea. Ening aulang metma tanda ening matubing hula, ini Mutu Yesus Aing aada. Emenghula ini nehe eele aing tarima bot aing aada angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aulang di nehe iiba angu lamal mi iturat Yesus omi oa, bot iiba angu amota oa, senge ini tajaning hula, “Hosana! Ni Lahatala Aing tajaning Aing palevang! Lahatala Eaaung-ehama metma nehe ba Lahatala Aing gahing hoa angu ma enang, se Lahatala Aing gahing iila angu ebele! ");
INSERT INTO beu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Ni Lahatala Aing tajaning Aing palevang! Se Lahatala hula raja Daud ekavasa ba eparenta omimi angu bale at lamal angu ebele! Hosana! Ni Lahatala Aing tajaning Aing palevang! Se Lahatala Ana mihit parenta pina tila, doe burang emi atela angdomi angu ebele!” ");
INSERT INTO beu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ila bendar mi muse, Yesus bot Egahing vala ang naung Lahatala Ehava hamulang elapa omi angmi mida. Ang muse Yesus Ana uuling lapa omi angu migoleng. Aarunge, bae jol niang iila angu ebele, ini bot bale Betania aabang mi ila. ");
INSERT INTO beu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Emikuaveng muse, ini Betania mi bale lamal bendar Yerusalem mi ila. Aarunge ila via mi muse, Yesus ava malapal. ");
INSERT INTO beu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana uuling se, te nu ue via adil mi tahi. Nehe biasat eiihi angu adang. Base Yesus va te angu abung e euling hula eiihi veng e, niang. Aarunge Ana va te angu abung di, Ana uuling se, eiihi iiba bae ateing niang. Se etabit angu jol eiihi vengniang. Ana mang uhavede eva ba veng. ");
INSERT INTO beu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ang muse Yesus Ana te angu at mateng vengbanang hula, “Aana bae eiihi iiba metma ma Nenang niang, base vede angase aana bae eiihi angu metma nehe aabeung di enang niang iila!” Egahing vala ang naung vengmee se, Ana mateng amal aelet aulang. ");
INSERT INTO beu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ang muse ini lamal milalut ila Yerusalem mi, seng ang muse Yesus ila Lahatala Ehava hamulang angmi mida. Lahatala Ehava hamulang elapa omi angu nehe metma ong ening, e ini dung molola ba nehe metma sadaka ening angu angmi aabali. Ateing aulang muse, Yesus Ana iaterit kaluar hela. Meja ba ini taang seeng tatelul angu Ana bakung abaang, bot bangku ba ini taang dung aabali ang naung Ana arahak avetang. ");
INSERT INTO beu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ana nehe toang rae angu ihapat etatabit hula, aaungba iot ekang na iiba baning lapa omi angmi lakal ekang. ");
INSERT INTO beu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bot Ana iavomung-iapahang vengbanang hula, “Naba ba Lahatala Ehur vala hurak angu iini ateing iila, ue vengbanang hula, ꞌNa Nehava anga bakung atahing e, aabang-aabang ba por kanap enehe ang naung emangpi hoa mi sambajang Lahatala Abanang, bot mi Aing tajaning Aing palevang.ꞌ Aarunge Lahatala Ehava anga iini metma nehe omi jasi emana ening!” ");
INSERT INTO beu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Agama Yahudi ebuang vala ekapala ang naung bot guru agama ang naung vengmee se, Yesus ening aulang, ang muse ini iomi metma Ealalil. Ang muse ini via aalaping hula Ameang. Aarunge ing di iuangmari, se nehe toang rae angu sukat Evomung-epahang venghele angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ila vedba muse, Yesus bot Egahing vala ang naung bendar Yerusalem mi bale Betania aabang mi ila e, angmi tia. ");
INSERT INTO beu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Mikuaveng muse, ini bot bale Yerusalem mi ila. Ila via hahama mi se, te ba meleng Yesus Ana at mateng alil angu ini lakal. Egahing vala ang naung mibaroti, se te angu aamina taatat hela ebariking vengjehi. Ang muse Petrus ana Yesus Emateng meleng angu mi vengani. Ang muse Ana vengbanang hula, “Nimang! Uuling hengi! Te ba Aana meleng at mateng alil aing kutuk angu, aamina tila!” ");
INSERT INTO beu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ang muse Yesus Ana ebalet hula, “Angu etabi! Malekang iing di iiomi metma Lahatala vengaanamang aulang. ");
INSERT INTO beu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hula etatabit iini iiomi metma vengaanamang se, iini bisa dol nu ot ava ohit iipa tang mi. Se Lahatala Ana dol angu ohi, base iini ekang iiomi vengaanamang vengdadena ekang! Iini malekang etatabit iiomi metma Lahatala anguba vengaanamang. ");
INSERT INTO beu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Base, ekang veng tajebing ekang! Malekang iini iiomi metma Lahatala angu vengaanamang hula, Ana bisa naba ba iini banang angu ening metma ma inang! ");
INSERT INTO beu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aarunge hula nehe iiba sambajang Lahatala abanang e, omi bae nehe aabeung veng sanang niang se, ana malekang nehe angu at aaung-hama hengi. Aulange, Iimang doe sorga aabang hamulang mi angu Ana iiahalang angu vengahit metma ma inang. ");
INSERT INTO beu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Hula iing anga nehe iiba omi bae sanang niang veng amaang e, bae nehe eahalang angu vengahi niang se, Iimang doe sorga aabang hamulang mi angu di bae iiahalang angu vengahi niang.” ");
INSERT INTO beu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ang muse, ini lamal milalu. Ila Yerusalem mi ang muse, ini bot bale Lahatala Ehava hamulang angmi mida. Ini mida elapa omi angmi muse, agama Yahudi ebuang vala ekapala ang naung, bot guru agama ang naung, bot Yahudi eboma ang naung di hoa, ");
INSERT INTO beu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","senge Yesus Adang taaning hula, “Nuba ba Aaing gahing hoa meleng angami ening oorang angu? Nuba ba Aaing gahing!” ");
INSERT INTO beu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aarunge Yesus ateing se, ini via aalaping hula Aing ening abaang. Ang muse Ana ihur ebalet hula, “Nandi hula iiadang taaning. Iini Nehur ang ebale hengi, senge Nandi iihur ang ebale. ");
INSERT INTO beu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na hula iiadang taaning alang: Iing emangpi Yohanis nehe Sasarani angu ateing! Base nuba ba aing gahing ba ana ila nehe sarani angu? Lahatala e, nehe aabeung?” ");
INSERT INTO beu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ang muse ini veng iomit ila hoa, bot itat mateng hula, “Aah! Hur anga ning vengba tila! Ni ebalet hula, ꞌLahatala ba aing gahingꞌ, eningse Ana ebalet hula, ꞌHula aulang se, etatalang ba iini bae Yohanis e etabit vengbanang niang!ꞌ ");
INSERT INTO beu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aarunge ning di bae bisat vengbanang hula, ꞌNehe aabeung ba gahing.ꞌ Eningse nehe toang ang naung emangpi iomi alil. Se ini iomi vengaanamang hula Yohanis angu, Lahatala Ehur vala.” ");
INSERT INTO beu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ang muse ini mang ebalet hula, “Ni bae ateing niang!” Ang muse Yesus bot ihur ebalet hula, “Base, hula aulang se, Nandi bae vengbanang niang hula, nuba ba Naing gahing.” ");
INSERT INTO beu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ang muse Yesus Ana bot kolil nu metma agama Yahudi ebuang vala ekapala ang naung bot eguru agama ang naung bot Yahudi eboma ang naung iat mateng hula, “Nehe nu ana ila bir nu veng maada ening ahamulang e, anggor metma emeke angmi muding. Seng ang muse ana lapa ening bir angu migoleng. Bot ana bak ening senge anggor ejar angu metma ma mi. Ana hava balolu jaga emana di nu ening atahing. Ang muse ana bir angu sevat metma nehe aabeung enang ini vengkarajang, senge ebili angu metma at paul. Seng ang muse ana por ola taang ila. ");
INSERT INTO beu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Anggor avaning ejol mi muse, bir manaing angu egahing vala nu ot nehe karajang ang naung ibele hoa, e baang angu banang. ");
INSERT INTO beu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aarunge ana hoa ing harak muse, nehe karajang ang naung adoit aing pina, e aing bue. Seng ang muse ini ot atang osing bale ila. ");
INSERT INTO beu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ang muse bir manaing angu ana bot egahing vala nu taang aing panatut hoa. Aarunge nehe karajang ang naung aing bue ening ong angu aibat. Ini aing gamar ehura emananti, seng ang muse ini aterit ot ila. ");
INSERT INTO beu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ang muse bir manaing angu ana bot egahing vala aabeung taang panatu. Aarunge ini ameang. Ini ening tatalang di, bir manaing angu egahing vala angu panatu tarus. Aarunge nehe ba karajang ang naung ini ing bue, ing ening iajajasing-iababutung bot iiba angu ini iameang. ");
INSERT INTO beu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Angase nehe nu kolang ang ba jedung. Aing angu ba bir manaing angu oal mehal nu kakolang ba ana etatabit omi metma ejahi angu. Bae via aabeung niang angu ebele, ana oal angu ba aing panatu. Ana veng omit hula, ꞌNa noal mamolo ba aing panatu base, ini malekang aing tarimat aaung-aaung bot ini aing vengmee.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Base ana oal angu aing panatut angmo mi ila. Aarunge nehe karajang ang naung uuling ateing se, val angu hoa muse, ini itat mateng hula, ꞌEe, uuling hengi! Boma angu ana oal mamolo ba aing panatut hoa iila! Hula boma angu aamina se, aing anga ba eningse kavasa ang naung emangpi medi. Ma e, pi val angu ameang, aulange ekavasa anga naung ping ba medi.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ang muse ini hama-hama tahit adoi, seng muse ini ameang. Ini ebaring angu at ila metma bir amota oa angmi bia. Kolil mateng metma nehe anggor ebir vengkarajang adana angu ila angmi jehi.” ");
INSERT INTO beu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Seng ang muse, Yesus Ana nehe eele ang naung iadang taaning hula, “Iiomi eamulung se, hula bir manaing angu ana ening tatalang metma nehe ba karajang ang naung iadana? Neamulung se, malekang ana hoa e nehe karajang ang naung emangpi iameang miosing. Seng ang muse, ana anggor ebir angu sevat metma nehe aabeung enang ini vengkarajang. ");
INSERT INTO beu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ping emangpi Lahatala Esurat hamulang angu basa se vengbanang hula, ꞌVar nu angu molang ang naung ohit bia tila. Aarunge angase var anguba metma var pasagi ening iila. ");
INSERT INTO beu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lahatala ba vengtalail medi, bot var angu amihing. Angu ebele ba pi uuling ateing se, eaalus bae na iiba edadenang niang!ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nehe eele ang naung ini tarus manggarati se hula, Yesus Ana ing ba ing vengbanang kolil mi mateng aulang. Ing angu emenghula nehe ba vede anggor bir mi karajang angu edadenang. Base ini via valaping e hula adoit Aing pina. Aarunge ini nehe toang rae ba sukat Yesus Evomung-epahang venghele ang naung veng iuangmari. Base ini tahit lamal ila Yesus eola. ");
INSERT INTO beu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ang muse, nehe Yahudi enehe eele ang naung ini nehe Farisi inang aaedeng, bot nehe ba Herodes eamulung angu ing gahing ila Yesus At natataanang e, hula Aing ening ahala. ");
INSERT INTO beu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ini hoa muse, ini Yesus At natataanang hula, “Nimang Guru! Ning emangpi ateing hula Aaing Oomi angu molo-molo, bot bae akal-kabule niang. Aana uuling nehe omi di ateing, bot Lahatala Eomi angu di Aana tarus-tarang vengbanang, Aana bae nehe apang kalalang niang. Ba angase, ni hula na-nu veng aadang taaning. Piagama Yahudi elamal-etahi eamulung se, pi malekang bea bajar metma parenta Roma eraja eele angu enang, e, niang?” ");
INSERT INTO beu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aarunge Yesus ateing iila, ini hula Ajajala, e Ana mateng parenta Roma aing malavang. Ang muse, Yesus ihur ebalet etatabi vengbanang hula, “Etatalang ba iini hula uangu metma veng Nadang taaning Naing ening ahala! Seeng perak angu nu at ma, Na euling hengi!” ");
INSERT INTO beu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ang muse, seeng perak nu ini taning metma ma enang. Ang muse Yesus Ana seeng angu medit euling muse, Ana iadang taaning hula, “Gambar anga nuba apang? Bot anga nuba ene?” Ang muse ini ebalet hula, “Angu parenta Roma eraja eele!” ");
INSERT INTO beu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ang muse Yesus hula, “Yaa! Hula aulang se, iini ila naba ba parenta ebaang se, metma parenta enang. Bot naba ba Lahatala ebaang se, metma Lahatala enang.” Vengmeet Ana mateng aulang muse, ing emangpi mibaroti, se naba ba Ana vengbanang angu etabi. Angu ebele base ini bae Aing ening ahalat jadi niang. ");
INSERT INTO beu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yahudi eagama omimi angu ekelompok nu ue, nehe ene vengbanang hula Saduki. Ini vomung-pahang hula nehe aamina se, bae bale aabeta niang. Minu adana, Saduki enehe inang aaedeng di hoa hula Yesus At natataanang Aing ening abaang. ");
INSERT INTO beu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ini Yesus At mateng hula, “Nimang Guru! Boma Musa hurak metma ma ninang, hada vengbanang hula: nehe mehal nu aamina ejangu jedung aabeta aarunge val vengniang se, mehal angu ekaku emi amulung angu malekang jangu kalabal angu aing medi e, val veng metma ekaku ba aamina tila angu enang. ");
INSERT INTO beu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Etabit Musa vomung-pahang vengbanang aulang. Aarunge ni hula taaning alang: Nehe mehal bititu iia mutu. Ehalomang angu eturat jangu medi, seng muse ana aamina, aarunge bae val vengniang. ");
INSERT INTO beu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ang muse ekaku ba emi amulung angu jangu kalabal angu aing medi. Bae luung niang se, andi aamina, aarunge bae val vengniang. Aulang di bot ekaku emitue, ana jangu kalabal angu medi, aarunge ana aamina e, bae val vengniang. ");
INSERT INTO beu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aulang mitatamulung ila ekaku iia ang di aamina. Seng ang muse, jangu kalabal angu di aamina. ");
INSERT INTO beu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ba! Angase ni hula taaning alang: Nehe jangu angu mehal bititu medi tila! Aarunge hula por-burang evengtahi mi e, Lahatala Ana nehe aamina ang naung iot bale aabeta se, jangu angu metma nehe bititu angu nuba ba ejangu ening?” ");
INSERT INTO beu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ang muse Yesus ihur ebalet hula, “Hula iini taaning aulang se, evengbanang hula Lahatala Esurat hamulang eomi angu iini bae manggaratit aaung niang. Bot Lahatala Ekavasa angu di iini bae manggarati niang. Base iing angu etatabit ahala tila! ");
INSERT INTO beu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vengmee hengi! Alang! Sorga mi angu, taingmedi-taingpina bae ue niang. Nehe emangpi ba aamina tila, senge Lahatala ening bale aabeta, ang naung di iiba bae taingmedi niang. Aulang di Lahatala Egahing vala sorga mi ang naung di iiba bae taingmedi niang. ");
INSERT INTO beu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Senge, Na hula metma veng iat mateng, nehe aamina ang naung bale aabeta e, niang. Boma Musa esurat hurak mi vengbanang hula dadi napa viling, aarunge bae tepul niang. Iini sarenta angu vengani e, niang? Angmi aad angu ue dadi napa angu mi viling sehi, ang muse, Lahatala Ana Musa at mateng hula, ꞌNaing anguba iidat-iimang ang naung iLahatala. Anguba iidat Abraham, iidat Isak, bot iidat Yakob. Ing emangpi Naing aada ila anga vengjehi.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ba! Pi ateing hula tidat-timang ang naung aaminat luung iila. Aarunge Lahatala hula Ana jedung Aing metma iLahatala ening sehi, angu ebele ba pi ateing hula ini bale aabeta tila. Base, nehe ba aamina tila di se, ini malekang bale aabeta. Nehe aabeta sehi anguba ana Lahatala Aing aada, nehe aamina tila angu se, niang. Base hula vomung-pahang angu iini pinat aanamang hula, nehe aamina bae bale aabeta niang se, iini etatabit ahala!” ");
INSERT INTO beu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesus mihit nehe Saduki ang naung iat mateng sehise, guru agama di nu eamulung vengmee. Guru agama angu eomi hula itaaning angu Yesus ebalet molo tila. Ang muse ana Yesus Adang taaning hula, “Nimang! Na hula taaning alang: Pihada elamal-etahi, bot agama elamal-etahi ang naung di toang amara. Lamal tahi emangpi ba boma Musa eparenta omimi angu taang ba mieele?” ");
INSERT INTO beu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus ebalet hula, “Parenta ba mieele Lahatala Esurat hamulang omimi angu alang: ꞌNehe emangpi ba Israel mi angu iini vengmeet aaung-aaung. Lahatala angu etatabit pi Lahatala, bot Aing anguba pi manaing eele balolu! Bae pimanaing aabeung iiba niang, aarunge Aing ba enangkolang! ");
INSERT INTO beu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Base iini malekang iiomi metma Ejahit mieele. Angu ebele, iini malekang iiomi Aing mi dadanang, bot Aing anguba iini malekang Ateing, bot Eomi anguba etatabit eamulung vengkarajang.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bot Eparenta emiaaru hula alang: ꞌAana malekang oomi metma nehe aabeung angu ejahi, emenghula aana oomi metma aababahi ejahi angu edadenang.ꞌ Parenta aaru anguba mieele. Parenta aabeung bae parenta aaru anga miataang oa niang.” ");
INSERT INTO beu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ang muse, guru agama angu bot Yesus At mateng hula, “Etabi! Naba ba Nimang vengbanang angu, etabi. Lahatala angu metma pimanaing eele balolu ening, e bae Lahatala aabeung iiba niang. ");
INSERT INTO beu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pi malekang tomi metma Ejahit mieele, bot tomi Aing mi dadanang, Aing anguba pi malekang Ateing, bot Eomi anguba etatabit eamulung vengkarajang. Bot ping di malekang tomi metma nehe aabeung ejahi, emenghula pi tomi metma tababahi ejahi angu edadenang. Angu, Lahatala etatabit Eomi sanang. Angu lebe miaaung, e pi mang agama elamal-etahi anguba enangkolang eamulung binanta ba metma sadaka ening edet atepul, senge na aabeung metma enang se, angu bae aaung niang.” ");
INSERT INTO beu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Vengmeet ana ebalet aulang muse, Yesus Eomi hula guru agama angu manggaratit aaung iila. Ang muse Yesus hula, “Kabing dena maveng se, aandi oomi vengaanamang angu emenghula Lahatala Enehe ang naung edadenang.” Seng ang muse, nehe aabeung bot bae Yesus adang taaning niang iila, se nehe iiba bae Aing ening Abaang jadi niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ang muse, Yesus jedung Lahatala Ehava hamulang angmi nehe toang angu iavomung-iapahang sehi. Di Ana iadang taaning hula, “Iiomi eamulung se, tatalang? Guru agama ang naung vomung-pahang hula Kristus anguba, turang jamang mi Lahatala matubing iila. Iomi eamulung se, Aing angu mang raja Daud etabaning. Aarunge angu bae molo jedung. ");
INSERT INTO beu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Se turangmi Lahatala ERoh hamulang angu raja Daud omimi e ana hurak vengbanang hula, ꞌLahatala Ana ne manaing eele balolu angu at mateng iila vengbanang hula, “Mahe aada haromat emana Ne tene oa angu mi mihi. Aulange nehe ba omi metma eekakurang ang naung Na ening ini aaing veng tou.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Uangu ebele pi ateing raja Daud di Kristus angu Earu se, hula ꞌEmanaing eele baloluꞌ. Angu ebele, nehe iiba hula Kristus angu, mang raja Daud etabaning ba enangkolang se, angu bae molo niang! Se Aing angu di metma raja Daud emanaing eele balolu ening!” ");
INSERT INTO beu_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Yesus vede mateng aulang muse, nehe toang ang naung vengaariak etatabit hula Aing venghele. ");
INSERT INTO beu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ang muse Ana bot iat mateng hula, “Iini malekang iiava venganit metma guru agama ang naung iadana. Ini sukat ikondo aavening bir venggalar ang naung paket basiar lamal, ila nehe toang rae harak, e nehe uuling iateing se hula, ꞌWe! Ing angu nehe eele o!ꞌ ");
INSERT INTO beu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Hula ini ila ihava hamulang mi masot mida, e hada epesta amulung se, ini sukat mana aalus angba valaping mi mihi, e nehe toang uuling iateing. ");
INSERT INTO beu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aarunge iiava vengani oo! Se ing di bot akal-kabule ba jasi angu ening metma nehe kalabal ang naung iadana angu ebele, ini ihava ang naung emangpi medit metma ioa. Aarunge nehe toang apang aadang mi se, ini ijasi angu vengtering, e tahit sambajang luung-luung. Ini ening aulang senge, nehe hula ing angu iomi hamulang. Aarunge eningse Lahatala ing hukung etatabit tamadi.” ");
INSERT INTO beu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ang muse, Yesus mida Lahatala Ehava hamulang mi sadaka epiti angu buang mihi. Ana uuling se nehe toang rae hoa isadaka metma piti angu mi maso, Ana ateing se nehe kavasa ang naung di hoa iseeng toang-toang metma angmi maso. ");
INSERT INTO beu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nehe kalabal masiking di nu hoa sambajang amulung. Ana eseeng aaru metma piti angu mi maso. Seeng angu ebili etatabit kiki. ");
INSERT INTO beu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ang muse Yesus Ana Egahing vala ang naung ing gale senge iat mateng hula, “Iini nehe kalabal masiking angu euling aaung-aaung. Ana seeng aaru kakolang maso, aarunge ana ening lebe mieele nehe emangpi anga mi iataang oa. ");
INSERT INTO beu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nehe aabeung ang naung ini iseeng ealehil anguba baning hoa masot metma isadaka ening. Aarunge nehe kalabal anga, eseeng ba aing veng angu emangpi ana metma Lahatala enang.” ");
INSERT INTO beu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ang muse, Yesus bot Egahing vala ang naung imampi hula ila Lahatala Ehava hamulang angu eahalang. Ini hula kaluar hela lamal se, Egahing vala nu Lahatala Ehava hamulang angu matubing, e vengbanang hula, “Nimang e! Aanake angu euling hengi! Hava anga etatabit mang aalus! Ini evar eele ang naung metma taing taang piling eaalus bae mura niang!” ");
INSERT INTO beu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aarunge Yesus ebalet vengbanang hula, “Hava anga etabit aalus! Aarunge bae luung niang se, ini evar ang naung emangpi adundur miosing.” ");
INSERT INTO beu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ang muse, Yesus bot Egahing vala ang naung imampi Saitun dol taang mida, e mana nu mi mihit iomi metma Lahatala Ehava hamulang angu enang. Ang muse Egahing vala inang buta ebele hoa inang kolang At mateng. Ing benang ba Petrus, Yakobus, Yohanis, bot Anderias. ");
INSERT INTO beu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ini taaning hula, “Nimang! Aanake Eemateng vede angu bale taang vengbanang. Taveding e Lahatala Ehava hamulang evar ba nehe adundur, ejol angu hoa? Bot etanda-tanda angu, tatalang?” ");
INSERT INTO beu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ang muse Yesus ibalet vengbanang hula, “Iiava vengjagat aaung-aaung! E, nehe ekang iiajajala ekang. ");
INSERT INTO beu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eningse nehe toang hoa iadiar parut vengbanang hula, ꞌNaing anga ba Kristus, nehe ba turangmi Lahatala Aing matubing iila anguꞌ. Senge ini bot nehe toang ajajala. ");
INSERT INTO beu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hula iini ateing se, nehe malibal, e nehe taang-taang mi malibal sehi angu esarenta vengmee se, iini ekang iiuangmari ekang. Se emangpi ba aulang angu malekang jadi hengi, aarunge bae por-burang evengtahi mi jedung. ");
INSERT INTO beu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Eningse lelang nu lelang aabeung at malibal. Negara nu negara aabeung at malibal. Taang-taang mi angu por tajoa. Bot malapal tabonggal di etatabi! Emangpi anga metma etanda-tanda ening, emenghula nehe jangu ba hula val veng ajai edira angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Base iini malekang iiava vengjagat aaung-aaung! Eningse ini hoa iiadoit iing masiring ila metma pengadilan agama mi. Bot ini hava hamulang ang naung mi iing bue. Bot ini iing partat iiat ila metma nehe eele ba parenta pina ang naung iapang aadang mi, se iini Namulung angu ebele. Aarunge anguba ejol aaung metma ma inang, e iini Nesarenta aaung-hama angu metma veng iat mateng. ");
INSERT INTO beu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lahatala Enehe angu malekang ila Nesarenta aaung-hama angu ematurat vengmaring metma lelang-lelang ba ae por alolang taang anga miiipi, senge por-burang angu evengtahi mi. ");
INSERT INTO beu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Vengani o! Hula ini iing partat iiat ila metma pengadilan mi se, iini ekang iiuangmarit hula, ꞌEningse na mateng tatalang? Ee naba hur ba na metma nehe ebale?ꞌ Ila ejol angu mi e hula aulang se, naba ba Lahatala ERoh hamulang metma iiomimi anguba iini vengbanang metma iat mateng. ");
INSERT INTO beu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Hava nu omimi, hula, nehe ue omi metma Naing vengaanamang, eningse ekaku mamolo ba evia aalaping ameang. Senge val ba omi metma Naing vengaanamang, eningse iva-imang mamolo ba ameang. Bot hula iva-imang ba omi metma Naing vengaanamang, eningse ioal mamolo ba iameang. ");
INSERT INTO beu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Base, eningse nehe ang naung iomi metma iialalil etatabi, se iini iiomi metma Naing vengaanamang angu ebele. Aarunge nehe ba veng daerit ila evengtahi mi se, Lahatala Ana aabetang ejajehing metma ma inang.” ");
INSERT INTO beu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus mateng tarus hula, “Nehe nu omi jasit etatabi eningse ana hoa. Ana ila Lahatala Ehava hamulang angmi maso, mana palula ba bae emana niang angmi tahi, senge ana mana angu ening akarita. Angu ebele Lahatala Ana mana angu atobang bot Amota metma ma enang. Hula iini uuling ateing aulang iila se, iiava vengjaga e! (Nuba ba anga basa se, ana malekang ava vengjaga!) Angu metma tanda ening hula ved-ved ba susalala angu hoa viaha mi tila. Hula uuling ateing aulang se, nehe propinsi Yudea mi angu tahi e bihit dol taang ila. ");
INSERT INTO beu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bot malekang bihit venghanako aulange ekang silaka ekang. Hula nehe iiba ihava mi kaluar hela iila se, ekang bale ihava mi masot mida naosing medi ekang. ");
INSERT INTO beu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bot nehe ba bir mi di, ekang bale hoa noang medi ekang. Aarunge bihi tarus. ");
INSERT INTO beu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Eba mikasiang angu, jangu ba ia tamadi val veng toda, bot memet naung ba val kalokal aing kono sehi angu. Se ini bae bihit venghanakot jadi niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Base, miaaung iini sambajang e, banang na jasi aulang angu hoa se, ekang ila jol aanuar adana ekang. ");
INSERT INTO beu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Se ved uangu etatabit susa angu ebele! Turang mi Lahatala Ana por-burang ening angmi hoa anga vengjehi anga, susa eele aulang angu nehe bae uuling ateing jedung. Aulang di eningse susa eele aulang angu nehe bot bae bale uuling ateing niang. ");
INSERT INTO beu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Hula Lahatala bae ved uangu ening atukang niang se, nehe nu bae bisat veng daerit aabeta niang. Aarunge, Lahatala omi metma nehe ba Ana vengtalail ang naung ijahi angu ebele, Ana ved-ved susa angu ening atukang. ");
INSERT INTO beu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Hula ila eved angu mi, iini vengmee se, nehe ang naung hula, ꞌIieng uuling! Kristus ae angami!ꞌ Aarunge nehe aabeung hula, ꞌKristus moe angmo mi!ꞌ Aarunge iini ekang venghele ekang! ");
INSERT INTO beu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Eningse nehe iiba hoa e adiar parut vengbanang hula, ꞌNaing anga, Kristus!ꞌ Nehe eabeung vengbanang hula, ꞌNaing anga, Lahatala Ehur vala.ꞌ Eningse ini setang ekavasa paket tanda herang ening toang-toang bot akal-kabule jasi angu ening. Ini ening aulang metma Lahatala Enehe ang naung iajajala, e ing di akal-kabule jasi angu ing vengba. ");
INSERT INTO beu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aarunge iini malekang vengjagat aaung-aaung, e! Ved-ved susa ang naung bae hoa jedung, aarunge Na metma iivengani ening iila!” ");
INSERT INTO beu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ang muse Yesus bot taang hamuat Egahing vala ang naung iat mateng hula, “Hula ved-ved ba susa ang naung sengila, ꞌEningse ved eng angu kua-kete, Uuru di bae jala niang iila. ");
INSERT INTO beu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Iid ba burang mi ang naung baat horung hela, Bot kavasa emangpi burang mi angu di eningse tajoa-tadiri.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Senge, nehe emangpi uuling Nateing Naing ba Manusia Emamolo turangmi Lahatala matubing ila angu, eningse Na burang mi hoa. Senge nehe emangpi Nekavasa, bot Neeele Nebalolu angu uuling ateing! ");
INSERT INTO beu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Senge Na Lahatala Egahing vala sorga mi ang naung ing parenta e, ila nehe ba Na vengtalail por etupa dena, ila por etupa dena mi angu emangpi ing kumpul, ved danang oat ila ved baang oa, dol eoat ila poe tang eoa.” ");
INSERT INTO beu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus Emateng angu taang hamuat vengbanang hula, “Na kolil mi mateng metma te mi mea. Hula eva angu ana iiba baori tila se, angu evengbanang hula jol ved etutung hoa peang iila. ");
INSERT INTO beu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aulang di, hula iini uuling ved-ved susa angu hoa iila se, emenghula Na vede metma iiat mateng angu edadenang, angu evengbanang hula Na hoa peang iila. ");
INSERT INTO beu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Angase, vengmeet aaung-aaung! Nehe ba aabeta sehi anga, emangpi bae aamina jedung, aarunge iiba jedung aabeta sehise, eningse ved-ved susa angu hoa iila. ");
INSERT INTO beu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hula por-burang angu bae ue niang iila di se, Nemateng angu vengtahang bae eseng veng niang.” ");
INSERT INTO beu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus bot mateng hula, “Nebale hoa angu nehe iiba bae ejol angu ateing niang. Lahatala Egahing vala sorga mi ang naung di, bae ateing niang. Naing di, bae ateing niang. Aarunge Nimang enangkolang ba ateing. ");
INSERT INTO beu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Angu ebele, iini malekang vengjagat aaung-aaung, se iini bae ejol angu ateing niang hula taveding. ");
INSERT INTO beu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bae luung niang se, Na ila iiadut iinangkolang, aarunge eningse Na bale hoa, emenghula nehe ba lamal bir ola mi ila e, ehava osing atahing angu edadenang. Ana ebalenta vala ang naung gahing iot hava angu vengpiling aaung-aaung. Bot ana ikarajang di vengpiling metma nu-nut enang. Nehe ba viaha jajaga angu di ana aing parentat ot vengjagat aaung-aaung ila ana vengbale. ");
INSERT INTO beu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iing di malekang vengjagat kua-jala, se iini bae ateing niang taveding e hava manaing angu hoa. Vedba hoa e, tereng hahama e, vedalil e, kukuaveng. Taveding di iini bae ateing niang. ");
INSERT INTO beu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Misavaka mibarotit ana hoa e, ateing se, iini tiat udut kuru sehi. ");
INSERT INTO beu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Base, naba ba Na metma iiat mateng anga, Na bot metma nehe toang rae aabeung ang naung di iat mateng, hula, ꞌIini malekang vengjagat aaung-aaung e, Nehoa angu tarima.ꞌ ” Saitun dol taang Mutu Yesus barintit Egahing vala ang naung iat mateng angmi jehi. ");
INSERT INTO beu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Ang muse, agama Yahudi ebuang vala ekapala ang naung jedung akal jasi aalaping sehi e, hula taimang-taimang Yesus adoi, e ini hula Ameang. Aarunge ini vengtemaring hula, “Jedung hengi! Pi ekang uuser-uuser Adoi ekang. Se ved-ved ba aaung-hama angu peang iila. Misavaka nehe toang ang naung eningse ini bir arahak.” Ini itat mateng aulang. Se ved aaru jedung se, nehe Yahudi ang naung ived aaung-hama, ini ene maveng hula ꞌVed Paskaꞌ bot ꞌPesta Roti Bae Bibit Pake Niangꞌ. Bot angu ved aaung-hama tura angu ini vengani, ini tura idat imang Mesir mi kaluar hela lamal angu ini vengani. Ini itat mateng aulang. ");
INSERT INTO beu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania aabang mi, nehe nu ene Simon. Tura angu nehe aing vengsini, se dilang hapeburang aing ening angu ebele. Aarunge angase, ana mona tila. Senge muse, bae ila ved aaung-hama angu ejol mi jedung se, Yesus bot Egahing vala ang naung imampi ila Simon ehava mi naadang. Ini naadang sehise, nehe jangu nu hoa Yesus Aing harak. Jal manema botil nu ini eng angu akabitak medi tila angu ana pina, jal manema angu etatabit ebili eele. Ang muse ana jal manema angu metma Yesus Ong mi bokong balea-balea, e metma tanda ening ana Yesus Aing aada tila. ");
INSERT INTO beu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aarunge nehe aabeung inang aaedeng angmi iat naadang. Ini uuling ateing se, nehe jangu angu ening aulang muse, ini alil, e itat mateng iava aohit hula, “Uuii! Jangu tatalang ba anga, ba ana jal manema ebili eele angu biat parasumang angu! ");
INSERT INTO beu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Miaaung ana jal manema angu mang aabali! E eseeng toang angu, ila paul metma nehe masiking kasiang ang naung inang! Jal manema ang ebili angu, emenghula nehe egaji mitungnu edadenang.” Base ini ehapat etatabi. ");
INSERT INTO beu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aarunge Yesus ibalet hula, “Iini ekang nehe jangu anga aing ening susa ekang! Vengkilang ana ening! Na sanang, se ana jal manema anga metma Naing vengbokong iila. ");
INSERT INTO beu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nehe masiking kasiang ang naung kilang ue iiat aabeta. Base iing ba hula taveding e ing vengbalenta. Aarunge Naing anga, bae luung niang se, Na bae iiat hama-hama niang iila. ");
INSERT INTO beu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Neabetang anga bae luung niang iila. Bot nehe jangu anga vede jal manema metma Naing vengbokong anga, ana Ne boa iipi angu vengharakat ematura, emenghula ana jal manema metma Nebaring vengbokong angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Venganit aaung-aaung! Taang mi Lahatala Esarenta aaung-hama angu nehe vengmaring por alolang anga migoleng se, ini malekang nehe jangu anga eaaung angu vengsarenta! Ee nehe emangpi aing vengani.” ");
INSERT INTO beu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yesus Egahing vala inang arinu belta aalu angu nu ene Yudas Iskariot. Ana ila agama Yahudi ebuang vala ekapala ang naung ing aalaping, e hula Yesus Aing aabalit metma ma inang. Ila ing harak muse, ana eomi angu metma veng iat mateng. ");
INSERT INTO beu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nehe eele ang naung Yudas emateng aulang angu vengmee muse, iomi etatabit sanang. Ang muse ini palait hula, “Aana hula Yesus Aing aabalit metma ma ninang, eningse ni malekang bajar.” Ang muse Yudas ana kaluar hela lamal, e ila via valaping hula Yesus At ila metma ma inang. ");
INSERT INTO beu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ved uangu ved ehalomang nehe Yahudi eved aaung-hama adana. Base, ved uangu veng angu, ini roti ba bae bibit maveng niang angu iia, bot ini jumba di ameang. Ang muse, Yesus Egahing vala ang naung hoa adang taaning hula, “Nimang! Vede ved anga, pived aaung-hama Paska angu. Ba, Aana hula ni ot ila taang mi pesta Paska angu emana vengharaka?” ");
INSERT INTO beu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ang muse Yesus Ana Egahing vala aaru ing gahing hula, “Oole iiturat ila bendar mi. Angmo mi, eningse oole nehe mehal nu ue jar korong kiki nu tevang angu aing harak. Oole ila mang amulung. ");
INSERT INTO beu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Eningse, ana ila hava taang ba mi maso se, oole amulung ila angmi. Seng ang se, oole hava manaing angu at mateng hula, ꞌNimang! Nimang Guru mana nu banang, e Ana hula paket metma Egahing vala ang naung iat pesta Paska ening.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eningse, nehe angu ana kamar eele nu atela angu matubing. Ana kamar angu vengharaka tila. Aarunge oole ila e mod ba angmi vengharaka.” ");
INSERT INTO beu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ang muse ole lamal ila bendar mi. Angmo mi emangpi ba Yesus metma ole iat mateng iila angu harak. Base ole emangpi angu vengharaka, e Yesus bot Egahing vala ang naung angmi pesta Paska enaadang. Ang muse ole bale ila Yesus bot Egahing vala ang naung iaru. ");
INSERT INTO beu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ved hula ba muse, Yesus bot Egahing vala arinu belta aalu angu ini angmi ila. ");
INSERT INTO beu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ang muse ini mihit naadang hama-hama. Ini naadang sehise, Yesus iat mateng hula, “Iini vengmee hengi! Nehe nu iing veng angu, eningse ana Naing aabalit metma nehe aabeung enang.” ");
INSERT INTO beu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vengmeet aulang muse, iomi bae sanang niang. Ang muse ini nu-nut Yesus adang taaning hula, “Nehe ba Nimang vengbanang angu, bae naing niang, o?” ");
INSERT INTO beu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus ibalet vengbanang hula, “Nehe ba eroti angu metma mako anga mitaning hela Nat hama-hama, aing angu ba eningse Naing aabali. ");
INSERT INTO beu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Vengani e! Naing anga Manusia Emamolo ba turangmi Lahatala matubing iila angu, malekang aamina, emenghula nehe Lahatala Esurat hamulang mi hurak iila angu edadenang. Aarunge vengani! Nehe ba hula Naing aabali angu, eningse ana etamadi angu tevang! Miaaung aing angu iva ekang aing veng ajai ekang!” ");
INSERT INTO beu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ini jedung naadang sehi muse, Yesus roti ahi dena nu ohit pina, e banang tarimakasi metma Lahatala enang. Seng muse Ana roti angu apeteng ening atatara, senge taning metma Egahing vala ang naung inang. E Ana vengbanang hula, “Roti anga, Neboa angu, medi e aaungba adang.” ");
INSERT INTO beu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Seng ang muse, galas ba anggor eiipi ejar ue mi angu Ana medit ohit pina, Ana bot banang tarimakasi metma Lahatala enang. Ang muse galas angu Ana taning metma Egahing vala ang naung inang e ini na. ");
INSERT INTO beu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ang muse Ana vengbanang hula, “Anggor anga, Neve angu. Eningse ana ava bokong metma nehe toang angu ening lohi. Ve anga metma ebukti ening e, iivengani ening hula, naba ba Lahatala vengpalai tila angu, etatabit angase ekanap mi. Ba, medi e aaungba na. ");
INSERT INTO beu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Vengmeet aaung-aaung hengi! Vede kua anga, Na bae anggor eiipi ejar angu na niang iila, ila Na Nimang doe sorga mi angu At hama-hama mihit parenta, senge Na bot na.” ");
INSERT INTO beu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Seng ang muse, ini dal nu ohit metma Lahatala Aing tajaning. Seng muse kua angmi ini tahit lamal Saitun Dol taang ila. ");
INSERT INTO beu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Uangu adana, ini hula lamal muse, Yesus iat hubait hula, “Eningse vede kua anga, iing emangpi bihit Naing bia. Angu ue ini Lahatala Esurat hamulang mi hurak vengbanang iilat hula, ꞌEningse Lahatala Ana terang vala angu ameang, Senge jumba ang naung bihit tarae-teapahing.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Na etabit aamina. Aarunge eningse hula Na bot bale aabeta tila se, Na Nematurat ila Galilea mi, senge iini ila angmo mi Naing harak.” ");
INSERT INTO beu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ang muse, Petrus malavang vengbanang hula, “Nimang! Masiking nehe aabeung ang naung emangpi bihit Nimang Eola, aarunge naing bae bihi niang!” ");
INSERT INTO beu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus ehur ebalet hula, “Petrus! Vengani, e! Vede kua anga, hangi bae kukulekat miaaru jedung se, aana Naajajalat mitue vengbanang hula aana bae Nateing niang!” ");
INSERT INTO beu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aarunge Petrus ebalet etatabit hula, “Niang, Nimang! Hula Aana aamina se, nandi Aat aaminat hama-hama. Na bae bihit Aaing bia niang, bot na bae Aajajala niang!” Petrus eserang aabeung ang naung di nu-nut vengbanang aulang. ");
INSERT INTO beu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ang muse, Yesus bot Egahing vala ang naung lamal tarus ila Saitun Dol taang bir nu angu mi, ene ꞌGetsemaniꞌ. Ang muse Yesus iat mateng hula, “Iini angami mihit Nading e Na hula va angmo mi sambajang.” ");
INSERT INTO beu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Seng ang muse, Yesus Ana Petrus, Yakobus, bot Yohanis iaru, e At hama-hamat ila. Uangu veng angu, Ekubang sar angu mang hula sia, se Omi etatabi dira angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ana iat mateng vengbanang hula, “Nekubang sar anga mang hula sia, se nomi dira angu ebele. Na mang hula aamina ba ae. Iini angami mihi e, iiava vengjaga.” ");
INSERT INTO beu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ang muse Ana lamal va aolat kabing dena, seng muse Ana meke mi iakuku muding e sambajang hula, “O, Nimang e! Hula Aana vengjali se, susalala alang anga Na ekang tevang ila vengaamina ekang. Na ateing etatabit hula, na iiba Aana bae ening jadi niang, niang. Ba hula bisa se, Aana susalala anga eebang metma Ne oola. Aarunge ekang Nejaling eamulung ekang ba, Eejaling ang ba eamulung.” ");
INSERT INTO beu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Seng ang muse, Ana bale ma Egahing vala tue angu harak, aarunge ini tiat udu sehi. Ang muse Ana iamehal iot tahi, senge Ana Petrus at mateng vengbanang hula, “E! Petrus! Etatalang ba aana tiat udu? Na uangmi mang kabing dena kolang, aarunge iinang tue bae iiava vengjagat kabing dena di niang! ");
INSERT INTO beu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Petrus, eeng angu venghapot ening jalat kabing dena hengi. Senge tahi e Nat hama-hamat vengjaga! Iinang tue iiomi angu etatabit hula, aaung-hama angu ba ening, aarunge iiboa iipi angu bae daeri niang. Base, miaaung iinang tue sambajang, e hula nehe iiabingit metma jasi-ahala omimi abaang se, iini bisat vengtahang iini bae Lahatala Eaaung-ehama angu bia niang.” ");
INSERT INTO beu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Seng ang muse, Yesus bot va sambajang minu maveng. Ana bot bale Lahatala abanang, e susalala angu ekang vengkilang Ana tevang ekang. ");
INSERT INTO beu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ang muse Ana bot bale ma Egahing vala tue angu harak. Aarunge inang tue bot bale tia tila, se ieng etatabit udu angu ebele. Ang muse Ana bale iamehal, aarunge inang tue bae ateing niang hula naba hur ba ini metma Emateng ang ebale. ");
INSERT INTO beu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Seng ang muse, Yesus ing vengkilang e, va bot sambajang emitue. Ang muse, Ana bale ma iamehal iot tahi. Ana hula, “Etatalang ba iinang tue jedung tiat udu sehi? Aaungba tahi! Naing anga ba Manusia Emamolo angu, nehe ba hula Naing aabali angu, ini hoa peang iila. Angase, ini hula Nadoi, e Nat ila metma nehe jasi ang naung iatang mi abaang. ");
INSERT INTO beu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aaungba tahi! Iieng angu ajala e angmo mi uuling hengi! Nehe ba hula Naing aabali angu, hoa iila. Ma e pi va ing harak!” ");
INSERT INTO beu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus jedung mateng aulang sehise, mibaroti se Yudas nehe toang rae ang naung iat hoa iila. Ini hoa angu peda, bot paru di ini baning, e hula Yesus adoi. Ini ening aulang, agama Yahudi enehe eele ang naung iparenta angu eamulung. Ing benang ba, agama Yahudi ebuang vala ekapala ang naung, guru agama ang naung, bot hada eboma ang naung. ");
INSERT INTO beu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas iat mateng iilat hula, “Iini uuling aaung-aaung! Nuba ba na amiku, Aing ba angu, aaungba iini Adoi! Aing angu nehe ba iini Aing aalaping angu!” ");
INSERT INTO beu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Base Yudas bot nehe toang angu ila angmi muse, ana tarus Yesus Aing harak, senge ana At mateng vengbanang hula, “Nimang Guru!” Seng ang muse Yudas ana Amiku. ");
INSERT INTO beu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ang muse nehe toang angu Yesus Aing venggoleng, e Adoit Aing pina. ");
INSERT INTO beu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aarunge Yesus Egahing vala nu epeda masiring e metma nehe nu aver angu patait asinga. Nehe ba iibat angu, agama Yahudi ebuang vala ang naung ekapala angu emalea. ");
INSERT INTO beu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ang muse Ana nehe toang rae ba hoa Adoit Aing pina angu iat mateng hula, “Tatalang? Iini hula Naing anga nehe jasi ka? Ba iini hoa Nadoi anga peda, bot paru di baning angu? ");
INSERT INTO beu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ved kakanap Na Lahatala Ehava hamulang mi iiavomung-iiapahang, aarunge nehe nu bae hoa Nadoi niang. Ma e aaungba Nadoi! Angu turangmi ue Lahatala Esurat hamulang mi hurak vengbanang iila.” ");
INSERT INTO beu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesus Egahing vala ang naung iuangmarit etatabi. Base ini tahit Onong bihit ila e, adut Enangkolang. ");
INSERT INTO beu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Angmi angu, nehe mehal kaneng di nu Yesus amota oa angmi amamulung. Ana noang talaling vengdena ba nu metma eboa angu vengtering. Nehe angu naung hula andi adoit aing pina. ");
INSERT INTO beu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Aarunge ini mang enoang angu ba vengpina. Ang muse ana edurat bihit ila, se ana uangmarit etatabi angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ang muse, ini Yesus Aing pinat At ila agama Yahudi ebuang vala ang naung ekapala angu ehava mi. Angumi nehe eele ang naung taing vengkumpul. Ing anguba agama Yahudi ebuang vala ekapala ang naung, guru agama, bot hada eboma ang naung. ");
INSERT INTO beu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Uangu veng ini Yesus Aing pinat At lamal angu, Petrus di amota oa angmi tamaang-tamaang amulung, ila agama Yahudi ebuang vala ang naung ekapala ehava mi. Andi masot mida lapa omimi, e nehe jajaga ba angmi ang naung imampi hama-hamat aad eang. ");
INSERT INTO beu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hava omimi angu, agama Yahudi ebuang vala ekapala ang naung bot nehe ba pengadilan agama mi karajang ang naung imampi itat mateng. Ing emangpi Evia aalaping e hula Yesus Aing ening ahala, se ini hula Aing hukung Ameang. Aarunge ini bae Eahalang iiba harak niang. ");
INSERT INTO beu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Base ini saksi toang iaru e hula, Yesus Aing ening abaang. Aarunge imateng ang naung emangpi bae hama niang. ");
INSERT INTO beu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Saksi aabeung di inang aaedeng angu, tahit mateng akal-kabulet vengbanang hula, ");
INSERT INTO beu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ni vengmee se, nehe anga mateng hula, ꞌEningse Lahatala Ehava hamulang ba nehe atang metma vengkarajang angu Na arahak. Senge mietang tue se, hava angu Na bale bakung atahing, aarunge bae nehe atang ba metma vengkarajang niang.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aarunge imateng ang naung, nu e se, bae nu e edadenang niang. ");
INSERT INTO beu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ang muse agama Yahudi ebuang vala ang naung ekapala angu, aloming tahit nehe emangpi ba pengadilan agama mi ang naung, iapang aadang mi, e ana Yesus adang taaning, vengbanang hula, “Nehe toang Aaing kalaa tila. Aarunge etatalang ba Aana mang taimang angu?” ");
INSERT INTO beu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus bae mateng kabing dena di niang. Ang muse agama Yahudi ebuang vala ang naung ekapala angu bale Yesus adang taaning hula, “Aanake vengbanang hengi! Aaing anga ba, etatabit Kristus, Lahatala Oal ba Ana turangmi vengpalai tila angu?” ");
INSERT INTO beu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus ebalet vengbanang hula, “Etatabi. Aing anguba Naing anga. Eningse iing emangpi uuling Nateing, Naing ba Manusia Emamolo angu, sorga Lahatala Eabang hamulang angmi Lahatala Atang tene oat mihi. Aing angu Ekavasa etatabit mieele! Eningse Naing metma Aing veng hama-hamat parenta pina! Seng ang muse, eningse Na sorga mi, bano majaa taang tahit hela.” ");
INSERT INTO beu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Vengmeet Yesus mateng aulang muse, agama Yahudi ebuang vala ang naung ekapala angu alil etatabi, anguba ana ekondo aavening angu abahak. Ang muse ana nehe ba pengadilan mi mihi ang naung iat mateng moring vengbanang hula, “Pi bae saksi aalaping niang iila! ");
INSERT INTO beu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Iini iiaver metma vengmee se, Aing ba vengbanang aulang e, niang? Ana ava ohit metma Lahatala Oal ening iila. Anga Lahatala ehura! Agama elamal-etahi eamulung se, nehe ba ava ening Lahatala At hama angu, nehe angu malekang ameang! Ba angase, iini hula vengbanang tatalang?” Ang muse ing emangpi vengbanang hula, “Nehe anga etatabit ahala! Base, malekang Aing hukung ameang!” ");
INSERT INTO beu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ang muse, nehe aaedeng ma Yesus Eng mi purung apang mi purung. Ini Eng angu vengtering, senge ini Aing bue Aing sabai. Bot ini Adang taaning hula, “Hula Aaing ba etatabit Lahatala Ehur vala se, Aanake ola ening. Nuba ba Aaing bue angu?” Seng ang muse, nehe ba Lahatala Ehava hamulang jajaga ang naung, ini iot hoa Yesus At ila muse, ing di taang Aing bue Aing sabai. ");
INSERT INTO beu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Uangu adana, Petrus jedung lapa omimi mihi sehi. Ang muse agama Yahudi ebuang vala ang naung ekapala angu emalea jangu nu hoa uuling se, ana aad eang sehi. Ana Petrus apang angu euling aaung-aaung, seng muse ana at mateng hula, “Vede aandi Yesus ba Nasaret Enehe angu amulung hama-hama. Etabi e, niang?” ");
INSERT INTO beu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aarunge Petrus ebalet hula, “Niang! Etatalang ba aana taaning aulang! Nehe angu na bae apang ateing niang.” Seng muse, Petrus hela lapa eviaha eele angmi tahi, ang muse, hangi di kukuleka. ");
INSERT INTO beu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Malea angu bot taang uuling Petrus ateing muse, ana nehe toang ba angmi angu iat mateng, hula, “Aing anga di, inehe nu ba anga!” ");
INSERT INTO beu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aarunge Petrus malavang hula, “Aana have buning! Na bae nehe uangu apang ateing niang!” Bae luung niang se, nehe nu angmi angu di bot Petrus at mateng hula, “Ee! Aana jedung akal mateng sehit hula, aana bae nehe ang naung iat hama-hama niang! We! Iing emangpi Galilea enehe, etabi e, niang?” ");
INSERT INTO beu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aarunge Petrus bot malavang hula, “We! Na natang ohi! Na bae nehe uangu apang ateing niang!” ");
INSERT INTO beu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ana mateng aulang muse, hangi di kukulekat miaaru. Ang muse, Petrus ana Yesus Ehur vede angu mivenganit, hula, “Hangi bae kukulekat miaaru jedung se, aana Naajajalat mitue tila.” Mivenganit aulang muse, Petrus baut eamamina. ");
INSERT INTO beu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kukuaveng muse, nehe emangpi pengadilan mi angu, itominu e hula Yesus ameang. Ang muse ini Aing partat At ila gubernur Pilatus apang aadang mi. ");
INSERT INTO beu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ila gubernur apang aadang mi muse, ana Yesus Adang taaning hula, “Tatalang? Etabit Aaing angu ba nehe Yahudi eRaja e, niang?” Yesus ebalet hula, “Etabi! Nimang gubernur vengbanang iila angu etabi.” ");
INSERT INTO beu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ang muse agama Yahudi ebuang vala ekapala ang naung gubernur at mateng hula, “Nehe anga ahalang ening bae kabing dena niang!” Bot ini Eahalang ang naung nu-nut vengbanang. ");
INSERT INTO beu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ang muse gubernur bot bale Yesus adang taaning hula, “Aana bae imateng ang naung venghele niang angu? Ini Aaing ening ahala toang amara tila. Aanake ebale hengi!” ");
INSERT INTO beu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aarunge Yesus bae ebale di niang, anguba gubernur angu mijongat etatabi. ");
INSERT INTO beu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tung kanap, hula nehe Yahudi ang naung pesta Paska ening angse, nehe toang angu ini nehe bui mi ang naung nu vengtalail, e gubernur ana ing ening ilva. ");
INSERT INTO beu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Uangu adana, nehe ba bui mi angu nu ene Barabas. Tura ini adoi angu, ana Roma eparenta angu malavang, bot andi nehe ameang. ");
INSERT INTO beu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pesta Paska ejol angu peang iila, angu ebele nehe toang gubernur Pilatus ebele ila e, moring vengbanang hula, “Nimang gubernur! Ved Paska hoa iila! Hula bisa se, nimang gubernur aana nehe bui mi angu nu aing ening ilva emenghula aana ening tung kanap angu edadenang!” ");
INSERT INTO beu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ang muse gubernur ibalet vengbanang hula, “Yaa! Na hula nuba ba ening ilva? Tatalang, hula na Aing ba nehe Yahudi eRaja anga Aing ening ilva se, iini vengjali e, niang?” ");
INSERT INTO beu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubernur Pilatus mateng aulang, se ana ateing iilat hula, agama Yahudi ebuang vala ekapala ang naung Yesus At hoa angu, iomi etatabit Yesus ealil angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aarunge agama enehe eele ang naung ini nehe toang angu ioomi taang, e ing emangpi gubernur Pilatus abanang hula, “Aing se ni nia! Barabas ang ba aing ening ilva!” ");
INSERT INTO beu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ang muse, gubernur Pilatus bale taaning, hula, “Hula aulang se, na malekang naba ba ening metma Yesus, ba iini Earut, ꞌYahudi eRajaꞌ angu adana?” ");
INSERT INTO beu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ang muse ing emangpi moring hama-hamat vengbanang hula, “Ening mang Ameang! Aing metma leut vengpaku!” ");
INSERT INTO beu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Gubernur Pilatus bot taaning hula, “Se, Eahalang naba? Na eahalang vengparisa tila, aarunge na bae Eahalang iiba harak niang!” Aarunge ing emangpi moring etatabit vengbanang hula, “Ening mang Ameang! Aaungba Aing metma leut vengpaku!” ");
INSERT INTO beu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gubernur Pilatus hula, nehe toang angu iomi ening sanang, angu ebele ana Barabas angu aing ening ilva, ijaling angu eamulung. Ang muse ana nehe jajaga ang naung ing parenta e cambuk metma Yesus Aing bue Aing sabai. Aing bue Aing sabai seng muse, bot tentara ang naung Yesus Aing medi, e hula At ila Aing metma leut vengpakut Ameang. ");
INSERT INTO beu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ang muse, tentara ang naung Yesus Aing masiring ila ilapa omi eele angu mi. Angumi, iserang batalion nu mi angu ini iaru. ");
INSERT INTO beu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Seng ang muse, ini kondo kaana aavening nu metma Yesus enang Ana pake, emenghula raja ang naung biasat pake angu edadenang. Seng muse, ini te emaang veng medi e, taing bikit metma tompi ening. Seng ang muse tompi maang angu ini metma Yesus Ong taang adimung, e ening At mamulal emenghula raja nu ini uhavede aing songgar etompi ma enang ana pake angu edadenang. ");
INSERT INTO beu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bot ing emangpi Aing haromat At mamulal, bot hula, “Tabe Yahudi eRaja!” ");
INSERT INTO beu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bot ini ibabakeng tout hela Yesus apang aadang mi Aing haromat. Seng ang muse ini Eng mi purung Apang mi purung bae alolang niang. Bot ini te kabura metma Ong angu veng bue. ");
INSERT INTO beu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ini At mamulal ajajasing seng muse, kondo aavening jasi angu ini bale aahit medi. Senge ini bot Ekondo angu bale metma Enang Ana pake. Ang muse, ini At ila bendar Yerusalem eahalang, e Aing metma leut vengpakut helet vengaamina. ");
INSERT INTO beu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ini Yerusalem mi kaluar lamal ila via hahama mi muse, ini nehe nu aing harak. Ene Simon. Aing angu bendar Kirene enehe. Aing ba Alexander bot Rufus imang angu. Ana uhavede hula bendar Yerusalem mi ila, aarunge tentara ang naung aing pina, senge aing paksa ot Yesus Eleut angu tevang. ");
INSERT INTO beu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ini Yesus Aing masiring ila mana nu angu mi, ene Golgota. Evengbanang hula, ꞌNehe ong kira emana.ꞌ ");
INSERT INTO beu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Angumi, ini hula anggor kalikil obat venggaot metma Yesus Enang Ana na, e Ana bisa Edira angu vengtahang. Aarunge Yesus bae na niang. ");
INSERT INTO beu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ang muse, ini Yesus alalat metma leut vengpaku. Oma oda turinu kuaveng muse, ini leut angu bakung atahing. Ang muse tentara ang naung bing ening, e ateing hula nuba ba Yesus Ekondo angu medi. ");
INSERT INTO beu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ang muse ini aarang nu metma Yesus Ong adana angmi paku, e mihurak vengbanang hula, “Anga nehe Yahudi eRaja” Angu ba ini metma e eela ening e, Yesus Aing hukung. ");
INSERT INTO beu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Angmi angu, nehe bui mi di aaru ini ing pakut iameang, nu Yesus Etene oa, nu Ebajaul oa. ");
INSERT INTO beu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ening aulang e ini naba ba Lahatala Esurat hamulang mi vengbanang iila angu akanap hula, “Ini Aing ening emenghula nehe jasi edadenang.” ");
INSERT INTO beu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nehe emangpi ba angmi lamal ang naung, uuling Yesus leut venghili angu ateing. Ang muse ini iong avavili aulange hura manantit ening Yesus ava aaloring vengbanang hula, “Ee! Aana hula Aana bisa Lahatala Ehava hamulang angu arahak, senge mietang tue se, Aana bale bakung atahing, etabi e, niang? ");
INSERT INTO beu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aanake leut angu taang hela, e Aava vengahit ening lohi! Hula aulang, senge niomi etatabit vengbanang hula Aaing angu etatabit Lahatala Oal.” ");
INSERT INTO beu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Agama Yahudi ebuang vala ekapala ang naung bot guru agama ang naung di Yesus Ehura Emanantit hula, “Ana nehe aabeung ening lohi tila, aarunge Ana bae Ava ening lohit jadi niang! ");
INSERT INTO beu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ana Ava ohit hula Aingba, ꞌKristusꞌ, Aing angu nehe ba turangmi Lahatala vengpalai tila angu. Nehe aabeung hula, Aing angu Israel eRaja. Hula etabit aulang se, Ana leut angu taang hela e pi ateing hengi. Aulang senge piomi etatabit Aing vengaanamang.” Nehe aaru ba leut venghili Yesus At hama-hama angu di Ehura Emanantit aulang. ");
INSERT INTO beu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ang muse, kua kete mana angu vengtering miiipi ved hahama mi ila oda tue vedba. ");
INSERT INTO beu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Oda tue vedba muse, Yesus moring Aram ehur mi vengbanang hula, “Eloi-eloi! Lema sabaktani?” (Evengbanang hula, Aaingba Nimang! Aaingba Ne Lahatala! Etatalang ba Aana aamota ma Nenang Naing vengkilang alang?”) ");
INSERT INTO beu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nehe aaedeng ba papeang angmi angu Yesus Amal angu vengmee. Ang muse ini hula, “He! Iini vengmee hengi! Ana Elia, Lahatala Ehur vala tura angu earu sehi.” ");
INSERT INTO beu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ang muse, nehe nu bihit ila lotang medi e, metma anggor kalikil mi abaang. Senge lotang angu metma doba etupa mi tangi, senge taning mida Yesus ibar tupa angu dei e, Ana kadumi. Ang muse nehe angu mateng hula, “Kilang e pi uuling hengi! Misavaka eningse Elia hoa e At leut angu taang hela.” ");
INSERT INTO beu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ang muse Yesus bot bale moring, seng muse Ana aamina. ");
INSERT INTO beu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lahatala Ehava hamulang mi, noang talaling eele nu hilit metma Lahatala Ekamar hamulang angu venghabal. Yesus Eeng abaang muse, noang talaling eele angu takahit siat oang aaru, atelat hela alolang veng abaang. ");
INSERT INTO beu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Golgota mi angu, nehe jajaga enehe eele nu ue Yesus Eleut eela angmi tahi. Ana uuling Yesus Eaamina angu ateing muse, ana mijonga. Senge ana vengbanang hula, “Ado! Nehe anga, etatabit Lahatala Oal!” ");
INSERT INTO beu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Bot nehe jangu aaedeng angu, ola mi uuling Yesus Eaamina angu ateing. Ing angu ba tura Galilea mi Yesus bot Egahing vala ang naung imampi ing vengbalenta angu. Ing anguba Salome, Maria ba Magdala aabang enehe angu, bot Maria ba nu angu (Aing ba Yakobus kuar bot Yoses iva angu), bot jangu aabeung toang ba Yesus amulung hama-hamat hoa Yerusalem mi angu. ");
INSERT INTO beu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ang muse, nehe nu via valaping e, hula Yesus Ebaring angu leut taang at hela. Nehe angu ene Yusup. Aing angu bendar Arimatea enehe. Bot aing angu di Majelis Pengadilan agama Yahudi angu e ia atang. Aing angu omi aaung. Bot Lahatala Eparenta pinat metma Enehe toang adana, ejol angu di ana ue ading sehi. Yesus Eaamina angu jumad veng. Emitobang angse nehe Yahudi ang naung ived sambajang adana. Angu ebele ba jumad veng angu, Yusup hula Yesus Ebaring angu ematurat at hela hengi. Ang muse ana ava ening barani, e ila gubernur Pilatus abung Yesus Ebaring angu banang. ");
INSERT INTO beu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gubernur Pilatus vengmee Yusup banang aulang muse, ana mijonga. Ang muse ana hula, “Ah! Nehe angu uuser-uuser aaminat aulang! Na hula have bae aulang niang!” Ang muse ana nehe gahing ila nehe jajaga enehe eele angu earu, e adang taaning hula, “Tatalang? Yesus angu aamina tila, e jedung?” ");
INSERT INTO beu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nehe jajaga enehe eele angu vengbanang hula, “Nimang, Ana etabit venangmi aamina tila.” Gubernur Pilatus vengmeet aulang muse, ana vengjalit Yusup ot Yesus Ebaring angu medit at ila. ");
INSERT INTO beu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ang muse Yusup ana Golgota mi ila muse, ana Yesus Ebaring angu leut taang at hela. Ana noang hiba ebili eele anguba metma Yesus Ebaring angu balolit ening aalus-aalus. Uangu adana, ini uhavede daang hiba nu var abu eele omimi venglabat medi. Ang muse ini Yesus Ebaring angu abaning ila metma daang angu mi maso. Seng ang muse, ini var halala eele nu aoring metma daang eviaha angu vengtering. Seng muse Yusup iimal ila. ");
INSERT INTO beu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Uangu veng, Maria ba Magdala enehe angu bot Maria ba eabeung (aing ba Yoses iva angu), di ila angmi. Oleve mana ba ini Yesus Ebaring ang metma mi mea angu euling bot venganit aaung-aaung. ");
INSERT INTO beu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Emitobang, sabtu veng, aing angu nehe Yahudi ang naung ived sambajang. Vedba tila muse, Maria ba Magdala aabang enehe angu, Maria ba eabeung (aing ba Yakobus iva angu) bot Salome, inang tue ila jal manema beli, aulange tobang se, baning ila metma Yesus Ebaring angu vengbokong, nehe Yahudi ehada angu eamulung. ");
INSERT INTO beu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ang muse minggu kukuaveng, inang tue daang angu mi ila. ");
INSERT INTO beu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Via hahama mi muse inang tue itat mateng hula, “Ee! Eningse nuba ba bisa toang moling var eele angu aoring metma daang eviaha angu eahalang? Se pinang tue anga etabit bae daeri niang, se var angu etatabit eele!” Aarunge ini ila angmi, e ini uuling ateing se, var angu ava aoring iila. ");
INSERT INTO beu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ang muse inang tue daang angu mi maso. Aarunge inang tue mibarotit etatabi, se ini uuling ateing se nehe kuar nu itene oa angmi mihi sehi ekondo angu majaat huring jara. ");
INSERT INTO beu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ang muse nehe kuar angu iat mateng vengbanang hula, “Ekang iiuangmari ekang! Na ateing se, iinang tue hoa hula Yesus ba Nasaret Enehe angu, ba ini Aing metma leut venghelet Ameang angu Aing aalaping. Ana bae angami niang iila, se Ana bale aabeta tila angu ebele. Ma, iinang tue ba iina euling, mana ba ini Yesus Ebaring metma mi mea angu, osing iila. ");
INSERT INTO beu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ba, aaungba iinang tue uuser bale ila! Ila Petrus iimal iat mateng hula, Yesus bale aabeta tila. Ana lamal eturat ila Galilea mi. Eningse ini angmomi Yesus Aing harak, emenghula turangmi Ana iiat mateng iila angu edadenang. Ba, aaungba iinang tue bale ila!” ");
INSERT INTO beu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nehe tue angu uuling se mana angu etatabit osing muse, ini mibaroti. Ang muse inang tue bihit bale kaluar hela. Ang muse inang tue uuser ila. Ini bae via mi nehe iiba at mateng di niang, se ini iuangmarit etatabi angu ebele. ");
INSERT INTO beu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Minggu kukuaveng angu, Yesus Ava metma Maria ba Magdala enehe angu ematurat etubing, aing ba tura Yesus setang bititu aterit aing mi kaluar hela eahalang angu. ");
INSERT INTO beu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ana uuling Yesus ateing seng muse, ana bale ila nehe emangpi ba tura Yesus Amulung ang naung iat mateng. Yesus Eaamina angu mivengani se, iomi dira bot ieng oono hela, angu ba ini jedung baning taing vengkumpul sehi. ");
INSERT INTO beu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ang muse Maria iat mateng hula, “Etatalang ba iini jedung iiomi dira sehi angu? Ekang iiomi dira ekang, se Yesus bale aabeta tila! Vede kakai anga, ba na Aing harak iila!” Aarunge ing emangpi vengbanang hula, “We! Aana akal mateng!” ");
INSERT INTO beu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ang muse, Yesus Egahing vala aaru lamal aabang nu mi ila. Via hahama mi muse, Yesus ila Ava metma oleve itubing. Aarunge Ana Ava aboit aabeung. Aarunge kabing dena muse, oleve di Apang ateing. ");
INSERT INTO beu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ang muse oleve bale ila iserang ang naung iat hubait hula, “Ee! Iini vengmee hengi! Vede kakai anga, noleve via mi Yesus Aing harak!” Aarunge iserang ang naung emangpi oleve ihur ebalet hula, “Ee! Oleve ekang akal mateng aulang ekang!” ");
INSERT INTO beu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Seng muse bot, Yesus Egahing vala arinu belta nu angu, mihit naadang sehise, Ana hoa ing harak. Ana iat mateng vengbanang hula, “Ah! Iing anga etatabit iiong aanamang! Nehe iiat hubai tilat hula, ini uuling ieng taang Nateing iila, aarunge iini bae ihur angu e etabit vengbanang niang! Iini hula ing emangpi akal mateng! Ba! Vede anga Naing ba hoa iila. Na etabit aamina tila, aarunge angase, Na bale aabeta tila. Ba iini iieng uuling. ");
INSERT INTO beu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ba angase iini malekang ila por alolang anga miiipi, e Nesarenta aaung-hama angu, metma nehe emangpi veng iat hubai. ");
INSERT INTO beu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nuba ba omi metma Naing vengaanamang, bot nehe aing sarani, eningse Lahatala Ana aabetang ejajehing angu metma ma enang. Aarunge nuba ba bae omi metma Naing vengaanamang niang, eningse Lahatala Ana aing hukung, anguba Ana atobang aing metma sorga Lahatala Eabang hamulang angu eola. ");
INSERT INTO beu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bot nehe ba omi metma Naing vengaanamang angu, eningse ini tanda herang emangpi angu ening, e nehe emangpi ateing hula kavasa ba ing veng angu etatabit Lahatala abung hoa. Angu ebele, eningse ini bisa Nene angu paket metma setang ateri, bot eningse Lahatala ening hur aabeung ba ini bae ateing niang angu di ini bisa veng mateng. ");
INSERT INTO beu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bot hula ini duming amia vengpina e, rasong ba ini na di se, ini bae silaka niang. Bot hula ini iatang metma nehe dila ang naung ing taang mea angse, nehe angu malekang mona. ");
INSERT INTO beu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ana Egahing vala ang naung iat mateng seng ang muse, Lahatala Ana Yesus Aing ohit sorga mi mida. Angumi Ana Lahatala atang tene oat mihi, e Lahatala At hama-hamat nehe parenta. ");
INSERT INTO beu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ang muse Egahing vala ang naung, Eparenta angu eamulung. Ini ila mana kanap Yesus Esarenta aaung-hama angu metma nehe emangpi iat hubai. Bot Lahatala kavasa metma ma inang, e ini tanda herang emangpi angu ening, emenghula Yesus iat hubai tila angu edadenang. Ang muse nehe toang rae angu iomi metma Yesus vengaanamang, se ini ateing iilat hula, sarenta aaung-hama angu etatabi. Nehe jangu tue angu ila Petrus iimal ing harak muse, nehe kuar ba vede daang omimi iat mateng angu inang tue metma ing emangpi veng iat hubai. Seng ang muse, Yesus Ana Egahing vala ang naung ing parenta, e ini ila Esarenta aaung-hama angu metma mana emangpi mi vengmaring, ila por etupa ang naung taang. Sarenta aaung-hama anga via matubing, e Lahatala Ana nehe ening lohit metma ijasi-iahalang ang naung eola, e ing metma aabetang ejajehing angu omimi. Sarenta aaung-hama anga etatabi. Angu ebele ana vengtahang ejehing-emeang, bae eseng veng niang. ");
INSERT INTO beu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","3","Nimang Topilus ba oomi aaung. Naing ba Lukas, na aaing aada. Ne buku ba tura angu, emangpi ba Yesus Eaabetang omimi angu na hurak iila. Ana ening iila, bot emangpi ba ehalomang Ana vengbanang iila angu, na hurak. Ana Eetvala ang naung ing vengtalail. Nehe Aing ening dira tila bot Ameang, aarunge Lahatala ening bale aabeta. Uanguveng Ana bale aabeta muse, Ana ava metma Eetvala ang naung itubing. Ini uuling Ateing mi aaedeng ila mietang ari buta, ini ateing iila, etatabit Ana aabeta tila. Ana bot iat mateng hula, Lahatala angu emenghula raja ba parenta pina angu edadenang. Lahatala ERoh Hamulang angu Ekavasa omimi angu ba Ana ing gahing. Angu emangpi angu, ba na hurak iila. ");
INSERT INTO beu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Minu adana, Yesus bot Eetvala ang naung ini taing vengmihit hama-hama doe Saitun dol taang. Ana ing parentat hula, “Vengani! Tura angu Yohanis ana mang jar ba metma nehe sarani, aarunge angase Lahatala Ana hula ening miaaung-mihama, se ved aaedeng maveng se, Ana ERoh Hamulang angu metma maiinang angu ebele. Base, iini malekang ading. Iini ekang lamal bendar Yerusalem anga eahalang ekang. Aarunge iini angami ading sampe Nimang Ana ERoh Hamulang metma iiomi mi tila angu edadenang. Bot Nandi metma iiat hubai tila angu eamulung.” ");
INSERT INTO beu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesus bot Eetvala ang naung imampi taing vengkumpul sehise, ini Adangtaaning hula, “Nimang! Ni hula taaning alang: Turang jamang negara Israel ava parenta angu Nimang vengani sehi. Aulang ba, angase Nimang hula ning ening lohit metma Roma eparenta angu eahalang e, ni malekang jol aabeung ba ading?” ");
INSERT INTO beu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ang muse Yesus ibalet hula, “Ejol angu iini ekang veng taaning ekang. Nimang ba enang kolang ejol angu veng ator. ");
INSERT INTO beu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aarunge kabingdena maveng se, Lahatala ERoh Hamulang angu hoa iiomi mi, senge kavasa angu iing veng. Sengila se iini ila naba ba Na ening iila angu vengmaring metma nehe toang ba bendar Yerusalem mi bot aabang ba propinsi Yudea mi bot propinsi Samaria mi ang naung bot ila por ola ang naung taang veng iat hubai.” ");
INSERT INTO beu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mateng aulang seng muse, Yesus iapangadang mi ava ohit burang mi mida. Ana ava ohit ila bano Aing vengtering, angmuse ini bae uuling ateing niang iila. ");
INSERT INTO beu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ini jedung burang euuling sehi se mibaroti se, nehe aaru pakiang majaat hamulang pake ue iabar oa ang mi tahi sehi. ");
INSERT INTO beu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nehe aaru angu mateng hula, “He! Iing ba Galilea enehe! Etatalang ba iini jedung taninggar burang euuling angu? Vede Yesus Ava ohit burang mi mida ila bano Aing vengtering iini uuling ateing iila. Iini uuling ateing Ana mida tatalang se, Ana bale hela di eningse aulang.” ");
INSERT INTO beu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Seng angmuse, Yesus Eetvala ang naung Saitun dol taang bale hela ila bendar Yerusalem mi. Dol angu bendar eola oma kilo nu. ");
INSERT INTO beu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ila bendar mi muse, ini hava nu mi mida mihit vengtahang. Angmuse, ini hava omi atela ang mi mida. Etvala ang naung iene benang ba: Petrus, Yohanis, Yakobus, Andarias, Pelipus, Tomas, Bartolomeus, Mateos, Yakobus (Alpius oal), Simon (Selot enehe), Bot Yudas (Yakobus oal). ");
INSERT INTO beu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ing emangpi biasat taing vengmihi tominu sambajang hama-hama. Maria Yesus iva, nehe jangu aaedeng, bot Yesus ekaku ang naung imampi sambajang hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ved nu adana, ini bot taing vengmihi oma inang ratu nu ari aaru. Petrus ana aloming tahi senge, ana mateng hula, ");
INSERT INTO beu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Niva-nimang bot nekaku naung! Yudas ba tura erombongan iat ila Yesus adoi angu, iini jedung vengani sehi. Emangpi ba Yudas ening angu, etabit malekang jadit aulang. Se turang jamang mi Lahatala ERoh hur metma raja Daud omimi senge nababa metma Yudas adana angu ana hurak aulang iila. ");
INSERT INTO beu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tura aing angu pi iiba. Andi piat karajang.” ");
INSERT INTO beu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Aarunge uanguveng Yudas ana Yesus Aing aabali sengmuse, eseeng angu ana metma meke kabingdena beli. Angmuse, meke angu metma emana aamina ening se ana angu mi adodut baat hela sampe atou takahi, bot atou sar ang naung emangpi kaluar. ");
INSERT INTO beu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Angmuse nehe ang naung itat sarenta angu ebele nehe emangpi ba bendar Yerusalem mi ang naung di Yudas eaamina angu vengmee. Anguba meke angu ini Ibrani ehur mi vengbanang ꞌAkeldamaꞌ evengbanang hula, angu ꞌMeke veꞌ.) ");
INSERT INTO beu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petrus bot mateng tarus hula, turang jamang mi raja Daud hurak aulang metma eMasmur buku tajaning angu mi tila. Ana hurak hula, ꞌKilange emihing mana angu, ana osing; nehe iiba ekang ang mi mihi ekang.ꞌ Angmuse ana bot taang hurak hula, ꞌKilange karajang angu, ini metma nehe aabeung ba enang.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Base, pi malekang nehe valaping metma Yudas etelul ening. Nehe ba piamulung hama-hamat lamal luung iila. Malekang nehe ba Mutu Yesus At aabeta bot Amulung taang-taang mi ila, mulai Yohanis Yesus Aing sarani mi. Andi bot malekang uuling eng taang ateing, hula, Mutu Yesus aamina bot bale aabeta tila, bot Ana bale ila sorga mi mida, anguba pi nu vengtalail.” ");
INSERT INTO beu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petrus mateng aulang seng muse, nehe ba imampi taing vengkumpul angmi angu ini nehe aaru iene vengbanang. Nehe nu ene Matias, bot nu angu, ene Yusup (ba ini ibiasat eaarut Barsabas; ene nu angu, benang ba Yustus). ");
INSERT INTO beu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Seng angmuse ini sambajang hula, “Nimang doe sorga mi! Nehe emangpi iomi Nimang ateing etatabi. Yudas ana ekarajang veng ea angu ebele ana aamina. Base Nimang Ana nehe aaru anga metma ni tubing, nuba ba ni vengtalail metma Yudas etelul ening, senge ni hula aing ohit metma Mutu Yesus Eetvala ening.” ");
INSERT INTO beu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Seng muse nehe aaru iene angu ini bing amaang. Angmuse bing angu Matias ba vengbaa. Angu ebele ini aing ohit metma etvala ening inang arinu belta nu angu imampi hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","2","Nehe Yahudi ang naung ived aaung ba ini vengbanang hula, ꞌPentakostaꞌ angu veng, nehe emangpi ba Mutu Yesus Eaamulung ang naung taing vengmihi hava nu mi. Mibaroti ini vengmee se burang mi arapi amal hoa emenghula eenar aaribut edadenang. ");
INSERT INTO beu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Senge bot ini uuling ateing se emenghula aad huring edadenang ekalambal-kalambal ila ing emangpi nu-nut iong taang. ");
INSERT INTO beu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ing emangpi Lahatala ERoh ing vengbaa. Angmuse ini mulai nehe aabeung ehur eapapahing metma itat mateng, naba ba Roh metma mainang angu eamulung vengmateng. ");
INSERT INTO beu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Uanguveng angu, Yahudi enehe toang aabang kanap por alolang mi iipi angu ue hoa Yerusalem mi taing vengkumpul. Iomi vengariak Lahatala Eamulung. ");
INSERT INTO beu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ini na eamal angu vengmee muse, ini hoa mana angu mi taing vengkumpul. Bot ini nu-nut vengmee se ihur ba Mutu Yesus Enehe ang naung vengmateng. Angu ebele ini mijonga. ");
INSERT INTO beu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ing emangpi taninggar, seng muse ini mateng hula, “Ah! Nehe ba mateng ang naung, ing emangpi Galilea enehe. ");
INSERT INTO beu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Aarunge etatalang ba pi vengmee se ini pi aabang hur ba nu-nut vengmateng angu? ");
INSERT INTO beu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ping anga, propinsi Partia, Media, Elam, Mesopotamia, Yudea, Kapadokia, Pontus, Asia, ");
INSERT INTO beu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Prigia, Pamfilia, Masir, Libia bendar Kirene abung angu; ping iiba angu bendar Roma mi hoa; iiba angu Kreta por taang ba hoa; bot Arab mi hoa. Ping iiba Yahudi enehe, bot iiba angu lelang abeung enehe ba agama Yahudi maso tila angu. Aarunge ping emangpi vengmee se, nehe ang naung pihur ba nu-nut metma na mura niang ba Lahatala ening iila angu vengmateng. Baa! Pi mijongat etatabi oo!” ");
INSERT INTO beu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ing emangpi taninggar, senge ini nu-nut itadangtaaning hula, “Etatalang ba ening aulang, ee? Evengbanang hula naba ba angu?” ");
INSERT INTO beu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aarunge nehe iiba angu ijajahi ening. Nehe ang naung hula, “Ee! Ekang iuuling ekang! Se ing angu, naboa ba ue!” ");
INSERT INTO beu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Angmi angu Petrus bot Mutu Yesus Eetvala aabeung arinu belta nu angu di ue. Angmuse, ana tahit nehe toang ba ue ang mi taing vengkumpul angu iat mateng. Ana amal aeelet iat hubai hula, “Nimang iimal, niva iimal, bot nekaku naung! Ing ba Yahudi enehe, bot iing ba hoa bendar Yerusalem anga mi mihi! Iiavel helet aaung-aaung senge ne mateng anga vengmee, se na hula hur aaung-hama metma iing emangpi veng iiat hubai. ");
INSERT INTO beu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Iini ekang vengiiomit hula nehe anga naung ue naboa ekang. Bae aulang niang! Vengani, se nehe iiba bae kukuaveng naboa niang. Se anga uhavede oda turinu! ");
INSERT INTO beu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iini vengmee se nehe anga naung iihur ba nu-nut metma itat mateng. Emolo angu alang: Uanguveng, Lahatala Ana Ehurvala Yoel Aing metma na anga vengbanang iilat, hula: ");
INSERT INTO beu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ꞌLahatala vengbanang hula, “Eningse ved evengseng muse, Na Ne Roh angu bokong metma nehe emangpi enang, Iioal mehal bot iioal jangu ang naung, eningse Na metma Ne etvala ening. Iinehe kuar ang naung, eningse naba ba Na metma itubing angu ini uuling ateing. Bot iinehe boma ang naung, eningse naba ba Na hula metma itubing angu ini vengiipal. ");
INSERT INTO beu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ila ved hula evengseng angumi se, Ne malea ang naung Na Ne Roh metma ma inang. Na metma mehal di emangpi enang, Bot Na metma jangu di emangpi enang. Naba ba Na metma iat hubai angu eningse ini vengmateng. ");
INSERT INTO beu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","21","Eningse Lahatala Eved hoa. Aarunge ved angu bae hoa jedung se, ematurat Na na muraniang ang naung ening doe atelat burang mi. Na mura niang emenghula ved aamina edadenang; bot uuru di tenat emenghula ve edadenang. Na bot na emangpi ba mura niang angu por alolang anga taang ening. Na angu naung, emenghula ve, bot aad edadenang, ehara tutung bot ebanak di ava apaleteng emenghula bano edadenang. Eningse Lahatala Eved eele ba mura niang angumi se, nehe ba Lahatala Abanang etatabit ot ioang moling, angu ba Lahatala Ana ing ening lohi.ꞌ ” Aing angu, ba turangmi Yoel vengbanang iila. ");
INSERT INTO beu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nekaku naung iing ba Israel enehe! Iavel hele senge naba ba na hula vengbanang anga vengmee. Lahatala Ana Yesus Nasaret enehe angu matubing iila. Ni ateing iilat hula, angu etabi, se Lahatala Ana Ekavasa metma Yesus enang Ana na mura niang ening ni uuling nieng taang ateing iila. Iing di na anga uuling ateing iila, se Yesus Ana iihahama mi na mura niang ang naung ening iila. ");
INSERT INTO beu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aarunge iini Aing ening Ana aamina. Nehe jasi ang naung iimampi hama-hama Aing metma leut vengpaku. Emangpi ba iini ening metma Yesus adana angu, turang jamang mi Lahatala vengbanang iila, se etabit Eomi eamulung angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Iini ening aulang senge Ana etatabit vengaamina. Aarunge Lahatala bae vengkilang Yesus aaminat milalu niang. Se, Lahatala Ana Aing vengahit metma aaminang ekavasa angu eahalang, bot Lahatala Aing ening bale aabeta. Se aaminang ekavasa bae Aing vengtahang niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Turang jamang mi raja Daud ana hurak iilat metma Yesus adana angu hula alang: ꞌNa ateing se Lahatala kilang ue nat toang pina, angu ebele na nu bae bisat nabaang jadi niang, se Lahatala kilang ue naing veng. ");
INSERT INTO beu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Angu ebele nomi mang eele; base na Aing tajaning Aing palevang, bot na kilang Aing anguba ading. ");
INSERT INTO beu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ana bae noramana vengkilang nehe aamina ang naung imana mimihi niang. Bot Lahatala bae Enehe Hamulang ebaring angu vengkilang daang omimi manisa niang. ");
INSERT INTO beu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Aabetang evia emamolo angu Lahatala metma netubing iila. Angu ebele nomi mang eele, se, Lahatala ue nat toang pina angu ebele.ꞌ Anguba turang mi raja Daud hurak iila. ");
INSERT INTO beu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nekaku naung neserang naung! Angase naba ba, metma boma Daud adana angu na metma iiat mateng tarang. Raja Daud angu aamina tila, bot aing taloul iila. Edaang angu jedung ue pi hahama mi hoa vede ved anga venghili. ");
INSERT INTO beu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Raja Daud angu di, Lahatala Ehurvala ba nu. Bot ana ateing se, Lahatala Ana at palai tila hula, etabaning angu nu eningse parenta pina, aing angu Nehe ba turangmi Lahatala matubing iila. ");
INSERT INTO beu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Uanguveng, Daud ana naba ba ue apang oat hoa sehi angu euuling. Bot metma Nehe ba Lahatala Ana vengpalai tila hula gahing hoa adana di ematurat Daud ana vengbanang. Eningse Nehe angu aamina, aarunge Ana bot bale aabeta. Bot Daud di vengbanang hula Nehe angu Lahatala bae vengkilang nehe aamina ang naung imana mi mihi niang, bot Ebaring angu di bae manisa niang. ");
INSERT INTO beu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nehe ba Daud vengbanang angu, benang ba Yesus angu! Eamina omimi angu Lahatala Aing ening bale aabeta tila, bot Ebale aabeta angu ni uuling nieng taang ateing iila! ");
INSERT INTO beu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bot angase Lahatala Ana Yesus Aing ohi senge pangka mieele-mibalolu angu pina tila. Angu ebele Ana doe mana ba Lahatala vengharaka tila angu mi mihi. Bot Imang ERoh Hamulang angu, Imang metma ma Enang iila, turang mi Lahatala palai tila angu eamulung. Angu ebele Yesus Ana ERoh Hamulang angu, metma ping di mapinang. Base, vede anga iini vengmee bot iini uuling ateing iila se, Lahatala Ana ERoh metma maninang iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daud bae sorga mi mida niang, aarunge ana hurak hula, ꞌLahatala Ana ne Manaing angu At mateng hula, “Aana Netene oa angmi mana ba Na vengharaka tila angumi mihi, ");
INSERT INTO beu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sampe Na ening nehe ba omi metma Eekakurang ang naung emangpi iora vengholong bot Aaing vengtou.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Angu ebele Israel enehe ang naung emangpi malekang ateing hula Yesus ba iini metma leut vengpaku ening aamina angu, Aingba Kristus, Nehe ba turang mi Lahatala Ana vengpalai hula gahing hoa angu. Bot Aingba piManaing Eele-balolu!” ");
INSERT INTO beu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Vengmeet aulang muse, nehe ang naung iomi etatabit bae sanang niang. Angmuse ini Petrus bot etvala aabeung ang naung iadangtaaning hula, “Kaku naung! Ni malekang naba ba ening hengi?” ");
INSERT INTO beu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Angmuse Petrus ibalet hula, “Iini malekang iiava vengbaroti, sengila ba bale Lahatala amulung. Iini malekang hoa senge nehe jar metma iing sarani hengi, aulange matubing hula, iini bot bale Yesus Kristus Evia aabetang angu eamulung iila. Angu di bot matubing hula, iiahalang ang naung Lahatala vengahi tila. Sengiila ba Lahatala Ana ERoh Hamulang angu metma maiinang. ");
INSERT INTO beu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Se na angu Lahatala vengpalai angu metma nehe emangpi ba metma Enehe ening iila angu mainang. Ening aulange, Epalai angu, metma maiinang bot iitabaning ang naung di inang. Ana bot palait metma nehe aabeung ang naung di inang.” ");
INSERT INTO beu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus jedung iat mateng aavening vengbanang hula, “Angase aabetang via emamolo angu nehe toang iabar ma enang iila. Angu ebele iini malekang iiava vengani, senge iini ekang nehe jasi ahala ang naung ivia angu eamulung ekang. Aarunge iini malekang Lahatala Evia molo anguba eamulung. Ening aulange Lahatala Ana iing ening lohi bot At aabeta ejajehing.” ");
INSERT INTO beu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Angmuse nehe toang ang naung Petrus emateng metma iadana angu ini metma iomi mi tila. Angmuse ini Yesus Evia aabetang angu amulung, bot ini banang senge nehe jar metma ing sarani. Ved angu veng nehe ba omi metma Yesus vengaanamang angu ribu tue. ");
INSERT INTO beu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ini nehe aabeung ba Yesus Amulung angu iat taing vengkumpul hama-hama. Ved kakanap ini kalakat Mutu Yesus Egahingvala ang naung ivomung angu venghele. Ini sambajang hama-hama. Bot naadang hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mutu Yesus Eetvala ang naung tanda herang toang ening anguba nehe emangpi jonga bot iuangmari. ");
INSERT INTO beu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nehe ba Mutu Yesus Evia aabetang eamulung ang naung taing veng mana nu mi mihi bot aabeta tominu-tahanu, bot naba ba ing veng angu ini paket hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Senge iiba angu ibarang bot ikavasa ang naung aabali, sengee eseeng angu ini metma nehe ba omi metma Lahatala vengaanamang ang naung inang. ");
INSERT INTO beu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ved kakanap ini Lahatala Ehava Hamulang mi taing vengmihi. Iomi mang lebal angu ba ini naadang teamulung hava nu mi ila hava nu mi. Bot ing emangpi aabeta toang-mamoling, bot ini bae iatang aanamang niang. ");
INSERT INTO beu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ved kakanap ing emangpi tajaning-palevang at mida Lahatala enang bae esia-epodu veng niang. Nehe ba bae ing veng hama-hama niang ang naung di emangpi ing vengsanang etatabi. Ved kakanap Lahatala Ana nehe ening lohi, angu ebele nehe ba omi Mutu Yesus vengaanamang angu tatoang-tatoang. ");
INSERT INTO beu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ved nu adana, oda tue vedba, Petrus bot Yohanis oleve Lahatala Ehava hamulang mi ila senge hula nehe aabeung ang naung imampi sambajang. ");
INSERT INTO beu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ini hula viaha eele nu mi maso, ene ꞌViaha Aalusꞌ. Angu mi nehe mehal nu iva aing vengajai mi ia aamina ini uuling ateing. Ved kakanap nehe aing tevang at ila mana angu mi, senge nehe ba hula Lahatala Ehava Hamulang ang mi maso angu ana iseeng banang. ");
INSERT INTO beu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ana uuling ateing Petrus bot Yohanis oleve hula masot omimi mida, angmuse ana atang horuk senge iabanang hula, “Nimang! Oleve iiomi nejahi hengi. Na iiba metma ma nenang hengi!” ");
INSERT INTO beu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Oleve euuling aaung-aaung, ang muse Petrus at mateng hula, “Kaku! Angami uuling hengi!” ");
INSERT INTO beu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Angmuse nehe angu apang ohi senge oleve iuuling, bot ana veng eomi hula, “Oo! Oleve anga, malekang na iiba metma ma nenang ba anga.” ");
INSERT INTO beu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aarunge Petrus at mateng hula, “Kaku! Seeng dena ae naing veng di niang. Aarunge naba ba ae naing veng anga ba na hula metma ma eenang. Angu ebele aana aavel helet aaung-aaung. Yesus Kristus, Nasaret enehe angu Ekavasa na metma ma eenang, aaungba aana tahi senge lamal!” ");
INSERT INTO beu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Angmuse Petrus ana nehe ia aamina angu atang tene angu vengpina, moling masiring aing bakung atahing. Uanguveng angu di ia benang mang mona, bot ia pandu iipi angu di daeri tila. ");
INSERT INTO beu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mibaroti se, ana kodo tahi, angmuse ana mulait lamal va-vaa ma-maa senge ia angu vengsoba. Seng angmuse, ana oleve iamulung hama-hama masot mida Lahatala Ehava Hamulang mi. Ana lamal, kodo-hipar bot Lahatala Aing tajaning. ");
INSERT INTO beu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Angmuse ana lamal bot Lahatala Aing tajaning angu nehe emangpi uuling ateing. ");
INSERT INTO beu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ini uuling ateing muse, ini mijonga senge mateng hula, “Aing anga, nehe ia aamina ba Viaha Aalus mi mihit nababanang angu. Etatalang ba aulang, ee?” ");
INSERT INTO beu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Angmuse, nehe angu Petrus bot Yohanis oleve iamamulung lamal. Inang tue ila najong nu mi ene ꞌNajong Raja Solemanꞌ. Nehe emangpi mijonga sengila ba ini hoa ing vengkumpul. ");
INSERT INTO beu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus uuling iateing muse, ana iat mateng, hula, “Ee, Israel enehe ang naung! Etatalang ba iini uuling na anga ateing muse ini mijongat aulang angu? Etatalang ba iini mang ni uuling alolang niang anga? Iini oma hula, nehe anga lamal anga ni tebahi pina, ee, ni kalakat Lahatala Amulung? Ee, tatalang? ");
INSERT INTO beu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Na hula iiat hubait alang: Tidat timang ang naung, anguba tidat Abraham, tidat Isak, bot tidat Yakob ini Lahatala Aing somba. Lahatala uangu ba Ana Nehe nu vengtalail iila angu Aing ohit mida eele-balolu, aingba Yesus. Yesus angu, Nehe ba tura iini Aing metma gubernur Pilatus atang mi abaang angu. Gubernur hula Aing ening lohi, aarunge iini iia, sengiila ba vengkilang nehe Ameang. ");
INSERT INTO beu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Aarunge Yesus angu, nehe nu ba bae Eahalang veng niang. Aing angu omi aaung. Gubernur hula Nehe ba eahalang veng niang angu aing ening lohi, aarunge iing bae amulung niang, senge iini omi taang ot nehe ba biasat nehe ameang anguba aing ening lohit metma ma iinang. ");
INSERT INTO beu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sengmuse iing ba Yesus Ameang. Aing anguba ening ping emangpi bisa aabeta. Etabit Ana aamina tila, aarunge Eaamina omimi angu Lahatala ening Ana bale aabeta tila. Aing anga ba ni uuling nieng taang ateing iila. ");
INSERT INTO beu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nehe ia aamina anga iini apang-ateing. Angase ana daeri tila, aarunge noleve ba bae ening ana mona niang. Noleve bae ni kavasa iiba veng niang. Kavasa angu Yesus ba Abung. Nehe angu bale daeri tila anga, ana omi metma Yesus vengaanamang angu ebele. Nehe anga iiapangaadang mi mona tila anga Yesus ba aing ening mona. ");
INSERT INTO beu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kaku naung! Angase na ateing hula, iing bot iinehe eele ang naung jasi ening metma Yesus adana tila aarunge nababa iini ening angu, iini bae vengkaruang niang. ");
INSERT INTO beu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Aarunge Lahatala Ana turang jamang mi Ehurvala ang naung ing gahing iot vengbanang iilat hula, Kristus, Aing angu Nehe ba Lahatala turangmi palait hula gahing hoa angu, malekang susa-lala angu tevang. Bot angase, na uangu jadit aulang iila. ");
INSERT INTO beu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Angu ebele, iini malekang iiahalang-iiavali ang naung vengbaroti sengila ba bale Lahatala amulung, aulange Ana iiahalang-iiavali ang naung vengahi bot Ana bae vengani niang iila. ");
INSERT INTO beu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Eningse Lahatala Ana iiomi ening aanamang bot iing ening aabetat aaung-hama. Eningse Lahatala di Kristus nehe ba Ana vengpalai tila angu, gahing hoa. Bot Kristus angu, Aing benang ba Yesus angu. ");
INSERT INTO beu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Turang jamang mi, Lahatala Ana Ehurvala ang naung ing gahing iot vengbanang iilat hula, ꞌEningse Lahatala Ana na emangpi angu ening aaung-hama bot bale ening hiba.ꞌ Base, Yesus malekang jedung sorga mi mihit sampe ejol Lahatala Ana na emangpi angu ening aaung-hama bot bale ening hiba senge, Ana hoa. ");
INSERT INTO beu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Turang mi boma Musa di Israel enehe ang naung iat mateng iilat metma Yesus Kristus adanat hula, ꞌLahatala anguba iiManaing, eningse Ana iilelang omimi iinehe nu gahing metma Ehurvala ening, emenghula Ana naing gahing metma Ehurvala ening angu edadenang. Base, emangpi ba Ana hula metma veng iiat hubai angu iini malekang iiavel metma venghele. ");
INSERT INTO beu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aarunge nehe ba eat bae Nehe ang Emateng angu venghelet aaung niang angu, eningse bae ing metma Lahatala Enehe ening niang. Angu, eningse ini bae aaung-hama iiba harak niang.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Boma Musa bae enangkolang vengbanang aulang niang. Aarunge Lahatala Ana nehe aabeung ang naung di ing gahing, metma Ehurvala ening, bot ing di vengbanang aulang iila. Angu ebele turangmi Lahatala Ana boma Samuel bot Lahatala Ehurvala ang naung emangpi di ing gahing, iot vengbanang hula, eningse Lahatala Ana Kristus Aing gahing hoa. Bot angase na angu jadit aulang iila. ");
INSERT INTO beu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Turang jamang mi, palai angu Lahatala Ana metma tidat-timang ang naung veng iat hubai tila. Angu ebele Lahatala Ana Ehurvala ang naung ing gahing iot palai angu vengbanang. Lahatala Ana tidat boma Abraham at palait hula, ꞌEningse Lahatala Ana aaung-hama metma bangsa emangpi ba por alolang taang angu inang. Abraham etabaning omimi angu, eningse Lahatala Ana aaung-hama angu metma nehe emangpi mainang.ꞌ Palai angu metma iing di iiadana. ");
INSERT INTO beu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Base Lahatala Ana Oal ba vengtalail iila angu gahing hoa, sengila ba via matubing aulange iiahalang-iiavali ang naung iini vengbaroti. Na uangu, Lahatala Ana ening aulang senge aaung-hama angu Ana metma maiinang. Lahatala Ana Oal angu panatut ematurat metma mapinang senge Ana bot metma bangsa aabeung ang naung di inang.” ");
INSERT INTO beu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrus bot Yohanis oleve jedung nehe ang naung iat mateng sehi se, nehe eele inang aaedeng hoa. Ing iiba, agama Yahudi ekapala ang naung, iiba kelompok Saduki mi angu enehe, bot Lahatala Ehava Hamulang jajaga ekapala. Ini hoa Petrus bot Yohanis oleve iat mateng. ");
INSERT INTO beu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nehe eele ang naung alil se Petrus bot Yohanis oleve nehe ang naung emangpi iat hubait hula, “Yesus aamina angu Ana bale aabeta tila! Aulang senge, Ana via bukat metma nehe aamina ang naung inang, senge ing di bale aabeta.” ");
INSERT INTO beu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Angmuse ing di bot inehe ang naung parentat ila oleve iadoi. Aarunge birkua tila base, ini oleve ing metma bui mi masot vengtahang. Emitobang, senge ini hula parkara angu vengurus. ");
INSERT INTO beu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aarunge nehe ba etvala ang naung ing venghele ang naung, nehe toang mangaku tilat hula, naba ba ini vengbanang angu, etabi. Angu ebele nehe ba iomi metma Mutu Yesus vengaanamang angu taang maveng toang, oma inang ribu ising. ");
INSERT INTO beu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Emitobang muse, nehe Yahudi enehe eele ang naung bendar Yerusalem mi taing veng kumpul. Anguba, agama Yahudi ekapala ang naung, Yahudi ehada eboma ang naung, bot guru agama ang naung, ");
INSERT INTO beu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","bot agama Yahudi e buang vala angnaung e kapala ene Hanas angu di ue ang mi. Nehe eele eabeung ang naung benang ba, Kayafas, Yohanis, Aleksander, bot nehe eele ehava omi aabeung ang naung di ue ang mi. ");
INSERT INTO beu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ing emangpi maso tila muse, ini parentat nehe ila senge Petrus bot Yohanis oleve iat hoa, nehe eele ang naung iapang aadang mi. Oleve maso ang muse, ini iadang taaning hula, “Etatalang ba nehe ia aamina angu iini bisa ening mona? Nuba ekavasa ba iini pake? Nuba ba ing gahing ba iini ening aulang? ");
INSERT INTO beu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ang muse Lahatala ERoh Petrus aing veng, ang muse Petrus barani, ana ibalet, hula, “Nimang, iing ba ninehe eele, bot Israel ehada eboma naung! ");
INSERT INTO beu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ni ateing se vede anga nimang iimal hula parkara ening metma niadana, se ni nehe ia aamina nu aing ening mona tila angu ebele. Senge bot nimang iimal hula ateing, nuba ekavasa ba ni metma aing ening mona angu? ");
INSERT INTO beu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Base, na hula iibalet alang: Nimang oma jedung Nasaret enehe ba ene Yesus angu vengani sehi. Aing anguba, Kristus ba turang mi Lahatala Ana vengpalai tila angu gahing hoa. Aarunge iini Aing metma leut veng pakut Ameang iila angu. Aarunge Eaamina omi mi angu Lahatala Aing ening Ana bale aabeta tila. Na hula nimang iimal bot bangsa Israel enehe ang naung emangpi malekang ateing hula, nehe ia aamina ni ening mona angu, Yesus angu ba Ekavasa metma ma ninang. ");
INSERT INTO beu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus anga ba, ini Lahatala Esurat hamulang mi hurak veng banang iilat hula, ꞌVar nu angu molang ang naung ohit bia tila, aarunge anga se var angu metma var halomang ening iila.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Por alolang anga miipi, Lahatala bot bae via aabeung iiba veng harakat metma ma pinang senge ping ening lohit metma piahalang-piavali ang naung eahalang niang. Aarunge via nu kakolang, benang ba Yesus. Hula bae Aing niang se, nehe aabeung nu bot bae bisat ping ening lohi niang.” ");
INSERT INTO beu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nehe ba ang mi mihi ang naung ateing hula, Petrus bot Yohanis oleve angu, mang nehe biasa, oleve angu bae sakola eele niang. Aarunge oleve ibarani angu ba ini mijonga, se oleve nehe toang iapangaadang mi mateng angu ini bae iuangmari niang, bot ini ateing hula, oleve angu, Yesus At aabeta angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bot nehe ia aamina ba mona tila angu di iapangadang mi tahi sehi angu ebele, ini bae mateng toang niang iila. ");
INSERT INTO beu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ang muse ini Yesus Eetvala aaru angu ing gahing hula, “Iini kaluar hela alolang mi mihi.” Senge ini hula temaring. ");
INSERT INTO beu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ini itat mateng hula, “Kaku naung! Pi malekang naba ba ening metma nehe aaru angu iadana? Se nehe emangpi Yerusalem mi angu ateing iilat hula, oleve ba tanda herang anga ening angu ebele. Pi bot hula akal tatalang, se ebukti ue tila angu? ");
INSERT INTO beu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Miaaung pi via valaping senge na anga ekang aalilit taang-taang mi ila ekang. Bot miaaung hula pi oleve ing ening ini iuangmari senge, ini bot ekang Yesus Evia Aabetang angu vengmaring ekang. Oleve iiat bae ping venghele niang se, naba ba pi ening metma iadana angu ini ina ateing!” ");
INSERT INTO beu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ang muse ini bot bale oleve iarut maso, senge iat hapat hula, “Vengani! Iini bot ekang Yesus Evia aabetang angu metma nehe emaring ekang!” ");
INSERT INTO beu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aarunge Petrus bot Yohanis oleve ibalet hula, “Nimang iina veng pikir hengi. Naba ba lebe miaaung? Iiparenta eamulung ba, miaaung ee? Lahatala Eparenta eamulung ba, miaaung? ");
INSERT INTO beu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Se na toang ni uuling nieng taang ateing illa, bot niaver vengmee tila. Tatalang e ni bisa veng taimang senge ekang nehe at hubai ekang!” ");
INSERT INTO beu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ang muse, nehe ba mihit parkara veng urus ang naung, ini bot oleve ihapa. Yahudi enehe ang naung ateingse nehe toang Lahatala tajaning-palevang, se Petrus bot Yohanis oleve nehe ia aamina angu ening mona tila angu ebele. Bot ini oleve ing ening lohi. Se ini bae ateing niang hula tatalang senge ini bisa oleve ing hukung angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","(Nehe ia aamina angu etung ari buta alehil, senge ana uhavede lamal aaung.) ");
INSERT INTO beu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ini Petrus bot Yohanis oleve ing ening lohi tila muse, oleve bale iserang ang naung ibele ila. Seng angmuse emangpi ba Yahudi eagama ekapala enehe eele ang naung bot hada eboma ang naung venghapa tila angu Petrus bot Yohanis oleve vengsarenta. ");
INSERT INTO beu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Vengmeet aulang muse, iserang emangpi angu, taing vengkumpul bot tominu senge sambajang hula, “Lahatala ba mi kavasa, Nimang Aaing ba burang bot por alolang, bot emangpi ba omimi angu ening. ");
INSERT INTO beu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tura Lahatala ERoh Hamulang angu boma Daud aing paket metma Lahatala Ehurvala ening iila. Ana vengbanang iilat hula, eningse nehe ang naung Yesus Aing lavang, se ana hurak hula, ꞌBangsa-bangsa enehe ang naung iomi alil iila, se ini hur ba bae molo niang vengmee angu ebele; Ini mang sama-aening, senge parkara ba ela-eajala veng niang angu ening. ");
INSERT INTO beu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Raja-raja por alolang taang ang naung ini taing vengkumpul senge hula Lahatala At malibal, bot kapala ang naung itat tominu senge ila Lahatala bot Kristus Aing lavang, Aing benang ba turang mi Lahatala Ana vengpalai tila hula gahing hoa angu.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na emangpi ba boma Daud hurak iila angu, angase jadi tila. Se bendar anga mi, raja Herodes bot gubernur Pontius Pilatus bot ni nehe boma ba Israel mi ang naung, bot bangsa aabeung ekapala ang naung taing vengkumpul iila angu ebele. Seng muse ing emangpi tominu senge Yesus, nehe ba Lahatala vengtalail iila angu, Aing lavang. ");
INSERT INTO beu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Aarunge angase ni ateing iila angu emangpi Lahatala Eomi vengbaa, naba ba turang mi Lahatala veng putus iila angu eamulung. ");
INSERT INTO beu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Angase, Nimang Lahatala Aana niuuling hengi, se ini nihapa niot ekang Yesus ene angu vengmaring ekang. Base, ni banang Aana ning ening barani senge ni ila Eehur aaung-hama metma Yesus adana anga metma taang-taang mi nehe at hubai. Bot ni bae na iiba veng niuangmari niang. ");
INSERT INTO beu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ning di banang senge Aana Eekavasa metma maninang, senge ni bisa nehe dila ang naung ening mona, bot na bae mura niang tanda herang edadenang toang rae ening aulange nehe ang naung ateing hula, kavasa angu Nehe Hamulang ba Lahatala Aing gahing, benang ba Mutu Yesus angu Abung hoa. Ni sambajang anga mang alang.” ");
INSERT INTO beu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ini sambajang sengmuse, hava ba ini mi taing vengkumpul angu, tadiri. Bot ing emangpi Lahatala ERoh Hamulang ing vengbaa. Angmuse ini hela Lahatala Ehur aaung-hama angu vengmaring, bot ini bae iuangmari niang. ");
INSERT INTO beu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Seng angmuse, nehe emangpi ba iomi Yesus vengaanamang angu, ini itomi nu, bot ini aabetat iomi metma tejajahi. Iiba bae iatang aanamang niang, senge ini sukat na metma ma tatenang. Na emangpi ba ing veng angu ini paket hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Senge Lahatala kavasa metma Eetvala ang naung inang senge ini nehe at hubait hula, Mutu Yesus aamina angu Ana bot bale aabeta tila. Ini bot uuling ieng taang ateing iila. Senge bot Lahatala Ana aaung-hama metma mainang mitoang mirae. ");
INSERT INTO beu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ing angu di, iiba angu ipor bot ihava di aabali. Senge eseeng angu, ana baning ila metma Mutu Yesus Eetvala ang naung inang. Senge ini metma nehe toang ang naung ing vengbalenta. Angu ebele ini bae na-nu ioang kurang di niang. ");
INSERT INTO beu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Yusup di ening aulang. Aing anga, Lewi etabaning, Siprus por taang hoa. (Etvala ang naung ene aabeung maveng earut hula, ꞌBarnabasꞌ, angu evengbanang hula, ꞌnehe ba sukat ening nehe aabeung ot lebalꞌ.) Ana ila epor vengdena angu aabali, senge eseeng angu baning ila metma Mutu Yesus Egahingvala ang naung inang. ");
INSERT INTO beu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Uanguveng angu nehe mehal nu ene Ananias. Ejangu angu ene Sapira. Oleve di, ipor vengdena nu aabali. ");
INSERT INTO beu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Aarunge oleve tominu por ebili angu dena vengamaang. Por angu aabali sengmuse, Ananias ila Lahatala Eetvala ang naung iat hubait hula, “Ni por vengdena nu aabali tila. Angase ni hula eseeng angu emangpi metma Lahatala enang.” ");
INSERT INTO beu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aarunge Petrus ehapat hula, “Ananias! Etatalang ba oomi vengdadena epor ba aana aabali eseeng angu aana vengamaang angu? Oomi etatabit jasi tila, se aana setang enehe eele eoomi eamulung angu ebele. Aana baranit Lahatala ERoh Hamulang angu ajajala! ");
INSERT INTO beu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Aana hula por angu aabali, por angu bae aabali niang ee, aaing ba eeoomi. Por angu aabali tila se, eseeng angu aana hula emangpi metma Lahatala Enang, ee niang, angu di aaing ba eeoomi. Aarunge etatalang ba aana bisat ening aulang angu? Aana eebabakeng ening aulang hula ning ba manusia anga niajajala, aarunge nehe iiba bae Lahatala angu ajajala niang!” ");
INSERT INTO beu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias ana vengmeet Petrus mateng aulang muse, mibaroti se ana baat meke mi hela, angmuse ana aamina. Nehe emangpi ba ehoja ang vengmee angu iuangmarit etatabi. ");
INSERT INTO beu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Angmuse nehe mehal kaneng inang aaedeng maso, sengila ba Ananias ebaring angu ini baloli, sengmuse at ila aing taloul. ");
INSERT INTO beu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Oma oda tue aulang muse, Ananias ejangu di hoa. Aarunge ana bae ateing hula emehal angu aamina tila niang. ");
INSERT INTO beu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Angmuse Petrus ana adangtaaning hula, “Tatalang, niva? Por ba iini aabali tila angu ebili ba alang anga, ee niang?” Angmuse ana ebalet vengbanang hula, “Etabi, nimang. Ebili ba mang aulang ba angu.” ");
INSERT INTO beu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ang muse Petrus ehapat hula, “Etatalang ba eemehal ooleve tominu senge hula Lahatala ERoh angu ajajalat aulang angu? Aana uuling hengi! Nehe uangu naung ba uhavede eemehal at ila aing taloul angu, ini bale tila. Bae luung niang se, ing ba bot eebaring angu tevang ila metma eemehal abar oa angmi taloul.” ");
INSERT INTO beu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nehe jangu angu ana Petrus emateng aulang angu vengmee muse, mibaroti se, nehe jangu angu baat hela emana eela taang aamina. Uanguveng angu nehe mehal kaneng ang naung bot bale maso, ini uuling ateing se nehe jangu angu di aamina tila. Angmuse ini ebaring angu tevang at ila metma emehal abar oa angmi taloul. ");
INSERT INTO beu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Angmuse nehe ba iomi Yesus vengaanamang ang naung, iuangmari. Bot nehe aabeung ang naung di naba ba metma Ananias bot Sapira oleve iaamina adana ang vengmee angu emangpi iuangmari. ");
INSERT INTO beu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesus Eetvala ang naung tanda herang toang amarat ening angu di, nehe ang naung uuling ateing. Gahingvala ang naung ila Lahatala Ehava Hamulang ang mi maso. Ini raja Soleman enajong mi taing vengmihi tominu-tahanu. ");
INSERT INTO beu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nehe toang Mutu Yesus Enehe ang naung ing tajaning. Aarunge nehe ba bae omi Yesus vengaanamang jedung ang naung di ue se, ana bae baranit ila angu mi masot imampi taing vengkumpul niang. ");
INSERT INTO beu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aarunge nehe ba omi Yesus vengaanamang angu, luung niang se mehal bot jangu di taang maveng tatoang-tatoang. ");
INSERT INTO beu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lahatala Eetvala ang naung tanda herang taang amarat ening angu ba nehe dila ang naung nehe iat hoa, senge via adil mi bihi taang iatiang. Se, ini vengpikir hula, “Petrus bot Yohanis oleve lamal angami lakal angse, iahumana ang ba ing vengbaa di, nehe dila anga naung mona.” ");
INSERT INTO beu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Angu ebele, aabang-aabang ba bendar Yerusalem eadil mi ang naung di enehe toang-rae hoa. Ini inehe ba dila ang naung tevang hoa, base Yesus Eetvala ang naung ing emangpi ing ening mona. Bot inehe ba setang iapang taang ang naung di ini iat hoa, base Yesus Eetvala ang naung setang angu emangpi aterit metma ioola. ");
INSERT INTO beu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mutu Yesus Eetvala ang naung ikarajang angu ebele, agama Yahudi ebuangvala enehe eele ang naung ekapala bot ia-atang ba kelompok Saduki mi ang naung, iomi mang alil metma iadana. ");
INSERT INTO beu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Angu ebele ini ila Mutu Yesus Eetvala ang naung iadoi, seng angmuse iat ila ing metma bui mi maso. ");
INSERT INTO beu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Aarunge kua angu adana, Lahatala Egahingvala sorga mi bui angu mi hoa, sengila ba ana bui eviaha angu ening abaleleng. Seng angmuse ana iat lamal hela via eela mi. Ang muse ana iat mateng hula, ");
INSERT INTO beu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Angase iini Lahatala Ehava Hamulang ang mi ila. Ila angmo mi, Lahatala Evia aabetang ba hiba angu metma nehe toang ang naung veng iat hubai, senge ini ateing.” ");
INSERT INTO beu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Emi tobang kukuaveng muse, ini ening Lahatala Egahingvala sorga mi hoa iat mateng iila angu eamulung. Seng angmuse ini ila Lahatala Ehava Hamulang elapa omi ang mi maso, sengila ba ini ang mi nehe toang ang naung iavomung-iapahang. Luung di niang se, Yahudi ebuangvala ang naung ieele angu bot eserang ang naung bot nehe eele ang naung bot Israel ehada eboma ang naung ini hoa parkara vengurus emana angu mi taing vengkumpul. Angmuse ini nehe jaga ang naung ing gahing ila bui mi Petrus bot Lahatala E etvala aabeung ang naung ing medit iat hoa, senge ini parkara angu vengurus. ");
INSERT INTO beu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aarunge uanguveng angu nehe jaga ang naung ila bui mi se, Petrus bot Lahatala Eetvala aabeung ang naung bae ue niang iila. Ang muse nehe jaga ang naung bale ila mana parkara vengurus ang mi nehe eele ang naung iat hubai. ");
INSERT INTO beu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ini vengbanang hula, “Nimang iimal ekang alil ekang. Ni ila bui mi, senge ni uuling ateing se bui eviaha angu emangpi jedung vengtering. Bot nehe jaga ang naung di emangpi ue ang mi tahi sehi. Aarunge ni iot bui eviaha angu buka senge ni maso se, ni bae nehe iiba harak niang.” ");
INSERT INTO beu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Vengmeet aulang muse, agama Yahudi ekapala enehe eele ang naung, bot Lahatala Ehava Hamulang ejaga enehe eele angu, ing emangpi iomi mang iipi sehi, se ini bae nababa etvala ang naung iadana angu manggarati niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Angmuse, nehe nu hoa iat hubait hula, “Nimang iimal, vengmee hengi! Nehe ba iini ing tahang metma bui mi angu, ae via eela ang mi! Anga se ini ae Lahatala Ehava Hamulang anga mi tahi senge nehe avomung-apahang sehi!” ");
INSERT INTO beu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Vengmeet aulang muse, Lahatala Ehava Hamulang ejaga ekapala angu bot nehe jaga ang naung ini ila Petrus bot eserang ang naung imampi bale iat hoa. Aarunge nehe jaga ang naung ila ang mi muse, ini iuangmari, se nehe toang ang naung Petrus emateng angu vengmee sehi angu ebele. Ini vengiomit hula, misavaka nehe toang ang naung bir arahak, bot var metma nehe jajaga ang naung ioda. Angu ebele, ini bale Petrus bot Lahatala Eetvala ang naung iadoi angu, ini mang iasenang iat hoa, ini bae baranit ing medit vengpaksa niang. ");
INSERT INTO beu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ang muse ini Petrus bot Lahatala Eetvala ang naung iat mana parkara vengurus ang mi ila. Ang muse nehe eele angu ana Petrus bot eserang ang naung iadangtaaning, ");
INSERT INTO beu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","hula, “Ning ba Yahudi enehe eele ang naung emangpi iihapat tilat hula nababa Yesus adana angu ekang vengmaring ekang! Aarunge iini bae ni parenta angu eamulung niang iila, iini mang ening iiomi ang ba eamulung! Iini lamal vomung-pahang bendar Yerusalem anga migoleng. Iini ning ening ahalat hula, ning ba nehe gahing senge ila Yesus angu Aing ening aamina.” ");
INSERT INTO beu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ang muse Petrus ana tahi metma Eetvala ang naung ihurvala ening. Seng angmuse ana ibalet hula, “Nimang iimal! Manusia eparenta Lahatala Eomi angu malavang se, ni bae eamulung niang. Aarunge ni malekang Lahatala Eparenta angu ba eamulung! ");
INSERT INTO beu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nehe ba ni aabetang hiba evia buka angu, aingba Yesus. Aing angu, Nehe ba iini Aing metma leut vengpakut ening aamina angu. Aarunge Lahatala ba tura tidat timang ang naung Aing somba angu, Aingba bale Yesus Aing ening Eaamina angu omimi aabeta tila! ");
INSERT INTO beu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Angase Lahatala Ana Yesus Aing ohi, senge metma Atang tene oat amihing iila. Senge Yesus kavasa pina tila emenghula raja eele edadenang. Ana via buka tila aulange nehe vengahit metma iahalang ang naung eola. Ana hula via metma ping ba Israel enehe anga naung mapinang, senge pi tava vengbaroti bot ekang piahalang ang naung emangpi bale ening ekang. Ening aulange, Lahatala Omi metma pi jahi base Ana pi ahalang ang naung emangpi vengahi. ");
INSERT INTO beu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Se ning anga, uuling nieng taang ateing iilat hula, Yesus etabit aamina tila, aarunge Ana bot bale aabeta tila. Lahatala ERoh Hamulang angu di na anga naung emangpi uuling ateing. Base Ana metma nehe ba Yesus Evia aabetang eamulung ang naung di veng iat hubai tila. Lahatala Ana Eroh Hamulang angu metma nehe ba Evia aabetang eamulung ang naung di inang iila.” ");
INSERT INTO beu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Vengmeet Petrus ana mateng aulang sengmuse, nehe emangpi ba parkara vengurus emana mi mihi angu, alil etatabi anguba ini hula Mutu Yesus Eetvala ang naung iameang. ");
INSERT INTO beu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aarunge angmi angu di nehe nu mihit parkara vengurus eamulung sehi angu ene Gamalial. Nehe toang aing vengtou, aing angu, nehe agama Farisi eguru hur adang. Anguba Petrus mateng sengmuse, ini hula ameang, aarunge Gamalial tahi seng muse ana nehe ang naung iot Petrus bot Lahatala Eetvala abeung ang naung iat via eela mi hela vengtahang kabingdena. ");
INSERT INTO beu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ini via eela mi hela iila muse, ana nehe eele ang mi ang naung iat mateng hula, “Nekaku naung emangpi! Pi malekang tava-vengani! Misavaka pi harubang mi jasi ening metma nehe anga naung iadana. Pi malekang uukur aavening hengi. ");
INSERT INTO beu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tura angu nehe nu ene Teudas. Ana jedung aabeta sehi angu ana ava ohit hula, aing angu nehe eele, anguba oma nehe ratu buta eamulung. Aarunge nehe ameang angmuse, enehe ba eamulung ang naung bihit tarae-teapahing, angu ebele angase nehe ba eamulung ang naung, di bae iava vengbutil niang iila! ");
INSERT INTO beu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Senge iini bot malekang sarenta nu angu di vengani hengi. Uanguveng parenta ue sensus ening nehe taanang aabang kanap. Nehe nu propinsi Galilea mi angu ene Yudas. Nehe toang eamulung. Aarunge andi nehe aing ening ana aamina. Senge nehe ba eamulung ang naung di bihit tarae-teapahing iila, angu ebele pi bae uuling iateing niang iila. ");
INSERT INTO beu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ba angase, kaku naung, ne nomi alang: ekang ing ening ini aamina ekang. Mang ing vengkilang. Se ivomung-ipahang, bot ilamal-itahi angu, manusia abung hoa se, angase bae vengtahang luung niang, eningse angu ue niang. ");
INSERT INTO beu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Aarunge ivomung-pahang anga etabit Lahatala abung hoa se, eningse iini bae bisat iabaang niang. Angu ebele, iini malekang iiava-vengani hengi. Se misavaka iini ue Lahatala Aing lavang sehi.” Vengmeet aulang muse, ing emangpi vengjalit, Gamaliel evomung angu eamulung. ");
INSERT INTO beu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Seng angmuse, ini Lahatala Eetvala ang naung iarut iot maso, sengmuse ini nehe gahing iot ing varisik. Senge bot ini ihapat iot ekang Yesus Ene angu vengbanang ekang. Angmuse ini Lahatala Eetvala ang naung ing ening lohi. ");
INSERT INTO beu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Angmuse, etvala ang naung lamal via eela mi hela mana parkara vengurus angu eahalang. Ini veng iomihula ing angu bae jasi niang, se ini Yesus eamulung iila angu ebele. Aarunge ing di bot iomi lebal, se ing anguba Lahatala Eomi vengeomi hula, ing anguba bae nehe jasi niang, ing malekang susa aulang angu harak angu ebele. Anguba iomi navera etatabi. ");
INSERT INTO beu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bot ved kakanap, ini ila nehe avomung hula, “Nehe ba Lahatala Ana turang mi vengpalai tila angu gahing hoa, benang ba Yesus angu.” Bot ini Yesus Ehur aaung-hama anga metma nehe at hubai alolang niang ihava ang naung mi, bot Lahatala Ehava Hamulang di mi. ");
INSERT INTO beu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Uanguveng angu, nehe ba iomi Mutu Yesus vengaanamang ang naung taang maveng toang iila. Aarunge ini ue hur baang aaru vengmateng. Bot iiba angu, Yahudi enehe ba Ibrani ehur vengmateng, bot Yahudi enehe ba Yunani ehur vengmateng. Luung niang se parkara baang aaru anga mi ava-apaleteng. Nehe ba Yunani ehur vengmateng angu ini bae nehe ba Ibrani ehur vengmateng angu iat sanang niang. Nehe Yunani ang naung vengbanang hula, “Ibrani enehe ang naung ini bae molo niang! Ini mod paul ved kakanap se, Yunani enehe kalabal ang naung ini bae mod metma mainang niang.” ");
INSERT INTO beu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Angu ebele, Mutu Yesus Eetvala arinu belta aalu angu, ini nehe ba iomi Mutu Yesus vengaanamang ang naung emangpi iot taing vengkumpul. Sengmuse ini mateng hula, “Kaku naung! Ning anga, malekang Lahatala Ehur angu metma nehe avomung alolang niang hengi. Ni iinaadang-iijalna ang ba vengurus angse, bae aaung niang. ");
INSERT INTO beu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Base ni vengpikir alang: lebe miaaung, iini iihahama mi nehe bititu vengtalail. Nehe ba ene veng, bot Lahatala ERoh ue aing veng, bot uukur aavening, anguba aing ing valaping. Nehe bititu angu iini vengtalail seng iila se, aulange ini naadang-jalna vengbalenta. ");
INSERT INTO beu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ening aulange, ni aaung ba sambajang lebe mitoang bot Lahatala Ehur angu vengmaring.” ");
INSERT INTO beu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ing emangpi Petrus emateng ang vengmee muse, ini vengjali. Angmuse ini nehe bititu vengtalail. Benang ba: Nehe nu, ene Stepanus. Aing angu etatabit omi metma Mutu Yesus vengaanamang, bot Lahatala ERoh Hamulang angu aing veng. Bot eserang aabeung ang naung, benang ba: Pelipus, Prokurus, Nikanor, Timon, Parmenas, bot Nikolas, bendar Antiokia enehe. Aing bae Yahudi enehe niang, aarunge ana agama Yahudi angu maso tila. ");
INSERT INTO beu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nehe bititu ba ini vengtalail iila angu ini iat ila Mutu Yesus Eetvala ang naung iabung. Angmuse etvala ang naung iatang metma ing taang mea, bot sambajang ing ohit metma nehe ba naadang-jalna vengurus ening, senge nehe masiking ang naung di emangpi hama-hamat ibaang angu harak. ");
INSERT INTO beu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Base Lahatala Ehur aaung-hama angu aalilit taang-taang mi ila. Bot nehe ba Yesus evia aabetang eamulung angu, Yerusalem mi taang maveng alolang niang. Bot, Yahudi eagama ekapala ang naung di toang iomi Mutu Yesus vengaanamang iila. ");
INSERT INTO beu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stepanus angu, Lahatala Ana aaung-hama etatabit metma maenang iila. Ana bot Ekavasa angu di metma maenang, anguba ana tanda herang bot na bae mura niang ang naung ening nehe toang uuling ieng taang ateing. ");
INSERT INTO beu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Angmi angu nehe Yahudi inang aaedeng mana ola mi hoa ang naung di ue. Anguba, bendar Kirene, bendar Aleksandria, propinsi Kilikia, bot propinsi Asia. Tura angu, ing metma nehe aabeung emalea ening, aarunge luung niang muse inehe eele ing ening lohi tila. Senge nehe anga naung taing vengkumpul Yerusalem mi. Ini ila sambajang hava nu ene, ꞌMalea lohi tilaꞌ ang mi maso. Senge mi nu angu, ini Stepanus emateng ang vengmee tila, aarunge ini bae suka niang, ang muse ini at natataanang. ");
INSERT INTO beu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aarunge Stepanus angu, nehe ba etatabit hur adang, se Lahatala ERoh Hamulang Ekavasa ba aing veng senge ana mateng angu ebele. Base naba ba Stepanus vengbanang angu, ini lavang jadi niang. ");
INSERT INTO beu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Angu ebele ini akal jasi aalaping. Ini ila nehe aaedeng iomi taang, senge iat mateng hula, “Ni vengmee se nehe anga mateng jasi-ahala bae aaung niang metma Musa bot Lahatala Adana! Ana etabit hura-manantit aulang!” ");
INSERT INTO beu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ini nehe ang naung iomi-taang, anguba nehe Yahudi ehada eboma ang naung, bot guru agama ang naung di vengmee. Vengmeet aulang, angmuse ini alil. Angmuse ini ila Stepanus adoi, senge aing at ila nehe ba agama eparkara vengurus emana mi ang naung iapang-aadang mi. ");
INSERT INTO beu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nehe aaedeng ba ini iomi taang iila angu mateng bae molo niang metma Stepanus adana hula, “Nehe anga mang hur jasi-ahala ang ba vengmateng alolang niang metma Lahatala Ehava Hamulang angu adana. Bot Yahudi eagama evia-via ba boma Musa ana metma mapinang iila angu ana vengmateng ening arahak. ");
INSERT INTO beu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ning di vengmee se ana mateng hula, Yesus Nasaret enehe angu, Ana hula Lahatala Ehava Hamulang anga arahak. Bot ana hula pi hada evia-via ba boma Musa metma mapinang iila angu ening arahak.” ");
INSERT INTO beu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Seng angmuse, nehe emangpi ba agama eparkara vengurus emana mi taing vengmihi angu, Stepanus euuling se, apang angu emenghula Lahatala Egahingvala sorga mi angu apang edadenang. ");
INSERT INTO beu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Angmuse agama Yahudi ebuangvala ang naung ekapala angu ana Stepanus adangtaaning hula, “Naba ba ini vengbanang metma aadana angu, etabi ee niang?” ");
INSERT INTO beu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Stepanus ebalet hula, “Nimang iimal bot nekaku naung! Iini naing venghele hengi. Tura angu, tidat timang boma Abraham bae eaabang emamolo ang mi ava asorong jedung se, Lahatala ba eele balolu angu, Ava metma etubing iila. Lahatala aing parentat hula, ꞌAaung ba aana tahit lamal ila eeaabang-eelelang anga eahalang, senge ila mana nu eningse Na metma eetubing angu mi!ꞌ Aulang angu ba ana Mesopotamia epor taang tahit lamal ila bendar Haran mi. ");
INSERT INTO beu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ana lamal nehe Kasdim ang naung iaabang angu eahalang, senge ava asorong ila bendar Haran mi. Imang ajajai angu aamina tila muse, Lahatala bot at hoa Kanaan por taang, mana ba angase nimang iimal bot nekaku naung mi aabeta sehi angu mi. ");
INSERT INTO beu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Uanguveng angu, Lahatala bae aabang anga mi meke vanggat nu paul metma tidat-boma Abraham enang epasaka ening di niang. Aarunge Lahatala Ana at palait vengbanang hula, eningse Ana meke anga maenang senge metma etabaning ang naung ipasaka ening. Aarunge uanguveng angu ana bae vaal veng jedung. ");
INSERT INTO beu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aarunge Lahatala Ana at mateng hula, ꞌEetabaning ang naung eningse ini ila nehe aabeung eaabang ehahama mi aabeta. Senge eningse nehe ang naung ini ing metma imalea ening, bot ening iajajasing ila mitung ratu buta. ");
INSERT INTO beu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aarunge mitung ratu buta angu eveng tahi mise, bangsa ba eetabaning ang naung ing ening metma imalea ening angu Na ing hukung. Senge eetabaning ang naung ini lamal aabang angu eahalang, sengila ba hoa aabang anga mi Naing somba.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Palait aulang seng muse, Lahatala Ana Abraham ot oal angu aing sunat. Ening aulang senge metma tanda ening hula, Abraham bot etabaning ang naung, ing metma Lahatala Enehe ening iila. Angu ebele, oal Isak uhavede eumur ved tuaru se, Abraham ana aing sunat. Aulang di, Isak ana oal Yakob aing sunat. Senge Yakob di oal mehal inang arinu belta aalu angu nu-nut eumur ved tuaru muse ana ing sunat. Ing emangpi anga naung ba, ping nehe Yahudi ang naung tidat-timang. ");
INSERT INTO beu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bot tidat-timang ang naung iomi metma ikaku kiki Yusup angu ealalil angu ebele, ini aing aabalit metma nehe eele nu atang mi abaang, sengila ba aing metma Masir por taang nehe eele angu emalea ening. Aarunge Lahatala kilang at toang pina. ");
INSERT INTO beu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Angu ebele Lahatala Ana aing ohit metma susa-lala ang naung emangpi eahalang. Lahatala uukur aaung di metma omimi angu ebele ana na toang manggarati, anguba Masir eraja di omi metma ejahi, base ana aing ohit metma gubernur ening Masir por angu miipi. Bot ana raja ehava omi angu di mi parenta pina. ");
INSERT INTO beu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Seng angmuse, malapal-tabonggal hoa Masir por bot Kanaan por angu taang. Malapal-tabonggal angu, etatabit eele, anguba taang-taang mi angu nehe toang etatabit susa. Angu ebele ba uanguveng angu, tidat-timang ang naung di bae mod iiba harak adang di niang. ");
INSERT INTO beu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aarunge tidat-boma Yakob ana hoja vengmee se hula, Masir por taang angu mod ue. Angmuse ana oal ang naung ing gahing senge Masir por taang ila ang mi mod beli. ");
INSERT INTO beu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Beli sengmuse, ini bale. Imod angu osing iila muse, Yakob ana bot bale ing gahing ila Masir mi mod beli. Yakob oal ang naung bale hoa Masir mi, anguba Yusup ana ava matubing, sengila ba ekaku ang naung ateing hula aing ba ikaku kiki Yusup benang. Sengmuse, Yusup ana bot ekaku ang naung ing metma Masir eraja angu di etubing. ");
INSERT INTO beu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Sengmuse, Yusup banang hula imang bot ehava omi enehe ang naung iot iava-asorong ila Masir mi. Ing emangpi ba angpo mi hoa angu, inang ari bititu belta iising. ");
INSERT INTO beu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Base, Yakob ava-asorong ila Masir mi angu ba aing bot tidat-timang ang naung angpo mi aamina. ");
INSERT INTO beu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Angmuse, tidat-timang ang naung ibaring angu ini bale baning ila Sikem aabang ba Kanaan por taang angu mi, sengmuse ini metma daang eele ba tura tidat boma Abraham ana Hemor etabaning ang naung iaabung beli tila angu mi taloul.” ");
INSERT INTO beu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Stepanus ana bot mateng hula, “Emangpi angu aulang iila, se Lahatala palai tilat hula, eningse Ana Kanaan mi por metma Abraham enang pasaka ening. Ila ejol angu mi senge Lahatala hula Epalai angu ening akanap se, ping bangsa Yahudi ba Masir por taang angu taang maveng toang iila. ");
INSERT INTO beu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yusup aaminat luung iila muse, raja aabeung ba nu bot Masir mi parenta pina. Aarunge aing bae Yusup angu ateing niang. ");
INSERT INTO beu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Raja angu ana pi lelang angu enehe ang naung ing ening iaajajasing. Ana etatabit lumul metma tidat-timang ang naung iadana. Ana bot ing paksat iot ioal kalokal ang naung iadut bianaila, senge ini aamina. ");
INSERT INTO beu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Uanguveng angu, tidat boma Musa iva ana aing vengajai. Eboa angu mang aalus! Iva bot imang oleve bae raja eparenta angu eamulung niang. Base ini vaal angu ihava mi amaang aing gariang ila eumur miuru tue. ");
INSERT INTO beu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ini bae vaal angu ihava mi amaang jadi niang iila muse, ini aing metma Nil moar mi ateding. Aarunge Masir eraja oal jangu nu vaal angu aing harak, angmuse ana vaal angu aing ohit medi sengmuse ana aing gariang emenghula oal mamolo edadenang. ");
INSERT INTO beu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Angu ebele, Masir enehe ang naung ilamal-itahi angu emangpi ini metma Musa avomung-apahang, angu ba andi metma nehe eele ening. Andi hur adang, bot ana karajang di ateing. ");
INSERT INTO beu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Musa eumur mitung aributa tila muse, ana hula ila enehe Israel ang naung iuuling. ");
INSERT INTO beu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ana ila muse, Masir enehe nu ue Israel enehe nu aing bue sehi ana uuling iateing. Angmuse ana va enehe Israel angu ba oang moling, senge Masir enehe angu ana buet ameang. ");
INSERT INTO beu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa have hula enehe Israel angu naung ateing iilat hula, Lahatala aing panatut hoa, senge ing vengahit metma isusa angu eahalang. Aarunge ini bae na angu manggarati jedung. ");
INSERT INTO beu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Emi tobang muse, Musa bot ila enehe Israel ang naung iuuling. Ana uuling ateing se nehe aaru taing salava sehi. Angmuse ana hula oleve ing metma toang-aaung, ana iat mateng vengbanang hula, “Ee! Iing ooleve anga, iia mutu. Aarunge etatalang ba iini tat totat alang anga?” ");
INSERT INTO beu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aarunge nehe ba eserang angu aing bue angu ana atang metma tidat boma Musa atobang ila abar oa, sengmuse ana mateng hula, ꞌNuba ba aaing songgar metma ni kapala ening! Bot nuba ba aaing songgar metma ni parkara anga vengurus? ");
INSERT INTO beu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aana eeomi hula nameang, emenghula aana meleng Masir enehe nu ameang angu edadenang ka?ꞌ ");
INSERT INTO beu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Vengmeet aulang muse, Musa ana bihit Masir eahalang. Angmuse ana ila Median enehe ang naung iaabang mi aabeta. Ana angmi jangu veng, senge ini vaal mehal aaru veng. ");
INSERT INTO beu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Mitung ari buta sengmuse, Musa ana ila mana nu jar bae mi niang ue dol nu nehe ene vengbanang hula Sinai iaeela angu mi. Angu mi Lahatala Egahingvala sorga mi hoa emenghula aad huring edadenang te kakiri nu taang Musa aing harak. Te kakiri angu viling, aarunge bae tepul niang. ");
INSERT INTO beu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Uuling ateing aulang muse, Musa ana mi jonga, angmuse ana va aad huring angu abung senge uuling ateing, angu naba ba angu. Aarunge mibaroti, ana vengmee se Lahatala Ana aad huring omi ang mi mateng, hula, ");
INSERT INTO beu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ꞌNaing anga ba, Lahatala iidat-iimang ang naung imanaing angu; benangba iidat boma Abraham, iidat boma Isak, bot iidat boma Yakob angu.ꞌ Vengmeet aulang muse, ana uangmarit etatabi angu ebele, Musa ana tababar, bot ana bae baranit apang ohit te kakiri ba viling angu euuling niang. ");
INSERT INTO beu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Seng angmuse Lahatala bot mateng hula, ꞌMusa! Aana ue mana hamulang ba mi tahi, angu ebele eesendal angu lapas bianaila! ");
INSERT INTO beu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ekang vengoomit hula, Ne nehe Israel ba Masir mi angmo naung Na ing vengtajebing iila ekang. Na jedung ing vengani sehi. Isusa-ilala angu Na ateing iila. Ini baut-peit hula ioang moling angu Na vengmee tila. Ba angase Na hela senge Na ila ing ening lohi. Angase, Na hula aaing gahing senge bale Masir angpo mi ila.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Aulang anguba, Lahatala Ana ava metma aad huring omimi matubing, senge Musa aing gahing ot bale Masir mi ila. Lahatala aing gahing senge Israel enehe ang naung ing metma isusa-ilala angu eahalang. Musa anga, nehe ba tura ini adangtaaning hula, ꞌNuba ba aaing songgar metma ni kapala ening?ꞌ Aarunge angase Lahatala ba aing songgar iila! ");
INSERT INTO beu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Seng angmuse, Musa bale Masir mi ila. Ana angmi tanda herang toang ening. Senge, ana Israel enehe ang naung iat lamal Masir ehalang. Ana ing baning ila Tang Tena ehahama angu mi lamal, angmuse ini lamal por osing eele ba nehe bae ue mi niang ang naung migoleng ila mitung ari buta venghili. ");
INSERT INTO beu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa ana Israel enehe ang naung iat hubait hula, ꞌEningse Lahatala Ana iihahama angmi nehe nu aing songgar metma Ehurvala ening emenghula Ana naing songgar iila anga edadenang.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa ue ping Israel enehe ang naung iat hama-hama por osing eele ba nehe bae ue mi niang angu mi. Aing anguba, metma tidat-timang ang naung bot Lahatala Egahingvala sorga mi hoa angu ehurvala ening. Se gahingvala angu ba Lahatala Ehur aaung-hama angu at hela metma Musa enang, senge via aabetang emamolo angu metma pitubing. Hur aaung-hama angu naung ba Lahatala Ana Sinai dol taang at hela angu. ");
INSERT INTO beu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aulang ba angu, aarunge tidat-timang ang naung iat bae Musa aing venghele niang. Bot ini atobang bianaila, senge ini hula mang bale Masir mi ila. ");
INSERT INTO beu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Angmuse ini ila Harun asenang hula, ꞌEekaku kiki Musa ana Masir mi piat kaluar iila. Aarunge angase, ni bae ateing niang iilat hula ana ue taang mi. Base ni banang senge aana aaneda ening metma maninang, senge aaneda angba niapang pinat lamal.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Angmuse ini aaneda angu ening emenghula sapi vaal nu edadenang. Angmuse ini binanta ba metma sadaka ening sengiila ba edet atepul metma aaneda angu enang. Seng angmuse ini pesta ening mura-rame, se iomi sanang iilat metma naba ba ini iatang metma ening adana angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lahatala uuling ateing aulang muse, Ana bae Eng metma iuuling niang bot bae ing paduli niang. Aulang aarunge ini bot naba ba doe burang mi emenghula ved, uuru, bot iid edadenang ang naung ini metma iaaneda ening. Aarunge Lahatala mang ing vengkilang aulang. Angu emenghula naba ba turang mi Lahatala Ehurvala hurak iila angu edadenang, vengbanang hula, ꞌEe! Iing ba Israel enehe ang naung! Mitung ari buta iini lamal por osing eele ba nehe bae ue mi niang angu migoleng, senge iini binanta ba metma sadaka ening edet atepul angu iini metma aaneda ba somba, aarunge iini bae metma Naing somba niang. ");
INSERT INTO beu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Iini bae Naing tajaning niang! Ved kakanap iini mang iiaaneda ang naung ba aing somba. Iini sukat ila setang Molok ehava aing aada anguba mi kaluar maso. Iing di iid esetang nu ene Refan anguba aing aada. Base, naba ba iini iiatang metma ening angu ba iini mang aing somba! Angu ebele ba eningse Na iing biat ila ola mi Babel edena veng angmo mi.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stepanus bot emateng ang taang hamuat hula, “Lahatala Ana ehava nu metma tidat boma Musa etubing. Lahatala Ehava angu, Musa iimal ini binanta ebuar bot noang ba metma Lahatala Eteeng nu ening Ana metma Musa etubing angu eamulung. Base, Israel enehe ang naung hoa ang mi Lahatala Aing tajaning. Ini mana nu mi iava asorong ila mana nu mi se, ini Lahatala Eteeng angu arahak, senge ini parta tevang ila mana ba aabeung angu mi. Angu mi ini bale Lahatala Eteeng angu bakung atahing. ");
INSERT INTO beu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Uanguveng, Yosua bot nehe Israel ba amulung, Kanaan mi bangsa aabeung ang naung iat malibal, ing lavang, Lahatala iaterit metma Kanaan por angu eahalang. Sengmuse Ana por angu paul metma tidat-timang ang naung inang. Ini ila por angu vengmalibal medi, seng angmuse Lahatala Eteeng angu di ini baning angmi ila. Teeng angu ang mi tahit ila raja Daud vengparenta pina. ");
INSERT INTO beu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Raja Daud anga ba ana Lahatala Aing tajaning emenghula tidat-boma Yakob di Lahatala Aing tajaning angu edadenang base Daud ening Lahatala Omi sanang. Bot ana Lahatala abanang senge aing ba Lahatala Ehava Hamulang ehiba angu bakung atahing. ");
INSERT INTO beu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aarunge Daud oal Soleman ba Lahatala Ehava Hamulang angu bakung atahing. ");
INSERT INTO beu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Aarunge pi ateing hula, Lahatala ba eele balolu angu bae hava ba nehe atang metma ening angu mi mihi niang, se turang mi Lahatala Ehurvala nu hurak vengbanang iilat hula, ");
INSERT INTO beu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ꞌBurang angu, Ne parenta emihing mana, Bot por alolang angu Nia tahi emana. Tatalange iini bisa hava aaung nu bakung atahing metma ma Nenang senge Na angu mi mihi? Bae bisa niang! ");
INSERT INTO beu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Se burang bot por alolang eomi angu emangpi, Naing ba ening angu ebele!ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Angmuse Stefanus ana emateng ang taang hamua, bot alil iat mateng amal aelet hula, “Iing etatabit nehe ba ong aanamang ang naung! Iing emenghula nehe ba bae Lahatala ateing niang angu edadenang, bot iiat bae Aing venghele niang. Iing iiaver akebe Lahatala Aing malavang, emenghula tidat-timang ang naung bae Eamulung niang angu edadenang! Angase iini jedung hula bot Lahatala ERoh Hamulang angu malavang e? ");
INSERT INTO beu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tidat-timang ang naung Lahatala Ehurvala ang naung ing ening susat alolang niang. Hurvala taang ba ini bae aing ening susa niang? Bae ue niang! Tura Lahatala Ehurvala ang naung, nehe at hubait hula, eningse Lahatala Ana EMalea ba aabetat Eomi eamulung angu panatut hoa. Aarunge iidat-iimang ang naung ini Lahatala Ehurvala ang naung iameang. Anguba iing di nehe aabeung ing gahing senge iot Lahatala EMalea ba aabetat Eomi eamulung, benangba Yesus angu, ameang. ");
INSERT INTO beu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bot Lahatala Egahingvala sorga mi ang naung di Musa eparenta evia-via angu emangpi metma mapinang, aarunge iini bae iiat eamulung niang.” ");
INSERT INTO beu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nehe ba mihit parkara vengurus ang naung Stepanus emateng angu vengmee muse, ini ateing iilat hula ana ahalang metma ing taang mea. Angmuse ini iomi alil bot iaveing eera ganiling. ");
INSERT INTO beu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aarunge Stepanus ba Lahatala ERoh Hamulang aing vengbaa angu, ana burang euuling. Angu mi, ana uuling Lahatala Ekavasa angu emangpi ateing, bot Mutu Yesus ue mana ba eele-balolu Lahatala Atang tene oa angu mi tahi sehi. ");
INSERT INTO beu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ang muse Stepanus mateng hula, “Nimang iimal, na uuling se burang viaha baleleng, bot Yesus ba Manusia Emamolo angu ue mana ba eele-balolu Lahatala Atang tene oa angu mi tahi sehi.” ");
INSERT INTO beu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Vengmeet aulang muse, nehe ba parkara vengurus ang naung ini iaver vengtering. Bot ini moring Stepanus ot taimang. Ing emangpi hama-hama bihit va senge Stepanus adoi. ");
INSERT INTO beu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Angmuse ini aing metma bir vengmasiring at ila bendar amota oa ang mi. Nehe ba emateng vengmee ang naung ini ikondo angu aahi, senge metma nehe kuar nu ot pina. Nehe kuar angu ene Saulus. Angmuse ini ila var metma Stepanus odat ameang. ");
INSERT INTO beu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ini jedung oda sehi se, ana moring amal aelet hula, “Mutu Yesus! Ne jol peang iila. Aaung ba naing tarima!” ");
INSERT INTO beu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Seng angmuse ana meke mi ia kuku muding bot moring amal aelet hula, “Yesus, Aaing ba neManaing, ekang iahalang anga vengkilang metma ing taang mea ekang!” Ang muse ana eeng abaang, muse ana aamina. ");
INSERT INTO beu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Saulus di ue mana angu mi, base ini Stepanus ameang angu andi vengjali. Stepanus aamina angmuse, nehe aaedeng ba iomi Lahatala midadanang sehi angu, ini ila Stepanus ebaring angu medi senge at ila aing taloul, bot ini ebau-epei. Ved angu veng angu, nehe ba Yerusalem mi iomi Mutu Yesus vengaanamang ang naung nehe ing ening susa-lala, sampe ini vengtahang jadi niang. Angmuse ini bihit tarae-teapahing ila propinsi Yudea bot propinsi Samaria mi. Ing emangpi bihi, aarunge Mutu Yesus Eetvala ang naung ba inang kolang Yerusalem mi mihi. ");
INSERT INTO beu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aarunge Saulus via valaping senge hula nehe ba omi Mutu Yesus vengaanamang ang naung ing ening ini aamina. Ana ila taang-taang mi ing aalaping. Ana hava ang naung mi maso-kaluar ing aalaping. Nehe mehal bot nehe jangu, ana iadoit iat ila, senge ing metma bui mi. ");
INSERT INTO beu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nehe ang naung ini nehe ba iomi Mutu Yesus vengaanamang ang naung ing ening susa, anguba ini bihit tarae-teapahing, aarunge Mutu Yesus Ehur aaung-hama angu ini metma taang-taang mi nehe veng iat hubai angu bae alolang niang. ");
INSERT INTO beu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pelipus ana ila bendar nu propinsi Samaria mi angu mi, senge ana nehe ang naung iat hubait hula, Yesus anguba Kristus, Aing angu Nehe ba Lahatala turang mi Ana vengpalai tilat hula gahing hoa angu. ");
INSERT INTO beu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nehe toang uuling tanda herang ba Pelipus ana ening angu ateing angmuse, ini taing vengkumpul senge naba ba ana vengbanang angu venghelet aaung-aaung. ");
INSERT INTO beu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aulang di nehe ba setang iapang taang ang naung di ang mi base, Pelipus ana setang ang naung iaterit metma nehe ang naung iahalang base setang ang naung kalilit etatabi. Nehe ba kuningkivil ang naung di angmi base Pelipus ana ing ening mona tila. ");
INSERT INTO beu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Angu ebele nehe ba bendar angu mi angu iomi etatabi navera. ");
INSERT INTO beu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nehe nu ene Simon ue bendar angu mi mihi. Ana tebahi pinat luung iila. Anguba Samaria enehe ang naung iuangmarit etatabi. Ana ava ohit hula, aing angu nehe eele! ");
INSERT INTO beu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Nehe emangpi ba bendar angu mi angu, kakaneng bot nehe eele ang naung emangpi ene vengbanang hula, “Nehe anga, etatabit mura niang! Nababa ana ening angu, Lahatala Ekavasa omimi hoa!” Etebahi angu ebele, turang mi nehe ang naung ebele hoa bot eamulung. ");
INSERT INTO beu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aarunge Pelipus ana Samaria mi hoa angmuse, ana Lahatala Ehur aaung-hama metma iat hubai. Pelipus iat mateng hula Lahatala Eparenta pina senge nehe ening lohi bot aabetang ejajehing metma ma inang. Bot ana via metma itubing senge ini bisa masot metma Lahatala Enehe ening, senge ing di metma Yesus Enehe ening. Vengmeet aulang seng muse, nehe toang iomi vengaanamang, angu ebele ini masot metma Lahatala Enehe ening. Nehe mehal bot nehe jangu ang naung emangpi ening aulang. Angu ebele nehe jar metma ing sarani. ");
INSERT INTO beu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon di omi vengaanamang bot andi hula aing metma Yesus Enehe ening. Base ini andi aing sarani. Angmuse ana Pelipus amulung at hama-hamat lamal. Tanda herang ba Pelipus ening angu Simon ana uuling ateing muse, ana etatabit mi jonga. ");
INSERT INTO beu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mutu Yesus Eetvala ba Yerusalem mi ang naung vengmee se hula, nehe propinsi Samaria mi ang naung emangpi iomi metma Lahatala Ehur Aaung-hama angu vengaanamang iila! Angmuse ini Petrus bot Yohanis oleve ing gahing angu mi ila. ");
INSERT INTO beu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Oleve ila angu mi muse, ini ateing hula Samaria enehe ba ang mi ang naung, Lahatala ERoh Hamulang angu bae ing vengbaa jedung. Uanguveng nehe jar metma ing sarani angu Yesus Ene ba enang kolang. Angmuse Petrus bot Yohanis oleve iatang metma nehe ang naung ing taang mea, bot sambajang banang senge Samaria enehe ang naung di Lahatala ERoh Hamulang angu ing veng. Petrus bot Yohanis oleve sambajang ang muse, Lahatala ERoh ing veng. ");
INSERT INTO beu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Oleve iatang metma nehe ang naung ing taang mea, senge Lahatala ERoh angu ing veng angu, Simon ana uuling ateing. Angmuse Simon ana hula seeng metma Petrus bot Yohanis oleve inang hengi, bot banang hula, ");
INSERT INTO beu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nimang! Iini kavasa angu metma nandi ma nenang. Aulange na hula natang metma nuba ba aing taang mea se, ing di Lahatala ERoh Hamulang angu ing veng.” ");
INSERT INTO beu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aarunge Petrus ana ealil amal aelet mateng hula, “Eeseeng angu metma aaing veng ening se iilang-tobol. Aana oma hula Lahatala ERoh Hamulang ekavasa angu aana seeng metma beli? Niang! Nehe bae Lahatala ERoh angu beli niang. ");
INSERT INTO beu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aaing bae bisat niamulung niang, se oomi bae molo niang angu ebele. Aana mang akal jasi ba aalaping. ");
INSERT INTO beu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eeahalang anga aaung ba aana vengbaroti. Miaung aana sambajang Lahatala abanang senge Ana eejasi ahala angu vengaahit metma eeahalang. ");
INSERT INTO beu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na ateing se hula, uukur jasi oomi angu aaving sehi, bot jasi ahala toang angu aaing parta.” ");
INSERT INTO beu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Angmuse Simon ana oleve iabanang hula, “Nimang. Aulang se, iini noang moling hengi. Iini sambajang metma ma nenang, senge hur ba iini vede vengbanang iila angu, ekang naing vengbaa ekang.” ");
INSERT INTO beu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Seng angmuse, Petrus bot Yohanis oleve Mutu Yesus Ehur aaung-hama angu emangpi vengsarenta, bot Lahatala Ehur aaung-hama angu metma bendar angu mi vengmaring. Angmuse ini bale Yerusalem mi ila. Ila via mi muse, ini aabang ba propinsi Samaria mi angu mi miari, senge Mutu Yesus Ehur aaung-hama angu metma nehe angmi ang naung di iavomung-iapahang. ");
INSERT INTO beu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ang muse Lahatala Egahing vala sorga mi hoa Pelipus aing gahing hula, “Aaung ba aana tahit lamal tang eoat ila, via ba bendar Yerusalem mi hela ila Gasa aabang mi tahi angu ba oa.” Via angu via taimang. ");
INSERT INTO beu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Vengmeet aulang muse, Pelipus ana tahit lamal. Ana ila via angu mi muse, ana uuling nehe nu ateing. Aing angu, nehe eele Etiopia por taang hoa ba nu. Nehe ba Pelipus ana aing harak angu, aing ba ratu Kandake Etiopa enehe eele angu, ekavasa ang naung emangpi vengurus. Ana ila Yerusalem mi sambajang seng angmuse, ana bale hoa via mi. Pelipus uuling ateing se, ana ekereta angu taang mihit na basa sehi. Ana Lahatala Ehurvala tidat boma Yesaya esurat angu ba basa. ");
INSERT INTO beu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Angmuse Lahatala ERoh Pelipus aing gahing lamal va kereta angu abung nehe angu aing harak. ");
INSERT INTO beu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ana va kereta angu abung sengila ba, ana vengmee se nehe angu tidat boma Yesaya esurat ba basa sehi. Angmuse Pelipus ana taaning hula, “Nimang! Naba ba nimang basa angu aana manggarati, ee niang?” ");
INSERT INTO beu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Angmuse nehe angu ebalet hula, “Niang. Evengbanang tarang angu nehe iiba bae metma nat mateng niang se, tatalange na emanggarati angu ateing.” Angmuse ana Pelipus abanang ot mida abung mihi. ");
INSERT INTO beu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Surat ba ana basa angu eamal alang: “Ini Aing masiring lamal, emenghula nehe jumba masiring ila, senge hula sabele angu edadenang. Andi bot emenghula jumba val ba nehe Eaamudi gunti angu edadenang, aarunge Ana bae kalili di niang. Ana bae Ai buka di niang, bot bae hur kokal nu metma nehe ebale di niang. ");
INSERT INTO beu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Angmuse ini Ehura-Emananti; Ini Eparkara angu vengputus bae molo niang. Ana bae ahalang iiba ening di niang, aarunge ini Aing ening Ana aamina. Angu ebele Etabaning iiba bae ue niang. Base, nehe iiba bae etabaning angu vengsarenta di niang.” ");
INSERT INTO beu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Basat aulang sengmuse, nehe eele angu ana Pelipus adang taaning, hula, “Tatalang? Tidat boma Yesaya hurak anga ana metma ava adana ee, ana hurak metma nehe aabeung adana?” ");
INSERT INTO beu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Angmuse Pelipus ana Mutu Yesus Ehur Aaung-Hama angu metma nehe eele angu at mateng. Ana Mutu Yesus evia aaung-hama angu metma nehe angu etubing Yesaya esurat vede angu eamulung. ");
INSERT INTO beu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ini jedung lamal sehi se, ini ila mana nu jar ue mi angu mi. Angmuse nehe eele angu ana Pelipus at mateng hula, “Nimang, uuling hengi, jar ue ang mi. Hula na iiba bae naing sakang niang se, pi hela senge aana jar metma naing sarani.” ");
INSERT INTO beu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Angmuse Pelipus ebalet hula, “Etatabit nimang aana oomi metma Mutu Yesus vengaanamang se, bae esakang veng niang. Pi hela, senge na jar metma aaing sarani.” Angmuse ana Pelipus at mateng hula, “Na etatabit nomi vengaanamang hula, Yesus angu, Nehe ba Lahatala turang mi matubing iila angu. Aing angu Lahatala Oal.” ");
INSERT INTO beu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ang muse nehe eele angu ana nehe ba kereta baning angu ot barinti. Angmuse ini hela jar mi maso sengila ba, Pelipus ana ang mi nehe eele angu aing sarani. ");
INSERT INTO beu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nehe eele angu Pelipus ana aing sarani sengmuse, oleve jar mi bale da. Angmuse Lahatala ERoh Hamulang Pelipus aing ohit at lamal mana aabeung mi ila. Nehe eele angu bae uuling ateing niang iila. Angmuse nehe eele angu bot taang lamal se omi mang navera angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Aarunge Pelipus ila aabang nu mi maso, aabang angu ene Asotus. Angmi ana lamal aabang emangpi miipi Yesus Ehur Aaung-hama angu metma nehe at hubai, ila Kaisarea mi. ");
INSERT INTO beu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Uangu adana Saulus ana nehe ba Mutu Yesus amulung ang naung imakau bot ing ening susa-lala. Ana eomi hula iameang. Angu ebele ana agama Yahudi ebuangvala ang naung ekapala angu ibele ila ");
INSERT INTO beu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","senge surat kuasa banang. Aulange ana baning ila hava hamulang ekapala moe bendar Damsik mi angu enang. Ana banang senge nehe ba Yesus Evia Aabetang eamulung ang naung ana ing harak se jangu bot mehal di, ana iadoi ing pina bot ing parta, senge ana iat bale Yerusalem mi ila. ");
INSERT INTO beu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Surat kuasa angu ana tarimat medi muse, aing bot eserang ang naung imampi Damsik mi ila. Ini jedung lamal bendar Damsik ebele iila sehi se, mibaroti se huring jara eele burang mi hela Saulus aing venggoleng. ");
INSERT INTO beu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Angmuse ana baat meke mi hela. Ang use ana nehe amal nu vengmee se, at mateng vengbanang hula, “Saulus! Saulus! Etatalang ba aana Naing ening susa-lalat alang anga?” ");
INSERT INTO beu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulus taaning hula, “Nimang, aaing ba nuba ba nat mateng anga?” Nehe amal angu ebalet hula, “Naing anga, Yesus, ba aana ening susa-lala angu. ");
INSERT INTO beu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Angase, aaung ba tahi senge ila bendar mi maso. Angu mi senge, aulange Na aat hubait hula, aana malekang naba ba ening.” ");
INSERT INTO beu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Eserang ang naung di nehe amal angu vengmee, aarunge ini bae uuling nehe iiba ateing niang. Angmuse ini mibaroti bot iomi mang iipi sehi angu ebele ini bae na iiba vengmateng niang. ");
INSERT INTO beu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Angmuse Saulus ana bakung tahi. Ana eng ajala, aarunge ana bae bisat uuling na iiba ateing di niang iila. Angmuse ini aing pina senge atang tedot ila bendar Damsik mi maso. ");
INSERT INTO beu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mietang tue ana bae uuling na iiba ateing niang. Bot ana bae na nu adang-na di niang. ");
INSERT INTO beu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Angmi angu nehe ba omi Mutu Yesus vengaanamang nu ue, ene Ananias. Lahatala hoa ava metma etubing emenghula iipal mi edadenang, senge earut hula, “Ananias!” Ananias madut hula, “Ya, Nimang!” ");
INSERT INTO beu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Emenghula iipalna edadenang Lahatala Ana Ananias at hubait hula, “Aana ila Via Molo mi, Yudas ehava mi, bendar Tarsus enehe nu ene Saulus angu aing aalaping. Angase, nehe angu ana sambajang. ");
INSERT INTO beu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na metma Saulus etubing hula, eningse nehe mehal nu ana ebele ila. Benang ba aaing, Ananias angu. Base, aana ila aatang metma aing taang mea, senge eningse ana bale uuling aaung.” ");
INSERT INTO beu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Aarunge Ananias ebalet hula, “Nimang Lahatala! Saulus elamal-etahi angu nehe toang vengsarenta na vengmee tila, se ana Lahatala Enehe ba Yerusalem mi ang naung ing ening susa-lala etatabi angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Angase ni bot vengmee se hula, agama Yahudi enehe eele ang naung surat kuasa metma ma enang senge hoa anga mi nehe ba iomi metma Mutu Yesus vengaanamang iila ang naung iadoi.” ");
INSERT INTO beu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Aarunge Lahatala Ana Ananias at mateng hula, “Kilang, angase aana mang ila! Se Na aing vengtalail medi tila senge ila via buka, senge Nehur aaung-hama angu, ana baning ila metma bangsa aabeung ang naung, raja aabeung ang naung, bot Israel enehe ang naung di inang. ");
INSERT INTO beu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eningse susa-lala toang ba Saulus ana harak angu emangpi Na metma etubing senge ana ateing, se ana Naing vengbalenta angu ebele.” ");
INSERT INTO beu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Vengmeet Lahatala mateng aulang muse, Ananias ana lamal Yudas ehava angu mi ila, angmuse ana angu mi maso. Angmuse ana atang metma Saulus aing taang mea, senge vengbanang hula, “Kaku Saulus, aana lamal anga mi hoa sehi se, Mutu Yesus ba aana via mi Aing harak angu, Aing ba naing gahing hoa aaing harak. Mutu Yesus not sambajang bot natang metma aaing taang mea, senge aana bale uuling aaung. Bot Ana hula ERoh Hamulang angu malekang aaing veng.” ");
INSERT INTO beu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ana mateng sengmuse, na iiba emenghula aab aakini edadenang, Saulus eng mi horung hela, angmuse ana bale uuling aaung. Angmuse ana tahi, sengmuse nehe jar metma aing sarani. ");
INSERT INTO beu_vpl VALUES ("AC9_19a","074_9_19a","ACT","9","19a","19a","Bot ana naadang-jal na sengmuse eboa angu bale daeri. ");
INSERT INTO beu_vpl VALUES ("AC9_19b","074_9_19b","ACT","9","19b","19b","Ved aaedeng Saulus ana nehe ba omi Mutu Yesus vengaanamang ba bendar Damsik mi ang naung iat mihit hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Uanguveng angu ana ila nehe Yahudi ehava hamulang ang naung mi maso, senge ana Mutu Yesus Elamal-Etahi angu metma nehe veng iat hubai. Ana vengbanang hula, “Yesus angu ba etatabit Lahatala Oal.” ");
INSERT INTO beu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulus mateng aulang angmuse, nehe emangpi mijonga bot iomi iipi sehi. Angmuse ini itat mateng hula, “Aing anga ba nehe omi Yesus vengaanamang Yerusalem mi ang naung ing ening susa-lala tila angu. Ana bot hoa anga mi hula iadoi senge iat ila metma agama Yahudi enehe eele ang naung inang!” ");
INSERT INTO beu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aarunge Saulus ana vengbanang tarang senge nehe ateing hula, etatabit Yesus angu Nehe ba Lahatala turangmi vengpalai tilat hula gahing hoa angu. Saulus ana nehe avomung-apahang aulang aarunge Yahudi enehe ang naung bae hur iiba vengbanang metma aing lavang niang. Saulus ana nehe avomung-apahang alolang niang anguba Saulus enehe angu maveng tatoang-tatoang. ");
INSERT INTO beu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Luung niang muse, Yahudi enehe ang naung itominu, senge ini via aalaping hula Saulus ameang. ");
INSERT INTO beu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aarunge iomi ba jasi angu Saulus ana ateing iila. Nehe Yahudi ang naung kua-jala bendar eviaha angu emangpi mi jaga, senge hula ameang. ");
INSERT INTO beu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Aarunge kua nu angu, Saulus eserang inang aaeedeng aing medi senge aing metma hora nu mi, sengila ba at ila bendar etode amota oa ang mi aing jolot hela. Ening aulang muse, ana bihit ila bendar Damsik eahalang. ");
INSERT INTO beu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Angmuse, Saulus ila Yerusalem mi. Ila angmo mi muse, ana hula ila nehe ba iomi Mutu Yesus vengaanamang ang naung ing harak, aarunge jadi niang. Se ing emangpi aing veng iuangmari, bot ini hula misavaka, ana mang ebabakeng ava ening emenghula nehe omi vengaanamang ba Yesus Amulung angu edadenang. Aarunge eningse ana bot iadoi. ");
INSERT INTO beu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Aarunge nehe nu ue, ene Barnabas, ana iat mateng. Aingba Saulus aing metma Mutu Yesus Eetvala angmi ang naung itubing. Barnabas at mateng hula, Saulus Damsik mi ila, angmuse, via mi, Saulus ana Yesus Aing harak bot Yesus Ana at mateng iila. Aulang di, Damsik mi angu Saulus ana nehe Damsik ang naung iat hubai metma Yesus angu adana. Ana Yesus Evia aabetang metma nehe toang veng iat mateng angu, Saulus ana bae uangmari niang. ");
INSERT INTO beu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Vengmeet aulang muse, Mutu Yesus Eetvala ang naung emangpi Saulus aing tarima. Angmuse ana iat hama-hamat bendar Yerusalem mi mihi. Ana baranit Mutu Yesus Ehur Aaung-Hama angu metma nehe emangpi angu veng iat hubai, se ana bae uangmari niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ana bot nehe Yahudi inang aaeedeng ba Yunani ehur vengmateng angu iat natataanang. Aarunge ini iat bae emateng ang metma iomimi niang, anguba ini via valaping senge hula ameang. ");
INSERT INTO beu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aarunge nehe ba omi Mutu Yesus vengaanamang ang naung vengmee se hula, nehe ang naung akal jasi aalaping aulang muse, ini Saulus aing medit at bendar Kaisarea ba tang adil mi angu mi ila. Angmuse ini aing panatut bale bendar Tarsus mi ila. ");
INSERT INTO beu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Seng angmuse, nehe ba omi Yesus vengaanamang propinsi Yudea mi, propinsi Galilea mi, bot propinsi Samaria mi ang naung, aabetat tening rama. Ini taang maveng tatoang-tatoang, bot ini Lahatala Eomi angba eamulung. Base Lahatala ERoh Hamulang angu iomi ening aanamang. ");
INSERT INTO beu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Uanguveng, Petrus lamal mana ang naung migoleng senge Lahatala Enehe ang naung iuuling. Ved nu adana Petrus ana ila nehe omi vengaanamang ba Lida aabang mi mihi ang naung iuuling. ");
INSERT INTO beu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Angmo mi ana nehe mehal nu aing harak, ene Eneas. Nehe angu kuningkivil, bot bae tahit etiang mana angu eahalang di niang mitung tuaru tila. ");
INSERT INTO beu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus at mateng hula, “Eneas! Angase, Yesus Kristus aaing ening mona. Base aaungba tahi! Eebihi angu paliul!” Vengmeet aulang muse, Eneas ana aloming tahi. ");
INSERT INTO beu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nehe emangpi ba Lida aabang bot Saron aabang mi angu Eneas ana mona tila angu uuling ateing. Angmuse ing emangpi iomi metma Mutu Yesus vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Uanguveng, nehe jangu nu ene Tabita aing angu bendar Yope ba tang eadil mi angu mi mihi. (Nehe jangu angu ene Yunani ehur mi se hula, ꞌDorkasꞌ, eveng banang hula, ꞌaarohingꞌ.) Ana omi metma Mutu Yesus vengaanamang. Bot ana aaung-hama angu ba ening alolang niang metma nehe adana, bot nehe masiking-kasiang ang naung ioang moling. ");
INSERT INTO beu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Uanguveng, Tabita dilat tamadi muse, ana aamina. Ang muse ini avela, bot ini ebaring angu baloli, seng angmuse ini aing metma ekamar atela angmi atiang. ");
INSERT INTO beu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nehe ba omi Mutu Yesus vengaanamang ang naung vengmee se hula, Petrus ue Lida mi tila, aabang nu Yope mi tiaveng lamal ila mi se oma ved boang. Angmuse ini nehe aaru ing gahing ila Petrus abanang hula, “Nimang! Aana uuser Yope mi ila hengi.” ");
INSERT INTO beu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Vengmeet aulang muse, Petrus tahit iamulung. Ila angmo mi muse, ana ang mi memet Tabita ekamar mi masot mida. Nehe memet kalabal ang naung hoa angmi bau-pei angu ba ini ue kamar angu aaving. Ikondo bot ipakiang aabeung ba Dorkas jedung aabeta sehi ana harotat metma ma inang angu, ini metma Petrus etubing. ");
INSERT INTO beu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus ana ing emangpi iot kamar angu eahalang. Angmuse ana iakuku muding sambajang. Seng angmuse, ana baring angu euuling, senge ana mateng hula, “Tabita! Aaungba tahi!” Mibaroti se, Tabita ana eng ajalat uuling. Ana uuling Petrus ateing muse, ana tahit mihi. ");
INSERT INTO beu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Angmuse Petrus ana atang angu vengpina, senge oang moling atahing. Angmuse Petrus ana nehe memet kalabal bot nehe aabeung ang naung iaru, seng angmuse Tabita ba bale aabeta tila angu ana metma ma inang. ");
INSERT INTO beu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Hoja angu aalilit bendar Yope mi mana ang naung mi iipi, anguba nehe toang iomi metma Mutu Yesus vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus ana angu mi nehe nu ehava mi mihit ved aaedeng. Nehe angu ene Simon. Aing ekarajang ba binanta ebuar ening ahamulang. ");
INSERT INTO beu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Uanguveng angu, Roma etentara nu, ene Kornelis. Aing angu tentara nehe ratu nu enehe eele. Ing angu Italia mi hoa. Ana bendar Kaisarea mi mihi. ");
INSERT INTO beu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Omi mang Lahatala midadanang, bot ehava omi enehe ang naung di emangpi aulang. Ana nehe masiking toang ioang moling, bot ana kalakat sambajang Lahatala At mateng. ");
INSERT INTO beu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ved nu adana, oma oda tue vedba, emenghula iipalna edadenang ana uuling ateing se Lahatala Egahingvala sorga mi nu hoa senge earut hula, “Kornelis!” ");
INSERT INTO beu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelis uuling gahingvala sorga mi hoa angu ateing muse, ana uangmarit etatabi. Angmuse ana taaning hula, “Nimang, naba ba anga?” Gahingvala angu ebalet hula, “Lahatala Ana eesambajang ang naung vengmee tila, bot aana oomi aaung metma nehe emangpi iadana angu Ana vengani. Base Lahatala Ana Omi aaing vengsanang. ");
INSERT INTO beu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Angase aana nehe gahing bendar Yope mi ila senge nehe nu ene Simon Petrus, angu earut at hoa. ");
INSERT INTO beu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ana ue nehe nu ehava tang eadil mi tahi angu mi mihit vengtahang. Nehe angu ene Simon. Aing ekarajang ba binanta ebuar ening ahamulang.” ");
INSERT INTO beu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Gahingvala sorga mi hoa angu Kornelis eahalang muse, nehe ba ekarajang pina angu nehe aaru, bot etentara nu andi omi metma Lahatala midadanang sehi angu ana iaru. ");
INSERT INTO beu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Angmuse Kornelis ana na emangpi ba gahingvala sorga mi hoa vengbanang angu, vengsarentat metma iat hubai, sengmuse ana ing gahing iot bendar Yope mi ila. ");
INSERT INTO beu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Emi tobang, oma ved hahama muse, Kornelis ana nehe gahing ang naung ila Yope abung. Uanguveng, Petrus mida Simon ehava eomi atela angu mi sambajang. ");
INSERT INTO beu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ana sambajang sehi, aarunge ana rasa se ava malapal, anguba ana hula naadang hengi. Aulang aarunge nehe jedung mod vengharaka sehi. Ana sambajang sehi se, Lahatala Ana Ekavasa metma etubing emenghula ana iipalna edadenang. ");
INSERT INTO beu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ana uuling ateing se burang viaha baleleng, ang muse noang talaling eele nu ava-apaleteng, engbidil buta angu mi hili. Sengmuse noang talaling eele angu ava alolang hela. ");
INSERT INTO beu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Noang talaling eele omi angu, ana uuling ateing se, binanta rupa-rupa ue mi, benangba binanta ia buta, binanta atou metma eera, bot dung rupa-rupa. ");
INSERT INTO beu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Bot ana nehe amal nu vengmee se aing gahing hula “Petrus! Aaungba tahi! Binanta anga naung sabele senge aaungba ana adang!” ");
INSERT INTO beu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aarunge Petrus ebalet hula, “Niang Nimang! Ekang aulang ekang! Na bae binanta erupa aulang ang naung adang jedung! Ning nehe Yahudi angu binanta aulang ang naung emangpi ni vengpalula base ni vengaahiling!” ");
INSERT INTO beu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aarunge nehe amal angu ebalet hula, “Lahatala mateng iilat hula, na nu hamulang iila se, aaing ekang mateng hula angu karita ekang!” ");
INSERT INTO beu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Noang talaling eele angu ava-apaleteng mitue sengmuse, ana bale ava ohit burang mi mida. ");
INSERT INTO beu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Angmuse Petrus ana omi mi jedung vengpikir sehi, senge hula naba ba ava-apaleteng angu evengbanang tatalang. Uanguveng angu, Kornelis ana nehe gahing ang naung ila Simon ehava eviaha mi tahi tila. ");
INSERT INTO beu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Angmuse ini nehe nu earut senge adang taaning hula, “Nehe nu ene Simon Petrus ba hava anga mi mihit vengtahang angu, ana ue ee niang?” ");
INSERT INTO beu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrus ana jedung naba ba ava-apaleteng angu evengbanang angu vengpikir sehi se, Lahatala ERoh Hamulang at hubait hula, “Petrus. Nehe aaedeng ue hoa alolang mi tahi tila. Ini hoa aaing aalaping. ");
INSERT INTO beu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aana hela senge aaungba iamulung ila. Ekang oomi vang-vang ekang. Ing angu, bae Yahudi enehe niang, aarunge aana ekang venguukur hula ing angu nehe karita ekang. Ekang nehe Yahudi ehada angu eamulung ekang. Naing ba ing gahing iot hoa aat ila.” ");
INSERT INTO beu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Angmuse Petrus ana hela nehe ang naung ing harak, sengmuse ana hula, “Naing anga ba, iini naing aalaping. Iinang tue hoa naba ening?” ");
INSERT INTO beu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Angmuse ini ebalet hula, “Roma etentara enehe eele nu ning gahing anga mi hoa. Aing angu tentara ratu nu enehe eele. Aing angu omi aaung, bot omi Lahatala midadanang. Yahudi enehe toang ang naung nehe anga eaaung angu ateing iila. Meleng angu ba, Lahatala Egahingvala sorga mi hoa ninehe eele angu aing gahing ot nimang Petrus abanang hoa ehava mi, senge ana hula nimang Petrus emateng angu vengmee.” ");
INSERT INTO beu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Vengmeet aulang muse, Petrus ana iabanang hula kua angu iot angmi tiat vengtahang. Emitobang muse, Petrus ana iat hama-hamat lamal. Nehe omi Mutu Yesus vengaanamang aaeedeng Yope mi ang naung di iat hama-hamat ila. ");
INSERT INTO beu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kua angu ini via mi tia, emitobang sengmuse ini ila bendar Kaisarea mi. Ila Kornelis ehava mi se, ana iading sehi. Ehava omi enehe bot eiia-mutu ang naung, bot eserang ba ini tominu ang naung ana ing kumpul ue angmi. ");
INSERT INTO beu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petrus hula hava angu mi maso angmuse, Kornelis ana va aing harak, angmuse ana hela Petrus ia eelami kuku muding senge aing somba. ");
INSERT INTO beu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aarunge Petrus ana aing ohit aloming atahing, sengmuse at hubait hula, “Kaku aaungba tahi. Ekang naing somba ekang. Se naing anga di nehe ba emenghula aaing edadenang.” ");
INSERT INTO beu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Vengmeet aulang muse, Kornelis ana aloming tahi. Angmuse oleve itat mateng, senge lamal masot hava omi mi mida. Petrus ana uuling ateing se, nehe toang angmi taing vengkumpul iila, senge ading sehi. ");
INSERT INTO beu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Angmuse Petrus ana mateng hula, “Nekaku naung. Iini nehe Yahudi eagama evia-via angu ateing iila. Niagama angu eamulung se, ni ekang iing ba nehe aabeung ang naung iing venggao ekang. Nabamu hula ila masot iihava omimi. Aarunge Lahatala Ana metma netubing, bot Aing ba vengbanang iilat hula, na nu hamulang se, naing ekang venguukur hula na angu karita ekang. Ba angase, na bae nehe aabeung ang naung venguukur hula ing angu nehe karita niang iila. Se Lahatala Ana vengbanang hula nehe emangpi angu pi malekang iat aabeta hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Angu ebele ba uanguveng iini ila nearu muse, na tahit lamal hoa. Na bae nava tahang niang, se Lahatala ana nat hubait aulang iila angu ebele. Aarunge iini nat hubai hengi! Etatalang ba iini not anga mi hoa?” ");
INSERT INTO beu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Angmuse Kornelis ana emangpi vengsarentat hula, “Venangtang buta, ved hahela, na nehava angmi sambajang. Mibaroti se, nehe mehal nu napang aadang mi tahi sehi. Epakiang angu huring jara. ");
INSERT INTO beu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Angmuse ana nearut hula, ꞌKornelis! Lahatala eesambajang ang naung vengmee tila, bot eeoomi aaung metma nehe emangpi adana angu Ana vengani. ");
INSERT INTO beu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ba angase, nehe gahing bendar Yope mi ila nehe nu ene Simon Petrus angu, earut at hoa. Ana ue hava nu tang eadil mi tahi angu mi mihit vengtahang, nehe nu ekarajang binanta ebuar ening ahamulang angu ehava. Andi ene Simon.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Angu ebele ba, na uuser nehe gahing senge ila eearut aat hoa. Ni eeaaung vengbanang etatabi, se aana hoa iila anga ebele. Base anga se, ni taing vengkumpul anga mi hula emangpi ba Lahatala Ana metma veng aaing gahing angu aana metma niat hubai, senge ni vengmee!” ");
INSERT INTO beu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Angmuse Petrus mateng hula, “Angase uhavede na ateing hula, Lahatala angu etatabit nehe emangpi euuling hama sehi. Ana bae nehe apang kalalang hula, anga Yahudi enehe, bot eaabeung angu bae Yahudi enehe niang niang. ");
INSERT INTO beu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nehe lelang taang omimi aabeta di omi angu Lahatala midadanang, bot aaung-hama anguba ening Eomi angu eamulung se, angu nehe ba Lahatala Omi vengbaa. ");
INSERT INTO beu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Se naba ba Lahatala metma ning ba bangsa Israel veng niat hubai angu iini ateing hula, Ana Kristus angu gahing iila, benang ba Yesus angu. Angmuse Yesus angu, aamina senge nehe emangpi ing metma Lahatala At toang aaung. Bot Yesus angu, Aing ba metma nehe emangpi iManaing ening. ");
INSERT INTO beu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Iing di bot naba ba jadi Propinsi Yudea mi iipi bot Galilea mi angu vengmee tila. Sarenta angu Yohanis ana nehe at hubait hula, ini malekang iahalang ang naung vengbaroti senge bot malekang ing sarani senge metma tanda ening hula, Lahatala Ana iat aaung-hama tila. ");
INSERT INTO beu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Angmuse Lahatala Ana ERoh Hamulang angu metma Yesus, Nasaret enehe angu enang. Lahatala bot Ekavasa angu di metma Yesus enang. Yesus Ana ila mana-mana kanap senge na emangpi ba aaung-hama angu ening metma nehe toang ang naung iadana. Bot Ana nehe ba setang enehe eele ing ening susa ang naung ioang moling. Ana ening aulang, se Lahatala Ana At hama-hama angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Se naba ba Ana bendar Yerusalem mi bot nehe Yahudi epor taang ening iila angu, ning anga ba uuling nieng taang ateing iila. Masiking aulang, aarunge nehe Aing metma leut vengpakut ahelet ila vengaamina tila. ");
INSERT INTO beu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ana aamina tila, aarunge emietang aaru muse, Lahatala Aing ening bale aabeta. Angmuse Ana Ava matubing, senge nehe ateing hula, Ana etatabit bale aabeta tila. ");
INSERT INTO beu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Uanguveng angu, Lahatala bae Yesus Aing metma nehe emangpi etubing niang. Aarunge ning ba Lahatala vengtalail anguba uanguveng Yesus Ana aabeta tila angu Ana metma nitubing se Yesus Ana niat naadang hama-hama angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Base, Lahatala ba ning gahing senge ila nehe ba turangmi Ana matubing iila, benang ba Yesus angu, vengbanang tarang metma nehe at hubai. Lahatala Ana Yesus angu Aing ohit metma sorga bot naraka eHakim ening iila, senge eningse nubaba Lahatala At aabetat ejajehing bot nubaba niang angu. Aing ba vengputus metma nehe ba aamina tila bot jedung aabeta sehi ang naung iadana. ");
INSERT INTO beu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Turang jamang mi, Lahatala Ehurvala emangpi angu di Yesus Aing matubing iilat vengbanang hula, nehe emangpi ba omi metma Aing vengaanamang angu, eningse Lahatala Ana ing tarima, bot eningse Lahatala Ana iahalang-iavali ang naung vengahi.” ");
INSERT INTO beu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus jedung mateng aulang sehi se, mibaroti se Lahatala ERoh Hamulang angu hoa nehe emangpi ba ue aing vengmee angu ing vengbaa. ");
INSERT INTO beu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Angmi angu Petrus eserang Yahudi enehe ang naung at hama-hamat bendar Yope mi hoa angu di ila Kornelis ehava bendar Kaisarea mi angu mi. Nehe toang ba Lahatala ERoh Hamulang ing vengbaa angu ini uuling ateing muse, ini mijonga, se Lahatala Ana ERoh Hamulang metma nehe ba bae Yahudi enehe niang enang angu ini uhavede uuling ateing angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ini vengmee se, nehe Kornelis ehava mi ang naung hur rupa-rupa metma itat mateng, bot ini Lahatala tajaning. Angmuse Petrus mateng hula, ");
INSERT INTO beu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Iini mang iina euuling! Nehe anga naung di Lahatala ERoh angu ing vengbaa tila emenghula ping edadenang. Base angase aaungba pi ing sarani. Iiba bae venghapa niang iila.” ");
INSERT INTO beu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Angmuse Petrus ana nehe aabeung iot Kornelis bot nehe angmi ang naung ing sarani, senge ing di metma Mutu Yesus Enehe ening. Angmuse ini banang Petrus iat mihit ved aaedeng. ");
INSERT INTO beu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesus Eetvala bot nehe aabeung ba iomi vengaanamang Yerusalem mi angu vengmee tilat hula, nehe ba bae Yahudi enehe niang di Lahatala Ehur Aaung hama angu ini vengmee bot metma iomimi tila. ");
INSERT INTO beu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Base, Petrus ana bale ila Yerusalem mi angmuse, nehe aaedeng iomi vengaanamang ba Yahudi mi angu ini aing ening ahalat ");
INSERT INTO beu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","hula, “Aana ening tatalang iila ba angu? Aana pi hada angu ateing, ee niang? Etatalang ba aana ila nehe ba bae Yahudi enehe niang ehava omimi mida bot iat naadang jalna? Ekang aulang ekang, se ing angu, bae pi hada sunat angu eamulung jedung! Pi bae ing venggao niang!” ");
INSERT INTO beu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Angmuse naba ba jadi tila angu emangpi Petrus ana vengbanang tarang hula, ");
INSERT INTO beu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Bendar Yope mi, na sambajang sehi se, Lahatala Ana Ekavasa metma netubing, emenghula iipalna edadenang. Na uuling ateing se burang viaha baleleng, angmuse noang talaling eele nu ava-apaleteng, engbidil buta angu mi hili. Ang muse noang talaling eele angu ava alolang nebele hela. ");
INSERT INTO beu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Noang talaling eele omi angu na kalalang senge ateing se, binanta eapapahing na uuling ateing, benang ba binanta ia buta, binanta atou metma eera, bot dung eapapahing. Binanta uangu emangpi, ping ba nehe Yahudi ang naung vengaahiling. ");
INSERT INTO beu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Bot nehe amal nu na vengmee se naing gahing hula, ꞌPetrus! Aaungba tahi! Binanta anga naung sabele senge aaungba aana adang!ꞌ ");
INSERT INTO beu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Aarunge na ebalet hula, ꞌNiang, Aaing ba ne Manaing! Ekang aulang ekang! Na bae binanta erupa aulang ang naung adang jedung! Ning nehe Yahudi ang naung binanta uangu emangpi ni vengpalula bot ni vengaahiling!ꞌ ");
INSERT INTO beu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Aarunge nehe amal angu ana nehur angu ebalet vengbanang hula, “Lahatala mateng iilat hula, na nu hamulang iila se, aaing ekang venguukur hula angu karita ekang!” ");
INSERT INTO beu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na uuling ateing se noang talaling eele angu ava apaleteng mi tue, sengmuse ana bale ava ohit burang mi mida. ");
INSERT INTO beu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Uanguveng angu, nehe tue hoa hava angu mi. Ini Kaesarea mi ba hoa naing aalaping. ");
INSERT INTO beu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Angmuse Lahatala ERoh Hamulang nat hubait hula, ꞌAana hela nehe tue angu iamulung ila. Ekang oomi vang-vang ekang. Ing angu, bae Yahudi enehe niang aarunge aana ekang venguukur hula ing angu nehe karita ekang!ꞌ Vengmeet aulang sengmuse, pi nehe inang taling anga, ing di nat hama-hamat Kaisarea mi ila. Angumi ning emangpi ila Roma etentara enehe eele nu ehava omimi mida. ");
INSERT INTO beu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nehe eele angu sarentat hula, ꞌVed aaedeng evaila anga, na uuling ateing se Lahatala egahingvala sorga mi nu hoa nehava mi. Ana vengbanang hula, ꞌAana nehe aaedeng ing gahing Yope mi ila, nehe nu ene Simon Petrus angu, aing harak, senge at angami hoa. ");
INSERT INTO beu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Eningse nehe angu ana Lahatala Eaaung-hama angu metma aaing bot eehava omi enehe bot eiia-mutu ang naung emangpi veng iiat hubai, aulange iiahalang-iiavali ang naung Lahatala Ana vengahi bot aabetang ejajehing angu Ana metma maiinang.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Angu ebele, na Lahatala Evia Aabetang angu metma veng iat hubai. Mibaroti se, Lahatala ERoh Hamulang hoa nehe ang naung emangpi ing vengbaa, emenghula tura Ana metma mapinang iila angu edadenang. ");
INSERT INTO beu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Uuling ateing hula ing di Lahatala ERoh angu ing vengbaa tila muse, na Mutu Yesus Emateng tura angu mi vengani se hula, ꞌYohanis ana mang jar ba metma ing sarani, aarunge eningse Lahatala angu Ana ening miaung-mihama bot Eroh Hamulang angu Ana metma iiomimi.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Lahatala Ana ERoh Hamulang angu metma nehe aabeung ang naung inang, emenghula Ana metma mapinang iila angu edadenang. Base naba ba Lahatala Ana ening iila angu, na bae lavang niang.” ");
INSERT INTO beu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Vengmeet Petrus ana mateng aulang muse, ini bae aing ening ahala niang iila. Angmuse ing emangpi Lahatala Aing tajaning senge vengbanang hula, “Lahatala Ana via bukat abaleleng senge nehe ba bae Yahudi enehe niang ang naung di iahalang-iavali ang naung ini vengbaroti senge aabetang ejajehing angu Lahatala Ana metma mainang.” ");
INSERT INTO beu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tura, nehe Stepanus aing ening ana aamina tila muse, nehe bot nehe ba omi Yesus vengaanamang ang naung ing ening susa-lala. Angu ebele ini bihit tarae-teapahing ila taang-taang mi. Iiba bihit ila propinsi Fenisia mi. Iiba bot bihit ila Siprus por taang, bot iiba angu bihit ila bendar Antiokia ba propinsi Siria mi angu mi. Nehe ba bihi ang naung ini Mutu Yesus Ehur Aaung hama angu metma taang-taang mi vengbanang. Aarunge ini mang metma inehe Yahudi ang naung ba veng iat hubai. Ini bae metma nehe aabeung ang naung veng iat hubai niang. ");
INSERT INTO beu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aulang aarunge Lahatala Enehe ba Siprus por taang bot bendar Kirene mi ang naung di ue. Angu ba ing iiba angu lamal milalut ila bendar Antiokia ba propinsi Siria mi angu mi. Ing anguba Mutu Yesus Ehur Aaung hama angu metma nehe ba bae Yahudi enehe niang angmi ang naung veng iat hubai. ");
INSERT INTO beu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Lahatala Ana Ekavasa angu metma ma inang, angu ebele nehe toang omi metma Mutu Yesus vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","24","Uanguveng angu, nehe ba omi Mutu Yesus vengaanamang ba Yerusalem mi ang naung vengmee se hula, nehe aabeung Antiokia mi ang naung di iomi metma Yesus vengaanamang iila. Angmuse nehe nu ene Barnabas angu ini aing gahing ot ila angmo mi iuuling. Barnabas anga, nehe ba omi aaung, ana etatabit omi metma Lahatala vengaanamang, bot Lahatala ERoh di aing veng. Barnabas ana hoa angmi muse, ana uuling ateing se hula, etatabit Lahatala Eaaung-hama angu Ana metma nehe aabeung ang naung di iaabetang angu omimi tila. Angu ebele ana omi etatabit navera. Angmuse ana nehe ang naung iavomung-iapahang senge ini Lahatala Evia aaung-hama angu etatabit eamulang. Ening aulang muse Lahatala Enehe angu taang maveng toang. ");
INSERT INTO beu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Seng angmuse, Barnabas ana bot bendar Tarsus mi ila Saulus aing aalaping. ");
INSERT INTO beu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ana aing harak muse, ana Saulus abanang, senge ini hama-hamat bale Antiokia mi ila. Ila Antiokia mi muse oleve Lahatala enehe ang naung iat hama-hamat mihi, ila mi tung nu. Ved kakanap oleve Mutu Yesus Evia Aabetang angu metma nehe toang ang naung iavomung-iapahang. (Bendar Antiokia angu mi senge, nehe ba omi Mutu Yesus vengaanamang ang naung nehe iene maveng hula, ꞌnehe Kristenꞌ). ");
INSERT INTO beu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Oleve jedung Antiokia mi sehi se nehe aaedeng Yerusalem mi hoa. Lahatala Ana nehe ang naung ing metma Ehurvala ening. ");
INSERT INTO beu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hurvala ang naung, nu ene Agabus. Lahatala ERoh at hubait hula, “Eningse malapal-tabonggal por alolang anga mi iipi, ila etupa ang naung taang.” Angmuse naba ba Lahatala ERoh vengbanang angu ana metma nehe emangpi veng iat hubai. (Naba ba ana vengbanang angu Roma eraja eele ene Klaudius, parenta pina sehi angmuse jadit aulang.) ");
INSERT INTO beu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Agabus emateng angu vengmee muse, Mutu Yesus Enehe ba Antiokia mi ang naung, ini tominu sengmuse seeng metma taing veng senge panatut metma nehe ba iomi Mutu Yesus vengaanamang ba propinsi Yudea mi aabetat susa ang naung inang. Seeng ba ini metma taing veng angu nu-nut ibisa angu eamulung. ");
INSERT INTO beu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Seeng metma taing veng sengmuse, ini Barnabas bot Saulus oleve ing gahing senge seeng angu baning ila metma jamaat eboma angmo mi ang naung inang, senge paul metma nehe susa ang naung inang. ");
INSERT INTO beu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Uanguveng angu raja Herodes ana nehe ba omi Mutu Yesus vengaanamang ang naung iiba ing ening etatabit susa-lala. ");
INSERT INTO beu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ana nehe parenta senge ini ila kalevang metma Yakobus aing patait ening ana aamina. Yakobus angu, Yohanis ekaku mutu. ");
INSERT INTO beu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Uanguveng Herodes uuling ateing se hula, Yakobus aamina angu nehe Yahudi enehe eele ang naung iomi sanang angu ebele, ana bot taang ening maveng. Angu ba ved eele nehe vengbanang hula, pesta roti bae bibit maveng niang angu adana, Herodes ana nehe gahing ila Petrus adoi. ");
INSERT INTO beu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ini Petrus adoi sengmuse, ini at ila metma bui mi maso. Ini tentara kelompok buta gahing iot taing tatelul Petrus aing jagat kua jala. Tentara kelompok nu se, nehe buta. Herodes hula pesta angu mitavala se ana Petrus eparkara angu nehe toang iapangaadang mi vengurus. ");
INSERT INTO beu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ini bui mi Petrus aing tahang, aarunge nehe ba omi Mutu Yesus vengaanamang ang naung etatabit sambajang alolang niang, Lahatala abanang metma Petrus adana. ");
INSERT INTO beu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Emitobang muse, raja Herodes hula Petrus eparkara angu nehe toang iapangaadang mi vengurus. Aarunge kua angu, ini bui mi rante aaru metma Petrus aing parta, sengmuse ana tentara aaru ihahama mi tia. Bot tentara aabeung ang naung viaha mi jaga. ");
INSERT INTO beu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mibaroti se, Lahatala Egahingvala sorga mi nu hoa angu mi Petrus abung tahi sehi, senge kamar angu mang huring jara. Angmuse gahingvala angu ana Petrus aing oombet ot tahi senge mateng hula “Petrus! Uuser tahi!” Uanguveng angu di rante oola aaru angu Petrus atang vengpodut baat hela. ");
INSERT INTO beu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Seng angmuse, gahingvala angu aing gahing hula, “Eekondo angu pina! Bot eesendal angu pake!” Petrus ana paket sengmuse, gahingvala angu bot taang gahing hula, “Eekondo eele angu di pina, senge aaungba namulung!” ");
INSERT INTO beu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Angmuse Petrus ana gahingvala angu amulung sengila ba, oleve bui mi lamal kaluar hela. Aarunge Petrus ana venguukur hula, ana mang iipal na, aarunge etatabit jadit aulang. ");
INSERT INTO beu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Oleve lamal ila jaga emana halomang bot lamal ila emi aaru angu mi tila muse, oleve bot ila viaha eele oola angu mi. Viaha angu mang ena baleleng. Angmuse oleve kaluar hela senge via ba bendar mi ila angu oa. Mibaroti se, Lahatala Egahingvala angu, ila Petrus adut enang kolang ue angmi. ");
INSERT INTO beu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Gahingvala angu ue niang iila muse, Petrus ana ava ateing hula, “Etabi! Angase na uhavede ateing hula, Lahatala Ana etatabit Egahingvala angu gahing hoa senge naing metma Herodes atang angu eahalang iila. Lahatala Ana ening aulang senge nehe Yahudi ang naung iomi ba jasi angu ini ekang ening metma nadana ekang.” ");
INSERT INTO beu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Aulang sengmuse Petrus ana Maria ehava mi ila. Maria angu, benang ba Yohanis iva. Yohanis angu, ene abeung, Markus. Maria ehava mi angu, nehe toang ue taing vengmihit sambajang Lahatala abanang, aulange Ana Petrus oang moling aing ening lohit metma eparkara angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ila hava angu mi muse, Petrus ana lapa etundil angu vengpapahing bot ana arut amal aelet ene vengbanang. Angmuse balentavala jangu nu ene Rode, ana va eng uuling hula nubaba hoa angu. ");
INSERT INTO beu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Petrus amal angu vengmee muse, Rode ana ateing iila. Rode, ana navera angu ebele ana bihit bale hava omimi mida. Rode ana vengtajebing bae viaha bukat metma Petrus enang ot maso niang. Bale hava omimi mida muse ana nehe ang naung iat hubait hula, “Petrus ana ae alolang tahi sehi!” ");
INSERT INTO beu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Aarunge ini ebalet hula, “Bae bisa niang! Aana buning. Ekang samamamateng aulang ekang!” Aarunge Rode ana vengbanang alolang niang hula, “Niang! Angu etabit Petrus amal! Ana poe alolang tahi sehi!” Aarunge ini mang iomi metma na aababeung bot mateng hula, “Uangu oma Lahatala Egahingvala sorga mi ba Petrus amanang.” ");
INSERT INTO beu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ini jedung vengnatataanang sehise, Petrus ana taang arut amal aeelet ene vengbanang, angmuse ini viaha medi. Angmuse, ini mibaroti bot mijonga, se Petrus ba ue angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus ana atang angu beok senge ing emangpi taimang. Seng angmuse ana metma iat sarenta hula Lahatala Ana aing metma bui eahalang iila. Bot ana ing gahing hula, “Iini ila na anga emangpi metma Yakobus bot etvala aabeung ang naung veng iat hubai.” Angmuse Petrus ana lamal mana aabeung mi ila. ");
INSERT INTO beu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Emi tobang kukuaveng, tentara ba jaga ang naung ini uuling ateing se, Petrus bae ue niang iila muse, iomi iipi sehi, bot ini iuangmarit etatabit, se ini bae ateing niang hula eningse nehe naba ba ening metma iadana angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes ana ateing aulang muse, ana bot bale ing parentat ila Petrus aing aalaping. Aarunge ini bae aing harak niang. Bot Herodes ana tentara aabeung parenta senge ini tentara jaga ang naung emangpi iameang. Ang muse Herodes ana lamal ila Yudea eahalang, senge bendar Kaisarea mi mihi. ");
INSERT INTO beu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Uanguveng angu, nehe ba bendar Tirus bot Sidon mi ang naung biasat ila raja Herodes epor taang mod beli. Aarunge raja angu, ana iat tebelung luung iila. Angmuse ini itat tominu senge via aalaping ila at toang aaung. Base ini nehe aaedeng vengtalail senge ila Herodes aing harak. Tirus enehe bot Sidon enehe angu ila Kaisarea mi muse, ini Blastus at serang, senge aing metma inehe ening via buka aulange ini bisa Herodes aing harak. Blastus angu, nehe eele ba eraja ehava omimi karajang. ");
INSERT INTO beu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Angmuse Herodes ana vengjali, base ini jol nu vengtalail senge ini itaing harak. Ved uangu, ini acara eele ening. Herodes ana ekondo eele pina, senge ana ekadera parenta angu taang mihi. Angmuse ana nehe toang ang naung iat mateng. ");
INSERT INTO beu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Amal angu vengmee muse, nehe ang naung aing tajaning hula, “Amal angu vengmee! Anga bae nehe biasa amal niang! Anga aaneda amal!” ");
INSERT INTO beu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mibaroti se, Lahatala Egahingvala sorga mi nu hoa Herodes aing ening dila, se nehe Herodes aing tajaning angu ana tarima, aarunge Herodes bae Lahatala Aing tajaning niang angu ebele. Base iip ang naung Herodes eboa iipi angu adang sampe ana vengaamina. ");
INSERT INTO beu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Base Lahatala Ehur Aaung hama angu aalilit taang berang maveng, bot nehe ba Mutu Yesus Evia Aabetang eamulung angu di taang toang maveng. ");
INSERT INTO beu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas bot Saulus oleve nehe ba Antiokia mi ang naung iseeng angu baning ila Yerusalem mi metma nehe enang sengmuse, oleve bot bale Antiokia mi ila. Nehe kuar nu ene Yohanis angu di ini at ila. Yohanis ene eabeung angu, Markus. ");
INSERT INTO beu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bendar Antiokia mi angu, nehe toang iomi Mutu Yesus vengaanamang iila. Nehe aaedeng Lahatala ing gahing metma Ehurvala ening, bot aaedeng angu di Ana ing gahing nehe avomung-apahang. Ing angu, benang ba: Barnabas, Simeon, ba nehe biasa earut hula, ꞌKaanaꞌ, Lukius, bendar Kirene mi angu, Menahem, ba kiki sehimi ini nehe raja Herodes oleve ing gariang hama-hama angu, bot Saulus. ");
INSERT INTO beu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ooras nu, nehe ba omi Mutu Yesus vengaanamang ang naung, ini kanempel, bot ini taing vengkumpul senge Lahatala Aing tajaning. Angmuse Lahatala ERoh Hamulang iat hubait hula, “Iini Barnabas bot Saulus oleve ing vengtalail senge, Nekarajang ba Na vengpiling metma ma inang angu ini vengkarajang.” ");
INSERT INTO beu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ini kanempel bot sambajang sengmuse, ini iatang metma Barnabas bot Saulus oleve ing taang mea senge ing gahing. Angmuse oleve ila Lahatala Ekarajang angu at lamal. ");
INSERT INTO beu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Uanguveng angu Lahatala ERoh Hamulang Barnabas bot Saulus oleve ing gahing lamal ila mana kanap, ehalomang angu ini bendar Seleukia mi. Yohanis (nehe ba ini earu hula, Markus) angu di iamulung hama-hama. Ila angmi muse, ini kampal hila aalarit Siprus por taang ila, angmuse ini hela bendar nu mi, ene Salamis. Angumi, ini ila nehe Yahudi ang naung ihava hamulang mi maso senge Lahatala Ehur aaung-hama angu metma nehe ang naung iavomung-iapahang. ");
INSERT INTO beu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Barnabas bot Saulus oleve lamal ila Siprus por taang angu, ini lamal aabang ba por angu taang ang naung migoleng. Angmuse ini hoa bendar nu ue por angu edenaveng ene Pafos angu di mi. Gubernur angu ue bendar angu mi mihi. Ene Sergius Paulus. Aing angu, nehe hur adang. Ana vengmee se hula, Barnabas iimal ebendar mi hoa iila muse, ana nehe gahing ila iaru, se Lahatala Evomung-pahang angu omi midadanang hula vengmee hengi angu ebele. Aarunge ang mi angu di, Yahudi enehe nu ue, ene Bar Yesus (bot ene aabeung Yunani ehur mi se hula, ꞌElimasꞌ). Aing angu tani enehe eele. Ana biasat nehe ajajalat hula, andi Lahatala Ehurvala. Ana gubernur angu at serang. Base Barnabas iimal hoa angmuse, Elimas ana gubernur omi taang senge ekang ing tarima ekang. Bot Elimas ana omi taang senge ekang omi metma Yesus vengaanamang ekang. ");
INSERT INTO beu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Aarunge Lahatala ERoh Hamulang angu Saulus aing veng (Saulus ene eabeung angu Paulus), base ana eng metma tani enehe eele angu etatabit euuling. Angmuse ana mateng hula, ");
INSERT INTO beu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ee, Elimas! Aaing setang oal! Aaing sukat nehe ajajala! Aana nehe ajajalat alolang niang! Emangpi ba aaung angu aana malavang. Aulang angu ebele, na ateing se aana setang enehe eele angu eamulung. Aana ekang bot ening aulang ekang. Lahatala Evia ba molo angu aana bot ekang hula vengtering ekang. ");
INSERT INTO beu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Aana vengmee hengi! Eningse Lahatala Ana aaing hukung. Eeng angu ening se kete, bot aana bae uuling na iiba ateing niang, ila ved aaedeng.” Paulus mateng aulang sengmuse, Elimas eng angu kete tila. Angmuse ana bir panahing lamal, senge nehe panahing iot atang pina, sengila ba atang tedot lamal. ");
INSERT INTO beu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gubernur angu uuling eng taang ateing aulang, bot ana vengmeet Barnabas iimal Yesus ehur aaung-hama angu vengmaring muse, ana mijonga, angmuse ana bot omi metma Yesus vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bendar Pafos ba Siprus por taang angu mi muse, Paulus bot eserang ang naung imangpi kampal hila senge aalarit iila bendar nu propinsi Pamfilia mi ene Perga angu mi. Angu mi, ini kampal taang hela, angmuse Yohanis Markus ana lamal iahalang senge bale Yerusalem mi ila. ");
INSERT INTO beu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perga mi ini aadang taang lamal bendar Antiokia ba propinsi Pisidia mi angu mi ila. Ini ila bendar angu mi, angmuse, uanguveng angu nehe Yahudi ang naung ived hamulang adana, base ini ila nehe Yahudi ang naung ihava hamulang mi Lahatala Aing tajaning eamulung. ");
INSERT INTO beu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Uanguveng angu, Lahatala Ehurvala Musa esurat, bot Lahatala Ehurvala aabeung ang naung isurat ba ini basa. Angmuse, hava hamulang angu enehe eele ang naung, Paulus iimal iabanang hula, “Nimang iimal, iivomung-pahang iiba ue se, ni banang iini vengbanang senge ning emangpi ba anga mi anga niomi ening aanamang.” ");
INSERT INTO beu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Angmuse Paulus ana aloming tahi bot ana atang ohit iot taimang. Angmuse ana mateng hula, “Nekaku naung, iing ba bangsa Israel enehe. Bot niva-nimang aabeung ba agama Yahudi maso tila ang naung, iing di iiomi Lahatala midadanang. Angu ebele na banang iini naing vengmee! ");
INSERT INTO beu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lahatala Ana turang mi ping ba bangsa Israel tidat-timang ang naung ing vengtalail medi tila. Ini ila Masir por taang mihi angu, bae iaabang mamolo niang, aarunge Lahatala Ana aaung-hama metma ma inang ini mihit sanang, anguba itabaning angu taang toang maveng. Seng angmuse Lahatala bot Ekavasa eele angu metma iat Mesir mi kaluar. ");
INSERT INTO beu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Angmuse, ini aabetat por osing eele ba nehe bae ue mi niang angu mi lamal ila mitung ari buta. Ini iong aanamang, aarunge Lahatala Ana mang kilang iat lamal alolang niang. ");
INSERT INTO beu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Angmuse, Lahatala Ana bot bangsa bititu Kanaan por taang angu ening atarahak. Angmuse Ana ipor angu paul, metma tidat-timang ang naung inang, senge metma ipor pasaka ening. ");
INSERT INTO beu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tidat-timang ang naung ini por angu taang aabetat ilelang kanap sampe mitung ratu buta ari iising. Ini por angu toang aabetat mitung ratu bura ari iising sengmuse, Lahatala Ana nehe ba parkara vengpaputus ang naung songgar metma ma inang senge iapang pina, sampe Lahatala Ana bot Ehurvala nu songgar, ene Semuel angu venghili. ");
INSERT INTO beu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Semuel metma Lahatala Ehurvala ening sehi angmuse, tidat-timang ang naung ini banang hula raja ba nu songgar hengi. Angmuse Lahatala Ana Saul angu aing songgar metma raja ening. Saul angu, Kis oal, Benyamin elelang omi. Saul parenta pinat ila mitung ari buta. ");
INSERT INTO beu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Angmuse Lahatala Ana at hela aing metma raja angu eahalang. Senge Lahatala Ana bot Isai oal, ene Daud angu aing songgar, metma Saul etelul ening. Lahatala etatabit Daud omi angu ateing bot Ana mateng hula, ꞌIsai oal Daud anga, elamal-etahi angu Nomi adang baa. Base eningse emangpi angu ana ening Nenomi eamulung. ");
INSERT INTO beu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Uanguveng angu, Lahatala Ana palait hula Daud etabaning angu nu panatu, senge Israel enehe ang naung ing ening lohit metma iahalang-iavali ang naung eola. Nekaku naung na iing emangpi iiat hubait hula, Daud etabaning ba Lahatala Ana vengpalai tila benang ba Yesus angu.” ");
INSERT INTO beu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Paulus ana emateng angu taang hamuat hula, “Mutu Yesus bae ekarajang at lamal jedung angu, nehe nu ene Yohanis, ana Israel enehe ang naung iat hubait hula, ini malekang iava vengbaroti senge iava metma ijasi-iahala angu iola, bot bale Lahatala angu ba eamulung. Sengila ba malekang ing sarani senge matubing hula, ini Lahatala At aaung-hama bot At aabeta tila. ");
INSERT INTO beu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aarunge Yohanis ekarajang angu hula evengtahi muse, ana nehe ang naung iat hubait hula, ꞌIini ekang veng iiomit hula naing anga, Nehe ba turang mi Lahatala vengpalait hula, panatut hoa angu ekang. Venganit aaung-aaung! Nehe nu eningse hula hoa angu iini malekang ading. Aing angu mieele-mibalolu minataang oa. Metma Egahingvala ening di, naing anga bae gahingvala angu at hama niang.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nekaku naung! Iing ba boma Abraham etabaning, bot iing aabeung ba iiomi Lahatala midadanang sehi angu, naing venghele hengi! Lahatala Ana Ehur aaung-hama angu metma piat hubai tilat hula, Ana ping ening lohit metma piahalang-piavali ang naung eola bot aabetang ejajehing angu Ana metma ma pinang. ");
INSERT INTO beu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nehe ba Lahatala vengpalai tila angu, turangmi Lahatala Ehurvala ang naung ini hurak metma nehe angu adana tila. Pi agama enehe eele ang naung, bot nehe aabeung ba Yerusalem mi ang naung di, naba ba hurvala ang naung hurak iila angu basat alolang-niang. Ved hamulang kakanap angse, ini hava hamulang mi maso, senge Lahatala Esurat hamulang angu basa. Aarunge nehe ba Lahatala vengpalai tilat hula panatut hoa benang ba Yesus angu, ini bae Ateing niang. Angmuse ini akal aalaping Aing hukung ameang. Aarunge ini ening aulang senge naba ba Lahatala Ehurvala ang naung hurak iila angu eamulung. ");
INSERT INTO beu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ini parkara ening metma Yesus adana senge hula Aing ening abaang, aarunge ini bae Eahalang iiba harak niang. Aulang aarunge ini ila gubernur Pilatus abanang senge Yesus Aing ening Ana aamina. ");
INSERT INTO beu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Gubernur angu vengjali, angmuse ini Yesus Aing metma leut vengpakut ahele, ila vengaamina. Aarunge emangpi anga di, ening aulang senge nababa Lahatala Ehurvala ang naung hurak iila angu eamulung. Seng angmuse, Ebaring angu ini leut taang at hela, sengila ba At ila metma daang omi mi mea. ");
INSERT INTO beu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Aarunge Yesus Eaamina omimi angu, Lahatala Ana Ekavasa metma Yesus Aing ening Ana bale aabeta tila. ");
INSERT INTO beu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yesus Ana bale aabeta tila muse, Ana Ava metma nehe toang etubing mitoang-mirae. Ing angu ba At hama-hamat propinsi Galilea mi hoa, ila Yerusalem mi angu. Ing ba Yesus Eaamina bot Eaabeta angu uuling ieng taang ateing anguba ini metma Israel enehe ang naung emangpi veng iat hubai.” ");
INSERT INTO beu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Paulus ana emateng angu taang hamuat hula, “Alang! Naing bot Barnabas, noleve anga, ni hoja aaung-hama anga metma iiat hubai hula, naba ba Lahatala metma tidat-timang ang naung iat palai tila angu, angase emangpi jadi tila. Lahatala Ana Yesus Aing ening Eaamina angu omimi bale aabeta tila. Mazmur buku tajaning e eela aaru omi mi angu, Yesus Nehe ba Lahatala Ana vengpalait hula panatut hoa angu hurak vengbanang iilat hula: ꞌAaing anga Noal. Naing ba Iimang. Vede ved anga, Na Aaing ohi senge Aana parenta pina.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Turang mi Lahatala palai tilat hula, Neheba Ana vengpalai tilat hula panatu hoa angu eningse Ana ening bale aabeta, senge Nehe angu bot bae taang aamina niang iila. Angu ebele, Lahatala Ehurvala hurak hula, ꞌTurangmi Nepalai angu Na metma raja Daud at hubai tila senge hula aaung-hama metma ma enang. Ba angase, Na hula palai angu bot metma aandi aat hubai, se aaingba Daud etabaning angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mazmur buku tajaning aabeung di Daud hurak hula, ꞌLahatala Ana bae Emalea ba Hamulang ebaring angu vengkilang, Edaang omimi musi niang.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","37","Hur kokal ba Daud ana metma Mazmur buku tajaning mihurak anga Daud bae ava vengbanang niang! Pi ateing aulang, se raja Daud ana Lahatala Eomi eamulung aaung-hama toang ening iila angu ebele, seng angmuse ana aamina. Ana aamina, angmuse ini aing taloul. Bot ebaring angu musit seng iila. Base pi ateing hula, Daud bae ava vengbanang niang, aarunge Nehe aabeung ba ana vengbanang, benang ba Yesus angu. Yesus angu eningse Ana aamina aarunge Lahatala Ana Aing ening bale aabeta. Angu ebele Ebaring angu bae kabingdena musi di niang. ");
INSERT INTO beu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Base, kaku naung, iini vengmeet aaung-aaung! Nehe benang ba, Yesus angu! Angu ebele pi malekang tomi metma Aing vengaanamang, senge pijasi-piahala emangpi ba pi ening iila ang naung Lahatala Ana vengahi. Pi ateing iilat hula, boma Musa eparenta evia-via emangpi angu pi eamulung di, angu enangkolang se bae bisat ping ening Lahatala apangaadang mi molo niang. Aarunge pi tomi metma Yesus vengaanamang se, Lahatala Ana pijasi-piahala ang naung vengahi. ");
INSERT INTO beu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Angu ebele iini malekang veng iiomit aaung-aaung. Misavaka, naba ba turangmi Lahatala Ehurvala ang naung vengbanang iila angu iing vengbaa. Ini hurak iilat hula, ꞌVengani, iing ba sukat nehe ehura, bot nehe paduli niang ang naung! Eningse Lahatala Ana na emangpi angu ening metma idana base iini jonga-baroti, bot eningse iini aamina. Iini jedung aabeta sehi se Na na nu ening, aarunge iini bae iiat tarima niang. Nehe metma iiat hubait tila di iini bae iiat manggarati niang”. ");
INSERT INTO beu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulus ana mateng sengmuse, Paulus bot Barnabas oleve tahit hula lamal hava hamulang angu eahalang. Aarunge nehe angmi ang naung iabanang hula ved hamulang eabeung se bot bale hoa, senge naba ba ini vede vengbanang iila angu, bot taang vengbanang maveng. ");
INSERT INTO beu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ini hava hamulang mi kaluar hela muse, nehe toang angmi ang naung ini Paulus bot Barnabas oleve iamulung. Angmuse oleve iavomung-iapahang hula, “Pi ateing hula, Lahatala Omi etatabit aaung metma mapinang. Angu ebele iini malekang iiomi metma Aing vengaanamang.” ");
INSERT INTO beu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Minggu eminu, nehe Yahudi eved hamulang veng muse, nehe bendar angu mi angu emangpi hoa senge hula Lahatala Ehur Aaung-hama angu venghele. ");
INSERT INTO beu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Aarunge nehe Yahudi enehe eele ang naung uuling nehe toang ba hoa Paulus bot Barnabas oleve ing venghele angu ateing muse, ini iomi alil etatabi. Angu ebele Paulus ana mateng sehise, ini aing lavang, bot mateng ehura-emananti. ");
INSERT INTO beu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Aarunge Paulus bot Bernabas oleve etatabit taang baranit mateng bot bae iuangmari niang. Ini mateng hula, “Etabit Lahatala ematurat via bukat metma pingba Yahudi enehe ang naung ma pinang, bot Ana Hur Aaung-hama angu di metma ma pinang iila. Aarunge iini bae iiat metma iomimi niang. Iini ening aulang base, iingba matubing hula, iini bae Lahatala At aabetat ejajehing niang. Ba angase, ni hula Hur Aaung-hama angu baning ila metma bangsa aabeung ang naung ba iat hubai, se iini bae iiat tarima niang iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Se angaba Lahatala Ana metma veng ning gahing iila, emenghula boma Yesaya ana hurak iila angu edadenang hula, ꞌNa iing matubing iila metma jara ening, senge jara angu iini baning metma bangsa aabeung ba bae Yahudi enehe niang ang naung inang, aulange via ba hoa Naing mi tahi angu iini ening ana jara, senge ini uuling Nateing, aulange Na ing vengaahit metma iahalang-iavali ang naung eahalang, senge ini aabetang ejajehing angu harak. Bot iini malekang via angu matubing por alolang anga taang, etupa dena ila etupa dena mi.” ");
INSERT INTO beu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nehe bangsa aabeung ba bae Yahudi enehe niang ang naung vengmeet aulang muse, ini navera. Angmuse ini Lahatala Aing tajaning hula, “Lahatala tajaning! Lahatala EHur Aaung-hama angu, etatabit aaung!” Bot nehe ba turangmi Lahatala vengtalail iila senge At aabetat ejajehing angu ing di ue ang mi. Angmuse ing emangpi angu iomi metma Mutu Yesus vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lahatala EHur Aaung-hama angu aalilit taang-taangmi ila bendar angu mi iipi. ");
INSERT INTO beu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Aarunge bendar angu enehe eele, bot nehe jangu ba eele-balolu ang naung di ue angmi. Iiba angu iomi metma Lahatala midadanang. Aarunge Yahudi enehe ang naung hoa nehe eele ang naung iomi taang, angu ebele nehe ba bendar angu mi ang naung ini Paulus bot Barnabas oleve ing bue sengila ba iaterit bendar angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bendar angu mi kaluar hela muse, Paulus bot Barnabas oleve moro ia veng angu teret bia senge matubing hula, nehe bendar angu mi ang naung iiat bae oleve ing venghele niang. Angmuse ini bale tahi lamal bendar angu eahalang. Ini bot bendar nu ene Ikonium, angu mi ila. ");
INSERT INTO beu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aarunge nehe iomi metma Mutu Yesus vengaanamang iila Antiokia mi ang naung, iomi navera etatabi, se Lahatala ERoh Hamulang iomi ening aanamang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulus bot Bernabas oleve ila bendar Ikonium mi seng angmuse, ini nehe Yahudi ehava hamulang mi maso. Angumi, Lahatala Ehur Aaung-hama angu ini metma veng iat mateng, angu ebele nehe Yahudi toang bot bangsa aabeung enehe toang angu di, iomi metma Mutu Yesus vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Aarunge nehe Yahudi aaedeng ba iagama elamal-etahi angu pinat aanamang senge iat bae Paulus bot Bernabas oleve imateng angu metma iomimi niang angu di, ue angmi. Angmuse ini nehe aabeung ba bae Yahudi enehe niang ang naung iomi taang, angu ebele ini iomi metma nehe ba iomi Mutu Yesus vengaanamang ang naung ialil etatabi. ");
INSERT INTO beu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Aarunge Paulus bot Bernabas oleve bae iuangmari niang. Ini Mutu Yesus Ehur Aaung-hama angu metma nehe emangpi veng iat hubait alolang niang. Ini vengbanang hula, Mutu Yesus Eaaung-hama angu Ana metma nehe emangpi enang iila. Ana Ekavasa angu di metma ma inang angu ebele ini tanda herang toang ening, aulange nehe toang ateing hula, Lahatala etatabit ing veng. Paulus bot Bernabas oleve bendar angu mi mihit luung. ");
INSERT INTO beu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Angu ebele bendar angu enehe ang naung iomi teahalang. Iiba angu nehe Yahudi ba iagama elamal-etahi pinat aanamang angu iamulung, bot iiba angu Lahatala Eetvala aaru angu iamulung. ");
INSERT INTO beu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Angmuse nehe Yahudi aaedeng ba iagama elamal-etahi pinat aanamang angu ini nehe aabeung ba bae Yahudi enehe niang ang naung, bot inehe eele ang naung di iat tominu, senge Lahatala Eetvala aaru angu ing ening susa, bot hula var di metma oleve ioda. ");
INSERT INTO beu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Aarunge naba ba nehe ang naung hula ening metma Paulus bot Barnabas oleve iadana angu ini ateing iila. Angmuse ini bihit ila bendar Listra bot bendar Derbe ba propinsi Likaonia mi angu mi, bot aabang ba angmi ang naung di mi. ");
INSERT INTO beu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Angumi, ini Mutu Yesus Ehur Aaung-hama angu vengmaring. ");
INSERT INTO beu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ila bendar Listra mi muse, Paulus bot Bernabas oleve nehe mehal nu aing harak. Iva ana aing vengajai muse, ia aaru angu aamina tila. Base ana lamal ahala. ");
INSERT INTO beu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nehe angu mihi senge ana Paulus emateng angu vengmee. Paulus ana eng metma euuling bot aing kalalang sehi se, ana vengomit hula, “Nehe anga eomi vengaanamang hula eningse Mutu Yesus Ana aing ening mona!” ");
INSERT INTO beu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Angmuse Paulus ana earut hula, “Kaku! Aaungba tahi!” Vengmeet aulang muse, nehe angu ana tahi sengmuse, ana lamal. ");
INSERT INTO beu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nehe ang naung uuling Paulus ana ening aulang angu ateing muse, ini mijonga. Ini ihur Likaonia mi mateng hula, “Iini vengmee hengi! Nehe aaru anga, emenghula aaneda ba por alolang taang hela senge ava aboit manusia ening angu edadenang!” ");
INSERT INTO beu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nehe ang naung mateng aulang, se ini hula Bernabas angu oma iaaneda nu ene Seus angu. Bot Paulus ba mateng angu, ini hula aing angu, oma aaneda ba ene Hermes angu. ");
INSERT INTO beu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Bendar eviaha maso angu, aaneda ba ene Seus angu aing somba emana nu ue angmi. Uuling Paulus bot Bernabas oleve iateing muse, imam ba aaneda Seus aing sasomba angu bunga baning bot sapi lotal eele aaedeng tedot hoa, senge nehe toang ang naung iamulung ila sadaka ening metma Lahatala Eetvala aaru angu ing somba. ");
INSERT INTO beu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Aarunge Paulus bot Bernabas oleve ateing hula, nehe ba aaneda sasomba ang naung hula sadaka ening metma ing somba muse, oleve iatobang. Angmuse oleve bihit ila nehe toang ang naung iapang aadang mi, sengila ba ini ikondo ang naung abahak senge metma nehe etubing hula, naba ba nehe ang naung hula ening angu oleve bae iomi adana niang. Angmuse oleve moring hula, ");
INSERT INTO beu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Etatalang ba iini ening alang anga? Ekang iomi hula noleve anga, aaneda ekang. Noleve anga nehe biasa, emenghula iing edadenang. Ni angami hoa senge hoja ba Aaung-hama angu metma veng iiat hubai. Iini malekang iiaaneda ba bae egunang veng niang ang naung eahalang, senge Lahatala ba etatabit aabeta angu iini malekang eamulung. Se burang bot por alolang eomi anga emangpi Aing ba ening angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Turangmi bangsa ang naung aabetat iomi angba enangkolang eamulung angu Lahatala Ana ing vengkilang. ");
INSERT INTO beu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Aarunge aaung-hama metma ma inang angu Lahatala bae vengtajebing niang, senge bangsa emangpi ateing hula, Lahatala angu etatabit aaung. Aing ba aanuar burang mi angu metma mapinang, bot pi bir ang naung ejol mi se Ana eiihi aaung angu metma mapinang. Aing ba mod metma mapinang, bot ping emangpi tomi ening navera.” ");
INSERT INTO beu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Paulus bot Bernabas oleve ihapat iot ekang ening aulang ekang, aarunge nehe ang naung iomi hula malekang na sasomba angu sadaka ening metma ma inang hengi. ");
INSERT INTO beu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Uanguveng angu, nehe Yahudi aaedeng ba bendar Antiokia bot bendar Ikonium mi hoa angu di ue bendar Listra mi. Ini nehe toang ang naung iomi taang iot iamulung senge Lahatala Eetvala aaru angu ing lavang. Bot ini var metma Paulus oda. Ini oma hula ana aamina tila, angmuse ini aing masiring ila aing metma bendar amota oa ang mi bia. ");
INSERT INTO beu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Aarunge nehe ba omi metma Mutu Yesus vengaanamang ang naung ini Paulus aing goleng tahi muse, ana aloming tahi. Angmuse ana bot bale bendar mi maso. Emitobang muse, Bernabas ana Paulus at lamal bendar aabeung ene Derbe angu mi ila. ");
INSERT INTO beu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbe mi, Paulus bot Bernabas oleve Mutu Yesus Ehur Aaung-hama angu vengmaring. Angmuse, nehe toang iomi metma Mutu Yesus Aing vengaanamang. Seng angmuse oleve bot bale ila Listra mi. Angmo mi, oleve bot bale ila Ikonium mi. Angumi, oleve lamal milalut ila Antiokia ba propinsi Pisidia mi angu mi. ");
INSERT INTO beu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Angumi, oleve nehe ba Yesus amulung ang naung iat mateng senge iomi ening aanamang. Oleve metma ivengani ening hula, “Kaku naung! Ping ba masot metma Lahatala Ehava omi Enehe ening angu, ekang vengomit hula, pi bae susa-lala angu harak niang ekang. Tatalang dise, pi malekang susa-lala angu harak. Aarunge pi malekang vengtahang senge, Yesus angu ba amulung.” Oleve bendar angumi Yesus enehe ang naung iavomung-iapahang aulang. ");
INSERT INTO beu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Angmuse Paulus bot Bernabas oleve nehe aaedeng songgar metma jamaat ekapala ening, jamaat ang naung kanap. Nehe ba oleve hula ing songgar metma jamaat ekapala ening angu, oleve kanempel bot sambajang metma Lahatala veng abanang senge Lahatala Ana iat toang pina. Angmuse nehe ba Lahatala Ana ing matubing iila angu Paulus bot Bernabas oleve iatang metma ing taang mea, senge ing songgar metma jamaat ekapala ening. ");
INSERT INTO beu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Seng angmuse, Paulus bot Bernabas oleve lamal milalut propinsi Pisidia eahalang senge propinsi Pamfilia mi ila. ");
INSERT INTO beu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ini ila bendar nu ene Perga angumi, Lahatala Ehur Aaung-hama angu vengmaring. Angmuse, ini bot lamal milalut ila bendar Atalia mi. ");
INSERT INTO beu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Angumi, oleve kampal hila senge aalarit bale bendar Antiokia ba propinsi Siria mi angu mi ila. Uuru aaedeng evaila angu Mutu Yesus Enehe Antiokia mi ang naung ba Paulus bot Bernabas oleve ing gahing, bot ing metma Lahatala atang mi abaang senge Ana iat toang pina. Angu ebele, Paulus bot Bernabas oleve bale ila, senge jamaat Antiokia mi ang naung iat hubait hula, ikarajang angu ini ening seng iila. ");
INSERT INTO beu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ila Antiokia mi muse, Paulus bot Bernabas oleve Lahatala Enehe ba angmi ang naung emangpi ing kumpul. Angmuse Paulus bot Bernabas oleve vengmateng hula, Lahatala Ana ing veng angu ebele na emangpi angu ini ening iila. Ini vengbanang hula, Lahatala via buka tila angu ebele nehe ba bae Yahudi enehe niang ang naung di iomi metma Mutu Yesus vengaanamang iila. ");
INSERT INTO beu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Seng angmuse, Paulus bot Bernabas oleve angumi Mutu Yesus Enehe ba iomi vengaanamang ang naung iat mihit luung. ");
INSERT INTO beu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Uanguveng angu, nehe Yahudi ba iomi Mutu Yesus vengaanamang angu inang aaedeng propinsi Yudea mi hoa, senge ila Antiokia mi. Ila angmi muse, ini Mutu Yesus Enehe ang naung iavomung-iapahang hula, “Iini bae sunat boma Musa ehada angu eamulung niang se, aabetang ejajehing ba Lahatala abung angu iini bae harak niang.” ");
INSERT INTO beu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Aarunge, Paulus bot Bernabas oleve nehe ba vomung-pahang aulang ang naung ing lavang etatabi. Paulus bot Bernabas oleve mateng hula, “Iini ahala! Bangsa aabeung ba bae Yahudi niang ang naung, iomi metma Yesus vengaanamang iila angu bae bot nehe Yahudi ehada sunat angu eamulung niang!” Ini taing lavang aulang angu ebele, ini itemaring senge Paulus bot Bernabas oleve, bot iserang aaedeng ba Antiokia mi hoa angu ing gahing Yerusalem mi ila Lahatala Eetvala bot jamaat eboma aabeung ang naung ing harak. Senge ini hama-hamat na angu vengmateng senge nehe ba iomi metma Yesus vengaanamang ang naung sunat ee niang? ");
INSERT INTO beu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Angu ebele, nehe omi Mutu Yesus vengaanamang Antiokia mi ang naung ini Paulus bot Bernabas oleve, bot iserang aabeung ba Antiokia mi hoa angu ing gahing Yerusalem mi ila. Ini via aadang taang ba oat ila propinsi Fenisia bot propinsi Samaria angu milakal. Ilamal omi angu, ini nehe ba omi vengaanamang ang naung ihava mi miari. Angmuse ini iat sarentat hula, “Nehe ba bae Yahudi enehe niang ang naung di, iava vengbaroti tila sengila ba ini iomi metma Lahatala venganamang iila!” Vengmeet aulang muse, nehe ang naung emangpi iomi mang navera. ");
INSERT INTO beu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ila Yerusalem mi muse, nehe ba iomi Yesus vengaanamang ang naung emangpi ing tarimat aaung-aaung. Lahatala Eetvala ang naung, bot jamaat eboma ang naung di, ing tarima. Paulus bot Bernabas oleve iat mateng hula, Lahatala Ana ing veng angu ebele na emangpi angu ini ening iila. Angu ebele nehe aabeung di toang Mutu Yesus amulung iila. Bot sunat ebele senge iomi teahalang angu di ini metma veng iat hubai. ");
INSERT INTO beu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nehe ba Paulus bot Bernabas oleve imateng vengmee angu, Yahudi enehe omi Mutu Yesus vengaanamang ba nehe Farisi eamulung angu di inang aaedeng ue. Ini ialoming tahi, sengila ba mateng iamal aelet hula, “Vengmeet aaung-aaung! Nehe ba bae Yahudi enehe niang angu, ini hula Yesus amulung se, ini malekang pi hada sunat bot pi hada aabeung elamal-etahi ba Lahatala metma boma Musa enang iila angu, ini malekang eamulung hengi.” ");
INSERT INTO beu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Angmuse nehe ba iomi Mutu Yesus vengaanamang ang naung emangpi vengjalit hula Lahatala Eetvala bot jamaat eboma ang naung malekang taing vengkumpul hengi. Senge ini vengtemaring hula nehe ba iomi metma Yesus vengaanamang ang naung sunat ee niang?. ");
INSERT INTO beu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Vengtemaring evengtahi mi muse Petrus ana aloming tahi senge mateng hula, “Kaku naung! Iini ateing iilat hula, turangmi Lahatala Ana iihahama angmi naing vengtalail iila, senge na ila Yesus Ehur Aaung-hama angu metma nehe ba bae Yahudi enehe niang ang naung iat hubai. Lahatala Ana vengjali, angu ebele ini iomi metma Yesus vengaanamang iila. ");
INSERT INTO beu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Lahatala Ana ping emangpi tomi angu ateing. Aing ba ERoh Hamulang angu metma nehe ba bae Yahudi enehe ang naung ma inang, emenghula Ana metma mapinang iila angu edadenang. Aulange pi ateing hula, Lahatala Ana nehe ba bae Yahudi enehe niang di ing tarima tila. ");
INSERT INTO beu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Se ping emangpi angu Lahatala Ana bae tapang kalalang niang angu ebele. Ana Aaung-hama metma mapinang angu hama sehi, bae tebelung niang. Ana ening iomi angu hamulang iila, se ing di iomi metma Yesus vengaanamang iila angu ebele, emenghula Ana tomi ening hamulang angu edadenang. ");
INSERT INTO beu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","11","Base tatalang? Hula Lahatala Ana ing tarima tila se, etatalang ba hada sunat angu di pi metma ing taang meat ening tamadit maveng? Mateng molo-molo se, ping, bot tidat-timang ang naung, pi agama elamal-etahi angu emangpi ini bae tevang jadi niang angu ebele! Base pi ekang ing paksat aulang ekang! Na hula taaning alang: Lahatala Ana ping ening lohi, bot aabetang ejajehing metma mapinang senge ping metma Ehava omi enehe ening angu pi agama elamal-etahi eamulung angu ebele ee, niang? Niang! Lahatala Ana ping ening lohi bot aabetang ejajehing metma mapinang senge ping metma Ehava omi enehe ening angu, Mutu Yesus Ana Omi metma pijahi angu ebele. Base, ekang vengtajebing ekang! Lahatala Ana Omi metma nehe aabeung di ejahit aulang.” ");
INSERT INTO beu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Vengmeet aulang muse, nehe iiba bae taang mateng niang iila. Seng angmuse, Paulus bot Bernabas oleve vengsarentat hula Lahatala Ana ing veng iila. Base tanda herang, bot na muraniang toang di, ini bangsa ba bae Yahudi enehe niang ang naung di ihahamami ening iila. ");
INSERT INTO beu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sarentat sengmuse, nehe nu, ene Yakobus angu, ana aloming tahi senge mateng hula, “Kaku naung! Iini naing venghele hengi! ");
INSERT INTO beu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Petrus ana uhavede sarentat hula, Lahatala Ana nehe ba bae Yahudi enehe niang ang naung ing medit metma Mutu Yesus ehava omi enehe ening iila. ");
INSERT INTO beu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Angu emenghula naba ba turangmi Lahatala Ehurvala ang naung vengbanang iila angu edadenang. Se ini hurak iilat hula, ");
INSERT INTO beu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ꞌEningse, Na bale. Se Na hula Raja Daud ehava angu bot bale bakung atahing angu ebele. Etabaning ba tarahak-tavetang iila angu, Na hula inehe nu aing songgar metma eele-balolu ening. ");
INSERT INTO beu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Bot ening aulang senge, nehe ba bangsa aabeung mi ang naung di hoa Naing valaping senge Naing harak. Na ing vengtalail, senge metma Ne nehe ening iila. Se Lahatala turangmi vengbanang iila angu ebele!ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","20","Base Yakobus vengbanang hula, “Naing nenomi alang: Nehe bangsa aabeung mi hula Lahatala eamulung se, ping ba Yahudi enehe ang naung ekang ing ening susa ekang. Pi ekang tamadi metma ing tang mea bot iot pihada sunat angu eamulung ekang. Base, pi malekang surat nu hurak, senge panatut metma ma inang, aulange ini ekang piagama Yahudi evia-via angu emangpi eamulung ekang. Bot pi metma ivengani ening hula, nehe ba bae imehal niang, senge bot bae ijangu niang angse, ini ekang aing vengbuha ekang. Ini ekang nehe aaneda ahi euumung adang ekang. Ini ekang binanta eve adang ekang. Bot binanta ba nehe obo kaomit ameang angu di, ini ekang euumung angu adang ekang. ");
INSERT INTO beu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Se ping nehe Yahudi piagama alang anga, nehe toang ateing iila. Angu ebele Musa eparenta evia-via ang naung, taang-taang mi ved hamulang kakanap se, hava hamulang emangpi angu pi metma mi basa. Base bangsa aabeung enehe toang ang naung di ateing iila. Ne mateng angu ila angmi jehi!” ");
INSERT INTO beu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Seng angmuse, Lahatala Eetvala bot jamaat eboma aabeung ang naung, imampi tominu senge nehe panatut ila ihur ba ini vengtominu tila angu metma nehe omi Mutu Yesus vengaanamang ba taang-taang mi ang naung veng iat hubai. Nehe ba jamaat iomi vengbaa, bot karajang angu ateing angu, ini nehe aaru vengtalail medi. Nu ene Silas, bot nu angu, ene Yudas (ba ini earut hula, Barsabas). Angmuse ini Silas bot Barsabas oleve ing gahing aulange ini Paulus bot Bernabas imampi ila. ");
INSERT INTO beu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ini surat baning metma nehe bangsa aabeung ba, bendar Antiokia propinsi Siria mi ang naung inang, bot ila propinsi Kilikia ba mi ola angu di mi. Surat angu eamal alang: “Ning ba Lahatala Eetvala bot jamaat eboma aabeung bendar Yerusalem mi anga ni iing aada aaung-hama. Niomi iijahit emenghula nikaku mamolo edadenang, angu ebele ni surat anga hurak metma ma iinang. ");
INSERT INTO beu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ni vengmee se nehe aaedeng Yerusalem mi anga ba ini ila iing harak iila, angu ebele ni surat anga hurak metma ma iinang. Ini sama-ening metma iiavomung-iiapahang iing ening susa, bot iiomi ening birvengtajebing. Base iini malekang ateing hula, ning ba bae nehe angu naung ing gahing niang. ");
INSERT INTO beu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ni vengmeet hula, nehe iiba iing ening susat aulang muse, ni angami taing vengkumpul senge na angu vengtemaring. Base, ni vengtominu bot na angu vengputus sengiila. Base angase, ni nehe aaru vengtalail iila senge nababa ni vengputus iila angu baning hoa metma veng iiat hubai. Bernabas bot Paulus oleve ba ni niomi metma ijahi angu imampi hama-hamat hoa. ");
INSERT INTO beu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nehe aaru angu, ini susa-lala angu tevang nianta se vengaamina, se ini Yesus Kristus amulung angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Base ni Yudas bot Silas oleve ing gahing, senge ini surat anga eomi angu metma veng iiat hubai. ");
INSERT INTO beu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Lahatala ERoh Hamulang angu niat hubai tila, bot ning emangpi vengtominut aulang hula, iini ekang ni hada Yahudi angu emangpi eamulung, emenghula hada sunat angu edadenang ekang, misavaka ni tamadi metma iing taang mea. Aarunge na aaedeng anga ba, iini malekang vengani: ");
INSERT INTO beu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nehe ba bae eemehal niang senge bot bae eejangu niang angu, ekang aing vengbuha ekang. Ekang aaneda ahi euumung adang ekang. Ekang ve adang ekang. Bot binanta ba nehe obo kaomit ameang angu ekang euumung adang ekang. Iini iiava vengjagat metma na angu naung emangpi adana se, iini bae iikaku Yahudi ba iomi Mutu Yesus vengaanamang ang naung ing ening iomi dira niang. Ni surat anga, ila angmi jehi.” ");
INSERT INTO beu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ini surat hurak sengmuse, jamaat eboma ang naung ini nehe buta ing gahing iot surat angu baning lamal bendar Antiokia mi ila. Ila angmo mi muse, ini nehe ba omi Mutu Yesus vengaanamang ang naung ing emangpi ing kumpul, senge ini surat angu metma ma inang. ");
INSERT INTO beu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ini surat angu basat sengmuse, nehe ang naung emangpi sanang, se surat ang eomi angu iomi ening aanamang iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas bot Silas oleve di metma Lahatala Ehurvala ening. Oleve nehe omi vengaanamang bendar ang mi angu iat mateng mitoang-mirae. Ini iavomung-iapahang bot iomi ening aanamang. ");
INSERT INTO beu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Oleve angmi mihit luung kabingdena muse, nehe omi Mutu Yesus vengaanmang Antiokia mi ang naung Yudas bot Silas oleve ing panutut bale Yerusalem mi ila, senge nehe ba ing gahing ang naung iat mateng hula, “Lahatala Ana iiat toang pina”. ");
INSERT INTO beu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Aarunge Silas eat bale niang, Silas hula Antiokia ba mi mihi. ");
INSERT INTO beu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus bot Bernabas oleve angumi mihit mi laluung. Ing di nehe aabeung ba Mutu Yesus Evia Aabetang vengmaring angu ioang moling. ");
INSERT INTO beu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Paulus bot Bernabas oleve Antiokia mi mihit luung kabingdena muse, Paulus ana Bernabas at mateng hula, “Kaku! Mahe mana emangpi ba tura pi mi miari tila angu bale mi ila. Pi bot bale ila pikaku ang naung iateing hengi. Ini jedung iomi metma Mutu Yesus vengaanamang sehi ee niang? Tura angu, pi iavomung-iapahang iila. Base mahe pi ila uuling iateing.” ");
INSERT INTO beu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Vengmeet Paulus banang aulang muse, Bernabas mang eamulung. Ana hula Yohanis di at ila senge iamulung. (Ini Yohanis anga earut hula, Markus). ");
INSERT INTO beu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Aarunge Paulus ana ea. Se turat propinsi Pamfilia mi angu, Markus ana iat tatarat lamal bot iadu angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Paulus bot Bernabas oleve iai metma tadanat etatabit aulang, angu ba oleve tatarat lamal. Angmuse Bernabas ana Markus aing medi, senge oleve kampal hila aalarit Siprus por taang ila. ");
INSERT INTO beu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Aarunge Paulus ana Silas aing medit at ila. Paulus bot Silas oleve hula lamal muse, nehe ba iomi metma Mutu Yesus vengaanamang Antiokia mi ang naung sambajang Lahatala abanang senge Ana iat toangpina, bot Ana Eomi aaung angu di metma itubing. Sambajang sengmuse, oleve lamal. ");
INSERT INTO beu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Angmuse ini ila lamal propinsi Siria bot propinsi Kilikia angu mi goleng. Taang-taang mi angu ini nehe ba iomi metma Mutu Yesus vengaanamang ang naung iomi ening adaeri. ");
INSERT INTO beu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Seng angmuse Paulus bot Silas oleve lamal milalut ila bendar Derbe mi. Angmi muse ini bot lamal milalut ila bendar Listra mi. Bendar angu mi ini nehe mehal kaneng nu aing harak, ene Timotius. Timotius imang angu Yunani enehe. Aarunge iva angu Yahudi jangu ba omi Yesus vengaanamang iila. Timotius angu di omi metma Yesus vengaanamang iila. ");
INSERT INTO beu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nehe omi Lahatala vengaanamang ba bendar Listra bot bendar Ikonium mi angu emangpi ateing hula, Timotius angu nehe aaung. ");
INSERT INTO beu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus ana vengjalit hula Timotius di iamulung. Aarunge nehe Yahudi ba angmi angu ini ateing hula Timotius imang angu Yunani enehe, base aing angu bae sunat Yahudi ehada angu eamulung jedung. Angu ebele, Paulus ana nehe gahing senge iot Timotius aing sunat. ");
INSERT INTO beu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Seng angmuse, ini angmi lamal bendar ang naung migoleng, senge naba ba Mutu Yesus Eetvala bot jamaat eboma ang naung Yerusalem mi vengputus iila angu vengmaring. ");
INSERT INTO beu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ini ening aulang senge, nehe ba omi metma Lahatala vengaanamang angu taang ening adaeri. Ved kakanap, nehe ba omi metma Lahatala vengaanamang angu taang toang maveng. ");
INSERT INTO beu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Seng angmuse, Paulus bot Silas oleve lamal milalu. Ini ila propinsi Frigia bot propinsi Galatia mi, se Lahatala ERoh Hamulang ihapat hula iot ekang ila propinsi Asia mi Lahatala Ehur Aaung-hama angu vengmaring ekang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ini ila bir nu propinsi Misia vengjehi angumi muse, iomi hula malekang propinsi Bitinia mi ila hengi. Aarunge Yesus ERoh ihapat iot ekang angmo mi ila ekang. ");
INSERT INTO beu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Angu ebele ini lamal propinsi Misia angu mi lakal muse, ini hela bendar Troas ba tang eadil mi jehi angumi. ");
INSERT INTO beu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kua angu adana, Lahatala Ana tanda metma Paulus etubing. Emenghula iipalna edadenang, ana uuling ateing se propinsi Makedonia enehe nu ue apang aadang mi tahi. Nehe angu moring banang hula, “Nimang! Makedonia mi ma senge nioang moling hengi!” ");
INSERT INTO beu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulus uuling ateing aulang muse, ni vengputus sengmuse ni Makedonia mi ila. Ni veng niomit hula, angu etabit Lahatala ba gahing senge ni ila Evia Aabetang angu metma nehe ba angmo mi ang naung veng imaring. Angu ebele Ana ni hapat niot ekang mana aabeung mi ila ekang. ");
INSERT INTO beu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Angmuse, ni bendar Troas mi kampal hila sengila ba aalarit por kiki nu ene Samotrake angumi ila. Emitobang muse, ni bot aalarit milalut ila bendar nu ene, Neapolis angumi. Angmuse ni angu mi hela. ");
INSERT INTO beu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Angumi ni aadang taang lamal ila bendar eele nu ene Filipi angu mi. (Filipi angu, bendar ene veng propinsi Makedonia mi; ing di Roma enehe eele ba ue ing parenta.) Ni angmi mihit mietang aaedeng. ");
INSERT INTO beu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nehe Yahudi eved hamulang adana muse, ni ila nehe Yahudi ang naung imana sambajang aalaping. Ni ateing se mana sambajang angu ue moar adil mi. Base ni lamal kabingdenat ila bendar angu eahalang muse, ni moar nu harak. Angumi ni nehe memet inang aaedeng ing harak. Base ni mihit iat mamateng. ");
INSERT INTO beu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Memet ang naung ing emangpi angu nu ene Lidia. Aing angu bendar olami nu propinsi Asia mi, ene Tiatira angu mi hoa. Memet anga noang ba ebili etatabit eele angu ba ana aabalit metma nehe eele ang naung inang. Ana kalakat sambajang Lahatala abanang. Base, ana Paulus emateng angu vengmee muse, ana metma omimi. ");
INSERT INTO beu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Angmuse ni angmi memet Lidia bot ehava omi enehe ang naung emangpi jar metma ing sarani. Jar metma ing sarani sengmuse ana niajalit hula, “Nimang. Oleve vengpikir hula naing anga di, etatabit na nomi metma Mutu Yesus Aing vengaanamang iila se, iini hoa ni hava mi mihi.” Ana niasenang aulang muse, ni eamulung. ");
INSERT INTO beu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ved nu adana, ni hula lamal mana sambajang mi ila se, ni via mi nehe jangu kaneng nu aing harak. Aing angu nehe eele ang naung imalea ba ini aing beli tila. Aing angu setang jasi apang taang, angu ebele naba ba eningse jadit metma nehe eaabetang adana angu ana bisa vengbanang. Base, nehe toang seeng metma ma enang senge abanang ot iaabetang angu uuling ateing. Aarunge seeng ang naung, nehe jangu kaneng angu enehe eele ang naung ba emangpi medi, angu ebele ini vengkavasa. ");
INSERT INTO beu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ved uanguveng, ni lamal sehi se, nehe jangu angu niamamulung lamal. Angmuse ana moring hula, “Nehe anga naung, Lahatala ba mieele-mibalolu angu Egahingvala. Ini hoa via matubing senge, nehe aabetang ejajehing angu harak, bot ing ening lohit metma iahalang-iavali ang naung eola!” ");
INSERT INTO beu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nehe jangu kaneng angu moring aulang alolang niang ila ved aaedeng omimi. Paulus ana nehe jangu angu ehur ang vengmeet aulang muse, Paulus ana bae vengtahang niang iila angu ebele, ana nehe jangu kaneng angu euuling etatabi senge ana setang angu aing parentat hula, “Hee! Aaing setang jasi! Mutu Yesus Ekavasa omimi, na aaing parenta, vede anga ba aana nehe jangu anga eahalang!” Paulus ana mateng aulang sengmuse, setang angu kaluar nehe jangu angu eahalang iila. ");
INSERT INTO beu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nehe jangu kaneng angu enehe eele ang naung ateing hula, setang ekavasa ba imalea aing veng angu ue niang iila muse ini alil, se ini bae seeng medi niang iila angu ebele. Angmuse ini Paulus bot Silas oleve ing pina, sengiila ba ing masiring ila ong mi, mana ba nehe biasat mi parkara vengputus angumi. ");
INSERT INTO beu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Angumi, ini moring etatabit hula, “Nehe anga naung, hoa pi bendar anga ening ajasing. Ing anga bae aabang anga enehe niang. Anga Yahudi enehe ola mi ba hoa senge angami bir arahak! ");
INSERT INTO beu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ing di bot nehe avomung-apahang hula, pi ekang Roma eparenta evia-via angu eamulung ekang, aarunge ivia-via angu ba eamulung.” ");
INSERT INTO beu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Vengmeet aulang muse, nehe toang ang naung alil etatabi, angmuse ini Paulus bot Silas oleve ing bue. Bot nehe ba parkara vengpaputus angmi ang naung di nehe gahing iot oleve ipakiang angu abahak medi, senge bot ing varisik. ");
INSERT INTO beu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ini Paulus bot Silas oleve ing varisik etatabi sengmuse, ini iat ila metma bui mi maso. Ini nehe ba angmi jaga enehe eele angu, at mateng ot nehe aaru angu ing jagat aaung-aaung. Misavaka ini bihit bui angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Vengmeet aulang muse, nehe ba angmi jaga enehe eele angu ana iat mida bui ekamar ba hahamami angu mi. Angmuse ana langi metma oleve ia mi. ");
INSERT INTO beu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tereng hahama muse, Paulus bot Silas oleve sambajang bot dal ohit Lahatala Aing tajaning. Nehe aabeung ba bui mi ang naung di, ini oleve dal ohi angu vengmee. ");
INSERT INTO beu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mibaroti se, meke angu tadirit etatabi, anguba bui ehava angu di emangpi tadiri. Bot eviaha etundil angu di emangpi mang baleleng. Angmuse, rante ba nehe bui mi ang naung ia mi angu di, mang ava ahibul. ");
INSERT INTO beu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nehe jaga enehe eele angu mibaroti tahi senge eng uuling se, bui eviaha ang naung emangpi baleleng. Uuling ateing aulang muse, ana oma hula nehe bui mi ang naung emangpi bihit miosing iila. Angmuse, ana earing angu masiring medi, senge hula ava ameang. ");
INSERT INTO beu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Aarunge Paulus moring amal aele bot ehapat hula, “Ee, Nimang! Ekang aava ameang ekang! Ning emangpi jedung ae anga mi!” ");
INSERT INTO beu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Paulus amal angu vengmee muse, nehe jaga enehe eele angu uangmari bot tababar etatabi. Angmuse ana nehe ot muhu tubing metma ma enang senge tababar mi ana masot bui mi mida. Angmuse ana Paulus bot Silas oleve iapangaadang mi ia kuku muding. ");
INSERT INTO beu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Angmuse ana bui mi iat kaluar hela, senge ana iadangtaaning hula, “Nimang. Naing anga, etatabit susa-lala. Na malekang naba ba ening senge, Lahatala Ana naing metma susa-lala anga eahalang?” ");
INSERT INTO beu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paulus bot Silas oleve ebalet hula, “Evia angu alang: Aana malekang oomi metma Mutu Yesus angu ba vengaanamang, aulange Ana aaing ening lohi metma eesusa-lala ang naung eola, bot aaing metma Ehava omi enehe ening senge, aabetang ejajehing angu Ana metma ma eenang. Bot eehava omi enehe ang naung di aulang.” ");
INSERT INTO beu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Seng angmuse, Paulus bot Silas oleve ini nehe jaga enehe eele angu, bot ehava omi enehe ang naung emangpi Mutu Yesus Ehur aaung-hama angu metma veng iat hubai. ");
INSERT INTO beu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tereng hahama muse, nehe ba bui jaga enehe eele angu ana Paulus bot Silas oleve iat ila senge, ibata ang naung ening ahamulang. Angmuse, ini nehe ba bui jaga enehe eele bot ehava omi enehe ang naung emangpi jar metma ing sarani. ");
INSERT INTO beu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Seng angmuse, ana iat ehava mi ila, mod metma ma inang ini adang. Nehe bui jaga enehe eele bot ehava omi enehe ang naung emangpi iomi naverat etatabi, se ini iomi metma Lahatala vengaanamang iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Emi kuaveng muse, nehe ba parkara vengpaputus ang naung, ini iamal panatut metma nehe bui jaga enehe eele angu enang, senge ot bui mi Paulus bot Silas oleve ing ening lohi. ");
INSERT INTO beu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Vengmeet aulang muse, nehe ba bui jaga enehe eele angu ana nehe ba parkara vengpaputus ang naung iamal angu metma Paulus at mateng hula, “Nimang. Nehe eele ang naung vengputus iilat hula iing ening lohi. Base aaung ba iini ila.” ");
INSERT INTO beu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Vengmeet aulang muse, Paulus ana eat bae tarima niang. Ana nehe ba vede nehe eele ang naung iamal baning hoa vengbanang angu iat hubait hula, “Ekang aulang ekang! Ning anga di metma Roma enehe ening iila! Base Roma enehe eele ang naung ini malekang ni parkara anga vengputus parenta evia-via angu eamulung. Emolo angu eamulung se, malekang mihit ahalang angu vengparisa senge, nehe hukung. Aarunge ini bae ening aulang niang. Ini bae mihit noleve ni ahalang angu vengparisa niang, aarunge ini mang nehe toang iapangaadang mi ning bue ning sabai tila. Ni ahalang iiba veng niang di, ini mang ning metma bui mi maso. Ening aulang angu, ini Roma eparenta evia-via angu lavang iila. Senge anga se ini hula, taimang-taimang bui mi ning lapas. Ni bae tarima niang! Nehe eele ang naung iot hoa senge ning ening lohi. Ening aulang senge, ni tarima.” ");
INSERT INTO beu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nehe ba jaga ang naung bale ila Paulus emateng angu vengbanang muse, nehe eele ang naung ateing iilat hula, oleve di metma Roma enehe ening iila. Anguba ini iuangmarit etatabi. ");
INSERT INTO beu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Angmuse nehe eele ang naung bui mi hoa iahalang angu vengbanang, sengila ba Paulus bot Silas oleve ing aada iomi ening sanang. Seng angmuse ini bui mi oleve iat kaluar, senge iabanang iot lamal bendar angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bui mi kaluar muse, Paulus bot Silas oleve lamal memet Lidia ehava mi ila. Angumi, nehe ba iomi Yesus vengaanamang ang naung imampi taing vengmihi. Paulus bot Silas oleve iavomung-iapahang, bot iomi angu taang ening aanamang. Seng angmuse, Paulus bot Silas oleve lamal bendar angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Seng angmuse, Paulus bot Silas oleve lamal milalu. Ini lamal bendar nu ene Amfipolis angu milakal. Angmuse, ini bot bendar aabeung nu ene Apolonia angu mi ila. Angumi ini lamal milalut ila bendar Tesalonika mi. Bendar Tesalonika mi angu, nehe Yahudi ehava sambajang nu ue. ");
INSERT INTO beu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulus bot Silas oleve lamal ila mana nu mi senge nehe Yahudi ehava sambajang ue angumi, bot ved hamulang adana se, Paulus ana ila imampi sambajang. Tesalonika mi angu di, ana ila imampi sambajang. Ana angmi imampi tat mamateng Lahatala Ehur ba Esurat hamulang mi angu eamulung. Ved hamulang mi tue mitatamulung angu ana iat sambajang. ");
INSERT INTO beu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ana iat hubait hula, “Pi Lahatala Esurat hamulang angu euuling aaung-aaung se pi ateing hula, Lahatala Ehurvala ang naung ini turang mi vengbanang iilat hula, Nehe ba Lahatala Ana vengpalait gahing hoa angu, eningse Ana susa-lala toang harak. Eningse Ana aamina. Aarunge eningse, Lahatala Ana Ekavasa metma Aing ening Ana bale aabeta. Ba angase pi ateing hula, Nehe ba Lahatala Ana vengpalai angu, Aing ba Yesus angu!” ");
INSERT INTO beu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Vengmeet aulang muse, Yahudi enehe iiba angu Paulus emateng angu tarima, sengila ba ini Paulus bot Silas oleve iamulung. Nehe ba tarima angu, toang Yunani enehe ba iomi metma Lahatala midadanang iila angu, bot nehe memet aaedeng ieneveng ba bendar angumi angu. ");
INSERT INTO beu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Aarunge nehe Yahudi enehe eele ba angmi ang naung iomi alil etatabi, se nehe toang angu ini Paulus bot Silas oleve iamulung angu ebele. Base ini nehe ba angmi basiar lamal bae karajang niang ang naung iomi taang sengila ba, iot bir arahak. Nehe ang naung taing vengkumpul toang iila muse, ini bendar angu mi bir arahak. Ini Paulus bot Silas oleve ing aalaping, senge hula ing masiring ila metma nehe toang ba bir arahak ang naung inang. Angmuse ini ila Yason ehava angu venggoleng, se Paulus bot Silas oleve angmi mihi angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Aarunge ini bae angmi Paulus bot Silas oleve ing harak niang. Angmuse ini Yason bot nehe ba omi Yesus vengaanamang aabeung inang aaedeng angu, ing masiring ila parkara vengpaputus emana angu mi. Ini Yason iimal ing ening ahalat hula, “Angase nehe anga naung hoa pi bendar angami tila. Ini lamal ila mana kanap senge angu mi bir arahak! Angase ini hoa senge hula, pilamal-pitahi ba angami anga ening arahak, senge ilamal-itahi angu ba metma telul! Yason anga, ana nehe ang naung ing tarimat ehava mi mihi tila! Aarunge ing emangpi bae raja eele Keser eparenta angu eamulung niang. Ini vengbanang hula raja aabeung nu ue, ene Yesus.” ");
INSERT INTO beu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Vengmeet aulang muse, nehe eele ang naung, bot nehe ba angmi ang naung iomi mang iipi sehi tila. ");
INSERT INTO beu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Angmuse nehe eele ba bendar angu mi angu, ini Yason bot nehe ba omi Yesus vengaanamang ang naung, iot seeng metma bajar senge etanda ening hula, ini bae bir arahak niang iila, bot palait hula Yason iimal bae bihi niang. Bajar sengmuse, nehe ang naung ini Yason iimal ing ening lohi. ");
INSERT INTO beu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kua angu, nehe omi vengaanamang ba bendar Tesalonika mi angu, vengiomit hula, lebe miaaung ini Paulus bot Silas oleve ing gahing mana aabeung mi ila. Angmuse ini oleve ing gahing ila bendar nu ene, Berea angumi. Ila angmi muse, ini nehe Yahudi ehava hamulang omimi maso. ");
INSERT INTO beu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Aarunge nehe Yahudi ba Berea mi angu, bae nehe Tesalonika mi ang naung edadenang niang. Nehe anga naung, ini sukat Paulus bot Silas oleve imateng angu venghele, bot tarima. Se ing ba Berea mi angu ini Paulus bot Silas oleve ing venghelet aaung-aaung, bot Lahatala Esurat Hamulang angu ini basa angu ebele. Paulus bot Silas oleve imateng angu ini hula valaping ateing, etabi ee niang. Angu ebele, ved kakanap ini Lahatala Esurat Hamulang angu parisat aaung-aaung. ");
INSERT INTO beu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Angu ebele, nehe Yahudi toang angmi angu iomi metma Mutu Yesus vengaanamang. Bot Yunani enehe ang naung di iomi metma Mutu Yesus vengaanamang. Nehe ba iomi metma Mutu Yesus vengaanamang ang naung iiba angu nehe mehal bot jangu ba ieneveng ang naung. ");
INSERT INTO beu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Aarunge nehe Yahudi ba Tesalonika mi ang naung ini vengmeet hula, Paulus bot Silas oleve ini Lahatala Ehur aaung-hama angu Berea mi metma nehe avomung-apahang muse, nehe Yahudi ang naung iamulung hoa, sengiila ba nehe omi taang senge iot angmo di mi bir arahak. ");
INSERT INTO beu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Angu ebele nehe omi vengaanamang Berea mi ang naung, ini uuser-uuser Paulus at oolol mi ila. Aarunge Timotius bot Silas oleve Berea mi mihi tarus. ");
INSERT INTO beu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nehe omi Mutu Yesus vengaanamang ang naung ini Paulus aing aantar sampe ila bendar nu ene Atena, angumi, seng angmuse ini bale Berea mi ila. Ini Paulus epalai baning vengbanang hula, Silas bot Timotius oleve iot uuser ebele hoa. ");
INSERT INTO beu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulus ana Silas bot Timotius oleve Atena mi hoa angu ading sehi se, omi mang etatabit dira, se bendar angumi angu, ana uuling se taang-taang mi angu aaneda ahi emana ue angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aarunge angmi angu nehe Yahudi inang aaedeng, bot nehe ba bae Yahudi enehe niang ba sukat sambajang Lahatala abanang angu di ue angmi. Paulus ana masot mida ihava hamulang mi, sengila ba iat temamaring. Ved kakanap, ana bot ila ong mi senge nubaba hoa angu mi angse, ana iat mamateng. ");
INSERT INTO beu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Angmuse, ana bot guru inang aaedeng ba kelompok Epikuros bot kelompok Stoa ba bendar angumi angu, iat natataanang. Aarunge ana Yesus esarenta angu vengbanang hula, Yesus Ana aamina aarunge Ana bot bale aabeta tila muse, nehe iiba angu mateng hula, “We! Nehe anga ana samamamateng!” Aabeung angu bot ehura-emanantit hula, “We! Ana hula piot bangsa aabeung eaaneda angu somba!” ");
INSERT INTO beu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","21","Angmuse ini Paulus at aabu nu ene, Areopagus angu taang mida. Mana angu bendar Atena enehe bot nehe aabeung ba hoa bendar angu mi mihi angu, bot inehe ba hur adang ang naung ini biasat mi mihit taing harak, senge naba ba ini uhavede ateing bot vengmee tila angu vengmateng. Ini Paulus at mida angmi sengmuse, ini abanang hula, “Vomung-pahang uhavede angu metma niat hubai hengi! Ni vengmee se, naba ba aana vengbanang angu na uhavede ba nu, bot ening niomi iipi sehi. Angu ebele, aana taang vengbanang maveng senge naba ba aana vengbanang angu ni ateing aaung-aaung.” ");
INSERT INTO beu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","23","Angmuse Paulus ana tahit mateng hula, “Iingba Atena enehe ang naung! Na lamal iibendar anga mi goleng iila, bot na uuling ateing se hula, iing anga etabit nehe ba sukat aaneda toang somba. Na uuling se mana ba iini mi aaneda somba ang naung ue taang-taang mi. Na ateing se doru nu iini taang aaneda ahi angu, ue mi hurak hula, ꞌAaneda ba pi bae ateing niang angu aing somba.ꞌ Evengbanang hula, iini Lahatala Aing somba tila, aarunge iini bae ateing jedung. Aing ba na metma veng iiat hubai angu. ");
INSERT INTO beu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Se Lahatala anga ba, por burang bot emangpi ba eomimi angu ening. Emangpi ba doe burang mi bot ae por alolang taang anga Aing ba Emanaing. Base, hava ba nehe ening senge mi aaneda somba angu Ana bae mi mihi niang. ");
INSERT INTO beu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Aing ba teenghara, bot aabetang angu metma mapinang. Evengbanang hula, emangpi ba pi hula metma piabetang adana angu, Aing ba metma mapinang. Aarunge Aing bae na iiba banang metma Eoa niang. Base nehe bae bisat Oang moling niang. ");
INSERT INTO beu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Bot nehe nu kolang etabaning omimi Lahatala Ana bangsa emangpi ae por alolang taang anga ahami. Bot Aing ba ooras vengator metma bangsa ang naung inang senge meke ba Ana paul metma mainang iila angu omimi aabeta. ");
INSERT INTO beu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ana ening aulang, senge pi Aing aalaping. Lahatala Ana Eomi hula pi Aing aalaping senge Aing harak. Ana etatabit bae piola niang. ");
INSERT INTO beu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nehe biasat vengbanang hula, ꞌAing angu ba etabi teenghara angu e eela. Aing ba etabit pi aabetang angu e eela.ꞌ Aulang di bot iinehe ba dal a ohi ang naung ini dal ohit hula, ꞌPi aabeta angu, Ana ping veng angu ebele. Angu ebele, ping metma Oal-Idat ening.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Base, angu etabi! Ping emangpi anga, Lahatala angu Oal-Idat. Base iini ekang vengiiomit hula, Lahatala angu emenghula mas perak, bot te var ba nehe metma aaneda ening iomi eamulung senge somba angu edadenang ekang. ");
INSERT INTO beu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tura angu, nehe bae na anga naung manggarati jedung. Angu ebele ba Lahatala Ana ing vengkilang senge ini aabetat ikamuke angu eamulung. Aarunge angase, Lahatala Ana eat hula tot ekang aabetat aulang ekang. Angu ebele Ana parentat hula, aaneda ba pi somba ang naung pi malekang at hela mea, sengila ba tava vengbaroti senge tava metma pijasi-piahala angu eola senge Amulung. ");
INSERT INTO beu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ana jol nu vengbanang iila, senge nehe ba por alolang taang anga emangpi ing hukung, se iahalang-iavali ang naung ebele. Bot Ana Nehe nu matubing iila senge metma Hakim ening. Nehe ba jasi-ahala ening ang naung eningse Nehe angu Ana ing hukung, evia angu eamulung. Angase pi ateing iilat hula, Hakim angu nuba. Aing benang ba Yesus angu. Ana aamina tila, aarunge Lahatala Aing ening Ana bale aabeta angu.” ");
INSERT INTO beu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Aarunge nehe ba taing vengkumpul angmi ang naung vengmee se Paulus ana hula, “Yesus Ana aamina tila di bale aabeta,” angmuse ini aing vengpalelat eja-jahi ening. Aarunge nehe aaedeng angu ini Paulus at hubait hula, “Sarenta ba nimang aana vengbanang angu, ni hula jedung vengmee sehi. Aarunge biar jol aabeung adana hengi.” ");
INSERT INTO beu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Seng angmuse Paulus ana lamal ila mana angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Aarunge iiba angu ini Paulus eamulung, se ini iomi metma Mutu Yesus vengaanamang iila angu ebele. Ing angu benang ba: nehe nu biasat Areopagus mi parkara veng aurus, ene Dionisius angu, bot nehe jangu di nu, ene Damaris, bot nehe aabeung di inang aaedeng iamulung hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","3","Uanguveng angu, Roma eparenta enehe eele angu ene Klaudius. Ana nehe Yahudi ang naung ialil, angmuse ana iaterit iot bendar Roma ba propinsi Italia mi angu eahalang. Yahudi enehe nu, ene Akila bot ejangu angu ene Priskila. Oleve di bihit nehe amulung ila propinsi Italia angu eahalang, ila bendar nu ene Korintus angu mi. Akila anga, propinsi Pontus mi hoa. Ekarajang angu, binanta ebuar ba harotat metma teeng ening. Uanguveng angu, Paulus ana bendar Atena eahalang sengila ba lamal bendar Korintus mi ila. Angmi angu, Paulus ana ava metma Akila bot Priskila oleve itubing, se andi ekarajang angu binanta ebuar ba harotat metma teeng ening angu ebele. Imampi mihit hama-hama, bot karajang di hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nehe Yahudi ang naung ived hamulang adana se, Paulus di ila ihava hamulang mi masot mida. Angmi angu, ana hula Yahudi ang naung bot nehe aabeung ang naung di, iabanang-iasenang senge ini iomi metma Mutu Yesus angu ba vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas bot Timotius oleve propinsi Makedonia mi hoa muse, Paulus ana Lahatala Ehur aaung-hama vengmaring. Kua-jala ana Yahudi enehe ang naung iat mateng hula, “Nehe ba turang mi Lahatala Ana vengpalait hula Aing gahing hoa, senge ping emangpi ading sehi angu, Ana hoa iila. Aing ba Yesus angu!” ");
INSERT INTO beu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Aulang aarunge nehe Yahudi iiba angu aing malavang alolang niang, bot ini at mateng hula aing ening ahala. Angmuse Paulus ana epakiang ba moro veng angu tere, aulange metma itubing hula, ana eat bae iateing niang iila, se ini iat bae hur aaung-hama ba ana metma veng iat mateng angu tarima niang angu ebele. Angmuse ana mateng hula, “Iing anga, bae mura niang! Iini iibabakeng iiaver ening akebe! Angu ebele eningse Lahatala Ana iing hukum se, iini ekang naing ening ahala ekang. Iiahalang ang naung iing ba tevang. Base vede angase, iing Yahudi ang naung naba ba iini ening angu na bae iiat ateing niang iila. Base na bae neat iiavomung-iiapahang niang iila. Na hula ila bangsa aabeung ba bae Yahudi niang ang naung iavomung-iapahang.” ");
INSERT INTO beu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Hava nu ue nehe Yahudi ehava hamulang abung angmi tahi. Hava manaing angu ene Titius Yustus. Aing angu bae Yahudi enehe niang, aarunge andi omi angu Lahatala midadanang sehi. Paulus ana tahit lamal nehe Yahudi ba hava hamulang mi ang naung iahalang muse, ana ila Titius ehava mi masot mida. ");
INSERT INTO beu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Bae luung niang muse, hava hamulang enehe eele angu di omi metma Mutu Yesus vengaanamang. Aing angu ene Krispus. Ehava omi enehe ang naung, bot Korintus enehe aabeung ba Paulus aing venghele angu di iomi metma Mutu Yesus vengaanamang. Angmuse, Paulus ana ing emangpi jar metma ing sarani. ");
INSERT INTO beu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kua nu adana, emenghula iipalna edadenang Lahatala ERoh hamulang Paulus at mateng hula, “Paulus! ekang uuangmari ekang, ekang aava bareat metma karajang anga adana ekang, se naba ba aana at lamal angu bae evengtahi jedung angu ebele. Aana malekang Ne hur aaung-hama angu vengbanang alolang niang. ");
INSERT INTO beu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Vengani! Aana bae eenang kolang karajang niang. Na ue aaing veng. Kandati nehe aaing ening susa, aulang aarunge Na aat toangpina. Kua jala angu, Na Neng metma eeuuling alolang niang. Ekang vengtajebing ekang. Neneheba omi metma Naing vengaanamang iila angu ae bendar anga mi.” ");
INSERT INTO beu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Vengmeet aulang muse, Paulus ana bendar Korintus mi mihit milaluung. Ana Lahatala Ehur aaung-hama angu metma nehe ang naung iavomung-iapahang sampe mitung nu vengdena. ");
INSERT INTO beu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Uangu adana, ini nehe nu aing songgar metma propinsi Akaya egubernur ening. Ene Galio. Yahudi enehe aaedeng itomi-taang senge Paulus aing lavang angu ebele ini at ila gubernur abung, mana ba nehe parkara vengpaputus angu mi. ");
INSERT INTO beu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ini vengbanang hula, “Nehe anga ana nehe toang omi taang iila, senge iot agama uhavede nu angu eamulung, senge Yahudi eagama evia-evia angu ekang eamulung ekang.” ");
INSERT INTO beu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulus ana hula mateng ava vengebang muse, gubernur ana ehur angu mi patai. Ana nehe ba Paulus aing kalaa angu ihapat hula, “He! Iing ba Yahudi enehe ang naung, iiavel hele hengi! Nehe jasi-ahala ening senge iini hula baning hoa mihit vengmateng senge nehe tamameang se, na malekang vengmee hengi. ");
INSERT INTO beu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Aulang aarunge parkara ba iini baning hoa anga, ue iihava omimi! Agama Yahudi evia-via, ehur kokal, bot ene ang naung ba iini veng iiai metma tadana. Parkara aulang angu, parenta anga mi anga bae vengurus niang!” ");
INSERT INTO beu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Angmuse, gubernur Galio angu ana iaterit iot parkara vengurus emana angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Angmuse Yunani enehe ba angmi ang naung, ini nehe nu ene Sostenes angu adoi. Aing angu, nehe Yahudi ehava hamulang angu ekapala. Ini adoi sengmuse, ini Sostenes at ila gubernur Galio apang-adangmi aing salava. Aulang aarunge gubernur Galio ana eat bae na angu paduli niang. ");
INSERT INTO beu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","19","Seng angmuse, Paulus ana Korintus mi mihit tarus. Aarunge luung niang muse, ana nehe ba omi vengaanamang angmi ang naung iapalai. Angmuse ana, Priskila bot Akila imampi bendar nu ene Kengkrea angu mi ila, senge ini angmi kampal ading. Kengkrea mi angmuse Paulus ana ong vaa angu il ening apolu, senge angu metma nehe etubing hula, naba ba ana tura metma Lahatala At palai tila angu, angase ana ening sengila. Angmuse ini kampal hila sengmuse aalarit bendar Efesus mi ila. Ila Efesus mi muse ini kampal angu taang bale hela. Angmuse Paulus ana Priskila bot Akila oleve iadu, sengila ba ana ila nehe Yahudi ehava hamulang angmi masot mida. Angmi angu Paulus ana Yahudi ang naung imampi tat mamateng. ");
INSERT INTO beu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ini tat mamateng sengmuse, Yahudi enehe ang naung Paulus abanang ot jedung imampi mihit luung kabingdena maveng hengi. Aarunge Paulus ana ea. ");
INSERT INTO beu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Angmuse Paulus ana iapalait hula, “Nekaku naung! Ekang iiomi alil ekang! Lahatala Ana via buka se, na bot bale hoa iiuuling.” Mateng aulang sengmuse, ana lamal ila Efesus eahalang. ");
INSERT INTO beu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Angmuse Paulus ana aalarit milalut ila bendar Kaisarea mi. Angmuse ana angmi hela. Sengila ba ana Yerusalem mi mida, senge ana aada aaung-hama metma jamaat angmi ang naung inang. Sengmuse, ana bale bendar Antiokia mi ila. ");
INSERT INTO beu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paulus ana angmi mihit mi laluung, sengmuse ana lamal ila, propinsi Galatia bot propinsi Frigia angu migoleng. Angmo mi angu, nehe ba omi vengaanamang ang naung, iomi angu ana taang ening adaeri. ");
INSERT INTO beu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Uanguveng angu, Yahudi enehe nu bendar Aleksandria ba propinsi Mesir mi angu, mi hoa. Ene Apolos. Aing angu, nehe hur-adang. Apolos ana Lahatala Esurat hamulang omi angu emangpi ateing. Ana uhavede hoa bendar Efesus mi. ");
INSERT INTO beu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Na emangpi ba Mutu Yesus Ana ening iila esarenta angu Apolos ana vengmee tila, angu ebele ana sukat metma nehe aabeung di iavomung-iapahang. Apolos ana kalakat vomung-pahang, bot naba ba ana vengbanang angu etabi. Aulang aarunge na ang naung emangpi Apolos ana bae manggarati jedung. Nehe ava vengbaroti senge Yohanis ana jar metma ing sarani, na angu ba ana ateing. ");
INSERT INTO beu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos ana nehe Yahudi ang naung ihava hamulang mi mateng angu, ana bae uangmari niang. Priskila bot Akila oleve di angmi aing venghele. Sambajang eamulung seng muse, Priskila bot Akila oleve hula ajalit at ihava mi ila. Ila hava mi muse, Priskila bot Akila oleve Lahatala Evia Aabetang angu emangpi metma Apolos veng at mateng lebe miaaung-maveng. ");
INSERT INTO beu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Angmuse, Apolos ana hula propinsi Akaya mi ila. Nehe omi vengaanamang ba Efesus mi ang naung ini at tominu bot eomi angu eamulung. Angmuse ini surat nu hurak metma ikaku ba iomi venganamang Akaya mi ang naung inang, senge banang iot Apolos aing tarimat aaung-aaung. Surat angu medi muse, ana lamal. Ila Akaya mi sengmuse, ana etatabit nehe omi vengaanamang angmi ang naung ioang moling. ");
INSERT INTO beu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos di nehe toang angmi ang naung, iapang aadangmi nehe Yahudi ang naung iat natataanang, aarunge Apolos ehur ang naung Yahudi enehe ang naung ini ebalet jadi niang. Apolos ana Lahatala Esurat hamulang eomi anguba metma iavomung-iapahang alolang niang hula, “Nehe ba Lahatala Ana vengpalai tilat hula Aing gahing hoa, benangba Yesus angu!” ");
INSERT INTO beu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos jedung bendar Korintus ba propinsi Akaya mi angu mi sehi se, Paulus ana lamal aabang ba dol taang ang naung mi goleng. Angmuse Paulus ana ila bendar Efesus mi. Angu mi, nehe aaedeng ba iomi metma Mutu Yesus vengaanamang iila angu ana ing harak. ");
INSERT INTO beu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Angmuse Paulus ana iadang taaning hula, “Kaku naung. Tura, iini iiomi metma Mutu Yesus vengaanamang angmuse, Lahatala ERoh hamulang angu iing veng iila e, niang?” Ini ebalet hula, “Niang. Ni bae vengmee di jedung, hula, Lahatala ERoh hamulang ba aulang angu ue.” ");
INSERT INTO beu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Angmuse Paulus ana iadangtaaning hula, “Aulang se, ini jar metma iing sarani angu, evia tatalang?” Angmuse ini ebalet hula, “Ini jar metma ning sarani angu, Yohanis ana jar metma nehe sarani evia angu ba eamulung.” ");
INSERT INTO beu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Angmuse Paulus ana iat hubait hula, “Iini vengmee hengi! Yohanis ana jar metma nehe sarani angu metma nehe etubing hula, ini iahalang-iavali ang naung vengbaroti tila. Aarunge na anga iini vengani! Ved kakanap aing ba Israel enehe ang naung iavomung-iapahang hula, ini malekang iomi metma Mutu Yesus angu ba vengaanamang, se Aing angu Nehe ba eningse Lahatala Ana Aing gahing hoa angu ebele.” ");
INSERT INTO beu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Vengmeet aulang muse, ini banang hula Paulus ot jar metma ing sarani, senge ing di masot metma Mutu Yesus Ehava omi enehe ening. ");
INSERT INTO beu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulus ana atang metma ing taang mea senge sambajang muse, Lahatala ERoh hamulang angu hela ing veng. Angmuse ini hur rupa-rupa ba ini bae ateing niang angu metma itat mateng. Lahatala Ana ing veng angu ebele, naba ba eningse Lahatala Ana ening angu, ini metma angu mi nehe at hubai. ");
INSERT INTO beu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ing emangpi angu inang arinu belta aalu. ");
INSERT INTO beu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulus ana jedung bendar Efesus mi mihi sehi angu, ana biasat ila nehe Yahudi ang naung ihava hamulang angmi maso. Angumi, ana nehe avomung-apahang hula Lahatala angu emenghula raja ba parenta pina angu edadenang. Ana vengmateng aulang angu ana bae uangmari niang, aarunge Paulus ana baranit Lahatala Ehur angu vengmateng. Ana ening aulang, eluung mi uuru tue. ");
INSERT INTO beu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Aarunge nehe iiba angu bae evomung-epahang angu tarima niang, base ini aing lavang. Ing di Mutu Yesus Evia Aabetang angu ehura-emananti. Angu ebele, Paulus bot nehe omi vengaanamang ang naung imampi tahit lamal hava hamulang angu eahalang. Angmuse ini ila sakola hava nu mi taing vengkumpul. Hava emanaing angu, ene Tiranus. ");
INSERT INTO beu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Paulus ana iavomung-iapahang, ila mi tung aaru; angu ebele, Mutu Yesus Ehur Aaung-hama angu nehe ba propinsi Asia mi iipi angu, emangpi vengmee. Yahudi enehe bot nehe ba bae Yahudi enehe niang ang naung di emangpi vengmee. ");
INSERT INTO beu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Uanguveng angu, Lahatala Ana Paulus aing veng, angu ebele tanda herang eapapahing bot nananiang ang naung ana ening. ");
INSERT INTO beu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Paulus esapebuar, bot noang ba ong parta angu ini medit baning ila sengila ba ini metma nehe dila ang naung ing tang mea se, nehe ang naung idilang angu mona tila. Aulang di bot setang jasi ang naung bihit nehe ang naung iahalang. ");
INSERT INTO beu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Angu mi angu, Yahudi e agama ekapala nu bot oal mehal inang bititu angu di ue. Kapala agama angu ene Sakewa. Oal ang naung ini biasat ila mana ang naung mi iipi, senge setang aterit metma nehe eahalang. Ing di bot hula, Yesus Ene angu vengbanang metma setang ateri. Ini setang enehe eele ang naung iat mateng hula, “Yesus Ene ba Paulus ana vengmaring angu omimi, na vengbanang metma aaing parenta, senge oot nehe anga eahalang!” Bot nehe Yahudi enehe hur adang aabeung inang aaedeng angu di vengsobat ening aulang. ");
INSERT INTO beu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Angmuse minu adana angu, Sakewa oal ang naung parentat aulang muse, setang jasi angu ibalet hula, “Na Yesus angu ateing. Na Paulus angu di ateing. Aarunge iing anga nuba?” ");
INSERT INTO beu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Angmuse, nehe ba setang aing vengbaa angu alil etatabi. Angmuse ana tahit ing marasi bot ing vengtahi. Ana ing ening aiibat, bot ipakiang ang naung di ana abahak, angu ebele ini idurat bihit hava angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Angmuse, esarenta angu aalilit mana kanap, angu ebele nehe ba Yahudi enehe bot bae Yahudi enehe niang ba bendar Efesus mi ang naung di emangpi ateing. Nuba ba sarenta angu vengmee angse, ini iuuangmari bot jonga. Angmuse ini Mutu Yesus Aing tajaning Aing palevang, se Lahatala Ekavasa angu ini uuling ateing iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Seng angmuse, nehe ba uhavede iomi vengaanamang ang naung, ini ikaku naung ba iomi vengaanamang iila ang naung ibele hoa iapangaadang mi, iahalang ang naung vengbanang. ");
INSERT INTO beu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ing anga naung, iiba angu ue tebahi ba ebasa-basa veng angu pina. Angmuse ini itebahi ba ebasa-basa veng ebuku ang naung akumpul, senge edet ening atepul. Buku ang naung ebili angu gare se, seeng perak ribu ari iising. ");
INSERT INTO beu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nehe ang naung ini ening aulang angu ba Lahatala Ehur Aaung-hama angu taang aalilit mana ang naung miiipi. Angu ebele nehe ba omi vengaanamang ang naung taang toang maveng. Se Lahatala Ehur Aaung-hama angu, nehe ang naung iomi mi tila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Seng angmuse, Paulus ana vengputus hula lamal bale Yerusalem mi ila. Aarunge ana malekang propinsi Makedonia bot propinsi Akaya ba ematurat mi ila senge, ana bot lamal milalut Yerusalem mi ila. Ana veng omi tilat hula, “Miaung, na ila mana anga naung mi nehe omi vengaanamang ang naung iuuling hengi. Se na malekeng ila bendar Roma di mi hengi.” ");
INSERT INTO beu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Angmuse Paulus ana Timotius bot Erastus oleve ba iat lamal metma ia-atang ening angu ing gahing senge iot imaturat Makedonia mi ila. Aarunge aing jedung propinsi Asia mi mihit luung. ");
INSERT INTO beu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Uanguveng angu ba, oorang eele bendar Efesus mi ava apaleteng metma Yesus Evia Aabetang angu adana. ");
INSERT INTO beu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Oorang eele angu e eela angu alang: Efesus mi angu, nehe perak vengmolang nu ene Dematrius. Ana biasat perak angu metma aaneda ehava kakili ening, senge metma Efesus enehe ang naung ioang aabali, senge ini mi iaaneda jangu nu, ene Artemis angu aing somba. Ekarajang angu etatabit ebili veng, angu ebele ana nehe toang iot oang moling, base seeng toang nehe metma ma inang. ");
INSERT INTO beu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Angu ebele, Dematrius ana emolang ang naung, bot molang aabeung ang naung emangpi ing kumpul, angmuse ana iat mateng hula, “Nimang iimal bot nekaku naung! Iini ateing iilat hula, pi aabetang anga aaung alang anga, pikarajang anga nehe seeng toang baning hoa metma mapinang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Aarunge angase naba ba Paulus ana ening angu, pi uuling teng taang ateing, bot taver vengmee tila. Se Paulus ana nehe toang ang naung iomi taang hula, naba ba pi ening anga emangpi bae egunang vengniang angu ebele. Aaneda ba pi ening anga naung Paulus ana vengbanang hula, angu aaneda ba bae ekavasa iiba vengniang. Bot nehe ba bae bendar Efesus mi anga naung ba inangkolang aing vengmee niang, aarunge nehe ba propinsi Asia mi iipi ang naung di, emangpi vengmee tila. ");
INSERT INTO beu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Iini vengmeet aaung-aaung! Nehe toang angu ini Paulus iimal iamulung aulang se, ping anga tatalang? Hula aulang se, nehe toang eat bae pikarajang anga beli niang iila! Angase vengani! Nehe toang pi aaneda jangu mahena ba, Artemis angu aing somba. Nehe propinsi Asia angu mi iipi bot por etupa ang naung taang angu ini hoa, sengila ba aaneda ehava ae pi bendar Efesus mi anga, mi aing tajaning. Base, misavaka nehe bae iat aaneda angu aing somba niang, bot ini bae iat angami hoa niang iila!” ");
INSERT INTO beu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Vengmeet aulang muse, iomi etatabit tutung. Angmuse ini moring hula, “Artemis aabeta! Artemis ba mahena! Ning Efesus enehe anga naung Artemis aing tajaning aing palevang!” ");
INSERT INTO beu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Vengmeet nehe aru-moring aulang muse, taang-taang mi angu nehe bihit ila sengila ba angu mi taing vengkumpul, angu ba bendar angu nehe aaving taing eetek, bot ing emangpi oorang-dumung. Angmuse nehe hama-hamat via oat lamal bir arahak, angu ba ini bot lamal ila bendar elelang eele angu di mi. Ini nehe aaru iadoi sengila ba ing masiring ila bendar elelang eele angu mi. Nehe aaru angu nu ene, Gayus bot nu angu ene Aristarkus. Nehe ang naung ini oleve anga iadoi angu, se oleve anga Paulus egahing vala ba Makedonia mi hoa angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Vengmeet aulang muse, Paulus ana hula nehe ba bir arahak ang naung ihahamami ila, aarunge nehe ba iomi metma Mutu Yesus vengaanamang angmi ang naung ini bae aing vengkilang ot ila niang. ");
INSERT INTO beu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nehe eele aaedeng propinsi Asia mi angu ini Paulus ateing. Ini nehe gahing ila Paulus at hubait hula, Paulus ot ekang nehe ba bendar elelang eele mi bir arahak ang naung ibele ila ekang. ");
INSERT INTO beu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Angmuse bendar elelang eele angumi, nehe ang naung ini parkara angu eeela-eaajala vengtaaning. Iiba angu moring hula “Alang!” Bot aabeung ang naung moring hula, “Aulang!” Nehe toang ba taing vengkumpul bendar elelang eele mi angu, vengbanang hula ini bae parkara angu eeela-eaajala ateing niang. Se ing angu mang hula eoorang-dumung anguba eamulung angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Uanguveng angu, nehe Yahudi ba angmi ang naung iuangmari tila, se ini veng iomit hula, misavaka nehe toang angu ing ening ahalat hula, ing ba parkara angu e eela. Angu ebele ini nehe nu aing oorok va iapangaadang mi tahi, senge aing metma ihur vala ening. Nehe angu ene, Aleksander. Ini banang senge ana mateng ing vengeebang vengbanang hula, parkara angu, bae nehe Yahudi ang naung ba eela mea niang. Angmuse Aleksander ana atang ohi, senge ini ekang oorang ekang, senge ana hula mateng nehe Yahudi ang naung ing vengeebang. ");
INSERT INTO beu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ini ateing se aing angu Yahudi enehe muse, ini bot taang moring iamal aelet hula, “Artemis aabeta! Artemis ba mahena! Ning Efesus enehe ang naung Artemis aing tajaning-aing palevang!” Ini aru moring aulang oda aaru omimi. ");
INSERT INTO beu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","36","Angmuse, bendar Efesus eparenta enehe eele angu tahit mateng nehe ang naung iot taimang. Ana mateng hula, “Nekaku naung, iing ba bendar Efesus enehe! Nehe emangpi ateing iilat hula, pi aaneda Artemis ehava angu ae bendar Efesus anga mi, bot evar angu burangmi ba baat hela, angu ebele var angu pi metma Artemis ehava angu omimi gariang mea. Base, tatalang ba iini moring alang anga? Nehe akal mateng iomi eamulung tatalang dise, iing ekang sama bir arahak alang ekang! ");
INSERT INTO beu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Iini Gayus bot Aristarkus oleve ing masiring anga mi hoa anga, emenghula ini ue jasi ening sehi angu edadenang. Ini bae Artemis ehava ba mi aing sasomba angu mi na iiba taavi niang. Bot ini bae hura-manantit metma pi aaneda ene aaung angu adana niang. ");
INSERT INTO beu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Iini venganit aaung-aaung! Ping anga pi mana parkara vengputus ue. Nehe ba vengpaputus angu di ue perkara angu ading sehi. Base, Dematrius iimal hula parkara ening se, ini malekang evia angu eamulung, senge parkara angu baning emana vengpaputus angu mi ila. ");
INSERT INTO beu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Bot na aabeung di ini hula metma parkara ening se, ini malekang ila hada eboma ang naung imampi vengmateng hengi. ");
INSERT INTO beu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Misavaka Roma eparenta enehe eele angu ana ahalang anga metma ping taang mea, se oorang-dumung anga ebele. Ini hula etatalang ba nehe bir arahak angu vengtaaning ateing se, naba ba pi metma ibale? Se parkara anga e eela bae vengniang angu ebele!” ");
INSERT INTO beu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mateng aulang seng muse, nehe eele angu ana nehe ang naung iot baraki. Angmuse ini ila. ");
INSERT INTO beu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bendar Efesus mi angu, nehe bot bae bir arahak niang iila muse, bendar angu tening emenghula biasa angu edadenang. Angmuse Paulus ana nehe omi vengaanamang angmi ang naung ing kumpul, senge iomi angu ening aanamang ana bot iapalai, angmuse ana lamal propinsi Makedonia mi ila. ");
INSERT INTO beu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ila angmi muse, Paulus ana lamal aabang ba propinsi Makedonia mi angu mi goleng, senge nehe omi vengaanamang ang naung ana iavomung-iapahang iomi ening aanamang. Paulus ana ening aulang, angmuse ana ila nehe Yunani ang naung ipor taang. ");
INSERT INTO beu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Paulus ana angu mi mihit mi uuru tue. Seng angmuse, ana ava vengharakat aalarit propinsi Siria mi ila, aarunge ana vengmee se hula, nehe Yahudi ang naung itominu sehit hula ameang. Vengmeet aulang muse, ana eat bae aalarit milalut propinsi Siria mi ila niang. Base ana mang ia venglamal bale propinsi Makedonia ba adang ila. ");
INSERT INTO beu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Rombongan kiki nu Paulus amulung at lamal benang ba, Timotius; Sopater Pirus oal ba bendar Berea mi hoa; nehe aaru bendar Tesalonika mi hoa, iene Aristarkus bot Sekundus ole; nehe nu bendar Derbe mi hoa, ene Gayus; bot nehe aaru propinsi Asia mi hoa, benang ba Tikikus, bot Trofinus oleve. ");
INSERT INTO beu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","6","Seng angmuse, naing (Lukas ba surat anga hurak angu), bale bendar Filipi ba propinsi Makedonia mi angu, mi Paulus aing harak. Angmuse Paulus egahing vala ang naung lamal imatura, senge ila bendar Troas ba tang edenaveng angu mi niading. Nehe Yahudi ang naung ived eele Paska angu lakal iila muse, Paulus noleve kampal hila, senge hula aalarit bendar Troas mi ila. Ni aalarit mietang iising muse, ni ila bendar Troas mi, angmuse ni kampal taang kaluar hela. Hela angmi muse niserang ba imaturat ila angmi tila ang naung ni ing harak, angmuse ni angmi mihit mi ong nu. ");
INSERT INTO beu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Uanguveng angu, ved Minggu adana. Paulus ana veng omit hula lamal muse, ana mateng hula, “Kaku naung, tobang se na lamal”. Base nehe omi vengaanamang ang naung nimangpi taing vengkumpul, senge ni naadang hama-hama. Paulus hula lamal angu ebele ana niat mateng ila tereng hahama. ");
INSERT INTO beu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ni taing vengkumpul angu hava nu eomi atela ba emitue angu mi. Kua angu veng angu, ini lampu toang ajara. ");
INSERT INTO beu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Uanguveng angu, nehe kuar nu ene Yutikus, ana ganela viaha taang mihi. Andi Paulus emateng angu eamulung venghele. Aarunge luung niang muse eng angu mang tamadi, angmuse ana udut ori. Mibaroti muse, ana ganela viaha angu taang baat meke mi hela. Angmuse ana aamina. ");
INSERT INTO beu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Angmuse Paulus ana hela, ava metma nehe kuar angu aing taang abaang sengmuse ana aing karavang. Seng angmuse ana mateng hula, “Ekang iiuangmari ekang. Ana aabeta.” ");
INSERT INTO beu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","Ning emangpi sanang, se nehe kuar angu aabeta angu ebele. Angmuse ini at ehava mi ila. Angmuse ning emangpi bot bale hava omi eatela angu mi mida, sengila ba ni mihit naadang hama-hama. Seng angmuse Paulus ana bot bale emateng angu taang hamuat ila kuaveng. Vedeng da muse, ni lamal. ");
INSERT INTO beu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Seng angmuse, ni temaring senge taing paul lamal, aulange ila bendar nu ene, Asos angu mi senge ni bot bale taing harak. Angmuse ni angmi kampal hila sengila ba aalarit Asos mi ila. Aarunge Paulus mang ia venglamal Asos mi ila. ");
INSERT INTO beu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ni Asos mi Paulus aing harak muse, andi kampal taang mida, sengila ba aalarit ila bendar Mitilene mi. ");
INSERT INTO beu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mitilene mi muse, ni aalari tarus. Emi tobang muse, por nu ene Kios angu ni abung aalari. Emietang aaru muse ila por nu ene Samos e omi oa angu mi. Emietang tue muse, ni ila bendar Miletus mi. ");
INSERT INTO beu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Aarunge Paulus omi midadanang sehit hula uuser ila bendar Yerusalem mi, senge ana angmo mi ved eele Pentakosta angu eamulung. Angmuse, ana eat bae ooras angu bia niang angu ba, ana bae lamal bendar Efesus ba propinsi Asia mi angu mi mida niang, se ooras iiba bae ue niang iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Base, Miletus mi angu, Paulus ana amal panatut ila metma jamaat eboma ba Efesus mi ang naung inang, senge ini hoa aing harak. ");
INSERT INTO beu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ini hoa aing harak muse, Paulus ana iat hubait hula, “Kaku naung. Halomang na uhavede ila propinsi Asia mi angu, ved ehalomang ila anga vengjehi anga, ne aabetang elamal-etahi angu iini ateing iila. ");
INSERT INTO beu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Iing di ateing se na iihahama angu mi karajang netarung metma vengboar, bot na bae nava ohit ening aeele-abalolu di niang, aarunge na nava ening alolang-alolang. Ne karajang omimi anga, na nengoono toang ahorung bot na susa-lala toang harak. Nehe Yahudi ang naung iomi jasi metma nadana angu esusa-lala toang angu di na harak. ");
INSERT INTO beu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Na iiavomung-iiapahang se, aaung-hama ba na ateing angu, emangpi na vengbanang metma ma iinang. Nehe toang iapang aadang mi di na iiavomung-iiapahang. Aulang di na bot ila nehe ang naung ihava kanap, senge Lahatala eomi angu metma iat hubai ivengani ening. ");
INSERT INTO beu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yahudi enehe bot nehe ba bae Yahudi enehe niang ang naung di na iat hubait hula, ini malekang iahalang-iavali ang naung vengbaroti, senge Lahatala amulung. Bot ini malekang iomi metma Mutu Yesus, Aing ba pi Manaing angu, Aing vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Base, na hula iiat hubait alang: Angase, na hula Yerusalem mi ila, se Lahatala ERoh hamulang naing gahing not lamal angmo mi ila angu ebele. Na mang eamulung, naba ba angmo mi jadit metma nadana di, na bae ateing niang. ");
INSERT INTO beu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Aarunge, Lahatala ERoh hamulang angu ematurat nat hubait tilat hula, eningse na angmi bui maso, bot bendar nu mi, senge ila bendar nu mi se na susa-lala toang harak. ");
INSERT INTO beu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Na etatabit ateing iilat aulang, se Mutu Yesus ba karajang anga metma veng naing gahing bot Ana metma nabea taang mea, senge na ila Lahatala Ehur Aaung-hama angu metma nehe at hubait hula, Lahatala Ana Omi metma pijahi, bot Eaaung-Ehama ba bae ebale vengniang angu Ana ening metma piadana. Na bae Lahatala Eomi angu eamulung niang senge, Ekarajang anga bae ening evengtahi mi niang angse, na vengnomi se ne aabetang anga bae egunang veng niang. ");
INSERT INTO beu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Na ateing iilat hula, angase pi bot bae bale taing harak niang iila. Turang mi, na iiavomung-iiapahang hula tatalange iing metma Lahatala Ehava omi enehe ening. ");
INSERT INTO beu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","28","Angu ebele, vengmeet aaung-aaung. Ne karajang ba na metma iiadana angu na ening seng iila. Base angase, iing ba jamaat eboma ang naung malekang karajang tarus. Iinehe iiba bae masot metma Lahatala Ehava omi enehe ening niang angse, venganit aaung-aaung! Iing ba jamaat eboma angu ba iiapang metma adana! Se angu bae ne ahalang niang angu ebele. Lahatala Eomi angu emangpi na metma veng iiat hubai tila. Na bae na nu metma vengiiamang di niang. Base iini malekang iiabetang angu vengjagat aaung-aaung, bot iini malekang nehe omi vengaanamang ang naung emangpi ing gariang aaung-aaung, se Lahatala ERoh hamulang Ana iing gahing iila angu ebele. Mutu Yesus Ana aamina senge Eve angu metma nehe toang ang naung sai tila angu, iini ekang vengtajebing ekang. Ana bot via metma iitubing senge iini ing vengbalenta, emenghula jumba eterangvala ana ejumba ang naung gariang angu edadenang. ");
INSERT INTO beu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Angase, na iiadu. Aarunge vengani! Eningse nehe iiba hoa, sengila ba vomung-pahang jasi metma iihahama angu mi iiat hubai. Ini masot emenghula jabar lumul ba ila jumba elapa omi mi masot mida angu edadenang. ");
INSERT INTO beu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nehe ba akal mamateng aulang ang naung iiba angu aabeung mi hoa. Aulang di iiba angu bot iihahama angu mi ava apaleteng, senge naba ba bae molo niang angu metma veng iiavomung-iiapahang. Ini hula ening aulang senge, nehe ing ba iamulung. Angu ba ini vengsobat ening aulang metma nehe toang omi abili, senge ekang Yesus amulung ekang. ");
INSERT INTO beu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Aulang angu ebele, iini malekang iiava vengjagat aaung-aaung. Ekang vengtajebing ekang, se na iiat mihit hama-hamat ila mitung tue angu ebele. Kua-jala na iiavomung-iapahang, bae ne dira angu venguukur niang. Nengoono toang na ahorung angu, iing anga ebele. ");
INSERT INTO beu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Angase, pihula tat tatara. Base, na iing emangpi iing metma Lahatala atang mi abaang, senge Ana iing gariang. Bot na metma veng iiat hubai tila hula Lahatala Eaaung-Ehama angu Ana ening metma piadana tila. Angu ebele iini malekang pinat aanamang. Se Lahatala angu Ekavasa veng, base ening iini daeri. Lahatala Ana palai tilat hula, Eaaung-Ehama angu Ana metma Enehe ang naung inang. Base, iini iiomi ening ahamulang bot malekang Lahatala anguba amulung, senge iing di Eaaung-Ehama angu harak. ");
INSERT INTO beu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Na iihahama angumi karajang sehi angu, iibarang ang naung na bae vengnomit hula nu medi di niang. Iibarang mas, perak, pakiang bot naba-naba angu, na bae hula banang di niang. ");
INSERT INTO beu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Iing di ateing, na jedung iiat mihi sehi angu, na karajang netarung metma vengboar etatabit hula, tatalang senge na aabeta. Bae metma neabetang adana angu ba enang kolang niang, aarunge na karajang senge, metma nehe ba neamulung ang naung di iaabetang angu adana. ");
INSERT INTO beu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Na emangpi anga, evia angu na metma iitubing iila, base iini eamulung senge, nehe masiking-kasiang ang naung iini ioang moling. Mutu Yesus Emateng angu venganit aaung-aaung, hula, ꞌPi na iiba metma nehe enang angu euuntung lebe mieele, aarunge pihula mang tarima angu, euuntung bae veng niang.” ");
INSERT INTO beu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulus mateng aulang seng muse, ana iakuku muding iat sambajang Lahatala abanang aulange Lahatala Ana ing emangpi ing gariang. ");
INSERT INTO beu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Angmuse ing emangpi iomi mang etatabit dira, se Paulus ana mateng iilat hula, eningse ini bot bae aing harak niang angu ebele. Base ini hula itat tatara muse, ini Paulus aing karavang senge amiku, bot baut etatabi.Seng angmuse, ini Paulus aing metma kampal vengadu. ");
INSERT INTO beu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jamaat eboma ba Efesus mi ang naung nimampi tapalai angu iomi mang etatabit dira, aarunge ni mang tahit lamal iahalang sengila ba kampal taang mida, sengmuse aalarit por Kos taang ila. Emi tobang muse, ni aalarit ila por Rodos mi. Angumi, ni aalarit tarus ila bendar Patara eoolol mi. ");
INSERT INTO beu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Angu mi ni kampal angu taang kaluar hela. Sengmuse, kampal aabeung nu hula aalarit propinsi Fenisia ba Siria abung angu mi ila angu ni harak. Base ni angmi kampal angu taang mida, angmuse nehe livang masiring sengmuse ni lamal. ");
INSERT INTO beu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ni aalarit luung di niang muse, Siprus por angu ni uuling ateing se ni bajaul oa angmi, aarunge ni mang aalarit milakal propinsi Siria adang ila. Ni ila bendar Tirus eoolol angu mi livang abaang teding. Se kampal ba ni taang angu, hula angmi naosing aadu angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ini jedung kampal enaosing angu aadu sehi muse, ni angmi hela sengila ba ila nehe omi veanganamang ang naung ing aalaping. Ila ing harak muse, ni angmi iat mihit ila mi ong nu. Nehe ba angmi ang naung Lahatala ERoh iat hubai tila, senge iot Paulus at mateng hula ot ekang Yerusalem mi ila ekang. ");
INSERT INTO beu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Aarunge mi ong nu seng muse, ni bale kampal taang mida. Nehe ba omi vengaanamang ang naung mijangu-mimehal, kiki-eele, boma-kuar ing emangpi niat ila oolol mi. Angumi ning emangpi nia kuku muding senge sambajang hama-hama. ");
INSERT INTO beu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Seng angmuse ni angmi tapalai, angmuse ni kampal taang mida, bot ing emangpi angu bale ihava mi ila. ");
INSERT INTO beu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ni Tirus mi lamal muse, ni ila bendar Ptolemais mi miari. Angu mi di, ni kampal taang kaluar hela sengmuse, ni ila nehe omi vengaanamang ang naung ing aalaping. Ni ing harak muse ni iat mihit ved nu. ");
INSERT INTO beu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Emitobang muse, ni bot angmi lamal ila bendar Kaisarea mi. Angu mi, ni ila Pelipus ehava mi mihit vengtahang. Pelipus angu ba Mutu Yesus Ehur Aaung-hama angu, halomang-halomang baning hoa angu mi. Bot aing angu, nehe bititu ba nehe ing vengtalail senge, mod paul metma memet kalabal ba Yerusalam mi ang naung inang angu, enu ba aing angu. ");
INSERT INTO beu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pelipus angu oal jangu kaneng inang buta. Lahatala Ana ing matubing metma hur vala ening, senge ini Lahatala Epalai angu metma nehe at hubai. ");
INSERT INTO beu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ni iat mihit ved aaeedeng muse, nehe nu ene Agabus angu ana propinsi Yudea mi ba hoa. Lahatala Ana aing matubing metma hur vala ening, senge ana Lahatala Epalai ang naung metma nehe at hubai. ");
INSERT INTO beu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Agabus ana nibele hoa seng muse ana Paulus esapebuar angu medi, seng muse sapebuar angu Agabus ana metma ia-atang angu parta. Angmuse ana mateng hula, “Lahatala ERoh hamulang vengbanang hula alang: “Eningse Yahudi enehe ang naung ini Yerusalem mi sapebuar anga emanaing angu aing partat ening alang. Seng angse ini aing metma nehe ba bae Yahudi enehe niang ang naung iatang mi abaang.” ");
INSERT INTO beu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Vengmeet Agabus ana mateng aulang muse, ning emangpi Paulus abanang-asenang, senge ana ekang Yerusalem mi ila ekang. Ning ba egahingvala ang naung, bot nehe omi vengaanamang ba mana angu mi angu, banang aulang. ");
INSERT INTO beu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Aarunge ana nihur ebalet hula, “Niang! Etatalang ba iini baut aulang angu? Iini ening nomi anga etatabit dira tila. Alang! Nehe iiba omi mang etatabit bae naing vengsanang niang, se na Mutu Yesus amulung angu ebele. Aarunge kilang ini nadoi bot naing ening na aamina, ini ening tatalang metma nadana dise, angase na nava vengharaka tila. ");
INSERT INTO beu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ni ateing hula, Paulus eat bae ning venghele niang muse, ni aing vengkilang, senge ni vengbanang hula, “Kilange Lahatala Eomi angu ba eamulung.” ");
INSERT INTO beu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ni Kaisarea mi mihit ved aaedeng iila muse, ni ninaosing ang naung taloul, seng angmuse ni lamal Yerusalem mi ila. ");
INSERT INTO beu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nehe omi vengaanamang inang aaedeng Kaisarea mi angu di niamulung. Ini niat ila hava nu mi muse, ni angu mi tiat vengtahang. Hava manaing angu, ene, Manason. Aing angu Siprus por taang hoa. Bot ana Mutu Yesus amulung luung iila. ");
INSERT INTO beu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ni ila Yerusalem mi muse, nikaku naung ba iomi Lahatala vengaanamang ang naung emangpi ning tarima bot iomi etatabit mang sanang. ");
INSERT INTO beu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Emitobang muse, ning emangpi ila Yakobus bot jamaat eboma ba angmi taing vengkumpul ang naung emangpi ing harak. ");
INSERT INTO beu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ni ing aada seng muse, Paulus ana iat mateng hula taang-taangmi angu Lahatala Ana na emangpi angu ening metma nehe ba bae Yahudi enehe niang ang naung di ioa tila. Mutu Yesus Ana via buka senge ini iomi metma Aing vengaanamang iila. Paulus ana bot vengbanang hula Lahatala Ana aing veng bot eserang ang naung emangpi ing veng angu ebele ini Lahatala Ekarajang angu at lamal. ");
INSERT INTO beu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Vengmeet Paulus ana mateng aulang seng muse, ing emangpi Lahatala Aing tajaning-Aing palevang. Angmuse Yakobus bot jamaat eboma ang naung ini Paulus at hubait hula, “Kaku Paulus! Aana malekang ateing hula, Yahudi enehe ang naung ribu-ribu iomi metma Mutu Yesus vengaanamang iila. Agama evia-via ba boma Musa metma mapinang ang naung, ini jedung pinat aanamang sehi. ");
INSERT INTO beu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Aarunge nehe iiba aai avarit angmi vengbanang iilat hula, mana aabeung mi angu, aana nehe Yahudi ang naung iavomung-iapahang hula, agama evia-via ba boma Musa ana metma mapinang iila angu, iot ekang eamulung ekang. Aana vengbanang hula, iot ekang ioal mehal ang naung ing sunat ekang. Bot nehe ba iomi Mutu Yesus vengaanamang ang naung di aana iat hubait hula iot ekang ping nehe Yahudi pihada evia-via aabeung ang naung di eamulung ekang. ");
INSERT INTO beu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Aana vengani! Yahudi enehe ba iomi vengaanamang iila ang naung eningse ini vengmeet hula, aana ae angami tila. Bot nehe ba eehoja vengmee tila ang naung, eningse ini alil. Base angase pi hula, ening tatalang? ");
INSERT INTO beu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Angu ebele, ni hula vengbanang alang: Nehe buta ae ning veng anga ini Lahatala At palai tila. Angase ini hula iongvaa angu il ening apolu, senge metma nehe etubing hula, ipalai angu ini eamulung ening sengila. ");
INSERT INTO beu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Aana nehe buta angu iat hama-hamat ila Lahatala Ehava hamulang mi maso mida. Aana iamulung, senge aababahi angu ening ahamulang, ping nehe Yahudi pivia-via angu eamulung. Aandi malekang iseeng hela angu moling bajar evia angu eamulung. Aana ening aulang se, nehe ang naung ateing hula, boma Musa eparenta evia-via angu, aandi jedung pinat aanamang sehi. Bot ening aulang senge, sarenta ba vengbanang hula, aana nehe ot ekang Yahudi evia-via angu eamulung ekang angu nehe ateing hula, emangpi angu bae etabi niang! ");
INSERT INTO beu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Aarunge nehe ba bae Yahudi enehe niang di iomi metma Mutu Yesus venganamang iila ang naung, pi surat panatut metma mainang iila. Tura pi vengputus hula ping Yahudi eagama evia-via angu emangpi ini ekang eamulung ekang angu, pi metma veng iat hubai tila. Aarunge via-via ba ini malekang vengani senge ening eamulung, benang ba: Nehe ba bae iimehal niang bot bae iijangu niang angu ekang aing vengbuha ekang. Naba ba nehe metma aaneda ahi angu ekang adang ekang, ekang ve adang ekang; bot binanta ba nehe obo kaomit ameang angu, ekang euumung angu adang ekang.” ");
INSERT INTO beu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Angmuse, Paulus ana imateng angu metma omimi. Base emitobang muse, Paulus ana nehe buta angu iat ila Lahatala Ehava hamulang elapa omimi, senge iababahi ening ahamulang, Yahudi eagama evia-via angu eamulung. Seng angmuse, Paulus ana kapala agama angmi angu at hubait hula, inang buta iababahi ening ahamulang angu ening evengtahi angu, ved eedeng jedung. Ved eedeng jedung angu evengtahi se, ing emangpi malekang nu-nut isadaka baning ila Lahatala Ehava Hamulang mi metma Lahatala enang hengi. ");
INSERT INTO beu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","29","Ved eedeng jedung angu eveng tahi mi muse Paulus bot eserang nu ene Trofimus, oleve Lahatala Ehava Hamulang mi ila. Uanguveng angu Yahudi enehe inang aaedeng propinsi Asia mi hoa angu di ue angmi. Yehudi enehe ang naung ini uuling oleve iateing. Trofimus anga, bendar Epesus mi hoa, aing bae Yahudi enehe niang. Nehe Yahudi ba propinsi Asia mi hoa ang naung ini uuling ateing se Paulus ana ila Lahatala Ehava hamulang mi maso muse, ini oma hula Paulus ana eserang Trofimus at hama-hamat angu mi ila. Se nehe ba bae Yahudi enehe niang angu ila Lahatala Ehava hamulang angumi maso niang angu ebele. Angu ebele ini na anga ba metma e eela ening, senge parkara ening. Base Yahudi enehe inang aaedeng ba propinsi Asia mi hoa angu ini nehe angmi ang naung iomi taang, senge Paulus adoi. Bot ini moring nehe angmi ang naung iat hubait hula, “Ee! Iing ba Israel enehe ang naung! Nioang moling hengi. Nehe anga ba, taang-taangmi ana nehe emangpi iavomung-iapahang hula, ping Yahudi eagama angu nehe ot ekang eamulung ekang angu. Ana bot mateng jasi-ahalat metma Lahatala Ehava hamulang anga adana. Bot angase, ana nehe ba bae Yahudi enehe niang angu at maso senge hula Lahatala Emana hamulang anga ening akarita.” ");
INSERT INTO beu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Vengmeet aulang muse, nehe ba bendar Yerusalem mi ang naung emangpi iomi etatabit alil. Angmuse nehe toang angmi ang naung bihit ila Lahatala Ehava hamulang elapa omimi taing vengkumpul. Angmuse ini Paulus adoit aing pina, seng muse ini aing masiring hava hamulang angmi kaluar hela. Angmuse, ini viaha ang naung emangpi vengtering. ");
INSERT INTO beu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nehe ang naung ini hula Paulus ameang muse, nehe ila Roma etentara enehe eele ba angmi angu at mateng, angu ebele ana oorang-dumung angu vengmee. ");
INSERT INTO beu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Uanguveng angu ana etentara ang naung, bot inehe eele ang naung emangpi iaru, senge ini ila nehe toang ba hula Paulus ameang angu ehahama mi maso. Ini uuling ateing se tentara ang naung bot inehe eele ang naung hoa iila muse, ini bae Paulus aing bue niang iila. ");
INSERT INTO beu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Angmuse nehe eele angu ana Paulus adoit aing pina, seng muse ana nehe gahing nehe ot rante oola aaru metma aing parta. Ini aing parta seng muse, nehe eele angu ana nehe ang naung iadang taaning hula, “Aing anga nuba? Ahalang naba ba ana ening?” ");
INSERT INTO beu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nehe toang angu iiba mateng hula, “Ana ening alang.” Aarunge iiba bot hula, “Ana ening aulang iila.” Angmuse nehe eele angu ana bae parkara e eela angu manggarati niang iila, se nehe toang ba angmi ang naung moring alolang niang angu ebele. Angmuse ana gahing senge ini Paulus at jaga hava mi ila. ");
INSERT INTO beu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Tentara ang naung ini hula Paulus at ila mana angu eahalang, aarunge nehe ang naung ini hama-hamat iamulung, senge bot taang bir arahak maveng. Ini at ila hula via oat mida muse, nehe ang naung ini hanunggur ila nehe toang ang naung iapang aadang mi hula Paulus aing masiring medi, senge aing bue-aing sabai. Angu ebele tentara ang naung ini Paulus aing tevang, senge nehe ang naung ekang aing bue ekang. Ang muse ini moring iamal aelet etatabit hula, “Ameang! Ameang!” ");
INSERT INTO beu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ini hula mana jaga angu mi masot mida muse, Paulus ana Yunani ehur mi mateng metma tentara enehe eele angu abanang hula, “Nimang! Na mateng kabingdena se, bisa ee niang?” Vengmeet Paulus mateng aulang muse, tentara enehe eele angu mibaroti, angmuse ana taaning hula, “Aandi Yunani ehur ateing? Tatalang ba aana bisa Yunani ehur vengmateng? ");
INSERT INTO beu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Hula aulangse, nenomi anga ahala tila. Na veng nomit hula, aaing anga Mesir enehe ba tura nehe omi taang senge ini bir arahak angu. Seng angmuse, ana bot nehe ribu buta ba golo maang pina angu iat bihit mana osing mi ila angu. Aarunge aaing anga bae nehe angu niang.” ");
INSERT INTO beu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Angmuse Paulus ana ebalet hula, “Niang nimang! Naing anga Yahudi enehe. Niva ana bendar Tarsus ba propinsi Kilikia mi angu, mi naing vengajai. Na banang nimang aana naing ening lohi, senge na bisa nehe toang anga naung iat mateng.” ");
INSERT INTO beu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tentara enehe eele angu ana vengjali. Angmuse Paulus ana via taang tahi senge bot atang ohi, banang iot taimang, senge ana hula iat mateng. Angmuse ana Ibrani ehur ba metma iat mateng. (Se angmi angu, Yahudi enehe ang naung ini Ibrani hur ba vengmateng angu ebele). ");
INSERT INTO beu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Angmuse Paulus ana mateng hula, “Nimang iimal, bot nekaku naung! Na banang iini iiavel metma naing venghele, senge na hula iiat mateng nava vengebang.” ");
INSERT INTO beu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nehe toang ang naung vengmee se Paulus ana ihur ba vengmateng angmuse ing emangpi taimang, senge hula ehur angu vengmeet aaung-aaung. Angmuse ana ehur angu taang hamuat hula, ");
INSERT INTO beu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Naing anga Yahudi enehe. Niva ana bendar Tarsus ba propinsi Kilikia mi angu, mi naing vengajai. Aarunge na Yerusalem anga mi aabetat ila veng eele. Guru eele nu angami, ene Gamaliel angu ba navomung-napahang. Ana boma Musa eparenta evia-via angu emangpi metma na vomung-napahang ila evengtahi mi. Nandi bot kalakat Lahatala eamulung emenghula iing emangpi anga edadenang. ");
INSERT INTO beu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tura angu nehe ba Yesus Evia Aabetang eamulung ang naung na ila iadoi, senge ing ening susat etatabi. Mijangu-mimehal, na iadoi senge iat hoa Yerusalem anga mi, sengila ba ing metma bui mi maso. Uanguveng angu, iiba angu aamina. ");
INSERT INTO beu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pi agama ebuangvala ang naung ekapala angu, bot nehe eele aabeung ba agama eparkara vengurus ang naung emangpi ateing hula, naba ba na vengbanang anga etabit aulang! Na bae akal mateng niang. Se ing angu ba surat kuasa metma manenang, senge na baning ila bendar Damsik mi hula nehe ba Yesus eamulung ang naung iadoit ing pina, senge iat hoa Yerusalem anga mi angu ebele. Nenomi hula aulang senge, nehe ba agama eparkara vengpaputus ang naung ba ing hukung.” ");
INSERT INTO beu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Angmuse Paulus ana emateng angu taang hamuat hula, “Na lamal Damsik mi ila, senge na angmi nehe ba iomi metma Mutu Yesus vengaanamang ang naung ing aalaping. Ved hahama muse, ni hula bendar maso. Mibaroti se, huring jara eele nu burang mi hela naing veng goleng. ");
INSERT INTO beu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Angmuse na baat meke mi hela, senge na nehe amal nu vengmee se nat hubait hula, ꞌSaulus! Etatalang ba aana naing ening susa-lalat alang anga?ꞌ ");
INSERT INTO beu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Na etabit nehe amal angu vengmee, aarunge na bae uuling nehe angu ateing niang. Angmuse na taaning hula, ꞌNimang, Aaing ba nat mateng anga nuba?ꞌ Angmuse, nehe amal angu bot nat mateng hula, ꞌNaing anga Yesus, Nasaret enehe ba aana Naing ening susa-lala angu!ꞌ ");
INSERT INTO beu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ne serang naung ba nat lamal ang naung ini uuling huring-jara angu ateing, aarunge nehe amal angu ini bae vengmee niang. ");
INSERT INTO beu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Angmuse na nehe amal angu ebalet hula, ꞌAulangse, na malekang naba ba ening hengi?ꞌ Nehe amal angu nat hubait hula, ꞌAaungba tahi, senge ila bendar mi maso. Ila angu mi senge, emangpi ba eningse aana malekang ening angu Na metma veng aat hubai.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Vengmeet aulang seng muse, na naloming tahi. Aarunge na bae uuling na iiba ateing niang iila, se huring-jara angu ebele. Angmuse ne serang ang naung ini natang pina senge, nat ila bendar Damsik mi maso. ");
INSERT INTO beu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Angmi angu nehe nu ene, Ananias. Aing anga ana aabetat Lahatala eomi angu eamulung, bot boma Musa eparenta evia-via ang naung di ana pinat aanamang. Yahudi enehe ba bendar angu mi mihi ang naung di emangpi aing vengsanang bot ini aing aada. ");
INSERT INTO beu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananias ana naing valaping hoa, sengmuse ana mateng hula, ꞌKaku Saulus! Aaungba eeng angu uuling!ꞌ Ana mateng aulang seng muse na napang ohi, angmuse na uuling aaung iila. ");
INSERT INTO beu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Seng angmuse, Ananias ana nat mateng hula, ꞌLahatala ba tidat-timang ang naung sambajang abanang angu, angase Lahatala anguba Ana aaing vengtalail iila. Senge aana Lahatala Eomi angu manggaratit aaung-aaung. Bot aana eeng metma Yesus ba Lahatala Emalea ba aabetat Lahatala Eomi Eamulung angu euuling. Angase Lahatala Ana via buka senge aana Yesus angu ba Aing vengmee. ");
INSERT INTO beu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Lahatala ba aaing vengtalail iila, senge Ehur aaung-hama angu baning lamal metma taang-taang mi nehe veng at hubai. Naba ba Lahatala Ana metma eetubing aana uuling eeng taang ateing, bot Ana metma veng aat hubai senge aaver vengmee tila angu, emangpi aana malekang vengbanang. ");
INSERT INTO beu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Aana ekang bot ading luung-luung ekang. Aaungba tahi! Ila senge iot jar metma aaing sarani! Aana bot Lahatala abanang senge Ana eeahalang ang naung emangpi vengahi.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Paulus ana emateng angu taang hamuat hula, “Seng angmuse, na lamal bale Yerusalem mi ila. Ved nu adana, na ila Lahatala Ehava hamulang mi sambajang. Na sambajang sehi se, Lahatala Ana metma netubing, emenghula na iipal-na edadenang. ");
INSERT INTO beu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Na uuling Yesus ateing. Angmuse Ana naing parentat hula, ꞌAngase aaungba aana uuser lamal bendar Yerusalem anga eahalang! Se emangpi metma Nadana ba aana vengmaring angu nehe Yerusalem mi anga naung iat bae tarima niang angu ebele.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na ebalet hula, ꞌAarunge, alang, Aaing ba neManaing! Kapala agama emangpi ateing hula, tura angu, naing ba lamal nehe Yahudi ehava hamulang ba taang-taang mi ang naung mi kaluar maso, senge nehe ba omi metma Aaing vengaanamang ang naung iadoi bot ing bue angu. ");
INSERT INTO beu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kapala agama ang naung di bot ateing se, ini Lahatala Eetvala, Stepanus odat ameang angu, nandi ue angmi, bot nandi vengjali. Ini var akumpul senge metma Stepanus oda angu naing ba ipakiang ang naung jaga.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Aarunge Yesus Ana bot bale naing parentat hula, ꞌAaing mang lamal. Se Nahula aaing gahing ila mana ola ang naung mi, senge angu mi nehe ba bae Yahudi enehe niang ang naung iavomung-iapahang angu ebele.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nehe toang ang naung vengmee se Paulus mateng hula, Lahatala Ana aing gahing nehe ba bangsa aabeung ang naung ibele ila muse, ini bae aing venghele niang iila. Ing emangpi alil, angmuse ini hama-hamat moring hula, “Ekang bot nehe anga aing venghele ekang! Aaungba ameang! Aing angu bae bisat aabeta niang iila.” ");
INSERT INTO beu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ini moring aulang, angmuse ini ikondo eele ang naung aahit bariting, sengmuse ini moro aabar medi, senge bariting atelat mida, se ini etatabit iomi alil iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tentara enehe eele angu ana uuling ateing se, nehe ang naung bir arahak aulang iila muse, ana egahingvala ang naung iot Paulus at ila jaga hava omi mi maso. Angmuse tentara enehe eele angu ana iot aing varisik, senge ana vengbanang hula naba ebele ba Yahudi enehe ang naung hula ameang angu. ");
INSERT INTO beu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ini Paulus aing parta senge hula aing varisik ang muse, ana tentara angu adangtaaning hula, “Roma eparenta elamal-etahi angu eamulung se, nehe ening tatalang? Roma eparenta omimi angu Roma enehe nu ana parkara ening se, iini malekang ening tatalang metma adana? Iini aing bue-aing sabait ematura, ee, iini adang taaning ba ematura?” ");
INSERT INTO beu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Vengmeet aulang muse, tentara angu uuser-uuser ila enehe eele angu aing aalaping. Sengmuse ana vengbanang hula, “Nimang! Nehe anga di Roma eparenta omimi angu andi Roma enehe ba nu! Base, nimang hula naba ba ening metma adana?” ");
INSERT INTO beu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Vengmeet aulang muse, tentara enehe eele angu ana ila Paulus adangtaaning hula, “Aanake vengbanang hengi, Roma eparenta omimi angu, etabit aandi Roma enehe ba nu ee niang?” Angmuse Paulus ana ebalet hula, “Etabi! Nandi Roma enehe.” ");
INSERT INTO beu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Angmuse, tentara enehe eele angu mateng hula, “Nandi aulang. Ebili angu na bajar etatabit eele, senge nandi metma Roma enehe ening ba angu.” Paulus ana ebalet hula, “Naing anga na bae na iiba metma bajar niang. Aarunge niva ana naing vengajai muse, naing anga metma Roma enehe ening iila. Nimang di Roma angu enehe.” ");
INSERT INTO beu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ini vengmeet hula, Paulus di Roma enehe muse, tentara ang naung ini iava asorong, senge ini bae baranit aing varisik, bot bae adangtaaning niang iila. Tentara enehe eele angu ana uangmari, se ana Paulus aing parta tila, bot ana ateing hula, parenta elamal-etahi angu ana lakal iila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Emitobang muse, tentara enehe eele angu ana hula parkara e eela angu vengtaaning hengi. Angu ebele ana egahingvala ang naung ing gahing iot ila Yahudi eagama ekapala enehe eele ang naung, bot nehe eele ba biasat Yahudi eagama eparkara vengurus angu emangpi iaru, senge ini taing vengkumpul. Angmuse ana bot ing gahing iot ila Paulus erante angu vengahibul, senge at hoa nehe ang naung emangpi iapangaadang mi. ");
INSERT INTO beu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ila parkara vengurus emana ang mi muse, ini Paulus aing gahing ot ava vengeebang. Angmuse ana kapala agama ang naung emangpi iuuling seng muse ana mateng hula, “Kaku naung serang naung! Na anga mi tahi anga nomi anga hamulang. Lahatala ateing hula, kiki kalokal mi ila anga vengjehi anga nomi angu hamulang.” ");
INSERT INTO beu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Vengmeet Paulus ana mateng aulang muse, Ananias ba, agama Yahudi ebuangvala ang naung ekapala angu, alil etatabi. Angmuse nehe ba Paulus abung tahi ang naung Ananias ana ing parentat hula, “Paulus ai angu vengbue!” ");
INSERT INTO beu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Angmuse Paulus ana Ananias ebalet hula, “Eningse Lahatala Ana bale aai angu vengbue. Aaing angu nehe biasa, aaing emenghula ludung ba eamotaoa angu nehe uhavede cet ening ahiba angu edadenang, aarunge eomi mi angu nanaka adang ening amusing iila angu edadenang. Aana anga mi mihit Lahatala ekarajang vengbalenta aarunge eeomi angu jasi. Aana hula naing hukung pihada elamal-etahi angu eamulung. Aarunge aaing ba hada elamal-etahi angu lakal, se aana ing gahing iot naing bue angu ebele.” ");
INSERT INTO beu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Paulus ana mateng aulang angu vengmee muse, nehe ba angmi angu ehapat hula, “Ee! Aaing bae bisat ni agama Yahudi ebuangvala ang naung ekapala anga at mateng aulang niang!” ");
INSERT INTO beu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Angmuse Paulaus ana ebalet hula, “Hula aulangse na iing aada. Se na bae ateing niang hula, aing angu pi agama Yahudi ebuangvala angu ekapala niang angu ebele. Etabi, Lahatala Esurat hamulang angu nehe hurak iilat hula, ꞌIini ekang hur jasi vengbanang metma iinehe eele ekapala ang naung iadana ekang.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","Paulus ana uuling ateingse nehe ba mihit agama eparkara veng urus ang naung, ini taing paul baang aaru. Iiba angu baang Saduki ba iomi vengaanamang hula, nehe aamina bae bale aabeta niang angu eamulung. Ing di bot iomi vengaanamang hula, Lahatala Egahing vala sorga mi, bae ue niang. Bot taang-taang mi angu roh bae ue niang. Iiba angu baang Farisi ba iomi vengaanamang hula, eningse Lahatala Ana nehe aamina tila ang naung ening bale aabeta angu eamulung. Ing di bot iomi vengaanamang hula, taang-taang mi angu roh ang nuang ue, bot Lahatala Egahingvala sorgami ang naung di ue. Angmuse Paulus ana mateng amal aelet vengbanang hula, “Kaku naung! Iing emangpi ateing hula, naing anga, Farisi enehe. Angase iini hula naing hukung, se na nomi vengaanamang hula, ening se Lahatala Ana nehe aamina ening bale aabeta angu ebele.” Uanguveng Paulus ana mateng aulang muse, Farisi enehe bot Saduki enehe ang naung ini iai metma tadana, angu ebele ini bae tominu niang iila. Angmuse ini tatarat baang aaru. ");
INSERT INTO beu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Base, nehe ang naung ini iai metma tadana angu ba oorang-dumung etatabi. Angmuse, nehe Farisi eguru inang aaeedeng tahi, senge mateng Paulus aing vengeebang hula, “Nehe anga bae ahala niang! Roh, niangse Lahatala Egahingvala sorga mi ba oma hoa at mateng iila!” ");
INSERT INTO beu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Guru ang naung mateng aulang iila, aarunge ini iai metma tadana angu mang taang maveng eele, angu ba tentara enehe eele angu uangmari. Ana vengomit hula, misavaka ini Paulus aing marasit ameang. Angu ebele ana egahingvala ang naung ing gahing iot hela senge Paulus at ila jaga hava omi mi maso. ");
INSERT INTO beu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ebirkua muse, Mutu Yesus Ana hoa Ava metma Paulus etubing. Yesus Ana Paulus at mateng omi ening aanamang hula, “Paulus! Ekang uuangmari ekang! Emangpi ba metma Nadana angu aana metma Yerusalem enehe ang naung veng iat hubai tila. Base eningse aana malekang Roma mi ila senge, emangpi ba metma Nadana angu aana metma Roma enehe ang naung di veng iat hubai emenghula aana metma Yerusalem enehe ang naung veng iat hubai tila angu edadenang.” ");
INSERT INTO beu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Emitobang kukuaveng muse, Yahudi enehe inang aributa alehil angu itominu senge Paulus ameang. Ini iava sumpat hula, “Ni bae Paulus angu ameang jedung se, ni bae niiat naadang-jalna niang.” ");
INSERT INTO beu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ini iava sumpat aulang sengmuse, ini ila agama ekapala enehe eele bot hada eboma ang naung iat hubait hula, “Nimang iimal! Ni niava sumpa tilat hula, ni bae Paulus angu ameang jedung se, ni niat bae naadang-jalna niang. ");
INSERT INTO beu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Base ni banang alang: Nimang iimal iini malekang ila tentara enehe eele angu apangadang mi, senge abanang Paulus at agama eparkara vengurus emana angu mi ila. Ening emenghula nimang iimal iini hula eparkara angu bale metma veng adangtaaning angu edadenang. Eningse ni via hahamami ing pakang, senge ni ameang.” ");
INSERT INTO beu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Aarunge ini itominut aulang angu, Paulus edi jangu oal mehal nu ana vengmee muse, ana bihit jaga hava mi ila metma Paulus at hubai. ");
INSERT INTO beu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Vaal angu esarenta angu vengmee sengmuse, Paulus ana tentara nu earut hula, “Aana uuser vaal anga at eenehe eele angu ebele ila. Ana hula na nu metma eenehe eele angu veng at hubai.” ");
INSERT INTO beu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Angmuse tentara angu ana vaal angu at enehe eele angu ebele ila. Angmuse ana vengbanang hula, “Nimang! Paulus ba pi aing tahang angu nabanang senge not vaal anga at hoa nimang apangaadangmi. Ana hula na nu metma veng aat hubai.” ");
INSERT INTO beu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tentara enehe eele angu ana vaal angu atang vengpina sengmuse oleve ila mana osing nu mi senge ana adangtaaning hula, “Aana hula naba ba metma veng nat hubai?” ");
INSERT INTO beu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Angmuse vaal angu ana at hubait hula, “Yahudi enehe inang aaedeng itominu tila senge hula Paulus angu ameang. Ini hula hoa nimang aabanang senge tobang se, nimang aana Paulus at nehe ba agama eparkara vengurus angu ebele ila. Ini ibabakeng hula Paulus eparkara angu bale metma veng adangtaaning. ");
INSERT INTO beu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Aarunge nimang aana ekang iomi angu eamulung ekang. Eningse inang aributa alehil via mi nimang eerombongan angu pakang tahi, senge ini hula Paulus angu ameang. Se ini iava sumpa tilat hula, ini bae Paulus angu ameang jedung ang se, ini bae iat nadang-jalna niang angu ebele. Angase ing emangpi iava vengharaka tila. Aarunge nimang eehur vengbanang tatalang angu ba, ini jedung ading sehi.” ");
INSERT INTO beu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Vaal ang esarenta angu vengmee muse, tentara enehe eele angu ana at hubait hula, “Aana ekang nehe iiba at mateng hula, aana hoa na angu metma veng nat hubai tila ekang.” Mateng aulang seng muse, ana vaal angu ot ila. ");
INSERT INTO beu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Seng angmuse, tentara enehe eele angu ana tentara aaru iaru. Ana oleve ing parentat hula, “Tentara inang ratu aaru, tentara ba kuda taang angu inang ari bititu, bot tentara ba aba pina angu, inang ratu aaru angu iini vengharaka. Vede kua anga oda turinu se, iini lamal bendar Kaisarea mi ila. ");
INSERT INTO beu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Iini bot kuda nu vengharakat senge Paulus ana taang mihi. Iini malekang aing jaga bot at lamal aaung-aaung ila gubernur Feliks apangaadang mi.” ");
INSERT INTO beu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Seng angmuse, ana surat nu hurak metma Gubernur Feliks enang hula, alang: ");
INSERT INTO beu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nimang gubernur Feliks ba eele balolu. Na aaing aada, naing ba nene Klaudius Lisias. ");
INSERT INTO beu_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nehe ba angase na hula aing panatut hoa anga, ene Paulus. Yahudi enehe ang naung ini adoit aing pina tila, bot niantase ini ameang. Aarunge uanguveng angu naing bot negahingvala ang naung nimampi ila sengmuse, ni Yahudi enehe ang naung iatang mi aing ening lohi. Seng angmuse, na ateing se hula, Roma eparenta omimi angu Paulus di Roma enehe. ");
INSERT INTO beu_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Na hula valaping ateing, etatalang ba Yahudi enehe ang naung hula ameang angu. Angu ebele, na at ila Yahudi eagama eparkara vengurus emana angu mi. ");
INSERT INTO beu_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Aarunge Yahudi enehe ang naung ini bae eahalang iiba harak niang. Se etabit Paulus ana bae jasi iiba ening niang angu ebele. Base nehe anga bae bisat bui maso niang, bot hukung aamina di bae bisat metma aing taang mea niang. Nehe ba agama eparkara vengurus emana mi ang naung ini iai metma tadanat etatabi, metma iagama evia-via ba bae hama niang angu adana. Angu ebele ba nehe anga na at bale jaga ehava mi ila. ");
INSERT INTO beu_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Aarunge emitobang muse, na vengmee se hula, Yahudi enehe ang naung iiba itominu tila senge ameang. Base na parenta senge nehe anga at ila metma nimang aapangaadang mi. Yahudi enehe ang naung hula parkara ening metma nehe anga aing lavang angu, eningse na ing parenta senge ini hoa nimang aapangaadang mi aaing harak. Naba ba Yahudi enehe ang naung ini hula vengbanang metma Paulus aing ening ahala angu, eningse nimang aana vengmee. Nesurat angu, ila ang vengjehi.” ");
INSERT INTO beu_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Angmuse, tentara emangpi ba iava vengharaka tila ang naung ini inehe eele angu eparenta angu at lamal. Kua angu di, ini Paulus at ila bendar nu ene, Antipatris angu mi. ");
INSERT INTO beu_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Emi tobang muse, tentara ba kuda taang ang naung ini Paulus at ila bendar Kaisarea mi. Aarunge tentara ba aabeung ang naung, bale Yerusalem mi ila. ");
INSERT INTO beu_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ini ila Kaisarea mi muse, surat angu ini baning ila metma gubernur Feliks enang bot Paulus aing metma atang mi abaang. ");
INSERT INTO beu_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Surat angu basat sengmuse, Gubernur Feliks ana Paulus adangtaaning hula, “Aaing anga propinsi taang enehe?” Angmuse Paulus ana ebalet hula, “Naing anga, propinsi Kilikia enehe.” ");
INSERT INTO beu_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Angmuse gubernur angu mateng hula, “Naing ba anga mi parenta pina. Base naing ba eningse eeparkara anga vengurus. Aarunge nehe ba hula aat parkara angu pi jedung iading ini hoa anga mi senge, na eeparkara angu vengurus.” Angmuse ana tentara ang naung ing gahing iot Paulus aing tahang metma gubernur ehava eele angu omimi, hava ba tura raja Herodes ana bakung atahing iila angu. ");
INSERT INTO beu_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ved iising lakal muse, Yahudi enehe ba hula Paulus at parkara ang naung, ini hoa bendar Kaisarea mi. Inang aaedeng ba hoa angu, Ananias ba agama Yahudi ebuangvala ang naung ekapala angu, bot Yahudi enehe eele aabeung ang naung imampi. Ini nehe aabeung di nu at hoa, ene Tertulus. Aing angu hur adang. Angu ebele ini aing metma ihurvala ening senge Paulus aing lavang. ");
INSERT INTO beu_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Nehe ang naung emangpi taing vengkumpul mana ba parkara vengurus angu mi tila muse, Gubernur Feliks ana gahing hula Paulus at maso. Angmuse Tertulus ana aloming tahi, senge hula mateng metma Paulus adana aing ening ahala. Tertulus ana Gubernur Feliks at mateng hula, “Nimang gubernur! Nimang aana anga mi parenta pinat luung iila, angu ebele uukur aaung oomimi angu, naba ba aaung angu nimang metma ma ninang. Bot nimang di na toang ening aaung-hama metma niadana tila, angu ebele ning nehe Yahudi ang naung aabeta tening-rama tila. Base ooras anga ni hula banang tarimakasi toang-toang metma nimang gubernur enang. Se nehe iiba bot bae aaung-hama toang aulang angu ening, emenghula nimang edadenang niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Aarunge ekang nimang eooras toang bia ekang, na aabanang senge aana ning venghelet kabingdena hengi. Se aaingba etatabit oomi aaung angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Alang, nimang. Ning Yahudi ang naung niomi eamulung se, Paulus anga, nehe ba biasa bir arahak. Ana biasa ning Yahudi ni agama angu lavang, bot taang-taang mi angu ana ni hada angu ening ajasing. Mana taang ba ana ila mi angse, ana nehe omi taang base nehe Yahudi ang naung ini malekang itaat parkara. Aing anga ana bot biasa nehe omi taang senge, nehe nu Nasaret mi agama hiba nu baning hoa, ni biasat vengbanang hula ꞌAgama Nasaraniꞌ angu eamulung. ");
INSERT INTO beu_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nehe anga ana via valaping hula, Lahatala Ehava hamulang angu ening akarita, angu ebele nehe ba bae eagama veng niang ang naung ana iat Lahatala Ehava hamulang angu omi mi masot mida. Ana ening aulang angu ebele ni adoit aing pina. Niomi eamulung se, ni hula aing hukung nihada evia-via angu ba eamulung. ");
INSERT INTO beu_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Aarunge tentara enehe eele ene Lisias angu, ana hoa niatang mi Paulus aing medi. ");
INSERT INTO beu_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Angmuse Lisias ana parentat hula, nehe iiba hula Paulus at parkara ening se, ini malekang hoa Kaisarea mi nimang aapangadang mi hengi. Eomi hula, parkara anga malekang nimang gubernur ba vengurus. Base angase, ni hoa anga mi senge nimang ba parkara anga vengurus. Eningse nimang aana ateing hula, emangpi ba ni vengbanang anga etabi. Ne mateng angu ila ang mi jehi.” ");
INSERT INTO beu_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tertulus ana mateng aulang sengmuse, nehe Yahudi aabeung ang naung di ini mateng Paulus aing ening ahala, bot naba ba Tertulus ana vengbanang angu ini eetabit vengbanang. ");
INSERT INTO beu_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Angmuse gubernur ana atang beok Paulus ot tahi senge ana mateng ava vengebang. Angmuse Paulus ana aloming tahi senge mateng hula, “Nimang gubernur! Nimang aana ning nehe Yahudi ang naung ebangsa anga mi parenta pinat, luung iila, base ning ba nehe Yahudi nilamal-nitahi anga mi angu nimang aana manggaratit etatabi tila. Angu ebele, nimang aapangaadang mi mateng nava vengeebang angu, na rasa se nomi mang sanang. ");
INSERT INTO beu_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Oma mietang arinu belta aalu evaila angu, na Yerusalem mi ila senge na hula Lahatala Ehava hamulang mi sambajang bot sadaka metma Lahatala enang. Nehe ba uanguveng namulung sambajang angu nimang aana bisa iadangtaaning. ");
INSERT INTO beu_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Lahatala Ehava hamulang mi angu, na bae nehe iiba iat niai metma tadana niang. Bot nehe Yahudi ehava hamulang ang naung mi di na bae nehe omi taang senge bir arahak niang. Yerusalem mi di aulang, na bae jasi iiba ening niang. ");
INSERT INTO beu_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Aarunge angase, nehe anga naung hula naing ening ahala. Naba ba ini vengbanang angu eela iiba bae ue niang, bot ebukti di vengniang. ");
INSERT INTO beu_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Alang, nimang gubernur. Na malekang na nu anga metma nimang aapangaadang mi vengbanang tarang hengi. Na ue “Mutu Yesus Evia Aabetang” angu, eamulung. Aarunge ini iomi hula Mutu Yesus Evia Aabetang angu bae aaung niang. Base na sambajang Lahatala Abanang, emenghula nidat-nimang ang naung sambajang Abanang angu edadenang. Nandi boma Musa eparenta evia-via ang naung emangpi eamulung, bot naba ba Lahatala Eetvala tura ang naung ini hurak metma pi mea tila angu na etatabit nomi metma vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Lahatala angu ba na nomi metma Aing vengmeat hula, eningse Ana nehe ba aaung ening bot jasi ening ba aamina tila ang naung emangpi ing ening bale aabeta. Nehe ang naung angase ae anga mi tahi senge hula naing lavang anga di emangpi iomi angu aulang. ");
INSERT INTO beu_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Angu ebele ba na nava vengjagat etatabi, senge na aabetat hamulang Lahatala Apangaadang mi bot nehe emangpi iapangaadang mi. Ening aulang senge nehe iiba bae bisat naing ening ahala niang. ");
INSERT INTO beu_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Mitung aaeedeng na Israel eabang eahalang karajang, angmuse na bot bale Yerusalem mi ila. Bale Yerusalem mi ila sengmuse, seeng ba nehe ang naung kumpul senge hula metma ni nehe ba aabetat susa ang naung ioangmoling angu, na baning hoa. Senge na bot hula ila Lahatala Ehava hamulang mi sambajang, bot hula angmi sadaka metma Lahatala Enang. ");
INSERT INTO beu_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Na Lahatala Ehava hamulang mi sadaka metma Lahatala Enang sehi se, ini naing harak. Uanguveng angu nihada ba na nava ening ahamulang angu na ening sengmuse, ini hoa naing harak. Nehe iiba bae angmi niang, bot nehe iiba bae angmi bir arahak di niang. ");
INSERT INTO beu_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Aarunge, nehe Yahudi inang aaedeng ba propinsi Asia mi hoa senge hula ila sambajang angu ba ue angmi. Base angase ini hula via valaping naing ening ahala se, ing angu ba malekang hoa angami hengi senge nat parkara. Bae nimang iimal Yahudi enehe eele anga niang! ");
INSERT INTO beu_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Aarunge nehe angu naung bae hoa niang. Aulang ba kilange nehe Yahudi anga naung ba vengbanang hula naba ahalang ba na ening iila. Tura ini agama eparkara vengurus emana mi nadangtaaning angu, ini bae neahalang nu harak di niang. ");
INSERT INTO beu_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Aarunge hur kokal nu kolang na vengbanang angu ba ening iot iomi alil, bot bae nat sanang niang. Uanguveng angu na namal aelet mateng hula, “Iini hula naing hukung angu, na nomi vengaanamang hula, eningse Lahatala Ana nehe aamina ening bale aabeta angu ebele!ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Paulus mateng ila ang vengjehi muse, gubernur Feliks ana ꞌMutu Yesus Evia Aabetangꞌ angu ateing toang iila, angmuse ana sidang angu vengtering senge mateng hula, “Na kumidan Lisias ot anga mi hoa, senge na esarenta vengmee hengi. Na atmateng sengiila se, na parkara anga vengputus.” ");
INSERT INTO beu_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Angmuse Gubernur ana tentara nu aing gahing ot Paulus aing tahang. Aarunge Gubernur ana parentat hula, Paulus aing ening lohit kabingdena, bot eserang ang naung di hoa aing vengbalenta se ekang ing larang ekang. ");
INSERT INTO beu_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Gubernur Feliks ejangu angu ene Drusila, aing angu Yahudi enehe. Ved aaedeng muse, ejangu oleve hula Paulus at mamateng. Angu ebele ana nehe ot Paulus at ibele hoa, ejangu oleve iapangaadang mi. Angmuse, via tatalang ba eamulung senge nehe omi metma Yesus Kristus Aing vengaanamang angu, Paulus ana metma oleve iat hubai. ");
INSERT INTO beu_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bot via tatalang ba eamulung senge nehe aabetat aaung-hama Lahatala Eomi angu eamulung, bot nehe ava vengjagat tatalang senge ekang ahalang ening ekang angu, ana metma oleve veng iat hubai. Paulus ana bot oleve iat hubait hula, ila por-burang evengtahi mi se, eningse Lahatala Ana nehe emangpi ing hukung. Feliks ana vengmeet aulang muse, ana uangmarit etatabi. Angmuse ana Paulus at mateng hula, “Paulus, aaung iila. Aaungba angami mea! Ooras aabeung senge na bot bale eearu.” ");
INSERT INTO beu_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Uanguveng angu, Feliks ana akal aalaping tatalang senge Paulus ana seeng metma ma enang, aulange ana Paulus aing ening lohi. Angu ba ana nehe ot Paulus at hoa alolang niang, senge ana at mateng angu. ");
INSERT INTO beu_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Aarunge Gubernur Feliks ana hula tatalang senge Yahudi enehe eele ang naung aing vengsanang, angu ebele Paulus eparkara angu ana bae uuser vengputus niang. Ana parkara angu vengtaimang ila mitung aaru. Seng angmuse, gubernur aabeung nu bot hoa Feliks aing telul. Ene Porkius Festus. Aarunge Feliks hula tatalang senge Yahudi enehe ang naung iomi metma aing vengsanang, angu ebele ini bui mi Paulus aing tahang tarus. ");
INSERT INTO beu_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Uanguveng angu, gubernur aabeung ba uhavede hoa ene Festus angu, ana ava asorong ila Kaisarea mi senge ana nehe parenta. Aarunge ana angumi mihit ved tue kolang, angmuse ana bot lamal milalut ila Yerusalem mi. ");
INSERT INTO beu_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Angumi, agama Yahudi ekapala enehe eele ang naung, bot nehe eele aabeung ang naung emangpi hoa aing harak, senge bot iava metma gubernur ba vea angu etubing. Taing harak angu Paulus eparkara angu ini vengmateng. ");
INSERT INTO beu_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ini banang hula, gubernur Festus ot ioangmoling senge Paulus at bale hoa Yerusalem mi. Ini vengtominu tilat aulang senge, hoa via mi se ini Paulus ameang. ");
INSERT INTO beu_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Aarunge gubernur ana ibalet hula, “Nimang iimal. Alang. Kilange ini jedung Kaisarea mi Paulus aing tahang hengi. Se nandi hula bale Kaisarea mi ila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Base, iinehe boma aaeedeng iini ing gahing senge iot parkara angu vengurus angu, ini nat hama-hamat Kaisarea mi ila. Senge etabit nehe anga ana ahalang iiba ening iila se, iini angmo mi at parkara ening. ");
INSERT INTO beu_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","7","Festus ana Yerusalem mi mihit oma ved arinu muse, ana bot bale Kaisarea mi ila. Ana bale ila Kaisarea mi muse, Yahudi enehe inang aaedeng amulung ila. Emitobang muse, gubernur Festus ana sidang buka senge hula parkara angu vengputus. Angmuse ana nehe parentat iot Paulus at masot mida apangaadang mi. Paulus ana masot mida Gubernur Festus apangaadang mi tahi muse, Yahudi enehe ang naung tahit Paulus aing goleng, seng angmuse ini ahalang toang-rae vengbanang metma adana. Aarunge ini bae ahalang eeela nu matubing di niang, bot ebukti di vengniang. ");
INSERT INTO beu_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Angmuse Paulus ana ava vengebang hula, “Nimang gubernur. Na bae jasi iiba ening di niang. Nandi bot bae na iiba ening metma ni agama Yahudi evia-via angu lavang niang. Bot na bae Lahatala Ehava hamulang angu ening akarita niang. Bot nandi bae na iiba ening metma Roma eparenta evia-via angu lavang di niang.” ");
INSERT INTO beu_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Aarunge gubernur hula tatalang senge Yahudi enehe ang naung iomi ening sanang, angu ebele ana Paulus adangtaaning hula, “Aana vengomi tatalang? Eeparkara anga na Yerusalem mi vengurus se, aana vengjali ee niang?” ");
INSERT INTO beu_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Vengmeet gubernur Festus ana taaning aulang muse, Paulus ana ebalet hula, “Nimang gubernur. Naing anga, Roma eparenta enehe. Bot Roma eparenta omimi angu, nimang gubernur ba malekang ne parkara anga vengurus metma evia-via angu eamulung, angase na ae aapangaadang mi tahi tila. Base, na neat bae Yerusalem mi ila senge, angmo mi ne parkara angu vengurus niang. Nimang aana eena ateing iilat hula, na bae ahalang iiba ening metma Yahudi enehe anga naung ing lavang niang. ");
INSERT INTO beu_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Base, etabit na ahalang ening metma Roma eparenta angu lavang ba hukung aamina angu metma nadana se, na tarima. Aarunge hula naba ba ini vengbanang angu bae etabi niang, se nehe iiba bae bisat naing metma nehe anga naung iatang mi abaang niang. Ini mang via valaping senge hula nameang. Base angase, nabanang ila bendar Roma mi raja eele Keser apangaadang mi senge nadangtaaning. Raja eele Keser angu ba ne parkara anga vengputus!” ");
INSERT INTO beu_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Vengmeet Paulus ana banang aulang muse, gubernur eserang naung ba parkara vengurus angu ana iat temaring. Seng angmuse, ana Paulus at hubait hula, “Aana banang hula ila Keser apangaadang mi senge aadangtaaning angu ebele, aana malekang bendar Roma mi ila.” Mateng aulang sengmuse, gubernur Festus ana sidang angu vengtering. ");
INSERT INTO beu_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Seng angmuse, Yahudi enehe ang naung iraja ene Agripa bot ekaku jangu kiki ene Bernike angu oleve hoa Kaisarea mi. Oleve hula gubernur uhavede angu aing aada. ");
INSERT INTO beu_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ini raja Agripa bot Bernike oleve gubernur Festus iabung mihit vengtahang ved aaedeng. Minu adana, Festus ana Paulus eparkara angu metma raja Agripa bot Bernike oleve iat hubai. Ana vengbanang hula, “Nimang raja! Kaisarea mi anga, Feliks ana ae nehe nu aing tahang metma bui mi tila, ene Paulus. Gubernur Feliks ana bae eparkara angu vengputus jadi niang. ");
INSERT INTO beu_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na jedung Yerusalem mi sehi angu, Yahudi eagama ekapala enehe eele ang naung bot hada eboma ang naung hoa ahalang ba ini hula metma Paulus adana angu vengbanang. Angmuse ini banang hula not aing hukung ameang. ");
INSERT INTO beu_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Aarunge na iat hubait hula, ꞌRoma eparenta evia-via eamulung se, na malekang parkara angu veng adangtaaning hengi, senge ehukung angu metma aing taang mea. Nehe ba itat parkara ang naung malekang iapang metma itadana hengi. Na hula Yahudi enehe ang naung ing vengmee, naba ahalang ba ini vengbanang metma adana. Bot andi malekang mateng ava vengeebang hengi, sengiila se, na parkara angu vengputus, bot hukung naba ba na metma aing taang mea.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Angmuse na bale Kaisarea mi hoa angu, Yahudi enehe inang aaedeng namulung hoa anga mi. Emitobang muse, na parkara angu buka. Na gahing iot Paulus at hoa napangaadang mi, aulang senge parkara anga eeela angu na vengmee. ");
INSERT INTO beu_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Angmuse, Yahudi enehe ang naung tahi senge hula Paulus eahalang ang naung matubing. Aarunge naba ba na vengnomit hula eningse ini vengbanang metma Paulus adana angu, ini bae vengbanang niang. ");
INSERT INTO beu_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Yahudi enehe ang naung ini iomi tebelung Paulus aing lavang angu, metma iagama elamal-etahi bot metma nehe nu ene Yesus angu adana. Yesus angu, aamina tila. Aarunge Paulus ana vengbanang hula, Yesus Ana bale aabeta tila. ");
INSERT INTO beu_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nomi iipi sehit hula tatalang senge parkara elamal-etahi angu na bisa ateing bot na bisa parkara angu vengurus. Angu ebele na Paulus adangtaaning, hula, ꞌTatalang, eeparkara anga na Yerusalem ba mi veng aadangtaaning se aana jali ee niang?ꞌ ");
INSERT INTO beu_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Aarunge Paulus ana ea. Angmuse Paulus ana banang hula ila Roma mi senge, Keser ba adangtaaning. Angu ebele na aing tahang, ila na ooras harak sengmuse na aing panatut Roma mi ila.” ");
INSERT INTO beu_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Vengmeet aulang muse, raja Agripa ana Festus at mateng hula, “Aulang se, naing ba nena nehe angu aing vengmee hengi.” Angmuse Festus ana ebalet hula, “Tobang se nimang ba eena nehe angu aing vengmee.” ");
INSERT INTO beu_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Emitobang muse, gubernur Festus ana vengator aulange raja Agripa ana Paulus emateng angu vengmee. Ana vengator senge nehe toang Paulus aing vengmee. Angu ebele tentara ang naung enehe eele, bot bendar Kaisarea enehe eele ang naung emangpi hoa. Senge raja Agripa bot Bernike oleve di raja epakiang angu pina sengmuse ini hoa parkara vengurus emana angu mi maso. Angmuse nehe emangpi oleve ing sambut bot ing aada. Ing emangpi taing vengmihi tila muse, gubernur ana gahing Paulus at maso. ");
INSERT INTO beu_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ini Paulus at maso sengmuse, gubernur Festus ana mateng hula, “Raja Agripa, nimang iimal, bot iing anga naung emangpi na iing aada. Nehe anga ene Paulus. Yahudi ekapala ba Yerusalem mi bot Yahudi enehe ang naung ini anga mi at parkara. Ini nebele hoa sengila ba aru-moring naing paksat vengbanang hula, nehe anga ekang aing vengkilang ana aabeta ekang. ");
INSERT INTO beu_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Angu ebele na adangtaaning iila, aarunge eahalang ba hula hukung aamina metma aing taang mea angu, na bae iiba harak niang. Aarunge ana banang hula ila Roma mi senge eahalang ba nehe ang naung vengbanang metma adana angu veng adangtaaning, angu ebele na malekang aing panatut Roma mi ila. ");
INSERT INTO beu_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","27","Na aing panatu se, na malekang surat nu hurak eahalang angu vengbanang metma Keser enang. Aarunge angase naba ba na malekang hurak metma raja eele Keser angu enang? Angu ebele na nimang iimal iing emangpi iing kumpul, senge iini Paulus aing vengmee. Aing vengmeet seng angse na banang nimang raja Agripa bisa via metma netubing, aulange naba ba na hurak metma raja eele Keser enang angu, ana bisa ateing. Parkara anga na panatut ila metma Keser enang, aarunge nehe anga eahalang ba nehe ang naung vengbanang metma adana angu, na bae metma Keser veng at hubai niangse, nomi bae sanang niang. Nemateng angu ila angmi jehi.” ");
INSERT INTO beu_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Angmuse raja Agripa ana Paulus aing gahing hula, “Angase, aana mateng aava vengeebang hengi.” Angu ebele Paulus ana atang ohi, sengmuse ana mateng hula, ");
INSERT INTO beu_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nimang raja Agripa ba na aaing aada. Nomi etatabit sanang, se aana naing vengkilang senge, na emangpi ba Yahudi enehe anga naung ini vengbanang metma nadana senge hula naing ening ahala angu, angase na mateng nava vengebang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Na ateing se, ning Yahudi nihada evia-via bot na emangpi ba ni veng niai metma tadana angu aana etatabit manggarati. Base, na banang nimang aana naing venghele se aaing ba oomi etatabit aaung angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Na jedung kuar sehi mi, nehe navomung-napahang iila senge aabetat ning Yahudi nihada angu ba eamulung. Ehalomang angu na neaabang mi, sengmuse na bot hoa Yerusalem mi senge taang sakolat maveng. Yahudi enehe ba ae Yerusalem mi ang naung ne aabetang elamal-etahi angu ateing, bot ini etatabit napang ateing. ");
INSERT INTO beu_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ini napang ateing luung iila, angu ebele agama enehe eele ang naung vengjali se, ini nelamal-netahi angu vengsarentat metma nimang raja di veng aat hubai. Naing anga di, Farisi enehe. Nehe emangpi ateing se hula, ning Farisi enehe anga naung ba, Yahudi eagama elamal-etahi angu etatabit emangpi eamulung. ");
INSERT INTO beu_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","8","Naing bot Israel enehe ba lelang arinu belta aalu mi angu, naba ba Lahatala Ana vengpalai angu ni jedung ading sehi. Palai angu, turang jamang mi Ana metma tidat-timang ang naung veng iat hubai tila. Angu ebele ila anga vengjehi anga, ning emangpi sambajang kua-jala, senge Lahatala Ana epalai angu ening akanap. Palai angu Ana vengbanang hula, eningse nehe ba aamina tila ang naung, Ana ening bale aabeta. Nimang raja Agripa ba na aaing aada. Na nomi vengaanamang hula, nehe aamina tila di, eningse Lahatala Ana ening bale aabeta, angu ebele ini parkara ening metma nadana. Na iadaangtaaning hula: etatalang ba iihahama mi angu nehe iiba bae iat iomi vengaanamang niang hula, eningse Lahatala Ana bae bisat nehe aamina ening bale aabeta niang angu? Etabi! Lahatala Ana nehe aamina ening bale aabeta. ");
INSERT INTO beu_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Tura angu na etatabit vengnomit hula malekang susa-lala angu ening metma nehe ba Yesus Nasaret enehe angu eamulung ang naung iadana hengi. ");
INSERT INTO beu_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","11","Uanguveng angu, Yahudi eagama ekapala enehe eele ang naung ini surat kuasa metma manenang, senge na ila nehe ba iomi Yesus vengaanamang ba taang-taang mi ang naung ing ening susa. Na iadoi seng angse na iat hoa Yerusalem mi, senge ing metma bui mi maso. Hukung aamina ba nehe vengputus angu nandi nemeng-ajali senge, nehe metma iadana. Na bot ila nehe Yahudi ehava hamulang ang naung mi maso, senge ing ening susa-lala. Nomi etatabit tutung metma iadana angu ebele, na hula ing paksat iot naba ba ini iomi metma vengaanamang iila angu metma iamota oat mea. Bendar aabeung ba por aabeung taang ang naung di na ila mi senge nehe ba iomi metma Mutu Yesus vengaanamang ang naung na hula iaterit ing pina.” ");
INSERT INTO beu_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Paulus ana taang hamuat mateng hula, “Minu adana, Yahudi eagama ekapala enehe eele ang naung ini surat kuasa metma manenang, senge na ila bendar Damsik mi nehe ba iomi Mutu Yesus vengaanamang ang naung iadoit ing pina. Angmuse na ila. ");
INSERT INTO beu_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nimang raja Agripa! Ni lamal ila angmuse, ved hahama ni jedung via hahamat lamal sehi se, mibaroti se, huring-jara eele nu burang mi hela naing vengbaa bot ne serang ang naung di ing vengbaa. ");
INSERT INTO beu_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ning emangpi baat meke mi hela. Angmuse na vengmee se nehe amal nu Ibrani ehur metma nat mateng hula, ꞌSaulus, Saulus! Etatalang ba aana Naing ening susa-lalat alang anga? Aana Naing ening susa-lalat alang anga, eningse nehe aandi aaing ening susa-lalat aulang. ");
INSERT INTO beu_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nehe amal angu na vengmee, aarunge na bae uuling nehe angu ateing niang. Base na taaning hula, ꞌNimang, Aaing ba mateng anga nuba?ꞌ Angmuse nehe amal angu nehur ang ebalet hula, ꞌNaing anga Yesus, ba angase aana Naing ening susa-lala angu. ");
INSERT INTO beu_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Saul! Aaung ba tahi! Na Nava metma eetubing senge Na aaing metma Ne balentavala ening. Naba ba vede ved anga aana uuling ateing anga, aana malekang ila metma nehe emangpi veng iat hubai. Na aabeung ang naung eningse Na taang metma eetubing maveng, senge aana ila metma nehe ang naung emangpi veng iat hubai. ");
INSERT INTO beu_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Susa-lala ba eapapahing angu eningse aana malekang harak. Nehe ba hula susa-lala angu ening metma aadana angu, Yahudi enehe ang naung, bot nehe aabeung di susa-lala angu metma aadana dise, Na bae aaing bia niang, aarunge Na kilang aat toang pina. Etabi! Na aaing gahing nehe ba bae Yahudi enehe niang ang naung ibele ila. ");
INSERT INTO beu_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Aana ila senge ieng angu buka, aulange ini bisa uuling jara angu ateing sengila ba jara angu omimi aabeta, bot manggarati, senge iabetang elamal-etahi ba jasi-ahala ang naung ini vengbaroti. Sengila ba aana malekang aabetang evia aaung-hama angu metma itubing. Aana malekang ing ening lohit metma setang ang naung inehe eele ekavasa angu eahalang, senge ing metma Lahatala Enehe ening. Ening aulang senge, Lahatala Ana iahalang-iavali ang naung emangpi vengaahi. Aulang senge ing di metma Lahatala Enehe ening, emenghula nehe aabeung ba Lahatala Ana ing vengtalail iila angu edadenang, se ini iomi metma Naing vengaanamang angu ebele.ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Paulus ana mateng taang hamuat hula, “Nimang raja. Base, karajang ba Lahatala Ana sorga mi vengbanang at hela metma manenang iila angu na tarima, sengmuse na at lamal. Ila anga vengjehi anga, na bae nora vengholong kabingdena di niang, aarunge na mang at lamal tarus. ");
INSERT INTO beu_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ehalomang angu Yesus Evia Aabetang angu na metma Damsik mi Yahudi enehe ang naung veng iat hubai. Seng angmuse, na hoa Yerusalem mi, bot propinsi Yudea mi Yahudi enehe ang naung di ing emangpi metma veng iat hubai. Seng angmuse, na bot lamal nehe ba bae Yahudi enehe niang ang naung di iaabang ang naung migoleng. Ing emangpi angu di na metma veng iatmateng tarang, aulange iaabetang elamal-etahi ba jasi-ahala angu ini malekang vengbaroti, sengila ba iava metma Lahatala enang, senge ini aaung-hama anguba vengkarajang, aulange metma nehe etubing hula, etatabit ini iahalang-iavali ang naung vengbaroti tila. ");
INSERT INTO beu_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Na ening aulang angu ebele, Yahudi enehe ba Yerusalem mi ang naung ini Lahatala Ehava hamulang mi nadoi, senge ini hula nameang. ");
INSERT INTO beu_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Aarunge Lahatala Ana noang moling, angu ebele ila anga vengjehi anga na jedung aabeta sehi, senge na ae anga mi tahi, bot na emangpi ba metma Yesus adana angu metma nehe kiki-eele emangpi, veng iat hubai. Naba ba na vengbanang anga, emangpi turang mi boma Musa bot Lahatala Ehurvala tura ang naung ini vengbanang iilat hula, ");
INSERT INTO beu_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kristus angu, Nehe ba Lahatala Ana vengpalai tilat hula Aing gahing hoa angu. Aing angu, Ana malekang susa-lala angu harak, senge Ana aamina, aarunge seng angmuse, Aing ba nehe halomang Lahatala Ana Aing ening bale aabeta angu. Aing angu ba jara metma Yahudi enehe ang naung, bot bangsa aabeung ba por alolang taang ang naung inang.” ");
INSERT INTO beu_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulus ana jedung ekarajang angu vengmateng sehi se, Festus ana amal aelet ehur angu mi patait mateng hula, “Ee, Paulus! Aana buning iila. Aana na talalu toang ateing angu ba, ening eeomi angu kivir iila.” ");
INSERT INTO beu_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Aarunge Paulus ana ebalet hula, “Nimang gubernur ba na aaing aada. Na bae buning niang. Emangpi ba na metma veng iiat hubai anga etabi bot nomi tening mi kaluar. ");
INSERT INTO beu_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Naba ba na vengbanang anga, nimang raja Agripa aana etatabit ateing. Angu ebele na nimang raja aapangaadang mi baranit vengbanang tarang anga. Na ateing se, naba ba nehe ening metma Yesus adana anga naung emangpi nimang raja vengmee tila, se naba ba jadi tila angu, bae mana taimang mi niang angu ebele. Nehe toang uuling na angu ateing iila. ");
INSERT INTO beu_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Turang jamang mi Lahatala Ehurvala ang naung ini na anga vengbanang iila. Nimang raja, na aadangtaaning hula, nimang raja di omi metma hurvala ang naung imateng angu vengaanamang iila ee niang? Na vengnomit hula, nimang raja di oomi metma naba ba ini vengbanang angu vengaanamang iila.” ");
INSERT INTO beu_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Angmuse raja Agripa ana Paulus ehur angu mipatait vengbanang hula, “Ee! Paulus! Bae luung niangse, aana hula naing ening metma nehe omi Mutu Yesus vengaanamang ening iila!” ");
INSERT INTO beu_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Aarunge Paulus ana raja ebalet hula, “Alang, nimang. Na sambajang metma Lahatala veng abanang hula, uuser niang ba pati dise ba, bae nimang raja enangkolang niang, aarunge vede ved anga nehe ba ae nehur anga vengmee anga, ing emangpi metma Yesus Enehe ening, emenghula naing edadenang! Aarunge iing angu nehe ekang langi metma iia mi, emenghula naing edadenang ekang.” ");
INSERT INTO beu_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Paulus ana mateng aulang sengmuse, raja Agripa, ekaku Bernike oleve, bot gubernur Festus, bot nehe eele ang naung emangpi, ialoming tahit lamal kaluar hela, viaela mi. ");
INSERT INTO beu_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ini hela viaela mi tila muse, ini itat mateng hula, “Nehe anga ana bae na iiba ening ahala niang angu ebele, hukung aamina angu bae bisat aing vengbaa niang, bot bae aing metma bui mi maso niang.” ");
INSERT INTO beu_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Angmuse raja Agripa ana gubernur Festus at hubait hula, “Nehe anga ana banang iilat hula ila Roma mi senge eparkara angu vengputus. Ana bae ening aulang niangse, eparkara angu sengila bot, ana lohi tila.” ");
INSERT INTO beu_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Seng angmuse, gubernur Festus ana vengputus hula Paulus aing ot Roma mi ila raja eele Keser angu apangaadang mi senge, eparkara angu angmo mi vengputus. Angmuse Paulus bot nehe bui mi inang aaedeng angu ana ing metma tentara enehe eele nu ene Yulius angu atang mi abaang, senge ana iat propinsi Italia mi ila. Yulius angu, tentara ba raja eele Keser aing jaga angu enehe ba nu. ");
INSERT INTO beu_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Uanguveng angu, naing ba (Lukas) di Paulus iimal iat hama-hamat ila. Bot nehe nu, ene Aristarkus, aing angu bendar Tesalonika ba propinsi Makedonia mi angu enehe, andi iat hama-hamat ila. Ning emangpi kampal nu bendar Adramitium mi hoa angu hila. Kampal elamal angu mana toang ba propinsi Asia mi ang eoolol angu, eningse kampal angu mi teding. ");
INSERT INTO beu_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ni aalarit Kaisarea eahalang senge, emitobang muse, ni ila bendar Sidon mi. Yulius ana Paulus aing ening aaung-aaung, bot ana at hubait hula, ana bisa aadang taang hela senge eserang ang naung iuuling. Eomi hula, aulang senge naba ba kampal taang bae Paulus aing veng niang angu, eningse eserang ang naung ini metma ma enang. ");
INSERT INTO beu_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Seng angmuse, ning emangpi bot bale kampal hila senge aalari. Aarunge eenar etatabit eelet niapang oat hoa, anguba kampal angu niantase bae lamal niang. Angmuse ini kampal angu belo, senge Siprus por amulung aalari, aulange eenar ba niapang oat hoa angu venghabal. ");
INSERT INTO beu_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Angmuse, ni angmi aalarit propinsi Kilikia bot propinsi Pamfilia eomi oa angu mi, tang angu akahit ila. Ni aalarit ila bendar Mira ba Likia mi angu mi. Ila angu mi muse, ning emangpi hela kampal angu eahalang. ");
INSERT INTO beu_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tentara Yulius ana Mira mi kampal aabeung aalaping senge ni aalarit Italia mi ila angu. Angmuse ana kampal nu bendar Aleksandria mi hoa senge aalarit Italia mi ila angu harak. Angmuse ana ning emangpi niat kampal angu taang mida. ");
INSERT INTO beu_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ni aalarit eluung mietang aaedeng iila, aarunge kampal angu bae lamal aaung niang, se eenar etatabit eelet niapang oat hoa angu ebele. Ni aalarit etatabit pati, anguba niantase ila bendar Knidus abung. Aarunge eenar angu jedung boning eele sehi, base ni aalarit Kreta por adang ila, senge eenar eele angu venghabal. Aulang sengmuse, ni aming nu, ene Salmone angu lakal. ");
INSERT INTO beu_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ni Kreta por eadang amulung aalari angu etatabit susa senge ila aming angu lakal, angmuse ni ila mana nu ene oolol Aalus angu mi. Mana angu bendar Lasea abung. ");
INSERT INTO beu_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Angu mi, kampal emataros ang naung ini miarit kabingdena, se ini aalari angu etatabit luung iila, aarunge bae ila Italia mi jedung angu ebele. Uanguveng angu, nehe Yahudi ang naung ived eele Ahalang Vengaahi Harak angu ejol lakal iila. Ved eele ejol angu lakal iila base, evengbanang hula, ooras eenar eele, bot uumba eele ejol hoa iila. Angmuse kampal emataros ang naung ini itadang taaning hula, aalarit milalu, ee jedung. Vengmeet aulang muse, Paulus ana mateng hula, ");
INSERT INTO beu_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Nekaku naung. Na banang mateng kabingdena. Na ateing se hula pi aalarit milalu se, eningse pi susa toang harak, eningse kampal anga hola, naosing ang naung ue niang, bot eningse ping emangpi aamina.” ");
INSERT INTO beu_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Aarunge tentara enehe eele angu ana omi metma nehe ba uuling pina bot kampal emanaing angu ba vengaanamang, senge ana eat bae Paulus emateng angu venghele niang. Se ini vengiomit hula aalarit milalut ila bir angu eahalang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Esakang benang ba, oolol Aalus angu, ooras uumba eele se, kampal bae angu mi teding aaung niang. Angu ebele ing evengtoang vengjalit hula, ni aalarit milalu senge ila bendar Feniks mi teding. Ini vengiomit hula, eningse, ooras uumba eele angu, ning emangpi angu mi mihi. Bendar Feniks angu, Kreta por angu eoolol aalus, se oolol angu eenar eele ved baang oat hoa bot tang eoat hoa di, Kreta por angu venghabal, base uumba eele di bae ping harak niang. ");
INSERT INTO beu_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Eenar tang eoat aput balea-balea, angmuse ini vengiomit hula ini bisa eenar angu baning aalarit bendar Feniks mi ila. Angmuse ini itat mateng hula, “Anga eenar aaung iila. Base aaung ba pi aalari!” Angmuse ini livang abingi, bot aalal at mida, sengmuse ni aadang amulung aalari. ");
INSERT INTO beu_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","15","Aarunge ni bae aalarit luung di jedung se, mibaroti se aaribut eele hoa. (Ba nehe ene maveng hula, ꞌeenar ved danangoa mi aadang taang boning hoaꞌ), sengila ba ni kampal angu vengbaa. Kampal emataros ang naung ini bae kampal etiri angu belot jadi niang, angmuse ini mang vengkilang, senge kampal angu teding aaribut eele eboning angu eamulung. ");
INSERT INTO beu_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ni teding uumba angu eamulung aulang, ila por kiki nu ene, Kauda angu abung. Uanguveng angu, kampal esekoci angu jedung sar vengkobong, kampal ealap abung angu mi. Angmuse sekoci angu ini masiring etatabit susa senge at kampal taang mida. ");
INSERT INTO beu_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Sekoci angu ini at mida kampal taang iila muse, ini sar metma kampal eboa angu balaal migoleng, senge kampal angu ekang pehak ekang. Ini bot iuangmarit hula, misavaka uumba eele kampal angu at ila Afrika mi Sirtis ebahi patang angu taang mida patang mihi. Base ini livang at hela tang mi hele, senge kampal elamal angu ening apati. ");
INSERT INTO beu_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Aaribut eele tahi anguba uumba eele di ni kampal angu vengbaa. Base emitobang muse, kampal emataros ang naung ini kampal enaosing ang naung metma tang mi bia. ");
INSERT INTO beu_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Emietang aaru di, aaribut angu jedung boning sehi. Base ini taang iuangmarit maveng. Angu ebele ini bot kampal enaosing ang naung taang biat maveng, senge kampal angu ening avila. Kampal eperkakas ang naung di kampal emataros ang naung ini iatang ba metma ohit tang mi bia. ");
INSERT INTO beu_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kua-jala aaribut eele, bot bano kaana pusi angu bae barintit kabingdena di niang ila ved aaedeng, angu ebele ni bae uuling ved, bot iid iiba ateing niang. Ning emangpi niomi bae na iiba vengaanamang niang iila, bot ni vengniomit hula, eningse nehe iiba bae nioang moling niang base ni mang aamina anguba vengbaing. ");
INSERT INTO beu_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ni bae na iiba adang di niang, ved aaedeng iila. Angu ebele Paulus ana ing emangpi iaru, angmuse ana ihahama mi tahi senge iat mateng hula, “Kaku naung! Iini nemateng angu eamulung senge, pi bae aalarit oolol Aalus angu eahalang niang angse, pi bae susa toang harak alang niang, bot bae na iiba bia niang. ");
INSERT INTO beu_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Aarunge angase, na iing emangpi iiabanang senge iini iiomi angu ening adia-adia. Eningse pi kampal anga ba jasi. Aarunge ekang iiuangmari ekang, se nehe iiba bae aamina niang angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Vede kua angu Lahatala ba na aing somba, bot Ana naing metma Enehe ening angu Ana Egahingvala nu gahing nebele hoa. ");
INSERT INTO beu_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Angmuse ana nat mateng hula, ꞌPaulus! Ekang uuangmari ekang! Eningse aana malekang ila Roma mi raja eele Keser angu apangaadang mi senge eeparkara angu vengurus. Lahatala Ana omi aaung metma aadana, angu ebele nehe ba ae kampal anga taang anga naung di emangpi Lahatala Ana ing ening aabeta.ꞌ ");
INSERT INTO beu_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Base kaku naung, iini ekang iiomi susa ekang. Na etatabit nomi metma Lahatala angu vengaanamang hula, naba ba vede birkua Ana metma veng nat hubai tila angu, eningse Ana malekang eamulung ening aulang. ");
INSERT INTO beu_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Aarunge kampal anga eningse ila por nu angu taang patang.” ");
INSERT INTO beu_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Uanguveng angu, Adria etang angu mi aaribut eele euumba angu ni kampal anga bue angu ba, ni teding lamal mietang arinu belta buta tila. Aarunge oma tereng hahama muse, kampal emataros ang naung ini vengiomit hula, ni aadang abung iila. ");
INSERT INTO beu_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Angmuse ini sar metma var vengkobong alolang hela, senge tang ekura angu ateing. Sar angu ini venguukur se ap ari aaru. Kampal angu lamal taang kabingdena maveng muse, ini bot bale venguukur se, tang ekura angu ap arinu belta iising. ");
INSERT INTO beu_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ing emangpi iuuangmarit hula, misavaka se kampal angu oma mida var eele taang patang, angu ebele ini livang buta metma kampal eaalap oa angmi alolang hela. Angmuse ning emangpi niomi metma vengmeat hula, aaung ba uuser birjala. ");
INSERT INTO beu_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Aarunge kampal emataros ang naung ini itominu, senge hula taimang-taimang bihit kampal angu eahalang. Base ini sekoci angu at hela, senge ening emenghula ini livang metma kampal etiri oat alolang hela angu edadenang. ");
INSERT INTO beu_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Aarunge Paulus ana tentara enehe eele angu bot tentara ang naung veng iat hubait hula, “Kampal emataros ang naung ini bae kampal anga taang mihi niang angse, eningse iing emangpi aamina.” ");
INSERT INTO beu_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Paulus ana mateng aulang angu vengmee muse, tentara ang naung ini sekoci esar angu patait asia, senge vengkilang sekoci angu teding ila. Base kampal emataros ang naung ini bae bihi niang iila. ");
INSERT INTO beu_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Bir hula jala muse, Paulus ana nehe ang naung emangpi iasenang hula iot naadang. Paulus ana mateng hula, “Mi ong aaru tila anga, pi mang vengbaing, bot pi bae na iiba adang di niang. ");
INSERT INTO beu_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Base, na iiabanang pi naadang kabingdena hengi, aulange pi bisa bale daeri. Na nomi vengaanamang hula, ping anga naung eningse nehe nu bae silaka angu harak niang. Eningse ping emangpi malekang ila aadang taang.” ");
INSERT INTO beu_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mateng aulang muse, Paulus ana roti angu medi, angmuse ana iapangaadang mi banang tarimakasi metma Lahatala enang. Seng angmuse ana roti angu ening atatara sengila ba ana adang. ");
INSERT INTO beu_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","37","Uuling ateing aulang muse, iomi bale aanamang iila. Angmuse ing di eamulung naadang hama-hama. Ning emangpi ba kampal taang angu ninang ratu aaru ari bititu belta taling. ");
INSERT INTO beu_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Naadang sengmuse, gandum aara edadenang ekarong ang naung ini ohit metma tang mi bia, senge kampal angu ening taang avilat maveng. ");
INSERT INTO beu_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bir jala tarang iila muse, kampal emataros ang naung uuling se aadang ateing iila. Aarunge ini bae ateing niang hula angu naba por. Bot omi kura nu e oolol angu bahi ue mi angu di ini uuling ateing. Base, ini etatabit vengbaing hula, bisa se kampal angu ini hula baning metma var eele ba tang omi mi ang naung lakal, senge ila oolol angu mi. ");
INSERT INTO beu_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Angmuse, livang ba tang omi mi ang naung esar angu ini patait asia, senge livang ang naung tang omi mi hola. Seng angmuse ini kampal euuling at hela hele, senge kampal angu vengaalapa. Angmuse ini bot aalal jip kampal etiri mi angu di at mida, senge eenar vengboning kampal angu at oolol mi mida. ");
INSERT INTO beu_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Aarunge kampal angu aalarit ila bahi patang tang omimi angu taang mida, angmuse kampal angu angmi patang, bot bae butil niang iila. Angmuse, kampal eaalap angu buat eele buet ening ajasing. ");
INSERT INTO beu_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tentara ang naung ini uuling ateing aulang muse, iomi hula bui enehe ang naung emangpi iameang. Se ini iuangmarit hula, misavaka bui enehe ang naung ini oma aalulit aadang taang mida, senge bihit ila angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Aarunge tentara Yulius ana tentara ang naung ihapa, se ana hula tentara ang naung iot ekang Paulus ameang ekang angu ebele. Angmuse ana parentat hula, nehe ba aalulit aaung ang naung iot iava abaang tang mi hela, senge aalulit aadang taang mida. ");
INSERT INTO beu_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Senge nehe ba aalulit ahala ang naung ana iot aarang, bot naba ba ue angmi dise pina, senge buat eamulung teding aadang ebele mida. Base, ning emangpi salamat mida aadang taang. ");
INSERT INTO beu_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ning emangpi salamat mida aadang taang iila muse, ni ateing hula, por angu ene Malta. ");
INSERT INTO beu_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Aabang ba Malta por taang enehe ang naung ini ning aada bot ning tarimat aaung-aaung. Aanuar hela angu ba bir etatabit kajavi, angu ebele ini oolol angu mi aad maveng ening ahuring, sengmuse ini niabanang hula niot aad huring angu eang. ");
INSERT INTO beu_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulus di iamulung aadeela valaping, senge metma aad huring angu taang mea. Aarunge ana aadeela angu metma aad huring angu taang mea sehi se, aad huring etutung angu ebele, mibaroti se duming nu aad omimi kaluar hela. Angmuse duming angu Paulus atang angu mi adang venghili sehi. ");
INSERT INTO beu_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Malta enehe ang naung ini uuling ateing se duming angu Paulus atang angu mi adang venghili sehi muse, ini itat mateng hula, “Nehe anga, ana jasi ening iila. Nehe anga ana nehe ameang iila. Nuba ba jasi angu ening se, ana malekang ebili angu tevang. Ana tang taang aaminang angu eahalang iila aarunge, angase duming aing adang base ana malekang aamina!” ");
INSERT INTO beu_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","6","Nehe ang naung ini vengiomit hula, kabingdena maveng se, Paulus atang angu vavarang, niangse mibaroti se ana baat hela bot ana aamina. Aarunge Paulus ana duming angu teret metma aad huring angu mi bia. Bot ana bae edira kabingdena rasa di niang. Angmuse, nehe ang naung vengbaing avalaluung, aarunge na iiba bae Paulus aing harak niang. Angmuse ini vengiomit hula, “Paulus angu aaneda!” ");
INSERT INTO beu_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Mana angu bae eola niang angu, gubernur ehava bot emeke bira eele angu ue angmi. Gubernur angu ene, Publius. Ana ila oolol mi ning harak, sengmuse ana niajali senge hoa ehava mi mihi. Angu mi ana ning vengbalentat ved tue. ");
INSERT INTO beu_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Uanguveng angu, gubernur imang ajajai angu ue dila tajoa, bot atou makara bae barinti niang. Paulus ana masot mida ekamar mi euuling, sengmuse ana atang metma nehe dila angu taang mea, senge aing vengsambajang. Angmuse ana mang mona tila. ");
INSERT INTO beu_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ini uuling ateing se gubernur imang angu mona tila muse, nehe dila aabeung ang naung di ini iat Paulus ebele hoa. Ini abanang, senge ana ing ening mona. ");
INSERT INTO beu_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Angmuse, nehe ang naung ini hula ibanang tarimakasi matubing anguba, ini iatang ooang baning hoa metma maninang. ");
INSERT INTO beu_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ni Malta mi mihit mi uuru tue, ila ooras umba eele bot aaribut eele angu vengbarinti. Uanguveng angu, kampal nu bendar Aleksandria mi hoa angu di ooras uumba angu omimi por angu taang teding. Kampal angu ene, Vaal Takohal, se aaneda vaal takohal epatung angu ue kampal etiri angu taang tahi angu ebele. Angmuse, ni hula kampal angu taang mida, senge aalarit milalut Roma mi ila. Base, ni hula kampal taang mida muse, Malta enehe ang naung ini mod, bot na aabeung ba bae kampal taang niang angu ini baning hoa metma maninang. ");
INSERT INTO beu_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ni aalarit pati-pati, angmuse ni ila bendar Sirakusa ba Sisilia por taang angu mi. Ni angu mi teding mietang tue. ");
INSERT INTO beu_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Angu mi, ni Sisilia eaadang angu amulung aalari, angmuse ni ila bendar Regium mi. Emitobang muse, eenar tang eoat boning eele angmuse ni alarit etatabit laju. Emietang aaru muse ni ila bendar Putioli eolol angu mi. ");
INSERT INTO beu_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ila angu mi muse, ni hela kampal angu eahalang, sengmuse ni ila angumi nehe omi Mutu Yesus vengaanamang ang naung ing aalaping. Ni ing harak muse, ini niajalit ila iabung mihi. Base ni angu mi mihit vengtahang mi ong nu. Seng angmuse, ni nia venglamal milalut Roma mi ila. ");
INSERT INTO beu_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nehe iomi Mutu Yesus vengaanamang ba Roma mi ang naung vengmee se, ni hula Roma mi ila muse, ini hoa via mi ning harak. Iiba angu ong Apius mi ning harak; bot eabeung angu mana nu ene, Aaring Mana Tue, angu mi ning harak. Paulus ana uuling ateing aulang muse, ana tarimakasi toang-toang vengbanang metma Lahatala enang, bot omi etatabit aanamang. ");
INSERT INTO beu_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ila Roma mi muse, tentara ang naung ini bui enehe ang naung ing metma bui enehe eele angu atang miabaang. Aarunge Paulus angu ini bae aing metma bui mi niang. Ini aing vengkilang, senge Paulus ana hava nu sevat mi mihi. Tentara nu ini aing gahing senge ot Paulus aing jaga. Tentara angu Paulus oleve iatang dadena angu nehe rante metma taing vengparta. ");
INSERT INTO beu_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ved tue sengmuse, Yahudi eboma ba angmi ang naung Paulus ana iarut hoa, senge aing harak. Ini hoa taing harak iila muse, Paulus ana iat hubait hula, “Kaku naung! Na ae anga mi, se nehe ang naung ini Yerusalem mi nadoi angu ebele. Na bae na iiba ening ahala niang aarunge ini nadoi sengmuse, ini naing metma Roma eparenta enehe eele angu atang mi abaang! Na bae na iiba ening metma pi bangsa angu lavang niang. Bot pihada elamal-etahi ba, pi tidat-timang ang naung iabung tarima tila angu di, na bae lavang niang. ");
INSERT INTO beu_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Parenta enehe eele ana Yerusalem mi ne parkara angu vengurus ila. Aarunge, neahalang iiba hula hukung aamina naing vengbaa angu bae harak niang. Angu ebele ba ini hula naing ening lohi. ");
INSERT INTO beu_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Aarunge Yahudi enehe eele ang naung, ini Roma eparenta enehe eele ana vengputus iilat hula naing ening lohi angu atobang, angu ebele na malekang hoa Roma mi senge neahalang ba ini vengbanang metma nadana angu, ini veng nadangtaaning. Na ening aulang, aarunge ne nomi bae hula ne lelang omi enehe ang naung ing ening ahala niang. ");
INSERT INTO beu_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Parkara angu ebele ba na hoa anga mi anga. Nekaku naung na iing kumpul senge na iiat mateng hula ping ba Israel enehe ang naung pi tomi metma vengmea angu, eningse Raja ba Lahatala Ana vengpalai tila angu Aing gahing hoa. Aing ba eningse ping ening lohi, bot aabetang ejajehing angu metma mapinang. Angu ebele ba ini rante metma naing parta anga.” ");
INSERT INTO beu_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Angmuse ini ebalet hula, “Ila anga vengjehi anga, surat Yudea mi hoa ba eeparkara anga metma veng niat hubai angu, ni bae nu tarima di jedung. Aulang di, pikaku naung ba Yerusalem mi hoa angu, ini bae eeparkara angu metma veng niat mateng niang. ");
INSERT INTO beu_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Aarunge naba ba aana oomi metma vengaanamang angu ni sukat hula vengmee. Se taang-taang mi angu ni vengmee tilat hula, naba ba aana oomi metma vengaanamang angu, nehe ang naung ini vengbanang hula ahala angu ebele. Aarunge emolo angu tatalang se, ni bae ateing jedung. Base, aana nioang moling senge metma niat mateng hengi.” ");
INSERT INTO beu_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Hama-hama tominu sengmuse, Paulus bot Yahudi eboma ang naung ini ved nu vengbanang, senge ini bot taing harak. Ila eved angu mi muse, nehe toang-rae hoa Paulus ehava mi taing vengkumpul. Angmuse Paulus ana iat mateng vengbanang tarang hula, “Lahatala Ana Eparenta pina. Senge Ana nehe ening lohi bot aabetang ejajehing metma ma inang angu.” Bot kuaveng ila ved baa angu, hur kokal ba boma Musa esurat mi bot Lahatala Ehurvala aabeung ang naung isurat mi angu, Paulus evengbanang tarang metma veng iat hubai, senge hula iomi angu abingit metma Yesus vengaanamang. ");
INSERT INTO beu_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ini Paulus emateng angu vengmee sengmuse, iiba angu iomi metma vengaanamang, aarunge iiba angu niang. ");
INSERT INTO beu_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ini iai metma tadanat aulang anguba nehe iiba angu ila. Nehe iiba ang naung ila sehi muse Paulus ana mateng hula, “Turang mi naba ba Lahatala ERoh hamulang metma boma Yesaya veng at hubai senge ana metma tidat-timang ang naung iat hubai tila angu, etabi. ");
INSERT INTO beu_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Lahatala Ana vengbanang hula, Aana ila lelang anga at hubait hula, “Ne mateng angu eningse iini vengmeet alolang niang, aarunge iini bae manggaratit kabingdena di niang! Naba ba Na ening angu iini uuling ateing alolang niang, aarunge iini bae eamulung niang.” ");
INSERT INTO beu_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Se lelang anga iomi angu aanamang emenghula var aanamang angu edadenang angu ebele. Iaver angu ini iat bae metma venghele niang iila! Bot ieng angu di, ini vengtering etatabi angu ebele! Vengkilang senge ini ekang vengmee ekang; Bot vengkilang senge ieng angu ekang uuling ateing ekang. Bot vengkilang senge ini aabetat iomi angu ba eamulung. Ila ini bae aabetang aaung-hama evia ateing niang, base ini bae bale Ne bele hoa niang iila, Base, tatalang senge eningse Na ing ening ini aabetat aaung-hama?ꞌ ” ");
INSERT INTO beu_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Evengtahi mi angu Paulus ana mateng hula, “Base alang, kaku naung! Iini malekang ateing hula, angase bangsa aabeung ba bae Yahudi niang ang naung di, Lahatala Ana vengharakat hula ing ening lohi, senge aabetang ejajehing angu metma mainang angu nehe metma veng iat hubai tila base eningse ini Aing venghele.” ");
INSERT INTO beu_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulus mateng aulang sengmuse, nehe ang naung emangpi ila mana angu eahalang. Aarunge ini bae tominu niang, se naba ba Paulus ana vengbanang angu ini veng iai metma tadana angu ebele. ");
INSERT INTO beu_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulus ana Roma mi hava nu seva angu mi mihit ila mitung aaru. Nehe emangpi ba ebele hoa angu, ana etatabit sanang bot ing tarima. ");
INSERT INTO beu_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Paulus ana iat mateng hula, “Lahatala Ana Eparenta pina tila. Senge Ana nehe ening lohi bot aabetang ejajehing metma ma inang.” Bot Mutu Yesus Evia Aabetang angu di Paulus ana metma iavomung-iapahang. Paulus ana baranit mateng tarang, se na iiba bae aing sakang niang angu ebele. Nimang Topilus ba oomi aaung. Ne sarenta angu ila anga mi jehi. Naing ba, Lukas ");
ALTER TABLE beu_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
