﻿USE sofia;
DROP TABLE IF EXISTS sofia.beo_vpl;
CREATE TABLE beo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES beo_vpl WRITE;
INSERT INTO beo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Musa: hemonega, bisili esoga, Gode da mu amola osobo bagade degabo hahamoi. ");
INSERT INTO beo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Osobo bagade da liligi hame galu. Hano gafululi hamonana fawane amo gasi dunasi ganodini ba:i. Gode Ea A:silibu da hano dabua gadodidi lalalu. ");
INSERT INTO beo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Amalalu, Gode E amane sia:i, “Hadigi misa.” Ea sia:beba:le, hadigi misi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Gode da hadigi amo hahawane ba:i. Amalalu, E da hadigi amola gasi dunasi afafai. ");
INSERT INTO beo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Hadigi amoma E da “eso” dio asuli. Gasi dunasi amoma E da “gasi” dio asuli. Daeya asili, hahabe doaga:i, amo eso age da baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","8","Amalalu, Gode da hamoma:ne sia:beba:le, hisi sogebi amo hano amoga gududili amola hano gadodili amo afafama:ne misi. Hisi sogebi amoma E da ‘mu’ dio asuli. Daeya asili hahabe doaga:i, amo eso ageyadu da baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Amalalu, Gode E amane hamoma:ne sia:i, “Hano amo mu hagudu gala amo gilisili, osobo hafoga:i ba:ma:ne misa!” E amane sia:beba:le, osobo da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Osobo hafoga:i amoma Gode da ‘Osobo’ dio asuli. Amola hano gilisi amoma E da ‘Hano Wayabo Bagade’ dio asuli. Gode da Ea hamoi da noga:idafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Amalalu, Gode da amane hamoma:ne sia:i, “Osobo amoga ifa amola gisi heda:ma. Ifa amola gisi ilia aligi hou defele dulu amola fage legema:ne heda:ma:ma!” Amalalu, Gode Ea hamoma:ne sia:i defele ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Gisi amo ilia aligi defele fage legei amola ifa amo ilia aligi defele dulu (amo ganodini fage ba:i) legei da osoboga heda:i. Gode da Ea hamoi noga:idafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Daeya asili, hahabe doaga:i, amo eso osoda da baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Amola Gode E amane hamoma:ne sia:i, “Mu amoga, gamali amo da gasi amola eso afafamusa:, eso, ode, anegagi oubi amola gibu dasu oubi, amo huluanema defei dawa:ma:ne, gamali misa! ");
INSERT INTO beo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Gamali da mu amoga nenanebeba:le, osobo bagadega hadigi imunu galebe.” Amo hamoma:ne sia:beba:le, gamali ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gode da gamali bagade aduna hahamoi. Eso da ha ouligima:ne amola oubi da gasi ouligima:ne, E hahamoi. Amola E da gasumuni hahamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Gode da amo gamali osobo bagadega hadigi olelema:ne muagadodi ligisi. ");
INSERT INTO beo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Eso amola gasi amoma ouligisu dialoma:ne, amola hadigi amola gasi amo afafamusa:, E da amo gamali ligisi. Gode da Ea hamoi noga:idafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Daeya asili, hahabe doaga:i, amo eso biyadu da baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Amalalu Gode da amane hamoma:ne sia:i “Hano ganodini esalebe fi osea:idafa hano wayabo huluane nabama:ne misa! Hisi amo ganodini amola sio fi da amo nabama:ne misa!” ");
INSERT INTO beo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Amola Gode da menabo bagadedafa hahamoi amola hano ganodini esalebe fi liligi, amola sio fi huluane hahamoi dagoi. Amola Gode da Ea hahamoi huluane hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","E da amo fi huluane ilima hahawane dogolegema:ne sia:i. Hano ganodini fi liligi ilima ilia mano lale, hano wayabo bagade nabama:ne amola sio fi osobo bagadega gilisima:ne, E da ilima mano lama:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Daeya asili hahabe doaga:i, amo eso bi da baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Amalalu, Gode amane hamoma:ne sia:i, “Esalebe liligi amo lai gebo, ohe fi amola liligi huluane da osoboba:le lafia:dalebe, amo ilia fi defele osoboga misa!” E da hamoma:ne sia:beba:le, huluane ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Gode da ohe fi ilia fi defele, lai gebo amola liligi osoboba:le lafia:dalebe, amo huluane ilia fi defele hahamoi. Gode da Ea hahamoi liligi huluane hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Amalalu, Gode amane hamoma:ne sia:i, “Ninia wali dunu fi amo ninia: agoaila hamomu. Dunu fi ilia da hano wayabo bagade menabo fi, sio fi mu amo ganodini esala, ohe fi amola osobo bagade liligi huluane osoboba:le lafia:dalebe, ilia da amo huluanema ouligisu esalumu.” ");
INSERT INTO beo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Amaiba:le, Gode da dunu amo Ea hou defele hamoma:ne, hamoi dagoi. E da dunu fi amo dunu amola uda hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Gode da elama hahawane dogolegema:ne sia:i. E da elama amane hamoma:ne sia:i, “Ali gilisili fima! Mano bagohame lale, osobo bagade nabalesima! Osobo bagade, hano wayabo bagade menabo fi, mu amo ganodini sio fi, amola liligi huluane osoboba:le lafia:dalebe ilima alia ouligisa esaloma!” ");
INSERT INTO beo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Amalalu, Gode amane sia:i, “Osobo bagade amo ganodini, gisi amola ifa amo da fage legesa, liligi huluane amo ali moma:ne Na da alima iaha.” ");
INSERT INTO beo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Amola E eno amane sia:i, “Na da mola:ya:i gisi liligi huluane amo osobo bagade ohe fi amola sio fi mu amo ganodini amola liligi osoboba:le lafia:dalebe, ilia moma:ne ilima iaha.” E da amo sia:beba:le amo hou da doaga:i dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Gode da Ea hahamoi liligi huluane ba:i dagoiba:le, E da huluane noga:idafa ba:i. Amola daeya asili, hahabe doaga:i, amo eso gafe da baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Amalalu mu amola osobo bagade, amo da liligi gilisisu bagadedafa, amo huluane da hahamoi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Eso fesu da doaga:beba:le, Gode da Ea hahamoi huluane dagobe ba:i. Amaiba:le, E da eso fesu amoga hawa: hamosu yolesili, helefi. ");
INSERT INTO beo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Amola Gode da eso fesu amoma hahawane dogolegema:ne sia:i, amola amo eso E da eso eno amoga afafane. E da Ea hawa: hamonanu, eso fesu amoga helefibiba:le, eso fesu afafane, hadigi eso modale ligiagai. ");
INSERT INTO beo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Osobo bagade amola mu liligi huluane da agoane hamoi. Be Hina Gode da osobo amola mu degabo hahamonanu, ");
INSERT INTO beo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","fage da sono hame heda:iba:le, ifa amola gisi, da hame ba:i. Bai amo esoha E da gibu hame iasi galu. Amola osobo dogoma:ne, ouligisu dunu da hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Be hano amo da osobo hagudu galu, amo da heda:le, osoboba:le ai ahoasu. ");
INSERT INTO beo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Amalalu, Hina Gode da osobo lale, dunu hamoi. Amo dunu ea mi amoga E da mifo i. Amalalu, dunu da esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Amalalu, gusu soge amo ganodini, amo da Idini soge, Hina Gode da ifabi bugi. Gode da dunu Ea hamoi, amo ifabi ganodini asunasi. ");
INSERT INTO beo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Amo ifabi ganodini, Gode da ifa ida:iwane amo da fage ida:iwane legesa, amo osea:idafa ifabi ganodini bugi. Ifabi dogoa amogai da mae bogole Fifi Ahoanusu ifa amola ifa eno da ea fage nasea dunuma noga:i hou amola wadela:i hou amo afafane dawa:digisu olelesu, amo ifa aduna lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Idini soge amo ganodini hano afadafa ba:i. Amo hano da bugi liligi amoma hano iasu. Idini soge yolesili, amo hano da adimi hamone, bu hano biyaduyale hamoi. ");
INSERT INTO beo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Hano age amo ea dio da Bisone. Amo hano da Hafila soge amo ganodini ahoa. ");
INSERT INTO beo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Amo soge ganodini da gouli ida:iwane gala, gabusiga: manoma amola igi ida:iwane gala.) ");
INSERT INTO beo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Hano ageyadu ea dio da Gihone. Amo hano da Guse soge amo ganodini ahoa. ");
INSERT INTO beo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hano osoda ea dio da Daigalisi. Amo da Asilia soge gusu la:ididili ahoa. Hano biyadu amo ea dio da Iufala:idisi. ");
INSERT INTO beo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Amalalu, Hina Gode da dunu amo Idini Ifabi amo ea osobo dogoma:ne amola sosodo ouligima:ne asunasi. ");
INSERT INTO beo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Gode da dunuma amane hamoma:ne sia:i, “Ifa huluane ifabi ganodini bugi amo fage faili manu da defea. ");
INSERT INTO beo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Be ifa afadafa fawane amo ifa da hou da noga:i o wadela:i amo dawa:digisu iaha, amo ifa fage nasea, di da amo esohaga bogomu.” ");
INSERT INTO beo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Amalalu, Hina Gode da amane sia:i, “Dunu hisu da esalumu da defea hame galebe. Na da na:iyado dunu e fidima:ne hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Amola Gode da osobo gasa:le, ganumugini, ohe fi amola sio fi hahamoi. Amalalu, E da amo fi huluane, dunu da ilima dio asulima:ne, oule misi. A:da:me da ilima dio asuliba:le, ilia da amo dio lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Amaiba:le, A:da:me da lai gebo amola sio fi amola ohe fi huluane ilima dio asuli. Be A:da:me fidima:ne, na:iyado fidisu dunu defele afae da hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Amaiba:le, Hina Gode hamobeba:le, A:da:me da golai nanabunina asi dialoba, Gode da ea didifi afadafa gulalelale, hu amola bu madelagili gilisi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Gode da dunu ea didifi gulale, amoga uda hamone, ema oule misi. ");
INSERT INTO beo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Amalalu, dunu da amane sia:i, “Defea! Wali na fi dunu eno da esala. Ea gasa da na gasa amoga lai, amola ea hu da na hu amoga lai. E da dunu amoga lalegaiba:le, ea dio da ‘uda’.” ");
INSERT INTO beo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Amaiba:le, dunu da ea ada amola ea ame yolesili, ea udama madelagili hu afadafa hamosa. ");
INSERT INTO beo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Dunu amola uda ela da da:i nabado ba:i. Be ela da hame gogosia:i. ");
INSERT INTO beo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Hina Gode Ea hahamoi fi liligi amoga, sania ea hohonosu dawa:digisu da liligi huluane amo ilia dawa:su baligi dagoi ba:i. Sania da udama amane sia:i, “Ifa huluane ifabi ganodini bugi amo ea fage mae moma:ne, amo sema Gode da dafawane ilegebela:?” ");
INSERT INTO beo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Uda da bu adole i, “Ani da ifa huluane ifabi ganodini bugi amo ea fage faili manu da defea. ");
INSERT INTO beo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Be ifa afadafa fawane ifabi dogoa bugi, amo ea fage Gode da mae moma:ne, amola mae digili ba:ma:ne sia:i. Amane hamosea, ania da bogosu ba:mu!” ");
INSERT INTO beo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sania da bu adole i, “Amo da ogogosa! Alia da hame bogomu! ");
INSERT INTO beo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Alia da amo fage nasea, alia da hou noga:i amola wadela:i amo dawa:beba:le, bu Gode agoane defele ba:mu. Alia da amo hamosa:besa:le, Gode da ali bogomu sia:i!” ");
INSERT INTO beo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Uda da amo ifa fage da ha:i manu noga:iwane ba:beba:le, amola ea ba:su da noga:i, amo dawa:beba:le amola amo nasea dawa:su bagade lamu amo dawa:beba:le, e da amo ifa fage faili mai. Eno e da egoa ema gilisili esalu, ema iabeba:le, e mai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Na dagole, ela asigi dawa:su si fadegai dagoi ba:i. Ela da da:i nabado amo dawa:beba:le, ela da figi ifa lubi amo nodomene, ela da:i nabado dedeboi. ");
INSERT INTO beo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Daeya, ela da Hina Gode ifabi ganodini ahoabe nabi. Ela da ifa adodoboi amoga wamoaligi. ");
INSERT INTO beo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Be Hina Gode da A:da:mema amane wele sia:i, “Di da habila:?” ");
INSERT INTO beo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A:da:me da bu adole i, “Di da ifabi ganodini ahoanebe amo na da nabi. Na da beda:iba:le wamoaligi. Na da da:i nabado amo dawa:beba:le beda:i galu.” ");
INSERT INTO beo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Gode da bu adole ba:i, “Di da da:i nabado nowa adobela:? Ifa fage amo na da dima mae moma:ne sia:i, amo di da maibala:?” ");
INSERT INTO beo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Dunu da bu adole i, “Uda amo Dia da nama i, e da amo ifa fage nama iabeba:le, na da mai dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Hina Gode da udama amane adole ba:i, “Di da abuliba:le agoane hamobela:?” Uda da bu adole i, “Sania da nama ogogoiba:le, na da mai dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Amalalu, Hina Gode da sania amoma amane sia:i, “Di da Na se iasu lamu galebe. Dima gagabusu aligima:ne da ohe fi huluane amo ilima gagabusu bagadewane baligimu. Wali mae yolesili di da dia hagomoga sugi masunu. Di da osobo fawane naha esalumu. ");
INSERT INTO beo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Na hamobeba:le, di amola uda da ha laiwane esalumu. Ea Mano amola dia mano da mae yolesili ha laiwane esalumu. Uda ea Mano da dia dialuma goudamu, amola di da ea Mano amo Ea emo gufi gasomanu.” ");
INSERT INTO beo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Amola udama E amane sia:i, “Di da abula agui ba:sea amola mano lalelegesea, dia se nabasu Na da bu bagade hamomu. Be amo mae dawa:le, di da diguama fima:ne hanamu. Be e da dima hinawane esalumu.” ");
INSERT INTO beo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Dunuma E amane sia:i, “Dia uda ea sia: nababeba:le, di ifa fage amo Na da mae moma:ne sia:i liligi, amo di da mai dagoi. Di da agoane hamobeba:le, Na da osobo amoga gagabusu aligima:ne ilegemu. Di da se nabawane gasa bagade hawa: hamobeba:le fawane, osoboga ha:i manu lamu. ");
INSERT INTO beo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Osoboa aya: gaga:nomei gisi heda:le, di da osoboga udigili heda:i liligi amo fawane manu galebe. ");
INSERT INTO beo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Di da gasa bagadewane finumu asili, hawa: hamobeba:le fawane, dia ha:i manu osoboga lamu. Di da osobo amoga hamoiba:le, bu osoboga doaga:sea fawane amo hou da dagoiwane ba:mu. Bai di da osobo amoga hamoi dagoi, amola di da osoboga buhagimu!” ");
INSERT INTO beo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","A:da:me da idua da dunu fifi asi gala ilima ame esalumu ba:i. Amaiba:le, e da idua ema Ibi dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hina Gode da ohe fi gadofo amoga abula amo A:da:me amola idua ela dedeboma:ne, Gode Hi hahamoi. ");
INSERT INTO beo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Amalalu, Hina Gode E amane sia:i, “Dunu da hou noga:i amola hou wadela:i amo afafane dawa:su lai dagoiba:le, e da Nini defele hamoi dagoi. E da Mae Bogole Fifi Ahoanusu ifa amo ea fage nasea eso huluane esalalalumu, amo hamosa:besa:le, ninia ea logo hedofamu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Amaiba:le, Hina Gode da dunu Idini Ifabi amoga ela esalu, amo gadili sefasi. Gode da osobo amoga dunu ea da:i hodo hahamoi, amola amo osobo ouligima:ne amola dogoma:ne, e asunasi. ");
INSERT INTO beo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Amalalu, Idini Ifabi gusu la:ididili, Gode da ‘selubimi’ dunu asunasi, amola gegesu gobiha:i bagade lalu agoane amo da gusu, gudu amola ga amo fefeloasu, amo E da asunasi. Dunu eno da mae bogole Fifi Ahoanusu ifa amoma doaga:sa:besa:le, E agoane hamoi. ");
INSERT INTO beo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","A:da:me amola idua Ibi da gilisili golai (elesu sogelai). Amalalu Ibi da abula agui ba:i amola ea mano Ga:ine lalelegei. Ibi da amane sia:i, “Hina Gode da fidibiba:le, na da dunu mano lalelegei!” ");
INSERT INTO beo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Fa:no Ibi da Ga:ine eya amo A:ibele lalelegei. A:ibele da sibi amola goudi ouligisu. Ga:ine da ifabi ouligisu esalu. ");
INSERT INTO beo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Asili, Ga:ine da ha:i manu amo ea ifabiga lai, amo Hina Godema gaguli misi. ");
INSERT INTO beo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Be A:ibele da ea sibi ilima degabo lalelegei sefena gala, amo lale, ea liligi noga:idafa Hina Godema gaguli misi. Hina Gode da A:ibele amola ea iasu amo hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Be E da Ga:ine amola ea gaguli masu liligi hahawane hame ba:i. Amaiba:le, Ga:ine da mi hanai galu. E da hagusa:ili, ea dialuma fili sa:i. ");
INSERT INTO beo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Amalalu, Hina Gode da Ga:inema amane sia:i, “Di da abuliba:le ougibala:? Dia odagi da abuliga hagusa:ila:? ");
INSERT INTO beo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Di da hou moloidafa hamoi ganiaba, Na da di lalegagula:loba. Be amai hame galea, wadela:i hou da gasonasu ohe fi defele dia logo holeiga dima doagala:musa: esalebe ba:mu. Wadela:i hou da di osa:le heda:musa: dawa:lala. Be di da wadela:i hou osa:le heda:mu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ga:ine da eya A:ibelema amane sia:i, “Ani sogega ahoa:di!” Ela da sogega asili, Ga:ine da A:ibele sogoba:le, medole legei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Amalalu, Hina Gode da Ga:inema adole ba:i, “Dia eya A:ibele da habila:?” Ga:ine da bu adole i, “Na da hame dawa:! Na da naeya amo ea ouligisu dunula:?” ");
INSERT INTO beo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hina Gode da amane sia:, “Di da adi hamobela:? Dia eya amoea maga:me osoboga sogoadigi, amo dabema:ne Nama wele sia:nana. ");
INSERT INTO beo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Wali gagabui da dima aligi gala. Di da wali osoboa ifabi hawa: hamomu da hamedei. Bai osobo amoga di da diaeya ea maga:me dia loboga sogadigi, amo fedege agoane mai dagoiba:le. ");
INSERT INTO beo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Di da osobo gidinasea, osobo da dima ha:i manu hame imunu. Di da mae aligili, diasu hamedene, osobo bagadega udigili lalumu.” ");
INSERT INTO beo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ga:ine da Hina Godema amane sia:i, “Na da amo se iasu lamu da hamedei. ");
INSERT INTO beo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Wali eso Di da na soge fisili masa:ne sefasilala. Na da Di gadenene esalumu hamedei agoane ba:sa. Na da osobo bagadega mae aligili lalumu. Nowa da na ba:sea, ilia da na medole legemu.” ");
INSERT INTO beo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Be Hina Gode da ema amane sia:i, “Hame mabu! Nowa da Ga:ine fane legesea, Na da ema fesuale agoane dabemu.” Amalalu, Hina Gode da ilegesu dawa:digisu, amo nowa da Ga:ine ba:sea, medole legemu da sema bagade, amo E da Ga:inema ilegei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Amalalu, Ga:ine da Hina Gode amo yolesili, e da soge Node (dawa:loma:ne da ‘Udigili Lala’) amo da Idini sogega gusudili gala, amoga esalumusa: asi. ");
INSERT INTO beo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ga:ine da ea udala gilisili golale (soge lalu), e da abula agui, Inage lalelegei. Ga:ine da amo esoga moilai bai bagade gagulalebe ba:i. Amoga e da ea mano Inage, amo ea dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inage da mano lai amo ea dio Aila:de. Aila:de da mano lai amo ea dio Mihiuya:iele. Mihiuya:iele ea mano da Midiusa:iele amola Midiusa:iele ea mano da La:imege. ");
INSERT INTO beo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","La:imege da uda aduna lai. Afae da A:ida, eno da Sila. ");
INSERT INTO beo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","A:ida da mano lai amo ea dio amo Ya:iba:le. Ea manolali da abula diasu ganodini esalu amola ilia da lai gebo fi ouligisu. ");
INSERT INTO beo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ya:iba:le eya da Yuba:le. Ea mano da gesami hea:su dusu liligi amo sani baidama, fulabosu dusu amola dusu hou eno hamosu. ");
INSERT INTO beo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila da mano lalelegei amo ea dio da Diubale-Ga:ine. E da ouli amola balase hahamonanu, hawa: hamosu liligi hahamoi. Diubale-Ga:ine amo ea dalusi da Na:iama. ");
INSERT INTO beo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","La:imege da ea uda aduna elama amane sia:i, “A:ida amola Sila! Na sia: nabima! Goi afae amo da na faiba:le, na da amo goi fanelegei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Gode da amane sia:i, ‘Nowa da Ga:ine fasea, e da Gode Ea se iasu baligili fesuale agoane ba:mu.’ Be na sia: da nowa La:imege fasea, e da se baligili 77 agoane ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","A:da:me amola idua bu gilisili golai. Amalalu, idua da dunu mano lai. E da amo manoma Sede dio asuli. E amane sia:i, “Ga:ine da A:ibele amo medole legei. Amaiba:le, ea sogebi lama:ne, Gode da mano eno nama i dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sede amola da dunu mano lalelegei amo ea dio Inosie. Amo esoga, osobo bagade dunu fi da muni Godema dawa:le, Ea Dioba:le nodone sia:ne gadosu. ");
INSERT INTO beo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","A:da:me ea fi amo ilia hou da hagudu dedei. (Gode da dunu fi hamonoba, E da Hi hou defele ili hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","E da dunu fi amo dunu amola uda hahamoi. E da elama hahawane sia:i. Hahamoi dagoiba:le e da elama ‘dunu fi’ dio asuli.) ");
INSERT INTO beo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","A:da:me da ode 130 esalu, dunu mano A:da:me ea ba:su defele lalelegei. E da amo manoma Sede dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sede da lalelegelalu, A:da:me da ode 800 eno esalu. Ema da dunu manolali eno amola uda manolali eno lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A:da:me da ode 930 esalu, bogoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sede da ode 105 esalu, ea mano Inosie da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Inosie da lalelegelalu, Sede da ode 807 eno esalu. Ema dunu manolali eno amola uda manolali eno lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sede da gilisili ode 912 esalu, bogoi. ");
INSERT INTO beo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inosie da ode 90 esalu, ea mano Gina:ne da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Gina:ne da lalelegelalu, Inosie da ode 815 eno esalu. E da dunu manolali eno amola uda manolali eno lai. ");
INSERT INTO beo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Inosie da gilisili ode 905 esalu, bogoi. ");
INSERT INTO beo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Gina:ne da ode 70 esalu, ea mano Maha:ilalele da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maha:ilalele da lalelegelalu, Gina:ne da ode 840 eno esalu. Amo ode amoga e da dunu manolali eno amola uda manolali eno lai. ");
INSERT INTO beo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Gina:ne da gilisili ode 910 esalu, bogoi. ");
INSERT INTO beo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maha:ilalele da ode 65 esalu, ea mano Ya:ilede da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ya:ilede da lalelegelalu, Maha:ilalele da ode 830 eno esalu. Amo ode ganodini dunu manolali eno amola uda manolali eno ea ema lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maha:ilalele da gilisili ode 895 esalu, bogoi. ");
INSERT INTO beo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ya:ilede da ode 162 esalu, ea mano Inage da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Inage da lalelegelalu, Ya:ilede da ode 800 eno esalu. Amo ode ganodini e da dunu manolali eno amola uda manolali eno lai. ");
INSERT INTO beo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ya:ilede da gilisili ode 962 esalu, bogoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inage da ode 65esalu, ea mano Midusala lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Midusala da lalelegelalu, Inage da 300 ode amoga gilisili Gode amola lalu. Ema dunu manolali eno amola uda manolali eno da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Inage da gilisili ode 365 esalu. ");
INSERT INTO beo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inage da gilisili Gode amola lalu. Amalalu, e da osobo bagadega alalolesi. Bai Gode da Inage mae bogole, lale gadoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Midusala da ode 187 esalu, ea mano La:imege da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","La:imege da lalelegelalu, Midusala da ode 782 eno esalu. Amo ode ganodini e da dunu manolali eno amola uda manolali eno lai. ");
INSERT INTO beo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Midusala da gilisili ode 969 esalu, bogoi. ");
INSERT INTO beo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","La:imege da ode 182 esalu, ea dunu mano da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","E da amo manoma Nowa: dio asuli. E amane sia:i, “Gode da osobo amoma gagabusu aligima:ne ilegei dagoiba:le, ninia da se nabawane hawa: hamonana. Be amo mano da ninia dogo denesimu.” ");
INSERT INTO beo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowa: da lalelegelalu, La:imege da ode 595 esalu. Amo odega e da dunu manolali eno amola uda manolali eno lai. ");
INSERT INTO beo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","La:imege da gilisili ode 777 esalu, bogoi. ");
INSERT INTO beo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowa: da ode 500 esalu. Amalalu, ea dunu manolali Sieme, Ha:me amola Ya:ifede da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Osobo bagadega dunu fi idi da bagade heda:i. Uda mano da ilima lalelegeloba, ");
INSERT INTO beo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Gode egefelali da dunu fi ilia uda manolali hahawane ba:loba, ilia hanaiga amo uda mano lasu. ");
INSERT INTO beo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Amalalu Hina Gode da amane sia:i, “Na A:silibu da dunu ilima eso huluane hame gegenanumu. Bau osobo bagade dunu ilia bogosu dawa:. Ilia da wali ode 120 fawane esalumu. ");
INSERT INTO beo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Amo esoga, amola fa:no, dunu bagade amo ilia dio da Nefilime da osobo bagadega esalu. Gode egefelali amola osobo bagade dunu ilia uda manolali da gilisili golaiba:le, amo dunu bagade da lalelegei. Amo dunu da gasa bagade hamobeba:le, dunu huluane da ilia hou nabi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Hina Gode da osobo bagade dunu ilia wadela:i hou bagade amo ba:lalu. Ilia asigi dawa:su da wadela:lesi dagoi. Ilia dogo ganodini wadela:i hou fawane dawa:lalu. Amo Gode da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Hina Gode da Ea musa: hou amo E da osobo bagadega esaloma:ne dunu fi hamoi, amo E da higale ba:i. Ea dogo ganodini se bagade nabi. ");
INSERT INTO beo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Amaiba:le Gode da amane sia:i. “Na da dunu fi hamoi dagoi be wali Na da huluane medole legemu. Dunu huluane, ohe fi, sania fi amola sio fi huluane Na da hamoiba:le hahawane hame gala. Amaiba:le, Na da huluane fane legemu.” ");
INSERT INTO beo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Be Hina Gode da dunu afae amo Nowa:, hahawane ba:i. (Amabela:? Sede egefelali - ilia da lafidili Gode dawa:i udigili sia:bela:?.) ");
INSERT INTO beo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nowa: ea sia: dedei da agoane. Nowa: da hou moloidafa dunu, e da wadela:i hame dawa:i. Ea fi amo ganodini, e da ida:iwane Gode amola gilisili lalu. ");
INSERT INTO beo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowa: da dunu mano udiana esalu amo Sieme, Ha:me amola Ya:ifede. ");
INSERT INTO beo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Be osobo bagadega dunu fi huluane ilia hou da wadela:lesi dagoi. Gegene nimi dasu bagade fawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dunu huluane da ilia hou wadela:lesiba:le, Gode da osobo bagade gugunufinisi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Amaiba:le, Gode da Nowa:ma amane sia:i, “Na da dunu fi huluane ebelema:ne medole legemu. Ilia hamobeba:le, osobo bagade da nimi bagade hou amola gegesu, amoga nabai gala. Amaiba:le, na da dunu fi amola osobo bagade gilisili gugunufinisimu. ");
INSERT INTO beo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Amaiba:le, di dusagai bagade amo ‘saibalase’ ifa amoga hamoma. Amo ganodini sesei hamoma. Ganodini amola gadili ea gadofo amoga edele agoai legema. ");
INSERT INTO beo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Dia dusagai agoane hiougima. Ea afo sedade defei da 133 mida amola ea da:iyamogoa dunumuni defei da 22 mida amola ea da:iyamogoa gado defei 13 mida. ");
INSERT INTO beo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gadodili figisu hamoma! Dusagai ea dobea fesa heda:le, figisu mae doaga:le dibi 44 sedamida agoane yolesima. Dusagai la:idi logo ga:su hamoma amola hada:i fa:i udiana agoane hamoma. ");
INSERT INTO beo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Na da esalebe liligi mu hagudu esala amo huluane mifo labe liligi wadela:ma:ne, hano bagade osobo bagadega iasimu. Osobo bagadega esalebe liligi huluane da bogogia:mu. ");
INSERT INTO beo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Be Na da dima gousa:su hamomu. Amalalu, di, dia manolali, dia uda, amola dia mano ilia uda da dusagai bagade ganodini golili sa:ima:mu. ");
INSERT INTO beo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Di esalebe liligi hisu hisu amo aduna - gawali amola aseme, amo esaloma:ne dusagai ganodini oule masa. ");
INSERT INTO beo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sio fi hisu hisu aduna aduna, ohe fi huluane aduna aduna, amola fi huluane da osoboga sugi ahoabe, amo huluane da aduna aduna di ouligima:ne, dima doaga:mu. ");
INSERT INTO beo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ha:i manu liligi huluane amola, di amola osobo bagade ohe fi huluane moma:ne, amo gilisima. ");
INSERT INTO beo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowa: da Gode Ea hamoma:ne sia:i defele, huluane hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Amalalu, Hina Gode da Nowa:ma amane sia:i, “Di amola dia sosogo fi huluane, amo dusagai bagade amoga golili sa:ima. Bai waha esalebe fi amo ganodini, Na da di fawane hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ohe fi hisu hisu liligi ledo hamedei amo gawali amola aseme amo fesuale agoane dusagai ganodini oule masa. Amola liligi ledo gala amo gawali amola aseme aduna aduna fawane oule masa. ");
INSERT INTO beo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Amola sio fi hisu hisu mae bogole osobo bagadega esaloma:ne, amo fesuale gawali amola aseme dusagai ganodini oule masa. ");
INSERT INTO beo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Eso fesuale aligili, Na da gibu bagade osobo bagadega iasimu. Gibu da eso 40 amola gasi 40 sa:imu. Amoga na da esalebe liligi huluane Na hamoi, amo huluane osobo bagadega mugululi fasimu. ");
INSERT INTO beo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowa: da Gode Ea hamoma:ne sia:i liligi huluane hamoi. ");
INSERT INTO beo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Hano bagade da osobo bagadega doaga:loba, Nowa: da ode 600 agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Amola Nowa:, ea manolali, ea uda amola ea mano ilia uda da hano bagade fisimusa:, dusagai ganodini fila heda:i. ");
INSERT INTO beo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ledo hamedei ohe fi amola ledo gala liligi aduna aduna, sio fi, osoboa sugi ahoasu liligi, ");
INSERT INTO beo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","gawali amola aseme amo huluane Nowa:ma misini, dusagai ganodini fila heda:i. Gode da Nowa:ma hamoma:ne sia:i, amo defele hamoi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Amola eso fesuale aligili galu, hano bagade da moi bagadega doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nowa: da ode 600 esalu. Amo ode ganodini, oubi ageyadu amola eso 17 - amo esoga, hano osobo hagudu dialu amo da fudagala:i amola mu amo ganodini gibu ea logo ga:su da fudagala:le, doasi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Eso 40 amola gasi 40 amoga gibu da osobo bagadega sa:i. ");
INSERT INTO beo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Amo esoga, Nowa: amola egefe udiana Sieme, Ha:me amola Ya:ifede, ea uda amola egefe ilia uda huluane da dusagaiga fila heda:i. ");
INSERT INTO beo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ilia da ohe fi hisu hisu, lai gebo amola sigua amola sania fi ilia osoboga sugi ahoa, amola sio fi huluane ilia da ougiga hagili ahoabe, amo huluane ilia da ganodini oule asi. ");
INSERT INTO beo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Gawali, aseme amola esalebe liligi huluane da mifo laha, amo huluane da Nowa:ma misini, dusagaiga fila heda:i. ");
INSERT INTO beo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ohe fi da ganodini ahoa amo huluane da gawali, aseme amola esalebe liligi huluanedafa, Gode da Nowa:ma sia:i amo defele. Amalalu, Nowa: da ganodini asi amola Gode da dusagai logo ga:si dagoi. ");
INSERT INTO beo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Gibu bagade da osobo bagadega sa:ili, eso 40 amanega dalu. Hano da leda:le, dusagai gaguia gadole bila sedagawane gado heda:i. ");
INSERT INTO beo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Hano da bagade hamoi amola bagade heda:i. Dusagai da hano da:iya mae magufale lalu. ");
INSERT INTO beo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Hano da bagade heda:le, goumi huluane mu haguduga dialu da dedeboi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Hano bagade heda:le, goumi huluane dedebole, bu 7 mida agoane heda:i. ");
INSERT INTO beo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Osobo bagadega esalebe liligi huluane, amo lai gebo, sogega esalu ohe fi, sio fi amola dunu fi huluane da bogogia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Liligi huluane da hafoga:i osobo bagadega esalu amola mifo lasu,, amo huluane da bogogia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Osobo bagadega esalebe liligi huluane da fadegale fasi dagoi ba:i. Dunu, ohe fi, osoboga sugi ahoasu liligi amola sio fi osobo bagadega hame ba:i. Be Nowa: hi fawane amola ea sosogo fi dusagai ganodini esalu, ilia fawane esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Hano bagade da osobo bagade dedeboi dialu eso 150 agoane dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Be Gode da Nowa:, ohe fi amola lai gebo fi dusagai ganodini esalu, amo hame gogolei. E da fo amo osobo bagadega asunasi. Amalalu, hano da halalu. ");
INSERT INTO beo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Hano hagudu dialu amo ea logo amola mu ea logo ga:si dagoi ba:i. Gibu da muagado dasu logo ga:i. ");
INSERT INTO beo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Hano da osobo bagade yolesili halalu. Eso 150 da dagoloba, hano da hai dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Eso 17 amola oubi fesu amoga, dusagai da A:lala:de Goumi amo da:iya ligisibi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Hano da mae yolesili hala dalu. Amalalu eso age amola oubi nabu amoga, goumi ilia dabuagado bi da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Eso 40 asili, Nowa: da fo misa:ne agenesi, e musa: hamoi liligi amo doasi. ");
INSERT INTO beo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","E da sio ea dio amo ‘la:ifene’, amo gadili asunasi. Amo sio da wa:le asili lalalu, hano da hafoga:i dagoiba:le fawane yolesi. ");
INSERT INTO beo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Amalalu, Nowa: da ‘dafe’ sio amo hano ea hasu hou ba:ma:ne asunasi. ");
INSERT INTO beo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Be hano da osobo huluane dedeboiba:le, ‘dafe’ da fila sa:imu gogolei. Amaiba:le, e da Nowa: dusagai ganodini ema buhagi. Nowa: da ea lobo da:legale amola dafe laleguda:le, dusagai ganodini bu sanasi. ");
INSERT INTO beo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","E da eso eno fesuale amo aligili, ‘dafe’ bu asunasi. ");
INSERT INTO beo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","‘Dafe’ da daeya amo ema bu misini, e da olife ifa lubi mini manebe ba:i. Amalalu, hano da hai dagoi, amo Nowa: da dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","E da eso eno fesuale amo aligili, ‘dafe’ bu asunasi. Be amo esoga ‘dafe’ da ema hame buhagi. ");
INSERT INTO beo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Eso age aligili, oubi age amo ode ganodini Nowa: da lalelegele, ea esalebe ode 601 amo gidigisia, hano da hai dagoi amola osobo bagade da hafoga:i dagoi ba:i. Nowa: da dusagai ea gisigisu fadegale, osobo da hafoga:i dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Eso No 27 amo oubi ageyadu amoga, osobo bagade da hafoga:idafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Amalalu, Gode da Nowa:ma amane sia:i, ");
INSERT INTO beo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Di, dia uda, dia egefelali amola ilia uda, amo dusagai yolesili, osoboga aligila sa:ima! ");
INSERT INTO beo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Esalebe liligi dia ouligisu amo sio, ohe fi amola liligi da osoboga sugi ahoa, ilia da fi hamone osobo bagade bu nabama:ne, amo gadili oule masa. ");
INSERT INTO beo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Amaiba:le, Nowa:, egefe udiana, ea uda, amola egefelali ilia udalali, da gadili asili, osoboga aligila sa:i. ");
INSERT INTO beo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ohe fi huluane amola liligi da osoboga sugi ahoasu amola sio fi huluane- liligi huluane osobo bagadega ahoanebe liligi da dusagai yolesili gadili asi. Ilia fi hisu hisu gilisisu hamone, gadili asi. ");
INSERT INTO beo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Amalalu, Nowa: da Hina Godema oloda hamoi. E da ledo hamedei ohe fi amola sio fi lale, gobele sali. ");
INSERT INTO beo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Hina Gode da amo gobele salasu ea gabusiga: nabi. E da Ea dogo ganodini agoane sia:i, “Osobo bagade dunu da degabo ea mano fonobahadi eso amola fa:no eso huluane wadela:i hou fawane dawa:lala. Be ea hou ba:beba:le, Na da hobea osobo bagadega gagabusu aligima:ne hame ilegemu. Amola esalebe liligi huluane Na waha medole legei dagoi, amo hou Na da bu hamedafa hamomu. ");
INSERT INTO beo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Osobo bagade da dialea, hawa: bugisu amola ha:i manu faisu, anegagi amola gia:su, esoi bagade oubi amola anegagi oubi amola, eso amola gasi da mae dagole dialumu. ");
INSERT INTO beo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Amalalu, Gode da Nowa: amola ea manolali ilima hahawane dogolegele sia:i. E amane sia:i, “Dilia mano bagohame lama. Dilia mano da osobo bagade soge huluane nabamu da defea. ");
INSERT INTO beo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ohe fi, sio fi amola menabo fi amola esalebe fi amo da osoboba:le ahoa, ilia huluane da dilima beda:mu. Dilia da ohe fi huluane ilima hinawane esalumu. ");
INSERT INTO beo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Na da musa: dadami fawane dilima ha:i moma:ne i dagoi. Be wali, dilia da amo ohe, sio amola menabo fi liligi huluane manu da defea. Na da amo huluane dili ha:i moma:ne iaha. ");
INSERT INTO beo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Be ha:i manu afadafa da dilima sema gala. Hu amo ganodini maga:me dialebe ba:sea, mae moma. Maga:me amo ganodini da esalusu gala. Amaiba:le, Na da amo liligi mae moma:ne sema ilegei. ");
INSERT INTO beo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nowa dunu da dunu eno fane legesea da se iasu ba:mu. Ohe fi da dunu fane legesea, amoma se iasu ima:ne, fane legema. ");
INSERT INTO beo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Osobo bagade dunu ilia da Gode Ea hou agoane hamoi dagoi. Amaiba:le, osobo bagade dunu da eno dunu fane legesea, amo dunu ema se iasu da eno osobo bagade dunu amoga fane legemu. ");
INSERT INTO beo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Dilia mano bagohame osobo bagade nabama:ne lama. ");
INSERT INTO beo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Amalalu, Gode da Nowa: amola ea mano ilima amane sia:i, ");
INSERT INTO beo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Na gousa:su Na da dilima amola diligaga fa:no lalelegemu mano dilima ilegesa. ");
INSERT INTO beo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Na da dilima amola esalebe liligi huluane, ohe fi amola sio fi - huluane amo dusagaiga gaga:i, amoma Na gousa:su hamosa. ");
INSERT INTO beo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Na gousa:su dilima da amo sia: ganodini gala. Hano bagade da esalebe liligi huluane bu hame fane legemu. Hano bagade da osobo bagade bu hame gugunufinisimu. ");
INSERT INTO beo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Wali na eso huluane dialumu gousa:su dilima amola esalebe liligi huluane amoma Na da dawa:digima:ne olelesu imunu. ");
INSERT INTO beo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Na da mu mobi ganodini dadi agoane (sona:ni) legemu. Amo da Na osobo bagadega gousa:su dawa:ma:ne agoane dawa:digima:ne olelesu gala. ");
INSERT INTO beo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Na da mu amo mu mobiga dedebosea, amola dilia da sona:ni sisiga:i ba:sea, ");
INSERT INTO beo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Na da Na musa: dafawane sia: bu dawa:mu. Amo da osobo bagadega esalebe liligi huluane medoma:ne, hano bagade da bu hamedafa misunu. ");
INSERT INTO beo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Sona:ni da mu mobi ganodini ba:sea, Na da Na eso huluane mae mugululi gousa:su Na da esalebe liligi osobo bagadega esala hamoi, amo bu dawa:ma. ");
INSERT INTO beo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Na da osobo bagadega esalebe liligi huluane ilima dafawane ilegele sia:i amo dawa:digima:ne olelesu da amo.” ");
INSERT INTO beo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowa: egefe udiana amo dusagaiga gadili asi da Sieme, Ha:me amola Ya:ifede. (Ha:me da Ga:ina:ne ea eda.) ");
INSERT INTO beo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nowa: ea mano udiana da osobo bagade esalebe fi osobo bagadega afagogoi, amo huluane ilima aowalali esalu. ");
INSERT INTO beo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa: da ifabi ouligisu dunu. E da degabo osobo bagadega waini efe sagasu. ");
INSERT INTO beo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","E da waini hano nanu, feloai ba:i. Amalalu, e da abula gisa:le, da:i nabadowane ea abula diasu ganodini dialu. ");
INSERT INTO beo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ha:me (Ga:ina:ne eda) da ea eda da:i nabado ba:i dagoi. E gadili asili, amo hou ea ola Sieme amola Ya:ifede elama olelei. ");
INSERT INTO beo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Be Sieme amola Ya:ifede da abula lale, ela gida amoga ligisili bagidiliwane misini, Nowa: ea da:i nabado dedeboi dagoi. Ela da Nowa: ea da:i nabado mae ba:ma:ne, ela odagi ga ba:legale misi. ");
INSERT INTO beo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nowa: da bu wa:legadole, adini ba:i bu hedofai ba:i. E da Ha:me (Ga:ina:ne eda) amo ea hou nabi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","E amane sia:i, “Ga:ina:ne amoma da gagabui aligi dagoi. E da ea yolalali ilia udigili hawa: hamosu dunu esalumu. ");
INSERT INTO beo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Gode da Sieme ea Hina Gode! Godema hahawane dogolegele nodoma! Ga:ina:ne da Sieme ea udigili hawa: hamosu dunu esaloma:mu. ");
INSERT INTO beo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Gode da Ya:ifede ea fi bu bagade heda:ma:ne fidimu da defea. Ya:ifede da Sieme ea abula diasu gilisisu ganodini esalumu da defea. Amola Ga:ina:ne da Ya:ifede ea udigili hawa: hamosu dunu esaloma:mu.” ");
INSERT INTO beo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Hano bagade amo misini, fa:no Nowa: da ode 350 eno esalu. ");
INSERT INTO beo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Amalalu, e bogoi. E da ode 950 agoane esalu bogoi. ");
INSERT INTO beo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hano bagade da yolesili, Nowa: ea mano Sieme, Ha:me amola Ya:ifede da manolali lai. ");
INSERT INTO beo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ya:ifede egefelali da agoane lalelegei. Ya:ifede ea mano da Goume, Ma:igoge, Ma:dai, Ya:ifa:ne, Diubale, Misege amola Dila:se. ");
INSERT INTO beo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goume ea dunu mano da A:segena:se, Laifa:de amola Dougama. ");
INSERT INTO beo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ya:ifa:ne egefelali da Ilaisia, Dasise, Gidimi amola Loudanimi. ");
INSERT INTO beo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Amo mano ilia fi da dusagai ouligisu hou hamone ilia fifi asi gala asili sia: hisu hisu hamosu). ");
INSERT INTO beo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ha:me egefelali da Gusia, Misala:ime, Fade amola Ga:ina:ne. ");
INSERT INTO beo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Gusia egefelali da Seba, Ha:fila, Sa:bada, Lama amola Sa:bediga. Lama egefela da Siba amola Dida:ne. ");
INSERT INTO beo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Gusia ea mano eno da Nimilode. E da asigilaloba, nimi bagade gegesu dunu hamoi. ");
INSERT INTO beo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","E da Hina Gode ba:ma:ne benea ahoasu dunu gasa bagade hamoi. Amaiba:le, musa: dunu da amane sia:su, “Hina Gode da di benea ahoasu dunu Nimilode defele hamomu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Moilai bai bagade ea soge Siaina ganodini da Ba:bilone, Elege, A:ga:de amola Ga:lene. ");
INSERT INTO beo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Amo soge yolesili, e da Asilia sogega asi. Amoga e da moilai bai bagade eno hahamone gagai amo Ninefe, Lihoubode, Ga:ila, ");
INSERT INTO beo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","amola Lisene. La:idi da Ninefe, la:idi da Ga:ila amola Lisene da moilai bai bagadedafa dogoa galu. ");
INSERT INTO beo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misala:ime ea mano da Ludaide fi, Anamaide fi, Lehabaide fi, Na:baduhaide fi, ");
INSERT INTO beo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Badalusaide fi, Gasaluhaide fi (amo fi amoga Filisidini fi da misi) amola Ga:fadolaide fi. ");
INSERT INTO beo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ga:ina:ne ea mano da Saidone (ea magobo mano), Hidaide fi, ");
INSERT INTO beo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebiusaide fi, A:moulaide fi, Gegasiaide fi, ");
INSERT INTO beo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Haifaide fi, Agaide fi, Sainaide fi, ");
INSERT INTO beo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Afadaide fi, Semalaide fi, Ha:imadaide fi. Fa:no Ga:ina:ne fi dunu huluane da afafai. ");
INSERT INTO beo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ga:ina:ne fi ilia soge olei da asili amo Saidone moilai bai bagade asili Gela asili Ga:isa moilai bai bagadega doaga:i. Amalalu, soge olei da Sodame moilai bai bagadega asili, Goumola moilai bai bagade amola A:dama moilai bai bagade amola Siboimi moilai bai bagade baligili, La:isia moilai bai bagadega doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amo dedei da Ha:me ea mano - ilia fi amola sia: hisu hisu amola sogebi da sosogo bagade ba:i. ");
INSERT INTO beo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sieme da Ya:ifede ea ola esalu. Sieme da Hibulu dunu fi huluane amo ilia aowalali eda. ");
INSERT INTO beo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sieme egefelali da Ila:me, A:sie, Afa:gasa:de, Lade amola A:ila:me. ");
INSERT INTO beo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","A:ila:me egefelali da Ase, Hale, Gidie amola Misiege. ");
INSERT INTO beo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Afa:gasa:de ea mano da Sila amola Sila ea mano da Ibe. ");
INSERT INTO beo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ibe da dunu mano aduna lai. Afae ea dio amo Bilege (Bai e esalea osobo bagade da afafai ba:i). Bilege ea eya dio amo Yogada:ne. ");
INSERT INTO beo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yogada:ne ea mano da A:lamouda:de, Silefe, Ha:isama:ifede, Yila, ");
INSERT INTO beo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoula:me, Usa:le, Digala, ");
INSERT INTO beo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ouba:le, Abima:ile, Siba, ");
INSERT INTO beo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Oufe, Ha:fila amola Youba:be. Amo huluane da Yogada:ne ea mano. ");
INSERT INTO beo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ilia esalebe soge da goumi gusudi soge ea ole da Misia alalo asili Sifa doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Amo dedei da Sieme ea mano - ilia fi, sia: hisu hisu, ilia sogebi amola ilia soge da bagade ba:i. ");
INSERT INTO beo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Huluane da Nowa: ea mano ilia fi amo ilia sosogo fi amo ganodini amola fi gilisisu ilia hamoi. Amo fi amoga fi gilisisu huluane da hano bagade fa:no hamone, afafane osobo bagade nabasu. ");
INSERT INTO beo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Amo esoga, osobo bagade dunu fi da sia: hisu hisu hame galu. Ilia huluane da sia: afadafa fawane galu. ");
INSERT INTO beo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Dunu fi huluane da eso maba gusudili ahoanu, umi soge ea dio amo Ba:bilone ba:i. Amo ganodini ilia fi dialu. ");
INSERT INTO beo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ilia da amane gilisili sia: dasu, “Defea! Ninia osobo ganumugini, gobele, igi agoai ‘baligi’ hamone, diasu gagumu.’ Amola amo liligi ‘baligi’ ilia da edele amoga madelagisu. ");
INSERT INTO beo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Amalalu, ilia da amane sia:i, “Ninia moilai bai bagade hamomu. Amo ganodini ninia da diasu sedade gagagula heda:i amo da Hebene amoga doaga:mu liligi gagumu. Ninia dio bagade hamomu. Ninia fi da osobo bagade soge huluane amoga afafasa:besa:le agoane hamomu. ");
INSERT INTO beo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Be Hina Gode da moilai bai bagade amola diasu gado gagagula heda:i amo dunu da hamonanu, amo ba:la gudu sa:i. ");
INSERT INTO beo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","E amane sia:i, “Ilia da fi afadafa amola sia: afadafa gala. Amo ilia da muni hamobeba:le, hobea huluane ilia hanaiga hamomusa: dawa:mu. ");
INSERT INTO beo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Defea! Ninia da gudu sa:ili, ilia sia: ededenagia:mu. Amasea, ilia sia: hisu hisu amoga sia:sea, nabimu gogolemu.” ");
INSERT INTO beo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Amaiba:le, Gode da dunu fi afagogole, osobo bagade dedeboma:ne asunasi. Ilia amo diasu gagagula heda:i gagumu yolesi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Amaiba:le, amo diasu ilia da Ba:ibele dio asuli. Bai amoga Hina Gode da ilia sia: hisu hisu hamoi, amola ili afagogole, osobo bagade soge huluane fima:ne asunasi. ");
INSERT INTO beo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sieme ea mano da hagudu dedei. Hano bagade da yolesili, ode aduna asili, Sieme da ode 100 esalu, ea dunu mano amo Aba:sa:de da lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Amalalu, Sieme da ode 500 eno esalu. Amoga e da manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aba:sa:de da ode 35 esalu, dunu mano amo ea dio Sila amo lai. ");
INSERT INTO beo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Fa:no e da ode 403 eno esalu amola amoga manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sila da ode 30 esalu, dunu mano ea dio Ibe amo lai. ");
INSERT INTO beo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Fa:no e da ode 430 eno esalu. Amoga e da manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ibe da ode 34 esalu, dunu mano amo ea dio Bilege lai. ");
INSERT INTO beo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Fa:no Ibe da ode 430 eno esalu. Amo odega e da egefelali eno lalelelegei amola uda manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Bilege da ode 30 esalu, dunu mano ea dio amo Liu lai. ");
INSERT INTO beo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Bilege da Liu lai amalu ode 209 eno esalu. Amoga e da egefelali eno lalelelegei amola uda manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Liu da ode 32 esalu, dunu mano ea dio amo Silage lai. ");
INSERT INTO beo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Liu da Silage lai amalu fa:no e da ode 207 esalu. Amoga e da dunu manolali eno lalelelegei amola uda manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Silage da ode 30 esalu, dunu mano ea dio amo Na:iho lai. ");
INSERT INTO beo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Silage da Na:iho lai amalu fa:no e da ode 200 eno esalu. Amoga e da dunu manolali eno lalelelegei amola uda manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Na:iho da ode 29 esalu, dunu mano ea dio amo Dila lai. ");
INSERT INTO beo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","E da Dila lai amalu fa:no ode 119 esalu. Amoga, e da dunu manolali eno lalelelegei amola uda manolali eno lalelelegei. ");
INSERT INTO beo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Dila da ode 70 esalu, dunu mano udiana lai amo A:ibala:me, Na:iho amola Ha:ila:ne. ");
INSERT INTO beo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Dila egaga fi da agoane. Ea mano da A:ibala:me, Na:iho amola Halane. Halane ea mano da Lode. ");
INSERT INTO beo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Halane da ea moilaidafa (moilai dio da E, Ba:bilone soge ganodini dialu) amoga bogoi. E bogoloba, ea ada Dila da esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","A:ibala:me da Selai lai amola Na:iho da Miliga lai. Miliga ea ada da Halane. Halane idiwi eno da Isiga. ");
INSERT INTO beo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Selai da aligime esalu. Mano lamu hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Dila da egefe A:ibala:me, eaowa Lode (Halane ea mano) amola ea nawi Selai (A:ibala:me idua) amo oule asili, Ba:bilone soge moilai amo E yolesili, Ga:ina:ne sogega doaga:musa: asi. Be ilia da Halane sogega doaga:le, fi galu. ");
INSERT INTO beo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Dila da amogawi bogoi. Ea esalu ode idi da 205 ba:i. ");
INSERT INTO beo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Gode da A:ibala:mema amane adole i, “Dia soge, dia fi amola dia ada diasu amo yolesili, soge enoga masa. Dia fimu soge na da dima olelemu. ");
INSERT INTO beo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Na da dima mano bagohame imunu. Dia mano fifi misunu da hobea bagadewane fi dialumu. Na da dima hahawane dogolegemu amola dia dio gasi gadomu. ");
INSERT INTO beo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nowa dunu da dima hahawane dogolegele fidisia, amo dunu Na da hahawane dogolegele fidimu. Be nowa dunu da dima gagabusu aligima:ne sia:sea, Na da ilima gagabusu aligima:ne sia:mu. Dia hou amo ganodini na da osobo bagade fifi asi gala dunu huluane ilima hahawane dogolegesu imunu.” ");
INSERT INTO beo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","A:ibala:me da ode 75 lai dagoi. Amalalu e da Gode Ea adoi defele Ha:ila:ne moilai yolesili asi. Lode amola da sigi asi. ");
INSERT INTO beo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","A:ibala:me da ea uda Selai, eaowa Lode amola ea liligi gagui huluane aguni amola ea udigili hawa: hamosu dunu amo e da Ha:ila:ne moilaiga lai, amo huluane oule asili, Ga:ina:ne moilaiga doaga:musa: asi. Ahoana, ilia da Ga:ina:ne sogega doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","A:ibala:me da Ga:ina:ne soge ganodini ahoanu, sema ifa amo ea dio Mole amo Siegeme moilai bai bagade ganodini galu amoga doaga:i. (amo esoga Ga:ina:ne dunu da amo soge ganodini esalu) ");
INSERT INTO beo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Gode da A:ibala:mema misini amane sia:i, “Na da amo soge, digaga fi ilima imunu.” Amalalu, A:ibala:me da Hina Gode ba:i dagoiba:le, e da Godema nodoma:ne oloda hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Amalalu, e da ga (south) asili, goumi soge amo da Bedele moilaiga gusu dialu, amoga abula diasu gagui. Ea moilai da Bedele moilai amo guma: amola A:iai moilai gusuli dogoa dialebe ba:i. Amo sogebiga e da oloda eno hamone, Godema nodoi. ");
INSERT INTO beo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Amalalu e da amo soge yolesili, sogebi eno amola sogebi eno amoga asili Ga:ina:ne soge ga (south) la:ididili doaga:musa: ahoanu. ");
INSERT INTO beo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Gibu da hame sa:iba:le, ha:i bagade doaga:i. Ha:i bagadeba:le, A:ibala:me da Idibidi sogega fonobahadi esalumusa: asi. ");
INSERT INTO beo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","E da Idibidi soge bega: doaga:loba, e da idua Selai ema amane sia:i, “Di da uda ida:iwane ba:sa amo na dawa:. ");
INSERT INTO beo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Idibidi dunu da di ba:sea amane sia:mu, ‘Amo da ea uda.’ Amasea, ilia da na fane legemu be di esaloma:ne yolesimu. ");
INSERT INTO beo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Amaiba:le di da na dalusi ilima sia:ma. Amasea, ilia nama hahawane hamomu amola ilia dima asigiba:le, na hame fane legemu. ");
INSERT INTO beo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","A:ibala:me da Idibidi sogega doaga:loba, Idibidi dunu da Selai da uda isisima:goi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Felou ea hou ouligisu dunu da Selai ba:loba, ilia da ea hou Felouma nodoi. Amanoba Felou da Selai ea diasu esalumusa: oule misi. ");
INSERT INTO beo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Felou da Selaima dawa:beba:le, Felou da A:ibala:me hahawane fidi. Amalalu, A:ibala:me da sibi, bulamagau, dougi (gawali amola aseme), hawa: hamosu (dunu amola uda) amola ga:mele lai. ");
INSERT INTO beo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Be Hina Gode da Felou amola ea diasuga esalebe fi ilima olo bagade iasi. E da A:ibala:me ea uda Selai laiba:le, amo olo iasi. ");
INSERT INTO beo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Amaiba:le, Felou da A:ibala:me ema misa:ne sia:i. E amane sia:i, “Di da nama adi hamobela:? Amo da dia uda. Abuli hame adobela:? ");
INSERT INTO beo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Di da abuli ‘amo da na dalusi!’ sia:bela:? amalalu amo uda na da lai dagoi. Defea! Dia uda da goea. Lale masa!” ");
INSERT INTO beo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Felou da ea ouligisu hina dunu ilima sia:beba:le, ilia A:ibala:me amola idua amola ea gagui liligi huluane gadili asunasi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","A:ibala:me da Idibidi yolesili, gano asili, Ga:ina:ne soge amo ga (south) la:idi doaga:i. E da ea uda amola Lode oule, ea liligi huluane aguni asi. ");
INSERT INTO beo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","A:ibala:me da bagade gagui dunu esalu. E da sibi, goudi, bulamagau, silifa amola gouli bagohame gagui galu. ");
INSERT INTO beo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Amalalu, amo soge yolesili asili, e da eno soge eno soge amoga asili, Bedele moilaiga doaga:musa: logo amoga asi. E da sogebi amo Bedele amola A:iai dogoa dialu, amoga e da musa: abula diasu moilai gaguia, amoga doaga:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Amo sogebi e da musa: oloda gagui galu. E da amo sogebi Hina Godema nodone sia:ne gadoi amola Hina Gode Ea Dioba:le Ema wei. ");
INSERT INTO beo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lode da sibi, goudi, amola bulamagau gaguiwane, A:ibala:mela lalu. Ea sosogo fi dunu amola ea hawa: hamosu dunu amogawi esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Amaiba:le, lai gebo bagohame esalebeba:le, ela da gilisili esaloma:ne sogebi amola gisi da fonabahadi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Amaiba:le, A:ibala:me ea lai gebo ouligisu dunu amola Lode ea lai gebo ouligisu dunu da sia:ga gegei. (Amo esoga, Ga:ina:ne fi amola Bilese fi da amo soge ganodini esalu) ");
INSERT INTO beo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Amalalu, A:ibala:me da Lodema amane sia:i, “Ani da fidafa. Amaiba:le, ania hawa: hamosu dunu sia:ga gegemu da defea hame galebe. ");
INSERT INTO beo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ania afafamu da defea. Di fawane sia:ma! Dia hanai soge, di ilegema. Di da guma: soge lamusa: dawa:sea, defea, na da gusu lamu. Di da gusu lamusa: dawa:sea, na da guma: lamu.” ");
INSERT INTO beo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lode da la:ididili amola la:ididili ba:lalu, e da Yodane Hano bega: soge huluane amo asili Soua moilaiga doaga:i. Amo hano la:ididili umi ida:iwane soge da hano bagade dialu, Idini Ifabi amola Idibidi soge amo defele ba:i. (Amo esoga Gode da Sodame amola Goumola hame wadela:lesi) ");
INSERT INTO beo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Amaiba:le, Lode da Yodane Hano umi soge lamusa: ilegei. E da eso maba la:ididili amoga asili, A:ibala:mema afafai. ");
INSERT INTO beo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","A:ibala:me da Ga:ina:ne sogega esalu. Be Lode da moilale gagai amo Yodane Hano umiga dialu, amo dogoa fi galu. E da Sodame moilai bai bagade gadenenewane fi. ");
INSERT INTO beo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodame dunu da Gode Ea hou higa:iba:le, wadela:i bagade hamosu dunu fi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lode da afafane asi ba:loba, Hina Gode da A:ibala:mema amane sia:i, “Defea! Di soge huluane ba:ma! Eso maba la:ididili amola eso dabe gududili huluane ba:ma. ");
INSERT INTO beo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Amo soge huluanedafa Na da di amola digaga lalelegemu fi ilima imunu. Amo soge da di amola dia fi eso huluane mae yolesili dilia soge dialumu. ");
INSERT INTO beo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Na da dima mano bagohame imunu. Osobo bagade dunu da ilia idi idimu hamedeiwane ba:mu. Osobo dou afae afae idimu da hamedei. Amo defele digaga mano lalelegemu amo idimu da hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Na da amo soge huluane dima imunu. Amaiba:le, amo soge huluane abodela masa. ");
INSERT INTO beo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Amalalu, A:ibala:me da ea abula diasu mugululi, asili amo sema ifa ea dio amo Ma:malei amo Hibalone moilai bai bagade gadenene fi galu. Amogai e da Godema gobele salasu fafai (oloda) hamoi. ");
INSERT INTO beo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Amo esoga soge hina bagade dunu biyadu amo A:malafele (Saina hina bagade), A:lioge (Ela:isa soge hina bagade), Gedola:ioume (Ila:me soge hina bagade) amola Daida:le (Goimi soge hina bagade), ");
INSERT INTO beo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ilia da soge hina bagade dunu biyale gala ilima gegei. Amo hina bagade dunu da Bila (Sodame hina bagade), Besia (Goumola hina bagade), Siaina:be (A:dama hina bagade), Siemibe (Siboimi hina bagade) amola hina bagade amo da Bila (eno dio Soua) moilai bai bagade ouligisu. ");
INSERT INTO beo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Amo soge hina bagade dunu ilia da gilisili gegemusa:, Sidimi soge (amo da la:idi goumi la:idi goumi, dogoa umi) amo ganodini gilisi. Amo sogega, sali hano wayabo bagade (Bogoi Hano Wayabo) ba:i. ");
INSERT INTO beo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ode 12 amoga, Gedola:ioume da ilima hina bagade esalu. Be ode 13 amoga, ilia da ea hina hou higa:iba:le, odoga:ne, ea hina hou yolesimusa: dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ode 14 amoga, Gedola:ioume amola ea fidisu hina bagade dunu da asili, gegene, dunu fi biyaduyale amo hasali. Amo fi da Lefa:ime (ilia soge da A:sadelode Gana:ime), Susimi fi (ilia soge da Ha:me), amola Imimi fi (amo fi udiana ilia da Giliada:ime umi sogega hasalasi), ");
INSERT INTO beo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","amola Houlaide fi (ilia soge da agolo soge amo Sie). Amo dunu ilia da sefasili, Elebalane wadela:i hafoga:i soge bega: fisi. ");
INSERT INTO beo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Amalalu, Gedola:ioume amola ea fidisu dunu da sinidigili, Enemisaba:de (eno dio Ga:idsie) amoga asi. Amoga ilia da Ama:legaide dunu huluane hasalili, ilia soge fedele lai. Ilia da A:moulaide dunu amo da Ha:sasoneda:ima moilai bai bagade amo ganodini esalu, amo hasalasi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Amalalu Sodame hina bagade, Goumola hina bagade, A:dama hina bagade, Seloimi hina bagade, Bila (Soua) hina bagade amola ilia dadi gagui huluane da misini, Sidimi umiga gegemusa: dada:lele gilisi. ");
INSERT INTO beo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ilia da Gedola:ioume (Ila:me hina bagade), Daida:le (Goimi hina bagade), A:malafele (Saina hina bagade), A:lioge (Ela:isa hina bagade), ilima gegemusa: misi. Hina bagade dunu biyale gala da hina bagade dunu biyaduyale gala ilima gegemusa: dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidimi umi da uli dogoi amo edele agoai liligi amoga nabai, bagohame dialebe ba:i. Sodame hina bagade amola Goumola hina bagade hobeale ahoanoba, ilia dadi gagui dunu mogili da amo uli dogoi ganodini dafai, mogili da goumiga hobeale asi. ");
INSERT INTO beo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Soge hina bagade biyaduyale ilia da Sodame amola Goumola, ilia liligi amola ilia ha:i manu huluane lale, gaguli asi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lode da Sodame moilaiga esalu. Amo gegesu dunu da Lode amola ea liligi huluane gagulaligili asi. ");
INSERT INTO beo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Dunu afae ilia afugili asi amo da hobea:i, e da A:ibala:me (Hibulu hina bagade) ema amo hou adole i. A:ibala:me da Ma:malei (A:moulaide dunu) amo ea sema ifa soge ganodini esalu. Ma:malei eya da Esagole amola A:ine. Ilia da gilisili A:ibala:me amola lalu. ");
INSERT INTO beo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","A:ibala:me da ea fi dunu Lode amo ilia afugili lai nababeba:le, e da dunu 318 amo da ea fi ganodini lalelegei, amo lale amola hina bagade dunu biyaduyale galu ilima fa:no bobogele, Da:ne sogega doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Gasi ganodini, A:ibala:me da ea fi dunu afafane, gegene, amo dunu sefasilalu, Houba moilai Dama:sagase moilai bai bagadega gagoe (north) dialu amoga fawane fisi. ");
INSERT INTO beo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","E da liligi wamolai huluane bu lai. E da ea fi dunu Lode, ea liligi, uda huluane amola eno dunu huluane bu oule misi. ");
INSERT INTO beo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","A:ibala:me da Gedola:ioume amola ea fidisu hina bagade dunu huluane fane lelegelalu, buhagimusa: logoga ahoanoba, Sodame hina bagade dunu da A:ibala:me gousa:musa:, Sia:ife umi (eno dio da ‘hina bagade ilia umi’) amoga misi. ");
INSERT INTO beo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Amalalu, Sa:ileme moilai bai bagade (amo ea dio da wali Yelusaleme) amo ea hina bagade dunu ea dio amo Melegisidege da agi amola waini gaguli misi. Melegisidege da Gode Gadodafa amo Ea gobele salasu dunu esalu. ");
INSERT INTO beo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melegisidege da Gode da A:ibala:me hahawane dogolegele ima:ne amane sia:i, “Gode Gadodafa Hebene amola osobo bagade Hahamosu amo da A:ibala:me hahawane dogolegele ilegesu imunu da defea. ");
INSERT INTO beo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Amola Gode Gadodafa da dima ha lai amo di osa:le heda:ma:ne dima i dagoiba:le, Ema hahawane nodomu da defea.” Amalalu, A:ibala:me da Melegisidegema ‘daide’ (ea gegene lai liligi 10 agoane momogili afadafa) i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodame hina bagade dunu da A:ibala:mema amane sia:i, “Na da na fi dunu amola uda bu lamu. Be di liligi huluane disu lama.” ");
INSERT INTO beo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Be A:ibala:me da Sodame hina bagade ema bu adole i, “Na da Hina Gode Gadodafa, osobo bagade Hahamosu Ema dafawanedafa ilegele sia:sa. ");
INSERT INTO beo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Na da dia liligi hamedafa lamu. Liligi fonobahadi afae, nodomesu efe o emo salasu ea la:gisu, na da hame lamu. Di da fa:no, ‘Na iabeba:le, A:ibala:me da bagade gagui.’ Di da amo sia:sa:besa:le na da hame lamu. ");
INSERT INTO beo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Be na fi dunu ilia ha:i manu mai amola eno fi amo da na sigi asi - amo A:ine fi, Esagole fi amola Ma:malei fi dunu - ilia fawane da ilia bidi defele lamu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Amo hou fa:no, A:ibala:me da Gode sia: esala ba:su ganodini nabi. Gode da amane sia:i, “A:ibala:me! Mae beda:ma! Na da dima Gaga:su esala. Na da dima baligili bidi ida:iwane imunu.” ");
INSERT INTO beo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Be A:ibala:me da bu adole i, “Ouligisu Hina Bagadedafa! Di da nama habodane ima:bela:? Na da mano hame lai. Na bogosea, na hawa: hamosu dunu, Dama:sagase dunu amo Elia:isa amo da na nana liligi huluane lamu.” ");
INSERT INTO beo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Amola A:ibala:me amane sia:i, “Di da mano nama hame iba:le, na hawa: hamosu dunu fawane da na nana liligi huluane lamu.” ");
INSERT INTO beo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Amalalu, Hina Gode Ea sia: ema amane misi, “Amo dunu da dia nana liligi hamedafa lamu. Be diagofedafa amo dia da:i hodo hamoi, hi fawane da dia nana liligi lamu.” ");
INSERT INTO beo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Gode da A:ibala:me gadili oule asili, amane sia:i, “Muagado ba:legadoma! Gasumuni idima! Be huluane idimu da hamedei.” Amalalu, E da ema amane sia:i, “Dia mano ilia da amo gasumuni ilia idi defele ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","A:ibala:me da Hina Gode dafawaneyale dawa:i galu. Amaiba:le, Gode da A:ibala:me ea hou moloidafa hamoi defele ba:i. ");
INSERT INTO beo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","E da bu A:ibala:mema amane sia:i, “Na da Hina Godedafa. Na da di Ga:ladia fi moilai bai bagade E, amoga fisili masa:ne, amo soge lalegagumusa: guiguda: oule misi.” ");
INSERT INTO beo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Be A:ibala:me amane sia:i, “Hina Gode Ouligisudafa! Na da amo soge lalegagumusa: habodane dawa:ma:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Amaiba:le, Hina Gode da ema amane sia:i, “Di bulamagau aseme, goudi amola sibi gawali amo huluane da ode osodoyale baligi, amo gaguli misa. Amola ‘dafe’ sio amola musuni sio gaguli misa. ");
INSERT INTO beo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","A:ibala:me da amo liligi huluane gaguli misini, dogoa oudahida:le, la:idi afae la:idili ligisili, eno afae eno la:idili legei. Be sio e da dogoa hame oudahida:i. ");
INSERT INTO beo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Amalalu, gasa bagade sio buhiba eno ilia da amo liligi wamolamusa: misi. Be A:ibala:me da amo sio sefasi. ");
INSERT INTO beo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Eso da daloba, A:ibala:me da golai nanabunina asi ba:i. Amoga e da gasi dunasi bagade ba:beba:le, bagadewane beda:i galu. ");
INSERT INTO beo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Amalalu, Hina Gode da ema amane sia:i, “Hou noga:le dawa:ma! Dia fa:no lalelegemu fi da eno dunu ilia soge ganodini, udigili hawa: hamosu dunu agoane esalumu. Ode 400 agoane, ilia da amo soge ganodini se nabawane esalumu. ");
INSERT INTO beo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Be Na da fa:no ilima se iabe dunu fi ilima se iasu bidi imunu. Dia fi da fa:no amo soge yolesili, gadili masunu. Ilia da liligi bagade gagumu. ");
INSERT INTO beo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Be di da ode bagohame esalu, gagoalumu, olofoiwane dia aowalali amoga bu masunu. Dia da:i hodo da bogole, uli dogoi ganodini ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Be dia fi da asili, fi biyaduyale fifilai dagosea, ilia da guiguda: bu misunu. A:moulaide dunu ilia wadela:i hou da Na se iasu defei lama:ne amoga hame doaga:iba:le, dia fi da ode agoane aligili, bu misunu. ");
INSERT INTO beo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Eso da gudu sa:i dagoi, amola gasi da doaga:loba, ganagu amoga mobi heda:lebe ba:i amola hanu gadodili nene, amo da lai gebo hu dadega:i gilisisu amo ganodini udigili asi. ");
INSERT INTO beo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Amo esoga, Hina Gode da A:ibala:mema gousa:su hamoi. E amane sia:i, “Soge amo ea defei da Idibidi hano asili hano bagadedafa ea dio amo Iufala:idisi amoga doaga:le, amo soge huluane Na da dia mano fi ilima iaha. ");
INSERT INTO beo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Amo soge ganodini dunu fi esalebe da Ginaide, Genisaide, Gadamunaide, ");
INSERT INTO beo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hidaide, Belisaide, Lefa:ide, ");
INSERT INTO beo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","A:moulaide, Ga:ina:naide, Gegasaide amola Yebusaide - amo dunu fi huluane ilia soge, Na da digaga fi ilima imunu.” ");
INSERT INTO beo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","A:ibala:me idua Selai da ema mano hame lai. E da aligime esalu. Be Idibidi hawa: hamosu a:fini ea dio amo Ha:iga da Selai ea fidisu esalu. ");
INSERT INTO beo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Amaiba:le Selai da A:bala:mema amane sia:i, “Hina Gode da hamobeba:le, na da mano lamu hamedei. Di amola na hawa: hamosu a:fini gilisili golama. Amo hou hamobeba:le, na da mano lamu.” A:ibala:me da Selai ea sia: da defea dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Amaiba:le, A:ibala:me da Ga:ina:ne soge ganodini ode 10 esalu, Selai da ea Idibidi hawa: hamosu a:fini amo Ha:iga amo A:ibala:me ema doaga:ma:ne, ema i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","E da Ha:iga amola gilisili golale, Ha:iga da mano lale abula agui ba:i. Ha:iga da ea abula agui dawa:beba:le, hidale ea hina Selai amo higale ba:i. ");
INSERT INTO beo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Amalalu, Selai da A:ibala:mema amane sia:i, “Di fawane da wadela:le hamobeba:le, na da se naba. Na da na hawa: hamosu a:fini dima i dagoi. Amola wali e da abula agui amo dawa:beba:le, nama higasa. Hina Gode Hifawane da sia:mu. Na hou da defeala: o dia hou da defeala:? Na hihi gala mabu.” ");
INSERT INTO beo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","A:ibala:me da bu adole i, “Defea! Dia hawa: hamosu a:fini da dia lobo ganodini gagui. Dia hanaiga ema hamoma.” Amalalu, Selai da Ha:igama se iasu. Ha:iga da se nababeba:le, hobea:i. ");
INSERT INTO beo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hobeale, e da gu hano amo logo gadenene galu doaga:i. Amoga, a:igele dunu da ema misi. ");
INSERT INTO beo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","E da Ha:igama amane sia:i, “Ha:iga! Selai ea hawa: hamosu a:fini! Di da habidili misibala:? Amola habidili masa:bela:?” Ha:iga da bu adole i, “Na da na ouligisu Selai amo yolesimusa: hobealala.” ");
INSERT INTO beo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Hina Gode Ea a:igele dunu da Ha:igama amane sia:i, “Dia hinama buhagili, ea sia: noga:le nabima!” ");
INSERT INTO beo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","E eno amane sia:i, “Na da dia mano fi bagadedafa hamomu. Amaiba:le, ilia idimu defei da hamedei agoane ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Hina Gode Ea a:igele dunu da eno ema amane sia:i, “Dia hagomo ganodini da mano esala. Di da dunu mano lalelegemu. Hina Gode da dia se nabasu nababeba:le, di da ema Isiama:ile dio asulima. ");
INSERT INTO beo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","E da nimi dougi defele ba:mu. E da dunu huluane ilima ha lai ba:mu. Amola dunu huluane da ema ha lai ba:mu. E da eaeya huluane ilima ha laiwane ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ha:iga da Hina Godema eno dio asuli. E amane sia:i, “Di da ‘Gode na Ba:lala’. Na da wali ‘Gode na Ba:lala’, amo ba:i dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Amaiba:le, hano nasu amo da Ga:idisie amola Bilede dogoa diala-amoma ilia dio sia:sa amo. “Esalebe Hina Gode E da na ba:lala amo Ea Hano.” ");
INSERT INTO beo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Amalalu, Ha:iga da A:ibala:mema dunu mano lalelegei. A:ibala:me da amo mano e lai ema Isiama:ile dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ha:iga da A:ibala:mema mano i, amo esoga A:ibala:me ea lalelegele ode esalu defei da 86 galu. ");
INSERT INTO beo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","A:ibala:me ea lalelegei ode 99 da gidigiloba, Hina Gode da ema misini, amane sia:i, “Na da Gode Bagadedafa. Di da Na hadigi ganodini ahoanoma amola hou moloidafa fawane hamoma. ");
INSERT INTO beo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Na da ania gousa:su hamoi amo dafawane hamomu. Na da digaga dunu bagohame dima imunu.” ");
INSERT INTO beo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","A:ibala:me da beguduli ea odagiga osobo digila sa:i. Amalalu, Gode da ema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Na gousa:su dima da agoane. Di da dunu fi bagohame ilima eda agoane ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Na da di dunu fi bagohame ilima eda hamoi dagoiba:le, wali dia dio da A:ibala:me hame, be bu afadenene A:ibalaha:me hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Di da mano bagohame lamu. Di da dunu fi bagohame lamu, amola fi hina bagade dunu bagohame di da lamu. ");
INSERT INTO beo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Na gousa:su Na da di amola digaga mano dilima Na da hamomu, da mae dagole dialalalumu. Na da dia Gode esalumu amola digaga mano huluane ilia Gode esalumu. ");
INSERT INTO beo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Di da wali Ga:ina:ne soge ganodini ga fi dunu agoane ba:sa. Be amo soge huluane, di eso huluane mae yolesili gagulaloma:ne, Na da di amola dia fa:no lalelegemu manolali dilima imunu. Amola Na da ilia Gode esalumu.” ");
INSERT INTO beo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Amalalu, Gode da A:ibalaha:mema amane sia:i, “Be di da Na gousa:su noga:le ouligima. Di amola digaga fa:no lalelegemu fi. ");
INSERT INTO beo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Na gousa:su dima amola dia manolali ilima - amo gousa:su di noga:le agoane ouligima. Dunu huluane dia fi amo ganodini da ilia gadofo damuma:mu. ");
INSERT INTO beo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Dilia huluane gadofo damuma:mu. Amo da Na gousa:su dilima amo dawa:digima:ne olelesu gala. ");
INSERT INTO beo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Dunu huluane dia fi ganodini fa:no lalelegesea, dunu mano huluane da lalelegesea, eso godoane fisili ilia gadofo damuma:mu. Amo da huluanedafa - dia fi amo ganodini lalelegei amola dunu mano ga fi amoga bidilai, amo huluane. ");
INSERT INTO beo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Dia fi amo ganodini lalelegei o ga fi ilima bidi lai - huluane. Na gousa:su defei dilia hu amo ganodini hamoi da eso huluane mae dagole dialalalumu. Amo da Na dilima gousa:su hamoi dagoi olelesa. ");
INSERT INTO beo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Be nowa dunu da dia fi amo ganodini ea hu gadofo hame damui ba:sea, amo dunu da Na gousa:su fi dagoiba:le, fadegale fasima.” ");
INSERT INTO beo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Gode da A:ibalaha:mema eno amane sia:i, “Dia uda Selai ema Selai dio bu mae sia:ma. Ea dio da wali Sela. ");
INSERT INTO beo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Na da ema hahawane dogolegele ilegemu. Amola e da diagofe lalelegemu. E da dunu fi bagohame ilima eme esalumu. Dunu fi hina dunu bagohame da ema lalelegemu.” ");
INSERT INTO beo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","A:ibalaha:me da beguduli ea odagiga osobo digila sa:ili, hahawane bagade ousu. E da ea dogo ganodini amane sia:i, “Dunu da 100 ode lai, amo mano lamu da defelela:? Sela amola da ode 90 lai dagoiba:le, mano lama:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","E da Godema amane adole ba:i, “Isiama:ile da na fi ganodini na sogebi lamu da defeala:?” ");
INSERT INTO beo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Be Gode bu adole i, “Hame mabu! Dia uda Sela da dia manodafa dia da:i amoga hamoi, amo lalelegemu. Di da ema Aisage dio asulima. Na da Na gousa:su ema amola egaga mano ilima hamoi, amo hamedafa yolesimu. Amo gousa:su da mae dagole eso huluane dialalalusu liligi. ");
INSERT INTO beo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Dia adole ba:su amo Isiama:ile fidima:ne Na da nabi dagoi. Amaiba:le, Na da ema amola hahawane dogolegele ilegemu. Na da ema mano bagohame imunu. Ema da fi hina bagade dunu fagoyale amo lalelegemu, amola ea mano da dunu fi bagadedafa hamomu. ");
INSERT INTO beo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Be Na gousa:sudafa da dia mano Aisage ema dialumu. Waha oubi wewaba amo ode enoga e da Selama lalelegemu.” ");
INSERT INTO beo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Gode da A:ibalaha:mema sia:i dagoiba:le, yolesili asi. ");
INSERT INTO beo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Amo esoga A:ibalaha:me da hedolo nabasu hou hamoi. E da Isiama:ile amola ea fi dunu huluane amola dunu da ea fi amo ganodini lalelegei amola udigili hawa: hamosu dunu e bidi lai, amo huluane ilia gadofo damui. ");
INSERT INTO beo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","A:ibalaha:me da lalelegele, ode 99 doaga:le, gadofo damui. ");
INSERT INTO beo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Amola Isiama:ile da ea ode 13 amoga gadofo damui ba:i. ");
INSERT INTO beo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","A:ibalaha:me amola egefe Isiama:ile ela da eso afae ganodini gadofo damui. ");
INSERT INTO beo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Amola dunu huluane A:ibalaha:me ea sosogo fi ganodini-amo da ea fi ganodini lalelegei, amola ga fi dunu e da bidilai dagoi-huluane da e amola gilisili gadofo damui ba:i. ");
INSERT INTO beo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","A:ibalaha:me da Ma:melei soge amo sema ifa bagade lelebe sogebi esalu. Eso gia:beba:le, e da ea abula diasu logo holei gadenene filasa:i esalu. Amalalu, Hina Gode da ema doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A:ibalaha:me da ba:legadole, dunu udiana gadenene lelebe ba:i. Ba:loba, e da hedolowane ili yosia:musa: asi, amola ilima begudui. ");
INSERT INTO beo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","E amane sia:i, “Hina! Dilia da na hahawane ba:i galea, mae baligili masa. ");
INSERT INTO beo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Na da hano gaguli misa:ne sia:mu. Amoga dilia emo dodofelalu, amo ifa ea ougiga helefima. ");
INSERT INTO beo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Na da dilia hawa: hamosu dunu defele esala. Dilia gasa bu lama:ne, na da dilima ha:i manu imunu da defeala:?” Ilia da bu adole i, “Defea! Dia sia:i defele hamoma!” ");
INSERT INTO beo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Amaiba:le, A:ibalaha:me da hedolowane ea abula diasua golili sa:i. E da Selama amane sia:i, “Hedolo! Falaua 22 lida amo lale, bibiagole amola gobele agi ga:gi hamoma.” ");
INSERT INTO beo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Amalalu, A:ibalaha:me da ea lai gebo gilisisu amoga hehenane, bulamagau mano gasono ida:iwane lale, ea hawa: hamosu dunuma i. Amo da hedolowane hahamoi. ");
INSERT INTO beo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Amalalu, e da dodo maga:me haei, dodo maga:me amola bulamagau mano gobei, amo gaguli misini, sofe misi dunu ili amo moma:ne ligisi. Ilia da ha:i nanoba, e da ifa ea ougiga ilima gadenene lelu. ");
INSERT INTO beo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ilia da ema amane adole ba:i, “Dia uda Sela da habila:?” A:ibalaha:me da bu adole i, “E da abula diasu ganodini esala.” ");
INSERT INTO beo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Amalalu, Hina Gode da amane sia:i, “Na da waha oubi sesegeyale uduli, dafawane dima misunu. Dia uda Sela da dunu mano lalelegemu.” Sela da abula diasu holei amo Hina Gode Ea baligiga galu amoga sia: lalabolalu. ");
INSERT INTO beo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","A:ibalaha:me amola Sela da da:i hamoi dagoiba:le, Sela da mano lamu ode defei amo baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Amaiba:le, Sela da ea dogo ganodini ousu. Ea asigi dawa:su ganodini, e amane dawa:i, “Na da:i da wadela:lesi dagoi amola nagoa da da:i hamoi. Na da habodane amo hahawane hou ba:ma:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Amalalu, Hina Gode da A:ibalaha:mema amane sia:i, “Sela da abuliba:le oune amane sia:i, ‘Na da da:i hamoiba:le, habodane mano lalelegema:bela:?’ ");
INSERT INTO beo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Gasa bagade liligi hamomu da Godema hamedebela:? Na da oubi sesegeyale uduli, eso ilegei defele na dima olelei, bu misunu. Amola Sela da dunu mano lalelegemu.” ");
INSERT INTO beo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sela da beda:iba:le, ogogoi. E amane sia:i, “Na da hame oui.” Be Hina Gode da amane sia:i, “Be di da oui dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Sofe misi dunu da masusa: wa:legadoloba, ilia da ba:le gaidi Sodame ba:i. Ilia da logoga ahoanoba, A:ibalaha:me da ili sigi asi. ");
INSERT INTO beo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Amalalu, Hina Gode da Hima amane sia:i, “Na da waha hou hamomu amo A:ibalaha:mema wamolegema:bela:? ");
INSERT INTO beo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","A:ibalaha:me ea fi da fi bagade amola gasa bagade hamomu. Ea houba:le, osobo bagade fifi asi gala huluane da hahawane dogolegele ilegesu ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Bai Na da e ilegei dagoi. E da ea mano noga:le olelema:ne amola ea fi dunu da hou moloidafa amola dafawanedafa amo olelema:ne, Na da e ilegei. Amai galea, Na da Na hahawane ilegele sia:i liligi huluane ema imunu.” ");
INSERT INTO beo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Amalalu, Hina Gode da amane sia:i, “Na da Sodame amola Goumola ela fi wadela:idafa hou amo nabi. ");
INSERT INTO beo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Amaiba:le, Na da ilia hou ba:ma:ne amo da nabi liligi defele ganabela:? Amo Na da ba:la masunu. Hame galea Na da dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Sofe misi dunu da sinidigili, Sodame moilaiga doaga:musa: asi. Be A:ibalaha:me da mae fisili Hina Gode Ea midadi lelu. ");
INSERT INTO beo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Amalalu, e da Hina Godema misini, amane sia:i, “Di da dafawane gilisili ida:iwane dunu amola wadela:i hamosu dunu ili fane legema:bela:? ");
INSERT INTO beo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Amabela:? Dunu ida:iwane 50 agoane amo moilai bai bagade ganodini esalabala? Amai galea, Di da amo dunu ilia hou dawa:beba:le, amo moilai bai bagade fadegale fasima:bela:? ");
INSERT INTO beo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Na da agoane dawa:. Di da dunu ida:iwane amola wadela:i hamosu dunu gilisili hou afadafa fawane hamomu da hamedei gala. Amo hou da Dima hame gala. Osobo bagade fifi asi gala ilima Fofada:su Dunudafa, E da hou moloidafa fawane hamoma:bela:? Na agoane dawa:. E da moloidafa hou fawane hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Hina Gode da bu amane sia:i, “Na da Sodame moilai bai bagade ganodini dunu ida:iwane gala 50 agoane ba:sea, Na da ilia hou dawa:beba:le, Sodame huluane hame gugunufinisimu.” ");
INSERT INTO beo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Amalalu, A:ibalaha:me da bu sia:i, “Na da osobo amola nasubu, amo fawane. Be na da mae beda:iwane, Hina Godema sia:i dagoiba:le, na da bu sia:mu. ");
INSERT INTO beo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Di da Sodame moilai bai bagade ganodini, dunu ida:iwane 45 fawane ba:sea, Di da 50 defei amo ganodini wadela:i hamosu dunu biyale fawane ba:sea, moilai wadela:ma:bela:?” E bu adole i, “Na da dunu ida:iwane 45 fawane ba:sea, moilai hame gugunufinisimu.” ");
INSERT INTO beo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","A:ibalaha:me da eno amane sia:i, “Be 40 fawane ba:sea, adi hamoma:bela:?” E amane sia:i, “Amo 40 ilia hou dawa:beba:le, Na da moilai bai bagade hame wadela:mu.” ");
INSERT INTO beo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Amalalu, A:ibalaha:me da amane sia:i, “Hina Gode! Nama mae ougima, be na da Dima bu sia:mu. Dunu 30 fawane ida:iwane esalea adi hamoma:bela:?” E bu adole i, “Na da 30 ba:sea, moilai hame gugunufinisimu.” ");
INSERT INTO beo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","A:ibalaha:me da amane sia:i, “Defea! Na da wali mae beda:iwane Hina Gode Ema sia:i dagoi. Be 20 fawane ba:sea?” E bu adole i, “Moloi dunu 20 ba:sea, Na da hame wadela:mu.” ");
INSERT INTO beo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","A:ibalaha:me da amane sia:i, “Hina Gode! Nama mae ougima, be na da afadafa fawane eno Dima sia:mu. Dunu 10 ida:iwane fawane ba:sea, adi hamoma:bela:?” Hina Gode da bu adole i, “Dunu 10 ilia hou ida:iwane ba:sea, Na da amo moilai hame gugunufinisimu.” ");
INSERT INTO beo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Hina Gode amola A:ibalaha:me, ela gilisili sia: dasu da dagoloba, Hina Gode da fisili asi amola A:ibalaha:me da hi diasuga buhagi. ");
INSERT INTO beo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Baloga, amo a:igele dunu aduna da Sodame moilai bai bagade logo holei amoga doaga:loba, Lode amo logo holei gadenene filasa:i esalebe ba:i. E da a:igele ba:loba, wa:legadole, elama asili begudui. ");
INSERT INTO beo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","E da elama amane sia:i, “Hina aduna! Na da alia hawa: hamosu dunu. Na diasuga misa! Alia emo dodofelalu, na diasuga golama. Hahabedafa, alia da wa:legadole, alia logoga masunu da defea. Be ela da bu adole i, “Hame mabu! Ania da gadili amo moilai gilisisu sogebi ganodini golamu.” ");
INSERT INTO beo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Be Lode da gasawane elama sia:nanu, ela da ea diasuga sigi asi. Lode da ea hawa: hamosu dunu ema agi gobema, amola ha:i manu eno amo sofe misi dunuma ima:ne sia:i. Amo ha:i manu hamonanu, a:igele dunu da mai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ela da golamusa: dawa:i galu, be hidadea Sodame dunu da diasu sisiga:i. Sodame dunu huluane, amo goi amola dunu da:i huluane gilisi. ");
INSERT INTO beo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ilia da Lodema bagadewane wele sia:i, “Dunu da dia diasuga golamusa: misi da habila:? Gadili oule misa!” Sodame dunu da amo dunuma wadela:i adole lasu hou hamomusa: hanaiba:le, amane sia:i. ");
INSERT INTO beo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Be Lode da gadili asili, logo ga:su amo ea baligidu ga:si dagoi. ");
INSERT INTO beo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","E da ilima amane sia:i, “Na:iyado! Na da dilima bagadewane edegesa! Amo wadela:i hou mae hamoma! ");
INSERT INTO beo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Na da uda mano aduna esala. Ela da dunuga hame dawa:digi. Na da ela gadili oule misini, dilima imunu da defea. Dilia da elama dilia hanai hamomu da defea. Be amo dunu aduna mae wadela:ma. Na da ela na diasuga aowasa. Na da ela gaga:mu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Be ilia da Lodema amane sia:i, “Di da ga fi dunu fawane! Ninia logo mae ga:ma! Di da ninima olelemu da defea hame galebe. Di da ninia logo hedofasea, ninia da di baligiliwane wadela:mu.” Ilia da Lode fulifasilalu, misini, logo mugulumusa: dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Be a:igele sofe misi dunu aduna da lobolele, Lode amo diasu ganodini hiougili, logo ga:si dagoi. ");
INSERT INTO beo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Amalalu, ela da amo Sodame dunu ilia si dofolesi dagoi. Ilia da logo ba:mu hamedeiwane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Amalalu, amo dunu aduna da Lodema amane sia:i, “Di da fi dunu eno esalea, amo dunu mano, uda mano, bai, o fi dunu eno diasu ganodini esala, amo mugululi gadili masa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ani da amo soge huluane wadela:mu galebe. Hina Gode da ilia wadela:i hou huluane nabi dagoi. E da ani Sodame moilai bai bagade wadela:musa: asunasi dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Amalalu, Lode da dunu amo da ea uda mano fa:no lamusa: sia:si dunu ilima asili, amane sia:i, “Hedolo! Moilai bai bagade yolesima! Hina Gode Bagade da amo soge gugunufinisimu!” Be ilia da ea sia: da gagaoui dunu ea sia: defele dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Eso maba amoga, a:igele dunu da Lode hedolo fisili masa:ne sia:i. Elea da amane sia:i, “Hedolo! Dia uda amola uda mano aduna oule asili, gadili masa. Moilai bai bagade da gugunufinisimu gala. Dilia bogosa:besa:le, hedolo masa!” ");
INSERT INTO beo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lode da hedolo hame asi. Be Hina Gode da ema asigiba:le, a:igele dunu aduna da e, ea uda, amola ea uda mano aduna, amo lobolele, diasu yolesili, gadili oule asi. ");
INSERT INTO beo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Amalalu, a:igele dunu afae da amane sia:i, “Hedolodafa hobeale masa! Mae beba:ma amola umiga mae aligima! Dilia bogosa:besa:le, goumiga hobeale masa!” ");
INSERT INTO beo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Be Lode da amane sia:i, “Hame mabu, hina! ");
INSERT INTO beo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Di da nama asigiba:le, na esalusu gaga:i dagoi. Be goumi da sedade. Amaiba:le, na da asili, goumiga mae doaga:le, soge wadela:mu da nama doaga:le, na da bogomu. ");
INSERT INTO beo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Amo moilai fonobahadi ba:ma! Amo da fonobahadi gadenei. Na da amoga masa:ne di sia:ma. Amo da moilai fonobahadi fawane. Amo ganodini na da gaga:su ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","A:igele da bu adole i, “Defea! Amo da defea! Na da amo moilai hame wadela:mu. ");
INSERT INTO beo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Be hedolo masa! Hehenama! Dia da amo moilaiga doaga:sea fawane soge wadela:mu.” Lode da amo moilai da fonobahadi sia:beba:le, ilia da amo moilaiga Soua (fonobahadi) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lode da Soua moilaiga doaga:loba, eso heda:lebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Amalalu, Hina Gode da lalu amola gia:i igi gibu agoane Sodame amola Goumola amo moilai bai bagade elama iasi. ");
INSERT INTO beo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Amo moilai bai bagade aduna, umi soge huluane, dunu fi, gisi amola ifa huluane da gugunufinisi dagoi, hamedafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Be Lode ea uda da logoga beba:beba:le, e da bogole, sali gelo ifa agoai lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Amalalu, hahabedafa, A:ibalaha:me da wa:legadole, asili, sogebi amoga e amola Hina Gode da gilisili sia: dasu amoga doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","E da ba:le gaidili, umi soge bagade, Sodame amola Goumola ela sogebi ba:lalu. Be mobi bagade amo da gobele nasu bagade ea mobi defele, amo fawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Amaiba:le, Gode da umi soge moilai bai bagade gugunufinisi galu, E da A:ibalaha:me amo dawa:i galu. E da Lode esaloma:ne gadili oule asi. Be Lode ea esalu moilai bai bagade, E da wadela:lesi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lode amola idiwi a:fini aduna da beda:iba:le, Soua moilai yolesili, goumi soge ganodini fi esalu. Ilia da magufu gele gelabo amo ganodini esalu. ");
INSERT INTO beo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Eso afaega, magobo uda mano da ea eya ema amane sia:i, “Ani ada da da:i hamoi dagoi. Guiguda: da dunu amo osobo bagade dunu huluane ilia hou defele, anima gilisili golamu da hamedei. ");
INSERT INTO beo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Amaiba:le, ania da adama waini hano imunu. E da amo nasea, feloale hamosea, ania da ema gilisili golamu. Mano lasea, ninia fi da hame udumu.” ");
INSERT INTO beo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Amo gasia, ela da waini hano amo edama i. Amalalu, magobo uda mano da asili edama gilisili golai. Be Lode da waini hano ba:ibale, ea mano ema misi, amola e wa:legadoi amo hame dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Aya amo magobo uda mano da eya ema amane sia:i, “Aya gasia na da adama gilisili golai. Wali gasia ani da eno ema waini hano imunu amola di ema gilisili golama. Amalalu, ninia fi da hame udumu.” ");
INSERT INTO beo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Amalalu, gasia, ela da Lodema waini hano i. Magobo bagia uda mano da asili, edama gilisili golai. Amo gasia amola, Lode da ea mano ema misini, bu wa:legadoi, hame dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Amaiba:le, Lode ea uda mano aduna da eda hamoiba:le, abula agui ba:i. ");
INSERT INTO beo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Magobo uda mano da dunu mano lai. E da amoma Moua:be dio asuli. Moua:be da Moua:be dunu fi ilima eda esalu. ");
INSERT INTO beo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Magobo bagia uda mano amola da dunu mano lai. E da ema Benami dio asuli. Benami ea lalelegei fi da wali esalebe A:monaide fi. ");
INSERT INTO beo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","A:ibalaha:me da Ma:melei soge yolesili, Ga:ina:ne soge ga (south) la:idiga asi. E da diasu aduna amo Ga:idesie amola Sie amoga dogoa moilai bai bagade ea dio amo Gila esalu. ");
INSERT INTO beo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Amoga, A:ibalaha:me da ea uda Sela amo da ea dalusi sia:i. Amalalu, Gila hina bagade dunu amo Abimelege da Sela ema misa:ne sia:i. E da ea diasuga esaloma:ne lai. ");
INSERT INTO beo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Be Gode da simasia ganodini Abimelegema amane sia:i, “Di da bogoi dunu defele. Bai amo uda di da lai, amo da dunu eno idua.” ");
INSERT INTO beo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Be Abimelege da Sela amoma hame doaga:i galu. Amaiba:le, e amane sia:i, “Hina Gode! Di da fi amo wadela:le hame hamoi amo wadela:ma:bela:? ");
INSERT INTO beo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","A:ibalaha:me da nama amane sia:i, ‘E da na dalusi,’ amola uda da nama amane sia:i, ‘E da na ola’. Na da amo sia: da dafawane dawa:beba:le, wadela:le hame hamoi.” ");
INSERT INTO beo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Amalalu, Gode da amo simasia ganodini ema amane sia:i, “Dafawane! Na dawa:. Di da asigi dawa:su dodofei dagoi amoga hamoi. Amaiba:le, Na da dia wadela:i hamomu logo damui dagoi. Bai di da e mae digili ba:ma:ne, Na da amo logo ga:i. ");
INSERT INTO beo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Be wali amo dunu ea uda ema bu ima. E da balofede dunu amola e da di fidima:ne sia:ne gadomu. Amasea, di da hame bogole esalumu. Be ema bu hame iasea, di amola dia fi huluane da bogogia:mu, amo noga:le dawa:ma.” ");
INSERT INTO beo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Hahabedafa, Abimelege da ea eagene ouligisu dunu huluane misa:ne sia:i. Amo hou huluane ilima olelelalu, ilia da bagadewane beda:i. ");
INSERT INTO beo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Amalalu, Abimelege da A:ibalaha:me misa:ne sia:i. E da ema amane sia:i, “Di da ninima adi hamobela:? Dia hou hamoiba:le, na amola na fi da se bagade nabi. Na da dima adi wadela:i hou hamobela:? Di da ninima hou hamoi da defea hame.” ");
INSERT INTO beo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Amola Abimelege da A:ibalaha:mema amane adole ba:i, “Adi baiga di da amo hou hamobela:?” ");
INSERT INTO beo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","A:ibalaha:me da bu adole i, “Na da na dogo ganodini amane sia:i, ‘Amo soge ganodini, dunu fi da Godema hame beda:sa. Ilia da na uda ba:sea, na fane legemu.’ ");
INSERT INTO beo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Amola, amo uda da dafawane na dalusi. E da na ada ea mano be eme ea mano hame. Amola amo na da lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Amola Gode da nama nada ea fi amo fisili ga masa:ne sia:noba, na da Selama amane sia:i, ‘Di da dia nama asigi hou agoane olelema. Soge huluane ani ahoasea, na hou agoane olelema; E da na ola!’” ");
INSERT INTO beo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Amalalu, Abimelege da sibi, bulamagau, udigili hawa: hamosu dunu amola udigili hawa: hamosu uda, amo oule misini, A:ibalaha:mema i. Amola ea uda Sela amo ema bu i. ");
INSERT INTO beo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Amola Abimelege da ema amane sia:i, “Na soge huluane ba:ma. Dia hanaiga amogai fima.” ");
INSERT INTO beo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","E da Selama amane sia:i, “Na da dia olama silifa muni 1000 amo iaha. Amo da dunu huluane ilima di da wadela:i hame hamoi amo olelema:ne. Dunu huluane da di da wadela:i hame hamoi amo dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Amalalu, A:ibalaha:me da Godema sia:ne gadoi. Amola Gode da Abimelege, ea uda amola ea udigili hawa: hamosu a:fini huluane uhinisi dagoi. Amalalu, ilia da mano eno bu lamu hou dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Bai Hina Gode da A:ibalaha:me idua Selama asigiba:le, Abimelege ea fi uda ilia mano lamu logo amo huluane ga:si dagoi. Be wali bu doasi. ");
INSERT INTO beo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Hina Gode da Ea ilegele sia:i defele Selama hahawane hamoi. ");
INSERT INTO beo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Amo eso defei, Gode da sia:i defele, Sela da abula agui amola dunu mano lalelegei. A:ibalaha:me da da:i hamone, amo esoga Sela da ema dunu mano lai. ");
INSERT INTO beo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Amo dunu mano Sela da ema lai, A:ibalaha:me da dio asuli amo Aisage. ");
INSERT INTO beo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Aisage da eso godoane esalu, A:ibalaha:me da Gode Ea hamoma:ne sia:i defele, ea gadofo damui. ");
INSERT INTO beo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aisage da lalelegeloba, A:ibalaha:me ea ode esalu da ode 100 ba:i. ");
INSERT INTO beo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sela da amane sia:i, “Gode da nama hahawane ousu i. Dunu huluane amo hou nabasea da hahawaneba:le, ilia da na amola gilisili oumu.” ");
INSERT INTO beo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","E eno amane sia:i, “Dunu da Sela da manoma dodo maga:me imunu hamedei liligi agoane sia:mu galu. Be na da A:ibalaha:me ea da:i hamoi esoga ema dunu mano lai.” ");
INSERT INTO beo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisage da asigilalasi amola ea:me ea dodo nasu fisi. Amo esoga, A:ibalaha:me da lolo nasu bagade hamoi. ");
INSERT INTO beo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Isiama:ile (amo Idibidi hawa: hamosu uda Ha:iga ea mano) da Aisagema habosesele hedei. ");
INSERT INTO beo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sela da amo hou ba:beba:le, A:ibalaha:mema amane sia:i, “Amo udigili hawa: hamosu uda amola ea mano sefasima. Amo uda ea mano da dia nana liligi amola muni la:idi lamu da defea hame galebe. Nagofe Aisage hi fawane lamu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Amo sia: nababeba:le, A:ibalaha:me da se bagade nabi. Bai Isiama:ile amola da ea mano galu. ");
INSERT INTO beo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Be Gode da A:ibalaha:mema amane sia:i, “Isiama:ile amola dia udigili hawa: hamosu uda Ha:iga ela hou dawa:beba:le, mae da:i dioma. Sela ea sia: defele hamoma. Dia fidafa da Aisagema lalelegemu. ");
INSERT INTO beo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Be Na da udigili hawa: hamosu uda ea mano ema mano bagohame imunu. E amola da fi bagade hamomu. Bai e amola da dia mano.” ");
INSERT INTO beo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Aya hahabedafa, A:ibalaha:me da ha:i manu amola gadofo houga:i hano nasu hano amoga nabai, amo Ha:igama i. E da Isiama:ile amo Ha:iga ea baligi da:iya ligisili, ela asunasi. Ha:iga da asili, Biasiba wadela:i hafoga:i soge ganodini udigili lalu. ");
INSERT INTO beo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hano amo da gadofo houga:i dialu amo huluane da ebele ba:loba, e da mano ifa fonobahadi hagudu ligisili, ");
INSERT INTO beo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","asili, dadi gala:i ea defei amoga asili, fi galu. E amane dawa:i, “Na da na mano bogomu ba:mu higasa.” E da muni esala dinanu. ");
INSERT INTO beo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Gode da mano ea dibi nabi dagoi. Gode Ea a:igele dunu da Hebene amoga Ha:igama welalu, amane sia:i, “Ha:iga! Di da abuli da:i diobela:? Mae beda:ma! Gode da mano ea dibi nabi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Di da dia mano lobolele wa:lesima. Na da ea lalelegemu fi bagade hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Amalalu, Gode da Ha:iga ea si fadegale, e da hano uli dou ba:i. Amaiba:le, e da asili gadofo houga:i amo hanoga nabalu, ea manoma i. ");
INSERT INTO beo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Asili, amo mano da asigilaloba, Gode da noga:le fidi. E da hano hame wadela:i soge ganodini esalu. E da dadiga gala:su hou bagade dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","E da Balane wadela:i hafoga:i soge amo ganodini esalea, ea:me da Idibidi uda Isiama:ile lama:ne hogole, ema i. ");
INSERT INTO beo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Amo esoga, Abimelege amola ea dadi gagui ouligisu dunu amo Faigole, da A:ibalaha:mema amane sia:i, “Dia hou huluane amo ganodini Gode da noga:le fidilala. ");
INSERT INTO beo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Amaiba:le, wali nama gousa:su hamoma. Gode ba:ma:ne, moloidafa sia:ma! Di da na mano amola nagaga fi ilima hame ogogomu amola hame hohonomu, amane ilegele sia:ma! Di da nama amola na soge amo di da sofe misi defele ganodini esala, amoma asigi hou na da dima olelei defele hamoma.” ");
INSERT INTO beo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","A:ibalaha:me da amane sia:i, “Na da amane dafawane ilegesa!” ");
INSERT INTO beo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Amalalu, A:ibalaha:me da Abimelegema egai. Bai Abimelege ea hawa: hamosu dunu ilia da hano uli dou gegene gasawane lai. Amola A:ibalaha:me da amo hou higale ba:i. ");
INSERT INTO beo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Be Abimelege da bu adole i, “Na da hame dawa:! Nowa da hamobela:? Di da nama hame adoi. Na da wahadafa nabi.” ");
INSERT INTO beo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Amaiba:le, A:ibalaha:me da sibi amola bulamagau lale Abimelegema i. Ela da gousa:su hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","A:ibalaha:me da sibi mano aseme fesuale gala ea sibi gilisisu amoma afafai. ");
INSERT INTO beo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Amola Abimelege da A:ibalaha:mema amane adole ba:i, “Amo sibi mano aseme fesuale gala di da afafai, amo ea bai da adila:?” ");
INSERT INTO beo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A:ibalaha:me da bu adole i, “Amo sibi mano fesuale gala, di lama! Amo da na amo hano uli dou nisu dogoi, amo dafawane dawa:ma:ne, amo sibi da ba:su ilegei gala.” ");
INSERT INTO beo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Amaiba:le, amo hano uli dou ea dio da Biasiba. Bai amo dunu aduna da gasa bagade gousa:su amogai hamoi galu. ");
INSERT INTO beo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Biasiba amoga ilia gousa:su hamonanu, Abimelege amola ea dadi gagui ouligisu dunu amo Faigole, da Filisidini fi ilia sogega buhagi. ");
INSERT INTO beo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A:ibalaha:me da ‘da:malisigi’ ifa Biasiba sogega bugi. Amoga e da Hina Gode, Eso huluane Esalalalusu Gode, Ema nodone sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Amola A:ibalaha:me da Filisidini soge amo ganodini ode bagohame esalu. ");
INSERT INTO beo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Eso enoga, Gode da A:ibalaha:me ea hou adoba:ma:ne, ema amane sia:i, “A:ibalaha:me!” A:ibalaha:me da bu adole i, “Na wea!” ");
INSERT INTO beo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Gode da ema amane sia:i, “Defea! Di da mano afadafa fawane gala. Amo dia dogolegei mano Aisage lale, oule asili, Molaia sogega doaga:ma. Goe sogega Na da goumi dima olelemu. Amo heda:le, dia mano gobele salasu hou hamoma:ne, medole legele, laluga gobele salima.” ");
INSERT INTO beo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Golale hahabe, A:ibalaha:me da nedigili, liligi ea dougi da:iya ligisili, gobele salasu hou hamomusa: lalu ifa habele, ea mano amola hawa: hamosu ayeligi aduna, Molaia sogega doaga:musa: oule asi. ");
INSERT INTO beo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Eso udiana ahoanu, A:ibalaha:me da amo sogebi sedagawane dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Amalalu, A:ibalaha:me da ea hawa: hamosu dunu elama amane sia:i, “Ali gui esaloma! Dougi ouligima! Na amola nagofe da amo sogega Godema nodone sia:ne gadolalu, bu misunu.” ");
INSERT INTO beo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Amalalu, A:ibalaha:me da lalu ifa habei amo Aisagema gisa masa:ne i. A:ibalaha:me da lalu dasu amola gobihei gisa asili, ela da goumiba:le heda:i. Ela da gilisili ahoana, ");
INSERT INTO beo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisage da edama amane sia:i, “Ada!” A:ibalaha:me da bu adole i, “Nagofe! Adi laha?” Aisage da amane sia:i, “Laludai amola lalu habei diala. Be sibi mano, gobele salasu hou hamoma:ne amo da habila:?” ");
INSERT INTO beo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","A:ibalaha:me da bu adole i, “Nagofe! Gode Hi da ani gobele salimusa:, sibi mano imunu!” Amalalu, ela da gilisili bu ahoanu. ");
INSERT INTO beo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Elea da Gode Ea musa: adoi sogebiga doaga:loba, A:ibalaha:me da gelega oloda hamone, lalu habei oloda da:iya ligisili, ea mano ea emo amola lobo la:gili, amo da:iya ligisi. ");
INSERT INTO beo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Amalalu, A:ibalaha:me da ea mano medole legemusa:, gobihei gaguia gadoi. ");
INSERT INTO beo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Be muagado, Hina Gode Ea a:igele dunu da gagabole ha:giwane wele sia:i, “A:ibalaha:me! A:ibalaha:me!” E bu adole i, “Na wea!” ");
INSERT INTO beo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","A:igele da amane sia:i, “Dia mano mae medoma! E se nabima:ne mae fama! Di da dia mano Nama imunu hame hihi galu. Amaiba:le, di da Godema beda:i amola nabasu hou dawa:, amo Na da ba:i dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Amalalu, A:ibalaha:me da ea si ba:le ga:le, sibi gawali amo ea hono da ifa amoga lala:gi lelebe ba:i. Amaiba:le, e da ea mano mae medole, amo sibi lale, medole legele, gobele salasu hamoi. ");
INSERT INTO beo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","A:ibalaha:me da amo sogebi ‘Yehoufayaila’ dio asuli. Goe dio dawaloma:ne da, “Hina Gode Hi da hahawane imunu!” Wali eso amola, dunu da amane sia:sa, “Hina Gode da Hi goumi da:iya hahawane imunu.” ");
INSERT INTO beo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Amalalu, Gode Ea a:igele dunu da Hebeneganini A:ibalaha:mema bu sia:i, ");
INSERT INTO beo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Di da Na sia: nabawane hamobeba:le, amola dia dogolegei mano Nama imunusa: hame hihiba:le, Na da Na Dioba:le agoane ilegele sia:sa. Na da dima bagadewane hahawane dogolegele ilegemu. ");
INSERT INTO beo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Na da digaga fi mano ilia da gasumuni ilia idi defele, amola sa:iboso idi defei defele hamomu. Dia fi da ilia ha lai dunu amo hasalasimu. ");
INSERT INTO beo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Di da Na hamoma:ne sia: nababeba:le, osobo bagade fifi asi gala huluane, da Nama Na da di hahawane dogolegele ilegei defele, ilima hahawane dogolegele ilegesu ima:ne adole ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Amalalu, A:ibalaha:me da ea hawa: hamosu dunu elama buhagili, ilia gilisili Biasiba moilaiga asi. Amola A:ibalaha:me da Biasiba amo ganodini esalu. ");
INSERT INTO beo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Fa:no, dunu eno da A:ibalaha:mema amane sia:i, “Miliga da mano lai. E da dia eya Na:iho ema dunu mano godoane lai. ");
INSERT INTO beo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Magobo dunu mano da Use. Ea eyalali da Buse, Gemuele (ea mano da Alame), ");
INSERT INTO beo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Gisede, Ha:iso, Bilada:se, Yidala:fe amola Bediuele. ");
INSERT INTO beo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bediuele da uda mano lai, amo Lebega. Amo dunu mano godoane ilia ame da Miliga, amola ilia eda da A:ibalaha:me eya amo Na:iho. ");
INSERT INTO beo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Na:iho ea gidisedagi uda amo ea dio amo Liuma, da dunu manolali lai. Ilia dio da Diba, Ga:iha:me, Da:iha:se amola Ma:iaga. ");
INSERT INTO beo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sela da ode 127 esalu. ");
INSERT INTO beo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Amalalu, e da Hibalone moilai bai bagade, Ga:ina:ne soge ganodini, amoga bogoi. A:ibalaha:me da amoga ea udama asigiba:le, dimusa: asi. ");
INSERT INTO beo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Amalalu, A:ibalaha:me da ea uda bogoi da:i hodo amoga ouesalu, wa:legadole Hidaide dunuma asili, amane sia:i, ");
INSERT INTO beo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Na da dilia fi amo ganodini ga fi dunu esala. Na uda bogoi uli dogoma:ne, soge fonobahadi nama bidi lama.” ");
INSERT INTO beo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hidaide dunu da A:ibalaha:mema bu adole i, ");
INSERT INTO beo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ada! Ninia sia: nabima! Di da ninima gasa bagade ouligisu dunu agoane. Ninia bogoi uli dogoi sogebiga, uli dogoi noga:idafa lama. Ninia huluane da baligili noga:idafa uli dogoi dima imunu hame higamu.” ");
INSERT INTO beo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Amalalu, A:ibalaha:me da wa:legadole, amo soge esalebe dunu amo Hidaide, ilima begudui. ");
INSERT INTO beo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","E da ilima amane sia:i, “Dilia da na bogoi uli dogomusa: hahawane ba:i galea, defea, dilia Ifalone (Souha ea mano) amoma na fidima:ne adole ba:ma. ");
INSERT INTO beo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ea soge la:idi ganodini da Ma:gafila gele gelabo. Amo e da gaguiba:le, e da amo ea muni defei na da dilia fi amo ganodini na bogoi uli dogomusa: bidi lama:ne, dilia ema adole ba:ma.” ");
INSERT INTO beo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ifalone e da amo Hidaide fi dunu ea fi ganodini esalebe ba:i. Ilia huluane da moilai logo holeiga gilisi. E da Hidaide dunu huluane nabima:ne, A:ibalaha:mema amane adole i, ");
INSERT INTO beo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hame mabu ada! Na sia: nabima! Amo soge amola gele gelabo amo ganodini diala, na da udigili dima imunu. Na dunu huluane ba:ma:ne, na da dima iaha. Dia bogoi amoga uli dogoma!” ");
INSERT INTO beo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","A:ibalaha:me da amo soge fi dunu ilima bu begudui, ");
INSERT INTO beo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ilia huluane nabima:ne, e da Ifalonema amane sia:i, “Na da dilima na sia: nabima:ne edegesa. Na da amo soge huluane ea ilegei amo defele bidi lamu. Amo muni lama. Na da na bogoi amoga uli dogomu galebe.” ");
INSERT INTO beo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ifalone da A:ibalaha:mema bu adole i, ");
INSERT INTO beo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ada! Nabima! Amo soge bidi lamu defei da silifa fage 400 fawane. Amo muni da anima hamedei liligi. Dia bogoi uli dogoma!” ");
INSERT INTO beo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","A:ibalaha:me da Ifalone ea sia:i hahawane ba:i. E da Hidaide dunu huluane ba:ma:ne, muni ea sia:i defele Ifalonema i. Defei da silifa fage 400 amo ea dioi ilegei defele da bidiga lasu dunu ilia hou defele i. ");
INSERT INTO beo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Amaiba:le, Ifalone ea sogebi amo da Ma:gafila soge ganodini Ma:melei soge gadenene, - sogebi, gele gelabo amo ganodini dialu amola ifa huluane amo sogebi ganodini, huluane A:ibalaha:me da lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hidaide dunu huluane logo holeiga gilisi da amo hou ba:beba:le, amo soge da wali A:ibalaha:me ea soge ilegei. ");
INSERT INTO beo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Amalalu, A:ibalaha:me da ea uda Sela amo gele gelabo Ma:gafila sogebi ganodini (Ga:ina:ne soge ganodini) uli dogone sali. ");
INSERT INTO beo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Amola Ma:gafila sogebi amola gele gelabo amo ganodini gala musa: da Hidaide dunu da gagui, amo A:ibalaha:me ea fi bogoi uli dogomusa: bidi lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","A:ibalaha:me da ode bagohame lai dagoiba:le, da:idafa ba:su. Be Hina Gode da ea hou huluane amo ganodini hahawane dogolegelewane fidilalusu. ");
INSERT INTO beo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","E da ea da:i hamoi hawa: hamosu dunu (amo da ea liligi huluane ouligisu) ema amane sia:i, “Dia lobo amo na masele hagudu ligisili, dafawane ilegele sia:ma! ");
INSERT INTO beo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Na da agoane hanai galebe. Di da Hina Gode amo da Hebene Hina amola osobo bagade Hina, amo Ea Dioba:le gasa bagade sia:ma. Di da Ga:ina:ne fi (amo ganodini na da wali esala) amoga nagofe uda lama:ne mae ilegema. ");
INSERT INTO beo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Be na musa: fi sogega asili, na fidafa amo ganodini hogolalu, nagofe Aisage uda lama:ne, a:fini sia:sima!” ");
INSERT INTO beo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ea hawa: hamosu dunu da bu adole ba:i, “Be amo uda da na amola bu sigi misunu hihi galea, na da adi hamoma:bela:? Na da dia mano amo dia musa: sogega bu oule masa:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Be A:ibalaha:me da amane sia:i, “Hame mabu! Di amoga nagofe bu mae oule masa! ");
INSERT INTO beo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hina Gode amo Hebene amoga Hina esala, e da na ada amo ea diasu amola na soge yolesili ga masa:ne sia:ne, nama gasawane amane sia:i, ‘Na da dafawane ilegele sia:sa! Na da amo soge (Ga:ina:ne) digaga fi ilima imunu.’ Amo Gode da Ea a:igele dunu dima bisimusa: asunasimu. Bai di da amo sogega nagofema ima:ne uda lamu defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Be uda da di guiguda: oule misunu amo higasea, defea, dia da nama Gode Ea Dioba:le sia:i, amo na da bu hame dawa:mu. Be na mano maedafa bu oule masa.” ");
INSERT INTO beo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Amaiba:le, hawa: hamosu dunu da ea hina A:ibalaha:me amo ea masele hagudu ea lobo ligisili, Gode Ea Dioba:le gasa bagade amo liligi hamoma:ne ilegele sia:i. ");
INSERT INTO beo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Amalalu, hawa: hamosu dunu da ea hina ga:mele nabuane gala amo lale, ea hina ea liligi noga:iwane aguni, gadili asi. E da Alame Nahalaime soge amoga doaga:musa: asili, Na:iho moilaiga doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Hano uli dogoi moilai gadili sogebi gala amoga doaga:loba, ea sia:beba:le, ga:mele da muguni bugi. Eso dabe da gadenenewane ba:i. Amoha, uda ilia hou da hano uli dogoi amoga hano dima:ne hiougimusa: ahoasu. ");
INSERT INTO beo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Amalalu, e da Godema amane sia:ne gadoi, “Hina Godedafa! Na hina A:ibalaha:me amo ea Gode! Na hawa: hamosu hahawane dagoma:ne Di fidima, amola na hina A:ibalaha:mema dia asigi hou olelema. ");
INSERT INTO beo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ba:ma! Na da amo hano nasu ulidou gadenene lela amola amo moilai dunu ilia uda mano da hano dimusa: manebe. ");
INSERT INTO beo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Na da agoane hanai gala. Na da a:finima ‘Dia hano disu amo na hano moma:ne ligisima.’ sia:sea, amola e da amane sia:sea, ‘Defea! Moma! Amola na da dia ga:mele moma:ne hano dili imunu.’ Amo hou ba:sea, Hina Gode da amo a:fini na hina ea mano lama:ne ilegei dagoi na da dawa:mu. Amola Di da na hinama asigi hou olelei dagoi, amo na da dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","E da sia:ne gadolaloba, Lebega da misini, ea hano ganagu amo gisa manebe ba:i. Lebega da Bediuele ea idiwi, amola Bediuele ea:me da A:ibalaha:me ola Na:iho amo idua, ea dio amo Miliga. ");
INSERT INTO beo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Lebega ea ba:su da noga:idafa ba:i. E da a:fini galu. Dunu afae da e amola gilisili hame golai. E da hano nasua asili, ea ganagu nabalesili, bu heda:i. ");
INSERT INTO beo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","A:ibalaha:me ea hawa: hamosu dunu da hedolo ema misini, amane sia:i, “Na da dia ganagu amoga hano fonobahadi manu da defeala:?” ");
INSERT INTO beo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A:fini da amane sia:i, “Defea! Ada! Di moma!” Amalalu, e da ganagu ligisili, ea lobo ganodini gaguli, ema hano i. ");
INSERT INTO beo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Hano dili ianu, e amane sia:i, “Na da dia ga:mele moma:ne amola hano dili imunu. Ilia sadi dagoiba:le fawane yolesimu.” ");
INSERT INTO beo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Amaiba:le, e da ea ganagu amo hano ga:mele hano nasu ganodini sogasalili, hano uli dogoi amoga hehenane, hano eno dili, ga:mele sadi dagoiba:le yolesi. ");
INSERT INTO beo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","A:ibalaha:me hawa: hamosu dunu da ouiya:le esalu. Gode da ea ahoabe bai amo noga:le fidi amo dawa:musa:gini, E da amo a:fini ea hou ha:giwane ba:lalu. ");
INSERT INTO beo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ga:mele da hano na dagoloba, A:ibalaha:me ea hawa: hamosu dunu da mi bione gala:su gouliga hamoi amo Lebega ea mi ga:i, amola gouli lobofasele fei. Mi bione gala:su ea dioi defei da gala:me biyale agoane amola fesuale fesu da gala:me 100agoane. ");
INSERT INTO beo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Amalalu, A:ibalaha:me ea hawa: hamosu dunu da ema amane adole ba:i, “Di da nowa ea manola:? Nama adoma! Dia ada diasu amo ganodini nini golama:ne sogebi ganabela:? ");
INSERT INTO beo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A:fini da bu adole i, “Na da Bediuele ea mano. Bediuele da Na:iho amola idua Miliga ela mano.” ");
INSERT INTO beo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Amalalu, e bu adole i, “Ninia diasua da gisi ha:i manu bagohame gala. Amola dilia gasia golama:ne, sogebi bagade gala. ");
INSERT INTO beo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Amalalu, hawa: hamosu dunu e da beguduli, Hina Godema nodone sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","E amane sia:i, “Na da Hina Gode dio nodone gaguia gadosa. Na hina A:ibalaha:me, amo ea Gode da ema asigi hou hame yolesi. Be Hina Gode da na bisili asili, nama na hina ea fi dunu ilia diasu noga:le olelei. ");
INSERT INTO beo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Lebega da hehenane, ea ame fi ilima amo hou olelei. ");
INSERT INTO beo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lebega ea ola amo ea dio La:iba:ne esalu. La:iba:ne da hehenane, hano nasu amoga doaga:musa: asi. ");
INSERT INTO beo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","E da Lebega lai liligi, amo mi bione ga:i amola gouli lobofasele fei ba:i dagoi. E da Lebega ea sia: nabi dagoi. Amabeba:le, e da asili, A:ibalaha:me ea hawa: hamosu dunu ea ga:mele amo hano nasu gadenene lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","E amane sia:i, “Hina Gode da dima hahawane dogolegele ilegesa. Misa! Di da abuli gadili lela. Na da di golama:ne amola ga:mele golama:ne diasu hahamoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Amaiba:le, dunu da diasuga asi. La:iba:ne da ga:mele amoga liligi lale ligisi. E da gisi amola ha:i manu ga:mele ilima gaguli misi, amola A:ibalaha:me ea hawa: hamosu dunu amola ea fidisu dunu ilia emo dodofema:ne, hano dili i. ");
INSERT INTO beo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Amalalu, amo dunu ha:i moma:ne, ilia da ha:i manu gaguli misi. Be e amane sia:i, Na da na sia:ne iasu sia:i dagoiba:le fawane, ha:i manu. La:iba:ne da amane sia:i, “Defea! Ninima adoma!” ");
INSERT INTO beo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Amaiba:le, e amane sia:i, “Na da A:ibalaha:me ea hawa: hamosu dunu. ");
INSERT INTO beo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Hina Gode da na hina amo hahawane dogolegelewane bagade fidibiba:le, e da wali bagade gagui dunu esala. Gode da ema sibi, bulamagau, silifa, gouli, hawa: hamosu dunu, hawa: hamosu uda, ga:mele, amola dougi ema i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ea uda Sela da da:i hamoi be ema dunu mano da lalelegei. Na hina da amo manoma ea gagui huluane i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Na hina da logeiba:le, na da Gode Ea Dioba:le gasa bagade ilegele sia:i. Na hina da amane sia:i, “Na da Ga:ina:ne fi amo ganodini esala. Be amoga nagofe uda lama:ne, uda mae sia:sima. ");
INSERT INTO beo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Be na ada ea sosogo fi amola na fidafa ilima nagofe ea uda lala masa.’ ");
INSERT INTO beo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Amalalu, na da na hinama amane adole ba:i, “Be amo uda da na amola bu sigi misunu hihi galea, na adi hamoma:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","E da nama bu adole i, ‘Hina Godedafa, amo Ea sia: na eso huluane naba, E di fidima:ne Ea a:igele dunu asunasimu. Di na fidafa, amola na ada ea sosogo fi amoga uda na mano ea lama:ne sia:sima. ");
INSERT INTO beo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Dia gasa bagade sia: amo mae hamoma:ne, logo afadafa fawane gala. Di da na fi ilima asili amola ilia amo uda dima imunu higasea, defea, yolema.’ ");
INSERT INTO beo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Na da wali eso hano nasu uli dogoi amoga doaga:loba, na amane sia:ne gadoi, ‘Hina Gode! Na hina A:ibalaha:me ea Gode! Dia na wali hou hamobe fidima! ");
INSERT INTO beo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Na da hano nasu uli dogoiga esala. A:fini afae hano dimusa: masea, e da nama ea ganagu, hano dili ima:ne na da adole ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","E da amo iasea amola baligili na ga:mele ilima hano imunusa: sia:sea, amo da na hina ea mano lama:ne a:fini Di ilegei dagoi, na dawa:mu.’ ");
INSERT INTO beo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Na sia:ne gadoi da hame dagoloba, Lebega da hano ganagu gisa manebe ba:i. E hano nasu amoga hano dimusa: sa:i. Na ema amane sia:i, ‘Na da dima edegesa. Hano nama ima.’ ");
INSERT INTO beo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","E hedolo ea ganagu gisi, amo osoba ligisili, amane sia:i, ‘Defea! Moma! Na da dia ga:mele amola ilima hano dili imunu.’ Amalalu, na hano mai, amola e da ga:mele ilima hano i. ");
INSERT INTO beo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Na ema amane adole ba:i, ‘Dia ada nowala:?’ E bu adole i, ‘Na ada da Bediuele amo Na:iho amola Miliga ela mano.’ Amalalu, na da ea mi amoga mi bione gala:su amola ea lobofasele fei. ");
INSERT INTO beo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Na muguni bugili Hina Godema nodone sia:ne gadoi. Na da Hina Godedafa, na hina A:ibalaha:me ea Gode, amo Ea Dio nodone gaguia gadoi. E da moloiwane na hina ea fi amoga doaga:musa: logo olelei dagoiba:le amola na hina ea mano uda lamu amo noga:le oleleiba:le, na nodoi. ");
INSERT INTO beo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Defea! Dilia da moloiwane na hina ea hanai hamomusa: dawa:i galea, nama adoma. Be higa:i galea, amo nama adoma. Amasea, na da fa:no hamomu, amo na da sia:mu. ");
INSERT INTO beo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","La:iba:ne amola Bediuele da bu adole i, “Amo hou Hina Gode Hi hamoiba:le, ninia sia:mu da hamedei. ");
INSERT INTO beo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebega da amogai lela. Lale masa. Hina Godedafa Ea sia: defele, e da dia hina ea mano ema fimu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","A:ibalaha:me ea hawa: hamosu dunu da amo sia: nabaloba, beguduli, Hina Godema nodone sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Amalalu, ea liligi amoga e da abula, silifa, gouli amola muni bagade igi lale, Lebegama i. E da muni bagade liligi Lebega ea ola amola ea:mema i. ");
INSERT INTO beo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Amalalu, A:ibalaha:me ea hawa: hamosu dunu amola ea fidisu dunu da ha:i amola hano nanu golai. Hahabe, nedigili, wa:legadole, e amane sia:i, “Dilia na hina ema na bu asunasima!” ");
INSERT INTO beo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Be Lebega ea ola amola ea:me da amane sia:i, “A:fini da hi afae o eso nabuane gala amo gui esalumu da defea. Amolalu masunu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Be e da bu adole i, “Ninia ouesalumu mae sia:ma. Bai Hina Gode da na sofe ahoasu amola hamobe noga:le didili fidi. Na da na hina ema bu masunu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ilia da bu adole i, “Ninia da a:fini misa:ne sia:mu. Ea sia: nabimu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Amaiba:le, ilia da Lebega misa:ne sia:i. Ilia da ema amane adole ba:i, “Di da amo dunu sigi masa:bela:?” E bu adole i, “Ma!” ");
INSERT INTO beo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Amabeba:le, ilia da Lebega amola ea hawa: hamosu uda da:i, amo A:ibalaha:me ea hawa: hamosu dunu, amola ea fidisu dunu amo sigi masa:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Amola ilia da Lebegama amo hahawane dogolegele sia:su sia:i, “Di, ninia dalusi, dunu fi osea:idafa ilima ame esaloma! Dima lalelegei fi da ilima ha lai dunu, ilima osa:le heda:mu da defea!” ");
INSERT INTO beo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Amalalu, Lebega amola ea a:fini fidisu huluane da liligi momagele, ga:mele da:iya fila heda:le, A:ibalaha:me ea hawa: hamosu dunu sigi asi. A:ibalaha:me ea hawa: hamosu dunu da Lebega oule asi. ");
INSERT INTO beo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisage da dunu hame esalebe hafoga:i soge amo ea dio da “Gode Esala da na Ba:lala amo Ea Hano Nasu Uli Dogoi.” amogai misini esalebe ba:i. Amo da Ga:ina:ne soge ga (south) la:idi dialu. ");
INSERT INTO beo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","E da baloga amo odagiaba sogega ahoanoba, ga:mele manebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Lebega da Aisage ba:loba, ga:mele amoga esalu, gudu aligila sa:i. ");
INSERT INTO beo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","E da A:ibalaha:me hawa: hamosu dunu ema amane adole ba:i, “Amo dunu ninima manebe da nowala:?” A:ibalaha:me ea hawa: hamosu dunu da bu adole i, “E da na hina.” Amaiba:le, Lebega da ea dialuma abula lale, ea odagi dedeboi. ");
INSERT INTO beo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Amalalu, hawa: hamosu dunu da ea hamoi huluane Aisagema olelei. ");
INSERT INTO beo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Amalalu, Aisage da Lebega lale, abula diasu amo ea:me Sela musa: esalu amoga oule misi. Aisage da Lebegama bagade asigi galu. Ea:me Sela da bogoi dagoiba:le e da da:i dioi galu. Be Lebega laiba:le ea dogo denesi. ");
INSERT INTO beo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","A:ibalaha:me da uda eno lai amo ea dio da Gedula. ");
INSERT INTO beo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Gedula da A:ibalaha:mema mano eno lai. Ilia dio da Simala:ne, Yogasia:ne, Mida:ne, Midia:ne, Isaba:ge, amola Siua. ");
INSERT INTO beo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yogasia:ne ea mano da Siba amola Dida:ne. Didane ea mano fifi asi da Asiulaide fi, Ledusaide fi, amola Liumaide fi. ");
INSERT INTO beo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midia:ne ea mano fifi da Ifa, Ife, Ha:noge, Abaida, amola Eleda:ia. Amo huluane da Gedula ea mano fifi asi esalu. ");
INSERT INTO beo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","A:ibalaha:me da bogoloba, ea nana liligi huluane amo Aisagema i. ");
INSERT INTO beo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Be e da esala, e da mano amo ea uda eno ema lai, ilima e da hahawane iasu liligi i. Amalalu, e da amo manolali, Aisage fisima:ne, gusu soge amoga asunasi. ");
INSERT INTO beo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","A:ibalaha:me da ode bagohame amo 175 esalu. ");
INSERT INTO beo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Amalalu, e da mifo lalusu amo fisili, bogoi. E da ea aowalali dunu ilima buhagi. ");
INSERT INTO beo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ea mano aduna (Aisage amola Isiama:ile) da Ma:gafila gele gelabo (Ma:melei amoga gusudili gala) amo ganodini uli dogone Sali. Musa: Ifalone (Hidaide dunu Souha ea mano) da amo sogebi gagui galu. ");
INSERT INTO beo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","A:ibalaha:me da musa: amo sogebi, Hidaide dunuma bidi lai. Amoga A:ibalaha:me amola ea uda Sela gilisili uli dogoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","A:ibalaha:me da bogoi dagoi. Amo fa:no, Gode da A:ibalaha:me egefe amo Aisage hahawane dogolegele ilegele fidi. Aisage da amo esoga “Esalebe Gode da na Ba:lala Hano Uli Dou” amo gadenene esalu. Isiama:ile Egaga Fifi Misi ");
INSERT INTO beo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","A:ibalaha:me ea mano eno amo Isiama:ile, da Sela ea udigili hawa: hamosu Idibidi uda amo Ha:iga amoga lai. Ea hou da hagudu dedei diala. ");
INSERT INTO beo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isiama:ile egefelali ilia dio da dedei. Hidadea da magobo, amola fa:no magobo bagia, amola dogoa, amola ufi agoane dedei. Magobo mano da Niba:iode, amalu Gide amalu A:dabili, amalu Mibasa:me, amalu ");
INSERT INTO beo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima amalu Duma amalu Ma:sa amalu ");
INSERT INTO beo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ha:ida:de amalu Dima amalu Yide amalu Na:ifisi amalu Gedima. ");
INSERT INTO beo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Amo da Isiama:ile egefelali. Ilia da fi gidayale gala ilia aowalali fi esalu. Ilia dio amo ilia da ilia moilai amola fisisu amoma asuli dagoi. ");
INSERT INTO beo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isiama:ile da ode 137 esalu. Amalalu, e da mifo labe fisili, bogoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isiama:ile ea lalelegei fi da soge amo da Idibidi amoma gusu galu amola logo Asilia moilaiga ahoasu gadenene dialu. Amo soge da Hafila soge amola Sioua hafoga:i soge amo dogoa dialebe ba:i. Amo dunu fi da A:ibalaha:me ea mano eno ilima hame gilisi. ");
INSERT INTO beo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","A:ibalaha:me egefe Aisage ea sia: dedei da agoane. ");
INSERT INTO beo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisage da ode 40 esalu, e da Lebega (Bediuele, A:ila:mia dunu Badane Alame sogega esalu amo ea mano amola A:ila:mia dunu La:iba:ne amo ea dalusi) amo lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisage ea uda da aligime esalu. Amaiba:le Aisage da Godema sia:ne gadoi. Gode da amo sia:ne gadosu nabi, amola Lebega da abula agui ba:i. ");
INSERT INTO beo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Lebega da mano aduna lalelegemu galu. Be amo mano aduna da mae lalelegele, ea hagomo ganodini esala gegenanu. Lebega da fofogadigili Hina Godema amane adole ba:i, “Amo hou da abuli nama doaga:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Hina Gode da ema bu adole i, “Fi aduna da dia hagomo ganodini esala. Dima da fi aduna lalelegemu. Afae da eno ea gasa baligimu. Magobo mano da eya ea hawa: hamosu dunu ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Amalalu, Lebega da dunu mano aduna lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Bisili lai da haliga:me agoane ba:i. Ea gadofo da hinabo bagade galu. Amaiba:le ilia da ema Iso dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Fa:no mabe mano da Iso amo ea emo muguni amoga gagui dalebe ba:i. Amaiba:le, ilia da ema Ya:igobe dio asuli. Ela lalelegei eso amoga Aisage da ode 60 lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ela asigilaloba, Iso da benea ahoasu hou bagade dawa:i. E da gadili odagiabaga lalumu hanai galu. Be Ya:igobe e da asaboi dunu. E da diasuga esalumusa: hanai galu. ");
INSERT INTO beo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisage da Iso ea dadi gala:i liligi manusa: hanaiba:le, Isoma bagade hahawane galu. Be Lebega ea dogolegei mano da Ya:igobe. ");
INSERT INTO beo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Eso afaega Ya:igobe da da:iyene amola hano gilisili gobele, ha:i manu ida:iwane hamoi. Iso logo sedagaga benea ahoabeba:le, bagadewane ha:iba:le, sidimu agoaiwane, diasuga doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","“Hedolo! Na bogosa:besa:le, amo yoi ha:i manu nama ima,” Iso da Ya:igobema amane sia:i. (Amaiba:le, ilia da ema Idome Yoi dio asuli.) ");
INSERT INTO beo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ya:igobe da ema amane sia:i, “Defea! Be hidadea dia magobo mano lamu nana liligi ilegei, amo nama lama:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso e bu adole i, “Defea! Amo lama! Na bogosea, amo liligi da hamedei liligi agoane ba:mu. Be ha:i manu ima!” ");
INSERT INTO beo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ya:igobe da bu adole i, “Hidadea di da magobo mano nana liligi ilegei amo nama imunu gasa bagade ilegele sia:ma!” Amaiba:le, Iso da amo magobo mano lamu nana liligi ilegei huluane Ya:igobema ima:ne, gasa bagade ilegele sia:i. ");
INSERT INTO beo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Amalalu, Ya:igobe da agi amola da:iyene hano amo Isoma i. E da amo nanu, wa:legadole yolesili asi. Iso da ea magobo mano lamu nana hahawane liligi ilegei amo hamedei liligi agoane dawa:beba:le, udigili fisi. ");
INSERT INTO beo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Soge huluane da ha:i bagade eno ba:i. Musa:, A:ibalaha:me ea esoga ha:i bagade ba:i, be amo da eno. Aisage da Abimelege amo Filisidini hina bagade Gila moilai bai bagade ganodini esalu, ema asi. ");
INSERT INTO beo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Hina Gode da Aisagema misini, amane sia:i, “Idibidi amoga mae masa. Be na olelemu soge amo ganodini esaloma. ");
INSERT INTO beo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Amo soge ganodini fonobahadi ouesaloma. Amalalu, Na amola gilisili esalumu amola dima hahawane dogolegele fidimu. Bai Na da amo soge huluane Na da dima amola dia fa:no lalelegemu fi ilima imunu. Na da gousa:su dia ada A:ibalaha:mema hamoi, amo Na da didili hamomu. ");
INSERT INTO beo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Na da digaga fi dunu amo gasumuni ilia idi defele hamomu. Amo soge huluane ilima imunu. Amola ilia houba:le, osobo bagade fifi asi gala huluane da hahawane dogolegele hou ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Bai A:ibalaha:me da Na sia: nabasu. E da Na hanai amola Na Sema amola Na hamoma:ne sia:i huluane mae fili, nabasu hou hamosu. ");
INSERT INTO beo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Amaiba:le, Aisage da Gila moilai bai bagade ganodini esalu. ");
INSERT INTO beo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Amo soge dunu da ea uda ea hou ema adole ba:loba, e da amane sia:i, “E da na dalusi.” E da, “Amo da na uda” sia:musa: bagade beda:i galu. Bai e agoane dawa:i, “Amo soge dunu da Lebega da na uda dawa:sea, na fane legemu. Bai e da noga:iwane ba:sa.” ");
INSERT INTO beo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisage amogai eso bagohame esaloba, Filisidini hina bagade dunu Abimelege, da ea fo misa:ne agenesi amoga gududili ba:loba, Aisage ea uda Lebega amo nonogonanebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Amaiba:le, Abimelege da Aisagema misa:ne sia:i. E da amane sia:i, “Amo da dia uda. Di da abuli, ‘amo da na dalusi’ sia:bela:?” Aisage da ema bu adole i, “Na da enoga medosa:besa:le, agoane hamoi.” ");
INSERT INTO beo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Amalalu, Abimelege da amane sia:i, “Di da ninima adi hamobela:? Ninia fi dunu afae da ema gilisili golai ganiaba, ninia huluane da wadela:i dunu fi ba:la:loba.” ");
INSERT INTO beo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Amaiba:le, Abimelege da ea fi dunu ilima amane sia:i, “Nowa da amo dunu o ea uda wadela:sea, amo dunu ninia fane legemu.” ");
INSERT INTO beo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisage da amo soge ganodini, ha:i manu bugi. Hina Gode da hahawane dogolegelewane fidibiba:le, amo bugi da ha:i manu bagade legei. ");
INSERT INTO beo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","E da bagade gagui dunu agoane ba:i. Ea gagui da asigilabeba:le, ea gagui da bagadedafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","E sibi, goudi amola bulamagau bagohame gaguiba:le, Filisidini dunu da e mudale ba:i. ");
INSERT INTO beo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Amaiba:le, Filisidini dunu da hano uli dogoi huluane amo ea ada hawa: hamosu dunu da A:ibalaha:me ea esoga dogoi, amo huluane ga:si. Ilia huluane osoboga nabasu. ");
INSERT INTO beo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Amalalu, Abimelege da Aisagema amane sia:i, “Di nini yolesili masa! Bai di da gasa bagade hamoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Amaiba:le, Aisage da amo soge yolesili, Gila Fago amoga esalu. ");
INSERT INTO beo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Amoga hano uli dogoi amo A:ibalaha:me ea esoga dogoi be Filisidini dunu da ga:i, amo Aisage bu doasi. Amola dio A:ibalaha:me da amo uli dogoi amoma asuli, amo dio Aisage bu asuli. ");
INSERT INTO beo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisage da umi amo ganodini dogolalu, noga:iwane hano ba:i. ");
INSERT INTO beo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Be Gila sibi ouligisu dunu da Aisage ea sibi ouligisu dunu ilima sia:ga gegei. Ilia amane sia:i, “Amo hano da ninia:.” Amaiba:le, e da amo hanoma “Sia:ga Gegesu” dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Amalalu ilia da hano uli dou eno dogoi. Be ilia amoga eno sia:ga gegei. Amaiba:le, e da amo hanoma Sidina (Ha Lai) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Bu asili, e da hano uli eno dogoi. Amoga ilia da hame sia:ga gegei. Amaiba:le, e da amo hano uli dogoima Lihoubode (Hahawane Halegale Lala) dio asuli. E amane sia:i, “Wali Hina Gode da sogebi defele ninima ia dagoiba:le, ninia da hahawane soge ganodini udigili lala.” ");
INSERT INTO beo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Amoga asili, e da Biasiba amoga asi. ");
INSERT INTO beo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Amo gasia, Hina Gode da ema misini amane sia:i, “Na da dia ada A:ibalaha:me amo ea Gode esala. Mae beda:ma! Na da di amola gilisili lala. Na da Na hawa: hamosu dunu A:ibalaha:mema hahawane sia:beba:le, Na dima hahawane dogolegele hamomu amola digaga lalelegemu fi amo bagade hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aisage da amo sogega oloda hamone, Hina Godema nodone sia:ne gadoi. E amoga abula diasu gagui, amola ea hawa: hamosu dunu da hano uli dogoi. ");
INSERT INTO beo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelege, ea fidisu dunu Ahusa:de amola ea dadi gagui dunu hina amo Fa:igole da Gila moilai bai bagade yolesili, Aisagema doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Amalalu, Aisage ema amane adole ba:i, “Di da musa: nama ha laiba:le, dia soge fisili masa:ne nama sia:i dagoi. Amaiba:le, di abuliba:le nama waha misi?” ");
INSERT INTO beo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ilia bu adole i, “Wali ninia dawa:! Hina Gode da dia fidisu esala. Ninia wali gousa:sudafa hamomu da defea. ");
INSERT INTO beo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Di ninima se maedafa ima:ne sia:ma. Ninia da dima se hame i, amo defele di da nini fidimu da defea. Ninia da dima asigi hou hamonanu, dia ga masa:ne logo doasi dagoi. Amola wali Hina Gode da dima hahawane dogolegele ilegei dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aisage da ili moma:ne, lolo nasu hamoi. Ilia huluane ha:i amola waini hano mai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Aya hahabedafa, Aisage amola Filisidini dunu da gousa:su hamoi. Aisage da ilima “asigibio” sia:nanu, ilia olofole agoane afafai. ");
INSERT INTO beo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Amo esoga, Aisage ea hawa: hamosu dunu da ema misini, ilia da hano uli dogoi amo olelei. Ilia da amane sia:i, “Ninia hano ba:i dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","E da amo hano Siba (“hou ilegele sia:” o eno dawaloma:ne da “fesuale hano”). Biasiba da amoga ea dio lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso da ode 40 lai dagoi. Amalalu, e da Hidaide a:fini aduna lai dagoi. Afae ea dio da Yudide amo Bieli ea mano. Eno da Basemade amo Ilone ea mano. ");
INSERT INTO beo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Aisage amola Lebega da amo hou ba:beba:le, se bagade nabasu. ");
INSERT INTO beo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisage da da:idafa hamoi galu. Ea si amola da dofoi dagoi. Eso afaega e da ea magobo mano misa:ne sia:i. E da ema amane sia:i, “Nagofe!” Iso bu adole i, “Na wea!” ");
INSERT INTO beo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisage da amane sia:i, “Na da da:i hamoi dagoi. Na bogomu eso hame dawa:. ");
INSERT INTO beo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Dia dadi lale, sogega asili, na moma:ne sigua ohe fi afae fane legema. ");
INSERT INTO beo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Amalalu, ha:i manu amo na hanai liligi gobelalu, nama gaguli misa. Na da amo nanu, magobo mano amoma Gode Ea hahawane dogolegele ilegema:ne defele nana sia:su, amo dima imunu. ");
INSERT INTO beo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Lebega da Aisage amo Isoma sia: daloba nabi dagoi. Amaiba:le, Iso da benea ahoanoba, ");
INSERT INTO beo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","e da Ya:igobema amane sia:i, ‘Na da wali dia ada Isoma sia: dalebe nabi. E amane sia:i, ");
INSERT INTO beo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Sigua ohe amo na moma:ne gaguli misa. Na da amo ha:i nanu, na da bogomu gadeneiba:le, Gode ba:ma:ne dima magobo mano hahawane dogolegele ilegema:ne nana sia: imunu.’ ");
INSERT INTO beo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Defea! Nagofe! Nabima! Na da hou dima olelemu. ");
INSERT INTO beo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Di da goudi gilisisu amoga asili, goudi mano aduna sefena gala amo lama. Amo na da gobele, dia ada ea hanai ha:i manu hamomu. ");
INSERT INTO beo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Amalalu, e moma:ne di gaguli masa. E da mae bogole, magobo mano hahawane dogolegele ilegema:ne nana sia: dima imunu. ");
INSERT INTO beo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Be Ya:igobe da ea:mema bu adole i, “Di dawa:! Iso ea gadofo da hinabo bagade gala. Be na da:i da hinabo hame. ");
INSERT INTO beo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Na ada da na gadofo digili ba:sea, e da na ogogoi dawa:mu. Amasea na da hahawane dogolegele ilegesu sia: mae ba:le, gagabusu aligi dagoi fawane ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ea:me bu adole i, “Nagofe! Gagabui aligisu da doaga:sea, amo da dima hame be nama fawane doaga:mu. Na sia: defele hamoma. Di goudi amo nama gaguli misa.” ");
INSERT INTO beo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Amaiba:le, e da goudi lala asili, ema bu gaguli misi. Lebega da Aisage ea hanai ha:i manu gobei. ");
INSERT INTO beo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Amalalu, Lebega da Iso ea abula noga:i amo da diasu ganodini dialu, amo lale, Ya:igobema idiniginisi. ");
INSERT INTO beo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","E da goudi ea gadofo amo Ya:igobe ea laboso amola ea ogomagi, amoga ligisi. ");
INSERT INTO beo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","E da ha:i manu hedai gala, amola agi gobei Ya:igobema i. ");
INSERT INTO beo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Amalalu, Ya:igobe da ea adama asili, amane sia:i, “Ada!” Aisage da bu adole ba:i, “Di da na mano habola:?” ");
INSERT INTO beo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ya:igobe da bu adole i, “Na da dia magobo mano amo Iso. Na da dia hamoma:ne sia:i amo hamoi dagoi. Di wa:lefima. Hu amo na da dima gaguli misi, moma. Amasea, ada! Dia hahawane dogolegele sia: sia:musa: sia:i amo sia:ne ima.” ");
INSERT INTO beo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aisage da amane adole ba:i, “Nagofe! Di da habodane hedolodafa amo ha:i manu ba:bala:?” Ya:igobe da bu adole i, “Dia Hina Gode da fidibiba:le, na da hedolo ba:i.” ");
INSERT INTO beo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aisage da Ya:igobema amane sia:i, “Na da di digili ba:musa:, gadenene misa. Di da dafawane Isola:?” ");
INSERT INTO beo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ya:igobe da ea ada gadenene misi. Aisage da ea gadofo digili ba:lalu, amane sia:i, “Dia sia: da Ya:igobe ea sia: defele naba, be dia laboso da Iso ea laboso defele digili ba:sa.” ");
INSERT INTO beo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ya:igobe ea laboso da hinabo bagade Iso ea laboso defele amo dawa:beba:le, e da lelu dunu da Ya:igobe hame dawa:i galu. E da ema Gode da hahawane dogolegele fidima:ne magobo mano nana sia: defei imunusa: dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Be e bu adole ba:i, “Di da dafawane Isola:?” “Ma,” Ya:igobe bu adole i. ");
INSERT INTO beo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aisage da amane sia:i, “Ohe hu afae nama gaguli misa. Amo nanu na da dima hahawane dogolegele misa:ne hou sia: imunu.” Ya:igobe da amo ha:i manu gaguli misi amola waini hano gaguli misi. ");
INSERT INTO beo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Amalalu, ea ada da ema amane sia:i, “Gadenene misa, nagofe! Nama nonogoma!” ");
INSERT INTO beo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","E da nonogomusa: manoba, Aisage da ea abula naba ba:i. E da ema hahawane dogolegele misa:ne hou nana sia: sia:i dagoi. E amane sia:i, “Na mano ea naba ba:su da gisi soge amo Gode da hahawane hamoi, amo ea gabusiga: defele gala. ");
INSERT INTO beo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gode da dima hebene doasili, oubi baea dima imunu da defea. E da dia soge osobo amo ha:i manu bagade heda:ma:ne hahamomu. E da gagoma amola waini hano bagohame dima imunu da defea. ");
INSERT INTO beo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dunu fifi asi gala da dima hawa: hamosu dunu ba:mu da defea. Dunu huluane da dima begudumu, amola di da dia fi dunu ilima hinawane esalumu. Dia:me ea mano da dima begudumu da defea. Dunu da dima gagabusu aligima:ne sia:sea, ilima gagabusu aligimu da defea, amola nowa da dima hahawane dogolegele sia:sea, ilia amola da hahawane dogolegele iasu ba:mu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisage da Ya:igobema hahawane dogolegele magobo mano nana misa:ne sia: i dagoi. Amanoba, Ya:igobe da yolesili asi. Amola Iso da benea ahoanu, misi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","E amola da ha:i manu ida:iwane gobele, ea adama gaguli misi. E da adama amane sia:i, “Di wa:lefima! Hu amo na da dima gaguli misi moma! Amasea, ada dia hahawane dogolegele sia: sia:musa: nana sia:i amo sia:ne ima.” ");
INSERT INTO beo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisage da amane adole ba:i, “Di da nowala:?” E da bu adole i, “Na da dia magobo mano Iso.” ");
INSERT INTO beo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisage da bagade yaguguli, amane adole ba:i, “Amaiba:le, nowa da ohe medole, nama gaguli misibala:? Wahadafa, di mae misini na da mai dagoi. Na da magobo mano hahawane dogolegele nana sia: ema iabeba:le, amo da mae yolesili dialalalumu.” ");
INSERT INTO beo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Amo nabaloba, Iso da digini wele sia:i, “Ada! Dia hahawane dogolegele misa:ne nana sia: nama amola ima!” ");
INSERT INTO beo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Be Aisage da bu adole i, “Diaeya da misini nama ogogoi dagoi. E da dia hahawane dogolegele misa:ne hou nana sia: amo wamolai dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iso da amane sia:i, “E da musa: amola wali nama ogogoi. Ea dio da Ya:igobe (ogogosu gagusu) dafawane. E na magobo mano nana liligi amo lai amola wali e da nama hahawane dogolegele misa:ne sia: amo wamolai dagoi. Di da hahawane dogolegele misa:ne hou sia: afadafa nama ima:ne ganabela:?” ");
INSERT INTO beo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisage e bu adole i, “Na da e amo dima hina hamoi dagoi amola ea fi ema udigili hawa: hamosu dunu esaloma:ne, na hamoi dagoi. Na da gagoma amola waini hano ema i dagoi. Na dima eno imunu hamedei ba:sa.” ");
INSERT INTO beo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iso da mae yolesili, Aisagema edegelalu. “Ada! Hahawane dogolegele misa:ne hou sia: afadafa nama ima! Di da afadafa fawane gaguila:?” E muni dinanu. ");
INSERT INTO beo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Amalalu, Aisage ema amane sia:i, “Dia da mu amoga oubi baea hame ba:mu. Ha:i manu soge noga:i hame ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Di da gobihei bagadega gegesea fawane ha:i manu amola esalebe diasu amola ba:mu. Di da diaeya amo ea udigili hawa: hamosu dunu ba:mu. Be di da ea sia: mae nabawane odoga:sea, ea ouligisu yolesimu.” ");
INSERT INTO beo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Aisage da Ya:igobema hahawane dogolegele misa:ne hou sia:i dagoiba:le, Iso da Ya:igobe bagade higasu. E amane dawa:i, “Na ada ea bogomu da gadenei. Amasea, ema asigi didiga:su dagosea, na da Ya:igobe fane legemu.” ");
INSERT INTO beo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Be Lebega da Iso ea ilegesu nabaloba, e da Ya:igobe misa:ne sia:ne, ema amane sia:i, “Nabima! Dia ola Iso da dima dabemu. E da di fane legemusa: dawa:lala. ");
INSERT INTO beo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nagofe! Na sia: noga:le nabima! Di da na ola La:iba:ne, ea diasu amo Halane soge ganodini diala, amoga masa. ");
INSERT INTO beo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Dia ola ea ougi amo gumima:ne, La:iba:ne ea diasuga ouesaloma. ");
INSERT INTO beo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Dia ola da di da ema hamoi gogolesea, na da di guiguda: oule misa:ne, dunu eno dima asunasimu. Na da na mano aduna eso afae amo ganodini fisimu bagadewane higasa.” ");
INSERT INTO beo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebega da Aisagema amane sia:i, “Na da Iso ea ga fi uda lai amo ela houga bagade helebe. Ya:igobe da amo Hidaide uda lasea, na da bogomu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Amaiba:le, Aisage da Ya:igobe misa:ne sia:i. E da ema hahawane dogolegele sia:i. E amane sia:i, “Di da Ga:ina:ne a:fini mae lama! ");
INSERT INTO beo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Be di da Mesoubouda:imia soge amo dia aowa Bediuele ea soge amoga masa. Amogai, di da dia daiya La:iba:ne, amo ea uda mano afae lama. ");
INSERT INTO beo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Gode Bagadedafa da dia lasu hou hahawane dogolegele hamomu amola dima mano bagohame imunu da defea. Amasea, di da fifi asi gala bagohame ilima ada agoane ba:mu da defea. ");
INSERT INTO beo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Gode da A:ibalaha:me hahawane dogolegele fidi dagoi. Amo defele, E da di amola digaga fi dilima hahawane dogolegele fidimu da defea. Dia wali esalebe soge amo Gode da A:ibalaha:mema i, amo soge di lamu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Amalalu, Aisage da Ya:igobe amo Mesoubouda:imia sogega asunasi. E da La:iba:nema asunasi. La:iba:ne da Bediuele (A:ila:mia dunu) amo ea mano esalu. E da Lebega (Ya:igobe amola Iso ame) amo ea ola. ");
INSERT INTO beo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aisage da Ya:igobema hahawane dogolegele sia:i, amola Badane Alame amoga uda lamusa: asunasi, amo huluane Iso da nabi dagoi. E eno amane nabi amo Aisage da Ya:igobema amane sia:i, “Ga:ina:ne uda maedafa lama.” ");
INSERT INTO beo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ya:igobe da ada amola ame ela sia: nababeba:le, Badane Alame sogega asi dagoi, amo amola e da ba:i. ");
INSERT INTO beo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Amanoba, e da ea ada da Ga:ina:ne uda hahawane hame ba:i amo dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Amaiba:le, e da Isiama:ile (A:ibalaha:me ea mano) ema asili, amola Ma:ihala:de (Niba:iode ea dalusi) amo lai dagoi. Ma:ihala:de da Isiama:ile ea idiwi galu. ");
INSERT INTO beo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ya:igobe da Biasiba moilai yolesili, Halane moilaiga doaga:musa: asi. ");
INSERT INTO beo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Eso dabe, daeya, e da sogebi afae doaga:le, gele afae lale, busafugulu hamone, gola midi. ");
INSERT INTO beo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","E simasia ba:i. E fa:gu bagade, osoboga bugila dalebe ba:i. Fa:gu ea banuguma, Hebene muagado doaga:i. Gode Ea a:igele dunu bagohame fa:guba:le gado heda:lebe amola gudu dalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Amalalu, e da Hina Gode ema dafulili lelebe ba:i. Hina Gode da Ya:igobema amane sia:, “Na da dia ada A:ibalaha:me ea Gode, amola Aisage ea Gode. Dia gola midi soge na digili imunu. ");
INSERT INTO beo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dia mano ilia da osobo ea su idi defele agoane heda:mu. Dia fi ilia da soge guma:goe amola gusugoe, ga (south) amola ga (north) amo huluane nabamu. Na da dia fi amo ganodini hawa: hamosea, dunu fifi asi gala huluane da hahawane dogolegesu bagade ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mae gogolema! Dilia da habidili ahoasea, Na amola da di gaga:musa: oule masunu. Fa:nowane Na da di amo sogega bu oule misunu. Na da di mae yolesili, Na ilegele sia:i liligi huluane didili hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ya:igobe da bu nedigili amane sia:i, “Dafawane! Hina Gode da gui soge ganodini esala. E da guiguda: esala, be na da hame dawa:i galu.” ");
INSERT INTO beo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","E da bagade beda:i galu amola amane sia:i, “Amo soge ganodini na da bagade beda:i. Amo da Gode Ea diasu. Dafawane! Amo da Hebene heda:su logo holei gala.” ");
INSERT INTO beo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Golale hahabe, Ya:igobe da wa:legadole, gele ea busafugului amo lale, Godema dawa:ma:ne wanonesi. E da amo gele wanonesisu Godema modale ligiagama:ne, amo da:iya olife susuligi sogadigi. ");
INSERT INTO beo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Amo sogebiga e da Bedele dio asuli. (Moilai amo sogebi galu da musa: Luse) ");
INSERT INTO beo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Amalalu, Ya:igobe da Godema amane ilegele sia:i, “Dafawane! Di da na masunu logo noga:le ouligisia, amola na ha:i manu amola na abula nama iasea, ");
INSERT INTO beo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","amola na da hahawane na ada diasuga bu doaga:sea, Di da na Godedafa esaloma:ne, na da ilegesa. ");
INSERT INTO beo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Amo wanonesisu na Dima dawa:digima:ne bugi da Dima nodone sia:ne gadosu sogebi agoane. Amola Dia nama iasu liligi na da nabuane momogili, afadafa Dima bu imunu.” ");
INSERT INTO beo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ya:igobe da asili, eso maba la:idi soge amoga asi. ");
INSERT INTO beo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","E da hano nasu uli dou gisi soge ganodini diala, amoga doaga:i. Amo uli dogoi gadenene, sibi gilisisu udiana dialebe ba:i. Sibi gilisisu da amo uli dogoiga hano nasu. Uli dogoi da gele bagadega ga:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Hou da agoane galu. Sibi gilisisu da uli dogoiga doaga:laloba, sibi ouligisu dunu da gele bagade amo bebesole, hano nasu amo sibima olelesu. Hano nanu, sibi ouligisu da uli dogoi gele bagadega bu ga:su. ");
INSERT INTO beo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ya:igobe da sibi ouligisu dunuma amane adole ba:i, “Dilia da habidili misibila:?” Ilia da bu adole i, “Ninia da Halane soge dunu.” ");
INSERT INTO beo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","E da bu adole ba:i, “Dilia da La:iba:ne, Na:iho ea aowa amo dawa:bela:?” “Ma! Ninia dawa:!” ilia amane sia:i. ");
INSERT INTO beo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ya:igobe amane adole ba:i, “E da hahawane esalabala?” Ilia bu adole i, “E da hahawane esala! Ba:ma! Idiwi La:isele, La:iba:ne ea uda mano a:fini da ea sibi gilisisu oule manebe goea!” ");
INSERT INTO beo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ya:igobe da amane sia:i, “Wali da esomogoa fawane. Amaiba:le, sibi amo diasuga gilisimu da hamedei. Dilia sibi ilima hano dili ianu, bu gisi sogega oule masunu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ilia da bu adole i, “Amai da hame hamomu! Sibi gilisisu huluane da doaga:sea fawane, ninia da gele bagade bebesole, sibi ilima hano dili imunu.” ");
INSERT INTO beo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ya:igobe da ilima sia: daloba, La:isele da ea sibi gilisisu oule misini, doaga:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ya:igobe da La:isele amo ea daiya La:iba:ne ea sibi oule manebe ba:loba, e da hano nasu uli dogoi amoga asili, gele bebesole, sibi ilima hano dili i. ");
INSERT INTO beo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Amalalu, e da La:isele amo nonogoi, amola hahawane bagadeba:le, dinanu. ");
INSERT INTO beo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","E da La:iselema amane adole i, “Na da dia ada esoa:bi, Lebega ea mano.” La:isele da ea ada amo adomusa: hehenane asi. ");
INSERT INTO beo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","La:iba:ne da esoa:bi Ya:igobe misi dagoi amo nababeba:le, hehenane, ema doaga:le, nonogone, hi diasuga oule asi. Ya:igobe da ea hou huluane ema olelei. ");
INSERT INTO beo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Amalalu, La:iba:ne da amane sia:i, “Dafawane! Di da na fi dunu maga:me afae amoga hamoi.” Ya:igobe da oubi afae amoga ea diasuga esalu. ");
INSERT INTO beo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","La:iba:ne da Ya:igobema amane sia:i, “Di da na fi dunuba:le na hawa: hamosu udigili hamomu da defea hame galebe. Di da bidi habodayane lama:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","La:iba:ne da uda mano aduna esala. Magobo mano da Lia amola eno da La:isele. ");
INSERT INTO beo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lia ea si da gasa hame galu. Be La:isele ea da:i hodo da noga:iwane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ya:igobe da La:iselema bagade magesa:i. Amaiba:le e da La:iba:nema amane sia:i, “Na da La:isele amo lamusa:, ode fesuale dima hawa: hamomu da defeala:?” ");
INSERT INTO beo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","La:iba:ne da bu adole i, “Na da dunu enoma imunu higa:i. Dima fawane imunu. Nama ouesaloma!” ");
INSERT INTO beo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ya:igobe da ode fesuale La:isele lama:ne hawa: hamosu. E da ema bagade asigiba:le, amo ode da eso bagahame defele ba:i. ");
INSERT INTO beo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Amalalu, Ya:igobe da La:iba:nema amane sia:i, “Na ode da gidigi dagoi. Na da dia mano lamu galebe.” ");
INSERT INTO beo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Amaiba:le, La:iba:ne da uda lasu lolo Nasu bagade hamoi. E da dunu huluane misa:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Be gasia, e da La:isele fisili, Lia amo Ya:igobema oule misi. Amalalu, Ya:igobe da Lia amo gilisili golai. ");
INSERT INTO beo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(La:iba:ne da ea udigili hawa: hamosu a:fini Siliba amo Lia hi hawa: hamomusa:gini i dagoi.) ");
INSERT INTO beo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Golale hahabe, Ya:igobe da uda da ema gilisili golai da La:isele hame be Lia ba:i. E da La:iba:nema asili amane sia:i, “Di da abuli amo hou nama hamobela:? Na da La:isele lamusa: hawa: hamoi dagoi. Di da abuliba:le nama ogogobela:?” ");
INSERT INTO beo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","La:iba:ne da bu adole i, “Ninia hou guiguda: da ninia magobo uda mano bisili dunuga lama:ne iaha. Fa:no eno uda mano iaha. ");
INSERT INTO beo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Be uda lasu lolo nasu hi afae da dagosea, defea, na da La:isele amola dima imunu. Be amo lama:ne, di da na hawa: hamosu ode fesuale eno hamoma.” ");
INSERT INTO beo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ya:igobe da amo hamomu sia:i. Amalalu, hi afae aligili, La:iba:ne da ea mano La:isele amo ema i. ");
INSERT INTO beo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(La:iba:ne da ea udigili hawa: hamosu a:fini ea dio amo Biliha amo La:isele fidimusa: i.) ");
INSERT INTO beo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ya:igobe da La:isele amo gilisili golai. Ea magesa:i hou ema da ea asigi hou Lia ema baligi dagoi. Amalalu, e da La:iba:ne ea hawa: hamosu ode fesuale eno hamoi. ");
INSERT INTO beo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Hina Gode da Ya:igobe ea hou amo La:iselema bagade asigi amola Liama fonobahadi asigi amo ba:beba:le, Gode da Liama mano lama:ne logo fodoi. Be La:isele da aligime esalu. ");
INSERT INTO beo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia da abula agui, dunu mano lalelegei. E amane sia:i, “Hina Gode da na se nabasu ba:i dagoi. Wali nagoa da nama asigimu.” Amaiba:le, e da dio asuli amo Liubene (Se Nabasu Ba:i) ");
INSERT INTO beo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Amalalu, e da bu eno abula agui ba:i. Dunu mano eno da lalelegele, Lia da amane sia:i, “Hina Gode da Ya:igobe da nama hame asigi amo nababeba:le, mano nama i.” Amaiba:le, amo manoma e da Simione (Nabasu dunu) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","E da bu eno abula agui. Dunu mano eno lai. E amane sia:i, “Wali na da dunu mano udiana laiba:le, nagoa da nama la:gi dagoi ba:mu.” Amaiba:le, e da amo manoma Lifai (La:gi) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Amalalu, e da abula agui, dunu mano eno lai. E da amane sia:i, “Wali na da Hina Godema nodomu.” Amaiba:le, e da amo manoma Yuda (Nodosu) dio asuli. Amalalu, e da mano lasu yolesi. ");
INSERT INTO beo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Be La:isele da Ya:igobe ea mano hame laiba:le ea dalusima mudasu ba:i. E da Ya:igobema amane sia:i, “Di da nama mano hame iasea na da bogomu.” ");
INSERT INTO beo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","La:isele ea sia: nababeba:le, Ya:igobe da ougi ba:i. E amane sia:i, “Na da Gode Ea sogebi lamu da hamedei galebe. Hi fawane da dia mano lamu logo ga:sisa.” ");
INSERT INTO beo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","La:isele da amane sia:i, “Di da na udigili hawa: hamosu a:fini Biliha, amo lama. Di amola e gilisili golama. Amasea, e da mano lasea, na da amo mano ea ame esalumu.” ");
INSERT INTO beo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","E da Biliha amo egoama i. Amalalu, Ya:igobe da e amola gilisili golai. ");
INSERT INTO beo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha da abula agui, dunu mano lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","La:isele da amane sia:i, “Gode da na fidima:ne fofada:i dagoi. E da na sia:ne gadosu nabalu, dunu mano nama i dagoi.” Amaiba:le, e da ea manoma Da:ne (Fidima:ne fofada:su) dio asuli dagoi. ");
INSERT INTO beo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha da bu abula agui, Ya:igobe ea dunu mano eno amola lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","La:isele da amane sia:i, “Na da na dalusima bagadewane gegei galu. Be na da osa:le heda:i dagoi. Amaiba:le e da amo manoma Na:badalai (Gegesu) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lia da ea mano lamu logo ga:i dagoi amo dawa:beba:le, e da ea udigili hawa: hamosu a:fini Siliba amo Ya:igobema i. ");
INSERT INTO beo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Amalalu, Siliba da Ya:igobe ea dunu mano lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lia da amane sia:i, “Na da hahawane udigili lai!” Amaiba:le e da Ga:de (Hahawane udigili Lai) dio ema asuli. ");
INSERT INTO beo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Siliba da Ya:igobe ea dunu mano eno lai. ");
INSERT INTO beo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lia da amane sia:i, “Na da hahawane bagade! Eno uda da na da hahawane sia:mu. Amaiba:le, e da amo manoma A:sie (Hahawane) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Widi faisu eso amoga, Liubene da gisi sogega asili, sogea liligi amo mano lasu fidisu liligi ilia da dawa:i galu, (ma:nadala:igi) amo fili, ea:me Liama gaguli misi. La:isele da Lia ema amane sia:i, “Dia mano ea sogea lai liligi amo mogili nama ima.” ");
INSERT INTO beo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lia da bu adole i, “Di da nagoa wamolai dagoi. Amo da hamedei liligi di da dawa:bela:? Be wali di da na mano ea sogea liligi amo amola lamusa: dawa:lala. La:isele da amane sia:i, “Di da dia mano ea sogea liligi amo nama iasea, di amola Ya:igobe da wali gasia gilisili golamu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Daeya, Ya:igobe da ifabi amoga misini, Lia da logoga e yosia:musa: asi. Lia da amane sia:i, “Ania da wali gasia gilisili golamu galebe. Na da na mano ea sogea amoga di bidi lai dagoi.” Amaiba:le, Ya:igobe da e amola gilisili golai. ");
INSERT INTO beo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Gode da Lia ea sia:ne gadosu nabi dagoi. E da abula agui, Ya:igobe ea dunu mano eno - amo da mano bi gala lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lia da amane sia:i, “Na da na hawa: hamosu a:fini nagoama i dagoiba:le, Gode da nama hahawane bidi i dagoi. Amaiba:le, e da ea manoma Isiga (Dunu Bidiga Lai) amo dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lia da bu abula agui ba:i. E da Ya:igobe ea dunu mano gafe lalelegei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","E amane sia:i, “Gode da nama hahawane udigili iasu i dagoi. Wali, na da nagoama dunu mano gafeyale ia dagoiba:le, e da na hahawane lamu. Amaiba:le, e da amo manoma Sebiulane (Hahawane Iasu Lai) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Fa:no, Lia da uda mano lai dagoi. E da ema Daina dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Amalalu, Gode da bu La:isele dawa:i. E da ea sia:ne gadosu nabi. E da ea mano lamu logo doasi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","E da abula agui, dunu mano lalelegei. E amane sia:i, “Gode da nama dunu mano ia dagoiba:le, na gogosiasu fadegai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","E da nama eno dunu mano imunu da defea. Amaiba:le, e da amo manoma Yousefe (Eno imunu da defea) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yousefe da lalelegei dagoloba, Ya:igobe da La:iba:nema amane sia:i, “Na da na diasuga masunu. Na masa:ne logo doasima. ");
INSERT INTO beo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Na uda amola mano amo na da dia hawa: hamosu hamoiba:le bidi lai, amo huluane nama ianu na da masunu galebe. Di dawa:. Na da dia hawa: hamosu noga:le hamoi. ");
INSERT INTO beo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","La:iba:ne da ema amane sia:i, “Na da ba:la:lusu dunu agoane. Na agoane ba:i. Dia hawa: hamobeba:le, Gode da nama hahawane dogolegele hamoi. ");
INSERT INTO beo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Dima bidi imunu defei, amo di fawane sia:ma. Amasea, na da amo dima imunu” ");
INSERT INTO beo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ya:igobe da amane sia:i, “Di da na hawa: hamosu dawa:. Na da dia sibi noga:le ouligisu. Amaiba:le, ilia idi da noga:le heda:i amola di da bagade gaguiwane ba:sa. ");
INSERT INTO beo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Musa: na da mae misini, dia sibi da bagahame galu. Be wali bagohame ba:sa. Na da fidibiba:le, Gode da dima hahawane dogolegele fidisu. Wali na da ni liligi amo dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","La:iba:ne da amane sia:i, “Na da dima adi ima:bela:?” Ya:igobe da bu adole i, “Na da muni hame lamu. Di da na adole ba:su hahawane ba:sea, na da dia sibi bu ouligimu. ");
INSERT INTO beo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Be wali eso na da dia sibi fi amoga bunumai sibi mano, amola goudi hoholei o daginisisi, amo huluane na da lamu. Amo bidi fawane na da lamu. ");
INSERT INTO beo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Amola hobea di da na hou hedolo ba:mu. Di da na hou ba:la masea, hoholei o daginisisi hame hamoi goudi o bunumai hame sibi ba:sea, amo da wamolai dagoi di da dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","La:iba:ne da bu adole i, “Defea! Dia sia: defele ninia da hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Be amo eso La:iba:ne da goudi gawali hoholei amola aseme fifi amola daginisisi huluane, amola bunumai sibi amo fadegale, egefelali ili ouligima:ne oule asi. ");
INSERT INTO beo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Amalalu, e da Ya:igobe fisili, eso udiana asili, eno sogega doaga:i. Be Ya:igobe da La:iba:ne ea sibi eno ouligisu. ");
INSERT INTO beo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ya:igobe da ifa amoda lale, ea gadofo mogili amo gobiheiga gagaselele, amoda da ahea:iai amola bunumai, amo fifi agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Amo ifa amoda e da sibi gilisisu ilia hano nasu ofodo gadenene ligisi. Bai fofoi ohe da hano na misini, mano lama:ne agusu. ");
INSERT INTO beo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Amaiba:le, goudi da mano hamoma:ne ifa ba:le gaidiga hamosu, ilia mano da fa:no lalelegeloba hoholei amola fifi daginisisi ba:su. ");
INSERT INTO beo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ya:igobe da sibi amola goudi afafai. Sibi da mano lasu hou hamonoba, e da ea sibi amo La:iba:ne ea fifi amola bunumai lai gebo amo ba:la masa:ne olelei. Amalalu, ea lai gebo da bagade hamoi, amola e da ea lai gebo fi amo La:iba:ne ea lai gebo fi ilima afafai. ");
INSERT INTO beo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Noga:i dagumui lai gebo da mano lama:ne hamonoba, e da ifa hamoi ilia ba:ma:ne hano ofodo gadenene ligisisu. ");
INSERT INTO beo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Be gasa hame lai gebo da mano lama:ne hamonanoba, e da ifa hame ligisisu. Amalalu, La:iba:ne ea lai gebo da gasa hame ba:i. Be Ya:igobe ea lai gebo huluane da gasa bagade dagumui ba:i. ");
INSERT INTO beo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Amalalu, Ya:igobe da bagade gagui dunu agoane ba:i. E da sibi gilisisu bagohame, udigili hawa: hamosu dunu, ga:mele, lai gebo, sibi, amola dougi bagohame gagui galu. ");
INSERT INTO beo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ya:igobe da La:iba:ne egefelali ilia sia:i amane, “Ya:igobe da ninia ada ea gagui huluane wamolai dagoi. Ea gagui huluane da ninia ada ea musa: gagui liligi,” amo sia: Ya:igobe da nabi. ");
INSERT INTO beo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Musa: La:iba:ne da ema asigisu be wali da hame asigi, amo amola e da ba:i galu. ");
INSERT INTO beo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Amalalu, Hina Gode da ema amane sia:i, “Dia ada amola dia fi dunu ilia sogega buhagima. Na da di sigi masunu.” ");
INSERT INTO beo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Amaiba:le, Ya:igobe da La:isele amola Lia amo ela da gisi odagiaba sogebi amo ganodini ea sibi gilisili dialebe ba:i, amoga e yosia:musa: misa:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","E da elama amane sia:i, “Alia ada da ea musa: hou fisili, wali nama hame asigisa, na da ba:i dagoi. Be na ada ea Gode da na fidimusa: lelu. ");
INSERT INTO beo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Alia dawa:! Na da na gasa huluane amoga dia ada ea hawa: hamosu. ");
INSERT INTO beo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Be e da nama ogogoi. Amola e da na muni logo nabuane afadenei. Be Gode da fidibiba:le, e da na hame wadela:lesi. ");
INSERT INTO beo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","La:iba:ne da, ‘Daginisisi gadofo goudi da dia bidi lamu gala’ amo sia:noba, goudi huluane da daginisisi agoane lalelegei. Amola e da, ‘gadofo fifi hamoi goudi amola da dia bidi lamu gala’ amo sia:noba, goudi huluane da gadofo fifi agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Gode da dia ada gebo fi huluane fadegale, nama i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Eso afaega, eso amoga lai ohe fi da mano lasu hou hamosa, amo esoga na da simasia ba:i agoane, goudi gawali huluane da aseme ilima mano lama:ne hamomusa: doaga:loba, ilia huluane da fifi amola daginisisi amola hoholei agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Simasia ganodini, Gode Ea a:igele dunu da nama amane sia:i, ‘Ya:igobe!’ Na bu adole i, ‘Na wea!’ ");
INSERT INTO beo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Amalalu, E da amane sia:i, ‘Ba:le gadoma! Goudi gawali huluane da mano lasu hou hamosa, huluane da fifi amola daginisisi amola hoholei fawane. Na da La:iba:ne ea hou dima hamonana, amo Na ba:i dagoiba:le, amo hou hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Na da Bedele (amoga di da igi busafugulu modale ligiagamusa:, olife susuligi sogadigili, gasa bagade Nama fa:no bobogema:ne sia:i) amo sogebi Gode esala. Wahadafa dia liligi momagele, amo soge yolesili dia sogedafa amoga buhagima.’” ");
INSERT INTO beo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","La:isele amola Lia da Ya:igobema bu adole i, “Ania ada ema ani nana liligi lamu da hamedei. ");
INSERT INTO beo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ea da ani ga fi agoane ba:sa. E da ani bidi lai dagoi amola wali e da muni huluane ani bidi lama:ne lai, amo huluane e da ha:digi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Muni amola liligi huluane amo Gode da La:iba:nema fadegai, amo huluane da ninia: amola ninia mano ilia:. Di Gode Ea hamoma:ne sia:i defele hamoma.” ");
INSERT INTO beo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Amalalu Ya:igobe da ea liligi huluane momagele, ea ada ea diasu Ga:ina:ne soge ganodini amoga buhagimusa: momagei. E da ea mano huluane amola ea uda ga:mele da:iya fila heda:ma:ne sia:i. Ea sibi amola ea goudi gilisisu, e bisima:ne sefasi. E da liligi huluane e da Mesoubouda:imia sogega lai, amo gaguli asi. ");
INSERT INTO beo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","La:iba:ne da ea sibi hinabo damumusa: asi dagoi ba:i. La:isele da ea ada ea loboga hamoi ogogosu ‘gode’ liligi amo wamolai. ");
INSERT INTO beo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ya:igobe amola da La:iba:nema ogogoi. E da hobea:i be La:iba:ne hame adoi. ");
INSERT INTO beo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Amaiba:le, ea liligi huluane gaguli, e da hobea:i. E da Iufala:idisi Hano degele, Gilia:de goumi soge amoga doaga:musa: asi. ");
INSERT INTO beo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Eso udiana asili, La:iba:ne da Ya:igobe ea hobea:i nabi. ");
INSERT INTO beo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","E da ea fi dunu sigi asili, eso fesuale fa:no bobogele, Gilia:de goumi sogega, Ya:igobema doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Amalalu, La:iba:ne da simasia, Gode da ema amane sia:i, “Dawa:ma! Ya:igobema maedafa baduguma!” ");
INSERT INTO beo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","La:iba:ne da Ya:igobema doaga:loba, Ya:igobe da ea abula diasu Gilia:de goumi soge amo ganodini gagui dialebe ba:i. La:iba:ne amola ea fi dunu da amoga ilia abula diasu gaguli esalu. ");
INSERT INTO beo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Amalalu, La:iba:ne da Ya:igobema amane sia:i, “Di da abuliba:le nama ogogoi, amola na uda mano amo uda da gasawane gegei ganodini suguli lai defele, hiouginana asi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Abuli nama ogogole, mae adole udigili hobea:i. Di da nama adole ba:loba, na da di hahawane asigi gesami hea:su amola sani baidama amola eno liligi dusa asili, di asunasila:loba. ");
INSERT INTO beo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Di udigili hobea:iba:le, na mano amola na aowa asigibio nonogomu da hamedei ba:i. Amo da gagaoui hou di da hamoi. ");
INSERT INTO beo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Na da di wadela:musa: gasa gala. Be aya gasia Gode da nama sisasu. E da di mae badugama:ne, nama sia:i. ");
INSERT INTO beo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Di da dia sogedafa amoga buhagimu hanaiba:le fisili asi, amo na dawa:. Be di da abuliba:le na fi loboga hamoi ‘gode’ liligi wamolabala?” ");
INSERT INTO beo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ya:igobe da bu adole i, “Di da dia uda mano amo bu samogesa:besa:le, na hobea:i. ");
INSERT INTO beo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Be nowa da dia loboga hamoi ‘gode’ liligi wamolai, amo ninia da fane legemu. Wali ninia fi dunu da ba:su dunu esala. Di hogoi helema. Adi liligi da dia liligi ba:sea, defea, bu lama.” La:isele da La:iba:ne ea ‘gode’ liligi wamolai, amo Ya:igobe da hame dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","La:iba:ne da asili, Ya:igobe ea abula diasu ganodini hogoi. Amalalu, e da Lia abula diasuga asi, amola udigili hawa: hamosu uda aduna amo ela diasu. Be ea ‘gode’ liligi hame ba:i. Amalalu, e da La:isele ea diasuga asi. ");
INSERT INTO beo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","La:isele da amo ‘gode’ liligi lale, ga:mele ea baligiga legesu esa amo ganodini salawane, amo da:iya fi galu. La:iba:ne da abula diasu huluane hogoi helele, hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","La:isele da ea adama amane sia:i, “Ada! Nama mae ougima! Na da wa:legadomu gogolei galebe. Na da oubiga sioi fi galebe,” e ogogole amane sia:i. La:iba:ne da hogoi helele, be ea loboga hamoi ‘gode’ hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Amalalu, Ya:igobe da mi hanai galu. E ougili amane sia:i, “Na da adi wadela:i hou hamobela:? Na da adi sema fibiba:le, di da nama benea ahoasu dunu defele nama se bobogebela:? ");
INSERT INTO beo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Di da na liligi ganodini hogoi helebeba:le, dia liligi ba:bela:? Amai galea, gadili ligisili, dia dunu amola na dunu da fofada:lalu, ninia da moloidafa dunu ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Na da wali ode 20 agoane, dia hawa: hamosu. Dia sibi amola dia goudi da mano bagohame lai dagoi. Sibi gawali dia sibi gilisisu amo ganodini esalebe, na da hamedafa mai. ");
INSERT INTO beo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Sibi da gasonasu ohe fi amoga medole legei ba:loba, na da nisu dabe i. Na da na hou dodofemusa: amo medole legei liligi dima hame gaguli misi. Esoga o gasi ganodini, liligi wamolai ba:loba, di da nama fawane dabe lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Eso bagohame na da se nabi. Esoga eso gia:i bagade amola gasi ganodini anegagi. Na da golamu gogolei. ");
INSERT INTO beo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Amo hou da ode 20 agoane na da dia sogega esalu, agoaiwane ba:i. Ode 14 na da dia uda mano aduna bidi lama:ne udigili hawa: hamosu. Ode 6 amoga na da dia lai gebo gilisisu ouligisu. Na da na sibi amola goudi gilisisu lama:ne hawa: hamosu. Di amola da amo ganodini na bidi nabuane agoane afadenei. ");
INSERT INTO beo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Na ada A:ibalaha:me amola Aisage ela Gode da na hame fidi ganiaba, di da na udigili bidi mae lalewane asunasila:loba. Be Gode da na se nabasu amola na hawa: hamosu ba:i dagoi. Aya gasia E da dima gagabole sia:ne, Ea fofada:su hamoi dima olelei dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","La:iba:ne da Ya:igobema bu adole i, “Amo uda da na mano esala. Ilia manolali da na manolali. Lai gebo gilisisu huluane guiguda: goe da na:. Liligi huluane di guiguda: ba:sa, amo da na liligi. Be na da na mano amola ilia mano gagumusa: hamedei ba:sa. ");
INSERT INTO beo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Amaiba:le, na da dima gousa:su hamomu gala. Ninia amo mae gogolema:ne, igi gilisili bi ilegele hamomu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Amaiba:le, Ya:igobe da igi afae lale, wanonesisu hamoma:ne ligisi. ");
INSERT INTO beo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ea sia:beba:le, ea dunu da igi eno gilisili, bi hamoi. Amalalu, amo igi gilisi bi dafulili, ilia da lolo mai. ");
INSERT INTO beo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","La:iba:ne da amo igi bi dio asuli amo Yiga Sa:ihaduda. Ya:igobe da amo igi bi dio eno asuli amo Ga:liede. (Hibulu sia: - Mae Gogolema:ne Bi Gagui). ");
INSERT INTO beo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","La:iba:ne da Ya:igobema amane sia:i, “Amo igi bi da anima mae gogolema:ne ilegei dialumu.” Amaiba:le, amo sogebi ea dio da Ga:liede. ");
INSERT INTO beo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","La:iba:ne da eno amane sia:i, “Ania da afafamuba:le, Gode da ani noga:le ba:mu da defea.” Amaiba:le, amo sogebi dio eno da Misiba. (Ba:su Sogebi). ");
INSERT INTO beo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","La:iba:ne e da amane sia:i, “Di da na uda mano wadela:lesisia o eno uda lasea, ania da afafamuba:le na da hame dawa:mu. Be mae gogolema. Gode da ani ba:lala. ");
INSERT INTO beo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Igi bi na hamoi da goea. Amola amo da mae gogolema:ne igi diala. ");
INSERT INTO beo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Amo igi bi amola igi ilegei da agoane olelesa. Na da di doagala:musa: masea, amo igi bi baligimu da sema bagade. Amola di da nama doagala:musa: ahoasea, amo baligimu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","A:ibalaha:me ea Gode amola Na:iho ea Gode da anima fofada:su dunu esala.” Amalalu Ya:igobe da Gode (Ema ea eda Aisage da nodone sia:ne gadosu) amo Ea Dioba:le, amo sema noga:le dawa:ma:ne, dafawane ilegele sia:i. ");
INSERT INTO beo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","E da ohe afae fane, gobele salasu hou amo goumia hamone, ea fi dunu amo lolo moma:ne sia:i. Ha:i nanu, ilia amo gasia goumi da:iya esalu. ");
INSERT INTO beo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Hahabedafa, La:iba:ne da ea aowa huluane amola ea uda mano ilima asigibio nonogonanu, hi diasuga buhagimusa: fisili asi. ");
INSERT INTO beo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ya:igobe da logoga ahoanoba, a:igele dunu ilia da ema doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Amo ba:beba:le e amane sia:i, “Amo sogebi da Gode Ea Aligibi Sogebi.” Amaiba:le, e da amo sogebi dio asuli amo Ma:ihana:ime. ");
INSERT INTO beo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ya:igobe da sia: adole iasu dunu, ili da e bisimusa:, Iso amo gousa:musa: asunasi. Iso da Idome sogega esalu. ");
INSERT INTO beo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ya:igobe da sia: adole iasu dunu ilima amane olelei, “Isoma amane sia:ma, ‘Na, Ya:igobe, dia nabasu hawa: hamosu dunu da na hina Isoma sia: iaha. Na da La:iba:nema ouesalu, hedolo hame buhagi be wali buhagisa. ");
INSERT INTO beo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Na da bulamagau, dougi, sibi, goudi, amola udigili hawa: hamosu dunu gagui gala. Na da di hahawane ba:ma:ne dima sia: adole iaha.’” ");
INSERT INTO beo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Sia: adole iasu dunu da Ya:igobema bu misini, amane sia:i, “Ninia da dia ola Iso ema doaga:i. E da wali dima doaga:musa:, logoga ahoanebe. E da dunu 400 agoane oule maha.” ");
INSERT INTO beo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ya:igobe da beda:i bagade amola da:i dioi. Ema misi dunu, sibi, goudi, bulamagau, amola ga:mele, e da afafane gilisisu aduna hamoi. ");
INSERT INTO beo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","E amane dawa:i, “Iso da na bisili gilisisu amoga doagala:ma:ne masea, - amabela:? - na eno gilisisu da se mae nabawane hobeama:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Amalalu Ya:igobe da amane sia:ne gadoi, “Na aowa A:ibalaha:me amola na ada Aisage, amo elea Gode! Na sia: nabima! Hina Gode, Di da nama na soge amola na fi dunu amoga buhagima:ne sia:noba, Di da na noga:le fidima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Na hou da wadela:i, be Di da nama asigi hou noga:idafa olelei. Na da dagulu fawane gaguli, Yodane hano degei, be wali na da buhagili, amo gilisisu aduna gaguiwane bu maha. ");
INSERT INTO beo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Gode! Dia na gaga:ma! Na da na ola Isoba:le bagade beda:i galebe. E da ninima doagala:sa:besa:le amola nini huluane amola uda amola mano wadela:sa:besa:le na da bagade beda:i. ");
INSERT INTO beo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Di da musa: na logo hahamoma:ne sia:i. Amola nama mano idimu hamedei amo sa:i hano wayabo bagade bega: amo idi defele amo imunu sia:i. Amo mae gogolema.” ");
INSERT INTO beo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Amo gasi afae amo sogebi esalu, Ya:igobe da ea lai gebo fi mogili, hahawane udigili iasu Isoma imunusa: dawa:i. E da goudi aseme 200, goudi gawali 20, sibi aseme 200, sibi gawali 20, ga:mele aseme dodo maga:me gala 30, amola ilia mano, bulamagau aseme 40, bulamagau gawali 10, dougi aseme 20 amola gawali 10, amo huluane Isoma imunusa: afafai. ");
INSERT INTO beo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","E da gilisisu afae afae hamone, amo afae afaega hawa: hamosu dunu afae ouligima:ne sia:i. E da amane sia:i, “Nama bisili masa. Gilisisu afae asili, dibi yolesima. Amalalu, gilisisu eno amola eno agoaiwane masa. ");
INSERT INTO beo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","E da bisili ahoasu hawa: hamosu dunu ilima amane sia:i, “Na ola Iso da dima doaga:sea, e da dima, ‘Dia hina da nowala:? Di da habi ahoa? Lai gebo fi di da amoga fa:no bobogesa. Amo da nowa eala:?’ amane adole ba:sea, ");
INSERT INTO beo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","di agoane adole ima, ‘Amo huluane da dia hawa: hamosu dunu Ya:igobe amo ea:. Amo huluane e da ea hina Isoma iaha. Ya:igobe hisu da fa:no maha.’” ");
INSERT INTO beo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ya:igobe da amo sia: defele gilisisu ouligisu dunu ageyadu amola gilisisu ouligisu dunu osoda amola gilisisu ouligisu huluane ilima amo defele olelei. E amane sia:i, “Dilia Isoma amane sia:ma, ");
INSERT INTO beo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Defea! Dia hawa: hamosu dunu Ya:igobe da ninima gadenene fa:no maha.’” Ya:igobe da agoane dawa:lalu, “Amabela:? Na da hahawane udigili iasu ema iasea, e da olofosu ba:ma:bela:? Amasea, e da na gogolema:ne olofoma:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","E da amo hahawane udigili iasu bisili asunasi. Amalalu e da amo sogebi abula diasuga esalu. ");
INSERT INTO beo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Amo gasia, Ya:igobe da wa:legadole, ea uda aduna, ea gidisedagi uda aduna, ea dunu mano gidayale gala, amo huluane Ya:boge Hano degemusa: oule asi. ");
INSERT INTO beo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","E da amo huluane asunasili, ea liligi huluane asunasi. ");
INSERT INTO beo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Be hisu da hame asi. Amalalu, dunu afae da ema misini ema ouga:ne ludui. Ludulalu, gasia huluane mae yolesili, ludui. ");
INSERT INTO beo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ya:igobe da gasa bagadewane ludubiba:le, amo dunu da ema osa:le heda:mu hamedeiwane ba:i. Amaiba:le, e da Ya:igobe ea masele digili ba:beba:le, Ya:igobe ea masele momoge dagai dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Amalalu, amo dunu da Ya:igobema amane sia:i, “Nama yolesima! Eso da heda:i dagoi.” Be Ya:igobe da bu adole i, “Di da nama hahawane dogolegele fidimusa: sia:beba:le fawane, na da yolesimu.” ");
INSERT INTO beo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Dunu da Ya:igobema amane adole ba:i, “Dia dio da nowala:?” E bu adole i, “Ya:igobe!” ");
INSERT INTO beo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Amalalu amo dunu da amane sia:i, “Defea! Dia dio da wali Ya:igobe hame. Dia dio da wali Isala:ili. Bai di da Godema amola osobo bagade dunuma ouga:ne ludulalu, hasali dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ya:igobe da amane sia:i, “Dia dio nama adoma!” Be E bu adole i, “Dia da abuliba:le Na dio adole ba:sala:?” Amalalu, e da amogai Ya:igobema hahawane dogolegele lama:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Amaiba:le, Ya:igobe da amo sogebiga Biniele dio asuli. E amane sia:i, “Bai na da Gode Ea odagi ba:i dagoi, be na hame bogoi.” ");
INSERT INTO beo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","E da Biniele baligili, eso da heda:i dagoi ba:i. Ea masele momoge dagaiba:le, e da gasuga:igili ahoanu. ");
INSERT INTO beo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Amaiba:le, musa: amola wali Isala:ili dunu da masele momoge huluane hame naha. Bai Biniele sogega musa: Gode da Ya:igobe (Isala:ili) amo ea masele momoge dagai. (Isala:ili dawa:loma:ne da ‘E da Godema ludusa.”) ");
INSERT INTO beo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ya:igobe da Iso amola dunu 400 agoane logoga ahoanebe ba:i. Amaiba:le, e da ea mano huluane afafane, Lia, La:isele amola ea gidisedagi uda aduna, amo ouligima:ne ilima i. ");
INSERT INTO beo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","E da gidisedagi uda amola ela mano bisimusa: asunasili, Lia amola ea mano fa:no, amola fa:nodafa La:isele amola Yousefe amola asunasi. ");
INSERT INTO beo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ya:igobe da bisili, ea ola gadenene doaga:loba, fesuale agoane osoboga begudui. ");
INSERT INTO beo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Be Iso da hehenane, Ya:igobe ouga:ne nonogoi. Ela da bagadewane dinanu. ");
INSERT INTO beo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Iso da ba:le ga:le, uda amola mano ba:beba:le, amane sia:i, “Amo dima sigi maha da nowala:?” Ya:igobe da bu adole i “Ada! Amo da mano, Gode da nama hahawaneba:le nama i.” ");
INSERT INTO beo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Amalalu, gidisedagi uda aduna amola ela mano da misini begudui. ");
INSERT INTO beo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Amalalu Lia amola ea mano misini amola fa:no Yousefe amola La:isele da misini, huluane da begudui. ");
INSERT INTO beo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iso da amane adole ba:i, “Be amo gilisisu eno da nama misi. Amo da adila:?” Ya:igobe da bu adole i, “Amo da di hahawane ba:ma:ne, na da asunasi.” ");
INSERT INTO beo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Be Iso da amane sia:i, “Be na da defele gagui gala. Dia liligi di fawane gaguma!” ");
INSERT INTO beo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Be Ya:igobe da amane sia:i, “Di da na hou hahawane ba:sea, na udigili hahawane iasu lalegaguma. Amo na da dima ha:giwane edegesa. Bai di da na hahawane ba:beba:le, dia odagi da nama Gode Ea odagi agoane ba:sa. ");
INSERT INTO beo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Gode da nama asigiba:le, nama bagade i dagoi. Na da sadiba:le, amo hahawane udigili iasu di lalegaguma.” Ya:igobe da ha:giwane sia:beba:le, Iso da ea iasu lai. ");
INSERT INTO beo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Amalalu, Iso da amane sia:i, “Defea! Hadiga! Ani liligi momagele, ahoa:di! Na da dili bisili masunu.” ");
INSERT INTO beo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Be Ya:igobe da bu adole i, “Di dawa:! Mano ilia da gasa hame galebe amola sibi, eno lai gebo fi amola ilia mano na da dawa:lala. Eso afaiwane ninia amo gasawane sefasisia, ilia huluane bogogia:mu. ");
INSERT INTO beo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Di bisili masa. Na da gebewane fa:no bobogemu. Na da ilia gasa defele, lai gebo fi amola mano oule asili, Idome diasuga dima bu gilisimu.” ");
INSERT INTO beo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iso da bu sia:i, “Amasea na da na dunu mogili di ouligima:ne yolesimu.” Be Ya:igobe da bu adole i, “Mae dawa:ma! Na hanai da di da nama asigisa amo fawane hanai!” ");
INSERT INTO beo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Amalalu, amo esoga, Iso da Idome sogega doaga:musa: asi. ");
INSERT INTO beo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Be Ya:igobe da Sagode sogega asili, diasu gagui. Amola ea lai gebo golama:ne, diasu eno gaguli gagai. Amaiba:le, ilia amo diasuga Sagode dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ya:igobe da Mesoubouda:imia sogega buhagiloba, e da hahawane Siegeme moilai bai bagade (Ga:ina:ne soge amo ganodini) amoga doaga:loba, e da sogebi Siegeme moilai bai bagade gadenene amoga ea abula diasu gilisisu gagui galu. ");
INSERT INTO beo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","E da amo ifabi sogebi bidi lama:ne, Ha:imo (Siegeme eda) amo egaga fi ilima silifa muni fage 100 amoga bidi lai. ");
INSERT INTO beo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Amoga e da oloda hamoi. Amo oloda e da dio asuli amo Ele Elouhe (Isala:ili fi ilia Gode Ea Dio). ");
INSERT INTO beo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Eso afaega, Daina (Ya:igobe amola Lia ela mano) da Ga:ina:ne uda amo ba:musa: sofe asi. ");
INSERT INTO beo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Siegeme (Haifaide dunu ea dio Ha:imo, amo ea mano) da amo sogega ouligisu dunu esalu. E da Daina ba:beba:le, gasawane doaga:le wadela:lesi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Be e da Daina hahawane bagade magesa:i ba:i. E da ema bagade magesa:i, amola Daina da ema bu asigimu e da hanai galu. ");
INSERT INTO beo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","E da ea ada Ha:imo ema amane sia:i, “Na da agoane hanai. Amo a:fini na da dafawane lamu hanai gala. Amo logo di hahamoma.” ");
INSERT INTO beo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ya:igobe da idiwi gogosia:ma:ne wadela:lesi dagoi, amo nabi dagoi. Be egefelali da sogega sibi ouligisa esalebeba:le, e da ili bu misunu ouesalu. ");
INSERT INTO beo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Siegeme eda Ha:imo da Ya:igobema sia: sa:imusa: misi. ");
INSERT INTO beo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Sia:nanoba, Ya:igobe egefelali da misini doaga:i. Siegeme da wadela:i hou amoga ilima gogosiasu i, amola Ya:igobe ea uda mano wadela:lesi, amo nababeba:le, ilia da mi hanai galu. ");
INSERT INTO beo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ha:imo da Ya:igobema amane sia:i, “Na mano Siegeme da didiwima bagade magesa:i. E amo lama:ne, logo hamoma. ");
INSERT INTO beo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ninia gousa:su hamomu da defea. Amoga ninia fi amola dia fi hahawane uda lasu hou hamomu da defea. ");
INSERT INTO beo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Amasea, dilia da ninia soge ganodini esalumu da defea. Dilia da dili hanaiga fima, bidi lama, amola soge lama.” ");
INSERT INTO beo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Amalalu, Siegeme da Daina eda amola yolalali ilima amane sia:i, “Dilia da nama amo hahawane hamosea, na da dilima liligi dilia hanaiga imunu. ");
INSERT INTO beo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Dilia lamu hanai, amo nama adoma. Bidi bagade dilia hanaiga defei ilegema. Na da amo a:fini lama:ne dilia da sia:sea, na da dilima dili hanai defele imunu.” ");
INSERT INTO beo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Siegeme da ilia dalusi Daina amo wadela:lesiba:le, Ya:igobe egefe ilia da Siegeme amola ea ada Ha:imo elama hohonomusa: dawa:le, amane bu adole i. ");
INSERT INTO beo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ilia da ema amane sia:i, “Ninia dalusi amo gadofo hame damui dunu amoga lamu da hamedei. Amo da ninima gogosiasu liligi. ");
INSERT INTO beo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Be dia fi dunu huluane da ilia gadofo damusia, amo hamobeba:le fawane ninia dalusi lamu defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Amasea, ninia fi amola dia fi uda lasu hou hamomu. Ninia dilia gilisisu amo ganodini fimu, amalalu ninia amola dilia da fi afadafa hamomu. ");
INSERT INTO beo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Be dili amo higasea, amola gadofo damusu hame lalegagusia, defea, ninia da ninia dalusi lale, fisili masunu.” ");
INSERT INTO beo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amo hou Ha:imo amola egefe Siegeme da hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Amo ayeligi da Ya:igobe idiwi ema bagade asigiba:le hedolowane amo hou hamomusa: dawa:i galu. Siegeme da ea fi amo ganodini bisili mimogo dunu esalu. ");
INSERT INTO beo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ha:imo amola ea mano Siegeme da diasu holei fofada:su gilisisu sogebi asili, ilia fi dunuma amane sia:i, ");
INSERT INTO beo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Amo dunu ilia da ninima asigisa. Ilia da nini soge ganodini udigili esalumu da defea. Ninia soge da bagade amola ili amola nini gilisili esalumu defele ba:sa. Ninia ilia uda mano lamu, amola ilia da ninia uda mano lamu da defea. ");
INSERT INTO beo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Be ilia da gadofo damuiba:le, ninia dunu huluane da gadofo damusia fawane ilia da ninima gilisimu. ");
INSERT INTO beo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ilia da ninima gilisisia, ilia lai gebo fi amola ilia liligi huluane da ninia liligi dialumu. Amaiba:le, ilia da ninima gilisimusa:, ninia sia:mu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Moilai bai bagade dunu huluane da Ha:imo amola Siegeme ela sia: da defea dawa:i. Amalalu, dunu huluane ilia gadofo damui dagoi. ");
INSERT INTO beo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Eso udiana aligili, Siegeme dunu huluane da gadofo damuiba:le se nabaloba, Ya:igobe egefe aduna amo Simione amola Lifai (Daina yolala), ela da gegesu gobihei bagade gaguli, wamowane moilai ganodini asili, Siegeme dunu huluane fane legei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ela da Ha:imo amola Siegeme fane legei. Amalalu, ela da Daina amo Siegeme ea diasuga fadegale, hiouginana asi. ");
INSERT INTO beo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Dunu huluane fane legelalu, Ya:igobe egefelali eno da ilia dalusi wadela:lesi dabe lama:ne, moilai liligi huluane sasamogene lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ilia da sibi amola goudi, bulamagau, dougi, liligi amo soge amola diasu ganodini dialu, amo huluane sasamogene lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ilia da noga:i liligi huluane, uda amola mano huluane gagulaligili asi. ");
INSERT INTO beo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ya:igobe da Simione amola Lifai elama amane sia:i, “Alia houba:le, na da se nabi dagoi. Wali Ga:ina:ne dunu, Belesaide dunu amola dunu huluane amo soge ganodini esala da nama bagade higamu. Na dunu da bagahame gala. Ilia da huluane gilisili nama doagala:sea, na fi huluane da wadela:lesi dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Be ilia da bu adole i, “Ilia da ninia dalusi udigili wadela:i aheda:i uda defele hamomu da ninima hamedei.” ");
INSERT INTO beo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Gode da Ya:igobema amane sia:i, “Di da Bedele sogega hedolo asili, esaloma. Amoga Nama oloda hamoma. Na da Gode amo di da Isoba:le hobealoba, Na da dima misi.” ");
INSERT INTO beo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Amaiba:le, Ya:igobe da ea sosogo fi amola dunu huluane ema gilisi, ilima amane sia:i, “Ga loboga hamoi ‘gode’ liligi dilia gagui amo huluane fadegale fasima. Dilia nigima: dodofelalu, abula gaheabolo salima. ");
INSERT INTO beo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ninia da amo soge yolesili, Bedele moilaiga masunu. Amoga na da Gode amo da na se nabasu ganodini fidi, amola na lalebe soge huluane E da gilisili lala, amoga na da oloda hamomu. ");
INSERT INTO beo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Amaiba:le, ilia da loboga hamoi ‘gode’ liligi amola gegagulu ilia ge ganodini sali, amo huluane duga:le, Ya:igobema i. Ya:igobe da amo liligi huluane ‘ouge’ ifa Siegeme soge ganodini amo haguduga uli dogone sali. ");
INSERT INTO beo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Amalalu, ilia da logoga asili, moilai dunu huluane gadenene esalu da beda:i bagade ba:i. Ilia da beda:iba:le, Ya:igobe ea fi hame se bobogei. ");
INSERT INTO beo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ya:igobe amola ea fi huluane da Luse (wali ea dio da Bedele), Ga:ina:ne soge ganodini amoga doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Amoga e da oloda hamone amola amo soge dio eno asuli amo Ele Bedele. Bai amoga e da ea olaba:le hobeale ahoanoba, Gode da ema misi. ");
INSERT INTO beo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Lebega ea hawa: hamosu uda amo Debola da amoga bogoi. Ea da:i hodo ilia da ‘ouge’ ifa Bedele sogebi amoga ga (south) dialu, amo hagudu uli dogone sali. Amaiba:le, amo ifaga ilia da ‘Disu Ouge Ifa’ dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ya:igobe da Mesoubouda:imia yolesili, bu Ga:ina:ne sogega bu misini, Gode da ema bu misini, ema hahawane dogolegele fidima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Gode da ema amane sia:i, “Dia dio da Ya:igobe, be amo fa:no dia dio da Isala:ili.” Amaiba:le, Gode da ema Isala:ili dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Amola Gode da ema amane sia:i, “Na da Gode Bagadedafa! Di mano bagohame lalelegema! Digaga fi da fifi asi gala bagohame ba:mu, amola di da hina bagade dunu ilima aowa ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Soge Na da A:ibalaha:me amola Aisage elama i dagoi, amo na da dima imunu. Amola fa:no digaga fibi ilima imunu.” ");
INSERT INTO beo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Amalalu, Gode da yolesili asi. ");
INSERT INTO beo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Amogawi, Gode da amo sogebiga ema sia:musa: misiba:le, Ya:igobe da wanonesisu gele bugili, amo Godema modale ligiagama:ne, amo da:iya waini amola olife susuligi sogadigi. ");
INSERT INTO beo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","E da amo sogebiga dio asuli, amo Bedele. ");
INSERT INTO beo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ya:igobe amola ea sosogo fi da Bedele yolesili, logoga ahoanoba, Efala:de amoga mae doaga:le, La:isele da mano lamusa: se nabi. E da mano lalelegemu logebeba:le, gasa bagade ba:i. ");
INSERT INTO beo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mano lamusa: se bagade nabaloba, mano lasu fidisu uda da ema amane sia:i, “La:isele! Mae beda:ma! Dunu mano da lalelegei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Be La:isele da bogolalu, amola mifo laha da gadenene dagoloba, ea manoma dio asuli amo Benoni. Be Ya:igobe da ema Bediamini dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","La:isele da bogoi. Ilia da ea da:i hodo Efala:de moilai logo ahoasu dafulili uli dogoi. Amo moilai ea dio wali da Bedeleheme. ");
INSERT INTO beo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ya:igobe da dawa:ma:ne gele wanonesisu amoga bugi, amola wali amo da La:isele ea uli dogoi amoga dawa:ma:ne diala. ");
INSERT INTO beo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ya:igobe da asili, diasu gagagula heda:i, ea dio Ede amo baligili, ea abula diasu gagui. ");
INSERT INTO beo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ya:igobe da amo soge ganodini esaloba, ea mano Liubene da misini, Ya:igobe ea gidesedagi uda amo Biliha ema gilisili golai. Ya:igobe da amo hou nababeba:le, mi hanai galu. Ya:igobe ea dunu mano da fagoyale galu. ");
INSERT INTO beo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lia ea dunu manolali da Liubene (Ya:igobe ea magobo mano) Simione, Lifai, Yuda, Isiga amola Sebiulane. ");
INSERT INTO beo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","La:isele ea dunu manola da Yousefe amola Bediamini. ");
INSERT INTO beo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","La:isele ea hawa: hamosu uda Biliha amo ea dunu manola da Da:ne amola Na:badalai. ");
INSERT INTO beo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lia ea hawa: hamosu uda Siliba amo ea dunu manola da Ga:de amola A:sie. Amo dunu mano ilia da Mesoubouda:imia sogega lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Aisage da Ma:melei amo Hibalone moilaiga gadenene esalu. Amoga Ya:igobe da asi. ");
INSERT INTO beo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisage da lalelegele, ode 180 esalu. ");
INSERT INTO beo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","E da amo ode bagohame lai dagoloba, bogoi. Ea mano Iso amola Ya:igobe da ea da:i hodo uli dogone sali. ");
INSERT INTO beo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso (eno dio da Idome) ea mano fi da hagudu dedei. ");
INSERT INTO beo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso da Ga:ina:ne uda lai. Amo da A:ida (Hidaide dunu Ilone idiwi) amola Ouholibama (A:ina Haifaide dunu Sibeone ea mano amo idiwi), ");
INSERT INTO beo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","amola Isiama:ile idiwi Basemade (Neba:iode eya). ");
INSERT INTO beo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","A:ida da Elifa:se lalelegei. Basemade da Leuele lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ouholibama da Yeuse, Yalame amola Gola lalelegei. Amo Iso ea mano huluane da Ga:ina:ne soge ganodini lalelegei. ");
INSERT INTO beo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Amalalu, Iso da ea uda, egefe, idiwi, ea fi huluane, ea lai gebo, amola ea liligi huluane e da Ga:ina:ne sogega lai, amo huluane lale, ea eya Ya:igobe amo yolesili asili, soge enoga asi. ");
INSERT INTO beo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bai soge amoga e amola Ya:igobe amoga esalu da fonobahadi ba:i. Lai gebo fi da bagade heda:iba:le, ela gilisili esalumu da hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Amaiba:le, Iso da Idome goumi sogega esalu. ");
INSERT INTO beo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso amo Idome dunu ilia eda, amo ea mano da agoane. ");
INSERT INTO beo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Iso idua A:ida da ema dunu mano afae lai amo Elifa:se. Elifa:se da dunu manolali lalelegei amo Dimane, Ouma, Sifou, Ga:idame, amola Giha:se. Uda eno amo Dimina da ema eno mano lai amo A:malege. Iso idua Basemade da ema dunu mano lalelegei amo Leuele. Leuele da dunu mano biyaduyale lai amo Na:ihade, Sila, Siama amola Misa. ");
INSERT INTO beo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso idua Ouholibama da dunu mano udiana lalelegei amo Yeuse, Yalame amola Gola. ");
INSERT INTO beo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iso ea dunu fifi misi da agoane. Iso ea magobo mano Elifa:se da amo hagudu dedei fi ilima eda esalu amo Dimane, Ouma, Sifou amola Gina:se, ");
INSERT INTO beo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Gola, Gadame amola A:malege. Amo huluane da Iso idua A:ida ea mano. ");
INSERT INTO beo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso ea mano Leuele amo ema mabe fi da Na:ihade, Sila, Siama amola Misa. Amo huluane da Iso idua Ba:sema:de ea mano. ");
INSERT INTO beo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso ea fi amo e da idua Ouholibama (A:ina idiwi) amoga lai da Yeuese, Yalame amola Gola. ");
INSERT INTO beo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Amo fi huluane da Iso egaga fi dunu. ");
INSERT INTO beo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Musa: fi Idome soge ganodini da afafane fifi misi hamoi. Ilia eda da Sie (Holaide dunu). Amo ea mano fifi misi da Louda:ine, Sahouba:le, Sibiane, A:ina, Disione, Ise amola Disia:ne. ");
INSERT INTO beo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Louda:ine ea mano fi da Houlai amola Hima:ne. (Louda:ine ea dalusi da Dimina) ");
INSERT INTO beo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Siouba:le ea mano fifi misi da A:lafa:ne, Ma:naha:de, Iba:le, Sifou amola Ouna:me. ");
INSERT INTO beo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibione da mano aduna lai amo A:iya amola A:ina. (A:ina da wadela:i hafoga:i soge ganodini ea eda ea dougi ouligilaloba, gia:i hano uli dogoi gilisi ba:i.) ");
INSERT INTO beo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","A:ina ea mano da Disione amola Disione ea mano fifi misi da Hemeda:ne, Eseba:ne, Idela:ne amola Gila:ne. A:ina ea uda mano da Ouholibama. ");
INSERT INTO beo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ise ea mano fifi misi da Bilihane, Sa:iafa:ne, amola A:iga:ne. ");
INSERT INTO beo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disia:ne ea mano fi da Ase amola A:ila:ne. ");
INSERT INTO beo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Houlaide fi Idome soge ganodini esalu da Louda:ine, Sahouba:le, Sibiane, A:ina, Disione, Ise amola Disia:ne. ");
INSERT INTO beo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Isala:ili soge da hina bagade hame galu. Amo esoga, Idome soge ganodini, hagudu dedei dunu da hina bagade esalu. hina bagade dio Ilia Soge 1 Bila (Bio ea mano) Dinihaba 2 Youbabe (Sila ea mano) Bosala 3 Husia:me Dima:ne 4 Ha:ida:de (Bidade ea mano. E da Moua:be soge ganodini Midianaide dunu fi fanelegei.) Ea soge da...A:ifide 5 Sa:mila Ma:saliga 6 Siole Lihoubode (Hano Bega Gala) 7 Bale Ha:ina:ne (A:gabo ea mano) 8 Ha:idade (ea uda da Mehedabele amo Ma:idalede ea mano amola Mesa:iha:be ea aowa) Ea soge da...Ba:ie ");
INSERT INTO beo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Iso egaga fi da Idome fi hagudu dedei. Ilia dio da Dimina, A:lifa, Yidede, Ouholibama, Ila, Bainone, Gina:se, Dima:ne, Mibisa, Magadiele amola Ila:mea. Amo fi huluane da ilia esalebe soge amoga ilia fi dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ya:igobe da soge amo ea eda da musa: amo ganodini esalu (Ga:ina:ne), amogawi esalu. ");
INSERT INTO beo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ya:igobe ea sosogo fi ilia hou dedei da agoane. Yousefe da lalelegele, ode 17 esalu, ayeligi ba:i. E amola yolalali (ilia da Ya:igobe ea gidisedagi uda Biliha amola Siliba elea mano), amo da gilisili Ya:igobe ea sibi amola goudi ouligisu. E da ea olalali ilia wadela:i hou ba:beba:le, ea edama sia:ne iasu olelei. ");
INSERT INTO beo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yousefe da Ya:igobe ea da:i hamoi esoga lalelegeiba:le, Ya:igobe ea asigi hou ema da ea asigi hou amo Yousefe yolalali ilima baligisu. E abula ida:iwane hamone, Yousefema i. ");
INSERT INTO beo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yousefe ea yolalali da Ya:igobe ea asigi hou Yousefema da ea asigi ilima baligi amo ba:beba:le, mudasu hamoi. Ilia da Yousefema bagade higasu. Ilia da ema asigiwane sia:mu hamedeiwane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Eso afaega, Yousefe da simasia ba:i. Amo e da ea yolalalima olelebeba:le, ilia da bu baligili ema mi hanai galu. ");
INSERT INTO beo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","E da ilima amane sia:i, “Nabima! Na da agoane simasia ba:i. ");
INSERT INTO beo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ninia huluane da widi sagai amo ganodini widi la:gi dudalebe ba:i. Amalalu, na widi la:gi da wa:legadole moloiwane lelu. Amalalu, dilia widi la:gi da na widi la:gi amoga sisiga:le, begudui.” ");
INSERT INTO beo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ea yolalali da ema amane adole ba:i, “Di da ninima hina bagade esalumu dawa:bela:?” Amaiba:le, e da simasia ba:beba:le amola amoga sia:beba:le, ilia da ema baligili mi hanai galu. ");
INSERT INTO beo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Amalalu, Yousefe da eno simasia ba:i. E da ea yolalali ilima amane sia:i, “Na da eno simasia ba:i. Amo ganodini, na da eso, oubi amola gasumuni gidayale gala, huluane nama begudulalebe ba:i.” ");
INSERT INTO beo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Amo simasia ba:i e da ea adama olelei. Ea eda da ema gagabole sia:i, “Amo da adi simasia ba:sula:? Dia ame, dia yolalali amola na da dima misini, beguduma:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yousefe ea yolalali da ema mudale dawa:i, be ea ada da amo liligi huluane ea asigi dawa:su ganodini dawa:lalu. ");
INSERT INTO beo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Eso afaega, Yousefe yolalali da Siegeme sogega ilia eda ea lai gebo fi amo ouligimusa: asi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ya:igobe da Yousefema amane sia:i, “Dia yolalali ilia da Siegeme sogega lai gebo gilisisu ouligilala. Di amoga masa!” Yousefe da amane bu adole i, “Na masunu!” ");
INSERT INTO beo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ea ada da ema amane sia:i, “Defea! Masa! Dia yolalali da hahawane esalabala? Sibi gilisisu da hahawanela:? Amo huluane abodemusa: masa. Amasea, amo sia:ne iasu bu nama iamisa.” Ea eda da Hibalone Fago esalu. E da Yousefe asunasiba:le, Yousefe da asili, Siegeme sogega doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","E da amo sogega udigili laloba, dunu afae da e ba:loba amane sia:i, “Di da adi hogosala:?” ");
INSERT INTO beo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yousefe da bu adole i, “Na da nolalali amo ilia lai gebo gilisisu ouligilala, amo hogosa. Di da ili ba:bela:? ");
INSERT INTO beo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Amo dunu bu adole i, “Ilia da fisili asi dagoi. Ilia sia: na da nabi, amo ilia da Douda:ne sogega masusa: dawa:i galu.” Amaiba:le, Yousefe da ea yolalali ilima fa:no bobogele, Douda:ne sogega ilima doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ilia da Yousefe sedagaga manebe ba:beba:le, e fane legemusa: gilisili sia: dasu. ");
INSERT INTO beo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ilia gilisili sia: dasu, amane, “Amo simasia ba:su dunu da manebe goea! ");
INSERT INTO beo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Defea! Ninia da medole legele amola ea da:i hodo amo hafoga:i hano uli dogoi amo ganodini ha:digimu. Ninia da gasonasu ohe fi da e medole legei sia:mu. Amasea, ea simasia ba:i liligi da hamedei liligi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Liubene da amo sia: nababeba:le, Yousefe gaga:musa: dawa:i galu. E amane sia:i, “Ninia da e hame fane legemu. ");
INSERT INTO beo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Be udigili amo hafoga:i uli dogoi amo ganodini sanasimu. Be ema se mae ima.” E da Yousefe gaga:le, ea edama bu oule masusa: ilegei galu. ");
INSERT INTO beo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yousefe da ea yolalali ilima doaga:loba, ilia da ea nina: hamoi abula sedade amo fadegai. ");
INSERT INTO beo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Amalalu, ilia da Yousefe amo hafoga:i uli dogoi amo ganodini sanasi. ");
INSERT INTO beo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ilia da ha:i nanoba, Isiama:ile (Midia:ne) fi dunu amo Gilia:de soge fisili Idibidi amoga doaga:musa: logoga ahoanebe ba:i. Ilia ga:mele da hedama:ne fodole nasu amola gamali agui ahoanebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda da ea eya ilima amane sia:i, “Ninia eya amo medole legele amola amo hou dedebomu da ninima fidisu liligi hame. ");
INSERT INTO beo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ninia da Yousefe amo Isiama:ile dunu ilima bidi lamu da defea. Amane hamosea, ninia da ema se hame imunu. E da ninia eya ninia hu amola maga:me afae hamoi.” Amane dawa:lalu, ea eya ilia da gilisili defea dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Amalalu, Midia:ne bidi lasu dunu da doaga:loba, Yousefe yolalali da Yousefe amo uli dogoiga fadegale, silifa 20 amoga Yousefe Isiama:ile dunu ilima bidi lai. Amalalu, Isiama:ile dunu da Yousefe Idibidi sogega afugili asi. ");
INSERT INTO beo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Liubene da uli dogoiga bu misini, Yousefe da amo ganodini hame esalu ba:beba:le, bagadewane da:i dione, ea abula gadelai. ");
INSERT INTO beo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","E da yolalali ilima bu misini amane sia:i, “Goi da uli dogoiga hame. Na da adi hamoma:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Amalalu, ilia da goudi medole legele, Yousefe ea abula goudi ea maga:me amo ganodini gela sa:i. ");
INSERT INTO beo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ilia da amo abula ilia adama gaguli asili, amane sia:i, “Ninia da amo ba:i dagoi. Amo da dia gofe ea abulala:?” ");
INSERT INTO beo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ya:igobe da amo abula dawa:i galu. E amane sia:i, “Amo da Yousefe ea:. Gasonasu ohe fi da nagofe Yousefe medole legele ea da:i dadegale fasi dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ya:igobe da se bagade nababeba:le, ea abula gadelale, eboboi abula ea da:i amoga sali. E da ea manoma asigiba:le, eso bagohame digini lalalusu. ");
INSERT INTO beo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Egefelali amola idiwi huluane da ema ea dogo denesima:ne doaga:i, be e da dogo denesimu amola olofomu hamedei ba:i. E amane sia:i, “Na da mae yolesili, da:i dione amola dinana bogomu.” Amaiba:le, ea da:i dioi e da mae yolesili da:i diolalu. ");
INSERT INTO beo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Be Idibidi sogega, Midia:ne dunu da Yousefe amo Bodifa (hina bagade dunu ea sosodo aligisu dunu ilima hina dunu) ema bidi lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Amalu, Yuda da yolalali amo yolesili, ea na:iyado Hila (Adala:me moilai dunu) amo ea moilaiga esalumusa: asi. ");
INSERT INTO beo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Amoga e da Ga:ina:ne a:fini, (Siua ea mano) amo gousa:i. Amo a:fini e da lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","E da ema dunu mano lai amo ea dio E. ");
INSERT INTO beo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yuda idua da bu abula agui ba:i. E da eno dunu mano lai. E da ema dio asuli amo Ouna:ne. ");
INSERT INTO beo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Amalalu, e da dunu mano eno lai amo Sila. Amo mano da lalelegeloba, Yuda da A:gasibi moilaiga esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ea magobo mano E, amo ea lama:ne, Yuda da a:fini ea dio amo Da:ima ilegei. ");
INSERT INTO beo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Be E (Yuda ea mano) da wadela:i hamosu dunu. Hina Gode da ea hou hahawane hame ba:i. Amaiba:le, Gode da E fane legei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Amalalu, Yuda da E ea eya Ouna:ne ema amane sia:i, “Di amola dia ola didalo amo gilisili golama. Dia ola da mano buga:i ba:ma:ne, houdafa ema hamoma.” ");
INSERT INTO beo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Be Ouna:ne da amo mano lalelegemu da ea mano hame ba:mu amo dawa:i galu. Amaiba:le, e da ea ola didalo amoga gilisisia, e da ea ami udigili osoboga sogadigi. Ea ola mano buga:i da hame lalelegema:ne, agoane hamoi. ");
INSERT INTO beo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Hina Gode da amo hou hahawane hame ba:i. Amaiba:le, Gode da Ouna:ne amola fane legei. ");
INSERT INTO beo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Amalalu, Yuda da ea awa Da:ima ema amane sia:i, “Di da dia ada amo ea diasuga buhagima. Nagofe Sila amo da asigilama:ne, ouesaloma.” E da Sila amola ea ola defele Godema fane legemu amo beda:iba:le amane sia:i. Amalu, Da:ima da ea diasuga buhagi. ");
INSERT INTO beo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Fa:no agoane, Yuda ea uda da bogoi. E da didigia:lalu, Yuda amola ea na:iyado Hila (Adala:me dunu) da Dimina sogega asi. Amoga Yuda ea sibi da hinabo damunanebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Dunu eno da Da:imama ea awa Yuda amo da Dimina ea sibi hinabo damumusa: ahoanebe olelei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Amaiba:le, Da:ima da ea didalo abula afadenene, ea odagi amo abula sawa: figisu amoga dedebole, Ina:ime moilai logo holeiga fi esalu. Ina:ime da Dimina ahoasu logoga dialu. Yuda ea ufi mano Sila, da asigilai dagoi, be e da Da:ima hame lai, amo Da:ima da dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda da Da:ima ba:beba:le, ea odagi da dedeboiba:le, e da aie heda:i uda amo dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yuda da logo bega: ema asili, amane adole ba:i, “Defea! Di bidi lamu defei da adila:?” (Amo da ea awa e da hame dawa:i galu.) Da:ima da ema amane adole ba:i, “Di da nama adi ima:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","E bu adole i, “Na da goudi mano dima iasimu.” Da:ima da amane sia:i, “Defea! Be liligi fonobahadi amo goudi fa:no iasimu ilegema:ne hidadea nama ima.” ");
INSERT INTO beo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","E bu adole ba:i, “Na da adi ima:bela:?” E bu adole i, “Dia ilegei hamomusa: gobele ga:su amola ea efe amola dia dagulu di gaguli mabe amo nama ima.” Amo liligi e da Da:imama i. Amalalu, ela da gilisili golai, amola Da:ima da abula agui ba:i. ");
INSERT INTO beo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Da:ima da ea diasuga asili, ea abula sawa: figisu fadegale, ea didalo eboboi abula bu sali. ");
INSERT INTO beo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda da goudi iasima:ne, amola ea liligi i amo Da:imama bu samogema:ne, ea na:iyado Hila amo asunasi. Be Hila da hogoi helele, amo uda hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","E da Ina:ime dunu ilima amane adole ba:i, “Aie heda:i uda amo da logo bega: esalu, amo da habila:?” Ilia bu adole i, “Guiguda: da aie heda:i uda hamedafa esalu.” ");
INSERT INTO beo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","E da Yudama buhagili amane sia:i, “Na da hogoi helele hame ba:i. Moilai dunu da aie heda:i uda hamedafa esalu sia:i.” ");
INSERT INTO beo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda da amane sia:i, “Defea! Mae dawa:ma! E da na liligi lamu da defea. Dunu eno da ninima oufesega:mu da defea hame. Na da ema bidi imunusa: dawa:i galu. Be di da e hame ba:i.” ");
INSERT INTO beo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Oubi udiana asili, dunu afae da Yudama amane sia:i, “Dia awa Da:ima da wadela:le hamoi. E da wali abula agui ba:sa.” Yuda da amane sia:i, “E gadili oule asili, bogoma:ne laluga ulugagima.” ");
INSERT INTO beo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ilia da e gadili gaguli asili, e da ea awa Yuda ema sia: adole iasi, “Amo liligi amo gobele ga:su, ea efe amola dagulu ba:ma! Amo liligi ea eda amo hamoiba:le na da abula agui ba:sa.” ");
INSERT INTO beo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda da amo liligi da ea liligi dawa:i galu. E amane sia:i, “Dafawane! Ea hou da defea. Nisu da wadela:le hamoi. Na gofe Sila amo e lama:ne sia:mu da defea galu.” Amalalu, Yuda da Da:imama bu hamedafa gilisili golai. ");
INSERT INTO beo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ea mano lamu eso da doaga:loba, e da mano aduna lamu agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","E da mano lalaloba, mano afae da ea lobo gadili ligiagai. Mano lasu fidisu uda da amoga yoi efe la:gili amane sia:i, “Amo da magobo lalelegei.” ");
INSERT INTO beo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Be e da ea lobo bu hiougia ganone amola ea na:iyado da magobo lalelegei. Amalalu, mano lasu fidisu uda da amane sia:i, “Di da agoane gadili bosona asi!” Amaiba:le, ilia da ema Bilese (gadili bosona ahoa) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Amalalu, ea eya amo ea lobo da haliga:me efe la:gi, amo da lalelegei. Ilia da ema dio amo Sila (eso mabe haliga:i ba:sa) asuli. ");
INSERT INTO beo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isiama:ile fi dunu da Yousefe amo Idibidi sogega oule asili, Bodifa (Idibidi hina bagade dunu ea sosodo aligisu dunu ilima hina dunu) ema bidi lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Hina Gode da Yousefe noga:le fidilalu. Ea hawa: hamosu da noga:idafa ba:i. E da ea Idibidi hina ea diasu ganodini esalu. ");
INSERT INTO beo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Bodifa da Hina Gode da Yousefe noga:le fidi amola ea hawa: hamosu da noga:idafa, amo ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Bodifa da ema hahawane bagade. E da Yousefe amo ea fidisu dunu ea diasu amola liligi huluane, amo ouligima:ne hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Amalalu, Yousefe dawa:beba:le, Hina Gode da amo Idibidi dunuma hahawane dogolegele hamoi. Liligi huluane ea diasu ganodini amola ea soge ganodini,, Gode da noga:le fidi. ");
INSERT INTO beo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Bodifa da ea hou huluane ouligima:ne, Yousefema sia:i. Bodifa da liligi huluane mae dawa:le, ea ha:i manu fawane dawa:i galu. Yousefe ea da:i amola ea odagi, da ida:iwane ba:su. ");
INSERT INTO beo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Asili, Bodifa idua da Yousefe amo hanaiwane ba:lalu. E da ema gilisili golama:ne adole ba:lalu. ");
INSERT INTO beo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yousefe da, “Hame mabu!” sia:i. Yousefe da ema amane sia:i, “Na da ouligibiba:le, na hina da ea diasu amola liligi amo hame dawa:lala. E da na ea liligi huluane ouligima:ne ilegei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Na da amo diasu ganodini, e defele hina hou hamosa. Liligi huluane e da nama i, be di fawane nama hame i. Na da habodane amo wadela:i hou hamoma:bela:? Na da habodane Godema wadela:le hamoma:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bodifa idua da eso huluane mae fisili Yousefe da ema gilisili golamusa: sia:su, be Yousefe da ea sia: hame nabi. ");
INSERT INTO beo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Be eso afaega, Yousefe da ea diasu ganodini ea hawa: hamosu hamoma:ne golili sa:ili, hawa: hamosu dunu eno hamedafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Bodifa idua da Yousefe ea abula gaguli, amane sia:i, “Nama gilisili golama!” Be e da ea abula fadegale, gadili hobea:i dagoi. Ea abula da Bodifa idua ea lobo ganodini gagui dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","E da Yousefe ea abula fisili gadili hobea:i dagoi amo ba:loba, ");
INSERT INTO beo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","e da ea hawa: hamosu dunu ilima welalu, amane sia:i, “Ba:ma! Amo Hibulu dunu nagoa da diasuga oule misi, amo da ninima gadele hamosa. E da na seseiga golili misini, na gasawane hi aie heda:le na wadela:lesimusa: dawa:i galu. Be na da bagade a:i gusa:i. ");
INSERT INTO beo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","E da na a:i gusa:i nababeba:le, ea abula fisili gadili hobea:i dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Amo abula gaguli, e da Yousefe ea hina amo bu misa:ne ouesalu. ");
INSERT INTO beo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Amalalu, e da Bodifama ea musa: sia:i defele olelei, amane, “Amo Hibulu udigili hawa: hamosu dunu di guiguda: oule misi da na sesei golili misini, nama hi aie heda:le wadela:le hamomusa: dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Be na da bagade a:i gusa:ne, e da ea abula fisili, gadili hobea:i dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yousefe ea hina (Bodifa) da bagadewane mi hanai galu. ");
INSERT INTO beo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ea sia:beba:le, ilia Yousefe afugili, se iasu diasu (amo ganodini Idibidi hina bagade dunu da wadela:i hamosu dunu sanasu) amo ganodini ha:digili, Yousefe da amo ganodini esalu. ");
INSERT INTO beo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Be Hina Gode da Yousefe hahawane dogolegele fidisu. Amola se iasu diasu ouligisu dunu da Yousefe ea hou hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","E da Yousefe amo se iasu diasu hamosu dunu huluanema, ouligisu hamoi dagoi. Hou huluane amo se iasu diasu ganodini hamosu, amo huluane Yousefe hi da ouligilalu. ");
INSERT INTO beo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Se iasu diasu ouligisu hina da liligi huluane hame dawa:lalu. Bai Hina Gode da Yousefe noga:le fidisu. Ea hou huluane e da noga:le hamoi amola hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Asili, eso enoga, Idibidi hina bagade (Felou) amo ea waini ouligisu dunu amola ea agi hamosu dunu, da hina bagade ougima:ne hou hamoi. ");
INSERT INTO beo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Hina bagade da amo dunu aduna elama ougi bagade. ");
INSERT INTO beo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","E da amo dunu se iasu diasu ganodini ha:digi. Ela da se iasu diasu ouligisu hina dunu ea diasu ganodini esalu. Yousefe amola da amo diasu ganodini esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ela da eso bagohame amo se iasu diasu ganodini esalu. Se iasu diasu ouligisu hina da sia:beba:le, Yousefe da amo dunuma hawa: hamosu dunu esalu. ");
INSERT INTO beo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gasi afaega, hina bagade ea waini ouligisu dunu da simasia ba:i amola agi ouligisu dunu da eno simasia ba:i. Amo simasia ba:i da bai hisu hisu galu. ");
INSERT INTO beo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Hahabe, Yousefe da elama misini, ela da da:i dioi esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","E da elama amane adole ba:i, “Alia da abuli da:i dione esalabala?” ");
INSERT INTO beo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ela da bu adole i, “Ania da hisu hisu simasia ba:i. Be amo ea bai olelemusa:, dunu da guiguda: hame esala.” Yousefe da amane sia:i, “Gode Hi fawane da simasia ba:su bai olelemusa: gasa iaha. Alia simasia ba:su amo nama adoma.” ");
INSERT INTO beo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Amalalu, waini hano ouligisu da amane sia:i, “Na simasia ba:i amo ganodini na da waini efe na midadi lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Waini efe da amoda udiana dialu. Lubi da misini amola mosoi amola fage misini yoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na da Felou ea faigelei gagui dialebe ba:i. Amaiba:le, na da waini fage lale, labugili, waini hano amo Felou ea faigelei ganodini salawane, Felou ea lobo ganodini ligisi.” ");
INSERT INTO beo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yousefe da ema amane sia:i, “Bai da agoane diala. Waini amoda udiana da dawa:loma:ne eso udiana. ");
INSERT INTO beo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Eso udiana asili, Felou da dia se iasu diasu logo doasili, dia musa: hawa: hamosu dima bu imunu. Di da dia musa: hou defele, ema waini faigelei imunu. ");
INSERT INTO beo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Be di hahawane dia musa: hawa: hamosu bu lasea, dia na mae gogolema. Na se iasu diasu logo doasima:ne Felouma sia:ma. ");
INSERT INTO beo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Na da musa: Hibulu sogega enoga gasawane gagulaligi, mugululi asi dagoi ba:i, amola Idibidi soge ganodini wadela:i hou se iasu diasu ganodini salima:ne hamedafa hamoi.” ");
INSERT INTO beo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Bisili agi hamosu dunu da waini ouligisu ea simasia ba:i da hahawane olelei, amo ba:beba:le e da Yousefema amane sia:i, “Na amola da simasia ba:i. Na da na dialuma da:iya agi daba udiana gaguli ahoanebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Daba amo gadodili diala amo ganodini da Felou ea agi gobei hisu hisu dialebe ba:i. Amola sio da amo nanebe ba:i.” ");
INSERT INTO beo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yousefe da bu adole i, “Simasia ba:i ea bai da agoane. Daba udiana da eso udiana. ");
INSERT INTO beo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Eso udiana asili, Felou da dia se iasu diasu logo doasimu. E da dia dialuma damuni fasima:ne sia:mu. Amasea, e da dia da:i hodo amo ifaga hegoa:nesili, sio da misini dia hu na dagomu.” ");
INSERT INTO beo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Eso udiana da asili, Felou ea lalelegesu eso amoga e da ea hou ouligisu dunu ilima lolo nasu bagade hamoi. E da waini hano ouligisu dunu amola agi hamosu dunu, ela se iasu diasu logo doasili, ea ouligisu dunu huluane ba:ma:ne oule misi. ");
INSERT INTO beo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","E da waini hano ouligisu dunuma ea musa: hawa: hamosu bu i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Be bisili agi hamosu dunu amo e da fane legei dagoi. Hou huluane Yousefe adoi defele ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Be waini hano ouligisu dunu da Yousefema bu hame dawa:i. E da Yousefe gogolei. ");
INSERT INTO beo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ode aduna asili, Felou da simasia ba:i. E da Naile Hano bega: lelebe dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Amalalu, bulamagau sefena bagade amo fesuale gala da hano yolesili, saga: ganodini gisi nanebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Amalalu, bulamagau eno fesuale gala be geloga:idafa agoane, da hano yolesili eno bulamagau gadenene lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Amola bulamagau geloga:i da bulamagau sefena gala amo fane mai dagoi. Amalalu, Felou da nedigi. ");
INSERT INTO beo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","E da bu eno golale, bu simasia ba:i. E da gagoma fage fesuale gala amo nabai, yoi amola noga:iwane ba:su gagoma da:i afadafa amoga legebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Amalalu, e da gagoma eno fesuale gala, amo foga fabeba:le, wadela:i amola faselai ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Amalalu, faselai gagoma da misini, gagoma noga:iwane na dagoi. Felou da nedigili, amola amo da simasia ba:su fawane dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Hahabe e da da:i dioiwane dawa:lalu. Amaiba:le, e da Idibidi bagade dawa:su dunu amola fefedoasu dawa: dunu huluane ema misa:ne sia:i. Ea simasia ba:i amo ilima olelei. Be amo ea bai ema olelemu da ilima hamedei. ");
INSERT INTO beo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Amalalu, waini hano ouligisu dunu da Felouma amane sia:i, “Na da wali na wadela:i hou bu dawa:lala. ");
INSERT INTO beo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Di da musa: bisili agi hamosu dunu amola na, anima ougi galu. Di da ani se iasu diasu ouligisu dunu amo ea diasu ganodini sanasi. ");
INSERT INTO beo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Gasi afaega ani da simasia ba:i. Amo da bai hisu hisu galu. ");
INSERT INTO beo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hibulu goi amo da se iasu diasu ouligisu dunu, ea hawa: hamosu dunu, da amogai esalu. Ania da ania simasia ba:su ema olelebeba:le, e da amo ea bai hisu hisu anima moloiwane olelei. ");
INSERT INTO beo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Amalalu, ea hou olelei defele ba:i dagoi. Di da na musa: hawa: hamosu nama bu i dagoi be bisili agi hamosu dunu di da medole legei.” ");
INSERT INTO beo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Felou da Yousefe misa:ne sia:i. Ilia da e se iasu diasuga fisili, Felou ea diasuga oule misi. E da mayabo waga:ne, abula afadenene, Felouma doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Felou da ema amane sia:i, “Na da simasia ba:i be dunu huluane da amo ea bai hame dawa:. Dunu eno da nama adoi, di da simasia ba:su bai bagade dawa:.” ");
INSERT INTO beo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yousefe da bu adole i, “Nisu hame! Be Gode da amo ea bai noga:le olelemu.” ");
INSERT INTO beo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Felou da amane sia:i, “Na da simasia ba:i agoane. Na da Naile Hano bega: lelebe dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Amalalu, bulamagau sefena bagade amo fesuale gala da hano yolesili, saga: ganodini gisi nanebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Amalalu, bulamagau eno fesuale gala be sefena hamedafa, geloga:i agoane, da hano yolesili, heda:i. Bulamagau amo wadela:i defele na da Idibidi amo ganodini hamedafa ba:su. ");
INSERT INTO beo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Geloga:i bulamagau da bulamagau eno, sefena gala, amo fane mai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Be ilia da sefena bulamagau mai dagoi, amo dawa:mu da hamedei. Ilia bu noga:i hame amola geloga:i agoane ba:i. Amalalu, na da nedigi. ");
INSERT INTO beo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Amola na da simasia eno ba:i. Na da gagoma fage fesuale gala amo nabai, yoi amola noga:iwane da:i afadafa amoga legebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Amalalu, na da gagoma fage eno fesuale gala, amo foga fabeba:le, wadela:i amola faselai ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Amola faselai gagoma da misini, gagoma noga:iwane na dagoi. Na da amo fefedoasu dawa: dunu ilima olelei. Be ilia da bai olelemu gogolei.” ");
INSERT INTO beo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yousefe da Felouma amane sia:i, “Amo simasia ba:su aduna da bai afadafa olelesa. Gode da Ea fa:no hamomu dima olelei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulamagau sefena gala fesuale da ode fesuale gala. Gagoma fage noga:idafa fesuale amola da ode fesuale gala. Bai da afadafa. ");
INSERT INTO beo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bulamagau geloga:i gala amola gagoma fage faselai fesuale gala da ode fesuale gala amo ganodini osobo bagade da ha:i bagade ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Na da dima sia:i defele - Gode da Ea fa:no hamomu dima olelei. ");
INSERT INTO beo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ode fesuale amoga, ha:i manu legei Idibidi soge ganodini da bagadedafa ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Be amo fa:no ninia da ode fesuale gala amoga ha:i bagadedafa ba:mu. Osobo bagade da wadela:lesi dagoi ba:mu. Ode noga:iwane da gogolei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ha:i da bagadeba:le, osobo bagade da se nabimu, amola ode noga:i da gogolei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Gode da aduna olelebeba:le, E da amo hou hame afadenene, dafawanedafa hamomu, amo olelesa. ");
INSERT INTO beo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Amaiba:le, di da dunu afae amo bagade dawa:su dunu amola ba:la:lusu dawa: dunu amo soge ouligimusa: ilegemu da defea. ");
INSERT INTO beo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Eno ouligisu dunu amola ilegemu da defea. Ode noga:iwane amoga, ha:i manu legei amoga biyale fifili, fifi afadafa Felou hi lamu da defea. ");
INSERT INTO beo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Di ouligisu dunuma ilia da ode noga:iwane ganodini amo ha:i manu huluane lidili, diasu ganodini ligisili, noga:le ouligima:mu. ");
INSERT INTO beo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Amo ha:i manu da ode wadela:i fesuale gala Idibidima misunu, amoga dunu ili mae bogoma:ne amo manu. Amasea, dunu da hame ha:ga bogogia:mu.” ");
INSERT INTO beo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Felou amola ea ouligisu dunu da amo hou hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Felou da ilima amane sia:i, “Dunu eno da Yousefe ea hou baligimu ninia da hame ba:mu. Bai Gode Ea A:silibu da ea dogo ganodini esala.” ");
INSERT INTO beo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Felou da Yousefema amane sia:i, “Gode da amo hou dima olelei dagoi. Amaiba:le, dia dawa:su amola ba:la:lusu hou da dunu huluane ilia hou baligi dagoi amo ninia dawa:. ");
INSERT INTO beo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Na da di Idibidi soge ouligima:ne ilegesa. Na fi dunu huluane da dia sia: nabimu. Dia hina hou da dunu huluane ilima baligimu. Na fawane, di da hame baligimu. ");
INSERT INTO beo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Di da Idibidi soge huluane ouligima:ne, na da dima ouligisu hina ilegesa.” ");
INSERT INTO beo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Felou da ea lobo sogo gasisalasu (amoga ea gobele ga:su da dedei) amo gisa:i, Yousefe ea lobo sogo amoga gasisali. E da abula ida:iwane Yousefema idinigisi amola gouli sia:ine amo Yousefe ea galogoaga sisiga:le sanasi. ");
INSERT INTO beo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E da ea No. 2 ‘sa:liode’ hosiga hiougi amo Yousefe da ahoanoma:ne, ema i. Amola ea dadi gagui dunu da Yousefema bisili asili, amane welalu, “Gasigama! Logo fodoma!” Amola Yousefe da Idibidi soge huluane ouligima:ne, ouligisu hina hamoi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Felou da ema amane sia:i, “Na da Idibidi hina bagade. Be Idibidi soge ganodini, dunu huluane da dia sia: fawane nabimu.” ");
INSERT INTO beo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","E da Yousefema eno Idibidi dio asuli amo Sa:bina:de Bania. Amola e da Boudifela (ogogosu ‘gode’ One amoma gobele salasu dunu Hilioubalisi moilai bai bagadega esalu) amo idiwi A:sena:de, amo Yousefe lama:ne ema i. Amola, Yousefe da Idibidi soge huluane amoga lalu. ");
INSERT INTO beo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yousefe da ea lalelegei ode30amoga Felou (Idibidi hina bagade) amo ea hawa: muni hamosu. E da Felou ea diasua fi gilisisu fisili, Idibidi soge huluane amoga lalu. Ode noga:iwane amoga, ha:i manu legei da bagade ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Amo huluane Yousefe da lale, moilai bai bagadega gaguli misini, amoga liligi ligisisua salasu. Ha:i manu soge moilai bai bagade sisiga:i dialu, amo ea ha:i manu fai e da amo moilai bai bagade ganodini sali. ");
INSERT INTO beo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Widi amola gagoma bagadedafa laiba:le, Yousefe da amo ea defei ba:mu yolesi. Gagoma da sa:i amo hano wayabo bagade bega: diala, amo ea defei defele ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ha: bagade da osobo bagadega mae doaga:le, Yousefe da A:sena:dema dunu mano aduna lai. ");
INSERT INTO beo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","E amane sia:i, “Gode da na se nabasu na ada amola fi fisiba:le, amo E da na gogolema:ne fadegai dagoi.” Amaiba:le, e da ea magobo mano ema Ma:na:se (gogolema:ne hamosa) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","E eno amane sia:i, “Gode da na se nabasu soge amo ganodini mano nama i.” Amaiba:le, e da ea magobo bagia mano ema Ifala:ime (manolali iaha) dio asuli. ");
INSERT INTO beo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ode ida:iwane fesuale gala Idibidi soge ganodini da gidigi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Amola ha:i bagade ode, Yousefe ea sia:i defele da mui. Soge huluanedafa da ha:i bagade ba:i. Be Idibidi soge ganodini, ha:i manu defele dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Idibidi dunu da degabo ha:i nabaloba, ilia da Felouma e da ilima ha:i manu ima:ne wei dagoi. Amalalu, e da ili Yousefema ha:i manu lama:ne masa:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ha: bagade da bu bagade ba:i. Soge huluane da ha: bagade ba:i. Amaiba:le, Yousefe da liligi legesu doasili, Idibidi dunuma widi amola gagoma bidi lai. ");
INSERT INTO beo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Osobo bagade fifi asi gala dunu huluane da ha:i manu bidi lamusa:, Idibidi sogega Yousefema misi. Bai ha: bagade da osobo bagade soge huluane amoga doaga:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ya:igobe da gagoma Idibidi dialebe amo nababeba:le, egefelali ilima amane sia:i, “Dilia da abuli udigili esalabala? ");
INSERT INTO beo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Na da nabi gagoma Idibidi sogega diala. Ninia da ha:iba:le bogosa:besa:le, amoga lala masa.” ");
INSERT INTO beo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Amaiba:le, Yousefe ea yolalali nabuane gala da Idibidi sogega gagoma bidi lamusa: asi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Be e da se nabasa:besa:le, Ya:igobe da Yousefe eya Bediamini amo hame asunasi. ");
INSERT INTO beo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ga:ina:ne soge da ha:i bagadeba:le, Ya:igobe egefelali da eno dunu gilisili, gagoma ha:i manu bidi lama:ne misi. ");
INSERT INTO beo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yousefe, Idibidi ouligisu hina dunu, da osobo bagade fifi asi gala dunu huluane ilima gagoma bidi lalu. Amaiba:le, Yousefe yolalali da ema misini, ilia odagi osoboa digimusa: begudui. ");
INSERT INTO beo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yousefe da ea yolalali ba:beba:le, ili dawa:i galu. Be e da ogogole, e da ili hame dawa:i agoane hamoi. E da gasa fiwane ilima adole ba:i, “Dilia da habidili misibala:?” Ilia da bu adole i, “Ninia da Ga:ina:ne sogega ha:i manu bidi lamusa: misi.” ");
INSERT INTO beo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yousefe da ea yolalali dawa:i. Be e da ilia eya amo ilia da hame dawa:i. ");
INSERT INTO beo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","E da ilima musa: simasia ba:su amo bu dawa:i. E ilima amane sia:i, “Dilia da desega ahoasu dunu. Dilia da Idibidi soge amo ninia habidili gasa hame gala amo ba:la misi.” ");
INSERT INTO beo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Be ilia bu adole i, “Hame mabu, hina! Ninia da dia udigili hawa: hamosu dunu defele, ha:i manu bidi lamusa: misi. ");
INSERT INTO beo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ninia huluane da olalali esala. Ninia da desega ahoasu dunu hame. Ninia huluane da moloi dunu.” ");
INSERT INTO beo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yousefe bu adole i, “Hame mabu! Dilia da ninia soge amo ea gasa hame hou ba:la misi dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ilia bu amane sia:i, “Ninia da olalali fagoyale galu. Ninia da dunu afae Ga:ina:ne soge ganodini amo ea manolali gala. Be eya afae da bogoi, amola ufi dunu mano da ninia eda amola esala.” ");
INSERT INTO beo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yousefe da bu adole i, “Na sia:i defele dilia da desega ahoasu dunu. ");
INSERT INTO beo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Na dilima adoba:su hou hamomu. Felou ea dioba:le, na da agoane sia:sa. Dilia fa:no lalelegei eya da guiguda: hame manoba, dilia da guiguda: hamedafa yolesimu. ");
INSERT INTO beo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Dilia fi dunu afae e lala masa:ma! Dilia eno huluane da guiguda: se iasu diasu ganodini esalumu. Dilia sia: da dafawane o dafawane hame, amo ninia ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Amalalu, e da ili se iasu diasu ganodini sali. Amoga ilia eso udiana esalu. ");
INSERT INTO beo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Eso udiana amoga Yousefe da ilima amane sia:i, “Na da Godema beda:i dunu. Dilia liligi afadafa hamosea fawane, na da dili hame fane legemu. ");
INSERT INTO beo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Dilia sia: da dafawane olelema:ne, dunu afae fawane da se iasu diasu ganodini esalumu. Dilia eno da dilia ha:i bagade fi ilima ha:i manu dilia lai gaguli masa. ");
INSERT INTO beo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Amasea, dilia fa:no lalelegei eya amo guiguda: oule misa. Amasea, dilia da hame ogogoi, na da dawa:mu amola na da dili hame fane legemu.” Amo da defea ilia sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ilia gilisili sia: dasu, “Dafawane! Wali ninia se nabasu da dabe agoane ninia eya ema wadela:le hamoiba:le lasa. E da ninima e fidima:ne se nabawane edegei, be ninia da hame nabi. Amaiba:le, ninia wali dabe agoane se naba.” ");
INSERT INTO beo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Liubene da amane sia:i, “Na da goi maedafa wadela:ma:ne sia:i; be dilia da hame nabi. Wali ea bogoi amoga ninia da dabe laha.” ");
INSERT INTO beo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yousefe da ilia sia: huluane dawa:i. Be amo hou ilia da hame dawa:i. Ilia da ema sia:noba, sia: adole iasu dunu, amoga fawane sia:su. ");
INSERT INTO beo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yousefe da ili yolesili, disu. Amalalu, e da ilima bu misini, ilima sia: dasu. Ea sia:beba:le, ea dadi gagui da Simiane lale, ilia huluane ba:ma:ne lala:gi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yousefe da sia:beba:le, ea hawa: hamosu dunu da ilia esa amo gagoma amoga nabalesi. Ilia da Yousefe yolalali ilia esa afae afae amo ganodini, silifa muni ilia musa: i, amo sali. Amola ilia da ha:i manu ilia logoga ahoasea moma:ne, ilima i. ");
INSERT INTO beo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Amalalu, Yousefe yolalali da ilia gagoma lai, amo ilia dougi baligiga ligisili, yolesili asi. ");
INSERT INTO beo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Asili, ilia da sogebi amo golamusa: ouesalu, dunu afae da ea dougi amo ha:i manu imunusa: ea esa doasilaloba, ea muni amo gagoma gadodili ligisi dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","E da yolalalima amane sia:i, “Na muni ilia da nama bu i. Amo da na esa ganodini dialebe ba:sa.” Ilia bagade beda:i galu. Ilia da gilisili amane sia: dasu, “Gode da anima adi hamobela:?” ");
INSERT INTO beo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ilia da eda Ya:igobema doaga:loba, ilia da hou huluane ilima misi amo huluane ema amane adoi, ");
INSERT INTO beo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Idibidi ouligisu hina dunu da ninima gasa bagade ougiwane sia:i. E da nini ea soge wadela:musa:, desega ahoanebe sia:i. ");
INSERT INTO beo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Be ninia ema bu adole i, ‘Ninia da desega ahoasu dunu hame. Ninia moloidafa dunu. ");
INSERT INTO beo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ninia da olalali fagoyale galu. Ninia dunu afae amo egefelali gala. Ninia eya da bogoi amola fa:no lalelegei eya da ninia eda amola Ga:ina:ne soge ganodini esala.’ ");
INSERT INTO beo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Amalalu, Idibidi hina da amane sia:i, ‘Dilia da moloidafa dunu o hame, amo ninia da amoga ba:mu. Dunu afadafa da nama ouesalumu. Eno da dilia ha:i bagade fi ilima ha:i manu gaguli masa. ");
INSERT INTO beo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Dia eya fa:no lalelegei, amo nama oule misa. Amasea, dilia da desega ahoasu dunu hame be moloidafa amo na da dawa:mu. Na da dilia ola dilima bu imunu. Amola dilia da guiguda: bidi lasu hamomusa: ouesalumu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Amalalu, ilia da gagoma esa ganodini sali amo huluane gugudili legeiya, ilia huluane muni ganodini sali dialebe ba:i. Amo ba:beba:le, ilia, amola ilia eda Ya:igobe, da bagade beda:i galu. ");
INSERT INTO beo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ilia eda da ilima amane sia:i, “Dilia da na mano huluane fisimu, amo dilia da hanabala:? Yousefe da fisi dagoi. Simiane da fisi dagoi. Wali dilia da Bediamini fadegamusa: dawa:lala. Ni fawane da se naba.” ");
INSERT INTO beo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Liubene da ea edama amane sia:i, “Na da Bediamini dima bu hame oule masea, di da na dunu mano aduna fane legemu da defea. Na ouligima:ne, Bediamini nama ima. Na da e bu oule misunu.” ");
INSERT INTO beo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Be Ya:igobe da amane sia:i, “Na gofe da dili sigi masunu hamedei. Ea ola da bogoi amola hisu da esala. E da logoga se nabasa:besa:le, hamedafa masunu. Na da dunu da:i hamoi dagoi. Di da amo se nabasu nama iasea, na bogomu.” ");
INSERT INTO beo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ga:ina:ne soge ganodini ha:i da bu bagade heda:lebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ya:igobe ea fi da gagoma huluane Idibidiga lai, amo na dagoloba, Ya:igobe da egefelali ilima amane sia:i, “Dilia Idibidi amoga ha:i manu fonobahadi bidi lamusa: masa.” ");
INSERT INTO beo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda da ema amane sia:i, “Idibidi ouligisu hina da gasa bagade sisasu ninima sia:i. Ninia da eya hame oule masea, ea odagi hamedafa ba:mu sia:i. ");
INSERT INTO beo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Be di da ninia eya ninia oule masunu defele ba:sea, ninia da ha:i manu bidi lala masunu. ");
INSERT INTO beo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Be amo di higasea, ninia da hame masunu. Bai ouligisu hina da ninia eya hame oule masea, ea odagi hame ba:mu amane sia:i.” ");
INSERT INTO beo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ya:igobe da amane sia:i, “Dilia abuliba:le nama se bagade iaha. Abuliba:le, dilia da eya eno esala amo ema olelebela:?” ");
INSERT INTO beo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ilia da bu adole i, “Ouligisu hina da ninia sosogo fi ilia hou, bagadewane adole ba:lalu amane, ‘Dilia eda wali esalabala? Dilia da eya eno esalabala?’ Ninia da ema adole hame imunu da hamedei. Ninia da habodane e da ‘Dilia eya guiguda: oule misa’ sia:mu amo dawa:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda da ea edama amane sia:i, “Na oule masa:ne, goi asunasili ninia wahadafa masunu. Amasea ninia huluane da hame ha:ga bogomu. ");
INSERT INTO beo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","E da se hame nabimu, amo na da gasa bagade sia:sa. Na da amo goi hahawane hame bu oule masea, defea, di da nama eso huluane nisu da wadela:le hamoi sia:mu da defea. ");
INSERT INTO beo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Be wali, ninia guiguda: sia: dalebe hame ouesalu ganiaba, ninia da Idibidi sogega aduna asili bu misini hamona:noba.” ");
INSERT INTO beo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Amalalu, ilia eda Isala:ili da ilima amane sia:i, “Defea! Amai galea dilia agoane hamoma. Dia liligi amo ganodini, ninia soge ha:i manu ida:iwane ouligisu hina ema ima:ne gaguli masa. Amo gamali fonobahadi, agime hano, hedama:ne fodole nasu, molobe, amola ‘alamode’ fage. ");
INSERT INTO beo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Amola muni dilia musa: gaguli asi amo adunawane gaguli masa. Bai muni da dilia esa amo ganodini sinidigi dagoi ba:i, amo dilia bu gaguli masa. Amabela:? Ilia giadofale bu iasu. ");
INSERT INTO beo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dilia eya lale, hedolo bu masa. ");
INSERT INTO beo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Gode Bagadedafa da amo Idibidi ouligisu dunu nama asigima:ne hamomu da defea. Amasea, e da Bediamini amola dilia ola eno nama bu imunu. Be na da na mano fisimu galea, defea, na da fisimu.” ");
INSERT INTO beo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Amaiba:le, olalali da hahawane udigili iasu liligi amola muni aduna gala gaguli asili, Bediamini amola Idibidi diasuga doaga:musa: asi. Amoga doaga:loba, ilia da Yousefema asi. ");
INSERT INTO beo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yousefe da Bediamini da yolalali amo gilisili misi amo ba:beba:le, ea diasu hawa: hamosu dunu ilia ouligisu dunuma amane sia:i, “Di amo dunu na diasuga oule masa. Esomogoa ilia da na amola gilisi ha:i manu. Amaiba:le, fofoi ohe amo medole legele, gobema.” ");
INSERT INTO beo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Amo hawa: hamosu dunu da Yousefe ea sia:i defele hamoi. E da Ya:igobe manolali amo Yousefe diasuga oule asi. ");
INSERT INTO beo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ilia da amo diasuga oule asili, bagadewane beda:i galu. Ilia amane dawa:i, “Muni ninia esa amo ganodini bu dialebe ba:beba:le, ilia da nini guiguda: oule ahoa. Amasea, ilia da sinidigili, ninima gasawane doagala:le, ninia dougi lale amola nini udigili hawa: hamosu dunu hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Amaiba:le, ilia da diasu logo holeiga, hawa: hamosu dunu ilia ouligisu dunuma amane sia:i, ");
INSERT INTO beo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ada! Ninia da musa: guiguda: ha:i manu bidi lala misi. ");
INSERT INTO beo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Be ninia da ninia diasuga buhagimusa: logoga golamusa: oualigi, ninia esa doasiloba, ninia muni musa: dima i, ninia esa amo ganodini dialebe ba:i. Huluane da galu. Amo ninia da dima bu gaguli misi. ");
INSERT INTO beo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ninia da eno muni amola ha:i manu eno bidi lamusa:, gaguli misi. Nowa da amo muni ninia esa ganodini salibala:?. Amo ninia hame dawa:.” ");
INSERT INTO beo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Be ouligibi hawa: hamosu dunu da amane sia:, “Mae dawa:ma! Mae beda:ma! Dilia Gode - Dilia ada ea Gode amo da dilia muni dilia esa ganodini salibala:? Na da dilia muni lai dagoi.” Amalalu, e da Simiane ilima oule misi. ");
INSERT INTO beo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Hawa: hamosu ouligisu dunu da olalali huluane diasu ganodini oule asi. E da ilia emo dodofema:ne, hano ilima i. E da ilia dougi ilima ha:i manu i. ");
INSERT INTO beo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ilia da Yousefema hahawane ima:ne, ilia iasu liligi momagei. Bai hawa: hamosu dunu amo da ilia da Yousefe amola gilisili ha:i manu, amo ilima olelei dagoi. ");
INSERT INTO beo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yousefe da ea diasuga doaga:loba, ilia da hahawane udigili iasu amo diasu ganodini gaguli misini, ema i. Amola ilia da Yousefema osoboga begudui. ");
INSERT INTO beo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","E da ilia hou ilima adole ba:i. Amalalu, e amane sia:i, “Dilia ada da:i hamoi dilia nama adoi? E da hahawane esalabala?” ");
INSERT INTO beo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ilia da bu adole i, “Dia fonoboi hawa: hamosu dunu ninia ada da hahawane esala.” Amalalu, ilia da muguni bugili, ema begudui. ");
INSERT INTO beo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yousefe da ea eya Bediamini ba:loba, amane sia:i, “Amo da dilia nama adoi dilia fa:no lalelegei eyala:? Na gofe! Gode da di hahawane dogolegele fidimu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Amalalu, Yousefe da hedolowane fisili asi. E da ea dogo ganodini ea eyama bagade asigiba:le, dimusa: dawa:i galu. Ilia da ea dibi ba:sa:besa:le, e da ea sesei amoga asili, dinanu. ");
INSERT INTO beo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Fa:no, e da ea odagi dodofelalu amola ea dogo bu denesilalu, e da bu misini, ha:i manu ima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yousefe da fafai afae, amola yolalali da fafai enoga ha:i mai. Idibidi dunu da Hibulu dunu ilima gilisili ha:i manu da gogosiasu liligi, Idibidi dunu da dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yolalali da fafai amoga fibi ba:i. Ilia da Yousefe ba:le gusuli esafulubi ba:i. Yousefe da sia:beba:le, ilia lalelegei defele olalali, eyalali, dadalele fi. Idibidi ouligisu hina da ilia lalelegei dadalesu dawa:beba:le dadalesu hamoi, amo ba:beba:le, ilia da bagadewane fofogadigili, enoenoma ba:lafui. ");
INSERT INTO beo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Hawa: hamosu dunu da Yousefe ea fafai amoga ha:i manu lale, ilima i. Amola Bediamini hisu ilia da ha:i manu biyale gala bagade ema i. Amaiba:le, ilia amola Yousefe, da ha:i bagade mai amola waini hano bagade nanu feloabe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yousefe da ea hawa: hamosu hina dunuma amane sia:i, “Di da amo dunu ilia esa, ilia gasa gaguli masunu defele, nabama. Amola, dunu hisu hisu ilia muni i, amo bu ilia esa ganodini salima. ");
INSERT INTO beo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Na silifa faigelei amo ufi mano amo ea esa ganodini ea muni amola salima.” Hawa: hamosu dunu da Yousefe ea sia: defele hamoi. ");
INSERT INTO beo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Hahabedafa, ilia da amo olalali amola ilia dougi, ilia soge buhagimusa: asunasi. ");
INSERT INTO beo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ilia da fonobahadi logoga asili, Yousefe da ea diasu hawa: hamosu hina dunuma amane sia:i, “Hedolo! Ilima fa:no bobogema! Ilima doaga:sea, amane adole ba:ma, “Dilia da abuli hou ida:iwane amoga dabe agoane wadela:i hou hamosala:? ");
INSERT INTO beo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Dilia da abuli na hina ea silifa faigelei amo wamolabala? E da amoga waini naha amola amoga ba:la:lusu hou hamosa. Dilia da wadela:i bagade hamoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yousefe ea hawa: hamosu dunu da yolalali ilima fa:no bobogele, madelala heda:i. E da Yousefe ea sia: ilima bu sia:i. ");
INSERT INTO beo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ilia da ema bu adole i, “Ada! Adi baiga di da ninima agoane sia:sala:? Ninia agoane hou da hamedafa hamosa. ");
INSERT INTO beo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Di dawa:. Muni amo ninia esa ganodini dialebe ba:i, amo ninia Ga:ina:ne sogega bu gaguli misi. Ninia da dia hina diasuga silifa amola gouli, abuli wamolama:bela:? ");
INSERT INTO beo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ada! Ninia dunu afae da amo faigelei wamolai ba:sea, amo medole legema. Amai ba:sea, ninia eno huluane da dia udigili hawa: hamosu dunu esalumu.” ");
INSERT INTO beo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","E bu adole i, “Defea! Be faigelei wamolasu dunu, hi fawane da udigili hawa: hamosu dunu esalumu. Dilia eno huluane da ahoanumu.” ");
INSERT INTO beo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Amaiba:le, ilia da esa huluane osoboga ligisili, ilia huluane da esa hisu hisu doalegele, esa lafi ifalesisi. ");
INSERT INTO beo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Yousefe hawa: hamosu dunu da esa huluane hogoi helei. E da degabo magobo mano ea esa hogole, asili huluane hogole, ufi mano Bediamini ema doaga:i. Ilia da Bediamini ea esa ganodini silifa faigelei dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Olalali da se nababeba:le, ilia abula gadelale, ilia liligi amo dougi baligiga ligisili, Yousefe ea diasuga buhagi. ");
INSERT INTO beo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Amoga doaga:loba, Yousefe esalebe ba:i. Ilia da ema begudui. ");
INSERT INTO beo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yousefe da ilima amane sia:i, “Dilia da adi hamobela:? Na da ba:la:lusu hou hamobeba:le, amo hou hedolo dawa:i. Amo dilia hame dawa:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda da bu adole i, “Ada! Ninia da adi sia:ma:bela:? Ninia hou dodofemu da hamedei. Gode da ninia wadela:i hou dedeboi amo hadigiga gaguli misi. Afae amo faigelei ea esa ganodini ba:i amo fawane hame, be ninia huluane da dia udigili hawa: hamosu dunu esalumu.” ");
INSERT INTO beo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Be Yousefe da amane sia:i, “Hame mabu! Na da agoane hamedafa hamomu. Faigelei gagui hi fawane da na udigili hawa: hamosu dunu esalumu. Dilia eno huluane da hahawane dilia eda ea diasuga bu masunu.” ");
INSERT INTO beo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda da Yousefema misini, amane sia:i, “Ada! Na da dima sia:sa:imu galebe! Nama mae ougima! Na da di Idibidi hina bagade amo defele ba:sa. ");
INSERT INTO beo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Di da ninima adole ba:i, ‘Dilia da ada o olalali eno esalabala?’ ");
INSERT INTO beo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ninia da bu adole i, ‘Ninia da ada da:i hamoi esala amola eya amo da ada ea da:i hamoi esoga lalelegei, e amola da esala. Amo goi ea ola da bogoi amola wali hi fawane da ea ame ea mano afadafa esala. Ea ada da ema bagade asigisa.’ ");
INSERT INTO beo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ada! Di da amo goi nini guiguda: di ba:ma:ne, oule misa:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Amola ninia da amo goi da ea ada yolesimu da hamedei sia:i. Amai ganiaba, ea ada da bogola:loba. ");
INSERT INTO beo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Amalalu di da amane sia:i, ‘Dilia eyadafa da dilia amola sigi hame masea, dilia da na odagi hame ba:mu.’ ");
INSERT INTO beo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nini da ninia adama bu asili, dia sia: ema adoi. ");
INSERT INTO beo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Amanoba, e da ninima ha:i manu fonobahadi bidi lamusa: bu masa:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ninia da ema bu adole i, ‘Ninia bu masunu da hamedei. Ninia eyadafa amo hame oule ahoasea, amo dunu ea odagi hame ba:mu. Ninia eya sigi ahoasea fawane masunu gala.’ ");
INSERT INTO beo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ninia ada ninima amane sia:i, ‘Dilia dawa:. Na uda La:isele da nama dunu mano aduna fawane lai. ");
INSERT INTO beo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Afadafa da fisi dagoi. E da gasonasu ohe fi amoga medole legebela:? E da asi amola amo na da bu hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na da ufi mano afae fawane esala. Be amo dilia oule ahoasea, e da se nabasea, na da:i hamoiba:le, se bagade dili nama i amo nababeba:le, bogomu.’ ");
INSERT INTO beo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Amaiba:le, ada! Na amo goi fisili adama bu asili, e da goi hame oule misi amo ba:sea, bogomu. Ea esalusu amola amo goi ea esalusu da gilisili lala:gi agoane diala. E da:idafa hamoiba:le, ninia da amo se nabasu ema iasea, e da bogomu. ");
INSERT INTO beo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na amola da na esalusu fisima:ne, dafawanedafa amo goi bu oule misa:ne sia:i. Na amo goi hame oule masea, eso huluane ni fawane da wadela:le hamoi, amo e da sia:mu da defea, ema adoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Wali ada! Na da amo goi ea sogebi lale, ni fawane da dia udigili hawa: hamosu dunu esalumu. E amola ea olalali, ilia buhagimu da defea. ");
INSERT INTO beo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na amola amo goi ani mae asili, nisu na adama masunu da hamedei. Na ada da amo se nabimu, na da hamedafa ba:mu!” Yuda e amane sia:i. ");
INSERT INTO beo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yousefe da dimusa: dawa:beba:le, bu ea hawa: hamosu da amo hou ba:sa:besa:le, e da ili huluane amo sesei fisima:ne sia:i. E da ea yolalali ilima e da Yousefe adoloba, dunu eno da hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","E bagadewane dibiba:le, Idibidi dunu ilia da nabi. Amalalu, ilia da amo sia:ne iasu Felou ea diasuga adola asi. ");
INSERT INTO beo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yousefe da ea yolalali ilima amane sia:i, “Na da Yousefe. Na ada da wali hahawane esalabala?” Be ea yolalali da amo sia: nababeba:le, ilia da bagadewane beda:iba:le, bu adole imunu da ilima hamedei. ");
INSERT INTO beo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Be Yousefe da ilima amane sia:i, “Nolalali! Dilia nama gadenena misa!” Ilia da misini, e eno adole i, “Na da dilia eya Yousefe amo dilia Idibidi sogega bidi lai. ");
INSERT INTO beo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Dilia mae fofogadigima, amola mae da:i dioma! Amola dilia wadela:i houba:le, wadela:i fawane ninima doaga:i, mae dawa:ma! Gode Hi da dilia loboga, na guiguda: eno dunu ilia esalusu gaga:ma:ne, asunasi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Wali da ha:i bagade ode ageyadu fawane. Ode biyale gala eno amoga osobo da hame gidinamu amo ha:i manu hame faimu, amo hou ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gode da na amo dili bisili masunusa:, asunasi dagoi. Bai E da dili amola diligaga fa:no lalelegemu mano, amo bogomu higa:i hodosa. ");
INSERT INTO beo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Amaiba:le houdafa da dilia na guiguda: hame asunasi. Gode Hifawane da na asunasi. Gode hamobeba:le, na da wali Felou ea bisili ouligisu hina dunu hamoi dagoi. Na da ea soge huluane ouligisa. Na da Idibidi fi huluane ilima hina esala. ");
INSERT INTO beo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Amaiba:le, hedolo na adama buhagili, ema ea mano Yousefe amane sia:sa amo adoma, ‘Gode da na Idibidi dunu huluanema hina bagade hamoi dagoi. Wahadafa nama misa. ");
INSERT INTO beo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Di da Gousiene sogega na gadenene fimu da defea. Di, dia mano, dia aowa, dia sibi, dia goudi, dia bulamagau amola dia liligi gagui huluane. ");
INSERT INTO beo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Di da Gousiene sogega esalea, na da di ouligisa esalumu, amo dawa:ma. Wali ha:i bagade ode biyale gala eno ba:mu. Di, dia sosogo fi, amola dia lai gebo, amo huluane ha:ga bogomu na bagadewane higa:i hodosa.” ");
INSERT INTO beo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yousefe da eno amane sia:i, “Defea! Wali dilia huluane amola di Bediamini, da noga:le dawa:. Na da dafawane Yousefe e. ");
INSERT INTO beo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Na ada noga:le adoma amane, ‘Na da guiguda: Idibidi soge ganodini gasa bagade gala. Dilia ba:i liligi huluane ema adoma. Amasea, hedolowane e nama oule misa.’” ");
INSERT INTO beo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","E da Bediamini ha:giwane nonogone dinanu. Bediamini amola Yousefe nonogone dinanu. ");
INSERT INTO beo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Amanoba, dinanuwane, e da yolalali huluane ouga:ne, nonogoi. Amalalu, yolalali da ema sia: dasu. ");
INSERT INTO beo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Felou ea diasu fi da Yousefe yolalali da ema doaga:i, amo nababeba:le, hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Felou da Yousefema amane sia:i, “Diolalali ilima amane sia:ma, ilia da ilia ohe baligiga ha:i manu legele, hedolowane Ga:ina:ne sogega buhagima. ");
INSERT INTO beo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Amalalu, ilia ada amola fi huluane, guiguda: bu oule misa. Na da soge baligili ida:iwane Idibidi soge ganodini, amo ilima imunu. Ilia baligiliwane hahawane esalusu ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ilia Idibidi gaguli fula ahoasu (bulamagau amoga hiougi) amoga ilia uda amola mano fonobahadi, amoga fila heda:ma:ne, amo oule masunu da defea. Ilia eda amola, bu oule misa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ilia liligi eno ilia sogega fisibiba:le, ilima mae da:i dioma:ne sia:ma. Liligi baligili ida:iwane Idibidi soge ganodini amo ninia da ilima imunu.” ");
INSERT INTO beo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ya:igobe ea mano da amo sia: defele hamosu. Yousefe da ilima gaguli fula ahoasu i, amola ilia logoga moma:ne ha:i manu i. ");
INSERT INTO beo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","E da abula afadafa salima:ne, ilima afae afae i. Be Bediaminima e da abula biyale salima:ne i, amola silifa muni fage 300 agoane i. ");
INSERT INTO beo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","E da ea adama dougi nabuane gala amo da:iya, Idibidi liligi ida:iwane gala ligisi, amo asunasi. Amola e da dougi nabuane eno amo da:iya gagoma, bali, agi amola logoga moma:ne ha:i manu eno i. ");
INSERT INTO beo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","E da yolalali asunasi. E da ilima amane sia:i, “Dilia logoga ahoasea, mae sia:ga gegema!” ");
INSERT INTO beo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ilia Idibidi yolesili, ilia eda Ya:igobe amo Ga:ina:ne sogega esalu, ema buhagi. ");
INSERT INTO beo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ilia ema amane sia:i, “Yousefe da esala. E da Idibidi fi huluane ilima hina esala.” Ya:igobe da bogomuwane fofogadigili, ilia sia: dafawaneyale dawa:mu hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Be ilia Yousefe ea sia: huluane ema olelebeba:le, amola gaguli fula ahoasu Yousefe da e Idibidi sogega oule masa:ne iasi amo ba:beba:le, e da uhi. ");
INSERT INTO beo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","E amane sia:i, “Na gofe Yousefe da esala! Na da Godema eno hame adole ba:mu! Na da mae bogole e ba:la masunu!” ");
INSERT INTO beo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ya:igobe da ea liligi huluane momagele, Bia Siba amoga asi. Amogai, e da ea ada Aisage ea Gode Ema nodone gobele salasu hamoi. ");
INSERT INTO beo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Gasia, e da Gode esalebe ba:i. Gode da ema amane sia:i, “Ya:igobe! Ya:igobe!” E bu adole i, “Na wea!” ");
INSERT INTO beo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Gode da amane sia:i, “Na da Gode, amo dia ada ea Gode. Di da Idibidi amoga masunu, mae beda:ma. Amogai, na digaga manolali ilima gasa bagade fi hamomu. ");
INSERT INTO beo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Na ani Idibidi sogega masunu. Fa:no digaga mano fi amo Na da Ga:ina:ne sogega guiguda: bu oule misunu. Di bogosea, Yousefe amola da dia bogosu ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Amalalu, Ya:igobe da Bia Siba fisili asi. Egefelali da Ya:igobe amola ilia mano fonobahadi amola ilia uda, amo gaguli fula ahoasu Felou da ilima iasi amoga fila heda:le, oule asi. ");
INSERT INTO beo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ilia liligi amola lai gebo huluane, amo ilia Ga:ina:ne sogega lai, amo huluane ilia gaguli asili, Idibidi diasuga asi. Ya:igobe da egaga mano fi huluane oule asi. ");
INSERT INTO beo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Amo da egefelali, ea aowalali, idiwilali amola ea uda mano aowalali. ");
INSERT INTO beo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ya:igobe ea sosogo fi e da Idibidi sogega oule asi, ilia dio da hagudu dedei amo, ea magobo manoLiubene, ");
INSERT INTO beo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Liubene egefelali amo Ha:inage, Ba:liu, Heselone amola Gami, ");
INSERT INTO beo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiane. Simiane egefelali amo da Yimiuele, Ya:imini, Ouha:de, Ya:igini, Souha amola Sia:iule (amo da Ga:ina:ne uda ea mano). ");
INSERT INTO beo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lifai. Lifai egefelali amo da Gesiome, Gouha:de amola Milalai. ");
INSERT INTO beo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda. Yuda egefelali amo da Sila, Bilese, Sela, (Yuda ea mano eno amo E amola Ouna:ne, ela da Ga:ina:ne sogega bogoi.), Bilese egefela Heselone amola Ha:imale. ");
INSERT INTO beo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Amola Ya:igobe ea manoIsiga. Isiga egefelali da Doula, Bua, Ya:isiabe amola Simolone. ");
INSERT INTO beo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ya:igobe ea mano enoSebiulane. Sebiulane egefelali da Silede, Ilone, amola Yalili. ");
INSERT INTO beo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Amo da Ya:igobe ea dunu mano e da Lia amoma lai, Mesoubouda:imia soge amo ganodini. E da uda mano amola lai amo Daina. Ya:igobe ea mano e da Lia amoma lai iligaga fi idi da33agoane. ");
INSERT INTO beo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Amola Ya:igobe ea mano eno amoGa:de. Ga:de egefelali da Sifone, Ha:gai, Sinunai, Esebone, Ilai, A:ilode amola Alilai. ");
INSERT INTO beo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ya:igobe ea mano eno amoA:sie, amola A:sie egefelali da Imina, Isua, Isuai, Bilaia amola ilia dalusi Sela. Bilaia egefela amo da Hibe amola Ma:legiele. ");
INSERT INTO beo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Amo16dedei Ya:igobe da Siliba amo udigili hawa: hamosu a:fini La:iba:ne da idiwi Lia amoma i, amoga Ya:igobe da egaga fi amo manolali 16 agoane lai. ");
INSERT INTO beo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ya:igobe idua La:isele da dunu mano aduna lalelegei, amo Yousefe amola Bediamini. ");
INSERT INTO beo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Idibidi sogega, Yousefeda dunu mano aduna lai amoMa:na:seamolaIfala:ime. Amo mano e da A:sena:de (Boudifela amo Hilioubalisi moilai bai bagade gobele salasu dunu amo idiwi) amoma lai. ");
INSERT INTO beo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bediamini. Bediamini egefelali da Bila, Bige, A:sabele, Gila, Na:iama:ne, Ehai, Lose, Mabimi, Habimi amola Ade. ");
INSERT INTO beo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Amo 14 da Ya:igobe egaga mano fi La:isele amoma misi. ");
INSERT INTO beo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ya:igobe egefeDa:ne amola ea mano Hiusimi. ");
INSERT INTO beo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ya:igobe egefeNa:badalai. Na:badalai egefelali da Yasiele, Gunai, Yise amola Sileme. ");
INSERT INTO beo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Amo dunu fesuale dedei Ya:igobe da Biliha udigili hawa: hamosu a:fini amo La:iba:ne da idiwi La:isele amoma i, Ya:igobe da ema lai. ");
INSERT INTO beo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ya:igobe egaga fi amo da Idibidi sogega asi ilia idi da 66 agoane. Egefe ilia uda da amo defei ganodini hame idi. ");
INSERT INTO beo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yousefe da Idibidi sogega dunu mano aduna lai. Amaiba:le, Ya:igobe ea fi huluane da Idibidi sogega asi amo ilia idi defei da 70 agoane. ");
INSERT INTO beo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ya:igobe da Yuda amo Yousefema bisili gousa:musa: masa:ne, asunasi. E da Yousefe amo Ya:igobe Gousiene sogega yosia:musa: misa:ne sia:i. Ilia da doaga:loba, ");
INSERT INTO beo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yousefe da ea ‘sa:liode’ fila heda:le, ea ada yosia:musa: asi. Doaga:beba:le, Yousefe da ea ada nonogone, mae yolesili dinanu. ");
INSERT INTO beo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ya:igobe da Yousefema amane sia:i, “Defea! Na da wali bogomu defele esala. Bai na da dia odagi bu ba:i, amola di da hahawane esala na dawa:.” ");
INSERT INTO beo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Amalalu, Yousefe da yolalali ilima amane sia:i, “Na da Felouma adomu. Nolalali amola na ada ea sosogo fi huluane musa: Ga:ina:ne sogega esalu, da misi dagoi, amo na da adomu. ");
INSERT INTO beo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Na da ema agoane adomu. Dilia da ohe ouligisu dunu esala. Amola dilia da dilia lai gebo huluane amola liligi huluane oule misi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Felou da dilima misa:ne sia:sea, amola dilima dili adi hawa: hamosa adole ba:sea, ");
INSERT INTO beo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ema moloiwane olelema agoane. ‘Ninia da ninia esalebe ganodini mae fisili lai gebo ouligisu. Ninia aowalalia hou defele agoane hamosa.’ Amasea, e da dili Gousiene soge ganodini hahawane fima:ne sia:mu.’ (Idibidi dunu ilia hou da ilia lai gebo ouligisu dunu ilima gilisimu higasu. Amo dawa:beba:le, Yousefe e da amo sia: sia:musa: sia:i.) ");
INSERT INTO beo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Amaiba:le, Yousefe da yolalali biyale gala amo Felouma oule asi. E da Felouma amane sia:i, “Na ada amola nolalali da Ga:ina:ne soge fisili guiguda: misi. Ilia lai gebo amola gagui liligi huluane oule misi. Ilia da wali Gousiene sogega esala.” ");
INSERT INTO beo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Amalalu, e da yolalali ili Felouma gousa:ma:ne oule misi. ");
INSERT INTO beo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Felou da ilima amane adole ba:i, “Dilia da adi hawa: hamosala:?” Ilia da bu adole i, “Ninia da ninia aowalali defele, lai gebo fi ouligisu dunu esala. ");
INSERT INTO beo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ninia soge Ga:ina:ne amoga ha:i bagade ganebeba:le, ninia lai gebo da gisi hamedafa. Amaiba:le, ninia da amo soge guiguda: fimusa: misi. Ninia da Gousiene soge amo ganodini fimusa:, nini da dima ha:giwane edegesa.” ");
INSERT INTO beo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Felou da Yousefema amane sia:i, “Dia eda amola diolalali ili da doaga:beba:le, ");
INSERT INTO beo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Idibidi soge huluane da ilia soge. Gousiene soge da Idibidi soge bisili noga:i gala. Ilia da amogai fimu da defea. Amola ilia fi amo ganodini lai gebo ouligisu dunu ida:iwane esalea, defea, amo dunu da na lai gebo ouligima:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Amalalu, Yousefe da ea ada Ya:igobe amo Felouma gousa:musa: oule misi. Ya:igobe da Felouma amane sia:i, “Gode da di hahawane dogolegele fidimu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Felou da Ya:igobema amane sia:i, “Dia lalelegele, ode habodayane esalabela:?” ");
INSERT INTO beo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ya:igobe da bu adole i, “Na da wali ode 130 amoga udigili lalu. Na aowalali da ode bagohame hahawane lalu. Be na esalebe ode da bagahame, amola se nabasu galu.” ");
INSERT INTO beo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ya:igobe da Felouma Gode e hahawane dogolegele fidima:ne amola “asigibio”, sia:nanu, yolesili asi. ");
INSERT INTO beo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Amalalu, Yousefe da fidibiba:le, ea ada amo yolalali ilia da Idibidi ganodini hahawane fi. Ilia da Felou ea sia: defele, moilai La:mesisi amo gadenene fi galu. ");
INSERT INTO beo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yousefe da ea ada amola yolalali ilima amola ea ada fi huluane amola mano fa:nodafa lalelegei, ilima ha:i manu i. Ha: Bagade ");
INSERT INTO beo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Soge huluane amo ganodini da ha: bagade ba:i. Ha:i manu hamedafa ba:i. Idibidi dunu amola Ga:ina:ne dunu huluane da ha:iba:le, gasa hame ba:i. ");
INSERT INTO beo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ilia da gagoma amola bali amo muniga lai. Amo muni Yousefe da Felou ea diasuga gaguli asi. ");
INSERT INTO beo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Muni huluane Idibidi amola Ga:ina:ne amo ganodini ebelei ba:loba, Idibidi dunu da Yousefema misini, amane sia:i, “Ninima ha:i manu ima! Nini bogogia:sa:besa:le fidima! Ninia muni da ebelei dagoi!” ");
INSERT INTO beo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yousefe da ilima bu adole i, “Dilia lai gebo oule misa. Dilia muni ebeleiba:le, na da dilia lai gebo bidi lale, ha:i manu amoga dabemu.” ");
INSERT INTO beo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Amaiba:le, ilia da ilia lai gebo amo Yousefema oule misi amola e da ilia hosi, sibi, goudi, bulamagau, dougi, amo lale, ilima ha:i manu dabe i. ");
INSERT INTO beo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Amo ode da gidigili, eno ba:loba, ilia da Yousefema misini amane sia:i “Ninia muni da ebelei dagoi amola ninia lai gebo huluane di da lai dagoi. Amo ninia da dima hame wamolegemu. Wali dima imunu liligi da hame. Ninia da:i hodo amola ninia soge fawane diala. ");
INSERT INTO beo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nini bogogia:sa:besa:le, nini fidima. Ninia soge da ha:i manu mae bugili, udigili dialumu da defea hame. Ninia da:i hodo amola ninia soge, bidi lama. Ninia da Felou ea udigili hawa: hamosu dunu esalumu amola e da ninia soge gagumu. Nini mae bogoma:ne ha:i manu ninima ima. Amola ninia sogega bu sagama:ne, hawa: bugima:ne ninima ima.” ");
INSERT INTO beo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yousefe da soge huluane Idibidi ganodini amo bidi lale, Felouma i. Ha: da gasa bagadeba:le Idibidi dunu huluanedafa da ilia soge gagumu hamedeiwane ba:i. Soge huluane da Felou ea soge fawane ba:i. ");
INSERT INTO beo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Amola Yousefe da Idibidi dunu huluanedafa, amo udigili hawa: hamosu dunu hamoi. ");
INSERT INTO beo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Soge afae afae, e da hame bidi lai. Amo da gobele salasu dunu ilia soge. Felou da ili esaloma:ne, muni ilima i. Amaiba:le, ilia da ili soge hame bidi lai. ");
INSERT INTO beo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yousefe da dunu huluane ilima amane sia:i, “Ba:ma! Na da Felouma ima:ne, dilia da:i hodo amola dilia soge bidi lai dagoi. Amo hawa: dilia sogega bu sagamusa:, amo lama. ");
INSERT INTO beo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Be ha:i manu faisu eso amoga dilia gagoma amola bali biyale fifili, afadafa Felouma ima. Eno hame i diala amo dili hawa: bugimusa:amola dilia amola dilia sosogo fi, amo moma:ne lama.” ");
INSERT INTO beo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ilia bu adole i, “Di da nini esalusu gaga:i dagoi. Di da nini noga:le fidi. Ninia Felou ea udigili hawa: hamosu dunu esalumu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Amaiba:le, Yousefe da sema hamoi, amane, ‘Idibidi soge ganodini, ha:i manu fai huluane ilia da biyale fifili, amo afadafa Felouma ima:ne sia:i. Amo sema da wali diala. Be Felou da gobele salasu dunu ilia soge fawane hame lalegagui. ");
INSERT INTO beo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isala:ili dunu da Idibidi ganodini Gousiene sogega esalu, mano bagohame lai, amola bagade gagui dunu ba:i. ");
INSERT INTO beo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ya:igobe da Idibidi soge ganodini ode 17 esalu. E da ode 147 amoga doaga:i. ");
INSERT INTO beo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ea bogomu eso gadenei ba:loba, e da eagofe Yousefe amo misa:ne sia:ne, ema amane sia:i, “Dia lobo amo na masele hagudu ligisima. Nama dafawanedafa ilegele sia:ma, amo di da na da:i hodo Idibidi soge ganodini hame uli dogomu. ");
INSERT INTO beo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Na da na aowalali amo ilia uli dogosu amo gadenene dialumu hanai galebe. Na da:i hodo di gaguli asili, ilia uli dogoi sogebi amoga na uli dogoma.” Yousefe da bu adole i, “Na da dia sia:i defele hamomu.” ");
INSERT INTO beo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ya:igobe da amane sia:i, “Gode ba:ma:ne, di da dia sia:i defele hamoma:ne dafawane ilegele sia:ma!” Yousefe da amo dafawane ilegele sia:i, amola Ya:igobe da ea dia heda:su da:iya nodoi. ");
INSERT INTO beo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Eso enoga Ya:igobe da olo madelai ba:i. Amola ilia da Yousefema adoi. Yousefe da egefe aduna amo Ma:na:se amola Ifala:ime, amo Ya:igobema oule asi. ");
INSERT INTO beo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ya:igobe da Yousefe e ba:la misi sia: nababeba:le, e da ea gasa fili, dia heda:su fafai da:iya wa:le fi. ");
INSERT INTO beo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ya:igobe da Yousefema amane sia:i, “Gode Bagadedafa da Luse soge amo ganodini nama misini amola E da na hahawane dogolegele fidima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","E da nama amane sia:i, ‘Na da dima mano bagohame imunu amola digaga lalelegei manolali da fi bagohame hamomu. Amo soge Na da dia mano fifi misi ilima imunu. Ilia da amo soge eso huluane mae fisili gagulalumu.’” ");
INSERT INTO beo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ya:igobe da eno amane sia:i, “Yousefe! Dia gofe aduna amo na da guiguda: mae misini dima lalelegei, amo da na mano. Ifala:ime amola Ma:na:se da Liubene amola Simiane amo defele, na mano gala. ");
INSERT INTO beo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Di da dunu mano eno lalelegesea, ilia da na mano defele hame ba:mu. Ilia nana liligi lamu da Ifala:ime amola Ma:na:se ela fi amoga lamu. ");
INSERT INTO beo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Na da dia ame La:isele amo dawa:beba:le agoane hamosa. Na da Mesoubouda:imia soge fisili, logoga manebeba:le, e da Efala:de moilai gadenene guiguda: Ga:ina:ne soge ganodini bogoi dagoi. E bogobeba:le, na da se bagade nabi. Na da Efala:de ahoasu logo bega: ea da:i hodo uli dogone sali.” (Efala:de ea dio da wali Bedeleheme.) ");
INSERT INTO beo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ya:igobe da Yousefe egefela ba:beba:le, amane adole ba:i, “Amo goi da nowala:?” ");
INSERT INTO beo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yousefe da bu adole i, “Amo da nagofela. Gode da Idibidi soge guiguda: amo ganodini, amo mano nama i dagoi.” Ya:igobe da amane sia:i, “Ela nama oule misa! Na da elama Gode da ela hahawane dogolegele fidima:ne sia:mu.” ");
INSERT INTO beo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ya:igobe da da:i hamoiba:le, ea si da wadela:i galu. E da noga:le ba:mu gogolei. Yousefe da amo goi aduna ema oule misini, e da ela ouga:ne nonogoi. ");
INSERT INTO beo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ya:igobe da Yousefema amane sia:i, “Na da dia odagi bu hame ba:mu dawa:i galu. Be wali Gode da fidibiba:le, na da di amola dia mano ba:i dagoi.” ");
INSERT INTO beo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Amalalu, Yousefe da ea mano aduna Ya:igobe ea masele da:iya fene esalu amo lale, e da beguduli ea odagi osobo digila sa:i. ");
INSERT INTO beo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yousefe da Ifala:ime amo Ya:igobe ea lobo fofadi leloma:ne oule asi amola Ma:na:se amo Ya:igobe ea lobodafa amoga leloma:ne oule asi. ");
INSERT INTO beo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Be Ya:igobe da ea lobo ele gaduli giawale, ea lobodafa amo Ifala:ime (e da fa:no lalelegei mano) ea dialuma da:iya ligisi amola ea lobo fofadi amo magobo mano Ma:na:se ea dialuma da:iya ligisi. ");
INSERT INTO beo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Amalalu, e da Godema E da Yousefe hahawane dogolegele fidima:ne sia:i, amane, “Gode (na ada A:ibalaha:me amola Aisage da Ema hawa: hamosu) E da amo goi aduna hahawane dogolegele fidimu da defea. Gode da mae yolesili musa: amola wahadafa nama bisili logo olelemusa: ahoasu. ");
INSERT INTO beo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","A:igele amo da na mae se nabima:ne gaga:su, e da ela hahawane dogolegele fidimu da defea. Na dio amola na ada A:ibalaha:me amola Aisage elea dio, da amo goi ela fi ganodini dialalalumu da defea. Ilima mano bagohame lalelegemu amola iligaga fi dunu bagohame ba:mu da defea.” ");
INSERT INTO beo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yousefe da ea ada ea lobodafa amo Ifala:ime ea dialuma da:iya ligisi amo ba:loba, da:i dioi galu. Amaiba:le, e da ea ada lobodafa amo Ifala:ime dialuma fisili Ma:na:se ea dialuma da:iya ligisima:ne, gagui. ");
INSERT INTO beo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","E da ea adama amane sia:i, “Agoane hame, ada! Ma:na:se da magobo mano. Dia lobodafa ea dialuma da:iya ligisima.” ");
INSERT INTO beo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Be ea ada da amane hame hamoi. E amane sia:i, “Na gofe! Na dawa:! Ma:na:se ea lalelegemu fi amola da fi bagade hamomu. Be magobo baligia da ea hou baligimu. Egaga fi lalelegemu da baligili bagade ba:mu.” ");
INSERT INTO beo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Amaiba:le, amo esoga, Ya:igobe da elama Gode da hahawane dogolegele fidima:ne ilegele sia:i dagoi. E amane sia:i, “Isala:ili dunu da eno dunuma Gode hahawane dogolegele fidima:ne sia:sea, ilia da alia dioba:le sia:mu. Ilia da agoane sia:mu, Gode da dilia hou afadenene, bu Ifala:ime amola Ma:na:se ela hou defele hamomu da defea.” Ya:igobe da agoane Ifala:ime bisili amola Ma:na:se fa:no ilegei. ");
INSERT INTO beo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Amalalu, Ya:igobe da Yousefema amane sia:i, “Di da waha ba:sa. Na da bogomu galebe. Be Gode da di mae fisili, dia aowalali amo ilia sogega bu oule masunu. ");
INSERT INTO beo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Siegeme soge ida:iwane gala amo na da A:moulaide dunuma gegesu gobihei bagade amola dadi amoga gegeiba:le, samogene gagulaligi. Amo soge na da diolalalima hame imunu. Na da amo dima fawane imunu.” ");
INSERT INTO beo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ya:igobe da egefe huluane misa:ne sia:ne, ilima amane sia:i, “Gadenene gilisima. Na da dilima fa:no misunu hou olelemu. ");
INSERT INTO beo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ya:igobe egefelali! Gilisima amola nabima! Dilia ada Isala:ili amo ea sia: nabima! ");
INSERT INTO beo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Liubene! Di da na magobo mano amola na gasa gala. Na da asigilaloba, di da na magobo mano lalelegei. Dia gasa da na mano huluane ilia gasa baligi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Di da gasa bagade hano neda:i agoane. Be dia hou da baligi bagade hame ba:mu. Bai di da dia eda diaheda:su fafai wadela:lesi. Di da na gidisedagi uda amola gilisili golai. ");
INSERT INTO beo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiane amola Lifai da eyalali amola olalali fi esala. Ela da ela gegesu liligi amoga gegenana, mi hanane gasa fisa. ");
INSERT INTO beo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Na da ela wamolegei sia: dasu gilisisu amoma hame gilisimu. Bai ela da ougiba:le, dunu medole lelegei amola ela da hedemusa: bulamagau gawali ili gasuga:igimusa: emo dina:fi dai. ");
INSERT INTO beo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ela ougi da gia:i bagade amola dodona:gi gala. Amaiba:le, ela ougi amoma na da gagabui aligima:ne ilegesa. Na da ela fi afafane, Isala:ili soge huluane amola Isala:ili fi huluane amo ganodini ela fi da afafane esalebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda! Diolalali ili da dima nodomu. Di da dima ha lai dunu amo ilia galogoa gagusu. Diolalali ilia da dima begudumu. ");
INSERT INTO beo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda da laione wa:me defele esala. E da ohe fi fane legelalu, hi diasuga bu asili, golai dialebe ba:sa. Dunu huluane da e didilisimusa: beda:i bagade. ");
INSERT INTO beo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda da Hina Bagadedafa amo ea dagulu gagui dagoi ba:mu. Egaga lalelegei manolali da eso huluane hina bagade dunu esalumu. Dunu fi eno da ema dabe ima:ne, gaguli misunu, amola nabasu hou hamoma:ne, ema begudumu. ");
INSERT INTO beo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","E da ea dougi amo waini efe baligili ida:iwane gala amo ilima la:gisisa. E da ea abula amo waini hano (maga:me agoane ba:sa) amo ganodini dodofesa. ");
INSERT INTO beo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","E da waini bagade nabeba:le, ea si da maga:me agoane ba:sa. E da dodo maga:me nabeba:le, ea bese da ahea:iai agoane ba:sa. ");
INSERT INTO beo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebiulane da hano wayabo bagade bega: esalumu. Dusagai bagade da ea hano bega: hahawane misunu. Ea soge da asili, ea dagomusa: alalo da Saidone moilai bai bagade ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isiga ea hou da dougi (amo da udigili ea baligiga legesu esa amo dogoa golai dialebe) ea hou hame baligisa. ");
INSERT INTO beo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Be e da helefisu soge hahawane ba:sa. Amola soge huluane da noga:idafa e da dawa:sa. Amaiba:le, e da dioi liligi gaguli masa:ne beguduli ahoa. Dunu eno da ema gasa fili logebeba:le, e da udigili hawa: hamosu dunu ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Da:ne da ea fi ilima ouligisu dunu esalumu. Ea fi dunu ilia da Isala:ili dunu fi eno amo defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Da:ne da gasonasu sa:ya:be amo da logo bega: dialebe agoane ba:mu. Amo sa:ya:be da hosi ea emo gufi gasonasea, dunu da hosi da:iya fila heda:i da baligidudili dafamu. ");
INSERT INTO beo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Hina Gode! Na da Dia gaga:sudafa ba:ma:ne ouesala. ");
INSERT INTO beo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ga:de! Wamolasu dunu gilisisu da Ga:dema doagala:musa: misunu. Be Ga:de da sinidigili ili se bobogemu. ");
INSERT INTO beo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","A:sie ea soge amoga ha:i manu ida:iwane ba:mu. E da ha:i manu hina bagade dunu moma:ne defele, amo sagale faimu. E da sagale nasu dunu noga:iwane ba:mu. ");
INSERT INTO beo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Na:badalai da ‘dia’ ohe fi amo da udigili hehenane lala, amo defele ba:sa. Amo ‘dia’ da mano ida:iwane lalelegesa. ");
INSERT INTO beo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yousefe da udigili lalebe dougi amo da gufi hano gadenene esalebe agoane ba:sa. Amola udigili lalebe hosi mano agologa esalebe agoane ba:sa. ");
INSERT INTO beo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ema ha lai dunu da nimiwane ema doagala:musa: mabe. Ilia da dadiga gala:musa: ema se bobogesa. ");
INSERT INTO beo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Be e da ea dadi mae yaguguiwane gagusa. Amola Ya:igobe ea Gode Bagadedafa da Ea Gasaga ea loboga gasa iaha. Gode da Isala:ili fi ilima Fidisu amola Sibi Ouligisu esala. ");
INSERT INTO beo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Dia ada amo ea Gode da dima Fidisu esala. Gode Bagadedafa da dima hahawane dogolegele fidilala amane. Gibu da gadodili osoboa daha. Gufi hano da osobo hagudu gala. Di da bulamagau bagohame amola mano bagohame gala. Amo da Gode Ea dima hahawane dogolegele fidisu. ");
INSERT INTO beo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Eno da fage (widi, bali, gagoma, naisi) amola sogea amola hahawane dogolegele fidisu E da dima iaha da musa: hemonega hamoi goumi amola liligi ida:iwane gala amo mae mugululi dialalalumu agolo ganodini gala. Yousefe da amo hahawane dogolegele fidisu hou ba:ma:ne, na da Godema sia:ne gadosa. Yousefe ea hou da hisuba:le, e da yolalali ilima afafai dagoi ba:sa. ");
INSERT INTO beo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bediamini da gasonasu wa:me (wufi) defele esala. Hahabe amola daeya, e da fane legesa amola gasonaha.” ");
INSERT INTO beo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Gadodili dedei da Isala:ili fi fagoyale galu. Amo sia: dedei da Ya:igobe ea fada:i sia:, ea bogomu gadenenanoba, ea mano afae afae ilima asigibio sia:ma:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ya:igobe da egefe ilima amane sia:i, “Na da wali bogole, na aowalali ilima gilisimu. Amaiba:le, na da:i hodo dilia na eda ilia uli dogosu amo gele gelabo amo Ifalone (Hidaide dunu) ea ifabi ganodini diala, amoga na da:i uli dogone salima. ");
INSERT INTO beo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Amo soge da Ma:gafila amo Ga:ina:ne soge ganodini amola Ma:melei moilaiga eso maba gusudili amoga diala. A:ibalaha:me da amo gele gelabo, ifabi amola bogoi uli dogosu hamoma:ne, Ifalonema bidi lai dagoi. ");
INSERT INTO beo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Amogai ilia da A:ibalaha:me amola idua Sela uli dogone sali. Amogai ilia da Aisage amola idua Lebega uli dogoi. Amola amogai na da Lia uli dogone sali. ");
INSERT INTO beo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Amo ifabi amola gele gelabo da Hidaide dunu amoga bidi lai. Amogai na da:i hodo uli dogone salima.” ");
INSERT INTO beo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ya:igobe da egefe ilima ea fada:i sia: huluane dagoloba, e da diaguduli, bogoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yousefe da ea adama ouga:nana sa:ili dinanu. E da ea ada odagi dinanuwane nonogosu. ");
INSERT INTO beo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Amalalu, Yousefe da hawa: hamosu dunu ilima amo ea ada da:i hodo, hedolo hame dasama:ne, gabusiga: manoma legema:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ilia hou defele, eso40amoga ilia da ea da:i hodo mae dasama:ne hahamoi. Idibidi dunu da eso 70 amoga Ya:igobema asigiba:le didigia:i. ");
INSERT INTO beo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Didigia:su eso da dagoloba, Yousefe da Felou ea eagene ouligisu dunu ilima amane sia:i, “Amo sia: dili Felouma adosima, ");
INSERT INTO beo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Na ada ea bogomu da gadenenoba, e da nama na da ea da:i hodo amo uli dogoi Ga:ina:ne soge ganodini hi hahamoi, amogai na da e uli dogoma:ne sia:i. Na da amo hamoma:ne ilegele sia:i dagoi. Amaiba:le, na da na ada uli dogomusa: asili, amalu bu sinidigimu da defeala:?’” ");
INSERT INTO beo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Felou da bu adole i, “Defea! Dia sia:i defele, dia ada uli dogone salimusa: masa.” ");
INSERT INTO beo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Amalalu, Yousefe da ea ada uli dogomusa: asi. Felou ea eagene ouligisu dunu huluane, ea hina fi huluane, amola Idibidi asigilai bagade dunu huluane, ilia da Yousefe sigi asi. ");
INSERT INTO beo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yousefe ea fi huluane, yolalali amola ea ada fi huluane da Yousefe sigi asi. Ilia mano fonobahadi, ilia sibi, goudi amola bulamagau, amo fawane da Gousiene sogega ouesalu. ");
INSERT INTO beo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Dunu eno da ‘sa:liode’ fila heda:le, Yousefe sigi asi, amola eno da hosi fila heda:le asi. Gilisisu da bagadedafa ba:i. ");
INSERT INTO beo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ilia da gala:ine dadabisu soge (amoga ilia da widi amola bali gisi fabeba:le fage lasu) amo A:ida:de (Yodane Hano amoga gusudili diala) amoga doaga:loba, ilia da mae fisili didigia:lalu. Eso fesuale, Yousefe da didigia:su gilisisu hou ouligi. ");
INSERT INTO beo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ga:ina:ne fi dunu da amo didigia:su hou A:ida:de sogebi ganodini hamonanebe ba:loba, ilia da amane sia:i, “Idibidi dunu da da:i dione didigia:su bagade hamonanebe goea.” Amaiba:le, ilia da amo sogebi amoma dio asuli amo A:ibele Misala:ime. (Idibidi didigia:su) ");
INSERT INTO beo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Amalalu, Ya:igobe egefelali da ea hamoma:ne sia:i defele hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ilia da ea da:i hodo gaguli asili, Ma:gafila gele gelabo (Ma:melei moilaiga gusudili ifabi, amo A:ibalaha:me da ea fi uli dogomusa: amo Ifalone Hidaide dunuma bidilai) amo ganodini uli dogoi. ");
INSERT INTO beo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yousefe da ea ada uli dogolalu, e amola yolalali amola dunu huluane da ea ada uli dogomusa: Yousefe sigi asi, amo huluane da Idibidi sogega buhagi. ");
INSERT INTO beo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ilia ada bogosu amo fa:no, Yousefe yolalali ili amane sia:i, “Yousefe da ninima higasala:? Ninia da ema se bagade iasu. E da ninima dabe ima:bela:?” ");
INSERT INTO beo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Amaiba:le, ilia da sia: adole iasu dunu amoga Yousefema amane adosi, “Ninia ada mae bogole, ");
INSERT INTO beo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","e da ninima nini da dima amane adole ba:ma:ne sia:i, ‘Diolalali ilia da dima wadela:le bagade hamoi. Be wali na da dima edegesa. Dia ili wadela:i hou gogolema:ne olofoma.’ Ninia da nini ada ea Gode hawa: hamosu dunu esala. Amaiba:le, dia nini wadela:i hou gogolema:ne olofoma.” Amo sia: adosi Yousefe da nababeba:le, bagadewane dinanu. ");
INSERT INTO beo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Amalalu, yolalali ilisu da ema misini, ema beguduli amane sia:i, “Ninia da dia hawa: hamosu dunu esalebe wea.” ");
INSERT INTO beo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Be Yousefe da bu adole i, “Mae beda:ma! Na da Gode Ea sogebi lamu da hamedei galebe. ");
INSERT INTO beo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Dilia da nama wadela:le hamomusa: dawa:i. Be Gode da amo hou afadenene, bu hou ida:iwane hamosu. Bai E da dunu bagohame waha esalu amo ilia esalusu gaga:musa: dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Dilima beda:ma:ne liligi da hamedafa gala. Na da dili amola dilia mano asigiwane ouligimu.” Amaiba:le, ilia da ea asigi sia: nabalu, ilia dogo da bu denesi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yousefe amola ea ada fi da Idibidi soge ganodini esalalalu, e da lalelegele, ode 110 esalu bogoi. ");
INSERT INTO beo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ea esalusu ganodini, e da Ifala:ime ea mano amola ea aowa ba:i dagoi. E da Ma:na:se ea mano Ma:igili, amo ea mano yosia:i. ");
INSERT INTO beo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","E da yolalalima amane sia:i, “Na da gadenene bogomu galebe. Be mae beda:ma. Gode da dili noga:le ouligimu. E da dili amo sogega fisili masa:ne gadili oule asili amola soge amo E da A:ibalaha:me, Aisage amola Ya:igobe ilima ima:ne dafawane ilegele sia:i, E da amo soge dilima imunu.” ");
INSERT INTO beo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Amalalu, Yousefe da ea fi dunuma amane sia:i, “Dilia dafawanedafa amane ilegele sia:ma, amane, Gode da dilia amo sogega oule ahoasea, dilia na da:i hodo amoga gaguli masa:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Amalalu, Yousefe da Idibidi soge ganodini bogoi dagoi. E lalelegele, ode 110 defele gidigili, bogoi. Amalalu, ilia da ea da:i hodo mae dasama:ne manoma legelalu, bogoi gagili ganodini sali. Sia: Ama Dagoi ");
INSERT INTO beo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ya:igobe egefelali ilia da e gilisili Idibidi sogega asi ilia dio da, ");
INSERT INTO beo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Liubene, Simiane, Lifai, Yuda, ");
INSERT INTO beo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isiga, Sebiulane, Bediamini, ");
INSERT INTO beo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Da:ne, Na:fadalai, Ga:de amola A:sie. ");
INSERT INTO beo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ya:igobe egaga fi huluane ilia idi da 70. Egefe Yousefe da Idibidi ganodini esalu. ");
INSERT INTO beo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ode da asili, Yousefe amola yolalali da bogoi. Amola eno dunu huluane ili defele lalelegei da bogoi. ");
INSERT INTO beo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Be iligaga fi (Isala:ili fi dunu) da mano bagohame lalelegei. Ilia idi da bagade heda:i amola ilia da gasa fi agoane ba:i. Idibidi soge da Isala:ili dunu amoga nabaiwane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Amalalu, Felou gaheabolo da Idibidi soge ganodini hina bagade esalebe ba:i. E da Yousefe hame dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","E da ea fi ilima amane sia:i, “Wali Isala:ili dunu da bagohame amola gasa bagade ba:sa. Ilia da ninima hasalasimu agoai galebe. ");
INSERT INTO beo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ninima ha lai dunu da ninima doagala:sea, Isala:ili dunu da ninima ha lai dunu gilisisa:besa:le amola Idibidi yolesili hobeasa:besa:le, ninia ili idi amo fonoboma:ne logo hogomu da defea. ");
INSERT INTO beo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Amaiba:le, Idibidi dunu da gasa fi ouligisu dunu Isala:ili dunu udigili gasa bagade hawa: hamosu hamoma:ne ilima asunasi. Isala:ili dunu da moilai bai bagade aduna amo Bidome amola La:misisi gagui. Amo moilai bai bagade aduna da Felou ea liligi ligisisu agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Idibidi dunu da Isala:ili dunu fi baligili se nabasu i. Be Isala:ili fi da hame fonoboi. Ilia bu baligili heda:i amola Idibidi soge huluane amoga fi bagade ba:i. ");
INSERT INTO beo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Idibidi dunu da Isala:ili dunuma beda:i galu. Amaiba:le, ilia da Isala:ili dunu se nabima:ne, ilima gasa fi hamone, ili da udigili hawa: hamosu dunu ba:i. Idibidi fi da Isala:ili dunu ilia diasu gaguma:ne amola ifabi hawa: hamoma:ne logei. Ilia da Isala:ili dunuma hamedafa asigisu. ");
INSERT INTO beo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Amalalu, Idibidi Felou da Sifala amola Bua (amo da mano lasu fidisu uda aduna ela da Hibulu uda fidisu) elama amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Alia da Hibulu uda ilia mano lalelegesu hou fidisia, mano lai da dunu mano ba:sea, amo fanelegema. Be uda mano ba:sea, mae fanelegema.” ");
INSERT INTO beo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Be mano lasu fidisu uda da Godema dawa:i. Amaiba:le, ela da Felou ea sia: hame nabi. Ela da dunu mano hame fanelegei. ");
INSERT INTO beo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Amaiba:le, Felou da mano lasu fidisu uda ema misa:ne sia:ne, elama amane sia:i, “Alia da abuliba:le agoane hamosala:? Abuliba:le dunu mano hame fanelegesala:?” ");
INSERT INTO beo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ela da bu adole i, “Hibulu uda da Idibidi uda defele hame hamosa. Ilia mano da hedolowane lalelegesa. Ania da mae doaga:le, ilia mano da lalelegei dagoi ba:sa.” ");
INSERT INTO beo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Mano lasu fidisu uda da Godema beda:iba:le, Gode da ela hahawane ba:i. Gode da elama sosogo fi mano i dagoi. Isala:ili dunu ilia idi da bu bagade heda:i amola ilia gasa bagade fi agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Amo ba:beba:le, Felou da ea fi dunu huluane ilima hamoma:ne sia:i hamoi dagoi. E amane sia:i, “Dilia Hibulu dunu mano gaheabolo lalelegei ba:sea, amo lale, Naile hano amoga bogoma:ne ha:digima. Uda mano fawane mae fanelelegema.” ");
INSERT INTO beo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Amo esoga, Lifai fi dunu afae da Lifai fi a:fini lai. ");
INSERT INTO beo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Amo uda da ema dunu mano lalelegei. E da ea mano da noga:i mano ba:beba:le, e da oubi udiana amoga mano wamolegei. ");
INSERT INTO beo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Be bu wamolegemu hamedei ba:loba, e da daba saga: amoga amuni lale, hano da amoga mae ha:ina sa:ima:ne edele amoga legei. E da ea mano amo ganodini sanasili, Naile hano bega: saga: sedade amo ganodini ligisi. ");
INSERT INTO beo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mano dudubu ea dalusi da fonobahadi sedagawane fa:no misunu hou ba:musa: lelu. ");
INSERT INTO beo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Felou idiwi da hano ulimusa: misi. Ea hawa: hamosu a:fini ilia da hano bega: lalu. E da daba amo saga: ganodini dialebe ba:i. E da ea udigili hawa: hamosu a:fini afae amo lama:ne asunasi. ");
INSERT INTO beo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Felou idiwi da daba ea figisu doagadole, dunu mano dudubu ganodini dialebe ba:i. E da dinanu amola Felou idiwi da e asigili ba:i. E amane sia:i, “Amo da Hibulu mano esala.” ");
INSERT INTO beo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Amalalu, amo mano dudubu ea dalusi da Felou idiwi ema amane adole ba:i, “Na da Hibulu uda amo di fidima:ne, amo manoma dodo ima:ne misa:ne sia:mu da defeala:? ");
INSERT INTO beo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Felou idiwi da bu adole i, “Defea! Amo misa:ne sia:ma.” Amalalu, mano ea dalusi da asili, mano dudubu hi amedafa ema oule misi. ");
INSERT INTO beo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Felou idiwi da amo udama amane sia:i, “Di amo mano dudubu lale, nama bu imunusa: ouligima. Na da dima bidi imunu.” Amalalu, e da mano dudubu lale, dodo ianu. ");
INSERT INTO beo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Fa:no, mano da fonobahadi asigilaloba, ea ame da e Felou idiwima bu oule asi. Amalalu, e da amo mano fofoi dagoi. E da hima adole i, “Na da amo mano hano ganodini dialu lai. Amaiba:le, na da ema Mousese dio asula.” (Mousese dawa:loma:ne Idibidi sia:ga da ‘lalelegei’ amola Hibulu sia:ga da ‘ganodini dialu lai.’) ");
INSERT INTO beo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mousese da asigi laloba, e da ea fi dunu (Hibulu dunu) amo ba:musa: sofe asi. E da Idibidi dunu da ilima gasa fili, hawa: hamosu gasa bagade ilima i, amo ba:i dagoi. Amola Idibidi dunu afae e da Mousese ea fi Hibulu dunu amo fanelegei dagoi, amo Mousese da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mousese da la:idi ba:lega, la:idi ba:lega hogolalu, dunu eno hame ba:beba:le, e da amo Idibidi dunu fanelegele, ea da:i hodo wamolegemusa:, sa:i boso amoga uli dogone sali. ");
INSERT INTO beo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Aya esoga, e da bu asili, Hibulu dunu aduna gegenanebe ba:i. E da giadofale hamoi dunuma amane sia:i, “Dia da abuliba:le dia Hibulu na:iyado fananala:?” ");
INSERT INTO beo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Amo dunu da bu adole i, “Di da ninia fofada:su dunu amola ouligisu dunu, nowa da hamobela:? Di da aya Idibidi dunu medole legei amo defele na amola medole legema:bela:?” Amalalu, Mousese da beda:i ba:i. E da ea dogo ganodini amane sia:i “Dunu huluane da na hamoi dawa: dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Felou da amo hou nababeba:le, e da Mousese fanelegema:ne sia:i, be Mousese da hobeale asili, Midia:ne sogega wamoaligimusa: asi. Eso afaega, Mousese da hano nasu uli dogoi gadenene esalu. Yedelou (Midia:ne gobele salasu dunu) amo ea uda mano fesuale gala da ilia ada ea sibi amola goudi, hano nasu ofodoga nabama:ne, hano dimusa: misi. ");
INSERT INTO beo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Be sibi ouligisu dunu eno da Yedelou ea uda manolali sefasi. Amalalu, Mousese da ili gaga:musa: misini, ilia lai gebo amoma ima:ne hano dili i. ");
INSERT INTO beo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ilia da ilia adama bu misini, e fofogadigili ilima amane, adole ba:i, “Dilia da habodane hedolo bu misibala:?” ");
INSERT INTO beo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ilia da bu adole i, “Sibi ouligisu dunu da nini sefasisia, Idibidi dunu afae da nini gaga:i dagoi. Amola e da ninia lai gebo moma:ne, hano dili i.” ");
INSERT INTO beo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yedelou da ea idiwi amoma amane adole ba:i, “E da habila:? Dilia da abuliba:le e gadili leloma:ne yolesila:? Masa! E da nini gilisili ha:i manusa: misa:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Amaiba:le, Mousese da Midia:ne soge ganodini esalumusa: dawa:i galu. Amalalu, Yedelou da idiwi Siboula e lama:ne Mousesema i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Siboula da ema dunu mano lalelegei. Mousese da ea dogo ganodini amane sia:i, “Na da amo soge ganodini ga fi esala. Amaiba:le, amo manoma na da Gesiome (ga fi dunu) dio asula.” ");
INSERT INTO beo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ode eno ilia da gidigili, Idibidi hina bagade (Felou) da bogoi. Be gasa bagade udigili hawa: hamosu hamobeba:le, Isala:ili dunu da gogonomane, Gode fidima:ne dinanawane wesu. ");
INSERT INTO beo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Gode da ilia dinanawane wesu nabi dagoi. E da Ea gousa:su, amo E da A:ibalaha:me, Aisage amola Ya:igobe ilima hamoi bu dawa:i. ");
INSERT INTO beo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","E da Isala:ili dunu amo ilia se nabawane udigili hawa: hamosu ba:i dagoi. Amola E da ilima bagade asigisu. ");
INSERT INTO beo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Eso afaega, Mousese da Yedelou (Midia:ne gobele salasu dunu) amo ea sibi amola goudi ouligisa esalu. E da amo lai gebo gilisisu wadela:i hafoga:i soge amoga oule asili, hadigi goumi amo Sainai, amoga doaga:i. ");
INSERT INTO beo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Amogai, Hina Gode Ea a:igele dunu da lalu gona:su agoane hamoi, ifa fonobahadi ganodini dialebe ba:i. Mousese da amo ifa laluga nenanu be hame nei dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","E da fofogadigili amane dawa:i “Amo ifa laluga nenanebe abuliba:le nei dagoi hame ba:sala:? Na da gadenene ba:la masunu.” ");
INSERT INTO beo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Hina Gode da Mousese gadenene manebe ba:loba, E da ifa fonobahadi amo ganodini lelu, amoga amane sia:i, “Mousese! Mousese!” Mousese da bu adole i, “Na da wea!” ");
INSERT INTO beo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Gode amane sia:i “Bu gadenene mae misa. Dia emo salasu fadegama. Bai di da hadigi osobo amo da:iya lela. ");
INSERT INTO beo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Na da dia aowalali amo A:ibalaha:me, Aisage amola Ya:igobe ilia Gode esala.” Amaiba:le, Mousese da Gode Ea odagi ba:mu bagade beda:iba:le, ea odagi dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Amalalu, Hina Gode da amane sia:i, “Idibidi dunu da mae asigili Na fi dunuma gasa fi hamonana, amo Na da ba:i dagoi. Ilia da ilia hame asigi udigili hawa: hamosu ouligisu dunu iliba:le gaga:ma:ne Nama wesu, Na da nabi dagoi. Na da ilia se nabasu huluane dawa:. ");
INSERT INTO beo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Amaiba:le, Na da ili Idibidi dunuma gaga:musa: misi dagoi. Na da Na fi amo Idibidi soge ganodini esala amo fisili masa:ne gadili hiougili, soge bagade noga:idafa amoga asunasimu. Amo soge ganodini wali dunu fi esala da Ga:ina:ne dunu fi, Hidaide dunu, A:moulaide, Belesaide, Haifaide amola Yebusaide, amo fi esala. ");
INSERT INTO beo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Na da dafawane Na fi ilia dinana wele sia:be nabi dagoi. Amola Idibidi fi da ilima banenesili hamonana Na da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Na da wali di Felouma asunasimu. Bai di da Na fi bisili Idibidi soge fisili masa:ne gadili oule masunu. ");
INSERT INTO beo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Be Mousese da Godema amane sia:i, “Na da hamedei dunu agoane. Na da habodane Felouma asili Isala:ili dunu Idibidi sogega gadili oule masa:bela:? ");
INSERT INTO beo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Gode da bu adole i, “Na ani esalumu. Di da Na fi dunu Idibidi sogega gadili oule asili, di da guiguda: goumia Nama nodone sia:ne gadomu. Amo hou da Nisu da di asunasi dagoi dawa:digima:ne olelesu dialebe ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Be Mousese da bu adole i, “Na da Isala:ili dunu ilima ahoasea amola ilima amane sia:sea, ‘Ninia aowalalia Gode da na asunasi,’ ilia da nama amane adole ba:mu, ‘Ea Dio da nowala:?’ Amaiba:le, na da ilima adi adole ima:bela:?” ");
INSERT INTO beo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gode da amane sia:i. “Na da Nisu Esala amola Esalu amola Esalumu. Di Isala:ili dunuma adoma, Dunu Ea Dio da “Na da Na” (dawa:loma:ne da “Na da Esala amola Esalu amola Esalumu”) E da na dilima asunasi dagoi.” Amola Gode da eno amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","“Ilima amane adoma, ‘Na, Hina Gode, ilia aowalalia Gode, A:ibalaha:me, Aisage amola Ya:igobe ilia Gode, da di ilima asunasi dagoi. Amo da Na Dio eso huluane mae fisili dialumu. Iligaga fi huluane fa:no lalelegesea da amo Dio Nama sia:mu. ");
INSERT INTO beo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Masa! Isala:ili dunu fi ouligisu dunu huluane gilisima. Ilima amo Na, Hina Gode, ilia aowalalia Gode, A:ibalaha:me, Aisage amola Ya:igobe ilia Gode, da dima misi dagoi, amo adoma. Ilima amane adoma, Na da ilima misini amola Idibidi fi ilima banenesisu hamosu huluane Na da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Na da ili Idibidi soge ganodini se nabawane esala, amoga fisili masa:ne gadili hiougimu. Amasea, Na da soge noga:idafa, fedege agoane amo ganodini dodo maga:me amola agime hano da hano agoane a:i ahoa, (amo ganodini wali Ga:ina:ne dunu, Hidaide dunu, A:moulaide dunu, Belesaide dunu, Haifaide dunu amola Yebusaide dunu wali amogai esala), amo sogega Na da Isala:ili dunu fi oule masunu. ");
INSERT INTO beo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Na fi dunu da dia sia: nabimu. Amasea, di da Isala:ili fi ouligisu dunu amo Felouma oule masa. Ema amane sia:ma, ‘Hina Gode, Hibulu dunu ilia Gode, da ninima misi dagoi. Di wali ninia logo doasima. Ninia da wadela:i hafoga:i soge, amoga eso udiana ahoasea, ninia Hina Godema gobele salasu hou hamomusa:gini masunu galebe. ");
INSERT INTO beo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Be Idibidi hina bagade (Felou) da dilia logo hame doasimu. Na da ema gasa bagade logebeba:le fawane e da dilia logo doasimu. ");
INSERT INTO beo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Amaiba:le, Na da Idibidi dunuma Na gasa bagade hou olelemu. Na da Idibidi fi ilima se bagade imunu. Musa: hame ba:i beda:su liligi ilima olelemu. Amasea, dilia ga masa:ne, e da dilia logo doasimu. ");
INSERT INTO beo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Na da hamobeba:le, Idibidi dunu da dilima nodomu. Amasea, Na fi dunu da gadili ahoasea, ilia da mae gaguiwane hame masunu. ");
INSERT INTO beo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Be Isala:ili uda huluane da ilia Idibidi gadenene fi amola Idibidi uda ilia diasuganodini esala, amoma asili, abula, gouli amola silifa amo edegemusa: masunu. Amasea, amo liligi ilia da ilia dunu mano amola uda mano ilima imunu. Amasea, ilia da Idibidi ilia noga:i gagui liligi gadili gaguli masunu,” Gode da amane sia:i. ");
INSERT INTO beo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Amalalu, Mousese da Hina Godema amane adole i, “Be Isala:ili dunu da na sia: dafawaneyale hame dawa:sea amola na sia: hame nabasea, na da adi hamoma:bela:? Ilia da Di da nama hame misi amo sia:sea, na da adi hamoma:bela:?” ");
INSERT INTO beo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Amaiba:le, Hina Gode da ema amane adole ba:i, “Dia loboga gagui da adila:?” E bu adole i, “Amo da dagulu.” ");
INSERT INTO beo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Hina Gode da amane sia:i, “Amo dagulu osoboga ligia guduma!” Mousese da ligia guduli, dagulu da afadenene bu sa:ya:be hamoi. Amalalu, Mousese da beda:iba:le amoga hobea:i. ");
INSERT INTO beo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Amalalu, Hina Gode da Mousesema amane sia:i, “Defea! Dia lobo ligia guduli, sa:ya:be ea la:go gaguli gaguia gadoma.” Amaiba:le, Mousese da ea lobo ligia guduli, sa:ya:be gaguli, sa:ya:be da bu afadenene dagulu ba:i. ");
INSERT INTO beo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Hina Gode da amane sia:i, “Di da Isala:ili dunu ba:ma:ne amo hou hamoma. Ilia da Hina Gode amo ilia aowalalia Gode, A:ibalaha:me, Aisage amola Ya:igobe ilia Gode, da dima misi dagoi, ilia da amo dafawaneyale dawa:ma:ne amo hou hamoma.” ");
INSERT INTO beo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Hina Gode da Mousesema eno amane sia:i, “Dia lobo amo dia abula ganodini wamo salima.” Mousese da Gode Ea sia:i defele hamoi. E da ea lobo bu duga:le, amo da aiya bagade moloba: agoai ba:i. (‘lebelosi’ oloi). ");
INSERT INTO beo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Amalalu, Hina Gode da amane sia:i, “Dia lobo bu dia abula ganodini wamo salima.” E da agoane hamoi. E lobo bu duga:le, aiya huluane da bahoi dagoi ba:i amola ea lobo gadofo da ea da:i hodo eno defele ba:i. ");
INSERT INTO beo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Hina Gode da amane sia:i, “Ilia da dia hidadea hamoi musa: hame ba:su hou amo dafawaneyale hame dawa:sea, ilia da amo hou ba:sea, dia sia: dafawaneyale dawa:mu. ");
INSERT INTO beo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Be ilia amo musa: hame ba:su hou aduna ba:sea, dia sia: dafawaneyale hame dawa:sea, defea, Naile Hano amoga hano lale, hafoga:i osoboga sogadigima. Amasea, hano da afadenene, bu maga:me hamoi dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Be Mousese da amane sia:i, “Hame mabu, Hina! Dia na mae asunasima! Na da sia: noga:le adole imunu hame dawa:. Di da nama sia:beba:le, na hou da hame afadenei. Na sia: da noga:i hame, dioi bagade gala.” ");
INSERT INTO beo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Be Hina Gode da ema bu adole i, “Nowa da osobo bagade dunuma lafi iahabela:? Nowa da dunu ge ga:i o sia: hamedei hamosala:? Nowa da dunu ba:ma:ne si iaha o mae ba:ma:ne si dofosala:? Amo da Ni fawane. Na fawane da Hina Gode! ");
INSERT INTO beo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Di wali masa! Na da dia sia: fidimu amola di adole ima:ne, Na da dima sia: imunu.” ");
INSERT INTO beo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Be Mousese da bu adole i, “Hame mabu, Hina! Eno dunu asunasima.” ");
INSERT INTO beo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Amo sia: nababeba:le, Hina Gode da Mousesema ougi galu. E amane sia:i, “Defea! Dia ola Elane (Lifai fi dunu) amo dawa:ma. Ea sia: da noga:iwane Na dawa:. E da wali di yosia:musa: logoga manebe. E da di hahawane ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Di sia:musa: dawa:i, amo ema sia:ma. Na da alia sia:be amo fidimu amola ali da eno dunu olelema:ne, alima sia: olelemu. ");
INSERT INTO beo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","E da dia lafi defele esalebe ba:mu. E da Isala:ili dunu ilima dia sia: olelemu. Amasea, di da Hina Gode defele, e da sia: adole imunusa: ema olelemu. ");
INSERT INTO beo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Di ahoasea, amo dagulu gaguli masa. Di da amo daguluga musa: hame ba:su hou hamomu.” ");
INSERT INTO beo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Amalalu, Mousese da esoa: Yedelouma asili, amane sia:i, “Na da na fi Idibidi soge ganodini amo ilia hou ba:la masunu da defeala:?” Yedelou da defea sia:ne, Mousesema hahawane ‘asigibio’ sia:i. ");
INSERT INTO beo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mousese da Midia:ne soge ganodini esaloba, Hina Gode da ema amane sia:i dagoi, “Dia Idibidi sogega buhagima. Dunu huluane da di fanelegemusa: dawa:i amo da bogoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Amaiba:le, Mousese da idua amola egefe aduna amo dougi amoga fila heda:ma:ne hamone, Idibidi sogega doaga:musa: oule asi. Mousese da dagulu amo Gode da gaguli masa:ne sia:i, amo gaguli asi. ");
INSERT INTO beo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Hina Gode da bu Mousesema amane sia:i, “Di da wali Idibidi sogega buhagimuba:le, di da Idibidi hina bagade (Felou) ba:ma:ne, musa: hame ba:su hou dia hamoma:ne Na da dima gasa i, amo huluane hamoma. Be na da Felou ea dogo igi agoane hamomu. Amaiba:le, e da Na fi dunu ilia gadili masunu logo hame doasimu. ");
INSERT INTO beo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Amasea, di da ema amane sia:ma, ‘Hina Gode da amane sia:sa; Isala:ili da Na magobo mano. ");
INSERT INTO beo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Na da dima nagofe Nama nodone sia:ne gadomusa: gadili masa:ne, logo doasima:ne sia:i. Be di da higa:i galu. Amaiba:le, Na da wali dia magobo dunu mano fanelegemu.’” ");
INSERT INTO beo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mousese da Idibidiga doaga:musa: logoga ahoanoba, sogebi afae amogai ouesalu golai. Amogai, Hina Gode da ema misini, Mousese fanelegemusa: dawa:i. ");
INSERT INTO beo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Be Mousese idua Siboula da debesu sua:ne, egefe gadofo damuni, amo Mousese ea emo da:iya ligisi. Gadofo damusu hou dawa:beba:le, e da Mousesema amane sia:i, “Di da nama maga:me egoa agoane galebe!” Amaiba:le, Hina Gode da Mousese hame fanelegei. ");
INSERT INTO beo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Be Hina Gode da Elanema amane sia:i dagoi, “Di wadela:i hafoga:i soge amoga masa. Amogai, di Mousese gousa:ma.” Amaiba:le, e da hadigi goumi (Sainai Goumi) amogai Mousese gousa:i. E da Mousese gousa:le, nonogoi. ");
INSERT INTO beo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Amalalu, Mousese da Hina Gode ea adoi huluane (E da Idibidi sogega buhagima:ne sia:i) amo Elanema olelei. Amola musa: hame ba:su hou Hina Gode da e hamoma:ne sia:i, amo Elanema olelei. ");
INSERT INTO beo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Amaiba:le, Mousese amola Elane ela da Idibidi sogega asi. Amogai, ilia da Isala:ili ouligisu dunu huluane gilisi. ");
INSERT INTO beo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Elane da ilima hou huluane Hina Gode da Mousesema sia:i amo ilima olelei. Dunu huluane ba:ma:ne, Mousese da musa: hame ba:su hou huluane hamosu. ");
INSERT INTO beo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Amalalu, Isala:ili dunu fi da dafawaneyale dawa:i. Ilia Hina Gode da ilima misi dagoi amola ilia se nabasu huluane E da ba:i dagoi, amo dafawaneyale dawa:i. Amo dawa:beba:le, ilia da beguduli, Godema nodone sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Amalalu, Mousese amola Elane da Felouma misini, ema amane sia:i, “Hina Gode da amane sia:sa, ‘Na fi dunu ga masa:ne, ilia logo doasima. Ilia da Nama nodone sia:ne gadomusa:, wadela:i hafoga:i soge ganodini hahawane gilisisu hamomu galebe.’” ");
INSERT INTO beo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Felou da bu adole i, “Hina Gode da nowala:? Na da abuliba:le Ea sia: nabalu, Isala:ili dunu udigili ahoanoma:ne logo doasima:bela:? Na da Hina Gode hame dawa:. Isala:ili dunu ilia da hame gadili masunu.” ");
INSERT INTO beo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mousese amola Elane da amane sia:i, “Hibulu dunu ilia Gode da anima misi. Ninia da eso udiana wadela:i soge ganodini asili, Hina Godema gobele salasu hamomu hanai. Agoane hame hamosea, Hina Gode da olo bagade o gegesu bagade amoga nini fanelegemu.” ");
INSERT INTO beo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Felou da Mousese amola Elane elama amane sia:i, “Ani da abuliba:le, Isala:ili udigili hawa: hamosu dunuma ilia hawa: hamosu fisimusa: sia:sala:? Ilia bu hawa: hamomusa: sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Dilia Isala:ili fi dunu idi da Idibidi dunu ilia idi amo baligi dagoi. Amola wali alia da ilia hawa: hamosu logo damumusa: dawa:lala.” ");
INSERT INTO beo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Amo esoha Felou da Idibidi ouligisu dunu amola Isala:ili ouligisu dunu ilima amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Dilia Isala:ili dunuma ilia ga:i (osoboga hamoi igi) hamoma:ne gisi mae ima. Ilisu gisi hogola masa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Be ilia da osoboga hamoi igi idi da hame fonobomu. Ilia da waha hamosa defele hamomu. Ilia hawa: hamosu da fonobahadi fawane. Ilia da hawa: hamosu higa:iba:le, ilia da gadili ilia Godema gobele salasu hamoma:ne nama adole ba:lala. ");
INSERT INTO beo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Hawa: hamosu gasa bagade ilima olelema. Amasea, ilia da ogogosu sia: amo nabimu hamedeiwane ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Idibidi hawa: hamosu ouligisu dunu amola Isala:ili ouligisu dunu da asili, Isala:ili dunuma amane sia:i, “Felou da dilima gisi eno hame imunu sia:i. ");
INSERT INTO beo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","E da dilisu gisi hogoma:ne amola ga:i dilia waha idi defele hamoma:ne sia:sa.” ");
INSERT INTO beo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Amaiba:le, Isala:ili dunu da Idibidi soge huluane amoga gisi hogola asi. ");
INSERT INTO beo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Idibidi gasa bagade ouligisu dunu da ili musa: ga:i idi defele hamoma:ne, ilima gasa bagade hamoi. ");
INSERT INTO beo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Idibidi ouligisu dunu ilia da Isala:ili ouligisu dunu (ilima ilia hawa: hamosu ouligima:ne sia:i) amo bagade fananu. Ilia gasa fili amane sia:i, “Dilia da abuliba:le dilia musa: ga:i (osoboga hamoi igi) idi amo hame hamosala:?” ");
INSERT INTO beo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Amalalu, Isala:ili ouligisu dunu ilia da Felouma asili amane sia:i, “Hina bagade! Di da abuliba:le ninima agoane hamosala:? ");
INSERT INTO beo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ilia da ninima gisi hame iaha. Be ninia musa: ga:i idi defele hamoma:ne ilia da gasa fili sia:sa. Amola, wali ilia da nini fanana. Ninia hame, be dia fi dunu da giadofasa.” ");
INSERT INTO beo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Be Felou bu adole i, “Dilia da hawa: hamosu higa:iba:le, gadili dia Hina Godema gobele salasu hamoma:ne nama adole ba:sa. ");
INSERT INTO beo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Wali hawa: hamomusa: masa! Ninia da gisi dilima hame imunu. Be dilia musa: idi amo defele hamoma.” ");
INSERT INTO beo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Amo sia: nababeba:le, Isala:ili hawa: hamosu ouligisu dunu da bidi hamosu da Isala:ili dunuma doaga:i dagoi dawa:i galu. Bai ilia ouligisu dunu da ilia musa: hamoi defele amo hamoma:ne sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ilia da Felou ea diasu fisili gadili ahoanoba, Mousese amola Elane ili misunu ouesalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ilia da Mousese amola Elane elama amane sia:i, “Alia hamobeba:le, Felou amola ea hina ouligisu dunu da nini bagade higasa. Hina Gode da amo hou ba:i dagoi amola E da alima se imunu. Alia da amo hou hamobeba:le, alia da Idibidi dunu nini fanelegema:ne abalosu logo fodoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Amalalu, Mousese da Hina Godema sinidigili amane sia:i, “Hina Gode! Dia da abuliba:le Dia fi dunuma se nabasisala:? Dia da abuliba:le na guiguda: asunasibala:? ");
INSERT INTO beo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Na da Dia sia: Felouma olelemusa: asiba:le, e da eso huluane ilima se bagade iaha. Amola Di da ili fidima:ne hamedafa hamoi!” ");
INSERT INTO beo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Amalalu, Hina Gode da Mousesema amane sia:i, “Wali Na Felouma gasa fili logesea, e da Na fi dunu ilia logo doasimu, amo di da ba:mu. Na da e logemuba:le, e da ili ea sogega fisili masa:ne sefasimu.” ");
INSERT INTO beo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Amola Gode da Mousesema amane sia:i, “Na da Hina Gode. ");
INSERT INTO beo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Na da A:ibalaha:me, Aisage amola Ya:igobe ilima misini, ilia da Na Dio Gode Bagadedafa dawa:i galu. Be Na da Na Dio Hina Gode (Hibulu sia: Yawe) amo ilima hame olelei. ");
INSERT INTO beo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Be Na da ilima gousa:su hamoi. Ilia da Ga:ina:ne soge amo ganodini ga fi agoane esalu. Be Na da Ga:ina:ne soge huluane ilima imunu ilegele sia:i. ");
INSERT INTO beo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Idibidi dunu da Isala:ili fi amo udigili hawa: hamosu dunu hamoi dagoi. Wali Na da ilia gogonomasu amola se nabasu nabi dagoi. Na musa: gousa:su Na da bu dawa:lala. ");
INSERT INTO beo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Amaiba:le, dia Na sia: Isala:ili dunuma olelema, amane, ‘Na da Hina Gode. Na da dili gaga:mu amola dili Idibidi dunuma udigili hawa: hamosu amo fisima:ne logo doasimu. Na da Na gasa bagade lobodafa ligia gadole, ilima bagadedafa se nabasimu. Amola Na da dili gaga:mu. ");
INSERT INTO beo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Na da dili Na fi hamomu amola Na da dilia Gode esalumu. Na da dilia Idibidi soge ganodini udigili hawa: hamosu amo logo doasisia, dilia da Na da Hina Godedafa amo dawa:mu. ");
INSERT INTO beo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Na da dili amo soge Na da hemonega A:ibalaha:me, Aisage amola Ya:igobe ilima ima:ne ilegele sia:i, amo sogega Na da dili oule masunu. Na da amo soge dili lalegaguma:ne, dilima imunu. Na da Hina Gode!’” ");
INSERT INTO beo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mousese da amo sia: huluane Isala:ili dunuma olelei. Be ilia da gasa bagade udigili hawa: hamosu hamobeba:le, ilia a:silibu da gasa hame ba:i. Amaiba:le, ilia da Mousese ea sia: dafawaneyale hame dawa:i. ");
INSERT INTO beo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Amalalu, Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Di Felouma e da Isala:ili dunu ilia gadili masunu logo doasima:ne amo sia:na masa!” ");
INSERT INTO beo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Be Mousese da bu adole i, “Isala:ili dunu huluane da na sia: hame naba. Amaiba:le, Idibidi hina bagade dunu da abuliba:le na sia: nabima:bela:? Na sia: da dioi bagade, noga:i hame.” ");
INSERT INTO beo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Be Hina Gode da gasa bagade Mousese amola Elane elama amane hamoma:ne sia:i, “Isala:ili dunu amola Felou ilima Na dima hamoma:ne sia: da agoane, ‘Na da gasa bagade dima adoi dagoi. Di Isala:ili dunu amo Idibidi soge yolesili gadili masa:ne bisili oule masa.’” ");
INSERT INTO beo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ya:igobe ea magobo mano Liubene da egefe biyaduyale lalelegei amo Ha:inoge, Ba:liu, Heselane amola Gami. Iligaga fi da ilia dio lai dagoi. ");
INSERT INTO beo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simiane egefe da gafeyale galu amo Yemiuele, Ya:imini, Ouha:de, Ya:igini, Souha amola Sia:iule (amo da Ga:ina:ne uda ea mano). Iligaga fi da ilia dio lai dagoi. ");
INSERT INTO beo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lifai egefe da osodayale galu amo Gesiome, Gouha:de amola Milalai. Iligaga fi da ilia dio lai dagoi. Lifai da ode 137 esalu bogoi. ");
INSERT INTO beo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gesiome egefe da aduna galu. Ela da Libinai amola Simia:i. Elama da elegaga fi dunu bagohame lalelegei. ");
INSERT INTO beo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Gouha:de egefe da biyaduyale galu amo A:mala:me, Isaha, Hibalone amola Asaiele. Gouha:de da ode 133 esalu, bogoi. ");
INSERT INTO beo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Milalai egefe da aduna galu amo Malai amola Musiai. Amo dedei da Lifai ea fi amola iligaga fi. ");
INSERT INTO beo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","A:mala:me da ea ada dalusi amo Yogebede lai dagoi. E da egefe Elane amola Mousese lalelegei. A:mala:me da ode 137 esalu bogoi. ");
INSERT INTO beo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isaha egefe da osodayale galu amo Goula, Nifege amola Sigalai. ");
INSERT INTO beo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Asaiele da egefe osodayale galu. Ilia dio da Misia:ili, Elasa:ifa:ne amola Sidala:i. ");
INSERT INTO beo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Elane da Ilisiba (A:minada:be idiwi amola Nasione ea dalusi) amo lai dagoi. E da egefe biyaduyale lalelegei amo Na:ida:be, Abaihu, Elia:isa amola Idima. ");
INSERT INTO beo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Goula da egefe osodayale galu amo A:se, Elaga:ina amola Abaia:sa:fe. Ilia da Goula fi ilima aowalali esalu. ");
INSERT INTO beo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elane egefe Elia:isa da Budiele idiwi lai dagoi. E da ema egefe Finia:se lalelegei. Amo dunu dedei da Lifai ea fi dunu ilima ada esalu. ");
INSERT INTO beo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Gode da Mousese amola Elane elama amane sia:i dagoi, “Ali bisili Isala:ili dunu fi huluane Idibidi sogega gadili oule masa.” ");
INSERT INTO beo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ela da Idibidi hina bagade (Felou) amoma e da Isala:ili dunu gagui amo fisidigili, ili masa:ne logo doasima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Hina Gode da Idibidi soge ganodini Mousesema sia:noba, ");
INSERT INTO beo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","E da amane sia:i, “Na da Hina Gode! Na dima sia:mu huluane, amo Felouma alofele adoma!” ");
INSERT INTO beo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Be Mousese da bu adole i, “Di dawa:! Na da sia: adole iasu noga:i hame dunu. Felou da abuliba:le na sia: nabima:bela:?” ");
INSERT INTO beo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Be Hina Gode amane sia:i, “Na da hamobeba:le, Felou da dia hou afadenene Gode Ea hou defele hamoi ba:mu. Amola dia ola Elane da dia balofede dunu agoane Felouma alofele sia:mu. ");
INSERT INTO beo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Na dima adomu huluane Elanema bu adoma. Amasea, e da Felouma Na fi dunu gadili masa:ne ilia se iasu diasu logo doasima:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","- ");
INSERT INTO beo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Be Na da Felou ea dogo igi agoane hame nabasu hamomu. Na da beda:su hou bagade Idibidi soge ganodini hamomu. Be e da Isala:ili dunu ilia logo hame doasimu. Amasea, Na da Idibidi fi ilima se bagade iasimu, amola Nisu da bisili Na dunu fi huluane amo sogega gadili oule masunu. ");
INSERT INTO beo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Amasea, Na da Idibidi dunuma gegene, Isala:ili fi huluane gadili oule ahoasea, Idibidi dunu da Na da Hina Godedafa dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mousese amola Elane da Hina Gode ea adoi huluane hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ela da Felouma sia: dasu amo esoga Mousese ea ode da 80 galu amola Elane ea ode da 83. ");
INSERT INTO beo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Hina Gode da Mousese amola Elane elama amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Felou da alima alia sia: ado ba:musa: musa: hame ba:su gasa bagade hou hamoma:ne sia:sea, Elanema agoane sia:ma. E da ea dagulu amo Felou ea midadi osoboga ligia guduli, dagulu da afadenene bu saya:be ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mousese amola Elane da Felouma asili, Hina Gode Ea sia:i defele hamosu. Elane da ea dagulu amo Felou amola ea eagene ouligisu dunu ilia midadi ligia guduli, dagulu da afadenene, sa:ya:be hamoi. ");
INSERT INTO beo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Amalalu, Felou da ea bagade dawa:su dunu amola ea fefedoasu dunu ili misa:ne sia:i. Ilia da ilia gasaga Elane ea hou defele hamosu. ");
INSERT INTO beo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ilia da ilia dagulu ligia guduli, dagulu ilia da afadenene bu sa:ya:be ba:i. Be Elane ea dagulu da ilia dagulu huluane da:gi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Be Hina Gode Ea sia:i defele, Felou ea dogo da ga:nasi dagoi. E da Mousese amola Elane ela sia: hamedafa nabi. ");
INSERT INTO beo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Amalalu, Hina Gode da Mousesema amane sia:i, “Felou ea dogo da gawamaga:i dagoi. E da sia: hame naba amola e da Na fi dunu ilia logo hame doasisa. ");
INSERT INTO beo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Amaiba:le, hahabe e da Naile Hanoga ahoasea, di e ba:la masa. Dagulu amo da afadenene saya:be hamoi, amo gaguli asili, hano bega: e ba:musa: ouesaloma. ");
INSERT INTO beo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Amasea, Felouma amane sia:ma, “Hibulu dunu ilia Hina Gode da na dima asunasi. E da dima amane sia:sa, ‘Di da Na fi dunu gagui amo ilia Nama wadela:i hafoga:i soge ganodini nodone sia:ne gadomusa: masa:ne, ili fisidigima.’ Be di da Ea sia: hame nabasu. ");
INSERT INTO beo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Be wali, Hina Gode da dima amane sia:sa, ‘Na hou hamobe ba:sea, di da Na da Hina Godedafa dawa:mu. Na da amo daguluga hano amo famu. Amasea, hano da afadenene bu maga:me ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Menabo huluane da bogogia:mu amola hano huluane da gaha bagade nababeba:le, Idibidi dunu da amo hano manu hamedei ba:mu.’” ");
INSERT INTO beo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Hina Gode da Mousesema amane sia:i, “Elanema e da ea dagulu lale, ea lobo amo Idibidi hano amola wayabo huluane dabuagadodi ilua:ma:ne sia:ma. Amasea, hano huluane da afadenene maga:me hamomu. Amola Idibidi soge huluane amoga, hano huluane amola hano ofodo amola ganaguga ganodini hano di, amo huluane da maga:me fawane ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Amalalu, Mousese amola Elane da Hina Gode Ea sia:i defele hamoi. Felou amola ea eagene ouligisu dunu ba:ma:ne, Elane da ea dagulu gaguia gadole, hano dabua fai dagoi. Amalalu, hano da bu maga:me hamoi. ");
INSERT INTO beo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Menabo fi hano ganodini da bogogia:le, gaha bagade heda:i. Idibidi dunu da amo hano manu hamedei ba:i. Idibidi soge huluane amo ganodini, maga:me bagade ba:i. ");
INSERT INTO beo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Amalalu, Felou ea fefedoasu dunu da amo hou defele hamoi. Amola Felou ea dogo bu ga:nasi hamoi. Hina Gode Ea sia:i defele, e da Mousese amola Elane ela sia: hame nabi. ");
INSERT INTO beo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Be amo baligili, e da sinidigili, amo hou mae dawa:le, hi diasuga bu asi. ");
INSERT INTO beo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Idibidi dunu da hanodafa manu hamedei ba:beba:le, ilia da hano bega: hano manusa: uli dogosu. ");
INSERT INTO beo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Hina Gode da Idibidi hano fai. Amalalu, eso fesu da baligi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Amalalu, Hina Gode da Mousesema amane sia:i, “Felouma masa! Ema amane sia:ma, “Hina Gode da amane sia:sa, ‘Na dunu fi di gagui amo Nama nodone sia:ne gadomusa: fisidigima. ");
INSERT INTO beo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Di da higasea, Na da dia sogega se iasimu. Soge huluane da guama amoga dedeboi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Naile Hano da guama amoga nabaidafa ba:mu. Amasea, guama da hano yolesili, dia diasu amola dia debea amoga heda:mu. Ilia da dia eagene ouligisu dunu amola ilia diasuga masunu. Amola ilia dilia ha:i manu ofodo amola gobele nasu amo ganodini ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ilia da di, dia fi dunu amola dia ouligisu dunu ilima soagala:le, fila heda:mu. ");
INSERT INTO beo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Hina Gode da Mousesema amane sia:i, “Di Elanema ea dagulu lale, hano amola hano logo amola hano wayabo huluane amo da:iya ea dagulu ligia gadoma:ne sia:ma. Guama da heda:le, Idibidi soge huluane dedeboma:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Amalalu, Elane da ea dagulu hano da:iya ligia gadoi. Amola guama da heda:le, Idibidi soge huluane dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Be Felou ea fefedoasu dawa: dunu da ilia hou hamobeba:le, guama da heda:i. ");
INSERT INTO beo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Felou da Mousese amola Elane misa:ne sia:i. E da elama amane sia:i, “Alia Hina Godema E da amo guama sefasima:ne sia:ne gadoma. Amasea, na da dia fi ilia da Godema gobele salasu hou hamoma:ne, logo doasimu.” ");
INSERT INTO beo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mousese da bu adole i, “Na da di, dia ouligisu dunu amola dia fi dunu amo fidima:ne hahawane Godema sia:ne gadomu. Na sia:ne gadoma:ne, di eso ilegema. Amasea, guama huluane da fadegale, Naile Hano amo ganodini fawane guama ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Felou da bu adole i, “Dia na fidima:ne, aya sia:ne gadoma!” Mousese da amane sia:i, “Dia adole ba:i defele na da hamomu. Amasea, ‘gode’ eno ninia Hina Gode defele da hamedafa gala, amo di da dawa:mu. ");
INSERT INTO beo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Di, dia eagene ouligisu dunu amola dia fi huluane da guama afia:i dagoi ba:mu. Naile Hano ganodini fawane da guama ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Amalalu, Mousese amola Elane da Felou yolesili, asili Hina Gode da guama sefasima:ne, Ema sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Hina Gode da Mousese ea sia:ne gadoi defele hamoi. Guama huluane diasu amola gagoi amola ifabi amo ganodini esafulu da bogogia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Idibidi dunu da guama bogoi amo gilisili ligisi biba heda:i dialu. Soge huluane da gaha bagade nabi. ");
INSERT INTO beo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Be Felou da guama bogoi dagoi ba:beba:le, ea dogo da bu igi agoane hamoi. Hina Gode Ea sia:i defele, e da Mousese amola Elane ela sia: hame nabi. ");
INSERT INTO beo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Hina Gode da Mousesema amane sia:i, “Di Elanema amane sia:ma. E da ea daguluga osoba fama. Amasea osobo su Idibidi soge huluane amo ganodini da afadenene mimini ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Amaiba:le, Elane da ea daguluga osobo fai. Osobo su Idibidi soge ganodini huluane da afadenene mimini hamoi. Ilia da dunu amola ohe fi amo da:iya fila heda:le dedeboi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Idibidi fefedoasu dunu da gasa fili mimini hamomusa: hamonanu. Be hamedei. Mimini da bagohame soge huluane ganodini ba:i. ");
INSERT INTO beo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Idibidi fefedoasu dunu da Felouma amane sia:i, “Gode Hi da amo hou hamoi.” Be Felou ea dogo da ga:nasi hamoi. E da Hina Gode Ea sia:i defele, Mousese amola Elane ela sia: hame nabi. ");
INSERT INTO beo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Hina Gode da Mousesema amane sia:i, “Hahabedafa, Felou da Naile Hano amoga ahoanumu. Di ema ba:la masa. Ema amane sia:ma, ‘Hina Gode da agoane sia:sa, Na fi dunu da Nama nodone sia:ne gadomusa:, di ili ga masa:ne fisidigima. ");
INSERT INTO beo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Na da dima sisasa. Di da fisidigimu higasea, Na da dima se nabasu imunu. Na da fane dima amola dia eagene ouligisu dunuma amola dia fi dunu huluane ilima asunasimu. Idibidi dunu ilia diasu huluane da fane amoga nabai ba:mu. Amola Idibidi soge osobo huluane da fane amoga dedeboi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Be Gousiene amo Na fi ilia esalebe soge amoga Na da fane hame asunasimu. Di da Na, Hina Gode, da amo hou hamonanebe dawa:ma:ne, Na da Na fi amola dia fi hisu ba:sa. Amo musa: hame ba:su hou da aya ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Hina Gode da fane gilisisu bagohame amo Felou ea diasuga amola eagene ouligisu dunu ilia diasuga asunasi. Fane idimu hamedeidafa misiba:le, Idibidi soge huluane da gugunufinisi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Amalalu, Felou da Mousese amola Elane ema misa:ne sia:i. E da elama amane sia:i, “Defea! Dilia Hina Godema gobele salasu hou hamoma:ne, Idibidi soge ganodini hamomusa: masa.” ");
INSERT INTO beo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Be Mousese da bu adole i, “Agoane hamosea da moloi hame ba:mu. Ninia ohe fi amo gobele salasu hamoma:ne medole legesea, Idibidi dunu da higa:i ba:mu. Amo hou ninia Idibidi dunu ilia siga ba:ma:ne hamosea, ilia da amo hou higa:iba:le, nini igiga gala:le legemu.” ");
INSERT INTO beo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Logo afae fawane gala. Ninia da eso udiana amo wadela:i hafoga:i soge ganodini ga ahoasea, ninia Hina Gode Ea sia: defele, Ema gobele salasu hamomu.” ");
INSERT INTO beo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Felou da amane sia:i, “Defea! Dilia Hina Godema gobele salasu hamoma:ne, wadela:i hafoga:i sogega masunu da defea. Be sedagaga mae masa. Amola na fidima:ne Godema sia:ne gadoma.” ");
INSERT INTO beo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mousese da bu adole i, “Na da ga ahoasea, na da Hina Godema E da fane amo dima, dia eagene ouligisu dunuma amola dia fi huluane ilima fisili sefasima:ne sia:mu. Be di da ninia fi ilia Hina Godema gobele salasu hamoma:ne masunu logo damumusa:, ninima bu mae ogogoma.” ");
INSERT INTO beo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mousese da Felou yolesili asili, Godema sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Amola Hina Gode da Mousese ea adole ba:su defele hamoi dagoi. Fane huluane da Felou, ea eagene ouligisu dunu amola ea fi dunu huluane yolesi dagoi. Fane afae esalebe da hamedafa ba:i. ");
INSERT INTO beo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Be Felou da bu eno ea dogo ga:nasi hamoi. E da Isala:ili dunu ga fisili masa:ne hame fisidigi. ");
INSERT INTO beo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Hina Gode da Mousesema amane sia:i, “Felouma masa! Ema amane adoma, Hibulu dunu ilia Hina Gode da amane sia:sa, Na fi dunu da Nama nodone sia:ne gadomusa:, amo fisidigima. ");
INSERT INTO beo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Be di da ili fisidigimu higasea, ");
INSERT INTO beo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Na da dima se nabasu imunu agoane. Na da dia lai gebo huluane amo hosi, dougi, ga:mele, bulamagau, sibi amola goudi ilima olo bagade madelama:ne iasimu. ");
INSERT INTO beo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Na da Isala:ili dunuma hisu hamomu. Ilia ohe fi huluane da hame olomu amola afaedafa da hame bogomu. ");
INSERT INTO beo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Na da aya amo hou hamoma:ne ilegei dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Aya Hina Gode da Ea sia:i defele hamoi dagoi. Idibidi dunu ilia ohe fi (lai gebo) huluane da bogogia:i. Be Isala:ili ohe da afae hamedafa bogoi. ");
INSERT INTO beo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Felou da ea fi dunuma adi hou da doaga:bayale adole ba:i. Isala:ili ohe da afae hamedafa bogoi, ilia da ema adole i. Be Felou ea dogo da ga:nasi hamoiba:le, e da Isala:ili fi ilia fisili masunu logo doasimu hame dawa:i. ");
INSERT INTO beo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Amalalu, Hina Gode da Mousese amola Elane elama amane sia:i, “Lalu amoga nasubu dia lobo ganodini gaguma. Mousese da lalu didi amoga nasubu su gasa:le gaguli Felou ea lelebe ba:le gaidi gasa:le galagadoma. ");
INSERT INTO beo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Amo nasubu su da asili, Idibidi soge huluane dedebomu. Amasea nasubu su da dulusu bagohame hamomu. Amo dului da guhi hodole dasea, aiya bagade dunu huluane ilia da:i amoga madelale ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Amaiba:le, Mousese amola Elane da nasubu su lale, Felou ea ba:le gaidi lelu. Mousese da amo nasubu su gasa:le galagadole, su da dunu amola ohe fi ilima dului hamosu. Dului da guhi hodole sa:ili, aiya bagade hamosu. ");
INSERT INTO beo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Felou ea fefedoasu dunu da Mousesema misunu hamedei. Ilia da Idibidi dunu huluane defele, dului amoga dedeboi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Be Hina Gode da Felou ea dogo bu ga:nasi hamoi amola Hina Gode Ea sia:i defele, e da Mousese amola Elane ela sia: hame nabi. ");
INSERT INTO beo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Amalalu, Hina Gode da Mousesema amane sia:i, “Hahabedafa, Felouma masa! Ema amane sia:ma, ‘Hibulu fi ilia Hina Godema nodone sia:ne gadomusa:, amo fisidigima. ");
INSERT INTO beo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Be wali di higasea, Na da dia eagene ouligisu dunu amola dia fi dunu ilima se nabasu baligili imunu. Osobo bagadega eno da Na defele hame esala, amo di dawa:ma:ne Na da dima se nabasu imunu. ");
INSERT INTO beo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Na da di amola dia fi dilima olo bagade ia ganiaba, dilia huluane da bogogia:la:loba. ");
INSERT INTO beo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Be osobo bagade dunu huluanedafa Na gasa dawa:ma:ne Na da dili hame medole legei. ");
INSERT INTO beo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Be di da gasa fi hamosa lela. Di da Na fi dunu fisidigimu higasa. ");
INSERT INTO beo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Amaiba:le, Na da aya wewaba mugene gibu agoane imunu. Amo mugene imunu da Idibidi sogega musa: misi amo bagadewane baligimu. ");
INSERT INTO beo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Dia hawa: hamosu dunu ilima olelema. Ilia da dia ohe fi amola liligi gadili diala amo diasu ganodini gaguli misa:ne sia:ma. Be dunu amola ohe fi gadili esalebe ba:sea da mugene amoga fabeba:le bogogia:mu.” ");
INSERT INTO beo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Felou ea eagene ouligisu dunu mogili da Hina Gode Ea sia: nababeba:le, beda:ga, ohe fi amola udigili hawa: hamosu dunu ganodini oule misi. ");
INSERT INTO beo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Be oda da Hina Gode Ea sisasu hame nabi. Ilia da ohe fi amola udigili hawa: hamosu dunu gadili esaloma:ne yolesi. ");
INSERT INTO beo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Amalalu, Hina Gode da Mousesema amane sia:i, “Dia lobo ligia gadosea, mugene da Idibidi soge huluane amoga sa:imu. Mugene da dunu, ohe fi amola gisi huluane amoga sa:imu. ");
INSERT INTO beo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Amaiba:le, Mousese da ea dagulu muga ligia gadoi. Amalalu, Hina Gode da gugelebe, mugene amola ha:ha:na osobo bagadega iasi. ");
INSERT INTO beo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","E da mugene gibula bobodoi iasi. Ha:ha:na la:didili la:didili asili bagadedafa ba:i. Amola amo gibula bobodobe da musa: Idibidi sogega misi amo bagadewane baligi. ");
INSERT INTO beo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Idibidi soge huluane amo ganodini, mugene da liligi huluane ganodini hame sali, dunu amola ohe fi fai dagoi. Mugene da gisi amola ifa huluane fili gugunufinisi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Be Gousiene soge amo Isala:ili fi esalebe soge amoga fawane mugene da hame sa:i. ");
INSERT INTO beo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Felou da Mousese amola Elane elama ema misa:ne sia:i. E da elama amane sia:i, “Wali na da wadela:le hamoi dagoi. Hina Gode Hi fawane da moloidafa. Na amola na fi dunu da giadofai. ");
INSERT INTO beo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hina Godema sia:ne gadoma. Ninia da gugelebe amola mugene gibula bobodobe amoma bagade helebe. Na da dafawane dili fisidigima:ne ilegele sia:sa. Dilia da goeguda: bu hame esalumu. ");
INSERT INTO beo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mousese da ema amane sia:i, “Na da moilai bai bagadega gadili ahoasea, na da lobo ligia gadole Hina Godema sia:ne gadomu. Amasea, di da osobo bagade da Hina Gode Ea soge fawane amo dawa:ma:ne, gugelebe da yolesimu amola mugene da yolesimu. ");
INSERT INTO beo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Be di amola dia eagene ouligisu dunu da Hina Godema hame beda:i, amo na dawa:.” ");
INSERT INTO beo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","‘Fala:gese’ (flax - amoga ilia da abula amunisu efe hamosu) da sogea hamonanu. Amaiba:le, huluane da mugene amoga gugunufinisi dagoi. Bali gala:ine amola da yoiba:le mugene amoga gugunufinisi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Be widi da fage hame legeiba:le, hame gugunufinisi. ");
INSERT INTO beo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mousese da Felou yolesili, moilai bai bagade amo gadili asili, ea lobo ligia gadole Hina Godema sia:ne gadoi. Amalalu, gugelebe, mugene amola gibu bagade huluane da yolesi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Be Felou da amo hou ba:loba, bu wadela:le hamoi. E amola ea eagene ouligisu dunu da bu higale gawamaga:i. ");
INSERT INTO beo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Hina Gode da Mousese ea lafidili sia:i amo defele, Felou da Isala:ili dunu hame fisidigi. ");
INSERT INTO beo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Amalalu, Hina Gode da Mousesema amane sia:i, “Felou ba:la masa! Na da e amola ea eagene ouligisu dunu ilia dogo ga:nasi agoane hamoi. Bai Na da ilia gilisisu ganodini musa: hame ba:su gasa bagade hou hamomusa: dawa:lala. ");
INSERT INTO beo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Bai eno da dilia fa:no dilia mano amola aowa ilima Na da musa: hame ba:su hou hamobeba:le, Idibidi dunu da gagaoui dunu agoane ba:i, amo dilia da diligaga fi ilima olelemu. Dilia huluane da Na da Hinadafa amo dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Amaiba:le, Mousese amola Elane da Felouma asili, amane sia:i, “Hibulu dunu ilia Hina Gode da amane sia:sa, ‘Di da habogala Na sia: nabima:bela:? Di da Na fi dunu Nama nodone sia:ne gadoma:ne amo fisidigima. ");
INSERT INTO beo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Be di da higasea Na da aya danuba: dilima se nabasu ima:ne asunasimu. ");
INSERT INTO beo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Danuba: da bagohamedafa ba:mu. Ilia da osobo huluane dedebomu. Ilia da liligi huluane amo mugene da hame gugunufinisi amola ifa huluane hame wadela:lesi amo na dagomu. ");
INSERT INTO beo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ilia dia diasu amola dia ouligisu dunu ilia diasu huluane nabamu. Ilia dilima se nabasu imunu da dilia musa: ba:i liligi huluane baligimu.’” Amo sia:nanu, Mousese da Felou yolesili asi. ");
INSERT INTO beo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Felou ea eagene ouligisu dunu ilia da ema amane sia:i, “Amo dunu da habowali seda ninima se nabasu ima:bela:? Di Isala:ili dunu ilia Hina Godema nodone sia:ne gadomusa: fisidigima. Ninia Idibidi soge da gugunufinisi dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Amaiba:le, ilia da Mousese amola Elane amo Felouma oule misi. Felou da elama amane sia:i, “Defea! Dilia da dilia Hina Godema sia:ne gadomusa: masunu da defea. Be nowa da masa:bala:?” ");
INSERT INTO beo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mousese da amane adole i, “Ninia huluane, dunu, uda, mano amola da:i hamoi da masunu. Ninia da ninia dunu mano, ninia uda mano, ninia sibi, goudi amola bulamagau huluane oule masunu. Bai ninia da lolo nasu gilisisu Hina Godema nodomusa: hamomu.” ");
INSERT INTO beo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Felou da amane sia:i, “Na da Hina Gode Ea Dioba:le gasa bagade sia:sa. Dilia da dilia uda amola mano hamedafa oule masunu. Ninia ba:i dagoi. Dilia da odoga:su hou hamomusa: dawa:lala. ");
INSERT INTO beo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hame mabu! Dilia amo hanai galea, dunu fawane da dilia Hina Godema nodone sia:ne gadomusa: masa!” Amo sia:beba:le, Idibidi dunu da Mousese amola Elane ela Felou fisimusa:, gadili sefasi. ");
INSERT INTO beo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Amalalu, Hina Gode da Mousesema amane sia:i, “Danuba: misa:ne sia:musa:, dia lobo amo Idibidi soge da:iya amoga ligia gadoma. Ilia da misini, liligi huluane mugene amoga hame gugunufinisi, amo ilia da na dagomu. ");
INSERT INTO beo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Amaiba:le, Mousese da ea dagulu ligia gadole, Hina Gode da fo amo gusudili misi da amo eso amola gasi ganodini Idibidi sogega fofosu. Hahabe aya danuba: foga gaguli misi doaga:i dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ilia da gilisisu osea:le misi amola soge huluane dedeboi dagoi. Ilia idi bagadedafa amo da musa: hame ba:su amola amo defele bu hamedafa ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ilia da osobo huluane dedeboiba:le, osobo da bunumai agoane ba:i. Ilia da liligi huluane amo mugene da hame gugunufinisi amola ifa fage dialu huluane na dagoi. Mola:ya:i liligi amo ifa o gisi da:iya Idibidi soge ganodini da hamedafa ba:i. ");
INSERT INTO beo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Amalalu, Felou da hedolowane Mousese amola Elane ema misa:ne sia:i. E da elama amane sia:i, “Na da Hina Gode amola alima wadela:le hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Be wali afadafa fawane na wadela:i hou gogolema:ne olofoma. Ali Hina Godema E da amo bogosu se nabasu fadegale fasima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mousese da Felou yolesili asili, Hina Godema sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Amalalu, Gode da gusudili mabe fo afadenene, bu guma:dini mabe fo hamoi. Amo da danuba: fi huluane lale Suese (Gulf) amo foga mini asi. Danuba: afadafa da Idibidi soge ganodini esalebe hame ba:i. ");
INSERT INTO beo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Be Hina Gode da Felou ea hou bu ga:nasi hamone, e da Isala:ili dunu hame fisidigi. ");
INSERT INTO beo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Amalalu, Hina Gode da Mousesema amane sia:i, “Dia lobo muagado ligia gadoma. Amasea, gasi dunasi bagadedafa da Idibidi soge huluane dedebomu.” ");
INSERT INTO beo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mousese da ea lobo muagado ligia gadole, gasi dunasi bagadedafa da Idibidi soge ganodini eso udianaga dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Idibidi dunu huluane da ilia na:iyado dunu ba:mu gogolei amola amo eso udianaga ilia da diasu fisili gadili masunu hamedei ba:i. Be Isala:ili dunu ilia esalebe soge ganodini hadigi galebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Felou da Mousese ema misa:ne sia:i. E da ema amane sia:i, “Defea! Di da Hina Godema nodone sia:ne gadomusa: masunu da defea. Dilia uda amola mano masunu da defea. Be dilia sibi, goudi amola bulamagau da guiguda: esaloma:mu.” ");
INSERT INTO beo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Be Mousese da bu adole i, “Agoane hamomu ganiaba, di da ninima ohe fi ninia Hina Godema gobele salasu hamoma:ne ia:noba. ");
INSERT INTO beo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Hame mabu! Ninia ahoasea ninia da ohe fi huluane amola oule masunu. Ninisu da Hina Godema nodomusa:, ohe fi afae afae amo ilegema. Amola ninia da Hina Godema gobele salasu sogebi amoga doaga:sea fawane, ohe fi ilegemusa: dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Hina Gode da Felou ea dogo bu ga:nasi hamoi amola e da Isala:ili fi fisidigimu higa:i. ");
INSERT INTO beo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","E da ougili Mousesema amane sia:i, “Dia odagi na siga mae ba:ma:ne, masa! Na da di bu ba:mu higa:i gala mabu! Eso enoga na da di bu ba:sea, di da bogomu!” ");
INSERT INTO beo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mousese da bu adole i, “Di da dafawane sia:i dagoi! Di da na hamedafa bu ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Amalalu, Hina Gode da Mousesema amane sia:i, “Na da Felou (Idibidi hina bagade) amola ea fi dunu ilima eno afae fawane se nabasu imunu. Amo ba:sea, e da dili fisidigimu. Amo baligili, e da dili gadili sefasimu. ");
INSERT INTO beo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Be wali Isala:ili dunuma sia:ma. Ilia da Idibidi na:iyado ilima gouli, silifa amola muni liligi ilima ima:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Hina Gode da Idibidi dunu ilia asigi dawa:su afadenene, ilia da Isala:ili dunuma nodone dawa:i. Idibidi eagene ouligisu dunu amola dunu huluane da Mousese da dunu mimogo bagadedafa dawa:i. ");
INSERT INTO beo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Amalalu, Mousese da Felouma amane sia:i, “Hina Gode da amane sia:sa, ‘Na da gasimogoa gadenene Idibidi soge ganodini lafidalomusa: masunu. ");
INSERT INTO beo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Amola magobo mano huluane Idibidi soge ganodini esalebe da bogogia:mu. Felou ea magobo mano (e da fa:no Idibidi hina bagade hamomu galu) amola udigili hawa: hamosu uda (amo da gagoma goudasa) ilia magobo mano huludafa da bogogia:mu. Amola bulamagau huluane ilia magobo mano da bogomu. ");
INSERT INTO beo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Idibidi soge ganodini didigia:su bagadedafa nabimu. Agoai didigia:su da musa: hame ba:i amola hobea bu hamedafa ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Be Isala:ili fi da se hame nabimu. Wa:me da ilima amola ilia ohe fi ilima hame yeyamu. Amasea, Na da Isala:ili dunu da hisu amola Idibidi dunu da hisu amo ba:sa, amo dilia da dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mousese da ea sia: dagomusa:, amane sia:i, “Dia ouligisu hina dunu huluane da nama misini, nama beguduli, na da na fi dunu lale gadili oule masa:ne nama ha:giwane edegemu. Amalalu, na da yolesili masunu.” Amalalu, Mousese da bagadewane ougili, Felou yolesili asi. ");
INSERT INTO beo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Be Hina Gode da musa: Mousesema sia:i dagoi, “Felou da mae fisili, dia sia: hamedafa nabimu. Bai Na da Idibidi soge ganodini Na musa: hame ba:su hou eno amo soge ganodini hamomu galebe.” ");
INSERT INTO beo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mousese amola Elane da amo musa: hame ba:su hou huluane Felou ba:ma:ne hamosu. Be Hina Gode da ea hou gawamaga:i agoane hamoi. Amola e da Isala:ili dunu ea soge fisili gadili masa:ne hame fisidigi. ");
INSERT INTO beo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Hina Gode da Idibidi soge ganodini, Mousese amola Elane elama amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Wali oubi da dilima oubi age ode huluane amoga ganumu. ");
INSERT INTO beo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isala:ili dunu gilisisu amoma agoane olelema, ‘Wali oubi amoga eso nabuane amoga diasu afae afae esalebe sosogo fi eda da sibi mano o goudi mano afae ilegema:ma. ");
INSERT INTO beo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Be ea sosogo fi da fonobahadi amola ohe afae huluane manu hamedei ba:sea, defea, e amola ea dafulisu na:iyado sosogo fi da amo ohe fifili, dunu ilia idi amola ilia manu defele, gilisili manu. ");
INSERT INTO beo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Sibi o goudi ilegema. Be gawali amo da noga:idafa, aiya amola nigima: amola wadela:i hame galu amo fawane ilegema. ");
INSERT INTO beo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Amasea, eso 14 (ge), age oubiga, daeya, Isala:ili dunu huluane da amo ilegei ohe medole legema:mu. ");
INSERT INTO beo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Isala:ili dunu da maga:me mogili lale, diasu amo ganodini ohe ilia da manu, amo diasu logo holei mimogoa gadodili, la:ididili amola la:ididili maga:mega ulasima:mu. ");
INSERT INTO beo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Amo gasia, sibi o goudi ea hu amo gobele, mola: agoane amola agi (yisidi hame sali) gilisili moma. ");
INSERT INTO beo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Hu da hame gobei (gahea) o hano ganodini egei mae moma. Be ohe mae dadega:le, dialuma, emo amola iga huluane gilisili gogo gobema. ");
INSERT INTO beo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Hahabe doaga:sea, hu huluane da na dagoi ba:ma:mu. Be fonobahadi hame mae dialebe ba:sea, amo laluga gobele salima. ");
INSERT INTO beo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Dilia amo hedolowane moma. Dilia gadili masa:ne defele, abula salawane, emo salasu salawane amola dagulu dilia lobo ganodini gaguiwane ouesaloma. Amo lolo nabe da Na Hina Godema nodoma:ne Baligisu (Gadodili Baligisu) Lolo Nabe. ");
INSERT INTO beo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Amo gasi ganodini Na da Idibidi soge huluane amo ganodini masunu. Na da dunu amola ohe fi magobo mano huluane fanelegemu. Amola Na da Idibidi ogogosu ‘gode’ huluanema se nabasu imunu. Na da Hina Godedafa! ");
INSERT INTO beo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Maga:me amo dilia logo holei mimogodiga ulasi da dilia Isala:ili dunu dilia esalebe diasu ilegei gala. Na da maga:me ba:sea, Na da dili gadodili baligimu amola Na da Idibidi dunuma se nabasu iasia Na da dilima se hame imunu. ");
INSERT INTO beo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Dilia da amo Lolo Nasu amo da hadigi gilisisu hamoma:mu. Na, Hina Gode, da hou bagadedafa hamoi. Amo dilia mae gogolema:ne amo Baligisu Lolo Nasu ode huluane mae yolesili hamonanoma.” ");
INSERT INTO beo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Hina Gode da amane sia:i, “Eso fesu ganodini dilia agi amo yisidi da ganodini sali, amo mae moma. Yisidi hame sali agi fawane moma. Eso agega, dilia yisidi huluane dilia diasu ganodini diala amo ha:digima. Amo eso fesuale ganodini nowa da yisidi sali agi nasea, e da Na fi amoga fadegai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Eso age amo ganodini dilia da nodone sia:ne gadomusa: gilisima. Amo eso fesuale amoga dilia mae hawa: hamoma. Be ha:i manu hahamomu da defea. ");
INSERT INTO beo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Amo gilisisu mae yolesili ode huluane amoga hamoma. Bai amo esoga, Na da dili Idibidi soge fisimusa:, gadili oule asi, amo dawa:ma. ");
INSERT INTO beo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Eso 14 oubi age amo daeya asili eso 21 daeya, amo eso fesualega, dilia da agi yisidi sali amo mae moma. ");
INSERT INTO beo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Amo eso fesualega, yisidi dilia diasu ganodini ba:mu da sema bagade. Bai nowa dunu amo Isala:ili o ga fi dunu da yisidi sali agi nasea, e da Na fi amoga fadegai dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mousese da Isala:ili ouligisu dunu huluane ema misa:ne sia:i. E da ilima amane sia:i, “Dilia huluane da sibi mano o goudi mano ilegele, amo medole legema. Dilia sosogo fi da Baligisu Lolo Nasu hamoma:ne, ");
INSERT INTO beo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","dilia ohe medole legei amo ea maga:me ofodo ganodini salima. Amasea, hisobe lubi amo maga:me ganodini gele, dilia diasu logo holei amo gadodili amola mimogodi la:didili amola eno la:didili ulasima. Amola dilia da diasu ganodini gagili sali agoane esaloma. Dunu huluane da daeya asili hahabe, diasu mae yolesili amo ganodini ouesaloma:mu. ");
INSERT INTO beo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Hina Gode da Idibidi sogega magobo mano fanelegemusa: ahoasea, E da maga:me dilia logo holei gadodili amola mimogodi la:didili la:didili ulasi ba:sea, E da Gugunufinisisu A:igele ema dilia diasu ganodini dili medoma:ne mae golili sa:ima:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Dilia amola dilia mano da amo hamoma:ne sia:i eso huluane nabawane hamoma. ");
INSERT INTO beo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Dilia da soge amo Hina Gode da dilima imunu ilegele sia:i, amoga golili dasea, dilia da Baligisu (Gadodili Baligisu) Lolo Nasu hamoma. ");
INSERT INTO beo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Dilia mano da dilima, amane adole ba:sea, ‘Amo hou ea bai da adi baila:?’ ");
INSERT INTO beo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Dilia bu adole ima, ‘Amo da Baligisu Lolo Nasu gobele salasu, Hina Godema nodomusa: nini hamosa. E da Idibidi soge ganodini, Isala:ili dunu diasu amo gadodili baligi dagoi. E da Idibidi dunu medole legei be E da nini gaga:i dagoi,’” Mousese da amane sia:i. Isala:ili dunu da muguni bugili, Hina Godema nodone sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Amalalu, ilia da asili, Hina Gode da Mousese amola Elane elama adoi defele hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gasimogoa, Hina Gode da magobo mano huluane Idibidi soge ganodini esalu, amo medole lelegei. Felou ea magobo mano (amo da hina bagade hamomu galu) amola se iasu diasu ganodini sali dunu ilia magobo mano huluane, E da medole lelegei. Amola ohe fi ilia magobo mano huluane da medole legei dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Amo gasia, Felou, ea eagene ouligisu dunu amola Idibidi dunu huluane da didilisi dagoi ba:i. Idibidi soge huluane amo ganodini da didigia:su bagade nabi. Bai diasu huluanedafa afae mae fisili, amo ganodini da dunu bogoi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Amo gasia, Felou da Mousese amola Elane elama misa:ne sia:i. E elama amane sia:i, “Gadili masa! Ali amola Isala:ili fi masa! Na soge yolesili masa! Dilia adole ba:i defele, Hina Godema nodomusa: masa! ");
INSERT INTO beo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Dilia sibi, goudi amola bulamagau lale, gadili masa! Amola Gode da na hahawane dogolegema:ne, Ema sia:ne gadoma.” ");
INSERT INTO beo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Idibidi dunu da Isala:ili dunuma hedolowane masa:ne sia:i. Ilia amane sia:i, “Dilia ga hame ahoasea, ninia huluane da bogogia:i dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Amaiba:le, Isala:ili dunu da yisidi hame sali hame gobei agi amo ilia gobele nasu ofodo ganodini sali, amo abulaga dedebole gisa asi. ");
INSERT INTO beo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isala:ili dunu da Mousese ea sia: defele Idibidi dunuma gouli, silifa amola abula edegei dagoi. ");
INSERT INTO beo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Hina Gode da Idibidi dunu ilia hou afadeneiba:le, ilia da Isala:ili dunuma esega beda:i galu. Amaiba:le, ilia da Isala:ili dunuma ilia edegei liligi iasu. Amola Isala:ili dunu da Idibidi dunu ilia noga:i liligi huluane gaguli asi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isala:ili dunu da La:misisi moilai bai bagade yolesili, emoga asili, Sagode moilaiga doaga:musa: asi. Dunu ilia idi da 600,000 agoane. Amola uda amola mano bagohame gadili asi, be ilia defei hame idi. ");
INSERT INTO beo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Dunu eno bagohame, sibi, goudi amola bulamagau osea:idafa ilia da oule asi. ");
INSERT INTO beo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ilia da yisidi hame sali agi amo logoga gobei. Ilia da Idibidi soge amoga hedolowane sefasiba:le, ilia Idibidi soge ganodini ha:i manu logoga manusa: hahamomu amola yisidi ilia falaua ganodini salimu hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isala:ili dunu da Idibidi soge ganodini ode 430 esalu. ");
INSERT INTO beo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Eso amoga ode 430 da gidigi ba:loba, Hina Gode Ea fi huluane da Idibidi yolesili gadili asi. ");
INSERT INTO beo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Amo gasia, Hina Gode da mae golale, Ea fi dunu Idibidi soge amoga fadegale ga oule masa:ne sosodo aligi ba:i. Amo gasia, ode huluane ganodini Isala:ili dunu da Hina Godema nodone dawa:ma:ne, sosodo aligilalebe ligiagasa. ");
INSERT INTO beo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Hina Gode da Mousese amola Elane elama amane sia:i, “Baligisu hamoma:ne sia: da amo:- Ga fi dunu da Baligisu Lolo hame manu. ");
INSERT INTO beo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Be dilia da udigili bidi hame lasu hawa: hamosu dunu lasea, e da Baligisu manu da defea. Be hidadea ea gadofo damuma:mu. ");
INSERT INTO beo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Sofe misi o bidi lamu hawa: hamosu dunu da hame manu. ");
INSERT INTO beo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Dilia Lolo Nasu ha:i manu amo huluanedafa da diasu afadafa fawane amo ganodini moma. Gadili mae gaguli masa. Amola, ohe gobei amo ea gasa mae fima. ");
INSERT INTO beo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isala:ili fi huluane da gilisisu hamone, amo lolo manu. ");
INSERT INTO beo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Be gadofo hame damui dunu da hame manu. Be ga fi dunu da dilia soge ganodini esalea, amola e da Hina Godema nodomusa: Baligisu Lolo manu hanai galea, dilia hidadea dunu huluane ea sosogo fi amo ganodini ilia gadofo damuma. Amasea, amo dunu da Isala:ili dunu lalelegei defele ba:ma. Amasea, e da Baligisu lolo manu da defea. ");
INSERT INTO beo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Be Isala:ili dunudafa amola ga fi dunu dilima gilisi, amo huluane da defele Baligisu Lolo Nasu hamoma:ne sia:i nabawane hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Isala:ili dunu huluane da nabasu hou hamosu. Ilia da Hina Gode Ea Mousese amola Elane elama adoi defele hamosu. ");
INSERT INTO beo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Amo esoga Hina Gode da Isala:ili fi huluane Idibidi sogega fisili masa:ne, gadili oule asi. ");
INSERT INTO beo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Magobo dunu mano huluane, Na ouligima:ne Nama ima. Bai Isala:ili dunu mano magobo huluane amola ohe fi magobo gawali huluane da Na:. ");
INSERT INTO beo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mousese da Isala:ili dunu ilima amane sia:i, “Wali eso mae gogolema. Dilia da Idibidi ganodini se nabawane udigili hawa: hamosu dunu esalu. Be wali eso dilia da gadili misi. Hina Gode Ea gasa bagade amoga dili fisili masa:ne asunasi. Agi yisidi sali amo mae moma. ");
INSERT INTO beo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Dilia da wali eso oubi age amoga (oubi dio da Abibi) Idibidi soge yolesili gadili ahoa. ");
INSERT INTO beo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Hina Gode da dafawane sia:i. E da Ga:ina:naide, Hidaide, A:moulaide, Haifaide amola Yebusaide amo dunu fi huluane ilia soge dilima imunu ilegele sia:i. E da dili amo soge noga:idafa amoga oule ahoasea, dilia da wali lolo nabe gilisisu ode huluane oubi age amoga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Eso fesuale amoga dilia yisidi hame sali agi fawane moma. Eso fesu amoga dilia Hina Godema nodomusa: gilisima. ");
INSERT INTO beo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Eso fesuale ganodini dilia yisidi sali agi maedafa moma. Dilia soge ganodini, yisidi amola agi yisidi sali liligi da sema bagade. ");
INSERT INTO beo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ode huluane, amo gilisisu dilia hemosea, dilia egefe ilima dilia da Hina Gode Ea dili Idibidi yolesili gadili masa:ne fidisu amo dawa:ma:ne, agoane hamoma amo dilia egefelali ilima olelema. ");
INSERT INTO beo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Amo gilisisu da dilima liligi dilia loboga o odagiga ga:i agoai gala ba:mu. Dilia da Hina Gode Ea hou (E da Ea gasa bagade amoga dili Idibidi sogega fisili masa:ne asunasi) amo bu dawa:sea, dilia da Hina Gode Ea hamoma:ne sia:i idimu amola dawa:ma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Dilia eso ilegei ode huluane amoga, amo lolo nabe gilisisu hamoma. ");
INSERT INTO beo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Hina Gode da dilia aowalali ilima, E da dili Ga:ina:naide fi ilia soge ganodini oule misunu ilegele sia:i. Amo E da hamomu. E da amo soge dilima iasea, ");
INSERT INTO beo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","dilia da magobo dunu mano huluane Ema ima. Ohe fi magobo gawali huluane da Gode Ea: liligi. ");
INSERT INTO beo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Be magobo gawali dougi amo dilia Ema bu bidi lama:mu. Dilia dougi bu lale, sibi mano Godema ima. Be dilia da dougi bu lamu higasea, defea, ea galogoa fima. Dilia dunu magobo mano amo huluane Godema bu bidi lama:mu. ");
INSERT INTO beo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Hobea, dia gofe da dima amo hou ea bai adole ba:sea, ema bu adole ima, ‘Ninia da musa: Idibidi soge ganodini udigili hawa: hamosu dunu esalu. Be Hina Gode Ea gasa bagade amoga E da nini fisili masa:ne gadili asunasi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Idibidi hina bagade (Felou) da gasa fili ninia fisidigimu higaloba, Hina Gode da magobo dunu mano huluane Idibidi soge ganodini esalu, dunu amola ohe medole legei dagoi. Amaiba:le, ninia da wali ohe mano magobo gawali huluane Godema gobele salasu iaha. Be magobo dunu mano huluane ninia bu bidi laha. ");
INSERT INTO beo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Amo hou ninia hamonana da ninia liligi ninia lobo o odagia ga:i agoai ganumu. Amo dawa:sea, ninia Hina Gode da Ea gasa bagade amoga nini Idibidi soge fisili masa:ne gadili asunasi dagoi dawa:sa.’” ");
INSERT INTO beo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Idibidi hina bagade (Felou) da Isala:ili dunu gadili masa:ne fisidigiloba, Gode da ili logo dunumuni (amo da hano wayabo bagade bega: Filisidia sogega ahoasu) amoga hame oule asi. Gode da amane dawa:i, “Isala:ili dunu da se nabasea amola gegesu ba:sea, ilia asigi dawa:su sinidigili, Idibidi sogega bu hagimu Na higa:i hodosa.” ");
INSERT INTO beo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Amaiba:le E da guga:loi ahoasu amo da wadela:i hafoga:i sogega asili Maga:me Hanoga doaga:musa:, amo logoga oule asi. Isala:ili dunu da ilia gegesu liligi gaguiwane ahoasu. ");
INSERT INTO beo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mousese da Yousefe ea bogoi da:i hodo gaguli asi. Yousefe da esaloba, e da Isala:ili dunuma amane sia:i dagoi, “Gode da dili gaga:sea, amola dilia ga ahoasea, na da:i hodo amola gaguli masa.” ");
INSERT INTO beo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isala:ili dunu da Sagode moilai yolesili, asili, wadela:i hafoga:i soge bega: doaga:i. Ilia da Ida:me sogega abula diasu gilisisu gaguli, ouesalu. ");
INSERT INTO beo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Esoga, Hina Gode da mumobi mogomogoi amo ganodini logo olelemusa:, ili bisili asi. Amola gasi ganodini E da lalu sawa: mogomogoi ganodini ilima hadigi olelemusa: bisili asi. Amalalu, ilia da eso amola gasia amoga hahawane ahoasu. ");
INSERT INTO beo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Eso huluane, mumobi mogomogoi da Isala:ili dunu bisili ahoanebe ba:i. Amola gasia huluane lalu sawa: mogomogoi agoane ili bisili ahoanebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Amalalu, Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Isala:ili dunuma sinidigima:ne sia:ma. Ilia da Baihahailode sogebi (amo da Migidole amola Maga:me Hano Wayabo amoga dogoa sogebi amola Ba:ilisifone gadenene galu) amoga ouesaloma:mu. ");
INSERT INTO beo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Felou da Isala:ili dunu da udigili sogega lalebe amola wadela:i hafoga:i soge ilia logo ga:i dagoi, amo e da dawa:mu. ");
INSERT INTO beo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Na da Felou ea odagi bu igi agoane hamomu. E da dilima doagala:le, se bobogemu. Be Na da Felou amola ea dadi gagui dunu hasalasimu. Amo ba:sea, Idibidi dunu da Na da Hinadafa amo dawa:mu.” Isala:ili dunu da Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Idibidi dunu da Felouma, Isala:ili dunu huluane da hobea:i dagoi olelei. Amalalu, e amola ea eagene ouligisu dunu da ilia asigi dawa:su sinidigili, amane sia:i, “Ninia da abuliba:le Isala:ili fi fisidigibala:? Ninia bidi mae lale udigili hawa: hamosu dunu fisi dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Amaiba:le, Felou da ea gegesu sa:liode, ea dadi gagui dunu amola gegesu liligi huluane momagele, ");
INSERT INTO beo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","e amola sa:liode da:iya fila heda:i noga:i dadi gagui dunu 600 agoane amola ilia ouligisu dunu, Isala:ili dunuma fa:no bobogei. ");
INSERT INTO beo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Isala:ili dunu da hahawane ahoanu. Be Hina Gode da Felou ea dogo ga:nasi hamoi amola e da Isala:ili dunuma se bobogei. ");
INSERT INTO beo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Idibidi dadi gagui wa:i, hosi, sa:liode amola sa:liode ouligisu dunu da Isala:ili dunuma se bobogei. Isala:ili dunu da Maga:me Hano Wayabo bega: Baihahailode amola Ba:ilisifone amo gadenene abula diasu gaguli ouesalu. Amogai, Idibidi dunu da ilima doagala:musa: doaga:i. ");
INSERT INTO beo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Isala:ili dunu da Felou amola ea dadi gagui dunu ilima doagala:musa: manebe ba:loba, ili beda:i bagade ba:i. Ilia da Hina Godema ili fidima:ne bagade wele sia:su. ");
INSERT INTO beo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ilia da Mousesema amane sia:i, “Bogoi uli dogomu da Idibidi sogega hame galula:? Di da abuliba:le nini bogomusa:, amo wadela:i sogega oule misibala:? Di da nini Idibidi sogega fisili masa:ne asunasiba:le, nini gugunufinisi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ninia da mae gadili asi amo esoga ninima misunu hou dima olelei dagoi. Ninia da di nini bu Idibidi dunu udigili hawa: hamomusa: yolesima, amo dima sia:i dagoi. Ninia da udigili hawa: hamone amola wadela:i hafoga:i soge amo ganodini hame bogomu da defea galu.” ");
INSERT INTO beo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mousese da bu adole i, “Mae beda:ma! Leloma! Amasea, dilia da wali eso Hina Gode Ea gasa bagade Gaga:su hou ba:mu. Dilia da amo Idibidi dunu bu hamedafa ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hina Gode Hi da dilia gegesu hamomu. Dilia hame! Dilia leloma!” ");
INSERT INTO beo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Hina Gode da Mousesema amane sia:i, “Di da abuliba:le Na fidisu lama:ne, adole ba:musa: dinanala:? Isala:ili dunuma ilia gaba:i masa:ne sia:ma! ");
INSERT INTO beo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Dia dagulu amo hano da:iya ligiagama. Hano da dogoa damuna asili osobo logo hamoi, hano hamedei dialebe ba:mu. Amasea, Isala:ili dunu da amo hafoga:i osobo logo amoga Maga:me Hano Wayabo degele masunu. ");
INSERT INTO beo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Be Na da Felou ea dogo ga:nasi hamobeba:le, e da Isala:ili dunu amo hano logo hamoi ganodini ilima se bobogemu. Amasea Na da Felou, ea dadi gagui dunu, ea sa:liode amola ea sa:liode ouligisu dunu ili hasalasimu. ");
INSERT INTO beo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Amasea, Na da Idibidi dunu hasanasisia, ilia da Na da Hina Godedafa amo dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Amalalu, Gode Ea a:igele dunu Isala:ili gilisisu amoga bisili ahoasu amo fisili, asili Isala:ili dunu ilia baligiduga asi. Mumobi mogomogoi da asili, ");
INSERT INTO beo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Isala:ili gilisisu baligiduga asili, Idibidi amola Isala:ili afafane gaga:su agoane hamoi. Mumobi dedeboiba:le, Idibidi dunu da gasi dunasi fawane ba:i. Be la:didili Isala:ili dunu da hadigi ba:i. Amoga afafaiba:le, Idibidi dadi gagui da Isala:ili dadi gagui amoga doagala:musa: misunu hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mousese da ea lobo hano da:iya ligia gadolaloba, Hina Gode da gasa bagade fo gusudili mabe amoga hano sefasi. Fo da gasi mae yolesili fofolalu, osobo logo hafoga:i dagoi ba:i. Hano da la:didili la:didili dogoa damuna asi. ");
INSERT INTO beo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isala:ili dunu da amo hafoga:i osobo logo amoga asili, Maga:me Hano Wayabo degei. Hano da la:didili amola la:didili dobea sali agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Idibidi dadi gagui, hosi amola sa:liode huluane da Isala:ili dunuma doagala:musa: ilima se bobogele, hano wayabo bagade golili sa:i. ");
INSERT INTO beo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Be eso mabe gadenenoba, Hina Gode mumobi mogomogoi amola lalu amo gadodili esalu da gudu ba:leguduli, Idibidi dadi gagui dunu wa:i ba:i dagoi. Ilia da beda:i bagadeba:le, ededenagia:i. ");
INSERT INTO beo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Gode da hamobeba:le, ilia sa:liode emo da bosona sa:ili, bai agoane ba:i. Ilia da bu masunu gogolei. Idibidi dunu da amane sia:i, “Hina Gode da Isala:ili dunumagale ninima gegenana! Hadiga! Ninia hobeamu da defea.” ");
INSERT INTO beo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Be Hina Gode da Mousesema amane sia:i, “Dia lobo amo hano da:iya bu ligiagama. Amalalu, hano da bu sinidigili, Idibidi dunu, ilia sa:liode amola genonesisu dunu huluane dedebomu.” ");
INSERT INTO beo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Amaiba:le, Mousese da ea lobo hano da:iya ligia gadole, amola eso mabe amoga hano da ea musa: defei amoga sinidigi dagoi. Idibidi dunu da hobeamu logo hogoi helei. Be Hina Gode da ili hano bagadega dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Hano da sinidigili, sa:liode, sa:liode fila heda:i dunu amola Idibidi dadi gagui ilia Isala:ili dunuma se bobogei, amo huluane dedeboi dagoi. Idibidi dunu afae esalebe hame ba:i. ");
INSERT INTO beo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Be Isala:ili dunu huluane da hafoga:i logoga emoga asili, hano bagade degei dagoi. Hano da la:didili, la:didili dobea sali agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Amo esoga, Hina Gode da Isala:ili dunu amo Idibidi dunuma gaga:i dagoi, amola Isala:ili dunu da Idibidi dunu ilia bogoi da:i hodo hano bagade bega: dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Hina Gode da Ea gasa bagade amoga Idibidi dadi gagui hasali dagoi. Isala:ili dunu da amo hou ba:beba:le, Godema beda:i galu. Amola ilia da Hina Gode ea hou dafawaneyale dawa:i. Amola Hina Gode Ea hawa: hamosu dunu Mousese, amo ea hou dafawaneyale dawa:i. ");
INSERT INTO beo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Amalalu, Mousese amola Isala:ili dunu da Hina Godema gesami hea:i amane, “Na da Hina Godema gesami hea:mu. Bai E da hasalasu bagade hamoi dagoi. E da hosi amola amoga fila heda:i dunu hano bagadega ha:digi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Hina Gode da na gasa bagade Gaga:su dunu E da na gaga:i dagoi. E da na Gode amola na da Ema nodomu E da na ada ea Gode, amola E da Ea hou bagadedafa hamobeba:le na da gesami hea:mu ");
INSERT INTO beo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hina Gode da gegesu dunu. Ea Dio da Hina Godedafa. ");
INSERT INTO beo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","E da Idibidi dadi gagui gilisisu amola ilia sa:liode hanoga gala:digi. Idibidi dadi gagui ouligisu dunu noga:idafa da Maga:me Hano Wayabo amoga bogole gela sa:i. ");
INSERT INTO beo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Hano bagade nugududafa da ilia da:i hodo dedeboi dagoi. Ilia da igi agoane gela sa:ili, hano haguduga doaga:i. ");
INSERT INTO beo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Hina Gode! Dia lobodafa da gasa bagadeba:le, ninia beda:iwane ba:sa. Dia lobodafa da ha lai dunu amo fifili goudasa. ");
INSERT INTO beo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Di da hadigi amola hahawane Dima ha lai amo wadela:sa. Dia ougi da lalu defele. Dima ha lai ilia da samaso bioi defele Dia laluga ulagisa. ");
INSERT INTO beo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Di da hano bagadega fulaboiba:le, hano da gafululi bi hamoi. Hano da wa:legadole, dobea salidi agoane ba:i. Hano hagududafa da ga:nasi amola hafoga:i agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ha lai da amane sia:i, ‘Na da ilima doagala:musa: se bobogele, baligimu. Na da ilia liligi huluane lale, afafane, ni hanaiga lamu. Na da na gegesu gobihei bagade duga:le gadole, ilia liligi huluane samogele lamu.’ ");
INSERT INTO beo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Be Hina Gode, Di da mifo afadafa fulabosea, Idibidi dunu huluane da hanoga na dagoi ba:i. Hano bagade beda:su liligi amo ganodini, ilia da lede (dioi bagade ouli liligi) amo defele gela sa:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Hina Gode! Di da ‘gode’ liligi huluane bagadewane baligi dagoi. Dia hadigi da dunu huluane ilia hou bagadewane baligisa. Di da musa: hame ba:su gasa bagade hou hamomusa: defele esala. Eno dunu da Dia hou defele hamomu hamedei agoane ba:sa. ");
INSERT INTO beo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Di da Dia lobodafa ligia gadoloba, osobo bagade da ninima ha lai amo da:gi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Dia musa: sia:i defele, Di da dunu Di gaga:i, ilima bisili ahoanu, oule asi dagoi. Dia gasaga, Di da ilima logo olelemu. Amola Dia hadigi soge amoga oule masunu. ");
INSERT INTO beo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dunu fifilai da nabimu. Amola, ilia beda:iba:le, yagugumu. Filisidini dunu da beda:ga bogomuwane. ");
INSERT INTO beo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idome hina bagade dunu da beda:i bagade ba:mu. Moua:be gasa bagade dunu da beda:iba:le yagugumu. Ga:ina:ne dunu da ilia gesa:i hou fisili, beda:i bagade ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ilia huluanema beda:su hou bagade da doaga:i dagoi. Ilia da Dia gasa, Hina Gode, ba:lala. Amabeba:le, ilia da gogaya:i agoane lela. Amogainini Dia fi dunu amo Di da ilia se iasu diasu logo doasili, ga masa:ne asunasi, ilia da mogodigili ahoanebe ba:sea. ");
INSERT INTO beo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Hina Gode! Di da goumi amoga Dia fisu hamoma:ne ilegei dagoi. Amoga Di da dia fi oule asili ilia fima:ne hahamonana. Amogai da Debolo Diasu gagui dagoi. ");
INSERT INTO beo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Di, Hina Gode, da eso huluane Hina Bagadedafa esalalalumu.” ");
INSERT INTO beo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Isala:ili dunu da osobo hafoga:i amoga asili Maga:me Hano Wayabo degei dagoi. Be Idibidi dunu, hosi, sa:liode amola sa:liode genonesisu dunu da amo logoga ahoanoba, Hina Gode da hano sinidigili, ilia huluane dedeboi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ba:la:lusu uda amo Milia:me (Elane ea dalusi) da hina gisani amo lai amola Isala:ili uda huluane da ema fa:no bobogei. Ilia da gisani gaguli sisiogola afia:i. ");
INSERT INTO beo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Milia:me da ilima amane gesami hea:i, “Hina Godema gesami hea:ma. Bai E da hahawane baligili hasalasu hamoi dagoi. E da hosi amola ilima fila heda:i dunu, amo hano wayabo bagadega ha:digi dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Amalalu, Mousese da bisili asili, Isala:ili dunu Maga:me Hano Wayabo yolesili, Siua wadela:i hafoga:i soge amoga oule asi. Eso udiana ilia da wadela:i soge ganodini lalu, be hano hame ba:i. ");
INSERT INTO beo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Amalalu, ilia sogebi ea dio amo Mala amoga doaga:i. Be amogai hano da gamogaiba:le, manu da hamedei ba:i. Amaiba:le, ilia amo sogebiga Mala (Gamogai) dio asuli. ");
INSERT INTO beo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Isala:ili dunu da da:i dioiba:le Mousesema gegene i. Ilia da amane sia:i, “Ninia da adi hano moma:bela:?” ");
INSERT INTO beo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mousese da ha:giwane Hina Godema sia:ne gadoi. Amalalu, Hina Gode da ema ifa olelei. Mousese da amo ifa hano ganodini ha:digili, hano da afadenene, bu noga:iwane ba:i. Amogai, Hina Gode da ili hahawane esaloma:ne sema eno ilima i dagoi amola ilima ado ba:su hou hamosu. ");
INSERT INTO beo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","E amane sia:i, “Dilia da dafawane nabasu hou hamosea amola moloidafa hou hamobeba:le Na hamoma:ne sia:i huluane amoma fa:no bobogesea, Na da dilima se nabasu hame imunu. Dilia da olo bagade na da Idibidi dunuma i, amo hame ba:mu. Na da Hina Gode, dili Uhinisisu Dunu.” ");
INSERT INTO beo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Isala:ili dunu da bu asili, Ilimi sogega doaga:i. Amogai gufi hano fana:iyado amola gumudi agoai ifa 70 ba:i. Amogai ilia da hano gadenene abula diasu gilisisu gaguli esalu. ");
INSERT INTO beo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isala:ili fi huluane da Ilimi soge yolesili, logoga asi. Ilia da Idibidi yolesili oubi aduna logoga asi. Eso ba: (15) amo oubi ganodini, ilia da wadela:i hafoga:i soge amo Sini amoga doaga:i. La:di da Ilimi amola la:di da Sainai. Sini soge da mogoa dialu. ");
INSERT INTO beo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Amogai, wadela:i soge amoga, ilia da Mousese amola Elane elama sia:ga gegene egai. ");
INSERT INTO beo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ilia da elama amane sia:i, “Hina Gode da nini huluane Idibidi soge ganodini medole legemu da defea galu. Amogai ninia da fili, hu amola ha:i manu eno, ninia hanai amo defele manusa: dawa:i galu. Be alia da nini amo wadela:i hafoga:i soge amoga ha:ga bogoma:ne oule misi dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Hina Gode da Mousesema amane sia:i, “Na da wali agoane hamomu. Ha:i manu da gibu agoane muagado dilima sanasimu. Dunu da eso huluane ilia amo esoga nasu defele ha:i manu lidimusa: masunu. Amasea, Na da ilia hou ado ba:mu. Ilia da Na sia: nabawane hamoma:bela:? ");
INSERT INTO beo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Eso gafe amoga, ilia da eso aduna defele ha:i manu diasuga gaguli misa:ma.” ");
INSERT INTO beo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Amaiba:le, Mousese amola Elane da Isala:ili dunu huluane ilima amane sia:i, “Wali daeya dilia Hina Gode da dili Idibidi sogega fisili masa:ne asunasili, guiguda: oule misi, amo dilia da noga:le dawa:mu. ");
INSERT INTO beo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Hahabe dilia da Hina Gode Ea hadigi sinenemigi bagade ba:mu. E da dilia Ema sia:ga egasu nabi dagoi. Dafawane! Amo egasu da Godema sia:ga gegesu. Ania da Ea sia: nabawane hamosu fawane.” ");
INSERT INTO beo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Amalalu, Mousese da amane sia:i, “Hina Gode da daeya hu dilima imunu amola hahabe agi dilia hanai defele amo dilima imunu. Bai E da dilia Ema egasu nabi dagoi. Dilia da anima sia:ga gegesea, dilia da dafawane Hina Gode Ema fawane sia:ga gegesa.” ");
INSERT INTO beo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mousese da Elanema amane sia:i, “Isala:ili dunu fi huluane misa:ne amola Gode ba:ma:ne leloma:ne sia:ma. Bai E da ilia egasu nabi dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Elane da Isala:ili dunu fi huluane ilima sia:noba, ilia da delegili wadela:i soge amoga ba:le, hedolowane Hina Gode Ea hadigi sinenemigi baligili bagadedafa mumobi ganodini dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Na da Isala:ili dunu ilia egasu nabi dagoi. Ilia da daeya hu manu ba:mu amola hahabe agi ilia sadimusa: defele ba:mu, amo ilima adoma. Amasea, ilia da Na da ilia Hina Gode, amo dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Daeya, sio fi ilia dio ‘gowa:ili’ amo wa:i bagadewane da misini amola ilia abula moilai dedeboi dagoi. Amola hahabe oubi baiya agoane ilia esalebe sogega sa:i dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Oubi baiya da esoga hafoga:loba, liligi amo da sua: agi fonobahadi amo osoboga dialebe ba:i. Amo liligi da asaboi mugene o gagoma fage agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isala:ili dunu da amo ba:loba, amo ea hou hame dawa:beba:le, amane gilisili sia: dasu, “Goe adila:?” (‘ma:na’ dawa:loma:ne da “Goe adila:?”) Mousese da ilima bu adole i, “Amo da ha:i manu Hina Gode da dilima i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hina Gode da agoane sia:sa. Dili da dili manu defele amo liligi lidima. Dunu amola uda amola mano afae afae ofodo fonobahadi (‘lida’ aduna defei agoane) amo defele lama:mu.” ");
INSERT INTO beo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isala:ili dunu da Mousese ea sia: defele hamoi. Oda da bagade lidi, oda da fonobahadi lidi. ");
INSERT INTO beo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Be lidi liligi ea defei ba:loba, dunu da bagade lidi da baligili lai dagoi hame ba:i amola nowa da fonobahadi lidi amo ea lai da defele ba:i dagoi. Dunu huluane da e sadima:ne lai dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mousese da ilima amane sia:i, “Amo ha:i manu aya manusa: mae ligisima.” ");
INSERT INTO beo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Be oda da Mousese ea sia: mae nabawane, ha:i manu mogili aya manusa: ligisi. Be aya hahabe amo da dasaiba:le gaha bagade nabi amola ifidi amoga nabai ba:i. Amo ba:beba:le, Mousese da ilima ougi galu. ");
INSERT INTO beo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Hahabe huluane, dunu huluane da e sadima:ne, ‘ma:na’ lidi dagoi. Amola eso da gia:noba, hame lidi liligi osoboga dialu da daeane ebelei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Eso gafe amoga ilia da eso aduna moma:ne defele dunu afae afae da ofodo fonobahadi aduna lidi (‘lida’ biyadu agoane). Isala:ili asigilai ouligisu ilia da Mousesema amo hou adola misi. ");
INSERT INTO beo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Amola e da ilima amane sia:i, “Hina Gode da amane sia:sa, ‘Aya eso fesu eso da Ema dawa:ma:ne helefisu eso ganumu.’ Wali eso dilia hanaiga ha:i manu gobema amola gia:ma. Ha:i manu hame mai diala amo aya manusa: ligisima.” ");
INSERT INTO beo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ilia da Mousese ea sia: defele hamoi. Ha:i manu hame mai dialu ilia da aya manusa: ligisi. Amo da hame dasai amola ifidi da amoga hame sa:i. ");
INSERT INTO beo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mousese da amane sia:i, “Amo ha:i manu wali wega moma. Bai wali da Sa:bade eso, amo helefisu eso Hina Godema dawa:ma:ne hamoi. Dilia diasu gadili ha:i manu hame ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Dilia da eso gafeyale gala amoga ha:i manu lidima. Be eso fesu amoga, amo da helefisu eso, amola dilia da ha:i manu hame ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Be eso fesu amoga, dunu mogili da gadili ha:i manu hogola asi. Be amo ilia hame ba:i. ");
INSERT INTO beo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Amalalu, Hina Gode da Mousesema amane sia:i, “Isala:ili fi da habogala gasa fi hou fisili Na sia: noga:le nabima:bela:? ");
INSERT INTO beo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mae gogolema! Na, Hina Gode, da dilima helefisu eso i dagoi. Amaiba:le, Na da eso gafeyale amoga mae fisili dilima ha:i manu eso adunaga moma:ne defele dilima imunu. Dunu huluanedafa da eso fesu amoga hi diasu mae fisili, helefima:ne esaloma:mu. ");
INSERT INTO beo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Amaiba:le, Isala:ili dunu da eso fesu amoga hawa: hame hamosu. ");
INSERT INTO beo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isala:ili dunu da amo ha:i manu ‘ma:na’ dio asuli. E da fage ahea:ya:i fonobahadi agoane ba:i. Ea gamini nasu da agi gobei amola agime hano gilisi agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mousese da amane sia:i, “Hina Gode da ninima amane sia:i, ‘Ma:na’ mogili diligaga fi ba:ma:ne la:didili ligisima. Ilia ha:i manu amo Hina Gode da dilia Idibidi sogega gadili oule asili, wadela:i soge amoga dilia moma:ne i, amo ilia ba:mu da defea.” ");
INSERT INTO beo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Amalalu, Mousese da Elanema amane sia:i, “Di ofodo agoai osoboga hamoi ‘lida’ aduna defei agoane amo lale, ‘ma:na’ amo ganodini salima. Amalalu, Hina Gode ba:ma:ne noga:le ligisima. Amasea, fa:no ninigaga fi da amo liligi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Hina Gode da Mousesema sia:i amo defele, Elane da amo lale, dialoma:ne Gode Ea Gousa:su Sema Gagili ea ba:le gaidiga ligisi. ");
INSERT INTO beo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isala:ili dunu da ode 40 eno amoga ‘ma:na’ nasu. Amogainini ilia Ga:ina:ne sogega doaga:le esalu. ");
INSERT INTO beo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Amo esoga, hafoga:i sema defei ilegei da 20 ‘lida’ agoane ba:i.) ");
INSERT INTO beo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isala:ili fi huluane da wadela:i hafoga:i soge Sini amo yolesili, asili, Hina Gode Ea Sia: defele soge eno eno amoga asi. Ilia da Lefidimi sogega fonobahadi fimusa: esalu, be hano manu hame ba:i. ");
INSERT INTO beo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ilia da Mousesema egane, amane sia:i, “Ninia moma:ne hano ninima ima.” Mousese da bu adole i, “Dilia da abuliba:le egale sia:ga gegesala:? Dilia abuliba:le Hina Godema ado ba:su hou hamosala:?” ");
INSERT INTO beo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Be Isala:ili dunu da bagadewane hano hanai galu. Ilia da Mousesema mae fisili sia:ga gegenanu. Ilia da amane sia:i, “Di da abuliba:le nini Idibidi sogega fisili asunasili, guiguda: oule misibala:? Di da nini, ninia mano amola ninia lai gebo fanelegemu hanabela:?” ");
INSERT INTO beo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mousese da ha:giwane Godema amane digini sia:ne gadoi, “Isala:ili dunu fi da na igiga medole legemusa: gadenenewane momagele esala. Na da ilima adi hamoma:bela:?” ");
INSERT INTO beo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Hina Gode da Mousesema amane sia:i, “Di Isala:ili fi ouligisu dunu mogili oule asili, Isala:ili fi ilima bisili masa. Dia dagulu amoga di da Naile Hano fai, amo gaguli masa. ");
INSERT INTO beo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Di da Na, Sainai Goumi gadenene dia midadi igi da:iya lelebe ba:mu. Di da amo igiga misini, dia daguluga magufu damana fane, hano nawa:li dunu huluane moma:ne defele, magufudi manebe ba:mu.” Mousese da amo hou Isala:ili dunu huluane ba:ma:ne hamoi. ");
INSERT INTO beo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Amo sogebi amoma ilia dio aduna asuli, amo Ma:sa amola Meliba. (dawa:loma:ne da ‘ado ba:su’ amola ‘sia:ga gegesu’). Bai amoga Isala:ili dunu da sia:ga gegei amola Hina Godema ado ba:su hou hamoi. Ilia da amane adole ba:i, “Hina Gode da ninimagale esalabala?” ");
INSERT INTO beo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Isala:ili dunu da Lefidimi sogega esaloba, A:malege dunu da ili doagala:i. ");
INSERT INTO beo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mousese da Yosiuama amane sia:i, “Dia dunu aya A:malege dunuma gegemusa: ilegema. Na da dagulu amo Gode da na gaguli masa:ne sia:i, amo gaguiwane na da agolo da:iya lelumu.” ");
INSERT INTO beo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosiua da Mousese ea sia:i defele hamoi. E da A:malege dunuma gegemusa: asi. Mousese, Elane amola He da agoloba:le heda:i. ");
INSERT INTO beo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Amalalu, Mousese da ea lobo gaguia gadoloba, Isala:ili dunu da A:malege dunuma hasali. Be Mousese da ea lobo bu ligia gudusia, A:malege dunu da bu gasa bagade ludubiba:le, Isala:ili dunuma hasalimu ba:i. ");
INSERT INTO beo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mousese ea lobo da helebeba:le, Elane amola He da igi bagade amo da:iya Mousese fima:ne, gaguli misi dagoi. Ela da Mousese la:didili amola la:didili dafulili leluwane, Mousese ea lobo mae ligia guduma:ne, ea lobo gaguia gadole gagui. Amo hou hamonana, eso dabeba:le fawane yolesi. ");
INSERT INTO beo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Amo hou hamobeba:le, Yosiua da A:malege dunu hasali dagoi. ");
INSERT INTO beo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Amalalu, Hina Gode da Mousesema amane sia:i, “Dilia da A:malege dunu ilima hasali amo mae gogolema:ne di amo hou meloaga dedene legema. Amola Yosiuama adoma. Na da A:malege dunu huluane osobo bagadega mae ba:ma:ne, ili dafawane gugunufinisimu.” ");
INSERT INTO beo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mousese da amogai oloda bi hamone, amoma dio asuli amo, “Hina Gode da na eso Gosagisu.” ");
INSERT INTO beo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","E amane sia:i, “Dunu da Gode Ea Fisu amoma gegemusa: dawa:i galu. Amaiba:le, Hina Gode da A:malege dunu ilima mae yolesili eso huluane gegenanumu.” ");
INSERT INTO beo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mousese esoa: Yedelou (Midia:ne gobele salasu dunu) da Gode da Mousese amola Isala:ili fi dunu Idibidi sogega gadili oule misini, noga:le fidisu, amo huluane nabi. ");
INSERT INTO beo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","4","- Amaiba:le, e da Mousesema sofe misi. E da Mousese idua Siboula (Mousese da musa: e Midia:ne sogega fisi) amola ea mano aduna amo Gesiome amola Elia:isa oule misi. (Mousese da musa: sia:i dagoi, “Na da Midia:ne soge ganodini ga fi esala.” Amaiba:le, e da egefema Gesiome (ga fi dunu) dio asuli. E da eno sia:i, “Na ada ea Gode da fidibiba:le, na da Idibidi hina bagade amoga hame fanelegei ba:i. Amaiba:le, egefe eno amoma e da Elia:isa Gode da na fidilala amo dio asuli.) ");
INSERT INTO beo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mousese da wadela:i hafoga:i soge hadigi goumi gadenene amogai esalu. Amoga, Yedelou da Mousese idua amola egefela oule misi. ");
INSERT INTO beo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","E da mae doaga:le, Mousesema sia: adole iasi. ");
INSERT INTO beo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Amaiba:le, Mousese da ema yosia:musa: asili, ema beguduli amola nonogoi. Ela, “Di da hahawane esalala:?,” sia:nanu, ela da Mousese ea Abula Diasu ganodini golili sa:i. ");
INSERT INTO beo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mousese da Yedelouma Hina Gode Ea hou hamobe Felouma amola Idibidi dunuma amola Isala:ili dunu gaga:ma:ne amo huluane olelei dagoi. E da Isala:ili dunu logoga ahoanebe se nabasu amola Hina Gode Ea fidisu huluane olelei. ");
INSERT INTO beo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yedelou da amo sia: huluane hahawane nabi. ");
INSERT INTO beo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","E amane sia:i. “Hina Godema nodoma! E da di amola Ea fi huluane noga:le fidi. E da ili Felou amola Idibidi dunu ilima gaga:ne, ilia se iasu diasu logo doasi dagoi. Godema nodoma! ");
INSERT INTO beo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Idibidi dunu da Isala:ili dunuma higale hamobeba:le, Hina Gode da amo hou hamoi dagoi. Amaiba:le, Hina Gode Ea hou da eno ‘gode’ liligi ilia hou bagade baligisa, amo na da wali dawa:.” ");
INSERT INTO beo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Amalalu, Yedelou da gobele salasu ohe amo mae fifili gogo gobemusa:, Godema imunusa: gaguli misi. Amola e da eno gobele salasu liligi gaguli misi. Elane amola Isala:ili fi ouligisu dunu huluane da Yedelou gilisili, Godema nodone sia:ne gadomusa:, sema lolo manusa: asi. ");
INSERT INTO beo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Aya esoga, Mousese da Isala:ili dunu fi ilia sia:ga gegesu liligi fofada:nanu. E da hahabe fofada:nanu, mae yolesili gasimu galu. ");
INSERT INTO beo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yedelou da Mousese ea hawa: hamosu bagade ba:beba:le, amane adole ba:i, “Di abuliba:le disu amo dia fi dunu agoane fidisala. Disu da hamonana amola dunu huluane eso huluane hahabe asili gasi, dima fofada:musa: lela.” ");
INSERT INTO beo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mousese da amane sia:i, “Na da agoane hamomu da defea. Dunu ilia da Gode Ea hanai amo dawa:musa:gini nama maha. ");
INSERT INTO beo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Dunu aduna da sia:ga gegesu galea, ela da nama maha. Amasea, na da elama afae da moloi amola eno da giadofai amo elama olelesa. Amola na da Gode Ea hamoma:ne sia:i elama olelesa.” ");
INSERT INTO beo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Amalalu, Yedelou da amane sia:i, “Di da giadofale hamosa. ");
INSERT INTO beo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Di da dia da:i hodo amola eno dunu ilia da:i hodo wadela:mu. Disu hamomu da hamedei. ");
INSERT INTO beo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Na da dima fada:i sia: noga:i imunu. Amasea, Gode da di fidimu. Di da dunu ilia sia:ga gegesu nabimu amola Gode amola ili dogoa agoane alofesu dunu esalumu da defea. ");
INSERT INTO beo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Di da Gode Ea hamoma:ne sia:i ilima olelemu amola ilia habodane esalumu amola hawa: hamosu ilima olelemu amo huluane da defea. ");
INSERT INTO beo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Be amo baligili, di da dunu noga:i bagade dawa:su dunu ilegele, ilia da dunu huluane ilima ouligisu hina dunu ilegemu da defea. Ilia dunu fi idi 1000 amola dunu fi idi 100 amola idi 50 amola idi 10 amola ilima ouligisu hina ilegema:mu. Godema beda:i dunu fawane lama amola dunu da hano suligisu hou hame dawa: dunu, amo fawane ilegema. ");
INSERT INTO beo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ilia mae yolesili fofada:su ouligisu dunu agoane hawa: hamoma:mu. Hou da gasa bagade ba:sea, ilia da di hahamoma:ne, dima adola misunu da defea. Be liligi fonobahadi ilisu da fofada:mu da defea. Ilia da dia dioi bagade liligi gilisili gaguli ahoasea, dia dioi liligi da bu fofoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Di da Gode Ea sia: defele agoane hamosea, di da bogomuwane hele hame nabimu amola dunu huluane da ilia sia:ga gegei huluane hahamoi dagoi ba:sea, ilia diasuga hahawane masunu.” ");
INSERT INTO beo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mousese da Yedelou ea olelesu nabi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","E da Isala:ili fi amoga noga:i dawa:su dunu ilegei. E da dunu idi 1000 amola idi 100 amola idi 50 amola idi 10 ilima ouligisu hina dunu ilegei. ");
INSERT INTO beo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ilia da mae yolesili fofada:su ouligisu hawa: hamosu. Gasa bagade fofada:su, ilia da Mousesema ia misi. Be ilisu da fonobahadi liligi hahamoi. ");
INSERT INTO beo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Amalalu, Mousese da Yedelouma “asigibio” sia:nanu, Yedelou da hi diasuga buhagi. ");
INSERT INTO beo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Isala:ili dunu fi da Lefidimi soge yolesili, asili, eso age oubi osoda (amoga ilia Idibidi yolesili fa:no) ilia da Sainai wadela:i hafoga:i soge amoga doaga:i. Ilia da Sainai Goumi ea bai gadenene, ilia abula diasu huluane gaguli esalu. ");
INSERT INTO beo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Amalalu, Mousese da Gode gousa:musa:, goumiba:le heda:i. Hina Gode da goumi amoga wesu. E da amane sia:i, “Dia Isala:ili fi dunu, Ya:igobe egaga fi, ilima amane sia:ma; ");
INSERT INTO beo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Na! Hina Gode! Na da Idibidi dunuma gasa bagade hamoi. Buhiba da ea mano amo ea ougia da:iya gaguli ahoa. Amo defele, Na da dili guiguda gaguli misi. Amo huluane dilia da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Wali, dilia da Na sia: noga:le nabasea, amola Na gousa:su noga:le ouligisia, Na da dili Na fidafa hamomu. Osobo bagade huluanedafa da Na:. Be dilia da Na ilegei fidafa esalumu. ");
INSERT INTO beo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Dilia da Nisu Na fi Nama gobele salasu hou hamoma:ne Na ilegei dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Amalalu, Mousese da sa:ili, ouligisu dunu huluane gilisili, ilima Hina Gode Ea sia: defele adoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Amalalu, dunu huluane gilisili amane sia:i, “Ninia da Hina Gode Ea sia:i amo defele nabawane hamomu.” Mousese da amo hou Hina Godema adole i. ");
INSERT INTO beo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Hina Gode da Mousesema amane sia:i, “Na da mumobi haguli bagade amoga dima sia:mu. Amasea, dunu huluane da Na dima sia: dalebe nabasea, dia hou fa:no dafawaneyale dawa:mu.” Mousese da Isala:ili dunu fi ilia bu adole iasu amo Hina Godema olelei dagoi. ");
INSERT INTO beo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Amola Hina Gode da ema amane sia:i, “Di da dunu fi ilima amane olelema. Ilia wali amola aya Nama nodone sia:ne gadomusa:, ledo liligi huluane dodofema:mu. Ilia da abula noga:le dodofema:mu. ");
INSERT INTO beo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Gasida ilia huluane dodofei dagole ha:esalebe ba:mu. Gasida Na da gudu sa:ili, Sainai Goumi da:iya lelebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Dia goumi sisiga:le, alalo ilegema. Isala:ili dunu ilia da amo alalo mae giadofama:ne sia:ma. Ilia da goumiba:le mae heda:ma:ne amola gadenene mae misa:ne, amo ilima adoma. Nowa dunu da ea emoga goumi da:iya osa:le heda:sea, amo fanelegema. ");
INSERT INTO beo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Amo dunu igiga medoma o dadiga gala:ma. Be dunu eno da ea da:i maedafa digili ba:ma:ne sia:ma. Amo hou da dunu amola ohe fi ilima hamoma. Udigili fanelegei dagoi ba:mu. Be dalabede fulabosu nabasea, dunu fi da goumiga masunu da defea.” ");
INSERT INTO beo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Amalalu, Mousese da goumiba:le sa:ili, dunu fi da Godema nodone sia:ne gadomusa:, ha:esaloma:ne sia:i. Amaiba:le, ilia da abula dodofei. ");
INSERT INTO beo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Amola Mousese da ilima amane sia:i, “Dilia! Gasida dilia ha:esaloma! Amola, amoga ha:esalumusa:, uda amola dunu gilisili mae golama.” ");
INSERT INTO beo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Eso osodaga, hahabe, gugelebe amola ha:ha:na ba:i. Goumi da:iya mumobi bagade ba:i amola dalabede gasa bagade fulaboi nabi. Dunu huluane abula diasu gaguli gagai ganodini da bagade beda:iba:le, yagugui. ");
INSERT INTO beo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mousese da ea fi dunu bisili, diasu gadili Godema gousa:musa: oule asi. Ilia da goumi ea bai amoga asili lelu. ");
INSERT INTO beo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sainai Goumi da lalu mobi amoga dedeboi dagoi ba:i. Bai Hina Gode da lalu defele goumiga sa:i dagoi. Mobi da lalu bagade ea mobi defele heda:i amola dunu huluane da bagadewane yagugui. ");
INSERT INTO beo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Dalabede ea fulabosu da bu baligili bagade nabi. Mousese da sia:i, amola Gode da gugelebe amoga ema bu adole i. ");
INSERT INTO beo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Hina Gode da Sainai Goumi amo da:iya gadodili sa:i. E da amogai misa:ne Mousesema sia:i. Mousese da goumiba:le heda:i. ");
INSERT INTO beo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Amalalu, Hina Gode da ema amane sia:i, “Di gudu sa:ili, dunu fi ilima sisasu olelema. Ilia da sisiga:i alalo ilegei mae giadofama:ne sia:ma. Amai galea, ilia da bagohame bogomu. ");
INSERT INTO beo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Gobele salasu dunu amola! Ilia Nama gadenene misunu dawa:sea, hidadea ilia ledo noga:le dodofema:mu. Amane hame hamosea, Na da ilima se nabasu imunu.” ");
INSERT INTO beo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mousese da Hina Godema amane sia:i, “Ninia dunu fi da goumiba:le heda:mu da hamedei. Bai Di da ninima amane adoi. Goumi da afafai dagoi, sema gala. Dia da ninima goumi bai sisiga:le, alalo ilegema:ne sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Hina Gode da bu adole i, “Di gudu sa:ili, Elane guiguda: oule misa. Be gobele salasu dunu amola dunu eno huluane amo sisiga:i alalo ilegei mae giadofama:ne sia:ma. Ilia da amo giadofasea, Na da ilima se nabasu imunu.” ");
INSERT INTO beo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Amalalu, Mousese da gudu sa:ili, Hina Gode Ea sia:i amo ilima adoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Gode da amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Na da dilia Hina Gode. Dilia da Idibidi soge ganodini udigili hawa: hamosu dunu esalu. Be Na da dili gadili oule asi. ");
INSERT INTO beo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","(1) Dilia eno ‘gode’ agoane liligi ilima mae nodone sia:ne gadoma. ");
INSERT INTO beo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","(2) Dilia Godema dawa:ma:ne, osobo bagade liligi agoaila o mu amoga agoaila maedafa hamoma. ");
INSERT INTO beo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Loboga hamoi ‘gode’ liligi ilima mae beguduma amola mae nodone sia:ne gadoma. Bai Na da dilia Hina Gode amola Na da nowa da Na defele hi dawa:sa, amo dunu higasa. Nowa da Na higasea, ema Na da se nabasu imunu amola egaga fi amo asili fi osodayale amola biyaduyale egaga fi ilima se nabasu imunu. ");
INSERT INTO beo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Be nowa da Nama asigi galea amola Na hamoma:ne sia:i nabawane hamosea, Na da ema amola egaga fi osea:idafa ilima asigi hou olelemu. ");
INSERT INTO beo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","(3) Na Dio amo mae giadofale sia:ma amola udigili mae sia:ma. Na, Hina Gode da nowa Na Dio udigili sia:sea, ilima se nabasu imunu. ");
INSERT INTO beo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","(4) Sa:bade eso da hadigi eso. Amaiba:le, Sa:bade eso ea hou mae giadofama! ");
INSERT INTO beo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Eso gafeyale gala amoga hawa: hamoma. ");
INSERT INTO beo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Be eso fesu da Nama dawa:ma:ne helefisu eso gala. Amo esoga, dunu huluanedafa da hawa: hamosu hame hamoma:mu. Amo di, dia mano, dia udigili hawa: hamosu dunu, dia ohe fi amola ga fi dunu dia soge ganodini esala huluanedafa, mae hawa: hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Na, Hina Gode da eso gafeyale gala amoga osobo bagade, mu, wayabo bagade amola amo ganodini liligi huluane hamoi dagoi. Be eso fesu amoga Na da helefi dagoi. Amaiba:le, Na da Sa:bade eso hahawane dogolegei amola sema hadigi ilegei dagoi. ");
INSERT INTO beo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","(5) Dia ada amola ame elama nodone asigima. Bai di agoane hamosea, di da soge amo Na da dilima imunu, amo ganodini ode bagohame esalumu. ");
INSERT INTO beo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","(6) Eno dunu mae medole legema. ");
INSERT INTO beo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","(7) Inia uda mae adole lama. ");
INSERT INTO beo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","(8) Wamolasu hou mae hamoma. ");
INSERT INTO beo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","(9) Eno dunu amo mae ogogole diwaneya udidima. ");
INSERT INTO beo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","(10) Dia dogo ganodini inia liligi lamusa:ne mae dawa:ma. Eno dunu ea diasu o ea uda o ea udigili hawa: hamosu dunu o ea dougi o liligi huluanedafa amo mae hananelamusa: dawa:ma. ");
INSERT INTO beo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Dunu huluane da gugelebe amola dalabede fulabosu nabaloba, amola ha:ha:na amola goumia lalu mobi ba:loba, ilia da beda:iba:le yagugui amola sedagawane lelu. ");
INSERT INTO beo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ilia da Mousesema amane sia:i, “Di da ninima sia:sea, ninia da nabimu. Be ninia da bogosa:besa:le, Gode da ninima sia:mu ninia higa:i.” ");
INSERT INTO beo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mousese da bu adole i, “Mae beda:ma! Gode da dilima ado ba:musa: misi dagoi. E da dilia hou amo dilia da Ea sia: noga:le nabima:bela:? amola wadela:i hou hame hamoma:bela:? E da amo ado ba:musa: misi.” ");
INSERT INTO beo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Be dunu huluane da gadenene hame misi, sedagawane lelu. Mousese hi fawane da bunumai mumobi mogomogoi Gode esalebe sogebi amo gadenene asi. ");
INSERT INTO beo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Hina Gode da Mousese amo Isala:ili dunuma amane sia:musa: sia:i, “Na, Hina Gode da Hebene amoga dilima sia:i. Amo dilia da ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Dilia gouli o silifa ‘gode’ agoane liligi ilima nodone sia:ne gadomusa: maedafa hamoma. ");
INSERT INTO beo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Dilia osobo ganumugini, oloda bi hamoma. Amo da:iya, dilia sibi amola bulamagau gobele salasu hamoma:ne amola dilia gilisili na:iyado hahawane hamoma:ne, gogo gobele salima. Adi sogebi dilia Nama nodone sia:ne gadomusa: Na da ilegesea, Na da dilima hahawane fidimusa: misunu. ");
INSERT INTO beo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Dilia da Nama oloda igiga hamosea, amo igi mae debema o hedofama. Di da igi gobihei o eno liligi amoga hedofasea, Nama imunu da hamedei. ");
INSERT INTO beo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Oloda hamosea, amo da:iya heda:ma:ne fa:gu mae hamoma. Di da amo heda:sea dia gogosiasu ba:sa:besa:le, fa:gu mae gaguma.” ");
INSERT INTO beo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Hina Gode da eno amane sia:i, “Isala:ili dunuma amo hamoma:ne sia:i olelema; ");
INSERT INTO beo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Di da Hibulu udigili hawa: hamosu dunu bidi lasea, e da ode gafeyale amoga dia hawa: hamomu. Ode fesu amoga, e da hahawane halegale ahoanoma:ne, ea logo doasima. E da dima dabe hame ima:mu. ");
INSERT INTO beo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","E da dia hawa: hamosu lasea uda hamelai galea, e da ahoasea, uda mae lalewane masunu. Be e da dia hawa: hamosu lasea udalai galea, defea, e da ahoasea uda amola oule masunu. ");
INSERT INTO beo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ea ouligisu dunu da ema uda ia galea, amo e da amo udama dunu mano o uda mano lalelegesea, amo uda amola ea mano da ea hina ea:. Udigili hawa: hamosu dunu hi fawane da fisili masunu. ");
INSERT INTO beo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Be amo udigili hawa: hamosu dunu da ea ouligisu dunu, ea uda amola ea mano amoma e da asigi amola e da udigili halegale ahoanumu higa:i amo sia:sea, ");
INSERT INTO beo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","amasea, ea ouligisu dunu da amo dunu sia:ne gadosu diasuga oule masunu. Amogai, ouligisu dunu da amo udigili hawa: hamosu dunu logo holei mimogodi ifa dafulili leloma:ne sia:ma:mu. Amasea, ouligisu dunu da amo dunu ea ge gala:mu. Amo ilegei hamoi dagoiba:le, udigili hawa: hamosu dunu da ea ouligisu dunu mae fisili, eso huluane amaiwane dialumu. ");
INSERT INTO beo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Be dunu da idiwi udigili hawa: hamoma:ne bidi lasea, idiwi da ode fesu amoga dunu ilia hou defele, halegale hame masunu. ");
INSERT INTO beo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Dunu eno da amo a:fini uda la:musa: bidi lasea, be fa:no e da higasea, e da amo uda ga fi dunuma bu bidi lamu da sema bagade. E da amo uda ea adama fawane bu bidi lama:mu. Bai e da amo udama asigiwane hame hamoiba:le. ");
INSERT INTO beo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Dunu da egefe lama:ne, udigili hawa: hamosu a:fini amo bidi lasea, e da amo a:fini idiwi defele noga:le ouligima:mu. ");
INSERT INTO beo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Dunu da uda aduna lasea, e da ea musa: lai udama ha:i manu amola abula ema asigi hou e da musa: ema i defele, bu ima:mu. ");
INSERT INTO beo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Be e da amo hou hame hamosea, e da ea musa: uda hahawane udigili masa:ne sia:ma:mu. E da bidi hamedafa lamu. ");
INSERT INTO beo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Nowa dunu da dunu eno fanelegesea, amo dunu fanelegema. ");
INSERT INTO beo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Be e da mae ougili giadofale eno dunu medosea, e da hobeale, Dabe Fasa:besa:le Gaga:su Moilai bai bagade amoga masunu da defea. Na da amo Dabe Fasa:besa:le Gaga:su Moilai bai bagade ilegemu. Amogai, e da se nabasu hame ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Be dunu da ougiliwane dunu eno fanelegesea, amo dunu medole legema. E da Na oloda hi gaga:ma:ne hobeasea, ema mae asigima. Amo fanelegesu dunu medole legema. ");
INSERT INTO beo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Nowa da ea ada o ea ame amo fasea, amo medole legema. ");
INSERT INTO beo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Nowa da dunu amo bidi lamusa: o udigili hawa: hamosu dunu hamoma:ne gasa fili gagulaligisia, amo dunu fanelegema. ");
INSERT INTO beo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Nowa da ea ada o ame elama gagabusu aligima:ne sia:sea, amo fanelegema. ");
INSERT INTO beo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Dunu da gegesea, amola dunu afae da dunu eno ea lobo usunawane fasea o igiga fasea, be amo dunu da hame bogosea, ema se nabasu mae ima. Be dunu e da fai dagoi, amo da ea debea da:iya golasea, be fa:no e da dagulu gaguiwane gadili ahoanebe dawa:sea, dunu da ema fai amo e da ea hawa: hamosu bidi oloiba:le fisi, amo huluane ema imunu. Amola e da amo dunu noga:le ouligimu. E da uhinisi dagoiba:le fawane ouligisu yolesimu. ");
INSERT INTO beo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Dunu da ifa lale, ea udigili hawa: hamosu dunu o uda amo fabeba:le, udigili hawa: hamosu da hedolowane bogosea, amo dunuma se nabasu ima. ");
INSERT INTO beo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Be amo udigili hawa: hamosu dunu o uda da eso afae o aduna esalu bogosea, ouligisu dunuma se nabasu mae ima. E da ea bidi lai amo fisi dagoiba:le, amo da ema se nabasu defele lai gala. ");
INSERT INTO beo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Dunu da gilisili gegesea, amola uda abula agui da se nababeba:le, mano ea hagomo ganodini gala amo fisisia, be eno se hame nabasea, dunu da se nabasu i amo da amo uda egoa ea sia: defele dabe imunu. Be fofada:su dunuma fofada:nanu, dabe imunu. ");
INSERT INTO beo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Be amo uda hi da se bagade nabasea, dabe da esalusu fisi amo defele esalusu dabe imunu. ");
INSERT INTO beo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Si wadela:sea, wadela:su dunu ea si dabe duga:ma. Bese gusia, dabe ea bese guma. Lobo o emo wadela:sea, amo dunu defele dabema. ");
INSERT INTO beo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Laluga gia:sia, dabe gia:sima. Fa:gi o fofonomasu hamosea, dabe defele ima. ");
INSERT INTO beo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Dunu da ea udigili hawa: hamosu dunu o uda amo ea si fabeba:le si wadela:sea, e da dabe ima:ne amo udigili hawa: hamosu uda o dunu amo hahawane halegale masa:ne logo doasima:mu. ");
INSERT INTO beo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","E da fabeba:le bese wadela:sea, e da amo udigili hawa: hamosu dunu o uda amoma dabe ima:ne ea logo doasima:mu. ");
INSERT INTO beo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Bulamagau gawali da ea bese amoga dunu fabeba:le dunu da bogosea, amo bulamagau gawali igiga fanelegema. Ea hu amo mae moma. Be ea ouligisu dunu ema se nabasu mae ima. ");
INSERT INTO beo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Be amo bulamagau gawali da musa: mae fisili dunuma doagala:musa: dawa:lalu ganiaba amola ea ouligisu dunu da sisasu nabalu, amo bulamagau gagoi ganodini hame ouligisu, amo bulamagau da ea besega dunu fanelegesea, bulamagau igiga medole legema amola ea ouligisu dunu fanelegema. ");
INSERT INTO beo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Be eno dunu da bulamagau ouligisu amo ea esalusu gaga:musa: muni dabe imunu da defea sia:sea, defea, e da muni bagade huluane ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Bulamagau gawali da dunu mano o uda mano fanelegesea, amo sema da defele diala. ");
INSERT INTO beo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Bulamagau gawali da udigili hawa: hamosu dunu o uda fanelegesea, bulamagau ea ouligisu dunu da hawa: hamosu dunu o uda ea ouligisu amoma silifa fage muni 30 agoane imunu. Be bulamagau gawali amo igiga gala:le, medole legema. ");
INSERT INTO beo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Dunu afae da uli dogoi amo ea ga:lu fadegasea, o e da uli dogone ga:lu hame figisia amola bulamagau gawali o dougi da amo ganodini bosona dasea, ");
INSERT INTO beo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","e da ohe ea ouligisu amoma muni dabe defele imunu. Be e da ohe medoi, amo gagumu. ");
INSERT INTO beo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Dunu afae ea bulamagau gawali da dunu eno ea bulamagau gawali fanelegesea, amo dunu aduna da bulamagau gawali hame bogoi amo bidi lale, muni amo afafane, afae da la:di lamu eno da eno la:di lamu. Ela da bulamagau bogoi amo ea hu dadega:le, la:di la:di lamu. ");
INSERT INTO beo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Be amo bulamagau gawali da musa: mae fisili, eno bulamagau doagala:musa: dawa:lala ganiaba amola ea ouligisu dunu da gagoi ganodini hame ouligisu, amo dunu da bogoi bulamagau ouligisu dunuma bulamagau gawali esala imunu. Be e da bulamagau bogoi amo manusa: lamu. ");
INSERT INTO beo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Dunu afae da sibi afae o bulamagau afae wamolale amo fanelegesea o bidi lasea, e da bulamagau ouligisu dunuma bulamagau biyale gala dabe bu imunu o sibi ouligisu dunuma sibi biyaduyale agoane dabe bu imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","E da ea wamolai liligi dabe defele bu imunu. Be e da muni o liligi hame galea, dilia amo dunu udigili hawa: hamoma:ne bidi lama:ne iasima. Be sibi o bulamagau e da hame fanelegei o bidilai, ea ouligisu amoga bu samogesea, wamolasu dunu da dabe afae wamolasea, aduna eno dabe imunu. Wamolasu dunu da gasia diasu gadelale, liligi wamolamusa: ganodini ahoasea, nowa dunu da amo wamolasu fanelegesea e da fanelegesu dunu agoane hame ba:mu. Be amo hou esoga hamosea, e da fanelegesu dunu agoane ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Dunu afae ea ohe fi da ea ifabi o waini efe sagai amo ganodini gisi nanebe ba:sea, e da amo noga:le hame ouligisia amola ilia da asili eno dunu ea ha:i manu bugi amo wadela:sea, ohe fi eda da amo ha:i manu gugunufinisi defele hi ha:i manu amo dunuma ima:mu. ");
INSERT INTO beo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Dunu afae da ea sogebi amoga lalu didisia amola amo lalu da asili eno dunu ea ifabi ganodini widi o gagoma sagai o widi faili lala:gili ligi amo nesea, dunu da lalu didi da amo liligi gugunufinisi defele dabe imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Dunu afae da eno dunu ea muni o noga:i liligi amo ea diasuga ouligimu sia:sea, amola wamolasu dunu da amo liligi ea diasuga wamolasea, dilia amo wamolasu dunu ba:sea, e da ea wamolai amo aduna defele dabe bu imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Be wamolasu dunu hame ba:sea, dunu da amo noga:i liligi ouligi amo dilia sia:ne gadosu diasuga oule masa. Amogai e da Gode Dioba:le amo liligi hi da hame wamolai dafawane ilegele sia:ma:mu. ");
INSERT INTO beo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Sia:ga gegesu huluane amo bai da bulamagau o dougi, dunu aduna da amo sia:ga gegesu galea, ela da amo sia:ga gegesu sia:ne gadosu diasuga hahamomu. Gode da giadofai hamosu dunu olelemu. Amola giadofai hamosu dunu da eno dunuma dabe adunawane imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Dunu afae da eno dunu ea dougi o bulamagau o sibi o eno ohe amo ouligimusa: sia:sea amola e da amo ohe ouligisia, ohe da bogosea o se nabasea o eno fi da ea fi amoga doagala:sea, amo ohe da wamolai dagoi ba:sea amola ba:su dunu da amo hou hame ba:i galea, ");
INSERT INTO beo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","amo ohe ouligisu dunu da sia:ne gadosu diasuga asili, e da Gode ba:ma:ne dafawane amane sia:mu, ‘Na da amo ohe hame wamolai.’ Fofada:su dunu da ouligisu dunu ohe hame wamolai ba:sea, defea, e da ohe edama dabe hame imunu. Ohe eda hi da amo ohe fisi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Be amo ohe da wamolai dagoi ba:sea, ouligisu dunu da ohe eda amoma dabe imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Amo ohe da soge ohe fi amoga fanelegei ba:sea, ouligisu da amo ohe ea da:i hodo dodosa:i amo ba:su dunu ba:ma:ne gaguli misunu. Amasea, e da ohe sigua fi amoga medoi liligi amo ohe edama dabe hame imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Dunu afadafa da eno dunu ea ohe amo hawa: hamomusa: amola fa:no ema bu imunusa: bidi lasea, (da:i sia: ‘hire’) amola ohe ea ouligisu dunu maeba:le lelea, amo ohe da se nabasea o bogosea, amo dunu da ohe edama dabe imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Be ohe eda da esalea amo ohe da se nabasea o bogosea amola ohe eda hi ba:sea, lai dunu da ohe ea dabe hame imunu. E da muni bidi ia dagoiba:le, amo hou da hahamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Dunu afae da dunuga hamelai a:fini amo gilisili golale wadela:sea, e da amo a:fini ea lamu dabe imunu. Amola e da amo a:fini hedolo dafawane lama:mu. ");
INSERT INTO beo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Be amo a:fini ea ada da amo a:fini ema imunu higasea, e da ea ada amoma a:fini dunuga hamelai ea dabe defele ea adama imunu. ");
INSERT INTO beo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Nowa uda da fefedoasu o bosa:ga:su hou hamosea, amo medole legema. ");
INSERT INTO beo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Nowa dunu da ohe fi aseme amoma uda adole lasu hou agoane hamosea, amo medole legema. ");
INSERT INTO beo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Nowa dunu da eno ogogosu ‘gode’ amoma gobele salasu hamosea, amo dunu fanelegema. Na, Hina Gode, Nama fawane gobele salasu hamoma. ");
INSERT INTO beo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Dilia da Idibidi soge ganodini ga fi dunu esalu, amo mae gogolema. Amaiba:le, ga fi dunu ilima se nabasu mae ima. ");
INSERT INTO beo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Dilia didalo amola guluba: mano ilima se nabasu mae ima. ");
INSERT INTO beo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Dilia da amoma se nabasu iasea, ilia da Nama fidima:ne digini wesea, amasea ilia wesu Na da nabimu. ");
INSERT INTO beo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Na da dilima ougimu amola dili gegesu amo ganodini dili fanelegemu. Dilia uda da didaloi ba:mu amola dilia mano da guluba:i dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Dilia da hame gagui dunuma muni amo e da dima fa:no dabema:ne iasea, e bu iasea su muni eno amola gilisili ima:ne mae sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Di da muni amo dunu e da dima fa:no dabema:ne ema iasea, amo e bu ima:ne ea anegagi abula amo ilegema:ne di lasea, hedolowane eso da mae sa:ili daeya amoga ea anegagi abula ema bu ima. ");
INSERT INTO beo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Bai e da ea da:i dogoloma:ne anegagi abula eno hame. E da noga:le golama:ne adi eno salima:bela:? E da Na fidima:ne Nama wesea, Na da ea sia: nabimu. Bai Na hou da asigi hou amola Na da gogolema:ne olofosu dawa:. ");
INSERT INTO beo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Dilia Gode Ea hou da noga:i hame amane mae sia:ma, amola dilia fi ouligisu dunu ilima gagabusu aligima:ne mae sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Dilia hahawane udigili iasu Na adoi defele Nama ima. Amo da widi, gagoma, waini hano amola olife susuligi. Amola dilia magobo mano Nama ima. ");
INSERT INTO beo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Dilia bulamagau amola sibi amo ilia magobo mano Nama ima. Magobo mano gawali da ea ame amoga eso fesuale esalumu. Amasea, eso godo amoga amo gawali magobo mano Nama ima. ");
INSERT INTO beo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Dilia da Na fi esala. Amaiba:le, ohe da ohe sigua amoga gasonabeba:le bogoi, amo ea hu dilia mae moma. Be amo fisili, wa:megili ima. ");
INSERT INTO beo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Dilia ogogosu sia: amola baligidu sia: mae sia:ma. Dilia giadofale hamosu dunu amo fidimusa:, mae ogogole sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ogogosu amola wadela:i hamosu dunu ilia idi da moloi hamosu dunu ilia idi baligisia, dilia da ogogosu amola wadela:i hamosu dunu bagohame ilima mae fa:no bobogema. Ilia da ogogobeba:le, moloidafa fofada:su wadela:sea, ilima mae fa:no bobogema. ");
INSERT INTO beo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hame gagui dunu da wadela:i hou hamobeba:le fofada:sea, e da liligi hame gaguiba:le, ema baligiliwane mae asigima. Emagale mae fofada:ma. ");
INSERT INTO beo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Dima ha lai dunu amo ea bulamagau o dougi da ea la:gi fadegale, udigili lalebe ba:sea, di da amo ema bu oule masa. ");
INSERT INTO beo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ea dougi baligiga dioi bagade liligi ligisiba:le da dafai dagoi ba:sea, di da dima ha lai dunu amo ea dougi ea emoga bu wa:lesima:ne fidima. Di mae udigili yolesili masa. ");
INSERT INTO beo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Hame gagui dunu da fofada:su dunuma fofada:sea, e da moloidafa hou ba:ma:ne, noga:le ouligima. ");
INSERT INTO beo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Mae ogogole diwaneya udidima. Dunu da wadela:le hame hamoi, amo udigili mae fanelegema. Nowa da amo wadela:i hou hamosea, Na da ema se imunusa: fofada:su hamomu. ");
INSERT INTO beo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Hano suligi hou mae hamoma. Hano suligi hou da dunu ilia moloidafa hou amo mae ba:ma:ne si dofosa. Amola hano suligi da moloi hamosu dunu amo ilia hou wadela:sa. ");
INSERT INTO beo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Dilia da Idibidi soge ganodini ga fi dunu esalu, amo mae gogolema. Amaiba:le, ga fi dunu ilima mae se ima. ");
INSERT INTO beo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Dilia da ode gafeyale amoga dilia sogega ha:i manu sagama amola ha:i manu faima. ");
INSERT INTO beo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Be ode fesu amoga dilia sogega ha:i manu mae sagama amo ha:i manu mae faima. Hame gagui dunu da ha:i manu amoga dialebe ba:sea, ilia amo ha:i manu lamu amola soge ohe fi da eno hame fai dialebe manu da defea. Amo hou defele dilia da waini sagai amola olife ifa sagai hamoma. ");
INSERT INTO beo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Hi aligi amoga eso gafeyale amoga hawa: hamoma. Be eso fesu amoga mae hawa: hamoma. Bai amo esoga, dilia udigili hawa: hamosu dunu, ga fi dilima hawa: hamosa amola dilia lai gebo helefimu da defea. ");
INSERT INTO beo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Na sia: huluane Na, Hina Gode da dilima olelei, amo noga:le nabima. Eno ‘gode’ agoane liligi ilima mae sia:ne gadoma. Ilia dio amola maedafa sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ode huluane amoga, dilia Nama nodomusa: Lolo Nasu gilisisu udiana hamoma. ");
INSERT INTO beo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Oubi ea dio Abibi, amoga dilia musa: da Idibidi yolesili gadili asi, dilia da Yisidi Hame Sali Agi gilisisu Na dilima olelei defele hamoma. Amo gilisisu eso fesu amoga, agi amoga yisidi sali amo mae moma. Eso huluane, dilia da Nama nodomusa: masea, Nama iasu liligi gaguli misa. ");
INSERT INTO beo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Dilia da degabo widi amola gagoma amo ha:i manu faimusa: dawa:sea, Ha:i Manu Gaheabolo Fai Lolo Nasu bagade hamoma. Dilia da ifa fage, waini fage amo dilia sagai amola waini sagai amoga faimusa: dawa:sea, Sogega Fasela Diasu Lolo Nasu bagade hamoma. ");
INSERT INTO beo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Dilia da ode huluane amo Gilisisu udiana gala amoga dilia da gilisisia, dunu huluane da Nama nodone sia:ne gadomusa: misa:ne sia:ma. Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Dilia da Nama ohe gobele salasu iasea, agi amo ganodini yisidi sali, amo Nama mae ima. Amo ohe gobele sali ilia sefe huluane gobesima. Dilia sefe udigili mae yolesima. Hahabe doaga:sea amo sefe da gobesi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ode huluane dilia widi amola gagoma bisili fai amo dilia Hina Gode ea diasuga gaguli misa. Dilia sibi o goudi mano amo ea ame ea dodo maga:me amo ganodini mae gobema. ");
INSERT INTO beo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Dilia da logoga ahoasea, Na da a:igele amo dili bisimusa: amola ouligimusa: asunasimu. E da soge amo dilia fima:ne Na da hahamoi, amoga E da dili oule masunu. ");
INSERT INTO beo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Dilia Ea sia: noga:le nabima. Ema higale mae hamoma amola mae odoga:ma. Bai Na da E asunasiba:le, E da Ema odoga:su hame gogolema:ne olofomu. ");
INSERT INTO beo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Be dilia da Ea sia: noga:le nabasea, amola Na adoi defele hamosea, Na da dilima ha lai dunu huluane ilima gegemu. ");
INSERT INTO beo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Na a:igele dunu da dilima bisili, amo A:moulaide dunu, Hidaide dunu, Belisaide dunu, Ga:ina:naide dunu, Haifaide dunu amola Yebusaide dunu amo ilia sogega dili oule masunu. Amasea Na da amo dunu fi huluane gugunufinisimu. ");
INSERT INTO beo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Dilia da ilia ‘gode’ liligi ilima mae beguduma. Amola ilima mae nodone sia:ne gadoma amola ilia sia:ne gadosu hou mae lalegaguma. Ilia ‘gode’ liligi gugunufinisima amola ilia sia:ne gadosu gele duni bugi huluane goudane salima. ");
INSERT INTO beo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Dilia da Nama fawane nodone sia:ne gadosea, Na da dilima ha:i manu amola hano noga:i amo dilima imunu. Amola Na da dilia olo huluane fadegale fasimu. ");
INSERT INTO beo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Dilia soge ganodini, abula agui uda da mano dudubu ea hagomo ganodini hamedafa fisimu. Amola uda huluane da mano lamu. Dilia ode bagohame esaloma:ne, na da amo logo hamomu. ");
INSERT INTO beo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Na da hamobeba:le, dilima ha lai dunu da Nama bagade beda:mu. Dunu eno da dilima gegesea, Na da ili ededenagia:ma:ne hamomu amola ilia dilima beda:iba:le, hobeamu. ");
INSERT INTO beo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Dilima ha lai amo hobeama:ne, Na da ilima beda:su hou imunu. Dilia da gaba:i ahoasea, Na da Haifaide, Ga:ina:naide amola Hidaide amo dunu fi gadili sefasimu. ");
INSERT INTO beo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Na da ode afadafa amoga ili hame sefasimu. Amai ganiaba soge da fisi dagoi ba:la:loba amola gasonasu ohe fi da heda:le dilima gegena:noba. ");
INSERT INTO beo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Be Na da gebewane amo dunu fi gadili sefasimu. Amasea, dilia fi dunu ilia idi da amo soge huluane fimusa: defele ba:sea, ilia huluane sefasi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Na da dilia soge alalo defei agoane hamomu. Soge da Agaba Wayabo Adobo muni asili, Medidala:inia Wayabo Bagade amoga doaga:mu. La:di da wadela:i hafoga:i soge amoga asili Iufala:idisi Hano amoga doaga:mu. Na da dilima gasa imunu. Amasea, dilia amo dunu fi ilia da wali amo soge ganodini esala ilima gasa fili, dilia amo soge ganodini golili dasea, amo dunu gadili sefasimu. ");
INSERT INTO beo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Dilia da ilima o ilia ‘gode’ liligi ilima gousa:su maedafa hamoma. ");
INSERT INTO beo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Dilia da amo dunu ilia da dilia soge ganodini bu esaloma:ne logo maedafa doasima. Ilia da dilia soge ganodini bu esalea, ilia da dilia hou wadela:mu. Amola dilia da Nama wadela:le hamoma:ne, ilia da dili logemu. Dilia da ilia ‘gode’ liligi ilima nodone sia:ne gadosea, amo da dilima sani bagade agoane ba:mu.” Hina Gode da amo hamoma:ne sia:i huluane Isala:ili dunuma olelei. ");
INSERT INTO beo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Hina Gode da Mousesema amane sia:i, “Di, Elane, Na:ida:be, Abaihu amola Isala:ili asigilai ouligisu dunu 70, goumiba:le heda:le, Nama misa. Be dilia da fonobahadi Nama sedagawane esalea, dilia da Nama nodomusa: beguduma. ");
INSERT INTO beo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Di fawane, eno dunu hame, di Nama gadenene misa. Dunudafa da goumiba:le hame heda:mu.” ");
INSERT INTO beo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mousese da asili, Hina Gode Ea hamoma:ne sia:i liligi amola sema huluane dunu huluane ilima olelei. Ilia gilisili amane sia:i, “Ninia da Hina Gode Ea sia: huluane nabawane hamomu.” ");
INSERT INTO beo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mousese da Hina Gode Ea sia:i liligi huluane meloaga dedene legei dagoi. Aya hahabedafa, e da goumi ea bai gadenene oloda hamoi. E da Isala:ili fi fagoyale gala amo ilegema:ne, igi fagoyale gala ligisi. ");
INSERT INTO beo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Amalalu, e da ayeligi dunu asunasili, ilia da Hina Godema gobele salasu hamoma:ne ohe gobesi, amola Hina Godema hahawane gousa:musa: bulamagau gobele salasu. ");
INSERT INTO beo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mousese da ohe ilia maga:me dogoa mogili la:di afae ofodo gilisi ganodini sali. La:di eno e da oloda amoga ha:digi. ");
INSERT INTO beo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Amalalu, e da gousa:su buga (amo ganodini Gode Ea sema dedei dagoi ba:i) amo lale, ea dedei amo dunu huluane nabima:ne idi. Ilia da amane sia:i, “Ninia da Hina Gode Ea sia:i liligi huluane nabawane hamomu.” ");
INSERT INTO beo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Amalalu, Mousese da maga:me amo ofodo ganodini diala, amo lale, dunuma adagaga:la:su. E amane sia:i, “Hina Gode da dilima gousa:su hamonoba, E da amo hamoma:ne sia:i dilima i dagoi. Amo maga:me da amo gousa:su ilegesa.” ");
INSERT INTO beo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mousese, Elane, Na:ida:be, Abaihu amola Isala:ili asigilai ouligisu dunu 70 agoane da goumiba:le heda:le, ");
INSERT INTO beo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ilia Isala:ili Gode ba:i dagoi. Ea emo hagudu da igi noga:idafa (Sa:faia - amo da mola:ya:i mu amo defele ba:su) amoga fa:i. ");
INSERT INTO beo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Gode da amo Isala:ili asigilai dunu hame gugunufinisi. Ilia da Gode ba:i dagoi. Amalalu, ilia da amo sogebiga gilisili ha:i manu amola waini mai. ");
INSERT INTO beo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Hina Gode da Mousesema amane sia:i “Di da goumiba:le heda:le, Nama misa. Di da guiguda: esalea, Na da igi gasui aduna amoga Na da Isala:ili dunuma olelema:ne dedei, amo Na digili imunu.” ");
INSERT INTO beo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mousese amola ea fidisu dunu Yosiua da momagele, Mousese da hadigi goumiba:le heda:musa: ha: esalu. ");
INSERT INTO beo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mousese da Isala:ili asigilai dunuma amane sia:i, “Dilia da ninia abula diasu gagui sogebi amoga ouesaloma. Elane amola He ela da dili sigi esala. Nowa da sia:ga gegesu galea, elama masa:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mousese da Sainai Goumiba:le heda:le, goumi da mumobi amoga dedeboi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Hina Gode Ea hadigi si nenemegi da goumiga sa:i dagoi. Isala:ili dunu da amo hadigi lalu agoane goumi da:iya gado nenanebe ba:i. Mumobi haguli da goumi eso gafeyale gala amoga goumi dedeboi dagoi ba:i. Eso fesu amoga, Hina Gode mumobi amoga Mousesema wei. ");
INSERT INTO beo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mousese da goumiba:le heda:le, mumobi amo ganodini golili sa:i. E da eso 40 amola gasi 40 amogai esalu. ");
INSERT INTO beo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Di Isala:ili dunuma ilia da Nama iasu hamoma:ne sia:ma. Ilia da Nama imunusa: dawa:lalu, amo iasu di lama. ");
INSERT INTO beo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ilia da Nama agoane liligi imunu da defea. Gouli, silifa, balase, ");
INSERT INTO beo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","abula, gobiaha:i (amo da mola:ya:i, yoi), abula goudi hinabo amoga hamoi, ");
INSERT INTO beo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","sibi gawali ea gadofo yoi amoga ulasi, bulamagau gadofo, aga:isia ifa, ");
INSERT INTO beo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","gamali hano amo gamali ganodini salimusa:, gabusiga: liligi amo sogadigisu susuligi ganodini salimusa:, laluga gobesimusa: gabusiga: liligi, ");
INSERT INTO beo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","igi noga:i gala (ganilia:ne) amola igi eno noga:i amo gobele salasu dunu ea ‘ifode’ (bidegiga salasu) amola bidegi gaga:su amo ganodini salimusa:. ");
INSERT INTO beo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Isala:ili dunuma ilia da Na ilia gilisisu ganodini esaloma:ne, amo hadigi Abula Diasu gaguma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Amo Abula Diasu amola Diasu ganodini liligi huluane amo Na da dima olelemu defele hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Dilia ‘aga:isia’ ifa amoga Gagili noga:i hamoma. Ea sedade fe defei amo110sedimida hamoma. Ea fe defei la:didili da 66 sedimida hamoma. Amola ea gadodili defei da 66 sedimida. ");
INSERT INTO beo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Amo Gagili ganodini amola gadili gouliga dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Lobo sogo gasisalasu defele 4 agoane gouliga hamoma. Amo da Gagili ea emoga madelagimu. Ilia da amo Gagili gaguli masa:ne hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Gagili la:gili gaguli masa:ne, ‘aga:isia’ ifa amo hamone gouliga dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Amo ifa dilia da gasisalasu amo Gagili la:didili salawane gaguli masa. ");
INSERT INTO beo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Be amo ifa da gasisalasu ganodini salalalu, maedafa duga:ma. ");
INSERT INTO beo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Na da igi gasui aduna amoga sema bagade dedemu. Amo Na da dima iasea, di amo Gode Ea Gousa:su Sema Gagili ganodini salima. ");
INSERT INTO beo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Gode Ea Gousa:su Sema Gagili amoga gouli ga:lu hamoma. Amo ga:lu ea fe defei da 110 sedimida ba:mu amola ea la:didili fe defei amo 66 sedimida hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Dilia ougia gala ‘sielabe’ aduna amo gouliga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ela da ga:lu la:didili leloma:ne amola ga:lu amoga madelagi leloma:ne hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Amo ougia gala ‘sielabe’ aduna da ga:lu da:iya sisima: hodole esala defele hamoma. Ela da ougia ligiagale ga:lu amo dedebomusa: dialebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Di da igi gasui aduna amo Gode Ea Gousa:su Sema Gagili ganodini salimu. Amasea, ga:lu ga:sima. ");
INSERT INTO beo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Na da ga:lu da:iya amo dima gousa:musa: misunu. Amola Na da amo da:iya ougia gala ‘sielabe’ aduna la:didili lela amo dogoa Na da lelumu amola Na sema huluane di Isala:ili dunuma alofele olelema:ne, dima imunu. ");
INSERT INTO beo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Dilia aga:isia ifa lale, fafai hamoma. Amo ea defei da sedade fe da 88 sedimida hamoma. Dunumuni fe da 44 sedimida defema. Amola gado lelebe defei da 66 sedimida defema. ");
INSERT INTO beo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Dilia amo fafai gouli noga:i amoga dedeboma. Amola ea fe amoga gouli oulegesu legema. ");
INSERT INTO beo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Fafai ea fe amoga oulegesu gouli amo ea ba:de da 75 milimida hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Amo fafai gaguli masa:ne gasisalasu biyaduyale gouliga hamone amo fafai ea bada sagai ilia bai gadenene fafai amoga madelagima. ");
INSERT INTO beo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Amo gasisalasu da oulegesu ea fe amo gadenene hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Amo fafai gaguli masa:ne ea ifa aga:isia ifa amoga hamone, gouliga dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ofodo, faigelei amola hano buni amo waini iasu hou hamoma:ne, amo huluane gouliga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Amo fafai, Gode Ea Gousa:su Sema Gagili amo ea midadi ligisima. Amola sema agi ga:gi dilia da Nama imunu liligi da eso huluane mae fisili fafai da:iya dialebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Gamali bai amo gouliga hamoma. Ea bai amola ea damo da gouliga hamoma. Amo noga:i ba:ma:ne dilia sogea amola falegai liligi amo gouliga hamone, ilia da amo gamali bai amoga madelagi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Gamali ea bai da heda:le, sagulufale, amoda gafeyale gala, udiana da la:di, udiana eno da la:didili ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Amo amoda gafeyale gala afae afae da falegai liligi, ‘alamode’ ea sogea defele amoga legei ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Gamali damo gadodili da falegai biyaduyale gala ‘alamode’ agoane amoga legei ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Sogea afadafa amo amoda ilia sagulufai hagudu damoga legemusa: hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Sogea, amoda amola gamali bai da mae afafane gouli liligi afadafa amoga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Gamali damo amola amoda amoga ligisimusa:, gamali fesuale gala hamoma. Ilia ba:le gaidi hadigima:ne, gamali bai amoga ligisima. ");
INSERT INTO beo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Gamali ea dida amola bianoi ofodo amo gouliga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Amo gamali amola ea liligi huluane hamoma:ne, gouli ea dioi defei 35 gilogala:me agoane, amo lama. ");
INSERT INTO beo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Amo liligi noga:le amola gebewane hamoma. Na da goumia dima hamoma:ne sia:i, amo defele hamoma.” ");
INSERT INTO beo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Gode da eno amane sia:i, “Nama Abula Diasu (Da:bena:gele) gaguma. Abula Diasu ea gano la:di agoane hamoma. Abula nabuane gala amo da:iya sibi hinabo gobiaha:i, mola:ya:i amola oga:iyei amola yoi amoga amunima. Dilia ougia gala ‘sielabe’ agoai liligi amo abula da:iya dedene amunima. ");
INSERT INTO beo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Amo abula nabuane gala ea defei amo mida fagoyale agoane gala amola la:di da mida ageyaduyale agoane gala, amo defele hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Abula biyale gala amo disimusa: nodomema. Amola eno biyale gala amo defele hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Abula mola:ya:i amoga gasisalasu agoane hamoma. Amo gasisalasu, dilia abula afae hamoi amo ea gadili fe amoga nodomema. Amola abula eno defele hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Abula afae gilisi amoga gasisalasu 50 agoane nodomema. Amola abula gilisi enoga gasisalasu 50 eno musa: abula defele amoga nodomema. ");
INSERT INTO beo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ma:go 50agoane amo abula gilisi aduna madelagima:ne amo gouliga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Abula Diasu dabua gadili dedebomusa:, abula gidayale gala amo goudi hinabo amoga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Amo abula gidayale gala afae afae ea defei da mida 13 sedade fe amola mida aduna ea dunumuni fe amo defele hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Amo abula biyaduyale gala disimusa: nodomema. Amola eno biyale gala amo disimusa: nodomema. Abula gafe amo disisu ganodini, amo selefale, Abula Diasu ea midadi dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Amo dedebosu abula aduna hamoi afae amoga gasisalasu 50 agoane la:diga nodomema amola afae eno amoga gasisalasu 50 agoane ea la:diga nodomema. ");
INSERT INTO beo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ma:go 50 balasega hamoma. Amo gasisalasu ganodini amo abula disisu madelagima:ne amola dedebosu afadafa hamoma:ne, salima. ");
INSERT INTO beo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Abula da amo Abula Diasu ea fe baligisa amo Abula Diasu ea baligiduga gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Abula da Abula Diasu la:di la:di fe sedade amo 50 sedimida agoane baligi ba:mu. Amo da fe la:di la:di amoga dedebomu. ");
INSERT INTO beo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Dedebosu eno aduna gadili dedeboma:ne hamoma. Afadafa da sibi gawali gadofo yoi maga:mega ulasi amoga hamoma. Eno da bulamagau gadofo noga:iwane amoga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Abula Diasu ea dobea hamoma:ne, aga:isia ifa amoga abula:ime hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Amo dobea abula:ime ea defei da golasu ifa la:di mida ageyaduyale gala amola dunumuni disisu la:di da 66 sedimida. ");
INSERT INTO beo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Abula:ime madelagimu liligi da golasu ifa amoga ifa da amo liligi bugima:ne fonobahadi baligimu. Abula:ime huluane madelagima:ne agoane hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Abula Diasu ea gano la:di dobea gaguma:ne abula:ime 20 hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Amo abula:ime bugima:ne, silifa bai amo ganodini gelabo gala 40 agoane hamoma. Amo da abula:ime afae afae hagudu aduna ligisima. ");
INSERT INTO beo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","21","Abula Diasu ea gano la:di eno dobea gaguma:ne, dobea liligi (abula:ime) 20 eno amola silifa bai eno 40 (aduna aduna abula:ime afae afae hagudu ligisima:ne) amola hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Abula Diasu baligidu la:di amoga bugima:ne, abula:ime gafeyale gala hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Amola abula:ime aduna sisigagala:su (corner) aduna la:di amola la:di disila afufuma:ne hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Amo sisigagala:su (corner) abula:ime ela bai da la:di abula:ime amoga disila afufuli amasea gadodili heda:sea, huluane noga:le madelagili disima. ");
INSERT INTO beo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Amasea Abula Diasu baligidu la:di da abula:ime godoane gala amola silifa bai 16 amo da aduna aduna abula:ime afae afae hagudu ligisi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Aga:isia ifa amoga dobea gagoi noga:le la:gimusa: hamoma. Sedade la:di gadili amoga biyaduyale gala ifa hamoma. Eno sedade la:di gadili eno biyaduyale gala hamoma. Amola baligidu la:di guma:dini amoga legema:ne, biyaduyale eno hamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Abula:ime huluane da silifa bai amoga bugisia, amo ifa bulufalegele madelagima. Dogoa bulufalegei ifa da sedade la:di amo ea defei defemu. ");
INSERT INTO beo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Abula:ime huluane amo gouliga dedeboma. Amoga, gouli gasisalasu madelagima. Bulufalegei ifa da amo gasisalasu ganodini salimu. Amola bulufalegei ifa gouliga dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Amo Abula Diasu (Da:bena:gele) ea fedege Na da Goumia dima olelei. Amo defele di noga:le hahamoma. ");
INSERT INTO beo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Abula noga:iwane Abula Diasu ganodini gosagisimusa: lama. Amoga sibi hinabo mola:ya:i, oga:iyei amola yoi, ‘sielabe’ fedege agoane amunima. ");
INSERT INTO beo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Golasu ifa biyaduyale gala aga:isia ifa amoga hamoma amola gouliga dedeboma. Amo ifaga ma:go la:gilisima. Amola golasu ifa amo silifa bai gelabo ifa salasu amoga salima. Abula noga:i amo golasu ifa ma:goga gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Abula amo ma:go da Abula Diasu gado dedebosu ma:go hagudu gosagisima. Abula ea baligiduga Gode Ea Gousa:su Sema Gagili (amo ganodini da sema dedei igi gasui aduna) amo ligisima. Abula da dogoa gosagi dialebe ba:mu. La:di da Hadigi Malei Sesei, la:di da Hadigidafa Momei Sesei. Amola abula da dogoa gigeigi dialebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Gode Ea Gousa:su Sema Gagili ga:luga ga:ma. ");
INSERT INTO beo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Hadigidafa Momei Sesei gadili (Hadigi Malei Sesei ganodini) amo ea ga (north) la:di guga fafai hamoi ligisima amola gamali bai amo ea ga (south) la:di guga ligisima. ");
INSERT INTO beo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Da:bena:gele Abula Diasu amo ea logo holei amoga gosagisima:ne, abula noga:i hamoma. Amoga sibi hinabo mola:ya:i, oga:iyei amola yoi amunima. ");
INSERT INTO beo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Amo abula gosagisima:ne golasu ifa biyale gala aga:isia ifa amoga hamoma. Amo ifa gouliga dedeboma amola gouli ma:go amoga la:gilisima. Amola amo golasu ifa bugima:ne, balase ifa salasu bai biyale gala hamoma. ");
INSERT INTO beo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Hina Gode da eno amane sia:i “Aga:isia ifa lale, oloda hamoma. Amo da ofodo agoane ea la:di fe defei da 2.2 mida amola la:di fe da 2.2 mida. Ea gadodili heda:su da 1.3 mida ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Oloda ea sisigagala:su (corner) biyaduyale gadili amoga da bulamagau ea ‘hono’ (bese) agoane heda:musa: hamoma. Ilia da oloda amoga noga:le madelagi dagoi ba:mu. Amo huluane balasega dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Sefe amola nasubu gilisi amo fadegama:ne, ofodo hamoma. Amola safala amola ofodo amola ma:go amola bianoi ofodo amo lalu gaguli masa:ne amo huluane balasega hamoma. ");
INSERT INTO beo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","- ");
INSERT INTO beo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Nasubu da gudu sa:ima:ne, balase liligi amo ganodini gelabo bagohame hamoma. Amo liligi oloda ea gadodili legesu hagudu amo oloda ea bada sagai amoga lala:gilisima. Oloda ea hegomai biyaduyale gala amoga gasisalasu oloda gaguli masa:ne lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Amo oloda gaguli masa:ne, aga:isia ifa aduna hamoma. Amo ifa aduna balasega dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Amo ifa gasisalasu oloda la:di la:di hamoi, amo ganodini salima. ");
INSERT INTO beo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Dilia oloda amo aga:isia ifa da:fe amoga ofodo agoane hamoma. Bai gudu mae fema, be gelabo bagohame ba:mu da defea. Na da goumi da:iya dima hamoma:ne sia:i amo defele noga:le hamoma. ");
INSERT INTO beo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Na Da:bena:gele Abula Diasu amo gagomusa: abula gagoi hamoma. Ga (south) la:di guga amoga abula ea sedade defei 44 mida amo hamone gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Amo abula golasu ifa balasega hamoi 20 amo bai balasega hamoi 20 amo ganodini bugi amoga gosagisima. Golasu ifa amoga ma:go amola bulufalegei dagulu agoane da silifa amoga hamoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Amo defele ga (north) la:di guga amoga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Guma:dini, abula ea defei da 22 mida amo golasu ifa nabuane gala amola bai nabuane gala, amoga gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Gusudili amo da logo holei ea sogebi gagoi da guma:dini defele 22 mida defei ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Logo holei da dogoa ba:mu. Ea la:diga da gagoi abula 6.6 mida defei ba:mu. Eno la:diga da amo defele ba:mu. Abula da la:di golasu ifa udiana amola bai udiana amoga gosagisi ba:mu. La:di da amo defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Logo holeidafa da abula 9 mida defei amoga hamoma. Amo abula amoga sibi hinabo mola:ya:i, oga:iyei amola yoi amoga amunima. Golasu ifa biyaduyale gala amola bai biyaduyale gala amoga gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Gagoi golasu ifa huluane da silifa dagulu bulufalegei agoane gilisili disi dagoi ba:mu. Ilia ma:go da silifa amoga hamoma amola ilia golasu ifa sagasu bai amo balasega hamoma. ");
INSERT INTO beo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Gagoi ea defei da agoane. Sedade defei da 44 mida. Dunumuni defei da 22 mida. Amola ea gado heda:su defei da 2.2 mida agoane ba:mu. Abula gosagisu da abula noga:i ahea:ya:i amoga hamoma. Amola golasu ifa sagasu bai amo balasega hamoma. ");
INSERT INTO beo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Liligi huluane Da:bena:gele Abula Diasu amoga sali, ea golasu ifa amola gagoi ea golasu ifa huluane, balasega hamoma. ");
INSERT INTO beo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Isala:ili dunu noga:le olelema. Ilia da olife susuligi noga:idafa amo gamali daeya huluane ulagisimusa: gaguli misa:ne sia:ma. Bai ilia da daeya huluane amo gamali ulagimu. ");
INSERT INTO beo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Elane amola egefelali da amo gamali Da:bena:gele Abula Diasu ganodini ligisima:ne sia:ma. Ea sogebi da Hadigidafa Momei Sesei abula gadili amola Hadigi Malei Sesei ganodini dialebe ba:mu. Ilia da daeya amo gamali ulagisia gamali da ulagilalu hadigimu Na esalebe sogebi amo ganodini. Amo hamoma:ne sia:i ilegei da Isala:ili dunu amola iligaga fi huluanema mae yolesili, eso huluane hamoma:ne dialumu.” ");
INSERT INTO beo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Gode da eno amane sia:i, “Dia ola Elane amola egefelali amo Na:ida:be, Abaihu, Elia:isa amola Idama amo misa:ne sia:ma. Ilia da Nama gobele salasu hawa: hamosu hamoma:ne, Isala:ili dunu fi eno ilima afafama. ");
INSERT INTO beo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Abula noga:iwane dia ola Elane salima:ne hahamoma. E da amo ga:sea, mimogo amola isisima:goi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Na da abula hahamosu dunu mogili ilima noga:le hawa: hamoma:ne, gasa i dagoi. Amo misa:ne sia:ne, ilia da Elane ea abula noga:i amo hamomu. Bai Na da e Na gobele salasu hawa: hamomusa: ilegemu gala. ");
INSERT INTO beo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ilima amane adoma, ‘Dilia bidegi dedebosu, ‘ifode’, abuladafa, da:i salasu amoga da dedene amuni, abula habuga amola abula bulu amo hahamoma. Amo liligi Elane amola egefelali da Nama gobele salasu hawa: hamoma:ne salimusa:, noga:le hamoma. ");
INSERT INTO beo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Amo bagade dawa:su abula hahamosu dunu da sibi hinabo mola:ya:i, oga:iyei amola yoi amola gouli gobiaha:i amola abula noga:idafa amoga gobele salasu dunu ilia abula hahamomu. ");
INSERT INTO beo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ilia da ‘ifode’ amo sibi hinabo mola:ya:i, oga:iyei amola yoi, amola abula noga:i amoga hamomu. Noga:i ba:ma:ne ilia da abula amo da:iya dedene amunimu. ");
INSERT INTO beo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Bulu aduna amo da ‘ifode’ amo gobele salasu dunu ea gida adunaga la:gilisimusa: hamoma. ");
INSERT INTO beo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Abula bulu da ‘ifode’ amoma madelagi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","‘Ganilia:ne’ igi aduna noga:iwane lale, amoga Ya:igobe egefelali fagoyale gala ilia dio dedema. ");
INSERT INTO beo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Magobo mano hidadea dedema. Amalu, magobo bagia amalu amo baligia asili ufi mano dedema. ");
INSERT INTO beo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Igi dedesu dunu noga:idafa da amo hawa: hamoma:ne sia:ma. Amo igi gouli bai hahamone, amo ganodini salima. ");
INSERT INTO beo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Amasea, amo igi da ‘ifode’ bulu amo gida da:iya lala:gilisima. Amasea, Elane da Isala:ili fi huluane ilia dio amo gisa masunu. Amola, Na, Hina Gode, Na da mae yolesili, Na fi dunu dawa:lalumu. ");
INSERT INTO beo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Gouli bai aduna hamone, ");
INSERT INTO beo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","gouli sia:ine aduna, gobiaha:i defele bione hamone, amo baiga lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Gobele salasu Ouligisu dunu amo salima:ne bidegi gaga:su amoga e da Gode Ea hanai dawa:mu, amo ‘ifode’ ea sibi hinabo abula amola amunisu amo defele hamoma. ");
INSERT INTO beo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Amo ea defei da la:di afae da 22 sedimida amola la:di eno da defele 22 sedimida. Amo abula dogoa selefale abula aduna agoane ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Amoga igi noga:iwane dadalesu biyaduyale gala bulufalegele la:gilisima. Dadalesu age ganodini, igi udiana amo ‘lubi’, ‘douba:se’ amola ‘ganede’ la:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Dadalesu ageyadu ganodini igi udiana eno amo ‘emelalede’, ‘sa:faia’ amola ‘daimode’ la:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Dadalesu osoda ganodini igi udiana amo ‘degaoise’, ‘a:gade’ amola ‘a:midiside’ la:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Dadalesu biyadu amo ganodini igi udiana eno amo ‘belile’, ‘ganilia:ne’ amola ‘ya:sabe’ la:gilisima. Amo noga:i igi huluane afae afae gouli bai amoga madelagima. ");
INSERT INTO beo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Amo igi fagoyale gala huluane afae afae amoga Ya:igobe egefelali ilia dio huluane dedema. Amo dio da Isala:ili fi fagoyale gala ilia dio. ");
INSERT INTO beo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Bidegi gaga:su amoga gouli sia:ine gobiaha:i defele bione lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Gouli gasisalasu aduna gouliga hamoi amo bidegi gaga:su ea gado hegomai aduna amoga lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Gouli sia:ine aduna amo gasisalasuga lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Gouli sia:ine aduna eno bidi amo gouli bai aduna amoga lala:gilisima. Amasea, ilia da ‘ifode’ ea gida bulu amoga lala:gilisi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Amasea, gouli gasisalasu aduna eno hamone, bidegi gaga:su ea gudu hegomai aduna ganodini ‘ifode’ dafulili amoga lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Gouli gasisalasu aduna eno hamone, amo da ‘ifode’ ea gida bulu ea gududi bulu eno amoga gadodili lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Bidegi gaga:su amo ea gasisalasu amo ‘ifode’ ea gasisalasu amoga mola:ya:i gobiaha:i amoga lala:gilisima. Bai agoane hamosea, Bidegi Gaga:su da bulu gadodili dialumu. Amola e da hoholei hame ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Elane da Hadigi Malei Sesei amo ganodini golili dasea, e da Bidegi Gaga:su amoga Isala:ili fi ilia dio dedei ea dogo gadenene salawane golili sa:imu. Amaiba:le, Na, Hina Gode da Na fi eso huluane mae yolesili dawa:lalumu. ");
INSERT INTO beo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Igi aduna amo Ulimi amola Damini amo Bidegi Gaga:su ganodini salima. Amasea, Elane da Hadigi Malei Sesei (amo ganodini Hina Gode da esalebe) amo ganodini masea e da ea dogo dafulili Ulimi amola Damini gaguli misunu. Amasea, e da Na da Na fi dunu ilia hou hamoma:ne ilegei, amo dawa:digimu. ");
INSERT INTO beo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Hina Gode da eno amane sia:i, “Gobele salasu dunu ilia abula amo ‘ifode’ dedebosu da sibi hinabo mola:ya:i amoga fawane hamoma. ");
INSERT INTO beo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Gobele salasu dunu ilia dialuma salimusa: gelabo da abula ganodini ba:mu. Amo gelabo da mae gadelama:ne ea fe amo gasa ima:ne noga:le amunima. ");
INSERT INTO beo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Abula ea fe gudu diala amoga ‘bomigala:nidi’ ifa fage agoane liligi sibi hinabo mola:ya:i, oga:iyei amola yoi amoga hamoi lala:gilisima. Sibi hinabo hamoi ‘bomigala:nidi’ afadafa amalalu, gouli belo afadafa amalalu, ‘bomigala:nidi’ eno agoane fega lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Elane da gobele salasu hawa: hamosea, e da amo abula salawane hamomu. E da Na ba:ma:ne Hadigidafa Momei Sesei ganodini golili dasea o gadili ahoasea, belo sia: da nabimuba:le, e da fanelegei dagoi hame ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Noga:i ba:su liligi gouliga hamoma. Amo da:iya agoane dedema, “Hina Godema hadigi hamoma:ne mogili gagai dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Amo nina: hamoi liligi Elane ea abula habuga ba:le gaidiga lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Isala:ili dunu da Na, Hina Gode, hahawane udigili iasu Nama imunu, be eso enoga ilia da giadofale Nama imunu. Be Na da ilia hahawane udigili iasu hahawane lama:ne, Elane da amo nina: hamoi liligi ea odagi da:iya ligisi gaguli ahoanumu. ");
INSERT INTO beo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Elane ea da:i salasu amo abula noga:iwane amoga hamoma. Ea habuga amola abula bulu amo abula noga:iwane amoga hamoma. Abula bulu amo da:iya sibi hinabo amoga amunima. ");
INSERT INTO beo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Da:i salasu, abula bulu amola habuga, Elane egefelali salima:ne hamoma. Ilia da mimogo amola dunu eno amoga fonobahadi afafane momogili gagai, amo ba:ma:ne hamoma. ");
INSERT INTO beo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Amo abula liligi huluane, di amo dia ola Elane amola egefelali ilima gasisa:lima. Amasea, ilia da Na gobele salasu dunu hawa: hamomusa: momogili gagama:ne, ilia dialuma da:iya olife susuligi sogadigima. ");
INSERT INTO beo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ilia selefa dunumuni, abula amoga hamoma. Amo selefa da ilia hagomo asili ilia masele amoga doaga:mu. Ilia sema mae ba:ma:ne agoane hamoma. ");
INSERT INTO beo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Elane amola egefelali da eso huluane Na Abula Diasu ganodini golili dasea o oloda amoga gobele salasu hamoma:ne amo gadenene masea, ilia da amo selefa salawane misunu. Bai ilia da ilia sema olelesea, fanelegei dagoi ba:sa:besa:le, agoane hamomu da defea. Amo da sema amo Elane amola egaga fi da mae yolesili hamonanoma:mu. ");
INSERT INTO beo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Hina Gode da eno amane sia:i, “Di da Elane amola egefelali, Nama gobele salasu hawa: hamoma:ne, agoane momogili gagale ilegema. Bulamagau gawali afadafa waha debe amola sibi gawali aduna amo da aiya o eno ledo hamedei, amo lama. ");
INSERT INTO beo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Widi falaua noga:idafa (yisidi hame sali) amo lale, mogili olife susuligi gilisili ga:gi hamoma. Mogili olife susuligi mae salawane ga:gi hamoma. Mogili belawagi agoane hamone, olife susuligi amoga ulasima. ");
INSERT INTO beo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Amo daba ganodini salima. Dilia da bulamagau gawali amola sibi gawali aduna Nama gobele salasu hamosea, amo ga:gi hamoi Nama ima. ");
INSERT INTO beo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Elane amola egefelali Na Abula Diasu Holeiga oule misa. Ilia da hanoga ulima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Amasea, Elane amoma gobele salasu abula huluane gasisa:lima. Amo da da:i salasu, abula da ‘ifode’ hagudu sala, ‘ifode’, Bidegi Gaga:su amola bulu. ");
INSERT INTO beo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Abula habuga ema figisima amola hadigi nina: hamoi liligi (amoga dedei da “Hina Godema hadigi hamoma:ne mogili gagai dagoi”) amo habuga amoga lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Amasea, olife susuligi (Gobele salasu dunu ilegesu liligi) amo lale, amo ea dialuma da:iya sogadigili, gobele salasu dunu ligiagale ilegema. ");
INSERT INTO beo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Elane egefelali oule misini, ilima da:i salasu gasisa:lima. ");
INSERT INTO beo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ilia hagomo sisiga:musa:, abula bulu legema amola habuga ilia dialumaga lala:gilisima. Di Elane amola egefelali amola iligaga fi da Nama mae yolesili gobele salasu hawa: hamonanoma:ne, ili momogili gagale ilegema. ");
INSERT INTO beo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Bulamagau gawali amo Abula Diasu ea ba:le gaidiga oule misini, Elane amola egefelali da ea dialuma da:iya ilia lobo ligisima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Abula Diasu holei gadenene, Na, Hina Gode Na ba:le gaidiga amogai bulamagau gawali fanelegema. ");
INSERT INTO beo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Bulamagau gawali ea maga:me mogili lale, dia lobosogo amoga oloda ea ‘hono’ amoga legema. Maga:me oda huluane amo oloda ea bai amoga sogadigima. ");
INSERT INTO beo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Amasea, bulamagau ea oso sefe amo da iga dedebosa, habe noga:i la:di amola fogome ganumu aduna ela sefe amo lale, oloda da:iya gobesima. ");
INSERT INTO beo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Be bulamagau gawali ea hu, ea gadofo amola ea iga huluane dilia abula diasu gilisisu (fisisu) amoga gadili gaguli asili, gobesima. Amo da gobele salasu Nama iaha amo gobele salasu dunu ilia wadela:i hou fadegale fasima:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Sibi gawali afadafa lale, Elane amola egefelali ilia lobo amo ea dialuma da:iya ligisima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Amasea, amo sibi medole legele, ea maga:me amo oloda ea la:di biyaduyale gala amoga adagala:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Sibi gawali amo ea da:i hodo dasega:ma. Ea iga amola baligidu emo dodofelalu, ea hodo dasega:i amola dialuma amo da:iya ligisima. ");
INSERT INTO beo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Amo sibi gawali oloda da:iya gobele salasu Nama iasu hamoma:ne, amo gobesima. Na da amo gobele iasu ea gabusiga: hahawane nabimu. ");
INSERT INTO beo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Sibi gawali eno (gobele salasu dunu mogili gagale hamoma:ne sibi) amo lale, Elane amola egefelali ilia lobo amo ea dialuma da:iya ligisima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Amasea amo sibi medole legele, ea maga:me mogili amo Elane amola egefelali ilia ge hedefo lobodafa la:didili, ilia lobodafa ea bi amola ilia emodafa ea bi amoga legema. Maga:me oda amo oloda ea la:di biyaduyale gala amoga adagala:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Maga:me oloda da:iya diala amo mogili lale, ilegesu susuligi mogili lale, amo Elane amola egefelali ilia da:i hodo amola ilia abula amoga adagala:ma. Amasea, e amola egefelali da Nama momogili gagai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Sibi gawali ea sefe la:go, oso sefe amo da iga dedebosa, habe noga:i la:di, fogome ganumu aduna amola ela sefe dedebosu amola emodafa amo gobiheiga damuni fasima. ");
INSERT INTO beo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Daba amo ganodini agi ga:gi da Nama iasu diala, amoga agi afae olife susuligi gilisi, agi afae susuligi hame sali amola agi afae belowagi agoane hamoi, amo lama. ");
INSERT INTO beo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Amo ha:i manu huluane amo Elane amola egefelali ilia lobo ganodini ligisima. Ilia da amo Nama iasu ida:iwane gala modale ligiagama:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Amasea, amo ha:i manu ilima bu lale, oloda da:iya, musa: gobele iasu amo gadodili gobesima. Amo da Nama ha:i manu gobele iasu. Na da ea gabusiga: hahawane nabimu. ");
INSERT INTO beo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Amo sibi gawali ea bidegi lale, Nama iasu baligili noga:i hamoma:ne momodale ligiagama. Amo bidegi di moma:ne lama. ");
INSERT INTO beo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Dilia da gobele salasu dunu gobele salasu hawa: hamoma:ne momogili gagasea, sibi gawali dilia gobele salasu dunu ilegemusa: gobele sala amo ea bidegi amola ea maseledafa, dilia Nama hahawane ima:ne ilegema. Amasea, gobele salasu dunu ilia da amo moma:ne la:didili ligisima. ");
INSERT INTO beo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Na da Na asigi dawa:su hame afadenemu. Na fi dunu da ilia gobele iasu hamosea, ilia da bidegi amola maseledafa amo gobele salasu dunuma imunu. Amo da Na fi dunu ilia Nama hahawane iasu gala. ");
INSERT INTO beo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Elane da bogosea, ea gobele salasu abula amo egefelali ilia gobele salasu ilegesea salima:ne, ilima ima. ");
INSERT INTO beo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Elane nowa egefe da ea sogebi labeba:le, Abula Diasu Hadigi Malei Sesei amo ganodini hawa: hamomusa:gini golili daha, amo da Elane ea abula eso fesuale salawane esalumu. ");
INSERT INTO beo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Sibi gawali amo Elane amola egefelali ilegemusa: medole legei, amo ea hu lale, hadigi sogebi amoga egema. ");
INSERT INTO beo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ilia da amo amola agi daba ganodini dialebe, Na Abula Diasu amo ea logo holeiga moma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ha:i manu amo ilia gobele salasu ilegesu gilisisu ganodini hamoi, amo ilia da manu. Amo ha:i manu da hadigi hamoiba:le, gobele salasu dunu fawane da manu. ");
INSERT INTO beo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Be aya hahabe doaga:sea, hu o agi mogili hame mai dialebe ba:sea, amo gobele salima. Amo da hadigi hamoiba:le, manu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Elane amola egefelali gobele salasu dunu momogili gagama:ne, amo hou Na sia:i defele eso fesuale amoga noga:le hamoma. ");
INSERT INTO beo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Amo eso fesuale ganodini, eso afae afae huluane wadela:i hou gogolema:ne olofoma:ne, bulamagau gawali afadafa gobele salasu hamoma:ne medole legema. ");
INSERT INTO beo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Eso afae amo hamoma, amola aya eso eno medole legema, asili eso fesuale hamosea fisima. Amasea, oloda da hadigidafa ledo hamedei agoane ba:mu. Amola ea hadigi da gasa bagadeba:le, nowa dunu o liligi da amo oloda digili ba:sea, e da se nabasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Eso huluane mae yolesili, dilia da sibi mano aduna amo da ode afadafa esalu amo medole legele oloda da:iya gobele salima. ");
INSERT INTO beo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Sibi mano afadafa amo hahabe gobele salima. Eno da daeya gobele salima. ");
INSERT INTO beo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Sibi mano hahabe gobele salasea, amo gilisili widi falaua l gilogala:me amola ‘lida’ afae olife susuligi ima. Amola waini ‘lida’ afae amo Hina Godema ima:ne sogadigima. ");
INSERT INTO beo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Daeya amo sibi mano eno gobele salasea, hahabe defele widi falaua, olife susuligi amola waini amo gilisili ima. Amo da ha:i manu Na, Hina Godema iasu. Na da amo gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Amo eso huluane mae yolesili, amo gobele salasu gobei dilia Na Abula Diasu Holeiga Nama iasu hamonanoma. Na da amo Logo Holeiga Na fi dunu gousa:le, ilima sia: sa:imu. ");
INSERT INTO beo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Na da amogai Na fi Isala:ili amo gousa:mu. Amola Na hadigi sinenemegi da amo sogebi hadigi hamomu. ");
INSERT INTO beo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Na da Abula Diasu amola oloda amo hadigi hamomu. Amola Na da Elane amola egefelali eno dunuma afafane, ilia Na gobele salasu hawa: hamoma:ne, momogili gagale ilegemu. ");
INSERT INTO beo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Na da Isala:ili fi dunu ilia gilisisu ganodini esalumu amola Na da ilia Gode esalebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Na da ilia Hina Gode amola Na da ilia gilisisu ganodini esalumusa:, Idibidi sogega fisili masa:ne gadili asunasi, amo ilia da dawa:mu. Na da ilia Hina Gode!” ");
INSERT INTO beo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Hina Gode da eno amane sia:i, “Dia oloda amoga gabusiga: manoma gobesimusa:, amo aga:isia ifaga hamoma. ");
INSERT INTO beo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Amo ea bulufai defei la:di da 45 sedimida, la:di da 45 sedimida amola gado defei da 90 sedimida. Gadodili hegomai biyaduyale gala amoga oloda madelagiwane bulamagau ea hono defele biyaduyale hamoma. ");
INSERT INTO beo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Amo ea dabuagado amola la:di biyaduyale gala amola ea ‘hono’ amo gouliga dedeboma. Oloda gagili sisiga:musa:, gouli fugalegei lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Amo oloda gaguli masa:ne, gouli gasisalasu aduna hamone, fugalegei amo hagudu la:di amola la:di, gaguli ahoasu ifa amoga sanasima:ne lala:gilisima. ");
INSERT INTO beo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Gaguli ahoasu ifa amo aga:isia ifa amoga hamone, gouliga dedeboma. ");
INSERT INTO beo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Amo oloda da abula amo da Gode Ea Gousa:su Sema Gagili ea ba:le gaidiga gosagisi diala amo gadili ligisima. Na da amo sogebi dili gousa:la misunu. ");
INSERT INTO beo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Hahabe huluane, Elane da gamali amo hahamomusa: masea, e da gabusiga: manoma amo oloda da:iya gobesima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","E da daeya gamali ulagisia, amo defele hamoma:ne sia:ma. Amo gabusiga: manoma gobesisu hou da eso huluane mae yolesili hamonanoma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Amo oloda da:iya dilia eno sema hamoi manoma o ohe fi iasu o widi o gagoma maedafa gobesima. Amoga waini iasu mae sogadigima. ");
INSERT INTO beo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Eso afadafa ode huluane amoga, Elane da amo oloda agoane dodofema:ne sia:ma. E da oloda ea ‘hono’ biyaduyale gala amoga ohe da wadela:i hou gogolema:ne olofoma:ne gobele salasu hou hamoi dagoi amo ea maga:me oloda hono amoga legemu. Amo da ode huluane amoga fifilamu huluane mae yolesili hamonanumu. Amo oloda da hadigidafa Na, Hina Gode, Nama i dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Di da Isala:ili dunu ilia idi abodesea, ilia amo esoga se mae nabima:ne, dunu huluane da ilia esalusu haboda:i defele, su Nama ima:mu. ");
INSERT INTO beo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Dunu huluane amo idisia da muni defei ilegei (dioi defei 6 gala:me) amo huluane Nama ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Dunu huluane idi, ilia da lalelegele, ode 20 amo baligi da amo su ima:mu. ");
INSERT INTO beo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ilia esalusu agoane bidi lasea, bagade gagui dunu da baligili hame imunu amola hame gagui dunu da muni hagudu amo hame imunu. Huluane da defele imunu. ");
INSERT INTO beo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Amo su muni Isala:ili dunuma lale, Na Abula Diasu (Da:bena:gele) amo noga:le ouligima:ne bidi lama. Amo su da Na fi dunu ilia mae bogoma:ne imunu. Amasea, Na da ili gaga:mu.” ");
INSERT INTO beo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Balase ofodo amola balase bai gilisili hamoma. Amo da Abula Diasu gadili Abula Diasu amola Oloda bagade amo dogoa sogebiga ligisima. Amo ganodini hano sogasalima. ");
INSERT INTO beo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Elane amola egefelali da amogai ilia lobo amola emo dodofemu. ");
INSERT INTO beo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ilia da Na Abula Diasu amo ganodini golili dasea o oloda da:iya ha:i manu gobele iasu hamomusa: dawa:sea, ilia hidadea amogai bogosu se nabasu mae ba:ma:ne, lobo amola emo dodofema:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Amo sema ilia amola iligaga fi da eso huluane mae yolesili hamonanoma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Di da gabusiga: hedama:ne fodole nasu noga:i lale - amo ‘me’ hano ea dioi defei da 6 gilogala:me amola gabusiga: ‘sinamone’ amo ea dioi defei da 3 gilogala:me amola gabusiga: ode ea dioi defei da 3 gilogala:me, ");
INSERT INTO beo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","amola ‘ga:sia’ ea dioi defei da 6 gilogala:me. (huluane amo dioi defeidafa amoga defema.) Amoga olife susuligi 4 lida agoane gilisima. ");
INSERT INTO beo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Amo liligi gilisili, hadigi ilegesu susuligi gabusiga: manoma defele bibiagone hamoma. ");
INSERT INTO beo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","28","Amo susuligi amoga Na Abula Diasu, Gode Ea Gousa:su Sema Gagili, Hadigi Fafai amola ea liligi, Gamali Bai amola ea liligi, Gabusiga: Manoma Gobesisu oloda amola ea liligi, oloda amoga gobele salasu ilia da hamosa amola ea liligi, dodofesu ofodo amola ea bai, amo liligi huluane amoma susuligi sogadigili, momodale ligiagama. ");
INSERT INTO beo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Amo liligi huluane agoane hamobeba:le da hadigidafa dagoi ba:mu. Amasea, nowa dunu o eno liligi da amo liligi digili ba:sea, e da amo hadigi ea gasaga se nabasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Amasea, Elane amola egefelali ilima susuligi sogadigili, ilia Na gobele salasu hamoma:ne momogili gagama. ");
INSERT INTO beo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Isala:ili fi dunuma amane sia:ma, ‘Amo hadigi ilegesu susuligi da Na hawa: hamosu dunu ilegemusa: eso huluane mae yolesili ilegemu. ");
INSERT INTO beo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Dunudafa amoga udigili mae sogadigima. Amola amo susuligi defele eno mae hamoma. Bai amo susuligi da hadigidafa, amola dilia da amo da hadigi ba:ma. ");
INSERT INTO beo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nowa dunu da susuligi amo defele hamosa o udigili gobele salasu hame dunu ilima sogadigisia, amo dunu da Na fi amoga fadegale fasi dagoi ba: mu.’” ");
INSERT INTO beo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Hina Gode da Mousesema amane sia:i, “Hedama:ne fodole nasu, amo ‘sada:gedi’, ‘oniga’, ‘galabaname’ amola ‘fala:gesese’ noga:i, amo lama. ");
INSERT INTO beo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Amo bibiagone, gabusiga: manoma hamoma. Amo mae dasama:ne, sali salima. ");
INSERT INTO beo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Mogili lale, goudane, su fonobahadidafa hamoma. Amo Na Abula Diasu ganodini gaguli misini, Gode Ea Gousa:su Sema Gagili amo ea ba:le gaidiga adagala:ma. ");
INSERT INTO beo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Dilia da amo gabusiga: manoma defele udigili mae hahamoma. Amo da hadigi hamoi liligi Nama iasu. ");
INSERT INTO beo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nowa da amo defele gabusiga: manoma hi da:i gabusiga:ma:ne hamosea, e da Na fi amoga fadegai dagoi ba:mu,” Hina Gode da amo sia: huluane Mousesema olelei. ");
INSERT INTO beo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Na da Bisa:liele (Uli egefe amola He ea aowa), Yuda fi dunu, amo ilegei. ");
INSERT INTO beo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Na da Na A:silibu amoga ema gasa nabaiwane i. Na da ema bagade dawa:su hou i dagoi. Na da e hawa: hamosu noga:iwane hamoma:ne, ema gasa i. ");
INSERT INTO beo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","E da gouli, silifa amola balase amoga liligi noga:iwane hamosu dawa:. ");
INSERT INTO beo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","E da igi noga:iwane hamone liligi ida:iwane hahamosu dawa:. E da ifa hedofale, ida:iwane liligi hamomusa: dawa:. Bai Na da amo hawa: hamomusa:gini, Na A:silibu Ea gasa ema i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Amola Na eno dunu afae e fidima:ne ilegei. E da Ouhoulia:be, Ahisama:ge ea mano (Da:ne fi dunu). Amola Na da eno noga:i hawa: hamosu dunu, ilia da Na sia:i liligi noga:le hahamoma:ne, ilima gasa i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Na Hadigi Abula Diasu, Gode Ea Gousa:su Sema Gagili, ea ga:lu, liligi huluane Abula Diasu ganodini, ");
INSERT INTO beo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","fafai amola ea liligi, gouliga hamoi gamali bai amola ea genonesisu liligi, gabusiga: manoma gobesisu oloda, ");
INSERT INTO beo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ohe gobele salasu oloda amola ea liligi, dodofesu ofodo amola ea bai, ");
INSERT INTO beo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Elane amola egefelali ilia abula ida:iwane gala amo ilia da Na hawa: hamosea salimu, ");
INSERT INTO beo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ilegesu susuligi amola gabusiga: manoma Hadigidafa Momei Sesei amo ganodini gobesimusa:, amo liligi huluane hahamosea, hawa: hamosu dunu ilia da Na dima hamoma:ne sia:i defele, noga:le hahamoma:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Isala:ili dunu ilima amane adoma, ‘Sa:bade eso da Na helefisu eso. Amaiba:le, Sa:bade eso noga:le dawa:ma. Bai Sa:bade eso da dunu huluane ba:ma:ne, dawa:digima:ne olelesu diala. Amo ilegei da Na, Hina Gode da dili Na fidafa hamoi dagoi amo olelesa. ");
INSERT INTO beo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Amo eso da hadigi hamoiba:le, noga:le dawa:ma. Nowa da amo eso mae dawa:le, udigili hawa: hamosea, amo dunu medole legema. ");
INSERT INTO beo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Dilia da eso gafeyale gala amoga dilia hawa: hamosu hamomu da defea. Be eso fesu da hadigi eso - Na esodafa. Nowa da amo esoga hawa: hamosea, amo dunu da fanelegei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Amo eso da Na Gousa:su amo dawa:digima:ne olelesu gala. Amaiba:le, Isala:ili dunu! Dilia amo sema noga:le dawa:ma! ");
INSERT INTO beo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Amo dawa:digima:ne olelesu da eso huluane dialumu. Bai Na, Hina Gode, da eso gafeyale gala amoga osobo bagade amola mu hahamoi dagoi. Be eso fesu amoga, Na da hawa: hamosu yolesili, helefi.’” ");
INSERT INTO beo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Gode da Sainai Goumia Mousesema Ea sia: dagoloba, E da igi gasui aduna amoga E da Hisu Ea hamoma:ne sia:i dedei, amo Mousesema i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Be Mousese da Sainai Goumia eso bagohame esalu. Isala:ili dunu da amo hou ba:beba:le, ilia Elanema misini amane sia: dasu, “Amo dunu Mousese, e da nini Idibidi sogega gadili bisili oule misi. Adi hou da ema doaga:bela:? Amaiba:le, ‘gode’ liligi ninima bisili masunusa: hamoma!” ");
INSERT INTO beo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Elane da ilima amane sia:i, “Gouli gegagulu bagedigi amo da dilia uda, egefe amola didiwi ilia gega sali, amo fadegale, nama gaguli misa.” ");
INSERT INTO beo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Amalalu, dunu huluane da ilia gouli gegagulu bagedigi gasisalasu huluane fadegale, Elanema gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","E da amo liligi lale, laluga daeane amola osobo dogone, bulamagau ea agoaila hamone, amo ganodini gouli daei sogadigili, gouli bulamagau gawali hamoi. Dunu huluane da hahawane amane sia:i, “Isala:ili! Amo da ninia ‘gode’. E da nini Idibidi soge amoga ga masa:ne bisili oule asi. ");
INSERT INTO beo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Amalalu, Elane da gouli bulamagau mano gawali amo ea ba:le gaidiga oloda hamoi. E amane sia:i, “Aya ninia da gilisisu bagade Hina Godema nodoma:ne hamomu.” ");
INSERT INTO beo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Hahabedafa ilia ohe amo gobele salasu amola eno olofoma:ne iasu manusa: amola hamoma:ne gaguli misi. Isala:ili dunu da lolo nasu bagade hamoi. Amoga ilia waini hano bagade mai, wadela:i hou amola wadela:i uda adole lasu hou bagade hamosu. ");
INSERT INTO beo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Hina Gode da Mousesema amane sia:i, “Hadiga! Hedolo gudu sa:ima! Dia fi amo di da Idibidiga fisili masa:ne gadili oule asi, amo da wadela:i hou hamoi dagoi amola ilia da Na yolesi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Na da hou amo ilia da hamoma:ne ilima sia:i, amo ilia da fisili dafai dagoi. Ilia da bulamagau mano gawali gouli daeane amoga hamone, amoma nodone sia:ne gadoi amola gobele salasu hamoi dagoi. Ilia da amo da ilia ‘gode’, e da ili Idibidi sogega fisili masa:ne asunasi amo sia: daha. ");
INSERT INTO beo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ilia dogo da igi agoane gawamaga:i dagoi amo Na dawa:. ");
INSERT INTO beo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Amaiba:le, Na logo mae damuma. Na da amo dunu fi ilima ougi bagadeba:le, ili huluane gugunufinisimu. Amasea, Na da di amola digaga fi amoga fifi asi bagade hamomu. ");
INSERT INTO beo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Be Mousese da Hina Godema ha:giwane edegei. E amane sia:i, “Hina Gode! Di da Dia gasa bagade amoga dia fi Idibidi sogega esalu amo gaga:le, fisili masa:ne asunasili, guiguda: oule misi. Ilima baligiliwane mae ougima! ");
INSERT INTO beo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Idibidi dunu da Di da dia fi amo goumia dafawanedafa medole legemusa: gadili oule misi, amo ilia sia:sa:besa:le, Dia ougi fisima. Dia asigi dawa:su sinidigili, Dia fi mae gugunufinisima! ");
INSERT INTO beo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Dia hawa: hamosu dunu A:ibalaha:me, Aisage amola Ya:igobe bu dawa:ma! Di da ilima iligaga fi ilia idi da gasumuni muagado gala amo defele ilima ima:ne sia:i, amola Ga:ina:ne soge ilia amo ganodini eso huluane esalalaloma:ne ilima ima:ne ilegele sia:i. Amo Di bu dawa:ma!” ");
INSERT INTO beo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Amaiba:le, Hina Gode da Ea asigi dawa:su afadenene, Ea fi dunu Ea musa: gugunufinisimu sia:i hame hamoi. ");
INSERT INTO beo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mousese da igi gasui amo da:iya Gode Ea hamoma:ne sia:i da la:di la:di dedei, amo goumiba:le gaguli asili gudu sa:i. ");
INSERT INTO beo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Gode Hi da amo igi gasui hamoi amola Hi da amo da:iya Ea hamoma:ne sia:i dedei. ");
INSERT INTO beo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosiua da Isala:ili dunu ilia welalu nabaloba, Mousesema amane sia:i, “Na da uda ulisalasu amola hududusu abula diasu gilisisu ganodini naba.” ");
INSERT INTO beo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Be Mousese da bu adole i, “Amo ea nabe da nimi baligisu o digini hobeasu agoane hame naba. Amo da gesami hea:su agoane naba.” ");
INSERT INTO beo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mousese da abula diasu gilisisu gadenene doaga:loba, e da gouli bulamagau mano gawali amola dunu gosa:lalebe ba:i. Amalalu, e da ougi bagade ba:i. Amogai, goumi ea bai amogai, e da igi gasui aduna gaguli ahoanebe amo gisalu gala:beba:le, igi gasui da goudana asi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","E da gouli bulamagau mano gawali ilia hamoi, amo lale, daeane, goudane su agoane hamone amola hano gilisili bibiagoi. Amalalu, e da Isala:ili dunu amo moma:ne logei. ");
INSERT INTO beo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","E da Elanema amane sia:i, “Dia hamobeba:le, amo dunu da wadela:i hou bagadedafa hamoi dagoi. Amo hamoma:ne, ilia da dima adi hamobela:?” ");
INSERT INTO beo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Elane da bu adole i, “Nama mae ougima! Amo dunu da wadela:i hou hamomusa: bagade hanai gala. Amo di dawa:! ");
INSERT INTO beo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ilia da nama amane sia:i, ‘Mousese da nini Idibidi sogega gadili oule misi. Be ema hou doaga:i ninia hame dawa:. Amaiba:le, ‘gode’ liligi nini bisimusa: hamoma.’ ");
INSERT INTO beo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Na da ilima ilia gouli noga:i liligi amo nama gaguli misa:ne sia:i. Amalalu, nowa da amai galea da amo fadegale nama i. Na da amo liligi laluga ha:digiloba, amo gouli bulamagau mano gawali da udigili gadili misi!” ");
INSERT INTO beo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mousese da Elane ba:loba, Elane da dunu huluane ilia da hina: sia: mae nabawane ilima ha lai dunu ba:ma:ne gagaoui agoane hamoi, Mousese da amo ba:i dagoi. ");
INSERT INTO beo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Amaiba:le, e da abula diasu gilisisu amo logo holeiga lelu, amane wei, “Nowa da Hina Godemagale fa:no bobogemusa: dawa:sea, guiguda: misa!” Amalalu, Lifai fi dunu huluane da ema misi. ");
INSERT INTO beo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mousese da ilima amane sia:i, “Isala:ili Hina Gode da dilima amane sia:sa, ‘Dilia huluane dilia gegesu gobihei bagade amo afoga salawane masa. Abula diasu gilisisu amo ganodini logo holei la:di amoga logo holei eno la:diga asili, dilia olalali amola dilia na:iyado ili medole legema.’” ");
INSERT INTO beo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lifai fi dunu da Mousese ea sia: nabawane hamoi. Amo esoga ilia da dunu 3000 agoane medole legei. ");
INSERT INTO beo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mousese da Lifai fi dunuma amane sia:i, “Wali eso dilisu da dilia Hina Godema gobele salasu hawa: hamomusa: ilegei dagoi. Dilia da dilia egefelali amola olalali fanelegei dagoiba:le, amo hamoi dagoi amola Hina Gode Ea hahawane fidisu lai dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Aya, Mousese da Isala:ili dunuma amane sia:i, “Dilia da wadela:i hou bagadedafa hamoi dagoi. Be na da wali Hina Gode Ea goumi amoga bu heda:mu. Amabela:? Na sia:beba:le, E da dilia hou gogolema:ne olofoma:bela:?” ");
INSERT INTO beo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Amalalu, Mousese da Hina Godema bu asili, Ema amane sia:i, “Amo dunu da wadela:i hou bagade hamoi dagoi. Ilia da ‘gode’ liligi gouliga hamone, ema nodone sia:ne gadosu. ");
INSERT INTO beo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ilia wadela:i hou Di gogolema:ne olofoma:ne, na da Dima edegesa. Be hamedei galea, Buga amo ganodini Di da Dia fi dio dedei, amoga na dio fadegama.” ");
INSERT INTO beo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Hina Gode da bu adole i, “Nowa dunu da Nama wadela:le hamoi, amo fawane Na da ilia dio Na Bugaga dedei fadegamu. ");
INSERT INTO beo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Be wali masa! Di bisili asili, Na fi dunu amo soge Na dima adoi, amoga oule masa. Mae gogolema! Na a:igele dunu da logo olelemusa:, dili bisili masunu. Be eso enoga, amo dunu ilia da wadela:i hou hamosea, Na da ilima se nabasu imunu.” ");
INSERT INTO beo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Amaiba:le, Hina Gode da Isala:ili dunuma olo bagade iasi. Bai ilia da gasa fili logebeba:le, Elane da gouli bulamagau mano gawali hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hina Gode da Mousesema amane sia:i, “Di amola dunu fi amo di da Idibidi sogega gadili masa:ne oule misi. Amo sogebi yolesili, soge amo Na da A:ibalaha:me, Aisage amola Ya:igobe iligaga fi amola ilima imunu ilegele sia:i, amoga masa. ");
INSERT INTO beo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Na da a:igele dunu dilima logo olelemusa: asunasimu. Amola dilia da amo sogega fima:ne, Na da Ga:ina:naide, A:moulaide, Hidaide, Belesaide, Haifaide amola Yebusaide, amo dunu fi huluane sefasimu. ");
INSERT INTO beo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Dilia da soge noga:idafa, fedege agoane amo ganodini dodo maga:me amola agime hano da hano agoane yogodaha, amoga ahoa. Be Na da dili hame sigi masunu. Bai dilia da dogo gawamaga:i dunu, amola Na da dili logoga dafawanedafa fanelegesa:besa:le, hame masunu.” ");
INSERT INTO beo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Isala:ili dunu da amo sia: nabaloba, da:i dioiba:le dinanu. Ilia da se nababeba:le, bu hame nina: hamoi. ");
INSERT INTO beo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Bai Hina Gode da Mousesema amane sia:i, “Isala:ili dunuma adoma, ‘Dilia da hame nabasu dunu. Na da fa:bihadi fawane dili oule ahoa ganiaba, Na da dafawane dili medole legela:loba. Wali dilia nina: hamoi igi noga:i huluane fadegama. Na da fa:no dilima adi hamoma:beyale dawa:ma.” ");
INSERT INTO beo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Amaiba:le, Isala:ili dunu da Sainai Goumi yolesili, fa:no bu hame nina: hamoi. ");
INSERT INTO beo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Eso huluane Isala:ili dunu da ilia Abula Diasu gaguloba, Mousese da Gode Ea Abula Diasu (Da:bena:gele) amo abula diasu gilisisu gadili fonobahadi sedagawane gagusu. Ilia da amo Abula Diasu, “Hina Gode Ea amo ganodini Esalebe Diasu” amo dio asuli. Nowa da Hina Godema sia: sa:imusa: dawa:loba, e da amoga ahoasu. ");
INSERT INTO beo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mousese da Gode Ea Abula Diasuga ahoanoba, dunu huluane da ilia abula diasu holeiga lelebe ba:su. Ilia da Mousese ea Gode Ea Abula Diasu ganodini golili dasu ba:su. ");
INSERT INTO beo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mousese da ganodini golili sa:i dagoi ba:loba, mumobi da gudu sa:ili, Da:bena:gele ea logo holeiga dialebe ba:su. Amalalu, Hina Gode da mumobi haguli amoga Mousesema sia: dalebe ba:su. ");
INSERT INTO beo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Dunu huluane da mumobi Gode Ea Abula Diasu logo holei amoga dialebe ba:loba, ilia da hedolowane begudusu. ");
INSERT INTO beo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Hina Gode da Mousesema sisima hodole, dunu da ea na:iyadoma sia: daha amo defele sia: dasu. Amalalu, Mousese da bu Isala:ili abula diasu gilisisu amoga buhagisu. Be Mousese ea ayeligi fidisu, amo Yosiua (Nane egefe) da Gode Ea Abula Diasuga esalusu. ");
INSERT INTO beo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mousese da Hina Godema amane sia:i, “Dafawane! Di da nama amo dunu Ga:ina:ne sogega bisili oule masa:ne sia:i. Be nama oule masunu dunu da nowa, amo di nama hame adoi. Di na noga:le dawa: amola na hou hahawane ba:sa, amo Di da adoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Amaiba:le, Di da nama hahawane galea, Dia fa:no hamomu hou nama olelema. Na udigili hame adole ba:sa. Be na da Dia hawa: hamosu noga:le hamoma:ne amola, Di da na hahawane ba:ma:ne, adole ba:sa. Amo dunu fi da Dia dunu fidafa hamoma:ne, Di ilegei dagoi. Amo mae gogolema!” ");
INSERT INTO beo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Hina Gode da amane sia:i, “Na da ani masunu. Na da dima hasalasu hou imunu.” ");
INSERT INTO beo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mousese da bu adole i, “Di da ninia hame sigi ahoasea, Di da amo sogebi fisimusa: nini gadili mae asunasima. ");
INSERT INTO beo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Di da nini hame sigi ahoasea, Di da nama amola Dia fi ilima hahawane gala, nowa da dawa:ma:bela:? Be Di da ninima gilisili ahoasea, dunu huluane da ninia da fi hisu, dunu fi huluane eno amoga afafai, dunu huluane da dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Hina Gode da Mousesema amane sia:i, “Na da di noga:le dawa:, amola Na da dima hahawane gala. Amaiba:le, Na da dia adole ba:i defele hamomu.” ");
INSERT INTO beo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Amalalu, Mousese da Ema amane adole ba:i, “Na da Dia hadigi sinenemegi amo ba:mu hanai galebe.” ");
INSERT INTO beo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Hina Gode da bu adole i, “Defea! Na da Na hadigi hou di ba:ma:ne olelemu. Na hadigi Dio amola dima adomu. Na da Gode Hinadafa. Na da nowa dunu gogolema:ne olofomusa: dawa:sea, Na da gogolema:ne olofomu. Nowa dunuma Na da asigima:ne dawa:sea, Na da ema asigimu. ");
INSERT INTO beo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Na da Na odagi dima hame olelemu. Bai nowa Na odagi ba:sea, e da bogomu. ");
INSERT INTO beo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Be amo gele da Na dafulili diala. Amoga di leloma. ");
INSERT INTO beo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Amasea, Na hadigi sinenemegi da baligisia, Na da di gele gelabo ganodini sanasili, Na loboga dedebomu. Amasea, Na da baligimu. ");
INSERT INTO beo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Amasea, Na da Na lobo bu lalegamu. Di da Na baligi ba:mu be Na odagi ba:mu da sema gala.” ");
INSERT INTO beo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Hina Gode da Mousesema amane sia:i, “Di igi gasui eno aduna musa: hamoi defele hedofama. Na da amo da:iya sia: da musa: gasui aduna di goudanasi, amo gaheabolo amoga bu dedemu. ");
INSERT INTO beo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Di aya hahabe, momagele, Sainai Goumiba:le heda:le, gadodili Na gousa:ma. ");
INSERT INTO beo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Dunu eno da hame sigi masunu, di fawane. Dunu da goumia esalebe hamedafa ba:mu. Sibi amola bulamagau amola da goumi baiga gisi nanebe da sema bagade. ");
INSERT INTO beo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Amaiba:le, Mousese da igi gasui aduna eno hedofale, hahabedafa amo gaguli asili, Sainai Goumiba:le heda:i, Hina Gode Ea sia:i defele. ");
INSERT INTO beo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Hina Gode da mumobi ganodini gudu sa:ili, Mousese gadenene lelu. E da Mousesema Ea hadigi Dio olelei, amo Hina Gode. ");
INSERT INTO beo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Amalalu, Hina Gode da Mousese ea ba:le gaidiga baligili asili, amane wele sia:i, “Na da Hina Gode. Na da gogolema:ne olofosu amola asigi hou baligili dawa:. Na da hedolo hame ougisa. Na da asigi hou dawa: amola mae fisili ouligisu hou dawa:. ");
INSERT INTO beo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Na da Na sia: sia:i amo mae gogole, fifilai osea:i ilima Na sia:i defele hamosa. Na da wadela:i hou amola ledo hou gogolema:ne olofosa. Be Na da eda amola eme ela wadela:i houba:le, ela mano amola aowalali amola agoane iligaga fifilai osoda amola biyadu ilima se nabasu imunu. Na da amo hame gogolemu.” ");
INSERT INTO beo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mousese da hedolowane osoba beguduli, Godema nodoiwane sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","E amane sia:i, “Hina Gode! Di da dafawane nama hahawane galea, Di da nini sigi masa:ne na Dima edegesa. Amo dunu fi da hame nabasu fi. Be ninia wadela:i hou amola ninia ledo amo gogolema:ne olofole, ninia da Dia fidafa esaloma:ne, Di sia:ma.” ");
INSERT INTO beo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Hina Gode da Mousesema amane sia:i, “Na da wali Isala:ili dunuma gousa:su hamomu. Ilia ba:ma:ne, Na da hou musa: osobo bagadega fifilai huluane amo ganodini da hamedafa ba:su, gasa bagade hou hamomu. Na da hou bagadedafa dia fi amo ganodini hamomuba:le, dunu huluane da Na Hina Gode, Na da gasa bagade hawa: hamosu dawa:, amo dawa:mu. ");
INSERT INTO beo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Dilia da hamoma:ne sia:i Na da wali eso dilima iaha, amo noga:le nabawane hamoma. Dilia da gaba:i ahoasea, Na da A:moulaide, Ga:ina:naide, Hidaide, Belisaide, Haifaide amola Yebusaide amo dunu fi ili sefasimu. ");
INSERT INTO beo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Dilia amo soge dilia da ganodini masunu ea esalebe fi dunu ilima gousa:su maedafa hamoma. Ilima gousa:su da dilima bogosu sani agoane ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Be amo mae hamone, ilia oloda huluane muguluma, ilia hadigi duni bugi ifa gugunufinisima amola ilia loboga hamoi liligi. ilia uda ‘gode’ liligi Asila amoma nodomusa: hamoi, amo hedofama. ");
INSERT INTO beo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Eno ‘godema’ mae nodone sia:ne gadoma. Bai Na, Hina Gode da ‘gode’ liligi eno ilima mudasa. ");
INSERT INTO beo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Dilia amo soge fi dunu gilisili gousa:su maedafa hamoma. Ilia da ilia ogogosu ‘gode’ liligi ilima nodone sia:ne gadosea amola ilima gobele salasu hamosea, ilia da dili amoma gilisima:ne sia:mu. Amasea, dilia ha:i manu ilia ogogosu ‘gode’ liligi amo gobele sanasima:ne lai, amo dili moma:ne ado ba:su sani agoane ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Dilia mano da amo ga fi uda lasa:besa:le, amola ilia sia:beba:le dilia mano da Na fisili, ogogosu ‘gode’ liligi ilima nodone sia:ne gadosa:besa:le, amo dunu fi ilima gousa:su maedafa hamoma. ");
INSERT INTO beo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Dilia ‘gode’ liligi ilima nodone sia:ne gadomusa:, ‘ouli’ amoga mae hamoma. ");
INSERT INTO beo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Agi Yisidi Hame Sali amo Lolo Nasu gilisisu noga:le dawa:ma. Na musa: sia:i defele, dilia da eso fesuale gala oubi Abibi ganodini, yisidi hame sali agi amo fawane moma. Bai amo oubi ganodini dilia da Idibidi soge yolesi. ");
INSERT INTO beo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Magobo dunu mano amola ohe magobo mano gawali huluane da Na:. ");
INSERT INTO beo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Be magobo dougi mano gawali amo sibi mano amoga bu bidi lama. Be hame bidi lasea, dougi ea mugi dugima. Dunu magobo mano huluane bu bidi lama. Dunu huluane da Nama masea, udigili mae misa! Be hahawane udigili iasu gaguli misa! ");
INSERT INTO beo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Eso gafeyale ganodini hawa: hamoma. Be eso fesu amoga mae hawa: hamoma. Osobo gidinasuga dogosu eso amola ha:i manu faisu eso da hisu hame ba:mu. Amo hou wali hamoma:ne sia:i defele hamoma. Eso fesu huluane amoga mae hawa: hamoma. ");
INSERT INTO beo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ha:i Manu Gaheabolo Fai Lolo Nasu gilisisu amo dilia widi degabo faisia hamoma. Amola, ha:i manu yoi fage amo degabo faisia, Sogega Fasela Diasuga Lolo Nasu bagade hamoma. ");
INSERT INTO beo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ode huluane amoga dilia gilisisu udiana hamoma. Amoga dilia dunu huluane da Na, Isala:ili Hina Gode, Nama nodone sia:ne gadomusa: misa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Na da dili Ga:ina:ne soge golili misa:ne amo soge fi dunu huluane gadili sefasisia amola dilia soge bu bagade hamosea, amo fa:no, dilia amo gilisisu hamosea, amo esoga ga fi da dilia soge bu lamusa: dilima hame doagala:mu. ");
INSERT INTO beo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Dilia da Nama ohe gobele salasu iasea, agi amo ganodini da yisidi sali, amo Nama mae ima. Amola Baligisu Lolo Manusa: ohe fi medoi amo ea hu hame mai diala, amo aya hahabe manusa: mae gaguma. Huluane gobesima. ");
INSERT INTO beo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ode huluane dilia widi amola gagoma degabo fai amo dilia Hina Gode Ea diasuga gaguli misa. Dilia sibi o goudi mano amo ea ame ea dodo maga:me amo ganodini mae gobema.” ");
INSERT INTO beo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Hina Gode da Mousesema amane sia:i, “Amo sia: huluane noga:le dedema. Amo sia: da gousa:su Na da di amola Isala:ili dunuma hamosa, amo sia: da amo gousa:su ea bai agoane gala.” ");
INSERT INTO beo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mousese da Hina Godema eso 40 amola gasi 40 ha:i mae nawane esalu. E da igi gasui amo da:iya amo Gousa:su sia: dedei dagoi - amo da Gode Ea Hamoma:ne sia:i Nabuane Gala. ");
INSERT INTO beo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mousese da Gode Ea Hamoma:ne sia:i Nabuane Gala amo gaguiwane Sainai Goumiba:le gudu sa:ili, e da Hina Godema sia: dabeba:le, ea odagi da hadigiwane ba:i. Be e da amo hame dawa:i galu. ");
INSERT INTO beo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Elane amola dunu huluane da Mousesema ba:lalu, ea odagi da hadigi ba:beba:le, ema bagadewane beda:iba:le, ema gadenene masunu hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Be Mousese da ilima misa:ne wei. Amalalu, Elane amola Isala:ili asigilai ouligisu dunu da ema asili, ema sia: dasu. ");
INSERT INTO beo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Amalalu, Isala:ili dunu huluane da ema sisiga:le gilisili, Mousese da hamoma:ne sia:i huluane Gode da Sainai Goumia ema i, amo ilima olelei. ");
INSERT INTO beo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mousese da ilima sia: dasu dagoloba, e da ea odagi abula asaboi amoga dedeboi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mousese da Hina Gode Ea Abula Diasu amo Godema sia: sa:imusa: golili daloba, e da amo abula sawa: figisu gisa:su. E da gadili bu manoba, e da Isala:ili dunuma Gode Ea sia:i huluane ilima olelesu. ");
INSERT INTO beo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ilia da ea odagi da hadigi hamoi dagoi ba:su. Amalalu, e da amo abula sawa: figisu amoga ea odagi bu dedebosu. E da enoga Hina Godema bu sia: sa:imusa: ahoanoba fawane bu gisa:su. ");
INSERT INTO beo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mousese da Isala:ili dunu fi huluane gilisima:ne sia:i. Amalalu, e da ilima amane sia:i, “Hina Gode da dilima amane sia:sa, ");
INSERT INTO beo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‘Dilia da hialigi amoga eso gafeyale gala amoga dilia da hawa: hamomu da defea. Be eso fesu amo da Na hadigi eso Nama modale ligiagai dagoi. Amo esoga dilia helefima. Nowa da Sa:bade esoga hawa: hamosea, amo fanelegema. ");
INSERT INTO beo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Hawa: hamosu maedafa hamoma. Sa:bade esoga, dilia diasu ganodini, lalu mae didima.’” ");
INSERT INTO beo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mousese da Isala:ili dunu huluane ilima amane sia:i, “Hina Gode da dilima amane sia:sa, ");
INSERT INTO beo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Hina Godema hahawane udigili iasu gaguli misa. Nowa dunu da hanai galea, e da hahawane udigili iasu amo gouli o silifa o balase amo gaguli misa. ");
INSERT INTO beo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Eno da abula noga:iwane o sibi hinabo mola:ya:i o oga:iyei o yoi. Eno da abula goudi hinabo amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Sibi gawali gadofo ulasi, bulamagau gadofo, aga:isia ifa, ");
INSERT INTO beo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","gamali susuligi, hedama:ne fodole nasu amo ilegesu susuligi amola gabusiga: manoma amoga gilisimusa:. ");
INSERT INTO beo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Eno da ‘ganilia:ne’ amola eno igi noga:idafa amo gobele salasu Ouligisu dunu ea ‘ifode’ amola Bidegi Gaga:su ganodini salimusa:.’” ");
INSERT INTO beo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Mousese da Gode Ea sia: eno Isala:ili dunuma amane adole i, “Hawa: hamosu dunu ida:iwane dilia gilisisu ganodini esalebe, ilia da misini amola Gode Ea hamoma:ne sia:i liligi huluane hamomu da defea. ");
INSERT INTO beo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Amo da Gode Ea Abula Diasu, ea dedebosu liligi huluane, ea ma:go, abula:ime, bulufalegei dududawalo, golasu ifa, amo ea bai huluane, ");
INSERT INTO beo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Gode Ea Gousa:su Sema Gagili, ea gaguli ahoasu ifa, ea ga:lu amola abula amo da Gode Ea Gousa:su Sema Gagili wamolegesu, ");
INSERT INTO beo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","fafai, ea ifa amola ea liligi huluane, agi ga:gi Godema iasu, ");
INSERT INTO beo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","gamali bai amola ea liligi, gamali, gamali susuligi, ");
INSERT INTO beo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","gabusiga: manoma amo gobesisu oloda amola ea gaguli ahoasu ifa, ilegesu susuligi, gabusiga: manoma, Gode Ea Abula Diasu logo holei abula ga:su, ");
INSERT INTO beo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","gobele salasu oloda, ea balasega hamoi gigiadomai, ea ifa amola liligi huluane, dodofesu ofodo amola ea bai, ");
INSERT INTO beo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","gagoi gaga:su abula amola ea golasu ifa amola ilia bai huluane, gagoi ea logo holei ga:su abula, ");
INSERT INTO beo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Abula Diasu amola Gagoi ilia udidisu ifa sagasu amola efe udidisu, ");
INSERT INTO beo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","abula ida:iwane gobele salasu dunu da Hadigi Malei Sesei ganodini hawa: hamosea salasu amola hadigi abula Elane amola egefelali sala.” Mousese da amo huluane hamoma:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Isala:ili dunu da yolesili asili, ");
INSERT INTO beo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","amola huluane da hanai galea, hahawane udigili iasu amo Hina Gode Ea Abula Diasu hahamoma:ne Ema gaguli misi. Ilia da liligi huluane, amo da Hina Godema nodone sia:ne gadomusa: amola gobele salasu dunu ilia abula hamomusa:, amo gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Nowa da hanai galea, dunu amola uda da nina: hamosu liligi amo gouli gedusu, abula bagedigi, igi noga:i, gouli gisa:gini amola gouli nina: hamosu liligi huluane Hina Godema ima:ne gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Nowa da abula noga:iwane o sibi hinabo mola:ya:i o oga:iyei o yoi o goudi hinaboga hamoi abula o sibi gawali gadofo ulasi o bulamagau gadofo amo liligi gagui dialebe, amo gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Amola nowa da silifa o balase gagui galea, ilia da ilia hahawane udigili iasu Hina Godema gaguli misi. Amola nowa da aga:isia ifa Hina Gode Ea liligi hahamoma:ne defele gala da amo gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Bagade dawa:su hawa: hamosu uda da abula nodomesu efe ahea:ya:i noga:iwane amola nodomesu efe amo mola:ya:i, oga:iyei amola yoi sibi hinabo amo gobiaha:i agoane hamoi amo gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ilia da goudi hinabo amoga efe hamosu. ");
INSERT INTO beo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Isala:ili fi asigilai ouligisu dunu da ‘ganilia:ne’ amola igi ida:iwane eno, amo ‘ifode’ amola Bidegi Gaga:su amo ganodini salimusa: gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Amola ilia da hedama:ne fodole nasu, gamali susuligi, ligiagasu susuligi amola gabusiga: manoma susuligi gaguli misi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Nowa Isala:ili dunu da hanai galea da Hina Gode da Mousesema sia:i defele, Ea Abula Diasu hawa: hamomusa:gini, hahawane udigili iasu Hina Godema gaguli misi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mousese da Isala:ili dunuma amane sia:i, “Hina Gode da Bisa:liele (Uli egefe amola He ea aowa - Yuda fi dunu) amo ilegei dagoi. ");
INSERT INTO beo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","E da Ea A:silibu ea gasa Ema i dagoi. E da Gode Ea A:silibu Hadigidafa amo Ea gasa lai dagoiba:le, hawa: hamosu bagade dawa:, amola liligi huluane noga:idafa hamoma:ne e da gasa gala. ");
INSERT INTO beo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","E da gouli, silifa amola balase amoga liligi ida:iwane hamomu dawa:, amola amoga osa:le dedesu hou noga:idafa dawa:. ");
INSERT INTO beo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","E da igi ida:iwane gala amo hedofasu hou amola amoga osa:le dedesu hou noga:le dawa:. E da ifa oso gasa:su hou noga:le dawa: amola liligi huluane hahamomusa:, e da dawa:lai amola gasa gala. ");
INSERT INTO beo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hina Gode da ema amola Ouhoulia:be (Ahisama:ge ea mano - Da:ne fi dunu) elama bagade dawa:su hou i dagoi. Ela da Hina Gode Ea A:silibu Hadigidafaga gasa lai dagoiba:le, ela da eno dunuma amo hou olelemu defele esala. ");
INSERT INTO beo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ela da hawa: hamosu huluane hamomusa: gasa bagade gala. Amo da osa:le dedesu hou, hawa: hamomusa: meloa ilegele dedesu, abula amunisu amola sibi hinabo efe mola:ya:i, oga:iyei amola yoi amunasu hou amola abula hou eno. Ilia da hawa: hamosu huluane dawa:, amola liligi hamoma:ne ilegesu dedesu bagade dawa:.” ");
INSERT INTO beo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Mousese da eno amane sia:i, “Bisa:liele, Ouhoulia:be amola hawa: hamosu dunu eno amoga Hina Gode da bagade dawa:su amola liligi huluane Ea Hadigi Malei Sesei gagumusa: amo hamomusa: E da ilima defele i, amo dunu da Hina Gode Ea hamoma:ne sia:i defele hamoma:ne, Gode da sia:sa.” ");
INSERT INTO beo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mousese da Bisa:liele, Ouhoulia:be amola noga:i hawa: hamosu dunu eno amo da Hina Gode Ea gasa iasu lai amola Gode Ea hawa: hamosu hamomu hanai galu, amo dunu misa:ne wei. Mousese da ilima hawa: muni hamoma:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ilia da Mousese ea loboga amo hahawane udigili iasu liligi Isala:ili dunu da Abula Diasu gaguma:ne gaguli misi, amo lai dagoi. Be hahabe huluane, Isala:ili dunu da mae yolesili, hahawane udigili iasu liligi Mousesema gaguli masu. ");
INSERT INTO beo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Amalalu, bagade dawa:su hawa: hamosu dunu da Mousesema asili, ");
INSERT INTO beo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ema amane sia:i, “Isala:ili dunu ilia gaguli manebe da Hina Gode Ea liligi hamomusa: sia:i amo baligisa.” ");
INSERT INTO beo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Amalalu, Mousese da Isala:ili abula diasu gilisisu amoga sia: adole iasi amane, “Hina Gode Ea Abula Diasu gaguma:ne, eno liligi mae ima. Defele gala!” Amalalu, Isala:ili dunu da eno hahawane udigili iasu hame gaguli misi. ");
INSERT INTO beo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ilia gaguli misi dagoi da amo hawa: hamosu dagomusa: defele ba:i amola baligimu ba:i. ");
INSERT INTO beo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Baligili bagade dawa:su hawa: hamosu dunu da Hina Gode Ea Abula Diasu gagui. Ilia da abula noga:i nabuane gala amo da:iya sibi hinabo gobiaha:i mola:ya:i, oga:iyei amola yoi amoga ‘sielabe’ agoane amo abula dedene amuni amo lale hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Amo abula nabuane gala ea defei da mida fagoyale gala amola la:di da mida ageyaduyale gala amo defele ba:i. ");
INSERT INTO beo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ilia da abula biyale gala amo disimusa: nodomei. Amola eno biyale gala amo defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ilia da abula mola:ya:i amoga gasisalasu agoane hamoi. Amo gasisalasu, ilia da abula afae hamoi amo ea gadili fe amoga nodomei. Amola abula eno defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ilia da abula afae gilisi amoga gasisalasu 50 agoane nodomei. Amola abula gilisi enoga gasisalasu 50 eno No1abula defele amoga nodomei. ");
INSERT INTO beo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ilia da ma:go 50 amo abula gilisi aduna madelagima:ne amo gouliga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Amalalu, ilia da Abula Diasu dabua gadili dedebomusa:, abula gidayale gala amo goudi hinabo amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ilia da amo abula gidayale gala afae afae ea defei da mida 13 sedade fe amola mida aduna ea dunumuni fe amo defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ilia da amo abula biyaduyale gala disimusa: nodomei. Amola eno biyale gala amo disimusa: nodomei. ");
INSERT INTO beo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ilia da amo dedebosu abula aduna hamoi afae amoga gasisalasu 50 agoane la:diga nodomei amola afae eno amoga gasisalasu 50 agoane ea la:diga nodomei. ");
INSERT INTO beo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ilia da ma:go 50 balasega hamoi. Amo gasisalasu ganodini amo abula disisu madelagima:ne amola dedebosu afadafa hamoma:ne, ilia da sali dagoi. ");
INSERT INTO beo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ilia da dedebosu eno aduna gadili dedeboma:ne hamoi. Afadafa da sibi gawali gadofo yoi maga:mega ulasi amoga hamoi. Eno da bulamagau gadofo noga:iwane amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ilia da Abula Diasu ea dobea hamoma:ne, aga:isia ifa amoga abula:ime hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ilia da amo dobea abula:ime ea defei da golasu ifa la:di mida ageyaduyale gala amola dunumuni disisu la:di da 66 sedimida agoane hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ilia da dobea gagumu liligi (abula:ime) da golasu ifa amoga ifa da amo liligi bugima:ne fonobahadi baligima:ne hamoi. Ilia da abula:ime huluane agoane hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ilia da Abula Diasu ea ga (south) la:di dobea gaguma:ne, dobea liligi (abula:ime) 20 hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ilia da amo abula:ime bugima:ne, silifa bai 40 agoane hamoi. Ilia da amo da abula:ime afae afae hagudu aduna ligisimusa: defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","26","Ilia da Abula Diasu ea ga (north) la:di eno dobea gaguma:ne, dobea liligi (abula:ime) 20 eno amola silifa bai eno 40 (aduna aduna abula:ime afae afae hagudu ligisima:ne) amola hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ilia da Abula Diasu baligidu la:di amoga bugima:ne, abula:ime gafeyale gala hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Amola ilia da abula:ime aduna hegomai aduna la:di amola la:di amola disila afufuma:ne hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ilia da amo hegomai abula:ime ela bai da la:di abula:ime amoga disila afufuli amasea gadodili heda:sa, huluane noga:le madelagili disi. ");
INSERT INTO beo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Amalalu, Abula Diasu baligidu la:di da abula:ime godoane gala amola silifa bai 16 amo da aduna aduna abula:ime afae afae hagudu ligisi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ilia da aga:isia ifa amoga dobea gagoi noga:le lala:gimusa: hamoi. Ilia da sedade la:di gadili amoga biyale gala ifa hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Amola eno sedade la:di gadili eno biyale gala hamoi amola baligidu la:di guma:dini amoga legema:ne, biyale eno hamoi. ");
INSERT INTO beo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ilia da abula:ime huluane da silifa bai amoga bugisia, amo ifa bulufalegele madelagi. Dogoa bulufalegei ifa da sedade la:di amo ea defei defele ba:i. ");
INSERT INTO beo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ilia da abula:ime huluane amo gouliga dedeboi. Ilia da amoga, gouli gasisalasu madelagi. Ilia da bulufalegei ifa dududawalo agoane amo gasisalasu ganodini sali dagoi amola ilia da bulufalegei ifa gouliga dedeboi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ilia da abula noga:iwane Abula Diasu ganodini gosagisimusa: hamoi. Amoga ilia da sibi hinabo mola:ya:i, oga:iyei amola yoi ‘sielabe’ agoaila amuni. ");
INSERT INTO beo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ilia da golasu ifa biyaduyale gala aga:isia ifa amoga hamoi amo gouliga dedeboi. Ilia da amo ifaga ma:go lala:gilisi. Amola ilia da golasu ifa amo silifa bai gelabo ifa salasu amoga sali. ");
INSERT INTO beo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ilia da Da:bena:gele Abula Diasu amo ea logo holei amoga gosagisima:ne, abula noga:i hamoi. Amoga ilia da sibi hinabo mola:ya:i, oga:iyei amola yoi amuni. ");
INSERT INTO beo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ilia da amo abula gosagisima:ne, golasu ifa biyale gala aga:isia ifa amoga hamoi. Amo ifa ilia da gouliga dedeboi amola gouli ma:go amoga lala:gilisi. Amola ilia da amo golasu ifa bugima:ne, balase ifa salasu bai biyale gala hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bisa:liele da Gode Ea Gousa:su Sema Gagili amo ‘aga:isia’ ifa amoga noga:le hamoi. Ea defei amo da fe defei da 110 sedimida hamoi. Ea fe defei la:didili e da 66 sedimida hamoi. Amola ea gadodili defei da 66 sedimida ba:i. ");
INSERT INTO beo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","E da Gode Ea Gousa:su Sema Gagili ganodini amola gadili gouliga dedeboi. Amola e da gouli oulegesu amo sisiga:musa: hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","E da lobo sogo gasisalasu defele biyaduyale agoane gouliga hamoi. E da amo Gode Ea Gousa:su Sema Gagili ea emoga madelagi. Ilia da amo Gode Ea Gousa:su Sema Gagili gaguli masa:ne, e hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","E da Gaga:su Gaga lala:gili gaguli masa:ne, ‘aga:isia’ ifa amo hamone gouliga dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","E da amo ifa ilia da gasisalasu amo gagili la:didili salawane gaguli masa:ne hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","E da Gode Ea Gousa:su Sema Gagili amo ga:ma:ne gouli ga:lu hamoi. Amo ga:lu ea fe defei da 110sedimida ba:i amola ea la:didili fe defei amo 66 sedimida hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","E da ‘sielabe’ aduna ougia gala amo gouliga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","E da ela ga:lu la:didili la:didili leloma:ne amola ga:lu amoga madelagi leloma:ne hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Amo ougia gala ‘sielabe’ aduna da ga:lu da:iya sisima hodole esala defele hamoi. Ela da ougia ligiagale, ga:lu amo dedebomusa: dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","E da ‘aga:isia’ ifa lale, fafai hamoi. Amo ea defei da sedade fe da 88 sedimida hamoi. Dunumuni fe da 44 sedimida defei. Amola gado lelebe defei da 66 sedimida defei. ");
INSERT INTO beo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","E da amo fafai gouli noga:i amoga dedeboi. Amola ea fe amoga gouli oulegesu legei. ");
INSERT INTO beo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","E da fafai ea fe amo gadodili dobea fei agoane hamoi. Fei ea defei da 75 milimida agoane. Amola e da gouli oulegesu amo fei sisiga:musa: hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","E da amo fafai gaguli masa:ne gasisalasu biyaduyale gouliga hamone amo fafai ea bada sagai ilia bai gadenene fafai amoga madelagi. ");
INSERT INTO beo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","E da amo gasisalasu fafai ea fei amo gadenene hamosu. ");
INSERT INTO beo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","E da amo fafai gaguli masa:ne, ea ifa aga:isia ifa amoga hamone, gouliga dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","E da ofodo, faigelei amola hano buni amoga waini iasu hou hamoma:ne, amo huluane gouliga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","E da gamali bai amo gouliga hamoi. E da gamali bai amola ea damo gouliga hamoi. E da amo noga:i ba:ma:ne sogea amola falegai liligi amo gouliga hamone, ilia da amo gamali bai amoga madelagi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Gamali ea bai da heda:le, sagulufale, amoda gafeyale gala, udiana da la:di udiana eno da la:didili ba:i. ");
INSERT INTO beo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Amo amoda gafeyale gala afae afae da mosoi liligi udiana ‘alamode’ ea sogea defele amoga legei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Gamali damo gadodili da mosoi biyaduyale gala ‘alamode’ agoane amoga legei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","E da sogea afadafa amo amoda ilia sagulufai hagudu damoga legemusa: hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","E da sogea, amoda amola gamali bai mae afafane gouli liligi afadafa amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","E da gamali bai amola amoda amoga ligisimusa:, gamali fesuale gala hamoi. Ilia hadigi da ba:le gaidiga hadigimusa:, gamali bai amoga ligisi. E da gamali ea dida amola bianoi ofodo amo gouliga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","E da amo gamali bai amola ea liligi huluane hamoma:ne, gouli ea dioi defei da 35 gilogala:me amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","E da oloda amoga gabusiga: manoma gobesimusa:, amo aga:isia ifa amoga hamoi. E da amo ea bulufai defei la:di da 45 sedimida, la:di da 45 sedimida amola gado defei da 90 sedimida agoane hamoi. E da gadodili hegomai biyaduyale gala amoga oloda madelagiwane bulamagau ea ‘hono’ defele biyaduyale hamoi. ");
INSERT INTO beo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","E da amo ea dabuagado, la:di biyaduyale gala amola ea ‘hono’ amo gouliga dedeboi. Amola e da amo oloda sisiga:musa: gouli oulegesu lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","E da amo oloda gaguli masa:ne, gouli gasisalasu aduna hamone, oulegesu amo hagudu la:di amola la:di amola gaguli ahoasu ifa amoga sanasima:ne lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","E da gaguli ahoasu ifa amo aga:isia ifaga hamone, gouliga dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Amola e da hadigi ilegesu susuligi amola gabusiga: manoma hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ohe iasu gobesimusa: e da aga:isia ifa lale, oloda hamoi. Amo da gagili agoane ea la:di fe defei da 2.2 mida amola la:di fe da 2.2 mida. Ea gadodili heda:su da 1.3 mida ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","E da oloda ea hegomai biyaduyale gadili amoga bulamagau ea ‘hono’ agoane heda:musa: hamoi. Ilia da oloda amoga noga:le madelagi dagoi ba:i. Amo huluane e da balasega dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","E da sefe amola nasubu gilisi amo fadegama:ne, ofodo hamoi. Amola ‘safala’, ofodo, ma:go amola bianoi ofodo amo lalu gaguli masa:ne, amo huluane balasega hamoi. ");
INSERT INTO beo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","- ");
INSERT INTO beo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","E da nasubu amo gudu sa:ima:ne, gigiadamoi hamoi. E da amo liligi oloda ea gadodili legesu hagudu amo oloda ea bada sagai amoga lala:gilisi. E da oloda ea hegomai biyaduyale gala amoga gasisalasu oloda gaguli masa:ne lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","E da amo oloda gaguli masa:ne, aga:isia ifa aduna hamoi. E da amo ifa aduna balasega dedeboi. ");
INSERT INTO beo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","E da amo ifa gasisalasu oloda la:di la:di hamoi, amo ganodini sali. E da oloda amo aga:isia ifa da:fe amoga gagili agoane hamoi. ");
INSERT INTO beo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","E da balase dodofesu ofodo amola ea balase bai hamoi. Uda da Hina Gode Ea Abula Diasu Holeiga hawa: hamonanu amo ilia daiya ba:su lale, amoga ofodo hamoi. ");
INSERT INTO beo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","E da Da:bena:gele Abula Diasu amo gagomusa: abula gagoi hamoi. E da ga (south) la:di guga amoga abula noga:idafa ea sedade defei 44 mida amo hamone gosagisi. ");
INSERT INTO beo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","E da amo abula gosagisimusa: golasu ifa balasega hamoi 20 amola bai salasu balasega hamoi 20 amola hamoi dagoi. Golasu ifa amoga ma:go amola bulufalegei dududawalo agoane da silifa amoga hamoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","E da amo defele ga (north) la:di guga amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Guma:dini, e da abula ea defei da 22 mida amo golasu ifa nabuane gala amola bai nabuane gala, amoga gosagisi. ");
INSERT INTO beo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Gusudili amo da logo holei ea sogebi gagoi da guma:dini defele 22 mida defei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Logo holei da dogoa ba:i. Ea la:diga da gagoi abula 6.6 mida defei ba:i. Eno la:diga da amo defele ba:i. Abula da la:di golasu ifa udiana amola bai udiana amoga gosagisi ba:i. La:di da amo defele ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Abula huluane amo gagomusa: gosagisi da abula noga:i ahea:ya:i amoga hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Gagoi golasu ifa huluane da silifa dagulu bulufalegei agoane gilisili disi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Logo holeidafa da abula 9 mida la:di amola 2 mida gado heda:i la:di amo defei amoga hamoi. Amo abula amoga sibi hinabo mola:ya:i, oga:iyei amola yoi amoga amuni ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Amo abula da golasu ifa biyaduyale gala amola ilia bai biyaduyale gala amoga gosagisi ba:i. Ilia ma:go amola habuga dududawalo agoane da silifa amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Abula Diasu amola gagoi ilia golasu ifa sagasu da balasega hamoi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hina Gode Ea Hadigi Abula Diasu amo ganodini igi gasui aduna amo da:iya da Gode Ea Sema nabuane gala dedei dagoi ba:i. Abula diasu liligi hamomusa:gini, Mousese da liligi lama:ne dedene legema:ne sia:i. Lifai fi dunu da amo dedene legei. Ilia ouligisu dunu da Elane egefe Idama galu. Ouli liligi lai amo ilia defei da hagudu dedei diala. ");
INSERT INTO beo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bisa:liele (Uli egefe amola He ea aowa - Yuda fi dunu) da Hina Gode Ea liligi hamoma:ne sia:i amo huluane hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ea fidisu dunu, Ouhoulia:be (Ahisama:ge egefe - Da:ne fi dunu) da ouli, igi amola ohe gadofo amoga dedesu hou dawa:su. E da hawa: hamoma:ne, osa:le dedesu dawa:i amola abula amoga sibi hinabo mola:ya:i, oga:iyei amola yoi amo amunasu hou dawa:i. ");
INSERT INTO beo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Gouli huluane amo Hina Godema Ea Hadigi Abula Diasu gaguma:ne iasu ea dioi defei (Amo da dioi defeidafa amoga ba:i) da 1,000 gilogala:me ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Silifa amo ilia Isala:ili dunu afae afae ilima lai ea dioi defei (amo amola ilia da dioi defeidafa amoga ba:i) da 3,430 gilogala:me ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ilia da dunu ilia idi defele dunu huluane afae afae ilima lai. Amola ilia da dioi defeidafa amo esoga ilia da ilegei amoga dioi defei ba:i. Ilia da Isala:ili dunu idisia dunu ode 20 lalelegei amola amo baligi da idi 603,550 ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","28","Ilia da silifa mogili, dioi defei 3,400 gilogala:me amo lale, amoga bai 100 agoane gala amo Hadigi Malei Sesei amola ea abula bugima:ne hamoi. Bai afae afae hamoma:ne, ilia da gouli 34 gilogala:me amoga hamoi. Silifa 30 gilogala:me hame lai dialu, amoga Bisa:liele da bulufalegesu dududawalo, golasu ifa ma:go amola golasu ifa habuga hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Balase amo da Hina Godema modale ligiagale i, amo ea dioi defei da 2,425 gilogala:me ba:i. ");
INSERT INTO beo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E da amo balase amoga Hina Gode Ea Abula Diasu logo holei ifa amo ea bai, amola balase oloda, ea gigiadomai, oloda ea liligi huluane, ");
INSERT INTO beo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","gagoi golasu ifa ilia sagasu bai, Hadigi Abula Diasu ea udidisu ifa amola gagoi ea udidisu ifa, amo huluane e da amo balasega hamoi. ");
INSERT INTO beo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ilia da sibi hinabo mola:ya:i, oga:iyei amola yoi amo gouli gobiaha:i amola abula noga:idafa amoga gobele salasu dunu ilia da Hadigi Malei Sesei ganodini hawa: hamosea sala, hahamoi dagoi. Hina Gode da Mousesema hamoma:ne sia:i defele ilia da Elane ea gobele salasu abula hamoi. ");
INSERT INTO beo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ilia da ‘ifode’ amo abula noga:i amola sibi hinabo mola:ya:i, oga:iyei amola yoi amoga hamoi. Noga:i ba:ma:ne ilia da abula amoga fedege amuni. ");
INSERT INTO beo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ilia da gouli amo ha:maga fane, oudahida:le, efe agoane hamone, amo ilia da ahea:ya:i abula amola sibi hinabo amo ganodini amunasu. ");
INSERT INTO beo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ilia da bulu aduna amo da ‘ifode’ amo gobele salasu dunu ea gida adunaga lala:gilisimusa: hamoi. ");
INSERT INTO beo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Amola Hina Gode Ea Mousesema hamoma:ne sia:i defele, abula bulu da ‘ifode’ amoma madelagi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ilia da ‘ganilia:ne’ igi aduna noga:iwane lale, amoga Ya:igobe egefelali fagoyale gala ilia dio dedene, gouli bai amoga ligisili madelagi. ");
INSERT INTO beo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Amalalu, ilia da amo igi, ‘ifode’ gida bulu amo da:iya lala:gilisi. Hina Gode da Mousesema hamoma:ne sia:i defele, Isala:ili fi huluane ilia dio da gobele salasu Ouligisu dunu ea gida da:iya dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ilia da gobele salasu Ouligisu dunu amo salima:ne, bidegi gaga:su amo ‘ifode’ ea sibi hinabo amola abula amuni, amo defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Amo ea defei da la:di afae da 22 sedimida amola la:di eno da defele 22 sedimida. Amo abula dogoa selefale abula aduna agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Amoga igi noga:iwane dadalesu biyaduyale gala bulufalegele lala:gilisi dagoi ba:i. Dadalesu age ganodini, igi udiana amo ‘lubi’, ‘douba:se’ amola ganede lala:gilisi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Dadalesu ageyadu ganodini igi udiana eno amo emelalede, ‘sa:faia’ amola ‘daimode’ lala:gilisi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Dadalesu osoda ganodini igi udiana amo ‘degaoise’, ‘a:gade’ amola ‘a:midiside’ lala:gilisi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Dadalesu biyadu amo ganodini igi udiana eno amo ‘belile’, ‘ganilia:ne’ amola ‘ya:sabe’ lala:gilisi dagoi ba:i. Amo noga:i igi huluane afae afae gouli bai amoga madelagi bidegi gaga:su bagedigi dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ilia da amo igi fagoyale gala huluane afae afae amoga Ya:igobe egefelali ilia dio huluane dedei. Amo dio da Isala:ili fi fagoyale gala ilia dio olelesu. ");
INSERT INTO beo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ilia da bidegi gaga:su amoga gouli sia:ine gobiaha:i defele bione lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ilia da gouli gasisalasu aduna gouliga hamoi amo bidegi gaga:su ea gado hegomai aduna amoga lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ilia da gouli sia:ine aduna amo gasisalasuga lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ilia da gouli sia:ine aduna eno bidi amo gouli bai aduna amoga lala:gilisi. Amalalu, ilia da ‘ifode’ ea gida bulu amoga lala:gilisi ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Amalalu, ilia da gouli gasisalasu aduna eno hamone, bidegi gaga:su ea gudu hegomai aduna ganodini ‘ifode’ dafulili amoga lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ilia da gouli gasisalasu aduna eno hamone, amo da ‘ifode’ ea gida bulu ea guduga bulu eno amoga gadodili lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ilia da Hina Gode Ea Mousesema hamoma:ne sia:i defele, bidegi gaga:su amo ea gasisalasu amola ‘ifode’ ea gasisalasu amoga mola:ya:i gobiaha:i amoga lala:gilisi. Agoane hamobeba:le, bidegi gaga:su da bulu gadodili hame hoholei dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ilia da gobele salasu dunu ea abula amo ‘ifode’ dedebosu da sibi hinabo mola:ya:i amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Gobele salasu dunu ea dialuma salimusa: gelabo da amo abula ganodini ba:i. Ilia da amo gelabo mae gadelama:ne ea fe amo gasa ima:ne, noga:le amuni. ");
INSERT INTO beo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Ilia da Hina Gode Ea Mousesema hamoma:ne sia:i defele, abula ea fe gudu diala amoga ‘bomigala:nidi’ ifa fage agoane liligi sibi hinabo mola:ya:i, oga:iyei amola yoi amoga hamoi amola gouli belo lala:gilisi. Ilia da sibi hinabo hamoi ‘bomigala:nidi’ afadafa amalalu, gouli belo afadafa agoane fega lala:gilisi. ");
INSERT INTO beo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ilia da Elane amola egefelali amo ilia da:i salasu hamoi, ");
INSERT INTO beo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","amola ilia da habuga amola selefa ili salima:ne hamoi. ");
INSERT INTO beo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Amola ilia da abula bulu noga:iwane amoga hamoi amola amoga sibi hinabo gobiaha:i mola:ya:i, oga:iyei amola yoi amuni. Ilia da Hina Gode Ea Mousesema hamoma:ne sia:i defele hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ilia da noga:i ba:su bagedigi liligi gouliga hamoi. Amo da:iya ilia da agoane dedei, “Hina Godema mogili gagai dagoi.” ");
INSERT INTO beo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ilia da amo bagedigi gobele salasu dunu ea abula habuga ba:le gaidiga mola:ya:i efe amoga lala:gilisi. Hina Gode Ea Mousesema hamoma:ne sia:i, amo defele ilia da hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Hina Gode Ea Abula Diasu amo hawa: hamosu huluane da hamoi dagoi ba:i. Isala:ili dunu da Hina Gode Ea Mousesema hamoma:ne sia:i defele huluane hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","34","Ilia da liligi huluane Mousesema gaguli misi. Amo da Gode Ea Abula Diasu (Da:bena:gele), ea dedebosu, ea ga dedebosu, ea ma:go, abula:ime, bulufalegei ifa, golasu ifa, amo ea bai huluane, ");
INSERT INTO beo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Gode Ea Gousa:su Sema Gagili, igi gasui amo ganodini sali, ea gaguli ahoasu ifa, ea ga:lu, ");
INSERT INTO beo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","fafai amola ea ifa amola ea liligi huluane, Godema agi iasu liligi, ");
INSERT INTO beo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","gamali bai gouliga hamoi, gamali amola ea liligi huluane, gamali susuligi, ");
INSERT INTO beo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","gabusiga: manoma gobesisu oloda amola ea gaguli ahoasu ifa, ligiagasu susuligi, gabusiga: manoma, Gode Ea Abula Diasu logo holei abula ga:su, ");
INSERT INTO beo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","gobele salasu oloda balasega hamoi, ea gigiadomai, ea gaguli ahoasu ifa amola liligi huluane, dodofesu ofodo amola ea bai, ");
INSERT INTO beo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","gagoi gaga:su abula amola ea golasu ifa amola ilia bai huluane, gagoi ea logo holei ga:su abula, Abula Diasu gagoi amola ilia udidisu ifa sagasu amola efe udidisu, Abula Diasu ea liligi huluane, ");
INSERT INTO beo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","abula ida:iwane gobele salasu dunu da Hadigi Malei Sesei ganodini hawa: hamosea ilia da amo sala amola hadigi abula Elane amola egefelali da sala amo huluane hamoi. ");
INSERT INTO beo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Hina Gode da amo hawa: hamosu Mousesema hamoma:ne sia:i dagoi. Amola Isala:ili dunu da Ea sia:i defele noga:le hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mousese da ilia hamoi huluane abodei. E da ilia da Hina Gode Ea hamoma:ne sia:i defele hamoi dagoi ba:i. Amaiba:le, e da Gode da ili hahawane dogolegele fidima:ne, Godema sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Eso age amo oubi age amoga Hina Gode Ea Hadigi Abula Diasu amo gaguma. ");
INSERT INTO beo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Amo ganodini, di Gode Ea Gousa:su Sema Gagili (amo ganodini Hamoma:ne sia:i Nabuane Gala gasui aduna diala) ligisili, ea ba:le gaidiga amo abula gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Fafai amo ganodini gaguli misa. Amo da:iya ea liligi ligisima. Amola gamali bai ganodini gaguli misini, gamali amo bai da:iya ligisima. ");
INSERT INTO beo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Gouli gabusiga: manoma gobesisu oloda amo Gode Ea Gousa:su Sema Gagili ea wamolegesu abula ba:le gaidiga ligisima. Amola Abula Diasu ea logo holeiga abula gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Abula Diasu ea ba:le gaidiga amo gobele salasu oloda ligisima. ");
INSERT INTO beo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Dodofesu ofodo amo oloda amola Abula Diasu dogoa sogebi amoga ligisima. Amo ganodini hano sogasalili nabama. ");
INSERT INTO beo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Sisiga:su gagoi amo gaguli, ea logo holeiga ea abula gosagisima. ");
INSERT INTO beo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Amasea, Abula Diasu amola ea liligi huluane amoga hadigi susuligi sogadigima. Di da agoane momodale ligiagasea, Hadigi Abula Diasu da modale ligiagai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Amasea, oloda amola ea liligi huluane amoga susuligi sogadigili, momodale ligiagama. ");
INSERT INTO beo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Amo defele, dodofesu ofodo amola ea bai momodale ligiagama. ");
INSERT INTO beo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Di da Elane amola egefelali Hadigi Abula Diasu ea logo holeiga oule misini, ilima hano ulima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Elane amoma ea gobele salasu dunu abula gasisa:lima. Susuligi sogadigili, e da Nama gobele salasu hawa: hamoma:ne e mogili gagama. ");
INSERT INTO beo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ea egefelali amola oule misini, ilima da:i salasu gasisa:lima. ");
INSERT INTO beo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Amasea, ilia ada defele, ilia da Nama gobele salasu hawa: hamoma:ne, ligiagasu susuligi ilia dialuma da:iya sogadigili, ili momogili gagama. Amo da ilia amola iligaga fi mae yolesili gobele salasu dunu hawa: hamonanoma:ne momogili gagai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mousese da Gode Ea hamoma:ne sia:i defele huluane hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Amaiba:le, ilia da Idibidi soge fisili, ode ageyadu ahoanu, eso age amola oubi age ganodini, Hina Gode Ea Hadigi Abula Diasu da gagui dagoi dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mousese da Hadigi Abula Diasu ea bai huluane ligisili, ea abula:ime huluane bugi, ea bulufalegei dududawalo ligisi amola ea golasu ifa bugi. ");
INSERT INTO beo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","E da Abula Diasuga amo abula dedebosu gisigi amola dabuagado dedebosu eno gisigi. E da Gode Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Amalalu, e da igi gasui aduna lale, Gode Ea Gousa:su Sema Gagili ganodini sali. E da gaguli ahoasu ifa amo Gode Ea Gousa:su Sema Gagili ea gasisalasu ganodini sali amola Gagili ea ga:lu figisi dagoi. ");
INSERT INTO beo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Amalalu, e da Gode Ea Gousa:su Sema Gagili amo Abula Diasu ganodini sali amola ea wamolegesu abula amo gosagisi. Amo hamobeba:le, e da Gode Ea Gousa:su Sema Gagili wamolegele gaga:le, Gode Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","E da fafai amo Abula Diasu ganodini ga (north) la:didili gaga:su abula amo gadili ligisi. ");
INSERT INTO beo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","E da fafai da:iya Godema iasu agi, Gode Ea hamoma:ne sia:i defele ligisi. ");
INSERT INTO beo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","E da gamali bai amo Abula Diasu ganodini ga (south) la:di amoga ligisi. Fafai da la:di amola gamali bai da la:didili dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Amola Hina Gode Ea midadi Ea Diasu amo ganodini e da gamali ulagisi, Gode Ea hamoma:ne sia:i defele. ");
INSERT INTO beo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","E da gouli oloda Abula Diasu ganodini gaga:su abula ea ba:le gaidiga ligisi. ");
INSERT INTO beo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Amo da:iya e da gabusiga: manoma gobesi. E da Hina Gode Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","E da Abula Diasu ea logo holei amoga ga:su abula gosagisi. ");
INSERT INTO beo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Amo ga:su abula ea ba:le gaidiga, e da gobele salasu oloda ligisi. Amo da:iya e da ohe fi amola widi amola gagoma gobele salasu iasu amo gobesi. ");
INSERT INTO beo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","E da Dodofesu Ofodo amo oloda amola Abula Diasu dogoa sogebi amoga ligisi. Amo ganodini e da hano sogasalasili, nabalesi. ");
INSERT INTO beo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Amogai, Elane amola egefelali da ilia lobo amola emo dodofesu. ");
INSERT INTO beo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ilia da Abula Diasu ganodini golili daloba amola oloda amoga heda:loba, ilia da Hina Gode Ea hamoma:ne sia:i defele, ilia lobo amola emo dodofesu. ");
INSERT INTO beo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mousese da Abula Diasu amola oloda sisiga:su gagoi amo gagui dagoi. Amola, gagoi ea logo holeiga abula ga:su gosagi. Amaiba:le, e da hawa: hamosu huluane dagolesi. ");
INSERT INTO beo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Amalalu, mumobi da Abula Diasu amo dedeboi amola Hina Gode Ea Esalebe agoane hadigi sinenemegi gala da Abula Diasu ganodini dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Amaiba:le, Mousese da Abula Diasu ganodini golili masunu hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Isala:ili dunu da ilia abula diasu gilisisu amo ganodini esalusu. Mumobi da gadodili heda:le asili, amo fawane ba:beba:le ilia da mugululi eno sogega asi. ");
INSERT INTO beo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Be mumobi da Abula Diasu dedebomusa: dialebe ba:loba, ilia da mae mugululi esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ilia da sogega ode bagohame lafiadalebe ba:i. Amo ode huluanega, Hina Gode Ea Esalebe mumobi Abula Diasu da:iya gadodili dialebe ba:i, amola gasia lalu nenanebe Abula Diasu amo da:iya gadodili dialebe ba:i. Sia: Ama Dagoi ");
INSERT INTO beo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Hina Gode da Ea Abula Diasuga esala, Mousesema misa:ne wele sia:i. E da Mousesema amo gobele salasu iasu sema olelei. ");
INSERT INTO beo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Isala:ili dunu da gobele salasu hou hamomusa: dawa:sea, ilia da agoane hamoma:ne sia:ma, ‘Nowa da ohe gobele salasu imunusa: dawa:sea, e da ea bulamagau afae o sibi afae o goudi afae lale ima:mu. ");
INSERT INTO beo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","E da ea bulamagau afae gobele salimusa: dawa:sea, e da bulamagau gawali afae ida:iwane gala, ledo hamedafa gala, gaguli misa:ne sia:ma. Hina Gode da amo dunu hahawane gousa:ma:ne, e da amo bulamagau gawali, Gode Ea Abula Diasu amo ea holeiga ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Amo dunu da ea lobo amo bulamagau gawali ea dialuma da:iya ligisima:mu. Amasea, Hina Gode da amo bulamagau gobele salasu liligi amo dunu ea wadela:i hou fadegale fasima:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","E da amogawi bulamagau medole legema:mu. Amola Elane ea gobele salasu dunu ilia da bulamagau ea maga:me lale, Hina Godema imunu. Amasea, ilia da amo maga:me oloda (amo da Abula Diasu ea holeiga diala) amo ea la:idi biyadu gala amoga sogaga:la:gaganomu. ");
INSERT INTO beo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Amasea, gobele salasu iabe dunu, e da bulamagau ea gadofo houga:le, ea da:i hodo dadega:mu. ");
INSERT INTO beo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Amola gobele salasu dunu ilia da oloda da:iya lalu habei gilisili, didima:mu. ");
INSERT INTO beo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ilia da amo ohe ea dadega:i fifi (huluane, dialuma amola sefe) laluga ligisimu. ");
INSERT INTO beo_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Gobele salasu iabe dunu da ohe ea iga amola emo amo dodofemu. Amasea, gobele salasu ouligisu dunu da amo liligi huluanedafa oloda da:iya gobesimu. Hina Gode da amo ha:i manu gobele salasu iasu ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Isala:ili dunu afae da sibi o goudi gobele salimusa: dawa:sea, e da gawali ida:iwane gala, ledo hamedei, ilegema:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","E da amo ohe oloda la:idi gagoe (north) amoga medole legemu. Amasea, gobele salasu dunu da ea maga:me oloda ea la:idi biyaduyale gala amoga sogaga:la:gaganoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Amasea, dunu hi da amo ohe ea da:i hodo dadega:le, gobele salasu ouligisu dunu da dadega:i fifi (huluane, amola dialuma amola sefe) amo laluma gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Gobele salasu iabe dunu da amo ohe ea iga amola emo dodofemu. Amasea, gobele salasu ouligisu dunu da amo gobele salasu Hina Godema ianu, oloda da:iya laluma gobesimu. Hina Gode da amo ha:i manu gobele salasu ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Isala:ili dunu da sio amo gobele salasu imunusa: dawa:sea, e da dafe sio o musuni gaguli misa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Gobele salasu ouligisu dunu da amo sio oloda amogawi Hina Godema ianu, ea asogoa dugini, ea dialuma amo oloda da:iya gobesimu. E da ea maga:me oloda beba:le soga:sisimu. ");
INSERT INTO beo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","E da sio ea wa amola amo ganodini liligi dialebe fadegale, oloda ea gusudili la:idiga (nasubu ligisisu) amoga galagamu. ");
INSERT INTO beo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","E da sio ea ougia aduna dodobole gaguli, amo mae fadegale, ea da:i hodo dudugale, mae dadega:le, amo oloda da:iya gobesimu. Hina Gode da amo ha:i manu gobele salasu ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Nowa da ‘gala:ine’ iasu Hina Godema imunusa: dawa:sea, e da hidadea amo ‘gala:ine’ goudale, falaua hamoma:ne sia:ma. E da amoga olife susuligi amola gabusiga: manoma legelalu, ");
INSERT INTO beo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","gobele salasu dunu (Elane egefelali) ilima gaguli misa:ne sia:ma. Amasea, gobele salasu ouligisu dunu da ea loboga falaua fonobahadi amola olife susuligi fonobahadi amola gabusiga: manoma huluane amo lale, oloda da:iya gobesimu. Amo liligi fonobahadi da dawa:digima:ne olelesu amane; liligi huluanedafa da Hina Godema ia dagoi olelesa! Hina Gode da amo ha:i manu gobele salasu ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Amo ‘gala:ine’ iasu hame gobei diala da gobele salasu dunu ilia ha:i manu liligi. Amo ‘gala:ine’ da hadigidafa liligi. Bai amo da ha:i manu Godema imunusa: liligi, amoga lai dagoi. ");
INSERT INTO beo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Be ‘gala:ine’ gobele salasu liligi da agi ga:gi gobele nasu amo ganodini gobei galea, amo agi ga:gi hamosea, amoga ‘yisidi’ mae gilisima. Amo gobele salasu da ‘agi ga:gi’ (falaua amola olife susuligi, gilisi amoga hamoi) o belowagi amo olife susuligiga legei da defea. ");
INSERT INTO beo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Be dilia da agi ga:gi amoga gobei gobele salasu imunusa: dawa:sea, falaua amola olife susuligi gilisima, be amoga ‘yisidi’ mae gilisima. ");
INSERT INTO beo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Amo liligi gilisili, ununuguni, amola gobele salasu iasea, amoga olife susuligi sogadigima. ");
INSERT INTO beo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Be dilia da agi ga:gi ofodo ganodini gobei, imunusa: dawa:sea, falaua amola olife susuligi gilisili hamoma. ");
INSERT INTO beo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Amo gobei Hina Godema imunusa: gaguli misini, gobele salasu Ouligisu dunu ema ima:mu. Amasea, e da oloda amoga gaguli masunu. ");
INSERT INTO beo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","E da amo liligi fifili, fonobahadi fifi amo oloda da:iya gobesimu. Amo da dawa:digima:ne olelesu amane, ‘Liligi huluane da Hina Godema i dagoi’. Hina Gode da amo ha:i manu gobele salasu ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Iasu liligi oloda da:iya hame gobei dialea, amo huluane gobele salasu dunu ilia da lamu. Amo da hadigidafa liligi. Bai amo da Hina Godema imunusa: liligi, amoga lai dagoi. ");
INSERT INTO beo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","‘Gala:ine’ gobele salasu liligi huluanedafa dilia Hina Godema iaha, amoga ‘yisidi’ maedafa gilisima. Ha:i manu amo dilia Hina Godema iaha, amoga agime hano amola ‘yisidi’ maedafa gilisima. Amo da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Dilia gagoma faisu eso doaga:sea, muni fai gagoma amo Hina Godema imunusa: gaguli misa. Be amo oloda da:iya mae gobesima. ");
INSERT INTO beo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Dilia ‘gala:ine’ Godema iasu liligi huluane amo da:iya deme (sali) legema. Bai deme da dili amola Gode da Gousa:su hamoi dagoi amo dawa:digima:ne olelesu diala. (Dilia Godema gobele salasu liligi huluane amoga deme legema). ");
INSERT INTO beo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Dilia da gagoma degabo fai amo Hina Godema gaguli masea, gagoma gobei o gagoma goudai amo Ema ima. ");
INSERT INTO beo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Amoga olife susuligi gilisima, amola gabusiga: manoma legema. ");
INSERT INTO beo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Amasea, gobele salasu dunu e da dawa:digima:ne olelesu ha:i manu fifi amola gabusiga: manoma huluane gobesima:mu. Amo da Hina Godema ha:i manu iasu liligi gala. ");
INSERT INTO beo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Nowa dunu da ea ohe amo Godema Hahawane Gilisili Olofole Iasu imunusa: dawa:sea, e da bulamagau gawali o aseme ida:iwane, ledo hamedei ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Amo dunu da bulamagau Hina Gode Ea Abula Diasu amo holeiga oule ahoasea, bulamagau ea dialuma da:iya ea lobo ligisilalu, amo bulamagau medole legemu. Amasea, Elane gobele salasu dunu, ilia da bulamagau ea maga:me oloda ea la:idi biyaduyale gala amoga sogaga:la:gaganomu. ");
INSERT INTO beo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","- ");
INSERT INTO beo_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Ilia da amo ohe dasega:le, ea dialumagaisa, ea fogome, ea sefe amola ea habe la:idi ida:iwane gala, amo ha:i manu iasu Hina Godema ima:ne olelemu. ");
INSERT INTO beo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Gobele salasu dunu da amo ha:i manu iasu liligi amola gobele salasu liligi huluane gilisili oloda da:iya gobesimu. Hina Gode da amo ha:i manu gobele salasu amo ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Dilia da sibi o goudi amo Hahawane Gilisili Olofole Iasu imunusa: dawa:sea, gawali o aseme amo ida:iwane gala amola ledo hamedafa gala ilegema. ");
INSERT INTO beo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Dunu afae da sibi imunusa: dawa:sea, ");
INSERT INTO beo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","e da Abula Diasu ea midadi amo sibi ea dialuma da:iya ea lobo ligisili, medole legemu. Gobele salasu dunu ilia da ea maga:me amo oloda ea la:idi biyaduyale gala amoga sogaga:la:gaganomu. ");
INSERT INTO beo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","- ");
INSERT INTO beo_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Amasea, ilia da sibi ea sefe, ea sefe la:go amola dialumagaisa, ea fogome ganumui amola sefe amoga gilisi, amola habe ea la:idi noga:i, amo huluane ha:i manu iasu agoane Hina Godema imunu. ");
INSERT INTO beo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Gobele salasu ouligisu dunu da amo liligi huluane amo Hina Godema ha:i manu gobele iasu ima:ne, oloda da:iya gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Dunu afae da goudi Godema imunusa: dawa:sea, ");
INSERT INTO beo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","e da amo goudi ea dialuma da:iya ea lobo ligisilalu, Abula Diasu ea midadi medole legemu. Gobele salasu dunu ilia da ea maga:me amo oloda ea la:idi biyaduyale gala amoga sogaga:la:gaganomu. ");
INSERT INTO beo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","- ");
INSERT INTO beo_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Amola e da dialumagaisa amola fogome ganumui amola sefe amoga dialebe, amola habe ea la:idi noga:i amo huluane ha:i manu iasu agoane, Hina Godema imunu. ");
INSERT INTO beo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Gobele salasu dunu da amo liligi huluane lale, oloda da:iya gobesima:mu. Amo da ha:i manu iasu amola Hina Gode da amo hahawane ba:sa. Sefe huluane da Hina Gode Ea:. ");
INSERT INTO beo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Isala:ili dunu da sefe amola maga:me hamedafa manu. Amo da sema bagade amola Isala:ili dunu huluane ilia habi esalea, amo sema noga:le ouligima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Hina Gode da Mousesema e da Isala:ili dunuma amane alofele sia:ma:ne sia:i, ");
INSERT INTO beo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Nowa da Hina Gode Ea hamoma:ne sia:i hame dawa:beba:le giadofai galea, e da amane hamoma:mu, ");
INSERT INTO beo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Gobele salasu Ouligisu dunu da giadofabeba:le, fofada:su da Isala:ili dunu huluane ilima doaga:sea, e da bulamagau mano gawali (noga:idafa, ledo hamedei) ea giadofabeba:le dabe ima:ne, Hina Godema gobele salimu. ");
INSERT INTO beo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","E da bulamagau gawali amo Abula Diasu holeiga oule asili, ea dialuma da:iya ea lobo ligisili, Hina Gode ba:ma:ne amo bulamagau medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Amasea, gobele salasu hina dunu da bulamagau ea maga:me mogili lale, Abula Diasua golili gaguli masunu. ");
INSERT INTO beo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","E da ea lobo sogo maga:mega gele, amo maga:me hadigi Abula (amo da Abula Diasu afafaia) ea midadi fesuale agoane foga:gagala:mu. ");
INSERT INTO beo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Amasea, e da maga:me eno amo hono da gabusiga: manoma oloda ea hegomaiga gala amoga foga:gagala:mu. E da maga:me eno diala amo oloda (Abula Diasu holeiga diala amola amoga ilia da gobele salasu liligi gobesisa) amo ea baiga sogadigimu. ");
INSERT INTO beo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","- ");
INSERT INTO beo_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","E da amo bulamagau ea sefe, sefe da iga dedebosa (oso sefe), fogome ganumui amola ilia sefe amola habe ea la:idi noga:iwane, amo lale, ");
INSERT INTO beo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","oloda (amoga ilia da gobele salasu liligi gobesisa) amo da:iya gobesimu. E da Hahawane Gilisili Olofole Iasu ohe ea sefe gobesisu amo defele gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Be amo bulamagau ea gadofo, ea hu huluane, ea emo amola ea iga huluane, ");
INSERT INTO beo_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","e da abula diasu gilisisu amoga gadili gaguli asili, ledo hamedei sogebi (amoga ilia da nasubu duduli fasisu) amogai nema:ne gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Be Isala:ili fi dunu huluane da hame dawa:beba:le Hina Gode Ea hamoma:ne sia:i afae giadofasea, ");
INSERT INTO beo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ilia wadela:i hou hamoi ilia dawa:sea, ilia huluane da bulamagau mano gawali ilia Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne, Hina Gode Ea Abula Diasu amoga oule masunu. ");
INSERT INTO beo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Isala:ili fi ilia ouligisu dunu da bulamagau ea dialuma da:iya ilia lobo ligisili, amogawi medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Gobele Salasu hina dunu da bulamagau ea maga:me mogili lale, Abula Diasu ganodini gaguli misunu. ");
INSERT INTO beo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","E da ea lobo sogo maga:me ganodini gele, hadigi Abula ea midadi fesuale agoane foga:gagala:mu. ");
INSERT INTO beo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Amasea, e da maga:me eno amo hono da gabusiga: manoma oloda ea hegomaiga gala, amoga foga:gagala:mu. E da maga:me eno diala amo oloda (Abula Diasu holeiga diala amola amoga ilia da gobele salasu liligi gobesisa) amo ea baiga sogadigimu. ");
INSERT INTO beo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Amasea, e da sefe huluane lale, oloda da:iya gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","E da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne gobele salasu defele, amo bulamagau gobele salimu. Amasea, Isala:ili fi dunu ilia wadela:i hou da gogolema:ne olofoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Amasea, e da hi Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne, bulamagau amo abula diasu gilisisu gadili gaguli asili gobesisa, amo defele e amo bulamagau gobesimu. Amo gobele salasu da Isala:ili fi dunu huluane ilia wadela:i hou dodofema:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Be fi ouligisu dunu da hame hanaiba:le amola hame dawa:beba:le, Hina Gode Ea hamoma:ne sia:i afae giadofasea, ");
INSERT INTO beo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","dunu eno da e da giadofai ema olelesea, e da goudi gawali ida:iwane ledo hamedei, gaguli misa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","E da amo goudi ea dialuma da:iya ea lobo ligisili, oloda ea gagoe (north) la:idi, (amoga ohe gobele salasu hamoma:ne ilia medole legebe) amoga medole legemu. Amo gobele salasu iasu da ouligisu dunu ea wadela:i hou fadegale fasima:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Gobele salasu dunu da ea lobo sogo maga:me ganodini gele, hono amo oloda hegomaiga gala amoga legelu amola maga:me eno diala amo oloda ea baiga sogadigimu. ");
INSERT INTO beo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Amasea, e da Hahawane Gilisili Olofole Iasu ohe ilia sefe gobesibi defele, amo goudi ea sefe huluane oloda da:iya gobesimu. Gobele salasu dunu da amomane fi ouligisu dunu ea Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne, gobele salasu hamomu. Amasea, ea wadela:i hou da gogolema:ne olofoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Be dunudafa da mae dawa:le, Hina Gode Ea hamoma:ne sia:i afae giadofale, wadela:i hou hamosea, ");
INSERT INTO beo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","dunu eno da ea giadofai amo ema olelesea, e da goudi aseme noga:idafa, ledo hamedei, amo Godema ima:ne gaguli misa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","E da amo goudi ea dialuma da:iya ea lobo ligisili, oloda ea gagoe (north) la:ididili (amoga ilia da gobele salasu ohe medole legesu) amoga medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Gobele salasu dunu da ea lobo sogo amo goudi ea maga:me ganodini gele, hono amo oloda ea hegomaiga dialebe amo foga:gagala:mu. Amola maga:me eno diala amo oloda ea baiga sogadigimu. ");
INSERT INTO beo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Amasea, e da goudi aseme ea sefe huluane bosolimu (ilia da ohe Hahawane Gilisili Olofole Iasu hamoma:ne medole legei sefe fadegasu defele). Amasea, e da amo sefe oloda da:iya gobesimu. Hina Gode da amo gobele salasu gabusiga: hahawane naba. Gobele salasu dunu da agoane hamosea, e da amo dunu ea wadela:i hou hamoi dabe iaha. Amola amo dunu da gogolema:ne olofosu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Dunu da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu imunusa:, sibi gaguli masea, e da sibi aseme ida:iwane ledo hamedei gaguli misunu da defea. ");
INSERT INTO beo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","E da amo sibi ea dialuma da:iya ea lobo ligisili, oloda ea gagoe (north) la:ididili (amoga ilia da gobele salasu ohe medole lelegesu) amoga medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Gobele salasu dunu da ea lobo sogo amo sibi ea maga:me ganodini gele, hono amo oloda ea hegomaiga diala amoga legemu. Amola maga:me eno diala amo oloda ea baiga sogadigimu. ");
INSERT INTO beo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Amasea, e da sibi aseme ea sefe huluane duga:le (ilia da sibi Hahawane Gilisili Olofole Iasu hamoma:ne medole legei ea sefe duga:su defele), amo sefe amola ha:i manu iasu Hina Godema i, amo gilisili gobesimu. Agoane hamobeba:le, gobele salasu dunu da amo dunu ea wadela:i hou hamoi ea dabe iaha. Amasea, amo dunu ea wadela:i hou da gogolema:ne olofoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Dilia hou hagudu dedei diala ba:sea, Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:- Fofada:su ouligisu dunu da dunu afae amo fofada:su diasuga hou e da ba:i o nabi amo olelemusa: misa:ne sia:sea, amola amo dunu da ea ba:i o nabi liligi noga:le hame olelesea, amo dunu da wadela:le hamoiba:le, fofada:mu gala. ");
INSERT INTO beo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Dunu da mae dawa:le, Isala:ili sema ganodini ledo hamoi liligi digili ba:sea (ledo hamoi liligi afae da bogoi ohe, digili ba:su agoane) amo dunu da ea hamoi dawa:digisia, e da ledo hamoi dagole, fofada:mu gala. ");
INSERT INTO beo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Dunu da mae dawa:le, ledo hamoi liligi dunu ea da:i hodo amoga misi, amo digili ba:sea, amo dunu da hi hamoi dawa:sea, e da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Nowa dunu da udigili dafawanedafa sia: ilegesea, e da ea giadofai dawa:sea, e da fofada:mu amola wadela:i hou gogolema:ne olofosu dabe imunu galebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Dunu da wadela:i hou hamoi dagoiba:le, e da ea wadela:i hou sisane fofada:ma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Amasea, e da ea Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne, e da Hina Gode Ema ima:ne, sibi o goudi aseme gaguli misa:ne sia:ma. Gobele salasu dunu da amo ohe, dunu ea wadela:i hou gogolema:ne olofomusa:, gobele salimu. ");
INSERT INTO beo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Be dunu da sibi o goudi bidi lamu hamedei ba:sea, e da ea Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne, ‘dafe’ sio aduna o musuni sio aduna gaguli misunu da defea. Afae da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu amola eno da Wadela:i Hou Dabe Ima:ne iasu agoane ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","E da ela gobele salasu dunu ema gaguli misunu. Gobele salasu dunu da hidadea sio afae Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne lale, ea asogoa dugimu. Be ea dialuma hame dugini fasimu. ");
INSERT INTO beo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","E da ea maga:me mogili oloda ea la:ididili foga:gagala:mu. Maga:me eno diala, e da oloda baiga sogadigimu. Amo da wadela:i hou fadegama:ne iasu gala. ");
INSERT INTO beo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Amasea e da sio eno lale, sema defele, Wadela:i Hou Dabe Ima:ne gobele salasu hamomu. Gobele salasu dunu da agoai dunu ea wadela:i hou dedeboma:ne gobele salabeba:le, amo dunu da gogolema:ne olofoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Be amo dunu da ‘dafe’ sio o musuni sio aduna bidi lamu hamedei ba:sea, e da falaua gilougala:me afae ea Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne gaguli misunu. Amo da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu, gala:ine iasu hame. Amaiba:le, e da amoga olife susuligi amola gabusiga: manoma hame legemu. ");
INSERT INTO beo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","E da amo falaua, gobele salasu dunu ema gaguli misini, gobele salasu dunu da amo huluane da Hina Godema i dagoi olelema:ne, lobo gagui afadafa lale, oloda da:iya ha:i manu iasu agoane gobesimu. Amo da wadela:i hou fadegama:ne iasu. ");
INSERT INTO beo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Gobele salasu dunu da agoane amo dunu ea wadela:i hou fadegama:ne, gobele salasu hamomu. Amasea, amo dunu ea wadela:i hou da gogolema:ne olofoi dagoi ba:mu. Gala:ine Iasu defele, falaua eno hame gobei dialebe da gobele salasu dunu ea:.” ");
INSERT INTO beo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Hina Gode da amo hagudu dedei hamoma:ne sia:i amo Mousesema i. ");
INSERT INTO beo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Dunu da Hina Godema muni o liligi imunusa: ilegesea, be mae dawa:le, gogoleiwane amo dabe hame iasea, e da Dabe Ima:ne iasu gaguli misa:ne sia:ma. Amo da sibi o goudi gawali ida:iwane ledo hamedei. Ilia sema ilegei defele, amo ea muni defei sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","E da muni o liligi musa: imunusa: ilegei amo huluane imunu. Amola amoga e da 20% gilisimu. E da sibi o goudi amo gobele salasu dunu ema imunu. Amasea, gobele salasu dunu da amo ohe amo dunu ea Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne gobele sanasimu. Amasea, amo dunu da gogolema:ne olofoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Nowa dunu da mae dawa:le, Hina Gode Ea hamoma:ne sia:i afae giadofasea, e da wadela:le hamoi dagoi ba:mu, amola e da dabe imunu gala. ");
INSERT INTO beo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","E da ea Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ima:ne, gobele salasu dunu ema sibi o goudi gawali ledo hamedei, amo gaguli misa:mu. Amo ea bidi lamu defei da Isala:ili fi ilia bidi lama:ne sema defele ilegemu. Gobele salasu dunu da wadela:i hou amo dunu da mae dawa:le hamoi amo fadegama:ne, amo ohe gobele salimu. Amasea, amo dunu ea wadela:i hou da gogolema:ne olofoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Amo gobele salasu da amo dunu ea Hina Godema wadela:le hamoi Ema Dabe Ima:ne Iasu agoane ba:mu.” ");
INSERT INTO beo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Hina Gode da amo hagudu dedei hamoma:ne sia:i, amo Mousesema i. ");
INSERT INTO beo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Nowa dunu da ea Isala:ili na:iyado dunu ema wadela:le hamosea, e da amo hou hamobeba:le, Hina Godema wadela:le hamosa. Amola e da Hina Godema dabe imunu gala. Amo wadela:i hou da e da inia liligi wamolai o eno dunuma ogogoiba:le ea liligi lai, o eno dunu da hi bu lamusa: ema liligi iasea, e da amo liligi bu hame iaha, ");
INSERT INTO beo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o eno dunu da liligi fisisia, e da amo liligi ba:sea be ogogole hame ba:i sia:sa. ");
INSERT INTO beo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","- ");
INSERT INTO beo_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Dunu da amo wadela:i hou afae hamosea, e da liligi wadela:le lai dagoiba:le, e da dabe imunu gala. Ilia da ema fofada:ne, ea giadofai ba:sea, amo esoga e da ea liligi lai eda ema ea wamolai liligi ea muni defei amola eno20% imunu gala. ");
INSERT INTO beo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Amola ea wadela:i hou Hina Godema Dabe Ima:ne, gobele salasu hamoma:ne, e da gobele salasu dunuma sibi gawali o goudi gawali ledo hamedei gaguli misunu. Amo ea bidi lamu defei ilia da bidi lama:ne sema defele ilegemu. ");
INSERT INTO beo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Gobele salasu dunu da amo dunu ea wadela:i hou hamoi ea dabe gobele salasu hamomu. Amasea, amo dunu ea wadela:i hou da gogolema:ne olofoi dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","9","Hina Gode da Mousesema e da Elane amola egefelalima amo gobele salasu sema olelema:ne sia:i. Ilia da gobele salasu liligi gasi amoga oloda da:iya yolesimu amola lalu da mae ha:ba:dole nenanebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Amasea, gobele salasu dunu, ea abula amola selefa dunumuni salawane, sefe nasubu hamoi oloda da:iya diala amo fadegale, oloda ea bai la:idiga ligisimu. ");
INSERT INTO beo_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Amasea, e da ea abula afadenene, amo nasubu lale, abula diasu gilisisu amoga gadili gaguli asili, ledo hame hamoi sema sogebi amoga ligisimu. ");
INSERT INTO beo_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Lalu oloda da:iya diala da maedafa ha:ba:doma:ne sia:ma. Hahabe huluane, gobele salasu dunu da lalu ifa amoga ligisili, amo da:iya gobele salasu liligi ligisimu amola Hahawane Gilisili Olofole Iasu liligi ea sefe amo gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Lalu oloda da:iya da maedafa haba:doma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Hina Godema Gala:ine Iasu ima:ne hamoma:ne sia:i da hagudu dedei. “Elane fi gobele salasu dunu da oloda midadi Hina Gode Ema Gala:ine Iasu imunu. ");
INSERT INTO beo_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Amasea, e da lobo afaega falaua amola susuligi gasa:le, amoga gabusiga: manoma legele, amola huluanedafa da Hina Godema ia dagoi olelema:ne, amo lobo afaega gasa:i liligi oloda da:iya gobesimu. Hina Gode da amo iasu ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","- ");
INSERT INTO beo_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Gobele salasu dunu ilia da falaua amola susuligi hame gobei diala, amo manu. Ilia da amoga yisidi mae gilisili, agi ga:gi hamoma:ne gobemu. Amola ilia hadigi sogebi (Abula Diasu ea gagoi) amo ganodini, Hina Gode ba:ma:ne, manu. Bai Hina Gode da amo Ha:i Manu Iasu la:idi amo gobele salasu dunuma ia dagoi. Amo da Wadela:i Hou Gogolema:ne Olofoma:ne gobele iasu amola Dabe Ima:ne gobele iasu defele, hadigi dagoi ba:sa. ");
INSERT INTO beo_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Wali amola eso huluanedafa, Elane ea dunu iligaga fi dunu da amo ha:i iasu da gasa bagade hadigi hamoiba:le, eno dunu da amo digili ba:sea, se bagade nabimu. ");
INSERT INTO beo_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Hina Gode da Mousesema hagudu dedei hamoma:ne sia:i Elane gobele salasu dunu ilegema:ne olelei. ");
INSERT INTO beo_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Elane gobele salasu dunu da ea ilegesu eso amoga Hina Godema falaua gilougala:me afae (eso huluane gala:ine iasu ea defei defele) amo ima:ne gaguli misa:ne sia:i. E da dogoa fifili, la:idi afae hahabe imunu amola la:idi eno daeya imunu. ");
INSERT INTO beo_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","E da falaua amoga susuligi gilisili agi gobesu agoai amoga gobele, goudale, gala:ine iasu defele Hina Godema imunu. Hina Gode da amo ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Hina Gode da amo hou mae yolesili hamonanumu sia:i. Elane egaga fi dunu huluane amo da gobele salasu hawa: hamoma:ne ilegeiba:le, da amo hou hamonanumu. Amo Gala:ine Iasu huludafa da Hina Godema gobele salimusa:, oloda da:iya gobesima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Gobele salasu dunu da Gala:ine Iasu iabeba:le, e da amo ea la:idi hamedafa manu. Huluanedafa da oloda da:iya, gobesi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Hina Gode da Mousesema, ");
INSERT INTO beo_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","e da Elane amola egefelalima Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne sia:i hagudu dedei olelema:ne sia:i. Ilia da ohe amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu medole legesea, oloda ea gagoe (north) la:ididili (amoga ilia da gobeidafa gobele salasu ohe medole legesa) amoga medole legema:ne sia:i. Amo Iasu da hadigidafa iasu. ");
INSERT INTO beo_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Amo ohe gobele salasu dunu da hadigi sogebi (Hina Gode Ea Abula Diasu gagoi) amo ganodini amo ohe manu. ");
INSERT INTO beo_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Be nowa dunu o liligi da amo medole legei ohe ea hu digili ba:sea, e da se nabimu. Bai amo hu da gasa bagade hadigi hamoi dagoi. Be amo ea maga:me da abula amoga foga:gagala:be ba:sea, amo abula hadigi sogebi amo ganodini dodofema:mu. ");
INSERT INTO beo_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ilia da amo hu osoboga hamoi ofodo ganodini egesea, amo goudama:ne sia:ma. Amola gula ofodo ganodini egesea, amo noga:le dodofema:mu. ");
INSERT INTO beo_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Nowa da gobele salasu fi dunu esalea da amo iasu manu defea. Amo iasu da hadigidafa. ");
INSERT INTO beo_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Be amo ohe ea maga:me mogili Abula Diasu ganodini wadela:i hou fadegama:ne gaguli misi dagoi ba:sea, amo ohe ea hu manu da sema bagade. Huluane gobele salasu hamoma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Dabe Ima:ne Iasu gobele salasu hou da hadigidafa. Hagudu da ilia hamoma:ne sia:i dedei diala. ");
INSERT INTO beo_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Dilia Dabe Ima:ne Iasu ohe amo oloda ea gagoe (north) la:idi (amoga ilia da gobele salasu ohe medole legesa) amoga medole legele, ea maga:me amo oloda ea la:idi la:idi biyaduyale gala amoga sogaga:la:gaganoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","- ");
INSERT INTO beo_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Amasea, ea sefe huluane amola ea sefe la:go amola dialumagaisa amola ea fogome ganumui amola sefe amoga diala amola habe ea la:idi noga:iwane gala amo dasega:le, oloda da:iya gobesima:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Gobele salasu dunu da oloda da:iya sefe huluane Hina Godema Dabe Ima:ne Iasu hamoma:ne, gobesima:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nowa da gobele salasu dunu fi amo ganodini gawali gala da amo manu da defea. Be amo da hadigi sogebi amo ganodini manu da defea. Bai amo iasu da hadigidafa. ");
INSERT INTO beo_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Hamoma:ne sia:i afadafa da Dabe Ima:ne Iasu amola Wadela:i Hou Da:be Ima:ne Iasu amoga ouligisa. Amo da nowa gobele salasu dunu da gobele salasu hamoi galea, amo hu da ea:. ");
INSERT INTO beo_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Gobele salasu dunu da ohe Hina Godema ima:ne gobele salasea, e da amo ea gadofo lamu. ");
INSERT INTO beo_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Gala:ine Iasu amola amo da gobele nasu ganodini gobei o ofodo ganodini o agi gobesu agoai da:iya gobei amo ha:i manu huluane da gobele salasu dunu amo da Godema gobele sali, amo ea:. ");
INSERT INTO beo_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Be Gala:ine Iasu hame gobei (susuligi gilisi o hafoga:i) amo huluane da Elane gobele salasu dunu fi ilia:. Amo fifili defele ima:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Hagudu da Hahawane Gilisili Olofole Iasu Hina Godema ima:ne hamoma:ne sia:i dedei diala. ");
INSERT INTO beo_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Nowa dunu da Godema nodoma:ne amo Iasu imunusa: dawa:sea, e da ohe gobele salimusa: amola agi ga:gi (yisidi hame gilisi) gaguli misa:mu. Amo agi ga:gi da falaua amola olife susuligi amoga hamoi o belowagi amoga olife susuligi da legei o falaua ga:gi amola olife susuligi gilisi amoga hamoi. ");
INSERT INTO beo_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Amola eno, e da agi ga:gi yisidi hame gilisi amo gobei gaguli misa:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","E da agi ga:gi hisu hisu amo fifili, Hina Godema dawa:ma:ne Ema imunu. Amo agi ga:gi da gobele salasu dunu amo da ohe ea maga:me lale, oloda la:idiga sogaga:la:gaganosa, amo dunu ea:. ");
INSERT INTO beo_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ohe ea hu da eso amoga e da gobele sali amo mai dagoi ba:ma:mu. Golale, hahabe, eno hu hame mai dialumu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Be dunu da ea sia: ilegei dafawaneyale ba:ma:ne o udigili hahawane ima:ne, Hahawane Gilisili Olofole Iasu gaguli masea, amo esoga ha:i manu hame mai diala, amo aya esoga manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Be hu da eso osodayale dialebe ba:sea, amo gobesima:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Be dunu da eso osodayale amoga hu nasea, Gode da iabe dunu ea iasu hame lamu. Hina Gode da ea wadela:i hou hame gogolema:ne olofomu. Be E da amo iasu ledo hamoi dagoi ba:mu. Amola nowa dunu da amo nasea, se nabimu. ");
INSERT INTO beo_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Be ledo hamoi liligi da Godema Iasu hu amo digili ba:sea, amo hu mae moma:ne sia:ma. Amo hu gobesima:mu. Nowa dunu da Hina Gode Ea sema defele dodofei dagoi ba:sea, da Godema Iasu bu manu defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Be nowa da ledo gala hame dodofei ba:sea, amo hu nasea, e da Gode Ea Fidafa amoga afafai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Amola, nowa da ledo hamoi liligi (dunuga o ohega hamoi) digili ba:lu, amo hu udigili nasea, e amola da Gode Ea Fidafa amoga afafai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Hina Gode da Mousesema (Isala:ili fi dunuma alofele ima:ne) hagudu dedei hamoma:ne sia:i olelei. ");
INSERT INTO beo_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Bulamagau, sibi amola goudi, ilia sefe maedafa moma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ohe amo da hisu bogoi o sigua ohega medole legei, amo ea sefe mae moma:ne sia:ma. Be ea sefe eno hou hamomusa: lamu da defea. ");
INSERT INTO beo_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Nowa da ohe amo Hina Godema ha:i manu iasu imunusa: ilegei galu, amo ea sefe nasea da Gode Ea Fidafa amoga afafai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Isala:ili dunu da habodili esalea, sio o ohe ilia maga:me manu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Nowa da amo sema wadela:sea, da Gode Ea Fidafa amoga afafai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Amola Hina Gode da Mousesema Isala:ili fi dunuma alofele ima:ne amo hagudu dedei hamoma:ne sia:i olelei. ");
INSERT INTO beo_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Nowa da Hahawane Gilisili Olofole Iasu imunusa: dawa:sea, e da amo fifilalu, fifi afae Hina Godema imunusa: gaguli misa:mu. ");
INSERT INTO beo_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","E da amo hi loboga ha:i manu iasu gaguli misa:mu. E da amo ohe ea sefe amola ea bidegi gaguli misini, Hina Godema ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Gobele salasu dunu da sefe amo oloda da:iya gobesimu. Be bidegi amo da gobele salasu dunu ea:. ");
INSERT INTO beo_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","- ");
INSERT INTO beo_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Amo ohe ea emodafa e da gobele salasu dunu amo da maga:me amola sefe Hahawane Gilisili Olofole Ima:ne iaha, amo ema imunu. ");
INSERT INTO beo_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ohe ea bidegi amola emodafa amo ele da iasu noga:idafa amo Hina Gode da Isala:ili fi dunu ilima lale, gobele salasu fi dunu ilima iaha. Amo hou da mae yolesili, dialumu. ");
INSERT INTO beo_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Amo da ha:i manu Hina Godema iasu, amo fifili, Elane amola egefelali, amo ilia gobele salasu dunu ilegesu eso amoga iasu. ");
INSERT INTO beo_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Amo esoga, Hina Gode da Isala:ili dunu ilima ilia da iasu fifili, amo fifi gobele salasu dunuma ima:ne sia:i. Amo hamoma:ne sia:i da Isala:ili dunu ilima fa:no eso huluane mae yolesili, ouligima:ne sia:ma ");
INSERT INTO beo_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Defea! Amo da Wadela:i Hou Dabe Ima:ne Iasu, Gala:ine Iasu, Wadela:i Hou Gogolema:ne Olofoma:ne Iasu, Mae Dawa:le Wadela:i Hamoi Iasu, Dabe Ima:ne Iasu amola Hahawane Gilisili Olofole Iasu ilia hamoma:ne sia:i huluane dedei diala. ");
INSERT INTO beo_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Sainai Goumi, hafoga:i soge ganodini, amogawi Hina Gode da amo hamoma:ne sia:i huluane Mousesema i dagoi. Eso amoga E da Isala:ili dunu ilia iasu ima:ne sia:i, E da amo hamoma:ne sia:i Mousesema i. ");
INSERT INTO beo_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Dia Elane amola egefelali amo Na Abula Diasu logo holeiga oule misa. Gobele salasu abula amola ligiagasu susuligi, bulamagau mano (gawali) Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne, sibi gawali aduna amola daba yisidi hame sali agi ga:gi amoga nabai, gaguli misa. ");
INSERT INTO beo_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Amasea, dunu fi huluane amogawi gilisima:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mousese da Hina Gode Ea hamoma:ne sia:i defele hamoi. Amasea, fi dunu huluane da gilisi dagosea, ");
INSERT INTO beo_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","e da ilima amane sia:i, “Na da wali Hina Gode Ea hamoma:ne sia:i liligi amo hamomu.” ");
INSERT INTO beo_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mousese da Elane amola egefelali ba:le gaidiga oule misini, ilima ilia da sema defele hanoga ulima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","E da Elanema da:i salasu amola abula gasisa:li. Amola abula eno bululisi. Amola e da ea bidegiga Ifode gasisa:li, amola amo ea nodomei bulu amoga ga:si. ");
INSERT INTO beo_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","E da bidegi ea dedebosu gasisa:lili, amo ganodini Ulimi amola Damini sali. ");
INSERT INTO beo_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","E da ea dialumaga habuga figisi amola amo ea midadi gouliga nina: hamosu mogili gagasu dawa:digima:ne olelesu sema liligi amo la:gi. E da Hina Gode ea hamoma:ne sia:i defele hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Amasea, Mousese da ligiagasu susuligi lale, Hina Gode Ea Abula Diasu amola liligi huluane amo ganodini dialu amoga legei dagoi. Amasea, liligi huluane da Hina Godema momodale ligiagai dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Amasea e da susuligi mogili lale, fesuale agoane oloda amola ea liligi amola ofodo bagade amola ea bai amoga Hina Godema momodale ligiagama:ne, foga:gagala:i. ");
INSERT INTO beo_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","E da Elane mogili gagamusa:, susuligi mogili ea dialuma amo da:iya, sogadigi. ");
INSERT INTO beo_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Amasea, Mousese da Elane egefelali oule misini, ilima da:i salasu amola abula bulu gasisali, amola ilia dialumaga habuga figisi-Hina Gode Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Amasea, Mousese da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne, bulamagau mano gawali amo oule misini, Elane amola egefelali da ilia lobo ea dialuma da:iya ligisi. ");
INSERT INTO beo_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mousese da amo bulamagau medole legele, ea maga:me mogili lale, ea lobo sogo amoga ‘hono’ oloda ea hegomaiga diala amoga sema modale ligiagama:ne ilegei. Amasea, eno maga:me dialu amo e da oloda ea baiga sogadigi-oloda modale ligiagama:ne amola ledo fadegama:ne. ");
INSERT INTO beo_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mousese da dialumagaisa, habe ea la:idi noga:i, fogome ganumui amola sefe amoga diala amo lale, oloda da:iya gobesi. ");
INSERT INTO beo_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","E da bulamagau ea da:i hodo eno dialu, - ea gadofo, ea hu amola ea iga huluane - amo lale, Hina Gode Ea hamoma:ne sia:i defele, abula diasu gilisisu gadili gobesi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Amasea, Mousese da sibi gawali amo Wadela:i Hou Dabe Ima:ne Iasu gobele salimusa: oule misini, Elane amola egefelali da ilia lobo ea dialuma da:iya ligisi. ");
INSERT INTO beo_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mousese da amo sibi gawali medole legele, ea maga:me amo oloda ea afo biyaduyale gala amoga sogaga:la:gaganoi. ");
INSERT INTO beo_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","- ");
INSERT INTO beo_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","E da sibi gawali amo dadega:le, ea iga amola emo hanoga dodofele, amola sefe amola sibi gawali ea da:i hodo huluane, Hina Gode Ea hamoma:ne sia:i defele, gobesi. Amo Wadela:i Hou Dabe Ima:ne Iasu gobele salasu da Ha:i Manu Iasu agoane ba:i, amola ea gabusiga: amo Hina Gode da hahawane nabi. ");
INSERT INTO beo_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Amasea, Mousese da sibi gawali eno, gobele salasu dunu ili momogili gagama:ne, (amo da Ligiagasu Iasu) amo oule misini, Elane amola egefelali da ilia lobo amo ea dialuma da:iya ligisi. ");
INSERT INTO beo_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mousese da amo sibi gawali medole legele, ea maga:me mogili lale, amo Elane ea lobodafadi ge gehahaya amola ea lobodafadi bi amola ea emodafadi bi amoga legei. ");
INSERT INTO beo_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Amasea, Mousese da Elane egefelali amo oule misini, maga:me mogili lale, ilia lobodafa la:idi ge gehahaya amola ilia lobodafa bi amola ilia emodafa bi amoga legei. Amasea, e da maga:me eno dialu amo oloda ea afo biyaduyale amoga sogaga:la:gaganoi. ");
INSERT INTO beo_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","E da sefe huluane, la:go bai, dialumagaisa, habe ea la:idi noga:i, fogome ganumui amola ela sefe amola emodafa amo lai. ");
INSERT INTO beo_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Amasea, e da agi ga:gi amoga yisidi hame sali Godema iasu, daba ganodini sali, amoga e da agi ga:gi afadafa lale, amola ga:gi eno susuligi amoga hamoi amola belowagi afae lale, amo sefe huluane amola emodafa amo da:iya ligisi. ");
INSERT INTO beo_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","E da amo ha:i manu huluane Elane amola egefelalia loboga ligisili, ilia da amo hahawane iasudafa agoane, Hina Godema ima:ne olelei. ");
INSERT INTO beo_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Amasea, Mousese da ilima amo ha:i manu bu lale, oloda da:iya, Wadela:i Hou Dabe Ima:ne Iasu gadodili, ili momogili gagama:ne, gobesi dagoi. Amo da ha:i manu iasu, amola ea gabusiga: amo Hina Gode da hahawane nabi. ");
INSERT INTO beo_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Amasea, Mousese da sibi gawali ea sogogea lale, Hina Godema i dagoi. Amo sogogea da ligiagasu gobele salasu sibi gawali, amo Mousese hi iabe gala. Mousese da hou huluane Hina Gode Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Amola, Mousese da ligiagasu susuligi mogili amola maga:me oloda da:iya dialu mogili amo lale, Elane amola egefelalia abula amoga fogaga:gala:i. E da amo hou amoga ili Godema momogili gagai dagoi. ");
INSERT INTO beo_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mousese da Elanema amane sia:i, “Hu amo Hina Gode Ea Abula Diasu logo holeiga gaguli masa. Amoga gobele moma! Amola agi ga:gi amo da ligiagasu iasu daba ganodini diala, Hina Gode Ea hamoma:ne sia:i defele, moma. ");
INSERT INTO beo_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Hu o agi ga:gi hame mai galea, amo laluga gobesima. ");
INSERT INTO beo_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Dilia da Abula Diasu logo holeiga eso fesuale gala, amogawi esalu, ligiagasu sema hou huluane hamoi dagosea fawane yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Hina Gode da dilia wali eso hou hamobe amo hamoma:ne sia:i. Bai dilia wadela:i hou fadegamusa:. ");
INSERT INTO beo_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dilia mae yolesili, Abula Diasu ea logo holeiga eso amola gasi, fesuale agoane ouesaloma. Amane hame hamosea, dilia da bogosu ba:mu. Hina Gode da amo hou hamoma:ne, nama sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Amaiba:le, Elane amola egefelali da Hina Gode Ea Mousesema sia:i liligi huluane hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ilegesu sema hou huluane hamoi dagobeba:le, Mousese da Elane amola egefelali amola Isala:ili ouligisu dunu ema misa:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","E da Elanema amane sia:i, “Bulamagau mano gawali amola sibi gawali (noga:idafa amola ledo hamedei) amo lale, Hina Godema gobele salimusa: ima. Bulamagau da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu amola sibi gawali da Wadela:i Hou Dabe Ima:ne Iasu gobeidafa gobele salasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Amasea, Isala:ili dunu da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele sanasima:ne, goudi gawali lama:ne sia:ma. Amola bulamagau amo da lalelegele, ode afae esalu amola sibi amo da lalelegele, ode afae esalu (amo da noga:idafa, ledo hamedei) Wadela:i Hou Dabe Ima:ne Iasu gobeidafa gobele salasu hamoma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Amola ilia da bulamagau gawali amola sibi gawali Hahawane Gilisili Olofole Iasu hamoma:ne sia:ma. Ilia da Gala:ine Iasu (amoga susuligi da gilisi) amoga gilisili, Hina Godema gobele sanasimu. Ilia da amo hou wali eso hamoma:ne sia:ma. Bai Hina Gode da wali eso ilia E ba:ma:ne misunu.” ");
INSERT INTO beo_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ilia da Mousese ea sia:i liligi huluane amo Abula Diasu ea midadi amoga gaguli misi dagoi. Amola fi dunu huluane da gilisili, Hina Godema nodone sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mousese da amane sia:i, “Hina Gode Ea hadigi sinenemegi dilima doaga:ma:ne, E da dilia amo hou hamoma:ne sia:i.” ");
INSERT INTO beo_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Amasea, e da Elanema amane sia:i, “Di oloda amoga asili, Wadela:i Hou Dabe Ima:ne Iasu gobele salasu amola Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu amo Hina Gode Ea hamoma:ne sia:i defele, fi dunu ilia wadela:i hou fadegama:ne, hamoma. ");
INSERT INTO beo_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Elane da oloda amoga asili, hi wadela:i hou fadegama:ne, Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoi. ");
INSERT INTO beo_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Elane egefelali da maga:me ema gaguli misi. E da amo ganodini ea lobo sogo gele, ‘hono’ amo da oloda ea hegomaiga gala amoga legei. Maga:me eno dialu amo e da oloda ea baiga sogadigi. ");
INSERT INTO beo_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Amasea, Hina Gode Ea hamoma:ne sia:i defele, e da oloda da:iya amoga sefe amola fogome ganumui amola habe ea la:idi noga:i amo gobesi. ");
INSERT INTO beo_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Be hu amola gadofo e da abula diasu gilisisu gadili gobesi. ");
INSERT INTO beo_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Amasea, e da hi wadela:i hou hahamoma:ne, Wadela:i Hou Dabe Ima:ne Iasu gobele salasu hamoma:ne, amo ohe medole legei. Egefelali da amo ea maga:me ema gaguli misini, e da oloda ea la:idi biyadu amoga sogaga:la:gaganoi. ");
INSERT INTO beo_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ilia da amo ohe ea dialuma amola eno dadega:i oda amo ema ianu, e da oloda da:iya gobesi. ");
INSERT INTO beo_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Amasea, e da iga amola emo amo dodofelalu, oloda da:iya Wadela:i Hou Dabe Ima:ne Iasu gobele salasu liligi amo gado gobesi. ");
INSERT INTO beo_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Amalalu, Elane da dunudafa ilia iasu amo gobele sali. E da goudi (amo dunudafa ilia mae dawa:le wadela:i hou fadegama:ne gobele salasu hamoma:ne) amo lale, medole legele, hi Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu defele ia dagoi. ");
INSERT INTO beo_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Amola e da Wadela:i Hou Dabe Ima:ne Iasu gobele salasu ohe amo lale, sema defele Hina Godema iasu. ");
INSERT INTO beo_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","E da Gala:ine Iasu gobele salima:ne, lobo afaega falaua gasa:le lale, amola oloda da:iya gobesi. (amo ilia da eso huluane Wadela:i Hou Dabe Ima:ne Iasu gobele salasu amoga gilisi.) ");
INSERT INTO beo_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","E da bulamagau gawali amola sibi gawali amo dunudafa ilia Hahawane Gilisili Olofole Iasu hamoma:ne medole legei. Egefelalia da maga:me ema gaguli misini, e da amo oloda ea afo biyaduyale amoga sogaga:la:gaganoi. ");
INSERT INTO beo_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Elane da bulamagau gawali amola sibi gawali ea sefe liligi lale, ");
INSERT INTO beo_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ohe ela bidegi da:iya ligisili huluane oloda amoga gaguli asi. E da sefe amo oloda da:iya gobesili, ");
INSERT INTO beo_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mousese Ea hamoma:ne sia:i defele, bulamagau gawali amola sibi gawali amo ela sogogea amola emodafa amo gobele salasu dunu ilia wadela:i hou gogolema:ne olofoma:ne, Hina Godema iasudafa ima:ne i. ");
INSERT INTO beo_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Elane da gobele salasu hou huluane hamoi dagosea, e da dunu huluane amo da:iya ea lobo ligia gadole, Gode da ilima hahawane dogolegema:ne sia:ne gadoi. Amasea, e da gudu sa:i. ");
INSERT INTO beo_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mousese amola Elane da Hina Gode Ea Abula Diasu ganodini golili sa:i. Ela da bu gadili misini, ela da Godema E da dunu huluane ilima hahawane dogolegema:ne adole ba:i. Amola Hina Gode da amogawi esala amo olelema:ne, ilia da Hina Gode Ea sinenemegi hadigi ba:i. ");
INSERT INTO beo_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Amasea, hedolodafa, Hina Gode da lalu iasu. Amo lalu da Wadela:i Hou Dabe Ima:ne Iasu gobele salasu liligi amola sefe liligi oloda da:iya dialebe amo nei dagoi. Dunu huluane da amo ba:beba:le, bagadewane welalu, ilia odagi osoba begugudui. ");
INSERT INTO beo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Elane egefela, Na:ida:be amola Abaihiu afae afae da lalu ofodo lale, amo ganodini laluso salawane, gabusiga: manoma sogadigili, Hina Godema imunusa: asi. Be amo lalu da hadigi hame galu. Bai Hina Gode da amo Ema ima:ne hame sia:i. ");
INSERT INTO beo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Amaiba:le, hedolodafa, Hina Gode da lalu iasili, ela da Hina Gode Ea midadi, laluga nei dagole, bogoidafa ba:i. ");
INSERT INTO beo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Amasea, Mousese da Elanema amane sia:i, “Hina Gode da amane sia:i, ‘Nowa da Nama hawa: hamomusa: dawa:sea da Na hadigi amoma beda:iwane dawa:ma:ne sia:ma. Na dunu da Nama nodoiwane dawa:mu da defea.’ Amaiba:le, amo hou da wali doaga:i dagoi.” Be Elane da ouiya:lewane esalu. ");
INSERT INTO beo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mousese da Misa:iele amola Elisa:ifa:ne (ela da Elane ea aowa Asaiele amo egefela) ela da ema misa:ne sia:ne, elama amane sia:i, “Misa! Alia awa amo elea da:i hodo sema abula diasuga lale, abula diasu gilisisu gadili gaguli masa.” ");
INSERT INTO beo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Amaiba:le, Mousese Ea hamoma:ne sia:i defele, ela da misini, abula amo bogoi amoga sali amo gaguli, bogoi abula diasu gilisisu gadili gaguli asi. ");
INSERT INTO beo_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Amasea, Mousese da Elane amola egefela Elia:isa amola Idama ilima amane sia:i, “Dilia dialuma hinabo noga:le fesega:ma, amola dilia hiawini disu mae hamoma, abula mae gadelama. Dilia hiawini disu olelesea, dilia da bogomu, amola Hina Gode da Isala:ili fi huluane ilima ougi bagade ba:mu. Be dilia na:iyado Isala:ili dunu, ilia da dunu amo da Hina Gode Ea lalu iasi amoga bogoi, amo dawa:beba:le hiawini dimu da defea. ");
INSERT INTO beo_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Be dilia bogosa:besa:le, Abula Diasu ea holei mae yolesima. Bai dilia da Hina Gode Ea momogili gagasu susuligi amoga mogili gagai dagoi.” Amaiba:le, ilia da Mousese Ea hamoma:ne sia:i defele hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Hina Gode da Elanema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Di amola dia gofelali da Na Abula Diasu ganodini golili sa:imusa: dawa:sea, adini o waini hano hidadea manu da sema bagade. Dilia da amo nasea, bogomu. Amo sema digaga fi huluane fa:no noga:le ouligima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Dia da liligi amo da Gode Ea liligi amola osobo bagade hou hamomusa: liligi amo afafane, ilegema. Sema dodofei dagoi liligi amola ledo hamoi liligi amo afafama. ");
INSERT INTO beo_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Amola di Isala:ili fi dunu ilima sema huluane Na da dilima alofele imunusa: Mousesema olelei, amo huluane olelema.” ");
INSERT INTO beo_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mousese da Elane amola egefela hame bogoi esalu (Elia:isa amola Idama) ilima amane sia:i, “Ha:i manu Hina Godema i, amoma Gala:ine Iasu diala amo lale, agi ga:gi (yisidi hame sali) hamone, oloda la:ididili lelu moma. Bai amo iasu da hadigidafa. ");
INSERT INTO beo_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Amo liligi hadigi sogebi amoga moma. Amo ha:i manu Hina Godema i ea la:idi fifi da dilia:. Hina Gode da amo nama sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Amola dilia amola dilia sosogo fi da ohe bidegi amola emo amo Hina Godema i, (amola E da alofele gobele salasu dunuma iasu) amo manu da defea. Dilia da sema dodofei dagoi sogebi amoga manu da defea. Isala:ili dunu da amo Hahawane Gilisili Olofole Iasu iaha. Amola sogogea amola emo fifi da gobele salasu dunu dilia:. ");
INSERT INTO beo_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ilia da sefe amo Ha:i Manu Iasu Hina Godema imunusa: gaguli masea, gilisili sogogea amola emo gaguli misunu. Hina Gode Ea sia: defele, amo liligi fifi da eso huluane mae yolele, dilia amola dilia mano dilia:.” ");
INSERT INTO beo_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mousese da goudi amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne, amo ea hou adole ba:i. Ilia da amo da gobesi dagoi olelei. Amo nababeba:le, Mousese da Elia:isa amola Idama elama ougi bagade galu. E amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Alia da abuliba:le amo gobele salasu sema sogebi amoga hame maibala:? Amo gobele salasu da hadigidafa. Bai Hina Gode da dunu fi ilia wadela:i hou fadegama:ne, amo dilima i. ");
INSERT INTO beo_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Amo gobele salasu ea maga:me da sema Abula Diasu ganodini hame gaguli misi ba:i. Amaiba:le, dilia da na hamoma:ne sia:i defele, hadigi sema sogebi amoga manu da defea galu.” ");
INSERT INTO beo_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Elane da bu adole i, “Isala:ili dunu da wali eso, ilia Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu amola Wadela:i Hou Dabe Ima:ne gobele salasu amo Hina Godema i dagoi. Be amo hou (ea mano aduna medole legei ba:i) amo da nama doaga:i dagoi. Na da wali eso Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu ha:i manu nanoba, Hina Gode da hahawane ba:la:lobala:?” ");
INSERT INTO beo_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mousese da amo sia: nababeba:le, ea ougi yolesili, bu Elane ea hou hahawane ba:i. ");
INSERT INTO beo_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Hina Gode da hagudu dedei hamoma:ne sia:i amo ela da Isala:ili fi dunuma alofele ima:ne, Mousese amola Elane elama olelei. ");
INSERT INTO beo_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","- ");
INSERT INTO beo_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","“Dilia da osoboga esalebe ohe amo ilia da emo wadobo gala amola ha:i manu da ea esaga dialu bu hi aduga:le naha, amo huluane manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Be ga:mele amola igi haguha fisu dauwa: amola mila amo mae moma. Ilia da dilia sema amo ganodini, ledo hamoi dagoi. Bai ilia da ha:i manu da ea esaga dialu bu hi aduga:le naha be ilia da emo wadobo hame gala. ");
INSERT INTO beo_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Amola gebo mae moma. Bai ilia da ledo hamoi dagoi. Ilia da emo wadobo gala be ilia ha:i manu ea esaga dialu bu hi aduga:le hame naha. ");
INSERT INTO beo_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Amo ohe mae moma. Amola ilia bogoi da:i hodo amo mae digili ba:ma. Bai ilia da sema ledo hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Dilia menabo amo da gagi gala, amo manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Be hano ganodini esalebe liligi amo da gagi hame enemei gala, amo manu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Dilia amo liligi sema ledo hamoi dagoi ba:mu. Dilia amo mae moma amola ilia bogoi da:i hodo mae digili ba:ma. ");
INSERT INTO beo_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Hano ganodini esalebe liligi amo da gagi hame, enemei, amo maedafa moma. ");
INSERT INTO beo_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Dilia hagudu dedei sio mae moma: Buhiba, gugunia, ogolo, ‘fa:legone’, ‘basade’, ‘faladiue’, ‘galou’, ‘osadaligi’, ‘sigale’, ‘sidogi’, ‘helane’, ‘beliga:ne’, ‘gomola:de’, ‘hubou’, gamo. ");
INSERT INTO beo_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Gedama fi agoai amo da ougia gala, amo da ledo hamoiba:le, mae moma. ");
INSERT INTO beo_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Be gedama fi agoai liligi amo da hadiasa, amo da ledo hameba:le, manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Dilia sage fi, danuba: amola soni manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Be fonobahadi liligi amo da ougia gala amola liligi da sugi ahoa, amo huluane da ledo hamoiba:le, mae moma. ");
INSERT INTO beo_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Nowa da hagudu dedei ohe ilia bogoi da:i hodo digili ba:sea, da ledo hamoi ba:mu. (Daeya doaga:sea fawane, bu dodofei dagoi ba:mu.) Ledo hamoi ohe da ohe huluane da ga:nasi emo (hoofs) gala. (Be ohe amo da ga:nasi emo gala, amola emo wadobo gala amola ha:i manu da ea esaga dialu bu hi aduga:le naha da defea.) Ohe amo da emo biyadu gala amola ea emo da nana:i gala da ledo gala. Nowa da amo ohe ea bogoi da:i hodo gaguli ahoasea, e da ea abula dodofema:mu. Be e da ledo hamoi dagoiba:le, daeya doaga:sea fawane, bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","- ");
INSERT INTO beo_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Dauwa fi, a:ginibuni amola agoai liligi huluane, amola goma:fi huluane, amo dilia ledo hamoi dagoi ba:ma:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Nowa da ili o ilia bogoi da:i hodo digili ba:sea, da ledo hamoi dagoi ba:mu. Daeya doaga:beba:le fawane, bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Amola amo liligi ilia bogoi da:i hodo da eno liligi amo da:iya dasea, amo liligi amola da ledo hamoi dagoi ba:mu. Amo bogoi da:i hodo da ifa liligi o abula liligi o bulamagau gadofo o esa liligi amoga dasea, liligi da ledo hamoi dagoi ba:mu. Amo liligi dodofemusa: dawa:sea, hano ganodini gema. Be e da ledo hamoi dagoiba:le, daeya doaga:sea fawane bu ledo hamedei hamoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Amola ledo hamoi ohe ilia bogoi hodo da osoboga hamoi ofodo amo ganodini dasea, liligi amo ofodo ganodini sali da ledo hamoi dagoi ba:mu. Amola osoboga hamoi ofodo amo goudama. ");
INSERT INTO beo_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Amola dilia da amo ledo hamoi ofodo amoga hano sogadigili, amola amo hano da ha:i manu amoga dasea, amo da ledo hamoi dagoi ba:mu. Bai amo ofodo ganodini, hano sali da ledo hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Adi liligi amoga amo bogoi da:i hodo dasea da ledo hamoi dagoi. Dilia osoboga hamoi gobele nasu amo goudale fasima. ");
INSERT INTO beo_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Be gu hano amola hano ofodo sugi bagade da ledo hame hamomu. Be amo bogoi da:i hodo da liligi eno huluane digili ba:sea, amo liligi huluane da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Be amo liligi ilia bogoi da:i hodo da hawa: oso amoga dasea, amo oso da ledo hame hamoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Be oso da hano ganodini gene dialea, amo bogoi da:i hodo da amoga dasea, oso da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ledo hame hamoi ohe da bogosea, nowa da amo ohe digili ba:sea da ledo hamoi dagoi ba:mu. Daeya doaga:sea fawane bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Amola nowa da amo ohe dadega:i amoga nasea, e da ea abula huluane dodofema:mu. Be e da ledo hamoi dagoi ba:mu. Daeya doaga:sea fawane bu noga:i ba:mu. Be nowa da amo ohe ea bogoi da:i hodo gaguli ahoasea, ea abula dodofema:mu. Be e da ledo hamone, daeya doaga:sea fawane yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Dilia ohe fonobahadi amo da osoboga gagasi ahoasea, mae moma. ");
INSERT INTO beo_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ohe fonobahadi da gagasi ahoasea o emo biyadu amoga ahoasea o emo osea:i amoga ahoasea, ");
INSERT INTO beo_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","dilia da ledo hamoi dagoi ba:sa:besa:le, maedafa moma. ");
INSERT INTO beo_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Na da dilia Hina Godedafa amola Na hou da hadigidafa. Amaiba:le, dilia hou amola da hadigi ba:mu da defea. ");
INSERT INTO beo_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Na da Hina Gode! Amola Na da dili Idibidi sogega fadegale fasili, gadili oule asi. Bai Na da dilia Gode esalumusa: hanai galu. Na hou da hadigiba:le, dilia hou amola da hadigi ba:mu da defea. ");
INSERT INTO beo_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Amo olelei liligi da sema amo ohe amola sio - liligi da hano ganodini esala amola liligi amo da osobo da:iya ahoa - amo ilia nasu hou olelesa. ");
INSERT INTO beo_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Dilia noga:le dawa:ma! Ledo sema hamoi liligi amola ledo hame hamoi liligi noga:le afafama! Ohe amo manu da defea amola ohe amo da manu sema gala, amo noga:le afafama. ");
INSERT INTO beo_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Hina Gode da Mousesema hamoma:ne sia:i eno Isala:ili dunu alofele ilegema:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Uda da dunu mano lalelegesea, e da eso fesuale amoga, ea sioi fisu sema defele, ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Eso godoane gala, dilia ea mano ea ewa gadofo damuma. ");
INSERT INTO beo_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Amasea, amo uda ea maga:me da gudu sa:iba:le, e da eso33 eno amoga ledo hamoi ba:mu. E da hadigi liligi mae digili ba:ma:ne sia:ma. Amola e da Sema Abula Diasu amo ganodini hame golili masunu. Be ea dodofesu hou huluane da hamoi dagoiba:le fawane, ganodini masunu da defea. ");
INSERT INTO beo_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Uda da uda mano lalelegesea, e da eso14 amoga, ea sioi fisu defele, ledo hamoi dagoi ba:mu. Amasea, ea maga:me da gudu sa:iba:le, e da eso66eno amoga, ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ea ledo hamoi eso da dagobeba:le, (dunu mano o uda mano lalelegesea) e da sibi mano amo da lalelegele, ode afae esalu, Wadela:i Hou Dabe Ima:ne Iasu gobele salasu hamoma:ne amola musuni o dafe sio Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne amo Hina Gode Ea Abula Diasu ea logo holeiga gaguli misini, gobele salasu dunu ema ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Gobele salasu dunu da ea iasu amo Hina Godema imunu. Amola e da ea ledo hamoi amo bu hahamoma:ne, hou hamonanu, e da fofoloi dagoi ba:mu. Uda da mano lalelegesea, amo hou hamoma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Be uda da hame gaguiba:le, sibi mano gaguli misunu hamedei ba:sea, e da musuni aduna o dafe sio aduna gaguli misa:ne sia:ma. Afae da Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne amola afae da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne. Amasea, gobele salasu dunu da amo uda ea ledo hou hahamoma:ne hahamonanu, uda da ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Hina Gode da Mousese amola Elanema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Nowa da ea gadofo amoga dului o aiya o fofai amo da bagade olobe ba:sea, amo dunu Elane fi gobele salasu dunuma oule misa. ");
INSERT INTO beo_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Gobele salasu dunu da amo aiya liligi noga:le ba:ma:mu. Hinabo amo aiya ganodini da ahea:iai ba:sea amola aiya da gadofo haguduga sa:i dagoi ba:sea, amo olo da gadofo olo bagade dawa:ma. Amola gobele salasu dunu da amo gadofo olo dunu da ledo hamoi dagoi sia:ma:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Be amo aiya da ahea:iai ba:sea, amola amo aiya da gadofo sisiga:le diala amoga haguduga hame ba:sea, amola hinabo amo aiya ganodini da ahea:iai hame hamoi galea, gobele salasu dunu da amo dunu eno dunuma mae gilisili, hisu esaloma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Amasea, eso fesuga, gobele salasu dunu da amo dunu ea hou bu ba:mu. E da amo aiya da ea musa: hou defele dialebe ba:sea, e da amo dunu eso fesuale eno hisu esaloma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Gobele salasu dunu da eso fesuga, amo dunu bu ba:mu. Aiya da udigili diala be hame bagai agoane ba:sea, e da amo dunu da ledo hamedei sia:mu. Amo da aiya fawane. E da ea abula dodofelalu, ledo hamedei agoane esalumu. ");
INSERT INTO beo_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Be gobele salasu dunu da amo dunu da ledo hamedei sia:sea, amola fa:no aiya da bu bagade hamosea, e da bu gobele salasu dunu ba:la masa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Gobele salasu dunu da amo dunu, bu ba:lalu, aiya da bu bagai ba:sea, e da amo dunu da ledo hamoi dagoi ilegemu. Bai ea gadofo oloi da eno dunu madelama:ne bagade gala. ");
INSERT INTO beo_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Nowa da eno dunu madelama:ne gadofo olo bagade gala, gobele salasu dunuma oule misa:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","E da amo dunu noga:le ba:mu. Ea gadofo amoga ahea:iai aiya amo ganodini hinabo da ahea:iai amola guhi galebe ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","amo da gadofo olo bagadeba:le, gobele salasu dunu da amo dunu da ledo hamoi dagoi sia:mu. E da hisu esaloma:ne hame sia:mu. Bai dunu huluane da e da ledo hamoi dagoi dawa:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Be gadofo olo da bagade hamosea amola dunu ea da:i hodo huluanedafa dedebosea, ");
INSERT INTO beo_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","gobele salasu dunu da amo dunu bu ba:mu. Gadofo olo da ea da:i huluanedafa dedeboi dagoi ba:sea, e da amo dunu da a:silibu ledo hamedei sia:mu. Gadofo huluanedafa da ahea:iai hamoi dagoiba:le, e da amo dunu da ledo hamedei sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Be aiyadafa ea da:i amoga ba:sea, e da hedolodafa ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Gobele salasu dunu da amo dunu bu ba:mu. E da aiyadafa ba:sea, amo dunu da ledo hamoi dagoi sia:mu. Bai aiyadafa ealeme ea bai da amo dunu da eno dunuma madelama:ne, gadofo olo bagade lai dagoi. ");
INSERT INTO beo_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Be aiya da bu bahole, ahea:iai bu ba:sea, e da bu gobele salasu dunuma masunu. ");
INSERT INTO beo_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Gobele salasu dunu da e bu ba:mu. Aiya da bahole, bu ahea:iai ba:sea, amo dunu da bu ledo hamedei e da sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Nowa dunu da dului galea, amola amo da bu uhisia, ");
INSERT INTO beo_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","be fa:no ahea:iai fofai o ahea:iai amola yoi daginisi da dului ea musa: sogebi amogai ba:sea, e da gobele salasu dunu ema masa:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Gobele salasu dunu da amo dunu ea hou ba:mu. Amo daginisi da gadofo amoga hagudu agoane asi ba:sea amola hinabo amo ganodini gala da ahea:iai hamoi dagoiba:le, gobele salasu dunu da amo dunu da ledo hamoi dagoi sia:mu. Bai e da gadofo olo bagade da dului ganodini mui dagoi dawa:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Be gobele salasu da hinabo amo daginisi ganodini da ahea:iai hame hamoi, amola daginisi da gadofo haguduga hame sa:i be fonobahadi ahea:iai agoane hamoi amo ba:sea, e da amo dunu eno dunuma mae gilisima:ne hisu esaloma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Be amo daginisi da bu bagai ba:sea, gobele salasu dunu da amo dunuma ledo hamoi dagoi sia:mu. Amo da olodafa. ");
INSERT INTO beo_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Be amo daginisi da mae afadenene bagai hame hamosea, amo da dului ea bahoi fawane ilia da dawa:mu. Gobele salasu dunu da amo dunu da ledo hamedei hamoi dagoi sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Be nowa dunu da laluga nesea, ea hu gahe da ahea:iai o yoi agoane ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","gobele salasu dunu da amo dunu ba:mu. Hinabo da laluga nei sogebi ganodini gala da ahea:iai hamoi amola amo sogebi da gadofo eno amoga hagudu ba:sea, gadofo olo bagade da amo sogebi ganodini mui dagoi ilia dawa:mu. Amaiba:le, gobele salasu da amo dunu da ledo hamoi dagoi sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Be hinabo da ahea:iai hame hamoi amola amo sogebi da gadofo eno amoga hagudu hame basea, gobele salasu dunu da amo dunu eso fesuale hisu esaloma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","E da amo dunu eso fesuga bu ba:mu. Amo aiya da bu bagade hamonanebe ba:sea, e da amo dunu da ledo hamoi dagoi sia:mu. Bai amo da gadofo olo bagade eno dunuma madelasa:besa:le sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Be amo aiya da mae afadenene, ahea:iai agoane dialebe ba:sea, amo da gadofo olo hame ilia dawa:mu. Gobele salasu dunu da amo dunu da ledo hamedei sia:mu. Bai amo da laluga nei baho fawane ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Dunu o uda da ea dialuma o magado amoga aiya ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","gobele salasu dunu da amo noga:le ba:mu. Amo da gadofo eno amoga hagudu ba:sea, amola amo ganodini hinabo da bua: amola bagahame fawane galea, ea oloi da gadofo olo bagade dawa:mu. Gobele salasu dunu da amo dunu da ledo hamoi dagoi sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Be gobele salasu dunu da amo dunu ea hou ba:sea, amola aiya da eno sisiga:i gadofo amoga hagudu hame gala, be hinabo noga:i da amo ganodini hame galea, e da amo dunu hisu esaloma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Eso fesu amoga gobele salasu dunu da amo aiya bu ba:mu. Amo aiya da bu bagade hame hamoi ba:sea amola amo ganodini bua: hinabo hame galea, ");
INSERT INTO beo_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","oloi dunu da gadofo amo aiya sisiga:i diala amoga hinabo waga:mu. Gobele salasu dunu da amo dunu eso fesuale eno hisu esaloma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Eso fesuga, gobele salasu dunu da amo dunu bu ba:mu. Ea aiya da bu bagai hame hamoi ba:sea amola e da sisiga:i gadofo amoga hagudu hame ba:sea, e da amo dunu da ledo hamedei hamoi dagoi sia:mu. Amo dunu da ea abula dodofelalu, dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Be gobele salasu da amo dunu ledo hamedei hamoi sia:nanu, fa:no aiya da bu bagade hamosea, ");
INSERT INTO beo_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","gobele salasu dunu da amo dunu bu ba:mu. Aiya da bu bagade hamoi ba:sea, e da bua: hinabo hame hogomu. Bai amo dunu da dafawane ledo hamoi dagoi ba:sa. ");
INSERT INTO beo_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Be gobele salasu da amo aiya da bu bagai hame hamoi hi dawa:sea amola aiya ganodini oloi hame hinabo heda:lebe ba:sea, aiya da bahoi dagoi dawa:ma. Amola gobele salasu dunu da amo dunu da sema ganodini ledo hamedei hamoi dagoi sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Dunu o uda da ea gadofo amoga ahea:iai daginisi ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","gobele salasu dunu da amo dunu o uda ea hou hogoi helema:ne sia:mu. Be daginisi da noga:le dafahame ahea:iai agoane ba:sea, amo daginisi da fonobahadi gadofo wadela:su liligi. Be amo dunu da sema ganodini ledo hamedei. ");
INSERT INTO beo_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","- ");
INSERT INTO beo_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Dunu da ea dialuma amoga midadi o baligia, hinabo fisisia, amo da ea hou ledo hamedei. ");
INSERT INTO beo_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Be yoi ahea:iai aiya da ea dialuma gianai amoga madelasea, amo da gadofo olo bagade dawa:ma. ");
INSERT INTO beo_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Gobele salasu dunu da ea hou ba:mu. Amola yoi agoane ahea:iai aiya ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","e da amo dunu da ledo hamoi dagoi sia:mu. Bai ea dialuma amoga, gadofo olo bagade da madelai dagoiba:le. ");
INSERT INTO beo_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Nowa dunu da gadofo oloi bagade galea, e da abula gadelai fawane ga:mu, e da ea dialuma hinabo hame fesega:mu amola e da ea mi amola lafi dedebole, agoane wele sia:mu “Ledo hamoi dagoi! Ledo hamoi dagoi!” ");
INSERT INTO beo_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Olo da ema madelai hame uhi galea, e da ledo hamoi dagoi ba:mu. Amola e da dunu ilia esalebe amoga gadili fawane esalu, eno dunu ilima hame gilisimu. ");
INSERT INTO beo_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Dunu o uda ilia salasu abula (wulo o godeni) amoga gagoba: iga giagala:i ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","o abula eno o bulamagau gadofo o liligi ohe gadofo amoga hamoi, amoga gagoba: iga giagala:i ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","amo gagoba: iga giagala:i da yoi o golofoyei ba:sea, amo da gagoba: iga giagala:i ai ahoana galebeya dawa:ma. Amola amo liligi gobele salasu dunuma olelema. ");
INSERT INTO beo_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Gobele salasu dunu da amo liligi ba:lalu, la:ididili ligisili, eso fesuale agoane yolesi dialumu. ");
INSERT INTO beo_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Eso fesuga e da amo liligi bu ba:mu. Gagoba: iga giagala:i da bu ai ahoabe ba:sea, amo liligi da ledo hamoi dagoi sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Gobele salasu da amo liligi laluga ulagimu. Bai amo da ai ahoabe gagoba: iga giagala:i amola sema da agoai liligi laluga ulagima. ");
INSERT INTO beo_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Be gobele salasu dunu da liligi ba:sea, gagoba: iga giagala:i da hame ai ahoabe ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","e da amo liligi dodofema:ne sia:nanu, eso fesuale eno amoga bu ligisimu. ");
INSERT INTO beo_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Amasea, e da amo liligi bu ba:mu. Gagoba: iga giagala:i da bu hame ai ahoa be ea da:i afadenesu hou da hame afadenei ba:sea, amo liligi da ledo hamoi dagoi e da sia:mu. Amo liligi da habodili dasai galea-midadi o baligia – laluga gobesima. ");
INSERT INTO beo_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Be e da amo liligi bu ba:sea, gagoba: iga giagala:i da gudu sa:ili hamedei agoane ba:sea, e da gagoba: iga giagala:i sogebi amo abula o bulamagau gadofo amoga gadelale fasimu. ");
INSERT INTO beo_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Amasea, gagoba: iga giagala:i da amo liligiga bu ba:sea, liligi ea eda da amo laluga gobesima:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Be e da liligi dodofebeba:le, gagoba: iga giagala:i daginisi da fadegai dagoi ba:sea, e da amo liligi bu dodofesea, e da ledo hame hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Amo dedei da sema, amo gagoba: iga giagala:i da abula (wulo o godeni ha:i) o ohe gadofo amoga madelai ba:sea hahamoma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","2","Hina Gode da Mousesema dunu da gadofo oloi uhibiba:le, ledo hamedei hamoma:ne amane olelei, “Eso amoga ilia da amo dunu da ledo hamedei hamoi dagoi sia:sea, ilia da amo dunu gobele salasu dunu ema oule masunu. ");
INSERT INTO beo_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Gobele salasu dunu da dunu ilia esalebe amoga gadili oule asili, ea hou ba:mu. Ea oloi da uhi dagoi ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","gobele salasu dunu da ledo hamedei sio aduna amola dolo ifa dudiai amola yoi efe amola ‘hisobe’ amoda lulubila, amo ema gaguli misa:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Amasea, gobele salasu dunu da sia:beba:le, ilia da sio afae amo osoboga hamoi ofodo amo ganodini si hano sali, amo gadodili medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Gobele salasu dunu da sio eno lale, amo amola dolo ifa amola yoi efe amola ‘hisobe’ amoda musa: sio ea maga:me ganodini gemu. ");
INSERT INTO beo_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","E da amo maga:me fesuale agoane dunu amo da gadofo oloi bagade galu amoga fogaga:ga:la:mu. Amasea, e da amo dunu da ledo hamedei hamoi dagoi sia:mu. Amasea, e da sio hame medoi amo hahawane hagili masa:ne yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Dunu amo da gadofo oloi bagade galu da hi abula dodofelalu, ea hinabo huluane waga:mu amola hano ulimu. Amasea, e da ledo hamedei hamoi dagoi ba:mu. E da diasu gilisisu ganodini misunu da defea, be e da ea abula diasu amoga gadili eso fesuale esalumu. ");
INSERT INTO beo_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Eso fesuga e da bu ea dialuma amola maya:bo amola si hinabo amola hinabo huluane ea da:iga dialebe amo waga:mu. E da ea abula dodofelalu, hano ulimu. Amasea, e da ledo hamedei hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Eso godo amoga e da gawali sibi mano aduna amola aseme sibi mano afadafa (amo da ode afaega lalelegei amola noga:idafa ledo hamedei) amola3 gilougala:me falaua amo da olife susuligi amola bibiagone gilisi, amola1/3 lida olife susuligi, amo gaguli misunu. ");
INSERT INTO beo_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Amasea, gobele salasu dunu da amo dunu amola ea gobele salasu liligi, amo Hina Gode Ea Abula Diasu logo holeiga oule masunu. ");
INSERT INTO beo_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Amasea, gobele salasu dunu da gawali sibi mano afae amola1/3lida olife susuligi amola Hina Godema Iasu dabe ima:ne imunu. Amo da gobele salasu dunu ea Hina Godema iasu liligi. ");
INSERT INTO beo_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","E da sogebi amoga ilia ohe Wadela:i Hou Gogolema:ne Olofosu Iasu gobele salasu amola ohe Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne medole legesa, amo sogebiga amo gawali sibi mano medole legemu. Bai Wadela:i Hou Dabe Ima:ne Iasu gobele salasu iasu amola Wadela:i Hou Gogolema:ne Olofoma:ne Iasu amo defele, Dabe Ima:ne Iasu da gobele salasu dunu ea liligi, amola hadigidafa gala. ");
INSERT INTO beo_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Gobele salasu dunu da sibi mano ea maga:me mogili lale, dunu amo e da ledo hamedei hamomusa: dawa:sa, amo ea lobodafadi gehahaya amola ea lobodafa bi amola ea emodafa bi amoga legemu. ");
INSERT INTO beo_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Gobele salasu dunu da olife susuligi mogili lale, hi lobo fofadi gafe amoga sogadigimu. ");
INSERT INTO beo_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","E da ea lobodafa lobosogo amo susuligi ganodini gele, Hina Gode ba:ma:ne fesuale agoane fogaga:ga:lamu. ");
INSERT INTO beo_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","E da susuligi ea lobodafa gafe ganodini diala amoga mogili lale, amola sibi mano ea maga:me mogili lale, dunu amo e da ledo hamedei hamomusa: dawa:sa, amo ea lobodafadi gehahaya amola ea lobodafa bi amola ea emodafa bi amoga legemu. ");
INSERT INTO beo_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Gobele salasu dunu da susuligi eno ea lobodafa gafe da:iya diala amo huluane dunu ea dialuma amoga sogadigimu. E da amo dunu sema dodofei dagoi hamoma:ne agoane hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Amasea, gobele salasu dunu da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hou hamomu, amola ledo hamedei hamoma:ne hou hamomu. Amalalu, e da Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne, amo ohe medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Amola e da amo ohe amola ‘gala:ine’ iasu gilisili oloda da:iya gobele salimu. E da amomane dodofesu hou hamomu. Amasea, musa: ledo hamoi dunu amo da ledo hame hamoi dagoi sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Be dunu da hame gaguiwane galea amola musa: sia:i liligi gaguli misunu hamedei ba:sea, e da ea hou hahamomusa:, sibi mano afadafa fawane gobele salasu dunu Hina Godema ima:ne gaguli misunu. Amola e da1 gilougala:me falaua olife susuligi amoga gilisi amola1/3 lida olife susuligi amo gala:ine iasu gaguli misunu. ");
INSERT INTO beo_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","E da dafe sio aduna o musuni sio aduna amola gaguli misunu. Sio afae da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu amola sio eno da Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne. ");
INSERT INTO beo_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ea dodofesu hou eso godoane gala amoga e da amo liligi gobele salasu dunu Hina Gode Ea Abula diasu logo holeiga gaguli misunu. ");
INSERT INTO beo_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Gobele salasu dunu da sibi mano amola olife susuligi lale, gobele salasu dunu ea iasudafa agoane Hina Godema imunu. ");
INSERT INTO beo_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","E da sibi mano medole legele, amo ea maga:me mogili lale, dunu ea lobodafadi gehahaya amola ea lobodafa bi amola ea emodafa bi amoga legemu. ");
INSERT INTO beo_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Gobele salasu dunu da susuligi mogili ea lobo fofadi gafe amoga sogadigili, ");
INSERT INTO beo_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","amola ea lobodafa lobosogo amo susuligi ganodini gele, Hina Gode ba:ma:ne, amo susuligi fesuale agoane fogaga:gala:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","E da susuligi mogili amo sogebi e da maga:me legei, amoga legemu; amo dunu ea gedafa gehahaya amola ea lobodafa bi amola ea emodafa bi amoga. ");
INSERT INTO beo_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Susuligi eno diala amo e da dunu ea dialuma da:iya sogadigimu. E da agoane amo dunu ledo hamedei hamoma:ne hou hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Amasea, e da dafe sio afae o musuni sio afae amo iasu hamomu. ");
INSERT INTO beo_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Sio afae da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu amola sio eno da Wadela:i Hou Dabe Ima:ne Iasu. E da gala:ine iasu amola gilisili gobele salasu hamomu. E da agoane amo dunu ledo hamedei hamoma:ne hou hamomu. ");
INSERT INTO beo_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Amo sema da dunu amoga gadofo oloi bagade madelai, e bu ledo hamedei hamoma:ne hanai be hame gaguiba:le, sema liligi huluane imunu hamedei ba:sea. Hou da agoane gala. ");
INSERT INTO beo_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","34","Hina Gode da Mousese amola Elanema hamoma:ne sia:i eno olelei. Ilia da diasu ganodini amo gagoba: iga giagala:i bagade ba:sea, agoane hamoma:ne sia:i. (Amo sema, Hina Gode da Isala:ili dunu ilima Ga:ina:ne soge ia dagosea, amola ilia da amo ganodini fila ahoasea, agoane hamoma:ne sia:i). ");
INSERT INTO beo_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","“Nowa dunu da hi diasu ganodini gagoba: iga giagala:i ba:sea, e da gobele salasu dunu ema olelemusa: masa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Gobele salasu dunu da liligi huluane amo diasu ganodini diala, gadili fadegama:ne sia:mu. Amasea, e da amo gagoba: iga giagala:i ba:la masunu. Be liligi huluane gadili hame fadegasea, e da amo liligi huluane da ledo gala hamoi dagoi sia:mu. Amasea, e da amo diasuga, ");
INSERT INTO beo_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","gagoba: iga giagala:i ba:la masunu. E da yoi o mola:iyai daginisi amo diasu ea dobea amoga nuisa ahoabe ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","e da amo diasu yolesili, logo ga:silalu, eso fesuale yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Eso fesuga e da bu misini, diasu bu ba:mu. Gagoba: iga giagala:i da bu ai ahoabe ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","e da igi amoga gagoba: iga giagala:i dialebe, amo fadegale, gadili ledo gala sogebi moilai gadili dialebe amoga ha:digima:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Amasea, e da sia:beba:le, ilia da dobea amogili huluane baholesisilalu, amo liligi amola ledo gala hamoi sogebi moilai gadili dialebe amoga galagamu. ");
INSERT INTO beo_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Amasea, ilia da igi eno musa: igi galagai ilia sogebi amoga legemu amola dobea amoga bu gaheabonone bahoseselesimu. ");
INSERT INTO beo_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Be amo hou huluane hamoi dagosea amola fa:no gagoba: iga giagala:i da amo diasuga bu ba:sea, ");
INSERT INTO beo_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","gobele salasu dunu da bu ba:la masunu. Gagoba: iga giagala:i da bu ai ahoabe ba:sea, diasu da ledo hamoi dagoi, e da sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Amasea, amo diasu mugululi, ea igi amola ea ifa amola ea bahoseselesi huluane ledo gala sogebi moilai gadili dialebe amoga gaguli masa:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Be diasu da logo hamoi dialea, nowa da ganodini golili dasea da ledo hamoi dagoi ba:mu. Daeya doaga:sea fawane bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Amola nowa da amo diasu ganodini golala dasea o ha:i nasea, e da ea abula huluanedodofema:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Be agoai diasu da bahosesema:ne gaheabolo legebeba:le, gobele salasu dunu ba:la masea, gagoba: iga giagala:i da hamewane ba:sea, e da amo diasu da ledo hamedei hamoi dagoi sia:mu. Bai gagoba: iga giagala:i huluane da fadegai dagoiba:le. ");
INSERT INTO beo_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Amo diasu da sema ganodini ledo hamedei, amo hamoma:ne, e da sio aduna amola dolo ifa amola yoi efe amola ‘hisobe’ amoda fonobahadi lamu. ");
INSERT INTO beo_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Amasea, e da sio afae amo osoboga hamoi ofodo amo ganodini nasegagi gu hano sali, amo gadodili medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Amasea, e da dolo ifa amola ‘hisobe’, amola yoi efe, amola sio hame medoi amo lale, sio eno ea maga:me amola gu hano amo ganodini gemu. Amola e da amo maga:mega, diasu amoga fesuale agoane fogaga:gala:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","E da amomane, sio ea maga:me amola nasegagi gu hano amola sio hame medoi amola dolo ifa amola hisobe amola yoi efe amoga diasu da ledo hamedei hamoi dagoi hamomu. ");
INSERT INTO beo_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Amasea, e da sio hame medoi amo hagili masa:ne, logo doasimu. E da amo ledo fadegama:ne hou hamosea, diasu da ledo hamedei, dodofei dagoi sia:mu. ");
INSERT INTO beo_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Amo da gadofo olo bagade ea sema dedei dagoi. ");
INSERT INTO beo_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","- ");
INSERT INTO beo_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Gadofo olo amola aiya amola dului amola gagolobale gala:i. Amola gagoba: iga giagala:i abula o diasu ganodini gala. ");
INSERT INTO beo_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Amo sema dawa:beba:le, dilia da liligi da ledo gala o ledo hamedei noga:le dawa:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Hina Gode da Mousese amola Elanema hamoma:ne sia:i eno olelei. ");
INSERT INTO beo_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","E da ela Isala:ili dunu ilima amane olelema:ne sia:i. “Nowa dunu da ea ewa amoga guhi agoane gadili ahoasea, amo guhi da ledo gala dawa:ma! ");
INSERT INTO beo_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Guhi da gadili ahoasea o ewa ea gelabo ga:sea, amo da ledo gala dawa:ma. ");
INSERT INTO beo_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","E da golasu fafai amoga golasea, amo amola da ledo hamoi dagoi dawa:ma. ");
INSERT INTO beo_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","- ");
INSERT INTO beo_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Nowa da ea debea digili ba:sea o ea fibi sogebi amoga fisia da ea abula dodofelalu amola hano ulima:mu. Amo dunu da ledo gala hamoi dagoiba:le, daeya doaga:sea fawane e da bu noga:le dodofei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Nowa da dunu ea ewa amoga guhi gadili ahoasea, amo digili ba:sea, e amola da ea abula dodofemu amola hano ulimu amola ledo gala hamoi dagoi ba:ma:mu. Daeya doaga:sea fawane, bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Dunu da guhi gadili ahoabe amo da eno dunuma defo adugala:sea, amo dunu amola da ledo gala hamoi dagoi ba:mu. E da ea abula dodofemu amola e da hano ulimu amola daeya doaga:sea fawane bu sema amo ganodini dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Dunu amo da guhi gadili ahoa, amo da hosi da:iya fila heda:ma:ne fisu o fisudafa amoga fisia, amo fisu da gugunufinisili ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Nowa da fisu amoga amo dunu da fisu digili ba:sea, e da ledo hamoi dagoi ba:mu. Daeya doaga:sea fawane bu ledo hamedei ba:mu. Nowa da liligi amoga amo dunu da fisia amo gaguli ahoasea, e da ea abula dodofemu amola hano ulimu amola daeya fawane ea ledo hamoi hou yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Dunu da guhi gadili ahoabe amola ea lobo mae dodofele, eno dunu digili ba:sea, amo dunu da ea abula dodofemu amola hano ulimu amola ledo gala hamosa. Daeya doaga:sea fawane yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Amola guhi gadili ahoabe dunu da osoboga hamoi ofodo amo digili ba:sea, amo goudale fasima:ne sia:ma. Amola ifaga hamoi yaeya amo dodofema. ");
INSERT INTO beo_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Amo dunu ea oloi da uhisia, e da eso fesuale esalu, ea abula dodofemu, amola hi da nasegagi gu hano amoga ulimu. Amasea, e da ledo hamedei hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Eso godoga e da ‘dafe’ sio aduna o musuni aduna amo gobele salasu dunuma ima:ne, Hina Gode Ea abula diasu logo holeiga gaguli misa:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Gobele salasu dunu da sio afae Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salimusa: hamomu amola sio eno da Wadela:i Hou Dabe Ima:ne Iasu hamomu. E da amo dunu ea ledo fadegale, sema amoga e da dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Dunu da ea ami gadili ahoasea, e da ea da:i huluane hano ulimu, amola e da ledo hamoi dagoi ba:mu. Daeya doaga:sea fawane yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ea ami da abula o ohe gadofo liligi amoga dasea, amo noga:le dodofemu amola amo liligi da ledo hamone, daeya doaga:sea fawane bu ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Dunu amola uda da gilisili golasea, ela da hano ulimu amola ledo hamoiba:le, daeya doaga:sea fawane ledo hamedei hamoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Uda da oubi ganodini sioi fisu doaga:sea, e da eso fesuale ledo hamoi dagoi ba:mu. Nowa da amo uda digili ba:sea da ledo hamoi dagoi ba:mu. Daeya doaga:sea fawane e da bu ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Uda da ea sioi fisu ganodini, liligi huluane amoga e da fisia o golasea da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Nowa da ea golasu o fisu amoga e da fi o golai amo digili ba:sea, e da ea abula dodofemu amola hano ulimu amola ledo hamoi gala dialumu amoganini daeya. ");
INSERT INTO beo_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Nowa dunu da amo uda ea sioi fisu esoga ema gilisili golasea, e amola da ea ledo ema madelabeba:le, ledo gala eso fesuale agoane dialumu. Amola ea golasu o debea amoga e da golasea da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Amola uda da ea sioi fisu baligili, maga:me ahoabe ba:sea, e da ea oubi sioi fisu defele, maga:me ea ahoabe eso defele ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ea debea o henela:gi amoga e da diaha o fisu amo huluane da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Nowa da ea debea o fisu liligi digili ba:sea, amo da ledo hamoi dagoi ba:mu. E da ea abula dodofemu amola hano ulimu. Daeya doaga:sea fawane, bu ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ea maga:me ahoabe dagosea, e da eso fesuale ouesalu, bu ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Eso godo amoga e da ‘dafe’ sio aduna o musuni aduna lale, gobele salasu dunu Hina Gode Ea abula diasu logo holeiga esala amoga gaguli masunu. ");
INSERT INTO beo_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Gobele salasu dunu da sio afadafa amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamomu. Amola sio eno da Wadela:i Hou Dabe Ima:ne Iasu hamomu. Amasea, amo uda da sema dodofei dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Hina Gode da Mousesema sisasu olelei. Dunu o uda da ledo hamoiba:le, ilia da Ea Abula Diasu ilia diasu gilisisu dogoa dialebe, amo ledo hamosa:besa:le, amoga mae misa:ne sia:i. Ilia amoga ledowane udigili doaga:sea, ili fane legema:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Amo dedei sema da sema amo dunu da guhi gadili ahoa o ami gadili ahoa, ");
INSERT INTO beo_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","amola uda da ea sioi fisu o dunu da ledo hamoi uda amoga gilisili golasa, amo ilia hou olelesa. ");
INSERT INTO beo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Elane egefe aduna da hadigi hame lalu amo Hina Godema iabeba:le, Hina Gode da ela medole legei dagoi. Amo fa:no, Hina Gode da Mousesema sia:i. ");
INSERT INTO beo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","E da amane sia:i, “Dia ola Elanema sia:ma. E da ea hanaiga Hadigidafa Momei Sesei ganodini udigili golili mae sa:ima:ne sia:ma. E da eso amo da Na ilegei, amoga fawane Abula Gosagisi amo baligili Hadigidafa Momei Sesei amo ganodini masa:ne sia:ma. Bai Na da amogawi mu mobi amo ganodini Gode Ea Gousa:su Sema Gagili ea ga:su gadodili esalebe ba:mu. Elane da amo sia: nabawane hame hamosea, e da medole legei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","E da Hadigidafa Momei Sesei amo ganodini udigili hame sa:imu. Be e da hidadea bulamagau mano gawali, Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne amola gawali sibi amo Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne, gaguli misa:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Amasea, Hina Gode da eno olelesu i, amane, “Elane da Hadigidafa Momei Sesei amo ganodini golili masunusa: dawa:sea, e da hidadea hano ulimu amola gobele salasu dunu abula (amo da ahea:iai abula, dunumuni selefa, bulu amola habuga abula) amo salima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isala:ili fi dunu da Elanema goudi gawali aduna Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne amola sibi gawali afae Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne ima:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","E da ea wadela:i hou amola ea sosogo fi dunu ilia wadela:i hou fadegama:ne, bulamagau gawali gobele salimu. ");
INSERT INTO beo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Amasea, e da goudi aduna Hina Gode Ea Abula Diasu logo holeiga oule masunu. ");
INSERT INTO beo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Amogawi, e da igi aduna (afae da Hina Gode Ea: amola eno da Fadegamusa: Ahoasu Goudi amo ea:) amoga ululuasu ado ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Elane da goudi amo Hina Godema ilegei amo medole legele, Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Be goudi eno Fadegamusa: Ahoasu Goudi ema ilegei amo e da Hina Godema mae medole ima:mu. Amo goudi e da wadela:i hafoga:i soge Isala:ili dunu ilia wadela:i hou fadegama:ne asunasimu. ");
INSERT INTO beo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Elane amola ea sosogo fi ilia wadela:i hou fadegama:ne, bulamagau gawali amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne, medole legema:mu ");
INSERT INTO beo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","E da yaeya amo laluso amoga nabai oloda amoga lale amola lobo aduna gabusiga: manoma amoga nabai, Hadigidafa Momei Sesei amo ganodini gaguli misa:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Amogawi, Hina Gode ba:ma:ne, e da gabusiga: manoma laluga gobesimu. Gabusiga: manoma ea mobi da Gode Ea Gousa:su Sema Gagili ea ga:lu amo uligimu. Bai Elane da Gagili ga:lu amo ea ba:iaba, e da bogola:loba. ");
INSERT INTO beo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","E da bulamagau gawali ea maga:me mogili lale, ea lobo sogo amoga Gode Ea Gousa:su Sema Gagili ga:lu ea midadi amoga fogaga:gala:mu. Amola fesuale agoane, e da maga:me Gode Ea Gousa:su Sema Gagili ea midadi fogaga:ga:la:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Amalalu, e da Isala:ili dunu ilia wadela:i hou fadegama:ne, goudi medole legele, ea maga:me amo Hadigidafa Momei Sesei ganodini gaguli misini, bulamagau ea maga:me defele, Gode Ea Gousa:su Sema Gagili ea ga:lu amola Gode Ea Gousa:su Sema Gagili midadi amoga foga:gala:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","E da agoane sema hamomu. Isala:ili dunu da ledo hamoi dagoiba:le, Hadigidafa Momei Sesei gugunufinisi. Be amo gobele salasu hamobeba:le, e da amo ledo amola Isala:ili fi dunu ilia wadela:i hou fadegasa. E da amo hou Hina Gode Ea Abula diasu ganodini hamomu. Bai Abula Diasu da diasu gilisisu dogoa amogawi dana. Amola Hina Gode da diasu gilisisu da ledo gala hamoi dagoi ba:sa. ");
INSERT INTO beo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Elane hisu da Hadigidafa Momei Sesei ledo fadegama:ne masunu. Eno dunu da hamedafa golili sa:imu. E, ea sosogo fi amola Isala:ili dunu huluane ilia wadela:i hou fadegama:ne hou hamoi dagosea, ");
INSERT INTO beo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","e da gadili oloda amoga ilia ohe gobesisu amoga ledo fadegama:ne masunu. E da bulamagau gawali amola goudi ela maga:me mogili lale, oloda hegomai ea ‘hono’ amoga fogaga:ga:la:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ea lobo sogo amoga e da maga:me mogili fesuale agoane oloda da:iya fogaga:gala:mu. E da agoane oloda dodofemu. Isala:ili dunu ilia wadela:i hou hamobeba:le, oloda amo ledo hamoi dagoi. Be Elane da amo noga:lesimu amola bu hadigi agoane hamonesimu. ");
INSERT INTO beo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Elane da Hadigidafa Momei Sesei amola Hina Gode Ea Abula Diasu bu hahamoma:ne hou hamoi dagosea, e da Hina Godema amo hame medoi goudi (Fadegamusa: Ahoasu Goudi) ilegei imunu. ");
INSERT INTO beo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","E da ea lobo aduna amo goudi ea dialuma amoga ligisili, Isala:ili dunu ilia wadela:i hou amola odoga:su hou huluane fofada:ma:ne olelemu. E da agoane amo wadela:i hou Isala:ili dunu ilima fadegale, bu goudi ea dialumaga ligisimu. Amasea, dunu amo ilia da ilegei, da amo goudi wadela:i hafoga:i sogega sefasima:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Goudi da Isala:ili dunu ilia wadela:i hou huluane gaguli asili, dunu hame esalebe sogega gaguli masunu. ");
INSERT INTO beo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Amasea, Elane da Abula Diasuga golili sa:ili, ea gobele salasu abula (amo e da Hadigidafa Momei Sesei ganodini masunusa: hidadea sali) amo gigisa:le, amogawi yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","E da hadigi ledo hamedei sogebi amoga hano ulimu amola ea abuladafa gasisalimu. Amalalu, e da gadili asili, ea wadela:i hou amola ea fi dunu ilia wadela:i hou fadegama:ne, Wadela:i Hou Dabe Ima:ne Iasu hamomu. ");
INSERT INTO beo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","E oloda da:iya Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne, sefe amo gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Dunu amo da Fadegamusa: Ahoasu Goudi amo wadela:i hafoga:i sogega sefasi, e da ea abula dodofelalu, hano ulimu. Amasea, e da diasu gilisisu amoga bu misunu. ");
INSERT INTO beo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ilia da bulamagau amola goudi (amo ela maga:me da wadela:i hou fadegama:ne, Elane da Hadigidafa Momei Sesei ganodini gaguli misi) amo diasu gilisisu gadili gaguli asili, gobesimu. Ilia da gadofo, hu amola iga huluane gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ilegei dunu da amo gobesu hou hamoi dagosea, e da ea abula dodofelalu, hano ulimu. Amasea, e da diasu gilisisu amoga buhagimu da defea. ");
INSERT INTO beo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Wali eso amola hobea eso huluane amo sema noga:le ouligima. Oubi fesu amoga amola eso nabu, Isala:ili dunu amola ga fi ilia fi amo ganodini esalebe, da ha:i mae nawane helefima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Amo eso afaega, hou amo da ilia wadela:i hou fadegama:ne, ilia da bu ledo hamedei ba:ma:ne, hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Amo eso da hadigidafa eso ilegei. Amoga, ilia da ha:i hame manu amola hawa: hamosu hamedafa hamomu. Amo hamoma:ne sia:i dilia eso huluane mae yolesili hamonanoma. ");
INSERT INTO beo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Gobele salasu Ouligisu dunu (amo da noga:le mogili gagai amola ea ada ea sogebi lai dagoi) e da ledo fadegama:ne hou hamomu. E da ea gobele salasu abula gasisalili, ");
INSERT INTO beo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","hou amo da Hadigidafa Momei Sesei, oloda, gobele salasu fi dunu amola Isala:ili dunu huluane, amo fofoloma:ne hamomu. ");
INSERT INTO beo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Amo hamoma:ne sia:i dilia mae yolesili, eso huluane hamonanoma. Ode huluane amoga amo hou Isala:ili dunu ilia wadela:i hou fadegama:ne, hamonanoma.” Amaiba:le, Mousese da Hina Gode Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","2","Hina Gode da Mousesema, e da Elane, egefela amola Isala:ili dunu huluane ilima amane alofele sia:ma:ne sia:i, ");
INSERT INTO beo_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","- ");
INSERT INTO beo_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","“Isala:ili dunu da bulamagau o sibi o goudi amo Hina Godema ima:ne medole legesea, be Hina Gode Ea Abula Diasu logo holeiga hame medole legesea, e da Sema gugunufinisi dagoi ba:mu. E da maga:me masa:ne, liligi medole legei dagoi. Amaiba:le, dilia amo dunu Gode Ea fi amoga fadegama. ");
INSERT INTO beo_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Amo sia: ea bai da Isala:ili dunu amo da musa: sogega ohe medole legei, ilia da wali amo ohe Hina Godema oule misunu. Ilia da gobele salasu dunu Hina Gode Ea Abula Diasu logo holeiga esala, ema ohe gaguli misini, Hahawane Gilisili Olofole Iasu gobele salasu hamomusa: medole legema:mu. ");
INSERT INTO beo_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Gobele salasu dunu da maga:me amo oloda Abula Diasu logo holeiga dialebe amo ea la:idiga sogaga:la:le gaganomu. Amola amo ohe ilia sefe, e da Hina Gode hahawane nabima:ne, oloda da:iya gobesimu. ");
INSERT INTO beo_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Isala:ili dunu da Hina Godema hohonoi. Bai ilia da sogega ilia ohe amo goudi wadela:i a:silibu ema nodomusa: gobele salasu. Be wali amo hou yolesima. Ilia da eso huluane mae yolesili, sema amo da Hina Gode ilima olelei, amo nabawane hamoma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Nowa Isala:ili dunu o ga fi dunu ilia fi amo ganodini esala, da Wadela:i Hou Dabe Ima:ne Iasu o gobele salasu eno, ");
INSERT INTO beo_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","amo Godema ima:ne, be Hina Gode Abula Diasu logo holeiga hame gaguli masea, amo dunu ea logo damuma amola bu Gode Ea fi dunu esalebe hame ba:ma:mu. ");
INSERT INTO beo_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Nowa Isala:ili dunu o ga fi dunu ilia fi ganodini esala, amo da hu amoga da maga:me dialebe amo nasea, Hina Gode da amo dunuma ha lai hamomu amola e da Hina Gode Ea fi dunu amoga fadegai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Esalebe liligi huluanedafa ilia esalusu da maga:me amo ganodini diala. Amaiba:le, Hina Gode da gasa bagadewane, ohe ilia maga:me dunu ilia wadela:i hou fadegama:ne, oloda da:iya fawane sogadigima:ne sia:i. Maga:me da esalusu liligi, amola amo da dunu ilia wadela:i hou fadegamusa: dawa:. ");
INSERT INTO beo_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Amaiba:le, Hina Gode da Isala:ili dunu ilima gasa bagadewane, ilia amola ga fi ilia fi ganodini esala da hu amo ganodini da maga:me, amo mae moma:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Isala:ili dunu o ga fi dunu ilia fi ganodini esala, amo da ohe o sio (sema amo ganodini ledo hamedei liligi) amo benea asili medole legesea, e da amo ea maga:me osoboga sogadigili, osoboga dedebomu. ");
INSERT INTO beo_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Esalebe liligi huluanedafa ilia esalusu da maga:me amo ganodini diala. Amaiba:le, Hina Gode da Isala:ili dunuma olelei dagoi. Ilia da hu amo ganodini da maga:me, amo mae moma:ne sia:i. Amola nowa da amo hu nasea, e da Hina Gode Ea fi amoga fadegai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Nowa dunu, Isala:ili fi dunu o ga fi dunu da ohe fi hi bogoi o sigua enoga medole legei, amo ea hu nasea, e da ea abula dodofemu amola hano ulimu. E da ledo hamoi dagoiba:le, daeya doaga:sea fawane bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","E da amo sema hame hamosea, hisu wadela:le hamobeba:le, se iasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","2","Hina Gode da Mousesema e da Isala:ili dunu ilima amane sia:ma:ne sia:i, “Na da dilia Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Dilia da musa: Idibidi fi ilia soge ganodini esalu amola Na da wali dili Ga:ina:ne sogega oule ahoa. Be amo dunu fi ilia hou mae fa:no bobogema. ");
INSERT INTO beo_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Na sema amola Na hamoma:ne sia:i liligi amoma fa:no bobogema. Bai Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Hou huluane amola sema Na da dilima iaha, amoma fa:no bobogema. Agoane hamosea, dilia da dilisu esalusu gaga:mu. Na da Hina Godedafa.” ");
INSERT INTO beo_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Hina Gode da haguduga dedei hamoma:ne sia:i olelei, “Dilia sosogo fi ilima gilisili mae golama. ");
INSERT INTO beo_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Dia ame ema maedafa gilisili golama. Bai dia ada da gogosiamu. Dia ame gogosiama:ne hamomu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Dia ada gogosiasa:besa:le, ea uda eno ilima gilisili golamu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Dia dalusi o fi dalusi ilima gilisili golamu da sema bagade. E da dia diasuga bugili i, o eno sogebi bugili i galea, amo sema da defele gala. Ilima mae gilisili golama. ");
INSERT INTO beo_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Didiwi ea uda mano ema mae gilisili golama. Amo hou da dima gogosiasu liligi. ");
INSERT INTO beo_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Dia dalusi adagili amola ame higagai, ilima mae gilisili golama. Bai e da dia dalusidafa. ");
INSERT INTO beo_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","- ");
INSERT INTO beo_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Dia awa o biya amoma gilisili mae golama. ");
INSERT INTO beo_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Dia adabi o ada o baba o daya amo ea udama gilisili mae golama. Bai e amola da dia awadafa. ");
INSERT INTO beo_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Dia gofe ea idua ema gilisili mae golama. ");
INSERT INTO beo_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Dia ola o diaea uda ilima gilisili mae golama. ");
INSERT INTO beo_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Dia uda amoma di gilisili golai amo ea uda mano o aowailima mae gilisili golama. Bai amo da dia fidafa. Amasa:besa:le, sema bagade gala. ");
INSERT INTO beo_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Dia udadafa esalea, di da dibae lamu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Uda da sioi fisia, ema gilisili mae golama. Bai e da sema ganodini, ledo hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Dunu eno ea uda ema mae gilisili golama. Bai amo hou hamosea, di ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Dilia da dilia mano amo ogogosu ‘gode’ Moulege ema nodone sia:ne gadomusa:, gobele salasu hamoma:ne mae ima. Bai amo hou da Hina Gode Ea Dio wadela:mu. ");
INSERT INTO beo_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Dunu da dunu eno gilisili golamu (sama da ea sama adole lamu) da sema bagadedafa. Gode da amo hou bagade higasa. ");
INSERT INTO beo_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Dunu o uda da ohe amoma hademu da sema bagadedafa. Amo hou hamosea, di da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Dilia da amo hou hamosea, ledo gala hamoi dagoi, amasa:besa:le, amo hou huluane mae hamoma. Gode Ea hou hame dawa:su dunu da amo ledo bagade hou hamosu. Amo dunu da Ga:ina:ne soge amo ganodini esalu. Be wali, dili amo ganodini golili sa:ima:ne, Hina Gode da amo dunu gadili sefasilala. ");
INSERT INTO beo_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ilia hou da Ga:ina:ne soge amo ledo gala hamoi dagoi. Amaiba:le, Hina Gode da amo sogega se iaha. Amola fedege agoane, Hina Gode hamobeba:le, soge da ea musa: fi dunu higale ili isolala. ");
INSERT INTO beo_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","- ");
INSERT INTO beo_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ilia da amo wadela:idafa hou hamobeba:le, ilia soge ledo gala hamoi dagoi. Be dilia da agoaiwane mae hamoma. Dilia huluane, Isala:ili dunu amola ga fi dili gilisili esala, Hina Gode Ea hamoma:ne sia:i liligi amola sema huluane amoma fa:no bobogema. ");
INSERT INTO beo_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Amasea soge da hame lalegagui dunu dili bisili amo soge ganodini amo higale fadegai amo defele, soge da dilima higale hame fadegamu. ");
INSERT INTO beo_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Dilia dawa:! Nowa da amo wadela:idafa hou afae hamosea, e da Gode Ea Fidafa dunu agoane hame ba:mu.” ");
INSERT INTO beo_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Amola Hina Gode da eno amane sia:i, “Na hamoma:ne sia:i liligi amoma fa:no bobogema! Dunu amo da dili bisili amo soge ganodini esalu, ilia hou amoma mae fa:no bobogema. Dilia amo hou agoane hamosea, ledo gala hamoi dagoi ba:mu. Amaiba:le, amo hou maedafa hamoma. Na da dilia Hina Godedafa!” ");
INSERT INTO beo_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","2","Hina Gode da Mousesema e da alofele Isala:ili dunu ilima sia:ma:ne sia:i, “Dilia hadigi agoane hamoma. Bai Na, dilia Hina Gode, da Hadigidafa gala. ");
INSERT INTO beo_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Dilia huluane afae afae amo dilia ada amola ame elama nodone dawa:ma. Amola Na sema defele, Sa:bade eso noga:le ouligima. Na da dilia Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Dilia Na mae yolesima. Amola eno loboga hamoi ogogosu ‘gode’ ilima nodone mae sia:ne gadoma. Ogogosu ‘gode’ ouli amoga mae hamoma amola ilima mae nodone sia:ne gadoma. Na da dilia Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Dilia Hahawane Gilisili Olofole Iasu hamoma:ne, ohe medole legesea, sema huluane Na dilima i, amoma fa:no bobogema. Amasea, Na da dilia iasu hahawane lamu. ");
INSERT INTO beo_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Amo iasu ea hu da eso amoga e da medole legei o aya eso agoane moma:ne sia:mu. Be eso osoda amoga hu hame mai dialebe ba:sea, amo laluga gobesima. ");
INSERT INTO beo_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Bai amo hu da ledo hamoi dagoi. Amola dunu afae da amo hu nasea, Na da iasu huluane hame lamu. ");
INSERT INTO beo_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Nowa da agoaiwane nasea, e da amo liligi Nama ilegei amo da udigili liligi olelesa. Amaiba:le, amo dunu da Na fidafa amoga fadegai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Dilia da dilia ifabi gamisia, gagoma da bega: sagai, amo mae faima. Amo gagoma udigili dialebe, amo lama:ne, mae sinidigima. ");
INSERT INTO beo_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Amola dilia waini sagai faisia, amoga waini fage fisi dialebe amo lamusa:, bu mae sinidigima. Hame gagui dunu amola ga fi amo moma:ne yolesima. Na da dilia Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Wamolasu amola ogogosu hou maedafa hamoma. ");
INSERT INTO beo_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Dilia udigili Na Dioba:le sia: mae ilegema. Amo hou da Na Dio wadela:sa. Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Dilia eno dunu ea hou wadela:ma:ne o ea liligi lamusa:, mae ogogoma. Amola mae wamolama! Nowa da dia hawa: hamosu hamoi galea, ea bidi hedolo ema ima. Gasi afae mae iawane oualigimu da defea hame. ");
INSERT INTO beo_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ge wadela:i dunu ema gagabusu aligima:ne mae ilegema. Amola si dofoi dunu da sadenane dafasa:besa:le, dafama:ne liligi ea logoga mae ligisima. Nama beda:ma! Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Fofada:su hou amo ganodini moloidafa amola defele hamoma. Hame gagui dunu ilima baligili mae dawa:ma amola bagade gagui dunu ilima mae beda:ma. ");
INSERT INTO beo_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Eno dunu ea hou gugunufinisima:ne, ogogole mae sia:ma. Amola fofada:su dunu da eno dunuma bogoma:ne fofada:su hamosea di da amo dunu gaga:musa: dawa: lai sia: galea, amo mae beda:iwane sia:ma. Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Eno dunuma mae higama. Be alia da sia:ga gegesu galea, di da wadela:i hou hamosa:besa:le, hedolowane hou hahamoma. ");
INSERT INTO beo_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Eno dunuma dabe lama:ne mae dawa:ma amola eno dunu mae higama. Be dia da:i amoma asigi hou amo defele dia na:iyadoma asigima. Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Na sema nabawane hamoma. Lai gebo hisu hisu amo mano lama:ne mae gilisima. Hawa: aduna ifabi afae ganodini mae sagama. Abula aduna amoga da:i salasu mae nodomema. ");
INSERT INTO beo_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Dunu da udigili hawa: hamosu uda amo eno dunuma ea gidisedagi uda hamoma:ne, bidi lamusa: ilegei galea, be amo dunu da ema muni hame i galea, hina dunu da ea hawa: hamosu uda ema gilisili golasea, dilia e amola amo uda mae medole legema. Bai e da ea udigili hawa: hamosu uda amola ea bidi hame lai. Be ela da se iasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Amo dunu da Dabe Ima:ne gobele salasu hamoma:ne, sibi gawali amo Na Abula Diasu logo holeiga gaguli misa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Amasea, amoga gobele salasu dunu da ledo gala dodofesu hou amo dunu ea wadela:i hou fadegama:ne hamomu. Amasea Gode da ea wadela:i hou gogolema:ne olofomu. ");
INSERT INTO beo_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Dilia da Ga:ina:ne soge amoga golili dasea, amola ha:i manu ifa bugisia, ode udiana amoga ea fage legei da ledo gala dawa:ma. Amo ode udiana ganodini, dilia da amo ifa ea fage mae moma. ");
INSERT INTO beo_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ode biyadu amoga, amo ifa ea fage huluane, Hina Godema imunusa: ilegema. Dilia da Na, Hina Gode, Nama nodomusa: agoane hamoma. ");
INSERT INTO beo_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Be ode biyale gala amoga, dilia amo ifa ea fage manu da defea. Dilia agoane hamosea, dilia ifa da fage baligili legemu. Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Hu amo ganodini da maga:me dialebe, mae moma. Wadela:i fefedoasu hou mae hamoma! ");
INSERT INTO beo_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Dilia dialuma hinabo la:ididili diala, amo mae damuni fasima, amola dilia maya:bo fe mae dadamuma. ");
INSERT INTO beo_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Gugui dedesu hou mae hamoma amola bogoi ilima asigiba:le, dilia da:i amoga mi defesu mae fa:ginisima. Na da Hina Godedafa. ");
INSERT INTO beo_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Dilia uda mano amo ogogosu ‘gode’ ea debolo diasuga hina da:i bidi lasu uda agoane maedafa hamoma. Amo hou da ili wadela:mu. Be dilia da agoane hamosea, dilia da Na yolesili, eno ogogosu ‘gode’ amoma fa:no bobogele, soge da wadela:i hamosu amoga nabaiwane ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Sa:bade eso noga:le dawa:ma. Amola sogebi amogawi dunu da Nama nodone sia:ne gadosa, amoma nodone dawa:ma. Na da Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Dunu amo da bogoi a:silibu amoma fada:i sia: hogosa, amoma mae gilisima. Agoane hamosea, dilia da ledo gala hamoi dagoi ba:mu. Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Asigilai, da:i hamoi dunu amola uda ilima nodone dawa:ma. Nama beda:ma. Na da Hina Godedafa. ");
INSERT INTO beo_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Dilia ga fi dunu dilia soge ganodini esala, ilima asigiwane hamoma. ");
INSERT INTO beo_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Dilia da dilia Isala:ili na:iyado dunu ilima hamosu defele ilima hamoma. Bu dawa:ma! Dilia amola da musa: ga fi agoane Idibidi soge ganodini esalu. Na da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Dilia eno dunuma ogogole mae hamoma. Ogogosu dioi defei ba:su liligi (scales) amola sedade ilegesu amola idisu liligi, amoga ogogole mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Moloiwane ado ba:su liligi amola dioi ba:su liligi amola sedade ilegesu liligi, amoga fawane hawa: hamoma. Na da dilia Hina Gode amola Na da dili Idibidi sogega fisili masa:ne gadili asunasi. ");
INSERT INTO beo_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Na sema amola Na hamoma:ne sia:i liligi huluane nabawane hamoma. Bai Na da Hina Godedafa.” ");
INSERT INTO beo_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Isala:ili dunu ilima amane sia:ma, Nowa Isala:ili dunu o ga fi dunu Isala:ili soge ganodini esala, amo da ea mano Moulege (ogogosu ‘gode’) ema iasea, medole legema. Isala:ili esalebe dunu da amo dunu igiga medole legema:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Na da amo dunuma ea ha lai dunu agoane ba:mu amola Na da e ea fi ilima fadegamu. Bai e da ea mano ogogosu ‘gode’ Moulege ema gobele salimusa: ia dagoiba:le, e da Na hadigi sogebi gugunufinisi dagoi amola Na hadigi Dio amo gugunufinisi. ");
INSERT INTO beo_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Dunu afae da ea mano afae Moulege ema iasea, amola Isala:ili fi dunu da mae dawa:le, amo dunu hame medole legesea, ");
INSERT INTO beo_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Na da amo dunu amola ea sosogo fi ilima mi hanane ba:mu amola e amola eno dunu huluane amo da ea hou fa:no bobogele, ogogosu ‘gode’ Moulege ema dawa:sa, amo huluane Na da Na fi dunu defele hamedafa ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Nowa da hou dawa:musa:, gesami dasu (amo da bogoi a:silibu hogosa) amoga ahoasea, Na da amo dunu ea fi amoga fadegale fasimu. ");
INSERT INTO beo_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Dilia hou hadigiwane ouligima. Bai Na, dilia Hina Gode, da hadigi. ");
INSERT INTO beo_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Na sema noga:le nabima! Bai Na da Hina Gode amola Ni fawane da dilia hou hadigima:ne hamosa.’” ");
INSERT INTO beo_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Hina Gode da eno hamoma:ne sia:i olelei, amane, “Nowa da ea eda o ame elama gagabusu aligima:ne ilegesea, amo dunu medole legema. E da hi hou hamobeba:le fawane bogomu. ");
INSERT INTO beo_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Dunu da Isala:ili dunu eno ea uda amo inia uda adole lasu hou hamosea, dilia amo dunu amola uda gilisili medole legema. ");
INSERT INTO beo_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Dunu da ea eda idua afae gilisili golasea, e da ea eda gogosiama:ne wadela:le hamosa. E amola amo uda gilisili medole legema. Elesu da wadela:i hou hamobeba:le fawane bogosu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Dunu da egefe idua amola gilisili golasea, dilia ela medole legema. Ela da fi ganodini lasu hou hamobeba:le, bogosu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Dunu da eno dunu amo sama da ea sama adole lasu hou hamosea, amo da gogosiasu wadela:idafa hou. Dilia ela gilisili medole legema. Elesu da wadela:i hamobeba:le, bogosu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Dunu da uda amola amo ea idiwi amo gilisili lasea, dilia amo udiana medole legema. Bai amo da gogosiasu liligi bagade amola amo hou dilia fi amo ganodini da sema bagade - hamedei. ");
INSERT INTO beo_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Dunu da ohe amo hadesea, e amola amo ohe medole legema. ");
INSERT INTO beo_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Amola uda da ohe amoma hademusa: dawa:sea, amo uda amola ohe gilisili medole legema. Ela wadela:i hou hamomu hanaiba:le, se iasu bogosu lamu. ");
INSERT INTO beo_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Dunu da ea dalusidafa o fi ada afae amola eme afafai amo lasea, ela dunu huluane ba:ma:ne gogosiasu lamu amola gadili sefasi dagoi ba:mu. E da ea dalusi gilisili golai dagoiba:le, se iasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Dunu da uda ea oubi sioi fisu amoga ema gilisili golasea, dilia ela gadili sefasima. Bai ilia da ledo gala hamoi sema amo gugunufinisi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Dunu da ea awa ema gilisili golasea, ela da fi ganodini wadela:i uda lasu hou hamobeba:le, amo hou ea se iasu lamu. ");
INSERT INTO beo_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Dunu da ea adabi ea uda amola edaiya idua amo gilisili golasea, e da ea adabi o edaiya ea hou wadela:lesiba:le, e amola amo uda da se iasu ba:mu. Ela da mano lalelegemu hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Dunu da ea ola o eya idua lasea, ilia da mano mae lalelegele, aligime esalu, bogomu. E da ea ola o eya ea hou wadela:lesiba:le amola ledo hamoi gala sema wadela:lesiba:le, se iasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Hina Gode da amane sia:i, “Na hamoma:ne sia:i liligi amola sema huluane amoma noga:le fa:no bobogema. Amo hamosea, Ga:ina:ne soge (amoga Na da dili oule ahoa) da dili higale hame fadegamu. ");
INSERT INTO beo_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Dilia Ga:ina:ne sogega esalebe dunu ilia hou mae lalegaguma! Na da amo hame lalegagui dunu gadili sefasilala. Ilia wadela:i hou bagade hamonanebeba:le, Na higale isomu agoai galebe. ");
INSERT INTO beo_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Be amo soge noga:i amola nasegagi Na da dilima ima:ne ilegei dagoi. Amola Na da dilima imunu. Na da dilia Hina Gode. Amola Na da dilia fi amo fifi asi gala eno amoga mogili gagai. ");
INSERT INTO beo_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Amaiba:le, dilia sio amola ohe fi amo da sema ganodini ledo gala amola sio amola ohe amo da ledo hamedei, amo afafama. Ledo gala sio amola ohe mae moma. Na da amo da ledo gala sia:beba:le, dilia da amo nasea ledo gala hamoi dagoi ba:sa:besa:le, mae moma. ");
INSERT INTO beo_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Dilia da Na: fi dunu amola hadigi hamoi dagoi ba:mu. Dilia Na fidafa dunu esaloma:ne, Na da dili amo fifi asi gala eno ilima afafai dagoi. ");
INSERT INTO beo_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Nowa dunu o uda da gesami dasu hou hamosea (bogoi a:silibu ilima sia:sa), amo dilia igiga gala:le, medole legema. Agoai dunu, hisu wadela:i hamobeba:le da bogosu ba:mu.” ");
INSERT INTO beo_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Hina Gode da Mousesema, e da Elane gobele salasu dunu ilima alofele sia:ma:ne sia:i, “Gobele salasu dunu ea fi dunu bogosea, e da ledo gala hamosa:besa:le amo dunu ea ‘idigisa’ lolo Nasu amoma maedafa gilisima:mu. ");
INSERT INTO beo_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","- ");
INSERT INTO beo_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Be ea ame o ada o egefe o idiwi o ola eya o dalusi ea diasu ganodini esala, amo bogosea e da ea bogosu dawa:su gilisisu amoga gilisimu da defea. ");
INSERT INTO beo_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Be uda lasu hou amoga dunu o uda da ea fi amoma gilisi, e da ledo gala hamosa:besa:le, amo bogosu dawa:ma:ne hou amoma hame gilisimu. ");
INSERT INTO beo_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Gobele salasu dunu da ea dialuma hinabo mogili hame waga:mu amola ea maya:bo fe hame waga:mu amola e da ea da:i dioi asigi hou olelema:ne, e da ea da:i hame mi defemu. ");
INSERT INTO beo_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","E da ea hou huluane amo ganodini hadigi ba:mu. E da Na Dio hame wadela:ma:mu. ");
INSERT INTO beo_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Gobele salasu dunu da uda lasea, e da hina: da:i bidi lasu uda o uda amo da eno dunuma dawa:digi o uda amoda enoga lai fisiagai, agoai uda hame lamu. ");
INSERT INTO beo_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Gobele salasu dunu da ha:i manu gobele salasu liligi Nama iaha. Amaiba:le, dunu eno da gobele salasu dunu da hadigi hamoi dagoi dawa:mu da defea. Na da Hina Gode! Na da hadigidafa amola Na da Na fi dunu amo hadigi hamosa. ");
INSERT INTO beo_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Gobele salasu dunu ea idiwi da hina: da:i bidi lasea, e da ea ada gogosiama:ne ea hou wadela:lesiba:le, laluga gobelesili medole legema:mu. ");
INSERT INTO beo_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Ilia da gobele salasu Ouligisu dunu amo ea dialumaga ilegesu susuligi sogadigi dagoi amola gobele salasu abula gasisalima:ne ilegei dagoi. Amaiba:le, dunu da bogosea, e da ea dialuma hinabo mae fesega:ne, ea da:i dioi olelema:ne abula gadelamu, amo hou e da hame hamomu. ");
INSERT INTO beo_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","- ");
INSERT INTO beo_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","E da Na hadigi hou hamoma:ne, Nama ilegei dagoi. Amaiba:le, e da ledo gala hamoma:ne, hou huluane hame hamomu. Amola e da Na sema Abula Diasu amo ledo gala hamosa:besa:le, e da Na diasu fisili, diasu amo ganodini bogoi da dialebe amoga masunu da sema bagade. Ea ada o ame amola da bogosea, e da ilia dialebe diasu amoga hame masunu. ");
INSERT INTO beo_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","E da a:fini, dunu hame dawa:digi amo fawane lamu. ");
INSERT INTO beo_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","E da uda didalo o dunu enoga lai fisiagai uda o hina: da:i bidi lasu uda amo hame lamu. E da ea fidafa a:fini dunu hame dawa:digi amo fawane lama:mu. ");
INSERT INTO beo_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ea mano da hadigi hamoi dagoi ba:mu da defea. Be e da uda udigili lasea, ea mano da sema ganodini ledo gala hamoi dagoi ba:mu. Na da Hina Gode amola Na da Gobele Salasu Ouligisu dunu mogili gagale hadigi hamoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","17","Hina Gode da Mousesema, e da Elanema amane sia:ma:ne sia:i, “Digaga fi amo afae da ea da:i hodo liligi da wadela:i ba:sea, e da ha:i manu iasu Nama imunu da defea hame. Amo sema da wali amola eso huluane dialalalumu. ");
INSERT INTO beo_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Nowa da ea da:i hodo liligi afae da wadela:i ba:sea, e da ha:i manu gobele salasu Nama hame imunu. Si dofoi dunu amola emo gasuga:igi o da:i wadela:lesi amo huluane, ");
INSERT INTO beo_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","lobo o emo afoi dunu, ");
INSERT INTO beo_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","baligi fele heda:i o samoi dunu, si oloi o gadofo oloi o gulusu danai, ");
INSERT INTO beo_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Elane egaga fi amo ganodini da da:i wadela:i amo da ha:i manu gobele salasu Nama hame imunu. ");
INSERT INTO beo_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Agoai dunu da ha:i manu Nama iasu liligi amo manu da defea. E da hadigi ha:i manu iasu amola hadigidafa ha:i manu iasu amo manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Be ea da:i da fonobahadi wadela:iba:le, e da Sema Abula (amo da Hadigi Malei Sesei amola Hadigidafa Momei Sesei afafasa) amola oloda amo gadenene hame misunu. E da amo hadigi liligi ledo gala hamosa:besa:le, gadenene hame misunu. Bai Na da Hina Gode amola Na da amo liligi hadigima:ne hamosa.” ");
INSERT INTO beo_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Amo sia: huluane, Mousese da Elane, egefela amola Isala:ili dunu ilima olelei. ");
INSERT INTO beo_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","2","Hina Gode da Mousesema, e da Elane amola egefela elama amane sia:ma:ne sia:i, “Na Dio mae wadela:ma! Amaiba:le, sema iasu amo da Isala:ili dunu da Nama ima:ne ilegesa, amo nodone dawa:ma. Na da Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Diligaga fi dunu afae da ledo gala hamoi galea, amola e da sema iasu amo Isala:ili dunu da Nama ima:ne ilegei, amo gadenene masea, e bu oloda hawa: hamosu hamoma:ne hamedafa heda:mu. Amo sema da eso huluane dialumu. Na da Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","- ");
INSERT INTO beo_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Elane egaga fi dunu da gadofo olo bagade madelasea o ea da:i amoga guhi gadili ahoasea, e da sema iasu ha:i manu amo hame manu. E da ledo gala hamoiba:le, bu ledo hamedei ba:sea fawane bu manu. Gobele salasu dunu da ledo gala liligi (amo da bogoi da:i hodo gadenene dialu) amo digili ba:sea o ea da:iga ami gadili ahoasea, o e da ledo gala ohe o dunu digili ba:sea, e amola da ledo gala hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Gobele salasu dunu da agoai hamosea, e da ledo hamone, daeya doaga:sea fawane bu ledo hamedei ba:mu. Be amogala e da sema ha:i manu iasu manusa: dawa:sea, e da hidadea hano ulimu. ");
INSERT INTO beo_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Eso dasea, e da sema dodofei dagoi ba:mu. Amasea, e da sema ha:i manu iasu (amo da ea ha:i manu) amo manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","E da ohe amo da hisu bogoi o sigua amoga medole legei, amo ea hu hame manu - sema gala. Agoai hamoi ganiaba, e da ledo gala hamona:noba. Na da Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Gobele salasu dunu huluane da hamoma:ne sia:i Na iligili i, amo noga:le fa:no bobogema:ma. Agoane hame hamomu ganiaba, ilia da wadela:le hamoiba:le, bogola:loba. Bai ilia da Na hamoma:ne sia:i i, amo hame nabala:loba. Na da Hina Gode amola Na da ili hadigima:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Gobele salasu fi dunu fawane da sema ha:i manu iasu manu da defea. Eno dunu huluane (amola nowa da gobele salasu dunu ea diasu ganodini esala o ea hawa: hamosu dunu), ilia da hamedafa manu - sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Be gobele salasu dunu ea udigili hawa: hamosu dunu (ea muniga bidi lai o ea diasu ganodini lalelegei), ilia da ha:i manu gobele salasu dunuma i, amo manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Gobele salasu dunu ea idiwi amo da hame gobele salasu dunu amoma fisia, da sema ha:i manu iasu amo hame manu. ");
INSERT INTO beo_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Be gobele salasu dunu ea idiwi amo da didalo hamoi o dunuga fisiagai, amo da mano hame amola ea eda bu ouligima:ne ea diasuga bu masea, e da sema ha:i manu ea gobele salasu eda hi iabe amo manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Be dunu eno (amo da gobele salasu dunu ea sosogo fi dunu hame) amo da mae dawa:le, sema ha:i manu iasu mogili nasea, e da amo ea bidi lasu idi defele amola20% eno amo gobele salasu dunuma bu dabe imunu. ");
INSERT INTO beo_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","- ");
INSERT INTO beo_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Gobele salasu dunu da sema ha:i manu iasu amo ledo gala hamosa:besa:le, ilia da eno hame ilegei dunu amo moma:ne, logo hame doasima:mu. Bai amo hame ilegei dunu da wadela:i hou hamomu ganiaba, se iasu ba:mu ganuma:loba. Na da Hina Gode amola Na da gobele salasu iasu liligi hadigi hamoma:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","- ");
INSERT INTO beo_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Hina Gode da Mousesema e da Elane, egefela amola Isala:ili dunu huluane ilima hamoma:ne sia:i hagudu dedei ilima olelema:ne sia:i. “Isala:ili dunu o ga fi Isala:ili soge ganodini esala, amo da Wadela:i Hou Dabe Ima:ne Iasu gobele salasu iasea (e da amo ima:ne ilegei o Godema hahawaneba:le udigili iaha) e da ohe noga:idafa wadela:i hame gala fawane ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Ohe amo da gawali amola wadela:i hamedafa gala, amo fawane imunu. ");
INSERT INTO beo_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Be dilia da wadela:i gala ohe amo imunusa: dawa:sea, Hina Gode da amo iasu hame lamu. ");
INSERT INTO beo_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Nowa da Hahawane Gilisili Olofole Iasu Hina Godema imunusa: dawa:sea, (e da amo imunusa: ilegei o Godema hahawaneba:le, udigili iaha) amo ohe amola da wadela:i hame gala liligi fawane ima. ");
INSERT INTO beo_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ohe amo da si dofoi o emo gasuga:igi o fofa:gi o aiya o baho gala, agoai ohe Hina Godema mae ima. Amola agoai ohe amo ha:i manu iasu oloda da:iya mae gobesima. ");
INSERT INTO beo_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Dilia ohe amo da noga:le hame alei o fonobahadi wadela:i amo hahawane udigili iasu agoane imunu da defea, be gobele salasu ilegei agoane mae ima. ");
INSERT INTO beo_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Amola ohe amo ea gulusu da lologoi o fa:ginisi o fofonomai o danai, agoai ohe Hina Godema mae ima. Isala:ili soge ganodini, amo iasu hou da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Dilia ha:i manu iasu imunusa:, ohe amo dilia da ga fi amoga lai mae ima. Hina Gode da amo ohe da wadela:i ba:mu, amola e da amo hame lamu. ");
INSERT INTO beo_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","- ");
INSERT INTO beo_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Bulamagau mano o sibi mano o goudi mano da lalelegesea, e da ea ame amola gilisili eso fesuale esalumu. Amalalu, amo lale, ha:i manu gobele iasu hamoma:ne imunu da defea. ");
INSERT INTO beo_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Bulamagau amola ea mano o sibi amola ea mano o goudi amola ea mano amo eso afaega gilisili gobele salasu hamomusa: mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Hina Gode da dili hahawane gousa:ma:ne, dilia Ema nodomusa: gobele salasu iasea, sema hamoi amo noga:le fa:no bobogema. ");
INSERT INTO beo_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Amo ha:i manu iabe goe, eso amoga dilima i, amoga fawane moma. Golale hahabe manusa:, mae yolesima. ");
INSERT INTO beo_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Hina Gode da amane sia:i, “Na sema amo nabawane hamoma! Na da Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Na Hadigi Dio amo mae wadela:ma. Isala:ili dunu huluane da Na Hadigi amo sia:ma:mu. Na da Hina Gode amola Na da dilia hadigi hamoma:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Na da dilia Gode esaloma:ne, dili Idibidi sogega fisili masa:ne asunasi. Na da Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Isala:ili dunu ilima amane sia:ma, ‘Na, Hina Gode, da dilia lolo nasu ilegei dagoi. Ilia da amo sema gilisisu esoha Nama nodone sia:ne gadomusa: gilisima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Dilia eso gafeyale ganodini hawa: hamoma. Be eso fesu amo da Sa:bade eso. Amoga dilia helefima amola sema defele gilisima. Dilia hawa: mae hamoma. Dilia da habi esalea, amo da Hina Gode Ea Sa:bade eso dawa:ma. ");
INSERT INTO beo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Dilia amo hagudu dedei gilisisu da ilia eso ilegei, amo Isala:ili dunuma olelema. ");
INSERT INTO beo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Eso14 oubi age amoga, daeya, eso dasea, dilia Baligisu Lolo Nasu, Hina Godema nodomusa: hemoma. ");
INSERT INTO beo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Eso15amoga, yisidi hame sali Agi ga:gi Lolo Nasu da muni hemoma. Amo hamosea, dilia eso fesuale amoga, yisidi hame sali agi ga:gi fawane manu. ");
INSERT INTO beo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Eso age amo gilisisu ganodini, dilia da Godema nodone sia:ne gadomusa: gilisima. Dilia hawa: hamosudafa amo mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Eso fesuale amoga, dilia ha:i manu gobele salasu Hina Godema ima. Eso fesu da doaga:sea, dilia bu nodone sia:ne gadomusa: gilisima. Be dilia hawa: hamosudafa amo mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Dilia da soge amo Hina Gode da dilima iabe, amo ganodini masea, dilia gagoma faisia, bisili fai gagoma gilisi amo gobele salasu dunu ema gaguli masa. ");
INSERT INTO beo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Hina Gode da dili hahawane gousa:ma:ne, gobele salasu dunu da amo gagoma iasu gilisili dobole gagai Hina Godema imunu. Gobele salasu dunu da Sa:bade eso asili, eso fa:no mabe amoga gagoma gilisili dobole gagai Godema imunu. ");
INSERT INTO beo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Eso amoga dilia gala:ine gilisili dobole gagai iabe, amo esoga ode afaega lalelegei sibi mano gawali (ledo hamedei liligi) amo Wadela:i Hou Dabe Ima:ne Iasu gobele salasu hamoma. ");
INSERT INTO beo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Amo hamosea, dilia falaua gilougala:me aduna agoane amola olife susuligi gilisi amo ha:i manu iasu agoane ima. Amo iasu ea gabusiga: Hina Gode da hahawane naba. Amomawaini hano lida afae agoane gilisili ima. ");
INSERT INTO beo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Dilia gagoma gaheabolo (gahe o gobei o agi ga:gi) amo mae moma. Be hidadea amo Godema ianu, fa:no moma. Amo hamoma:ne sia:i dilia amola diligaga fi mae yolesili, eso huluane noga:le fa:no bobogema. ");
INSERT INTO beo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Dilia da Sa:bade eso amoga gagoma gilisili dobole gagai Hina Godema gaguli misi, amo fa:no, hialigi fesuale idima. ");
INSERT INTO beo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Eso 50 (amo eso da Sa:bade fesuale gala fa:no) amoga, Hina Godema eno gaheabolo gagoma gilisi amo ima. ");
INSERT INTO beo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Sosogo fi huluane da afae afae agi ga:gi aduna, Hina Godema baligisu iasu ima:ne gaguli misa:ne sia:ma. Agi ga:gi afae afae da falaua gilougala:me aduna agoane amola yisidi gilisi gobei. Amo da gagoma gaheabolo fai Hina Godema iasu liligi. ");
INSERT INTO beo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Agi ga:gi iasea, Isala:ili fi dunu da gilisili sibi amo da lalelegele, ode afae esalu mano fesuale gala amola bulamagau gawali afadafa amola goudi aduna (huluane da da:i noga:idafa) amo Hina Godema Wadela:i Hou Dabe Ima:ne Iasu gobele salasu hamoma:ne imunu. Ilia da Gala:ine Iasu amola Waini hano iasu amo gobele salasu amoga gilisimu. Amo gobele salasu ea gabusiga:, Hina Gode da hahawane naba. ");
INSERT INTO beo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Amola, dilia goudi gawali afae Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gobele salasu hamoma:ne ima. Amola gawali sibi mano aduna Hahawane Gilisili Olofole Iasu gobele salasu hamoma:ne, ima. ");
INSERT INTO beo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Gobele salasu dunu da agi ga:gi amola sibi mano aduna amo Hina Godema imunusa: olelema:mu. Amo da baligili iasu amola gobele salasu dunu da amo manu. Amo iasu liligi da hadigi. ");
INSERT INTO beo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Amo esoga dilia hawa: hamosudafa mae hamoma. Be Godema nodone sia:ne gadomusa: gilisima. Diligaga fi da eso huluane mae yolesili ilia habi esalea, amo hamoma:ne sia:i noga:le fa:no bobogema:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Dilia ifabi amoga ha:i manu faisia, gagoma amola gala:ine sogebi bega: galea, amo mae faima amola gagoma fonobahadi hame lai diala, amo lamusa: mae sinidigima. Hame gagui dunu amola ga fi dunu amo ea lama:ne yolesima. Hina Gode da dilia Godedafa. ");
INSERT INTO beo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Eso age amo oubi fesuga, helefisu hamoma. Dalabede dusia, dilia Godema nodone sia:ne gadomusa: gilisima. ");
INSERT INTO beo_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ha:i manu gobele salasu amo Hina Godema ima. Amola dilia hawa: hamosudafa mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","Eso nabu gala oubi fesuga, dilia dunu ilia wadela:i hou fadegama:ne Bu Gousa:su Eso gilisisu hamoma. Amo esoga ha:i maedafa moma. Hina Godema nodone sia:ne gadomusa: amola ha:i manu iasu Ema imunusa:, gilisima. ");
INSERT INTO beo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Amo esoga, dilia hawa: hamosu mae hamoma. Bai amo eso dilia da hou amo da wadela:i fadegamusa: hamosu gala. ");
INSERT INTO beo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Dunu afae da amo esoga ha:i nasea, e da Gode Ea fidafa amoga fadegai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Amola nowa da amo esoga hawa: hamosea, Hina Gode Hisu da amo dunu medole legemu. ");
INSERT INTO beo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Amo hamoma:ne sia:i da dili amola diligaga fi huluane ilia habi esalebe, amo ilia fa:no bobogema:ne hamoi. ");
INSERT INTO beo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Eso sesege amo oubi ganodini, eso dasea, amogainini eso nabu amoga eso dasea, dilia ha:i mae nawane helefima. ");
INSERT INTO beo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Sogega Fasela Diasu Lolo Nasu Gilisisu da eso15 oubi fesuga hemoma. Amola eso fesuale hamonanu dagoma. ");
INSERT INTO beo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Eso age amoga Hina Godema nodone sia:ne gadomusa: gilisima. Amo esoga, dilia hawa: hamosudafa mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Eso fesuale amoga eso afae afaega, dilia ha:i manu gobele salasu ima. Eso godo amoga dilia bu nodone sia:ne gadomusa: gilisima. Amola amo esoga dilia hawa: hamosu mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(Amo lolo Nasu gilisisu huluane da dilia Hina Gode Ea nodoma:ne gilisisu liligi. Amola amo ganodini dilia da Ema ha:i manu iasu, Wadela:i Hou Dabe Ima:ne Iasu, Gala:ine Iasu, gobele salasu eno amola waini hano iasu eso afae afaega sema defele hamosa. ");
INSERT INTO beo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Dilia Sa:bade eso hamoma:ne sia:i defele amola iasu hamoma:ne sia:i defele, ilegei iasu amola hahawane udigili asigili iasu eso huluane Hina Godema iabe. Be lolo Nasu gilisisu ganodini, iasu eno amo olelei amo ima:mu.) ");
INSERT INTO beo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Dilia da ifabi ha:i manu fai dagosea, Sogega Fasela Diasu Lolo Nasu Gilisisu eso fesuale ganodini hamoma. Eso15 oubi fesuga muni hemoma. Eso age amo lolo nasu ganodini da baligili helefisu hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Amo esoga, ifa fage noga:idafa dilia ifa amoga faima. Amola gumudi lubi amola lubi noga:i gala ifa amoda lale, dilia Hina Godema nodomusa: gilisisu hamoma. ");
INSERT INTO beo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Dilia eso fesuale amoga hahawane gilisima. Amo gilisisu, dili amola diligaga fi da mae yolesili, eso huluane hamonanoma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Isala:ili dunu huluane da eso fesuale amoga, sogega fasela diasu ganodini esalumu. ");
INSERT INTO beo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Bai diligaga fi ilia Hina Gode da Isala:ili dunu amo Idibidi sogega fisili masa:ne asunasia, ilia da soge diasu ganodini fawane esaloma:ne sia:i, amo diligaga fi dawa:ma:ne. E da dilia Hina Gode. ");
INSERT INTO beo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mousese da agoane Isala:ili dunu ilima hamoma:ne sia:i olelei. Ilia da Hina Gode Ea nodoma:ne amo Lolo Nasu Gilisisu huluane olelei. ");
INSERT INTO beo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Isala:ili dunu ilima amane sia:ma, ‘Gamali amo da Hina Gode Ea Abula Diasu ganodini da mae ha:ba:dole noga:le nenanoma:ne, olife susuligi noga:idafa gaguli misa. ");
INSERT INTO beo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Daeya huluane, Elane da gamali noga:le nenanoma:ne anegagini, e da hahabe fawane bu ha:ba:domu. Gamali da Hina Gode ba:ma:ne, abula Gode Ea Gousa:su Sema Gagili midadi gala, amo gadili nenanebe ba:mu. Amo hamoma:ne sia:i dilia eso huluane mae yolesili hamonanoma. ");
INSERT INTO beo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Elane da gamali amo da gamali bai gouliga hamoi dialebe, amo noga:le ouligima:mu. Ilia da mae ha:ba:dole, Hina Gode ba:ma:ne nenanoma:ne, Elane da noga:le ouligima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Dilia falaua gilougala:me12 agoane lale, amoga agi ga:gi gobema. ");
INSERT INTO beo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Agi ga:gi amo afafane, dadalesu aduna (dadalesu afae afae da agi ga:gi gafeyale gala ba:mu) fafai gouliga hamoi Hina Gode ba:ma:ne gala, amoga ligisima. ");
INSERT INTO beo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Agi ga:gi dadalesu afae afae amoga gabusiga: manoma legemu. Amo da Hina Gode agi ga:gi mae lale, gabusiga: manoma lama:ne, Ema ha:i manu iasu defele imunu. ");
INSERT INTO beo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Sa:bade eso huluane, mae yolesili, agi ga:gi amo Hina Gode ba:ma:ne agoane ligisima. Isala:ili dunu fi ilia da eso huluane mae yolesili amo hamoma:ne sia:i hamonanoma:mu. ");
INSERT INTO beo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Amo agi ga:gi da Elane amola egaga fi ilia ha:i nasu. Ilia da hadigi sogebi amo ganodini manu. Bai amo da ha:i manu mogili hadigi hamoi Hina Godema olema:ne, gobele salasu dunu moma:ne iasu. ");
INSERT INTO beo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Dunu afae esalu, amo ea eda da Idibidi dunu amola ea ame da Isala:ili uda (ea dio da Siloumidi amola ea ada da Dibili, Da:ne fi dunu). Amo dunu da abula diasu gilisisu ganodini, Isala:ili dunu ilima sia:ga gegei. Amo sia:ga gegesu ganodini, e da Godema gagabusu aligima:ne ilegei. Amaiba:le, ilia da amo dunu Mousesema oule asi. ");
INSERT INTO beo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ilia da sosodolasu dunu amo ouligima:ne sia:ne, Hina Gode Ea olelesu lama:ne ouesala. ");
INSERT INTO beo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Dilia amo dunu fisisu diasu gadili oule masa. Nowa huluane da amo dunu gagabusu aligima:ne ilegei nababeba:le, ea wadela:i hou olelema:ne, ilia lobo ea dialuma da:iya ligisima:ne sia:ma. Amasea, fi dunu huluane da e igiga medole legema:mu. ");
INSERT INTO beo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Amasea, Isala:ili dunu ilima olelema. Nowa da Godema gagabusu aligima:ne ilegesea da agoane se iasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","E da bogosu ba:mu. Nowa Isala:ili dunu o ga fi dunu Isala:ili soge ganodini esalebe, amo da Hina Godema gagabusu aligima:ne ilegesea, Isala:ili fi ilia da amo dunu igiga medole legei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Nowa da eno dunu ea hanaiga medole legesea, amo da medole legei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Amola nowa da inia ea ohe amo medole legesea, e da amo ohe defele ohe ea eda ema bu ima:ne sia:ma. Hou da esalusu afae lasea, esalusu amo defele dabe imunu gala. ");
INSERT INTO beo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Nowa dunu da eno dunuma se iasea, dilia da ea se i amo defele ema se ima. ");
INSERT INTO beo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","E da dunu eno ea gasa fisia, ea gasa defele gasa fima. E da dunu eno ea si afae wadela:sea, ea si afae amo dabe wadela:lesima. E da dunu eno ea bese gusia, ea bese amo dabele guma. E da dunu eno ema se iasu, amo defele ema se ima. ");
INSERT INTO beo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Nowa da ohe medole legesea, e da ohe eno ea medoi defele dabe ima:ne sia:ma. Be nowa da dunu medole legesea, dilia amo dabe medole legema. ");
INSERT INTO beo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Amo sema da dilia huluane, Isala:ili dunu amola ga fi dilia fi amo ganodini esala, amo Na da dili huluane noga:le hamoma:ne olelei dagoi. Bai, Na da dilia Hina Gode!” ");
INSERT INTO beo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Amo sia: Mousese da Isala:ili fi dunu ilima olelei. Amasea, ilia da amo dunu diasu gilisisu amoga gadili oule asili, igiga gala:le, medole legei dagoi. Isala:ili fi dunu da agoane Hina Gode Ea Mousesema hamoma:ne sia:i amo hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Hina Gode da Sainai Goumia, Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Isala:ili fi dunuma amane sia:ma, ‘Dilia soge amo Hina Gode da dilima iabe, amo ganodini golili dasea, dilia Hina Gode Ea nodoma:ne, ode fesuga osobo mae gidinama. ");
INSERT INTO beo_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Dilia ode gafeyale ganodini osoboga hawa: bugima, dilia waini sagai amoda damuni fasima, amola ha:i manu faima. ");
INSERT INTO beo_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Be ode fesuga, dilia soge hedofasima. Amo ode da Hina Gode Ea nodoma:ne ilegei dagoi. Dilia ifabia hawa: mae sagama amola dilia waini efe amoda mae damuni fasima. ");
INSERT INTO beo_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Gagoma da hisu heda:sea, amo mae faima. Amola dilia waini sagai (amoda hame damuni fasi) amoga waini fage mae faima. Bai amo ode da helefisudafa ode. ");
INSERT INTO beo_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","- ");
INSERT INTO beo_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Amo ode ganodini, osobo da hame dogoi ba:mu. Be dilia amola dilia udigili hawa: hamosu dunu amola bidi lamusa: hawa: hamosu dunu amola ga fi dunu dilima gilisili esala, amola dilia lai gebo amola sigua ohe amo da dilia sogega ha:i manu defele ba:mu. Ha:i manu liligi huluane dilia sogega heda:lebe, amo manu da defea. ");
INSERT INTO beo_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Dilia da ode fesuale amo idili, amo fesuale agoane asili, ode49 asi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Amo odega (ode50) eso nabu oubi fesuga, Bu Gousa:su Esoga, dunu amo da soge huluane ganodini ‘dalabede’ duma:ne asunasima. ");
INSERT INTO beo_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Dilia agoane hamosea, ode50amoga hahawane udigili ahoasu hou, sogega esalebe dunu huluane ilima ilegemu. Amo ode ganodini, soge huluane amo da eno dunuma bidi lai galea, amo soge ea musa: ada o egaga fi ilima bu ima:ne sia:ma. Amola nowa da udigili hawa: hamomusa: enoga bidi lai esalea, amo da ea fidafama buhagima:ne, logo doasima. ");
INSERT INTO beo_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Dilia amo ode ganodini, dilia sogega hawa: mae bugima, gagoma hisu heda:lebe, amo mae faima, amola dilia waini sagai (amoda hame damuni fasi) amoga fage mae faima. ");
INSERT INTO beo_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Amo ode huluane da sema hamoi dagoi ode. Ha:i manu da dilia sogega hisu heda:beba:le, amo fawane moma. ");
INSERT INTO beo_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Amo ode ganodini, soge huluane amo da eno dunuma bidi lai galea, ea musa: ada ema ima. ");
INSERT INTO beo_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Amaiba:le, dilia da dilia Isala:ili na:iyado ilima osobo bidi lasea, moloiwane hamoma. ");
INSERT INTO beo_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Bidi lasu defei amo da ode asili Bu Sagosu Ode amoga doaga:su idi amo defele ilegemu da defea. ");
INSERT INTO beo_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Bu Sagosu Ode doaga:ma:ne, ode bagohame gala ba:sea, bidi lasu defei da bagade hamoma. Be ode bagahame fawane gala ba:sea, bidi lasu defei da fonobahadi ba:mu. Bai ode amoga ha:i manu faimu gala, amo ea idi amoga dilia bidi laha. ");
INSERT INTO beo_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Dilia Isala:ili na:iyado dunu ilima mae ogogoma. Be dilia Hina Godema beda:ma!” ");
INSERT INTO beo_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Dilia soge amo ganodini gaga:iwane esaloma:ne, Hina Gode Ea hamoma:ne sia:i liligi amola sema huluane noga:le nabima. ");
INSERT INTO beo_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Dilia soge da ha:i manu noga:le legemu. Dilia hanai defele, dilia da ha:i manu lamu amola soge ganodini gaga:iwane esalumu. ");
INSERT INTO beo_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Be dunu afae da agoane adole ba:ma:bela:le, ‘Ninia da ode fesu amoga ha:i manu hame bugisia amola hame faisia, adi moma:bela:? ");
INSERT INTO beo_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","‘Na, Hina Gode, da ode gafe amoga dilia soge amo ganodini hahawane hamomuba:le, dilia sogega ha:i manu ode adunaga moma:ne defele da heda:mu. ");
INSERT INTO beo_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Dilia ode godo ganodini ha:i manu bu bugisia, dilia ha:i manu ode gafe ganodini fai, amo nanebe ba:mu. Amola amo ha:i manu da mae dagole, dilia da ode godo bugi liligi faili manu. ");
INSERT INTO beo_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Dilia soge da dilia sogedafa hame. Amaiba:le, eno dunu amoma bidi lamudafa da hamedei. Dilia soge da Gode Ea soge. Dilia da amo sogega ouligisu dunu fawane. ");
INSERT INTO beo_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Dilia da soge amo bidi lasea, musa: soge eda amo hi lamu defele gala. Amo noga:le dawa:ma! ");
INSERT INTO beo_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Isala:ili dunu da hame gaguiba:le, ili esaloma:ne ea soge bidi lamu amo fawane da logo galea, e gadenenedafa sosogo fi dunu fawane lamu da defea. ");
INSERT INTO beo_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Be dunu da gadenene sosogo fi dunu hame galea, e da fa:no muni eno lasea, hi bu lamu defele agoane ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Amai galea, e da ea musa: soge lai dunuma dabe amo ode da asili Bu Sagosu Ode amoga doaga:mu amo ea idi defele ima:ne sia:ma. Bai e da soge bu hame bidi lai ganiaba, e da Bu Sagosu Ode amoga udigili lala:loba. ");
INSERT INTO beo_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Be e da ea soge bu bidi lamu defele hame ba:sea, soge bidi lai dunu da amo soge gagulaligimu. Amola Bu Sagosu Ode amoga, e da udigili musa: gagui dunuma imunu. ");
INSERT INTO beo_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Dunu da diasu gagili sali moilai amo ganodini gala, amo bidi lasea, e da ode afae amoga bu bidi lamusa: dawa:sea, bu bidi lamu da defea. ");
INSERT INTO beo_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Be amo ode ganodini, e da ea diasu bu hame bidi lasea, amo diasu da gaheabolo gagui dunu amola egaga fi dunu ilia diasudafa ba:ma:mu. Musa: gagui dunu da Bu Sagosu Ode amoga, amo diasu bu hame samogemu. ");
INSERT INTO beo_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Be hou amo diasu hame gagili sali moilai ganodini dialebe da bugili nasu sogebi ea hou defele ba:mu. Musa: eda da bu bidi lamusa: dawa:sea, e da bu bidi lamu da defea, amola Bu Sagosu Ode amoga, gagui dunu da amo diasu ea musa: eda ema udigili bu imunu. ");
INSERT INTO beo_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Be Lifai dunu da moilai bai bagade ilima ilegei amo ganodini ilia soge o diasu enoga lai amo bu samogene bidi lamusa: dawa:sea, ilia bu bidi lamu da defea. ");
INSERT INTO beo_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Amo moilai ganodini, Lifai dunu da diasu bidi lasea amola bu samogene hame bidi lasea, amo diasu Bu Sagosu Ode ganodini, Lifai dunuma bu udigili ima:mu. Bai diasu amo da Lifai dunu ilia moilai ganodini gagubi amo da Lifai dunu ilia: fawane. ");
INSERT INTO beo_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Be ohe ha:i nasu soge, Lifai dunu ilia moilai sisiga:le diala, amo da hamedafa bidi lamu. Bai amo soge da Lifai dunu ilia eso huluane gaguma:ne dialumu. ");
INSERT INTO beo_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Dilia Isala:ili na:iyado dunu dili gadenene esala da hame gaguiwane hamosea amola ea labe lamu hamedei ba:sea, dilia bidi lamusa: hawa: hamosu dunu defele, e da dilima gadenene esaloma:ne, ema ima. ");
INSERT INTO beo_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Bidi bu ima:ne iabeba:le, amoga dabe eno mae lama. Be Gode Ea sia: nabima amola e da dilima bu gadenene esaloma:ne, logo doasima. ");
INSERT INTO beo_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Dilia ema bidi bu ima:ne iasea, amoga dabe eno mae lama amola ema ha:i manu bidi lasea, amo ha:i manu ea lasu ilegei defele fawane lama. ");
INSERT INTO beo_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Bai amo da dilia Hina Gode Ea hamoma:ne sia:i gala. Hina Gode da dilima Ga:ina:ne soge ima:ne, amola dilia Hina Gode esaloma:ne, dili Idibidi sogega fisili masa:ne asunasi dagoi. ");
INSERT INTO beo_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Dilia Isala:ili na:iyado dunu dilia fi amo ganodini esala da ea bidi fisili, hame gagui hamoiba:le, dilia udigili hawa: hamomusa:gini dilima ea da:i bidi lasea, ema udigili hawa: hamosu dunu defele hamoma:ne mae sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","E da dia bidiga hawa: hamosu dunu defele dia hawa: hamonanu, Bu Sagosu Ode amoga yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Amo odega, e amola ea mano da di yolesili, ea fidafa amola ea aowalali ilia soge amoga buhagima:ne yolesima. ");
INSERT INTO beo_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Isala:ili dunu ilia da Hina Gode Ea udigili hawa: hamosu dunu. E da ili Idibidi sogega guiguda: oule misi. Amaiba:le, Isala:ili fi dunu amo eno dunuma ea udigili hawa: hamomusa: bidi lamu da sema gala. ");
INSERT INTO beo_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ilima ougiliwane mae hamoma. Be Godema beda:ma. ");
INSERT INTO beo_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Dilia da udigili hawa: hamosu dunu lamu hanai galea, fifi asi gala dilima sisiga:le esala amoga bidi lama. ");
INSERT INTO beo_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Amola ga fi dunu dilima gilisili esalea, ilia mano amo dilia udigili hawa: hamomusa:gini lamu da defea. Amo mano dilia sogega lalelegei, amo dilia gagui liligi hamoma:ne lamu da defea. ");
INSERT INTO beo_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Amola dilia bogosea, dilia mano da amo udigili hawa: hamosu dunu lama:ne sia:ma. Be dilia Isala:ili na:iyado dunu ilima ougili mae hamoma. ");
INSERT INTO beo_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ga fi dunu dili amola gilisili esalebe da bagade gaguiwane ba:sea, amola dilia Isala:ili na:iyado dunu da hame gaguiba:le, ea da:i amo ga fi dunu o ea sosogo fi dunu ilima bidi lasea, ");
INSERT INTO beo_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","- ");
INSERT INTO beo_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","fa:no ea ola o eya ea adabi amola daiya o ea gawia o ea fidafa dunu da e bu bidi lamusa: dawa:sea, amo da e bu samogene lama:ne logo doasima:mu. O hi da bidi lale bu hi da:i bidi lamu da defea. ");
INSERT INTO beo_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","E da ga fi dunu ea da:i bidi lai, ema fada:i fofada:ma:mu. Amasea, ela da ode amoga ea bidi lai ode asili Bu Sagosu Ode amoga doaga:ma:ne idimu. Amola e bu yolesima:ne, dabe da bidiga hawa: hamosu dunuma iasu defele ilegemu. ");
INSERT INTO beo_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","53","Dunu da dunu fi enoga bidiga lai, be ea fi dunu ili da e bu bidiga lamu hanai. Amaiba:le, ilia da Bu Sagosu Ode doaga:ma:ne, ea hawa: hamosu esalumu ode fisiagai amo fawane idilalu, bidi imunu. Amo bidi defei da dunu ea odega hawa: hamosu bidi defele ba:mu, amola ea hina da ema ougiliwane hamomu da sema bagade. ");
INSERT INTO beo_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Be e da amo hou defele ea udigili hawa: hamosu hame yolesea, e da Bu Sagosu Ode amoga hahawane yolesima:ne logo doasima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Isala:ili dunu da eso huluane udigili hawa: hamosu dunu esalumu da hamedei. Bai ilia da Hina Gode Ea udigili hawa: hamosu dunu esala. E da ili Idibidi sogega fisili masa:ne guiguda: oule misi. E da ilia Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Hina Gode da amane sia:i, “Dilia nodone sia:ne gadomusa:, loboga hamoi liligi, igiga hamoi golasu ifa agoane liligi amola osole dedei igi, amo mae hamoma. Bai Na da dilia Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Nama nodomusa: lolo Nasu gilisisu huluane noga:le dawa:ma amola Nama nodone sia:ne gadosu sogebi amo nodoma. Na da Hina Gode! ");
INSERT INTO beo_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Dilia da Na hamoma:ne sia:i amola Na sema amoma noga:le fa:no bobogesea, ");
INSERT INTO beo_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Na da dilima eso defele gibu imunu. Amasea, dilia sogega dilia da ha:i manu heda:lebe ba:mu, amola dilia ifa amoga fage legei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Dilia ha:i manu faimu da bagadedafa ba:mu. Dilia da gagoma failalu, mae dagole waini fage faimu ba:mu. Amola dilia da waini fage failalu, bu gagoma hawa: bugima:ne eso da doaga:i dagoi ba:mu. Dilia da sadima:ne, ha:i manu bagade ba:mu amola dilia soge ganodini gaga:iwane esalumu. ");
INSERT INTO beo_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Na da dilia soge ganodini dilima olofosu imunu. Amola dilia da enoba:le mae beda:iwane hahawane golamu. Na da gasonasu sigua ohe dilia soge ganodini mae misa:ne sefasimu, amola dilia da gegesu bu hame ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Dilia da dilia ha lai hasalimu. ");
INSERT INTO beo_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Dilia dunu biyale gala da ha lai dunu100 amo hasalimu. Amola dilia dunu100 da ha lai dunu10,000 hasalimu. ");
INSERT INTO beo_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Na da dilima hahawane hamomu amola mano bagohame dilima imunu. Na da Na gousa:su dilima hamoi amo noga:le ouligimu. ");
INSERT INTO beo_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Dilia da ha:i manu bagadedafa faimuba:le, dilia ha:i manu ode afaega defele ba:mu. Amasea, musa: fai ha:i manu da dialebeba:le, dilia da gaheabolo ha:i manu faisia, diasu ganodini legemusa:, musa: ha:i manu fai bagade dialebeba:le da ha:digimu agoai ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Na da Na sema Abula Diasu ganodini, dilia fi dogoa esalumu. Amola Na da dili hame yolesimu. ");
INSERT INTO beo_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Na amola da dili gilisili esalumu. Na da dilia Gode esalumu amola dilia da Na fidafa dunu esalumu. ");
INSERT INTO beo_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Na, dilia Hina Gode, da dilia udigili hawa: hamosu dunu bu mae esaloma:ne, dili Idibidi sogega fisili masa:ne asunasi. Gasa bagade dunu da dili banenesi galu. Be dilia hahawane, dialuma mae fili sa:ili, gadili laloma:ne, Na da amo ilia gasa gugunufinisi dagoi.” ");
INSERT INTO beo_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Hina Gode da amane sia:i, “Dilia da Na hamoma:ne sia:i hame nabasea, dilia da Na se iasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Dilia da higa:iba:le, Na hamoma:ne sia:i amola Na sema amoma hame fa:no bobogesea, amola gousa:su Na dilima hamoi amo wadela:sea, ");
INSERT INTO beo_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Na da dilima se imunu. Na da gugunufinisisu liligi dilima iasimu. olo bagade amola asugi amo da dilia si wadela:mu amola dili da bogosu dilima madelai ba:mu. Dilia da ha:i manu hawa: bugimu be udigili bugimu. Bai dilia ha lai dunu da dilima hasalasili, dilia ha:i manu bugi huluane manu. ");
INSERT INTO beo_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Na da sinidigili dilima ha lai hamomu. Amaiba:le, dilia da enoga hasalasi dagoi ba:mu amola dilima higa:i dunu da dili ouligimu. Dilia da bagade beda:iba:le, dunu eno da dili hame sefasibi amomane dilia da udigili hobea:le masunu. ");
INSERT INTO beo_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Be amo se iasu ba:sea, dilia da Nama hame sinidigili nabasu hou hame hamosea, Na da fesuale agoane baligili dilima se imunu. ");
INSERT INTO beo_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Na da dilia gasa fi hidasu hou amo gugunufinisisimu. Gibu da hame sa:imu amola dilia osobo da ga:nasi gula agoane hamomu. ");
INSERT INTO beo_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Dilia gasa bagade hawa: hamosu da dilia hou hame fidimu. Bai dilia soge da ha:i manu hame legemu amola dilia ifa da fage hame legemu. ");
INSERT INTO beo_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Amola dilia bu hame nabasu hou hamonanebe ba:sea, Na da bu dilia se iasu fesuale eno agoane imunu. ");
INSERT INTO beo_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Na da medosu sigua ohe dilima asunasimu. Ilia da dilia mano medole legemu amola dilia lai gebo gugunufinisimu. Amola dilia bogogia:mubale, dunu bagahame fawane esalebe ba:mu. Logo huluane da dunu hame ahoanebeba:le, yaloi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Be dilia amo se iasu lai dagosea, bu Na hamoma:ne sia:i bu hame nabasea, ");
INSERT INTO beo_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Na da sinidigili, se iasu fesuale eno agoane baligili dilima imunu. ");
INSERT INTO beo_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Dilia da Na gousa:su wadela:lesiba:le, Na da dilima gegesu iasimu. Amola dilia moilai amo ganodini gagili salimusa: agoane gilisisia, Na da olo amo uhinisimu hamedei dilima imunu. Amasea, bu gegemu gogoleba:le, dilia da dilia ha lai ilima dili gagulaligima:ne amola fama:ne olemu. ");
INSERT INTO beo_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Na da dilia ha:i manu logo hedofamu. Amasea, uda nabuane gala da ilia agi ga:gi hamoma:ne, gobele nasu afae fawane defele ba:mu. Ilia fonobahadi fifili dilima imunu. Amola dilia huluane na dagosea, bu ha:i bagade ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Amalalu, dilia Nama halale Na hamoma:ne sia:i hame nabasea, ");
INSERT INTO beo_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Na da ougili dilima gegene, se iasu fesuale eno baligili dilima imunu. ");
INSERT INTO beo_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Dilia ha:i bagade nababeba:le, dilia manodafa amo hei manusa: dawa:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Dilia nodone sia:ne gadosu sogebi agologa diala amo Na da gugunufinisimu. Na da dilia gabusiga: manoma oloda amo mugulumu amola dilia bogoi da:i hodo amo dilia loboga hamoi ogogosu ‘gode’ dafai amo da:iya ha:digimu. ");
INSERT INTO beo_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Na da dilima bagade higale, dilia moilai gugunufinisimu. Na da dilia nodone sia:ne gadosu sogebi gugunufinisimu amola dilia gobele salasu liligi hame lamu. ");
INSERT INTO beo_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Na da dilia soge dafawanedafa gugunufinisimu. Amaiba:le, dilia ha lai da dilia soge gesowai, amo ba:sea, bagadewane fofogadigimu. ");
INSERT INTO beo_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Na da gegesu dilima iasimu amola ga fifi asi gala ilia sogega dili afagogomu. Dilia soge da dunu hame esalebe ba:mu amola dilia moilai huluane mugululi gugunufinisi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","- ");
INSERT INTO beo_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Amasea, Isala:ili soge da ode bagohame helefisu ba:mu (amo helefisu dilia da dilia sogega hame iasu). Soge da ouligisu dunu hamedene udigili dialumu. Dilia da mugululi asili, dilia ha lai dunu ilia soge ganodini esalea, soge da damunisi dialumu. ");
INSERT INTO beo_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Na da hamobeba:le, dilia mugululi asi dunu da bagadewane beda:mu. Amasea, dilia da ifa lubi foga ahoa fane gulibagebe nabasea, hobea:mu. Dilia ha lai da gegesu ganodini dili sefasibi amo defele hobea:mu, amola ha lai da dilima gadenei ba:sea, dilia da udigili dafamu. ");
INSERT INTO beo_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ha lai da dili hame sefasisia, dilia da eno enoma legagala:le dafamu. Amola dilia ha lai ilima dabe gegemu hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Dilia da mugululi asili, dilia ha lai ilia soge ganodini bogomu. Fedege agoane, dilia ha lai ilia sogega na dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Dilia dunu afae afae dilia ha lai ilia soge ganodini hame bogoi esalebe, da da:i dione geloga:gia:mu. Bai dilia amola dilia aowalali da wadela:i hou hamosu. ");
INSERT INTO beo_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","- ");
INSERT INTO beo_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Be diligaga fi ilia amola ilia aowalali (amo da Nama ha lai amola lelebeba:le, Na da ilima ha lale, ilia ha lai dunu sogega esaloma:ne, mugululi masa:ne sia:i) ilia wadela:i hou fofada:mu. Hobea, diligaga fi da ilia hou fonobosea, amola ilia wadela:i hou amola odoga:su hou amo ea dabe huluane ilia da hamoi dagosea, ilia da fofada:mu. ");
INSERT INTO beo_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Amasea, Na da Na gousa:su Na da Ya:igobe, Aisage amola A:ibalaha:me ilima hamoi, amo Na da bu dawa:mu. Na da Na fidafa ilima Isala:ili soge imunu ilegei, Na da bu gaheabolo ilegemu. ");
INSERT INTO beo_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Be hidadea, amo soge da hahawane damunisili, dunu hamedafa amo ganodini esalebe ba:mu. Amola Na fi dunu da Na hamoma:ne sia:i amola Na sema higale yolesiba:le, ilia amo dabe huluanedafa hamomu. ");
INSERT INTO beo_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Be amo eso amolawane, ilia da ilia ha lai soge ganodini esalea, Na da Na fi dafawanedafa hame yolesimu amola dafawanedafa hame gugunufinisimu. Amai hamoi ganiaba, Na gousa:su da ilima dagolesila:loba. Be Na da ilia Hina Godedafa. ");
INSERT INTO beo_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Na da musa: Na fi amo Idibidi sogega fisili masa:ne asunasiba:le, Na da fifi asi gala huluane ilima Na gasa olelei. Amoha, Na da ilia aowalali ilima gousa:su hamoi. Amo gousa:su Na da bu gaheabolo ilegemu. Bai Na, Hina Gode, da ilia Godedafa esaloma:ne.” ");
INSERT INTO beo_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Amo dedei da sema amola Gode Ea hamoma:ne sia:i, amo Hina Gode da Sainai Goumia, Mousesema olelei, amo e da bu Isala:ili dunuma alofele ima:ne. ");
INSERT INTO beo_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Hina Gode da Mousesema amane hamoma:ne sia:i, ");
INSERT INTO beo_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Isala:ili dunu ilima amane sia:ma,” Nowa da Godema imunusa:, dunu ilegesea, e da amo dunu bu samogene lamu da defea. Be e da amo dunu ea dabe defele imunu. ");
INSERT INTO beo_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","Dabe lamu defei da hagudu dedei, asigilai dunu amo da ode20 asili ode60 doaga:i, ea dabe lamu defei da silifa fage50agoane asigilai uda ea dabe lamu defei da silifa fage30 agoane goi amo da ode5 asili20 doaga:i, ea dabe lamu defei da silifa fage20agoane uda mano ea dabe lamu defei da silifa fage10 agoane dunu mano dudubu (ode oasili5) ea dabe lamu defei da silifa fage5agoane uda mano dudubu ea dabe lamu defei da silifa fage3 agoane asigilai dunu amo da ode60 baligi, ea dabe lamu defei da silifa fage15agoane asigilai uda amo daode60baligi amo ea dabe lamu defei da silifa fage10agoane. ");
INSERT INTO beo_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Be dunu da eno dunu ilegei amola hame gaguiba:le, bu defei amo defele lamu hamedei ba:sea, e da ea ilegei dunu o uda, gobele salasu dunu ema oule masa:ne sia:ma. Amasea, gobele salasu dunu da ilegei hamoi dunu ea gagui defele, dabe lamu defei haguduga ilegemu. ");
INSERT INTO beo_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","- ");
INSERT INTO beo_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Be dunu da Hina Godema imunusa:, ohe noga:i ilegesea, e da amo ohe afadenene eno ohe imunu da hamedei. Bai Hina Godema ilegei iasu da sema gala. E da ohe afadenene, eno imunusa: dawa:sea, amo ohe aduna da Hina Gode Ea:. ");
INSERT INTO beo_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Be ilegei liligi amo da ledo galebe ohe (Hina Gode da agoai liligi hame laha) amo galea, dunu da amo ohe gobele salasu dunuma gaguli masunu. ");
INSERT INTO beo_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Gobele salasu dunu da amo ohe ea hou defele lamu defei ilegemu. Amo lamu defei afadenemu da hamedei galebe. ");
INSERT INTO beo_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Iasu dunu da amo ohe bu bidi lamusa: dawa:sea, e da bidi lamu defei amola20% eno amola bidi lamusa: imunu. ");
INSERT INTO beo_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Nowa dunu da ea diasu Hina Godema imunusa: ilegesea, gobele salasu dunu da amo diasu ea hou defele, bidi lamu defele ilegemu. Amo bidi lamu defei afadenemu da hamedei. ");
INSERT INTO beo_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Be dunu amo diasu imunusa: ilegei da amo diasu bu bidi lamusa: dawa:sea, e da diasu ea bidi lamu defei amola20% eno amola amoga bu bidi lamu. ");
INSERT INTO beo_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Dunu da Hina Godema imunusa: ea soge ilegesea, amo ea bidi lamu defei da fage hawa: amo sogea bugima:ne ea defei agoane ba:mu. Idi da bali hawa:20gilougala:me afae afae da silifa fage nabuane amoga lamu. ");
INSERT INTO beo_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Be Bu Sagosu Ode doaga:sea, amolalu e da hedolo Hina Godema imunusa: ilegesea, amo ea bu lamusa: defei da huluanedafa. ");
INSERT INTO beo_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Be e da fa:nowane ilegesea, gobele salasu dunu da ode asili, Bu Sagosu Ode doaga:mu, amo ode idilalu ea bu bidi lamu defei ilegemu. ");
INSERT INTO beo_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Dunu amo da musa: amo soge Hina Godema ilegei, e da bu bidi lamusa: dawa:sea, e da amo ea bidi lamu defei amola eno20% amoga bu bidi lamu. ");
INSERT INTO beo_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Be amo dunu da amo soge Hina Godema bu mae bidi lale, eno dunuma bidi lasea, e da amo soge bu hamedafa bidi lamu - sema gala. ");
INSERT INTO beo_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Bu Sagosu Ode eno doaga:sea, amo soge da Hina Gode Ea: liligi, eso huluane enoga mae bidi lama:ne, hamoi dagoi ba:mu. Gobele salasu dunu ilia da amo soge gagumu. ");
INSERT INTO beo_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Dunu da soge bidi lale, Hina Godema amo soge imunusa: ilegesea, ");
INSERT INTO beo_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","gobele salasu dunu da ode asili Bu Sagosu Ode amoga doaga:mu, amo ode idilalu, amo soge bidi lamu defei ilegemu. Amasea, amo dunu da defei amo defele amo esodafaga hedolo imunu. Bidi i amo da Hina Gode Ea:. ");
INSERT INTO beo_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Bu Sagosu Ode amoga, soge da ea musa: eda o egaga fi ilima bu sinidigili ima:mu. ");
INSERT INTO beo_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Bidi lamu defei da Isala:ili fi bidi lasu sema ilegei defele hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Isala:ili sema amo ganodini, magobo lalelegei huluane da Hina Gode Ea:. Amaiba:le, dilia da magobo amo hahawane udigili iasu hamomu da hamedei. Bai amo da Hina Gode Ea: liligi. Bulamagau mano o sibi mano o goudi mano da Hina Gode Ea:. ");
INSERT INTO beo_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Be ledo gala ohe amo da ilegei hame ohe ea bidi lasu defei defele amola eno20% amola amoga bu bidi lamu da defea. Be ea eda da bu hame bidi lasea, gobele salasu dunu da eno dunuma ea lamu defei ilegei amoga bidi lamu da defea. ");
INSERT INTO beo_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Be liligi o dunu o ohe o soge da bu hame lamusa: Hina Godema ilegesea, amo bu samogemu da hamedei. Bai amo liligi da eso huluane Hina Gode Ea:. ");
INSERT INTO beo_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Dunu amola da medole legemusa: Hina Godema ilegei, amo bu lamu da hamedei. Amo da medole legemu fawane. ");
INSERT INTO beo_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Sogega heda:i ha:i manu huluane, (gala:ine amola ifa fage) amo nabuane momogili, afae da Hina Gode Ea:. ");
INSERT INTO beo_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Nowa da Hina Gode Ea liligi bu lamusa: dawa:sea, e da amo ea bidi lamu defei defele amola eno20% amoga bu lamu. ");
INSERT INTO beo_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Lai gebo ilia idi nabuane ganodini, afae da Hina Gode Ea:. ");
INSERT INTO beo_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Amo ohe ea eda da amo nabuane idi amo ganodini, wadela:i ohe fawane Hina Godema imunu da sema bagade. Amola ohe noga:i amo da Hina Godema ilegei, amo afadenene eno imunu da sema bagade. Amai hamosea., amo ohe aduna da Hina Gode Ea: ba:mu, amola ela bu bidi lamu da hamedei. ");
INSERT INTO beo_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Hina Gode da amo hamoma:ne sia:i huluane Sainai Goumia Mousesema i. E da Isala:ili fi dunu ilima alofele ima:ne, Mousesema sia:si. Sia: Ama Dagoi ");
INSERT INTO beo_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Eso age amola oubi ageyadu amoga Isala:ili dunu ilia da Idibidi yolesi ode ageyadu ganodini, Hina Gode da Ea Abula Diasu, Sainai hafoga:i soge ganodini diala, amo ganodini Mousesema sia:i. ");
INSERT INTO beo_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","E da amane sia:i, “Di amola Elane amo Isala:ili dunu ilia sosogo fi amola fidafa amoga idisu hamoma. Dunu huluane amo da ode 20 lalelegele esalu, amola ode 20 baligi, amola ilia da dadi gagui hawa: hamomusa: defele esala, amo huluane ilia dio dedema. ");
INSERT INTO beo_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Fi huluane afae afae ilia bisilua ali fidima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Fi amoga bisilua, amo hawa: hamomusa: ilia fi dunu amoga ilegei, ilia dio da haguduga dedei diala; Fi ...Fi Bisilua Liubene...Elaise (Siedia egefe) Simiane... Sieliumiele (Siulisia:dai egefe) Yuda...Na:iasione (Aminada:be egefe) Isaga...Nida:niele (Sua egefe) Sebiulane...Ilaia:be (Hilone egefe) Ifala:ime...Ilisiama (Amihade egefe) Ma:na:se...Ga:maliele (Bedase egefe) Bediamini...Abaida:ne (Gidioni egefe) Da:ne...Ahaise (Amisia:da:ia; egefe) A:sie...Ba:igiele (Ogela:ne egefe) Ga:de...Ilaiasa:fe (Diuele egefe) Na:fadalai...Ahaila (Ina:ne egefe) ");
INSERT INTO beo_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Amo dunu fagoyale gala, ilia da Mousese amola Elane fidi. Ilia, da ");
INSERT INTO beo_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","eso age amola oubi ageyadu amoga Isala:ili fi huluane gilisimusa: wele sia:i. Amalalu, ilia da ilia fi amola sosogo fi huluane afafane, ilia dio huluane dedei. Dunu amo da ode 20 lalelegele esalu amola amo baligi ilia da ilia dio dedene idi. ");
INSERT INTO beo_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Hina Gode Ea sia:i defele, ilia da hamoi dagoi. Mousese da amo dunu idisu, Sainai hafoga:i soge ganodini hamoi. ");
INSERT INTO beo_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Dunu amo da ode 20 lalelegele esalu, amola amo baligi, amo da dadi gagumu defele ba:loba, amo huluane ilia fi amola sosogo fi defele dedei dagoi ba:i. Ilia da Liubene (Ya:igobe ea mano magobo) hidadea dedei. Idi huluane da agoane:- Fi ...Idisu Liubene ...46,500 Simiane ...59,300 Ga:de ...45,650 Yuda ...74,600 Isaga ...54,400 Sebiulane ...57,400 Ifala:ime ...40,500 Ma:na:se ...32,200 Bediamini ...35,400 Da:ne ...62,700 A:sie ...41,500 Na:fadalai ...53,400 Huluane gilisi idi da ...603,550 ");
INSERT INTO beo_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lifai fi da eno dunu fi ilima gilisili hame dedei. ");
INSERT INTO beo_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Bai Hina Gode da Mousesema amane sia:i dagoi, ");
INSERT INTO beo_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Di da dunu amo da dadi gagumu defele gala dedesea, Lifai fi dunu mae dedema. ");
INSERT INTO beo_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Be Lifai fi dunu amo ilia Na abula diasu amola hawa: hamosu liligi ganodini sali amo huluane ouligima:ne sia:ma. Ilia da Na abula diasu amola liligi huluane gaguli masunu. Ilia da amo abula diasu ganodini hawa: hamomu amola ilia fisu diasu amoga sisiga:le gagumu. ");
INSERT INTO beo_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Dilia fisisu mugululi masusa: dawa:sea, Lifai dunu da amo mugululi, gaguli ahoasea, gaheabolo sogebi amoga bu gagumu. Be eno dunu da abula diasuga gadenenewane doaga:sea, amo dunu medole legema. ");
INSERT INTO beo_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Be Isala:ili fi dunu huluane da fisisu higagale gaguli gagamu. Ilia da fi afae afae amanewane ilia abula diasu ilisu eso gosa:gisu abula haguduga gagumu. ");
INSERT INTO beo_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Be Lifai fi da Na Abula Diasu noga:le ouligima:ne, amogai sisiga:le fimu. Eno dunu da gadenene masea, Na ougi da Isala:ili fi fasa:besa:le, agoane noga:le ouligima.” ");
INSERT INTO beo_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Amaiba:le, Isala:ili dunu da Hina Gode Ea Mousesema hamoma:ne sia:i huluane defele hamoi. ");
INSERT INTO beo_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Hina Gode da Mousese amola Elane elama amane hamoma:ne sia:i, ");
INSERT INTO beo_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Isala:ili dunu da ilia abula diasu gilisisu hamosea, dunu huluane da ea fi gosa:gisu amo haguduga gaguli fima:mu. Ilia abula diasu huluane amo Na Abula Diasu sisiga:le gaguma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","Eso maba gusudili la:idi amoga Yuda fi ilia eso gosa:gisu hagudu, fi haguduga dedei ilia amola ilia ouligisu dunu da fima:mu. Fi Ouligisu Dunu Idisu Yuda Na:iasione (Aminada:be egefe) 74,600 Isaga Nida:niele (Sua egefe) 54,400 Sebiulane Ilaia:be (Hilone egefe) 57,400 Huluane da 186,400 Isala:ili dunu da mogodigili ahoasea, Yuda fi da bisili mogodigima:mu. ");
INSERT INTO beo_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","Ga (south) la:idi amoga Liubene fi dunu da fi afae afae ilia amola ilia ouligisu dunu ilia eso gosa:gisu haguduga fima:mu, agoane, Fi Ouligisu Dunu Idisu Liubene Elaise (Siedia egefe) 46,500 Simiane Sieliumiele (Siulisia:dai egefe) 59,300 Ga:de Ilaiasa:fe (Diuele egefe) 45,650 Huluane da 151,450 Liubene ea fi da No 2, Yuda bagia, mogodigili masunu. ");
INSERT INTO beo_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Yuda amola Liubene ilima gilisili fi da bisili mogodigili masunu. Fa:nodafa, fi amo da Ifala:ime amola Ga:de gilisi da mogodigimu. Dogoa, Lifai fi dunu da Na Abula Diasu gaguli mogodigimu. ");
INSERT INTO beo_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Eso dabe guma:dini la:idi, Ifala:ime fi dunu amola ilia ouligisu dunu da ilia gilisi mogi amo ganodini agoane fima:mu. Fi Ouligisu Dunu Idisu Ifala:ime Ilisiama (Amihade egefe) 40,500 Ma:na:se Ga:maliele (Bedase egefe) 32,200 Bediamini Abaida:ne (Gidioni egefe) 35,400 Huluane da 108,100 Ifala:ime fi da No 3 agoane, Lifai dunu ili baligia mogodigima:mu. ");
INSERT INTO beo_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Ga (north) la:idi amoga, Da:ne fi dunu amola ilia ouligisu dunu da ilia gilisisu mogi amo ganodini agoane fima:mu. Fi Ouligisu Dunu Idisu Da:ne Ahaise (Amisia:da:iai egefe) 62,700 A:sie Ba:igiele (Ogela:ne egefe) 41,500 Na:fadalai Ahaila (Ina:ne egefe) 53,400 Huluane da 157,600 Da:ne ea fi gilisisu da fa:nodafa mogodigima:mu. ");
INSERT INTO beo_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Isala:ili dunu huluane amo da ilia fi afae afae amo ganodini gilisili dedei, ilia idi da 603,550 ba:i. ");
INSERT INTO beo_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Be Hina Gode da Mousesema hamoma:ne sia:i defele, ilia da Isala:ili dunu idisia, Lifai dunu gilisili hame idili dedei. ");
INSERT INTO beo_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Amaiba:le, Isala:ili dunu da Hina Gode Ea Mousesema hamoma:ne sia:i liligi huluane hamoi. Ilia da fisia, ilia eso gosa:gisu hagudu fi. Amola ilia da mogodigisia, dunu huluane da hi fi amo gilisili mogodigisu ");
INSERT INTO beo_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hina Gode da Sainai Goumia Elane amola Mousesema sia:i. Amo esoga, ela sosogo fi da agoane galu. ");
INSERT INTO beo_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Elane egefelali da biyaduyale galu. Ilia dio, magobo Na:ida:be. Amo baligia da Abaihiu, Elia:isa amola ufidafa da Idama. ");
INSERT INTO beo_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ilia huluane da gobele salasu dunu hamoma:ne susuligi legele, momogili gagai dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Be Na:ida:be amola Abaihiu da sia: mae nabane, hame hadigi lalu amo Sainai hafoga:i sogega Hina Godema imunusa: dawa:beba:le, Hina Gode da ela medole legei. Ela da mano hame. Amaiba:le, Elane da esalea, Elia:isa amola Idama da eda Elane esalebeba:le, gobele salasu dunu hawa: hamonanu. ");
INSERT INTO beo_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Lifai fi dunu oule misini, ilia da gobele salasu dunu Elane amo ea hawa: hamoma:ne, Lifai dunu momogili gagama. ");
INSERT INTO beo_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ilia da Na Abula Diasu ouligima:ne hawa: hamomu amola gobele salasu dunu amola fi dunu huluane fidima:ne, ilelegema. ");
INSERT INTO beo_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ilia da liligi huluane Na Abula Diasu ganodini sali amo huluane ouligimu. Amola Isala:ili dunu huluane fidima:ne, hawa: hamomu. ");
INSERT INTO beo_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ilia da eno hawa: hamosu hame hamomu. Ilia da Elane amola ea mano fawane fidimu. ");
INSERT INTO beo_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Be dia Elane amola ea mano amo elea gobele salasu hawa: hamosu fawane hamoma:ne ilegema. Be nowa dunu eno da ilia hawa: hamosu amo udigili hamomusa: dawa:sea, amo medole legema! ");
INSERT INTO beo_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Na da wali Lifai fi amo Na dunu fi ilegei dagoi. Na da Idibidi dunu ilia mano magobo huluane medole legeiba:le, Na da Isala:ili mano magobo huluanedafa amola ohe fi mano magobo huluane, amo Na hawa: hamomusa:gini ilegele momogili gagai dagoi. Be Isala:ili magobo huluane mae lale, Na da wali Lifai fi dunu huluane lalegagumu. Ilia da Na fi dunu esalumu. Bai Na da Hina Gode. ");
INSERT INTO beo_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","15","Sainai hafoga:i soge ganodini, Hina Gode da Mousese amola Lifai dunu huluane, dunu mano amo da oubi afae lalelegele esala, amola dunu eno huluane, ilia fi amola sosogo fi defele, idili, dedema:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mousese da Hina Gode Ea hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","20","Lifai da dunu mano udiana galu. Ilia dio da Gesione, Gouha:de amola Milalai. Ilia da amo dio udiana ilia fi udiana ilima asuli. Gesione da dunu mano aduna galu. Elea dio da Libini amola Simiai. Gouha:de da dunu mano biyaduyale galu. Ilia dio da A:mala:me, Isiha, Hibalone amola Asaiele. Milalai da dunu mano aduna galu. Elea dio da Malai amola Musiai. Iligaga fi da amo dunu ilia dio lai dagoi. ");
INSERT INTO beo_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Libini amola Simiai elea sosogo fi da Gesione fi hamoi galu. ");
INSERT INTO beo_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Amo fi dunu huluane amo da lalelegele, oubi afae baligi, ilia idi da 7,500! ");
INSERT INTO beo_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Amo fi ilia fisisu sogebi da Hina Gode Ea Abula Diasu amoga guma:dini ilegei galu. ");
INSERT INTO beo_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ilia ouligisudafa da Ilaiasa:fe (La:iele egefe) galu. ");
INSERT INTO beo_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","26","Ilia da Hina Gode Ea Abula Diasu liligi huluane ouligima:ne ilegei. Amo da ea ganodini dedebosu, ea gadili dedebosu abula amo ea logo holei dedebosu, gagoi amo Abula Diasu amola oloda sisiga:su amo ea abula liligi, amola gagoi logo holei amo ea abula dedebosu. Ilia da amo liligi hahamoma:ne, ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","A:mala:me, Isiha, Hibalone amola Asaiele, amo ilia sosogo fi da Gouha:de fi hamoi. ");
INSERT INTO beo_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Amo fi ilia dunu mano huluane lalelegele, oubi afae baligi, ilia idi da 8,600. ");
INSERT INTO beo_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Amo fi ilia fisisu sogebi da Hina Gode Ea Abula Diasu gadili (south) ilegei dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ilia ouligisudafa da Elisa:ifa:ne (Asaiele egefe) galu. ");
INSERT INTO beo_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ilia da Gode Ea Gousa:su Sema Gagili, fafai, gamali bai, oloda huluane, hawa: hamosu liligi amo gobele salasu dunu da Hadigi Malei Sesei amoga hamosu amola Hadigidafa Momei Sesei logo holei ea abula, amo huluane noga:le ouligima:ne ilegei. ");
INSERT INTO beo_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lifai fi dunu ilia bisilua da Elia:isa (Gobele salasu dunu Elane ea mano). E da dunu huluane amo da Hadigi Malei Sesei hawa: hamosu hamoma:ne ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Malai amola Musiai ela sosogo fi da Milalai fi hamoi galu. ");
INSERT INTO beo_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Amo fi dunu huluane lalelegele, oubi afae baligili, ilia idi da 6,200. ");
INSERT INTO beo_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Amo fi ilia fisisu sogebi da Hina Gode Ea Abula diasuga ga (north) agoane, ilegei dagoi ba:i. Ilia ouligisudafa da Siuliele (A:biha:ile egefe) galu. ");
INSERT INTO beo_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Mousese da amo fi dunu ilia Abula Diasu amo gagui liligi, golasu ifa, fa:i liligi amola disisili hahamomusa: liligi huluane amo ouligima:ne ilegei. ");
INSERT INTO beo_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Amola ilia hawa: hamosu da gadili gagoi ea golasu ifa, amo ea bai, duni bugisu amola efe huluane ouligima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mousese, Elane amola egefelali ilia fisisu da Hina Gode Ea Abula Diasu midadi, eso mabe gusudili ilegei. Ilisu da Isala:ili dunu fidima:ne, Hadigi Malei Sesei amo ganodini hawa: hamonanu. Be dunu eno da amo hawa: hamomusa: dawa:i ganiaba, ilia amo dunu medole legemusa: ilegei. ");
INSERT INTO beo_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Hina Gode da ema sia:beba:le, Mousese da dunu huluane amo da lalelegele, oubi afae baligiba:le, ilia dunu momogi defele idili gagale dedei. Ilia idi huluane da 22,000. ");
INSERT INTO beo_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","41","Hina Gode da Mousesema amane sia:i, “Isala:ili dunu ilia mano magobo huluanedafa da Na:. Amaiba:le, Isala:ili magobo dunu mano amo da oubi afae baligi, amo dedema. Be amo mae lale, Na da Lifai fi huluane amo lamu. Na da Hina Gode! Amola Isala:ili ohe fi mano magobo huluane mae lale, Na da Lifai fi dunu ilia ohe huluanedafa lamu.” ");
INSERT INTO beo_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","43","Mousese da Hina Gode Ea sia: nababeba:le, Isala:ili dunu ilia mano magobo huluane amo da lalelegele, oubi afae baligi galea, ilia dio huluane dedei. Ilia idi huluane da 22,273 agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Wali, Isala:ili magobo dunu mano huluane ilia sogebi lama:ne, Lifai fi dunu huluane ilegele, Nama ima. Amola Isala:ili dunu ilia ohe fofoi mano magobo ilia sogebi lama:ne, Lifai fi dunu ilia ohe fofoi mano magobo huluanedafa ilegele, Nama ima. ");
INSERT INTO beo_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Be Isala:ili dunu ilia dunu mano magobo ilia idi da Lifai fi dunu huluane ilia idi273agoane baligisa. Amaiba:le, di amo 273 dunu bu bidi lama. ");
INSERT INTO beo_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Bidi lasu ilegesu amo defele Isala:ili ilia dunu mano magobo amo silifa biyale gala amoga bu bidi lama. ");
INSERT INTO beo_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Amo muni lale amo Elane amola egefelali ilima ima:mu.” ");
INSERT INTO beo_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mousese da Hina Gode Ea hamoma:ne sia:i defele hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","51","E da silifa fage 1,365 amo lale, Elane amola egefelali ilima i. ");
INSERT INTO beo_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Lifai fi Gouha:de, amo ilia fi huluane amola sosogo fi huluane gilisili, afae afae idima. ");
INSERT INTO beo_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Dunu huluane da lalelegele, ode30baligi be ode50 hame baligi, amola ilia da Hina Gode Ea Abula Diasu amo ganodini hawa: hamomu defele ba:sea, amo dedema. ");
INSERT INTO beo_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ilia hawa: hamosu da hadigidafa liligi ouligimusa: gala.” ");
INSERT INTO beo_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Hina Gode da Mousesema amane sia:i, “Fisisu fisili, logoga masunu eso da doaga:sea, Elane amola egefelali da Na Abula Diasu ganodini golili sa:ili, abula amo da Sema Gagili midadi diala amo fadegale, amoga Sema Gagili dedeboma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ilia da bulamagau gadofo noga:i amoga dedebole, amola amo da:iya haisewe abula ligisilalu, gaguli ahoasu ifa salima:mu. ");
INSERT INTO beo_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ilia da Godema agi imunusa: fafai amo da:iya haisewe abula fadegale gale ligisimu. Amo da:iya ilia da ofodo, gabusiga: manoma ofodo, iasu faigelei amola ganagu amo ganodini ilia waini iaha, amo huluane ligisimu. Amo fafai da:iya, eso huluane mae fisili dilia da agi ligisi dialoma:ma. ");
INSERT INTO beo_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Amo huluane da:iya, ilia da yoi abula fadegale gale ligisilalu, bulamagau gadofo noga:i amoga dedebole, gaguli ahoasu ifa amo ilia salasu ganodini salimu. ");
INSERT INTO beo_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ilia da haisewe abula lale, gamali bugisu bai, gamali, nasu dida, beanoi ofodo amola olife susuligi ofodo huluane amo dedebomu. ");
INSERT INTO beo_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ilia da amo liligi huluane bulamagau gadofo abenai noga:i amo ganodini sosone la:la:gili aloi da:iya ligisimu. ");
INSERT INTO beo_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Amasea, ilia da gouliga hamoi oloda, amo da:iya haisewe abula amoga dedebomu amola bulamagau gadofoga dedebomu. Amola amo gaguli masa:ne, gaguli ahoasu ifa amo salimu. ");
INSERT INTO beo_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ilia da Hadigi Malei Sesei hawa: hamosu liligi huluane lale, haisewe abula amoga la:la:gili, bulamagau gadofo abenai noga:i amoga dedebomu. Amasea, ilia da amo liligi gaguli ahoasu fafai amoga ligisimu. ");
INSERT INTO beo_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ilia da sefe amola nasubu oloda da:iya diala amo gasa:le gale amola oloda da:iya ogaiya:i abula fadegale amoga dedebomu. ");
INSERT INTO beo_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ilia da amo da:iya, oloda hawa: hamosu liligi huluane ligisimu. Amo da lalu ofodo, ma:go, safala amola faigelei huluane. Amasea, ilia da amo huluane bulamagau gadofo amoga dedebole, gaguli ahoasu ifa salimu. ");
INSERT INTO beo_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Fisisu fisili masunu eso da doaga:sea, Elane amola egefelali da hadigi liligi huluane dedeboi dagoiba:le fawane, Gouha:de fi dunu da amo liligi gaguli masunusa: misunu da defea. Be Gouha:de fi dunu da amo hadigi liligi digili ba:mu da sema bagade. Agoane hamosea, ilia da bogomu. Isala:ili dunu da Hina Gode Ea Abula Diasu eno sogega gaguli ahoasea, Gouha:de fi dunu ilia hawa: hamosu da agoaiwane gala. ");
INSERT INTO beo_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Elia:isa (Elane, gobele salasu dunu amo ea mano) da Abula Diasu huluane, gamali ea susuligi, gabusiga: manoma, gala:ine iasu, ilegesu susuligi amola liligi huluane Abula Diasu ganodini Hina Godema ilegei amo huluane ouligimu. ");
INSERT INTO beo_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Hina Gode da Mousese amola Elane elama amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","“Gouha:de fi dunu da bogosa:besa:le, ilia da hadigidafa hamoi liligi amo gadenene mae misa:ne sia:ma. Be amo hou ilima mae doaga:ma:ne, Elane amola egefelali da Abula Diasu ganodini golili sa:ili, dunu afae afae ea hawa: hamosu ilegele sia:mu. ");
INSERT INTO beo_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Be Gouha:de fi dunu da Abula diasu golili sa:ili, gobele salasu dunu ilia da amo hadigidafa liligi gaguli masa:ne momagelalebe ba:sea, ilia da bogomu. ");
INSERT INTO beo_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Lifai fi Gesione amo ilia fi amola sosogo fi gilisili idima. ");
INSERT INTO beo_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Amola dunu huluane da lalelegele, ode 30baligi be ode 50hame baligi, amola ilia da Hina Gode Ea Abula Diasu ganodini hawa: hamomu defele ba:sea, amo dedema. ");
INSERT INTO beo_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ilia hawa: hamosu da hagudu dedei liligi amo gaguli masa:ne, sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Abula Diasu amola ea ganodini dedebosu liligi; ea gadili dedebosu liligi; bulamagau gadofo noga:i gadodili diala amola Abula Diasu logo holei ga:su abula, ");
INSERT INTO beo_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","gagoi amo da Abula Diasu amola oloda sisiga:i amo ea abula amola efe, amola gagoi logo holei ga:su abula amola amo liligi huluane amola disisu liligi huluane. Ilia amo hawa: huluane hamoma:ne ilegema. ");
INSERT INTO beo_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Mousese amola Elane da Gesione fi ilima amo hou ilia noga:le ouligisu hamoma:ne ilegei. ");
INSERT INTO beo_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gesione ilia hawa: hamosu Abula Diasu ganodini da agoaiwane galu. Idama (Gobele salasu dunu Elane egefe) da ilia hawa: hamosu ouligimu.” ");
INSERT INTO beo_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Hina Gode da Mousesema amane sia:i, “Lifai fi Milalai amo ilia fi amola sosogo fi gilisili idima. ");
INSERT INTO beo_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Amola dunu huluane da lalelegele, ode30 baligi be ode50hame baligisa, amola ilia da Hina Gode Ea Abula Diasu ganodini hawa: hamomu defele ba:sea, amo dedema. ");
INSERT INTO beo_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ilia hawa: hamosu da hagudu dedei liligi gaguli masa:ne, ilegema. Abula Diasu gagumusa: ifa, golasu ifa, golasu ifa ilia bai, amola Abula Diasu ea bai. ");
INSERT INTO beo_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Abula Diasu ea sisiga:su gagoi ifa, ifa bai, duni bugisu huluane, efe amola liligi huluane amoga ilia da Abula Diasu amola gagoi gagusu. Milalai fi dunu afae afae hi liligi gaguli masa:ne ilegema.” ");
INSERT INTO beo_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Milalai fi dunu ilia Abula Diasu ouligisu hou da agoaiwane gala. Idama (gobele salasu dunu, Elane egefe) da ilia hawa: hamosu ouligima:mu.” ");
INSERT INTO beo_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Hina Gode da hamoma:ne sia:beba:le, Mousese, Elane amola Isala:ili ouligisu dunu da Lifai fi udiana (Gouha:de, Gesione amola Milalai) amo ilia dunu idi. Ilia da fi huluane amola sosogo fi huluane gilisili idi. Dunu huluane da lalelegele, ode 30baligi be ode 50hame baligi, amo da Hina Gode Ea Abula Diasu ganodini hawa: hamomu defele ba:loba, ilia da idili dedei. Idi da agoane ba:i. Fi Idi Gouha:de 2,750 Gesione 2,630 Milalai 3,200 Idi huluane 8,580 ");
INSERT INTO beo_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Hina Gode da Mousesema hamoma:ne sia:i amo defele ilia dunu huluanedafa afae afae idili dedei. Amola Hina Gode da Mousesema hamoma:ne sia:i defele, ilia da dunu huluanedafa afae afae, amoma hi hawa: hamosu amola liligi gaguli masa:ne olelei dagoi. ");
INSERT INTO beo_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Di Isala:ili dunuma ilia da ilia fisisu amoga dunu huluane da gadofo oloi o ilia da:iga guhi gadili ahoa o bogoi da:i hodo digili ba:beba:le ledo hamoi, amo dunu gadili masa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Amo sema hamoi ledo gala dunu da fisisu amo ganodini Na da Na fi dunu gilisili esala, amo wadela:sa:besa:le, gadili asunasima.” ");
INSERT INTO beo_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Isala:ili dunu da Hina Gode Ea hamoma:ne sia:i nababeba:le, ledo hamoi dunu huluane gadili fadegale fasi. ");
INSERT INTO beo_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","- ");
INSERT INTO beo_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Hina Gode da Mousesema, e da Isala:ili dunuma amane alofele sia:ma:ne sia:i, “Nowa dunu da Hina Gode Ea hou fisili, eno dunuma wadela:i hou hamosea, ");
INSERT INTO beo_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","e da ea wadela:i hou fofada:lalu, liligi lai amo dunu amoma e da wadela:le hamoi ema bu imunu amola eno20% gilisili imunu. ");
INSERT INTO beo_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Be amo dunu da bogoi dagoi ba:sea, amola ea sosogo gadenenedafa dunu hame esalea, ea dabe iasu amo Hina Godema ima. Gobele salasu dunu da amo dabe lamu. Be dunu da wadela:le hamobeba:le, ledo hamoi galea, e bu dodofei dagoi ba:ma:ne, sibi gawali gobele salasu imunu amola waha dedei eno imunu. ");
INSERT INTO beo_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Amola Isala:ili dunu da eno liligi Godema iasea, ilia da gobele salasu dunu afae ema iasea, amo gobele salasu dunu da amo iasu lamu. ");
INSERT INTO beo_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Gobele salasu dunu afae afae da iasu ema i, amo lamu. ");
INSERT INTO beo_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","15","Hina Gode da Mousesema e da Isala:ili dunu ilima alofele sia:ma:ne sia:i, “Dunu afae da ea asigi dawa:su ganodini, ea uda da eno dunu gilisili wadela:le hamoi amo hihini dawa:sea be bai noga:le hame dawa: - bai ea uda da amo hou wamolegei amola ba:su dunu hame galu-o uda da wadela:le hame hamoi be egoa da udigili e da wadela:le hamobayale hihini dawa:sea, amo dunu da ea uda gobele salasu dunuma oule masa:ne sia:ma. Amola e da Godema ima:ne, amo bali falaua gilogala:me afae amo gaguli misa:mu. Be amoga e da olife susuligi o gabusiga: manoma hame sogagala:mu. Bai amo da egoa e da ea uda wadela:le hamoi dawa:beba:le, bu amo hou hadigi ganodini gaguli misa:ne dawa:su, amo ea iasu. ");
INSERT INTO beo_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Gobele salasu dunu da amo uda oule asili, e da oloda midadi amoga leloma:ne sia:ma:mu. ");
INSERT INTO beo_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","E da hadigi hano lale, osoboga hamoi ofodo amo ganodini sogadigimu. Amasea, e da osobo gulu amo da Hina Gode Ea Abula Diasu ganodini diala amo lale, amo hano gamogama:ne salimu. ");
INSERT INTO beo_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Amasea, e da amo uda ea dialumasa fesega:mu amola ea lobo ganodini falaua iasu ligisimu. Gobele salasu dunu da ofodo amo ganodini da gamoga:i gagabusu ilegesu hano amo ea lobo ganodini gagumu. ");
INSERT INTO beo_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Amasea, gobele salasu dunu da amo udama, e da ema dafawaneyale ilegema:ne dabe sia:musa: sia:mu. E da amane sia:mu, “Di da wadela:le inia dunu adole lasu hame hamoi galea, gagabusu ilegesu amo hano da hamosea da dima se hame imunu. ");
INSERT INTO beo_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Be di da wadela:le inia dunu adole lasu hamoi galea, ");
INSERT INTO beo_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Hina Gode da di amo dia fi amo ganodini gagabui ilegei dagoi hamomu. E da dia sema liligi amo nonobomu amola dia hagomo didigagima:ne hamomu da defea. ");
INSERT INTO beo_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Amo hano da dia hagomoga sa:ili, dia hagomo da didigagimu amola dia sema da nonobomu.” Amasea, uda da amane sia:mu, “Defea! Hina Gode da amane hamomu da defea.” ");
INSERT INTO beo_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Amasea, gobele salasu dunu da amo gagabui ilegesu dedene, e da amo dedei dodofele, gamoga:i hano faigelei amo ganodini salimu. ");
INSERT INTO beo_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Gobele salasu dunu da amo uda da se ima:ne, gamoga:i hano amo moma:ne sia:mu. Be hidadea, ");
INSERT INTO beo_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","e da falaua iasu amo uda ea loboga lale, ea lobo iluale, oloda da:iya Hina Godema imunu. ");
INSERT INTO beo_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Amasea, e da amo falaua lobo afaega gasa:le, oloda da:iya gobele salimu. Amasea, e da amo uda hano moma:ne sia:mu. ");
INSERT INTO beo_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","E da wadela:le hamoi galea, amo hano da ema se bagade imunu. Ea hagomo da didigagimu amola ea sema da nonobomu. Ea dio da ea fi ganodini gagabui ilegei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Be e da wadela:le hame hamoi galea, e da se hame nabimu, amola e da fa:no mano lalelegemu defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","Dunu da mudale, ea uda da eno dunu amola wadela:le hamoi giadofale dawa:sea, amo sema da gala. Ilia da uda amo oloda midadi leloma:ne sia:ne, gobele salasu dunu da amo hou huluane hamomu. ");
INSERT INTO beo_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Egoa da fofada:su se iasu hame ba:mu, be uda da dafawane wadela:le hamoi dagoi ba:sea, fofada:ne, se lamu. ");
INSERT INTO beo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","3","Hina Gode da Mousesema e da Isala:ili dunu ilima amane alofele sia:ma:ne sia:i, “Nowa dunu o uda da Na:salaide hamoma:ne amola Hina Godema fawane fa:no bobogema:ne dafawaneyale ilegesea, e da waini hano amola adini hamedafa manu. E da hano amo da waini fagega hamoi, waini fage amola hafoga:i waini fage huluane hamedafa manu. ");
INSERT INTO beo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","E da Na:salaide ilegei hou amo ganodini esalea, e da waini fage liligi, oso amola gadofo huluanedafa hame manu. Amo da ema sema gala. ");
INSERT INTO beo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","E da Na:salaide ilegei hou amo ganodini esalea, e da ea dialuma hinabo luga hamedafa damumu amola ea maya:bo hame waga:mu. E da eso huluane Hina Godema ilegei esoga ea ilegesu amoga la:la:gi dagoi agoane ba:mu. Amola ea dialuma amola ea maya:bo da udigili agoane alemu. ");
INSERT INTO beo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Na:salaide dunu ea dialuma hinabo, e da Godema ilegei amo ilegesu olelesu agoane gala. Amaiba:le, e da ledo hamosa:besa:le, bogoi da:i hodo gadenene masunu da ema sema bagade. Dafawane! Amola ea ada o ame, yolalia o dalusilali bogosea, e da amo da:i hodo gadenene hamedafa masunu. ");
INSERT INTO beo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","E da Na:salaide dunu esalea, e da Hina Godema ilegele mogiligai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Be Na:salaide dunu da dunu amo da hedolo bogosea, amo gadenene lelebeba:le, e da eso fesuale ouesalu, amasea dialuma hinabo amola ea maya:bo waga:ma:mu. Amasea, ea ledo hamoi da fadegai dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Eso godo amoga, e da ‘dafe’ sio aduna o musuni aduna amo Hina Gode Ea Abula Diasu logo holeiga gaguli misini, gobele salasu dunu ema imunu. ");
INSERT INTO beo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Gobele salasu dunu da sio afadafa amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamomu amola sio eno amo Wadela:i Hou Dabe Ima:ne Iasu agoane hamomu. Amo dunu da bogoi da:i hodo gadenene ahoabeba:le, ledo hamoi, amo dodofema:ne agoane hamosa. Amo esoga, amo dunu da ea dialuma hinabo bu Godema Na:salaide hou defele mogiligale ilegemu. ");
INSERT INTO beo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","E da Hina Godema ea Na:salaide eso hamosu bu mogiligale ilegemu. E da musa: eso hamoi amo da bu hame dawa:mu. Bai ea dialuma hinabo mogili gagale ilegei da ledo hamoi dagoi. E da Dabe Iasu hamoma:ne, sibi mano ode afae lalelegei, amo gaguli misunu. ");
INSERT INTO beo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Na:salaide dunu da ea ilegei eso huluane hamoi dagosea, e da agoane hamomu. E da Hina Gode Ea Abula Diasu logo holeiga asili, ");
INSERT INTO beo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ohe udiana noga:i (ledo hamedei) amo Hina Godema imunu. Amo da ode afae lalelegele esala gawali sibi mano Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne; amola ode afae lalelegei aseme sibi mano Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne amola sibi gawali amo Hahawane Gilisili Olofole Iasu hamoma:ne. ");
INSERT INTO beo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Amola e da daba amo ganodini da agi ga:gini gagai (yisidi hame gala) imunu. Amo agi da gadugagi ba:mu amola falaua amola olife susuligi gilisili bibiagoi amoga hamoi. Amola ga:gi abenai amoga olife susuligi da unasi amola e da gala:ine amola waini hano ilegei iasu gaguli misa:mu. ");
INSERT INTO beo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Gobele salasu dunu da amo liligi huluane Hina Godema imunu. Amola e da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu amola Wadela:i Hou Dabe Ima:ne Iasu amo gobele salimu. ");
INSERT INTO beo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","E da Hahawane Gilisili Olofole Iasu hamoma:ne, sibi gawali amola agi sali daba amo gilisili imunu. Amola, e da gala:ine amola waini hano imunu. ");
INSERT INTO beo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Na:salaide dunu da Abula Diasu logo holeiga asili, ea dialuma hinabo waga:ne, lalu amoga Hahawane Gilisili Olofole Iasu da hamonanebe, amoga ligisima:mu. ");
INSERT INTO beo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Amasea, sibi gawali ea bea dagai da gobei dagosea, gobele salasu dunu da amo amola gadugagi agi ga:gi afae amola belowagi dabaga lale, Na:salaide dunu amo ea lobo ganodini ligisimu. ");
INSERT INTO beo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Amasea, gobele salasu dunu da amo liligi, Hina Godema imunu. Ilia da gobele salasu dunuma ima:ne, hadigi iasu agoane hamoi. E da amo liligi amola sibi gawali ea bidegi amola emo (Isala:ili sema ganodini, amo da gobele salasu dunu ea:) amo lamu. Amo fa:no, Na:salaide dunu da waini manu defea. ");
INSERT INTO beo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Amo dedei liligi da Na:salaide dunu ilia sema. Be Na:salaide dunu da Na:salaide sema amo baligimusa: ilegele sia:sea, amola baligili iasu imunusa:ilegesea, e da amo baligi ilegei defele noga:le hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","23","Hina Gode da Mousesema e da Elane amola egefelali ilima alofele sia:ma:ne sia:i, “Dilia da Isala:ili dunuma, ili hahawane esaloma:ne hahawane dogolegele sia:sea, amane sia:ma, ");
INSERT INTO beo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Hina Gode da dilima hahawane dogolegele hamomu amola dili noga:le ouligimu da defea. ");
INSERT INTO beo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Hina Gode da dilima asigimu amola dilima gogolema:ne olofosu hou olelemu da defea. ");
INSERT INTO beo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Hina Gode da dili hahawane ba:mu amola dilima olofosu imunu da defea.’” ");
INSERT INTO beo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Amola, Hina Gode da amane sia:i, “Elane amola ea mano da Na Dioba:le, Isala:ili dunuma hahawane dogolegele hamoma:ne sia: iasea, Na amola da ilima hahawane dogolegele hamomu.” ");
INSERT INTO beo_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Eso amoga Mousese da Hina Gode Ea Abula Diasu amo gaguli dagoloba, e da Abula Diasu amola ea hawa: hamosu liligi amola oloda amola ea hawa: hamosu liligi amoga susuligi sogadigili, Hina Godema momodale ligiagale ilegei. ");
INSERT INTO beo_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Amalalu, fi ouligisu dunu (amo da Isala:ili fi amo ganodini ouligisu dunu esalu amola ilia da idili dedesu hou ouligisu), ");
INSERT INTO beo_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","4","ilia da Hina Godema ima:ne, liligi gaguli misi. Ilia da gaguli fula ahoasu gafeyale amola bulamagau fagoyale gaguli misi (amo da ouligisu dunu aduna da gaguli fula ahoasu afae amola ouligisu dunu afae afae da bulamagau afae afae gaguli misi). Ilia da amo liligi ianu, amola Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Amo liligi lale, bu Lifai dunuma ima. Ilia Abula Diasu ganodini hawa: hamoi bidi lama:ne defele, ilima ima.” ");
INSERT INTO beo_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Amaiba:le, Mousese da gaguli fula ahoasu amola bulamagau amo Lifai dunuma i. ");
INSERT INTO beo_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","E da gaguli fula ahoasu aduna amola bulamagau biyaduyale amo Gesione fi ilima i. ");
INSERT INTO beo_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","E da gaguli fula ahoasu biyaduyale amola bulamagau godoane amo Milalai fi ilima i. E da Idama (Elane ea mano) amo hawa: hamosu huluane ouligima:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Be Mousese da Gouha:de fi ilima gaguli fula ahoasu amola bulamagau hame i. Bai sema liligi amo ilia da ouligisu, amo ilia da gisawane fawane gaguli ahoasu. ");
INSERT INTO beo_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Amola Isala:ili ouligisu dunu da hahawane oloda modale ligiagama:ne, iasu liligi gaguli misi. Ilia da amo liligi oloda amoga ima:ne momagei dagoi ba:loba, ");
INSERT INTO beo_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Hina Gode da Mousesema amane sia:i, “Ilima amane olelema, ‘Eso fagoyale gala amoga, eso afae afae, ouligisu dunu afae afae da ea iasu oloda modale ligiagale ilegema:ne’ sia:ma.” ");
INSERT INTO beo_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Ilia da ilia iasu afae afae agoane i; Eso Fi Ouligisu 1 Yuda Na:iasione (Aminida:be egefe) 2 Isaga Nida:niele (Sua egefe) 3 Sebiulane Ilaia:be (Hilone egefe) 4 Liubene Elaise (Siendiua egefe) 5 Simiane Sieliumiele (Siulisia:dai egefe) 6 Ga:de Ilaiasa:fe (Diuele egefe) 7 Ifala:ime Ilisiama (Aminihade egefe) 8 Ma:na:se Gama:iliele (Bedase egefe 9 Bediamini Abaida:ne (Gidiouni egefe) 10 Da:ne Ahaisa (Amisia:dai egefe) 11 A:sie Ba:idiele (Ogela:ne egefe) 12 Na:fadalai Ahaila (Ina:ne egefe) Ilia huluane da iasu afae afae defele gaguli misi. Amo da, Silifa ofodo fonobahadi afae - ea dioi defei da 1.5 gilogala:me amola silifa ofodo bagade afae - ea dioi defei da 800 gala:me - ela afae afae da falaua amola susuligi (Gala:ine Iasu) amoga nabai galu. Gouliga hamoi ofodo afae - ea dioi defei da 110 gala:me. Amo da gabusiga: manoma amoga nabai galu. Bulamagau gawali waha debe agoai afae amola ode afae lai sibi mano afae, amo da Wadela:i Hou Dabe Ima:ne Iasu hamoma:ne. Goudi afae amo da Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne. Amola bulamagau gawali aduna, sibi gawali biyale, goudi biyale amola ode afae lai sibi mano biyale gala amo da Hahawane Gilisili Olofele Gobele Salasu hamoma:ne gaguli misi. ");
INSERT INTO beo_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Ouligisu dunu fagoyale gala da amo liligi oloda ilegema:ne gaguli misi. Liligi huluane gilisili da agoane ba:i. Silifa ofodo fonobahadi fagoyale amola silifa ofodo bagade fagoyale gala. Gilisili, ilia dioi defei ba:su da 27.6 gilogala:me; Gouliga hamoi ofodo fagoyale gala gabusiga: manoma amoga nabai. Ilia dioi defei huluane da 1.32 gilogala:me; Bulamagau gawali fagoyale gala, amola gala:ine amoga ilia da gilisili Wadela:i Hou Dabe Ima:ne gobele salasu hamosu; Goudi fagoyale gala, amo Wadela:i Hou Gogolema:ne Olofoma:ne gobele salasu hamoma:ne. Bulamagau gawali 24 agoane, sibi gawali 60 agoane, goudi 60 agoane amola ode afae lalelegei sibi mano 60 agoane (amo da Hahawane Gilisili OlofeleGobele salasu hamoma:ne gaguli misi.) ");
INSERT INTO beo_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mousese da Hina Godema sia:musa:, Abula Diasu golili daloba, e da Hina Gode amo Ea Gousa:su Sema Gagili ea ga:lu gadodili liligi aduna ougia hamoi gala, amo elea dibidi amodili, ema dabe sia:neyabe nabi. ");
INSERT INTO beo_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Elanema amane olelema. ‘E da gamali fesuale amo ilia baiga ligisisia, amo gamali ilia hadigi da midadi hadigima:ne, agoane bugima:ne sia:ma.’” ");
INSERT INTO beo_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Elane da amo sia: nababeba:le, gamali ea ba:le gaidi amodili gamali ea baiga amoi ilia midadi amoga bugi. ");
INSERT INTO beo_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Gadodili asili ea baiga, gamali bai da gouli amo ha:maga dabagala:i agoane ba:i. Bai Hina Gode da amo hamosu ilegei Mousesema olelei. ");
INSERT INTO beo_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Dia Lifai dunu amo Isala:ili dunu eno amoga afafama. Amola ilia ledo doga:ma:ne agoane hamoma. ");
INSERT INTO beo_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ilia da:i hodo hinabo huluane waga:ma:ne amola abula huluane dodofema:ne sia:ma. Amasea, ilia da sema defele, ledo hamedei hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Amasea, ilia da bulamagau gawali waha debe amola Gala:ine Iasu (falaua amola olife susuligi gilisi) amo lama:ne sia:ma. Amola di bulamagau gawali eno Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne lama. ");
INSERT INTO beo_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Amasea, Isala:ili dunu huluane gilisima:ne sia:ma. Amola Lifai dunu amo Na Abula Diasu midadi leloma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Isala:ili dunu huluane da ilia lobo Lifai dunu ilia dialuma da:iya ligisima:mu. ");
INSERT INTO beo_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Amasea, Lifai dunu da Nama hahawane iasu, Na hawa: hamosu hamoma:ne, Elane da ili momogili gagale ilegema:mu. ");
INSERT INTO beo_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Amasea, Lifai dunu da ilia lobo bulamagau aduna ela dialuma da:iya ligisimu. Ilia da bulamagau afae amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne imunu amola eno da Wadela:i Hou Dabe Ima:ne Iasu hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Dia Lifai dunu amo Nama noga:idafa fi hamoma:ne momogili gagale ilegema. Amola Elane amola ea mano ilima ouligima:ne ilegema. ");
INSERT INTO beo_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Lifai dunu ilia da Na fidafa esaloma:ne, Isala:ili fi ilima mogima. ");
INSERT INTO beo_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Di da Lifai dunu ledo hamedei esaloma:ne ilegei dagosea, ilia da Na Abula diasu amo ganodini hawa: hamomu defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Na da Lifai dunu amo Isala:ili mano magobo huluane ilia sogebi lama:ne ilegei dagoi. Ili da Na: fawane. ");
INSERT INTO beo_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Na da Idibidi fi ilia mano magobo huluane fane legeloba, Na da Isala:ili dunu fi amola ohe fi mano magobo huluane Na: fawane esaloma:ne ilegei dagoi. ");
INSERT INTO beo_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Be wali Na da Isala:ili mano magobo mae lale, Lifai fi dunu huluane Na: fawane esaloma:ne ilegele laha. ");
INSERT INTO beo_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Amola Isala:ili dunu ilia da Lifai dunu huluane amo Elane amola ea mano ilima ima:ne, Na da ilegesa. Ilia da Isala:ili dunu ilia hawa: hamosu Abula Diasu amo ganodini hamomu. Bai Isala:ili dunu eno da Hadigi Malei Sesei gadenene masea, ilia da gugunufinisi dagoi ba:sa:besa:le, agoane hamosa.” ");
INSERT INTO beo_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Amaiba:le, Mousese, Elane amola Isala:ili dunu huluane da Hina Gode Ea hamoma:ne sia:i defele, Lifai dunu momogili gagale ilegei. ");
INSERT INTO beo_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lifai dunu da ilia da:i hano ulalu, ilia abula dodofei. Amasea, Elane da ili Hina Godema iasu noga:i ima:ne, momogili gagale ilegei. E amola ledo hamedei hamoma:ne hou ilima hamoi. ");
INSERT INTO beo_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Isala:ili dunu da hou huluane Hina Gode da Mousesema hamoma:ne sia:i, amo huluane Lifai dunuma hamoi. Amaiba:le, Lifai dunu da Elane amola ea mano ilia ouligisu hagudu amo Abula Diasu hawa: hamosu hamoma:ne defele ba:i. ");
INSERT INTO beo_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Lifai dunu da ode 25 baligisia, Na Abula Diasu ganodini hawa: hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","E da ode 50 gidigisia, ea hawa: hamosu fisima:mu. ");
INSERT INTO beo_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Amo ode fa:no, e da ea Lifai sama amo Abula Diasu ganodini fidimu da defea, be hisu da hame hamomu. Di da Lifai dunu ilia hawa: hamosu amo defele ouligima.” ");
INSERT INTO beo_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Oubi age amoga Isala:ili dunu da Idibidi soge fisili, gadili asili ode ageyadu amoga, Hina Gode da Sainai Hafoga:i Soge ganodini Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","“Wali oubi, eso 14amoga eso dabe galu, Isala:ili dunu da Baligisu Lolo Nasu amo sema huluane defele hamoma:ma.” ");
INSERT INTO beo_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Amaiba:le, Mousese da Isala:ili dunu huluane Baligisu Lolo Nasu hamoma:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ilia da eso dabe amoga eso 14amola oubi age ganodini, Sainai Hafoga:i Soge ganodini, Baligisu Lolo Nasu hamoi. Ilia da Hina Gode Ea Mousesema hamoma:ne sia:i huluane defele hamoi. ");
INSERT INTO beo_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Be dunu mogili da bogoi da:i hodo digili ba:i dagobeba:le, amo esoha Baligisu Lolo manu hamedei ba:i. Ilia da Mousese amola Elanema asili amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“Ninia da bogoi da:i hodo digili ba:iba:le, ledo hamoi dagoi. Be abuliba:le, ninia Isala:ili dunu eno defele, Hina Godema gobele salasu hamomu defele hame ba:sala:?” ");
INSERT INTO beo_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mousese da bu adole i, “Waha aligima! Na da Hina Gode Ea sia: nabimu!” ");
INSERT INTO beo_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Hina Gode da Mousesema, e da Isala:ili dunuma alofele sia:ma:ne sia:i, ");
INSERT INTO beo_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Dilia amola diligaga fi da bogoi digili ba:beba:le ledo hamoi ganiaba o ga sedaga sogega lala, be Baligisu Lolo manu hanai galea, ");
INSERT INTO beo_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","dilia da ilegei oubi fisili, oubi eno ageyadu amoga eso 14amoga daeya manu da defea. Amo nasea, agi yisidi hame sali fawane amola gamoga:i hedama:ne fodole nasu fawane gilisili moma. ");
INSERT INTO beo_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ha:i manu aya manusa: mae yolesima. Amola ohe ea gasa afae maedafa fima. Baligisu Lolo Nasu ea sema huluane defele moma. ");
INSERT INTO beo_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Be nowa dunu da ledo hamedei amola soge sedade amoga hame asi, be Baligisu Lolo Nasu hame hamobe ba:sea, di amo dunu Na fi ilima fadegale fasima. Bai e da Lolo Nasu esoha, Nama gobele salasu hame hamoi. E da hisu wadela:le hamoiba:le, se nabimu. ");
INSERT INTO beo_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ga fi dunu Isala:ili fi amo ganodini esalea da Baligisu Lolo Nasu hamomu hanai galea, e da amo Baligisu ea sema huluane hamoma:ne sia:ma. Dunu huluanedafa, Isala:ili dunu amola ga fi dunu, da amo sema huluane defele hamosea, Baligisu Lolo manu. ");
INSERT INTO beo_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Esoha amoga ilia da Hina Gode Ea Abula Diasu hiougi, mu mobi ganumu da misini, Abula Diasu dedeboi dagoi. Gasi ganodini, amo mu mobi ganumu da lalu agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Mu mobi ganumu da gado heda:loba, Isala:ili dunu da ilia fisisu mugululi asili, amola mu mobi ganumu da bisili asili bu sa:i dagoi ba:loba, amo sogebiga ilia da fisisu bu gagusu. ");
INSERT INTO beo_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Hina Gode Ea sia:beba:le, ilia da fisisu mugululi ahoasu, amola E da bu sia:beba:le, ilia da fisisu bu hiougisu. Mu mobi ganumu da ilia fisisu da:iya gadodili dialebeba:le, ilia da fisisu ganodini ouesalu. ");
INSERT INTO beo_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Mu mobi ganumu da eso bagohame ilia fisisu da:iya gadodili dialebeba:le, ilia da Hina Gode Ea hamoma:ne sia:i defele, ouesalu. ");
INSERT INTO beo_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Eso enoga, mumobi ganumu da eso bagahame ilia fisisu da:iya gadodili dialebe ba:i. Be ilia da fisisu ganodini ouesaloba o fisisu mugululi ahoanoba, ilia da Hina Gode Ea olelei defele fawane hamoi. ");
INSERT INTO beo_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Eso enoga, mumobi ganumu da daeya ilia fisisu da:iya gadodili dialu hahabe bu bisili asi ba:su. Be mumobi ganumu da gadodili heda:le, ahoanoba, ilia amola da ahoasu. ");
INSERT INTO beo_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Mumobi ganumu da eso aduna o oubi afae o ode afae baligili, amo ea aligisu eso defele ilia da ouesalusu. Be mumobi ganumu da gadodili heda:be ba:loba, ilia da ahoasu. ");
INSERT INTO beo_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ilia da fisisu hiougisu amola fisisu mugulusu, amo Hina Gode da Mousese ea lafidili ilima hamoma:ne sia:i defele hamoi. ");
INSERT INTO beo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Silifa dabagala:le dalabede aduna hahamoma. Amoga, Isala:ili dunu gilisima:ne amola fisisu muguluma:ne eso olelema. ");
INSERT INTO beo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Dalabede aduna dusia, ela ga: da badilia lalaba ahoasea, amo da Isala:ili dunu huluanedafa da dima, Na Abula Diasu logo holeiga gilisima:ne, dawa:digima:ne dusa. ");
INSERT INTO beo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Be dalabede afae fawane dusia, fi ouligisu dunu fawane da gilisima:ne galebeya dawa:ma. ");
INSERT INTO beo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Dalabede aduna da dunumugini dusia, fi amo da fisisu eso mabe la:ididili esala da gadili masa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Be dalabede da dunumugini aduna agoane dusia, fi amo da ga (south) la:idili esala da gadili masa:ne sia:ma. Amaiba:le, dilia da dalabede da dunumuni agoane dusu nabasea, fisisu mugulumusa: momagema:ma. ");
INSERT INTO beo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Be dilia Isala:ili dunu huluane gilisimusa: dawa:sea, sedagiliwane dalabede fulaboma:ma. ");
INSERT INTO beo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Gobele salasu dunu (Elane ea mano) da dalabede fulaboma:ne sia:ma. Eso huluane, mae fisili, amo hamoma:ne sia:i noga:le ouligima. ");
INSERT INTO beo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Dilia soge ganodini, gegesu ba:beba:le, ha lai dunu da dilima doagala:sea, dilia gegemusa:gini, dalabede duma. Na, dilia Hina Gode, da dili fidimu amola dilia ha lai dunu dili mae hasalima:ne gaga:mu. ");
INSERT INTO beo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Amola dilia hahawane eso amoga dilia Oubi Gaheabolo Lolo Nasu amola Hina Godema dawa:ma:ne Lolo Nasu eno amoga, dilia Wadela:i Hou Dabe Ima:ne Iasu amola Hahawane Gilisili Olofole Iasu hahamosea, dalabede fulaboma. Amasea, Na da dili fidimu. Bai Na da dilia Hina Gode.” ");
INSERT INTO beo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Eso 20 amola oubi ageyadu amola ode ageyadu ganodini, Hina Gode da mumobi ganumu Ea Abula Diasu gadodili dialu amo gaguia gadole asi. ");
INSERT INTO beo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Isala:ili fi dunu da Sainai hafoga:i soge amo fisili asi. Mumobi ganumu da ahoanu, Ba:ila:ne hafoga:i sogega oulelu. ");
INSERT INTO beo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Amaiba:le, ilia da Hina Gode Ea Mousesema hamoma:ne sia:i defele, degabo agoane asi. ");
INSERT INTO beo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Amola eso huluane ahoabeba:le, ilia da hou ilegei defele ahoasu. Dunu fi amo da Yuda fi ilima gilisi da eso gosagisu fa:no, fi eno fi eno ahoasu. Na:iasione (Aminida:be ea egefe) da amo gilisisu ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nida:niele (Sua ea egefe) da Isaga fi amo ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ilia:be (Hilone ea mano) da Sebiulane fi amo ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Amalalu, ilia da Gode Ea Abula Diasu mugululi, Gesione amola Milalai fi dunu da amo gaguli ahoasu. ");
INSERT INTO beo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Amalalu, fi amo da Liubene fi ilima fa:no bobogesu, ilia da gilisisu eno eno agoane ahoasu. Elaise (Siediua egefe) da ili ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Sieliumiele (Siulisia:dai egefe) da Simione fi amo ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ilaiasa:fe (Diuele egefe) da Ga:de fi ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Amalalu, Lifai fi amo Gouha:de da sema liligi gaguli ahoasu. Ilia da asili, fisisu sogebi eno amoga doaga:loba, Gode Ea Abula Diasu bu hiougili dagoi ba:su. ");
INSERT INTO beo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Lifai fi da asi dagoi ba:loba, fi gilisisu amo da Ifala:ime fi da ouligisu da logoga ahoanebe ba:su. Ilia ouligisu dunu da Ilisiama (Amihade egefe) ba:i. ");
INSERT INTO beo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Amo gilisisu ganodini, Gama:iliele (Bedase egefe) da Ma:na:se fi amo ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Amola Abaida:ne (Gidioni egefe) da Bediamini fi amo ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Fa:nodafa, fi amo da Da:ne fi gilisili fi da ilia eso gosa:gisu fa:no bobogele ahoasu. Ilia da fi huluane ilia fa:no sosodo ouligisu dunu agoane ba:i. Amo gilisisu ilia ouligisu dunu da Ahaisa (Amisia:dai egefe). ");
INSERT INTO beo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ba:idiele (Ogela:ne egefe) da A:sie fi amo ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Amola Ahaila (Ina:ne egefe) da Na:fadalai fi amo ouligisu. ");
INSERT INTO beo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Isala:ili dunu da ilia fisisu yolesili, logoga ahoanoba, agoane fi eno fi eno agoane mogodigili ahoasu. ");
INSERT INTO beo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mousese da ea bae amo Houba:be (Midiane dunu Yedelou egefe) ema amane sia:i, “Ninia da soge amo Hina Gode da ninima imunusa: ilegei, amoga doaga:musa: masunu. E da Isala:ili dunu hahawane bagade gaguiwane esalumusa: ilegele sia:i. Amaiba:le, di ani masunu. Ninia da di amola gilisili hahawane bagade gaguiwane hou ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Be Houba:be da bu adole i, “Hame mabu! Na da ni sogega buhagimu.” ");
INSERT INTO beo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Be Mousese da ema ha:giwane edegei, “Dia nini mae yolesima! Di da hafoga:i soge ganodini nini hahawane fima:ne, sogebi huluane dawa:. Dia ninima logo olelema:ne misa. Hina Gode da ninima hahawane bagade imunusa: sia:i. ");
INSERT INTO beo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Di amola ninia gilisili ahoasea, ninia da gilisili Gode Ea hahawane dogolegele iabe hou amo ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Isala:ili dunu da hadigi goumi Sainai amo fisili asili, eso udiana agoane logoga asi. Hina Gode Ea Gousa:su Sema Gagili ilima fisisu sogebi hogomusa:, bisili ahoanebe ba:su. ");
INSERT INTO beo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Hou da eso huluane agoane ba:i. Ilia da fisisu fisili ahoabeba:le, Hina Gode Ea mu mobi ganumu da esoga ili gadodili lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Eso huluane ilia da Sema Gagili amo gaguli ahoabeba:le, Mousese da amane sia:su, ‘Hina Gode! Di wa:legadoma! Dia ha lai dunu amo afagogolisima! Dima higa:i dunu hobeama:ne, sefasima!” ");
INSERT INTO beo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Amola Sema Gagili da oulelea, e da amane sia:su, “Hina Gode! Dia Isala:ili dunu sosogo fi osea:i, ilima buhagima!” ");
INSERT INTO beo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Isala:ili dunu da se nababeba:le, Hina Godema sia:ga gegei. Hina Gode da ilia egasu sia: nababeba:le, ougi ba:i. E da ilima lalu i. Amo lalu da ilia gilisisu ganodini nenanu, ilia fisisu la:idi afae gugunufinisi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Isala:ili dunu da Mousesema, ili fidima:ne dini wele sia:i. Amalalu, Mousese da Hina Godema sia:ne gadoi. Amalalu, lalu da haba:doi. ");
INSERT INTO beo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Amaiba:le, ilia da amo sogebi amoga Dabila dio asuli. Bai amogawi Hina Gode Ea lalu da ilia gilisisu ganodini nenemegiwane nenanu. ");
INSERT INTO beo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Isala:ili dunu da logoga ahoanoba, ga fi dunu mogili amola da ili gilisili lalu. Ilia da hu manusa: bagade hanai galu. Amola Isala:ili dunu ilia amola da egai. Ilia amane egane sia:i, “Ninia da hu manu da defea. ");
INSERT INTO beo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Idibidi soge ganodini ninia da menabo ninia hanai defele bidi mae iawane mai dagoi. Ha:i manu, doagi, agilima, ‘ligi’, ania:ni amola galu ninia mai, amo bu dawa:ma. ");
INSERT INTO beo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Be wali ninia gasa da hamedei. Wali ninia da ha:i manu hame gala. Eso huluane ninia da ‘ma:na’ fawane naha!” ");
INSERT INTO beo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(‘Ma:na’ da oso fonobahadi agoane ba:i. E da ahea:iai amola bua: gilisi agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","‘Ma:na’ da oubi baeya amola gilisili fisisu amogai gasia sa:i. Golale hahabe, Isala:ili dunu da asili, ‘ma:na’ goudane o fa:ne ‘falaua’ hamosu. Amalalu, ilia da amo liligi egegele, ga:gisu. Ea heda da agi amo olife susuligiga gilisili gobei agoane ba:i.) ");
INSERT INTO beo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Isala:ili dunu huluane da ilia abula diasu logo holei gadenene gilisili egane sia: dasu. Amola Mousese da amo sia: nabi. Hina Gode da ilima ougi bagadeba:le, Mousese amola da se nabi. ");
INSERT INTO beo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","E da Hina Godema amane sia:i, “Di da abuliba:le nama se ibala:? Abuliba:le, Di da nama hahawane hame gala. Dia da abuliba:le amo dunu ouligima:ne na ilegebela:? ");
INSERT INTO beo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Na da amo dunu hame hahamoi. Ili da na hame hahamone lalelegei. Na da amo dunu ouga:ne, mano dudubu agoane ouga:ne asili, soge amo Di da ilia aowalali ilima ima:ne ilegele sia:i, amoga masunu da defea hame. Di abuliba:le, na agoane hamoma:ne sia:sala:? ");
INSERT INTO beo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Na da habodili hu amo dunu huluane defele moma:ne lama:bela:? Ilia da mae fisili egane hu manusa: edegelala. ");
INSERT INTO beo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Na nisu amo dunu ouligimu da hamedei. Hawa: hamosu bagadeba:le, amo da hamedei. ");
INSERT INTO beo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Di da nama agoane hamomu na higa:i. Nama asigima! Dia na fane legema! Amasea, na da Dia nama dodona:gi hou bu hame ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Hina Gode da Mousesema amane sia:i “Dunu noga:idafa (dunu eno da amo dunu da ouligisu dunu noga:iwane dawa:sa) agoai dunu 70 agoane gagadole, Nama Na abula diasuga oule misini, dima dafulili leloma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Na da gudu sa:ili amogawi dima sia:mu. Amola Na da A:silibu Na dima i amoga lale, ilima imunu. Amasea, di fawane da Isala:ili dunu hame ouligimu. Be ilia amola di gilisili dilia Isala:ili dunu ouligima:mu. ");
INSERT INTO beo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Amola wali, Isala:ili dunuma amane olelema, ‘Aya misunu hou momagema:ne, dilia hou dodofema. Dilia da hu manu ba:mu. Hina Gode da dilia egane hu manusa: hanai sia: amola dilia da Idibidi soge ganodini baligili hahawane ba:i, amo egasu sia: E da nabi dagoi. Wali, Hina Gode, da dilima hu moma:ne imunu, amola dilia da amo moma! ");
INSERT INTO beo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Dilia da amo esohaga afae o aduna o biyale o nabuane o20 amogamusu fawane hame manu. ");
INSERT INTO beo_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Be oubi afae amoga, dilia da eso huluane sadini manu. Amasea, dilia da hu mai amoga sadiba:le, hu da fedege agoane dilia ge gelabadili hulu aduga:le sa:imu, amola dilia da oloiba:le isomu. Bai dilia da Hina Gode (E da dilia gilisisu ganodini esala) amo higasu, amola dilia da egane Ema dilia da Idibidi soge fisimu da defea hame galu amane sia:dasu.” ");
INSERT INTO beo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mousese da Hina Godema amane sia:i, “Na da dunu 600,000 agoane ouligilala. Amola Di da ilima oubi afae amoga manu defele hu imunu sia:sa. ");
INSERT INTO beo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bulamagau amola sibi amo ilia sadini moma:ne defele medole legemu ba:ma:bela:? Menabo huluane wayabo bagade ganodini diala da ili sadini moma:ne defelela:?” ");
INSERT INTO beo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Hina Gode da ema bu adole i, “Di adi dawa:bela:? Na gasa da baligili bagade hamela:? Na sia:i liligi da ba:ma:bela:? O hame ba:ma:bela:? Di da hedolowane ba:mu!” ");
INSERT INTO beo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Amalalu, Mousese da gadili asili, Isala:ili dunu ilima Hina Gode Ea hamoma:ne sia:i alofele i. E da ouligisu dunu 70 gagadole, Abula Diasu sisiga:le leloma:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Amalalu, Hina Gode da mu mobi ganodini gudu sa:ili, ema sia:i. E da A:silibu amo E da musa: Mousesema i, amo Ea gasa lale, ouligisu dunu 70 ilima i. A:silibu da amo ouligisu dunuma aligila sa:ili, ilia da Gode Sia: Alofesu dunu (balofede) agoane afadafa fawane wele, bu hame wei. ");
INSERT INTO beo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Be ouligisu dunu 70 gilisisu amo ganodini, dunu aduna amo Eleda:de amola Mida:de, ela da fisisu mae yolele, Abula Diasu amoga hame asi ba:i. Be fisisu amo ganodini, A:silibu da elama aligila sa:ili, ela amola balofede dunu agoane wele ba:la:lusu. ");
INSERT INTO beo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Isala:ili ayeligi afae da hehenane, Eleda:de amola Mida:de elea hou amo Mousesema olelei. ");
INSERT INTO beo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Amalalu, Yosiua (Nane egefe. E da ea ayeligi eso amogainini muni, amo esoga doaga:le, Mousese ea fidisu dunu esalusu) e da Mousesema amane sia:i, “Hina! Amo dunu ilia logo hedofama!” ");
INSERT INTO beo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Be Mousese da bu adole i, “Di da na hou dawa:beba:le mudasala:? Mae dawa:ma! Na da agoane hanai! Hina Gode da Ea A:silibu amo Ea fi dunu huluane ilima ianu, ilia huluane balofede dunu agoane wele ba:la:lumu da defea.” ");
INSERT INTO beo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Amalalu, Mousese amola ouligisu dunu 70 da fisisu amoga buhagi. ");
INSERT INTO beo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Amalalu, hedolowane, Hina Gode da fo asunasi. Amo fo da ‘gawa:ile’ sio hano wayabo bagade amogainini oule misi. Ilia da osobo gadenene (mida afae fisia guduli) hagili misi. Ilia da fisisu amo sisiga:le, bulagila sa:i. Ilia bulagila asi da gusudili, guma:dini amola la:idi amola la:idi huluane da gilomida bagohame baligi. ");
INSERT INTO beo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Amaiba:le, amo eso amola amo gasia, amola golale eso enoga, Isala:ili dunu da hawa: hamonanu amola ‘gawa:ile’ sio gaguiagagai. Ilia huluane afae afae da 1,000 gilogala:me defei baligi gagadoi. Ilia da ilia fisisu sisiga:le, amo sio ilia hodo gufunanesili eso hougi. ");
INSERT INTO beo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Be sio ea hu da ilia lafia hame mai dialobawane, Hina Gode Ea ougi heda:le, E da olo bagade se dabe ilima i. ");
INSERT INTO beo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ilia da amo sogebi amoma dio asuli amo ‘Gibalode Ha:da:ifa’ (dawa:loma:ne da ‘Hanaiba:le Bogoi Uli Dogosu’). Bai amogawi ilia da dunu amo da hu baligili hanai, amo ilia bogoi da:i hodo uli dogoi. ");
INSERT INTO beo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Isala:ili dunu da amo sogebi fisili, asili, Hasilode sogega doaga:le, fisisu hamoi. ");
INSERT INTO beo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mousese da Giusiai soge uda lale esalu. Amaiba:le, Milia:me amola Elane da amoga hahawane hameba:le, egane sia:i. ");
INSERT INTO beo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ela da amane sia:i, “Hina Gode da Mousese ea lafidili fawane sia:bela:? Hame mabu! E da ania lafidili amola sia:dasu:.” Hina Gode da elea egasu sia: nabi. ");
INSERT INTO beo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Mousese da bodogi dunu esalu, gasa fi hame dawa:i. Ea bodogi hou da osobo bagade dunu eno huluane ilia asaboi hou baligi dagoi.) ");
INSERT INTO beo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Hedolowane, Hina Gode da Mousese, Elane amola Milia:me ilima amane sia:i “Dilia udiana! Gadili misa! Na Abula Diasuga misa!” Ilia da asi. ");
INSERT INTO beo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Hina Gode da mu mobi ganumu ganodini gudu sa:ili, Abula Diasu ea logo holeiga lelu, amane wei, “Elane! Milia:me!” Ela da elea midadi aliaguda:i. ");
INSERT INTO beo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Hina Gode da amane sia:i, “Na alima sia:be goe nabima! Balofede dunu ilia da dilia gilisisu ganodini esalea, ili da Na ba:ma:ne, Na da ilia esala ba:su ganodini maha amola ilia simasia ganodini ilima sia:sa. ");
INSERT INTO beo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Be Na da Na hawa: hamosu dunu Mousesema sia:sea, hou hisu da ba:sa. Na da e amo Na Isala:ili fi dunu huluane ouligima:ne ilegei. ");
INSERT INTO beo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Amaiba:le, Na da ea odagia moloiwane idinamasu agoane mae dawa:le sia:sa. E da Na da:i defele ba:i dagoi. Alia da Na hawa: hamosu dunu ema ha laiwane sia:mu da defea hame!” ");
INSERT INTO beo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Hina Gode da elama ougi galu. Amaiba:le, E da ahoanoba, ");
INSERT INTO beo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","amola mu ganumu da Abula Diasu fisili, Milia:me ea gadofo da lebolosi oloi madelale, ahea:iai agoane ba:i. Elane da ea dalusi amo lebolosiga dedeboi ba:beba:le, ");
INSERT INTO beo_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","e da Mousesema amane sia:i, “Hina! Fidima! Ania da gagaoui agoane wadela:le hamoi. Be ania se bagade nabima:ne, logo mae doasima. ");
INSERT INTO beo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","E da liligi bogoiwane lalelegei amo ea hu la:idi dasaidafa ba:sa, agoane ba:mu da defea hame. Dia amo logo hedofama!” ");
INSERT INTO beo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Amaiba:le, Mousese da Hina Godema amane wei, “Gode! E uhinisima!” ");
INSERT INTO beo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Hina Gode da bu adole i, “Ea ada da ea odagia defo adugagala:i ganiaba, e da ea gogosiasu dawa:ma:ne eso fesuale agoane dialumu. Amaiba:le, e da fisisu gadili eso fesuale esaloma:ne, sefasima. Amalalu, e ganodini oule misunu da defea.” ");
INSERT INTO beo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ilia da Milia:me fisisu gadili oule asili, fisisu logo ga:le fisiagai. E da eso fesuale gadili ouesalu, amalalu ilia da e bu ganodini oule misi. Amalalu, ilia da bu logoga ahoasu. ");
INSERT INTO beo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ilia da Hasilode soge fisili asili, wadela:i hafoga:i soge ea dio Ba:ila:ne amo ganodini ilia abula fisisu bu hiougi. ");
INSERT INTO beo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Isala:ili fi fagoyale gala afae afae amoga ouligisu dunu afae ilegema. Amalalu, amo dunu fagoyale ilia da Ga:ina:ne soge (amo Na da Isala:ili dunuma imunu gala) amo ea hou hogoma:ne, desega masa:ne asunasima.” ");
INSERT INTO beo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","15","Mousese da Gode Ea hamoma:ne sia:i nabi dagoi. Ilia da Ba:ila:ne wadela:i sogega esalu amola amogawi e da amo ouligisu dunu asunasi. Fi Ouligisu Dunu (Desega Masa:ne Asunasi) Liubene Sia:miua (Sa:ge ea mano) Simione Sia:ifa:de (Houlai ea mano) Yuda Ga:ilebe (Yifane ea mano) Isaga Aiga:le (Yousefe ea mano) Ifala:ime Housia (Nane ea mano) Bediamini Ba:ladai (La:ifiu ea mano) Sebiulane Ga:diele (Soudai ea mano) Ma:na:se Ga:dai (Susai ea mano) Da:ne A:miele (Gima:li ea mano) A:sie Sidie (Maigele ea mano) Na:fadalai Nabi (Fofosai ea mano) Ga:de Giuele (Ma:igai ea mano) ");
INSERT INTO beo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Amo dunu dedei da desega ahoasu dunu amo Mousese da Ga:ina:ne soge ba:la masa:ne asunasi. Mousese da Housia (Nane ea mano) ea dio afadenene, Yosiua dio asuli. ");
INSERT INTO beo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mousese da desega ahoasu dunu asunasilaloba, e da ilima amane sia:i, “Guiguda:nini asili, ga (north) amoga masa. Asili, Ga:ina:ne ga (south) sogega doaga:le, amalu agolo sogega ba:la masa. ");
INSERT INTO beo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Soge ea hou ba:ma. Dunu amo ganodini esalebe ilia idi hogoma. Amola ilia da gasa bagade o gasa hame amo hou hogole ba:ma. ");
INSERT INTO beo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Osobo da ha:i manu heda:mu noga:i o wadela:i hogole ba:ma. Amola dunu da udigili moilai ganodini esala o gasawane gagili sali esala, amo hogoma. ");
INSERT INTO beo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Osobo da nasegagila:? Soge amoga da ifa ganabela:? Amo huluane hogole ba:ma. Amola fage amo sogega galebe, amo bu gaguli misa. (amo oubi ganodini, waini fage da muni yoi agoane hamosu.) ");
INSERT INTO beo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Amaiba:le, ilegei dunu ilia da ga (north) amoga asili, soge amo da ga (south) diala soge amo wadela:i soge Sini amoga muni asili, Lihoube moilai (Ha:ima:de adobo gigadofa ahoasu gadenene) amoga doaga:i. ");
INSERT INTO beo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ilia da hidadea soge ea ga (south) la:idi asili, Hibalone moilai bai bagade amoga doaga:i. Amogawi, dunu bagadedafa fi dunu ilia dio amo da A:ina:ge, amo iligaga fi (Ahaima:ne, Siesai amola Da:lamai) esalebe ba:i. (Ilia da hemonega Hibalone moilai bai bagade hiouginanawane ode fesuale agoane gidigili, Soua:ne moilai bai bagade Idibidi soge ganodini gagui). ");
INSERT INTO beo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Desega ahoasu dunu da Esiegole Fago amoga doaga:le, ilia da waini efe amoda damuni fasili gaguli asi. Amo amodaga legei da waini fage gagabu bagade galu. Amo da dioi bagadeba:le, dunu aduna da amo ifaga la:gili, gisawene ahoasu. Ilia eno ifa fage amo ‘bomegala:nade’ amola ‘figi’ gaguli misi. ");
INSERT INTO beo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","(Amo soge ea dio da Esiegole Fago - dawa:loma:ne da ‘waini fage gagabu’ - Bai amogawi Isala:ili dunu da waini fage damuni fasi). ");
INSERT INTO beo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","26","Desega ahoasu dunu da eso 40amoga soge hogolalu, bu Mousese, Elane amola Isala:ili dunu Ga:idesie soge, wadela:i hafoga:i soge Ba:ila:ne amo ganodini esala, amoga buhagi. Ilia ba:i liligi huluane olelei amola waini fage gagabu ilia gaguli misi, amo olei. ");
INSERT INTO beo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ilia da Mousesema amane sia:i, “Ninia da soge huluane noga:le ba:i. Osobo da noga:i amola nasegagi. Amo soge ea ha:i manu fage afae da goea. ");
INSERT INTO beo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Be dunu fi amogawi esalebe da gasa bagade ba:i. Amola ilia moilai da gasa bagade gagui amola gagili sali agoane hamoi dagoi. Amola ninia da bagadedafa dunu fi, amo A:ina:ge egaga fi, amogawi esalebe ba:beba:le bagade hihini ba:i. ");
INSERT INTO beo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","A:malege fi da amo soge ea ga (south) la:idi esala. Amola agolo soge ganodini, Hidaide dunu fi, Yebiusaide amola A:moulaide dunu esalebe ba:sa. Amola Medidela:inia Hano Wayabo Bagade bega: amola Yodane Hano bega:, amogawi Ga:ina:ne dunu da fi esala. ");
INSERT INTO beo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Isala:ili dunu da Mousesema egane sia:beba:le, Ga:ilebe da ilima ouiya:ma:ne sia:i. E amane sia:i, “Ninia wahadafa ilima doagala:mu da defea. Ninia gasa da amo soge hasalimu defele gala.” ");
INSERT INTO beo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Be desega ahoasu dunu amo da Ga:ilebe ili gilisili asi, ilia amane sia:i, “Hame mabu! Ninia da gasa hame. Amo dunu doagala:mu da hamedei. Amo dunu ilia gasa da ninia gasa baligi dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Amaiba:le ilia da eno Isala:ili dunuma ilia soge ba:i amoga ogogole ba:i sia:ne olelei. Ilia amane sia:i, “Amo soge da ha:i bagade. Ha:i manu heda:i da esalebe dunu amo sadimu hamedei. Dunu huluane ninia ba:i da sedadedafa. ");
INSERT INTO beo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ninia da A:ina:ge egaga fi dunu bagadedafa ba:i. Ninia da ilia da:i ba:beba:le, ninia da:i da danuba: agoane defele dawa:i. Amola ilia da nini ba:beba:le, danuba: defele agoane dawa:i. ");
INSERT INTO beo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Amo gasia, daeya asili hahabe, Isala:ili dunu da se nabawane dinanu. ");
INSERT INTO beo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ilia da Mousese amola Elane elama eganewane agoane sia:dasu. Ilia da amane sia:i, “Ninia da Idibidi sogega o guiguda: hafoga:i soge amo ganodini bogomu da defea galu. ");
INSERT INTO beo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Hina Gode da abuliba:le nini Ga:ina:ne sogega oule ahoabela:? Ninia da gegesu ganodini medole legei dagoi ba:mu amola ninia uda amola mano huluane gagulaligi dagoi ba:mu. Ninia da Idibidi sogega buhagimu da defea. ");
INSERT INTO beo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Amaiba:le, ilia da gilisili amane sia:dasu, “Defea! Ninia da gaheabolo ouligisu dunu eno ilegele, Idibidi sogega buhagimu.” ");
INSERT INTO beo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Amalalu, Mousese amola Elane ela da dunu gilisisu ilia midadi osoboga begudui. ");
INSERT INTO beo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Amola Yosiua (Nane egefe) amola Ga:ilebe (Yifane egefe), desega ahoasu dunu aduna, ela da se nababeba:le, abula gadelale, ");
INSERT INTO beo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Isala:ili dunuma amane sia:i, “Soge ninia ba:i amo da soge noga:iwanedafa. ");
INSERT INTO beo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Hina Gode da ninia hou hahawane ba:sea, E da nini amoga oule asili, amola amo soge ida:iwane amola nasegagi ninima imunu. ");
INSERT INTO beo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Dilia! Hina Godema mae odoga:ma! Amola dunu fi amogawi esala ilima mae beda:ma! Ninia da ilima hedolowane hasalimu. Hina Gode da nini esala. Amola e da ogogosu ‘gode’ liligi amo da ili gagui, E da amo hasali dagoi. Amaiba:le, mae beda:ma!” ");
INSERT INTO beo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Isala:ili dunu huluane da Mousese, Elane, Ga:ilebe amola Yosiua amo ili igiga medole legemusa:, magagisu. Be hedolodafa, Hina Gode Ea sinenemegi hadigi da Abula Diasu gadodili doaga:i. Amola Isala:ili da Gode Ea sinenemegi hadigi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Hina Gode da Mousesema amane sia:i, “Amo dunu da bu habowali seda Nama higa:ma:bela:? Na da ilia gilisisu ganodini, gasa bagade degabo ba:i hou bagohame hamosu. Be ilia da Na hou dafawaneyale hame dawa:sa. ");
INSERT INTO beo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Na da ili wadela:lesima:ne, olo bagade ilima iasimu. Be Na da di amo dunu fi da Isala:ili fi ilia idi amola ilia gasa amo bagade baligisa, amo hamomu. Amola di da amo gaheabolo fi ilima ada esalumu.” ");
INSERT INTO beo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Be Mousese da Hina Godema bu adole i, “Di da Dia gasaga amo dunu Idibidi fisili masa:ne, goeguda: oule misi. Idibidi dunu da Dia hou waha sia:i amo Dia dunu fi ilima hamoi amo nabasea, ");
INSERT INTO beo_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ilia da dunu amo da Ga:ina:ne soge ganodini esala, ilima olelemu. Ga:ina:ne dunu da Dia hou nabi dagoi. Di, Hina Gode, da nini esala. Dia mobi ganumu da ninima gadodili aligisia, Di, Hina Gode da esalebe amo ba:beba:le, dunu huluane dawa:. Ilia da ba:i dagoi. Di da esoga mu mobi ganumu ganodini bisili ahoa amola gasia, lalu ganumu ganodini bisili ahoa. ");
INSERT INTO beo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Be Di da wali Dia fi dunu huluane medole legesea, dunu fi amo da Dia gasa bagade hou nabi dagoi, amo ilia da amane sia:mu, ");
INSERT INTO beo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Di da hafoga:i soge ganodini Dia fi dunu medole legei. Bai Di da soge amo Di ilima ima:ne ilegei, amoga oule masunu hamedei ba:i. ");
INSERT INTO beo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Amaiba:le, wali Hina Gode, na da Dima edegesa. Dia gasa bagade hou ninima olelema. Dia musa: ilegele sia:i defele hamoma. ");
INSERT INTO beo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Bai Di amane sia:i, ‘Na, Hina Gode, da hedolo hame ougisa. Na da asigi hou bagade olelesa. Amola wadela:i hou amola lelesu hou amo gogolema:ne olofosa. Be ada amola ame da wadela:le hamosea, Na da mano amola elagaga fifi ahoabe osoda amola amo baligi biyadu fifi ahoabe ilima se dabe imunu.’ ");
INSERT INTO beo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Wali, Hina Gode, Dia noga:iwane gasa bagade hou amola Dia afadenemusa: hame dawa: asigi hou defele, amo dunu ilia wadela:i hou gogolema:ne olofoma. Ilia da Idibidi fisili, asili, goeguda: doaga:le, Di da ilia hou gogolema:ne olofoi. Amo defele, ilia wali hou hamoi amo gogolema:ne olofoma.” ");
INSERT INTO beo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Hina Gode da bu adole i, “Dia adole ba:su defele, Na da ilia hou gogolema:ne olofomu. ");
INSERT INTO beo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Be Na da dafawane ilegele sia:sa. Na da esala amola Na da osobo bagade nabasa, amo da dafawane. Amo defele, ");
INSERT INTO beo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Isala:ili dunu huluanedafa da Ga:ina:ne soge ganodini mae golili sa:ili, bogomu. Ilia da Na sinenemegi hadigi ba:i dagoi. Ilia da Na degabo ba:i gasa bagade hou Na da Idibidi amola hafoga:i soge ganodini hamoi, amo huluane ba:i dagoi. Be ilia da Na ilima ougima:ne, hame nabasu hou bagade hamonanu. ");
INSERT INTO beo_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ilia da soge amo Na da ilia aowalali ilima imunu ilegele sia:i, amo ganodini hamedafa golili sa:imu. Dunu huluane Nama higasu, ilia da ganodini hamedafa masunu. ");
INSERT INTO beo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","- ");
INSERT INTO beo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Be Na hawa: hamosu dunu Ga:ilebe, amo ea hou da hisu. E da Nama fuligala:su hou hame yolesi. Na da soge amo e da hogola asi, amo ganodini oule masunu. Egaga fi da Ga:ina:ne soge (amo ganodini wali A:malege dunu amola Ga:ina:ne dunu esala) amo noga:le gagumu. Be dilia huluane, sinidigili, hafoga:i soge Agaba Gogomai la:idiga gala, amoga masa.” ");
INSERT INTO beo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Hina Gode da Mousese amola Elane elama amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Amo wadela:i dunu da habowali seda Nama egane sia: sia:nanoma:bela:? Na da ilia egane sia: bagade nabala helebe. ");
INSERT INTO beo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Wali, ilima agoane adole ima, ‘Na da esalebe amo defele, dima dafawane agoane sia:sa. Na da dilia adole ba:su defele dilima hamomu. Na, Hina Gode da sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Dilia da bogomu amola dilia da:i hodo da amo hafoga:i sogega afagogoi dagoi ba:mu. Dunu huluane amo da lalelegele, ode20 baligi da Ga:ina:ne soge ganodini hame golili sai:mu. Bai dilia da Nama egane sia:dalu. ");
INSERT INTO beo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Na da dili amo soge ganodini hahawane esaloma:ne sia:i. Be dilia afaega da hamedafa agoai hamomu. Ga:ilebe amola Yosiua, ela fawane da ganodini masunu. ");
INSERT INTO beo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Dilia da dilia mano da ha lai dunuga gagulaligi dagoi ba:mu, amane sia:i. Be Na da dilia mano amo soge dilia higasu amo ganodini oule masunu. Amola ilia da amo ganodini hahawane fimu. ");
INSERT INTO beo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Be dilia da guiguda: amo hafoga:i soge ganodini bogomu. ");
INSERT INTO beo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Dilia mano da wadela:i hafoga:i soge ganodini ode 40 amoga udigili lalumu. Ilia da dilia dafawaneyale hame dawa:su houba:le, se nabimu. Dilia huluane da bogoi dagoiba:le fawane, amo hou fisi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Dilia da ode 40 amoga, dilia wadela:i hou dabe se nabasu ba:mu. Dilia da eso40 amoga, Ga:ina:ne soge ea hou ba:i. Amo eso idi defele, dilia da ode 40 se nabimu. Na da dilima ha lai hamoi dagoi, amola dilia da amo hou dawa:mu. ");
INSERT INTO beo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Na da dafawane sia:sa! Dilia da wadela:i hamosu dunu amola Nama ha lamusa: gilisi. Amaiba:le, Na da amo hou dilima hamomu. Goeguda: hafoga:i soge ganodini, dilia huluane da bogogia:mu. Na, Hina Gode, da sia:i dagoi!” ");
INSERT INTO beo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Desega ahoasu dunu amo Mousese da Ga:ina:ne soge ea hou ba:lamasa:ne asunasi, ilia da bu misini ogogole ba:i amane sia:ne i dagoiba:le, Isala:ili dunu da Hina Godema egane sia:i. Amaiba:le, Hina Gode da ilima olo bagade iabeba:le, ilia da bogogia:i. ");
INSERT INTO beo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Desega ahoasu dunu fagoyale gala da musa: asi. Be Yosiua amola Ga:ilebe ela fawane hame bogoi. ");
INSERT INTO beo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mousese da Hina Gode Ea sia:i amo Isala:ili dunuma olelebeba:le, ilia da ha:giwane didigia:i. ");
INSERT INTO beo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Golale hahabedafa, ilia da Ga:ina:ne agolo soge amoga doagala:le golili sa:imusa: asi. Ilia da amane sia:i, “Dafawane! Ninia da wali soge amo Hina Gode da ninima olelei, amoga masunu. Ninia da wadela:le hamoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Be Mousese da amane sia:i, “Amaiba:le, dilia da abuliba:le wali bu Hina Godema hame nabasu hou hamosala:? Dilia da hame didili hamoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mae masa! Hina Gode da dilia gilisili hame esala. Dilia ha lai da dili hasalimu. ");
INSERT INTO beo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Dilia da A:malege amola Ga:ina:ne dunu gegesu ganodini ba:le ganosea, dilia amo gegesu ganodini bogogia:mu. Hina Gode da dili hame fidimu. Bai dilia Ema fa:no bobogemu higasu.” ");
INSERT INTO beo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Be ilia da Mousese ea sia: mae nabawane, gasa fili, Ga:ina:ne agolo sogega asi. Be Hina Gode Ea Gousa:su Sema Gagili amola Mousese da mae asili, fisisu ganodini dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalalu, A:malege dunu amola Ga:ina:ne dunu amogawi esalu da ilima doagala:le, ili hasali dagoi. Ilia da Isala:ili dunu sefasili, fa:no bobogele, Homa moilai bai bagade amoga doaga:beba:le fawane fisiagai. ");
INSERT INTO beo_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","2","Hina Gode da Mousesema hamoma:ne sia:i. E da amo sema Isala:ili dunu da soge E da ilima imunu amo ganodini noga:le fa:no bobogema:ne sia:i. Hamoma:ne sia:i da agoane, ");
INSERT INTO beo_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","“Bulamagau gawali, sibi gawali sibi o goudi da Hina Godema Gobei Iasu (Wadela:i Hou Dabe Ima:ne Iasu) o dafawane ilegele sia:i hahamoma:ne gobele salasu o udigili iasu o Godema nodoma:ne lolo Nasu iasu amo Hina Godema imunu da defea. Hina Gode da amo ha:i manu iasu gabusiga: agoane hahawane naba. ");
INSERT INTO beo_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Nowa da sibi o goudi Hina Godema Gobei Iasu hamoma:ne gaguli masea, e da ohe afae gaguli masea, gilisili gilogala:me afae falaua amola olife susuligi lida afae amola waini hano lida afae gaguli misa:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","7","Sibi gawali iasea, falaua gilogala:me aduna amola olife susuligi 1 1/2 lida (gala:ine iasu) amola waini hano 1 1/2 lida gaguli misa:ne sia:ma. Hina Gode da amo iasu ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Dilia bulamagau gawali gobei iasu o dafawane ilegei sia: hahamoma:ne o Hahawane Gilisili Olofole Iasu Hina Godema iasea, ");
INSERT INTO beo_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","10","gala:ine iasu amo falaua3 gilogala:me amola olife susuligi 2 lida amola waini hano 2 lida gilisili ima. Amo gobele salasu ea gabusiga: amo Hina Gode da hahawane naba. ");
INSERT INTO beo_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Amola bulamagau gawali o sibi gawali o sibi o goudi iasea, amo liligi gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ohe afae iasu baligisia, gilisili iasu amola amo defele baligili ima. ");
INSERT INTO beo_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Isala:ili dunudafa da ha:i manu iasu Hina Gode ea gabusiga: hahawane nabima:ne amo iasea, agoane ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Amola ga fi dunu dilia fi amo ganodini esala (eso huluane esaloma:ne o sofe misi fawane), e da Hina Godema gabusiga: hahawane nabima:ne ha:i manu iasu iasea, e amola da amo hamoma:ne sia:i defele hamomu. ");
INSERT INTO beo_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Isala:ili dunu amola ga fi dilia fi amo ganodini esala dilia amo hamoma:ne sia:i mae fisili, eso huluane hamonanoma:mu. Dilia Isala:ili dunu amola ga fi dunu da hisu hame - Hina Gode da dilia huluane defele ba:sa. ");
INSERT INTO beo_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Hamoma:ne sia:i amola malasu da dili huluane defele agoane dialumu. ");
INSERT INTO beo_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","18","Hina Gode da Mousesema eno hamoma:ne sia:i. E da amo hamoma:ne sia:i Isala:ili dunu da soge E da ilima imunu amo ganodini noga:le fa:no bobogema:ne sia:i. Hamoma:ne sia:i da agoane. ");
INSERT INTO beo_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Ha:i manu Ga:ina:ne sogega heda:i amo nasea, mogili amo Hina Godema imunusa: la:ididili ligisima. ");
INSERT INTO beo_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Dilia agi gobesea, bisili ga:gi gagoma gaheabolo amoga hamoi, amo Hina Godema iasudafa hamoma:ne ima. Amo Ema iasea, gagoma dilia faili daba sali, amo iasu defele Ema ima. ");
INSERT INTO beo_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dilia amo agi gobei iasu amo eso huluane mae fisili sema agoane hamonanoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Be dunu da mae hanane amola mae dawa:le, sema amo Hina Gode da Mousesema i, amo mogili hame hamosea, ");
INSERT INTO beo_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","amola eso enoga hobea, Isala:ili dunu fi da Hina Gode Ea Mousesema sia:i liligi amo hame hamosea, ");
INSERT INTO beo_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ilia hame dawa:beba:le, giadofale hamoi galea, agoane hamoma. Ilia da bulamagau gawali gobei iasu (Hina Gode da gabusiga: agoane hahawane nabima:ne) gobele salima:ne sia:ma. Amoga ilia da gala:ine iasu amola waini iasu sema defele imunu. Amola amoga ilia da goudi gawali Wadela:i Hou Gogolema:ne Olofoma:ne Iasu gilisimu. ");
INSERT INTO beo_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Gobele salasu dunu da Isala:ili fi dodofema:ne hou hamonanu, ilia wadela:i hou da gogolema:ne olofoi dagoi ba:mu. Bai ilia da mae dawa:le giadofai amola ilia Wadela:i Hou Gogolema:ne Olofoma:ne Iasu ilia da Ha:i Manu iasu agoane Hina Godema i. ");
INSERT INTO beo_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Isala:ili fi dunu huluane amola ga fi ilia gilisisu ganodini esala da gogolema:ne olofosu ba:mu. Bai dunu huluanedafa da amo giadofasu hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Dunu afae fawane da mae dawa:le giadofasea, e da ode afae lalelegei goudi aseme amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu amo ima:mu. ");
INSERT INTO beo_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Gobele salasu dunu da oloda amoga asili, amo dunu ea wadela:i hou fadegama:ne, wadela:i hou dodofesu hou hamomu. Amasea, amo dunu da gogolema:ne olofoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Dunu huluanedafa, Isala:ili dunudafa o ga fi Isala:ili ganodini misi esala, e da mae dawa:le giadofasea, da amo sema hamomu. ");
INSERT INTO beo_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Be nowa dunu, Isala:ili dunudafa o ga fi Isala:ili fi ganodini misi esala, da hi dawa:i amoane wadela:i hou hamosea, e da Hina Gode Ea hou higabeba:le, medole legei dagoi ba:ma:mu. ");
INSERT INTO beo_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Bai e da Hina Gode Ea sia:i liligi higale, Ea sema afae hame hamoi. E da hi giadofale hamobeba:le, bogosu ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Eso afaega, Isala:ili dunu fi da wadela:i hafoga:i sogega esaloba, dunu afae da Sa:bade esoga lalu habelalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ilia da amo dunu Mousese, Elane amola Isala:ili fi gilisisu amoga oule misi. ");
INSERT INTO beo_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ilia da amo dunu mae hobeama:ne, sosodo ouligisu dunuga ouligima:ne sia:i. Bai ilia da amo dunuma adi hou hamoma:bela:le gogolei. ");
INSERT INTO beo_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Amalalu, Hina Gode da Mousesema amane sia:i, “Amo dunu medole legema! Isala:ili fi dunu huluanedafa da amo dunu fisisu gadili oule asili igiga gala:le, medole legema:ne sia:ma.” ");
INSERT INTO beo_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Amaiba:le, Hina Gode Ea hamoma:ne sia:i defele, Isala:ili fi dunu huluane da amo dunu fisisu gadili oule asili, igiga gala:le, medole legei. ");
INSERT INTO beo_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Isala:ili dunuma amane sia:ma, ‘Dilia abula hegomai fe amoga sosofe nodomema. Sosofe huluane amoga haisewe efe la:gima. Eso huluane mae fisili, amo hou hamonanoma:ma. ");
INSERT INTO beo_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Amo sosofe ilia bai da Na sema bu dawa:ma:ne dialumu. Amo ba:sea, dilia da Na sema bu dawa:le, nabawane hamomu. Amasea, dilia da Nama fa:no bobogesu fisili, dilia hanai amoga fa:no bobogesu amo hamedafa hamomu. ");
INSERT INTO beo_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Sosofe ba:sea, dilia da Na sia:i liligi huluane noga:le hamoma:ne bu dawa:mu. Amola, dilia da dafawane Na: fi dunu fawane esalumu. ");
INSERT INTO beo_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Na da dilia Hina Gode! Na da dilia Gode esaloma:ne, dili Idibidi sogega fisili masa:ne, ga oule asi. Na da Hina Gode!” ");
INSERT INTO beo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Goula (e da Aisiha ea mano amola ea fi da Lifai amola ea sosogo fi da Gouha:de), e da gasa fili, Mousesema odoga:i. Liubene fi dunu udiana (Ilaia:be ea mano aduna amo Da:idia:ne, Abaila:me amola Bilede ea mano amo One) amola Isala:ili fi ouligisu dunu 250 (Isala:ili fi dunuga ilegei ouligisu dunu) ilia da Goula gilisili Mousesema odoga:i. ");
INSERT INTO beo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ilia da Mousese amola Elane ela midadi gilisili, amane sia:i, “Alia hou da gasa fili, baligi dagoi! Ninia fi dunu huluane da Hina Gode Ea:! Amola Hina Gode da nini huluane gilisili esala! Amaiba:le, Mousese, di abuliba:le ninima hina agoane hamosala:?” ");
INSERT INTO beo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mousese da amo sia: nababeba:le, hi osoboga gala:lasa:ili, Godema sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Amasea, e da Goula amola ema fa:no bobogesu dunu ilima amane sia:i, “Aya hahabe, Hina Gode da nowa da Ea: fidafa, amo olelemu. E da Ea ilegei dunu, Ema oloda gadenene doaga:ma:ne logo doasimu. ");
INSERT INTO beo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Aya hahabe, dilia amola dilia fa:no bobogesu dunu, amo lalu gasa:le legesu ofodo lale, amo ganodini laluoso amola gabusiga: manoma salawane, oloda amoma gaguli misa. Amasea, ninia da Hina Gode Ea ilegei dunu dawa:mu. Dilia Lifai dunu, dilia fawane da gasa fili baligi dagoi!” ");
INSERT INTO beo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mousese da bu Goula ema amane sia:i, “Dilia Lifai dunu! Nabima! ");
INSERT INTO beo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Isala:ili Gode da dili eno Isala:ili fi amoga afafai dagoi. Bai dilia da Ema misini, Hina Gode Ea Abula Diasu ganodini hawa: hamoma:ne amola Isala:ili fi ilima fidisu hou hamoma:ne E da dilima ilegei. Dilia adi dawa:bela:? Amo da hamedei hou, dilia dawa:bela:? ");
INSERT INTO beo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Hina Gode da amo gadodafa nodoma:ne hou dilima i dagoi. Be amo mae dawa:le, dilia da gobele salasu hou amola lamusa: dawa:lala. ");
INSERT INTO beo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Dilia da Elanema egane sia:sea, dilia da ema hame egasa. Be dilia dafawane Hina Gode Ema egane odoga:sa.” ");
INSERT INTO beo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Amalalu, Mousese da Da:ida:ne amola Abaila:me ela ema misa:ne sia:si. Be ela da amane sia:i, “Ania da hame misunu! ");
INSERT INTO beo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Di da nini Idibidi nasegagi soge amoga fisili masa:ne, goeguda: wadela:i soge ganodini medole legema:ne oule misi. Amo da defeala:? Be amo baligili, di abuliba:le ninima hina agoane hamosala:? ");
INSERT INTO beo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Di da ninima nasegagi soge amola soge amola waini sagai ninia gaguma:ne hamedafa i. Amola wali di da ninima ogogomusa: dawa:lala. Ania da hamedafa misunu.” ");
INSERT INTO beo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mousese da ougi bagade ba:i. E da Hina Godema amane sia:i “Amo dunu da Dima iasu gaguli masea, mae lama! Na da ilia dunu afae amoma wadela:le hamedafa hamoi. Na da ilia dougi afae hamedafa lai.” ");
INSERT INTO beo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mousese da Goula ema amane sia:i, “Aya, di amola dia 250 fa:no bobogesu dunu amo Hina Gode Ea Abula Diasuga misa. Elane amola da amogawi esalebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Dilia afae afae laluoso gasa:le legesu lale, gabusiga: manoma amoga ligisili, oloda amoga gaguli misini, olelema.” ");
INSERT INTO beo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Amaiba:le, ilia da dunu afae afae da ilia laluoso gasa:le legesu lale, amo ganodini laluoso amola gabusiga: manoma salawane, ilia amola Mousese amola Elane da Abula Diasu holeiga lelu. ");
INSERT INTO beo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Amalalu, Goula da Isala:ili fi huluane gilisili, ilia da Mousese amola Elane ela midadi Abula Diasu ea logo holeiga lelu. Amalalu, hedolowane, Hina Gode E esalagalebeia dawa:loma:ne sinenemegi hadigi da dunu huluane ba:ma:ne misi. ");
INSERT INTO beo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Hina Gode da Mousese amola Elanema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Masa! Amo dunuma mae gilisima! Na da wahadafa ili dafawanedafa wadela:lesimu!” ");
INSERT INTO beo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Be Mousese amola Elane da osoboga mi bugila sa:ili, beguduli, amane sia:i, “Gode! Di da esalusu huluane ea bai gala. Dunu afae fawane da wadela:le hamoiba:le, Di da fi dunu huluane ilima ougima:bela:?” ");
INSERT INTO beo_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Dunu huluane ilia da Goula, Da:ida:ne amola Abaila:me ilia abula diasu yolesili, sogebi enoga masa:ne sia:ma!” ");
INSERT INTO beo_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Amalalu, Mousese, amola Isala:ili ouligisu dunu, ilia da Da:ida:ne amola Abaila:me elama asi. ");
INSERT INTO beo_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mousese da Isala:ili dunu ilima amane sia:i, “Amo wadela:i hamosu dunu ilia abula diasu yolesili, gadenene mae leloma! Ilia liligi huluanedafa mae digili ba:ma! Dilia agoane hame hamosea, dilia da ilia wadela:i hamoiba:le bogobe defele, dilia amola da bogomu.” ");
INSERT INTO beo_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Amaiba:le, Isala:ili dunu da Goula, Da:ida:ne amola Abaila:me ilia abula diasu yolesili asi. Da:ida:ne amola Abaila:me da ilia abula diasuga gadili asili, ela, elea uda amola mano da abula diasu logo holeiga lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mousese da Isala:ili dunu ilima amane sia:i, “Dilia waha ba:mu liligi amoga, Hina Gode da na amo hou hamoma:ne asunasi amo dawa:mu. Amola na da na hanaiga hame hamoi amo dawa:mu. ");
INSERT INTO beo_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Amo dunu da osobo bagade dunu ilia esalusu hou defele, Gode Ea se dabe mae lale, udigili bogosea, defea, Hina Gode da na hame asunasi dawa:ma. ");
INSERT INTO beo_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Be Hina Gode da hou musa: hame ba:i hamosea, amola osobo ea lafi da dagale, dunu amola ilia liligi huluane amo mogo salasea, amola ilia esaleawane udigili bogoi sogega gudu dasea, amo dunu da Hina Gode da ilima higale yolesi dagoi dilia da dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mousese da sia:i dagoloba, hedolowane Da:ida:ne amola Abaila:me ela lelebe hagudu dialu osobo da lafi agoane dagale gai. ");
INSERT INTO beo_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Osobo da ela amola elea sosogo fi amola Goula ea fa:no bobogesu dunu amola ilia liligi huluane amo mogosali dagoi. ");
INSERT INTO beo_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Amaiba:le, ilia amola ilia liligi huluane da mae bogole, bogoi sogega gudu sa:i. Ilia gudu sa:i dagoloba, osobo ea lafi da bu ga:si. Ilia da bu hamedafa ba:i. ");
INSERT INTO beo_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Isala:ili dunu huluane da disa wesu nababeba:le, hobea:i. Ilia da amane wei, “Hobea:ma! Osobo da nini amola mogosalasa:besa:le, hehenama!” ");
INSERT INTO beo_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Amalalu, Hina Gode da lalu iasi. Amo da nene gadole, dunu250 amo da gabusiga: manoma i, amo huluane nei dagoi. ");
INSERT INTO beo_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Amalalu, Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Elia:isa (gobele salasu dunu Elane egefe) ema, e da balase laluoso gasa:le legesu amo dunu laluga nei ilia da:i hodo amo lale, laluoso amo da ilia laluoso gasa:le legesu ganodini diala amo soge enoga afagogoma:ne sia:ma! Bai amo laluoso gasa:le legesu da hadigi ilegei gala. ");
INSERT INTO beo_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ilia da Hina Gode Ea oloda amoga i dagoiba:le, hadigi hamoi dagoi. Amaiba:le, amo dunu (ilia da wadela:le hamoiba:le medole legei dagoi ba:i) amo ilia laluoso gasa:le legesu lale, dadabili, abenale da:fe hamone, amoga oloda dedebosu hamoma. Amo da Isala:ili dunuma sisasu dawa:loma:ne agoane ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Amaiba:le, gobele salasu dunu Elia:isa da laluoso gasa:le legesu lale, da:fe abenai hamoma:ne sia:i. Amalalu, ilia da amoga oloda dedeboi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Amo da Isala:ili dunu ilima sisasu agoane ba:i. Sisasu da Elane egaga fi, ilia fawane da Hina Godema gabusiga: manoma ulagima:ne, oloda amoga doaga:mu da defea. Be eno dunu da amai hamonanu, e da Goula amola ea fa:no bobogesu dunu amo wadela:lesi dagoi ba:mu. Amo hou, Hina Gode da Mousesema, e da Elia:isama alofele sia:ma:ne sia:i. ");
INSERT INTO beo_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Eso eno aya amoga, Isala:ili fi dunu huluane da Mousese amola Elane elama egane sia:i, “Alia da Hina Gode Ea fi dunu mogili medole legei.” ");
INSERT INTO beo_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ilia da Mousese amola Elane elama egane sia:musa: gilisi dagoloba, ilia da Abula Diasu ba:musa: sinidigisia, Mu Mobi Ganumu da Abula Diasu dedeboi amola Hina Gode Esalebe dawa:digima:ne sinenemegi hadigi misi dialebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mousese amola Elane da asili, Abula Diasu ea midadi lelu. ");
INSERT INTO beo_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Amola Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Masa! Amo dunu yolesima! Na da amogawi wahadafa ili wadela:lesimu!” Mousese amola Elane ela da odagi osoboa beguduli, ");
INSERT INTO beo_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mousese da Elanema amane sia:i, “Dia laluoso gasa:le legesu lale, oloda amoga laluoso lale, laluoso gasa:le legesu ganodini ligisili, gabusiga: manoma amo laluoso da:iya salima. Amasea hedolowane Isala:ili dunuma gaguli asili, dodofesu hou ilima hamomu. Hedolo! Hina Gode Ea ougi da heda:le, asi dagoi. Olo bagade da dunu fi ganodini mui dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Elane da Mousese ea sia: nababeba:le, ea laluoso gasa:le legesu lale, Isala:ili dunu gilisisu dogoa amo gusu hehenaiya heda:i. E da olo bagade da mui dagoi ba:beba:le, gabusiga: manoma amo laluoso ligisili, dodofesu hou dunu ili dodofema:ne hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Amo hou da olo bagade madelai amo ea logo hedofai. Amalu, Elane da esala dunu la:idi amola bogoi dunu la:idi amoga dogoa lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Dunu da olo bagadeba:le bogogia:i ilia idi da 14,700. Eno da Goula ea lelesuba:le bogoi ili da gilisili hame idi. ");
INSERT INTO beo_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Olo bagade da hedofai dagoi ba:loba, Elane da Mousese Abula Diasu logo holeiga esaloba amogai buhagi. ");
INSERT INTO beo_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Isala:ili dunuma ilia da dima galiamo fagoyale gala ima:ne sia:ma. Amo galiamo da afae afae Isala:ili fi ouligisu dunu fagoyale gala ilia galiamo agoane. Amo dunu ilia dio afae afae amo galiamo damana dedema. ");
INSERT INTO beo_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Amola galiamo amo da Lifai fi ilia galiamo amoga Elane ea dio dedema. Fi ouligisu dunu afae afae da galiamo afae dialebe ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Amo galiamo Na Abula Diasuga gaguli misini, Gode Ea Gousa:su Sema Gagili (amoga Na da di gousa:sa) amo midadi ligisima. ");
INSERT INTO beo_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Amasea Na ilegei dunu ea galiamo da fadagala:mu. Amo hamobeba:le, Na da Isala:ili dunu ilia mae fisili dima egane sia:su amo hedofamu.” ");
INSERT INTO beo_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Amaiba:le, Mousese da Isala:ili dunuma sia:beba:le, ilia ouligisu dunu afae afae da ema galiamo i. Amo galiamo da fi fagoyale afae afae gala, ilia:. Amola ilia da Elane ea galiamo amo galiamo enoma gilisi. ");
INSERT INTO beo_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Amalalu, Mousese da galiamo huluane Abula Diasu amo Hina Gode Ea Sema Gousa:su Gagili midadi amoga ligisi. ");
INSERT INTO beo_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Aya eso amoga, Mousese da Abula Diasu ganodini golili sa:ili, Elane ea galiamo (amo da Lifai fi ilia galiamo) amo da fadagala:i dagoi ba:i. Amo da yebese hamone, sogea hamone, ‘alamode’ fage legei dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mousese da galiamo huluane gaguli asili, Isala:ili dunuma olei. Ilia da hou doaga:i amo ba:lalu, ilia ouligisu dunu afae afae da ilia galiamo bu ili ladi. ");
INSERT INTO beo_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Hina Gode da Mousesema amane sia:i, “Elane ea galiamo amo Gode Ea Gousa:su Sema Gagili ganodini bu salima. Amo da Isala:ili odoga:su dunuma sisasu agoane dialoma:mu. Sisasu da ilia da egasu sia: hame hedofasea, bogomu.” ");
INSERT INTO beo_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mousese da Hina Gode Ea hamoma:ne sia:i defele hamoi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Isala:ili dunu da Mousesema amane sia:i, “Ninia da gugunufinisi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Nowa da Abula Diasu gadenene fawane masea, e da bogomu. Amaiba:le ninia huluane da bogogia:mu agoai galebe.” ");
INSERT INTO beo_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Hina Gode da Elanema amane sia:i, “Dunu da Na Abula Diasu ganodini giadofale hawa: hamosea, di amola dia mano amola Lifai dunu da se dabe nabimu. Be dilia gobele salasu hawa: hamosu ganodini giadofale hamosea, di amola dia mano fawane da se dabe iasu ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Dia fi dunu, Lifai dunu, amo di amola dia mano, Abula Diasu hawa: hamosu fidima:ne oule misa. ");
INSERT INTO beo_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ilia da dia hawa: hamosu noga:le hamoma:ne sia:ma, amola Abula Diasu hawa: hamosu noga:le hamoma:ne sia:ma. Be Hadigi liligi Hadigi Malei Sesei ganodini diala amola Oloda, ilia da hame digili ba:mu. Ilia da amo liligi digili ba:sea, ili amola di, gilisili medole legei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ilia da di amola gilisili hawa: hamomu, amola Abula Diasu hawa: hamosu huluane amo noga:le hamoma:ne sia:ma. Be hame dawa:su dunu da di gilisili mae hamoma:ne sia:ma. Amo da hamedei. ");
INSERT INTO beo_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Di amola diagefelali fawane da Hadigi Malei Sesei amola Oloda amo hawa: hamosu hamomu. Bai Na ougi da Isala:ili dunuma bu heda:sa:besa:le, dilisu fawane hamoma. ");
INSERT INTO beo_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Na da Isala:ili fi amo ganodini, dia fi Lifai dunu amo ilegele, dima hahawane iasu agoane, dima iaha. Ilia da Abula Diasu ganodini hawa: hamoma:ne, Nama momogili gagai dagoi. ");
INSERT INTO beo_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Be Na da di amola dia mano, dilisu da Oloda amola Hadigidafa Momei Sesei amoga gobele salasu hawa: hamosu hamoma:ne ilegei dagoi. Amo hawa: hamosu da dilia hawa: hamosu fawane. Bai gobele salasu hou Na da hahawane iasu fedege agoane dilima fawane i dagoi. Hame dawa:su amola hame ilegei dunu da hadigi liligi gadenene masea, amo dunu medole legema.” ");
INSERT INTO beo_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Hina Gode da Elanema amane sia:i, “Dawa:ma! Na da ha:i manu liligi Nama i amo da gobele salimusa: hame gobele sali, amo huluane Na da dima iaha. Amo da di amola digaga fi mae fisili, eso huluane lamu. ");
INSERT INTO beo_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Hadigidafa iasu amo da oloda da:iya hame gobele sali, amo liligi haguduga dedei da dia: :- Gala:ine Iasu; Wadela:i Hou Gogolema:ne Olofoma:ne Iasu; Dabe Imunu Iasu. Liligi huluane Nama hadigi iasu hamoma:ne i, da di amola dia gofelali, dilia:. ");
INSERT INTO beo_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Dilia amo liligi hadigi sogebi ganodini moma. Amo dunuga fawane manu. Amo liligi da hadigi gala dawa:ma. ");
INSERT INTO beo_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Amola eno hahawane iasu liligi amo Isala:ili dunu da Nama iaha, amo di da lamu. Na da eso huluane, mae fisili di amola dia gofelali amola didiwilali ilima iaha. Dia sosogo fi huluane ledo dodofei dagoiba:le fawane amo manu da defea. ");
INSERT INTO beo_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Na da baligili noga:i degabo fai ha:i manu amo Isala:ili dunu da Nama ode huluane amoga iaha, amo Na da dilima iaha. Amo da olife susuligi, waini hano amola gagoma. ");
INSERT INTO beo_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Amo huluane da dia liligi ba:mu. Dia sosogo fi huluane ledo hamedei, da amo manu defea. ");
INSERT INTO beo_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Liligi huluane Isala:ili soge ganodini amo ilia da Nama udigili momodale ligiagale ilegei, amo da dia:. ");
INSERT INTO beo_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Magobo dunu mano o magobo ohe mano amo Isala:ili dunu da Nama iaha, amo da dia:. Be dunu ilia da mano magobo bu bidi lamusa: dawa:sea, amo di bidiga lama:ne ilegema. Amola magobo ohe amo da sema ganodini ledo hamoi, amo amolawane bidiga lama:ne ilegema. ");
INSERT INTO beo_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Mano lalelegele, oubi afae doaga:sea, Isala:ili ilia malasu defele, silifa fage biyale gala amoga bu bidiga lama:ne ilegema:ma! ");
INSERT INTO beo_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Be magobo bulamagau, sibi amola goudi amo dunu ilia da bu bidi lamu da hamedei. Ilia da dafawane Na: liligi fawane amola amo dilia gobele salima. Ilia maga:me amo oloda la:idi amoga galagama amola ilia sefe amo gobesima. Na da amo gobei gabusiga: hahawane nabimu. ");
INSERT INTO beo_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ilia hu da dia:. Amola sogogea amola baligili noga:i iasu ea lobodafadi emo amola da dia:. ");
INSERT INTO beo_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Na da di, dia gofelali amola didiwilali ilima baligili noga:i iasu Isala:ili dunu da Nama iaha, amo imunu. Amo da gousa:su (fimu da hamedei) Na da di amola digaga fi ilima hamoi dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Hina Gode da Elanema amane sia:i, “Di da soge o diasu amo digaga fi ilima imunusa: hame lamu. Amola, soge afae Isala:ili soge ganodini da dima ilegei hame ba:mu. Bai Na, Hina Gode, da dia esaloma:ne liligi huluane defele esala.” ");
INSERT INTO beo_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Hina Gode da amane sia:i “Na da Lifai fi dunu ilima ‘daide’ (lai liligi huluane nabuane mogili, afae) amo huluane Isala:ili dunu da Nama iaha, amo Lifai dunu ilima i dagoi. Ilia da Na Abula Diasu ouligima:ne hawa: hamobeba:le, Na da amo bidi ilima iaha. ");
INSERT INTO beo_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Isala:ili dunu eno da Na Abula Diasu gadenene hamedafa misunu. Bai ilia da bogosu se dabe iasu lasa:besa:le. ");
INSERT INTO beo_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Waha winini, Lifai dunu ilia fawane da Na Abula Diasu ouligimu. Amola, noga:le hame ouligisia, Na da ilima fawane sia:mu. Amo da eso huluane dialumu sema amola amo sema da digaga fi ilima dialumu. Lifai dunu da soge o diasu Isala:ili soge ganodini hame gagui dialumu. ");
INSERT INTO beo_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Bai Na da ilima ‘daide’ amo Isala:ili dunu da Nama iaha, amo ilima i dagoi. Amaiba:le Na da ili da Isala:ili soge ganodini liligi hame gagui dialumu, ilima sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Hina Gode da Mousesema amane hamoma:ne sia:i, ");
INSERT INTO beo_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Lifai dunu ilima amane sia:ma, ‘Dilia da Isala:ili dunu ilima ‘daide’ amo Hina Gode da dili lama:ne sia:i, amo lasea, dilia amoga ‘daide’ amo bu Hina Godema ima. ");
INSERT INTO beo_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Na da dilia iasu amo ifabi ouligisu dunu ea iasu (gagoma gaheabolo amola waini hano gaheabolo) amo defele ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Amo iasu (Isala:ili dunu ilia ‘daide’ dilima i) da Hina Gode Ea:. Amola amoga dilia ‘daide’ lale, gobele salasu dunu Elanema ima:ma. ");
INSERT INTO beo_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Amo liligi noga:idafa fawane, amoga amo ‘daide’ lama. ");
INSERT INTO beo_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ifabi ouligisu dunu da ‘daide’ ia dagosea, eno la:idi hi gagusa. Amo defele dilia ‘daide’ noga:idafa la:idi amo Hina Godema (amola Elanema) ia dagosea, eno la:idi dilisu lama. ");
INSERT INTO beo_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Dilia amola dilia sosogo fi da nasu sogebi mae dawa:le, udigili manu da defea. Bai amo da dilia hawa: hamosu Abula Diasu ganodini, amo ea bidi lasu gala. ");
INSERT INTO beo_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Dilia da amo huluane nasea, wadela:i hame hou hamosa. Be hidadea baligili noga:idafa ‘daide’ Hina Godema ima. Be Isala:ili dunu ilia hadigi sema iasu noga:le dawa:ma. Dilia da Hina Godema Ea baligili noga:idafa ‘daide’ hidadea mae iawane, amo liligi manu da sema bagade. Agoane hamosea, dilia da medole legei dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Hina Gode da Mousese amola Elane elama amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Isala:ili dunu ilima hamoma:ne sia: amane olelema, ‘Yoi bulamagau aseme amo da afae hame lologoi amola hawa: hamosu hame hamoi, amo oule misini, ");
INSERT INTO beo_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","gobele salasu dunu Elia:isa ema ima. Amasea, amo bulamagau fisisu gadili oule asili, Elia:isa ba:ma:ne, medole legema. ");
INSERT INTO beo_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Amasea, Elia:isa da bulamagau ea maga:me mogili lale, amola ea lobo sogo amoga Abula Diasu midadi amodili fogaga:la:ma:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Amo ohe ea da:i hodo huluane (amola gadofo, hu, maga:me amola gaisa) amo gobele salasu dunu ba:ma:ne, gobesima. ");
INSERT INTO beo_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Amasea, gobele salasu dunu da ‘dolo’ ifa, ‘hisobe’ amoda fili lai amola yoi efe amo lale, bulamagau yoi lalu ganodini amo da:iya galagamu. ");
INSERT INTO beo_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Amolalu, e da ea abula dodofele, hano hi da:i damana sogagala:le amalu e da bu fisisu amo ganodini golili sa:imu da defea. Be e da ledo hamoi dagoi ba:mu. Daeya doaga:beba:le fawane, bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Dunu amo da bulamagau aseme gobele sali, e amola da ea abula dodofele, hano hi da:i amoga sogagala:mu. Be e da ledo hamoi dagoi ba:mu. Daeya doaga:beba:le fawane, bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Amasea, dunu eno (amo da sema ganodini dodofei dagoi dunu), e da bulamagau ea nasubu gagadole, ledo hamedei sogebi amoga gaguli masa:mu. Ilia da nasubu amogawi ouligimu, amasea Isala:ili dunu da amo lale, hano amo da sema ledo dodofema:ne hamosa, amoga gilisimu. Amo hou da wadela:i hou fadegama:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Dunu amo da nasubu gagadoi, amo dunu da ea abula dodofemu. Be e da ledo hamoiba:le, daeya doaga:sea bu ledo hamedei ba:mu. Amo sema da eso huluane dialumu. Isala:ili dunu amola ga fi dunu ili gilisili esalebe, da amo sema defele dawa:laloma:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Nowa da bogoi da:i hodo digili basea da eso fesuale agoane ledo hamoi gala esalumu. ");
INSERT INTO beo_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","E da eso osodaga dodofesu hano amoga dodofemu, amola eso fesu amoga bu amoga dodofelalu, ledo hamedei agoane ba:mu. Be e da eso osoda amola eso fesu amoga hame dodofesea, e da ledo hamoi gala agoane esalumu. ");
INSERT INTO beo_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Nowa da bogoi da:i hodo digili ba:sea amola sema dodofesu hou hame hamosea, e da ledo hamoi dagoi ba:mu. Bai sema dodofesu hano da ema hame sogagala:i. E da Hina Gode Ea Abula Diasu amo wadela:lesisa. Amola amo dunu ilia da Gode Ea fi dunu hame sia:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Dunu afae da abula diasu ganodini bogosea, nowa dunu da e bogoloba amo abula diasu ganodini esalea, o nowa da amo abula diasu ganodini golili dasea, da eso fesuale amoga, ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Amola ofodo amola ganagu amo abula diasu ganodini gala, amo da ga:lu hame galea, amo da ledo hamoi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Nowa dunu amo da medole legei o hisu fawane da diasu gadili bogoi amo digili ba:sea, amola nowa da dunu ea gasa o bogoi uli dogosu amo digili ba:sea, amo dunu da ledo hamone, eso fesuale agoane esalumu. ");
INSERT INTO beo_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Amo ledo hamoi hou fadegama:ne, yoi bulamagau (amo da wadela:i hou fadegama:ne medole legei) amo ea nasubu mogili lale, ofodo ganodini salawane, hano gaheabolo noga:i amoga gilisima. ");
INSERT INTO beo_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Dunu amo da sema ganodini ledo hamedei, e da hidadea hisobe amoda fili lale, hano ganodini gele, amola amo hano ea abula diasu, amola amo ganodini liligi amola dunu huluane, amoga ilima fogaga:ga:la:mu. Amalalu, dunu amo da ledo hamedei, da amo hano, dunu afae amo da dunu gasa o dunu bogoi da:i hodo o bogoi uli dogosu amo digili ba:i, ema foga:ga:la:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Eso osodoga amola eso fesu amoga, ledo hame hamoi dunu da hano amo ledo hamoi dunu amoga fogaga:ga:la:mu. Eso fesu amoga, ledo hame hamoi dunu da amo dunu dafawane dodofemu. E da ea abula dodofelalu, ea da:iga hano sogagala:le, eso dasea e da sema ganodini dafawane dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Nowa dunu da sema ganodini ledo hamoi dagosea, be sema dodofesu hou hame hamosea, e da ledo hamoi dagoiba:le, amaiwane dialumu. Bai sema dodofesu hano da ea da:iga hame gufagagala:i. E da Hina Gode Ea Abula Diasu ledo hamoiba:le, wadela:sa. Amola amo dunu da Gode Ea fi dunu, maedafa sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Amo sema dilia eso huluane mae fisili hamonanoma. Dunu amo da dodofesu hano eno ledo hamoi dunuma foga:ga:la:sa, amo amola da ea abula dodofema:ne sia:ma. Nowa da amo dodofesu hano digili ba:sea, da ledo hamoi dagoiba:le, daeya doaga:sea fawane bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Adi liligi amo ledo hamoi dunu da digili ba:sea da ledo hamoi dialumu. Amola nowa da amo liligi digili ba:sea, e amola da ledo hamoi dagoi ba:mu, amola daeya doaga:sea fawane bu dodofei dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Oubi age ganodini, Isala:ili fi dunu huluane da wadela:i hafoga:i soge amo Sini amoga doaga:le, Ga:idesie sogebi amoga fi dialu. Amogawi, Milia:me da bogole, ilia da ea da:i uli dogone sali. ");
INSERT INTO beo_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ilia fisisu sogebi amoga hano hame dialebe ba:i. Amaiba:le, Isala:ili dunu da Mousese amola Elane elama gegedole, ");
INSERT INTO beo_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","egane sia:i “Ninia da ninia fi Isala:ili dunu eno defele, Hina Gode Ea Abula Diasu midadi bogomu da defea galu. ");
INSERT INTO beo_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Di da abuliba:le nini amo wadela:i hafoga:i sogega oule misibala:? Dia da nini amola ninia ohe fi guiguda: bogoma:ne, goeguda: oule misibala:? ");
INSERT INTO beo_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Amo soge da wadela:idafa. Ha:i manu heda:mu da hamedei. Gagoma da hame - figi fage da hame - waini fage da hame - ‘bomegala:nede’ fage da hame. Hano amola da hame gala. Di abuliba:le nini Idibidi sogega fisili masa:ne, guiguda: oule misibala:?” ");
INSERT INTO beo_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mousese amola Elane da Isala:ili dunu ilia gilisisu fisili, Abula Diasu ea holeiga lelu. Ela da beguduli osoboga mi bugila sa:i. Amalalu, Hina Gode Ea esalebe dawa:loma:ne sinenemegi hadigi da misini, ela da amo ba:i. ");
INSERT INTO beo_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Galiamo amo da Gode Ea Gousa:su Sema Gagili midadi diala, amo lale, di, Elane amo Isala:ili dunu gilisima:ne sia:ma. Amasea, ilia huluane ba:ma:ne, amo igi amoma sia:ma. Amasea, hano da amodili musa: gala:mu. Di da agoane hamosea, hano amo da gele musa: gala:le, dunu huluane amola ilia ohe da amo moma:ma.” ");
INSERT INTO beo_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mousese da Hina Gode Ea sia:i defele, asili, galiamo lai. ");
INSERT INTO beo_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","E amola Elane da Isala:ili fi dunu huluane amo gele midadi gilisi. Amola, Mousese da amane sia:i, “Dilia odoga:su dunu! Nabima! Ania da dili hano moma:ne amo gele fana:dula:?” ");
INSERT INTO beo_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Amalalu, Mousese da galiamo gaguia gadole, gele adunawane fai dagoi. Hano musa:su bagade musa:gala:le amola dunu huluane amola ohe da hano amo maiba:le sadi. ");
INSERT INTO beo_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Be Hina Gode da Mousese amola Elane elama amane gagabuli sia:i, “Alia da Isala:ili dunu amo soge Na da ilima ima:ne ilegele sia:i amoga hame oule masunu. Bai alia dafawaneyale dawa:su hou da gasa hame amola alia da Na hadigi gasa hou amo Isala:ili dunu ba:ma:ne, hame olelei.” ");
INSERT INTO beo_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Amo hou da Meliba sogebi (dawa:loma:ne da ‘egasu’) amoga ba:i. Amogawi Isala:ili dunu da Hina Godema egai amola E da ilima Ea hadigi hou olelei. ");
INSERT INTO beo_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mousese da Ga:idesie sogega sia:ne iasu dunu Idome hina bagade ema asunasi. Ilia da amane sia:i, “Amo sia:ne iasu da dia ‘fi dunu’, Isala:ili fi dunu amoga misi. Ninia se nabasu di dawa:. ");
INSERT INTO beo_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ninia aowalali dunu da Idibidi sogega asili, amogawi ode bagohame esalu. Idibidi dunu da ninia aowalali amola nini se nabima:ne ninima hamosu. ");
INSERT INTO beo_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Amola ninia da Hina Godema Ea nini fidima:ne dini wesu. E da ninia wei amo nabi. E da a:igele dunu asunasili, amo da nini Idibidi sogega fisili masa:ne gadili oule asi. Wali ninia da Ga:idesie sogebi dia soge alalo amoga esala. ");
INSERT INTO beo_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ninia da dia sogedili baligili masunu hanai galebe. Dia ninima logo doasima. Ninia amola ninia ohe da logoba:le fawane masunu. Ninia da dia ifabi amola waini sagai amo ganodini hame masunu amola dia hano nasu amoga hame manu. Ninia da logoba:le fawane, dia sogedili baligimu.” ");
INSERT INTO beo_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Be Idome dunu da bu adole i, “Dilia da hamedafa ninia sogedili masunu. Dilia da amane hamosea, ninia da gadili mogodigili, dilima doagala:mu.” ");
INSERT INTO beo_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isala:ili dunu da amane sia:i, “Ninia da logo bagade amoga fawane masunu. Amola ninia o ninia ohe da dilia hano nasea, ninia da amo dabe dilima imunu. Ninia da logodili fodoma:ne fasimusa: fawane sia:sa.” ");
INSERT INTO beo_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Be Idome dunu da bu adole i, “Hame mabu!” Amalalu, ilia da dadi gagui dunu bagohame gilisili, gadili mogodigili asili, Isala:ili dunu doagala:musa: asi. ");
INSERT INTO beo_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Idome dunu da Isala:ili dunu ilia sogega fadoma:ne masunu logo ga:iba:le, ilia da sinidigili, logo enoga asi. ");
INSERT INTO beo_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isala:ili fi dunu huluane da Ga:idesie fisili, Ho Goumiga doaga:i. ");
INSERT INTO beo_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ho Goumi da Idome soge alalo gadenene gala. Amogawi, Hina Gode da Mousese amola Elane elama amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Elane da soge amo Na da Isala:ili fi ilima imunu ilegei, amoga e da amo soge ganodini hame masunu. E da bogomu. Bai alia da Meliba sogega Na sia:i amo lelei. ");
INSERT INTO beo_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Elane amola egefe Elia:isa amo Ho Goumiba:le heda:ma:ne oule masa. ");
INSERT INTO beo_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Amogawi, Elane ea gobele salasu abula gisa:le, Elia:isa ema gasisalasima.” ");
INSERT INTO beo_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mousese da Hina Gode Ea hamoma:ne sia:i defele hamoi dagoi. Ilia da Isala:ili dunu huluane ba:ma:ne, Ho Goumiba:le heda:i. ");
INSERT INTO beo_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Amogawi, Mousese da Elane ea gobele salasu abula gisa:le, bu Elia:isa ema gasisali. Amogawi, Ho Goumi da:iya dabuagado, Elane da bogoi dagoi. Amalalu, Mousese amola Elia:isa da bu gudu sa:i. ");
INSERT INTO beo_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Isala:ili dunu huluane da Elane ea bogoi nababeba:le, eso30amoga, e dawa:ha heawini didigia:lalu. ");
INSERT INTO beo_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","A:ila:de moilai bai bagade (ga (south) Ga:ina:ne soge ganodini gala) amo ea hina bagade da Isala:ili dunu da A:dalime logoga manebe nababeba:le, e da ili doagala:le, mogili suguli lai. ");
INSERT INTO beo_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Amalalu, Isala:ili dunu da Hina Godema amane dafawaneyale ilegele sia:i, “Di da amo dunu hasalima:ne, nini logo doasisia, ninia da dafawanedafa amo dunu amola ilia moilai huluane Dima momodale ligiagale ilegele, huluane gugunufinisimu.” ");
INSERT INTO beo_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Hina Gode da ilia sia: nababeba:le, E da ili fidi amola ilia da Ga:ina:ne dunu hasali dagoi. Amaiba:le, Isala:ili dunu da amo dunu amola ilia moilai huluane dafawane wadela:lesi. Ilia da amo soge ‘Homa’ (dawa:loma:ne da wadela:lesisu) dio asuli. ");
INSERT INTO beo_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isala:ili dunu da Idome sogega sisiga:ma:ne, Ho Goumi fisili, logo amo da Agaba Gogomai doaga:musa: asi. Be logoga ahoanoba, ilia da bu da:i dione, egasu. ");
INSERT INTO beo_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ilia da Godema amola Mousesema amane egai, “Dia abuliba:le nini Idibidi sogega fisili masa:ne, amo wadela:i ha:i manu amola hano hame hafoga:i sogega nini bogoma:ne, nini oule misibala:?” ");
INSERT INTO beo_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Amalalu, Hina Gode da wadela:i medosu sania Isala:ili dunuma asunasi. Isala:ili dunu bagohame da amoga gasomaiba:le, bogogia:i. ");
INSERT INTO beo_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Isala:ili dunu da Mousesema misini, amane sia:i, “Dafawane! Ninia da di amola Hina Gode alima ougili egane sia:beba:le, wadela:i bagade hamoi. Wali, Hina Gode da amo sania fadegama:ne, Ema sia:ne gadoma!” Amaiba:le, Isala:ili dunu fidima:ne, Mousese da sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Amalalu, Hina Gode da Mousesema e da balasega sania hamoma:ne sia:i. E da amo sania, ifa amoga gosagisima:ne sia:i. Amalalu, nowa dunu da saniaga gasomai galea, e da amo sania ifaga gosagisi ba:beba:le, e da uhi dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Amaiba:le, Mousese da balasega sania hamone, ifaga gosa:gisi. Nowa da sania amoga gasomai galea, e da amo sania balasega hamoi ba:loba, uhinisi dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isala:ili dunu da bu asili, Oubode sogebi fonobahadi ouesalu, ");
INSERT INTO beo_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","asili, ilia da wadela:i hafoga:i soge Moua:be soge ea gusu la:idi diala, A:balime sogebi amoga fi esalu. ");
INSERT INTO beo_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Amalalu, bu asili, ilia da Silede Fago amoga fi galu. ");
INSERT INTO beo_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Amo yolesili, asili, ilia da Anone Hano ea ga (north) bega: fisisu hamoi. Amo sogebi da wadela:i hafoga:i soge A:moulaide soge ganodini diala. (Anone Hano da alalo amo da Moua:be soge amola A:moulaide soge afafasa.) ");
INSERT INTO beo_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Amaiba:le, ‘Hina Gode Ea Gegesu Buga’ amo ganodini da agoane dedei gala, “moilai Wahebe amo da Soufa soge ganodini amola fago soge ganodini amola Anone Hano, ");
INSERT INTO beo_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","amola fago ilia bega: asili A moilai amola Moua:be alalo defei gadenene diala.” ");
INSERT INTO beo_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Amo yolesili, ilia da sogebi ea dio amo Si Hano amoga asi. Amogawi, Hina Gode da Mousesema amane sia:i, “Dunu huluane gilisima! Amasea, Na da ilima hano imunu!” ");
INSERT INTO beo_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Amo esoga, Isala:ili dunu da amane gesami hea:i, “Si hano! Dilia hano hamoma! Amasea, ninia da amo hano gesami hea:suga yosia:mu! ");
INSERT INTO beo_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Amo si hano uli dogoi da hina bagade ilia mano amola ouligisu dunu ilia dogoi. Ilia da hina bagade ea galiamo amoga, amola ilia dagulu amoga dogoi.” Isala:ili dunu da wadela:i hafoga:i soge yolesili, Ma:dana sogega asi. ");
INSERT INTO beo_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Amo yolesili, ilia da Naha:iliele sogebiga asili esalu, asili Ba:imode sogega asi. ");
INSERT INTO beo_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Amalalu, ilia da Ba:imode fisili, asili, Moua:be dunu ilia sogega asi. Amo soge da Bisiga Goumi ea gouha dialu. Midadi da wadela:i hafoga:i soge ba:i. ");
INSERT INTO beo_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Amalalu, Isala:ili dunu da A:moulaide hina bagade Saihone ema sia:ne iasu dunu asunasi. ");
INSERT INTO beo_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Ilia da amane sia:i, “Ninia da dia sogedili baligili masa:ne, ninima logo doasima! Ninia amola ninia ohe da logo bagade hame yolesimu. Ninia da dia ifabi amola waini sagai amoga hame heda:mu. Ninia da dia hano uli dogoi amoga, hano hame manu. Ninia da dia soge ganodini, logodili fodoma:ne fasimusa: fawane ahoanumu.” ");
INSERT INTO beo_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Be Saihone da Isala:ili dunu ilia logo hedofai dagoi. E da ea dadi gagui dunu gagadole, gadili asili, Ya:iha:se sogebi wadela:i hafoga:i sogega amogawi Isala:ili dunu doagala:i. ");
INSERT INTO beo_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Be Isala:ili dunu da amo gegesu ganodini, ilia ha lai dunu bagohame medole legei. Ilia da A:moulaide soge amo Anone Hano asili Ya:boge Hano amo soge dogoa dialu huluane fedelale, fi dialu. Ya:boge Hano da A:monaide dunu fi ilia soge alalo defei gala. Ilia da amo hame giadofai, bai A:monaide dunu da amo alalo defei gasawane gaga:su. ");
INSERT INTO beo_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isala:ili dunu da A:moulaide dunu ilia moilai huluane amo doagala:le, fedelai dagole, amo ganodini fi. Ilia da Hesiabone amola moilai huluane amo sisiga:le dialu, fedelai dagoi. ");
INSERT INTO beo_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesiabone da A:moulaide hina bagade Saihone, amo ea bisili moilai bai bagade. Saihone da musa: Moua:be hina bagade ema gegei galu. E da ea soge huluane asili Anone hano, amo huluane fedelai dagoi. ");
INSERT INTO beo_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Amaiba:le, gesami hea:su dunu da amane gesami hea:sa, ‘Hesiabone moilai bai bagade, hina bagade Saihone ea moilai, amoga misa. Ninia da amo moilai bu hiougi amola bu hahamoi dagoi ba:mu, amo hanai gala. ");
INSERT INTO beo_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Hemonega, Saihone ea dadi gagui dunu da lalu ea ahoabe defele, Hesiabone moilai bai bagadega asi. Ea dadi gagui dunu da lalu agoane, A moilai bai bagade Moua:be soge ganodini wadela:lesi, amola Anone Hano ea banuguma agolo soge da lalu nebe agoane nei dagoi. ");
INSERT INTO beo_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moua:be fi dunu! Dilia da se bagade naba! Dilia ogogosu ‘gode’ Gimosie amoma nodone sia:ne gadosu dunu! Dilia da wadela:lesi dagoi. Dilia ‘gode’ da dilia dunu amo mugululi asi dunu hamoma:ne, logo doasi dagoi. Amola dilia uda ilia da A:moulaide hina bagade ea udigili hawa: hamosu uda hamoi. ");
INSERT INTO beo_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Be wali iligaga fi da wadela:lesi dagoi. Soge amo da Hesiaboneganini muni asili Daibone amola Noufa (Mediba gadenene), amo soge huluane ganodini fi, iligaga fi da wadela:lesi dagoi ba:sa.” ");
INSERT INTO beo_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Amaiba:le, Isala:ili fi dunu da A:moulaide fi dunu ilia soge ganodini fi. ");
INSERT INTO beo_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Amola Mousese da Ya:isa moilai bai bagade doagala:ma:ne, logo noga:i amo hogomusa:, desega ahoasu dunu asunasi. Isala:ili dunu da Ya:isa moilai bai bagade amola e sisiga:le dialu moilai huluane amo moilai doagala:le fedelai dagoi. Ilia da A:moulaide dunu amogawi esalu amo sefasi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Amalalu, Isala:ili dunu da sinidigili, Ba:isia:ne sogega doaga:musa: logoga asi. Oge (Ba:isia:ne hina bagade) da ea dadi gagui dunu gagadole, Edeliai moilai bai bagadega Isala:ili dunu ilima doagala:musa:, mogodigili asi. ");
INSERT INTO beo_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Hina Gode da Mousesema amane sia:i, “Ema mae beda:ma! Na da di amo Oge amola ea dunu huluane amola ea soge amo hasalima:ne, Na da amo hou dima imunu. Dia da Saihone, A:moulaide hina bagade amo da Hesiabone amoga ouligisu hou hamosu, dia da ema hamoi defele, Oge ema hamoma.” ");
INSERT INTO beo_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Amaiba:le, Isala:ili dunu da Oge amola egefelali amola ea fi dunu huluanedafa medole lelegei dagoi. Dunu afae esalebe hame ba:i. Amalalu, ilia da ea soge gesowale fi dialu. ");
INSERT INTO beo_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isala:ili dunu da bu asili, Moua:be umi soge amo Yodane Hano ea eso mabe la:idi, Yeligou moilai bai bagade la:idila la:idilale diala, amogawi ilia fisisu hamoi. ");
INSERT INTO beo_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Moua:be hina bagade Ba:ila:ge (Sibo egefe), e da Isala:ili ilia hou amo A:moulaide dunuma hamoi amola ilia idi bagade nababeba:le, ");
INSERT INTO beo_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","e amola ea fi dunu huluane da bagadewane beda:i galu. ");
INSERT INTO beo_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moua:be dunu da Midia:ne fi dunu ilima amane sia:i, “Bulamagau gawali da gisi bugi ganodini gisi na ebelesa, amo defele Isala:ili fi bagade da ninia liligi huluane wadela:lesimu.” ");
INSERT INTO beo_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Amaiba:le, hina bagade Ba:ila:ge da sia:ne iasu dunu ilia Ba:ila:me (Bio egefe, e da Bidio moilai Amoue soge Iufala:idisi Hano gadenene esalu), amo dunu ema misa:ne sia:si. Sia:ne iasu dunu da Ba:ila:ge ea sia: amane sia:si, “Di da amo liligi dawa:ma:ne na da sia:sisa. Dunu fi bagade da Idibidi sogega goeguda: misi dagoi. Amo dunu da soge huluane amoga a:i ahoa, amola ilia da ninia soge huluane lamusa: magagisa. ");
INSERT INTO beo_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ilia idi da ninia idi baligi dagoi. Amaiba:le, di goeguda: misini, na fidima:ne ilima gagabusu aligima:ne ilegema. Amasea, amabela:? ninia da ilima hasalimu amola ninia soge fisimusa: ili sefasimu. Na dawa:! Di da dunu hahawane esaloma:ne sia:sea, ilia da hahawane esalumu, amola di da ilima gagabusu aligima:ne ilegesea, amo gagabusu da ilima aligi dialumu.” ");
INSERT INTO beo_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Amaiba:le, Moua:be amola Midia:ne ouligisu dunu da amo gagabusu ilegesu dabe sia: amo gaguli asili, Ba:ila:mema doaga:le, Ba:ila:ge ea sia: ema sia:ne i. ");
INSERT INTO beo_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ba:ila:me da ilima amane sia:i, “Wali guiguda: golale, aya na da Hina Gode Ea nama sia:mu, amo dilima olelemu.” Amaiba:le, Moua:be ouligisu dunu da Ba:ila:me ili esalu. ");
INSERT INTO beo_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Gode da Ba:ila:mema misini, amane sia:i, “Amo dunu dili esalebe da nowa dunula:?” ");
INSERT INTO beo_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ba:ila:me da bu adole i, “Moua:be hina bagade Ba:ila:ge da ili nama amane olelema:ne asunasi, ");
INSERT INTO beo_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Dunu fi amo da Idibidi sogega misi da soge huluane amoga a:i ahoa. E da agoane hanai gala, amo na da gagubusu ilima aligima:ne ilegemu. Amasea, e da ilima doagala:le, gadili sefasimusa: dawa:mu.” ");
INSERT INTO beo_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Gode da Ba:ila:mema amane sia:i, “Amo dunu mae sigi masa! Amola Isala:ili fi dunu ilima gagabui aligima:ne mae ilegema! Bai Na da ilima hahawane dogolegele hou ilegele i dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Golale, hahabe, Ba:ila:me da Ba:ila:ge ea sia:ne iasu dunuma asili, amane sia:i, “Dilia diasuga buhagima! Hina Gode da, na dili mae sigi masa:ne sia:i dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Amaiba:le, ilia da Ba:ila:ge ema buhagili, Ba:ila:me da ili mae sigi misa:ne sia:i amo ema olelei. ");
INSERT INTO beo_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Amalalu, Ba:ila:ge da sia:ne iasu dunu ilia idi da musa: asi dagoi, amo ilia hou da musa: asi hou ilia baligi, amo asunasi. ");
INSERT INTO beo_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ilia da Ba:ila:mema asili, Ba:ila:ge ea sia: ema amane alofele i, “Na dima ha:giwane edegesa. Misa! Logo ga:su liligi mae dawa:ma! ");
INSERT INTO beo_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Na da bidi bagadewane dima imunu, amola dia hanai adole ba:su huluane hamomu. Na dima ha:giwane edegesa. Misa! Amola na fidima:ne amo Isala:ili dunu fi ilima gagabui aligima:ne ilegema.” ");
INSERT INTO beo_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Be Ba:ila:me da bu adole i, “Ba:ila:ge da silifa amola gouli ea hina bagade diasu ganodini amo huluanedafa nama ianoba, na da Hina Gode Ea sia: fonobahadi afae fawane giadofamu da nama hamedei gala:loba. ");
INSERT INTO beo_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Be dilia musa: misi dunu defele, wali gasia goeguda: esaloma. Bai na da Hina Godema bu adole ba:mu. Amabela:? E da nama sia: eno ganabela:?” ");
INSERT INTO beo_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Amo gasia, Gode da Ba:ila:mema misini, amane sia:i, “Amo dunu da dia ili sigi masa:ne sia:musa: misi galea, defea, dia liligi momagele, ili sigi masa. Be Na hamoma:ne sia:i defele amo fawane hamoma.” ");
INSERT INTO beo_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Amaiba:le, hahabe, Ba:ila:me da ea dougi amo da:iya fa:le fisu amo lala:gilalu, fila heda:le, Moua:be ouligisu dunu amola sigi asi. ");
INSERT INTO beo_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ba:ila:me da ahoabeba:le, Gode da ougi ba:i. Amaiba:le, Ba:ila:me da ea dougi da:iya fila heda:le, ea hawa: hamosu dunu aduna amola gilisili: logoga ahoanoba, Hina Gode Ea a:igele dunu da ea logo hedofamusa:, logo dogoa lelu. ");
INSERT INTO beo_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Dougi da a:igele dunu gegesu gobihei bagade gaguliwane lelebe ba:beba:le, e da logo fisili, bu la:ididili sega sa:i. Ba:ila:me da ea dougi fananu, bu logoga logei. ");
INSERT INTO beo_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Amalalu, a:igele dunu da logo donoboi amo da waini efe sagai amo da igiga gagoi, amo dibiga asili, lelu. ");
INSERT INTO beo_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Dougi da a:igele ba:beba:le, logo la:idi amoga bobogala:le, Ba:ila:me ea emo da igiga gagoi amo damana fanasili gigidinai. Ba:ila:me da bu enowane dougi fai. ");
INSERT INTO beo_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","A:igele da eno ba:le gaidi asili, donoboidafa logo sogebi, la:ididili amola la:ididili baligimu hamedei sogebi, amoga lelu. ");
INSERT INTO beo_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Dougi da bu a:igele dunu ba:beba:le, osoboga diagudui. Ba:ila:me ea ougi bagade heda:le, e da dougi amo ea galiamoga fananu. ");
INSERT INTO beo_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Amalalu, Hina Gode da dougi amoma, dunuga sia:be agoane sia:ma:ne, gasa i. Dougi da Ba:ila:mema amane sia:i, “Na da dima adi hamobela:? Di da abuliba:le, na udiana agoane udigili fabela:?” ");
INSERT INTO beo_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ba:ila:me da bu adole i, “Bai di da na gagaoui dunu agoane ba:ma:ne, hamoi dagoi! Na da gegesu gobihei bagade gagui ganiaba, na da di medole legela:loba.” ");
INSERT INTO beo_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Dougi da bu adole i, “Na da dia dougi amola dia esalusu ganodini di da eso huluane nama fila heda:le ahoanusu. Na da amo hou musa: dima hamobela:?” Ba:ila:me da bu adole i, “Hame mabu!” ");
INSERT INTO beo_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Amalalu, Hina Gode da Ba:ila:mema amo a:igele dunu gegesu gobihei bagade gaguiwane lelebe amo ba:ma:ne, e si doasi. Amalalu, Ba:ila:me da hina: odagi osoba guduli gala:lasa:i. ");
INSERT INTO beo_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","A:igele da ema amane sia:i, “Dia abuliba:le udiana agoane dia dougi fabela:? Na da dia logo hedofamusa: misi dagoi! Bai di da amodili masunu da defea hame galebe. ");
INSERT INTO beo_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Be dia dougi da na ba:lalu udiana agoane sinidigi. E da agoai hame hamosa ganiaba, na da di fane legela:loba, amola dougi hame fane legela:loba.” ");
INSERT INTO beo_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ba:ila:me da bu adole i, “Na da wadela:le hamoi dagoi. Di da na logo hedofamusa: logoga lelu, na da hame dawa:i galu. Be di da na bu masunu da defea hame dawa:sea, na da na diasuga buhagimu.” ");
INSERT INTO beo_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Be a:igele da ema amane sia:i, “Di mae buhagili, amo dunu sigi masa. Be na dima adomu liligi fawane sia:ma!” Amaiba:le, Ba:ila:me da Moua:be ouligisu dunu amola bu sigi asi. ");
INSERT INTO beo_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ba:ila:ge da Ba:ila:me ea manebe sia: nababeba:le, e da A moilai bai bagade (Anone Hano bega: amola Moua:be soge alalo amoga dialu) amoga Ba:ila:me yosia:musa: asi. ");
INSERT INTO beo_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ba:ila:ge da Ba:ila:mema amane sia:i, “Dia abuliba:le na da musa: misa:ne sia:i amoga hame misibala:? Dia adi dawa:bela:? Na da dima bidi defele imunu hamedebela:?” ");
INSERT INTO beo_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ba:ila:me da bu adole i, “Na da wali misi dagoi! Dafawanela:? Be na da gasa hamedei. Na da Gode Ea nama sia:i liligi fawane sia:mu, amo fawane gasa gala.” ");
INSERT INTO beo_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Amalalu, Ba:ila:me amola Ba:ila:ge da Gilia:de Husode moilai amoga asili, ");
INSERT INTO beo_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ba:ila:ge da bulamagau amola sibi medole legele, amo ea hu mogili Ba:ila:me amola ouligisu dunu amo ili gilisili moma:ne ema i. ");
INSERT INTO beo_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Golale, hahabe, Ba:ila:ge da Ba:ila:me amo Ba:imode Ba:ile (gado sogebi) amoga oule asi. Amoga, Ba:ila:me da Isala:ili fi dunu mogili ba:musa: dawa:i. ");
INSERT INTO beo_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ba:ila:me da Ba:ila:gema amane sia:i, “Na hou fidima:ne, goeguda: oloda agoane gaguma. Amola bulamagau gawali fesuale amola sibi gawali fesuale agoane, goeguda: gaguli misa!” ");
INSERT INTO beo_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ba:ila:ge da ea sia:i defele hamoi. Ba:ila:ge amola Ba:ila:me ela da bulamagau gawali amola sibi gawali amo oloda afae afae amoga gobele sali. ");
INSERT INTO beo_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Amalalu, Ba:ila:me da Ba:ila:gema amane sia:i, “Goeguda: dia gobei iasu gadenene leloma. Na da asili, Hina Gode da nama gousa:ma:bela:le, amo na da hogomu. Ea nama sia:mu liligi huluane na da dima olelemu.” Amaiba:le, e da hisu agoloba:le heda:le, agolo da:iya gado lelu, ");
INSERT INTO beo_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Gode da ema misi. Ba:ila:me da Godema amane sia:i, “Na da oloda fesuale gaguli, amo afae afae da:iya bulamagau gawali amola sibi gawali amo gobele sali.” ");
INSERT INTO beo_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Hina Gode da Ba:ila:mema ea sia:mu liligi olelelalu, Ba:ila:gema bu sia:musa: asunasi. ");
INSERT INTO beo_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Amaiba:le, e da buhagili, Ba:ila:ge amola Moua:be ouligisu dunu huluane ea gobei iasu gadenene lelebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ba:ila:me da ea ba:la:lusu amoga amane sia:i, “Ba:ila:ge, Moua:be hina da na goeguda: oule misi. Na da eso mabe goumi soge, Silia soge amoga misi. ‘Na fidima:ne sia:musa: misa’ e sia:i. ‘Isala:ili fi dunu ilima gagabusu aligima:ne ilegema!’ ");
INSERT INTO beo_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Be na da habodane Gode Ea gagabui hame ilegei dunu ilima gagabusu aligima:ne ilegema:bela:? Na da habodane amo dunu fi wadela:lesima:ne sia:ma:bela:? Bai Gode da amo dunu fi wadela:lesima:ne hame sia:i. ");
INSERT INTO beo_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Na da gado heda:le, gele da:iya amogai aligili, amo fi ba:sa. Na da agolo da:iya gadonini ili ba:lala. Ilia da fi amo da hisu esala. Ilia dawa:! Hina Gode da ilima hahawane dogolegelema:ne hou, eno fifi asi gala ilima hahawanedogolegele hou baligisa, amo ilima i dagoi. ");
INSERT INTO beo_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Isala:ili fi iligaga fi da osobo su agoane, bagohameba:le, ilia dunu idimu da hamedei. Na da bogosea, na da Gode Ea fi dunu afae defele bogomu da defea. Na da bogosea, na da olofole, dunu moloidafa bogomu da defea gala.” ");
INSERT INTO beo_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Amalalu, Ba:ila:ge da Ba:ila:mema amane sia:i, “Di da nama adi hamobela:? Na da di na ha lai dunu ilima gagabui aligima:ne ilegemusa: goeguda: oule misi. Be di da amo mae hamone, ilima hahawane dogolegele hou fawane aligima:ne ilegei dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ba:ila:me da bu adole i, “Na da Hina Gode Ea nama sia:i liligi amo fawane adomusa: dawa:!” ");
INSERT INTO beo_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Amalalu, Ba:ila:ge da Ba:ila:mema amane sia:i, “Eno sogebi amoga nama sigi misa. Amogawi, di da Isala:ili dunu ba:lalu, na fidima:ne, ilima gagabusu aligima:ne ilegema.” ");
INSERT INTO beo_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","E da Ba:ila:me amo Soufime sogebi Bisiga Goumi gadodili diala amoga oule asi. Amola amogawi e da oloda fesuale gaguli amola amo afae afae amoga bulamagau gawali amola sibi gawali gobele sali. ");
INSERT INTO beo_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ba:ila:me da Ba:ila:gema amane sia:i, “Goeguda: dia gobei iasu gadenene leloma. Amola na da ga (south) asili, Gode gousa:mu.” ");
INSERT INTO beo_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Hina Gode da Ba:ila:mema misini, ea sia:mu liligi ema olelei. E da amo Ba:ila:gema olelema:ne, bu asunasi. ");
INSERT INTO beo_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Amaiba:le, Ba:ila:me da buhagili, Ba:ila:ge amola Moua:be ouligisu dunu, ea gobei iasu gadenene lelebe ba:i. Ba:ila:ge da Hina Gode Ea sia:ne iasu amo ema adole ba:i. ");
INSERT INTO beo_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Amalalu, Ba:ila:me da ea ba:la:lusu amane sia:i, “Ba:ila:ge, Sibo ea mano! Misa! Na sia: nabima! ");
INSERT INTO beo_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Osobo bagade dunu da ogogosu dawa:. Be Gode da ogogosu hamedafa dawa. Osobo bagade dunu da ilia asigi dawa:su hedolo afadenesa. Be Gode da agoai hame dawa:. Gode da Ea ilegei sia: amo huluane hamosa. E da sia:sea, Ea sia:i liligi da hamoi dagoi ba:sa. ");
INSERT INTO beo_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","E da nama hahawane dogolegele sia: fawane sia:ma:ne sia:i. Amo Gode da hahawane dogolegele aligima:ne sia:sea, na da amo sia: bu afadenemu hame dawa:. ");
INSERT INTO beo_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Na da agoane ba:sa. Isala:ili fi ilia hobea misunu hou amo ganodini da se nabasu amola bidi hamosu hame ba:mu. Bai Hina Gode, ilia Gode, da ili esala. E da ilia Hina Bagadedafa, ilia da amane wele sisia:sa. ");
INSERT INTO beo_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gode da ili Idibidi sogega fisili masa:ne, goeguda: oule misi. E da sigua bulamagau defele, ili fidima:ne gegenana. ");
INSERT INTO beo_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Isala:ili dunu hasalimusa: da wamuni dawa:su o yagono hou hamomu da hamedei. Wali dunu huluane da Isala:ili ea hou ba:sea amane sia:mu, ‘Ba:ma! Gode Ea hamoi ba:ma!’ ");
INSERT INTO beo_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Isala:ili fi da gasa bagade laione wa:me agoane. E da mae helefili, hu dodosa:sa amola naha amola medole legei liligi ea maga:me naha. Mai dagoiba:le fawane helefisa.” ");
INSERT INTO beo_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Amalalu, Ba:ila:ge da Ba:ila:mema amane sia:i, “Di da Isala:ili dunu ilima gagabusu aligima:ne ilegemusa: higasa. Defea! Be ilima hahawane dogolegele hou maedafa aligima:ne ilegema!” ");
INSERT INTO beo_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Be Ba:ila:me da amane bu adole i, “Na da dima sia:i dagoi! Na da Hina Gode nama sia:i liligi fawane hamomusa: defele gala!” ");
INSERT INTO beo_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ba:ila:ge da amane sia:i, “Ania da eno sogebi amoga ahoa:di! Amabela:? Gode da di amoga Isala:ili dunu gagabusu aligima:ne ilegemusa:, amogawi dia logo doasima:bela:?” ");
INSERT INTO beo_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Amaiba:le, e da Ba:ila:me amo oule asili, Bio Goumi amoba:le heda:i. Amogawi, wadela:i hafoga:i soge da elea midadi gududi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ba:ila:me da ema amane sia:i, “Goeguda: oloda fesuale agoane gaguli, nama bulamagau gawali fesuale gala amola sibi gawali fesuale gala amo gaguli misa.” ");
INSERT INTO beo_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ba:ila:ge da ea sia:i defele hamoi. E da oloda afae afae amoga bulamagau gawali afae amola sibi gawali afae gobele sali. ");
INSERT INTO beo_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Be wali, Ba:ila:me da Hina Gode da Ea Isala:ili dunu ilima hahawane dogolegele aligima:ne ilegemu fawane hanai, amo e dawa:i galu. Amaiba:le, ea musa: hou defele hame hamoi. E da dawa:digima:ne olelesu liligi amo hogomusa: hame asi. E da hafoga:i soge ba:musa: sinidigili, ");
INSERT INTO beo_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Isala:ili dunu ilia fisisu ba:i. E da ilia sosogo fi afae afae dafulili esalebe ba:i. Gode Ea A:silibu Hadigidafa da ema aligila sa:ili, ");
INSERT INTO beo_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","e da amo ba:la:lusu sia:i, “Ba:ila:me, Bio ea mano, da moloiwane ba:sa. Ea sia: da agoane gala. ");
INSERT INTO beo_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Nowa da Gode Ea sia:dalebe nababela:? Na da si godonasini agoane sosodosa. Na da esala ba:lala, Gode Bagadedafa da nama olelesa. ");
INSERT INTO beo_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Isala:ili ilia abula diasu da isisima:goi ba:sa. ");
INSERT INTO beo_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ilia da gumudi yobo dadalei sedade defele. O ifabi hano bega: bugi agoane ba:sa. Ilia da gabusiga: ifa Hina Gode Ea bugi defele, o dolo ifa, hano bega: lelebe agoane ba:sa. ");
INSERT INTO beo_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ilia da gibu dabe bagade ba:mu. Ilia da hawa: amo nasegagi hano bagade soge ganodini bugimu. Ilia hina bagade da A:iga:ge ea hou bagadewane baligimu. Ea ouligisu hou da soge bagohame amoga heda:mu. ");
INSERT INTO beo_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gode da ili Idibidi sogega fisili masa:ne, oule misi. E da sigua bulamagau defele, ili fidima:ne gegenana. Ilia da ilia ha lai dunu amo na dagosa. Ilia da ilia gasa goudasa amola ilia dadi wadela:lesisa. ");
INSERT INTO beo_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Isala:ili fi da gasa bagade laione wa:me agoane. E da golai dialea, dunu eno da beda:iba:le, hamedafa didilisisa. Nowa da Isala:ili hahawane dogolegelewane aligima:ne ilegesea, da Gode Ea hahawane dogolegesu ba:mu. Amola nowa da Isala:ili ilima gagabusu aligima:ne ilegesea, da amo gagabusu sinidigili hihima aligima:ne ilegei dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ba:ila:ge da ougili ea lobo usuna gaguli, Ba:ila:mema amane sia:i, “Na da di na ha lai dunu amo gagabusu aligima:ne ilegema sia:i. Be udiana agoane di da amo mae hamone, ilima Gode Ea hahawane dogolegesu hou aligima:ne sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Dia diasuga masa! Na da dima bidi bagade imunu sia:i. Be Hina Gode da dia amo bidi lama:ne logo hedofai dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ba:ila:me da bu adole i, “Na da sia:ne iasu dunu di nama asunasi ilima olelei, amane, ");
INSERT INTO beo_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Ba:ila:ge da silifa amola gouli ea hina bagade diasu ganodini gala amo huluanedafa nama ia:noba, na da ni hanaiga Hina Gode Ea hamoma:ne sia:i fonobahadi nama sia:i amo giadofamu da hamedela:loba. Na da Hina Gode Ea nama sia:i liligi fawane bu sia:mu.” ");
INSERT INTO beo_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ba:ila:me da Ba:ila:gema amane sia:i, “Na da wali na fidafa amoga buhagimu. Be hidadea, na da dima sisasu sia:mu. Amalu da fa:no Isala:ili dunu ilia hou dia fi dunuma hamomu, amo na da dima sia:mu.” ");
INSERT INTO beo_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Amalalu, e da amo ba:la:lusu amane sia:i, “Ba:ila:me, Bio ea mano, da moloiwane ba:sa. Ea sia: da agoane gala. ");
INSERT INTO beo_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Na da Gode Ea sia: dalebe naba. Na da si godonasini agoane sosodosa. Na da esalebe ba:lala, Gode Bagadedafa da nama olelesa. ");
INSERT INTO beo_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Na da hobea misunu hou ba:la:lala. Na da Isala:ili fi ba:sa. Hina Bagade dunu, hadigi bagade gasumuni agoai, amo fi ganodini heda:lebe ba:mu. E da ofa:su gasumuni defele Isala:ili sogega misunu. E da Moua:be ouligisu dunu famu amola Sede soge dunu amo banenesimu. ");
INSERT INTO beo_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","E da ea ha lai dunu Idome sogega esala amo hasalili, ilia soge huluane suguli lamu. Amola Isala:ili dunu da hasaliliwane masunu. ");
INSERT INTO beo_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Isala:ili fi dunu da ilia ha lai amo osa:le heda:le, dunu hame bogoi esalebe, amo huluane fane legemu.” ");
INSERT INTO beo_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Amalalu, Ba:ila:ge da ea esala ba:su amo ganodini A:malege fi ba:lalu, amane ba:la:lusu sia:i, “A:malege ea gasa bagade hou da eno fi huluane baligi dagoi. Be fa:no e da gugunufinisi dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Amalalu, Ba:ila:ge da ea esalebe ba:su amo ganodini, Ginaide dunu fi ba:i. E da amo ba:la:lusu sia:i, “Dia esalebe sogebi da gaga:i dagoi. Sio ea bibi da gafulu bagade amoga bibiba:le, eno liligiga wadela:lesimu hamedei. ");
INSERT INTO beo_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Be dilia Ginaide dunu da gugunufinisi dagoi ba:mu. Bai Asilia dunu da dili doagala:le, suguli lamu.” ");
INSERT INTO beo_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ba:ila:me da eno ba:la:lusu amane sia:i, “Dunu da gadili (north) amogawi gilisilalebe da nowa dunula:? ");
INSERT INTO beo_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Doagala:su golili dasu dunu da Saibalase sogega, dusagai ganodini manebe ba:mu. Ilia da Asilia amola Ibe amo hasalimu. Be Saibalase dunu amola da fa:no gugunufinisi dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Amalalu, Ba:ila:me da momagele, hi diasuga buhagi. Amola Ba:ila:ge da hi logoga asi. ");
INSERT INTO beo_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isala:ili dunu da Sidimi Fago amoga esaloba, Isala:ili dunu ilia da Moua:be uda hiougili, gilisili golai. ");
INSERT INTO beo_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Amo uda ilia da Isala:ili dunu ilia gobele salasu lolo nasu (amogawi ilia da Moua:be ogogosu ‘gode’ amoga nodone sia:ne gadosu) amoga hiougi. Isala:ili dunu da ha:i manu mai amola ogogosu Bio ‘gode’ Ba:ile, amoma nodone sia:ne gadoi. ");
INSERT INTO beo_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Amaiba:le, Hina Gode da ougi bagade ba:i. ");
INSERT INTO beo_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","E da Mousesema amane sia:i, “Na sia: nabima! Isala:ili ouligisu dunu huluane lale, dunu huluane ba:ma:ne medole legema. Amasea, Na da Isala:ili dunu ilima Na ougi fisimu.” ");
INSERT INTO beo_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mousese da ouligisu dunu ilima amane sia:i, “Dilia afae afae amo dilia fi amo ganodini nowa da Bio ogogosu ‘gode’ Ba:ile ema nodone sia:ne gadolala, amo medole legema.” ");
INSERT INTO beo_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Mousese amola Isala:ili dunu huluane da da:i dioiwane, Hina Gode Ea Abula diasu holeiga didiga:lalu. Isala:ili dunu afae da Mousese amola Isala:ili dunu huluane ba:ma:ne, Midia:ne uda hi abula diasu ganodini hiougili asi. ");
INSERT INTO beo_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finia:se (Elia:isa egefe amola Elane ea aowa) amo ba:beba:le, wa:legadole, dunu gilisisu yolesiagai. E da goge agei lale, ");
INSERT INTO beo_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","amo dunu amola uda bobogele, abula diasu golili sa:ili, ea goge agei amoga ela gilisili sone, medole legei. Amane hamobeba:le, olo bagade amo da Isala:ili fi wadela:lesilalu, amo da hedofai dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Be amo olo ganodini, Isala:ili dunu 24,000 agoane da bogogia:i dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finia:se ea hamobeba:le, Na da Isala:ili dunuma ougi amo gumi dagoi. E da eno ‘gode’ liligi ilima nodone sia:ne gadosu hou higale, Nama fawane nodone sia:ne gadomusa: dawa:i. Amaiba:le Na da ougili Isala:ili dunu huluane hame gugunufinisi. ");
INSERT INTO beo_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Amaiba:le ema adoma. Na da ema gousa:su amo da eso huluanedafa dialoma:ne hamomu. ");
INSERT INTO beo_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","E amola egaga fi da eso huluane mae fisili, gobele salasu dunu fi esalumu. Bai e da eno ‘gode’ liligi mae dawa:le, baligiliwane Na fuligala:i. Amola ea hamobeba:le, Isala:ili dunu da ilia wadela:i hou gogolema:ne olofoi dagoi ba:i.” ");
INSERT INTO beo_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isala:ili dunu amo da Midia:ne uda gilisili medole legei ba:i amo ea dio da Similai (Sailiu egefe. Sailiu da sosogo fi Simione fi amo ganodini bisilua dunu galu). ");
INSERT INTO beo_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Midia:ne uda ea dio amo da Gosabai. Ea ada da Se. E da Midia:ne fi gilisisu ilia hina esalu. ");
INSERT INTO beo_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Midia:ne fi amo doagala:le, ili gugunufinisima! ");
INSERT INTO beo_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Bai ilia da Bio sogega dilima ogogoiba:le, Isala:ili fi wadela:lesi. Amola Gosabai amo da olo bagade eso Bio sogega amo ganodini medole legei ba:i, e da ogogoiba:le, Isala:ili dunu da se bagade nabi.” ");
INSERT INTO beo_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Olo bagade da hedofai galu, Hina Gode da Mousese amola Elia:isa (Elane egefe) ilima amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Isala:ili fi ganodini, sosogo fi huluane, dunu amo da ode20doaga:i amola baligi, amola dadi gagui hou hamomu defele ba:sea, amo huluane idili dedema.” ");
INSERT INTO beo_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Mousese amola Elia:isa da Hina Gode Ea hamoma:ne sia:i nababeba:le, dunu da lalelegele, ode 20 doaga:i amola baligi amo huluane gagadomusa:, wele sia:i. Ilia da Moua:be umi soge Yodane Hano gusu bega: gilisi. Yeligou moilai bai bagade da hano na:iyadodili ba:i. Isala:ili dunu amo da Idibidi soge fisili, ga misi, da agoane:- ");
INSERT INTO beo_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","6","Liubene fi (Liubene da Ya:igobe ea mano magobo). Liubene ea sosogo fi da Ha:inoge, Pa:liu, Heselone amola Gami. ");
INSERT INTO beo_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Amo fi dunu idi da 43,730 dunu agoane. ");
INSERT INTO beo_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","9","Pa:liu egaga fi da Ilaia:be, ea mano Nemiuele, Da:ida:ne amola Abaila:me (Isala:ili dunu fi da Da:ida:ne amola Abaila:me ilegei. Ilia da Goula ea fa:no bobogesu dunu gilisili, Hina Godema odoga:i. ");
INSERT INTO beo_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Osobo da ea lafi dagale gale, ili mogosali dagoi. Lalu da dunu 250 medole legeiya, ilia amola Goula amola ema fa:no bobogesu dunu huluane da bogogia:i. Ilima doaga:i hou da Isala:ili dunu huluane ilima sisasu agoane galu. ");
INSERT INTO beo_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Be Goula egefelali da hame medole legei ba:i.) ");
INSERT INTO beo_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","13","Simione fi. Amo fi ea sosogo fi da Nemiuele, Ya:imine, Ya:igini, Sela amola Sia:iale. ");
INSERT INTO beo_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Amo fi ilia idi da 22,200 dunu agoane. ");
INSERT INTO beo_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","17","Ga:de fi. Amo fi ea sosogo fi da Sifone, Ha:gai, Siounai, Osinai, Ilai, A:ilode amola Alilai. ");
INSERT INTO beo_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Amo fi dunu ilia idi da 40,500 agoane. ");
INSERT INTO beo_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Yuda fi. Amo fi ea sosogo fi da Sila, Bilese, Sela, Heselone amola Ha:imale. (Yuda egefe aduna amo E amola Ouna:ne da musa: Ga:ina:ne sogega bogoi.) ");
INSERT INTO beo_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Amo fi dunu ilia idi da dunu 76,500 agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","24","Isaga fi. Amo fi ea sosogo fi da Doula, Biua, Ya:isiabe amola Similone. ");
INSERT INTO beo_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Amo fi dunu ilia idi da 64,300 agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sebiulane fi. Amo ea sosogo fi da Silede, Ilone amola Yaliele. ");
INSERT INTO beo_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Amo fi dunu ilia idi da 60,500 agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yousefe ea fi. Egefe aduna da Ma:na:se amola Ifala:ime. ");
INSERT INTO beo_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ma:na:se fi. Ma:na:se egefe Ma:ige amo egefe da Gilia:de. Gilia:de egaga sosogo fi da agoane galu. ");
INSERT INTO beo_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","32","Aiesa, Hilege, A:saliele, Siegeme, Siemaida amola Hife. ");
INSERT INTO beo_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hife egefe Siloufiha:de da egefe hame galu- be idiwi fawane galu. Ilia dio da Mala, Nowa, Hogola, Miliga amola Desa. ");
INSERT INTO beo_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Amo fi huluane ilia idi da 52,700 dunu agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ifala:ime fi. Amo fi ea sosogo fi da Sioudila, Biga amola Da:iha:ne. ");
INSERT INTO beo_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sioudila ea egaga sosogo fi da Ila:ne. ");
INSERT INTO beo_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ifala:ime sosogo fi huluane ilia idi da 32,500 agoane ba:i. Ma:na:se amola Ifala:ime fi huluane da Yousefe egaga fi. ");
INSERT INTO beo_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","40","Bediamini fi. Amo fi ea sosogo fi da Bila, A:siebele, Ahailame, Siefufa:me, Hiufa:me, Ade amola Na:ima:ne. Ade amola Na:ima:ne da Bila egaga fi. ");
INSERT INTO beo_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Amo fi ilia idi da 64,400 agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Da:ne fi. Ea sosogo fi afae da Hiusimi. ");
INSERT INTO beo_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Amo fi ea idi da 64,000 agoane. ");
INSERT INTO beo_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","A:sie fi. Amo ea sosogo fi da Imina, Isifi, Bilaia, Hibe amola Ma:lagiele. ");
INSERT INTO beo_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Hibe amola Ma:lagiele fi da Bilaia egaga fi galu. ");
INSERT INTO beo_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Amola A:sie da idiwi afae galu. Ea dio amo da Sila. ");
INSERT INTO beo_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Amo fi ilia idi da 53,400 dunu agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","49","Na:fadalai fi. Amo fi ea sosogo fi da Yasiele, Giunai, Yisa amola Sileme. ");
INSERT INTO beo_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Amo fi ilia idi da 45,400 dunu agoane ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Isala:ili dunu huluane gilisili idi da 601,730 agoane. ");
INSERT INTO beo_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Soge fifili, Isala:ili dunu ilia idi defele ilima ima. ");
INSERT INTO beo_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","56","Ululuasu hedesu amoga soge fifima. Fi bagade ilima soge fifi bagade ima. Amola fi fonobahadi ilima soge fifi fonobahadi ima.” ");
INSERT INTO beo_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lifai fi ea sosogo fi da Gesione, Gouha:de amola Milalai. ");
INSERT INTO beo_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Iligaga fi da sosogo fi fonobahadi amo Libini, Hibalone, Malai, Miusiai amola Goula. Gouha:de egefe da A:mala:me. ");
INSERT INTO beo_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","A:mala:me da Lifai idiwi Yogebede (e da Idibidi sogega lalelegei) amo lai. Yogebede da A:mala:me ema dunu mano aduna amo Elane, Mousese amola uda mano afae amo Milia:me lai. ");
INSERT INTO beo_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Elane da egefe biyaduyale galu. Ilia da Na:ida:be, Abaihu, Elia:isa amola Idama. ");
INSERT INTO beo_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Na:ida:be amola Abaihu da hadigi hamedei lalu amo Hina Godema imunusa: dawa:beba:le, bogoi dagoi. ");
INSERT INTO beo_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Lifai fi dunu da oubi afae lalelegei amola amo baligi, ilia idi da 23,000 agoane. Ilia da eno Isala:ili dunuma gilisili hame dedei - hisu dedei. Bai ilia da Isala:ili soge ganodini liligi afae ilima hame i galu. ");
INSERT INTO beo_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Mousese amola Elia:isa da Moua:be umi Yodane Hano bega: Yeligou moilai bai bagade amoga na:iyadodili diala, amo ganodini Isala:ili dunu huluane dedene ba:loba, ilia da amo fi dunu huluane dedei dagoi. ");
INSERT INTO beo_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mousese amola Elane da musa: Sainai Hafoga:i Sogega Isala:ili dunu huluane dedei. Be wali dedena sa:i amo ganodini, musa: dedei dunu afae esalebe hame ba:i. ");
INSERT INTO beo_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Bai Hina Gode da ilia huluane da wadela:i hafoga:i soge ganodini bogogia:ima:ne sia:i dagoi. Amola, Ea sia:i defele, ilia da huluane bogogia:i. Ga:ilebe (Yifane egefe) amola Yosiua (Nane egefe), ela fawane esalebe ba:i. ");
INSERT INTO beo_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Yousefe egefe da Ma:na:se. Ma:na:se egefe da Ma:ige. Ma:ige egefe da Gilia:de. Gilia:de egefe da Hife amola Hife egefe da Siloufiha:de. Siloufiha:de ea idiwilali ilia dio da Mala, Nowa, Hogola, Miliga amola Desa. ");
INSERT INTO beo_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ilia da Hina Gode Ea Abula Diasu holeiga asili, Mousese amola gobele salasu dunu Elia:isa, amola Isala:ili ouligisu dunu amola Isala:ili dunu huluane, ilia midadi lelu, amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Ninia ada e da dunu mano mae lalelegele, wadela:i hafoga:i sogega bogoi dagoi. Goula amola ea fa:no bobogesu dunu da Hina Godema lelelaloba, ninia ada da ilima hame gilisi. E da hi wadela:i hou hamoiba:le fawane bogoi. ");
INSERT INTO beo_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Ninia ada ea dio da Isala:ili soge ganodini abuliba:le bu hame ba:mu, bai e da egefe hame. Ninia ada ea fi dunu defele, soge ninima ima!” ");
INSERT INTO beo_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mousese da ilia adole ba:su amo Hina Godema olelei. ");
INSERT INTO beo_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Amola, Hina Gode da ema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Defea! Siloufiha:de ea idiwilali ilia adole ba:su da moloi! Edalalia fi amo ganodini, soge ilima ima! Ea lamu liligi amo ilima imunu da defea. ");
INSERT INTO beo_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Amola, Isala:ili dunuma amane olelema. Dunu da dunu mano mae lalelegele bogosea, idiwi da eda soge lama:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Be e da idiwi hame galea, ea yolali da ea liligi lamu. ");
INSERT INTO beo_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","E da yolali hame galea, ea eda ea yolali da ea liligi lamu. ");
INSERT INTO beo_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Be e da yolali amola eda yolali hame galea, ea gadenenedafa fi dunu da amo lale gagumu. Isala:ili dunu da amo hou sema hamoi dagoi noga:le dawa:ma:ne sia:ma. Na, Hina Gode, da dima hamoma:ne sia:i dagoi, amo defele hamoma.” ");
INSERT INTO beo_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Hina Gode da Mousesema amane sia:i, “Dia A:balime Goumiba:le heda:le, soge amo Na da Isala:ili dunuma iaha, amo huluane ba:ma! ");
INSERT INTO beo_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Di da amo ba:lalu, dia ola Elane defele, di da bogomu. ");
INSERT INTO beo_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Bai ali da Na Sini hafoga:i soge ganodini hamoma:ne sia:i amoma odoga:i. Isala:ili dunu huluane da Meliba sogega Nama egane sia:noba, di da Na hadigi gasa bagade hou ili dafawaneyale dawa:ma:ne hame olelei.” (Meliba da Ga:idesie gu hano Sini hafoga:i soge ganodini, amogawi diala) ");
INSERT INTO beo_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mousese da amane sia:ne gadoi, ");
INSERT INTO beo_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Hina Gode! Di da esalusu huluanedafa ea bai gala! Dunu amo da Isala:ili dunu noga:le ouligimusa: dawa:, amo ilegema! ");
INSERT INTO beo_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Dunu amo da gegesu ganodini ilia bisili masunu dawa:, amo ilegema. Dia fidafa da sibi amo sibi ouligisu dunu hame, amo agoane ba:sa:besa:le, ouligisu dunu ilegema!” ");
INSERT INTO beo_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Hina Gode da Mousesema amane sia:i, “Yosiua (Nane egefe) hawa: hamosu dawa: dunu, amo lale, dia lobo amo ea dialuma da:iya ligisima. ");
INSERT INTO beo_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","E da gobele salasu dunu Elia:isa amola Isala:ili fi dunu gilisisu amo ilia midadi leloma:ne sia:ma. Amasea ili huluane ba:ma:ne, e da dia sogebi lai dagoi amane wele sisia:ma. ");
INSERT INTO beo_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Isala:ili fi dunu da ea sia: nabalu, noga:le hamoma:ne, dia gasa bagade ouligisu hou mogili ema ima. ");
INSERT INTO beo_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","E da gobele salasu dunu Elia:isa ea fidisu hahawane dawa:mu. Amola Elia:isa da Iulimi amola Damimi amo ba:beba:le, Na hanai dawa:mu. Amane hamobeba:le, Elia:isa da hou huluane amo ganodini, Yosiua amola Isala:ili fi dunu huluane ilima olelemu.” ");
INSERT INTO beo_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mousese da Hina Gode Ea hamoma:ne sia:i defele hamoi dagoi. Ea sia:beba:le, Yosiua da Elia:isa amola Isala:ili fi huluane ilia midadi lelu. ");
INSERT INTO beo_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Hina Gode Ea sia:i defele, Mousese da ea lobo Yosiua ea dialuma da:iya ligisili, Yosiua da ea sogebi lai dagoi amane wele sisia:i. ");
INSERT INTO beo_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Isala:ili dunu ilima ilia da sema defele, ha:i manu iasu amo Na da hahawane ba:sa, amo Nama ima:ne sia:ma. ");
INSERT INTO beo_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ha:i manu iasu agoane Hina Godema ima. Eso huluane, dilia da sibi mano gawali aduna ledo hamedei amo da ode afadafa esalu, amo gobele salima. ");
INSERT INTO beo_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Hahabe, sibi mano afae amo gobele salima. Eno da daeya gobele salima. ");
INSERT INTO beo_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Amo sibi mano gobesea, gilisili widi falaua1gilogala:me amola1lida olife susuligi noga:i amo ima. ");
INSERT INTO beo_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Amo da eso huluane iasu liligi. Dafawanedafa gogo gobesima. Isala:ili dunu da musa: degabo amo iasu Sainai Goumia ha:i manu iasu agoane i. Na da amo ea gabusiga: hahawane nabi. ");
INSERT INTO beo_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Hahabe sibi mano gobele salasea, waini hano 1lida amo oloda amoga soga:sima. Amo da waini hano iasu. ");
INSERT INTO beo_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Daeya eno sibi mano amo hahabe hamoi defele hamoma. Amola waini hano defele ima. Amo amola da ha:i manu iasu. Hina Gode da amo ea gabusiga: hahawane naba. ");
INSERT INTO beo_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Sa:bade eso amoga sibi mano gawali aduna ode afae lalelegei, ledo hamedei amo ima. Amoga2 gilogala:me widi falaua (olife susuligi bibiogoi) amola waini iasu gilisima. ");
INSERT INTO beo_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Amo Gobei Iasu (Wadela:i Hou Dabe Ima:ne Iasu), dilia Sa:bade eso huluane hamoma. Amola amo esoha, eso huluane hamosu iasu amola ea waini hano iasu amo gilisili hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Eso age oubi huluane ganodini, Hina Godema Wadela:i Hou Dabe Ima:ne Iasu hamoma. Amo da bulamagau gawali waha debe aduna, sibi gawali afae amola sibi mano gawali ode afae lalelegei fesuale, huluane da ledo hamedei noga:i fawane, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Gala:ine Iasu da falaua amola olife susuligi gilisi. Bulamagau gawali afae afae amoga widi falaua3 gilogala:me gilisima. Sibi gawali amoga 2 gilogala:me falaua gilisima. ");
INSERT INTO beo_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Sibi mano gawali afae afae amoga1 gilogala:me falaua gilisima. Amo Wadela:i Hou Dabe Ima:ne Iasu da ha:i manu iasu, amola amoga ea gabusiga: Hina Gode da hahawane naba. ");
INSERT INTO beo_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Waini iasu da agoane imunu. Bulamagau gawali afae afae amoga2lida waini hano. Sibi gawali amoga1 1/2lida waini hano. Amola sibi mano afae afae amoga 1 lida waini hano ima. Malasu da agoane gala. Oubi huluane eso age amoga, Wadela:i Hou Dabe Ima:ne Iasu gobei agoane hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Amola eso huluane Wadela:i Hou Dabe Ima:ne Iasu amola waini hano iasu amoga goudi gawali afae amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu amo hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Baligisu Lolo Nasu amo da Hina Godema nodoma:ne hamosa, amo da eso 14oubi age amoga hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Eso 15 amoga, Hina Godema dawa:ma:ne gilisisu hamoma. Amo gilisisu eso fesuale hamoma, amola amoga dilia agi da yisidi hame sali liligi fawane manu. ");
INSERT INTO beo_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Eso age amoga gilisisu da, Hina Godema nodone sia:ne gadomusa: gilisima. Amo esoha, hawa: hamosu mae hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Wadela:i Hou Dabe Ima:ne Iasu gobele salima. Amo da Hina Godema ha:i manu iasu. Amo iasu da bulamagau gawali waha debe aduna, sibi gawali afae amola ode afae lalelegei sibi mano gawali. Amo liligi da noga:idafa ledo hamedei liligi fawane. ");
INSERT INTO beo_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Amola sia:i liligi gala:ine iasu amo falaua amola olife susuligi gilisi ima. Bulamagau gawali amoga gilogala:me udiana gilisima amola sibi gawali amoga gilogala:me aduna gilisima, ");
INSERT INTO beo_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","amola sibi mano afae afae amoga gilogala:me afadafa gilisima. ");
INSERT INTO beo_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Amola goudi gawali afae, Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne, ima. Amo da Isala:ili dunu ilia ledo hamoi dodofema:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Amo da gilisili eso huluane Wadela:i Hou Dabe Ima:ne Iasu (Gobei Iasu) amola hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Amo defele, Hina Godema ha:i manu iasu ima! Amo ea gabusiga:, E da hahawane naba. Amola eso huluane Wadela:i Hou Dabe Ima:ne Iasu amola waini iasu gilisili hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Eso fesu ganodini, Hina Godema nodone sia:ne gadomusa: gilisima. Amola amo esoga hawa: hamosu mae hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Ha:i Manu Gaheabolo Fai Lolo Nasu gilisisu amoga, eso agega, dilia da gagoma gaheabolo iasu Hina Godema iasea, Ema nodone sia:ne gadomusa: gilisima. Hawa: hamosudafa mae hamoma. ");
INSERT INTO beo_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Hina Gode amo gabusiga: hahawane nabima:ne, Ema Wadela:i Hou Dabe Ima:ne Iasu (gobei) agoane ima amo bulamagau gawali waha debe aduna, sibi gawali afae amola sibi mano gawali ode afae lalelegei fesuale gala, amo huluane da noga:i ledo hamedei fawane ima. ");
INSERT INTO beo_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Amola sia:i liligi Gala:ine Iasu, amo falaua amola olife susuligi gilisili ima. Bulamagau gawali amoga gilogala:me udiana gilisima amola sibi gawali amoga gilogala:me aduna gilisima, ");
INSERT INTO beo_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","amola sibi mano afae afae amoga gilogala:me afadafa gilisima. ");
INSERT INTO beo_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Amola goudi gawali afae Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne, ima. Amo da Isala:ili dunu ilia ledo hamoi dodofema:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Amo amola waini hano iasu, amola eso huluane Wadela:i Hou Dabe Ima:ne Iasu (Gobei Iasu) amola Gala:ine Iasu amo gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Oubi fesu amola eso age amoga dilia Hina Godema nodone sia:ne gadoma:ne gilisima. Hawa: hamosudafa mae hamoma. Amo esoha, dalabede duma. ");
INSERT INTO beo_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Hina Godema Wadela:i Hou Dabe Ima:ne Iasu (Gobei Iasu) ima, E da amo ea gabusiga: hahawane nabima:ne. Amo da bulamagau gawali waha debe afae, goudi gawali afae amola sibi mano gawali, ode afae lalelegei, fesuale gala. Huluane da noga:i, ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Amola sia:i liligi Gala:ine Iasu, amo falaua amola olife susuligi gilisi ima. Bulamagau gawali amoga gilogala:me udiana gilisima amola sibi gawali amoga gilogala:me aduna gilisima, ");
INSERT INTO beo_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","amola sibi mano afae afae amoga gilogala:me afadafa gilisima. ");
INSERT INTO beo_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Amola goudi gawali afae Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne ima. Amo da Isala:ili dunu ilia ledo hamoi dodofema:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Amo da gilisili eso huluane Wadela:i Hou Dabe Ima:ne Iasu Gobei (gala:ine iasu amola waini hano iasu amoga gilisi) amola hamoma. Amo ha:i manu iasu gabusiga: da Hina Gode Ea hahawane nabima:ne hamosa. ");
INSERT INTO beo_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Eso nabu amola oubi fesu amoga, Hina Godema nodone sia:ne gadomusa: gilisima. Amo esoha, ha:i mae moma amola hawa: hamosu mae hamoma. ");
INSERT INTO beo_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Hina Godema Wadela:i Hou Dabe Ima:ne Iasu Gobei ima. E da amo ea gabusiga: hahawane nabima:ne. Amo da bulamagau gawali waha debe afae, sibi gawali afae amola sibi mano ode afae lalelegei fesuale gala. Huluane da noga:i, ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Amola hamoma:ne sia:i liligi Gala:ine Iasu amo falaua amola olife susuligi gilisi ima. Bulamagau gawali afae afae amoga gilogala:me udiana gilisima. Sibi gawali amoga gilogala:me aduna gilisima, ");
INSERT INTO beo_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","amola sibi mano afae afae amoga gilogala:me afadafa gilisima. ");
INSERT INTO beo_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Amola goudi gawali afae eno Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne ima. Amo da gilisili goudi amo da dunu ilia ledo hamoi dodofema:ne hamoma. Amola eso huluane Wadela:i Hou Dabe Ima:ne Iasu Gobei (gala:ine iasu amola waini hano iasu amoga gilisi) amo huluane iasu hamoma. ");
INSERT INTO beo_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Oubi fesuga, eso 15 amoga, Hina Godema nodone sia:ne gadomusa: gilisima. Eso fesuale amoga, Hina Godema nodoma:ne gilisima, amola hawa: hamosu mae hamoma. ");
INSERT INTO beo_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Amo gilisisuga eso age amoga Hina Godema ha:i manu iasu, ea gabusiga: E da hahawane nabima:ne, gobele salima. Amo da bulamagau gawali waha debe13 agoane, sibi gawali aduna amola sibi mano gawali ode afae lalelegei 14agoane. Huluane da noga:idafa, ledo hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Amola hamoma:ne sia:i liligi Gala:ine Iasu, amo falaua amola olife susuligi gilisi ima. Bulamagau afae afae amoga gilogala:me udiana gilisima. Sibi gawali afae afae amoga gilogala:me aduna gilisima, ");
INSERT INTO beo_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","amola sibi mano afae afae amoga gilogala:me afadafa gilisima, amola waini hano ilegei iasu gilisima. ");
INSERT INTO beo_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Amola goudi gawali afae amo Wadela:i Hou Gogolema:ne Olofoma:ne Iasu hamoma:ne ima. Amo da gilisili eso huluane Wadela:i Hou Dabe Ima:ne Iasu Gobei (gala:ine iasu amola waini hano iasu amoga gilisi) amola hamoma. ");
INSERT INTO beo_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Eso ageyadu amoga bulamagau gawali waha debe fagoyale gala amola sibi gawali aduna amola sibi mano gawali ode afae lalelegei 14, huluane noga:i ledo hamedei, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","19","Iasu amo da eso age amoga gobele sali, amo defele amola gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Eso osoda amoga bulamagau gawali waha debe gidayale gala amola sibi gawali aduna amola sibi mano gawali ode afae lalelegei 14, huluane noga:i, ledo hamedei, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","22","Iasu amo da eso age amoga gobele sali, amo defele amola gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Eso biyadu amoga, bulamagau gawali waha debe nabuane gala, amola sibi gawali aduna, amola sibi mano gawali ode afae lalelegei 14, huluane noga:i, ledo hamedei, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","25","Iasu amo da eso age amoga gobele sali, amo defele amola gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Eso bi amoga, bulamagau gawali waha debe sesegeyale gala, sibi gawali aduna amola sibi mano gawali ode afae lalelegei geyale gala, huluane noga:i, ledo hamedei, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","28","Iasu huluane amo da eso age amoga gobele sali, amo defele amola gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Eso gafe amoga, bulamagau gawali waha debe godoane gala, sibi gawali aduna amola sibi mano gawali14 amo da ode afae lalelegei, huluane noga:i, ledo hamedei, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","31","Iasu huluane amo da eso age amoga gobele sali, amo defele gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Eso fesu amoga, bulamagau gawali waha debe fesuale gala, sibi gawali aduna amola sibi mano gawali14 amo da ode afae lalelegei, huluane noga:i ledo hamedei, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","34","Iasu huluane amo da eso age amoga gobele sali, amo defele gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Eso godo amoga, Hina Godema nodone sia:ne gadomusa: gilisili, hawa: hamosu mae hamoma. ");
INSERT INTO beo_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Hina Godema Wadela:i Hou Dabe Ima:ne Iasu, ha:i manu iasu, E da amo ea gabusiga: hahawane nabima:ne, amo Ema ima. Amo da bulamagau gawali waha debe afae, sibi gawali afae amola sibi mano gawali ode afae lalelegei fesuale gala, huluane da noga:i, ledo hamedei, amo ima. ");
INSERT INTO beo_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","Iasu huluane amo da eso age amoga gobele sali, amo defele gilisili ima. ");
INSERT INTO beo_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Amo huluane da malasu dilia da Gobei Iasu (Wadela:i Hou Dabe Ima:ne Iasu) amola Hina Godema Gala:ine Iasu, Waini Hano Iasu amola Hahawane Gilisili Olofole Iasu dilia da Lolo Nasu Gilisisu ilegei amoga hamoma:ne i. Amo iasu liligi dilia hahawane udigili Iasu amo dilia ilegele sia:i, o udigili imunusa: dawa:sa, amoma gilisima. ");
INSERT INTO beo_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Amaiba:le, Mousese da Hina Gode ema hamoma:ne sia:i liligi huluane, amo Isala:ili dunu ilima alofele adole i. ");
INSERT INTO beo_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mousese da amo malasu Isala:ili fi ilia ouligisu dunu ilima olelei. ");
INSERT INTO beo_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Dunu da liligi amo Hina Godema imunusa: sia:ne ilegesea o hou afae maedafa hamoma:ne sia:ne ilegesea, e da amo dafawane sia: mae giadofale, hi hamoma:ne sia:i huluane defele hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Uda a:fini da ea ada diasu ganodini esalea, e da Hina Godema liligi imunusa: ilegesea o hou afae hame hamomu ilegesea, ");
INSERT INTO beo_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ea ada da amo nababeba:le, logo hedofamusa: hame sia:sea, e da ea hamomusa: liligi huluanedafa hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Be ea ada da amo nababeba:le, amo hamoma:ne ilegele sia:i mae hamoma:ne sia:sea, e da amo hamoma:ne sia:i ilegei hame hamomu. Hina Gode da ea hamoma:ne sia:i ilegei giadofai ba:sea, e gogolema:ne olofomu. Bai ea ada da e amo mae hamoma:ne, logo hedofai dagoi. ");
INSERT INTO beo_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","A:fini gawa hame fi amo da hamomusa: sia: ilegesea, (dawa:iwane o udigili mae dawa:iwane) o hou maedafa hamoma:ne ilegele sia:sa, be amoane e da dunuga lai dagoi ba:sea, ");
INSERT INTO beo_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","egoa da logo hedofale hame sia:sea, e da ea ilegele hamomusa: sia:i liligi huluane defele hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Be egoa da amo ilegele hamomusa: sia:i mae hamoma:ne sia:sea, e da ea ilegei hamoma:ne sia:i amo yolesimu da defea. Amasea, Hina Gode da ea hou gogolema:ne olofomu. ");
INSERT INTO beo_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Uda didalo o uda egoa fisiagai da hamomusa: sia: ilegesea, e da amo sia:i huluane dafawane hamoma:mu, amola e da hou afae hame hamomusa: ilegele sia:sea, e da amo defele hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Uda amo da egoa gala, e da hamomusa: sia: ilegesea o hou afae hame hamomusa: ilegele sia:sea, ");
INSERT INTO beo_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","egoa da amo sia: nabasea, ea logo hame hedofasea, e da ea hamomusa: sia:i ilegei huluane defele hamoma:mu. ");
INSERT INTO beo_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Be egoa da ea ilegei sia:i amo nababeba:le, amo sia:i mae hamomusa: sia:sea, e da ea hamomusa: ilegei sia:i hame hamomu da defea. Hina Gode da ea giadofai amo gogolema:ne olofomu. Bai egoa da ea ilegei sia:i mae hamomusa: sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Egoa da ea hamomusa: ilegei sia:i o hou afae mae hamomusa: ilegele sia:i amo logo hedofamusa: defele gala. ");
INSERT INTO beo_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Be egoa da amo hamomusa: ilegele sia:i nabasea, eso afae aligili, hame hihini sia:i ba:sea, amasea amo uda da ea ilegele sia:i defele hamomusa: sia:ma. Egoa da eso amoga e da ilegele sia:i nabasea, hame hedofama:ne sia:beba:le, e da amo ilegele sia:i da defea fedege agoane sia:i dagoi. ");
INSERT INTO beo_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Be e da fa:no agoane, amo hamomusa: ilegele sia:i liligi logo hedofasea, amo ilegele hamomusa: sia:i da hame hamoi ba:sea, giadofai da egoa ea: fawane amola e da amoga se dabe lamu. ");
INSERT INTO beo_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Hina Gode da Mousesema amo sema i. Amo sema da ilegele hamomusa: sia:i amo da gawa hame fi a:fini da eda diasua esala amola dunuga lai uda, amo elea hou olelesa. ");
INSERT INTO beo_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Midia:ne dunu da Isala:ili fi ilima wadela:le hamoi. Amaiba:le, ilima se dabe iasu ima. Amo hamonanu, di da bogosu ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Amaiba:le, Mousese da Isala:ili dunu ilima amane sia:i, “Gegemusa: momagema! Dilia da Midia:ne fi doagala:le, amola ilia da Hina Godema wadela:le hamobeba:le, ilima se dabe ima. ");
INSERT INTO beo_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Isala:ili fi afae afae amoga 1000 dunu agoane gegemusa: asunasima.” ");
INSERT INTO beo_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Amaiba:le, Isala:ili fi afae afae da dunu 1000 agoane ilegei. Huluane da dunu 12,000 amola huluane da gegemusa: momagei. ");
INSERT INTO beo_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mousese da amo dunu gegemusa: asunasi. E da Finia:se (Elia:isa, gobele salasu dunu amo egefe) amo dunu ili bisimusa: asunasi. E da Hina Gode Abula Diasu sema liligi gaguli asi amola dawa:digisu wesu dalabede amola gaguli asi. ");
INSERT INTO beo_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ilia da Hina Gode Ea Mousesema hamoma:ne sia:i defele, Midia:ne dunu doagala:le, dunu huluane medole legei dagoi. ");
INSERT INTO beo_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ilia da Midia:ne hina bagade biyale gala amo Ifai, Legeme, Sua, Hua amola Liba, medole legei. Amola ilia da Ba:ila:me (Bio egefe) amo medole legei. ");
INSERT INTO beo_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Isala:ili dunu da Midia:ne uda amola mano huluane doagala:le lai, amola ilia bulamagau amola ohe fi huluane lai. Ilia liligi amola muni huluane lale, ");
INSERT INTO beo_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ilia moilai amola fisisu huluane laluga ulagi. ");
INSERT INTO beo_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ilia da liligi lai amola Midia:ne uda amola mano amola ohe huluane amo lale, ");
INSERT INTO beo_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Mousese, Elia:isa amola Isala:ili dunu huluane ilima oule misi. Isala:ili dunu ilia fisisu, da Moua:be umiga, Yodane hano eso mabe bega: dialebe ba:i. Yeligou moilai bai bagade da hano na:iyadodili ba:i. ");
INSERT INTO beo_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mousese, Elia:isa amola Isala:ili ouligisu dunu huluane da fisisu fisili, dadi gagui dunu yosia:musa: gadili asi. ");
INSERT INTO beo_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mousese da dadi gagui ouligisu dunu (amo da gegemusa: asili sinidigi. Ilia afae afae da dadi gagui gilisisu bagade amola fonobahadi amo ouligi) ilima ougi galu. ");
INSERT INTO beo_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","E da ilima adole ba:i, “Dilia da abuliba:le uda huluane esaloma:ne fisiagabela:? ");
INSERT INTO beo_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Bu dawa:ma! Amo uda ilia da Ba:ila:me ea olelesu amo fa:no bobogele, Bio goumi amogawi, Isala:ili dunu Hina Gode Ea hou fisima:ne olelei. Olo bagade Hina Gode Ea fi dunuma misi, amo ea bai da goea. ");
INSERT INTO beo_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Wali goi huluane amola uda amo da dunuma gilisili golai huluane, amo medole legema. ");
INSERT INTO beo_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Be dilia lama:ne, uda mano amola uda da dunuma gilisili hame golai, amo esaloma:ne fisiagama. ");
INSERT INTO beo_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Amola dilia! Nowa da dunu medole legei o bogoi da:i hodo digili ba:i galea, dilia fisisu gadili eso fesuale esaloma. Eso osoda amola eso fesu amoga dilia da:i amola uda amo dilia samogele lai amo huluane sema dodofesu hou hamoma. ");
INSERT INTO beo_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Amola dilia abula huluane amola liligi amo da bulamagau gadofo o goudi hinabo o ifa amoga hamoi amo huluane sema dodofesu hou hamoma.” ");
INSERT INTO beo_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Gobele salasu dunu Elia:isa da gegena asi buhagi dunuma amane sia:i, “Malasu amo Hina Gode da Mousesema i da goea. ");
INSERT INTO beo_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Liligi huluane amo da nemu gogolei (gouli, silifa, balase, gula, dini, lede, amola enoenoi) dilia lalu gobele dodofemu. Liligi huluane enoenoi, dilia sema dodofesu hano amoga dodofema. ");
INSERT INTO beo_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Eso fesu amoga dilia abula dodofema. Amasea dilia da sema dodofei dagoiba:le, fisisu amo ganodini sa:ima:ne logo doasi dagoi ba:mu.” ");
INSERT INTO beo_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Hina Gode da Mousesema amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Di, Elia:isa amola Isala:ili fi ouligisu dunu huluane da lai liligi huluane (amo da uda amola ohe samogele lai) amo idima. ");
INSERT INTO beo_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Lai liligi amo dogoadafa momogima. Na:iyado mogi amo dadi gagui dunu iligili ima, amola na:iyado la:idi da Isala:ili dunu huluanema ima. ");
INSERT INTO beo_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Dadi gagui ilia lai amoga Hina Godema ima:ne agoane lama. Udigili hawa: hamosu uda 500 gilisisu afae afae amoga uda afae ima. Amola sibi, bulamagau, dougi amola goudi 500 gilisisu amoga ohe afae defele ima. ");
INSERT INTO beo_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Amo liligi Hina Godema iasudafa ima:ne, gobele salasu dunu Elia:isa ema ima. ");
INSERT INTO beo_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Isala:ili dunu eno ilia lai liligi amoga udigili hawa: hamosu uda 50 gilisisu afae afae amoga uda afae ima amola bulamagau, dougi, sibi amola goudi 50 gilisisu afae afae amoga ohe afae defele ima. Lifai dunu da Hina Gode Ea Abula Diasu ouligisa. Amo liligi ilima ima. ");
INSERT INTO beo_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mousese amola Elia:isa da Hina Gode Ea hamomusa: sia:i amo defele hamoi. ");
INSERT INTO beo_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","Dadi gagui dunu da liligi lai mogili ilisu gagui. Eno liligi ea dedena sa:i da agoane:- Sibi amola goudi 675,000; bulamagau 72,000; dougi 6l,000 amola dunuga hame dawa:digi uda 32,000. ");
INSERT INTO beo_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","Dadi gagui ilia dogoa fifi mogi da:- Sibi amola goudi 337,500 (Hina Godema iasu da 675); Bulamagau 36,000 (Hina Godema iasu da 72); Dougi 30,500 (Hina Godema iasu da 61); dunuga hame dawa:digi uda 16,000 (Hina Godema iasu da 32). ");
INSERT INTO beo_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Amaiba:le, Mousese da Hina Gode Ea hamoma:ne sia:i defele, Hina Godema iasudafa ima:ne, amo ilegei liligi Elia:isa ema i dagoi. ");
INSERT INTO beo_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","Isala:ili fi dunu huluane ilima dogoa fifi mogi da dadi gagui dunu ilia lai defele ba:i, agoane:- Sibi amola goudi 337,500; bulamagau 36,000; dougi 30,500; dunuga gilisili hame golai uda 16,000. ");
INSERT INTO beo_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Amoga Mousese da Hina Gode Ea sia:i defele 50 gilisisu afae afae amoga afae lale, Lifai dunu (amo da Hina Gode Ea Abula Diasu ouligisu) ilima i. ");
INSERT INTO beo_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Amasea, dadi gagui ouligisu dunu (amo da Midia:ne dunuma gegesu ganodini, Isala:ili dadi gagui ouligi) ilia da Mousesema asili, ");
INSERT INTO beo_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ema sia:ne i, “Hina! Ninia da dadi gagui dunu amo nini ouligilalu, amo huluane idili dagole, afae hame fisiagai ba:i. ");
INSERT INTO beo_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Amaiba:le, ninia da gouliga nina: hamoi liligi, amola nabu, lobo fasele fesu, lobosogo salasu, gegagulu amola bida ga:su ninia lai, amo gaguli manebe goea. Hina Gode da nini gaga:iba:le, amola E da fa:no nini esalusu gaga:ma:ne, ninia da amo liligi Ema iaha.” ");
INSERT INTO beo_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mousese amola Elia:isa da amo liligi lai. Huluane da nina: hamoi liligi fawane gala. ");
INSERT INTO beo_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Isala:ili dadi gagui ouligisu dunu ilia iabe huluane da gadenenewane 200 gilogala:me dioi defei amoma doaga:i. ");
INSERT INTO beo_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Be dadi gagui dunudafa da ilia lai liligi, ilila: gagulaligi. ");
INSERT INTO beo_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Amaiba:le, Hina Gode da Isala:ili dunu gaga:ma:ne, Mousese amola Elia:isa da gouli liligi huluane Hina Gode Ea Abula Diasuga gaguli asi. ");
INSERT INTO beo_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Liubene fi amola Ga:de fi ilia ohe fofoi da bagohamedafa. Ilia da Ya:isa amola Gilia:de soge da ohe fofomu noga:idafa ba:beba:le, ");
INSERT INTO beo_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ilia da Mousese, Elia:isa amola Isala:ili ouligisu dunu ilima asili, amane sia:i, ");
INSERT INTO beo_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Hina Gode da fidibiba:le, Isala:ili dunu da amo soge (moilai A:dalode, Daibone, Ya:isa, Nimila, Hesiabone, Ilia:ile, Sibima, Nibou amola Bione) amo huluane fedelai dagoi. Amola ninia ba:loba amo soge da ohe fofomu noga:idafa ba:sa. ");
INSERT INTO beo_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Amaiba:le, ninia dilima edegesa. Ninia gaguli fima:ne, amo soge ninima ima. Nini da Yodane Hano degele, na:iyadodili amo lale fima:ne mae sia:ma.” ");
INSERT INTO beo_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mousese da bu adole i, “Dilia fidafa Isala:ili dunu da gegena ahoasea, dilia da guiguda: esalumu da defeala:? ");
INSERT INTO beo_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Isala:ili dunu da Yodane Hano degele, soge amo Hina Gode da ilima ilegele i, amo ganodini fimu. Dilia da abuliba:le ili dogoa da:i dioma:ne sia:sala:? ");
INSERT INTO beo_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Dilia musa: ada ilia agoane hamoi. Na da Ga:idesie Bania amogawi ili Ga:ina:ne soge hogoma:ne, asunasi. ");
INSERT INTO beo_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ilia da asili, soge hogolalu, Esiegole Fago amoga doaga:i. Be ilia da buhagili, Isala:ili dunu da soge amo Hina Gode da ilima i, amo ganodini mae masa:ne, ilia dogo ganodini da:i dioma:ne egane sia:i. ");
INSERT INTO beo_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Amo esoga, Hina Gode da ougi ba:i. E da amane ilegele sia:i, ");
INSERT INTO beo_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Na da dafawane ilegele sia:sa. Dunu huluane amo da Idibidi sogega misi amola lalelegesu ode 20 fisiagai amola amo ode idi baligili esala, ilia da soge amo Na da A:ibalaha:me, Aisage amola Ya:igobe ilima ima:ne ilegele sia:i, ilia da amo ganodini hamedafa masunu. Bai ilia da Nama hagai galu.’ ");
INSERT INTO beo_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Amo da Isala:ili asigilai dunu huluanedafa. Be Ga:ilebe (Yifane, Ginesaide dunu amo egefe) amola Yosiua (Nane egefe) ela fawane da ganodini masunu. Bai ela fawane da Hina Godema hame hagai galu. ");
INSERT INTO beo_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Hina Gode da Isala:ili dunu ilima ougi galu. Ea hamobeba:le, ilia da wadela:i hafoga:i soge amo ganodini ode 40 agoane udigili lalu. Amalalu, dunu huluanedafa da Ema ougima:ne hamoiba:le, ili da bogogia:i dagoi ba:i. ");
INSERT INTO beo_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Amola wali dilia da ilia sogebi lai dagoi. Dilia da wadela:i fi gaheabolo amola dilia hame nabasu hou hamomuba:le, Hina Gode da bu Isala:ili fi ilima mihanane ougimu. ");
INSERT INTO beo_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Dilia Liubene amola Ga:de fi dunu da wali Ema fa:no bobogemu higasea, E da bu Isala:ili dunu huluane wadela:i hafoga:i soge ganodini udigili laloma:ne yolesimu. Amola ilia da gugunufinisi dagoi ba:mu. Bai dilia hamobeba:le.” ");
INSERT INTO beo_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Liubene amola Ga:de dunu da Mousesema misini, amane sia:i, “Ninia bisili ninia sibi gaga:ma:ne, gelega gagoma:ne amola ninia sosogo fi esaloma:ne osobo dogomusa:, logo doasima. ");
INSERT INTO beo_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Amasea, ninia da ninia Isala:ili fi eno ilima gilisili gegemusa: masunu. Ninia da ilia doagala:su amo bisili masunu amola mae fisili, ilia da ilia sogedafa amo lale fi dagosea fawane buhagimu. Be ninia da amo gegemusa: ahoasea, ninia uda amola mano da goeguda: gagili sali moilai amo ganodini esalumu. Ilia amogawi fi dunu amoga hahawane gaga:i dagoi ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ninia da ninia diasudafa amoguda: hedolo hame buhagimu. Be Isala:ili dunu oda ilia huluane da ilima ilegei soge amo lai dagobeba:le fawane buhagimu. ");
INSERT INTO beo_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ilia da Yodane Hano na:iyadodili soge lasea, ninia da hame lamu. Bai ninia da Yodane Hano eso midadi heda:su gusudili lai dagoi.” ");
INSERT INTO beo_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mousese da bu adole i, “Dilia adomusa: fawane hanai galea, guiguda: Hina Gode ba:ma:ne, dilia gegena masusa: momagema! ");
INSERT INTO beo_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Dilia gegesu dunu huluane da Yodane Hano degemu. Amasea, Hina Gode da ili ouligimu. Ilia da ilia ha lai amo doagala:le, amola Hina Gode da ili hasalili, ");
INSERT INTO beo_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ilia soge huluane lale gagamu. Amalalu, dilia buhagimu da defea. Bai dilia da dia Hina Godema amola dilia Isala:ili fi hamoma:ne ilegei amo hamoi dagoi ba:mu. Amasea, Hina Gode da amo soge Yodane Hano eso midadi heda:su gusudili gala, da dilia sogedafa sia:mu. ");
INSERT INTO beo_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Be na da dilima sisasu olelesa. Dilia da dilia hamomusa: sia:i ilegei amo giadofale hamosea, dilia Hina Godema wadela:le hamoi dagoi ba:mu. Sia: noga:le dawa:ma! Dilia wadela:i hou hamosea, Hina Godema wamolegemu da hamedei ba:mu. ");
INSERT INTO beo_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Amaiba:le, dilia moilai dogoma amola sibi gagoi hamoma. Be dilia hamomusa: ilegele sia:i, amo noga:le hamoma.” ");
INSERT INTO beo_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Ga:de amola Liubene fi dunu da Mousesema amane sia:i, “Hina! Ninia da dia hamoma:ne sia:i defele hamomu. ");
INSERT INTO beo_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ninia uda, mano, bulamagau amola sibi da Gilia:de soge moilai goeguda: esaloma:mu. ");
INSERT INTO beo_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Be ninia huluane da Hina Godema fa:no bobogele gegemusa: momageiwane esala. Ninia da dia sia:i defele, Yodane Hano degele, gegena masunu.” ");
INSERT INTO beo_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Amaiba:le, Mousese da Elia:isa, Yosiua amola eno Isala:ili ouligisu dunu ilima amane hamoma:ne sia:i, ");
INSERT INTO beo_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Ga:de amola Liubene fi dunu da Hina Gode Ea hamoma:ne sia:sea, amola gegemusa: Yodane Hano degesea, amola ilia da dili fidisia, amola Ga:ina:ne soge fi hasalasea, Gilia:de soge amo ilia gagulaligima:ne ilima ima. ");
INSERT INTO beo_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Be ilia da dili gilisili gegemusa: Yodane Hano hame degesea, defea, ilia da dili defele Ga:ina:ne soge ganodini ilima ilegei soge mogi amo lamu.” ");
INSERT INTO beo_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Ga:de amola Liubene fi dunu da bu adole i, “Hina! Ninia da Hina Gode Ea hamoma:ne sia:i amo defele hamomu. ");
INSERT INTO beo_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ninia da guiguda: Yodane Hano eso midadi heda:su gusudili soge amo gagulaligima:ne, Hina Gode Ea hamoma:ne sia:i amo fa:no bobogele, Yodane Hano degele, Ga:ina:ne soge fi dunuma gegemusa: masunu.” ");
INSERT INTO beo_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Amaiba:le, Mousese da Ga:de amola Liubene fi amola Ma:na:se fi dogoa mogi la:idili, ilima A:moulaide hina bagade Saihone amola Ba:isia:ne hina bagade Oge amo ela soge huluane ilima ilegele i. E da amo soge ea moilai huluane amola soge amoga sisiga:le diala, amo huluane ilima i. ");
INSERT INTO beo_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","36","Ga:de fi dunu da musa: gagili sali moilai mugului (amo Daibone, A:dalode, Aloua, A:dalodi Sioufa:ne, Ya:isa, Yogebiha, Bede Nimila, amola Bede Ha:ila:ne) amo huluane bu hiougi. ");
INSERT INTO beo_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","38","Liubene fi dunu da moilai amo Hesiabone, Ilia:ile, Giliada:ime, Nibou, Ba:ile Mione amola Sibima bu gagui. Ilia da moilai huluane amo ilia bu gagui amoma dio gaheabolo asuli. ");
INSERT INTO beo_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Ma:ige (Ma