﻿USE sofia;
DROP TABLE IF EXISTS sofia.benobcv_vpl;
CREATE TABLE benobcv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES benobcv_vpl WRITE;
INSERT INTO benobcv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","শুরুতে ঈশ্বর আকাশমণ্ডল ও পৃথিবী সৃষ্টি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","এমতাবস্থায় পৃথিবী নিরবয়ব ও ফাঁকা ছিল, গভীরের উপরের স্তরে অন্ধকার ছেয়ে ছিল, এবং ঈশ্বরের আত্মা জলের উপর ভেসে বেড়াচ্ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","আর ঈশ্বর বললেন, “আলো হোক,” এবং আলো হল। ");
INSERT INTO benobcv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ঈশ্বর দেখলেন যে সেই আলো ভালো হয়েছে, এবং তিনি অন্ধকার থেকে আলোকে বিচ্ছিন্ন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ঈশ্বর আলোকে “দিন” নাম দিলেন এবং অন্ধকারকে “রাত” নাম দিলেন। সন্ধ্যা হল এবং সকাল হল—এই হল প্রথম দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","আর ঈশ্বর বললেন, “পৃথিবীর জল থেকে আকাশের জলকে আলাদা করার জন্য এই দুই ধরনের জলের মাঝখানে উন্মুক্ত এলাকা তৈরি হোক।” ");
INSERT INTO benobcv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","অতএব ঈশ্বর উন্মুক্ত এলাকা তৈরি করলেন এবং সেই এলাকার উপরের ও নিচের জলকে আলাদা করে দিলেন। আর তা সেইমতোই হল। ");
INSERT INTO benobcv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ঈশ্বর সেই উন্মুক্ত এলাকাকে “আকাশ” নাম দিলেন। আর সন্ধ্যা হল ও সকাল হল—এই হল দ্বিতীয় দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","আর ঈশ্বর বললেন, “আকাশের নিচের সব জল এক স্থানে জমা হোক, এবং শুকনো জমি দৃষ্টিগোচর হোক।” আর তা সেইমতোই হল। ");
INSERT INTO benobcv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ঈশ্বর সেই শুকনো জমির নাম দিলেন “ভূমি” এবং জমা জলকে তিনি “সমুদ্র” নাম দিলেন। আর ঈশ্বর দেখলেন যে সেটি ভালো হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","পরে ঈশ্বর বললেন, “ভূমি গাছপালা উৎপন্ন করুক: সেগুলির বিভিন্ন ধরন অনুসারে ভূমিতে উৎপন্ন সবীজ লতাগুল্ম ও বীজ সমেত ফল উৎপাদনকারী গাছ উৎপন্ন হোক।” আর তা সেইমতোই হল। ");
INSERT INTO benobcv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ভূমি গাছপালা উৎপন্ন করল: নিজস্ব প্রজাতি অনুসারে বীজ উৎপাদনকারী লতাগুল্ম এবং নিজস্ব প্রজাতি অনুসারে বীজ সমেত ফল উৎপাদনকারী গাছ উৎপন্ন হল। এবং ঈশ্বর দেখলেন যে সেগুলি ভালো হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","আর সন্ধ্যা হল ও সকাল হল—এই হল তৃতীয় দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","আর ঈশ্বর বললেন, “রাত থেকে দিনকে আলাদা করার জন্য আকাশের উন্মুক্ত এলাকায় জ্যোতি হোক, এবং বিভিন্ন ঋতু, দিন ও বছর চিহ্নিত করার জন্য এগুলি নিদর্শনরূপে কাজ করুক, ");
INSERT INTO benobcv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","আর পৃথিবীতে আলো দেওয়ার জন্য এগুলি আকাশের উন্মুক্ত এলাকায় আলোর উৎস হয়ে যাক।” আর তা সেরকমই হল। ");
INSERT INTO benobcv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ঈশ্বর দুটি বড়ো জ্যোতি তৈরি করলেন—দিন নিয়ন্ত্রিত করার জন্য অপেক্ষাকৃত বড়ো জ্যোতি এবং রাত নিয়ন্ত্রিত করার জন্য অপেক্ষাকৃত ছোটো জ্যোতি। তিনি তারকামালাও তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","পৃথিবীতে আলো দেওয়ার জন্য ঈশ্বর সেগুলিকে আকাশের উন্মুক্ত এলাকায় বসিয়ে দিলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","যেন সেগুলি দিন ও রাতের উপরে প্রভুত্ব করতে পারে, এবং অন্ধকার থেকে আলোকে আলাদা করতে পারে। আর ঈশ্বর দেখলেন যে তা ভালো হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","আর সন্ধ্যা হল এবং সকাল হল—এই হল চতুর্থ দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","আর ঈশ্বর বললেন, “জলে জীবিত প্রাণীর ঝাঁক দেখা যাক এবং আকাশে পৃথিবীর উপর পাখিরা উড়ে বেড়াক।” ");
INSERT INTO benobcv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","তাই ঈশ্বর সমুদ্রের বড়ো বড়ো প্রাণীদের এবং জলে থাকা প্রত্যেকটি জীবিত ও গতিশীল জীবকে তাদের প্রজাতি অনুসারে, এবং প্রত্যেকটি ডানাযুক্ত পাখিকে তাদের প্রজাতি অনুসারে সৃষ্টি করলেন। আর ঈশ্বর দেখলেন যে তা ভালো হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ঈশ্বর তাদের আশীর্বাদ করে বললেন, “ফলবান হও ও সংখ্যায় বৃদ্ধি পেয়ে সমুদ্রের জল ভরিয়ে তোলো, এবং পৃথিবীর বুকে পাখিরাও সংখ্যায় বৃদ্ধি পাক।” ");
INSERT INTO benobcv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","আর সন্ধ্যা হল এবং সকাল হল—এই হল পঞ্চম দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","আর ঈশ্বর বললেন, “ভূমি নিজস্ব প্রজাতি অনুসারে জীবিত প্রাণী উৎপন্ন করুক: গৃহপালিত পশু, জমির সরীসৃপ প্রাণী, এবং বন্যপশু, প্রত্যেকে নিজস্ব প্রজাতি অনুসারেই হোক।” আর তা সেইমতোই হল। ");
INSERT INTO benobcv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","বন্যপশুদের তাদের নিজস্ব প্রজাতি অনুসারে, গৃহপালিত পশুদের তাদের নিজস্ব প্রজাতি অনুসারে, এবং জমির সরীসৃপ প্রাণীদের তাদের নিজস্ব প্রজাতি অনুসারে ঈশ্বর তৈরি করলেন। আর ঈশ্বর দেখলেন যে তা ভালো হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","তখন ঈশ্বর বললেন, “এসো, আমরা আমাদের প্রতিমূর্তিতে ও আমাদের সাদৃশ্যে মানুষ তৈরি করি, যেন তারা সমুদ্রের মাছেদের উপরে এবং আকাশের পাখিদের উপরে, গৃহপালিত পশুদের ও সব বন্যপশুর উপরে, এবং জমির সব সরীসৃপ প্রাণীর উপরে কর্তৃত্ব করে।” ");
INSERT INTO benobcv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","অতএব ঈশ্বর তাঁর নিজস্ব প্রতিমূর্তিতে মানুষ সৃষ্টি করলেন, ঈশ্বরের প্রতিমূর্তিতেই তিনি তাকে সৃষ্টি করলেন; পুরুষ ও স্ত্রী করে তিনি তাদের সৃষ্টি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ঈশ্বর তাদের আশীর্বাদ করে বললেন, “তোমরা ফলবান হও ও সংখ্যায় বৃদ্ধিলাভ করো; পৃথিবী ভরিয়ে তোলো ও এটি বশে রেখো। সমুদ্রের মাছগুলির উপরে ও আকাশের পাখিদের উপরে এবং প্রত্যেকটি সরীসৃপ প্রাণীর উপরে তোমরা কর্তৃত্ব কোরো।” ");
INSERT INTO benobcv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","পরে ঈশ্বর বললেন, “প্রত্যেকটি সবীজ লতাগুল্ম, যা সমগ্র পৃথিবীর বুকে উৎপন্ন হয় ও বীজ সমেত ফল উৎপাদনকারী প্রত্যেকটি গাছপালা আমি তোমাদের দিলাম। সেগুলি তোমাদের খাদ্যদ্রব্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","আর পৃথিবীর সব পশুর ও আকাশের সব পাখির এবং সব সরীসৃপ প্রাণীর কাছে—যে সবকিছুর মধ্যে জীবন আছে—খাদ্যদ্রব্যরূপে আমি প্রত্যেকটি সবুজ চারাগাছ দিলাম।” আর তা সেইমতোই হল। ");
INSERT INTO benobcv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ঈশ্বর যা যা তৈরি করলেন, তা তিনি দেখলেন, এবং তা খুবই ভালো হল। আর সন্ধ্যা হল ও সকাল হল—এই হল ষষ্ঠ দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","এইভাবে আকাশমণ্ডল এবং পৃথিবী ও সেখানকার সবকিছু সৃষ্টির কাজ সম্পূর্ণ হল। ");
INSERT INTO benobcv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","সপ্তম দিনে এসে ঈশ্বর তাঁর সব কাজকর্ম সমাপ্ত করলেন; তাই সপ্তম দিনে তিনি তাঁর সমস্ত কাজ থেকে বিশ্রাম নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","আর ঈশ্বর সপ্তম দিনকে আশীর্বাদ করে সেটিকে পবিত্র করলেন, কারণ এই দিনেই তিনি তাঁর সব সৃষ্টিকর্ম সম্পূর্ণ করে বিশ্রাম নিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","আকাশমণ্ডল ও পৃথিবী যখন সৃষ্টি হল, সদাপ্রভু ঈশ্বর যখন পৃথিবী ও আকাশমণ্ডল তৈরি করলেন তখন তার বর্ণনা এইরকম হল। ");
INSERT INTO benobcv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","আর তখনও পর্যন্ত পৃথিবীতে কোনও গাছপালা উৎপন্ন হয়নি এবং কোনও চারাগাছ তখনও গজিয়ে ওঠেনি, কারণ সদাপ্রভু ঈশ্বর পৃথিবীতে বৃষ্টি পাঠাননি, এবং জমিতে চাষ করার জন্য সেখানে কোনও মানুষও ছিল না, ");
INSERT INTO benobcv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","কিন্তু পৃথিবী থেকে জলধারা উঠে এল ও জমির সমগ্র বহির্ভাগ জলসিক্ত করে তুলল। ");
INSERT INTO benobcv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","সদাপ্রভু ঈশ্বর জমির ধুলো থেকে মানুষকে গড়ে তুললেন এবং তার নাকে ফুঁ দিয়ে প্রাণবায়ু ভরে দিলেন, এবং সেই মানুষ এক জীবিত প্রাণী হয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","এমতাবস্থায় সদাপ্রভু ঈশ্বর এদনে, পূর্বদিকে একটি বাগান তৈরি করলেন; এবং সেখানে তিনি তাঁর হাতে গড়া মানুষটিকে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","আর সদাপ্রভু ঈশ্বর ভূমিতে সব ধরনের গাছপালা জন্মাতে দিলেন—যেসব গাছপালা দেখতে ভালো লাগে এবং খাদ্যরূপেও যেগুলি ভালো। বাগানের মাঝখানে জীবনদায়ী গাছ এবং ভালোমন্দের জ্ঞানদায়ী গাছ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","এদন থেকে একটি নদী প্রবাহিত হয়ে বাগানটি জলসেচিত করে তুলল; সেখান থেকে এটি চার ভাগে বিভক্ত হয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","প্রথমটির নাম পীশোন; এটি সমগ্র সেই হবীলা দেশ জুড়ে প্রবাহিত হয়েছে, যেখানে সোনা পাওয়া যায়। ");
INSERT INTO benobcv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(সেই দেশের সোনা খুব উন্নত মানের; আর সেখানে সুগন্ধি ধুনো এবং স্ফটিকমণিও পাওয়া যায়) ");
INSERT INTO benobcv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","দ্বিতীয় নদীটির নাম গীহোন, এটি সমগ্র কূশ দেশ জুড়ে প্রবাহিত হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","তৃতীয় নদীটির নাম টাইগ্রিস; এটি আসিরিয়ার পূর্বদিক ঘেঁসে বয়ে গিয়েছে। চতুর্থ নদীটি হল ইউফ্রেটিস। ");
INSERT INTO benobcv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","সদাপ্রভু ঈশ্বর মানুষটিকে নিয়ে এদন বাগানে কাজ করার এবং সেটির যত্ন নেওয়ার জন্য তাকে সেখানে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","আর সদাপ্রভু ঈশ্বর সেই মানুষটিকে আদেশ দিলেন, “বাগানের যে কোনো গাছের ফল খাওয়ার ক্ষেত্রে তুমি স্বাধীন; ");
INSERT INTO benobcv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","কিন্তু ভালোমন্দের জ্ঞানদায়ী গাছের ফল তুমি অবশ্যই খেয়ো না। যদি সেই গাছের ফল খাও, তবে তুমি নিশ্চয় মারা যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","সদাপ্রভু ঈশ্বর বললেন, “মানুষের একা থাকা ভালো নয়। আমি তার উপযুক্ত এক সহকারিণী তৈরি করব।” ");
INSERT INTO benobcv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","এখন সদাপ্রভু ঈশ্বর সব বন্যপশুকে ও আকাশের সব পাখিকে মাটি দিয়ে তৈরি করলেন। সেই মানুষটি তাদের কী নাম দেয় তা দেখার জন্য ঈশ্বর তাদের তাঁর কাছে আনলেন; আর সেই মানুষটি প্রত্যেকটি জীবন্ত প্রাণীকে যে যে নাম দিলেন, তার নাম ঠিক তাই হল। ");
INSERT INTO benobcv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","অতএব সেই মানুষটি সব গৃহপালিত পশুর, আকাশের পাখিদের এবং সব বন্যপশুর নামকরণ করলেন। কিন্তু আদমের জন্য উপযুক্ত কোনও সহকারিণী পাওয়া যায়নি। ");
INSERT INTO benobcv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","অতএব সদাপ্রভু ঈশ্বর মানুষটিকে গভীর ঘুমে ঘুমিয়ে পড়তে দিলেন; এবং যখন তিনি ঘুমাচ্ছিলেন, তখন ঈশ্বর সেই মানুষটির পাঁজরের একটি হাড় বের করে নিয়ে তাঁর সেই স্থানটি মাংস দিয়ে ভরাট করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","পরে সদাপ্রভু ঈশ্বর সেই মানুষটির পাঁজরের যে হাড়টি বের করলেন, তা দিয়ে এক নারী তৈরি করলেন, এবং ঈশ্বর তাঁকে সেই মানুষটির কাছে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","মানুষটি বললেন, “এখন এই আমার অস্থির অস্থি ও আমার মাংসের মাংস; এর নাম হবে ‘নারী,’ কারণ একে নর থেকে নেওয়া হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","এই কারণে একজন পুরুষ তার পিতা ও মাতাকে ত্যাগ করে, তার স্ত্রীর সাথে সংযুক্ত হবে ও সেই দুজন একাঙ্গ হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","সেই পুরুষ ও তাঁর স্ত্রী, দুজনেই নগ্ন ছিলেন, আর তাদের কোনো লজ্জাবোধও ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","এখন সদাপ্রভু ঈশ্বরের নির্মিত যে কোনো বন্যপশুর মধ্যে সাপই ছিল সবচেয়ে ধূর্ত। সে নারীকে বলল, “সত্যিই কি ঈশ্বর বলেছেন, ‘তোমরা অবশ্যই বাগানের কোনও গাছের ফল খেয়ো না’?” ");
INSERT INTO benobcv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","নারী সাপকে বললেন, “আমরা বাগানের গাছগুলি থেকে ফল খেতে পারি, ");
INSERT INTO benobcv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","কিন্তু ঈশ্বর বলেছেন, ‘বাগানের মাঝখানে যে গাছটি আছে, তার ফল তোমরা অবশ্যই খাবে না, আর এটি তোমরা ছোঁবেও না, এমনটি করলে তোমরা মারা যাবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“অবশ্যই তোমরা মরবে না,” সাপ নারীকে বলল। ");
INSERT INTO benobcv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“কারণ ঈশ্বর জানেন যে, যখন তোমরা এটি খাবে, তখন তোমাদের চোখ খুলে যাবে, ও তোমরা ভালোমন্দ জানার ক্ষেত্রে ঈশ্বরের মতো হয়ে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","নারী যখন দেখলেন যে সেই গাছের ফলটি খাদ্য হিসেবে ভালো ও চোখের পক্ষে আনন্দদায়ক, এবং জ্ঞানার্জনের পক্ষেও কাম্য, তখন তিনি কয়েকটি ফল পেড়ে তা খেলেন। তিনি তাঁর সেই স্বামীকেও কয়েকটি ফল দিলেন, যিনি তাঁর সঙ্গেই ছিলেন ও তিনিও তা খেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","তখন তাদের দুজনেরই চোখ খুলে গেল, এবং তারা অনুভব করলেন যে তারা উলঙ্গ; তাই তারা ডুমুর গাছের পাতা একসাথে সেলাই করে নিজেদের জন্য আচ্ছাদন তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","তখন সেই মানুষটি ও তাঁর স্ত্রী সেই সদাপ্রভু ঈশ্বরের হাঁটার আওয়াজ শুনতে পেলেন, যিনি দিনের পড়ন্ত বেলায় বাগানে হেঁটে চলে বেড়াচ্ছিলেন, এবং তারা সদাপ্রভু ঈশ্বরকে এড়িয়ে বাগানের গাছগুলির আড়ালে লুকিয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","কিন্তু সদাপ্রভু ঈশ্বর সেই মানুষটিকে ডেকে বললেন, “তুমি কোথায়?” ");
INSERT INTO benobcv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","তিনি উত্তর দিলেন, “বাগানে আমি তোমার হাঁটার আওয়াজ শুনতে পেয়েছিলাম, আর আমি ভয় পেয়েছিলাম কারণ আমি যে উলঙ্গ; তাই আমি লুকিয়ে পড়েছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","আর সদাপ্রভু ঈশ্বর বললেন, “কে তোমাকে বলেছে যে তুমি উলঙ্গ? যে গাছের ফল না খাওয়ার আদেশ আমি তোমাকে দিয়েছিলাম, সেই গাছের ফল তুমি কি খেয়েছ?” ");
INSERT INTO benobcv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","মানুষটি বললেন, “আমার সঙ্গে তুমি যে নারীকে এখানে রেখেছ—সেই গাছটি থেকে কয়েকটি ফল আমায় দিয়েছিল এবং আমি তা খেয়ে ফেলেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","তখন সদাপ্রভু ঈশ্বর নারীকে বললেন, “তুমি এ কী করলে?” নারী বললেন, “সাপ আমাকে প্রতারিত করেছে, ও আমি খেয়ে ফেলেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","অতএব সদাপ্রভু ঈশ্বর সাপকে বললেন, “যেহেতু তুমি এমনটি করেছ, তাই, “সব গবাদি পশুর মধ্যে ও সব বন্যপশুর মধ্যে তুমিই হলে অভিশপ্ত! তুমি বুকে ভর দিয়ে চলবে আর সারা জীবনভর ধুলো খেয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","তোমার ও নারীর মধ্যে আর তোমার ও তার সন্তানসন্ততির মধ্যে আমি শত্রুতা জন্মাব; সে তোমার মাথা গুঁড়িয়ে দেবে আর তুমি তার পায়ের গোড়ালিতে আঘাত হানবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","সদাপ্রভু ঈশ্বর নারীকে বললেন, “আমি তোমার সন্তান প্রসবের ব্যথা খুব বাড়িয়ে দেব; প্রচণ্ড প্রসববেদনা সহ্য করে তুমি সন্তানের জন্ম দেবে। তোমার স্বামীর প্রতি তোমার আকুল বাসনা থাকবে, আর সে তোমার উপর কর্তৃত্ব করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","আদমকে তিনি বললেন, “যেহেতু তুমি তোমার স্ত্রীর কথা শুনে সেই গাছের ফল খেয়েছ, যেটির বিষয়ে আমি তোমাকে আদেশ দিয়েছিলাম, ‘তুমি এর ফল অবশ্যই খাবে না,’ তাই “তোমার জন্য ভূমি অভিশপ্ত হল; আজীবন তুমি কঠোর পরিশ্রম করে তা থেকে খাবার খাবে। ");
INSERT INTO benobcv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","তা তোমার জন্য কাঁটাগাছ ও শিয়ালকাঁটা ফলাবে, আর তুমি ক্ষেতের লতাগুল্ম খাবে, ");
INSERT INTO benobcv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","যতদিন না তুমি মাটিতে ফিরে যাচ্ছ, ততদিন তুমি কপালের ঘাম ঝরিয়ে তোমার খাবার খাবে, যেহেতু সেখান থেকেই তোমাকে আনা হয়েছে; কারণ তুমি তো ধুলো, আর ধুলোতেই তুমি যাবে ফিরে।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","আদম তাঁর স্ত্রীর নাম দিলেন হবা, কারণ তিনি হবেন সব জীবন্ত মানুষের মা। ");
INSERT INTO benobcv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","সদাপ্রভু ঈশ্বর আদম ও তাঁর স্ত্রীর জন্য চামড়ার পোশাক বানিয়ে দিলেন এবং তাদের কাপড় পরিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","আর সদাপ্রভু ঈশ্বর বললেন, “মানুষ এখন ভালোমন্দের জ্ঞান পেয়ে আমাদের একজনের মতো হয়ে গিয়েছে। তাকে এই সুযোগ দেওয়া যাবে না, যেন সে তার হাত বাড়িয়ে আবার জীবনদায়ী গাছের ফল খেয়ে অমর হয়ে যায়।” ");
INSERT INTO benobcv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","তাই সদাপ্রভু ঈশ্বর তাঁকে এদন বাগান থেকে নির্বাসিত করে সেই ভূমিতে কাজ করার জন্য পাঠিয়ে দিলেন, যেখান থেকে তাঁকে তুলে আনা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","সেই মানুষটিকে তাড়িয়ে দেওয়ার পর, এদন বাগানের পূর্বদিকে তিনি করূবদের মোতায়েন করে দিলেন এবং জীবনদায়ী গাছের কাছে পৌঁছানোর পথ রক্ষা করার জন্য ঘূর্ণায়মান জ্বলন্ত এক তরোয়ালও বসিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","আদম তাঁর স্ত্রী হবার সঙ্গে সহবাস করলেন, এবং হবা গর্ভবতী হয়ে কয়িনের জন্ম দিলেন। হবা বললেন, “সদাপ্রভুর সাহায্য নিয়ে আমি একটি পুরুষমানুষ উৎপন্ন করেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","পরে তিনি কয়িনের ভাই হেবলের জন্ম দিলেন। হেবল মেষপাল দেখাশোনা করত, এবং কয়িন জমি চাষ-আবাদ করত। ");
INSERT INTO benobcv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","অবশেষে কয়িন তার জমির কিছু ফল সদাপ্রভুর কাছে এক উপহার রূপে নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","কিন্তু হেবল উপহার রূপে তার মেষপালের প্রথমজাত কয়েকটি মেষের চর্বিদার অংশ আনল। সদাপ্রভু হেবল ও তার উপহারের প্রতি সন্তুষ্ট হলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","কিন্তু কয়িন ও তার উপহারের প্রতি তিনি সন্তুষ্ট হননি। তাই কয়িন খুব ক্রুদ্ধ হল এবং সে বিষণ্ণবদন হয়ে পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","তখন সদাপ্রভু কয়িনকে বললেন, “তুমি ক্রুদ্ধ হলে কেন? কেন তুমি বিষণ্ণবদন হয়ে পড়েছ? ");
INSERT INTO benobcv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","যদি তুমি ঠিক কাজ করতে, তবে কি গ্রাহ্য হতে না? কিন্তু যদি ঠিক কাজ না করে থাকো, তবে পাপ তোমার দরজায় গুটিসুটি মেরে আছে; পাপ তোমাকে গ্রাস করতে চাইছে, কিন্তু তোমাকেই পাপকে বশে রাখতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","এদিকে কয়িন তার ভাই হেবলকে বলল, “চলো, আমরা জমিতে যাই।” আর তারা যখন জমিতে ছিল, তখন কয়িন তার ভাই হেবলকে আক্রমণ করে তাকে হত্যা করল। ");
INSERT INTO benobcv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","তখন সদাপ্রভু কয়িনকে বললেন, “তোমার ভাই হেবল কোথায়?” “আমি জানি না,” সে উত্তর দিল, “আমি কি আমার ভাইয়ের তত্ত্বাবধায়ক?” ");
INSERT INTO benobcv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","সদাপ্রভু বললেন, “তুমি এ কী করলে? শোনো! জমি থেকে তোমার ভাইয়ের রক্তের কান্না আমার কানে ভেসে আসছে। ");
INSERT INTO benobcv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","এখন তুমি অভিশাপগ্রস্ত হলে এবং সেই জমি থেকে বিতাড়িতও হলে, যা তোমার হাত থেকে তোমার ভাইয়ের রক্ত গ্রহণ করার জন্য উন্মুক্ত হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","যখন তুমি এই জমিতে কাজ করবে, তখন আর তা তোমার জন্য ফসল উৎপন্ন করবে না। এ জগতে তুমি অশান্ত এক ভ্রমণকারী হয়েই থাকবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","কয়িন সদাপ্রভুকে বলল, “আমার শাস্তিটি, আমার শক্তির অতিরিক্ত হয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","আজ তুমি আমাকে কৃষিভূমি থেকে তাড়িয়ে দিলে, আর আমি তোমার উপস্থিতি থেকে লুকিয়ে পড়ব; পৃথিবীতে আমি অশান্ত এক ভ্রমণকারী হয়েই থাকব, এবং যে কেউ আমার দেখা পাবে সে আমাকে হত্যা করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","কিন্তু সদাপ্রভু তাকে বললেন, “তা নয়; কেউ যদি কয়িনকে হত্যা করে, তবে তার প্রতিশোধে তাকে সাতগুণ বেশি নির্যাতন সহ্য করতে হবে।” পরে সদাপ্রভু কয়িনের গায়ে একটি চিহ্ন লাগিয়ে দিলেন, যেন যে কেউ কয়িনের খোঁজ পেয়ে তাকে হত্যা করতে না পারে। ");
INSERT INTO benobcv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","অতএব কয়িন সদাপ্রভুর উপস্থিতি থেকে সরে গিয়ে এদনের পূর্বদিকে নোদ দেশে গিয়ে বসবাস করতে লাগল। ");
INSERT INTO benobcv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","কয়িন তার স্ত্রীর সঙ্গে সহবাস করল, ও তার স্ত্রী গর্ভবতী হয়ে হনোকের জন্ম দিল। পরে কয়িন একটি নগর গড়ে তার ছেলে হনোকের নামানুসারে সেটির নাম রাখল হনোক। ");
INSERT INTO benobcv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","হনোক ঈরদের জন্ম দিল, এবং ঈরদ মহূয়ায়েলের বাবা হল, এবং মহূয়ায়েল মথূশায়েলের বাবা হল, এবং মথূশায়েল লেমকের বাবা হল। ");
INSERT INTO benobcv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","লেমক দুজন মহিলাকে বিয়ে করল, একজনের নাম আদা ও অন্যজনের নাম সিল্লা। ");
INSERT INTO benobcv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","আদা যাবলের জন্ম দিল; যারা তাঁবুতে বসবাস করে ও গৃহপালিত পশুপাল পালন করে, সে তাদের পূর্বপুরুষ। ");
INSERT INTO benobcv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","তার ভাইয়ের নাম যুবল; যারা বীণা ও বাঁশি বাজায়, সে তাদের পূর্বপুরুষ। ");
INSERT INTO benobcv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","সিল্লারও এক ছেলে ছিল, যে তূবল-কয়িন, ব্রোঞ্জ ও লোহা দিয়ে সেসব ধরনের যন্ত্রপাতি গড়ে তুলত। তূবল-কয়িনের বোনের নাম নয়মা। ");
INSERT INTO benobcv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","লেমক তার স্ত্রীদের বলল, “আদা ও সিল্লা; আমার কথা শোনো; ওহে লেমকের স্ত্রীরা, আমার কথায় কান দাও। আমায় যন্ত্রণা দেওয়ার জন্য একটি লোককে আমি হত্যা করেছি, আমায় আহত করার জন্য একটি যুবককে আমি হত্যা করেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","কয়িনের হত্যার প্রতিশোধ যদি সাতগুণ হয়, তবে লেমকের হত্যার প্রতিশোধ হবে 77 গুণ।” ");
INSERT INTO benobcv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","আদম আবার তাঁর স্ত্রীর সঙ্গে সহবাস করলেন, এবং হবা এক ছেলের জন্ম দিয়ে এই বলে তার নাম দিলেন শেথ, যে “কয়িন হেবলকে হত্যা করেছে বলে ঈশ্বর তার স্থানে আমাকে আর এক ছেলে মঞ্জুর করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","শেথেরও একটি ছেলে হল, এবং তিনি তার নাম দিলেন ইনোশ। তখন থেকেই লোকেরা সদাপ্রভুর নামে ডাকতে শুরু করল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","এই হল আদমের বংশাবলির লিখিত নথি। ঈশ্বর যখন মানবজাতিকে সৃষ্টি করলেন, তখন তিনি তাদের ঈশ্বরের প্রতিমূর্তিতেই তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","তিনি তাদের পুরুষ ও স্ত্রী করে সৃষ্টি করলেন এবং তাদের আশীর্বাদও করলেন। আর তারা যখন সৃষ্ট হলেন তখন তিনি তাদের “মানবজাতি” নাম দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","130 বছর বয়সে আদম তাঁর নিজের সাদৃশ্যে, তাঁর নিজের প্রতিমূর্তিতে এক ছেলে লাভ করলেন; আর তিনি তাঁর নাম দিলেন শেথ। ");
INSERT INTO benobcv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","শেথের জন্ম হওয়ার পর, আদম 800 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","সব মিলিয়ে, আদম মোট 930 বছর বেঁচেছিলেন, আর পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","105 বছর বয়সে শেথ ইনোশের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ইনোশের বাবা হওয়ার পর শেথ 807 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","সব মিলিয়ে, শেথ মোট 912 বছর বেঁচেছিলেন, আর পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","90 বছর বয়সে ইনোশ কৈননের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","কৈননের বাবা হওয়ার পর ইনোশ 815 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","সব মিলিয়ে, ইনোশ মোট 905 বছর বেঁচেছিলেন, পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","70 বছর বয়সে, কৈনন মহললেলের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","মহললেলের বাবা হওয়ার পর কৈনন 840 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","সব মিলিয়ে, কৈনন মোট 910 বছর বেঁচেছিলেন, পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","65 বছর বয়সে, মহললেল যেরদের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","যেরদের বাবা হওয়ার পর মহললেল 830 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","সব মিলিয়ে, মহললেল মোট 895 বছর বেঁচেছিলেন, পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","162 বছর বয়সে, যেরদ হনোকের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","হনোকের বাবা হওয়ার পর যেরদ 800 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","সব মিলিয়ে, যেরদ মোট 962 বছর বেঁচেছিলেন, পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","65 বছর বয়সে হনোক, মথূশেলহের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","মথূশেলহের বাবা হওয়ার পর হনোক 300 বছর ধরে বিশ্বস্ততাপূর্বক ঈশ্বরের সাথে চলাফেরা করলেন, এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","সব মিলিয়ে, হনোক মোট 365 বছর বেঁচেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","হনোক বিশ্বস্ততাপূর্বক ঈশ্বরের সাথে চলাফেরা করলেন; পরে তিনি অদৃশ্য হয়ে গেলেন, কারণ ঈশ্বর তাঁকে তুলে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","187 বছর বয়সে মথূশেলহ, লেমকের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","লেমকের বাবা হওয়ার পর মথূশেলহ 782 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","সব মিলিয়ে, মথূশেলহ মোট 969 বছর বেঁচেছিলেন, পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","182 বছর বয়সে লেমকের এক ছেলে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","তিনি তার নাম দিলেন নোহ এবং বললেন, “সদাপ্রভুর দ্বারা জমি অভিশপ্ত হওয়ার কারণে হাতে কাজ করতে গিয়ে আমাদের যে ব্যথা ও কষ্টকর পরিশ্রম ভোগ করতে হচ্ছে, তা থেকে এই ছেলেটি আমাদের স্বস্তি দেবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","নোহের জন্ম হওয়ার পর, লেমক 595 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","সব মিলিয়ে, লেমক মোট 777 বছর বেঁচেছিলেন, পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","500 বছর বয়সে নোহ, শেম, হাম ও যেফতের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","পৃথিবীতে মানুষের সংখ্যা যখন বাড়তে শুরু করল ও তাদের ঔরসে কন্যাসন্তানেরা জন্মাল, ");
INSERT INTO benobcv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","তখন ঈশ্বরের ছেলেরা দেখল যে মানুষের মেয়েরা বেশ সুন্দরী, এবং তাদের মধ্যে থেকে তারা নিজেদের পছন্দমতো মেয়েকে বিয়ে করল। ");
INSERT INTO benobcv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","তখন সদাপ্রভু বললেন, “আমার আত্মা অনন্তকাল ধরে মানুষের সাথে বিবাদ করবেন না, কারণ তারা নশ্বর; তাদের আয়ু হবে 120 বছর।” ");
INSERT INTO benobcv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","সে যুগে পৃথিবীতে নেফিলীমরা বসবাস করত—এবং পরবর্তীকালেও করত—যখন ঈশ্বরের ছেলেরা মানুষের মেয়েদের সঙ্গে সহবাস করল এবং তাদের মাধ্যমে সন্তানসন্ততি লাভ করল। তারাই প্রাচীনকালের বীরপুরুষ, বিখ্যাত মানুষ হল। ");
INSERT INTO benobcv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","সদাপ্রভু দেখলেন পৃথিবীতে মানুষের দুষ্টতা কত বেড়ে গিয়েছে, এবং তাদের অন্তরের চিন্তাভাবনার প্রত্যেকটি প্রবণতা সবসময় শুধু মন্দই থেকে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","পৃথিবীতে মানবজাতিকে তৈরি করেছেন বলে সদাপ্রভু মর্মাহত হলেন, এবং তাঁর অন্তর গভীর মর্মবেদনায় ভরে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","তাই সদাপ্রভু বললেন, “যে মানবজাতিকে আমি সৃষ্টি করেছি, তাদের—এবং তাদের সাথে সাথে পশুদের, পাখিদের ও সরীসৃপ প্রাণীদেরও—আমি এই পৃথিবীর বুক থেকে নিশ্চিহ্ন করে ফেলব, কারণ তাদের তৈরি করেছি বলে আমার অনুতাপ হচ্ছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","কিন্তু নোহ সদাপ্রভুর দৃষ্টিতে অনুগ্রহ লাভ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","এই হল নোহ ও তাঁর পরিবারের বিবরণ। নোহ তাঁর সমকালীন লোকদের মধ্যে এক ধার্মিক, অনিন্দনীয় লোক ছিলেন, আর তিনি বিশ্বস্ততাপূর্বক ঈশ্বরের সাথে চলাফেরা করতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","নোহের তিন ছেলে ছিল: শেম, হাম ও যেফৎ। ");
INSERT INTO benobcv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","এমতাবস্থায় পৃথিবী ঈশ্বরের দৃষ্টিতে নীতিভ্রষ্ট ছিল এবং হিংস্রতাতেও পরিপূর্ণ হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ঈশ্বর দেখলেন পৃথিবী কত নীতিভ্রষ্ট হয়ে গিয়েছে, কারণ পৃথিবীর সব মানুষজন তাদের জীবনযাপন নীতিভ্রষ্ট করে তুলেছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","অতএব ঈশ্বর নোহকে বললেন, “আমি সব মানুষের জীবন শেষ করে দিতে চলেছি, কারণ এদের জন্যই পৃথিবী হিংস্রতায় পরিপূর্ণ হয়ে উঠেছে। আমি নির্ঘাৎ তাদের ও পৃথিবীকে একসাথে ধ্বংস করে দিতে চলেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","তাই তুমি নিজেই দেবদারু কাঠ দিয়ে একটি জাহাজ তৈরি করো; তার মধ্যে কয়েকটি ঘর তৈরি কোরো এবং তার ভিতরের ও বাইরের দিকে আলকাতরা মাখিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","এভাবেই তোমাকে এটি তৈরি করতে হবে: জাহাজটি 135 মিটার লম্বা, 23 মিটার চওড়া ও 14 মিটার উঁচু হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","এর একটি ছাদ তৈরি কোরো এবং ছাদের নিচে চারদিকে 45 সেন্টিমিটার উঁচু একটি জানালা তৈরি কোরো। জাহাজটির একদিকে একটি দরজা তৈরি কোরো এবং জাহাজে নিম্ন, মধ্যম ও উপর তলা তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","পৃথিবীতে বন্যার জল পাঠিয়ে আমি আকাশমণ্ডলের নিচে থাকা সব প্রাণকে, প্রাণবায়ুবিশিষ্ট প্রত্যেকটি প্রাণীকে ধ্বংস করে দিতে চলেছি। পৃথিবীর সবকিছু ধ্বংস হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","কিন্তু তোমার সাথে আমি আমার নিয়ম প্রতিষ্ঠিত করব, এবং তুমি সেই জাহাজে প্রবেশ করবে—তুমি ও তোমার সাথে তোমার ছেলেরা, ও তোমার স্ত্রী এবং তোমার পুত্রবধূরাও। ");
INSERT INTO benobcv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","সব জীবিত প্রাণীর মধ্যে থেকে এক এক জোড়া করে মদ্দা ও মাদি প্রাণীকে তোমার সাথে বাঁচিয়ে রাখার জন্য তোমাকে জাহাজে এনে রাখতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","জীবিত থাকার জন্য সব ধরনের পাখি, সব ধরনের পশু এবং সব ধরনের সরীসৃপ প্রাণী দুটি দুটি করে তোমার কাছে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","তোমাদের ও তাদের সকলের খাদ্যরূপে তোমাকে সব ধরনের খাদ্যদ্রব্য মজুত করতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ঈশ্বর যেমন আদেশ দিয়েছিলেন, নোহ সবকিছু ঠিক সেভাবেই করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","সদাপ্রভু পরে নোহকে বললেন, “তুমি ও তোমার সম্পূর্ণ পরিবার জাহাজে প্রবেশ করো, কারণ এই প্রজন্মে আমি তোমাকেই ধার্মিকরূপে খুঁজে পেয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","তুমি সব ধরনের শুচিশুদ্ধ পশুর মধ্যে সাত জোড়া করে, একটি মদ্দা ও তার সহচরীকে, সব ধরনের অশুচি পশুর মধ্যে এক জোড়া করে, একটি মদ্দা ও তার সহচরীকে, ");
INSERT INTO benobcv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","আর সব ধরনের পাখির মধ্যে সাত জোড়া করে, মদ্দা ও মাদিকেও সাথে নিয়ো, যেন পৃথিবীর সর্বত্র তাদের বিভিন্ন প্রজাতি রক্ষা পায়। ");
INSERT INTO benobcv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","আর সাত দিন পর আমি পৃথিবীতে চল্লিশ দিন ও চল্লিশ রাত পর্যন্ত চলতে থাকা বৃষ্টি পাঠাব, এবং আমার তৈরি করা প্রত্যেকটি জীবিত প্রাণীকে আমি পৃথিবীর বুক থেকে নিশ্চিহ্ন করে ফেলব।” ");
INSERT INTO benobcv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","আর সদাপ্রভু নোহকে যা যা আদেশ দিয়েছিলেন, তিনি সেসবকিছু করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","নোহের 600 বছর বয়সকালে বন্যার জল পৃথিবীতে ধেয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","আর বন্যার জলের হাত থেকে রক্ষা পাওয়ার জন্য নোহ এবং তাঁর ছেলেরা ও তাঁর স্ত্রী ও পুত্রবধূরা সবাই সেই জাহাজে প্রবেশ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","শুচিশুদ্ধ ও অশুচি পশুদের, পাখিদের ও সরীসৃপ সব প্রাণীর মদ্দা ও মাদিরা জোড়ায় জোড়ায়, ");
INSERT INTO benobcv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","নোহকে দেওয়া ঈশ্বরের আদেশানুসারে নোহের কাছে এল এবং জাহাজে প্রবেশ করল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","আর সেই সাত দিন পর পৃথিবীতে বন্যার জল ধেয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","নোহের জীবনকালের 600 তম বছরের, দ্বিতীয় মাসের সপ্তদশতম দিনে—সেদিন ভূগর্ভস্থ জলের সব উৎস বিস্ফোরিত হল, এবং আকাশের জলনিকাশের সব পথ খুলে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","আর চল্লিশ দিন ও চল্লিশ রাত পৃথিবীতে বৃষ্টি পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","সেদিনই নোহ ও তাঁর স্ত্রী এবং তাঁর ছেলেরা—শেম, হাম ও যেফৎ, ও তিন পুত্রবধূ সেই জাহাজে প্রবেশ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","তাদের সাথে তারা নিজ নিজ প্রজাতি অনুসারে সব ধরনের বন্যপশু, সব ধরনের গৃহপালিত পশু, সব ধরনের সরীসৃপ প্রাণী এবং ডানাওয়ালা সব ধরনের পাখি রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","প্রাণবায়ুবিশিষ্ট সব প্রাণী জোড়ায় জোড়ায় নোহের কাছে এল এবং জাহাজে প্রবেশ করল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","যেসব পশু ভিতরে ঢুকল, তারা ছিল প্রত্যেকটি জীবিত প্রাণীর মদ্দা ও মাদি পশু, ঠিক যেভাবে ঈশ্বর নোহকে আদেশ দিয়েছিলেন। পরে সদাপ্রভু তাঁকে ভিতর থেকে বন্ধ করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","চল্লিশ দিন ধরে পৃথিবীতে বন্যা হল, আর যেমন যেমন জল বেড়েছিল, তেমন তেমন জাহাজটিকে সেই জল ভূতল থেকে উঁচুতে তুলে ধরেছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","জল উপরে উঠে পৃথিবীর উপর অত্যন্ত বেড়ে গেল, এবং সেই জাহাজটি জলের উপর ভেসে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","জল পৃথিবীর উপর খুব বেড়ে গেল, ও সমগ্র আকাশমণ্ডলের নিচে অবস্থিত সব উঁচু উঁচু পাহাড়-পর্বত ঢাকা পড়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","জলস্তর 6.8 মিটারেরও বেশি উচ্চতায় উঠে গেল ও পাহাড়-পর্বতগুলি ঢাকা পড়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","পাখি, গৃহপালিত ও বন্যপশু, পৃথিবীতে উড়ে বেড়ানো সব কীটপতঙ্গ, ও সমগ্র মানবজাতি—পৃথিবীতে বিচরণকারী প্রত্যেকটি জীবিত প্রাণী ধ্বংস হল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","শুকনো জমির উপরে থাকা প্রত্যেকটি শ্বাসবিশিষ্ট প্রাণী মারা গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","পৃথিবীর বুকে যত জীবিত প্রাণী ছিল, সবাই নিশ্চিহ্ন হয়ে গেল; মানুষজন ও পশু এবং সরীসৃপ জীব ও আকাশের পাখি, সবাই পৃথিবী থেকে নিশ্চিহ্ন হয়ে গেল। শুধুমাত্র নোহ এবং জাহাজে যারা তাঁর সাথে ছিল, তারাই বাদ পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","150 দিন ধরে জল পৃথিবীকে প্লাবিত করে রাখল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","কিন্তু ঈশ্বর নোহকে এবং জাহাজে তাঁর সাথে থাকা সব বন্য ও গৃহপালিত পশুকে স্মরণ করলেন, এবং পৃথিবীতে তিনি বাতাস পাঠালেন, ও জল সরে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","এদিকে মাটির নিচে থাকা জলের উৎসগুলি, ও আকাশমণ্ডলের জানালাগুলি বন্ধ হয়ে গেল, এবং আকাশ থেকে বৃষ্টি পড়াও বন্ধ হল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","পৃথিবী থেকে জল সরার প্রক্রিয়া অব্যাহত রইল। 150 দিন পর জল নিচে নামল, ");
INSERT INTO benobcv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","এবং সপ্তম মাসের সপ্তদশতম দিনে জাহাজটি আরারট পর্বতের চূড়ায় এসে স্থির হল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","দশম মাস পর্যন্ত জল অনবরত সরে এল, এবং দশম মাসের প্রথম দিনে পাহাড়-পর্বতের চূড়াগুলি দৃষ্টিগোচর হল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","চল্লিশ দিন পর নোহ সেই জানালাটি খুলে দিলেন, যেটি তিনি সেই জাহাজে তৈরি করেছিলেন ");
INSERT INTO benobcv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","এবং একটি দাঁড়কাক বাইরে পাঠালেন, আর পৃথিবীতে জল না শুকানো পর্যন্ত সেটি ইতস্তত বাইরে যাচ্ছিল ও ফিরে আসছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","পরে স্থলভূমির উপরে জল শুকিয়েছে কি না, তা দেখার জন্য তিনি একটি পায়রা বাইরে পাঠালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","কিন্তু পায়রাটি তার পা রাখার জায়গা পায়নি, কারণ পৃথিবীর উপরে সর্বত্র তখনও জল জমে ছিল; তাই সেটি জাহাজে নোহের কাছে ফিরে এল। তখন তিনি তাঁর হাত বাড়িয়ে পায়রাটিকে ধরে জাহাজে তাঁর নিজের কাছে ফিরিয়ে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","তিনি আরও সাত দিন অপেক্ষা করলেন এবং আবার জাহাজ থেকে সেই পায়রাটিকে বাইরে পাঠালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","সন্ধ্যাবেলায় যখন সেই পায়রাটি তাঁর কাছে ফিরে এল, তখন সেটির চঞ্চুতে ছিল জলপাই গাছের একটি টাটকা পাতা! তখন নোহ জানতে পারলেন যে পৃথিবী থেকে জল সরে গিয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","তিনি আরও সাত দিন অপেক্ষা করলেন এবং আবার সেই পায়রাটিকে বাইরে পাঠালেন, এবার কিন্তু সেটি আর তাঁর কাছে ফিরে এল না। ");
INSERT INTO benobcv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","নোহের জীবনকালের 601 তম বছরের প্রথম মাসের প্রথম দিনে, পৃথিবীর উপরে জল শুকিয়ে গেল। নোহ তখন জাহাজ থেকে আচ্ছাদনটি সরিয়ে দিলেন এবং দেখতে পেলেন যে স্থলভূমির উপরদিকটি শুকিয়ে গিয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","দ্বিতীয় মাসের সাতাশতম দিনে পৃথিবী পুরোপুরি শুকিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ঈশ্বর তখন নোহকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“তুমি ও তোমার স্ত্রী ও তোমার ছেলেরা ও তাদের স্ত্রীরা—তোমরা জাহাজ থেকে বাইরে বেরিয়ে এসো। ");
INSERT INTO benobcv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","যেসব জীবিত প্রাণী তোমার সাথে আছে—পাখিরা, পশুরা, ও সব সরীসৃপ প্রাণী—সবাইকে বাইরে বের করে আনো, যেন সেগুলি পৃথিবীতে বংশবৃদ্ধি করে এখানে ফলবান হয় ও সংখ্যায় বৃদ্ধি পায়।” ");
INSERT INTO benobcv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","অতএব নোহ তাঁর স্ত্রীকে, ছেলেদের, এবং তাঁর পুত্রবধূদের সাথে নিয়ে বাইরে বের হয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","সব পশু এবং সরীসৃপ প্রাণী ও পাখি—পৃথিবীতে বিচরণকারী সবকিছু, তাদের প্রজাতি অনুসারে এক এক করে জাহাজ থেকে বাইরে বের হয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","পরে নোহ সদাপ্রভুর উদ্দেশে একটি যজ্ঞবেদি তৈরি করলেন এবং, সব শুচিশুদ্ধ পশু ও শুচিশুদ্ধ পাখির মধ্যে থেকে কয়েকটি নিলেন, ও সেই বেদিতে হোমবলি উৎসর্গ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","সদাপ্রভু সেই প্রীতিকর সৌরভের ঘ্রাণ নিয়ে মনে মনে বললেন: “মানুষের জন্য আমি আর কখনোই ভূমিকে অভিশাপ দেব না, যদিও শিশুকাল থেকেই মানুষের অন্তরের সব প্রবণতা মন্দ। যেভাবে আমি সব জীবিত প্রাণীকে ধ্বংস করেছি, আমি আর তা করব না। ");
INSERT INTO benobcv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“যতদিন এই পৃথিবী টিকে থাকবে, বীজবপনকাল ও ফসল গোলাজাত করার সময়, শৈত্য ও উত্তাপ, গ্রীষ্মকাল ও শীতকাল, দিন ও রাত কখনোই শেষ হবে না।” ");
INSERT INTO benobcv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","পরে ঈশ্বর নোহ ও তাঁর ছেলেদের আশীর্বাদ করে বললেন, “ফলবান হও ও সংখ্যায় বৃদ্ধি পেয়ে পৃথিবী ভরিয়ে তোলো। ");
INSERT INTO benobcv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","পৃথিবীর সব জন্তু ও আকাশের সব পাখি, সব সরীসৃপ প্রাণী, ও সমুদ্রের সব মাছ তোমাদের দেখে ভীত ও আতঙ্কিত হবে; তোমাদের হাতে এদের তুলে দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","যা যা জীবন্ত ও চলেফিরে বেড়ায়, সেসব তোমাদের খাদ্য হবে। ঠিক যেভাবে আমি তোমাদের সবুজ গাছপালা দিয়েছি, সেভাবে এখন সবকিছু আমি তোমাদের দিচ্ছি। ");
INSERT INTO benobcv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“কিন্তু যে মাংসে প্রাণ-রক্ত অবশিষ্ট আছে, তোমরা সেই মাংস কখনোই খেয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","আর তোমাদের প্রাণ-রক্তের হিসেবও আমি নিশ্চিতভাবেই চাইব। প্রত্যেকটি পশুর কাছে আমি হিসেব চাইব। আর প্রত্যেকটি মানুষের কাছেও, আমি অন্যান্য মানুষের প্রাণের হিসেব চাইব। ");
INSERT INTO benobcv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“যে কেউ মানুষের রক্ত ঝরাবে, মানুষের দ্বারাই তার রক্ত ঝরবে; কারণ ঈশ্বরের প্রতিমূর্তিতে ঈশ্বর মানুষকে তৈরি করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","আর তোমরা ফলবান হয়ে সংখ্যায় বৃদ্ধিলাভ করো; পৃথিবীতে বংশবৃদ্ধি করো ও এখানে বর্ধিষ্ণু হও।” ");
INSERT INTO benobcv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","পরে ঈশ্বর নোহকে ও তাঁর সাথে থাকা তাঁর ছেলেদের বললেন, ");
INSERT INTO benobcv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“আমার নিয়মটি আমি এখন তোমাদের সঙ্গে ও তোমাদের ভাবী বংশধরদের সঙ্গে ");
INSERT INTO benobcv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","এবং তোমাদের সাথে থাকা সব জীবিত প্রাণীর—পাখিদের, গৃহপালিত পশুদের ও সব বন্যপশুর, যারা তোমাদের সাথে জাহাজের বাইরে বের হয়ে এসেছিল—পৃথিবীর সব জীবিত প্রাণীর সঙ্গে স্থাপন করছি। ");
INSERT INTO benobcv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","আমি তোমাদের সঙ্গে আমার নিয়ম স্থাপন করছি: আর কখনও সব প্রাণী বন্যার জলে উচ্ছিন্ন হবে না; আর কখনও এই পৃথিবী ধ্বংস করার জন্য কোনও বন্যা হবে না।” ");
INSERT INTO benobcv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","আর ঈশ্বর বললেন, “এই হল সেই নিয়মের চিহ্ন, যা আমি আমার ও তোমাদের মধ্যে তথা তোমাদের সঙ্গে থাকা প্রত্যেকটি জীবিত প্রাণীর সঙ্গে স্থাপন করেছি, পরবর্তী সব প্রজন্মের জন্যও এ এক নিয়ম হবে: ");
INSERT INTO benobcv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","মেঘের মধ্যে আমি আমার মেঘধনু বসিয়ে দিয়েছি, আর এটিই হবে আমার ও পৃথিবীর মধ্যে স্থাপিত সেই চিহ্ন। ");
INSERT INTO benobcv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","পৃথিবীর উপর যখনই আমি মেঘ বিস্তার করব ও সেই মেঘে মেঘধনু আবির্ভূত হবে, ");
INSERT INTO benobcv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","তখনই আমি তোমাদের এবং তোমাদের সঙ্গে থাকা সব জীবিত প্রাণীর সঙ্গে স্থাপিত আমার সেই নিয়মটি স্মরণ করব। আর কখনও জল বন্যায় পরিণত হয়ে সব প্রাণীকে ধ্বংস করবে না। ");
INSERT INTO benobcv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","যখনই মেঘে মেঘধনু আবির্ভূত হবে, আমি তা দেখব ও অনন্তকালস্থায়ী সেই নিয়মটি স্মরণ করব, যা ঈশ্বর ও পৃথিবীর সব ধরনের জীবিত প্রাণীর মধ্যে স্থাপিত হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","অতএব ঈশ্বর নোহকে বললেন, “এই সেই নিয়মের চিহ্ন, যা আমি আমার ও পৃথিবীর সব প্রাণীর মধ্যে স্থাপন করেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","নোহের যে ছেলেরা জাহাজ থেকে বেরিয়ে এলেন, তারা হলেন শেম, হাম ও যেফৎ। (হাম কনানের বাবা) ");
INSERT INTO benobcv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","এরাই হলেন নোহের সেই তিন ছেলে, এবং তাঁদের থেকে যেসব লোকজন উৎপন্ন হল, তারা সমগ্র জগতে ছড়িয়ে পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","চাষিগৃহস্থ মানুষ নোহ, একটি দ্রাক্ষাক্ষেত তৈরি করার জন্য এগিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","যখন তিনি সেখানকার খানিকটা দ্রাক্ষারস পান করলেন, তখন তিনি নেশাগ্রস্ত হয়ে পড়লেন এবং তাঁর তাঁবুর ভিতরে তিনি বিবস্ত্র হয়ে শুয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","কনানের বাবা হাম তাঁর বাবাকে উলঙ্গ অবস্থায় দেখে বাইরে বেরিয়ে গিয়ে তাঁর দুই দাদাকে তা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","কিন্তু শেম ও যেফৎ একটি কাপড় নিয়ে সেটি তাঁদের কাঁধের উপর ফেলে রাখলেন; পরে তাঁরা পিছনের দিকে পিছিয়ে গিয়ে তাঁদের বাবার উলঙ্গতা ঢেকে দিলেন। তাঁদের মুখমণ্ডল অন্যদিকে ঘোরানো ছিল, যেন তাঁরা তাঁদের বাবার উলঙ্গতা দেখতে না পান। ");
INSERT INTO benobcv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","নোহ যখন তাঁর নেশার ঘোর কাটিয়ে উঠলেন ও জানতে পারলেন তাঁর ছোটো ছেলে তাঁর প্রতি ঠিক কী আচরণ করেছেন, ");
INSERT INTO benobcv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","তখন তিনি বললেন, “কনান অভিশপ্ত হোক! তার দাদা-ভাইদের মধ্যে সে অত্যন্ত নীচ দাস হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","তিনি আরও বললেন, “শেমের ঈশ্বর সদাপ্রভু ধন্য হোন! কনান শেমের দাস হোক। ");
INSERT INTO benobcv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ঈশ্বর যেফতের এলাকা প্রসারিত করুন; যেফৎ শেমের তাঁবুতে বসবাস করুক, আর কনান তার ক্রীতদাস হোক।” ");
INSERT INTO benobcv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","বন্যার পর নোহ 350 বছর বেঁচেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","নোহ মোট 950 বছর বেঁচেছিলেন, ও পরে তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","এই হল নোহের ছেলে শেম, হাম ও যেফতের বিবরণ, যারা স্বয়ং বন্যার পর সন্তান লাভ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","যেফতের ছেলেরা: গোমর, মাগোগ, মাদয়, যবন, তূবল, মেশক ও তীরস। ");
INSERT INTO benobcv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","গোমরের ছেলেরা: অস্কিনস, রীফৎ, এবং তোগর্ম। ");
INSERT INTO benobcv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","যবনের ছেলেরা: ইলীশা, তর্শীশ, কিত্তীম এবং রোদানীম। ");
INSERT INTO benobcv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(এদের থেকেই সমুদ্র-উপকূল নিবাসী লোকেরা, প্রত্যেকে তাদের নিজস্ব ভাষা সমেত নিজেদের বংশানুসারে, তাদের এলাকায় ছড়িয়ে পড়েছিল।) ");
INSERT INTO benobcv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","হামের ছেলেরা: কূশ, মিশর, পূট ও কনান। ");
INSERT INTO benobcv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","কূশের ছেলেরা: সবা, হবীলা, সব্‌তা, রয়মা ও সব্‌তেকা। রয়মার ছেলেরা: শিবা ও দদান। ");
INSERT INTO benobcv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","কূশ সেই নিম্রোদের বাবা, যিনি পৃথিবীতে এক বলশালী যোদ্ধা হয়ে উঠলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","সদাপ্রভুর সামনে তিনি বলশালী এক শিকারি হলেন; তাই বলা হয়ে থাকে, “সদাপ্রভুর সামনে নিম্রোদের মতো বলশালী এক শিকারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","শিনারে অবস্থিত ব্যাবিলন, এরক, অক্কদ, ও কল্‌নী তাঁর রাজ্যের মূলকেন্দ্র হল। ");
INSERT INTO benobcv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","সেই দেশ থেকে তিনি সেই আসিরিয়া দেশে গেলেন, যেখানে তিনি নীনবী, রহোবোৎ ঈর, কেলহ ");
INSERT INTO benobcv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ও সেই রেষণ নগরটি গড়ে তুললেন যা নীনবী ও কেলহের মাঝখানে অবস্থিত; সেটিই সেই মহানগর। ");
INSERT INTO benobcv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","মিশর ছিলেন সেই লূদীয়, অনামীয়, লহাবীয়, নপ্তুহীয়, ");
INSERT INTO benobcv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","পথ্রোষীয়, কস্‌লূহীয় (যাদের থেকে ফিলিস্তিনীরা উৎপন্ন হয়েছে) ও কপ্তোরীয়দের বাবা। ");
INSERT INTO benobcv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","কনান ছিলেন তাঁর বড়ো ছেলে সীদোনের, ও হিত্তীয়, ");
INSERT INTO benobcv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","যিবূষীয়, ইমোরীয়, গির্গাশীয়, ");
INSERT INTO benobcv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","হিব্বীয়, অর্কীয়, সীনীয়, ");
INSERT INTO benobcv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","অর্বদীয়, সমারীয় ও হমাতীয়দের বাবা। (পরবর্তীকালে কনানীয় বংশ ইতস্তত ছড়িয়ে পড়ল ");
INSERT INTO benobcv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","এবং কনানের সীমানা সীদোন থেকে গরারের দিকে গাজা পর্যন্ত, ও পরে লাশার দিকে সদোম, ঘমোরা, অদ্‌মা, ও সবোয়ীম পর্যন্ত বিস্তৃত হল) ");
INSERT INTO benobcv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","তাদের এলাকা ও জাতি ধরে এরাই হল বংশ ও ভাষা অনুসারে হামের সন্তান। ");
INSERT INTO benobcv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","সেই শেমেরও কয়েকটি ছেলে জন্মাল, যাঁর দাদা ছিলেন যেফৎ; শেম হলেন এবরের সব সন্তানের পূর্বপুরুষ। ");
INSERT INTO benobcv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","শেমের ছেলেরা: এলম, অশূর, অর্ফক্‌ষদ, লূদ ও অরাম। ");
INSERT INTO benobcv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","অরামের ছেলেরা: ঊষ, হূল, গেথর, ও মেশক। ");
INSERT INTO benobcv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","অর্ফক্‌ষদ হলেন শেলহের বাবা, এবং শেলহ এবরের বাবা। ");
INSERT INTO benobcv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","এবরের দুটি ছেলের জন্ম হল: একজনের নাম দেওয়া হল পেলগ, কারণ তাঁর সময়কালেই পৃথিবী বিভিন্ন ভাষাবাদী জাতির আধারে বিভক্ত হল; তাঁর ভাইয়ের নাম দেওয়া হল যক্তন। ");
INSERT INTO benobcv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","যক্তন হলেন অলমোদদ, শেলফ, হৎসর্মাবৎ, যেরহ, ");
INSERT INTO benobcv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","হদোরাম, ঊষল, দিক্ল, ");
INSERT INTO benobcv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ওবল, অবীমায়েল, শিবা, ");
INSERT INTO benobcv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ওফীর, হবীলা ও যোববের বাবা। তারা সবাই যক্তনের বংশধর ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(পূর্বদিকের পার্বত্য দেশের যে এলাকায় তারা বসবাস করতেন, সেটি মেষা থেকে সফার পর্যন্ত বিস্তৃত ছিল) ");
INSERT INTO benobcv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","তাদের এলাকা ও জাতি ধরে বংশ ও ভাষা অনুসারে এরাই শেমের সন্তান। ");
INSERT INTO benobcv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","তাদের জাতিগুলির মধ্যে, বংশানুক্রমিকভাবে এরাই নোহের ছেলেদের বংশধর। বন্যার পর এদের থেকেই বিভিন্ন জাতি সমগ্র পৃথিবীতে ছড়িয়ে পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","এমতাবস্থায় সমগ্র জগতে এক ভাষা ও এক সাধারণ বাচনভঙ্গি ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","মানুষজন যেমন যেমন পূর্বদিকে সরে গেল, তারা শিনারে এক সমভূমি খুঁজে পেল এবং সেখানেই বসতি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","তারা পরস্পরকে বলল, “এসো, আমরা ইট তৈরি করি ও সেগুলি পুরোদস্তুর আগুনে পুড়িয়ে শক্ত করে নিই।” তারা পাথরের পরিবর্তে ইট, ও চুনসুরকির পরিবর্তে আলকাতরা ব্যবহার করল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","পরে তারা বলল, “এসো, আমরা নিজেদের জন্য গগনস্পর্শী এক মিনার সমেত এক নগর নির্মাণ করি, যেন আমাদের নামডাক হয় ও সমগ্র পৃথিবীতে আমাদের ছড়িয়ে পড়তে না হয়।” ");
INSERT INTO benobcv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","কিন্তু সদাপ্রভু সেই নগর ও মিনারটি দেখার জন্য নেমে এলেন, যেগুলি সেই মানুষেরা তখন নির্মাণ করছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","সদাপ্রভু বললেন, “এক ভাষাবাদী মানুষ হয়ে যদি তারা এরকম করতে শুরু করে দিয়েছে, তবে তারা যাই করার পরিকল্পনা করুক না কেন, তা তাদের অসাধ্য হবে না। ");
INSERT INTO benobcv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","এসো, আমরা নিচে নেমে যাই ও তাদের ভাষা গুলিয়ে দিই, যেন তারা পরস্পরের কথা বুঝতে না পারে।” ");
INSERT INTO benobcv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","অতএব সদাপ্রভু সেখান থেকে তাদের পৃথিবীর সর্বত্র ইতস্তত ছড়িয়ে দিলেন, আর তারা নগর নির্মাণের কাজ বন্ধ করে দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","সেজন্যই সেই স্থানটির নাম দেওয়া হল ব্যাবিলন—যেহেতু সেখানেই সদাপ্রভু সমগ্র জগতের ভাষা গুলিয়ে দিলেন। সেখান থেকে সদাপ্রভু তাদের পৃথিবীর সর্বত্র ইতস্তত ছড়িয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","এই হল শেমের বংশবৃত্তান্ত। বন্যার দুই বছর পর, শেমের বয়স যখন একশো বছর, তখন তিনি অর্ফক্‌ষদের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","আর অর্ফক্‌ষদের বাবা হওয়ার পর শেম 500 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","অর্ফক্‌ষদ পঁয়ত্রিশ বছর বয়সে শেলহের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","আর শেলহের বাবা হওয়ার পর অর্ফক্‌ষদ 403 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","শেলহ ত্রিশ বছর বয়সে এবরের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","আর এবরের বাবা হওয়ার পর শেলহ 403 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","এবর চৌত্রিশ বছর বয়সে পেলগের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","আর পেলগের বাবা হওয়ার পর এবর 430 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","পেলগ ত্রিশ বছর বয়সে রিয়ূর বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","আর রিয়ূর বাবা হওয়ার পর পেলগ 209 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","রিয়ূ বত্রিশ বছর বয়সে সরূগের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","আর সরূগের বাবা হওয়ার পর রিয়ূ 207 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","সরূগ ত্রিশ বছর বয়সে নাহোরের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","আর নাহোরের বাবা হওয়ার পর সরূগ 200 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","নাহোর উনত্রিশ বছর বয়সে তেরহের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","আর তেরহের বাবা হওয়ার পর নাহোর 119 বছর বেঁচেছিলেন এবং তাঁর আরও ছেলেমেয়ে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","তেরহ সত্তর বছর বয়সে অব্রাম, নাহোর, ও হারণের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","এই হল তেরহের বংশবৃত্তান্ত। তেরহ অব্রাম, নাহোর, ও হারণের বাবা হলেন। আর হারণ লোটের বাবা হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","হারণ তাঁর জন্মস্থান, কলদীয় দেশের ঊরেই তাঁর বাবা তেরহের জীবদ্দশায় মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","অব্রাম ও নাহোর, দুজনেই বিয়ে করলেন। অব্রামের স্ত্রীর নাম সারী, এবং নাহোরের স্ত্রীর নাম মিল্কা; মিল্কা সেই হারণের মেয়ে, যিনি মিল্কা ও যিষ্কা, দুজনেরই বাবা। ");
INSERT INTO benobcv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","সারী নিঃসন্তান ছিলেন যেহেতু তাঁর গর্ভধারণের ক্ষমতা ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","তেরহ তাঁর ছেলে অব্রাম, তাঁর নাতি তথা হারণের ছেলে লোট এবং তাঁর পুত্রবধূ তথা তাঁর ছেলে অব্রামের স্ত্রী সারীকে সঙ্গে নিয়ে একসাথে কলদীয় দেশের ঊর ত্যাগ করে কনানে যাওয়ার জন্য যাত্রা শুরু করলেন। কিন্তু হারণ নামাঙ্কিত স্থানে পৌঁছে তারা সেখানে বসতি স্থাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","তেরহ 205 বছর বেঁচেছিলেন, এবং হারণেই তিনি মারা যান। ");
INSERT INTO benobcv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","সদাপ্রভু অব্রামকে বললেন, “তোমার দেশ, তোমার আত্মীয়স্বজন ও তোমার পৈত্রিক পরিবার ছেড়ে সেই দেশে চলে যাও, যা আমি তোমাকে দেখাতে চলেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“আমি তোমাকে এক মহাজাতিতে পরিণত করব, আর আমি তোমাকে আশীর্বাদ করব; আমি তোমার নাম মহান করে তুলব, আর তুমি এক আশীর্বাদ হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","যারা তোমাকে আশীর্বাদ করবে, আমি তাদের আশীর্বাদ করব, আর যারা তোমাকে অভিশাপ দেবে, আমি তাদের অভিশাপ দেব; আর পৃথিবীর সব লোকজন তোমার মাধ্যমে আশীর্বাদ লাভ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","অতএব সদাপ্রভুর কথামতো অব্রাম চলে গেলেন; এবং লোট তাঁর সাথে গেলেন। 75 বছর বয়সে অব্রাম হারণ ছেড়ে বেরিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","তিনি তাঁর স্ত্রী সারী, ভাইপো লোট, ও হারণে উপার্জিত সব বিষয়সম্পত্তি ও অর্জিত লোকজন সাথে নিয়ে কনান দেশের উদ্দেশে যাত্রা শুরু করে সেখানে পৌঁছে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","অব্রাম সেই দেশের মধ্য দিয়ে ভ্রমণ করে শিখিমে মোরির সেই বিশাল গাছটির কাছে পৌঁছে গেলেন। সেই সময় কনানীয়েরা সেই দেশে বসবাস করত। ");
INSERT INTO benobcv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","সদাপ্রভু অব্রামকে দর্শন দিয়ে বললেন, “তোমার সন্তানসন্ততিকে আমি এই দেশ দেব।” তাই তিনি সেখানে সেই সদাপ্রভুর উদ্দেশে এক যজ্ঞবেদি নির্মাণ করলেন, যিনি তাঁকে দর্শন দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","সেখান থেকে তিনি বেথেলের পূর্বদিকে অবস্থিত পাহাড়ের দিকে চলে গেলেন এবং বেথেলকে পশ্চিমদিকে ও অয়কে পূর্বদিকে রেখে তিনি তাঁর তাঁবু খাটালেন। সেখানে তিনি সদাপ্রভুর উদ্দেশে একটি যজ্ঞবেদি নির্মাণ করলেন এবং সদাপ্রভুর আরাধনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","পরে অব্রাম যাত্রা শুরু করে নেগেভের দিকে এগিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","এদিকে সেই দেশে এক দুর্ভিক্ষ হল, এবং অব্রাম মিশরে কিছুদিন বসবাস করার জন্য সেখানে নেমে গেলেন, কারণ দুর্ভিক্ষটি বেশ দুঃসহ হল। ");
INSERT INTO benobcv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","মিশরে প্রবেশ করার ঠিক আগে তিনি তাঁর স্ত্রী সারীকে বললেন, “আমি জানি তুমি খুব সুন্দরী। ");
INSERT INTO benobcv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","মিশরীয়রা যখন তোমায় দেখে বলবে, ‘এ তো এই লোকটির স্ত্রী।’ তখন তারা আমায় হত্যা করবে কিন্তু তোমাকে বাঁচিয়ে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","তুমি বোলো, তুমি আমার বোন, যেন তোমার খাতিরে আমি ভালো ব্যবহার পাই ও তোমার জন্য আমার প্রাণরক্ষা হয়।” ");
INSERT INTO benobcv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","অব্রাম যখন মিশরে এলেন, তখন মিশরীয়রা দেখল যে সারী পরম সুন্দরী। ");
INSERT INTO benobcv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","আর ফরৌণের কর্মকর্তারা সারীকে দেখে ফরৌণের কাছে তাঁর প্রশংসা করলেন, এবং সারীকে ফরৌণের রাজপ্রাসাদে নিয়ে যাওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","সারীর খাতিরে তিনি অব্রামের সঙ্গে খুব ভালো ব্যবহার করলেন, এবং অব্রাম প্রচুর মেষ ও গবাদি পশু, গাধা ও গাধি, দাস-দাসী ও উট অর্জন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","কিন্তু অব্রামের স্ত্রী সারীর কারণে সদাপ্রভু ফরৌণ ও তাঁর পরিবারের উপর সংকটজনক রোগব্যাধি চাপিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","তাই ফরৌণ অব্রামকে ডেকে পাঠালেন, “আপনি আমার প্রতি এ কী করলেন?” তিনি বললেন, “আপনি কেন আমায় বলেননি যে ইনি আপনার স্ত্রী? ");
INSERT INTO benobcv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","আপনি কেন বললেন, ‘এ আমার বোন,’ তাইতো আমি তাঁকে আমার স্ত্রীরূপে গ্রহণ করেছি? তবে এখন, এই রইল আপনার স্ত্রী। তাঁকে নিন আর চলে যান!” ");
INSERT INTO benobcv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","পরে ফরৌণ তাঁর লোকজনকে অব্রামের বিষয়ে আদেশ দিলেন, এবং তারা তাঁর স্ত্রী ও তাঁর অধিকারে থাকা সবকিছু সমেত তাঁকে বিদায় করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","অতএব অব্রাম তাঁর স্ত্রী ও নিজের সবকিছু নিয়ে মিশর থেকে নেগেভের দিকে চলে গেলেন, এবং লোটও তাঁর সাথে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","অব্রাম তাঁর গৃহপালিত পশুপাল এবং রুপো ও সোনার নিরিখে খুবই ধনী হয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","নেগেভ থেকে এদিক-ওদিক ঘোরাফেরা করে তিনি সেই বেথেলে পৌঁছালেন, যা বেথেল ও অয়ের মাঝখানে অবস্থিত এমন এক স্থান, যেখানে এর আগেও তাঁর তাঁবু খাটানো ছিল ");
INSERT INTO benobcv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","এবং যেখানে তিনি প্রথমবার এক যজ্ঞবেদি নির্মাণ করেছিলেন। সেখানেই অব্রাম সদাপ্রভুর আরাধনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","এদিকে, যিনি অব্রামের সঙ্গে ঘুরে বেড়াচ্ছিলেন, সেই লোটেরও প্রচুর মেষপাল ও পশুপাল ও তাঁবু ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","কিন্তু একসাথে থাকার সময় সেখানে তাঁদের জায়গার অকুলান হচ্ছিল, কারণ তাঁদের বিষয়সম্পত্তি এত বেশি ছিল যে তাঁরা একসাথে থাকতে পারছিলেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","আর অব্রামের ও লোটের রাখালদের মধ্যে ঝগড়া বেধে গেল। সেই সময় কনানীয় এবং পরিষীয়রাও সেদেশে বসবাস করছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","তাই অব্রাম লোটকে বললেন, “তোমার ও আমার মধ্যে অথবা তোমার ও আমার রাখালদের মধ্যে যেন ঝগড়া না হয়, কারণ আমরা পরস্পরের খুব ঘনিষ্ঠ আত্মীয়। ");
INSERT INTO benobcv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","তোমার সামনে কি গোটা দেশ পড়ে নেই? এসো, আমরা পৃথক হয়ে যাই। তুমি যদি বাঁদিকে যাও, আমি তবে ডানদিকে যাব; তুমি যদি ডানদিকে যাও, আমি তবে বাঁদিকে যাব।” ");
INSERT INTO benobcv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","লোট চারিদিকে তাকালেন এবং দেখলেন যে সোয়রের দিকে জর্ডনের সমগ্র সমভূমি বেশ জলসিক্ত, ঠিক যেন সদাপ্রভুর বাগানের মতো, মিশর দেশের মতো। (সদাপ্রভু সদোম ও ঘমোরা ধ্বংস করার আগে সেখানকার দশা এরকমই ছিল) ");
INSERT INTO benobcv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","অতএব লোট তাঁর নিজের জন্য জর্ডনের সমগ্র সমভূমিটি মনোনীত করলেন এবং পূর্বদিকে এগিয়ে গেলেন। দুজন পরস্পরের সঙ্গ ত্যাগ করলেন: ");
INSERT INTO benobcv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","অব্রাম কনান দেশে থেকে গেলেন, অন্যদিকে লোট সেই সমভূমির নগরগুলিতে থেকে গিয়ে সদোমের কাছে তাঁর তাঁবু খাটালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","সদোমের মানুষজন খুব দুষ্ট ছিল ও সদাপ্রভুর বিরুদ্ধে তারা মহাপাপ করে যাচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","লোট অব্রামের সঙ্গ ত্যাগ করে যাওয়ার পর সদাপ্রভু অব্রামকে বললেন, “তুমি যেখানে আছ, সেখানে থেকেই তোমার চারপাশে—উত্তর, দক্ষিণ, পূর্ব ও পশ্চিমদিকে তাকিয়ে দেখো। ");
INSERT INTO benobcv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","তুমি যে দেশটি দেখতে পাচ্ছ, সম্পূর্ণ সেই দেশটিই আমি চিরতরে তোমাকে ও তোমার বংশধরদের দেব। ");
INSERT INTO benobcv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","তোমার বংশধরদের আমি পৃথিবীর ধূলিকণার মতো করে তুলব, যেন কেউ যদি ধূলিকণার সংখ্যা গুনতে পারে, তবে তোমার বংশধরদেরও গোনা যাবে। ");
INSERT INTO benobcv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","যাও, দেশটির দৈর্ঘ্য ও প্রস্থ ধরে ঘুরে এসো, কারণ আমি এটি তোমাকেই দিচ্ছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","অতএব অব্রাম হিব্রোণে মম্রির সেই বিশাল গাছগুলির কাছে থাকতে চলে গেলেন, যেখানে তিনি তাঁর তাঁবুগুলি খাটিয়েছিলেন। সেখানে তিনি সদাপ্রভুর উদ্দেশে এক যজ্ঞবেদি নির্মাণ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","সেই সময় যখন অম্রাফল শিনারের রাজা, অরিয়োক ইল্লাসরের রাজা, কদর্লায়োমর এলমের রাজা এবং তিদিয়ল গোয়ীমের রাজা, ");
INSERT INTO benobcv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","তখন এই রাজারা সদোমের রাজা বিরা, ঘমোরার রাজা বির্শা, অদ্‌মার রাজা শিনাব, সবোয়িমের রাজা শিমেবর ও বিলার (অর্থাৎ, সোয়রের) রাজার বিরুদ্ধে যুদ্ধ করতে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","শেষোক্ত এসব রাজা সিদ্দীম উপত্যকায় (অর্থাৎ, মরুসাগরের উপত্যকায়) একজোট হয়ে সেনাবাহিনী মোতায়েন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","বারো বছর তাঁরা কদর্লায়োমরের শাসনাধীন হয়ে ছিলেন, কিন্তু ত্রয়োদশতম বছরে তাঁরা বিদ্রোহ ঘোষণা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","চতুর্দশতম বছরে, এমীয়দের রাজা কদর্লায়োমর এবং তাঁর সঙ্গী রাজারা মরুভূমির কাছাকাছি অবস্থিত এল-পারণ পর্যন্ত এগিয়ে গিয়ে অস্তরোৎ-কর্ণয়িমে রফায়ীয়দের, হমে সুষীয়দের, শাবি-কিরিয়াথয়িমে এমীয়দের ");
INSERT INTO benobcv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","এবং সেয়ীরের পার্বত্য এলাকায় হোরীয়দের পরাজিত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","পরে সেখান থেকে ফিরে এসে তারা ঐনমিস্পটে (অর্থাৎ, কাদেশে) গেলেন, এবং সেই অমালেকীয়দের ও ইমোরীয়দেরও সমগ্র এলাকা তারা জোর করে দখল করে নিলেন, যারা হৎসসোন-তামরে বসবাস করছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","পরে সদোমের রাজা, ঘমোরার রাজা, অদ্‌মার রাজা, সবোয়িমের রাজা এবং বিলার (অর্থাৎ সোয়রের) রাজা কুচকাওয়াজ করে এগিয়ে গিয়ে সিদ্দীম উপত্যকায় ");
INSERT INTO benobcv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","সেই এলমের রাজা কদর্লায়োমর, গোয়ীমের রাজা তিদিয়ল, শিনারের রাজা অম্রাফল ও ইল্লাসরের রাজা অরিয়োকের বিরুদ্ধে সৈন্যশিবির স্থাপন করলেন—যে চারজন রাজা পাঁচজনের বিরুদ্ধে যুদ্ধ করছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ওই সিদ্দীম উপত্যকায় প্রচুর আলকাতরার খনি ছিল, এবং সদোম ও ঘমোরার রাজারা যখন পালিয়ে যাচ্ছিলেন, তখন কয়েকটি লোক সেইসব খনিতে গিয়ে পড়ল ও বাকিরা পাহাড়ে পালিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","সেই চারজন রাজা সদোম ও ঘমোরার সব জিনিসপত্র ও তাদের সব খাবারদাবার বাজেয়াপ্ত করলেন এবং তাঁরা চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","তাঁরা অব্রামের ভাইপো লোটকে ও তাঁর বিষয়সম্পত্তিও তুলে নিয়ে গেলেন, যেহেতু লোট সদোমেই বসবাস করছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","একজন লোক পালিয়ে গিয়ে হিব্রু অব্রামের কাছে এসে খবর দিল। অব্রাম তখন সেই ইষ্কোলের ও আনেরের এক ভাই ইমোরীয় মম্রির বিশাল গাছগুলির কাছে বসবাস করছিলেন, যারা সবাই অব্রামের বন্ধু ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","অব্রাম যখন শুনলেন যে তাঁর আত্মীয়কে বন্দি করা হয়েছে, তখন তিনি তাঁর ঘরে জন্মানো 318 জন প্রশিক্ষণপ্রাপ্ত লোককে ডাক দিলেন ও দান পর্যন্ত তাঁদের পশ্চাদ্ধাবন করে গেলেন, যাঁরা লোটকে বন্দি করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","রাতের বেলায় তাঁদের আক্রমণ করে ছত্রভঙ্গ করে দেওয়ার জন্য অব্রাম তাঁর লোকজনকে কয়েকটি ভাগে বিভক্ত করে দিলেন, ও দামাস্কাসের উত্তরে অবস্থিত হোবা পর্যন্ত তাদের পশ্চাদ্ধাবন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","তিনি সব জিনিসপত্র পুনরুদ্ধার করলেন এবং তাঁর আত্মীয় লোটকে ও তাঁর বিষয়সম্পত্তি, তথা মহিলাদের ও অন্যান্য লোকজনকেও ফিরিয়ে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","অব্রাম কদর্লায়োমর ও তাঁর সঙ্গে জোট বাঁধা রাজাদের পরাজিত করে ফিরে আসার পর শাবী উপত্যকায় (অর্থাৎ, রাজার উপত্যকায়) সদোমের রাজা তাঁর সাথে দেখা করার জন্য বেরিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","তখন শালেমের রাজা মল্কীষেদক রুটি ও দ্রাক্ষারস বের করে নিয়ে এলেন। তিনি পরাৎপর ঈশ্বরের যাজক ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","তিনি অব্রামকে আশীর্বাদ করে বললেন, “অব্রাম, স্বর্গ-মর্ত্যের সৃষ্টিকর্তা পরাৎপর ঈশ্বরের আশীর্বাদধন্য হোন, ");
INSERT INTO benobcv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","আর সেই পরাৎপর ঈশ্বরের প্রশংসা হোক, যিনি আপনার শত্রুদের আপনার হাতে সঁপে দিয়েছেন।” পরে অব্রাম তাঁকে নিজের সবকিছুর দশমাংশ দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","সদোমের রাজা অব্রামকে বললেন, “লোকজন আমাকে দিন ও সব জিনিসপত্র আপনি নিজের কাছে রেখে দিন।” ");
INSERT INTO benobcv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","কিন্তু অব্রাম সদোমের রাজাকে বললেন, “স্বর্গ-মর্ত্যের সৃষ্টিকর্তা পরাৎপর ঈশ্বর সেই সদাপ্রভুর উদ্দেশে হাত তুলে আমি শপথ করছি ");
INSERT INTO benobcv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","যে আপনার অধিকারে থাকা কোনো কিছুই আমি গ্রহণ করব না, এমনকি একটি সুতো বা চটিজুতোর একটি ফিতেও নয়, যেন আপনি কখনও বলতে না পারেন, ‘আমি অব্রামকে ধনবান করে তুলেছি।’ ");
INSERT INTO benobcv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","আমার লোকজন যা খেয়েছে ও যারা আমার সাথে গিয়েছিল—সেই আনের, ইষ্কোল ও মম্রির ভাগে যা পড়ে, সেটুকু ছাড়া আমি আর কিছুই গ্রহণ করব না। তারা তাদের ভাগ বুঝে নিক।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","পরে, এক দর্শনের মাধ্যমে সদাপ্রভুর বাক্য অব্রামের কাছে এল: “অব্রাম, ভয় কোরো না। আমি তোমার ঢাল, তোমার মহা পুরস্কার।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","কিন্তু অব্রাম বললেন, “হে সার্বভৌম সদাপ্রভু, তুমি আর আমাকে কী দেবে? আমি যে নিঃসন্তান ও দামাস্কাসের ইলীয়েষরই যে আমার ভূসম্পত্তির উত্তরাধিকারী হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","আর অব্রাম বললেন, “তুমি তো আমাকে কোনও সন্তান দাওনি; তাই আমার ঘরের এক দাসই আমার উত্তরাধিকারী হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","তখন তাঁর কাছে সদাপ্রভুর এই বাক্য এল: “এই লোকটি তোমার উত্তরাধিকারী হবে না, কিন্তু যে ছেলে তোমার নিজের রক্তমাংস, সেই হবে তোমার উত্তরাধিকারী।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","তিনি অব্রামকে বাইরে নিয়ে গিয়ে বললেন, “আকাশের দিকে তাকিয়ে দেখো ও যদি সম্ভব হয় তবে তারাগুলি গোনো।” পরে তিনি তাঁকে বললেন, “তোমার সন্তানসন্ততিরা এরকমই হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","অব্রাম সদাপ্রভুকে বিশ্বাস করলেন, এবং তিনি তা অব্রামের পক্ষে ধার্মিকতা বলে গণ্য করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","এছাড়াও তিনি অব্রামকে বললেন, “আমি সেই সদাপ্রভু, যিনি তোমাকে এই দেশের অধিকার দেওয়ার জন্য কলদীয় দেশের ঊর থেকে এদেশে বের করে এনেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","কিন্তু অব্রাম বললেন, “হে সার্বভৌম সদাপ্রভু, আমি কীভাবে জানব যে আমি এদেশের অধিকার লাভ করব?” ");
INSERT INTO benobcv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","তাই সদাপ্রভু তাঁকে বললেন, “তুমি আমার কাছে তিন বছর বয়স্ক এক-একটি বকনা-বাছুর, ছাগল, ও মেষ, ও একইসাথে একটি ঘুঘু, ও একটি কপোতশাবক নিয়ে এসো।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","অব্রাম এসব কিছু তাঁর কাছে আনলেন, সেগুলি দু-টুকরো করে কেটে অর্ধেক অর্ধেক অংশ পরস্পরের উল্টোদিকে সাজিয়ে রাখলেন; পাখিটিকে, অবশ্য তিনি দু-টুকরো করেননি। ");
INSERT INTO benobcv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","পরে পশুপাখির শবগুলির উপর শিকারি পাখিরা নেমে এল, কিন্তু অব্রাম তাদের তাড়িয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","সূর্য যখন অস্ত যাচ্ছিল, অব্রাম তখন গভীর ঘুমে আচ্ছন্ন হয়ে পড়লেন, এবং ত্রাসজনক অন্ধকার তাঁর উপর নেমে এল। ");
INSERT INTO benobcv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","সদাপ্রভু তখন তাঁকে বললেন, “নিশ্চিত জেনে রাখো যে তোমার বংশধরেরা 400 বছর এমন একটি দেশে অপরিচিত মানুষ হয়ে বসবাস করবে, যা তাদের নিজস্ব নয়, এবং তারা সেখানে ক্রীতদাসে পরিণত হবে এবং তাদের সাথে দুর্ব্যবহার করা হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","কিন্তু যে দেশে তারা ক্রীতদাস হয়ে থাকবে, সেই দেশটিকে আমি শাস্তি দেব, এবং শেষ পর্যন্ত তারা প্রচুর বিষয়সম্পত্তি নিয়ে বেরিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","তুমি অবশ্য, শান্তিতে মারা গিয়ে তোমার পূর্বপুরুষদের কাছে চলে যাবে, এবং বেশ বৃদ্ধ অবস্থায় কবরস্থ হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","চতুর্থ প্রজন্মে তোমার বংশধরেরা এখানে ফিরে আসবে, কারণ ইমোরীয়দের পাপ এখনও পর্যন্ত চূড়ান্ত সীমায় পৌঁছায়নি।” ");
INSERT INTO benobcv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","সূর্য অস্ত যাওয়ার ও অন্ধকার নেমে আসার পর, জ্বলন্ত এক মশাল সমেত ধোঁয়ায় ভরা একটি উনুন আবির্ভূত হল এবং সেই টুকরোগুলির মাঝখান দিয়ে চলে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","সেদিন সদাপ্রভু অব্রামের সঙ্গে একটি নিয়ম স্থাপন করে বললেন, “আমি মিশরের ওয়াদি থেকে সেই মহানদী ইউফ্রেটিস পর্যন্ত এই দেশটি— ");
INSERT INTO benobcv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","কেনীয়, কনিষীয়, কদমোনীয়, ");
INSERT INTO benobcv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","হিত্তীয়, পরিষীয়, রফায়ীয়, ");
INSERT INTO benobcv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ইমোরীয়, কনানীয়, গির্গাশীয় ও যিবূষীয়দের দেশটি তোমার বংশধরদের দিয়েছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","অব্রামের স্ত্রী সারী, তাঁর জন্য কোনও সন্তানের জন্ম দেননি। কিন্তু সারীর এক মিশরীয় ক্রীতদাসী ছিল, যার নাম হাগার; ");
INSERT INTO benobcv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","তাই সারী অব্রামকে বললেন, “সদাপ্রভু আমাকে নিঃসন্তান করে রেখেছেন। যাও, আমার ক্রীতদাসীর সঙ্গে গিয়ে শোও; হয়তো তার মাধ্যমে আমি এক পরিবার গড়ে তুলতে পারব।” সারীর কথায় অব্রাম সম্মত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","অতএব অব্রাম কনানে দশ বছর বসবাস করার পর, তাঁর স্ত্রী সারী মিশরীয় ক্রীতদাসী হাগারকে নিয়ে তাকে নিজের স্বামীর স্ত্রী হওয়ার জন্য তাঁর হাতে তুলে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","অব্রাম হাগারের সঙ্গে সহবাস করলেন, এবং সে গর্ভবতী হল। হাগার যখন জানতে পারল যে সে গর্ভবতী হয়েছে, তখন সে তার মালকিনকে অবজ্ঞা করতে লাগল। ");
INSERT INTO benobcv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","তখন সারী অব্রামকে বললেন, “আমি যে অন্যায় ভোগ করছি, তার জন্য তুমিই দায়ী। আমি আমার ক্রীতদাসীকে তোমার হাতে তুলে দিয়েছি, আর এখন সে যখন জানতে পেরেছে যে সে গর্ভবতী হয়েছে, সে আমাকেই অবজ্ঞা করছে। সদাপ্রভুই তোমার ও আমার মধ্যে বিচারক হোন।” ");
INSERT INTO benobcv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","“তোমার ক্রীতদাসী তোমারই হাতে আছে,” অব্রাম বললেন, “তোমার যা ভালো মনে হয়, তুমি তার সাথে তাই করো।” তখন সারী হাগারের সঙ্গে দুর্ব্যবহার করলেন; তাই সে তাঁর কাছ থেকে পালিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","মরুভূমিতে একটি জলের উৎসের কাছে সদাপ্রভুর দূত হাগারকে খুঁজে পেলেন; এটি সেই জলের উৎস, যা শূরের দিকে যাওয়ার পথের ধারে অবস্থিত। ");
INSERT INTO benobcv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","আর দূত হাগারকে বললেন, “হে সারীর ক্রীতদাসী হাগার, তুমি কোথা থেকে এসেছ, ও কোথায় যাচ্ছ?” “আমি আমার মালকিন সারীর কাছ থেকে পালিয়ে যাচ্ছি,” সে উত্তর দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","তখন সদাপ্রভুর দূত তাকে বললেন, “তোমার মালকিনের কাছে ফিরে যাও ও তার বশ্যতাস্বীকার করো।” ");
INSERT INTO benobcv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","সদাপ্রভুর দূত আরও বললেন, “আমি তোমার বংশধরদের সংখ্যা এত বৃদ্ধি করব যে গোনার পক্ষে তারা বহুসংখ্যক হয়ে উঠবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","সদাপ্রভুর দূত তাকে আরও বললেন: “এখন তুমি গর্ভবতী হয়েছ আর তুমি এক ছেলের জন্ম দেবে। তুমি তার নাম দেবে ইশ্মায়েল, কারণ সদাপ্রভু তোমার দুর্দশার কথা শুনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","সে বন্য গাধার মতো এক মানুষ হবে; প্রত্যেকের বিরুদ্ধে তার হাত উঠবে আর প্রত্যেকের হাত তার বিরুদ্ধে উঠবে, আর তার সব ভাইয়ের প্রতি শত্রুতা বজায় রেখে সে বসবাস করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","যে সদাপ্রভু হাগারের সঙ্গে কথা বলেছিলেন, সে তাঁর এই নাম দিল: “তুমি দর্শনকারী ঈশ্বর,” কারণ সে বলল, “আমি এখন এমন একজনকে দেখেছি, যিনি আমাকে দেখেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","সেইজন্য সেই কুয়োর নাম হল বের-লহয়-রোয়ী; কাদেশ ও বেরদের মাঝখানে এটি এখনও আছে। ");
INSERT INTO benobcv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","অতএব হাগার অব্রামের জন্য এক ছেলের জন্ম দিল, এবং সে যে ছেলের জন্ম দিল, অব্রাম তার নাম দিলেন ইশ্মায়েল। ");
INSERT INTO benobcv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","হাগার যখন অব্রামের জন্য ইশ্মায়েলের জন্ম দিল, তখন অব্রামের বয়স ছিয়াশি বছর। ");
INSERT INTO benobcv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","অব্রামের বয়স যখন 99 বছর, তখন সদাপ্রভু তাঁর কাছে আবির্ভূত হয়ে বললেন, “আমি সর্বশক্তিমান ঈশ্বর; বিশ্বস্ত ও অনিন্দনীয় হয়ে আমার সামনে চলাফেরা করো। ");
INSERT INTO benobcv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","তবেই আমি আমার ও তোমার মধ্যে আমার নিয়ম স্থাপন করব এবং প্রচুর পরিমাণে তোমার বংশবৃদ্ধি করব।” ");
INSERT INTO benobcv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","অব্রাম মাটিতে উবুড় হয়ে পড়ে গেলেন, এবং ঈশ্বর তাঁকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“দেখো, তোমার সঙ্গে এই হল আমার নিয়ম: তুমি বহু জাতির পিতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","তোমাকে আর অব্রাম বলে ডাকা হবে না; তোমার নাম হবে অব্রাহাম, কারণ আমি তোমাকে বহু জাতির পিতা করেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","আমি তোমাকে অত্যন্ত ফলবান করব; আমি তোমার মধ্যে থেকে বহু জাতি উৎপন্ন করব, এবং রাজারা তোমার মধ্যে থেকেই উৎপন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","তোমার ঈশ্বর ও তোমার আগামী বংশধরদের ঈশ্বর হওয়ার জন্য আমার এবং তোমার মধ্যে ও তোমার আগামী বংশধরদের মধ্যে কয়েক প্রজন্ম পর্যন্ত স্থায়ী এক চিরস্থায়ী নিয়মরূপে আমি আমার নিয়মটি স্থাপন করব। ");
INSERT INTO benobcv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","এখন যেখানে তুমি এক বিদেশিরূপে বসবাস করছ, সমগ্র সেই কনান দেশটি আমি তোমাকে ও তোমার বংশধরদের এক চিরস্থায়ী অধিকাররূপে দেব; আর আমি তাদের ঈশ্বর হব।” ");
INSERT INTO benobcv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","পরে ঈশ্বর অব্রাহামকে বললেন, “দেখো, তোমাকে অবশ্যই আমার নিয়মটি পালন করতে হবে, তোমাকে ও তোমার বংশধরদের আগামী বংশপরম্পরায় তা পালন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","এই হল তোমার ও তোমার পরবর্তী বংশধরদের জন্য আমার সেই নিয়ম, যা তোমাদের পালন করতে হবে: তোমাদের মধ্যে প্রত্যেক পুরুষকে সুন্নত করা হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","তোমাকে সুন্নত করাতে হবে, আর এটিই হবে আমার ও তোমার মধ্যে স্থাপিত নিয়মের চিহ্ন। ");
INSERT INTO benobcv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","পুরুষানুক্রমে তোমাদের মধ্যে আট দিন বয়স্ক প্রত্যেকটি পুরুষকে সুন্নত করাতে হবে, যারা তোমার পরিবারে জন্মেছে, তাদের বা কোনও বিদেশির কাছ থেকে যাদের অর্থ দিয়ে কেনা হয়েছে—যারা তোমার নিজের সন্তান নয়, তাদেরও করাতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","যারা তোমার পরিবারে জন্মেছে বা তোমার অর্থ দিয়ে যাদের কেনা হয়েছে, তাদের সবাইকে সুন্নত করাতেই হবে। তোমার শরীরে স্থাপিত আমার এই নিয়মই চিরস্থায়ী এক নিয়ম হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","সুন্নত না হওয়া যে কোনো পুরুষ, যার শরীরে সুন্নত করা হয়নি, সে তার লোকজনের মধ্যে থেকে উৎখাত হবে; সে আমার নিয়ম ভঙ্গ করেছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ঈশ্বর অব্রাহামকে আরও বললেন, “তোমার স্ত্রী সারীকে, তুমি আর সারী বলে ডাকবে না; তার নাম হবে সারা। ");
INSERT INTO benobcv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","আমি তাকে আশীর্বাদ করব, আর অবশ্যই তাকে তার নিজের এক পুত্রসন্তান দেব। আমি তাকে আশীর্বাদ করব, যেন সে বহু জাতির মা হয়; তার মধ্যে থেকে লোকসমূহের রাজারা উৎপন্ন হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","অব্রাহাম মাটিতে উবুড় হয়ে পড়ে গেলেন; তিনি হেসে আপনমনে বললেন, “একশো বছর বয়স্ক লোকের কি পুত্রসন্তান হবে? সারা কি নব্বই বছর বয়সে সন্তানের জন্ম দেবে?” ");
INSERT INTO benobcv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","আর অব্রাহাম ঈশ্বরকে বললেন, “ইশ্মায়েলই শুধু তোমার আশীর্বাদের অধীনে বেঁচে থাকুক!” ");
INSERT INTO benobcv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","তখন ঈশ্বর বললেন, “হ্যাঁ, কিন্তু তোমার স্ত্রী সারা তোমার জন্য এক ছেলের জন্ম দেবে, এবং তুমি তার নাম দেবে ইস্‌হাক। তার আগামী বংশধরদের জন্য এক চিরস্থায়ী নিয়মরূপে আমি তার সঙ্গে আমার নিয়ম স্থাপন করব। ");
INSERT INTO benobcv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","আর ইশ্মায়েলের সম্বন্ধেও তোমার করা প্রার্থনাটি আমি শুনেছি: আমি তাকে অবশ্যই আশীর্বাদ করব; আমি তাকে ফলবান করব ও তার প্রচুর বংশবৃদ্ধি করব। সে বারোজন শাসনকর্তার বাবা হবে এবং আমি তাকে এক বড়ো জাতিতে পরিণত করব। ");
INSERT INTO benobcv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","কিন্তু আমার নিয়ম আমি সেই ইস্‌হাকের সঙ্গেই স্থাপন করব, যাকে আগামী বছর এইসময় সারা তোমার জন্য জন্ম দেবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","অব্রাহামের সঙ্গে কথা বলা শেষ করে ঈশ্বর তাঁর কাছ থেকে উঠে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","সেদিনই অব্রাহাম তাঁর ছেলে ইশ্মায়েলকে ও তাঁর পরিবারে জন্মানো বা তাঁর অর্থ দিয়ে কেনা সবাইকে, তাঁর পরিবারের প্রত্যেকটি পুরুষ সদস্যকে নিয়ে ঈশ্বরের কথানুসারে সুন্নত করালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","অব্রাহাম যখন সুন্নত করালেন তখন তাঁর বয়স 99 বছর, ");
INSERT INTO benobcv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","এবং তাঁর ছেলে ইশ্মায়েলের বয়স তেরো বছর; ");
INSERT INTO benobcv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","অব্রাহাম এবং তাঁর ছেলে ইশ্মায়েল দুজনে একই দিনে সুন্নত করালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","আর অব্রাহামের পরিবারের প্রত্যেকটি পুরুষ সদস্যকে তথা তাঁর পরিবারে জন্মানো বা কোনও বিদেশির কাছ থেকে অর্থ দিয়ে কেনা প্রত্যেককে তাঁর সাথে সুন্নত করানো হল। ");
INSERT INTO benobcv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","অব্রাহাম যখন একদিন ভর-দুপুরে মম্রির বিশাল গাছগুলির কাছে তাঁর তাঁবুর প্রবেশদ্বারে বসেছিলেন, তখন সদাপ্রভু তাঁর কাছে আবির্ভূত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","অব্রাহাম চোখ তুলে চেয়ে দেখলেন তিনজন লোক তাঁর কাছাকাছি দাঁড়িয়ে আছেন। তাঁদের দেখতে পেয়ে তিনি তাঁদের সাথে দেখা করার জন্য তাড়াতাড়ি তাঁবুর প্রবেশদ্বার ছেড়ে এগিয়ে গেলেন ও মাটিতে উবুড় হয়ে প্রণাম করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","তিনি বললেন, “হে আমার প্রভু, আপনার দৃষ্টিতে আমি যদি অনুগ্রহ পেয়ে থাকি, তবে আপনার এই দাসকে পার করে যাবেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","একটু জল এনে দিই, যেন আপনারা পা-টা ধুয়ে নিয়ে এই গাছের তলায় বিশ্রাম করে নিতে পারেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","আপনারা যখন আপনাদের এই দাসের কাছে এসেই পড়েছেন—আপনাদের জন্য আমি কিছু খাবার এনে দিই, যেন আপনারা তরতাজা হয়ে আপনাদের যাত্রাপথে এগিয়ে যেতে পারেন।” “তা বেশ,” তাঁরা উত্তর দিলেন, “যা বললে তাই করো।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","অতএব অব্রাহাম চট্ করে তাঁবুতে সারার কাছে চলে গেলেন। তিনি বললেন, “তাড়াতাড়ি করো, তিন মান মিহি আটা নাও ও তা মেখে কয়েকটি রুটি সেঁকে দাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","পরে তিনি দৌড়ে গোয়ালঘরে গেলেন এবং বাছাই করা একটি কচি বাছুর নিয়ে সেটি তাঁর এক দাসকে দিলেন, যে চট্ করে সেটি রান্না করতে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","পরে অব্রাহাম খানিকটা দই ও দুধ এবং রান্না করা বাছুরের মাংস এনে তাঁদের সামনে পরিবেশন করলেন। তাঁরা যখন ভোজনপান করছিলেন, তিনি তখন তাঁদের কাছে, একটি গাছের তলায় দাঁড়িয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“তোমার স্ত্রী সারা কোথায়?” তাঁরা তাঁকে জিজ্ঞাসা করলেন। “ওখানে, তাঁবুর মধ্যে আছে,” তিনি বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","তখন তাঁদের মধ্যে একজন বললেন, “আগামী বছর মোটামুটি এইসময় আমি অবশ্যই তোমাদের কাছে ফিরে আসব, এবং তোমার স্ত্রী সারা এক পুত্রসন্তান লাভ করবে।” ইত্যবসরে সারা তাঁবুর প্রবেশদ্বারে সেই অতিথির পিছন দিকে দাঁড়িয়ে সেকথা শুনছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","অব্রাহাম ও সারা দুজনেরই খুব বয়স হয়েছিল এবং সারার সন্তান প্রসবের বয়স পেরিয়ে গিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","তাই একথা ভেবে সারা মনে মনে হেসেছিলেন, “আমি জরাগ্রস্ত ও আমার স্বামী বৃদ্ধ হয়ে যাওয়ার পরেও কি এখন আমি এই সুখ পাব?” ");
INSERT INTO benobcv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","তখন সদাপ্রভু অব্রাহামকে বললেন, “সারা কেন হেসে বলল, ‘সত্যিই কি আমি এক সন্তান লাভ করব, আমি যে এখন বৃদ্ধা হয়ে গিয়েছি?’ ");
INSERT INTO benobcv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","সদাপ্রভুর কাছে কোনো কিছু কি খুব কঠিন? আগামী বছর নিরূপিত সময়ে আমি তোমার কাছে ফিরে আসব, এবং সারার কাছে তখন এক পুত্রসন্তান থাকবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","সারা ভয় পেয়েছিলেন, তাই তিনি মিথ্যামিথ্যি বললেন, “আমি হাসিনি।” কিন্তু তিনি বললেন, “হ্যাঁ, তুমি অবশ্যই হেসেছিলে।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","সেই লোকেরা চলে যাওয়ার জন্য উঠে দাঁড়িয়ে নিচে সদোমের দিকে তাকালেন, এবং অব্রাহাম তাঁদের বিদায় জানানোর জন্য তাঁদের সঙ্গে কিছুটা পথ হাঁটলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","তখন সদাপ্রভু বললেন, “আমি যা করতে যাচ্ছি তা কি আমি অব্রাহামের কাছে লুকাব?” ");
INSERT INTO benobcv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","অব্রাহাম নিঃসন্দেহে মহান ও শক্তিশালী এক জাতিতে পরিণত হবে, এবং পৃথিবীর সব জাতি তার মাধ্যমে আশীর্বাদ লাভ করবে। ");
INSERT INTO benobcv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","কারণ আমি তাকে মনোনীত করেছি, যেন যা উপযুক্ত ও ন্যায্য, তা করার মাধ্যমে সদাপ্রভুর পথে চলার ক্ষেত্রে সে তারপরে তার সন্তানদের ও তার পরিবারকে পথ দেখায়, ও যেন সদাপ্রভু অব্রাহামের কাছে যে প্রতিজ্ঞা করেছেন তা তিনি সফল করেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","পরে সদাপ্রভু বললেন, “সদোম ও ঘমোরার বিরুদ্ধে ওঠা কোলাহল এত তীব্র ও তাদের পাপ এত অসহ্য ");
INSERT INTO benobcv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","যে আমি নিচে নেমে যাব এবং দেখব তারা যা করেছে, তা সত্যিই আমার কানে পৌঁছানো কোলাহলের মতো মন্দ কি না। যদি তা না হয়, আমি তা জানতে পারব।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","সেই লোকেরা পিছনে ফিরে সদোমের দিকে চলে গেলেন, কিন্তু অব্রাহাম সদাপ্রভুর সামনে দাঁড়িয়ে থাকলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","পরে অব্রাহাম তাঁর দিকে এগিয়ে গিয়ে বললেন: “তুমি কি দুষ্টদের সাথে ধার্মিকদেরও দ্রুত নিশ্চিহ্ন করে ফেলবে? ");
INSERT INTO benobcv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","নগরে যদি পঞ্চাশ জন ধার্মিক লোক থাকে তবে কী হবে? তুমি কি সত্যিই নগরটি নিশ্চিহ্ন করে ফেলবে এবং সেখানকার পঞ্চাশ জন ধার্মিক লোকের খাতিরে সেই স্থানটিকে অব্যাহতি দেবে না? ");
INSERT INTO benobcv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","এমন কাজ করা থেকে তুমি বিরত থাকো—দুষ্টদের সাথে ধার্মিকদের হত্যা করা, ধার্মিকদের ও দুষ্টদের প্রতি একইরকম আচরণ করা—এমন কাজ করা থেকে তুমি বিরত থাকো! সমগ্র পৃথিবীর বিচারক কি ন্যায়বিচার করবেন না?” ");
INSERT INTO benobcv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","সদাপ্রভু বললেন, “সদোম নগরে আমি যদি পঞ্চাশ জন ধার্মিক লোক পাই, তবে তাদের খাতিরে সমগ্র স্থানটিকে আমি অব্যাহতি দেব।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","তখন অব্রাহাম আরেকবার বলে উঠলেন: “যদিও আমি ধুলো ও ভস্ম ছাড়া আর কিছুই নই, তাও যখন আমি প্রভুর সাথে কথা বলার সাহস পেয়েই গিয়েছি, ");
INSERT INTO benobcv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","তখন বলি কি, ধার্মিকদের সংখ্যা যদি পঞ্চাশ জনের থেকে পাঁচজন কম হয়, তাতে কী? পাঁচজন লোক কম থাকার জন্য কি তুমি সমগ্র নগরটিকে ধ্বংস করে দেবে?” “আমি যদি সেখানে পঁয়তাল্লিশ জন পাই,” তিনি বললেন, “আমি তা ধ্বংস করব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","আরেকবার অব্রাহাম তাঁকে বললেন, “সেখানে যদি শুধু চল্লিশ জন পাওয়া যায়, তবে কী হবে?” তিনি বললেন, “চল্লিশ জনের খাতিরে, আমি এরকম করব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","তখন অব্রাহাম বললেন, “প্রভু, রাগ করবেন না, কিন্তু আমায় বলতে দিন। সেখানে যদি শুধু ত্রিশজন পাওয়া যায়, তবে কী হবে?” তিনি উত্তর দিলেন, “সেখানে আমি যদি ত্রিশজন পাই, তাও আমি এরকম করব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","অব্রাহাম বললেন, “প্রভুর সাথে কথা বলার জন্য আমি যখন এতটাই সাহসী হয়েছি, তখন বলি কি, সেখানে যদি শুধু কুড়ি জন পাওয়া যায় তবে কী হবে?” তিনি বললেন, “কুড়ি জনের খাতিরে, আমি তা ধ্বংস করব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","তখন অব্রাহাম বললেন, “প্রভু রাগ করবেন না, আমাকে শুধু আর একটিবার বলতে দিন। সেখানে যদি শুধু দশজন পাওয়া যায়, তবে কী হবে?” তিনি উত্তর দিলেন, “দশজনের খাতিরে, আমি তা ধ্বংস করব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","অব্রাহামের সাথে কথোপকথন শেষ করে সদাপ্রভু চলে গেলেন, এবং অব্রাহাম ঘরে ফিরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","সন্ধ্যাবেলায় সেই দুজন দূত সদোমে উপস্থিত হলেন। লোট নগরের প্রবেশদ্বারে বসেছিলেন। তাঁদের দেখতে পেয়ে তিনি তাঁদের সাথে দেখা করার জন্য উঠে গেলেন ও মাটিতে উবুড় হয়ে প্রণাম করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“হে আমার প্রভুরা,” তিনি বললেন, “দয়া করে আপনাদের এই দাসের বাড়ির দিকে আসুন। আপনারা পা ধুয়ে এখানে রাত কাটাতে পারেন ও তারপর ভোরবেলায় আপনাদের যাত্রাপথে এগিয়ে যান।” “না,” তাঁরা উত্তর দিলেন, “আমরা চকেই রাত কাটাব।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","কিন্তু তিনি এত পীড়াপীড়ি করলেন যে তাঁরা তাঁর সাথে গেলেন ও তাঁর বাড়িতে প্রবেশ করলেন। তিনি তাঁদের জন্য কিছু খাবারদাবার রান্না করলেন ও খামিরবিহীন রুটি সেঁকে দিলেন, ও তাঁরা তা খেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","তাঁরা শুতে যাওয়ার আগে, সদোম নগরের সবদিক থেকে লোকজন এসে—যুবকেরা ও বৃদ্ধেরা—সবাই বাড়িটি ঘিরে ধরল। ");
INSERT INTO benobcv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","তারা লোটকে ডেকে বলল, “আজ রাতে যে লোকেরা তোমার কাছে এসেছে, তারা কোথায়? তাদের আমাদের কাছে বের করে নিয়ে এসো, যেন আমরা তাদের সঙ্গে যৌনসঙ্গম করতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","তাদের সাথে দেখা করার জন্য লোট বাইরে গেলেন ও পিছন থেকে দরজাটি বন্ধ করে দিলেন ");
INSERT INTO benobcv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","এবং বললেন, “হে আমার বন্ধুরা, না। এরকম মন্দ কাজ কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","দেখো, আমার এমন দুই মেয়ে আছে যারা কখনও কোনো পুরুষের সাথে সহবাস করেনি। আমি তাদের তোমাদের কাছে বের করে আনি, আর তোমরা তাদের সাথে যা ইচ্ছা তা করতে পারো। কিন্তু এই লোকদের প্রতি কিছু কোরো না, কারণ তাঁরা আমার ঘরে আশ্রয় নিতে এসেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“আমাদের পথ থেকে সরে দাঁড়া।” তারা উত্তর দিল। “এ তো এক বিদেশি হয়ে এখানে এসেছিল, আর এখন কি না বিচারক হওয়ার চেষ্টা করছে! আমরা তোর প্রতি ওদের চেয়েও মন্দ আচরণ করব।” তারা লোটের উপর চাপ বাড়িয়ে যাচ্ছিল ও দরজা ভেঙে ফেলার জন্য সামনে এগিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","কিন্তু ভিতরে থাকা ব্যক্তিরা হাত বাড়িয়ে লোটকে বাড়ির ভিতরে ঢুকিয়ে দরজা বন্ধ করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","পরে তাঁরা সেই বাড়ির দরজায় যারা দাঁড়িয়েছিল—যুবকদের ও বৃদ্ধদের—এমন অন্ধতায় আছন্ন করলেন, যে তারা আর দরজাই খুঁজে পেল না। ");
INSERT INTO benobcv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","সেই দুই ব্যক্তি লোটকে বললেন, “এখানে তোমার আর কেউ কি আছে—জামাই, ছেলে বা মেয়ে, অথবা এই নগরের এমন কেউ, যারা তোমার আপনজন? এখান থেকে তাদের বের করে নিয়ে যাও, ");
INSERT INTO benobcv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","কারণ আমরা এই স্থানটি ধ্বংস করতে যাচ্ছি। এখানকার লোকজনের বিরুদ্ধে ওঠা কোলাহল সদাপ্রভুর কানে এত জোরে বেজেছে, যে এটি ধ্বংস করার জন্যই তিনি আমাদের এখানে পাঠিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","অতএব লোট বাইরে গিয়ে তাঁর সেই জামাইদের সাথে কথা বললেন, যারা তাঁর মেয়েদের বিয়ে করার জন্য বাগ্‌দান করেছিল। তিনি বললেন, “তাড়াতাড়ি করো ও এখান থেকে বেরিয়ে যাও, কারণ সদাপ্রভু এই নগরটি ধ্বংস করতে চলেছেন!” কিন্তু তাঁর জামাইরা ভেবেছিল যে তিনি বুঝি ঠাট্টা করছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ভোর হতে না হতেই, দূতেরা লোটকে অনুরোধ জানিয়ে বললেন, “তাড়াতাড়ি করো! যারা এখানে আছে, তোমার সেই স্ত্রী ও দুই মেয়েকে সাথে নাও, তা না হলে এই নগরটিকে যখন দণ্ড দেওয়া হবে, তখন তোমরাও নিশ্চিহ্ন হয়ে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","তিনি যখন ইতস্তত বোধ করছিলেন, তখন সেই ব্যক্তিরা তাঁর হাত, তাঁর স্ত্রীর হাত ও তাঁর দুই মেয়ের হাত চেপে ধরে নিরাপদে তাঁদের নগরের বাইরে নিয়ে গেলেন, কারণ সদাপ্রভু তাঁদের প্রতি দয়াবান ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","তাঁদের বাইরে বের করে আনার পরেই সেই ব্যক্তিদের মধ্যে একজন বললেন, “প্রাণ বাঁচানোর জন্য পালিয়ে যাও! পিছনে ফিরে তাকিয়ো না, আর সমভূমিতে কোথাও দাঁড়িয়ো না! পাহাড়-পর্বতে পালিয়ে যাও, তা না হলে তোমরা নিশ্চিহ্ন হয়ে যাবে!” ");
INSERT INTO benobcv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","কিন্তু লোট তাঁদের বললেন, “হে আমার প্রভুরা, না, দয়া করুন! ");
INSERT INTO benobcv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","আপনাদের এই দাস আপনাদের দৃষ্টিতে অনুগ্রহ লাভ করেছে, এবং আপনারা আমার প্রাণরক্ষার জন্য অশেষ দয়া দেখিয়েছেন। কিন্তু আমি পাহাড়-পর্বতে পালিয়ে যেতে পারব না; এই দুর্যোগ আমাকে গ্রাস করবে ও আমি মারা যাব। ");
INSERT INTO benobcv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","দেখুন, এখানে কাছাকাছি পালিয়ে যাওয়ার উপযোগী একটি নগর আছে, আর তা ছোটও। আমাকে সেখানে পালিয়ে যেতে দিন—সেটি খুবই ছোটো, তাই না? তবেই তো আমার প্রাণরক্ষা হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","তিনি তাঁকে বললেন, “তা বেশ, এই অনুরোধটিও আমি রাখব; যে নগরটির কথা তুমি বললে, আমি সেটি উৎখাত করব না। ");
INSERT INTO benobcv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","কিন্তু তাড়াতাড়ি সেখানে পালিয়ে যাও, কারণ যতক্ষণ না তুমি সেখানে পৌঁছে যাচ্ছ, আমি কিছুই করতে পারব না।” (সেজন্যই নগরটিকে সোয়র নাম দেওয়া হল।) ");
INSERT INTO benobcv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","লোট সোয়রে পৌঁছালে, দেশে সূর্যোদয় হল। ");
INSERT INTO benobcv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","তখন সদাপ্রভু সদোম ও ঘমোরার উপর—সদাপ্রভুর কাছ থেকে, আকাশ থেকে—জ্বলন্ত গন্ধক বর্ষণ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","এভাবে তিনি সেই নগরগুলি ও সমগ্র সমতল এলাকা উৎখাত করলেন, ও নগরগুলিতে যত প্রাণী ছিল, সেসব—আর দেশের গাছপালাও ধ্বংস করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","কিন্তু লোটের স্ত্রী পিছনে ফিরে তাকাল, ও সে এক লবণস্তম্ভে পরিণত হল। ");
INSERT INTO benobcv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","পরদিন ভোরবেলায় অব্রাহাম উঠে সেই স্থানে ফিরে গেলেন, যেখানে তিনি সদাপ্রভুর সামনে দাঁড়িয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","তিনি নিচে সদোম ও ঘমোরার দিকে, এবং সমগ্র সমতল এলাকার দিকে তাকালেন, ও তিনি দেখলেন যে এক চুল্লি থেকে ওঠা ধোঁয়ার মতো ঘন ধোঁয়া সেই দেশ থেকে উঠে আসছে। ");
INSERT INTO benobcv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","তাই ঈশ্বর যখন সমতল এলাকার নগরগুলি ধ্বংস করে দিলেন, তখন তিনি অব্রাহামকে স্মরণ করলেন, এবং লোটকে তিনি সেই সর্বনাশ থেকে বের করে আনলেন, যা সেই নগরগুলিকে উৎখাত করে ছেড়েছিল, যেখানে লোট বসবাস করছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","লোট ও তাঁর দুই মেয়ে সোয়র ছেড়ে পাহাড়-পর্বতের উপর বসতি স্থাপন করলেন, কারণ সোয়রে থাকতে তিনি ভয় পেয়েছিলেন। তিনি ও তাঁর দুই মেয়ে একটি গুহাতে বসবাস করছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","একদিন তাঁর বড়ো মেয়ে ছোটো মেয়েকে বলল, “আমাদের বাবা বৃদ্ধ হয়ে গিয়েছেন, আর সমগ্র পৃথিবীর প্রচলিত প্রথানুসারে—এখানে এমন কোনো পুরুষও নেই, যে আমাদের সন্তান দিতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","আয়, আমাদের বাবাকে দ্রাক্ষারস পান করাই ও পরে তাঁর সাথে সহবাস করি এবং আমাদের বাবার মাধ্যমে আমাদের পারিবারিক বংশধারা এগিয়ে নিয়ে যাই।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","সেরাতে তারা তাদের বাবাকে দ্রাক্ষারস পান করালো, এবং বড়ো মেয়ে ভিতরে গিয়ে তাঁর সাথে সহবাস করল। লোট জানতেই পারেননি কখন সে শুতে এসেছিল আর কখনোই বা সে উঠে পড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","পরদিন বড়ো মেয়ে ছোটো মেয়েকে বলল, “গতকাল রাতে আমি আমার বাবার সাথে সহবাস করেছিলাম। আয়, আজ রাতেও আমরা তাঁকে দ্রাক্ষারস পান করাই আর তুই ভিতরে গিয়ে তাঁর সাথে সহবাস কর, যেন আমরা আমাদের বাবার মাধ্যমে আমাদের পারিবারিক বংশধারা এগিয়ে নিয়ে যেতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","তাই সেরাতেও তারা তাদের বাবাকে দ্রাক্ষারস পান করালো, আর ছোটো মেয়ে ভিতরে গিয়ে তাঁর সাথে সহবাস করল। এবারও তিনি জানতেই পারেননি কখন সে শুতে এসেছিল আর কখনোই বা সে উঠে পড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","অতএব লোটের দুই মেয়েই তাদের বাবার মাধ্যমে গর্ভবতী হল। ");
INSERT INTO benobcv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","বড়ো মেয়ে এক পুত্রসন্তান লাভ করল, আর সে তার নাম দিল মোয়াব; সে বর্তমানকালের মোয়াবীয়দের পূর্বপুরুষ। ");
INSERT INTO benobcv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ছোটো মেয়েও এক পুত্রসন্তান লাভ করল, ও সে তার নাম দিল বিন-অম্মি; সে বর্তমানকালের অম্মোনীয়দের পূর্বপুরুষ। ");
INSERT INTO benobcv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","এমতাবস্থায় অব্রাহাম সেখান থেকে নেগেভ অঞ্চলের দিকে এগিয়ে গিয়ে কাদেশ ও শূরের মাঝখানে বসবাস করলেন। কিছুকাল তিনি গরারে থেকে গেলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","আর সেখানে অব্রাহাম তাঁর স্ত্রী সারার বিষয়ে বললেন, “এ আমার বোন।” তখন গরারের রাজা অবীমেলক লোক পাঠিয়ে সারাকে তুলে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","কিন্তু একদিন রাতে ঈশ্বর স্বপ্নে অবীমেলককে দর্শন দিয়ে তাঁকে বললেন, “যে মহিলাটিকে তুমি নিয়ে এসেছ, তার জন্য তুমি মৃত্যুর পাত্র হয়ে গিয়েছ; সে এক বিবাহিত মহিলা।” ");
INSERT INTO benobcv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","অবীমেলক তখনও সারার কাছাকাছি যাননি, তাই তিনি বললেন, “প্রভু, তুমি কি নির্দোষ এক জাতিকে ধ্বংস করবে? ");
INSERT INTO benobcv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","সেই লোকটি কি আমাকে বলেননি, ‘এ আমার বোন’ আর মহিলাটিও কি বলেননি, ‘উনি আমার দাদা?’ বিশুদ্ধ এক বিবেক সমেত ও শুচিশুদ্ধ হাতেই আমি এ কাজ করেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","তখন ঈশ্বর স্বপ্নে তাঁকে বললেন, “হ্যাঁ, আমি জানি যে তুমি বিশুদ্ধ বিবেক সমেত এ কাজ করেছ, আর তাই আমি তোমাকে আমার বিরুদ্ধে পাপ করা থেকে বিরত রেখেছি। এজন্যই আমি তাকে ছুঁতে দিইনি। ");
INSERT INTO benobcv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","এখন সেই লোকটির স্ত্রীকে ফিরিয়ে দাও, কারণ সে একজন ভাববাদী এবং সে তোমার জন্য প্রার্থনা করবে ও তুমি বেঁচে যাবে। কিন্তু যদি তুমি মহিলাটিকে ফিরিয়ে না দাও, তবে নিশ্চিত থাকতে পারো যে তুমি ও তোমার সব লোকজন মারা যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","পরদিন ভোরবেলায় অবীমেলক তাঁর সব কর্মকর্তাকে ডেকে পাঠালেন এবং যা যা ঘটেছে সেসব যখন তিনি তাঁদের বলে শোনালেন, তখন তাঁরা খুব ভয় পেয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","পরে অবীমেলক অব্রাহামকে নিজের কাছে ডেকে পাঠিয়ে বললেন, “আমাদের প্রতি আপনি এ কী করলেন? আমি আপনার প্রতি কী এমন অন্যায় করেছি যে আপনি আমার ও আমার রাজ্যের উপর এত বড়ো দোষ লাগিয়ে দিলেন? আপনি আমার প্রতি যা করলেন, তা করা আপনার উচিত হয়নি।” ");
INSERT INTO benobcv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","আর অবীমেলক অব্রাহামকে জিজ্ঞাসা করলেন, “কেন আপনি এরকম করতে গেলেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","অব্রাহাম উত্তর দিলেন, “আমি মনে করেছিলাম, ‘নিঃসন্দেহে এখানে মানুষের মনে ঈশ্বরভয় নেই, আর তারা আমার স্ত্রীর কারণে আমাকে হত্যা করবে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","এছাড়াও, এ সত্যিই আমার বোন, আমার বাবার মেয়ে হলেও সে আমার মায়ের মেয়ে নয়; পরে সে আমার স্ত্রী হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","আর ঈশ্বর যখন আমার পিতৃগৃহ ছাড়তে আমাকে বাধ্য করেছিলেন, তখন আমি একে বলেছিলাম, ‘এভাবেই তুমি আমার প্রতি তোমার ভালোবাসা প্রকাশ করতে পারবে: আমরা যেখানে যেখানে যাব, আমার বিষয়ে তুমি বলবে, “উনি আমার দাদা।” ’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","তখন অবীমেলক মেষ ও গবাদি পশুপাল এবং ক্রীতদাস ও দাসীদের এনে অব্রাহামকে দিলেন, আর তাঁর স্ত্রী সারাকেও তিনি তাঁর কাছে ফিরিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","আর অবীমেলক বললেন, “আমার দেশটি আপনার সামনেই আছে; আপনার যেখানে ইচ্ছা সেখানে বসবাস করুন।” ");
INSERT INTO benobcv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","সারাকে তিনি বললেন, “আমি আপনার দাদাকে 1,000 শেকল রুপো দিচ্ছি। যারা আপনার সাথে আছে, তাদের সামনেই আপনার বিরুদ্ধে করা অন্যায়ের ক্ষতিপূরণস্বরূপ আমি এটি দিচ্ছি; আপনার সব দোষ খণ্ডন হল।” ");
INSERT INTO benobcv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","তখন অব্রাহাম ঈশ্বরের কাছে প্রার্থনা করলেন এবং ঈশ্বর অবীমেলককে, তাঁর স্ত্রীকে ও তাঁর ক্রীতদাসীদের সুস্থ করে দিলেন যেন তারা আবার সন্তান লাভ করতে পারে, ");
INSERT INTO benobcv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","কারণ অব্রাহামের স্ত্রী সারার জন্য সদাপ্রভু অবীমেলকের পরিবারের সব মহিলাকে গর্ভধারণ করা থেকে বিরত রেখেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","সদাপ্রভু তাঁর বলা কথানুসারে সারার প্রতি অনুগ্রহকারী হলেন, এবং সদাপ্রভু যে প্রতিজ্ঞা করেছিলেন, সারার প্রতি তাই করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","সারা গর্ভবতী হলেন এবং অব্রাহামের বৃদ্ধাবস্থায়, ঈশ্বর যে সময়ের প্রতিজ্ঞা তাঁর কাছে করেছিলেন, ঠিক সেই সময়ে অব্রাহামের জন্য এক পুত্রসন্তানের জন্ম দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","অব্রাহামের জন্য সারা যে পুত্রসন্তানের জন্ম দিলেন, অব্রাহাম তার নাম দিলেন ইস্‌হাক। ");
INSERT INTO benobcv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","তাঁর ছেলে ইস্‌হাকের বয়স যখন আট দিন, তখন ঈশ্বরের আদেশানুসারে অব্রাহাম তার সুন্নত করালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","অব্রাহামের ছেলে ইস্‌হাকের যখন জন্ম হয় তখন তাঁর বয়স একশো বছর। ");
INSERT INTO benobcv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","সারা বললেন, “ঈশ্বর আমাকে হাসির পাত্রী করে তুলেছেন, আর যে কেউ একথা শুনবে সেও আমাকে নিয়ে হাসাহাসি করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","পরে তিনি এও বললেন, “কে অব্রাহামকে বলতে পেরেছিল যে সারা শিশুসন্তানকে স্তন্যদান করবে? তা সত্ত্বেও তাঁর বৃদ্ধাবস্থায় আমি তাঁর জন্য এক ছেলের জন্ম দিয়েছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","শিশুটি বেড়ে উঠল ও তার স্তন্য-ত্যাগ করানো হল, এবং যেদিন ইস্‌হাকের স্তন্য-ত্যাগ করানো হল, সেদিন অব্রাহাম এক মহাভোজের আয়োজন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","কিন্তু সারা দেখতে পেলেন যে, যে ছেলেটিকে মিশরীয় হাগার অব্রাহামের জন্য জন্ম দিয়েছিল, সে ঠাট্টা-বিদ্রুপ করছে, ");
INSERT INTO benobcv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","আর তাই তিনি অব্রাহামকে বললেন, “ওই ক্রীতদাসী ও তার ছেলেকে তাড়িয়ে দাও, কারণ আমার ছেলে ইস্‌হাকের সম্পত্তির অধিকারে ওই মহিলার ছেলে কখনোই ভাগ বসাবে না।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","বিষয়টি অব্রাহামকে খুবই ব্যথিত করে তুলেছিল, কারণ এতে তাঁর ছেলের স্বার্থ জড়িত ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","কিন্তু ঈশ্বর তাঁকে বললেন, “ছেলেটির ও তোমার ক্রীতদাসীর বিষয়ে তুমি এত ব্যথিত হোয়ো না। সারা তোমাকে যা বলছে, তা শোনো, কারণ ইস্‌হাকের মাধ্যমেই তোমার সন্তানসন্ততি পরিচিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","আমি ওই ক্রীতদাসীর ছেলেকেও এক জাতিতে পরিণত করব, কারণ সেও তোমার সন্তান।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","পরদিন ভোরবেলায় অব্রাহাম কিছু খাবার ও এক মশক জল নিয়ে সেগুলি হাগারকে দিলেন। তিনি সেগুলি হাগারের কাঁধে চাপিয়ে দিয়ে তাকে সেই ছেলেটি সমেত বিদায় করে দিলেন। হাগার প্রস্থান করল এবং বের-শেবার মরুভূমিতে ইতস্তত ঘুরে ফিরে বেড়াচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","মশকের জল যখন শেষ হয়ে গেল, তখন সে ছেলেটিকে একটি ঝোপের তলায় নিয়ে গিয়ে রাখল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","পরে সে একটু দূরে, প্রায় 100 মিটার দূরে গিয়ে বসে পড়ল, কারণ সে ভাবল, “আমি নিজের চোখে ছেলেটির মৃত্যুদৃশ্য দেখতে পারব না।” আর সেখানে বসে সে ফোঁপাতে শুরু করল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ঈশ্বর সেই ছেলেটির কান্না শুনতে পেলেন, এবং ঈশ্বরের দূত স্বর্গ থেকে হাগারকে ডেকে বললেন, “কী হল, হাগার? ভয় পেয়ো না; সেখানে শুয়ে ছেলেটি যখন কাঁদছে, তখন তার কান্না ঈশ্বর শুনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ছেলেটিকে তুলে তার হাত ধরো, কারণ আমি তাকে এক মহাজাতিরূপে গড়ে তুলব।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","তখন ঈশ্বর হাগারের চোখ খুলে দিলেন আর সে জলের এক কুয়ো দেখতে পেল। তাই সে গিয়ে মশকে জল ভরে ছেলেটিকে পানীয় জল এনে দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ছেলেটি যখন বেড়ে উঠছিল তখন ঈশ্বর তার সাথেই ছিলেন। সে মরুভূমিতে বসবাস করছিল ও এক তিরন্দাজ হয়ে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","সে যখন পারণ মরুভূমিতে বসবাস করছিল তখন তার মা, মিশর থেকে এক মহিলাকে তার স্ত্রী হওয়ার জন্য নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","সেই সময় অবীমেলক তাঁর সৈন্যদলের সেনাপতি ফীকোলকে সাথে নিয়ে অব্রাহামের কাছে এসে বললেন, “আপনি যা যা করেন, সবেতেই ঈশ্বর আপনার সহায় হন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","এখন ঈশ্বরকে সাক্ষী রেখে আমার কাছে শপথ করুন যে আপনি আমার বা আমার সন্তানসন্ততির বা আমার বংশধরদের সঙ্গে প্রতারণা করবেন না। আমি আপনার প্রতি যে দয়া দেখিয়েছিলাম, সেই একইরকম দয়া আপনি আমার প্রতি ও যে দেশে এখন আপনি এক বিদেশিরূপে বসবাস করছেন, সেই দেশের প্রতিও দেখান।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","অব্রাহাম বললেন, “আমি শপথ করছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","তখন অব্রাহাম অবীমেলকের কাছে সেই সজল কুয়োটির বিষয়ে অভিযোগ জানালেন, যেটি অবীমেলকের দাসেরা জোর করে দখল করে নিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","কিন্তু অবীমেলক বললেন, “আমি জানি না কে এই কাজটি করেছে। আপনিও আমাকে কিছু বলেননি, আর আজই আমি এই বিষয়ে শুনলাম।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","অতএব অব্রাহাম মেষ ও গবাদি পশুপাল আনিয়ে সেগুলি অবীমেলককে দিলেন এবং দুজনে এক সন্ধিচুক্তি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","অব্রাহাম তাঁর মেষপাল থেকে মেষের সাতটি মাদি শাবক পৃথক করলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","এবং অবীমেলক অব্রাহামকে জিজ্ঞাসা করলেন, “আপনি যে মেষের এই সাতটি মাদি শাবক পৃথক করলেন, এর অর্থ কী?” ");
INSERT INTO benobcv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","তিনি উত্তর দিলেন, “আমিই যে এই কুয়োটি খুঁড়েছি, তার প্রমাণস্বরূপ আপনি আমার হাত থেকে মেষের এই সাতটি শাবক গ্রহণ করুন।” ");
INSERT INTO benobcv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","অতএব সেই স্থানটির নাম হল বের-শেবা, কারণ সেই দুজন লোক সেখানে এক শপথ নিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","বের-শেবায় সন্ধিচুক্তি সম্পাদিত হওয়ার পর অবীমেলক ও তাঁর সৈন্যদলের সেনাপতি ফীকোল ফিলিস্তিনীদের দেশে ফিরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","অব্রাহাম বের-শেবায় একটি ঝাউ গাছ লাগালেন, ও সেখানে তিনি অনন্তজীবী ঈশ্বর সদাপ্রভুর আরাধনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","আর অব্রাহাম দীর্ঘকাল ফিলিস্তিনীদের দেশে থেকে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","কিছুকাল পর ঈশ্বর অব্রাহামকে পরীক্ষা করলেন। তিনি তাঁকে বললেন, “অব্রাহাম!” “আমি এখানে,” অব্রাহাম উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","তখন ঈশ্বর বললেন, “তোমার ছেলেকে, তোমার একমাত্র ছেলেকে, যাকে তুমি ভালোবাসো তাকে—সেই ইস্‌হাককে—নাও ও মোরিয়া প্রদেশে যাও। সেখানে এমন একটি পর্বতের উপর তাকে হোমবলিরূপে উৎসর্গ করো, যেটি আমি তোমাকে দেখিয়ে দেব।” ");
INSERT INTO benobcv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","পরদিন ভোরবেলায় অব্রাহাম উঠে তাঁর গাধায় জিন চাপালেন। তিনি তাঁর দাসদের মধ্যে দুজনকে ও তাঁর ছেলে ইস্‌হাককে সাথে নিলেন। হোমবলির জন্য যথেষ্ট পরিমাণ কাঠ কাটার পর তিনি সেই স্থানের উদ্দেশে যাত্রা শুরু করলেন, যেটির বিষয়ে ঈশ্বর তাঁকে আগেই বলে দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","তৃতীয় দিনে অব্রাহাম চোখ তুলে তাকিয়ে দূর থেকে সেই স্থানটি দেখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","তিনি তাঁর দাসদের বললেন, “ছেলেটিকে সাথে নিয়ে আমি যখন সেখানে যাচ্ছি, তখন তোমরা গাধাটির সঙ্গে এখানেই থাকো। আমরা আরাধনা করব ও পরে তোমাদের কাছে ফিরে আসব।” ");
INSERT INTO benobcv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","অব্রাহাম হোমবলির কাঠ নিয়ে সেগুলি তাঁর ছেলে ইস্‌হাকের কাঁধে চাপিয়ে দিলেন, এবং তিনি স্বয়ং আগুন ও ছুরি নিলেন। তাঁরা দুজন যখন একসাথে এগিয়ে যাচ্ছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ইস্‌হাক মুখ খুলে তাঁর বাবা অব্রাহামকে বললেন, “বাবা?” “বলো বাছা?” অব্রাহাম উত্তর দিলেন। “আগুন ও কাঠ তো এখানে আছে,” ইস্‌হাক বললেন, “কিন্তু হোমবলির জন্য মেষশাবক কোথায়?” ");
INSERT INTO benobcv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","অব্রাহাম উত্তর দিলেন, “বাছা, ঈশ্বর স্বয়ং হোমবলির জন্য মেষশাবকের জোগান দেবেন।” আর তাঁরা দুজন একসাথে এগিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ঈশ্বর যে স্থানটির কথা বলেছিলেন, তারা যখন সেখানে পৌঁছালেন, তখন অব্রাহাম সেখানে একটি যজ্ঞবেদি নির্মাণ করলেন ও সেটির উপর কাঠ বিছিয়ে দিলেন। তিনি তাঁর ছেলে ইস্‌হাককে বেঁধে সেই বেদিতে, কাঠের উপর শুইয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","পরে তিনি হাত বাড়িয়ে ছুরিটি ধরে তাঁর ছেলেকে হত্যা করতে উদ্যত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","কিন্তু সদাপ্রভুর দূত স্বর্গ থেকে তাঁকে ডেকে বললেন, “অব্রাহাম, অব্রাহাম!” “আমি এখানে,” তিনি উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“ছেলেটির গায়ে হাত দিয়ো না,” দূত বললেন। “ওর কোনও ক্ষতি কোরো না। এখন আমি বুঝেছি যে তুমি ঈশ্বরকে ভয় করো, কারণ আমাকে তুমি তোমার ছেলেটি, তোমার একমাত্র ছেলেটি দিতে অসম্মত হওনি।” ");
INSERT INTO benobcv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","অব্রাহাম চোখ তুলে তাকিয়ে দেখতে পেলেন সেখানে ঝোপঝাড়ের মধ্যে একটি মদ্দা মেষ শিং আটকানো অবস্থায় পড়ে আছে। তিনি সেখানে গিয়ে মদ্দা মেষটিকে এনে তাঁর ছেলের পরিবর্তে সেটিকে এক হোমবলিরূপে উৎসর্গ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","অতএব অব্রাহাম সেই স্থানটির নাম দিলেন সদাপ্রভু জোগাবেন। আর আজও পর্যন্ত একথা বলা হয়ে থাকে, “সদাপ্রভুর পর্বতে তা জোগানো হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","সদাপ্রভুর দূত দ্বিতীয়বার স্বর্গ থেকে অব্রাহামকে ডাক দিলেন ");
INSERT INTO benobcv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","এবং বললেন, “সদাপ্রভু ঘোষণা করছেন, আমি নিজের নামে শপথ করছি, যেহেতু তুমি এই কাজটি করেছ এবং আমাকে তোমার ছেলেটি, তোমার একমাত্র ছেলেটি দিতে অসম্মত হওনি, ");
INSERT INTO benobcv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","তাই অবশ্যই আমি তোমাকে আশীর্বাদ করব ও তোমার বংশধরদের আকাশের তারাগুলির মতো ও সমুদ্রের বালুকণার মতো বিপুল সংখ্যক করে তুলব। তোমার বংশধররা তাদের শত্রুদের নগরগুলি দখল করে নেবে, ");
INSERT INTO benobcv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","এবং তোমার সন্তানসন্ততির মাধ্যমে পৃথিবীর সব জাতি আশীর্বাদ লাভ করবে, কারণ তুমি আমার বাধ্য হয়েছ।” ");
INSERT INTO benobcv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","পরে অব্রাহাম তাঁর দাসদের কাছে ফিরে এলেন, এবং তাঁরা সবাই মিলে বের-শেবার উদ্দেশে যাত্রা শুরু করলেন। আর অব্রাহাম বের-শেবাতেই থেকে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","কিছুকাল পর অব্রাহামকে বলা হল, “মিল্কাও মা হয়েছেন; তিনি আপনার ভাই নাহোরের জন্য এই ছেলেদের জন্ম দিয়েছেন: ");
INSERT INTO benobcv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","প্রথমজাত ঊষ, তার ভাই বূষ, কমূয়েল (অরামের বাবা), ");
INSERT INTO benobcv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","কেষদ, হসো, পিলদশ, যিদলফ ও বথূয়েল।” ");
INSERT INTO benobcv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","বথূয়েল রিবিকার বাবা। মিল্কা অব্রাহামের ভাই নাহোরের জন্য এই আটটি ছেলের জন্ম দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","যার নাম রূমা, নাহোরের সেই উপপত্নীও এই ছেলেদের জন্ম দিল: টেবহ, গহম, তহশ ও মাখা। ");
INSERT INTO benobcv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","সারা 127 বছর বেঁচেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","কনান দেশের অন্তর্গত কিরিয়ৎ-অর্বে (অথবা, হিব্রোণে) তিনি মারা গেলেন, এবং অব্রাহাম সারার জন্য শোকপ্রকাশ ও কান্নাকাটি করার জন্য (সেখানে) গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","পরে অব্রাহাম তাঁর স্ত্রীর মৃতদেহের পাশ থেকে উঠে এসে হিত্তীয়দের সাথে কথা বললেন। তিনি বললেন, ");
INSERT INTO benobcv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“আপনাদের মাঝখানে আমি একজন বিদেশি ও অপরিচিত ব্যক্তি। কবরস্থান বানানোর জন্য এখানে আমাকে কিছুটা জমি বিক্রি করে দিন, যেন আমি আমার স্ত্রীর মৃতদেহ কবর দিতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","হিত্তীয়েরা অব্রাহামকে উত্তর দিল, ");
INSERT INTO benobcv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“মশাই, আমাদের কথা শুনুন। আমাদের মাঝখানে আপনি তো এক মহান রাজপুরুষ। আমাদের কবরগুলির মধ্যে আপনার পছন্দসই সেরা কবরটিতেই আপনার মৃত পরিজনকে কবর দিন। আমাদের মধ্যে কেউই আপনার মৃত পরিজনকে কবর দেওয়ার জন্য নিজের কবরটি দিতে অস্বীকার করব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","তখন অব্রাহাম উঠে দাঁড়িয়ে সেই দেশের লোকদের অর্থাৎ, হিত্তীয়দের সামনে প্রণত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","তিনি তাদের বললেন, “আপনারা যদি চান যে আমি আমার মৃত পরিজনকে এখানে কবর দিই, তবে আমার কথা শুনুন এবং আপনারা আমার হয়ে আমার ও সোহরের ছেলে ইফ্রোণের মাঝে মধ্যস্থতা করুন, ");
INSERT INTO benobcv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","যেন তিনি তাঁর অধিকারে থাকা সেই মক্‌পেলা গুহাটি আমায় বিক্রি করেন, যেটি তাঁর জমির শেষ প্রান্তে আছে। তাঁকে বলুন, তিনি যেন সেটি সম্পূর্ণ দাম নিয়ে আপনাদের মাঝে অবস্থিত এক কবরস্থানরূপে আমায় বিক্রি করে দেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","হিত্তীয় ইফ্রোণ তাঁর লোকজনের মাঝখানে বসেছিলেন এবং যে হিত্তীয়েরা তাঁর নগরের প্রবেশদ্বারের কাছে সমবেত হল, তাদের সবাইকে শুনিয়ে শুনিয়ে তিনি অব্রাহামকে উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“হে আমার প্রভু, না,” তিনি বললেন। “আমার কথা শুনুন; আমি আপনাকে সেই জমিটি দিলাম, ও সেখানে অবস্থিত গুহাটিও দিলাম। আমার লোকজনের উপস্থিতিতেই আমি এগুলি আপনাকে দিলাম। আপনার মৃত পরিজনকে আপনি কবর দিন।” ");
INSERT INTO benobcv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","অব্রাহাম আরও একবার সেই দেশের লোকদের সামনে প্রণত হলেন ");
INSERT INTO benobcv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","এবং তাদের শুনিয়ে শুনিয়ে তিনি ইফ্রোণকে বললেন, “আমার কথা শুনতে চাইলে, শুনুন। আমি জমিটির দাম দেব। আমার কাছ থেকে তা গ্রহণ করুন, যেন সেখানে আমি আমার মৃত পরিজনকে কবর দিতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ইফ্রোণ অব্রাহামকে উত্তর দিলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“হে আমার প্রভু, আমার কথা শুনুন; জমিটির দাম 400 শেকল রুপো, কিন্তু আপনার ও আমার মধ্যে তাতে কী আসে-যায়? আপনার মৃত পরিজনকে আপনি কবর দিন।” ");
INSERT INTO benobcv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ইফ্রোণের শর্তে অব্রাহাম রাজি হলেন এবং হিত্তীয়দের কর্ণগোচরে ইফ্রোণ যে দাম ধার্য করলেন, ততখানি পরিমাণ রুপো: বণিকদের মধ্যে প্রচলিত বর্তমান ওজন অনুসারে 400 শেকল রুপো তিনি তাঁকে ওজন করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","অতএব মম্রির কাছাকাছি অবস্থিত মক্‌পেলায় ইফ্রোণের সেই জমিটি—সেখানকার জমি ও গুহা, দুটিই এবং সেই জমির সীমানার অন্তর্গত সব গাছপালা—হস্তান্তরের দলিল ");
INSERT INTO benobcv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","অব্রাহামের নামে তাঁর সম্পত্তিরূপে সেই নগরের প্রবেশদ্বারের কাছে সমবেত সব হিত্তীয়ের উপস্থিতিতে পাকা করা হল। ");
INSERT INTO benobcv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","পরে অব্রাহাম তাঁর স্ত্রী সারাকে কনান দেশে মম্রির (অর্থাৎ, হিব্রোণের) পার্শ্ববর্তী মক্‌পেলার জমিতে অবস্থিত গুহায় কবর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","অতএব সেই জমি ও সেখানকার গুহাটি হিত্তীয়েরা দলিল করে এক কবরস্থানরূপে অব্রাহামের অধিকারভুক্ত করে দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","অব্রাহাম খুব বৃদ্ধ হয়ে গেলেন এবং সদাপ্রভু তাঁকে সবদিক থেকেই আশীর্বাদ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","যিনি তাঁর সব সম্পত্তি দেখাশোনা করতেন, তাঁর ঘরের সেই প্রবীণ দাসকে তিনি বললেন, “তুমি আমার ঊরুর তলায় হাত রাখো। ");
INSERT INTO benobcv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","যিনি স্বর্গের ঈশ্বর ও পৃথিবীরও ঈশ্বর, আমি চাই তুমি সেই সদাপ্রভুর নামে এই শপথ করো, যে আমি যাদের মধ্যে বসবাস করছি, সেই কনানীয়দের কোনো মেয়েকে তুমি আমার ছেলের স্ত্রী করে আনবে না, ");
INSERT INTO benobcv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","কিন্তু তুমি আমার দেশে ও আমার আপন আত্মীয়স্বজনদের কাছে যাবে এবং আমার ছেলে ইস্‌হাকের জন্য এক স্ত্রী নিয়ে আসবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","সেই দাস তাঁকে জিজ্ঞাসা করলেন, “সেই মেয়েটি যদি এই দেশে আসতে অনিচ্ছুক হয় তবে কী হবে? তবে কি যে দেশ থেকে আপনি এসেছেন, সেই দেশে আমি আপনার ছেলেকে ফিরিয়ে নিয়ে যাব?” ");
INSERT INTO benobcv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“তুমি কোনোমতেই আমার ছেলেকে সেই দেশে ফিরিয়ে নিয়ে যাবে না,” অব্রাহাম বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“স্বর্গের সেই ঈশ্বর সদাপ্রভু, যিনি আমাকে আমার পিতৃগৃহ থেকে ও আমার মাতৃভূমি থেকে বের করে এনেছেন এবং আমার সঙ্গে কথা বলেছেন এবং এক শপথের মাধ্যমে প্রতিজ্ঞা করে বলেছেন, ‘এই স্থানটি আমি তোমার সন্তানসন্ততিকে দেব,’ তিনিই তোমার অগ্রগামী করে তাঁর দূতকে পাঠিয়ে দেবেন, যেন তুমি সেখান থেকে আমার ছেলের জন্য এক স্ত্রী আনতে পারো। ");
INSERT INTO benobcv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","যদি সেই মেয়েটি তোমার সঙ্গে আসতে না চায়, তবে তুমি আমার এই শপথ থেকে মুক্ত হয়ে যাবে। শুধু তুমি আমার ছেলেকে সেখানে ফিরিয়ে নিয়ে যেয়ো না।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","অতএব সেই দাস তাঁর প্রভু অব্রাহামের ঊরুর তলায় হাত রেখে এই বিষয়ে তাঁর কাছে শপথ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","পরে সেই দাস তাঁর প্রভুর উটগুলির মধ্যে থেকে দশটি উটের পিঠে তাঁর প্রভুর কাছ থেকে পাওয়া সব ধরনের ভালো ভালো জিনিসপত্র চাপিয়ে নিয়ে রওনা হয়ে গেলেন। তিনি অরাম-নহরয়িমের উদ্দেশে রওনা হয়ে গেলেন এবং নাহোরের নগরে পৌঁছালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","তিনি নগরের বাইরে অবস্থিত একটি কুয়োর কাছে উটগুলিকে নতজানু করে বসালেন; তখন প্রায় সন্ধ্যা ঘনিয়ে আসছিল, যে সময় মহিলারা কুয়ো থেকে জল তুলতে যায়। ");
INSERT INTO benobcv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","তখন তিনি প্রার্থনা করলেন, “হে সদাপ্রভু, আমার প্রভু অব্রাহামের ঈশ্বর, আজ তুমি আমাকে সফল করে তোলো, এবং আমার প্রভু অব্রাহামের প্রতি দয়া দেখাও। ");
INSERT INTO benobcv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","দেখো, আমি এই জলের উৎসের ধারে দাঁড়িয়ে আছি, এবং নগরবাসীদের মেয়েরা জল তুলতে আসছে। ");
INSERT INTO benobcv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","এরকমই হোক যেন আমি যখন একটি যুবতী মেয়েকে বলব, ‘দয়া করে তোমার কলশিটি নামিয়ে রাখো যেন আমি জলপান করতে পারি,’ এবং সে যখন বলবে, ‘আপনি পান করুন এবং আপনার উটগুলির জন্যও আমি পানীয় জল দেব, ’ তখন সেই যেন সেই মেয়ে হয়, যাকে তুমি তোমার দাস ইস্‌হাকের জন্য মনোনীত করেছ। এর দ্বারাই আমি জানতে পারব যে তুমি আমার প্রভুর প্রতি দয়া দেখিয়েছ।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ঈশ্বরের কাছে করা তাঁর প্রার্থনাটি শেষ হওয়ার আগেই রিবিকা তার কলশি কাঁধে নিয়ে বেরিয়ে এলেন। তিনি অব্রাহামের ভাই নাহোরের স্ত্রী মিল্কার ছেলে বথূয়েলের মেয়ে। ");
INSERT INTO benobcv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","সেই মেয়েটি অপরূপ সুন্দরী, ও এক কুমারী ছিলেন; কোনও পুরুষ কখনও তাঁর সাথে শোয়নি। তিনি জলের উৎসের কাছে নেমে গিয়ে, তাঁর কলশিতে জল ভরে আবার উপরে উঠে আসছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","সেই দাস তাড়াতাড়ি তাঁর সাথে দেখা করে বললেন, “দয়া করে তোমার কলশি থেকে আমায় একটু জল দাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“হে আমার প্রভু, পান করুন,” এই বলে রিবিকা চট্ করে কলশিটি হাতে নামিয়ে এনে তাঁকে পানীয় জল দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","তাঁকে পানীয় জল দেওয়ার পর রিবিকা বললেন, “আমি আপনার উটগুলির জন্যও ততক্ষণ জল তুলতে থাকব, যতক্ষণ না তারা যথেষ্ট পরিমাণ জলপান করে ফেলছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","অতএব তিনি তাড়াতাড়ি সেই জাবপাত্রে কলশির জল খালি করে দিলেন, আরও জল তোলার জন্য কুয়োর কাছে দৌড়ে ফিরে গেলেন, এবং সেই দাসের সব উটের জন্য যথেষ্ট পরিমাণ জল তুলে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","কোনও কথা না বলে সেই লোকটি এই বিষয়টি বোঝার জন্য তাঁকে খুব ভালো করে লক্ষ্য করছিলেন, যে সদাপ্রভু তাঁর যাত্রা আদৌ সফল করেছেন কি না। ");
INSERT INTO benobcv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","উটগুলি জলপান করে ফেলার পর, সেই লোকটি এক বেকা ওজনের একটি সোনার নথ এবং দশ শেকল ওজনের সোনার দুটি বালা বের করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","পরে তিনি প্রশ্ন করলেন, “তুমি কার মেয়ে? দয়া করে আমায় বলো তো, তোমার পিতৃগৃহে আমাদের রাত কাটানোর জন্য ঘর আছে কি?” ");
INSERT INTO benobcv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","রিবিকা তাঁকে উত্তর দিলেন, “আমি সেই বথূয়েলের মেয়ে, যিনি নাহোরের ছেলে, ও যাঁকে মিল্কা নাহোরের জন্য জন্ম দিয়েছিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","তিনি আরও বললেন, “আমাদের কাছে প্রচুর খড়-বিচালি ও জাব আছে, তা ছাড়া আপনাদের রাত কাটানোর জন্য ঘরও আছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","তখন সেই লোকটি মাথা নত করে সদাপ্রভুর আরাধনা করলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","এবং বললেন, “আমার প্রভু অব্রাহামের ঈশ্বর সেই সদাপ্রভুর প্রশংসা হোক, যিনি আমার প্রভুর প্রতি তাঁর দয়া ও বিশ্বস্ততা দেখাতে ক্ষান্ত হননি। আমার ক্ষেত্রেও, সদাপ্রভু আমার প্রভুর আত্মীয়স্বজনের বাড়ি পর্যন্ত যাত্রাপথে আমাকে পথ দেখালেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","যুবতী মেয়েটি দৌড়ে গিয়ে তাঁর মায়ের পরিজনদের এইসব বিষয় জানালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","রিবিকার এক দাদা ছিলেন, যাঁর নাম লাবন, আর তিনি চট্ করে জলের উৎসের কাছে দাঁড়িয়ে থাকা লোকটির কাছে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","সেই নথটি এবং তাঁর বোনের হাতের বালা দেখামাত্রই এবং রিবিকাকে সেই লোকটি যা যা বলেছিলেন, সেসব কথা তাঁর কাছ থেকে শোনামাত্রই তিনি সেই লোকটির কাছে চলে গেলেন এবং দেখতে পেলেন, তিনি সেই জলের উৎসের কাছে উটগুলি নিয়ে দাঁড়িয়ে আছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“হে সদাপ্রভুর আশীর্বাদধন্য ব্যক্তি, আসুন,” তিনি বললেন। “আপনি এখানে বাইরে দাঁড়িয়ে আছেন কেন? আমি আপনার জন্য বাড়িঘর ঠিকঠাক করে রেখেছি এবং উটগুলির জন্যও জায়গা করে রেখেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","অতএব সেই লোকটি বাড়িতে গেলেন এবং উটগুলিকেও ভারমুক্ত করা হল। উটগুলির জন্য খড়-বিচালি ও জাব আনা হল এবং তাঁর ও তাঁর লোকজনের পা ধোয়ার জন্য জল আনা হল। ");
INSERT INTO benobcv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","পরে তাঁর সামনে খাবার পরিবেশন করা হল, কিন্তু তিনি বললেন, “আমার যা বলার আছে তা যতক্ষণ না আমি আপনাদের বলে শুনাচ্ছি, ততক্ষণ আমি কিছু খাব না।” “তবে আমাদের তা বলে ফেলুন।” লাবন বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","অতএব তিনি বললেন, “আমি অব্রাহামের দাস। ");
INSERT INTO benobcv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","সদাপ্রভু আমার প্রভুকে প্রচুর পরিমাণে আশীর্বাদ করেছেন, এবং তিনি ধনী হয়ে গিয়েছেন। সদাপ্রভু তাঁকে মেষ ও গবাদি পশুপাল, রুপো ও সোনা, দাস ও দাসী, এবং উট ও গাধা দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","আমার প্রভুর স্ত্রী সারা বৃদ্ধাবস্থায় তাঁর জন্য এক ছেলের জন্ম দিয়েছেন, এবং আমার প্রভুর নিজস্ব সবকিছু তিনি তাঁকেই দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","আর আমার প্রভু আমাকে দিয়ে এক শপথ করিয়ে নিয়েছেন, ও বলেছেন, ‘যাদের দেশে আমরা বসবাস করছি, সেই কনানীয়দের মেয়েদের মধ্যে থেকে কাউকে তুমি আমার ছেলের স্ত্রী করে আনবে না, ");
INSERT INTO benobcv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","কিন্তু তুমি আমার পিতৃপরিজনদের এবং আমার নিজের গোত্রভুক্ত লোকজনের কাছে যাবে, ও আমার ছেলের জন্য এক স্ত্রী নিয়ে আসবে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“তখন আমি আমার প্রভুকে জিজ্ঞাসা করেছিলাম, ‘সেই মেয়েটি যদি আমার সঙ্গে আসতে না চায় তবে কী হবে?’ ");
INSERT INTO benobcv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“তিনি উত্তর দিয়েছিলেন, ‘যাঁর সাক্ষাতে আমি বিশ্বস্ততাপূর্বক চলেছি, সেই সদাপ্রভুই তাঁর দূতকে তোমার সঙ্গে পাঠাবেন এবং তোমার যাত্রা সফল করবেন, যেন তুমি আমার নিজের গোত্রভুক্ত লোকজনের ও আমার পিতৃপরিজনদের মধ্য থেকেই আমার ছেলের জন্য এক স্ত্রী আনতে পারো। ");
INSERT INTO benobcv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","আমার শপথ থেকে তুমি মুক্ত হয়ে যাবে যদি, তুমি যখন আমার গোত্রভুক্ত লোকজনের কাছে যাবে, ও তারা যদি মেয়েটিকে তোমার হাতে তুলে দিতে অস্বীকার করে—তখন তুমি আমার শপথ থেকে মুক্ত হয়ে যাবে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“আজ যখন আমি জলের উৎসের কাছে এলাম, তখন আমি বললাম, ‘হে সদাপ্রভু, আমার প্রভু অব্রাহামের ঈশ্বর, যদি তোমার ইচ্ছা হয়, তবে দয়া করে তুমি আমার এই যাত্রা সফল করো, যে যাত্রায় আমি বের হয়ে এসেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","দেখো, আমি এই জলের উৎসের পাশে দাঁড়িয়ে আছি। একটি যুবতী মেয়ে যদি এখানে জল তুলতে আসে এবং আমি যদি তাকে বলি, “দয়া করে তোমার কলশি থেকে আমাকে একটু জলপান করতে দাও,” ");
INSERT INTO benobcv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","আর সে যদি আমাকে বলে, “পান করুন, এবং আমি আপনার উটগুলির জন্যও জল তুলে দেব,” তবে সেই যেন এমন একজন হয়, যাকে সদাপ্রভু আমার প্রভুর ছেলের জন্য মনোনীত করে রেখেছেন।’ ");
INSERT INTO benobcv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“মনে মনে আমি এই প্রার্থনা শেষ করার আগেই, রিবিকা বেরিয়ে এল, ও তার কাঁধে কলশি ছিল। সে জলের উৎসের কাছে নেমে গেল ও জল তুলছিল, আর আমি তাকে বললাম, ‘দয়া করে আমাকে পান করার জল দাও।’ ");
INSERT INTO benobcv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“সে তাড়াতাড়ি কাঁধ থেকে তার কলশিটি নামিয়ে এনে বলল, ‘পান করুন, এবং আমি আপনার উটগুলির জন্যও জল দেব।’ অতএব আমি জলপান করলাম, এবং সে উটগুলিকেও জল দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“আমি তাকে জিজ্ঞাসা করলাম, ‘তুমি কার মেয়ে?’ “সে বলল, ‘আমি সেই বথূয়েলের মেয়ে, যিনি নাহোরের ছেলে, ও যাঁকে মিল্কা নাহোরের জন্য জন্ম দিয়েছিলেন।’ “তখন আমি তার নাকে নথ ও হাতে বালা পরিয়ে দিলাম, ");
INSERT INTO benobcv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","এবং আমি নতমস্তকে সদাপ্রভুর আরাধনা করলাম। আমি আমার প্রভু অব্রাহামের ঈশ্বর সেই সদাপ্রভুর প্রশংসা করলাম, যিনি সঠিক পথে আমাকে পরিচালিত করলেন, যেন আমার প্রভুর ছেলের জন্য তাঁর ভাইয়ের নাতনীকে আমি খুঁজে পাই। ");
INSERT INTO benobcv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","এখন আপনারা যদি আমার প্রভুর প্রতি দয়া ও বিশ্বস্ততা দেখাতে চান, তবে বলুন; আর যদি তা না চান, তাও বলুন, যেন আমি জানতে পারি কোন দিকে আমাকে ফিরতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","লাবন ও বথূয়েল উত্তর দিলেন, “সদাপ্রভুর দিক থেকেই এই ঘটনাটি ঘটেছে; এই ব্যাপারে আমরা আপনাকে ভালোমন্দ কিছুই বলতে পারব না। ");
INSERT INTO benobcv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","রিবিকা এখানেই আছে; তাকে নিয়ে চলে যান, আর সে আপনার প্রভুর ছেলের স্ত্রী হয়ে যাক, যেমনটি সদাপ্রভু নির্দেশ দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","তাঁরা যা বললেন, অব্রাহামের দাস যখন তা শুনলেন, তখন তিনি সদাপ্রভুর সামনে মাটিতে উবুড় হয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","পরে সেই দাস সোনা ও রুপোর গয়না এবং বিভিন্ন ধরনের পোশাক-পরিচ্ছদ বের করে সেগুলি রিবিকাকে দিলেন; তিনি তাঁর দাদা ও মাকেও মূল্যবান উপহারসামগ্রী দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","পরে তিনি এবং তাঁর সঙ্গে থাকা লোকজন ভোজনপান করলেন এবং সেখানেই রাত কাটালেন। পরদিন সকালে ওঠার পর তিনি বললেন, “আমার প্রভুর কাছে যাওয়ার জন্য আমায় বিদায় দিন।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","কিন্তু রিবিকার দাদা ও মা উত্তর দিলেন, “মেয়েটি আমাদের কাছে দিন দশেক থাকুক; পরে আপনারা যেতে পারেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","কিন্তু তিনি তাঁদের বললেন, “আমাকে আটকে রাখবেন না, যেহেতু সদাপ্রভু আমার যাত্রা সফল করেছেন। আমাকে বিদায় দিন, যেন আমি আমার প্রভুর কাছে যেতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","তখন তাঁরা বললেন, “মেয়েটিকে ডাকা হোক এবং তাকেই এই বিষয়ে জিজ্ঞাসা করা যাক।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","অতএব তাঁরা রিবিকাকে ডেকে এনে তাঁকে জিজ্ঞাসা করলেন, “তুমি কি এই লোকটির সঙ্গে যাবে?” “আমি যাব,” তিনি বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","অতএব তাঁরা তাঁদের বোন রিবিকাকে ও তাঁর ধাত্রীকে এবং অব্রাহামের দাস ও তাঁর লোকজনকে বিদায় জানালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","আর তাঁরা রিবিকাকে আশীর্বাদ করে তাঁকে বললেন, “হে আমাদের বোন, তুমি বৃদ্ধি পাও হাজার হাজার গুণ; তোমার সন্তানসন্ততি অধিকার করুক তাদের শত্রুদের নগরগুলি।” ");
INSERT INTO benobcv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","পরে রিবিকা ও তাঁর সেবিকারা প্রস্তুত হয়ে উটের পিঠে চড়ে সেই লোকটির সাথে চলে গেলেন। অতএব সেই দাস রিবিকাকে সাথে নিয়ে প্রস্থান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","এদিকে ইস্‌হাক বের-লহয়-রোয়ী থেকে ফিরে আসছিলেন, কারণ তিনি তখন নেগেভে বসবাস করতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","এক সন্ধ্যায় তিনি ধ্যান করতে ক্ষেতে গেলেন, এবং যেই তিনি উপর দিকে তাকালেন, তিনি দেখতে পেলেন কয়েকটি উট এগিয়ে আসছে। ");
INSERT INTO benobcv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","রিবিকাও উপর দিকে তাকালেন এবং ইস্‌হাককে দেখতে পেলেন। তিনি তাঁর উটের পিঠ থেকে নেমে ");
INSERT INTO benobcv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","সেই দাসকে জিজ্ঞাসা করলেন, “ক্ষেত থেকে যিনি আমাদের সাথে দেখা করতে এগিয়ে আসছেন, তিনি কে?” “তিনি আমার প্রভু,” সেই দাস উত্তর দিলেন। অতএব রিবিকা তাঁর ঘোমটা টেনে এনে নিজের মুখ ঢাকলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","পরে সেই দাস নিজে যা যা করেছিলেন সেসব তিনি ইস্‌হাককে বলে শোনালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ইস্‌হাক রিবিকাকে তাঁর মা সারার তাঁবুতে নিয়ে এলেন, এবং তাঁকে বিয়ে করলেন। অতএব রিবিকা তাঁর স্ত্রী হয়ে গেলেন, এবং ইস্‌হাক তাঁকে ভালোবাসলেন; আর ইস্‌হাক তাঁর মায়ের মৃত্যুর পর সান্ত্বনা লাভ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","অব্রাহাম অন্য আর এক স্ত্রীকে বিয়ে করে আনলেন, যাঁর নাম কটুরা। ");
INSERT INTO benobcv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","তাঁর জন্য কটুরা সিম্রণ, যকষণ, মদান, মিদিয়ন, যিষবক ও শূহের জন্ম দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","যক্‌ষণ শিবা এবং দদানের বাবা; অশূরীয়, লটূশীয় ও লিয়ূম্মীয়রা হল দদানের বংশধর। ");
INSERT INTO benobcv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","মিদিয়নের ছেলেরা হল ঐফা, এফর, হনোক, অবীদ ও ইলদায়া। এরা সবাই কটূরার বংশধর। ");
INSERT INTO benobcv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","অব্রাহাম তাঁর অধিকারে থাকা সবকিছু ইস্‌হাককে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","কিন্তু বেঁচে থাকাকালীনই অব্রাহাম তাঁর উপপত্নীদের ছেলেদের উপহারসামগ্রী দিলেন এবং তাঁর ছেলে ইস্‌হাকের কাছ থেকে তাদের দূরে সরিয়ে দিয়ে পূর্বদেশে পাঠিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","অব্রাহাম 175 বছর বেঁচেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","পরে অব্রাহাম শেষনিশ্বাস ত্যাগ করলেন এবং যথেষ্ট বৃদ্ধাবস্থায়, বৃদ্ধ ও পূর্ণায়ূ মানুষরূপে মারা গেলেন; এবং তিনি তাঁর পূর্বপুরুষদের সাথে মিলিত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","তাঁর ছেলে ইস্‌হাক ও ইশ্মায়েল তাঁকে হিত্তীয় সোহরের ছেলে ইফ্রোণের ক্ষেতে অবস্থিত মম্রির নিকটবর্তী মক্‌পেলা গুহাতে কবর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","সেই ক্ষেতটি অব্রাহাম হিত্তীয়দের কাছ থেকে কিনে নিয়েছিলেন। সেখানেই অব্রাহাম ও তাঁর স্ত্রী সারা সমাধিস্থ হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","অব্রাহামের মৃত্যুর পর, ঈশ্বর তাঁর সেই ছেলে ইস্‌হাককে আশীর্বাদ করলেন, যিনি তখন বের-লহয়-রোয়ীর কাছে বসবাস করছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","এই হল অব্রাহামের ছেলে সেই ইশ্মায়েলের বংশবৃত্তান্ত, যাঁকে সারার ক্রীতদাসী, মিশরীয়া হাগার, অব্রাহামের জন্য জন্ম দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","এই হল ইশ্মায়েলের ছেলেদের নাম, যা তাদের জন্মের ক্রমানুসারে নথিভুক্ত করা হয়েছে: ইশ্মায়েলের বড়ো ছেলে নবায়োৎ, পরে কেদর, অদবেল, মিবসম, ");
INSERT INTO benobcv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","মিশমা, দুমা, মসা, ");
INSERT INTO benobcv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","হদদ, তেমা, যিটূর, নাফীশ ও কেদমা। ");
INSERT INTO benobcv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","এরাই ইশ্মায়েলের সন্তান, এবং তাদের উপনিবেশ ও শিবির অনুসারে এই হল বারোজন গোষ্ঠী-শাসকদের নাম। ");
INSERT INTO benobcv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ইশ্মায়েল 137 বছর বেঁচেছিলেন। তিনি শেষনিশ্বাস ত্যাগ করে মারা গেলেন, এবং তাঁর পূর্বপুরুষদের সাথে মিলিত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","তাঁর বংশধরেরা আসিরিয়ার দিকে মিশরের পূর্বসীমার কাছাকাছি অবস্থিত হবীলা থেকে শূর পর্যন্ত বিস্তৃত এলাকায় বসতি স্থাপন করল। তারা তাদের দূর-সম্পর্কের আত্মীয়-গোষ্ঠীদের প্রতি শত্রুতাভাব বজায় রেখে বসবাস করে যাচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","এই হল অব্রাহামের ছেলে ইস্‌হাকের পারিবারিক বংশবৃত্তান্ত। অব্রাহাম ইস্‌হাকের বাবা হলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","এবং ইস্‌হাক চল্লিশ বছর বয়সে সেই রিবিকাকে বিয়ে করলেন, যিনি পদ্দন-আরামের বাসিন্দা অরামীয় বথূয়েলের মেয়ে এবং অরামীয় লাবনের বোন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ইস্‌হাক তাঁর স্ত্রীর হয়ে সদাপ্রভুর কাছে প্রার্থনা করলেন, কারণ রিবিকা নিঃসন্তান ছিলেন। সদাপ্রভু তাঁর প্রার্থনার উত্তর দিলেন, এবং তাঁর স্ত্রী রিবিকা গর্ভবতী হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","শিশুরা রিবিকার গর্ভে একে অপরকে ধাক্কা দিচ্ছিল, এবং তিনি বললেন, “আমার ক্ষেত্রে কেন এমন ঘটছে?” অতএব তিনি সদাপ্রভুর কাছে খোঁজ নিতে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","সদাপ্রভু তাঁকে বললেন, “তোমার গর্ভে দুই জাতি আছে, এবং তোমার মধ্য থেকেই দুই বংশ পৃথক হবে; এক বংশ অন্য বংশ থেকে বেশি শক্তিশালী হবে, এবং বড়ো ছেলে ছোটো ছেলের সেবা করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","সন্তান প্রসবের সময়কাল ঘনিয়ে এলে দেখা গেল তাঁর গর্ভে যমজ সন্তান। ");
INSERT INTO benobcv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","প্রথমে যে ভূমিষ্ঠ হল, তার গায়ের রং ছিল লাল, এবং তার সারা শরীর ছিল লোমশ পোশাকের মতো; তাই তাঁরা তার নাম দিলেন এষৌ। ");
INSERT INTO benobcv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","পরে, তার সেই ভাই বেরিয়ে এল, যার হাত এষৌর গোড়ালি ধরে রেখেছিল; তাই তার নাম দেওয়া হল যাকোব। রিবিকা যখন তাদের জন্ম দেন তখন ইস্‌হাকের বয়স 60 বছর। ");
INSERT INTO benobcv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ছেলেরা বেড়ে উঠেছিল, এবং এষৌ এমন এক নিপুণ শিকারি হয়ে উঠছিল, যিনি বাড়ির বাইরে ঘুরে বেড়াতেন, অন্যদিকে যাকোব ঘরের ভিতরে তাঁবুর মধ্যেই থাকতে পছন্দ করতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","যিনি শিকার করা পশুর মাংস খেতে পছন্দ করতেন, সেই ইস্‌হাক এষৌকে ভালোবাসতেন, কিন্তু রিবিকা যাকোবকে ভালোবাসতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","একবার যাকোব যখন খানিকটা ঝোল-তরকারী রান্না করছিলেন, এষৌ তখন মাঠ থেকে ক্ষুধার্ত অবস্থায় ফিরে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","তিনি যাকোবকে বললেন, “তাড়াতাড়ি আমাকে লাল রংয়ের ওই ঝোল-তরকারী থেকে কিছুটা খেতে দাও! আমি ক্ষুধার্ত!” (এই জন্য তাঁকে ইদোম নামেও ডাকা হয়।) ");
INSERT INTO benobcv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","যাকোব উত্তর দিলেন, “প্রথমে তুমি আমার কাছে তোমার জ্যেষ্ঠাধিকার বিক্রি করো।” ");
INSERT INTO benobcv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","দেখো, আমি প্রায় মরতে চলেছি, “এষৌ বললেন। জ্যেষ্ঠাধিকার আমার কী কাজে লাগবে?” ");
INSERT INTO benobcv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","কিন্তু যাকোব বললেন, “প্রথমে আমার কাছে শপথ করো।” অতএব এষৌ তাঁর কাছে শপথ করলেন, তাঁর জ্যেষ্ঠাধিকার যাকোবের কাছে বিক্রি করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","পরে যাকোব এষৌকে কয়েকটি রুটি ও মশুরি দিয়ে তৈরি কিছুটা ঝোল-তরকারী দিলেন। তিনি ভোজনপান করলেন, ও পরে উঠে চলে গেলেন। অতএব এষৌ তাঁর জ্যেষ্ঠাধিকার হেয় জ্ঞান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","এদিকে দেশে এক দুর্ভিক্ষ হল—যা অব্রাহামের সময়কালে হওয়া সাবেক দুর্ভিক্ষের অতিরিক্ত—এবং ইস্‌হাক গরারে ফিলিস্তিনীদের রাজা অবীমেলকের কাছে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","সদাপ্রভু ইস্‌হাককে দর্শন দিয়ে বললেন, “তুমি মিশরে যেয়ো না; সেই দেশেই বসবাস করো, যেখানে আমি তোমাকে বসবাস করতে বলছি। ");
INSERT INTO benobcv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","এদেশেই কিছুকাল থেকে যাও, আর আমি তোমার সহবর্তী হব ও তোমাকে আশীর্বাদ করব। কারণ তোমাকে ও তোমার বংশধরদের আমি এইসব দেশ দেব এবং তোমার বাবা অব্রাহামের কাছে করা আমার সেই শপথ বলবৎ করব। ");
INSERT INTO benobcv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","আমি তোমার বংশধরদের সংখ্যা আকাশের তারাগুলির মতো বিপুল সংখ্যক করব এবং তাদের এইসব দেশ দেব, এবং তোমার সন্তানসন্ততির মাধ্যমে পৃথিবীর সব জাতি আশীর্বাদ লাভ করবে, ");
INSERT INTO benobcv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","কারণ অব্রাহাম আমার বাধ্য হয়েছিল এবং আমার আদেশ, আমার হুকুম ও আমার নির্দেশনা পালনের ক্ষেত্রে আমি তার কাছে যা কিছু চেয়েছিলাম, সে সবকিছু করেছিল।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","অতএব ইস্‌হাক গরারেই থেকে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","সেখানকার লোকজন যখন তাঁকে তাঁর স্ত্রীর বিষয়ে জিজ্ঞাসা করল, তখন তিনি বললেন, “সে আমার বোন,” কারণ “সে আমার স্ত্রী” একথা বলতে তাঁর ভয় হল। তিনি ভাবলেন, “এখানকার লোকজন রিবিকার জন্য আমাকে হয়তো মেরে ফেলবে, কারণ সে সুন্দরী।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","বেশ কিছুকাল ইস্‌হাক সেখানে থেকে যাওয়ার পর, ফিলিস্তিনীদের রাজা অবীমেলক জানালা থেকে নিচে তাকালেন এবং দেখতে পেলেন যে ইস্‌হাক তাঁর স্ত্রী রিবিকাকে আদর-সোহাগ করছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","অতএব অবীমেলক ইস্‌হাককে ডেকে পাঠিয়ে বললেন, “উনি সত্যিই আপনার স্ত্রী! আপনি কেন তবে বললেন, ‘সে আমার বোন’?” ইস্‌হাক তাঁকে উত্তর দিলেন, “কারণ আমি ভেবেছিলাম, তার জন্য আমাকে হয়তো প্রাণ হারাতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","তখন অবীমেলক বললেন, “আপনি আমাদের প্রতি এ কী ব্যবহার করলেন? যে কোনো লোক অনায়াসে আপনার স্ত্রীর সঙ্গে শুয়ে পড়তে পারত, আর আপনি আমাদের উপর দোষ চাপিয়ে দিতেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","অতএব অবীমেলক প্রজাদের সবাইকে আদেশ দিলেন: “যে কোনো লোক এই লোকটির বা তাঁর স্ত্রীর ক্ষতিসাধন করবে, তার অবশ্যই প্রাণদণ্ড হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ইস্‌হাক সেই দেশে চাষাবাদ করলেন এবং সেবছর একশো গুণ ফসল পেলেন, কারণ সদাপ্রভু তাঁকে আশীর্বাদ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","তিনি ধনী হয়ে গেলেন এবং যতদিন না তিনি অত্যন্ত ধনী হতে পেরেছিলেন, তাঁর ধনসম্পদ ক্রমাগত বেড়েই যাচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","তাঁর এত মেষপাল ও গবাদি পশুপাল এবং দাস-দাসী হল যে ফিলিস্তিনীরা তাঁকে হিংসা করতে লাগল। ");
INSERT INTO benobcv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","অতএব তাঁর বাবা অব্রাহামের সময় তাঁর বাবার দাসেরা যে কুয়োগুলি খুঁড়েছিল, ফিলিস্তিনীরা মাটি ফেলে সেগুলি ভরাট করে দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","তখন অবীমেলক ইস্‌হাককে বললেন, “আমাদের কাছ থেকে দূরে সরে যান; আমাদের তুলনায় আপনি খুব বেশি শক্তিশালী হয়ে উঠেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","অতএব ইস্‌হাক সেখান থেকে দূরে সরে গিয়ে গরার উপত্যকায় শিবির স্থাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","তাঁর বাবা অব্রাহামের সময় যে কুয়োগুলি খোঁড়া হয়েছিল, ও অব্রাহামের মৃত্যুর পর যেগুলি ফিলিস্তিনীরা ভরাট করে দিয়েছিল, ইস্‌হাক আর একবার সেগুলি খুঁড়িয়েছিলেন, এবং তাঁর বাবা সেগুলির যে যে নাম দিয়েছিলেন, তিনিও সেগুলির সেই সেই নাম বজায় রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ইস্‌হাকের দাসেরা সেই উপত্যকায় মাটি খুঁড়ে সেখানে টাটকা জলের একটি কুয়ো খুঁজে পেয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","কিন্তু গরারের রাখালেরা ইস্‌হাকের রাখালদের সঙ্গে ঝগড়া করে বলল, “এই জল আমাদের!” তাই তিনি সেই কুয়োর নাম দিলেন এষক, কারণ তারা তাঁর সাথে সংঘাতে জড়িয়ে পড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","পরে তারা আরও একটি কুয়ো খুঁড়েছিল, কিন্তু তারা সেটির জন্যও ঝগড়া করল; তাই তিনি সেটির নাম দিলেন সিটনা। ");
INSERT INTO benobcv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","সেখান থেকে দূরে সরে গিয়ে তিনি আরও একটি কুয়ো খোঁড়ালেন, এবং সেটির জন্য কেউই ঝগড়া করেনি। এই বলে তিনি সেটির নাম দিলেন রহোবোৎ, যে “সদাপ্রভু এখন আমাদের স্থান করে দিয়েছেন এবং আমরা এই দেশে সমৃদ্ধিলাভ করব।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","সেখান থেকে তিনি বের-শেবার দিকে উঠে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","সেরাতে সদাপ্রভু তাঁকে দর্শন দিয়ে বললেন, “আমি তোমার বাবা অব্রাহামের ঈশ্বর। ভয় কোরো না, কারণ আমি তোমার সাথে আছি; আমি তোমাকে আশীর্বাদ করব এবং আমার দাস অব্রাহামের খাতিরে আমি তোমার বংশধরদের সংখ্যা বৃদ্ধি করব।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ইস্‌হাক সেখানে একটি যজ্ঞবেদি নির্মাণ করলেন এবং সদাপ্রভুর আরাধনা করলেন। সেখানে তিনি তাঁবু খাটালেন, এবং সেখানে তাঁর দাসেরা একটি কুয়ো খুঁড়ল। ");
INSERT INTO benobcv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ইত্যবসরে, অবীমেলক গরার থেকে তাঁর কাছে আসলেন, ও তাঁর সঙ্গে ছিলেন তাঁর ব্যক্তিগত পরামর্শদাতা অহূষৎ ও তাঁর সেনাবাহিনীর সেনাপতি ফীকোল। ");
INSERT INTO benobcv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ইস্‌হাক তাঁদের জিজ্ঞাসা করলেন, “আপনারা কেন আমার কাছে এসেছেন, যেহেতু আপনারা তো আমার প্রতি শত্রুভাবাপন্ন ছিলেন এবং আমাকে দূরে পাঠিয়ে দিয়েছিলেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","তাঁরা উত্তর দিলেন, “আমরা স্পষ্টই দেখেছি যে, সদাপ্রভু আপনার সাথে ছিলেন; তাই আমরা বলছি, ‘আমাদের মধ্যে এক শপথ-চুক্তি হওয়া উচিত—আমাদের এবং আপনার মধ্যে।’ আসুন, আপনার সঙ্গে আমরা এমন এক সন্ধি করি ");
INSERT INTO benobcv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","যে আপনি আমাদের কোনও ক্ষতি করবেন না, ঠিক যেভাবে আমরা আপনার ক্ষতি করিনি, কিন্তু সবসময় আপনার সাথে ভালো ব্যবহার করেছি এবং শান্তিপূর্বক আপনাকে বিদায় দিয়েছিলাম। আর এখন আপনি সদাপ্রভুর আশীর্বাদধন্য হয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ইস্‌হাক তখন তাঁদের জন্য এক ভোজসভার আয়োজন করলেন, এবং তাঁরা ভোজনপান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","পরদিন ভোরবেলায় তাঁরা পরস্পরের উদ্দেশে শপথ করলেন। পরে ইস্‌হাক তাঁদের বিদায় দিলেন, এবং তাঁরাও শান্তিপূর্বক প্রস্থান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","সেইদিনই ইস্‌হাকের দাসেরা তাঁর কাছে এসে যে কুয়োটি তারা খুঁড়েছিল, সেটির কথা তাঁকে বলে শুনিয়েছিল। তারা বলল, “আমরা জল পেয়েছি!” ");
INSERT INTO benobcv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","তিনি সেটির নাম দিলেন শেবা, আর আজও পর্যন্ত সেই নগরটি বের-শেবা নামাঙ্কিত হয়ে আছে। ");
INSERT INTO benobcv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","এষৌর বয়স যখন চল্লিশ বছর, তখন তিনি হিত্তীয় বেরির মেয়ে যিহূদীৎকে, এবং হিত্তীয় এলোনের মেয়ে বাসমৎকেও বিয়ে করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ইস্‌হাক ও রিবিকার কাছে তারা মর্মযন্ত্রণার উৎস হল। ");
INSERT INTO benobcv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ইস্‌হাক যখন বৃদ্ধ হয়ে পড়েছিলেন ও তাঁর চোখদুটি যখন এত দুর্বল হয়ে পড়েছিল যে তিনি আর দেখতেই পারতেন না, তখন তিনি তাঁর বড়ো ছেলে এষৌকে ডেকে তাঁকে বললেন, “বাছা।” “এই তো আমি এখানে,” এষৌ উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ইস্‌হাক বললেন, “আমি এখন বৃদ্ধ হয়ে গিয়েছি আর এও জানি না কবে আমার মৃত্যু হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","তাই এখন, তোমার সাজসরঞ্জাম—তোমার তূণীর ও ধনুক হাতে তুলে নাও—এবং মরুপ্রান্তরে গিয়ে আমার জন্য পশু শিকার করে আনো। ");
INSERT INTO benobcv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","আমি যে ধরনের সুস্বাদু খাবার পছন্দ করি, সেরকম পদ রান্না করে আমার কাছে নিয়ে এসো, আমি তা খাব; যেন মারা যাওয়ার আগে আমি আমার আশীর্বাদ তোমাকে দিয়ে যেতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ইস্‌হাক যখন এষৌর সাথে কথা বলছিলেন তখন রিবিকা তা শুনে ফেলেছিলেন। এষৌ যখন শিকার করে আনার জন্য মরুপ্রান্তরের উদ্দেশে বেড়িয়ে পড়লেন, ");
INSERT INTO benobcv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","তখন রিবিকা তাঁর ছেলে যাকোবকে বললেন, “দেখো, আমি আড়ি পেতে শুনে ফেলেছি, তোমার বাবা তোমার দাদা এষৌকে বলেছেন, ");
INSERT INTO benobcv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘আমার কাছে শিকার করা পশুর মাংস নিয়ে এসো এবং আমার জন্য সুস্বাদু খাবার রান্না করো, যেন মারা যাওয়ার আগে সদাপ্রভুর উপস্থিতিতে আমি তোমায় আশীর্বাদ দিয়ে যেতে পারি।’ ");
INSERT INTO benobcv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","এখন বাছা, আমি তোমাকে যা বলছি তা ভালো করে শোনো এবং আমি যা বলছি, তাই করো: ");
INSERT INTO benobcv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","পশুপালের কাছে চলে যাও এবং বাছাই করা দুটি কচি পাঁঠা নিয়ে এসো, যেন আমি তোমার বাবার জন্য সুস্বাদু খাবার রান্না করে দিতে পারি, ঠিক যেমনটি তিনি পছন্দ করেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","পরে তুমি তা নিয়ে গিয়ে তোমার বাবাকে খেতে দিয়ো, যেন মারা যাওয়ার আগে তিনি তোমাকে তাঁর আশীর্বাদ দিয়ে যেতে পারেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","যাকোব তাঁর মা রিবিকাকে বললেন, “কিন্তু আমার দাদা এষৌ যে এক লোমশ মানুষ, অথচ আমার ত্বক তো মসৃণ। ");
INSERT INTO benobcv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","আমার বাবা যদি আমাকে স্পর্শ করেন তবে কী হবে? আমি যে তাঁর সাথে ছলচাতুরি করছি তা প্রমাণ হয়ে যাবে এবং আমার উপর আশীর্বাদের পরিবর্তে অভিশাপ নেমে আসবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","তাঁর মা তাঁকে বললেন, “বাছা, সেই অভিশাপ আমার উপরেই নেমে আসুক। আমি যা বলছি তুমি শুধু তাই করো; যাও ও আমার জন্য সেগুলি নিয়ে এসো।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","অতএব তিনি চলে গেলেন ও সেগুলি সংগ্রহ করে তাঁর মায়ের কাছে নিয়ে এলেন, এবং তাঁর বাবা যেমনটি পছন্দ করতেন, রিবিকা ঠিক তেমনই সুস্বাদু খাবার রান্না করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","পরে রিবিকা তাঁর বড়ো ছেলে এষৌর সবচেয়ে ভালো সেই পোশাকগুলি বের করলেন, যা সেই বাড়িতেই রাখা ছিল, এবং সেগুলি তাঁর ছোটো ছেলে যাকোবের গায়ে পরিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","তিনি যাকোবের দুটি হাত ও ঘাড়ের মসৃণ অংশগুলি ছাগচর্ম দিয়ে আচ্ছাদিত করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","পরে তিনি তাঁর ছেলে যাকোবের হাতে তাঁর নিজের হাতে তৈরি করা সেই সুস্বাদু খাবার ও রুটি তুলে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","যাকোব তাঁর বাবার কাছে গিয়ে বললেন, “বাবা।” “হ্যাঁ বাছা,” তিনি উত্তর দিলেন, “তুমি কে?” ");
INSERT INTO benobcv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","যাকোব তাঁর বাবাকে বললেন, “আমি আপনার বড়ো ছেলে এষৌ। আপনি আমায় যা বলেছিলেন, আমি তাই করেছি। দয়া করে উঠে বসুন এবং আমার শিকার করা পশুর মাংসের খানিকটা অংশ খান, যেন আপনি আমাকে আপনার আশীর্বাদ দিতে পারেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ইস্‌হাক তাঁর ছেলেকে জিজ্ঞাসা করলেন, “বাছা, এত তাড়াতাড়ি তুমি কীভাবে তা খুঁজে পেলে?” “আপনার ঈশ্বর সদাপ্রভু আমাকে সফলতা দিয়েছেন,” তিনি উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","তখন ইস্‌হাক যাকোবকে বললেন, “বাছা, আমার কাছে এসো, যেন আমি তোমাকে স্পর্শ করে বুঝতে পারি তুমি সত্যিই আমার ছেলে এষৌ কি না।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","যাকোব তাঁর বাবা ইস্‌হাকের কাছে গেলেন, ও তিনি যাকোবকে স্পর্শ করে বললেন, “কণ্ঠস্বর তো যাকোবের কণ্ঠস্বরের মতো, কিন্তু হাত দুটি এষৌর হাতের মতো।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","তিনি যাকোবকে চিনতে পারেননি, কারণ তাঁর হাত দুটি তাঁর দাদা এষৌর হাতের মতোই লোমশ ছিল; তাই তিনি তাঁকে আশীর্বাদ করার জন্য এগিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“তুমি কি সত্যিই আমার ছেলে এষৌ?” তিনি জিজ্ঞাসা করলেন। “হ্যাঁ,” যাকোব উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","তখন তিনি বললেন, “বাছা, শিকার করা পশুর মাংস খাওয়ার জন্য খানিকটা আমার কাছে নিয়ে এসো, যেন আমি তোমাকে আমার আশীর্বাদ দিতে পারি।” যাকোব তাঁর কাছে তা নিয়ে এলেন ও তিনি তা খেলেন; এবং যাকোব তাঁকে কিছুটা দ্রাক্ষারসও এনে দিলেন ও তিনি তা পান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","তখন তাঁর বাবা ইস্‌হাক তাঁকে বললেন, “বাছা, এখানে এসো, ও আমাকে চুমু দাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","অতএব যাকোব তাঁর কাছে গিয়ে তাঁকে চুমু দিলেন। ইস্‌হাক যখন তাঁর পোশাকের গন্ধ শুঁকলেন, তখন তিনি তাঁকে আশীর্বাদ করে বললেন, “আহা, আমার ছেলের সুগন্ধ তা যেন এমন এক ক্ষেতের সুগন্ধ যা সদাপ্রভুর আশীর্বাদধন্য। ");
INSERT INTO benobcv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ঈশ্বর তোমাকে আকাশের শিশির আর ভূমির প্রাচুর্য— শস্যপ্রাচুর্য ও নতুন দ্রাক্ষারস দান করুন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","জাতিরা তোমার সেবা করুক এবং মানুষজন তোমার কাছে মাথা নত করুক। তোমার ভাইদের উপর তুমি প্রভুত্ব করো, আর তোমার মায়ের ছেলেরা তোমার কাছে মাথা নত করুক। যারা তোমাকে অভিশাপ দেয় তারা শাপগ্রস্ত হোক আর যারা তোমাকে আশীর্বাদ দেয় তারা আশীর্বাদধন্য হোক।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ইস্‌হাক যাকোবকে আশীর্বাদ করার পর, ও তিনি তাঁর বাবার কাছ থেকে প্রস্থান করতে না করতেই, তাঁর দাদা এষৌ শিকার করে ফিরে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","তিনিও খানিকটা সুস্বাদু খাবার রান্না করে সেটি তাঁর বাবার কাছে আনলেন। পরে তিনি তাঁকে বললেন, “বাবা, দয়া করে উঠে বসুন ও আমার শিকার করা পশুর মাংসের তরকারি খানিকটা খেয়ে নিন, যেন আপনি আমাকে আপনার আশীর্বাদ দিতে পারেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","তাঁর বাবা ইস্‌হাক তাঁকে জিজ্ঞাসা করলেন, “তুমি কে?” “আমি তো আপনার ছেলে,” তিনি উত্তর দিলেন, “আপনার বড়ো ছেলে এষৌ।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ইস্‌হাক প্রবলভাবে কাঁপতে কাঁপতে বললেন, “তবে, সে কে ছিল, যে পশু শিকার করেছিল ও আমার কাছে তা নিয়ে এসেছিল? তুমি আসার খানিকক্ষণ আগেই আমি তা খেয়ে ফেলেছি ও তাকে আশীর্বাদ দিয়েছি—আর সে অবশ্যই আশীর্বাদধন্য হবে!” ");
INSERT INTO benobcv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","তাঁর বাবার কথা শুনে এষৌ জোর গলায় চিৎকার করে কাঁদতে শুরু করলেন এবং তাঁর বাবাকে বললেন, “বাবা, আমাকে—আমাকেও আশীর্বাদ করুন!” ");
INSERT INTO benobcv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","কিন্তু তিনি বললেন, “তোমার ভাই ছলনা করে এসেছিল ও তোমার আশীর্বাদ আত্মসাৎ করে নিয়ে গিয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","এষৌ বললেন, “তার নাম যাকোব রাখাই কি উচিত হয়নি? সে এই দ্বিতীয়বার আমার সাথে প্রতারণা করল: সে আমার জ্যেষ্ঠাধিকার আত্মসাৎ করেছিল আর এখন সে আমার আশীর্বাদও আত্মসাৎ করে নিল!” পরে তিনি জিজ্ঞাসা করলেন, “আমার জন্য আর কোনও আশীর্বাদ কি আপনি রাখেননি?” ");
INSERT INTO benobcv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ইস্‌হাক এষৌকে উত্তর দিলেন, “তোমার উপর আমি তাকে প্রভু করে দিয়েছি ও তার সব আত্মীয়স্বজনকে আমি তার দাস করে দিয়েছি, এবং খাদ্যশস্য ও নতুন দ্রাক্ষারস দিয়ে আমি তাকে সবল করেছি। তাই, বাছা, তোমার জন্য এখন আমি আর কী করতে পারি?” ");
INSERT INTO benobcv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","এষৌ তাঁর বাবাকে বললেন, “বাবা, আপনার কাছে কি শুধু একটিই আশীর্বাদ আছে? বাবা, আমাকেও আশীর্বাদ করুন না!” পরে এষৌ জোর গলায় কেঁদে ফেলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","তাঁর বাবা ইস্‌হাক তাঁকে উত্তর দিলেন, “তোমার বাসস্থান হবে ভূমির প্রাচুর্য থেকে দূরবর্তী, ঊর্ধ্বস্থ আকাশের শিশির থেকে দূরবর্তী। ");
INSERT INTO benobcv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","তরোয়ালের সাহায্যেই তুমি বেঁচে থাকবে আর তুমি তোমার ভাইয়ের সেবা করবে। কিন্তু তুমি যখন অস্থির হয়ে পড়বে, তখন তোমার কাঁধ থেকে তুমি তার জোয়াল ঝেড়ে ফেলবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","যাকোবের বিরুদ্ধে এষৌ মনে আক্রোশ পুষে রাখলেন, কারণ তাঁর বাবা যাকোবকে আশীর্বাদ দিয়েছিলেন। তিনি মনে মনে বললেন, “আমার বাবার জন্য শোকপ্রকাশের সময় আসন্ন; তারপরেই আমি আমার ভাই যাকোবকে হত্যা করব।” ");
INSERT INTO benobcv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","রিবিকার বড়ো ছেলে কী বলেছেন, তা যখন তাঁকে বলা হল, তখন রিবিকা লোক পাঠিয়ে তাঁর ছোটো ছেলে যাকোবকে ডেকে পাঠালেন ও তাঁকে বললেন, “তোমার দাদা এষৌ তোমাকে হত্যা করে প্রতিশোধ নেওয়ার পরিকল্পনা করছে। ");
INSERT INTO benobcv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","এখন তবে, বাছা, আমি যা বলছি তুমি তাই করো: এখনই তুমি হারণে আমার দাদা লাবনের কাছে পালিয়ে যাও। ");
INSERT INTO benobcv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","সেখানে অল্প কিছুদিন তাঁর কাছে গিয়ে থাকো, যতদিন না তোমার দাদার রাগ কমছে। ");
INSERT INTO benobcv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","যখন তোমার উপর তোমার দাদার রাগ শান্ত হয়ে যাবে ও তুমি যা যা করেছ, সে যখন সেসব কথা ভুলে যাবে, তখন আমি সেখান থেকে ফিরে আসার জন্য তোমাকে খবর পাঠাব। একই দিনে কেন আমি তোমাদের দুজনকেই হারাব?” ");
INSERT INTO benobcv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","পরে রিবিকা ইস্‌হাককে বললেন, “এই হিত্তীয় মেয়েদের সাথে বসবাস করতে করতে আমি বিতৃষ্ণ হয়ে পড়েছি। এদের মতো যাকোবও যদি এই দেশের মেয়েদের মধ্যে থেকে, অর্থাৎ হিত্তীয় মেয়েদের মধ্যে থেকে কাউকে তার স্ত্রী করে আনে, তবে আমার বেঁচে থাকাই অর্থহীন হয়ে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","অতএব ইস্‌হাক যাকোবকে ডেকে পাঠালেন ও তাঁকে আশীর্বাদ করলেন। পরে তিনি তাঁকে আদেশ দিলেন: “কনানীয় কোনো মেয়েকে তুমি বিয়ে কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","এখনই তুমি পদ্দন-আরামে, তোমার দাদু বথূয়েলের বাড়িতে যাও। সেখান থেকেই, তোমার মামা লাবনের মেয়েদের মধ্যে থেকেই কাউকে তোমার স্ত্রীরূপে গ্রহণ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","সর্বশক্তিমান ঈশ্বর তোমাকে আশীর্বাদ করুন ও তোমাকে ফলবান করুন এবং যতদিন না তুমি এক জনসমাজ হয়ে উঠছ, ততদিন তোমার সংখ্যা বৃদ্ধি করে যান। ");
INSERT INTO benobcv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","অব্রাহামকে যে আশীর্বাদ দেওয়া হয়েছিল, তিনি যেন তোমাকে ও তোমার বংশধরদের সেই আশীর্বাদই দেন, যার বলে তুমি সেই দেশের দখল নিতে পারো, যেখানে এখন তুমি এক বিদেশিরূপে বসবাস করছ, তা সেই দেশ, যেটি ঈশ্বর অব্রাহামকে দিয়েছিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","পরে ইস্‌হাক যাকোবকে বিদায় করে দিলেন, এবং তিনি পদ্দন-আরামে, অরামীয় বথূয়েলের ছেলে সেই লাবনের কাছে গেলেন, যিনি সেই রিবিকার দাদা, যিনি যাকোব ও এষৌর মা। ");
INSERT INTO benobcv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","এদিকে এষৌ জানতে পারলেন যে ইস্‌হাক যাকোবকে আশীর্বাদ করে পদ্দন-আরাম থেকে এক স্ত্রী আনার জন্য তাঁকে সেখানে পাঠিয়েছেন, এবং আশীর্বাদ দেওয়ার সময় তিনি তাঁকে এই আদেশও দিয়েছেন, “কনানীয় কোনো মেয়েকে বিয়ে কোরো না,” ");
INSERT INTO benobcv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","এবং যাকোবও তাঁর বাবা-মায়ের আদেশ পালন করে পদ্দন-আরামে চলে গিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","এষৌ তখন অনুভব করলেন কনানীয় মেয়েরা তাঁর বাবা ইস্‌হাকের কাছে কত অপছন্দসই; ");
INSERT INTO benobcv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","তাই তাঁর একাধিক স্ত্রী থাকা সত্ত্বেও তিনি ইশ্মায়েলের কাছে গেলেন এবং সেই মহলৎকে বিয়ে করলেন, যিনি অব্রাহামের ছেলে ইশ্মায়েলের মেয়ে নবায়োতের বোন। ");
INSERT INTO benobcv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","যাকোব বের-শেবা ত্যাগ করে হারণের দিকে যাত্রা শুরু করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","নির্দিষ্ট এক স্থানে পৌঁছে, তিনি রাত্রিবাসের জন্য থামলেন, কারণ সূর্যাস্ত হয়ে গিয়েছিল। সেখানকার একটি পাথর নিয়ে, সেটি তিনি তাঁর মাথার নিচে রেখে ঘুমিয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","তিনি একটি স্বপ্ন দেখলেন এবং সেই স্বপ্নে তিনি দেখলেন যে একটি সিঁড়ি পৃথিবীর উপর দাঁড়িয়ে আছে, ও সেটির মাথা আকাশ ছুঁয়েছে, এবং ঈশ্বরের দূতেরা সেটির উপর দিয়ে ওঠানামা করছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","সেটির মাথায় সদাপ্রভু দাঁড়িয়েছিলেন, এবং তিনি বললেন: “আমি সেই সদাপ্রভু, তোমার পূর্বপুরুষ অব্রাহামের ঈশ্বর ও ইস্‌হাকের ঈশ্বর। তুমি যে জমিতে শুয়ে আছ সেটি আমি তোমাকে ও তোমার বংশধরদের দেব। ");
INSERT INTO benobcv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","তোমার বংশধরেরা পৃথিবীর ধূলিকণার মতো হয়ে যাবে, এবং তুমি পশ্চিমে ও পূর্বে, উত্তরে ও দক্ষিণে ছড়িয়ে পড়বে। তোমার ও তোমার সন্তানসন্ততির মাধ্যমেই পৃথিবীর সব লোকজন আশীর্বাদধন্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","আমি তোমার সাথেই আছি ও তুমি যেখানেই যাও না কেন, আমি তোমার উপর নজর রাখব, এবং তোমাকে এই দেশেই ফিরিয়ে আনব। যতদিন না আমি তোমার কাছে আমার করা প্রতিজ্ঞাটি পূরণ করছি, ততদিন আমি তোমাকে ত্যাগ করব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ঘুম ভেঙে জেগে ওঠার পর, যাকোব ভাবলেন, “সদাপ্রভু নিশ্চয় এখানে আছেন, এবং আমি তা বুঝতে পারিনি।” ");
INSERT INTO benobcv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","তিনি ভয় পেয়ে গিয়ে বললেন, “এই স্থানটি কি ভয়ংকর! এটি ঈশ্বরের গৃহ ছাড়া আর অন্য কিছু নয়; এটিই স্বর্গদ্বার।” ");
INSERT INTO benobcv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","পরদিন ভোরবেলায় যাকোব তাঁর মাথার নিচে রাখা পাথরটি নিয়ে সেটি এক স্তম্ভরূপে স্থাপন করলেন এবং সেটির উপর তেল ঢেলে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","তিনি সেই স্থানটির নাম বেথেল রাখলেন, যদিও সেই নগরটিকে আগে লূস নামে ডাকা হত। ");
INSERT INTO benobcv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","পরে যাকোব এই বলে এক শপথ নিলেন যে, “আমার এই যাত্রাপথে ঈশ্বর যদি আমার সাথে থাকেন ও আমার উপর নজর রাখেন এবং আমাকে খাওয়ার জন্য খাদ্য ও গায়ে পরার জন্য বস্ত্র জোগান, ");
INSERT INTO benobcv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","যেন আমি আমার বাবার ঘরে নিরাপদে ফিরে যেতে পারি, তবে সদাপ্রভু আমার ঈশ্বর হবেন ");
INSERT INTO benobcv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","এবং এই যে পাথরটি আমি স্তম্ভরূপে স্থাপন করেছি, সেটিই ঈশ্বরের গৃহ হবে, এবং তুমি আমাকে যা কিছু দেবে, আমি অবশ্যই তোমাকে তার দশমাংশ দেব।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","পরে যাকোব তাঁর যাত্রাপথে এগিয়ে গেলেন এবং প্রাচ্যদেশীয় লোকদের দেশে পৌঁছালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","সেখানে খোলা মাঠের মধ্যে তিনি একটি কুয়ো দেখতে পেলেন, যার কাছে মেষের তিনটি পাল শুয়েছিল, কারণ সেই কুয়ো থেকে পালগুলিকে জলপান করানো হত। কুয়োর মুখের উপর রাখা পাথরটি খুব বড়ো ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","সবকটি পাল যখন সেখানে একত্রিত হত, তখন মেষপালকেরা কুয়োর মুখ থেকে সেই পাথরটি সরিয়ে মেষদের জলপান করাতো। পরে তারা আবার কুয়োর মুখে যথাস্থানে পাথরটি বসিয়ে দিত। ");
INSERT INTO benobcv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","যাকোব মেষপালকদের জিজ্ঞাসা করলেন, “হে আমার ভাইসকল, তোমরা কোথাকার লোক?” “আমরা হারণের অধিবাসী,” তারা উত্তর দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","তিনি তাদের বললেন, “তোমরা কি সেই লাবনকে চেন, যিনি নাহোরের নাতি?” “হ্যাঁ, আমরা তাঁকে চিনি,” তারা উত্তর দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","তখন যাকোব জিজ্ঞাসা করলেন, “তিনি ভালো আছেন তো?” “হ্যাঁ, তিনি ভালো আছেন,” তারা বলল, “আর দেখুন, তাঁর মেয়ে রাহেল মেষপাল নিয়ে এদিকেই আসছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“দেখো,” তিনি বললেন, “সূর্য এখনও মাথার উপরেই আছে; পালগুলি একত্রিত করার সময় এখনও হয়নি। মেষদের জলপান করিয়ে তাদের আবার চরাতে নিয়ে যাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“আমরা তা পারবো না,” তারা উত্তর দিল, “আগে সব পাল একসঙ্গে একত্রিত হোক এবং কুয়োর মুখ থেকে পাথরটি সরানো হোক। পরে আমরা মেষদের জলপান করাব।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","তিনি তখনও তাদের সঙ্গে কথা বলছেন, ইতিমধ্যে রাহেল তাঁর বাবার মেষপাল নিয়ে উপস্থিত হলেন, কারণ তিনি এক মেষপালিকা ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","যাকোব যখন তাঁর মামা লাবনের মেয়ে রাহেলকে, ও লাবনের মেষদের দেখতে পেলেন, তখন তিনি এগিয়ে গিয়ে কুয়োর মুখ থেকে পাথরটি সরিয়ে দিলেন ও তাঁর মামার মেষদের জলপান করালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","পরে যাকোব রাহেলকে চুমু দিলেন এবং জোর গলায় কাঁদতে শুরু করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","তিনি রাহেলকে বলে দিয়েছিলেন যে তিনি রাহেলের বাবার এক আত্মীয় ও রিবিকার এক ছেলে। তাই রাহেল দৌড়ে গিয়ে তাঁর বাবাকে সেকথা জানালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","যে মুহূর্তে লাবন তাঁর বোনের ছেলে যাকোবের খবর পেলেন, তিনি তাড়াতাড়ি তাঁর সঙ্গে দেখা করতে গেলেন। তিনি তাঁকে জড়িয়ে ধরলেন ও তাঁকে চুমু দিলেন এবং তাঁকে নিজের ঘরে নিয়ে এলেন, ও যাকোব সেখানে তাঁকে সবকিছু বলে শোনালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","তখন লাবন তাঁকে বললেন, “তুমি আমার আপন রক্তমাংসের আত্মীয়।” যাকোব সম্পূর্ণ এক মাস লাবনের সঙ্গে থাকার পর, ");
INSERT INTO benobcv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","লাবন যাকোবকে বললেন, “তুমি আমার এক আত্মীয় বলে কি কিছু না নিয়েই আমার জন্য কাজ করবে? তোমার বেতন কত হওয়া উচিত তা তুমিই বলে দাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","লাবনের দুই মেয়ে ছিল; বড়টির নাম লেয়া ও ছোটোটির নাম রাহেল। ");
INSERT INTO benobcv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","লেয়ার চোখদুটি দুর্বল ছিল, কিন্তু রাহেল স্বাস্থ্যবতী ও সুন্দরী ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","যাকোব রাহেলের প্রেমে পড়ে গেলেন এবং তিনি বললেন, “আপনার ছোটো মেয়ে রাহেলের জন্য আমি সাত বছর আপনার কাছে কাজ করব।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","লাবন বললেন, “তাকে অন্য কোনও পুরুষের হাতে তুলে দেওয়ার পরিবর্তে বরং তোমাকে দেওয়াই ভালো। আমার সঙ্গে তুমি এখানেই থাকো।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","অতএব যাকোব রাহেলকে পাওয়ার জন্য সাত বছর দাসত্ব করলেন, কিন্তু যেহেতু তিনি রাহেলকে ভালোবেসেছিলেন তাই এতগুলি বছর তাঁর কাছে মাত্র কয়েক দিন বলে মনে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","পরে যাকোব লাবনকে বললেন, “আমার স্ত্রীকে আমার হাতে তুলে দিন। আমার সময় সম্পূর্ণ হয়েছে, আর আমি তাকে প্রণয়জ্ঞাপন করতে চাই।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","অতএব লাবন সেখানকার সব লোকজনকে একত্রিত করে এক ভোজসভার আয়োজন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","কিন্তু সন্ধ্যাবেলায়, তিনি তাঁর মেয়ে লেয়াকে এনে তাঁকে যাকোবের কাছে পৌঁছে দিলেন এবং যাকোব তাঁকে প্রণয়জ্ঞাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","আর লাবন তাঁর দাসী সিল্পাকে তাঁর মেয়ে লেয়ার সেবিকারূপে তাঁকে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","যখন সকাল হল, দেখা গেল তিনি লেয়া! অতএব যাকোব লাবনকে বললেন, “আপনি আমার সঙ্গে এ কী করলেন? আমি রাহেলের জন্যই তো আপনার দাসত্ব করেছি, তাই না? তবে কেন আপনি আমাকে ঠকালেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","লাবন উত্তর দিলেন, “আমাদের এখানে বড়ো মেয়ের আগে ছোটো মেয়ের বিয়ে দেওয়ার প্রথা নেই। ");
INSERT INTO benobcv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","এই মেয়েটির দাম্পত্য-সপ্তাহ সম্পূর্ণ করো; আরও সাত বছর কাজ করার পরিবর্তে পরে আমরা ছোটো মেয়েটিকেও তোমার হাতে তুলে দেব।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","আর যাকোব তেমনই করলেন। তিনি লেয়ার সপ্তাহ সম্পূর্ণ করলেন, এবং পরে লাবন তাঁর মেয়ে রাহেলকে যাকোবের স্ত্রী হওয়ার জন্য তাঁর হাতে তুলে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","লাবন তাঁর দাসী বিলহাকে রাহেলের সেবিকারূপে তাঁকে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","যাকোব রাহেলকেও প্রণয়জ্ঞাপন করলেন, এবং লেয়াকে তিনি যত না ভালোবাসতেন, রাহেলকে সে তুলনায় অনেক বেশি ভালোবাসতেন। আর তিনি লাবনের জন্য আরও সাত বছর কাজ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","সদাপ্রভু যখন দেখলেন যে লেয়া ভালোবাসা পাচ্ছেন না, তখন তিনি তাঁকে গর্ভধারণের ক্ষমতা দিলেন, কিন্তু রাহেল নিঃসন্তান রয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","লেয়া অন্তঃসত্ত্বা হলেন এবং একটি ছেলের জন্ম দিলেন। তিনি তাঁর নাম রাখলেন রূবেণ, কারণ তিনি বললেন, “সদাপ্রভু আমার দুর্দশা দেখেছেন বলেই এমনটি ঘটেছে। এখন নিশ্চয় আমার স্বামী আমাকে ভালোবাসবেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","তিনি আবার গর্ভবতী হলেন, এবং যখন তিনি আর একটি ছেলের জন্ম দিলেন, তখন তিনি বললেন, “যেহেতু সদাপ্রভু শুনেছেন যে আমি ভালোবাসা পাইনি, তাই তিনি আমাকে এই একটি ছেলেও দিলেন।” অতএব তিনি তার নাম রাখলেন শিমিয়োন। ");
INSERT INTO benobcv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","আবার তিনি গর্ভবতী হলেন, এবং যখন তিনি আর একটি ছেলের জন্ম দিলেন, তখন তিনি বললেন, “এখন অবশেষে আমার স্বামী আমার প্রতি সংলগ্ন হবেন, কারণ আমি তাঁর জন্য তিন ছেলের জন্ম দিয়েছি।” অতএব তার নাম রাখা হল লেবি। ");
INSERT INTO benobcv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","তিনি আর একবার গর্ভবতী হলেন, এবং যখন তিনি আর একটি ছেলের জন্ম দিলেন, তখন তিনি বললেন, “এবার আমি সদাপ্রভুর প্রশংসা করব।” অতএব তিনি তার নাম রাখলেন যিহূদা। পরে তিনি আর কোনও সন্তানের জন্ম দেননি। ");
INSERT INTO benobcv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","রাহেল যখন দেখলেন যে তিনি যাকোবের জন্য কোনও সন্তানধারণ করতে পারছেন না, তখন তিনি তাঁর দিদির প্রতি ঈর্ষাকাতর হলেন। তাই তিনি যাকোবকে বললেন, “আমাকে সন্তান দাও, তা না হলে আমি মারা যাব!” ");
INSERT INTO benobcv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","যাকোব তাঁর প্রতি ক্রুদ্ধ হয়ে বললেন, “আমি কি সেই ঈশ্বরের স্থান নিতে পারি, যিনি তোমাকে সন্তানধারণ করা থেকে বিরত রেখেছেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","তখন রাহেল বললেন, “আমার দাসী বিলহা তো আছে। এর সাথে শুয়ে পড়ো, যেন সে আমার জন্য সন্তানধারণ করতে পারে এবং আমিও তার মাধ্যমে এক পরিবার গড়ে তুলতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","অতএব তিনি তাঁর দাসী বিলহাকে স্ত্রীরূপে যাকোবকে দিলেন। যাকোব তার সাথে শুলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","এবং সে গর্ভবতী হল ও তাঁর জন্য এক পুত্রসন্তানের জন্ম দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","তখন রাহেল বললেন, “ঈশ্বর আমার পক্ষসমর্থন করেছেন; তিনি আমার অনুরোধ শুনেছেন ও আমাকে এক ছেলে দিয়েছেন।” এই জন্য তিনি তাঁর নাম রাখলেন দান। ");
INSERT INTO benobcv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","রাহেলের দাসী বিলহা আবার গর্ভধারণ করল ও যাকোবের জন্য দ্বিতীয় এক ছেলের জন্ম দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","তখন রাহেল বললেন, “আমার দিদির সঙ্গে আমার এক মহাসংগ্রাম হয়েছে, এবং আমিই জয়লাভ করেছি।” অতএব তিনি তার নাম রাখলেন নপ্তালি। ");
INSERT INTO benobcv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","লেয়া যখন দেখলেন যে তিনি সন্তানধারণ করতে অপারক, তখন তিনি তাঁর দাসী সিল্পাকে এক স্ত্রীরূপে যাকোবকে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","লেয়ার দাসী সিল্পা যাকোবের জন্য এক ছেলের জন্ম দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","তখন লেয়া বললেন, “আমার কী মহাসৌভাগ্য!” অতএব তিনি তার নাম রাখলেন গাদ। ");
INSERT INTO benobcv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","লেয়ার দাসী সিল্পা যাকোবের জন্য দ্বিতীয় এক ছেলের জন্ম দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","তখন লেয়া বললেন, “আমি কতই না সুখী! মহিলারা আমাকে সুখী বলে ডাকবে।” অতএব তিনি তার নাম রাখলেন আশের। ");
INSERT INTO benobcv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","গম গোলাজাত করার সময়, রূবেণ ক্ষেতে গেল ও কিছু দূদা লতাগুল্ম খুঁজে পেল, যা সে তার মা লেয়ার কাছে এনেছিল। রাহেল লেয়াকে বললেন, “তোমার ছেলের আনা দূদাগুলি থেকে আমাকে দয়া করে কিছুটা দাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","কিন্তু লেয়া তাঁকে বললেন, “এই কি যথেষ্ট নয় যে তুমি আমার স্বামীকে ছিনিয়ে নিয়েছ? তুমি আমার ছেলের দূদাগুলিও নেবে নাকি?” “ঠিক আছে,” রাহেল বললেন, “তোমার ছেলের দূদাগুলির পরিবর্তে যাকোব আজ রাতে তোমার সাথে শুতে পারেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","অতএব সেদিন সন্ধ্যাবেলায় যাকোব যখন ক্ষেত থেকে ফিরে এলেন, লেয়া তখন তাঁর সঙ্গে দেখা করার জন্য বাইরে গেলেন। “তোমাকে আমার সাথে শুতে হবে,” তিনি বললেন। “আমি আমার ছেলের দূদাগুলি দিয়ে তোমাকে ভাড়া করেছি।” অতএব সেরাতে তিনি লেয়ার সাথে শুলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ঈশ্বর লেয়ার প্রার্থনা শুনলেন ও তিনি অন্তঃসত্ত্বা হলেন এবং যাকোবের জন্য পঞ্চম এক ছেলের জন্ম দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","পরে লেয়া বললেন, “আমার স্বামীকে আমার দাসী দিয়েছি বলে ঈশ্বর আমাকে পুরস্কৃত করেছেন।” অতএব তিনি তার নাম রাখলেন ইষাখর। ");
INSERT INTO benobcv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","লেয়া আবার গর্ভধারণ করলেন এবং যাকোবের জন্য ষষ্ঠ এক ছেলের জন্ম দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","পরে লেয়া বললেন, “ঈশ্বর আমাকে এক মূল্যবান উপহার দিয়েছেন। এবার আমার স্বামী আমাকে সম্মান দেবেন, কারণ আমি তাঁর জন্য ছয় ছেলের জন্ম দিয়েছি।” অতএব তিনি তাঁর নাম রাখলেন সবূলূন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","আরও কিছুকাল পরে তিনি এক মেয়ের জন্ম দিলেন এবং তার নাম রাখলেন দীণা। ");
INSERT INTO benobcv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","পরে ঈশ্বর রাহেলকে স্মরণ করলেন; তিনি তাঁর প্রার্থনা শুনলেন ও তাঁকে গর্ভধারণের ক্ষমতা দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","তিনি অন্তঃসত্ত্বা হলেন এবং এক ছেলের জন্ম দিলেন ও বললেন, “ঈশ্বর আমার লাঞ্ছনা দূর করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","তিনি তার নাম রাখলেন যোষেফ, এবং বললেন, “সদাপ্রভু আমার জীবনে আরও এক ছেলে যোগ করুন।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","রাহেল যোষেফের জন্ম দেওয়ার পর যাকোব লাবনকে বললেন, “আমাকে এবার যেতে দিন, যেন আমি নিজের স্বদেশে ফিরে যেতে পারি। ");
INSERT INTO benobcv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","আমার সেই স্ত্রীদের ও সন্তানদেরও দিন, যাদের জন্য আমি আপনার দাসত্ব করেছি, এবং আমি দেশে ফিরে যাব। আপনি তো জানেন, আপনার জন্য আমি কত পরিশ্রম করেছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","কিন্তু লাবন তাঁকে বললেন, “আমি যদি তোমার দৃষ্টিতে দাক্ষিণ্য পেয়ে থাকি, তবে দয়া করে এখানে থেকে যাও। আমি অলৌকিক উপায়ে জানতে পেরেছি যে তোমার কারণেই সদাপ্রভু আমাকে আশীর্বাদ করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","তিনি আরও বললেন, “তুমি কত পারিশ্রমিক চাও তা বলো, ও আমি তোমাকে তা দিয়ে দেব।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","যাকোব তাঁকে বললেন, “আপনি জানেন আপনার জন্য আমি কীভাবে পরিশ্রম করেছি ও আমার যত্নআত্তিতে আপনার গবাদি পশুপাল কীভাবে বৃদ্ধি পেয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","আমি আসার আগে আপনার অল্পসল্প যা কিছু ছিল তা প্রচুর পরিমাণে বৃদ্ধি পেয়েছে, এবং আমি যেখানে থেকেছি সদাপ্রভু সেখানেই আপনাকে আশীর্বাদ করেছেন। কিন্তু এখন, আমার নিজের পরিবারের জন্য আমি কখন কী করব?” ");
INSERT INTO benobcv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“আমি তোমাকে কী দেব?” তিনি জিজ্ঞাসা করলেন। “আমাকে কিছু দিতে হবে না,” যাকোব উত্তর দিলেন। “কিন্তু আপনি যদি আমার জন্য এই একটি কাজ করেন, তবে আমি আপনার পশুপালের তত্ত্বাবধান করে যাব ও তাদের উপর নজরদারিও চালিয়ে যাব: ");
INSERT INTO benobcv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","আজ আমাকে আপনার পশুপালের মধ্যে দিয়ে যেতে দিন এবং সেগুলির মধ্যে থেকে প্রত্যেকটি দাগযুক্ত বা তিলকিত মেষ, প্রত্যেকটি শ্যামবর্ণ মেষশাবক ও প্রত্যেকটি তিলকিত বা দাগযুক্ত ছাগল আলাদা করতে দিন। সেগুলিই হবে আমার পারিশ্রমিক। ");
INSERT INTO benobcv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","আর ভবিষ্যতে যখনই আপনি আমাকে দেওয়া পারিশ্রমিকের হিসেব কষবেন, তখন আমার সততাই আমার হয়ে সাক্ষ্য দেবে। আমার অধিকারে থাকা যে কোনো ছাগল যদি দাগযুক্ত বা তিলকিত না হয়, অথবা যে কোনো মেষশাবক যদি শ্যামবর্ণ না হয়, তবে তা চুরি করা হয়েছে বলে গণ্য হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“আমি রাজি,” লাবন বললেন। “তোমার কথামতোই তা হোক।” ");
INSERT INTO benobcv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","সেদিনই তিনি সেইসব মদ্দা ছাগল আলাদা করলেন, যেগুলি ডোরাকাটা বা তিলকিত, ও সেইসব মাদি ছাগলও আলাদা করলেন, যেগুলি দাগযুক্ত ও তিলকিত (যেগুলির গায়ে সাদা দাগ ছিল) এবং সব শ্যামবর্ণ মেষশাবকও আলাদা করলেন, ও সেগুলি তাঁর ছেলেদের তত্ত্বাবধানে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","পরে তিনি তাঁর নিজের ও যাকোবের মধ্যে তিনদিনের যাত্রার ব্যবধান রাখলেন, অন্যদিকে যাকোব লাবনের বাদবাকি পশুপালের তত্ত্বাবধান করে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","যাকোব অবশ্য, চিনার, কাঠবাদাম ও প্লেইন গাছের সদ্য কাটা ডালপালা নিয়ে সেগুলির ছাল ছাড়িয়ে ও ডালপালার ভিতরদিকের সাদা কাঠ বের করে সেগুলির উপর সাদা লম্বা লম্বা দাগ বানিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","পরে তিনি সেইসব ছালছাড়ানো ডালপালা পশুদের জলপানের সব জাবপাত্রে রেখে দিলেন, যেন সেগুলি তখন সরাসরি সেইসব পশুর সামনে থাকে, যারা তখন জলপান করার জন্য সেখানে এসেছিল। পশুপাল যৌন আবেগে গরম হয়ে জলপান করতে এসে, ");
INSERT INTO benobcv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","সেইসব ডালপালার সামনে যৌনমিলন করল। আর তারা সেইসব শাবকের জন্ম দিল, যারা ডোরাকাটা বা দাগযুক্ত বা তিলকিত। ");
INSERT INTO benobcv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","যাকোব পশুপালের সেইসব শাবক আলাদা করে দিলেন, কিন্তু বাদবাকি পশুদের সেইসব ডোরাকাটা ও শ্যামবর্ণ পশুদের দিকে মুখ করিয়ে রাখলেন, যেগুলি লাবনের অধিকারভুক্ত ছিল। এইভাবে তিনি নিজের জন্য আলাদা পশুপাল তৈরি করলেন এবং সেগুলিকে লাবনের পশুপালের সঙ্গে রাখেননি। ");
INSERT INTO benobcv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","যখনই সবল মাদিগুলি যৌন আবেগে উত্তেজিত হত, যাকোব সেইসব ডালপালা পশুপালের জলপানের জাবপাত্রের মধ্যে পশুপালের সামনে রেখে দিতেন, যেন তারা সেইসব ডালপালার সামনে যৌনমিলন করতে পারে, ");
INSERT INTO benobcv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","কিন্তু পশুগুলি যদি দুর্বল হত, তবে তিনি সেগুলিকে সেখানে রাখতেন না। অতএব দুর্বল পশুগুলি লাবনের ও সবল পশুগুলি যাকোবের অধিকারভুক্ত হল। ");
INSERT INTO benobcv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","এইভাবে সেই মানুষটি খুব সমৃদ্ধিশালী হয়ে উঠলেন এবং অনেক পশুপাল, ও দাস-দাসী, এবং উট ও গাধার মালিক হয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","যাকোব শুনতে পেলেন যে লাবনের ছেলেরা বলাবলি করছে, “আমাদের বাবার অধিকারভুক্ত সবকিছু যাকোব ছিনিয়ে নিয়েছে এবং আমাদের বাবার যেসব ধনসম্পদ ছিল তা নিয়েই তার বাড়বাড়ন্ত হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","আর যাকোব লক্ষ্য করলেন যে তার প্রতি লাবনের আচরণ আর আগের মতো নেই। ");
INSERT INTO benobcv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","তখন সদাপ্রভু যাকোবকে বললেন, “তুমি তোমার পূর্বপুরুষদের ও আত্মীয়স্বজনের দেশে ফিরে যাও, আর আমি তোমার সঙ্গে থাকব।” ");
INSERT INTO benobcv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","অতএব যাকোব রাহেল ও লেয়াকে খবর পাঠিয়ে সেই মাঠে ডেকে পাঠালেন, যেখানে তাঁর পশুপাল রাখা ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","তিনি তাঁদের বললেন, “আমি দেখছি যে আমার প্রতি তোমাদের বাবার আচরণ আর আগের মতো নেই, কিন্তু আমার পৈত্রিক ঈশ্বর আমার সঙ্গে আছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","তোমরা তো জানো যে তোমাদের বাবার জন্য আমি আমার সর্বশক্তি দিয়ে পরিশ্রম করেছি, ");
INSERT INTO benobcv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","তবুও তোমাদের বাবা দশবার আমার পারিশ্রমিক পরিবর্তন করে আমাকে ঠকিয়েছেন। অবশ্য, ঈশ্বর তাঁকে আমার কোনও ক্ষতি করার অনুমতি দেননি। ");
INSERT INTO benobcv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","তিনি যদি বলেছেন, ‘দাগযুক্ত পশুগুলি তোমার পারিশ্রমিক হবে,’ তবে সব পশুপালই দাগযুক্ত শাবকের জন্ম দিয়েছিল; আর তিনি যদি বলেছেন, ‘ডোরাকাটা পশুগুলি তোমার পারিশ্রমিক হবে,’ তবে সব পশুপালই ডোরাকাটা শাবকের জন্ম দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","অতএব ঈশ্বরই তোমাদের বাবার গবাদি পশুপাল তাঁর কাছ থেকে কেড়ে নিয়েছেন ও সেগুলি আমাকে দিয়ে দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“পশুদের প্রজননের মরশুমে আমি একবার এক স্বপ্ন দেখেছিলাম যে আমি উপরের দিকে চোখ তুলে তাকিয়েছিলাম আর দেখেছিলাম যে, যে মদ্দা ছাগলগুলি মাদিগুলির সাথে যৌনমিলন করছে, সেগুলি ডোরাকাটা, দাগযুক্ত বা তিলকিত। ");
INSERT INTO benobcv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ঈশ্বরের দূত স্বপ্নে আমাকে বলেছিলেন, ‘যাকোব।’ আমি উত্তর দিয়েছিলাম, ‘আমি এখানে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","আর তিনি বলেছিলেন, ‘উপরের দিকে চোখ তুলে তাকাও ও দেখো মাদিগুলির সাথে যেসব মদ্দা ছাগল যৌনমিলন করছে সেগুলি ডোরাকাটা, দাগযুক্ত বা তিলকিত, কারণ লাবন তোমার সঙ্গে যা যা করে চলেছে, আমি সেসব দেখেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","আমি সেই বেথেলের ঈশ্বর, যেখানে তুমি এক স্তম্ভকে অভিষিক্ত করেছিলে এবং আমার কাছে এক শপথ নিয়েছিলে। এখন তুমি এই মুহূর্তেই এই স্থান ত্যাগ করো এবং তোমার স্বদেশে ফিরে যাও।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","তখন রাহেল ও লেয়া উত্তর দিলেন, “আমাদের বাবার ভূসম্পত্তিতে এখনও কি আমাদের আর কোনও অংশ ও অধিকার আছে? ");
INSERT INTO benobcv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","তিনি কি আমাদের বিদেশি বলে গণ্য করেন না? তিনি যে শুধু আমাদের বিক্রি করে দিয়েছেন তা নয়, কিন্তু আমাদের জন্য যা দেওয়া হয়েছিল, তাও তিনি নিঃশেষ করে ফেলেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","নিঃসন্দেহে যেসব ধনসম্পদ ঈশ্বর আমাদের বাবার কাছ থেকে কেড়ে নিয়েছেন, তা আমাদের ও আমাদের সন্তানদেরই। অতএব ঈশ্বর তোমাকে যা যা বলেছেন, তাই করো।” ");
INSERT INTO benobcv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","তখন যাকোব তার সন্তানদের ও তাঁর স্ত্রীদের উটের পিঠে চাপিয়ে দিলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","এবং কনান দেশে তাঁর বাবা ইস্‌হাকের কাছে যাবার জন্য তিনি পদ্দন-আরামে থাকাকালীন যেসব জিনিসপত্র জমিয়েছিলেন, সেগুলি সাথে নিয়ে তাঁর আগে আগে তাঁর সব গবাদি পশুপালও তাড়িয়ে নিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","লাবন যখন তাঁর মেষের লোম ছাঁটতে গিয়েছিলেন, রাহেল তখন তাঁর বাবার গৃহদেবতাদের মূর্তিগুলি চুরি করে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","এছাড়াও, তিনি যে পালিয়ে যাচ্ছেন একথা অরামীয় লাবনকে না বলে যাকোব তাঁকে প্রতারিত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","অতএব তিনি তাঁর সবকিছু সাথে নিয়ে, ইউফ্রেটিস নদী পার করে পালিয়ে গেলেন, এবং গিলিয়দের পার্বত্য এলাকার দিকে এগিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","তৃতীয় দিনে লাবনকে বলা হল যে যাকোব পালিয়ে গিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","তাঁর আত্মীয়স্বজনদের সঙ্গে নিয়ে, তিনি সাত দিন ধরে যাকোবের পশ্চাদ্ধাবন করলেন এবং গিলিয়দের পার্বত্য এলাকায় তাঁকে ধরে ফেললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","তখন রাতের বেলায় ঈশ্বর স্বপ্নে অরামীয় লাবনের কাছে এলেন ও তাঁকে বললেন, “যাকোবকে ভালো বা মন্দ কোনো কিছু বলার বিষয়ে তুমি সাবধান থেকো।” ");
INSERT INTO benobcv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","লাবন যখন যাকোবের নাগাল ধরে ফেললেন, তখন যাকোব গিলিয়দের পার্বত্য এলাকায় তাঁর তাঁবু খাটিয়েছিলেন, এবং লাবন ও তাঁর আত্মীয়স্বজনরাও সেখানেই ঘাঁটি গেড়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","তখন লাবন যাকোবকে বললেন, “তুমি এ কী করলে? তুমি আমার সাথে প্রতারণা করেছ এবং তুমি আমার মেয়েদের যুদ্ধবন্দিদের মতো করে নিয়ে এসেছ। ");
INSERT INTO benobcv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","তুমি কেন গোপনে পালিয়ে এসেছ ও আমাকে ঠকিয়েছ? তুমি কেন আমায় বলোনি, আমি তো আনন্দের সঙ্গে এবং খঞ্জনি ও বীণার বাজনা সহযোগে গান গেয়ে তোমাদের বিদায় জানাতে পারতাম? ");
INSERT INTO benobcv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","এমনকি তুমি আমাকে আমার নাতি-নাতনিদের ও মেয়েদের চুমু দিয়ে বিদায় জানাতেও দাওনি। তুমি এক মূর্খের মতো কাজ করেছ। ");
INSERT INTO benobcv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","তোমার ক্ষতিসাধন করার শক্তি আমার আছে; কিন্তু গতকাল রাতে তোমার পৈত্রিক ঈশ্বর আমাকে বললেন, ‘যাকোবকে ভালো বা মন্দ কোনো কিছু বলার বিষয়ে তুমি সাবধান থেকো।’ ");
INSERT INTO benobcv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","তুমি প্রস্থান করেছ, কারণ তুমি তোমার বাবার ঘরে ফিরে যেতে চেয়েছিলে। কিন্তু আমার দেবতাদের তুমি চুরি করলে কেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","যাকোব লাবনকে উত্তর দিলেন, “আমি ভয় পেয়েছিলাম, কারণ আমি ভেবেছিলাম আপনি আপনার মেয়েদের জোর করে আমার কাছ থেকে ছিনিয়ে নেবেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","কিন্তু এমন কাউকে যদি আপনি খুঁজে পান যার কাছে আপনার দেবতারা আছে, তবে সে আর বেঁচে থাকবে না। আমাদের আত্মীয়স্বজনদের উপস্থিতিতে, আপনি নিজেই দেখে নিন আপনার কোনও জিনিস আমার সাথে আছে কি না; এবং যদি তা থাকে, তবে তা নিয়ে নিন।” যাকোব জানতেনই না যে রাহেল দেবতাদের চুরি করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","অতএব লাবন যাকোবের তাঁবুতে ও লেয়ার তাঁবুতে এবং দুই দাসীর তাঁবুতে প্রবেশ করলেন, কিন্তু তিনি কিছুই খুঁজে পেলেন না। আর লেয়ার তাঁবু থেকে বেরিয়ে আসার পর, তিনি রাহেলের তাঁবুতে প্রবেশ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","রাহেল গৃহদেবতাদের নিয়ে সেগুলি তাঁর উটের জিনের মধ্যে রেখে দিয়েছিলেন এবং সেটির উপরে বসেছিলেন। লাবন সেই তাঁবুর প্রত্যেকটি জিনিসপত্র খানাতল্লাশি করলেন কিন্তু কিছুই খুঁজে পেলেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","রাহেল তাঁর বাবাকে বললেন, “হে আমার প্রভু, আমি যে আপনার সামনে উঠে দাঁড়াতে পারছি না, সেজন্য আমার উপর রাগ করবেন না; আমার মাসিক চলছে।” তাই লাবন খানাতল্লাশি করেও গৃহদেবতাদের খুঁজে পাননি। ");
INSERT INTO benobcv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","যাকোব রেগে গিয়ে লাবনকে তিরস্কার করলেন। “আমি কী অপরাধ করেছি?” তিনি লাবনকে জিজ্ঞাসা করলেন। “আমি আপনার কী এমন ক্ষতি করেছি যে আপনি আমাকে তন্নতন্ন করে খুঁজে বেড়াচ্ছেন? ");
INSERT INTO benobcv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","এখন আপনি যে আমার সব জিনিসপত্র খানাতল্লাশি করলেন, তাতে এমন কিছু কি পেয়েছেন যা আপনার গৃহস্থালিভুক্ত? আপনার ও আমার আত্মীয়স্বজনদের সামনে তা এখানে এনে রাখুন, এবং তাদেরকেই আমাদের উভয়ের মধ্যে বিচার করতে দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“আমি আপনার কাছে এখন কুড়ি বছর ধরে আছি। না আপনার মেষ ও ছাগপালের গর্ভপাত হয়েছে, না আমি আপনার পশুপাল থেকে মদ্দা মেষগুলি ধরে ধরে খেয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","বন্যজন্তুরা যেসব পশুকে বিদীর্ণ করেছিল আমি সেগুলি আপনার কাছে নিয়ে আসিনি; সেই ক্ষতি আমি নিজেই বহন করেছি। আর দিনে বা রাতে যখনই কিছু চুরি গিয়েছিল, আপনি আমার কাছ থেকে তার দাম দাবি করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","এই ছিল আমার অবস্থা: দিনের বেলায় উত্তাপ ও রাতের বেলায় শৈত্য আমাকে গ্রাস করেছিল, এবং আমার চোখ থেকে নিদ্রা পালিয়ে গিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","এভাবেই আমি কুড়িটি বছর আপনার ঘর-পরিবারে কাটিয়ে দিয়েছি। আপনার দুই মেয়ের জন্য চোদ্দো বছর এবং আপনার পশুপালের জন্য ছয় বছর আমি আপনার কাছে কাজ করেছি, আর দশবার আপনি আমার পারিশ্রমিকের পরিবর্তন করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","আমার পৈত্রিক ঈশ্বর, অব্রাহামের ঈশ্বর এবং ইস্‌হাকের সেই আশঙ্কা যদি আমার সাথে না থাকতেন, তবে আপনি নিঃসন্দেহে আমাকে শূন্য হাতেই পাঠিয়ে দিতেন। কিন্তু ঈশ্বর আমার কষ্ট ও আমার হাতের পরিশ্রম দেখেছেন, আর তাই গতকাল রাতে তিনি আপনাকে ভর্ৎসনা করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","লাবন যাকোবকে উত্তর দিলেন, “এই মহিলারা আমার মেয়ে, এই সন্তানেরা আমার সন্তানসন্ততি ও এই পশুপাল আমারই পশুপাল। তুমি যা কিছু দেখছ এসবই আমার। তবুও আজ আমি আমার এই মেয়েদের বিষয়ে বা তারা যেসব সন্তানের জন্ম দিয়েছে, তাদের বিষয়ে কী-ই বা করতে পারি? ");
INSERT INTO benobcv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","এখন তবে এসো, তুমি ও আমি, আমরা এক নিয়ম তৈরি করি, এবং এটি আমাদের মধ্যে এক সাক্ষী হয়ে থাকুক।” ");
INSERT INTO benobcv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","অতএব যাকোব একটি পাথর নিয়ে সেটি এক স্তম্ভরূপে স্থাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","তিনি তাঁর আত্মীয়স্বজনদের বললেন, “কিছু পাথর সংগ্রহ করো।” অতএব তাঁরা বেশ কিছু পাথর নিয়ে সেগুলি একটি স্তূপে পাঁজা করে রাখলেন, এবং সেই স্তূপের পাশে বসে ভোজনপান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","লাবন সেটির নাম রাখলেন যিগর সাহদূথা, এবং যাকোব সেটির নাম রাখলেন গল্-এদ। ");
INSERT INTO benobcv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","লাবন বললেন, “এই স্তূপ আজ তোমার ও আমার মধ্যে এক সাক্ষী হয়ে রইল।” এজন্য সেটির নাম রাখা হল গল্-এদ। ");
INSERT INTO benobcv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","সেটির নাম মিস্‌পা রাখা হল, কারণ তিনি বললেন, “আমরা যখন পরস্পরের থেকে দূরে সরে থাকব তখনও সদাপ্রভু যেন আমাদের দুজনের উপর নজর রাখেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","তুমি যদি আমার মেয়েদের সঙ্গে দুর্ব্যবহার করো বা আমার মেয়েদের পাশাপাশি অন্য কোনও স্ত্রীকে গ্রহণ করো, তবে যদিও আমাদের সঙ্গে কেউ নাও থাকে, তবু মনে রেখো যে তোমার ও আমার মাঝখানে ঈশ্বর এক সাক্ষী হয়ে আছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","লাবন যাকোবকে এও বললেন, “এই সেই স্তূপ, ও এই সেই স্তম্ভ যা আমি তোমার ও আমার মাঝখানে স্থাপন করেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","এই স্তূপ এক সাক্ষী, এবং এই স্তম্ভ এক সাক্ষী হয়ে থাকল, যে এই স্তূপ পার হয়ে আমি তোমার ক্ষতিসাধন করার জন্য তোমার দিকে যাব না এবং তুমিও এই স্তূপ ও স্তম্ভ পার হয়ে আমার ক্ষতিসাধন করার জন্য আমার দিকে আসবে না। ");
INSERT INTO benobcv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","অব্রাহামের ঈশ্বর এবং নাহোরের ঈশ্বর, তাঁদের পৈত্রিক ঈশ্বরই, আমাদের দুজনের মধ্যে বিচারক হয়ে থাকুন।” অতএব যাকোব তাঁর বাবা ইস্‌হাকের আশঙ্কার নামে শপথ নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","সেই পার্বত্য এলাকায় তিনি এক বলি উৎসর্গ করলেন ও তাঁর আত্মীয়স্বজনদের এক ভোজসভায় নিমন্ত্রণ করলেন। ভোজনপান করার পর, তাঁরা সেখানে রাত কাটালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","পরদিন ভোরবেলায় লাবন তাঁর নাতি-নাতনিদের ও তাঁর মেয়েদের চুমু দিলেন এবং তাদের আশীর্বাদ করলেন। পরে তিনি বিদায় নিয়ে তাঁর স্বদেশে ফিরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","যাকোবও তাঁর পথে রওনা দিলেন, এবং ঈশ্বরের দূতেরা তাঁর সঙ্গে দেখা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","যাকোব যখন তাঁদের দেখলেন, তিনি তখন বললেন, “এ হল ঈশ্বরের শিবির!” অতএব তিনি সেই স্থানটির নাম রাখলেন মহনয়িম। ");
INSERT INTO benobcv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","যাকোব নিজে যাওয়ার আগেই সেয়ীর দেশে, ইদোম অঞ্চলে তাঁর দাদা এষৌর কাছে তাঁর দূতদের পাঠিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","তিনি তাদের নির্দেশ দিলেন: “আমার প্রভু এষৌকে তোমাদের একথাই বলতে হবে: ‘আপনার দাস যাকোব বলেছেন, আমি লাবনের সঙ্গে বসবাস করছিলাম এবং এতদিন সেখানেই ছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","আমার কাছে গবাদি পশুপাল ও গাধা, মেষ ও ছাগল, এবং দাস-দাসী আছে। এখন আমি আমার প্রভুকে এই খবর পাঠাচ্ছি, যেন আমি আপনার দৃষ্টিতে দয়া পাই।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","দূতেরা যাকোবের কাছে ফিরে এসে বলল, “আমরা আপনার দাদা এষৌর কাছে গেলাম, আর এখন তিনি আপনার সঙ্গে দেখা করতে আসছেন, ও তাঁর সাথে 400 লোক আছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","খুব ভীত ও উদ্বিগ্ন হয়ে যাকোব তাঁর সঙ্গে থাকা সব লোকজনকে দুই দলে বিভক্ত করে দিলেন, এবং মেষ ও গোরুর পাল ও উটদেরও তেমনটিই করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","তিনি ভাবলেন, “এষৌ যদি এসে একটি দলকে আক্রমণ করেন, তবে অন্য দলটি পালিয়ে যেতে পারবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","পরে যাকোব প্রার্থনা করলেন, “হে সদাপ্রভু, আমার পূর্বপুরুষ অব্রাহামের ঈশ্বর, আমার বাবা ইস্‌হাকের ঈশ্বর, তুমিই তো আমাকে বলেছ, ‘তোমার দেশে ও তোমার আত্মীয়স্বজনদের কাছে ফিরে যাও, এবং আমি তোমাকে সমৃদ্ধিশালী করব,’ ");
INSERT INTO benobcv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","তোমার দাসের প্রতি তুমি যে দয়া ও বিশ্বস্ততা দেখিয়েছ, আমি সেসব পাওয়ার যোগ্য নই। আমি যখন এই জর্ডন নদী পার হলাম, তখন আমার হাতে শুধু আমার লাঠিটিই ছিল, কিন্তু এখন আমি দুটি শিবিরে পরিণত হয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","প্রার্থনা করি, আমার দাদা এষৌর হাত থেকে আমাকে রক্ষা করো, কারণ আমার ভয় হচ্ছে যে তিনি এসে আমাকে, এবং সন্তানসন্ততিসহ মায়েদের আক্রমণ করবেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","কিন্তু তুমিই তো বলেছ, ‘আমি অবশ্যই তোমাকে সমৃদ্ধিশালী করব এবং তোমার বংশধরদের সমুদ্রের এমন বালুকণার মতো করব, যা গোনা যায় না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","সেই রাতটি তিনি সেখানেই কাটালেন, এবং তাঁর কাছে যা কিছু ছিল তার মধ্যে থেকে তিনি তাঁর দাদা এষৌর জন্য এক উপহার বেছে নিলেন: ");
INSERT INTO benobcv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200-টি মাদি ছাগল ও কুড়িটি মদ্দা ছাগল, 200-টি মেষী ও কুড়িটি মদ্দা মেষ, ");
INSERT INTO benobcv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","শাবকসহ ত্রিশটি মাদি উট, চল্লিশটি গরু ও দশটি বলদ, এবং কুড়িটি গাধি ও দশটি গাধা। ");
INSERT INTO benobcv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","আলাদা আলাদা করে প্রত্যেকটি পশুপাল তিনি তাঁর দাসদের তত্ত্বাবধানে রাখলেন, এবং তাঁর দাসদের বললেন, “আমার আগে আগে যাও, এবং পশুপালগুলির মধ্যে তোমরা কিছুটা ব্যবধান রেখো।” ");
INSERT INTO benobcv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","নেতৃত্বে থাকা একজনকে তিনি নির্দেশ দিলেন: “আমার দাদা এষৌ যখন তোমার সঙ্গে দেখা করবেন ও জিজ্ঞাসা করবেন, ‘তুমি কার লোক ও তুমি কোথায় যাচ্ছ, এবং তোমার সামনে থাকা এইসব পশুর মালিক কে?’ ");
INSERT INTO benobcv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","তখন তোমাকে বলতে হবে, ‘এগুলির মালিক আপনার দাস যাকোব। আমার প্রভু এষৌর কাছে এগুলি উপহারস্বরূপ পাঠানো হয়েছে, এবং আমাদের পিছু পিছু তিনিও আসছেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","সেই পশুপালের অনুগামী দ্বিতীয়জনকে, তৃতীয় জনকে ও অন্যান্য সবাইকেও তিনি নির্দেশ দিলেন: “তোমরা যখন এষৌর সঙ্গে দেখা করবে, তখন তোমাদেরও তাঁকে একই কথা বলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","আর অবশ্যই বলবে, ‘আপনার দাস যাকোব আমাদের পিছু পিছু আসছেন।’ ” কারণ তিনি ভেবেছিলেন, “আগেভাগেই আমি এই যেসব উপহার পাঠিয়ে দিচ্ছি, সেগুলি দিয়েই আমি তাঁকে শান্ত করব; পরে, আমার সঙ্গে যখন তাঁর দেখা হবে, হয়তো তিনি আমাকে গ্রহণ করবেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","অতএব যাকোবের উপহারগুলি তাঁর যাওয়ার আগেই পৌঁছে গেল, কিন্তু তিনি স্বয়ং সেই রাতটি শিবিরেই কাটালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","সেরাতে যাকোব উঠে পড়লেন ও তাঁর দুই স্ত্রীকে, তাঁর দুই দাসীকে এবং তাঁর এগারোজন ছেলেকে সঙ্গে নিয়ে যব্বোক নদীর অগভীর অংশটি পার হয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","তাদের নদী পার করে পাঠিয়ে দেওয়ার পর, তিনি তাঁর সব জিনিসপত্রও পাঠিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","অতএব যাকোব একাই থেকে গেলেন, এবং একজন লোক ভোর হয়ে ওঠা পর্যন্ত তাঁর সঙ্গে কুস্তি লড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","যখন সেই লোকটি দেখলেন যে তিনি তাঁকে হারাতে পারছেন না, তখন তিনি যাকোবের ঊরুর কোটর স্পর্শ করলেন যেন সেই লোকটির সঙ্গে কুস্তি করতে করতে তাঁর ঊরু মচকে যায়। ");
INSERT INTO benobcv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","পরে সেই লোকটি বললেন, “আমাকে যেতে দাও, কারণ ভোর হয়ে আসছে।” কিন্তু যাকোব উত্তর দিলেন, “যতক্ষণ না পর্যন্ত আপনি আমাকে আশীর্বাদ করছেন, আমি আপনাকে যেতে দেব না।” ");
INSERT INTO benobcv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","সেই লোকটি তাঁকে জিজ্ঞাসা করলেন, “তোমার নাম কী?” “যাকোব,” তিনি উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","তখন সেই লোকটি বললেন, “তোমার নাম আর যাকোব থাকবে না, কিন্তু তা হবে ইস্রায়েল, কারণ তুমি ঈশ্বরের ও মানুষের সঙ্গে যুদ্ধ করে জয় পেয়েছ।” ");
INSERT INTO benobcv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","যাকোব বললেন, “দয়া করে আপনার নাম বলুন।” কিন্তু তিনি উত্তর দিলেন, “তুমি আমার নাম জিজ্ঞাসা করছ কেন?” পরে তিনি সেখানেই তাঁকে আশীর্বাদ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","অতএব যাকোব এই বলে সেই স্থানটির নাম রাখলেন পনূয়েল, “আমি ঈশ্বরকে সামনাসামনি দেখেছি, আর তাও আমার প্রাণরক্ষা হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","তিনি যখন পনূয়েল পার হচ্ছিলেন তখন সূর্য তাঁর মাথার উপর উদিত হল, এবং তাঁর ঊরুর জন্য তিনি খুঁড়িয়ে খুঁড়িয়ে হাঁটছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","তাই আজও পর্যন্ত ইস্রায়েলীরা ঊরুর কোটরের সঙ্গে সংলগ্ন কণ্ডরা খায় না, যেহেতু কণ্ডরার কাছেই যাকোবের ঊরুর কোটর স্পর্শ করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","যাকোব চোখ তুলে তাকিয়ে সেই এষৌকে দেখতে পেলেন, যিনি 400 জন লোক নিয়ে এগিয়ে আসছিলেন; অতএব তিনি লেয়া, রাহেল ও দুই দাসীর মধ্যে সন্তানদের ভাগাভাগি করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","সামনের দিকে তিনি দাসীদের ও তাদের সন্তানদের, পরে লেয়া ও তাঁর সন্তানদের এবং পিছন দিকে রাহেল ও যোষেফকে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","তিনি স্বয়ং সবার আগে এগিয়ে গেলেন এবং তাঁর দাদার কাছাকাছি পৌঁছে সাতবার মাটিতে মাথা ঠেকিয়ে অভিবাদন জানালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","কিন্তু এষৌ যাকোবের সঙ্গে দেখা করার জন্য ছুটে এলেন এবং তাঁকে আলিঙ্গন করলেন; তিনি দু-হাতে তাঁর গলা জড়িয়ে ধরে তাঁকে চুমু দিলেন। আর তাঁরা কান্নাকাটি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","পরে এষৌ মুখ তুলে তাকালেন এবং সব মহিলা ও সন্তানকে দেখতে পেলেন। “তোমার সঙ্গে এরা কারা?” তিনি জিজ্ঞাসা করলেন। যাকোব উত্তর দিলেন, “এরা সেইসব সন্তানসন্ততি যাদের ঈশ্বর অনুগ্রহ করে আপনার এই দাসকে দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","তখন দাসীরা ও তাদের সন্তানেরা এগিয়ে এসে অভিবাদন জানাল। ");
INSERT INTO benobcv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","পরে, লেয়া ও তাঁর সন্তানেরা এসে অভিবাদন জানালেন। সবশেষে যোষেফ ও রাহেল এলেন, এবং তাঁরাও অভিবাদন জানালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","এষৌ জিজ্ঞাসা করলেন, “যেসব মেষ ও পশুপালের সঙ্গে আমার দেখা হল, সেগুলির অর্থ কী?” “হে আমার প্রভু, আপনার দৃষ্টিতে দয়া পাওয়ার জন্য,” তিনি বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","কিন্তু এষৌ বললেন, “হে আমার ভাই, আমার কাছে তো যথেষ্ট আছে। তোমার কাছে যা আছে, তা নিজের জন্যই রেখে দাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","যাকোব বললেন, “আপনার দৃষ্টিতে আমি যদি দয়া পেয়েছি, তবে দয়া করে আমার কাছ থেকে এই উপহারটি গ্রহণ করুন। কারণ আপনার মুখ দেখার অর্থ হল ঈশ্বরেরই মুখ দেখা, যেহেতু এখন আপনি দয়া দেখিয়ে আমাকে গ্রহণ করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","আপনার কাছে যে উপহারটি আনা হয়েছে তা দয়া করে গ্রহণ করুন, কারণ ঈশ্বর আমার প্রতি অনুগ্রহশীল হয়েছেন এবং আমার যা যা প্রয়োজন তা আমার কাছে আছে।” আর যেহেতু যাকোব পীড়াপীড়ি করলেন, তাই এষৌ তা গ্রহণ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","পরে এষৌ বললেন, “চলো আমরা রওনা দিই; আমিও তোমাদের সঙ্গে সঙ্গে যাব।” ");
INSERT INTO benobcv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","কিন্তু যাকোব তাঁকে বললেন, “আমার প্রভু তো জানেন যে শিশুসন্তানেরা সুকুমার এবং আমাকে সেইসব মেষীর ও গরুর যত্ন নিতে হবে, যারা তাদের শাবকদের শুশ্রুষা করছে। একদিনেই যদি তাদের জোরে তাড়িয়ে নিয়ে যাওয়া হয়, তবে সব পশু মারা যাবে। ");
INSERT INTO benobcv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","অতএব আমার প্রভুই তাঁর দাসের আগে আগে চলে যান, আর যতক্ষণ না আমি আমার প্রভুর কাছে সেয়ীরে উপস্থিত হতে পারছি, ততক্ষণ আমি আমার আগে আগে যাওয়া মেষ ও পশুপালের এবং শিশু সন্তানদের গতির সাথে তাল মিলিয়ে এগিয়ে যাচ্ছি।” ");
INSERT INTO benobcv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","এষৌ বললেন, “তবে আমার কিছু লোকজন তোমাদের কাছে ছেড়ে যাই!” “কিন্তু তা কেন করবেন?” যাকোব জিজ্ঞাসা করলেন। “আমার প্রভুর দৃষ্টিতে শুধু আমাকে দয়া পেতে দিন।” ");
INSERT INTO benobcv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","অতএব সেদিন এষৌ সেয়ীরের দিকে ফিরে যাওয়ার জন্য যাত্রা শুরু করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","যাকোব, অবশ্য, সেই সুক্কোতে চলে গেলেন, যেখানে তিনি নিজের জন্য এক বাড়ি ও তাঁর গৃহপালিত পশুপালের জন্য নিরাপদ আশ্রয়স্থল তৈরি করলেন। সেই কারণে সেই স্থানটিকে সুক্কোৎ বলে ডাকা হয়। ");
INSERT INTO benobcv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","পদ্দন-আরাম থেকে চলে আসার পর যাকোব নিরাপদে কনান দেশের শিখিম নগরে পৌঁছে গেলেন এবং সেই নগরের কাছেই নিজের শিবির স্থাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","100 রৌপমুদ্রা দিয়ে, তিনি শিখিমের বাবা হমোরের ছেলেদের কাছ থেকে সেই জমিখণ্ডটি কিনলেন, যেখানে তিনি তাঁবু খাটিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","সেখানে তিনি একটি যজ্ঞবেদি নির্মাণ করে সেটির নাম রাখলেন এল্-এলোহে-ইস্রায়েল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","যে মেয়েটিকে লেয়া যাকোবের জন্য জন্ম দিয়েছিলেন, সেই দীণা সেদেশের মহিলাদের সঙ্গে দেখা করার জন্য বাইরে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","সেই অঞ্চলের শাসনকর্তা হিব্বীয় হমোরের ছেলে শিখিম যখন তাকে দেখতে পেল, তখন সে তাকে উঠিয়ে নিয়ে গিয়ে ধর্ষণ করল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","যাকোবের মেয়ে দীণার প্রতি তার মন আকর্ষিত হল; সে সেই যুবতী মেয়েটিকে ভালোবেসে ফেলল ও তার সঙ্গে কোমলভাবে কথা বলল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","আর শিখিম তার বাবা হমোরকে বলল, “এই মেয়েটিকে আমার স্ত্রী করে এনে দাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","যাকোব যখন শুনতে পেলেন যে তাঁর মেয়ে দীণাকে কলুষিত করা হয়েছে, তখন তাঁর ছেলেরা তাঁর গৃহপালিত পশুপাল নিয়ে মাঠেই ছিল; তাই তারা বাড়ি ফিরে না আসা পর্যন্ত তিনি সে বিষয়ে কিছুই করলেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","পরে শিখিমের বাবা হমোর যাকোবের সঙ্গে কথা বলতে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","এদিকে, যে ঘটনা ঘটেছিল তা শুনে যাকোবের ছেলেরা মাঠ থেকে ফিরে এসেছিল। তারা মর্মাহত ও অগ্নিশর্মা হয়ে উঠল, কারণ যাকোবের মেয়ের সাথে শুয়ে শিখিম ইস্রায়েলে এমন এক নির্লজ্জ কাজ করেছিল—যা করা একদম উচিত হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","কিন্তু হমোর তাঁদের বললেন, “আমার ছেলে শিখিম আপনার মেয়েকে তার মন দিয়ে বসেছে। দয়া করে তাকে স্ত্রীরূপে তার হাতে তুলে দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","আমাদের সাথে অসবর্ণমতে বিবাহবন্ধনে আবদ্ধ হোন; আপনাদের মেয়েদের আমাদের হাতে তুলে দিন ও আমাদের মেয়েদের আপনারা গ্রহণ করুন। ");
INSERT INTO benobcv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","আমাদের মধ্যে আপনারা স্থায়ীভাবে বসবাস করতে পারেন; দেশটি আপনাদের কাছে খোলা পড়ে আছে। এখানে বসবাস করুন, এখানে ব্যবসাবাণিজ্য করুন, এবং এখানে বিষয়সম্পত্তি অর্জন করুন।” ");
INSERT INTO benobcv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","তখন শিখিম দীণার বাবাকে ও দাদাদের বলল, “আপনাদের দৃষ্টিতে আমাকে দয়া পেতে দিন, এবং আপনারা যা চান আমি আপনাদের তাই দেব। ");
INSERT INTO benobcv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","যে স্ত্রী-পণ ও উপহার আমাকে দিতে হবে, তা যতই বেশি হোক না কেন, আপনাদের ইচ্ছানুসারে তা আপনারাই ঠিক করুন, আর আপনারা আমার কাছে যা চাইবেন, আমি আপনাদের তাই দেব। শুধু যুবতী মেয়েটিকে আমার স্ত্রীরূপে আমায় দিন।” ");
INSERT INTO benobcv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","যেহেতু তাদের বোন দীণাকে কলুষিত করা হয়েছিল, তাই যাকোবের ছেলেরা শিখিম ও তার বাবা হমোরের সঙ্গে কথা বলার সময় ছলনা করে উত্তর দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","তারা তাদের বলল, “আমরা এরকম কাজ করতে পারব না; আমরা এমন কোনও পুরুষের হাতে আমাদের বোনকে তুলে দিতে পারব না, যার সুন্নত হয়নি। তা আমাদের পক্ষে মর্যাদাহানিকর হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","একটিমাত্র শর্তে শুধু আমরা তোমাদের সঙ্গে চুক্তিবদ্ধ হতে পারি: তোমাদের সব পুরুষমানুষ সুন্নত করিয়ে যদি আমাদের মতো হয়ে যাও, তবেই তা সম্ভব। ");
INSERT INTO benobcv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","তখনই আমাদের মেয়েদের আমরা তোমাদের হাতে তুলে দেব ও তোমাদের মেয়েদের আমরা নিজেদের জন্য গ্রহণ করব। আমরা তোমাদের মধ্যেই স্থায়ীভাবে বসবাস করব এবং তোমাদের সঙ্গে মিলেমিশে এক জাতি হয়ে যাব। ");
INSERT INTO benobcv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","কিন্তু তোমরা যদি সুন্নত করাতে রাজি না হও, তবে আমরা আমাদের বোনকে নিয়ে চলে যাব।” ");
INSERT INTO benobcv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","তাদের প্রস্তাবটি হমোর ও তার ছেলে শিখিমের ভালোই লেগেছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","সেই যুবকটি, যে তার বাবার পরিবারে সবচেয়ে বেশি সম্মানিত ছিল, সে তাদের কথামতো কাজ করতে একটুও সময় নষ্ট করেনি, কারণ যাকোবের মেয়েকে পেয়ে সে খুশি হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","অতএব হমোর ও তার ছেলে শিখিম তাদের নগরের লোকজনের সঙ্গে কথা বলার জন্য তাদের নগরের ফটকে চলে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“এই লোকেরা আমাদের প্রতি বন্ধুভাবাপন্ন,” তারা বলল। “তারা আমাদের দেশেই বসবাস করুক ও এখানেই ব্যবসাবাণিজ্য করুক; এদেশে তাদের জন্য প্রচুর স্থান আছে। আমরা তাদের মেয়েদের বিয়ে করতে পারি ও তারাও আমাদের মেয়েদের বিয়ে করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","কিন্তু সেই লোকেরা একটিই মাত্র শর্তে আমাদের সঙ্গে এক জাতি হয়ে বসবাস করবে, যে আমাদের সব পুরুষমানুষ সুন্নত করাবে, যেমনটি তারা নিজেরাও করিয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","তাদের গবাদি পশুপাল, তাদের বিষয়সম্পত্তি ও তাদের বাকি সব পশু কি আমাদের হয়ে যাবে না? তাই এসো, আমরা তাদের শর্তে রাজি হয়ে যাই, এবং তারা আমাদের মধ্যে স্থায়ীভাবে বসবাস করুক।” ");
INSERT INTO benobcv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","যেসব লোকজন নগরের ফটকের বাইরে গিয়েছিল, তারা হমোর ও তার ছেলে শিখিমের কথায় রাজি হল, এবং সেই নগরের সব পুরুষমানুষ সুন্নত করাল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","তিন দিন পর, যখন তারা সবাই তখনও ব্যথায় কাতরাচ্ছিল, তখন যাকোবের ছেলেদের মধ্যে দুজন—দীণার দাদা শিমিয়োন ও লেবি, তাদের তরোয়াল হাতে তুলে নিয়ে সেই অসন্দিগ্ধ নগরটি আক্রমণ করল, ও প্রত্যেকটি পুরুষমানুষকে হত্যা করল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","তারা হমোর ও তার ছেলে শিখিমকেও তরোয়াল দিয়ে হত্যা করল এবং দীণাকে শিখিমের বাড়ি থেকে নিয়ে চলে এল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","যাকোবের ছেলেরা মৃতদেহগুলির কাছে গিয়ে সেই নগরে লুটপাট চালাল, যেখানে তাদের বোনকে কলুষিত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","তারা তাদের মেষপাল ও পশুপাল ও গাধাগুলি এবং সেই নগরে ও মাঠেঘাটে তাদের আরও যা যা ছিল, সেসবকিছু দখল করে নিল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","তারা তাদের ধনসম্পদ ও তাদের সব স্ত্রী ও সন্তানসন্ততিকে তুলে এনে, তাদের বাড়িঘরের সর্বস্ব লুট করল। ");
INSERT INTO benobcv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","তখন যাকোব শিমিয়োন ও লেবিকে বললেন, “তোমরা সেই কনানীয় ও পরিষীয়দের কাছে, এই দেশে বসবাসকারী জাতিদের কাছে আমাকে আপত্তিকর করে তুলে আমার উপর সমস্যার বোঝা চাপিয়ে দিলে। আমরা সংখ্যায় কয়েকজন মাত্র, এবং তারা যদি আমার বিরুদ্ধে দল বেঁধে আমাকে আক্রমণ করে, তবে আমি ও আমার পরিবার ধ্বংস হয়ে যাব।” ");
INSERT INTO benobcv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","কিন্তু তারা উত্তর দিল, “আমাদের বোনের সাথে এক বেশ্যার মতো ব্যবহার করা কি তার উচিত হয়েছে?” ");
INSERT INTO benobcv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","তখন ঈশ্বর যাকোবকে বললেন, “বেথেলে চলে যাও ও সেখানেই বসবাস করো, এবং সেখানে সেই ঈশ্বরের উদ্দেশে একটি যজ্ঞবেদি নির্মাণ করো, যিনি তোমার কাছে সেই সময় আবির্ভূত হলেন, যখন তুমি তোমার দাদা এষৌর কাছ থেকে পালিয়ে যাচ্ছিলে।” ");
INSERT INTO benobcv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","অতএব যাকোব তাঁর পরিবারের লোকজনদের ও তাঁর সঙ্গে আরও যারা ছিলেন, তাদের বললেন, “তোমাদের কাছে যে বিজাতীয় দেবতারা আছে, তাদের থেকে নিষ্কৃতি লাভ করো এবং নিজেদের শুচিশুদ্ধ করো ও তোমাদের পোশাক-পরিচ্ছদ বদলে ফেলো। ");
INSERT INTO benobcv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","পরে এসো, আমরা সবাই মিলে সেই বেথেলে উঠে যাই, যেখানে সেই ঈশ্বরের উদ্দেশে আমি একটি যজ্ঞবেদি নির্মাণ করব, যিনি আমার দুঃখের দিনে আমাকে উত্তর দিয়েছিলেন ও আমি যেখানেই গিয়েছি, তিনি আমার সহায় হয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","অতএব তারা, তাদের কাছে যেসব বিজাতীয় দেবতাগুলি ছিল, সেগুলি ও তাদের কানের দুলগুলি যাকোবকে দিলেন, এবং যাকোব সেগুলি শিখিমে ওক গাছের তলায় পুঁতে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","পরে তাঁরা রওনা দিলেন, এবং ঈশ্বরের আতঙ্ক এমনভাবে তাঁদের চারপাশের ছোটোখাটো সব নগরের উপর নেমে এল যে কেউই তাঁদের পশ্চাদ্ধাবন করেনি। ");
INSERT INTO benobcv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","যাকোব ও তাঁর সব সঙ্গীসাথী কনান দেশের লূসে (অথবা, বেথেলে) এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","সেখানে তিনি একটি যজ্ঞবেদি নির্মাণ করেছিলেন, এবং তিনি সেই স্থানটির নাম রাখলেন এল্-বেথেল, কারণ যখন তিনি তাঁর দাদার কাছ থেকে পালিয়ে যাচ্ছিলেন, তখন সেখানেই ঈশ্বর নিজেকে তাঁর কাছে প্রকাশিত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","তখন রিবিকার সেবিকা দবোরা মারা গেল এবং তাকে বেথেলের বাইরের দিকে একটি ওক গাছের তলায় কবর দেওয়া হল। তাই সেই স্থানটির নাম রাখা হল অলোন্-বাখুৎ। ");
INSERT INTO benobcv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","পদ্দন-আরাম থেকে ফিরে আসার পর, ঈশ্বর আবার যাকোবের কাছে আবির্ভূত হলেন ও তাঁকে আশীর্বাদ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ঈশ্বর তাঁকে বললেন, “তোমার নাম যাকোব, কিন্তু তোমাকে আর যাকোব বলে ডাকা হবে না; তোমার নাম হবে ইস্রায়েল।” অতএব তিনি তাঁর নাম রাখলেন ইস্রায়েল। ");
INSERT INTO benobcv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","আর ঈশ্বর তাঁকে বললেন, “আমি সর্বশক্তিমান ঈশ্বর; ফলপ্রসূ হও এবং সংখ্যায় বৃদ্ধি পাও। তোমার মধ্যে থেকে এক জাতি ও এক জাতি-সমাজ উৎপন্ন হবে, এবং তোমার বংশধরদের মধ্যে অনেকেই রাজা হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","যে দেশটি আমি অব্রাহাম ও ইস্‌হাককে দিয়েছিলাম তা আমি তোমাকেও দেব, এবং তোমার পরে এই দেশটি আমি তোমার বংশধরদেরও দেব।” ");
INSERT INTO benobcv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","পরে ঈশ্বর তাঁর কাছ থেকে সেই স্থানে উঠে গেলেন, যেখানে তিনি তাঁর সঙ্গে কথা বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ঈশ্বর যে স্থানটিতে যাকোবের সঙ্গে কথা বললেন, সেখানে তিনি পাথরের একটি স্তম্ভ খাড়া করলেন এবং সেটির উপর তিনি এক পেয়-নৈবেদ্য উৎসর্গ করলেন; তিনি সেটির উপর তেলও ঢেলে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","যে স্থানটিতে ঈশ্বর যাকোবের সঙ্গে কথা বললেন, তিনি সেটির নাম রাখলেন বেথেল। ");
INSERT INTO benobcv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","পরে তাঁরা বেথেল ছেড়ে এগিয়ে গেলেন। যখন তাঁরা ইফ্রাথ থেকে কিছুটা দূরে ছিলেন, তখন রাহেলের প্রসবযন্ত্রণা শুরু হল ও তিনি খুব কষ্ট পাচ্ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","আর সন্তানের জন্ম দিতে গিয়ে যখন তাঁর খুব অসুবিধা হচ্ছিল তখন তাঁর ধাত্রী তাঁকে বলল, “আপনি নিরাশ হবেন না, আপনি আরও এক ছেলের জন্ম দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","শেষনিশ্বাস ত্যাগ করতে করতে তিনি তাঁর ছেলের নাম রাখলেন বিনোনী—কারণ তিনি মারা যাচ্ছিলেন। কিন্তু তার বাবা তার নাম রাখলেন বিন্যামীন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","অতএব রাহেল মারা গেলেন ও তাঁকে ইফ্রাথে (অথবা, বেথলেহেমে) যাওয়ার পথেই কবর দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","তাঁর সমাধির উপর যাকোব একটি স্তম্ভ খাড়া করলেন, এবং আজও পর্যন্ত সেই স্তম্ভটি রাহেলের কবররূপে চিহ্নিত হয়ে আছে। ");
INSERT INTO benobcv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ইস্রায়েল আরও আগে এগিয়ে গেলেন এবং মিগদল-এদোর পার করে তাঁর তাঁবু খাটালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ইস্রায়েল যখন সেই অঞ্চলে বসবাস করছিলেন, রূবেণ তাঁর বাবার উপপত্নী বিলহার কাছে গিয়ে তাঁর সাথে শুয়েছিলেন, এবং ইস্রায়েল তা শুনতে পেলেন। যাকোবের বারোটি ছেলে ছিল: ");
INSERT INTO benobcv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","লেয়ার ছেলেরা: যাকোবের বড়ো ছেলে রূবেণ, শিমিয়োন, লেবি, যিহূদা, ইষাখর ও সবূলূন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","রাহেলের ছেলেরা: যোষেফ ও বিন্যামীন, ");
INSERT INTO benobcv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","রাহেলের দাসী বিলহার ছেলেরা: দান ও নপ্তালি। ");
INSERT INTO benobcv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","লেয়ার দাসী সিল্পার ছেলেরা: গাদ ও আশের। এরাই যাকোবের সেই ছেলেরা, পদ্দন-আরামে যারা তাঁর ঔরসে জন্মেছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","কিরিয়ৎ-অর্বের (অথবা, হিব্রোণের) কাছাকাছি অবস্থিত সেই মম্রিতে যাকোব ঘরে তাঁর বাবা ইস্‌হাকের কাছে এলেন, যেখানে অব্রাহাম ও ইস্‌হাক বসবাস করতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ইস্‌হাক 180 বছর বেঁচেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","পরে তিনি শেষনিশ্বাস ত্যাগ করলেন ও মারা গেলেন এবং তিনি বৃদ্ধ ও পূর্ণায়ূ অবস্থায় তাঁর পূর্বপুরুষদের সাথে মিলিত হলেন। আর তাঁর ছেলে এষৌ ও যাকোব তাঁকে কবর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","এই হল এষৌর (অথবা, ইদোমের) বংশপরম্পরার বৃত্তান্ত। ");
INSERT INTO benobcv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","এষৌ কনানীয় মহিলাদের মধ্যে থেকেই তাঁর স্ত্রীদের গ্রহণ করলেন: হিত্তীয় এলোনের মেয়ে আদা এবং হিব্বীয় সিবিয়োনের নাতনি তথা অনার মেয়ে অহলীবামা— ");
INSERT INTO benobcv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","এছাড়াও ইশ্মায়েলের মেয়ে ও নবায়োতের বোন বাসমৎ। ");
INSERT INTO benobcv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","এষৌর জন্য আদা ইলীফসের, বাসমৎ রূয়েলের, ");
INSERT INTO benobcv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","এবং অহলীবামা যিয়ূশ, যালম ও কোরহের জন্ম দিলেন। এরাই হল এষৌর সেই ছেলেরা, যাদের জন্ম কনান দেশে হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","এষৌ তাঁর স্ত্রীদের ও ছেলেমেয়েদের এবং তাঁর পরিবারের সব সদস্যকে, এছাড়াও তাঁর গবাদি পশুপাল ও অন্যান্য পশুপাল তথা কনান দেশে তিনি যেসব জিনিসপত্র অর্জন করেছিলেন, সেসবকিছু নিয়ে তাঁর ভাই যাকোবের কাছ থেকে কিছুটা দূরত্ব বজায় রেখে এগিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","তাঁদের বিষয়সম্পত্তির পরিমাণ এত বেশি ছিল যে একত্রে বসবাস করা তাঁদের পক্ষে সম্ভব হচ্ছিল না; যে দেশে তাঁরা বসবাস করছিলেন, তা তাঁদের গবাদি পশুপালের জন্য তাঁদের ভারবহন করতে পারছিল না। ");
INSERT INTO benobcv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","অতএব এষৌ (অথবা, ইদোম) সেয়ীরের পার্বত্য অঞ্চলে বসতি স্থাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","সেয়ীরের পার্বত্য অঞ্চলে বসবাসকারী ইদোমীয়দের পূর্বপুরুষ এষৌর বংশপরম্পরা এইরকম: ");
INSERT INTO benobcv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","এষৌর ছেলেদের নাম এইরকম: এষৌর স্ত্রী আদার ছেলে ইলীফস, এবং এষৌর স্ত্রী বাসমতের ছেলে রূয়েল। ");
INSERT INTO benobcv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ইলীফসের ছেলেরা: তৈমন, ওমার, সফো, গয়িতম ও কনস। ");
INSERT INTO benobcv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","এষৌর ছেলে ইলীফসের তিম্না নামের এক উপপত্নীও ছিল, যে ইলীফসের জন্য অমালেককে জন্ম দিয়েছিল। এরাই হল এষৌর স্ত্রী আদার সব নাতিপুতি। ");
INSERT INTO benobcv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","রূয়েলের ছেলেরা: নহৎ, সেরহ, শম্ম ও মিসা। এরাই হল এষৌর স্ত্রী বাসমতের সব নাতিপুতি। ");
INSERT INTO benobcv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","এষৌর স্ত্রী তথা সিবিয়োনের নাতনি ও অনার মেয়ে অহলীবামা এষৌর জন্য যেসব ছেলের জন্ম দিলেন তারা হল: যিয়ূশ, যালম ও কোরহ। ");
INSERT INTO benobcv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","এষৌর বংশধরদের মধ্যে এরাই হলেন বিভাগীয় প্রধান: এষৌর বড়ো ছেলে ইলীফসের ছেলেরা: দল প্রধান তৈমন, ওমার, সফো, কনস, ");
INSERT INTO benobcv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","কোরহ, গয়িতম ও অমালেক। ইদোমে এই বিভাগীয় প্রধানেরাই ইলীফসের বংশে জন্মগ্রহণ করলেন; তাঁরা আদার সব নাতিপুতি। ");
INSERT INTO benobcv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","এষৌর ছেলে রূয়েলের ছেলেরা: বিভাগীয় প্রধান নহৎ, সেরহ, শম্ম ও মিসা। ইদোমে এই বিভাগীয় প্রধানেরাই রূয়েলের বংশে জন্মগ্রহণ করলেন; তাঁরা এষৌর স্ত্রী বাসমতের সব নাতিপুতি। ");
INSERT INTO benobcv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","এষৌর স্ত্রী অহলীবামার ছেলেরা: বিভাগীয় প্রধান যিয়ূশ, যালম ও কোরহ। এই বিভাগীয় প্রধানেরাই এষৌর স্ত্রী তথা অনার মেয়ে অহলীবামার গর্ভজাত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","এরাই হলেন এষৌর (অথবা, ইদোমের) সব ছেলে, এবং এরাই হলেন তাদের বিভাগীয় প্রধান। ");
INSERT INTO benobcv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","এরাই হলেন হোরীয় সেয়ীরের সেইসব ছেলে, যারা সেই অঞ্চলে বসবাস করতেন: লোটন, শোবল, শিবিয়োন, অনা, ");
INSERT INTO benobcv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","দিশোন, এৎসর ও দীশন। ইদোমে সেয়ীরের এই ছেলেরা ছিলেন হোরীয় বিভাগীয় প্রধান। ");
INSERT INTO benobcv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","লোটনের ছেলেরা: হোরি ও হোমম। তিম্না ছিলেন লোটনের বোন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","শোবলের ছেলেরা: অলবন, মানহৎ, এবল, শফী ও ওনম। ");
INSERT INTO benobcv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","সিবিয়োনের ছেলেরা: অয়া ও অনা। (এই অনাই মরুভূমিতে তাঁর বাবা সিবিয়োনের গাধাগুলি চরানোর সময় উষ্ণ জলের উৎসগুলি খুঁজে পেয়েছিলেন) ");
INSERT INTO benobcv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","অনার সন্তানেরা: অনার মেয়ে দিশোন ও অহলীবামা। ");
INSERT INTO benobcv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","দিশোনের ছেলেরা: হিমদন, ইশ্‌বন, যিত্রণ ও করাণ। ");
INSERT INTO benobcv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","এৎসরের ছেলেরা: বিলহন, সাবন ও আকন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","দীশনের ছেলেরা: ঊষ ও অরাণ। ");
INSERT INTO benobcv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","এরাই ছিলেন হোরীয় বিভাগীয় প্রধান: লোটন, শোবল, শিবিয়োন, অনা, ");
INSERT INTO benobcv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","দিশোন, এৎসর ও দীশন। সেয়ীর দেশে তাদের বিভাগ অনুসারে এরাই হলেন হোরীয় বিভাগীয় প্রধান। ");
INSERT INTO benobcv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","কোনো ইস্রায়েলী রাজা রাজত্ব করার আগে এরাই ইদোমে রাজা হয়ে রাজত্ব করলেন: ");
INSERT INTO benobcv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","বিয়োরের ছেলে বেলা ইদোমের রাজা হলেন। তাঁর রাজধানীর নাম দেওয়া হল দিনহাবা। ");
INSERT INTO benobcv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","বেলা যখন মারা যান, বস্রানিবাসী সেরহের ছেলে যোবব তখন রাজারূপে তাঁর স্থলাভিষিক্ত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","যোবব যখন মারা যান, তৈমন দেশ থেকে আগত হূশম রাজারূপে তাঁর স্থলাভিষিক্ত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","হূশম যখন মারা যান, বেদদের ছেলে সেই হদদ তখন রাজারূপে তাঁর স্থলাভিষিক্ত হলেন, যিনি মোয়াব দেশে মিদিয়নীয়দের পরাজিত করলেন। তাঁর নগরের নাম দেওয়া হল অবীৎ। ");
INSERT INTO benobcv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","হদদ যখন মারা যান, মস্রেকানিবাসী সম্ল তখন রাজারূপে তাঁর স্থলাভিষিক্ত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","সম্ল যখন মারা যান, সেই নদীর নিকটবর্তী রহোবোৎ নিবাসী শৌল তখন রাজারূপে তাঁর স্থলাভিষিক্ত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","শৌল যখন মারা যান, অকবোরের ছেলে বায়াল-হানন তখন রাজারূপে তাঁর স্থলাভিষিক্ত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","অকবোরের ছেলে বায়াল-হানন যখন মারা যান, হদদ রাজারূপে তাঁর স্থলাভিষিক্ত হলেন। তাঁর নগরের নাম দেওয়া হল পায়ূ এবং তাঁর স্ত্রীর নাম মহেটবেল, যিনি মট্রেদের মেয়ে, ও মেষাহবের নাতনি ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","নামানুসারে, এবং তাদের বংশ ও অঞ্চল অনুসারে এরাই হলেন এষৌর বংশে জন্মানো বিভাগীয় প্রধান: তিম্ন, অলবা, যিথেৎ, ");
INSERT INTO benobcv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","অহলীবামা, এলা, পীনোন, ");
INSERT INTO benobcv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","কনস, তৈমন, মিবসর, ");
INSERT INTO benobcv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","মগ্‌দীয়েল ও ঈরম। তাদের অধিকৃত দেশে তাঁরা যে বসতি স্থাপন করলেন, তা অনুসারে এরাই ইদোমের দলপতি ছিলেন। এই হল ইদোমীয়দের পূর্বপুরুষ এষৌর বংশপরম্পরা। ");
INSERT INTO benobcv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","যাকোব সেই কনান দেশে, যেখানে তাঁর বাবা বসবাস করতেন, সেখানেই বসবাস করছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","এই হল যাকোবের বংশপরম্পরার বৃত্তান্ত। সতেরো বছর বয়স্ক এক যুবক যোষেফ, তাঁর সেই দাদাদের সঙ্গে পশুপাল চরাচ্ছিলেন, যাঁরা ছিলেন তাঁদের বাবার স্ত্রী বিলহা ও সিল্পার ছেলে, এবং তাঁদের কুকর্মের খবর যোষেফ তাঁদের বাবার কাছে পৌঁছে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ইস্রায়েল যোষেফকে তাঁর অন্য ছেলেদের থেকে বেশি ভালোবাসতেন, কারণ ইস্রায়েলের বৃদ্ধাবস্থায় যোষেফের জন্ম হয়েছিল; এবং ইস্রায়েল তাঁর জন্য একটি রংচঙে আলখাল্লা বানিয়ে দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","তাঁর দাদারা যখন দেখলেন যে তাঁদের বাবা যোষেফকে তাঁদের যে কোনো একজনের তুলনায় বেশি ভালোবাসেন, তখন তাঁরা তাঁকে ঘৃণা করলেন, এবং তাঁর উদ্দেশে তাঁরা কোনও প্রীতিকর কথা বলতে পারতেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","যোষেফ একটি স্বপ্ন দেখলেন এবং যখন তিনি সেটি তাঁর দাদাদের বললেন, তখন তাঁরা তাঁকে আরও বেশি ঘৃণা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","তিনি তাঁদের বললেন, “আমি যে স্বপ্নটি দেখেছি তা শোনো: ");
INSERT INTO benobcv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","আমরা যখন জমিতে শস্যের আঁটি বাঁধছিলাম তখন হঠাৎই আমার আঁটিটি উঠে দাঁড়াল, আর তোমাদের আঁটিগুলি আমার আঁটিটির চারপাশ ঘিরে সেটিকে প্রণাম জানাল।” ");
INSERT INTO benobcv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","তাঁর দাদারা তাঁকে বললেন, “তুমি কি আমাদের উপর রাজত্ব করতে চাও? তুমি কি সত্যিই আমাদের শাসন করবে?” তাঁর এই স্বপ্নের জন্য ও তিনি যা যা বললেন, সেজন্য তাঁরা তাঁকে আরও বেশি ঘৃণা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","পরে তিনি আরও একটি স্বপ্ন দেখলেন, এবং সেটি তিনি তাঁর দাদাদের বললেন। “শোনো,” তিনি বললেন, “আমি আরও একটি স্বপ্ন দেখেছি, এবং এবার সূর্য ও চন্দ্র ও এগারোটি তারা আমাকে প্রণাম করছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","তিনি যখন তাঁর বাবাকে ও একইসাথে তাঁর দাদাদেরও তা বললেন, তখন তাঁর বাবা তাঁকে ভর্ৎসনা করে বললেন, “তুমি এ কী ধরনের স্বপ্ন দেখলে? তোমার মা, আমি ও তোমার দাদারা কি সত্যিই তোমার কাছে এসে মাটিতে মাথা ঠেকিয়ে তোমাকে প্রণাম করব?” ");
INSERT INTO benobcv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","তাঁর দাদারা তাঁর প্রতি ঈর্ষাপরায়ণ হলেন, কিন্তু তাঁর বাবা এই বিষয়টি মনে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","তাঁর দাদারা শিখিমের কাছে তাঁদের বাবার পশুপাল চরাতে গেলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","এবং ইস্রায়েল যোষেফকে বললেন, “তুমি তো জানো, তোমার দাদারা শিখিমের কাছে পশুপাল চরাচ্ছে। এসো, আমি তোমাকে তাদের কাছে পাঠাতে যাচ্ছি।” “খুব ভালো,” তিনি উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","অতএব তিনি যোষেফকে বললেন, “যাও ও দেখো পশুপালের সাথে সাথে তোমার দাদারাও সব ঠিকঠাক আছে কি না, এবং আমার কাছে খবর নিয়ে এসো।” পরে তিনি তাঁকে হিব্রোণ উপত্যকা থেকে পাঠিয়ে দিলেন। যোষেফ যখন শিখিমে পৌঁছালেন, ");
INSERT INTO benobcv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","তখন একজন লোক তাঁকে মাঠেঘাটে ঘোরাঘুরি করতে দেখে তাঁকে জিজ্ঞাসা করল, “তুমি কার খোঁজ করছ?” ");
INSERT INTO benobcv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","তিনি উত্তর দিলেন, “আমি আমার দাদাদের খুঁজছি। তুমি কি বলতে পারবে কোথায় তাঁরা তাঁদের পশুপাল চরাচ্ছেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“তাঁরা এখান থেকে সামনে এগিয়ে গিয়েছেন,” লোকটি উত্তর দিল। “আমি তাঁদের বলতে শুনেছি, ‘চলো, দোথনে যাই।’ ” অতএব যোষেফ তাঁর দাদাদের অনুসরণ করলেন ও দোথনের কাছে তাঁদের খুঁজে পেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","কিন্তু তাঁরা দূর থেকেই তাঁকে দেখতে পেলেন, এবং তিনি তাঁদের কাছে পৌঁছানোর আগেই, তাঁরা তাঁকে হত্যা করার পরিকল্পনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“সেই স্বপ্নদর্শী আসছে!” তাঁরা একে অপরকে বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“এখন এসো, আমরা তাকে হত্যা করি ও এখানে যে জলাশয়গুলি আছে তার মধ্যে একটিতে তাকে ফেলে দিই এবং বলি যে হিংস্র কোনো পশু তাকে গিলে ফেলেছে। পরে আমরা দেখব তার স্বপ্নের কী হয়।” ");
INSERT INTO benobcv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","রূবেণ যখন তা শুনলেন, তখন তিনি তাঁদের হাত থেকে যোষেফকে রক্ষা করতে চাইলেন। “আমরা যেন তাকে হত্যা না করি,” তিনি বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","“কোনও রক্তপাত কোরো না। এই মরুপ্রান্তরে তাকে এই জলাশয়ের মধ্যে ফেলে দাও, কিন্তু তার গায়ে হাত দিয়ো না।” যোষেফকে তাঁদের হাত থেকে রক্ষা করার ও তাঁকে তাঁর বাবার কাছে ফিরিয়ে দেওয়ার জন্যই রূবেণ তা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","অতএব যোষেফ যখন তাঁর দাদাদের কাছে এলেন, তখন তাঁরা তাঁর সেই আলখাল্লাটি—তাঁর পরনের সেই রংচঙে আলখাল্লাটি—খুলে নিলেন ");
INSERT INTO benobcv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","এবং তাঁরা তাঁকে ধরে সেই জলাশয়ের মধ্যে ছুঁড়ে ফেলে দিলেন। জলাশয়টি খালি ছিল; তাতে জল ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","খাবার খেতে বসামাত্রই তারা মুখ তুলে তাকালেন এবং দেখতে পেলেন গিলিয়দ থেকে ইশ্মায়েলীয়দের একটি কাফেলা এগিয়ে আসছে। তাদের উটগুলি মশলাপাতি, সুগন্ধি মলম ও গন্ধরসে বোঝাই ছিল এবং তারা সেগুলি মিশরের উদ্দেশে নিয়ে যাচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","যিহূদা তাঁর দাদা-ভাইদের বললেন, “আমাদের ভাইকে হত্যা করে ও তার রক্ত লুকিয়ে রেখে আমাদের কী লাভ হবে? ");
INSERT INTO benobcv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","এসো, আমরা বরং তাকে ইশ্মায়েলীয়দের কাছে বিক্রি করে দিই ও তার গায়ে হাত না দিই; যতই হোক, সে তো আমাদেরই ভাই, আমাদের নিজেদের রক্ত ও মাংস।” তাঁর দাদা-ভাইরাও একমত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","অতএব মিদিয়নীয় ব্যবসায়ীরা যখন সেখানে পৌঁছাল, যোষেফের দাদারা তাঁকে সেই জলাশয় থেকে টেনে তুললেন এবং সেই ইশ্মায়েলীয়দের কাছে কুড়ি শেকল রুপোর বিনিময়ে তাঁকে বিক্রি করে দিলেন, যারা তাঁকে মিশরে নিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","রূবেণ যখন সেই জলাশয়ের কাছে ফিরে এসে দেখতে পেলেন যে যোষেফ সেখানে নেই, তখন তিনি নিজের পোশাক ছিঁড়ে ফেললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","তিনি তাঁর ভাইদের কাছে গিয়ে বললেন, “ছেলেটি তো সেখানে নেই! আমি এখন কোথায় যাব?” ");
INSERT INTO benobcv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","তখন তাঁরা যোষেফের আলখাল্লাটি নিয়ে, একটি ছাগল জবাই করলেন এবং সেই আলখাল্লাটি রক্তে চুবিয়ে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","তাঁরা সেই রংচঙে আলখাল্লাটি তাঁদের বাবার কাছে ফিরিয়ে নিয়ে গিয়ে বললেন, “আমরা এটি খুঁজে পেয়েছি। পরীক্ষা করে দেখুন এটি আপনার ছেলেরই আলখাল্লা কি না।” ");
INSERT INTO benobcv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","তিনি সেটি চিনতে পেরে বললেন, “এটি আমার ছেলেরই আলখাল্লা! কোনো হিংস্র জন্তু তাকে গিলে ফেলেছে। যোষেফকে নিশ্চয় টুকরো টুকরো করে ফেলা হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","তখন যাকোব তাঁর পোশাক ছিঁড়ে ফেলে দিলেন, গুনচট গায়ে দিলেন ও তাঁর ছেলের জন্য অনেক দিন ধরে শোক পালন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","তাঁর সব ছেলেমেয়ে তাঁকে সান্তনা দিতে এলেন, কিন্তু তিনি সান্তনা পেতে চাননি। “না,” তিনি বললেন, “যতদিন না পর্যন্ত আমি কবরে গিয়ে আমার ছেলের সঙ্গে মিলিত হচ্ছি, আমি শোক পালন করেই যাব।” অতএব তাঁর বাবা তাঁর জন্য কান্নাকাটি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ইতিমধ্যে, মিদিয়নীয়রা যোষেফকে মিশরে ফরৌণের রাজকর্মকর্তা, পাহারাদারদের দলপতি পোটিফরের কাছে বিক্রি করে দিল। ");
INSERT INTO benobcv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","সেই সময় যিহূদা তাঁর দাদা-ভাইদের ছেড়ে হীরা নামক অদুল্লম নিবাসী একজন লোকের সঙ্গে থাকতে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","সেখানে যিহূদা শূয় নামক কনানীয় একজন লোকের মেয়ের দেখা পেলেন। তিনি তাকে বিয়ে করলেন ও তাকে প্রণয়জ্ঞাপনও করলেন; ");
INSERT INTO benobcv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","সে অন্তঃসত্ত্বা হয়ে পড়ল ও এক ছেলের জন্ম দিল, যার নাম রাখা হল এর। ");
INSERT INTO benobcv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","সে আবার গর্ভবতী হল ও এক ছেলের জন্ম দিল, ও তার নাম রাখল ওনন। ");
INSERT INTO benobcv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","সে আরও এক ছেলের জন্ম দিল ও তার নাম রাখল শেলা। শেলার জন্মের সময় তাঁরা কষীবেই বসবাস করতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","যিহূদা তাঁর বড়ো ছেলে এরের জন্যে এক স্ত্রী এনেছিলেন, তার নাম তামর। ");
INSERT INTO benobcv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","কিন্তু যিহূদার বড়ো ছেলে এর, সদাপ্রভুর দৃষ্টিতে দুষ্ট ছিল; তাই সদাপ্রভু তাকে মেরে ফেললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","পরে যিহূদা ওননকে বললেন, “তোমার দাদার স্ত্রীর সঙ্গে শুয়ে পড়ো এবং তোমার দাদার হয়ে সন্তানের জন্ম দেওয়ার জন্য তার প্রতি তোমার দায়িত্ব পালন করো।” ");
INSERT INTO benobcv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","কিন্তু ওনন জানত যে সেই সন্তানটি তার নিজের হবে না, তাই যখনই সে তার দাদার স্ত্রীর সাথে শুতো, সে তার বীর্য মাটিতে ফেলে দিত, যেন তাকে তার দাদার হয়ে কোনও সন্তানের জন্ম দিতে না হয়। ");
INSERT INTO benobcv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","সে যা করল তা সদাপ্রভুর দৃষ্টিতে অপকর্মরূপে গণ্য হল; তাই সদাপ্রভু তাকেও মেরে ফেললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","যিহূদা তখন তাঁর পুত্রবধূ তামরকে বললেন, “আমার ছেলে শেলা যতদিন না বড়ো হচ্ছে, ততদিন তুমি তোমার বাবার ঘরে গিয়ে বিধবার মতো হয়ে থাকো।” কারণ তিনি ভাবলেন, “সেও হয়তো তার দাদাদের মতো মারা যাবে।” অতএব তামর তার বাবার ঘরে থাকতে চলে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","বেশ কিছুকাল পর শূয়ের সেই মেয়ে, যিহূদার স্ত্রী মারা গেল। যিহূদা যখন তাঁর মর্মযন্ত্রণা কাটিয়ে উঠলেন, তখন তিনি তিম্নায় সেই লোকজনের কাছে উঠে গেলেন, যারা তাঁর মেষগুলির লোম ছাঁটছিল, এবং তাঁর বন্ধু অদুল্লমীয় হীরাও তাঁর সঙ্গে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","যখন তামরকে বলা হল, “তোমার শ্বশুরমশাই তাঁর মেষগুলির লোম ছাঁটার জন্য তিম্নার উদ্দেশে রওনা দিয়েছেন,” ");
INSERT INTO benobcv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","তখন সে তার বৈধব্য-বস্ত্রটি খুলে ফেলল, ছদ্মবেশ ধারণের জন্য ঘোমটায় মুখ ঢাকল, এবং পরে সেই ঐনয়িমের প্রবেশদ্বারে গিয়ে বসল, যা তিম্নায় যাওয়ার পথেই পড়ে। কারণ সে দেখল যে, যদিও শেলা এখন বেড়ে উঠেছে, তবুও তার স্ত্রীরূপে তাকে তার হাতে তুলে দেওয়া হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","যিহূদা যখন তাকে দেখলেন, তখন তিনি ভাবলেন যে সে একজন বেশ্যা, কারণ সে তার মুখ ঢেকে রেখেছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","সে যে তাঁর পুত্রবধূ, একথা না বুঝেই তিনি রাস্তার ধারে তার কাছে গিয়ে বললেন, “এবার এসো, আমি তোমার সঙ্গে শুয়ে পড়ি।” “আর আপনার সঙ্গে শোয়ার জন্য আপনি আমাকে কী দেবেন?” সে জিজ্ঞাসা করল। ");
INSERT INTO benobcv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“আমার পশুপাল থেকে একটি ছাগশাবক আমি তোমার কাছে পাঠিয়ে দেব,” তিনি বললেন। “যতদিন না আপনি আমার কাছে সেটি পাঠাচ্ছেন, ততদিন আপনি কি জামানতরূপে আমাকে কিছু দেবেন?” সে জিজ্ঞাসা করল। ");
INSERT INTO benobcv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","তিনি বললেন, “জামানতরূপে তোমাকে আমি কী দেব?” “আপনার সিলমোহর ও সেটির সুতো, ও আপনার হাতের লাঠিটি,” সে উত্তর দিল। অতএব তিনি তাকে সেগুলি দিলেন ও তাঁর সঙ্গে শুলেন, এবং সে তাঁর দ্বারা অন্তঃসত্ত্বা হয়ে পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","সেখান থেকে চলে যাওয়ার পর, সে তার ওড়নাটি খুলে ফেলল এবং আবার তার বৈধব্য-বস্ত্রটি পরে নিল। ");
INSERT INTO benobcv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ইতিমধ্যে যিহূদা সেই মহিলাটির কাছ থেকে তাঁর জামানতটি ফিরে পাওয়ার লক্ষ্যে তাঁর সেই অদুল্লমীয় বন্ধুর মাধ্যমে সেই ছাগশাবকটি পাঠিয়ে দিলেন, কিন্তু তিনি তাকে খুঁজে পাননি। ");
INSERT INTO benobcv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","সেখানে বসবাসকারী লোকজনকে তিনি জিজ্ঞাসা করলেন, “ঐনয়িমের রাস্তার ধারে যে দেবদাসীটি ছিল, সে কোথায়?” তারা বলল, “এখানে কোনও দেবদাসী থাকে না।” ");
INSERT INTO benobcv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","অতএব তিনি যিহূদার কাছে ফিরে গেলেন ও বললেন, “আমি তাকে খুঁজে পাইনি। এছাড়াও, সেখানে বসবাসকারী লোকজনও বলল, ‘এখানে কোনও দেবদাসী থাকে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","তখন যিহূদা বললেন, “তার কাছে যা আছে তা সে রেখে দিক, তা না হলে আমাদের এক হাসির খোরাক হতে হবে। যাই হোক না কেন, আমি তো এই ছাগশাবকটি তার কাছে পাঠিয়েছিলাম, কিন্তু তুমি তাকে খুঁজে পাওনি।” ");
INSERT INTO benobcv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","প্রায় তিন মাস পর যিহূদাকে বলা হল, “আপনার পুত্রবধূ তামর বেশ্যাবৃত্তির অপরাধ করেছে, এবং পরিণামস্বরূপ এখন সে অন্তঃসত্ত্বা হয়ে পড়েছে।” যিহূদা বললেন, “তাকে বের করে আনো ও আগুনে পুড়িয়ে মারো!” ");
INSERT INTO benobcv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","তাকে যখন বের করে আনা হচ্ছিল, সে তখন তার শ্বশুরের কাছে একটি খবর পাঠিয়েছিল। “যিনি এগুলির মালিক, তাঁর দ্বারাই আমি অন্তঃসত্ত্বা হয়েছি,” সে বলল। আর সে এও বলল, “দেখুন তো, এই সিলমোহর ও সুতো এবং লাঠিটি কার তা আপনি চিনতে পারেন কি না।” ");
INSERT INTO benobcv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","যিহূদা সেগুলি চিনতে পেরে বললেন, “সে আমার থেকে বেশি ধার্মিক, যেহেতু আমি তাকে আমার ছেলে শেলার হাতে তুলে দিইনি।” তিনি আর কখনও তামরের সঙ্গে শয়ন করেননি। ");
INSERT INTO benobcv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","যখন তামরের প্রসবকাল এসে উপস্থিত হল, তখন দেখা গেল তার গর্ভে যমজ ছেলে। ");
INSERT INTO benobcv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","যখন সে সন্তান প্রসব করছিল, তাদের মধ্যে একজন তার হাত বাইরে বের করল; অতএব ধাত্রী টকটকে লাল রংয়ের সুতো নিয়ে সেটি তার কব্জিতে বেঁধে দিল ও বলল, “এই প্রথমে বের হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","কিন্তু সে যখন তার হাতটি টেনে নিল, তখন তার ভাই বের হয়ে এল, ও ধাত্রী বলল, “অতএব তুমি এভাবেই আবির্ভূত হয়েছ!” আর তার নাম রাখা হল পেরস। ");
INSERT INTO benobcv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","পরে তার সেই ভাই বের হয়ে এল, যার কব্জিতে টকটকে লাল রংয়ের সুতো বাঁধা ছিল। আর তার নাম রাখা হল সেরহ। ");
INSERT INTO benobcv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","যোষেফকে মিশরে নিয়ে যাওয়া হল। পোটিফর বলে একজন মিশরীয়, যিনি ফরৌণের রাজকর্মকর্তাদের মধ্যে একজন তথা পাহারাদারদের দলপতি ছিলেন, তিনি তাঁকে সেই ইশ্মায়েলীয়দের কাছ থেকে কিনে নিয়েছিলেন, যারা তাঁকে মিশরে নিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","সদাপ্রভু যোষেফের সঙ্গে ছিলেন তাই তিনি সাফল্য পেলেন, এবং তিনি তাঁর মিশরীয় প্রভুর বাড়িতে বসবাস করতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","তাঁর প্রভু যখন দেখলেন যে সদাপ্রভু তাঁর সঙ্গে আছেন এবং তিনি যা যা করেন সবেতেই সদাপ্রভু তাঁকে সফলতা দেন, ");
INSERT INTO benobcv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","তখন যোষেফ তাঁর দৃষ্টিতে অনুগ্রহ লাভ করলেন ও তাঁর সেবক হয়ে গেলেন। পোটিফর তাঁকে নিজের পরিবারের দেখাশোনার দায়িত্ব দিলেন, এবং তাঁর মালিকানাধীন সবকিছু দেখাশোনার দায়িত্বও তাঁকে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","যে সময় থেকে তিনি যোষেফকে তাঁর পরিবারের ও তাঁর মালিকানাধীন সবকিছুর দায়িত্ব দিলেন, সদাপ্রভু যোষেফের জন্য সেই মিশরীয়ের পরিবারকে আশীর্বাদ করলেন। বাড়িতে ও জমিতে, পোটিফরের যা যা ছিল, সে সবকিছুর উপর সদাপ্রভুর আশীর্বাদ বর্তে ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","অতএব পোটিফর তাঁর সবকিছু দেখাশোনার দায়িত্ব যোষেফের উপর ছেড়ে দিলেন; যোষেফ সেই দায়িত্ব সামলানোর সময়, তিনি যে যে খাবারদাবার খেতেন সেগুলি ছাড়া তিনি আর কোনো বিষয়ে চিন্তা করতেন না। যোষেফ শক্তপোক্ত ও সুদর্শন পুরুষ ছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","এবং কিছুকাল পর তার প্রভু-পত্নীর দৃষ্টি যোষেফের উপর গিয়ে পড়ল ও সে বলল, “আমার সাথে বিছানায় এসো!” ");
INSERT INTO benobcv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","কিন্তু তিনি সেই প্রস্তাব প্রত্যাখ্যান করলেন। “আমাকে দায়িত্ব দিয়ে,” তিনি তাকে বললেন, “আমার প্রভু বাড়ির কোনও বিষয়েই আর মাথা ঘামান না; তাঁর মালিকানাধীন সবকিছুই তিনি আমার দায়িত্বে ছেড়ে দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","এই বাড়িতে আমার চেয়ে বড়ো আর কেউ নেই। আপনাকে ছাড়া আর কোনো কিছুই আমার প্রভু আমার কাছ থেকে দূরে সরিয়ে রাখেননি, কারণ আপনি যে তাঁর স্ত্রী। তবে কীভাবে আমি এ ধরনের জঘন্য কাজ এবং ঈশ্বরের বিরুদ্ধে পাপ করব?” ");
INSERT INTO benobcv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","আর যদিও সেই মহিলা দিনের পর দিন যোষেফকে একই কথা বলে যাচ্ছিল, তবুও তিনি তাঁর সাথে বিছানায় যেতে অস্বীকার করলেন; এমনকি তিনি তাঁর সঙ্গে থাকতেও চাইলেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","একদিন তিনি নিজের দায়িত্ব পালন করার জন্য বাড়ির ভিতরে গেলেন, এবং পারিবারিক দাস-দাসীদের মধ্যে কেউই তখন ভিতরে ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","তাঁর প্রভু-পত্নী তাঁর আলখাল্লা টেনে ধরে বলল, “আমার সাথে বিছানায় এসো!” কিন্তু তিনি তার হাতে নিজের আলখাল্লাটি ছেড়ে দিয়ে বাড়ি থেকে পালিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","যখন সে দেখল যে যোষেফ তার হাতে নিজের আলখাল্লাটি ছেড়ে দিয়ে বাড়ি থেকে পালিয়ে গিয়েছেন, ");
INSERT INTO benobcv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","তখন সে তার পারিবারিক দাস-দাসীদের ডাক দিল। “দেখো,” সে তাদের বলল, “এই হিব্রুটিকে আমাদের সঙ্গে ফুর্তি করার জন্য আনা হয়েছে! সে এখানে ভিতরে এসে আমার সঙ্গে শুতে চেয়েছিল, কিন্তু আমি চিৎকার করে উঠেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","যখন সে শুনল আমি সাহায্য পাওয়ার জন্য চিৎকার করছি, তখন সে আমার পাশে তার আলখাল্লাটি ছেড়ে দিয়ে বাড়ি থেকে পালিয়ে গেল।” ");
INSERT INTO benobcv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","তাঁর প্রভু ঘরে না ফেরা পর্যন্ত সেই মহিলাটি তাঁর আলখাল্লাটি নিজের পাশে রেখে দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","পরে সে পোটিফরকে এই গল্পটি বলে শোনাল: “যে হিব্রু ক্রীতদাসটিকে তুমি এনেছিলে, সে আমার সঙ্গে ফুর্তি করার জন্য আমার কাছে এসেছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","কিন্তু যেই না আমি সাহায্যের জন্য চিৎকার করে উঠেছিলাম, সে আমার পাশে তার আলখাল্লাটি ছেড়ে দিয়ে পালিয়েছিল।” ");
INSERT INTO benobcv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“তোমার ক্রীতদাসটি আমার সঙ্গে এই ধরনের ব্যবহার করেছে,” এই গল্পটি যখন যোষেফের প্রভু-পত্নী তাঁর প্রভুকে বলে শোনাল, তখন তিনি রাগে অগ্নিশর্মা হয়ে উঠলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","যোষেফের প্রভু যোষেফকে ধরে সেই জেলখানায় পুরে দিলেন, যেখানে রাজার কয়েদিদের বন্দি করে রাখা হত। কিন্তু যোষেফ যখন সেই জেলখানায় ছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","সদাপ্রভু তখন তাঁর সঙ্গেই ছিলেন; তিনি তাঁকে দয়া দেখালেন ও সেই জেল-রক্ষকের দৃষ্টিতে তাঁকে অনুগ্রহ পেতেও দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","অতএব সেই জেল-রক্ষক যোষেফকে জেলের সব বন্দির তত্ত্বাবধায়ক করে দিলেন, এবং সেখানে যা যা কাজকর্ম হত, সেসবের দায়িত্বও তাঁকে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","যোষেফের তত্ত্বাবধানে যা কিছু ছিল, তার কোনোটির প্রতিই সেই রক্ষক মনোযোগ দিতেন না, কারণ সদাপ্রভু যোষেফের সঙ্গে ছিলেন ও তিনি যা কিছু করতেন, সবেতেই তিনি তাঁকে সাফল্য দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","কিছুকাল পর, মিশরের রাজার পানপাত্র বহনকারী ও রুটিওয়ালা তাদের প্রভুকে, মিশরের রাজাকে অসন্তুষ্ট করল। ");
INSERT INTO benobcv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ফরৌণ তাঁর সেই দুই কর্মকর্তার, প্রধান পানপাত্র বহনকারী ও প্রধান রুটিওয়ালার প্রতি ক্রুদ্ধ হলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","এবং যে জেলখানায় যোষেফ বন্দি ছিলেন, সেখানে পাহারাদারদের দলপতির হেফাজতেই তাদের রেখে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","পাহারাদারদের দলপতি তাদের দেখাশোনার দায়িত্ব যোষেফকে দিলেন, এবং তিনি তাদের পরিচর্যা করলেন। তারা কিছুকাল সেখানে বন্দি থাকার পর, ");
INSERT INTO benobcv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","দুজনের প্রত্যেকেই—যাদের জেলখানায় বন্দি করে রাখা হয়েছিল, মিশরের রাজার সেই পানপাত্র বহনকারী ও রুটিওয়ালা—একই রাতে একটি করে স্বপ্ন দেখল, এবং প্রত্যেকটি স্বপ্নেরই নিজস্ব অর্থ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","পরদিন সকালে যোষেফ যখন তাদের কাছে এলেন, তখন তিনি দেখলেন যে তারা দুজনেই বিমর্ষ হয়ে আছে। ");
INSERT INTO benobcv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","অতএব ফরৌণের যে কর্মকর্তারা তাঁর প্রভুর বাড়িতে তাঁর সঙ্গে বন্দি অবস্থায় ছিল, তাদের তিনি জিজ্ঞাসা করলেন, “আজ আপনাদের এত দুঃখিত দেখাচ্ছে কেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“আমরা দুজনেই স্বপ্ন দেখেছি,” তারা উত্তর দিল, “কিন্তু সেগুলি ব্যাখ্যা করে দেওয়ার কেউ নেই।” তখন যোষেফ তাদের বললেন, “ব্যাখ্যা করার মালিক কি ঈশ্বর নন? আপনাদের স্বপ্নগুলি আমায় বলুন।” ");
INSERT INTO benobcv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","অতএব প্রধান পানপাত্র বহনকারী যোষেফকে তার স্বপ্নটি বলল। সে তাঁকে বলল, “আমার স্বপ্নে আমার সামনে আমি একটি দ্রাক্ষালতা দেখলাম, ");
INSERT INTO benobcv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","এবং সেই দ্রাক্ষালতায় তিনটি শাখা ছিল। সেটিতে কুঁড়ি ফোটামাত্র ফুলও ফুটে উঠল, এবং সেটির গুচ্ছগুলি পাকা দ্রাক্ষাফলে পরিণত হল। ");
INSERT INTO benobcv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ফরৌণের পানপাত্রটি আমার হাতে ছিল, এবং আমি সেই দ্রাক্ষাফলগুলি নিয়ে সেগুলি ফরৌণের পানপাত্রে নিংড়ে দিলাম এবং পানপাত্রটি তাঁর হাতে তুলে দিলাম।” ");
INSERT INTO benobcv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","“এই হল এর অর্থ,” যোষেফ তাকে বললেন। “তিনটি শাখা হল তিন দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","তিনদিনের মধ্যে ফরৌণ আপনার মাথা উন্নত করবেন ও আপনাকে আপনার পদে পুনর্বহাল করবেন, এবং আপনি ফরৌণের হাতে তাঁর পানপাত্রটি তুলে দেবেন, ঠিক যেভাবে আপনি তাঁর পানপাত্র বহনকারী থাকার সময় করতেন। ");
INSERT INTO benobcv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","কিন্তু সবকিছু যখন আপনার ক্ষেত্রে ঠিকঠাক হয়ে যাবে, তখন আপনি আমায় মনে রাখবেন ও আমার প্রতি দয়া দেখাবেন; ফরৌণের কাছে আমার কথা বলবেন এবং আমাকে এই জেলখানা থেকে মুক্ত করবেন। ");
INSERT INTO benobcv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","হিব্রুদের দেশ থেকে আমাকে জোর করে ধরে আনা হয়েছে এবং এমনকি এখানেও আমি এমন কোনও কিছু করিনি যে কারণে আমাকে অন্ধকূপে থাকতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","যখন প্রধান রুটিওয়ালা দেখল যে যোষেফ এক যথাযথ ব্যাখ্যা দিয়েছেন, তখন তিনি যোষেফকে বললেন, “আমিও একটি স্বপ্ন দেখেছি: আমার মাথায় তিন ঝুড়ি রুটি রাখা ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","একদম উপরের ঝুড়িটিতে ফরৌণের জন্য সব ধরনের সেঁকা খাবারদাবার ছিল, কিন্তু পাখিরা আমার মাথায় রাখা সেই ঝুড়ি থেকে সেগুলি খেয়ে নিচ্ছিল।” ");
INSERT INTO benobcv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","“এই হল এর অর্থ,” যোষেফ বললেন। “সেই তিনটি ঝুড়ি হল তিন দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","তিনদিনের মধ্যে ফরৌণ আপনার মাথা কেটে ফেলবেন ও আপনার দেহটি শূলে চড়াবেন। আর পাখিরা আপনার মাংস খুবলে খুবলে খাবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","তৃতীয় দিনটি ছিল ফরৌণের জন্মদিন, এবং তিনি তাঁর সব কর্মকর্তার জন্য এক ভোজসভার আয়োজন করলেন। তাঁর সব কর্মকর্তার উপস্থিতিতে তিনি তাঁর প্রধান পানপাত্র বহনকারী ও প্রধান রুটিওয়ালার মাথা উন্নত করলেন: ");
INSERT INTO benobcv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","প্রধান পানপাত্র বহনকারীকে তিনি তাঁর পদে পুনর্বহাল করলেন, যেন তিনি আরও একবার ফরৌণের হাতে পানপাত্রটি তুলে দিতে পারেন— ");
INSERT INTO benobcv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","কিন্তু প্রধান রুটিওয়ালাকে তিনি শূলে চড়ালেন, ঠিক যেমনটি যোষেফ তাঁর ব্যাখ্যায় তাদের বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","প্রধান পানপাত্র বহনকারী, অবশ্য, যোষেফকে মনে রাখেনি; সে তাঁকে ভুলে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","সম্পূর্ণ দুই বছর যখন পার হয়ে গেল, তখন ফরৌণ একটি স্বপ্ন দেখলেন: তিনি নীলনদের কূলে দাঁড়িয়েছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","পরে নদী থেকে সাতটি মসৃণ ও হৃষ্টপুষ্ট গরু উঠে এল, এবং সেগুলি নলখাগড়ার বনে চরছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","এগুলির পরে অন্য আরও সাতটি কুৎসিতদর্শন ও অস্থিচর্মসার গরু, নীলনদ থেকে উঠে এল ও নদীর কূলে চরা সেই গরুগুলির পাশে এসে দাঁড়াল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","আর যে গরুগুলি কুৎসিত ও অস্থিচর্মসার ছিল, সেগুলি মসৃণ ও হৃষ্টপুষ্ট গরুগুলিকে গিলে ফেলল। পরে ফরৌণ জেগে উঠলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","তিনি আবার ঘুমিয়ে পড়লেন ও দ্বিতীয় একটি স্বপ্ন দেখলেন: সাতটি স্বাস্থ্যকর ও সুন্দর শস্যদানার শিষ একটিমাত্র বৃন্তে বেড়ে উঠছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","সেগুলির পরে, আরও সাতটি শস্যদানার শিষ—কৃষকায় ও পূর্বীয় বায়ু দ্বারা ঝলসিত শিষ অঙ্কুরিত হল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","সেই সাতটি কৃষকায় শিষ সাতটি স্বাস্থ্যকর, পূর্ণ শিষকে গিলে ফেলল। পরে ফরৌণ জেগে উঠলেন; তা এক স্বপ্ন ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","সকালবেলায় তাঁর মন অস্থির হয়ে পড়ল, তাই তিনি মিশরের সব জাদুকর ও জ্ঞানীগুণী মানুষজনকে ডেকে পাঠালেন। ফরৌণ তাঁর স্বপ্নের কথা তাঁদের বললেন, কিন্তু কেউই সেগুলি তাঁর জন্য ব্যাখ্যা করে দিতে পারলেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","তখন সেই প্রধান পানপাত্র বহনকারী ফরৌণকে বলল, “আমার ত্রুটি-বিচ্যূতির কথা আজ আমার মনে পড়ছে। ");
INSERT INTO benobcv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ফরৌণ একবার তাঁর দাসদের উপর ক্রুদ্ধ হয়েছিলেন, এবং তিনি আমাকে ও প্রধান রুটিওয়ালাকে পাহারাদারদের দলপতির বাড়িতে বন্দি করে রেখেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","একই রাতে আমরা দুজনেই একটি করে স্বপ্ন দেখেছিলাম, এবং প্রত্যেকটি স্বপ্নেরই নিজস্ব এক অর্থ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","সেখানে পাহারাদারদের দলপতির দাস, এক হিব্রু যুবক আমাদের সঙ্গেই ছিল। আমরা তাকে আমাদের স্বপ্নগুলি বলেছিলাম, এবং সে আমাদের জন্য সেগুলি ব্যাখ্যা করে দিয়েছিল, প্রত্যেককে তার স্বপ্নের অর্থ জানিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","আর যেভাবে সে আমাদের কাছে সেগুলি ব্যাখ্যা করে দিয়েছিল, ঠিক সেভাবেই তা ঘটল: আমি আমার পদে পুনর্বহাল হলাম, এবং অন্যজনকে শূলে চড়ানো হল।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","অতএব ফরৌণ যোষেফকে ডেকে পাঠালেন, এবং তাঁকে তাড়াতাড়ি অন্ধকূপ থেকে নিয়ে আসা হল। চুল-দাড়ি কামিয়ে ও পোশাক পরিবর্তন করে তিনি ফরৌণের সামনে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ফরৌণ যোষেফকে বললেন, “আমি একটি স্বপ্ন দেখেছি, এবং কেউই সেটির ব্যাখ্যা করতে পারছে না। কিন্তু আমি তোমার বিষয়ে শুনেছি যে তুমি যখন কোনও স্বপ্নের কথা শোনো, তখন তা ব্যাখ্যা করে দিতে পারো।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","“আমি তা করতে পারি না,” যোষেফ ফরৌণকে উত্তর দিলেন, “কিন্তু ফরৌণের ইচ্ছানুসারে ঈশ্বরই তাঁকে উত্তর দেবেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","তখন ফরৌণ যোষেফকে বললেন, “আমার স্বপ্নে আমি যখন নীলনদের কূলে দাঁড়িয়েছিলাম, ");
INSERT INTO benobcv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","তখন নদী থেকে সাতটি হৃষ্টপুষ্ট ও মসৃণ গরু উঠে এল, এবং সেগুলি নলখাগড়ার বনে চরছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","সেগুলির পিছু পিছু, অন্য সাতটি গরু উঠে এল—অস্থিসার ও খুব কুৎসিত এবং কৃষকায়। সমগ্র মিশর দেশে আমি এরকম কুৎসিত গরু কখনও দেখিনি। ");
INSERT INTO benobcv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","সেই কৃষকায়, কুৎসিত গরুগুলি সেই সাতটি হৃষ্টপুষ্ট গরুকে খেয়ে ফেলল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","কিন্তু সেগুলি খেয়ে ফেলার পরও, কেউই বলতে পারেনি যে তারাই এ কাজ করেছিল; আগের মতো তখনও সেগুলিকে কুৎসিতই দেখাচ্ছিল। পরে আমি জেগে উঠলাম। ");
INSERT INTO benobcv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“আমার স্বপ্নে আমি একই বৃন্তে বেড়ে ওঠা শস্যদানার সাতটি পূর্ণ ও স্বাস্থ্যকর শিষ দেখেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","সেগুলির পিছু পিছু, আরও সাতটি শিষ অঙ্কুরিত হল—শুকনো ও কৃষকায় ও পূর্বীয় বায়ু দ্বারা ঝলসিত। ");
INSERT INTO benobcv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","শস্যদানার সেই কৃষকায় শিষগুলি সেই সাতটি সুন্দর শিষকে গিলে ফেলল। আমি একথা জাদুকরদের বললাম, কিন্তু তাদের মধ্যে কেউই আমার কাছে তা ব্যাখ্যা করে দিতে পারেনি।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","তখন যোষেফ ফরৌণকে বললেন, “ফরৌণের স্বপ্নগুলি এক ও অনুরূপ। ঈশ্বর ফরৌণের কাছে প্রকাশ করে দিয়েছেন তিনি কী করতে চলেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","সাতটি সুন্দর গরু হল সাত বছর এবং সাতটি সুন্দর শস্যদানার শিষ হল সাত বছর; এ হল এক ও অনুরূপ স্বপ্ন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","যে সাতটি কৃষকায়, কুৎসিত গরু পরে উঠে এল সেগুলি সাত বছর, এবং পূর্বীয় বায়ু দ্বারা ঝলসিত শস্যদানার সাতটি রুগ্ন অখাদ্য শিষও তাই: সেগুলি হল সাত বছরের দুর্ভিক্ষ। ");
INSERT INTO benobcv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“আমি ফরৌণকে যেমনটি বললাম তা ঠিক এরকম: ঈশ্বর যা করতে চলেছেন তা তিনি ফরৌণকে দেখিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","মিশর দেশে অতিপ্রাচুর্যময় সাতটি বছর আসতে চলেছে, ");
INSERT INTO benobcv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","কিন্তু তার পিছু পিছু দুর্ভিক্ষকবলিত সাতটি বছর আসবে। তখন মিশরের সব প্রাচুর্য মানুষ ভুলে যাবে, এবং দুর্ভিক্ষ দেশটিকে ধ্বংস করে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","দেশের প্রাচুর্যকে কেউ মনে রাখবে না, কারণ যে দুর্ভিক্ষ সেটির পিছু পিছু আসতে চলেছে তা খুব ভয়াবহ হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ফরৌণকে দুটি আকারে স্বপ্নটি দেওয়ার কারণ হল এই যে বিষয়টি ঈশ্বর দ্বারা অটলভাবে নিশ্চিত হয়ে আছে, এবং অচিরেই ঈশ্বর তা বাস্তবায়িত করবেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“আর এখন ফরৌণ একজন বিচক্ষণ ও বুদ্ধিমান লোক খুঁজে বের করুন এবং তার হাতে মিশর দেশের দায়িত্ব তুলে দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","প্রাচুর্যময় সাত বছর ধরে মিশরে উৎপন্ন শস্যের এক-পঞ্চমাংশ আদায় করার জন্য ফরৌণ সারা দেশে ভারপ্রাপ্ত কর্মকর্তাদের নিয়োগ করুন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","তাঁরা আগামী এই সুন্দর বছরগুলিতে যেন খাদ্যশস্য সংগ্রহ করেন এবং ফরৌণের কতৃর্ত্বের অধীনে সেই শস্য মজুত করে যেন নগরগুলিতে খাদ্যভাণ্ডার গড়ে রাখেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","মিশরের উপর দুর্ভিক্ষকবলিত যে সাতটি বছর নেমে আসতে চলেছে, সেই সময় ব্যবহারের উপযোগী করে দেশের জন্য এই খাদ্যশস্য মজুত করে রাখতে হবে, যেন দেশটি সেই দুর্ভিক্ষ দ্বারা ধ্বংস হয়ে না যায়।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ফরৌণের ও তাঁর সব কর্মকর্তার কাছে সেই পরিকল্পনাটি বেশ ভালো বলে মনে হল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","অতএব ফরৌণ তাঁদের জিজ্ঞাসা করলেন, “এই লোকটির মতো কাউকে কি আমরা খুঁজে পাব, যার অন্তরে ঈশ্বরের আত্মা আছে?” ");
INSERT INTO benobcv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","পরে ফরৌণ যোষেফকে বললেন, “যেহেতু ঈশ্বর এসব কিছু তোমাকেই জানিয়ে দিয়েছেন, তাই তোমার মতো এত বিচক্ষণ ও জ্ঞানীগুণী আর কেউ নেই। ");
INSERT INTO benobcv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","তুমিই আমার প্রাসাদের দায়িত্ব সামলাবে, এবং আমার সব প্রজাকে তোমার আদেশের অধীন হতে হবে। শুধুমাত্র সিংহাসনের ক্ষেত্রে আমি তোমার চেয়ে মহত্তর হব।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","অতএব ফরৌণ যোষেফকে বললেন, “আমি এতদ্বারা তোমার হাতে সম্পূর্ণ মিশর দেশের দায়িত্ব সমর্পণ করে দিলাম।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","পরে ফরৌণ নিজের আঙুল থেকে তাঁর সিলমোহরের আংটিটি খুলে যোষেফের আঙুলে পরিয়ে দিলেন। তিনি তাঁকে মিহি মসিনার আলখাল্লা দিয়ে সুসজ্জিত করলেন এবং তাঁর গলায় সোনার এক হার পরিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","তিনি তাঁকে পদমর্যাদায় তাঁর দ্বিতীয় প্রধান করে একটি রথে চড়িয়ে দিলেন এবং লোকজন তাঁর সামনে চিৎকার করতে লাগল, “রাস্তা করে দাও!” এভাবে তিনি যোষেফের হাতে সম্পূর্ণ মিশর দেশের দায়িত্ব তুলে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","পরে ফরৌণ যোষেফকে বললেন, “আমি ফরৌণ, কিন্তু তোমার আদেশ ছাড়া সমগ্র মিশরে কেউ হাত বা পা ওঠাবে না।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ফরৌণ যোষেফের নাম রাখলেন সাফনৎ-পানেহ এবং তাঁর স্ত্রী হওয়ার জন্য তিনি ওনের যাজক পোটীফেরের মেয়ে আসনৎকে দান করলেন। আর যোষেফ সমগ্র মিশর দেশ জুড়ে ঘুরে বেড়ালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ত্রিশ বছর বয়সে যোষেফ মিশরের রাজা ফরৌণের কাজে যোগ দিলেন। আর যোষেফ ফরৌণের সামনে থেকে চলে গেলেন এবং সমগ্র মিশর জুড়ে ঘুরে বেড়ালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","প্রাচুর্যময় সাত বছর জমিতে প্রচুর ফসল উৎপন্ন হল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","প্রাচুর্যময় সেই সাত বছর ধরে মিশরে যত খাদ্যশস্য উৎপন্ন হল, যোষেফ সেসব সংগ্রহ করলেন ও নগরগুলিতে মজুত করে রাখলেন। প্রত্যেকটি নগরের চারপাশের জমিতে উৎপন্ন খাদ্যশস্য তিনি সেইসব নগরেই রেখে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","প্রচুর খাদ্যশস্য, সমুদ্রের বালুকণার মতো করে যোষেফ মজুত করে ফেললেন; তা পরিমাণে এত বেশি ছিল যে তিনি হিসেব রাখা বন্ধ করে দিলেন, কারণ তা অসম্ভব হয়ে পড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","দুর্ভিক্ষকবলিত বছরগুলি এসে পড়ার আগেই, ওনের যাজক পোটীফেরের মেয়ে আসনতের মাধ্যমে যোষেফের দুই ছেলে জন্মেছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","যোষেফ তাঁর বড়ো ছেলের নাম রাখলেন মনঃশি এবং বললেন, “যেহেতু ঈশ্বর আমাকে আমার সব দুঃখকষ্ট ও আমার বাবার পুরো পরিবারকেই ভুলিয়ে দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","দ্বিতীয় ছেলের নাম তিনি রাখলেন ইফ্রয়িম এবং বললেন “যেহেতু ঈশ্বর আমাকে আমার দুঃখের দেশে ফলপ্রসূ করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","মিশরে প্রাচুর্যময় সাত বছর সমাপ্ত হল, ");
INSERT INTO benobcv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","এবং দুর্ভিক্ষকবলিত সাত বছর শুরু হল, যোষেফ ঠিক যেমনটি বলেছিলেন। অন্যান্য দেশেও দুর্ভিক্ষ হল, কিন্তু সমগ্র মিশর দেশে খাদ্যদ্রব্য ছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","সমগ্র মিশরে যখন দুর্ভিক্ষের অনুভূতি শুরু হল, তখন প্রজারা ফরৌণের কাছে খাদ্যদ্রব্যের জন্য কান্নাকাটি করল। তখন ফরৌণ সব মিশরবাসীকে বললেন, “যোষেফের কাছে যাও ও সে যা বলবে তাই করো।” ");
INSERT INTO benobcv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","দুর্ভিক্ষ যখন সমগ্র দেশে ছড়িয়ে পড়ল, তখন যোষেফ সব আড়ত খুলে দিলেন ও মিশরীয়দের কাছে খাদ্যশস্য বিক্রি করলেন, কারণ সমগ্র মিশর জুড়ে দুর্ভিক্ষ ভয়াবহ রূপ ধারণ করল। ");
INSERT INTO benobcv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","সমগ্র জগৎ মিশরে যোষেফের কাছে খাদ্যশস্য কিনতে এল, কারণ দুর্ভিক্ষ সর্বত্র ভয়াবহ রূপ ধারণ করল। ");
INSERT INTO benobcv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","যাকোব যখন জানতে পারলেন যে মিশর দেশে খাদ্যশস্য আছে, তখন তিনি তাঁর ছেলেদের বললেন, “তোমরা কেন শুধু পরস্পরের মুখ দেখাদেখি করছ?” ");
INSERT INTO benobcv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","তিনি আরও বললেন, “আমি শুনেছি যে মিশরে খাদ্যশস্য আছে। সেখানে যাও ও আমাদের জন্য কিছুটা খাদ্যশস্য কিনে আনো, যেন আমরা বাঁচতে পারি ও মরে না যাই।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","তখন যোষেফের দাদা-ভাইদের মধ্যে দশজন মিশর থেকে খাদ্যশস্য কিনে আনার জন্য সেখানে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","কিন্তু যাকোব যোষেফের ছোটো ভাই বিন্যামীনকে, অন্যদের সঙ্গে পাঠাননি, কারণ তিনি ভয় পেয়েছিলেন, পাছে তার কোনও ক্ষতি হয়। ");
INSERT INTO benobcv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","অতএব যারা খাদ্যশস্য কেনার জন্য মিশরে গেল তাদের মধ্যে ইস্রায়েলের ছেলেরাও ছিলেন, কারণ কনান দেশেও দুর্ভিক্ষ দেখা দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","যোষেফ ছিলেন সেদেশের সেই শাসনকর্তা, যিনি সেখানকার সব প্রজার কাছে খাদ্যশস্য বিক্রি করছিলেন। অতএব যোষেফের দাদারা যখন সেখানে পৌঁছালেন, তাঁরা মাটিতে মাথা নত করে তাঁকে প্রণাম করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","যোষেফ তাঁর দাদাদের দেখামাত্রই, তাঁদের চিনতে পারলেন, কিন্তু তিনি এক অপরিচিত লোক হওয়ার ভান করলেন ও তাঁদের সঙ্গে কর্কশভাবে কথা বললেন। “তোমরা কোথা থেকে এসেছ?” তিনি জিজ্ঞাসা করলেন। “কনান দেশ থেকে,” তাঁরা উত্তর দিলেন, “খাদ্যশস্য কেনার জন্য।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","যোষেফ যদিও তাঁর দাদাদের চিনতে পেরেছিলেন, তাঁরা তাঁকে চিনতে পারেননি। ");
INSERT INTO benobcv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","তখন তাঁর সেই স্বপ্নের কথা মনে পড়ল, যা তিনি তাঁদের সম্বন্ধে দেখেছিলেন এবং তিনি তাঁদের বললেন, “তোমরা গুপ্তচর! তোমরা দেখতে এসেছ কোথায় আমাদের দেশ অসুরক্ষিত হয়ে আছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“হে আমার প্রভু, না,” তাঁরা উত্তর দিলেন। “আপনার দাসেরা খাদ্যশস্য কিনতে এসেছে। ");
INSERT INTO benobcv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","আমরা সবাই এক ব্যক্তিরই ছেলে। আপনার দাসেরা সৎলোক, তারা গুপ্তচর নয়।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“না!” তিনি তাঁদের বললেন। “তোমরা দেখতে এসেছ কোথায় আমাদের দেশ অসুরক্ষিত হয়ে আছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","কিন্তু তাঁরা উত্তর দিলেন, “আপনার দাসেরা মোট বারোজন ভাই ছিল, সবাই সেই একজনেরই ছেলে, যিনি কনান দেশে বসবাস করেন। ছোটো ছেলেটি এখন আমাদের বাবার সঙ্গে আছে, এবং অন্যজন আর বেঁচে নেই।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","যোষেফ তাদের বললেন, “আমি যা বলেছি তাই ঠিক: তোমরা গুপ্তচর! ");
INSERT INTO benobcv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","আর এভাবেই তোমাদের পরীক্ষা করা হবে: ফরৌণের প্রাণের দিব্যি, যতক্ষণ না তোমাদের ছোটো ভাই এখানে আসছে, তোমরা এই স্থান ছেড়ে যেতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","তোমাদের ভাইকে নিয়ে আসার জন্য তোমাদের মধ্যে থেকে একজনকে পাঠাও; তোমাদের মধ্যে অবশিষ্টজনেদের জেলখানায় পুরে রাখা হবে, যেন তোমাদের কথা পরীক্ষা করে দেখা যায় যে আদৌ তোমরা সত্যিকথা বলছ কি না। যদি তা না হয়, তবে ফরৌণের প্রাণের দিব্যি, তোমরা গুপ্তচরই!” ");
INSERT INTO benobcv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","আর তিনদিনের জন্য তিনি তাঁদের জেলে বন্দি করে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","তৃতীয় দিনে, যোষেফ তাঁদের বললেন “এরকম করো ও তোমরা বেঁচে যাবে, কারণ আমি ঈশ্বরকে ভয় করি: ");
INSERT INTO benobcv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","যদি তোমরা সৎলোক হও, তবে তোমাদের ভাইদের মধ্যে একজন এখানে জেলখানায় থাকো, ততক্ষণ তোমাদের মধ্যে অন্যেরা চলে যাও ও তোমাদের নিরন্ন পরিবার-পরিজনেদের জন্য খাদ্যশস্যও নিয়ে যাও। ");
INSERT INTO benobcv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","কিন্তু তোমরা অবশ্যই তোমাদের ছোটো ভাইকে আমার কাছে নিয়ে আসবে, যেন তোমাদের বলা কথা যাচাই করা যায় ও তোমরা মারা না যাও।” তাঁরা তাই করতে উদ্যত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","তাঁরা পরস্পরকে বললেন, “আমাদের ভাইয়ের কারণেই আমরা শাস্তি পাচ্ছি। সে যখন আমাদের কাছে প্রাণভিক্ষা চাইছিল, আমরা দেখেছিলাম সে কত আকুল হয়ে পড়েছিল, কিন্তু আমরা তার কথা শুনিনি; সেজন্যই আমাদের উপর এই চরম বিপদ ঘনিয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","রূবেণ উত্তর দিলেন, “আমি কি তোমাদের বলিনি যে বালকটির বিরুদ্ধে কোনও পাপ কোরো না? কিন্তু তোমরা তা শোনোনি! এখন তার রক্তের হিসেব আমাদের দিতেই হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","তাঁরা অনুভবই করতে পারেননি যে যোষেফ তাঁদের কথা বুঝতে পারছিলেন, কারণ তিনি একজন অনুবাদক ব্যবহার করছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","তিনি তাঁদের কাছ থেকে দূরে সরে গেলেন ও কাঁদতে শুরু করলেন, কিন্তু পরে আবার ফিরে এলেন ও তাঁদের সঙ্গে কথা বললেন। তিনি তাঁদের মধ্যে থেকে শিমিয়োনকে নিয়ে তাঁদের চোখের সামনেই তাকে বেঁধে ফেললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","যোষেফ তাঁদের বস্তাগুলি খাদ্যশস্য দিয়ে ভর্তি করার, প্রত্যেকের রুপো তাঁদের বস্তায় আবার রেখে দেওয়ার, ও তাঁদের যাত্রাপথের জন্য প্রয়োজনীয় রসদপত্র তাঁদের দেওয়ার আদেশ দিলেন। তাঁদের জন্য এসব কিছু সম্পন্ন হওয়ার পর, ");
INSERT INTO benobcv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","তাঁরা তাঁদের গাধাগুলির পিঠে তাঁদের খাদ্যশস্য চাপিয়ে রওনা হয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","রাত্রিযাপনের জন্য একটি স্থানে তাঁরা দাঁড়ানোর পর তাঁদের মধ্যে একজন তাঁর গাধার জাবনা নেওয়ার জন্য নিজের বস্তাটি খুললেন, আর তিনি বস্তার মুখে তাঁর রুপো দেখতে পেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“আমার রুপো ফিরিয়ে দেওয়া হয়েছে,” তিনি তাঁর ভাইদের বললেন। “এখানে আমার বস্তার মধ্যে তা রাখা আছে।” তাঁদের মনে কাঁপুনি ধরে গেল এবং তাঁরা কাঁপতে কাঁপতে পরস্পরের দিকে ফিরে বললেন, “ঈশ্বর আমাদের প্রতি এ কী করলেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","কনান দেশে তাঁরা যখন তাঁদের বাবা যাকোবের কাছে এলেন, তখন তাঁরা তাঁদের প্রতি যা যা ঘটেছিল সেসব কথা তাঁকে বললেন। তাঁরা বললেন, ");
INSERT INTO benobcv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“যে লোকটি সে দেশের প্রভু, তিনি আমাদের সঙ্গে কর্কশভাবে কথা বললেন এবং আমাদের সঙ্গে এমন ব্যবহার করলেন যে আমরা বুঝি সেই দেশে গুপ্তচরবৃত্তি করতে গিয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","কিন্তু আমরা তাঁকে বললাম, ‘আমরা সৎলোক; আমরা গুপ্তচর নই। ");
INSERT INTO benobcv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","আমরা বারোটি ভাই, সবাই একই বাবার ছেলে। একজন আর বেঁচে নেই, এবং ছোটো ভাই এখন কনানে আমাদের বাবার সাথে আছে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“তখন সেদেশের প্রভু সেই লোকটি আমাদের বললেন, ‘এভাবেই আমি জানতে পারব তোমরা সৎলোক কি না: তোমাদের ভাইদের মধ্যে একজনকে এখানে আমার কাছে ছেড়ে যাও, এবং তোমাদের নিরন্ন পরিবার-পরিজনেদের জন্য খাদ্যশস্য নাও ও চলে যাও। ");
INSERT INTO benobcv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","কিন্তু তোমাদের ছোটো ভাইকে আমার কাছে নিয়ে এসো যেন আমি জানতে পারি যে তোমরা গুপ্তচর নও কিন্তু সৎলোক। পরে আমি তোমাদের ভাইকে তোমাদের কাছে ফিরিয়ে দেব, এবং তোমরা এই দেশে ব্যবসাবাণিজ্য করতে পারো।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","তাঁরা যখন তাঁদের বস্তাগুলি খালি করছিলেন, প্রত্যেকের বস্তাতেই তাঁদের রুপো ভর্তি বটুয়া পাওয়া গেল! যখন তাঁরা এবং তাঁদের বাবা টাকার বটুয়াগুলি দেখলেন, তখন তাঁরা ভয় পেয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","তাঁদের বাবা যাকোব তাঁদের বললেন, “তোমরা আমাকে সন্তানহীন করেছ, যোষেফ আর বেঁচে নেই ও শিমিয়োনও আর নেই, এবং এখন তোমরা বিন্যামীনকে নিয়ে যেতে চাইছ। সবকিছুই আমার বিরুদ্ধে গিয়েছে!” ");
INSERT INTO benobcv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","তখন রূবেণ তাঁর বাবাকে বললেন, “আমি যদি তাকে আপনার কাছে ফিরিয়ে আনতে না পারি তবে আপনি আমার দুই ছেলেকে মেরে ফেলতে পারেন। তার দায়িত্ব আমার হাতে তুলে দিন, আর আমি তাকে ফিরিয়ে আনব।” ");
INSERT INTO benobcv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","কিন্তু যাকোব বললেন, “আমার ছেলে তোমাদের সাথে সেখানে যাবে না; তার দাদা মারা গিয়েছে এবং একমাত্র ওই বেঁচে আছে। তোমাদের যাত্রাপথে ওর যদি কোনও ক্ষতি হয়, তবে শোকার্ত অবস্থায় পাকাচুলে তোমরা আমাকে কবরে পাঠিয়ে দেবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","তখনও পর্যন্ত সেদেশে ভয়াবহ দুর্ভিক্ষ চলছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","অতএব যখন তাঁরা মিশর থেকে আনা সব খাদ্যশস্য খেয়ে ফেললেন, তখন তাঁদের বাবা তাঁদের বললেন, “তোমরা ফিরে যাও ও আমাদের জন্য আরও কিছু খাদ্যশস্য কিনে আনো।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","কিন্তু যিহূদা তাঁকে বললেন, “সেই লোকটি শপথপূর্বক আমাদের সাবধান করে দিয়েছিলেন, ‘তোমাদের ভাই যদি তোমাদের সঙ্গে না থাকে তবে তোমরা আর আমার মুখদর্শন করবে না।’ ");
INSERT INTO benobcv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","আপনি যদি আমাদের সঙ্গে আমাদের ভাইকে পাঠান, তবেই আমরা সেখানে যাব ও আপনার জন্য খাদ্যশস্য কিনে আনব। ");
INSERT INTO benobcv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","কিন্তু আপনি যদি তাকে না পাঠান, আমরা সেখানে যাব না, কারণ সেই লোকটি আমাদের বলেছিলেন, ‘তোমাদের ভাই যদি তোমাদের সঙ্গে না থাকে তবে তোমরা আর আমার মুখদর্শন করবে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ইস্রায়েল জিজ্ঞাসা করলেন, “সেই লোকটিকে একথা বলে কেন তোমরা আমার উপর এই বিপত্তি ডেকে এনেছ যে তোমাদের অন্য একটি ভাই আছে?” ");
INSERT INTO benobcv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","তাঁরা উত্তর দিলেন, “সেই লোকটি আমাদের বিষয়ে ও আমাদের পরিবারের বিষয়ে পুঙ্খনাপুঙ্খভাবে আমাদের প্রশ্ন করেছিলেন। ‘তোমাদের বাবা কি এখনও জীবিত আছেন?’ তিনি আমাদের জিজ্ঞাসা করেছিলেন। ‘তোমাদের কি অন্য কোনও ভাই আছে?’ আমরা শুধু তাঁর প্রশ্নগুলির উত্তর দিয়েছিলাম। আমরা কীভাবে জানব যে তিনি বলবেন, ‘তোমাদের ভাইকে এখানে নিয়ে এসো’?” ");
INSERT INTO benobcv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","তখন যিহূদা তাঁর বাবা ইস্রায়েলকে বললেন, “বালকটিকে আমার সঙ্গে পাঠিয়ে দিন এবং আমরা এখনই রওনা দেব, যেন আমরা ও আপনি এবং আমাদের সন্তানেরা বাঁচতে পারি এবং না মরি। ");
INSERT INTO benobcv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","আমি নিজে তার নিরাপত্তার মুচলেকা দেব; তার জন্য আপনি ব্যক্তিগতভাবে আমাকে দায়ী করতে পারেন। আমি যদি তাকে আপনার কাছে ফিরিয়ে আনতে না পারি ও আপনার সামনে তাকে দাঁড় করাতে না পারি, তবে সারা জীবন আমি এই দোষ বয়ে বেড়াব। ");
INSERT INTO benobcv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","তবে ঘটনা হল এই যে, আমরা যদি দেরি না করতাম, তবে এতক্ষণে আমরা দু-দুবার সেখানে গিয়ে ফিরে আসতে পারতাম।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","তখন তাঁদের বাবা ইস্রায়েল তাঁদের বললেন, “যদি তা আবশ্যক হয়, তবে এরকম করো: তোমাদের বস্তাগুলিতে এদেশের শ্রেষ্ঠ দ্রব্যগুলির মধ্যে কিছু কিছু নিয়ে রাখো ও এক উপহারসামগ্রীরূপে সেগুলি সেই লোকটির কাছে নিয়ে যাও—যেমন সামান্য কিছু গুগ্‌গুল ও সামান্য কিছু মধু, কিছু মশলাপাতি ও গন্ধরস, কিছু পেস্তাবাদাম ও কাঠবাদাম। ");
INSERT INTO benobcv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","তোমরা নিজেদের সঙ্গে দ্বিগুণ পরিমাণ রুপো নাও, কারণ সেই রুপোগুলি তোমাদের ফেরত দিতে হবে যা তোমাদের বস্তার মুখে রেখে দেওয়া হয়েছিল। হয়তো ভুলবশতই তা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","তোমাদের ভাইকেও সঙ্গে নাও এবং এখনই সেই লোকটির কাছে চলে যাও। ");
INSERT INTO benobcv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","আর সর্বশক্তিমান ঈশ্বর সেই লোকটির দৃষ্টিতে তোমাদের দয়া পেতে দিন, যেন তিনি তোমাদের অন্য ভাইকে ও বিন্যামীনকে তোমাদের সঙ্গে ফিরে আসতে দেন। আমার আর কি, আমাকে যদি সন্তানহারা হতে হয় তবে তাই হোক।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","অতএব তাঁরা উপহারসামগ্রী ও দ্বিগুণ পরিমাণ রুপো, এবং বিন্যামীনকেও সঙ্গে নিলেন। তাঁরা তাড়াতাড়ি করে মিশরে গেলেন ও যোষেফের কাছে নিজেদের উপস্থিত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","যোষেফ যখন বিন্যামীনকে তাঁদের সঙ্গে দেখতে পেলেন, তখন তিনি তাঁর বাড়ির গোমস্তাকে বললেন, “এদের আমার বাড়িতে নিয়ে যাও, একটি পশু বধ করো এবং ভোজের আয়োজন করো, দুপুরবেলায় এরা আমাদের সঙ্গে ভোজনপান করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","যোষেফ যেমনটি করতে বললেন, সেই লোকটি ঠিক সেরকমই করলেন এবং তাঁদের যোষেফের বাড়িতে নিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","যখন তাঁদের তাঁর বাড়িতে নিয়ে যাওয়া হল তখন তাঁরা ভয় পেয়ে গেলেন। তাঁরা ভাবলেন, “প্রথমবার আমাদের বস্তায় যে রুপো রেখে দেওয়া হয়েছিল সেজন্যই আমাদের এখানে আনা হয়েছে। তিনি আমাদের উপর হামলা করতে ও ক্রীতদাসরূপে আমাদের গ্রেপ্তার করতে এবং আমাদের গাধাগুলি দখল করে নিতে চাইছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","অতএব তাঁরা যোষেফের গোমস্তার কাছে চলে গেলেন ও বাড়ির প্রবেশদ্বারে দাঁড়িয়ে তাঁর সঙ্গে কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“হে আমাদের প্রভু, আমরা আপনার দয়া ভিক্ষা করছি,” তাঁরা বললেন, “প্রথমবার আমরা এখানে খাদ্যশস্য কেনার জন্যই এসেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","কিন্তু রাত্রিযাপনের জন্য আমরা একটি স্থানে থেমে আমাদের বস্তাগুলি খুলেছিলাম এবং আমাদের প্রত্যেকেই বস্তার মুখে নিজের নিজের রুপো—একেবারে নির্ভুল ওজনের রুপো—খুঁজে পেয়েছিলাম। তাই আমরা তা নিজেদের সঙ্গে করে ফিরিয়ে এনেছি। ");
INSERT INTO benobcv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","খাদ্যশস্য কেনার জন্য আমরা আরও কিছু রুপো আমাদের সঙ্গে করে এনেছি। আমরা জানি না কে আমাদের বস্তাগুলিতে আমাদের রুপোগুলি রেখে দিয়েছিল।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“ঠিক আছে,” তিনি বললেন। “ভয় পেয়ো না। তোমাদের ঈশ্বর, তোমাদের পৈত্রিক ঈশ্বর, তোমাদের বস্তাগুলিতে পুরে তোমাদের ধনসম্পদ দিয়েছেন; আমি তোমাদের রুপো পেয়েছি।” পরে তিনি শিমিয়োনকে তাঁদের কাছে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","সেই গোমস্তা তাঁদের যোষেফের বাড়িতে নিয়ে গেলেন, তাঁদের পা ধোয়ার জন্য তাঁদের জল দিলেন এবং তাঁদের গাধাগুলির জন্য জাবনার জোগান দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","দুপুরে যোষেফ আসবেন বলে তাঁরা তাঁদের উপহারসামগ্রী প্রস্তুত করে রাখলেন, কারণ তাঁরা শুনেছিলেন যে সেখানে তাঁদের ভোজনপান করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","যোষেফ যখন ঘরে এলেন, তখন সেই বাড়িতে তাঁরা যেসব উপহারসামগ্রী নিয়ে এসেছিলেন, সেগুলি তাঁরা তাঁকে দিলেন, এবং মাটিতে নতমস্তক হয়ে তাঁকে প্রণাম করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","তিনি তাদের জিজ্ঞাসা করলেন তারা কেমন আছেন, এবং পরে তিনি বললেন, “তোমাদের যে বৃদ্ধ বাবার কথা তোমরা বলেছিলে, তিনি কেমন আছেন? তিনি কি এখনও বেঁচে আছেন?” ");
INSERT INTO benobcv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","তাঁরা উত্তর দিলেন, “আপনার দাস আমাদের বাবা এখনও বেঁচে আছেন ও ভালোই আছেন।” এবং তাঁরা তাঁর সামনে মাটিতে উবুড় হয়ে তাঁকে শ্রদ্ধা জ্ঞাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","তিনি চোখ তুলে তাকিয়ে যেই না তাঁর ভাই বিন্যামীনকে, তাঁর সহোদর ভাইকে দেখতে পেলেন, তিনি জিজ্ঞাসা করলেন, “এই কি তোমাদের সেই ছোটো ভাই, যার কথা তোমরা আমাকে বলেছিলে?” আর তিনি বললেন, “বাছা, ঈশ্বর তোমার প্রতি মঙ্গলময় হোন।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ভাইকে দেখতে পেয়ে যোষেফ দারুণ আবেগতাড়িত হয়ে পড়লেন, তাই তিনি তাড়াতাড়ি বাইরে বেরিয়ে গেলেন ও কাঁদার জন্য একটি স্থান খুঁজলেন। তিনি নিজের খাস কামরায় ঢুকে গেলেন ও সেখানে কেঁদে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","নিজের মুখ ধুয়ে নেওয়ার পর, নিজেকে সংযত করে তিনি বাইরে বেরিয়ে এসে বললেন, “খাবার পরিবেশন করো।” ");
INSERT INTO benobcv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","তারা আলাদা আলাদা করে তাঁর জন্য, তাঁর ভাইদের জন্য এবং তাঁর সাথে যে মিশরীয়রা খেতে বসেছিল, তাদের জন্য খাবার পরিবেশন করল, কারণ মিশরীয়রা হিব্রুদের সাথে ভোজনপান করত না, যেহেতু মিশরীয়দের কাছে তা ঘৃণ্য বলে গণ্য হত। ");
INSERT INTO benobcv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","বড়ো থেকে শুরু করে ছোটো পর্যন্ত, তাঁদের বয়সানুসারেই তাঁদের তাঁর সামনে বসানো হল; এবং তাঁরা অবাক হয়ে পরস্পরের দিকে তাকালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","যোষেফের টেবিল থেকে যখন তাঁদের খাবার পরিবেশন করা হল, বিন্যামীনের অংশটি অন্য যে কারোর অংশের চেয়ে পাঁচগুণ বেশি হল। অতএব তাঁরা তাঁর সাথে বসে অবাধে পেট পুরে ভোজনপান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","যোষেফ তাঁর ঘরের গোমস্তাকে এই নির্দেশগুলি দিলেন: “এই লোকেরা যতখানি খাদ্যশস্য বয়ে নিয়ে যেতে পারে, ততখানি করে দিয়ে ওদের বস্তাগুলি ভরে দাও, এবং প্রত্যেকের বস্তার মুখে তাদের রুপো রেখে দাও। ");
INSERT INTO benobcv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","পরে খাদ্যশস্যের জন্য আনা রুপোর পাশাপাশি আমার পানপাত্রটি, সেই রুপোর পানপাত্রটিও সেই ছোটো ছেলেটির বস্তার মুখে রেখে দাও।” আর যোষেফ যেমনটি বললেন, তিনি তেমনটিই করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","সকাল হওয়ামাত্র, তাঁদের গাধাগুলির সঙ্গে তাঁদের বিদায় করে দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","তাঁরা নগর থেকে তখন খুব বেশি দূরে যাননি, এমন সময় যোষেফ তাঁর গোমস্তাকে বললেন, “এখনই ওই লোকদের পশ্চাদ্ধাবন করো, এবং তাদের নাগাল পেয়ে, তুমি তাদের বোলো, ‘ভালোর পরিবর্তে তোমরা কেন মন্দ প্রতিদান দিলে? ");
INSERT INTO benobcv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","এটি কি সেই পানপাত্র নয় যেটি থেকে আমার প্রভু পান করেন এবং ভবিষ্যৎ-কথনের জন্য যেটি ব্যবহার করেন? তোমরা এ এক মন্দ কাজ করে বসলে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","তাঁদের নাগাল পেয়ে তিনি তাঁদের কাছে এই কথাগুলি বলে শোনালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","কিন্তু তাঁরা তাঁকে বললেন, “আমার প্রভু কেন এরকম কথা বলছেন? এরকম কোনও কাজ আপনার দাসেরা করতেই পারে না! ");
INSERT INTO benobcv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","এমনকি আমরা সেই কনান দেশ থেকে সেই রুপোও তো ফেরত এনেছিলাম, যা আমাদের বস্তার মুখে পাওয়া গিয়েছিল। তাই আপনার প্রভুর বাড়ি থেকে কেনই বা আমরা রুপো বা সোনা চুরি করব? ");
INSERT INTO benobcv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","যদি আপনার এই দাসেদের মধ্যে কারও কাছে তা পাওয়া যায়, তবে সে মরবে; এবং আমাদের মধ্যে বাকি সবাই আমার প্রভুর ক্রীতদাস হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“তবে ঠিক আছে,” তিনি বললেন, “তোমাদের কথানুসারেই তা হোক। যার কাছে সেটি পাওয়া যাবে সে আমার ক্রীতদাস হয়ে যাবে; তোমাদের মধ্যে বাদবাকি সবাই দোষমুক্ত হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","তাঁদের প্রত্যেকেই তাড়াতাড়ি মাটিতে বস্তা নামালেন ও তা খুলে ধরলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","পরে সেই গোমস্তা খানাতল্লাশি করার জন্য এগিয়ে গেলেন, বড়ো থেকে শুরু করে ছোটো জনের কাছে গিয়ে খানাতল্লাশি শেষ করলেন। আর সেই পানপাত্রটি বিন্যামীনের বস্তাতে পাওয়া গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","তা দেখে, তাঁরা তাঁদের পোশাক ছিঁড়ে ফেললেন। পরে তাঁরা সবাই তাঁদের গাধার পিঠে বোঝা চাপিয়ে নগরে ফিরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","যিহূদা ও তাঁর ভাইয়েরা যখন ফিরে এলেন, যোষেফ তখনও বাড়ির মধ্যেই ছিলেন, এবং তাঁরা তাঁর সামনে গিয়ে মাটিতে উবুড় হয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","যোষেফ তাঁদের বললেন, “তোমরা এ কী কাজ করলে? তোমরা কি জানো না যে আমার মতো একজন লোকগণনা করে সবকিছু খুঁজে বের করতে পারে?” ");
INSERT INTO benobcv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“আমার প্রভুর কাছে আমরা কী আর বলব?” যিহূদা উত্তর দিলেন। “আমরা কী আর বলব? আমরা কীভাবেই বা আমাদের নির্দোষিতার প্রমাণ দেব? ঈশ্বর আপনার দাসদের দোষ উন্মোচন করে দিয়েছেন। আমরা এখন আমার প্রভুর ক্রীতদাস হয়ে গিয়েছি—আমরা নিজেরা এবং সেই জন, যার কাছে সেই পানপাত্রটি পাওয়া গিয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","কিন্তু যোষেফ বললেন, “এরকম কাজ যেন আমি না করি! শুধু যার কাছে সেই পানপাত্রটি পাওয়া গিয়েছে, সেই লোকটিই আমার ক্রীতদাস হবে। তোমাদের মধ্যে বাদবাকি সবাই শান্তিতে তোমাদের বাবার কাছে ফিরে যাও।” ");
INSERT INTO benobcv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","তখন যিহূদা তাঁর কাছে গিয়ে বললেন: “হে আমার প্রভু, আপনার এই দাসকে ক্ষমা করুন, আমার প্রভুর কাছে আমাকে একটি কথা বলতে দিন। আপনার এই দাসের প্রতি ক্রুদ্ধ হবেন না, যদিও বা আপনি স্বয়ং ফরৌণের সমতুল্য। ");
INSERT INTO benobcv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","আমার প্রভু তাঁর দাসদের জিজ্ঞাসা করেছিলেন, ‘তোমাদের কি বাবা অথবা ভাই আছে? ’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","আর আমরা তাঁকে উত্তর দিয়েছিলাম, ‘আমাদের বৃদ্ধ বাবা আছেন, এবং তাঁর বৃদ্ধাবস্থায় জন্মানো তাঁর এক ছোটো ছেলেও আছে। তার দাদা মারা গিয়েছে, এবং তার মায়ের একমাত্র সন্তানরূপে সেই বেঁচে আছে, এবং তার বাবা তাকে ভালোবাসেন।’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“পরে আপনি আপনার দাসদের বলেছিলেন, ‘তাকে আমার কাছে নিয়ে এসো, যেন আমি তাকে স্বচক্ষে দেখতে পারি।’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","আর আমরা আমার প্রভুকে বলেছিলাম, ‘সেই বালকটি তার বাবার কাছছাড়া হতে পারবে না; যদি সে তাঁকে ছেড়ে আসে, তবে তার বাবা মারা যাবেন।’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","কিন্তু আপনি আপনার দাসদের বলেছিলেন, ‘তোমাদের ছোটো ভাই যতক্ষণ না তোমাদের সঙ্গে আসছে, তোমরা আর আমার মুখদর্শন করবে না।’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","আমরা যখন আপনার দাস আমার বাবার কাছে ফিরে গেলাম, তখন আমার প্রভু যা যা বলেছিলেন, সেসব আমরা তাঁকে বলেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“তখন আমাদের বাবা বললেন, ‘তোমরা ফিরে যাও এবং আরও অল্প কিছু খাদ্যশস্য কিনে আনো।’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","কিন্তু আমরা বললাম, ‘আমরা যেতে পারব না। আমাদের ছোটো ভাই যদি আমাদের সঙ্গে থাকে তবেই আমরা যাব। আমাদের ছোটো ভাই যদি আমাদের সঙ্গে না থাকে তবে আমরা সেই লোকটির মুখদর্শন করতে পারব না।’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“আপনার দাস আমার বাবা আমাদের বললেন, ‘তোমরা তো জানো যে আমার স্ত্রী আমার জন্য দুটি সন্তানের জন্ম দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","তাদের মধ্যে একজন আমার কাছ থেকে দূরে চলে গিয়েছে, এবং আমি বলেছিলাম, “নিশ্চিতভাবে তাকে ছিন্ন-বিচ্ছিন্ন করে ফেলা হয়েছে।” তখন থেকে আমি আর তাকে দেখতে পাইনি। ");
INSERT INTO benobcv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","তোমরা যদি একেও আবার আমার কাছ থেকে নিয়ে যাও এবং এর যদি কোনও ক্ষতি হয়, তবে এই পাকাচুলে মর্মপীড়ায় তোমরা আমাকে কবরে পাঠাবে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“অতএব এখন, আমি যখন আপনার দাস আমার বাবার কাছে ফিরে যাব, তখন যদি বালকটি আমাদের সঙ্গে না থাকে এবং আমার সেই বাবা, যাঁর জীবন সেই বালকটির জীবনের সঙ্গে ঘনিষ্ঠভাবে যুক্ত, ");
INSERT INTO benobcv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","তিনি যদি দেখেন যে বালকটি সেখানে নেই, তবে তিনি মারা যাবেন। আপনার দাসেরা আমার বাবাকে এই পাকাচুলে মর্মপীড়ায় কবরে পাঠাবে। ");
INSERT INTO benobcv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","আপনার এই দাস আমি আমার বাবার কাছে সেই বালকটির নিরাপত্তার মুচলেকা দিয়েছিলাম। আমি বলেছিলাম, ‘আমি যদি তাকে আপনার কাছে ফিরিয়ে আনতে না পারি, তবে হে আমার বাবা, আজীবন আমি আপনার সামনে দোষ বয়ে বেড়াব!’ ");
INSERT INTO benobcv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“এখন তবে, প্রভু দয়া করে এই বালকটির স্থানে আপনার এই দাসকেই এখানে আপনার ক্রীতদাস হয়ে থাকতে দিন, এবং এই বালকটিকে তার দাদাদের সঙ্গে ফিরে যেতে দিন। ");
INSERT INTO benobcv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","বালকটি যদি আমার সঙ্গে না থাকে তবে আমি কীভাবে আমার বাবার কাছে ফিরে যাব? না! আমার বাবার উপর যে মর্মপীড়া নেমে আসবে, তা যেন আমাকে দেখতে না হয়।” ");
INSERT INTO benobcv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","তখন যোষেফ তাঁর সব সেবকের সামনে নিজেকে আর সংযত করে রাখতে পারলেন না, এবং তিনি চিৎকার করে উঠলেন, “সবাই আমার সামনে থেকে সরে যাও!” অতএব যোষেফ যখন তাঁর দাদা-ভাইদের কাছে নিজের পরিচয় প্রকাশ করলেন তখন তাঁর কাছে আর কেউ ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","আর তিনি এত জোরে কাঁদলেন যে মিশরীয়রা তা শুনতে পেল, এবং ফরৌণের পরিবার-পরিজনও তা শুনতে পেল। ");
INSERT INTO benobcv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","যোষেফ তাঁর দাদা-ভাইদের বললেন, “আমি যোষেফ! আমার বাবা কি এখনও বেঁচে আছেন?” কিন্তু তাঁর দাদারা তাঁকে উত্তর দিতে পারলেন না, কারণ তাঁর উপস্থিতিতে তাঁরা ভয় পেয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","পরে যোষেফ তাঁর দাদা-ভাইদের বললেন, “আমার কাছে এসো।” যখন তাঁরা এলেন, তখন তিনি বললেন, “আমিই তোমাদের সেই ভাই যোষেফ, যাকে তোমরা মিশরে বিক্রি করে দিয়েছিলে! ");
INSERT INTO benobcv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","আর এখন, আমাকে এখানে বিক্রি করে দিয়েছ বলে আকুল হোয়ো না ও নিজেদের উপর রাগ কোরো না, কারণ মানুষের প্রাণরক্ষা করার জন্যই ঈশ্বর তোমাদের আগে আগে আমাকে পাঠিয়ে দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","দুই বছর ধরে এখন এদেশে দুর্ভিক্ষ চলছে, এবং পরবর্তী পাঁচ বছর কোনও হলকর্ষণ ও শস্যচ্ছেদন হবে না। ");
INSERT INTO benobcv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","কিন্তু এই পৃথিবীতে তোমাদের বংশরক্ষা করার জন্য ও এক মহামুক্তির মাধ্যমে তোমাদের প্রাণরক্ষা করার জন্য ঈশ্বর তোমাদের আগে আগে আমাকে পাঠিয়ে দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“অতএব, এমনটি নয় যে তোমরা আমাকে এখানে পাঠিয়েছ, কিন্তু ঈশ্বরই পাঠিয়েছেন। তিনি আমাকে ফরৌণের বাবা, তাঁর সমস্ত পরিবারের মালিক এবং সমগ্র মিশরের শাসনকর্তা করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","এখন তাড়াতাড়ি করে আমার বাবার কাছে ফিরে যাও এবং তাঁকে বলো, ‘তোমার ছেলে যোষেফ একথা বলেছে: ঈশ্বর আমাকে সমগ্র মিশরের মালিক করে তুলেছেন। আমার কাছে নেমে এসো; দেরি কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","তোমরা গোশন অঞ্চলে বসবাস করবে এবং আমার কাছেই থাকবে—তোমরা, তোমাদের সন্তানেরা, এবং তোমাদের নাতিপুতিরা, তোমাদের গোমেষাদি পশুপাল, এবং তোমাদের যা যা আছে সেসবকিছু। ");
INSERT INTO benobcv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","আমি সেখানে তোমাদের জন্য সবকিছুর জোগান দেব, কারণ পাঁচ বছরের দুর্ভিক্ষ এখনও বাকি আছে। তা না হলে তোমরা ও তোমাদের পরিবার-পরিজন এবং তোমাদের অধিকারভুক্ত সবাই নিঃস্ব হয়ে যাবে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“তোমরা নিজের চোখেই দেখতে পাচ্ছ, এবং আমার ভাই বিন্যামীনও দেখতে পাচ্ছে, যে তোমাদের সঙ্গে যে কথা বলছে সে আসলে আমিই। ");
INSERT INTO benobcv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","মিশরে আমাকে যে সম্মান দেওয়া হয়েছে ও তোমরা যা যা দেখেছ সেসব আমার বাবাকে গিয়ে বলো। আর আমার বাবাকে তাড়াতাড়ি নিয়ে এসো।” ");
INSERT INTO benobcv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","পরে তিনি তাঁর দু-হাত বাড়িয়ে দিয়ে তাঁর ভাই বিন্যামীনকে আলিঙ্গন করলেন এবং কাঁদলেন, এবং বিন্যামীনও তাঁকে জড়িয়ে ধরে কাঁদলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","আর তিনি তাঁর দাদাদের সবাইকে চুমু দিলেন, ও তাঁদের ধরে কাঁদলেন। পরে তাঁর দাদারা তাঁর সঙ্গে কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","যোষেফের দাদা-ভাইরা এসেছে, এই খবর যখন ফরৌণের প্রাসাদে এসে পৌঁছাল, তখন ফরৌণ ও তাঁর সব কর্মকর্তা খুশি হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ফরৌণ যোষেফকে বললেন, “তোমার দাদা-ভাইদের বলো, ‘এরকম করো: তোমাদের পশুদের পিঠে বোঝা চাপাও ও কনান দেশে ফিরে যাও, ");
INSERT INTO benobcv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","এবং তোমাদের বাবাকে ও তোমাদের পরিবার-পরিজনকে নিয়ে আমার কাছে ফিরে এসো। মিশর দেশের সেরা জিনিসগুলি আমি তোমাদের দেব এবং তোমরা দেশের বাছাই করা জিনিসগুলি উপভোগ করবে।’ ");
INSERT INTO benobcv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“তোমাকে আরও নির্দেশ দেওয়া হল যেন তুমি তাদের বলো, ‘এরকম করো: তোমাদের সন্তানদের ও তোমাদের স্ত্রীদের জন্য মিশর থেকে কয়েকটি দুই চাকার গাড়ি নাও, এবং তোমাদের বাবাকে নিয়ে চলে এসো। ");
INSERT INTO benobcv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","তোমাদের বিষয়সম্পত্তির জন্য কোনও চিন্তা কোরো না, কারণ সমগ্র মিশরের সেরা জিনিসগুলি তোমাদেরই হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","অতএব ইস্রায়েলের ছেলেরা এমনটিই করলেন। ফরৌণ যেমনটি আদেশ দিলেন, সেই অনুসারে যোষেফ তাঁদের দু-চাকার গাড়িগুলি দিলেন, এবং তিনি তাঁদের যাত্রাপথের জন্য রসদপত্রও জোগালেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","তাঁদের প্রত্যেককে তিনি নতুন নতুন পোশাক দিলেন, কিন্তু তিনি বিন্যামীনকে তিনশো শেকল রুপো ও পাঁচজোড়া পোশাক দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","আর তাঁর বাবার কাছে তিনি যা যা পাঠালেন তা হল এই: দশটি মদ্দা গাধার পিঠে বোঝাই করা মিশরের সেরা জিনিসপত্র, এবং দশটি গাধির পিঠে বোঝাই করা তাঁর যাত্রাপথের জন্য প্রয়োজনীয় খাদ্যশস্য এবং রুটি ও অন্যান্য রসদপত্র। ");
INSERT INTO benobcv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","পরে তিনি তাঁর দাদা-ভাইদের পাঠিয়ে দিলেন, এবং তাঁরা যখন প্রস্থান করলেন, তিনি তাঁদের বললেন, “রাস্তায় ঝগড়াঝাটি কোরো না!” ");
INSERT INTO benobcv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","অতএব তাঁরা মিশর থেকে চলে গেলেন এবং কনান দেশে তাঁদের বাবা যাকোবের কাছে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","তাঁরা তাঁকে বললেন, “যোষেফ এখনও বেঁচে আছে! আসলে, সে সমগ্র মিশরের শাসনকর্তা হয়ে গিয়েছে।” যাকোব স্তব্ধ হয়ে গেলেন; তাঁদের কথা তিনি বিশ্বাস করলেন না। ");
INSERT INTO benobcv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","কিন্তু তাঁরা যখন যোষেফ তাঁদের যা যা বলেছিলেন সেসব কথা তাঁকে বললেন, এবং তিনি যখন তাঁকে বয়ে নিয়ে যাওয়ার জন্য যোষেফের পাঠানো দুই চাকার গাড়িগুলি দেখলেন, তখন তাঁদের বাবা যাকোবের অন্তরাত্মা পুনরুজ্জীবিত হল। ");
INSERT INTO benobcv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","আর ইস্রায়েল বললেন, “আমি নিশ্চিত! আমার ছেলে যোষেফ এখনও বেঁচে আছে। মরার আগে আমি যাব এবং তাকে দেখব।” ");
INSERT INTO benobcv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","অতএব ইস্রায়েল তাঁর যথাসর্বস্য নিয়ে রওনা দিলেন, এবং তিনি যখন বের-শেবাতে পৌঁছালেন, তখন তিনি তাঁর বাবা ইস্‌হাকের ঈশ্বরের উদ্দেশে বলি উৎসর্গ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","আর রাতের বেলায় এক দর্শনের মাধ্যমে ঈশ্বর ইস্রায়েলের সঙ্গে কথা বললেন, এবং তিনি বললেন, “যাকোব, যাকোব!” “আমি এখানে,” তিনি উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“আমি ঈশ্বর, তোমার বাবার সেই ঈশ্বর,” তিনি বললেন। “মিশরে যেতে ভয় পেয়ো না, কারণ সেখানে আমি তোমাকে এক বড়ো জাতি করে তুলব, ");
INSERT INTO benobcv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","তোমার সঙ্গে আমিও মিশরে যাব, এবং আমি আবার সেখান থেকে তোমাকে অবশ্যই বের করে আনব। আর যোষেফ নিজের হাতে তোমার চোখ বন্ধ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","পরে যাকোব বের-শেবা ছেড়ে এলেন, এবং ইস্রায়েলের ছেলেরা, তাঁদের বাবা যাকোবকে ও তাঁদের সন্তানদের এবং তাঁদের স্ত্রীদের সেই দুই চাকার গাড়িগুলিতে করে আনলেন, যেগুলি ফরৌণ তাঁকে বয়ে নিয়ে যাওয়ার জন্য পাঠিয়ে দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","অতএব যাকোব ও তাঁর সব বংশধর নিজেদের সাথে কনানে অর্জিত তাঁদের গৃহপালিত পশুপাল ও বিষয়সম্পত্তি নিয়ে মিশরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","যাকোব নিজের সাথে তাঁর ছেলেদের ও নাতিদের এবং তাঁর মেয়েদের ও নাতনীদের—তাঁর সব বংশধরকে মিশরে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","এই হল ইস্রায়েলের সেই ছেলেদের নাম (যাকোব এবং তাঁর বংশধররা) যারা মিশরে গিয়েছিলেন: যাকোবের প্রথমজাত রূবেণ। ");
INSERT INTO benobcv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","রূবেণের ছেলেরা: হনোক, পল্লু, হিষ্রোণ ও কর্মি। ");
INSERT INTO benobcv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","শিমিয়োনের ছেলেরা: যিমূয়েল, যামীন, ওহদ, যাখীন, সোহর ও এক কনানীয় মহিলার সেই ছেলে শৌল। ");
INSERT INTO benobcv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","লেবির ছেলেরা: গের্শোন, কহাৎ, ও মরারি। ");
INSERT INTO benobcv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","যিহূদার ছেলেরা: এর, ওনন, শেলা, পেরস ও সেরহ। (কিন্তু এর ও ওনন কনান দেশে মারা গিয়েছিল) পেরসের ছেলেরা: হিষ্রোণ ও হামূল। ");
INSERT INTO benobcv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ইষাখরের ছেলেরা: তোলয়, পূয়, যাশূব ও শিম্রোণ। ");
INSERT INTO benobcv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","সবূলূনের ছেলেরা: সেরদ, এলোন, ও যহলেল। ");
INSERT INTO benobcv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","এরা হলেন লেয়ার সেই ছেলেরা, যাদের ও তা ছাড়াও যাকোবের মেয়ে দীণাকে যিনি পদ্দন-আরামে যাকোবের জন্য জন্ম দিয়েছিলেন। তাঁর এইসব ছেলে ও মেয়ে মোট তেত্রিশজন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","গাদের ছেলেরা: সেফোন, হগি, শূনী, ইষবোন, এরি, অরোদী ও অরেলী। ");
INSERT INTO benobcv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","আশেরের ছেলেরা: যিম্না, যিশ্‌বা, যিশ্‌বি, বরিয়। তাদের বোন সেরহ। বরিয়ের ছেলেরা: হেবর ও মল্কীয়েল। ");
INSERT INTO benobcv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","এরা হলেন যাকোবের সেই ছেলেমেয়ে, যারা লেয়ার সেই দাসী সিল্পা দ্বারা জাত হয়েছিল, যাকে লাবন তাঁর মেয়ে লেয়াকে দিয়েছিলেন—মোট ষোলোজন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","যাকোবের স্ত্রী রাহেলের ছেলেরা: যোষেফ ও বিন্যামীন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","মিশরে, যোষেফের ছেলে মনঃশি ও ইফ্রয়িম ওনের যাজক পোটীফেরের মেয়ে আসনতের দ্বারা জন্মেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","বিন্যামীনের ছেলেরা: বেলা, বেখর, অস্‌বেল, গেরা, নামান, এহী, রোশ, মূপপীম, হুপপীম ও অর্দ। ");
INSERT INTO benobcv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","এরা হলেন যাকোবের সেই ছেলেরা, যারা রাহেলের দ্বারা জন্মেছিলেন—মোট চোদ্দোজন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","দানের ছেলে: হূশীম। ");
INSERT INTO benobcv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","নপ্তালির ছেলেরা: যহসিয়েল, গূনি, যেৎসর ও শিল্লেম। ");
INSERT INTO benobcv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","এরা হলেন যাকোবের সেই ছেলেরা, যারা রাহেলের সেই দাসী বিলহা দ্বারা জাত হলেন, যাকে লাবন তাঁর মেয়ে রাহেলকে দিয়েছিলেন—মোট সাতজন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","যাকোবের সঙ্গে যারা মিশরে গেলেন—যারা তাঁর অব্যবহিত বংশধর নন, তাঁর সেই পুত্রবধূদের সংখ্যা না ধরে—তাদের সংখ্যা হয়েছিল ছেষট্টি জন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","মিশরে যোষেফের যে দুই ছেলের জন্ম হয়েছিল তাদের সংখ্যা ধরে, যাকোবের পরিবারের যে সদস্যেরা মিশরে গেলেন তাদের সংখ্যা মোট সত্তর জন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ইত্যবসরে গোশনে যাওয়ার পথনির্দেশনা লাভের জন্য যাকোব তাঁর আগে আগে যিহূদাকে যোষেফের কাছে পাঠিয়ে দিলেন। তাঁরা যখন সেই গোশন অঞ্চলে পৌঁছালেন, ");
INSERT INTO benobcv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","যোষেফ তখন তাঁর রথ সাজিয়েগুছিয়ে নিলেন ও তাঁর বাবা ইস্রায়েলের সঙ্গে দেখা করার জন্য গোশনে চলে গেলেন। যোষেফ তাঁর সামনে গিয়ে দাঁড়াতে না দাঁড়াতেই তিনি তাঁর বাবার দিকে দু-হাত বাড়িয়ে দিলেন ও অনেকক্ষণ ধরে কাঁদলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ইস্রায়েল যোষেফকে বললেন, “আমি এখন মরার জন্য প্রস্তুত, যেহেতু আমি নিজের চোখেই দেখলাম যে তুমি এখনও জীবিত আছ।” ");
INSERT INTO benobcv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","পরে যোষেফ তাঁর দাদা-ভাইদের ও তাঁর পৈত্রিক পরিবার-পরিজনদের বললেন, “আমি ফরৌণের কাছে গিয়ে তাঁর সাথে কথা বলব ও তাঁকে বলব, ‘যারা সেই কনান দেশে বসবাস করছিলেন, আমার সেই দাদা-ভাইয়েরা ও আমার পৈত্রিক পরিবার-পরিজনেরা আমার কাছে এসেছেন। ");
INSERT INTO benobcv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","তারা মেষপালক; তারা গৃহপালিত পশুপাল চরান, এবং তাদের মেষপাল ও পশুপাল ও তাদের অধিকারভুক্ত সবকিছু সাথে নিয়ে তারা এখানে এসেছেন।’ ");
INSERT INTO benobcv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ফরৌণ যখন তোমাদের ডেকে জিজ্ঞাসা করবেন যে, ‘তোমাদের পেশা কী?’ ");
INSERT INTO benobcv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","তোমাদের তখন এই উত্তর দিতে হবে, ‘আমাদের ছেলেবেলা থেকেই আপনার এই দাসেরা গৃহপালিত পশুপাল চরিয়ে আসছে, ঠিক যেভাবে আমাদের পূর্বপুরুষরাও চরাতেন।’ তখন তোমাদের গোশন অঞ্চলে বসতি স্থাপন করার অনুমতি দেওয়া হবে, কারণ সব মেষপালকই মিশরীয়দের কাছে ঘৃণ্য।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","যোষেফ চলে গেলেন এবং ফরৌণকে বললেন, “আমার বাবা ও দাদা-ভাইয়েরা তাদের মেষপাল ও পশুপাল এবং তাদের অধিকারভুক্ত সবকিছু সাথে নিয়ে কনান দেশ থেকে চলে এসেছেন এবং এখন গোশনে আছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","তিনি তাঁর দাদা-ভাইদের মধ্যে পাঁচ জনকে মনোনীত করে তাঁদের ফরৌণের সামনে উপস্থিত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ফরৌণ সেই দাদা-ভাইদের জিজ্ঞাসা করলেন, “তোমাদের পেশা কী?” “আপনার এই দাসেরা মেষপালক,” তাঁরা ফরৌণকে উত্তর দিলেন, “ঠিক যেমনটি আমাদের পূর্বপুরুষেরাও ছিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","তাঁরা তাঁকে আরও বললেন, “আমরা এখানে অল্প কিছুকালের জন্য বসবাস করতে এসেছি, কারণ কনানে দুর্ভিক্ষ দুঃসহ হয়ে দাঁড়িয়েছে এবং আপনার এই দাসেদের মেষপালের জন্য কোনও চারণভূমি নেই। অতএব এখন, দয়া করে আপনার এই দাসেদের গোশনে বসতি স্থাপন করতে দিন।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ফরৌণ যোষেফকে বললেন, “তোমার বাবা ও দাদা-ভাইয়েরা তোমার কাছে এসেছেন, ");
INSERT INTO benobcv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","এবং এই মিশর দেশটি তোমার সামনেই আছে; দেশের সব থেকে ভালো জায়গায় তোমার বাবা ও দাদা-ভাইদের বসতি স্থাপন করিয়ে দাও। তারা গোশনেই বসবাস করুন। আর যদি তুমি জানো যে তাদের মধ্যে কেউ কেউ বিশেষ দক্ষতাবিশিষ্ট, তবে তাদের তুমি আমার নিজের গৃহপালিত পশুপাল দেখাশোনার দায়িত্ব দিয়ো।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","তখন যোষেফ তাঁর বাবা যাকোবকে নিয়ে গিয়ে ফরৌণের সামনে দাঁড় করিয়ে দিলেন। যাকোব ফরৌণকে আশীর্বাদ করার পর, ");
INSERT INTO benobcv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ফরৌণ তাঁকে জিজ্ঞাসা করলেন, “আপনার বয়স কত?” ");
INSERT INTO benobcv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","আর যাকোব ফরৌণকে বললেন, “আমার জীবনপরিক্রমার কাল 130 বছর হয়েছে। আমার আয়ুর বছরগুলি অল্প সংখ্যক ও কষ্টকর হয়েছে, এবং সেগুলি আমার পূর্বপুরুষদের জীবনপরিক্রমার বছরগুলির সমান নয়।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","পরে যাকোব ফরৌণকে আশীর্বাদ করলেন এবং তাঁর সামনে থেকে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","অতএব যোষেফ তাঁর বাবা ও দাদা-ভাইদের মিশরে বসতি স্থাপন করিয়ে দিলেন এবং ফরৌণের নির্দেশানুসারে, দেশের সব থেকে ভালো জায়গায়, সেই রামিষেষ জেলায় তাঁদের বিষয়সম্পত্তি দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","এছাড়াও যোষেফ তাঁর বাবার ও দাদা-ভাইদের এবং তাঁর পৈত্রিক সব পরিবার-পরিজনের সন্তানসন্ততির সংখ্যা অনুসারে তাঁদের খাদ্যদ্রব্য জোগান দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","সমগ্র এলাকায় অবশ্য খাদ্যদ্রব্য ছিল না, কারণ দুর্ভিক্ষ দুঃসহ হয়ে পড়েছিল; দুর্ভিক্ষের কারণে মিশর ও কনান, দুই দেশই ক্ষতিগ্রস্ত হয়ে পড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","মিশর ও কনানে যে অর্থ পাওয়া গেল যোষেফ সেসব তাদের কেনা খাদ্যশস্যের মূল্যরূপে সংগ্রহ করে তা ফরৌণের প্রাসাদে নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","মিশর ও কনানের প্রজাদের অর্থ যখন শেষ হয়ে গেল, তখন মিশরের সব লোকজন যোষেফের কাছে এসে বলল, “আমাদের খাদ্যদ্রব্য দিন। আপনার চোখের সামনে আমরা কেন মারা পড়ব? আমাদের সব অর্থ ফুরিয়ে গিয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","“তবে তোমাদের গৃহপালিত পশুপাল নিয়ে এসো,” যোষেফ বললেন। “যেহেতু তোমাদের অর্থ ফুরিয়ে গিয়েছে তাই তোমাদের গৃহপালিত পশুপালের বিনিময়ে আমি তোমাদের খাদ্যদ্রব্য বিক্রি করব।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","অতএব তারা যোষেফের কাছে তাদের গৃহপালিত পশুপাল নিয়ে এল, এবং তিনি তাদের ঘোড়া, তাদের মেষ ও ছাগল, তাদের গবাদি পশুপাল ও গাধাগুলির বিনিময়ে তাদের খাদ্যদ্রব্য দিলেন। আর তাদের সব গৃহপালিত পশুর বিনিময়ে তাদের খাদ্যদ্রব্য দিয়ে তিনি সে বছরটি পার করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","যখন সেই বছরটি শেষ হল, পরের বছরও তারা তাঁর কাছে এসে বলল, “আমরা এই তথ্যটি আমাদের প্রভুর কাছে লুকিয়ে রাখতে পারছি না যে যেহেতু আমাদের অর্থ ফুরিয়ে গিয়েছে এবং আমাদের গৃহপালিত পশুপালও আপনারই হয়ে গিয়েছে, এখন আমাদের প্রভুর জন্য আমাদের শরীর ও আমাদের জমিজায়গা ছাড়া আর কিছুই অবশিষ্ট নেই। ");
INSERT INTO benobcv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","আপনার চোখের সামনে আমরা কেন ধ্বংস হব—আমরা ও আমাদের জমিজায়গাও? খাদ্যদ্রব্যের পরিবর্তে আপনি আমাদের ও আমাদের জমিজায়গা কিনে নিন, এবং আমাদের জমিজায়গা সমেত আমরা ফরৌণের কাছে দাসত্ববন্ধনে আবদ্ধ হব। আমাদের বীজ দিন যেন আমরা বাঁচতে পারি ও মারা না যাই, এবং এই দেশ যেন জনশূন্য হয়ে না যায়।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","অতএব যোষেফ মিশরে সব জমিজায়গা ফরৌণের জন্য কিনে নিলেন। মিশরীয়রা, এক এক করে, সবাই তাদের জমিজায়গা বিক্রি করে দিল, কারণ তাদের পক্ষে দুর্ভিক্ষ অত্যন্ত দুঃসহ হয়েছিল। সেই জমিজায়গা ফরৌণের হয়ে গেল, ");
INSERT INTO benobcv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","এবং যোষেফ মিশরের এক প্রান্ত থেকে অন্য প্রান্ত পর্যন্ত প্রজাদের ক্রীতদাসে পরিণত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","অবশ্য, তিনি যাজকদের জমিজায়গা কেনেননি, কারণ তাঁরা ফরৌণের কাছ থেকে নিয়মিত এক ভাতা পেতেন এবং ফরৌণের দেওয়া সেই ভাতা থেকে যথেষ্ট পরিমাণ খাদ্যদ্রব্য জোগাড় হয়ে যেত। সেজন্যই তাঁরা তাঁদের জমিজায়গা বিক্রি করেননি। ");
INSERT INTO benobcv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","যোষেফ প্রজাদের বললেন, “আজ যখন আমি তোমাদেরকে ও তোমাদের জমিজায়গা ফরৌণের জন্য কিনে নিয়েছি, এই রইল তোমাদের বীজ, যেন তোমরা জমিতে তা বপন করতে পারো। ");
INSERT INTO benobcv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","কিন্তু যখন শস্য উৎপন্ন হবে, তখন তার এক-পঞ্চমাংশ তোমরা ফরৌণকে দিয়ো। অন্য চার-পঞ্চমাংশ তোমরা জমির জন্য বীজরূপে, এবং তোমাদের নিজেদের, তোমাদের পরিবার-পরিজনেদের এবং তোমাদের সন্তানদের জন্য খাদ্যদ্রব্যরূপে রাখতে পারো।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","“আপনি আমাদের প্রাণরক্ষা করেছেন,” তারা বলল। “আমরা যেন আমাদের প্রভুর দৃষ্টিতে অনুগ্রহ পাই; আমরা ফরৌণের ক্রীতদাস হয়ে থাকব।” ");
INSERT INTO benobcv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","অতএব যোষেফ সেটি মিশরে জমি সংক্রান্ত এক আইনরূপে প্রতিষ্ঠিত করে দিলেন—যা আজও বলবৎ আছে—যে উৎপন্ন শস্যের এক-পঞ্চমাংশ ফরৌণের অধিকারভুক্ত। শুধুমাত্র যাজকদের জমিজায়গাই ফরৌণের অধিকারভুক্ত হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ইস্রায়েলীরা মিশরে গোশন অঞ্চলে বসতি স্থাপন করল। তারা সেখানে বিষয়সম্পত্তি অর্জন করল এবং ফলবান হল ও সংখ্যায় ব্যাপকভাবে বৃদ্ধি পেল। ");
INSERT INTO benobcv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","যাকোব মিশরে সতেরো বছর বেঁচেছিলেন, এবং তাঁর জীবনকাল হল 147 বছর। ");
INSERT INTO benobcv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ইস্রায়েলের মৃত্যুর সময় যখন ঘনিয়ে এল, তিনি তখন তাঁর ছেলে যোষেফকে ডেকে পাঠালেন এবং তাঁকে বললেন, “আমি যদি তোমার দৃষ্টিতে অনুগ্রহ পেয়ে থাকি, তবে আমার ঊরুর নিচে তোমার হাত রেখে প্রতিজ্ঞা করো যে তুমি আমার প্রতি দয়া ও বিশ্বস্ততা দেখাবে। আমাকে মিশরে কবর দিয়ো না, ");
INSERT INTO benobcv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","কিন্তু আমি যখন আমার পূর্বপুরুষদের সাথে চিরবিশ্রামে শায়িত হব, তখন মিশর থেকে আমাকে তুলে নিয়ে যেয়ো এবং সেখানেই কবর দিয়ো যেখানে তাঁদের কবর দেওয়া হয়েছে।” “আপনি যেমনটি বললেন, আমি তেমনটিই করব,” তিনি বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“আমার কাছে প্রতিজ্ঞা করো,” তিনি বললেন। তখন যোষেফ তাঁর কাছে প্রতিজ্ঞা করলেন, এবং ইস্রায়েল তাঁর লাঠির ডগার উপর হেলান দিয়ে উপাসনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","কিছুকাল পর যোষেফকে বলা হল, “আপনার বাবা অসুস্থ হয়ে পড়েছেন।” অতএব তিনি তাঁর দুই ছেলে মনঃশি ও ইফ্রয়িমকে সঙ্গে করে নিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","যাকোবকে যখন বলা হল, “আপনার ছেলে যোষেফ আপনার কাছে এসেছেন,” তখন ইস্রায়েল শক্তি সঞ্চয় করে বিছানায় উঠে বসলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","যাকোব যোষেফকে বললেন, “সর্বশক্তিমান ঈশ্বর কনান দেশের লূসে আমাকে দর্শন দিয়েছিলেন, এবং সেখানে তিনি আমাকে আশীর্বাদ করেছিলেন ");
INSERT INTO benobcv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ও আমাকে বলেছিলেন, ‘আমি তোমাকে ফলবান করতে ও তোমার সংখ্যা বৃদ্ধি করতে চলেছি। আমি তোমাকে এক জনসমাজে পরিণত করব, এবং আমি তোমার পরে তোমার বংশধরদের এই দেশটি চিরস্থায়ী এক অধিকাররূপে দেব।’ ");
INSERT INTO benobcv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“এখন তবে, আমি তোমার কাছে এখানে আসার আগে মিশরে তোমার যে দুই ছেলে জন্মেছিল, তারা আমারই বলে গণ্য হবে; ইফ্রয়িম ও মনঃশি আমারই হবে, ঠিক যেমন রূবেণ ও শিমিয়োনও আমার। ");
INSERT INTO benobcv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","এদের পরে তোমার যে কোনো সন্তান জন্মাবে, তারা তোমারই হবে; উত্তরাধিকারসূত্রে প্রাপ্ত সেই অঞ্চলে তারা তাদের দাদাদের নামেই পরিচিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","আমি যখন পদ্দন থেকে ফিরছিলাম, তখন আমাদের যাত্রাপথেই ইফ্রাথ থেকে খানিকটা দূরে সেই কনান দেশে রাহেল মারা গিয়েছিল। তাই ইফ্রাথে (অথবা, বেথলেহেমে) যাওয়ার পথের পাশে আমি তাকে কবর দিয়েছিলাম।” ");
INSERT INTO benobcv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ইস্রায়েল যখন যোষেফের ছেলেদের দেখলেন, তখন তিনি তাঁকে জিজ্ঞাসা করলেন, “এরা কারা?” ");
INSERT INTO benobcv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“এরা সেই ছেলেরা, ঈশ্বর যাদের এখানে আমাকে দিয়েছেন,” যোষেফ তাঁর বাবাকে বললেন। তখন ইস্রায়েল বললেন, “তাদের আমার কাছে নিয়ে এসো, যেন আমি তাদের আশীর্বাদ করতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","বার্ধক্যের কারণে ইস্রায়েলের চোখের দৃষ্টি ক্ষীণ হয়ে এসেছিল, এবং দেখতে তাঁর খুব অসুবিধা হত। তাই যোষেফ নিজের ছেলেদের তাঁর খুব কাছে নিয়ে এলেন, এবং তাঁর বাবা তাদের চুমু দিলেন ও তাদের আলিঙ্গন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ইস্রায়েল যোষেফকে বললেন, “আমি কখনও আশা করিনি যে তোমার মুখ আবার দেখতে পাব, আর ঈশ্বর এখন আমাকে তোমার সন্তানদেরও দেখার সুযোগ করে দিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","পরে যোষেফ ইস্রায়েলের দুই হাঁটুর মাঝখান থেকে তাদের সরিয়ে দিলেন এবং মাটিতে মুখ ঠেকিয়ে নতজানু হলেন ");
INSERT INTO benobcv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","আর যোষেফ তাদের দুজনকে নিয়ে, ইফ্রয়িমকে নিজের ডানদিকে রেখে ইস্রায়েলের বাঁ হাতের দিকে এবং মনঃশিকে নিজের বাঁদিকে রেখে ইস্রায়েলের ডান হাতের দিকে এগিয়ে দিলেন, এবং তাঁর খুব কাছাকাছি নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","কিন্তু ইস্রায়েল তাঁর ডান হাত বাড়িয়ে দিলেন এবং তা ইফ্রয়িমের মাথায় রাখলেন, যদিও সেই ছিল ছোটো, এবং তাঁর হাত দুটি আড়াআড়িভাবে বাড়িয়ে দিয়ে, তিনি তাঁর বাঁ হাত মনঃশির মাথায় রাখলেন, যদিও মনঃশিই ছিল প্রথমজাত সন্তান। ");
INSERT INTO benobcv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","পরে তিনি যোষেফকে আশীর্বাদ করে বললেন, “আমার পূর্বপুরুষ অব্রাহাম ও ইস্‌হাক যে ঈশ্বরের সামনে বিশ্বস্ততাপূর্বক চলাফেরা করতেন, আজও পর্যন্ত আমার সমগ্র জীবনভোর যে ঈশ্বর আমার মেষপালক হয়ে থেকেছেন, ");
INSERT INTO benobcv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","যে দূত আমাকে সব অনিষ্ট থেকে রক্ষা করেছেন, তিনিই এই বালকদের আশীর্বাদ করুন। তারা আমার এবং আমার পূর্বপুরুষ অব্রাহাম ও ইস্‌হাকের নাম দ্বারাই পরিচিত হোক, আর তারা এই পৃথিবীর বুকে ব্যাপকভাবে বৃদ্ধিলাভ করুক।” ");
INSERT INTO benobcv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","যোষেফ যখন দেখলেন যে তাঁর বাবা তাঁর ডান হাত ইফ্রয়িমের মাথায় রেখেছেন তখন তিনি অসন্তুষ্ট হলেন; তাই তিনি তাঁর বাবার হাতটি মনঃশির মাথার উপর রাখার জন্য সেটি ধরে ইফ্রয়িমের মাথার উপর থেকে সরিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","যোষেফ তাঁকে বললেন, “হে আমার বাবা, না না, এই প্রথমজাত, এরই মাথার উপর আপনার ডান হাতটি রাখুন।” ");
INSERT INTO benobcv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","কিন্তু তাঁর বাবা তা প্রত্যাখ্যান করে বললেন, “আমি জানি, বাছা, আমি জানি। সেও এক জাতিতে পরিণত হবে, এবং সেও মহান হবে। তা সত্ত্বেও, তার ছোটো ভাই তার থেকেও মহান হবে এবং তার বংশধরেরা এক জাতিপুঞ্জ হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","সেদিন তিনি তাদের আশীর্বাদ করে বললেন, “তোমার নামেই ইস্রায়েল এই আশীর্বাদ উচ্চারণ করবে: ‘ঈশ্বর তোমাকে ইফ্রয়িম ও মনঃশির মতো করুন।’ ” অতএব তিনি ইফ্রয়িমকে মনঃশির আগে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","পরে ইস্রায়েল যোষেফকে বললেন, “আমি মরতে চলেছি, কিন্তু ঈশ্বর তোমাদের সহবর্তী থাকবেন এবং তোমাদের পূর্বপুরুষদের দেশে তোমাদের ফিরিয়ে নিয়ে যাবেন। ");
INSERT INTO benobcv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","আর আমি তোমার দাদা-ভাইদের যা দেব তা থেকেও তোমাকে দেশের আরও একটি বেশি শৈলশিরা দেব, যে শৈলশিরাটি আমি আমার তরোয়াল ও আমার ধনুক দিয়ে ইমোরীয়দের কাছ থেকে অধিকার করেছিলাম।” ");
INSERT INTO benobcv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","পরে যাকোব তাঁর ছেলেদের ডেকে বললেন: “তোমরা একত্রিত হও যেন আমি তোমাদের বলে দিতে পারি আগামী দিনগুলিতে তোমাদের প্রতি কী ঘটবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“হে যাকোবের সন্তানেরা, জমায়েত হও ও শোনো; তোমাদের বাবা ইস্রায়েলের কথা শোনো। ");
INSERT INTO benobcv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“হে রূবেণ, তুমি আমার প্রথমজাত, আমার বল, আমার শক্তির প্রথম চিহ্ন, সম্মানে উত্তম, পরাক্রমে উত্তম। ");
INSERT INTO benobcv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","জলের মতো অদম্য বলে, তুমি আর শ্রেষ্ঠতর হবে না, কারণ তুমি তোমার বাবার বিছানায়, আমার শয্যায় গেলে ও সেটি কলুষিত করলে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“শিমিয়োন ও লেবি দুই ভাই— তাদের তরোয়ালগুলি হিংস্রতার অস্ত্রশস্ত্র। ");
INSERT INTO benobcv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","তাদের মন্ত্রণা-সভায় আমি যেন না ঢুকি, তাদের সমাবেশে যেন যোগ না দিই, কারণ তাদের ক্রোধে তারা মানুষজনকে হত্যা করেছিল এবং তাদের খেয়ালখুশি মতো তারা বলদদের পায়ের শিরা কেটে দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","অভিশপ্ত হোক তাদের ক্রোধ, যা এত প্রচণ্ড, আর তাদের উন্মত্ততা, যা এত নিষ্ঠুর! যাকোবের মধ্যে আমি তাদের ইতস্তত ছড়িয়ে দেব এবং ইস্রায়েলের মধ্যে তাদের বিক্ষিপ্ত করে দেব। ");
INSERT INTO benobcv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“হে যিহূদা, তোমার দাদা-ভাইয়েরা তোমার প্রশংসা করবে; তোমার শত্রুদের ঘাড়ে তোমার হাত থাকবে; তোমার বাবার ছেলেরা তোমার কাছে মাথা নত করবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","তুমি এক সিংহশাবক, হে যিহূদা; বাছা, তুমি শিকার করে ফিরে এলে। এক সিংহের মতো সে গুড়ি মারে ও শুয়ে থাকে, এক সিংহীর মতো—কে তাকে জাগাতে সাহস করে? ");
INSERT INTO benobcv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","যিহূদা থেকে রাজদণ্ড বিদায় নেবে না, তার দুই পায়ের ফাঁক থেকে শাসকের ছড়িও সরে যাবে না, যতদিন না তিনি আসছেন সেটি যাঁর অধিকারভুক্ত আর জাতিদের সেই আনুগত্য তাঁরই হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","সে এক দ্রাক্ষালতায় তার গাধা বেঁধে রাখবে, তার অশ্বশাবক সেই পছন্দসই ডালে বেঁধে রাখবে; দ্রাক্ষারসে সে তার জামাকাপড় ধোবে, তার আলখাল্লাগুলি ধোবে দ্রাক্ষারসের রক্তে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","তার চোখদুটি দ্রাক্ষারসের থেকেও বেশি রক্তবর্ণ হবে, তার দাঁতগুলি দুধের থেকেও বেশি সাদা হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“সবূলূন সমুদ্রতীরে বসবাস করবে আর জাহাজগুলির জন্য এক পোতাশ্রয় হবে; তার সীমানা সীদোনের দিকে প্রসারিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ইষাখর এক কঙ্কালসার গাধা মেষ-খোঁয়াড়ের মধ্যে যে পড়ে আছে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","যখন সে দেখবে তার বিশ্রামস্থান কত সুন্দর ও তার দেশ কত সুখকর, তখন ভারবহনের জন্য সে তার কাঁধ নত করবে ও কষ্টকল্পিত পরিশ্রমের প্রতি সমর্পিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ইস্রায়েলের গোষ্ঠীগুলির মধ্যে এক গোষ্ঠীরূপে দান তার লোকজনের জন্য ন্যায় প্রদান করবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","দান পথের পাশে পড়ে থাকা এক সাপ, সেই পথ বরাবর এমন এক বিষধর সাপ হবে, যে ঘোড়ার গোড়ালিতে ছোবল মারে যেন সেটির সওয়ার পিছন-পানে ডিগবাজি খায়। ");
INSERT INTO benobcv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“হে সদাপ্রভু, আমি তোমার উদ্ধারের প্রত্যাশা করছি। ");
INSERT INTO benobcv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“গাদ এক আক্রমণকারী দল দ্বারা আক্রান্ত হবে, কিন্তু সে তাদের গোড়ালি লক্ষ্য করে তাদের আক্রমণ করবে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“আশেরের খাদ্যদ্রব্য হবে সমৃদ্ধ; সে এমন সুস্বাদু খাদ্য জোগাবে যা এক রাজার পক্ষে মানানসই। ");
INSERT INTO benobcv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“নপ্তালি এমন এক বাঁধনমুক্ত হরিণী যা সুন্দর সুন্দর হরিণশিশু গর্ভে ধারণ করে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“যোষেফ এক ফলবান দ্রাক্ষালতা, এক নির্ঝরিণীর কাছে স্থিত এক ফলবান দ্রাক্ষালতা, যার শাখাপ্রশাখাগুলি এক দেয়াল বেয়ে ওঠে। ");
INSERT INTO benobcv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","তিক্ততা সমেত তিরন্দাজরা তাকে আক্রমণ করেছিল; শত্রুতা দেখিয়ে তারা তার দিকে তির ছুঁড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","কিন্তু তার ধনুক অবিচলিত থেকেছিল, তার শক্তিশালী হাত দুটি নমনীয় হয়েই ছিল, যাকোবের সেই শক্তিমান-জনের সেই হাতের কারণে, ইস্রায়েলের সেই মেষপালকের, সেই শৈলের কারণে, ");
INSERT INTO benobcv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","তোমার পৈত্রিক সেই ঈশ্বরের কারণে, যিনি তোমাকে সাহায্য করবেন, সেই সর্বশক্তিমানের কারণে, যিনি তোমাকে আশীর্বাদ করবেন ঊর্ধ্বস্থিত আকাশের আশীর্বাদসহ, নিচস্থ গভীর নির্ঝরিণীর আশীর্বাদসহ, স্তন ও গর্ভের আশীর্বাদসহ। ");
INSERT INTO benobcv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","তোমার পৈত্রিক আশীর্বাদগুলি সেই প্রাচীন পাহাড়-পর্বতের আশীর্বাদগুলির চেয়েও মহত্তর, শতাব্দী-প্রাচীন পাহাড়গুলির দানশীলতার চেয়েও মহত্তর। এসব কিছু যোষেফের মাথায় স্থির হোক, তার দাদা-ভাইদের মধ্যে যে নায়ক, তার ললাটে গিয়ে পড়ুক। ");
INSERT INTO benobcv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“বিন্যামীন এক বুভুক্ষু নেকড়ে; সকালবেলায় সে শিকার গ্রাস করে, সন্ধ্যাবেলায় সে লুন্ঠিত জিনিসপত্র ভাগবাঁটোয়ারা করে।” ");
INSERT INTO benobcv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","এরা সবাই ইস্রায়েলের সেই বারো বংশ, এবং তাঁদের বাবা প্রত্যেককে যথাযথ আশীর্বাদ দিয়ে তাঁদের আশীর্বাদ করার সময় তাঁদের এই কথাগুলিই বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","পরে তিনি তাঁদের এইসব নির্দেশ দিলেন: “আমি আমার পরিজনবর্গের সঙ্গে একত্রিত হতে যাচ্ছি। আমাকে আমার পূর্বপুরুষদের সঙ্গে হিত্তীয় ইফ্রোণের ক্ষেতের সেই গুহায় কবর দিয়ো, ");
INSERT INTO benobcv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","যে গুহাটি কনানে মম্রির পার্শ্ববর্তী মক্‌পেলার ক্ষেতে অবস্থিত, যেটি অব্রাহাম হিত্তীয় ইফ্রোণের কাছ থেকে ক্ষেতসহ এক কবরস্থানরূপে কিনেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","সেখানে অব্রাহাম এবং তাঁর স্ত্রী সারাকে কবর দেওয়া হয়েছিল, সেখানেই ইস্‌হাক ও তাঁর স্ত্রী রিবিকাকে কবর দেওয়া হয়েছিল, এবং সেখানেই আমি লেয়াকে কবর দিয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","সেই ক্ষেত ও সেই গুহাটি হিত্তীয়দের কাছ থেকে কেনা হয়েছিল।” ");
INSERT INTO benobcv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","যাকোব তাঁর ছেলেদের নির্দেশদান সমাপ্ত করার পর, তিনি তাঁর পা-দুটি বিছানায় টেনে আনলেন, শেষনিশ্বাস ত্যাগ করলেন এবং তাঁর পরিজনবর্গের সঙ্গে একত্রিত হলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","যোষেফ তাঁর বাবার উপর ঝাঁপিয়ে পড়লেন এবং কাঁদতে কাঁদতে তাঁকে চুমু দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","পরে যোষেফ তাঁর সেবায় নিয়োজিত চিকিৎসকদের তাঁর বাবা ইস্রায়েলের দেহটি সুগন্ধি বস্তু দ্বারা রক্ষা করার নির্দেশ দিলেন। অতএব চিকিৎসকরা তাঁর দেহটি সুগন্ধি বস্তু দ্বারা সংরক্ষণ করলেন, ");
INSERT INTO benobcv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","তাঁরা পুরো চল্লিশ দিন সময় নিলেন, কারণ সুগন্ধি বস্তু দ্বারা শবদেহ সংরক্ষণ করার জন্য এতখানিই সময় লাগত। আর মিশরীয়রা তাঁর জন্য সত্তর দিন শোক পালন করল। ");
INSERT INTO benobcv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","যখন শোকপালনকাল অতিবাহিত হয়ে গেল, তখন যোষেফ ফরৌণের রাজসভাসদদের কাছে গিয়ে বললেন, “আমি যদি আপনাদের দৃষ্টিতে অনুগ্রহ পেয়ে থাকি, তবে আমার হয়ে ফরৌণের কাছে একথা বলুন। তাঁকে বলুন, ");
INSERT INTO benobcv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘আমার বাবা আমাকে দিয়ে এক প্রতিজ্ঞা করিয়ে নিয়েছিলেন এবং বলেছিলেন, “আমি মরতে চলেছি; কনান দেশে আমি নিজের জন্য যে কবর খুঁড়ে রেখেছি সেখানেই আমাকে কবর দিয়ো।” এখন আমাকে গিয়ে আমার বাবাকে কবর দিয়ে আসতে দিন; পরে আমি ফিরে আসব।’ ” ");
INSERT INTO benobcv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ফরৌণ বললেন, “যাও ও তোমার বাবাকে কবর দাও, যেমনটি করার জন্য তিনি তোমাকে দিয়ে প্রতিজ্ঞা করিয়ে নিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","অতএব যোষেফ তাঁর বাবাকে কবর দিতে গেলেন। ফরৌণের সব কর্মকর্তা যোষেফের সাথী হলেন—তাঁর দরবারের বিশিষ্ট ব্যক্তিবর্গ ও মিশরের সব বিশিষ্ট ব্যক্তিবর্গ— ");
INSERT INTO benobcv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","এছাড়াও যোষেফের পরিবারের সব সদস্য ও তাঁর দাদা-ভাইয়েরা এবং তাঁর পৈত্রিক পরিবারের অন্তর্গত সকলে তাঁর সঙ্গে গেলেন। শুধুমাত্র তাঁদের সন্তানেরা, এবং তাঁদের মেষপাল ও পশুপাল গোশনে থেকে গেল। ");
INSERT INTO benobcv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","রথ ও অশ্বারোহীরাও তাঁর সঙ্গে গেল। সে ছিল বিশাল এক সমবেত জনসমষ্টি। ");
INSERT INTO benobcv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","তাঁরা যখন জর্ডনের কাছে আটদের খামারে পৌঁছালেন, তখন তাঁরা তারস্বরে ও তীব্রভাবে কান্নাকাটি করলেন; এবং যোষেফ সেখানে তাঁর বাবার জন্য সাত দিন ধরে শোক পালন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","যে কনানীয়রা সেখানে বসবাস করত, তারা যখন আটদের খামারে তাদের শোক পালন করতে দেখল, তখন তারা বলল, “মিশরীয়রা শোকের এক গুরুগম্ভীর অনুষ্ঠান পালন করছে।” সেজন্যই জর্ডনের কাছে অবস্থিত সেই স্থানটি আবেল-মিস্রয়ীম নামে আখ্যাত হল। ");
INSERT INTO benobcv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","অতএব যাকোবের ছেলেরা তাই করলেন, যা তিনি তাঁদের আদেশ দিয়েছিলেন: ");
INSERT INTO benobcv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","তাঁরা তাঁকে কনান দেশে বয়ে নিয়ে গেলেন এবং তাঁকে মম্রির কাছে, মক্‌পেলার সেই ক্ষেতে অবস্থিত গুহায় কবর দিলেন, যেটি অব্রাহাম হিত্তীয় ইফ্রোণের কাছ থেকে ক্ষেতজমিসহ এক কবরস্থানরূপে কিনে নিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","তাঁর বাবাকে কবর দেওয়ার পর, যোষেফ তাঁর দাদা-ভাইদের ও অন্যান্য সেইসব লোকজনের সাথে মিশরে ফিরে এলেন, যারা তাঁর বাবাকে কবর দেওয়ার জন্য তাঁর সঙ্গে সেখানে গিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","যোষেফের দাদা-ভাইয়েরা যখন দেখলেন যে তাঁদের বাবা মারা গিয়েছেন, তখন তাঁরা বললেন, “যোষেফ যদি আমাদের বিরুদ্ধে আক্রোশ পুষে রাখে ও তার প্রতি আমরা যেসব অন্যায় করেছি সে যদি তার প্রতিশোধ নেয়, তবে কী হবে?” ");
INSERT INTO benobcv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","অতএব তাঁরা যোষেফের কাছে খবর পাঠিয়ে, বললেন, “তোমার বাবা মারা যাওয়ার আগে এসব নির্দেশ দিয়ে গিয়েছেন: ");
INSERT INTO benobcv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘যোষেফকে তোমাদের এই কথাটি বলতে হবে: তোমার দাদারা তোমার প্রতি এত খারাপ ব্যবহার করে যে পাপ ও অন্যায় করেছে আমি চাই তুমি যেন তা ক্ষমা করে দাও।’ এখন দয়া করে তোমার পৈত্রিক ঈশ্বরের দাসদের পাপগুলি ক্ষমা করে দাও।” তাঁদের এই খবর যখন যোষেফের কাছে এসে পৌঁছাল, তখন তিনি কেঁদে ফেললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","তাঁর দাদা-ভাইয়েরা পরে তাঁর কাছে এলেন এবং তাঁর সামনে নতমস্তক হয়ে প্রণাম করলেন। “আমরা তোমার ক্রীতদাস,” তাঁরা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","কিন্তু যোষেফ তাঁদের বললেন, “ভয় পেয়ো না। আমি কি ঈশ্বরের স্থলাভিষিক্ত? ");
INSERT INTO benobcv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","তোমরা আমার ক্ষতি করার সংকল্প করলে, কিন্তু এখন যা কিছু হয়েছে তা ভালোর জন্যই, প্রচুর প্রাণরক্ষা করার জন্য ঈশ্বরই মনস্থ করে রেখেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","তাই এখন, ভয় পেয়ো না। আমি তোমাদের ও তোমাদের সন্তানদের জন্য রসদপত্র জোগাব।” আর তিনি আবার তাঁদের আশ্বস্ত করলেন এবং তাঁদের সাথে সদয় কথাবার্তা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","যোষেফ তাঁর পৈত্রিক পরিবারের সব লোকজনকে সঙ্গে নিয়ে মিশরে থেকে গেলেন। তিনি 110 বছর বেঁচেছিলেন ");
INSERT INTO benobcv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","এবং ইফ্রয়িমের সন্তানদের তৃতীয় প্রজন্মকে স্বচক্ষে দেখলেন। এছাড়াও মনঃশির ছেলে মাখীরের সন্তানদেরও জন্মের সময় যোষেফের কোলেই রাখা হল। ");
INSERT INTO benobcv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","পরে যোষেফ তাঁর দাদা-ভাইদের বললেন, “আমি মরতে চলেছি। কিন্তু ঈশ্বর নিঃসন্দেহে তোমাদের সাহায্য করতে এগিয়ে আসবেন এবং তোমাদের এই দেশ থেকে বের করে সেই দেশে নিয়ে যাবেন, যেটি তিনি অব্রাহাম, ইস্‌হাক ও যাকোবকে দেওয়ার প্রতিজ্ঞা করেছিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","আর যোষেফ ইস্রায়েলীদের দিয়ে একটি প্রতিজ্ঞা করিয়ে নিলেন ও বললেন, “ঈশ্বর নিঃসন্দেহে তোমাদের সাহায্য করতে এগিয়ে আসবেন, এবং তখন তোমাদের অবশ্যই আমার অস্থি এই স্থান থেকে বয়ে নিয়ে যেতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","অতএব যোষেফ 110 বছর বয়সে মারা গেলেন। আর তাঁরা তাঁকে সুগন্ধি বস্তু দ্বারা সংরক্ষণ করার পর তাঁর মৃতদেহ মিশরে একটি শবাধারের মধ্যে রেখে দেওয়া হল।");
INSERT INTO benobcv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","এই হল ইস্রায়েলের সেই ছেলেদের নাম, যাঁরা প্রত্যেকে নিজের পরিবারসহ যাকোবের সঙ্গে মিশরে গিয়েছিলেন: ");
INSERT INTO benobcv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","রূবেণ, শিমিয়োন, লেবি ও যিহূদা; ");
INSERT INTO benobcv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ইষাখর, সবূলূন ও বিন্যামীন; ");
INSERT INTO benobcv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","দান ও নপ্তালি; গাদ ও আশের। ");
INSERT INTO benobcv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","যাকোবের বংশধররা সংখ্যায় হল মোট সত্তরজন; যোষেফ ইতিপূর্বে মিশরেই ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","এদিকে যোষেফ ও তাঁর সব দাদা-ভাই, এবং সেই প্রজন্মের সবাই মারা গেলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","কিন্তু ইস্রায়েলীরা অত্যন্ত ফলবান হল; তারা প্রচুর পরিমাণে বংশবৃদ্ধি করল, সংখ্যায় বৃদ্ধি পেয়ে এত সংখ্যক হয়ে উঠল যে সে দেশটি তাদের দিয়েই পরিপূর্ণ হয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","পরে এমন এক নতুন রাজা মিশরের ক্ষমতায় এলেন, যাঁর কাছে যোষেফের কোনও গুরুত্বই ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“দেখো,” তিনি তাঁর প্রজাদের বললেন, “ইস্রায়েলীরা আমাদের পক্ষে বড়ো বেশি সংখ্যক হয়ে পড়েছে। ");
INSERT INTO benobcv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","এসো, আমরা তাদের প্রতি প্রজ্ঞাপূর্বক ব্যবহার করি, তা না হলে তারা এর চেয়েও বেশি সংখ্যক হয়ে যাবে এবং, যদি যুদ্ধ শুরু হয়ে যায়, তারা আমাদের শত্রুদের সাথে যোগ দেবে, আমাদের বিরুদ্ধে লড়াই করবে ও দেশ ছেড়ে চলে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","অতএব তারা বাধ্যতামূলকভাবে পরিশ্রম করিয়ে ইস্রায়েলীদের নিগৃহীত করার জন্য তাদের উপর কড়া তত্ত্বাবধায়কদের নিযুক্ত করে দিল, এবং তারা ফরৌণের জন্য ভাণ্ডার-নগরীরূপে পিথোম ও রামিষেষ গেঁথে তুলল। ");
INSERT INTO benobcv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","কিন্তু যত বেশি তাদের নিপীড়িত করা হল, তত বেশি তাদের সংখ্যা বৃদ্ধি হল ও তারা ছড়িয়ে পড়ল; অতএব মিশরীয়রা ইস্রায়েলীদের ভয় পেতে শুরু করল ");
INSERT INTO benobcv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","এবং তারা নির্মমভাবে তাদের খাটাতে লাগল। ");
INSERT INTO benobcv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ইট ও চুনসুরকির কাজে এবং চাষবাসের সব ধরনের কাজে কঠোর পরিশ্রম করিয়ে তারা তাদের জীবন দুর্বিষহ করে তুলল; মিশরীয়রা নির্মমভাবে তাদের কাছে কঠোর পরিশ্রম দাবি করল। ");
INSERT INTO benobcv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","মিশরের রাজা শিফ্রা ও পূয়া নামাঙ্কিত হিব্রু ধাত্রীদের বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“প্রসব-শয্যায় তোমরা যখন সন্তান প্রসবের সময় হিব্রু মহিলাদের সাহায্য করছ, তখন যদি তোমরা দেখো যে শিশুটি এক পুত্রসন্তান, তবে তাকে মেরে ফেলো; কিন্তু সে যদি এক কন্যাসন্তান হয়, তবে তাকে বাঁচিয়ে রেখো।” ");
INSERT INTO benobcv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","সেই ধাত্রীরা অবশ্য ঈশ্বরকে ভয় করত ও মিশরের রাজা তাদের যা করতে বললেন, তারা তা করল না; তারা শিশুপুত্রদের বাঁচিয়ে রাখল। ");
INSERT INTO benobcv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","তখন মিশরের রাজা সেই ধাত্রীদের ডেকে পাঠিয়ে তাদের জিজ্ঞাসা করলেন, “তোমরা এরকম কেন করলে? তোমরা শিশুপুত্রদের বাঁচিয়ে রাখলে কেন?” ");
INSERT INTO benobcv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","তারা ফরৌণকে উত্তর দিল, “হিব্রু মহিলারা মিশরীয় মহিলাদের মতো নয়; তারা সবলা ও ধাত্রীরা পৌঁছানোর আগেই তারা সন্তান প্রসব করে ফেলে।” ");
INSERT INTO benobcv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","অতএব ঈশ্বর সেই ধাত্রীদের প্রতি দয়ালু হলেন এবং ইস্রায়েলীরা বৃদ্ধি পেয়ে আরও বহুসংখ্যক হয়ে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","আর যেহেতু সেই ধাত্রীরা ঈশ্বরকে ভয় করত, তাই তিনি তাদের নিজস্ব পরিবার দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","পরে ফরৌণ তাঁর সব প্রজাকে এই আদেশ দিলেন: “সদ্যজাত প্রত্যেকটি হিব্রু পুত্রসন্তানকে তোমরা অবশ্যই নীলনদে ছুঁড়ে ফেলবে, কিন্তু প্রত্যেকটি কন্যাসন্তানকে জীবিত রাখবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","এদিকে লেবি বংশের একজন লোক এক লেবীয় মহিলাকে বিয়ে করলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","আর সেই মহিলাটি গর্ভবতী হলেন ও এক পুত্রসন্তানের জন্ম দিলেন। যখন তিনি দেখলেন যে শিশুটি দেখতে খুব সুন্দর, তখন তিনি তাকে তিন মাস ধরে লুকিয়ে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","কিন্তু যখন তিনি তাকে আর লুকিয়ে রাখতে পারলেন না, তখন তিনি তার জন্য নলখাগড়া দিয়ে একটি ডালি তৈরি করলেন ও সেটিতে আলকাতরা ও পিচ লেপন করে দিলেন। পরে তিনি সেই শিশুটিকে সেটির মধ্যে শুইয়ে দিয়ে সেটি নীলনদের পাড়ে নলবনের মধ্যে রেখে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","শিশুটির দিদি একটু দূরে দাঁড়িয়ে লক্ষ্য রাখছিল তার ভাইয়ের প্রতি কী ঘটতে চলেছে। ");
INSERT INTO benobcv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","পরে ফরৌণের মেয়ে নীলনদে স্নান করার জন্য নামলেন, এবং তাঁর পরিচারিকারা তাঁর পাশে পাশে নদীর পাড় ধরে হাঁটছিল। তিনি নলবনের মধ্যে সেই ডালিটি দেখতে পেলেন এবং সেটি তুলে আনার জন্য তিনি তাঁর ক্রীতদাসীকে পাঠালেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","তিনি সেটি খুললেন ও সেই শিশুটিকে দেখতে পেলেন। সে কাঁদছিল, আর তার জন্য তাঁর দুঃখ হল। “এ হিব্রু শিশুদের মধ্যেই একজন,” তিনি বললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","তখন সেই শিশুটির দিদি ফরৌণের মেয়েকে জিজ্ঞাসা করল, “আমি কি গিয়ে হিব্রু মহিলাদের মধ্যে একজনকে ডেকে আনব, যে আপনার জন্য এই শিশুটির শুশ্রুষা করবে?” ");
INSERT INTO benobcv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“হ্যাঁ, যাও,” ফরৌণের মেয়ে উত্তর দিলেন। অতএব সেই মেয়েটি গিয়ে শিশুটির মাকে ডেকে আনল। ");
INSERT INTO benobcv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ফরৌণের মেয়ে তাঁকে বললেন, “এই শিশুটিকে নিয়ে যাও ও আমার হয়ে এর শুশ্রুষা করো, আর আমি তোমাকে বেতন দেব।” অতএব সেই মহিলাটি শিশুটিকে নিয়ে তার শুশ্রুষা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","শিশুটি যখন বড়ো হল, তখন তিনি তাকে ফরৌণের মেয়ের কাছে নিয়ে এলেন ও সে তাঁর ছেলে হয়ে গেল। “আমি তাকে জল থেকে টেনে তুলেছি,” এই বলে তিনি তার নাম দিলেন মোশি। ");
INSERT INTO benobcv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","একদিন, মোশি বড়ো হয়ে যাওয়ার পর, যেখানে তাঁর নিজস্ব লোকজনেরা ছিল, তিনি সেখানে গেলেন ও দেখলেন তারা কঠোর পরিশ্রম করছে। তিনি দেখতে পেলেন একজন মিশরীয় লোক একজন হিব্রু লোককে মারধর করছে, যে কি না তাঁর নিজস্ব লোকজনের মধ্যেই একজন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","এদিক-ওদিক তাকিয়ে, কাউকে দেখতে না পেয়ে তিনি সেই মিশরীয় লোকটিকে হত্যা করলেন ও তাকে বালিতে পুঁতে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","পরদিন তিনি বাইরে গেলেন ও দেখতে পেলেন দুজন হিব্রু লোক মারপিট করছে। যে অন্যায় করেছিল তিনি তাকে জিজ্ঞাসা করলেন, “তুমি কেন তোমার স্বজাতীয় হিব্রু ভাইকে মারছ?” ");
INSERT INTO benobcv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","সেই লোকটি বলল, “কে তোমাকে আমাদের উপর শাসক ও বিচারক নিযুক্ত করেছে? যেভাবে তুমি সেই মিশরীয় লোকটিকে হত্যা করেছিলে, সেভাবে আমাকেও কি হত্যা করার কথা ভাবছ?” তখন মোশি ভয় পেয়ে গিয়ে ভাবলেন, “আমি যা করেছি তা নিশ্চয় লোকেরা জেনে ফেলেছে।” ");
INSERT INTO benobcv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ফরৌণ যখন তা শুনতে পেলেন, তখন তিনি মোশিকে হত্যা করার চেষ্টা করলেন, কিন্তু মোশি ফরৌণের কাছ থেকে পালিয়ে মিদিয়নে বসবাস করতে চলে গেলেন, ও সেখানে গিয়ে তিনি এক কুয়োর পাড়ে বসে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","মিদিয়নীয় এক যাজকের সাতটি মেয়ে ছিল, এবং তারা তাদের বাবার মেষপালকে জলপান করাবার জন্য জল তুলতে ও জাবপাত্র ভরতে এসেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","কয়েকজন মেষপালক সেখানে এসে তাদের তাড়িয়ে দিল, কিন্তু মোশি উঠে দাঁড়ালেন ও তাদের রক্ষাকর্তা হয়ে তাদের মেষপালকে জলপান করালেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","সেই মেয়েরা যখন তাদের বাবা রূয়েলের কাছে ফিরে গেল, তখন তিনি তাদের জিজ্ঞাসা করলেন, “আজ তোমরা কেন এত তাড়াতাড়ি ফিরে এলে?” ");
INSERT INTO benobcv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","তারা উত্তর দিল, “একজন মিশরীয় লোক মেষপালকদের হাত থেকে আমাদের রক্ষা করেছেন। এমনকি তিনি আমাদের জন্য জল তুলে দিলেন ও আমাদের মেষপালকে জলপান করালেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“আর তিনি কোথায়?” রূয়েল তাঁর মেয়েদের জিজ্ঞাসা করলেন। “তোমরা কেন তাঁকে ছেড়ে এলে? কিছু খাওয়ার জন্য তাঁকে নিমন্ত্রণ করো।” ");
INSERT INTO benobcv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","মোশি সেই লোকটির সঙ্গে থাকতে সম্মত হলেন, যিনি মোশির সঙ্গে তাঁর মেয়ে সিপ্পোরার বিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","সিপ্পোরা এক পুত্রসন্তানের জন্ম দিলেন, ও মোশি এই বলে তার নাম দিলেন গের্শোম যে “বিদেশভূমিতে আমি এক বিদেশি হয়ে গেলাম।” ");
INSERT INTO benobcv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","সুদীর্ঘ সময়কাল পার হয়ে যাওয়ার পর, মিশরের রাজা মারা গেলেন। ইস্রায়েলীরা তাদের ক্রীতদাসত্বের কারণে যন্ত্রণা পেয়ে গভীর আর্তনাদ করে উঠল, এবং তাদের ক্রীতদাসত্বের কারণে তাদের চাওয়া সাহায্যের আকুতি ঈশ্বরের কাছে পৌঁছে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ঈশ্বর তাদের কান্না শুনলেন এবং অব্রাহাম, ইস্‌হাক ও যাকোবের সঙ্গে করা তাঁর নিয়মটি তিনি স্মরণ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","অতএব ঈশ্বর ইস্রায়েলীদের দিকে দৃষ্টিপাত করলেন ও তাদের বিষয়ে উদ্বিগ্ন হলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","মোশি এক সময় তাঁর শ্বশুর, মিদিয়নীয় যাজক যিথ্রোর মেষপাল চরাচ্ছিলেন, এবং সেই পালকে দূরে মরুপ্রান্তরের এক প্রান্তে চরাতে চরাতে তিনি হোরেবে সদাপ্রভুর পর্বতে পৌঁছে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","সেখানে এক ঝোপের মধ্যে থেকে সদাপ্রভুর দূত আগুনের শিখায় মোশির কাছে আবির্ভূত হলেন। মোশি দেখলেন যে যদিও ঝোপটি জ্বলছে তবুও তা পুড়ে শেষ হচ্ছে না। ");
INSERT INTO benobcv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","অতএব মোশি ভাবলেন, “আমি পরিদর্শনে যাব ও এই অদ্ভুত ঘটনাটি দেখব—কেন ঝোপটি পুড়ে শেষ হচ্ছে না।” ");
INSERT INTO benobcv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","সদাপ্রভু যখন দেখলেন যে মোশি দেখার জন্য পরিদর্শনে গিয়েছেন, তখন ঈশ্বর সেই ঝোপের মধ্যে থেকে মোশিকে ডেকে বললেন, “মোশি, মোশি!” আর মোশি বললেন, “আমি এখানে।” ");
INSERT INTO benobcv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“আর কাছে এসো না,” ঈশ্বর বললেন। “তোমার চটিজুতো খুলে ফেলো, কারণ তুমি যে স্থানে দাঁড়িয়ে আছ সেটি পবিত্র ভূমি।” ");
INSERT INTO benobcv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","পরে তিনি বললেন, “আমি তোমার পৈত্রিক ঈশ্বর, অব্রাহামের ঈশ্বর, ইস্‌হাকের ঈশ্বর ও যাকোবের ঈশ্বর।” তখন মোশি তাঁর মুখ আড়াল করলেন, কারণ তিনি ঈশ্বরের দিকে তাকাতে ভয় পেয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","সদাপ্রভু বললেন, “আমি সত্যিই মিশরে আমার প্রজাদের দুর্দশা দেখেছি। তাদের উপর নিযুক্ত ক্রীতদাস পরিচালকদের কারণে তারা যে কান্নাকাটি করছে তা আমি শুনেছি, এবং তাদের কায়ক্লেশের বিষয়ে আমি উদ্বিগ্ন হয়ে পড়েছি। ");
INSERT INTO benobcv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","তাই মিশরীয়দের হাত থেকে তাদের রক্ষা করার জন্য এবং সেদেশ থেকে মনোরম ও প্রশস্ত এক দেশে, দুধ ও মধু প্রবাহিত এক দেশে—কনানীয়, হিত্তীয়, ইমোরীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়দের স্বদেশে তাদের নিয়ে যাওয়ার জন্য আমি নেমে এসেছি। ");
INSERT INTO benobcv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","আর এখন ইস্রায়েলীদের কান্না আমার কাছে পৌঁছে গিয়েছে এবং আমি দেখেছি কীভাবে সেই মিশরীয়রা তাদের নিগৃহীত করছে। ");
INSERT INTO benobcv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","অতএব এখন, যাও। মিশর থেকে আমার প্রজা ইস্রায়েলীদের বের করে আনার জন্য আমি তোমাকে ফরৌণের কাছে পাঠাচ্ছি।” ");
INSERT INTO benobcv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","কিন্তু মোশি ঈশ্বরকে বললেন, “আমি কে যে আমাকে ফরৌণের কাছে যেতে হবে ও মিশর থেকে ইস্রায়েলীদের বের করে আনতে হবে?” ");
INSERT INTO benobcv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","আর ঈশ্বর বললেন, “আমি তোমার সঙ্গে থাকব। আর আমিই যে তোমাকে পাঠিয়েছি তার চিহ্ন হবে এই: তুমি যখন মিশর থেকে লোকদের বের করে আনবে, তখন এই পর্বতে তোমরা ঈশ্বরের আরাধনা করবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","মোশি ঈশ্বরকে বললেন, “ধরে নিন আমি ইস্রায়েলীদের কাছে গেলাম ও তাদের বললাম, ‘তোমাদের পূর্বপুরুষদের ঈশ্বর আমাকে তোমাদের কাছে পাঠিয়েছেন,’ এবং তারা আমাকে জিজ্ঞাসা করবে, ‘তাঁর নাম কী?’ তখন আমি তাদের কী বলব?” ");
INSERT INTO benobcv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ঈশ্বর মোশিকে বললেন, “আমি যে আছি, সেই আছি। ইস্রায়েলীদের তোমাকে একথাই বলতে হবে: ‘আমি আছি আমাকে তোমাদের কাছে পাঠিয়েছেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","এছাড়াও ঈশ্বর মোশিকে বললেন, “ইস্রায়েলীদের বোলো, ‘সদাপ্রভু, তোমাদের পূর্বপুরুষদের ঈশ্বর—অব্রাহামের ঈশ্বর, ইস্‌হাকের ঈশ্বর ও যাকোবের ঈশ্বর—আমাকে তোমাদের কাছে পাঠিয়েছেন।’ “এটিই আমার অনন্তকালীন নাম, যে নামে তোমরা আমায় প্রজন্মের পর প্রজন্ম ধরে ডাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“যাও, ইস্রায়েলের প্রাচীনদের সমবেত করো ও তাদের বলো, ‘সদাপ্রভু, তোমাদের পূর্বপুরুষদের ঈশ্বর—অব্রাহামের ঈশ্বর, ইস্‌হাকের ঈশ্বর ও যাকোবের ঈশ্বর—আমাকে দর্শন দিয়ে বললেন: আমি তোমাদের পাহারা দিয়েছিলাম এবং দেখেছিলাম মিশরে তোমাদের প্রতি কী করা হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","আর আমি তোমাদের মিশরের দুর্দশা থেকে বের করে এনে কনানীয়, হিত্তীয়, ইমোরীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়দের দেশে—দুধ ও মধু প্রবাহিত সেই দেশে নিয়ে যাওয়ার প্রতিজ্ঞা করলাম।’ ");
INSERT INTO benobcv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ইস্রায়েলের প্রাচীনেরা তোমার কথা শুনবে। পরে তোমাকে ও সেই প্রাচীনদের মিশররাজের কাছে গিয়ে তাকে বলতে হবে, ‘সদাপ্রভু, হিব্রুদের ঈশ্বর, আমাদের দেখা দিয়েছেন। মরুপ্রান্তরে তিনদিনের পথযাত্রা করে আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশে আমাদের বলি উৎসর্গ করে আসতে দিন।’ ");
INSERT INTO benobcv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","কিন্তু আমি জানি যে মিশররাজ ততক্ষণ তোমাদের যেতে দেবে না, যতক্ষণ না এক বলশালী হাত তাকে বাধ্য করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","অতএব আমি আমার হাত বাড়িয়ে দেব ও সেইসব আশ্চর্য কাজের মাধ্যমে মিশরীয়দের আঘাত হানব, যেগুলি আমি তাদের মধ্যে সম্পন্ন করতে চলেছি। পরে, সে তোমাদের যেতে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“আর এই জাতির প্রতি মিশরীয়দের আমি এত অনুগ্রহকারী হতে দেব, যে যখন তোমরা দেশ ছেড়ে যাবে, তখন তোমাদের খালি হাতে যেতে হবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","প্রত্যেকটি মহিলাকে তার প্রতিবেশিনী ও তার বাড়িতে বসবাসকারী যে কোনো মহিলার কাছ থেকে রুপো ও সোনার গয়নাগাটি এবং পোশাক-পরিচ্ছদ চেয়ে নিতে হবে, যেগুলি তোমরা তোমাদের ছেলেমেয়েদের গায়ে পরিয়ে দেবে। আর এইভাবে তোমরা মিশরীয়দের উপর লুঠতরাজ চালাবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","মোশি উত্তর দিলেন, “তারা যদি আমার কথা বিশ্বাস না করে বা আমার কথা না শোনে ও বলে, ‘সদাপ্রভু তোমার কাছে আবির্ভূত হননি,’ তবে কী হবে?” ");
INSERT INTO benobcv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","তখন সদাপ্রভু তাঁকে বললেন, “তোমার হাতে ওটি কী?” “একটি ছড়ি,” তিনি উত্তর দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","সদাপ্রভু বললেন, “সেটি মাটিতে ছুঁড়ে ফেলে দাও।” মোশি সেটি মাটিতে ছুঁড়ে ফেলে দিলেন এবং সেটি একটি সাপে পরিণত হল ও তিনি সেটির কাছ থেকে পালিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","তখন সদাপ্রভু মোশিকে বললেন, “তোমার হাত বাড়িয়ে দাও ও সেটির লেজ ধরে ফেলো।” অতএব মোশি হাত বাড়িয়ে সাপটি ধরে ফেললেন এবং সেটি আবার তাঁর হাতে ধরা এক ছড়িতে পরিণত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","সদাপ্রভু বললেন, “এরকম করা হল, যেন তারা বিশ্বাস করে যে সদাপ্রভু, তাদের পূর্বপুরুষদের ঈশ্বর—অব্রাহামের ঈশ্বর, ইস্‌হাকের ঈশ্বর ও যাকোবের ঈশ্বর—তোমার কাছে আবির্ভূত হয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","পরে সদাপ্রভু বললেন, “তোমার আলখাল্লায় তোমার হাতটি ঢুকিয়ে নাও।” অতএব মোশি নিজের আলখাল্লায় তাঁর হাতটি ঢুকিয়ে নিলেন, ও তিনি যখন সেটি বের করে আনলেন, তখন তাঁর হাতের চামড়া কুষ্ঠরোগাক্রান্ত হয়ে—সেটি বরফের মতো সাদা হয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“এখন হাতটি আবার তোমার আলখাল্লায় ঢুকিয়ে নাও।” তিনি বললেন। অতএব মোশি আবার নিজের হাতটি তাঁর আলখাল্লায় ঢুকিয়ে নিলেন, আর যখন তিনি তাঁর হাতটি বের করে আনলেন, তখন সেটি ঠিক হয়ে গেল, তাঁর শরীরের অন্যান্য অঙ্গের মতোই। ");
INSERT INTO benobcv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","পরে সদাপ্রভু বললেন, “তারা যদি তোমার কথা বিশ্বাস না করে বা প্রথম চিহ্নটিতে মনোযোগ না দেয়, তবে তারা হয়তো দ্বিতীয়টি বিশ্বাস করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","কিন্তু তারা যদি এই দুটি চিহ্নই বিশ্বাস না করে বা তোমার কথা না শোনে, তবে তুমি নীলনদ থেকে খানিকটা জল নিয়ে তা শুকনো মাটিতে ঢেলে দিয়ো। যে জল তুমি নদী থেকে আনবে তা মাটিতে রক্ত হয়ে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","মোশি সদাপ্রভুকে বললেন, “হে প্রভু, আপনার এই দাসকে ক্ষমা করবেন। আমি কখনোই বাক্যবাগীশ ছিলাম না, না ছিলাম অতীতে আর না তখন, যখন আপনি আপনার এই দাসের সঙ্গে কথা বলেছিলেন। কথাবার্তায় ও জিভে আমার জড়তা আছে।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","সদাপ্রভু তাঁকে বললেন, “মানুষকে কে মুখ দিয়েছে? কে তাদের কালা বা বোবা তৈরি করেছে? কে তাদের দৃষ্টিশক্তি দিয়েছে বা তাদের অন্ধ তৈরি করেছে? সে কি আমি, এই সদাপ্রভু নই? ");
INSERT INTO benobcv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","এখন যাও; আমি তোমাকে কথা বলতে সাহায্য করব ও কী বলতে হবে তা শেখাব।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","কিন্তু মোশি বললেন, “হে প্রভু, আপনার এই দাসকে ক্ষমা করবেন। দয়া করে অন্য কাউকে পাঠান।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","তখন সদাপ্রভুর ক্রোধ মোশির বিরুদ্ধে জ্বলে উঠল ও তিনি বললেন, “তোমার দাদা, সেই লেবীয় হারোণ নেই নাকি? আমি জানি সে বেশ ভালোই কথা বলতে পারে। সে এখনই তোমার সাথে দেখা করতে আসছে এবং তোমার দেখা পেয়ে সে খুশিই হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","তুমি তার সাথে কথা বলবে এবং তার মুখে শব্দ বসিয়ে দেবে; আমি তোমাদের দুজনকেই কথা বলতে সাহায্য করব ও কী করতে হবে তা শিখিয়ে দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","সে তোমার হয়ে লোকজনের কাছে কথা বলবে, এবং সে তোমার মুখ হবে, ও তুমি তার কাছে ঈশ্বরস্বরূপ হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","কিন্তু এই ছড়িটি তোমার হাতে নাও যেন তুমি এটি দিয়ে চিহ্নকাজ করতে পারো।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","পরে মোশি তাঁর শ্বশুর যিথ্রোর কাছে ফিরে গেলেন এবং তাঁকে বললেন, “আমাকে মিশরে আমার নিজস্ব লোকজনের কাছে ফিরে গিয়ে দেখতে দিন যে তাদের মধ্যে কেউ এখনও বেঁচে আছে কি না।” যিথ্রো বললেন, “যাও, ও আমি তোমার মঙ্গলকামনা করছি।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","মিদিয়নে থাকাকালীনই মোশিকে সদাপ্রভু বললেন, “মিশরে ফিরে যাও, কারণ যারা তোমাকে হত্যা করতে চেয়েছিল তারা সবাই মারা গিয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","অতএব মোশি তাঁর স্ত্রী ও ছেলেদের নিয়ে, তাদের গাধার পিঠে চাপিয়ে মিশরে ফেরার জন্য রওনা হলেন। আর তিনি ঈশ্বরের সেই ছড়িটি নিজের হাতে তুলে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","সদাপ্রভু মোশিকে বললেন, “তুমি যখন মিশরে ফিরে যাবে, তখন দেখো আমি তোমাকে যেসব আশ্চর্য কাজ করার ক্ষমতা দিয়েছি, সেগুলি যেন তুমি ফরৌণের সামনে করে দেখাও। কিন্তু আমি তার হৃদয় এমন কঠিন করব যে সে লোকদের যেতে দেবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","পরে তুমি ফরৌণকে বোলো, ‘সদাপ্রভু একথাই বলেন: ইস্রায়েল আমার প্রথম সন্তান, ");
INSERT INTO benobcv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","আর আমি তোমাকে বলেছি, “আমার ছেলেকে যেতে দাও, যেন সে আমার আরাধনা করতে পারে।” কিন্তু তুমি তাকে যেতে দিতে অস্বীকার করলে; তাই আমি তোমার প্রথমজাত ছেলেকে হত্যা করব।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","পথিমধ্যে এক পান্থশালায়, সদাপ্রভু মোশির সাথে দেখা করলেন এবং তাঁকে প্রায় হত্যা করেই ফেলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","কিন্তু সিপ্পোরা চকমকি পাথরের একটি ছুরি নিয়ে, তাঁর ছেলের লিঙ্গাগ্রত্বক কেটে সেটি মোশির পায়ে ঠেকিয়ে দিলেন। “নিশ্চয় তুমি আমার কাছে রক্তের এক বর,” তিনি বললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","অতএব সদাপ্রভু মোশিকে নিষ্কৃতি দিলেন। (সেই সময় সিপ্পোরা সুন্নতের উল্লেখ করে বললেন, “রক্তের বর।”) ");
INSERT INTO benobcv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","সদাপ্রভু হারোণকে বললেন, “মোশির সঙ্গে দেখা করার জন্য মরুপ্রান্তরে যাও।” তাই তিনি ঈশ্বরের পর্বতে মোশির সঙ্গে দেখা করলেন ও তাঁকে চুমু দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","পরে সদাপ্রভু মোশিকে যা যা বলতে পাঠালেন, ও এছাড়াও যেসব চিহ্নকাজ তিনি তাঁকে সম্পাদন করার আদেশ দিয়েছিলেন, সেসবকিছু মোশি হারোণকে বললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","মোশি ও হারোণ ইস্রায়েলীদের সব প্রাচীনকে একত্রিত করলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","এবং সদাপ্রভু মোশিকে যা যা বলেছিলেন সেসবকিছু হারোণ তাঁদের বললেন। এছাড়াও তিনি লোকজনের সামনে সেই চিহ্নকাজগুলি সম্পাদন করলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","এবং তাঁরা বিশ্বাস করলেন। আর তাঁরা যখন শুনলেন যে সদাপ্রভু তাঁদের বিষয়ে উদ্বিগ্ন হয়েছেন ও তাঁদের দুর্দশা দেখেছেন, তখন তাঁরা মাথা নত করে আরাধনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","পরে মোশি ও হারোণ ফরৌণের কাছে গিয়ে বললেন, “ইস্রায়েলের ঈশ্বর সদাপ্রভু, একথাই বলেন: ‘আমার লোকজনকে যেতে দাও, যেন তারা মরুপ্রান্তরে গিয়ে আমার উদ্দেশে এক উৎসব পালন করতে পারে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ফরৌণ বললেন, “সদাপ্রভু কে, যে আমাকে তার বাধ্য হতে হবে ও ইস্রায়েলকে যেতে দিতে হবে? আমি সদাপ্রভুকে চিনি না আর আমি ইস্রায়েলকেও যেতে দেব না।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","তখন তাঁরা বললেন, “হিব্রুদের ঈশ্বর আমাদের দর্শন দিয়েছেন। এখন মরুপ্রান্তরে তিনদিনের পথযাত্রা করে আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশে আমাদের বলি উৎসর্গ করে আসতে দিন, তা না হলে তিনি হয়তো আমাদের মহামারি বা তরোয়াল দিয়ে আঘাত করবেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","কিন্তু মিশররাজ বললেন, “ওহে মোশি ও হারোণ, লোকদের কেন তোমরা তাদের কাজকর্ম থেকে সরিয়ে নিয়ে যাচ্ছ? তোমাদের কাজে ফিরে যাও!” ");
INSERT INTO benobcv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","পরে ফরৌণ বললেন, “দেখো, দেশের লোকজন এখন বহুসংখ্যক হয়ে গিয়েছে এবং তোমরা তাদের কাজ করা থেকে বিরত রাখছ।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","সেদিনই ফরৌণ লোকজনের দায়িত্বে থাকা ক্রীতদাস পরিচালকদের ও তত্ত্বাবধায়কদের এই আদেশ দিলেন: ");
INSERT INTO benobcv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ইট তৈরি করার জন্য তোমরা লোকদের আর খড়ের জোগান দেবে না; তারা নিজেরাই গিয়ে খড় জোগাড় করুক। ");
INSERT INTO benobcv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","কিন্তু আগে তারা যে পরিমাণ ইট তৈরি করত, এখনও তাদের ততটাই তৈরি করতে বলো; প্রদেয় নির্দিষ্ট ভাগ কমিয়ে দিয়ো না। তারা অলস; তাই তারা কান্নাকাটি করে বলছে, ‘আমাদের যেতে দাও ও আমাদের ঈশ্বরের উদ্দেশে বলি উৎসর্গ করতে দাও।’ ");
INSERT INTO benobcv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","লোকদের জন্য কাজকর্ম এত কঠিন করে দাও, যেন তারা কাজ করতেই থাকে ও মিথ্যা কথায় মনোযোগ না দেয়।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","তখন ক্রীতদাস পরিচালকেরা ও তত্ত্বাবধায়কেরা বাইরে গিয়ে লোকজনকে বলল, “ফরৌণ একথাই বলেছেন: ‘আমি আর তোমাদের খড় দেব না। ");
INSERT INTO benobcv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","যাও, যেখান থেকে পারো তোমাদের খড় নিয়ে এসো, কিন্তু তোমাদের কাজকর্ম কোনোমতেই কম করা হবে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","অতএব লোকেরা খড়ের পরিবর্তে নাড়া সংগ্রহ করার জন্য মিশরের সর্বত্র ছড়িয়ে পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ক্রীতদাস পরিচালকেরা এই বলে তাদের চাপ দিয়ে যাচ্ছিল, “তোমরা প্রতিদিনের নিরূপিত কাজকর্ম শেষ করো, ঠিক যেভাবে আগে তোমাদের কাছে খড় থাকার সময় তোমরা তা করতে।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","আর ফরৌণের ক্রীতদাস পরিচালকেরা যে ইস্রায়েলী তত্ত্বাবধায়কদের নিযুক্ত করল, তারা তাদের কাছে এই দাবি জানিয়ে তাদের মারধর করত, “গতকাল বা আজ কেন তোমরা আগের মতো তোমাদের যত ইট তৈরি করার কথা, ততখানি তৈরি করোনি?” ");
INSERT INTO benobcv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","তখন ইস্রায়েলী তত্ত্বাবধায়কেরা গিয়ে ফরৌণের কাছে নালিশ জানাল: “কেন আপনি আপনার এই দাসেদের সঙ্গে এরকম আচরণ করছেন? ");
INSERT INTO benobcv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","আপনার দাসেদের কোনও খড় দেওয়া হয়নি, অথচ আমাদের বলা হয়েছে, ‘ইট তৈরি করো!’ আপনার দাসেদের মারধর করা হয়েছে, কিন্তু আপনার নিজের প্রজারাই দোষ করেছে।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ফরৌণ বললেন, “তোমরা অলস, তোমরা এরকমই—অলস! সেজন্যই তোমরা বলে যাচ্ছ, ‘চলো যাই ও সদাপ্রভুর উদ্দেশে বলি উৎসর্গ করি।’ ");
INSERT INTO benobcv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","এখন কাজে লেগে পড়ো। তোমাদের কোনও খড় দেওয়া হবে না। তবুও তোমাদের নিরূপিত পরিমাণ ইটের পুরোটাই উৎপাদন করতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ইস্রায়েলী তত্ত্বাবধায়কদের যখন বলা হল, “প্রতিদিন তোমাদের যতগুলি করে ইট তৈরি করার কথা, তোমরা তার সংখ্যা কমাতে পারবে না,” তখন তারা বুঝতে পারল যে তারা অসুবিধায় পড়েছে। ");
INSERT INTO benobcv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","তারা যখন ফরৌণের কাছ থেকে ফিরে এল, তখন তারা দেখল যে মোশি ও হারোণ তাদের সাথে দেখা করার জন্য অপেক্ষা করছেন, ");
INSERT INTO benobcv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","এবং তারা বলল, “সদাপ্রভুই আপনাদের দিকে তাকিয়ে আপনাদের বিচার করুন! আপনারা ফরৌণের ও তাঁর কর্মকর্তাদের কাছে আমাদের আপত্তিকর করে তুলেছেন এবং আমাদের হত্যা করার জন্য তাদের হাতে এক তরোয়াল তুলে দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","মোশি সদাপ্রভুর কাছে ফিরে গিয়ে বললেন, “কেন, হে প্রভু, কেন তুমি এই লোকদের অসুবিধায় ফেললে? এজন্যই কি তুমি আমাকে পাঠিয়েছিলে? ");
INSERT INTO benobcv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","যখন থেকে আমি তোমার নাম করে ফরৌণের সাথে কথা বলতে গিয়েছি, তখন থেকেই তিনি এই লোকদের অসুবিধায় ফেলেছেন, এবং তুমি তোমার প্রজাদের আদৌ উদ্ধার করোনি।” ");
INSERT INTO benobcv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","তখন সদাপ্রভু মোশিকে বললেন, “এখন তুমি দেখবে আমি ফরৌণের প্রতি কী করব: আমার শক্তিশালী হাতের কারণে সে তাদের যেতে দেবে; আমার শক্তিশালী হাতের কারণে সে তাদের তার দেশ থেকে তাড়িয়ে দেবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","এছাড়াও ঈশ্বর মোশিকে বললেন, “আমিই সেই সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","সর্বশক্তিমান ঈশ্বররূপে আমি অব্রাহামের, ইস্‌হাকের ও যাকোবের কাছে আবির্ভূত হয়েছিলাম, কিন্তু সদাপ্রভু—আমার এই নামে পুরোপুরিভাবে আমি তাদের কাছে নিজের পরিচয় দিইনি। ");
INSERT INTO benobcv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","যে কনান দেশে তারা বিদেশিরূপে বসবাস করছিল, সেটি তাদের দেওয়ার জন্য আমি তাদের সাথে আমার নিয়ম প্রতিষ্ঠিতও করেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","এছাড়াও, আমি সেই ইস্রায়েলীদের কান্না শুনেছিলাম, যাদের মিশরীয়রা ক্রীতদাস করে রেখেছে, এবং আমি আমার নিয়ম স্মরণ করলাম। ");
INSERT INTO benobcv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“সুতরাং, ইস্রায়েলীদের বলো: ‘আমি সদাপ্রভু, এবং মিশরীয়দের জোয়ালের তলা থেকে আমি তোমাদের বের করে আনব। তাদের ক্রীতদাস হয়ে থাকার হাত থেকে আমি তোমাদের স্বাধীন করব, এবং এক প্রসারিত হাত ও মহৎ দণ্ডাদেশ সহ আমি তোমাদের মুক্ত করব। ");
INSERT INTO benobcv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","আমার নিজস্ব প্রজারূপে আমি তোমাদের গ্রহণ করব, এবং আমি তোমাদের ঈশ্বর হব। তখন তোমরা জানবে যে আমিই তোমাদের সেই ঈশ্বর সদাপ্রভু, যিনি মিশরীয়দের জোয়ালের তলা থেকে তোমাদের বের করে এনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","আর উদ্যত হাত দিয়ে আমি তোমাদের সেই দেশে নিয়ে আসব, যেটি দেওয়ার প্রতিজ্ঞা আমি অব্রাহামের, ইস্‌হাকের ও যাকোবের কাছে করেছিলাম। এক অধিকাররূপে আমি সেটি তোমাদের দেব। আমিই সদাপ্রভু।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","মোশি ইস্রায়েলীদের এই খবর দিলেন, কিন্তু তাদের আত্মবিশ্বাসহীনতা ও কঠোর পরিশ্রমের কারণে তারা তাঁর কথা শোনেনি। ");
INSERT INTO benobcv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","তখন সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“যাও, মিশররাজ ফরৌণকে তার দেশ ছেড়ে ইস্রায়েলীদের যেতে দিতে বলো।” ");
INSERT INTO benobcv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","কিন্তু মোশি সদাপ্রভুকে বললেন, “আমি যেহেতু কম্পমান ঠোঁটে কথা বলি তাই ইস্রায়েলীরাই যখন আমার কথা শুনছে না, ফরৌণ তবে কেন আমার কথা শুনবেন?” ");
INSERT INTO benobcv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ইস্রায়েলীদের ও মিশররাজ ফরৌণের বিষয়ে সদাপ্রভু মোশি ও হারোণের সাথে কথা বললেন, এবং ইস্রায়েলীদের মিশর থেকে বের করে আনার আদেশ তিনি তাঁদের দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","তাঁদের কুলের নেতা এঁরাই: ইস্রায়েলের প্রথমজাত সন্তান রূবেণের ছেলেরা: হনোক, পল্লু, হিষ্রোণ ও কর্মি। এরাই হলেন রূবেণের গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","শিমিয়োনের ছেলেরা: যিমূয়েল, যামীন, ওহদ, যাখীন, সোহর, ও এক কনানীয় মহিলার ছেলে শৌল। এঁরাই হলেন শিমিয়োনের গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","তাঁদের নথি অনুসারে এই হল লেবির ছেলেদের নাম: গের্শোন, কহাৎ, ও মরারি। (লেবি 137 বছর বেঁচেছিলেন।) ");
INSERT INTO benobcv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","গোষ্ঠী অনুসারে, গের্শোনের ছেলেরা: লিব্‌নি ও শিমিয়ি। ");
INSERT INTO benobcv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","কহাতের ছেলেরা: অম্রাম, যিষ্‌হর, হিব্রোণ ও উষীয়েল। (কহাৎ 133 বছর বেঁচেছিলেন।) ");
INSERT INTO benobcv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","মরারির ছেলেরা: মহলি ও মূশি। তাঁদের নথি অনুসারে এরাই লেবির বিভিন্ন গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","অম্রাম তাঁর পিসিমা সেই যোকেবদকে বিয়ে করলেন, যিনি অম্রামের জন্য মোশি ও হারোণের জন্ম দিলেন। (অম্রাম 137 বছর বেঁচেছিলেন।) ");
INSERT INTO benobcv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","যিষ্‌হরের ছেলেরা: কোরহ, নেফগ ও সিখ্রি। ");
INSERT INTO benobcv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","উষীয়েলের ছেলেরা: মীশায়েল, ইল্‌সাফন ও সিথ্রি। ");
INSERT INTO benobcv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","হারোণ অম্মীনাদবের মেয়ে ও নহশোনের বোন ইলীশেবাকে বিয়ে করলেন, এবং তিনি হারোণের জন্য নাদব ও অবীহূ, ইলীয়াসর ও ঈথামরের জন্ম দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","কোরহের ছেলেরা হলেন: অসীর, ইল্‌কানা ও অবীয়াসফ। এঁরাই হলেন কোরহের বিভিন্ন গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","হারোণের ছেলে ইলীয়াসর পুটিয়েলের মেয়েদের মধ্যে একজনকে বিয়ে করলেন, এবং তিনি তাঁর জন্য পীনহসের জন্ম দিলেন। এঁরাই হলেন গোষ্ঠী ধরে ধরে লেবীয় কুলের বিভিন্ন নেতা। ");
INSERT INTO benobcv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","এই হারোণ ও মোশিকেই সদাপ্রভু বললেন, “বিভাগ ধরে ধরে তোমরা ইস্রায়েলীদের মিশর থেকে বের করে আনো।” ");
INSERT INTO benobcv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","তাঁরাই—এই মোশি ও হারোণই ইস্রায়েলীদের মিশর থেকে বের করে আনার বিষয়ে মিশররাজ ফরৌণের সাথে কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","এদিকে সদাপ্রভু যখন মিশরে মোশির সাথে কথা বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","তখন তিনি মোশিকে বললেন, “আমি সদাপ্রভু। আমি তোমাকে যা যা বলছি সেসব কথা মিশররাজ ফরৌণকে গিয়ে বলো।” ");
INSERT INTO benobcv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","কিন্তু মোশি সদাপ্রভুকে বললেন, “আমি যেহেতু কম্পমান ঠোঁটে কথা বলি, তাই ফরৌণ আমার কথা শুনবেন কেন?” ");
INSERT INTO benobcv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","তখন সদাপ্রভু মোশিকে বললেন, “দেখো, আমি তোমাকে ফরৌণের কাছে ঈশ্বরের সমতুল্য করে দিয়েছি, এবং তোমার দাদা হারোণ তোমার ভাববাদী হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","আমি তোমাকে যে আদেশ দিচ্ছি সেসব কথা তোমাকে বলতে হবে, এবং তোমার দাদা হারোণ ফরৌণকে বলুক যেন সে ইস্রায়েলীদের তার দেশ ছেড়ে যেতে দেয়। ");
INSERT INTO benobcv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","কিন্তু আমি ফরৌণের হৃদয় কঠিন করব, ও যদিও আমি মিশরে আমার চিহ্নের ও অলৌকিক কাজের সংখ্যা বৃদ্ধি করব, ");
INSERT INTO benobcv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","তবুও সে তোমাদের কথা শুনবে না। পরে আমি মিশরের উপর আমার হাত বাড়াব এবং দণ্ডের ক্ষমতাশালী কাজের মাধ্যমে আমি আমার সৈন্যসামন্তকে, আমার প্রজা ইস্রায়েলীদের বের করে আনব। ");
INSERT INTO benobcv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","আর আমি যখন মিশরের বিরুদ্ধে আমার হাত প্রসারিত করব ও সেখান থেকে ইস্রায়েলীদের বের করে আনব তখনই মিশরীয়রা জানবে যে আমিই সদাপ্রভু।” ");
INSERT INTO benobcv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","মোশি ও হারোণকে সদাপ্রভু যে আদেশ দিলেন তাঁরা ঠিক তাই করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","তাঁরা যখন ফরৌণের সঙ্গে কথা বললেন তখন মোশির বয়স আশি ও হারোণের তিরাশি বছর। ");
INSERT INTO benobcv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ফরৌণ যখন তোমাদের বলবে, ‘একটি অলৌকিক কাজ করে দেখাও,’ তখন হারোণকে বোলো, ‘তোমার ছড়িটি নাও ও ফরৌণের সামনে সেটি নিক্ষেপ করো,’ আর সেটি একটি সাপে পরিণত হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","অতএব মোশি ও হারোণ ফরৌণের কাছে গেলেন এবং সদাপ্রভু যেমন আদেশ দিয়েছিলেন ঠিক সেরকমই করলেন। হারোণ ফরৌণের ও তাঁর কর্মকর্তাদের সামনে তাঁর ছড়িটি নিক্ষেপ করলেন ও সেটি একটি সাপে পরিণত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ফরৌণ তখন পণ্ডিতদের ও গুনিনদের ডেকে পাঠালেন, এবং সেই মিশরীয় জাদুকররাও তাদের রহস্যময় শিল্পকলার মাধ্যমে একই কাজ করল: ");
INSERT INTO benobcv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","প্রত্যেকে নিজের নিজের ছড়ি নিক্ষেপ করল এবং তা সাপে পরিণত হল। কিন্তু হারোণের ছড়িটি তাদের ছড়িগুলি গিলে ফেলল। ");
INSERT INTO benobcv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","তবুও ফরৌণের হৃদয় কঠিন হল ও তিনি তাদের কথা শুনতে চাননি, যেমন সদাপ্রভু বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","তখন সদাপ্রভু মোশিকে বললেন, “ফরৌণের হৃদয় অনমনীয়; সে লোকদের যেতে দিতে চায় না। ");
INSERT INTO benobcv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","সকালে ফরৌণ যখন নদীর কাছে যাবে তখন তুমিও তার কাছে যেয়ো। নীলনদের তীরে তার সম্মুখীন হোয়ো, এবং তোমার সেই ছড়িটি হাতে রেখো যেটি একটি সাপে পরিণত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","পরে তাকে বোলো, ‘হিব্রুদের ঈশ্বর সদাপ্রভু, আপনার কাছে আমাকে একথা বলতে পাঠিয়েছেন: আমার প্রজাদের যেতে দাও, যেন তারা মরুপ্রান্তরে আমার আরাধনা করতে পারে। কিন্তু এখনও পর্যন্ত তুমি সেকথা শোনোনি। ");
INSERT INTO benobcv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","সদাপ্রভু একথাই বলেন: এর দ্বারাই তোমরা জানতে পারবে যে আমিই সদাপ্রভু: যে ছড়িটি আমার হাতে ধরা আছে সেটি দিয়ে আমি নীলনদের জলে আঘাত করব, আর তা রক্তে পরিণত হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","নীলনদে মাছ মারা যাবে, এবং তার ফলে নদীতে দুর্গন্ধ ছড়াবে; মিশরীয়রা এর জলপান করতে পারবে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","সদাপ্রভু মোশিকে বললেন, “হারোণকে বোলো, ‘তোমার ছড়িটি নাও এবং মিশরের সব স্রোতোজলের উপর—নদীর ও খালের উপর, পুকুরের ও সব জলাধারের উপর—তোমার হাত বাড়াও ও সেসব রক্তে পরিণত হবে।’ মিশরে সর্বত্র রক্তই থাকবে, এমনকি কাঠের ও পাথরের পাত্রেও থাকবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","মোশি ও হারোণ ঠিক তাই করলেন যা সদাপ্রভু তাঁদের করার আদেশ দিয়েছিলেন। ফরৌণ ও তাঁর কর্মকর্তাদের সামনে তিনি তাঁর ছড়িটি বাড়িয়ে দিলেন ও নীলনদের জলে আঘাত করলেন ও সব জল রক্তে পরিণত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","নীলনদে মাছ মারা গেল, এবং নদীতে এত দুর্গন্ধ ছড়াল যে মিশরীয়রা সেটির জলপান করতে পারল না। মিশরে সর্বত্র রক্ত ছড়িয়ে পড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","কিন্তু মিশরের জাদুকররাও তাদের রহস্যময় শিল্পকলার দ্বারা একই কাজ করল, এবং ফরৌণের হৃদয় কঠিন হল; তিনি মোশি ও হারোণের কথা শোনেননি, ঠিক যেমনটি সদাপ্রভু বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","পরিবর্তে, তিনি তাঁর প্রাসাদে ফিরে গেলেন, এবং এমনকি এতে কিছুই মনে করলেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","আর মিশরীয়রা সবাই পানীয় জল পাওয়ার জন্য নীলনদের পাশে কুয়ো খুঁড়েছিল, কারণ তারা নদীর জলপান করতে পারেনি। ");
INSERT INTO benobcv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","সদাপ্রভু নীলনদের উপর আঘাত হানার পর সাত দিন কেটে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","তখন সদাপ্রভু মোশিকে বললেন, “ফরৌণের কাছে যাও ও তাকে বলো, ‘সদাপ্রভু একথাই বলেন: আমার প্রজাদের যেতে দাও, যেন তারা আমার আরাধনা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","যদি তুমি তাদের যেতে দিতে অসম্মত হও, তবে আমি তোমার সমগ্র দেশে ব্যাং দ্বারা এক আঘাত হানব। ");
INSERT INTO benobcv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","নীলনদ ব্যাং-এ পরিপূর্ণ হয়ে যাবে। সেগুলি তোমার প্রাসাদে ও শয়নকক্ষে, এবং তোমার বিছানাতে, এবং তোমার কর্মকর্তাদের বাড়িতে ও তোমার প্রজাদের উপর, এবং তোমাদের উনুনে ও কোঠাতেও উঠে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ব্যাংগুলি তোমার গায়ে ও তোমার প্রজাদের এবং তোমার সব কর্মকর্তার গায়ে উঠে আসবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","পরে সদাপ্রভু মোশিকে বললেন, “হারোণকে বলো, ‘ছড়িসহ তোমার হাত সব জলস্রোতের ও খালের এবং পুকুরের উপর বাড়িয়ে দাও, এবং মিশর দেশের উপর ব্যাঙদের নিয়ে এসো।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","অতএব হারোণ মিশরের স্রোতোজলের উপর তাঁর হাত বাড়িয়ে দিলেন, এবং ব্যাংগুলি উঠে এসে দেশটি ঢেকে দিল। ");
INSERT INTO benobcv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","কিন্তু জাদুকররা তাদের রহস্যময় শিল্পকলার মাধ্যমে একই কাজ করল; তারাও মিশর দেশের উপর ব্যাঙদের নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ফরৌণ, মোশি ও হারোণকে ডেকে পাঠিয়ে বললেন, “আমার ও আমার প্রজাদের কাছ থেকে ব্যাংগুলি দূরে সরিয়ে নেওয়ার জন্য সদাপ্রভুর কাছে প্রার্থনা করো, এবং সদাপ্রভুর উদ্দেশে বলি উৎসর্গ করার জন্য আমি তোমাদের লোকজনকে যেতে দেব।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","মোশি ফরৌণকে বললেন, “শুধু নীলনদে যেসব ব্যাং আছে, সেগুলি ছাড়া আপনি ও আপনাদের ঘরবাড়ি যেন ব্যাং-এর হাত থেকে নিষ্কৃতি পান সেজন্য আমি কখন আপনার জন্য ও আপনার কর্মকর্তাদের এবং আপনার প্রজাদের জন্য প্রার্থনা করব, সেই সময়টি ঠিক করার ভার আমি আপনার হাতেই তুলে দিচ্ছি।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“আগামীকাল,” ফরৌণ বললেন। মোশি উত্তর দিলেন, “আপনার কথামতোই তা হোক, যেন আপনি জানতে পারেন যে আমাদের ঈশ্বর সদাপ্রভুর মতো আর কেউ নেই। ");
INSERT INTO benobcv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ব্যাংগুলি আপনার কাছ থেকে ও আপনার বাড়ি থেকে এবং আপনার কর্মকর্তাদের ও আপনার প্রজাদের বাড়ি থেকে চলে যাবে; সেগুলি শুধু নীলনদেই থাকবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","মোশি ও হারোণ ফরৌণের কাছ থেকে চলে যাওয়ার পর, মোশি সেই ব্যাংগুলির সম্বন্ধে সদাপ্রভুর কাছে প্রার্থনা করলেন, যেগুলি তিনি ফরৌণের উপর নিয়ে এসেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","আর মোশি যা চেয়েছিলেন সদাপ্রভু তাই করলেন। বাড়িতে, প্রাঙ্গণে ও ক্ষেতজমিতে ব্যাংগুলি মারা গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","সেগুলি গাদায় গাদায় স্তূপাকার করা হল, এবং সেগুলির কারণে দেশে দুর্গন্ধ ছড়াল। ");
INSERT INTO benobcv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","কিন্তু ফরৌণ যখন দেখলেন যে মুক্তি পাওয়া গিয়েছে, তখন তিনি তাঁর হৃদয় কঠিন করলেন এবং মোশি ও হারোণের কথা শুনতে চাইলেন না, ঠিক যেমনটি সদাপ্রভু বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","তখন সদাপ্রভু মোশিকে বললেন, “হারোণকে বলো, ‘তোমার ছড়িটি বাড়িয়ে দাও এবং মাঠের ধুলোতে আঘাত করো,’ এবং মিশর দেশের সর্বত্র ধুলোবালি ডাঁশ-মশায় পরিণত হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","তাঁরা তাই করলেন, এবং হারোণ যখন ছড়িসহ তাঁর হাতটি বাড়িয়ে দিয়ে মাঠের ধুলোতে আঘাত করলেন, তখন মানুষজনের ও পশুদের গায়ে ডাঁশ-মশা উঠে এল। মিশর দেশের সর্বত্র সব ধুলোবালি ডাঁশ-মশায় পরিণত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","কিন্তু জাদুকররা যখন তাদের রহস্যময় শিল্পকলার মাধ্যমে ডাঁশ-মশা উৎপন্ন করতে চাইল, তারা তা করতে পারল না। যেহেতু সর্বত্র মানুষের ও পশুদের উপর ডাঁশ-মশা ছেয়ে গেল, ");
INSERT INTO benobcv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","তাই জাদুকররা ফরৌণকে বলল, “এ হল ঈশ্বরের আঙুল।” কিন্তু ফরৌণের হৃদয় কঠিন হল এবং তিনি শুনতে চাইলেন না, ঠিক যেমনটি সদাপ্রভু বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","তখন সদাপ্রভু মোশিকে বললেন, “সকালে তাড়াতাড়ি উঠে যেয়ো এবং ফরৌণ যখন নদীর কাছে যাবে তখন তার সম্মুখীন হোয়ো ও তাকে বোলো, ‘সদাপ্রভু একথাই বলেন: আমার প্রজাদের যেতে দাও, যেন তারা আমার আরাধনা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","যদি তুমি আমার প্রজাদের যেতে না দাও, তবে আমি তোমার উপর ও তোমার কর্মকর্তাদের, তোমার প্রজাদের উপর এবং তোমার বাড়ির মধ্যে মাছির ঝাঁক পাঠাব। মিশরীয়দের বাড়িগুলি মাছিতে পরিপূর্ণ হয়ে যাবে; এমনকি মাঠঘাটও সেগুলি দ্বারা ঢাকা পড়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘কিন্তু সেদিন সেই গোশন প্রদেশের প্রতি আমি অন্যরকম আচরণ করব, যেখানে আমার প্রজারা বসবাস করে; সেখানে মাছির কোনও ঝাঁক থাকবে না, যেন তুমি জানতে পারো যে আমি, সদাপ্রভু এই দেশেই আছি। ");
INSERT INTO benobcv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","আমি আমার প্রজাদের ও তোমার প্রজাদের মধ্যে এক পার্থক্য গড়ে তুলব। আগামীকাল এই চিহ্নটি ফুটে উঠবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","আর সদাপ্রভু এরকমই করলেন। মাছির ঘন ঝাঁক ফরৌণের প্রাসাদে, ও তাঁর কর্মকর্তাদের বাড়িগুলিতে আছড়ে পড়ল; মিশরের সর্বত্র দেশ মাছি দ্বারা ছারখার হয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","তখন ফরৌণ মোশি ও হারোণকে ডেকে পাঠালেন এবং বললেন, “যাও, দেশের মধ্যেই তোমাদের ঈশ্বরের উদ্দেশে বলি উৎসর্গ করো।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","কিন্তু মোশি বললেন, “এরকম করা ঠিক হবে না। আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশে আমরা যে বলি উৎসর্গ করি তা মিশরীয়দের কাছে ঘৃণ্য হবে। আর আমরা যদি সেই বলি উৎসর্গ করি যা তাদের দৃষ্টিতে ঘৃণ্য, তবে তারা কি আমাদের উপর পাথর ছুঁড়বে না? ");
INSERT INTO benobcv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","আমাদের অবশ্যই আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশে বলি উৎসর্গ করার জন্য তিনদিনের পথ পাড়ি দিয়ে মরুপ্রান্তরে যেতে হবে, যেমনটি তিনি আমাদের আদেশ দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ফরৌণ বললেন, “মরুপ্রান্তরে তোমাদের ঈশ্বর সদাপ্রভুর উদ্দেশে বলি উৎসর্গ করার জন্য আমি তোমাদের যেতে দেব, কিন্তু তোমরা খুব বেশি দূরে যাবে না। এখন আমার জন্য প্রার্থনা করো।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","মোশি উত্তর দিলেন, “আপনার কাছ থেকে চলে যাওয়ার পরই আমি সদাপ্রভুর কাছে প্রার্থনা করব, এবং আগামীকাল মাছিগুলি ফরৌণকে ও তাঁর কর্মকর্তাদের এবং তাঁর প্রজাদের ছেড়ে চলে যাবে। শুধু ফরৌণ যেন নিশ্চিতরূপে সদাপ্রভুর উদ্দেশে লোকদের বলি দিতে যেতে না দিয়ে প্রতারণামূলক আচরণ না করেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","পরে মোশি ফরৌণের কাছ থেকে চলে গেলেন এবং সদাপ্রভুর কাছে প্রার্থনা করলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","এবং মোশি যেমনটি চেয়েছিলেন সদাপ্রভু তাই করলেন। মাছির ঝাঁক ফরৌণকে ও তাঁর কর্মকর্তাদের এবং তাঁর প্রজাদের ছেড়ে গেল; একটিও মাছি অবশিষ্ট রইল না। ");
INSERT INTO benobcv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","কিন্তু এবারও ফরৌণ তাঁর হৃদয় কঠিন করলেন এবং তিনি লোকদের যেতে দিলেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","তখন সদাপ্রভু মোশিকে বললেন, “ফরৌণের কাছে যাও এবং তাকে বলো, ‘হিব্রুদের ঈশ্বর সদাপ্রভু একথাই বলেন: “আমার প্রজাদের যেতে দাও, যেন তারা আমার আরাধনা করতে পারে।” ");
INSERT INTO benobcv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","যদি তুমি তাদের যেতে দিতে অসম্মত হও এবং ক্রমাগত তাদের আটকে রাখো, ");
INSERT INTO benobcv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","তবে সদাপ্রভুর হাত মাঠেঘাটে থাকা তোমাদের গৃহপালিত পশুপালের উপর—তোমাদের ঘোড়া, গাধা ও উটের এবং গবাদি পশুপালের, মেষ ও ছাগলদের উপর ভয়ংকর এক আঘাত নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","কিন্তু সদাপ্রভু ইস্রায়েলীদের গৃহপালিত পশুপালের এবং মিশরীয়দের গৃহপালিত পশুপালের মধ্যে এক পার্থক্য গড়ে তুলবেন, যেন ইস্রায়েলীদের অধিকারভুক্ত কোনও পশু মারা না যায়।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","সদাপ্রভু এক সময় নির্দিষ্ট করলেন ও বললেন, “আগামীকাল সদাপ্রভু দেশে এরকম করবেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","আর পরদিন সদাপ্রভু তা করলেন: মিশরীয়দের সব গৃহপালিত পশু মারা গেল, কিন্তু ইস্রায়েলীদের অধিকারভুক্ত একটি পশুও মারা গেল না। ");
INSERT INTO benobcv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ফরৌণ তদন্ত করলেন এবং জানতে পারলেন যে ইস্রায়েলীদের একটি পশুও মারা যায়নি। তবুও তাঁর হৃদয় অনমনীয়ই থেকে গেল এবং তিনি লোকদের যেতে দিলেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","পরে সদাপ্রভু মোশি ও হারোণকে বললেন, “একটি উনুন থেকে মুঠো ভর্তি করে ছাইভস্ম তুলে নাও এবং ফরৌণের সামনেই মোশি তা হাওয়ায় ছড়িয়ে দিক। ");
INSERT INTO benobcv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","সমগ্র মিশর দেশে তা মিহি ধুলোয় পরিণত হবে, এবং দেশের সর্বত্র মানুষজনের ও পশুপালের গায়ে পুঁজ-ভরা ফোঁড়া ফুটে উঠবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","অতএব তাঁরা একটি উনুন থেকে ছাইভস্ম তুলে নিয়ে ফরৌণের সামনে গিয়ে দাঁড়ালেন। মোশি হাওয়ায় তা ছড়িয়ে দিলেন, এবং মানুষজনের ও পশুপালের গায়ে পুঁজ-ভরা ফোঁড়া ফুটে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","জাদুকরদের ও সব মিশরীয়দের গায়ে যে ফোঁড়াগুলি ফুটে উঠল, সেগুলির কারণে জাদুকররা মোশির সামনে দাঁড়াতে পারল না। ");
INSERT INTO benobcv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","কিন্তু সদাপ্রভু ফরৌণের হৃদয় কঠিন করে দিলেন এবং তিনি মোশি ও হারোণের কথা শুনতে চাইলেন না, ঠিক যেমনটি সদাপ্রভু মোশিকে বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","পরে সদাপ্রভু মোশিকে বললেন, “ভোরবেলায় ঘুম থেকে উঠে, ফরৌণের সম্মুখীন হয়ে তাকে বোলো, ‘হিব্রুদের ঈশ্বর সদাপ্রভু একথাই বলেন: আমার প্রজাদের যেতে দাও, যেন তারা আমার আরাধনা করতে পারে, ");
INSERT INTO benobcv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","তা না হলে এবার আমি তোমার বিরুদ্ধে ও তোমার কর্মকর্তাদের ও তোমার প্রজাদের বিরুদ্ধে আমার আঘাতগুলির পূর্ণ বল পাঠাব, যেন তুমি জানতে পারো যে সারা পৃথিবীতে আমার মতো আর কেউ নেই। ");
INSERT INTO benobcv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","কারণ এখনই আমি আমার হাত বাড়িয়ে তোমাকে ও তোমার প্রজাদের এমন এক আঘাত দ্বারা আহত করতে পারি যা তোমাদের এই পৃথিবীর বুক থেকে মুছে ফেলতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","কিন্তু ঠিক এই উদ্দেশ্যেই আমি তোমাকে উন্নত করেছি, যেন আমি তোমাকে আমার ক্ষমতা দেখাতে পারি ও সমগ্র পৃথিবীতে আমার নাম প্রচারিত হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","তুমি এখনও আমার প্রজাদের বিরুদ্ধে নিজেকে দাঁড় করিয়ে রেখেছ এবং তাদের যেতে দিচ্ছ না। ");
INSERT INTO benobcv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","তাই, আগামীকাল এইসময় আমি এমন ভারী শিলাবৃষ্টি পাঠাব যা মিশরের প্রতিষ্ঠা-দিবস থেকে শুরু করে আজ পর্যন্ত কখনও মিশরের উপর পড়েনি। ");
INSERT INTO benobcv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","তুমি এখন এক আদেশ জারি করো, যেন মাঠেঘাটে তোমার যত গৃহপালিত পশুপাল ও যা যা আছে, সেসব নিরাপদ আশ্রয়ে নিয়ে আসা হয়, কারণ যেসব মানুষ ও পশুকে ভিতরে আনা হয়নি ও যারা এখনও মাঠেঘাটেই আছে, তাদের প্রত্যেকের উপর শিলাবৃষ্টি নেমে আসবে, ও তারা মারা পড়বে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ফরৌণের যেসব কর্মকর্তা সদাপ্রভুর বাক্যে ভয় পেয়েছিলেন, তাঁরা তাড়াতাড়ি করে তাঁদের ক্রীতদাস-দাসীদের ও তাঁদের গৃহপালিত পশুপালকে ভিতরে নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","কিন্তু যারা সদাপ্রভুর বাক্য উপেক্ষা করল, তারা তাদের ক্রীতদাস-দাসীদের ও গৃহপালিত পশুপাল মাঠেঘাটেই ছেড়ে দিল। ");
INSERT INTO benobcv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","পরে সদাপ্রভু মোশিকে বললেন, “তোমার হাত আকাশের দিকে প্রসারিত করো যেন মিশরে সর্বত্র শিলাবৃষ্টি নেমে আসে—মানুষজনের ও পশুপালের এবং মিশরের মাঠেঘাটে যা যা উৎপন্ন হচ্ছে, সবকিছুর উপরে নেমে আসে।” ");
INSERT INTO benobcv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","মোশি যখন তাঁর ছড়িটি আকাশের দিকে প্রসারিত করলেন, তখন সদাপ্রভু বজ্রবিদ্যুৎ ও শিলাবৃষ্টি পাঠিয়ে দিলেন, এবং বজ্রবিদ্যুতের চমক মাটি স্পর্শ করল। অতএব সদাপ্রভু মিশর দেশের উপর শিলাবৃষ্টি বর্ষণ করলেন; ");
INSERT INTO benobcv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","শিলাবৃষ্টিপাত হয়েছিল এবং এদিক-ওদিক বজ্রবিদ্যুৎ চমকাল। যখন থেকে মিশর এক দেশে পরিণত হয়েছিল, তখন থেকে শুরু করে আজ পর্যন্ত মিশর দেশে এরকম শিলাবৃষ্টি আর কখনও হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","মিশরে সর্বত্র শিলাবৃষ্টি মাঠের সবকিছুকে—মানুষজন ও পশুপাল, সবাইকেই আঘাত করল; মাঠেঘাটে যা যা উৎপন্ন হয় সেসবকিছু তা দুমড়ে-মুচড়ে দিল ও প্রত্যেকটি গাছ নেড়া করে ফেলল। ");
INSERT INTO benobcv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","একমাত্র যেখানে শিলাবৃষ্টি পড়েনি তা হল সেই গোশন প্রদেশ, যেখানে ইস্রায়েলীরা বসবাস করত। ");
INSERT INTO benobcv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","তখন ফরৌণ মোশি ও হারোণকে ডেকে পাঠালেন। “এবার আমি পাপ করেছি,” তিনি তাঁদের বললেন। “সদাপ্রভু ন্যায়পরায়ণ, এবং আমি ও আমার প্রজারা অন্যায় করেছি। ");
INSERT INTO benobcv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","সদাপ্রভুর কাছে প্রার্থনা করো, কারণ আমরা যথেষ্ট বজ্রবিদ্যুৎ ও শিলাবৃষ্টি পেয়েছি। আমি তোমাদের যেতে দেব; তোমাদের আর এখানে থাকতে হবে না।” ");
INSERT INTO benobcv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","মোশি উত্তর দিলেন, “আমি যখন নগরটি ছেড়ে যাব, তখন আমি আমার হাত দুটি প্রার্থনায় সদাপ্রভুর দিকে প্রসারিত করব। বজ্রপাত থেমে যাবে এবং শিলাবৃষ্টি আর হবে না, যেন আপনি জানতে পারেন যে এই পৃথিবী সদাপ্রভুরই। ");
INSERT INTO benobcv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","কিন্তু আমি জানি যে আপনি ও আপনার কর্মকর্তারা এখনও সদাপ্রভু ঈশ্বরকে ভয় পাচ্ছেন না।” ");
INSERT INTO benobcv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(শণগাছ ও যব ধ্বংস হল, যেহেতু যবের শিষ ফুটেছিল ও শণগাছে ফুল ধরেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","গম ও বাজরা অবশ্য ধ্বংস হয়নি, কারণ সেগুলি পরে পাকে।) ");
INSERT INTO benobcv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","পরে মোশি ফরৌণকে ছেড়ে নগর থেকে বাইরে চলে গেলেন। তিনি সদাপ্রভুর দিকে তাঁর হাত দুটি প্রসারিত করলেন; বজ্রবিদ্যুৎ ও শিলাবৃষ্টি পড়া বন্ধ হয়ে গেল, এবং বৃষ্টিও আর জমিতে নেমে এল না। ");
INSERT INTO benobcv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ফরৌণ যখন দেখলেন যে বৃষ্টি ও শিলাবৃষ্টি ও বজ্রবিদ্যুৎ পড়া বন্ধ হয়েছে, তখন আবার তিনি পাপ করলেন: তিনি ও তাঁর কর্মকর্তারা তাঁদের হৃদয় কঠিন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","অতএব ফরৌণের হৃদয় কঠিন হল এবং তিনি ইস্রায়েলীদের যেতে দিলেন না, ঠিক যেমনটি সদাপ্রভু মোশির মাধ্যমে বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","পরে সদাপ্রভু মোশিকে বললেন, “ফরৌণের কাছে যাও, কারণ আমি তার হৃদয় ও তার কর্মচারীদের হৃদয় কঠিন করে দিয়েছি যেন তাদের মাঝখানে আমি আমার এই চিহ্নকাজগুলি সম্পন্ন করতে পারি ");
INSERT INTO benobcv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ও যেন তুমি তোমার সন্তানদের ও নাতি-নাতনিদের বলতে পারো কীভাবে আমি মিশরীয়দের সঙ্গে রূঢ়ভাবে আচরণ করেছি এবং কীভাবে আমি তাদের মাঝখানে আমার চিহ্নকাজগুলি সম্পন্ন করেছি, এবং তোমরা যেন জানতে পারো যে আমিই সদাপ্রভু।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","অতএব মোশি ও হারোণ ফরৌণের কাছে গেলেন এবং তাঁকে বললেন, “হিব্রুদের ঈশ্বর সদাপ্রভু একথাই বলেন: ‘আর কত কাল তুমি আমার সামনে নিজেকে নত করতে অসম্মত হবে? আমার প্রজাদের যেতে দাও, যেন তারা আমার আরাধনা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","যদি তুমি তাদের যেতে না দাও, তবে আগামীকাল আমি তোমার দেশে পঙ্গপাল নিয়ে আসব। ");
INSERT INTO benobcv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","সেগুলি মাঠঘাট এমনভাবে ঢেকে ফেলবে যেন তা দেখা না যায়। শিলাবৃষ্টির পর তোমাদের অল্পসল্প যা কিছু অবশিষ্ট আছে, সেগুলি ও তার পাশাপাশি তোমাদের মাঠেঘাটে যত গাছপালা বেড়ে উঠছে, সেসব সেগুলি গ্রাস করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","সেগুলি তোমার বাড়িঘর ও তোমার কর্মকর্তাদের এবং সমস্ত মিশরীয়ের বাড়িঘর ভরিয়ে তুলবে—তা এমন এক ঘটনা হবে যা তোমার বাবা-মায়েরা বা তোমার পূর্বপুরুষরাও এদেশে তাদের বসতি স্থাপন করা থেকে শুরু করে আজ পর্যন্ত কখনও দেখেনি।’ ” পরে মোশি ঘুরে দাঁড়ালেন ও ফরৌণকে ছেড়ে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ফরৌণের কর্মকর্তারা তাঁকে বললেন, “আর কত দিন এই লোকটি আমাদের পক্ষে এক ফাঁদ হয়ে থাকবে? লোকদের যেতে দিন, যেন তারা তাদের ঈশ্বর সদাপ্রভুর আরাধনা করতে পারে। আপনি কি এখনও বুঝতে পারছেন না যে মিশর ছারখার হয়ে গিয়েছে?” ");
INSERT INTO benobcv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","তখন মোশি ও হারোণকে ফরৌণের কাছে ফিরিয়ে আনা হল। “যাও, তোমাদের ঈশ্বর সদাপ্রভুর আরাধনা করো,” তিনি বললেন। “কিন্তু আমায় বলো, কে কে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","মোশি উত্তর দিলেন, “আমরা আমাদের শিশু ও বৃদ্ধদের, আমাদের ছেলেমেয়েদের, এবং আমাদের মেষপাল ও পশুপাল সঙ্গে নিয়ে যাব, কারণ সদাপ্রভুর উদ্দেশে আমাদের এক উৎসব পালন করতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ফরৌণ বললেন, “সদাপ্রভু তোমাদের সহবর্তী হোন—আমি যদি মহিলা ও শিশুদের সঙ্গে নিয়ে তোমাদের যেতে দিই! এতে তোমাদের অশুভ উদ্দেশ্য প্রকাশিত হচ্ছে। ");
INSERT INTO benobcv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","না! শুধুমাত্র পুরুষরাই যাক এবং সদাপ্রভুর আরাধনা করুক, যেহেতু তোমরা তো তাই চেয়েছিলে।” পরে মোশি ও হারোণকে ফরৌণের কাছ থেকে তাড়িয়ে দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","আর সদাপ্রভু মোশিকে বললেন, “মিশরের উপর তোমার হাত প্রসারিত করো যেন পঙ্গপালেরা দেশের উপর ঝাঁকে ঝাঁকে নেমে আসে ও শিলাবৃষ্টির পর যা কিছু অবশিষ্ট থেকে গিয়েছে, মাঠঘাটে বেড়ে ওঠা সেসবকিছু সেগুলি গ্রাস করে নেয়।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","অতএব মোশি মিশর দেশের উপর তাঁর ছড়িটি বাড়িয়ে দিলেন, আর সদাপ্রভু সারাদিন ও সারারাত দেশে পূর্বীয় বাতাস বইতে দিলেন। সকাল হতে না হতেই সেই বাতাস ঝাঁকে ঝাঁকে পঙ্গপাল নিয়ে এল; ");
INSERT INTO benobcv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","সেগুলি সমগ্র মিশর দেশে হানা দিল এবং বিপুল সংখ্যায় দেশের প্রত্যেকটি অঞ্চলে থিতুও হল। আগে কখনও পঙ্গপালের এরকম আঘাত সহ্য করতে হয়নি, আর কখনও তা করতেও হবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","অন্ধকার হওয়ার আগেই সেগুলি সমস্ত মাঠঘাট ঢেকে ফেলল। শিলাবৃষ্টির পর যা কিছু অবশিষ্ট থেকে গিয়েছিল—মাঠেঘাটে বেড়ে ওঠা সবকিছু এবং গাছের ফলমূল সেগুলি গ্রাস করে ফেলল। মিশর দেশের সর্বত্র গাছপালায় বা লতাপাতায় কোনও সবুজ অংশ অবশিষ্ট রইল না। ");
INSERT INTO benobcv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ফরৌণ তাড়াতাড়ি মোশি ও হারোণকে ডেকে পাঠালেন এবং বললেন, “আমি তোমাদের ঈশ্বর সদাপ্রভুর বিরুদ্ধে ও তোমাদের বিরুদ্ধেও পাপ করেছি। ");
INSERT INTO benobcv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","এখন আর একবার আমার পাপ ক্ষমা করে দাও, এবং এই মৃত্যুজনক আঘাত আমার কাছ থেকে দূর করার জন্য তোমাদের ঈশ্বর সদাপ্রভুর কাছে প্রার্থনা করো।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","মোশি পরে ফরৌণকে ছেড়ে সদাপ্রভুর কাছে প্রার্থনা করতে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","আর সদাপ্রভু সেই বাতাসকে প্রচণ্ড এক পশ্চিমী বাতাসে পরিবর্তিত করে দিলেন, যা পঙ্গপালগুলিকে ধরে উঠিয়ে নিয়ে গিয়ে লোহিত সাগরে ফেলে দিল। মিশরে কোথাও আর একটিও পঙ্গপাল অবশিষ্ট রইল না। ");
INSERT INTO benobcv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","কিন্তু সদাপ্রভু ফরৌণের হৃদয় কঠিন করে দিলেন, এবং তিনি ইস্রায়েলীদের যেতে দিলেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","পরে সদাপ্রভু মোশিকে বললেন, “আকাশের দিকে তোমার হাত প্রসারিত করো যেন মিশরের উপর অন্ধকার ছড়িয়ে পড়ে—তা এমন অন্ধকার যা অনুভব করা যায়।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","অতএব মোশি আকাশের দিকে তাঁর হাত প্রসারিত করলেন, এবং সমগ্র মিশর দেশ তিনদিনের জন্য অন্ধকারে ঢেকে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","তিন দিন ধরে কেউ কাউকে দেখতে পায়নি বা চলাফেরাও করতে পারেনি। অথচ ইস্রায়েলীরা যেখানে বসবাস করত সেখানে তাদের কাছে আলো ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","তখন ফরৌণ মোশিকে ডেকে পাঠালেন এবং বললেন, “যাও, সদাপ্রভুর আরাধনা করো। এমনকি তোমাদের মহিলারা এবং সন্তানেরাও তোমাদের সঙ্গে যেতে পারে; শুধু তোমাদের মেষপাল ও পশুপাল এখানে রেখে যাও।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","কিন্তু মোশি বললেন, “আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশে উপহার বলি এবং হোমবলি উৎসর্গ করার জন্য আপনাকে আমাদের অনুমতি দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","আমাদের গৃহপালিত পশুপালও আমাদের সঙ্গে অবশ্যই যাবে; একটি খুরও এখানে পড়ে থাকবে না। আমাদের ঈশ্বর সদাপ্রভুর আরাধনায় সেগুলির মধ্যে কয়েকটিকে আমাদের ব্যবহার করতে হবে, আর যতক্ষণ না আমরা সেখানে পৌঁছাচ্ছি, ততক্ষণ পর্যন্ত আমরা জানতে পারব না যে সদাপ্রভুর আরাধনার জন্য আমাদের কী কী ব্যবহার করতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","কিন্তু সদাপ্রভু ফরৌণের হৃদয় কঠিন করে দিলেন, এবং তিনি তাঁদের যেতে দিতে চাইলেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ফরৌণ মোশিকে বললেন, “আমার চোখের সামনে থেকে দূর হয়ে যাও! নিশ্চিত করে নাও যে আমার সামনে তুমি আর কখনও দর্শন দেবে না! যেদিন আমার মুখদর্শন করবে সেদিনই তুমি মারা যাবে!” ");
INSERT INTO benobcv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“আপনি ঠিকই বলেছেন,” মোশি উত্তর দিলেন, “আমি আর কখনোই আপনার সামনে দর্শন দেব না।” ");
INSERT INTO benobcv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","এদিকে সদাপ্রভু মোশিকে বললেন, “আমি ফরৌণের ও মিশরের উপর আরও একটি আঘাত নিয়ে আসব। পরে, সে তোমাদের এখান থেকে যেতে দেবে, এবং যখন সে তা করবে, তখন সম্পূর্ণরূপে সে তোমাদের তাড়িয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","লোকদের বলো, স্ত্রী-পুরুষ সবাই যেন তাদের প্রতিবেশীদের কাছে রুপো ও সোনার তৈরি জিনিসপত্র চেয়ে নেয়।” ");
INSERT INTO benobcv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(সদাপ্রভু লোকজনের প্রতি মিশরীয়দের অনুগ্রহকারী করে তুলেছিলেন, এবং স্বয়ং মোশি মিশরে ফরৌণের কর্মকর্তাদের ও তাঁর প্রজাদের দৃষ্টিতে খুব শ্রদ্ধাভাজন হয়ে উঠেছিলেন।) ");
INSERT INTO benobcv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","অতএব মোশি বললেন, “সদাপ্রভু একথাই বলেন: ‘মাঝরাত নাগাদ আমি মিশরের মধ্যে দিয়ে যাব। ");
INSERT INTO benobcv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","মিশরের প্রত্যেক প্রথমজাত পুত্রসন্তান মারা যাবে, যে সিংহাসনে বসতে চলেছে, ফরৌণের সেই প্রথমজাত ছেলেটি থেকে শুরু করে, ক্রীতদাসীর যাঁতার কাছে বসে থাকা তার প্রথমজাত ছেলে, এবং গবাদি পশুপালের প্রথমজাত সব শাবকও মারা যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","মিশরের সর্বত্র প্রবল হাহাকার উঠবে—এত প্রবল হাহাকার আগে কখনও শোনা যায়নি বা আর কখনও শোনাও যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","কিন্তু ইস্রায়েলীদের মধ্যে কোনও মানুষের বা পশুর বিরুদ্ধে একটি কুকুরও ঘেউ ঘেউ করবে না।’ তখন আপনি জানতে পারবেন যে সদাপ্রভু মিশরের ও ইস্রায়েলীদের মধ্যে এক পার্থক্য রচনা করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","আপনার এইসব কর্মকর্তা আমার কাছে আসবে, আমার সামনে মাথা নত করবে ও বলবে, ‘যাও, তুমি ও তোমার অনুগামী সব লোকজন চলে যাও!’ পরে আমি চলে যাব।” এরপর মোশি প্রচণ্ড রেগে গিয়ে, ফরৌণকে ছেড়ে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","সদাপ্রভু মোশিকে বলে দিয়েছিলেন, “ফরৌণ তোমার কথা শুনতে চাইবে না—যেন মিশরে আমার অলৌকিক কাজের সংখ্যা বৃদ্ধি হয়।” ");
INSERT INTO benobcv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","মোশি ও হারোণ ফরৌণের সামনে এইসব অলৌকিক কাজ সম্পন্ন করলেন, কিন্তু সদাপ্রভু ফরৌণের হৃদয় কঠিন করে দিলেন, এবং তিনি তাঁর দেশ থেকে ইস্রায়েলীদের চলে যেতে দিলেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","মিশরে সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“এই মাসটি তোমাদের জন্য প্রথম মাস, তোমাদের বছরের প্রথম মাস হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ইস্রায়েলের সমগ্র জনসাধারণকে বলো যে এই মাসের দশম দিনে প্রত্যেকটি লোককে তার পরিবারের জন্য একটি করে মেষশাবক নিতে হবে, এক-একটি পরিবারের জন্য এক-একটি মেষশাবক। ");
INSERT INTO benobcv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","যদি কোনও পরিবার সম্পূর্ণ একটি মেষশাবক নেওয়ার ক্ষেত্রে খুব ছোটো হয়ে যায়, তবে তারা তাদের নিকটতম প্রতিবেশীদের সঙ্গে সেখানকার জনসংখ্যার আধারে অবশ্যই যেন সেটি ভাগাভাগি করে নেয়। প্রত্যেকে যতখানি করে খাবে সেই অনুসারে মেষশাবকের পরিমাণ তোমরা নির্দিষ্ট করে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","যে পশুগুলি তোমরা বাছাই করে রাখবে সেগুলি অবশ্যই যেন খুঁতবিহীন এক বছর বয়স্ক মদ্দা হয়, এবং তোমরা সেগুলি মেষ বা ছাগপাল থেকে নিতে পারো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","মাসের সেই চতুর্দশতম দিন পর্যন্ত সেগুলির যত্ন নিয়ো, যেদিন ইস্রায়েলী জনসাধারণের অন্তর্গত সব সদস্য অবশ্যই গোধূলি লগ্নে সেগুলি বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","পরে খানিকটা রক্ত নিয়ে তা তাদের সেই বাড়ির দরজার চৌকাঠের দুই পাশে ও উপর দিকে লাগিয়ে দিতে হবে, যেখানে তারা সেই মেষশাবকগুলি খাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","সেরাতেই আগুনে ঝলসে সেই মাংস তাদের তেতো শাক ও খামিরবিহীন রুটির সাথে খেতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","সেই মাংস কাঁচা বা জলে সিদ্ধ করে খেয়ো না, কিন্তু তা আগুনে ঝলসে নিও—মাথা, পা ও অভ্যন্তরীণ অঙ্গপ্রত্যঙ্গ সমেত। ");
INSERT INTO benobcv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","সকাল পর্যন্ত সেটির কোনো কিছুই অবশিষ্ট রেখো না; যদি কোনো কিছু সকাল পর্যন্ত অবশিষ্ট থেকে যায়, তা তোমাদের পুড়িয়ে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","এইভাবেই তোমাদের তা খেতে হবে: তোমরা আলখাল্লা কোমরবন্ধে গুঁজে নেবে, পায়ে চটিজুতো পরে থাকবে এবং হাতে ছড়ি ধরে রাখবে। তাড়াতাড়ি করে তা খাবে; এ হল সদাপ্রভুর নিস্তারপর্ব। ");
INSERT INTO benobcv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“সেরাতেই আমি মিশরের মধ্যে দিয়ে যাব এবং মানুষ ও পশু উভয়ের প্রত্যেক প্রথমজাতকে আঘাত করব, এবং মিশরের সব দেবতাকে আমি দণ্ড দেব। আমিই সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","তোমরা যেখানে আছ, সেই ঘরগুলির উপর সেই রক্তই তোমাদের জন্য চিহ্ন হবে, এবং আমি যখন সেই রক্ত দেখব, তখন আমি তোমাদের অতিক্রম করে যাব। আমি যখন মিশরকে আঘাত করব, তখন কোনও ধ্বংসাত্মক আঘাত তোমাদের স্পর্শ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“এ এমন একদিন যা তোমাদের স্মরণার্থক দিনরূপে পালন করতে হবে; আগামী বংশপরম্পরায় তোমরা এটি সদাপ্রভুর উদ্দেশে পালনীয় এক উৎসবরূপে পালন করবে—যা হবে এক দীর্ঘস্থায়ী বিধি। ");
INSERT INTO benobcv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","সাত দিন ধরে তোমাদের খামিরবিহীন রুটি খেতে হবে। প্রথম দিনই তোমাদের বাড়িঘর থেকে খামির বিদায় করে দেবে, কারণ যে কেউ প্রথম দিন থেকে শুরু করে সপ্তম দিন পর্যন্ত খামিরযুক্ত কোনো কিছু খাবে, তাকে ইস্রায়েল থেকে বিচ্ছিন্ন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","প্রথম দিনে পবিত্র সমাবেশ রাখবে এবং সপ্তম দিনও আরও একটি কোরো। শুধুমাত্র সবার জন্য খাবার রান্না করা ছাড়া এই দিনগুলিতে তোমরা আর কোনও কাজকর্ম কোরো না; শুধু এটুকুই করতে পারো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“খামিরবিহীন রুটির উৎসব পালন কোরো, কারণ ঠিক এই দিনেই আমি তোমাদের বাহিনীকে মিশর থেকে বের করে এনেছিলাম। আগামী বংশপরম্পরায় এক দীর্ঘস্থায়ী বিধিরূপে এই দিনটি পালন কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","প্রথম মাসে তোমাদের খামিরবিহীন রুটি খেতে হবে, চতুর্দশ দিনের সন্ধ্যাবেলা থেকে একুশতম দিনের সন্ধ্যাবেলা পর্যন্ত। ");
INSERT INTO benobcv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","সাত দিন যেন তোমাদের বাড়িঘরে কোনও খামির পাওয়া না যায়। আর বিদেশি হোক বা দেশজাত, যে কেউ এইসময় খামিরযুক্ত কোনো কিছু খাবে, তাকে ইস্রায়েলের জনসমাজ থেকে বিচ্ছিন্ন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","খামির দিয়ে তৈরি কোনো কিছুই খেয়ো না। তোমরা যেখানেই বসবাস করো না কেন, তোমরা অবশ্যই খামিরবিহীন রুটি খাবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","তখন মোশি ইস্রায়েলের সব প্রাচীনকে ডেকে পাঠালেন এবং তাঁদের বললেন, “এক্ষুনি যাও ও তোমাদের পরিবারগুলির জন্য পশুগুলি মনোনীত করো এবং নিস্তারপর্বীয় মেষশাবক জবাই করো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","একগুচ্ছ এসোব নাও, গামলায় রাখা রক্তে সেটি চুবিয়ে নাও এবং সেই রক্তের কিছুটা দরজার চৌকাঠের উপর দিকে ও দুই পাশে লাগিয়ে দাও। সকাল না হওয়া পর্যন্ত তোমাদের মধ্যে কেউ দরজা দিয়ে বাইরে যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","সদাপ্রভু যখন মিশরীয়দের আঘাত করার জন্য দেশের মধ্যে দিয়ে এগিয়ে যাবেন, তিনি দরজার চৌকাঠের উপর দিকে ও দুই পাশে রক্ত দেখবেন এবং দরজার সেই চৌকাঠ পার করে যাবেন, ও তিনি বিনাশকারীকে তোমাদের ঘরে ঢুকে তোমাদের আঘাত করার অনুমতি দেবেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“তোমাদের নিজেদের ও তোমাদের বংশধরদের জন্য দীর্ঘস্থায়ী এক বিধিরূপে তোমরা এই নির্দেশাবলির বাধ্য হোয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","যে দেশটি সদাপ্রভু তাঁর প্রতিজ্ঞানুসারে তোমাদের দেবেন, তোমরা যখন সেখানে প্রবেশ করবে, তখন সেখানেও এই অনুষ্ঠানটি তোমরা পালন কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","আর তোমাদের সন্তানেরা যখন তোমাদের জিজ্ঞাসা করবে, ‘তোমাদের কাছে এই অনুষ্ঠানটির অর্থ কী?’ ");
INSERT INTO benobcv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","তখন তাদের বোলো, ‘এটি সেই সদাপ্রভুর উদ্দেশে উৎসর্গীকৃত নিস্তারপর্বীয় বলি, যিনি মিশরে ইস্রায়েলীদের বাড়িঘর অতিক্রম করে গিয়েছিলেন এবং যখন তিনি মিশরীয়দের আঘাত করেছিলেন, তখন আমাদের ঘরগুলি বাদ দিয়েছিলেন।’ ” তখন লোকেরা মাথা নত করে আরাধনা করল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","সদাপ্রভু মোশি ও হারোণকে যে আদেশ দিয়েছিলেন ইস্রায়েলীরা ঠিক তাই করল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","মাঝরাতে সদাপ্রভু মিশরে সব প্রথমজাতকে, সিংহাসনে উপবিষ্ট ফরৌণের প্রথমজাত সন্তান থেকে শুরু করে অন্ধকূপে থাকা বন্দির প্রথমজাত সন্তান, এবং সব গৃহপালিত পশুর প্রথমজাত শাবক পর্যন্ত সবাইকে আঘাত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","রাতের বেলায় ফরৌণ এবং তাঁর কর্মকর্তারা ও মিশরীয়রা সবাই জেগে গেল, আর মিশরে প্রবল হাহাকার শুরু হয়ে গেল, কারণ এমন কোনও বাড়ি ছিল না যেখানে কেউ মারা যায়নি। ");
INSERT INTO benobcv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","রাতেই ফরৌণ মোশি ও হারোণকে ডেকে পাঠালেন ও বললেন, “ওঠো! তোমরা ও ইস্রায়েলীরা আমার প্রজাদের ছেড়ে চলে যাও! যাও, তোমরা যেমন অনুরোধ জানিয়েছিলে, সেই অনুসারে গিয়ে সদাপ্রভুর আরাধনা করো। ");
INSERT INTO benobcv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","তোমরা যেমন বলেছিলে, সেভাবেই তোমাদের মেষপাল ও পশুপাল নিয়ে চলে যাও। আর আমাকে আশীর্বাদও করো।” ");
INSERT INTO benobcv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","মিশরীয়রা লোকদের অনুরোধ জানাল যেন যত তাড়াতাড়ি সম্ভব তারা দেশ ছেড়ে চলে যায়। “কারণ তা না হলে,” তারা বলল, “আমরা সবাই মারা যাব!” ");
INSERT INTO benobcv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","অতএব লোকেরা খামির মেশানোর আগেই তাদের আটার তালগুলি তুলে নিল, এবং কাপড়ে মুড়ে সেগুলি কেঠোয় রেখে কাঁধে তুলে নিল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ইস্রায়েলীরা মোশির নির্দেশানুসারেই সবকিছু করল এবং তারা মিশরীয়দের কাছে রুপো ও সোনার তৈরি জিনিসপত্র এবং পোশাক-পরিচ্ছদ চেয়ে নিল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","সদাপ্রভু লোকদের প্রতি মিশরীয়দের অনুগ্রহকারী করে দিয়েছিলেন, এবং ইস্রায়েলীরা তাদের কাছে যা যা চেয়েছিল, তারা সেসবকিছু তাদের দিয়েছিল; অতএব তারা মিশরীয়দের জিনিসপত্র অপহরণ করল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ইস্রায়েলীরা রামিষেষ থেকে সুক্কোতের উদ্দেশে যাত্রা করল। মহিলা ও শিশুদের বাদ দিয়ে, সেখানে প্রায় 6 লক্ষ পদাতিক পুরুষ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","অন্যান্য আরও অনেক লোকজন তাদের সঙ্গে গেল, এবং এছাড়াও গৃহপালিত পশুপালের বিশাল এক দলও গেল, তাতে মেষ ও গবাদি পশুপালও ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","যে আটার তাল ইস্রায়েলীরা মিশর থেকে এনেছিল, তা দিয়ে তারা খামিরবিহীন রুটি সেঁকে নিল। আটার সেই তাল খামিরবিহীন ছিল কারণ তাদের মিশর থেকে তাড়িয়ে দেওয়া হয়েছিল ও তারা নিজেদের জন্য খাবার তৈরি করার সময় পায়নি। ");
INSERT INTO benobcv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ইস্রায়েলী জনগণ মিশরে 430 বছর ধরে বসবাস করল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","সেই 430 বছরের শেষে, সেদিনই, সদাপ্রভুর সব বাহিনী মিশর ছেড়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","যেহেতু সেরাতে তাদের মিশর থেকে বের করে আনার জন্য সদাপ্রভু সতর্কতা অবলম্বন করেছিলেন, তাই আগামী বংশপরম্পরায় সদাপ্রভুকে সম্মান জানানোর জন্য এরাতে ইস্রায়েলীদের সবাইকে সতর্কতা অবলম্বন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","সদাপ্রভু মোশি ও হারোণকে বললেন, “এগুলিই হল নিস্তারপর্বীয় খাদ্যের নিয়মকানুন: “কোনো বিদেশি লোক এটি খেতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","যাকে তোমরা কিনে নেওয়ার পর সুন্নত করিয়েছ, সেরকম এক ক্রীতদাস এটি খেতে পারে, ");
INSERT INTO benobcv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","কিন্তু অস্থায়ী এক বাসিন্দা বা এক ঠিকা শ্রমিক এটি খেতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“বাড়ির ভিতরেই এটি খেতে হবে; সেই মাংসের কিছুই বাড়ির বাইরে নিয়ে যেয়ো না। কোনও অস্থি ভেঙো না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ইস্রায়েলীদের সমগ্র জনসমাজকে এটি পালন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“তোমাদের মধ্যে বসবাসকারী কোনো বিদেশি লোক যদি সদাপ্রভুর নিস্তারপর্ব পালন করতে চায়, তবে তাকে পরিবারের সব পুরুষ সদস্যকে সুন্নত করাতে হবে; পরেই সে দেশজাত একজনের মতো এতে অংশগ্রহণ করতে পারবে। সুন্নত না করানো কোনো পুরুষ এটি খেতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","যারা দেশজাত ও যেসব বিদেশি তোমাদের মধ্যে বসবাস করছে, তাদের উভয়ের ক্ষেত্রেই একই নিয়মকানুন প্রযোজ্য হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ইস্রায়েলীরা সবাই ঠিক তাই করল, যা করার আদেশ সদাপ্রভু মোশি ও হারোণকে দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","আর ঠিক সেদিনই সদাপ্রভু ইস্রায়েলীদের বাহিনী অনুসারে তাদের মিশর থেকে বের করে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“প্রত্যেকটি প্রথমজাত পুরুষকে আমার উদ্দেশে পবিত্র করো। মানুষ হোক কি পশু, ইস্রায়েলীদের মধ্যে প্রত্যেকটি গর্ভের প্রথম সন্তানটি আমার।” ");
INSERT INTO benobcv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","তখন মোশি লোকদের বললেন, “যেদিন তোমরা মিশর থেকে, ক্রীতদাসত্বের দেশ থেকে বের হয়ে এসেছিলে, সেদিনটির স্মরণার্থে এদিন উৎসব পালন করো, কারণ সদাপ্রভু শক্তিশালী হাত দিয়ে তোমাদের সেখান থেকে বের করে এনেছেন। খামিরযুক্ত কোনো কিছু খেয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","আজ, আবীব মাসে, তোমরা বের হয়ে যাচ্ছ। ");
INSERT INTO benobcv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","সদাপ্রভু যখন তোমাকে কনানীয়, হিত্তীয়, ইমোরীয়, হিব্বীয়, ও যিবূষীয়দের দেশে—যে দেশটি তিনি তোমাকে দেওয়ার বিষয়ে তোমার পূর্বপুরুষদের কাছে প্রতিজ্ঞা করেছিলেন, দুধ ও মধু প্রবাহিত সেই দেশে—নিয়ে আসবেন, তখন এই মাসে তোমাকে এই পর্বটি পালন করতে হবে: ");
INSERT INTO benobcv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","সাত দিন ধরে তুমি খামিরবিহীন রুটি খেয়ো এবং সপ্তম দিনে সদাপ্রভুর উদ্দেশে একটি উৎসবের আয়োজন কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","সেই সাত দিন যাবৎ তুমি খামিরবিহীন রুটি খেয়ো; খামিরযুক্ত কোনো কিছু যেন তোমার কাছে দেখা না যায়, বা তোমার সীমানার মধ্যেও যেন কোথাও কোনও খামির দেখা না যায়। ");
INSERT INTO benobcv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","সেদিন তুমি তোমার সন্তানকে বোলো, ‘আমি যখন মিশর থেকে বের হয়ে এসেছিলাম তখন সদাপ্রভু আমার জন্য যা করেছিলেন, সেজন্যই আমি এরকম করছি।’ ");
INSERT INTO benobcv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","এই অনুষ্ঠানটি তোমার জন্য তোমার হাতে এক চিহ্নের মতো ও তোমার কপালে এক স্মৃতিচিহ্ন হয়ে থাকবে যেন সদাপ্রভুর এই বিধান তোমার ঠোঁটেই থাকে। কারণ সদাপ্রভু তাঁর শক্তিশালী হাত দিয়ে তোমাকে মিশর থেকে বের করে এনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","বছরের পর বছর ধরে নিরূপিত সময়ে তোমাকে এই বিধিটি পালন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“সদাপ্রভু তোমাকে কনানীয়দের দেশে নিয়ে আসার পর ও সেটি তোমাকে দেওয়ার পর, যেভাবে তিনি তোমার কাছে ও তোমার পূর্বপুরুষদের কাছে শপথ নিয়ে প্রতিজ্ঞা করেছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","তোমার প্রত্যেকটি গর্ভের প্রথম সন্তান সদাপ্রভুর হাতে তুলে দিতে হবে। তোমার গৃহপালিত পশুপালের সব প্রথমজাত মদ্দা সদাপ্রভুর। ");
INSERT INTO benobcv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","প্রত্যেকটি প্রথমজাত গাধাকে এক-একটি মেষশাবক দিয়ে মুক্ত কোরো, কিন্তু যদি সেটি মুক্ত না করো, তবে সেটির ঘাড় ভেঙে দিয়ো। তোমার ছেলেদের মধ্যে প্রত্যেক প্রথমজাতকে মুক্ত কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ভবিষ্যতে, তোমার সন্তানেরা যখন তোমাকে জিজ্ঞাসা করবে, ‘এর অর্থ কী?’ তখন তুমি তাকে বোলো, ‘শক্তিশালী হাত দিয়ে সদাপ্রভু আমাদের মিশর থেকে, ক্রীতদাসত্বের সেই দেশ থেকে বের করে এনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ফরৌণ যখন একগুঁয়েমি দেখিয়ে আমাদের যেতে দিতে অস্বীকার করলেন, সদাপ্রভু তখন মিশরে মানুষ ও পশু, উভয়ের প্রথমজাতদের হত্যা করলেন। এজন্যই আমি সদাপ্রভুর উদ্দেশে প্রত্যেকটি গর্ভের প্রথম পুং-সন্তানকে বলিরূপে উৎসর্গ করছি এবং আমার প্রথমজাত ছেলেদের মধ্যে এক একজনকে মুক্ত করছি।’ ");
INSERT INTO benobcv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","আর এটি তোমার হাতে এই এক চিহ্নের ও তোমার কপালে এই এক প্রতীকের মতো হবে যে সদাপ্রভু তাঁর শক্তিশালী হাত দিয়ে আমাদের মিশর থেকে বের করে এনেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ফরৌণ যখন লোকদের যেতে দিলেন, ঈশ্বর তখন তাদের ফিলিস্তিনীদের দেশের মধ্যে দিয়ে স্থলপথে পথ দেখিয়ে নিয়ে যাননি, যদিও সেটিই সংক্ষিপ্ত পথ। কারণ ঈশ্বর বললেন, “যদি তারা যুদ্ধের সম্মুখীন হয়, তবে তারা হয়তো তাদের মন পরিবর্তন করে ফেলবে এবং মিশরে ফিরে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","অতএব ঈশ্বর ঘুরপথে লোকদের মরুভূমির পথ দিয়ে লোহিত সাগরের দিকে নিয়ে গেলেন। ইস্রায়েলীরা যুদ্ধের জন্য প্রস্তুত হয়েই মিশর থেকে বের হয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","মোশি যোষেফের অস্থিও সাথে নিলেন কারণ যোষেফ ইস্রায়েলীদের দিয়ে এক প্রতিজ্ঞা করিয়ে নিয়েছিলেন। তিনি বলে দিয়েছিলেন, “ঈশ্বর নিঃসন্দেহে তোমাদের সাহায্য করতে আসবেন, এবং তখন তোমাদের অবশ্যই নিজেদের সাথে আমার অস্থি এখান থেকে বয়ে নিয়ে যেতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","সুক্কোৎ ছেড়ে আসার পর তারা মরুভূমির এক প্রান্তে অবস্থিত এথমে শিবির স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","সদাপ্রভু দিনের বেলায় এক মেঘস্তম্ভের মধ্যে থেকে তাদের পথ দেখানোর জন্য এবং রাতের বেলায় এক অগ্নিস্তম্ভের মধ্যে থেকে তাদের আলো দেওয়ার জন্য তাদের অগ্রগামী হলেন, যেন দিনরাত তারা যাত্রা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","দিনের বেলায় মেঘস্তম্ভ বা রাতের বেলায় অগ্নিস্তম্ভ, কোনোটিই লোকদের সামনে থেকে সরে যায়নি। ");
INSERT INTO benobcv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ইস্রায়েলীদের বলো, তারা যেন পিছনে ফিরে মিগ্‌দোলের ও সমুদ্রের মাঝামাঝিতে অবস্থিত পী-হহীরোতের কাছে শিবির স্থাপন করে। তাদের সরাসরি বায়াল-সফোনের বিপরীত দিকে, সমুদ্রের ধারে শিবির স্থাপন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ফরৌণ ভাববে, ‘ইস্রায়েলীরা মরুভূমি দ্বারা পরিবেষ্টিত হয়ে, ধন্দে পড়ে দেশে ইতস্তত বিচরণ করে বেড়াচ্ছে।’ ");
INSERT INTO benobcv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","আর আমি ফরৌণের হৃদয় কঠিন করে দেব, এবং সে তাদের পশ্চাদ্ধাবন করবে। কিন্তু আমি ফরৌণ ও তার সমগ্র সৈন্যদলের মাধ্যমে স্বয়ং গৌরব লাভ করব, এবং মিশরীয়রা জানতে পারবে যে আমিই সদাপ্রভু।” অতএব ইস্রায়েলীরা এরকমই করল। ");
INSERT INTO benobcv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","মিশররাজকে যখন বলা হল যে লোকেরা পালিয়েছে, তখন ফরৌণ ও তাঁর কর্মকর্তারা তাদের বিষয়ে নিজেদের মন পরিবর্তন করে বললেন, “আমরা এ কী করলাম? আমরা ইস্রায়েলীদের যেতে দিলাম ও তাদের পরিষেবা হারালাম!” ");
INSERT INTO benobcv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","অতএব তিনি তাঁর রথ প্রস্তুত করলেন ও তাঁর সৈন্যদল সঙ্গে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","সেরা রথগুলির মধ্যে থেকে তিনি 600-টি রথ নিলেন, এছাড়াও মিশরের অন্য সব রথ ও সেসবের উপর নিযুক্ত কর্মকর্তাদেরও সঙ্গে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","সদাপ্রভু মিশরের রাজা ফরৌণের হৃদয় কঠিন করে দিলেন, যেন তিনি সেই ইস্রায়েলীদের পশ্চাদ্ধাবন করেন, যারা নির্ভীকভাবে কুচকাওয়াজ করে এগিয়ে যাচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","মিশরীয়রা—ফরৌণের সব ঘোড়া ও রথ, ঘোড়সওয়ার ও সেনা—ইস্রায়েলীদের পশ্চাদ্ধাবন করল এবং তারা যখন বায়াল-সফোনের বিপরীত দিকে, পী-হহীরোতের কাছে সমুদ্রের ধারে শিবির স্থাপন করে বসেছিল, তখন তাদের নাগাল পেল। ");
INSERT INTO benobcv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ফরৌণ যেই না তাদের কাছে এগিয়ে এলেন, ইস্রায়েলীরা চোখ তুলে তাকাল, আর মিশরীয়রা তাদের পিছনে ধেয়ে আসছিল। তারা আতঙ্কিত হয়ে পড়ল এবং সদাপ্রভুর কাছে কাঁদতে শুরু করল। ");
INSERT INTO benobcv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","তারা মোশিকে বলল, “মিশরে কি কোনও কবরস্থান ছিল না যে তুমি মরার জন্য আমাদের এই মরুভূমিতে নিয়ে এসেছ? মিশর থেকে আমাদের বের করে এনে তুমি আমাদের প্রতি এ কী করলে? ");
INSERT INTO benobcv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","মিশরেই কি আমরা তোমাকে বলিনি, ‘আমাদের একা ছেড়ে দাও; মিশরীয়দের সেবা করতে দাও’? মরুভূমিতে মরার চেয়ে মিশরীয়দের সেবা করাই আমাদের পক্ষে ভালো ছিল।” ");
INSERT INTO benobcv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","মোশি লোকদের উত্তর দিলেন, “তোমরা ভয় পেয়ো না! শক্ত হয়ে দাঁড়াও এবং তোমরা দেখতে পাবে আজ সদাপ্রভু কীভাবে তোমাদের রক্ষা করবেন। আজ তোমরা যে মিশরীয়দের দেখছ, তাদের আর কখনও দেখতে পাবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","সদাপ্রভু তোমাদের হয়ে যুদ্ধ করবেন; তোমাদের শুধু স্থির হয়ে থাকতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","তখন সদাপ্রভু মোশিকে বললেন, “তুমি আমার কাছে কাঁদছ কেন? ইস্রায়েলীদের এগিয়ে যেতে বলো। ");
INSERT INTO benobcv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","তোমার ছড়িটি উঠিয়ে নাও এবং জল ভাগ করার জন্য তোমার হাতটি সমুদ্রের উপর প্রসারিত করো যেন ইস্রায়েলীরা সমুদ্রের একদিক থেকে অন্যদিকে শুকনো জমির উপর দিয়ে চলে যেতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","আমি মিশরীয়দের হৃদয় কঠিন করে দেব, যেন তারা তাদের পশ্চাৎগামী হয়। আর আমি ফরৌণের ও তার সমগ্র সৈন্যদলের, তার রথগুলির ও তার ঘোড়সওয়ারদের মাধ্যমে গৌরব লাভ করব। ");
INSERT INTO benobcv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","আমি যখন ফরৌণের, তার রথগুলির ও তার ঘোড়সওয়ারদের মাধ্যমে গৌরব লাভ করব, তখনই মিশরীয়রা জানবে যে আমিই সদাপ্রভু।” ");
INSERT INTO benobcv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ঈশ্বরের যে দূত ইস্রায়েলী সৈন্যদলের আগে আগে যাচ্ছিলেন, তিনি তখন সরে গিয়ে তাদের পিছনে চলে গেলেন। মেঘস্তম্ভও তাদের সামনে থেকে সরে গেল এবং তাদের পিছনে গিয়ে, ");
INSERT INTO benobcv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","মিশর ও ইস্রায়েলের সৈন্যদলের মাঝখানে চলে এল। সারারাত মেঘ একদিকে অন্ধকার ও অন্যদিকে আলো নিয়ে এসেছিল; তাই সারারাত তারা কেউই অন্য দলের কাছে যায়নি। ");
INSERT INTO benobcv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","পরে মোশি সমুদ্রের উপর তাঁর হাত প্রসারিত করলেন, এবং সেই সারারাত সদাপ্রভু এক প্রবল পূর্বীয় বাতাস বইয়ে সমুদ্রকে পিছিয়ে দিলেন এবং সেটিকে শুকনো জমিতে পরিণত করলেন। জল দুই ভাগে বিভক্ত হয়ে গেল, ");
INSERT INTO benobcv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","এবং ইস্রায়েলীরা শুকনো জমির উপর দিয়ে সমুদ্রের একদিক থেকে অন্যদিকে চলে গেল, আর তাদের ডানদিকে ও তাদের বাঁদিকে ছিল জলের এক প্রাচীর। ");
INSERT INTO benobcv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","মিশরীয়রা তাদের পশ্চাদ্ধাবন করল, এবং ফরৌণের সব ঘোড়া ও রথ ও ঘোড়সওয়ার ইস্রায়েলীদের অনুগামী হয়ে সমুদ্রে গিয়ে পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","রাতের শেষ প্রহরে সদাপ্রভু অগ্নিস্তম্ভ ও মেঘস্তম্ভ থেকে নিচে সেই মিশরীয় সৈন্যদলের দিকে দৃষ্টিপাত করলেন এবং সেখানে বিশৃঙ্খলা সৃষ্টি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","তিনি তাদের রথগুলির চাকা আটকে দিলেন যেন রথ চালাতে তাদের অসুবিধা হয়। আর মিশরীয়রা বলল, “এসো, আমরা ইস্রায়েলীদের কাছ থেকে দূরে সরে যাই! মিশরের বিরুদ্ধে সদাপ্রভুই তাদের হয়ে যুদ্ধ করছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","তখন সদাপ্রভু মোশিকে বললেন, “তোমার হাত সমুদ্রের উপর প্রসারিত করে দাও যেন মিশরীয়দের উপর এবং তাদের রথ ও ঘোড়সওয়ারদের উপর জলধারা ধেয়ে আসে।” ");
INSERT INTO benobcv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","মোশি সমুদ্রের উপর তাঁর হাত প্রসারিত করে দিলেন, এবং ভোরবেলায় সমুদ্র স্বস্থানে ফিরে গেল। মিশরীয়রা সেদিকেই পালাচ্ছিল, এবং সদাপ্রভু তাদের সমুদ্রে ভাসিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","জলধারা ধেয়ে এসে রথ ও ঘোড়সওয়ারদের—ফরৌণের সমগ্র সেই সৈন্যদলকে ঢেকে দিল যারা ইস্রায়েলীদের অনুগামী হয়ে সমুদ্রে নেমেছিল। তাদের একজনও প্রাণে বাঁচেনি। ");
INSERT INTO benobcv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","কিন্তু ইস্রায়েলীরা তাদের ডানদিকে ও বাঁদিকে জলের এক প্রাচীর সাথে নিয়ে সমুদ্রের একদিক থেকে অন্যদিকে শুকনো জমির উপর দিয়ে চলে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ইস্রায়েলকে সেদিন সদাপ্রভু মিশরীয়দের হাত থেকে রক্ষা করলেন, এবং ইস্রায়েল দেখল মিশরীয়রা সমুদ্রতীরে মরে পড়ে আছে। ");
INSERT INTO benobcv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","আর ইস্রায়েলীরা যখন মিশরীয়দের বিরুদ্ধে সদাপ্রভুর শক্তিশালী হাত প্রদর্শিত হতে দেখল, তখন লোকেরা সদাপ্রভুকে ভয় করল এবং তাঁর উপর ও তাঁর দাস মোশির উপর তাদের আস্থা স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","তখন মোশি ও ইস্রায়েলীরা সদাপ্রভুর উদ্দেশে এই গান গাইলেন: “আমি সদাপ্রভুর উদ্দেশে গান গাইব, কারণ তিনি অত্যন্ত মহিমান্বিত। ঘোড়া ও সওয়ার উভয়কেই তিনি সমুদ্রে নিক্ষেপ করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“সদাপ্রভু আমার শক্তি ও আমার সুরক্ষা; তিনি হলেন আমার পরিত্রাণ। তিনি আমার ঈশ্বর, এবং আমি তাঁর প্রশংসা করব, আমার পৈত্রিক ঈশ্বর, এবং আমি তাঁকে মহিমান্বিত করব। ");
INSERT INTO benobcv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","সদাপ্রভু এক যোদ্ধা; তাঁর নাম সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ফরৌণের রথ ও তাঁর সৈন্যদলকে তিনি সমুদ্রে নিক্ষেপ করলেন। ফরৌণের সেরা কর্মকর্তারা লোহিত সাগরে ডুবে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","গভীর জলরাশি তাদের ঢেকে দিল; এক পাথরের মতো তারা গভীরে তলিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","তোমার ডান হাত, হে সদাপ্রভু, পরাক্রমে অত্যুন্নত। তোমার ডান হাত, হে সদাপ্রভু, শত্রুকে করেছে চূর্ণবিচূর্ণ। ");
INSERT INTO benobcv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“তোমার মহত্ত্বের গরিমায় তোমার বিরোধীদের তুমি নিক্ষেপ করেছ। তোমার জ্বলন্ত ক্রোধ তুমি ছড়িয়ে দিয়েছ; তা তাদের নাড়ার মতো গ্রাস করেছে। ");
INSERT INTO benobcv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","তোমার নাকের বিস্ফোরণে জলরাশি স্তূপাকার হল। উথাল জলরাশি, এক প্রাচীর হয়ে দাঁড়াল; গভীর জলরাশি সমুদ্র-গহ্বরে জমাট বেঁধে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","শত্রু দম্ভভরে বলল, ‘আমি তাদের পশ্চাদ্ধাবন করব, তাদের ধরে ফেলব। আমি লুটের মাল ভাগাভাগি করব; আমি তাদের উপর ঘাটি গাড়ব। আমি আমার তরোয়াল টেনে আনব আর আমার হাত তাদের ধ্বংস করবে।’ ");
INSERT INTO benobcv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","কিন্তু তুমি তোমার শ্বাস দিয়ে ফুঁ দিলে, আর সাগর তাদের ঢেকে দিল। তারা প্রবল জলরাশিতে সীসার মতো ডুবে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","দেবতাদের মধ্যে কে তোমার মতো, হে সদাপ্রভু? তোমার মতো কে— পবিত্রতায় মহিমান্বিত, প্রতাপে অসাধারণ, অলৌকিক কর্মকারী? ");
INSERT INTO benobcv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“তোমার ডান হাত তুমি প্রসারিত করলে, আর পৃথিবী তোমার শত্রুদের গ্রাস করল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","তোমার চিরস্থায়ী প্রেমে করবে তুমি পরিচালনা তোমার মুক্তিপ্রাপ্ত জাতিকে। তোমার শক্তিতে তুমি তাদের পথ দেখাবে তোমার পবিত্র বাসস্থানের দিকে। ");
INSERT INTO benobcv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","জাতিরা শুনবে ও থরথরাবে; ফিলিস্তিনী প্রজারা যন্ত্রণায় কাতর হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ইদোমের নেতারা আতঙ্কিত হবে, মোয়াবের নায়কেরা হবে কম্পন-কবলিত। কনানের প্রজারা গলে যাবে; ");
INSERT INTO benobcv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","আতঙ্ক ও শঙ্কা তাদের উপর এসে পড়বে। তোমার বাহুবলে তারা পাথরের মতো স্থির হয়ে যাবে— যতক্ষণ না তোমার প্রজারা পেরিয়ে যায়, হে সদাপ্রভু, যতক্ষণ না সেই প্রজারা পেরিয়ে যায়, যাদের তুমি কিনে নিয়েছ। ");
INSERT INTO benobcv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","তুমি তাদের ভিতরে আনবে ও রোপণ করবে, তোমার উত্তরাধিকারের পাহাড়ে— সেই স্থান, হে সদাপ্রভু, তুমি করে তোমার বাসস্থান রচেছ, হে সদাপ্রভু, তোমার দুটি হাত সেই পবিত্রস্থান প্রতিষ্ঠিত করেছে। ");
INSERT INTO benobcv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“সদাপ্রভু করলেন রাজত্ব করলেন অনন্তকাল ধরে।” ");
INSERT INTO benobcv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ফরৌণের ঘোড়া, রথ ও ঘোড়সওয়ারেরা যখন সমুদ্রে তলিয়ে গেল, তখন সদাপ্রভু তাদের উপর সমুদ্রের জলরাশি ফিরিয়ে আনলেন, কিন্তু ইস্রায়েলীরা সমুদ্রের একদিক থেকে অন্যদিকে শুকনো জমির উপর দিয়ে হেঁটে চলে গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","তখন মহিলা ভাববাদী মরিয়ম, হারোণের দিদি, নিজের হাতে একটি খঞ্জনি তুলে নিলেন, এবং সব মহিলা তাঁর দেখাদেখি খঞ্জনি বাজিয়ে নেচেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","মরিয়ম তাদের কাছে গান গাইলেন: “সদাপ্রভুর উদ্দেশে গাও গান, কারণ তিনি অত্যন্ত মহিমান্বিত। ঘোড়া ও সওয়ার উভয়কেই তিনি করেছেন সমুদ্রে নিক্ষিপ্ত।” ");
INSERT INTO benobcv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","পরে মোশি লোহিত সাগর থেকে ইস্রায়েলীদের চালিত করলেন এবং তারা শূর মরুভূমিতে চলে গেল। তিন দিন ধরে তারা মরুভূমিতে জল না পেয়ে ভ্রমণ করল। ");
INSERT INTO benobcv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","তারা যখন মারায় পৌঁছাল, তারা সেখানকার জলপান করতে পারেনি কারণ তা ছিল তেতো। (সেজন্যই সেই স্থানটির নাম রাখা হল মারা) ");
INSERT INTO benobcv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","অতএব লোকেরা মোশির বিরুদ্ধে অভিযোগ জানিয়ে বলল, “আমরা কী পান করব?” ");
INSERT INTO benobcv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","তখন মোশি সদাপ্রভুর কাছে কেঁদে ফেললেন, এবং সদাপ্রভু তাঁকে এক টুকরো কাঠ দেখিয়ে দিলেন। তিনি সেটি জলে ছুঁড়ে দিলেন, এবং সেই জল পানের উপযুক্ত হয়ে গেল। সেখানেই সদাপ্রভু তাদের জন্য এক বিধিনির্দেশ ও অনুশাসন দিলেন এবং তাদের পরীক্ষায় ফেলে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","তিনি বললেন, “তোমরা যদি তোমাদের ঈশ্বর সদাপ্রভুর কথা যত্নসহকারে শোনো, এবং তাঁর দৃষ্টিতে যা ন্যায্য তাই করো, তোমরা যদি তাঁর আদেশগুলির প্রতি মনোযোগ দাও ও তাঁর সব হুকুম পালন করো, তবে তোমাদের উপর আমি সেইসব রোগব্যাধির মধ্যে একটিও আনব না, যেগুলি আমি মিশরীয়দের উপরে এনেছিলাম, কারণ আমি সেই সদাপ্রভু, যিনি তোমাদের সুস্থ করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","পরে তারা সেই এলীমে এল, যেখানে বারোটি জলের উৎস ও সত্তরটি খেজুর গাছ ছিল, এবং সেখানে তারা জলের কাছেই শিবির স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ইস্রায়েলীদের সমগ্র জনসমাজ মিশর থেকে বের হয়ে আসার পর দ্বিতীয় মাসের পঞ্চদশতম দিনে এলীম থেকে বের হয়ে সেই সীন মরুভূমিতে এল, যা এলীম ও সীনয়ের মাঝখানে অবস্থিত। ");
INSERT INTO benobcv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","সেই মরুভূমিতে সমগ্র জনসমাজ মোশি ও হারোণের বিরুদ্ধে অভিযোগ জানাল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ইস্রায়েলীরা তাঁদের বলল, “হায় আমরা কেন মিশরেই সদাপ্রভুর হাতে মারা পড়িনি! সেখানে আমরা মাংসের হাঁড়ি ঘিরেই বসে থাকতাম ও আমাদের চাহিদানুসারেই সব খাবারদাবার খেতাম, কিন্তু তোমরা সমগ্র এই জনসমাজকে অনাহারে মেরে ফেলার জন্য আমাদের এই মরুভূমিতে নিয়ে এসেছ।” ");
INSERT INTO benobcv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","তখন সদাপ্রভু মোশিকে বললেন, “আমি তোমাদের জন্য স্বর্গ থেকে খাদ্য বর্ষণ করব। লোকদের প্রতিদিন বাইরে যেতে হবে এবং সেদিনের জন্য যথেষ্ট পরিমাণে তা কুড়াতে হবে। এইভাবে আমি তাদের পরীক্ষা করব ও দেখব তারা আমার নির্দেশাবলি পালন করে কি না। ");
INSERT INTO benobcv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ষষ্ঠ দিনে তারা যেটুকু কুড়াবে সেটুকুই রান্না করবে, এবং তা হবে অন্যান্য দিনে কুড়ানো খাদ্যের তুলনায় দ্বিগুণ বেশি।” ");
INSERT INTO benobcv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","অতএব মোশি ও হারোণ সব ইস্রায়েলীকে বললেন, “সন্ধ্যাবেলায় তোমরা জানতে পারবে যে সদাপ্রভুই তোমাদের মিশর থেকে বের করে এনেছেন, ");
INSERT INTO benobcv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","এবং সকালবেলায় তোমরা সদাপ্রভুর মহিমা দেখতে পাবে, কারণ তাঁর বিরুদ্ধে তোমাদের গজ্‌গজানি তিনি শুনেছেন। আমরা কে, যে তোমরা আমাদের বিরুদ্ধে অভিযোগ জানাচ্ছ?” ");
INSERT INTO benobcv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","মোশি এও বললেন, “যখন তিনি সন্ধ্যাবেলায় তোমাদের মাংস খেতে দেবেন ও সকালবেলায় তোমাদের চাহিদানুসারে সব খাদ্য দেবেন তখনই তোমরা জানতে পারবে যে তা সদাপ্রভুই দিয়েছেন, কারণ তাঁর বিরুদ্ধে করা তোমাদের গজ্‌গজানি তিনি শুনেছেন। আমরা কে? তোমরা আমাদের বিরুদ্ধে অভিযোগ জানাচ্ছ না, কিন্তু সদাপ্রভুর বিরুদ্ধেই জানাচ্ছ।” ");
INSERT INTO benobcv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","তখন মোশি হারোণকে বললেন, “সমগ্র ইস্রায়েলী জনসমাজকে বলো, ‘সদাপ্রভুর সামনে এসো, কারণ তিনি তোমাদের গজ্‌গজানি শুনেছেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","হারোণ যখন সমগ্র ইস্রায়েলী জনসমাজের সঙ্গে কথা বলছিলেন, তখন তারা মরুভূমির দিকে তাকাল, এবং সেখানে সদাপ্রভুর মহিমা মেঘে আবির্ভূত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“আমি ইস্রায়েলীদের গজ্‌গজানি শুনেছি। তাদের বলো, ‘গোধূলিবেলায় তোমরা মাংস খাবে, এবং সকালবেলায় তোমরা খাদ্যে পরিপূর্ণ হবে। তখন তোমরা জানবে যে আমিই সদাপ্রভু তোমাদের ঈশ্বর।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","সেই সন্ধ্যায় ভারুই পাখির দল এল এবং শিবির ঢেকে ফেলল, এবং সকালবেলায় শিবিরের চারপাশে শিশিরের এক পরত পড়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","শিশির সরে যাওয়ার পর, মরুভূমির জমিতে হিমকণার মতো পাতলা আঁশ আবির্ভূত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ইস্রায়েলীরা যখন তা দেখল, তখন তারা পরস্পরকে বলল, “এটি কী?” কারণ সেটি কী তা তারা জানতে পারেনি। মোশি তাদের বললেন, “এ হল সেই খাদ্য যা সদাপ্রভু তোমাদের খেতে দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","সদাপ্রভু এই আদেশই দিয়েছেন: ‘প্রত্যেকে তাদের প্রয়োজন অনুসারেই কুড়াবে। তোমাদের তাঁবুতে থাকা এক একজনের জন্য এক ওমর করে কুড়াও।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ইস্রায়েলীরা তাই করল যা তাদের করতে বলা হয়েছিল; কয়েকজন বেশি পরিমাণে কুড়াল এবং কয়েকজন কম পরিমাণে কুড়াল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","আর যখন তারা তা ওমর দিয়ে মাপল, তখন যে বেশি পরিমাণে কুড়িয়েছিল তার কাছে খুব বেশি ছিল না, এবং যে কম পরিমাণে কুড়িয়েছিল তার কাছে খুব কম ছিল না। প্রত্যেকে ঠিক তাদের চাহিদা অনুসারেই কুড়িয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","পরে মোশি তাদের বললেন, “সকাল পর্যন্ত কেউ এর কোনো কিছুই রাখবে না।” ");
INSERT INTO benobcv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","অবশ্য, তাদের মধ্যে কেউ কেউ মোশির কথায় মনোযোগ দেয়নি; তারা সকাল পর্যন্ত এর অংশবিশেষ রেখে দিয়েছিল, কিন্তু তাতে পোকা লেগে গেল এবং দুর্গন্ধ ছড়াতে শুরু করল। অতএব মোশি তাদের উপর ক্রুদ্ধ হলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","প্রত্যেকদিন সকালবেলায় প্রত্যেকে তাদের চাহিদা অনুসারে কুড়াত, আর সূর্য যখন প্রখর হত, তখন তা গলে যেত। ");
INSERT INTO benobcv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ষষ্ঠ দিনে, তারা দ্বিগুণ পরিমাণে কুড়াল—প্রত্যেকের জন্য দুই ওমর করে—এবং সমাজের নেতারা এসে মোশিকে এই সংবাদ দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","তিনি তাঁদের বললেন, “সদাপ্রভু এই আদেশই দিয়েছেন: ‘আগামীকাল হবে সাব্বাথ বিশ্রামের দিন, সদাপ্রভুর উদ্দেশে এক পবিত্র সাব্বাথ। তাই যা যা তোমরা সেঁকতে চাও তা সেঁকে নাও এবং যা যা জলে সিদ্ধ করতে চাও তা সিদ্ধ করো। যা যা অবশিষ্ট থাকবে তা বাঁচিয়ে সকাল পর্যন্ত রেখে দাও।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","অতএব সকাল পর্যন্ত তারা তা বাঁচিয়ে রাখল, ঠিক যেমনটি মোশি আদেশ দিয়েছিলেন, এবং তাতে দুর্গন্ধ ছড়ায়নি বা তাতে কোনো পোকাও লাগেনি। ");
INSERT INTO benobcv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","“আজ এটি খেয়ে নাও,” মোশি বললেন, “কারণ আজ সদাপ্রভুর উদ্দেশে পালনীয় এক সাব্বাথবার। মাঠে আজ তোমরা এর একটিও খুঁজে পাবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ছয় দিন তোমরা এটি কুড়াবে, কিন্তু সপ্তম দিনে, সাব্বাথবারে, কিছুই থাকবে না।” ");
INSERT INTO benobcv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","তা সত্ত্বেও, কয়েকজন লোক সপ্তম দিনেও তা কুড়ানোর জন্য বাইরে গেল, কিন্তু তারা কিছুই পেল না। ");
INSERT INTO benobcv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","তখন সদাপ্রভু মোশিকে বললেন, “আর কত দিন তুমি আমার আদেশগুলি ও আমার নির্দেশাবলি পালন করতে অস্বীকার করবে? ");
INSERT INTO benobcv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","মনে রেখো যে সদাপ্রভুই তোমাদের সাব্বাথবার দিয়েছেন; সেজন্যই ষষ্ঠ দিনে তিনি তোমাদের দুই দিনের খাদ্য দেন। সপ্তম দিনে যে যেখানে আছে তাকে সেখানেই থাকতে হবে; কেউ যেন বাইরে না যায়।” ");
INSERT INTO benobcv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","অতএব লোকেরা সপ্তম দিনে বিশ্রাম নিল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ইস্রায়েলীরা সেই খাদ্যকে মান্না নাম দিল। এটি দেখতে সাদা রংয়ের ধনে বীজের মতো এবং স্বাদে মধু মাখানো চাকতির মতো হত। ");
INSERT INTO benobcv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","মোশি বললেন, “সদাপ্রভু এই আদেশই দিয়েছেন: ‘এক ওমর মান্না নাও এবং সেটি পরবর্তী প্রজন্মগুলির জন্য রেখে দাও, যেন তারা সেই খাদ্যটি দেখতে পায় যা মিশর দেশ থেকে তোমাদের বের করে আনার পর, মরুভূমিতে আমি তোমাদের খেতে দিয়েছিলাম।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","অতএব মোশি হারোণকে বললেন, “একটি বয়াম নাও এবং তাতে এক ওমর মান্না ভরে রাখো। পরে পরবর্তী প্রজন্মগুলির জন্য সেটি রক্ষা করে রাখার জন্য সদাপ্রভুর সামনে সাজিয়ে রাখো।” ");
INSERT INTO benobcv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","মোশিকে দেওয়া সদাপ্রভুর আদেশানুসারে, হারোণ বিধিনিয়মের ফলকগুলি সমেত সেই মান্না সাজিয়ে রাখলেন, যেন তা সংরক্ষিত থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ইস্রায়েলীরা যতদিন না স্থায়ী এক দেশে এল, ততদিন চল্লিশ বছর ধরে মান্না খেয়েছিল; কনানের সীমানায় পৌঁছানো পর্যন্ত তারা মান্না খেয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(এক ওমর এক ঐফার এক-দশমাংশ।) ");
INSERT INTO benobcv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","সমগ্র ইস্রায়েলী জনসমাজ সদাপ্রভুর আদেশানুসারে এক স্থান থেকে আরেক স্থানে ভ্রমণ করতে করতে সীন মরুভূমি থেকে বের হয়ে এল। তারা রফীদীমে শিবির স্থাপন করল, কিন্তু সেখানে লোকজনের জন্য পানীয় জল ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","তাই তারা মোশির সঙ্গে ঝগড়া-বিবাদ করে বলল, “আমাদের পানীয় জল দাও।” মোশি উত্তর দিলেন, “তোমরা কেন আমার সঙ্গে ঝগড়া-বিবাদ করছ? তোমরা কেন সদাপ্রভুর পরীক্ষা নিচ্ছ?” ");
INSERT INTO benobcv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","কিন্তু লোকেরা সেখানে জলের জন্য তৃষ্ণার্ত হল এবং তারা মোশির বিরুদ্ধে অভিযোগ জানাল। তারা বলল, “কেন তুমি আমাদের ও আমাদের সন্তানসন্ততিকে এবং আমাদের গৃহপালিত পশুপালকে তৃষ্ণার্ত হয়ে মরে যাওয়ার জন্য মিশর থেকে বের করে এখানে নিয়ে এসেছ?” ");
INSERT INTO benobcv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","তখন মোশি সদাপ্রভুর কাছে কেঁদে বললেন, “এই লোকদের নিয়ে আমি কী করব? তারা তো প্রায় আমাকে পাথর মারার জন্য তৈরিই হয়ে আছে।” ");
INSERT INTO benobcv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","সদাপ্রভু মোশিকে উত্তর দিলেন, “লোকদের সামনে চলে যাও। ইস্রায়েলের কয়েকজন প্রাচীনকে তোমার সাথে নাও ও তোমার সেই ছড়িটি হাতে তুলে নাও, যেটি দিয়ে তুমি নীলনদে আঘাত করেছিলে, এবং যাও। ");
INSERT INTO benobcv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","আমি সেখানে তোমার সামনে হোরেবে শিলাপাথরের পাশে গিয়ে দাঁড়াব। সেই শিলাপাথরে আঘাত করো, এবং লোকজনের জন্য সেখান থেকে পানীয় জল বেরিয়ে আসবে।” অতএব মোশি ইস্রায়েলের প্রাচীনদের চোখের সামনে তা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","আর তিনি সেই স্থানটির নাম দিলেন মঃসা ও মরীবা কারণ ইস্রায়েলীরা ঝগড়া-বিবাদ করেছিল এবং তারা এই বলে সদাপ্রভুর পরীক্ষা নিয়েছিল, “সদাপ্রভু আমাদের মাঝে আছেন কি নেই?” ");
INSERT INTO benobcv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","অমালেকীয়রা রফীদীমে এসে ইস্রায়েলীদের আক্রমণ করল। ");
INSERT INTO benobcv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","মোশি যিহোশূয়কে বললেন, “আমাদের কয়েকজন লোককে মনোনীত করো এবং অমালেকীয়দের সাথে যুদ্ধ করতে যাও। আগামীকাল আমি ঈশ্বরের সেই ছড়িটি হাতে নিয়ে পাহাড়ের উপরে দাঁড়াব।” ");
INSERT INTO benobcv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","অতএব যিহোশূয় মোশির আদেশানুসারে অমালেকীয়দের সাথে যুদ্ধ করলেন, এবং মোশি, হারোণ ও হূর পাহাড়ের উপরে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","যতক্ষণ মোশি তাঁর হাত দুটি উপরে উঠিয়ে রেখেছিলেন, ইস্রায়েলীরা জিতছিল, কিন্তু যখনই তিনি তাঁর হাত দুটি নিচে নামাচ্ছিলেন, অমালেকীয়রা জিতছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","মোশির হাত দুটি যখন অবসন্ন হয়ে গেল, তখন তাঁরা একটি পাথর নিলেন ও সেটি তাঁর নিচে রেখে দিলেন এবং তিনি সেটির উপর বসে পড়লেন। হারোণ ও হূর তাঁর হাত দুটি—একজন একদিকে, অন্যজন অন্যদিকে—তুলে ধরে রাখলেন, যেন সূর্যাস্ত পর্যন্ত তাঁর হাত দুটি অবিচলিত থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","অতএব যিহোশূয় তরোয়াল দিয়ে অমালেকীয় সৈন্যদলকে পরাস্ত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","পরে সদাপ্রভু মোশিকে বললেন, “স্মরণযোগ্য করে রাখার জন্য এটি একটি গোটানো চামড়ার পুঁথিতে লিখে রাখো এবং নিশ্চিত কোরো যেন যিহোশূয় তা শোনে, কারণ আকাশের নিচ থেকে অমালেকের নাম আমি পুরোপুরি মুছে ফেলব।” ");
INSERT INTO benobcv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","মোশি একটি যজ্ঞবেদি নির্মাণ করলেন ও সেটির নাম রাখলেন “সদাপ্রভু আমার নিশান।” ");
INSERT INTO benobcv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","তিনি বললেন, “যেহেতু সদাপ্রভুর সিংহাসনের বিরুদ্ধে হাত উঠেছিল, তাই প্রজন্মের পর প্রজন্ম ধরে সদাপ্রভু অমালেকীয়দের বিরুদ্ধে যুদ্ধ করে যাবেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ঈশ্বর মোশির ও তাঁর প্রজাদের জন্য যা যা করলেন, এবং কীভাবে সদাপ্রভু ইস্রায়েলকে মিশর থেকে বের করে এনেছিলেন, সেসব কথা মিদিয়নীয় যাজক তথা মোশির শ্বশুরমশাই যিথ্রো শুনেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","মোশি তাঁর স্ত্রী সিপ্পোরাকে পাঠিয়ে দেওয়ার পর, তাঁর শ্বশুরমশাই যিথ্রো সিপ্পোরাকে, ");
INSERT INTO benobcv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","এবং তাঁর দুই ছেলেকে গ্রহণ করলেন। এক ছেলের নাম রাখা হল গের্শোম, কারণ মোশি বললেন, “আমি বিদেশে এক বিদেশি হয়ে গিয়েছি” ");
INSERT INTO benobcv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","আর অন্যজনের নাম রাখা হল ইলীয়েষর, কারণ তিনি বললেন, “আমার পৈত্রিক ঈশ্বর আমার সাহায্যকারী হয়েছেন; তিনি আমাকে ফরৌণের তরোয়ালের হাত থেকে রক্ষা করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","মোশির শ্বশুরমশাই যিথ্রো, মোশির ছেলেদের ও স্ত্রীকে নিয়ে সেই মরুভূমিতে তাঁর কাছে এলেন, যেখানে ঈশ্বরের পর্বতের কাছে তিনি শিবির স্থাপন করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","যিথ্রো তাঁর কাছে এই কথা বলে পাঠালেন, “আমি, তোমার শ্বশুর যিথ্রো, তোমার স্ত্রী ও তার দুই ছেলেকে সঙ্গে নিয়ে তোমার কাছে আসছি।” ");
INSERT INTO benobcv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","অতএব মোশি তাঁর শ্বশুরমশাই-এর সাথে দেখা করার জন্য বাইরে গেলেন এবং প্রণত হয়ে তাঁকে চুমু দিলেন। তাঁরা পরস্পরকে অভিবাদন জানালেন ও পরে তাঁবুর ভিতরে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ইস্রায়েলের জন্য সদাপ্রভু ফরৌণের ও মিশরীয়দের প্রতি যা যা করেছিলেন এবং পথিমধ্যে যেসব কষ্ট তাঁদের সহ্য করতে হয়েছিল ও সদাপ্রভু কীভাবে তাঁদের রক্ষা করেছিলেন, সেসব কথা মোশি তাঁর শ্বশুরমশাইকে বলে শোনালেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","মিশরীয়দের হাত থেকে ইস্রায়েলীদের রক্ষা করতে গিয়ে সদাপ্রভু ইস্রায়েলের জন্য যেসব ভালো ভালো কাজ করেছিলেন, তার বৃত্তান্ত শুনে যিথ্রো খুব খুশি হলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","তিনি বললেন, “সেই সদাপ্রভুর প্রশংসা হোক, যিনি মিশরীয়দের ও ফরৌণের হাত থেকে তোমাদের রক্ষা করেছেন এবং যিনি মানুষজনকে মিশরীয়দের হাত থেকে রক্ষা করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","এখন আমি জানলাম যে সদাপ্রভু অন্য সব দেবতার চেয়ে মহত্তর, কারণ তিনি তাদেরই প্রতি এরকম করেছেন, যারা ইস্রায়েলের প্রতি অহংকারী আচরণ দেখিয়েছিল।” ");
INSERT INTO benobcv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","পরে মোশির শ্বশুরমশাই যিথ্রো, সদাপ্রভুর কাছে এক হোমবলি ও অন্যান্য নৈবেদ্য নিয়ে আসলেন, এবং হারোণ ইস্রায়েলের সব প্রাচীনকে সঙ্গে নিয়ে ঈশ্বরের উপস্থিতিতে মোশির শ্বশুরমশাই যিথ্রোর সঙ্গে এক ভোজ খেতে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","পরদিন মোশি লোকদের বিচারক হয়ে তাঁর আসন গ্রহণ করলেন, এবং সকাল থেকে সন্ধ্যা পর্যন্ত লোকেরা তাঁর চারপাশে দাঁড়িয়ে থাকল। ");
INSERT INTO benobcv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","মোশি লোকজনের জন্য যা কিছু করছিলেন, তাঁর শ্বশুরমশাই যখন সেসবকিছু দেখলেন, তখন তিনি বললেন, “লোকজনের জন্য তুমি এ কী করছ? একা তুমিই কেন বিচারক হয়ে বসে আছ, যখন এইসব লোক সকাল থেকে সন্ধ্যা পর্যন্ত তোমার চারপাশে দাঁড়িয়ে আছে?” ");
INSERT INTO benobcv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","মোশি তাঁকে উত্তর দিলেন, “কারণ লোকেরা ঈশ্বরের ইচ্ছার খোঁজ নেওয়ার জন্য আমার কাছে আসে। ");
INSERT INTO benobcv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","যখনই তারা এক দ্বন্দ্বের সম্মুখীন হয়, তা আমার কাছে আনা হয়, এবং আমি দুই দলের মধ্যে মীমাংসা করি এবং ঐশ্বরিক হুকুমাদি ও নির্দেশাবলি তাদের জানিয়ে দিই।” ");
INSERT INTO benobcv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","মোশির শ্বশুরমশাই তাঁকে উত্তর দিলেন, “তুমি যা করছ তা ঠিক নয়। ");
INSERT INTO benobcv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","তুমি ও এই যেসব লোক তোমার কাছে আসছে, তোমরা সবাই অবসন্ন হয়ে পড়বে। তোমার পক্ষে এ কাজটি অত্যন্ত গুরুভার; একা তুমি এটি সামলাতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","এখন আমার কথা শোনো ও আমি তোমাকে কিছু পরামর্শ দেব, এবং ঈশ্বর তোমার সহবর্তী হোন। তোমাকে অবশ্যই ঈশ্বরের সামনে লোকজনের প্রতিনিধি হতে হবে এবং তাঁর কাছে তাদের দ্বন্দ্বগুলি নিয়ে আসতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","তাঁর হুকুমাদি ও নির্দেশাবলি তাদের শিক্ষা দাও, এবং তাদের দেখিয়ে দাও কীভাবে তাদের জীবনযাপন করতে হবে ও তাদের কেমন আচরণ করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","কিন্তু সব লোকজনের মধ্যে থেকে যোগ্য লোকদের মনোনীত করো—যারা ঈশ্বরকে ভয় করে, বিশ্বস্ত এমন সব লোক যারা অসাধু মুনাফা ঘৃণা করে—এবং কয়েক হাজার, কয়েকশো, পঞ্চাশ-পঞ্চাশ ও দশ-দশ জনের উপর তাদের কর্মকর্তারূপে নিযুক্ত করো। ");
INSERT INTO benobcv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","সবসময় এদেরই লোকজনের বিচারক হয়ে থাকতে দিয়ো, কিন্তু প্রত্যেকটি দুরূহ মামলা তাদের তোমার কাছে আনতে দিয়ো; সহজ মামলাগুলির নিষ্পত্তি তারা নিজেরাই করে নিতে পারবে। এতে তোমার বোঝা হালকা হয়ে যাবে, কারণ তারা তোমার সঙ্গে তা ভাগাভাগি করে নেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","তুমি যদি এরকম করো ও ঈশ্বরও যদি এরকম আদেশ দেন, তবে তুমি ধকলটি সামলাতে সক্ষম হবে, এবং এইসব লোক তৃপ্ত হয়ে ঘরে ফিরে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","মোশি তাঁর শ্বশুরমশাই যিথ্রোর কথা শুনলেন এবং তিনি যা যা করতে বললেন সেসবকিছু করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","সমগ্র ইস্রায়েলের মধ্যে থেকে তিনি যোগ্য লোকদের মনোনীত করলেন এবং লোকজনের নেতারূপে, কয়েক হাজার, কয়েকশো, পঞ্চাশ-পঞ্চাশ ও দশ-দশ জনের উপর কর্মকর্তারূপে তাঁদের নিযুক্ত করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","সবসময় তাঁরা লোকজনের জন্য বিচারক হয়ে বিচার করতেন। দুরূহ মামলাগুলি তাঁরা মোশির কাছে আনতেন, কিন্তু সহজ মামলাগুলির নিষ্পত্তি তাঁরা নিজেরাই করতেন। ");
INSERT INTO benobcv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","পরে মোশি তাঁর শ্বশুরমশাইকে বিদায় দিলেন, এবং যিথ্রো তাঁর নিজের দেশে ফিরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ইস্রায়েলীরা মিশর ছেড়ে বেরিয়ে আসার পর তৃতীয় মাসের প্রথম দিনে—ঠিক সেদিনই—তারা সীনয় মরুভূমিতে এসেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","রফীদীম থেকে যাত্রা শুরু করার পর, তারা সীনয় মরুভূমিতে প্রবেশ করল, এবং পর্বতের সামনের দিকে ইস্রায়েল সেখানে মরুভূমিতে শিবির স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","পরে মোশি ঈশ্বরের কাছে উঠে গেলেন এবং সদাপ্রভু পর্বত থেকে তাঁকে ডাক দিয়ে বললেন, “যাকোবের বংশধরদের কাছে এবং ইস্রায়েলের লোকজনের কাছে তোমাকে একথাই বলতে হবে: ");
INSERT INTO benobcv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘তোমরা নিজেরাই তো দেখেছ আমি মিশরের প্রতি কী করেছিলাম, এবং কীভাবে আমি তোমাদের ঈগলের ডানায় তুলে বহন করেছিলাম ও তোমাদের নিজের কাছে এনেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","এখন তোমরা যদি পুরোপুরি আমার বাধ্য হও ও আমার নিয়ম পালন করো, তবে সব জাতির মধ্যে তোমরাই আমার নিজস্ব সম্পত্তি হবে। যদিও সমগ্র পৃথিবীই আমার, ");
INSERT INTO benobcv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","তোমরা আমার জন্য যাজকদের এক রাজ্য এবং পবিত্র এক জাতি হবে।’ ইস্রায়েলীদের কাছে তোমাকে এইসব কথা বলতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","অতএব মোশি ফিরে গেলেন এবং লোকদের প্রাচীনদের ডেকে পাঠালেন ও সদাপ্রভু তাঁকে যা যা বলার আদেশ দিয়েছিলেন সেসব কথা তাঁদের সামনে পেশ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","লোকজন সবাই একসঙ্গে উত্তর দিল, “সদাপ্রভু যা যা বলেছেন আমরা সেসবকিছু করব।” অতএব মোশি তাদের উত্তর সদাপ্রভুর কাছে ফিরিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","সদাপ্রভু মোশিকে বললেন, “আমি এক ঘন মেঘে তোমার কাছে আসতে চলেছি, যেন লোকেরা শোনে যে আমি তোমার সঙ্গে কথা বলছি এবং তারা সবসময় তোমার উপর তাদের আস্থা স্থাপন করে।” লোকেরা কী বলেছিল তা তখন মোশি সদাপ্রভুকে বললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","আর সদাপ্রভু মোশিকে বললেন, “লোকদের কাছে যাও এবং আজ ও আগামীকাল তাদের পবিত্র করো। তারা তাদের জামাকাপড় ধুয়ে নিক ");
INSERT INTO benobcv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ও তৃতীয় দিনের জন্য প্রস্তুত থাকুক, কারণ সেদিনই সব লোকের চোখের সামনে সদাপ্রভু সীনয় পর্বতে নেমে আসবেন। ");
INSERT INTO benobcv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","পর্বতের চারপাশে লোকদের জন্য সীমানা নির্দিষ্ট করে দাও ও তাদের বলো, ‘সাবধান, তোমরা কেউ যেন পর্বতের কাছে না যাও বা এর পাদদেশ স্পর্শ না করো। যে কেউ পর্বত স্পর্শ করবে তাকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","তাদের পাথর ছুঁড়ে বা তির নিক্ষেপ করে হত্যা করতে হবে; তাদের উপর যেন কোনও হাত না পড়ে। কোনও মানুষ বা পশুকে বেঁচে থাকার অনুমতি দেওয়া হবে না।’ একমাত্র যখন শিঙার সুদীর্ঘ শব্দ শোনা যাবে, তখনই তারা পর্বতের কাছে আসতে পারবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","পর্বত থেকে মোশি নিচে ইস্রায়েলীদের কাছে নেমে আসার পর, তিনি তাদের পবিত্র করলেন, এবং তারা তাদের জামাকাপড় ধুয়ে নিল। ");
INSERT INTO benobcv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","পরে তিনি লোকদের বললেন, “তৃতীয় দিনের জন্য তোমরা নিজেদের প্রস্তুত করো। যৌন সম্পর্ক স্থাপন করা থেকে বিরত থাকো।” ");
INSERT INTO benobcv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","তৃতীয় দিন সকালবেলায় বজ্রপাত হল ও বিদ্যুৎ চমকাল, একইসাথে ঘন মেঘে পর্বত ঢেকে গেল ও খুব জোরে শিঙার শব্দ শোনা গেল। শিবিরের মধ্যে প্রত্যেকে কেঁপে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","তখন মোশি ঈশ্বরের সঙ্গে দেখা করার জন্য নেতৃত্ব দিয়ে লোকদের শিবির থেকে বের করে আনলেন, এবং তারা পর্বতের পাদদেশে এসে দাঁড়াল। ");
INSERT INTO benobcv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","সীনয় পর্বত ধোঁয়ায় ঢেকে গেল, কারণ সদাপ্রভু অগ্নিবেষ্টিত হয়ে পর্বতের উপর নেমে এলেন। অগ্নিকুণ্ড থেকে ওঠা ধোঁয়ার মতো সেই ধোঁয়া গলগল করে সেখান থেকে উপরে উঠে গেল, এবং সমগ্র পর্বত থরথর করে কেঁপে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","শিঙার শব্দ ক্রমশ জোরালো হল, মোশি কথা বললেন এবং ঈশ্বরের কণ্ঠস্বর তাঁকে উত্তর দিল। ");
INSERT INTO benobcv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","সদাপ্রভু সীনয় পর্বতের চূড়ায় নেমে এলেন এবং মোশিকে পর্বতের চূড়ায় ডেকে নিলেন। অতএব মোশি উপরে উঠে গেলেন ");
INSERT INTO benobcv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","এবং সদাপ্রভু তাঁকে বললেন, “নিচে নেমে যাও ও লোকদের সাবধান করে দাও, পাছে তারা জোর করে সদাপ্রভুকে দেখতে যায় ও তাদের মধ্যে অনেকে প্রাণ হারায়। ");
INSERT INTO benobcv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","এমনকি যারা সদাপ্রভুর নিকটবর্তী হয়, সেই যাজকরাও যেন নিজেদের পবিত্র করে, তা না হলে সদাপ্রভু তাদের বিরুদ্ধে সহসা আবির্ভূত হবেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","মোশি সদাপ্রভুকে বললেন, “লোকেরা সীনয় পর্বতে উঠে আসতে পারবে না, কারণ তুমি নিজেই আমাদের সাবধান করে দিয়েছ, ‘পর্বতের চারপাশে সীমানা নির্দিষ্ট করে রাখো এবং সেটিকে পবিত্রতায় পৃথক করে রাখো।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","সদাপ্রভু উত্তর দিলেন, “নিচে নেমে যাও এবং হারোণকে তোমার সঙ্গে নিয়ে উপরে উঠে এসো। কিন্তু যাজকেরা ও লোকেরা যেন জোর করে সদাপ্রভুর কাছে উঠে আসার চেষ্টা না করে, তা না হলে তিনি তাদের বিরুদ্ধে সহসা আবির্ভূত হবেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","অতএব মোশি নিচে লোকদের কাছে নেমে গেলেন এবং তাদের এসব কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","আর ঈশ্বর এইসব কথা বললেন: ");
INSERT INTO benobcv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“আমিই তোমার ঈশ্বর সেই সদাপ্রভু, যিনি তোমাকে মিশর থেকে, ক্রীতদাসত্বের সেই দেশ থেকে বের করে এনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“আমার সামনে তুমি অন্য কোনও দেবতা রাখবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","নিজের জন্য তুমি ঊর্ধ্বস্থ স্বর্গের বা অধঃস্থ পৃথিবীর বা জলরাশির তলার কোনো কিছুর আকৃতিবিশিষ্ট কোনও প্রতিমা তৈরি করবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","তুমি তাদের কাছে মাথা নত করবে না বা তাদের আরাধনা করবে না; কারণ আমি, তোমার ঈশ্বর সদাপ্রভু, এক ঈর্ষান্বিত ঈশ্বর, বাবা-মার করা পাপের কারণে সন্তানদের শাস্তি দিই, যারা আমাকে ঘৃণা করে তাদের তৃতীয় ও চতুর্থ প্রজন্ম পর্যন্ত দিই, ");
INSERT INTO benobcv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","কিন্তু যারা আমাকে ভালোবাসে ও আমার আজ্ঞাগুলি পালন করে, হাজার প্রজন্ম পর্যন্ত তাদের প্রতি ভালোবাসা দেখাই। ");
INSERT INTO benobcv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","তোমার ঈশ্বর সদাপ্রভুর নামের অপব্যবহার কোরো না, কারণ যে কেউ তাঁর নামের অপব্যবহার করে সদাপ্রভু তাকে নির্দোষ প্রতিপন্ন করবেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","পবিত্রতায় বিশ্রামদিন পালন করে স্মরণ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ছয় দিন তুমি পরিশ্রম করবে ও তোমার সব কাজকর্ম করবে, ");
INSERT INTO benobcv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","কিন্তু সপ্তম দিনটি তোমার ঈশ্বর সদাপ্রভুর উদ্দেশে বিশ্রামদিন। সেদিন তুমি, তোমার ছেলে বা মেয়ে, তোমার দাস বা দাসী, তোমার পশুপাল, বা তোমার নগরে বসবাসকারী কোনো বিদেশি, কেউ কোনও কাজ কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","কারণ ছয় দিনে সদাপ্রভু আকাশমণ্ডল ও পৃথিবী, সমুদ্র ও সেগুলির মধ্যে থাকা সমস্ত কিছু তৈরি করেছিলেন, কিন্তু সপ্তম দিন তিনি বিশ্রাম নিয়েছিলেন। তাই সদাপ্রভু সাব্বাথবারকে আশীর্বাদ করে সেটি পবিত্র করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","তোমার বাবাকে ও তোমার মাকে সম্মান কোরো, যেন তুমি সেই দেশে দীর্ঘকাল বেঁচে থাকতে পারো, যে দেশ তোমার ঈশ্বর সদাপ্রভু তোমাকে দিচ্ছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","তুমি নরহত্যা কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","তুমি ব্যভিচার কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","তুমি চুরি কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","তুমি তোমার প্রতিবেশীর বিরুদ্ধে মিথ্যা সাক্ষ্য দিয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","তুমি তোমার প্রতিবেশীর ঘরবাড়ির প্রতি লোভ কোরো না। তুমি তোমার প্রতিবেশীর স্ত্রীর, বা তার দাস বা দাসীর, তার বলদের বা গাধার, বা তোমার প্রতিবেশীর অধিকারভুক্ত কোনো কিছুর প্রতি লোভ কোরো না।” ");
INSERT INTO benobcv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","যখন লোকেরা বজ্রপাত হতে ও বিদ্যুৎ চমকাতে দেখল এবং শিঙার শব্দ শুনল ও পর্বত ধোঁয়ায় ঢেকে যেতে দেখল, তখন তারা ভয়ে কেঁপে উঠল। তারা দূরে দাঁড়িয়ে পড়ল ");
INSERT INTO benobcv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","এবং মোশিকে বলল, “আপনি নিজেই আমাদের সঙ্গে কথা বলুন ও আমরা তা শুনব। কিন্তু ঈশ্বর যেন আমাদের সঙ্গে কথা না বলেন পাছে আমরা মারা যাই।” ");
INSERT INTO benobcv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","মোশি লোকদের বললেন, “ভয় পেয়ো না। ঈশ্বর তোমাদের পরীক্ষা করতে এসেছেন, যেন পাপ করা থেকে তোমাদের বিরত রাখার জন্য ঈশ্বরভয় তোমাদের সহবর্তী হয়।” ");
INSERT INTO benobcv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","লোকেরা দূরে দাঁড়িয়ে থাকল, আর মোশি সেই ঘন অন্ধকারের দিকে এগিয়ে গেলেন যেখানে ঈশ্বর উপস্থিত ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","তখন সদাপ্রভু মোশিকে বললেন, “ইস্রায়েলীদের একথা বলো: ‘তোমরা নিজেরাই দেখলে যে আমি স্বর্গ থেকে তোমাদের সঙ্গে কথা বলেছি: ");
INSERT INTO benobcv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","আমার পাশাপাশি রাখার জন্য অন্য কোনও দেবতা তৈরি কোরো না; নিজেদের জন্য রুপোর দেবতা বা সোনার দেবতা তৈরি কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘আমার জন্য মাটি দিয়ে একটি যজ্ঞবেদি তৈরি করো এবং সেটির উপর তোমাদের হোমবলি ও মঙ্গলার্থক বলি উৎসর্গ করো, মেষ ও ছাগল, ও তোমাদের গবাদি পশুপাল বলি দাও। আমি যেখানেই আমার নাম সম্মানিত করব, সেখানেই আমি তোমাদের কাছে আসব এবং তোমাদের আশীর্বাদ করব। ");
INSERT INTO benobcv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","তোমরা যদি আমার জন্য পাথরের এক যজ্ঞবেদি তৈরি করো, তবে খোদিত পাথর দিয়ে তা নির্মাণ কোরো না, কারণ যদি সেটিতে যন্ত্রপাতি ব্যবহার করো তবে তোমরা সেটি অশুচি করে তুলবে। ");
INSERT INTO benobcv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","আর সিঁড়ির ধাপ বেয়ে আমার যজ্ঞবেদিতে উঠো না, পাছে তোমাদের গোপনাঙ্গগুলি অনাবৃত হয়ে যায়।’ ");
INSERT INTO benobcv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“এগুলি সেই বিধিবিধান যা তোমাকে তাদের সামনে রাখতে হবে: ");
INSERT INTO benobcv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“যদি তুমি কোনও হিব্রু দাসকে কিনে এনেছ, তবে সে ছয় বছর তোমার সেবা করুক। কিন্তু সপ্তম বছরে, সে স্বাধীন হয়ে চলে যাবে, তাকে কোনও অর্থ খরচ করতে হবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","সে যদি একা এসেছে, তবে সে একাই স্বাধীন হয়ে চলে যাক; কিন্তু আসার সময় যদি তার স্ত্রী তার সঙ্গে ছিল, তবে সেও তার সঙ্গে যাক। ");
INSERT INTO benobcv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","তার মালিক যদি তাকে এক স্ত্রী দেন এবং সেই স্ত্রী তার জন্য ছেলে বা মেয়েদের জন্ম দেয়, তবে সেই মহিলা ও তার সন্তানেরা তার মালিকের অধিকারভুক্ত হবে, এবং শুধু সেই পুরুষটিই স্বাধীন হয়ে চলে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“কিন্তু সেই দাস যদি ঘোষণা করে, ‘আমি আমার মালিককে ও আমার স্ত্রী ও সন্তানদের ভালোবাসি এবং স্বাধীন হয়ে চলে যেতে চাই না,’ ");
INSERT INTO benobcv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","তবে তার মালিক অবশ্যই তাকে ঈশ্বরের সামনে নিয়ে যাবেন। মালিক তাকে দরজার কাছে বা দরজার চৌকাঠের কাছে নিয়ে যাবেন এবং একটি কাঁটা দিয়ে তার কান বিদীর্ণ করে দেবেন। তখন সে সারা জীবনের জন্য তাঁর দাস হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“যদি কোনও লোক তার মেয়েকে এক দাসীরূপে বিক্রি করে দেয়, তবে সে দাসের মতো স্বাধীন হয়ে চলে যেতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","সে যদি তার সেই মালিককে সন্তুষ্ট করতে না পারে, যিনি তাকে নিজের জন্য পছন্দ করেছিলেন, তবে তিনি যেন অবশ্যই তাকে মুক্ত করে দেন। তাকে বিদেশিদের কাছে বিক্রি করার তাঁর কোনও অধিকার নেই, কারণ তিনি তার প্রতি বিশ্বাসঘাতকতা করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","সেই মালিক যদি তাকে নিজের ছেলের জন্য পছন্দ করেছেন, তবে তিনি যেন অবশ্যই তাকে এক মেয়ের অধিকার দেন। ");
INSERT INTO benobcv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","তিনি যদি অন্য কোনও মহিলাকে বিয়ে করেন, তবে তিনি যেন অবশ্যই প্রথমজনকে তার খাদ্য, বস্ত্র ও দাম্পত্য অধিকার থেকে বঞ্চিত না করেন। ");
INSERT INTO benobcv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","তিনি যদি তার প্রতি এই তিনটি কর্তব্য পালন না করেন, তবে সেই স্ত্রী কোনও অর্থ খরচ না করে, স্বাধীন হয়ে ফিরে যেতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“যে কেউ অন্য কাউকে মারাত্মক এক ঘা দিয়ে জখম করে, তাকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","অবশ্য, তা যদি ইচ্ছাকৃতভাবে করা না হয়, কিন্তু ঈশ্বরই তা হতে দিয়েছেন, তবে তাকে এমন এক স্থানে পালিয়ে যেতে হবে যা আমি নির্দিষ্ট করে দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","কিন্তু কেউ যদি চক্রান্ত করে কাউকে ইচ্ছাকৃতভাবে হত্যা করে, তবে সেই লোকটিকে আমার যজ্ঞবেদি থেকে সরিয়ে নিয়ে গিয়ে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“যে কেউ তার বাবা বা মাকে আক্রমণ করে, তাকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“যে কেউ অন্য কাউকে অপহরণ করে সেই অপহৃত লোকটিকে বিক্রি করে দেয় বা তাকে নিজের দখলে রাখে, তবে সেই অপহরণকারীকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“যে কেউ তার বাবা বা মাকে অভিশাপ দেয়, তাকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“যদি মানুষজন ঝগড়া-বিবাদ করতে করতে একজন অন্যজনকে পাথর দিয়ে আঘাত করে বা তাদের মুষ্টাঘাত করে এবং সেই আঘাতপ্রাপ্ত লোকটি মারা না যায় কিন্তু শয্যাশায়ী হয়, ও ");
INSERT INTO benobcv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","সে যদি উঠে একটি ছড়ি ধরে বাইরে এদিক-ওদিক ঘোরাঘুরি করতে পারে, তবে যে আঘাত করল তাকে দায়ী করা হবে না; অবশ্য, সেই দোষী লোকটিকে সময়ের ক্ষতিপূরণস্বরূপ সেই আহত লোকটির জন্য খরচপত্র দিতে হবে এবং যতদিন না সে পুরোপুরি সুস্থ হচ্ছে ততদিন তার দেখাশোনা করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“যদি কেউ তার ক্রীতদাস বা ক্রীতদাসীকে একটি লাঠি দিয়ে মারে ও এর প্রত্যক্ষ ফলস্বরূপ সে যদি মারা যায় তবে অবশ্যই তাকে শাস্তি দিতে হবে, ");
INSERT INTO benobcv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","কিন্তু যদি সেই ক্রীতদাস বা দাসী দুই একদিন পর সুস্থ হয়ে ওঠে তবে তাকে শাস্তি দেওয়া যাবে না, যেহেতু সেই ক্রীতদাস বা দাসী তারই সম্পত্তি। ");
INSERT INTO benobcv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“যদি লোকজন মারামারি করার সময় কোনও গর্ভবতী মহিলাকে আঘাত করে ও সে অকালে সন্তানের জন্ম দেয় কিন্তু বড়ো ধরনের আঘাত না পায়, তবে সেই মহিলার স্বামী যা দাবি করবে এবং আদালত যেমনটি অনুমতি দেবে সেইমতোই অবশ্য অপরাধীর জরিমানা ধার্য করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","কিন্তু সেই মহিলাটি যদি বড়ো ধরনের আঘাত পায়, তবে তোমাদের প্রাণের পরিবর্তে প্রাণ, ");
INSERT INTO benobcv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","চোখের পরিবর্তে চোখ, দাঁতের পরিবর্তে দাঁত, হাতের পরিবর্তে হাত, পায়ের পরিবর্তে পা, ");
INSERT INTO benobcv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","দহনের পরিবর্তে দহন, ক্ষতের পরিবর্তে ক্ষত, কালশিটের পরিবর্তে কালশিটে আদায় করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“যে মালিক তাঁর ক্রীতদাস বা ক্রীতদাসীর চোখে আঘাত করে তা নষ্ট করে দেন, তাঁকে অবশ্যই সেই চোখের ক্ষতিপূরণ করার জন্য সেই ক্রীতদাস বা দাসীকে স্বাধীন করে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","আর যে মালিক মেরে ক্রীতদাস বা ক্রীতদাসীর দাঁত উপড়ে ফেলেন, তাঁকে অবশ্যই সেই দাঁতের ক্ষতিপূরণ করার জন্য সেই ক্রীতদাস বা দাসীকে স্বাধীন করে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“একটি বলদ যদি ঢুঁ মেরে কোনও পুরুষ বা মহিলাকে মেরে ফেলে, তবে সেই বলদটিকে পাথর ছুঁড়ে মেরে ফেলতে হবে, এবং সেটির মাংস অবশ্যই খাওয়া যাবে না। কিন্তু সেই বলদটির মালিক দোষী সাব্যস্ত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","অবশ্য যদি, সেই বলদটির ঢুঁ মারার অভ্যাস ছিল এবং সেই মালিককে সাবধান করে দেওয়া হয়েছিল কিন্তু সে সেটিকে খোঁয়াড়ে বেঁধে রাখেনি ও সেটি কোনও পুরুষ বা মহিলাকে মেরে ফেলেছে, তবে সেই বলদটিকে পাথর ছুঁড়ে মেরে ফেলতে হবে এবং সেটির মালিককেও মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","অবশ্য, যদি খরচপত্র দাবি করা হয়, তবে সেই মালিক দাবিমতো খরচপত্র দিয়ে তার প্রাণ মুক্ত করতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","সেই বলদটি যদি কোনও ছেলে বা মেয়েকে ঢুঁ মারে, সেক্ষেত্রেও একই নিয়ম প্রযোজ্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","সেই বলদটি যদি কোনও ক্রীতদাস বা ক্রীতদাসীকে ঢুঁ মারে, তবে সেই মালিককে অবশ্যই সেই ক্রীতদাস বা দাসীর মালিককে ত্রিশ শেকল রুপো দিতে হবে, এবং সেই বলদটিকে পাথর ছুঁড়ে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“যদি কেউ একটি খানাখন্দ অনাবৃত রাখে বা সেটি ঢেকে রাখতে ব্যর্থ হয় এবং কোনও বলদ বা কোনও গাধা সেটির মধ্যে পড়ে যায়, ");
INSERT INTO benobcv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","তবে যে সেই খন্দটি খুঁড়েছিল সে অবশ্যই সেই মালিককে ক্ষতিপূরণ দেবে ও পরিবর্তে মৃত পশুটি নিয়ে নেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“যদি কোনও লোকের বলদ অন্য কোনও লোকের বলদকে আহত করে ও সেটি মারা যায়, তবে দুই পক্ষই জীবিত বলদটিকে বিক্রি করবে এবং সেই অর্থ ও মৃত পশুটিকে সমপরিমাণে ভাগ করে নেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","অবশ্য, যদি জানা ছিল যে সেই বলদটির ঢুঁ মারার অভ্যাস ছিল, অথচ মালিক সেটিকে খোঁয়াড়ে বেঁধে রাখেনি, তবে সেই মালিক অবশ্যই পশুর জন্য পশু দেবে, এবং পরিবর্তে মৃত পশুটি নিয়ে নেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“যে কেউ একটি বলদ বা একটি মেষ চুরি করে সেটি জবাই করে বা বিক্রি করে দেয়, তবে তাকে অবশ্যই ক্ষতিপূরণস্বরূপ সেই বলদটির পরিবর্তে পাঁচটি গবাদি পশু ও সেই মেষটির পরিবর্তে চারটি মেষ দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“রাতের বেলায় যদি কোনও চোর চুরি করতে এসে ধরা পড়ে এবং মারাত্মক আঘাত পেয়ে মারা যায়, তবে রক্ষক রক্তপাতের দোষে দোষী হবে না; ");
INSERT INTO benobcv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","কিন্তু তা যদি সূর্যোদয়ের পর ঘটে, তবে সেই রক্ষক রক্তপাতের দোষে দোষী হবে। “যে কেউ চুরি করেছে, তাকে অবশ্যই ক্ষতিপূরণ দিতে হবে, কিন্তু তার কাছে যদি কিছুই না থাকে, তবে চৌর্যবৃত্তির ক্ষতিপূরণের জন্য তাকে অবশ্যই বিক্রীত হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","চুরি যাওয়া পশুটিকে যদি তার সম্পত্তির মধ্যে জীবিত অবস্থায় পাওয়া যায়—তা সে বলদ বা গাধা বা মেষ যাই হোক না কেন—তাকে অবশ্যই দ্বিগুণ অর্থ ফিরিয়ে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“কেউ যদি তার গৃহপালিত পশুপাল জমিতে বা দ্রাক্ষাক্ষেতে চরাতে নিয়ে যায় ও সেগুলি পথভ্রষ্ট হয়ে অন্য একজনের জমিতে চরতে চলে যায়, তবে সেই অপরাধীকে অবশ্যই তার নিজস্ব জমি বা দ্রাক্ষাক্ষেতের সেরা ফলন দিয়ে ক্ষতিপূরণ করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“যদি আগুন লেগে তা কাঁটাঝোপে এমনভাবে ছড়িয়ে পড়ে যে তা কাঁচা বা পাকা শস্য অথবা সমগ্র ক্ষেতজমি পুড়িয়ে ছারখার করে দেয়, তবে যে প্রথমে সেই আগুন লাগিয়েছিল, তাকেই ক্ষতিপূরণ করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“কেউ যদি তার প্রতিবেশীর কাছে রুপো বা সোনা গচ্ছিত রাখে এবং সেগুলি সেই প্রতিবেশীর বাড়ি থেকে চুরি হয়ে যায়, এবং চোর যদি ধরা পড়ে যায়, তবে তাকে অবশ্যই দ্বিগুণ ক্ষতিপূরণ দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","কিন্তু সেই চোরকে যদি খুঁজে পাওয়া না যায়, তবে সেই বাড়ির মালিককে বিচারকদের সামনে দাঁড়াতে হবে, এবং তাঁদেরই স্থির করতে হবে সেই বাড়ির মালিক সেই অন্যজনের সম্পত্তিতে হস্তক্ষেপ করেছে, কি না। ");
INSERT INTO benobcv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","বলদ, গাধা, মেষ, পোশাকের, বা অন্য যে কোনো হারিয়ে যাওয়া সম্পত্তির বিষয়ে যদি কেউ বলে, ‘এটি আমার,’ সেগুলির অবৈধ দখলদারির সব ক্ষেত্রে দুই পক্ষকেই তাদের মামলাগুলি বিচারকদের সামনে আনতে হবে। যাকে বিচারকেরা দোষী সাব্যস্ত করবেন, সেই অন্যজনকে দ্বিগুণ ক্ষতিপূরণ দেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“যদি কেউ তার প্রতিবেশীর কাছে গাধা, বলদ, মেষ বা অন্য কোনো পশু গচ্ছিত রাখে এবং সেটি মারা যায় বা আহত হয় বা মানুষের অগোচরে চুরি হয়ে যায়, ");
INSERT INTO benobcv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","তবে তাদের মধ্যে উৎপন্ন সমস্যাটির সমাধান হবে সদাপ্রভুর সামনে এই শপথ নেওয়ার মাধ্যমে, যে সেই প্রতিবেশী অন্যজনের সম্পত্তিতে হস্তক্ষেপ করেনি। মালিককে তা মেনে নিতে হবে, এবং কোনও ক্ষতিপূরণ দেওয়ার প্রয়োজন হবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","কিন্তু সেই পশুটি যদি সেই প্রতিবেশীর কাছ থেকে চুরি গিয়েছে, তবে তাকে মালিকের ক্ষতিপূরণ করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","সেটি যদি কোনও বন্যপশু দ্বারা বিদীর্ণ হয়েছে, তবে সেই প্রতিবেশী প্রমাণস্বরূপ সেটির দেহাবশেষ আনবে এবং সেই বিদীর্ণ পশুটির জন্য কোনও ক্ষতিপূরণ দিতে হবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“যদি কেউ তার প্রতিবেশীর কাছ থেকে কোনও পশু ধার নেয় এবং মালিকের অনুপস্থিতিতে সেটি আহত হয় বা মারা যায়, তবে তাকে অবশ্যই ক্ষতিপূরণ দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","কিন্তু মালিক যদি পশুটির সাথে থাকে, তবে তাকে ক্ষতিপূরণ দিতে হবে না। সেই পশুটি যদি ভাড়া নেওয়া হয়েছিল, তবে ভাড়াবাবদ দেওয়া অর্থেই ক্ষতিপূরণ হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“যদি কোনও লোক, যার বাগদান হয়নি এমন এক কুমারীর সতীত্ব হরণ করে ও তার সাথে শোয়, তবে সে অবশ্যই কন্যাপণ দেবে এবং সেই কুমারী তার স্ত্রী হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","সেই কুমারীর বাবা যদি তাকে তার হাতে তুলে দিতে নিছক অস্বীকার করে, তা হলেও, তাকে কুমারীদের জন্য ধার্য কন্যাপণ দিতেই হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“কোনও ডাকিনীকে বেঁচে থাকতে দিয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“যে কেউ পশুর সঙ্গে যৌন সম্পর্ক স্থাপন করে তাকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“যে কেউ সদাপ্রভু ছাড়া অন্য কোনো দেবতার কাছে বলি উৎসর্গ করে তাকে অবশ্যই ধ্বংস করে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“কোনও বিদেশির প্রতি মন্দ ব্যবহার বা জুলুম কোরো না, কারণ তোমরা মিশরে বিদেশিই ছিলে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“বিধবা বা অনাথদের দুর্বলতার সুযোগ নিয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","তোমরা যদি তা করো ও তারা আমার কাছে কেঁদে ওঠে, তবে আমি নিঃসন্দেহে তাদের কান্না শুনব। ");
INSERT INTO benobcv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","আমার ক্রোধ জাগ্রত হবে, এবং আমি তরোয়াল দিয়ে তোমাদের হত্যা করব; তোমাদের স্ত্রীরা বিধবা হয়ে যাবে ও তোমাদের সন্তানেরা পিতৃহীন হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“তুমি যদি তোমাদের মধ্যে বসবাসকারী আমার প্রজাদের মধ্যে অভাবগ্রস্ত কাউকে অর্থ ধার দাও, তবে তা এক ব্যবসায়িক চুক্তিরূপে গণ্য কোরো না; সুদ ধার্য কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","তোমার প্রতিবেশীর আলখাল্লাটি যদি তুমি বন্ধকরূপে নিয়েছ, তবে সূর্যাস্তের আগেই তা ফিরিয়ে দিয়ো, ");
INSERT INTO benobcv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","কারণ সেই আলখাল্লাটিই তোমার প্রতিবেশীর কাছে থাকা একমাত্র আচ্ছাদন। তারা আর কীসে শোবে? তারা যখন আমার কাছে কেঁদে উঠবে, আমি তা শুনব; কারণ আমি করুণাময়। ");
INSERT INTO benobcv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ঈশ্বরনিন্দা কোরো না বা তোমাদের লোকজনের শাসককে অভিশাপ দিয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“তোমার শস্যাগারে বা তোমাদের ভাঁটিতে অর্ঘ্য আটকে রেখো না। “তোমার ছেলেদের মধ্যে প্রথমজাতকে আমার হাতে অবশ্যই তুলে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","তোমার গবাদি পশুপালের ও তোমার মেষের ক্ষেত্রেও তুমি তাই কোরো। মায়েদের সাথে সেগুলি সাত দিন থাকুক, কিন্তু অষ্টম দিনে তুমি সেগুলি আমাকে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“তোমাদের আমার পবিত্র প্রজা হতে হবে। অতএব বুনো পশুদের দ্বারা বিদীর্ণ কোনও পশুর মাংস খেয়ো না; কুকুরদের কাছে তা ছুঁড়ে ফেলে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“মিথ্যা গুজব ছড়িয়ো না। এক বিদ্বেষপরায়ণ সাক্ষী হওয়ার দ্বারা কোনও দোষী লোককে সাহায্য কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“অন্যায় করার ক্ষেত্রে জনসাধারণের অনুগামী হোয়ো না। কোনো মামলায় তুমি যখন সাক্ষ্য দাও, তখন জনসাধারণের পক্ষ নিয়ে ন্যায়বিচার বিকৃত কোরো না, ");
INSERT INTO benobcv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","এবং কোনো মামলায় কোনও দরিদ্র লোকের প্রতি পক্ষপাতিত্ব কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“তোমার শত্রুর বলদ অথবা গাধাকে যদি তুমি পথভ্রষ্ট হয়ে চরতে দেখো, তবে নিঃসন্দেহে সেটি ফিরিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","যে তোমাকে ঘৃণা করে, এমন কোনও লোকের গাধাকে যদি তুমি সেটির ভারের তলায় চাপা পড়তে দেখো, তবে সেটিকে সেখানে পড়ে থাকতে দিয়ো না; তুমি নিঃসন্দেহে সেটিকে ভারমুক্ত হতে সাহায্য করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“তোমাদের মধ্যবর্তী দরিদ্র লোকজনের মামলায় তাদের প্রতি যেন ন্যায়বিচার অস্বীকার করা না হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","মিথ্যা দোষারোপ করা থেকে দূরে সরে থেকো এবং কোনও নির্দোষ বা সৎলোককে মৃত্যুর মুখে ঠেলে দিয়ো না, কারণ আমি সেই দোষীকে বেকসুর খালাস হতে দেব না। ");
INSERT INTO benobcv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“ঘুস নিয়ো না, কারণ যাদের দৃষ্টিশক্তি আছে, ঘুস তাদের অন্ধ করে তোলে এবং নির্দোষ লোকদের কথা পরিবর্তন করে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“কোনও বিদেশির উপর জোরজুলুম কোরো না; তোমরা নিজেরাই জানো বিদেশি হয়ে থাকতে কেমন লাগে, কারণ তোমরাও মিশরে বিদেশিই হয়ে ছিলে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ছয় বছর ধরে তুমি তোমার জমিতে বীজ বুনবে এবং শস্য কাটবে, ");
INSERT INTO benobcv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","কিন্তু সপ্তম বছরে সেই জমিটি অকর্ষিত ও অব্যবহৃত অবস্থায় পড়ে থাকতে দেবে। তখন তোমাদের লোকজনের মধ্যবর্তী দরিদ্র লোকেরা সেখান থেকে হয়তো খাদ্যশস্য পাবে, এবং যা অবশিষ্ট থেকে যাবে তা হয়তো বন্যপশুরা খেতে পারবে। তোমার দ্রাক্ষাক্ষেতের ও জলপাই বাগানের ক্ষেত্রেও তুমি তাই কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ছয় দিন তুমি কাজ কোরো, কিন্তু সপ্তম দিন কাজ কোরো না; যেন তোমার বলদ ও গাধা বিশ্রাম নিতে পারে, এবং তোমার পরিবারে জন্মানো ক্রীতদাস ও তোমাদের মধ্যে বসবাসকারী বিদেশি যেন চাঙ্গা থাকতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“আমি তোমাকে যা যা বলেছি সেসবকিছু করার ক্ষেত্রে সাবধান থেকো। অন্যান্য দেবতাদের নাম ধরে ডেকো না; তোমার মুখে যেন তাদের কথা শোনাও না যায়। ");
INSERT INTO benobcv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“বছরে তিনবার তোমাকে আমার উদ্দেশে উৎসব পালন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“খামিরবিহীন রুটির উৎসব উদ্‌যাপন কোরো; সাত দিন ধরে খামিরবিহীন রুটি খেয়ো, যেমনটি আমি তোমাকে আদেশ দিয়েছি। আবীব মাসের নির্দিষ্ট সময়ে এরকমটি কোরো, কারণ সেই মাসেই তোমরা মিশর থেকে বেরিয়ে এসেছিলে। “কেউ যেন খালি হাতে আমার সামনে এসে না দাঁড়ায়। ");
INSERT INTO benobcv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“তোমার জমিতে বোনা ফসলের প্রথম ফল দিয়ে শস্যচ্ছেদনের উৎসব উদ্‌যাপন কোরো। “বছর-শেষে, জমি থেকে যখন তুমি তোমার শস্য সংগ্রহ করবে, তখন শস্য সংগ্রহের উৎসব উদ্‌যাপন কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“বছরে তিনবার সব পুরুষকে সার্বভৌম সদাপ্রভুর সামনে এসে দাঁড়াতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“খামিরযুক্ত কোনো কিছু সমেত আমার উদ্দেশে বলির রক্ত উৎসর্গ কোরো না। “আমার উৎসব-বলির মেদ যেন সকাল পর্যন্ত রেখে দেওয়া না হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“তোমার জমির সেরা প্রথম ফলটি তোমার ঈশ্বর সদাপ্রভুর গৃহে নিয়ে এসো। “ছাগ-শিশুকে তার মায়ের দুধে রান্না কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“দেখো, পথে তোমাকে রক্ষা করার জন্য ও যে স্থানটি আমি তৈরি করে রেখেছি, সেখানে তোমাকে পৌঁছে দেওয়ার জন্য আমি তোমার আগে আগে এক দূত পাঠাচ্ছি। ");
INSERT INTO benobcv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","তাঁর কথায় মনোযোগ দিয়ো এবং তিনি যা কিছু বলেন তা শুনো। তাঁর বিরুদ্ধে বিদ্রোহ কোরো না; তিনি তোমার বিদ্রোহ ক্ষমা করবেন না, যেহেতু তাঁর মধ্যে আমার নাম আছে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","তিনি যা বলেন তা যদি তুমি সযত্নে শোনো এবং আমি যা কিছু বলি সেসব করো, তবে আমি তোমার শত্রুদের শত্রু হব ও যারা তোমার বিরোধিতা করে তাদের বিরোধিতা করব। ");
INSERT INTO benobcv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","আমার দূত তোমার আগে আগে যাবেন এবং ইমোরীয়, হিত্তীয়, পরিষীয়, কনানীয়, হিব্বীয়, ও যিবূষীয়দের দেশে তোমাকে নিয়ে আসবেন, এবং আমি তাদের নিশ্চিহ্ন করে ফেলব। ");
INSERT INTO benobcv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","তাদের দেবতাদের সামনে মাথা নত কোরো না বা তাদের আরাধনা কোরো না অথবা তাদের রীতিনীতি পালন কোরো না। তোমরা অবশ্যই তাদের ধ্বংস করবে এবং তাদের পুণ্য পাথরগুলি ভেঙে টুকরো টুকরো করে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","তোমার ঈশ্বর সদাপ্রভুর আরাধনা কোরো, এবং তাঁর আশীর্বাদ তোমার খাদ্যে ও জলে বজায় থাকবে। তোমার মধ্যে থেকে আমি সব রোগব্যাধি দূর করে দেব, ");
INSERT INTO benobcv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","এবং তোমার দেশে কারোর গর্ভপাত হবে না বা কেউ বন্ধ্যা থাকবে না। আমি তোমার আয়ুর পরিমাণ পূর্ণ করব। ");
INSERT INTO benobcv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“তোমার আগে আগে আমি আমার আতঙ্ক পাঠিয়ে দেব এবং যেসব জাতি তোমার সম্মুখীন হবে, তাদের প্রত্যেককে আমি বিশৃঙ্খল করে তুলব। তোমার সব শত্রুকে আমি পিছু ফিরে পালাতে বাধ্য করব। ");
INSERT INTO benobcv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","তোমার সামনে থেকে হিব্বীয়, কনানীয় ও হিত্তীয়দের তাড়িয়ে দেওয়ার জন্য আমি তোমার আগে আগে ভিমরুল পাঠিয়ে দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","কিন্তু এক বছরের মধ্যেই আমি তাদের তাড়িয়ে দেব না, কারণ দেশটি জনশূন্য হয়ে যাবে এবং বন্যপশুরা তোমার পক্ষে অত্যধিক বহুসংখ্যক হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","তোমার সামনে থেকে আমি তাদের একটু একটু করে তাড়িয়ে দেব, যতক্ষণ না পর্যন্ত তুমি সংখ্যায় যথেষ্ট পরিমাণে বেড়ে দেশের দখল নিতে পারছ। ");
INSERT INTO benobcv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“লোহিত সাগর থেকে ভূমধ্যসাগর পর্যন্ত, এবং মরুভূমি থেকে ইউফ্রেটিস নদী পর্যন্ত আমি তোমার সীমানা স্থাপন করব। যারা সেই দেশে বসবাস করে তাদের আমি তোমার হাতে তুলে দেব, এবং তোমার সামনে থেকে তুমি তাদের তাড়িয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","তাদের সঙ্গে বা তাদের দেবতাদের সঙ্গে কোনও নিয়ম স্থির কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","তোমার দেশে তাদের বসবাস করতে দিয়ো না, তা না হলে আমার বিরুদ্ধে তারা তোমাকে দিয়ে পাপ করাবে, কারণ তাদের দেবতাদের আরাধনা নিঃসন্দেহে তোমার পক্ষে এক ফাঁদ হয়ে উঠবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","পরে সদাপ্রভু মোশিকে বললেন, “তুমি ও হারোণ, নাদব, ও অবীহূ, এবং ইস্রায়েলের সত্তরজন প্রাচীন, তোমরা সদাপ্রভুর কাছে উঠে এসো। তোমরা একটু দূরে থেকেই আরাধনা করবে, ");
INSERT INTO benobcv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","কিন্তু মোশি একাই সদাপ্রভুর কাছে আসবে; অন্যেরা কাছাকাছি আসবে না। আর লোকেরাও যেন তার সঙ্গে উপরে উঠে না আসে।” ");
INSERT INTO benobcv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","মোশি যখন লোকদের কাছে গিয়ে সদাপ্রভুর সব কথা ও বিধি তাদের বলে শোনালেন, তখন তারা একস্বরে উত্তর দিল, “সদাপ্রভু যা যা বলেছেন, আমরা সেসবকিছু করব।” ");
INSERT INTO benobcv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","মোশি তখন সদাপ্রভু যা যা বলেছিলেন সেসবকিছু লিখে রাখলেন। পরদিন ভোরবেলায় মোশি ঘুম থেকে উঠলেন ও সেই পর্বতের পাদদেশে এক যজ্ঞবেদি নির্মাণ করলেন এবং ইস্রায়েলের বারো গোষ্ঠীর প্রতিনিধিত্বমূলক পাথরের বারোটি স্তম্ভ খাড়া করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","পরে তিনি ইস্রায়েলী যুবকদের পাঠালেন, এবং তারা হোমবলি উৎসর্গ করল ও মঙ্গলার্থক বলিরূপে সদাপ্রভুর উদ্দেশে এঁড়ে বাছুরগুলি উৎসর্গ করল। ");
INSERT INTO benobcv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","মোশি অর্ধেক পরিমাণ রক্ত নিয়ে তা গামলাগুলিতে রাখলেন, এবং বাকি অর্ধেকটি তিনি যজ্ঞবেদির উপর ছিটিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","পরে তিনি নিয়মের সেই গ্রন্থটি নিলেন এবং লোকদের কাছে তা পড়ে শোনালেন। তারা উত্তর দিল, “সদাপ্রভু যা যা বলেছেন আমরা সেসবকিছু করব; আমরা বাধ্য হব।” ");
INSERT INTO benobcv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","মোশি তখন সেই রক্ত নিলেন, লোকদের উপর তা ছিটিয়ে দিলেন এবং বললেন, “এ হল সেই নিয়মের রক্ত, যে নিয়মটি সদাপ্রভু এসব কথার আধারে তোমাদের সঙ্গে স্থির করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","মোশি ও হারোণ, নাদব ও অবীহূ এবং ইস্রায়েলের সেই সত্তরজন প্রাচীন উপরে উঠে গেলেন ");
INSERT INTO benobcv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","এবং ইস্রায়েলের ঈশ্বরের দর্শন পেলেন। তাঁর পায়ের তলায় আকাশের মতো উজ্জ্বল নীল রংয়ের নীলকান্তমণি দিয়ে তৈরি শান-বাঁধান মেঝের মতো কিছু একটা ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","কিন্তু ঈশ্বর ইস্রায়েলীদের এইসব নেতার বিরুদ্ধে তাঁর হাত ওঠাননি; তাঁরা ঈশ্বরের দর্শন পেলেন, এবং তাঁরা ভোজনপান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","সদাপ্রভু মোশিকে বললেন, “পর্বতে আমার কাছে উঠে এসো ও এখানে থাকো, এবং আমি তোমাকে সেই পাথরের ফলকগুলি দেব, যেগুলিতে আমি তাদের নির্দেশদানের উদ্দেশে বিধি ও আদেশগুলি লিখে রেখেছি।” ");
INSERT INTO benobcv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","তখন মোশি তাঁর সহায়ক যিহোশূয়কে সঙ্গে নিয়ে বেড়িয়ে পড়লেন, এবং মোশি ঈশ্বরের পর্বতে উঠে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","তিনি প্রাচীনদের বললেন, “যতক্ষণ না আমরা তোমাদের কাছে ফিরে আসছি, ততক্ষণ এখানে আমাদের জন্য অপেক্ষা করো। হারোণ ও হূর তোমাদের সঙ্গে আছেন, এবং যে কেউ কোনও বিবাদে জড়িয়ে পড়ে, সে তাদের কাছে যেতে পারে।” ");
INSERT INTO benobcv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","মোশি যখন পর্বতের উপরে চলে গেলেন, তখন তা মেঘে ঢেকে গেল, ");
INSERT INTO benobcv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","এবং সদাপ্রভুর গৌরব সীনয় পর্বতের উপর বসতি স্থাপন করল। ছয় দিন পর্বত মেঘে ঢাকা পড়ে গেল, এবং সপ্তম দিনে সদাপ্রভু মেঘের মধ্যে থেকে মোশিকে ডাক দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ইস্রায়েলীদের কাছে সদাপ্রভুর গৌরব পর্বতচূড়ায় অবস্থিত গ্রাসকারী এক আগুনের মতো দেখাচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","পরে মোশি পর্বতে চড়তে চড়তে সেই মেঘে প্রবেশ করলেন। আর সেই পর্বতের উপর তিনি চল্লিশ দিন ও চল্লিশ রাত থেকে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ইস্রায়েলীদের আমার কাছে এক নৈবেদ্য আনতে বলো। আমার জন্য তোমাকে সেই প্রত্যেকজনের কাছ থেকে নৈবেদ্য গ্রহণ করতে হবে যারা আন্তরিকভাবে দান দিতে ইচ্ছুক। ");
INSERT INTO benobcv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“এই নৈবেদ্যগুলি তোমাকে তাদের কাছ থেকে গ্রহণ করতে হবে: “সোনা, রুপো ও ব্রোঞ্জ; ");
INSERT INTO benobcv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","নীল, বেগুনি, ও টকটকে লাল রংয়ের সুতো এবং মিহি মসিনা; ছাগলের লোম; ");
INSERT INTO benobcv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","লাল রং করা মেষের ছাল এবং অন্য এক ধরনের টেকসই চামড়া; বাবলা কাঠ; ");
INSERT INTO benobcv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","আলোর জন্য জলপাই তেল; অভিষেক করার উপযোগী তেলের জন্য ও সুগন্ধি ধূপের জন্য মশলাপাতি; ");
INSERT INTO benobcv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","এবং এফোদ ও বুকপাটার উপরে বসানোর জন্য স্ফটিকমণি ও অন্যান্য মণিরত্ন। ");
INSERT INTO benobcv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“পরে আমার জন্য এক পবিত্রস্থান তৈরি করতে তাদের দিয়ো, এবং আমি তাদের মধ্যে বসবাস করব। ");
INSERT INTO benobcv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","আমি তোমাদের যে নমুনাটি দেখিয়ে দেব ঠিক সেই অনুসারেই এই সমাগম তাঁবু ও সেটির সব আসবাবপত্র তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“প্রায় 1.1 মিটার লম্বা এবং 68 সেন্টিমিটার করে চওড়া ও উঁচু বাবলা কাঠের একটি সিন্দুক তাদের তৈরি করতে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ভিতরে ও বাইরে, দুই দিকেই এটি খাঁটি সোনা দিয়ে মুড়ে দিয়ো, এবং এটির চারপাশে সোনার এক ছাঁচ তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","এটির জন্য সোনার চারটি কড়া ঢালাই কোরো এবং সেগুলি এটির চারটি পায়াতে আটকে দিয়ো, দুটি কড়া একদিকে ও দুটি কড়া অন্যদিকে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","পরে বাবলা কাঠের খুঁটিগুলি তৈরি কোরো এবং সেগুলি সোনা দিয়ে মুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","সিন্দুকটি বহন করার জন্য সেটির দুই পাশে থাকা কড়াগুলিতে সেই খুঁটিগুলি ঢুকিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","এই সিন্দুকের কড়ার মধ্যে যেন সেই খুঁটিগুলি থাকে; সেগুলি সরানো যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","পরে সেই সিন্দুকটিতে বিধিনিয়মের সেই ফলকগুলি রেখো, যেগুলি আমি তোমাদের দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“খাঁটি সোনা দিয়ে প্রায় 1.1 মিটার লম্বা এবং 68 সেন্টিমিটার চওড়া একটি প্রায়শ্চিত্ত-আচ্ছাদন তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","আর সেই আচ্ছাদনের শেষ প্রান্তের দিকে পিটানো সোনা দিয়ে দুটি করূব তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","একটি করূব এক প্রান্তে এবং দ্বিতীয়টি অন্য প্রান্তে তৈরি কোরো; দুই প্রান্তেই আবরণসহ একটি করে করূব তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","করূবেরা তাদের ডানা উপর দিকে ছড়িয়ে রেখে, সেই আবরণটির উপরে নিজেদের দেহ দিয়ে ছায়া ফেলবে। করূবেরা পরস্পরের দিকে মুখ করে, সেই আবরণের দিকে তাকিয়ে থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","আবরণটি সিন্দুকের চূড়ায় রাখবে এবং সিন্দুকে সেই বিধিনিয়মের ফলকগুলি রাখবে, যেগুলি আমি তোমাদের দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","সেখানে, সেই দুই করূবের মাঝখানে বিধিনিয়মের সিন্দুকের উপরে রাখা সেই আবরণের উপরেই আমি তোমার সঙ্গে দেখা করব ও ইস্রায়েলীদের জন্য তোমাকে আমার সমস্ত আজ্ঞা দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“বাবলা কাঠ দিয়ে প্রায় 90 সেন্টিমিটার লম্বা, 45 সেন্টিমিটার চওড়া ও 68 সেন্টিমিটার উঁচু একটি টেবিল তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","খাঁটি সোনা দিয়ে সেটি মুড়ে দিয়ো এবং সেটির চারপাশে সোনার এক ছাঁচ তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","এছাড়াও সেটির চারপাশে প্রায় 7.5 সেন্টিমিটার চওড়া চক্রবেড় তৈরি করে সেই চক্রবেড়ের উপর সোনার এক ছাঁচ রেখো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","টেবিলের জন্য সোনার চারটি কড়া তৈরি কোরো ও যেখানে সেই চারটি পায়া আছে, সেই চার প্রান্তে সেগুলি বেঁধে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","কড়াগুলি যেন সেই চক্রবেড়গুলির কাছাকাছি থাকে ও সেই টেবিলটি বহন করার উপযোগী খুঁটিগুলি যেন সেগুলি ধরে রাখতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","বাবলা কাঠ দিয়ে খুঁটিগুলি তৈরি কোরো, সেগুলি সোনা দিয়ে মুড়ে দিয়ো এবং সেগুলির সাথে সাথে টেবিলটিও বহন কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","আর খাঁটি সোনা দিয়ে এটির থালা ও বাসন, এছাড়াও নৈবেদ্য ঢেলে দেওয়ার জন্য এটির কলশি ও গামলাও তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","সবসময় আমার সামনে রাখার জন্য এই টেবিলে দর্শন-রুটি সাজিয়ে রেখো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“খাঁটি সোনার এক দীপাধার তৈরি কোরো। এটির ভিত ও দণ্ড পিটিয়ে নিতে হবে, এবং সেগুলির সাথে সাথে এতে একই টুকরো দিয়ে ফুলের মতো দেখতে পানপাত্র, কুঁড়ি ও মুকুলগুলিও তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","সেই দীপাধারের পাশ থেকে ছয়টি শাখা বেরিয়ে আসবে—একদিকে তিনটি এবং অন্যদিকে তিনটি। ");
INSERT INTO benobcv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","একটি শাখায় কুঁড়ি ও মুকুল সহ কাগজি বাদামের আকৃতিবিশিষ্ট তিনটি পানপাত্র থাকবে, পরবর্তী শাখাতে তিনটি, এবং সেই দীপাধার থেকে বেরিয়ে আসা ছয়টি শাখার সবকটিতে একইরকম হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","আর সেই দীপাধারে কুঁড়ি ও মুকুল সহ কাগজি বাদামফুলের মতো আকৃতিবিশিষ্ট চারটি পানপাত্র থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","সেই দীপাধার থেকে বেরিয়ে আসা মোট ছয়টি শাখার মধ্যে প্রথম জোড়া শাখার নিচে একটি কুঁড়ি থাকবে, দ্বিতীয় জোড়া শাখার নিচে দ্বিতীয় একটি কুঁড়ি থাকবে, এবং তৃতীয় জোড়ার নিচে তৃতীয় একটি কুঁড়ি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","সেই দীপাধারের সাথে একই টুকরো দিয়ে সেই কুঁড়ি ও শাখাগুলিও পিটানো খাঁটি সোনা দিয়ে তৈরি করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“পরে এর সাতটি প্রদীপ তৈরি কোরো ও সেগুলি সেটির উপর এমনভাবে সাজিয়ে রেখো যেন সেগুলি সেটির সামনের দিকের প্রাঙ্গণে আলো ফেলে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","এর পলতে ছাঁটার যন্ত্র ও বারকোশগুলিও খাঁটি সোনার হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","দীপাধার ও এইসব আনুষঙ্গিক উপকরণের জন্য এক তালন্ত খাঁটি সোনা ব্যবহার করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","দেখো, পর্বতের উপরে তোমাকে যে নকশা দেখানো হয়েছিল, সেই অনুযায়ী সবকিছু নির্মাণ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“একজন দক্ষ কারিগরকে দিয়ে মিহি পাকান মসিনা ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতোয় তৈরি দশটি পর্দায় করূবদের নকশা ফুটিয়ে তুলে সমাগম তাঁবুটি তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","সব পর্দা একই মাপের—13 মিটার লম্বা ও 1.8 মিটার চওড়া হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","পাঁচটি পর্দা একসঙ্গে জুড়ে দিয়ো, এবং অন্য পাঁচটির ক্ষেত্রেও একই কাজ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","এক পাটি পর্দায় এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত কিনারা ধরে ধরে নীল কাপড়ের ফাঁস তৈরি কোরো, এবং অন্য পাটি পর্দাতেও এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত একই কাজ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","একটি পর্দায় পঞ্চাশটি ফাঁস তৈরি কোরো এবং অন্য পাটি পর্দাতেও কিনারা ধরে ধরে পঞ্চাশটি ফাঁস তৈরি কোরো, যেন ফাঁসগুলি পরস্পরের বিপরীত দিকে থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","পরে সোনার পঞ্চাশটি আঁকড়া তৈরি কোরো এবং পর্দাগুলি একসঙ্গে সংলগ্ন করে রাখার জন্য সেগুলি ব্যবহার কোরো, যেন এক এককরূপে সমাগম তাঁবুটি অক্ষুণ্ণ থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“সমাগম তাঁবুটি ঢেকে রাখার জন্য ছাগ-লোমের পর্দা তৈরি কোরো—মোট এগারোটি। ");
INSERT INTO benobcv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","এগারোটি পর্দার সবগুলিই একই মাপের হবে—13.5 মিটার লম্বা ও 1.8 মিটার চওড়া। ");
INSERT INTO benobcv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","পাঁচটি পর্দা একসঙ্গে এক পাটিতে জুড়ে দিয়ো, এবং অন্য ছয়টি অন্য পাটিতে জুড়ে দিয়ো। ষষ্ঠ পর্দাটি দুই ভাঁজ করে তাঁবুর সামনের দিকে রেখে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","এক পাটি পর্দায় এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত কিনারা ধরে ধরে পঞ্চাশটি ফাঁস তৈরি কোরো এবং অন্য পাটি পর্দাতেও এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত তা কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","পরে ব্রোঞ্জের পঞ্চাশটি আঁকড়া তৈরি কোরো এবং এক এককরূপে একসঙ্গে তাঁবুটি বেঁধে রাখার জন্য সেগুলি ফাঁসগুলির মধ্যে আটকে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","তাঁবুর পর্দাগুলির বাড়তি দৈর্ঘ্যের ক্ষেত্রে, যে অর্ধেক পর্দাটি বাড়তি থেকে যাবে, সেটি সমাগম তাঁবুর পিছন দিকে ঝুলিয়ে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","তাঁবুর পর্দাগুলি দুই দিকেই 45 সেন্টিমিটার করে বেশি লম্বা হবে; যেটুকু বাড়তি থাকবে তা সমাগম তাঁবুটি ঢেকে রাখার জন্য তাঁবুর এপাশে ওপাশে ঝুলতে থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","তাঁবু ঢেকে রাখার জন্য মেষের চামড়া লাল রং করে, তা দিয়ে একটি আচ্ছাদন তৈরি কোরো, এবং সেটির উপর অন্য এক টেকসই চামড়া দিয়ে আরও একটি আচ্ছাদন তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“সমাগম তাঁবুর জন্য বাবলা কাঠ দিয়ে খাড়া কাঠামো তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","প্রত্যেকটি কাঠামো 4.5 মিটার করে লম্বা ও 68 সেন্টিমিটার করে চওড়া হবে, ");
INSERT INTO benobcv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","এবং কাঠামোর বেরিয়ে থাকা অংশ দুটি পরস্পরের সমান্তরাল করে বসাতে হবে। এভাবেই সমাগম তাঁবুর সব কাঠামো তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","সমাগম তাঁবুর দক্ষিণ দিকের জন্য কুড়িটি কাঠামো তৈরি কোরো ");
INSERT INTO benobcv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","এবং সেগুলির তলায় লাগানোর জন্য রুপোর চল্লিশটি ভিত তৈরি কোরো—প্রত্যেকটি কাঠামোর জন্য দুটি করে ভিত, এক-একটি অভিক্ষেপের তলায় একটি করে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","অন্য দিকের জন্য, সমাগম তাঁবুর উত্তর দিকের জন্য, কুড়িটি কাঠামো ");
INSERT INTO benobcv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","এবং প্রত্যেকটি কাঠামোর তলায় দুটি করে ভিত লাগানোর জন্য চল্লিশটি রুপোর ভিত তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","দূরবর্তী প্রান্তের জন্য, অর্থাৎ, সমাগম তাঁবুর পশ্চিম প্রান্তের জন্য ছয়টি কাঠামো তৈরি কোরো, ");
INSERT INTO benobcv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","এবং দূরবর্তী প্রান্তে কোণার জন্য দুটি কাঠামো তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","এই দুটি কোনায় সেগুলি যেন অবশ্যই নিচ থেকে একদম চূড়া পর্যন্ত দ্বিগুণ মাপের হয় এবং একটিই বলয়ে লাগানো থাকে; দুটিই একইরকম হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","অতএব সেখানে আটটি কাঠামো ও প্রত্যেকটি কাঠামোর তলায় দুটি করে—মোট ষোলোটি রুপোর ভিত থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“এছাড়াও বাবলা কাঠ দিয়ে অর্গল তৈরি কোরো: সমাগম তাঁবুর একদিকের কাঠামোগুলির জন্য পাঁচটি, ");
INSERT INTO benobcv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","অন্য দিকের কাঠামোগুলির জন্য পাঁচটি, এবং সমাগম তাঁবুর শেষ প্রান্তে, পশ্চিমদিকের কাঠামোগুলির জন্য পাঁচটি। ");
INSERT INTO benobcv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","মাঝখানের অর্গলটি কাঠামোগুলির মাঝখানে এক প্রান্ত থেকে অন্য প্রান্ত পর্যন্ত বিস্তৃত থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","কাঠামোগুলি সোনা দিয়ে মুড়ে দিয়ো এবং অর্গলগুলি ধরে রাখার জন্য সোনার আংটা তৈরি কোরো। আর অর্গলগুলিও সোনা দিয়ে মুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“পর্বতের উপরে তোমার কাছে যেমনটি প্রদর্শিত হল, ঠিক সেই পরিকল্পনা অনুসারেই সমাগম তাঁবুটি প্রতিষ্ঠিত কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো ও মিহি পাকান মসিনা দিয়ে একটি পর্দা তৈরি কোরো, এবং দক্ষ কারিগর দিয়ে তাতে করূবদের নকশা ফুটিয়ে তোলো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","সোনা দিয়ে মোড়া এবং রুপোর চারটি ভিতের উপর দাঁড়ান বাবলা কাঠের চারটি খুঁটির উপরে এটি সোনার আঁকড়া দিয়ে ঝুলিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","পর্দাটি আঁকড়া থেকে নিচে ঝুলিয়ে দিয়ো এবং বিধিনিয়মের সিন্দুকটি পর্দার পিছন দিকে রেখে দিয়ো। পর্দাটিই পবিত্র স্থানটিকে মহাপবিত্র স্থান থেকে পৃথক করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","মহাপবিত্র স্থানে, বিধিনিয়মের সিন্দুকটির উপরে প্রায়শ্চিত্ত-আবরণটি রেখে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","সমাগম তাঁবুর উত্তর দিকে পর্দার বাইরে টেবিলটি রেখে দিয়ো এবং সেটির বিপরীতে দক্ষিণ দিকে দীপাধারটি রেখে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“তাঁবুর প্রবেশদ্বারের জন্য নীল, বেগুনি, টকটকে লাল রংয়ের সুতো এবং মিহি পাকান মসিনা দিয়ে একটি পর্দা তৈরি কোরো—যা হবে একজন সূচিশিল্পীর হস্তকলা। ");
INSERT INTO benobcv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","এই পর্দাটির জন্য সোনার আঁকড়া এবং সোনায় মোড়া বাবলা কাঠের পাঁচটি খুঁটিও তৈরি কোরো। আর এগুলির জন্য ব্রোঞ্জের পাঁচটি ভিত ঢালাই করে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“বাবলা কাঠ দিয়ে 1.4 মিটার উঁচু একটি বেদি নির্মাণ কোরো; এটি যেন 2.3 মিটার লম্বা ও 2.3 মিটার চওড়া বর্গাকার হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","চার কোণার প্রত্যেকটিতে একটি করে, চারটি শিং তৈরি কোরো, যেন সেই শিংগুলি বেদির সাথে অখণ্ড হয়, এবং বেদিটি ব্রোঞ্জ দিয়ে মুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","এটির সব বাসনপত্র—ছাই ফেলার হাঁড়ি, ও বেলচা, ছিটানোর গামলা, মাংস তোলার কাঁটাচামচ এবং আগুনে সেঁকার চাটু, সবই ব্রোঞ্জ দিয়ে তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","এটির জন্য একটি জাফরি, ব্রোঞ্জের পরস্পরছেদী একটি জাল তৈরি কোরো, এবং সেই জালের চার কোণার প্রত্যেকটিতে একটি করে ব্রোঞ্জের আংটা তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","এটি বেদির তাকের নিচে রেখে দিয়ো যেন এটি বেদির অর্ধেক উচ্চতায় অবস্থিত থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","বেদির জন্য বাবলা কাঠের খুঁটি তৈরি কোরো এবং সেগুলি ব্রোঞ্জ দিয়ে মুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","খুঁটিগুলিকে আংটাগুলির মাঝে মাঝে ঢুকিয়ে দিতে হবে যেন বেদিটি বহন করার সময় সেগুলি বেদির দুই পাশে থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","তক্তা দিয়ে, বেদিটি ফাঁপা করে তৈরি কোরো। এটি ঠিক সেভাবেই তৈরি করতে হবে যেমনটি পর্বতের উপরে তোমার কাছে প্রদর্শিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“সমাগম তাঁবুর জন্য একটি প্রাঙ্গণ তৈরি কোরো। দক্ষিণ দিকটি 45 মিটার লম্বা হবে এবং সেখানে মিহি পাকান মসিনা দিয়ে তৈরি পর্দা থাকবে, ");
INSERT INTO benobcv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","এবং কুড়িটি খুঁটি ও ব্রোঞ্জের কুড়িটি ভিত তথা খুঁটিগুলির উপরে রুপোর আঁকড়া ও শেকলও থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","উত্তর দিকটিও 45 মিটার লম্বা হবে এবং সেখানে পর্দা, তথা কুড়িটি খুঁটি ও ব্রোঞ্জের কুড়িটি ভিত এবং খুঁটিগুলির উপরে রুপোর আঁকড়া ও শিকল থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“প্রাঙ্গণের পশ্চিমপ্রান্তটি 23 মিটার চওড়া হবে, এবং সেখানে পর্দা, তথা দশটি খুঁটি ও দশটি ভিত থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","সূর্যোদয়ের দিকে, পূর্বপ্রান্তেও, প্রাঙ্গণটি 23 মিটার চওড়া হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","6.8 মিটার লম্বা পর্দাগুলি প্রবেশদ্বারের একদিকে থাকবে, ও সাথে থাকবে তিনটি খুঁটি ও তিনটি ভিত, ");
INSERT INTO benobcv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","এবং 6.8 মিটার লম্বা পর্দাগুলি অন্যদিকে থাকবে, ও সাথে থাকবে তিনটি খুঁটি ও তিনটি ভিত। ");
INSERT INTO benobcv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“প্রাঙ্গণের প্রবেশদ্বারের জন্য, নীল, বেগুনি এবং টকটকে লাল রংয়ের সুতো এবং মিহি পাকান মসিনা দিয়ে তৈরি 9 মিটার লম্বা একটি পর্দার জোগান দিয়ো—তা হবে এক সূচিশিল্পীর হস্তকলা—সাথে চারটি খুঁটি ও চারটি ভিতও দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","প্রাঙ্গণের চারপাশের সব খুঁটির শিকল ও আঁকড়াগুলি রুপোর এবং ভিতগুলি ব্রোঞ্জের হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","প্রাঙ্গণটি হবে 45 মিটার লম্বা ও 23 মিটার চওড়া, এবং পর্দাগুলি মিহি পাকান মসিনা দিয়ে তৈরি 2.3 মিটার উচ্চতাবিশিষ্ট হবে, এবং সাথে ব্রোঞ্জের ভিতগুলিও থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","সমাগম তাঁবুর সেবাকাজে ব্যবহৃত অন্য সব জিনিসপত্র, তা তাদের কাজ যাই হোক না কেন, সাথে সাথে সেটির এবং প্রাঙ্গণের সব তাঁবু-খুটা, ব্রোঞ্জের হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“আলোর জন্য নিংড়ে নেওয়া স্বচ্ছ জলপাই তেল তোমার কাছে নিয়ে আসার জন্য ইস্রায়েলীদের আদেশ দাও যেন প্রদীপগুলি সবসময় জ্বলতেই থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","সমাগম তাঁবুর ভিতরে, যে পর্দাটি বিধিনিয়মের সিন্দুকটি আড়াল করে রাখে, সেটির বাইরের দিকে, হারোণ ও তার ছেলেরা সন্ধ্যা থেকে সকাল পর্যন্ত সদাপ্রভুর সামনে প্রদীপগুলি জ্বালিয়ে রাখবে। আগামী বংশপরম্পরায় ইস্রায়েলীদের মধ্যে এটি একটি চিরস্থায়ী বিধিনিয়ম হয়েই থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“ইস্রায়েলীদের মধ্যে থেকে তোমার দাদা হারোণকে এবং তার ছেলে নাদব ও অবীহূ, ইলীয়াসর ও ঈথামরকে তোমার কাছে ডেকে আনো, যেন তারা যাজকরূপে আমার সেবা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","তোমার দাদা হারোণকে মর্যাদা ও সম্মান দিতে তার জন্য পবিত্র পোশাক তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","যাদের আমি এই বিষয়ে প্রজ্ঞা দিয়েছি, সেইসব দক্ষ কারিগরকে বোলো, তারা যেন হারোণের জন্য, তার অভিষেকের জন্য পোশাক তৈরি করে, সে যেন যাজকরূপে আমার সেবা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","এইসব পোশাক-পরিচ্ছদ তারা তৈরি করবে: একটি বুকপাটা, একটি এফোদ, একটি আলখাল্লা, হাতে বোনা একটি নিমা, একটি পাগড়ি ও একটি উত্তরীয়। তোমার দাদা হারোণ ও তার ছেলেদের জন্য তাদের এইসব পবিত্র পোশাক-পরিচ্ছদ তৈরি করতে হবে, যেন তারা যাজকরূপে আমার সেবা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","তাদের সোনা, ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো এবং মিহি মসিনা ব্যবহার করতে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“সোনা, এবং নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো এবং মিহি পাকান মসিনা দিয়ে এফোদটি তৈরি কোরো—যা দক্ষ হস্তকলা হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","এতে কোণাগুলির সাথে যুক্ত দুটি কাঁধ-পটি থাকবে, যেন এফোদটি বেঁধে রাখা যায়। ");
INSERT INTO benobcv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","দক্ষতার সাথে বোনা এটির কোমরবন্ধটিও এরই মতো হবে—এটি এফোদের সাথেই জুড়ে থাকা একই ভাগ হবে এবং সোনা, ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো এবং মিহি পাকান মসিনা দিয়ে তৈরি করা হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“তুমি দুটি স্ফটিকমণি নাও এবং সেগুলির উপর ইস্রায়েলের ছেলেদের নাম খোদাই করে দাও। ");
INSERT INTO benobcv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","তাদের জন্মের ক্রমানুসারে—একটি মণিতে ছয়টি নাম এবং অন্যটিতে বাকি ছয়টি নাম খোদাই করো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","যেভাবে একজন রত্নশিল্পী একটি সিলমোহর খোদাই করে, সেভাবেই সেই মণি দুটিতে ইস্রায়েলের ছেলেদের নামগুলি খোদাই করে দিয়ো। পরে মণিগুলি সোনার তারের সূক্ষ্ম কারুকার্য করা ঝালরে চড়িয়ে দিয়ো ");
INSERT INTO benobcv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","এবং ইস্রায়েলের ছেলেদের জন্য স্মরণার্থক মণিরূপে সেগুলি সেই এফোদের কাঁধ-পটিগুলিতে বেঁধে দিয়ো। সদাপ্রভুর সামনে এক স্মারকরূপে হারোণ তার কাঁধে সেই নামগুলি বহন করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","সোনার তারের সূক্ষ্ম কারুকার্য করা ঝালর ");
INSERT INTO benobcv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","এবং খাঁটি সোনা দিয়ে দড়ির মতো দেখতে দুটি পাতা-কাটা শিকল তৈরি কোরো, ও সেই শিকলটি ঝালরে জুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“সিদ্ধান্ত নেওয়ার জন্য একটি বুকপাটা গড়ে দিয়ো—যা হবে দক্ষ হস্তকলা। এটিকে এফোদের মতো করেই: সোনা, ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো এবং মিহি পাকান মসিনা দিয়ে তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","এটি বর্গাকার, 23 সেন্টিমিটার লম্বা ও চওড়া হবে এবং তা দুই ভাঁজ করে রাখতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","পরে এটির উপর মূল্যবান মণিরত্নের চারটি সারি চড়িয়ে দিয়ো। প্রথম সারিতে থাকবে চুণী, গোমেদ ও পান্না; ");
INSERT INTO benobcv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","দ্বিতীয় সারিতে থাকবে ফিরোজা, নীলা ও পান্না; ");
INSERT INTO benobcv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","তৃতীয় সারিতে থাকবে নীলকান্তমণি, অকীক ও নীলা; ");
INSERT INTO benobcv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","চতুর্থ সারিতে থাকবে পোখরাজ, স্ফটিকমণি ও সূর্যকান্তমণি। এগুলি সোনার তারের সূক্ষ্ম কারুকার্য করা ঝালরে চড়িয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ইস্রায়েলের ছেলেদের এক একজনের নামের জন্য বারোটি মণি থাকবে, প্রত্যেকটি মণির উপরে বারোটি গোষ্ঠীর মধ্যে এক এক গোষ্ঠীর নাম এক সিলমোহরের মতো খোদাই করে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“বুকপাটার জন্য খাঁটি সোনা দিয়ে দড়ির মতো পাতা-কাটা শিকল তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","এটির জন্য সোনার দুটি আংটা তৈরি করে সেগুলি সেই বুকপাটার দুই কোনায় বেঁধে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","সেই বুকপাটার কোনায় থাকা আংটাগুলিতে সোনার সেই শিকল দুটি বেঁধে দিয়ো, ");
INSERT INTO benobcv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","এবং সেই শিকলগুলির অন্য প্রান্তগুলি সেই দুটি ঝালরে বেঁধে দিয়ে এফোদের সামনের দিকের কাঁধ-পটিতে জুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","সোনার দুটি আংটা তৈরি করে সেগুলি এফোদের পাশে থাকা ভিতরদিকের বুকপাটার অন্য দুই কোনায় জুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","সোনার আরও দুটি আংটা তৈরি করে সেগুলি এফোদের সামনের দিকের কাঁধ-পটির তলায়, এফোদের কোমরবন্ধের ঠিক উপরে, দুই প্রান্তের জোড়ের কাছে জোড়া দিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","বুকপাটার আংটাগুলিকে কোমরবন্ধের সাথে যুক্ত করে নীল দড়ি দিয়ে এফোদের আংটাগুলির সাথে এমনভাবে বেঁধে দিতে হবে, যেন বুকপাটাটি দোল খেয়ে এফোদ থেকে সরে না যায়। ");
INSERT INTO benobcv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“হারোণ যখনই পবিত্রস্থানে প্রবেশ করবে, সদাপ্রভুর সামনে চিরস্থায়ী এক স্মারকরূপে সিদ্ধান্তের সেই বুকপাটায় সে তার হৃদয়ের উপরে ইস্রায়েলের ছেলেদের নামগুলি বহন করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","এছাড়াও সেই বুকপাটায় ঊরীম ও তুম্মীম রেখো, যেন হারোণ যখনই সদাপ্রভুর উপস্থিতিতে প্রবেশ করে, সেগুলি তার হৃদয়ের উপরেই থেকে যায়। এইভাবে হারোণ সবসময় সদাপ্রভুর সামনে ইস্রায়েলীদের জন্য সিদ্ধান্ত গ্রহণের সাধন তার বুকের উপরে বয়ে বেড়াবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“এফোদের আলখাল্লাটি আগাগোড়াই নীল কাপড় দিয়ে তৈরি করে, ");
INSERT INTO benobcv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","মাথা ঢোকানোর জন্য মাঝখানে একটি ফাঁক রেখো। এই ফাঁকের চারপাশে গলাবন্ধের মতো হাতে বোনা একটি ধারি থাকবে, যেন এটি ছিঁড়ে না যায়। ");
INSERT INTO benobcv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","সেই আলখাল্লার আঁচলের চারপাশে নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো দিয়ে ডালিম তৈরি করে, সেগুলির মাঝে মাঝে সোনার ঘণ্টা ঝুলিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","সোনার ঘণ্টা ও ডালিমগুলি আলখাল্লার আঁচলের চারপাশে পর্যায়ক্রমে বসানো থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","পরিচর্যা করার সময় হারোণকে অবশ্যই এটি পরে থাকতে হবে। সে যখন পবিত্রস্থানে সদাপ্রভুর সামনে প্রবেশ করবে এবং যখন সে বাইরে বেরিয়ে আসবে, তখন সেই ঘণ্টার শব্দ শোনা যাবে, যেন সে মারা না যায়। ");
INSERT INTO benobcv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“খাঁটি সোনা দিয়ে একটি ফলক তৈরি করে তাতে সিলমোহরের মতো করে খোদাই করে দিয়ো: সদাপ্রভুর উদ্দেশে পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","এটিকে পাগড়ির সাথে জুড়ে রাখার জন্য এতে একটি নীল সুতো বেঁধে দিয়ো; এটি পাগড়ির সামনের দিকে থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","এটি হারোণের কপালের উপরে থাকবে, এবং সে ইস্রায়েলীদের উৎসর্গ করা পবিত্র নৈবেদ্যগুলির সাথে যুক্ত অপরাধ বহন করবে, তাদের নৈবেদ্যগুলি যাই হোক না কেন। অবিচ্ছিন্নভাবে এটি হারোণের কপালে থাকবে যেন তারা সদাপ্রভুর কাছে গ্রাহ্য হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“মিহি মসিনা দিয়ে নিমা বুনো এবং পাগড়িও তৈরি কোরো। উত্তরীয়টি হবে দক্ষ এক সূচিশিল্পীর হস্তকলা। ");
INSERT INTO benobcv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","হারোণের ছেলেদের মর্যাদা ও সম্মান দিতে তাদের জন্য নিমা, উত্তরীয় ও টুপি তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","তোমার দাদা হারোণ ও তার ছেলেদের এইসব পোশাক পরিয়ে দেওয়ার পর তুমি তাদের অভিষিক্ত ও নিযুক্ত কোরো। তাদের পবিত্র কোরো যেন তারা যাজকরূপে আমার সেবা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“শরীর ঢেকে রাখার জন্য মসিনা দিয়ে অন্তর্বাস তৈরি কোরো, যা কোমর থেকে ঊরু পর্যন্ত বিস্তৃত থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","হারোণ ও তার ছেলেরা যখনই সমাগম তাঁবুতে প্রবেশ করবে বা পবিত্রস্থানে পরিচর্যা করার জন্য বেদির নিকটবর্তী হবে, তখনই তাদের সেগুলি পরতে হবে, যেন তারা অপরাধের ভাগী হয়ে মারা না যায়। “হারোণ ও তার বংশধরদের জন্য এটি চিরস্থায়ী এক বিধি হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“তারা যেন যাজকরূপে আমার সেবা করতে পারে, সেজন্য তাদের পবিত্র করার ক্ষেত্রে তোমাকে এরকম করতে হবে: নিখুঁত একটি এঁড়ে বাছুর ও দুটি মেষ নিও। ");
INSERT INTO benobcv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","আর গমের মিহি আটায় জলপাই তেল মিশ্রিত করে খামিরবিহীন গোলাকার রুটি, খামিরবিহীন মোটা মোটা রুটি এবং জলপাই তেল মাখানো পাতলা পাতলা রুটি তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","সেগুলি একটি ঝুড়িতে রেখো এবং সেগুলি সেই এঁড়ে বাছুর ও মেষ সমেত উপহার দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","পরে হারোণ ও তার ছেলেদের সমাগম তাঁবুর প্রবেশদ্বারে এনো এবং জল দিয়ে তাদের গা ধুয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","পোশাকগুলি নিয়ে হারোণকে নিমা, এফোদের আলখাল্লা, এফোদ ও বুকপাটাটি পরিয়ে দিয়ো। দক্ষতার সঙ্গে বোনা কোমরবন্ধ দিয়ে তার গায়ে এফোদটি বেঁধে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","তার মাথায় পাগড়ি পরিয়ে দিয়ো এবং সেই পাগড়িতে পবিত্র প্রতীক জুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","অভিষেক-তেল নিয়ে তা তার মাথায় ঢেলে দিয়ে তাকে অভিষিক্ত কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","তার ছেলেদের নিয়ে এসে তাদেরও নিমা পরিয়ে দিয়ো ");
INSERT INTO benobcv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","এবং মাথায় টুপি বেঁধে দিয়ো। পরে হারোণ ও তার ছেলেদের গায়ে উত্তরীয় পরিয়ে দিয়ো। দীর্ঘস্থায়ী এক বিধি দ্বারা যাজকত্ব তাদেরই অধিকারভুক্ত হয়েছে। “পরে তুমি হারোণ ও তার ছেলেদের যাজকপদে নিযুক্ত কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“সেই বাছুরটিকে তুমি সমাগম তাঁবুর সামনে এনো, এবং হারোণ ও তার ছেলেরা সেটির মাথায় তাদের হাত রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","সমাগম তাঁবুর প্রবেশদ্বারে সদাপ্রভুর উপস্থিতিতে সেটি বধ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","সেই বাছুরটির রক্ত থেকে কিছুটা রক্ত নিয়ো ও তোমার আঙুল দিয়ে তা সেই বেদির শিং-এ মাখিয়ে দিয়ো, এবং বাদবাকি রক্ত সেই বেদির তলায় ঢেলে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","পরে অভ্যন্তরীণ অঙ্গের সব চর্বি, কলিজার বড়ো পালি, ও চর্বি সমেত কিডনি দুটি নিয়ে সেগুলি বেদির উপর পুড়িয়ে ফেলো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","কিন্তু বাছুরটির মাংস ও সেটির চামড়া ও অন্ত্রগুলি শিবিরের বাইরে পুড়িয়ে দিয়ো। এ হল এক পাপার্থক বলি। ");
INSERT INTO benobcv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“মেষগুলির মধ্যে একটিকে নিয়ো, এবং হারোণ ও তার ছেলেরা সেটির মাথায় তাদের হাত রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","সেটিকে বধ কোরো ও রক্ত নিয়ে তা বেদির উপরে চারপাশে ছিটিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","মেষটিকে টুকরো টুকরো করে কেটো এবং সব অভ্যন্তরীণ অঙ্গ ও পা ধুয়ে দিয়ো, এবং সেগুলি মাথা ও অন্যান্য টুকরোগুলির সাথেই রেখো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","পরে সমগ্র মেষটি বেদিতে রেখে পুড়িয়ে ফেলো। এ হল সদাপ্রভুর উদ্দেশে দত্ত এক হোমবলি, প্রীতিকর সৌরভ, সদাপ্রভুর উদ্দেশে নিবেদিত এক ভক্ষ্য-নৈবেদ্য। ");
INSERT INTO benobcv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“অন্য মেষটিকেও নিও, এবং হারোণ ও তার ছেলেরা সেটির মাথায় তাদের হাত রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","সেটিকে বধ কোরো, সেটির রক্ত থেকে কিছুটা রক্ত নিয়ো এবং তা হারোণ ও তার ছেলেদের ডান কানের লতিতে, তাদের ডান হাতের বুড়ো আঙুলে ও তাদের ডান পায়ের বুড়ো আঙুলে লাগিয়ে দিয়ো। পরে বেদির উপরে চারপাশে রক্ত ছিটিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","আর বেদি থেকে কিছুটা রক্ত ও কিছুটা অভিষেক-তেল নিও এবং হারোণের ও তার পোশাকের উপরে এবং তার ছেলেদের ও তাদের পোশাকের উপরে ছিটিয়ে দিয়ো। তখন সে ও তার ছেলেরা এবং তাদের পোশাকগুলিও শুচিশুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“এই মেষটি থেকে চর্বি, মোটা লেজ, অভ্যন্তরীণ অঙ্গগুলিতে লেগে থাকা চর্বি, কলিজার বড়ো পালি, দুটি কিডনি ও সেগুলিতে লেগে থাকা চর্বি, এবং ডানদিকের ঊরুটি নিও। (এ হল যাজকপদে নিযুক্তিমূলক মেষ) ");
INSERT INTO benobcv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","সদাপ্রভুর সামনে রাখা খামিরবিহীন রুটির ঝুড়ি থেকে একটি গোলাকার রুটি, জলপাই তেল মিশ্রিত একটি মোটা রুটি, এবং একটি পাতলা রুটি নিও। ");
INSERT INTO benobcv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","এসব কিছু হারোণ ও তার ছেলেদের হাতে দিয়ো এবং এক দোলনীয়-নৈবেদ্যরূপে সদাপ্রভুর সামনে সেগুলি তাদের দোলাতে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","পরে তাদের হাত থেকে সেগুলি নিয়ে নিও এবং হোমবলির সাথে সাথে সেগুলিও সদাপ্রভুর উদ্দেশে এক প্রীতিকর সৌরভরূপে, সদাপ্রভুর কাছে নিবেদিত এক ভক্ষ্য-নৈবেদ্যরূপে বেদিতে পুড়িয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","হারোণের নিযুক্তির জন্য তুমি মেষের বক্ষটি নেওয়ার পর, সেটি এক দোলনীয়-নৈবেদ্যরূপে সদাপ্রভুর সামনে দুলিয়ো, এবং এটি তোমার অংশ হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“যাজকপদে নিযুক্তিমূলক মেষের সেই অঙ্গগুলি শুচিশুদ্ধ কোরো, যেগুলি হারোণ ও তার ছেলেদের অধিকারভুক্ত: সেই বক্ষঃস্থল, যা দোলানো হল এবং সেই ঊরু, যা উপহার দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","এটি সবসময় হারোণ ও তার ছেলেদের জন্য ইস্রায়েলীদের কাছ থেকে নেওয়া চিরস্থায়ী অংশ হবে। এ হল ইস্রায়েলীদের সেই উপহার, যা সদাপ্রভুর উদ্দেশে দত্ত মঙ্গলার্থক বলি থেকে তারা দিয়ে থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“হারোণের পবিত্র পোশাকগুলি তার বংশধরদের অধিকারভুক্ত হবে যেন তারা সেগুলি পরে অভিষিক্ত ও নিযুক্ত হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","তার যে ছেলে যাজকরূপে তার স্থলাভিষিক্ত হবে এবং পবিত্রস্থানে পরিচর্যা করার জন্য সমাগম তাঁবুতে আসবে, তাকে সাত দিন ধরে সেগুলি পরে থাকতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“যাজকপদে নিযুক্তিমূলক মেষটি নিও এবং পবিত্র এক স্থানে সেই মাংস রান্না কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","সমাগম তাঁবুর প্রবেশদ্বারে, হারোণ ও তার ছেলেদের সেই মেষের মাংস ও ঝুড়িতে রাখা রুটি খেতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","তাদের যাজকপদে নিযুক্তি ও অভিষেকের জন্য যে যে প্রায়শ্চিত্ত বলি উৎসর্গ করা হল, সেগুলির আধারেই তাদের এই নৈবেদ্যগুলি খেতে হবে। কিন্তু অন্য কেউ সেগুলি খেতে পারবে না, কারণ সেগুলি পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","আর যাজকপদে নিযুক্তিমূলক সেই মেষের কিছুটা মাংস বা কয়েকটি রুটি যদি সকাল পর্যন্ত অবশিষ্ট থেকে যায়, তবে সেগুলি পুড়িয়ে ফেলো। তা যেন অবশ্যই খাওয়া না হয়, কারণ তা পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“তোমাকে দেওয়া আমার আদেশানুসারে তুমি হারোণ ও তার ছেলেদের প্রতি সবকিছু কোরো, যাজকপদে তাদের নিযুক্ত করার জন্য সাত দিন সময় নিও। ");
INSERT INTO benobcv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","প্রায়শ্চিত্ত করার জন্য এক পাপার্থক বলিরূপে প্রতিদিন একটি করে বলদ বলি দিয়ো। বেদির জন্য প্রায়শ্চিত্ত করার দ্বারা সেটি শুচিশুদ্ধ কোরো, এবং সেটি পবিত্র করার জন্য তা অভিষিক্ত কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","সাত দিন ধরে বেদির জন্য প্রায়শ্চিত্ত কোরো এবং সেটি পবিত্র কোরো। তখন সেই বেদিটি মহাপবিত্র হয়ে যাবে এবং যা কিছু সেটিকে স্পর্শ করবে তাও পবিত্র হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“প্রতিদিন নিয়মিতভাবে সেই বেদির উপরে তোমাকে যা যা উৎসর্গ করতে হবে, তা হল এই: এক বছর বয়স্ক দুটি মেষশাবক। ");
INSERT INTO benobcv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","একটি সকালে ও অন্যটি গোধূলিবেলায় উৎসর্গ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","প্রথম মেষশাবকটির সাথে সাথে হিনের এক-চতুর্থাংশ নিংড়ানো জলপাই তেল মিশ্রিত ঐফার এক-দশমাংশ মিহি আটা এবং পেয়-নৈবেদ্যরূপে হিনের এক-চতুর্থাংশ দ্রাক্ষারসও উৎসর্গ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","গোধূলিবেলায় অন্য মেষশাবকটিও সকালবেলার মতো একই শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য সহযোগে সদাপ্রভুর উদ্দেশে নিবেদিত এক প্রীতিকর সৌরভ, এক ভক্ষ্য-নৈবেদ্যরূপে উৎসর্গ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“বংশপরম্পরায় সদাপ্রভুর সামনে, সমাগম তাঁবুর প্রবেশদ্বারে নিয়মিতভাবে এই হোমবলিটি উৎসর্গ করতে হবে। সেখানে আমি তোমার সাথে দেখা করব ও তোমার সাথে কথা বলব; ");
INSERT INTO benobcv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","এছাড়াও সেখানেই আমি ইস্রায়েলীদের সাথে দেখা করব, এবং সেই স্থানটি আমার মহিমা দ্বারা পবিত্র হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“অতএব আমি সেই সমাগম তাঁবু ও বেদিটি পবিত্র করব এবং যাজকরূপে আমার সেবা করার জন্য হারোণ ও তার ছেলেদেরও পবিত্র করব। ");
INSERT INTO benobcv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","পরে আমি ইস্রায়েলীদের মধ্যে বসবাস করব এবং তাদের ঈশ্বর হব। ");
INSERT INTO benobcv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","তারা জানতে পারবে যে আমিই তাদের সেই ঈশ্বর সদাপ্রভু, যিনি তাদের মধ্যে বসবাস করার জন্য মিশর থেকে তাদের বের করে এনেছিলেন। আমিই তাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ধূপ জ্বালানোর জন্য বাবলা কাঠ দিয়ে একটি বেদি তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","এটি 45 সেন্টিমিটার করে লম্বা ও চওড়া, এবং 90 সেন্টিমিটার উঁচু বর্গাকার হবে—এর শিংগুলি এর সাথে একই টুকরো দিয়ে গড়া হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","এর চূড়া ও সবদিক এবং শিংগুলি খাঁটি সোনা দিয়ে মুড়ে দিয়ো, এবং এর চারপাশে সোনার এক ছাঁচ তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","সেই ছাঁচের তলায় বেদিটির জন্য সোনার দুটি আংটা তৈরি কোরো—বেদিটি বহন করার ক্ষেত্রে ব্যবহৃত খুঁটিগুলি ধরে রাখার জন্য বিপরীত দিকগুলির প্রত্যেকটিতে দুটি দুটি করে আংটা তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","বাবলা কাঠ দিয়ে খুঁটিগুলি তৈরি কোরো এবং সেগুলি সোনা দিয়ে মুড়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","যে পর্দাটি বিধিনিয়মের সিন্দুকটিকে আড়াল করে রাখে, সেটির সামনের দিকে—যে প্রায়শ্চিত্ত-আচ্ছাদনটি বিধিনিয়মের ফলকগুলির উপরে থাকে, সেটির সামনে—সেই বেদিটি রেখো, যেখানে আমি তোমার সাথে দেখা করব। ");
INSERT INTO benobcv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“প্রতিদিন সকালে হারোণ যখন প্রদীপগুলি পরিষ্কার করবে তখন তাকে বেদিতে সুগন্ধি ধূপ জ্বালাতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","আবার গোধূলিবেলায় সে যখন প্রদীপগুলি জ্বালাবে তখনও তাকে ধূপ জ্বালাতে হবে, যেন আগামী বংশপরম্পরায় সদাপ্রভুর সামনে নিয়মিতভাবে ধূপ জ্বলে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","এই বেদিতে আর অন্য কোনো ধূপ বা কোনো হোমবলি বা শস্য-নৈবেদ্য উৎসর্গ কোরো না, এটির উপরে কোনো পেয়-নৈবেদ্য ঢেলো না। ");
INSERT INTO benobcv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","বছরে একবার হারোণ বেদির শিংগুলির উপরে প্রায়শ্চিত্ত সাধন করবে। এই বাৎসরিক প্রায়শ্চিত্তটি আগামী বংশপরম্পরায় প্রায়শ্চিত্তকারক পাপার্থক বলির রক্ত দিয়ে করতে হবে। সদাপ্রভুর উদ্দেশে এটি অতি পবিত্র।” ");
INSERT INTO benobcv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ইস্রায়েলীদের সংখ্যা গণনা করার জন্য যখন তুমি তাদের জনগণনা করবে, তখন গণিত হওয়ার সময় প্রত্যেককে তার জীবনের জন্য সদাপ্রভুকে এক মুক্তিপণ দিতে হবে। তুমি তাদের সংখ্যা গণনা করার সময় তখন আর তাদের উপর কোনও আঘাত নেমে আসবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","যারা ইতিমধ্যেই গণিত হয়ে গিয়েছে, সেই লোকজনের মধ্যে যে কেউ আসবে, তাকে পবিত্রস্থানের শেকল অনুসারে আধ শেকল দিতে হবে, এক শেকলের ওজন কুড়ি গেরা। এই আধ শেকল সদাপ্রভুর উদ্দেশে দত্ত এক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","এদিকে আসা যাদের বয়স কুড়ি বছর বা তার বেশি, তারা সদাপ্রভুর উদ্দেশে এক নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","তোমাদের জীবনের জন্য প্রায়শ্চিত্ত করতে গিয়ে তুমি যখন সদাপ্রভুর উদ্দেশে নৈবেদ্য উৎসর্গ করবে, তখন ধনবান লোক আধ শেকলের বেশি দেবে না এবং দরিদ্রও কম দেবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ইস্রায়েলীদের কাছ থেকে প্রায়শ্চিত্তকারী অর্থ গ্রহণ কোরো এবং সেই অর্থ সমাগম তাঁবুর সেবাকাজে ব্যবহার কোরো। সদাপ্রভুর সামনে ইস্রায়েলীদের জন্য এক স্মারক হয়ে থেকে তা তোমাদের জীবনের জন্য প্রায়শ্চিত্ত করবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ধোয়াধুয়ি করার জন্য ব্রোঞ্জের একটি গামলা ও ব্রোঞ্জ দিয়ে সেটির মাচাও তৈরি কোরো। সমাগম তাঁবুর ও বেদির মাঝখানে সেটি রেখো, এবং সেটিতে জল ভরে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","সেখান থেকে জল নিয়ে হারোণ ও তার ছেলেদের তাদের হাত পা ধুতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","যখনই তারা তাঁবুর ভিতরে প্রবেশ করবে, তারা জল দিয়ে নিজেদের ধুয়ে ফেলবে, যেন তারা মারা না যায়। এছাড়াও, যখন তারা সদাপ্রভুর উদ্দেশে এক ভক্ষ্য-নৈবেদ্য উৎসর্গ করার মাধ্যমে পরিচর্যা করার জন্য সেই বেদির নিকটবর্তী হবে, ");
INSERT INTO benobcv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","তখনও তারা তাদের হাত পা ধুয়ে নেবে, যেন তারা মারা না যায়। আগামী বংশপরম্পরায় হারোণ ও তার বংশধরদের জন্য এ এক দীর্ঘস্থায়ী বিধি হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“তুমি এই সুন্দর সুন্দর মশলাগুলি নিও: 500 শেকল তরল গন্ধরস, এর অর্ধেক পরিমাণ (অর্থাৎ 250 শেকল) সুগন্ধি দারুচিনি, 250 শেকল সুগন্ধি বচ, ");
INSERT INTO benobcv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","500 শেকল নীরসে ধরনের দারুচিনি—সবই পবিত্রস্থানের শেকল অনুসারে—এবং এক হিন জলপাই তেল। ");
INSERT INTO benobcv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","এগুলি দিয়ে সুগন্ধি দ্রব্যাদির প্রস্তুতকারকের হস্তকলার মতো করে পবিত্র এক অভিষেক-তেল, সুগন্ধি এক মিশ্রণ তৈরি কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","পরে সমাগম তাঁবু, বিধিনিয়মের সিন্দুক, ");
INSERT INTO benobcv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","টেবিল ও তার সব জিনিসপত্র, দীপাধার ও তার আনুষঙ্গিক উপকরণ, ধূপবেদি, ");
INSERT INTO benobcv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","হোমবলির বেদি ও তার সব বাসনপত্র, এবং গামলা ও তার মাচাটি অভিষিক্ত করার জন্য তা ব্যবহার কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","সেগুলি তুমি পবিত্র করবে, যেন সেগুলি অতি পবিত্র হয়ে যায় এবং যা কিছু সেগুলির সংস্পর্শে আসবে সেগুলিও পবিত্র হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“হারোণ ও তার ছেলেদের অভিষিক্ত এবং পবিত্র কোরো, যেন তারা যাজকরূপে আমার সেবা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ইস্রায়েলীদের বোলো, ‘আগামী বংশপরম্পরায় এটিই হবে আমার পবিত্র অভিষেক-তেল। ");
INSERT INTO benobcv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","অন্য কোনো মানুষের দেহে এটি ঢেলো না এবং একই প্রস্তুতপ্রণালী ব্যবহার করে অন্য কোনো তেল তৈরি কোরো না। এটি পবিত্র, আর তোমাদের এটি পবিত্র বলেই গণ্য করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","যে কেউ এটির মতো সুগন্ধি তৈরি করে এবং একজন যাজক ছাড়া অন্য কোনো মানুষের গায়ে ঢেলে দেয়, তাকে তার লোকজনদের কাছ থেকে বিচ্ছিন্ন হতে হবে। ’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","পরে সদাপ্রভু মোশিকে বললেন, “তুমি সমপরিমাণে সুগন্ধি মশলাপাতি—আঠা রজন, নখী, কুন্দুরু—এবং খাঁটি গুগগুল নিয়ো, ");
INSERT INTO benobcv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","এবং একজন সুগন্ধি দ্রব্যাদি প্রস্তুতকারকের হস্তকলার মতো করে ধূপের এক সুগন্ধি মিশ্রণ তৈরি কোরো। এটি যেন লবণাক্ত এবং খাঁটি ও পবিত্র হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","তা থেকে কিছুটা পিষে গুঁড়ো করে নিও এবং তা সমাগম তাঁবুতে বিধিনিয়মের সেই সিন্দুকটির সামনে এনে রেখো, যেখানে আমি তোমার সাথে দেখা করব। এটি তোমাদের কাছে অতি পবিত্র হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","এই প্রস্তুতপ্রণালী দিয়ে নিজেদের জন্য তোমরা কোনো ধূপ তৈরি কোরো না; সদাপ্রভুর উদ্দেশে এটি পবিত্র বলে গণ্য কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","যে কেউ এটির সুগন্ধ উপভোগ করার জন্য এটির মতো ধূপ তৈরি করবে, তাকে তার লোকজনদের কাছ থেকে বিচ্ছিন্ন হতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“দেখো, আমি যিহূদা গোষ্ঠীভুক্ত হূরের নাতি তথা ঊরির ছেলে বৎসলেলকে মনোনীত করেছি, ");
INSERT INTO benobcv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","এবং আমি তাকে ঈশ্বরের আত্মায়, প্রজ্ঞায়, বুদ্ধিতে, জ্ঞানে এবং সব ধরনের দক্ষতায় পরিপূর্ণ করেছি— ");
INSERT INTO benobcv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","যেন সে সোনা, রুপো ও ব্রোঞ্জ দিয়ে চারুশিল্পসম্মত নকশা ফুটিয়ে তুলতে, ");
INSERT INTO benobcv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","পাথর কেটে তা বসাতে, কাঠের কাজ করতে, এবং সব ধরনের কারুশিল্পের কাজে লিপ্ত হতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","এছাড়াও, তাকে একাজে সাহায্য করার জন্য আমি দান গোষ্ঠীভুক্ত অহীষামকের ছেলে অহলীয়াবকেও নিযুক্ত করেছি। “যা যা করার আদেশ আমি তোমাকে দিয়েছিলাম, সেসবকিছু তৈরি করার দক্ষতা আমি সব দক্ষ কারিগরকে দিয়েছি: ");
INSERT INTO benobcv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“সমাগম তাঁবু, বিধিনিয়মের সিন্দুক এবং সেটির উপরের প্রায়শ্চিত্ত-আচ্ছাদন, এবং তাঁবুর অন্যান্য সব আসবাবপত্র— ");
INSERT INTO benobcv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","টেবিল এবং সেটির সব জিনিসপত্র, খাঁটি সোনার দীপাধার এবং সেটির সব আনুষঙ্গিক উপকরণ, ধূপবেদি, ");
INSERT INTO benobcv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","হোমবলির বেদি এবং সেটির সব পাত্র, গামলা এবং সেটির মাচা— ");
INSERT INTO benobcv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","আর এছাড়াও হাতে বোনা পোশাক-পরিচ্ছদ, যাজক হারোণের জন্য সেই পবিত্র পোশাক এবং তার ছেলেদের জন্যও সেই পোশাক, যেগুলি তারা যাজকরূপে সেবাকাজ করার সময় গায়ে দেবে, ");
INSERT INTO benobcv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","এবং পবিত্রস্থানের জন্য সেই অভিষেক-তেল ও সুগন্ধি ধূপ। “আমি তোমাকে যেমন আদেশ দিয়েছিলাম, ঠিক সেভাবেই তারা যেন সেগুলি তৈরি করে।” ");
INSERT INTO benobcv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","ইস্রায়েলীদের বলো, “তোমাদের অবশ্যই আমার সাব্বাথ পালন করতে হবে। আগামী বংশপরম্পরায় এটি আমার ও তোমাদের মধ্যে এক চিহ্ন হবে, যেন তোমরা জানতে পারো যে আমিই সেই সদাপ্রভু, যিনি তোমাদের পবিত্র করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“সাব্বাথ পালন কোরো, কারণ তোমাদের কাছে এই দিনটি পবিত্র। যে কেউ এই দিনটিকে অপবিত্র করবে, তাকে মেরে ফেলতে হবে; যারা সেদিন কোনও কাজ করবে, তাদের অবশ্যই তাদের লোকজনের কাছ থেকে বিচ্ছিন্ন হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ছয় দিন কাজ করা যেতে পারে, কিন্তু সপ্তম দিনটি সাব্বাথ বিশ্রামের দিন, যা সদাপ্রভুর উদ্দেশে পবিত্র। যে কেউ সাব্বাথবারে কোনও কাজ করবে, তাকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","আগামী বংশপরম্পরায় দীর্ঘস্থায়ী এক নিয়মরূপে সাব্বাথবার উদ্‌যাপন করার মাধ্যমে ইস্রায়েলীদের তা পালন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","চিরকালের জন্য এটি আমার ও ইস্রায়েলীদের মধ্যে এক চিহ্ন হয়ে থাকবে, কারণ ছয় দিনে সদাপ্রভু আকাশমণ্ডল ও পৃথিবী তৈরি করেছিলেন, এবং সপ্তম দিনে তিনি বিশ্রাম নিয়েছিলেন ও চাঙ্গা হয়েছিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","সীনয় পর্বতে মোশির সঙ্গে সদাপ্রভুর কথা বলা শেষ হয়ে যাওয়ার পর, তিনি মোশিকে ঈশ্বরের আঙুল দিয়ে খোদাই করা পাথরের ফলকগুলি, বিধিনিয়মের সেই দুটি ফলক দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","লোকেরা যখন দেখেছিল যে মোশি পর্বত থেকে নিচে নামতে খুব দেরি করছেন, তখন তারা হারোণের চারপাশে একত্রিত হয়ে বলল, “আসুন, আমাদের জন্য এমন সব দেবতা তৈরি করে দিন, যারা আমাদের অগ্রগামী হবেন। যে মোশি আমাদের মিশর দেশ থেকে বের করে এনেছেন, তার কী হল তা আমরা জানি না।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","হারোণ তাদের উত্তর দিলেন, “তোমাদের স্ত্রী, ছেলে ও মেয়েরা যেসব সোনার কানের দুল পরে আছে, সেগুলি খুলে ফেলো ও আমার কাছে নিয়ে এসো।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","অতএব সব লোকজন তাদের সোনার কানের দুল খুলে ফেলল ও হারোণের কাছে এনে দিল। ");
INSERT INTO benobcv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","তারা তাঁর হাতে যা সঁপে দিল, সেগুলি তিনি গ্রহণ করলেন এবং ঢালাই করে এক যন্ত্রের সাহায্যে তিনি বাছুরের আকৃতিবিশিষ্ট একটি প্রতিমা তৈরি করে দিলেন। তখন তারা বলল, “হে ইস্রায়েল, এরাই তোমাদের সেই দেবতা, যারা মিশর থেকে তোমাদের বের করে এনেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","হারোণ যখন তা দেখলেন, তখন তিনি সেই বাছুরের সামনে একটি বেদি নির্মাণ করে দিলেন ও ঘোষণা করলেন, “আগামীকাল সদাপ্রভুর উদ্দেশে একটি উৎসব হবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","অতএব লোকজন পরদিন ভোরবেলায় উঠে পড়ল এবং হোমবলি উৎসর্গ করল ও মঙ্গলার্থক বলি নিবেদন করল। পরে তারা ভোজনপান করার জন্য বসে পড়ল, তারপর উঠে পরজাতীয়দের মতো হুল্লোড়ে মত্ত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","পরে সদাপ্রভু মোশিকে বললেন, “নিচে নেমে যাও, কারণ তোমার যে লোকদের তুমি মিশর থেকে বের করে এনেছ, তারা নীতিভ্রষ্ট হয়ে পড়েছে। ");
INSERT INTO benobcv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","আমি তাদের যে আদেশ দিয়েছিলাম তা থেকে তারা খুব তাড়াতাড়ি বিপথগামী হয়ে পড়েছে এবং নিজেদের জন্য তারা ঢালাই করে বাছুরের আকৃতিবিশিষ্ট একটি প্রতিমা তৈরি করেছে। সেটির সামনে তারা নতজানু হয়েছে এবং সেটির উদ্দেশে বলি উৎসর্গ করে বলেছে, ‘হে ইস্রায়েল, এরাই তোমার সেইসব দেবতা, যারা মিশর থেকে তোমাকে বের করে এনেছেন।’ ");
INSERT INTO benobcv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“আমি এই লোকদের দেখেছি,” সদাপ্রভু মোশিকে বললেন, “আর এরা খুব একগুঁয়ে লোক। ");
INSERT INTO benobcv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","এখন আমার কাজে হস্তক্ষেপ কোরো না, যেন এদের বিরুদ্ধে আমি ক্রোধে ফেটে পড়তে পারি ও যেন এদের আমি ধ্বংস করে ফেলতে পারি। পরে আমি তোমাকে এক মহাজাতিতে পরিণত করব।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","কিন্তু মোশি তাঁর ঈশ্বর সদাপ্রভুর অনুগ্রহ চাইলেন, “হে সদাপ্রভু,” তিনি বললেন, “তুমি কেন তোমার সেই প্রজাদের বিরুদ্ধে ক্রোধে ফেটে পড়বে, যাদের তুমি মহাশক্তিতে ও বলশালী এক হাত দিয়ে মিশর থেকে বের করে এনেছ? ");
INSERT INTO benobcv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","মিশরীয়রা কেন বলবে, ‘মন্দ উদ্দেশ্য নিয়ে, পাহাড়-পর্বতে তাদের হত্যা করার এবং পৃথিবীর বুক থেকে তাদের নিশ্চিহ্ন করে ফেলার জন্যই তিনি তাদের বের করে এনেছেন’? তোমার প্রচণ্ড ক্রোধ প্রশমিত করো; কোমল হও ও তোমার এই প্রজাদের উপর বিপর্যয় ডেকে এনো না। ");
INSERT INTO benobcv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","তোমার সেই দাস অব্রাহাম, ইস্‌হাক ও যাকোবকে স্মরণ করো, যাদের কাছে তুমি নিজের নামে শপথ করে বলেছিলে: ‘আমি তোমার বংশধরদের আকাশের তারার মতো অসংখ্য করে তুলব এবং আমি তোমার বংশধরদের এই সমগ্র দেশটি দেব, যেটি আমি তাদের দেওয়ার প্রতিজ্ঞা করলাম, এবং চিরকালের জন্য এই দেশটি তাদের উত্তরাধিকার হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","তখন সদাপ্রভু কোমল হলেন এবং তাঁর প্রজাদের উপর যে বিপর্যয় ডেকে আনার হুমকি তিনি দিয়েছিলেন, তা আর আনেননি। ");
INSERT INTO benobcv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","মোশি ঘুরে দাঁড়ালেন এবং বিধিনিয়মের সেই দুটি ফলক হাতে নিয়ে পাহাড় থেকে নিচে নেমে এলেন। সেই ফলকগুলির সামনে ও পিছনে, দুই দিকেই বিধিনিয়ম খোদাই করা ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ফলকগুলি ছিল ঈশ্বরের কাজ; রচনাটি ছিল ফলকগুলির উপর খোদাই করা ঈশ্বরের রচনা। ");
INSERT INTO benobcv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","যিহোশূয় যখন লোকজনের চিৎকার শুনলেন, তখন তিনি মোশিকে বললেন, “শিবিরে যুদ্ধের শব্দ হচ্ছে।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","মোশি উত্তর দিলেন: “এটি জয়ধ্বনির শব্দ নয়, এটি পরাজয়ের শব্দ নয়; আমি গানের শব্দ শুনতে পাচ্ছি।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","মোশি যখন শিবিরের কাছাকাছি এলেন, এবং সেই বাছুরটিকে ও নাচানাচি দেখলেন, তখন তিনি ক্রোধে ফেটে পড়লেন এবং তিনি ফলকগুলি হাত থেকে ছুঁড়ে ফেলে দিয়ে পর্বতের পাদদেশে সেগুলি ভেঙে টুকরো টুকরো করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","আর তিনি লোকদের তৈরি করা সেই বাছুরটি নিয়ে আগুনে পুড়িয়ে দিলেন; পরে তিনি সেটি পিষে গুঁড়ো করে, তা জলের উপর ছড়িয়ে দিলেন এবং ইস্রায়েলীদের তা পান করতে বাধ্য করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","তিনি হারোণকে বললেন, “এই লোকেরা তোমার কী করেছিল, যে তুমি তাদের দিয়ে এত বড়ো পাপ করালে?” ");
INSERT INTO benobcv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“হে আমার প্রভু, ক্রুদ্ধ হবেন না,” হারোণ উত্তর দিলেন। “আপনি তো জানেন এই লোকেরা কত দুষ্টতাপ্রবণ। ");
INSERT INTO benobcv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","তারা আমাকে বলল, ‘আমাদের জন্য এমন সব দেবতা তৈরি করে দিন, যারা আমাদের অগ্রগামী হবেন। যে মোশি আমাদের মিশর থেকে বের করে এনেছেন, তার কী হয়েছে তা আমরা জানি না।’ ");
INSERT INTO benobcv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","তাই আমি তাদের বললাম, ‘যার যার কাছে সোনার অলংকার আছে, সেগুলি খুলে ফেলো।’ তখন তারা আমাকে সেই সোনা দিয়েছিল, আর আমি সেগুলি আগুনে ফেলে দিয়েছিলাম, ও সেখান থেকে এই বাছুরটি বেরিয়ে এসেছে!” ");
INSERT INTO benobcv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","মোশি দেখলেন যে, লোকেরা যা খুশি তাই করছে এবং হারোণও তাদের লাগামছাড়া হতে দিয়েছেন ও এভাবে তাদের শত্রুদের কাছে উপহাসের পাত্রে পরিণত হয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","অতএব তিনি শিবিরের প্রবেশদ্বারে দাঁড়িয়ে বললেন, “যে কেউ সদাপ্রভুর স্বপক্ষে, সে আমার কাছে চলে এসো।” আর লেবীয়রা সবাই তাঁর কাছে এসে একত্রিত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","তখন তিনি তাদের বললেন, “ইস্রায়েলের ঈশ্বর সদাপ্রভু একথাই বলেন: ‘প্রত্যেকে নিজের নিজের দেহের পাশে একটি করে তরোয়াল বেঁধে নিক। শিবিরের এক প্রান্ত থেকে অন্য প্রান্ত পর্যন্ত সে আসা যাওয়া করুক, এবং প্রত্যেকে তার ভাই ও বন্ধু ও প্রতিবেশীকে হত্যা করুক।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","লেবীয়রা মোশির আদেশানুসারেই কাজ করল, আর সেদিন প্রায় 3,000 লোক মারা গেল। ");
INSERT INTO benobcv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","তখন মোশি বললেন, “আজ তোমরা সদাপ্রভুর উদ্দেশে পৃথক হলে, কারণ তোমরা তোমাদের নিজের ছেলে ও ভাইদের বিরুদ্ধে রুখে দাঁড়িয়েছ, এবং এই দিনে তিনি তোমাদের আশীর্বাদ করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","পরদিন মোশি লোকদের বললেন, “তোমরা মহাপাপ করেছ। কিন্তু আমি সদাপ্রভুর কাছে যাব; হয়তো আমি তোমাদের পাপের প্রায়শ্চিত্ত করতে পারব।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","অতএব মোশি সদাপ্রভুর কাছে ফিরে গিয়ে বললেন, “হায়, হায়, এই লোকেরা কী মহাপাপই না করেছে! তারা নিজেদের জন্য সোনার দেবতা তৈরি করেছে। ");
INSERT INTO benobcv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","কিন্তু এখন, দয়া করে এদের পাপ ক্ষমা করো—কিন্তু যদি না করো, তবে তোমার লেখা বই থেকে আমার নামটি মুছে ফেলো।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","সদাপ্রভু মোশিকে উত্তর দিলেন, “যে কেউ আমার বিরুদ্ধে পাপ করেছে, তারই নাম আমি আমার বই থেকে মুছে ফেলব। ");
INSERT INTO benobcv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","এখন যাও, যে স্থানের কথা আমি বলেছিলাম, লোকদের সেখানে নিয়ে যাও এবং আমার দূত তোমার অগ্রগামী হবেন। অবশ্য, যখন শাস্তি দেওয়ার সময় আসবে, তখন তাদের পাপের জন্য আমি তাদের শাস্তি দেব।” ");
INSERT INTO benobcv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","আর হারোণের তৈরি করা সেই বাছুরটিকে নিয়ে লোকেরা যা করেছিল সেজন্য সদাপ্রভু এক সংক্রামক মহামারি দ্বারা লোকদের আঘাত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","পরে সদাপ্রভু মোশিকে বললেন, “তুমি ও যাদের তুমি মিশর থেকে বের করে এনেছ, তারা সবাই এই স্থান ত্যাগ করে সেই দেশে যাও, যে দেশের বিষয়ে আমি অব্রাহাম, ইস্‌হাক, ও যাকোবের কাছে শপথ নিয়ে প্রতিজ্ঞা করে বলেছিলাম, ‘এটি আমি তোমার বংশধরদের দেব।’ ");
INSERT INTO benobcv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","তোমার আগে আগে আমি এক দূত পাঠাব এবং কনানীয়, ইমোরীয়, হিত্তীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়দের তাড়িয়ে দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","দুধ ও মধু প্রবাহিত সেই দেশে চলে যাও। কিন্তু আমি তোমাদের সাথে যাব না, কারণ তোমরা একগুঁয়ে লোক এবং পাছে পথে আমি তোমাদের ধ্বংস করে ফেলি।” ");
INSERT INTO benobcv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","লোকেরা যখন এই অসুখকর কথা শুনল, তখন তারা দুঃখ প্রকাশ করল এবং কেউই কোনও অলংকার পরল না। ");
INSERT INTO benobcv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","কারণ সদাপ্রভু মোশিকে বললেন, “ইস্রায়েলীদের বলো, ‘তোমরা একগুঁয়ে লোক। এক মুহূর্তের জন্যও যদি আমি তোমাদের সাথে যাই, তবে হয়তো আমি তোমাদের ধ্বংসই করে ফেলব। এখন তোমাদের অলংকারগুলি খুলে ফেলো এবং আমিই ঠিক করব তোমাদের নিয়ে কী করতে হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","অতএব হোরেব পর্বতে ইস্রায়েলীরা তাদের গা থেকে অলংকারগুলি খুলে ফেলেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","আর মোশি একটি তাঁবু নিয়ে শিবিরের বাইরে কিছুটা দূরে তা খাটিয়ে দিলেন, ও সেটির নাম দিলেন “সমাগম তাঁবু।” যে কেউ সদাপ্রভুর কাছে কিছু জানতে চাইত, সে শিবিরের বাইরে সমাগম তাঁবুর কাছে যেত। ");
INSERT INTO benobcv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","আর যখনই মোশি সেই তাঁবুর কাছে যেতেন, সব লোকজন উঠে তাদের তাঁবুগুলির প্রবেশদ্বারে দাঁড়িয়ে পড়ত, ও যতক্ষণ না মোশি সেই তাঁবুতে প্রবেশ করতেন, ততক্ষণ তাঁর উপর নজর রাখত। ");
INSERT INTO benobcv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","মোশি যেই না সেই তাঁবুর ভিতরে প্রবেশ করতেন, মেঘস্তম্ভ নেমে আসত ও যতক্ষণ সদাপ্রভু মোশির সাথে কথা বলতেন, ততক্ষণ তা সেই প্রবেশদ্বারে অবস্থান করত। ");
INSERT INTO benobcv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","যখনই লোকেরা সেই মেঘস্তম্ভটিকে তাঁবুর প্রবেশদ্বারে অবস্থান করতে দেখত, তখনই তারা প্রত্যেকে নিজেদের তাঁবুর প্রবেশদ্বারে দাঁড়িয়ে আরাধনা করত। ");
INSERT INTO benobcv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","একজন বন্ধু যেভাবে তার বন্ধুর সাথে কথা বলে, সদাপ্রভুও মোশির সাথে সেভাবে মুখোমুখি কথা বলতেন। পরে মোশি নিজের তাঁবুতে ফিরে আসতেন, কিন্তু নূনের ছেলে যিহোশূয়—তাঁর তরুণ সহায়ক, সেই তাঁবু ত্যাগ করতেন না। ");
INSERT INTO benobcv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","মোশি সদাপ্রভুকে বললেন, “তুমি আমাকে বলে চলেছ, ‘এই লোকদের নেতৃত্ব দাও,’ কিন্তু তুমি আমাকে জানতে দাওনি আমার সাথে তুমি কাকে পাঠাবে। তুমি বলেছ, ‘আমি তোমাকে নাম ধরে চিনি এবং তুমি আমার দৃষ্টিতে অনুগ্রহ লাভ করেছ।’ ");
INSERT INTO benobcv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","আমি যদি তোমাকে খুশি করতে পেরেছি, তবে তোমার পথের বিষয়ে আমাকে শিক্ষা দাও যেন আমি তোমাকে জানতে পারি ও অবিরতভাবে তোমার দৃষ্টিতে অনুগ্রহ পেতেই থাকি। মনে রেখো যে এই জাতি তোমারই প্রজা।” ");
INSERT INTO benobcv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","সদাপ্রভু উত্তর দিলেন, “আমার উপস্থিতি তোমার সাথেই যাবে, এবং আমি তোমাকে বিশ্রাম দেব।” ");
INSERT INTO benobcv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","তখন মোশি তাঁকে বললেন, “তোমার উপস্থিতি যদি আমাদের সাথে না যায়, তবে এখান থেকে আমাদের পাঠিয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","তুমি যদি আমাদের সাথে না যাও তবে কেউ কীভাবে জানবে যে আমি ও তোমার প্রজারা তোমাকে খুশি করতে পেরেছি? আর কী-ই বা আমাকে ও তোমার প্রজাদের এই পৃথিবীর অন্যান্য সব মানুষজনের থেকে ভিন্ন করে তুলবে?” ");
INSERT INTO benobcv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","আর সদাপ্রভু মোশিকে বললেন, “তুমি যা চেয়েছ, আমি ঠিক তাই করব, কারণ তুমি আমাকে খুশি করেছ এবং আমি তোমাকে নাম ধরে চিনি।” ");
INSERT INTO benobcv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","তখন মোশি বললেন, “তোমার মহিমা এখন আমাকে দেখাও।” ");
INSERT INTO benobcv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","আর সদাপ্রভু বললেন, “আমি আমার সব চমৎকারিত্ব তোমার সামনে দিয়ে পার হতে দেব, এবং তোমার উপস্থিতিতে আমি আমার সেই সদাপ্রভু নামটি ঘোষণা করব। যার প্রতি আমি দয়া দেখাতে চাই, তার প্রতি আমি দয়া দেখাব, এবং যার প্রতি করুণা করতে চাই, তার প্রতি করুণা করব। ");
INSERT INTO benobcv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","কিন্তু,” তিনি বললেন, “তুমি আমার মুখ দেখতে পাবে না; কারণ কেউ আমাকে দেখে বেঁচে থাকে না।” ");
INSERT INTO benobcv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","পরে সদাপ্রভু বললেন, “আমার কাছাকাছি একটি স্থান আছে যেখানে তুমি পাষাণ-পাথরের উপরে গিয়ে দাঁড়াতে পারো। ");
INSERT INTO benobcv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","আমার মহিমা যখন পার হবে, তখন আমি তোমাকে সেই পাষাণ-পাথরের এক ফাটলে রেখে দেব এবং যতক্ষণ না আমি পার হয়ে যাচ্ছি ততক্ষণ তোমাকে আমি আমার হাত দিয়ে ঢেকে রাখব। ");
INSERT INTO benobcv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","পরে আমি আমার হাত সরিয়ে নেব ও তুমি আমার পিঠ দেখতে পাবে; কিন্তু আমার মুখ দেখা যাবে না।” ");
INSERT INTO benobcv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","সদাপ্রভু মোশিকে বললেন, “প্রথম দুটির মতো আরও দুটি পাথরের ফলক খোদাই করো, এবং তুমি যে ফলকগুলি ভেঙে ফেলেছিলে, সেগুলিতে যা যা লেখা ছিল আমি এগুলিতেও সেসব কথা লিখে দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","সকালবেলায় তৈরি থেকো, ও পরে সীনয় পর্বতে উঠে এসো। সেই পর্বতের চূড়ায় সেখানে আমার কাছে উপস্থিত হোয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","কেউ যেন তোমার সাথে না আসে বা সেই পর্বতে কোথাও যেন কাউকে দেখা না যায়; এমনকি সেই পর্বতের সামনে মেষপাল ও পশুপালও যেন না চরে।” ");
INSERT INTO benobcv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","অতএব মোশি সদাপ্রভুর আজ্ঞানুসারে প্রথম দুটি ফলকের মতো আরও দুটি পাথরের ফলক খোদাই করলেন এবং খুব সকালবেলায় সীনয় পর্বতে উঠে গেলেন; এবং তিনি সেই পাথরের ফলক দুটিও হাতে করে তুলে নিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","তখন সদাপ্রভু মেঘে নিচে নেমে এলেন এবং মোশির সাথে সেখানে দাঁড়িয়ে থেকে, সদাপ্রভু—তাঁর এই নাম ঘোষণা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","আর তিনি একথা ঘোষণা করতে করতে মোশির সামনে দিয়ে পার হয়ে গেলেন, “সদাপ্রভু, সদাপ্রভু, তিনি করুণাময় ও অনুগ্রহকারী ঈশ্বর, ক্রোধে ধীর, প্রেম ও বিশ্বস্ততায় সমৃদ্ধ, ");
INSERT INTO benobcv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","হাজার হাজার জনের প্রতি প্রেম প্রদর্শনকারী, এবং দুষ্টতা, বিদ্রোহ ও পাপ ক্ষমাকারী। তবুও অপরাধীকে শাস্তি না দিয়ে তিনি ছেড়ে দেন না; তৃতীয় ও চতুর্থ প্রজন্ম পর্যন্ত তিনি বাবা-মার পাপের জন্য তাদের সন্তানদের ও নাতি-নাতনিদের শাস্তি দেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","মোশি তৎক্ষণাৎ মাটিতে মাথা নত করে আরাধনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“হে প্রভু,” তিনি বললেন, “আমি যদি তোমার দৃষ্টিতে অনুগ্রহ পেয়ে থাকি, তবে প্রভু যেন আমাদের সাথে যান। এরা যদিও একগুঁয়ে লোক, তাও আমাদের দুষ্টতা ও আমাদের পাপ ক্ষমা করো, এবং আমাদের তোমার উত্তরাধিকার করে নাও।” ");
INSERT INTO benobcv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","তখন সদাপ্রভু বললেন: “আমি তোমার সঙ্গে এক নিয়ম স্থির করছি। তোমার সব লোকজনের সামনে আমি এমন সব আশ্চর্য কাজ করব যা সমগ্র পৃথিবীতে কোনও জাতির মধ্যে আগে কখনও করা হয়নি। যেসব লোকজনের মধ্যে তুমি বসবাস করছ, তারা দেখবে আমি, সদাপ্রভু তোমার জন্য যে কাজ করব, তা কতই না অসাধারণ। ");
INSERT INTO benobcv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","আজ আমি তোমাকে যে আদেশ দিচ্ছি, তা পালন কোরো। আমি তোমার সামনে থেকে ইমোরীয়, কনানীয়, হিত্তীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়দের তাড়িয়ে দেব। ");
INSERT INTO benobcv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","সাবধান, যে দেশে তুমি যাচ্ছ, সেখানে বসবাসকারী লোকদের সঙ্গে কোনও চুক্তি কোরো না, তা না হলে তারা তোমাদের মধ্যে এক ফাঁদ হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","তাদের বেদিগুলি ভেঙে দিয়ো, তাদের পবিত্র পাথরগুলি চূর্ণবিচূর্ণ করে দিয়ো ও তাদের আশেরা-খুঁটিগুলি কেটে নামিয়ে দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","অন্য আর কোনও দেবতার আরাধনা কোরো না, কারণ যাঁর নাম ঈর্ষাপরায়ণ, সেই সদাপ্রভু ঈর্ষান্বিত ঈশ্বর। ");
INSERT INTO benobcv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“সাবধান, সেই দেশে বসবাসকারী লোকদের সঙ্গে চুক্তি কোরো না; কারণ তারা যখন তাদের দেবতাদের কাছে বেশ্যাবৃত্তি করবে ও তাদের উদ্দেশে বলি উৎসর্গ করবে, তখন তারা তোমাকে আমন্ত্রণ জানাবে ও তুমি তাদের বলি দেওয়া প্রসাদ খেয়ে ফেলবে। ");
INSERT INTO benobcv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","আর তুমি যখন তোমার ছেলেদের জন্য স্ত্রীরূপে তাদের মেয়েদের মধ্যে কয়েকজনকে মনোনীত করবে এবং সেই মেয়েরা তাদের দেবতাদের কাছে বেশ্যাবৃত্তি করবে, তখন তারা তোমার ছেলেদেরও একই কাজ করতে বাধ্য করবে। ");
INSERT INTO benobcv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“কোনও প্রতিমা তৈরি কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“খামিরবিহীন রুটির উৎসব পালন কোরো। তোমাকে দেওয়া আদেশানুসারে, সাত দিন খামিরবিহীন রুটি খেয়ো। আবীব মাসের নির্দিষ্ট সময়ে এরকম কোরো, কারণ সেই মাসেই তুমি মিশর থেকে বের হয়ে এসেছিলে। ");
INSERT INTO benobcv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“প্রত্যেকটি গর্ভের প্রথম সন্তানটি আমার, এবং তোমার গৃহপালিত পশুপালের প্রথমজাত সব মদ্দাও আমার, তা সে গোপাল বা মেষপাল, যাই হোক না কেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","প্রথমজাত গাধাকে এক মেষশাবক দিয়ে মুক্ত কোরো, কিন্তু যদি তা মুক্ত না করো, তবে সেটির ঘাড় ভেঙে দিয়ো। তোমার সব প্রথমজাত ছেলেকে মুক্ত কোরো। “কেউ যেন খালি হাতে আমার সামনে উপস্থিত না হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ছয় দিন তুমি পরিশ্রম কোরো, কিন্তু সপ্তম দিন বিশ্রাম নিয়ো; এমনকি চাষ করার ও ফসল কাটার সময়েও তোমাকে বিশ্রাম নিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“কাটা গমের অগ্রিমাংশ নিয়ে সাত সপ্তাহের উৎসব, এবং বছর ঘুরে এলে ফল সংগ্রহের উৎসবও পালন কোরো। ");
INSERT INTO benobcv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","বছরে তিনবার তোমাদের সব পুরুষকে ইস্রায়েলের ঈশ্বর, সার্বভৌম সদাপ্রভুর সামনে উপস্থিত হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","আমি তোমার সামনে থেকে জাতিদের তাড়িয়ে দেব এবং তোমার এলাকা সম্প্রসারিত করব, এবং তুমি যখন বছরে তিনবার তোমার ঈশ্বর সদাপ্রভুর সামনে উপস্থিত হতে যাবে, তখন কেউ তোমার জমিজায়গার উপর লোভ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“খামিরযুক্ত কোনো কিছু সমেত আমার উদ্দেশে বলির রক্ত উৎসর্গ কোরো না, এবং নিস্তারপর্বীয় উৎসবের কোনও নৈবেদ্য সকাল পর্যন্ত পড়ে থাকতে দিয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“তোমার জমির সেরা প্রথম ফলটি তোমার ঈশ্বর সদাপ্রভুর গৃহে নিয়ে এসো। “ছাগ-শিশুকে তার মায়ের দুধে রান্না কোরো না।” ");
INSERT INTO benobcv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","পরে সদাপ্রভু মোশিকে বললেন, “এসব কথা লিখে ফেলো, কারণ এই কথাগুলির আধারে আমি তোমার সাথে ও ইস্রায়েলের সাথে এক নিয়ম স্থির করেছি।” ");
INSERT INTO benobcv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","রুটি না খেয়ে ও জলপান না করে মোশি সেখানে চল্লিশ দিন ও চল্লিশ রাত সদাপ্রভুর সাথে ছিলেন। আর সেই ফলকের উপর তিনি নিয়মের সেই কথাগুলি—দশাজ্ঞাটি লিখলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","মোশি যখন বিধিনিয়মের সেই দুটি ফলক হাতে নিয়ে সীনয় পর্বত থেকে নেমে এলেন, তখন তিনি জানতেই পারেননি যে যেহেতু তিনি সদাপ্রভুর সাথে কথা বলেছিলেন তাই তাঁর মুখটি উজ্জ্বল হয়ে উঠেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","হারোণ ও ইস্রায়েলীরা সবাই যখন মোশিকে দেখেছিল, তখন তাঁর মুখটি উজ্জ্বল দেখাচ্ছিল, এবং তারা তাঁর কাছে আসতে ভয় পেল। ");
INSERT INTO benobcv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","কিন্তু মোশি তাঁদের ডাক দিলেন; অতএব হারোণ ও সমাজের নেতারা সবাই তাঁর কাছে ফিরে এলেন, এবং মোশি তাঁদের সাথে কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","পরে ইস্রায়েলীরা সবাই তাঁর কাছে এল, এবং সদাপ্রভু সীনয় পর্বতে তাঁকে যেসব আদেশ দিয়েছিলেন তা তিনি তাদের জানালেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","মোশি তাদের কাছে সব কথা বলে শেষ করার পর, তিনি তাঁর মুখে একটি আবরণ দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","কিন্তু যখনই তিনি সদাপ্রভুর সাথে কথা বলার জন্য তাঁর উপস্থিতিতে প্রবেশ করতেন, বের হয়ে না আসা পর্যন্ত তিনি সেই আবরণ সরিয়ে রাখতেন। আর যখনই তিনি বাইরে বেরিয়ে এসে ইস্রায়েলীদের বলতেন তাঁকে কী কী আদেশ দেওয়া হয়েছে, ");
INSERT INTO benobcv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","তখনই তারা দেখত যে তাঁর মুখ উজ্জ্বল হয়ে আছে। তখন মোশি যতক্ষণ না সদাপ্রভুর সাথে কথা বলার জন্য ভিতরে যেতেন ততক্ষণ তাঁর মুখে একটি আবরণ দিয়ে রাখতেন। ");
INSERT INTO benobcv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","মোশি সমগ্র ইস্রায়েলী সমাজকে একত্রিত করলেন এবং তাদের বললেন, “সদাপ্রভু তোমাদের এরকম করার আদেশ দিয়েছেন: ");
INSERT INTO benobcv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ছয় দিন কাজ করা যাবে, কিন্তু সপ্তম দিনটি তোমাদের জন্য পবিত্র দিন, সদাপ্রভুর উদ্দেশে সাব্বাথের এক বিশ্রামবার হবে। যে কেউ এদিন কোনও কাজ করবে তাকে মেরে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","সাব্বাথবারে তোমাদের কোনও বাড়িতে আগুন জ্বালিয়ো না।” ");
INSERT INTO benobcv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","মোশি সমগ্র ইস্রায়েল সমাজকে বললেন, “সদাপ্রভু তোমাদের এরকম করার আদেশ দিয়েছেন: ");
INSERT INTO benobcv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","তোমাদের কাছে যা আছে তা থেকে সদাপ্রভুর জন্য এক উপহার নিয়ো। যে কেউ ইচ্ছুক, সে সদাপ্রভুর উদ্দেশে এক উপহাররূপে এগুলি আনুক: “সোনা, রুপো ও ব্রোঞ্জ; ");
INSERT INTO benobcv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো এবং মিহি মসিনা; ছাগলের লোম; ");
INSERT INTO benobcv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","লাল রং করা মেষের ছাল এবং অন্য এক ধরনের টেকসই চামড়া; বাবলা কাঠ; ");
INSERT INTO benobcv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","আলোর জন্য জলপাই তেল; অভিষেক করার উপযোগী তেলের জন্য ও সুগন্ধি ধূপের জন্য মশলাপাতি; ");
INSERT INTO benobcv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","এবং এফোদ ও বুকপাটার উপরে বসানোর জন্য স্ফটিকমণি ও অন্যান্য মণিরত্ন। ");
INSERT INTO benobcv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“তোমাদের মধ্যে যারা দক্ষ কারিগর, তাদের এগিয়ে আসতে হবে ও সদাপ্রভুর আদেশানুসারে সবকিছু করতে হবে: ");
INSERT INTO benobcv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“আবাস এবং সেটির তাঁবু ও সেটির আচ্ছাদন, আঁকড়া, কাঠামো, আগল, খুঁটি ও ভিতগুলি; ");
INSERT INTO benobcv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","সিন্দুক ও সেটির খুঁটিগুলি এবং প্রায়শ্চিত্ত-আচ্ছাদন ও সেটিকে আড়াল করে থাকা পর্দা; ");
INSERT INTO benobcv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","টেবিল ও সেটির খুঁটিগুলি এবং সেটির সব উপকরণ ও দর্শন-রুটি; ");
INSERT INTO benobcv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","আলো দেওয়ার জন্য দীপাধার ও সেটির আনুষঙ্গিক উপকরণ, প্রদীপ ও আলোর জন্য তেল; ");
INSERT INTO benobcv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ধূপবেদি ও সেটির খুঁটিগুলি, অভিষেক-তেল ও সুগন্ধি ধূপ; সমাগম তাঁবুর প্রবেশদ্বারে দরজার জন্য পর্দা; ");
INSERT INTO benobcv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","হোমবলির বেদি ও সেটির ব্রোঞ্জের জাফরি, সেটির খুঁটিগুলি ও সেটির সব পাত্র; ব্রোঞ্জের গামলা ও সেটির মাচা; ");
INSERT INTO benobcv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","প্রাঙ্গণের পর্দাগুলি ও সেখানকার খুঁটি ও ভিতগুলি, এবং প্রাঙ্গণের প্রবেশদ্বারের জন্য পর্দা; ");
INSERT INTO benobcv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","সমাগম তাঁবুর ও প্রাঙ্গণের জন্য তাঁবু-খুটা এবং সেগুলির দড়াদড়ি; ");
INSERT INTO benobcv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","হাতে বোনা যে পোশাক পরে পবিত্রস্থানে পরিচর্যা করতে হত, সেগুলি ও যাজক হারোণের জন্য পবিত্র পোশাক এবং যাজকরূপে সেবা করার সময় তাঁর ছেলেদের যে পোশাকগুলি পরে, সেই পোশাকগুলিও।” ");
INSERT INTO benobcv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","পরে সমগ্র ইস্রায়েলী সমাজ মোশির কাছ থেকে চলে গেল, ");
INSERT INTO benobcv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","এবং যে যে ইচ্ছুক হল ও যাদের অন্তর তোলপাড় হল, তারা প্রত্যেকে এগিয়ে এল এবং সমাগম তাঁবুর জন্য, সেখানকার সব সেবাকাজের জন্য, ও পবিত্র পোশাকগুলির জন্য সদাপ্রভুর কাছে এক উপহার নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","পুরুষ-স্ত্রী নির্বিশেষে যারা যারা ইচ্ছুক হল, তারা এগিয়ে এল এবং সব ধরনের সোনার অলংকার নিয়ে এল: বালা, কানের দুল, আংটি ও গয়নাগাটি। তারা সবাই তাদের সোনাদানা সদাপ্রভুর উদ্দেশে এক দোলনীয়-নৈবেদ্যরূপে উৎসর্গ করল। ");
INSERT INTO benobcv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","যার যার কাছে নীল, বেগুনি বা টকটকে লাল রংয়ের সুতো অথবা মিহি মসিনা, বা ছাগলের লোম, লাল রং করা মেষচর্ম অথবা অন্যান্য টেকসই চামড়া ছিল, তারা প্রত্যেকে সেগুলি নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","যারা যারা রুপো বা ব্রোঞ্জের উপহার উৎসর্গ করল, সদাপ্রভুর উদ্দেশেই তারা সেটি নিয়ে এল, এবং যাদের কাছে যে কোনো কাজে ব্যবহারের উপযোগী বাবলা কাঠ ছিল তারা প্রত্যেকেই তা নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","এক একজন দক্ষ মহিলা নিজের হাতে সুতো কেটেছিল ও নীল, বেগুনি বা টকটকে লাল রংয়ের সুতো অথবা মিহি মসিনা—যা কেটেছিল তাই আনল। ");
INSERT INTO benobcv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","আর যেসব মহিলা ইচ্ছুক হল ও যাদের সেই দক্ষতা ছিল, তারা ছাগলের লোম দিয়ে সুতো কেটেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","নেতারা এফোদ ও বুকপাটায় বসানোর জন্য স্ফটিকমণি ও অন্যান্য মণিরত্ন আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","এছাড়াও তারা আলোর জন্য এবং অভিষেক-তেলের জন্য ও সুগন্ধি ধূপের জন্য মশলাপাতি ও জলপাই তেল আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","যেসব ইস্রায়েলী স্ত্রী-পুরুষ ইচ্ছুক হল, তারা মোশির মাধ্যমে সদাপ্রভু তাঁর জন্য তাদের যেসব কাজ করার আদেশ দিয়েছিলেন, তা করার জন্য সদাপ্রভুর কাছে স্বেচ্ছাদান নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","পরে মোশি ইস্রায়েলীদের বললেন, “দেখো, সদাপ্রভু যিহূদা গোষ্ঠীভুক্ত হূরের নাতি তথা ঊরির ছেলে বৎসলেলকে মনোনীত করেছেন, ");
INSERT INTO benobcv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","এবং তিনি তাকে ঈশ্বরের আত্মায়, প্রজ্ঞায়, বুদ্ধিতে, জ্ঞানে এবং সব ধরনের দক্ষতায় পরিপূর্ণ করেছেন— ");
INSERT INTO benobcv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","যেন সে সোনা, রুপো ও ব্রোঞ্জ দিয়ে শিল্পবোধসম্পন্ন নকশা ফুটিয়ে তোলে, ");
INSERT INTO benobcv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","মণিরত্ন কেটে বসায়, কাঠের কাজ করে এবং সব ধরনের শিল্পবোধসম্পন্ন কারুশিল্পের কাজে লিপ্ত হয়। ");
INSERT INTO benobcv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","আর তিনি তাকে ও দান গোষ্ঠীভুক্ত অহীষামকের ছেলে অহলীয়াব, এই দুজনকেই অন্যান্য মানুষজনকে শিক্ষা দেওয়ার ক্ষমতা দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","তিনি তাদের ও তাঁতিদের খোদাইকারী, নকশাকার ও সূচিশিল্পীরূপে নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো ও মিহি মসিনা দিয়ে সব ধরনের কাজ করার দক্ষতায় পরিপূর্ণ করেছেন—তারা সবাই দক্ষ কারিগর ও নকশাকার। ");
INSERT INTO benobcv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","অতএব ঠিক কীভাবে সদাপ্রভুর আদেশানুসারে পবিত্রস্থান নির্মাণ-সংক্রান্ত সব কাজ সম্পন্ন করতে হবে তা জানার জন্য সদাপ্রভু বৎসলেলকে, অহলীয়াবকে ও প্রত্যেক দক্ষ লোককে দক্ষতা ও সামর্থ্য দিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","পরে মোশি সেই বৎসলেল ও অহলীয়াব এবং দক্ষ এক একজন লোককে ডেকে পাঠালেন, যাদের সদাপ্রভু সামর্থ্য দিয়েছিলেন ও যারা এসে কাজ করতে ইচ্ছুক হল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","পবিত্রস্থান নির্মাণ-সংক্রান্ত কাজটি সম্পন্ন করার জন্য ইস্রায়েলীরা যেসব উপহার এনেছিল, মোশির হাত থেকে তাঁরা সেগুলি গ্রহণ করলেন। আর লোকেরা প্রতিদিন সকালবেলায় অব্যাহতভাবে স্বেচ্ছাদান এনেই যাচ্ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","অতএব যেসব দক্ষ কারিগর পবিত্রস্থানের সব কাজকর্ম করছিল, তারা নিজেদের কাজ থামিয়ে ");
INSERT INTO benobcv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","মোশির কাছে এসে বলল, “সদাপ্রভু যে কাজ করার আদেশ দিয়েছেন তা করার জন্য যা দরকার, লোকেরা তার চেয়েও বেশি উপকরণ নিয়ে এসেছে।” ");
INSERT INTO benobcv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","তখন মোশি এক আদেশ জারি করলেন এবং তারা শিবিরের সর্বত্র একথা ঘোষণা করে দিলেন: “কোনও স্ত্রী বা পুরুষ যেন পবিত্রস্থানের জন্য এক উপহাররূপে আর কিছু না আনে।” আর তাই লোকেরা আরও বেশি কিছু আনা থেকে ক্ষান্ত হল, ");
INSERT INTO benobcv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","যেহেতু তাদের কাছে ইতিমধ্যেই যা ছিল, তা সব কাজ করার পক্ষে প্রয়োজনের তুলনায় অতিরিক্তই ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","কারিগরদের মধ্যে যাঁরা দক্ষ ছিলেন, তাঁরা পাকা হাতে মিহি পাকান মসিনা ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতোয় তৈরি দশটি পর্দায় করূবদের নকশা ফুটিয়ে তুলে সমাগম তাঁবুটি তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","সব পর্দা একই মাপের—13 মিটার লম্বা ও 1.8 মিটার চওড়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","তাঁরা পাঁচটি পর্দা একসাথে জুড়ে দিলেন ও অন্য পাঁচটির ক্ষেত্রেও একই কাজ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","পরে তাঁরা এক পাটি পর্দায় এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত কিনারা ধরে ধরে নীল কাপড়ের ফাঁস তৈরি করলেন, এবং অন্য পাটি পর্দাতেও এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত একই কাজ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","এছাড়াও তাঁরা একটি পর্দায় পঞ্চাশটি ফাঁস ও অন্য পাটির শেষ প্রান্তের পর্দায় পঞ্চাশটি ফাঁস তৈরি করে দিলেন, এবং ফাঁসগুলি পরস্পরের মুখোমুখি ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","পরে তাঁরা সোনার পঞ্চাশটি আঁকড়া তৈরি করলেন এবং দুই পাটি পর্দা একসাথে বেঁধে রাখার জন্য সেগুলি ব্যবহার করলেন, যেন সমাগম তাঁবুটি অক্ষুণ্ণ থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","তাঁরা সমাগম তাঁবুটি ঢেকে রাখার জন্য ছাগ-লোমের মোট এগারোটি পর্দা তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","এগারোটি পর্দার সবকটি একই মাপের—14 মিটার লম্বা ও 1.8 মিটার চওড়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","তাঁরা পর্দাগুলির মধ্যে পাঁচটি একসাথে জুড়ে এক পাটি করলেন এবং অন্য ছটি জুড়ে আর এক পাটি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","পরে তাঁরা এক পাটি পর্দায় এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত কিনারা ধরে ধরে পঞ্চাশটি ফাঁস তৈরি করলেন এবং অন্য পাটি পর্দাতেও এক প্রান্ত থেকে আর এক প্রান্ত পর্যন্ত তা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","তাঁবুটি একসাথে অক্ষুণ্ণ অবস্থায় বেঁধে রাখার জন্য তাঁরা ব্রোঞ্জের পঞ্চাশটি আঁকড়া তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","পরে তাঁরা সেই তাঁবু ঢেকে রাখার জন্য মেষের চামড়া লাল রং করে, তা দিয়ে একটি আচ্ছাদন তৈরি করলেন, এবং সেটির উপর অন্য এক টেকসই চামড়া দিয়ে আরও একটি আচ্ছাদন তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","তাঁরা সমাগম তাঁবুর জন্য বাবলা কাঠ দিয়ে খাড়া কাঠামো তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","প্রত্যেকটি কাঠামো 4.5 মিটার করে লম্বা ও 68 সেন্টিমিটার করে চওড়া হল, ");
INSERT INTO benobcv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","এবং কাঠামোর বেরিয়ে থাকা অংশ দুটি পরস্পরের সমান্তরাল করে বসানো হল। এভাবেই তাঁরা সমাগম তাঁবুর সব কাঠামো তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","সমাগম তাঁবুর দক্ষিণ দিকের জন্য তাঁরা কুড়িটি কাঠামো তৈরি করলেন ");
INSERT INTO benobcv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","এবং সেগুলির তলায় দেওয়ার জন্য—প্রত্যেকটি কাঠামোর জন্য দুটি করে, ও প্রত্যেকটি বেরিয়ে থাকা অংশের তলায় একটি করে মোট চল্লিশটি রুপোর ভিত তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","অন্য দিকের, সমাগম তাঁবুর উত্তর দিকের জন্য তাঁরা কুড়িটি কাঠামো ");
INSERT INTO benobcv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","এবং প্রত্যেকটি কাঠামোর তলায় দুটি করে মোট চল্লিশটি রুপোর ভিত তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","শেষ প্রান্তের, অর্থাৎ, সমাগম তাঁবুর পশ্চিম প্রান্তের জন্য তাঁরা ছয়টি কাঠামো তৈরি করলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","এবং শেষ প্রান্তে সমাগম তাঁবুর কোণাগুলির জন্যও দুটি কাঠামো তৈরি হল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","এই দুই কোনায় কাঠামোগুলি নিচ থেকে একদম চূড়া পর্যন্ত দ্বিগুণ মাপের হল এবং একটিই চক্রে সেগুলি লাগানো হল; দুটি কোনা একইরকম ভাবে তৈরি করা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","অতএব সেখানে আটটি কাঠামো ও প্রত্যেকটি কাঠামোর তলায় দুটি করে—মোট ষোলোটি রুপোর ভিত ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","এছাড়াও তাঁরা বাবলা কাঠের আগল তৈরি করলেন: সমাগম তাঁবুর একদিকের কাঠামোগুলির জন্য পাঁচটি, ");
INSERT INTO benobcv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","অন্য দিকের কাঠামোগুলির জন্য পাঁচটি, এবং সমাগম তাঁবুর শেষ প্রান্তে, পশ্চিমদিকের কাঠামোগুলির জন্য পাঁচটি। ");
INSERT INTO benobcv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","তাঁরা এমনভাবে মধ্যবর্তী আগলটি তৈরি করলেন যে সেটি কাঠামোর মাঝখানে এক প্রান্ত থেকে অন্য প্রান্ত পর্যন্ত সম্প্রসারিত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","কাঠামোগুলি তাঁরা সোনা দিয়ে মুড়ে দিলেন এবং আগলগুলি ধরে রাখার জন্য সোনার আংটা তৈরি করলেন। আগলগুলিও তাঁরা সোনা দিয়ে মুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","তাঁরা নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো ও মিহি পাকান মসিনা দিয়ে একটি পর্দা তৈরি করলেন, এবং দক্ষ কারিগর দিয়ে তাতে করূবদের নকশা ফুটিয়ে তুললেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","সেটির জন্য তাঁরা বাবলা কাঠের চারটি খুঁটি তৈরি করলেন এবং সেগুলি সোনা দিয়ে মুড়ে দিলেন। সেগুলির জন্য তাঁরা সোনার আঁকড়া তৈরি করলেন এবং সেগুলির চারটি রুপোর ভিতও ঢালাই করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","তাঁবুর প্রবেশদ্বারের জন্য নীল, বেগুনি, টকটকে লাল রংয়ের সুতো এবং মিহি পাকান মসিনা দিয়ে একটি পর্দা তৈরি করলেন—যা হল একজন সূচিশিল্পীর হস্তকলা; ");
INSERT INTO benobcv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","এবং তাঁরা পাঁচটি খুঁটি ও সেগুলির জন্য আঁকড়াও তৈরি করলেন। তাঁরা খুঁটিগুলির চূড়া ও বেড়ীগুলি সোনা দিয়ে মুড়ে দিলেন এবং ব্রোঞ্জ দিয়ে সেগুলির পাঁচটি ভিত তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","বৎসলেল বাবলা কাঠ দিয়ে 1.1 মিটার লম্বা, 68 সেন্টিমিটার চওড়া, ও 68 সেন্টিমিটার উঁচু সিন্দুকটি তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ভিতরে ও বাইরে, দুই দিকেই তিনি সেটি খাঁটি সোনা দিয়ে মুড়ে দিলেন, এবং সেটির চারপাশে সোনা দিয়ে একটি ছাঁচ তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","সেটির জন্য তিনি সোনার চারটি কড়া ঢালাই করে দিলেন এবং সেগুলি সেটির চারটি পায়ায় বেঁধে দিলেন—দুটি আংটা একদিকে ও দুটি আংটা অন্যদিকে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","পরে তিনি বাবলা কাঠ দিয়ে খুঁটি তৈরি করলেন ও সেগুলি সোনা দিয়ে মুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","আর সিন্দুকটি বহন করার জন্য তিনি সেটির দুই পাশে রাখা আংটায় খুঁটিগুলি ঢুকিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","খাঁটি সোনা দিয়ে তিনি 1.1 মিটার লম্বা ও 68 সেন্টিমিটার চওড়া প্রায়শ্চিত্ত-আচ্ছাদন তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","পরে তিনি সেই আচ্ছাদনের দুই কিনারায় পিটানো সোনা দিয়ে দুটি করূব তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","একদিকের কিনারায় তিনি একটি করূব ও অন্যদিকে দ্বিতীয় করূবটি তৈরি করলেন; দুই কিনারায় আবরণ সমেত তিনি সেগুলি অখণ্ডিত রূপ দিয়েই তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","করূবেরা তাদের ডানাগুলি উপরের দিকে ছড়িয়ে দিয়েছিল, ও সেগুলি দিয়ে আবরণটি আড়াল করে রেখেছিল। করূবেরা পরস্পরের দিকে মুখ করে সেই আবরণের দিকে তাকিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","তাঁরা বাবলা কাঠ দিয়ে 90 সেন্টিমিটার লম্বা, 45 সেন্টিমিটার চওড়া ও 68 সেন্টিমিটার উঁচু টেবিলটি তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","পরে তাঁরা সেটি খাঁটি সোনা দিয়ে মুড়ে দিলেন এবং সেটির চারপাশে সোনার এক ছাঁচ তৈরি করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","এছাড়াও তাঁরা সেটির চারপাশে 7.5 সেন্টিমিটার চওড়া একটি চক্রবেড় তৈরি করলেন এবং সেই চক্রবেড়ে সোনার এক ছাঁচ বসিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","টেবিলের জন্য তাঁরা সোনার চারটি আংটা ঢালাই করে দিলেন এবং সেগুলি সেই চার কোনায় বেঁধে দিলেন, যেখানে চারটি পায়াও ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","টেবিল বহনের উদ্দেশে ব্যবহৃত খুঁটিগুলি ধরে রাখার জন্য সেই কড়াগুলি চক্রবেড়ের কাছাকাছি রাখা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","টেবিল বহনকারী খুঁটিগুলি বাবলা কাঠ দিয়ে তৈরি করা হল এবং সোনা দিয়ে মুড়ে দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","আর টেবিলের জন্য খাঁটি সোনা দিয়ে তাঁরা এইসব জিনিসপত্র—থালা ও বাটি ও গামলা ও পেয়-নৈবেদ্য ঢালার জন্য কলশিগুলি তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","তাঁরা খাঁটি সোনা দিয়ে দীপাধার তৈরি করলেন। পিটিয়ে পিটিয়ে তাঁরা সেটির ভিত ও হাতল তৈরি করলেন, এবং সেগুলির সাথে একই টুকরো দিয়ে ফুলের মতো দেখতে পেয়ালা, কুঁড়ি ও মুকুলগুলিও তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","সেই দীপাধারের দুই ধার থেকে একদিকে তিনটি ও অন্যদিকে তিনটি—মোট ছয়টি শাখা বের করা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","কুঁড়ি ও মুকুল সমেত কাগজি বাদামফুলের মতো দেখতে তিনটি পেয়ালা ছিল একটি শাখায়, ও অন্য তিনটি ছিল পরবর্তী শাখায় এবং দীপাধার থেকে বের হয়ে থাকা ছয়টি শাখাই একইরকম দেখতে হল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","আর দীপাধারে কুঁড়ি ও মুকুল সমেত কাগজি বাদামফুলের মতো দেখতে চারটি পানপাত্র ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","একটি কুঁড়ি ছিল দীপাধার থেকে বের হয়ে থাকা মোট ছয়টি শাখার মধ্যে প্রথম জোড়া শাখার তলায়, দ্বিতীয় কুড়িটি ছিল দ্বিতীয় জোড়ার তলায় এবং তৃতীয় কুড়িটি ছিল তৃতীয় জোড়ার তলায়। ");
INSERT INTO benobcv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","সবকটি কুঁড়ি ও শাখা সেই দীপাধারের সঙ্গে অখণ্ড ছিল, যা খাঁটি সোনা পিটিয়ে পিটিয়ে তৈরি করা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","খাঁটি সোনা দিয়ে তাঁরা সেটির সাতটি প্রদীপ, সেইসাথে সেটির পলতে ছাঁটার যন্ত্র ও বারকোশগুলিও তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","এক তালন্ত খাঁটি সোনা দিয়ে তাঁরা সেই দীপাধার ও সেটির সব আনুষঙ্গিক উপকরণ তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ধূপ জ্বালানোর জন্য তাঁরা বাবলা কাঠ দিয়ে একটি বেদি তৈরি করলেন। এটি ছিল বর্গাকার, 45 সেন্টিমিটার করে লম্বা ও চওড়া এবং 90 সেন্টিমিটার উঁচু—এর শিংগুলি এর সাথে একই টুকরো দিয়ে গড়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","তাঁরা সেই বেদির চূড়া ও সবদিক এবং শিংগুলি খাঁটি সোনা দিয়ে মুড়ে দিলেন, এবং এর চারপাশে সোনার এক ছাঁচ তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","তাঁরা বেদিটি বহন করার কাজে ব্যবহৃত খুঁটিগুলি ধরে রাখার জন্য সেই ছাঁচের তলায়—সামনাসামনি দুই দিকের জন্য দুটি দুটি করে—সোনার দুটি আংটা তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","বাবলা কাঠ দিয়ে তাঁরা খুঁটি তৈরি করলেন ও সেগুলি সোনা দিয়ে মুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","এছাড়াও তাঁরা পবিত্র অভিষেক-তেল ও খাঁটি সুগন্ধি ধূপ তৈরি করলেন—যা হল সুগন্ধি দ্রব্যাদি প্রস্তুতকারকের হস্তকলা। ");
INSERT INTO benobcv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","বাবলা কাঠ দিয়ে তাঁরা 1.4 মিটার উঁচু হোমবলির বেদি নির্মাণ করলেন; সেটি বর্গাকার, 2.3 মিটার করে লম্বা ও চওড়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","চারটি কোণের প্রত্যেকটিতে তাঁরা একটি করে শিং তৈরি করলেন, যেন শিংগুলি বেদির সাথে অখণ্ড হয়, এবং বেদিটি তাঁরা ব্রোঞ্জ দিয়ে মুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","সেটির সব পাত্র তাঁরা ব্রোঞ্জ দিয়ে তৈরি করলেন: হাঁড়ি, বেলচা, জল ছিটানোর গামলা, মাংস তোলার কাঁটাচামচ ও আগুনে সেঁকার চাটু। ");
INSERT INTO benobcv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","বেদির জন্য তাঁরা একটি জাফরি, ব্রোঞ্জের পরস্পরছেদী একটি জাল তৈরি করলেন, যা বেদির মাঝামাঝিতে, সেটির তাকের নিচে বসানো হল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ব্রোঞ্জের জাফরির চার কোণের খুঁটিগুলি ধরে রাখার জন্য তাঁরা ব্রোঞ্জের আংটা ঢালাই করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","বাবলা কাঠ দিয়ে তাঁরা খুঁটিগুলি তৈরি করলেন এবং সেগুলি ব্রোঞ্জ দিয়ে মুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","খুঁটিগুলি তাঁরা আংটায় ঢুকিয়ে দিলেন, যেন বেদি বহনের জন্য সেগুলি বেদির পাশেই থাকে। তাঁরা সেগুলি তক্তা দিয়ে, ফাঁপা করে তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","যেসব মহিলা সমাগম তাঁবুর প্রবেশদ্বারে সেবাকাজ করত, তাদের ব্যবহৃত আয়নাগুলি দিয়ে তাঁরা ব্রোঞ্জের গামলা ও সেটির মাচা তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","পরে তাঁরা প্রাঙ্গণটি তৈরি করলেন। দক্ষিণ দিকটি ছিল 45 মিটার লম্বা এবং সেখানে মিহি পাকান মসিনা দিয়ে তৈরি পর্দা, ");
INSERT INTO benobcv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","এবং কুড়িটি খুঁটি ও ব্রোঞ্জের কুড়িটি ভিত ছিল, ও খুঁটিগুলির উপরে রুপোর আঁকড়া ও বেড়ীও ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","উত্তর দিকটিও ছিল 45 মিটার লম্বা এবং সেখানে কুড়িটি খুঁটি ও ব্রোঞ্জের কুড়িটি ভিত ছিল, ও খুঁটিগুলির উপরে রুপোর আঁকড়া ও বেড়ীও ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","পশ্চিম দিকটি ছিল 23 মিটার চওড়া এবং সেখানে পর্দা, এবং দশটি খুঁটি ও দশটি ভিত, এবং খুঁটিগুলির উপরে রুপোর আঁকড়া ও বেড়ীও ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","সূর্যোদয়ের দিকে, পূর্ব দিকটিও ছিল 23 মিটার চওড়া। ");
INSERT INTO benobcv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","প্রবেশদ্বারের এক পাশে, তিনটি খুঁটি ও তিনটি ভিত সমেত 6.8 মিটার লম্বা পর্দা ছিল, ");
INSERT INTO benobcv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","এবং প্রাঙ্গণের প্রবেশদ্বারের অন্য দিকেও তিনটি খুঁটি ও তিনটি ভিত সমেত 6.8 মিটার লম্বা পর্দা ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","প্রাঙ্গণের চারপাশের সব পর্দা মিহি পাকান মসিনা দিয়ে তৈরি করা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","সব খুঁটির ভিতগুলি ব্রোঞ্জ দিয়ে তৈরি করা হল। খুঁটির উপরের আঁকড়া ও বেড়ীগুলি রুপো দিয়ে তৈরি করা হল, এবং খুঁটির চূড়াগুলি রুপো দিয়ে মুড়ে দেওয়া হল; অতএব প্রাঙ্গণের সব খুঁটিতে রুপোর বেড়ী ছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","প্রাঙ্গণের প্রবেশদ্বারের পর্দাটি নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো এবং মিহি পাকান মসিনা দিয়ে তৈরি করা হল—যা এক সূচিশিল্পীর হস্তকলা হল। সেটি 9 মিটার লম্বা এবং, প্রাঙ্গণের পর্দাগুলির মতো, 2.3 মিটার উঁচু হল, ");
INSERT INTO benobcv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","এবং সেটির সাথে চারটি খুঁটি ও ব্রোঞ্জের চারটি ভিতও ছিল। সেগুলির আঁকড়া ও বেড়ীগুলি রুপো দিয়ে তৈরি করা হল, এবং চূড়াগুলি রুপো দিয়ে মুড়ে দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","সমাগম তাঁবুর ও পার্শ্ববর্তী প্রাঙ্গণের সব তাঁবু-খুটা ব্রোঞ্জ দিয়ে তৈরি করা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","মোশির আদেশানুসারে, যাজক হারোণের ছেলে ঈথামরের নেতৃত্বে লেবীয়েরা সমাগম তাঁবুতে, বিধিনিয়মের সেই সমাগম তাঁবুতে ব্যবহারযোগ্য সামগ্রীর যে সংখ্যা নথিভুক্ত করলেন তা এইরকম। ");
INSERT INTO benobcv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন, সেইমতোই যিহূদা গোষ্ঠীভুক্ত হূরের নাতি ও ঊরির ছেলে বৎসলেল সবকিছু তৈরি করলেন; ");
INSERT INTO benobcv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","তাঁর সাথে ছিলেন দান গোষ্ঠীভুক্ত অহীষামকের ছেলে অহলীয়াব—যিনি এক ক্ষোদক ও নকশাকার, এবং নীল, বেগুনি ও টকটকে লাল রংয়ের সুতোর ও মিহি মসিনার কাজ জানা এক সূচিশিল্পী ছিলেন) ");
INSERT INTO benobcv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","পবিত্রস্থানের শেকল অনুসারে, পবিত্রস্থানের সব কাজে ব্যবহৃত দোলনীয়-নৈবেদ্য থেকে সংগৃহীত সোনার মোট পরিমাণ দাঁড়িয়েছিল 29 তালন্ত ও 730 শেকল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","পবিত্রস্থানের শেকল অনুসারে, সমাজভুক্ত যাদের সংখ্যা জনগণনায় স্থান পেয়েছিল, তাদের কাছ থেকে সংগৃহীত রুপোর পরিমাণ দাঁড়িয়েছিল 100 তালন্ত ও 1,775 শেকল— ");
INSERT INTO benobcv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","কুড়ি বছর ও ততোধিক বয়স্ক মোট 6,03,550 জন লোক, যারা গণিত হওয়ার জন্য পার হয়ে এসেছিল, তাদের মধ্যে প্রত্যেকের জন্য পবিত্রস্থানের শেকল অনুসারে এক বেকা, অর্থাৎ, আধ শেকল করে নেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","100 তালন্ত রুপো পবিত্রস্থানের ও পর্দার জন্য ভিত ঢালাইয়ের উদ্দেশে 100-টি ভিতের জন্য 100 তালন্ত, প্রত্যেকটি ভিতের জন্য এক এক তালন্ত রুপো ব্যবহৃত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","খুঁটির আঁকড়া তৈরি করার, খুঁটির চূড়া মুড়ে দেওয়ার, ও সেগুলির বেড়ী তৈরি করার জন্য তাঁরা 1,775 শেকল ব্যবহার করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","দোলনীয়-নৈবেদ্য থেকে সংগৃহীত ব্রোঞ্জের পরিমাণ হল 70 তালন্ত ও 2,400 শেকল। ");
INSERT INTO benobcv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","সেই ব্রোঞ্জ তারা সমাগম তাঁবুর প্রবেশদ্বারের ভিত, ব্রোঞ্জের বেদি ও সেটির সাথে যুক্ত ব্রোঞ্জের জাফরি এবং সেটির সব পাত্র, ");
INSERT INTO benobcv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","পার্শ্ববর্তী প্রাঙ্গণের ও সেটির প্রবেশদ্বারের ভিতগুলি এবং সমাগম তাঁবুর ও পার্শ্ববর্তী প্রাঙ্গণের জন্য তাঁবু-খুটা তৈরি করার কাজে ব্যবহার করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","পবিত্রস্থানে পরিচর্যা করার জন্য তারা নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো দিয়ে হাতে বোনা পোশাক তৈরি করলেন। এছাড়াও, সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন, সেই আদেশানুসারে তাঁরা হারোণের জন্য পবিত্র পোশাক তৈরি করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","তাঁরা সোনা, ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো, এবং মিহি পাকান মসিনা দিয়ে এফোদ তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","তাঁরা সোনা পিটিয়ে পিটিয়ে সরু পাত তৈরি করলেন এবং তা থেকে সুতো কেটে নীল, বেগুনি ও লাল রংয়ের সুতোয় ও মিহি মসিনায় গেঁথে দিলেন—যা দক্ষ হস্তকলা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","তাঁরা এফোদের জন্য কাঁধ-পটি তৈরি করলেন, ও এমনভাবে সেগুলি এফোদের দুটি কোণে জুড়ে দিলেন যেন তা বাঁধা থাকে। ");
INSERT INTO benobcv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","দক্ষতার সাথে বোনা কোমরবন্ধটিও এটির মতো করে তৈরি হল—এফোদের সাথেই জুড়ে থাকা একই ভাগ হবে এবং সোনা, ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো, এবং মিহি পাকান মসিনা দিয়ে, সদাপ্রভু মোশিকে যেমন আদেশ দিয়েছিলেন, সেরকমই হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","সোনার তারের সূক্ষ্ম কারুকার্যে স্ফটিকমণি বসিয়ে তাঁরা তাতে ইস্রায়েলের ছেলেদের নামগুলি সিলমোহরের মতো খোদাই করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন, সেই অনুসারে পরে তাঁরা ইস্রায়েলের ছেলেদের জন্য স্মারক-মণিরূপে সেগুলি এফোদের কাঁধ-পটিগুলিতে বেঁধে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","তাঁরা বুকপাটাটি তৈরি করলেন—যা দক্ষ এক কারিগরের কাজ হল। এফোদের মতো করেই তাঁরা সেটি তৈরি করলেন: সোনা, ও নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো, এবং মিহি পাকান মসিনা দিয়ে সেটি তৈরি করা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","সেটি বর্গাকার—23 সেন্টিমিটার করে লম্বা ও চওড়া হল—এবং তা দুই ভাঁজ করে রাখা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","পরে তাঁরা সেটির উপর চার সারি মূল্যবান মণিরত্ন বসিয়ে দিলেন। প্রথম সারিতে ছিল চুণী, গোমেদ ও পান্না; ");
INSERT INTO benobcv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","দ্বিতীয় সারিতে ছিল ফিরোজা, নীলা ও হীরা; ");
INSERT INTO benobcv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","তৃতীয় সারিতে ছিল নীলকান্তমণি, অকীক ও নীলা; ");
INSERT INTO benobcv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","চতুর্থ সারিতে ছিল পোখরাজ, স্ফটিকমণি ও সূর্যকান্তমণি। সেগুলি সোনার তারের সূক্ষ্ম কারুকার্য করা নকশার উপরে বসানো হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ইস্রায়েলের ছেলেদের প্রত্যেকের নামে একটি করে, মোট বারোটি মণিরত্ন নেওয়া হল, এবং প্রত্যেকটি মণি বারোটি গোষ্ঠীর মধ্যে এক এক গোষ্ঠীর নামে সিলমোহরের মতো খোদাই করে দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","বুকপাটাটির জন্য তাঁরা খাঁটি সোনা দিয়ে দড়ির মতো দেখতে পাতা-কাটা শিকল তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","তাঁরা সোনার তারের সূক্ষ্ম কারুকার্য করা দুটি নকশা ও সোনার দুটি আংটা তৈরি করলেন, এবং সেই আংটা দুটি বুকপাটার দুই কোণে বেঁধে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","তাঁরা সোনার সেই দুটি শিকল বুকপাটার কোণগুলিতে রাখা আংটাগুলিতে বেঁধে দিলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","এবং শিকলের অন্য প্রান্তগুলি নকশা দুটিতে বেঁধে দিয়ে, সেগুলি সামনের দিকে এফোদের কাঁধ-পটিতে জুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","তাঁরা সোনার দুটি আংটা তৈরি করলেন ও এফোদের পাশের বুকপাটার ভিতরদিকে অন্য দুই কোণে সেগুলি জুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","পরে তাঁরা সোনার আরও দুটি আংটা তৈরি করলেন এবং এফোদের কোমরবন্ধের ঠিক উপরে, যেখানে জোড়ের মুখের সেলাই পড়েছিল, তার কাছেই এফোদের সামনের দিকে কাঁধ-পটির তলায় সেগুলি জুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","নীল সুতো দিয়ে তাঁরা এফোদের আংটাগুলির সাথে বুকপাটার আংটাগুলি বেঁধে, সেটি কোমরবন্ধের সাথে জুড়ে দিলেন, যেন বুকপাটাটি নড়ে গিয়ে এফোদ থেকে খুলে না যায়—যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","তাঁরা পুরোপুরি নীল কাপড় দিয়েই তাঁতির কাজের মতো করে এফোদের আলখাল্লাটি তৈরি করলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","এবং সেই আলখাল্লার মাঝখানে মাথা ঢোকানোর মতো একটি ফাঁক, ও সেই ফাঁকের চারপাশে একটি বেড়ী রেখে দিলেন, যেন তা ছিঁড়ে না যায়। ");
INSERT INTO benobcv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","সেই আলখাল্লার আঁচল ধরে ধরে তাঁরা নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো ও মিহি পাকান মসিনা দিয়ে ডালিম তৈরি করে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","আর তাঁরা খাঁটি সোনা দিয়ে ঘণ্টা তৈরি করলেন এবং ডালিমগুলির মাঝে মাঝে আঁচলের চারপাশে সেগুলি জুড়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন সেই আদেশানুসারে, পরিচর্যা করার সময় যে আলখাল্লাটি পরতে হত, সেটির আঁচলের চারপাশে পর্যায়ক্রমিকভাবে ঘণ্টা ও ডালিমগুলি লাগানো হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","হারোণ ও তাঁর ছেলেদের জন্য, তাঁরা মিহি মসিনা দিয়ে তাঁতির কাজের মতো করে নিমা ");
INSERT INTO benobcv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","এবং মিহি মসিনা দিয়ে পাগড়ি, মসিনার টুপি ও মিহি পাকান মসিনা দিয়ে অন্তর্বাসগুলি তৈরি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন সেই আদেশানুসারে, একজন সূচিশিল্পীর হস্তকলার মতো করে মিহি পাকান মসিনা এবং নীল, বেগুনি ও টকটকে লাল রংয়ের সুতো দিয়ে উত্তরীয়টি তৈরি করা হল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","তাঁরা খাঁটি সোনা দিয়ে ফলক, সেই পবিত্র প্রতীকটি তৈরি করে, তাতে সিলমোহরে খোদাই করা লিপির মতো খোদাই করে লিখে দিলেন: সদাপ্রভুর উদ্দেশে পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন সেই আদেশানুসারে, পরে তাঁরা পাগড়ির সাথে সেটি জুড়ে রাখার জন্য তাতে একটি নীল সুতো বেঁধে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","অতএব আবাসের, সমাগম তাঁবুর সব কাজ সম্পূর্ণ হল। ইস্রায়েলীরা সবকিছু সেভাবেই করল, যেমনটি করার আদেশ সদাপ্রভু মোশিকে দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","পরে তারা সেই সমাগম তাঁবুটি মোশির কাছে নিয়ে এল: সেই তাঁবু ও সেটির সব আসবাবপত্র, সেটির আঁকড়া, কাঠামো, আগল, খুঁটি ও ভিতগুলি; ");
INSERT INTO benobcv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","লাল রং করা মেষচর্মের আচ্ছাদন এবং অন্য একটি টেকসই চামড়ার আচ্ছাদন ও আচ্ছাদক-পর্দা; ");
INSERT INTO benobcv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","খুঁটি ও প্রায়শ্চিত্ত-আচ্ছাদন সমেত বিধিনিয়মের সিন্দুক; ");
INSERT INTO benobcv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","সব উপকরণ সমেত টেবিল এবং দর্শন-রুটি; ");
INSERT INTO benobcv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","প্রদীপের সারি ও আনুষঙ্গিক উপকরণ সমেত খাঁটি সোনার দীপাধার, এবং আলোর জন্য জলপাই তেল; ");
INSERT INTO benobcv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","সোনার বেদি, অভিষেক-তেল, সুগন্ধি ধূপ, এবং তাঁবুর প্রবেশদ্বারের জন্য পর্দা; ");
INSERT INTO benobcv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ব্রোঞ্জের জাফরি সমেত ব্রোঞ্জের বেদি, সেটির খুঁটি ও সব পাত্র; গামলা ও সেটির মাচা; ");
INSERT INTO benobcv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","খুঁটি ও ভিত সমেত প্রাঙ্গণের পর্দাগুলি, এবং প্রাঙ্গণের প্রবেশদ্বারের পর্দা; প্রাঙ্গণের জন্য তাঁবু-খুটা ও দড়াদড়ি; আবাসের, সেই সমাগম তাঁবুর জন্য সব আসবাবপত্র; ");
INSERT INTO benobcv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","এবং হাতে বোনা যে পোশাক পরে পবিত্রস্থানে পরিচর্যা করতে হত, সেগুলি ও যাজক হারোণের জন্য পবিত্র পোশাক এবং যাজকরূপে সেবা করার সময় তাঁর ছেলেদের যে পোশাকগুলি পরতে হত, সেই পোশাকগুলিও। ");
INSERT INTO benobcv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","সদাপ্রভু মোশিকে যেমন আদেশ দিয়েছিলেন, ঠিক সেভাবেই ইস্রায়েলীরা সব কাজ করল। ");
INSERT INTO benobcv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","মোশি সেই কাজ পরিদর্শন করলেন এবং দেখলেন যে সদাপ্রভু যেমন আদেশ দিয়েছিলেন, ঠিক সেভাবেই তারা তা করেছে। তাই মোশি তাদের আর্শীবাদ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","পরে সদাপ্রভু মোশিকে বললেন: ");
INSERT INTO benobcv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“প্রথম মাসের প্রথম দিনে সমাগম তাঁবু, সেই আবাসটি প্রতিষ্ঠিত করো। ");
INSERT INTO benobcv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","বিধিনিয়মের সিন্দুকটি সেটির মধ্যে রেখে দাও এবং সিন্দুকটি পর্দা দিয়ে ঢেকে দাও। ");
INSERT INTO benobcv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","টেবিলটি এনে সেটির উপরে সব জিনিসপত্র সাজিয়ে রাখো। পরে দীপাধারটি এনে সেটির প্রদীপগুলি জ্বালিয়ে দাও। ");
INSERT INTO benobcv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","বিধিনিয়মের সিন্দুকটির সামনে সোনার ধূপবেদিটি এনে রাখো এবং সমাগম তাঁবুর প্রবেশদ্বারে পর্দা টাঙিয়ে দাও। ");
INSERT INTO benobcv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“সমাগম তাঁবুর, সেই আবাসের প্রবেশদ্বারের সামনে হোমবলির বেদিটি এনে রাখো; ");
INSERT INTO benobcv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","সমাগম তাঁবু ও বেদির মাঝখানে গামলাটি এনে রাখো এবং তাতে জল ভরে দাও। ");
INSERT INTO benobcv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","সেটির চারপাশের প্রাঙ্গণটি সাজিয়ে রাখো এবং সেই প্রাঙ্গণের প্রবেশদ্বারে পর্দা টাঙিয়ে দাও। ");
INSERT INTO benobcv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“অভিষেক-তেল নাও এবং সমাগম তাঁবু ও সেখানকার সবকিছু অভিষিক্ত করো; সেটি ও সেখানকার সব আসবাবপত্র পবিত্র করো, এবং তা পবিত্র হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","পরে হোমবলির বেদিটি ও সেটির সব পাত্র অভিষিক্ত করো; বেদিটি অভিষিক্ত করো, এবং তা মহাপবিত্র হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","গামলা ও সেটির মাচাটি অভিষিক্ত করো এবং সেগুলি পবিত্রও করো। ");
INSERT INTO benobcv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“হারোণ ও তার ছেলেদের সমাগম তাঁবুর প্রবেশদ্বারের কাছে নিয়ে এসো এবং তাদের জল দিয়ে স্নান করাও। ");
INSERT INTO benobcv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","পরে হারোণকে পবিত্র পোশাকগুলি পরিয়ে দাও, তাকে অভিষিক্ত করো এবং তাকে পবিত্র করো, যেন সে যাজকরূপে আমার সেবা করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","তার ছেলেদের নিয়ে এসো এবং তাদের নিমা পরাও। ");
INSERT INTO benobcv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","যেভাবে তাদের বাবাকে অভিষিক্ত করলে, ঠিক সেভাবে তাদেরও অভিষিক্ত করো, যেন তারা যাজকরূপে আমার সেবা করতে পারে। তাদের এই অভিষেক এমন এক যাজকত্বের জন্য হবে, যা তাদের বংশপরম্পরা ধরে চলতে থাকবে।” ");
INSERT INTO benobcv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন, ঠিক সেই অনুসারেই তিনি সবকিছু করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","অতএব দ্বিতীয় বছরের প্রথম মাসের প্রথম দিনে সমাগম তাঁবুটি প্রতিষ্ঠিত হল। ");
INSERT INTO benobcv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","মোশি যখন সমাগম তাঁবুটি প্রতিষ্ঠিত করলেন, তখন তিনি ভিতগুলি সঠিক স্থানে বসালেন, কাঠামোগুলি দাঁড় করালেন, আগলগুলি ঢুকিয়ে দিলেন এবং খুঁটিগুলি পুঁতে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","পরে তিনি সমাগম তাঁবুর উপরে তাঁবু বিছিয়ে দিলেন এবং তাঁবুর উপরে আবরণ দিলেন, ঠিক যেভাবে সদাপ্রভু তাঁকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","তিনি বিধিনিয়মের ফলকগুলি নিলেন এবং সেগুলি সিন্দুকে রেখে দিলেন, সেই সিন্দুকের সাথে খুঁটিগুলি জুড়ে দিলেন ও সেটির উপরে প্রায়শ্চিত্ত-আচ্ছাদনটি রেখে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","পরে তিনি সেই সিন্দুকটি সমাগম তাঁবুতে নিয়ে এলেন এবং আড়ালকারী পর্দাটি ঝুলিয়ে দিলেন ও বিধিনিয়মের সেই সিন্দুকটি আড়াল করে রাখলেন, ঠিক যেভাবে সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","মোশি সেই টেবিলটি সমাগম তাঁবুতে, পর্দার বাইরে, আবাসের উত্তর দিকে রেখে দিলেন ");
INSERT INTO benobcv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","এবং সদাপ্রভুর সামনে সেটির উপরে রুটি সাজিয়ে রাখলেন, ঠিক যেভাবে সদাপ্রভু তাঁকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","তিনি সেই দীপাধারটি সমাগম তাঁবুতে, টেবিলের বিপরীতে, আবাসের দক্ষিণ দিকে রেখে দিলেন ");
INSERT INTO benobcv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","এবং সদাপ্রভুর সামনে প্রদীপগুলি জ্বালিয়ে দিলেন, ঠিক যেভাবে সদাপ্রভু তাঁকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","মোশি সোনার বেদিটি সমাগম তাঁবুতে পর্দার সামনে রেখে দিলেন ");
INSERT INTO benobcv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","এবং সেটির উপরে সুগন্ধি ধূপ জ্বালিয়ে দিলেন, ঠিক যেভাবে সদাপ্রভু তাঁকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","পরে তিনি সমাগম তাঁবুর প্রবেশদ্বারে পর্দা টাঙিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","তিনি হোমবলির বেদিটি সমাগম তাঁবুর, সেই আবাসের প্রবেশদ্বারের কাছে রেখে দিলেন, এবং সেটির উপরে হোমবলি ও শস্য-নৈবেদ্য উৎসর্গ করলেন, ঠিক যেভাবে সদাপ্রভু তাঁকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","গামলাটি তিনি সমাগম তাঁবু ও বেদির মাঝখানে রেখে দিলেন ও ধোয়াধুয়ি করার জন্য তাতে জল ভরে রাখলেন, ");
INSERT INTO benobcv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","এবং মোশি এবং হারোণ ও তাঁর ছেলেরা সেই জল তাঁদের হাত পা ধোয়ার জন্য ব্যবহার করতেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","যখনই তাঁরা সমাগম তাঁবুতে প্রবেশ করতেন বা বেদিটির কাছে যেতেন, তাঁরা নিজেদের ধোয়াধুয়ি করতেন, ঠিক যেভাবে সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","পরে মোশি সমাগম তাঁবুর ও বেদির চারপাশে প্রাঙ্গণ তৈরি করলেন এবং প্রাঙ্গণের প্রবেশদ্বারে পর্দা লাগিয়ে দিলেন। আর এইভাবে মোশি কাজটি সমাপ্ত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","তখন মেঘ এসে সমাগম তাঁবুটি ঢেকে দিল, এবং সমাগম তাঁবুটি সদাপ্রভুর মহিমায় পরিপূর্ণ হয়ে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","মোশি সমাগম তাঁবুতে প্রবেশ করতে পারেননি কারণ তা মেঘে ছেয়ে ছিল, এবং সদাপ্রভুর মহিমা সমাগম তাঁবুটি পরিপূর্ণ করে রেখেছিল। ");
INSERT INTO benobcv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ইস্রায়েলীদের সব যাত্রায়, যখনই মেঘ সমাগম তাঁবুর উপর থেকে সরে যেত, তখনই তারা যাত্রা শুরু করত; ");
INSERT INTO benobcv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","কিন্তু মেঘ যদি না সরত, তবে যতদিন তা না সরত, ততদিন তারা যাত্রা শুরু করত না। ");
INSERT INTO benobcv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","অতএব ইস্রায়েলীদের সব যাত্রায় তাদের সকলের দৃষ্টিগোচরে দিনের বেলায় সদাপ্রভুর মেঘ সমাগম তাঁবুর উপরে থাকত, এবং রাতের বেলায় সেই মেঘে আগুন থাকত।");
INSERT INTO benobcv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","সদাপ্রভু মোশিকে ডাকলেন ও সমাগম তাঁবু থেকে তাঁর সঙ্গে কথা বললেন। তিনি বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ইস্রায়েলীদের সঙ্গে কথা বলো, তাদের বলো: ‘তোমাদের মধ্যে যদি কেউ সদাপ্রভুর উদ্দেশে উপহার দেয়, সে পশুপাল থেকে অর্থাৎ গোপাল অথবা মেষপাল থেকে একটি পশু উৎসর্গ করুক। ");
INSERT INTO benobcv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘যদি সে পশুপাল থেকে হোমবলি উপহার দেয়, তাহলে নিষ্কলঙ্ক এক পুংপশু উৎসর্গ করুক। সে অবশ্যই সমাগম তাঁবুর প্রবেশদ্বারে এই উপহার রাখবে, যেন তা সদাপ্রভুর গ্রহণযোগ্য হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","হোমবলির মাথায় সে হাত রাখবে ও তা প্রায়শ্চিত্তরূপে তার পক্ষে গৃহীত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","পরে সদাপ্রভুর সামনে সে এঁড়ে বাছুরটি বধ করবে এবং এরপরে হারোণের পুত্র যাজকেরা রক্ত নেবে ও সমাগম তাঁবুর প্রবেশদ্বারের চারপাশে বেদির সর্বত্র রক্ত ছিটিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","সে ওই হোমবলির চামড়া খুলবে ও বলিকৃত পশু কেটে খণ্ড খণ্ড করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","এরপর হারোণের পুত্র যাজকেরা বেদিতে অগ্নি সংযোগ করবে ও আগুনের মধ্যে কাঠ দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","পরে হারোণের পুত্র যাজকেরা পশুর মাথা ও চর্বি সমেত খণ্ডগুলি সাজাবে, এবং বেদিতে জ্বলন্ত কাঠের উপরে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","পশুর শরীরের ভিতরের অংশ ও পাগুলি সে জলে ধোবে এবং যাজক সে সকল বেদির আগুনে পোড়াবে। এটি হোমবলি, সদাপ্রভুর উদ্দেশে সন্তোষজনক সৌরভার্থক অগ্নিকৃত এক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘যদি মেষপাল থেকে হোমবলি উৎসর্গ করা হয়, পালের মেষ কিংবা ছাগল হোক, তা হবে নিষ্কলঙ্ক এক পুংশাবক। ");
INSERT INTO benobcv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","সদাপ্রভুর সামনে বেদির উত্তর দিকে সে পশুটি হত্যা করবে ও হারোণের পুত্র যাজকেরা বেদির চারপাশে বলিদানের রক্ত ছিটিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","সে পশুটিকে খণ্ড খণ্ড করে কাটবে এবং পশুটির মাথা ও চর্বি সমেত সমস্ত অর্ঘ্য যাজক সাজাবে ও বেদিতে জ্বলন্ত কাঠের উপরে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","সে ওই পশুর অন্ত্র ও পা জলে ধুয়ে নেবে এবং যাজক সমস্ত নৈবেদ্য তুলবে ও বেদিতে পোড়াবে। এটি হোমবলি, সদাপ্রভুর উদ্দেশে সৌরভার্থক সন্তোষজনক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘যদি সদাপ্রভুর উদ্দেশে পাখিদের হোমবলি উৎসর্গ করা হয়, তাহলে ঘুঘু অথবা কপোতশাবক সে উপহার দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","যাজক ওই পাখিকে বেদিতে আনবে, তার মাথা মুচড়ে বেদিতে পোড়াবে; পাখির রক্ত বেদির পাশ দিয়ে প্রবাহিত হতে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","সে ওই পাখির কণ্ঠনালীর থলি ও অন্যান্য আবর্জনা তুলবে ও ভস্মস্থানের বেদির পূর্বদিকে নিক্ষেপ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","সে পাখিটির ডানা ভাঙবে, কিন্তু পাখিটিকে পুরোপুরি ছিঁড়ে ফেলবে না, এবং বেদিতে জ্বলন্ত কাঠে যাজক পাখিটিকে পোড়াবে। এটি হোমবলি, যা সদাপ্রভুর উদ্দেশে সৌরভার্থক সন্তোষজনক এক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘যখন কেউ সদাপ্রভুর উদ্দেশে শস্য-নৈবেদ্য আনবে, সে মিহি ময়দার উপহার আনবে, ময়দাতে জলপাই তেল ঢালবে, নৈবেদ্যের উপরে ধূপ রাখবে ");
INSERT INTO benobcv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","এবং হারোণের পুত্র যাজকদের কাছে নিয়ে যাবে। যাজক সমস্ত ধূপ সমেত একমুঠো মিহি ময়দা ও তেল নেবে এবং নৈবেদ্যের স্মরণীয় অংশরূপে তা বেদিতে পোড়াবে, যা সদাপ্রভুর উদ্দেশে সৌরভার্থক সন্তোষজনক অগ্নিকৃত উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","শস্য-নৈবেদ্যের অবশিষ্টাংশ হারোণের ও তাঁর ছেলেদের হবে; এটি সদাপ্রভুর উদ্দেশে অগ্নিকৃত সমস্ত উপহারের অতি পবিত্র অংশ। ");
INSERT INTO benobcv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘যদি তুমি উনুনে শেঁকা শস্য-নৈবেদ্য আনো, তাহলে মিহি ময়দা দিয়ে তা তৈরি করতে হবে, যা হবে খামিরবিহীন, অথচ তেলমিশ্রিত পিঠে, তৈলাক্ত সরু চাকলী। ");
INSERT INTO benobcv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","যদি পিঠে সেঁকার পাত্রে তোমার শস্য-নৈবেদ্য প্রস্তুত করো, তাহলে তেলমিশ্রিত মিহি ময়দা দিয়ে তা তৈরি করতে হবে, কিন্তু সেই খাদ্য খামিরবিহীন রাখতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","নৈবেদ্য খণ্ড খণ্ড করো, তাতে তেল ঢালো; এটি শস্য-নৈবেদ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","যদি তোমার শস্য-নৈবেদ্য একটি পাত্রে রান্না করা হয়, তা মিহি ময়দা ও জলপাই তেল সহযোগে রান্না করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","এই সমস্ত উপাদান মিশ্রিত শস্য-নৈবেদ্য সদাপ্রভুর কাছে আনো; যাজকের হাতে দাও, যাজক সেটি বেদিতে নিয়ে যাবেন। ");
INSERT INTO benobcv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","তিনি শস্য-নৈবেদ্য থেকে স্মরণীয় অংশ তুলে নেবেন, এবং অগ্নিকৃত নৈবেদ্যরূপে বেদিতে পোড়াবেন, যা সদাপ্রভুর উদ্দেশে সৌরভার্থক সন্তোষজনক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","শস্য-নৈবেদ্যের অবশিষ্টাংশ হারোণের ও তাঁর ছেলেদের হবে। এটি সদাপ্রভুর উদ্দেশে অগ্নিকৃত সমস্ত উপহারের অতি পবিত্র অংশ। ");
INSERT INTO benobcv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘সদাপ্রভুর উদ্দেশে নিবেদিত তোমার যে কোনো শস্য-নৈবেদ্য অবশ্যই খামিরবিহীন হবে। মধুমিশ্রিত কোনো নৈবেদ্য তুমি পোড়াতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","তুমি সেগুলি তোমার প্রথম ফসলরূপে সদাপ্রভুর কাছে আনবে, কিন্তু সৌরভার্থক প্রীতিজনক উপহাররূপে সেগুলি উৎসর্গ করা যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","তুমি তোমার শস্য-নৈবেদ্যের সব বস্তু লবণাক্ত করবে। তোমার শস্য-নৈবেদ্য তোমার ঈশ্বরের সঙ্গে সন্ধিচুক্তির লবণ বিহীন রাখবে না। তোমার সব নৈবেদ্যে লবণ মিশ্রিত করো। ");
INSERT INTO benobcv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘যদি তুমি সদাপ্রভুর উদ্দেশে তোমার প্রথম ফসলের শস্য-নৈবেদ্য নিবেদন করতে চাও, তাহলে আগুনে ঝলসানো নতুন ফসলের মর্দিত শিষ নিবেদন করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","এই নৈবেদ্যে তেল ঢালো ও এর উপরে ধূপ রাখো; এটি শস্য-নৈবেদ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","যাজক সমস্ত ধূপ সমেত মর্দিত ফসলের স্মরণীয় অংশ ও তেল পোড়াবে, যা সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহাররূপে নিবেদিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘যদি কেউ মঙ্গলার্থক বলিদান দেয় এবং পশুপাল থেকে একটি পশু উৎসর্গ করে, সেটি পুংপশু বা স্ত্রীপশু যাই হোক না কেন, সদাপ্রভুর সামনে সেটি নির্দোষ হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","সে ওই পশুর মাথায় হাত রাখবে ও সমাগম তাঁবুর প্রবেশদ্বারে সেটিকে বধ করবে। পরে হারোণের পুত্র যাজকেরা বেদির চারপাশে রক্ত ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","মঙ্গলার্থক বলিদান থেকে সে এক অর্ঘ্য আনবে, যা সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহার, ভিতরের অঙ্গ এবং সমস্ত মেদ তার সঙ্গে যুক্ত, ");
INSERT INTO benobcv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","অন্ত্র আচ্ছাদনকারী সমস্ত মেদ অথবা এর সঙ্গে সংযুক্ত প্রত্যঙ্গ, কোমরের কাছাকাছি মেদসহ দুটি কিডনি ও কিডনির পর্দা সে বাদ দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","তারপর হোমবলির শীর্ষ ভাগে বেদির উপরে হারোণের ছেলেরা নৈবেদ্য পোড়াবে, অর্থাৎ কাঠে অর্ঘ্য ঝলসানো হবে; এটি অগ্নিকৃত এক নৈবেদ্য যা সদাপ্রভুর উদ্দেশে সৌরভার্থক প্রীতিজনক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘যদি সে সদাপ্রভুর উদ্দেশে পশুপাল থেকে কোনো পুংশাবক অথবা স্ত্রীশাবক মঙ্গলার্থক নৈবেদ্যরূপে উৎসর্গ করে, তাহলে তা যেন ত্রুটিমুক্ত হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","যদি সে এক মেষশাবক বলি দেয়, সদাপ্রভুর সামনে সে তাকে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","সে তার বলির পশুর মাথায় হাত রাখবে ও সমাগম তাঁবুর সামনে বধ করবে। পরে হারোণের ছেলেরা বেদির চারপাশে বধ করা পশুর রক্ত ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","মঙ্গলার্থক বলি থেকে অগ্নিকৃত উপহার সে সদাপ্রভুর উদ্দেশে নিবেদন করবে। বলিকৃত পশুর সমস্ত মেদ, অথবা এতে সংযুক্ত অন্যান্য প্রত্যঙ্গ, ");
INSERT INTO benobcv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","কোমরের কাছাকাছি মেদসহ দুটো কিডনি ও যকৃতের পর্দা সে সরিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","যাজক খাদ্যরূপে সেগুলি বেদিতে পোড়াবে, যা সদাপ্রভুর উদ্দেশে অগ্নিকৃত এক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘যদি সে একটি ছাগল উৎসর্গ করতে চায়, সদাপ্রভুর সামনে সে তাকে রাখবে, ");
INSERT INTO benobcv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ছাগটির মাথায় সে হাত রাখবে ও সমাগম তাঁবুর সামনে তাকে বধ করবে। পরে হারোণের পুত্রেরা বেদির চারপাশে বধ করা পশুর রক্ত ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","তার যে কোনো বলিদান সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহার হতেই হবে; অন্ত্র আচ্ছাদনকারী সমস্ত মেদ অথবা এতে সংযুক্ত প্রত্যঙ্গ ");
INSERT INTO benobcv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","কোমরের কাছাকাছি মেদসহ দুটো কিডনি ও যকৃতের পর্দা সে সরিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","যাজক সেগুলি ভক্ষ্যরূপে বেদিতে পোড়াবে, যা সৌরভার্থক প্রীতিজনক অগ্নিকৃত এক উপহার। সমস্ত মেদ সদাপ্রভুর। ");
INSERT INTO benobcv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘পুরুষানুক্রমে তোমরা যেখানেই বসবাস করো এটি হবে তোমাদের জন্য চিরস্থায়ী বিধি, তোমরা মেদ অথবা রক্ত ভোজন করবে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“তুমি ইস্রায়েলীদের বলো: ‘কেউ যখন অনিচ্ছাকৃতভাবে পাপ করে এবং সদাপ্রভুর আদেশসমূহের যে কোনো নিষিদ্ধ আদেশ লঙ্ঘন করে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘যদি অভিষিক্ত যাজক পাপ করে, লোকদের উপরে দোষ বর্তায়, তাহলে তার করা পাপের জন্য সে সদাপ্রভুর উদ্দেশে পাপার্থক বলিরূপে ত্রুটিহীন এঁড়ে বাছুর উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","সে সদাপ্রভুর সামনে সমাগম তাঁবুর প্রবেশদ্বারে গোবৎস রাখবে। বাছুরটির মাথায় সে হাত রাখবে ও সদাপ্রভুর সামনে তাকে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","পরে অভিষিক্ত যাজক বাছুরটির কিছু রক্ত নেবে ও সমাগম তাঁবুতে নিয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","সে রক্তের মধ্যে আঙুল ডুবিয়ে পবিত্রস্থানের সামনের দিকে গিয়ে সদাপ্রভুর সামনে সেই রক্তের কিছুটা ছিটিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","পরে যাজক সমাগম তাঁবুর মধ্যে সদাপ্রভুর সামনে সুগন্ধি ধূপযুক্ত বেদির শৃঙ্গে অল্প রক্ত দেবে। সমাগম তাঁবুর প্রবেশদ্বারে হোমবলির বেদির মূলে সে বাছুরটির অবশিষ্ট রক্ত ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","পাপার্থক বলির বাছুরটির সমস্ত মেদ সে ছাড়াবে যা অন্ত্রের সঙ্গে সংযুক্ত অংশ, ");
INSERT INTO benobcv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","কোমরের কাছাকাছি মেদযুক্ত দুটি কিডনি ও যকৃতের পর্দা সে সরিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","একইভাবে বলিকৃত বাছুরটির মেদ সরাবে, যা মঙ্গলার্থক বলিদান। পরে যাজক হোমবলির বেদিতে সেগুলি পোড়াবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","কিন্তু ওই বাছুরটির চামড়া, সমস্ত মাংস, মাথা ও পা, অন্ত্র ও গোবর, ");
INSERT INTO benobcv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","সম্পূর্ণ বাছুরটিকে নিয়ে শিবিরের বাইরে কোনো আনুষ্ঠানিক শুচিশুদ্ধ স্থানে কাঠের উপরে আগুনে পোড়াবে, ভস্ম ফেলার স্থানেই ভস্মের স্তূপে সেগুলি পুড়বে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘যদি সমগ্র ইস্রায়েলী সমাজ অনিচ্ছাকৃতভাবে পাপ করে ও সদাপ্রভুর আদেশসমূহের মধ্যে যে কোনো একটি নিষিদ্ধ আদেশ লঙ্ঘন করে, এমনকি বিষয়টি সমাজের অজানা থাকলেও তারা দোষী সাব্যস্ত হবে ");
INSERT INTO benobcv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","যখন সমাজ তাদের করা পাপের কথা জানতে পারবে, সকলে পাপার্থক বলিরূপে অবশ্যই একটি এঁড়ে বাছুর আনবে ও সমাগম তাঁবুর সামনে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","সমাজের প্রাচীনেরা সদাপ্রভুর সামনে বাছুরটির মাথায় হাত রাখবে এবং বাছুরটিকে সদাপ্রভুর সামনে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","তারপর অভিষিক্ত যাজক বাছুরটির কিছুটা রক্ত নিয়ে সমাগম তাঁবুর মধ্যে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","সে রক্তের মধ্যে আঙুল ডুবিয়ে পবিত্রস্থানের সামনের দিকে গিয়ে সদাপ্রভুর সামনে সেই রক্তের কিছুটা ছিটিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","বেদির শৃঙ্গে সে খানিকটা রক্ত ঢালবে, যা সমাগম তাঁবুর সদাপ্রভুর সামনে রয়েছে। সমাগম তাঁবুর প্রবেশদ্বারে হোমবলির বেদিমূলে সে অবশিষ্ট রক্ত ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","সে বাছুরটির সমস্ত মেদ ছাড়াবে ও বেদিতে পোড়াবে, ");
INSERT INTO benobcv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","এবং পাপার্থক বলিদানে বাছুরটির প্রতি কৃতকর্মের মতো এই বাছুরটির প্রতি আচরণ করবে। এভাবে তাদের জন্য যাজক প্রায়শ্চিত্ত করবে ও তারা ক্ষমা পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","পরে সে বাছুরটিকে শিবিরের বাইরে নিয়ে যাবে ও তাকে পোড়াবে, যেমন প্রথমে বাছুরকে পুড়িয়েছিল। এই হল সমাজের পাপার্থক বলিদান। ");
INSERT INTO benobcv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘যখন কোনো নেতা অনিচ্ছাকৃতভাবে পাপ করে এবং তার ঈশ্বর সদাপ্রভুর আদেশসমূহের মধ্যে যে কোনো একটি নিষিদ্ধ আদেশ লঙ্ঘন করে, সে যখন তার অপরাধ বুঝতে পারবে ");
INSERT INTO benobcv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","এবং তার করা পাপ অন্যেরা জানতে পারবে, সে অবশ্যই ত্রুটিমুক্ত মদ্দা ছাগল উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ছাগলটির মাথায় সে হাত রাখবে ও সেখানে তাকে বধ করবে, সেখানে সদাপ্রভুর সামনে হোমবলি করা হয়। এটি পাপার্থক বলিদান। ");
INSERT INTO benobcv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","এরপর পাপার্থক বলিদানের খানিকটা রক্ত যাজক আঙুল দিয়ে তুলবে এবং হোমবলির বেদিশৃঙ্গে ঢালবে ও অবশিষ্ট রক্ত বেদিমূলে ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","সে সমস্ত মেদ বেদিতে জ্বালাবে, যেমন মঙ্গলার্থক বলিদানে জ্বালিয়েছিল। এভাবে মানুষের পাপের জন্য যাজক প্রায়শ্চিত্ত করবে ও সে পাপের ক্ষমা পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘যদি সমাজের কোনো সদস্য অনিচ্ছাকৃতভাবে পাপ করে ও সদাপ্রভুর আদেশসমূহের মধ্যে যে কোনো একটি নিষিদ্ধ আদেশ লঙ্ঘন করে, যখন তারা তার দোষ বুঝতে পারবে ");
INSERT INTO benobcv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","এবং তার করা পাপ অন্যেরা জানতে পারবে, তাদের করা পাপের জন্য বলিদানরূপে অবশ্যই একটি ত্রুটিমুক্ত মাদি ছাগল আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","পাপার্থক বলির মাথায় সে হাত রাখবে ও হোমবলির জায়গায় সেটিকে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","এবারে যাজক তার আঙুল দিয়ে খানিকটা রক্ত তুলবে এবং হোমবলির বেদিশৃঙ্গে ঢালবে ও অবশিষ্ট রক্ত বেদিমূলে ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","সে সমস্ত মেদ ছাড়াবে, যেমন মঙ্গলার্থক বলি থেকে ছাড়িয়েছিল; পরে যাজক সদাপ্রভুর উদ্দেশে সৌরভার্থে বেদিতে রাখা সবকিছুই জ্বালিয়ে দেবে। এভাবে যাজক তার পক্ষে প্রায়শ্চিত্ত করবে এবং সে ক্ষমা পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘যদি সে তার পাপার্থক বলিরূপে একটি মেষশাবক আনে, তাকে ত্রুটিমুক্ত মাদি মেষশাবক আনতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","শাবকটির মাথায় সে হাত রাখবে, এবং হোমবলি বধ করার জায়গায় পাপার্থক বলিরূপে সেটিকে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","তারপর পাপার্থক বলিদানের খানিকটা রক্ত যাজক তার আঙুল দিয়ে তুলবে এবং হোমবলির বেদিশৃঙ্গে ঢালবে ও অবশিষ্ট রক্ত বেদিমূলে ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","সে সমস্ত মেদ ছাড়াবে, যেমন মঙ্গলার্থক বলিদানের মেষশাবকের মেদ ছাড়িয়েছিল এবং সদাপ্রভুর উদ্দেশে অগ্নিকৃত নৈবেদ্যের বেদির উপরে পোড়াবে। এইভাবে যাজক তার কৃত পাপের কারণে প্রায়শ্চিত্ত করবে এবং সে ক্ষমা পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘যদি কেউ নিজের চোখে দেখে অথবা নিজের কানে শুনেও তা প্রকাশ না করার জন্য পাপ করে, তাহলে সেই বিষয়ের জন্য সে দায়ী হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘যদি কোনো ব্যক্তি জানতে পারে যে সে দোষী—যদি সে অজান্তে আনুষ্ঠানিকভাবে অশুচি কোনো জিনিস স্পর্শ করে (হতে পারে অশুচি পশুর মৃতদেহ, বন্য অথবা গৃহপালিত, অথবা কোনো অশুচি জীব যা মাটিতে চলে) এবং জানে না যে সে অশুচি, কিন্তু পরে উপলব্ধি করে যে সে অশুচি; ");
INSERT INTO benobcv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","অথবা যদি সে মানুষের অশৌচ স্পর্শ করে (যা তাকে অশুচি করে) যদিও সে সেই বিষয় অবগত না হয়, কিন্তু পরে জানতে পারে এবং নিজের দোষ উপলব্ধি করে; ");
INSERT INTO benobcv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","অথবা যদি কেউ অবিবেচকের মতো ভালো বা মন্দ কোনো কিছু করার শপথ গ্রহণ করে (যে কোনো কিছু করতে অযত্নে শপথ গ্রহণ করে) যদিও সে সেই বিষয় অবগত না হয়, কিন্তু পরে জানতে পারে এবং নিজের দোষ উপলব্ধি করে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","এগুলির কোনো একটির দ্বারা যখন কেউ অপরাধী হয়, সে নিজের পাপ অবশ্যই স্বীকার করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","তার কৃত পাপের দণ্ডরূপে এক পাপার্থক বলির জন্য একটি মেষবৎসা অথবা ছাগবৎসা সদাপ্রভুর উদ্দেশে সে নিবেদন করবে এবং তার পাপমোচনের জন্য তার পক্ষে যাজক প্রায়শ্চিত্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘সে যদি মেষবৎসা আনতে অসমর্থ হয়, তাহলে তার কৃত পাপের জন্য দুটি ঘুঘু অথবা দুটি কপোতশাবক এক দোষার্থক-নৈবেদ্যরূপে সদাপ্রভুর কাছে আনবে—একটি পাপার্থক ও অন্যটি হোমবলি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","সে যাজকের কাছে সেগুলি আনবে, তিনি পাপার্থক বলিরূপে প্রথমে একটি শাবক উৎসর্গ করবেন। যাজক ওই শাবকের মাথা থেকে গলা মোচড় দেবে, কিন্তু ছিঁড়ে ফেলবে না, ");
INSERT INTO benobcv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","এবং পাপার্থক বলির কিছুটা রক্ত নিয়ে বেদির গায়ে ছিটাবে এবং অবশিষ্ট রক্ত বেদির মূলে ঢেলে দেবে। এটি পাপার্থক বলি। ");
INSERT INTO benobcv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","এবারে যাজক নির্ধারিত উপায়ে হোমবলিরূপে অন্য শাবকটি উৎসর্গ করবে এবং সেই ব্যক্তির কৃত পাপের জন্য তার পক্ষে প্রায়শ্চিত্ত করবে, এবং তার পাপের ক্ষমা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘অন্যদিকে, যদি সে দুটি ঘুঘু অথবা দুটি কপোতশাবক জোগাড় করতে অসমর্থ হয়, তাহলে সে তার পাপের জন্য এক ঐফার দশমাংশ সূক্ষ্ম ময়দা পাপার্থক বলিরূপে উৎসর্গ করবে। সে তার নৈবেদ্যের উপরে জলপাই তেল অথবা সুগন্ধিদ্রব্য ঢালবে না, কারণ এটি পাপার্থক বলিদান। ");
INSERT INTO benobcv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","সে এই বলিদান যাজকের কাছে আনবে যে এক স্মরণীয় অংশরূপে বলিদানের একমুঠো তুলে নিয়ে বেদিতে ভক্ষ্য-নৈবেদ্যের উপরে সদাপ্রভুর উদ্দেশে পোড়াবে। এটি পাপার্থক বলিদান। ");
INSERT INTO benobcv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","এইভাবে তাদের কৃত যে কোনো পাপের জন্য যাজক প্রায়শ্চিত্ত করবে এবং তাদের পাপের ক্ষমা হবে। অবশিষ্ট নৈবেদ্য যাজকের হবে, যেমন শস্য-নৈবেদ্যের ক্ষেত্রে হয়েছিল।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“যখন কোনও ব্যক্তি আজ্ঞা লঙ্ঘন করে এবং সদাপ্রভুর পবিত্র বিষয়গুলির কোনো একটি বিষয়ে অনিচ্ছাকৃতভাবে পাপ করে, সে দণ্ডস্বরূপ মেষপাল থেকে একটি ত্রুটিমুক্ত মেষ সদাপ্রভুর উদ্দেশে আনবে ও ধর্মধামের শেকল অনুসারে নিরূপিত পরিমাণে রুপো রাখবে। এটি হবে দোষার্থক-নৈবেদ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","পবিত্র বিষয়গুলির সম্বন্ধে তার ব্যর্থতা হেতু সে অবশ্যই ক্ষতিপূরণ দেবে ও সামগ্রিক পরিমাণের পঞ্চমাংশ আনবে ও সমস্তই যাজককে দেবে। অপরাধের বলিদানরূপে একটি মেষ নিয়ে তার পক্ষে যাজক প্রায়শ্চিত্ত করবে, এবং পাপীকে ক্ষমা করা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“যদি কেউ পাপ করে ও সদাপ্রভুর আদেশগুলির মধ্যে কোনো একটি আদেশ লঙ্ঘন করে, নিজের অজান্তে ওই পাপ করলেও সে অপরাধী ও দায়ী হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","দোষার্থক-নৈবেদ্যরূপে মেষপাল থেকে একটি মেষ সে যাজকের কাছে আনবে; মেষটি নিখুঁত সঠিক মূল্যের হবে। তার অনিচ্ছাকৃত অপরাধ হেতু তার পক্ষে যাজক প্রায়শ্চিত্ত করবে, এবং সে তার কৃত পাপের ক্ষমা পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","এটি দোষার্থক এক নৈবেদ্য। সদাপ্রভুর বিপক্ষে কৃত মন্দ কাজ হেতু সে অপরাধী হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“যদি কেউ পাপ করে, এবং তার প্রতি অর্পিত কোনো বিষয় সম্বন্ধে তার প্রতিবেশীকে প্রবঞ্চিত করার দ্বারা সদাপ্রভুর প্রতি অবিশ্বস্ত হয়, অথবা তার কাছে গচ্ছিত বস্তু চুরি করে, কিংবা সে প্রতিবেশীকে প্রবঞ্চিত করে, ");
INSERT INTO benobcv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","অথবা হারানো সম্পত্তি খুঁজে পায়, অথচ মিথ্যা কথা বলে, কিংবা মিথ্যা শপথ করে, কিংবা তার কৃত পাপের মতো অন্য কেউ একই পাপ করে এভাবে যখন সে পাপ করে, ");
INSERT INTO benobcv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","যখন সে এরকম কোনো পাপ করে এবং বুঝতে পারে যে সে অপরাধী, তখন চুরি করা বস্তু বা লুন্ঠিত জিনিস, অথবা তার প্রতি অর্পিত জিনিস কিংবা হারানো প্রাপ্ত সম্পদ পেয়ে নিজের কাছে রেখেছে ");
INSERT INTO benobcv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","অথবা মিথ্যা শপথ করা যে কোনো বস্তু সে অবশ্যই ফেরত দেবে। যেদিন সে তার দোষার্থক-নৈবেদ্য উৎসর্গ করবে, সেদিন নির্ধারিত পরিমাণের পঞ্চমাংশ সমেত পরিশোধ যোগ্য সমস্ত দ্রব্যের ক্ষতিপূরণ প্রাপকের হাতে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","দণ্ডস্বরূপ সে যাজকের কাছে, অর্থাৎ সদাপ্রভুর উদ্দেশে মেষপাল থেকে নিখুঁত ও যথার্থ মানের একটি মেষ অবশ্যই আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","এভাবে সদাপ্রভুর সামনে তার পক্ষে যাজক প্রায়শ্চিত্ত করবে এবং এসব আদেশের যে কোনো একটি আদেশ অমান্য হেতু তার পাপের ক্ষমা হবে, যা তাকে দোষী করেছিল।” ");
INSERT INTO benobcv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“হারোণ ও তার ছেলেদের এই আদেশ দাও, ‘হোমবলির নিয়মাবলি এইরকম: সারারাত, সকাল অবধি হোমবলি বেদিগৃহে থাকবে, এবং বেদিতে অগ্নি নির্বাপিত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","এবারে যাজক সুতির পোশাক ও অন্তর্বাস পরিধান করবেন, এবং হোমবলির অগ্নিভস্ম সরাবেন ও বেদির পাশে রাখবেন। ");
INSERT INTO benobcv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","এরপর যাজক তার পোশাক ছাড়বেন ও অন্য পোশাক পরিহিত হবেন এবং সমস্ত ভস্ম শিবিরের বাইরে এক জায়গায় নিয়ে যাবেন, যা আনুষ্ঠানিকভাবে শুচি স্থান। ");
INSERT INTO benobcv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","বেদিতে সংযোগ করা আগুন যেন জ্বলতে থাকে; এই আগুন কোনোভাবে নির্বাপিত হবে না। প্রতিদিন সকালে যাজক কাঠ জোগান দেবে, আগুনে হোমবলি সাজাবে ও এর উপরে মঙ্গলার্থক বলির মেদ পোড়াবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","বেদিতে আগুন অবশ্যই অবিরাম জ্বলবে; আগুন নির্বাপিত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘শস্য-নৈবেদ্যের পক্ষে নিয়মাবলি এইরকম, হারোণের ছেলেরা সদাপ্রভুর সামনের দিকে বেদি সামনের দিকে এই নৈবেদ্য আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","যাজক সমস্ত ধূপ সমেত এক মুঠি মিহি ময়দা ও জলপাই তেল তুলে নিয়ে শস্য-নৈবেদ্যের উপরে রাখবে, এবং সদাপ্রভুর উদ্দেশে সৌরভার্থক সন্তোষজনক উপহাররূপে বেদিতে স্মরণীয় অংশ পোড়াবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","হারোণ ও তার ছেলেরা অবশিষ্ট খাদ্য ভোজন করবে, কিন্তু তাদের পবিত্রস্থানে খামিরবিহীন খাদ্য ভোজন করতে হবে; সমাগম তাঁবুর উঠোনে তারা যেন আহার করে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","খামিরযুক্ত খাদ্যবস্তু রান্না করা যাবে না; আমার উদ্দেশে প্রস্তুত অগ্নিকৃত উপহারগুলির অংশরূপে এটি আমি তাদের দিয়েছি। পাপার্থক বলি ও দোষার্থক-নৈবেদ্যের মতো এটি অত্যন্ত পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","হারোণের যে কোনো পুরুষ বংশধর এই খাদ্য ভোজন করতে পারে। সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহারগুলির মধ্যে এই অংশবিশেষ তার অধিকার ও পুরুষানুক্রমে তারা ভোজন করবে। তাদের স্পর্শে যে কোনো বস্তু পবিত্র হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","সদাপ্রভু মোশিকে আরও বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“হারোণ ও তার ছেলেরা অভিষেকের দিনে সদাপ্রভু উদ্দেশে এই উপহার আনবে: এক নিয়মিত শস্য-নৈবেদ্যরূপে এক ঐফা মিহি ময়দার দশমাংশ, সকালে অর্ধেক ভাগ ও সন্ধ্যায় অর্ধেক ভাগ। ");
INSERT INTO benobcv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","পাত্রে তেল ঢেলে তা প্রস্তুত করো, সুমিশ্রিত খাদ্য আনো ও সদাপ্রভুর উদ্দেশে খণ্ড খণ্ড করে কেটে সৌরভার্থক সন্তোষজনক উপহাররূপে ওই শস্য-নৈবেদ্য উৎসর্গ করো। ");
INSERT INTO benobcv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","অভিষিক্ত যাজকরূপে তার উত্তরাধিকারী ছেলে এই খাদ্য প্রস্তুত করবে। এটি সদাপ্রভুর নিয়মিত অংশ, যা পুরোপুরি পোড়াতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","যাজকের প্রত্যেক শস্য-নৈবেদ্য পুরোপুরি পুড়ে যাবে, এটি ভোজন করা যাবে না।” ");
INSERT INTO benobcv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“হারোণ ও তার ছেলেদের বলো, পাপার্থক বলিদানের নিয়মাবলি এইরকম: সদাপ্রভুর সামনে হোমবলি হত্যা করার জায়গায় পাপার্থক বলিকে হত্যা করতে হবে; এটি অত্যন্ত পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","উৎসর্গকারী যাজক এই খাদ্য খাবে। সমাগম তাঁবুর উঠোনের পবিত্রস্থানে খাদ্যটি ভোজন করতে হবে; ");
INSERT INTO benobcv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","যে তা স্পর্শ করবে সে পবিত্র হবে; যদি পোশাকে রক্তের দাগ লাগে, তোমাকে এক পবিত্রস্থানে তা ধুয়ে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","মাংস রান্নার জন্য মাটির পাত্রকে অবশ্যই ভেঙে ফেলতে হবে; কিন্তু যদি পিতলের পাত্রে তা রান্না করা হয়, তাহলে জল দিয়ে ধুয়ে পাত্রটি পরিষ্কার করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","যাজকের পরিবারের যে কোনো পুরুষ এই খাদ্য ভোজন করতে পারে; এটি অত্যন্ত পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","কিন্তু পবিত্রস্থানে প্রায়শ্চিত্ত করবার জন্য সমাগম তাঁবুতে আনা যে কোনো পাপার্থক বলির রক্ত ভোজন করা যাবে না; এই ভক্ষ্য দ্রব্যকে পোড়াতেই হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘দোষার্থক-নৈবেদ্যদানের পক্ষে এই নিয়মাবলি, যা অত্যন্ত পবিত্র: ");
INSERT INTO benobcv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","দোষার্থক-নৈবেদ্যদান সেখানে করতে হবে, যেখানে হোমবলি করা হয় এবং বেদির উপরে চারপাশে এর রক্ত ছিটাতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","এর সমস্ত চর্বি উৎসর্গ করা হবে, মেদযুক্ত লেজ, অন্ত্র আচ্ছাদনকারী মেদ, ");
INSERT INTO benobcv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","কোমরের কাছাকাছি মেদযুক্ত দুটি কিডনি এবং যকৃতের পর্দা ছাড়িয়ে ফেলে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহাররূপে এগুলি বেদিতে রেখে যাজক পোড়াবে। এটি দোষার্থক-নৈবেদ্যদান। ");
INSERT INTO benobcv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","যাজকের পরিবারের যে কোনো পুরুষ এই খাদ্য ভোজন করতে পারে, কিন্তু অবশ্যই এক পবিত্রস্থানে তা ভোজন করতে হবে; এটি অত্যন্ত পবিত্র ভক্ষ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘পাপার্থক বলি ও দোষার্থক-নৈবেদ্য উভয় ক্ষেত্রে একই নিয়ম প্রযোজ্য হবে; সবই যাজক নেবে, যার দ্বারা সকলের জন্য প্রায়শ্চিত্ত সাধিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","হোম বলিদানকারী যাজক নিজের জন্য চামড়া রাখতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","প্রত্যেক শস্য-নৈবেদ্য উনুনে অথবা পাত্রে কিংবা চাটুতে রান্না করা খাদ্য যাজকের হবে, যে এই নৈবেদ্য উৎসর্গ করবে ");
INSERT INTO benobcv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","এবং তেলমিশ্রিত কিংবা অমিশ্রিত যে কোনো শস্য-নৈবেদ্য হারোণের ছেলেরা সবাই সমপরিমাণে পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘মঙ্গলার্থক বলিদানের পক্ষে এই নিয়মাবলি, যা যে কোনো ব্যক্তি সদাপ্রভুর উদ্দেশে উপহার দিতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘যদি সে কৃতজ্ঞতার প্রকাশস্বরূপ বলি আনে, তাহলে ধন্যবাদসূচক এই বলিদানের সঙ্গে সে তেলমিশ্রিত খামিরবিহীন রুটি, তৈলাক্ত খামিরবিহীন সরুচাকলি, তৈলসিক্ত মিহি ময়দার পিঠে আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","সে তার কৃতজ্ঞতাপূর্ণ মঙ্গলার্থক বলির সঙ্গে খামিরযুক্ত ময়দার পিঠে উপহার দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","সব ধরনের ভক্ষ্য সে সদাপ্রভুর উদ্দেশে একটি করে উপহার দানরূপে আনবে; এগুলি সেই যাজকের হবে যে বেদিতে মঙ্গলার্থক বলির রক্ত ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","তার ধন্যবাদ জ্ঞাপনের মঙ্গলার্থক বলির মাংস উৎসর্গীকরণের দিনে অবশ্যই ভোজন করতে হবে; সকাল পর্যন্ত যেন কোনো খাদ্য রাখা না হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘যাইহোক, যদি, তার উপহার কোনো মানত কিংবা স্বেচ্ছাকৃত দানের পরিণতি হয়, তাহলে উৎসর্গীকরণের দিনে ওই বলি ভোজন করতে হবে, তবে অবশিষ্ট যে কোনো ভক্ষ্য পরের দিন ভোজন করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","বলিদানের কোনো মাংস তৃতীয় দিন পর্যন্ত থাকলে তা অবশ্যই পোড়াতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","যদি মঙ্গলার্থক বলিদানের কোনো মাংস তৃতীয় দিনে ভোজন করা হয়, তাহলে তা গৃহীত হবে না। উপহারদাতার প্রতি তা আরোপিত হবে না, কারণ সেটি অশুচি; যদি কেউ এই মাংস ভক্ষণ করে, সে তার জন্য দায়ী হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘মাংস কোনো আনুষ্ঠানিক অশুচি বস্তুকে স্পর্শ করলে তা ভক্ষণ করা যাবে না; সেটি জ্বালিয়ে দিতে হবে। আনুষ্ঠানিকভাবে শুচি যে কোনো ব্যক্তি অন্য মাংস ভক্ষণ করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","কিন্তু অশুচি কেউ যদি সদাপ্রভুর উদ্দেশে নিবেদিত মঙ্গলার্থক বলিদানের মাংস ভক্ষণ করে, তাহলে নিজের লোকদের মধ্য থেকে সে উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","যদি কেউ কোনো অশুচি বস্তু স্পর্শ করে, কোনো অশুচি মানুষ অথবা এক অশুচি পশু, কিংবা ভূমিতে বিচরণকারী কোনো অশুচি ঘৃণার্হ বস্তু, এবং পরে সদাপ্রভুর উদ্দেশে নিবেদিত মঙ্গলার্থক বলিদানের মাংস ভক্ষণ করে, তাহলে সে নিজের লোকদের মধ্য থেকে অবশ্যই উচ্ছিন্ন হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“তুমি ইস্রায়েলীদের এই কথা বলো: ‘গরু, মেষ অথবা ছাগলের মেদ তোমরা ভোজন করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","মৃত পশুর অথবা বন্যপশু দ্বারা ছিন্নভিন্ন পশুর মেদ অন্য যে কোনো উদ্দেশ্যে ব্যবহৃত হতে পারে কিন্তু তোমরা কিছুতেই ভোজন করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","যদি কেউ এমন কোনো পশুর মেদ ভোজন করে যা অগ্নিকৃত উপহার রূপে সদাপ্রভুর উদ্দেশে নিবেদিত, সে আপন লোকদের মধ্য থেকে অবশ্যই উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","তোমরা যেখানেই থাকো, কোনো পাখির অথবা পশুর রক্ত কখনও ভোজন করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","যদি কেউ রক্ত ভোজন করে, তাহলে আপনজনদের মধ্য থেকে সে অবশ্যই উচ্ছিন্ন হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“তুমি ইস্রায়েলীদের এই কথা বলো: ‘সদাপ্রভুর উদ্দেশে যদি কেউ মঙ্গলার্থক বলিদান আনে, তাহলে সদাপ্রভুর উদ্দেশে সে তার বলিদানের অংশ আনুক। ");
INSERT INTO benobcv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","সে নিজের হাতে সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহার নৈবেদ্যরূপে সদাপ্রভুর সামনে আনবে; বক্ষের সঙ্গে মেদও আনতে হবে এবং সেই বক্ষ দোলনীয়-নৈবেদ্যস্বরূপ সদাপ্রভুর সামনে দোলাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","বেদির উপরে যাজক মেদ জ্বালাবে, কিন্তু হারোণ ও তার ছেলেরা বক্ষের অধিকারী। ");
INSERT INTO benobcv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","তোমরা নিজ নিজ মঙ্গলার্থক বলিদানের ডান জাং উপহাররূপে যাজককে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","হারোণের যে ছেলে মঙ্গলার্থক বলিদানের রক্ত ও মেদ উৎসর্গ করবে, তার ভাগের অংশরূপে ডান জাং পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ইস্রায়েলীদের মঙ্গলার্থক বলিদান থেকে এক দোলনীয় বক্ষ আমি নিলাম ও উৎসর্গীকৃত জাং নিয়ে ইস্রায়েল-সন্তানদের দেয় চিরস্থায়ী অধিকাররূপে সেই নৈবেদ্য যাজক হারোণ ও তার ছেলেদের দিলাম।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","অগ্নিকৃত উপহারের এই অংশ সদাপ্রভুর উদ্দেশে নিবেদিত, যা সেদিন হারোণ ও তার ছেলেদের জন্য চিহ্নিত হল, যেদিন যাজকরূপে তারা সদাপ্রভুর সেবাকর্মে সমর্পিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","যেদিন তারা অভিষিক্ত হল, সেদিন সদাপ্রভু আদেশ দিলেন যে বংশপরম্পরায় ইস্রায়েলীদের দেয় চিরস্থায়ী অধিকাররূপে এই উৎসর্গীকৃত জাং তারা হারোণ ও তার ছেলেদের দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","হোমবলি, শস্য-নৈবেদ্য, পাপার্থক বলি, দোষার্থক-নৈবেদ্য, অভিষিক্তকরণ ও মঙ্গলার্থক বলিদানের পক্ষে এই বিধান, ");
INSERT INTO benobcv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","যা সেদিন সদাপ্রভু সীনয় পর্বতে মোশির প্রতি অর্পণ করেছিলেন, যেন ইস্রায়েলীরা সীনয় মরুভূমিতে সদাপ্রভুর উদ্দেশে তাদের সব বলিদান উৎসর্গ করে। ");
INSERT INTO benobcv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“তুমি হারোণ ও তার ছেলেদের, তাদের পোশাক-পরিচ্ছদ, অভিষেকার্থ তেল, পাপার্থক বলিদানের জন্য বাছুর, দুটি মেষ ও এক ঝুড়ি খামিরবিহীন রুটি আনো, ");
INSERT INTO benobcv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","এবং সমাগম তাঁবুর প্রবেশদ্বারে সমগ্র মণ্ডলীকে সমবেত করো।” ");
INSERT INTO benobcv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","সদাপ্রভুর আদেশমতো মোশি কাজ করলেন ও সমাগম তাঁবুর প্রবেশদ্বারে জনমণ্ডলী সমবেত হল। ");
INSERT INTO benobcv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","জনগণের উদ্দেশে মোশি বললেন, “এই কাজ করতে সদাপ্রভু আদেশ দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","পরে হারোণ ও তাঁর ছেলেদের মোশি সামনে আনলেন ও জল দিয়ে তাদের ধুয়ে দিলেন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","তিনি হারোণকে কাপড় পরালেন, রেশমি ফিতে দিয়ে তার কোমর বেঁধে, তার গায়ে পোশাক ও তার উপরে এফোদ দিলেন এবং একটি বুনানি করা কোমরবন্ধ দিয়ে তার গায়ের এফোদ বেঁধে দিলেন। এর দ্বারা হারোণ সুদৃঢ় হল। ");
INSERT INTO benobcv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","মোশি হারোণকে বুকপাটা দিলেন ও বুকপাটাতে ঊরীম ও তুম্মীম স্থাপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","পরে হারণের মাথায় তিনি পাগড়ি পরিয়ে দিলেন, এবং পাগড়ির সামনের দিকে সোনার পাত দিয়ে গড়া পবিত্র প্রতীক জুড়ে দিলেন, যেমন মোশিকে সদাপ্রভু আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","পরে মোশি অভিষেকার্থক তেল নিলেন, এবং সমাগম তাঁবু ও তার মধ্যের সমস্ত দ্রব্য অভিষিক্ত করলেন, এবং সেগুলি উৎসর্গ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","তিনি বেদিতে সাতবার তেল ছিটালেন; বেদি এবং বেদির সমস্ত পাত্র, খাড়া রাখার উপাদান সমেত প্রক্ষালন পাত্র পবিত্র করণার্থে অভিষেক করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","হারোণের মাথায় তিনি কিছুটা অভিষেকার্থক তেল ঢাললেন ও তাকে পবিত্র করণার্থে অভিষিক্ত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","তারপর তিনি হারোণের ছেলেদের সামনে আনলেন, কাপড় পরালেন, কটি বন্ধনে আবদ্ধ করলেন ও তাদের মাথায় শিরোভূষণের বন্ধনী দিলেন, যেমন মোশিকে সদাপ্রভু আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","পরে পাপার্থক বলিদানের জন্য তিনি বাছুর রাখলেন, এবং হারোণ ও তার ছেলেরা বাছুরটির মাথায় হাত রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","মোশি ওই বাছুরটিকে বধ করলেন এবং বেদি শুচি করার জন্য বেদির শিংগুলিতে আঙুল দিয়ে কিছুটা রক্ত ঢাললেন। অবশিষ্ট রক্ত তিনি বেদিমূলে ঢেলে দিলেন। এইভাবে প্রায়শ্চিত্ত করার জন্য তিনি সমস্তই পবিত্র করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","আর মোশি অন্ত্রের সব মেদ, যকৃতের পর্দা, দুটি কিডনি ও কিডনির মেদ ছাড়িয়ে নিলেন ও বেদিতে জ্বালিয়ে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","কিন্তু বাছুরটির চামড়া, মাংস ও গোবর শিবিরের বাইরে নিয়ে গেলেন ও সেগুলি পুড়িয়ে দিলেন, যেমন মোশিকে সদাপ্রভু আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","পরে হোমবলির জন্য তিনি মেষ রাখলেন এবং হারোণ ও তাঁর ছেলেরা সেটির মাথায় তাঁদের হাত রাখল। ");
INSERT INTO benobcv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","পরে মোশি ওই মেষকে বধ করলেন ও বেদির উপরে চারপাশে রক্ত ছিটালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","তিনি মেষটিকে খণ্ড খণ্ড করে কাটলেন এবং তার মাথা, মাংসখণ্ড, ও মেদ পোড়ালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","তিনি অন্ত্র ও পাগুলি জল দিয়ে ধুয়ে দিলেন এবং হোমবলিরূপে গোটা মেষ বেদিতে পোড়ালেন যা সদাপ্রভুর উদ্দেশে নিবেদিত অগ্নিকৃত সৌরভার্থক সন্তোষজনক উপহার, যেমন মোশিকে সদাপ্রভু আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","এরপর অভিষেকের জন্যে তিনি অন্য একটি মেষ রাখলেন, এবং হারোণ ও তাঁর ছেলেরা সেটির মাথায় হাত রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","মোশি ওই মেষকে বধ করলেন এবং হত মেষের কিছুটা রক্ত নিয়ে হারোণের ডান কানের ডগায়, তার ডান হাতের বুড়ো আঙুলে ও তার ডান পায়ের বুড়ো আঙুলে লেপন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","মোশি হারোণের ছেলেদেরও সামনে আনলেন এবং তাদের ডান কানের ডগায়, তাদের ডান হাতের বুড়ো আঙুলে ও ডান পায়ের বুড়ো আঙুলে কিছুটা রক্ত ঢেলে দিলেন। পরে তিনি বেদির উপরে চারপাশে রক্ত ছিটালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","এরপরে তিনি মেদ, মেদযুক্ত লেজ, অন্ত্রবেষ্টিত সব মেদ, যকৃতের পর্দা, দুটি কিডনি ও কিডনির মেদ ডান জাং-এ ছাড়িয়ে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","পরে সদাপ্রভুর সামনে রাখা খামিরবিহীন রুটির ঝুড়ি থেকে একটি রুটি, তৈলপক্ক একটি রুটি এবং একটি সরুচাকলি তিনি তুলে নিলেন, তিনি মেদের অংশে ও ডান জাং-এ এগুলি রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","হারোণ ও তার ছেলেদের হাতে তিনি এগুলি দিলেন, এবং দোলনীয়-নৈবেদ্যরূপে সদাপ্রভুর সামনে এগুলি দোলালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","এরপর তাদের হাত থেকে মোশি সেগুলি নিলেন এবং অভিষেক নৈবেদ্যরূপে হোমবলির উপরে বেদিতে সকল নৈবেদ্য পোড়ালেন, যা সদাপ্রভুর উদ্দেশে নিবেদিত অগ্নিকৃত সৌরভার্থক সন্তোষজনক এক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","তিনি বক্ষটিও নিলেন যা অভিষেক মেষ থেকে মোশির অংশ এবং দোলনীয় এক নৈবেদ্যরূপে সদাপ্রভুর সামনে সেটি দোলালেন যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","পরে মোশি বেদি থেকে কিছুটা অভিষেকার্থক তেল ও রক্ত নিলেন এবং হারোণ ও তাঁর পরিধানে এবং তাঁর সকল ছেলে ও তাদের পোশাকে ছিটালেন। এইভাবে হারোণ ও তাঁর পোশাককে, এবং তাঁর সকল ছেলে ও তাদের পোশাককে মোশি পবিত্র করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","পরে হারোণ ও তার ছেলেদের মোশি বললেন, “সমাগম তাঁবুর প্রবেশদ্বারে তোমরা মাংস রান্না করো ও অভিষেক নৈবেদ্যগুলির ঝুড়ি থেকে রুটি নিয়ে মাংস দিয়ে ভোজন করো: ‘যেমন আমি বললাম, হারোণ ও তার ছেলেরা সবাই সেরকমই করুক।’ ");
INSERT INTO benobcv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","পরে অবশিষ্ট মাংস ও রুটি পুড়িয়ে দাও। ");
INSERT INTO benobcv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","সাত দিনের জন্য সমাগম তাঁবুর প্রবেশদ্বার ছেড়ে যেয়ো না, যতদিন না তোমাদের অভিষেকের দিনগুলি সম্পূর্ণ হয়, কেননা তোমাদের অভিষেক সাত দিন স্থায়ী হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","সদাপ্রভুর আদেশানুসারে আজ সেই কাজ করা হল, যেন তোমাদের জন্য প্রায়শ্চিত্ত সাধিত হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","সমাগম তাঁবুর প্রবেশদ্বারে দিনরাত সাত দিন অবধি তোমরা অবশ্যই থেকো, এবং সদাপ্রভুর চাহিদা অনুযায়ী কাজ করো; তাহলে তোমরা মরবে না; কেননা আমাকে এই আদেশ করা হয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","সুতরাং মোশির মাধ্যমে সদাপ্রভুর আদেশ অনুযায়ী হারোণ ও তাঁর ছেলেরা সকল কাজ করল। ");
INSERT INTO benobcv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","অষ্টম দিনে হারোণ, তাঁর সব ছেলেদের ও ইস্রায়েলের প্রাচীনবর্গকে মোশি ডাকলেন, ");
INSERT INTO benobcv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","তিনি হারোণকে বললেন, “তুমি পাপার্থক-নৈবেদ্যরূপে ত্রুটিহীন এক এঁড়ে বাছুর ও হোমবলিরূপে ত্রুটিহীন এক মেষ নাও এবং সদাপ্রভুর সামনে নিয়ে এসো। ");
INSERT INTO benobcv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","পরে ইস্রায়েলীদের তিনি বললেন, ‘পাপার্থক-নৈবেদ্যরূপে তোমরা একটি পাঁঠা ও হোমবলিরূপে একটি বাছুর, একটি মেষশাবক নাও; দুটিই যেন এক বর্ষীয় ও ত্রুটিমুক্ত হয়, ");
INSERT INTO benobcv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","এবং মঙ্গলার্থক বলিদানের জন্য একটি ষাঁড় ও একটি মেষ এবং জলপাই তেলে মেশানো শস্য-নৈবেদ্য নেবে সদাপ্রভুর সামনে উৎসর্গ করার জন্য, কেননা আজ তোমাদের সামনে সদাপ্রভু আবির্ভূত হবেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","মোশির আদেশানুসারে তারা এইসব সমাগম তাঁবুর সামনে আনল, এবং সমগ্র জনমণ্ডলী কাছে এল ও সদাপ্রভুর সামনে দাঁড়াল। ");
INSERT INTO benobcv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","পরে মোশি বললেন, “সদাপ্রভু এই কাজ করতে তোমাদের আদেশ দিয়েছেন, যেন সদাপ্রভুর মহিমা তোমাদের প্রতি প্রদর্শিত হয়।” ");
INSERT INTO benobcv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","মোশি হারোণকে বললেন, “তুমি বেদির নিকটবর্তী হও এবং তোমার পাপার্থক বলি ও তোমার হোমবলি উৎসর্গ করো এবং তোমার ও লোকদের পক্ষে প্রায়শ্চিত্ত করো; লোকদের জন্য উপহার নিবেদন করো এবং তাদের জন্য প্রায়শ্চিত্ত করো, যেমন সদাপ্রভু আজ্ঞা দিয়েছিলেন।” ");
INSERT INTO benobcv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","সুতরাং হারোণ বেদির কাছে এলেন ও নিজের পাপার্থক বলিরূপে এঁড়ে বাছুর বধ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","তাঁর ছেলেরা তাঁকে রক্ত এনে দিল এবং তিনি তাঁর আঙুল রক্তে ডুবালেন, বেদির শৃঙ্গগুলিতে রক্তের প্রলেপ দিলেন ও অবশিষ্ট রক্ত বেদিমূলে নিক্ষেপ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","পাপার্থক বলি থেকে মেদ, দুটো কিডনি ও যকৃতের পর্দা নিয়ে তিনি বেদিতে সেগুলি পোড়ালেন, যেমন মোশিকে সদাপ্রভু আদেশ দিয়েছিলেন; ");
INSERT INTO benobcv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","তিনি শিবিরের বাইরে মাংস ও চামড়া পোড়ালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","পরে তিনি হোমবলি বধ করলেন, তার ছেলেরা রক্ত এগিয়ে দিল এবং তিনি বেদির উপরে চারপাশে রক্ত ছিটালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ছেলেরা খণ্ড খণ্ড করে হোমবলি মাথা সমেত হারোণের হাতে দিল এবং হারোণ সেগুলি বেদিতে পোড়ালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","তিনি অন্ত্র ও পাগুলি ধুয়ে দিলেন ও বেদিতে হোমবলির উপরে সেগুলি পোড়ালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","পরে হারোণ উপহার আনলেন, যা লোকদের জন্য ছিল। লোকদের পাপার্থক বলিদানের জন্য তিনি ছাগল নিলেন, সেটি বধ করলেন এবং পাপার্থক বলিরূপে উপহার দিলেন, যেমন প্রথম উপহার দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","তিনি হোমবলি আনলেন ও নিয়মানুসারে তা নিবেদন করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","তিনি শস্য-নৈবেদ্যও আনলেন, ওই নৈবেদ্য থেকে এক মুঠি নিলেন এবং বেদিতে তা পোড়ালেন, যা প্রাতঃকালীন হোমবলির অতিরিক্ত। ");
INSERT INTO benobcv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","লোকদের পক্ষে মঙ্গলার্থক বলিরূপে ষাঁড় ও মেষ তিনি বধ করলেন। তাঁর ছেলেরা তাঁর হাতে রক্ত জোগান দিল এবং তিনি বেদির উপরে চারপাশে রক্ত ছিটালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","কিন্তু ষাঁড় ও মেষের মেদের অংশ, মেদযুক্ত লেজ, মেদের স্তর, দুটি কিডনি ও যকৃতের পর্দা, ");
INSERT INTO benobcv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","তারা সেগুলি বক্ষস্থলে রাখল ও পরে হারোণ বেদির উপরে মেদ পোড়ালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","সদাপ্রভুর সামনে হারোণ বক্ষদুটি ও ডান জাং দোলনীয়-নৈবেদ্যরূপে দোলান, যেমন মোশি আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","পরে লোকদের দিকে হারোণ তাঁর হাত তুলে ধরলেন ও তাদের আশীর্বাদ করলেন। পাপার্থক বলি, হোমবলি ও মঙ্গলার্থক বলিদান শেষ হওয়ার পরে হারোণ নিচে নামলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","পরে মোশি ও হারোণ সমাগম তাঁবুর মধ্যে গেলেন। শিবির থেকে বেরিয়ে এসে তাঁরা লোকদের আশীর্বাদ করলেন, এবং সব লোকের কাছে সদাপ্রভুর প্রতাপ আবির্ভূত হল। ");
INSERT INTO benobcv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","সদাপ্রভুর উপস্থিতি থেকে আগুন নির্গত হল এবং বেদিতে রাখা হোমবলি ও মেদমিশ্রিত অংশগুলিকে সেই আগুন গ্রাস করল। সব লোক এই দৃশ্য চাক্ষুষ করে, হর্ষধ্বনি করল ও উবুড় হয়ে পড়ল। ");
INSERT INTO benobcv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","হারোণের ছেলে নাদব ও অবীহূ তাদের ধূপাধার নিল, এবং তাতে ধূপ দিয়ে আগুন সংযোগ করল ও সদাপ্রভুর সামনে অসমর্থিত আগুন উৎসর্গ করল, যা তাঁর আজ্ঞার পরিপন্থী। ");
INSERT INTO benobcv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","সুতরাং সদাপ্রভুর উপস্থিতি থেকে অগ্নি নির্গত হয়ে তাদের গ্রাস করল ও সদাপ্রভুর সামনে তারা মারা গেল। ");
INSERT INTO benobcv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","পরে মোশি হারোণকে বললেন, সদাপ্রভু এমন কথাই বলেছিলেন যখন তিনি আমাকে বলেছিলেন: “ ‘যারা আমার নিকটবর্তী হয়, তাদের আমি আমার পবিত্রতা দেখাব ও সব মানুষের দৃষ্টিতে আমি সম্মানিত হব।’ ” হারোণ নীরব থাকলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","হারোণের কাকা উষীয়েলের ছেলে মীশায়েল ও ইল্‌সাফনকে মোশি ডাকলেন ও তাদের বললেন, “তোমরা এখানে এসো; ধর্মধামের সামনে থেকে দূরে, শিবিরের বাইরে তোমাদের জ্ঞাতিদের নিয়ে যাও।” ");
INSERT INTO benobcv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","সুতরাং তারা এল, জ্ঞাতিদের বহন করল ও কাপড় পরা অবস্থাতেই তাদের শিবিরের বাইরে নিয়ে গেল, যেমন মোশি আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","পরে হারোণ, তাঁর ছেলে ইলীয়াসর ও ঈথামরকে মোশি বললেন, “তোমাদের মাথা নেড়া কোরো না ও তোমাদের পরিধান ছিঁড়ো না, পাছে তোমরাও মারা যাও, এবং সমগ্র জনমণ্ডলীর উপরে সদাপ্রভুর ক্রোধ বর্ষিত হয়। কিন্তু তোমাদের পরিজন, ইস্রায়েলের সমগ্র সমাজ সদাপ্রভুর কৃত অগ্নিদ্বারা মৃতদের জন্য কাঁদুক। ");
INSERT INTO benobcv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","সমাগম তাঁবুর প্রবেশদ্বার ত্যাগ কোরো না, অন্যথায় তোমরা মরবে, কেননা তোমাদের গায়ে সদাপ্রভুর অভিষেকার্থক তেল আছে।” সুতরাং মোশি যেমন বললেন তারা তেমনই করল। ");
INSERT INTO benobcv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","পরে সদাপ্রভু হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“সমাগম তাঁবুতে যাওয়ার সময় তোমরা দ্রাক্ষারস অথবা মদ্যপান করবে না, নইলে তোমরা মরবে। এটি বংশপরম্পরায় তোমাদের পালনীয় চিরস্থায়ী বিধি, ");
INSERT INTO benobcv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","যেন পবিত্র ও সাধারণের মধ্যে, শুচি ও অশুচির মধ্যে তুমি অবশ্যই পার্থক্য রাখো ");
INSERT INTO benobcv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","এবং মোশির মাধ্যমে সদাপ্রভু যেসব বিধি দিয়েছেন সেগুলি তুমি ইস্রায়েলীদের অবশ্যই শেখাবে।” ");
INSERT INTO benobcv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","মোশি হারোণকে ও তাঁর দুই ছেলে ইলীয়াসর ও ঈথামরকে বললেন, “সদাপ্রভুর উদ্দেশে নিবেদিত অগ্নিকৃত উপহারের অবশিষ্ট যে শস্য-নৈবেদ্য আছে, তা নিয়ে বেদির পাশে খামিরবিহীন খাদ্য প্রস্তুত ও ভোজন করো, কেননা এটি অত্যন্ত পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","এক পবিত্রস্থানে এই খাদ্য ভোজন করো, কেননা এটি তোমার ও তোমার ছেলেদের অংশ যা সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহার; কেননা আমি এই আজ্ঞা পেয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","কিন্তু তুমি, তোমার ছেলেমেয়েরা বক্ষ ভোজন করবে, যা দোলানো হল এবং জাং যা সামনে রাখা হল; আনুষ্ঠানিকভাবে শুচি জায়গায় তোমরা এই খাদ্য ভোজন করবে; ইস্রায়েলীদের মঙ্গলার্থক বলি থেকে তোমাদের অংশরূপে এই ভক্ষ্য তোমাকে ও তোমার সন্তানদের দেওয়া হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","নিবেদিত জাং ও দোলায়িত বক্ষ অগ্নিকৃত উপহারের মেদযুক্ত অংশগুলির সঙ্গে অবশ্যই আনতে হবে, যেন দোদুল্যমান উপহাররূপে সদাপ্রভুর সামনে সেগুলি দোলানো হয়। এগুলি তোমার ও তোমার সন্তানদের নিয়মিত অংশ হবে, যেমন সদাপ্রভু আদেশ দিয়েছেন।” ");
INSERT INTO benobcv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","যখন মোশি পাপার্থক বলির জন্য ছাগল অন্বেষণ করলেন, তিনি জানতে পারলেন যে হারোণের অবশিষ্ট দুই ছেলে ইলীয়াসর ও ঈথামর ছাগল পুড়িয়ে দিয়েছে, মোশি ক্রুদ্ধ হয়ে জানতে চাইলেন, ");
INSERT INTO benobcv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“পবিত্রস্থানের এলাকায় তোমরা পাপার্থক বলি ভোজন করলে না কেন? এটি অত্যন্ত পবিত্র এবং জনমণ্ডলীর অপরাধ বহনার্থে সদাপ্রভুর সামনে প্রায়শ্চিত্ত করণার্থে তিনি এটি তোমাদের দিয়েছেন। ");
INSERT INTO benobcv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","যেহেতু এর রক্ত পবিত্রস্থানে আনা হয়নি, তাই আমার আজ্ঞানুসারে পবিত্রস্থানের এলাকায় তোমাদের এই ছাগল ভোজন করা উচিত ছিল।” ");
INSERT INTO benobcv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","হারোণ মোশিকে উত্তর দিলেন, “আজ সদাপ্রভুর সামনে তারা তাদের পাপার্থক বলি ও হোমবলি উৎসর্গ করল, কিন্তু এই ধরনের ঘটনা আমার প্রতি ঘটল। সদাপ্রভু কি সন্তুষ্ট হতেন, যদি আজ আমি পাপার্থক বলি ভোজন করতাম?” ");
INSERT INTO benobcv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","এই কথা শুনে মোশি সন্তুষ্ট হলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“তোমরা ইস্রায়েলীদের বলো, ‘ভূচর সব পশুর মধ্যে সমস্ত জীব তোমাদের খাদ্য হবে: ");
INSERT INTO benobcv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","পশুদের মধ্যে যেসব পশু দ্বিখণ্ড খুরবিশিষ্ট ও জাবর কাটে, তার মাংস তোমরা ভোজন করতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘পশুদের মধ্যে যে পশুরা কেবল জাবর কাটে অথবা কেবল দ্বিখণ্ড খুরবিশিষ্ট, তোমরা কোনোভাবে সেই পশু ভক্ষণ করবে না। উট যদিও জাবর কাটে, কিন্তু দ্বিখণ্ড খুরবিশিষ্ট নয়, তাই আনুষ্ঠানিকভাবে তোমাদের পক্ষে উট অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","শাফন জাবর কাটলেও দ্বিখণ্ড খুরবিশিষ্ট নয়; তাই তোমাদের পক্ষে এটি অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","খরগোশ যদিও জাবর কাটে, কিন্তু দ্বিখণ্ড খুরবিশিষ্ট নয়; তোমাদের পক্ষে এটি অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","আর শূকর যদিও তার খুর দ্বিখণ্ডিত, জাবর কাটে না; তোমাদের পক্ষে এটি অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","তোমরা তাদের মাংস খাবে না কিংবা তাদের মৃতদেহও ছোঁবে না; তোমাদের পক্ষে এগুলি অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘সমুদ্রের জলে ও জলস্রোতে বসবাসকারী সব প্রাণীর মধ্যে যেগুলির ডানা ও আঁশ আছে সেগুলি তোমরা খেতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","কিন্তু সমুদ্রে অথবা জলস্রোতে বসবাসকারী যে প্রাণীদের ডানা ও আঁশ নেই, সেগুলি ঝাঁকে ঝাঁকে থাকলেও অথবা জলচর প্রাণীদের দলভুক্ত হলেও সেগুলি তোমাদের ঘৃণার্হ। ");
INSERT INTO benobcv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","যেহেতু সেগুলি তোমাদের কাছে ঘৃণার্হ, তাই তোমরা কিছুতেই সেগুলির মাংস ভক্ষণ করবে না; সেগুলির মৃতদেহও অবশ্যই ঘৃণা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","জলচর যে প্রাণীদের ডানা ও আঁশ নেই, তোমাদের পক্ষে সেগুলি ঘৃণার্হ। ");
INSERT INTO benobcv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘এই পাখিগুলিকে তোমাদের ঘৃণা করতে হবে এবং তাদের মাংস তোমরা ভক্ষণ করবে না, কারণ সেগুলি ঘৃণার্হ: এগুলি ঈগল, শকুন, কালো শকুন, ");
INSERT INTO benobcv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","লাল চিল, যে কোনো ধরনের কালো চিল, ");
INSERT INTO benobcv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","যে কোনো ধরনের দাঁড়কাক, ");
INSERT INTO benobcv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","শিংযুক্ত প্যাঁচা, কালপ্যাঁচা, শঙ্খচিল, যে কোনোরকম বাজপাখি, ");
INSERT INTO benobcv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ছোটো প্যাঁচা, পানকৌড়ি, বড়ো প্যাঁচা, ");
INSERT INTO benobcv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","সাদা প্যাঁচা, মরু-প্যাঁচা, সিন্ধু-ঈগল, ");
INSERT INTO benobcv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","সারস, যে কোনো ধরনের কাক, ঝুঁটিওয়ালা পাখি ও বাদুড়। ");
INSERT INTO benobcv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘চার পায়ে চলা সব পতঙ্গ তোমাদের ঘৃণিত। ");
INSERT INTO benobcv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","অন্যদিকে কিছু ডানাওয়ালা প্রাণী রয়েছে, যারা চার পায়ে গমনাগমন করে, সেগুলি তোমরা ভোজন করতে পারো; ভূমিতে গমনশীল চতুষ্পদ প্রাণীদের মধ্যে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","যে কোনো ধরনের পঙ্গপাল, বাঘাফড়িং, ঝিঁঝি অথবা অন্য ধরনের ফড়িং তোমরা ভোজন করতে পারো, ");
INSERT INTO benobcv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","কিন্তু ডানাওয়ালা যে প্রাণীরা চতুষ্পদ, তারা তোমাদের কাছে ঘৃণার্হ। ");
INSERT INTO benobcv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘এসব দ্বারা তোমরা অশুচি হবে, যে কেউ ঘৃণিত প্রাণীদের অথবা পাখিদের মৃতদেহ স্পর্শ করবে, সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","যে কেউ তাদের মৃতদেহ তুলে ধরবে, তাকে তার পরিধান ধুতেই হবে এবং সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘যেসব পশু কিছুটা ছিন্ন ক্ষুরবিশিষ্ট, পুরোপুরি দ্বিখণ্ডিত নয়, অথবা জাবর কাটে না, তোমাদের পক্ষে এরা অশুচি। যে কেউ তাদের কোনো মৃতদেহ স্পর্শ করবে, সে অশুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","যেসব পশু চার পায়ে গমনাগমন করে, যে পশুরা থাবা ফেলে চলে, তোমাদের পক্ষে ওরা অশুচি। ওদের মৃতদেহ যে কেউ স্পর্শ করবে, সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","তাদের মৃতদেহ যদি কেউ তুলে নেয়, তার পরিধান তাকে ধুতেই হবে, এবং সন্ধ্যা অবধি সে অশুচি থাকবে। এই পশুগুলি তোমাদের পক্ষে অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘ভূমিতে বিচরণকারী পশুরা তোমাদের পক্ষে অশুচি, যেমন বেজি, ইঁদুর, বড়ো চেহারার যে কোনো ধরনের টিকটিকি, ");
INSERT INTO benobcv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","গোসাপ, নীল টিকটিকি, মেটে গিড়গিটি, সবুজ টিকটিকি ও কাঁকলাশ। ");
INSERT INTO benobcv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","এগুলির মধ্যে যেগুলি ভূমিতে চলে, তোমাদের পক্ষে সেগুলি অশুচি। ওদের মৃতদেহ যে কেউ স্পর্শ করবে, সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","এদের একটি যখন মরে ও কোনো কিছুর উপরে পড়ে যায়, কাঠ, কাপড়, চামড়া, অথবা চটের তৈরি সেই উপাদান ব্যবহৃত হলে সেটি অশুচি হবে। সেটি জলে ডোবাবে; সন্ধ্যা পর্যন্ত সেটি অশুচি থাকবে, পরে শুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","যদি তাদের মধ্যে কোনও একটি মাটির কোনো পাত্রে পড়ে যায়, পাত্রস্থিত সবকিছুই অশুচি হবে এবং পাত্রটি তোমরা অবশ্যই ভেঙে ফেলবে, ");
INSERT INTO benobcv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","কোনো খাদ্য ভোজনযোগ্য হলে যদি উপরোক্ত পাত্র থেকে সেই খাদ্যে জল পড়ে, তাহলে সেই খাদ্য অশুচি হবে এবং সেই পাত্র থেকে পানযোগ্য যে কোনো পানীয় অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","যদি কোনো দ্রব্যের উপরে তাদের মৃতদেহ থেকে কিছুটা পড়ে যায়, তাহলে সেই জিনিস অশুচি হবে; উনুন অথবা রান্নার বাসন ভেঙে ফেলতে হবে; ওগুলি অশুচি এবং তোমরা ওই উপাদানগুলিকে অশুচি বিবেচনা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","অন্যদিকে, জলধারা অথবা চৌবাচ্চা শুচি রাখতে হবে, কিন্তু কেউ যদি কোনো মৃতদেহ স্পর্শ করে, সে অশুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","তাদের মৃতদেহের কিছুটা যদি বপনীয় বীজের উপরে পতিত হয়, বীজগুলি শুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","কিন্তু বীজের উপরে যদি জল ছিটানো হয় ও সেগুলির উপরে মৃতদেহ পড়ে যায়, তাহলে তোমাদের পক্ষে তা অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘তোমাদের ভোজনযোগ্য কোনো পশু যদি মরে এবং যদি কেউ মৃতদেহটি স্পর্শ করে, তাহলে সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","মৃতদেহগুলির কিছুটা যদি কেউ ভোজন করে, সে তার পরিধান অবশ্যই ধুয়ে দেবে এবং সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। যদি কেউ মৃতদেহ বহন করে তাহলে তাকে তার পরিধান অবশ্যই ধুয়ে দিতে হবে এবং সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘ভূমিতে গমনশীল সমস্ত প্রাণী ঘৃণিত; তাদের মাংস ভক্ষণ করা নিষিদ্ধ। ");
INSERT INTO benobcv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ভূমিতে গমনশীল কোনো প্রাণী তোমরা ভোজন করবে না; হতে পারে তারা পেটে অথবা চার পায়ে কিংবা ততোধিক পায়ে ভর দিয়ে চলে; সেগুলি ঘৃণিত। ");
INSERT INTO benobcv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","এই পতঙ্গগুলির মধ্যে থেকে কোনো কিছুর দ্বারা তোমরা নিজেদের অশুচি করো না। তাদের কাজে লাগিয়ে অথবা তাদের দ্বারা তোমরা অশুচি হোয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","আমি তোমাদের ঈশ্বর সদাপ্রভু; তোমরা উৎসর্গীকৃত ও পবিত্র হও, কেননা আমি পবিত্র। ভূমিতে গমনশীল কোনো প্রাণী দ্বারা নিজেদের অশুচি কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","আমি সদাপ্রভু মিশর থেকে তোমাদের বের করে এনেছি, যেন তোমাদের ঈশ্বর হতে পারি; অতএব, তোমরা পবিত্র হও, যেমন আমি পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘এই নিয়মাবলি সব ধরনের পশু, পাখি, জলে গমনশীল সব ধরনের প্রাণী এবং ভূমিতে গমনশীল প্রত্যেক প্রাণীর ক্ষেত্রে প্রযোজ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","অশুচি ও শুচির মধ্যে এবং খাদ্য ও অখাদ্য জীবিত প্রাণীদের মধ্যে তোমরা অবশ্যই পার্থক্য রাখবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“তুমি ইস্রায়েলীদের বলো: ‘সন্তান গর্ভধারণ করার পর কোনো মহিলা যখন একটি ছেলের জন্ম দেয় তবে সে আনুষ্ঠানিকভাবে সাত দিনের জন্য অশুচি থাকবে, যেমন তার মাসিক ঋতুস্রাব থাকাকালীন সে অশুচি থাকে। ");
INSERT INTO benobcv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","অষ্টম দিনে বালকটিকে সুন্নত করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","পরে মহিলাটি তার রক্তস্রাব থেকে শুদ্ধ হওয়ার জন্য তেত্রিশ দিন অপেক্ষা করবে। তার শুচিশুদ্ধ হওয়ার দিনগুলি অতিবাহিত না হওয়া পর্যন্ত সে কোনোভাবে পবিত্র বস্তু স্পর্শ করবে না অথবা পবিত্রস্থানে যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","যদি সে একটি মেয়ের জন্ম দেয়, তাহলে দুই সপ্তাহের জন্য তার অশুদ্ধতা থাকবে, যেমন ঋতুস্রাব থাকাকালীন সে অশুচি থাকে। তারপর তার রক্তস্রাব থেকে শুচিশুদ্ধ হওয়ার জন্য তাকে ছেষট্টি দিন অবশ্যই প্রতীক্ষা করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘যখন একটি ছেলে অথবা মেয়ের জন্য তার শুচিশুদ্ধ হওয়ার দিনগুলি অতিবাহিত হয়, হোমবলির জন্য এক বর্ষীয় মেষশাবক ও পাপার্থক বলির জন্য একটি কপোতশাবক অথবা একটি ঘুঘু সে সমাগম তাঁবুর প্রবেশদ্বারে যাজকের কাছে আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","তার জন্য প্রায়শ্চিত্ত সাধনার্থে সদাপ্রভুর যাজক সেগুলি উৎসর্গ করবে এবং পরে ওই মহিলা তার রক্তস্রাব থেকে আনুষ্ঠানিকভাবে শুচিশুদ্ধ হবে। “ ‘এই নিয়মাবলি ওই মহিলার জন্য, যে একটি ছেলে অথবা একটি মেয়ের জন্ম দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","যদি সে একটি মেষশাবক জোগান দিতে না পারে, তাহলে দুটি ঘুঘু কিংবা দুটি কপোতশাবক আনবে; প্রথমটি হোমবলিদানার্থে ও দ্বিতীয়টি পাপার্থক বলিদানার্থে তার নিবেদন। এইভাবে তার জন্য যাজক প্রায়শ্চিত্ত করবে এবং সে শুচিশুদ্ধ হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“যদি কারোর চামড়ায় ফোঁড়া অথবা ফুসকুড়ি কিংবা উজ্জ্বল দাগ দেখা যায়, তা সংক্রামক চর্মরোগ হতে পারে, তাহলে তাকে অবশ্যই যাজক হারোণের কাছে অথবা তার কোনো ছেলের সামনে আনতে হবে এবং সেই ছেলে যেন যাজক হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","যাজক ওই ব্যক্তির চামড়ায় ক্ষত পরীক্ষা করবে এবং যদি ক্ষতের লোম সাদা রংয়ের হয়ে থাকে ও ক্ষতটির আকার চামড়ার গভীরতার চেয়েও গভীর মনে হয়, তাহলে তা এক সংক্রামক চর্মরোগ। সেটি পরীক্ষা করে যাজক তাকে অশুচি বলবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","যদি তার চামড়ার ক্ষতস্থান সাদা রংয়ের হয়, কিন্তু চামড়ার গভীরতার চেয়েও ক্ষতস্থান বেশি গভীর এবং ক্ষতস্থানের লোম সাদা রংয়ের হয়নি, তাহলে যাজক তাকে সাত দিন পৃথক জায়গায় রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","সপ্তম দিনে যাজক তাকে পরীক্ষা করবে এবং যদি তার নজরে ক্ষত অপরিবর্তিত থাকে ও চামড়ায় তা প্রসারিত না হয়, তাহলে আরও সাত দিন যাজক তাকে পৃথক জায়গায় রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","সপ্তম দিনে যাজক আবার তাকে পরীক্ষা করবে এবং যদি ক্ষত মুছে যায় ও চামড়ায় প্রসারিত না হয় তাহলে যাজক তাকে শুচি ঘোষণা করবে। মানুষটির শুধু ফুসকুড়ি হয়েছে। সে অবশ্যই তার পরিধান ধুয়ে নেবে ও শুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","নিজে শুচি ঘোষিত হওয়ার জন্য যাজকের কাছে নিজেকে দেখানোর পরে যদি সেই ফুসকুড়ি তার চামড়ায় প্রসারিত হয়, তাহলে সে আবার যাজকের সামনে উপস্থিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","যাজক তাকে পরীক্ষা করবে এবং যদি তার চামড়ায় ফুসকুড়ি প্রসারিত হয়ে থাকে তাহলে যাজক তাকে অশুচি বলবে; এটি এক সংক্রামক রোগ। ");
INSERT INTO benobcv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“যখন কারোর সংক্রামক চর্মরোগ হয়, যাজকের কাছে তাকে আনতেই হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","যাজক তাকে পরীক্ষা করবে এবং যদি চামড়ায় সাদা রংয়ের ফোঁড়া হয় ও লোম সাদা রং হয়ে যায় এবং ফোঁড়াতে কাঁচা মাংস থাকে, ");
INSERT INTO benobcv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","তাহলে এটি এক দুরারোগ্য চর্মরোগ এবং যাজক তাকে অশুচি বলবে ও তাকে আলাদা জায়গায় রাখবে না, কারণ ইতিমধ্যে সে অশুচি হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“যদি তার সারা শরীরে রোগ প্রসারিত হয় এবং যাজকের নজরে পড়ে যে সংক্রমিত মানুষটি আপাদমস্তক রোগগ্রস্ত, ");
INSERT INTO benobcv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","তাহলে যাজক তাকে পরীক্ষা করবে এবং যদি তার সারা শরীর রোগে আচ্ছন্ন হয়ে থাকে, তাহলে যাজক তাকে শুচি বলবে। যেহেতু তার সারা শরীর সাদা হয়ে গিয়েছে, তাই সে শুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","কিন্তু যখনই তার দেহে কাঁচা মাংস দেখা যায়, সে অশুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","কাঁচা মাংস যাজকের নজরে পড়লে যাজক তাকে অশুচি বলবে। কাঁচা মাংস অশুচি; তার সংক্রমিত রোগ হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","কাঁচা মাংস অপরিবর্তিত হয়ে যদি সাদা রং হয়ে যায়, তাহলে সে অবশ্যই যাজকের কাছে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","যাজক তাকে পরীক্ষা করবে এবং যদি ক্ষতস্থানগুলি সাদা রং হয়, তাহলে সংক্রমিত মানুষটিকে যাজক শুচি বলবে; এইভাবে সে শুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“যখন কারোর চামড়ায় একটি ফোঁড়া থাকে এবং তা সেরে যায়, ");
INSERT INTO benobcv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","আর ফোঁড়ার জায়গায় সাদা রংয়ের অথবা হালকা শ্বেতির ছোপ দেখা যায়, তাহলে তাকে অবশ্যই যাজকের কাছে আনতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","যাজক তাকে পরীক্ষা করবে এবং যদি চামড়ার গভীরতার চেয়েও তা বেশি গভীর দেখায় ও সংক্রমিত স্থানের লোম সাদা হয়ে যায়, তাহলে যাজক তাকে অশুচি বলবে। এটি এক সংক্রামক চর্মরোগ, যা ফোঁড়া রূপে উৎপাদিত হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","কিন্তু যাজকের পরীক্ষায় যদি দেখা যায়, তাতে সাদা রংয়ের লোম নেই এবং চামড়ার গভীরতার চেয়ে তা বেশি গভীর নয়, দাগ মুছে গিয়েছে, তাহলে যাজক সাত দিনের জন্য তাকে পৃথক রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","যদি চামড়ায় দাগ প্রসারিত হতে থাকে, তাহলে যাজক তাকে অশুচি বলবে; রোগটি সংক্রামক। ");
INSERT INTO benobcv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","কিন্তু যদি দাগ অপরিবর্তিত থাকে এবং না বাড়ে, এটি ফোঁড়ার ক্ষতচিহ্নমাত্র ও যাজক তাকে শুচি বলবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“যখন কারো চামড়া পুড়ে যায় এবং পোড়া কাঁচা মাংসে হালকা রক্তিম সাদাটে অথবা সাদা দাগ দেখা যায়, ");
INSERT INTO benobcv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","তাহলে যাজক সেই দাগ পরীক্ষা করবে এবং যদি ওই স্থানের লোম সাদা রং হয়ে যায় ও চামড়া থেকে অংশটি নিম্ন মানের মনে হয়, তাহলে এটি এক সংক্রামক রোগ, যা আগুনে পুড়ে উৎপন্ন হয়েছে। যাজক তাকে অশুচি বলবে; এটি সংক্রামক এক চর্মরোগ। ");
INSERT INTO benobcv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","কিন্তু যদি যাজক দ্বারা পরীক্ষা করার পর ক্ষতস্থানে সাদা রংয়ের লোম না দেখা যায় ও চামড়ার গভীরে না থাকে, দাগ মুছে যায়, তাহলে যাজক সাত দিনের জন্য তাকে পৃথক স্থানে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","সপ্তম দিনে যাজক তাকে পরীক্ষা করবে এবং যদি তার চর্মরোগ ছড়িয়ে যায়, তাহলে যাজক তাকে অশুচি বলবে; এটি সংক্রামক এক চর্মরোগ। ");
INSERT INTO benobcv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","অন্যদিকে, যদি দাগ অপরিবর্তিত থাকে এবং চামড়ায় ছড়িয়ে না যায়, কিন্তু দাগ দেখা না যায়, তাহলে তা আগুনে পোড়া এক ফোলা অংশ এবং যাজক তাকে শুচি বলবে; এটি কেবল আগুনে পোড়া এক ক্ষতচিহ্ন। ");
INSERT INTO benobcv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“যদি কোনো নর বা নারীর মাথায় কিংবা থুতনিতে ক্ষত থাকে, ");
INSERT INTO benobcv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","তাহলে যাজক সেই ক্ষত পরীক্ষা করবে এবং যদি সেই ক্ষত চামড়ার চেয়েও গভীরে থাকে এবং ক্ষতস্থানের লোম হলুদ ও রুগ্ন হয়, তাহলে ওই মানুষকে যাজক অশুচি ঘোষণা করবে; এটি মস্তকের অথবা থুতনির এক সংক্রামক রোগ। ");
INSERT INTO benobcv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","কিন্তু যদি যাজক দ্বারা এই ধরনের ক্ষত পরীক্ষা করার পর তা চামড়ার চেয়েও গভীরে না থাকে এবং সেখানে কালো রংয়ের লোম দেখা না যায়, তাহলে রোগগ্রস্ত মানুষটিকে যাজক সাত দিনের জন্য পৃথক জায়গায় রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","সপ্তম দিনে যাজক তার ক্ষতস্থান পরীক্ষা করবে এবং যদি সেটি প্রসারিত না হয় ও সেখানে হলুদ রংয়ের লোম না থাকে এবং চামড়ার চেয়েও গভীরে এর অবস্থান না থাকে, ");
INSERT INTO benobcv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","তাহলে রোগগ্রস্ত নর বা নারীর ক্ষতস্থান ছাড়া সর্বত্র লোম চেঁচে ফেলবে এবং যাজক সাত দিনের জন্য তাকে পৃথক জায়গায় রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","সপ্তম দিনে যাজক তার ক্ষত পরীক্ষা করবে এবং যদি চামড়ায় ক্ষতের প্রসারণ না দেখা যায় ও চামড়ার চেয়েও গভীরে এর অবস্থান না হয়, তাহলে যাজক তাকে শুচি ঘোষণা করবে। সে তার পরিধান অবশ্যই ধুয়ে পরিষ্কার করবে ও নিজে শুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","কিন্তু যদি যাজক দ্বারা তাকে শুচি ঘোষণা করার পর তার চামড়ায় ক্ষত প্রসারিত হয়, ");
INSERT INTO benobcv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","তাহলে যাজক তাকে পরীক্ষা করবে এবং যদি চামড়ায় প্রসারিত ক্ষত দেখা যায়, তাহলে যাজকের হলুদ রংয়ের লোম দেখার প্রয়োজন নেই; মানুষটি অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","অন্যদিকে, তার বিচারে যদি দাগ অপরিবর্তিত থাকে এবং সেখানে কালো রংয়ের লোম উৎপন্ন হয়, তাহলে ক্ষত নিরাময় হয়েছে। সে শুচিশুদ্ধ এবং যাজক তাকে শুদ্ধ ঘোষণা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“যখন কোনো নর বা নারীর চামড়ায় সাদা রং দাগ দেখা যায়, ");
INSERT INTO benobcv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","তাহলে যাজক সমস্ত দাগ পরীক্ষা করবে এবং যদি দাগগুলি হালকা সাদা রং থাকে, তাহলে তা ক্ষতিহীন ফুসকুড়ি, যা চামড়ায় ফুটে উঠেছে; সেই ব্যক্তি শুদ্ধ। ");
INSERT INTO benobcv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“যদি কোনো মানুষের মাথায় চুল না থাকে ও তার টাক পড়ে, সে শুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","যদি তার মাথার সামনের দিকে চুল না থাকে এবং টাকপড়া কপাল দেখা যায়, তাহলে সে শুচি। ");
INSERT INTO benobcv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","কিন্তু যদি তার টাক মাথায় বা কপালে হালকা রক্তিম সাদাটে ক্ষত থাকে, তাহলে তা মাথায় বা কপালে অঙ্কুরিত এক সংক্রামক রোগ। ");
INSERT INTO benobcv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","যাজক তাকে পরীক্ষা করবে এবং যদি তার মাথায় অথবা কপালে ফুলে ওঠা ক্ষত এবং সংক্রামক চামড়ার রোগের মতো হালকা রক্তিম সাদাটে হয়, ");
INSERT INTO benobcv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","তাহলে মানুষটি রোগগ্রস্ত ও অশুচি। তার মাথায় ক্ষতের কারণে যাজক তাকে অশুচি ঘোষণা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“এমন এক সংক্রামক রোগগ্রস্ত মানুষ অবশ্যই ছেঁড়া কাপড় পরবে, তার চুল এলোমেলো থাকুক; সে তার মুখমণ্ডলের নিচের দিকটি ভাগ ঢেকে রাখবে ও তারস্বরে বলবে ‘অশুচি! অশুচি!’ ");
INSERT INTO benobcv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","যতদিন তার ক্ষত থাকবে, তাকে অশুচি বলা হবে। সে অবশ্যই একলা থাকবে; সে অবশ্যই শিবিরের বাইরে দিন কাটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ছাতারোগ দ্বারা যদি কোনো কাপড় কলঙ্কিত হয়, হতে পারে তা পশমি বা মসিনা কাপড়, ");
INSERT INTO benobcv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","তাঁতের কাপড়, অথবা মসিনা কিংবা পশমে বোনা, যে কোনো চামড়ার উপাদান অথবা চামড়ার জিনিস, ");
INSERT INTO benobcv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","যদি কাপড়ে অথবা চামড়ায়, কিংবা তাঁত কাপড়ে বা বোনা উপাদানে অথবা চামড়ার জিনিসে কলঙ্ক থাকে, সবুজ অথবা হালকা রক্তিম রং পাওয়া যায়, তাহলে প্রসারিত ছাতারোগ এবং অবশ্যই তা যাজককে দেখাতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","যাজক ওই ছাতারোগ পরীক্ষা করবে ও সাত দিনের জন্য রোগগ্রস্ত উপাদান বিচ্ছিন্ন রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","সপ্তম দিনে সে সেটি পরীক্ষা করবে এবং যদি ছাতারোগ কাপড়ে, অথবা কোনো বোনায়, কিংবা বোনা পরিধানে, অথবা চামড়ায়, কিংবা ব্যবহার করা যে কোনো জিনিসে প্রসারিত হয়ে থাকে, তাহলে তা এক মারাত্মক ছাতারোগ, অশুচি জিনিস। ");
INSERT INTO benobcv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","সে ওই কাপড়, অথবা তাঁতের কাপড়, কিংবা পশম বা মসিনার কাপড় অথবা কলঙ্কিত যে কোনো চর্মজাত জিনিস পোড়াবে, কেননা ছাতারোগ ধ্বংসাত্মক। ওই জিনিস অবশ্যই পুড়িয়ে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“কিন্তু যাজক দ্বারা পরীক্ষার পর যদি দেখা যায় ছাতারোগ কাপড়ে কিংবা কোনো বয়ন শিল্পে বা বোনা উপাদানে অথবা চর্মজাত দ্রব্যে প্রসারিত না হয়, ");
INSERT INTO benobcv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","তাহলে সেই কলঙ্কিত জিনিস ধুয়ে নিতে তাকে আদেশ দেওয়া হবে। পরে আরও সাত দিনের জন্য সে ওই জিনিস দূরে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","প্রভাবিত জিনিস ধোয়ার পরে যাজক সেটি পরীক্ষা করবে এবং যদি ছাতারোগের ছোপ পরিবর্তিত না হয় ও তার প্রসারণ নজরে না পড়ে, তবুও এটি অশুদ্ধ। একদিকে বা অন্যদিকে প্রভাবিত ছাতা আগুনে পোড়াতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","যদি যাজক দ্বারা পরীক্ষিত হয়ে জিনিসটি ধোয়ার পরে ছাতারোগ না দেখা যায়, তাহলে কলঙ্কিত কাপড়ের টুকরো অথবা চামড়া কিংবা বয়ন শিল্প বা বোনা উপাদান সে ছিঁড়ে ফেলবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","কিন্তু যদি তা কাপড়ে অথবা বয়ন শিল্পে কিংবা বোনা উপাদানে বা চামড়ার জিনিসে আবার দেখা যায়, তাহলে তা ছড়িয়ে যাচ্ছে এবং অল্পবিস্তর ছাতারোগ অবশ্যই আগুনে পোড়াতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","কাপড় অথবা বয়ন শিল্প কিংবা বোনা উপাদান অথবা চামড়ার জিনিস যা ধোয়া হয়েছে ও সেটি ছাতারোগ মুক্ত দেখা যায়, তাহলে ওই জিনিস অবশ্যই পুনরায় ধুয়ে নিতে হবে, তাহলে সেটি শুদ্ধ হবে।” ");
INSERT INTO benobcv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","পশমি বা মসিনার কাপড়, বয়ন শিল্প কিংবা বোনা উপাদান অথবা চর্মজাত যে কোনো জিনিসের মলিনতা সম্বন্ধে নিয়মাবলি রয়েছে যেগুলি শুদ্ধ অথবা অশুদ্ধ বলা যেতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“রোগগ্রস্ত ব্যক্তির পক্ষে তার আনুষ্ঠানিক শুচিশুদ্ধ হওয়ার সময় নিয়মাবলি এই ধরনের, যখন তাকে যাজকের কাছে আনা হয়: ");
INSERT INTO benobcv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","যাজক শিবিরের বাইরে যাবে ও তাকে পরীক্ষা করবে। যদি সেই ব্যক্তির সংক্রামক চর্মরোগ সুস্থ হয়ে থাকে, ");
INSERT INTO benobcv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","তাহলে তার শুচিকরণের জন্য যাজক দুটি জীবিত শুচি পাখি কিছু দেবদারু কাঠ, লাল রংয়ের সুতো ও এসোব আনতে আদেশ দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","পরে যাজক মাটির পাত্রে টাটকা জলের উপরে একটি পাখিকে হত্যা করতে আদেশ দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","এবারে যাজক জীবিত পাখিটি নেবে এবং দেবদারু কাঠ, লাল রংয়ের সুতো ও এসোবের সঙ্গে ওই পাখি টাটকা জলের উপরে বধ করা পাখির রক্তে ডুবিয়ে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","সংক্রামক রোগগ্রস্ত ব্যক্তিকে শুচিশুদ্ধ করার জন্য যাজক সাতবার রক্ত ছিটাবে ও তাকে শুচি ঘোষণা করবে। পরে যাজক জীবিত পাখিটিকে খোলা মাঠে মুক্তি দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“ওই রোগী শুচি হওয়ার জন্য অবশ্যই তার পরিধান ধুয়ে নেবে, তার মাথার সমস্ত চুল নেড়া করবে ও জলে স্নান করবে। এবারে সে আনুষ্ঠানিকভাবে শুচিশুদ্ধ হবে। এরপরে সে শিবিরে আসতে পারে, কিন্তু সাত দিনের জন্য তাকে তাঁবুর বাইরে থাকতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","সপ্তম দিনে সে তার সর্বাঙ্গের লোম চেঁচে ফেলবে; সে মাথার চুল, দাড়ি, ভুরুর ও সর্বাঙ্গের সমস্ত লোম চেঁচে ফেলবে। সে তার পোশাক অবশ্যই ধুয়ে নেবে, নিজেও জলে স্নান করবে ও শুচিশুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“অষ্টম দিনে দুটি মদ্দা মেষশাবক এবং একটি এক বছরের মেষী সে অবশ্যই আনবে, যেগুলির প্রত্যেকটি হবে নিখুঁত, সঙ্গে থাকবে শস্য-নৈবেদ্যর জন্য তেলমিশ্রিত মিহি ময়দার এক ঐফার দশ ভাগের তিন ভাগ ও এক লোগ তেল। ");
INSERT INTO benobcv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","যে যাজক তাকে শুচি ঘোষণা করবে, সে তাকে ও তার নৈবেদ্য উভয়কে সমাগম তাঁবুর প্রবেশদ্বারে সদাপ্রভুর সামনে উপস্থিত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“পরে যাজক একটি মদ্দা মেষশাবক নেবে ও এক লোগ তেলের সঙ্গে দোষার্থক-নৈবেদ্যরূপে তা উৎসর্গ করবে। দোলনীয়-নৈবেদ্যরূপে বলিদান নিয়ে সদাপ্রভুর সামনে যাজক সেগুলি দোলাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","যাজক পবিত্রস্থানে সেই মেষশাবকটি বধ করবে, যেখানে পাপার্থক বলি ও হোমবলি বধ করা হয়। পাপার্থক বলির মতো দোষার্থক-নৈবেদ্য যাজকের; এটি অত্যন্ত পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","যাজক দোষার্থক-নৈবেদ্যের কিছুটা রক্ত নিয়ে যে শুচি হবে তার ডান কানের লতি, তার ডান হাতের বুড়ো আঙুলে ও তার ডান পায়ের বুড়ো আঙুলে রক্তের প্রলেপ দেবে শুচি হবার জন্য। ");
INSERT INTO benobcv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","এবারে যাজক এক লোগ তেলের কিছুটা নেবে এবং আপন বাম হাতের তালুতে ঢালবে, ");
INSERT INTO benobcv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","তার হাতে ঢালা তেলের মধ্যে তার তর্জনী ডোবাবে এবং সদাপ্রভুর সামনে আঙুল দিয়ে সাতবার তেল ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","যাজক তার হাতের অবশিষ্ট তেলের কিছুটা তেল নেবে, এবং শুচিকরণ প্রার্থীর ডান কানের লতিতে, তার ডান হাতের বুড়ো আঙুলে, ডান পায়ের বুড়ো আঙুলে দোষার্থক-নৈবেদ্যের রক্তের উপরে ঢেলে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","যাজক তার হাতের অবশিষ্ট তেল শুচিকরণ প্রার্থীর মাথায় ঢালবে ও সদাপ্রভুর সামনে তার জন্য প্রায়শ্চিত্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“পরে যাজক পাপার্থক বলি উৎসর্গ করবে ও অশুচিতা থেকে শুচিতা প্রত্যাশী প্রার্থীর জন্য প্রায়শ্চিত্ত করবে। এরপরে যাজক হোমবলির পশু বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","এরপরে শস্য-নৈবেদ্যের সঙ্গে যাজক বেদিতে ওই প্রার্থীর জন্য প্রায়শ্চিত্ত করবে এবং সে শুচিশুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“অন্যদিকে, যদি সে দরিদ্র হয় ও বলিদানের সামগ্রী জোগাতে না পারে, তবুও দোষার্থক-নৈবেদ্যরূপে একটি মদ্দা মেষশাবক তাকে আনতেই হবে এবং শস্য-নৈবেদ্যরূপে তেলমিশ্রিত মিহি ময়দার এক ঐফার দশমাংশ ও এক লোগ তেল সহযোগে প্রায়শ্চিত্ত সাধনার্থে নৈবেদ্য দোলাতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","সে তার সংগতি অনুসারে দুটি ঘুঘু অথবা দুটি কপোতশাবক আনবে এবং পাপার্থক বলিদানার্থে একটি ও হোমবলিদানার্থে অন্যটি উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“সে তার শুদ্ধকরণের জন্য অষ্টম দিনে সদাপ্রভুর সামনে সমাগম তাঁবুর প্রবেশদ্বারে যাজকের কাছে উল্লিখিত ঘুঘু অথবা কপোত আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","যাজক এক লোগ তেল সহযোগে দোষার্থক-নৈবেদ্যদানের পক্ষে মেষশাবক গ্রহণ করবে ও দোলনীয়-নৈবেদ্যরূপে সেগুলি সদাপ্রভুর সামনে দোলাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","দোষার্থক-নৈবেদ্যদানের জন্য যাজক মেষশাবককে বধ করবে ও কিছুটা রক্ত নিয়ে শুচিতা প্রত্যাশী প্রার্থীর ডান কানের লতিতে, তার ডান হাতের বুড়ো আঙুলে ও তার ডান পায়ের বুড়ো আঙুলে রক্তের প্রলেপ দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","যাজক তার বাম হাতের তালুতে কিছুটা তেল ঢালবে ");
INSERT INTO benobcv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","এবং তার হাতের তালু থেকে ডান তালুতে কিছুটা তেল নিয়ে সদাপ্রভুর সামনে সাতবার ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","দোষার্থক-নৈবেদ্যের রক্ত যেখানে ঢালা হয়েছিল সেখানে, শুচিতা প্রত্যাশী প্রার্থীর ডান কানের লতিতে, তার ডান হাতের বুড়ো আঙুলে ও তার ডান পায়ের বুড়ো আঙুলে যাজক তার হাতের তালু থেকে কিছুটা তেল ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","যাজক তার হাতের তালুর অবশিষ্ট তেল ওই প্রার্থীর মাথায় ঢালবে, এবং এইভাবে সদাপ্রভুর সামনে তার জন্য প্রায়শ্চিত্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","পরে সে তার সংগতি অনুসারে দুটি ঘুঘু অথবা দুটি কপোতশাবককে উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ঘুঘু অথবা কপোতশাবকের একটি পাপার্থক বলিরূপে এবং অন্যটি হোমবলিরূপে শস্য-নৈবেদ্য সহকারে সে উৎসর্গ করবে। এইভাবে শুচিকৃত হতে ইচ্ছুক ব্যক্তির পক্ষে সদাপ্রভুর সামনে যাজক প্রায়শ্চিত্ত করবে।” ");
INSERT INTO benobcv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","যে কোনো ব্যক্তির পক্ষে নিয়মাবলি এই ধরনের, যার সংক্রামক চামড়ার রোগ হয়েছে এবং যে তার শুচিতার জন্য নিয়মিত বলিদান দিতে অক্ষম। ");
INSERT INTO benobcv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“তোমরা যখন কনান দেশে প্রবেশ করবে, যে দেশ আমি তোমাদের অধিকার করতে দিচ্ছি, সেই দেশের কোনো বাড়িতে আমি যখন বিস্তৃত ছাতারোগ উৎপন্ন করব, ");
INSERT INTO benobcv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","তখন বাড়ির মালিক যাজকের কাছে গিয়ে বলবে, ‘আমার বাড়িতে ছাতারোগের মতো কলঙ্ক আমার নজরে এসেছে।’ ");
INSERT INTO benobcv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","যাজক ওই ছাতারোগ পরীক্ষা করার আগে বাড়িটি খালি করতে আদেশ দেবে, যেন বাড়ির কোনো জিনিসকে অশুচি না বলা হয়। এরপরে যাজক বাড়ির মধ্যে প্রবেশ করে সেটি পরীক্ষা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","যাজক দেওয়ালগুলির ছাতারোগ পরীক্ষা করবে এবং যদি হালকা সবুজ অথবা হালকা লাল দাগ দেওয়ালের বাইরের দিকের চেয়ে গাঢ় মনে হয়, ");
INSERT INTO benobcv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","যাজক বাড়ির দরজা দিয়ে বেরিয়ে যাবে এবং তা সাত দিন বন্ধ রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","সপ্তম দিনে বাড়িটি পরীক্ষা করার জন্য যাজক ফিরে আসবে। যদি সমস্ত দেওয়ালে ছাতারোগ বিস্তৃত দেখা যায়, ");
INSERT INTO benobcv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","তাহলে তার আদেশে কলুষিত পাথর খুঁড়ে বের করতে হবে ও নগরের বাইরের অশুচি জায়গায় ছুঁড়ে ফেলতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","সে বাড়ির ভিতরের দেওয়ালগুলি অবশ্যই ঘষাবে ও ঘষার উপাদানের ধুলো নগরের বাইরে অশুচি জায়গায় ফেলবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","পরে তারা অন্য পাথর নিয়ে আগে গাঁথা পাথরের জায়গায় বসাবে ও নতুন প্রলেপ দিয়ে বাড়ি পলস্তরা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“কলুষিত পাথর ফেলে দেওয়ার, বাড়ি ঘষে পলস্তরা করার পর যদি বাড়িতে ছাতারোগ আবার দেখা যায়, ");
INSERT INTO benobcv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","তাহলে যাজক গিয়ে তা পরীক্ষা করবে এবং যদি ছাতারোগ বাড়িতে ছড়িয়ে পড়ে, তাহলে সেটি ধ্বংসাত্মক ছাতারোগ; ওই বাড়ি অশুদ্ধ। ");
INSERT INTO benobcv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","প্রভাবিত সমস্ত পাথর, কাঠ ও পলস্তরা তুলে নগরের বাইরে অশুচি জায়গায় ফেলে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“যদি বন্ধ বাড়িতে কেউ প্রবেশ করে, সন্ধ্যা পর্যন্ত সে অশুদ্ধ ঘোষিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","যে কেউ সেই বাড়িতে ঘুমায় অথবা খাবার খায়, সে তার কাপড় অবশ্যই ধুয়ে নেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“যদি যাজক তা পরীক্ষা করতে আসে ও সেই বাড়ি পলস্তরা করার পর ছাতারোগ ছড়িয়ে পড়তে না দেখা যায়, তাহলে সেই বাড়িকে সে শুচি আখ্যা দেবে, কারণ ছাতারোগ নিরসন হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ওই বাড়ি পবিত্র করার জন্য যাজক দুটি পাখি, কিছু দেবদারু কাঠ, উজ্জ্বল লাল রংয়ের পাকানো সুতো ও এসোব নেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","মাটির পাত্রে টাটকা জলের ওপরে সে একটি পাখিকে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","এবারে সে দেবদারু কাঠ, এসোব, উজ্জ্বল লাল রংয়ের পাকানো সুতো নিয়ে মৃত পাখির রক্তে ও টাটকা জলে ডোবাবে এবং সাতবার সেই বাড়িতে ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","পাখির রক্ত, টাটকা জল, জীবিত পাখি, দেবদারু কাঠ, এসোব ও উজ্জ্বল লাল রংয়ের পাকানো সুতো দিয়ে সে বাড়িটি শুদ্ধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","পরে নগরের বাইরে খোলা মাঠে সে জীবিত পাখিকে ছেড়ে দেবে। এইভাবে বাড়িটির জন্য সে প্রায়শ্চিত্ত করবে ও সেই বাড়ি শুদ্ধ হবে।” ");
INSERT INTO benobcv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","এই নিয়মাবলি যে কোনো সংক্রামক চামড়ার রোগ, চুলকানি, ");
INSERT INTO benobcv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","কাপড়ে অথবা বাড়িতে ছাতারোগ, ");
INSERT INTO benobcv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","এবং কোনো আব, ফুসকুড়ি অথবা উজ্জ্বল দাগের জন্য, ");
INSERT INTO benobcv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","যেন কোনো কিছুর শুদ্ধতা বা অশুদ্ধতা নির্ণয় করা যায়। এসব নিয়মাবলি সংক্রামক চর্মরোগ ও ছাতারোগের জন্য। ");
INSERT INTO benobcv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“তোমরা ইস্রায়েলীদের বলো, ‘যখন কারোর দেহে অস্বাভাবিক ক্ষরণ হয়, সেই ক্ষরণ অশুদ্ধ। ");
INSERT INTO benobcv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","তার দেহ থেকে ক্ষরণ অব্যাহত বা বদ্ধ থাকলে সেটি তাকে অশুচি করবে। এইভাবে তার ক্ষরণ অশুচিতা নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘ক্ষরণযুক্ত কোনো ব্যক্তি বিছানায় শুলে সেই বিছানা অশুচি হবে এবং আসন বা যা কিছুর উপরে সে বসবে, সেটি অশুচি বিবেচিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","যদি কেউ তার বিছানা স্পর্শ করে, তাকে তার কাপড় অবশ্যই ধুয়ে নিতে হবে এবং জলে স্নান করতে হবে এবং সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ক্ষরণযুক্ত মানুষটির বসা আসবাবপত্রের ওপরে যদি কেউ বসে, তাকে তার কাপড় ধুয়ে নিতেই হবে ও সে জলে স্নান করবে ও সন্ধ্যা পর্যন্ত তাকে অশুচি বলা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘ক্ষরণযুক্ত মানুষকে যে কেউ স্পর্শ করবে, সে অবশ্যই তা পরিহিত কাপড় ধোবে ও জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘ক্ষরণযুক্ত মানুষ যদি কারোর দেহে থুতু ফেলে, যে শুচি, সেই ব্যক্তি নিজের কাপড় ধোবে ও জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘ক্ষরণযুক্ত মানুষটি যে কোনো গাড়িতে চড়ে, সেই গাড়ি অশুচি হয় ");
INSERT INTO benobcv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","এবং তার বসার জায়গায় নিচে রাখা কোনো জিনিস যদি কেউ স্পর্শ করে সন্ধ্যা পর্যন্ত সেই জিনিসটি অশুচি থাকবে। যে কেউ সেই জিনিসগুলি তুলে নেয়, তাকে অবশ্যই নিজ কাপড় ধুতে ও জলে স্নান করতে হবে এবং সন্ধ্যা পর্যন্ত সে অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘ক্ষরণযুক্ত মানুষ তার হাত না ধুয়ে যদি কাউকে স্পর্শ করে, সে নিজের কাপড় ধোবে ও জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত তাকে অশুচি বলা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘ওই মানুষটি দ্বারা স্পর্শ করা মাটির পাত্র অবশ্যই ভেঙে ফেলতে হবে ও কাঠের আসবাবপত্র জল দিয়ে ধুতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘ক্ষরণযুক্ত মানুষ যখন শুচি হয়, সে নিজের আনুষ্ঠানিক শুচিতার জন্য সাত দিন গণনা করবে। সে তার কাপড় অবশ্যই ধোবে ও টাটকা জলে স্নান করবে, এভাবে সে শুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","অষ্টম দিনে সে দুটি ঘুঘু অথবা দুটি কপোতশাবক নেবে, সমাগম তাঁবুর প্রবেশদ্বারে সদাপ্রভুর সামনে আসবে এবং ঘুঘু অথবা কপোতশাবক যাজককে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","একটি পাপার্থক বলি ও অন্যটি হোমবলিরূপে যাজক পাখিগুলি উৎসর্গ করবে। এইভাবে ক্ষরণযুক্ত মানুষের পক্ষে সদাপ্রভুর সামনে যাজক প্রায়শ্চিত্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘যদি কোনো পুরুষের বীর্যপাত হয়, তাহলে সে তার সমস্ত শরীর জলে ধুয়ে নেবে এবং সন্ধ্যা পর্যন্ত সে অশুদ্ধ থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","কোনো কাপড়ে অথবা চামড়ার জিনিসে বীর্যপাত হলে, জলে সেটি ধুতেই হবে ও সেই জিনিসটি সন্ধ্যা পর্যন্ত অশুদ্ধ থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","যদি একটি নারীর সাথে কোনো পুরুষ শয়ন করে এবং বীর্যপাত হয়, তাহলে উভয়ে জলে স্নান করবে ও সন্ধ্যা পর্যন্ত তারা অশুদ্ধ বিবেচিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘যখন কোনো মহিলার নিয়মিত রক্তস্রাব হয়, ঋতুমতীর মাসিক সময়ের অশুদ্ধতা সাত দিন থাকবে এবং যে কেউ তাকে স্পর্শ করে, সন্ধ্যা পর্যন্ত সে অশুদ্ধ বিবেচিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘মাসিক চলাকালীন যে কিছুর ওপরে সে শোবে, এবং বসবে সবকিছুই অশুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","তার বিছানা স্পর্শকারী যে কেউ নিজের কাপড় ধোবে ও স্নান করবে এবং সন্ধ্যা পর্যন্ত সে অশুদ্ধ থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","তার বসা আসবাব যে কেউ স্পর্শ করে, সে তার কাপড় অবশ্যই ধুয়ে নেবে ও নিজে স্নান করবে এবং সন্ধ্যা পর্যন্ত সে অশুদ্ধ থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","বিছানা অথবা তার বসা যে কোনো আসবাবপত্র যদি কেউ স্পর্শ করে, সে সন্ধ্যা পর্যন্ত অশুদ্ধ থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘যদি কোনো পুরুষ ওই নারীর সঙ্গে শয়ন করে ও তার মাসিক রক্তস্রাব ওই পুরুষের দেহে লাগে, তাহলে পুরুষটি সাত দিনের জন্যে অশুদ্ধ থাকবে ও তার শয়ন করা বিছানা অশুদ্ধ বিবেচিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘যদি কোনো মহিলার মাসিক কাল চেয়েও একবারে দীর্ঘদিন ধরে রক্তস্রাব হয়, অথবা তার রক্তস্রাব নিয়মিত সময় অতিক্রম করে, তাহলে তার মাসিক ঋতুস্রাবের দিনগুলির মতো অনিয়মিত দীর্ঘকাল পর্যন্ত সে অশুদ্ধ থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","রক্তস্রাব চলাকালীন তার শোয়ার বিছানা অশুদ্ধ হবে, যেমন তার মাসিক ঋতুকালের বিছানা অশুদ্ধ হবে, যেমন তার অশৌচকালের সময় তার বিছানা অশুদ্ধ হয় এবং তার বসা যে কোনো আসন তার অশৌচকালের মতো অশুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","সেগুলি স্পর্শকারী যে কেউ অশুদ্ধ হবে; সে নিজের কাপড় অবশ্যই ধুয়ে নেবে ও নিজে জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত তাকে অশুদ্ধ বলা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘তার রক্তস্রাব থেকে যখন সে শুদ্ধ হবে, সে নিজের জন্য সাত দিন গণনা করবে এবং এরপরে আনুষ্ঠানিকভাবে সে শুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","অষ্টম দিনে দুটি ঘুঘু অথবা দুটি কপোতশাবক সে নেবে এবং সমাবেশ-তাঁবুর প্রবেশদ্বারে যাজকের হাতে সেগুলি তুলে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","একটি পাপার্থক বলি ও অন্যটি হোমবলিরূপে পাখিগুলিকে যাজক উৎসর্গ করবে। এভাবে মহিলাটির স্রাবের অশুচিতার জন্য সদাপ্রভুর সামনে প্রায়শ্চিত্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘তোমরা সমস্ত অশুচিতা থেকে ইস্রায়েলীদের পৃথক রাখবে, যেন আমার বাসস্থান অশুচি করার দ্বারা তাদের অশুচিতায় তাদের মৃত্যু না হয়, যা তাদের মধ্যবর্তী।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","পুরুষের যে কোনো ক্ষরণ, বীর্যপাতের হেতু যে কোনো পুরুষের অশুচিতার জন্য এসব নিয়মবিধি, ");
INSERT INTO benobcv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","কারণ কোনো নারীর মাসিক রক্তস্রাবের ক্ষেত্রে, কোনো পুরুষ অথবা মহিলার ক্ষরণের পক্ষে এবং কোনো মহিলার সঙ্গে শয়নকারী আনুষ্ঠানিকভাবে অশুচি পুরুষের জন্য নিয়মগুলি প্রযোজ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","হারোণের দুই ছেলে সদাপ্রভুর কাছে এসে মারা যাওয়ার পর সদাপ্রভু মোশির সঙ্গে কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","সদাপ্রভু মোশিকে বললেন, “তুমি তোমার দাদা হারোণকে বলো, সে যেন মহাপবিত্র জায়গায় তিরস্কারিণীর পিছনে সিন্দুকের সামনে পাপাবরণের জায়গায় যখন তখন যেন প্রবেশ না করে, অন্যথায় সে মরবে, কারণ পাপাবরণের ওপরে মেঘের মধ্যে আমি আবির্ভূত হই। ");
INSERT INTO benobcv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“পাপার্থক বলিরূপে একটি বাছুর ও হোমবলিরূপে একটি মেষ সঙ্গে নিয়ে হারোণ মহাপবিত্র জায়গায় প্রবেশ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","মসিনার পবিত্র নিমা সে গায়ে দেবে, মসিনার অন্তর্বাস পরবে, মসিনার কটিবন্ধন বাঁধবে ও মসিনার পাগড়িতে বিভূষিত হবে। এগুলি পবিত্র পোশাক সুতরাং এই পোশাক পরার আগে সে অবশ্যই স্নান করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","পাপার্থক বলির জন্য দুটি পুংছাগ ও হোমবলির জন্য একটি মেষ ইস্রায়েলী সমাজ থেকে সে সংগ্রহ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“হারোণ নিজের পাপার্থক বলিরূপে প্রায়শ্চিত্ত সাধনার্থে ও তার কুলের পক্ষে বাছুরটি উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","পরে সে দুটি ছাগল নেবে এবং সমাগম তাঁবুর প্রবেশদ্বারে সদাপ্রভুর সামনে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","পরে দুটি ছাগলের পক্ষে সে গুটিকাপাত করবে। সদাপ্রভুর উদ্দেশে একটি ছাগল ও অন্যদের অপরাধে দণ্ডিত হবার জন্য অন্য ছাগলের ভাগ্য নির্ণীত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","সদাপ্রভুর উদ্দেশে নির্ণীত ছাগকে এনে হারোণ পাপার্থক বলি উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","কিন্তু অন্যদের জন্য শাস্তি পাওয়ার জন্য মনোনীত ছাগটিকে জীবিতাবস্থায় সদাপ্রভুর সামনে আনতে হবে ও প্রায়শ্চিত্ত সাধনার্থে অন্যের পক্ষে দণ্ডিতরূপে তাকে মরুপ্রান্তরে পাঠাতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“হারোণ নিজের পাপার্থক বলিরূপে বাছুর আনবে এবং তার ও তার কুলের পক্ষে প্রায়শ্চিত্ত করবে এবং আপন পাপার্থক বলিদানার্থে সে বাছুরটিকে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","সদাপ্রভুর সামনের বেদি থেকে সে জ্বলন্ত কয়লাপূর্ণ ধূপাধার নেবে এবং পূর্ণ দুই মুঠো চূর্ণীকৃত সুগন্ধি ধূপ নিয়ে পর্দার পিছনে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","সদাপ্রভুর সামনে আগুনের মধ্যে সে ধূপ নিক্ষেপ করবে; ফলে সাক্ষ্য-সিন্দুকের ওপরে রাখা পাপাবরণ ধূপের ধূমমেঘে আচ্ছন্ন হবে; সুতরাং সে মরবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","সে বাছুরটির কিছুটা রক্ত নেবে ও তার আঙুল দিয়ে পাপাবরণের সামনে ছিটাবে; পরে সে তার আঙুল দিয়ে কিছুটা রক্ত নিয়ে পাপাবরণের সামনে সাতবার ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“এবারে লোকদের জন্য পাপার্থক বলিদানার্থে সে ছাগকে বধ করবে এবং বাছুরটির রক্ত ছিটানোর মতো ছাগলের রক্ত ছিটাবে। পাপাবরণের উপরে সাতবার ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","এভাবে মহাপবিত্র স্থানের জন্য সে প্রায়শ্চিত্ত করবে, কেননা ইস্রায়েলীদের রকমারি অশুচিতা, বিরোধিতা ও অন্যান্য পাপ সেখানে ঘটেছিল। সমাগম তাঁবুর জন্য সে একই কাজ করবে, যা তাদের অশুচিতার মাঝে তাদের মধ্যে রয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","মহাপবিত্র জায়গায় প্রায়শ্চিত্ত সাধনার্থে হারোণ চলে যাওয়ার সময় থেকে তার ফিরে না আসা পর্যন্ত সমাগম তাঁবুতে কেউ যাবে না। সে নিজের জন্য, তার কুলের পক্ষে ও সমগ্র ইস্রায়েল সমাজের জন্য প্রায়শ্চিত্ত সাধনের পর সেখান থেকে বেরিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“পরে সদাপ্রভুর সম্মুখবর্তী বেদির সামনে সে আসবে ও বেদির জন্য প্রায়শ্চিত্ত করবে। সে বাছুরটির কিছুটা রক্ত ও ছাগলের কিছুটা রক্ত নেবে এবং বেদির সমস্ত শিং-এ ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","বেদি শুচি করতে ও ইস্রায়েলীদের সব ধরনের অশুচিতা থেকে বেদিকে পবিত্র করার জন্য সে তার আঙুল দিয়ে কিছুটা রক্ত নিয়ে সাতবার ছিটাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“মহাপবিত্র স্থান, সমাগম তাঁবুর ও বেদির জন্য প্রায়শ্চিত্ত সাধনের পর হারোণ জীবিত ছাগকে সামনে আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","জীবিত ছাগলের মাথায় সে তার দু-হাত রাখবে এবং ইস্রায়েলীদের সমস্ত দুষ্টতা, বিরোধিতা স্বীকার করবে তাদের সকল পাপ ছাগলের মাথার ওপরে রাখা হবে। দায়িত্ব পালনার্থে নিযুক্ত ব্যক্তির তত্ত্বাবধানে সে ছাগটিকে প্রান্তরে পাঠিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ছাগটি তাদের সব পাপ বহন করে এক নির্জন জায়গায় নিয়ে যাবে ও তত্ত্বাবধায়ক ছাগটিকে মরুপ্রান্তরে ছেড়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“পরে হারোণ সমাগম তাঁবুতে যাবে এবং মহাপবিত্র স্থানে প্রবেশ করার আগে পরিহিত সব মসিনার পোশাক ছাড়বে ও সেগুলি সেখানে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","এক পবিত্রস্থানে সে জলে স্নান করবে এবং তার নিয়মিত কাপড় পরবে। এবারে সে বাইরে আসবে এবং নিজের জন্য হোমবলি ও লোকদের জন্য হোমবলি উৎসর্গ করবে, এইভাবে নিজের জন্য ও লোকদের জন্য প্রায়শ্চিত্ত সাধিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","আর সে পাপার্থক বলির মেদ বেদিতে পোড়াবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“অন্যের জন্য দণ্ডিত ছাগকে যে ব্যক্তি মুক্ত করবে, সে তার কাপড় অবশ্যই ধুয়ে নেবে ও জলে স্নান করবে; পরে সে শিবিরে আসতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","পাপার্থক বলির জন্য আনা বাছুর ও ছাগলের রক্ত প্রায়শ্চিত্ত সাধনের জন্য মহাপবিত্র স্থান থেকে শিবিরের বাইরে নিয়ে যেতেই হবে; তাদের চামড়া, মাংস ও নাড়ি আগুনে জ্বালিয়ে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","এগুলি যে ব্যক্তি জ্বালাবে, সে তার কাপড় অবশ্যই ধুয়ে নেবে ও নিজে জলে স্নান করবে; পরে সে শিবিরে আসতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“এটি তোমাদের জন্য চিরস্থায়ী বিধি হবে: সপ্তম মাসের দশম দিনে তোমরা আত্মসংযমী হবে এবং স্বদেশি অথবা তোমাদের মধ্যে বসবাসকারী প্রবাসী কোনো কাজ করবে না, ");
INSERT INTO benobcv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","কারণ ওই দিনে তোমাদের জন্য প্রায়শ্চিত্ত সাধিত হবে, তোমরা পরিষ্কৃত হবে। পরে সদাপ্রভুর সামনে তোমরা সব পাপ থেকে শুচিশুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","এই দিন তোমাদের বিশ্রামের জন্য বিশ্রামদিন এবং তোমরা অবশ্যই আত্মসংযমী হবে; এটি চিরস্থায়ী বিধি। ");
INSERT INTO benobcv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","যে যাজককে অভিষেক ও নিযুক্তি দ্বারা মহাযাজকরূপে তার বাবার উত্তরসূরি করা হবে, সে প্রায়শ্চিত্ত করবে। পবিত্র মসিনা কাপড় সে পরবে ");
INSERT INTO benobcv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","এবং সমাগম তাঁবু ও বেদির জন্য এবং যাজকদের ও সমাজের সমস্ত লোকের জন্য মহাপবিত্র জায়গায় প্রায়শ্চিত্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“তোমাদের জন্য এটি চিরস্থায়ী বিধি হবে: ইস্রায়েলীদের সব পাপের জন্য বার্ষিক একবার প্রায়শ্চিত্ত করতে হবে।” এই কাজ করা হল, যেমন সদাপ্রভু মোশিকে আদেশ করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“তুমি হারোণকে এবং তার ছেলেদের ও ইস্রায়েলীদের সবাইকে এই কথা বলো, ‘সদাপ্রভু এই আদেশ দিয়েছেন: ");
INSERT INTO benobcv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","যদি কোনো ইস্রায়েলী শিবিরের মধ্যে অথবা শিবিরের বাইরে গরু, অথবা মেষ কিংবা ছাগল হত্যা করে, ");
INSERT INTO benobcv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","কিন্তু সদাপ্রভুর আবাসের সামনে, সদাপ্রভুর উদ্দেশে উপহার উৎসর্গ করতে সমাগম তাঁবুর প্রবেশদ্বারে তা না আনে, তাহলে সেই মানুষটি রক্তপাতের অপরাধী গণিত হবে; সে রক্তপাত করছে; সুতরাং তার পরিজনদের কাছ থেকে সে উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","এরপরে ইস্রায়েলীরা সদাপ্রভুর উদ্দেশে বিভিন্ন বলিদান আনবে, যেগুলি ওই সময় পর্যন্ত তারা খোলা ময়দানে উৎসর্গ করছিল। তারা যাজকের কাছে সেগুলি অবশ্যই আনবে: অর্থাৎ সমাগম তাঁবুর প্রবেশদ্বারে সদাপ্রভুর সামনে এনে মঙ্গলার্থক বলিরূপে সেগুলি উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","সমাগম তাঁবুর প্রবেশদ্বারে সদাপ্রভুর বেদির সামনে যাজক রক্ত ছিটাবে এবং সদাপ্রভুর সুগন্ধি সন্তোষজনক উপহাররূপে মেদ পোড়াবে। ");
INSERT INTO benobcv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ছাগল প্রতিমাদের উদ্দেশে তারা আর কোনোরকম বলিদান করবে না, যাদের অনুগমনে তারা ব্যভিচার করেছে। তাদের জন্যে ও আগামী প্রজন্মের জন্য এটি চিরস্থায়ী বিধি।’ ");
INSERT INTO benobcv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“তাদের বলো, ‘তাদের মধ্যে বসবাসকারী কোনো ইস্রায়েলী অথবা প্রবাসী যদি হোম অথবা বলিদান করে ");
INSERT INTO benobcv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","এবং সদাপ্রভুর উদ্দেশে বলিদান করার জন্য সমাগম তাঁবুর প্রবেশদ্বারে ওই নৈবেদ্য না আনে, তাহলে তার পরিজনদের নিকট থেকে সে অবশ্যই উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘তোমাদের মধ্যে বসবাসকারী কোনো ইস্রায়েলী অথবা কোনো প্রবাসী যদি রক্ত ভোজন করে, তাহলে আমি ওই রক্ত ভোজনকারীর প্রতি বিমুখ হব ও তার পরিজনদের কাছ থেকে তাকে উচ্ছিন্ন করব। ");
INSERT INTO benobcv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","কেননা একটি প্রাণীর রক্তে জীবন থাকে এবং এই জীবন আমি তোমাদের দিয়েছি, যেন তোমাদের জন্য তোমরা বেদির ওপরে প্রায়শ্চিত্ত করতে পারো; এই রক্ত প্রত্যেকজনের জন্য প্রায়শ্চিত্ত সাধন করে। ");
INSERT INTO benobcv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","অতএব ইস্রায়েলীদের উদ্দেশে আমি এই কথা বলি, “তোমাদের কেউ অথবা তোমাদের মধ্যে বসবাসকারী কোনো প্রবাসী যেন রক্ত ভোজন না করে।” ");
INSERT INTO benobcv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘কোনো ইস্রায়েল সন্তান অথবা তোমাদের মধ্যে বসবাসকারী কোনো প্রবাসী যদি মৃগয়াতে গিয়ে ভোজনের উপযোগী পশু অথবা পাখি বধ করে, তাহলে মৃত পশুর অথবা পাখির প্রবাহিত রক্তধারাকে ধুলো দিয়ে ঢেকে দিতে হবে, ");
INSERT INTO benobcv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","কারণ প্রত্যেক প্রাণীর জীবন রক্তের মধ্যে রয়েছে। এই কারণে আমি ইস্রায়েলীদের বলেছি, “তোমরা কোনো প্রাণীর রক্ত একেবারে ভোজন করবে না, কারণ রক্তের মধ্যে প্রত্যেক প্রাণীর জীবন রয়েছে, যদি কেউ তা ভোজন করে, তাকে উচ্ছিন্ন হতেই হবে।” ");
INSERT INTO benobcv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘স্বদেশি অথবা বিদেশি কেউ যদি কোনো মৃত অথবা বিদীর্ণ বন্যপশুর মাংস ভক্ষণ করে, তাহলে সে নিজের কাপড় অবশ্যই ধুয়ে নেবে ও জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত সে আনুষ্ঠানিকভাবে অশুদ্ধ থাকবে; পরে সে শুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","কিন্তু সে যদি তার কাপড় না ধোয় ও নিজে স্নান না করে, তাহলে সে নিজের অপরাধ বহন করবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ইস্রায়েলীদের বলো, ‘আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","মিশরে তাদের কর্মের মতো কাজ তোমরা কোরো না, যেখানে তোমরা বসবাস করতে এবং কনান দেশে তাদের কর্মানুযায়ী তোমরা কোনও কাজ কোরো না, যেখানে আমি তোমাদের আনছি। তাদের কোনও অনুশীলন অনুকরণ কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","আমার শাসন তোমরা অবশ্যই পালন করবে এবং আমার সব বিধি সযত্নে মানবে। আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","আমার বিধিলিপি ও নিয়মাবলি পালন করবে, কেননা যে ব্যক্তি সেগুলি পালন করে সে এসবের দ্বারা বাঁচবে। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘যৌন সম্পর্ক স্থাপনের জন্য কেউ নিকট আত্মীয়ের কাছে যাবে না। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘তোমাদের মায়ের সাথে যৌন সম্পর্ক রেখে তুমি তোমার বাবাকে অশ্রদ্ধা করো না। তিনি তোমার মা; তাঁর সাথে কোনো যৌন সম্পর্ক রেখো না। ");
INSERT INTO benobcv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘তোমার বাবার স্ত্রীর সঙ্গে যৌন সম্পর্ক রেখো না; এই কাজ তোমার বাবার অসম্মানজনক। ");
INSERT INTO benobcv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘তোমার বোনের সাথে অর্থাৎ তোমার বাবার মেয়ের সাথে অথবা তোমার মায়ের মেয়ের সাথে যৌন সম্পর্ক রেখো না; হতে পারে সে একই বাড়িতে অথবা অন্যত্র জন্মেছে। ");
INSERT INTO benobcv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘তোমার ছেলের মেয়ে অথবা তোমার মেয়ের কোনো মেয়ের সাথে যৌন সম্পর্ক রাখবে না, এই কাজ তোমার অসম্মানজনক। ");
INSERT INTO benobcv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘তোমার বাবার ঔরসে জাত মেয়ের সঙ্গে তুমি যৌন সম্পর্ক রাখবে না; সে তোমার বোন। ");
INSERT INTO benobcv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘তোমার বাবার বোনের সঙ্গে তুমি যৌন সম্পর্ক রাখবে না; সে তোমার বাবার নিকট আত্মীয়। ");
INSERT INTO benobcv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘তোমার মায়ের বোনের সঙ্গে যৌন সম্পর্ক রেখো না, কেননা সে তোমার মায়ের নিকট আত্মীয়। ");
INSERT INTO benobcv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘তোমার বাবার ভ্রাতৃবধূর সঙ্গে যৌন সম্পর্ক স্থাপন করতে গিয়ে বাবার ভাইকে অশ্রদ্ধা কোরো না; তিনি তোমার কাকীমা। ");
INSERT INTO benobcv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘তোমার ছেলের বউ-এর সঙ্গে যৌন সম্পর্ক রেখো না। সে তোমার পুত্রের বউ; তার সাথে অবৈধ সম্পর্ক রাখবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘তোমার ভাই-এর বউ-এর সঙ্গে যৌন সম্পর্ক রাখবে না; এ কাজ তোমার ভাই-এর প্রতি অসম্মানজনক। ");
INSERT INTO benobcv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘কোনো এক মহিলা ও তার মেয়ের সঙ্গে যৌন সম্পর্ক রাখবে না। তার ছেলের মেয়ে অথবা তার মেয়ের কোনো মেয়ের সঙ্গে যৌন সম্পর্ক রাখবে না। তারা তার নিকট আত্মীয়; এটি পাপাচার। ");
INSERT INTO benobcv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘তোমার স্ত্রীর বোনকে এক প্রতিযোগিনী স্ত্রীরূপে গ্রহণ করবে না ও তোমার স্ত্রী জীবিত থাকাকালীন তার সঙ্গে যৌন সম্পর্ক রাখবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘কোনো মহিলার মাসিক রক্তস্রাবের অশুচিতা থাকাকালীন যৌন সম্পর্ক স্থাপন করার জন্য তার কাছে যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘তোমার প্রতিবেশীর স্ত্রী সঙ্গে যৌন সম্পর্ক রেখে তার দ্বারা নিজেকে অশুচি করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘মোলকের উদ্দেশে তোমার কোনো সন্তান বলিদানার্থে দিয়ো না, কেননা তোমার ঈশ্বরের নাম তুমি কখনও অপবিত্র করবে না। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘কোনো পুরুষের সঙ্গে সংসর্গ করবে না, যেমন কেউ কোনো মহিলার সঙ্গে শয়ন করে। এই কাজ ঘৃণিত। ");
INSERT INTO benobcv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘কোনো পশুর সঙ্গে যৌন সম্পর্ক রেখে নিজেকে অশুচি করবে না। একটি নারী কামনা চরিতার্থ করতে যেন কখনও কোনো পশুর কাছে না যায়। এই কাজ চূড়ান্ত দুষ্কর্ম। ");
INSERT INTO benobcv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘এসব দুষ্কর্ম দ্বারা তোমরা নিজেদের কলুষিত করবে না, কারণ তোমাদের সামনে থেকে যে জাতিদের আমি বিতাড়িত করতে চলেছি, তারা এইভাবে কলুষিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","এমনকি দেশও কলুষিত হয়েছিল; সুতরাং দেশের পাপের জন্য তাকে শাস্তি দিলাম এবং দেশ তার বাসিন্দাদের উগরে ফেলল। ");
INSERT INTO benobcv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","কিন্তু আমার বিধি ও আমার বিধান অবশ্যই পালন করবে। স্বদেশে জাত ও তোমাদের মধ্যে বসবাসকারী বিদেশিরা যেন কোনো ঘৃণিত কাজ না করে। ");
INSERT INTO benobcv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","কারণ তোমাদের আগে এই দেশে বসবাসকারী লোকেরা এই সমস্ত করেছিল ও দেশ কলুষিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","আর তোমরা যদি দেশ কলুষিত করো, তাহলে দেশ তোমাদের উগরে দেবে, যেমন তোমাদের আগে সেই জাতিদের উগরে দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘যদি কেউ এই ঘৃণিত কাজগুলির মধ্যে কোনো একটি কাজ করে, তাহলে নিজের পরিজনদের মধ্য থেকে সে উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","আমার চাহিদাগুলি পূরণ করবে ও ঘৃণিত কোনো কাজ অনুসরণ করবে না, তোমাদের আগে যেগুলি অনুশীলিত হয়েছিল এবং কুকাজগুলির দ্বারা নিজেদের কলুষিত করবে না। আমি তোমাদের ঈশ্বর সদাপ্রভু।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“সমগ্র ইস্রায়েলী জনতার সঙ্গে তুমি কথা বলো এবং তাদের জানাও, ‘তোমরা পবিত্র হও, কেননা তোমাদের ঈশ্বর সদাপ্রভু, আমি পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘তোমাদের প্রত্যেকজন বাবা-মাকে অবশ্যই সম্মান দিয়ো, এবং আমার বিশ্রামদিন নিশ্চিতরূপে পালন করবে। আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘প্রতিমাদের দিকে তোমরা ফিরো না, অথবা তোমাদের জন্য গলিত ধাতু দিয়ে প্রতিমা নির্মাণ করবে না। আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘সদাপ্রভুর উদ্দেশে যখন তোমরা মঙ্গলার্থক বলি উৎসর্গ করতে চাও, এমনভাবে তা উৎসর্গ করবে, যেন তোমাদের পক্ষে নৈবেদ্য গৃহীত হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","উৎসর্গীকরণ দিনে অথবা পরবর্তী দিনে বলিদানের মাংস ভক্ষণ করতে হবে; তৃতীয় দিন পর্যন্ত যা কিছু পড়ে থাকবে তা পোড়াতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","যদি ভক্ষ্য দ্রব্যের কিছু অংশ তৃতীয় দিনে ভোজন করা হয়, সেটি অশুদ্ধ এবং গৃহীত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","যদি কেউ তা ভোজন করে, সে দায়ী হবে, কারণ সদাপ্রভুর উদ্দেশে পবিত্র দ্রব্যকে সে অপবিত্র করেছে; সেই ব্যক্তি নিজের পরিজনদের মধ্য থেকে অবশ্যই উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘তোমাদের জমির ফসল কাটার সময় একেবারে ফসলের গোড়া কাটবে না, অথবা জমিতে পড়ে থাকা ফসল সংগ্রহ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","তোমাদের দ্রাক্ষাক্ষেতে দ্বিতীয়বার যেয়ো না, অথবা ঝরে পড়া আঙুর তুলবে না। দরিদ্র ও বিদেশিদের জন্য সেগুলি ছেড়ে দিয়ো। আমি তোমাদের ঈশ্বর সদাপ্রভুর। ");
INSERT INTO benobcv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘চুরি কোরো না। “ ‘মিথ্যা কথা বোলো না। “ ‘একজন অন্যজনকে প্রতারণা কোরো না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘আমার নাম নিয়ে মিথ্যা দিব্যি করবে না এবং এইভাবে তোমাদের ঈশ্বরের নাম অপবিত্র করবে না। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘তোমাদের প্রতিবেশীকে নির্যাতন করবে না কিংবা তার কোনো জিনিস হরণ করবে না। “ ‘বেতনজীবীর বেতন রাত্রি অতিবাহিত না হওয়া পর্যন্ত ধরে রেখো না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘বধিরকে অভিশাপ দিয়ো না, অথবা অন্ধজনের সামনে বাধা রেখো না; কিন্তু তোমাদের ঈশ্বরকে ভয় কোরো। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘তোমরা বিচারে অন্যায় করবে না; দরিদ্রের প্রতি পক্ষপাতিত্ব দেখাবে না, অথবা ধনবানকে তোষণ করবে না, কিন্তু তোমাদের প্রতিবেশীর প্রতি ন্যায়বিচার করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘তোমাদের লোকদের মাঝে কুৎসা রটাতে এগিয়ে যেয়ো না। “ ‘এমন কোনো কাজ করবে না, যার দ্বারা তোমাদের প্রতিবেশীর জীবন বিপন্ন হয়। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘তোমরা হৃদয়ে তোমাদের আত্মীয়কে ঘৃণা কোরো না। তোমাদের প্রতিবেশীকে খোলাখুলিভাবে অনুযোগ করো, যেন তার অপরাধের ভাগী হতে না হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘তোমার লোকদের কারও বিরুদ্ধে প্রতিহিংসাপরায়ণ হবে না, অথবা তার বিপক্ষে বিরূপ মনোভাব রেখো না, কিন্তু প্রতিবেশীকে নিজের মতোই ভালোবেসো। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘আমার বিধিবিধান পালন করবে। “ ‘বিভিন্ন ধরনের পশুর মধ্যে সংসর্গ করতে দিয়ো না। “ ‘তোমার জমিতে দুই ধরনের বীজবপন করবে না। “ ‘দুই ধরনের উপাদান দিয়ে বোনা কাপড় পরবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘যদি একটি পুরুষ কোনো এক নারীর সঙ্গে শয়ন করে, যে এক ক্রীতদাসী ও অন্য পুরুষের প্রতি বাগদত্তা, কিন্তু যার বন্ধনমুক্ত হয়নি, অথবা তাকে স্বাধীনতা দেওয়া হয়নি, তার শাস্তি হবেই। কিন্তু তাদের মৃত্যুদণ্ড দেওয়া হবে না, কেননা সে মুক্ত হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","অন্যদিকে, সদাপ্রভুর উদ্দেশে এক দোষার্থক-নৈবেদ্যদানার্থে সমাগম তাঁবুর প্রবেশদ্বারে ওই পুরুষ অবশ্যই একটি মেষ আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","যাজক দোষার্থক-নৈবেদ্যদানের মেষটি নিয়ে পুরুষটির পাপের জন্য সদাপ্রভুর সামনে তার পক্ষে প্রায়শ্চিত্ত করবে এবং তার পাপের ক্ষমা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘দেশে প্রবেশের পর তোমরা যে কোনো ফলের গাছ রোপণ করো, এর ফল নিষিদ্ধ বিবেচনা করো, কেননা তিন বছর পর্যন্ত এটি নিষিদ্ধ বিবেচিত হবে। এর ফল ভোজন করা যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","চতুর্থ বছরে এর সমস্ত ফল পবিত্র হবে, সদাপ্রভুর উদ্দেশে এটি প্রশংসাসূচক এক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","কিন্তু পঞ্চম বছরে তুমি এর ফল ভোজন করতে পারো। এইভাবে তোমার ফসল বৃদ্ধি পাবে। আমি তোমার ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘রক্ত সমেত কোনো মাংস ভোজন করবে না। “ ‘ভবিষ্যৎ-কথন অথবা জাদুবিদ্যা অনুশীলন করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘তোমার মাথার কিনারার চুল অথবা তোমার দাড়ির প্রান্তভাগ ছাঁটবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘মৃত মানুষের জন্য তোমার দেহে অস্ত্রাঘাত কোরো না অথবা দেহে ক্ষোদিত চিহ্ন দিয়ো না। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘তুমি তোমার মেয়েকে ব্যভিচারিণী বানিয়ে তার মর্যাদাহানি করবে না পাছে দেশ ব্যভিচারে পূর্ণ হয় ও সব ধরনের লাম্পট্যে ভরে যায়। ");
INSERT INTO benobcv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘আমার বিশ্রামবার পালন কোরো ও আমার পবিত্র ধর্মধামের প্রতি সম্মান দেখাও। আমি তোমার ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘তোমরা প্রেত মাধ্যমদের ও মায়াবীদের অভিমুখে যেয়ো না, কেননা তাদের সংস্পর্শে তোমরা কলুষিত হবে। আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘বয়স্কদের উপস্থিতিতে তোমরা উঠে দাঁড়াও, প্রাচীনদের প্রতি সম্মান দেখাও এবং তোমার ঈশ্বরকে ভয় কোরো। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘তোমাদের দেশে তোমাদের সঙ্গে বসবাসকারী বিদেশির প্রতি দুর্ব্যবহার করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","তোমার কাছে স্বদেশীয় যেমন, তোমাদের সঙ্গে বসবাসকারী বিদেশির প্রতিও তুমি অবশ্যই একই ব্যবহার করবে। তুমি তাকে নিজের মতো ভালোবেসো, কেননা মিশরে তুমিও প্রবাসী ছিলে। আমি তোমার ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘দৈর্ঘ্য, ওজন অথবা পরিমাণ পরিমাপ করার সময় অবৈধ বাটখারা ব্যবহার করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ন্যায্য মাপনী, ন্যায্য বাটখারা, ন্যায্য ঐফা ও ন্যায্য হিন ব্যবহার করবে। আমি তোমাদের ঈশ্বর সদাপ্রভু, যিনি মিশর দেশ থেকে তোমাদের বের করে এনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘আমার সব অনুশাসন ও বিধিবিধান পালন করবে, এবং সেগুলির অনুগামী হবে। আমি সদাপ্রভু।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ইস্রায়েলীদের বলো, ‘কোনো ইস্রায়েলী অথবা ইস্রায়েলে বসবাসকারী কোনো প্রবাসী যদি তার সন্তানদের মোলকের উদ্দেশে উৎসর্গ করার জন্য দেয়, তাহলে অবশ্যই তার প্রাণদণ্ড হবে। সমাজের লোকেরা তাকে প্রস্তরাঘাত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","আমি তার বিরুদ্ধে বিমুখ হব ও তার পরিজনদের মধ্যে থেকে তাকে উচ্ছিন্ন করব; কারণ মোলকের উদ্দেশে তার সন্তান দিয়ে সে আমার পবিত্র ধর্মধাম কলুষিত করেছে ও আমার পবিত্র নাম কলঙ্কিত করেছে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","যখন সে তার সন্তানদের মধ্য থেকে একটি সন্তান মোলককে উৎসর্গ করে, তখন যদি সমাজের লোকেরা তাদের চোখ বন্ধ রাখে ও তাকে মৃত্যুদণ্ড দিতে না পারে, ");
INSERT INTO benobcv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","তাহলে সেই ব্যক্তি ও তার পরিবারের বিপক্ষে আমি বিমুখ হব এবং তাকে ও তার অনুগামী মোলকের সঙ্গে ব্যভিচারী সবাইকে তাদের পরিজনদের মধ্য থেকে উচ্ছিন্ন করব। ");
INSERT INTO benobcv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘সেই মানুষের বিপক্ষে আমি বিমুখ হব, যে ভূতপ্রেত ও গুণীনদের অনুগমনে ব্যভিচার করার জন্য তাদের অভিমুখে যায় এবং তাকে তার আপনজনদের মধ্য থেকে আমি উচ্ছিন্ন করব। ");
INSERT INTO benobcv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘তোমরা নিজেদের উৎসর্গ করো ও পবিত্র হও, কেননা আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","আমার বিধিবিধান পালন করবে, সেগুলির অনুগামী হবে। আমিই সদাপ্রভু, যিনি তোমাদের পবিত্র করেন। ");
INSERT INTO benobcv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘যদি কেউ তার বাবাকে বা মাকে অভিশাপ দেয়, তাকে মৃত্যুদণ্ড পেতে হবে। সে তার বাবাকে বা মাকে অভিশাপ দিয়েছে; সুতরাং তার রক্ত তার নিজের মাথায় প্রযোজ্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘যদি কোনো ব্যক্তি অন্যের স্ত্রীর সঙ্গে ব্যভিচার করে—তার প্রতিবেশীর স্ত্রীর সঙ্গে—ব্যভিচারী ও ব্যভিচারিণী উভয়ের অবশ্যই প্রাণদণ্ড হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘যদি কোনো পুরুষ তার বাবার স্ত্রীর সঙ্গে শয়ন করে, সে তার বাবাকে অশ্রদ্ধা করেছে। সেই পুরুষ ও নারী উভয়ের অবশ্যই মৃত্যুদণ্ড হবে; তাদের রক্ত তাদের নিজেদের মাথায় গিয়ে পড়বে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘যদি কেউ তার ছেলের বউ-এর সঙ্গে শয়ন করে তাদের উভয়ের প্রাণদণ্ড হবে। তারা যা করেছে তা স্বেচ্ছাচারিতা; তাদের রক্ত তাদের নিজেদের মাথায় গিয়ে পড়বে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘যদি কোনো পুরুষ অন্য এক পুরুষের সঙ্গে শয়ন করে, যেমন একটি পুরুষ কোনো নারীর সঙ্গে যৌন সম্পর্কে করে তাহলে তারা দুজনই ঘৃণিত কাজ করেছে। অবশ্যই তাদের মৃত্যুদণ্ড হবে; তাদের রক্ত তাদের নিজেদের মাথায় গিয়ে পড়বে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘যদি কোনো পুরুষ এক নারী ও তার মাকে বিয়ে করে, এটি দুশ্চরিত্রতা। তাকে ও তাদের আগুনে জ্বালিয়ে দিতে হবে, যেন তোমাদের মাঝে কোনো দুশ্চরিত্রতা না থাকে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘যদি কোনো পুরুষ একটি পশুর সঙ্গে কামনা চরিতার্থ করে, তার অবশ্যই মৃত্যুদণ্ড হবে এবং পশুকে তোমরা অবশ্যই বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘যদি একটি নারী কামনা চরিতার্থ করতে কোনো পশুর কাছে যায়, সেই নারী ও পশু উভয়কে তোমরা অবশ্যই বধ করবে। অবশ্যই তাদের মৃত্যুদণ্ড দেবে। তাদের রক্ত তাদের নিজেদের মাথায় গিয়ে পড়বে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘যদি কোনো পুরুষ তার বোনকে বিয়ে করে, যে তার বাবার অথবা মায়ের মেয়ে এবং তারা কামনা চরিতার্থ করে, এটি লজ্জার বিষয়। তাদের পরিজনদের নজর থেকে তাদের উচ্ছিন্ন করতেই হবে। সে তার বোনের সতীত্ব হরণ করেছে এবং এই দুষ্কর্মের জন্য সে দায়ী থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘যদি কোনো পুরুষ একটি স্ত্রীলোকের মাসিক রক্তস্রাব চলাকালীন তার সঙ্গে শয়ন ও কামনা চরিতার্থ করে, সে ওই স্ত্রীলোকের স্রাবের উৎস উন্মোচন করে এবং স্ত্রীলোকটিও তা অনাবৃত করে। তাদের উভয়কে তাদের আপনজনদের মধ্য থেকে অবশ্যই উচ্ছিন্ন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘তোমার মায়ের অথবা তোমার বাবার বোনের সঙ্গে যৌন সম্পর্ক স্থাপন করবে না; কেননা সেই কাজ নিকট আত্মীয়ের প্রতি অসম্মানজনক। এর জন্য তোমরা দুজনই দায়ী থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘যদি কোনো পুরুষ তার আত্মীয়ার সঙ্গে শয়ন করে, তাহলে সে তার আত্মীয়কে অশ্রদ্ধা করেছে। তারা অপরাধী হবে ও নিঃসন্তান থাকাকালীন মারা যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘যদি কোনো পুরুষ তার ভাইয়ের বউকে বিয়ে করে, এই কাজ অশুদ্ধাচার; সে তার অগ্রজকে অশ্রদ্ধা করেছে। তারা নিঃসন্তান থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘আমার সব অনুশাসন ও বিধান পালন করবে ও সেগুলির অনুগামী হবে, যেন যে দেশে তোমাদের আমি নিয়ে যাচ্ছি, সেই দেশ তোমাদের উগরে না ফেলে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","তোমরা ওই সমস্ত জাতির বিভিন্ন প্রথা অনুযায়ী জীবনযাপন করবে না, তোমাদের সামনে থেকে যাদের আমি বিতাড়িত করতে যাচ্ছি, কেননা আমার দৃষ্টিতে অত্যন্ত ঘৃণিত কাজগুলি এরা করেছে। ");
INSERT INTO benobcv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","কিন্তু আমি তোমাদের বলেছি, “তাদের দেশ তোমরা অধিকার করবে। আমি উত্তরাধিকাররূপে দেশটি তোমাদের দেব, যে দেশে দুধ ও মধু প্রবাহিত হয়।” আমি তোমাদের ঈশ্বর সদাপ্রভু, যিনি সমস্ত জাতি থেকে তোমাদের পৃথক করেছেন। ");
INSERT INTO benobcv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘অতএব, শুচি ও অশুচি পশুদের মাঝে এবং অশুচি ও শুচি পাখিদের মাঝে তোমরা অবশ্যই তফাৎ রাখবে। কোনো পশু অথবা পাখি কিংবা ভূমিতে বিচরণকারী কোনো কিছুর দ্বারা নিজেদের কলুষিত করবে না—তোমাদের জন্য অশুচিরূপে সেগুলিকে আমি পৃথক রেখেছি। ");
INSERT INTO benobcv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","আমার উদ্দেশে তোমাদের পবিত্র হতে হবে, কারণ আমি সদাপ্রভু পবিত্র এবং জাতিদের মধ্য থেকে তোমাদের আমি পৃথক রেখেছি, যেন তোমরা আমার নিজস্ব হও। ");
INSERT INTO benobcv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘তোমাদের মধ্যে বসবাসকারী কোনো পুরুষ বা নারী যদি প্রেতমাধ্যম অথবা জাদুকর হয়, তার অবশ্যই মৃত্যুদণ্ড হবে। তাদের তোমরা প্রস্তরাঘাত করবে। তাদের রক্ত তাদের নিজেদের মাথায় গিয়ে পড়বে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","সদাপ্রভু মোশিকে বললেন, “হারোণের ছেলে যাজকদের জানাও, তাদের বলো, ‘কোনো যাজক তার কোনো মৃত আপনজনের পক্ষে আনুষ্ঠানিকভাবে যেন নিজেকে অশুচি না করে, ");
INSERT INTO benobcv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","কেবল কোনো নিকট আত্মীয়, যেমন তার মা অথবা বাবা, তার ছেলে অথবা মেয়ে, তার ভাই, ");
INSERT INTO benobcv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","অথবা অবিবাহিতা বোন, যে তার উপরে নির্ভরশীল, যেহেতু তার স্বামী নেই—এই বোনের জন্য সে নিজেকে অশুচি করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","বিবাহ দ্বারা সম্পর্কিত লোকদের জন্য সে নিজেকে কখনও অশুদ্ধ করবে না, কোনোভাবে নিজে কলুষিত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘যাজকেরা তাদের মাথা ও দাড়ির প্রান্তভাগ ছাঁটবে না, অথবা নিজেদের দেহে অস্ত্রাঘাত করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","তারা তাদের ঈশ্বরের উদ্দেশে অবশ্যই পবিত্র হবে এবং তাদের ঈশ্বরের নাম কখনও কলঙ্কিত করবে না। যেহেতু সদাপ্রভুর উদ্দেশে তারা অগ্নিকৃত উপহার আনে, তাদের ঈশ্বরের উদ্দেশে ভক্ষ্য-নৈবেদ্য রাখে, সেই কারণে তাদের পবিত্র হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘বেশ্যাবৃত্তি দ্বারা কলঙ্কিত রমণীদের অথবা বিবাহবিচ্ছেদ হয়েছে এমন মহিলাদের তারা কোনোমতে বিয়ে করবে না, কারণ যাজকেরা তাদের ঈশ্বরের কাছে পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","পবিত্ররূপে তাদের বিবেচনা করো, কারণ তোমাদের ঈশ্বরের উদ্দেশে তারা ভক্ষ্য-নৈবেদ্য উৎসর্গ করে। তাদের পবিত্র বলে বিবেচনা করো, কেননা সদাপ্রভু পবিত্র—আমি তোমাদের পবিত্র করি। ");
INSERT INTO benobcv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘যদি কোনো যাজকের মেয়ে বেশ্যা হয়ে নিজেকে কলুষিত করে, সে তার বাবাকে লজ্জা দেয়, তাকে অবশ্যই আগুনে জ্বালিয়ে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘নিজের ভাইদের মধ্যে প্রধান যাজক, যার মাথায় অভিষেকের তেল ঢালা হয়েছে এবং যাজকীয় পোশাক পরার জন্য যে অভিষিক্ত হয়েছে, সে তার চুল এলোমেলো রাখবে না, অথবা তার কাপড় ছিঁড়বে না। ");
INSERT INTO benobcv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","সে এমন জায়গায় কখনও প্রবেশ করবে না, যেখানে মৃতদেহ রয়েছে। সে তার বাবা অথবা মায়ের জন্যও নিজেকে কখনও অশুচি করবে না, ");
INSERT INTO benobcv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","তার ঈশ্বরের পবিত্রস্থান পরিত্যাগ করবে না, অথবা তা অপবিত্র করবে না, কারণ সে তার ঈশ্বরের অভিষেকের তেল দিয়ে স্থানটিকে উৎসর্গ করেছে। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘তার বিয়ের জন্য পাত্রী যেন অবশ্যই কুমারী মেয়ে হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","সে কোনো বিধবাকে, বিবাহ-বিচ্ছিন্না মহিলাকে অথবা বেশ্যাকে কখনও বিয়ে করবে না, কিন্তু তার লোকদের মধ্য থেকে কেবল একটি কুমারী মেয়েকে বিয়ে করবে, ");
INSERT INTO benobcv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","যেন এইভাবে তার লোকদের মাঝে নিজের বংশধরদের সে অপবিত্র না করে। আমি সদাপ্রভু, যিনি তাকে পবিত্র করেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“তুমি হারোণকে বলো, ‘আগামী প্রজন্মগুলিতে তার বংশধরদের মধ্যে যদি কারও খুঁত থাকে, সে যেন তার ঈশ্বরের উদ্দেশে ভক্ষ্য-নৈবেদ্য উৎসর্গ করতে নিকটবর্তী না হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","দোষযুক্ত কোনো মানুষ কাছে আসতে পারবে না, অন্ধ অথবা খঞ্জ, বিকলাঙ্গ অথবা অঙ্গহীন কেউ দোষমুক্ত নয়; ");
INSERT INTO benobcv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","যার পা অথবা হাত অকেজো, ");
INSERT INTO benobcv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","অথবা যে কুঁজো বা বামন, কিংবা যার চোখে ছানি পড়েছে অথবা যে পুঁজযুক্ত ক্ষতবিশিষ্ট, কিংবা ভগ্ন অণ্ডকোষ বিশিষ্ট, ");
INSERT INTO benobcv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","যাজক হারোণের বংশধরদের মধ্যে কেউ খুঁতযুক্ত থাকলে সদাপ্রভুর উদ্দেশে অগ্নিকৃত উপহার উৎসর্গ করতে সে আসতে পারবে না। যেহেতু তার দোষ আছে; তাই তার ঈশ্বরের উদ্দেশে ভক্ষ্য-নৈবেদ্য উৎসর্গ করতে সে কখনও কাছে আসতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","সে তার ঈশ্বরের অতি পবিত্র ভক্ষ্য এবং পবিত্র খাদ্যবস্তু ভোজন করতে পারবে; ");
INSERT INTO benobcv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","তবুও তার খুঁতের কারণে সে পর্দার কাছে অথবা বেদির অভিমুখে একেবারেই যাবে না, যেন আমার পবিত্রস্থান কলুষিত না হয়। আমি সদাপ্রভু, যিনি তাদের পবিত্র করেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","সুতরাং হারোণকে, তার সব ছেলেকে ও সব ইস্রায়েলীকে মোশি এইসব কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“হারোণ ও তার ছেলেদের তুমি জানিয়ে দাও, আমার উদ্দেশে ইস্রায়েলীদের উৎসর্গীকৃত পবিত্র উপহারগুলির প্রতি তারা যেন সম্মান প্রদর্শন করে এবং আমার পবিত্র নাম তারা যেন অপবিত্র না করে। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“তাদের বলো, ‘আগামী প্রজন্মগুলিতে তোমাদের বংশধরদের মধ্যে কেউ যদি আনুষ্ঠানিকভাবে অশুচি থাকে এবং তবুও সদাপ্রভুর উদ্দেশে ইস্রায়েলীদের উৎসর্গীকৃত পবিত্র উপহারগুলির কাছে সে আসে, তাহলে আমার সামনে থেকে সেই ব্যক্তি উচ্ছিন্ন হবে। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘যদি হারোণের কোনো এক বংশধরের সংক্রামক চর্মরোগ অথবা দেহের ক্ষরণ থাকে, পবিত্র নৈবেদ্য সে ভোজন করবে না, যতক্ষণ না সে শুচি হয়। সে অশুচি হবে, যদি মৃতদেহ দ্বারা কলুষিত কোনো বস্তু অথবা বীর্য নির্গমিত ব্যক্তিকে স্পর্শ করে; ");
INSERT INTO benobcv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","অথবা যদি সে কোনো সরীসৃপকে স্পর্শ করে, সেই স্পর্শে সে অশুচি হবে, অথবা সে কোনো অশুচিতায় কোনো অশুচি মানুষের স্পর্শে সে অশুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","এই ধরনের দ্রব্যকে যে কেউ স্পর্শ করবে, সে সন্ধ্যা পর্যন্ত অশুচি বিবেচিত হবে। সে কোনো পবিত্র নৈবেদ্য ভোজন করতেই পারবে না, যতক্ষণ না জলে স্নান করছে। ");
INSERT INTO benobcv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","সূর্য অস্ত গেলে সে শুচিশুদ্ধ হবে এবং এরপরে পবিত্র নৈবেদ্য সে ভোজন করতে পারবে; কেননা সেগুলি তার খাদ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","কোনো মৃত অথবা বন্যপশু দ্বারা ছিন্ন-বিচ্ছিন্ন কোনো প্রাণী সে কখনও ভোজন করবে না এবং এইভাবে নিজে অশুচি হবে না। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘যাজকেরা আমার চাহিদাগুলি পূরণ করবে, যেন অপরাধী না হয় এবং সেগুলিকে অবজ্ঞা করে মারা না যায়। আমি সদাপ্রভু, যিনি তাদের পবিত্র করেন। ");
INSERT INTO benobcv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘যাজকীয় পরিবারের বহির্ভূত কেউ পবিত্র নৈবেদ্য ভোজন করতে পারবে না, অথবা যাজকের কোনো অতিথি কিংবা বেতনজীবী কর্মী এই খাদ্যের অংশীদার হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","কিন্তু যদি যাজক টাকা দিয়ে এক ক্রীতদাস ক্রয় করে, অথবা তার বাড়িতে কোনো ক্রীতদাসের জন্ম হয়, তাহলে ক্রীতদাস সেই খাদ্য ভোজন করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","যদি যাজকের একটি মেয়ে যাজকের পরিবর্তে অন্য একজনকে বিয়ে করে, তাহলে মেয়েটি কোনো পবিত্র নৈবেদ্য ভোজন করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","কিন্তু যাজকের মেয়ে যদি বিধবা হয়, অথবা তার বিবাহবিচ্ছেদ হয়ে থাকে, অথচ সন্তান না থাকে এবং তার যৌবন থাকাকালীন বাবার বাড়িতে বসবাস করতে সে ফিরে আসে, তাহলে সে তার বাবার খাদ্য ভোজন করবে। অন্যদিকে, কোনো অস্বীকৃত মানুষ ভোজন করতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘যদি কেউ ভুলবশত পবিত্র নৈবেদ্য ভোজন করে, তাহলে ওই নৈবেদ্যের পক্ষে সে যাজককে ক্ষতিপূরণ দেবে। খাদ্যমানের পঞ্চমাংশ সে সংযোজিত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","সদাপ্রভুর উদ্দেশে ইস্রায়েলীদের উৎসর্গীকৃত পবিত্র নৈবেদ্য যাজক কিছুতেই কালিমালিপ্ত করবে না, ");
INSERT INTO benobcv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","পবিত্র খাদ্য লোকদের ভোজন করতে দেবে না, যেন এর বিনিময়ে তাদের ওপরে অপরাধ না বর্তায়। আমি সদাপ্রভু, যিনি তাদের পবিত্র করেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“হারোণ, তার সব ছেলেদের ও সব ইস্রায়েলীর সঙ্গে তুমি কথা বলো এবং তাদের জানাও, ‘যদি তোমাদের কেউ, কিংবা ইস্রায়েলের কোনো একজন অথবা ইস্রায়েলে বসবাসকারী কোনো প্রবাসী মানত পূরণে অথবা স্বেচ্ছাদত্ত উপহাররূপে সদাপ্রভুর উদ্দেশে হোমার্থক বলি উৎসর্গ করে, ");
INSERT INTO benobcv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","তাহলে একটি নির্দোষ বলদ, অথবা পুংমেষ কিংবা পুংছাগ তোমরা অবশ্যই উৎসর্গ করবে, যেন তোমাদের পক্ষে এই উৎসর্গ গৃহীত হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","খুঁতযুক্ত কোনো কিছু আনবে না, অন্যথায় তোমাদের পক্ষে তা গৃহীত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","যখন কেউ কোনো মানত পূরণ করার জন্য অথবা স্বেচ্ছাদত্ত উপহারস্বরূপ সদাপ্রভুর উদ্দেশে ষাঁড় অথবা মেষ মঙ্গলার্থক বলিদানরূপে আনে, সেটি গৃহীত হওয়ার জন্য যেন নির্দোষ বা নিষ্কলঙ্ক হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","সদাপ্রভুর উদ্দেশে অন্ধ, আহত, অথবা বিকলাঙ্গ, কিংবা আবযুক্ত অথবা পুঁজযুক্ত ক্ষতবিশিষ্ট কোনো কিছু আনবে না। সদাপ্রভুর উদ্দেশে এই ধরনের কোনো দোষযুক্ত পশু হোমার্থক বলিরূপে বেদিতে রাখবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","অন্যদিকে, একটি গরু অথবা একটি মেষ স্বেচ্ছাদত্ত উপহাররূপে উৎসর্গ করতে পারো, এগুলি বিকলাঙ্গ অথবা বুদ্ধিবিহীন বিশিষ্ট হতে পারে, কিন্তু কোনো মানত পূরণের জন্য এই উপহার গৃহীত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","সদাপ্রভুর উদ্দেশে এমন কোনো পশু উৎসর্গ করবে না, যার অণ্ডকোষ থেঁতলানো, চূর্ণ অথবা বিদীর্ণ। তোমাদের দেশে তোমরা এই কাজ কখনও করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","কোনো বিদেশির নিকট থেকে এই ধরনের পশু তোমরা কখনও গ্রহণ করবে না এবং ভক্ষ-নৈবেদ্য স্বরূপ তোমার ঈশ্বরের উদ্দেশে উৎসর্গ করবে না। তোমাদের পক্ষে সেগুলি গৃহীত হবে না, কারণ সেগুলি বিকৃত ও খুঁতযুক্ত।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“যখন কোনো বাছুর, মেষশাবক অথবা ছাগল জন্মাবে, তার মায়ের সঙ্গে তাকে সাত দিন থাকতে হবে। অষ্টম দিন থেকে ওই শাবক হোমার্থক বলিরূপে সদাপ্রভুর উদ্দেশে গৃহীত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","একই দিনে কোনো গরু অথবা মেষ ও তার শাবককে হত্যা করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“যখন সদাপ্রভুর উদ্দেশে তোমরা ধন্যবাদের উপহার বলি দেবে, এমনভাবে সেই বলি দিতে হবে, যেন তোমাদের পক্ষে তা গৃহীত হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","বলিদানের মাংস সেদিনই ভোজন করতে হবে; সকাল পর্যন্ত কিছু অবশিষ্ট রেখো না। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“আমার সব আদেশ পালন করো এবং সেগুলি অনুসরণ করো। আমি সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","আমার পবিত্র নাম অপবিত্র করবে না। ইস্রায়েলীদের দ্বারা পবিত্ররূপে আমাকে স্বীকৃতি পেতেই হবে। আমি সদাপ্রভু, যিনি তোমাদের পবিত্র করেন ");
INSERT INTO benobcv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","এবং যিনি মিশর থেকে তোমাদের বের করে এনেছেন, যেন তোমাদের ঈশ্বর হন। আমি সদাপ্রভু।” ");
INSERT INTO benobcv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ইস্রায়েলীদের সঙ্গে তুমি কথা বলো এবং তাদের বলো, ‘এগুলি আমার নির্দিষ্ট উৎসব, সদাপ্রভুর নির্দিষ্ট উৎসব, পবিত্র সমাবেশরূপে সেগুলি তোমরা ঘোষণা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘তোমরা ছয় দিন কাজ করতে পারবে, কিন্তু সপ্তম দিন বিশ্রামের জন্য বিশ্রামদিন, পবিত্র সমাবেশ দিবস। এই দিনে তোমরা কোনো কাজ করবে না; তোমরা যেখানেই থাকো, দিনটি সদাপ্রভুর উদ্দেশে বিশ্রামদিন। ");
INSERT INTO benobcv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘এগুলি সদাপ্রভুর নির্দিষ্ট উৎসব, এগুলি নির্দিষ্ট সময়ে তোমরা বিভিন্ন পবিত্র সমাবেশে ঘোষণা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","প্রথম মাসের চতুর্দশ দিনে গোধূলি লগ্নে সদাপ্রভুর নিস্তারপর্ব শুরু হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","সেই মাসের পঞ্চদশ দিনে সদাপ্রভুর খামিরবিহীন রুটির উৎসব শুরু হয়; সাত দিন ধরে খামিরবিহীন রুটি তোমরা অবশ্যই ভোজন করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","প্রথম দিনে পবিত্র সমাবেশ রাখবে এবং সেদিন নিয়মিত কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","সাত দিন ধরে সদাপ্রভুর উদ্দেশে ভক্ষ্য-নৈবেদ্য আনবে। সপ্তম দিনে পবিত্র সভা রাখবে এবং সেদিন কোনো নিয়মিত কাজ করবে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ইস্রায়েলীদের সঙ্গে তুমি কথা বলো এবং তাদের বলো, ‘তোমরা যে দেশে প্রবেশ করবে, যা আমি তোমাদের দিতে যাচ্ছি, সেখানে তোমরা ফসল সংগ্রহ করবে এবং সংগৃহীত শস্যের প্রথম আঁটি যাজকের কাছে আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","সদাপ্রভুর সামনে যাজক সেই আঁটি দোলাবে, যেন তোমাদের পক্ষে তা গৃহীত হয়; বিশ্রামদিনের পরবর্তী দিনে যাজক সেই আঁটি দোলাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","যেদিন তোমরা বাঁধা আঁটি দোলাবে, সেদিন এক বর্ষীয় নির্দোষ মেষশাবক হোমবলিরূপে সদাপ্রভুর উদ্দেশে উৎসর্গ করবে, ");
INSERT INTO benobcv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","এবং একইসঙ্গে তেল মিশ্রিত এক ঐফা মিহি ময়দার দুই-দশমাংশ শস্য-নৈবেদ্য আনবে—সদাপ্রভুর উদ্দেশে সুগন্ধযুক্ত সন্তোষজনক এক উপহার—এবং এক হিন দ্রাক্ষারসের এক-চতুর্থাংশ পেয়-নৈবেদ্য রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","যতদিন না নির্দিষ্ট দিনে সদাপ্রভুর উদ্দেশে তোমরা এই উপহার আনছ, ততদিন পর্যন্ত কোনো রুটি বা সেঁকা খাদ্য অথবা নবান্ন ভোজন করবে না। তোমরা যেখানেই বসবাস করো, আগামী প্রজন্মগুলির পক্ষে এ এক চিরস্থায়ী বিধি। ");
INSERT INTO benobcv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘বিশ্রামদিনের পরবর্তী দিন থেকে, দোলনীয় উপহাররূপ আঁটি আনার দিন থেকে সম্পূর্ণ সাত সপ্তাহ গণনা করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","সপ্তম বিশ্রামদিনের পরবর্তী দিন থেকে পঞ্চাশ দিন গণনা করবে এবং পরে সদাপ্রভুর উদ্দেশে নতুন শস্যের নৈবেদ্য নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","তোমরা যেখানেই বসবাস করো সেখান থেকে এক ঐফা মিহি ময়দার দুই-দশমাংশ দিয়ে তৈরি খামিরযুক্ত দুটি রুটি সদাপ্রভুর উদ্দেশে প্রথম ফসলের দোলনীয় উপহাররূপে আনবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","এই রুটির সঙ্গে এক বর্ষীয় সাতটি নির্দোষ মদ্দা মেষশাবক, একটি কমবয়সি ষাঁড় ও দুটি মেষ রাখবে। শস্য-নৈবেদ্য ও পেয়-নৈবেদ্যের সঙ্গে এগুলি সদাপ্রভুর উদ্দেশে হোম-নৈবেদ্যরূপে বিবেচিত হবে—সদাপ্রভুর উদ্দেশে সুরভিযুক্ত ভক্ষ্য-নৈবেদ্যের সন্তোষজনক এক উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","পরে পাপার্থক বলিরূপে একটি পুংছাগ এবং মঙ্গলার্থক বলিরূপে এক বর্ষীয় দুটি মেষশাবক উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","সদাপ্রভুর উদ্দেশে প্রথম ফসলের রুটির সঙ্গে দোলনীয় উপহাররূপে দুটি মেষশাবক যাজক দোলাবে। যাজকের পক্ষে এগুলি সদাপ্রভুর উদ্দেশে পবিত্র উপহার। ");
INSERT INTO benobcv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","একই দিনে তোমরা পবিত্র সমাবেশ ঘোষণা করবে এবং কোনো নিয়মিত কাজ করবে না। তোমরা যেখানেই বসবাস করো, আগামী প্রজন্মগুলির পক্ষে এ এক চিরস্থায়ী বিধি। ");
INSERT INTO benobcv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘যখন তোমাদের দেশে তোমরা শস্য ছেদন করবে, ক্ষেত্রের প্রান্তসীমার শস্য ছেদন অথবা পতিত শস্য সংগ্রহ করবে না। দরিদ্র ও তোমাদের মধ্যে বসবাসকারী বিদেশিদের জন্য সেগুলি রেখে দিয়ো। আমি তোমাদের ঈশ্বর সদাপ্রভু।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“তুমি ইস্রায়েলীদের বলো, ‘সপ্তম মাসের প্রথম দিনে বিশ্রামদিন পালন করবে, তূরীধ্বনি সহকারে পবিত্র সমাবেশ দিবস স্মরণ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","নিয়মিত কোনো কাজ করবে না, কিন্তু সদাপ্রভুর উদ্দেশে ভক্ষ্য-নৈবেদ্য নিবেদন করবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“এই সপ্তম মাসের দশম দিনটি প্রায়শ্চিত্ত দিবস। এক পবিত্র সমাবেশ আয়োজন করো এবং নিজেদের অস্বীকার করবে ও সদাপ্রভু উদ্দেশে ভক্ষ্য-নৈবেদ্য দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ওই দিনে কোনো কাজ করবে না, কারণ দিনটি প্রায়শ্চিত্ত দিবস, যেদিন তোমাদের ঈশ্বর সদাপ্রভুর সামনে তোমাদের জন্য প্রায়শ্চিত্ত করা হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","যদি সেদিন কেউ নিজেকে অস্বীকার না করে, সে তার আপনজনদের মধ্য থেকে উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","যদি সেদিন কেউ কাজ করে, তাহলে তার আপনজনদের মধ্য থেকে আমি তাকে বিনষ্ট করব। ");
INSERT INTO benobcv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","তোমরা কোনো কাজই করবে না। তোমরা যেখানেই বসবাস করো, আগামী প্রজন্মগুলির পক্ষে এটি চিরস্থায়ী বিধি। ");
INSERT INTO benobcv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","এটি তোমাদের জন্যে এক বিশ্রামের দিন, সেদিন তোমরা নিজেদের অস্বীকার করবে। মাসের নবম দিনের সন্ধ্যা থেকে পরবর্তী সন্ধ্যা পর্যন্ত এটি তোমাদের পালনীয় বিশ্রামদিন।” ");
INSERT INTO benobcv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ইস্রায়েলীদের বলো, ‘সপ্তম মাসের পঞ্চদশ দিনে সদাপ্রভুর উদ্দেশে কুটিরবাস-পর্ব পালন করতে হবে এবং এই পর্ব সাত দিন পর্যন্ত চলবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","প্রথম দিনে এক পবিত্র সমাবেশ হবে; সেদিন কোনো নিয়মিত কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","সাত দিন ধরে সদাপ্রভুর উদ্দেশে ভক্ষ্য-নৈবেদ্য উৎসর্গ করবে এবং অষ্টম দিনে এক পবিত্র সমাবেশ রাখবে এবং সদাপ্রভুর উদ্দেশে তোমরা ভক্ষ্য-নৈবেদ্য উৎসর্গ করবে। এটি বিশেষ সমাপ্তি সমাবেশ; সেদিন কোনো নিয়মিত কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘এগুলি সদাপ্রভুর নির্দিষ্ট উৎসব, পবিত্র সমাবেশরূপে যেগুলি তোমরা ঘোষণা করবে, যখন সদাপ্রভুর উদ্দেশে তোমরা ভক্ষ্য-নৈবেদ্য আনবে—প্রতিদিনের জন্য হোমবলি, শস্য-নৈবেদ্য, বিভিন্ন বলিদান ও পেয়-নৈবেদ্য দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","এই উপাদানগুলি সদাপ্রভুর বিশ্রামদিনের উদ্দেশে, তোমাদের বিভিন্ন দান এবং তোমাদের রকমারি মানত ও সদাপ্রভুর উদ্দেশে তোমাদের স্বেচ্ছাদত্ত সব দানের অতিরিক্ত।) ");
INSERT INTO benobcv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘সুতরাং সপ্তম মাসের পঞ্চদশ দিনে জমি থেকে শস্য সংগ্রহ করার পর সাত দিন ধরে সদাপ্রভুর উদ্দেশে তোমরা উৎসব পালন করবে; প্রথম দিনটি বিশ্রামদিন এবং অষ্টম দিনটিও বিশ্রামদিন। ");
INSERT INTO benobcv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","প্রথম দিনে তোমরা পছন্দসই গাছের ফল, খেজুর পাতা, পাতাবাহার গাছের শাখা ও দীর্ঘ বৃক্ষবিশেষের শাখা তুলবে এবং তোমাদের ঈশ্বর সদাপ্রভুর সামনে সাত দিন ধরে আনন্দে মাতোয়ারা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","প্রতি বছর সাত দিন ধরে সদাপ্রভুর উদ্দেশে তোমরা এই উৎসব পালন করবে; আগামী প্রজন্মগুলির জন্য এটি চিরস্থায়ী বিধি। সপ্তম মাসে বিধি অনুযায়ী তোমরা উৎসব পালন করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","সাত দিনের জন্য তোমরা কুটিরে থাকবে; স্বদেশে জাত সব ইস্রায়েলী থাকবে, ");
INSERT INTO benobcv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","যেন তোমাদের বংশধরেরা জানতে পারে, যখন আমি মিশর থেকে তাদের বের করে এনেছিলাম তখন ইস্রায়েলীদের আমি কুটিরে বসবাস করিয়েছিলাম। আমি তোমাদের ঈশ্বর সদাপ্রভু।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","তখন সদাপ্রভুর উদ্দেশে নির্দিষ্ট উৎসবগুলি সম্বন্ধে মোশি ইস্রায়েলীদের জানালেন। ");
INSERT INTO benobcv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“আলোর জন্য নিংড়ে নেওয়া স্বচ্ছ জলপাই তেল তোমার কাছে নিয়ে আসার জন্য ইস্রায়েলীদের আদেশ দাও যেন প্রদীপগুলি সবসময় জ্বলতেই থাকে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","সমাগম তাঁবুতে সাক্ষ্য-সিন্দুকের পর্দার বাইরে সন্ধ্যা থেকে সকাল পর্যন্ত হারোণ অবিরত সদাপ্রভুর সামনে বাতিগুলি সাজিয়ে রাখবে। আগামী প্রজন্মগুলির জন্য এটি চিরস্থায়ী বিধি হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","সদাপ্রভুর সামনে নির্মল সোনার দীপাধারগুলিতে ওই প্রদীপগুলি সারাক্ষণ জ্বলবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“মিহি ময়দা দিয়ে বারোটি রুটি তৈরি করবে, প্রত্যেক রুটিতে এক ঐফা আটার দুই-দশমাংশ খরচ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","প্রভু সদাপ্রভুর সামনে নির্মল সোনার টেবিলে দুটি সারির প্রত্যেক সারিতে ছয়টি রুটি সাজিয়ে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","এক স্মারক অংশরূপে আবার রুটি জোগাতে ও সদাপ্রভুর উদ্দেশে ভক্ষ্য-নৈবেদ্য দিতে প্রত্যেক সারির পাশে কিছুটা নির্মল ধূপ ঢালবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","সদাপ্রভুর সামনে নিয়মিতভাবে প্রত্যেক বিশ্রামদিনে ইস্রায়েলীদের পক্ষে চিরস্থায়ী সন্ধিচুক্তিরূপে এই রুটি সাজাতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","এটি হারোণ ও তার ছেলেদের জন্য, এক পবিত্রস্থানে তারা এই খাদ্য ভোজন করবে, কারণ এটি হল তাদের নিয়মিত উপহারের অংশের এক অত্যন্ত পবিত্র অংশ যা সদাপ্রভুর উদ্দেশে ভক্ষ্য-নৈবেদ্য।” ");
INSERT INTO benobcv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ঘটনাক্রমে এক ইস্রায়েলী মায়ের ও এক মিশরীয় বাবার ছেলে ইস্রায়েলীদের মাঝে উপস্থিত হল এবং শিবিরের মধ্যে তার সঙ্গে এক ইস্রায়েলীর বিবাদ সংঘটিত হল। ");
INSERT INTO benobcv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ইস্রায়েলী মহিলার ছেলে (ঈশ্বরের) নামের প্রতি নিন্দা ও অভিশাপবাণী উচ্চারণ করল। সুতরাং লোকেরা তাকে মোশির কাছে আনল। (তার মায়ের নাম শিলোমিৎ, সে দান বংশীয় দিব্রির মেয়ে) ");
INSERT INTO benobcv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","তাদের প্রতি সদাপ্রভুর ইচ্ছা স্পষ্টভাবে প্রকাশিত না হওয়া পর্যন্ত তারা তাকে আটকে রাখল। ");
INSERT INTO benobcv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ঈশ্বরনিন্দুককে শিবিরের বাইরে নিয়ে যাও, তার কথা যতজন শুনেছে, তারা তার মাথায় হাত রাখবে ও সমগ্র জনসমাজ তাকে প্রস্তরাঘাত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","তুমি ইস্রায়েলীদের বলো, ‘যদি কেউ তার ঈশ্বরকে অভিশাপ দেয়, সে পাপের দায়ী হবে; ");
INSERT INTO benobcv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","যে কেউ সদাপ্রভুর নামের নিন্দা করবে, তার অবশ্যই মৃত্যুদণ্ড হবে। সমগ্র মণ্ডলী তাকে প্রস্তরাঘাত করবে। এক বিদেশি অথবা স্বদেশে জাত যে কেউ তাঁর নামের নিন্দা করবে, তাকে মৃত্যুদণ্ড পেতেই হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘যদি কেউ মানুষের জীবন নাশ করে, অবশ্যই তাকে মৃত্যুদণ্ড দেওয়া হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","যদি কেউ কারোর পশুর জীবন নেয় তাকে ক্ষতিপূরণ দিতেই হবে—প্রাণের পরিশোধে প্রাণ। ");
INSERT INTO benobcv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","যদি কেউ প্রতিবেশীকে আঘাত করে, সে যেমনি করুক, তাকে প্রত্যাঘাত পেতেই হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","জখমের পরিশোধে জখম, চোখের পরিবর্তে চোখ, দাঁতের পরিবর্তে দাঁত। সে যেমন অন্যকে আহত করেছে তেমনই তাকেও আহত হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","যে কেউ একটি পশুকে হত্যা করবে, সে অবশ্যই ক্ষতিপূরণ দেবে, কিন্তু কেউ যদি কোনো মানুষকে হত্যা করে, তাকেই হত হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","বিদেশি ও স্বদেশে জাত প্রত্যেকজনের জন্য একই নিয়ম প্রযোজ্য হবে। আমি তোমাদের ঈশ্বর সদাপ্রভু।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","পরে মোশি ইস্রায়েলীদের বললেন এবং লোকেরা ঈশ্বরনিন্দুককে শিবিরের বাইরে নিয়ে গেল ও তাকে প্রস্তরাঘাত করল। ইস্রায়েলীরা সেই কাজ করল, সদাপ্রভু মোশিকে যেমন আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","সদাপ্রভু সীনয় পর্বতে মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ইস্রায়েলীদের সঙ্গে তুমি কথা বলো, তাদের জানাও, ‘আমি যে দেশ তাদের দিতে যাচ্ছি, যখন তারা সেই দেশে প্রবেশ করবে, তখন সদাপ্রভুর উদ্দেশে যেন ভূমি বিশ্রাম ভোগ করে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ছয় বছর ধরে তোমরা ক্ষেতে বীজবপন করবে এবং ছয় বছর ধরে দ্রাক্ষাক্ষেতের অপ্রয়োজনীয় ডালপালা ছাঁটবে ও দ্রাক্ষাফল সংগ্রহ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","কিন্তু সপ্তম বছরে ভূমি বিশ্রাম, সদাপ্রভুর উদ্দেশে এক বিশ্রাম ভোগ করবে। এই বছরে তোমাদের ক্ষেত্রগুলি বীজবপন করবে না, অথবা দ্রাক্ষাক্ষেতের অনর্থক ডালপালাগুলি ছেঁটে ফেলবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ক্ষেতগুলি থেকে যে শস্য এমনি এমনি উৎপন্ন হয়েছে তা কাটবে না, অথবা আঝোড়া দ্রাক্ষাফল সংগ্রহ করবে না। ভূমির জন্য বিশ্রামের বছর রাখতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","বিশ্রাম বছর চলাকালীন ভূমির খাদ্যশস্য তোমাদের জন্য—তোমার নিজের, তোমার দাস-দাসী, বেতনজীবী কর্মী, তোমার মাঝে অস্থায়ীভাবে বসবাসকারী মানুষের জন্য ");
INSERT INTO benobcv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","এবং তোমার গৃহপালিত সমস্ত পশু ও তোমার দেশের বন্য পশুরাও এই খাদ্যশস্যের অংশীদার। ভূমিতে উৎপন্ন যাবতীয় খাদ্যশস্য ভোজন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘সাতটি বিশ্রাম বছর—সাতগুণ সাত বছর—গণনা করবে, যেন সাত বিশ্রাম বছরের মোট সংখ্যা উনপঞ্চাশ বছর হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","এরপর সপ্তম মাসের দশম দিনে সর্বত্র তূরী বাজাতে হবে; প্রায়শ্চিত্ত দিনে তোমার সারা দেশে তূরী বাজবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","পঞ্চাশতম বছর পবিত্র করবে ও সারা দেশে সব বসবাসকারীদের জন্য মুক্তি ঘোষণা করবে। তোমাদের পক্ষে এটি অর্ধশতবার্ষিক মহোৎসব হবে; তোমরা প্রত্যেকজন নিজের নিজের পারিবারিক অধিকারে ও গোষ্ঠীতে ফিরে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","পঞ্চাশতম বছরটি তোমাদের পক্ষে আনন্দ উৎসবের বছর হবে। এসময় কোনো বীজবপন করবে না, ভূমিতে আপনা-আপনি উৎপন্ন শস্যচয়ন অথবা আঝোড়া দ্রাক্ষাফল সংগ্রহ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","কেননা তখন মহোৎসবের সময়, যা তোমাদের জন্য পবিত্র হবে; কেবল ক্ষেতগুলি থেকে সরাসরি তুলে আনা ভক্ষ্য তোমরা ভোজন করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘এই অর্ধশতবার্ষিক অনুষ্ঠানে প্রত্যেকজনকে নিজের নিজের অধিকারে ফিরে আসতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘যদি তোমার কোনো দেশবাসীর কাছে তুমি জমি বিক্রি করো অথবা তার কাছ থেকে জমি কেনো, তাহলে পরস্পর সুযোগ নিও না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","অর্ধশতবর্ষের পরে বছর অতিবাহিত হওয়ার ভিত্তিতে তুমি দেশবাসীর নিকট থেকে কিনবে এবং শস্য সংগ্রহের জন্য অবশিষ্ট বছরগুলির ভিত্তিতে সে বিক্রি করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","বছর-সংখ্যার আধিক্য অনুসারে তুমি মূল্য বৃদ্ধি করবে ও বছর সংখ্যা কম হলে তুমি মূল্য কম করবে, কারণ আসলে সে তোমার কাছে ফলোৎপাদক সংখ্যা অনুসারে বিক্রি করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","তোমরা পরস্পর সুযোগ নিও না, কিন্তু ঈশ্বরকে ভয় কোরো। আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘আমার অনুশাসনের অনুগামী হও এবং আমার সব বিধান মেনে চলতে যত্নশীল থেকো, তাহলে তোমরা দেশে নিরাপদে বসবাস করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ভূমি ফল উৎপন্ন করবে এবং তৃপ্তি অবধি তোমরা ভোজন করবে ও তোমাদের নিরাপত্তা থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","তোমাদের প্রশ্ন থাকতে পারে, “সপ্তম বছরে আমরা কী ভোজন করব, যদি আমরা বীজবপন ও শস্য সংগ্রহ না করি?” ");
INSERT INTO benobcv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ষষ্ঠ বছরে আমি এমন আশীর্বাদ বর্ষণ করব যে তিন বছরের জন্য জমিতে প্রচুর ফসল উৎপন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","অষ্টম বছরে বীজ বপনকালের আগে সংগৃহীত ফসল থেকে তোমরা ভোজন করবে এবং নবম বছরে ফসল সংগৃহীত না হওয়া পর্যন্ত তোমরা পুরোনো খাদ্য ভোজন করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘চিরদিনের জন্য ভূমি বিক্রি করা যাবে না, কেননা ভূমি আমার এবং তোমরা প্রবাসী ও ভাড়াটিয়া ব্যতীত আর কিছু নও। ");
INSERT INTO benobcv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","সারা দেশে তোমরা যে ভূমির অধিকারী হয়েছ, তা মুক্ত করতে তোমরা অবশ্যই সুযোগ দিয়ো। ");
INSERT INTO benobcv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘যদি তোমার স্বদেশবাসীর মধ্যে কেউ দরিদ্র হয় এবং সে তার কিছু জমি বিক্রি করে, তাহলে তার নিকটতম আত্মীয় আসবে ও স্বদেশবাসীর বিক্রীত ভূমি মুক্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","অন্যদিকে, যদি এমন কেউ থাকে, যার ভূমির মুক্তিকর্তা কেউ নেই, কিন্তু সে নিজে সমৃদ্ধিশালী হয় এবং ভূমি মুক্ত করতে তার যথেষ্ট সঙ্গতি থাকে, ");
INSERT INTO benobcv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","তাহলে বিক্রি করার সময় থেকে পরবর্তী বছরগুলির জন্য সে মূল্য নির্ধারণ করবে ও বিক্রীত মূল্য ক্রেতাকে ফেরত দেবে; পরে সে নিজের অধিকারে ফিরে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","কিন্তু ক্রেতার পাওনা মেটাতে যদি তার সামর্থ্য না থাকে, তাহলে অর্ধশতবার্ষিক পর্যন্ত বিক্রীত সম্পদ ক্রেতার কাছে থাকবে। অর্ধশতবার্ষিকীর সময় তা ফিরিয়ে দেওয়া হবে এবং সে নিজের অধিকারে ফিরে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘যদি কোনো ব্যক্তি প্রাচীরবেষ্টিত নগরে তার বাড়ি বিক্রি করে তাহলে বিক্রি করার সময় থেকে সম্পূর্ণ এক বছর পর্যন্ত তার মুক্ত করার অধিকার থাকবে। ওই সময়ের মধ্যে বিক্রেতা মুক্ত করতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","যদি সম্পূর্ণ এক বছরের আগে তা মুক্ত করা না হয়, তাহলে প্রাচীরবেষ্টিত নগরের বাড়িটি চিরদিনের জন্য ক্রেতার ও তার বংশধরদের হয়ে যাবে। অর্ধশতবর্ষে এই সম্পত্তি ফেরত দেওয়া হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","কিন্তু প্রাচীরহীন গ্রামগুলিতে নির্মিত বাড়িগুলি দেশের সার্বিক সম্পত্তিরূপে বিবেচিত হবে। এগুলি মুক্ত করা যাবে এবং অর্ধশতবর্ষে ফেরত দেওয়া হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘লেবীয় অধ্যুষিত নগরগুলিতে নির্মিত লেবীয়দের বাড়িগুলি মুক্ত করতে লেবীয়দের সবসময় অধিকার থাকবে, যেগুলি তাদের অধিকৃত। ");
INSERT INTO benobcv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","সুতরাং লেবীয়দের সম্পত্তি মুক্তিযোগ্য অর্থাৎ যে কোনো নগরে তাদের অধিকৃত বাড়ি বিক্রীত হলে অর্ধশতবর্ষে তা ফেরত দিতে হবে, কারণ লেবীয়দের নগরগুলিতে নির্মিত বাড়িগুলি ইস্রায়েলীদের মাঝে লেবীয়দের সম্পত্তি। ");
INSERT INTO benobcv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","কিন্তু তাদের নগরগুলির চারণভূমি বিক্রি করা যাবে না; এটি তাদের চিরস্থায়ী অধিকার। ");
INSERT INTO benobcv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘যদি তোমাদের দেশবাসীর মধ্যে কেউ দরিদ্র ও তোমাদের মাঝে নিজের ভরণ-পোষণ চালাতে অসমর্থ হয়, তাহলে তাকে সাহায্য করো, যেমন তোমরা বিদেশি এবং অপরিচিতদের প্রতি করে থাকো; যেন তোমাদের মাঝে সে বসবাস করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","তার কাছ থেকে কোনোরকম সুদ অথবা সুবিধা গ্রহণ করবে না, কিন্তু তোমাদের ঈশ্বরকে ভয় করবে, যেন তোমাদের দেশবাসী তোমাদের মাঝে বসবাস করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","সুদ গ্রহণের শর্তে তুমি তাকে অর্থ ধার দিতে পারবে না, অথবা লাভের আশায় তার কাছে খাদ্য বিক্রি করবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","আমি তোমাদের ঈশ্বর সদাপ্রভু, যিনি মিশর দেশ থেকে তোমাদের বের করে এনেছেন, যেন কনান দেশ তোমাদের দেন ও তোমাদের ঈশ্বর হন। ");
INSERT INTO benobcv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘যদি তোমার দেশবাসীর মধ্যে কেউ দরিদ্র হয় ও তোমার কাছে নিজেকে বিক্রি করে, এক ক্রীতদাসরূপে তাকে কাজ করতে দিয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","এক বেতনজীবী কর্মী অথবা তোমার মাঝে এক অস্থায়ী বাসিন্দারূপে তার প্রতি আচরণ করতে হবে। অর্ধশত বছর পর্যন্ত তোমার জন্য সে কাজটি করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","পরে সে ও তার সন্তানেরা মুক্ত হবে এবং সে তার গোষ্ঠীতে ও তার পিতৃপুরুষদের অধিকারে ফিরে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","যেহেতু ইস্রায়েলীরা আমার ভৃত্য, আমি মিশর থেকে যাদের বের করেছিলাম; তারা কোনোমতে ক্রীতদাসরূপে বিক্রীত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","নির্দয়ভাবে তাদের শাসন করবে না, কিন্তু তোমাদের ঈশ্বরকে ভয় কোরো। ");
INSERT INTO benobcv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘তোমাদের ক্রীতদাস ও দাসীরা তোমাদের চারপাশের দেশ থেকে আসবে; তাদের মধ্যে থেকে তোমরা দাস ও দাসী কিনতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","তোমাদের মাঝে বসবাসকারী অস্থায়ী বাসিন্দাদের মধ্য থেকে কয়েকজনকে ও তোমাদের দেশে তাদের গোষ্ঠীজাত সদস্যদের তোমরা কিনতে পারো এবং তারা তোমাদের সম্পদ হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","তোমাদের সন্তানদের পক্ষে অধিকৃত সম্পদরূপে তোমরা তাদেরকে দিতে পারো এবং সারা জীবনের জন্য তাদের ক্রীতদাস করে রাখতে পারো, কিন্তু তোমাদের সঙ্গী ইস্রায়েলীদের ওপরে নির্দয়ভাবে শাসন করতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘তোমাদের মাঝে বসবাসকারী কোনো বিদেশি যদি ধনী হয় এবং তোমাদের কোনো একজন ইস্রায়েলী দেশবাসী দরিদ্র হয় ও সেই বিদেশির অথবা প্রবাসীগোষ্ঠীর কোনো এক সদস্যের কাছে নিজেকে বিক্রি করে, ");
INSERT INTO benobcv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","বিক্রীত হওয়ার পরে তার মুক্তিলাভের অধিকার থাকবে; তার কোনো এক আত্মীয় তাকে মুক্ত করতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","তার জ্যাঠা, কাকা অথবা জ্ঞাতিভাই বা বোন কিংবা তার গোষ্ঠীর রক্তের সম্পর্কযুক্ত কেউ তাকে মুক্ত করতে পারবে। অথবা যদি সে সম্পদশালী হয়, তাহলে নিজেই নিজেকে মুক্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","বিক্রি করার বছর থেকে পঞ্চাশ বছর পর্যন্ত সে ও তার ক্রেতা সময় গণনা করবে। বছরগুলির সংখ্যা সাপেক্ষে বেতনজীবী মানুষের প্রতি বেতন দেওয়ার হারের ভিত্তিতে তার মুক্তির মূল্য ধার্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","যদি অনেক বছর অবশিষ্ট থাকে, তাহলে ক্রয় মূল্য থেকে বেশিরভাগটাই সে নিজের মুক্তির জন্য অবশ্যই দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","যদি অর্ধশত বছর না আসা পর্যন্ত কেবল কয়েক বছর অবশিষ্ট থাকে, তাহলে সে তা গণনা করবে ও তদনুসারে নিজের মুক্তির জন্য মূল্য দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","বছরের পর বছর ধরে এক ভাড়া করা মানুষরূপে তার প্রতি আচরণ করা হবে; তুমি অবশ্যই নজর রাখবে, যেন তার মালিক তাকে নির্দয়ভাবে শাসন না করে। ");
INSERT INTO benobcv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘যদি এই উপায়গুলির কোনো উপায়ে সে মুক্তি না পায়, তাহলে সে ও তার সন্তানেরা পঞ্চাশতম বছরে মুক্ত হবে, ");
INSERT INTO benobcv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","কেননা ইস্রায়েলীরা দাসরূপে আমার অধিকার। ওরা আমার দাস-দাসী, আমি মিশর থেকে যাদের বের করে এনেছি। আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘তোমরা নিজেদের জন্য প্রতিমা নির্মাণ কোরো না, অথবা প্রতিমূর্তি কিংবা পবিত্র পাথর স্থাপন কোরো না এবং তোমাদের দেশে ক্ষোদিত পাথর রেখে তার সামনে প্রণিপাত কোরো না। আমি তোমাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘আমার বিশ্রামবার পালন কোরো ও আমার পবিত্র ধর্মধামের প্রতি সম্মান দেখাও। আমি তোমার ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘তোমরা যদি আমার বিধানগুলি অনুধাবন করো ও আমার সব আদেশ মেনে চলতে যত্নশীল থাকো, ");
INSERT INTO benobcv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","তাহলে আমি যথাসময়ে বৃষ্টি পাঠাব; ফলে ভূমি শস্য উৎপন্ন করবে ও ক্ষেতের গাছগুলিতে ফল ভরে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","দ্রাক্ষাচয়ন পর্যন্ত তোমাদের শস্যমর্দনের কাজ চলবে, এবং বীজবপনকাল পর্যন্ত দ্রাক্ষাচয়নের কাজ চলবে এবং তোমরা ইচ্ছামতো খাদ্য ভোজন করবে ও নিরাপদে তোমাদের দেশে বসবাস করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘দেশের প্রতি আমি শান্তি মঞ্জুর করব ও শয়নকালে কেউ তোমাদের ভয় দেখাবে না। আমি দেশ থেকে হিংস্র জন্তুদের তাড়িয়ে দেব ও তোমাদের দেশের মধ্য দিয়ে তরোয়াল যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","তোমরা শত্রুদের তাড়া করবে ও তোমাদের সামনে তারা তরোয়াল দ্বারা পতিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","তোমাদের পাঁচজন একশো জনের পিছনে ধাবমান হবে ও তোমাদের একশো জন 10,000 জনকে তাড়িয়ে নিয়ে যাবে এবং তোমাদের সামনে তোমাদের শত্রুরা তরোয়াল দ্বারা পতিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘তোমাদের প্রতি আমি সদয় দৃষ্টি রাখব, তোমাদের ফলবান রাখব, তোমাদের সংখ্যা বৃদ্ধি করব এবং তোমাদের সঙ্গে আমার অঙ্গীকার-চুক্তি রাখব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","বিগত বছরে সংগৃহীত শস্য থেকে তখনও তোমরা ভোজন করবে, যখন পুরোনো খাদ্যশস্য সরিয়ে রাখবে, যেন নতুন শস্য রাখার স্থান প্রস্তুত থাকে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","আমি তোমাদের মাঝে আমার আবাসস্থান রাখব এবং আমি তোমাদের ঘৃণা করব না। ");
INSERT INTO benobcv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","তোমাদের মাঝে আমি গমনাগমন করব, আমি তোমাদের ঈশ্বর হব এবং তোমরা আমার প্রজা হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","আমি তোমাদের ঈশ্বর সদাপ্রভু, যিনি মিশর থেকে তোমাদের বের করে এনেছেন, যেন তোমরা আর মিশরীয়দের ক্রীতদাস না হও; আমি তোমাদের জোয়ালের কাঠ ভেঙেছি ও মাথা উঁচু করে চলার যোগ্যতা তোমাদের দিয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘কিন্তু তোমরা যদি আমার কথা না শুনে এই সমস্ত আদেশ অমান্য করো ");
INSERT INTO benobcv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","এবং তোমরা যদি আমার সকল অনুশাসন অগ্রাহ্য করো, আমার বিধানগুলি ঘৃণা করো, আমার সমস্ত আদেশ পালনে ব্যর্থ হও এবং এইভাবে আমার অঙ্গীকার-চুক্তি লঙ্ঘন করো, ");
INSERT INTO benobcv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","তাহলে তোমাদের প্রতি আমার হস্তক্ষেপ এই ধরনের হবে, যথা: তোমাদের ওপরে আমি অকস্মাৎ প্রচণ্ড ভীতি আনব, মারাত্মক বিবিধ রোগ ও জ্বর পাঠাব করব, যেগুলির দাপটে তোমরা দৃষ্টিশক্তি হারাবে ও তোমাদের প্রাণনাশ হবে। তোমাদের বীজবপন বৃথা যাবে, কারণ তোমাদের শত্রুরা সমস্ত খাদ্য ভোজন করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","তোমাদের বিপক্ষে আমি বিমুখ হব, যেন তোমাদের শত্রুরা তোমাদের পরাস্ত করে; যারা তোমাদের ঘৃণা করে তারা তোমাদের উপরে কর্তৃত্ব করবে এবং তোমাদের পিছনে কেউ ধাবমান না হলেও তোমরা পলায়ন করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘এসবের পরেও যদি আমার কথায় তোমরা অবধান না করো, তাহলে তোমাদের পাপসমূহের কারণে আমি তোমাদের সাতগুণ বেশি শাস্তি দেব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","তোমাদের একগুঁয়ে গর্ব আমি ভেঙে দেব, ঊর্ধ্বস্থ আকাশ লোহার মতো ও নিম্নস্থ ভূমি পিতলের মতো করব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","তোমাদের শক্তি প্রয়োগ বৃথা যাবে, কারণ তোমাদের মাটি ফসল উৎপন্ন করবে না, এমনকি দেশের গাছগুলিও ফল ফলাবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘যদি আমার প্রতি তোমরা বৈরীভাবাপন্ন থাকো ও আমার কথা শুনতে না চাও, তাহলে তোমাদের ক্লেশ আমি সাতগুণ বৃদ্ধি করব, যা পাপের কারণে তোমাদের প্রাপ্য। ");
INSERT INTO benobcv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","তোমাদের বিপক্ষে আমি বন্যপশু প্রেরণ করব; ওরা তোমাদের সন্তানদের হরণ করবে, তোমাদের গবাদি পশু বিনষ্ট করবে ও তোমাদের সংখ্যা এত হ্রাস করবে যে তোমাদের সমস্ত পথঘাট জনশূন্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘এত বেশি ক্ষতি হওয়া সত্ত্বেও যদি তোমরা সংশোধিত না হও এবং আমার প্রতি বৈরিতা চালিয়ে যাও, ");
INSERT INTO benobcv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","তাহলে তোমাদের প্রতি আমি শত্রুতা করব ও তোমাদের পাপের কারণে সাতগুণ ক্লেশ বৃদ্ধি করব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","তোমাদের বিপক্ষে তরোয়াল পাঠিয়ে আমি অঙ্গীকার-চুক্তি ভঙ্গের প্রতিশোধ নেব। তোমরা যখন নিজের নিজের নগরে ফিরে যাবে, তোমাদের মাঝে আমি মহামারি পাঠাব এবং শত্রুদের হাতে তোমাদের অর্পণ করব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","যখন আমি তোমাদের ভক্ষ্য রুটির জোগান ছিন্ন করব, একটি উনুনে দশজন মহিলা তোমাদের জন্য রুটি তৈরি করতে পারবে এবং নির্দিষ্ট পরিমাণ ওজনের রুটি তারা তোমাদের দেবে। তোমরা ভোজন করবে, কিন্তু তৃপ্ত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘উদরপূর্তি ও তৃপ্তি না হওয়া সত্ত্বেও যদি তোমরা আমার কথা শ্রবণ না করো কিন্তু আমার বিরোধিতা করতেই থাকো, ");
INSERT INTO benobcv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","তাহলে আমি ক্রুদ্ধ হয়ে তোমাদের বিরোধিতা করব এবং তোমাদের পাপের কারণে সাতগুণ বেশি শাস্তি আমি তোমাদের দেব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","তোমরা নিজের নিজের ছেলেদের ও মেয়েদের মাংস ভক্ষণ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","তোমাদের সমস্ত উচ্চস্থলী আমি বিনষ্ট করব, তোমাদের ধূপবেদিগুলি উচ্ছেদ করব, তোমাদের প্রতিমাগুলির নিষ্প্রাণ আকৃতির উপরে তোমাদের মৃতদেহ রাখব ও তোমাদের ঘৃণা করব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","তোমাদের নগরগুলিকে আমি ধ্বংসাবশেষে পরিণত করব, তোমাদের ধর্মধামগুলি ধ্বংস করব এবং তোমাদের সুরভিযুক্ত সন্তোষজনক উপহারে আমি মোটেই পরিতৃপ্ত হব না। ");
INSERT INTO benobcv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","তোমাদের দেশ আমি ধ্বংস করব, যেন তোমাদের শত্রুরা যারা সেখানে বসবাস করে তারা অত্যন্ত ভীত হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","জাতিদের মাঝে আমি তোমাদের ছড়িয়ে-ছিটিয়ে রাখব, আমার তরোয়াল নিষ্কোষ করব এবং তোমাদের পিছনে ধাবমান হব। তোমাদের দেশ উৎসন্ন হবে ও তোমাদের নগরগুলি ধ্বংসস্থান হয়ে থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ফলে যতদিন দেশ ধ্বংসস্থান হয়ে থাকবে ও তোমরা তোমাদের শত্রুদের দেশে বসবাস করবে, ততদিন পর্যন্ত দেশ বিশ্রামের বছরগুলি উপভোগ করবে; পরে দেশ বিশ্রাম পাবে ও বিশ্রামবারগুলি উপভোগ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","যতকাল দেশ পরিত্যক্ত থাকবে, দেশ বিশ্রাম পাবে, যদিও দেশে তোমাদের থাকাকালীন দেশ বিশ্রামবারগুলিতে বিশ্রাম পায়নি। ");
INSERT INTO benobcv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘তোমাদের মধ্যে যারা অবশিষ্ট থাকবে, শত্রুদের দেশে তাদের হৃদয় এত ভয়ে ভরিয়ে দেব যে হাওয়াতে পাতা ওড়ার শব্দ শুনে তারা পালাতে চাইবে। তাদের দৌড় দেখে মনে হবে যেন কেউ তরোয়াল নিয়ে তাদের তাড়া করছে এবং তারা পতিত হবে, যদিও কেউ তাদের তাড়া করেনি। ");
INSERT INTO benobcv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","কেউ তাড়া না করলেও তরোয়াল থেকে বাঁচবার তাগিদে তারা একজন অন্যজনের উপরে পতিত হবে। সুতরাং তোমাদের শত্রুদের সামনে তোমরা দাঁড়াতে পারবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","জাতিদের মাঝে তোমরা বিনষ্ট হবে; তোমাদের শত্রুদের দেশ তোমাদের গ্রাস করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","যারা অবশিষ্ট থাকবে, তারা তাদের অসংখ্য পাপের কারণে শত্রুদের দেশে বিনষ্ট হবে; তাদের পূর্বপুরুষদের পাপের কারণেও তাদের ধ্বংস অনিবার্য। ");
INSERT INTO benobcv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘কিন্তু তারা যদি তাদের পাপ ও তাদের পূর্বপুরুষদের পাপস্বীকার করে, এই স্বীকারোক্তিতে যদি আমার বিপক্ষে তাদের বিশ্বাসঘাতকতা ও আমার প্রতি তাদের শত্রুতার উল্লেখ থাকে, ");
INSERT INTO benobcv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","যা তাদের প্রতি আমাকে বৈরীভাবাপন্ন করেছিল, যার প্রেরণায় শত্রুদের দেশে তাদের আমি পাঠালাম, এর ফলে যখন তাদের সুন্নত করা হৃদয়গুলি অবনত হয় ও তাদের পাপের কারণে তারা মূল্য দেয়, ");
INSERT INTO benobcv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","যাকোবের সঙ্গে আমার অঙ্গীকার-চুক্তি, ইস্‌হাকের সঙ্গে আমার অঙ্গীকার-চুক্তি ও অব্রাহামের সঙ্গে আমার অঙ্গীকার-চুক্তি আমি স্মরণ করব এবং আমি দেশকে স্মরণ করব। ");
INSERT INTO benobcv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","কেননা তাদের দ্বারা দেশ পরিত্যাক্ত হবে এবং তাদের বিহনে জনশূন্য জায়গায় দেশ বিশ্রামবারগুলি উপভোগ করবে। তাদের পাপের কারণে তারা ক্ষতিপূরণ দেবে, কারণ আমার বিধানগুলি তারা অগ্রাহ্য করেছে ও আমার অনুশাসনগুলি ঘৃণা করেছে। ");
INSERT INTO benobcv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","আমার প্রতি অবমাননা করা সত্ত্বেও যখন শত্রুদের দেশে তারা থাকবে, আমি তাদের অগ্রাহ্য অথবা ঘৃণা করব না; এবং পুরোপুরিভাবে তাদের বিনষ্ট করব না, তাদের সঙ্গে আমার অঙ্গীকার-চুক্তি ভঙ্গ করব না। আমি তাদের ঈশ্বর সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","কিন্তু তাদের পক্ষে তাদের পূর্বপুরুষদের সঙ্গে আমার অঙ্গীকার-চুক্তি আমি স্মরণ করব, মিশর থেকে সর্বজাতির গোচরে আমি যাদের বের করে আনলাম, যেন তাদের ঈশ্বর হতে পারি। আমি সদাপ্রভু।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","এসব আদেশ, অনুশাসন ও নিয়মাবলি সদাপ্রভু সীনয় পর্বতে মোশির মাধ্যমে তাঁর ও ইস্রায়েলীদের মধ্যে প্রতিষ্ঠা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ইস্রায়েলীদের সঙ্গে তুমি কথা বলো ও তাদের জানিয়ে দাও: ‘যদি কেউ সদাপ্রভুর উদ্দেশে কোনো একজনকে উৎসর্গ করবার জন্য সমতুল্য মূল্য দিয়ে এক বিশেষ মানত করে, ");
INSERT INTO benobcv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","তাহলে কুড়ি থেকে ষাট বছরের মধ্যে বয়স্ক কোনো এক পুরুষের মূল্য হিসেবে সে পঞ্চাশ শেকল রুপো ধার্য করবে, যা পবিত্রস্থানের শেকল অনুসারে হবে, ");
INSERT INTO benobcv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","একজন নারীর ক্ষেত্রে তাকে ত্রিশ শেকল মূল্য ধার্য করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","যদি পাঁচ থেকে কুড়ি বছরের মধ্যে বয়স্ক কোনো এক ব্যক্তিকে উৎসর্গ করতে হয়, তাহলে পুরুষের ক্ষেত্রে কুড়ি শেকল এবং নারীর ক্ষেত্রে দশ শেকল ধার্য করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","যদি এক মাস ও পাঁচ বছরের মধ্যে যে কোনো বয়সি কেউ থাকে, তাহলে পুরুষের ক্ষেত্রে পাঁচ শেকল রুপো ও নারীর ক্ষেত্রে তিন শেকল রুপো ধার্য করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","যদি কারও বয়স ষাট অথবা তদূর্ধ্ব হয়, তাহলে পুরুষের ক্ষেত্রে পনেরো শেকল ও নারীর ক্ষেত্রে দশ শেকল ধার্য করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","যদি কেউ মানত করে, অথচ অত্যন্ত দরিদ্রতার কারণে নির্দিষ্ট পরিমাণ মূল্য দিতে অসমর্থ হয়, তাহলে সেই নির্দিষ্ট ব্যক্তিকে যাজকের কাছে আনা হবে এবং মানতকারীর সামর্থ্য অনুযায়ী সেই ব্যক্তির পক্ষে যাজক মূল্য নির্ধারণ করবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘একটি পশু দিয়ে যদি সে মানত করে, সদাপ্রভুর উদ্দেশে এক উপহাররূপে সেই মানত গ্রহণযোগ্য। সদাপ্রভুর উদ্দেশে দত্ত এমন এক পশু পবিত্র হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","সে যেন পরিবর্তন না করে, অথবা বিকল্পরূপে মন্দের স্থানে ভালো কিংবা ভালোর স্থানে মন্দ পশু জোগান না দেয়। যদি সে একটিরও পক্ষে অন্য পশু বিকল্পরূপে দেয়, তাহলে বিকল্প দুটিই পবিত্র হয়। ");
INSERT INTO benobcv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","যদি তার মানত করা পশু আনুষ্ঠানিকভাবে অশুচি হয়, যদি তা সদাপ্রভুর উদ্দেশে এক উপহাররূপে গ্রহণযোগ্য না হয়, তাহলে ওই পশুকে অবশ্যই যাজকের কাছে নিয়ে যেতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","পশুটি ভালো অথবা মন্দ, সে বিষয়ের গুণাগুণ যাজক বিচার করবে। পরে যাজক দ্বারা নিরূপিত মূল্য অনুযায়ী পশুর মূল্য নির্ধারিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","পশুর মালিক যদি পশুকে মুক্ত করতে চায়, নিরূপিত মূল্যের পঞ্চমাংশ সে অবশ্যই অতিরিক্ত দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘যদি কোনো পুরুষ পবিত্র বস্তুরূপে তার বাড়ি সদাপ্রভুর উদ্দেশে উৎসর্গ করে তাহলে ভালো অথবা মন্দ বাড়িটির গুণাগুণ যাজক বিচার করবে; যাজক দ্বারা নির্ধারিত মূল্য মেনে নেওয়া হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","যদি উৎসর্গকারী তার বাড়ি মুক্ত করে, তাহলে নিরূপিত মূল্যের অতিরিক্ত পঞ্চমাংশ সে অবশ্যই দেবে। বাড়িটি পুনরায় তার হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘যদি কোনো পুরুষ তার অধিকৃত ক্ষেতের অংশবিশেষ সদাপ্রভুর উদ্দেশে উৎসর্গ করে, সেই ক্ষেতে বপনীয় বীজের পরিমাণানুসারে ক্ষেতটির মূল্য নিরূপিত হবে—এক হোমর যবের বীজের জন্য পঞ্চাশ শেকল রুপো। ");
INSERT INTO benobcv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","অর্ধশত বছর চলাকালীন যদি সে তার ক্ষেত উৎসর্গ করে, তাহলে ক্ষেতটির নিরূপিত মূল্য অপরিবর্তিত থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","কিন্তু যদি অর্ধশতবার্ষিকীর পরে সে তার ক্ষেত উৎসর্গ করে, পরবর্তী অর্ধশতবার্ষিকী না আসা পর্যন্ত বছরগুলির সংখ্যা অনুযায়ী যাজক মূল্য নির্ধারণ করবে এবং নির্ধারিত মূল্য হ্রাস পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","উৎসর্গকারী যদি তার ক্ষেত মুক্ত করতে চায়, ক্ষেতটির মূল্যের অতিরিক্ত পঞ্চমাংশ সে অবশ্যই দেবে এবং ক্ষেতটি আবার তার হয়ে যাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","অন্যদিকে, যদি সে তার ক্ষেত মুক্ত না করে, অথবা অন্য কারও কাছে ক্ষেতটি বিক্রি করে, তাহলে তা কখনও মুক্ত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","অর্ধশতবার্ষিকীতে ক্ষেত মুক্ত হলে তা হবে পবিত্র, যেন সদাপ্রভুর উদ্দেশে বিকশিত এক ক্ষেত; এটি হবে যাজকদের সম্পত্তি। ");
INSERT INTO benobcv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘যদি কোনো এক পুরুষ তার কেনা একটি ক্ষেত সদাপ্রভুর উদ্দেশে উৎসর্গ করে, যা তার পৈতৃক ভূমির অংশ নয়, ");
INSERT INTO benobcv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","অর্ধশত বছর পর্যন্ত যাজক সেই ক্ষেতটির মূল্য নির্ধারণ করবে এবং সেই মালিককে তার মূল্য সেদিন দিতে হবে যা সদাপ্রভুর উদ্দেশে পবিত্র বলে বিবেচিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","পঞ্চাশতম বছরে ক্ষেতটি পূর্ব অধিকারে যাবে, যার নিকট থেকে সে ক্ষেতটি কিনেছিল অর্থাৎ পূর্বাধিকারী সেই ক্ষেত পাবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","পবিত্রস্থানের শেকল অনুযায়ী প্রত্যেক বিষয়ের মূল্য নিরূপিত হবে, প্রতি শেকলে কুড়ি গেরা। ");
INSERT INTO benobcv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘অন্যদিকে, প্রথমজাত কোনো পশুকে কেউ উৎসর্গ করতে পারবে না, যেহেতু প্রথমজাত সদাপ্রভুর অধিকার; ষাঁড় অথবা মেষ যা জন্মাবে, তা প্রভুর। ");
INSERT INTO benobcv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","যদি তা এক অশুচি পশু হয়, তাহলে নিরূপিত মূল্যে সে আবার প্রথমজাতকে কিনবে, এর মূল্যের অতিরিক্ত পঞ্চমাংশ সে দেবে। যদি পশুটিকে সে মুক্ত না করে, তাহলে নিরূপিত মূল্যে ওই পশুকে বিক্রি করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘কিন্তু কোনো ব্যক্তি নিজের সর্বস্ব থেকে—মানুষ কিংবা পশু কিংবা পৈতৃক সম্পত্তি—সদাপ্রভুর উদ্দেশে উৎসর্গীকৃত করে; তা বিক্রি বা মুক্ত করা যাবে না; সদাপ্রভুর উদ্দেশে নিবেদিত সবকিছুই অতি পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘ধ্বংসাত্মক কর্মে লিপ্ত কোনো বর্জিত ব্যক্তির বন্দিত্বমোচন হবে না; তাকে মৃত্যুদণ্ড পেতেই হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘ভূমি থেকে উৎপন্ন সবকিছুর দশমাংশ মাটি থেকে উৎপন্ন খাদ্যশস্য অথবা গাছের ফল, সমস্তই সদাপ্রভুর। উৎপাদিত সবকিছু সদাপ্রভুর উদ্দেশে পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","যদি কোনো পুরুষ তার দশমাংশের কিছুটা মুক্ত করে, তাহলে দশমাংশ মূল্যের অতিরিক্ত পঞ্চমাংশ সে অবশ্যই দেবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","গরু ও মেষের সম্পূর্ণ দশমাংশ মেষপালকের চরাণী পাওয়া প্রত্যেক দশটি পশু সদাপ্রভুর উদ্দেশে পবিত্র হবে। ");
INSERT INTO benobcv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","সে মন্দ পশুদের মধ্য থেকে ভালো পশু বেছে নেবে না, অথবা বিকল্প বিধান নেবে না। যদি সে বিকল্প উপায় গ্রহণ করে, তাহলে পশু ও তাদের বিকল্প উভয়ই পবিত্র হবে এবং তাদের মুক্ত করা যাবে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","সদাপ্রভুর এই আদেশগুলি ইস্রায়েলীদের জন্য সীনয় পর্বতে মোশিকে দেওয়া হল।");
INSERT INTO benobcv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ইস্রায়েলীরা মিশর থেকে বের হয়ে আসার পর দ্বিতীয় বছরের, দ্বিতীয় মাসের, প্রথম দিনে, সদাপ্রভু সীনয় মরুভূমিতে সমাগম তাঁবুর মধ্যে মোশির সঙ্গে কথা বললেন। তিনি বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“গোষ্ঠী এবং পরিবার অনুযায়ী, সমস্ত ইস্রায়েলী সম্প্রদায়ের জনগণনা করো। প্রত্যেক ব্যক্তির নাম, এক এক করে তালিকাভুক্ত করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ইস্রায়েলের সমস্ত পুরুষ কুড়ি বছর বা তারও বেশি বয়স্ক ব্যক্তিদের, যারা সেনাদলে কাজ করতে সক্ষম, তুমি ও হারোণ, শ্রেণিবিভাগ অনুসারে তাদের গণনা করো। ");
INSERT INTO benobcv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","প্রত্যেক গোষ্ঠীর মধ্যে একজন ব্যক্তি, যে তাদের কুলের পুরোধা, সে তোমাদের সাহায্য করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“যে সমস্ত ব্যক্তি তোমাদের সহকারী হবে, তাদের নাম হল: “রূবেণ থেকে শদেয়ূরের ছেলে ইলীষূর; ");
INSERT INTO benobcv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","শিমিয়োন থেকে সূরীশদ্দয়ের ছেলে শলুমীয়েল; ");
INSERT INTO benobcv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","যিহূদা থেকে অম্মীনাদবের ছেলে নহশোন; ");
INSERT INTO benobcv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ইষাখর থেকে সূয়ারের ছেলে নথনেল; ");
INSERT INTO benobcv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","সবূলূন থেকে হেলোনের ছেলে ইলীয়াব; ");
INSERT INTO benobcv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","যোষেফের ছেলেদের মধ্য থেকে, ইফ্রয়িম থেকে, অম্মীহূদের ছেলে ইলীশামা, মনঃশি থেকে পদাহসূরের ছেলে গমলীয়েল; ");
INSERT INTO benobcv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","বিন্যামীন থেকে গিদিয়োনির ছেলে অবীদান; ");
INSERT INTO benobcv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","দান থেকে অম্মীশদ্দয়ের ছেলে অহীয়েষর; ");
INSERT INTO benobcv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","আশের থেকে অক্রণের ছেলে পগীয়েল; ");
INSERT INTO benobcv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","গাদ থেকে দ্যূয়েলের ছেলে ইলীয়াসফ; ");
INSERT INTO benobcv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","নপ্তালি থেকে ঐননের ছেলে অহীরঃ।” ");
INSERT INTO benobcv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","সমাজের মধ্য থেকে এই ব্যক্তিদের নিযুক্ত করা হল। তারা নিজের নিজের গোষ্ঠীর নেতা ছিলেন। ইস্রায়েলী গোষ্ঠীসমূহের তারা শীর্ষস্থানীয় ব্যক্তি ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","যাদের নাম দেওয়া হয়েছিল, মোশি ও হারোণ সেই ব্যক্তিদের নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","দ্বিতীয় মাসের প্রথম দিনে, তাঁরা সমস্ত সমাজকে একত্র হওয়ার আহ্বান দিলেন। জনতার পৈতৃক কুল তাদের গোষ্ঠী ও পরিবার অনুযায়ী সূচিত হচ্ছিল, যাদের বয়স কুড়ি বা তারও বেশি, সেই সমস্ত পুরুষ ব্যক্তিরই নাম এক একজন করে তালিকাভুক্ত করা হয়েছিল, ");
INSERT INTO benobcv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","যে রকম সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। তিনি সীনয় মরুভূমিতেই তাদের গণনা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ইস্রায়েলের বড়ো ছেলে রূবেণের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","রূবেণ গোষ্ঠীর জনসংখ্যা ছিল 46,500। ");
INSERT INTO benobcv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","শিমিয়োনের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী ও পরিবারের নথি অনুসারে, এক একজন গণিত ও নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","শিমিয়োন গোষ্ঠীর জনসংখ্যা ছিল 59,300। ");
INSERT INTO benobcv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","গাদের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী ও পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","গাদ গোষ্ঠীর জনসংখ্যা ছিল 45,650। ");
INSERT INTO benobcv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","যিহূদার উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী ও পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","যিহূদা গোষ্ঠীর জনসংখ্যা ছিল 74,600। ");
INSERT INTO benobcv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ইষাখরের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ইষাখর গোষ্ঠীর জনসংখ্যা ছিল 54,400। ");
INSERT INTO benobcv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","সবূলূনের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","সবূলূন গোষ্ঠীর জনসংখ্যা ছিল 57,400। ");
INSERT INTO benobcv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","যোষেফের সন্তানদের মধ্য থেকে, ইফ্রয়িমের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ইফ্রয়িম গোষ্ঠীর জনসংখ্যা ছিল 40,500। ");
INSERT INTO benobcv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","মনঃশির উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","মনঃশি গোষ্ঠীর জনসংখ্যা ছিল 32,200। ");
INSERT INTO benobcv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","বিন্যামীনের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে, এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","বিন্যামীন গোষ্ঠীর জনসংখ্যা ছিল 35,400। ");
INSERT INTO benobcv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","দানের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","দান গোষ্ঠীর জনসংখ্যা ছিল 62,700। ");
INSERT INTO benobcv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","আশেরের উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","আশের গোষ্ঠীর জনসংখ্যা ছিল 41,500। ");
INSERT INTO benobcv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","নপ্তালির উত্তরসূরিদের মধ্য থেকে, সমস্ত পুরুষ যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা সেনাদলে কাজ করতে সক্ষম, তাদের গোষ্ঠী এবং পরিবারের নথি অনুসারে এক একজনের নাম তালিকাভুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","নপ্তালি গোষ্ঠীর জনসংখ্যা ছিল 53,400। ");
INSERT INTO benobcv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","মোশি ও হারোণ এবং নিজের নিজের গোষ্ঠীর প্রতিনিধিস্বরূপ ইস্রায়েলের বারোজন নেতা, এই ব্যক্তিদের গণনা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","সমস্ত ইস্রায়েলী, যাদের বয়স কুড়ি বছর এবং তারও বেশি, যারা ইস্রায়েলী সেনাবাহিনীতে কাজ করতে সক্ষম ছিল তাদের নিজের নিজের গোষ্ঠী অনুসারে গণিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","এই সমগ্র জনগোষ্ঠীর সংখ্যা ছিল 6,03,550 জন। ");
INSERT INTO benobcv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","লেবীয় গোষ্ঠীভুক্ত পরিবারগুলি অন্যদের সঙ্গে গণিত হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","সদাপ্রভু মোশিকে বলেছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“তুমি অবশ্যই লেবির গোষ্ঠীকে গণনা করবে না অথবা অন্যান্য ইস্রায়েলীদের সঙ্গে তাদের সংখ্যা যুক্ত করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","তার পরিবর্তে, লেবীয়দের নিয়োগ করবে, যেন তারা সাক্ষ্যস্বরূপ উপাসনা-তাঁবু, তার আসবাব এবং তার মধ্যবর্তী সমস্ত দ্রব্যের তত্ত্বাবধায়ক হয়। তারা উপাসনা-তাঁবু ও তার সমস্ত দ্রব্য বহন করবে; তারা তার তত্ত্বাবধান করবে এবং তার চতুর্দিকে ছাউনি স্থাপন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","যখনই উপাসনা-তাঁবুর স্থানান্তরের প্রয়োজন হবে, লেবীয়েরা তা খুলে ফেলবে। যখন উপাসনা-তাঁবু স্থাপন করতে হবে, লেবীয়েরাই তা করবে। অন্য যে কেউ তার নিকটবর্তী হয়, তাকে বধ করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ইস্রায়েলীরা তাদের নিজের তাঁবু, শ্রেণী অনুসারে প্রত্যেকজন তার নিজস্ব ছাউনিতে, নিজেরাই পতাকার তলায় স্থাপন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","কিন্তু লেবীয়েরা, সাক্ষ্যস্বরূপ উপাসনা-তাঁবুর চারিদিকে তাদের ছাউনি স্থাপন করবে যেন আমার ক্রোধ ইস্রায়েলী সমাজের উপরে না বর্তায়। লেবীয়েরাই সাক্ষ্যস্বরূপ উপাসনা-তাঁবুর তত্ত্বাবধানের জন্য দায়ী হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ইস্রায়েলীরা এই সমস্তই সঠিক করেছিল, যে রকম সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ইস্রায়েলের প্রত্যেক ব্যক্তি, নিজের নিজের পিতৃকুলের চিহ্নের সঙ্গে দলীয় পতাকার সঙ্গে কিছুটা দূরত্ব রেখে, সমাগম তাঁবুর চতুর্দিকে ছাউনি করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","পূর্বদিকে, সূর্যোদয় অভিমুখে: যিহূদার শিবিরের সেনাদল তাদের পতাকার তলায় সন্নিবেশিত হবে। অম্মীনাদবের ছেলে নহশোন যিহূদা জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","তার বিভাগীয় সেনাদের সংখ্যা 74,600। ");
INSERT INTO benobcv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","তার পরবর্তী ছাউনি হবে ইষাখর গোষ্ঠীর। সূয়ারের ছেলে নথনেল ইষাখর জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","তার বিভাগীয় সেনাদের সংখ্যা 54,400। ");
INSERT INTO benobcv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","তার পরবর্তী ছাউনি হবে সবূলূন গোষ্ঠীর। হেলোনের ছেলে ইলীয়াব সবূলূন জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","তার বিভাগীয় সেনাদের সংখ্যা 57,400। ");
INSERT INTO benobcv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","সমস্ত বিভাগীয় সেনাদল অনুসারে যিহূদা শিবিরের জন্য নির্দিষ্ট পুরুষের সংখ্যা 1,86,400 জন। প্রথমে তারা যাত্রা শুরু করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","দক্ষিণপ্রান্তে: রূবেণের শিবিরের সেনাদল তাদের পতাকার তলায় সন্নিবেশিত হবে। শদেয়ূরের ছেলে ইলীষূর রূবেণ জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","তার বিভাগীয় সেনাদের সংখ্যা 46,500। ");
INSERT INTO benobcv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","শিমিয়োনের গোষ্ঠী তাদের পাশে ছাউনি স্থাপন করবে। সূরীশদ্দয়ের ছেলে শলুমীয়েল শিমিয়োন জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","তার বিভাগীয় সেনাদের সংখ্যা 59,300। ");
INSERT INTO benobcv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","তার পাশের ছাউনি হবে গাদের। দ্যূয়েলের ছেলে ইলীয়াসফ গাদ জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","তার বিভাগীয় সেনাদের সংখ্যা 45,650। ");
INSERT INTO benobcv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","রূবেণের শিবিরের জন্য নির্দিষ্ট তাদের বিভাগীয় সেনাদের অনুসারে, সমস্ত পুরুষের সংখ্যা 1,51,450। দ্বিতীয় স্থানে তারা যাত্রা শুরু করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","তারপর শিবির সমূহের মধ্যস্থানে, সমাগম তাঁবু এবং লেবীয়দের ছাউনি যাত্রা শুরু করবে। তারা যে রকম ছাউনি স্থাপন করে, সেইরকম অভিন্ন ক্রম অনুসারে যাত্রা করবে, প্রত্যেকজন দলীয় পতাকার কাছে, তাদের নির্দিষ্ট স্থানে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","পশ্চিম প্রান্তে: ইফ্রয়িম শিবিরের সেনাদল তাদের পতাকার তলায় অবস্থান করবে। অম্মীহূদের ছেলে ইলীশামা ইফ্রয়িম জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","তার বিভাগীয় সেনাদের সংখ্যা 40,500। ");
INSERT INTO benobcv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","তাদের পরবর্তী ছাউনি হবে মনঃশি গোষ্ঠীর। পদাহসূরের ছেলে গমলীয়েল, মনঃশি জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","তার বিভাগীয় সেনাদের সংখ্যা 32,200। ");
INSERT INTO benobcv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","বিন্যামীন গোষ্ঠীর ছাউনি হবে তাদের পরে। গিদিয়োনির ছেলে অবীদান বিন্যামীন জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","তার বিভাগীয় সেনাদের সংখ্যা 35,400। ");
INSERT INTO benobcv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ইফ্রয়িমের শিবিরের জন্য নির্দিষ্ট, তাদের সেনাদল অনুসারে পুরুষের সংখ্যা 1,08,100। তারা তৃতীয় স্থানে যাত্রা শুরু করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","উত্তর প্রান্তে: দানের শিবিরের সেনাদল তাদের পতাকার তলায় সন্নিবেশিত হবে। অম্মীশদ্দয়ের ছেলে অহীয়েষর দান জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","তার বিভাগীয় সেনাদের সংখ্যা 62,700। ");
INSERT INTO benobcv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","তার পরবর্তী ছাউনি হবে আশের গোষ্ঠীর। অক্রণের ছেলে পগীয়েল আশের জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","তার বিভাগীয় সেনাদের সংখ্যা 41,500। ");
INSERT INTO benobcv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","তারপরে অবস্থান হবে নপ্তালি গোষ্ঠীর। ঐননের ছেলে অহীরঃ নপ্তালি জনগোষ্ঠীর নেতা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","তার বিভাগীয় সেনাদের সংখ্যা 53,400। ");
INSERT INTO benobcv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","দানের শিবিরের জন্য নির্দিষ্ট সমস্ত পুরুষের সংখ্যা 1,57,600 জন। তাদের পতাকা সমেত তারা সবশেষে যাত্রা করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","এরাই ইস্রায়েলী জনগোষ্ঠী, তাদের পিতৃকুল অনুসারে গণিত। শিবির সমূহে, তাদের বিভাগ অনুসারে গণিত সর্বমোট জনসংখ্যা 6,03,550 জন। ");
INSERT INTO benobcv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","কিন্তু এদের মধ্যে অন্য ইস্রায়েলীদের সঙ্গে লেবীয়েরা গণিত হয়নি, যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","সদাপ্রভু মোশিকে যেমন আদেশ দিয়েছিলেন, এইভাবে ইস্রায়েলীরা সে সমস্তই করেছিল; তারা সেইভাবে তাদের পতাকাতলে সন্নিবেশিত প্রত্যেক ব্যক্তি তার গোষ্ঠী এবং পিতৃকুল অনুসারে সেইভাবে যাত্রা করত। ");
INSERT INTO benobcv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","সদাপ্রভু যে সময়ে সীনয় পর্বতে মোশির সঙ্গে কথোপকথন করছিলেন, সেই সময় হারোণ ও মোশির বংশবৃত্তান্ত ছিল এইরকম। ");
INSERT INTO benobcv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","হারোণের ছেলেদের নাম হল, প্রথমজাত নাদব, তারপর অবীহূ, ইলীয়াসর ও ঈথামর। ");
INSERT INTO benobcv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","হারোণের ছেলেদের নাম এই। তারা অভিষিক্ত যাজক ছিলেন। যাজকীয় কাজের জন্য তাদের নিযুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","কিন্তু, নাদব ও অবীহূ সদাপ্রভুর সামনে নিহত হয়েছিল, যখন তারা সীনয় মরুভূমিতে তাঁর উদ্দেশে অননুমোদিত অগ্নি নিবেদন করেছিল। তাদের কোনো পুত্রসন্তান ছিল না। তাই তাদের বাবা হারোণের জীবদ্দশায় শুধুমাত্র ইলীয়াসর ও ঈথামর যাজক হিসেবে পরিচর্যা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“লেবি গোষ্ঠীকে নিয়ে এসো ও যাজক হারোণকে সাহায্য করার জন্য তাদের তার কাছে উপস্থিত করো। ");
INSERT INTO benobcv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","তারা সমাগম তাঁবুতে, উপাসনা-তাঁবু সংক্রান্ত কাজ দ্বারা তার এবং সমস্ত সম্প্রদায়ের জন্য নিরূপিত কর্তব্য করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","তারা সমাগম তাঁবুর সমস্ত আসবাবপত্রের তত্ত্বাবধান করবে ও উপাসনা সম্পর্কিত কাজের মাধ্যমে ইস্রায়েলীদের বাধ্যবাধকতা সম্পূর্ণ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","হারোণ ও তার ছেলেদের হাতে লেবীয়দের সমর্পণ করো; ইস্রায়েলীদের মধ্যে তারাই সম্পূর্ণরূপে তার কাছে দত্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","হারোণ ও তার ছেলেদের যাজক হিসেবে পরিচর্যার জন্য নিযুক্ত করো। অন্য কোনো ব্যক্তি পবিত্রস্থানের নিকটবর্তী হলে অবশ্যই তার প্রাণদণ্ড হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","সদাপ্রভু মোশিকে আরও বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“প্রত্যেক ইস্রায়েলী মহিলার প্রথমজাত পুরুষ শিশুর পরিবর্তে আমি লেবি গোষ্ঠীকে গ্রহণ করেছি। লেবীয় গোষ্ঠী আমারই, ");
INSERT INTO benobcv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","যেহেতু সমস্ত জ্যেষ্ঠ সন্তানেরা আমার। যখন মিশরে আমি সমস্ত প্রথমজাতকে আঘাত করি, তখন ইস্রায়েলীদের মধ্য থেকে আমি পশু হোক অথবা মানুষ, প্রত্যেক প্রথমজাত প্রাণীকে নিজের জন্য স্বতন্ত্র করে রাখি। তারা আমারই হবে। আমিই সদাপ্রভু।” ");
INSERT INTO benobcv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","সদাপ্রভু মোশিকে সীনয় মরুভূমিতে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“বংশ এবং গোষ্ঠী অনুসারে লেবীয়দের গণনা করো। এক মাস বা তারও বেশি বয়সি প্রত্যেক পুরুষের সংখ্যা গ্রহণ করো।” ");
INSERT INTO benobcv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","তাই মোশি তাদের গণনা করলেন, যেমন সদাপ্রভু বাণীর মাধ্যমে তাকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","লেবির সন্তানদের নাম এই: গের্শোন, কহাৎ ও মরারি। ");
INSERT INTO benobcv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","গের্শোন গোষ্ঠীসমূহের নাম: লিব্‌নি ও শিমিয়ি। ");
INSERT INTO benobcv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","কহাতীয় গোষ্ঠীসমূহ হল: অম্রাম, যিষ্‌হর, হিব্রোণ ও উষীয়েল। ");
INSERT INTO benobcv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","মরারি গোষ্ঠীসমূহের নাম: মহলি ও মূশি। বংশক্রম অনুসারে লেবীয় গোষ্ঠীসমূহ হল এরাই। ");
INSERT INTO benobcv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","গের্শোন থেকে লিব্‌নীয় গোষ্ঠী ও শিমিয়ি গোষ্ঠী; এরা গের্শোনীয়দের গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","এক মাস বা তারও বেশি বয়সের সমস্ত পুরুষের গণিত সংখ্যা 7,500। ");
INSERT INTO benobcv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","গের্শোনীয়দের গোষ্ঠী সকলকে পশ্চিমদিকে উপাসনা-তাঁবুর পিছন দিকে শিবির স্থাপন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","গের্শোনের বংশসমূহের নেতা ছিলেন, লায়েলের ছেলে ইলীয়াসফ। ");
INSERT INTO benobcv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","সমাগম তাঁবুতে গের্শোনীয়েরা, উপাসনালয় ও তাঁবু, তাদের আচ্ছাদন, সমাগম তাঁবুর প্রবেশপথের পর্দা, ");
INSERT INTO benobcv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","মন্দির প্রাঙ্গণের পর্দাসকল, উপাসনা-তাঁবু ও বেদি আবেষ্টনকারী অঙ্গনের প্রবেশপথের পর্দা ও দড়ি সকল এবং সেইগুলি সম্পর্কিত সমস্ত ব্যবহার্য দ্রব্যের তত্ত্বাবধানের জন্য দায়িত্ব ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","কহাতের অন্তর্গত ছিল অম্রামীয়, যিষ্‌হরীয়, হিব্রোণীয় এবং উষীয়েলীয় গোষ্ঠী; এরাই ছিল কহাৎ গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","এক মাস বা তারও বেশি বয়সের সমস্ত পুরুষের সংখ্যা 8,600। কহাৎ গোষ্ঠী পবিত্রস্থল রক্ষণাবেক্ষণের জন্য দায়ী ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","কহাতীয় গোষ্ঠী সকলকে তাদের উপাসনা-তাঁবুর দক্ষিণপ্রান্তে শিবির স্থাপন করতে হত। ");
INSERT INTO benobcv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","উষীয়েলের ছেলে ইলীষাফণ ছিলেন কহাতীয় গোষ্ঠীবৃন্দের বংশসমূহের নেতা। ");
INSERT INTO benobcv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","তারা তত্ত্বাবধান করত সিন্দুক, মেজ, দীপাধার, বেদিসমূহ, পবিত্রস্থানের ব্যবহার্য বিশেষ দ্রব্যসকল, পর্দা এবং সেই সকলের সঙ্গে সম্পর্কিত ব্যবহার্য সমস্ত দ্রব্য। ");
INSERT INTO benobcv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","লেবি গোষ্ঠীর মুখ্য নেতা ছিলেন, যাজক হারোণের ছেলে ইলীয়াসর। যারা পবিত্রস্থানের দায়িত্বে ছিল, তিনি তাদের উপর নিযুক্ত হয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","মরারির অন্তর্গত মহলীয় গোষ্ঠী ও মূশীয় গোষ্ঠী; এরা ছিল মরারি গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","এক মাস বা তার অধিক বয়সি যে সমস্ত পুরুষ গণিত হয়েছিল, তাদের সংখ্যা 6,200। ");
INSERT INTO benobcv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","অবীহয়িলের ছেলে সূরীয়েল ছিলেন মরারি গোষ্ঠীর বংশসমূহের নেতা। উপাসনা-তাঁবুর উত্তর প্রান্তে তাদের ছাউনি ফেলতে হত। ");
INSERT INTO benobcv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","মরারিদের নিযুক্ত করা হয়েছিল, যেন তারা উপাসনা-তাঁবুর কাঠামো, তক্তা, তার সমস্ত অর্গল, স্তম্ভ, চুঙ্গি ও তার সমস্ত জিনিস এবং সেই সকলের সঙ্গে সম্পর্কিত ব্যবহারের জিনিসের, ");
INSERT INTO benobcv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","সেই সঙ্গে প্রাঙ্গণের চারিদিকের সমস্ত খুঁটি, তাঁবুর গোঁজ ও দড়ির তত্ত্বাবধান করে। ");
INSERT INTO benobcv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","মোশি, হারোণ এবং তাঁর ছেলেদের, উপাসনা-তাঁবুর পূর্বপ্রান্তে, সূর্যোদয় অভিমুখে, সমাগম তাঁবুর সম্মুখভাগে শিবির স্থাপন করতে হত। তারা ইস্রায়েলীদের তরফে পবিত্রস্থান তত্ত্বাবধানের জন্য দায়ী ছিলেন। অন্য যে কেউ পবিত্রস্থানের কাছে হত, তাকে মৃত্যুদণ্ড দেওয়া হত। ");
INSERT INTO benobcv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","লেবি গোষ্ঠীর পূর্ণ জনসংখ্যা, সদাপ্রভুর আদেশ অনুসারে মোশি ও হারোণ, গোষ্ঠী অনুসারে যাদের গণনা করেছিলেন। এক মাস বা তার অধিক বয়সি যে সমস্ত পুরুষ গণিত হয়েছিল, তাদের সংখ্যা 22,000। ");
INSERT INTO benobcv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","সদাপ্রভু মোশিকে বললেন, “এক মাস বা তারও বেশি বয়সি ইস্রায়েলী সমস্ত প্রথমজাত সন্তানকে গণনা করে তাদের নামের একটি তালিকা তৈরি করো। ");
INSERT INTO benobcv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ইস্রায়েলী সমস্ত জ্যেষ্ঠ সন্তানের পরিবর্তে লেবীয়দের এবং সেই সঙ্গে তাদের গৃহপালিত পশুসকলের পরিবর্তে লেবীয়দের গৃহপালিত পশুসকল, আমার জন্য অধিকার করো। আমিই সদাপ্রভু।” ");
INSERT INTO benobcv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","অতএব সদাপ্রভু যে রকম আদেশ দিয়েছিলেন, মোশি ইস্রায়েলী সমস্ত প্রথমজাত সন্তানের সংখ্যা নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","এক মাস ও তারও বেশি বয়সি, নাম তালিকাভুক্ত প্রথমজাত সন্তানের সংখ্যা ছিল 22,273। ");
INSERT INTO benobcv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","সদাপ্রভু মোশিকে একথাও বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ইস্রায়েলী সমস্ত প্রথমজাত সন্তানের পরিবর্তে লেবীয়দের ও তাদের গৃহপালিত পশুসকলের পরিবর্তে লেবীয়দের পশুসকল গ্রহণ করো। লেবীয়রা আমারই হবে। আমিই সদাপ্রভু। ");
INSERT INTO benobcv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","লেবীয়দের সংখ্যা থেকে অতিরিক্ত 273 জন ইস্রায়েলী প্রথমজাত সন্তানের মুক্তির উদ্দেশে, ");
INSERT INTO benobcv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","প্রত্যেক ব্যক্তির বিনিময়ে, পবিত্রস্থানের নিরূপিত শেকল অনুসারে, পাঁচ শেকল করে আদায় করো, যার ওজন কুড়ি গেরা। ");
INSERT INTO benobcv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ইস্রায়েলীদের মুক্তি বাবদ প্রাপ্ত এই অতিরিক্ত অর্থ হারোণ ও তাঁর ছেলেদের দিয়ে দাও।” ");
INSERT INTO benobcv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","তাই মোশি, লেবীয়দের দ্বারা মুক্ত ইস্রায়েলীদের থেকে যারা সংখ্যায় অতিরিক্ত ছিল, তাদের কাছ থেকে মুক্তিপণ আদায় করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ইস্রায়েলী প্রথমজাত সন্তানের কাছ থেকে তিনি, পবিত্রস্থানের নিরূপিত শেকল অনুসারে, 1,365 শেকল রুপো আদায় করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","মোশি সেই মুক্তিপণ, হারোণ ও তার ছেলেদের দিয়ে দিলেন, যে রকম তিনি সদাপ্রভুর বাণীর মাধ্যমে আদেশপ্রাপ্ত হয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“লেবি গোষ্ঠীর অন্তর্গত, কহাৎ সন্তানদের, গোষ্ঠী ও বংশ অনুসারে জনগণনা করো। ");
INSERT INTO benobcv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","যারা সমাগম তাঁবু সম্পর্কিত কাজ করার জন্য সমাগত হয়, ত্রিশ থেকে পঞ্চাশ বছর বয়স্ক সেই পুরুষদের সংখ্যা গণনা করো। ");
INSERT INTO benobcv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“সমাগম তাঁবুতে কহাতীয়দের কাজকর্ম এই; অতি পবিত্র দ্রব্যসমূহের তত্ত্বাবধান। ");
INSERT INTO benobcv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","যখন শিবির যাত্রা শুরু করবে, হারোণ ও তার ছেলেরা ভিতরে ঢেকে দেবে। তারা আচ্ছাদক-পর্দা নামিয়ে এনে, তা দিয়ে সাক্ষ্যের সিন্দুক আবৃত করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","তার উপরে তারা টেকসই চামড়ার আচ্ছাদন দেবে। এরপর তারা ঘন নীল রংয়ের এক বস্ত্রের আবরণ দিয়ে যথাস্থানে বহন-দণ্ড পরিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“উপস্থিতির মেজের উপর তারা নীল রংয়ের বস্ত্র পাতবে, তার উপরে সমস্ত রেকাব, থালা ও বাটি এবং পেয়-নৈবেদ্য রাখার ঘটগুলি রাখবে। যে রুটি সতত সেই মেজের উপরে রাখা থাকে, তা যথারীতি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","এই সমস্তের উপরে তারা এক উজ্জ্বল লাল রংয়ের বস্ত্র পাতবে ও টেকসই চামড়ার আচ্ছাদন দেবে এবং তার বহন-দণ্ড যথাস্থানে পরিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“তারা একটি নীল রংয়ের বস্ত্র নিয়ে, দীপ্তিদানের উদ্দেশে যে দীপাধার, তা আবৃত করবে; সেই সঙ্গে তার প্রদীপগুলি, সলিতা-কাটা যন্ত্রগুলি, বারকোশ এবং তার প্রজ্বলনের উদ্দেশে দত্ত জলপাই তেলের পাত্রগুলি আবৃত করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","তারপর, তারা সেই দীপাধার ও তার সম্পর্কিত সমস্ত জিনিসের উপর টেকসই চামড়ার আচ্ছাদন দেবে এবং সেই সমস্ত তারা বহনকারী কাঠামোর উপরে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“স্বর্ণ-বেদির উপরে তারা নীল রংয়ের বস্ত্র পাতবে এবং টেকসই চামড়ার আচ্ছাদন দিয়ে তার বহন-দণ্ড যথাস্থানে পরিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“পবিত্রস্থানে পরিচর্যার উদ্দেশে ব্যবহৃত সমস্ত পাত্র নিয়ে তারা নীল রংয়ের কাপড়ে জড়াবে; সেই সমস্তের উপরে টেকসই চামড়ার আচ্ছাদন দেবে এবং বহনকারী কাঠামোর উপরে রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“তারা পিতলের বেদি থেকে সমস্ত ছাই বের করে দেবে। তার উপরে বেগুনি রংয়ের কাপড় পাতবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","তার উপরে তারা বেদির উদ্দেশে ব্যবহৃত সমস্ত বাসনপত্র রাখবে, সমস্ত অঙ্গারধানী, ত্রিশূল, বেলচা, রক্ত ছিটানোর উদ্দেশে ব্যবহৃত বাটি সমূহ। এর উপরে তারা টেকসই চামড়ার আচ্ছাদন দেবে এবং তার বহন-দণ্ড যথাস্থানে পরাবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“হারোণ ও তার ছেলেরা সমস্ত পবিত্র আসবাব ও পবিত্র দ্রব্যসমূহ আবৃত করার পর, যখন ছাউনি যাবার উদ্দেশে অগ্রসর হবে, তখন কেবল কহাতীয়েরা বহন করার জন্য এগিয়ে আসবে। তারা কিন্তু পবিত্র দ্রব্যসকল স্পর্শ করবে না, নইলে মৃত্যুবরণ করবে। কহাতীয়েরা সমাগম তাঁবুর মধ্যে স্থিত দ্রব্যসকল বহন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“যাজক হারোণের ছেলে ইলীয়াসর, দীপ্তির জন্য তেলের, সুগন্ধি ধূপ, নিয়মিত শস্য-নৈবেদ্য ও অভিষেকের তেলের দায়িত্ব নেবে। সে সমস্ত পবিত্র আসবাব ও জিনিসপত্র সমাগম তাঁবু ও তার ভিতরের সমস্ত বিষয়ের তত্ত্বাবধায়ক হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“দেখবে, যেন কহাতীয় গোষ্ঠীর বংশসমূহ, লেবীয় গোষ্ঠী থেকে উচ্ছিন্ন না হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","যখন তারা অতি পবিত্র দ্রব্যসমূহের নিকটবর্তী হয়, তারা যেন জীবিত থাকে, হত না হয়; তাদের জন্য এই কাজ করো, হারোণ ও তার ছেলেরা পবিত্রস্থানের ভিতরে যাবে এবং প্রত্যেক ব্যক্তিকে তার কাজ এবং কোন দ্রব্য সে বহন করবে, তা নিরূপণ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","কিন্তু কহাতীয়েরা অবশ্যই ভিতরে গিয়ে, এক মুহূর্তের জন্যও পবিত্র দ্রব্যসকল দেখবে না, নইলে তাদের মৃত্যু হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“বংশ এবং গোষ্ঠী অনুসারে গের্শোনীয়দের জনগণনা করো, ");
INSERT INTO benobcv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","সমাগম তাঁবুর কাজে যারা অংশগ্রহণ করে, ত্রিশ থেকে পঞ্চাশ বছর বয়স্ক সেইসব পুরুষের সংখ্যা গণনা করো। ");
INSERT INTO benobcv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“গের্শোন গোষ্ঠীর সকলে, যখন তারা ভারবহন ও কাজ করে, তাদের কর্তব্য এরকম হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","তারা উপাসনা-তাঁবুর সব পর্দা, তার বাইরে টেকসই চামড়ার আচ্ছাদন, সমাগম তাঁবুর প্রবেশপথের সব পর্দা, ");
INSERT INTO benobcv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","উপাসনা-তাঁবু ও যজ্ঞবেদি পরিবেষ্টনকারী অঙ্গনের পর্দাসকল, প্রবেশপথের পর্দা, দড়ি সকল এবং পরিচর্যায় ব্যবহৃত সমস্ত উপকরণ বহন করবে। গের্শোনীয়েরা এসব দ্রব্য-সংক্রান্ত অথবা অন্যান্য যে কোনো কাজই হোক না কেন তা করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","তাদের সমস্ত কাজ, বহন-সংক্রান্ত অথবা অন্যান্য যে কোনো কাজই হোক না কেন, সেই সমস্ত হারোণ এবং তার ছেলেদের নির্দেশে করতে হবে। তাদের দায়িত্বে যে সকল বহন করার কাজ থাকবে তা তুমি নির্দিষ্ট করে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","সমাগম তাঁবুর জন্য গের্শোনীয়দের কাজকর্ম এই। তাদের করণীয় কর্তব্য যাজক হারোণের ছেলে ঈথামরের নির্দেশ অনুসারে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“মরারিদেরও তাদের গোষ্ঠী ও বংশ অনুসারে গণনা করো। ");
INSERT INTO benobcv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","সমাগম তাঁবুর কাজে অংশগ্রহণের জন্য যারা সমাগত হয়, ত্রিশ থেকে পঞ্চাশ বছর বয়স্ক সেই সমস্ত পুরুষের সংখ্যা গণনা করো। ");
INSERT INTO benobcv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","সমাগম তাঁবুতে, তারা যখন কাজ করে, তাদের করণীয় কর্তব্য হবে এরকম; তারা উপাসনা-তাঁবুর কাঠামোর তক্তা সকল, তার অর্গলদণ্ড গুলি, খুঁটি ও পীঠসকল, ");
INSERT INTO benobcv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","সেই সঙ্গে প্রাঙ্গণের পরিবেষ্টনকারী খুঁটি সকল, তাঁবুর গোঁজ, দড়ি, তাদের উপকরণ এবং ব্যবহার্য সমস্ত আনুষঙ্গিক দ্রব্য বহন করবে। বহনের জন্য প্রত্যেক ব্যক্তিকে তার নির্দিষ্ট দ্রব্যসকল নিরূপণ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","সমাগম তাঁবু সম্পর্কিত কাজ করার সময় মরারি গোষ্ঠীর করণীয় কর্তব্য এই। তারা যাজক হারোণের ছেলে ঈথামরের নির্দেশে এই সমস্ত কাজ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","মোশি, হারোণ এবং সমাজের নেতারা, গোষ্ঠী ও বংশ অনুসারে কহাতীয়দের গণনা করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ত্রিশ থেকে পঞ্চাশ বছর বয়স্ক সমস্ত পুরুষের, যারা সমাগম তাঁবুর কাজ করার জন্য সমাগত হল, ");
INSERT INTO benobcv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","গোষ্ঠী অনুসারে তাদের গণিত সংখ্যা 2,750। ");
INSERT INTO benobcv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","কহাতীয় গোষ্ঠীর যারা সমাগম তাঁবুর পরিচর্যা করত, সেই সমস্ত ব্যক্তির এই মোট সংখ্যা। মোশির মাধ্যমে সদাপ্রভু যে আদেশ দিয়েছিলেন, সেই অনুসারে মোশি ও হারোণ তাদের গণনা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","গের্শোনীয়েরা তাদের গোষ্ঠী এবং বংশ অনুসারে গণিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","সমস্ত পুরুষ যাদের বয়স ত্রিশ থেকে পঞ্চাশ বছর, যারা সমাগম তাঁবুর কাজে অংশগ্রহণ করতে আসত, ");
INSERT INTO benobcv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","তাদের গোষ্ঠী এবং বংশ অনুসারে গণিত জনসংখ্যা ছিল 2,630। ");
INSERT INTO benobcv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","যারা সমাগম তাঁবু পরিচর্যা করত, সেই গের্শোনীয়দের এই ছিল মোট জনসংখ্যা। সদাপ্রভুর আদেশমতো মোশি ও হারোণ তাদের গণনা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","মরারিদের তাদের গোষ্ঠী ও বংশ অনুসারে গণনা করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","সমস্ত পুরুষ যাদের বয়স ত্রিশ থেকে পঞ্চাশ বছর, যারা সমাগম তাঁবুর কাজে অংশগ্রহণ করতে আসত, ");
INSERT INTO benobcv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","গোষ্ঠী অনুসারে তাদের গণিত সংখ্যা ছিল 3,200। ");
INSERT INTO benobcv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","মরারি গোষ্ঠীর এই ছিল মোট সংখ্যা। সদাপ্রভু মোশির মাধ্যমে যে আদেশ দিয়েছিলেন, সেই অনুসারে মোশি ও হারোণ তাদের গণনা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","এইভাবে মোশি, হারোণ এবং ইস্রায়েলের নেতারা, সমস্ত লেবীয়দের, তাদের গোষ্ঠী ও বংশ অনুসারে গণনা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ত্রিশ থেকে পঞ্চাশ বছর বয়স্ক সমস্ত পুরুষ যারা পরিচর্যার ও সমাগম তাঁবু বহনের জন্য আসত, ");
INSERT INTO benobcv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","তাদের গণিত সংখ্যা হয়েছিল 8,580। ");
INSERT INTO benobcv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","মোশির মাধ্যমে দেওয়া সদাপ্রভুর আদেশ অনুসারে তাদের প্রত্যেকজনকে তার কাজ ও বহনীয় দ্রব্যসামগ্রী নিরূপণ করা হয়েছিল। এইভাবে তাদের মোট সংখ্যা গণিত হয়েছিল, যে রকম সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ইস্রায়েলীদের আদেশ দাও যেন তারা সংক্রামক চর্মরোগী বা প্রমেহী অথবা শবের জন্য আনুষ্ঠানিকভাবে অশুচি ব্যক্তিকে ছাউনি থেকে বহিষ্কার করে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","পুরুষ ও স্ত্রী নির্বিশেষে, তারা তাদের বহিষ্কার করবে। তাদের ছাউনির বাইরে পাঠাতে হবে যেন যে শিবিরে আমি তাদের মধ্যে অবস্থান করি, সেই শিবির কলুষিত না হয়।” ");
INSERT INTO benobcv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ইস্রায়েলীরা সেইরকমই করল; তারা তাদের ছাউনির বাইরে পাঠিয়ে দিল। সদাপ্রভু যে রকম মোশিকে আদেশ দিয়েছিলেন, তারা ঠিক সেই কাজ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ইস্রায়েলীদের বলো, ‘যখন কোনো পুরুষ বা স্ত্রী, অন্য কোনো ব্যক্তির প্রতি কোনও ধরনের অন্যায় আচরণ করে এবং সে সদাপ্রভুর কাছে অবিশ্বস্ত প্রতিপন্ন হয়, তাহলে সেই ব্যক্তি অপরাধী সাব্যস্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","সে তার কৃত পাপস্বীকার করবে। তার অন্যায়ের জন্য সে পূর্ণ ক্ষতিপূরণ দেবে, তার সঙ্গে এক-পঞ্চমাংশ বেশি যোগ করবে এবং যার বিরুদ্ধে সে অন্যায় করেছে, সেই ব্যক্তিকে তার সমস্তটাই দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","যদি সেই ব্যক্তির কোনো নিকটাত্মীয় না থাকে, যাকে সেই অন্যায়ের জন্য ক্ষতিপূরণ দেওয়া যেতে পারে, তাহলে তা সদাপ্রভুর অধিকারভুক্ত হবে। তার জন্য কৃত প্রায়শ্চিত্তের মেষের সঙ্গে সেইসব অবশ্যই যাজককে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","যাজকের কাছে ইস্রায়েলীদের দ্বারা আনীত সমস্ত পবিত্র উপহার, তাদেরই অধিকারস্বরূপ হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","প্রত্যেক ব্যক্তির পবিত্র দানসকল তার নিজস্ব হলেও, যে সমস্ত সে যাজকের কাছে নিবেদন করে তা যাজকেরই হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","তারপর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ইস্রায়েলীদের সঙ্গে আলাপ করে তাদের বলো, ‘যদি কারোর স্ত্রী বিপথগামী ও তার প্রতি অবিশ্বস্ত হয়, ");
INSERT INTO benobcv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","অন্য পুরুষের সঙ্গে শয়ন করে এবং সেই বিষয় তার স্বামীর নিকট গুপ্ত থাকে, তার অশুদ্ধতা অনাবিষ্কৃত থেকে যায় (যেহেতু তার বিপক্ষে কোনো সাক্ষী নেই, অথবা সেই কাজ কারোর দৃষ্টিগোচর হয়নি), ");
INSERT INTO benobcv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","যদি তার স্বামী ঈর্ষান্বিত হয়ে তাকে সন্দেহ করে এবং সে অশুচি হয় অথবা যদি ঈর্ষান্বিত হয়ে স্ত্রীকে সন্দেহ করলেও যদিও সে অশুচি না হয়ে থাকে, ");
INSERT INTO benobcv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","সে তার স্ত্রীকে যাজকের কাছে নিয়ে যাবে। সে অবশ্যই তার স্ত্রীর তরফে, এক ঐফার এক-দশমাংশ যবের ময়দা নৈবেদ্যরূপে নিয়ে আসবে। সে তার উপরে জলপাই তেল দেবে না, বা ধূপ নিবেদন করবে না, কারণ এই শস্য-নৈবেদ্য ঈর্ষাজনিত কারণে আনীত, যা অপরাধ চিহ্নিতকরণের অভিপ্রায়ে আনা স্মরণার্থক দানস্বরূপ। ");
INSERT INTO benobcv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘যাজক সেই স্ত্রীকে সদাপ্রভুর সামনে দাঁড় করাবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","তারপর সে একটি মাটির পাত্রে সামান্য পবিত্র জল নেবে এবং উপাসনা-তাঁবুর মেঝে থেকে একটু ধুলো নিয়ে ওই জলের মধ্যে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","যাজক সেই স্ত্রীকে সদাপ্রভুর সামনে দাঁড় করিয়ে তার চুল খুলে দেবে ও তার হাতে স্মারক নৈবেদ্য, অর্থাৎ ঈর্ষাজনিত শস্য-নৈবেদ্য দেবে। সে কিন্তু ওই তিক্ত জল নিজের হাতে ধারণ করবে, যা শাপ বহন করে আনবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","তারপর যাজক সেই স্ত্রীকে শপথ করিয়ে বলবে, “যদি কোনো পুরুষ তোমার সঙ্গে শয়ন না করে থাকে, তুমি যদি ভ্রষ্টা না হয়ে থাকো এবং যদি তোমার স্বামীর সঙ্গে বিবাহিত হয়েছ, তাই যদি অশুচি না হয়ে থাকো, তাহলে এই তিক্ত জল যা শাপ বহন করে আনে, তা তোমার ক্ষতি না করুক। ");
INSERT INTO benobcv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","কিন্তু তোমার স্বামীর সঙ্গে সম্মিলিত হলেও যদি তুমি ভ্রষ্টা হয়ে থাকো এবং তোমার স্বামী ছাড়াও অন্য ব্যক্তির সঙ্গে শয়ন করে কলুষিত হয়ে থাকো,” ");
INSERT INTO benobcv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","এখানে যাজক, সেই স্ত্রীকে শপথের এই শাপের অধীনে নিয়ে আসবে, “তাহলে সদাপ্রভু তাই করুন যেন তোমার জনগোষ্ঠী তোমাকে অভিশাপ দেয় ও প্রকাশ্যে তোমার নিন্দা করে এবং তিনি তোমার ঊরুদেশ নিশ্চল ও উদর স্ফীত করুন। ");
INSERT INTO benobcv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","এই অভিশপ্ত জল তোমার মধ্যে প্রবেশ করে তোমার উদর স্ফীত ও ঊরুদেশ নিশ্চল করুক।” “ ‘তখন স্ত্রীলোকটিকে বলতে হবে, “আমেন, হ্যাঁ তাই হোক।” ");
INSERT INTO benobcv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘যাজক এই শাপের বাণীগুলি একটি গোটান পুঁথিতে লিখে ওই তিক্ত জলে সেই লেখা ধুয়ে ফেলবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","সে স্ত্রীলোকটিকে ওই তিক্ত জলপান করাবে, যা শাপ বহন করে আনবে এবং সেই জল তার উদরে প্রবেশ করে দুঃসহ যন্ত্রণা সৃষ্টি করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","যাজক তার হাত থেকে ঈর্ষাজনিত শস্য-নৈবেদ্য গ্রহণ করে সদাপ্রভুর অভিমুখে দোলাবে এবং যজ্ঞবেদির কাছে নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","তারপর যাজক পূর্ণ একমুঠো ওই শস্য-নৈবেদ্য নিয়ে স্মারক নৈবেদ্যরূপে বেদিতে পোড়াবে; তারপর সে, সেই স্ত্রীকে ওই জলপান করাবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","যদি সে নিজেকে কলুষিত করে থাকে এবং তার স্বামীর প্রতি অবিশ্বস্ত হয়ে থাকে, তাহলে সে যখন শাপবাহী ওই জলপান করবে, সেটি তার উদরে প্রবেশ করে দুঃসহ যন্ত্রণা সৃষ্টি করবে; তার উদর স্ফীত হবে ও ঊরুদেশ নিশ্চল হয়ে যাবে। সে তার গোষ্ঠীর মধ্যে অভিশপ্ত প্রতিপন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","কিন্তু যদি সেই স্ত্রী নিজেকে অশুচি না করে থাকে এবং নিষ্কলুষ থাকে, তাহলে সে অপরাধ মুক্ত হবে এবং সন্তানের জন্ম দিতে সক্ষম হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘এই হবে ঈর্ষাপরায়ণতার বিধি, যখন কোনো স্ত্রীলোক ভ্রষ্টাচারী এবং তার স্বামীর সঙ্গে বিবাহিতা হলেও অশুচি হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","অথবা যখন কোনো ব্যক্তির মনে ঈর্ষার মনোভাব জাগে ও সে তার স্ত্রীর প্রতি সন্ধিগ্ধমনা হয়। যাজক সদাপ্রভুর কাছে তার অবস্থান যাচাই করে দেখবে এবং এই সম্পূর্ণ বিধি তার উপরে প্রয়োগ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","কৃত কোনও অন্যায় কাজের জন্য স্বামী নির্দোষ প্রতিপন্ন হবে, কিন্তু সেই স্ত্রীলোকটি তার পাপের পরিণতি ভোগ করবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ইস্রায়েলীদের সঙ্গে আলাপ করে তাদের বলো, ‘যদি কোনো পুরুষ বা স্ত্রী বিশেষ মানত রাখতে চায়, অর্থাৎ নাসরীয় হিসেবে সদাপ্রভুর উদ্দেশে পৃথক থাকার মানত, ");
INSERT INTO benobcv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","তাহলে সে দ্রাক্ষারস; অথবা অন্য উত্তেজক পানীয় পান করা থেকে নিবৃত্ত থাকবে; সে দ্রাক্ষারস অথবা অন্য উত্তেজক পানীয় থেকে প্রস্তুত সিরকাও পান করবে না। দ্রাক্ষার রস সে অবশ্যই পান করবে না, দ্রাক্ষা বা কিশমিশ খাবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","যতদিন পর্যন্ত সে নাসরীয় থাকে, দ্রাক্ষালতা থেকে উৎপন্ন কোনো কিছুই, এমনকি তার বীজ বা খোসাও সে আহার করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘তার পৃথক থাকার নাসরীয় মানতের সম্পূর্ণ পর্যায়ে মাথায় ক্ষুর ব্যবহার করা হবে না। সদাপ্রভুর উদ্দেশে পৃথক থাকার সম্পূর্ণ পর্যায় সে অবশ্যই পবিত্র থাকবে। সে তার চুলের বৃদ্ধি ঘটতে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘সদাপ্রভুর উদ্দেশে পৃথক থাকার সম্পূর্ণ পর্যায়ে সে কোনো শবের কাছে যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","যদি তার বাবা, মা, ভাই, বা বোন কেউ মারা যায়, তাদের জন্য সে নিজেকে কোনোভাবে অশুচি করবে না, কারণ সদাপ্রভুর উদ্দেশে উৎসর্গীকৃত থাকার প্রতীক তার মাথায় আছে, ");
INSERT INTO benobcv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","তাদের উৎসর্গীকরণের সমস্ত সময় তারা সদাপ্রভুর উদ্দেশে পবিত্র থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘যদি কেউ তার সান্নিধ্যে হঠাৎ প্রাণত্যাগ করে ও পরিণামে তার উৎসর্গিত চুল অশুচি হয়, তাহলে শুদ্ধকরণের দিন, অর্থাৎ সপ্তম দিনে সে তার মাথা নেড়া করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","তারপর অষ্টম দিনে সে দুটি ঘুঘু অথবা দুটি কপোত সমাগম তাঁবুর প্রবেশদ্বারে যাজকের কাছে নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","যাজক তার একটি পাপার্থে ও অন্যটি হোমার্থক বলিরূপে উৎসর্গ করে তার জন্য প্রায়শ্চিত্ত করবে, কারণ সে শবের সংস্পর্শে এসে পাপ করেছে। সেদিনই তার মাথার শুদ্ধায়ন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","স্বতন্ত্র থাকা পূর্ণ পর্যায়ে সে অবশ্যই সদাপ্রভুর নিকট উৎসর্গ করবে এবং তার অপরাধের নৈবেদ্যস্বরূপ একটি এক বর্ষীয় মদ্দা মেষশাবক নিয়ে আসবে। পূর্বকালীন দিন সমূহ আর গণিত হবে না কারণ তার পৃথকস্থিতির সময় সে অশুচি হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘যখন স্বতন্ত্র থাকার পর্যায় সমাপ্ত হবে, তখন নাসরীয় ব্যক্তির করণীয় বিধি হবে এইরকম। তাকে সমাগম তাঁবুর প্রবেশপথে নিয়ে আসতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","সেই স্থানে সে তার উপহার সদাপ্রভুর কাছে নিয়ে আনবে। হোম-নৈবেদ্যর জন্য ক্রুটিহীন একটি এক বর্ষীয় মদ্দা মেষশাবক, পাপার্থক বলির জন্য নিখুঁত একটি এক বর্ষীয় মাদি মেষশাবক, মঙ্গলার্থক বলিদানের জন্য একটি নিখুঁত মেষ; ");
INSERT INTO benobcv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","এর সঙ্গে তাদের শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য, এক ঝুড়ি খামিরবিহীন রুটি, জলপাই তেলমিশ্রিত মিহি ময়দায় প্রস্তুত পিঠে ও জলপাই তেলে ভিজানো পাতলা রুটি। ");
INSERT INTO benobcv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘যাজক সেই সমস্ত নৈবেদ্য সদাপ্রভুর সামনে নিয়ে আসবে এবং পাপার্থক বলি ও হোম-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","সে খামিরবিহীন রুটির চুপড়ির সঙ্গে একটি মেষ মঙ্গলার্থক বলিরূপে সদাপ্রভুর উদ্দেশে উৎসর্গ করবে, তার সঙ্গে শস্য-নৈবেদ্য ও পেয়-নৈবেদ্যও নিবেদন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘তারপর, সমাগম তাঁবুর প্রবেশপথে, সেই নাসরীয় ব্যক্তি তার উৎসর্গিত চুল মুণ্ডন করবে। সেই চুল নিয়ে সে মঙ্গলার্থক বলির উপকরণের সঙ্গে আগুনে নিক্ষেপ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘নাসরীয় ব্যক্তির উৎসর্গিত হওয়ার প্রতীকরূপ চুল মুণ্ডনের পর, যাজক তার হাতে মেষের সিদ্ধ করা একটি কাঁধ, খামিরবিহীন তৈরি করা একটি পিঠে ও একটি পাতলা রুটি দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","তারপর যাজক সেই সমস্ত নিয়ে দোলনীয়-নৈবেদ্যরূপে সদাপ্রভুর অভিমুখে দোলাবে; পবিত্র সেই দ্রব্যগুলি, দোলানো বক্ষের ও নিবেদিত ঊরুর সঙ্গে সবকিছুই যাজকের প্রাপ্য হবে। এরপরে নাসরীয় ব্যক্তি সুরা পান করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘নাসরীয় ব্যক্তি সম্পর্কিত বিধি এরকম যে সদাপ্রভুর কাছে নৈবেদ্যর মানত করে, তার পৃথকস্থিতির বিধি অনুসারে, এই সমস্ত দ্রব্য ছাড়তে অতিরিক্ত যে সমস্ত উপহার সে দিতে সমর্থ হয়, দিতে পারে। নাসরীয় বিধি অনুসারে, তার মানত সে অবশ্যই পূর্ণ করবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“হারোণ এবং তার ছেলেদের বলো, ‘তোমরা এইভাবে ইস্রায়েলীদের আশীর্বাদ করবে। তাদের বোলো ");
INSERT INTO benobcv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “সদাপ্রভু তোমাদের আশীর্বাদ করুন ও তোমাদের রক্ষা করুন; ");
INSERT INTO benobcv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","সদাপ্রভু তোমাদের প্রতি প্রসন্ন-মুখ হোন ও তোমাদের প্রতি সদয় হোন; ");
INSERT INTO benobcv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","সদাপ্রভু তোমাদের প্রতি তার মুখ ফেরান ও তোমাদের শান্তি দিন।” ’ ");
INSERT INTO benobcv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“এইভাবে তারা ইস্রায়েলীদের উপর আমার নাম স্থাপন করবে ও আমি তাদের আশীর্বাদ করব।” ");
INSERT INTO benobcv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","মোশি উপাসনা-তাঁবু স্থাপনের কাজ সমাপ্ত করার পর তিনি সেই তাঁবু ও তার সমস্ত আসবাবপত্র অভিষেক ও উৎসর্গ করলেন। তিনি যজ্ঞবেদি ও তার সমস্ত বাসনপত্রও অভিষেক ও উৎসর্গ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","পরে ইস্রায়েলের নেতৃবৃন্দ, গোষ্ঠীসমূহের মুখ্য ব্যক্তিরা, যাঁরা গণিত ব্যক্তিদের তত্ত্বাবধায়ক ছিলেন, তাঁরা নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","তাঁরা সদাপ্রভুর উদ্দেশে উপহারস্বরূপ আচ্ছাদন যুক্ত ছয়টি শকট ও বারোটি ষাঁড়, প্রত্যেক নেতার পক্ষে একটি করে ষাঁড় এবং একটি শকট প্রত্যেক দুজনের জন্য এনে আবাস তাঁবুর সামনে উপস্থিত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“এই সমস্ত তাদের কাছ থেকে গ্রহণ করো যেন সেগুলি সমাগম তাঁবুর কাজে ব্যবহৃত হয়। প্রয়োজন অনুসারে সেই সমস্ত লেবীয়দের দান করো।” ");
INSERT INTO benobcv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","মোশি সেইসব শকট ও ষাঁড়গুলি নিয়ে লেবীয়দের দান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","তিনি গের্শোনীয়দের কাজের চাহিদা অনুসারে দুটি শকট ও চারটি ষাঁড় দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","আবার মরারীয়দের কাজের চাহিদা অনুসারে তিনি তাদের চারটি শকট ও আটটি ষাঁড় দিলেন। তারা সবাই যাজক হারোণের ছেলে ঈথামরের নির্দেশের অধীন ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","মোশি কিন্তু কহাতীয়দের কিছু দিলেন না, কারণ পবিত্র দ্রব্যসমূহ তাদের কাঁধে করে বহন করতে হত। এই কাজের জন্য তারাই ছিল দায়ী। ");
INSERT INTO benobcv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","যজ্ঞবেদি অভিষিক্ত হওয়ার পর, তা উৎসর্গ করার জন্য নেতৃবর্গ নৈবেদ্য নিয়ে এসে, যজ্ঞবেদির সামনে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","কারণ সদাপ্রভু মোশিকে বলেছিলেন, “প্রত্যেকদিন এক একজন নেতা যজ্ঞবেদি উৎসর্গের জন্য তার নৈবেদ্য নিয়ে আসবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","প্রথম দিন, যিনি তাঁর নৈবেদ্য নিয়ে এলেন, তিনি যিহূদা গোষ্ঠীর অম্মীনাদবের ছেলে নহশোন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","তাঁর উপহারের মধ্যে ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেল মিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ পাঁচটি ছাগল, ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল অম্মীনাদবের ছেলে নহশোনের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","দ্বিতীয় দিন, ইষাখর গোষ্ঠীর নেতা, সূয়ারের ছেলে নথনেল তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","যে উপহার সে নিয়ে এল, তার মধ্যে ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল সূয়ারের ছেলে নথনেলের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","তৃতীয় দিনে, সবূলূন গোষ্ঠীর নেতা, হেলোনের ছেলে ইলীয়াব তাঁর উপহার নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","দশ শেকল পরিমিত, ধূপে পূর্ণ সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","পাপার্থক বলির জন্য একটি ছাগল; ");
INSERT INTO benobcv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল হেলোনের ছেলে ইলীয়াবের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","চতুর্থ দিন, রূবেণ গোষ্ঠীর নেতা, শদেয়ূরের ছেলে ইলীষূর, তাঁর নৈবেদ্য নিয়ে এলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল শদেয়ূরের ছেলে ইলীষূরের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","পঞ্চম দিন, শিমিয়োন গোষ্ঠীর নেতা, সূরীশদ্দয়ের ছেলে শলুমীয়েল, তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","পাপার্থক বলির জন্য একটি ছাগল; ");
INSERT INTO benobcv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল সূরীশদ্দয়ের ছেলে শলুমীয়েলের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ষষ্ঠ দিন, গাদ গোষ্ঠীর নেতা, দ্যূয়েলের ছেলে ইলীয়াসফ, তাঁর নৈবেদ্য নিয়ে এলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","পাপার্থক বলির জন্য একটি ছাগল; ");
INSERT INTO benobcv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল দ্যূয়েলের ছেলে ইলীয়াসফের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","সপ্তম দিন, ইফ্রয়িম গোষ্ঠীর নেতা, অম্মীহূদের ছেলে ইলীশামা, তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","পাপার্থক বলির জন্য একটি ছাগল; ");
INSERT INTO benobcv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল অম্মীহূদের ছেলে ইলীশামার উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","অষ্টম দিনে, মনঃশি গোষ্ঠীর নেতা, পদাহসূরের ছেলে গমলীয়েল, তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল পদাহসূরের ছেলে গমলীয়েলের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","নবম দিনে, বিন্যামীন গোষ্ঠীর নেতা, গিদিয়োনির ছেলে অবীদান তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","তাঁর উপহার ছিল, 130 ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল গিদিয়োনির ছেলে অবীদানের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","দশম দিনে, দান গোষ্ঠীর নেতা, অম্মীশদ্দয়ের ছেলে অহীয়েষর; তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","তাঁর উপহার ছিল, 130 শেকলের ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল অম্মীশদ্দয়ের ছেলে অহীয়েষরের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","একাদশ দিনে, আশের গোষ্ঠীর নেতা, অক্রণের পুত্র পগীয়েল তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকলের ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি মেষ, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল অক্রণের পুত্র পগীয়েলের উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","দ্বাদশ দিনে, নপ্তালি গোষ্ঠীর নেতা, ঐননের পুত্র অহীরঃ, তাঁর নৈবেদ্য নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","তাঁর উপহার ছিল, 130 শেকল ওজনের একটি রুপোর থালা, একটি সত্তর শেকল ওজনের রুপোর বাটি, উভয়েরই পরিমাপ পবিত্রস্থানের শেকলের মানদণ্ড অনুযায়ী ছিল। তার প্রত্যেকটি শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দায় পূর্ণ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","দশ শেকল পরিমিত, ধূপে পূর্ণ একটি সোনার থালা; ");
INSERT INTO benobcv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","হোম-নৈবেদ্যের জন্য একটি এঁড়ে বাছুর, একটি মেষ ও একটি এক বর্ষীয় মদ্দা মেষশাবক; ");
INSERT INTO benobcv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","পাপার্থক বলির জন্য একটি ছাগল, ");
INSERT INTO benobcv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","এবং মঙ্গলার্থক বলি উৎসর্গের জন্য দুটি ষাঁড়, পাঁচটি ছাগল ও পাঁচটি এক বর্ষীয় মেষশাবক। এই ছিল ঐননের পুত্র অহীরঃর উপহার। ");
INSERT INTO benobcv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","যজ্ঞবেদি অভিষেক করার পর, তা উৎসর্গ করার জন্য এই সমস্ত ছিল ইস্রায়েলী নেতাদের নৈবেদ্য; বারোটি রুপোর থালা, বারোটি রুপোর বাটি ও বারোটি সোনার থালা। ");
INSERT INTO benobcv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","প্রত্যেকটি রুপোর থালার ওজন ছিল 130 শেকল এবং প্রত্যেক রুপোর বাটি সত্তর শেকল। রুপোর পাত্রগুলির সর্বমোট ওজন পবিত্রস্থানের শেকল অনুসারে, 2,400 শেকল ");
INSERT INTO benobcv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ধূপে পূর্ণ বারোটি সোনার থালা, পবিত্রস্থানের শেকলের অনুসারে প্রত্যেকটির ওজন দশ শেকল। সোনার থালিগুলির সর্বমোট ওজন 120 শেকল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","হোম-নৈবেদ্যর জন্য আনীত সমস্ত পশুর সংখ্যা, বারোটি এঁড়ে বাছুর, বারোটি মেষ ও বারোটি এক বর্ষীয় মদ্দা মেষশাবক এবং তাদের পরিপূরক শস্য-নৈবেদ্য। পাপার্থক বলির জন্য ব্যবহৃত হয়েছিল বারোটি ছাগল। ");
INSERT INTO benobcv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","মঙ্গলার্থক বলি উৎসর্গের জন্য সর্বমোট পশুর সংখ্যা ছিল চব্বিশটি ষাঁড়, ষাটটি মেষ, ষাটটি ছাগল ও ষাটটি এক বর্ষীয় মেষশাবক। যজ্ঞবেদি অভিষিক্ত হওয়ার পর এই সমস্ত ছিল উৎসর্গ করার নৈবেদ্য। ");
INSERT INTO benobcv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","যখন মোশি সমাগম তাঁবুর ভিতরে সদাপ্রভুর সঙ্গে কথা বলার জন্য প্রবেশ করলেন, তিনি সাক্ষ্য-সিন্দুকের উপরে পাপাবরণের ঊর্ধ্বে অবস্থিত দুই করূবের মধ্যস্থল থেকে তাঁর রব শুনতে পেলেন। এভাবে সদাপ্রভু তাঁর সঙ্গে কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“তুমি হারোণের সঙ্গে আলাপ করে তাকে বলো, ‘তুমি যখন সপ্ত-প্রদীপ প্রতিষ্ঠা করবে, তখন সেগুলি যেন দীপাধারের সামনের দিকে আলো দেয়।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","হারোণ সেইমতো করলেন; তিনি প্রদীপগুলি স্থাপন করে, সেগুলির মুখ দীপাধারের সামনের দিকে রাখলেন, যে রকম সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","দীপাধার এইভাবে নির্মিত হয়েছিল; এর নিচ থেকে ফুল পর্যন্ত, সমস্ত অংশই সোনা পিটিয়ে তৈরি করা হয়েছিল। সদাপ্রভু মোশিকে যেমন নমুনা দেখিয়েছিলেন, দীপাধার ঠিক সেইরকম নির্মিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“অন্য ইস্রায়েলীদের মধ্য থেকে লেবীয়দের নিয়ে, তাদের আনুষ্ঠানিকভাবে শুদ্ধ করো। ");
INSERT INTO benobcv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","তাদের শুদ্ধকরণের জন্য এই কাজ করো, তাদের উপর শুদ্ধকরণের জল সেচন করো; তারা সমস্ত শরীরের লোম ক্ষৌরি করে, জলে তাদের পোশাক ধুয়ে ফেলুক ও এইভাবে নিজেদের শুচি করুক। ");
INSERT INTO benobcv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","শস্য-নৈবেদ্যস্বরূপ জলপাই তেলমিশ্রিত মিহি ময়দা সমেত তারা একটি এঁড়ে বাছুর নেবে; তারপর পাপার্থক বলির জন্য তুমি দ্বিতীয় একটি এঁড়ে বাছুর নেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","লেবীয়দের সমাগম তাঁবুর সামনের দিকে আনবে এবং সমস্ত ইস্রায়েলী সমাজকে একত্র করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","তুমি লেবীয়দের সদাপ্রভুর সামনে নিয়ে আসবে এবং ইস্রায়েলীরা তাদের উপরে হাত রাখবে। ");
INSERT INTO benobcv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","হারোণ ইস্রায়েলীদের দোলনীয়-নৈবেদ্যরূপে লেবীয়দের সদাপ্রভুর সামনে নিবেদন করবে, যেন তারা সদাপ্রভুর কাজ করার জন্য প্রস্তুত হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“লেবীয়েরা ওই এঁড়ে বাছুরের উপর হাত রাখার পর, সদাপ্রভুর উদ্দেশে তাদের একটি পাপার্থক বলিরূপে, অন্যটি হোমবলিরূপে উৎসর্গ করবে, যেন লেবীয়দের জন্য প্রায়শ্চিত্ত সাধিত হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","হারোণ ও তার ছেলেদের সামনে লেবীয়েরা দাঁড় করাবে। তারপর, সদাপ্রভুর অভিমুখে দোলনীয়-নৈবেদ্যরূপে তাদের নিবেদন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","এইভাবে, অন্য ইস্রায়েলীদের থেকে তুমি লেবীয়দের পৃথক করবে। লেবীয়দের সকলে আমারই হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“লেবীয়দের শুদ্ধ করে, তুমি তাদের দোলনীয়-নৈবেদ্যরূপে নিবেদন করার পর, তারা সমাগম তাঁবুতে তাদের সেবাকাজ করতে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ইস্রায়েলীদের মধ্যে শুধু তারাই সম্পূর্ণরূপে আমাকে দত্ত হবে। আমি প্রথমজাতদের, প্রত্যেক ইস্রায়েলী স্ত্রীর প্রথম পুরুষ-সন্তানের পরিবর্তে তাদের নিজস্ব স্বত্ব বলে গ্রহণ করেছি। ");
INSERT INTO benobcv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","মানুষ অথবা পশু, ইস্রায়েলের সমস্ত প্রথমজাত পুরুষ আমার। মিশরে যখন আমি সমস্ত প্রথমজাত প্রাণীকে নিধন করি, আমি তাদের নিজের জন্য স্বতন্ত্র করে রেখেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","তারপর আমি সমস্ত ইস্রায়েলী প্রথমজাত সন্তানের পরিবর্তে লেবীয়দের গ্রহণ করেছি। ");
INSERT INTO benobcv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","সমস্ত ইস্রায়েলীর মধ্য থেকে, আমি হারোণ ও তার ছেলেদের, লেবীয়দের দান করেছি, যেন তারা সমস্ত ইস্রায়েলীর পক্ষে সমাগম তাঁবুর কাজ করে, তাদের জন্য প্রায়শ্চিত্ত করে, যেন তারা যখন পবিত্রস্থানের অভিমুখী হয়, তখন কোনো মহামারি ইস্রায়েলীর আঘাত না করে।” ");
INSERT INTO benobcv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","মোশি, হারোণ এবং সমস্ত ইস্রায়েল সম্প্রদায়, লেবীয় গোষ্ঠীকে নিয়ে সেরকম করলেন, যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","লেবীয়েরা নিজেদের শুদ্ধ করে তাদের পোশাক ধুয়ে ফেলল। তখন হারোণ সদাপ্রভুর সামনে দোলনীয়-নৈবেদ্যরূপে তাদের নিবেদন করলেন ও তাদের শুদ্ধ করার জন্য প্রায়শ্চিত্ত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","তারপর লেবীয়েরা, হারোণ ও তার ছেলেদের তত্ত্বাবধানে, সমাগম তাঁবুর কাজ করার জন্য উপস্থিত হল। তাঁরা লেবীয়দের নিয়ে সেরকম কাজ করলেন, যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“এই কথা লেবীয়দের ক্ষেত্রে প্রযোজ্য, পঁচিশ বছর বা তারও বেশি বয়স্ক পুরুষেরা, সমাগম তাঁবুর কাজে অংশগ্রহণ করতে আসবে, ");
INSERT INTO benobcv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","কিন্তু পঞ্চাশ বছর বয়স হলে তারা সেবাকাজ থেকে অবসর নেবে ও আর কোনো কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","তারা সমাগম তাঁবুর কাজে, তাদের ভাইদের সহায়ক হবে, কিন্তু তারা নিজেরা কোনো কাজ করবে না। এইভাবে তুমি লেবীয়দের দায়িত্ব নিরূপণ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","মিশর থেকে বের হয়ে আসার পর, দ্বিতীয় বছরের প্রথম মাসে, সদাপ্রভু সীনয় মরুভূমিতে মোশির সঙ্গে কথা বললেন। তিনি বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ইস্রায়েলীরা নিরূপিত সময়ে নিস্তারপর্ব পালন করুক। ");
INSERT INTO benobcv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","নির্দিষ্ট সময়ে, অর্থাৎ এই মাসের চতুর্দশ দিনের সন্ধ্যাবেলায়, সমস্ত বিধিনিয়ম অনুসারে, তারা তা সম্পন্ন করুক।” ");
INSERT INTO benobcv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","মোশি তখন ইস্রায়েলীদের নিস্তারপর্ব পালন করতে বললেন। ");
INSERT INTO benobcv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","তারা সীনয় মরুভূমিতে, প্রথম মাসের চতুর্দশ দিনের সন্ধ্যাবেলায় তা সম্পন্ন করল। ইস্রায়েলীরা ঠিক তাই করল, যে রকম সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","কিন্তু তাদের মধ্যে কয়েকজন একটি মৃতদেহ স্পর্শ করায় আনুষ্ঠানিকভাবে অশুচি হয়েছিল। তাই তারা সেইদিন নিস্তারপর্ব পালন করতে পারেনি। তারা সেদিনই মোশি ও হারোণের কাছে এল ");
INSERT INTO benobcv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","এবং মোশিকে বলল, “আমরা একটি মৃতদেহ স্পর্শ করে অশুচি হয়েছি; তা সত্ত্বেও, অন্য ইস্রায়েলীদের সঙ্গে, নিরূপিত সময়ে, সদাপ্রভুর উদ্দেশে নৈবেদ্য আনতে আমরা কেন বঞ্চিত হব?” ");
INSERT INTO benobcv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","মোশি তাদের উত্তর দিলেন, “সদাপ্রভু তোমাদের সম্পর্কে কী আদেশ দেন, আমি তা জেনে আসা অবধি, তোমরা অপেক্ষা করো।” ");
INSERT INTO benobcv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","সদাপ্রভু তখন মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“তুমি ইস্রায়েলীদের বলো, ‘যখন তোমাদের মধ্যে কোনো ব্যক্তি বা তার বংশধরদের কেউ, শবজনিত কারণে অশুচি হয়, অথবা ভ্রমণপথে দূরে থাকে, তারা তা সত্ত্বেও, সদাপ্রভুর উদ্দেশে নিস্তারপর্ব পালন করতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","তারা দ্বিতীয় মাসের চতুর্দশ দিনের সন্ধ্যেবেলা সেই পর্ব সম্পন্ন করবে। খামিরবিহীন রুটি ও তিক্ত শাকের সঙ্গে তারা সেই মেষশাবক আহার করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","তার কোনো কিছুই তারা সকাল পর্যন্ত রাখবে না, বা তার কোনো অস্থি ভঙ্গ করবে না। তারা যখন নিস্তারপর্ব পালন করবে, তখন তার সমস্ত বিধিনিয়ম অনুসরণ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","কিন্তু, যদি কোনো ব্যক্তি আনুষ্ঠানিকভাবে শুচি থাকে, ভ্রমণপথে না থাকে, অথচ নিস্তারপর্ব পালন না করে, সেই ব্যক্তিকে, তার গোষ্ঠী থেকে অবশ্যই উচ্ছেদ করতে হবে। কারণ, সে নির্দিষ্ট সময়ে সদাপ্রভুর নৈবেদ্য নিবেদন করেনি। সেই ব্যক্তি তার পাপের পরিণতি ভোগ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘তোমাদের মধ্যে কোনো প্রবাসী, কোনো বিদেশি ব্যক্তি যদি সদাপ্রভুর নিস্তারপর্ব পালন করতে ইচ্ছুক হয়, সমস্ত বিধিনিয়ম অনুসরণ করে সে তা অবশ্য করবে। বিদেশি ব্যক্তি হোক অথবা স্বদেশ জাত, প্রত্যেকের ক্ষেত্রে একই নিয়ম প্রযোজ্য হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","যেদিন আবাস তাঁবু, অর্থাৎ সাক্ষ্যের তাঁবু স্থাপিত হল, মেঘ তা আবৃত করল। সন্ধ্যা থেকে সকাল পর্যন্ত, আবাস তাঁবুর ঊর্ধ্বস্থ মেঘ, অগ্নিসদৃশ প্রত্যক্ষ হল। ");
INSERT INTO benobcv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","সেইরকমই নিত্য হত, মেঘ তা আবৃত করত এবং রাত্রিবেলা সেই মেঘ অগ্নিসদৃশ তা প্রত্যক্ষ হত। ");
INSERT INTO benobcv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","যখনই মেঘ তাঁবুর উপর থেকে সরে যেত, ইস্রায়েলীরা যাত্রা শুরু করত। যেখানে মেঘ সুস্থির হত, ইস্রায়েলীরা ছাউনি স্থাপন করত। ");
INSERT INTO benobcv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","সদাপ্রভুর আদেশে ইস্রায়েলীরা যাত্রা শুরু করত এবং তাঁর আদেশেই তারা ছাউনি স্থাপন করত। যতক্ষণ পর্যন্ত মেঘ আবাস তাঁবুর উপরে নিশ্চল থাকত, তারা ছাউনিতে অবস্থান করত। ");
INSERT INTO benobcv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","যখন মেঘ দীর্ঘ সময় ধরে আবাস তাঁবুর উপরে অবস্থান করত, ইস্রায়েলীরা সদাপ্রভুর আদেশ পালন করে যাত্রা করত না। ");
INSERT INTO benobcv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","কোনো কোনো সময় আবাস তাঁবুর উপর মেঘ কয়েক দিন অবস্থিতি করত; সদাপ্রভুর আদেশে তারা ছাউনি স্থাপন করত এবং তাঁর আদেশক্রমেই তারা যাত্রা শুরু করত। ");
INSERT INTO benobcv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","কোনো কোনো সময় মেঘ কেবলমাত্র সন্ধ্যেবেলা থেকে সকাল পর্যন্ত অবস্থান করত। যখন সকালবেলায় তা উন্নীত হত, তারা যাত্রা শুরু করত। দিনের বেলা হোক, অথবা রাতের বেলা, যখনই মেঘ উন্নীত হত, তারা যাত্রা করত। ");
INSERT INTO benobcv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","মেঘ, আবাস তাঁবুর উপর দু-দিন, বা এক মাস, অথবা এক বছর, যতদিনই অবস্থিতি করুক, ইস্রায়েলীরা তাদের ছাউনিতে অবস্থান করত, যাত্রা করত না; কিন্তু যখন তা উন্নীত হত, তারা যাত্রা করত। ");
INSERT INTO benobcv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","সদাপ্রভুর আদেশে ছাউনিতে তারা অবস্থান করত এবং সদাপ্রভুর আদেশেই তারা যাত্রা শুরু করত। মোশির মাধ্যমে দেওয়া তাঁর নির্দেশ অনুসারেই, তারা সদাপ্রভুর আদেশ পালন করত। ");
INSERT INTO benobcv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“পিটানো রুপো দিয়ে দুটি তূরী নির্মাণ করো এবং জনসাধারণকে একত্র করতে ও ছাউনির যাত্রা শুরু করার জন্য সেগুলি ব্যবহার করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","যখন উভয় তূরী ধ্বনিত হবে, সমস্ত সমাজ, সমাগম তাঁবুর প্রবেশপথে, তোমার কাছে একত্র হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","যদি একটিমাত্র ধ্বনিত হয়, তাহলে নেতৃবর্গ, অর্থাৎ ইস্রায়েলী গোষ্ঠীর প্রধানেরা, তোমার কাছে একত্র হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","যখন প্রথমবার তূরীধ্বনি শোনা যাবে, তখন ছাউনিস্থিত পূর্ব প্রান্তের গোষ্ঠীসমূহ যাত্রা শুরু করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","দ্বিতীয়বার তূরীধ্বনি শোনা গেলে, দক্ষিণপ্রান্তের ছাউনিসমূহ যাত্রা করবে। তুরীধ্বনিই যাত্রা শুরুর সংকেত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","জনসাধারণকে একত্র করার জন্য, তূরীধ্বনি করবে, কিন্তু যাত্রা শুরু করার সংকেত হবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“হারোণের ছেলেরা যাজকেরা তূরী বাজাবে। এই আদেশ তোমাদের ও তোমাদের ভবিষ্যৎ প্রজন্মের জন্য চিরদিন থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","স্বদেশে, যারা তোমাদের নিপীড়ন করে, যখন তোমরা সেই সমস্ত শত্রুর বিপক্ষে যুদ্ধ করতে যাবে, তূরী বাজাবে। সেই সময় সদাপ্রভু, তোমাদের ঈশ্বর, তোমাদের স্মরণ করবেন এবং শত্রুর হাত থেকে নিস্তার করবেন। ");
INSERT INTO benobcv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","তোমাদের আনন্দের দিনেও, অর্থাৎ তোমাদের নিরূপিত পর্বসমূহে ও পূর্ণিমার উৎসবে, তোমাদের হোম-নৈবেদ্যের ও মঙ্গলার্থক-নৈবেদ্য উৎসর্গ করার সময়ে, তোমরা তূরী বাজাবে। সেসব ঈশ্বরের সামনে তোমাদের জন্য স্মারকরূপে হবে। আমিই সদাপ্রভু তোমাদের ঈশ্বর।” ");
INSERT INTO benobcv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","দ্বিতীয় বছরের, দ্বিতীয় মাসের, বিংশতিতম দিনে, সাক্ষ্যের তাঁবুর উপর থেকে মেঘ উন্নীত হল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","তখন ইস্রায়েলীরা সীনয় মরুভূমিতে থেকে বের হল এবং তারা এক স্থান থেকে আরেক স্থানে ভ্রমণ করল, যতক্ষণ না মেঘ, পারণ প্রান্তরে এসে থামল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","মোশির মাধ্যমে সদাপ্রভুর আজ্ঞানুসারে, তারা এই প্রথমবার যাত্রা করল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","প্রথমে যিহূদার শিবিরের অন্তর্গত সমস্ত সেনাবিভাগ, তাদের নিশান নিয়ে অগ্রসর হল। অম্মীনাদবের ছেলে নহশোন তাদের সেনাপতি ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ইষাখর গোষ্ঠীর সেনাবিভাগের শীর্ষে সূয়ারের ছেলে নথনেল ছিলেন ");
INSERT INTO benobcv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","এবং হেলোনের ছেলে ইলীয়াব ছিলেন সবূলূন গোষ্ঠীর সেনাপতি। ");
INSERT INTO benobcv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","এরপর সমাগম তাঁবু তুলে ফেলা হল এবং যারা তা বহন করত, সেই গের্শোনীয়েরা এবং মরারীয়েরা তখন যাত্রারম্ভ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","তারপর রূবেণের শিবিরের সমস্ত সৈন্য দলীয় নিশান নিয়ে যাত্রা শুরু করল। শদেয়ূরের ছেলে ইলীষূর তাদের সেনাপতি ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","শিমিয়োনের গোষ্ঠীর সেনাবিভাগের শীর্ষে ছিলেন সূরীশদ্দয়ের ছেলে শলুমীয়েল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","দ্যূয়েলের ছেলে ইলীয়াসফ ছিলেন গাদ গোষ্ঠীর সেনাবিভাগের শীর্ষে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","এরপর কহাতীয়েরা বের হল। তারা পবিত্র দ্রব্যসমূহ বহন করছিল। তাদের পৌঁছানোর আগেই সমাগম তাঁবু পুনঃস্থাপিত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","তারপর ইফ্রয়িমের শিবিরের সেনাবিভাগ, দলীয় নিশান নিয়ে যাত্রা শুরু করল। অম্মীহূদের ছেলে ইলীশামা ছিলেন সেনাপতি। ");
INSERT INTO benobcv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","পদাহসূরের ছেলে গমলীয়েল, মনঃশি গোষ্ঠীর শীর্ষে ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","গিদিয়োনির ছেলে অবীদান ছিলেন বিন্যামীন গোষ্ঠীর সেনাবিভাগের শীর্ষে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","সমস্ত শিবিরের পিছনে প্রহরীরূপে দানের শিবিরের সমস্ত সেনাবিভাগ, তাদের নিশান নিয়ে যাত্রা করল। অম্মীশদ্দয়ের ছেলে অহীয়েষর ছিলেন তাদের সেনাপতি। ");
INSERT INTO benobcv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","আশের গোষ্ঠীর সেনাবিভাগের শীর্ষে ছিলেন অক্রণের ছেলে পগীয়েল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","আবার ঐননের ছেলে অহীরঃ ছিলেন নপ্তালির গোষ্ঠীর সেনাবিভাগের শীর্ষে। ");
INSERT INTO benobcv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","সমস্ত ইস্রায়েলী সেনাবিভাগ এই ধারায় যাত্রা করত। ");
INSERT INTO benobcv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","এরপর মোশি, তাঁর শ্বশুর, মিদিয়নীয় রূয়েলের ছেলে হোববকে বললেন, “আমরা সেই স্থানের উদ্দেশে বের হয়েছি, যার সম্পর্কে সদাপ্রভু বলেছিলেন, ‘আমি সেই দেশ তোমাকে দেব।’ আমাদের সঙ্গে এসো, আমরা তোমাদের সঙ্গে যথোচিত ব্যবহার করব, কারণ সদাপ্রভু ইস্রায়েলের কাছে উত্তম বিষয়সমূহের শপথ করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","সে উত্তর দিল, “না আমি যাব না। আমি স্বদেশে, আমার স্বজাতির কাছে ফিরে যাচ্ছি।” ");
INSERT INTO benobcv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","মোশি তা সত্ত্বেও বললেন, “দয়া করে আমাদের ত্যাগ কোরো না। তুমি জানো প্রান্তরে আমাদের কোন স্থানে ছাউনি স্থাপন করতে হবে এবং তুমি আমাদের পথপ্রদর্শক হতে পারো। ");
INSERT INTO benobcv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","যদি তুমি আমাদের সঙ্গে চলো, তাহলে সদাপ্রভু যে সকল উত্তম দ্রব্য আমাদের দান করবেন, আমরা তোমার সঙ্গে সেই সমস্ত ভাগ করে নেব।” ");
INSERT INTO benobcv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","এইভাবে তারা সদাপ্রভুর পর্বত থেকে বের হয়ে তিনদিনের পথ ভ্রমণ করল। সদাপ্রভুর নিয়ম-সিন্দুক তাদের অগ্রবর্তী হয়ে সেই তিন দিন চলার পর তারা বিশ্রামের জন্য জায়গা অন্বেষণ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","তারা যখন শিবির থেকে বের হল, সদাপ্রভুর মেঘ তাদের ঊর্ধ্বে বিদ্যমান ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","যখনই সিন্দুক যাত্রা করত মোশি বলতেন, “হে সদাপ্রভু, ওঠো! তোমার শত্রুদের ছিন্নভিন্ন করো; যারা তোমাকে ঘৃণা করে তারা তোমার সামনে থেকে পালিয়ে যাক।” ");
INSERT INTO benobcv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","যখনই বিশ্রামের অবকাশ হত, তিনি বলতেন, “সদাপ্রভু, ফিরে এসো, অযুত অযুত ইস্রায়েলীদের মধ্যে।” ");
INSERT INTO benobcv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","এরপর জনগণ সদাপ্রভুর কর্ণগোচরে তাদের ক্লেশের জন্য অভিযোগ করল এবং তিনি যখন তা শুনলেন তখন তিনি রুষ্ট হলেন। তখন সদাপ্রভুর কাছ থেকে আগুন বের হয়ে ছাউনির প্রান্তসীমার কিছু অংশ পুড়িয়ে দিল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","যখন সেই লোকেরা মোশির কাছে কাঁদল, তিনি সদাপ্রভুর কাছে বিনতি করলেন এবং আগুন নিবে গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","এজন্য সেই স্থানের নাম তবেরা রাখা হল, কারণ সদাপ্রভুর কাছ থেকে আগুন বেরিয়ে এসে তাদের পুড়িয়ে দিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","তাদের মধ্যে বসবাসকারী উচ্ছৃঙ্খল লোকেরা, বিকল্প খাবারের জন্য অনুনয় করল এবং ইস্রায়েলীরা পুনরায় বিলাপ করে বলতে লাগল, “আমাদের খাবারের জন্য যদি একটু মাংস পেতাম! ");
INSERT INTO benobcv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","স্মরণে আসছে, মিশরে আমরা বিনামূল্যে মাছ খেতাম, সেই সঙ্গে শসা, তরমুজ, সবজি, পিঁয়াজ, রসুনও খেতাম। ");
INSERT INTO benobcv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","কিন্তু এখন আমাদের ক্ষুধার অবলুপ্তি ঘটেছে; এই মান্না ছাড়া অন্য কিছু দেখা যায় না।” ");
INSERT INTO benobcv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","মান্না, ধনে বীজের মতো আকৃতি এবং দেখতে কিশমিশের মতো ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","লোকেরা চতুর্দিকে ভ্রমণ করে তা সংগ্রহ করত, তারপর যাঁতায় পেষণ অথবা হামানদিস্তায় চূর্ণ করত। তারা কোনো পাত্রে সেই মান্না রান্না করত, নতুবা তা দিয়ে পিঠে তৈরি করত। জলপাই তেলে প্রস্তুত কোনো পদের মতোই তার স্বাদ ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","রাত্রিবেলা, ছাউনিতে শিশিরের সঙ্গে মান্না পড়ত। ");
INSERT INTO benobcv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","মোশি প্রত্যেক পরিবারের বিলাপ শুনতে পেলেন। তারা প্রত্যেকে নিজেদের তাঁবুর প্রবেশ মুখে ছিল। সদাপ্রভু ভয়ংকর রুষ্ট হওয়াতে, মোশি উদ্বিগ্ন হলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","তিনি সদাপ্রভুকে জিজ্ঞাসা করলেন, “তোমার দাসকে এই সমস্যার সম্মুখীন কেন করেছ? আমি কোন কাজ করতে তোমাকে অসন্তুষ্ট করেছি যে তুমি এই সমস্ত লোকের ভার আমার উপর চাপিয়ে দিলে? ");
INSERT INTO benobcv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","এদের সবাইকে কি আমি গর্ভে ধারণ করেছিলাম? আমি কি তাদের জন্ম দিয়েছি? ধাত্রী যেমন শিশুসন্তান বহন করে, সেভাবে, কেন তুমি আমাকে বলেছিলে, তাদের বহন করে, পূর্বপুরুষদের কাছে করা শপথ অনুসারে প্রতিজ্ঞাত দেশে নিয়ে যেতে? ");
INSERT INTO benobcv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","এই সমস্ত লোকের জন্য আমি এখন কোথায় মাংস পাব? তারা আমার কাছে কেঁদে বলছে, ‘আমাদের খাবারের জন্য মাংস দাও!’ ");
INSERT INTO benobcv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","আমি এককভাবে, এই সমস্ত লোকের দায়িত্ব বহন করতে পারব না। তা আমার শক্তির অতিরিক্ত। ");
INSERT INTO benobcv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","আমার সঙ্গে অনুরূপ ব্যবহার যদি তোমার অভিপ্রেত হয়, তাহলে এই মুহূর্তেই আমাকে বধ করো, যদি তোমার দৃষ্টিতে কৃপা লাভ করে থাকি, আমাকে ধ্বংসের সম্মুখীন হতে দিয়ো না।” ");
INSERT INTO benobcv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","সদাপ্রভু মোশিকে বললেন, “আমার কাছে ইস্রায়েলের সত্তরজন প্রবীণ ব্যক্তিকে, যারা জনসমাজের নেতা ও কর্মকর্তারূপে তোমার কাছে পরিচিত, তাদের নিয়ে এসো। তারা সমাগম তাঁবুতে সমাগত হোক, যেন তারা সেই জায়গায় তোমার সঙ্গে দাঁড়ায়। ");
INSERT INTO benobcv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","আমি নেমে এসে তোমার সঙ্গে আলাপ করব এবং তোমার উপরে যে আত্মা বিদ্যমান, সেই আত্মা আমি তাদের উপরেও অধিষ্ঠান করাব। তারা তোমার সঙ্গে জনসমাজের দায়িত্ব বহন করবে, যেন তোমাকে এককভাবে সমস্ত ভারবহন করতে না হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“লোকদের বলো, ‘আগামীকালের জন্য প্রস্তুত হও, নিজেদের পবিত্র করো, যখন তোমরা মাংস ভোজন করতে পারবে। তোমরা যখন বিলাপ করে বলেছিলে, “যদি আহার করার জন্য মাংস পেতাম! মিশরেই আমরা অপেক্ষাকৃত ভালো ছিলাম!” সেই কথা সদাপ্রভু শুনেছিলেন। এইবার, সদাপ্রভু তোমাদের মাংস জোগাবেন, তোমরা তা ভোজন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","মাত্র একদিন, দু-দিন, পাঁচ, দশ কি কুড়ি দিনের জন্য তোমরা ভোজন করবে, তা নয়; ");
INSERT INTO benobcv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","সম্পূর্ণ এক মাস অবধি, যতক্ষণ না মাংস তোমাদের নাক থেকে বহির্গত হয় ও তোমাদের বিরাগ জন্মে, কারণ যিনি তোমাদের মধ্যে অবস্থানকারী, তোমরা সেই সদাপ্রভুকে প্রত্যাখ্যান করেছ, বলেছ, “কেন আমরা সম্পূর্ণরূপে মিশর পরিত্যাগ করে এলাম?” ’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","কিন্তু মোশি বললেন, “এখানে আমি ছয় লক্ষ পদাতিকের মধ্যে অবস্থান করছি এবং তুমি বলছ, ‘আমি তাদের এক মাস পর্যন্ত মাংস ভোজন করতে দেব!’ ");
INSERT INTO benobcv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","যদি পাল পাল গবাদি পশু ও মেষ হনন করা হয়, তা হলেও তাদের জন্য পরিমাণে কি তা পর্যাপ্ত হবে? যদি সমুদ্রের সমস্ত মাছ ধরা হয়, তাও কি তাদের জন্য যথেষ্ট হবে?” ");
INSERT INTO benobcv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","সদাপ্রভু মোশিকে উত্তর দিলেন, “সদাপ্রভুর হাত কি নিতান্তই সংকুচিত হয়েছে? তুমি এবার দেখবে, আমি যা বলি, তা তোমাদের জন্য বাস্তব হয় কি না!” ");
INSERT INTO benobcv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","অতএব মোশি বাইরে গিয়ে সদাপ্রভু যে সমস্ত কথা বলেছিলেন, তা লোকদেরকে বললেন। তাদের সত্তরজন প্রবীণকে একত্র করে, সেই শিবিরের চতুর্দিকে দাঁড় করালেন। ");
INSERT INTO benobcv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","তখন সদাপ্রভু মেঘের মধ্যে অবতীর্ণ হলেন এবং তাঁর সঙ্গে কথা বললেন; তিনি ঈশ্বরের সেই আত্মা সত্তরজন প্রবীণের উপর অধিষ্ঠান করালেন, যে আত্মা মোশির উপর ছিলেন। যখন আত্মা তাঁদের উপর অধিষ্ঠান করলেন, তাঁরা ভাববাণী বলতে লাগলেন, অবশ্য পরে তাঁরা আর তা করেননি। ");
INSERT INTO benobcv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","কিন্তু, ইল্‌দদ ও মেদদ নামক দুজন ব্যক্তি ছাউনিতেই থেকে গিয়েছিলেন। তাঁরাও প্রবীণদের মধ্যে গণিত হয়েছিলেন, যদিও বের হয়ে সেই শিবিরের কাছে যাননি। তা সত্ত্বেও আত্মা তাঁদের উপরে অধিষ্ঠিত হলেন এবং তাঁরা ছাউনির মধ্যেই ভাববাণী বলা শুরু করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","একজন যুবক দৌড়ে গিয়ে মোশিকে বলল, “ইল্‌দদ ও মেদদ, ছাউনির মধ্যেই ভাববাণী বলছেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","নূনের ছেলে যিহোশূয়, যিনি যৌবনকাল থেকে মোশির পরিচারক ছিলেন, তিনি বললেন, “আমার প্রভু, মোশি, ওদের বারণ করুন!” ");
INSERT INTO benobcv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","কিন্তু মোশি উত্তরে বললেন, “আমার জন্য তুমি কি ঈর্ষান্বিত হয়েছ? আমার বাসনা, সদাপ্রভুর প্রত্যেকজন ব্যক্তি ভাববাদী হোন এবং তিনি তাদের সকলের উপর আত্মাকে অধিষ্ঠিত করুন।” ");
INSERT INTO benobcv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","তারপর মোশি ও ইস্রায়েলের প্রবীণেরা ছাউনিতে ফিরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","তখন সদাপ্রভুর কাছ থেকে এক ঝড় বের হয়ে সমুদ্র থেকে ভারুই পাখিদের তুলে নিয়ে এল। সেই ঝড়, ছাউনির চতুর্দিকে তাদের উড়িয়ে নিয়ে এল। তারা ভূমি থেকে তিন ফুট উঁচুতে অবস্থান করল এবং যে কোনো দিশায়, একদিনের চলার পথ পর্যন্ত বিস্তৃত হয়ে রইল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","সেদিন, সম্পূর্ণ দিন ও রাত এবং তার পরেরও সম্পূর্ণ দিন সবাই ভারুই পাখি সংগ্রহ করল। কোনো ব্যক্তিই দশ হোমারের কম সংগ্রহ করল না। তারা সেই সমস্ত পাখি ছাউনির চতুর্দিকে ছড়িয়ে রাখল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","মাংস তাদের দাঁতে থাকতে থাকতেই এবং সব সমাপ্ত হবার আগেই লোকেদের বিপক্ষে সদাপ্রভুর রোষ বহ্নিমান হল। তিনি ভয়ংকর এক মহামারি দ্বারা তাদের আঘাত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","অতএব সেই স্থানের নাম রাখা হল কিব্রোৎ-হত্তাবা, কারণ যারা ভিন্নতর খাবারের জন্য লোভাতুর হয়েছিল, তাদের সেখানেই তারা সমাধি দিল। ");
INSERT INTO benobcv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","কিব্রোৎ-হত্তাবা থেকে সেই জনতা, হৎসেরোতে যাত্রা করল এবং সেই জায়গায় অবস্থান করল। ");
INSERT INTO benobcv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","মরিয়ম ও হারোণ, মোশির কূশীয়া স্ত্রীর জন্য, তাঁর বিপক্ষে কথা বলা শুরু করলেন, কারণ তিনি এক কূশীয়া নারীকে বিয়ে করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","তাঁরা প্রশ্ন করলেন, “সদাপ্রভু কি শুধু মোশির মাধ্যমেই কথা বলেছেন? তিনি কি আমাদের মাধ্যমেও কথা বলেননি?” সদাপ্রভু সেই কথা শুনলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(এদিকে মোশি, একজন অত্যন্ত নম্র, ভূপৃষ্ঠ নিবাসী যে কোনো ব্যক্তি অপেক্ষা অধিকতর নম্র ছিলেন।) ");
INSERT INTO benobcv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","সদাপ্রভু অনতিবিলম্বে মোশি, হারোণ ও মরিয়মকে বললেন, “তোমরা তিনজনই বেরিয়ে সমাগম তাঁবুর কাছে এসো।” তাঁরা তিনজনই বেরিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","তখন সদাপ্রভু এক মেঘস্তম্ভে অবতরণ করলেন; তিনি তাঁবুর প্রবেশপথে দাঁড়িয়ে হারোণ ও মরিয়মকে ডাকলেন। তাঁরা উভয়েই যখন সামনে এগিয়ে গেলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","তিনি বললেন, “আমার কথা শোনো, “তোমাদের মধ্যে থেকে যখন কোনো ভাববাদীর কাছে, আমি, সদাপ্রভু, দর্শনের মাধ্যমে নিজেকে প্রকাশ করি, আমি স্বপ্নে তাঁর সঙ্গে আলাপ করি। ");
INSERT INTO benobcv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","কিন্তু আমার দাস মোশি সেরকম নয়, সে আমার সমস্ত গৃহের মধ্যে বিশ্বাসভাজন। ");
INSERT INTO benobcv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","আমি তাঁর সঙ্গে সরাসরি আলাপ করি, স্পষ্টভাষায় বলি, হেঁয়ালি করে নয়, সে সদাপ্রভুর অবয়ব প্রত্যক্ষ করে। তাহলে তোমরা ভীত হলে না কেন, আমার সেবক মোশির বিপক্ষে কথা বলতে?” ");
INSERT INTO benobcv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","সদাপ্রভুর রোষ তাঁদের প্রতি বহ্নিমান হল এবং তিনি তাঁদের ত্যাগ করে চলে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","যখন সেই মেঘ, তাঁবুর উপর থেকে প্রস্থান করল, মরিয়ম হিমের মতো কুষ্ঠরোগাক্রান্ত হয়ে সেখানে দাঁড়িয়েছিলেন। হারোণ তাঁর দিকে ফিরে দৃষ্টিপাত করলেন, দেখলেন তাঁর কুষ্ঠ হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","তিনি মোশিকে বললেন, “আমার প্রভু, নির্বোধের মতো করে ফেলা আমাদের পাপ, দয়া করে আমাদের বিপক্ষে ধরে রাখবেন না। ");
INSERT INTO benobcv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","সে মাতৃগর্ভ থেকে নিঃসৃত, অর্ধ-ক্ষয়িষ্ণু, মৃতজাত শিশুর মতো না হোক।” ");
INSERT INTO benobcv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","মোশি তাই সদাপ্রভুর কাছে কেঁদে বললেন, “হে ঈশ্বর, কৃপাবশত তাকে সুস্থ করো!” ");
INSERT INTO benobcv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","সদাপ্রভু মোশিকে উত্তর দিলেন, “যদি তাঁর বাবা, তাঁর মুখে থুতু দিত, তাহলে সাত দিন সে কি লজ্জিত হত না? ছাউনির বাইরে তাঁকে সাত দিন আবদ্ধ রাখো; তারপর ফিরিয়ে আনা যেতে পারে।” ");
INSERT INTO benobcv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","অতএব, মরিয়ম সাত দিন, ছাউনির বাইরে আবদ্ধ রইলেন এবং তাঁর ফিরে না আসা অবধি, লোকেরা যাত্রায় অগ্রসর হল না। ");
INSERT INTO benobcv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","তারপর সেই লোকেরা হৎসেরোৎ ত্যাগ করে পারণ মরুভূমিতে গিয়ে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“আমি ইস্রায়েলীদের যে দেশ দিতে চাই, সেই কনানের ভূমি নিরীক্ষণ করতে কয়েকজন ব্যক্তিকে পাঠাও। প্রত্যেক পিতৃ-গোষ্ঠীর নেতৃবৃন্দ থেকে একজন করে পাঠাও।” ");
INSERT INTO benobcv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","অতএব মোশি সদাপ্রভুর আদেশ অনুসারে, তাদের পারণ প্রান্তর থেকে পাঠালেন। তাঁরা প্রত্যেকেই ইস্রায়েলীদের নেতা ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","এই তাঁদের নাম: রূবেণ গোষ্ঠী থেকে সক্কুরের ছেলে শম্মূয়; ");
INSERT INTO benobcv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","শিমিয়োন গোষ্ঠী থেকে হোরির ছেলে শাফট; ");
INSERT INTO benobcv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","যিহূদা গোষ্ঠী থেকে যিফূন্নির ছেলে কালেব; ");
INSERT INTO benobcv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ইষাখর গোষ্ঠী থেকে যোষেফের ছেলে যিগাল; ");
INSERT INTO benobcv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ইফ্রয়িম গোষ্ঠী থেকে নূনের ছেলে হোশেয়; ");
INSERT INTO benobcv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","বিন্যামীন গোষ্ঠী থেকে রাফূর ছেলে পল্‌টি; ");
INSERT INTO benobcv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","সবূলূন গোষ্ঠী থেকে সোদির ছেলে গদ্দীয়েল; ");
INSERT INTO benobcv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","মনঃশি (যোষেফের একটি গোষ্ঠী) গোষ্ঠী থেকে সূষির ছেলে গদ্দি; ");
INSERT INTO benobcv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","দান গোষ্ঠী থেকে গমল্লির ছেলে অম্মীয়েল; ");
INSERT INTO benobcv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","আশের গোষ্ঠী থেকে মীখায়েলের ছেলে সথুর; ");
INSERT INTO benobcv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","নপ্তালি গোষ্ঠী থেকে বপ্সির ছেলে নহ্‌বি; ");
INSERT INTO benobcv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","গাদ গোষ্ঠী থেকে মাখির ছেলে গ্যূয়েল। ");
INSERT INTO benobcv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","মোশি যে ব্যক্তিদের দেশ নিরীক্ষণ করতে পাঠিয়েছিলেন, তাঁদের নামগুলি এই। (মোশি নূনের ছেলে হোশেয়ের নাম রাখলেন যিহোশূয়।) ");
INSERT INTO benobcv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","কনান নিরীক্ষণ করতে পাঠানোর সময় মোশি তাঁদের বললেন, “নেগেভের মধ্য দিয়ে উঠে পার্বত্য অঞ্চলে গমন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","লক্ষ্য করবে, সেই দেশ কী রকম, সেখানকার লোকেরা দুর্বল না শক্তিশালী। তারা সংখ্যায় অল্প না বেশি। ");
INSERT INTO benobcv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","কোন ধরনের ভূমিতে তারা বসবাস করে? তা কী ভালো না মন্দ? কোন ধরনের নগরে তাদের নিবাস? সেগুলি প্রাচীর বিহীন না সুরক্ষিত? ");
INSERT INTO benobcv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","মাটিই বা কী রকম? উর্বর না সাধারণ? বৃক্ষসমন্বিত না বৃক্ষবিহীন? আপ্রাণ চেষ্টা কোরো, সেই দেশের কিছু ফল নিয়ে আসতে।” (তখন আঙুর পাকার সময় ছিল।) ");
INSERT INTO benobcv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","অতএব তাঁরা উঠে গেলেন এবং সীন মরুভূমি থেকে রহোব পর্যন্ত, লেবো-হমাৎ অভিমুখে ভ্রমণ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","তাঁরা নেগেভ হয়ে নিরীক্ষণ করে হিব্রোণে এলেন। সেখানে অহীমান, শেশয়, ও তল্‌ময় নামবিশিষ্ট, অনাকের তিনজন উত্তরাধিকারী বসবাস করত। (মিশরে সোয়ন নির্মিত হওয়ার সাত বছর আগে হিব্রোণ নির্মিত হয়েছিল।) ");
INSERT INTO benobcv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","যখন তাঁরা ইষ্কোল উপত্যকায় উপস্থিত হলেন, তাঁরা দ্রাক্ষার গুচ্ছ সমন্বিত একটি শাখা কাটলেন। দুজন ব্যক্তি, একটি দণ্ডের দ্বারা সেই দ্রাক্ষাগুচ্ছ এবং কিছু বেদানা ও ডুমুর বহন করে আনলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","যেহেতু দ্রাক্ষাগুচ্ছ ইস্রায়েলীরা কেটে এনেছিল, তাই সেই স্থানের নাম হল, ইষ্কোল উপত্যকা। ");
INSERT INTO benobcv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","চল্লিশ দিনের শেষে, তাঁরা দেশ নিরীক্ষণ করে ফিরে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","পারণ প্রান্তরে, কাদেশে তাঁরা মোশি, হারোণ এবং সমস্ত ইস্রায়েলীদের কাছে ফিরে এলেন। সেখানে তাঁরা, তাঁদের এবং সমস্ত সম্প্রদায়কে দেশ নিরীক্ষণের বিশদ বিবরণ দিলেন ও সেই দেশের ফল তাদের দেখালেন। ");
INSERT INTO benobcv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","তাঁরা মোশিকে বর্ণনা দিয়ে বললেন, “আপনি যে দেশে আমাদের পাঠিয়েছিলেন, আমরা সেখানে গিয়েছিলাম। সেই দেশ অবশ্যই দুধ ও মধু প্রবাহী! এই ফলগুলি, সেই দেশের। ");
INSERT INTO benobcv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","কিন্তু যারা সেখানে বসবাস করে, তারা বলিষ্ঠ, তাদের নগরগুলি সুরক্ষিত এবং বড়ো বড়ো। আমরা সেখানে অনাকের উত্তরসূরীদেরও দেখেছি। ");
INSERT INTO benobcv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","নেগেভে অমালেকীয়েরা বসবাস করে; হিত্তীয়, যিবূষীয়, ইমোরীয়েরা পার্বত্য অঞ্চলে এবং কনানীয়েরা সমুদ্রের কাছে ও জর্ডন উপকূলে বসবাস করে।” ");
INSERT INTO benobcv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","তখন কালেব, মোশির সামনে তাঁদের শান্ত করে বলল, “আমাদের উচিত, উঠে গিয়ে সেই দেশ অধিকার করা, কারণ সেই শক্তি আমাদের অবশ্যই আছে।” ");
INSERT INTO benobcv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","যে ব্যক্তিরা তাঁর সঙ্গে গিয়েছিলেন তাঁরা বললেন, “আমরা ওই ব্যক্তিদের আক্রমণ করতে পারি না; তারা আমাদের থেকেও বেশি শক্তিশালী।” ");
INSERT INTO benobcv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","তাঁরা যে দেশ নিরীক্ষণ করে এসেছিলেন, সেই দেশ সম্পর্কে ইস্রায়েলীদের মধ্যে বিরূপ সংবাদ ছড়াল। তাঁরা বললেন, “যে দেশ আমরা নিরীক্ষণ করেছি সেই দেশ নিজের অধিবাসীদের গ্রাস করে। যে সমস্ত লোককে সেখানে আমরা দেখেছি তারা সবাই বৃহদাকার। ");
INSERT INTO benobcv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","আমরা নেফিলীমদেরও সেখানে দেখেছি। (অনাকের উত্তরসূরিদের আগমন নেফিলিম থেকে) আমরা নিজেদের দৃষ্টিতে, সেই সঙ্গে তাদের দৃষ্টিতেও, ফড়িং-এর মতো প্রতিপন্ন হয়েছি।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","সেই রাতে, সমাজের আপামর জনতা, উচ্চস্বরে কান্নাকাটি করল। ");
INSERT INTO benobcv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ইস্রায়েলীরা সবাই, মোশি ও হারোণের বিপক্ষে অসন্তোষ প্রকাশ করল। সম্পূর্ণ সমাজ তাঁদের বলল, “ভালো হত, যদি আমরা মিশরেই, অথবা এই প্রান্তরেই মারা যেতাম! ");
INSERT INTO benobcv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","সদাপ্রভু তরোয়াল দ্বারা বধ করার অভিপ্রায়ে, কেন আমাদের এই দেশে নিয়ে এলেন? আমাদের স্ত্রী ও সন্তানেরা লুন্ঠিত হবে। আমাদের জন্য মিশরে ফিরে যাওয়াই কি বেশি ভালো নয়?” ");
INSERT INTO benobcv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","তারা পরস্পর আলোচনা করে বলল, “একজন নেতা মনোনীত করে আমাদের মিশরে ফিরে যাওয়াই উচিত।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","তখন মোশি ও হারোণ, সমবেত সমগ্র ইস্রায়েলী সমাজের সামনে উপুড় হয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","নূনের ছেলে যিহোশূয় এবং যিফূন্নির ছেলে কালেব, যাঁরা দেশ নিরীক্ষণ করেছিলেন, নিজেদের বস্ত্র চিরলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","এবং সমগ্র ইস্রায়েলী সমাজকে বললেন, “যে দেশ আমরা সরেজমিনে নিরীক্ষণ করেছি, তা অত্যন্ত ভালো। ");
INSERT INTO benobcv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","যদি সদাপ্রভু আমাদের উপরে প্রীত হন, তিনি সেই দেশে, দুধ ও মধু প্রবাহী দেশে, আমাদের নিয়ে যাবেন ও তা দান করবেন। ");
INSERT INTO benobcv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","কেবল সদাপ্রভুর বিদ্রোহী হোয়ো না। সেই দেশনিবাসী লোকেদের ভয় পেয়ো না কারণ আমরা তাদের দেশ কুক্ষিগত করব। তাদের নিরাপত্তা বিলীন হয়েছে, কিন্তু সদাপ্রভু আমাদের সহবর্তী আছেন। তাদের থেকে ভীত হোয়ো না।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","সমগ্র জনতা কিন্তু তাঁদের প্রস্তরাঘাত করার কথা বলল। তখন ইস্রায়েলীদের সবার সামনে, সদাপ্রভুর মহিমা, সমাগম তাঁবুতে প্রত্যক্ষ হল। ");
INSERT INTO benobcv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","সদাপ্রভু মোশিকে বললেন, “কত কাল এই লোকেরা আমার অবমাননা করবে? তাদের মধ্যে আমার সমস্ত অলৌকিক চিহ্নকাজ প্রদর্শিত হওয়া সত্ত্বেও, কত কাল তারা আমাকে বিশ্বাস করতে অস্বীকার করবে? ");
INSERT INTO benobcv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","আমি তাদের মহামারির মাধ্যমে আঘাত করে ধ্বংস করব এবং তোমাকে এক মহত্তর ও তাদের অপেক্ষাও শক্তিধর জাতিতে পরিণত করব।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","মোশি সদাপ্রভুকে বললেন, “যখন মিশরীয়রা এই কথা শুনতে পাবে! তোমরা শক্তিবলে এই লোকদেরকে, তুমি তাদের মধ্য থেকে বের করে নিয়ে এসেছিলে। ");
INSERT INTO benobcv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","তারা এই দেশনিবাসী সবাইকে সেই কথা বলবে। তারা ইতিমধ্যেই শুনেছে, তুমি সদাপ্রভু, এই লোকদের সহবর্তী আছ এবং সদাপ্রভু, তুমি সামনাসামনি এদের দর্শন দিয়ে থাকো। তোমার মেঘ এদের উপরে অবস্থান করে এবং তুমি এদের পুরোভাগে থেকে, দিনের বেলায় মেঘস্তম্ভে ও রাত্রিবেলায় অগ্নিস্তম্ভে গমন করো। ");
INSERT INTO benobcv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","যদি তুমি এদের সবাইকে একসঙ্গে বিনাশ করো, কাউকে জীবিত না রাখ, তাহলে যে জাতিসমূহ তোমার সম্পর্কে এই সমস্ত কথা শুনেছে, তারা বলবে, ");
INSERT INTO benobcv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘সদাপ্রভু শপথ করে যে দেশ এই জাতিকে দেওয়ার প্রতিজ্ঞা করেছিলেন, তা দিতে সক্ষম হলেন না, তাই তিনি প্রান্তরে তাদের বধ করলেন।’ ");
INSERT INTO benobcv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“এখন সদাপ্রভুর শক্তি প্রদর্শিত হোক, যেভাবে তুমি ঘোষণা করেছ, ");
INSERT INTO benobcv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘সদাপ্রভু ক্রোধে ধীর, প্রেমে সমৃদ্ধ, পাপ ও বিদ্রোহ ক্ষমা করেন। তা সত্ত্বেও অপরাধীকে শাস্তি না দিয়ে তিনি ছেড়ে দেন না; তৃতীয় ও চতুর্থ প্রজন্ম পর্যন্ত তিনি বাবা-মার পাপের জন্য তাদের সন্তানদের শাস্তি দেন।’ ");
INSERT INTO benobcv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","তোমার মহান প্রেমবশত লোকেদের পাপ মার্জনা করো, ঠিক যে রকম ভাবে, মিশর পরিত্যাগ করার সময় থেকে, এ পর্যন্ত তাদের মার্জনা করে এসেছ।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","সদাপ্রভু উত্তর দিলেন, “তুমি যেমন চেয়েছ, আমি তাদের ক্ষমা করেছি। ");
INSERT INTO benobcv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","তা সত্ত্বেও, আমার জীবনের দিব্য এবং সমস্ত পৃথিবী সদাপ্রভুর প্রতাপে পরিপূর্ণ হবে, ");
INSERT INTO benobcv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","যত লোক আমার প্রতাপ এবং মিশরে ও প্রান্তরে আমার সাধিত অলৌকিক কাজগুলি প্রত্যক্ষ করেছে, কিন্তু আমাকে অমান্য করে দশবার আমার পরীক্ষা করেছে, ");
INSERT INTO benobcv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","তাদের মধ্যে একজনও কখনোই সেই দেশ দেখতে পাবে না, যা আমি শপথপূর্বক, তাদের পূর্বপুরুষদের দান করার প্রতিজ্ঞা করেছিলাম। যারা আমাকে অবজ্ঞা করেছে তাদের মধ্যে কেউই, কখনোই সেই দেশ দেখতে পাবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","কিন্তু, যেহেতু আমার সেবক কালেবের অন্তরে এক ভিন্নতর আত্মা আছে এবং যে সর্বান্তঃকরণে আমার অনুগামী হয়েছে, তাই যে দেশে সে গিয়েছিল, আমি তাকে সেই দেশে নিয়ে যাব এবং তাঁর বংশধরেরা সেই দেশ অধিকার করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","যেহেতু উপত্যকাসমূহে অমালেকীয় ও কনানীয়েরা বসতি করে, সেইজন্য আগামীকাল বিপরীতমুখী হও এবং লোহিত সাগরের পথ দিয়ে প্রান্তরের অভিমুখে যাত্রারম্ভ করো।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“কত কাল এই দুষ্ট জনতা আমার বিপক্ষে বচসা করবে? আমি বচসাকারী এই সমস্ত ইস্রায়েলীদের অভিযোগ শুনেছি। ");
INSERT INTO benobcv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","তাই তাদের বলো, ‘সদাপ্রভু এই কথা ঘোষণা করেন, আমার জীবনের দিব্য, তোমরা যে কথা বলেছ, আমি তোমাদের জন্য সেই কাজই করব। ");
INSERT INTO benobcv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","যাদের বয়স কুড়ি বছর বা তারও বেশি, জনগণনায় যারা অন্তর্ভুক্ত হয়েছিল এবং আমার বিপক্ষে যারা বচসা করেছে, তাদের প্রত্যেকের দেহ এই প্রান্তরে নিপাতিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","তোমাদের মধ্যে একজন ব্যক্তিও সেই দেশে প্রবেশ করবে না, যা তোমাদের বাসভূমি হবে বলে আমি হস্ত উত্তোলন পূর্বক শপথ করেছিলাম। শুধুমাত্র যিফূন্নির ছেলে কালেব ও নূনের ছেলে যিহোশূয় হবে ব্যতিক্রম। ");
INSERT INTO benobcv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","কিন্তু যে সমস্ত শিশুর সম্পর্কে তোমরা বলেছিলে যে তারা লুন্ঠিত হবে, আমি তাদের সেই দেশে নিয়ে যাব, যে দেশ তোমরা প্রত্যাখ্যান করেছ। ");
INSERT INTO benobcv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","কিন্তু তোমাদের দেহ এই মরুভূমিতে পতিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","তোমাদের সন্তানেরা চল্লিশ বছর এখানে পশু চরাবে, তোমাদের অবিশ্বস্ততার জন্য তারা কষ্টভোগ করবে, যতদিন না তোমাদের শেষ ব্যক্তির দেহ এই প্রান্তরে কবরস্থ হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","চল্লিশ বছর পর্যন্ত, দেশ পরিক্রমা করার উদ্দেশে চল্লিশ দিনের জন্য, এক একদিনের পরিবর্তে এক এক বছর, তোমরা তোমাদের পাপের পরিণতি ভোগ করবে। তোমরা উপলব্ধি করবে, আমার বিপক্ষতা করা, কতই না ভয়ানক বিষয়!’ ");
INSERT INTO benobcv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","আমি সদাপ্রভু এই কথা বলেছি, এর সমস্তই এই দুষ্ট সমাজের প্রতি পূর্ণ করব, যারা একসঙ্গে আমার বিপক্ষতা করার উদ্দেশে জোটবদ্ধ হয়েছে। তারা তাদের অন্তিমদশা এই প্রান্তরে দেখতে পাবে। তারা সবাই এখানেই মরবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","তাই, মোশি যাদের দেশ নিরীক্ষণ করতে পাঠিয়েছিলেন তারা ফিরে এসে সেই দেশ সম্পর্কে বিরূপ মন্তব্য করে সমস্ত সমাজকে বচসা করতে প্ররোচিত করেছিল, ");
INSERT INTO benobcv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","সেই ব্যক্তিরা, যারা সেই দেশ সম্পর্কে বিরূপ মন্তব্য করছিল, তারা সদাপ্রভুর সামনে এক মহামারিতে আক্রান্ত হয়ে মরল। ");
INSERT INTO benobcv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","যারা দেশ পরিক্রমা করতে গিয়েছিল, তাদের মধ্যে কেবল নূনের ছেলে যিহোশূয় ও যিফূন্নির ছেলে কালেব অবশিষ্ট রইলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","মোশি যখন ইস্রায়েলীদের সবাইকে এই সংবাদ দিলেন, তারা খুব কান্নাকাটি করল। ");
INSERT INTO benobcv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","পরদিন ভোরবেলায়, তারা উঁচু পর্বতাঞ্চলে আরোহণ করল। তারা বলল, “আমরা পাপ করেছি। সদাপ্রভু যে দেশের বিষয় প্রতিজ্ঞা করেছেন, আমরা সেখানে যাব।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","কিন্তু মোশি উত্তর দিলেন, “তোমরা সদাপ্রভুর আদেশ কেন লঙ্ঘন করেছ? এভাবে কৃতকার্য হবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","উপরে উঠে যাবে না, কারণ সদাপ্রভু তোমাদের সহবর্তী নন। তোমরা শত্রুদের হাতে পরাজিত হবে, ");
INSERT INTO benobcv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","কারণ অমালেকীয় ও কনানীয়েরা সেখানে তোমাদের সম্মুখীন হবে। যেহেতু তোমরা সদাপ্রভুর কাছ থেকে বিপথগমন করেছ, তিনি আর তোমাদের সহবর্তী থাকবেন না এবং তরোয়াল দ্বারা তোমাদের পতন হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","তা সত্ত্বেও, সম্ভাব্য ঝুঁকি নিয়ে, তারা উঁচু পর্বতে অবস্থিত নগরে উঠে গেল, যদিও মোশি, অথবা সদাপ্রভুর নিয়ম-সিন্দুক ছাউনি থেকে অগ্রসর হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","তখন সেই পাহাড়ি এলাকায় বসবাসকারী অমালেকীয় ও কনানীয়েরা নেমে এসে তাদের আক্রমণ করল এবং হর্মা পর্যন্ত মারতে মারতে নিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ইস্রায়েলীদের সঙ্গে কথা বলো, তাদের বলো, ‘যে দেশ তোমাদের বাসভূমি বলে আমি দান করেছি, সেখানে প্রবেশ করার পর, ");
INSERT INTO benobcv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","তোমরা সদাপ্রভুর কাছে গবাদি পশুপাল অথবা মেষপাল থেকে, আগুনের মাধ্যমে, সদাপ্রভুর আনন্দদায়ক সুরভিস্বরূপ নৈবেদ্য নিয়ে আসবে। সেই নৈবেদ্য হোম-নৈবেদ্য বা পশুবলি, বিশেষ মানতের উদ্দেশে বা স্বেচ্ছাদত্ত উপহার, অথবা উৎসবের বলি, যাইহোক না কেন, নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","তখন যে ব্যক্তি তার নৈবেদ্য নিয়ে আসবে, সে এক ঐফার এক-দশমাংশ মিহি ময়দা, হিনের এক-চতুর্থাংশ জলপাই তেলের সঙ্গে মিশ্রিত করে, শস্য-নৈবেদ্য সদাপ্রভুকে উপহার দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","হোম-নৈবেদ্যের প্রত্যেকটি মেষশাবক, অথবা অন্য পশুবলির সঙ্গে, হিনের এক-চতুর্থাংশ দ্রাক্ষারস দিয়ে পেয়-নৈবেদ্য প্রস্তুত করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘একটি মেষের সঙ্গে এক ঐফার দুই-দশমাংশ ও মিহি ময়দা নিয়ে, হিনের এক-তৃতীয়াংশ জলপাই তেল মিশ্রিত করে শস্য-নৈবেদ্য ");
INSERT INTO benobcv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","এবং সেই সঙ্গে হিনের এক-তৃতীয়াংশ দ্রাক্ষারস দিয়ে পেয়-নৈবেদ্য প্রস্তুত করবে। সদাপ্রভুর আনন্দদায়ক সুরভিরূপে এই সমস্ত নিবেদন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘যখন তোমার একটি এঁড়ে বাছুর হোম-নৈবেদ্য বা বলিরূপে নিয়ে আসবে, সদাপ্রভুর উদ্দেশে কোনও বিশেষ মানত পূরণ অথবা মঙ্গলার্থক-নৈবেদ্যের জন্য, ");
INSERT INTO benobcv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","তখন সেই এঁড়ে বাছুরের সঙ্গে এক ঐফার তিন-দশমাংশ মিহি ময়দার সঙ্গে অর্ধ হিন জলপাই তেল মিশ্রিত করে শস্য-নৈবেদ্য নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","সেই সঙ্গে অর্ধ হিন দ্রাক্ষারস, পেয়-নৈবেদ্যরূপে নিয়ে আসবে। এটি ভক্ষ্য-নৈবেদ্য, সদাপ্রভুর আনন্দদায়ক সুরভিরূপে, আগুনের মাধ্যমে নিবেদিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","প্রত্যেকটি ষাঁড় অথবা মেষ, প্রত্যেকটি মেষশাবক অথবা ছাগশিশু, এইরূপে আয়োজন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","তোমরা তাদের সংখ্যানুসারে প্রত্যেকটি ক্ষেত্রে একই ধরনের করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘স্বদেশে জাত প্রত্যেক ব্যক্তি, যখন সে সদাপ্রভুর আনন্দদায়ক সুরভিরূপে ভক্ষ্য-নৈবেদ্য নিয়ে আসে, তখন এই সমস্ত বিষয় এভাবেই করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ভবিষ্যৎ প্রজন্মের জন্য, তোমাদের মধ্যে বসবাসকারী কোনো বিদেশি বা অন্য কেউ যদি সদাপ্রভুর আনন্দদায়ক সুরভিরূপে ভক্ষ্য-নৈবেদ্য উৎসর্গ করে, সে ঠিক তোমাদের মতোই করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","সমাজের মধ্যে তোমাদের এবং তোমাদের মধ্যে বসবাসকারী বিদেশিদের জন্যও একই বিধি প্রযোজ্য হবে। ভবিষ্যৎ প্রজন্মের জন্যও এই বিধি চিরস্থায়ী। সদাপ্রভুর সামনে তোমরা এবং বিদেশি ব্যক্তি, উভয়ই সমান প্রতিপন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","অভিন্ন বিধি ও নিয়ম তোমাদের ও তোমাদের মধ্যে বসবাসকারী বিদেশিদের ক্ষেত্রে প্রযোজ্য হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ইস্রায়েলীদের সঙ্গে কথা বলো, তাদের বলো, ‘যেখানে আমি তোমাদের নিয়ে যাচ্ছি, যখন তোমরা সেই দেশে প্রবেশ করবে ");
INSERT INTO benobcv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","এবং সেই দেশের খাদ্যদ্রব্য আহার করবে, তখন তার একটু অংশ নিয়ে সদাপ্রভুর কাছে নৈবেদ্যরূপে উপহার দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","তোমাদের ভূমিজাত প্রথম খাদ্যদ্রব্য থেকে একটি পিঠে নিবেদন করবে; খামারের উত্তোলনীয় নৈবেদ্য বলেই সেটি উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","পুরুষ-পরম্পরায় তোমাদের প্রথম ভূমিজাত খাদ্যদ্রব্যের এই উত্তোলনীয় নৈবেদ্য সদাপ্রভুর উদ্দেশে নিবেদন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘এখন মোশিকে দত্ত সদাপ্রভুর এই আদেশসমূহের কোনো একটি, তোমরা সমাজরূপে যদি অনিচ্ছাকৃতভাবে, পালন করতে ব্যর্থ হও, ");
INSERT INTO benobcv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","এমনকি সদাপ্রভু যে দিনে তোমাদের আদেশ দিয়েছেন, সেদিন থেকে পুরুষ-পরম্পরায় তোমাদের জন্য সদাপ্রভু মোশির মাধ্যমে তোমাদের যত আদেশ দিয়েছেন, ");
INSERT INTO benobcv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","সেসব যদি অনিচ্ছাকৃতভাবে পালন না করো এবং তা যদি সমাজের অজ্ঞাতসারে হয়, তাহলে সমস্ত সমাজ, হোম-নৈবেদ্যরূপে, সদাপ্রভুর আনন্দদায়ক সুরভির জন্য, এক এঁড়ে বাছুর উৎসর্গ করবে ও সেই সম্পর্কিত শস্য-নৈবেদ্য, পেয়-নৈবেদ্য এবং পাপার্থক বলির জন্য একটি ছাগল উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","যাজক সমস্ত ইস্রায়েলী সমাজের জন্য প্রায়শ্চিত্ত করবে এবং তাদের পাপ ক্ষমা করা হবে। যেহেতু তাদের অন্যায়ের জন্য তারা সদাপ্রভুর কাছে ভক্ষ্য-নৈবেদ্য ও পাপার্থক বলি নিয়ে আসবে, কারণ সেই পাপ ইচ্ছাকৃত ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","সমস্ত ইস্রায়েলী সমাজ এবং তাদের মধ্যবর্তী বসবাসকারী বিদেশিদের ক্ষমা করা হবে, যেহেতু সব লোক সেই অনিচ্ছাকৃত অন্যায়ে জড়িত ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘কিন্তু যদি মাত্র একজন ব্যক্তি অনিচ্ছাকৃতভাবে পাপ করে, সে পাপার্থক বলির জন্য একটি এক বর্ষীয় ছাগী নিয়ে আসবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","যাজক সেই ব্যক্তির জন্য সদাপ্রভুর সামনে প্রায়শ্চিত্ত করবে, যে অনিচ্ছাকৃতভাবে পাপ করে অন্যায় করেছিল যখন তাঁর জন্য প্রায়শ্চিত্ত সম্পন্ন হবে তার পাপ ক্ষমা হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","যারা অনিচ্ছাকৃত পাপ করে, তাদের প্রত্যেকের জন্য সেই একই বিধি প্রযোজ্য হবে, সে স্বদেশি ইস্রায়েলী হোক, অথবা তাদের মধ্যে বসবাসকারী বিদেশি ব্যক্তি। ");
INSERT INTO benobcv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘কিন্তু যদি কোনো স্বদেশি বা বিদেশি ব্যক্তি ঔদ্ধত্য দেখিয়ে পাপ করে, যদি সে সদাপ্রভুর নিন্দা করে, সেই ব্যক্তি, তার জনগোষ্ঠী থেকে উচ্ছিন্ন হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","কারণ সে সদাপ্রভুর আদেশ প্রত্যাখ্যান করেছে ও তাঁর বিধি লঙ্ঘন করেছে। সেই ব্যক্তি নিশ্চিতরূপে উচ্ছিন্ন হবে; কারণ তার অপরাধ তার উপরে বর্তাবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ইস্রায়েলীরা যখন প্রান্তরে ছিল, তখন একজন ব্যক্তিকে বিশ্রামবারে কাঠ সংগ্রহ করতে দেখা গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","যারা তাকে কাঠ সংগ্রহ করতে দেখেছিল, তারা তাকে মোশি, হারোণ এবং সমস্ত সমাজের কাছে উপস্থিত করল। ");
INSERT INTO benobcv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","তাঁরা তাকে অবরুদ্ধ করে রাখলেন, কারণ তার প্রতি কী করণীয়, তা সুস্পষ্ট জানা ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","তখন সদাপ্রভু মোশিকে বললেন, “লোকটি অবশ্যই মরবে। সমস্ত সমাজ তাকে ছাউনির বাইরে নিয়ে গিয়ে প্রস্তরাঘাত করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","অতএব সমস্ত সমাজ তাকে ছাউনির বাইরে নিয়ে গেল এবং যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন, তাকে প্রস্তরাঘাতে বধ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ইস্রায়েলীদের সঙ্গে কথা বলো, তাদের বলো, ‘পুরুষ-পরম্পরায় তোমাদের পরিধেয় বস্ত্রের কোণে থোপ দেবে। প্রত্যেক থোপ নীল রংয়ের সুতো দিয়ে তৈরি হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","তোমরা এই সমস্ত থোপ প্রত্যক্ষ করলে, সদাপ্রভুর বিধিগুলি স্মরণে আনতে পারবে; তাহলে তোমরা সেই সমস্ত পালন করে তোমাদের হৃদয় ও চোখের অভিলাষ অনুসারে ব্যভিচার করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","তখন তোমরা আমার আদেশগুলি পালন করার বিষয় স্মরণে আনবে এবং তোমাদের ঈশ্বরের উদ্দেশে পবিত্র হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","আমি সদাপ্রভু, তোমাদের ঈশ্বর, যিনি মিশর থেকে তোমাদের ঈশ্বর হওয়ার জন্য তোমাদের মুক্ত করে এনেছি। আমিই সদাপ্রভু, তোমাদের ঈশ্বর।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","লেবির ছেলে কহাৎ, তার ছেলে যিষ্‌হর, তার ছেলে কোরহ এবং কয়েকজন রূবেণ গোষ্ঠীর ব্যক্তি—ইলীয়াবের ছেলে দাথন ও অবীরাম এবং পেলতের ছেলে ওন—উদ্ধত হল ");
INSERT INTO benobcv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","এবং মোশির বিপক্ষতা করল। তাদের সঙ্গে 250 জন ইস্রায়েলী পুরুষ ছিল, যারা প্রত্যেকে সমাজের সুপরিচিত নেতা ছিল, যাদের মন্ত্রণা-সভার সদস্য নিযুক্ত করা হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","তারা দলবদ্ধ হয়ে মোশি ও হারোণের বিরোধিতা করতে এল এবং তাঁদের বলল, “তোমাদের স্পর্ধা বহুদূর বিস্তৃত হয়েছে! সমস্ত সমাজ পবিত্র, প্রত্যেক ব্যক্তিই পবিত্র এবং সদাপ্রভু তাদের সহবর্তী আছেন। তাহলে কেন তোমরা নিজেদের অবস্থান সদাপ্রভুর সমাজের ঊর্ধ্বে উন্নীত করেছ?” ");
INSERT INTO benobcv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","মোশি এই কথা শুনে ভূমিতে উপুড় হয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","তিনি কোরহ ও তার অনুগামীদের বললেন, “সকালবেলায় সদাপ্রভু প্রকাশ করবেন, কে তাঁর অধিকারভুক্ত এবং কে পবিত্র। তিনি সেই ব্যক্তিকে তাঁর নিকটবর্তী করবেন। যে ব্যক্তিকে তিনি মনোনীত করেন, সেই তাঁর নিকটবর্তী হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","কোরহ, তুমি ও তোমার অনুগামী সবাই এই কাজ করো, অঙ্গারধানী নাও ");
INSERT INTO benobcv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","এবং আগামীকাল তার মধ্যে আগুন ও ধূপ দিয়ে, সদাপ্রভুর সামনে নিবেদন করো। যে ব্যক্তিকে সদাপ্রভু মনোনীত করেন, সেই ব্যক্তি পবিত্র গণ্য হবে। লেবীয়রা, তোমাদের স্পর্ধা সীমা ছাড়িয়ে গেছে!” ");
INSERT INTO benobcv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","মোশি কোরহকে এই কথাও বললেন, “লেবীয়েরা তোমরা এই কথা শোনো! ");
INSERT INTO benobcv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ইস্রায়েলের ঈশ্বর, অবশিষ্ট সমাজ থেকে তোমাদের পৃথক করে, তাঁর সান্নিধ্যে নিয়ে এসেছেন, যেন তোমরা সদাপ্রভুর আবাস তাঁবুর কাজকর্ম করো এবং সমাজের সামনে দাঁড়িয়ে থেকে তাদের পরিচর্যা করো, এই কি তোমাদের জন্য যথেষ্ট ছিল না? ");
INSERT INTO benobcv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","তিনি তোমাদের ও তোমাদের সহচর লেবীয়দের তাঁর নিকটস্থ করেছেন, কিন্তু এখন তোমরা যাজকত্ব পদের জন্যও চেষ্টা করছ। ");
INSERT INTO benobcv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","তোমরা ও তোমাদের অনুগামী সবাই, সদাপ্রভুর বিপক্ষেই জোটবদ্ধ হয়েছ। হারোণ কে যে তোমরা তার বিপক্ষে বচসা করো?” ");
INSERT INTO benobcv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","মোশি ইলীয়াবের ছেলে দাথন ও অবীরামকে ডেকে পাঠালেন, কিন্তু তারা বলল, “আমরা যাব না। ");
INSERT INTO benobcv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","তুমি এক দুধ ও মধু প্রবাহী দেশ থেকে, এই প্রান্তরে আমাদের মেরে ফেলতে এনেছ, এই কি যথেষ্ট নয়? এখন আমাদের উপর প্রভুত্ব করতে চাইছ? ");
INSERT INTO benobcv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","এছাড়াও, এখনও তুমি আমাদের কোনো দুধ ও মধু প্রবাহী দেশে নিয়ে যাওনি অথবা শস্যক্ষেত্র ও দ্রাক্ষাকুঞ্জের কোনো অধিকার দান করোনি। তুমি কি এই সমস্ত ব্যক্তির সঙ্গে ক্রীতদাসের মতো ব্যবহার করবে? না, আমরা যাব না!” ");
INSERT INTO benobcv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","মোশি তখন অত্যন্ত ক্রুদ্ধ হয়ে সদাপ্রভুকে বললেন, “ওই ব্যক্তিদের নৈবেদ্য গ্রহণ কোরো না। আমি তাদের কাছ থেকে, সর্বাধিক একটি গাধাও গ্রহণ করিনি অথবা তাদের কারও প্রতি কোনো অন্যায় আচরণ করিনি।” ");
INSERT INTO benobcv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","মোশি কোরহকে বললেন, “তুমি ও তোমার সমস্ত অনুগামী, আগামীকাল সদাপ্রভুর সামনে উপস্থিত হবে—তুমি, তারা সবাই এবং হারোণ। ");
INSERT INTO benobcv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","প্রত্যেক ব্যক্তি অঙ্গারধানী নেবে—সর্বমোট 250-টি অঙ্গারধানী—এবং সদাপ্রভুর সামনে নিবেদন করতে হবে।” তুমি ও হারোণ তোমাদের অঙ্গারধানীও সদাপ্রভুর সামনে নিবেদন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","অতএব তারা প্রত্যেকে তাদের অঙ্গারধানী নিল ও তার মধ্যে আগুন ও ধূপ রাখল। তারপর তারা মোশি ও হারোণের সঙ্গে সমাগম তাঁবুর প্রবেশপথে দাঁড়াল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","যখন কোরহ তার অনুগামীদের, তাঁদের বিপক্ষে সমাগম তাঁবুর প্রবেশপথে একত্র করল, তখন সদাপ্রভুর মহিমা সমস্ত সমাজের কাছে প্রত্যক্ষ হল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“তোমরা নিজেদের এই সমাজ থেকে পৃথক করো, যেন এক মুহূর্তে আমি তাদের বিলুপ্ত করি।” ");
INSERT INTO benobcv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","কিন্তু মোশি ও হারোণ ভূমিতে উপুড় হয়ে উচ্চস্বরে বললেন, “হে ঈশ্বর, সমস্ত জীবিত বস্তুর আত্মাদের ঈশ্বর, যখন কোনো একজন ব্যক্তি পাপ করে, তখন তাঁর জন্য কি তুমি সমস্ত সমাজের প্রতি রুষ্ট হবে?” ");
INSERT INTO benobcv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“তুমি সমাজকে বলো, ‘তোমরা কোরহ, দাথন ও অবীরামের তাঁবুর কাছ থেকে সরে যাও।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","মোশি উঠে দাথন ও অবীরামের কাছে গেলেন এবং ইস্রায়েলের প্রবীণেরা তাঁকে অনুসরণ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","তিনি সমাজকে সাবধান করে দিয়ে বললেন, “এই দুষ্ট ব্যক্তিদের তাঁবু থেকে সরে যাও! তাদের কোনো জিনিস স্পর্শ করো না, তা না হলে, তাদের পাপের জন্য তোমরাও বিনষ্ট হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","অতএব তারা কোরহ, দাথন ও অবীরামের তাঁবুর কাছ থেকে সরে গেল। দাথন ও অবীরাম, তাদের স্ত্রী, সন্তান ও শিশুসহ তাঁবু থেকে বের হয়ে প্রবেশপথে দাঁড়িয়ে রইল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","মোশি তখন বললেন, “এবার তোমরা অবগত হবে যে সদাপ্রভু এই সমস্ত কাজ করবার জন্য আমাকেই প্রেরণ করেছেন এবং কোনোটিই আমার কল্পনাপ্রসূত নয়। ");
INSERT INTO benobcv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","যদি এই ব্যক্তিরা স্বাভাবিক মৃত্যুবরণ করে ও মানুষমাত্রের প্রতি যা ঘটে থাকে, তাই ভোগ করে, তাহলে সদাপ্রভু আমাকে পাঠাননি। ");
INSERT INTO benobcv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","কিন্তু সদাপ্রভু যদি সম্পূর্ণ নতুন কিছু করেন, ভূমি মুখ বিদীর্ণ করে সমস্ত দ্রব্য সমেত তাদের গ্রাস করে এবং যদি তারা জীবিত অবস্থায় সমাধিপ্রাপ্ত হয়, তাহলে তোমরা অবগত হবে যে এই ব্যক্তিরা সদাপ্রভুর অবমাননা করেছে।” ");
INSERT INTO benobcv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","যে মুহূর্তে তিনি এই সমস্ত কথা সমাপ্ত করলেন, তাদের নিম্নস্থ ভূমি বিদীর্ণ হল, ");
INSERT INTO benobcv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ভূমি তার মুখ বিদীর্ণ করে কোরহ, তার সব অনুগামী ও তার আত্মীয়স্বজনদের, সমস্ত বিষয়সম্পত্তি গ্রাস করল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","তাদের অধিকারভুক্ত সমস্ত দ্রব্যসহ তারা জীবিত অবস্থায় সমাধিপ্রাপ্ত হল। ভূমি তাদের অবরুদ্ধ করল। তারা বিনাশপ্রাপ্ত হয়ে সমাজ থেকে অবলুপ্ত হল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","তাদের আর্তস্বর শুনে, চতুর্দিকের ইস্রায়েলীরা পলায়ন করল। তারা চিৎকার করে বলে উঠল, “ভূমি আমাদেরও গ্রাস করবে!” ");
INSERT INTO benobcv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","সদাপ্রভুর কাছ থেকে আগুন নির্গত হয়ে, যারা ধূপ নিবেদন করেছিল, সেই 250 জন ব্যক্তিকেও পুড়িয়ে দিল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“যাজক হারোণের ছেলে ইলীয়াসরকে বলো, সব অঙ্গারধানী নিয়ে, তাদের অবশিষ্ট অঙ্গার, দূরে কোথাও ফেলে দিতে, কারণ ওইসব অঙ্গারধানী পবিত্র। ");
INSERT INTO benobcv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","সেই লোকদের অঙ্গারধানী যারা নিজেদের জীবনের প্রতিকূলে পাপ করেছিল। অঙ্গারধানীগুলি হাতুড়ি দিয়ে পিটিয়ে বেদির আচ্ছাদনের জন্য পাত প্রস্তুত করো, কারণ সেসব সদাপ্রভুর উদ্দেশে নিবেদিত হয়েছিল, তাই পবিত্র। সেগুলি ইস্রায়েলীদের জন্য নিদর্শনস্বরূপ হোক।” ");
INSERT INTO benobcv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","অতএব যাজক ইলীয়াসর, যারা পুড়ে মরেছিল, তাদের আনা পিতলের সেইসব অঙ্গারধানী নিলেন এবং সেগুলি পিটিয়ে বেদির আচ্ছাদনের জন্য পাত প্রস্তুত করলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","যে রকম সদাপ্রভু, মোশির মাধ্যমে, তাঁকে নির্দেশ দিয়েছিলেন। এই নিদর্শন ছিল ইস্রায়েলীদের স্মরণার্থক, যেন হারোণের উত্তরসূরি ব্যতীত অন্য কেউ সদাপ্রভুর উদ্দেশে ধূপদাহ না করে; তা না হলে, তার পরিণতি কোরহ ও তার অনুগামীদের মতোই হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","পরদিন, সমস্ত ইস্রায়েলী সমাজ, মোশি ও হারোণের বিপক্ষে বচসা করল। তারা বলল, “আপনারাই সদাপ্রভুর প্রজাদের হত্যা করলেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","যখন সেই সমাজ মোশি ও হারোণের বিপক্ষে একত্র হল এবং সমাগম তাঁবুর অভিমুখে ফিরল, হঠাৎ মেঘ তা আবৃত করল এবং সদাপ্রভুর মহিমা প্রত্যক্ষ হল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","তখন মোশি ও হারোণ, সমাগম তাঁবুর সামনে গেলেন ");
INSERT INTO benobcv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","এবং সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“এই সমাজ থেকে পৃথক হও যেন আমি এক নিমেষেই এদের বিলুপ্ত করি।” তাঁরা ভূমিতে উপুড় হয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","মোশি তারপর হারোণকে বললেন, “তোমার অঙ্গারধানী নাও, বেদি থেকে অঙ্গার নিয়ে তার মধ্যে আগুন ও ধূপ দাও এবং তাড়াতাড়ি সমাজের মধ্যে গিয়ে তাদের জন্য প্রায়শ্চিত্ত করো। সদাপ্রভুর রোষ নির্গত হয়েছে; মহামারি শুরু হয়ে গিয়েছে।” ");
INSERT INTO benobcv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","মোশি যে রকম বললেন, হারোণ ঠিক তাই করলেন, তিনি সমাজের মধ্যে দৌড়ে গেলেন। ততক্ষণে জনতার মধ্যে মহামারি ছড়িয়ে পড়েছিল, কিন্তু হারোণ ধূপ দিয়ে তাদের জন্য প্রায়শ্চিত্ত করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","তিনি জীবিত ও মৃত, এই উভয় দলের মধ্যে দণ্ডায়মান হলেন এবং মহামারি নিবৃত্ত হল। ");
INSERT INTO benobcv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","কোরহের জন্য যারা নিহত হয়েছিল, তাদের অতিরিক্ত, ওই মহামারিতে নিহতের সংখ্যা 14,700। ");
INSERT INTO benobcv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","পরে হারোণ সমাগম তাঁবুর প্রবেশপথে, মোশির কাছে ফিরে গেলেন, কারণ মহামারি নিবৃত্ত হয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ইস্রায়েলীদের সঙ্গে কথা বলো এবং তাদের কাছ থেকে প্রত্যেক পিতৃকুলের নেতা প্রতি একটি করে, বারোটি লাঠি গ্রহণ করো। প্রত্যেক ব্যক্তির নাম তার লাঠিতে লেখো। ");
INSERT INTO benobcv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","লেবির লাঠিতে হারোণের নাম লিখবে, কারণ প্রত্যেক পিতৃকুলের শীর্ষ নেতার একটি করে লাঠি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","সেগুলি নিয়ে, যেখানে আমি তোমার সঙ্গে দেখা করি, সমাগম তাঁবুর সেই সাক্ষ্য-সিন্দুকের সামনে রাখো। ");
INSERT INTO benobcv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","যে ব্যক্তিকে আমি মনোনীত করব তার লাঠি অঙ্কুরিত হবে এবং আমি আমার বিপক্ষে ইস্রায়েলীদের নিরবচ্ছিন্ন অসন্তোষ থেকে অব্যহতি পাব।” ");
INSERT INTO benobcv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","আর মোশি ইস্রায়েলীদের সঙ্গে কথা বললেন এবং তাদের নেতৃবৃন্দ তাঁকে প্রত্যেক পিতৃকুলের প্রধানের জন্য একটি করে বারোটি লাঠি দিলেন। হারোণের লাঠিও তাদের মধ্যে ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","মোশি সাক্ষ্য তাঁবুর মধ্যে সেই লাঠিগুলি সদাপ্রভুর সামনে রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","পরদিন, মোশি সাক্ষ্য তাঁবুতে প্রবেশ করে দেখলেন, লেবির কূলসূচক হারোণের লাঠি; শুধুমাত্র যে অঙ্কুরিত হয়েছে, তা নয় কিন্তু মুকুলিত ও পুষ্পিত হয়েছে এবং কাঠবাদামও ধরেছে। ");
INSERT INTO benobcv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","তখন মোশি, লাঠিগুলি সদাপ্রভুর কাছ থেকে বাইরে, ইস্রায়েলীদের কাছে নিয়ে এলেন। তারা সেগুলি দেখল এবং প্রত্যেক নেতা নিজের নিজের লাঠি গ্রহণ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","সদাপ্রভু মোশিকে বললেন, “হারোণের লাঠি আবার সাক্ষ্য-সিন্দুকের সামনে রাখো, তা বিদ্রোহীকুলের পক্ষে নিদর্শনস্বরূপ হবে। এরপরে তারা আমার বিপক্ষে বচসা করতে নিবৃত্ত হবে এবং তারা যেন আর না মরে।” ");
INSERT INTO benobcv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","মোশি ঠিক তাই করলেন, যে রকম সদাপ্রভু তাকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ইস্রায়েলীরা মোশিকে বলল, “আমরা মারা যাব! আমরা বিনাশপ্রাপ্ত হয়েছি, প্রত্যেকেই বিনষ্ট হলাম! ");
INSERT INTO benobcv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","যে কেউ সদাপ্রভুর আবাস তাঁবুর কাছেও যদি আসে, সে মারা পড়বে। আমরা কি সবাই মরব?” ");
INSERT INTO benobcv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","সদাপ্রভু হারোণকে বললেন, “তুমি, তোমার ছেলেরা এবং তোমার পিতৃকুল, পবিত্রস্থানের বিপক্ষে কৃত অপরাধের জন্য দায়ী হবে এবং তুমি ও তোমার ছেলেরা যাজকত্ব পদের বিপক্ষে কৃত অপরাধের জন্য দায়ী হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","তোমার পিতৃকুল থেকে সহচর লেবীয়দের নিয়ে এসো। যখন তুমি ও তোমার ছেলেরা সাক্ষ্য তাঁবুর সামনে পরিচর্যা করো, তারা তোমার সঙ্গে যোগ দিয়ে তোমাদের সাহায্য করুক। ");
INSERT INTO benobcv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","তারা তোমার প্রতি দায়িত্বশীল থাকবে এবং তারা তাঁবুর সংশ্লিষ্ট সমস্ত কাজ করবে, কিন্তু পবিত্রস্থানের আসবাব অথবা যজ্ঞবেদির কাছে যাবে না, নতুবা তুমি এবং তারা উভয়ই মারা পড়বে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","তারা তোমার সঙ্গে যুক্ত হয়ে সাক্ষ্য তাঁবুর তত্ত্বাবধানের জন্য দায়ী হবে, তাঁবু সংক্রান্ত সমস্ত কাজের জন্যই, কিন্তু কেউই যেখানে তোমরা থাকবে সেখানে যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“তুমি পবিত্রস্থান ও যজ্ঞবেদির জন্য দায়ী হবে, যেন আবার ইস্রায়েলীদের উপর আমার রোষ না বর্তায়। ");
INSERT INTO benobcv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","আমি স্বয়ং তোমার সহচর লেবীয়দের, ইস্রায়েলীদের মধ্য থেকে মনোনীত করে, তোমাকে উপহার দিয়েছি, সদাপ্রভুর উদ্দেশে পবিত্র করেছি, যেন তারা সমাগম তাঁবুর কাজকর্ম করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","কিন্তু যজ্ঞবেদি সম্পর্কিত সমস্ত বিষয়ে এবং পর্দার অভ্যন্তরে শুধুমাত্র তুমি ও তোমার ছেলেরা যাজকরূপে পরিচর্যা করবে। আমি যাজকত্ব পদের পরিচর্যা, তোমাকে উপহারস্বরূপ দিয়েছি। অন্য কেউ যদি পবিত্রস্থানের কাছে যায়, তার প্রাণদণ্ড হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","তারপর সদাপ্রভু হারোণকে বললেন, “যে নৈবেদ্যগুলি আমার উদ্দেশে নিবেদিত হয়, আমি স্বয়ং তোমাকে সেসবের তত্ত্বাবধায়ক করেছি; সমস্ত পবিত্র উপহার, যা ইস্রায়েলীরা আমাকে নিবেদন করে, আমি তোমাকে ও তোমার ছেলেদের তোমাদের অংশ ও প্রাপ্য বলে দিয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","যে সমস্ত দ্রব্য অগ্নি আহুতি থেকে অবশিষ্ট থাকে, তুমি সেই অতি পবিত্র নৈবেদ্যর অংশ প্রাপ্ত হবে। সমস্ত উপহার, যা তারা অতি পবিত্র নৈবেদ্যরূপে নিয়ে আসে, অর্থাৎ শস্য বা পাপার্থক-নৈবেদ্য, সেই অংশে তোমার ও তোমার পুত্রগণের অধিকার থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","অত্যন্ত পবিত্র গণ্য করে তা ভোজন কোরো; প্রত্যেক পুরুষ তা ভোজন করবে, তুমি অবশ্যই তা পবিত্র বলে সম্মান করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“এই সমস্ত তোমার, ইস্রায়েলীদের আনীত দোলনীয়-নৈবেদ্যের উপহারসমূহ থেকে যা কিছু পৃথক করে রাখা হয়। আমি সেসব তোমাকে, তোমার ছেলে ও মেয়েদের, তোমাদের নিয়মিত প্রাপ্য অংশ বলে দিলাম। তোমার কুলের প্রত্যেক ব্যক্তি, যে আনুষ্ঠানিকভাবে শুচিশুদ্ধ, সে তা ভোজন করতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“তারা সদাপ্রভুর উদ্দেশে তাদের যেসব উৎকৃষ্ট জলপাই তেল, উত্তম নতুন দ্রাক্ষারস ও শস্য নিবেদন করে, যেসব অগ্রিমাংশ তারা উৎসর্গ করে, সে সমস্তই আমি তোমাকে দিলাম। ");
INSERT INTO benobcv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ভূমিজাত সমস্ত ফলের অগ্রিমাংশ যা তারা সদাপ্রভুর কাছে নিয়ে আসে, তা তোমাদেরই হবে। তোমরা পরিবারের প্রত্যেকে, যে আনুষ্ঠানিকভাবে শুচিশুদ্ধ, সে তা ভোজন করতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ইস্রায়েলের সবকিছুই, যা সদাপ্রভুর উদ্দেশে উৎসর্গীকৃত হয়, তা তোমার হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","মানুষ বা পশু, যাবতীয় প্রাণীর মধ্যে প্রথমজাত সব প্রাণীকে সদাপ্রভুর উদ্দেশে উৎসর্গ করবে, সে সব তোমার হবে। কিন্তু মনুষের প্রথমজাতকে এবং অশুচি পশুর প্রথমজাত পুংপশুকে তুমি অবশ্য মুক্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","যখন তাদের বয়স এক মাস হবে, তুমি তাদের নির্ধারিত মুক্তির মূল্যে, অর্থাৎ পবিত্রস্থানের শেকল অনুসারে, পাঁচ শেকল রুপোর বিনিময়ে মুক্ত করবে। এক শেকলের ওজন, কুড়ি গেরা। ");
INSERT INTO benobcv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“তুমি কিন্তু প্রথমজাত ষাঁড়, মেষ অথবা ছাগলকে মুক্ত করবে না; সেগুলি পবিত্র। তাদের রক্ত বেদিতে ছিটাবে এবং তাদের মেদ, সদাপ্রভুর আনন্দদায়ক সুরভিস্বরূপ, ভক্ষ্য-নৈবেদ্যরূপে আগুনে পোড়াবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","তাদের মাংস তোমাদেরই প্রাপ্য হবে, যেমন দোলনীয়-নৈবেদ্যর বক্ষ ও দক্ষিণ ঊরু তোমাদের। ");
INSERT INTO benobcv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","সদাপ্রভুর উদ্দেশে নিবেদিত, ইস্রায়েলীদের পবিত্র নৈবেদ্য থেকে যা কিছু স্বতন্ত্র রাখা হয়, তা আমি তোমাকে, তোমার ছেলে ও মেয়েদের নিয়মিত অংশ বলে দিলাম। তুমি ও তোমার সন্তানদের জন্য এই হল সদাপ্রভুর সাক্ষাতে চিরস্থায়ী লবণ-নিয়ম।” ");
INSERT INTO benobcv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","সদাপ্রভু হারোণকে বললেন, “তাদের দেশে তোমার কোনো উত্তরাধিকার থাকবে না, কিংবা তাদের মধ্যে তোমার কোনো অংশ থাকবে না। ইস্রায়েলীদের মধ্যে আমিই তোমার অংশ এবং অধিকার। ");
INSERT INTO benobcv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“সমাগম তাঁবুর পরিচর্যার সময় লেবীয়েরা যে কাজ করে, তাঁর পরিবর্তে আমি উত্তরাধিকারস্বরূপ তাদের ইস্রায়েলের সমস্ত দশমাংশ দিলাম। ");
INSERT INTO benobcv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","এখন অবধি ইস্রায়েলীরা অবশ্যই সমাগম তাঁবুর নিকটস্থ হবে না, নতুবা তারা তাদের পাপের পরিণতি ভোগ করবে ও মারা পড়বে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","কেবলমাত্র লেবীয়েরাই সমাগম তাঁবুর সংশ্লিষ্ট কাজকর্ম করবে এবং তাঁর বিপক্ষে কৃত অপরাধসমূহের দায়িত্ব বহন করবে। ভবিষ্যৎ প্রজন্মের জন্যও এই বিধি চিরস্থায়ী। তারা ইস্রায়েলীদের মধ্যে কোনো উত্তরাধিকার পাবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","পরিবর্তে, আমি লেবীয়দের অধিকারস্বরূপ সমস্ত দশমাংশ দান করছি, যা ইস্রায়েলীরা, সদাপ্রভুর কাছে উপহারস্বরূপ নিবেদন করে। এই জন্য আমি তাদের সম্পর্কে এই কথা বলেছি, ‘ইস্রায়েলীদের মধ্যে তাদের কোনো উত্তরাধিকার থাকবে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“লেবীয়দের সঙ্গে কথা বলো, তাদের বলো, ‘যখন তোমরা ইস্রায়েলীদের কাছ থেকে দশমাংশ গ্রহণ করবে, যা আমি তোমাদের অধিকারস্বরূপ দান করেছি, তোমরা সেই দশমাংশের দশমাংশ, সদাপ্রভুর নৈবেদ্যস্বরূপ উপহার দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","তোমাদের নৈবেদ্য তোমাদের জন্য খামারের শস্য অথবা দ্রাক্ষা নিষ্পেষণ যন্ত্রের নির্যাসস্বরূপ গণ্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","একইভাবে, তোমরাও ইস্রায়েলীদের কাছ থেকে যে সমস্ত দশমাংশ পাও, তা থেকে সদাপ্রভুর উদ্দেশে এক নৈবেদ্য উপহার দেবে। এই সমস্ত দশমাংশ থেকে, তোমরা অবশ্যই সদাপ্রভুর অংশ, যাজক হারোণকে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","তোমাদের যা দেওয়া হয়, তার মধ্যে থেকে সর্বোত্তম এবং পবিত্রতম অংশ, সদাপ্রভুর অংশ বলে নিবেদন করবে।’ ");
INSERT INTO benobcv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“লেবীয়দের বলো, ‘যখন তোমরা সেই সর্বোত্তম অংশ নিবেদন করবে, তখন তা তোমাদের জন্য খামারের শস্য অথবা দ্রাক্ষা নিষ্পেষণ যন্ত্রের নির্যাসের মতোই গণ্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","তোমরা ও তোমাদের স্বজনবর্গ, তাঁর অবশিষ্ট অংশ, যে কোনো স্থানে আহার করতে পারো, কারণ তা সমাগম তাঁবুতে তোমাদের কাজের বেতনস্বরূপ। ");
INSERT INTO benobcv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","তাঁর সর্বোত্তম অংশ নিবেদন করে, তোমরা এই বিষয়ে অপরাধী হবে না; ফলে তোমরা ইস্রায়েলীদের পবিত্র নৈবেদ্য কলুষিত করবে না এবং তোমরা মারা পড়বে না।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“সদাপ্রভু যা আদেশ করেছেন, শাস্ত্রের সেই বিধান হল এই; ইস্রায়েলীদের বলো, একটি লাল রংয়ের ক্রুটিহীন ও বিকলাঙ্ক নয়, এমন বকনা-বাছুর, যে কখনও জোয়াল টানেনি, তোমার কাছে নিয়ে আসতে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","তুমি তা নিয়ে যাজক ইলীয়াসরকে দেবে; সেটিকে ছাউনির বাইরে নিয়ে গিয়ে তাঁর সামনে জবাই করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","পরে যাজক ইলীয়াসর তাঁর আঙুলে সামান্য রক্ত নিয়ে, সমাগম তাঁবুর অভিমুখে সাতবার ছিটিয়ে দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","তাঁর দৃষ্টিগোচরে সেই বকনা-বাছুরটিকে, তাঁর চামড়া, মাংস, রক্ত এবং গোবর সমেত পোড়াতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","যাজক কিছু পরিমাণ দেবদারু কাঠ, এসোব ও লাল রংয়ের পশম নিয়ে ওই পোড়া বাছুরের উপরে নিক্ষেপ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","তারপর যাজক অবশ্যই তাঁর পোশাক ধুয়ে জলে স্নান করবে। পরে সে ছাউনিতে ফিরে আসতে পারে; তা সত্ত্বেও, আনুষ্ঠানিকভাবে সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","যে ব্যক্তি তা পোড়ায়, সেও নিজের পোশাক ধুয়ে জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“একজন শুচিশুদ্ধ ব্যক্তি সেই বকনা-বাছুরের ছাই সংগ্রহ করে, ছাউনির বাইরে, আনুষ্ঠানিকভাবে শুচিকৃত কোনও এক স্থানে রাখবে। সেগুলি ইস্রায়েলী সমাজের কাছে রাখবে যেন শুদ্ধকরণের জল হিসেবে তা ব্যবহার করা যায়; এটি পাপ থেকে শুদ্ধকরণের জন্যে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","যে ব্যক্তি ওই বকনা-বাছুরের ভস্ম সংগ্রহ করে, সে নিজের পোশাক ধুয়ে নেবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ইস্রায়েলী এবং তাদের মধ্যে বসবাসকারী বিদেশিদের জন্য এই আদেশ হবে চিরস্থায়ী। ");
INSERT INTO benobcv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“যে কেউ কোনো মৃত ব্যক্তিকে স্পর্শ করবে সে সাত দিন অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","তাদের অবশ্যই সেই জল নিয়ে তৃতীয় দিনে ও সপ্তম দিনে নিজেকে শুচিশুদ্ধ করতে হবে; তারপর তারা শুচিশুদ্ধ হবে। কিন্তু তারা যদি তৃতীয় ও সপ্তম দিনে নিজেদের শুচিশুদ্ধ না করে, তারা শুচিশুদ্ধ হবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","মৃত ব্যক্তিকে স্পর্শ করে যদি কেউ নিজেকে পাপমুক্ত না করে, তাহলে তারা সদাপ্রভুর আবাস তাঁবু অশুচি করবে। তারা ইস্রায়েলের মধ্য থেকে বিলুপ্ত হবে। যেহেতু শুদ্ধকরণের জল তাদের উপর ছিটানো হয়নি, তাই তারা অশুচি থাকবে; তাদের অশুচিতা থেকেই যাবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“যখন কেউ তাঁবুর মধ্যে মারা যায়, এই বিধি সেই সময়ের জন্য প্রযোজ্য। যে কেউ সেই তাঁবুর অভ্যন্তরে থাকে ও যে কোনো ব্যক্তি তাঁর মধ্যে প্রবেশ করে, তারা সাত দিন পর্যন্ত অশুচি থাকবে ");
INSERT INTO benobcv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","এবং সমস্ত খোলা পাত্র ও সুতোয় বাঁধা ঢাকনাবিহীন পাত্র অশুচি হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“উন্মুক্ত স্থানে কোনো ব্যক্তি যদি তরোয়াল দ্বারা নিহত বা স্বাভাবিকভাবে মৃত কোনো ব্যক্তিকে স্পর্শ করে, অথবা যদি কেউ কোনো মৃত ব্যক্তির অস্থি বা সমাধি স্পর্শ করে, তাহলে সেই ব্যক্তি সাত দিন অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“অশুচি ব্যক্তির শুদ্ধকরণের জন্য একটি পাত্রে পাপার্থক নৈবেদ্যের সামান্য ভস্ম নিয়ে তাঁর মধ্যে টাটকা জল দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","তারপর, আনুষ্ঠানিকভাবে শুচিশুদ্ধ এমন কোনো ব্যক্তি, সামান্য এসোব নিয়ে, সেই জলে ডুবিয়ে তাঁবু, তাঁর আসবাবপত্র এবং সেই স্থানের সমস্ত ব্যক্তির উপর ছিটিয়ে দেবে। সে অবশ্য সেই জল তার উপরেও ছিটিয়ে দেবে, যে কোনো মানুষের অস্থি অথবা সমাধি অথবা কোনো নিহত বা স্বাভাবিকভাবে মৃত ব্যক্তিকে স্পর্শ করেছে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","যে ব্যক্তি শুচিশুদ্ধ, সে ওই অশুচি ব্যক্তিদের উপর তৃতীয় ও সপ্তম দিনে জল ছিটাবে এবং সপ্তম দিনে সে তাদের শুচিশুদ্ধ করবে। যারা এইভাবে শুদ্ধিকৃত হয়, তারা অবশ্যই তাদের পোশাক ধুয়ে নেবে ও জলে স্নান করবে এবং সেই সন্ধ্যায় তারা শুচিশুদ্ধ হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","কিন্তু যদি অশুচি ব্যক্তিরা নিজেদের শুচিশুদ্ধ না করে, তারা অবশ্যই সমাজ থেকে বিলুপ্ত হবে, কারণ তারা সদাপ্রভুর পবিত্র স্থানকে অশুচি করেছে। শুদ্ধকরণের জল তাঁর উপরে ছিটানো হয়নি, তাই তারা অশুচি। ");
INSERT INTO benobcv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","তাদের জন্য এই আদেশ হবে চিরস্থায়ী। “যে ব্যক্তি সেই জল ছিটাবে, সেও নিজের পোশাক ধুয়ে নেবে এবং যে কেউ সেই শুদ্ধকরণের জল স্পর্শ করবে সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","কোনো অশুচি ব্যক্তি যা কিছু স্পর্শ করবে, তা অশুচি হবে এবং যে কেউ তা স্পর্শ করে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","প্রথম মাসে সমগ্র ইস্রায়েলী সমাজ, সীন মরুভূমিতে উপস্থিত হয়ে কাদেশে অবস্থান করল। সেই স্থানে মরিয়ম মারা গেলেন এবং তাঁকে কবর দেওয়া হল। ");
INSERT INTO benobcv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","সেখানে সমাজের ব্যবহার্য কোনো জল ছিল না। তাই জনতা মোশি ও হারোণের বিপক্ষে একত্র হল। ");
INSERT INTO benobcv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","তারা মোশির সঙ্গে বিবাদ করে বলল, “আমাদের ভ্রাতৃবর্গ যখন সদাপ্রভুর সামনে মারা গেল, তখন আমরাও যদি মারা যেতাম! ");
INSERT INTO benobcv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","কেন তোমরা সদাপ্রভুর সমাজকে এই প্রান্তরে নিয়ে এলে, যেন আমরা ও আমাদের পশুপাল এই জায়গায় মারা যাই? ");
INSERT INTO benobcv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","কেন তোমরা মিশর থেকে আমাদের বের করে এই ভয়ংকর জায়গায় নিয়ে এলে? এখানে কোনো শস্য বা ডুমুর, দ্রাক্ষালতা বা বেদানা নেই। পান করার জন্য জলও নেই!” ");
INSERT INTO benobcv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","মোশি ও হারোণ, মণ্ডলী থেকে পৃথক হয়ে সমাগম তাঁবুর প্রবেশপথে গেলেন এবং তারা উপুড় হয়ে পড়লেন আর তাদের সামনে সদাপ্রভুর মহিমা প্রকাশিত হল। ");
INSERT INTO benobcv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“তোমার লাঠিটি নাও এবং তুমি ও তোমার ভাই হারোণ মণ্ডলীকে একত্র করো। তাদের দৃষ্টিগোচরে ওই শৈলকে গিয়ে বলো, সে তার অভ্যন্তরস্থ জল নির্গত করবে। তুমি শৈল থেকে সমাজের জন্য জল নির্গত করবে, যেন তারা ও তাদের পশুপাল সেই জলপান করতে পারে।” ");
INSERT INTO benobcv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","অতএব মোশি, সদাপ্রভুর উপস্থিতিতে সেই লাঠিটি গ্রহণ করলেন, যেমন তিনি তাকে আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","তিনি এবং হারোণ, মণ্ডলীকে সেই শৈলের সামনে একত্র করলেন এবং মোশি তাদের বললেন, “বিদ্রোহীকুল, তোমরা শোনো, আমরা কি এই শৈল থেকে তোমাদের জন্য জল নির্গত করব?” ");
INSERT INTO benobcv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","তারপর মোশি হাত তুলে, তাঁর লাঠি দিয়ে দু-বার সেই শৈলে আঘাত করলেন। জল পূর্ণ বেগে নির্গত হল এবং সমাজ ও তাদের পশুপাল সেই জলপান করল। ");
INSERT INTO benobcv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","সদাপ্রভু কিন্তু মোশি ও হারোণকে বললেন, “যেহেতু তোমরা, ইস্রায়েলীদের দৃষ্টিতে পবিত্র বলে আমাকে সম্মান দিয়ে, আমার উপর পর্যাপ্ত বিশ্বাস রাখলে না, তাই যে দেশ আমি তাদের দান করব, তোমরা এই মণ্ডলীকে সেই দেশে নিয়ে যাবে না।” ");
INSERT INTO benobcv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","এই ছিল মরীবার জল, যেখানে ইস্রায়েলীরা সদাপ্রভুর সঙ্গে বিবাদ করেছিল এবং সেই স্থানে তিনি তাদের মধ্যে পবিত্র প্রমাণিত হয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","মোশি কাদেশ থেকে ইদোমের রাজার কাছে বার্তাবাহকদের মাধ্যমে এই বার্তা প্রেরণ করলেন, “আপনার ভাই ইস্রায়েল এই কথা বলছে, আমাদের প্রতি যে সমস্ত কষ্ট ঘটেছিল, সেই বিষয় আপনি অবগত আছেন। ");
INSERT INTO benobcv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","আমাদের পূর্বপুরুষেরা মিশরে গিয়েছিলেন এবং বহু বছর আমরা সেখানে বসবাস করেছিলাম। মিশরীয়েরা আমাদের ও আমাদের পূর্বপুরুষদের প্রতি দুর্ব্যবহার করেছিল, ");
INSERT INTO benobcv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","কিন্তু আমরা সদাপ্রভুর কাছে যখন কাঁদলাম তিনি আমাদের কান্না শুনে একজন স্বর্গদূত পাঠিয়েছিলেন এবং মিশর থেকে আমাদের বের করে নিয়ে এলেন। “এখন আমরা, আপনার অঞ্চলের প্রান্তে কাদেশ নগরে অবস্থান করছি। ");
INSERT INTO benobcv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","কৃপা করে আপনার দেশের মধ্যে দিয়ে আমাদের যাত্রা করতে দিন। আমরা কোনো চাষের জমি বা দ্রাক্ষাকুঞ্জের মধ্য দিয়ে যাব না, কুয়ো থেকে জলও পান করব না। আমরা সরাসরি রাজপথ দিয়ে যাব এবং যতক্ষণ না আপনার সীমানা পার হই, আমরা ডানদিকে বা বাঁদিকে ঘুরব না।” ");
INSERT INTO benobcv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","কিন্তু ইদোম উত্তর দিল, “তোমরা এই দেশের মধ্য দিয়ে যেতে পারবে না। যদি সেই চেষ্টা করো, তাহলে আমরা তোমাদের বিরুদ্ধে যাব এবং তরোয়াল নিয়ে তোমাদের আক্রমণ করব।” ");
INSERT INTO benobcv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","প্রত্যুত্তরে ইস্রায়েলীরা বলল, “আমরা প্রধান পথ ধরেই যাত্রা করব। যদি আমরা, বা আমাদের পশুপাল কেউ জলপান করে, তার জন্য আমরা মূল্য দেব। আমরা শুধুমাত্র পায়ে হেঁটে পার হতে চাই, অন্য কিছু নয়।” ");
INSERT INTO benobcv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","তারা আবার উত্তর দিল, “তোমরা যেতে পারবে না।” তারপর ইদোম এক বড়ো এবং শক্তিশালী সেনাদল নিয়ে তাদের বিপক্ষে বেরিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","যেহেতু ইদোম, তাদের ভূখণ্ড দিয়ে যেতে দিল না, তাই ইস্রায়েলীরা তাদের কাছ থেকে ফিরে এল। ");
INSERT INTO benobcv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","সমগ্র ইস্রায়েলী সমাজ কাদেশ থেকে যাত্রা করে হোর পর্বতে উপস্থিত হল। ");
INSERT INTO benobcv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ইদোমের সীমানার কাছে, হোর পর্বতে, সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“হারোণ তাঁর স্বজনবর্গের কাছে সংগৃহীত হবে। ইস্রায়েলীদের আমি যে দেশ দিতে চাই, সেখানে সে প্রবেশ করবে না, কারণ তোমরা উভয়েই মরীবার জলের কাছে আমার বিরুদ্ধাচারণ করেছিলে। ");
INSERT INTO benobcv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","হারোণ ও তাঁর ছেলে ইলীয়াসরকে নিয়ে হোর পর্বতে যাও। ");
INSERT INTO benobcv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","হারোণের পোশাক খুলে ইলীয়াসরকে পরিয়ে দাও, কারণ হারোণ তাঁর স্বজনবর্গের কাছে সংগৃহীত হবে; সে সেখানেই মারা যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","সদাপ্রভু যে রকম বলেছিলেন, মোশি, ঠিক তাই করলেন। তাঁরা সমগ্র সমাজের দৃষ্টিগোচরে হোর পর্বতে উঠে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","মোশি, হারোণের পোশাক খুলে, তাঁর পুত্র ইলীয়াসরকে পরিয়ে দিলেন। হারোণ সেই পর্বতের উপরে মারা গেলেন। তারপর মোশি ও ইলীয়াসর পর্বত থেকে নেমে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","যখন সমগ্র সমাজ অবগত হল যে হারোণ মারা গিয়েছেন, তখন ইস্রায়েলীরা সবাই তাঁর জন্য ত্রিশ দিন শোক করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","কনান বংশীয় অরাদের রাজা, যিনি নেগেভে বসবাস করতেন, যখন শুনলেন যে ইস্রায়েলীরা অথারীমের পথ ধরে আসছে, তখন তিনি তাদের আক্রমণ করে কয়েকজনকে বন্দি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","তখন ইস্রায়েল সদাপ্রভুর কাছে এই শপথ করল, “যদি তুমি এই লোকদের আমাদের হাতে সমর্পণ করো, তবে আমরা তাদের নগরগুলি নিঃশেষে বিনষ্ট করব।” ");
INSERT INTO benobcv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","সদাপ্রভু ইস্রায়েলীদের অনুনয় শুনলেন এবং তাদের হাতে কনানীয়দের সমর্পণ করলেন। তারা তাদের নগর সমেত সবাইকে সম্পূর্ণরূপে ধ্বংস করল। তাই সেই স্থানের নাম রাখা হল হর্মা। ");
INSERT INTO benobcv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","তারা হোর পর্বত থেকে যাত্রা শুরু করল, ইদোম প্রদক্ষিণ করার উদ্দেশে লোহিত সাগর অভিমুখে গমন করল। কিন্তু জনতা পথের মধ্যে অসহিষ্ণু হয়ে উঠল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","তারা ঈশ্বরের এবং মোশির বিপক্ষে নিন্দা করে বলল, “আপনারা কেন মিশর থেকে আমাদের বের করে এই প্রান্তরে মেরে ফেলার জন্য নিয়ে এলেন? এখানে কোনো রুটি নেই! জল নেই! এই কষ্টদায়ক আহারে আমাদের অরুচি ধরে গেছে!” ");
INSERT INTO benobcv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","তখন সদাপ্রভু তাদের মধ্যে বিষধর সাপ পাঠালেন; সেগুলি লোকদের দংশন করল এবং অনেক ইস্রায়েলী মারা গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","লোকেরা মোশির কাছে এসে তাঁকে বলল, “আমরা সদাপ্রভু ও আপনার বিপক্ষে কথা বলে পাপ করেছি। প্রার্থনা করুন যেন সদাপ্রভু এই সাপদের আমাদের কাছ থেকে দূর করেন।” তাই মোশি লোকদের জন্য বিনতি করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","সদাপ্রভু মোশিকে বললেন, “একটি সাপ নির্মাণ করে তুমি খুঁটির উপরে স্থাপন করো। কাউকে সাপ দংশন করলে সে তার প্রতি দৃষ্টিপাত করে রক্ষা পাবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","মোশি তখন ব্রোঞ্জের একটি সাপ নির্মাণ করে একটি খুঁটির উপরে স্থাপন করলেন। তারপর যখনই কোনো ব্যক্তিকে সাপ দংশন করত এবং সে ওই ব্রোঞ্জ নির্মিত সাপের প্রতি দৃষ্টিপাত করত, সে বেঁচে যেত। ");
INSERT INTO benobcv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ইস্রায়েলীরা যাত্রা করে ওবোতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","তারপর তারা ওবোৎ থেকে যাত্রা করে, সূর্যোদয়ের অভিমুখে, মরুভূমি সন্নিহিত মোয়াবের কাছে ঈয়ী-অবারীমে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","সেখান থেকে অগ্রসর হয়ে তারা সেরদ উপত্যকায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","সেখান থেকে যাত্রা করে তারা অর্ণোনের পাশে ছাউনি স্থাপন করল। অর্ণোন মরুভূমিতে অবস্থিত, যা ইমোরীয়দের এলাকা পর্যন্ত বিস্তৃত ছিল। মোয়াব এবং ইমোরীয়দের মধ্যে অর্ণোনই হল মোয়াবের সীমানা। ");
INSERT INTO benobcv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","এই কারণে সদাপ্রভুর যুদ্ধ সংক্রান্ত পুস্তকে লিপিবদ্ধ আছে, “শূফাতে অবস্থিত বাহেব ও উপত্যকা সকল, অর্ণোন ");
INSERT INTO benobcv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","এবং উপত্যকা সকলের পার্শ্ব ভূমি, যা আর্-এর অভিমুখী, এবং মোয়াবের সীমানার পাশে অবস্থিত।” ");
INSERT INTO benobcv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","সেই স্থান থেকে তারা ক্রমাগত অগ্রসর হয়ে বীর-এ গেল। সেই কুয়োর কাছে সদাপ্রভু মোশিকে বললেন, “লোকদের একত্র করো। আমি তাদের জল দেব।” ");
INSERT INTO benobcv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","তখন ইস্রায়েলীরা এই গীত গাইল “উৎসারিত হও, হে কুয়ো, এর উদ্দেশে গাও গীত, ");
INSERT INTO benobcv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","রাজপুত্রদের খনিত এই কুয়োর বিষয়ে অভিজাত ব্যক্তিরা যা খনন করেছিলেন, অভিজাত ব্যক্তিদের রাজদণ্ড ও লাঠি দিয়ে।” তারপর তারা প্রান্তর থেকে মত্তানায় গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","মত্তানা থেকে নহলীয়েলে, নহলীয়েল থেকে বামোতে, ");
INSERT INTO benobcv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","বামোৎ থেকে মোয়াব উপত্যকায়, যেখানে পিস্‌গা শিখর থেকে মরুভূমি প্রত্যক্ষ হল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ইস্রায়েল, ইমোরীয়দের রাজা সীহোনের কাছে বার্তাবাহকদের প্রেরণ করল। তারা গিয়ে বলল, ");
INSERT INTO benobcv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“আপনার দেশের মধ্য দিয়ে আমাদের যাওয়ার অনুমতি দিন। আমরা কোনো শস্যক্ষেত্র বা দ্রাক্ষাকুঞ্জের মধ্য গিয়ে যাব না, কুয়ো থেকে জলও পান করব না। যতদিন না আমরা এলাকা পার হয়ে যাই, আমরা শুধু রাজপথ দিয়েই গমন করব।” ");
INSERT INTO benobcv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","সীহোন কিন্তু তাঁর এলাকা দিয়ে ইস্রায়েলীদের যেতে দিলেন না। তিনি তাঁর সমস্ত সেনা সমাবেশ করে প্রান্তরে ইস্রায়েলীদের বিপক্ষে অগ্রসর হলেন। যহসে পৌঁছে তিনি ইস্রায়েলের সঙ্গে যুদ্ধ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","তাতে ইস্রায়েল তাঁকে তরোয়াল দিয়ে আঘাত করল এবং অর্ণোন থেকে যব্বোক পর্যন্ত দখল করে নিল, কারণ অম্মোনীয়দের সীমানা সুরক্ষিত ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ইস্রায়েল হিষ্‌বোন সমেত ইমোরীয়দের সমস্ত নগর এবং তাদের সন্নিহিত উপনিবেশগুলি দখল করে বসতি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","হিষ্‌বোন, ইমোরীয়দের রাজা সীহোনের শহর ছিল, যা তিনি মোয়াবের সঙ্গে যুদ্ধ করে অর্ণোন পর্যন্ত তাঁর সমস্ত রাজ্য অধিকারভুক্ত করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","সেইজন্য কবিরা বলেছেন, “হিষ্‌বোনে এসো, তা পুনর্নির্মিত হোক, সীহোনের নগর পুনরুদ্ধার হোক। ");
INSERT INTO benobcv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“হিষ্‌বোন থেকে অগ্নি, সীহোনের নগর থেকে নির্গত হল এক বহ্নিশিখা, তা মোয়াবের আর্ ও অর্ণোনের উচ্চভূমির নাগরিকদের বিনাশ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","হে মোয়াব, ধিক্ তোমাকে! কমোশের প্রজারা, তোমরা বিনষ্ট হলে। সে তার ছেলেদের পলাতকদের হাতে, ও মেয়েদের বন্দিরূপে সমর্পণ করেছে, ইমোরীয়দের রাজা সীহোনের হাতে। ");
INSERT INTO benobcv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“কিন্তু আমরা তাদের নিপাতিত করেছি; হিষ্‌বোন দীবোন পর্যন্ত ধ্বংস হয়েছে, আমরা নোফঃ পর্যন্ত তাদের ধ্বংস করেছি, যা মেদ্‌বা পর্যন্ত বিস্তৃত।” ");
INSERT INTO benobcv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","এইভাবে ইস্রায়েল ইমোরীয়দের দেশে বসতি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","মোশি যাসেরে গুপ্তচর পাঠানোর পর, ইস্রায়েলীরা তার চতুর্দিকের গ্রামগুলি অধিকার করে নিল এবং সেখানকার সমস্ত ইমোরীয়দের বিতাড়িত করল। ");
INSERT INTO benobcv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","তারপর তারা ঘুরে বাশনের পথে উঠে গেল। আর বাশনের রাজা ওগ তাঁর সৈন্যদল নিয়ে তাদের সঙ্গে যুদ্ধ করার জন্য ইদ্রিয়ীতে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","সদাপ্রভু মোশিকে বললেন, “তাকে ভয় পেয়ো না। আমি তাকে, তার সমস্ত সেনাবাহিনী ও তার দেশ তোমার হাতে সমর্পণ করেছি। তার প্রতি সেরকমই কোরো, যেমন তুমি ইমোরীয়দের রাজা সীহোনের প্রতি করেছিলে, যে হিষ্‌বোনে রাজত্ব করত।” ");
INSERT INTO benobcv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","তাই তারা ওগ ও তার ছেলেদের ও সমস্ত সৈন্যবাহিনীকে আঘাত করল, কাউকে বাঁচিয়ে রাখল না এবং তারা তাঁর দেশ অধিকার করে নিল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","তারপর ইস্রায়েলীরা মোয়াব দেশের সমতলে যাত্রা করল এবং যিরীহোর অন্য পাশে, জর্ডন বরাবর ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ইস্রায়েল ইমোরীয়দের প্রতি যা করেছিল, সিপ্পোরের ছেলে বালাক তা দেখলেন ");
INSERT INTO benobcv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","এবং বিশাল জনতা দেখে মোয়াব অত্যন্ত শঙ্কিত হল। প্রকৃতপক্ষে, মোয়াব ইস্রায়েলীদের জন্য ত্রাসে পূর্ণ হল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","মোয়াবীয়েরা, মিদিয়নের প্রবীণদের বলল, “যেমন ষাঁড় ক্ষেতের ঘাস চেটে খায়, তেমনি এই যাযাবর সম্প্রদায় আমাদের চতুর্দিকের সবকিছুই চেটে খাবে।” তাই সিপ্পোরের ছেলে বালাক, যিনি সেই সময় মোয়াবের রাজা ছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","বিয়োরের ছেলে বিলিয়মের কাছে বার্তাবাহকদের পাঠালেন। তিনি সেই সময় ইউফ্রেটিস নদীর সন্নিকটে, তাঁর জন্মভূমি পথোর নগরে ছিলেন। বালাক বলে পাঠালেন, “এক জনসমাজ মিশর থেকে বের হয়ে এসেছে; তারা ভূপৃষ্ঠ ছেয়ে গেছে এবং আমার রাজ্যের পাশেই বসতি করছে। ");
INSERT INTO benobcv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","আপনি এসে এই জনসমাজকে অভিশাপ দিন, কারণ তারা আমার থেকেও বেশি ক্ষমতাসম্পন্ন। সম্ভবত তখন আমি তাদের পর্যুদস্ত করে দেশ থেকে বিতাড়ন করতে পারব। আমি জানি, আপনি যাদের আশীর্বাদ করেন, তারা আশীর্বাদপ্রাপ্ত হয় এবং যাদের অভিশাপ দেন তারা অভিশপ্ত হয়।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","মোয়াবের ও মিদিয়নের প্রবীণেরা প্রস্থান করলেন। তাঁরা প্রত্যাদেশের জন্য দেয় পারিশ্রমিক সঙ্গে নিয়ে গেলেন। তাঁরা বিলিয়মের কাছে গিয়ে, তাঁকে বালাকের বার্তা পৌঁছে দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","বিলিয়ম তাঁদের বলল, “রাতে এখানেই থাকুন সদাপ্রভু আমাকে যা উত্তর দেন, তা আমি আপনাদের জ্ঞাত করব।” অতএব মোয়াবীয় কর্মকর্তারা তার সঙ্গে থাকলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ঈশ্বর বিলিয়মের কাছে এসে প্রশ্ন করলেন, “তোমার সঙ্গী, এই সমস্ত ব্যক্তি কারা?” ");
INSERT INTO benobcv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","বিলিয়ম ঈশ্বরকে বললেন, “মোয়াবের রাজা, সিপ্পোরের ছেলে বালাক, আমার কাছে এই বার্তা পাঠিয়েছেন, ");
INSERT INTO benobcv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘এক জনসমাজ মিশর থেকে বের হয়ে এসে সমস্ত দেশ ছেয়ে গেছে। এখন আপনি এসে আমার অনুকূলে তাদের অভিশাপ দিন। সম্ভবত তখন আমি তাদের সঙ্গে যুদ্ধ করতে পারব ও তাদের বিতাড়ন করব।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","কিন্তু ঈশ্বর বিলিয়মকে বললেন, “তুমি তাদের সঙ্গে যাবে না। তুমি অবশ্যই ওই লোকদের অভিশাপ দেবে না, কারণ তারা আশীর্বাদপ্রাপ্ত।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","পরদিন সকালে, বিলিয়ম উঠে বালাকের কর্মকর্তাদের বলল, “আপনাদের দেশে ফিরে যান, কারণ সদাপ্রভু আমাকে, আপনাদের সঙ্গে যেতে দিতে অস্বীকার করলেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","অতএব মোয়াবীয় কর্মকর্তারা বালাকের কাছে ফিরে গিয়ে বললেন, “বিলিয়ম আমাদের সঙ্গে আসতে অস্বীকার করেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","তখন বালাক, সংখ্যায় আরও বেশি ও প্রথম দল অপেক্ষা অধিকতর বিশিষ্ট কর্মকর্তাদের পাঠালেন। ");
INSERT INTO benobcv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","তাঁরা বিলিয়মের কাছে এসে বলল, “সিপ্পোরের ছেলে বালাক এই কথা বলেছেন যে, আমার কাছে আসতে কোনো কিছুই যেন আপনাকে নিবারিত না করে, ");
INSERT INTO benobcv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","কেননা আমি উদারভাবে আপনাকে পুরস্কৃত করব এবং আপনি যা কিছু বলেন, সে সমস্তই করব। আসুন এবং আমার অনুকূলে এই লোকদের অভিশাপ দিন।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","কিন্তু বিলিয়ম তাঁদের উত্তর দিল, “বালাক যদি তাঁর প্রাসাদের সমস্ত রুপো ও সোনা আমাকে দান করেন, আমার ঈশ্বর, সদাপ্রভু আমাকে যে আদেশ দেন, আমি তার থেকে বেশি বা অল্প কিছুই করতে পারব না। ");
INSERT INTO benobcv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","এখন অন্য দলের মতো আপনারাও আজ রাতে এখানে থাকুন যেন আমি চেষ্টা করে দেখি সদাপ্রভু আমাকে আর কিছু বলেন কি না।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","সেই রাতে সদাপ্রভু বিলিয়মের কাছে এসে বললেন, “যেহেতু এই ব্যক্তিরা তোমাকে ডাকতে এসেছে, তাদের সঙ্গে যাও; কিন্তু সেই কাজই করবে, যা আমি তোমাকে করতে বলব।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","বিলিয়ম সকালে উঠে তাঁর গর্দভীর সজ্জা পরালো এবং মোয়াবের কর্মকর্তাদের সঙ্গে গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","কিন্তু সে যখন গেল, ঈশ্বর ভয়ানক রুষ্ট হলেন, সদাপ্রভুর দূত তার বিরোধিতা করার উদ্দেশে পথের মধ্যে দাঁড়ালেন। বিলিয়ম তার গর্দভীতে আরোহণ করেছিল এবং তার দুই ভৃত্য তার সঙ্গে ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","যখন সেই গর্দভী, নিষ্কোষ তরোয়াল হাতে সদাপ্রভুর দূতকে পথের মধ্যে দাঁড়িয়ে থাকতে দেখল, সে রাস্তা থেকে নেমে এক ক্ষেতের মধ্যে গেল। বিলিয়ম পথে ফিরানোর জন্য তাকে মারল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","তারপর সদাপ্রভুর দূত, সেই দ্রাক্ষাকুঞ্জের মধ্যবর্তী এক সংকীর্ণ স্থানে দাঁড়ালেন, যার দুই ধারে দেওয়াল ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","যখন সেই গর্দভী সদাপ্রভুর দূতকে দেখল, সে দেওয়ালের নিকট ঘেসে গেল এতে বিলিয়মের পা ঘষে গেল। সেইজন্য সে তাকে পুনরায় প্রহার করল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","এরপর সদাপ্রভুর দূত অগ্রসর হয়ে এক সংকীর্ণ স্থানে গিয়ে দাঁড়ালেন, যেখান থেকে ডানদিকে বা বাঁদিকে কোনও পথে ফিরবার উপায় ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","যখন গর্দভী সদাপ্রভুর দূতকে দেখল, সে বিলিয়মের নিচে বসে পড়ল। এতে সে ক্রুদ্ধ হল ও লাঠি দিয়ে সেই গর্দভীকে মারল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","তখন সদাপ্রভু গর্দভীটির মুখ খুলে দিলেন এবং সে বিলিয়মকে বলল, “আমি আপনার প্রতি কী করেছি যে এই তিনবার আপনি আমাকে মারলেন?” ");
INSERT INTO benobcv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","বিলিয়ম গর্দভীকে উত্তর দিল, “তুমি আমাকে কি নির্বোধ পেয়েছ! যদি আমার হাতে তরোয়াল থাকত, তাহলে আমি এখনই তোমাকে বধ করতাম।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","গর্দভী বিলিয়মকে বলল, “আমি কি আপনার ব্যক্তিগত গর্দভী নই, যার উপরে আজ পর্যন্ত আপনি আরোহণ করে এসেছেন? আমি কি অনুরূপ আচরণ কখনও আপনার প্রতি করেছি?” সে বলল, “না।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","তখন সদাপ্রভু বিলিয়মের চোখ খুলে দিলেন, আর সে দেখল সদাপ্রভুর দূত, পথের মধ্যে তাঁর তরোয়াল উন্মুক্ত করে দাঁড়িয়ে আছেন। তাই তিনি মাথা নত করে উপুড় হয়ে পড়লেন। ");
INSERT INTO benobcv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","সদাপ্রভুর দূত তাকে জিজ্ঞাসা করলেন, “তোমার গর্দভীকে তুমি এই তিনবার কেন মারলে? আমি তোমার বিপক্ষতা করতে এসেছি, কারণ তোমার কর্মপন্থা আমার দৃষ্টিতে অবিবেচকের মতো প্রতিপন্ন হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","গর্দভীটি আমাকে দেখতে পেয়ে এই তিনবার আমার কাছ থেকে সরে গিয়েছিল। যদি সে না সরে যেত, আমি অবশ্যই এতক্ষণে তোমাকে বধ করতাম, কিন্তু তাকে বাঁচিয়ে রাখতাম।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","বিলিয়ম সদাপ্রভুর দূতকে বলল, “আমি পাপ করেছি। আমি উপলব্ধি করিনি যে আপনি আমার বিপক্ষতা করার জন্য পথের মধ্যে দাঁড়িয়ে আছেন। এখন আপনি যদি অসন্তুষ্ট হয়ে থাকেন, তাহলে আমি ফিরে যাব।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","সদাপ্রভুর দূত বিলিয়মকে বললেন, “তুমি ওই লোকদের সঙ্গে যাও, কিন্তু আমি তোমাকে যে কথা বলি, তুমি ঠিক তাই বলবে।” বিলিয়ম এরপর বালাকের কর্মকর্তাদের সঙ্গে গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","বালাক যখন বিলিয়মের আগমনের সংবাদ পেলেন, তিনি তার সঙ্গে মিলিত হতে তাঁর অঞ্চলের প্রান্তস্থিত অর্ণোনের সীমায় অবস্থিত মোয়াবীয় এক নগরে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","বালাক বিলিয়মকে বললেন, “আমি কি আপনাকে জরুরি ভিত্তিতে ডেকে পাঠাইনি? আপনি কেন আমার কাছে আসেননি? আমি কি বাস্তবিকই আপনাকে পুরস্কৃত করতে অক্ষম?” ");
INSERT INTO benobcv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","বিলিয়ম উত্তর দিলেন, “বেশ, এখন আমি তো আপনার কাছে উপস্থিত হয়েছি। কিন্তু আমি আমার ইচ্ছা মতন কথা বলতে পারি না। সদাপ্রভু আমার মুখে যে ভাষ্য দেবেন, আমি শুধু সেকথাই বলতে পারব।” ");
INSERT INTO benobcv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","তারপর বিলিয়ম, বালাকের সঙ্গে কিরিয়ৎ-হুষোতে গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","বালাক গবাদি পশু ও মেষ বলিদান করলেন এবং তাদের কয়েকটি নিয়ে বিলিয়ম ও তার সঙ্গী সেই কর্মকর্তাদের দান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","পরদিন সকালে বালাক, বিলিয়মকে নিয়ে বামোৎ বায়ালে আরোহণ করলেন এবং সেই স্থান থেকে তিনি ইস্রায়েলীদের শিবিরের প্রান্তদেশ দেখতে পেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","বিলিয়ম বলল, “আমার জন্য আপনি এখানে সাতটি বেদি নির্মাণ করুন এবং সাতটি ষাঁড় ও সাতটি মেষের আয়োজন করুন।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","বিলিয়মের কথামতো বালাক সব কাজ করলেন। তারা উভয়ে প্রতিটি বেদিতে, একটি ষাঁড় ও একটি মেষ উৎসর্গ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","তারপর বালাককে বিলিয়ম বলল, “যখন আমি একান্তে যাই, আপনি আপনার নৈবেদ্যের পাশে অপেক্ষা করুন। সম্ভবত সদাপ্রভু আমার সঙ্গে দেখা করতে আসবেন। যা কিছু তিনি আমার কাছে প্রকাশ করেন, আমি আপনাকে অবহিত করব।” তারপর সে এক অনুর্বর পাহাড়ের উপরে উঠে গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ঈশ্বর তার সঙ্গে দেখা করলেন এবং বিলিয়ম বলল, “আমি সাতটি বেদি নির্মাণ করেছি। প্রত্যেকটির উপর একটি করে ষাঁড় ও একটি করে মেষ উৎসর্গ করেছি।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","সদাপ্রভু বিলিয়মের মুখে একটি বাণী দিলেন এবং বললেন, “বালাকের কাছে ফিরে গিয়ে তাকে এই বার্তা শোনাও।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","সে তাঁর কাছে ফিরে গিয়ে দেখল তিনি মোয়াবের সমস্ত কর্মকর্তার সঙ্গে তাঁর নৈবেদ্যের কাছে দাঁড়িয়ে আছেন। ");
INSERT INTO benobcv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","তখন বিলিয়ম তার প্রত্যাদেশ ব্যক্ত করল, “অরাম থেকে বালাক আমাকে আনলেন, মোয়াব রাজা, প্রাচ্যের পর্বতসমূহ থেকে আনলেন, সে বলল, ‘এসো, আমার অনুকূলে যাকোবকে অভিশাপ দাও, এসো, ইস্রায়েলের বিষয় অমঙ্গলের কথা বলো।’ ");
INSERT INTO benobcv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ঈশ্বর যাদের অভিশাপ দেননি আমি কীভাবে তাদের অভিশাপ দিই? সদাপ্রভু যাদের অবলুপ্ত করেননি, আমি কীভাবে তাদের অবলুপ্তি ঘোষণা করব? ");
INSERT INTO benobcv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","শৈলময় শিখর থেকে আমি তাদের নিরীক্ষণ করি, উচ্চস্থল থেকে আমি তাদের লক্ষ্য করি; দেখতে পাই, স্বতন্ত্র এক জাতির নিবাস, যারা অন্য জাতিসমূহের পর্যায়ভুক্ত বলে নিজেদের গণ্য করে না। ");
INSERT INTO benobcv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","যাকোবের ধুলো, কে করতে গণনা পারে অথবা, ইস্রায়েলের এক-চতুর্থাংশের সংখ্যা নির্ণয় করতে পারে? ধার্মিকের মৃত্যুর মতো আমার মৃত্যু হোক, যেন তাদেরই অনুরূপ আমরাও পরিণতি হয়!” ");
INSERT INTO benobcv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","বালাক, বিলিয়মকে বললেন, “আপনি আমার প্রতি এ কী করলেন? আমি, আমার শত্রুদের অভিশাপ দিতে আপনাকে ডেকেছিলাম, কিন্তু আপনি কিছুই না করে, তাদের আশীর্বাদ করলেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","সে উত্তর দিল, “সদাপ্রভু আমার মুখে যে কথা দেন, আমি কি সেকথাই বলতে বাধ্য নই?” ");
INSERT INTO benobcv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","পরে বালাক তাকে বললেন, “আমার সঙ্গে অন্য স্থানে চলুন, সেখান থেকে আপনি তাদের দেখতে পাবেন। আপনি তাদের সবাইকে নয়, কিন্তু তাদের শিবিরের প্রান্তভাগ দেখতে পাবেন। সেখান থেকে আমার অনুকূলে তাদের অভিশাপ দিন।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","সেই লক্ষ্যে তিনি তাকে পিস্‌গা শিখরে সোফীমের ক্ষেতে নিয়ে গেলেন। সেখানে সাতটি বেদি নির্মাণ করে, প্রত্যেকটির উপর একটি করে ষাঁড় ও একটি মেষ উৎসর্গ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","বালাককে বিলিয়ম বলল, “যখন আমি তাঁর সঙ্গে দেখা করতে যাই, আপনি আপনার নৈবেদ্যের পাশে অপেক্ষা করুন।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","সদাপ্রভু বিলিয়মের সঙ্গে দেখা করে তার মুখে বাণী দিলেন এবং বললেন, “বালাকের কাছে ফিরে যাও ও এই বার্তা তাকে দাও।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","সে তাঁর কাছে গিয়ে দেখল তিনি মোয়াবের কর্মকর্তাদের সঙ্গে তাঁর নৈবেদ্যের কাছে দাঁড়িয়ে আছেন। বালাক তাকে জিজ্ঞাসা করলেন, “সদাপ্রভু কী কথা বললেন?” ");
INSERT INTO benobcv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","তখন তিনি তার প্রত্যাদেশ ব্যক্ত করলেন, “বালাক, ওঠো ও শ্রবণ করো, সিপ্পোরের ছেলে, আমার কথায় কর্ণপাত করো। ");
INSERT INTO benobcv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","সদাপ্রভু মানব নন যে তাঁকে মিথ্যা বলতে হবে, মনুষ্য সন্তান নন যে তাঁর মতের পরিবর্তন করবেন। তিনি কথা দিয়ে কি কাজে রূপায়িত করেন না? প্রতিজ্ঞা করে তিনি কি পূর্ণ করেন না? ");
INSERT INTO benobcv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","আমি আশীর্বাদ করার আদেশ পেয়েছি; তিনি আশীর্বাদ করেছেন, আমি তার অন্যথা করতে পারি না। ");
INSERT INTO benobcv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“যাকোবের মধ্যে কোনো দুর্বিপাক দেখা যায়নি, ইস্রায়েলে কোনো ক্লেশ প্রত্যক্ষ হয়নি; সদাপ্রভু, তাদের ঈশ্বর, তাদের সহায় আছেন রাজার জয়োল্লাস তাদের সঙ্গে বিদ্যমান। ");
INSERT INTO benobcv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ঈশ্বর, মিশর থেকে তাদের নিয়ে এসেছেন, বন্য বৃষের মতো তারা শক্তিধর; ");
INSERT INTO benobcv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","যাকোবের বিপক্ষে কোনও ইন্দ্রজাল, ইস্রায়েলের বিপক্ষে কোনও ভবিষ্যৎ-কথন কৃতকার্য হবে না। যাকোব এবং ইস্রায়েল সম্পর্কে এখন বলা হবে, ‘দেখো, ঈশ্বর কী কাজই না সাধন করেছেন!’ ");
INSERT INTO benobcv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","সেই জাতি সিংহীর মতো উত্থিত হয়, সিংহের মতোই তারা গাত্রোত্থান করে। তারা যতক্ষণ না শিকার বিদীর্ণ করে ততক্ষণ বিশ্রাম করে না, এবং নিহতদের রক্ত পান করে।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","বালাক তখন বিলিয়মকে বললেন, “তাদের অভিশাপ দেবেন না, কিংবা আশীর্বাদও করবেন না।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","বিলিয়ম উত্তর দিল, “আমি কি আপনাকে একথা বলিনি, যে আমি শুধু সেই কাজই করব, যা সদাপ্রভু আমাকে করতে বলবেন?” ");
INSERT INTO benobcv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","তারপরে বিলিয়মকে বালাক বললেন, “আসুন আমি আপনাকে অন্য এক স্থানে নিয়ে যাই। সম্ভবত ঈশ্বর সন্তুষ্ট হবেন, যেন আপনি আমার পক্ষে সেখান থেকে তাদের অভিশাপ দেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","আর বালাক মরুভূমি অভিমুখী পিয়োর শৃঙ্গে বিলিয়মকে নিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","বিলিয়ম বলল, “এখানে আমার জন্য আপনি সাতটি বেদি নির্মাণ করুন এবং সাতটি ষাঁড় ও সাতটি মেষের বলিদানের আয়োজন করুন।” ");
INSERT INTO benobcv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","বিলিয়মের কথামতো বালাক তাই করলেন এবং প্রত্যেকটি বেদির উপরে একটি করে ষাঁড় ও একটি মেষ উৎসর্গ করা হল। ");
INSERT INTO benobcv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","বিলিয়ম যখন দেখল যে ইস্রায়েলীদের আশীর্বাদ করা সদাপ্রভুর সন্তোষজনক, তখন অন্য সময়ের মতো সে প্রত্যাদেশ লাভ করতে অন্যত্র গেল না, কিন্তু তার মুখ প্রান্তরের দিকে ফেরালো। ");
INSERT INTO benobcv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","বিলিয়ম দেখল, গোষ্ঠী অনুসারে ইস্রায়েল ছাউনি স্থাপন করে আছে, তখন ঈশ্বরের আত্মা তার উপরে এলেন ");
INSERT INTO benobcv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","এবং সে তার প্রত্যাদেশ ব্যক্ত করল, “বিয়োরের ছেলে বিলিয়মের প্রত্যাদেশ, যার চোখ স্পষ্ট প্রত্যক্ষ করে, তার প্রত্যাদেশ, ");
INSERT INTO benobcv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","তার প্রত্যাদেশ, যে ঐশ বাণী শ্রবণ করে, যে সর্বশক্তিমানের কাছ থেকে দর্শন পায়, যে সাষ্টাঙ্গ প্রণত হয়, ও যার চোখ খোলা থাকে। ");
INSERT INTO benobcv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“হে যাকোব, তোমার তাঁবুগুলি, হে ইস্রায়েল, তোমার নিবাসস্থান কেমন মনোহর! ");
INSERT INTO benobcv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“উপত্যকার মতো সেগুলি বিস্তৃত হয়, নদী-তীরের বাগানের মতো হয়; সদাপ্রভু দ্বারা রোপিত অগুরু গাছগুলির মতো, জলস্রোতের পাশে থাকা দেবদারু গাছগুলির মতো হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","তাদের বালতি থেকে জল উপচে পড়বে, তাদের বীজ প্রচুর জল পাবে। “তাদের রাজা হবেন অগাগ থেকেও মহৎ, উন্নত হবে তাদের রাজ্য। ");
INSERT INTO benobcv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“ঈশ্বর মিশর থেকে তাদের নির্গত করেছেন, তারা বন্য ষাঁড়ের মতো শক্তিশালী। বৈরী জাতিদের তারা ছিন্নভিন্ন করে, খণ্ডবিখণ্ড করে তাদের অস্থিগুলি, তিরগুলি দিয়ে তাদের বিদ্ধ করে। ");
INSERT INTO benobcv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","সিংহের মতোই তারা হামাগুড়ি দেয়, সিংহীর মতোই শয়ন করে; কোন সাহসী তাকে উঠাতে পারে? “যারা তোমাকে আশীর্বাদ করে তারা আশিস ধন্য হবে, যারা তোমাকে অভিশাপ দেয় তারা অভিশপ্ত হবে!” ");
INSERT INTO benobcv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","তখন বিলিয়মের প্রতি বালাকের ক্রোধ বহ্নিমান হল। তিনি হাতে করাঘাত করে তাকে বললেন, “আমি আপনাকে ডেকে এনেছিলাম যেন আপনি আমার শত্রুদের অভিশাপ দেন, কিন্তু এই তিনবার আপনি তাদের আশীর্বাদ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","এখন এই মুহূর্তে, প্রস্থান করুন ও বাড়িতে ফিরে যান! আমি বলেছিলাম, আপনাকে উদারভাবে পুরস্কৃত করব, কিন্তু সদাপ্রভুই আপনাকে পুরস্কার নিতে দিলেন না।” ");
INSERT INTO benobcv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","বালাককে বিলিয়ম উত্তর দিল, “আপনি যে বার্তাবাহকদের পাঠিয়েছিলেন, আমি কি তাদের বলিনি, ");
INSERT INTO benobcv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘বালাক যদিও তাঁর প্রাসাদের সমস্ত সোনা ও রুপো দেন, আমি স্বেচ্ছায়, ভালো অথবা মন্দ, সদাপ্রভুর আদেশের অতিরিক্ত, কিছুই করতে পারি না। আমি শুধু সেই কথা বলব, যা সদাপ্রভু আমাকে বলে দেবেন।’ ");
INSERT INTO benobcv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","এখন আমি আমার স্বজাতির কাছে ফিরে যাই, কিন্তু এই লোকেরা ভবিষ্যতে আপনার লোকদের প্রতি কী করবে, আসুন, সেই বিষয়ে আপনাকে সচেতন করে দিই।” ");
INSERT INTO benobcv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","পরে সে তার প্রত্যাদেশ ব্যক্ত করল, “বিয়োরের ছেলে বিলিয়মের প্রত্যাদেশ, যার চোখ স্পষ্ট প্রত্যক্ষ করে, তার প্রত্যাদেশ, ");
INSERT INTO benobcv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","তার প্রত্যাদেশ, যে ঐশ বাণী শ্রবণ করে, যিনি পরাৎপরের কাছে থেকে জ্ঞান লাভ করেছে, যে সর্বশক্তিমানের কাছ থেকে দর্শন পায়, যে সাষ্টাঙ্গ প্রণত হয় ও যার চোখ খোলা থাকে। ");
INSERT INTO benobcv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“আমি তাঁকে দেখব, কিন্তু এখন নয়, আমি দর্শন করব, কিন্তু কাছ থেকে নয়; যাকোব থেকে উদিত হবেন এক তারকা, ইস্রায়েল থেকে এক রাজদণ্ডের উত্থান হবে। তিনি মোয়াবের কপালগুলি ও শেথের সমস্ত সন্তানের খুলিগুলি চূর্ণ করবেন। ");
INSERT INTO benobcv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ইদোম পরাভূত হবে, তার শত্রু সেয়ীর পরাভূত হবে, কিন্তু ইস্রায়েল উত্তরোত্তর শক্তিমান হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","যাকোব থেকে এক প্রশাসকের আগমন হবে, তিনি নগরের অবশিষ্ট ব্যক্তিদের বিনাশ করবেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","পরে বিলিয়ম অমালেকের প্রতি দৃষ্টিপাত করে তার প্রত্যাদেশ ব্যক্ত করল, “অমালেক জাতিসমূহের মধ্যে অগ্রগণ্য ছিল, কিন্তু বিনাশই হবে তার পরিণতি।” ");
INSERT INTO benobcv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","তারপর সে কেনীয়দের প্রতি দৃষ্টিপাত করে তার প্রত্যাদেশ ব্যক্ত করল, “তোমার নিবাসস্থল সুরক্ষিত, তোমার নীড় শৈলের মধ্যে স্থাপিত, ");
INSERT INTO benobcv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","তা সত্ত্বেও কেনীয়েরা, তোমার হবে বিধ্বংস যখন আসিরীয়রা বন্দি করে তোমাদের নিয়ে যাবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","তারপর সে তার প্রত্যাদেশ ব্যক্ত করল, “হায়! ঈশ্বর যখন এই কাজ করেন, তখন কে রক্ষা পেতে পারে? ");
INSERT INTO benobcv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","কিত্তীমের সৈকত থেকে জাহাজগুলি আসবে, তারা আসিরিয়া ও এবরকে দমন করবে; কিন্তু তাদের নিজেদেরও বিনাশ হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","এরপরে বিলিয়ম উঠে নিজের ঘরে ফিরে গেল এবং বালাকও নিজের পথে প্রস্থান করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","শিটিমে অবস্থানকালে ইস্রায়েলীরা, মোয়াবীয় স্ত্রীলোকদের সঙ্গে ব্যভিচারে লিপ্ত হল, ");
INSERT INTO benobcv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","যারা তাদের দেবতাদের উদ্দেশে বলিকৃত খাদ্য খাওয়ার জন্য তাদের আমন্ত্রণ জানাল। লোকেরা তা খেয়ে সেই দেবতাদের কাছে প্রণিপাত করল। ");
INSERT INTO benobcv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","এইভাবে ইস্রায়েল, পিয়োরের বায়ালের উপাসনায় যোগ দিল। তখন তাদের বিপক্ষে সদাপ্রভুর ক্রোধ বহ্নিমান হল। ");
INSERT INTO benobcv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","সদাপ্রভু মোশিকে বললেন, “এই জাতির সমস্ত নেতৃবর্গকে নাও এবং প্রকাশ্য দিবালোকে তাদের বধ করো, যেন সদাপ্রভুর প্রচণ্ড ক্রোধ ইস্রায়েল থেকে দূরীভূত হয়।” ");
INSERT INTO benobcv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","তাই মোশি ইস্রায়েলের বিচারকদের বললেন, “তোমরা প্রত্যেকে পিয়োরের বায়াল-প্রতিমার উপাসনাকারী স্বজনদের অবশ্যই বধ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","সেই সময়, একজন ইস্রায়েলী ব্যক্তি, মোশি এবং সমগ্র ইস্রায়েলী সমাজের দৃষ্টিগোচরে, একজন মিদিয়নীয় স্ত্রীলোককে তার বাড়িতে নিয়ে এল। তখন সমাগম তাঁবুর প্রবেশপথে, তারা সকলে কান্নাকাটি করছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","যখন যাজক হারোণের নাতি, ইলিয়াসরের ছেলে পীনহস তা দেখলেন, তিনি সমাজ থেকে প্রস্থান করে হাতে একটি বর্শা নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","তিনি সেই ইস্রায়েলী ব্যক্তিকে অনুসরণ করে তার তাঁবু পর্যন্ত গেলেন। তিনি তাদের উভয়ের, সেই ইস্রায়েলী ব্যক্তি ও স্ত্রীলোকটির পেটে বর্শা বিদ্ধ করলেন। তখন ইস্রায়েলীদের মধ্যে ছড়িয়ে পড়া মহামারি নিবৃত্ত হল; ");
INSERT INTO benobcv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","কিন্তু সেই মহামারিতে যারা মারা গিয়েছিল তাদের সংখ্যা 24,000। ");
INSERT INTO benobcv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“যাজক হারোণের নাতি, ইলিয়াসরের ছেলে পীনহস, ইস্রায়েলীদের প্রতিকূলে আমার ক্রোধ নিবৃত্ত করেছে, কারণ আমার সম্মান রক্ষার জন্য আমার মতোই সেও উদ্যোগী হয়েছে। তাই আমি ক্রোধ প্রকাশ করে তাদের শেষ করে দিইনি। ");
INSERT INTO benobcv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","সেইজন্য তাকে বলো, আমি তার সঙ্গে আমার শান্তিচুক্তি কার্যকর করছি। ");
INSERT INTO benobcv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","সে ও তার বংশধরেরা চিরকাল যাজকত্ব পদের জন্য চুক্তিবদ্ধ হল, কারণ সে তার ঈশ্বরের সম্মান রক্ষার উদ্যোগী হয়ে ইস্রায়েলীদের জন্য প্রায়শ্চিত্ত সাধন করেছে।” ");
INSERT INTO benobcv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","যে ইস্রায়েলী ব্যক্তি, ওই মিদিয়নীয় স্ত্রীলোকটির সঙ্গে হত হয়েছিল, তার নাম সিম্রি। সে সালুর ছেলে ও শিমিয়োনীয় গোষ্ঠীর একজন নেতা ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","আর সেই মিদিয়নীয় স্ত্রীলোক, যাকে হত্যা করা হয়েছিল, তার নাম কস্‌বী। সে মিদিয়ন বংশের জনৈক গোষ্ঠীর প্রধান, সূর-এর মেয়ে ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“মিদিয়নীয়দের শত্রু-জ্ঞান করে তাদের বধ করো। ");
INSERT INTO benobcv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","কারণ তারাও তোমাদের শত্রু-জ্ঞান করেছে; তারা পিয়োর সংক্রান্ত বিষয়ে এবং মিদিয়নীয় জনৈক নেতার মেয়ে তাদের বোন কস্‌বী নামক যে স্ত্রীলোকটি হত হয়েছিল, তার মাধ্যমে তোমাদের প্রতারণা করেছিল। পরিণতিস্বরূপ, এই পিয়োরের জন্য তোমরা মহামারিতে আক্রান্ত হয়েছিলে।” ");
INSERT INTO benobcv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","মহামারির পরে সদাপ্রভু, মোশি ও যাজক হারোণের ছেলে ইলীয়াসরকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“বংশ অনুসারে সমস্ত ইস্রায়েলী সম্প্রদায়ের লোকগণনা করো। তাদের সবাইকে গণনা করো যাদের বয়স কুড়ি বছর বা তারও বেশি এবং যারা ইস্রায়েলী সেনাবাহিনীতে কাজ করতে সক্ষম।” ");
INSERT INTO benobcv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","অতএব মোশি ও যাজক ইলীয়াসর, মোয়াবের সমতলে, জর্ডনের কাছে, যিরীহোর অপর পাশে, তাদের সঙ্গে আলাপ করলেন ও বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“সদাপ্রভু যেমন মোশিকে আদেশ করেছেন, কুড়ি বছর বা তারও বেশি বয়স্ক পুরুষদের সংখ্যা গণনা করো।” এই ইস্রায়েলীরা মিশর থেকে বের হয়ে এসেছিল: ");
INSERT INTO benobcv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ইস্রায়েলের বড়ো ছেলে রূবেণের বংশধরেরা হল: হনোক থেকে হনোকীয় গোষ্ঠী, পল্লু থেকে পল্লুয়ীয় গোষ্ঠী; ");
INSERT INTO benobcv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","হিষ্রোণ থেকে হিষ্রোণীয় গোষ্ঠী, কর্মি থেকে কর্মীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","এরা সবাই রূবেণের গোষ্ঠী; এদের গণিত সংখ্যা ছিল 43,730। ");
INSERT INTO benobcv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","পল্লুর ছেলে ইলীয়াব ");
INSERT INTO benobcv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","এবং ইলীয়াবের ছেলেেরা হল নমূয়েল, দাথন ও অবীরাম। এই দাথন ও অবীরাম ছিলেন সম্প্রদায়ের আধিকারিক, যারা মোশি ও হারোণের বিরুদ্ধে বিদ্রোহ করেছিল। তারা কোরহের অনুগামীদলের অন্তর্ভুক্ত ছিল, যখন তারা সদাপ্রভুর বিপক্ষে বিদ্রোহ করেছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","পৃথিবী, তাঁর মুখ খুলে কোরহের সঙ্গে তার অনুগামী দলকে গ্রাস করেছিল। সেসময় আগুন, 250 জন ব্যক্তিকেও পুড়িয়ে দিয়েছিল। তাদের ঘটনা দৃষ্টান্তস্বরূপ হয়ে রইল। ");
INSERT INTO benobcv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","যাইহোক, কোরহের বংশধরেরা কেউই মারা পড়েনি। ");
INSERT INTO benobcv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","গোষ্ঠী অনুযায়ী, শিমিয়োনের বংশধরেরা হল: নমূয়েল থেকে নমূয়েলীয় গোষ্ঠী, যামীন থেকে যামীনীয় গোষ্ঠী, যাখীন থেকে যাখীনীয় গোষ্ঠী, ");
INSERT INTO benobcv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","সেরহ থেকে সেরহীয় গোষ্ঠী, শৌল থেকে শৌলীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","এরা সবাই শিমিয়োনের গোষ্ঠী। এদের গণিত পুরুষের সংখ্যা 22,200। ");
INSERT INTO benobcv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","গোষ্ঠী অনুযায়ী, গাদের বংশধরেরা হল: সিফোন থেকে সিফোনীয় গোষ্ঠী, হগি থেকে হগীয় গোষ্ঠী, শূনি থেকে শূনীয় গোষ্ঠী, ");
INSERT INTO benobcv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ওষ্ণি থেকে ওষ্ণীয় গোষ্ঠী, এরি থেকে এরীয় গোষ্ঠী; ");
INSERT INTO benobcv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","আরোদ থেকে আরোদীয় গোষ্ঠী, অরেলি থেকে অরেলীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","এরা সবাই গাদের গোষ্ঠী। এদের গণিত সংখ্যা ছিল 40,500। ");
INSERT INTO benobcv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","এর ও ওনন, যিহূদার সন্তান। তারা সবাই কনানে মারা গিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","গোষ্ঠী অনুযায়ী, যিহূদার বংশধরেরা হল: শেলা থেকে শেলানীয় গোষ্ঠী, পেরস থেকে পেরসীয় গোষ্ঠী, সেরহ থেকে সেরহীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","পেরসের বংশধরেরা হল: হিষ্রোণ থেকে হিষ্রোণীয় গোষ্ঠী, হামূল থেকে হামূলীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","এরা সবাই যিহূদার গোষ্ঠী। এদের গণিত সংখ্যা ছিল 76,500। ");
INSERT INTO benobcv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","গোষ্ঠী অনুযায়ী ইষাখরের বংশধরেরা হল: তোলয় থেকে তোলয়ীয় গোষ্ঠী; পূয় থেকে পূয়ীয় গোষ্ঠী, ");
INSERT INTO benobcv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","যাশূব থেকে যাশূবীয় গোষ্ঠী, শিম্রোণ থেকে শিম্রোণীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","এরা সবাই ইষাখরের গোষ্ঠী। এদের গণিত সংখ্যা ছিল 64,300। ");
INSERT INTO benobcv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","গোষ্ঠী অনুযায়ী, সবূলূনের বংশধরেরা হল: সেরদ থেকে সেরদীয় গোষ্ঠী, এলোন থেকে এলোনীয় গোষ্ঠী, যহলেল থেকে যহলেলীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","এরা সবাই সবূলূনের গোষ্ঠী। এদের গণিত সংখ্যা ছিল, 60,500। ");
INSERT INTO benobcv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","গোষ্ঠী অনুযায়ী, মনঃশি ও ইফ্রয়িমের মাধ্যমে, যোষেফের বংশধরেরা হল: ");
INSERT INTO benobcv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","মনঃশির বংশধরেরা হল: মাখীর থেকে মাখীরীয় গোষ্ঠী। (গিলিয়দের বাবা ছিলেন মাখীর) গিলিয়দ থেকে গিলিয়দীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","গিলিয়দের বংশধরেরা হল: ঈয়েষর থেকে ঈয়েষরীয় গোষ্ঠী, হেলক থেকে হেলকীয় গোষ্ঠী, ");
INSERT INTO benobcv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","অস্রীয়েল থেকে অস্রীয়েলীয় গোষ্ঠী, শেখম থেকে শেখমীয় গোষ্ঠী, ");
INSERT INTO benobcv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","শিমীদা থেকে শিমীদায়ীয় গোষ্ঠী, হেফর থেকে হেফরীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(হেফরের ছেলে সলফাদের কোনো ছেলে ছিল না। তাঁর শুধুমাত্র কয়েকটি মেয়ে ছিল। তাদের নাম ছিল মহলা, নোয়া, হগ্‌লা, মিল্কা ও তির্সা) ");
INSERT INTO benobcv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","এরা সবাই মনঃশির গোষ্ঠী। এদের গণিত সংখ্যা ছিল 52,700। ");
INSERT INTO benobcv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","গোষ্ঠী অনুযায়ী ইফ্রয়িমের বংশধরেরা হল: শূথেলহ থেকে শূথেলহীয় গোষ্ঠী, বেখর থেকে বেখরীয় গোষ্ঠী, তহন থেকে তহনীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","এরা সবাই শূথেলহের বংশধর, এরণ থেকে এরণীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","এরা সবাই ইফ্রয়িম গোষ্ঠী। এদের গণিত সংখ্যা ছিল 32,500। গোষ্ঠী অনুযায়ী, এরা সকলে যোষেফের বংশধর। ");
INSERT INTO benobcv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","গোষ্ঠী অনুযায়ী, বিন্যামীনের বংশধরেরা হল: বেলা থেকে বেলায়ীয় গোষ্ঠী, অস্‌বেল থেকে অস্‌বেলীয় গোষ্ঠী। অহীরাম থেকে অহীরামীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","শূফম থেকে শূফমীয় গোষ্ঠী, হুফম থেকে হুফমীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","অর্দ এবং নামানের মাধ্যমে, বেলার বংশধরেরা হল: অর্দ থেকে অর্দীয় গোষ্ঠী, নামান থেকে নামানীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","এরা সবাই বিন্যামীনের গোষ্ঠী। এদের গণিত সংখ্যা হল 45,600। ");
INSERT INTO benobcv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","গোষ্ঠী অনুযায়ী, দানের বংশধরেরা হল: শূহম থেকে শূহমীয় গোষ্ঠী। এরা সবাই দানের গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","তারা সবাই শূহমীয় গোষ্ঠীভুক্ত ছিল। তাদের গণিত সংখ্যা ছিল 64,400। ");
INSERT INTO benobcv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","গোষ্ঠী অনুযায়ী, আশেরের বংশধরেরা হল: যিম্ন থেকে যিম্নীয় গোষ্ঠী, যিস্‌বি থেকে যিস্‌বীয় গোষ্ঠী, বরিয় থেকে বরিয়ীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","আবার বরিয়ের বংশধরেরা হল: হেবর থেকে হেবরীয় গোষ্ঠী, মল্কীয়েল থেকে মল্কীয়েলীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","আশেরের সারহ নামে একটি মেয়ে ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","এরা সবাই আশেরের গোষ্ঠী, তাদের গণিত সংখ্যা ছিল, 53,400। ");
INSERT INTO benobcv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","গোষ্ঠী অনুযায়ী, নপ্তালির বংশধরেরা হল: যহসীয়েল থেকে যহসীয়েলীয় গোষ্ঠী, গূনি থেকে গূনীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","যেৎসর থেকে যেৎসরীয় গোষ্ঠী, শিল্লেম থেকে শিল্লেমীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","এরা সবাই নপ্তালির গোষ্ঠী। এদের গণিত সংখ্যা ছিল 45,400। ");
INSERT INTO benobcv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ইস্রায়েলী পুরুষদের সর্বমোট গণিত সংখ্যা ছিল 6,01,730 জন। ");
INSERT INTO benobcv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“নামের গণিত সংখ্যা অনুযায়ী তাদের মধ্যে ভূমির স্বত্বাধিকার বণ্টন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","বড়ো দলকে বেশি এবং ছোটো দলকে অল্প স্বত্বাধিকার দিতে হবে। নামের তালিকা অনুযায়ী, প্রত্যেক ব্যক্তি তার স্বত্বাধিকার লাভ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ভূমি নিশ্চিতরূপে গুটিকাপাতের মাধ্যমে বন্টিত হবে। পিতৃ-গোষ্ঠীর নাম অনুযায়ী প্রতিটি দল স্বত্বাধিকার লাভ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","বড়ো বা ছোটো সমস্ত দলের মধ্যেই গুটিকাপাতের মাধ্যমে বন্টিত হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","এই লেবীয়েরাও তাদের গোষ্ঠী অনুযায়ী গণিত হল: গের্শোন থেকে গের্শোনীয় গোষ্ঠী, কহাৎ থেকে কহাতীয় গোষ্ঠী, মরারি থেকে মরারীয় গোষ্ঠী। ");
INSERT INTO benobcv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","এরাও সবাই লেবীয় গোষ্ঠী ছিল: লিব্‌নীয় গোষ্ঠী, হিব্রোণীয় গোষ্ঠী, মহলীয় গোষ্ঠী, মূশীয় গোষ্ঠী, কোরহীয় গোষ্ঠী। (কহাৎ অম্রামের পূর্বপুরুষ ছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","অম্রামের স্ত্রীর নাম যোকেবদ। ইনি লেবির বংশ। মিশরে ও লেবি গোষ্ঠীতে তাঁর জন্ম হয়েছিল। অম্রামের জন্য তিনি হারোণ, মোশি ও তাঁদের দিদি মরিয়মকে জন্ম দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","হারোণ ছিলেন নাদব, অবীহূ, ইলীয়াসর ও ঈথামরের বাবা। ");
INSERT INTO benobcv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","কিন্তু নাদব ও অবীহূ অশুচি আগুনের মাধ্যমে সদাপ্রভুর উদ্দেশে নৈবেদ্য উৎসর্গ করায় মারা পড়েছিল।) ");
INSERT INTO benobcv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","এক মাস বা তারও বেশি বয়স্ক লেবীয়দের সব পুরুষের গণিত সংখ্যা ছিল 23,000। অন্য ইস্রায়েলীদের সঙ্গে তাদের গণনা করা হয়নি, কারণ তাদের মধ্যে তারা কোনো স্বত্বাধিকার প্রাপ্ত হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","মোশি ও যাজক ইলীয়াসর মোয়াবের সমতলে জর্ডনের তীরে যিরীহোর অপর পাশে এই ইস্রায়েলীদের গণনা করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","মোশি ও যাজক হারোণ, সীনয় মরুভূমিতে, যে ইস্রায়েলীদের গণনা করেছিলেন, এই গণিত লোকদের মধ্যে তাদের একজনও অন্তর্ভুক্ত ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","কারণ সদাপ্রভু সেই ইস্রায়েলীদের বলেছিলেন যে তারা নিশ্চিতরূপেই প্রান্তরে মারা যাবে। তাই যিফূন্নির ছেলে কালেব ও নূনের ছেলে যিহোশূয় ছাড়া, তাদের একজনও অবশিষ্ট ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","মনঃশির ছেলে মাখীর, তাঁর ছেলে গিলিয়দ, তাঁর ছেলে হেফর; তাঁর ছেলে সলফাদের মেয়েরা, যোষেফের ছেলে মনঃশির গোষ্ঠীভুক্ত ছিল। সেই মেয়েদের নাম ছিল মহলা, নোয়া, হগ্‌লা, মিল্কা ও তির্সা। ");
INSERT INTO benobcv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","তারা সমাগম তাঁবুর প্রবেশ মুখে মোশি, যাজক ইলীয়াসর, নেতৃবর্গ এবং সমগ্র সমাজের সামনে এসে দাঁড়াল। তারা বলল, ");
INSERT INTO benobcv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“আমাদের বাবা প্রান্তরে মারা গিয়েছিলেন। যারা সদাপ্রভুর বিপক্ষে জোটবদ্ধ হয়েছিল, সেই কোরহের অনুগামীদের মধ্যে তিনি ছিলেন না, কিন্তু তিনি নিজের পাপেই মারা গিয়েছেন এবং কোনো ছেলে রেখে যাননি। ");
INSERT INTO benobcv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","যেহেতু তাঁর ছেলে নেই, তাই আমাদের বাবার নাম, তাঁর গোষ্ঠী থেকে কেন অবলুপ্ত হবে? আমাদের বাবার আত্মজনের মধ্যে থেকে, আমাদের ভূমির স্বত্বাধিকার দিন।” ");
INSERT INTO benobcv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","মোশি তাদের আবেদন সদাপ্রভুর সামনে নিয়ে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","সদাপ্রভু তাঁকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“সলফাদের কন্যাগণ সঠিক কথাই বলেছে। তুমি নিশ্চিতরূপে তাদের বাবার আত্মীয়দের অধিকারের মধ্যে, তাদের ভূমির স্বত্বাধিকার দেবে এইভাবে, তাদের বাবার স্বত্বাধিকার, তাদের দান করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“ইস্রায়েলীদের বলো, ‘যদি কোনো ব্যক্তি মারা যায় ও তার ছেলে না থাকে তাহলে স্বত্বাধিকার তার মেয়ের হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","যদি তার মেয়েও না থাকে, তবে তার ভ্রাতৃবৃন্দকে সেই স্বত্বাধিকার দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","যদি তার ভ্রাতৃবৃন্দও না থাকে, তাহলে তার পিতৃকুলের ভ্রাতৃগণকে তার স্বত্বাধিকার দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","যদি তার বাবারও কোনো ভাই না থাকে, তাহলে গোষ্ঠীর নিকটতম আত্মীয়কে তা দান করতে হবে। এইভাবে সে তার স্বত্বাধিকার লাভ করবে। ইস্রায়েলীদের জন্য এই বিধি হবে আইনানুগ, কারণ সদাপ্রভু মোশিকে এরকমই আদেশ দিয়েছেন।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","তারপর সদাপ্রভু মোশিকে বললেন, “অবারীম পর্বতশ্রেণীর এই পর্বতে ওঠো এবং ইস্রায়েলীদের যে দেশ আমি দিতে চাই, সেই দেশ দেখো। ");
INSERT INTO benobcv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","সেটি দেখার পর তুমিও, তোমার দাদা হারোণের মতো স্বজনবর্গের কাছে সংগৃহীত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","কারণ সীন মরুভূমিতে যখন জনতা জলের জন্য বিদ্রোহ করেছিল, তোমরা উভয়েই আমার আদেশের অবাধ্য হয়ে তাদের দৃষ্টিগোচরে আমাকে পবিত্র বলে সম্মান করোনি।” (এই জল ছিল সীন মরুভূমির মরীবা কাদেশের জল।) ");
INSERT INTO benobcv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","মোশি সদাপ্রভুকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“হে সদাপ্রভু, সমগ্র মানবজাতির আত্মাস্বরূপ ঈশ্বর, এই সম্প্রদায়ের উপরে এক ব্যক্তিকে নিযুক্ত করুন, ");
INSERT INTO benobcv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","যে তাদের সামনে গমনাগমন করবে ও তাদের নেতৃত্ব দিয়ে বাইরে নিয়ে যাবে ও ভিতরে নিয়ে আসবে, যেন সদাপ্রভুর প্রজারা পালকবিহীন মেষপালের মতো না হয়।” ");
INSERT INTO benobcv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","অতএব সদাপ্রভু মোশিকে বললেন, “নূনের ছেলে যিহোশূয়কে নিয়ে তার উপরে তুমি তোমার হাত রাখো, সে আত্মাবিষ্ট ব্যক্তি। ");
INSERT INTO benobcv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","তাকে যাজক ইলীয়াসর ও সমগ্র সমাজের সামনে দাঁড় করাও এবং তাদের উপস্থিতিতে তাকে নিয়োগ করো। ");
INSERT INTO benobcv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","তোমার কর্তৃত্বভারের কিছু অংশ তাঁকে দাও, যেন সমগ্র ইস্রায়েলী সম্প্রদায় তাঁকে মেনে চলে। ");
INSERT INTO benobcv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","সে যাজক ইলিয়াসরের সামনে দাঁড়াবে, যে তার জন্য সদাপ্রভুর কাছে, ঊরিম মারফত সদাপ্রভুর সিদ্ধান্ত যাচ্ঞা করবে। তাঁর আদেশে সে এবং সমস্ত ইস্রায়েলী সম্প্রদায় বাইরে যাবে এবং তাঁর আদেশে তারা ভিতরে আসবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","মোশি ঠিক তাই করলেন, যে রকম সদাপ্রভু তাঁকে আদেশ করেছিলেন। তিনি যিহোশূয়কে নিয়ে যাজক ইলীয়াসর ও সমগ্র সমাজের সামনে দাঁড় করালেন। ");
INSERT INTO benobcv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","তারপর তিনি তাঁর উপর হাত রাখলেন এবং তাঁকে নিয়োগ করলেন যেমন সদাপ্রভু মোশির মাধ্যমে সেরকমই নির্দেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ইস্রায়েলীদের আদেশ দিয়ে তাদের এই কথা বলো, ‘তোমরা নিরূপিত সময়ে, আমার আনন্দদায়ক সুরভিরূপে, আগুনের মাধ্যমে ভক্ষ্য-নৈবেদ্য উৎসর্গ করবে।’ ");
INSERT INTO benobcv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","তাদের বলো, ‘আগুনের মাধ্যমে অনুরূপ নৈবেদ্য তোমরা সদাপ্রভুর উদ্দেশে প্রতিদিন হোম-নৈবেদ্যরূপে ক্রুটিহীন এক বর্ষীয় দুটি মেষশাবক উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","একটি মেষ সকালে ও অন্যটি গোধূলিবেলায় উৎসর্গ কোরো। ");
INSERT INTO benobcv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","তার সঙ্গে শস্য-নৈবেদ্য হিসেবে, এক ঐফার এক-দশমাংশ মিহি ময়দা, এক হিনের এক-চতুর্থাংশ নিষ্পেষিত জলপাই তেলের সঙ্গে মিশ্রিত করে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","এই নিয়মিত হোম-নৈবেদ্য, সীনয় পর্বতে স্থাপিত আনন্দদায়ক সুরভিত বলি, যা সদাপ্রভুর উদ্দেশে এক ভক্ষ্য-নৈবেদ্য। ");
INSERT INTO benobcv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","এর পেয়-নৈবেদ্যরূপে, প্রত্যেকটি মেষশাবকের সঙ্গে, এক হিনের এক-চতুর্থাংশ গাঁজানো দ্রাক্ষারস দিতে হবে। সেই পেয়-নৈবেদ্য, পবিত্রস্থানে সদাপ্রভুর উদ্দেশে ঢেলে দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","সন্ধ্যাবেলায় দ্বিতীয় মেষটি, একই ধরনের শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য সহযোগে প্রস্তুত করবে, যেমন সকালবেলা করেছিল। এটি ভক্ষ্য-নৈবেদ্য, আগুনের মাধ্যমে সদাপ্রভুর আনন্দদায়ক সুরভিরূপে নিবেদিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘বিশ্রামবারে ক্রুটিহীন এক বর্ষীয় দুটি মেষশাবক নিয়ে উৎসর্গ করবে। সেই সঙ্গে তার পরিপূরক পেয়-নৈবেদ্য ও শস্য-নৈবেদ্যরূপে, এক ঐফার দুই-দশমাংশ মিহি ময়দা তেলে মিশ্রিত করে নিবেদন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","নিয়মিত হোম-নৈবেদ্য ও পরিপূরক পেয়-নৈবেদ্যর অতিরিক্ত এই হোম-নৈবেদ্য প্রতি বিশ্রামবারের জন্য প্রযোজ্য। ");
INSERT INTO benobcv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘প্রত্যেক মাসের প্রথম দিনে, সদাপ্রভুর কাছে দুটি এঁড়ে বাছুর, একটি মেষ এবং সাতটি মদ্দা মেষশাবক, হোম-নৈবেদ্যরূপে উৎসর্গ করবে। এদের প্রত্যেকটিই ত্রুটিহীন হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","প্রত্যেকটি এঁড়ে বাছুরের সঙ্গে শস্য-নৈবেদ্যরূপে এক ঐফার তিন-দশমাংশ মিহি ময়দা তেলে মিশ্রিত করে দিতে হবে। মেষটির জন্য শস্য-নৈবেদ্য হবে, তেলে মিশ্রিত এক ঐফার দুই-দশমাংশ মিহি ময়দা; ");
INSERT INTO benobcv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","আবার প্রত্যেকটি মেষশাবকের শস্য-নৈবেদ্য হবে এক ঐফার এক-দশমাংশ তেলে মিশ্রিত মিহি ময়দা। এই সমস্ত হোম-নৈবেদ্য, আগুনের মাধ্যমে, সদাপ্রভুর আনন্দদায়ক সুরভিরূপে নিবেদিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","এদের পরিপূরক পেয়-নৈবেদ্য হবে, প্রত্যেকটি এঁড়ে বাছুরের সঙ্গে হিনের এক অর্ধাংশ; মেষটির হিনের এক-তৃতীয়াংশ এবং প্রত্যেকটি মেষশাবকের সঙ্গে হিনের এক-চতুর্থাংশ দ্রাক্ষারস। বছরের প্রত্যেক অমাবস্যায় এই মাসিক হোম-নৈবেদ্য উৎসর্গ করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক পেয়-নৈবেদ্যর সঙ্গে পাপার্থক বলিরূপে, সদাপ্রভুর কাছে একটি পাঁঠাও উপহার দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘প্রথম মাসের চতুর্দশ দিনে, সদাপ্রভুর নিস্তারপর্ব অনুষ্ঠিত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","এই মাসের পঞ্চদশ দিনে এক উৎসব হবে। সাত দিন খামিরবিহীন রুটি ভোজন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","প্রথম দিনে পবিত্র সমাবেশ রাখবে এবং সেদিন নিয়মিত কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","সদাপ্রভুর নিকট আগুনের মাধ্যমে এক নৈবেদ্য, অর্থাৎ এক হোম-নৈবেদ্য নিবেদন কোরো। দুটি এঁড়ে বাছুর, একটি মেষ ও সাতটি এক বর্ষীয় মদ্দা মেষশাবক নিতে হবে। এর সব কটিই ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","প্রত্যেকটি এঁড়ে বাছুরের সঙ্গে পরিপূরক শস্য-নৈবেদ্য দিতে হবে, তেলে মিশ্রিত এক ঐফার তিন-দশমাংশ মিহি ময়দা, মেষটির সঙ্গে দুই-দশমাংশ ");
INSERT INTO benobcv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ও সাতটি মেষশাবকের প্রত্যেক সাতটি মেষের জন্য এক-দশমাংশ মিহি ময়দা। ");
INSERT INTO benobcv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","তোমাদের প্রায়শ্চিত্ত সাধনের উদ্দেশে, পাপার্থক বলির জন্য একটি পাঁঠাও নেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","সকালবেলায় নিয়মিত হোম-নৈবেদ্যর অতিরিক্তিরূপে এই সমস্তের আয়োজন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","এইভাবে সাত দিন ধরে প্রত্যেকদিন, সদাপ্রভুর আনন্দদায়ক সুরভিরূপে নিবেদিত ভক্ষ্য-নৈবেদ্যর আয়োজন করবে। নিয়িমিত হোম-নৈবেদ্য ও তার পরিপূরক পেয়-নৈবেদ্যর অতিরিক্তরূপে এই আয়োজন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","সপ্তম দিনে পবিত্র সভা রাখবে এবং সেদিন কোনো নিয়মিত কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘প্রথম উৎপন্ন শস্যের দিনে, সাত সপ্তাহের উৎসবে, যখন তোমরা সদাপ্রভুকে নতুন শস্য নিবেদন করবে, পবিত্র নতুন শস্যের সভা আহ্বান করবে এবং কোনো নিয়মিত কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","সদাপ্রভুর আনন্দদায়ক সুরভিস্বরূপ হোম-নৈবেদ্যরূপে, দুটি এঁড়ে বাছুর, একটি মেষ ও সাতটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","প্রত্যেকটি এঁড়ে বাছুরের জন্য পরিপূরক শস্য-নৈবেদ্য হবে তেলে মিশ্রিত এক ঐফার তিন-দশমাংশ মিহি ময়দা; মেষটির জন্য দুই-দশমাংশ ");
INSERT INTO benobcv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","এবং সাতটি মেষশাবকের প্রত্যেকটির জন্য এক-দশমাংশ করে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","তোমাদের প্রায়শ্চিত্ত সাধনের উদ্দেশে একটি পাঁঠাও নেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","নিয়মিত হোম-নৈবেদ্য ও শস্য-নৈবেদ্যর অতিরিক্তরূপে এই সমস্তের আয়োজন পেয়-নৈবেদ্য সহযোগে করবে। নিশ্চিত হবে, যেন পশুগুলি ত্রুটিহীন হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘সপ্তম মাসের প্রথম দিনে, এক পবিত্র সভার আয়োজন কোরো এবং কোনো নিয়মিত কাজ করবে না। এই দিন তোমরা তূরী বাজাবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","সদাপ্রভুর আনন্দদায়ক সুরভিস্বরূপ হোম-নৈবেদ্যরূপে ত্রুটিহীন একটি এঁড়ে বাছুর, একটি মেষ ও সাতটি এক বর্ষীয় মেষশাবকের আয়োজন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","এঁড়ে বাছুরটির সঙ্গে শস্য-নৈবেদ্য দিতে হবে, এক ঐফার তিন-দশমাংশ জলপাই তেলে মিশ্রিত মিহি ময়দা, মেষটির সঙ্গে দুই-দশমাংশ ");
INSERT INTO benobcv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","এবং সাতটি মেষশাবকের প্রত্যেকটির সঙ্গে এক-দশমাংশ। ");
INSERT INTO benobcv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","তোমাদের প্রায়শ্চিত্ত সাধনের উদ্দেশে পাপার্থক বলির জন্য একটি পাঁঠাও নেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","যেমন সবিস্তারে বর্ণিত হয়েছে, এসব নৈবেদ্য, মাসিক ও প্রাত্যহিক হোম-নৈবেদ্য এবং তার পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্যর অতিরিক্ত। এই সমস্তই অগ্নির মাধ্যমে সদাপ্রভুকে নিবেদিত আনন্দদায়ক সুরভিত ভক্ষ্য-নৈবেদ্য। ");
INSERT INTO benobcv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘এই সপ্তম মাসের দশম দিনে এক পবিত্র সভা আহ্বান করবে। তোমরা কৃচ্ছ্রসাধন করবে এবং কোনো কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","সদাপ্রভুর কাছে আনন্দদায়ক সুরভিস্বরূপ হোম-নৈবেদ্যর জন্য একটি এঁড়ে বাছুর, একটি মেষ ও সাতটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","এঁড়ে বাছুরটির জন্য পরিপূরক শস্য-নৈবেদ্যরূপে আনতে হবে এক ঐফার তিন-দশমাংশ তেলে মিশ্রিত মিহি ময়দা; মেষটির সঙ্গে দুই-দশমাংশ, ");
INSERT INTO benobcv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","সাতটি মেষশাবকের প্রত্যেকটির সঙ্গে এক-দশমাংশ করে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","প্রায়শ্চিত্তের জন্য পাপার্থক বলিরূপে নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্যর অতিরিক্ত পাপার্থক বলিরূপে একটি পাঁঠাও অন্তর্ভুক্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘সপ্তম মাসের পঞ্চদশ দিনে, একটি পবিত্র সভার আয়োজন করবে এবং সেদিন কোনো নিয়মিত কাজ করবে না। সদাপ্রভুর উদ্দেশে, সাত দিন ব্যাপী এক আনন্দোৎসব করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","তেরোটি এঁড়ে বাছুর, দুটি মেষ এবং চোদ্দটি এক বর্ষীয় মদ্দা মেষশাবক নিয়ে, আগুনের মাধ্যমে সদাপ্রভুর আনন্দদায়ক সুরভিরূপে হোম-নৈবেদ্য উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","পরিপূরক শস্য-নৈবেদ্য আনতে হবে, তেরোটি এঁড়ে বাছুরের প্রত্যেকটির জন্য এক ঐফার তিন-দশমাংশ, দুটি মেষের প্রত্যেকটির সঙ্গে দুই-দশমাংশ ");
INSERT INTO benobcv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","এবং চোদ্দটি মেষশাবকের প্রত্যেকটির সঙ্গে এক-দশমাংশ তেলে মিশ্রিত মিহি ময়দা। ");
INSERT INTO benobcv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","নিয়মিত হোম-নৈবেদ্য এবং তার পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্যর অতিরিক্ত, পাপার্থক বলিরূপে একটি পাঁঠাও অন্তর্ভুক্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘দ্বিতীয় দিনে বারোটি এঁড়ে বাছুর, দুটি মেষ ও চোদ্দটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। এদের প্রত্যেকটি ত্রুটিহীন হতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","সেই ষাঁড়, মেষ ও মেষশাবকদের সংখ্যা অনুযায়ী তাদের পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","পাপার্থক বলিরূপে একটি পাঁঠাও অন্তর্ভুক্ত করবে। এই সমস্ত, নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক শস্য-নৈবেদ্য ও তাদের পেয়-নৈবেদ্যর অতিরিক্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘তৃতীয় দিনে এগারোটি ষাঁড়, দুটি মেষ ও চোদ্দটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","সেই ষাঁড়, মেষ ও মেষশাবকদের সংখ্যা অনুযায়ী তাদের পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","পাপার্থক বলির জন্য একটি পাঁঠাও অন্তর্ভুক্ত করবে। এই সমস্ত নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক শস্য-নৈবেদ্য ও তাদের পেয়-নৈবেদ্যর অতিরিক্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘চতুর্থ দিনে এগারোটি ষাঁড়, দুটি মেষ ও চোদ্দটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","সেই ষাঁড়, মেষ ও মেষশাবকদের সংখ্যা অনুযায়ী, তাদের পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","নিয়মিত হোম-নৈবেদ্য এবং তার পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্যর অতিরিক্ত, পাপার্থক বলিরূপে একটি পাঁঠাও অন্তর্ভুক্ত করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘পঞ্চম দিনে নয়টি ষাঁড়, দুটি মেষ ও চোদ্দটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","সেই ষাঁড়, মেষ ও মেষশাবকদের সংখ্যা অনুযায়ী, তাদের পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","পাপার্থক বলির জন্য একটি পাঁঠাও অন্তর্ভুক্ত করবে। এই সমস্ত, নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক শস্য-নৈবেদ্য ও তাদের পেয়-নৈবেদ্যর অতিরিক্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘ষষ্ঠ দিনে আটটি ষাঁড়, দুটি মেষ ও চোদ্দটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","সেই ষাঁড়, মেষ ও মেষশাবকদের সংখ্যা অনুযায়ী তাদের পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","পাপার্থক বলির জন্য একটি পাঁঠাও অন্তর্ভুক্ত করবে। এই সমস্ত, নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক শস্য-নৈবেদ্য ও তাদের পেয়-নৈবেদ্যর অতিরিক্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘সপ্তম দিনে সাতটি ষাঁড় মেষ, দুটি মেষ ও চোদ্দটি এক বর্ষীয় মদ্দা মেষশাবক উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","সেই ষাঁড়, মেষ ও মেষশাবকদের সংখ্যা অনুযায়ী, তাদের পরিপূরক শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","পাপার্থক বলির জন্য একটি পাঁঠাও অন্তর্ভুক্ত করবে। এই সমস্ত নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক শস্য-নৈবেদ্য ও তাদের পেয়-নৈবেদ্যর অতিরিক্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘অষ্টম দিনে শেষ দিনের এক বিশেষ সভা করবে এবং কোনো নিয়মিত কাজ করবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","একটি ষাঁড়, একটি মেষ ও সাতটি এক বর্ষীয় মদ্দা মেষশাবক নিয়ে, সদাপ্রভুর আনন্দদায়ক সুরভিত উপহাররূপে, আগুনের মাধ্যমে হোম-নৈবেদ্য উৎসর্গ করবে। প্রত্যেকটি ত্রুটিহীন হওয়া চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","সেই ষাঁড়, মেষ এবং মেষশাবকগুলির সঙ্গে, সংখ্যা অনুযায়ী তাদের শস্য-নৈবেদ্য ও পেয়-নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","পাপার্থক বলির জন্য একটি পাঁঠাও অন্তর্ভুক্ত করবে। এই সমস্ত, নিয়মিত হোম-নৈবেদ্য ও তার পরিপূরক শস্য-নৈবেদ্য ও তাদের পেয়-নৈবেদ্যর অতিরিক্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘তোমাদের মানত ও স্বেচ্ছাদানের অতিরিক্তরূপে, তোমাদের নিরূপিত উৎসবসমূহে, সদাপ্রভুর উদ্দেশে এই সমস্ত উৎসর্গ করবে। তোমাদের হোম-নৈবেদ্য, শস্য-নৈবেদ্য, পেয়-নৈবেদ্য ও মঙ্গলার্থক-নৈবেদ্য থেকে এই সমস্ত স্বতন্ত্র।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","সদাপ্রভু মোশিকে যে সমস্ত আদেশ দিয়েছিলেন, তিনি ইস্রায়েলীদের সেই সমস্তই বললেন। ");
INSERT INTO benobcv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","মোশি, ইস্রায়েলী গোষ্ঠীপ্রধানদের বললেন, “সদাপ্রভু এই আদেশ দিয়েছেন, ");
INSERT INTO benobcv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","যখন কোনো ব্যক্তি সদাপ্রভুর উদ্দেশে কোনো মানত স্থির করে, অথবা শপথপূর্বক কোনো অঙ্গীকারে নিজেকে আবদ্ধ করে, তাহলে সে নিজের শপথের অন্যথা করবে না, কিন্তু যা কিছু সে অঙ্গীকার করে, তা অবশ্যই পালন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“কোনো যুবতী যদি তার পিতৃগৃহে অবস্থানকালে, সদাপ্রভুর উদ্দেশে কোনো মানত স্থিত করে অথবা অঙ্গীকারে নিজেকে আবদ্ধ করে, ");
INSERT INTO benobcv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","এবং তার বাবা যদি সেই মানত এবং অঙ্গীকার শোনে, কিন্তু তাকে কিছুই না বলে, তাহলে যার দ্বারা সে আবদ্ধ হয়েছে, সেই সমস্ত মানত এবং অঙ্গীকার স্থির থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","কিন্তু সেই শপথ শোনার পর যদি তার বাবা তাকে নিষেধ করে থাকে, তাহলে তার কোনও মানত বা অঙ্গীকার, যার দ্বারা সে আবদ্ধ হয়েছে, স্থির থাকবে না। সদাপ্রভু তাকে মুক্তি দেবেন, কারণ তার বাবা তাকে নিষেধ করেছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“যদি সে মানত স্থির করে বা ওষ্ঠনির্গত, অবিবেচনাপূর্ণ শপথের দ্বারা নিজেকে আবদ্ধ করে বিবাহিতা হয়, ");
INSERT INTO benobcv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","এবং তার স্বামী সেকথা শুনলেও তাকে কিছু না বলে, তাহলে তার মানত বা অঙ্গীকার, যার দ্বারা সে আবদ্ধ হয়েছিল, স্থির থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","কিন্তু সেকথা শোনার পর যদি তার স্বামী নিষেধ করে থাকে এবং তার মানত বা যে অবিবেচনাপূর্ণ শপথ দ্বারা সে নিজেকে আবদ্ধ করেছে তা বাতিল করে দেয়, সদাপ্রভু তাকে মুক্ত করবেন। ");
INSERT INTO benobcv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“বিধবা বা বিবাহ-বিচ্ছিন্না স্ত্রীর যে কোনো মানত বা বাধ্যবাধকতা তার বন্ধনস্বরূপ হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“যদি কোনো স্ত্রীলোক, তার স্বামীর সঙ্গে বসবাস করার সময়, কোনো মানত স্থির করে বা শপথপূর্বক কোনো অঙ্গীকারে আবদ্ধ হয়, ");
INSERT INTO benobcv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","তার স্বামী সেকথা শুনেও যদি তাকে কিছু না বলে এবং তাকে নিষেধ না করে, তাহলে তার সমস্ত মানত এবং অঙ্গীকার, যার দ্বারা সে নিজেকে আবদ্ধ করেছে, স্থির থাকবে। ");
INSERT INTO benobcv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","কিন্তু সেই সমস্ত শোনার পর যদি তার স্বামী সব বাতিল করে দেয়, তাহলে কোনও মানত বা তার ওষ্ঠনির্গত অঙ্গীকারের শপথ স্থির থাকবে না। তার স্বামী সেই সমস্ত বাতিল করেছে, অতএব সদাপ্রভু তাকে মুক্ত করবেন। ");
INSERT INTO benobcv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","তার প্রত্যেক মানত ও অঙ্গীকারকে দুঃখ দেবার প্রতিজ্ঞাযুক্ত প্রত্যেক মানত তার স্বামী স্থির করতেও পারে বা ব্যর্থ করতেও পারে। ");
INSERT INTO benobcv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","কিন্তু দিন-প্রতিদিন, এই সম্পর্কে যদি তার স্বামী তাকে কিছু না বলে, তাহলে তার সমস্ত মানত ও অঙ্গীকার, যার দ্বারা সে আবদ্ধ হয়, সে তার অনুমোদন করে। সমস্ত বিষয় শোনার পরও তাকে কিছু না বলার পরিণতিস্বরূপ সে সেই সমস্তের অনুমোদন করে। ");
INSERT INTO benobcv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","কিন্তু, যদি সে সেই সমস্ত শোনার কিছুদিন পরে বাতিল করে, তাহলে সে তার স্ত্রীর অপরাধের জন্য দায়ী হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","পুরুষ ও স্ত্রীর সম্পর্কে এবং বাবা ও তার যুবতী মেয়ে, যখন সে পিতৃগৃহে থাকে, তাদের সম্পর্কের এই সমস্ত নিয়মবিধি, সদাপ্রভু মোশির মাধ্যমে দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ইস্রায়েলীদের তরফে মিদিয়নীয়দের উপর প্রতিশোধ নাও। তারপর তুমি তোমার স্বজনবর্গের কাছে সংগৃহীত হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","অতএব মোশি লোকদের বললেন, “মিদিয়নীয়দের বিপক্ষে যুদ্ধ করার জন্য তোমরা কিছু ব্যক্তিকে অস্ত্রসজ্জিত করো, যেন সদাপ্রভুর জন্য তাদের বিরুদ্ধে প্রতিশোধ গ্রহণ করে। ");
INSERT INTO benobcv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ইস্রায়েলের প্রত্যেক গোষ্ঠী থেকে এক এক হাজার সৈন্য যুদ্ধে পাঠাও।” ");
INSERT INTO benobcv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","অতএব ইস্রায়েলী বংশসমূহ থেকে, প্রত্যেক গোষ্ঠীর এক হাজার করে বারো হাজার সৈন্য, সমর সজ্জায় সজ্জিত হল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","মোশি প্রত্যেক গোষ্ঠী থেকে এক হাজার ব্যক্তিকে যুদ্ধে পাঠালেন। তাদের সঙ্গে যাজক ইলিয়াসরের ছেলে পীনহসকেও পাঠানো হল। তিনি পবিত্রস্থান থেকে পবিত্র জিনিসগুলি ও সংকেত জ্ঞাপনের উদ্দেশে তূরী সঙ্গে নিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","সদাপ্রভু যেমন মোশিকে আদেশ দিয়েছিলেন, তারা মিদিয়নের বিপক্ষে যুদ্ধ করে তাদের প্রত্যেক পুরুষকে বধ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","তাদের শিকারের মধ্যে ছিল, মিদিয়নের পাঁচজন রাজা—ইবি, রেকম, সূর, হূর ও রেবা। তারা বিয়োরের ছেলে বিলিয়মকেও তরোয়ালের আঘাতে বধ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ইস্রায়েলীরা, মিদিয়নীয় স্ত্রীলোক ও ছেলেমেয়েদের বন্দি করল এবং তারা তাদের গবাদি পশু, মেষপাল ও সমস্ত জিনিস লুণ্ঠন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","তারা তাদের নগরগুলি, যেখানে তারা বসবাস করত এবং তাদের সমস্ত ছাউনি পুড়িয়ে দিল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","তারা মানুষ ও পশু সমেত সমস্ত লুন্ঠিত দ্রব্য ও সমস্ত প্রাণীকে নিয়ে গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","সমস্ত বন্দি, ধৃত প্রাণী ও লুন্ঠিত জিনিসগুলি নিয়ে তারা মোশি, যাজক ইলিয়াসর ও ইস্রায়েলী সমাজের কাছে তাদের ছাউনিতে, মোয়াবের সমতলে, জর্ডনের সমীপে, যিরীহোর অপর পাশে নিয়ে এল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","মোশি, যাজক ইলিয়াসর ও মণ্ডলীর সমস্ত নেতৃবর্গ, ছাউনির বাইরে তাদের সঙ্গে দেখা করতে গেলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","মোশি যুদ্ধ থেকে ফেরা দায়িত্বপ্রাপ্ত সেনা আধিকারিকদের, অর্থাৎ সহস্র-সেনাপতি ও শত-সেনাপতিদের উপর রুষ্ট হলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","তিনি তাদের প্রশ্ন করলেন, “তোমরা কি সব স্ত্রীলোককে জীবিত রেখেছ? ");
INSERT INTO benobcv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","বিলিয়মের পরামর্শে তারাই ইস্রায়েলীদের সদাপ্রভুর কাছে থেকে পথভ্রষ্ট করেছিল। পিয়োরে সেই ঘটনা ঘটেছিল যখন সদাপ্রভুর প্রজারা এক মহামারি দ্বারা আক্রান্ত হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","এখন সব কিশোরকে বধ করো। পুরুষের সঙ্গে শায়িতা সব স্ত্রীলোককেও বধ করো, ");
INSERT INTO benobcv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","কিন্তু, যারা কোনো পুরুষের সঙ্গে কখনও শয়ন করেনি, সেই কুমারীদের নিজেদের জন্য জীবিত রাখো। ");
INSERT INTO benobcv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“তোমাদের মধ্যে প্রত্যেকে, যারা কাউকে বধ করেছে বা নিহত কাউকে স্পর্শ করেছে, ছাউনির বাইরে সাত দিন অবস্থিতি করবে। তৃতীয় ও সপ্তম দিনে, তোমরা নিজেদের ও তোমাদের বন্দিদের অবশ্যই শুদ্ধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","প্রত্যেকটি বস্ত্র, সেই সঙ্গে চর্মনির্মিত, ছাগ-লোম বা কাঠ নির্মিত সমস্ত দ্রব্যকে শুদ্ধ করতে হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","তারপর যাজক ইলিয়াসর, যারা যুদ্ধে গিয়েছিল, সেই সৈন্যদের বললেন, “সদাপ্রভু মোশিকে যা বলেছিলেন, সেই বিধানের চাহিদা এই, ");
INSERT INTO benobcv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","সোনা, রুপো, ব্রোঞ্জ, লোহা, টিন, সীসা, ");
INSERT INTO benobcv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","এবং অন্য যে সমস্ত দ্রব্য আগুনের উত্তাপ সহ্য করতে পারে, তাদের আগুনের মধ্য দিয়ে পরিশোধন করতে হবে, তখন তা শুদ্ধ হবে। তা সত্ত্বেও, শুদ্ধকরণের জল দিয়ে সেসব পরিশোধন করতে হবে। যে কোনো দ্রব্য আগুনের উত্তাপ সহ্য করতে পারে না, সেগুলি জলে পরিশোধন করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","সপ্তম দিনে তোমরা নিজেদের বস্ত্র ধুয়ে পরিষ্কৃত হবে। তারপর তোমরা ছাউনিতে প্রবেশ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“তুমি, যাজক ইলিয়াসর এবং সমাজের বংশ-প্রধানেরা, সমস্ত বন্দি মানুষ ও ধৃত পশুদের সংখ্যা গণনা করো। ");
INSERT INTO benobcv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","যারা যুদ্ধে অংশগ্রহণ করেছিল, সেই সৈন্যদের মধ্যে ও সমাজের অবশিষ্ট ব্যক্তিদের মধ্যে লুন্ঠিত দ্রব্য সমান ভাগে ভাগ করো। ");
INSERT INTO benobcv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","যারা যুদ্ধ করেছিল সেই সৈন্যদের কাছ থেকে মানুষ অথবা গবাদি পশু, গাধা, মেষ বা ছাগল, প্রত্যেক 500 প্রাণী প্রতি একটি করে প্রাণী সদাপ্রভুকে দেয় রাজস্ব হিসেবে পৃথক করো। ");
INSERT INTO benobcv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","তাদের প্রাপ্য এই অর্ধাংশ থেকে এই রাজস্ব নিয়ে, সদাপ্রভুর অংশ হিসেবে, যাজক ইলিয়াসরকে দান করো। ");
INSERT INTO benobcv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ইস্রায়েলীদের প্রাপ্য অর্ধাংশ থেকে, মানুষ, গবাদি পশু, গাধা, মেষ, ছাগল বা অন্য পশু, প্রত্যেক পঞ্চাশটি প্রাণী প্রতি একটি করে প্রাণী পৃথক করো। সেই সমস্ত নিয়ে লেবীয়দের দাও, যারা সদাপ্রভুর আবাস তাঁবুর রক্ষণাবেক্ষণের দায়িত্বে আছে।” ");
INSERT INTO benobcv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","অতএব মোশি ও যাজক ইলিয়াসর ঠিক তাই করলেন, যেমন সদাপ্রভু মোশিকে বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","অন্যান্য লুন্ঠিত দ্রব্য ছাড়া সৈন্যদের ধৃত প্রাণীর সংখ্যা, 6,75,000-টি মেষ, ");
INSERT INTO benobcv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000-টি গবাদি পশু, ");
INSERT INTO benobcv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000-টি গাধা, ");
INSERT INTO benobcv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","এবং 32,000 জন কুমারী যারা কখনও কোনো পুরুষের সঙ্গে শয়ন করেনি। ");
INSERT INTO benobcv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","যারা যুদ্ধে অংশগ্রহণ করেছিল, তাদের প্রাপ্ত অর্ধাংশ ছিল: 3,37,500-টি মেষ, ");
INSERT INTO benobcv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","এর মধ্যে সদাপ্রভুকে দেয় রাজস্বের সংখ্যা 675-টি মেষ; ");
INSERT INTO benobcv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000-টি গবাদি পশু, এর মধ্যে সদাপ্রভুকে দেয় রাজস্বের সংখ্যা 72-টি পশু; ");
INSERT INTO benobcv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500-টি গাধা, এর মধ্যে সদাপ্রভুকে দেয় রাজস্বের সংখ্যা 61; ");
INSERT INTO benobcv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 জন মানুষ, এর মধ্যে সদাপ্রভুকে দেয় রাজস্বের সংখ্যা 32-টি গাধা। ");
INSERT INTO benobcv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","মোশি এই রাজস্ব নিয়ে, সদাপ্রভুর প্রাপ্য বলে যাজক ইলিয়াসরকে দিলেন, যেমন সদাপ্রভু মোশিকে বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ইস্রায়েলীদের প্রাপ্য অর্ধেকাংশ, যা মোশি সৈন্যদের প্রাপ্ত অর্ধাংশ থেকে পৃথক করে রেখেছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","অর্থাৎ সমাজের প্রাপ্য অর্ধাংশ ছিল 3,37,500-টি মেষ, ");
INSERT INTO benobcv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000-টি গবাদি পশু, ");
INSERT INTO benobcv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500-টি গাধা ");
INSERT INTO benobcv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","এবং 16,000 জন মানুষ। ");
INSERT INTO benobcv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ইস্রায়েলীদের অর্ধাংশ থেকে, মোশি প্রতি পঞ্চাশ জন মানুষ ও পশু থেকে একটি করে পৃথক করলেন, যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন এবং তিনি সেই সমস্ত নিয়ে লেবীয়দের দিলেন, যারা সদাপ্রভুর আবাস তাঁবুর রক্ষণাবেক্ষণের দায়িত্বে ছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","তখন সামরিক বিভাগের পদস্থ আধিকারিকেরা, অর্থাৎ সহস্র-সেনাপতিরা ও শত-সেনাপতিরা, মোশির কাছে গিয়ে, ");
INSERT INTO benobcv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","তাঁকে বললেন, “আপনার সেবকেরা আমাদের অধীনস্থ সৈন্যদের গণনা করে দেখেছে, তাদের মধ্যে একজনও নিরুদ্দেশ হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","অতএব আমরা আমাদের অর্জিত স্বর্ণালংকার থেকে, সদাপ্রভুর কাছে নৈবেদ্য এনেছি—তাগা, বালা, আংটি, কানের দুল ও গলার হার—যেন সদাপ্রভুর কাছে আমরা নিজেদের জন্য প্রায়শ্চিত্ত করতে পারি।” ");
INSERT INTO benobcv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","মোশি ও যাজক ইলিয়াসর, তাদের কাছে থেকে সেই সোনা—সকল কারুকার্যময় দ্রব্য গ্রহণ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","সহস্র-সেনাপতির ও শত-সেনাপতির কাছে থেকে গৃহীত সমস্ত সোনার পরিমাণ, যা মোশি ও যাজক ইলিয়াসর সদাপ্রভুকে নিবেদন করেছিলেন, তার ওজন 16,750 শেকল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","সৈনিকরা প্রত্যেকে নিজেদের জন্য লুন্ঠিত দ্রব্য নিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","মোশি ও যাজক ইলিয়াসর সেই সোনা, সহস্র সেনা অধিনায়ক ও শত সেনা অধিনায়কদের কাছ থেকে গ্রহণ করে এবং সদাপ্রভুর সামনে ইস্রায়েলীদের জন্য স্মারকরূপে সমাগম তাঁবুতে নিয়ে এলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","রূবেণ ও গাদ গোষ্ঠীর খুব বড়ো বড়ো গোপাল ও মেষপাল ছিল। তারা দেখল যে যাসের ও গিলিয়দ অঞ্চল পশুপালনের জন্য উপযোগী। ");
INSERT INTO benobcv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","তারা মোশি, ও যাজক ইলিয়াসর এবং সমাজের নেতৃবর্গের কাছে এল এবং বলল, ");
INSERT INTO benobcv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“অটারোৎ, দীবোন, যাসের, নিম্রা, হিষ্‌বোন, ইলিয়ালী, সেবাম, নেবো ও বিয়োন, ");
INSERT INTO benobcv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","সদাপ্রভু ইস্রায়েলীদের সামনে যে সমস্ত অঞ্চলের পতন ঘটিয়েছেন, তা পশুপালের জন্য উপযোগী এবং আপনাদের সেবকদের কাছে পশুপাল আছে। ");
INSERT INTO benobcv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","যদি আমরা আপনাদের দৃষ্টিতে কৃপা লাভ করে থাকি,” তারা বলল, “তাহলে স্বত্বাধিকাররূপে এই ভূমি আমাদের দান করা হোক। আমাদের জর্ডনের অপর পারে যেতে বাধ্য করবেন না।” ");
INSERT INTO benobcv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","গাদ ও রূবেণ গোষ্ঠীর সবাইকে মোশি বললেন, “তোমাদের ইস্রায়েলী ভাইয়েরা যুদ্ধে যাবে আর তোমরা সবাই এখানে বসে থাকবে? ");
INSERT INTO benobcv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","সদাপ্রভু যে দেশ ইস্রায়েলীদের দান করেছেন, তোমরা সেখানে যেতে কেন তাদের নিরুৎসাহ করছ? ");
INSERT INTO benobcv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","এরকমই কাজ তোমাদের পূর্বপুরুষেরা করেছিল, যখন আমি কাদেশ-বর্ণেয় থেকে তাদের দেশ পর্যবেক্ষণ করতে পাঠিয়েছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","তারা ইষ্কোল উপত্যকা পর্যন্ত উঠে গিয়ে দেশ নিরীক্ষণ করে এসে, যে দেশ সদাপ্রভু তাদের দান করেছিলেন, সেই দেশে প্রবেশ করতে ইস্রায়েলীদের হতোদ্যম করেছিল। ");
INSERT INTO benobcv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","সেদিন সদাপ্রভুর ক্রোধ প্রজ্বলিত হয়েছিল এবং তিনি শপথ করে বলেছিলেন, ");
INSERT INTO benobcv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘যেহেতু তারা সর্বান্তঃকরণে আমার অনুগমন করেনি, তাই তাদের মধ্যে যাদের বয়স কুড়ি বছর বা তারও বেশি, যারা মিশর থেকে বেরিয়ে এসেছিল, তাদের মধ্যে একজনও সেই দেশে প্রবেশ করবে না, যে দেশ আমি অব্রাহাম, ইস্‌হাক ও যাকোবের নিকট দেওয়ার প্রতিজ্ঞা করেছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","কেবলমাত্র, কনিষীয়, যিফূন্নির ছেলে কালেব ও নূনের ছেলে যিহোশূয় ছাড়া, অন্য একজনও নয়, কারণ তারা সর্বান্তঃকরণে সদাপ্রভুর অনুগমন করেছিল।’ ");
INSERT INTO benobcv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ইস্রায়েলের বিপক্ষে সদাপ্রভুর ক্রোধ বহ্নিমান হয়েছিল, তিনি চল্লিশ বছর তাদের প্রান্তরে পরিভ্রমণ করিয়েছিলেন, যতদিন না সেই সম্পূর্ণ প্রজন্ম, যারা তার দৃষ্টিতে কুকাজ করেছিল, মারা গেল। ");
INSERT INTO benobcv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“এখন, পাপিষ্ঠ ব্যক্তিদের সন্তান তোমরা সকলে, যারা তোমাদের পূর্বপুরুষদের স্থানে দণ্ডায়মান হয়েছে, ইস্রায়েলীদের বিপক্ষে সদাপ্রভুকে আরও বেশি রুষ্ট করছ। ");
INSERT INTO benobcv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","যদি তোমরা তাঁর অনুগমন থেকে ফিরে আস, তিনি এই সমস্ত লোককে প্রান্তরে পরিত্যাগ করবেন এবং তোমরাই তাদের বিনাশের কারণ হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","তারা তখন তাঁর কাছে এসে বলল, “আমরা এখানে আমাদের পশুপালের জন্য খোঁয়াড় ও স্ত্রী-সন্তানদের জন্য নগর নির্মাণ করতে চাই। ");
INSERT INTO benobcv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","তা সত্ত্বেও, আমরা অস্ত্রসজ্জিত হয়ে, ইস্রায়েলের পুরোভাগে যাব, যতদিন না তাদের গন্তব্য স্থানে নিয়ে যাই। এসময়, আমাদের স্ত্রী ও সন্তানেরা, দেশবাসীদের থেকে নিরাপত্তার জন্য সুরক্ষিত নগরে বসবাস করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","যতক্ষণ না প্রত্যেক ইস্রায়েলী তাদের অধিকার লাভ করে, আমরা আমাদের বাড়িতে ফিরে যাব না, ");
INSERT INTO benobcv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","জর্ডনের অপর পাড়ে, আমরা তাদের সঙ্গে আর কোনো স্বত্বাধিকার গ্রহণ করব না, কারণ আমাদের স্বত্বাধিকার জর্ডনের পূর্বপাড়ে আমরা প্রাপ্ত হয়েছি।” ");
INSERT INTO benobcv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","তখন মোশি তাদের বললেন, “যদি তোমরা সেরকম করো, সদাপ্রভুর সামনে যুদ্ধের জন্য যদি নিজেদের অস্ত্রসজ্জা গ্রহণ করো, ");
INSERT INTO benobcv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","যদি তোমাদের প্রত্যেক ব্যক্তি সদাপ্রভুর সামনে, সশস্ত্র হয়ে জর্ডনের অন্য পাড়ে যাও, যতক্ষণ না তিনি তাঁর শত্রুদের তাঁর সামনে থেকে বিতাড়িত করেন, ");
INSERT INTO benobcv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","যখন দেশ, সদাপ্রভুর সামনে পদানত হবে, তখন তোমরা ফিরে আসতে পারো এবং সদাপ্রভু ও ইস্রায়েলীদের প্রতি বাধ্যবাধকতা থেকে মুক্ত হতে পারো। তখন সদাপ্রভুর সামনে এই ভূমির স্বত্বাধিকার, তোমাদের হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“কিন্তু এই কাজ করতে যদি অক্ষম হও, তোমরা সদাপ্রভুর বিপক্ষে পাপ করবে। তাহলে নিশ্চিত জেনো, তোমাদের পাপ তোমাদের ধরবে। ");
INSERT INTO benobcv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","তোমাদের স্ত্রী ও সন্তানদের জন্য নগর ও পশুপালের জন্য খোঁয়াড় নির্মাণ করো, কিন্তু যা শপথ করেছ, কাজেও তা পূর্ণ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","গাদ ও রূবেণ গোষ্ঠী মোশিকে বলল, “আমদের প্রভু যেমন আদেশ দিলেন, আপনার দাস আমরা তাই করব। ");
INSERT INTO benobcv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","আমাদের স্ত্রী ও সন্তানেরা, মেষপাল ও গোপালসমূহ, গিলিয়দ অঞ্চলের এই সমস্ত নগরে অবস্থান করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","কিন্তু আপনার দাসেরা, যুদ্ধের জন্য সশস্ত্র প্রত্যেক পুরুষ, সদাপ্রভুর সামনে যুদ্ধের জন্য জর্ডন পার হয়ে যাবে, যেমন আমাদের প্রভু বলেছেন।” ");
INSERT INTO benobcv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","মোশি তখন তাদের সম্বন্ধে, যাজক ইলিয়াসর, নূনের ছেলে যিহোশূয় এবং ইস্রায়েল গোষ্ঠীর বংশ-প্রধানদের আদেশ দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","তিনি তাদের বললেন, “যদি গাদ ও রূবেণ গোষ্ঠীর প্রত্যেক পুরুষ যুদ্ধের জন্য সসজ্জ হয়, সদাপ্রভুর সামনে তোমাদের সঙ্গে জর্ডন অতিক্রম করে, তাহলে দেশ যখন তোমাদের সামনে পদানত হবে, তখন স্বত্বাধিকারস্বরূপ তাদের গিলিয়দের ভূমি দান করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","কিন্তু সশস্ত্র হয়ে তারা যদি তোমাদের সঙ্গে জর্ডন অতিক্রম না করে, তাহলে তারা অবশ্যই তাদের স্বত্বাধিকার, কনানে, তোমাদের সঙ্গে লাভ করবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","গাদ ও রূবেণ গোষ্ঠী উত্তর দিল, “সদাপ্রভু যে রকম বলেছেন, আপনার দাসেরা সেরকমই করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","আমরা সদাপ্রভুর সামনে, সশস্ত্র অবস্থায় পার হয়ে কনানে প্রবেশ করব, কিন্তু আমাদের অধিকারস্বরূপ স্বত্ব, জর্ডনের এই পাড়ে থাকবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","তখন মোশি, গাদ গোষ্ঠী, রূবেণ গোষ্ঠী ও যোষেফের ছেলে মনঃশির অর্ধগোষ্ঠীকে, ইমোরীয় রাজা সীহোনের রাজ্য ও বাশনের রাজা ওগের রাজ্য দান করলেন। তাদের নগর সমেত সমস্ত দেশ ও তাদের সন্নিহিত অঞ্চলগুলিও দিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","গাদ গোষ্ঠী দীবোন, অটারোৎ, অরোয়ের, ");
INSERT INTO benobcv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","অটারোৎ শোফন, যাসের, যগ্‌বিহ, ");
INSERT INTO benobcv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","বেথ-নিম্রা ও বেত-হারণ, সুরক্ষিত নগর এবং পশুপালের খোঁয়াড় নির্মাণ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","আবার রূবেণ গোষ্ঠী হিষ্‌বোন, ইলিয়ালী ও কিরিয়াথয়িম, ");
INSERT INTO benobcv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","সেই সঙ্গে নেবো, বায়াল-মিয়োন (এই নামগুলি পরিবর্তিত হয়েছিল) এবং সিব্‌মা। এসব নগর তারা পুনর্নির্মাণ করে তাদের নামকরণ করল। ");
INSERT INTO benobcv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","মনঃশির ছেলে মাখীরের বংশধরেরা গিলিয়দে গিয়ে তা দখল করল ও যারা সেখানে ছিল, সেই ইমোরীয়দের বিতাড়িত করল। ");
INSERT INTO benobcv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","তাই মোশি, মনঃশির বংশধর মাখীরীয়দের গিলিয়দ দান করলেন। তারা সেখানেই উপনিবেশ স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","মনঃশির বংশধর যায়ীরও তাদের উপনিবেশগুলি দখল করে সেগুলির নাম হব্বোথ-যায়ীর রাখলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","নোবহ, কনাৎ ও তার সন্নিহিত অঞ্চলগুলি দখল করে তার নিজের নামানুসারে তার নাম নোবহ রাখল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","মোশি এবং হারোণের নেতৃত্বে যখন ইস্রায়েলীরা মিশর থেকে সৈন্য শ্রেণীবিভাগ অনুযায়ী বের হয়েছিল, তখন এই হল যাত্রাপথের পর্যায়ক্রমিক বিবরণ। ");
INSERT INTO benobcv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","সদাপ্রভুর আদেশমতো মোশি তাদের যাত্রাপথের পর্যায়ক্রমের বিবরণ নথিভুক্ত করেন। এই হল তাদের যাত্রাপথের পর্যায়ক্রম বিবরণ। ");
INSERT INTO benobcv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","প্রথম মাসের পঞ্চদশ দিনে, নিস্তারপর্বের পরদিন, ইস্রায়েলীরা রামিষেষ থেকে বের হয়। তারা সমস্ত মিশরীয়ের সামনে দিয়ে সদম্ভে বেরিয়ে আসে। ");
INSERT INTO benobcv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","সেই সময় তারা তাদের প্রথমজাত সন্তানের কবর দিচ্ছিল, যাদের সদাপ্রভু আঘাত করে বধ করেছিলেন। এইভাবে ঈশ্বর তাদের দেবতাদের বিচার করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ইস্রায়েলীরা রামিষেষ ত্যাগ করে সুক্কোতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","তারা সুক্কোৎ ত্যাগ করে মরুভূমির প্রান্তে, এথমে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","তারা এথম ত্যাগ করে, পী-হহীরোতের বিপরীতমুখী হয়ে, বায়াল-সফোনের পূর্বপ্রান্তে এল। তারপর মিগ্‌দোলের কাছে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","তারা পী-হহীরোৎ ত্যাগ করে, সমুদ্রের ভিতর দিয়ে মরুভূমিতে গেল এবং এথমের প্রান্তরে তিনদিনের পথ অতিক্রম করে, তারা মারায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","মারা ত্যাগ করে তারা এলীমে গেল, যেখানে বারোটি জলের উৎস ও সত্তরটি খেজুর গাছ ছিল। তারা সেখানে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","তারা এলীম ত্যাগ করে লোহিত সাগরতীরে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","তারা লোহিত সাগর ত্যাগ করে, সীন প্রান্তরে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","সীন প্রান্তর ত্যাগ করে তারা দপ্‌কাতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","দপ্‌কা ত্যাগ করে তারা আলূশে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","আলূশ ত্যাগ করে তারা রফীদীমে ছাউনি স্থাপন করল, যেখানে লোকদের পান করার জন্য জল ছিল না। ");
INSERT INTO benobcv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","রফীদীম ত্যাগ করে তারা সীনয় মরুভূমিতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","সীনয় মরুভূমি ত্যাগ করে তারা কিব্রোৎ-হত্তাবায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","কিব্রোৎ-হত্তাবা ত্যাগ করে তারা হৎসেরোতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","হৎসেরোৎ ত্যাগ করে তারা রিৎমায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","রিৎমা ত্যাগ করে তারা রিম্মোণ-পেরসে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","রিম্মোণ-পেরস ত্যাগ করে তারা লিব্‌নায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","লিব্‌না ত্যাগ করে তারা রিস্‌সায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","রিস্‌সা ত্যাগ করে তারা কহেলাথায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","কহেলাথা ত্যাগ করে তারা শেফর পর্বতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","শেফর পর্বত ত্যাগ করে তারা হরাদায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","হরাদা ত্যাগ করে তারা মখেলোতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","মখেলোৎ ত্যাগ করে তারা তহতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","তহৎ ত্যাগ করে তারা তেরহে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","তেরহ ত্যাগ করে তারা মিৎকায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","মিৎকা ত্যাগ করে তারা হশ্‌মোনায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","হশ্‌মোনা ত্যাগ করে তারা মোষেরোতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","মোষেরোৎ ত্যাগ করে তারা বনেয়াকনে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","বনেয়াকন ত্যাগ করে তারা হোর্-হগিদ্‌গদে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","হোর্-হগিদ্‌গদ ত্যাগ করে তারা যট্‌বাথায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","যট্‌বাথা ত্যাগ করে তারা অব্রোণায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","অব্রোণা ত্যাগ করে তারা ইৎসিয়োন-গেবরে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ইৎসিয়োন-গেবর ত্যাগ করে তারা সীন মরুভূমিতে, কাদেশে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","কাদেশ ত্যাগ করে তারা ইদোমের সীমানায়, হোর পর্বতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","সদাপ্রভুর আদেশে যাজক হারোণ হোর পর্বতে উঠে গেলেন। ইস্রায়েলীদের মিশর থেকে বের হওয়ার পর, চল্লিশতম বছরের পঞ্চম মাসের প্রথম দিনে, তিনি সেখানে প্রাণত্যাগ করলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","হোর পর্বতে মারা যাবার সময় হারোণের বয়স হয়েছিল, 123 বছর। ");
INSERT INTO benobcv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","কনানীয় রাজা অরাদ, যিনি কনানের নেগেভ অঞ্চলে বসবাস করতেন, তিনি শুনলেন যে ইস্রায়েলীরা আসছে। ");
INSERT INTO benobcv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","তারা হোর পর্বত ত্যাগ করে সল্‌মোনায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","সল্‌মোনা ত্যাগ করে তারা পূনোনে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","পূনোন ত্যাগ করে তারা ওবোতে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ওবোৎ ত্যাগ করে তারা মোয়াবের সীমানায় ঈয়ী-অবারীমে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","তারা ঈয়ী-অবারীম ত্যাগ করে দীবোন গাদে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","তারা দীবোন গাদ ত্যাগ করে অল্‌মোন দিব্লাথয়িমে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","অল্‌মোন দিব্লাথয়িম ত্যাগ করে তারা নেবোর কাছে অবারীম পর্বতমালায় ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","অবারীম পর্বতমালা ত্যাগ করে জর্ডন সমীপে, যিরীহোর অপর পাশে, মোয়াবের সমতলে ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","সেখানে, তারা মোয়াবের সমতলে, জর্ডন বরাবর, বেথ-যিশীমোৎ থেকে আবেল শিটিম পর্যন্ত ছাউনি স্থাপন করল। ");
INSERT INTO benobcv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","জর্ডন সমীপে, যিরীহোর অপর পাশে, মোয়াবের সমতলে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ইস্রায়েলীদের সঙ্গে কথা বলো এবং তাদের বলো, ‘তোমরা যখন জর্ডন অতিক্রম করে কনানে যাবে, ");
INSERT INTO benobcv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","সেখানকার সমস্ত অধিবাসীদের বিতাড়িত করবে। তাদের সমস্ত ক্ষোদিত প্রতিমা ও ছাঁচে ঢালা দেবমূর্তি বিনষ্ট এবং তাদের উচ্চস্থলগুলি ধ্বংস করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","দেশ দখল করে তার মধ্যে উপনিবেশ স্থাপন করবে, কারণ আমি ওই দেশ তোমাদের অধিকারের জন্য দিয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","গোষ্ঠী অনুসারে গুটিকাপাত দ্বারা সেই দেশ তোমরা ভাগ করবে। বেশি লোককে বেশি অংশ এবং যাদের লোকসংখ্যা অল্প তাদের অল্প অংশ দেবে। গুটিকাপাত দ্বারা তাদের যা নির্ধারিত হবে তা তাদেরই। তোমাদের পৈতৃক গোষ্ঠী অনুযায়ী তা বণ্টন করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘কিন্তু, যদি তোমরা সেই দেশনিবাসীদের তাড়িয়ে না দাও, যাদের তোমরা বসবাস করার অনুমতি দেবে, তারা তোমাদের চোখের শূল ও বুকের অঙ্কুশস্বরূপ হবে। যে দেশে তোমরা বসবাস করবে, সেখানে তারা তোমাদের ক্লেশ দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","তখন আমি তোমাদের প্রতি তাই করব, যা আমি তাদের প্রতি করতে মনস্থ করেছিলাম।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ইস্রায়েলীদের আদেশ দাও, তাদের বলো, ‘যখন তোমরা কনানে প্রবেশ করবে, যে দেশ তোমাদের স্বত্বাধিকাররূপে বণ্টন করা হবে, তার সীমানা হবে এইরকম: ");
INSERT INTO benobcv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘তোমাদের দক্ষিণপ্রান্তের সীমানা হবে, ইদোমের সীমানা বরাবর, সীন মরুভূমির কিছুটা অংশ। পূর্বপ্রান্তে, তোমাদের দক্ষিণ দিকের সীমানা শুরু হবে মরুসাগরের প্রান্তভাগ থেকে। ");
INSERT INTO benobcv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","বৃশ্চিক গিরিপথের দক্ষিণভাগ অতিক্রম করে, সীন পর্যন্ত গিয়ে তা কাদেশ-বর্ণেয়ের দক্ষিণ দিক পর্যন্ত বিস্তৃত হবে। তারপরে তা হৎসর-অদর পর্যন্ত গিয়ে অস্‌মোন পর্যন্ত যাবে। ");
INSERT INTO benobcv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","সেখানে বেঁকে গিয়ে মিশরের ওয়াদি ও ভূমধ্যসাগরের প্রান্তে গিয়ে সংযুক্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","তোমাদের পশ্চিম প্রান্তের সীমানা হবে ভূমধ্যসাগরের উপকুলভাগ। এই হবে তোমাদের পশ্চিম সীমানা। ");
INSERT INTO benobcv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","তোমাদের উত্তরপ্রান্তের সীমানার জন্য, ভূমধ্যসাগর থেকে হোর পর্বত ");
INSERT INTO benobcv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","এবং হোর পর্বত থেকে লেবো-হমাৎ পর্যন্ত সরলরেখা বরাবর হবে। তারপর সীমানা সদাদ পর্যন্ত গিয়ে, ");
INSERT INTO benobcv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","সিফ্রোণ হয়ে হৎসর-ঐনন পর্যন্ত বিস্তৃত হবে। এই হবে তোমাদের উত্তর সীমানা। ");
INSERT INTO benobcv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","তোমাদের পূর্ব প্রান্তের সীমানার জন্য হৎসর-ঐনন থেকে শফাম পর্যন্ত সরলরেখা বরাবর হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","সীমানা শফাম থেকে নিচে ঐনের পূর্বপ্রান্তে রিব্লা পর্যন্ত যাবে; সেখান থেকে গালীল সাগরের পূর্ব প্রান্তের ঢাল বরাবর বিস্তৃত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","তারপর সীমানা জর্ডন বরাবর নেমে গিয়ে মরুসাগরে শেষ হবে। “ ‘এই হবে চতুর্দিকের সীমানা সম্বন্ধিত তোমাদের দেশ।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","মোশি ইস্রায়েলীদের নির্দেশ দিলেন, “এই দেশের স্বত্বাধিকার গুটিকাপাতের মাধ্যমে বণ্টন করে অধিকার করবে। সদাপ্রভু আদেশ দিয়েছেন যে সাড়ে নয় গোষ্ঠীকে এই ভূমি দান করা হবে, ");
INSERT INTO benobcv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","কারণ রূবেণ গোষ্ঠী, গাদ গোষ্ঠী ও মনঃশির অর্ধ গোষ্ঠীর বংশসমূহ তাদের স্বত্বাধিকার প্রাপ্ত হয়েছে। ");
INSERT INTO benobcv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","এই আড়াই গোষ্ঠী, সূর্যোদয় অভিমুখে, যিরীহোর সন্নিহিত জর্ডনের পূর্বপ্রান্তে তাদের, স্বত্বাধিকার লাভ করেছে।” ");
INSERT INTO benobcv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“যে ব্যক্তিরা তোমাদের মধ্যে স্বত্বাধিকার ভাগ করবে, তাদের নাম এরকম: যাজক ইলিয়াসর ও নূনের ছেলে যিহোশূয়। ");
INSERT INTO benobcv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","আবার প্রত্যেক গোষ্ঠী থেকে ভূমি বিভাগের জন্য এক একজন নেতাকে সাহায্যকারী নিয়োগ করো। ");
INSERT INTO benobcv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“তাদের নামগুলি হবে: “যিহূদা গোষ্ঠী থেকে, যিফূন্নির ছেলে কালেব। ");
INSERT INTO benobcv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","শিমিয়োন গোষ্ঠী থেকে অম্মীহূদের ছেলে শমূয়েল। ");
INSERT INTO benobcv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","বিন্যামীন গোষ্ঠী থেকে কিশ্‌লোনের ছেলে ইলীদদ। ");
INSERT INTO benobcv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","দান গোষ্ঠীর নেতা, যগ্‌লির ছেলে বুক্কি। ");
INSERT INTO benobcv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","যোষেফের ছেলে মনঃশি গোষ্ঠীর নেতা, এফোদের ছেলে হন্নীয়েল। ");
INSERT INTO benobcv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","যোষেফের ছেলে ইফ্রয়িম গোষ্ঠীর নেতা, শিপ্তনের ছেলে কমূয়েল ");
INSERT INTO benobcv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","সবূলূন গোষ্ঠীর নেতা, পর্ণকের ছেলে ইলীষাফণ। ");
INSERT INTO benobcv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ইষাখর গোষ্ঠীর নেতা, অস্‌সনের ছেলে পল্‌টিয়েল। ");
INSERT INTO benobcv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","আশের গোষ্ঠীর নেতা, শলোমির ছেলে অহীহূদ। ");
INSERT INTO benobcv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","নপ্তালি গোষ্ঠীর নেতা, অম্মীহূদের ছেলে পদহেল।” ");
INSERT INTO benobcv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","কনান দেশে ইস্রায়েলীদের মধ্যে অধিকার বিভাগ করে দিতে সদাপ্রভু এই লোকদের আদেশ দিয়েছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","মোয়াবের সমতলে, যিরীহোর অপর পাশে, জর্ডন সন্নিহিত অঞ্চলে, সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ইস্রায়েলীদের আদেশ দাও যেন তারা যে স্বত্বাধিকার লাভ করবে, তার মধ্য থেকে যেন কয়েকটি নগর লেবীয়দের বাস করার জন্য দান করে। সেইসব নগর সন্নিহিত চারণভূমিও যেন তাদের দেওয়া হয়। ");
INSERT INTO benobcv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","তাহলে তারা সেই সমস্ত নগরে বসবাস করবে এবং তাদের গবাদি পশু, মেষপাল ও অন্যান্য প্রাণীর জন্য চারণভূমিও লাভ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“তোমরা লেবীয়দের জন্য নগরের চতুর্দিকে যে চারণভূমি দান করবে, তা নগরের প্রাচীর থেকে পরের একশো হাত পর্যন্ত বিস্তৃত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","নগরের বাইরে, পূর্বদিকে 2,000 হস্ত, দক্ষিণ দিকে 2,000 হস্ত, পশ্চিমদিকে 2,000 হস্ত ও উত্তর দিকে 2,000 হাত, মাঝখানে নগরটি থাকবে। তারা এই এলাকা, নগরের সকলের চারণভূমি হিসেবে প্রাপ্ত হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“যে সমস্ত নগর তোমরা লেবীয়দের দেবে, তার মধ্যে ছয়টি আশ্রয়-নগর হবে। কোনো ব্যক্তি কাউকে বধ করে থাকলে সেখানে পালিয়ে যেতে পারবে। তার অতিরিক্ত তাদের আরও বিয়াল্লিশটি নগর দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","তোমরা লেবীয়দের জন্য চারণভূমি সমেত মোট আটচল্লিশটি নগর দেবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ইস্রায়েলীয়দের অধিকৃত অংশ থেকে যে সমস্ত নগর তোমরা লেবীয়দের দেবে, তা প্রত্যেক গোষ্ঠীর প্রাপ্ত অধিকার অনুসারে হবে। যে গোষ্ঠীর বেশি সংখ্যা আছে, তাদের থেকে নগরের সংখ্যা বেশি নেবে, কিন্তু যাদের কম আছে, তাদের থেকে কম সংখ্যক নগর নেবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","তারপর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ইস্রায়েলীদের সঙ্গে কথা বলো, তাদের বলো, ‘যখন তোমরা জর্ডন পার হয়ে কনান দেশে যাবে, ");
INSERT INTO benobcv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","তখন কয়েকটি নগর মনোনীত করবে যেগুলি আশ্রয়-নগর হবে, যেন কেউ ভ্রান্তিবশত কারোর প্রাণ নিলে সেখানে পলায়ন করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","সেইগুলি প্রতিশোধলিপ্সু ব্যক্তির কাছে রক্ষাকারী আশ্রয়স্থল হবে, যেন নরহত্যার দায়ে অভিযুক্ত ব্যক্তি, মণ্ডলীর সামনে বিচারিত হওয়ার আগেই মারা না পড়ে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","এই যে ছয়টি নগর তোমরা দান করবে, সেগুলি তোমাদের আশ্রয়-নগর হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","জর্ডনের এই পাড়ে তিনটি এবং কনানে তিনটি আশ্রয়-নগর দান করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ইস্রায়েলী এবং যেসব বিদেশি তোমাদের মধ্যে বসবাস করছে তাদের জন্য এই ছয়টি নগর আশ্রয়স্থল হবে, যেন কেউ যদি ভ্রান্তিবশত কারোর প্রাণ নেয় তাহলে সেখানে পলায়ন করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘যদি কোনো ব্যক্তি, অন্য কোনো ব্যক্তিকে কোনো লৌহ পদার্থ দিয়ে এমন আঘাত করে যে তার মৃত্যু হয়, তাহলে সেই ব্যক্তি হত্যাকারী; সেই হত্যাকারী ব্যক্তিকে মৃত্যুদণ্ড দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","অথবা যদি কোনো ব্যক্তির হাতে একটি পাথর থাকে এবং সে অন্য এক ব্যক্তিকে তার দ্বারা এমন আঘাত করে যে তার মৃত্যু হয়, তাহলে সেই ব্যক্তি হত্যাকারী; সেই হত্যাকারী ব্যক্তিকে মৃত্যুদণ্ড দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","অথবা নিহত হতে পারে এমন কোনো কাঠের বস্তু কারোর হাতে থাকে এবং তার দ্বারা সে কোনো ব্যক্তিকে এমন আঘাত করে যে তার মৃত্যু হয়, তাহলে সেই ব্যক্তি হত্যাকারী; সেই হত্যাকারী ব্যক্তিকে মৃত্যুদণ্ড দিতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","রক্তপাতের জন্য প্রতিশোধগ্রহণকারী ব্যক্তি সেই হত্যাকারী ব্যক্তিকে বধ করবে; যখনই সে হত্যাকারীর দেখা পাবে, তাকে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","যদি কেউ আগে থেকে বিদ্বেষবশত কাউকে সজোরে ধাক্কা দেয়, অথবা ইচ্ছাকৃতভাবে কোনো বস্তু কারোর দিকে নিক্ষেপ করে, যার ফলে সে মারা যায়, ");
INSERT INTO benobcv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","অথবা শত্রুতার কারণে সে তাকে এমন মুষ্ট্যাঘাত করে, যার ফলে সেই ব্যক্তি মারা যায়, তাহলে সেই ব্যক্তিকে মৃত্যুদণ্ড দিতে হবে, তাহলে সেই ব্যক্তি হত্যাকারী। রক্তপাতের জন্য প্রতিশোধগ্রহণকারী ব্যক্তি তাকে দেখামাত্র সেই হত্যাকারী ব্যক্তিকে বধ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘কিন্তু শত্রুতার মনোভাব ছাড়াই, যদি কোনো ব্যক্তি হঠাৎ কাউকে ধাক্কা দেয়, অথবা অনিচ্ছাকৃতভাবে কোনো বস্তু তার দিকে নিক্ষেপ করে ");
INSERT INTO benobcv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","অথবা তার প্রতি লক্ষ্য না করে যদি কোনো ভারী পাথর তার ওপর নিক্ষেপ করে যার দ্বারা মৃত্যু হতে পারে এবং সে মারা যায়, তাহলে যেহেতু সে তার শত্রু ছিল না এবং তার ক্ষতিসাধন করার কোনো মনোবাসনা সেই ব্যক্তির ছিল না ");
INSERT INTO benobcv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","মণ্ডলী অবশ্যই সেই ব্যক্তির এবং রক্তপাতের জন্য প্রতিশোধগ্রহণকারী ব্যক্তির মধ্যে এই সমস্ত নিয়ন্ত্রণ বিধির পরিপ্রেক্ষিতে বিচার করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","মণ্ডলী অবশ্যই সেই ব্যক্তিকে রক্তপাতের জন্য প্রতিশোধগ্রহণকারী ব্যক্তির হাত থেকে রক্ষা করবে এবং সেই আশ্রয়-নগরে তাকে আবার পাঠিয়ে দেবে, যেখানে সে পালিয়ে গিয়েছিল। যে পর্যন্ত পবিত্র তেলে অভিষিক্ত মহাযাজকের মৃত্যু না হয়, সেই পর্যন্ত সে ওই স্থানে অবস্থিতি করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘কিন্তু অভিযুক্ত ব্যক্তি, যেখানে সে পলায়ন করেছিল, সেই আশ্রয়-নগরের সীমানার বাইরে যদি কখনও যায় ");
INSERT INTO benobcv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","এবং রক্তপাতের জন্য প্রতিশোধগ্রহণকারী ব্যক্তি সেই নগর সীমানার বাইরে তার দেখা পায়, তাহলে সে অভিযুক্ত ব্যক্তিকে বধ করতে পারবে। নরহত্যার কোনো অপরাধ তার হবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","অভিযুক্ত ব্যক্তি অবশ্যই তার আশ্রয়-নগরে অবস্থান করবে, যতদিন না মহাযাজকের মৃত্যু হয়; কেবলমাত্র মহাযাজকের মৃত্যু হলেই সে তার নিজস্ব অধিকারে ফিরে যেতে পারবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘তোমরা যেখানে বসবাস করো, সেখানেই ভবিষ্যৎ বংশপরম্পরায় এই বিধান প্রযোজ্য হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘কোনও ব্যক্তি, অন্য কোনো ব্যক্তিকে হত্যা করলে, প্রত্যক্ষদর্শীদের সাক্ষ্যদানের ভিত্তিতে, হত্যাকারী হিসেবে তাকে বধ করতে হবে। কিন্তু শুধুমাত্র একজন সাক্ষীর সাক্ষ্যের ভিত্তিতে কাউকে মৃত্যুদণ্ড দেওয়া যাবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘মৃত্যুদণ্ডযোগ্য কোনো হত্যাকারীর জীবনের বিনিময়ে কোনো মুক্তির মূল্য গ্রহণ করবে না। তাকে নিশ্চিতরূপেই বধ করতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘যে ব্যক্তি আশ্রয়-নগরে পলায়ন করেছে, তার কাছ থেকে কোনো মুক্তিপণ নেবে না এবং মহাযাজকের মৃত্যু হওয়ার আগেই তাকে ফিরে যেতে ও নিজস্ব নিবাস ভূমিতে বসবাস করার অনুমতি দেবে না। ");
INSERT INTO benobcv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘যে দেশে তোমরা বসবাস করো, সেই দেশকে কলুষিত করবে না। রক্তপাত দেশকে কলুষিত করে এবং যেখানে রক্তপাত হয় সেখানে রক্তপাতকারীর রক্তপাত বিনা দেশের প্রায়শ্চিত্ত হতে পারে না। ");
INSERT INTO benobcv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","যেখানে তোমরা জীবনযাপন করো ও যেখানে আমি বসবাস করি, সেই দেশকে কলুষিত করবে না। কারণ আমি, সদাপ্রভু, ইস্রায়েলীদের মধ্যে বসবাস করি।’ ” ");
INSERT INTO benobcv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","যোষেফের বংশধরদের গোষ্ঠীসমূহ থেকে মনঃশির নাতি মাখীরের ছেলে গিলিয়দের গোষ্ঠীর প্রধানেরা এসে মোশি ও ইস্রায়েলী পরিবারগুলির প্রধানদের সঙ্গে কথা বললেন। ");
INSERT INTO benobcv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","তাঁরা বললেন, “যখন সদাপ্রভু আমাদের প্রভুকে আদেশ দিয়ে বলেছিলেন গুটিকাপাত দ্বারা স্বত্বাধিকাররূপে ইস্রায়েলীদের দেশ বণ্টন করতে, তিনি আপনাকে আদেশ দিয়েছিলেন যেন আপনি আমাদের ভাই সলফাদের অধিকার তার মেয়েদের দেন। ");
INSERT INTO benobcv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","এখন, মনে করুন, তারা যদি ইস্রায়েলী অন্য গোষ্ঠীভুক্ত কাউকে বিয়ে করে; তাহলে তাদের স্বত্বাধিকার আমাদের পৈতৃক উত্তরাধিকার থেকে নিয়ে নেওয়া হবে এবং যে গোষ্ঠীতে তাদের বিয়ে হবে তারা তাদের অংশে অন্তর্ভুক্ত হবে। তাই আমাদের জন্য বন্টিত অধিকারের অংশ আমাদের থেকে নিয়ে নেওয়া হবে। ");
INSERT INTO benobcv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","যখন ইস্রায়েলীদের জয়ন্তী বছর উপস্থিত হবে, তখন যে গোষ্ঠীতে তাদের বিয়ে হবে, সেই গোষ্ঠীর অধিকারে তাদের অধিকার যুক্ত হবে এবং আমাদের পিতৃবংশের অধিকার থেকে তাদের সম্পত্তি নিয়ে নেওয়া হবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","তখন সদাপ্রভুর আদেশ অনুযায়ী মোশি, ইস্রায়েলীদের এই বিধান দিলেন, “যোষেফের গোষ্ঠীর বংশধরেরা যে কথা বলছে, তা যথার্থ। ");
INSERT INTO benobcv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","সদাপ্রভু, সলফাদের মেয়েদের জন্য এই আদেশ দিয়েছেন, তাদের বাবার গোষ্ঠীর মধ্যে তারা যাকে চায়, তাকেই বিয়ে করতে পারে। ");
INSERT INTO benobcv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","কিন্তু ইস্রায়েলীদের মধ্যে কোনো অধিকার এক গোষ্ঠী থেকে অন্য গোষ্ঠীতে যাবে না, কারণ প্রত্যেক ইস্রায়েলী তার পূর্বপুরুষদের কাছ থেকে পাওয়া গোষ্ঠীর ভূমি রক্ষা করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","প্রত্যেক মেয়ে যে ইস্রায়েলী গোষ্ঠীর মধ্যে অধিকার প্রাপ্ত হবে, সে অবশ্যই তা পিতৃ-গোষ্ঠীর মধ্যে কোনো ব্যক্তিকে বিয়ে করবে। এভাবে প্রত্যেক ইস্রায়েলী ব্যক্তি তার বাবার অধিকার ভোগ করবে। ");
INSERT INTO benobcv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","কোনো উত্তরাধিকার এক গোষ্ঠী থেকে অন্য গোষ্ঠীতে যাবে না, কারণ প্রত্যেক ইস্রায়েলী গোষ্ঠী তার অধিকারভুক্ত ভূমি নিজের কাছে রাখবে।” ");
INSERT INTO benobcv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","অতএব সলফাদের মেয়েরা সেইরকমই করল, যেমন সদাপ্রভু মোশিকে বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","সলফাদের মেয়েরা—মহলা, তির্সা, হগ্‌লা, মিল্কা ও নোয়া—তাদের পিতৃ-গোষ্ঠীর ছেলেদের বিয়ে করল। ");
INSERT INTO benobcv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","তারা যোষেফের ছেলে মনঃশির বংশধরদের গোষ্ঠীর মধ্যে বিয়ে করল এবং তাদের অধিকার তাদের বাবার বংশ ও গোষ্ঠীর মধ্যেই রইল। ");
INSERT INTO benobcv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","এই সমস্ত আদেশ ও নিয়ন্ত্রণবিধি, সদাপ্রভু জর্ডনের সামনে, যিরীহোর অন্য পাশে, মোয়াবের সমতলে, মোশির মাধ্যমে ইস্রায়েলীদের দান করেছিলেন।");
INSERT INTO benobcv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","মোশি জর্ডন নদীর পূর্বদিকের মরুএলাকায় অর্থাৎ অরাবাতে সূফের সামনে, পারণ ও তোফল, লাবন, হৎসেরোৎ ও দীষাহবের মাঝখানে ইস্রায়েলীদের কাছে এসব কথা বলেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(হোরেব থেকে সেয়ীর পাহাড়ের রাস্তা ধরে কাদেশ-বর্ণেয় পর্যন্ত যেতে এগারো দিন লাগে।) ");
INSERT INTO benobcv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","সদাপ্রভু ইস্রায়েলীদের সম্বন্ধে মোশিকে যেসব নির্দেশ দিয়েছিলেন তা তিনি চল্লিশতম বছরের একাদশ মাসের প্রথম দিনে তাদের কাছে প্রকাশ করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ইমোরীয়দের রাজা সীহোনকে এবং ইদ্রিয়ীতে বাশনের রাজা ওগকে হারিয়ে দেবার পর এই ঘটনা ঘটেছিল। সীহোন রাজত্ব করতেন হিষ্‌বোনে এবং ওগ রাজত্ব করতেন অষ্টারোতে। ");
INSERT INTO benobcv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","জর্ডনের পূর্বদিকে মোয়াব দেশে মোশি এই বিধান ব্যাখ্যা করতে লাগলেন, তিনি বললেন: ");
INSERT INTO benobcv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","আমাদের ঈশ্বর সদাপ্রভু হোরেবে আমাদের বলেছিলেন, “তোমরা অনেক দিন পাহাড়ে থেকেছ। ");
INSERT INTO benobcv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","এখন তোমরা ছাউনি তুলে নিয়ে ইমোরীয়দের পাহাড়ি এলাকা এবং তার নিকটবর্তী জায়গার লোকদের কাছে যাও যারা অরাবাতে, উঁচু পাহাড়ি এলাকায়, পশ্চিম প্রদেশের নিচের পাহাড়ি এলাকায়, নেগেভে এবং সমুদ্রের তীরে, মহানদী ইউফ্রেটিস নদী পর্যন্ত কনানীয়দের দেশে ও লেবাননে বসবাস করে। ");
INSERT INTO benobcv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","দেখো, আমি তোমাদের এই দেশ দিয়েছি। তোমাদের পূর্বপুরুষদের কাছে অব্রাহাম, ইস্‌হাক ও যাকোব এবং তাঁদের বংশধরদের কাছে যে দেশ দিতে সদাপ্রভু শপথ করেছিলেন তোমরা সেখানে গিয়ে সেই দেশ অধিকার করো।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","সেই সময় আমি তোমাদের বলেছিলাম, “আমার একার পক্ষে তোমাদের ভার বয়ে নিয়ে যাওয়া সম্ভব নয়। ");
INSERT INTO benobcv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","তোমাদের ঈশ্বর সদাপ্রভু তোমাদের এত বৃদ্ধি করেছেন যে আজকে তোমরা আকাশের তারার মতো অসংখ্য হয়ে উঠেছ। ");
INSERT INTO benobcv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","তোমাদের পূর্বপুরুষদের ঈশ্বর সদাপ্রভু তোমাদের সংখ্যা আরও হাজার গুণ বাড়িয়ে দিন এবং তাঁর প্রতিজ্ঞা অনুসারেই তিনি তোমাদের আশীর্বাদ করুন! ");
INSERT INTO benobcv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","কিন্তু আমি একা কী করে তোমাদের সব সমস্যা ও তোমাদের বোঝা এবং তোমাদের ঝগড়া বহন করব? ");
INSERT INTO benobcv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","তোমরা তোমাদের প্রত্যেকটি গোষ্ঠী থেকে কয়েকজন করে জ্ঞানবান, বুদ্ধিমান ও সম্মানীয় লোক বেছে নাও, আমি তাদের উপর তোমাদের দেখাশোনার ভার দেব।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","তোমরা আমাকে উত্তর দিয়েছিলে, “আপনি যা বলেছেন তাই করা ভালো।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","সেইজন্য আমি তোমাদের গোষ্ঠীর প্রধানদের, জ্ঞানবান ও বুদ্ধিমান লোকদের নিয়ে তোমাদের উপরে নিযুক্ত করেছিলাম—সহস্রপতি, শতপতি, পঞ্চাশৎপতি, দশপতি এবং গোষ্ঠীগত কর্মকর্তাদের। ");
INSERT INTO benobcv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","আর সেই বিচারকদের তখন আমি বলেছিলাম, “তোমরা ঝগড়া-বিবাদের সময়ে দুই পক্ষের কথা শুনে ন্যায়পূর্বক বিচার করবে, সেই ঝগড়া ইস্রায়েলী ভাইদের মধ্যেই হোক কিংবা ইস্রায়েলী এবং ভিন্ন জাতির লোকদের মধ্যেই হোক। ");
INSERT INTO benobcv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","বিচারের ব্যাপারে তোমরা কারও পক্ষ নেবে না এবং বড়ো-ছোটো সবার কথাই শুনবে। কোনো মানুষকে ভয় পাবে না, কেননা বিচার ঈশ্বরের। যদি কোনো বিচার তোমাদের কাছে কঠিন বলে মনে হয় তবে তোমরা তা আমার কাছে নিয়ে আসবে, আমি সেই বিচার করব।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","আর তোমাদের যা করতে হবে তাও আমি তখন তোমাদের বলে দিয়েছিলাম। ");
INSERT INTO benobcv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","এরপর, আমাদের ঈশ্বর সদাপ্রভুর আদেশ অনুসারে, আমরা হোরেব ছেড়ে ইমোরীয়দের পাহাড়ি এলাকার দিকে যাওয়ার পথে তোমরা সেই বড়ো ও ভয়ংকর মরুএলাকা দেখেছিলে, এবং আমরা কাদেশ-বর্ণেয় পৌঁছালাম। ");
INSERT INTO benobcv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","তারপর আমি তোমাদের বলেছিলাম, “তোমরা ইমোরীয়দের পাহাড়ি এলাকায় এসে গিয়েছ, যেটি আমাদের ঈশ্বর সদাপ্রভু আমাদের দিচ্ছেন। ");
INSERT INTO benobcv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","দেখো, তোমাদের ঈশ্বর সদাপ্রভু সেই দেশ তোমাদের দিয়েছেন। উঠে গিয়ে সেটি অধিকার করো যেমন সদাপ্রভু, তোমাদের পূর্বপুরুষদের ঈশ্বর, তোমাদের বলেছিলেন। ভয় পেয়ো না; হতাশ হোয়ো না।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","তখন তোমরা সবাই এসে আমাকে বলেছিলে, “কয়েকজন লোককে আগেই পাঠিয়ে দেওয়া হোক যেন তারা দেশটি দেখে এসে আমাদের বলতে পারে কোন পথে আমাদের সেখানে যেতে হবে এবং কোন কোন নগর আমাদের সামনে পড়বে।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","তোমাদের কথাটি আমার ভালো মনে হয়েছিল; সেইজন্য আমি তোমাদের মধ্যে বারোজনকে মনোনীত করেছিলাম, একজন করে প্রত্যেক গোষ্ঠীর। ");
INSERT INTO benobcv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","তারা যাত্রা করে পাহাড়ি এলাকায় উঠে গেল এবং ইষ্কোল উপত্যকায় গিয়ে ভালো করে সবকিছু দেখে আসল। ");
INSERT INTO benobcv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","তারা সেই দেশের কিছু ফল সঙ্গে করে নিয়ে এসে বলেছিল, “আমাদের ঈশ্বর সদাপ্রভু যে দেশটি আমাদের দিচ্ছেন তা সত্যিই চমৎকার।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","কিন্তু তোমরা সেই দেশে যেতে চাইলে না; তোমরা তোমাদের ঈশ্বর সদাপ্রভুর আদেশের বিরুদ্ধাচরণ করেছিলে। ");
INSERT INTO benobcv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","তোমাদের তাঁবুতে তোমরা দোষারোপ করে বলেছিল, “সদাপ্রভু আমাদের ঘৃণা করেন; সেইজন্য তিনি ইমোরীয়দের হাতে তুলে দিয়ে ধ্বংস করার জন্য আমাদের মিশর থেকে বের করে এনেছেন। ");
INSERT INTO benobcv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","আমরা কোথায় যাব? আমাদের ভাইয়েরা আমাদের মন ভেঙে দিয়েছে। তারা বলেছে, ‘সেখানকার লোকেরা আমাদের থেকে শক্তিশালী এবং লম্বা; নগরগুলি খুব বড়ো ও তাদের প্রাচীর গগনচুম্বী। আমরা সেখানে অনাকীয়দেরও দেখেছি।’ ” ");
INSERT INTO benobcv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","তখন আমি তোমাদের বলেছিলাম, “আতঙ্কগ্রস্ত হোয়ো না; তাদের ভয় পেয়ো না। ");
INSERT INTO benobcv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","তোমাদের ঈশ্বর সদাপ্রভু, যিনি তোমাদের আগে যাচ্ছেন, তিনি তোমাদের হয়ে যুদ্ধ করবেন, যেমন তিনি তোমাদের হয়ে মিশরে করেছিলেন, তোমাদের চোখের সামনে, ");
INSERT INTO benobcv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","মরুএলাকায়। সেখানে তোমরা দেখেছিলে তোমাদের ঈশ্বর সদাপ্রভু কেমন করে তোমাদের বহন করেছিলেন, যেমন করে একজন বাবা তার ছেলেকে বহন করে, তেমনি করে তিনি নিয়ে এসেছেন যতক্ষণ না তোমরা এই জায়গায় পৌঁছেছ।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","তবুও তোমরা তোমাদের ঈশ্বর সদাপ্রভুকে বিশ্বাস করোনি, ");
INSERT INTO benobcv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","যিনি যাত্রাপথে রাতে আগুনের মধ্যে ও দিনে মেঘের মধ্যে তোমাদের আগে আগে গিয়েছিলেন, তোমাদের তাঁবু ফেলার জায়গার খোঁজে এবং পথ দেখাবার জন্য যেখান দিয়ে তোমাদের যেতে হবে। ");
INSERT INTO benobcv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","তোমরা যা বলেছ তা সদাপ্রভু যখন শুনলেন, তিনি ভীষণ অসন্তুষ্ট হলেন এবং এই শপথ করলেন ");
INSERT INTO benobcv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“এই দুষ্ট বংশের কোনো লোক সেই চমৎকার দেশ দেখতে পাবে না যা আমি তাদের পূর্বপুরুষদের কাছে প্রতিজ্ঞা করেছিলাম, ");
INSERT INTO benobcv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","কেবল যিফূন্নির ছেলে কালেব ছাড়া। সে তা দেখবে, এবং আমি তাকে ও তার বংশধরদের সেই জায়গা দেব যেখানে সে পা রেখেছিল, কেননা সে পুরোপুরিভাবে সদাপ্রভুর কথা অনুসারে চলেছে।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","তোমাদের দরুন সদাপ্রভু আমার উপরেও ভীষণ অসন্তুষ্ট হয়ে বলেছিলেন, “তোমারও, ওই দেশে ঢোকা হবে না। ");
INSERT INTO benobcv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","কিন্তু তোমার সাহায্যকারী নূনের ছেলে যিহোশূয় ঢুকবে। তাকে উৎসাহ দাও, কারণ সেই ইস্রায়েলকে দেশটি অধিকার করতে নেতৃত্ব দেবে। ");
INSERT INTO benobcv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","যেসব ছেলেমেয়েকে বন্দি করে নিয়ে যাওয়া হবে বলে তোমরা বলেছিলে তোমাদের সেইসব ছেলেমেয়ে, যাদের ভালোমন্দের জ্ঞান হয়নি তারাই সেই দেশে ঢুকবে। আমি দেশটি তাদেরই দেব এবং তারা তা অধিকার করবে। ");
INSERT INTO benobcv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","কিন্তু তোমরা ফেরো এবং সূফসাগরের পথ দিয়ে মরুএলাকার দিকে যাও।” ");
INSERT INTO benobcv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","তখন তোমরা উত্তর দিয়েছিলে, “আমরা সদাপ্রভুর বিরুদ্ধে পাপ করেছি। আমরা উঠে যাব এবং যুদ্ধ করব, আমাদের ঈশ্বর সদাপ্রভু আমাদের যেমন আদেশ করেছেন।” অতএব তোমরা সবাই অস্ত্রশস্ত্র নিয়েছিলে, ভেবেছিলে পাহাড়ি এলাকায় উঠে যাওয়া খুব সহজ। ");
INSERT INTO benobcv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","কিন্তু সদাপ্রভু আমাকে বললেন, “তাদের বলো, ‘উপরে উঠে যুদ্ধ কোরো না, কেননা আমি তোমাদের সঙ্গে থাকব না। তোমরা শত্রুদের দ্বারা পরাজিত হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","আমি তোমাদের সেই কথা জানালাম, কিন্তু তোমরা শুনলে না। তোমরা সদাপ্রভুর আদেশের বিরুদ্ধে বিদ্রোহ করলে এবং অহংকারের সঙ্গে পর্বতে অবস্থিত নগরে উঠে গেলে। ");
INSERT INTO benobcv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","সেই পাহাড়ি এলাকায় বসবাসকারী ইমোরীয়েরা তোমাদের বিরুদ্ধে বের হয়ে এসে এক ঝাঁক মৌমাছির মতো তোমাদের তাড়া করে সেয়ীর থেকে হর্মা পর্যন্ত মারতে মারতে নিয়ে গিয়েছিল। ");
INSERT INTO benobcv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","তোমরা ফিরে এসে সদাপ্রভুর কাছে কেঁদেছিলে, কিন্তু তিনি তোমাদের কান্নায় কোনও মনোযোগ দিলেন না এবং তিনি কান বন্ধ করেছিলেন। ");
INSERT INTO benobcv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","আর তোমরা অনেক দিন কাদেশে থাকলে—সেখানেই তোমাদের সময় কাটল। ");
INSERT INTO benobcv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","পরে সদাপ্রভু যেমন নির্দেশ দিয়েছিলেন সেইভাবে আমরা পিছন ফিরে সূফসাগরের পথ ধরে মরুএলাকার দিকে রওনা হয়েছিলাম। সেয়ীরের পাহাড়ি এলাকা ঘুরে যেতে আমাদের অনেক দিন কেটে গেল। ");
INSERT INTO benobcv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","তারপর সদাপ্রভু আমাকে বললেন, ");
INSERT INTO benobcv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“তোমরা পাহাড়ি এলাকায় অনেক দিন ধরে ঘুরছ; এখন উত্তর দিকে ফের। ");
INSERT INTO benobcv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","লোকদের এই আদেশ করো: ‘সেয়ীরে বসবাসকারী এষৌর বংশধর তোমাদের আত্মীয়দের রাজ্যের মধ্যে দিয়ে এখন তোমাদের যেতে হবে। তোমাদের দেখে তারা ভয় পাবে কিন্তু তোমরা খুব সাবধানে থেকো। ");
INSERT INTO benobcv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","তাদের যুদ্ধের উসকানি দেবে না, কারণ তাদের দেশের কোনও অংশই আমি তোমাদের দেব না, এমনকি পা রাখার জায়গা পর্যন্ত দেব না। আমি সেয়ীরের এই পাহাড়ি এলাকা এষৌকে তার নিজের দেশ হিসেবে দিয়েছি। ");
INSERT INTO benobcv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","তাদের কাছ থেকে খাবার ও জল তোমাদের রুপো দিয়ে কিনে খেতে হবে।’ ” ");
INSERT INTO benobcv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","তোমাদের ঈশ্বর সদাপ্রভু সবকাজেই তোমাদের আশীর্বাদ করেছেন। এই বিশাল মরুএলাকার মধ্যে দিয়ে যাওয়ার সময় তিনি তোমাদের দেখাশোনা করেছেন। এই চল্লিশ বছর তোমাদের ঈশ্বর সদাপ্রভু তোমাদের সঙ্গেই থেকেছেন, এবং তোমাদের কোনও অভাব হয়নি। ");
INSERT INTO benobcv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","অতএব আমরা সেয়ীরে বসবাসকারী এষৌর বংশধর আমাদের আত্মীয়দের রাজ্যের মধ্যে দিয়ে গেলাম। আমরা অরাবার যে পথটি এলৎ ও ইৎসিয়োন-গেবর থেকে বের হয়ে এসেছে সেই পথ ছেড়ে মোয়াবের মরুএলাকার পথে গেলাম। ");
INSERT INTO benobcv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","তারপর সদাপ্রভু আমাকে বললেন, “মোয়াবীয়দের তোমরা বিরক্ত কোরো না কিংবা তাদের যুদ্ধের উসকানি দিয়ো না, কারণ তাদের দেশের কোনও অংশই আমি তোমাদের দেব না। আমি সম্পত্তি হিসেবে আর্ অঞ্চলটি লোটের বংশধরদের দিয়েছি।” ");
INSERT INTO benobcv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(এমীয়েরা—আগে সেখানে থাকত তারা শক্তিশালী ও অসংখ্য ছিল, এবং অনাকীয়দের মতো লম্বা। ");
INSERT INTO benobcv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","অনাকীয়দের মতো এমীয়দেরও রফায়ীয় বলা হত, কিন্তু মোয়াবীয়রা তাদের বলত এমীয়। ");
INSERT INTO benobcv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","হোরীয়েরাও সেয়ীরে বসবাস করত, কিন্তু এষৌর বংশধরেরা তাদের সেখান থেকে তাড়িয়ে দিয়েছিল। তারা হোরীয়দের তাদের সামনেই ধ্বংস করে, তাদের অধিকারে থাকা জায়গায় বসবাস করতে লাগল, যেমন ইস্রায়েলীরা সদাপ্রভুর দেওয়া জায়গায় করেছিল।) ");
INSERT INTO benobcv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","আর সদাপ্রভু বললেন, “এখন তোমরা উঠে সেরদ উপত্যকা পার হয়ে যাও।” সুতরাং আমরা উপত্যকা পার হলাম। ");
INSERT INTO benobcv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","কাদেশ-বর্ণেয় ছেড়ে সেরদ উপত্যকা পার হয়ে আসতে আমাদের আটত্রিশ বছর কেটে গিয়েছিল। তার মধ্যে, তাঁবুতে যেসব সৈন্য ছিল তারা 