﻿USE sofia;
DROP TABLE IF EXISTS sofia.benirv_vpl;
CREATE TABLE benirv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES benirv_vpl WRITE;
INSERT INTO benirv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","আদিতে ঈশ্বর আকাশমণ্ডল ও পৃথিবীর সৃষ্টি করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","পৃথিবী বিন্যাস বিহীন ও শূন্য ছিল এবং অন্ধকার জলরাশির উপরে ছিল, আর ঈশ্বরের আত্মা জলের উপরে চলাচল করছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","পরে ঈশ্বর বললেন, আলো হোক; তাতে আলো হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","তখন ঈশ্বর আলো উত্তম দেখলেন এবং ঈশ্বর আলো ও অন্ধকার আলাদা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","আর ঈশ্বর আলোর নাম “দিন” ও অন্ধকারের নাম “রাত” রাখলেন। সন্ধ্যা ও সকাল হলে প্রথম দিন হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","পরে ঈশ্বর বললেন, “জলের মধ্যে আকাশ (বায়ুমণ্ডল) হোক ও জলকে দুই ভাগে আলাদা করুক।” ");
INSERT INTO benirv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ঈশ্বর এই ভাবে বায়ুমণ্ডল করে আকাশের উপরের জল থেকে নীচের জল পৃথক করলেন; তাতে সেরকম হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","পরে ঈশ্বর আকাশের নাম আকাশমণ্ডল রাখলেন। আর সন্ধ্যা ও সকাল হলে দ্বিতীয় দিন হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","পরে ঈশ্বর বললেন, “আকাশমণ্ডলের নীচে অবস্থিত সমস্ত জল এক জায়গায় জমা হোক ও স্থল প্রকাশিত হোক,” তাতে সেরকম হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","তখন ঈশ্বর শুকনো জায়গার নাম ভূমি ও জলরাশির নাম সমুদ্র রাখলেন; আর ঈশ্বর দেখলেন যে, তা উত্তম। ");
INSERT INTO benirv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","পরে ঈশ্বর বললেন, “ভূমি ঘাস, বীজ উত্পন্নকারী ওষধি ও সবীজ গাছপালা তাদের জাতি অনুযায়ী ফলের উৎপাদক ফলের গাছ, ভূমির উপরে উৎপন্ন করুক,” তাতে সেরকম হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ফলে ভূমি ঘাস, তাদের জাতি অনুযায়ী বীজ উত্পন্নকারী ওষধি, ও তাদের জাতি অনুযায়ী সবীজ ফলের উৎপাদক গাছ, উৎপন্ন করল; আর ঈশ্বর দেখলেন যে, সে সকল ভালো। ");
INSERT INTO benirv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","আর সন্ধ্যা ও সকাল হলে তৃতীয় দিন হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","পরে ঈশ্বর বললেন, “রাত থেকে দিন কে আলাদা করার জন্য আকাশমণ্ডলের বিতানে নক্ষত্র হোক এবং তারা চিহ্নের মতো হোক, ঋতুর জন্য, রাত এবং সময়ের ও বছরের জন্য হোক; ");
INSERT INTO benirv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","এবং পৃথিবীতে আলো দেবার জন্য দীপ বলে আকাশ (বায়ুমণ্ডল) থাকুক,” তাতে সেরকম হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ঈশ্বর সময়ের উপরে কর্তৃত্ব করতে এক মহাজ্যোতি ও রাতের উপরে কর্তৃত্ব করতে তার থেকেও ছোট এক জ্যোতি, এই দুটি বড় জ্যোতি এবং সমস্ত নক্ষত্র সৃষ্টি করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ঈশ্বর পৃথিবীতে আলো দেবার জন্য তাদেরকে আকাশে স্থাপন করলেন এবং ");
INSERT INTO benirv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","দিন ও রাতের উপরে কর্তৃত্ব করার জন্য এবং আলো থেকে অন্ধকার আলাদা করার জন্য ঈশ্বর ঐ জ্যোতিগুলিকে আকাশে স্থাপন করলেন এবং ঈশ্বর দেখলেন যে, সে সব উত্তম। ");
INSERT INTO benirv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","আর সন্ধ্যা ও সকাল হলে চতুর্থ দিন হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","পরে ঈশ্বর বললেন, “জল নানাজাতীয় জলজ প্রাণীতে প্রাণীময় হোক এবং ভূমির উপরে আকাশে পাখিরা উড়ুক।” ");
INSERT INTO benirv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","তখন ঈশ্বর বৃহৎ জলজ প্রাণীদের ও যে নানাজাতীয় জলজ প্রাণীতে জল প্রাণীময় আছে, সে সবের এবং নানাজাতীয় পাখি সৃষ্টি করলেন। পরে ঈশ্বর দেখলেন যে সে সব উত্তম। ");
INSERT INTO benirv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","আর ঈশ্বর সে সকলকে আশীর্বাদ করে বললেন, “তোমরা ফলবান ও বহুবংশ হও, সমুদ্রের জল পরিপূর্ণ কর এবং পৃথিবীতে পাখিদের বৃদ্ধি হোক।” ");
INSERT INTO benirv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","আর সন্ধ্যা ও সকাল হলে পঞ্চম দিন হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","পরে ঈশ্বর বললেন, “ভূমি নানাজাতীয় প্রাণীতে, অর্থাৎ তাদের জাতি অনুযায়ী পশুপাল, সরীসৃপ ও বন্য পশু সৃষ্টি করুক; তাতে সেরকম হল।” ");
INSERT INTO benirv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ফলে ঈশ্বর নিজের নিজের জাতি অনুযায়ী বন্য পশু ও নিজের নিজের জাতি অনুযায়ী পশুপাল ও নিজের নিজের জাতি অনুযায়ী যাবতীয় ভূচর সরীসৃপ সৃষ্টি করলেন; আর ঈশ্বর দেখলেন যে, সে সব উত্তম। ");
INSERT INTO benirv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","পরে ঈশ্বর বললেন, “আমরা আমাদের প্রতিমূর্ত্তিতে, আমাদের সঙ্গে মিল রেখে মানুষ সৃষ্টি করি; আর তারা সমুদ্রের মাছদের ওপরে, আকাশের পাখিদের ওপরে, পশুদের ওপরে, সমস্ত পৃথিবীর ওপরে ও ভূমিতে চলাচলকারী যাবতীয় সরীসৃপের ওপরে কর্তৃত্ব করুক।” ");
INSERT INTO benirv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","পরে ঈশ্বর নিজের প্রতিমূর্ত্তিতে মানুষকে সৃষ্টি করলেন; ঈশ্বরের প্রতিমূর্তিতেই তাকে সৃষ্টি করলেন, পুরুষ ও স্ত্রী করে তাদেরকে সৃষ্টি করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","পরে ঈশ্বর তাদেরকে আশীর্বাদ করলেন; ঈশ্বর বললেন, “তোমরা ফলবান ও বহুবংশ হও এবং পৃথিবী পরিপূর্ণ ও কর্তৃত্ব কর, আর সমুদ্রের মাছদের ওপরে, আকাশের পাখিদের ওপরে এবং ভূমিতে গমনশীল যাবতীয় জীবজন্তুর ওপরে কর্তৃত্ব কর।” ");
INSERT INTO benirv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ঈশ্বর আরও বললেন, “দেখ, আমি সমস্ত পৃথিবীতে অবস্থিত যাবতীয় বীজৎপাদক ওষধি ও যাবতীয় সবীজ ফলদায়ী বৃক্ষ তোমাদেরকে দিলাম, তা তোমাদের খাদ্য হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","আর ভূমিতে চরাচর যাবতীয় পশু ও আকাশের যাবতীয় পাখি ও ভূমিতে বুকে হেঁটে চলা যাবতীয় কীট, এই সব প্রাণীর আহারের জন্য সবুজ গাছপালা সকল দিলাম। তাতে সেরকম হল। ");
INSERT INTO benirv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","পরে ঈশ্বর নিজের তৈরী সব জিনিসের প্রতি দেখলেন, আর দেখলেন, সে সবই খুবই ভালো। আর সন্ধ্যা ও সকাল হলে ষষ্ঠ দিন হল। ");
INSERT INTO benirv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","এই ভাবে আকাশমণ্ডল ও পৃথিবী এবং তাদের মধ্যে অবস্থিত স ব জিনিস তৈরী করা শেষ হল। ");
INSERT INTO benirv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","পরে সপ্তম দিনের ঈশ্বর তাঁর কাজকে শেষ করলেন, সেই সপ্তম দিনের নিজের করা সমস্ত কাজ থেকে বিশ্রাম নিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","আর ঈশ্বর সেই সপ্তম দিন কে আশীর্বাদ করে পবিত্র করলেন, কারণ সেই দিনের ঈশ্বর নিজের সৃষ্টি ও তৈরী করা সমস্ত কাজ থেকে বিশ্রাম নিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","সৃষ্টিকালে যে দিন সদাপ্রভু ঈশ্বর পৃথিবী ও আকাশমণ্ডল সৃষ্টি করলেন, তখনকার আকাশমণ্ডল ও পৃথিবীর সৃষ্টির বৃত্তান্ত এই। ");
INSERT INTO benirv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","সেই দিনের পৃথিবীর ভূমিতে কোন ফসল উত্পন্ন হত না, আর ভূমিতে কোন ওষধি উৎপন্ন হত না, কারণ সদাপ্রভু ঈশ্বর পৃথিবীতে বৃষ্টি বর্ষণ করেননি, আর ভূমিতে কৃষিকাজ করতে মানুষ ছিল না। ");
INSERT INTO benirv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","আর পৃথিবী থেকে কুয়াশা ঝর্ণা উঠে গিয়ে সমস্ত পৃথিবীকে জলসিক্ত করল। ");
INSERT INTO benirv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","আর সদাপ্রভু ঈশ্বর মৃত্তিকার ধূলোতে আদমকে অর্থাৎ মানুষকে তৈরী করলেন এবং তার নাকে ফুঁ দিয়ে প্রাণবায়ু প্রবেশ করালেন; তাতে মানুষ সজীব প্রাণী হল। ");
INSERT INTO benirv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","আর সদাপ্রভু ঈশ্বর পূর্বদিকে, এদনে, এক বাগান তৈরী করলেন এবং সেই জায়গায় নিজের জন্য ঐ মানুষকে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","আর সদাপ্রভু ঈশ্বর ভূমি থেকে সর্বজাতীয় সুদৃশ্য ও সুখাদ্য-দায়ক গাছ এবং সেই বাগানের মাঝখানে জীবনগাছ ও সদসদ-জ্ঞানদায়ক গাছ সৃষ্টি করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","আর বাগানে জল সেচনের জন্য এদন থেকে এক নদী বের হল, ওটা সেখান থেকে চারটি মুখে ভাগ হল। ");
INSERT INTO benirv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","প্রথম নদীর নাম পিশোন; এটা সমস্ত হবীলা দেশের চারপাশ থেকে বয়ে যায়, ");
INSERT INTO benirv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","সেখানে সোনা পাওয়া যায়, আর সেই দেশের সোনা উত্তম এবং সেই জায়গায় মোতী ও গোমেদকমনি জন্মে। ");
INSERT INTO benirv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","দ্বিতীয় নদীর নাম গীহোন; এটা সমস্ত ইথিওপিয়া দেশ বেষ্টন করে। ");
INSERT INTO benirv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","তৃতীয় নদীর নাম হিদ্দেকল, এটা অশূর দেশের সামনে দিয়ে বয়ে গেছে। চতুর্থ নদী ফরাৎ। ");
INSERT INTO benirv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","পরে সদাপ্রভু ঈশ্বর আদমকে নিয়ে এদনের বাগানে কৃষিকাজ ও দেখাশোনার জন্য সেখানে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","আর সদাপ্রভু ঈশ্বর আদমকে এই আদেশ দিলেন, “তুমি এই বাগানের সব গাছের ফল নিজের ইচ্ছায় খাও; ");
INSERT INTO benirv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","কিন্তু সদসদ-জ্ঞানদায়ক যে গাছ, তার ফল খেও না, কারণ যে দিন তার ফল খাবে, সেই দিন মরবেই মরবে।” ");
INSERT INTO benirv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","আর সদাপ্রভু ঈশ্বর বললেন, “মানুষের একা থাকা ভাল নয়, আমি তার জন্য তার মতো সহকারিণী তৈরী করি।” ");
INSERT INTO benirv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","আর সদাপ্রভু ঈশ্বর মাটি থেকে সকল বন্য পশু ও আকাশের সব পাখি তৈরী করলেন; পরে আদম তাদের কি কি নাম রাখবেন, তা জানতে সেই সবাইকে তাঁর কাছে আনলেন, তাতে আদম যে সজীব প্রাণীর যে নাম রাখলেন, তার সেই নাম হল। ");
INSERT INTO benirv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","আদম যাবতীয় পশুপাল, পাখির ও যাবতীয় বন্য পশুর নাম রাখলেন, কিন্তু মানুষের জন্য তাঁর মতো সহকারিণী পাওয়া গেল না। ");
INSERT INTO benirv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","পরে সদাপ্রভু ঈশ্বর আদমকে গভীর ঘুমে মগ্ন করলে তিনি ঘুমিয়ে পড়লেন; আর তিনি তাঁর একখানা পাঁজর নিয়ে মাংস দিয়ে সেই স্থান পূরণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","সদাপ্রভু ঈশ্বর আদম থেকে পাওয়া সেই পাঁজরে এক স্ত্রী সৃষ্টি করলেন ও তাঁকে আদমের কাছে আনলেন। ");
INSERT INTO benirv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","তখন আদম বললেন, “এবার হয়েছে; ইনি আমার অস্থির অস্থি ও মাংসের মাংস; এর নাম নারী হবে, কারণ ইনি মানুষ থেকে গৃহীত হয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","এই কারণ মানুষ নিজের বাবা মাকে ত্যাগ করে নিজের স্ত্রীতে আসক্ত হবে এবং তারা একাঙ্গ হবে। ");
INSERT INTO benirv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ঐ দিনের আদম ও তাঁর স্ত্রী উভয়ে উলঙ্গ থাকতেন, আর তাঁদের লজ্জা বোধ ছিল না। ");
INSERT INTO benirv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","সদাপ্রভু ঈশ্বরের সৃষ্টি ভূচর প্রাণীদের মধ্যে সাপ সবচেয়ে ধূর্ত ছিল। সে ঐ নারীকে বলল, “ঈশ্বর কি বাস্তবিক বলেছেন, তোমরা এই বাগানের কোনো গাছের ফল খেও না?” ");
INSERT INTO benirv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","নারী সাপকে বললেন, “আমরা এই বাগানের সব গাছের ফল খেতে পারি; ");
INSERT INTO benirv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","কেবল বাগানের মাঝখানে যে গাছ আছে, সেই ফলের বিষয় ঈশ্বর বলেছেন, তোমরা তা খেও না, ছুঁয়েও দেখ না, তা করলে মরবে।” ");
INSERT INTO benirv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","তখন সাপ নারীকে বলল, “কোনোভাবেই মরবে না; ");
INSERT INTO benirv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","কারণ ঈশ্বর জানেন, যে দিন তোমরা তা খাবে, সেই দিন তোমাদের চোখ খুলে যাবে। তাতে তোমরা ঈশ্বরের মতো হয়ে সদসদ-জ্ঞান লাভ করবে।” ");
INSERT INTO benirv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","নারী যখন দেখলেন, ঐ গাছ সুখাদ্যদায়ক ও চোখের লোভজনক, আর ঐ গাছ জ্ঞানদায়ক বলে বাঞ্ছনীয়, তখন তিনি তার ফল পেড়ে খেলেন; পরে নিজের স্বামীকেও দিলেন, আর তিনিও খেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","তাতে তাঁদের উভয়ের চোখ খুলে গেল এবং তাঁরা বুঝতে পারলেন যে তাঁরা উলঙ্গ; আর ডুমুর গাছের পাতা জুড়ে ঘাগরা তৈরী করে নিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","পরে তাঁরা সদাপ্রভু ঈশ্বরের রব শুনতে পেলেন, তিনি দিনের রবেলায় বাগানে চলাফেরা করছিলেন; তাতে আদম ও তাঁর স্ত্রী সদাপ্রভু ঈশ্বরের সামনে থেকে বাগানের গাছ সকলের মধ্যে লুকালেন। ");
INSERT INTO benirv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","তখন সদাপ্রভু ঈশ্বর আদমকে ডেকে বললেন, “তুমি কোথায়?” ");
INSERT INTO benirv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","তিনি বললেন, “আমি বাগানে তোমার কথা শুনে ভয় পেলাম, কারণ আমি উলঙ্গ, তাই নিজেকে লুকিয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","তিনি বললেন, “তুমি যে উলঙ্গ, এটা তোমাকে কে বলল?” যে গাছের ফল খেতে তোমাকে বারণ করেছিলাম, তুমি কি তার ফল খেয়েছ? ");
INSERT INTO benirv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","তাতে আদম বললেন, “তুমি আমার সঙ্গিনী করে যে স্ত্রীকে দিয়েছ, সে আমাকে ঐ গাছের ফল দিয়েছিল, তাই খেয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","তখন সদাপ্রভু ঈশ্বর নারীকে বললেন, “তুমি এ কি করলে?” নারী বললেন, “সাপ আমাকে ভুলিয়েছিল, তাই খেয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","পরে সদাপ্রভু ঈশ্বর সাপকে বললেন, “তুমি এই কাজ করেছ, এই জন্য পশুপাল ও বন্য পশুদের মধ্যে তুমি সবচেয়ে বেশি শাপগ্রস্ত; তুমি বুকে হাঁটবে এবং যাবজ্জীবন ধূলো খাবে। ");
INSERT INTO benirv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","আর আমি তোমাতে ও নারীতে এবং তোমার বংশে ও তার বংশে পরস্পর শত্রুতা জন্মাব; সে তোমার মাথা ভেঙে দেবে এবং তুমি তার পাদমূল দংশন করবে।” ");
INSERT INTO benirv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","পরে তিনি নারীকে বললেন, “আমি তোমার গর্ভ বেদনা খুবই বাড়িয়ে দেব, তুমি কষ্টে সন্তান প্রসব করবে এবং স্বামীর প্রতি তোমার বাসনা থাকবে ও সে তোমার উপরে কর্তৃত্ব করবে।” ");
INSERT INTO benirv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","আর তিনি আদমকে বললেন, “যে বৃক্ষের ফলের বিষয়ে আমি তোমাকে বলেছিলাম, তুমি তা খেওনা, তুমি তোমার স্ত্রীর কথা শুনে তার ফল খেয়েছ, এই জন্য তোমার জন্য ভূমি অভিশপ্ত হল; তুমি সারাজীবন কষ্টে তা ভোগ করবে; ");
INSERT INTO benirv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","আর মাটিতে তোমার জন্য কাঁটা ও শেয়াল কাঁটা জন্মাবে এবং তুমি জমির ওষধি খাবে। ");
INSERT INTO benirv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","তুমি ঘাম ঝরা মুখে খাবার খাবে, যে পর্যন্ত তুমি মাটিতে ফিরে না যাবে; তুমি তো তা থেকেই এসেছ; কারণ তোমাকে ধূলো থেকে নেওয়া হয়েছে এবং ধূলোতে মিশে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","পরে আদম নিজের স্ত্রীর নাম হ বা জীবিত রাখলেন, কারণ তিনি জীবিত সকলের মা হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","আর সদাপ্রভু ঈশ্বর আদম ও তাঁর স্ত্রীর জন্য চামড়ার বস্ত্র তৈরী করে তাঁদেরকে পরালেন। ");
INSERT INTO benirv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","আর সদাপ্রভু ঈশ্বর বললেন, “দেখ, মানুষ সদসদ-জ্ঞান প্রাপ্ত হবার বিষয়ে আমাদের এক জনের মত হল, এখন যদি সে হাত বাড়িয়ে জীবনবৃক্ষের ফলও পেড়ে খায় ও অনন্তজীবী হয়।” ");
INSERT INTO benirv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","এই জন্য সদাপ্রভু ঈশ্বর তাঁকে এদনের বাগান থেকে বের করে দিলেন, যেন, তিনি যা থেকে সৃষ্টি, সেই মাটিতে কৃষিকাজ করেন। ");
INSERT INTO benirv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","এই ভাবে ঈশ্বর মানুষকে তাড়িয়ে দিলেন এবং জীবনবৃক্ষের পথ রক্ষা করবার জন্য এদন বাগানের পূর্বদিকে করূবদেরকে ও ঘূর্ণায়মান তেজোময় তলোয়ার রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","পরে আদম নিজের স্ত্রী হবার সঙ্গে শারীরিক সম্পর্ক করলে তিনি গর্ভবতী হয়ে কয়িনকে প্রসব করে বললেন, “সদাপ্রভুর সাহায্যতে আমি একটা মানুষকে জন্ম দিতে পেরেছি।” ");
INSERT INTO benirv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","পরে তিনি হেবল নামে তার ভাইকে প্রসব করলেন। হেবল মেষপালক ছিল, ও কয়িন চাষী ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","পরে নির্ধারিত দিনের কয়িন উপহাররূপে সদাপ্রভুর উদ্দেশ্যে ভূমির ফল উৎসর্গ করল। ");
INSERT INTO benirv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","আর হেবলও নিজের পালের প্রথমজাত কয়েকটি পশু ও তাদের মেদ উৎসর্গ করল। তখন সদাপ্রভু হেবলকে ও তার উপহার গ্রহণ করলেন; ");
INSERT INTO benirv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","কিন্তু কয়িনকে ও তার উপহার গ্রহণ করলেন না; এই জন্য কয়িন খুবই রেগে গেল, তার মুখ বিষণ্ণ হল। ");
INSERT INTO benirv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","তাতে সদাপ্রভু কয়িনকে বললেন, “তুমি কেন রাগ করেছ? তোমার মুখ কেন বিষণ্ণ হয়েছে? ");
INSERT INTO benirv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","যদি ভালো আচরণ কর, তবে কি গ্রহণ করা হবে না? আর যদি ভালো আচরণ না কর, তবে পাপ দরজায় গুঁড়ি মেরে বসে আছে। তোমার প্রতি তার বাসনা থাকবে কিন্তু তোমার তার উপরে কর্তৃত্ব করা উচিত।” ");
INSERT INTO benirv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","আর কয়িন নিজের ভাই হেবলের সঙ্গে কথোপকথন করল; পরে তারা ক্ষেতে গেলে কয়িন নিজের ভাই হেবলের বিরুদ্ধে উঠে তাকে মেরে ফেলল। ");
INSERT INTO benirv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","পরে সদাপ্রভু কয়িনকে বললেন, তোমার ভাই হেবল কোথায়? সে উত্তর করল, “আমি জানি না, আমি কি আমার ভাইয়ের রক্ষক?” ");
INSERT INTO benirv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","তিনি বললেন, “তুমি কি করেছ? তোমার ভাইয়ের রক্ত ভূমি থেকে আমার কাছে প্রতিফলের জন্য কাঁদছে। ");
INSERT INTO benirv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","আর এখন, যে ভূমি তোমার হাত থেকে তোমার ভাইয়ের রক্ত গ্রহণ করার জন্য নিজের মুখ খুলেছে, সেই ভূমিতে তুমি শাপগ্রস্ত হলে। ");
INSERT INTO benirv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","যখন তুমি ভূমিতে কৃষিকাজ করবে তা নিজের শক্তি দিয়ে তোমার সেবা আর করবে না; তুমি পৃথিবীতে পলাতক ও ভ্রমণকারী হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","তাতে কয়িন সদাপ্রভুকে বলল, “আমার অপরাধের ভার অসহ্য। ");
INSERT INTO benirv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","দেখ, আজ তুমি পৃথিবী থেকে আমাকে তাড়িয়ে দিলে, আর তোমার সামনে থেকে আমি লুকিয়ে থাকব। আমি পৃথিবীতে পলাতক ও ভ্রমণকারী হব, আর আমাকে যে পাবে, সে হত্যা করবে।” ");
INSERT INTO benirv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","তাতে সদাপ্রভু তাকে বললেন, “এই জন্য কয়িনকে যে মারবে, সে সাত গুন প্রতিফল পাবে।” আর সদাপ্রভু কয়িনের জন্য এক চিহ্ন রাখলেন, যদি কেউ তাকে পেলে আক্রমণ করে। ");
INSERT INTO benirv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","পরে কয়িন সদাপ্রভুর সামনে থেকে চলে গিয়ে এদনের পূর্ব দিকে নোদ দেশে বাস করল। ");
INSERT INTO benirv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","আর কয়িন নিজের স্ত্রীর সঙ্গে শারীরিক সম্পর্ক করলে সে গর্ভবতী হয়ে হনোককে প্রসব করল। আর কয়িন এক নগর তৈরী করে নিজের ছেলের নামানুসারে তার নাম হনোক রাখল। ");
INSERT INTO benirv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","হনোকের ছেলে ঈরদ, ঈরদের ছেলে মহুয়ায়েল, মহুয়ায়েলের ছেলে মথূশায়েল ও ");
INSERT INTO benirv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","মথূশায়েলের ছেলে লেমক। লেমক দুই স্ত্রী গ্রহণ করল, একজন স্ত্রীর নাম আদা, অন্যের নাম সিল্লা। ");
INSERT INTO benirv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","আদার গর্ভে যাবল জন্মাল, সে তাঁবুনিবাসী পশুপালকদের আদিপুরুষ ছিল। তার ভাইয়ের নাম যুবল; ");
INSERT INTO benirv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","সে বীণা ও বংশীধারী সকলের আদিপুরুষ ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","আর সিল্লার গর্ভে তুবল-কয়িন জন্মাল, সে পিতলের ও লোহার নানা প্রকার অস্ত্র তৈরী করত। তুবল-কয়িনের বোনের নাম নয়মা। ");
INSERT INTO benirv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","আর লেমক নিজের দুই স্ত্রীকে বলল, “আদা, সিল্লা, তোমরা আমার কথা শোন, লেমকের স্ত্রীরা আমার কথা শোন; কারণ আমি আঘাতের পরিশোধে পুরুষকে, প্রহারের পরিশোধে যুবাকে মেরে ফেলেছি। ");
INSERT INTO benirv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","যদি কয়িনের হত্যার প্রতিফল সাত গুন হয়, তবে লেমকের হত্যার প্রতিফল সাতাত্তর গুন হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","আর আদম আবার নিজের স্ত্রীর পরিচয় নিলে তিনি ছেলে প্রসব করলেন ও তার নাম শেথ রাখলেন। কারণ তিনি বললেন কয়িনের মাধ্যমে হত হেবলের পরিবর্তে ঈশ্বর আমাকে আর এক ছেলে দিলেন। পরে ");
INSERT INTO benirv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","শেথেরও ছেলে হল, আর তিনি তার নাম ইনোশ রাখলেন। তখন লোকেরা সদাপ্রভুর নামে আরাধনা করতে আরম্ভ করল। ");
INSERT INTO benirv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","আদমের বংশাবলী (1 বংশাবলী 1-4) পত্র এই। যে দিন ঈশ্বর মানুষের সৃষ্টি করলেন, সেই দিনের ঈশ্বরের সাদৃশ্যেই তাঁকে তৈরী করলেন, ");
INSERT INTO benirv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","পুরুষ ও স্ত্রী করে তাঁদের সৃষ্টি করলেন; এবং সেই সৃষ্টিদিনে তাঁদেরকে আশীর্বাদ করে আদম, এই নাম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","পরে আদম একশো ত্রিশ বছর বয়সে নিজের মতো ও প্রতিমূর্ত্তিতে ছেলের জন্ম দিয়ে তার নাম শেথ রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","শেথের জন্ম দিলে পর আদম আটশো বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","সব মিলিয়ে আদমের নয়শো ত্রিশ বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","শেথ একশো পাঁচ বছর বয়সে ইনোশের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ইনোশের জন্ম দিলে পর শেথ আটশো সাত বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","সব মিলিয়ে শেথের নয়শো বারো বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ইনোশ নব্বই বছর বয়সে কৈননের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","কৈননের জন্ম দিলে পর ইনোশ আটশো পনের বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","সব মিলিয়ে ইনোশের নয়শো পাঁচ বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","কৈনন সত্তর বছর বয়সে মহললেলের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","মহললেলের জন্ম দিলে পর কৈনন আটশো চল্লিশ বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","সব মিলিয়ে কৈননের নয়শো দশ বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","মহললেল পঁয়ষট্টি বছর বয়সে যেরদের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","যেরদের জন্ম দিলে পর মহললেল আটশো ত্রিশ বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","সব মিলিয়ে মহললেলের আটশো পঁচানব্বই বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","যেরদ একশো বাষট্টি বছর বয়সে হনোকের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","হনোকের জন্ম দিলে পর যেরদ আটশো বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","সব মিলিয়ে যেরদের নয়শো বাষটি বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","হনোক পয়ষট্টি বছর বয়সে মথূশেলহের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","মথূশেলহের জন্ম দিলে পর হনোক তিনশো বছর ঈশ্বরের সঙ্গে যাতায়াত করলেন এবং আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","সব মিলিয়ে হনোক তিনশো পয়ষটি বছর থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","হনোক ঈশ্বরের সঙ্গে যাতায়াত করতেন। পরে তিনি আর থাকলেন না, কারণ ঈশ্বর তাঁকে গ্রহণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","মথূশেলহ একশো সাতাশী বছর বয়সে লেমকের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","লেমকের জন্ম দিলে পর মথূশেলহ সাতশো বিরাশী বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","সব মিলিয়ে মথূশেলহের নয়শো ঊনসত্তর বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","লেমক একশো বিরাশী বৎসর বয়সে ছেলের জন্ম দিয়ে তাঁর নাম নোহ বিশ্রাম রাখলেন; ");
INSERT INTO benirv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","তিনি নোহের নাম ধরে ডাকলেন, বললেন, “সদাপ্রভুর মাধ্যমে অভিশপ্ত ভূমি থেকে আমাদের যে শ্রম ও হাতের কষ্ট হয়, তার বিষয়ে এ আমাদেরকে সান্ত্বনা করবে।” ");
INSERT INTO benirv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","নোহের জন্ম দিলে পর লেমক পাঁচশো পঁচানব্বই বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","সব মিলিয়ে লেমকের সাতশো সাতাত্তর বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","পরে নোহ পাঁচশো বছর বয়সে শেম, হাম ও যেফতের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","এভাবে যখন পৃথিবীতে মানুষদের সংখ্যা বৃদ্ধি পেতে লাগল ও অনেক মেয়ে জন্ম গ্রহণ করল, ");
INSERT INTO benirv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","তখন ঈশ্বরের ছেলেরা মানুষদের মেয়েদেরকে সুন্দরী দেখে, যার যাকে ইচ্ছা, সে তাকে বিয়ে করতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","তাতে সদাপ্রভু বললেন, “আমার আত্মা মানুষদের মধ্যে সবদিন থাকবে না, কারণ তারা মাংসমাত্র; কিন্তু তাদের দিন একশো কুড়ি বছর হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","সেই দিনের পৃথিবীতে মহাবীররা ছিল এবং তার পরেও ঈশ্বরের ছেলেরা মানুষদের মেয়েদের কাছে গেলে তাদের গর্ভে ছেলেমেয়ে জন্মাল, তারাই সেকালের প্রসিদ্ধ বীর। ");
INSERT INTO benirv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","আর সদাপ্রভু দেখলেন, পৃথিবীতে মানুষের দুষ্টতা বড় এবং তার হৃদয়ের চিন্তার সমস্ত কল্পনা সবদিন কেবল খারাপ। ");
INSERT INTO benirv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","তাই সদাপ্রভু পৃথিবীতে মানুষের সৃষ্টির জন্য দুঃখিত হলেন ও মনে আঘাত পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","আর সদাপ্রভু বললেন, “আমি যে মানুষকে সৃষ্টি করেছি, তাকে পৃথিবী থেকে উচ্ছিন্ন করব; মানুষের সঙ্গে পশু, সরীসৃপ জীব ও আকাশের পাখিদেরকেও উচ্ছিন্ন করব; কারণ তাদের সৃষ্টির জন্য আমার দুঃখ হচ্ছে।” ");
INSERT INTO benirv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","কিন্তু নোহ সদাপ্রভুর দৃষ্টিতে অনুগ্রহ প্রাপ্ত হলেন। নোহের বংশ বৃত্তান্ত এই। ");
INSERT INTO benirv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","নোহ সেই সময়ের লোকদের মধ্যে ধার্মিক ও সিদ্ধ লোক ছিলেন, নোহ ঈশ্বরের সঙ্গে যাতায়াত করতেন। ");
INSERT INTO benirv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","নোহ শেম, হাম ও যেফৎ নামে তিন ছেলের জন্ম দেন। ");
INSERT INTO benirv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","সেই দিনের পৃথিবী ঈশ্বরের সামনে ভ্রষ্ট ও মন্দতায় পরিপূর্ণ ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","আর ঈশ্বর পৃথিবীতে দেখলেন, আর দেখ, সে ভ্রষ্ট হয়েছে, কারণ পৃথিবীতে অবস্থিত সমস্ত প্রাণী ভ্রষ্টাচারী হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","তখন ঈশ্বর নোহকে বললেন, “আমার চোখের সামনে সমস্ত প্রাণীর অন্তিমকাল উপস্থিত, কারণ তাদের দিয়ে পৃথিবী অত্যাচারে পরিপূর্ণ হয়েছে; আর দেখ, আমি পৃথিবীর সঙ্গে তাদেরকে বিনষ্ট করব। ");
INSERT INTO benirv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","তুমি গোফর কাঠ দিয়ে এক জাহাজ তৈরী কর; সেই জাহাজের মধ্যে কামরা তৈরী করবে ও তার ভিতরে ও বাইরে ধূনা দিয়ে লেপে দেবে। ");
INSERT INTO benirv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","এই ভাবে তা তৈরী করবে। জাহাজ দৈর্ঘ্যে তিনশো হাত, প্রস্থে পঞ্চাশ হাত ও উচ্চতায় ত্রিশ হাত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","আর তার ছাদের এক হাত নিচে জানালা তৈরী করে রাখবে ও জাহাজের পাশে দরজা রাখবে; তার প্রথম, দ্বিতীয় ও তৃতীয় তলা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","আর দেখ, আকাশের নীচে প্রাণবায়ুবিশিষ্ট যত জীবজন্তু আছে, সবাইকে বিনষ্ট করার জন্য আমি পৃথিবীর উপরে বন্যা আনব, পৃথিবীতে সবাই মারা যাবে। ");
INSERT INTO benirv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","কিন্তু তোমার সঙ্গে আমি নিজের নিয়ম স্থির করব; তুমি নিজের ছেলেদের, স্ত্রী ও ছেলের বউদেরকে সঙ্গে নিয়ে সেই জাহাজে প্রবেশ করবে। ");
INSERT INTO benirv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","আর মাংসবিশিষ্ট সমস্ত জীবজন্তুর স্ত্রীপুরুষ জোড়া জোড়া নিয়ে তাদের প্রাণরক্ষার জন্য নিজের সঙ্গে ");
INSERT INTO benirv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","সেই জাহাজে প্রবেশ করাবে; সর্বজাতীয় পাখি ও সর্বজাতীয় পশু ও সর্বজাতীয় মাটিতে চলা সরীসৃপ জোড়া জোড়া প্রাণরক্ষার জন্য তোমার কাছে প্রবেশ করবে। ");
INSERT INTO benirv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","আর তোমার ও তাদের আহারের জন্য তুমি সব ধরনের খাদ্য সামগ্রী এনে নিজের কাছে সঞ্চয় করবে।” ");
INSERT INTO benirv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","তাতে নোহ সেরকম করলেন, ঈশ্বরের আদেশ অনুসারেই সব কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","আর সদাপ্রভু নোহকে বললেন, “তুমি সপরিবারে জাহাজে প্রবেশ কর, কারণ এই কালের লোকদের মধ্যে আমার সামনে তোমাকেই ধার্মিক দেখেছি। ");
INSERT INTO benirv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","তুমি শুচি পশুর স্ত্রীপুরুষ নিয়ে প্রত্যেক জাতির সাত সাত জোড়া এবং অশুচি পশুর স্ত্রী ও পুরুষ নিয়ে প্রত্যেক জাতির ");
INSERT INTO benirv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","এক এক জোড়া এবং আকাশের পাখিদেরও স্ত্রীপুরুষ নিয়ে প্রত্যেক জাতির সাত সাত জোড়া, সমস্ত ভূমণ্ডলে তাদের বংশ রক্ষার জন্য নিজের সঙ্গে রাখ। ");
INSERT INTO benirv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","কারণ সাত দিনের র পর আমি পৃথিবীতে চল্লিশ দিন রাত বৃষ্টি বর্ষণ করে আমার সৃষ্টি যাবতীয় প্রাণীকে পৃথিবী থেকে উচ্ছিন্ন করব।” ");
INSERT INTO benirv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","তখন নোহ সদাপ্রভুর আদেশ অনুসারে সব কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","নোহের ছয়শো বছর বয়সে পৃথিবীতে জলপ্লাবন হল। ");
INSERT INTO benirv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","জলপ্লাবনের জন্য নোহ ও তাঁর ছেলেরা এবং তাঁর স্ত্রী ও ছেলের বউরা জাহাজে প্রবেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","নোহের প্রতি ঈশ্বরের আদেশ অনুসারে শুচি অশুচি পশুর ");
INSERT INTO benirv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","এবং পাখির ও ভূমিতে চলাচল যাবতীয় জীবের স্ত্রী পুরুষ জোড়া জোড়া জাহাজে প্রবেশ করল, যেমন ঈশ্বর নোহকে আদেশ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","আর সেই সাত দিন পরে পৃথিবীতে জলপ্লাবন হল। ");
INSERT INTO benirv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","নোহের বয়সের ছয়শো বছরের দ্বিতীয় মাসের সতেরো দিনের মহাজলধির সমস্ত উনুই ভেঙে গেল এবং আকাশের জানালা সব মুক্ত হল; ");
INSERT INTO benirv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","তাতে পৃথিবীতে চল্লিশ দিন রাত মহাবৃষ্টি হল। ");
INSERT INTO benirv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","সেই দিন নোহ এবং শেম, হাম ও যেফৎ নামে নোহের ছেলেরা এবং তাঁদের সঙ্গে নোহের স্ত্রী ও তিন ছেলের বউরা জাহাজে প্রবেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","আর তাঁদের সঙ্গে সর্বজাতীয় বন্য পশু, সবজাতীয় গ্রাম্য পশু, সবজাতীয় মাটিতে চলাচল করা সরীসৃপ জীব ও সবজাতীয় পাখি, ");
INSERT INTO benirv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","প্রাণবায়ুবিশিষ্ট সর্বপ্রকার জীবজন্তু জোড়া জোড়া জাহাজে নোহের কাছে প্রবেশ করল। ");
INSERT INTO benirv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ফলতঃ তাঁর প্রতি ঈশ্বরের আদেশ অনুসারে সমস্ত প্রাণীর স্ত্রী ও পুরুষ প্রবেশ করল। পরে সদাপ্রভু তাঁর জন্য পিছনের দরজা বন্ধ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","আর চল্লিশ দিন পর্যন্ত পৃথিবীতে বন্যা হল, তাতে জল বৃদ্ধি পেয়ে জাহাজ ভাসালে তা মাটি ছেড়ে উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","পরে জল প্রবল হয়ে পৃথিবীতে অনেক বেড়ে গেল এবং জাহাজ জলের উপরে ভেসে উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","আর পৃথিবীতে জল অত্যন্ত প্রবল হল, আকাশমণ্ডলের নীচের সব মহাপর্বত ডুবে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","তার উপরে পনেরো হ্যাঁত জল উঠে প্রবল হল, পর্বত সকল ডুবে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","তাতে মাটিতে চলাচল যাবতীয় প্রাণী, পাখি, পশুপাল ও বন্য পশু সব এবং সমস্ত মানুষ মারা গেল। ");
INSERT INTO benirv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","মাটিতে চলনশীল যত প্রাণীর নাকে প্রাণবায়ুর সঞ্চার ছিল, সকলে মারা গেল। ");
INSERT INTO benirv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","এই ভাবে পৃথিবী নিবাসী সমস্ত প্রাণী মানুষ, পশু, সরীসৃপ, জীব ও আকাশের পাখি সকল উচ্ছিন্ন হল, পৃথিবী থেকে উচ্ছিন্ন হল, কেবল নোহ ও তাঁর সঙ্গী জাহাজে প্রাণীরা বেঁচে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","আর জল পৃথিবীর উপরে একশো পঞ্চাশ দিন পর্যন্ত প্রবল থাকল। ");
INSERT INTO benirv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","আর ঈশ্বর নোহকে ও জাহাজে অবস্থিত তাঁর সঙ্গী পশু যাবতীয় প্রাণীকে স্মরণ করলেন, ঈশ্বর পৃথিবীতে বাতাস বহালেন, তাতে জল থামল। ");
INSERT INTO benirv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","আর গভীর জলের উনুই ও আকাশের জানালা সকল বন্ধ এবং আকাশের মহাবৃষ্টি থামল। ");
INSERT INTO benirv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","আর জল ক্রমশঃ মাটির ওপর থেকে সরে গিয়ে একশো পঞ্চাশ দিনের র শেষে কমে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","তাতে সপ্তম মাসে, সতেরো দিনের অরারটের পর্বতের ওপরে জাহাজ লেগে থাকল। ");
INSERT INTO benirv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","পরে দশ মাস পর্যন্ত জল কমতে থাকল, ঐ দশ মাসের প্রথম দিনের পর্বতের শৃঙ্গ দেখা গেল। ");
INSERT INTO benirv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","আর চল্লিশ দিন পরে নোহ নিজের বানানো জাহাজের জানালা খুলে, একটা দাঁড়কাক ছেড়ে দিলেন; ");
INSERT INTO benirv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","তাতে সে উড়ে ভূমির উপরের জল শুকনো না হওয়া পর্যন্ত এখানে ওখানে ঘোরাফেরা করতে লাগলো। ");
INSERT INTO benirv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","আর মাটির ওপরে জল কমেছে কি না, তা জানবার জন্য তিনি নিজের কাছ থেকে এক ঘুঘু ছেড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","তাতে সমস্ত পৃথিবী জলে ভরে থাকাতে ঘুঘু নামার জায়গা পেল না, তাই জাহাজে তাঁর কাছে ফিরে আসল। তখন তিনি হাত বাড়িয়ে তাকে ধরলেন ও জাহাজের ভিতরে নিজের কাছে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","পরে তিনি আর সাত দিন অপেক্ষা করে জাহাজ থেকে সেই ঘুঘু আবার ছেড়ে দিলেন ");
INSERT INTO benirv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","এবং ঘুঘুটি সন্ধ্যাবেলায় তাঁর কাছে ফিরে এল; আর দেখ, তার ঠোঁটে জিতগাছের একটা নতুন পাতা ছিল; এতে নোহ বুঝলেন, মাটির ওপরে জল কমেছে। ");
INSERT INTO benirv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","পরে তিনি আর সাত দিন অপেক্ষা করে সেই ঘুঘু ছেড়ে দিলেন, তখন সে তাঁর কাছে আর ফিরে এল না। ");
INSERT INTO benirv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","নোহের বয়সের ছয়শো এক বছরের প্রথম মাসের প্রথম দিনের পৃথিবীর ওপরে জল শুকনো হল; তাতে নোহ জাহাজের ছাদ খুলে দেখলেন, আর দেখ, মাটিতে জল নেই। ");
INSERT INTO benirv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","পরে দ্বিতীয় মাসের সাতাশ দিনের ভূমি শুকনো হল। ");
INSERT INTO benirv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","পরে ঈশ্বর নোহকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","তুমি নিজের বউ, ছেলেদের ও ছেলের বউদেরকে সঙ্গে নিয়ে জাহাজ থেকে বাইরে যাও। ");
INSERT INTO benirv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","আর তোমার সঙ্গী পশু, পাখি ও মাটিতে চলা সরীসৃপ প্রভৃতি মাংসিক যত জীবজন্তু আছে, সেই সমস্ত কিছুকে তোমার সঙ্গে বাইরে আন, তারা পৃথিবীতে প্রাণীময় করুক এবং পৃথিবীতে ফলবান ও বহুবংশ হোক। ");
INSERT INTO benirv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","তখন নোহ নিজের ছেলেদের এবং নিজের স্ত্রী ও ছেলের স্ত্রীদেরকে সঙ্গে নিয়ে বের হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","আর নিজের নিজের জাতি অনুসারে প্রত্যেক পশু, সরীসৃপ জীব ও পাখি, সমস্ত মাটিতে চলনশীল প্রাণী জাহাজ থেকে বের হল। ");
INSERT INTO benirv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","পরে নোহ সদাপ্রভুর উদ্দেশ্যে যজ্ঞবেদি নির্মাণ করলেন এবং সমস্ত রকমের শুচি পশুর ও সমস্ত রকমের শুচি পাখির মধ্যে কতকগুলি নিয়ে বেদির ওপরে হোম করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","তাতে সদাপ্রভু তার সুগন্ধ গ্রহণ করলেন, আর সদাপ্রভু মনে মনে বললেন, “আমি মানুষের জন্য মাটিকে আর অভিশাপ দেব না, কারণ বাল্যকাল পর্যন্ত মানুষের মনের কল্পনা দুষ্ট; যেমন করলাম, তেমন আর কখনও সকল প্রাণীকে ধ্বংস করব না। ");
INSERT INTO benirv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","যতদিন পৃথিবী থাকবে, ততদিন শস্য বোনার ও শস্য কাটার দিন এবং শীত ও উত্তাপ এবং গ্রীষ্মকাল ও হেমন্তকাল এবং দিন ও রাত, এই সমস্ত থেমে যাবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","পরে ঈশ্বর নোহকে ও তাঁর ছেলেদেরকে এই আশীর্বাদ করলেন ও বললেন, “তোমরা ফলবান ও বহুবংশ হও, পৃথিবী ভরিয়ে তোলো। ");
INSERT INTO benirv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","পৃথিবীর যাবতীয় প্রাণী ও আকাশের যাবতীয় পাখি তোমাদের থেকে ভয় ও ত্রাসযুক্ত হবে; সমস্ত মাটিতে চলা জীব ও সমুদ্রের সমস্ত মাছ সে সব তোমাদেরই হাতে দেওয়া আছে। ");
INSERT INTO benirv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","প্রত্যেক গমনশীল প্রাণী তোমাদের খাদ্য হবে; আমি সবুজ গাছপালার মতো সে সকল তোমাদেরকে দিলাম। ");
INSERT INTO benirv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","কিন্তু প্রাণসহ অর্থাৎ রক্তসহ মাংস খেও না। ");
INSERT INTO benirv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","আর তোমাদের রক্তপাত হলে আমি তোমাদের প্রাণের পক্ষে তার প্রতিশোধ অবশ্যই নেব; সকল পশুর কাছে তার প্রতিশোধ নেব। এবং মানুষের ভাই মানুষের কাছে আমি মানুষের প্রাণের প্রতিশোধ নেব।” ");
INSERT INTO benirv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","যে কেউ মানুষের রক্তপাত করবে, মানুষের মাধ্যমে তার রক্তপাত করা যাবে; কারণ ঈশ্বর নিজের প্রতিমূর্ত্তিতে মানুষকে নির্মাণ করেছেন। ");
INSERT INTO benirv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","তোমরা ফলবান ও বহুবংশ হও, পৃথিবীকে প্রাণীময় কর, ও তার মধ্যে বেড়ে ওঠ। ");
INSERT INTO benirv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","পরে ঈশ্বর নোহকে ও তাঁর সঙ্গী ছেলেদেরকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“দেখ, তোমাদের সঙ্গে, তোমাদের আগামী বংশের সঙ্গে ও তোমাদের সঙ্গী যাবতীয় প্রাণীর সঙ্গে, ");
INSERT INTO benirv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","পাখি এবং পশুপাল ও বন্য পশু, পৃথিবীতে অবস্থিত যত প্রাণী জাহাজ থেকে বের হয়েছে, তাদের সঙ্গে আমি আমার নিয়ম স্থির করি। ");
INSERT INTO benirv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","আমি তোমাদের সঙ্গে আমার নিয়ম স্থির করি; বন্যার মাধ্যমে সমস্ত প্রাণী আর ধ্বংস হবে না এবং পৃথিবীর বিনাশের জন্য জলপ্লাবন আর হবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ঈশ্বর আরও বললেন, “আমি তোমাদের সঙ্গে ও তোমাদের সঙ্গী যাবতীয় প্রাণীর সঙ্গে চিরস্থায়ী পুরুষ পরম্পরার জন্য যে নিয়ম স্থির করলাম, তাঁর চিহ্ন এই।” ");
INSERT INTO benirv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","আমি মেঘে নিজের মেঘধনু স্থাপন করি, সেটাই পৃথিবীর সঙ্গে আমার নিয়মের চিহ্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","যখন আমি পৃথিবীর উপরে মেঘ আনব, তখন সেই মেঘধনু মেঘে দেখা যাবে; ");
INSERT INTO benirv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","তাতে তোমাদের সঙ্গে ও মাংসিক সমস্ত প্রাণীর সঙ্গে আমার যে নিয়ম আছে, তা আমার স্মরণ হবে এবং সকল প্রাণীর বিনাশের জন্য জলপ্লাবন আর হবে না। ");
INSERT INTO benirv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","আর মেঘধনু হলে আমি তার প্রতি দৃষ্টিপাত করব; তাতে মাংসিক যত প্রাণী পৃথিবীতে আছে, তাদের সঙ্গে ঈশ্বরের যে চিরস্থায়ী নিয়ম, তা আমি স্মরণ করব। ");
INSERT INTO benirv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ঈশ্বর নোহকে বললেন, “এটি একটি নিয়মের চিহ্ন যা আমার এবং পৃথিবীর সব প্রাণীর সঙ্গে স্থাপিত হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","নোহের যে ছেলেরা জাহাজ থেকে বের হলেন, তাঁদের নাম শেম, হাম ও যেফৎ; সেই হাম কনানের বাবা। ");
INSERT INTO benirv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","এই তিনজন নোহের ছেলে; এদেরই বংশ সমস্ত পৃথিবীতে ছড়িয়ে পড়ল। ");
INSERT INTO benirv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","পরে নোহ কৃষিকাজে যুক্ত হয়ে আঙ্গুরের ক্ষেত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","আর তিনি আঙ্গুর রস পান করে মাতাল হলেন এবং তাঁবুর মধ্যে বিবস্ত্র হয়ে পড়লেন। ");
INSERT INTO benirv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","তখন কনানের বাবা হাম নিজের বাবার উলঙ্গতা দেখে বাইরে নিজের দুই ভাইকে বলল। ");
INSERT INTO benirv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","তাতে শেম ও যেফৎ কাপড় নিয়ে নিজেদের কাঁধে রেখে পিছনে হেঁটে বাবার উলঙ্গতা ঢেকে দিলেন; পিছন দিকে মুখ থাকাতে তাঁরা পিতার উলঙ্গতা দেখলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","পরে নোহ আঙ্গুর রসের ঘুম থেকে জেগে উঠে তাঁর প্রতি ছোট ছেলের আচরণ জানতে পারলেন। ");
INSERT INTO benirv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","আর তিনি বললেন, “কনান অভিশপ্ত হোক, সে নিজের ভাইদের দাসানুদাস হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","তিনি আরও বললেন, “শেমের ঈশ্বর সদাপ্রভু ধন্য; কনান তার দাস হোক। ");
INSERT INTO benirv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ঈশ্বর যেফৎকে বিস্তীর্ণ করুন; সে শেমের তাঁবুতে বাস করুক, আর কনান তার দাস হোক।” ");
INSERT INTO benirv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","জলপ্লাবনের পরে নোহ তিনশো পঞ্চাশ বছর জীবিত থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","সব মিলিয়ে নোহের নয়শো পঞ্চাশ বছর বয়স হলে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","নোহের ছেলে শেম, হাম ও যেফতের বংশ বৃত্তান্ত এই। বন্যার পরে তাঁদের ছেলেমেয়ে জন্মাল। ");
INSERT INTO benirv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","যেফতের ছেলে গোমর, মাগোগ, মাদয়, যবন, তূবল, মেশক ও তীরস। ");
INSERT INTO benirv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","গোমরের ছেলে অস্কিনস, রীফৎ ও ");
INSERT INTO benirv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","তোগর্ম। যবনের ছেলে ইলীশা, তর্শীশ, ");
INSERT INTO benirv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","কিত্তীম ও দোদানীম। এই সমস্ত থেকে জাতিদের দ্বীপনিবাসীরা নিজের নিজের দেশে নিজের নিজের ভাষানুসারে নিজের নিজের জাতির নানা গোষ্ঠীতে বিভক্ত হল। ");
INSERT INTO benirv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","আর হামের ছেলে কূশ, মিশর, পুট ও কনান। ");
INSERT INTO benirv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","কূশের ছেলে সবা, হবীলা, সপ্তা, রয়মা ও সপ্তকা। রয়মার ছেলে শিবা ও দদান। ");
INSERT INTO benirv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","নিম্রদ কূশের ছেলে; তিনি পৃথিবীতে শক্তিশালী হতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","তিনি সদাপ্রভুর সামনে শক্তিশালী শিকারী হলেন; তার জন্য লোকে বলে, সদাপ্রভুর সামনে শক্তিশালী শিকারী নিম্রোদের তুল্য। ");
INSERT INTO benirv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","শিনিয়র দেশে বাবিল, এরক, অক্কদ ও কলনী, এই সব জায়গা তাঁর রাজ্যের প্রথম অংশ ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","সেই দেশ থেকে তিনি অশূরে গিয়ে নীনবী, ");
INSERT INTO benirv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","রহবোৎপুরী, কেলহ এবং নীনবী ও কেলহের মাঝখানে রেষন পত্তন করলেন; ওটা মহানগর। ");
INSERT INTO benirv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","আর লূদীয়, অনামীয়, ");
INSERT INTO benirv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","লহাবীয়, নপ্তুহীয়, পথ্রোষীয়, পলেষ্টীয়দের পূর্বপুরুষ কসলূহীয় এবং কপ্তরীয়, এই সব মিশরের সন্তান। ");
INSERT INTO benirv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","এবং কনানের বড় ছেলে সীদন, তারপর হেৎ, ");
INSERT INTO benirv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","যিবূষীয়, ইমোরীয়, গির্গাশীয়, ");
INSERT INTO benirv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","হিব্বীয়, অর্কীয়, সীনীয়, ");
INSERT INTO benirv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","অর্বদীয়, সমারীয় ও হমাতীয়। পরে কনানীয়দের গোষ্ঠী সকল বিস্তারিত হল। ");
INSERT INTO benirv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","সীদোন থেকে গরারের দিকে ঘসা পর্যন্ত এবং সদোম, ঘমোরা, অদমা ও সবোয়ীমের দিকে লাশা পর্যন্ত কনানীয়দের সীমা ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","নিজের নিজের গোষ্ঠী, ভাষা, দেশ ও জাতি অনুসারে এই সব হামের ছেলে। ");
INSERT INTO benirv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","যে শেম এবারের সব লোকদের পূর্বপুরুষ, আর যেফতের বড় ভাই, তাঁরও ছেলেমেয়ে ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","শেমের এই সকল ছেলে এলম, অশূর, অর্ফকষদ, লূদ ও অরাম। ");
INSERT INTO benirv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","অরামের সন্তান ঊষ, হূল, গেথর ও মশ। ");
INSERT INTO benirv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","আর অর্ফকষদ শেলহের জন্ম দিলেন ও শেলহ এবারের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","এবারের দুই ছেলে; একের নাম পেলগ বিভাগ, কারণ সেই দিনের পৃথিবী ভাগ হল। তাঁর ভাইয়ের নাম যক্তন। ");
INSERT INTO benirv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","যক্তন অলমোদদ, শেলফ, হৎসর্মাবৎ, যেরহ, ");
INSERT INTO benirv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","হদোরাম, উষল, দিক্ল, ");
INSERT INTO benirv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ওবল, অবীমায়েল, শিবা, ");
INSERT INTO benirv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ওফীর, হবীলা ও যোববের বাবা হলেন। এরা সবাই যক্তনের ছেলে। ");
INSERT INTO benirv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","মেষা থেকে পূর্বদিকের সফার পর্বত পর্যন্ত তাদের বসতি ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","নিজের নিজের গোষ্ঠী, ভাষা, দেশ ও জাতি অনুসারে এই সকল শেমের ছেলে। ");
INSERT INTO benirv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","নিজের নিজের বংশ ও জাতি অনুসারে এরা নোহের ছেলেদের গোষ্ঠী এবং বন্যার পরে এদের থেকে তৈরী নানা জাতি পৃথিবীতে ভাগ হল। ");
INSERT INTO benirv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","সমস্ত পৃথিবীতে এক ভাষা ও একই কথা ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","পরে লোকেরা পূর্বদিকে ঘুরতে ঘুরতে শিনিয়র দেশে এক সমভূমি পেয়ে সে জায়গায় বাস করল; ");
INSERT INTO benirv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","আর একে অপরকে বলল, “এস, আমরা ইট তৈরী করে আগুনে পোড়াই,” তাতে তাদের পাথরের পরিবর্তে ইট ও চূনের পরিবর্তে আলকাতরা ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","পরে তারা বলল, “এস, আমরা নিজেদের জন্য এক শহর ও আকাশকে নাগাল পেতে পারে এমন এক উঁচু বাড়ি (মিনার) তৈরী করে নিজেদের নাম বিখ্যাত করি, যদি সমস্ত পৃথিবীতে ছড়িয়ে ছিটিয়ে পড়ি।” ");
INSERT INTO benirv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","পরে মানুষেরা যে শহর ও উঁচু বাড়ি (মিনার) তৈরী করছিল, তা দেখতে সদাপ্রভু নেমে এলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","আর সদাপ্রভু বললেন, “দেখ, তারা সবাই এক জাতি ও এক ভাষাবাদী; এখন এই কাজে যুক্ত হল; এর পরে যা কিছু করতে ইচ্ছা করবে, তা থেকে তারা থেমে যাবে না। ");
INSERT INTO benirv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","এস, আমরা নিচে গিয়ে, সেই জায়গায় তাদের ভাষার ভেদ জন্মাই, যেন তারা এক জন অন্যের ভাষা বুঝতে না পারে।” ");
INSERT INTO benirv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","আর সদাপ্রভু সেখান থেকে সমস্ত পৃথিবীতে তাদেরকে ছিন্নভিন্ন করলেন এবং তারা শহর তৈরী করা থেকে থেমে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","এই জন্য সেই শহরের নাম বাবিল ভেদ হল; কারণ সেই জায়গায় সদাপ্রভু সমস্ত পৃথিবীর ভাষার ভেদ জন্মিয়েছিলেন এবং সেখান থেকে সদাপ্রভু তাদেরকে সমস্ত পৃথিবীতে ছিন্নভিন্ন করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","শেমের বংশ-বৃত্তান্ত এই। শেম একশো বছর বয়সে, বন্যার দুই বছর পরে, অর্ফকষদের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","অর্ফকষদের জন্ম দিলে পর শেম পাঁচশো বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","অর্ফকষদ পঁয়ত্রিশ বছর বয়সে শেলহের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","শেলহের জন্ম দিলে পর অর্ফকষদ চারশো তিন বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","শেলহ ত্রিশ বছর বয়সে এবারের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","এবারের জন্ম দিলে পর শেলহ চারশো তিন বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","এবর চৌত্রিশ বছর বয়সে পেলগের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","পেলগের জন্ম দিলে পর এবর চারশো ত্রিশ বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","পেলগ ত্রিশ বছর বয়সে রিয়ূর জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","রিয়ূর জন্ম দিলে পর পেলগ দুইশো নয় বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","রিয়ূ বত্রিশ বছর বয়সে সরূগের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","সরূগের জন্ম দিলে পর রিয়ূ দুশো সাত বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","সরূগ ত্রিশ বছর বয়সে নাহোরের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","নাহোরের জন্ম দিলে পর সরূগ দুশো বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","নাহোর উনত্রিশ বছর বয়সে তেরহের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","তেরহের জন্ম দিলে পর নাহোর একশো উনিশ বছর জীবিত থেকে আরও ছেলেমেয়ের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","তেরহ সত্তর বছর বয়সে অব্রাম, নাহোর ও হারণের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","তেরহের বংশ বৃত্তান্ত এই। তেরহ অব্রাম, নাহোর ও হারণের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","আর হারণ লোটের জন্ম দিলেন। কিন্তু হারণ নিজের বাবা তেরহের সামনে নিজের জন্মস্থান কলদীয় দেশের ঊরে প্রাণত্যাগ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","অব্রাম ও নাহর উভয়েই বিয়ে করলেন; অব্রাহামের স্ত্রীর নাম সারী ও নাহোরের স্ত্রীর নাম মিলকা। এই স্ত্রী হারণের মেয়ে; হারণ মিলকার ও যিস্কার বাবা। ");
INSERT INTO benirv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","সারী বন্ধ্যা ছিলেন, তাঁর সন্তান হল না। ");
INSERT INTO benirv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","আর তেরহ নিজের ছেলে অব্রামকে ও হারণের ছেলে নিজের নাতি লোটকে এবং অব্রাহামের স্ত্রী সারী নাম্নী ছেলের স্ত্রীকে সঙ্গে নিলেন; তাঁরা একসঙ্গে কনান দেশে যাবার জন্য কলদীয় দেশের ঊর থেকে যাত্রা করলেন; আর হারণ নগর পর্যন্ত গিয়ে সেখানে বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","পরে তেরহের দুশো পাঁচ বছর বয়স হলে হারণে তাঁর মৃত্যু হল। ");
INSERT INTO benirv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","সদাপ্রভু অব্রামকে বললেন, “তুমি নিজের দেশ, আত্মীয় ও বাবার বাড়ি ছেড়ে দিয়ে, আমি যে দেশ তোমাকে দেখাই, সেই দেশে চল। ");
INSERT INTO benirv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","আমি তোমার থেকে এক মহাজাতি সৃষ্টি করব এবং তোমাকে আশীর্বাদ করে তোমার নাম মহৎ করব, তাতে তুমি আশীর্বাদের আকর হবে। ");
INSERT INTO benirv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","যারা তোমাকে আশীর্বাদ করবে, তাদেরকে আমি আশীর্বাদ করব, যে কেউ তোমাকে অভিশাপ দেবে, তাকে আমি অভিশাপ দেব এবং তোমাতে পৃথিবীর যাবতীয় গোষ্ঠী আশীর্বাদ পাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","পরে অব্রাম সদাপ্রভুর সেই বাক্যানুসারে যাত্রা করলেন এবং লোটও তাঁর সঙ্গে গেলেন। হারন থেকে চলে যাবার দিন অব্রামের পঁচাত্তর বছর বয়স ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","অব্রাম নিজের স্ত্রী সারীকে ও ভাইয়ের ছেলে লোটকে এবং হারণে তাঁরা যে ধন উপার্জন করেছিলেন ও যে প্রাণীদেরকে লাভ করেছিলেন, সে সমস্ত নিয়ে কনান দেশে যাওয়ার জন্য যাত্রা করলেন এবং কনান দেশে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","আর অব্রাম দেশ দিয়ে যেতে যেতে শিখিমে, মোরির এলোন গাছের কাছে উপস্থিত হলেন। ঐ দিনের কনানীয়েরা সেই দেশে বাস করত। ");
INSERT INTO benirv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","পরে সদাপ্রভু অব্রামকে দেখা দিয়ে বললেন, “আমি তোমার বংশকে এই দেশ দেব,” তখন সেই জায়গায় অব্রাম সদাপ্রভুর উদ্দেশ্যে এক যজ্ঞবেদি করলেন, যিনি তাঁকে দর্শন দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","পরে তিনি ঐ জায়গা ত্যাগ করে পর্বতে গিয়ে বৈথেলের পূর্ব দিকে নিজের তাঁবু স্থাপন করলেন; তার পশ্চিমে বৈথেল ও পূর্ব দিকে অয় ছিল; তিনি সে জায়গায় সদাপ্রভুর উদ্দেশ্যে এক যজ্ঞবেদি নির্মাণ করলেন ও সদাপ্রভুর নামে ডাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","পরে অব্রাম ক্রমে ক্রমে দক্ষিণ দিকে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","আর দেশে দূর্ভিক্ষ হল, তখন অব্রাম মিশরে বাস করতে যাত্রা করলেন; কারণ কনান দেশে ভারী দূর্ভিক্ষ হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","আর অব্রাম যখন মিশরে প্রবেশ করতে উদ্যত হন, তখন নিজের স্ত্রী সারীকে বললেন, “দেখ, আমি জানি, তুমি দেখতে সুন্দরী; ");
INSERT INTO benirv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","এ কারণ মিশরীয়েরা যখন তোমাকে দেখে বলবে, ‘এ তাঁর স্ত্রী,’ এবং আমাকে হত্যা করবে, আর তারা তোমাকে জীবিত রাখবে। ");
INSERT INTO benirv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","অনুরোধ করে, এই কথা বলো যে, তুমি আমার বোন; যেন তোমার অনুরোধে আমার ভালো হয়, তোমার জন্য আমার প্রাণ বাঁচে।” ");
INSERT INTO benirv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","পরে অব্রাম মিশরে প্রবেশ করলে মিশরীয়েরা ঐ স্ত্রীকে খুব সুন্দরী দেখল। ");
INSERT INTO benirv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","আর ফরৌণের সামনে তাঁর প্রশংসা করলেন; তাঁতে সেই স্ত্রীকে ফরৌণের বাড়িতে নিয়ে যাওয়া হল। ");
INSERT INTO benirv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","আর তাঁর অনুরোধে তিনি অব্রামকে আদর করলেন; তাতে অব্রাম মেষ, গরু, গাধা এবং দাস দাসী গাধী ও উট পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","কিন্তু অব্রামের স্ত্রী সারীর জন্য সদাপ্রভু ফরৌণ ও তাঁর পরিবারের ওপরে ভারী ভারী উৎপাত ঘটালেন। ");
INSERT INTO benirv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","তাতে ফরৌণ অব্রামকে ডেকে বললেন, “আপনি আমার সঙ্গে এ কি ব্যবহার করলেন? উনি আপনার স্ত্রী, এ কথা আমাকে কেন বলেননি? ");
INSERT INTO benirv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ওনাকে আপনার বোন কেন বললেন? আমি তো ওনাকে বিয়ে করার জন্য নিয়েছিলাম। এখন আপনার স্ত্রীকে নিয়ে চলে যান।” ");
INSERT INTO benirv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","তখন ফরৌণ লোকদেরকে তাঁর বিষয়ে আদেশ দিলেন, আর তারা সব কিছুর সঙ্গে তাঁকে ও তাঁর স্ত্রীকে বিদায় করল। ");
INSERT INTO benirv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","পরে অব্রাম ও তাঁর স্ত্রী সমস্ত সম্পত্তি নিয়ে লোটের সঙ্গে মিশর থেকে কনান দেশের দক্ষিণাঞ্চলে যাত্রা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","অব্রাম পশুধনে ও সোনা রূপাতে খুব ধনবান ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","পরে তিনি দক্ষিণ থেকে বৈথেলের দিকে যেতে যেতে বৈথেলের ও অয়ের মাঝখানে যে জায়গায় আগে তাঁর তাঁবু ছিল, ");
INSERT INTO benirv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","সেই জায়গায় নিজের আগে নির্মাণ করা যজ্ঞবেদির কাছে উপস্থিত হলেন; সেখানে অব্রাম সদাপ্রভুর নামে ডাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","আর অব্রামের সহযাত্রী লোটেরও অনেক ভেড়া ও গরু এবং লোক ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","আর সেই দেশে একসঙ্গে তাদের বসবাস করা হল না, কারণ তাঁদের প্রচুর সম্পত্তি থাকাতে তাঁরা একসঙ্গে বাস করতে পারলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","আর অব্রামের পশুপালকদের ও লোটের পশুপালকদের পরস্পর ঝগড়া হল। ঐ দিনের সেই দেশে কনানীয়েরা ও পরিষীয়েরা বাস করত। ");
INSERT INTO benirv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","তাতে অব্রাম লোটকে বললেন, “অনুরোধ করি, তোমার ও আমার মধ্যে এবং তোমার পশুপালকদের ও আমার পশুপালকদের মধ্যে ঝগড়া না হোক; কারণ আমরা পরস্পর জ্ঞাতি। ");
INSERT INTO benirv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","তোমার সামনে কি সমস্ত দেশ নেই? অনুরোধ করি, আমার থেকে আলাদা হও; হয়, তুমি বামে যাও, আমি দক্ষিণে যাই; নয়, তুমি দক্ষিণে যাও, আমি বামে যাই।” ");
INSERT INTO benirv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","তখন লোট চোখ তুলে দেখলেন, যর্দ্দনের সমস্ত অঞ্চল সোয়র পর্যন্ত সব জায়গা সজল, সদাপ্রভুর বাগানের মতো, মিশর দেশের মতো, কারণ সেইদিনের সদাপ্রভু সদোম ও ঘমোরা বিনষ্ট করেননি। ");
INSERT INTO benirv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","অতএব লোট নিজের জন্য যর্দ্দনের সব অঞ্চল বেছে নিয়ে পূর্বদিকে চলে গেলেন; এই ভাবে তাঁরা পরস্পর আলাদা হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","অব্রাম কনান দেশে থাকলেন এবং লোট সেই অঞ্চলের নগরগুলির মধ্যে থেকে সদোম পর্যন্ত তাঁবু স্থাপন করতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","সদোমের লোকেরা অনেক দুষ্ট ও সদাপ্রভুর বিরুদ্ধে অনেক পাপ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","অব্রাম থেকে লোট আলাদা হলে পর সদাপ্রভু অব্রামকে বললেন, “চোখ তুলে এই যে জায়গায় তুমি আছ, এই জায়গা থেকে উত্তর দক্ষিণে ও পূর্ব পশ্চিমে দেখো; ");
INSERT INTO benirv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","কারণ এই যে সমস্ত দেশ তুমি দেখতে পাচ্ছ, এটা আমি তোমাকে ও যুগে যুগে তোমার বংশকে দেব। ");
INSERT INTO benirv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","আর পৃথিবীর ধূলোর মতো তোমার বংশ বৃদ্ধি করব; কেউ যদি পৃথিবীর ধূলো গুণতে পারে, তবে তোমার বংশও গোনা যাবে। ");
INSERT INTO benirv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ওঠ, এই দেশের দৈর্ঘ্য ও প্রস্থ অনুসারে ঘুরে দেখ, কারণ আমি তোমাকেই এটা দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","তখন অব্রাম তাঁবু তুলে হিব্রোণে অবস্থিত মম্রির এলোন বনের কাছে গিয়ে বাস করলেন এবং সেখানে সদাপ্রভুর উদ্দেশ্যে এক যজ্ঞবেদি নির্মাণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","শিনিয়রের অম্রাফল রাজা, ইল্লাসরের অরিয়োক রাজা, এলমের কদর্লায়োমর রাজা এবং গোয়ীমের তিদিয়ল রাজার দিনের ");
INSERT INTO benirv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ঐ রাজারা সদোমের রাজা বিরা, ঘমোরার রাজা বির্সা, অদমার রাজা শিনাব, সবোয়িমের রাজা শিমেবর ও বেলার অর্থাৎ সোয়রের রাজার সঙ্গে যুদ্ধ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","এরা সবাই সিদ্দিম উপত্যকাতে অর্থাৎ লবণসমুদ্রে জড়ো হয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","এরা বারো বছর পর্যন্ত কদরলায়মের দাসত্বে থেকে তেরো বছরে বিদ্রোহী হন। ");
INSERT INTO benirv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","পরে চোদ্দো বছরে কদরলায়মের ও তাঁর সঙ্গী রাজারা এসে অস্তরোৎ কর্ণয়িমে রফায়ীয়দেরকে, হমে সুষীয়দেরকে, শাবি ");
INSERT INTO benirv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","কিরিয়াথয়িমে এমীয়দেরকে ও প্রান্তরের পাশে এল-পারন পর্যন্ত সেয়ীর পর্বতে সেখানকার হোরীয়দেরকে আঘাত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","পরে সেখান থেকে ফিরে ঐনমিষ্পটে অর্থাৎ কাদেশ গিয়ে অমালেকীয়দের সমস্ত দেশকে এবং হৎসসোন-তামর নিবাসী ইমোরীয়দেরকে আঘাত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","আর সদোমের রাজা, ঘমোরার রাজা, অদমার রাজা, সবোয়িমের রাজা ও বেলার অর্থাৎ সোয়রের রাজা বের হয়ে ");
INSERT INTO benirv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","এলমের কদর্লায়োমর রাজার, গোয়ীমের তিদিয়ল রাজার, শিনিয়রের অম্রাফল রাজার ও ইল্লাসরের অরিয়োক রাজার সঙ্গে, পাঁচ জন রাজা চারজন রাজার সঙ্গে যুদ্ধ করার জন্য সিদ্দীম উপত্যকাতে সেনা স্থাপন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ঐ সিদ্দীম উপত্যকাতে আলকাতরার অনেক খাত ছিল; আর সদোম ও ঘমোরার রাজারা পালিয়ে গেলেন ও তাঁর মধ্যে পড়ে গেলেন এবং অবশিষ্টেরা পর্বতে পালিয়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","আর শত্রুরা সদোম ঘমোরার সমস্ত সম্পতি ও খাদ্য দ্রব্য নিয়ে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","বিশেষত তাঁরা অব্রামের ভাইয়ের ছেলে লোটকে ও তাঁর সম্পতি নিয়ে গেলেন, কারণ তিনি সদোমে বাস করছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","তখন এক জন পলাতক ইব্রীয় অব্রামকে খবর দিল; ঐ দিনের তিনি ইষ্কোলের ভাই ও আনেরের ভাই ইমোরীয় মম্রির এলোন বনে বাস করছিলেন এবং তাঁরা অব্রামের সঙ্গে যুক্ত ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","অব্রাম যখন শুনলেন, তার আত্মীয় ধরা পড়েছেন, তখন তিনি বাড়িতে জন্মানো তিনশো আঠারো জন প্রশিক্ষণপ্রাপ্ত দাসকে নিয়ে দান পর্যন্ত তাড়া করে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","পরে রাতে নিজের দাসদেরকে দুই দলে ভাগ করে তিনি শত্রুদেরকে আঘাত করলেন এবং দম্মেশকের উত্তরে অবস্থিত হোবা পর্যন্ত তাড়িয়ে দিলেন ");
INSERT INTO benirv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","এবং সকল সম্পতি, আর নিজের আত্মীয় লোট ও তাঁর সম্পত্তি এবং স্ত্রীলোকদেরকে ও লোক সকলকে ফিরিয়ে আনলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","অব্রাম কদলায়েমরকে ও তাঁর সঙ্গী রাজাদের জয় করে ফিরে আসলে পর, সদোমের রাজা তাঁর সঙ্গে দেখা করতে শাবী তলভূমিতে অর্থাৎ রাজার তলভূমিতে গেলেন ");
INSERT INTO benirv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","এবং শালেমের রাজা মল্কীষেদক রুটি ও আঙ্গুর রস বের করে আনলেন, তিনি সর্বশক্তিমান ঈশ্বরের যাজক। ");
INSERT INTO benirv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","তিনি অব্রামকে আশীর্বাদ করলেন, বললেন, “অব্রাম স্বর্গমর্তের সৃষ্টিকর্ত্তা সর্বশক্তিমান ঈশ্বরের আশীর্বাদযুক্ত হোন, ");
INSERT INTO benirv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","আর সর্বশক্তিমান ঈশ্বর ধন্য হোন, যিনি তোমার বিপক্ষদেরকে তোমার হাতে দিয়েছেন।” তখন অব্রাম সমস্ত দ্রব্যের দশমাংশ তাকে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","আর সদোমের রাজা অব্রামকে বললেন, “সব লোকজনকে আমাকে দিন, সম্পত্তি নিজের জন্য নিন।” ");
INSERT INTO benirv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","তখন অব্রাম সদোমের রাজাকে উত্তর করলেন, “আমি স্বর্গমর্তের অধিকারী সর্বশক্তিমান ঈশ্বর সদাপ্রভুর উদ্দেশ্যে হাত উঠিয়ে বলছি, ");
INSERT INTO benirv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","আমি আপনার কিছুই নেব না, এক গাছি সুতো কি জুতোর ফিতেও নেব না; যদি আপনি বলেন, আমি অব্রামকে ধনবান্‌ করেছি। ");
INSERT INTO benirv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","কেবল আমার যুবকরা যা খেয়েছে তা নেব এবং যে ব্যক্তিরা আমার সঙ্গে গিয়েছিলেন, আনের, ইষ্কোল ও মম্রি, তাঁরা নিজের নিজের প্রাপ্ত অংশ গ্রহণ করুন।” ");
INSERT INTO benirv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ঐ ঘটনার পরে দর্শনে সদাপ্রভুর বাক্য অব্রামের কাছে উপস্থিত হল, তিনি বললেন, “অব্রাম, ভয় কর না, আমিই তোমার ঢাল ও তোমার মহাপুরস্কার।” ");
INSERT INTO benirv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","অব্রাম বললেন, “হে প্রভু সদাপ্রভু, তুমি আমাকে কি দেবে? আমি তো নিঃসন্তান হয়ে মারা যাচ্ছি এবং এই দম্মেশকীয় ইলীয়েষর আমার বাড়ির উত্তরাধিকারী।” ");
INSERT INTO benirv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","আর অব্রাম বললেন, “দেখ, তুমি আমাকে সন্তান দিলে না এবং আমার গৃহের এক জন আমার উত্তরাধিকারী হবে। ");
INSERT INTO benirv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","তখন দেখ, তাঁর কাছে সদাপ্রভুর বাক্য উপস্থিত হল, যেমন ঐ ব্যক্তি তোমার উত্তরাধিকারী হবে না, কিন্তু যে তোমার ঔরসে জন্মাবে, সেই তোমার উত্তরাধিকারী হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","পরে তিনি তাঁকে বাইরে এনে বললেন, “তুমি আকাশের দিকে দেখে যদি তারা গুণতে পার, তবে গুনে বল; তিনি তাঁকে আরও বললেন এইরকম তোমার বংশ হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","তখন তিনি সদাপ্রভুতে বিশ্বাস করলেন, আর সদাপ্রভু তাঁর পক্ষে তা ধার্ম্মিকতা বলে গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","আর তাঁকে বললেন, “যিনি তোমার অধিকারের জন্য এই দেশ দেবেন বলে কলদীয় দেশের ঊর থেকে তোমাকে বের করে এনেছেন, সেই সদাপ্রভু আমি।” ");
INSERT INTO benirv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","তখন তিনি বললেন, “হে প্রভু সদাপ্রভু, আমি যে এর অধিকারী হব, তা কিভাবে জানব?” ");
INSERT INTO benirv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","তিনি তাঁকে বললেন, “তুমি তিন বছরের এক গরু, তিন বছরের এক ছাগল, তিন বছরের একটি ভেড়া এবং এক ঘুঘু ও এক পায়রার বাচ্চা আমার কাছে আন।” ");
INSERT INTO benirv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","পরে তিনি ঐ সব তাঁর কাছে এনে দুটো করে টুকরো করলেন এবং এক এক টুকরোর আগে অন্য অন্য টুকরো রাখলেন, কিন্তু পাখিদেরকে দুই টুকরো করলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","পরে হিংস্র পাখিরা সেই মৃত পশুদের ওপরে পড়লে অব্রাম তাদেরকে তাড়িয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","পরে সূর্য্য অস্ত যাবার দিনের অব্রাম গভীরভাবে ঘুমিয়ে পড়লেন; আর দেখ, তিনি ভয়ে ও ভয়ঙ্কার অন্ধকারে মগ্ন হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","তখন তিনি অব্রামকে বললেন, নিশ্চয় জেনো, তোমার বংশধরেরা পরদেশে প্রবাসী থাকবে এবং বিদেশী লোকদের দাসত্ব করবে ও লোকে তাদেরকে চারশো বছর পর্যন্ত দুঃখ দেবে; ");
INSERT INTO benirv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","আবার তারা যে জাতির দাস হবে, আমিই তাঁর বিচার করব; তারপরে তাঁরা যথেষ্ট সম্পত্তি নিয়ে বের হবে। ");
INSERT INTO benirv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","আর তুমি শান্তিতে নিজের পূর্বপুরুষদের কাছে যাবে ও ভালোভাবে বৃদ্ধ অবস্থায় কবর প্রাপ্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","আর তোমার বংশের চতুর্থ পুরুষ এই দেশে ফিরে আসবে; কারণ ইমোরীয়দের অপরাধ এখনও সম্পূর্ণ হয়নি। ");
INSERT INTO benirv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","পরে সূর্য্য অস্ত হলে ও অন্ধকার হলে দেখ, ধোঁয়াযুক্ত উনুন ও জলন্ত বাতি ঐ দুটি টুকরোর মধ্য দিয়ে চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","সেই দিন সদাপ্রভু অব্রামের সঙ্গে নিয়ম স্থির করে বললেন, “আমি মিশরের নদী থেকে মহানদী, ফরাৎ নদী পর্যন্ত এই দেশ তোমার বংশকে দিলাম; ");
INSERT INTO benirv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","কেনিয়, কনিষীয়, কদমোনীয়, ");
INSERT INTO benirv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","হিত্তীয়, পরিষীয়, রফারীয়, ");
INSERT INTO benirv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ইমোরীয়, কনানীয়, গির্গাশীয় ও যিবুষীয় লোকদের দেশ দিলাম।” ");
INSERT INTO benirv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","অব্রামের স্ত্রী সারী নিঃসন্তানা ছিলেন এবং হাগার নামে তাঁর এক মিশরীয় দাসী ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","তাতে সারী অব্রামকে বললেন, “দেখ, সদাপ্রভু আমাকে বন্ধ্যা করেছেন; অনুরোধ করি, তুমি আমার দাসীর কাছে যাও; কি জানি, এর দ্বারা আমি সন্তান লাভ করতে পারব।” তখন অব্রাম সারীর বাক্যে রাজি হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","এই ভাবে কনান দেশে অব্রাম দশ বছর বাস করলে পর অব্রামের স্ত্রী সারী নিজের দাসী মিশরীয় হাগারকে নিয়ে নিজের স্বামী অব্রামের সঙ্গে বিবাহ দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","পরে অব্রাম হাগারের কাছে গেলে সে গর্ভবতী হল এবং নিজের গর্ভ হয়েছে দেখে নিজ কর্ত্রীকে তুচ্ছ জ্ঞান করতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","তাতে সারী অব্রামকে বললেন, “আমার উপরে করা এই অন্যায় তোমার উপরেই ফলুক; আমিই নিজের দাসীকে তোমার হাতে দিয়েছিলাম, সে নিজেকে গর্ভবতী দেখে আমাকে তুচ্ছজ্ঞান করছে; সদাপ্রভুই তোমার ও আমার বিচার করুন!” ");
INSERT INTO benirv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","তখন অব্রাম সারীকে বললেন, “দেখ, তোমার দাসী তোমারই হাতে; তোমার যা ভাল মনে হয়, তার প্রতি তাই কর।” তাতে সারী হাগারকে দুঃখ দিলেন, আর সে তাঁর কাছ থেকে পালিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","পরে সদাপ্রভুর দূত মরুপ্রান্তের মধ্যে এক জলের উনুইয়ের কাছে, শুরের পথে যে উনুই আছে, ");
INSERT INTO benirv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","তার কাছে তাকে পেয়ে বললেন, “হে সারীর দাসী হাগার, তুমি কোথা থেকে আসলে? এবং কোথায় যাবে?” তাতে সে বলল, “আমি নিজের কর্ত্রী” ");
INSERT INTO benirv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","সারীর কাছ থেকে পালাচ্ছি। তখন সদাপ্রভুর দূত তাকে বললেন, “তুমি নিজের কর্ত্রীর কাছে ফিরে যাও এবং নিজেকে সমর্পণ করে তার অধীনে থাক।” ");
INSERT INTO benirv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","সদাপ্রভুর দূত তাকে আরও বললেন, “আমি তোমার বংশের এমন বৃদ্ধি করব যে, গণনা করা যাবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","সদাপ্রভুর দূত তাকে আরও বললেন, “দেখ, তোমার গর্ভ হয়েছে, তুমি ছেলে জন্ম দেবে ও তার নাম ইশ্মায়েল ঈশ্বর শুনেন রাখবে, কারণ সদাপ্রভু তোমার দুঃখ শুনলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","আর সে বন্য গাধার মতো মানুষ হবে; তার হাত সবার বিরুদ্ধ ও সবার হাত তার বিরুদ্ধ হবে; সে তার সব ভাইদের সামনে বাস করবে। ");
INSERT INTO benirv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","পরে হাগার, যিনি তার সঙ্গে কথা বললেন, “সেই সদাপ্রভুর এই নাম রাখল, তুমি দর্শনকারী ঈশ্বর;” কারণ সে বলল, “যিনি আমাকে দেখেন, আমি কি এই জায়গাতেই তাঁর দর্শন করেছি?” ");
INSERT INTO benirv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","এই কারণে সেই কূপের নাম বের-লহয়-রয়ী হল; দেখ, তা কাদেশ ও বেরদের মধ্যে রয়েছে। ");
INSERT INTO benirv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","পরে হাগার অব্রামের জন্য ছেলের জন্ম দিল; আর অব্রাম হাগারের গর্ভে জন্মানো নিজের সেই ছেলের নাম ইশ্মায়েল রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","অব্রামের ছিয়াশি বছর বয়সে হাগার অব্রামের জন্য ইশ্মায়েলকে জন্ম দিল। ");
INSERT INTO benirv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","অব্রামের নিরানব্বই বছর বয়সে সদাপ্রভু তাঁকে দর্শন দিলেন ও বললেন, “আমিই সর্বশক্তিমান ঈশ্বর, তুমি আমার সামনে যাতায়াত করে সিদ্ধ হও। ");
INSERT INTO benirv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","আর আমি তোমার সঙ্গে নিজের নিয়ম স্থির করব ও তোমার প্রচুর পরিমাণে বংশ বৃদ্ধি করব।” ");
INSERT INTO benirv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","তখন অব্রাম উপুড় হয়ে পড়লেন এবং ঈশ্বর তাঁর সঙ্গে আলাপ করে বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“দেখ, আমিই তোমার সঙ্গে নিজের নিয়ম স্থির করছি, তুমি বহু জাতির আদিপিতা হবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","তোমার নাম অব্রাম আর থাকবে না, কিন্তু তোমার নাম অব্রাহাম হবে; কারণ আমি তোমাকে বহু জাতির আদিপিতা করলাম। ");
INSERT INTO benirv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","আমি তোমাকে অত্যাধিক পরিমাণে ফলবান করব এবং তোমার থেকে বহুজাতি সৃষ্টি করব; আর রাজারা তোমার থেকে সৃষ্টি হবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","আমি তোমার সঙ্গে ও পুরুষানুক্রমে তোমার ভাবী বংশের সঙ্গে যে নিয়ম স্থাপন করব, তা চিরকালের নিয়ম হবে; কারণ আমি তোমার ঈশ্বর ও তোমার ভাবী বংশের ঈশ্বর হব। ");
INSERT INTO benirv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","আর তুমি এই যে কনান দেশে বাস করছ, এর সম্পূর্ণ আমি তোমাকে ও তোমার ভাবী বংশকে চিরস্থায়ী অধিকারের জন্য দেব, আর আমি তাদের ঈশ্বর হব।” ");
INSERT INTO benirv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ঈশ্বর অব্রাহামকে আরও বললেন, “তুমিও আমার নিয়ম পালন করবে; তুমি ও তোমার ভাবী বংশ পুরুষানুক্রমে তা পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","তোমাদের সঙ্গে ও তোমার ভাবী বংশের সঙ্গে করা আমার যে নিয়ম তোমরা পালন করবে, তা এই, তোমাদের প্রত্যেক পুরুষের ত্বকছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","তোমরা নিজের নিজের লিঙ্গের মুখের চামড়া কাটবে; সেটাই তোমাদের সঙ্গে আমার নিয়মের চিহ্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","পুরুষানুক্রমে তোমার প্রত্যেক ছেলে সন্তানের আট দিন বয়সে ত্বকছেদ হবে এবং যারা তোমার বংশ নয়, এমন অইহুদীয়দের মধ্যে তোমাদের বাড়িতে জন্মানো কিম্বা মূল্য দিয়ে কেনা লোকেদেরও ত্বকছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","তোমার গৃহ জন্মানো কিম্বা মূল্য দিয়ে কেনা লোকের ত্বকছেদ অবশ্য কর্তব্য; আর তোমাদের মাংসে অবস্থিত আমার নিয়ম চিরকালের নিয়ম হবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","কিন্তু যার লিঙ্গের ত্বকছেদ না হবে, এমন ত্বকছেদ বিহীন পুরুষ নিজের লোকেদের মধ্য থেকে বিতাড়িত হবে; সে আমার নিয়ম ভঙ্গ করেছে।” ");
INSERT INTO benirv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","আর ঈশ্বর অব্রাহামকে বললেন, “তুমি তোমার স্ত্রী সারীকে আর সারী বলে ডেকো না; তার নাম সারা রাণী হল। ");
INSERT INTO benirv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","আর আমি তাকে আশীর্বাদ করব এবং তা থেকে এক ছেলেও তোমাকে দেব; আমি তাকে আশীর্বাদ করব, তাকে সে জাতির আদি-মা করা হবে, তা থেকে লোকদের রাজারা সৃষ্টি হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","তখন অব্রাহাম উপুড় হয়ে পড়ে হাঁসলেন, মনে মনে বললেন, “একশো বছর বয়ষ্ক পুরুষের কি সন্তান হবে? আর নব্বই বছর বয়ষ্কা সারা কি প্রসব করবে?” ");
INSERT INTO benirv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","পরে অব্রাহাম ঈশ্বরকে বললেন, “ইশ্মায়েলই তোমার সামনে বেঁচে থাকুক।” ");
INSERT INTO benirv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","তখন ঈশ্বর বললেন, “তোমার স্ত্রী সারা অবশ্য তোমার জন্য ছেলে প্রসব করবে এবং তুমি তার নাম ইসহাক হাস্য রাখবে, আর আমি তার সঙ্গে আমার নিয়ম স্থাপন করব, তা তার আগামী বংশধরদের পক্ষে চিরস্থায়ী নিয়ম হবে। ");
INSERT INTO benirv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","আর ইস্মায়েলের বিষয়েও তোমার প্রার্থনা শুনলাম; দেখ, আমি তাকে আশীর্বাদ করলাম এবং তাকে ফলবান করে তার প্রচুর পরিমাণে বংশ বৃদ্ধি করব; তা থেকে বারোটি রাজা সৃষ্টি হবে ও আমি তাকে বড় জাতি করব। ");
INSERT INTO benirv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","কিন্তু আগামী বছরের এই ঋতুতে সারা তোমার জন্য যাকে প্রসব করবে, সেই ইসহাকের সঙ্গে আমি আমার নিয়ম স্থাপন করব।” ");
INSERT INTO benirv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","পরে কথোপকথন শেষ করে ঈশ্বর অব্রাহামের কাছ থেকে উপরে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","পরে অব্রাহাম আপন ছেলে। ইশ্মায়েলকে ও নিজের গৃহে জন্মানো ও মূল্য দিয়ে কেনা সমস্ত লোককে, অব্রাহামের গৃহে যত পুরুষ ছিল, সেই সকলকে নিয়ে ঈশ্বরের আজ্ঞানুসারে সেই দিনের তাদের লিঙ্গের মুখের চামড়া কাটলেন। ");
INSERT INTO benirv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","অব্রাহামের লিঙ্গের মুখের চামড়া কাটার দিনের তাঁর বয়স নিরানব্বই বছর। ");
INSERT INTO benirv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","আর তাঁর ছেলে ইস্মায়েলের লিঙ্গের মুখের চামড়া কাটার দিনের তাঁর বয়স তের বছর। ");
INSERT INTO benirv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","সেই দিনের ই অব্রাহাম ও তাঁর ছেলে ইস্মায়েল, উভয়ের ত্বকছেদ হল। ");
INSERT INTO benirv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","আর তাঁর গৃহে জন্মানো এবং অইহুদীয়দের কাছে মূল্য দিয়ে কেনা তাঁর গৃহের সব পুরুষেরও ত্বকছেদ সেই দিনের হল। ");
INSERT INTO benirv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","পরে সদাপ্রভু মম্রির এলোন বনের কাছে তাঁকে দর্শন দিলেন। তিনি দিনের গরমের দিনের তাঁবুর দুয়ারের মুখে বসেছিলেন; চোখ তুলে দেখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","আর দেখ, তিনটে পুরুষ সামনে দাঁড়িয়ে ছিল। দেখতে পাওয়ার সঙ্গে সঙ্গেই তিনি তাঁবুর দুয়ারের মুখে থেকে তাঁদের কাছে দৌড়ে গিয়ে মাটিতে প্রণাম করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","তিনি বললেন, “হে প্রভু, অনুরোধ করি, যদি আমি আপনার দৃষ্টিতে অনুগ্রহের পাত্র হয়ে থাকি, তবে আপনার এই দাসের কাছ থেকে যাবেন না। ");
INSERT INTO benirv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","অনুরোধ করি, অল্প জল এনে দিই, আপনারা পা ধুয়ে এই গাছের তলায় বিশ্রাম করুন। ");
INSERT INTO benirv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","কিছু খাবার এনে দিই, তা দিয়ে প্রাণ তৃপ্ত করুন, পরে নিজের পথে এগিয়ে যাবেন; কারণ এরই জন্য নিজের দাসের কাছে এসেছেন।” তখন তাঁরা বললেন, “যা বললে, তাই কর।” ");
INSERT INTO benirv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","তাতে অব্রাহাম তাড়াতাড়ি করে তাঁবুতে সারার কাছে গিয়ে বললেন, “শীঘ্র 21 কিলো উত্তম ময়দা নিয়ে মেখে গোলা বানিয়ে রুটি তৈরী কর।” ");
INSERT INTO benirv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","পরে অব্রাহাম দৌড়িয়ে গিয়ে পশুপাল থেকে উৎকৃষ্ট কোমল এক বাছুর নিয়ে দাসকে দিলে সে তা তাড়াতাড়ি রান্না করল। ");
INSERT INTO benirv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","তখন তিনি দই, দুধ ও রান্না মাংস নিয়ে তাঁদের সামনে দিলেন এবং তাঁদের কাছে বৃক্ষ তলায় দাঁড়ালেন ও তাঁরা ভোজন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","আর তাঁরা তাঁকে জিজ্ঞাসা করলেন, “তোমার স্ত্রী সারা কোথায়?” তিনি বললেন, “দেখুন, তিনি তাঁবুতে আছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","তিনি বললেন, “বসন্তকালে আমি অবশ্যই তোমার কাছে ফিরে আসব; আর দেখ, তোমার স্ত্রী সারার এক ছেলে হবে।” এই কথা সারা দরজার পিছনে থেকে শুনলেন। ");
INSERT INTO benirv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","সেই দিনের অব্রাহাম ও সারা অনেক বয়ষ্ক ছিলেন; সারার সন্তান প্রসব করার বয়স পার হয়ে গিয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","অতএব সারা নিজে মনে মনে হেঁসে বললেন, “আমার এই শীর্ণ দশার পরে কি এমন আনন্দ হবে? আমার প্রভুও তো বৃদ্ধ।” ");
INSERT INTO benirv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","তখন সদাপ্রভু অব্রাহামকে বললেন, “সারা কেন এই বলে হাঁসলো যে, ‘আমি কি সত্যই প্রসব করব, আমি যে বুড়ী?’ কোন কাজ কি সদাপ্রভুর অসাধ্য? ");
INSERT INTO benirv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","সঠিক দিনের এই ঋতু আবার উপস্থিত হলে আমি তোমার কাছে ফিরে আসব, আর সারার ছেলে হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","তাতে সারা অস্বীকার করে বললেন, “আমি হাঁসিনি; কারণ তিনি ভয় পেয়েছিলেন।” তিনি বললেন, “না, অবশ্যই হেঁসেছিলে।” ");
INSERT INTO benirv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","পরে সেই ব্যক্তিরা সেখান থেকে উঠে সদোমের দিকে দেখলেন, আর অব্রাহাম তাঁদেরকে বিদায় দিতে তাঁদের সঙ্গে সঙ্গে চললেন। ");
INSERT INTO benirv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","কিন্তু সদাপ্রভু বললেন, “আমি যা করব, তা কি অব্রাহাম থেকে লুকাব? ");
INSERT INTO benirv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","অব্রাহাম থেকে মহান ও বলবান এক জাতি সৃষ্টি হবে এবং পৃথিবীর যাবতীয় জাতি তাতেই আশীর্বাদ প্রাপ্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","কারণ আমি তাকে জানিয়েছি, যেন সে নিজের ভাবী সন্তানদের ও পরিবারদেরকে আদেশ করে, যেন তারা ধার্ম্মিকতায় ও ন্যায্য আচরণ করতে করতে সদাপ্রভুর পথে চলে; এই ভাবে সদাপ্রভু যেন অব্রাহামের বিষয়ে কথিত নিজের বাক্য সফল করেন।” ");
INSERT INTO benirv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","পরে সদাপ্রভু বললেন, “কারণ সদোমের ও ঘমোরার কান্না অত্যন্ত বেশি এবং তাদের পাপ অতিশয় ভারী; ");
INSERT INTO benirv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","আমি নীচে গিয়ে দেখব, আমার কাছে আসা কান্না অনুসারে তারা সম্পূর্ণরূপে করেছে কি না; যদি না করে থাকে, তা জানব।” ");
INSERT INTO benirv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","পরে সেই ব্যক্তিরা সেখান থেকে ফিরে সদোমের দিকে গেলেন; কিন্তু অব্রাহাম তখনও সদাপ্রভুর সামনে দাঁড়িয়ে থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","পরে অব্রাহাম কাছে গিয়ে বললেন, “আপনি কি দুষ্টের সঙ্গে ধার্মিককেও ধ্বংস করবেন? ");
INSERT INTO benirv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","সেই নগরের মধ্যে যদি পঞ্চাশ জন ধার্মিক পাওয়া যায়, তবে আপনি কি সেখানকার পঞ্চাশ জন ধার্ম্মিকের অনুরোধে সেই জায়গার প্রতি দয়া না করে তা বিনষ্ট করবেন? ");
INSERT INTO benirv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","দুষ্টের সঙ্গে ধার্ম্মিককে ধ্বংস করা, এই রকম কাজ আপনার থেকে দূরে থাকুক; ধার্ম্মিককে দুষ্টের সমান করা আপনার কাছ থেকে দূর থাকুক। সমস্ত পৃথিবীর বিচারকর্ত্তা কি ন্যায়বিচার করবেন না?” ");
INSERT INTO benirv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","সদাপ্রভু বললেন, “আমি যদি সদোমের মধ্যে পঞ্চাশ জন ধার্মিক দেখি, তবে তাদের অনুরোধে সেই সমস্ত জায়গার প্রতি দয়া করব।” ");
INSERT INTO benirv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","অব্রাহাম উত্তর করে বললেন, “দেখুন, ধূলো ও ছাইমাত্র যে আমি, আমি প্রভুর সঙ্গে কথা বলতে সাহসী হয়েছি! ");
INSERT INTO benirv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","কি জানি, পঞ্চাশ জন ধার্ম্মিকের পাঁচ জন কম হবে; সেই পাঁচ জনের অভাবের জন্য আপনি কি সমস্ত নগর ধ্বংস করবেন?” তিনি বললেন, “সেই জায়গায় পঁয়তাল্লিশ জন পেলে আমি তা বিনষ্ট করব না।” ");
INSERT INTO benirv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","তিনি তাঁকে আবার বললেন, “সেই জায়গায় যদি চল্লিশ জন পাওয়া যায়?” তিনি বললেন, “সেই চল্লিশ জনের জন্য তা করব না।” ");
INSERT INTO benirv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","আবার তিনি বললেন, “প্রভু বিরক্ত হবেন না, আমি আরও বলি; যদি সেখানে ত্রিশ জন পাওয়া যায়?” তিনি বললেন, “সেখানে ত্রিশ জন পেলে তা করব না।” ");
INSERT INTO benirv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","তিনি বললেন, “দেখুন, প্রভুর কাছে আমি সাহসী হয়ে আবার বলি, যদি সেখানে কুড়ি জন পাওয়া যায়?” তিনি বললেন, “সেই কুড়ি জনের অনুরোধে তা বিনষ্ট করব না।” ");
INSERT INTO benirv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","তিনি বললেন, “প্রভু রাগ করবেন না। আমি শুধু মাত্র আর একবার বলব; যদি সেখানে দশ জন পাওয়া যায়?” তিনি বললেন, “সেই দশ জনের অনুরোধে তা ধ্বংস করব না।” ");
INSERT INTO benirv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","তখন সদাপ্রভু অব্রাহামের সঙ্গে কথাবার্তা শেষ করে চলে গেলেন এবং অব্রাহাম নিজের জায়গায় ফিরে এলেন। ");
INSERT INTO benirv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","পরে সন্ধ্যাবেলায় ঐ দুই দূত সদোমে এলেন। তখন লোট সদোমের দরজার কাছে বসেছিলেন, আর তাঁদেরকে দেখে তাঁদের কাছে যাবার জন্য উঠলেন এবং মাটিতে মুখ দিয়ে প্রণাম করলেন ");
INSERT INTO benirv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","তিনি বললেন, “হে আমার প্রভুরা, দেখুন, অনুরোধ করি, আপনাদের এই দাসের বাড়িতে প্রবেশ করুন, রাতে থাকুন ও আপনার পা ধুয়ে নিন; পরে সকালে উঠে নিজের যাত্রায় এগিয়ে যাবেন।” এবং তাঁরা বললেন, “না, আমরা চকেই রাত কাটাব।” ");
INSERT INTO benirv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","কিন্তু লোট অতিরিক্ত আগ্রহ দেখাবার পর, তাঁরা তাঁর সঙ্গে গেলেন ও তাঁর বাড়িতে প্রবেশ করলেন; তাতে তিনি তাঁদের জন্য খাবার তৈরী করলেন ও তাড়ীশূন্য রুটি তৈরী করলেন, আর তাঁরা ভোজন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","পরে তাঁদের শোয়ার আগে ঐ নগরের পুরুষেরা, সদোমের যুবক ও বৃদ্ধ সমস্ত লোক চারদিক থেকে এসে তাঁর বাড়ি ঘিরে ফেলল ");
INSERT INTO benirv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","তারা লোটকে ডেকে বলল, “আজ রাত্রে যে দুজন লোক তোমার বাড়িতে আসল, তারা কোথায়? তাদেরকে বার করে আমাদের কাছে আন, আমরা তাদের পরিচয় নেব।” ");
INSERT INTO benirv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","তখন লোট ঘরের দরজার বাইরে তাদের কাছে এসে নিজে পেছনের দরজা বন্ধ করলেন ");
INSERT INTO benirv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","তিনি বললেন, “ভাই সব, অনুরোধ করি, এমন খারাপ ব্যবহার কর না। ");
INSERT INTO benirv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","দেখ, পুরুষের পরিচয় পায়নি এমন যুবতী আমার দুটি মেয়ে আছে, তাদেরকে তোমাদের কাছে আনি, তোমাদের দৃষ্টিতে যা ভাল, তা কর, কিন্তু সেই ব্যক্তিদের প্রতি কিছুই কর না, কারণ এই দিনের তাঁরা আমার বাড়ির ছায়ায় আশ্রয় নিলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","তখন তারা বলল, “সরে যা!” তারা আরও বলল, “একজন বিদেশী হিসাবে এখানে বাস করতে এসে এখন এ আমাদের বিচারকর্ত্তা হল; এখন তাদের থেকে তোর প্রতি আরও খারাপ ব্যবহার করব।” তারা লোটের ওপরে চাপ দিতে লাগল এবং তারা দরজা ভাঙ্গতে কাছে এল। ");
INSERT INTO benirv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","তখন সেই দুই ব্যক্তি হাত বাড়িয়ে লোটকে ঘরের মধ্যে নিজেদের কাছে টেনে নিয়ে দরজা বন্ধ করলেন; ");
INSERT INTO benirv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","এবং বাড়ির দরজার কাছে ছোট কি বড় সব লোককে অন্ধতায় আহত করলেন; তাতে তারা দরজা খুঁজতে খুঁজতে পরিশ্রান্ত হল। ");
INSERT INTO benirv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","পরে সেই ব্যক্তিরা লোটকে বললেন, “এই জায়গায় তোমার আর কে কে আছে? তোমার জামাই ও ছেলে মেয়ে যত জন এই নগরে আছে, সে সকলকে এই জায়গা থেকে নিয়ে যাও। ");
INSERT INTO benirv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","কারণ আমরা এই জায়গা ধ্বংস করব; কারণ সদাপ্রভুর সামনে এই লোকদের বিপরীতে ভীষণ কান্নার আওয়াজ উঠেছে, তাই সদাপ্রভু এটা ধ্বংস করতে আমাদেরকে পাঠিয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","তখন লোট বাইরে গিয়ে, যারা তাঁর মেয়েদেরকে বিয়ে করেছিল, নিজের সেই জামাইদেরকে বললেন, “তাড়াতাড়ি ওঠ, এ জায়গা থেকে বেরিয়ে যাও, কারণ সদাপ্রভু এই নগর ধ্বংস করবেন।” কিন্তু তাঁর জামাইরা তাঁকে উপহাসকারী বলে মনে করল। ");
INSERT INTO benirv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","যখন প্রভাত হল সেই দূতেরা লোটকে তাড়াতাড়ি বললেন, “ওঠ, তোমার স্ত্রীকে ও এই যে মেয়ে দুটি এখানে আছে, এদেরকে নিয়ে যাও, যদি তোমরা নগরের অপরাধে বিনষ্ট হও।” ");
INSERT INTO benirv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","কিন্তু তিনি এদিক-ওদিক করতে লাগলেন; তাতে তাঁর প্রতি সদাপ্রভুর স্নেহের জন্য সেই ব্যক্তিরা তাঁর ও তাঁর স্ত্রীর ও মেয়ে দুটির হাত ধরে শহরের বাইরে নিয়ে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","যখন তাদেরকে বের করে তিনি লোটকে বললেন, “প্রাণরক্ষার জন্য পালিয়ে যাও! পিছন দিকে দেখ না; অথবা সমতলে যে কোনো জায়গায় থেকো না; পর্বতে পালিয়ে যাও, যাতে বিনষ্ট না হও।” ");
INSERT INTO benirv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","লোট তাঁদেরকে বললেন, “হে আমার প্রভু, এমন না হোক। ");
INSERT INTO benirv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","দেখুন, আপনার দাস আপনার কাছে অনুগ্রহ প্রাপ্ত হয়েছে; আমার প্রাণরক্ষা করাতে আপনি আমার প্রতি আপনার মহাদয়া প্রকাশ করেছেন; কিন্তু আমি পর্বতে পালাতে পারি না; কি জানি, সেই বিপদ এসে পড়লে আমিও মরব। ");
INSERT INTO benirv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","দেখুন, পালানোর জন্য ঐ শহর কাছাকাছি, ওটা ছোট; ওখানে পালাবার অনুমতি দিন, তা হলে আমার প্রাণ বাঁচবে; ওটা কি ছোট না?” ");
INSERT INTO benirv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","তিনি বললেন, “ভাল, আমি এ বিষয়েও তোমার প্রতি অনুগ্রহ করছি, ঐ যে নগরের কথা বললে, ওটা ধ্বংস করব না। ");
INSERT INTO benirv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","তাড়াতাড়ি! ঐ জায়গায় পালিয়ে যাও, কারণ তুমি ঐ জায়গায় না পৌঁছালে আমি কিছু করতে পারি না।” এই জন্য সেই জায়গার নাম সোয়র অর্থাৎ ক্ষুদ্র হল। ");
INSERT INTO benirv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","দেশের উপর সূর্য্য উদিত হলে লোট সোয়রে প্রবেশ করলেন, ");
INSERT INTO benirv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","এমন দিনের সদাপ্রভু নিজের কাছ থেকে, আকাশ থেকে, সদোমের ও ঘমোরার ওপরে গন্ধক ও আগুন বর্ষণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","সেই সব নগর, সমস্ত অঞ্চল নগরবাসী সব লোক ও সেই ভূমিতে উত্পন্ন সমস্ত বস্তু ধ্বংস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","কিন্তু লোটের স্ত্রী, যে তাঁর পিছনে ছিল, সে পিছনের দিকে তাকাল এবং লবণস্তম্ভ হয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","আর অব্রাহাম খুব সকালে ঘুম থেকে উঠলেন এবং সেই জায়গায় গেলেন, আগে যে জায়গায় সদাপ্রভু দাঁড়িয়ে ছিলেন ");
INSERT INTO benirv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","সদোম ও ঘমোরার দিকে ও সেই অঞ্চলের সব ভূমির দিকে চেয়ে দেখলেন, আর দেখ, ভাটির ধোঁয়ার মতো সেই দেশের থেকে ধোঁয়া উঠছে। ");
INSERT INTO benirv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","এই ভাবে সেই অঞ্চলে অবস্থিত সমস্ত নগরের ধ্বংসের দিনের ঈশ্বর অব্রাহামকে স্মরণ করলেন। যে যে নগরে লোট বাস করতেন, সেই সেই নগরের ধ্বংসের দিনের ধ্বংসের মধ্য থেকে লোটকে পাঠালেন। ");
INSERT INTO benirv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","পরে লোট ও তাঁর দুটি মেয়েকে নিয়ে সোয়র থেকে পর্বতে উঠে গিয়ে সেখানে থাকলেন; কারণ তিনি সোয়রে বাস করতে ভয় পেলেন আর তিনি ও তাঁর সেই দুই মেয়ে গুহার মধ্যে বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","পরে তাঁর বড় মেয়ে ছোট মেয়েকে বলল, “আমাদের বাবা বৃদ্ধ এবং জগৎ সংসারের ব্যবহার অনুসারে আমাদের সঙ্গে সম্পর্ক স্থাপন করতে এ দেশে কোন পুরুষ নেই; ");
INSERT INTO benirv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","এস, আমরা বাবাকে আঙ্গুর রস পান করিয়ে তাঁর সঙ্গে শয়ন করি, এই ভাবে আমরা বাবার বংশ বৃদ্ধি করি।” ");
INSERT INTO benirv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","তাতে তারা সেই রাতে নিজেদের বাবাকে আঙ্গুর রস পান করাল, পরে তাঁর বড় মেয়ে বাবার সঙ্গে শয়ন করতে গেল; তাঁর শয়ন করা ও উঠে যাওয়া লোট টের পেলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","আর পরদিন বড় মেয়েটি ছোট মেয়েটিকে বলল, “দেখ, গত রাতে আমি বাবার সঙ্গে শয়ন করেছিলাম; এস, আমরা আজ রাতেও বাবাকে আঙ্গুর রস পান করাই; পরে তুমি গিয়ে তাঁর সঙ্গে শয়ন কর, এই ভাবে বাবার বংশ রক্ষা করব।” ");
INSERT INTO benirv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","এই ভাবে তারা সেই রাতেও বাবাকে আঙ্গুর রস পান করাল; পরে ছোট মেয়ে উঠে গিয়ে তাঁর সঙ্গে শয়ন করল; তার শয়ন করা ও উঠে যাওয়া লোট টের পেলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","এই ভাবে লোটের দুটি মেয়েই নিজেদের বাবা থেকে গর্ভবতী হল। ");
INSERT INTO benirv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","পরে বড় মেয়ে ছেলের জন্ম দিয়ে তার নাম মোয়াব রাখল; সে এখনকার মোয়াবীয়দের আদিপিতা। ");
INSERT INTO benirv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","আর ছোট মেয়েটিও ছেলের জন্ম দিয়ে তার নাম বিন–অম্মি রাখল, সে এখনকার অম্মোন-লোকদের আদিবাবা। ");
INSERT INTO benirv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","আর অব্রাহাম সেখান থেকে দক্ষিণ দেশে যাত্রা করে কাদেশ ও শূরের মাঝখানে থাকলেন ও গবারে বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","আর অব্রাহাম নিজের স্ত্রী সারার বিষয়ে বললেন, “এ আমার বোন” তাতে গবারের রাজা অবীমেলক লোক পাঠিয়ে সারাকে গ্রহণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","কিন্তু রাতে ঈশ্বর স্বপ্নে অবীমেলকের কাছে এসে বললেন, “দেখ, ঐ যে নারীকে গ্রহণ করেছ, তার জন্য তোমার মৃত্যু হবে, কারণ সে একজন লোকের স্ত্রী।” ");
INSERT INTO benirv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","তখন অবীমেলক তাঁর কাছে যাননি; তাই তিনি বললেন, “প্রভু, যে জাতি নির্দোষ, তাকেও কি আপনি হত্যা করবেন?” ");
INSERT INTO benirv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","সেই ব্যক্তি কি আমাকে বলেনি, এ আমার বোন? এবং সেই স্ত্রীও কি বলেনি, এ আমার ভাই? আমি যা করেছি, তা হৃদয়ের সরলতায় ও হাতের নির্দোষতায় করেছি। ");
INSERT INTO benirv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","তখন ঈশ্বর স্বপ্নে তাঁকে বললেন, “তুমি হৃদয়ের সরলতায় এ কাজ করেছ, তা আমিও জানি এবং আমার বিরুদ্ধে পাপ করতে আমি তোমাকে বারণ করলাম; এই জন্য তাকে স্পর্শ করতে দিলাম না। ");
INSERT INTO benirv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","অতএব, সেই ব্যক্তির স্ত্রীকে ফিরিয়ে দাও, কারণ সে ভাববাদী; আর সে তোমার জন্য প্রার্থনা করবে, তাতে তুমি বাঁচবে; কিন্তু যদি তাকে ফিরিয়ে না দাও, তবে এটা জেনে রাখ, তুমি ও তোমরা সকলেই নিশ্চয় মরবে।” ");
INSERT INTO benirv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","অবীমেলক খুব সকালে উঠে নিজের সব দাসকে ডেকে ঐ সমস্ত বিবরণ তাদেরকে বললেন; তাতে তারা খুব ভয় পেল। ");
INSERT INTO benirv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","পরে অবীমেলক অব্রাহামকে ডেকে বললেন, “আপনি আমাদের সঙ্গে এ কি ব্যবহার করলেন? আমি আপনার কাছে কি দোষ করেছি যে আপনি আমাকে ও আমার রাজ্যকে এমন মহাপাপগ্রস্ত করলেন? আপনি আমার প্রতি অনুচিত কাজ করলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","অবীমেলক অব্রাহামকে বললেন, “আপনি কি দেখেছিলেন যে, এমন কাজ করলেন?” ");
INSERT INTO benirv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","তখন অব্রাহাম বললেন, “আমি ভেবেছিলাম, এই জায়গায় নিশ্চয় ঈশ্বর ভয় নেই, তাই এরা হয়তো আমার স্ত্রীর লোভে আমাকে হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","আর সে অবশ্যই আমার বোন, সে আমার বাবার মেয়ে কিন্তু মায়ের নয়, পরে আমার স্ত্রী হল। ");
INSERT INTO benirv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","যখন ঈশ্বর আমাকে বাবার বাড়ি ছেড়ে যেতে বলেছিলেন তখন আমি তাকে বলেছিলাম, তুমি আমার প্রতি তোমার এই দয়া করতে হবে, আমরা যে সমস্ত জায়গায় যাব আমার সম্মন্ধে বলবে, এ আমার ভাই।” ");
INSERT INTO benirv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","তখন অবীমেলক ভেড়া, গরু ও দাস দাসী এনে অব্রাহামকে দান করলেন এবং তাঁর স্ত্রী সারাকেও ফিরিয়ে দিলেন; ");
INSERT INTO benirv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","অবীমেলক বললেন, “দেখুন, আমার দেশ আপনার সামনে আছে আপনার যেখানে ইচ্ছা সেখানে বাস করুন।” ");
INSERT INTO benirv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","আর তিনি সারাকে বললেন, “দেখুন, আমি আপনার ভাইকে হাজার টুকরো রূপা দিলাম; দেখুন, আপনার সঙ্গী সকলের কাছে তা আপনার চোখের আবরণ স্বরূপ; সব বিষয়ে আপনার বিচার নিষ্পত্তি হল।” ");
INSERT INTO benirv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","পরে অব্রাহাম ঈশ্বরের কাছে প্রার্থনা করলেন, আর ঈশ্বর অবীমেলককে ও তাঁর স্ত্রীকে ও তাঁর দাসীদেরকে সুস্থ করলেন; তাতে তারা প্রসব করল। ");
INSERT INTO benirv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","কারণ অব্রাহামের স্ত্রী সারার জন্য সদাপ্রভু অবীমেলকের পরিবারে সমস্ত গর্ভ রোধ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","সদাপ্রভু নিজের কথা অনুযায়ী সারার যত্ন নিলেন; সদাপ্রভু যা বলেছেন, সারার প্রতি তাই করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","সারা গর্ভবতী হয়ে ঈশ্বরের বলা নির্দিষ্ট দিনের অব্রাহামের বৃদ্ধ বয়সে তাঁর জন্য একটি ছেলের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","অব্রাহাম সারার গর্ভজাত নিজের ছেলের নাম ইস্‌হাক অর্থাৎ হাস্য, রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","পরে ঐ ছেলে ইস্‌হাকের আট দিন বয়সে অব্রাহাম ঈশ্বরের আজ্ঞানুসারে তাঁর ত্বকছেদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","যখন ইসহাকের জন্ম হয়, তখন অব্রাহামের একশো বছর বয়স ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","আর সারা বললেন, “ঈশ্বর আমাকে হাঁসালেন; যে কেউ এটা শুনবে, সে আমার সঙ্গে হাসবে।” ");
INSERT INTO benirv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","তিনি আরও বললেন, “সারা শিশুদেরকে স্তন পান করাবে, এমন কথা অব্রাহামকে কে বলতে পারত? কারণ আমি তাঁর বৃদ্ধ বয়সে তাঁর জন্য ছেলের জন্ম দিলাম!” ");
INSERT INTO benirv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","পরে বালকটি বড় হয়ে স্তন পান ত্যাগ করল এবং যে দিন ইস্‌হাক স্তন পান ত্যাগ করল, সেই দিন অব্রাহাম মহাভোজ প্রস্তুত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","আর মিস্রীয়া হাগার অব্রাহামের জন্য যে ছেলের জন্ম দিয়েছিল, সারা তাকে ঠাট্টা করতে দেখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","তাতে তিনি অব্রাহামকে বললেন, “তুমি ঐ দাসীকে ও ওর ছেলেকে তাড়িয়ে দাও; কারণ আমার ছেলে ইস্‌হাকের সঙ্গে ঐ দাসীর ছেলে উত্তরাধিকারী হবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","এই কথায় অব্রাহাম নিজের ছেলের কারণে অতি দুঃখিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","কিন্তু ঈশ্বর অব্রাহামকে বললেন, “ঐ বালকের কারণে ও তোমার ঐ দাসীর কারণে দুঃখিত হয়ো না; সারা তোমাকে যা বলছে, তার সেই কথা শোন; কারণ ইস্‌হাকের মাধ্যমে তোমার বংশ আখ্যাত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","আর ঐ দাসীর ছেলে থেকেও আমি এক জাতি তৈরী করব, কারণ সে তোমার বংশীয়।” ");
INSERT INTO benirv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","পরে অব্রাহাম ভোরবেলায় উঠে রুটি ও জলের থলি নিয়ে হাগারের কাঁধে দিয়ে ছেলেটিকে সমর্পণ করে তাকে বিদায় করলেন। তাতে সে চলে গিয়ে বের-শেবা মরুপ্রান্তে ঘুরে বেড়াল। ");
INSERT INTO benirv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","যখন থলির জল শেষ হল, তাতে সে এক ঝোপের নীচে ছেলেটিকে ফেলে রাখল; ");
INSERT INTO benirv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","তারপর সে তার কাছ থেকে কিছুটা দূরে গিয়ে বসল, কারণ সে বলল, “ছেলেটির মৃত্যু আমি দেখব না।” আর সে তার কাছ থেকে দূরে বসে উচ্চৈঃস্বরে কাঁদতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ঈশ্বর ছেলেটির বর শুনলেন; এবং ঈশ্বরের দূত আকাশ থেকে ডেকে হাগারকে বললেন, “হাগার, তোমার কি হল? ভয় কর না, ছেলেটি যেখানে আছে, ঈশ্বর সেখান থেকে তার রব শুনলেন; ");
INSERT INTO benirv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","তুমি ওঠ, ছেলেটিকে তোলো এবং তাকে উত্সাহ দাও; কারণ আমি তার মধ্যে দিয়ে এক মহাজাতি তৈরী করব।” ");
INSERT INTO benirv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","তখন ঈশ্বর তার চোখ খুলে দিলেন এবং সে এক জলের কুয়ো দেখতে পেল। সে সেখানে গিয়ে জলের থলিতে জল ভরে ছেলেটিকে পান করাল। ");
INSERT INTO benirv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","পরে ঈশ্বর ছেলেটির সঙ্গে ছিলেন এবং সে বড় হয়ে উঠল। সে মরুভূমি থেকে ধনুকধারী হয়ে উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","সে পারন প্রান্তরে বাস করল এবং তার মা তার বিয়ের জন্য মিশর দেশ থেকে একটি মেয়ে আনল। ");
INSERT INTO benirv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ঐ দিনের অবীমেলক এবং তাঁর সেনাপতি ফীখোল অব্রাহামকে বললেন, “আপনি যা কিছু করেন, সে সব কিছুতেই ঈশ্বর আপনার সঙ্গী।” ");
INSERT INTO benirv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","“অতএব আপনি এখন এই জায়গায় ঈশ্বরের দিব্যি করে আমাকে বলুন যে, আমার প্রতি ও আমার ছেলে ও বংশধরদের প্রতি বিশ্বাসঘাতকতা করবেন না; আমি আপনার যেমন চুক্তির প্রতি বিশ্বস্ততা করেছি, আপনিও আমার প্রতি ও আপনার বাসস্থান এই দেশের প্রতি সেরকম চুক্তির প্রতি বিশ্বস্ততা করবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","তখন অব্রাহাম বললেন, “শপথ করব।” ");
INSERT INTO benirv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","কিন্তু অবীমেলকের দাসেরা একটি জলপূর্ণ কূপ সবলে অধিকার করেছিল, এই জন্য অব্রাহাম অবীমেলককে অভিযোগ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","অবীমেলক বললেন, “এই কাজ কে করেছে, তা আমি জানি না; আপনিও আমাকে জানাননি এবং আমিও কেবল আজ এ কথা শুনলাম।” ");
INSERT INTO benirv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","পরে অব্রাহাম ভেড়া ও গরু নিয়ে অবীমেলককে দিলেন এবং উভয়ে একটি নিয়ম তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","আর অব্রাহাম পাল থেকে সাতটা বাচ্চা ভেড়া আলাদা করে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","অবীমেলক অব্রাহামকে জিজ্ঞাসা করলেন, “আপনি কি অর্থে এই সাত বাচ্চা ভেড়া আলাদা করে রাখলেন?” ");
INSERT INTO benirv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","তিনি বললেন, “আমি যে এই কুয়ো খুঁড়েছি, তাঁর প্রমাণের জন্য আমার থেকে এই সাত বাচ্চা ভেড়া আপনাকে গ্রহণ করতে হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","এজন্য তিনি সে জায়গার নাম বের-শেবা শপথের কুয়ো রাখলেন, কারণ সেই জায়গায় তাঁরা উভয়ে শপথ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","এই ভাবে তাঁরা বের-শেবাতে নিয়ম তৈরী করলেন এবং পরে অবীমেলক ও তাঁর সেনাপতি ফীখোল উঠে পলেষ্টীয়দের দেশে ফিরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","পরে অব্রাহাম বের-শেবায় ঝাউগাছ রোপণ করে সেই জায়গায় অনন্তকালস্থায়ী ঈশ্বর সদাপ্রভুর নামে উপাসনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","অব্রাহাম পলেষ্টীয়দের দেশে অনেক দিন বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","এই সব ঘটনার পরে ঈশ্বর অব্রাহামের পরীক্ষা করলেন। তিনি তাঁকে বললেন, “অব্রাহাম;” তিনি উত্তর করলেন, “এখানে আমি।” ");
INSERT INTO benirv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","তখন তিনি বললেন, “তুমি নিজের ছেলেকে, তোমার একমাত্র ছেলেকে, যাকে তুমি ভালবাস, সেই ইসহাককে নিয়ে মোরিয়া দেশে যাও এবং সেখানকার যে এক পর্বতের কথা আমি তোমাকে বলব, তার উপরে তাকে হোম বলির জন্য বলিদান কর।” ");
INSERT INTO benirv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","পরে অব্রাহাম ভোরবেলায় উঠে গাধা সাজিয়ে দুই জন দাস ও তাঁর ছেলে ইসহাককে সঙ্গে নিলেন, হোমের জন্য কাঠ কাটলেন, আর উঠে ঈশ্বরের নির্দিষ্ট জায়গায় দিকে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","তৃতীয় দিনের অব্রাহাম চোখ তুলে দূর থেকে সেই জায়গা দেখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","তখন অব্রাহাম নিজের দাসদেরকে বললেন, “তোমরা এই জায়গায় গাধার সঙ্গে থাক; আমি ও ছেলেটি, আমরা ঐ জায়গায় গিয়ে প্রার্থনা করি, পরে তোমাদের কাছে ফিরে আসব” ");
INSERT INTO benirv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","তখন অব্রাহাম হোমের কাঠ নিয়ে নিজের ছেলে ইসহাকের কাঁধে দিলেন এবং নিজের হাতে আগুন ও ছুরি; দুজনেই একসঙ্গে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ইসহাক নিজের বাবা অব্রাহামকে বললেন, “হে আমার বাবা।” তিনি বললেন, “হে আমার ছেলে, দেখ, এই আমি।” তখন তিনি বললেন, “এই দেখুন, আগুন ও কাঠ, কিন্তু হোমের জন্য বাচ্চা ভেড়া কোথায়?” ");
INSERT INTO benirv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","অব্রাহাম বললেন, “বৎস, ঈশ্বর নিজের হোমের জন্য বাচ্চা ভেড়া যোগাবেন।” পরে উভয়ে একসঙ্গে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ঈশ্বরের নির্দিষ্ট জায়গায় উপস্থিত হলে অব্রাহাম সেখানে যজ্ঞবেদি নির্মাণ করে কাঠ সাজালেন, পরে নিজের ছেলে ইসহাককে বেঁধে বেদিতে কাঠের ওপরে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","পরে অব্রাহাম হাত বাড়িয়ে নিজের ছেলেকে হত্যা করার জন্য ছুরি গ্রহণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","এমন দিনের আকাশ থেকে সদাপ্রভুর দূত তাঁকে ডাকলেন, বললেন, “অব্রাহাম, অব্রাহাম।” তিনি বললেন, “দেখুন এই আমি।” ");
INSERT INTO benirv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","তখন তিনি বললেন, “ছেলেটির প্রতি তোমার হাত বাড়িয়ো না ওর প্রতি কিছুই কর না, কারণ এখন আমি বুঝলাম, তুমি ঈশ্বরকে ভয় কর, আমাকে নিজের একমাত্র ছেলে দিতেও হয়নি।” ");
INSERT INTO benirv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","তখন অব্রাহাম চোখ তুলে চাইলেন, আর দেখ, তাঁর পিছন দিকে একটি ভেড়া, তার শিং ঝোপে বাঁধা; পরে অব্রাহাম গিয়ে সেই মেষটি নিয়ে নিজের পুত্রের পরিবর্তে হোমের জন্য বলিদান করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","আর অব্রাহাম সেই জায়গার নাম যিহোবা-যিরি সদাপ্রভু যোগাবেন রাখলেন। এই জন্য আজও লোকে বলে, “সদাপ্রভুর পর্বতে যোগান হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","পরে সদাপ্রভুর দূত দ্বিতীয় বার আকাশ থেকে অব্রাহামকে ডেকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","সদাপ্রভু বলছেন, “তুমি এই কাজ করলে, আমাকে নিজের একমাত্র পুত্র দিতে অসম্মত হলে না, ");
INSERT INTO benirv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","এই জন্য আমি আমারই দিব্য করে বলছি, আমি অবশ্য তোমাকে আশীর্বাদ করব এবং আকাশের তারাদের ও সমুদ্রতীরের বালির মতো তোমার অতিশয় বংশ বৃদ্ধি করব; তোমার বংশ শত্রুদের পুরদ্বার অধিকার করবে; ");
INSERT INTO benirv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","আর তোমার বংশে পৃথিবীর সব জাতি আশীর্বাদ প্রাপ্ত হবে; কারণ তুমি আমার বাক্যে পালন করেছ।” ");
INSERT INTO benirv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","পরে অব্রাহাম নিজের দাসদের কাছে গেলেন, আর সবাই উঠে একসঙ্গে বের-শেবাতে গেলেন; এবং অব্রাহাম বের-শেবাতে বাস করতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ঐ ঘটনার পরে অব্রাহামের কাছে এই সংবাদ আসল, “দেখুন, আপনার ভাই নাহোরের জন্য মিল্কাও ছেলেদেরকে জন্ম দিয়েছেন; ");
INSERT INTO benirv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","তাঁর বড় ছেলে ঊষ ও তার ভাই বূষ ও অরামের পিতা কমূয়েল এবং ");
INSERT INTO benirv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","কেষদ, হসো, পিল্‌দশ, যিদ্‌লফ ও বথূয়েল। ");
INSERT INTO benirv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","বথূয়েলের মেয়ে রিবিকা। অব্রাহামের ভাই নাহোরের জন্য মিল্কা এই আট জনকে জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","আর রুমা নামে তাঁর উপপত্নী টেবহ, গহম, তহশ এবং মাখা, এই সবাইকে জন্ম দিলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","সারার বয়স একশো সাতাশ বছর হয়েছিল; সারার জীবনকাল এত বছর। ");
INSERT INTO benirv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","পরে সারা কনান দেশে কিরিয়থর্ব্বে অর্থাৎ হিব্রোণে মারা গেলেন। আর অব্রাহাম সারার জন্য শোক ও কাঁদতে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","পরে অব্রাহাম নিজের মৃত স্ত্রীর সামনে থেকে উঠে গিয়ে হেতের সন্তানদের বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“আমি আপনাদের মধ্যে বিদেশী ও প্রবাসী; আপনাদের মধ্যে আমাকে কবরস্থানের অধিকার দিন; যেন আমি আমার সামনে আমার মৃত স্ত্রীকে কবর দিই।” ");
INSERT INTO benirv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","তখন হেতের ছেলেরা অব্রাহামকে উত্তর দিলেন, ");
INSERT INTO benirv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“হে প্রভু, আমাদের কথা শুনুন; আপনি আমাদের মধ্যে ঈশ্বর নিযুক্ত রাজাস্বরূপ; আপনার মৃত স্ত্রীকে আমাদের কবরস্থানের মধ্যে আপনার পছন্দের কবরে রাখুন, আপনার মৃত স্ত্রীকে কবর দেবার জন্য আমাদের কেউ নিজ কবর অস্বীকার করবে না” ");
INSERT INTO benirv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","তখন অব্রাহাম উঠে সেই দেশের লোকদের, অর্থাৎ হেতের ছেলেদের কাছে নত হলেন, ");
INSERT INTO benirv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","তিনি সম্ভাষণ করে বললেন, “আমার সামনে থেকে আমার মৃত স্ত্রীকে কবরে রাখতে যদি আপনাদের সম্মতি হয়, তবে আমার কথা শুনুন। আপনারা আমার জন্য সোহরের ছেলে ইফ্রোণের কাছে অনুরোধ করুন; ");
INSERT INTO benirv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","তাঁর ক্ষেত্রের শেষপ্রান্তে মক্‌পেলা গুহা আছে, আপনাদের মধ্যে আমার কবরস্থানের অধিকারের জন্য তিনি আমাকে তাই দিন; সম্পূর্ণ মূল্য নিয়ে দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","তখন ইফ্রোণ হেতের সন্তানদের মধ্যে বসে ছিলেন; আর হেতের যত সন্তান তাঁর নগরের দরজা দিয়ে প্রবেশ করলেন, তাঁদের কর্ণগোচরে সেই হিত্তীয় ইফ্রোণ অব্রাহামকে উত্তর করলেন, ");
INSERT INTO benirv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“হে আমার প্রভু, তা হবে না, আমার কথা শুনুন, আমি সেই ক্ষেত্র ও সেখানকার গুহা আপনাকে দান করলাম; আমি নিজ জাতির সন্তানদের সামনেই আপনাকে তা দিলাম, আপনার মৃত স্ত্রীকে কবর দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","তখন অব্রাহাম সেই দেশের লোকদের সামনে নত হলেন, ");
INSERT INTO benirv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","আর সেই দেশের সকলের সামনে ইফ্রোণকে বললেন, “যদি আপনার ইচ্ছা হয়, নিবেদন করি, আমার কথা শুনুন, আমি সেই ক্ষেত্রের মূল্য দিই, আপনি আমার কাছে তা গ্রহণ করুন, পরে আমি সে জায়গায় আমার মৃত স্ত্রীকে কবর দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","তখন ইফ্রন উত্তর দিয়ে অব্রাহামকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“হে আমার প্রভু, আমার কথা শুনুন, সেই ভূমির মূল্য মাত্র চারশো শেকল রূপা; এতে আপনার ও আমার কি এসে যায়? আপনি নিজ মৃত স্ত্রীকে কবর দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","তখন অব্রাহাম ইফ্রনের কথা শুনলেন; ইফ্রন হেতের সন্তানদের সামনে যে রূপার কথা বলেছিলেন, অব্রাহাম তা, অর্থাৎ বনিকদের মধ্যে প্রচলিত চারশো শেকল রূপা তুলে ইফ্রনকে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","এই ভাবে মম্রির সামনে মকপেলায় ইফ্রনের যে ক্ষেত ছিল, সেই ক্ষেত, সেখানকার গুহা ও সেই ক্ষেতের গাছগুলি, তার চারদিকের অন্তর্গত গাছগুলি, ");
INSERT INTO benirv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","এই সব কিছু হেতের সন্তানদের সামনে, তাঁর নগরের দরজায় প্রবেশকারী সকলের সামনে, অব্রাহামের নিজের অধিকার স্থির করা হল। ");
INSERT INTO benirv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","তারপরে অব্রাহাম কনান দেশের মম্রির, অর্থাৎ হিব্রোণের সামনে মকপেলা ক্ষেত্রে অবস্থিত গুহাতে নিজের স্ত্রী সারার কবর দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","এই ভাবে কবরস্থানের অধিকারের জন্য সেই ক্ষেত্রে ও সেখানকার গুহাতে অব্রাহামের অধিকার হেতের সন্তানদের মাধ্যমে স্থির করা হল। ");
INSERT INTO benirv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","সেইদিনের অব্রাহাম বৃদ্ধ ও তাঁর অনেক বয়স হয়েছিল এবং সদাপ্রভু অব্রাহামকে সব বিষয়ে আশীর্বাদ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","তখন অব্রাহাম নিজের দাসকে, তাঁর সমস্ত বিষয়ের অধ্যক্ষ, গৃহের প্রাচীনকে বললেন, “অনুরোধ করি, তুমি আমার উরুর নীচে হাত দাও; ");
INSERT INTO benirv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","আমি তোমাকে স্বর্গ মর্ত্ত্যের ঈশ্বর সদাপ্রভুর নামে এই শপথ করাই, যে কনানীয় লোকদের মধ্যে আমি বাস করছি, তুমি আমার ছেলের বিয়ের জন্য তাঁদের কোনো মেয়ে গ্রহণ করব না, ");
INSERT INTO benirv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","কিন্তু আমার দেশে আমার আত্মীয়দের কাছে গিয়ে আমার পুত্র ইস্‌হাকের জন্য মেয়ে আনবে।” ");
INSERT INTO benirv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","তখন সেই দাস তাঁকে বললেন, “কি জানি, আমার সঙ্গে এই দেশে আসতে কোনো মেয়ে রাজি হবে না; আপনি যে দেশ ছেড়ে এসেছেন, আপনার ছেলেকে কি আবার সেই দেশে নিয়ে যাব?” ");
INSERT INTO benirv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","তখন অব্রাহাম তাঁকে বললেন, “সাবধান, কোনোভাবে আমার ছেলেকে আবার সেখানে নিয়ে যেও না। ");
INSERT INTO benirv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","সদাপ্রভু, স্বর্গের ঈশ্বর, যিনি আমাকে বাবার বাড়ি ও আত্মীয়দের মধ্য থেকে এনেছেন, আমার সঙ্গে আলাপ করেছেন এবং এমন শপথ করেছেন যে, আমি তোমার বংশকে এই দেশ দেব, তিনিই তোমার আগে নিজের দূত পাঠাবেন; তাতে তুমি আমার ছেলের জন্য সেখান থেকে একটি মেয়ে নিয়ে আসতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","যদি কোনো মেয়ে তোমার সঙ্গে আসতে রাজি না হয়, তবে তুমি আমার এই শপথ থেকে মুক্ত হবে; কিন্তু কোনো ভাবে আমার ছেলেকে আবার সে দেশে নিয়ে যেও না।” ");
INSERT INTO benirv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","তাতে সেই দাস নিজের প্রভু অব্রাহামের উরুর নীচে হাত দিয়ে সেই বিষয়ে শপথ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","পরে সেই দাস নিজের প্রভুর উটেদের মধ্য থেকে দশটা উট ও নিজের প্রভুর সব রকমের ভালো জিনিসপত্র হাতে নিয়ে চলে গেলেন, অরাম-নহরয়িম দেশে, নাহোরের নগরে যাত্রা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","আর সন্ধ্যাবেলায় যে দিনের স্ত্রীলোকের জল তুলতে বের হয়, সেই দিনের তিনি নগরের বাইরে কুয়োর কাছে উটদেরকে বসিয়ে রাখলেন ");
INSERT INTO benirv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","তিনি বললেন, “হে সদাপ্রভু, আমার কর্তা অব্রাহামের ঈশ্বর, অনুরোধ করি, আজ আমার সামনে শুভফল উপস্থিত কর, আমার প্রভু অব্রাহামের প্রতি দয়া কর। ");
INSERT INTO benirv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","দেখ, আমি এই সজল কুয়োর কাছে দাঁড়িয়ে আছি এবং এই নগরবাসীদের মেয়েরা জল তুলতে বাইরে আসছে; ");
INSERT INTO benirv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","অতএব যে মেয়েকে আমি বলব, আপনার কলসি নামিয়ে আমাকে জল পান করান, সে যদি বলে, পান কর, তোমার উটদেরকেও পান করাব, তবে তোমার দাস ইস্‌হাকের জন্য তোমার নিরূপিত মেয়ে সেই হোক; এতে আমি জানব যে, তুমি আমার প্রভুর প্রতি দয়া করলে।” ");
INSERT INTO benirv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","এই কথা বলতে না বলতে, দেখ, রিবিকা কলসি কাঁধে করে বাইরে আসলেন; তিনি অব্রাহামের নাহর নামক ভাইয়ের স্ত্রী মিল্কার ছেলে বথূয়েলের মেয়ে। ");
INSERT INTO benirv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","সেই মেয়ে দেখতে বড়ই সুন্দরী এবং অবিবাহিতা ও পুরুষের পরিচয় অপ্রাপ্তা ছিলেন। তিনি কূপে নেমে কলসিতে জল ভরে উঠে আসছেন, ");
INSERT INTO benirv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","এমন দিনের সেই দাস দৌড়িয়ে এসে তাঁর সঙ্গে দেখা করে বললেন, “অনুরোধ করি, আপনার কলসি থেকে আমাকে কিছু জল পান করতে দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","তিনি বললেন, “মহাশয়, পান করুন;” এই বলে তিনি শীঘ্র কলশি হাতের ওপরে নামিয়ে তাঁকে পান করতে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","আর তাঁকে পান করাবার পর বললেন, “যতক্ষণ আপনার উটেদের জল পান শেষ না হয়, ততক্ষণ আমি ওদের জন্যও জল তুলব।” ");
INSERT INTO benirv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","পরে তিনি শীঘ্র পাত্রে কলশির জল ঢেলে আবার জল তুলতে কুয়োর কাছে দৌড়ে গিয়ে তাঁর উটদের জন্য জল তুললেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","তাতে সেই পুরুষ তাঁর প্রতি এক নজরে চেয়ে, সদাপ্রভু তাঁর যাত্রা সফল করেন কি না, তা জানার জন্য নীরব থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","উটেরা জল পান করার পর সেই পুরুষ অর্ধেক শেকল পরিমিত দুই হাতের সোনার নথ এবং দশ তোলা পরিমিত দুই হাতের সোনার বালা নিয়ে বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“আপনি কার মেয়ে? অনুরোধ করি, আমাকে বলুন, আপনার বাবার বাড়িতে কি আমাদের রাত কাটানোর জায়গা আছে?” ");
INSERT INTO benirv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","তিনি উত্তর করলেন, “আমি সেই বথূয়েলের মেয়ে, যিনি মিল্কার ছেলে, যাঁকে তিনি নাহোরের জন্য জন্ম দিয়েছিলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","তিনি আরও বললেন, “খড় ও কলাই আমাদের কাছে যথেষ্ট আছে এবং রাত কাটাবার জায়গাও আছে।” ");
INSERT INTO benirv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","তখন সে ব্যক্তি মাথা নিচু করে সদাপ্রভুর উদ্দেশ্যে প্রার্থনা করলেন, ");
INSERT INTO benirv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","তিনি বললেন, “আমার কর্তা অব্রাহামের ঈশ্বর সদাপ্রভু ধন্য হোন, তিনি আমার কর্তার সঙ্গে নিজের দয়া ও সত্য ব্যবহার অস্বীকার করেননি; সদাপ্রভু আমাকেও পথঘটনাতে আমার কর্তার আত্মীয়দের বাড়িতে আনলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","পরে সেই মেয়ে দৌড়ে গিয়ে নিজের মায়ের ঘরের লোকদেরকে এই সব কথা জানালেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","আর রিবিকার এক ভাই ছিলেন, তাঁর নাম লাবন; সেই লাবন বাইরে ঐ ব্যক্তির উদ্দেশ্যে কূপের কাছে দৌড়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","নথ ও বোনের হাতে বালা দেখে এবং সেই ব্যক্তি আমাকে এই কথা বললেন, নিজের বোন রিবিকার মুখে এই শুনে, তিনি সেই পুরুষের কাছে গেলেন, আর দেখ, তিনি কুয়োর কাছে উটদের সঙ্গে দাঁড়িয়ে ছিলেন; ");
INSERT INTO benirv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","আর লাবন বললেন, “হে সদাপ্রভুর আশীর্বাদপাত্র, আসুন, কেন বাইরে দাঁড়িয়ে আছেন? আমি তো ঘর এবং উটদের জন্যও জায়গা তৈরী করেছি।” ");
INSERT INTO benirv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","তখন ঐ লোক বাড়িতে ঢুকে উটদের সজ্জা খুললে তিনি উটদের জন্য খড় ও কলাই দিলেন এবং তাঁর ও তার সঙ্গী লোকদের পা ধোবার জল দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","পরে তাঁর সামনে আহারের জিনিস রাখা হল, কিন্তু তিনি বললেন, “যা বলার না বলে আমি আহার করব না।” লাবন বললেন, “বলুন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","তখন তিনি বলতে লাগলেন, “আমি অব্রাহামের দাস;” ");
INSERT INTO benirv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","সদাপ্রভু আমার কর্তাকে প্রচুর আশীর্বাদ করেছেন, আর তিনি বড় মানুষ হয়েছেন এবং সদাপ্রভু তাঁকে ভেড়া ও পশুপাল এবং রূপা ও সোনা এবং দাস ও দাসী এবং উট ও গাধা দিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","আর আমার কর্তার স্ত্রী সারা বৃদ্ধ বয়সে তাঁর জন্য এক ছেলের জন্ম দিয়েছেন, তাঁকেই তিনি আপনার সব কিছু দিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","আর আমার কর্তা আমাকে শপথ করিয়ে বললেন, “আমি যাদের দেশে বাস করছি, তুমি আমার ছেলের জন্য সেই কনানীয়দের কোনো মেয়ে এন না; ");
INSERT INTO benirv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","কিন্তু আমার বাবার বংশের ও আমার আত্মীয়ের কাছে গিয়ে আমার ছেলের জন্য মেয়ে এন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","তখন আমি কর্তাকে বললাম, “কি জানি, কোনো মেয়ে আমার সঙ্গে আসবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","তিনি বললেন, “আমি যাঁর সামনে চলাফেরা করি সেই সদাপ্রভু তোমার সঙ্গে নিজের দূত পাঠিয়ে তোমার যাত্রা সফল করবেন; এবং তুমি আমার আত্মীয় ও আমার বাবার বংশ থেকে আমার ছেলের জন্য মেয়ে আনবে। ");
INSERT INTO benirv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","তা করলে এই শপথ থেকে মুক্ত হবে; আমার আত্মীয়ের কাছে গেলে যদি তারা মেয়ে না দেয়, তবে তুমি এই শপথ থেকে মুক্ত হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","আর আজ আমি ঐ কূপের কাছে পৌছালাম, আর বললাম, “হে সদাপ্রভু, আমার কর্তা অব্রাহামের ঈশ্বর, তুমি যদি আমার এই যাত্রা সফল কর, ");
INSERT INTO benirv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","তবে দেখ, আমি এই কুয়োর কাছে দাঁড়িয়ে আছি; অতএব জল তুলতে আসার জন্য যে মেয়েকে আমি বলব, নিজের কলসি থেকে আমাকে কিছু জল পান করতে দিন,” ");
INSERT INTO benirv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","তিনি যদি বলেন, “তুমিও পান কর এবং তোমার উটেদের জন্যও আমি জল তুলে দেব; তবে তিনি সেই মেয়ে হোন, যাঁকে সদাপ্রভু আমার কর্তার ছেলের জন্য মনোনীত করেছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","এই কথা আমি মনে মনে বলতে না বলতে, দেখ, রিবিকা কলসি কাঁধে করে বাইরে আসলেন; পরে তিনি কূপে নেমে জল তুললে আমি বললাম, “অনুরোধ করি, আমাকে জল পান করান।” ");
INSERT INTO benirv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","তখন তিনি তাড়াতাড়ি কাঁধ থেকে কলসি নামিয়ে বললেন “পান করুন, আমি আপনার উটদেরকেও পান করাব।” তখন আমি পান করলাম; আর তিনি উটদেরকেও পান করালেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","পরে আমি তাঁকে জিজ্ঞাসা করলাম, “আপনি কার মেয়ে?” তিনি উত্তর করলেন, “আমি বথূয়েলের মেয়ে, তিনি নাহোরের ছেলে, যাঁকে মিল্কা তাঁর জন্য জন্ম দিয়েছিলেন।” তখন আমি তাঁর নাকে নথ ও হাতে বালা পরিয়ে দিলাম। ");
INSERT INTO benirv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","আর মাথা নিচু করে সদাপ্রভুর উদ্দেশ্যে প্রার্থনা করলাম এবং যিনি আমার কর্তার ছেলের জন্য তাঁর ভাইয়ের মেয়ে গ্রহণের জন্য আমাকে প্রকৃত পথে আনলেন, আমার কর্তা অব্রাহামের ঈশ্বর সেই সদাপ্রভুকে ধন্যবাদ করলাম। ");
INSERT INTO benirv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","অতএব আপনারা যদি এখন আমার কর্তার সঙ্গে দয়া ও সত্য ব্যবহার করতে রাজি হন, তা বলুন; আর যদি না হন, তাও বলুন; তাতে আমি ডান দিকে কিম্বা বাম দিকে ফিরতে পারব। ");
INSERT INTO benirv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","তখন লাবন ও বথুয়েল উত্তর করলেন, বললেন, “সদাপ্রভু থেকে এই ঘটনা হল, আমরা ভাল মন্দ কিছুই বলতে পারি না। ");
INSERT INTO benirv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ঐ দেখুন, রিবিকা আপনার সামনে আছে; ওকে নিয়ে চলে যান; এ আপনার কর্তার ছেলের স্ত্রী হোক, যেমন সদাপ্রভু বলেছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","তাঁদের কথা শোনামাত্র অব্রামের দাস সদাপ্রভুর উদ্দেশ্যে মাটিতে নত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","পরে সেই দাস রূপার সোনার গয়না ও বস্ত্র বের করে রিবিকাকে দিলেন এবং তাঁর ভাইকে ও মাকে বহুমূল্য দ্রব্য দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","আর তিনি ও তাঁর সাথীরা ভোজন পান করে সেখানে রাত কাটালেন; পরে তাঁরা সকালে উঠলে তিনি বললেন, “আমার কর্তার কাছে আমাকে যেতে দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","তাতে রিবিকার ভাই ও মা বললেন, “মেয়েটী আমাদের কাছে কিছু দিন থাকুক, কমপক্ষে দশ দিন থাকুক, পরে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","কিন্তু তিনি তাঁদেরকে বললেন, “আমাকে দেরী করাবেন না কারণ সদাপ্রভু আমার যাত্রা সফল করলেন; আমাকে বিদায় করুন; আমি নিজ কর্তার কাছে যাই।” ");
INSERT INTO benirv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","তাকে তাঁরা বললেন, “আমার মেয়েকে ডেকে তাকে সামনে জিজ্ঞাসা করি।” ");
INSERT INTO benirv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","পরে তাঁরা রিবিকাকে ডেকে বললেন, “তুমি কি এই ব্যক্তির সঙ্গে যাবে?” তিনি বললেন, “যাব।” ");
INSERT INTO benirv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","তখন তাঁরা নিজেদের বোন রিবিকার কাছে ও তাঁর ধাত্রীকে এবং অব্রাহামের দাসকে ও তাঁর লোকদেরকে বিদায় করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","আর রিবিকাকে আশীর্বাদ করে বললেন, “তুমি আমাদের বোন, হাজার হাজার অযুতের মা হও; তোমার বংশ নিজের শত্রুর পুরদ্বার অধিকার করুক।” ");
INSERT INTO benirv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","পরে রিবিকা ও তাঁর দাসীরা উঠলেন এবং উটে চড়ে সেই মানুষের পিছনে গেলেন। এই ভাবে সেই দাস রিবিকাকে নিয়ে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","আর ইসহাক বের-লহয়-রয়ী নামক জায়গায় গিয়ে ফিরে এসেছিলেন, কারণ তিনি দক্ষিণ দেশে বাস করছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ইসহাক সন্ধ্যাবেলায় ধ্যান করতে ক্ষেত্রে গিয়েছিলেন, পরে চোখ তুলে দেখলেন, আর দেখ, উট আসছে। ");
INSERT INTO benirv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","আর রিবিকা চোখ তুলে যখন ইসহাককে দেখলেন, তখন উট থেকে নামলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","সেই দাসকে জিজ্ঞাসা করলেন, “আমাদের সঙ্গে দেখা করতে ক্ষেত্রের মধ্য দিয়ে আসছেন, ঐ লোকটি কে?” দাস বললেন, “উনি আমার কর্তা” তখন রিবিকা ঘোমটা দিয়ে নিজেকে ঢাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","পরে সেই দাস ইসহাককে আপনার করা সমস্ত কাজের বিবরণ বললেন। ");
INSERT INTO benirv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","তখন ইসহাক রিবিকাকে গ্রহণ করে সারা মায়ের তাঁবুতে নিয়ে গিয়ে তাকে বিয়ে করলেন এবং তাকে প্রেম করলেন। তাতে ইসহাক মায়ের মৃত্যুর শোক থেকে সান্ত্বনা পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","অব্রাহাম কটুরা নামে আর এক স্ত্রীকে বিয়ে করেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","তিনি তাঁর জন্য সিম্রন, যক্‌ষন, মদান, মিদিয়ন, যিশ্‌বক ও শূহ, এদের সকলকে প্রসব করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","যক্‌ষন শিবা ও দদানের বাবা হলেন। অশুরীয়, লটুশীয় ও লিয়ূম্মীয় লোকেরা দদানের বংশধর। ");
INSERT INTO benirv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","মিদিয়নের ছেলে ঐফা, এফর, হনোক, অবীদ ও ইলদায়া; এরা সকলে কটুরার বংশধর। ");
INSERT INTO benirv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","অব্রাহাম ইসহাককে নিজের সব কিছু দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","কিন্তু নিজের উপপত্নীদের ছেলেদের কে অব্রাহাম ভিন্ন ভিন্ন দান দিয়ে নিজের জীবদ্দশাতেই নিজের ছেলে ইসহাকের কাছ থেকে তাঁদেরকে পুর্বদিকে, পুর্বদেশে পাঠালেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","অব্রাহামের জীবনকাল একশো পঁচাত্তর বছর; তিনি এত বছর জীবিত ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","পরে অব্রাহাম বৃদ্ধ ও পূর্ণায়ু হয়ে শুভ বৃদ্ধ অবস্থায় প্রাণত্যাগ করে নিজের লোকদের কাছে সংগৃহীত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","তাঁর ছেলে ইস্‌হাক ও ইশ্মায়েল মম্রির সামনে হেতীয় সোহরের ছেলে ইফ্রোনের ক্ষেত্রে অবস্থিত মক্‌পেলা গুহাতে তাঁর কবর দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","অব্রাহাম হেতের ছেলেদের কাছে সেই ক্ষেত্র কিনেছিলেন। সেই জায়গায় অব্রাহামের ও তাঁর স্ত্রী সারার কবর দেওয়া হয়। ");
INSERT INTO benirv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","অব্রাহামের মৃত্যু হলে পর ঈশ্বর তাঁর ছেলে ইসহাককে আশীর্বাদ করলেন এবং ইসহাক বের-লহয়-রয়ীর কাছে বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","অব্রাহামের ছেলে ইশ্মায়েলের বংশ বৃত্তান্ত এই। সারার দাসী মিশরীয় হাগার অব্রাহামের জন্য তাঁকে জন্ম দিয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","নিজের নিজের নাম ও গোষ্ঠী অনুসারে ইশ্মায়েলের ছেলেদের নাম এই। ইশ্মায়েলের বড় ছেলে নবায়োৎ, পরে কেদর, অদবেল, মিবসম, ");
INSERT INTO benirv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","মিশম, দূমা, মসা, ");
INSERT INTO benirv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","হদদ, তেমা, জিতুর নাফীশ ও কেদমা। ");
INSERT INTO benirv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","এই সকল ইস্মায়েলের ছেলে এবং তাঁদের গ্রাম ও তাঁবুপল্লি অনুসারে তাঁদের এই এই নাম; তাঁরা নিজের নিজের জাতি অনুসারে বারো জন নেতা ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ইশ্মায়েলের জীবনকাল একশো সাঁইত্রিশ বছর ছিল; পরে তিনি প্রাণত্যাগ করে নিজের লোকদের কাছে সংগৃহীত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","আর তাঁর ছেলেরা হবীলা থেকে অশূরিয়ার দিকে মিশরের সামনে অবস্থিত শূর পর্যন্ত বাস করল; তিনি তাঁর সব ভাইয়ের সামনে বাস করার জায়গা পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","অব্রাহামের ছেলে ইসহাকের বংশ বিবরণ এই। অব্রাহাম ইসহাকের জন্ম দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","চল্লিশ বছর বয়সে ইসহাক অরামীয় বথূয়েলের মেয়ে অরামীয় লাবনের বোন রিবিকাকে পদ্দন-অরাম থেকে এনে বিয়ে করেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ইসহাকের স্ত্রী বন্ধ্যা হওয়াতে তিনি তাঁর জন্য সদাপ্রভুর কাছে প্রার্থনা করলেন। তাতে সদাপ্রভু তাঁর প্রার্থনা শুনলেন, তাঁর স্ত্রী রিবিকা গর্ভবতী হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","তাঁর গর্ভমধ্যে শিশুরা জড়াজড়ি করল, তাতে তিনি বললেন, “যদি এমন হয়, তবে আমি কেন বেঁচে আছি?” আর তিনি সদাপ্রভুর কাছে জিজ্ঞাসা করতে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","তখন সদাপ্রভু তাঁকে বললেন, “তোমার গর্ভে দুই জাতি আছে ও তোমার উদর থেকে দুই বংশ আলাদা হবে; এক বংশ অন্য বংশের থেকে শক্তিশালী হবে ও বড় ছোটর দাস হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","পরে প্রসবকাল সম্পূর্ণ হল, আর দেখ, তাঁর গর্ভে যমজ ছেলে। ");
INSERT INTO benirv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","যে প্রথমে ভূমিষ্ঠ হল, সে রক্তবর্ণ এবং তার সর্বাঙ্গ লোমশ বস্ত্রের মতো ছিল। তার নাম এষৌ লোমশ রাখা গেল। ");
INSERT INTO benirv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","পরে তার ভাই ভূমিষ্ঠ হল। তার হাত এষৌর পা ধরেছিল, আর তার নাম যাকোব পাদ্গ্রাহী হল; ইসহাকের ষাট বছর বয়সে এই যমজ ছেলে হল। ");
INSERT INTO benirv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","পরে সেই বালকেরা বড় হলে এষৌই নিপুণ শিকারি ও মরুপ্রান্তে মানুষ হলেন; কিন্তু যাকোব শান্ত ছিলেন, তিনি তাঁবুতে বাস করতেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ইসহাক এষৌকে ভালবাসতেন, কারণ তাঁর মুখে শিকার করা মাংস ভাল লাগত; কিন্তু রিবিকা যাকোবকে ভালবাসতেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","একবার যাকোব ঝোল রান্না করেছেন, এমন দিন এষৌ ক্লান্ত হয়ে মরুভূমি থেকে এসে ");
INSERT INTO benirv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","এষৌ যাকোবকে বললেন, “আমি ক্লান্ত হয়েছি, অনুরোধ করি, ঐ লাল, ঐ লাল ঝোল দিয়ে আমার পেট ভর্তি কর।” এই জন্য তাঁর নাম ইদোম লাল খ্যাত হল। ");
INSERT INTO benirv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","তখন যাকোব বললেন, “আজ তোমার বড় হওয়ার অধিকার আমার কাছে বিক্রি কর।” ");
INSERT INTO benirv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","এষৌ বললেন, “দেখ, আমি মৃতপ্রায়, বড় হওয়ার অধিকারে আমার কি লাভ?” ");
INSERT INTO benirv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","যাকোব বললেন, “তুমি আজ আমার কাছে শপথ কর।” তাতে তিনি তাঁর কাছে শপথ করলেন। এই ভাবে তিনি নিজের বড় হওয়ার অধিকার যাকোবের কাছে বিক্রি করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","আর যাকোব এষৌকে রুটি ও মসুরের রান্না ডাল দিলেন। তিনি ভোজন পান করলেন, পরে উঠে চলে গেলেন। এই ভাবে এষৌ নিজের বড় হওয়ার অধিকার তুচ্ছ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","আগে অব্রামের দিনের যে দূর্ভিক্ষ হয়, তাছাড়া দেশে আর এক দূর্ভিক্ষ দেখা দিল। তখন ইসহাক গরারে পলেষ্টীয়দের রাজা অবীমেলকের কাছে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","সদাপ্রভু তাঁকে দর্শন দিয়ে বললেন, “তুমি মিশর দেশে নেমে যেও না, আমি তোমাকে যে দেশের কথা বলব, সেখানে থাক; ");
INSERT INTO benirv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","এই দেশে বসবাস কর; আমি তোমার সঙ্গে থেকে তোমাকে আশীর্বাদ করব, কারণ আমিই তোমাকে ও তোমার বংশকে এই সব দেশ দেব এবং তোমার বাবা অব্রাহামের কাছে যে শপথ করেছিলাম, তা সফল করব। ");
INSERT INTO benirv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","আমি আকাশের তারাদের মতো তোমার বংশ বৃদ্ধি করব, তোমার বংশকে এই সব দেশ দেব ও তোমার বংশে পৃথিবীর যাবতীয় জাতি আশীর্বাদ প্রাপ্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","কারণ অব্রাহাম আমার বাক্য মেনে আমার আদেশ, আমার আজ্ঞা, আমার বিধি ও আমার ব্যবস্থা সব পালন করেছে।” ");
INSERT INTO benirv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","তাই ইসহাক গরারে বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","আর সে জায়গার লোকেরা তাঁর স্ত্রীর বিষয়ে জিজ্ঞাসা করলে তিনি বললেন, “উনি আমার বোন; কারণ, এ আমার স্ত্রী, এই কথা বলতে তিনি ভয় পেলেন, ভাবলেন, কি জানি এই জায়গার লোকেরা রিবিকার জন্য আমাকে হত্যা করবে; কারণ তিনি দেখতে সুন্দরী ছিলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","কিন্তু সে জায়গায় বহুকাল বাস করলে পর কোনো দিনের পলেষ্টীয়দের রাজা অবীমেলক জানালা দিয়ে দেখলেন, আর দেখ, ইসহাক নিজের স্ত্রী রিবিকার সঙ্গে সোহাগপূর্ণ ব্যবহার করছে। ");
INSERT INTO benirv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","তখন অবীমেলক ইসহাককে ডেকে বললেন, “দেখুন, তিনি অবশ্য আপনার স্ত্রী; তবে আপনি বোন বলে তাঁর পরিচয় কেন দিয়েছিলেন?” ইসহাক উত্তর করলেন, “আমি ভাবছিলাম, কি জানি, তাঁর জন্য আমার মৃত্যু হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","তখন অবীমেলক বললেন, “আপনি আমাদের সঙ্গে এ কি ব্যবহার করলেন? কোনো লোক আপনার ভার্য্যার সঙ্গে অনায়াসে শয়ন করতে পারত; তা হলে আপনি আমাদেরকে দোষী করতেন।” ");
INSERT INTO benirv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","তাই অবীমেলক সব লোককে এই আজ্ঞা দিলেন, “যে কেউ এই ব্যক্তিকে কিম্বা এর স্ত্রীকে স্পর্শ করবে, তাঁর প্রাণদণ্ড অবশ্য হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","আর ইসহাক সেই দেশে চাষবাস করে সেই বছর একশো গুণ শস্য পেলেন এবং সদাপ্রভু তাঁকে আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","আর তিনি ধনী হলেন এবং আরো বৃদ্ধি পেয়ে অনেক বড় লোক হলেন; ");
INSERT INTO benirv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","আর তাঁর ভেড়া ও গরু সম্পত্তি এবং অনেক দাস দাসী হল; আর পলেষ্টীয়রা তাঁর প্রতি হিংসা করতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","তাঁর বাবা অব্রাহামের দিনের তাঁর দাসরা যে যে কুয়ো খুঁড়েছিল, পলেষ্টীয়রা সে সব বুজিয়ে ফেলেছিল ও ধূলোতে ভর্তি করেছিল। ");
INSERT INTO benirv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","পরে অবীমেলক ইসহাককে বললেন, “আমাদের কাছ থেকে চলে যান, কারণ আপনি আমাদের থেকে অনেক শক্তিশালী হয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","পরে ইস্‌হাক সেখান থেকে চলে গেলেন ও গরারের উপত্যকাতে তাঁবু স্থাপন করে সেখানে বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ইস্‌হাক নিজের বাবা অব্রাহামের দিনের খোঁড়া কুয়ো সব আবার খুঁড়লেন; কারণ অব্রাহামের মৃত্যুর পরে পলেষ্টীয়রা সে সব বুজিয়ে ফেলেছিল; তাঁর বাবা সেই সকলের যে যে নাম রেখেছিলেন, তিনিও সেই সেই নাম রাখলেন! ");
INSERT INTO benirv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","সেই উপত্যকায় ইসহাকের দাসরা খুঁড়ে জলের উনুই বিশিষ্ট এক কুয়ো পেল। ");
INSERT INTO benirv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","তাতে গরারীয় পশুপালকেরা ইসহাকের পশুপালকদের সঙ্গে বিবাদ করে বলল, এ জল আমাদের; অতএব তিনি সেই কুয়োর নাম এষক বিবাদ রাখলেন, যেহেতু তারা তাঁর সঙ্গে বিবাদ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","পরে তাঁর দাসরা আর এক কুয়ো খনন করলে তারা সেটির জন্যও বিবাদ করল; তাতে তিনি সেটির নাম সিটনা বিপক্ষতা রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","তিনি সেখান থেকে চলে গিয়ে অন্য এক কুয়ো খনন করলেন; সেটার জন্য তারা বিবাদ করল না; তাই তিনি সেটার নাম রহোবোৎ প্রশস্ত স্থান রেখে বললেন, এখন সদাপ্রভু আমাদেরকে প্রশস্ত স্থান দিলেন, আমরা দেশে ফলবন্ত হব। ");
INSERT INTO benirv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","পরে তিনি সেখান থেকে বের-শেবাতে উঠে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","সেই রাতে সদাপ্রভু তাঁকে দর্শন দিয়ে বললেন, “আমি তোমার পিতা অব্রাহামের ঈশ্বর, ভয় কর না, কারণ আমি নিজের দাস অব্রাহামের অনুরোধে তোমার সহবর্ত্তী, আমি আশীর্বাদ করব ও তোমার বংশ বৃদ্ধি করব।” ");
INSERT INTO benirv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ইসহাক সেই জায়গায় যজ্ঞবেদি নির্মাণ করে সদাপ্রভুর নামে ডাকলেন, আর সেই জায়গায় তিনি তাঁবু স্থাপন করলেন ও তাঁর দাসরা সেখানে একটা কুয়ো খুঁড়ল। ");
INSERT INTO benirv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","আর অবীমেলক নিজের বন্ধু অহূষৎকে ও সেনাপতি ফীকোলকে সঙ্গে নিয়ে গরার থেকে ইসহাকের কাছে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ইসহাক তাঁদেরকে বললেন, “আপনারা আমার কাছে কি জন্য আসলেন? আপনারা তো আমাকে হিংসা করে আপনাদের থেকে দূর করে দিয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","তাঁরা বললেন, “আমরা স্পষ্টই দেখলাম, সদাপ্রভু আপনার সহবর্ত্তী, এই জন্য বললাম, আমাদের মধ্য অর্থাৎ আমাদের ও আপনার মধ্যে একটা শপথ হোক, আর আমরা একটা নিয়ম স্থির করি। ");
INSERT INTO benirv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","আমরা যেমন আপনাকে স্পর্শ করিনি ও আপনার মঙ্গল ছাড়া আর কিছুই করিনি, বরং আপনাকে শান্তিতে বিদায় করেছি, সেই রকম আপনিও আমাদের উপর হিংসা করবেন না; আপনিই এমন সদাপ্রভুর আশীর্বাদের পাত্র।” ");
INSERT INTO benirv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","তখন ইস্‌হাক তাঁদের জন্যে ভোজ প্রস্তুত করলে তাঁরা ভোজন পান করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","পরে তাঁরা ভোরবেলায় উঠে পরস্পর শপথ করলেন; তখন ইস্‌হাক তাঁদেরকে বিদায় করলে তাঁরা শান্তিতে তাঁর কাছ থেকে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","সেই দিন ইস্‌হাকের দাসরা এসে নিজেদের খোঁড়া কূপের বিষয়ে সংবাদ দিয়ে তাঁকে বলল, “জল পেয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","তিনি তার নাম শিবিয়া দিব্যি রাখলেন, এই জন্য আজ পর্যন্ত সেই নগরের নাম বের-শেবা রয়েছে। ");
INSERT INTO benirv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","আর এষৌ চল্লিশ বছর বয়সে হিত্তীয় বেরির যিহূদীৎকে এবং হিত্তীয় এলোনের মেয়ে বাসমৎকে বিয়ে করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","এরা ইসহাকের ও রিবিকার জীবনে দুঃখ দিল। ");
INSERT INTO benirv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","পরে ইস্‌হাক বৃদ্ধ হলে তাঁর চোখ নিস্তেজ হওয়ায় আর দেখতে পেতেন না; তখন তিনি আপনার বড় ছেলে এষৌকে ডেকে বললেন, “বৎস।” ");
INSERT INTO benirv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","তিনি উত্তর করলেন, “দেখুন, এই আমি।” তখন ইস্‌হাক বললেন, “দেখ, আমি বৃদ্ধ হয়েছি; কোন দিন আমার মৃত্যু হবে, জানি না। ");
INSERT INTO benirv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","এখন অনুরোধ করি, তোমার শস্ত্র, তোমার তীর ও ধনুক নিয়ে প্রান্তরে যাও, আমার জন্য পশু শিকার করে আন। ");
INSERT INTO benirv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","আমি যেমন ভালবাসি, সেরকম সুস্বাদু খাদ্য তৈরী করে আমার কাছে আন, আমি ভোজন করব; যেন মৃত্যুর আগে আমার প্রাণ তোমাকে আশীর্বাদ করে।” ");
INSERT INTO benirv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","যখন ইস্‌হাক নিজের ছেলে এষৌকে এই কথা বলেন, তখন রিবিকা তা শুনতে পেলেন। অতএব এষৌ পশু শিকার করে আনবার জন্য প্রান্তরে গেলে পর ");
INSERT INTO benirv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","রিবিকা নিজের ছেলে যাকোবকে বললেন, “দেখ, তোমার ভাই এষৌকে তোমার বাবা যা বলেছেন, আমি শুনেছি;” ");
INSERT INTO benirv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","তিনি বলেছেন, “তুমি আমার জন্য পশু শিকার করে এনে সুস্বাদু খাদ্য তৈরী কর, তাতে আমি ভোজন করে মৃত্যুর আগে সদাপ্রভুর সামনে তোমাকে আশীর্বাদ করব। ");
INSERT INTO benirv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","হে আমার ছেলে, এখন আমি তোমাকে যা আদেশ করি, আমার সেই কথা শুন। ");
INSERT INTO benirv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","তুমি পালে গিয়ে সেখান থেকে উত্তম দুটি বাচ্চা ছাগল আন, তোমার বাবা যেমন ভাল বাসেন, সেরকম সুস্বাদু খাবার আমি প্রস্তুত করে দিই; ");
INSERT INTO benirv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","পরে তুমি নিজের বাবার কাছে তা নিয়ে যাও, তিনি তা ভোজন করুন; যেন তিনি মৃত্যুর আগে তোমাকে আশীর্বাদ করেন।” ");
INSERT INTO benirv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","তখন যাকোব নিজের মা রিবিকাকে বললেন, “দেখ, আমার ভাই এষৌ লোমশ, কিন্তু আমি নির্লোম। ");
INSERT INTO benirv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","কি জানি, বাবা আমাকে স্পর্শ করবেন, আর আমি তাঁর দৃষ্টিতে প্রতারক বলে গণিত হব; তা হলে আমি আমার প্রতি আশীর্বাদ না পেয়ে অভিশাপ পাব।” ");
INSERT INTO benirv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","তাঁর মা বললেন, “বৎস, সেই অভিশাপ আমাতেই আসুক, কেবল আমার কথা শোনো, একটি বাচ্চা ছাগল নিয়ে এস।” ");
INSERT INTO benirv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","পরে যাকোব গিয়ে তা নিয়ে মায়ের কাছে নিয়ে গেলেন, আর তাঁর বাবা যেমন ভালবাসতেন, মা সেরকম সুস্বাদু খাবার তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","আর ঘরে নিজের কাছে বড় ছেলে এষৌর যে যে সুন্দর বস্ত্র ছিল, রিবিকা তা নিয়ে ছোট ছেলে যাকোবকে পরিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ঐ দুই বাচ্চা ছাগলের চামড়া নিয়ে তাঁর হাতে ও গলার নির্লোম জায়গায় জড়িয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","আর তিনি যে সুস্বাদু খাবার ও রুটি রান্না করেছিলেন, তা তাঁর ছেলে যাকোবের হাতে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","পরে তিনি নিজের বাবার কাছে গিয়ে বললেন, “বাবা।” তিনি উত্তর করলেন, “দেখ, এই আমি; বৎস, তুমি কে?” ");
INSERT INTO benirv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","যাকোব নিজের বাবাকে বললেন, “আমি আপনার বড় ছেলে এষৌ; আপনি আমাকে যা আদেশ করেছিলেন, তা করেছি। অনুরোধ করি, আপনি উঠে বসে আমার আনা পশুর মাংস ভোজন করুন, যেন আপনার প্রাণ আমাকে আশীর্বাদ করে।” ");
INSERT INTO benirv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","তখন ইসহাক নিজের ছেলেকে বললেন, “বৎস, কেমন করে এত তাড়াতাড়ি ওটা পেলে?” তিনি বললেন, “আপনার ঈশ্বর সদাপ্রভু আমার সামনে শুভফল উপস্থিত করলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ইস্‌হাক যাকোবকে বললেন, “বৎস, কাছে এস; আমি তোমাকে স্পর্শ করে বুঝি, তুমি নিশ্চয় আমার ছেলে এষৌ কি না।” ");
INSERT INTO benirv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","তখন যাকোব নিজের বাবা ইস্‌হাকের কাছে গেলে তিনি তাঁকে স্পর্শ করে বললেন, “গলার আওয়াজ তো যাকোবের আওয়াজ, কিন্তু হাত এষৌর হাত।” ");
INSERT INTO benirv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","বাস্তবিক তিনি তাঁকে চিনতে পারলেন না, কারণ ভাই এষৌর হাতের মতো তাঁর হাত লোমযুক্ত ছিল; অতএব তিনি তাঁকে আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","তিনি বললেন, “তুমি নিশ্চয়ই আমার ছেলে এষৌ?” তিনি বললেন, “হ্যাঁ।” ");
INSERT INTO benirv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","তখন ইস্‌হাক বললেন, “আমার কাছে আন; আমি ছেলের আনা পশুর মাংস ভোজন করি, যেন আমার প্রাণ তোমাকে আশীর্বাদ করে।” তিনি মাংস আনলে ইস্‌হাক ভোজন করলেন এবং দ্রাক্ষারস এনে দিলে তা পান করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","পরে তাঁর বাবা ইস্‌হাক বললেন, “বৎস, অনুরোধ করি, কাছে এসে আমাকে চুম্বন কর।” ");
INSERT INTO benirv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","তখন তিনি কাছে গিয়ে চুম্বন করলেন, আর ইস্‌হাক তাঁর বস্ত্রের গন্ধ নিয়ে তাঁকে আশীর্বাদ করে বললেন, “দেখ, আমার ছেলের সুগন্ধ সদাপ্রভুর আশীর্বাদযুক্ত ক্ষেত্রের সুগন্ধের মতো। ");
INSERT INTO benirv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ঈশ্বর আকাশের শিশির থেকে ও ভূমির উর্বরতা থেকে তোমাকে দিন; প্রচুর শস্য ও আঙ্গুরের রস তোমাকে দিন। ");
INSERT INTO benirv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","লোকবৃন্দ তোমার দাস হোক, জাতিরা তোমার কাছে নত হোক; তুমি নিজের আত্মীয়দের কর্তা হও, তোমার মায়ের ছেলেরা তোমার কাছে নত হোক। যে কেউ তোমাকে অভিশাপ দেয়, সে অভিশপ্ত হোক; যে কেউ তোমাকে আশীর্বাদ করে, সে আশীর্বাদযুক্ত হোক।” ");
INSERT INTO benirv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ইস্‌হাক যখন যাকোবের প্রতি আশীর্বাদ শেষ করলেন, তখন যাকোব নিজের পিতা ইস্‌হাকের সামনে থেকে যেতে না যেতেই তাঁর ভাই এষৌ শিকার করে ঘরে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","তিনিও সুস্বাদু খাবার তৈরী করে বাবার কাছে এনে বললেন, “বাবা আপনি উঠে ছেলের আনা পশুর মাংস ভোজন করুন, যেন আপনার প্রাণ আমাকে আশীর্বাদ করে।” ");
INSERT INTO benirv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","তাঁর বাবা ইস্‌হাক বললেন, “তুমি কে?” তিনি বললেন, “আমি আপনার বড় ছেলে এষৌ।” ");
INSERT INTO benirv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ইস্‌হাক ভীষণভাবে কেঁপে উঠে বললেন, “তবে সে কে, যে শিকার করে আমার কাছে পশুর মাংস এনেছিল? আমি তোমার আসবার আগেই তা ভোজন করে তাকে আশীর্বাদ করেছি, আর সেই আশীর্বাদযুক্ত থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","বাবার এই কথা শোনামাত্র এষৌ ভীষণ ব্যকুলভাবে কাঁদলেন এবং নিজের বাবাকে বললেন, “হে বাবা, আমাকে, আমাকেও আশীর্বাদ করুন।” ");
INSERT INTO benirv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ইস্‌হাক বললেন, “তোমার ভাই ছলনা করে এসে তোমার আশীর্বাদ নিয়ে নিয়েছে।” ");
INSERT INTO benirv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","এষৌ বললেন, “তার নাম কি যাকোব না? বাস্তবিক সে দু-বার আমাকে প্রতারণা করেছে; সে আমার বড় হওয়ার অধিকার নিয়ে নিয়েছিল এবং দেখুন, এখন আমার আশীর্বাদও নিয়ে নিয়েছে।” তিনি আবার বললেন, “আপনি কি আমার জন্য কিছুই আশীর্বাদ রাখেননি?” ");
INSERT INTO benirv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","তখন ইস্‌হাক উত্তর করে এষৌকে বললেন, “দেখ, আমি তাঁকে তোমার কর্তা করেছি এবং তার আত্মীয় সবাইকে তারই দাস করেছি এবং তাঁকে শস্য ও দ্রাক্ষারস দিয়ে সবল করেছি; বৎস, এখন তোমার জন্য আর কি করিতে পারি?” ");
INSERT INTO benirv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","এষৌ আবার নিজের বাবাকে বললেন, “হে বাবা, আপনার কি কেবল ঐ একটা আশীর্বাদ ছিল? হে বাবা, আমাকেও আশীর্বাদ করুন।” এই বলে এষৌ উচ্চৈঃস্বরে কাঁদতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","তখন তাঁর বাবা ইস্‌হাক উত্তর করে বললেন, “দেখ, তোমার বাসভূমি উর্বরতা বিহীন হবে। ");
INSERT INTO benirv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","তুমি তরোয়ালের জোরে বাঁচবে এবং নিজের ভাইয়ের দাস হবে; কিন্তু যখন তুমি বিদ্রোহ করবে, নিজের ঘাড় থেকে তার যোঁয়ালী ভাঙ্গবে।” ");
INSERT INTO benirv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","যাকোব নিজের বাবার কাছ থেকে আশীর্বাদ পেয়েছিলেন বলে এষৌ যাকোবকে হিংসা করতে লাগলেন। এষৌ মনে মনে বললেন, “আমার বাবার জন্য দুঃখ প্রকাশ করার দিন প্রায় উপস্থিত, তারপরে আমার ভাই যাকোবকে হত্যা করব।” ");
INSERT INTO benirv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","বড় ছেলে এষৌর এরকম কথা রিবিকার কানে গেল, তাতে তিনি লোক পাঠিয়ে ছোট ছেলে যাকোবকে ডাকালেন, বললেন, “দেখ, তোমার ভাই এষৌ তোমাকে হত্যা করবার আশাতেই মনকে সান্ত্বনা দিচ্ছে। ");
INSERT INTO benirv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","এখন, হে বৎস, আমার কথা শোনো; ওঠ, হারণে আমার ভাই লাবনের কাছে পালিয়ে যাও ");
INSERT INTO benirv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","সেখানে কিছু দিন থাক, যে পর্যন্ত তোমার ভাইয়ের রাগ না কমে। ");
INSERT INTO benirv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","তোমার প্রতি ভাইয়ের রাগ কমে গেলে এবং তুমি তার প্রতি যা করেছ, তা সে ভুলে গেলে আমি লোক পাঠিয়ে সেখান থেকে তোমাকে আনাব; এক দিনের তোমাদের দুই জনকেই কেন হারাব?” ");
INSERT INTO benirv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","রিবিকা ইসহাককে বললেন, “এই হিত্তীয়দের মেয়েদের বিষয় আমার প্রাণে ঘৃণা হচ্ছে; যদি যাকোবও এদের মতো কোনো হিত্তীয় মেয়েকে, এদেশীয় মেয়েদের মধ্যে কোনো মেয়েকে বিয়ে করে, তবে বেঁচে থেকে আমার কি লাভ?” ");
INSERT INTO benirv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","তখন ইসহাক যাকোবকে ডেকে আশীর্বাদ করলেন এবং এই আজ্ঞা দিয়ে তাঁকে বললেন, “তুমি কনান দেশীয় কোনো মেয়েকে বিয়ে কর না। ");
INSERT INTO benirv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ওঠ, পদ্দন অরামে নিজের দাদুর বথুয়েলের বাড়িতে গিয়ে সে জায়গায় নিজের মামা লাবনের কোনো মেয়েকে বিয়ে কর। ");
INSERT INTO benirv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","আর সর্বশক্তিমান ঈশ্বর তোমাকে আশীর্বাদ করে ফলবান ও বংশ বৃদ্ধি করুন, যেন তুমি বড় জাতি হয়ে ওঠ। ");
INSERT INTO benirv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","তিনি অব্রাহামের আশীর্বাদ তোমাকে ও তোমার বংশকে দিন; যেন তোমার বাসস্থান এই যে দেশ ঈশ্বর অব্রাহামকে দিয়েছেন, এতে তোমার অধিকার হয়।” ");
INSERT INTO benirv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","পরে ইসহাক যাকোবকে বিদায় করলে তিনি পদ্দন অরামে অরামীয় বথুয়েলের ছেলে লাবনের কাছে গেলেন; সেই ব্যক্তি যাকোবের ও এষৌর মা রিবিকার ভাই। ");
INSERT INTO benirv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","এষৌ যখন দেখলেন, ইসহাক যাকোবকে আশীর্বাদ করে বিবাহের মেয়ে গ্রহণের জন্য পদ্দন অরামে বিদায় করেছেন এবং আশীর্বাদের দিন কনানীয় কোনো মেয়েকে বিয়ে করতে নিষেধ করেছেন ");
INSERT INTO benirv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","তাই যাকোব মা বাবার আদেশ মেনে পদ্দন অরামে গিয়েছেন, ");
INSERT INTO benirv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","তখন এষৌ দেখলেন যে, কনানীয় মেয়েরা তাঁর বাবা ইসহাকের অসন্তোষের পাত্রী; ");
INSERT INTO benirv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","অতএব দুই স্ত্রী থাকলেও এষৌ ইশ্মায়েলের কাছে গিয়ে অব্রাহামের ছেলে ইশ্মায়েলের মেয়ে, নবায়তের বোন, মহলৎকে বিয়ে করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","আর যাকোব বের-শেবা থেকে বের হয়ে হারনের দিকে গেলেন ");
INSERT INTO benirv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","কোনো এক জায়গায় পৌঁছালে সূর্য্য অস্ত যাওয়ায় সেখানে রাত কাটালেন। আর তিনি সেখানকার পাথর নিয়ে বালিশ করে সেই জায়গায় ঘুমানোর জন্য শুয়ে পড়লেন। ");
INSERT INTO benirv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","পরে তিনি স্বপ্ন দেখলেন, পৃথিবীর উপরে এক সিঁড়ি স্থাপিত, তার মাথা আকাশছোঁয়া, আর দেখ তা দিয়ে ঈশ্বরের দূতেরা উঠছেন ও নামছেন। ");
INSERT INTO benirv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","আর দেখ, সদাপ্রভু তার উপরে দাঁড়িয়ে আছেন; তিনি বললেন, “আমি সদাপ্রভু, তোমার বাবা অব্রাহামের ঈশ্বর ও ইসহাকের ঈশ্বর; এই যে ভূমিতে তুমি শুয়ে আছ, এটা আমি তোমাকে ও তোমার বংশকে দেব। ");
INSERT INTO benirv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","তোমার বংশ পৃথিবীর ধূলোর মতো অসংখ্য হবে এবং তুমি পশ্চিম ও পূর্ব, উত্তর ও দক্ষিণ চারদিকে বিস্তীর্ণ হবে এবং তোমাতে ও তোমার বংশে পৃথিবীর যাবতীয় গোষ্ঠী আশীর্বাদ প্রাপ্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","আর দেখ, আমি তোমার সহবর্ত্তী, যে যে জায়গায় তুমি যাবে, সেই সেই জায়গায় তোমাকে রক্ষা করব ও আবার এই দেশে নিয়ে আসব; কারণ আমি তোমাকে যা যা বললাম, তা যতক্ষণ সফল না করি, ততক্ষণ তোমাকে ত্যাগ করব না।” ");
INSERT INTO benirv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","পরে ঘুম ভেঙে গেলে যাকোব বললেন, “অবশ্য এই জায়গায় সদাপ্রভু আছেন, আর আমি তা জানতাম না।” ");
INSERT INTO benirv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","আর তিনি ভয় পেয়ে বললেন, “এ কেমন ভয়াবহ জায়গা! এ নিতান্তই ঈশ্বরের গৃহ, এ স্বর্গের দরজা।” ");
INSERT INTO benirv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","পরে যাকোব ভোরবেলায় উঠে বালিশের জন্য যে পাথর রেখেছিলেন, তা নিয়ে স্তম্ভরূপে স্থাপন করে তার উপর তেল ঢেলে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","আর সেই জায়গার নাম বৈথেল ঈশ্বরের গৃহ রাখলেন, কিন্তু আগে ঐ নগরের নাম লূস ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","যাকোব মানত করে এই প্রতিজ্ঞা করলেন, “যদি ঈশ্বর আমার সহবর্ত্তী হন, আমার এই গন্তব্য পথে আমাকে রক্ষা করেন এবং আহারের জন্য খাবার ও পরিধানের জন্য বস্ত্র দেন, ");
INSERT INTO benirv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","আর আমি যদি ভালোভাবে বাবার বাড়ি ফিরে যেতে পারি, তবে সদাপ্রভু আমার ঈশ্বর হবেন ");
INSERT INTO benirv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","এবং এই যে পাথর আমি স্তম্ভরূপে স্থাপন করেছি, এটা ঈশ্বরের গৃহ হবে; আর তুমি আমাকে যা কিছু দেবে, তার দশমাংশ আমি তোমাকে অবশ্য দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","পরে যাকোব পূর্বদিকের লোকদের দেশে গেলেন। সেখানে দেখলেন, মাঠের মধ্যে এক কূপ আছে, ");
INSERT INTO benirv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","আর দেখ, তার কাছে ভেড়ার তিনটি পাল শুয়ে আছে; কারণ লোকে ভেড়ার পাল সকলকে সেই কুয়োর জল পান করাত; আর সেই কূপের মুখে একটা বড় পাথর ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","সেই জায়গায় পাল সকল জড়ো করা হলে লোকে কুয়োর মুখ থেকে পাথরখানা সরিয়ে ভেড়াদের জল পান করাত, পরে আবার কুয়োর মুখে সঠিক জায়গায় সেই পাথর রাখত। ");
INSERT INTO benirv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","যাকোব তাদেরকে বললেন, “ভাই সব, তোমরা কোন জায়গার লোক?” তারা বলল, “আমরা হারনের লোক।” ");
INSERT INTO benirv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","তিনি বললেন, “নাহরের নাতি লাবণকে চেনো কি না?” তারা বলল, “চিনি।” ");
INSERT INTO benirv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","তিনি বললেন, “সে ভালো আছে তো?” তারা বলল, “ভালো;” দেখ, তাঁর মেয়ে রাহেল ভেড়ার পাল নিয়ে আসছেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","তখন তিনি বললেন, “দেখ, এখনও অনেক বেলা আছে; পশুপাল জড়ো করার দিন হয়নি; তোমরা মেষদেরকে জল পান করিয়ে আবার চরাতে নিয়ে যাও।” ");
INSERT INTO benirv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","তারা বলল, “যতক্ষণ পাল সব জড়ো না হয়, ততক্ষণ আমরা তা করতে পারি না; পরে কুয়োর মুখ থেকে পাথর খানা সরান যায়; তখন আমরা ভেড়াদের জল পান করাই।” ");
INSERT INTO benirv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","যাকোব তাদের সঙ্গে এরকম কথাবার্তা বলছেন, এমন দিনের রাহেল নিজের বাবার মেষপাল নিয়ে উপস্থিত হলেন, কারণ তিনি ভেড়াপালিকা ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","তখন যাকোব নিজের মামা লাবনের মেয়ে রাহেলকে ও মামার ভেড়ার পালকে দেখামাত্র কাছে গিয়ে কুয়োর মুখ থেকে পাথরখানা সরিয়ে তাঁর মামা লাবনের ভেড়ার পালকে জল পান করালেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","পরে যাকোব রাহেলকে চুম্বন করে উচ্চৈঃস্বরে কাঁদতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","আপনি যে তাঁর বাবার কুটুম্ব ও রিবিকার ছেলে, যাকোব রাহেলকে এই পরিচয় দিলে রাহেল দৌড়ে গিয়ে নিজের বাবাকে সংবাদ দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","তাতে লাবন তাঁর ভাগ্নে যাকোবের সংবাদ পেয়ে দৌড়ে তাঁর সঙ্গে দেখা করতে গেলেন, তাঁকে আলিঙ্গন ও চুম্বন করলেন ও নিজের বাড়িতে নিয়ে গেলেন; পরে তিনি লাবণকে বলা সমস্ত বৃত্তান্ত জানালেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","তাতে লাবন বললেন, “তুমি সত্যিই আমার হাড় ও আমার মাংস।” পরে যাকোব তাঁর বাড়িতে এক মাস বাস করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","পরে লাবন যাকোবকে বললেন, “তুমি আত্মীয় বলে কি বিনা বেতনে আমার দাসের কাজ করবে? বল দেখি, কি বেতন নেবে?” ");
INSERT INTO benirv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","লাবনের দুই মেয়ে ছিলেন; বড়টার নাম লেয়া ও ছোটটার নাম রাহেল। ");
INSERT INTO benirv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","লেয়া মৃদুলোচনা, কিন্তু রাহেল রূপবতী ও সুন্দরী ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","আর যাকোব রাহেলকে ভালবাসতেন, এজন্য তিনি উত্তর করলেন, “আপনার ছোট মেয়ে রাহেলের জন্য আমি সাত বছর আপনার দাসের কাজ করব।” ");
INSERT INTO benirv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","লাবন বললেন, “অন্য পাত্রকে দান করার থেকে তোমাকে দান করা ভালো বটে; আমার কাছে থাক।” ");
INSERT INTO benirv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","এই ভাবে যাকোব রাহেলের জন্য সাত বছর দাসের কাজ করলেন; রাহেলের প্রতি তাঁর ভালোবাসার জন্য এক এক বছর তাঁর কাছে এক এক দিন মনে হল। ");
INSERT INTO benirv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","পরে যাকোব লাবণকে বললেন, “আমার নিয়মিত কাল সম্পূর্ণ হল, এখন আমার স্ত্রী আমাকে দিন, আমি তার কাছে যাব।” ");
INSERT INTO benirv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","তখন লাবন ঐ জায়গার সব লোককে জড়ো করে ভোজ প্রস্তুত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","আর সন্ধ্যাবেলায় তিনি নিজের মেয়ে লেয়াকে নিয়ে তাঁর কাছে এনে দিলেন, আর যাকোব তাঁর কাছে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","আর লাবন সিল্পা নামে নিজের দাসীকে নিজের মেয়ে লেয়ার দাসী বলে তাঁকে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","আর সকাল হলে, দেখ, তিনি লেয়া। তাতে যাকোব লাবনকে বললেন, “আপনি আমার সঙ্গে এ কি ব্যবহার করলেন? আমি কি রাহেলের জন্য আপনার দাসের কাজ করিনি? তবে কেন আমাকে প্রতারণা করলেন?” ");
INSERT INTO benirv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","তখন লাবন বললেন, “বড়র আগে ছোটকে দান করা আমাদের এই জায়গায় কর্তব্য নয়। ");
INSERT INTO benirv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","তুমি এর সপ্তাহ পূর্ণ কর; পরে আর সাত বছর আমার দাসের কাজ স্বীকার করবে, সেজন্য আমরা ওকেও তোমাকে দান করব।” ");
INSERT INTO benirv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","তাতে যাকোব সেই রকম করলেন, তাঁর সপ্তাহ পূর্ণ করলেন; পরে লাবন তাঁর সঙ্গে নিজের মেয়ে রাহেলের বিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","আর লাবন বিলহা নামে নিজের দাসীকে রাহেলের দাসী বলে তাঁকে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","তাই তিনি রাহেলের কাছেও গেলেন এবং লেয়ার থেকে রাহেলকে বেশি ভালবাসলেন এবং আরও সাত বছর লাবনের কাছে দাসের কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","পরে সদাপ্রভু লেয়াকে অবজ্ঞা করা দেখে তাঁর গর্ভ মুক্ত করলেন, কিন্তু রাহেল বন্ধ্যা হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","আর লেয়া গর্ভবতী হয়ে ছেলের জন্ম দিলেন ও তার নাম রুবেন ছেলেকে দেখ রাখলেন; কারণ তিনি বললেন, “সদাপ্রভু আমার দুঃখ দেখেছেন; এখন আমার স্বামী আমাকে ভালবাসবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","পরে তিনি আবার গর্ভবতী হয়ে ছেলের জন্ম দিয়ে বললেন, “সদাপ্রভু শুনেছেন যে, আমি ঘৃণার পাত্রী, তাই আমাকে এই ছেলেও দিলেন;” আর তার নাম শিমিয়ন শ্রবন রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","আবার তিনি গর্ভবতী হয়ে ছেলের জন্ম দিয়ে বললেন, “এ বার আমার স্বামী আমাতে আসক্ত হবেন, কারণ আমি তাঁর জন্য তিন ছেলের জন্ম দিয়েছি;” অতএব তার নাম, লেবি আসক্ত রাখা গেল। ");
INSERT INTO benirv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","পরে আবার তাঁর গর্ভ হলে তিনি ছেলের জন্ম দিয়ে বললেন, “এ বার আমি সদাপ্রভুর স্তব গান করি;” অতএব তিনি তার নাম যিহূদা স্তব রাখলেন। তারপরে তাঁর গর্ভ বন্ধ হল। ");
INSERT INTO benirv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","রাহেল যখন দেখলেন, তিনি যাকোবের কোনো ছেলেমেয়ের জন্ম দেননি, তখন তিনি তাঁর বোনের প্রতি ঈর্ষা করলেন ও যাকোবকে বললেন, “আমাকে সন্তান দাও, না হয় আমি মরব।” ");
INSERT INTO benirv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","তাতে রাহেলের প্রতি যাকোবের রাগ হল; তিনি বললেন, “আমি কি ঈশ্বরের প্রতিনিধি?” তিনিই তোমাকে গর্ভফল দিতে অস্বীকার করেছেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","তখন রাহেল বললেন, “দেখ, আমার দাসী বিলহা আছে, ওর কাছে যাও; যেন ও ছেলের জন্ম দিয়ে আমার কোলে দেয় এবং ওর মাধ্যমে আমিও ছেলেমেয়ের মা হব।” ");
INSERT INTO benirv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","এই বলে তিনি তাঁর সঙ্গে নিজের দাসী বিলহার বিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","তখন যাকোব তার কাছে গেলেন, আর বিলহা গর্ভবতী হয়ে যাকোবের জন্য ছেলের জন্ম দিল। ");
INSERT INTO benirv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","তখন রাহেল বললেন, “ঈশ্বর আমার বিচার করলেন এবং আমার রবও শুনে আমাকে ছেলে দিলেন;” তাই তিনি তার নাম দান বিচার রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","পরে রাহেলের বিলহা দাসী আবার গর্ভবতী হয়ে যাকোবের জন্য দ্বিতীয় ছেলের জন্ম দিল। ");
INSERT INTO benirv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","তখন রাহেল বললেন, “আমি বোনের সঙ্গে ঈশ্বর সম্বন্ধীয় কুস্তি করে জয়লাভ করলাম;” আর তিনি তার নাম নপ্তালি কুস্তি রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","পরে লেয়া নিজের গর্ভ বন্ধ হলে বুঝে নিজের দাসী সিল্পাকে নিয়ে যাকোবের সঙ্গে বিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","তাতে লেয়ার দাসী সিল্পা যাকোবের জন্য এক ছেলের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","তখন লেয়া বললেন, “সৌভাগ্য হল;” আর তার নাম গাদ সৌভাগ্য রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","পরে লেয়ার দাসী সিল্পা যাকোবের জন্য দ্বিতীয় ছেলের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","তখন লেয়া বললেন, “আমি ধন্যা, যুবতীরা আমাকে ধন্যা বলবে;” আর তিনি তার নাম আশের ধন্য রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","আর গম কাটার দিনের রুবেন বাইরে গিয়ে ক্ষেতে দুদাফল পেয়ে নিজের মা লেয়াকে এনে দিল; তাতে রাহেল লেয়াকে বললেন, “তোমার ছেলের কতগুলি দুদাফল আমাকে দাও না।” ");
INSERT INTO benirv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","তাতে তিনি বললেন, “তুমি আমার স্বামীকে হরণ করেছ, এ কি ছোট ব্যাপার? আমার ছেলের দুদাফলও কি হরণ করবে?” তখন রাহেল বললেন, “তবে তোমার ছেলের দুদাফলের পরিবর্তে তিনি আজ রাতে তোমার সঙ্গে শোবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","পরে সন্ধ্যাবেলা ক্ষেত্র থেকে যাকোবের আসার দিনের লেয়া বাইরে তাঁর কাছে গিয়ে বললেন, “আমার কাছে আসতে হবে, কারণ আমি নিজের ছেলের দুদাফল দিয়ে তোমাকে ভাড়া করেছি;” তাই সেই রাত্রিতে তিনি তাঁর সঙ্গে শয়ন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","আর ঈশ্বর লেয়ার প্রার্থনা শোনাতে তিনি গর্ভবতী হয়ে যাকোবের জন্য পঞ্চম ছেলের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","তখন লেয়া বললেন, “আমি স্বামীকে নিজের দাসী দিয়েছিলাম, তার বেতন ঈশ্বর আমাকে দিলেন; আর তিনি তার নাম ইষাখর বেতন রাখলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","পরে লেয়া আবার গর্ভধারন করে যাকোবের জন্য ষষ্ঠ ছেলের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","তখন লেয়া বললেন, “ঈশ্বর আমাকে উত্তম উপহার দিলেন, এখন আমার স্বামী আমার সঙ্গে বাস করবেন, কারণ আমি তাঁর জন্য ছয় ছেলের জন্ম দিয়েছি;” আর তিনি তার নাম সবূলূন বাস রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","তারপরে তাঁর এক মেয়ে জন্মাল, আর তিনি তার নাম দীণা রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","আর ঈশ্বর রাহেলকে স্মরণ করলেন, ঈশ্বর তাঁর প্রার্থনা শুনলেন, তাঁর গর্ভ মুক্ত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","তখন তাঁর গর্ভ হলে তিনি ছেলের জন্ম দিয়ে বললেন, “ঈশ্বর আমার অপযশ হরণ করেছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","আর তিনি তার নাম যোষেফ বৃদ্ধি রাখলেন, বললেন, “সদাপ্রভু আমাকে আরো এক ছেলে দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","আর রাহেলের গর্ভে যোষেফ জন্মালে পর যাকোব লাবণকে বললেন, “আমাকে বিদায় করুন, আমি নিজের জায়গায়, নিজ দেশে, চলে যাই; ");
INSERT INTO benirv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","আমি যাদের জন্য আপনার দাসত্ব করেছি, আমার সেই স্ত্রীদেরকে ও ছেলেমেয়েদেরকে আমার হাতে সমর্পণ করে আমাকে যেতে দিন; কারণ আমি যেমন পরিশ্রমে আপনার দাসত্ব করেছি, তা আপনি জানেন।” ");
INSERT INTO benirv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","তখন লাবন তাঁকে বললেন, “আমি যদি তোমার দৃষ্টিতে অনুগ্রহ পেয়ে থাকি তবে থাক; কারণ আমি অনুভবে জানলাম, তোমার অনুরোধে সদাপ্রভু আমাকে আশীর্বাদ করলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","তিনি আরও বললেন, “তোমার বেতন ঠিক করে আমাকে বল, আমি দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","তখন যাকোব তাঁকে বললেন, “আমি যেমন আপনার দাসত্ব করেছি এবং আমার কাছে আপনার যেমন পশুধন হয়েছে, তা আপনি জানেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","কারণ আমার আসবার আগে আপনার অল্প সম্পত্তি ছিল, এখন বৃদ্ধি পেয়ে প্রচুর হয়েছে; আমার যত্নে সদাপ্রভু আপনাকে আশীর্বাদ করেছেন; কিন্তু আমি নিজ পরিবারের জন্য কবে সঞ্চয় করব?” ");
INSERT INTO benirv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","তাতে লাবন বললেন, “আমি তোমাকে কি দেব?” যাকোব বললেন, “আপনি আমাকে আর কিছুই না দিয়ে যদি আমার জন্য একটা কাজ করেন, তবে আমি আপনার পশুদেরকে আবার চড়াব ও পালন করব। ");
INSERT INTO benirv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","আজ আমি আপনার সব পশুপালের মধ্য দিয়ে যাব; আমি ভেড়াদের মধ্যে বিন্দুচিহ্নিত ও দাগযুক্ত ও কৃষ্ণবর্ণ সকল এবং ছাগলদের মধ্যে দাগযুক্ত ও বিন্দু চিহ্নিত সকলকে পৃথক করি; সেগুলি আমার বেতন হবে। ");
INSERT INTO benirv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","এর পরে যখন আপনার সামনে উপস্থিত বেতনের জন্য আপনি আসবেন, তখন আমার ধার্ম্মিকতা আমার পক্ষে উত্তর দেবে; ফলে ছাগলদের বিন্দুচিহ্নিত কি দাগযুক্ত ছাড়া ও মেষেদের মধ্যে কৃষ্ণবর্ণ ছাড়া যা থাকবে, তা আমার চুরি রূপে গণ্য হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","তখন লাবন বললেন, “দেখ, তোমার বাক্যানুসারেই হোক।” ");
INSERT INTO benirv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","পরে তিনি সেই দিন রেখাঙ্কিত ও দাগযুক্ত ছাগল সকল এবং বিন্দুচিহ্নিত ও দাগযুক্তদের মধ্য কিছু সাদাবর্ণ ছিল, এমন ছাগী সকল এবং কালো রঙের ভেড়া সকল আলাদা করে নিজের ছেলেদের হাতে দিলেন ");
INSERT INTO benirv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","এবং আপনার ও যাকোবের মধ্যে তিন দিনের পথ ব্যবধান রাখলেন। আর যাকোব লাবনের অবশিষ্ট পশুপাল চরাতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","আর যাকোব লিবনী, লুস ও আমোণ গাছের সরস শাখা কেটে তার ছাল খুলে কাঠের সাদা রেখা বের করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","পরে যে জায়গায় পশুপাল জল পানের জন্য আসে, সেই জায়গায় পালের সামনে জল পান করার জায়গার মধ্যে ঐ ত্বকশূন্য রেখাবিশিষ্ট শাখা সকল রাখতে লাগলেন; তাতে জল পান করবার দিনের তারা গর্ভ ধারন করত। ");
INSERT INTO benirv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","আর সেই শাখার কাছে তাদের গর্ভধারণের জন্য রেখাঙ্কিত ও বিন্দুচিহ্নিত ও দাগযুক্ত বৎস জন্মাত। ");
INSERT INTO benirv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","পরে যাকোব সেই সব বৎস আলাদা করতেন এবং লাবনের রেখাঙ্কিত ও কালো রঙের ভেড়ার প্রতি স্ত্রী ভেড়াদের দৃষ্টি রাখতেন; এই ভাবে তিনি লাবনের পালের সঙ্গে না রেখে নিজের পালকে আলাদা করতেন। ");
INSERT INTO benirv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","আর বলবান পশুরা যেন শাখার কাছে গর্ভধারন করে, এই জন্য জল পান করার জায়গার মধ্যে পশুদের সামনে ঐ শাখা রাখতেন; ");
INSERT INTO benirv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","কিন্তু দুর্বল পশুদের সামনে রাখতেন না। তাতে দুর্বল পশুরা লাবনের ও বলবান পশুরা যাকোবের হত। ");
INSERT INTO benirv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","আর যাকোব খুব সমৃদ্ধিশালী হলেন এবং তাঁর পশু ও দাস দাসী এবং উট ও গাধা যথেষ্ট হল। ");
INSERT INTO benirv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","পরে তিনি লাবনের ছেলেদের এই কথা শুনতে পেলেন, যাকোব আমাদের বাবার সব কিছু কেড়ে নিয়েছে, আমাদের বাবার সম্পত্তি থেকে তার এই সব ঐশ্বর্য্য হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","আর যাকোব লাবনের মুখ দেখলেন, আর দেখ, তা আর তাঁর প্রতি আগের মত নয়। ");
INSERT INTO benirv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","আর সদাপ্রভু যাকোবকে বললেন, “তুমি নিজের বাবার দেশে আত্মীয়দের কাছে ফিরে যাও, আমি তোমার সঙ্গী হব। ");
INSERT INTO benirv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","তাই যাকোব লোক পাঠিয়ে মাঠে পশুদের কাছে রাহেল ও লেয়াকে ডেকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","আমি তোমাদের বাবার মুখ দেখে বুঝতে পারছি, তা আর আমার কাছে আগের মত নয়, কিন্তু আমার বাবার ঈশ্বর আমার সহবর্ত্তী রয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","আর তোমরা নিজেরা জান, আমি যথাশক্তি তোমাদের বাবার দাসত্ব করেছি। ");
INSERT INTO benirv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","তোমার বাবা আমাকে প্রবঞ্চনা করে দশ বার আমার বেতন অন্যথা করেছেন; কিন্তু ঈশ্বর তাঁকে আমার ক্ষতি করতে দেননি। ");
INSERT INTO benirv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","কারণ যখন তিনি বলতেন, বিন্দুচিহ্নিত পশুরা তোমার বেতন স্বরূপ হবে, তখন সব পাল বিন্দু চিহ্নিত শাবক প্রসব করত এবং যখন বলতেন, দাগযুক্ত পশু সব তোমার বেতন স্বরূপ হবে, তখন মেষরা সব দাগযুক্ত শাবক প্রসব করত। ");
INSERT INTO benirv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","এভাবে ঈশ্বর তোমাদের বাবার পশুধন নিয়ে আমাকে দিয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","পশুদের গর্ভধারনের দিনের আমি স্বপ্নে চোখ তুলে দেখলাম, আর দেখ, পালের মধ্যে স্ত্রী পশুদের উপরে যত পুরুষ পশু উঠছে, সকলেই দাগযুক্ত ও চিত্রবিচিত্র। ");
INSERT INTO benirv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","তখন ঈশ্বরের দূত স্বপ্নে আমাকে বললেন, “হে যাকোব;” আর আমি বললাম, “দেখুন, এই আমি।” ");
INSERT INTO benirv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","তিনি বললেন, “তোমার চোখ তুলে দেখ, স্ত্রীপশুদের ওপরে যত পুরুষ পশু উঠছে, সকলেই রেখাঙ্কিত, দাগযুক্ত ও চিত্রবিচিত্র; কারণ, লাবন তোমার প্রতি যা যা করে, তা সবই আমি দেখলাম। ");
INSERT INTO benirv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","যে জায়গায় তুমি স্তম্ভের অভিষেক ও আমার কাছে মানত করেছ, সেই বৈথেলের ঈশ্বর আমি; এখন উঠ, এই দেশ ত্যাগ করে নিজের জন্মভূমিতে ফিরে যাও।” ");
INSERT INTO benirv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","তখন রাহেল ও লেয়া উত্তর করে তাঁকে বললেন, “বাবার বাড়িতে আমাদের কি আর কিছু অংশ ও অধিকার আছে? ");
INSERT INTO benirv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","আমরা কি তাঁর কাছে বিদেশীদের মতো না? তিনি তো আমাদেরকে বিক্রি করেছেন এবং আমাদের রূপা নিজে ভোগ করেছেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ঈশ্বর আমাদের বাবা থেকে যে সব সম্পত্তি কেড়ে নিয়েছেন, সে সবই আমাদের ও আমাদের ছেলে মেয়েদের। তাই ঈশ্বর তোমাকে যা কিছু বলেছেন, তুমি তাই কর।” ");
INSERT INTO benirv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","তখন যাকোব উঠে আপন ছেলেদের ও স্ত্রীদেরকে উটে চড়িয়ে আপনার উপার্জিত সমস্ত পশুধন, ");
INSERT INTO benirv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","অর্থাৎ পদ্দন অরামে যে পশু ও যে সম্পত্তি উপার্জন করেছিলেন, তা নিয়ে কনান দেশে নিজের বাবা ইসহাকের কাছে যাত্রা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","সে দিন লাবন ভেড়ার লোম কাটতে গিয়েছিলেন; তখন রাহেল নিজের বাবার ঠাকুরগুলাকে চুরি করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","আর যাকোব নিজের পালানোর কোনো খবর না দিয়ে অরামীয় লাবণকে ঠকালেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","তিনি নিজের সর্বস্ব নিয়ে পালিয়ে গেলেন এবং উঠে ফরাৎ নদী পার হয়ে গিলিয়দ পর্বত সামনে রেখে চলতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","পরে তৃতীয় দিনের লাবন যাকোবের পালানোর খবর পেলেন ");
INSERT INTO benirv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","এবং নিজের আত্মীয়দেরকে সঙ্গে নিয়ে সাত দিনের র পথ তাঁর পেছনে গেলেন ও গিলিয়দ পর্বতে তাঁর দেখা পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","কিন্তু ঈশ্বর রাতে স্বপ্নযোগে অরামীয় লাবনের কাছে উপস্থিত হয়ে তাঁকে বললেন, “সাবধান, যাকোবকে ভাল মন্দ কিছুই বোলো না।” ");
INSERT INTO benirv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","লাবন যখন যাকোবের দেখা পেলেন, তখন যাকোবের তাঁবু পর্বতের ওপরে স্থাপিত ছিল; তাতে লাবণও কুটুম্বদের সঙ্গে গিলিয়দ পর্বতের ওপরে তাঁবু স্থাপন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","পরে লাবন যাকোবকে বললেন, “তুমি কেন এমন কাজ করলে? আমাকে ঠকিয়ে আমার যেমন তরোয়াল দিয়ে বন্দী বানানো হয় সেই বন্দিদের মত কেন আমার মেয়েদেরকে নিয়ে আসলে? ");
INSERT INTO benirv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","তুমি আমাকে বঞ্চনা করে কেন গোপনে পালালে? কেন আমাকে খবর দিলে না? দিলে আমি তোমাকে উদযাপন ও গান এবং খঞ্জনির ও বীণার বাজনা দিয়ে বিদায় করতাম। ");
INSERT INTO benirv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","তুমি আমার নাতি ও মেয়েদেরকে চুমু দিতে আমাকে দিলে না; এ মূর্খের কাজ করেছ। ");
INSERT INTO benirv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","তোমাদের ক্ষতি করতে আমার হাতে শক্তি আছে;” কিন্তু গত রাতে তোমাদের বাবার ঈশ্বর আমাকে বললেন, “সাবধান, যাকোবকে ভাল খারাপ কিছুই বল না। ");
INSERT INTO benirv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","আর এখন, তুমি দূরে চলে গেছ কারণ তুমি তোমার বাবার বাড়ির জন্য অনেক প্রত্যাশিত; কিন্তু আমার দেবতাদেরকে কেন চুরি করলে?” ");
INSERT INTO benirv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","যাকোব লাবনকে উত্তরে বললেন, “আমি ভয় পেয়েছিলাম; কারণ ভেবেছিলাম, যদি আপনি আমার কাছ থেকে আপনার মেয়েদেরকে জোর করে কেড়ে নেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","আপনি যার কাছে আপনার দেবতাদেরকে পাবেন, সে বাঁচবে না। আমাদের আত্মীদের কাছে খোঁজ নিয়ে আমার কাছে আপনার যা আছে, তা নিন।” আসলে যাকোব জানতেন না যে, রাহেল সেগুলো চুরি করেছেন৷ ");
INSERT INTO benirv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","তখন লাবন যাকোবের তাঁবুতে ও লেয়ার তাঁবুতে ও দুই দাসীর তাঁবুতে প্রবেশ করলেন, কিন্তু পেলেন না। পরে তিনি লেয়ার তাঁবু থেকে রাহেলের তাঁবুতে প্রবেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","কিন্তু রাহেল সেই ঠাকুরগুলাকে নিয়ে উটের গদীর ভেতরে রেখে তাদের ওপরে বসে ছিলেন; সে জন্য লাবন তাঁর তাঁবুর সব জায়গায় হাতড়ালেও তাদেরকে পেলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","তখন রাহেল বাবাকে বললেন, “প্রভু, আপনার সামনে আমি উঠতে পারলাম না, এতে বিরক্ত হবেন না, কারণ আমার ঋতুচক্র চলছে।” এভাবে তিনি খোঁজ করলেও সেই ঠাকুরগুলাকে পেলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","তখন যাকোব রেগে গিয়ে লাবনের সঙ্গে ঝগড়া করতে লাগলেন। যাকোব লাবনকে বললেন, “আমার অপরাধ কি, ও আমার পাপ কি যে, তুমি রেগে গিয়ে আমার পেছনে পেছনে দৌড়ে এসেছো? ");
INSERT INTO benirv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","তুমি আমার সব জিনিসপত্র হাতড়িয়ে তোমার বাড়ির কোন জিনিস পেলে? আমার ও তোমার এই আত্মীয়দের সামনে তা রাখ, এরা উভয় পক্ষের বিচার করুন। ");
INSERT INTO benirv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","এই কুড়ি বছর আমি তোমার কাছে আছি; তোমার ভেড়ীদের কি ছাগীদের গর্ভপাত হয়নি এবং আমি তোমার পালের ভেড়াদের খাইনি; ");
INSERT INTO benirv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","পশুতে ছিন্নভিন্ন করা ভেড়া তোমার কাছে আনতাম না; সে ক্ষতি নিজে স্বীকার করতাম; দিনের কিম্বা রাতে যা চুরি হত, তার পরিবর্তে তুমি আমার কাছ থেকে নিতে ");
INSERT INTO benirv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","আমার এরকম দশা হত, আমি দিনের র তাপ ও রাতে শীত ভোগ করতাম, ঘুম আমার চোখ থেকে দূরে পালিয়ে যেত। ");
INSERT INTO benirv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","এই কুড়ি বছর আমি তোমার বাড়িতে আছি; তোমার দুই মেয়ের জন্য চোদ্দ বছর, আর তোমার পশুদের জন্য ছয় বছর দাসবৃত্তি করেছি; এর মধ্যে তুমি দশ বার আমার বেতন অন্যথা করেছ। ");
INSERT INTO benirv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","আমার বাবার ঈশ্বর, অব্রাহামের ঈশ্বর ও ইস্‌হাকের ভয়স্থান যদি আমার পক্ষ না হতেন, তবে অবশ্য এখন তুমি আমাকে খালি হাতে বিদায় করতে। ঈশ্বর আমার দুঃখ ও হাতের পরিশ্রম দেখেছেন, এ জন্য গত রাত্রে তোমাকে ধমকালেন।” ");
INSERT INTO benirv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","তখন লাবন উত্তর করে যাকোবকে বললেন, “এই মেয়েরা আমারই মেয়ে, এই ছেলেরা আমারই ছেলে এবং এই পশুরা আমারই পশু; যা যা দেখছ, এ সবই আমার। এখন আমার এই মেয়েদেরকে ও এদের প্রস্তুত এই ছেলেদের কে আমি কি করব? ");
INSERT INTO benirv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","এস তোমাতে ও আমাতে নিয়ম স্থির করি, তা তোমার ও আমার সাক্ষী থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","তখন যাকোব এক পাথর নিয়ে স্তম্ভরূপে স্থাপন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","আর যাকোব নিজের আত্মীয়দেরকে বললেন, আপনারাও পাথর সংগ্রহ করুন। তাতে তাঁরা পাথর এনে এক রাশি করলেন এবং সেই জায়গায় ঐ রাশির কাছে ভোজন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","আর লাবন তার নাম যিগর-সাহদূখা সাক্ষি-রাশি রাখলেন, কিন্তু যাকোব তার নাম গল-এদ সাক্ষি-রাশি রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","তখন লাবন বললেন, “এই রাশি আজ তোমার ও আমার সাক্ষী থাকল। এই জন্য তার নাম গিলিয়দ” ");
INSERT INTO benirv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","এছাড়া মিস্পা নামে প্রহরী স্থান রাখা গেল; কারণ তিনি বললেন, “আমরা পরস্পর অদৃশ্য হলে সদাপ্রভু আমার ও তোমার প্রহরী থাকবেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","তুমি যদি আমার মেয়েদেরকে দুঃখ দাও আর যদি আমার মেয়ে ছাড়া অন্য স্ত্রীকে বিয়ে কর, তবে কোন মানুষ আমার কাছে থাকবে না বটে, কিন্তু দেখ, ঈশ্বর আমার ও তোমার সাক্ষী হবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","লাবন যাকোবকে আর ও বললেন, “এই রাশি দেখ ও এই স্তম্ভ দেখ, আমার ও তোমার মধ্যে আমি এটা স্থাপন করলাম। ");
INSERT INTO benirv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","হিংসাভাবে আমিও এই রাশি পার হয়ে তোমার কাছে যাব না এবং তুমিও এই রাশি ও এই স্তম্ভ পার হয়ে আমার কাছে আসবে না, এর সাক্ষী এই রাশি ও এর সাক্ষী এই স্তম্ভ; ");
INSERT INTO benirv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","অব্রাহামের ঈশ্বর, নাহোরের ঈশ্বর ও তাঁদের বাবার ঈশ্বর আমাদের মধ্যে বিচার করবেন।” তখন যাকোব নিজের বাবা ইসহাকের ভয়স্থানের শপথ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","পরে যাকোব সেই পর্বতে বলিদান করে আহার করতে নিজের আত্মীদের নিমন্ত্রণ করলেন, তাতে তারা ভোজন করে পর্বতে রাত্ কাটালেন। ");
INSERT INTO benirv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","পরে লাবন সকালে উঠে নিজের নাতি মেয়েদেরকে চুম্বনপূর্বক আশীর্বাদ করলেন। আর লাবন নিজের জায়গায় ফিরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","আর যাকোব নিজের পথে এগিয়ে গেলে ঈশ্বরের দূতেরা তাঁর সঙ্গে দেখা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","তখন যাকোব তাঁদেরকে দেখে বললেন, “এ ঈশ্বরের সেনাদল, তাই সেই জায়গার নাম মহনয়িম রাখলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","তার পর যাকোব নিজের আগে সেয়ীর দেশের ইদোম অঞ্চলে তাঁর ভাই এষৌর কাছে দূতদেরকে পাঠালেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","তিনি তাদেরকে এই আজ্ঞা করলেন, “তোমরা আমার প্রভু এষৌকে বলবে, আপনার দাস যাকোব আপনাকে জানালেন, আমি লাবনের কাছে বাস করছিলাম, এ পর্যন্ত থেকেছি। ");
INSERT INTO benirv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","আমার গরু, গাধা, ভেড়ার পাল ও দাস দাসী আছে, আর আমি প্রভুর অনুগ্রহ দৃষ্টি পাবার জন্য আপনাকে খবর পাঠালাম।” ");
INSERT INTO benirv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","পরে দূতেরা যাকোবের কাছে ফিরে এসে বলল, “আমরা আপনার ভাই এষৌর কাছে গিয়েছিলাম; আর তিনি চারশো লোক সঙ্গে নিয়ে আপনার সঙ্গে দেখা করতে আসছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","তখন যাকোব খুব ভয় পেলেন ও চিন্তিত হলেন, আর যে সব লোক তাঁর সঙ্গে ছিল, তাদেরকে ও গরু ও ভেড়ার দল সমস্ত পাল ও উটদেরকে বিভক্ত করে দুটি দল করলেন, ");
INSERT INTO benirv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","বললেন, “এষৌ এসে যদিও এক দলকে আক্রমণ করেন, তবুও অন্য দল অবশিষ্ট থেকে রক্ষা পাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","তখন যাকোব বললেন, “হে আমার বাবা অব্রাহামের ঈশ্বর ও আমার বাবা ইসহাকের ঈশ্বর, তুমি সদাপ্রভু নিজে আমাকে বলেছিলে, তোমার দেশে আত্মীয়দের কাছে ফিরে যাও, তাতে আমি তোমার মঙ্গল করব। ");
INSERT INTO benirv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","তুমি এই দাসের প্রতি যে সমস্ত চুক্তির বিশ্বস্ততা ও যে সমস্ত সত্যাচরণ করেছ, আমি তার কিছুরই যোগ্য নই; কারণ আমি আমার এই লাঠিটি নিয়ে এই যর্দ্দন পার হয়েছিলাম, এখন দুই দল হয়েছি। ");
INSERT INTO benirv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","অনুরোধ করি, আমার ভাইয়ের হাত থেকে, এষৌর হাত থেকে আমাকে রক্ষা কর, কারণ আমি তাকে ভয় করি, যদি সে এসে আমাকে, ছেলেদের সঙ্গে মাকে হত্যা করে। ");
INSERT INTO benirv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","তুমিই তো বলেছ, আমি অবশ্য তোমার মঙ্গল করব এবং সমুদ্রতীরে অবস্থিত যে বালি তার মতো তোমার বংশ বৃদ্ধি করব, যা গোনা যায় না।” ");
INSERT INTO benirv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","পরে যাকোব সেই জায়গায় রাত কাটালেন ও তার কাছে যা ছিল, তার কিছু নিয়ে তাঁর ভাই এষৌর জন্য এই উপহার প্রস্তুত করলেন; ");
INSERT INTO benirv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","দুশো ছাগী ও কুড়িটা ছাগল, দুশো ভেড়ী ও কুড়িটা ভেড়া, ");
INSERT INTO benirv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","বাচ্চা সহ দুগ্ধবতী ত্রিশটি উট, চল্লিশটি গরু ও দশটি ষাঁড় এবং কুড়িটি গাধী ও দশটি গাধা। ");
INSERT INTO benirv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","পরে তিনি নিজের এক এক দাসের হাতে এক এক পাল সমর্পণ করে দাসদেরকে এই আদেশ দিলেন, “তোমরা আমার আগে পার হয়ে যাও এবং মাঝে মাঝে জায়গা রেখে প্রত্যেক পাল আলাদা কর।” ");
INSERT INTO benirv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","পরে তিনি প্রথম দাসকে এই আদেশ দিলেন, “আমার ভাই এষৌর সঙ্গে তোমার দেখা হলে তিনি যখন জিজ্ঞাসা করবেন, তুমি কার দাস? কোথায় যাচ্ছ? আর তোমার আগে অবস্থিত এই সব কার?” ");
INSERT INTO benirv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","তখন তুমি উত্তর করবে, “এই সব আপনার দাস যাকোবের; তিনি উপহার হিসাবে এই সব আমার প্রভু এষৌর জন্য পাঠালেন;” আর দেখুন, তিনিও আমাদের পিছনে আসছেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","পরে তিনি দ্বিতীয় ও তৃতীয় প্রভৃতি পালের পিছনে চলা দাস সবাইকেও আদেশ দিয়ে বললেন, “এষৌর সঙ্গে দেখা হলে তোমরা এই এই ধরনের কথা বল। ");
INSERT INTO benirv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","আরো বল, দেখুন, আপনার দাস যাকোবও আমাদের পিছনে আসছেন।” কারণ তিনি বললেন, “আমি আগে উপহার পাঠিয়ে তাঁকে শান্ত করব, পরে তাঁর সঙ্গে দেখা করব, তাতে তিনি আমার প্রতি অনুগ্রহ করলেও করতে পারেন।” ");
INSERT INTO benirv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","তাই তাঁর আগে উপহারের জিনিস পার হয়ে গেল, কিন্তু নিজে সেই রাতে দলের মধ্যে থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","পরে তিনি রাতে উঠে নিজের দুই স্ত্রী, দুই দাসী ও এগারো জন ছেলেকে নিয়ে যব্বোক নদীর অগভীর অংশ দিয়ে পার হলেন ");
INSERT INTO benirv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","তিনি তাঁদেরকে নদী পার করিয়ে নিজের সব জিনিস পাড়ে পাঠিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","আর যাকোব সেখানে একা থাকলেন এবং এক পুরুষ ভোর পর্যন্ত তাঁর সঙ্গে মল্লযুদ্ধ করলেন; ");
INSERT INTO benirv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","কিন্তু তাঁকে জয় করতে পারলেন না দেখে, তিনি যাকোবের ঊরুসন্ধিতে আঘাত করলেন। তাঁর সঙ্গে এরকম মল্লযুদ্ধ করাতে যাকোবের ঊরুসন্ধির হাড় সরে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","পরে সেই পুরুষ বললেন, “আমাকে ছাড়, কারণ ভোর হল।” যাকোব বললেন, “আপনি আমাকে আশীর্বাদ না করলে আপনাকে ছাড়ব না।” ");
INSERT INTO benirv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","আবার তিনি বললেন, “তোমার নাম কি?” তিনি উত্তর করলেন, “যাকোব।” ");
INSERT INTO benirv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","তিনি বললেন, “তুমি যাকোব নামে আর আখ্যাত হবে না, কিন্তু ইস্রায়েল ঈশ্বরের সঙ্গে যুদ্ধকারী নামে আখ্যাত হবে; কারণ তুমি ঈশ্বরের ও মানুষদের সঙ্গে যুদ্ধ করে জয়ী হয়েছ।” ");
INSERT INTO benirv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","তখন যাকোব জিজ্ঞাসা করে বললেন, “অনুরোধ করি, আপনার নাম কি? বলুন।” তিনি বললেন, “কি জন্য আমার নাম জিজ্ঞাসা কর?” পরে সেখানে যাকোবকে আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","তখন যাকোব সেই জায়গার নাম পনূয়েল ঈশ্বরের মুখ রাখলেন; কারণ তিনি বললেন, “আমি ঈশ্বরকে সামনাসামনি হয়ে দেখলাম, তবুও আমার প্রাণ বাঁচল।” ");
INSERT INTO benirv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","পরে তিনি পনূয়েল পার হলে সূর্যোদয় হল। আর তিনি ঊরুতে খোঁড়াতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","এই কারণ ইস্রায়েল-সন্তানেরা আজও ঊরুসন্ধির হাড়ের উপরের ঊরুসন্ধির শিরা খায় না, কারণ তিনি যাকোবের ঊরুসন্ধির হাড় অর্থাৎ ঊরুসন্ধির শিরা স্পর্শ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","পরে যাকোব চোখ তুলে চাইলেন, আর দেখ, এষৌ আসছেন ও তাঁর সঙ্গে চারশো লোক। তখন তিনি ছেলেদেরকে বিভাগ করে লেয়াকে, রাহেলকে ও দুই দাসীকে সমর্পণ করলেন; ");
INSERT INTO benirv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","সবার আগে দুই দাসী ও তাদের ছেলেমেয়েদেরকে, তার পিছনে লেয়া ও তাঁর ছেলেমেয়েদেরকে, সবার পিছনে রাহেল ও যোষেফকে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","পরে নিজে সবার আগে গিয়ে সাত বার ভূমিতে নত হতে হতে নিজের ভাইয়ের কাছে উপস্থিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","তখন এষৌ তাঁর সঙ্গে দেখা করতে দৌড়ে এসে তাঁর গলা ধরে আলিঙ্গন ও চুম্বন করলেন এবং উভয়েই কাঁদলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","পরে এষৌ চোখ তুলে নারীদেরকে ও বালকদেরকে দেখে জিজ্ঞাসা করলেন, “এরা তোমার কে?” তিনি বললেন, “ঈশ্বর অনুগ্রহ করে আপনার দাসকে এই সব সন্তান দিয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","তখন দাসীরা ও তাদের ছেলেমেয়েরা কাছে এসে প্রণাম করল; ");
INSERT INTO benirv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","পরে লেয়া ও তাঁর ছেলেমেয়েরা কাছে এসে প্রণাম করলেন; শেষে যোষেফ ও রাহেল কাছে এসে প্রণাম করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","পরে এষৌ জিজ্ঞাসা করলেন, “আমি যে সব দলের সঙ্গে মিলিত হলাম, সে সমস্ত কিসের জন্য?” তিনি বললেন, “প্রভুর দৃষ্টিতে অনুগ্রহ পাবার জন্য।” ");
INSERT INTO benirv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","তখন এষৌ বললেন, “আমার যথেষ্ট আছে, ভাই, তোমার যা আছে তা তোমার থাকুক।” ");
INSERT INTO benirv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","যাকোব বললেন, “তা না, অনুরোধ করি, আমি যদি আপনার দৃষ্টিতে অনুগ্রহ পেয়ে থাকি, তবে আমার হাত থেকে উপহার গ্রহণ করুন; কারণ আমি ঈশ্বরের মুখ দর্শনের মতো আপনার মুখ দর্শন করলাম, আপনিও আমার প্রতি প্রসন্ন হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","অনুরোধ করি, আপনার কাছে যে উপহার আনা হয়েছে, তা গ্রহণ করুন; কারণ ঈশ্বর আমার প্রতি অনুগ্রহ করেছেন এবং আমার সবই আছে।” এই ভাবে অনুরোধ করলে এষৌ তা গ্রহণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","পরে এষৌ বললেন, “এস আমরা যাই; আমি তোমার আগে আগে যাব।” ");
INSERT INTO benirv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","তিনি তাঁকে বললেন, “আমার প্রভু জানেন, এই ছেলেরা কোমল এবং দুগ্ধবতী ভেড়ী ও গরু সব আমার সঙ্গে আছে; একদিন খুব জোরে গেলেই সব পালই মারা যাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","“নিবেদন করি, হে আমার প্রভু আপনি নিজের দাসের আগে যান; আর আমি যতক্ষণ সেয়ীরে আমার প্রভুর কাছে উপস্থিত না হই, ততক্ষণ আমার সামনে চলা পশুদের চলবার শক্তি অনুসারে এবং এই ছেলে মেয়েদের, চলবার শক্তি অনুসারে ধীরে ধীরে চালাই।” ");
INSERT INTO benirv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","এষৌ বললেন, “তবে আমার সঙ্গী কিছু লোক তোমার কাছে রেখে যাই।” তিনি বললেন, “তাতেই বা প্রয়োজন কি? আমার প্রভুর দৃষ্টিতে আমি অনুগ্রহ পেলেই হল।” ");
INSERT INTO benirv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","আর এষৌ সেই দিন সেয়ীরের পথে ফিরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","কিন্তু যাকোব সুক্কোতে গিয়ে নিজের জন্য গৃহ ও পশুদের জন্য কয়েকটি ঘর তৈরী করলেন, এই জন্য সেই জায়গা সুক্কোৎ কুটীর সকল নামে আখ্যাত আছে। ");
INSERT INTO benirv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","পরে যাকোব পদ্দন্‌-অরাম থেকে এসে, নিরাপদে কনান দেশের শিখিম নগরে উপস্থিত হয়ে, নগরের বাইরে তাঁবু স্থাপন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","পরে শিখিমের বাবা যে হমোর, তাঁর ছেলেদেরকে রূপার একশো কসীতা মুদ্রা দিয়ে তিনি নিজের তাঁবু স্থাপনের ভূমিখণ্ড কিনলেন ");
INSERT INTO benirv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","এবং সেখানে এক যজ্ঞবেদি নির্মাণ করে তার নাম এল-ইলহে-ইস্রায়েল ঈশ্বর, ইস্রায়েলের ঈশ্বর রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","আর লেয়ার মেয়ে দীণা, যাকে তিনি যাকোবের জন্য প্রসব করেছিলেন, সেই দেশের মেয়েদের সঙ্গে দেখা করতে বাইরে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","আর হিব্বীয় হমোর যিনি সেই দেশের রাজা ছিলেন তার ছেলে শিখিম তাকে দেখতে পেল এবং তাকে ধরে নিয়ে তার সঙ্গে শয়ন করল, তাঁকে ভ্রষ্ট করল। ");
INSERT INTO benirv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","আর যাকোবের মেয়ে দীণার প্রতি তাঁর প্রাণ অনুরক্ত হওয়াতে সে সেই যুবতীকে প্রেম করল ও তাকে স্নেহপূর্বক কথা বলল। ");
INSERT INTO benirv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","পরে শিখিম নিজের বাবা হমোরকে বলল, “তুমি আমার সঙ্গে বিয়ে দেবার জন্য এই মেয়েকে গ্রহণ কর।” ");
INSERT INTO benirv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","আর যাকোব শুনলেন, সে তার মেয়ে দীণাকে ভ্রষ্ট করেছে; ঐ দিনের তার ছেলেরা মাঠে পশুপালের সঙ্গে ছিল; আর যাকোব তাদের আসা পর্যন্ত চুপ থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","পরে শিখিমের বাবা হমোর যাকোবের সঙ্গে কথাবার্তা বলতে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","যাকোবের ছেলেরাও ঐ খবর পেয়ে মাঠ থেকে এসেছিল; তারা ক্ষুব্ধ ও খুব রেগে গিয়েছিল, কারণ যাকোবের মেয়ের সঙ্গে শয়ন করাতে শিখিম ইস্রায়েলের মধ্যে মূর্খামি ও অকর্তব্য কাজ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","তখন হমোর তাদের সঙ্গে কথাবার্তা বলে বলল, “তোমাদের সেই মেয়ের প্রতি আমার ছেলে শিখিমের প্রাণ আসক্ত হয়েছে; অনুরোধ করি, আমার ছেলের সঙ্গে তার বিয়ে দাও। ");
INSERT INTO benirv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","এবং আমাদের সঙ্গে আত্মীয়তা কর; তোমাদের মেয়েদেরকে আমাদেরকে দান কর এবং আমাদের মেয়েদেরকে তোমরা গ্রহণ কর। আর আমাদের সঙ্গে বাস কর; ");
INSERT INTO benirv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","এই দেশ তোমাদের সামনে থাকল, তোমরা এখানে বসবাস ও ব্যবসা-বাণিজ্য কর, এখানে অধিকার গ্রহণ কর।” ");
INSERT INTO benirv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","আর শিখিম দীণার বাবাকে ও ভাইদেরকে বলল, “আমার প্রতি তোমাদের অনুগ্রহ দৃষ্টি হোক; তা হলে যা বলবে, তাই দেব। ");
INSERT INTO benirv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","পণ ও দান যত বেশি চাইবে, তোমাদের কথানুসারে তাই দেব; কোনো মতে আমার সঙ্গে ঐ মেয়ের বিয়ে দাও।” ");
INSERT INTO benirv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","কিন্তু সে তাদের বোন দীণাকে ভ্রষ্ট করেছিল বলে যাকোবের ছেলেরা ছলনার সাথে আলাপ করে শিখিমকে ও তাঁর বাবা হমোরকে উত্তর দিল; ");
INSERT INTO benirv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","তারা তাদেরকে বলল, “অচ্ছিন্নত্বক লোককে যে আমাদের বোনকে দিই, এমন কাজ আমরা করতে পারিনা; করলে আমাদের বদনাম হবে। ");
INSERT INTO benirv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","শুধু এই কাজটি করলে আমরা তোমাদের কথায় রাজি হব; আমাদের মতো তোমরা প্রত্যেক পুরুষ যদি ছিন্নত্বক হও, ");
INSERT INTO benirv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","তবে আমরা তোমাদেরকে নিজেদের মেয়েদের দেব এবং তোমাদের মেয়েদেরকে গ্রহণ করব ও তোমাদের সঙ্গে বাস করে এক জাতি হব। ");
INSERT INTO benirv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","কিন্তু যদি ত্বকছেদের বিষয়ে আমাদের কথা না শোন, তবে আমরা নিজেদের ঐ মেয়েকে নিয়ে চলে যাব।” ");
INSERT INTO benirv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","তখন তাদের এই কথায় হমোর ও তার ছেলে শিখিম সন্তুষ্ট হল। ");
INSERT INTO benirv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","আর সেই যুবক তাড়াতাড়ি সেই কাজ করল, কারণ সে যাকোবের মেয়েতে প্রীত হয়েছিল; আর সে নিজের বাবার বংশে সবচেয়ে সম্মানীত ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","পরে হমোর ও তার ছেলে শিখিম নিজের নগরের দরজায় এসে নগর নিবাসীদের সঙ্গে আলোচনা বলে বলল, ");
INSERT INTO benirv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“সেই লোকেরা আমাদের সঙ্গে শান্তিতে আছে; তাই তারা এই দেশে বসবাস ও ব্যবসা-বাণিজ্য করুক; কারণ দেখ, তাদের সামনে দেশটি সুপ্রশস্ত; এস, আমরা তাদের মেয়েদেরকে গ্রহণ করি ও আমাদের মেয়েদেরকে তাদেরকে দিই। ");
INSERT INTO benirv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","কিন্তু তাদের এই এক পণ আছে, আমাদের মধ্যে প্রত্যেক পুরুষ যদি তাদের মত ছিন্নত্বক হয়, তবে তারা আমাদের সঙ্গে বাস করে এক জাতি হতে রাজি আছে। ");
INSERT INTO benirv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","আর তাদের ধন, সম্পত্তি ও পশু সব কি আমাদের হবে না? আমরা তাদের কথায় রাজি হলেই তারা আমাদের সঙ্গে বাস করবে।” ");
INSERT INTO benirv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","তখন হমোরের ও তার ছেলে শিখিমের কথায় তার নগরের দরজা দিয়ে যে সব লোক বাইরে যেত, তারা রাজি হল, আর তার নগর দরজা দিয়ে যে সব পুরুষ বাইরে যেত, তাদের ত্বকছেদ করা হল। ");
INSERT INTO benirv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","পরে তৃতীয় দিনের যন্ত্রণায় পরিপূর্ণ হলে দীণার ভাই শিমিয়ন ও লেবি, যাকোবের এই দুই ছেলে নিজের নিজের খড়্গ গ্রহণ করে নির্ভয়ে নগর আক্রমণ করতঃ সকল পুরুষকে হত্যা করল। ");
INSERT INTO benirv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","এবং হমোর ও তার ছেলে শিখিমকে তরবারির আঘাতে হত্যা করে শিখিমের বাড়ি থেকে দীণাকে নিয়ে চলে আসল। ");
INSERT INTO benirv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ওরা তাদের বোনকে ভ্রষ্ট করেছিল, এই জন্য যাকোবের ছেলেরা নিহত লোকদের কাছে গিয়ে নগর লুট করল। ");
INSERT INTO benirv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","তারা ওদের ভেড়া, গরু ও গাধা সব এবং নগরের ও ক্ষেত্রের যাবতীয় দ্রব্য বাজেয়াপ্ত করল; ");
INSERT INTO benirv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","আর ওদের শিশু ও স্ত্রীদেরকে বন্দি করে ওদের সমস্ত ধন ও গৃহের সর্বস্ব লুট করল। ");
INSERT INTO benirv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","তখন যাকোব শিমিয়ন ও লেবিকে বললেন, “তোমরা এই দেশনিবাসী কনানীয় ও পরিষীয়দের কাছে আমাকে দূর্গন্ধস্বরূপ করে ব্যাকুল করলে; আমার লোক অল্প, তারা আমার বিরুদ্ধে জড়ো হয়ে আমাকে আঘাত করবে; আর আমি সপরিবারে বিনষ্ট হব।” ");
INSERT INTO benirv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","তারা উত্তর করল, যেমন বেশ্যার সঙ্গে, তেমনি আমার বোনের সঙ্গে ব্যবহার করা কি তার উচিত ছিল? ");
INSERT INTO benirv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","পরে ঈশ্বর যাকোবকে বললেন, “তুমি উঠ, বৈথেলে গিয়ে সে জায়গায় বাস কর এবং তোমার ভাই এষৌর সামনে থেকে তোমার পালানোর দিনের যে ঈশ্বর তোমাকে দেখা দিয়েছিলেন, তার উদ্দেশ্যে সেই জায়গায় যজ্ঞবেদি তৈরী কর।” ");
INSERT INTO benirv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","তখন যাকোব নিজের আত্মীয় ও সঙ্গী লোক সবাইকে বললেন, “তোমাদের কাছে যে সব ইতর দেবতা আছে, তাদেরকে দূর কর এবং শুদ্ধ হও ও অন্য বস্ত্র পর। ");
INSERT INTO benirv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","আর এস, আমরা উঠে বৈথেলে যাই; যে ঈশ্বর আমার সঙ্কটের দিনের আমাকে প্রার্থনার উত্তর দিয়েছিলেন এবং আমার যাত্রাপথে সঙ্গে ছিলেন, তাঁর উদ্দেশ্যে আমি সেই জায়গায় এক যজ্ঞবেদি নির্মাণ করব।” ");
INSERT INTO benirv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","তাতে তারা নিজেদের দেবমূর্তি ও কানের দুল সব যাকোবকে দিল এবং তিনি ঐ সব শিখিমের কাছাকাছি এলা গাছের তলায় পুঁতে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","পরে তাঁরা সেখান থেকে যাত্রা করলেন। তখন চারদিকের নগরসমূহে ঈশ্বর থেকে ভয় উপস্থিত হল, তাই সেখানকার লোকেরা যাকোবের ছেলেদের পিছনে গেল না। ");
INSERT INTO benirv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","পরে যাকোব ও তাঁর সঙ্গীরা সবাই কনান দেশের লূসে অর্থাৎ বৈথেলে উপস্থিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","সেখানে তিনি এক যজ্ঞবেদি নির্মাণ করে সেই জায়গার নাম এল-বৈথেল বৈথেলের ঈশ্বর রাখলেন; কারণ ভাইয়ের সামনে থেকে তার পালাবার দিন ঈশ্বর সেই জায়গায় তাকে দর্শন দিয়েছিলেন ");
INSERT INTO benirv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","আর রিবিকার দবোরা নামের ধাত্রীর মৃত্যু হল এবং বৈথেলের নীচে অবস্থিত অলোন গাছের তলায় তার কবর হল এবং সেই জায়গার নাম অলোন-বাখুৎ ক্রন্দন গাছ হল। ");
INSERT INTO benirv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","পদ্দন-অরাম থেকে যাকোব ফিরে আসলে ঈশ্বর তাঁকে আবার দর্শন দিয়ে আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ফলে ঈশ্বর তাঁকে বললেন, “তোমার নাম যাকোব; লোকে তোমাকে আর যাকোব বলবে না, তোমার নাম ইস্রায়েল হবে;” আর তিনি তাঁর নাম ইস্রায়েল রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ঈশ্বর তাঁকে আরো বললেন, “আমিই সর্বশক্তিমান ঈশ্বর, তুমি প্রজাবান ও বহুবংশ হও; তোমার থেকে এক জাতি, এমন কি, জাতিসমাজ সৃষ্টি হবে, আর তোমার থেকে রাজারা সৃষ্টি হবে। ");
INSERT INTO benirv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","আর আমি অব্রাহামকে ও ইসহাককে যে দেশ দান করেছি, সেই দেশ তোমাকে ও তোমার ভাবী বংশকে দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","সেই জায়গায় তাঁর সঙ্গে কথাবার্তা বলে ঈশ্বর তাঁর কাছ থেকে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","আর যাকোব সেই কথাবার্তার জায়গায় এক স্তম্ভ, পাথরের স্তম্ভ, স্থাপন করে তার উপরে পানীয় নৈবেদ্য উৎসর্গ করলেন ও তেল ঢেলে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","এবং যে জায়গায় ঈশ্বর তাঁর সঙ্গে কথা বললেন, যাকোব সেই জায়গার নাম বৈথেল রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","পরে তাঁরা বৈথেল থেকে চলে গেলেন, আর ইফ্রাথে উপস্থিত হবার অল্প পথ বাকি থাকতে রাহেলের প্রসব বেদনা হল এবং তাঁর প্রসব করতে বড় কষ্ট হল। ");
INSERT INTO benirv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","আর প্রসব ব্যথা কঠিন হলে ধাত্রী তাকে বলল, “ভয় কর না, কারণ এবারও তোমার ছেলে হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","পরে তার মৃত্যু হল, আর প্রাণ চলে যাবার দিনের তিনি ছেলের নাম বিনোনী আমার কষ্টের ছেলে রাখলেন, কিন্তু তার বাবা তার নাম বিন্যামীন ডান হাতের ছেলে রাখলেন ");
INSERT INTO benirv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","এই ভাবে রাহেলের মৃত্যু হল এবং ইফ্রাথ অর্থাৎ বৈৎলেহমের পথের পাশে তার কবর হল। ");
INSERT INTO benirv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","পরে যাকোব তার কবরের ওপরে এক স্তম্ভ স্থাপন করলেন, রাহেলের সেই কবর স্তম্ভ আজও আছে। ");
INSERT INTO benirv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","পরে ইস্রায়েল সেখান থেকে যাত্রা করলেন এবং মিগদল-এদরের ওপাশে তাঁবু স্থাপন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","সেই দেশে ইস্রায়েলের বসবাসের দিনের রুবেন গিয়ে নিজের বাবার বিলহা নামে উপপত্নীর সঙ্গে শয়ন করল এবং ইস্রায়েল তা শুনতে পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","লেয়ার ছেলে; যাকোবের বড় ছেলে রুবেন এবং শিমিয়োন, লেবি, যিহূদা, ইষাখর ও সবূলূন। ");
INSERT INTO benirv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","রাহেলের ছেলে; যোষেফ ও বিন্যামীন। ");
INSERT INTO benirv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","রাহেলের দাসী বিলহার ছেলে; দান ও নপ্তালি। ");
INSERT INTO benirv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","লেয়ার দাসী সিল্পার ছেলে; গাদ ও আশের। এরা যাকোবের ছেলে, পদ্দন-অরামে জন্মায়। ");
INSERT INTO benirv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","পরে কিরিয়থর্ব্বের অর্থাৎ হিব্রোণের কাছাকাছি মম্রি নামক যে জায়গায় অব্রাহাম ও ইসহাক বাস করেছিলেন, সেই জায়গায় যাকোব নিজের বাবা ইসহাকের কাছে উপস্থিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ইসহাকের বয়স একশো আশী বছর হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","পরে ইসহাক বৃদ্ধ ও পূর্ণায়ু হয়ে প্রাণত্যাগ করে নিজের পূর্বপুরুষদের সঙ্গে একত্রিত হলেন এবং তাঁর ছেলে এষৌ ও যাকোব তাঁর কবর দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","এষৌর অর্থাৎ ইদোমের বংশ-বৃত্তান্ত এই। ");
INSERT INTO benirv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","এষৌ কনানীয়দের দুটি মেয়েকে, অর্থাৎ হিত্তীয় এলোনের মেয়ে আদাকে ও হিব্বীয় সিবিয়োনের নাতনি অনার মেয়ে অহলীবামাকে, ");
INSERT INTO benirv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","তাছাড়াও নবায়োতের বোনকে, অর্থাৎ ইশ্মায়েলের বাসমৎ নামে মেয়েকে বিয়ে করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","আর এষৌর জন্য আদা ইলীফসকে ও বাসমৎ রুয়েলকে প্রসব করে। ");
INSERT INTO benirv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","এবং অহলীবামা যিয়ূশ, যালম ও কোরহকে প্রসব করে; এরা এষৌর ছেলে, কনান দেশে জন্মে। ");
INSERT INTO benirv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","পরে এষৌ নিজের স্ত্রী ছেলে মেয়েরা ও ঘরের অন্য সব প্রাণীকে এবং নিজের সমস্ত পশুধন ও কনান দেশে উপার্জিত সমস্ত সম্পত্তি নিয়ে যাকোব ভাইয়ের সামনে থেকে আর এক দেশে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","কারণ তাঁদের প্রচুর সম্পত্তি থাকাতে একসঙ্গে বসবাস করা সম্ভব হল না এবং পশুধনের জন্য তাঁদের সেই প্রবাস-দেশে জায়গা কুলাল না। ");
INSERT INTO benirv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","এই ভাবে এষৌ সেয়ীর পর্বতে বাস করলেন; তিনিই ইদোম। ");
INSERT INTO benirv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","সেয়ীর পর্বতে অবস্থিত ইদোমীয়দের পূর্বপুরুষ এষৌর বংশ-বৃত্তান্ত এই। ");
INSERT INTO benirv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","এষৌর ছেলেদের নাম এই। এষৌর স্ত্রী আদার ছেলে ইলীফস ও এষৌর স্ত্রী বাসমতের ছেলে রুয়েল। ");
INSERT INTO benirv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","আর ইলীফসের ছেলে তৈমন ও ওমার, সফো, গয়িতম ও কনস। ");
INSERT INTO benirv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","আর এষৌর ছেলে ইলীফসের তিম্না নামের এক উপপত্নী ছিল, সে ইলীফসের জন্য অমালেককে প্রসব করল। এরা এষৌর স্ত্রী আদার বংশধর। ");
INSERT INTO benirv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","আর রুয়েলের ছেলে নহৎ, সেরহ, শম্ম ও মিসা; এরা এষৌর স্ত্রী বাসমতের ছেলে। ");
INSERT INTO benirv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","আর সিবিয়োনের নাতনি অনার মেয়ে যে অহলীবামা এষৌর স্ত্রী ছিল, তার ছেলে যিয়ূশ, যালম ও কোরহ। ");
INSERT INTO benirv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","এষৌর বংশধরদের দলপতিরা এই। এষৌর বড় ছেলে যে ইলীফস, তার ছেলে দলপতি তৈমন, দলপতি ওমার, ");
INSERT INTO benirv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","দলপতি সফো, দলপতি কনস, দলপতি কোরহ, দলপতি গয়িতম ও দলপতি অমালেক; ইদোম দেশের ইলীফস বংশীয় এই দলপতিরা আদার বংশধর। ");
INSERT INTO benirv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","এষৌর ছেলে রুয়েলের ছেলে দলপতি নয়, দলপতি সেরহ, দলপতি শম্ম ও দলপতি মিসা; ইদোম দেশের রুয়েল বংশীয় এই দলপতিরা এষৌর স্ত্রী বাসমতের ছেলে। ");
INSERT INTO benirv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","আর এষৌর স্ত্রী অহলীবামার ছেলে দলপতি যিয়ুশ, দলপতি যালম ও দলপতি কোরহ; অনার মেয়ে যে অহলীবামা এষৌর স্ত্রী ছিল, এই দলপতিরা তার বংশধর। ");
INSERT INTO benirv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","এরা এষৌর অর্থাৎ ইদোমের সন্তান ও এরা তাদের দলপতি। ");
INSERT INTO benirv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","সেই দেশনিবাসী হোরীয় সেয়ীরের ছেলে লোটন, শোবল, শিবিয়োন, অনা, ");
INSERT INTO benirv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","দিশোন, এৎসর ও দীশন; সেয়ীরের এই ছেলেরা ইদোম দেশের হোরীয় বংশোদ্ভব দলপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","লোটনের ছেলে হোরি ও হেমম এবং তিম্না লোটনের বোন ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","আর শোবলের অলবন, মানহৎ, এবল, শফো ও ওনম। ");
INSERT INTO benirv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","আর সিবিয়োনের ছেলে অয়া ও অনা; এই অনা তার বাবা সিবিয়োনের গাধা চরাবার দিনের মরুপ্রান্তে গরম জলের উনুই খুঁজে পেয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","অনার ছেলে দিশোন ও অনার মেয়ে অহলীবামা। ");
INSERT INTO benirv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","আর দিশোনের ছেলে হিমদন, ইশবন, যিত্রন ও করান। ");
INSERT INTO benirv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","আর এৎসরের ছেলে বিলহন, সাবন ও আকন। ");
INSERT INTO benirv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","আর দিশোনের ছেলে উষ ও অরান। ");
INSERT INTO benirv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","হোরীয় বংশোদ্ভব দলপতিরা এই; দলপতি লোটন, দলপতি শোবল, দলপতি সিবিয়োন, দলপতি অনা, ");
INSERT INTO benirv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","দলপতি দিশোন, দলপতি এৎসর ও দলপতি দীশন। এরা সেয়ীর দেশের হোরীয় বংশোদ্ভব দলপতি। ");
INSERT INTO benirv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ইস্রায়েল–সন্তানদের ওপরে কোনো রাজা রাজত্ব করার আগে এরা ইদোম দেশের রাজা ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","বিয়োরের ছেলে বেলা ইদোম দেশে রাজত্ব করেন, তাঁর রাজধানীর নাম দিন হাবা। ");
INSERT INTO benirv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","আর বেলা মারা গেলে পর তাঁর পদে বস্রা-নিবাসী সেরহের ছেলে যোবব রাজত্ব করেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","আর যোবব মারা গেলে পর তৈমন দেশীয় হূশম তাঁর পদে রাজত্ব করেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","আর হূশম মারা যাবার পর বদদের ছেলে যে হদদ মোয়াব-ক্ষেত্রে মিদিয়নকে আঘাত করেছিলেন, তিনি তার পদে রাজত্ব করেন; তাঁর রাজধানীর নাম অবীৎ। ");
INSERT INTO benirv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","আর হদদ মারা যাবার পর মস্রেকা-নিবাসী সম্ল তাঁর পদে রাজত্ব করেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","আর সম্ল মারা গেলে পর ফরাৎ নদীর নিকটবর্তী রহোবোৎ-নিবাসী শৌল তাঁর পদে রাজত্ব করেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","আর শৌল মারা গেলে পর অকবোরের ছেলে বাল্‌হানন তাঁর পদে রাজত্ব করেন। ");
INSERT INTO benirv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","আর অকবোরের পুত্র বাল্‌হানন মারা গেলে পর হদর তাঁর পদে রাজত্ব করেন; তাঁর রাজধানীর নাম পায়ু ও স্ত্রীর নাম মহেটবেল, সে মট্রেদের মেয়ে ও মেষাহবের নাতনী। ");
INSERT INTO benirv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","গোষ্ঠী, স্থান ও নাম ভেদে এষৌ থেকে সৃষ্টি যে সব দলপতি ছিলেন, তাঁদের নাম হল; দলপতি তিম্ন, দলপতি অলবা দলপতি যিথেৎ, ");
INSERT INTO benirv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","দলপতি অহলীবামা, দলপতি এলা, দলপতি পীনোন, ");
INSERT INTO benirv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","দলপতি কনস্‌, দলপতি তৈমন, দলপতি মিবসর, ");
INSERT INTO benirv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","দলপতি মগদীয়েল ও দলপতি ঈরম। এরা নিজের নিজের অধিকার দেশে, নিজের নিজের বসবাস জায়গা ভেদে ইদোমের দলপতি ছিলেন। ইদোমীয়দের আদিপুরুষ এষৌর বৃত্তান্ত সমাপ্ত। ");
INSERT INTO benirv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","সেই দিনের যাকোব তার বাবার দেশে, কনান দেশে বাস করছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","যাকোবের বংশ-বৃত্তান্ত এই। যোষেফ সতেরো বছর বয়সে তার ভাইদের সঙ্গে পশুপাল চরাত; সে ছোটবেলায় তার বাবার স্ত্রী বিলহার ও সিল্পার ছেলেদের সঙ্গী ছিল এবং যোষেফ তাদের খারাপ ব্যবহারের খবর বাবার কাছে আনত। ");
INSERT INTO benirv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","যোষেফ ইস্রায়েলের বৃদ্ধ বয়সের ছেলে, এই জন্য ইস্রায়েল সব ছেলের থেকে তাকে বেশি ভালবাসতেন এবং তাকে একটা নানা রঙের পোশাক তৈরী করে দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","কিন্তু বাবা তার সব ভাইদের থেকে তাকে বেশি ভালবাসেন, এটা দেখে তার ভাইয়েরা তাকে ঘৃণা করত, তার সঙ্গে আন্তরিকভাবে কথা বলতে পারত না। ");
INSERT INTO benirv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","আর যোষেফ স্বপ্ন দেখে নিজের ভাইদেরকে তা বলল; এতে তারা তাকে আরও বেশি ঘৃণা করল। ");
INSERT INTO benirv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","সে তাদেরকে বলল, “আমি এক স্বপ্ন দেখেছি, অনুরোধ করি, তা শোন। ");
INSERT INTO benirv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","দেখ, আমরা আঁটি বাঁধছিলাম, আর দেখ, আমার আঁটি উঠে দাঁড়িয়ে থাকল এবং দেখ, তোমাদের আঁটি সব আমার আঁটিকে চারদিকে ঘিরে তার কাছে নত হল।” ");
INSERT INTO benirv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","এতে তার ভাইয়েরা তাকে বলল, “তুই কি বাস্তবে আমাদের রাজা হবি? আমাদের উপরে বাস্তবে কর্তৃত্ব করবি?” ফলে তারা স্বপ্ন ও তার কথার জন্য তাকে আরো ঘৃণা করল। ");
INSERT INTO benirv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","পরে সে আরো এক স্বপ্ন দেখে ভাইদেরকে তার বৃত্তান্ত বলল। সে বলল, “দেখ, আমি আর এক স্বপ্ন দেখলাম; দেখ, সূর্য্য, চন্দ্র ও এগারো নক্ষত্র আমার সামনে নত হল।” ");
INSERT INTO benirv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","সে তার বাবা ও ভাইদেরকে এর বৃত্তান্ত বলল, তাতে তার বাবা তাকে ধমকিয়ে বললেন, “তুমি এ কেমন স্বপ্ন দেখলে? আমি, তোমার মা ও তোমার ভায়েরা, আমরা কি সত্যিই তোমার কাছে ভূমিতে নত হতে আসব?” ");
INSERT INTO benirv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","আর তার ভায়েরা, তার প্রতি হিংসা করল, কিন্তু তার বাবা সেই কথা মনে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","একবার তার ভায়েরা বাবার পশুপাল চরাতে শিখিমে গিয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","তখন ইস্রায়েল যোষেফকে বললেন, “তোমার ভায়েরা কি শিখিমে পশুপাল চরাচ্ছে না? এস, আমি তাদের কাছে তোমাকে পাঠাই।” ");
INSERT INTO benirv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","সে বলল, “দেখুন, এই আমি।” তখন তিনি তাকে বললেন, “তুমি গিয়ে তোমার ভাইদের বিষয় ও পশুপালের বিষয় জেনে আমাকে সংবাদ এনে দাও।” এই ভাবে তিনি হিব্রোণের উপত্যকা থেকে যোষেফকে পাঠালে সে শিখিমে উপস্থিত হল। ");
INSERT INTO benirv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","তখন এক জন লোক তাকে দেখতে পেল, আর দেখ, সে মরুপ্রান্তে ভ্রমণ করছে; সেই লোকটি তাকে জিঞ্জাসা করল, “কিসের খোঁজ করছ?” ");
INSERT INTO benirv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","সে বলল, “আমার ভাইদের খোঁজ করছি; অনুগ্রহ করে আমাকে বল, তাঁরা কোথায় পাল চরাচ্ছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","সে ব্যক্তি বলল, “তারা এ জায়গা থেকে চলে গিয়েছে, কারণ ‘চল, দোথনে যাই,’ তাদের এই কথা বলতে শুনেছিলাম।” পরে যোষেফ নিজের ভাইদের পিছন পিছনে গিয়ে দোথনে তাদের খুঁজে পেল। ");
INSERT INTO benirv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","তারা দূর থেকে তাকে দেখতে পেল এবং সে কাছে উপস্থিত হবার আগে তাকে হত্যা করার জন্য ষড়যন্ত্র করল। ");
INSERT INTO benirv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","তারা পরস্পর বলল, “ঐ দেখ, স্বপ্নদর্শক মহাশয় আসছেন, ");
INSERT INTO benirv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","এখন এস, আমরা ওকে হত্যা করে একটা গর্তে ফেলে দিই; পরে বলব, কোনো হিংস্র জন্তু তাকে খেয়ে ফেলেছে; তাতে দেখব, ওর স্বপ্নের কি হয়।” ");
INSERT INTO benirv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","রুবেন এটা শুনে তাদের হাত থেকে তাকে উদ্ধার করল, বলল, “না, আমরা ওকে প্রাণে মারব না।” ");
INSERT INTO benirv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","আর রুবেন তাদেরকে বলল, “তোমরা রক্তপাত কর না, ওকে মরুপ্রান্তের এই গর্তের মধ্যে ফেলে দাও, কিন্তু ওর ওপরে হাত তুল না।” এই ভাবে রুবেন তাদের হাত থেকে তাকে উদ্ধার করে বাবার কাছে ফেরত পাঠাবার চেষ্টা করল। ");
INSERT INTO benirv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","পরে যোষেফ নিজের ভাইদের কাছে আসলে তারা তার গা থেকে, সেই বস্ত্র, সেই চোগাখানি খুলে নিল, ");
INSERT INTO benirv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","আর তাকে ধরে গর্তের মধ্যে ফেলে দিল, সেই গর্ত শূন্য ছিল, তাতে জল ছিল না। ");
INSERT INTO benirv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","পরে তারা খাবার খেতে বসল এবং চোখ তুলে চাইল, আর দেখ, গিলিয়দ থেকে এক দল ইশ্মায়েলীয় ব্যবসায়ী লোক আসছে; তারা উটে সুগন্ধি দ্রব্য, গুগ্‌গুলু ও গন্ধরস নিয়ে মিশর দেশে যাচ্ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","তখন যিহূদা নিজের ভাইদেরকে বলল, “আমাদের ভাইকে হত্যা করে তার রক্ত গোপন করলে আমাদের কি লাভ? ");
INSERT INTO benirv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","এস, আমরা ঐ ইশ্মায়েলীয়দের কাছে তাকে বিক্রি করি, আমরা তার ওপরে হাত তুলব না; কারণ সে আমাদের ভাই, আমাদের মাংস।” এতে তার ভায়েরা রাজি হল। ");
INSERT INTO benirv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","পরে মিদিয়নীয় বনিকেরা কাছে আসলে ওরা যোষেফকে গর্ত থেকে টেনে তুলল এবং কুড়িটি রূপার মুদ্রায় সেই ইশ্মায়েলীয়দের কাছে যোষেফকে বিক্রি করল; আর তারা যোষেফকে মিশর দেশে নিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","পরে রুবেন গর্তের কাছে ফিরে গেল, আর দেখ, যোষেফ সেখানে নাই; তখন সে নিজের পোশাক ছিঁড়ল, আর ভাইদের কাছে ফিরে এসে বলল, ");
INSERT INTO benirv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","“যুবকটি নেই, আর আমি! আমি কোথায় যাই?” ");
INSERT INTO benirv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","পরে তারা যোষেফের পোশাক নিয়ে একটা ছাগল মেরে তার রক্তে তা ডুবাল; ");
INSERT INTO benirv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","আর লোক পাঠিয়ে সেই চোগাখানি বাবার কাছে এনে বলল, “আমরা এই মাত্র পেলাম, পরীক্ষা করে দেখ, এটা তোমার ছেলের পোশাক কি না?” ");
INSERT INTO benirv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","তিনি চিনতে পেরে বললেন, এত আমার ছেলেরই পোশাক; কোনো হিংস্র জন্তু তাকে খেয়ে ফেলেছে, যোষেফ অবশ্য খণ্ড খণ্ড হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","তখন যাকোব নিজের পোশাক ছিঁড়ে কোমরে চট পরিধান করে ছেলের জন্য অনেক দিন পর্যন্ত শোক করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","আর তাঁর সব ছেলেমেয়ে উঠে তাঁকে সান্ত্বনা করতে যত্ন করলেও তিনি প্রবোধ না মেনে বললেন, “আমি শোক করতে ছেলের কাছে পাতালে নামব।” এই ভাবে তার বাবা তার জন্য কাঁদলেন। ");
INSERT INTO benirv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","আর ঐ মিদিয়নীয়েরা যোষেফকে মিশরে নিয়ে গিয়ে ফরৌণের কর্মচারী রক্ষক-সেনাপতি পোটীফরের কাছে বিক্রি করল। ");
INSERT INTO benirv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ঐ দিনের যিহূদা নিজের ভাইদের কাছ থেকে চলে গিয়ে অদুল্লমীয় হীরা নামে একটি লোকের কাছে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","সে জায়গায় শূয় নামে এক কনানীয় পুরুষের মেয়েকে দেখে যিহূদা তাকে গ্রহণ করে তার কাছে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","পরে সে গর্ভবতী হয়ে ছেলে প্রসব করল ও যিহূদা তার নাম এর রাখল। ");
INSERT INTO benirv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","পরে আবার তার গর্ভ হলে সে ছেলে প্রসব করে তার নাম ওনন রাখল। ");
INSERT INTO benirv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","আবার তার গর্ভ হলে সে ছেলে প্রসব করে তার নাম শেলা রাখল; এর জন্মের দিনের যিহূদা কষীবে ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","পরে যিহূদা তামর নামে একটি মেয়েকে এনে নিজের বড় ছেলে এরের সঙ্গে বিয়ে দিল। ");
INSERT INTO benirv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","কিন্তু যিহূদার বড় ছেলে এর সদাপ্রভুর দৃষ্টিতে দুষ্ট হওয়াতে সদাপ্রভু তাকে মেরে ফেললেন। ");
INSERT INTO benirv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","তাতে যিহূদা ওননকে বলল, “তুমি নিজের ভাইয়ের স্ত্রীর কাছে যাও ও তার প্রতি দেবরের কর্তব্য সাধন করে নিজের ভাইয়ের জন্য বংশ উৎপন্ন কর।” ");
INSERT INTO benirv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","কিন্তু ঐ বংশ নিজের হবে না, এই বুঝে ওনন ভাইয়ের স্ত্রীর কাছে গেলেও ভাইয়ের বংশ উৎপন্ন করবার অনিচ্ছাতে মাটিতে বীর্যপাত করল। ");
INSERT INTO benirv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","তার সেই কাজ সদাপ্রভুর দৃষ্টিতে মন্দ হওয়াতে তিনি তাকেও হত্যা করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","তখন যিহূদা ছেলের স্ত্রী তামরকে বলল, “যে পর্যন্ত আমার ছেলে শেলা বড় না হয়, ততক্ষণ তুমি নিজের বাবার বাড়ি গিয়ে বিধবাই থাক।” কারণ সে বলল যদি ভাইদের মতো সেও মারা যায়। অতএব তামর বাবার বাড়ি গিয়ে বাস করল। ");
INSERT INTO benirv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","পরে অনেক দিন গেলে শূয়ের মেয়ে যিহূদার স্ত্রী মারা গেল, পরে যিহূদা সান্ত্বনাযুক্ত হয়ে নিজের বন্ধু অদুল্লমীয় হীরার সঙ্গে তিম্নায়, যারা তাঁর মেষদের লোম কাটছিল, তাদের কাছে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","তখন কেউ তামরকে বলল, “দেখ, তোমার শ্বশুর নিজের মেষদের লোম কাটতে তিম্নায় যাচ্ছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","তখন সে বিধবার বস্ত্র ত্যাগ করে ঘোমটা দিয়ে নিজেকে ঢাকলেন ও গায়ে কাপড় দিয়ে তিম্নার পথের পাশে অবস্থিত ঐনয়িমের প্রবেশস্থানে বসে থাকল; কারণ সে দেখল, শেলা বড় হলেও তার সঙ্গে তার বিয়ে হল না। ");
INSERT INTO benirv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","পরে যিহূদা তাকে দেখে বেশ্যা মনে করল, কারণ সে মুখ আচ্ছাদন করেছিল। ");
INSERT INTO benirv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","তাই সে ছেলের স্ত্রীকে চিনতে না পারাতে পথের পাশে তার কাছে গিয়ে বলল, “এস, আমি তোমার কাছে যাই।” তামর বলল, “আমার কাছে আসার জন্য আমাকে কি দেবে?” ");
INSERT INTO benirv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","সে বলল, “পাল থেকে একটি ছাগল ছানা পাঠিয়ে দেব। তামর বলল, যতক্ষণ তা না পাঠাও, ততক্ষণ আমার কাছে কি কিছু বন্ধক রাখবে?” ");
INSERT INTO benirv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","সে বলল, “কি বন্ধক রাখব?” তামর বলল, “তোমার এই মোহর ও সুতো ও হাতের লাঠি।” তখন সে তাকে সেইগুলি দিয়ে তার কাছে গেল; তাতে সে তা থেকে গর্ভবতী হল। ");
INSERT INTO benirv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","পরে সে উঠে চলে গেল এবং সেই আবরণ ত্যাগ করে নিজের বৈধব্য বস্ত্র পরিধান করল। ");
INSERT INTO benirv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","পরে যিহূদা সেই স্ত্রীলোকের কাছ থেকে বন্ধক দ্রব্য নেবার জন্য নিজের অদুল্লমীয় বন্ধুর হাতে ছাগল ছানাটি পাঠিয়ে দিল, কিন্তু সে তাকে পেল না। ");
INSERT INTO benirv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","তখন সে সেখানকার লোকদেরকে জিজ্ঞাসা করল, “ঐনয়িমের পথের পাশে যে বেশ্যা ছিল, সে কোথায়?” তারা বলল, “এ জায়গায় কোনো বেশ্যা আসেনি। ");
INSERT INTO benirv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","পরে সে যিহূদার কাছে ফিরে গিয়ে বলল, আমি তাকে পেলাম না এবং সেখানকার লোকেরাও বলল, এ জায়গায় কোনো বেশ্যা আসেনি।” ");
INSERT INTO benirv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","তখন যিহূদা বলল, “তার কাছে যা আছে, সে তা রাখুক, না হলে আমরা লজ্জায় পড়ব। দেখ, আমি এই ছাগল ছানাটি পাঠিয়েছিলাম, কিন্তু তুমি তাকে পেলে না।” ");
INSERT INTO benirv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","প্রায় তিন মাস পরে কেউ যিহূদাকে বলল, “তোমার ছেলের স্ত্রী তামর ব্যভিচারিণী হয়েছে, আরো দেখ, ব্যভিচারের জন্য তার গর্ভ হয়েছে।” তখন যিহূদা বলল, “তাকে বাইরে এনে পুড়িয়ে দাও।” ");
INSERT INTO benirv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","পরে বাইরে আনার দিনের সে শ্বশুরকে বলে পাঠাল, যার এই সব বস্তু, সেই পুরুষ থেকে আমার গর্ভ হয়েছে। সে আরো বলল, “এই মোহর, সুতো ও লাঠি কার? চিনে দেখ।” ");
INSERT INTO benirv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","তখন যিহূদা সেগুলি চিনে বলল, “সে আমার থেকেও অনেক ধার্মিক, কারণ আমি তাকে নিজের ছেলে শেলাকে দিইনি। পরে যিহূদা তাঁর সঙ্গে আর কোনো শারীরিক সম্পর্ক স্থাপন করলেন না।” ");
INSERT INTO benirv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","পরে তামরের প্রসবকাল উপস্থিত হল, আর দেখ। তার গর্ভে যমজ সন্তান। ");
INSERT INTO benirv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","তার প্রসবকালে একটি বালক হাত বের করল; তাতে ধাত্রী তার সেই হাত ধরে রক্তবর্ণ সুতো বেঁধে বলল, “এই প্রথমে ভূমিষ্ট হল।” ");
INSERT INTO benirv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","কিন্তু সে নিজের হাত টেনে নিলে দেখ, তার ভাই ভূমিষ্ট হল; তখন ধাত্রী বলল, “তুমি কিভাবে নিজের জন্য ভেদ করে আসলে?” অতএব তার নাম পেরস ভেদ হল। ");
INSERT INTO benirv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","পরে হাতে রক্তবর্ণ সুতো বাঁধা তার ভাই ভূমিষ্ট হলে তার নাম সেরহ হল। ");
INSERT INTO benirv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","যোষেফকে মিশর দেশে নিয়ে যাওয়ার পর, যে ইশ্মায়েলীয়েরা তাকে সেখানে নিয়ে গিয়েছিল, তাদের কাছে ফরৌণের কর্মচারী পোটীফর তাকে কিনলেন, ইনি রক্ষক-সেনাপতি, একজন মিশরীয় লোক। ");
INSERT INTO benirv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","আর সদাপ্রভু যোষেফের সঙ্গে ছিলেন এবং তিনি সমৃদ্ধিশালী হলেন ও নিজের মিশরীয় প্রভুর ঘরে থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","আর সদাপ্রভু তাঁর সঙ্গে আছেন এবং তিনি যা কিছু করেন, সদাপ্রভু তাঁর হাতে তা সফল করছেন, এটা তাঁর প্রভু দেখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","অতএব যোষেফ তার দৃষ্টিতে অনুগ্রহ প্রাপ্ত হলেন ও তার পরিচারক হলেন এবং তিনি যোষেফকে নিজের বাড়ির পরিচালক করে তার হাতে নিজের সব কিছুর দায়িত্ব দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","যখন থেকে তিনি যোষেফকে নিজের বাড়ির ও সব কিছুর পরিচালক করলেন, তখন থেকে সদাপ্রভু যোষেফের অনুরোধে সেই মিশরীয় ব্যক্তির বাড়ির প্রতি আশীর্বাদ করলেন; বাড়িতে ও ক্ষেতে অবস্থিত তাঁর সমস্ত সম্পদের প্রতি সদাপ্রভু আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","অতএব তিনি যোষেফের হাতে নিজের সব কিছুর ভার দিলেন, তিনি নিজের খাবারের জিনিস ছাড়া আর কিছুরই বিষয়ে চিন্তা করতেন না। যোষেফ রূপবান ও সুন্দর ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","এই সব ঘটনার পর তাঁর প্রভুর স্ত্রী যোষেফের প্রতি দৃষ্টিপাত করল; আর তাঁকে বলল, “আমার সঙ্গে শয়ন কর।” ");
INSERT INTO benirv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","কিন্তু তিনি অস্বীকার করায় নিজের প্রভুর স্ত্রীকে বললেন, “দেখুন, এই বাড়িতে আমার হাতে কি কি আছে, আমার প্রভু তা জানেন না; আমারই হাতে সব কিছু রেখেছেন; ");
INSERT INTO benirv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","এই বাড়িতে আমার থেকে বড় কেউই নেই; তিনি সকলের মধ্যে শুধু আপনাকেই আমার অধীনা করেননি; কারণ আপনি তাঁর স্ত্রী। অতএব আমি কিভাবে এই এত বড় খারাপ কাজ করতে ও ঈশ্বরের বিরুদ্ধে পাপ করতে পারি?” ");
INSERT INTO benirv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","সে দিন দিন যোষেফকে সেই কথা বললেও তিনি তার সঙ্গে শয়ন করতে কিম্বা সঙ্গে থাকতে তার কথায় রাজি হতেন না। ");
INSERT INTO benirv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","পরে এক দিন যোষেফ কাজ করার জন্য ঘরের মধ্যে গেলেন, বাড়ির লোকদের মধ্যে অন্য কেউ সেখানে ছিল না, ");
INSERT INTO benirv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","তখন সে যোষেফের পোশাক ধরে বলল, “আমার সঙ্গে শয়ন কর৷” কিন্তু যোষেফ তার হাতে নিজের পোশাক ফেলে বাইরে পালিয়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","তখন যোষেফ তার হাতে পোশাক ফেলে বাইরে পালালেন দেখে, সে নিজের ঘরের লোকদেরকে ডেকে বলল, ");
INSERT INTO benirv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","“দেখ, তিনি আমাদের সঙ্গে ঠাট্টা করতে একজন ইব্রীয় পুরুষকে এনেছেন; সে আমার সঙ্গে শয়ন করবার জন্য আমার কাছে এসেছিল, তাতে আমি চিৎকার করে উঠলাম;” ");
INSERT INTO benirv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","আমার চিৎকার শুনে সে আমার কাছে নিজের পোশাকটি ফেলে বাইরে পালিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","আর যতক্ষণ তার কর্তা ঘরে না আসলেন, সে পর্যন্ত সেই স্ত্রীলোক তাঁর পোশাক নিজের কাছে রেখে দিল। ");
INSERT INTO benirv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","পরে সে সেই কথা অনুযায়ী তাঁকে বলল, “তুমি যে ইব্রীয় দাসকে আমাদের কাছে এনেছ, সে আমার সঙ্গে ঠাট্টা করতে আমার কাছে এসেছিল; ");
INSERT INTO benirv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","পরে আমি চিৎকার করে উঠলে সে আমার কাছে তার বস্ত্রখানি ফেলে বাইরে পালিয়ে গেল।” ");
INSERT INTO benirv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","তাঁর প্রভু যখন নিজের স্ত্রীর এই কথা শুনলেন যে, “তোমার দাস আমার প্রতি এইরকম ব্যবহার করেছে,” তখন খুব রেগে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","অতএব যোষেফের প্রভু তাঁকে নিয়ে কারাগারে রাখলেন, যে জায়গায় রাজার বন্দিরা বন্ধ থাকত; তাতে তিনি সেখানে, সেই কারাগারে থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","কিন্তু সদাপ্রভু যোষেফের সঙ্গে ছিলেন এবং তাঁর প্রতি দয়া করলেন ও তাঁকে কারারক্ষকের দৃষ্টিতে অনুগ্রহ-পাত্র করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","তাতে কারারক্ষক কারাগারে অবস্থিত সমস্ত বন্দির ভার যোষেফের হাতে সমর্পণ করলেন এবং সেখানকার লোকেদের সমস্ত কাজ যোষেফের আদেশ অনুযায়ী চলতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","কারারক্ষক তাঁর অধিকারের কোনো বিষয়ে দেখতেন না, কারণ সদাপ্রভু তাঁর সঙ্গী ছিলেন এবং তিনি যা কিছু করতেন সদাপ্রভু তা সফল করতেন। ");
INSERT INTO benirv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ঐ সব ঘটনার পরে মিশর-রাজের পান পাত্রবাহক ও রুটিওয়ালা নিজেদের প্রভু মিশর রাজের বিরুদ্ধে দোষ করল। ");
INSERT INTO benirv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","তাতে ফরৌণ নিজের সেই দুই কর্মচারীর প্রতি, ঐ প্রধান পাত্রবাহকের ও প্রধান রুটিওয়ালা প্রতি প্রচণ্ড রেগে গেলেন ");
INSERT INTO benirv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","এবং তাদেরকে বন্দি করে রক্ষক-সেনাপতির বাড়িতে, কারাগারে, যোষেফ যে জায়গায় বন্দী ছিলেন, সেই জায়গায় রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","তাতে রক্ষক-সেনাপতি তাদের কাছে যোষেফকে নিযুক্ত করলেন, আর তিনি তাদের পরিচর্য্যা করতে লাগলেন। এই ভাবে তারা কিছু দিন কারাগারে থাকল। ");
INSERT INTO benirv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","পরে মিশর-রাজের পানপাত্র বাহক ও রুটিওয়ালা, যারা জেলে বন্দী হয়েছিল, সেই দুইজনে এক রাতে দুই ধরনের অর্থবিশিষ্ট দুই স্বপ্ন দেখল। ");
INSERT INTO benirv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","আর যোষেফ সকালে তাদের কাছে এসে তাদেরকে দেখলেন, আর দেখ তারা দুঃখিত। ");
INSERT INTO benirv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","তখন তাঁর সঙ্গে ফরৌণের ঐ যে দুই কর্ম্মচারী তাঁর প্রভুর বাড়িতে কারাবদ্ধ ছিল, তাদেরকে তিনি জিজ্ঞাসা করলেন, “আজ আপনাদের মুখ বিষণ্ণ কেন?” ");
INSERT INTO benirv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","তারা উত্তর করল, “আমরা স্বপ্ন দেখেছি, কিন্তু অর্থকারক কেউ নেই।” যোষেফ তাদেরকে বললেন, “অর্থ করবার শক্তি কি ঈশ্বর থেকে হয় না? অনুরোধ করি, স্বপ্নের বৃত্তান্ত আমাকে বলুন।” ");
INSERT INTO benirv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","তখন প্রধান পানপাত্র বাহক যোষেফকে নিজের স্বপ্নের বৃত্তান্ত জানাল, তাঁকে বলল, “আমার স্বপ্নে, দেখ, আমার সামনে একটি আঙ্গুর গাছ। ");
INSERT INTO benirv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","সেই আঙ্গুর গাছের তিনটি শাখা; তা যেন পল্লবিত হল ও তাতে ফুল হল এবং স্তবকে তার ফল হল ও পেকে গেল।” ");
INSERT INTO benirv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","তখন আমার হাতে ফরৌণের পানপাত্র ছিল, আর আমি সেই দ্রাক্ষাফল নিয়ে ফরৌণের পাত্রে নিংড়িয়ে ফরৌণের হাতে সেই পাত্র দিলাম। ");
INSERT INTO benirv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","যোষেফ তাকে বললেন, “এর অর্থ এই; ঐ তিনটি শাখা যা তিন দিন বোঝায়। ");
INSERT INTO benirv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","তিন দিনের মধ্যে ফরৌণ আপনার মাথা উঁচু করে আপনাকে আবার আগের পদে নিযুক্ত করবেন; আর আপনি আগের মতই পানপাত্র বাহক হয়ে আবার ফরৌণের হাতে পানপাত্র দেবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","কিন্তু অনুরোধ করি, “যখন আপনার মঙ্গল হবে, তখন আমাকে মনে রাখবেন এবং আমার প্রতি দয়া করে ফরৌণের কাছে আমার কথা বলে আমাকে এই কারাগার থেকে উদ্ধার করবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","কারণ ইব্রীয়দের দেশ থেকে আমাকে প্রকৃত পক্ষে অপহরণ করে আনা হয়েছে; আর এ জায়গাতেও আমি কিছুই করিনি, যার জন্য এই কারাকুয়োতে বন্দী হই। ");
INSERT INTO benirv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","প্রধান রুটিওয়ালা যখন দেখল, অনুবাদটা ভাল, তখন সে যোষেফকে বলল, “আমিও স্বপ্ন দেখেছি; দেখ আমার মাথার ওপরে সাদা পিঠের তিনটি ঝুড়ি। ");
INSERT INTO benirv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","তার ওপরের ঝুড়িতে ফরৌণের জন্য সব ধরনের তৈরী খাবার ছিল; আর পাখিরা আমার মাথার উপরের ঝুড়ি থেকে তা নিয়ে খেয়ে ফেলল।” ");
INSERT INTO benirv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","যোষেফ উত্তর করলেন, “এর অর্থ এই, সেই তিন ঝুড়ি তিন দিন বোঝায়। ");
INSERT INTO benirv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","তিন দিনের র মধ্যে ফরৌণ তোমার দেহ থেকে মাথা তুলে নিয়ে তোমাকে গাছে ফাঁসি দেবেন এবং পাখিরা তোমার দেহ থেকে মাংস খাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","পরে তৃতীয় দিনের ফরৌণের জন্মদিন হল, আর তিনি নিজের সব দাসের জন্য খাবার তৈরী করলেন এবং নিজের দাসদের মধ্যে প্রধান পাত্রবাহকের ও প্রধান রুটিওয়ালার মাথা উঠাইলেন। ");
INSERT INTO benirv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","তিনি প্রধান পানপাত্রবাহককে তার নিজের পদে আবার নিযুক্ত করলেন, তাতে সে ফরৌণের হাতে পানপাত্র দিতে লাগল; ");
INSERT INTO benirv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","কিন্তু তিনি প্রধান রুটিওয়ালাকে ফাঁসি দিলেন; যেমন যোষেফ তাদেরকে স্বপ্নের অর্থ করে বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","অথচ প্রধান পানপাত্রবাহক যোষেফকে মনে করল না, ভুলে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","দুই বছর পরে ফরৌণ স্বপ্ন দেখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","দেখ, তিনি নদীর তীরে দাঁড়িয়ে আছেন, আর দেখ, নদী থেকে সাতটি মোটাসোটা সুন্দর গরু উঠল ও খাগড়া বনে চরতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","সেগুলির পরে, দেখ, আর সাতটি রোগা ও বিশ্রী গরু নদী থেকে উঠল ও নদীর তীরে ঐ গরুদের কাছে দাঁড়াল। ");
INSERT INTO benirv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","পরে সেই রোগা বিশ্রী গাভীরা ঐ সাতটি মোটাসোটা সুন্দর গরুকে খেয়ে ফেলল। তখন ফরৌণের ঘুম ভেঙে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","তার পরে তিনি আবার ঘুমিয়ে পড়লে দ্বিতীয় বার স্বপ্ন দেখলেন; দেখ, এক বোঁটাতে সাতটি মোটা ও ভালো শীষ উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","সেগুলির পরে, দেখ, পূর্বীয় বায়ুতে শোষিত অন্য সাতটি ক্ষীণ শীষ উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","আর এই ক্ষীণ শীষগুলি ঐ সাতটি মোটা পরিপক্ক শীষকে খেয়ে ফেলল। পরে ফরৌণের ঘুম ভেঙে গেল, আর দেখ, ওটা স্বপ্নমাত্র। ");
INSERT INTO benirv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","পরে সকালে তাঁর মন অস্থির হল; আর তিনি লোক পাঠিয়ে মিশরের সব জাদুকর ও সেখানকার সব জ্ঞানীকে ডাকলেন; আর ফরৌণ তাঁদের কাছে সেই স্বপ্নবৃত্তান্ত বললেন, কিন্তু তাঁদের মধ্যে কেউই ফরৌণকে তার অর্থ বলতে পারলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","তখন প্রধান পানপাত্রবাহক ফরৌণকে অনুরোধ করল, “আজ আমার দোষ মনে পড়ছে।” ");
INSERT INTO benirv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ফরৌণ নিজের দুই দাসের প্রতি, আমার ও প্রধান রুটিওয়ালার প্রতি, রেগে গিয়ে আমাদেরকে রক্ষক-সেনাপতির বাড়িতে কারাবদ্ধ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","আর সে ও আমি এক রাতে স্বপ্ন দেখেছিলাম এবং দুই জনের স্বপ্নের দুই প্রকার অর্থ হল। ");
INSERT INTO benirv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","তখন সে জায়গায় রক্ষক-সেনাপতির দাস এক জন ইব্রীয় যুবক আমাদের সঙ্গে ছিল; তাকে স্বপ্নবৃত্তান্ত বললে সে আমাদেরকে তার অর্থ বলল; উভয়ের স্বপ্নের অর্থ বলল। ");
INSERT INTO benirv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","আর সে আমাদেরকে যেমন অর্থ বলেছিল, সেরকমই ঘটল; মহারাজ আমাকে আগের পদে নিযুক্ত করলেন ও তাকে ফাঁসি দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","তখন ফরৌণ যোষেফকে ডেকে পাঠালে লোকেরা কারাকুয়ো থেকে তাঁকে তাড়াতাড়ি আনল। পরে তিনি চুল-দাড়ি কেটে অন্য পোশাক পরে ফরৌণের কাছে উপস্থিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","তখন ফরৌণ যোষেফকে বললেন, “আমি এক স্বপ্ন দেখেছি, তার অর্থ করতে পারে, এমন কেউ নেই। কিন্তু তোমার বিষয়ে আমি শুনেছি যে, তুমি স্বপ্ন শুনলে অর্থ করতে পার।” ");
INSERT INTO benirv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","যোষেফ ফরৌণকে উত্তর করলেন, “তা আমার পক্ষে অসম্ভব, ঈশ্বরই ফরৌণকে সঠিক উত্তর দেবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","তখন ফরৌণ যোষেফকে বললেন, “দেখ, আমি স্বপ্নে নদীর তীরে দাঁড়িয়েছিলাম। ");
INSERT INTO benirv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","আর দেখ, নদী থেকে সাতটি মোটাসোটা গরু উঠে খাগড়া বনে চরতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","সেগুলির পরে, দেখ, রোগা ও বিশ্রী গাভী উঠল; আমি সমস্ত মিশর দেশে সেই ধরনের বিশ্রী গাভী কখনও দেখিনি। ");
INSERT INTO benirv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","আর এই রোগা ও বিশ্রী গরুরা সেই আগের মোটাসোটা সাতটি গরুকে খেয়ে ফেলল। ");
INSERT INTO benirv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","কিন্তু তারা এদের খেয়ে ফেললে পর, খেয়ে ফেলেছে, এমন মনে হল না, কারণ এরা আগের মতো বিশ্রীই থাকল। ");
INSERT INTO benirv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","তখন আমার ঘুম ভেঙে গেল। পরে আমি আর এক স্বপ্ন দেখলাম; আর দেখ, একটি বোঁটায় সম্পূর্ণ ভালো সাতটি শীষ উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","আর দেখ, সেগুলির পরে শুকনো, ক্ষীণ ও পুর্বীয় বায়ুতে শুকনো সাতটি শীষ উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","আর এই ক্ষীণ শীষগুলি সেই ভালো সাতটি শীষকে গ্রাস করল। এই স্বপ্ন আমি জাদুকরদেরকে বললাম, কিন্তু কেউই এর অর্থ আমাকে বলতে পারল না।” ");
INSERT INTO benirv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","তখন যোষেফ ফরৌণকে বললেন, “ফরৌণের স্বপ্ন এক; ঈশ্বর যা করতে প্রস্তুত হয়েছেন, তাই ফরৌণকে জানিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ঐ সাতটি ভালো গরু সাত বছর এবং ঐ সাতটি ভালো শীষও সাত বছর; স্বপ্ন এক। ");
INSERT INTO benirv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","আর তার পরে যে সাতটি রোগা ও বিশ্রী গরু উঠল, তারাও সাত বছর এবং পুর্বীয় বায়ুতে শুকনো যে সাতটি অপুষ্ট শীষ উঠল, তা দূর্ভিক্ষের সাত বছর হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","আমি ফরৌণকে এটাই বললাম; “ঈশ্বর যা করতে প্রস্তুত হয়েছেন, তা ফরৌণকে দেখিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","দেখুন, সমস্ত মিশর দেশে সাত বছর প্রচুর শস্য হবে। ");
INSERT INTO benirv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","তার পরে সাত বছর এমন দূর্ভিক্ষ হবে যে, মিশর দেশে সমস্ত শস্য নষ্ট হবে এবং সেই দূর্ভিক্ষে দেশ ধ্বংস হবে। ");
INSERT INTO benirv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","আর সেই পরে আসা দূর্ভিক্ষের জন্য দেশে আগের শস্যপ্রাচুর্য্যতার কথা মনে পড়বে না; কারণ তা খুব কষ্টকর হবে। ");
INSERT INTO benirv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","আর ফরৌণের কাছে দুবার স্বপ্ন দেখাবার ভাব এই; ঈশ্বর এটা স্থির করেছেন এবং ঈশ্বর এটা তাড়াতাড়ি ঘটাবেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","অতএব এখন ফরৌণ একজন সুবুদ্ধি ও জ্ঞানবান পুরুষের চেষ্টা করে তাঁকে মিশর দেশের উপরে নিযুক্ত করুন। ");
INSERT INTO benirv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","আর ফরৌণ এই কাজ করুন; দেশে অধ্যক্ষদের নিযুক্ত করে যে সাত বছর শস্যপ্রাচুর্য্য হবে, সেই দিনের মিশর দেশ থেকে শস্যের পঞ্চমাংশ গ্রহণ করুন। ");
INSERT INTO benirv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","তাঁরা সেই আগামী ভালো বছরগুলিতে খাবার সংগ্রহ করুন ও ফরৌণের অধীনে নগরে নগরে খাবারের জন্য শস্য সঞ্চয় করুন ও রক্ষা করুন। ");
INSERT INTO benirv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","এই ভাবে মিশর দেশে যে দূর্ভিক্ষ হবে, সেই দূর্ভিক্ষের সাত বছরের জন্য সেই খাবার দেশের জন্য সঞ্চিত থাকবে, তাতে দূর্ভিক্ষে দেশ ধ্বংস হবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","তখন ফরৌণের ও তাঁর সব দাসের দৃষ্টিতে এই কথা ভালো মনে হল। ");
INSERT INTO benirv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","আর ফরৌণ নিজের দাসদেরকে বললেন, “এর তুল্য পুরুষ, যাঁর অন্তরে ঈশ্বরের আত্মা আছেন, এমন আর কাকে পাব?” ");
INSERT INTO benirv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","তখন ফরৌণ যোষেফকে বললেন, “ঈশ্বর তোমাকে এই সব জানিয়েছেন, অতএব তোমার মতো সুবুদ্ধি ও জ্ঞানবান কেউই নেই। ");
INSERT INTO benirv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","তুমিই আমার বাড়ির পরিচালক হও; আমার সমস্ত প্রজা তোমার কথায় চলবে, কেবল সিংহাসনে আমি তোমার থেকে বড় থাকব।” ");
INSERT INTO benirv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ফরৌণ যোষেফকে আরও বললেন, “দেখ, আমি তোমাকে সমস্ত মিশর দেশের ওপরে নিযুক্ত করলাম।” ");
INSERT INTO benirv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","পরে ফরৌণ হাত থেকে নিজের আংটি খুলে যোষেফের হাতে দিলেন, তাঁকে কার্পাসের ভালো কাপড় পরালেন এবং তাঁর গলায় সোনার হার দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","আর তাঁকে নিজের দ্বিতীয় রথে আরোহণ করালেন এবং লোকেরা তাঁর আগে আগে “হাঁটু পাত, হাঁটু পাত বলে ঘোষণা করল।” এই ভাবে তিনি সমস্ত মিশর দেশের পরিচালকের পদে নিযুক্ত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","আর ফরৌণ যোষেফকে বললেন, “আমি ফরৌণ, তোমার আদেশ ছাড়া সমস্ত মিশর দেশের কোনো লোক হাত কিংবা পা তুলতে পারবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","আর ফরৌণ যোষেফের নাম “সাফনৎ-পানেহ” রাখলেন এবং তার সঙ্গে ওন নগর-নিবাসী পোটীফেরঃ নামে যাজকের আসনৎ নামের মেয়ের বিয়ে দিলেন। পরে যোষেফ মিশর দেশের মধ্যে যাতায়াত করতে লাগলেন ");
INSERT INTO benirv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","যোষেফ ত্রিশ বছর বয়সে মিশর-রাজ ফরৌণের সামনে দাঁড়িয়ে ছিলেন। পরে যোষেফ ফরৌণের কাছ থেকে চলে গিয়ে মিশর দেশের সব জায়গায় ভ্রমণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","আর প্রচুর শস্য ফলনের সেই সাত বছর ভূমিতে প্রচুর পরিমাণ শস্য জন্মাল। ");
INSERT INTO benirv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","মিশর দেশে উপস্থিত সেই সাত বছরে সব শস্য সংগ্রহ করে তিনি প্রতি নগরে সঞ্চয় করলেন; যে নগরের চার সীমায় যে শস্য হল, সেই নগরে তা সঞ্চয় করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","এই ভাবে যোষেফ সমুদ্রের বালির মতো এমন প্রচুর শস্য সংগ্রহ করলেন যে, তা মাপা বন্ধ করলেন, কারণ তা পরিমাপের বাইরে ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","দূর্ভিক্ষ বছরের আগে যোষেফের দুই ছেলে জন্মাল; ওন-নিবাসী পোটীফেরঃ যাজকের মেয়ে আসনৎ তাঁর জন্য তাদেরকে প্রসব করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","আর যোষেফ তাদের বড় ছেলের নাম মনঃশি ভুলে যাওয়া রাখলেন, কারণ তিনি বললেন, “ঈশ্বর আমার সমস্ত দুঃখের ও আমার বাবার বংশের স্মৃতি ভুলিয়ে দিয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","পরে দ্বিতীয় ছেলের নাম ইফ্রয়িম ফলবান্‌ রাখলেন, কারণ তিনি বললেন, “আমার দুঃখভোগের দেশে ঈশ্বর আমাকে ফলবান করেছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","পরে মিশর দেশে উপস্থিত শস্যপ্রাচুর্য্যের সাত বছর শেষ হল ");
INSERT INTO benirv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","এবং যোষেফ যেমন বলেছিলেন, সেই অনুসারে দূর্ভিক্ষের সাত বছর আরম্ভ হল। সব দেশে দূর্ভিক্ষ হল, কিন্তু সমস্ত মিশর দেশে খাবার ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","পরে সমস্ত মিশর দেশে দূর্ভিক্ষ হলে প্রজারা ফরৌণের কাছে খাবারের জন্য কাঁদল, তাতে ফরৌণ মিশরীয়দের সবাইকে বললেন, “তোমরা যোষেফের কাছে যাও; তিনি তোমাদেরকে যা বলেন, তাই কর।” ");
INSERT INTO benirv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","তখন সমস্ত দেশেই দূর্ভিক্ষ হয়েছিল। আর যোষেফ সব জায়গার গোলা খুলে মিশরীয়দের কাছে শস্য বিক্রি করতে লাগলেন; আর মিশর দেশে দূর্ভিক্ষ প্রবল হয়ে উঠল ");
INSERT INTO benirv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","এবং সবদেশের লোক মিশর দেশে যোষেফের কাছে শস্য কিনতে এল, কারণ সবদেশেই দূর্ভিক্ষ প্রবল হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","আর যাকোব দেখলেন যে, মিশর দেশে শস্য আছে, তাই যাকোব নিজের ছেলেদেরকে বললেন, “তোমরা একজন অন্য জনের মুখ দেখাদেখি কেন করছ?” ");
INSERT INTO benirv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","তিনি আরও বললেন, “দেখ, আমি শুনলাম, মিশরে শস্য আছে, তোমরা সেখানে যাও, আমাদের জন্য শস্য কিনে আন; তা হলে আমরা বাঁচব, মরব না।” ");
INSERT INTO benirv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","পরে যোষেফের দশ জন ভাই শস্য কিনতে মিশরে নেমে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","কিন্তু যাকোব যোষেফের ভাই বিন্যামীনকে ভাইদের সঙ্গে পাঠালেন না; কারণ তিনি বললেন, যদি এর বিপদ ঘটে। ");
INSERT INTO benirv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","যারা সেখানে গিয়েছিল, তাঁদের মধ্যে ইস্রায়েলের ছেলেরাও শস্য কেনার জন্য গেলেন, কারণ কনান দেশেও দূর্ভিক্ষ হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","সেই দিনের যোষেফই ঐ দেশের শাসক ছিলেন, তিনিই দেশীয় সব লোকদের কাছে শস্য বিক্রি করছিলেন; অতএব যোষেফের ভাইয়েরা তাঁর কাছে গিয়ে ভূমিতে নত হয়ে প্রণাম করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","তখন যোষেফ নিজের ভাইদেরকে দেখে চিনতে পারলেন, কিন্তু তাঁদের কাছে অপরিচিতের মতো ব্যবহার করলেন ও কঠোরভাবে তাঁদের সঙ্গে কথা বললেন; তিনি তাঁদেরকে বললেন, “তোমরা কোন জায়গা থেকে এসেছ?” তাঁরা বললেন, “কনান দেশ থেকে খাবার কিনতে এসেছি।” ");
INSERT INTO benirv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","বাস্তবে যোষেফ নিজের ভাইদেরকে চিনতে পারলেন, কিন্তু তাঁরা তাঁকে চিনতে পারলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","আর যোষেফ তাঁদের বিষয়ে যে যে স্বপ্ন দেখেছিলেন তা তাঁর মনে পড়ল এবং তিনি তাঁদেরকে বললেন, “তোমরা গুপ্তচর, দেশের অসুরক্ষিত জায়গা দেখতে এসেছ।” ");
INSERT INTO benirv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","তাঁরা বললেন, “না প্রভু, আপনার এই দাসেরা খাবার কিনতে এসেছে; ");
INSERT INTO benirv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","আমরা সবাই এক বাবার ছেলে; আমরা সৎলোক, আপনার এই দাসেরা চর নয়।” ");
INSERT INTO benirv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","কিন্তু তিনি তাঁদেরকে বললেন, “না না, তোমরা দেশের অসুরক্ষিত জায়গা দেখতে এসেছ।” ");
INSERT INTO benirv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","তাঁরা বললেন, “আপনার এই দাসেরা বারো ভাই, কনান দেশে বসবাসকারী এক জনের ছেলে; দেখুন, আমাদের ছোট ভাই আজ বাবার কাছে আছে এবং এক জন নেই।” ");
INSERT INTO benirv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","তখন যোষেফ তাদেরকে বললেন, “আমি যে তোমাদেরকে বললাম, তোমরা চর, তাই বটে। ");
INSERT INTO benirv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","এই দিয়ে তোমাদের পরীক্ষা করা যাবে; আমি ফরৌণের প্রাণের শপথ করে বলছি, তোমাদের ছোট ভাই এখানে না এলে তোমরা এখান থেকে বের হতে পারবে না। ");
INSERT INTO benirv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","তোমাদের এক জনকে পাঠিয়ে তোমাদের সেই ভাইকে আন, তোমরা বন্দী থাক; এই ভাবে তোমাদের কথার পরীক্ষা হবে, তোমরা সত্যবাদী কি না, তা জানা যাবে;” অথবা আমি ফরৌণের প্রাণের শপথ করে বলছি, “তোমরা অবশ্যই চর।” ");
INSERT INTO benirv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","পরে তিনি তাঁদেরকে তিন দিন কারাগারে বন্দী রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","পরে তৃতীয় দিনের যোষেফ তাঁদেরকে বললেন, “এই কাজ কর, তাতে বাঁচবে; আমি ঈশ্বরকে ভয় করি। ");
INSERT INTO benirv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","তোমরা যদি সৎলোক হও, তবে তোমাদের এক ভাই তোমাদের এই কারাগারে বন্দী থাকুক; তোমরা নিজের নিজের গৃহের দূর্ভিক্ষের জন্য শস্য নিয়ে যাও; ");
INSERT INTO benirv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","পরে তোমাদের ছোট ভাইকে আমার কাছে এন; এই ভাবে তোমাদের কথা প্রমাণ হলে তোমার মারা যাবে না।” তাঁরা তাই করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","আর তাঁরা পরস্পর বললেন, “নিশ্চয়ই আমরা নিজেদের ভাইয়ের বিষয়ে অপরাধী, কারণ সে আমাদের কাছে অনুরোধ করলে আমরা তার প্রাণের কষ্ট দেখেও তাঁ শুনিনি; এই জন্য আমাদের উপরে এই সঙ্কট উপস্থিত হয়েছে।” ");
INSERT INTO benirv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","তখন রুবেন উত্তর করে তাঁদেরকে বললেন, “আমি না তোমাদেরকে বলেছিলাম, ছেলেটির বিরুদ্ধে পাপ কর না? কিন্তু তোমার তা শোননি; দেখ, এখন তার রক্তেরও হিসাব দিতে হচ্ছে।” ");
INSERT INTO benirv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","কিন্তু যোষেফ যে তাঁদের এই কথা বুঝলেন, এটা তাঁরা জানতে পারলেন না, কারণ দুটো ভাষার মাধ্যমে উভয় পক্ষের মধ্যে কথাবার্তা হচ্ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","তখন তিনি তাঁদের কাছ থেকে সরে গিয়ে কাঁদলেন; পরে ফিরে এসে তাঁদের সঙ্গে কথা বললেন ও তাঁদের মধ্যে শিমিয়োনকে ধরে তাঁদের সামনেই বাঁধলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","পরে যোষেফ তাঁদের সব থলেতে শস্য ভরতে প্রত্যেক জনের থলে টাকা ফিরিয়ে দিতে ও তাঁদেরকে যাত্রা পথের খাবার দিতে আজ্ঞা দিলেন; আর তাঁদের জন্য সেরকম করা হল। ");
INSERT INTO benirv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","পরে তাঁরা নিজের নিজের গাধার ওপরে শস্য চাপিয়ে সেখান থেকে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","কিন্তু সরাইখানায় যখন এক জন নিজের গাধাকে খাবার দিতে থলে খুললেন, তখন নিজের টাকা দেখলেন, আর দেখ, থলের মুখেই টাকা। ");
INSERT INTO benirv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","তাতে তিনি ভাইদের বললেন, “আমার টাকা ফিরেছে; দেখ, আমার থলেতেই আছে।” তখন তাঁদের প্রাণ উড়ে গেল ও সবাই ভয়ে কাঁপতে কাঁপতে বললেন, “ঈশ্বর আমাদের প্রতি এ কি করলেন?” ");
INSERT INTO benirv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","পরে তাঁরা কনান দেশে নিজেদের বাবা যাকোবের কাছে উপস্থিত হলেন। ও তাঁদের প্রতি যা যা ঘটেছিল, সে সব তাঁকে জানালেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","বললেন, “যে ব্যক্তি সেই দেশের শাসক,” তিনি আমাদেরকে কঠোর কথা বললেন, আর দেশ অনুসন্ধানকারী চর মনে করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","আমরা তাঁকে বললাম, “আমরা সৎ লোক, চর নই; ");
INSERT INTO benirv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","আমরা বারো ভাই, সবাই এক বাবার ছেলে; কিন্তু একজন নেই এবং ছোটটি আজ কনান দেশে বাবার কাছে আছে।” ");
INSERT INTO benirv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","তখন সেই ব্যক্তি, সেই দেশের শাসক আমাদেরকে বললেন, “এতেই জানতে পারব যে, তোমরা সৎলোক; তোমাদের এক ভাইকে আমার কাছে রেখে তোমাদের গৃহের দূর্ভিক্ষের জন্য শস্য নিয়ে যাও। ");
INSERT INTO benirv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","পরে তোমাদের ছোট ভাইকে আমার কাছে এন, তাতে বুঝতে পারব যে, তোমরা চর না, তোমরা সৎলোক; আর আমি তোমাদের ভাইকে তোমাদের কাছে দেব এবং তোমরা দেশে বাণিজ্য করতে পারবে।” ");
INSERT INTO benirv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","পরে তাঁরা থলে থেকে শস্য ঢাললে দেখ, প্রত্যেক জন নিজের নিজের থলেতে নিজের নিজের টাকার গোছ পেলেন। তখন সেই সব টাকার গোছ দেখে তাঁরা ও তাঁদের বাবা ভয় পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","আর তাঁদের বাবা যাকোব বললেন, “তোমরা আমাকে পুত্রহীন করেছ; যোষেফ নেই, শিমিয়ন নেই, আবার বিন্যামীনকেও নিয়ে যেতে চাইছ; এই সবই আমার বিরুদ্ধে।” ");
INSERT INTO benirv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","তখন রুবেন তাঁর বাবাকে বললেন, “আমি যদি তোমার কাছে তাঁকে না আনি, তবে আমার দুই ছেলেকে হত্যা কর; আমার হাতে তাঁকে সমর্পণ কর; আমি তোমার কাছে তাঁকে আবার এনে দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","তখন তিনি বললেন, “আমার ছেলে তোমাদের সঙ্গে যাবে না, কারণ তার ভাই মারা গিয়েছে, সে একা আছে; তোমরা যে পথে যাবে, সেই পথে যদি এর কোনো বিপদ ঘটে, তবে শোকে এই পাকা চুলে আমাকে পাতালে নামিয়ে দেবে।” ");
INSERT INTO benirv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","তখন কানন দেশে খুব দূর্ভিক্ষ ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","আর তাঁরা মিশর থেকে যে শস্য এনেছিলেন, সে সমস্ত খাওয়া হয়ে গেলে তাঁদের বাবা তাঁদেরকে বললেন, “তোমরা আবার যাও, আমাদের জন্য কিছু খাবার কিনে আন।” ");
INSERT INTO benirv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","তখন যিহূদা তাঁকে বললেন, “সেই ব্যক্তি দৃঢ় প্রতিজ্ঞা করে আমাদেরকে বলেছেন, তোমাদের ভাই তোমাদের সঙ্গে না এলে তোমরা আমার মুখ দেখতে পাবে না। ");
INSERT INTO benirv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","যদি তুমি আমাদের সঙ্গে আমাদের ভাইকে পাঠাও, তবে আমরা গিয়ে তোমার জন্য খাবার কিনে আনব। ");
INSERT INTO benirv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","কিন্তু যদি না পাঠাও, তবে যাব না;” কারণ সে ব্যক্তি আমাদেরকে বলেছেন, “তোমাদের ভাই তোমাদের সঙ্গে না আসলে তোমরা আমার মুখ দেখতে পাবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","তখন ইস্রায়েল বললেন, “আমার সঙ্গে এমন খারাপ ব্যবহার কেন করেছ? ঐ ব্যক্তিকে কেন বলেছ যে, তোমাদের আর এক ভাই আছে?” ");
INSERT INTO benirv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","তাঁরা বললেন, “তিনি আমাদের বিষয়ে ও আমাদের বংশের বিষয়ে বিস্তারিতভাবে জিজ্ঞাসা করলেন,” বললেন, “তোমাদের বাবা কি এখনও জীবিত আছেন? তোমাদের কি আরো ভাই আছে?” তাতে আমরা সেই কথা অনুসারে উত্তর করেছিলাম। আমরা কিভাবে জানব যে, তিনি বলবেন, “তোমাদের ভাইকে এখানে আন?” ");
INSERT INTO benirv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","যিহূদা নিজের বাবা ইস্রায়েলকে আরও বললেন, “বালকটিকে আমার সঙ্গে পাঠিয়ে দাও; আমরা উঠে চলে যাই, তাতে তুমি ও আমাদের বালকেরা ও আমরা বাঁচব; কেউ মরব না। ");
INSERT INTO benirv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","আমিই তার জামিন হলাম, আমারই হাত থেকে তাকে নিও, আমি যদি তোমার কাছে তাকে না আনি, তোমার সামনে তাকে উপস্থিত না করি, তবে আমি যাবজ্জীবন তোমার কাছে অপরাধী থাকব। ");
INSERT INTO benirv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","এত দেরী না করলে আমরা এর মধ্যে দ্বিতীয় বার ফিরে আসতে পারতাম।” ");
INSERT INTO benirv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","তখন তাঁদের বাবা ইস্রায়েল তাঁদেরকে বললেন, “যদি তাই হয়, তবে এক কাজ কর; তোমরা নিজের নিজের পাত্রে এই দেশের সেরা জিনিস, গুগগুলু, মধু, সুগন্ধি জিনিস, গন্ধরস, পেস্তা ও বাদাম কিছু কিছু নিয়ে গিয়ে সেই ব্যক্তিকে উপহার দাও। ");
INSERT INTO benirv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","আর নিজের নিজের হাতে দ্বিগুন টাকা নাও এবং তোমাদের থলির মুখে যে টাকা ফিরে এসেছে তাও হাতে করে আবার নিয়ে যাও কি জানি বা ভুল হয়েছিল ");
INSERT INTO benirv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","আর তোমাদের ভাইকে নাও, ওঠ, আবার সেই ব্যক্তির কাছে যাও। ");
INSERT INTO benirv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","সর্বশক্তিমান ঈশ্বর তোমাদেরকে সেই ব্যক্তির কাছে করুণার পাত্র করুন, যেন তিনি তোমাদের অন্য ভাইকে ও বিন্যামীনকে ছেড়ে দেন। আর যদি আমাকে পুত্রহীন হতে হয়, তবে পুত্রহীন হলাম।” ");
INSERT INTO benirv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","তখন তারা সেই উপহারের জিনিস নিলেন, আর হাতে দ্বিগুন টাকা ও বিন্যামীনকে নিয়ে যাত্রা করলেন এবং মিশরে গিয়ে যোষেফের সামনে দাঁড়ালেন। ");
INSERT INTO benirv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","যোষেফ তাদের সঙ্গে বিন্যামীনকে দেখে নিজের বাড়ির পরিচারককে বললেন, “এই কজন লোককে বাড়ির ভিতরে নিয়ে যাও, আর পশু মেরে খাবার তৈরী কর; কারণ এরা দুপুরে আমার সঙ্গে খাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","সেই ব্যক্তিকে, যোষেফ যেমন বললেন, সেরকম করল, তাদেরকে যোষেফের বাড়িতে নিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","কিন্তু যোষেফের বাড়িতে উপস্থিত হওয়াতে তাঁরা ভয় পেলেন ও পরস্পর বললেন, “আগে আমাদের থলিতে যে টাকা ফিরে গিয়েছিল, তারই জন্য ইনি আমাদেরকে এখানে নিয়ে এসেছেন; এখন আমাদের ওপরে পড়ে আক্রমণ করবেন ও আমাদের গাধা নিয়ে আমাদেরকে দাস করে রাখবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","অতএব তাঁরা যোষেফের বাড়ির পরিচালকের কাছে গিয়ে বাড়ির দরজায় তার সঙ্গে কথা বললেন, ");
INSERT INTO benirv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“মহাশয়, আমারা আগে খাবার কিনতে এসেছিলাম; ");
INSERT INTO benirv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","পরে ভাড়া নেওয়া জায়গায় গিয়ে নিজের নিজের থলে খুললাম, আর দেখুন, প্রত্যেক জনের থলের মুখে তার টাকা, যেমন আমাদের আনা টাকা আছে; তা আমরা আবার হাতে করে এনেছি; ");
INSERT INTO benirv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","এবং খাবার কেনার জন্য আরো টাকা এনেছি; আমাদের সেই টাকা আমাদের থলেতে কে রেখেছিল, তা আমরা জানি না।” ");
INSERT INTO benirv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","সেই ব্যক্তি বলল, “তোমাদের মঙ্গল হোক, ভয় কর না; তোমাদের ঈশ্বর, তোমাদের পৈতৃক ঈশ্বর তোমাদের থলেতে তোমাদেরকে গুপ্ত ধন দিয়েছেন; আমি তোমাদের টাকা পেয়েছি।” পরে সে শিমিয়োনকে তাঁদের কাছে আনল। ");
INSERT INTO benirv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","আর সে তাঁদেরকে যোষেফের বাড়ির ভিতরে নিয়ে গিয়ে জল দিল, তাতে তাঁরা পা ধুলেন এবং সে তাঁদের গাধাগুলিকে খাবার দিল। ");
INSERT INTO benirv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","আর দুপুরে যোষেফ আসবেন বলে তাঁরা উপহার সাজালেন, কারণ তাঁরা শুনেছিলেন যে, সেখানে তাঁদেরকে খাবার খেতে হবে। ");
INSERT INTO benirv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","পরে যোষেফ বাড়ি ফিরে এলে তাঁরা হাতের ওপরে রাখা উপহার ঘরের মধ্যে তাঁর কাছে আনলেন, ও তাঁর সামনে মাটিতে নত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","তখন তিনি ভালো-মন্দ জিজ্ঞাসা করে তাঁদেরকে বললেন, “তোমাদের যে বৃদ্ধ বাবার কথা বলেছিলে, তিনি ভালো তো? তিনি কি এখনও জীবিত আছেন?” ");
INSERT INTO benirv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","তাঁরা বললেন, “আপনার দাস আমাদের বাবা ভালো আছেন, তিনি এখনও জীবিত আছেন।” পরে তাঁরা উপুড় হয়ে প্রণাম করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","তখন যোষেফ চোখ তুলে নিজের ভাই বিন্যামীনকে, নিজের ভাইকে দেখে বললেন, “তোমাদের যে ছোট ভাইয়ের কথা আমাকে বলেছিলে, সে কি এই?” আর তিনি বললেন, “বৎস, ঈশ্বর তোমার প্রতি অনুগ্রহ করুন।” ");
INSERT INTO benirv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","তখন যোষেফ তাড়াতাড়ি করলেন, কারণ তাঁর ভাইয়ের জন্য তাঁর প্রাণ কাঁদছিল, তাই তিনি কাঁদবার জায়গা খুঁজলেন, আর নিজের ঘরে প্রবেশ করে সেখানে কাঁদলেন। ");
INSERT INTO benirv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","পরে তিনি মুখ ধুয়ে বাইরে আসলেন ও নিজেকে সামলে খাবার পরিবেশন করতে আদেশ দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","তখন তাঁর জন্য আলাদা ও তাঁর ভাইদের জন্য আলাদা এবং তাঁর সঙ্গে ভোজনকারী মিশরীয়দের জন্য আলাদা পরিবেশন করা হল, কারণ ইব্রীয়দের সঙ্গে মিশরীয়েরা খাবার খায় না; কারণ তা মিশরীয়দের ঘৃণার কাজ। ");
INSERT INTO benirv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","আর তাঁরা যোষেফের সামনে বড় বড়র জায়গায় ও ছোট ছোটর জায়গায় বসলেন; তখন তাঁরা পরস্পর আশ্চর্য্য বলে মনে করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","আর তিনি নিজের সামনে থেকে খাবারের অংশ তুলে তাঁদেরকে পরিবেশন করালেন; কিন্তু সবার অংশ থেকে বিন্যামীনের অংশ পাঁচ গুণ বেশি ছিল। পরে তাঁরা পান করলেন ও তাঁর সঙ্গে আনন্দিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","আর যোষেফ বাড়ির পরিচালককে আজ্ঞা করলেন, এই লোকদের থলেতে যত শস্য ধরে, ভরে দাও এবং প্রতিজনের টাকা তার থলের মুখে রাখ। ");
INSERT INTO benirv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","আর কনিষ্ঠের থলের মুখে তার শস্য কেনার টাকার সঙ্গে আমার বাটি অর্থাৎ রূপার বাটি রাখ। তখন সে যোষেফের বলা কথানুসারে কাজ করল। ");
INSERT INTO benirv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","আর সকাল হওয়ামাত্র তাঁরা গাধাদের সঙ্গে বিদায় পেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","তাঁরা নগর থেকে বের হয়ে অনেক দূরে যেতে না যেতে যোষেফ নিজের বাড়ির পরিচালককে বললেন, “ওঠ, ঐ লোকদের পিছনে দৌড়িয়ে গিয়ে তাদের সঙ্গ ধরে বল তোমরা উপকারের পরিবর্তে কেন অপকার করলে? ");
INSERT INTO benirv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","আমার প্রভু যাতে পান করেন ও যার মাধ্যমে গণনা করেন, এ কি সেই বাটি না? এই কাজ করায় তোমরা দোষ করেছ।” ");
INSERT INTO benirv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","পরে সে তাদেরকে নাগালে পেয়ে সেইকথা বলল। ");
INSERT INTO benirv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","তাঁরা বললেন, “মহাশয়, কেন এমন কথা বললেন? আপনার দাসেরা যে এমন কাজ করবে, তা দূরে থাকুক। ");
INSERT INTO benirv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","দেখুন, আমরা নিজের নিজের থলের মুখে যে টাকা পেয়েছিলাম, তা কনান দেশ থেকে আবার আপনার কাছে এনেছি; তবে আমরা কি কোনো মতে আপনার প্রভুর গৃহ থেকে রূপা বা সোনা চুরি করব? ");
INSERT INTO benirv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","আপনার দাসদের মধ্যে যার কাছে তা পাওয়া যায়, সে মরুক এবং আমরাও প্রভুর দাস হব।” ");
INSERT INTO benirv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","সে বলল, “ভাল, এক্ষণে তোমাদের কথানুসারেই হোক; যার কাছে তা পাওয়া যাবে, সে আমার দাস হবে, কিন্তু আর সবাই নির্দোষ হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","তখন তাঁরা তাড়াতাড়ি করে নিজেদের থলিগুলি মাটিতে নামিয়ে প্রত্যেকে নিজের নিজের থলে খুললেন। ");
INSERT INTO benirv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","আর সে বড় থেকে আরম্ভ করে ছোট পর্যন্ত খুঁজল; আর বিন্যামীনের থলেতে সেই বাটি পাওয়া গেল। ");
INSERT INTO benirv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","তখন তাঁরা নিজের নিজের পোশাক ছিঁড়লেন ও নিজের নিজের গাধায় থলে চাপিয়ে নগরে ফিরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","পরে যিহূদা ও তাঁর ভাইরা যোষেফের বাড়িতে আসলেন; তিনি তখনও সেখানে ছিলেন; আর তাঁরা তাঁর আগে মাটিতে পড়লেন। ");
INSERT INTO benirv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","তখন যোষেফ তাঁদেরকে বললেন, “তোমরা এ কেমন কাজ করলে? আমার মত পুরুষ অবশ্য গণনা করতে পারে, এটা কি তোমরা জান না?” ");
INSERT INTO benirv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","যিহূদা বললেন, “আমরা প্রভুর কাছে কি উত্তর দেব? কি কথা বলব? কিসেই বা নিজেদেরকে নির্দোষ দেখাব? ঈশ্বর আপনার দাসদের অপরাধ প্রকাশ করেছেন, দেখুন, আমরা ও যার কাছে বাটি পাওয়া গিয়েছে, সবাই প্রভুর দাস হলাম।” ");
INSERT INTO benirv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","যোষেফ বললেন, “এমন কাজ আমার থেকে দূরে থাকুক; যার কাছে বাটি পাওয়া গিয়েছে, সেই আমার দাস হবে, কিন্তু তোমরা ভালোভাবে বাবার কাছে ফিরে যাও।” ");
INSERT INTO benirv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","তখন যিহূদা কাছে গিয়ে বললেন, “হে প্রভু, অনুরোধ করি, আপনার দাসকে প্রভুর কানে একটি কথা বলতে অনুমতি দিন; এই দাসের প্রতি আপনার রাগ প্রজ্বলিত না হোক, কারণ আপনি ফরৌণের সমান।” ");
INSERT INTO benirv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","প্রভু এই দাসদেরকে জিজ্ঞাসা করেছিলেন, “তোমাদের বাবা কি ভাই আছে?” ");
INSERT INTO benirv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","আমরা প্রভুকে উত্তর করেছিলাম, “আমাদের বৃদ্ধ বাবা আছেন এবং তাঁর বৃদ্ধ অবস্থায় এক ছোট ছেলে আছে; তার ভাই মারা গিয়েছে; সেই একমাত্র তার মায়ের অবশিষ্ট ছেলে এবং তার বাবা তাকে ভালবাসেন।” ");
INSERT INTO benirv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","পরে আপনি এই দাসদেরকে বলেছিলেন, “তোমরা আমার কাছে তাকে আন, আমি তাকে স্বচক্ষে দেখব।” ");
INSERT INTO benirv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","তখন আমরা প্রভুকে বলেছিলাম, “সেই যুবক বাবাকে ছেড়ে আসতে পারবে না, সে বাবাকে ছেড়ে আসলে বাবা মারা যাবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","তাতে আপনি এই দাসদেরকে বলেছিলেন, সেই ছোট ভাইটি তোমাদের সঙ্গে না আসলে তোমরা আমার মুখ আর দেখতে পাবে না। ");
INSERT INTO benirv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","আমরা আপনার দাস যে আমার বাবা, তাঁর কাছে গিয়ে তাঁকে প্রভুর সেই সব কথা বললাম। ");
INSERT INTO benirv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","পরে আমাদের বাবা বললেন, “তোমরা আবার যাও, আমাদের জন্য কিছু খাবার কিনে আন।” ");
INSERT INTO benirv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","আমরা বললাম, “যেতে পারব না; যদি ছোট ভাই আমাদের সঙ্গে থাকে, তবে যাই; কারণ ছোট ভাইটি সঙ্গে না থাকলে আমরা সেই ব্যক্তির মুখ দেখতে পাব না।” ");
INSERT INTO benirv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","তাতে আপনার দাস আমার বাবা বললেন, “তোমরা জান, আমার সেই স্ত্রী থেকে দুটি মাত্র সন্তান জন্মায়। ");
INSERT INTO benirv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","তাদের মধ্যে এক জন আমার কাছ থেকে চলে গেল,” আর আমি বললাম, “সে নিশ্চয় খণ্ড খণ্ড হয়েছে এবং সেই থেকে আমি তাঁকে আর দেখতে পাইনি।” ");
INSERT INTO benirv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","এখন আমার কাছ থেকে একেও নিয়ে গেলে যদি এর কোনো বিপদ ঘটে, তবে তোমরা শোকে এই পাকা চুলে আমাকে পাতালে নামিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","অতএব আপনার দাস যে আমার বাবা, আমি তাঁর কাছে উপস্থিত হলে আমাদের সঙ্গে যদি এই যুবক না থাকে, ");
INSERT INTO benirv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","তবে এই যুবকের প্রাণে তাঁর প্রাণ বাঁধা আছে বলে, যুবকটি নেই দেখলে তিনি মারা পড়বেন; এই ভাবে আপনার এই দাসেরা শোকে পাকা চুলে আপনার দাস আমাদের বাবাকে পাতালে নামিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","আবার আপনার দাস আমি বাবার কাছে এই যুবকটির জামিন হয়ে বলেছিলাম, আমি যদি তাকে তোমার কাছে না আনি, যাবজ্জীবন বাবার কাছে অপরাধী থাকব। ");
INSERT INTO benirv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","অতএব অনুরোধ করি, প্রভুর কাছে এই যুবকটির পরিবর্তে আপনার দাস আমি প্রভুর দাস হয়ে থাকি, কিন্তু এই যুবককে আপনি তাঁর ভাইদের সঙ্গে যেতে দিন। ");
INSERT INTO benirv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","কারণ এই যুবকটি আমার সঙ্গে না থাকলে আমি কিভাবে বাবার কাছে যেতে পারি? যদি বাবার যে বিপদ ঘটে, তাই আমাকে দেখতে হয়। ");
INSERT INTO benirv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","তখন যোষেফ নিজের কাছে দাঁড়িয়ে থাকা লোকদের সামনে নিজেকে নিয়ন্ত্রণ করতে পারলেন না; তিনি উচ্চৈঃস্বরে বললেন, “আমার সামনে থেকে সব লোককে বের কর।” তাতে কেউ তাঁর কাছে দাঁড়াল না, আর তখনই যোষেফ ভাইদের কাছে নিজের পরিচয় দিতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","তিনি উচ্চৈঃস্বরে কাঁদলেন; মিশরীয়েরা তা শুনতে পেল ও ফরৌণের গৃহে অবস্থিত লোকেরাও শুনতে পেল। ");
INSERT INTO benirv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","পরে যোষেফ তাঁর ভাইদের বললেন, “আমি যোষেফ; আমার বাবা কি এখনও জীবিত আছেন?” এতে তাঁর ভাইরা তাঁর সামনে বিস্মিত হয়ে পড়লেন, উত্তর করতে পারলেন না। ");
INSERT INTO benirv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","পরে যোষেফ নিজের ভাইদের বললেন, “অনুরোধ করি, আমার কাছে এস।” তাঁরা কাছে গেলেন। তিনি বললেন, “আমি যোষেফ, তোমাদের ভাই, যাকে তোমরা মিশরগামীদের কাছে বিক্রি করেছিলে।” ");
INSERT INTO benirv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","কিন্তু তোমরা আমাকে এই জায়গায় বিক্রি করেছ বলে এখন দুঃখিত কি বিরক্ত হয়ো না; কারণ প্রাণ রক্ষা করবার জন্যই ঈশ্বর তোমাদের আগে আমাকে পাঠিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","কারণ দুই বছর ধরে দেশে দূর্ভিক্ষ হয়েছে; আরও পাঁচ বছর পর্যন্ত চাষ কি ফসল হবে না। ");
INSERT INTO benirv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","আর ঈশ্বর পৃথিবীতে তোমাদের বংশ রক্ষা ও মহৎ উদ্ধারের দ্বারা তোমাদেরকে বাঁচাতে তোমাদের আগে আমাকে পাঠিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","অতএব তোমরাই আমাকে এই জায়গায় পাঠিয়েছ, তা নয়, ঈশ্বর পাঠিয়েছেন এবং আমাকে ফরৌণের পিতৃস্থানীয়, তাঁর সমস্ত বাড়ির প্রভু ও সমস্ত মিশর দেশের ওপরে শাসনকর্ত্তা করেছেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","তোমরা তাড়াতাড়ি করে আমার বাবার কাছে যাও, তাঁকে বল, তোমার ছেলে যোষেফ এরকম বলল, ঈশ্বর আমাকে সমস্ত মিশর দেশের কর্তা করেছেন; তুমি আমার কাছে চলে এস, দেরী কোরো না। ");
INSERT INTO benirv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","তুমি ছেলে ও নাতিদের ও গরু ও ভেড়া সব কিছুর সঙ্গে গোশন প্রদেশে বাস করবে; তুমি আমার কাছেই থাকবে। ");
INSERT INTO benirv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","সেই জায়গায় আমি তোমাকে প্রতিপালন করব, কারণ আরও পাঁচ বছর দূর্ভিক্ষ থাকবে; যদি তোমার ও তোমার পরিজনের ও তোমার সকল লোকদের অভাব হয়। ");
INSERT INTO benirv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","আর দেখ, তোমরা ও আমার ভাই বিন্যামীন সরাসরি দেখছ যে, আমি নিজ মুখে তোমাদের সঙ্গে কথাবার্তা বলছি। ");
INSERT INTO benirv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","অতএব এই মিশর দেশে আমার প্রতাপ ও তোমরা যা যা দেখেছ, সে সব আমার বাবাকে জানাবে এবং তাঁকে তাড়াতাড়ি এই জায়গায় আনবে। ");
INSERT INTO benirv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","পরে যোষেফ নিজের ভাই বিন্যামীনের গলা ধরে কাঁদলেন এবং বিন্যামীনও তাঁর গলা ধরে কাঁদলেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","আর যোষেফ অন্য সব ভাইকেও চুম্বন করলেন ও তাদের গলা ধরে কাঁদলেন; তার পরে তাঁর ভাইরা তাঁর সঙ্গে আলাপ করতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","আর যোষেফের ভাইরা এসেছে, ফরৌণের বাড়িতে এই কথা উপস্থিত হলে ফরৌণ ও তাঁর দাসরা সবাই সন্তুষ্ট হলেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","আর ফরৌণ যোষেফকে বললেন, “তুমি তোমার ভাইদের বল, তোমরা এই কাজ কর; তোমাদের পশুদের পিঠে শস্য চাপিয়ে কনান দেশে যাও এবং ");
INSERT INTO benirv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","তোমাদের বাবাকে ও নিজের নিজের পরিবারকে আমার কাছে নিয়ে এস; আমি তোমাদেরকে মিশর দেশের ভালো জিনিস দেব, আর তোমরা দেশের বেশি অংশ ভোগ করবে। ");
INSERT INTO benirv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","এখন তোমার প্রতি আমার আদেশ এই, তোমরা এই কাজ কর, তোমরা নিজের নিজের ছেলে মেয়েদের ও স্ত্রীদের জন্য মিশর দেশ থেকে মালবাহী গাড়ি নিয়ে গিয়ে তাদেরকে ও নিজেদের বাবাকে নিয়ে এস; ");
INSERT INTO benirv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","আর নিজের নিজের দ্রব্য সামগ্রীর মমতা কোরো না, কারণ সমস্ত মিশর দেশের ভালো জিনিস তোমাদেরই।” ");
INSERT INTO benirv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","তখন ইস্রায়েলের ছেলেরা তাই করলেন এবং যোষেফ ফরৌণের আজ্ঞানুসারে তাদেরকে মালবাহী গাড়ি দিলেন এবং যাত্রা পথের জিনিসও দিলেন; ");
INSERT INTO benirv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","তিনি প্রত্যেক জনকে এক এক জোড়া বস্ত্র দিলেন, কিন্তু বিন্যামীনকে তিনশো রূপার মুদ্রা ও পাঁচ জোড়া বস্ত্র দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","আর বাবার জন্য এই সব জিনিস পাঠালেন, দশ গাধাতে চাপিয়ে মিশরের ভালো জিনিস এবং বাবার যাত্রাপথের জন্য দশ গাধীতে চাপিয়ে শস্য ও রুটি প্রভৃতি খাবার। ");
INSERT INTO benirv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","এই ভাবে তিনি নিজের ভাইদেরকে বিদায় করলে তাঁরা চলে গেলেন; তিনি তাঁদেরকে বলে দিলেন, “পথে ঝগড়া কর না।” ");
INSERT INTO benirv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","পরে তাঁরা মিশর থেকে যাত্রা করে কনান দেশে তাদের বাবা যাকোবের কাছে উপস্থিত হলেন ");
INSERT INTO benirv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ও তাকে বললেন যোষেফ এখনও জীবিত আছে, আবার সমস্ত মিশর দেশের ওপরে সেই শাসনকর্ত্তা হয়েছে, তবুও তাঁর হৃদয় বিস্মিত থাকল, কারণ তাঁদের কথায় তাঁর বিশ্বাস হল না। ");
INSERT INTO benirv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","কিন্তু যোষেফ তাঁদেরকে যে সব কথা বলেছিলেন, সে সকল যখন তাঁরা তাঁকে বললেন এবং তাঁকে নিয়ে যাবার জন্যে যোষেফ যে সব মালগাড়ি পাঠিয়েছিলেন, তা যখন তিনি দেখলেন, তখন তাঁদের বাবা যাকোবের আত্মা পুনর্জীবিত হয়ে উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","আর ইস্রায়েল বললেন, “এই যথেষ্ট; আমার ছেলে যোষেফ এখনও জীবিত আছে; আমি যাব ও মৃত্যুর আগে তাকে দেখব।” ");
INSERT INTO benirv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","পরে ইস্রায়েল নিজের সর্বস্বের সঙ্গে যাত্রা করে বের-শেবাতে আসলেন এবং নিজের বাবা ইসহাকের ঈশ্বরের উদ্দেশ্যে বলিদান করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","পরে ঈশ্বর রাতে ইস্রায়েলকে দর্শন দিয়ে বললেন, “হে যাকোব, হে যাকোব।” তিনি উত্তর করলেন, “দেখ, এই আমি।” ");
INSERT INTO benirv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","তখন তিনি বললেন, “আমি ঈশ্বর, তোমার বাবার ঈশ্বর; তুমি মিশরে যেতে ভয় কোরো না, কারণ আমি সেই জায়গায় তোমাকে বড় জাতি করব।” ");
INSERT INTO benirv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","আমিই তোমার সঙ্গে মিশরে যাব এবং আমিই সেখান থেকে তোমাকে ফিরিয়েও আনব, আর যোষেফ তোমার চোখে হাত দেবে। ");
INSERT INTO benirv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","পরে যাকোব বের-শেবা থেকে যাত্রা করলেন। ইস্রায়েলের ছেলেরা নিজেদের বাবা যাকোবকে এবং নিজের নিজের ছেলেমেয়ে ও স্ত্রীদেরকে সেই সব মালবাহী গাড়িতে করে নিয়ে গেলেন, যা ফরৌণ তাদের বহনের জন্য পাঠিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","পরে তাঁরা, যাকোব ও তাঁর সমস্ত বংশ, নিজেদের পশুরা ও কনান দেশে উপার্জিত সব সম্পত্তি নিয়ে মিশর দেশে পৌঁছালেন। ");
INSERT INTO benirv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","এই ভাবে যাকোব নিজের ছেলে নাতি, মেয়ে নাতনি প্রভৃতি সমস্ত বংশকে সঙ্গে করে মিশরে নিয়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ইস্রায়েলীয়রা, যাকোব ও তাঁর ছেলেমেয়েরা, যাঁরা মিশরে গেলেন, তাঁদের নাম। যাকোবের বড় ছেলে রুবেণ। ");
INSERT INTO benirv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","রুবেণের ছেলে হনোক, পললু, হিষ্রোণ ও কর্মি। ");
INSERT INTO benirv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","শিমিয়োনের ছেলে যিমূয়েল, যামীন, ওহদ, যাখীন, সোহর ও তার কনানীয়া স্ত্রীজাত ছেলে শৌল। ");
INSERT INTO benirv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","লেবির ছেলে গের্শোন, কহাৎ ও মরারি। ");
INSERT INTO benirv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","যিহূদার ছেলে এর, ওনন, শেলা, পেরস ও সেরহ। কিন্তু এর ও ওনন কনান দেশে মারা গিয়েছিল এবং পেরসের ছেলে হিষ্রোণ ও হামূল। ");
INSERT INTO benirv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ইষাখরের ছেলে তোলয়, পূয়, যোব ও শিম্রোণ। ");
INSERT INTO benirv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","আর সবূলূনের ছেলে সেরদ, এলোন ও যহলেল। ");
INSERT INTO benirv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","তারা লেয়ার সন্তান; তিনি পদ্দন-অরামে যাকোবের জন্য এদেরকে ও তার মেয়ে দীণাকে প্রসব করেন। যাকোবের এই ছেলে মেয়েরা সবশুদ্ধ তেত্রিশ জন। ");
INSERT INTO benirv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","আর গাদের ছেলে সিফিয়োন, হগি, শুনী, ইষবোন, এরি, অরোদী ও অরেলী। ");
INSERT INTO benirv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","আশেরের ছেলে যিম্না, যিশবা, যিশবি, বরিয় ও তাদের বোন সেরহ। বরিয়ের ছেলে হেবর ও মল্কীয়েল। ");
INSERT INTO benirv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","এরা সেই সিল্পার সন্তান, যাকে লাবন নিজের মেয়ে লেয়াকে দিয়েছিলেন; সে যাকোবের জন্য এদেরকে প্রসব করেছিলেন। এরা ষোল জন ");
INSERT INTO benirv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","আর যাকোবের স্ত্রী রাহেলের ছেলে যোষেফ ও বিন্যামীন। ");
INSERT INTO benirv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","যোষেফের ছেলে মনঃশি ও ইফ্রয়িম মিশর দেশে জন্মেছিল; ওন নগরের পোটীফেরঃ যাজকের মেয়ে আসনৎ তাঁর জন্য তাদেরকে প্রসব করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","বিন্যামীনের ছেলে বেলা, বেখর, অসবেল, গেরা, নামন, এহী, রোশ, মুপপীম, হুপপীম ও অর্দ। ");
INSERT INTO benirv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","এই চৌদ্দ জন যাকোবের থেকে জন্মানো রাহেলের ছেলে। ");
INSERT INTO benirv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","আর দানের ছেলে হুশীম। ");
INSERT INTO benirv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","নপ্তালির ছেলে যহসিয়েল, গূনি, যেৎসর ও শিল্লেম। ");
INSERT INTO benirv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","এরা সেই বিলহার ছেলে, যাকে লাবন নিজের মেয়ে রাহেলকে দিয়েছিলেন। সে যাকোবের জন্য এদেরকে প্রসব করেছিল; এরা সবশুদ্ধ সাত জন। ");
INSERT INTO benirv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","যাকোবের দেহ থেকে সৃষ্টি যে লোকেরা তাঁর সঙ্গে মিশরে উপস্থিত হল, যাকোবের ছেলের স্ত্রীরা ছাড়া তারা সবশুদ্ধ ছেষট্টি জন। ");
INSERT INTO benirv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","মিশরে যোষেফের যে ছেলেরা জন্মেছিল, তারা দুই জন। যাকোবের আত্মীয়েরা, যারা মিশরে গেল, তারা সবশুদ্ধ সত্তর জন। ");
INSERT INTO benirv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","পরে আগে আগে গোশনের পথ দেখবার জন্যে যাকোব নিজের আগে যিহূদাকে যোষেফের কাছে পাঠালেন; আর তাঁরা গোশন প্রদেশে পৌঁছালেন। ");
INSERT INTO benirv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","তখন যোষেফ নিজের রথ সাজিয়ে গোশনে তাঁর বাবা ইস্রায়েলের সঙ্গে দেখা করতে গেলেন; আর তাকে দেখা দিয়ে তাঁর গলা ধরে অনেকক্ষণ কাঁদলেন। ");
INSERT INTO benirv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","তখন ইস্রায়েল যোষেফকে বললেন, “এখন স্বচ্ছন্দে মরব, কারণ তোমার মুখ দেখতে পেলাম, তুমি এখনও জীবিত আছ।” ");
INSERT INTO benirv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","পরে যোষেফ নিজের ভাইদেরকে ও বাবার আত্মীয়দেরকে বললেন, “আমি গিয়ে ফরৌণকে সংবাদ দেব, তাঁকে বলব, আমার ভাইরা ও বাবার সমস্ত আত্মীয় কনান দেশ থেকে আমার কাছে এসেছেন; ");
INSERT INTO benirv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","তাঁরা ভেড়াপালক, তাঁরা পশুপাল রাখেন; আর তাঁদের গরু ও ভেড়ার পাল এবং সব কিছু এনেছেন।” ");
INSERT INTO benirv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","তাতে ফরৌণ তোমাদেরকে ডেকে যখন জিজ্ঞাসা করবেন, “তোমাদের ব্যবসা কি?” ");
INSERT INTO benirv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","তখন তোমরা বলবে, “আপনার এই দাসরা পূর্বপুরুষদের ছেলেবেলা থেকে আজ পর্যন্ত পশুপাল রেখে আসছে;” তাতে তোমরা গোশন প্রদেশে বাস করতে পারবে; কারণ পশুপালক মাত্রেই মিশরীয়দের ঘৃণার জিনিস। ");
INSERT INTO benirv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","পরে যোষেফ গিয়ে ফরৌণকে সংবাদ দিলেন, বললেন, আমার বাবা ও ভাইয়েরা নিজের নিজের গরু ও ভেড়ার পাল এবং সব কিছু কনান দেশ থেকে নিয়ে এসেছেন; আর দেখুন, তাঁরা গোশন প্রদেশে আছেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","আর তিনি নিজের ভাইদের মধ্যে পাঁচ জনকে নিয়ে ফরৌণের সামনে উপস্থিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","তাতে ফরৌণ যোষেফের ভাইদেরকে জিজ্ঞাসা করলেন, “তোমাদের ব্যবসায় কি?” তাঁরা ফরৌণকে বললেন, “আপনার এই দাসরা পূর্বপুরুষদের দিন থেকেই পশুপালক।” ");
INSERT INTO benirv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","তাঁরা ফরৌণকে আরো বললেন, “আমরা এই দেশে বাস করতে এসেছি, কারণ আপনার এই দাসদের পশুপালের চরাণী হয় না, কারণ কনান দেশে অতি ভারী দূর্ভিক্ষ হয়েছে;” অতএব অনুরোধ করি, “আপনার এই দাসদেরকে গোশন প্রদেশে বাস করতে দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ফরৌণ যোষেফকে বললেন, “তোমার বাবা ও ভাইরা তোমার কাছে এসেছে; ");
INSERT INTO benirv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","মিশর দেশ তোমার সামনে আছে; দেশের ভালো জায়গায় নিজের বাবা ও ভাইদেরকে বাস করাও; তারা গোশন প্রদেশে বাস করুক; আর যদি তাদের মধ্যে কাউকে কাউকেও কাজে দক্ষ লোক বলে জান, তবে তাদেরকে আমার পশুপালের পরিচারক পদে নিযুক্ত কর।” ");
INSERT INTO benirv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","পরে যোষেফ নিজের বাবা যাকোবকে এনে ফরৌণের সামনে উপস্থিত করলেন, আর যাকোব ফরৌণকে আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","তখন ফরৌণ যাকোবকে জিজ্ঞাসা করলেন, “আপনার কত বছর বয়স হয়েছে?” ");
INSERT INTO benirv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","যাকোব ফরৌণকে বললেন, “আমার প্রবাসকালের একশো ত্রিশ বছর হয়েছে; আমার জীবনের দিন অল্প ও কষ্টকর হয়েছে এবং আমার পূর্বপুরুষদের প্রবাসকালের আয়ুর সমান হয়নি।” ");
INSERT INTO benirv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","পরে যাকোব ফরৌণকে আশীর্বাদ করে তাঁর সামনে থেকে বিদায় নিয়ে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","তখন যোষেফ ফরৌণের আদেশ অনুযায়ী মিশর দেশের উত্তম অঞ্চলে, রামিষেষ প্রদেশে, অধিকার দিয়ে নিজের বাবা, ও ভাইদেরকে বসিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","আর যোষেফ নিজের বাবা ও ভাইদেরকে এবং বাবার সমস্ত আত্মীয়দেরকে তাদের পরিবার অনুসারে খাবার দিয়ে প্রতিপালন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","সেই দিনের সমস্ত দেশে খাবার ছিল না, কারণ অতি ভারী দূর্ভিক্ষ হয়েছিল, তাতে মিশর দেশ ও কনান দেশ দূর্ভিক্ষের জন্য অবসন্ন হয়ে পড়ল। ");
INSERT INTO benirv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","আর মিশর দেশে ও কনান দেশে যত রূপা ছিল, লোকে তা দিয়ে শস্য কেনাতে যোষেফ সেই সমস্ত রূপা সংগ্রহ করে ফরৌণের ভান্ডারে আনলেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","মিশর দেশে ও কনান দেশে রূপা ব্যয় হয়ে গেলে মিশরীয়েরা সবাই যোষেফের কাছে এসে বলল, “আমাদেরকে খাবার দিন, আমাদের রূপা শেষ হয়ে গিয়েছে বলে আমরা কি আপনার সামনে মারা যাব?” ");
INSERT INTO benirv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","যোষেফ বললেন, “তোমাদের পশু দাও; যদি রূপা শেষ হয়ে থাকে, তবে তোমাদের পশুর পরিবর্তে তোমাদেরকে খাবার দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","তখন তারা যোষেফের কাছে নিজের নিজের পশু আনলে যোষেফ অশ্ব, মেষপাল, গরুর পাল ও গাধাদের পরিবর্তে তাদেরকে খাবার দিতে লাগলেন; এই ভাবে যোষেফ তাদের সমস্ত পশু নিয়ে সেই বছর খাবার দিয়ে তাদের চালিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","আর সেই বছর চলে গেলে দ্বিতীয় বছরে তারা তাঁর কাছে এসে বলল, “আমরা প্রভু থেকে কিছু গোপন করব না; আমাদের সমস্ত রূপা শেষ হয়ে গিয়েছে এবং পশুধনও প্রভুরই হয়েছে; এখন প্রভুর সামনে আর কিছুই বাকি নেই, শুধু আমাদের শরীর ও জমি আছে। ");
INSERT INTO benirv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","আমরা নিজের নিজের ভূমির সঙ্গে নিজেদের চোখের সামনে কেন মারা যাব? আপনি খাবার দিয়ে আমাদেরকে ও আমাদের ভূমি কিনে নিন; আমরা নিজের নিজের ভূমির সঙ্গে ফরৌণের দাস হব; আর আমাদেরকে বীজ দিন, তা হলে আমরা বাঁচব, মারা যাব না, ভূমিও নষ্ট হবে না।” ");
INSERT INTO benirv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","তখন যোষেফ মিশরের সমস্ত ভূমি ফরৌণের জন্যে কিনলেন, কারণ দূর্ভিক্ষ তাদের অসহ্য হওয়াতে মিস্রীয়েরা প্রত্যেকে নিজের নিজের ক্ষেত্র বিক্রয় করল। ");
INSERT INTO benirv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","অতএব মাটি ফরৌণের হল। আর তিনি মিশরের এক সীমা থেকে অন্য সীমা পর্যন্ত প্রজাদেরকে নগরে নগরে প্রবাস করালেন। ");
INSERT INTO benirv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","তিনি কেবল যাজকদের ভূমি কিনলেন না, কারণ ফরৌণ যাজকদের বৃত্তি দিতেন এবং তারা ফরৌণের দেওয়া বৃত্তি ভোগ করত; এই জন্য নিজের নিজের ভূমি বিক্রয় করল না। ");
INSERT INTO benirv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","পরে যোষেফ প্রজাদেরকে বললেন, “দেখ, আমি আজ তোমাদেরকে ও তোমাদের ভূমি ফরৌণের জন্যে কিনলাম। দেখ, এই বীজ নিয়ে মাটিতে বপন কর; ");
INSERT INTO benirv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","তাতে যা যা উৎপন্ন হবে, তাঁর পঞ্চমাংশ ফরৌণকে দাও, অন্য চার অংশ ক্ষেত্রের বীজের জন্যে এবং নিজেদের ও আত্মীয়দের ও শিশুদের খাদ্যের জন্যে তোমাদেরই থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","তাতে তারা বলল, “আপনি আমাদের প্রাণ রক্ষা করলেন; আমাদের প্রতি আপনার অনুগ্রহ দৃষ্টি হোক, আমরা ফরৌণের দাস হব।” ");
INSERT INTO benirv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","মিশরের ভূমির সম্বন্ধে যোষেফ এই ব্যবস্থা তৈরী করেন, আর এটা আজও পর্যন্ত চলছে যে, পঞ্চমাংশ ফরৌণ পাবেন; কেবল যাজকদের ভূমি ফরৌণের হয়নি। ");
INSERT INTO benirv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","আর ইস্রায়েল মিশর দেশে, গোশন অঞ্চলে বাস করল, তারা সেখানে অধিকার পেয়ে ফলবন্ত ও অতি বহুবংশ হয়ে উঠল। ");
INSERT INTO benirv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","মিশর দেশে যাকোব সতেরো বছর জীবিত থাকলেন; যাকোবের আয়ুর পরিমাণ একশো সাতচল্লিশ বছর হল। ");
INSERT INTO benirv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","পরে ইস্রায়েলের মরণ দিন সন্নিকট হল। তখন তিনি নিজের ছেলে যোষেফকে ডেকে বললেন, “আমি যদি তোমার দৃষ্টিতে অনুগ্রহ পেয়ে থাকি, তবে অনুরোধ করি, তুমি আমার উরুর নীচে হাত দাও এবং আমার প্রতি সদয় ও সত্য ব্যবহার কর; মিশরে আমাকে কবর দিও না। ");
INSERT INTO benirv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","আমি যখন নিজের পূর্বপুরুষদের কাছে শয়ন করব, তখন তুমি আমাকে মিশর থেকে নিয়ে গিয়ে তাঁদের কবরস্থানে কবর দিয়ো।” যোষেফ বললেন, “আপনি যা বললেন, তাই করব।” ");
INSERT INTO benirv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","আর যাকোব তাঁকে শপথ করতে বললে তিনি তাঁর কাছে শপথ করলেন। তখন ইস্রায়েল তাঁর বিছানার দিকে প্রণাম করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","এ সব ঘটনা হলে পর কেউ যোষেফকে বলল, “দেখুন, আপনার বাবা অসুস্থ;” তাতে তিনি নিজের দুই ছেলে মনঃশি ও ইফ্রয়িমকে সঙ্গে নিয়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","তখন কেউ যাকোবকে সংবাদ দিয়ে বলল, “দেখুন, আপনার ছেলে যোষেফ এসেছেন; তাতে ইস্রায়েল নিজেকে সবল করে শয্যায় উঠে বসলেন।” ");
INSERT INTO benirv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","আর যাকোব যোষেফকে বললেন, “কনান দেশে, লুস নামক জায়গায়, সর্বশক্তিমান ঈশ্বর আমাকে দর্শন দিয়ে আশীর্বাদ করেছিলেন” ");
INSERT INTO benirv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ও বলেছিলেন, “দেখ, আমি তোমাকে ফলবান ও বহুবংশ করব, আর তোমার থেকে জাতিসমাজ সৃষ্টি করব এবং তোমার ভাবী বংশকে চিরস্থায়ী অধিকারের জন্য এই দেশ দেব।” ");
INSERT INTO benirv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","আর মিশরে তোমার কাছে আমার আসবার আগে তোমার যে দুই ছেলে মিশর দেশে জন্মেছে, তারা আমারই; রুবেন ও শিমিয়োনের মতো ইফ্রয়িম ও মনঃশিও আমারই হবে। ");
INSERT INTO benirv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","কিন্তু তুমি এদের পরে যাদের জন্ম দিয়েছ, তোমার সেই বংশধরেরা তোমারই হবে এবং এই দুই ভাইয়ের নামে এদেরই অধিকারে আখ্যাত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","আর পদ্দন থেকে আমার আসবার দিনের কনান দেশে রাহেল ইফ্রাথে পৌঁছাবার অল্প পথ থাকতে পথের মধ্যে আমার কাছে মারা গেলেন; তাতে আমি সেখানে, ইফ্রাথের, অর্থাৎ বৈৎলেহমের, পথের পাশে তাঁর কবর দিলাম। ");
INSERT INTO benirv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","পরে ইস্রায়েল যোষেফের দুই ছেলেকে দেখে জিজ্ঞাসা করলেন, “এরা কে?” ");
INSERT INTO benirv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","যোষেফ বাবাকে বললেন, “এরা আমার ছেলে, যাদেরকে ঈশ্বর এই দেশে আমাকে দিয়েছেন।” তখন তিনি বললেন, “অনুরোধ করি, এদেরকে আমার কাছে আন, আমি এদেরকে আশীর্বাদ করব।” ");
INSERT INTO benirv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","তখন ইস্রায়েল বার্ধক্যের জন্য ক্ষীণ দৃষ্টি হওয়াতে দেখতে পেলেন না; আর তারা কাছে আসলে তিনি তাদেরকে চুম্বন ও আলিঙ্গন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","পরে ইস্রায়েল যোষেফকে বললেন, “আমি ভেবেছিলাম, তোমার মুখ আর দেখতে পাব না; কিন্তু দেখ, ঈশ্বর আমাকে তোমার বংশও দেখালেন।” ");
INSERT INTO benirv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","তখন যোষেফ দুই জানুর মধ্য থেকে তাদেরকে বের করলেন ও ভূমিতে মুখ দিয়ে প্রণাম করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","পরে যোষেফ দুই জনকে নিয়ে নিজের ডান হাত দিয়ে ইফ্রয়িমকে ধরে ইস্রায়েলের বামদিকে ও বাম হাত দিয়ে মনঃশিকে ধরে ইস্রায়েলের ডানদিকে তাঁর কাছে উপস্থিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","তখন ইস্রায়েল ডান হাত বাড়িয়ে ছোট ছেলে ইফ্রয়িমের মাথায় দিলেন এবং বাম হাত মনঃশির মাথায় রাখলেন। এ তার বিবেচনা সম্পন্ন বাহুচালন, কারণ মনঃশি প্রথমজাত। ");
INSERT INTO benirv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","পরে তিনি যোষেফকে আশীর্বাদ করে বললেন, “সেই ঈশ্বর, যাঁর সামনে আমার পূর্বপুরুষ অব্রাহাম ও ইসহাক যাতায়াত করতেন সেই ঈশ্বর, যিনি প্রথম থেকে আজ পর্যন্ত আমার পালক হয়ে আসছেন ");
INSERT INTO benirv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","সেই দূত, যিনি আমাকে সমস্ত বিপদ থেকে মুক্ত করেছেন তিনিই এই ছেলে দুটিকে আশীর্বাদ করুন। এদের মাধ্যমে আমার নাম ও আমার পূর্বপুরুষ অব্রাহামের ও ইসহাকের নাম আখ্যাত হোক এবং এরা দেশের মধ্যে বহুগোষ্ঠী হোক।” ");
INSERT INTO benirv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","তখন ইফ্রয়িমের মাথায় বাবা ডান হাত দিয়েছেন দেখে যোষেফ অসন্তষ্ট হলেন, আর তিনি ইফ্রয়িমের মাথা থেকে মনঃশির মাথায় রাখার জন্য বাবার হাত তুলে ধরলেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","যোষেফ বাবাকে বললেন, “বাবা, এমন না, এই প্রথমজাত, এরই মাথায় ডান হাত দিন।” ");
INSERT INTO benirv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","কিন্তু তাঁর বাবা অসম্মত হয়ে বললেন, “বৎস তা আমি জানি, আমি জানি, এও এক জাতি হবে এবং মহানও হবে, তবুও এর ছোট ভাই এর থেকেও মহান হবে ও তার বংশ বহুগোষ্ঠী হবে।” ");
INSERT INTO benirv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","সেই দিন তিনি তাঁদেরকে আশীর্বাদ করে বললেন, “ইস্রায়েল তোমার নাম করে আশীর্বাদ করবে, বলবে, ঈশ্বর তোমাকে ইফ্রয়িমের ও মনঃশির সমান করুন।” এই ভাবে তিনি মনঃশি থেকে ইফ্রয়িমকে অগ্রগন্য করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","পরে ইস্রায়েল যোষেফকে বললেন, “দেখ, আমি মারা যাচ্ছি; কিন্তু ঈশ্বর তোমাদের সঙ্গে থাকবেন ও তোমাদেরকে আবার তোমাদের পূর্বপুরুষদের দেশে নিয়ে যাবেন। ");
INSERT INTO benirv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","আর তোমার ভাইদের থেকে এক অংশ তোমাকে বেশী দিলাম; তা আমি নিজের তরোয়াল ও ধনুকের মাধ্যমে ইমোরীয়দের হাত থেকে নিয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","পরে যাকোব নিজের ছেলেদেরকে ডেকে বললেন, “তোমরা এক জায়গায় জড়ো হও, পরবর্তীকালে তোমাদের প্রতি যা ঘটবে, তা তোমাদেরকে বলছি।” ");
INSERT INTO benirv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","যাকোবের ছেলেরা, সমবেত হও, শোন, তোমাদের বাবা ইস্রায়েলের বাক্য শোন। ");
INSERT INTO benirv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","রুবেন, তুমি আমার প্রথমজাত, আমার বল আমার শক্তির প্রথম ফল মহিমার প্রাধান্য ও পরাক্রমের প্রাধান্য। ");
INSERT INTO benirv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","তুমি তপ্ত জলের মতো চঞ্চল, তোমার প্রাধান্য থাকবে না; কারণ তুমি নিজের বাবার বিছানায় গিয়েছিলে; তখন অপবিত্র কাজ করেছিলে; সে আমার বিছানায় গিয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","শিমিয়োন ও লেবি দুই ভাই; তাদের খড়গ দৌরাত্ম্যের অস্ত্র। ");
INSERT INTO benirv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","হে আমার প্রাণ! তাঁদের সভায় যেও না; হে আমার গৌরব! তাদের সমাজে যোগ দিও না; করণ তারা রাগে নরহত্যা করল, স্বেচ্ছাচারীতায় ষাঁড়ের শিরা ছেদন করল। ");
INSERT INTO benirv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","অভিশপ্ত তাদের রাগ, কারণ তা প্রচণ্ড; তাদের কোপ, কারণ তা নিষ্ঠুর; আমি তাঁদেরকে যাকোবের মধ্যে বিভাগ করব, ইস্রায়েলের মধ্যে ছিন্নভিন্ন করব। ");
INSERT INTO benirv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","যিহূদা, তোমার ভায়েরা তোমারই স্তব করবে; তোমার হাত তোমার শত্রুদের ঘাড় ধরবে; তোমার বাবার ছেলেরা তোমার সামনে নত হবে। ");
INSERT INTO benirv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","যিহূদা সিংহশাবক; বৎস, তুমি শিকার থেকে উঠে আসলে; সে শুয়ে পড়ল, গুঁড়ি মারল, সিংহের মতো ও সিংহীর মতো; কে তাঁকে উঠাবে? ");
INSERT INTO benirv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","যিহূদা থেকে রাজদণ্ড যাবে না, তার পায়ের মধ্যে থেকে বিচারদন্ড যাবে না, যে পর্যন্ত শীলো না আসেন; জাতিরা তাঁরই আজ্ঞাবহতা স্বীকার করবে। ");
INSERT INTO benirv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","সে আঙ্গুর গাছে নিজের গাধী বাঁধবে, ভালো আঙ্গুর গাছে নিজের বাচ্চা ঘোড়া বাঁধবে; সে আঙ্গুর রসে নিজের পরিচ্ছদ কেচেছে, আঙ্গুরের রক্তে নিজের কাপড় কেচেছে। ");
INSERT INTO benirv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","তার চোখ আঙ্গুর রসে রক্তবর্ণ, তার দাঁত দুধে সাদা রঙের। ");
INSERT INTO benirv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","সবূলূন সমুদ্রতীরে বাস করবে, তা জাহাজের জন্য বন্দর হবে, সীদোন পর্যন্ত তার সীমা হবে। ");
INSERT INTO benirv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ইষাখর বলবান গাধা, সে দুটি ভেড়ার খোঁয়াড়ের মধ্যে শয়ন করে। ");
INSERT INTO benirv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","সে দেখল, বিশ্রামের জায়গা ভালো, দেখল, এই দেশ আনন্দময়, তাই ভার বহন করতে কাঁধ পেতে দিল, আর করাধীন দাস হল। ");
INSERT INTO benirv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","দান নিজের প্রজাদের বিচার করবে, ইস্রায়েলের এক বংশের মতো। ");
INSERT INTO benirv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","দান পথে অবস্থিত সাপ, সে মার্গে অবস্থিত বিষাক্ত সাপ, যে ঘোড়ার পায়ে দংশন করে, আর আরোহী পিছনে পড়ে যায়। ");
INSERT INTO benirv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","সদাপ্রভু আমি তোমার পরিত্রানের অপেক্ষায় আছি। ");
INSERT INTO benirv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","গাদকে সৈন্যদল আঘাত করবে; কিন্তু সে তাদের পিছন দিকে আঘাত করবে। ");
INSERT INTO benirv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","আশের থেকে অতি ভালো খাবার জন্মাবে; সে রাজার সুস্বাদু খাদ্য জুগিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","নপ্তালি মুক্ত হরিণী, সে মনোহর বাক্য বলে। ");
INSERT INTO benirv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","যোষেফ ফলবান গাছের শাখা, জলপ্রবাহের পাশে অবস্থিত ফলবান গাছের শাখা; তার শাখা সকল পাঁচিল অতিক্রম করে। ");
INSERT INTO benirv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ধনুকধারীরা তাকে কঠিন কষ্ট দিয়েছিল, বাণের আঘাতে তাকে উৎপীড়ন করেছিল; ");
INSERT INTO benirv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","কিন্তু তার ধনুক দৃঢ় থাকল, তার হাতের বাহুযুগল বলবান থাকল, যাকোবের একবীরের হাতের মাধ্যমে, যিনি ইস্রায়েলের পালক ও শৈল, তাঁর মাধ্যমে, ");
INSERT INTO benirv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","তোমার পিতার সেই ঈশ্বরের মাধ্যমে, যিনি তোমাকে সাহায্য করবেন, সেই সর্বশক্তিমানের মাধ্যমে, যিনি তোমাকে আশীর্বাদ করবেন, উপরে অবস্থিত আকাশ থেকে নিঃসৃত আশীর্বাদে, অধোবিস্তীর্ণ জলধি থেকে নিঃসৃত আশীর্বাদে, স্তন ও গর্ভ থেকে নিঃসৃত আশীর্বাদে। ");
INSERT INTO benirv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","আমার পূর্বপুরুষদের আশীর্বাদ অপেক্ষা তোমার পিতামহর আশীর্বাদের থেকে উৎকৃষ্ট। তা চিরন্তন গিরিমালার সীমা পর্যন্ত ব্যাপ্ত; তা আসবে যোষেফের মাথায়, ভাইদের থেকে পৃথককৃতের মাথার তালুতে। ");
INSERT INTO benirv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","বিন্যামীন ক্ষুধার্ত নেকড়ের সমান; সকালে সে শিকার খাবে, সন্ধ্যাকালে সে লুটের জিনিস ভাগ করবে। ");
INSERT INTO benirv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","এরা সবাই ইস্রায়েলের বারো বংশ; এদের বাবা আশীর্বাদ করবার দিনের এই কথা বললেন; এদের প্রত্যেক জনকে বিশেষ বিশেষ আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","পরে যাকোব তাঁদেরকে আদেশ দিয়ে বললেন, আমি নিজের লোকদের কাছে সংগৃহীত হতে প্রস্তুত। হেতীয় ইফ্রোণের ক্ষেতে অবস্থিত গুহাতে আমার পূর্বপুরুষদের কাছে আমার কবর দিও; ");
INSERT INTO benirv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","সেই গুহা কনান দেশে মম্রির কাছে মকপেলা ক্ষেত্রে অবস্থিত; আব্রাহাম হেতীয় ইফ্রোণের কাছে তা কবরস্থানের অধিকারের জন্য কিনেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","সেই জায়গায় অব্রাহামের ও তাঁর স্ত্রী সারার কবর হয়েছে, সেই জায়গায় ইসহাকের ও তাঁর স্ত্রী রিবিকার কবর হয়েছে এবং সেই স্থানে আমিও লেয়ার কবর দিয়েছি; ");
INSERT INTO benirv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","সেই ক্ষেত্রে ও তাঁর মধ্যবর্ত্তী গুহা হেতের লোকদের কাছে কেনা হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","যাকোব নিজের ছেলেদের প্রতি আদেশ শেষ করলে পর শয্যাতে দুই পা জড়ো করলেন ও প্রাণত্যাগ করে নিজের লোকদের কাছে ফিরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","তখন যোষেফ নিজের বাবার মুখে মুখ দিয়ে কাঁদলেন ও তাকে চুম্বন করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","আর যোষেফ নিজের বাবার দেহে ক্ষয়-নিবারক দ্রব্য দিতে নিজের দাস চিকিৎসকদেরকে আদেশ করলেন, তাতে চিকিৎসকেরা ইস্রায়েলের দেহে ক্ষয়-নিবারক দ্রব্য দিল। ");
INSERT INTO benirv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","তারা সেই কাজে চল্লিশ দিন কাটাল, কারণ সেই ক্ষয়-নিবারক দ্রব্য দিতে চল্লিশ দিন লাগে; আর মিশরীয়েরা তাঁর জন্যে সত্তর দিন ধরে কাঁদল। ");
INSERT INTO benirv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","সেই শোকের দিন চলে গেলে যোষেফ ফরৌণের আত্মীয়দেরকে বললেন, “যদি আমি আপনাদের দৃষ্টিতে অনুগ্রহ পেয়ে থাকি, তবে ফরৌণের কানে এই কথা বলুন, ");
INSERT INTO benirv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","আমার বাবা আমাকে শপথ করিয়ে বলেছেন, দেখ, আমি যাচ্ছি, কনান দেশে আমার জন্য যে কবর খনন করেছি, তুমি আমাকে সেই কবরে রেখো। অতএব অনুরোধ করি, আমাকে যেতে দিন; আমি পিতাকে কবর দিয়ে আবার আসব।” ");
INSERT INTO benirv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ফরৌণ বললেন, “যাও, তোমার বাবা তোমাকে যে শপথ করিয়েছেন, তুমি সেই অনুসারে তাঁর কবর দাও।” ");
INSERT INTO benirv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","পরে যোষেফ নিজের বাবার কবর দিতে যাত্রা করলেন; আর ফরৌণের দাসরা সবাই তাঁর বাড়ির প্রাচীনরা ও মিশর দেশের প্রাচীনেরা সবাই এবং যোষেফের সব পরিবার, ");
INSERT INTO benirv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","যোষেফের ভাইরা ও তাঁর বাবার বংশধর তাঁর সঙ্গে গেলেন; তারা গোশন প্রদেশে শুধু তাঁদের ছেলে মেয়েরা, ভেড়ার পাল ও গরুর পাল রেখে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","তাঁর সঙ্গে রথ ও অশ্বারোহীরা গেল; অতি ভারী সমারোহ হল। ");
INSERT INTO benirv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","পরে তাঁরা যর্দ্দনের পারে অবস্থিত আটদের খামারে উপস্থিত হয়ে সেখানে ভীষণ শোক করে কাঁদলেন; যোষেফ সেই জায়গায় বাবার উদ্দেশ্যে সাত দিন শোক করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","আটদের খামারে তাঁদের সেরকম শোক দেখে সেই দেশনিবাসী কনানীয়েরা বলল, “মিশরীয়দের এ অতি দারুন শোক;” এই জন্যে যর্দনপারে অবস্থিত সেই জায়গা আবেল-মিস্রয়ীম মিশরীয়দের শোক নামে আখ্যাত হল। ");
INSERT INTO benirv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","যাকোব নিজের ছেলেদেরকে যেমন আদেশ দিয়েছিলেন, তাঁরা সেই অনুসারে তাঁর সৎকার করলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ফলে তাঁর ছেলেরা তাকে কনান দেশে নিয়ে গেলেন এবং মম্রির সামনে অবস্থিত মকপেলা ক্ষেতের মাঝখানের গুহাতে তাঁর কবর দিলেন, যা অব্রাহাম ক্ষেতসহ কবরস্থানের অধিকারের জন্য হেতীয় ইফ্রোণের কাছ থেকে কিনেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","বাবার কবর হলে পর যোষেফ, তাঁর ভাইরা এবং যত লোক তাঁর বাবার কবর দিতে তাঁর সঙ্গে গিয়েছিলেন, সবাই মিশরে ফিরে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","আর বাবার মৃত্যু হল দেখে যোষেফের ভাইয়েরা বললেন, “হয় তো যোষেফ আমাদেরকে ঘৃণা করবে, আর আমরা তাঁর যে সব অপকার করেছি, তাঁর সম্পূর্ণ প্রতিফল আমাদেরকে দেবে।” ");
INSERT INTO benirv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","আর তারা যোষেফের কাছে এই কথা বলে পাঠালেন, “তোমার বাবা মৃত্যুর আগে এই আদেশ দিয়েছিলেন,” ");
INSERT INTO benirv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","তোমরা যোষেফকে এই কথা বল, “তোমার ভাইরা তোমার অপকার করেছে, কিন্তু অনুরোধ করি, তুমি তাদের সেই অধর্ম্ম ও পাপ ক্ষমা কর। অতএব এখন আমরা অনুরোধ করি, তোমার বাবার ঈশ্বরের এই দাসদের অধর্ম্ম ক্ষমা কর।” তাদের এই কথায় যোষেফ কাঁদতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","পরে তার ভায়েরা নিজেরা গিয়ে তাঁর সামনে নত হয়ে বললেন, “দেখ, আমরা তোমার দাস।” ");
INSERT INTO benirv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","তখন যোষেফ তাঁদেরকে বললেন, “ভয় কর না, আমি কি ঈশ্বরের প্রতিনিধি? ");
INSERT INTO benirv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","তোমরা আমার বিরুদ্ধে অনিষ্ট কল্পনা করেছিলে বটে, কিন্তু ঈশ্বর তা মঙ্গলের কল্পনা করলেন; আজ যেমন দেখছ, এই ভাবে অনেক লোকের প্রাণ রক্ষা করাই তাঁর উদ্দেশ্য ছিল। ");
INSERT INTO benirv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","তোমরা এখন ভীত হয়ো না, আমিই তোমাদেরকে ও তোমাদের ছেলে মেয়েদেরকে প্রতিপালন করব।” এই ভাবে তিনি তাঁদেরকে সান্ত্বনা করলেন ও ভালো কথা বললেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","পরে যোষেফ ও তাঁর বাবার বংশ মিশরে বাস করতে থাকলেন এবং যোষেফ একশ দশ বছর জীবিত থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","যোষেফ ইফ্রয়িমের নাতি পর্যন্ত দেখলেন; মনঃশির মাখীর নামক ছেলের ছেলেমেয়েরাও যোষেফের কোলে জন্ম নিল। ");
INSERT INTO benirv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","পরে যোষেফ নিজের ভাইদেরকে বললেন, “আমি মরছি কিন্তু ঈশ্বর অবশ্য তোমাদের পরিচালনা করবেন এবং অব্রাহামের, ইসহাকের ও যাকোবের কাছে যে দেশ দিতে শপথ করেছেন তোমাদেরকে এ দেশ থেকে ঐ দেশে নিয়ে যাবেন।” ");
INSERT INTO benirv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","আর যোষেফ ইস্রায়েলীয়দেরকে এই শপথ করালেন, বললেন, “ঈশ্বর অবশ্য তোমাদের পরিচালনা করবেন, আর তোমরা এ জায়গা থেকে আমার অস্থি নিয়ে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","যোষেফ একশো দশ বছর বয়সে মারা গেলেন; আর লোকেরা তাঁর দেহে ক্ষয়-নিবারক দ্রব্য দিয়ে তা মিশর দেশে এক মৃতদেহ রাখার বাক্সর মধ্যে রাখল।");
INSERT INTO benirv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ইস্রায়েলের ছেলেরা, যাঁরা মিশর দেশে গিয়েছিলেন, পরিবারের সবাই যাকোবের সঙ্গে গিয়েছিলেন, তাঁদের নাম হল; ");
INSERT INTO benirv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","রূবেন, শিমিয়োন, লেবি ও যিহূদা, ");
INSERT INTO benirv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ইষাখর, সবূলূন ও বিন্যামীন, ");
INSERT INTO benirv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","দান, নপ্তালি, গাদ ও আশের। ");
INSERT INTO benirv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","যাকোবের বংশ থেকে মোট সত্তর জন মানুষ ছিল; আর যোষেফ মিশরেই ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","পরে যোষেফ, তাঁর ভায়েরা ও সেই দিনের র সমস্ত লোক মারা গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","আর ইস্রায়েলের সন্তানেরা ফলবান হল, সংখ্যায় অনেক বৃদ্ধি পেল, খুব শক্তিশালী হয়ে উঠল এবং তাদের মাধ্যমে দেশ ভরে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","পরে মিশরে এক নতুন রাজা উঠলেন, যিনি যোষেফকে চিনতেন না। ");
INSERT INTO benirv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","তিনি তাঁর প্রজাদেরকে বললেন, “দেখ, আমাদের থেকে ইস্রায়েলের সন্তানরা সংখ্যায় বেশি ও শক্তিশালী; ");
INSERT INTO benirv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","এস, আমরা তাদের সঙ্গে বুদ্ধির সঙ্গে ব্যবহার করি, নাহলে তারা বৃদ্ধি পাবে এবং যুদ্ধের দিন তারাও শত্রুদের দলে যোগ দিয়ে আমাদের সঙ্গে যুদ্ধ করে এবং এই দেশ থেকে চলে যায়।” ");
INSERT INTO benirv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","অতএব তারা কঠিন পরিশ্রম করিয়ে তাদের কষ্ট দেবার জন্য তাদের উপরে শাসকদেরকে নিযুক্ত করল। আর তারা ফরৌণের জন্য ভান্ডারের নগর, পিথোম ও রামিষেষ তৈরী করল। ");
INSERT INTO benirv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","কিন্তু তারা তাদের মাধ্যমে যত দুঃখ পেল, ততই বৃদ্ধি পেতে ও ছড়িয়ে পড়তে লাগল; তাই ইস্রায়েল সন্তানদের জন্য তারা খুব চিন্তিত হয়ে পড়ল। ");
INSERT INTO benirv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","আর মিশরীয়েরা নিষ্ঠুর ভাবে ইস্রায়েল সন্তানদের দাসের মত কাজ করালো; ");
INSERT INTO benirv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","তারা কাদা তৈরির কাজে, ইট ও ক্ষেতের সমস্ত কাজে দাসের মত খাটিয়ে তাদের জীবন কষ্টকর করে তুলল। তারা তাদের দিয়ে যে সব দাসের কাজ করাতো, সে সমস্ত নিষ্ঠুর ভাবে করাতো। ");
INSERT INTO benirv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","পরে মিশরের রাজা শিফ্রা ও পূয়া নামে দুই ইব্রীয় ধাত্রীকে এই কথা বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“যে দিনের তোমরা ইব্রীয় স্ত্রীদের ধাত্রীর কাজ করবে ও তাদেরকে প্রসবের দিন দেখবে, যদি ছেলে হয়, তাকে হত্যা করবে; আর যদি মেয়ে হয়, তাকে জীবিত রাখবে।” ");
INSERT INTO benirv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","কিন্তু ঐ ধাত্রীরা ঈশ্বরকে ভয় করত, সুতরাং মিশরের রাজার আদেশ না মেনে ছেলে সন্তানদের জীবিত রাখত। ");
INSERT INTO benirv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","তাই মিশরের রাজা সেই ধাত্রীদের ডেকে বললেন, “এ রকম কাজ কেন করেছ? ছেলে সন্তানদের কেন জীবিত রেখেছ?” ");
INSERT INTO benirv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ধাত্রীরা ফরৌণকে উত্তরে বলল, “ইব্রীয় স্ত্রীলোকেরা মিশরীয় স্ত্রীলোকদের মত নয়; তারা বলবতী, তাদের কাছে ধাত্রী যাবার আগেই তাদের প্রসব হয়।” ");
INSERT INTO benirv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","তাই ঈশ্বর ঐ ধাত্রীদের মঙ্গল করলেন এবং লোকেরা বৃদ্ধি পেয়ে খুব শক্তিশালী হল। ");
INSERT INTO benirv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","সেই ধাত্রীরা ঈশ্বরকে ভয় করত বলে তিনি তাদের বংশের বৃদ্ধি করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","পরে ফরৌণ তাঁর সব প্রজাকে এই আদেশ দিলেন, “তোমরা ইব্রীয়দের জন্ম নেওয়া প্রত্যেক ছেলেকে নীল নদীতে ফেলে দেবে, কিন্তু প্রত্যেক মেয়েকে জীবিত রাখবে।” ");
INSERT INTO benirv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","আর লেবির বংশের এক পুরুষ গিয়ে এক লেবীয় মেয়েকে বিয়ে করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","আর সেই স্ত্রী গর্ভবতী হয়ে একটি ছেলের জন্ম দিলেন ও শিশুটিকে সুন্দর দেখে তিন মাস লুকিয়ে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","পরে আর লুকাতে না পেরে তিনি এক নলের ঝুড়ি নিয়ে পিচ তেল ও আলকাতরা মাখিয়ে তার মধ্যে ছেলেটিকে রাখলেন ও নদীর তীরে নলবনে সেটি রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","আর তার কি দশা হয়, তা দেখবার জন্য তার দিদি দূরে দাঁড়িয়ে থাকলো। ");
INSERT INTO benirv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","পরে ফরৌণের মেয়ে স্নানের জন্য নদীতে আসলেন এবং তাঁর সঙ্গীরা নদীর তীরে বেড়াচ্ছিল; আর তিনি নল বনের মধ্যে ঐ ঝুড়ি দেখে তাঁর দাসীকে সেটা আনতে পাঠালেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","তারপর ঝুড়ি খুলে শিশুটিকে দেখলেন যে, ছেলেটি কাঁদছে; তার প্রতি তিনি দয়া দেখিয়ে বললেন, “এটা ইব্রীয়দের ছেলে।” ");
INSERT INTO benirv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","তখন তার দিদি ফরৌণের মেয়েকে বলল, “আমি গিয়ে কি আপনার জন্য এই ছেলেকে দুধ দেবার জন্য একটি ইব্রীয় স্ত্রীলোককে আপনার কাছে ডেকে আনব?” ");
INSERT INTO benirv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ফরৌণের মেয়ে বললেন, “যাও।” তখন সেই মেয়েটি গিয়ে ছেলেটির মাকে ডেকে আনল। ");
INSERT INTO benirv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ফরৌণের মেয়ে তাঁকে বললেন, “তুমি এই ছেলেটিকে নিয়ে আমার হয়ে দুধ পান করাও; আমি তোমাকে বেতন দেব।” তাতে সেই স্ত্রী ছেলেটিকে নিয়ে দুধ পান করাতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","পরে ছেলেটি বড় হলে তিনি তাকে নিয়ে ফরৌণের মেয়েকে দিলেন; তাতে সে তাঁরই ছেলে হল; আর তিনি তার নাম মোশি টানিয়া তোলা রাখলেন, কারণ তিনি বললেন, “আমি তাকে জল থেকে টেনে তুলেছি।” ");
INSERT INTO benirv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","যখন মোশি বড় হলেন, তিনি এক দিন তাঁর ভাইদের কাছে গিয়ে তাদের কঠিন পরিশ্রম দেখতে লাগলেন; আর তিনি দেখলেন, একজন মিশরীয় একজন ইব্রীয়কে, তাঁর ভাইদের মধ্যে এক জনকে মারছে। ");
INSERT INTO benirv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","তখন তিনি এদিক ওদিক চেয়ে কাউকে দেখতে না পেয়ে ঐ মিশরীয়কে হত্যা করে বালির মধ্যে পুঁতে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","পরের দিন তিনি বাইরে গিয়ে দেখলেন, দুইজন ইব্রীয় একে অপরের সঙ্গে মারপিট করছে; তিনি দোষী ব্যক্তিকে বললেন, “তোমার ভাইকে কেন মারছ?” ");
INSERT INTO benirv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","সে বলল, “তোমাকে শাসনকর্ত্তা ও বিচারকর্ত্তা করে আমাদের উপরে কে নিযুক্ত করেছে? তুমি যেমন সেই মিশরীয়কে হত্যা করেছে, সেইভাবে কি আমাকেও হত্যা করতে চাও?” তখন মোশি ভয় পেয়ে বললেন, “কথাটা তাহলে জানাজানি হয়ে গেছে?” ");
INSERT INTO benirv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","তারপর ফরৌণ এই কথা শুনে মোশিকে হত্যা করতে চেষ্টা করলেন। কিন্তু মোশি ফরৌণের সামনে থেকে পালিয়ে গেলেন এবং মিদিয়ন দেশে বাস করতে গেলেন, সেখানে একটি কুয়োর কাছে এসে বসলেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","মিদিয়নীয় যাজকের সাতটি মেয়ে ছিল; তারা সেখানে এসে বাবার ভেড়ার পাল কে জল পান করাবার জন্য জল তুলে পাত্রগুলি ভর্তি করল। ");
INSERT INTO benirv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","তখন ভেড়ার পালকেরা এসে তাদেরকে তাড়িয়ে দিল, কিন্তু মোশি উঠে তাদের সাহায্য করলেন ও তাদের ভেড়ার পাল কে জল পান করালেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","পরে তারা তাদের বাবা রূয়েলের কাছে গেলে তিনি তাদেরকে জিজ্ঞাসা করলেন, “আজ তোমরা কি করে এত তাড়াতাড়ি আসলে?” ");
INSERT INTO benirv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","তারা বলল, “একজন মিশরীয় আমাদেরকে ভেড়ার পালকদের হাত থেকে উদ্ধার করলেন, আর তিনি আমাদের জন্য যথেষ্ট জল তুলে ভেড়ার পাল কে জল পান করালেন।” ");
INSERT INTO benirv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","তখন তিনি তাঁর মেয়েদেরকে বললেন, “সে লোকটি কোথায়? তোমরা তাঁকে ছেড়ে কেন আসলে? তাঁকে ডাক; তিনি আহার করুন।” ");
INSERT INTO benirv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","পরে মোশি ঐ ব্যক্তির সঙ্গে থাকতে রাজি হলেন, আর তিনি মোশির সঙ্গে নিজের মেয়ে সিপ্পোরার বিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","পরে ঐ স্ত্রী ছেলের জন্ম দিলেন, আর মোশি তার নাম গের্শোম তত্রপ্রবাসী রাখলেন, কারণ তিনি বললেন, “আমি বিদেশে প্রবাসী হয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","অনেক কাল পরে মিশরের রাজার মৃত্যু হল। ইস্রায়েলীয়রা তাদের দাসত্বের যন্ত্রণায় আর্তনাদ করে উঠলো, বন্দীদশায় তারা সাহায্যের জন্য কাঁদলো, আর তাদের প্রার্থনা ঈশ্বরের কাছে পৌঁছালো। ");
INSERT INTO benirv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","আর ঈশ্বর তাদের আর্তনাদ শুনলেন এবং অব্রাহাম, ইস্‌হাক ও যাকোবের সঙ্গে করা তাঁর নিয়ম স্মরণ করলেন; ");
INSERT INTO benirv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","তার ফলে ঈশ্বর ইস্রায়েলীয়দের দিকে তাকালেন; আর তিনি তাদের অবস্থা বুঝলেন। ");
INSERT INTO benirv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","মোশি তাঁর শ্বশুর যিথ্রোর ভেড়ার পাল চরাতেন যিনি মিদিয়নীয় যাজক ছিলেন। এক দিন তিনি মরুপ্রান্তের পিছনের দিকে ভেড়ার পাল নিয়ে গিয়ে হোরেবে, ঈশ্বরের পর্বতে উপস্থিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","আর ঝোপের মধ্যে থেকে আগুনের শিখাতে সদাপ্রভুর দূত তাঁকে দেখা দিলেন; তখন তিনি তাকালেন, আর দেখো, ঝোপ আগুনে জ্বলছে, তবুও ঝোপ পুড়ে যাচ্ছে না। ");
INSERT INTO benirv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","তাই মোশি বললেন, “আমি এক পাশে গিয়ে এই মহা আশ্চর্য্য দৃশ্য দেখি, ঝোপ পুড়ছে না, এর কারণ কি?” ");
INSERT INTO benirv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","কিন্তু সদাপ্রভু যখন দেখলেন যে, তিনি দেখবার জন্য এক পাশে যাচ্ছেন, তখন ঝোপের মধ্য থেকে ঈশ্বর তাঁকে ডেকে বললেন, “মোশি, মোশি।” তিনি বললেন, “দেখুন, এই আমি।” ");
INSERT INTO benirv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","তখন তিনি বললেন, “এই জায়গার কাছে এস না, তোমার পা থেকে জুতো খুলে ফেলো; কারণ যেখানে তুমি দাঁড়িয়ে আছ, ওটা পবিত্র জায়গা।” ");
INSERT INTO benirv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","তিনি আরও বললেন, “আমি তোমার বাবার ঈশ্বর, অব্রাহামের ঈশ্বর, ইস্‌হাকের ঈশ্বর ও যাকোবের ঈশ্বর।” তখন মোশি তাঁর মুখ ঢেকে দিলেন, কারণ তিনি ঈশ্বরের দিকে চেয়ে থাকতে ভয় পাচ্ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","পরে সদাপ্রভু বললেন, “সত্যিই আমি মিশরের আমার প্রজাদের কষ্ট দেখেছি এবং শাসকদের জন্য তাদের কান্না শুনেছি; তার ফলে আমি তাদের দুঃখ জানি।” ");
INSERT INTO benirv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","আর মিশরীয়দের হাত থেকে তাদেরকে উদ্ধার করবার জন্য এবং সেই দেশ থেকে উঠিয়ে নিয়ে ভালো ও বড় এক দেশে, অর্থাৎ কনানীয়, হিত্তীয়, ইমোরীয়, পরিষীয়, হিব্বীয় ও যিবূষীয় লোকেরা যেখানে থাকে, সেই দুধ ও মধু প্রবাহিত দেশে তাদেরকে আনবার জন্য নেমে এসেছি। ");
INSERT INTO benirv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","এখন দেখ, ইস্রায়েলের লোকদের কান্না আমার কাছে উপস্থিত হয়েছে এবং মিশরীয়েরা তাদের ওপর যে নির্যাতন করে, তা আমি দেখেছি। ");
INSERT INTO benirv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","অতএব এখন এস, আমি তোমাকে ফরৌণের কাছে পাঠাব, তুমি মিশর থেকে আমার লোক ইস্রায়েলীয়দেরকে বের কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","কিন্তু মোশি ঈশ্বরকে বললেন, “আমি কে, যে ফরৌণের কাছে যাই ও মিশর থেকে ইস্রায়েলীয়দেরকে বের করি?” ");
INSERT INTO benirv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","তিনি বললেন, “নিশ্চয় আমি তোমার সঙ্গে সঙ্গে থাকব এবং আমি যে তোমাকে পাঠালাম, তোমার জন্য তার এই চিহ্ন হবে; তুমি মিশর থেকে লোকেদেরকে বের করে এনে তোমরা এই পর্বতে ঈশ্বরের সেবা করবে।” ");
INSERT INTO benirv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","পরে মোশি ঈশ্বরকে বললেন, “দেখ, আমি যখন ইস্রায়েলীয়দের কাছে গিয়ে বলব, ‘তোমাদের পূর্বপুরুষদের ঈশ্বর তোমাদের কাছে আমাকে পাঠিয়েছেন’, তখন যদি তারা জিজ্ঞাসা করে, ‘তাঁর নাম কি’? তবে তাদেরকে কি বলব?” ");
INSERT INTO benirv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ঈশ্বর মোশিকে বললেন, “আমি যা আছি তাই আছি,” আরও বললেন, “ইস্রায়েল সন্তানদের এই ভাবে বোলো, ‘আমি সেই যিনি তোমাদের কাছে আমাকে পাঠিয়েছেন’।” ");
INSERT INTO benirv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ঈশ্বর মোশিকে আরও বললেন, “তুমি ইস্রায়েল সন্তানদের এই কথা বোলো, ‘যিহোবাঃ সদাপ্রভু, তোমাদের পূর্বপুরুষদের ঈশ্বর, অব্রাহামের ঈশ্বর, ইস্‌হাকের ঈশ্বর ও যাকোবের ঈশ্বর তোমাদের কাছে আমাকে পাঠিয়েছেন; আমার নাম এই অনন্তকালস্থায়ী এবং এর দ্বারা আমি সমস্ত বংশে স্মরণীয়’।” ");
INSERT INTO benirv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","তুমি যাও, ইস্রায়েলের প্রাচীনদেরকে জড়ো কর, তাদেরকে এই কথা বল, সদাপ্রভু, তোমাদের পূর্বপুরুষদের ঈশ্বর, অব্রাহামের, ইস্‌হাকের ও যাকোবের ঈশ্বর আমাকে দেখা দিয়ে বললেন, সত্যিই আমি তোমাদের পর্যবেক্ষণ করেছি, মিশরে তোমাদের প্রতি যা হয়েছে, তা দেখেছি। ");
INSERT INTO benirv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","আর আমি বলেছি, আমি মিশরের কষ্ট থেকে তোমাদেরকে উদ্ধার করে কনানীয়দের, হিত্তীয়দের, ইমোরীয়দের, পরিষীয়দের, হিব্বীয়দের ও যিবূষীয়দের দেশে, দুধ ও মধু প্রবাহিত দেশে, নিয়ে যাব। ");
INSERT INTO benirv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","তারা তোমার কথা মনোযোগ দিয়ে শুনবে; তখন তুমি ও ইস্রায়েলের প্রাচীনেরা মিশরের রাজার কাছে যাবে, তাকে বলবে, সদাপ্রভু, ইব্রীয়দের ঈশ্বর আমাদেরকে দেখা দিয়েছেন; অতএব অনুরোধ করি, আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশ্যে বলিদান করার জন্য আমাদেরকে তিন দিনের পথ মরুপ্রান্তে যাবার অনুমতি দিন। ");
INSERT INTO benirv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","কিন্তু আমি জানি, মিশরের রাজা তোমাদেরকে যেতে দেবে না, এমনকি শক্তিশালী হাত দিয়েও নয় (যতক্ষণ না তাকে বাধ্য করা হচ্ছে)। ");
INSERT INTO benirv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","আমি হাত তুলব এবং দেশের মধ্যে যে সব আশ্চর্য্য কাজ করে, তা দিয়ে মিশরকে আঘাত করব, তারপরে সে তোমাদেরকে যেতে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","পরে আমি মিশরীয়দের চোখে এই লোকদেরকে দয়ার পাত্র করব; তাতে তোমরা যাবার দিন খালি হাতে যাবে না; ");
INSERT INTO benirv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","কিন্তু প্রত্যেক স্ত্রী নিজেদের প্রতিবেশীনী কিংবা প্রতিবেশীর বাড়িতে বসবাসকারী স্ত্রীর কাছে রূপা ও সোনার গয়না এবং পোশাক চাইবে। তোমরা তা তোমাদের ছেলে মেয়েদের গায়ে পরাবে; এই ভাবে তোমরা মিশরীয়দের জিনিসপত্র লুট করবে। ");
INSERT INTO benirv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","মোশি উত্তরে বললেন, “কিন্তু দেখুন, তারা আমাকে বিশ্বাস করবে না ও আমার কথা মনোযোগ দিয়ে শুনবে না, কারণ তারা বলবে, ‘সদাপ্রভু তোমাকে দেখা দেন নি’।” ");
INSERT INTO benirv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","তখন সদাপ্রভু তাঁকে বললেন, “তোমার হাতে ওটা কি?” তিনি বললেন, “লাঠি।” তখন তিনি বললেন, “ওটা মাটিতে ফেল।” ");
INSERT INTO benirv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","পরে তিনি মাটিতে ফেললে সেটা সাপ হয়ে গেল; আর মোশি তার সামনে থেকে পালিয়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","তখন সদাপ্রভু মোশিকে বললেন, “হাত বাড়িয়ে ওটার লেজ ধর, তাতে তিনি হাত বাড়ালেন এবং সেই সাপটি ধরলেন।” তখন এটি তাঁর হাতে লাঠি হয়ে গেল, ");
INSERT INTO benirv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“যেন তারা বিশ্বাস করে যে, সদাপ্রভু, তাদের পূর্বপুরুষদের ঈশ্বর, অব্রাহামের ঈশ্বর, ইস্‌হাকের ঈশ্বর যাকোবের ঈশ্বর তোমাকে দেখা দিয়েছেন।” ");
INSERT INTO benirv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","পরে সদাপ্রভু তাঁকে আরও বললেন, “তুমি তোমার হাত বুকে দাও,” তাতে তিনি বুকে হাত দিলেন; পরে তা বের করে দেখলেন, তাঁর হাতে তুষারের মত সাদা কুষ্ঠ হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","পরে সদাপ্রভু বললেন, “তোমার হাত আবার বুকে দাও।” তিনি আবার বুকে হাত দিলেন, পরে বুক থেকে হাত বের করে দেখলেন, তা পুনরায় তাঁর মাংসের মত হয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“যদি তারা তোমাকে বিশ্বাস না করে এবং যদি আমার শক্তির প্রথম চিহ্নেও মনোযোগ না করে অথবা বিশ্বাস না করে, তবে তারা দ্বিতীয় চিহ্নে বিশ্বাস করিবে। ");
INSERT INTO benirv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","এবং তারা যদি আমার বিশ্বাসের এই দুই চিহ্নেও বিশ্বাস না করে অথবা তোমার কথায় যদি মনোযোগ না করে, তবে তুমি নদী থেকে কিছু জল নিয়ে শুকনো মাটিতে ঢেলে দিও; তাতে তুমি নদী থেকে যে জল তুলবে, তা শুকনো মাটিতে রক্ত হয়ে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","পরে মোশি সদাপ্রভুকে বললেন, হায় প্রভু! আমি ভালো করে কথা বলতে পারি না, এর আগেও বলতে পারতাম না, বা তোমার সঙ্গে এই দাসের আলাপ করার পরেও নই; কারণ আমি আসতে আসতে কথা বলি ও তোতলা। ");
INSERT INTO benirv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","সদাপ্রভু তাঁকে বললেন, “মানুষের মুখ কে তৈরী করেছে? আর বোবা, কালা, চোখে দেখতে পায় বা অন্ধকে কে তৈরী করে? ");
INSERT INTO benirv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","আমি সদাপ্রভুই কি করি নি? এখন তুমি যাও; আমি তোমার মুখের সহায় হব ও কি বলতে হবে, তোমাকে শেখাব।” ");
INSERT INTO benirv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","তিনি বললেন, “হে আমার প্রভু, অনুরোধ করি, অন্য কারো হাতে এই বার্তা পাঠাও, যাকে তুমি পাঠাতে চাও।” ");
INSERT INTO benirv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","তখন মোশির উপর সদাপ্রভু রেগে গেলেন; তিনি বললেন, “তোমার ভাই লেবীয় হারোণ কি নেই? আমি জানি সে ভালো কথা বলে; আরও দেখ, সে তোমার সঙ্গে দেখা করতে আসছে; তোমাকে দেখে খুব আনন্দিত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","তুমি তাকে বলবে ও তাঁর মুখে বাক্য দেবে এবং আমি তোমার মুখের ও তার মুখের সহায় হব ও কি করতে হবে, তোমাদেরকে জানাব। ");
INSERT INTO benirv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","তোমার পরিবর্তে সে লোকদের কাছে বক্তা হবে; তার ফলে সে তোমার মুখের মত হবে এবং তুমি তার ঈশ্বরের মত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","আর তুমি এই লাঠি হাতে ধরবে, এর মাধ্যমেই তোমাকে সে সমস্ত চিহ্ন কাজ করতে হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","পরে মোশি তাঁর শ্বশুর যিথ্রোর কাছে ফিরে এসে বললেন, “অনুরোধ করি, আমাকে যেতে দিন যেন আমি মিশরে থাকা আমার ভাইদের কাছে ফিরে যেতে পারি এবং তারা এখনও জীবিত আছে কি না, তা দেখতে পাই।” যিথ্রো মোশিকে বললেন, “শান্তিতে যাও।” ");
INSERT INTO benirv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","আর সদাপ্রভু মিদিয়নে মোশিকে বললেন, “তুমি মিশরে ফিরে যাও; কারণ যে লোকেরা তোমাকে হত্যা করার চেষ্টা করছিল, তারা সবাই মারা গেছে।” ");
INSERT INTO benirv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","তখন মোশি তাঁর স্ত্রী ও ছেলেদেরকে গাধায় চাপিয়ে মিশর দেশে ফিরে গেলেন এবং মোশি তাঁর হাতে ঈশ্বরের সেই লাঠি নিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","আর সদাপ্রভু মোশিকে বললেন, “তুমি যখন মিশরে ফিরে যাবে, দেখো, আমি তোমার হাতে যে সব অদ্ভুত কাজের ভার দিয়েছি, ফরৌণের সামনে সে সব কোরো; কিন্তু আমি তার হৃদয় কঠিন করব, সে লোকদেরকে ছাড়বে না। ");
INSERT INTO benirv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","আর তুমি ফরৌণকে বলবে, ‘সদাপ্রভু এই কথা বলেন, ইস্রায়েল আমার ছেলে, আমার প্রথমজাত।’ ");
INSERT INTO benirv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","আর আমি তোমাকে বলেছি, আমার সেবা করার জন্য আমার ছেলেকে ছেড়ে দাও; কিন্তু তুমি তাঁকে ছেড়ে দিতে রাজি না হলে; দেখ, আমি তোমার সন্তানকে, তোমার প্রথমজাতকে, হত্যা করব।” ");
INSERT INTO benirv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","পরে পথে সরাইখানায় সদাপ্রভু তাঁর কাছে গিয়ে তাঁকে হত্যা করতে চেষ্টা করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","তখন সিপ্পোরা একটি পাথরের ছুরি নিয়ে তাঁর ছেলের ত্বক্‌ ছেদ করলেন ও তা মোশির পায়ে স্পর্শ করে বললেন, “তুমি আমার রক্তের বর।” ");
INSERT INTO benirv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","আর ঈশ্বর তাঁকে ছেড়ে দিলেন; তখন সিপ্পোরা বললেন, “ত্বক্‌ছেদের কারণে তুমি রক্তের বর।” ");
INSERT INTO benirv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","আর সদাপ্রভু হারোণকে বললেন, “তুমি মোশির সঙ্গে দেখা করতে মরুপ্রান্তে যাও।” তাতে তিনি গিয়ে ঈশ্বরের পর্বতে তাঁর দেখা পেলেন ও তাঁকে চুম্বন করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","তখন মোশি তাঁকে যিনি পাঠিয়েছেন সদাপ্রভুর সমস্ত বাক্য ও তাঁর আদেশ মত সমস্ত চিহ্নের বিষয় হারোণকে জানালেন। ");
INSERT INTO benirv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","পরে মোশি ও হারোণ গিয়ে ইস্রায়েল সন্তানদের সমস্ত প্রাচীনকে জড়ো করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","আর হারোণ মোশির প্রতি সদাপ্রভুর বলা সমস্ত বাক্য তাদেরকে জানালেন এবং তিনি লোকদের চোখের সামনে সেই সব চিহ্ন কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","তাতে লোকেরা বিশ্বাস করল এবং ঈশ্বর সদাপ্রভু ইস্রায়েলীয়দের যত্ন নিয়েছেন ও তাদের দুঃখ দেখেছেন শুনে তারা মাথা নিচু করলেন এবং তাঁর আরাধনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","পরে মোশি ও হারোণ গিয়ে ফরৌণকে বললেন, “সদাপ্রভু, ইস্রায়েলের ঈশ্বর এই কথা বলেন, ‘মরুপ্রান্তে আমার উদ্দেশ্যে উৎসব করার জন্য আমার প্রজাদেরকে ছেড়ে দাও’।” ");
INSERT INTO benirv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ফরৌণ বললেন, “সদাপ্রভু কে, যে আমি তার কথা শুনে ইস্রায়েলকে ছেড়ে দেব? আমি সদাপ্রভু কে জানি না, ইস্রায়েলকেও ছাড়বো না।” ");
INSERT INTO benirv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","তাঁরা বললেন, “ইব্রীয়দের ঈশ্বর আমাদেরকে দেখা দিয়েছেন; আমরা অনুরোধ করি, আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশ্যে বলিদান করার জন্য আমাদেরকে তিন দিনের র পথ মরুপ্রান্তে যেতে দিন, যেন তিনি মহামারী কি তরোয়াল দিয়ে আমাদেরকে আক্রমণ না করেন।” ");
INSERT INTO benirv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","মিশরের রাজা তাঁদেরকে বললেন, “ওহে মোশি ও হারোণ, তোমরা কেন লোকদের কাজ থেকে নিস্তার দাও? তোমাদের কাজে ফিরে যাও।” ");
INSERT INTO benirv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ফরৌণ আরও বললেন, “দেখ, দেশে লোক এখন অনেক, আর তোমরা তাদের কাজ থামিয়ে দিয়েছ।” ");
INSERT INTO benirv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","আর ফরৌণ সেই দিন লোকদের শাসক ও শাসনকর্তাকে এই আদেশ দিলেন, ");
INSERT INTO benirv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“তোমরা ইট তৈরী করার জন্য আগের মত এই লোকদেরকে আর খড় দিয়ো না; তাঁরা গিয়ে নিজেরাই নিজেদের খড় সংগ্রহ করুক। ");
INSERT INTO benirv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","কিন্তু আগে তাদের যত ইট তৈরীর ভার ছিল, এখনও সেই ভার দাও; তার কিছুই কম কর না; কারণ তারা কুঁড়ে, তাই কেঁদে বলছে, আমরা আমাদের ঈশ্বরের উদ্দেশ্যে বলিদান করতে যাই। ");
INSERT INTO benirv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","সেই লোকদের উপরে আরও কঠিন কাজ চাপান হোক, তারা তাতেই ব্যস্ত থাকুক এবং মিথ্যা কথায় মনোযোগ না দিক।” ");
INSERT INTO benirv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","আর লোকদের শাসকেরা ও শাসনকর্তারা বাইরে গিয়ে তাদেরকে বলল, “ফরৌণ এই কথা বলেন, আমি তোমাদেরকে খড় দেব না। ");
INSERT INTO benirv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","নিজেরা যেখানে পাও, সেখানে গিয়ে খড় সংগ্রহ কর; কিন্তু তোমাদের কাজ কিছুই কম হবে না।” ");
INSERT INTO benirv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","তাতে লোকেরা খড়ের চেষ্টায় নাড়া জড়ো করতে সমস্ত মিশর দেশে ছড়িয়ে পড়ল। ");
INSERT INTO benirv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","আর শাসকেরা তাড়া দিয়ে বলল, “খড় পেলে যেমন করতে, সেই রকম এখনও তোমাদের প্রতিদিনের র নির্ধারিত কাজ শেষ কর।” ");
INSERT INTO benirv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","আর ফরৌণের শাসকেরা ইস্রায়েল সন্তানদের যে শাসনকর্তাদেরকে তাদের উপরে রেখেছিল, তারাও অত্যাচারিত হল, আর বলে দেওয়া হল, “তোমরা আগের মত ইট তৈরীর বিষয়ে নির্ধারিত কাজ আজকাল শেষ কর না কেন?” ");
INSERT INTO benirv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","তাতে ইস্রায়েলীয়দের শাসনকর্তারা এসে ফরৌণের কাছে কেঁদে বলল, “আপনার দাসদের সঙ্গে আপনি এমন ব্যবহার কেন করছেন? ");
INSERT INTO benirv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","লোকেরা আপনার দাসদেরকে খড় দেয় না, তবুও আমাদেরকে বলে ইট তৈরী কর; আর দেখুন আপনার এই দাসেরা অত্যাচারিত হয়, কিন্তু আপনারই লোকদেরই দোষ।” ");
INSERT INTO benirv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ফরৌণ বললেন, “তোমরা অলস, তাই বলছ, ‘আমরা সদাপ্রভুর উদ্দেশ্যে যজ্ঞ করতে যাই।’ ");
INSERT INTO benirv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","এখন যাও, কাজ কর, তোমাদেরকে খড় দেওয়া যাবে না, তবুও সমস্ত ইট তৈরী করে দিতে হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","তখন ইস্রায়েল সন্তানদের শাসনকর্তারা দেখল, তারা বিপদে পড়েছে, কারণ বলা হয়েছিল, “তোমরা প্রত্যেক দিনের র কাজের, নির্ধারিত ইটের, কিছু কম করতে পাবে না।” ");
INSERT INTO benirv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","পরে ফরৌণের কাছ থেকে বের হয়ে আসার দিনের তারা মোশির ও হারোণের দেখা পেল, তাঁরা পথে দাঁড়িয়ে ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","তারা তাঁদেরকে বলল, “সদাপ্রভু তোমাদের প্রতি দৃষ্টিপাত করুন এবং তোমাদের বিচার করুন, কারণ তোমরা ফরৌণের চোখে ও তাঁর দাসেদের চোখে আমাদেরকে জঘন্য খারাপ করে তুলে আমাদের হত্যা করার জন্য তাদের হাতে তরোয়াল দিয়েছ।” ");
INSERT INTO benirv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","পরে মোশি সদাপ্রভুর কাছে ফিরে গিয়ে তাঁকে বললেন, “হে প্রভু, তুমি এই লোকদের অমঙ্গল কেন করলে? আমাকে কেন পাঠালে? ");
INSERT INTO benirv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","যখন তোমার নামে কথা বলতে ফরৌণের কাছে গিয়েছি, তখন থেকে তিনি এই লোকেদের অমঙ্গল করছেন, আর তুমি তোমার প্রজাদের কিছুই উদ্ধার করনি।” ");
INSERT INTO benirv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","তখন সদাপ্রভু মোশিকে বললেন, “আমি ফরৌণের ওপর যা করব, তা তুমি এখন দেখবে; কারণ শক্তিশালী হাত দেখলে, সে লোকদেরকে ছেড়ে দেবে এবং শক্তিশালী হাত দেখান হলে তার দেশ থেকে তাদেরকে দূর করে দেবে।” ");
INSERT INTO benirv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ঈশ্বর মোশিকে আরও বললেন, “আমি যিহোবা সদাপ্রভু; ");
INSERT INTO benirv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","আমি অব্রাহামকে, ইস্‌হাককে ও যাকোবকে ‘সর্বশক্তিমান ঈশ্বর’ বলে দেখা দিতাম, কিন্তু আমার যিহোবা সদাপ্রভু নাম নিয়ে তাদেরকে আমার পরিচয় দিতাম না। ");
INSERT INTO benirv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","আর আমি তাদের সঙ্গে এই নিয়ম স্থির করেছি, আমি তাদেরকে কনান দেশ দেব, যে দেশে তারা অনাগরিক হিসাবে বাস করত, তাদের সেই বসবাসকারী দেশ দেব। ");
INSERT INTO benirv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","এমনকি মিশরীয়দের দিয়ে দাসত্বে নিযুক্ত ইস্রায়েলীয়দের আর্তনাদ শুনে আমার সেই নিয়ম স্মরণ করলাম। ");
INSERT INTO benirv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","অতএব ইস্রায়েল সন্তানদের বল, ‘আমি যিহোবা, আমি তোমাদেরকে মিশরের দাসত্ব থেকে মুক্ত করব এবং তাদের শক্তি থেকে স্বাধীন করব। আমি তোমাদের আমার শক্তি দিয়ে উদ্ধার করব। ");
INSERT INTO benirv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","আর আমি তোমাদেরকে আমার প্রজা হিসাবে স্বীকার করব ও তোমাদের ঈশ্বর হব; তাতে তোমরা জানতে পারবে যে, আমি যিহোবা, তোমাদের ঈশ্বর, যিনি তোমাদেরকে মিশরীয়দের দাসত্ব থেকে বের করে এনেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","আর আমি অব্রাহামকে, ইস্‌হাককে ও যাকোবকে দেবার জন্যে প্রতিজ্ঞা করেছি, সেই দেশে তোমাদেরকে নিয়ে যাব ও তোমাদের অধিকারে তা দেব; আমিই সদাপ্রভু’।” ");
INSERT INTO benirv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","পরে মোশি ইস্রায়েলীয়দেরকে সেই অনুসারে বললেন, কিন্তু তারা মনের অধৈর্য্য ও কঠিন দাসত্ব কাজের জন্য মোশির কথায় মনোযোগ করল না। ");
INSERT INTO benirv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“তুমি যাও, মিশরের রাজা ফরৌণকে বল, যেন সে তার দেশ থেকে ইস্রায়েলীয়দের ছেড়ে দেয়।” ");
INSERT INTO benirv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","তখন মোশি সদাপ্রভুর সামনে বললেন, “দেখ, ইস্রায়েল সন্তানেরা আমার কথায় মনোযোগ করল না; তবে ফরৌণ কি ভাবে শুনবে? আমি তো ভালো করে কথা বলতে পারি না।” ");
INSERT INTO benirv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","আর সদাপ্রভু মোশির ও হারোণের সঙ্গে আলাপ করলেন এবং ইস্রায়েলীয়দেরকে মিশর দেশ থেকে বের করে আনার জন্য ইস্রায়েল সন্তানদের কাছে এবং মিশরের রাজা ফরৌণের কাছে যা বক্তব্য, তাঁদেরকে আদেশ দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","এই সব লোক নিজের পূর্বপুরুষদের প্রধান ছিলেন। ইস্রায়েলের বড় ছেলে রূবেণের ছেলে হনোক, পল্লু, হিষ্রোণ ও কর্ম্মি; এরা রূবেণের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","শিমিয়োনের ছেলে যিমূয়েল, যামীন, ওহদ, যাখীন, সোহর ও কনানীয় স্ত্রীর ছেলে শৌল; এরা শিমিয়োনের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","বংশ তালিকা অনুসারে লেবির ছেলেদের নাম গের্শোন, কহাৎ ও মরারি; লেবির বয়স একশো সাঁইত্রিশ বছর হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","আর তার গোষ্ঠী অনুসারে গের্শোনের ছেলে লিবনি ও শিমিয়ি। ");
INSERT INTO benirv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","কহাতের সন্তান অম্রম, যিষহর, হিব্রোণ ও উষীয়েল; কহাতের বয়স একশো তেত্রিশ বছর হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","মরারির সন্তান মহলি ও মুশি; এরা বংশ তালিকা অনুসারে লেবির গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","আর অম্রম তার পিসী যোকেবদকে বিয়ে করলেন, আর ইনি তাঁর জন্য হারোণকে ও মোশিকে জন্ম দিলেন। অম্রমের বয়স একশো সাঁইত্রিশ বছর হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","যিষ্হরের সন্তান কোরহ, নেফগ ও সিখ্রি। ");
INSERT INTO benirv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","আর উষীয়েলের সন্তান মীশায়েল, ইলীষাফণ ও সিখ্রি। ");
INSERT INTO benirv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","আর হারোণ অম্মীনাদবের মেয়ে নহোশনের বোন ইলীশেবাকে বিয়ে করলেন, আর ইনি তাঁর জন্য নাদব, অবীহূ, ইলীয়াসর ও ঈথামরের জন্ম দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","আর কোরহের সন্তান অসীর, ইলকানা ও অবীয়াসফ; এরা কোরহীয়দের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","আর হারোণের ছেলে ইলীয়াসর পূটীয়েলের এক মেয়েকে বিয়ে করলে তিনি তাঁর জন্য পীনহসের জন্ম দিলেন; এরা লেবীয়দের গোষ্ঠী অনুসারে তাদের পূর্বপুরুষদের প্রধান ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","এই যে হারোণ ও মোশি, এদেরকেই সদাপ্রভু বললেন, “তোমরা ইস্রায়েল সন্তানদের সৈন্যদের সারি অনুসারে মিশর দেশ থেকে বের কর।” ");
INSERT INTO benirv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","এরাই ইস্রায়েল সন্তানদের মিশর থেকে বের করে আনার জন্য মিশরের রাজা ফরৌণের সঙ্গে কথা বললেন। এরা সেই মোশি ও হারোণ। ");
INSERT INTO benirv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","আর মিশর দেশে যে দিন সদাপ্রভু মোশির সঙ্গে কথা বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","সেই দিন সদাপ্রভু মোশিকে বললেন, “আমিই সদাপ্রভু, আমি তোমাকে যা যা বলি, সে সবই তুমি মিশরের রাজা ফরৌণকে বোলো।” ");
INSERT INTO benirv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","আর মোশি সদাপ্রভুর সামনে বললেন, “দেখ, আমি তো কথা বলতে পারি না, ফরৌণ কি করে আমার কথা শুনবেন?” ");
INSERT INTO benirv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","তখন সদাপ্রভু মোশিকে বললেন, “দেখ, আমি ফরৌণের কাছে তোমাকে ঈশ্বরের মত করে নিযুক্ত করলাম, আর তোমার ভাই হারোণ তোমার ভাববাদী হবে। ");
INSERT INTO benirv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","আমি তোমাকে যা যা আদেশ করি, সে সবই তুমি বলবে এবং তোমার ভাই হারোণ ফরৌণকে তা বলবে, যেন সে ইস্রায়েল সন্তানদের তার দেশ থেকে ছেড়ে দেয়। ");
INSERT INTO benirv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","কিন্তু আমি ফরৌণের হৃদয় কঠিন করব এবং মিশর দেশে আমি অসংখ্য চিহ্ন ও অদ্ভুত লক্ষণ দেখাব। ");
INSERT INTO benirv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","তবুও ফরৌণ তোমাদের কথায় মনোযোগ করবে না; আর আমি মিশরের উপর হাত তুলে ভয়ঙ্কর শাস্তির মধ্যে দিয়ে মিশর দেশ থেকে আমার সৈন্যসামন্তকে, আমার প্রজা ইস্রায়েল সন্তানদের, বের করব। ");
INSERT INTO benirv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","আমি মিশরের উপরে আমার হাত তুলে মিশরীয়দের মধ্যে থেকে ইস্রায়েল সন্তানদের বের করে আনলে, তারা জানবে, আমিই সদাপ্রভু।” ");
INSERT INTO benirv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","পরে মোশি ও হারোণ সেই রকম করলেন; সদাপ্রভুর আদেশ অনুসারে কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ফরৌণের সঙ্গে আলাপ করবার দিনের মোশির আশী ও হারোণের তিরাশী বছর বয়স হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","পরে সদাপ্রভু মোশি ও হারোণকে বললেন, “ফরৌণ যখন তোমাদেরকে বলে, ");
INSERT INTO benirv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","‘তোমরা তোমাদের পক্ষে কোনো অদ্ভুত লক্ষণ দেখাও’, তখন তুমি হারোণকে বোলো, ‘তোমার লাঠি নিয়ে ফরৌণের সামনে ছুঁড়ে ফেল; তাতে তা সাপ হয়ে যাবে’।” ");
INSERT INTO benirv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","তখন মোশি ও হারোণ ফরৌণের কাছে গিয়ে সদাপ্রভুর আদেশ অনুসারে কাজ করলেন; হারোণ ফরৌণের ও তাঁর দাসেদের সামনে তাঁর লাঠি ছুঁড়ে ফেললেন, তাতে তা সাপ হয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","তখন ফরৌণও জ্ঞানীদের ও জাদুকরদের ডাকলেন; তাতে তারা অর্থাৎ মিশরীয় জাদুকরেরাও তাদের মায়াবলে সেই রকম করল। ");
INSERT INTO benirv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","তার ফলে তারা প্রত্যেকে নিজেদের লাঠি ছুঁড়ে ফেললে সেগুলি সব সাপ হয়ে গেল, কিন্তু হারোণের লাঠি তাদের সকল লাঠিকে গিলে ফেলল। ");
INSERT INTO benirv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","আর ফরৌণের হৃদয় কঠিন হল, তিনি তাঁদের কথায় মনোযোগ করলেন না; যেমন সদাপ্রভু বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","আর সদাপ্রভু মোশিকে বললেন, “ফরৌণের হৃদয় কঠিন হয়েছে; সে লোকদেরকে ছেড়ে দিতে অস্বীকার করেছে। ");
INSERT INTO benirv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","তুমি সকালে ফরৌণের কাছে যাও; দেখ, সে জলের দিকে যাবে; তুমি তার সঙ্গে দেখা করতে নদীর তীরে দাঁড়াবে এবং যে লাঠি সাপ হয়ে গিয়েছিল, সেটিও হাতে নিও। ");
INSERT INTO benirv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","আর তাকে বোলো, ‘সদাপ্রভু, ইব্রীয়দের ঈশ্বর আমাকে দিয়ে, তোমাকে বলে পাঠিয়েছেন, তুমি আমার প্রজাদেরকে মরুপ্রান্তে আমার সেবা করার জন্য ছেড়ে দাও; কিন্তু দেখ, তুমি এ পর্যন্ত শোনোনি। ");
INSERT INTO benirv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","সদাপ্রভু এই কথা বলেন, আমি যে সদাপ্রভু, তা তুমি এর মাধ্যমে জানতে পারবে; দেখ, আমি আমার হাতে থাকা লাঠি দিয়ে নদীর জলে আঘাত করব, তাতে তা রক্ত হয়ে যাবে; ");
INSERT INTO benirv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","আর নদীতে যে সব মাছ আছে, তারা মারা যাবে এবং নদীতে দুর্গন্ধ হবে; আর নদীর জল পান করতে মিশরীয়দের ঘৃণা করবে’।” ");
INSERT INTO benirv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","পরে সদাপ্রভু মোশিকে বললেন, “হারোণকে এই কথা বল, ‘তুমি তোমার লাঠি নিয়ে মিশরের জলের উপরে, দেশের নদী, খাল, বিল ও সমস্ত জলাশয়ের উপরে তোমার হাত তোলো; তাতে সেই সব জল রক্ত হবে এবং মিশর দেশের সব জায়গায় কাঠের ও পাথরের পাত্রেও রক্ত হবে’।” ");
INSERT INTO benirv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","তখন মোশি ও হারোণ সদাপ্রভুর আদেশ অনুসারে সেই রকম করলেন, তিনি লাঠি তুলে ফরৌণের ও তাঁর দাসেদের সামনে নদীর জলে আঘাত করলেন; তাতে নদীর সমস্ত জল রক্ত হয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","আর নদীর সব মাছ মারা গেল ও নদীতে দুর্গন্ধ হল; তাতে মিশরীয়েরা নদীর জল পান করতে পারল না এবং মিশর দেশের সব জায়গায় রক্ত হয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","আর মিশরীয় জাদুকরেরাও তাদের মায়াবলে সেই রকম করল; তাতে ফরৌণের হৃদয় কঠিন হল এবং তিনি তাঁদের কথায় মনোযোগ করলেন না; যেমন সদাপ্রভু বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","পরে ফরৌণ তাঁর বাড়ি ফিরে গেলেন, এতেও মনোযোগ করলেন না। ");
INSERT INTO benirv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","আর মিশরীয়েরা সবাই নদীর জল পান করতে না পারাতে জলের চেষ্টায় নদীর আশে পাশে চারিদিকে খুঁড়ল। ");
INSERT INTO benirv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","সদাপ্রভু নদীটি আঘাত করার পর সাত দিন কেটে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","পরে সদাপ্রভু মোশিকে বললেন, “তুমি ফরৌণের কাছে যাও, তাকে বল, ‘সদাপ্রভু এই কথা বলেন, আমার সেবা করার জন্য আমার প্রজাদেরকে ছেড়ে দাও। ");
INSERT INTO benirv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","যদি ছেড়ে দিতে রাজি না হও, তবে দেখ, আমি ব্যাঙের মাধ্যমে তোমার সমস্ত প্রদেশকে যন্ত্রণা দেব। ");
INSERT INTO benirv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","নদী ব্যাঙে ভর্তি হবে; সেই সব ব্যাঙ উঠে তোমার বাড়িতে, শোবার ঘরে ও বিছানায় এবং তোমার দাসদের বাড়িতে, তোমার প্রজাদের মধ্যে, তোমার উনুনে ও তোমার আটা মাখার পাত্রে ঢুকে পড়বে; ");
INSERT INTO benirv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","আর তোমরা, তোমার প্রজারা ও দাসেরা ব্যাঙের মাধ্যমে আক্রান্ত হবে’।” ");
INSERT INTO benirv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","পরে সদাপ্রভু মোশিকে বললেন, “হারোণকে বলো, ‘তুমি নদী, খাল ও বিল সব কিছুর উপরে লাঠি তুলে ব্যাঙ আনাও’।” ");
INSERT INTO benirv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","তাতে হারোণ মিশরের সব জলের উপরে নিজের হাত তুললে ব্যাঙেরা উঠে সমস্ত মিশর দেশ ব্যাঙে পরিপূর্ণ করল। ");
INSERT INTO benirv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","আর জাদুকরেরাও মায়াবলে সেই রকম করে মিশর দেশের উপরে ব্যাঙ আনল। ");
INSERT INTO benirv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","পরে ফরৌণ মোশি ও হারোণকে ডেকে বললেন, “সদাপ্রভুর কাছে প্রার্থনা কর, যেন তিনি আমার থেকে ও আমার প্রজাদের থেকে এই সব ব্যাঙ দূর করে দেন, তাতে আমি লোকদেরকে ছেড়ে দেব, যেন তারা সদাপ্রভুর উদ্দেশ্যে যজ্ঞ করতে পারে।” ");
INSERT INTO benirv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","তখন মোশি ফরৌণকে বললেন, “আপনি আমাকে বলুন, আপনার ও আপনার দাসদের জন্য এবং লোকদের জন্য কোন দিন আমরা প্রার্থনা করব, যাতে ব্যাঙগুলি যেন আপনার ও আপনার বাড়ি থেকে উচ্ছেদ হয় এবং শুধুমাত্র নদীতে থাকে?” ");
INSERT INTO benirv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","তিনি বললেন, “কালকের জন্য।” তখন মোশি বললেন, “আপনার কথা মতই হোক, যেন আপনি জানতে পারেন যে, আমাদের ঈশ্বর সদাপ্রভুর মত কেউ নেই। ");
INSERT INTO benirv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ব্যাঙেরা আপনার কাছ থেকে ও আপনার বাড়ি, দাস ও প্রজাদের থেকে চলে যাবে এবং শুধুমাত্র নদীতেই থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","পরে মোশি ও হারোণ ফরৌণের কাছ থেকে বেরিয়ে গেলেন এবং মোশি ফরৌণের বিরুদ্ধে যে সব ব্যাঙ এনেছিলেন, সেই সকলের বিষয়ে সদাপ্রভুর কাছে কাঁদলেন। ");
INSERT INTO benirv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","আর সদাপ্রভু মোশির কথা অনুযায়ী করলেন, তাতে বাড়িতে, উঠানে ও ক্ষেতের সব ব্যাঙ মারা গেল। ");
INSERT INTO benirv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","তখন লোকেরা সেই সব জড়ো করে ঢিবি করলে দেশে দুর্গন্ধ হল। ");
INSERT INTO benirv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","কিন্তু ফরৌণ যখন দেখলেন, মুক্ত হওয়া গেল, তখন তাঁর হৃদয় কঠিন করলেন, তাঁদের বাক্যে মনোযোগ দিলেন না; যেমন সদাপ্রভু বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","পরে সদাপ্রভু মোশিকে বললেন, “হারোণকে বল, তুমি তোমার লাঠি তুলে মাটির ধূলোতে আঘাত কর, তাতে সারা মিশর দেশে মশা হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","তখন তাঁরা সেই রকম করলেন; হারোণ তাঁর লাঠি সুদ্ধ হাত তুলে মাটির ধূলোতে আঘাত করলেন, তাতে মানুষে ও পশুতে মশা হল, মিশর দেশের সব জায়গায় ভূমির সকল ধূলো মশা হয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","তখন জাদুকরেরা তাদের মায়াবলে মশা উৎপন্ন করার জন্য সেই রকম করল ঠিকই, কিন্তু পারল না, আর মানুষে ও পশুতে মশা হল। ");
INSERT INTO benirv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","তখন জাদুকরেরা ফরৌণকে বলল, “এ ঈশ্বরের আঙ্গুল।” তবুও ফরৌণের হৃদয় কঠিন হল, তিনি তাঁদের কথায় মনোযোগ দিলেন না; যেমন সদাপ্রভু বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","আর সদাপ্রভু মোশিকে বললেন, “তুমি ভোরবেলায় উঠে গিয়ে ফরৌণের সামনে দাঁড়াও; যেমন সে জলের কাছে যায়; তুমি তাকে এই কথা বল, ‘সদাপ্রভু এই কথা বলেন, আমার সেবা করার জন্য আমার প্রজাদেরকে ছেড়ে দাও’।” ");
INSERT INTO benirv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","যদি আমার প্রজাদেরকে ছেড়ে না দাও, তবে দেখ, আমি তোমার কাছে, তোমার দাসেদের কাছে, প্রজাদের কাছে ও বাড়িতে মৌমাছির ঝাঁক পাঠাব; মিশরীয়দের বাড়িতে, এমন কি, তাঁদের বসবাসের জায়গাও মৌমাছিতে ভর্তি হবে। ");
INSERT INTO benirv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","কিন্তু আমি সেই দিন আমার প্রজাদের বাসস্থান গোশন প্রদেশ আলাদা করব; সেখানে আক্রমণ হবে না; যেন তুমি জানতে পার যে, পৃথিবীর মধ্যে আমিই সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","আমি আমার প্রজাদের আলাদা করব; কাল এই চিহ্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","পরে সদাপ্রভু সেই রকম করলেন, ফরৌণের ও তাঁর দাসেদের বাড়ি মৌমাছির বিশাল ঝাঁক উপস্থিত হল; তাতে সমস্ত মিশর দেশে মৌমাছির ঝাঁকে দেশ ছারখার হল। ");
INSERT INTO benirv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","তখন ফরৌণ মোশি ও হারোণকে ডেকে বললেন, “তোমরা যাও, দেশের মধ্যে তোমাদের ঈশ্বরের উদ্দেশ্যে যজ্ঞ কর।” ");
INSERT INTO benirv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","মোশি বললেন, “তা করা উপযুক্ত নয়, কারণ আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশ্যে মিশরীয়দের ঘৃণাজনক বলিদান করতে হবে; দেখুন, মিশরীয়দের সাক্ষাৎে তাঁদের ঘৃণাজনক বলিদান করলে তারা কি আমাদেরকে পাথর দিয়ে হত্যা করবে না? ");
INSERT INTO benirv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","আমরা তিন দিনের র পথ মরুপ্রান্তে গিয়ে, আমাদের ঈশ্বর সদাপ্রভু যে আদেশ দেবেন, সেই অনুসারে তাঁর উদ্দেশ্যে যজ্ঞ করব।” ");
INSERT INTO benirv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ফরৌণ বললেন, “আমি তোমাদেরকে ছেড়ে দিচ্ছি, তোমরা মরুপ্রান্তে গিয়ে তোমাদের ঈশ্বর সদাপ্রভুর উদ্দেশ্যে যজ্ঞ কর; কিন্তু বহুদূর যেও না; তোমরা আমার জন্য প্রার্থনা কর।” ");
INSERT INTO benirv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","তখন মোশি বললেন, “দেখুন, আমি আপনার কাছ থেকে গিয়ে সদাপ্রভুর কাছে প্রার্থনা করব, তাতে ফরৌণের, তাঁর দাসেদের ও তাঁর প্রজাদের কাছ থেকে কাল মৌমাছির ঝাঁক দূরে যাবে; কিন্তু সদাপ্রভুর উদ্দেশ্যে যজ্ঞ করার জন্য লোকদেরকে ছেড়ে দেবার বিষয়ে ফরৌণ আবার বিশ্বাসঘাতকতা না করুন।” ");
INSERT INTO benirv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","পরে মোশি ফরৌণের কাছ থেকে বেরিয়ে গিয়ে সদাপ্রভুর কাছে প্রার্থনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","আর সদাপ্রভু মোশির বাক্য অনুসারে করলেন; ফরৌণ, তাঁর দাসেদের ও প্রজাদের থেকে মৌমাছির সমস্ত ঝাঁক দূর করলেন; একটিও বাকি রইল না। ");
INSERT INTO benirv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","আর এবারও ফরৌণ তাঁর হৃদয় কঠিন করলেন, লোকদেরকে ছেড়ে দিলেন না। ");
INSERT INTO benirv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","পরে সদাপ্রভু মোশিকে বললেন, “তুমি ফরৌণের কাছে গিয়ে তাকে বল, ‘সদাপ্রভু, ইব্রীয়দের ঈশ্বর, এই কথা বলেন, আমার সেবা করার জন্য আমার প্রজাদেরকে ছেড়ে দাও। ");
INSERT INTO benirv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","যদি তাদেরকে ছেড়ে দিতে রাজি না হও, এখনও বাধা দাও, ");
INSERT INTO benirv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","তবে দেখ, ক্ষেতের তোমার পশু সম্পত্তির উপর, ঘোড়াদের, গাধাদের, উটদের, গরুর পালের ও ভেড়ার পালের উপর সদাপ্রভুর হাত রয়েছে; ভারী মহামারী হবে। ");
INSERT INTO benirv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","কিন্তু সদাপ্রভু ইস্রায়েলের পশুদের থেকে মিশরের পশুদের আলাদা করবেন; তাতে ইস্রায়েল সন্তানদের কোনো পশু মরবে না’।” ");
INSERT INTO benirv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","আর সদাপ্রভু দিন নির্ধারণ করে বললেন, “কাল সদাপ্রভু দেশে এই কাজ করবেন।” ");
INSERT INTO benirv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","পরদিন সদাপ্রভু তাই করলেন, তাতে মিশরের সকল পশু মরল, কিন্তু ইস্রায়েল সন্তানদের পশুদের মধ্যে একটিও মরল না। ");
INSERT INTO benirv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","তখন ফরৌণ লোক পাঠালেন, আর দেখ, ইস্রায়েলের একটি পশুও মরেনি; তবুও ফরৌণের হৃদয় কঠিন হল এবং তিনি লোকদেরকে ছেড়ে দিলেন না। ");
INSERT INTO benirv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","পরে সদাপ্রভু মোশি ও হারোণকে বললেন, “তোমরা হাত ভর্তি করে ভাটীর ছাই নাও, পরে মোশি ফরৌণের সাক্ষাৎে তা আকাশের দিকে ছড়িয়ে দিক। ");
INSERT INTO benirv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","তা সমস্ত মিশর দেশ জুড়ে সূক্ষ্ম ধূলো হয়ে মিশর দেশের সব জায়গায় মানুষ ও পশুদের গায়ে ক্ষতযুক্ত ফোসকা জন্মাবে।” ");
INSERT INTO benirv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","তখন তাঁরা ভাটীর ছাই নিয়ে ফরৌণের সামনে দাঁড়ালেন এবং মোশি আকাশের দিকে তা ছড়িয়ে দিলেন, তাতে বা সমস্ত মানুষ ও পশুর গায়ে ক্ষতযুক্ত ফোসকা হল। ");
INSERT INTO benirv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","সেই ফোসকার জন্য জাদুকরেরা মোশির সামনে দাঁড়াতে পারল না, কারণ জাদুকরদের ও সমস্ত মিশরীয়ের গায়ে ফোসকা জন্মাল। ");
INSERT INTO benirv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","আর সদাপ্রভু ফরৌণের হৃদয় কঠিন করলেন; তিনি তাঁদের কথায় মনোযোগ দিলেন না, যেমন সদাপ্রভু মোশিকে বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","পরে সদাপ্রভু মোশিকে বললেন, “তুমি ভোরে উঠে ফরৌণের সামনে দাঁড়িয়ে তাকে এই কথা বোলো, ‘সদাপ্রভু, ইব্রীয়দের ঈশ্বর, এই কথা বলেন, আমার সেবা করার জন্য আমার প্রজাদেরকে ছেড়ে দাও; ");
INSERT INTO benirv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","নাহলে এবার আমি তোমার হৃদয়ের বিরুদ্ধে এবং তোমার দাসেদের ও প্রজাদের মধ্যে আমার সব রকম মহামারী পাঠাব; যেন তুমি জানতে পার, সমস্ত পৃথিবীতে আমার মত কেউ নেই। ");
INSERT INTO benirv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","কারণ এতদিনের আমি আমার হাত বাড়িয়ে মহামারীর মাধ্যমে তোমাকে ও তোমার প্রজাদেরকে আঘাত করতে পারতাম; তা করলে তুমি পৃথিবী থেকে উচ্ছেদ হতে। ");
INSERT INTO benirv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","কিন্তু প্রকৃত পক্ষে আমি এই জন্যই তোমাকে স্থাপন করেছি, যেন আমার ক্ষমতা তোমাকে দেখাই ও সমস্ত পৃথিবীতে আমার নাম প্রচারিত হয়। ");
INSERT INTO benirv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","এখনও তুমি আমার প্রজাদের বিরুদ্ধে অহঙ্কার করে তাদেরকে ছেড়ে দিতে চাইছ না। ");
INSERT INTO benirv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","দেখ, মিশরের পত্তন হওয়ার দিন থেকে আজ পর্যন্ত যা কখনও দেখা যায় নি, এমন প্রচণ্ড ভারী শিলাবৃষ্টি আমি কাল এই দিনের বর্ষাব। ");
INSERT INTO benirv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","অতএব তুমি এখন ক্ষেতে লোক পাঠিয়ে তোমার পশু ও যা কিছু আছে সে সব নিরাপদ জায়গায় জড়ো কর; যে মানুষ ও পশুদেরকে ক্ষেত থেকে বাড়িতে আনা হবে না, তাঁদের উপরে শিলাবৃষ্টি হবে, আর তারা মারা যাবে’।” ");
INSERT INTO benirv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","তখন ফরৌণের দাসেদের মধ্যে যে কেউ সদাপ্রভুর কথায় ভয় পেল, সে তাড়াতড়ি তার দাস ও পশুকে বাড়ির মধ্যে আনল; ");
INSERT INTO benirv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","আর যে কেউ সদাপ্রভুর কথায় মনোযোগ দিল না, সে তার দাস ও পশুদেরকে ক্ষেতে রেখে দিল। ");
INSERT INTO benirv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","পরে সদাপ্রভু মোশিকে বললেন, “তুমি আকাশের দিকে তোমার হাত তোলো, তাতে মিশর দেশের সব জায়গায় শিলাবৃষ্টি হবে, মিশর দেশের মানুষ, পশু ও ক্ষেতের সমস্ত গাছের উপরে তা হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","পরে মোশি তাঁর লাঠি আকাশের দিকে তুললে সদাপ্রভু মেঘগর্জন করালেন ও শিলাবৃষ্টি বর্ষালেন এবং আগুন মাটির উপরে বেগে এসে পড়ল; এই ভাবে সদাপ্রভু মিশর দেশে শিলাবৃষ্টি বর্ষালেন। ");
INSERT INTO benirv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","তাতে শিলা এবং শিলার সঙ্গে আগুন মেশানো বৃষ্টি হওয়াতে তা খুব শোচনীয় হল; রাজ্য হিসাবে প্রতিষ্টিত হওয়া পর্যন্ত মিশরে এরকম শিলাবৃষ্টি কখনও হয়নি। ");
INSERT INTO benirv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","তাতে সমস্ত মিশর দেশের ক্ষেতের মানুষ ও পশু সবই শিলার মাধ্যমে আহত হল ও ক্ষেতের সমস্ত ঔষধি গাছগুলি শিলাবৃষ্টির মাধ্যমে ধ্বংস হল, আর ক্ষেতের সমস্ত গাছ ভেঙে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","শুধুমাত্র ইস্রায়েল সন্তানদের বাসস্থান গোশন প্রদেশে শিলাবৃষ্টি হল না। ");
INSERT INTO benirv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","পরে ফরৌণ লোক পাঠিয়ে মোশি ও হারোণকে ডেকে বললেন, “এইবার আমি পাপ করেছি; সদাপ্রভু ধার্মিক, কিন্তু আমি ও আমার প্রজারা দোষী। ");
INSERT INTO benirv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","তোমরা সদাপ্রভুর কাছে প্রার্থনা কর; মেঘগর্জন ও শিলাবৃষ্টি যথেষ্ট হয়েছে? আমি তোমাদেরকে ছেড়ে দেব, তোমাদের আর দেরী হবে না।” ");
INSERT INTO benirv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","তখন মোশি তাঁকে বললেন, “আমি নগর থেকে বাইরে গিয়েই সদাপ্রভুর দিকে হাত বাড়িয়ে দেব, তাতে মেঘগর্জন থেমে যাবে ও শিলাবৃষ্টি আর হবে না, যেন আপনি জানতে পারেন যে, পৃথিবী সদাপ্রভুরই। ");
INSERT INTO benirv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","কিন্তু আমি জানি, আপনি ও আপনার দাসেরা, আপনারা এখনও সদাপ্রভু ঈশ্বরকে ভয় পাবেন না।” ");
INSERT INTO benirv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","তখন মসিনা ও যব সবই ক্ষতি হল, কারণ যব শীষযুক্ত ও মসিনা ফুটেছিল। ");
INSERT INTO benirv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","কিন্তু গম ও জনার (শীতের শস্য দানা) বড় না হওয়াতে আহত হল না। ");
INSERT INTO benirv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","পরে মোশি ফরৌণের কাছ থেকে নগরের বাইরে গিয়ে সদাপ্রভুর দিকে হাত বাড়িয়ে দিলেন, তাতে মেঘগর্জন ও শিলা পড়া বন্ধ হল এবং মাটিতে আর বৃষ্টি বর্ষাল না। ");
INSERT INTO benirv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","তখন বৃষ্টি, শিলা বর্ষণ ও মেঘগর্জন থেমে গেছে দেখে ফরৌণ আরও পাপ করলেন, তিনি ও তাঁর দাসেরা তাদের হৃদয় কঠিন করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","আর ফরৌণের হৃদয় কঠিন হওয়াতে তিনি ইস্রায়েলের লোকদেরকে যেতে দিলেন না; যেমন সদাপ্রভু মোশিকে বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","পরে সদাপ্রভু মোশিকে বললেন, “তুমি ফরৌণের কাছে যাও; কারণ আমি তার ও তার দাসেদের হৃদয় কঠিন করলাম, যেন আমি তাদের মধ্যে আমার এই সব চিহ্ন দেখাই ");
INSERT INTO benirv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","এবং আমি মিশরীয়দের প্রতি যা যা করেছি ও তাঁদের মধ্যে আমার যা কিছু চিহ্ন কাজ করেছি, তার বর্ণনা যেন তুমি তোমার ছেলে ও নাতিদেরকে বল এবং আমি সদাপ্রভু, এটা তোমরা জানো।” ");
INSERT INTO benirv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","তখন মোশি ও হারোণ ফরৌণের কাছে গিয়ে বললেন, “সদাপ্রভু, ইব্রীয়দের ঈশ্বর, এই কথা বলেন, ‘তুমি আমার সামনে নম্র হতে কতদিন অসম্মত হবে?’ আমার সেবা করার জন্য আমার প্রজাদেরকে ছেড়ে দাও। ");
INSERT INTO benirv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","কিন্তু যদি আমার প্রজাদেরকে ছেড়ে দিতে রাজি না হও, তবে দেখ, আমি কাল তোমার সীমানাতে পঙ্গপাল আনব। ");
INSERT INTO benirv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","তারা পৃথিবী এমন ভাবে আচ্ছন্ন করবে যে, কেউ ভূমি দেখতে পাবে না এবং শিলাবৃষ্টি থেকে বেঁচে বাকি তোমাদের যা কিছু আছে, তা তারা খেয়ে ফেলবে এবং ক্ষেতে উৎপন্ন তোমাদের গাছগুলিও খাবে। ");
INSERT INTO benirv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","আর তোমার বাড়ি ও তোমার দাসের বাড়ি ও সমস্ত মিশরীয় লোকের বাড়ির সব জায়গা ভরে যাবে; পৃথিবীতে তোমার পূর্বপুরুষদের ও তাঁদের পূর্বপুরুষদের জন্ম থেকে আজ পর্যন্ত সেই রকম দেখা যায়নি।” তখন তিনি মুখ ফিরিয়ে ফরৌণের কাছ থেকে বাইরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","আর ফরৌণের দাসেরা তাঁকে বলল, “এ ব্যক্তি কত দিন আমাদের ফাঁদ হয়ে থাকবে? এই লোকদের ঈশ্বর সেবা করার জন্য এদেরকে ছেড়ে দিন; আপনি কি এখনও বুঝছেন না যে, মিশর দেশ ছারখার হয়ে গেল?” ");
INSERT INTO benirv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","তখন মোশি ও হারোণ ফরৌণের কাছে আবার আনা হল; আর তিনি তাদেরকে বললেন, “যাও গিয়ে তোমাদের ঈশ্বর সদাপ্রভুর সেবা কর; কিন্তু কে কে যাবে?” ");
INSERT INTO benirv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","মোশি বললেন, “আমরা আমাদের শিশু ও বৃদ্ধদেরকে, আমাদের ছেলেমেয়েদেরকে এবং গরু ভেড়ার পালও সঙ্গে নিয়ে যাব, কারণ সদাপ্রভুর উদ্দেশ্যে আমাদের উৎসব করতে হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","তখন ফরৌণ তাদেরকে বললেন, “সদাপ্রভু তোমাদের সঙ্গে সঙ্গে থাকুন, যদি আমি তোমাদেরকে ও তোমাদের শিশুদেরকে ছেড়ে দিই; দেখ, অনিষ্ট তোমাদের সামনে। ");
INSERT INTO benirv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","তা হবে না; তোমাদের পুরুষেরা গিয়ে সদাপ্রভুর সেবা করুক; কারণ তোমরা তো এটাই চাইছ।” পরে তাঁরা ফরৌণের সামনে থেকে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","পরে সদাপ্রভু মোশিকে বললেন, “তুমি মিশর দেশের উপরে পঙ্গপালের জন্য হাত তোলো, তাতে তারা মিশর দেশে এসে ক্ষেতের সমস্ত ঔষধি গাছ খাবে, শিলাবৃষ্টি যা কিছু রেখে গেছে, সবই খাবে।” ");
INSERT INTO benirv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","তখন মোশি মিশর দেশের উপরে তাঁর লাঠি তুললেন, তাতে সদাপ্রভু সমস্ত দিন ও সমস্ত রাত দেশে পূর্ব দিকের বায়ু বহালেন; আর সকাল হলে পূর্ব দিকের বায়ু পঙ্গপাল উঠিয়ে আনল। ");
INSERT INTO benirv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","তাতে সারা মিশর দেশের উপরে পঙ্গপালে ভরে গেল ও মিশরের সমস্ত সীমানাতে পঙ্গপাল পড়ল। তা খুব ভয়ানক হল; সেই রকম পঙ্গপাল আগে কখনও হয়নি এবং পরেও কখনও হবে না। ");
INSERT INTO benirv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","তারা সমস্ত এলাকা ঢেকে ফেলল, তাতে দেশ অন্ধকার হল এবং ভূমির যে ঔষধি গাছ ও বৃক্ষের যে ফল শিলাবৃষ্টি থেকে রক্ষা পেয়েছিল, সে সমস্ত তারা খেয়ে ফেলল; সমস্ত মিশর দেশে বড় গাছ বা ক্ষেতের গাছ, সবুজ গাছ বলে কিছুই রইল না। ");
INSERT INTO benirv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","তখন ফরৌণ তাড়াতাড়ি মোশি ও হারোণকে ডেকে বললেন, “আমি তোমাদের ঈশ্বর সদাপ্রভুর বিরুদ্ধে ও তোমাদের বিরুদ্ধে পাপ করেছি। ");
INSERT INTO benirv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","অনুরোধ করি, শুধুমাত্র এবার আমার পাপ ক্ষমা কর এবং আমাদের থেকে এই মৃত্যুকে দূর করার জন্য তোমাদের ঈশ্বর সদাপ্রভুর কাছে প্রার্থনা কর।” ");
INSERT INTO benirv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","তখন তিনি ফরৌণের কাছ থেকে বাইরে গিয়ে সদাপ্রভুর কাছে প্রার্থনা করলেন; ");
INSERT INTO benirv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","আর সদাপ্রভু বাতাসকে প্রবল পশ্চিম বাতাসে পরিবর্তন করলেন; তা পঙ্গপালদেরকে উঠিয়ে নিয়ে সূফসাগরে তাড়িয়ে দিল, তাতে মিশরের সমস্ত সীমানাতে একটিও পঙ্গপাল থাকল না। ");
INSERT INTO benirv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","কিন্তু সদাপ্রভু ফরৌণের হৃদয় কঠিন করলেন, আর তিনি ইস্রায়েল সন্তানদের ছাড়লেন না। ");
INSERT INTO benirv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","পরে সদাপ্রভু মোশিকে বললেন, “তুমি আকাশের দিকে হাত তোলো; তাতে মিশর দেশে অন্ধকার হবে ও সেই অন্ধকার গাঢ় হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","পরে মোশি আকাশের দিকে হাত তুললে তিন দিন পর্যন্ত সমস্ত মিশর দেশে গাঢ় অন্ধকার হল। ");
INSERT INTO benirv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","তিনদিন পর্যন্ত কেউ কাকেও দেখতে পেল না এবং কেউ নিজের জায়গা থেকে উঠল না; কিন্তু ইস্রায়েল সন্তানদের জন্য তাদের বাসস্থানে আলো ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","তখন ফরৌণ মোশিকে ডেকে বললেন, “যাও, গিয়ে সদাপ্রভুর সেবা কর; শুধুমাত্র তোমাদের ভেড়ার পাল ও গরুর পাল থাকুক; তোমাদের শিশুরাও তোমাদের সঙ্গে যাক।” ");
INSERT INTO benirv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","কিন্তু মোশি বললেন, “আমাদের ঈশ্বর সদাপ্রভুর উদ্দেশ্যে উৎসর্গ করার জন্য আমাদের হাতে বলি ও হোমদ্রব্য সমর্পণ করা আপনার কর্তব্য। ");
INSERT INTO benirv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","আমাদের সঙ্গে আমাদের পশুরাও যাবে, একটি খুরও বাকি থাকবে না; কারণ আমাদের ঈশ্বর সদাপ্রভুর সেবার জন্য তাঁদের মধ্যে থেকে বলি করতে হবে এবং কি কি দিয়ে সদাপ্রভুর সেবা করব, তা সেখানে উপস্থিত না হলে আমরা জানতে পারব না।” ");
INSERT INTO benirv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","কিন্তু সদাপ্রভু ফরৌণের হৃদয় কঠিন করলেন, আর তিনি তাদেরকে ছেড়ে দিতে রাজি হলেন না। ");
INSERT INTO benirv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","তখন ফরৌণ তাঁকে বললেন, “আমার সামনে থেকে দূর হও; সাবধান, আমাকে আর কখনও মুখ দেখিও না; কারণ যে দিন আমার মুখ দেখবে, সেই দিন মরবে।” ");
INSERT INTO benirv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","মোশি বললেন, “ভালই বলেছেন, আমি আপনার মুখ আর কখনও দেখব না।” ");
INSERT INTO benirv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","আর সদাপ্রভু মোশিকে বললেন, “আমি ফরৌণের ও মিশরের উপরে আর এক মহামারী আনব, তারপরে সে তোমাদেরকে এই স্থান থেকে ছেড়ে দেবে এবং ছেড়ে দেবার দিনের তোমাদেরকে নিশ্চয়ই এখান থেকে একেবারে তাড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","তুমি লোকেদেরকে নির্দেশ দাও, আর প্রত্যেক পুরুষ তার প্রতিবেশীর থেকে ও প্রত্যেক স্ত্রী তার প্রতিবাসিনী থেকে রূপার ও সোনার গয়না চেয়ে নিক।” ");
INSERT INTO benirv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","আর সদাপ্রভু মিশরীয়দের চোখে লোকদেরকে অনুগ্রহের পাত্র করলেন। আবার মিশর দেশে মোশি ফরৌণের দাসেদের ও প্রজাদের চোখে খুব মহান ব্যক্তি হয়ে উঠলেন। ");
INSERT INTO benirv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","মোশি আরও বললেন, “সদাপ্রভু এই কথা বলেন, ‘আমি মাঝরাতে মিশরের মধ্যে দিয়ে যাব। ");
INSERT INTO benirv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","তাতে সিংহাসনে বসা ফরৌণের প্রথমজাত থেকে যাঁতা পেষণকারিণী দাসীর প্রথমজাত পর্যন্ত মিশর দেশের সকল প্রথমজাত মরবে। ");
INSERT INTO benirv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","আর যেরকম কখনও হয়নি ও হবে না, সমস্ত মিশর দেশে এমন মহাকোলাহল হবে। ");
INSERT INTO benirv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","কিন্তু সমস্ত ইস্রায়েল সন্তানের মধ্যে মানুষের কি পশুর বিরুদ্ধে একটা কুকুরও চিত্কার করবে না, যেন আপনারা জানতে পারেন যে, সদাপ্রভু মিশরীয় ও ইস্রায়েলীয়ের মধ্যে প্রভেদ করেন।’ ");
INSERT INTO benirv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","আর তোমার এই দাসেরা সবাই আমার কাছে নেমে আসবে ও প্রণাম করে আমাকে বলবে, ‘তুমি ও তোমার অনুগামী সব লোকেরা যাও,’ তারপর আমি বেরিয়ে আসব।” তখন তিনি খুব রেগে গিয়ে ফরৌণের কাছ থেকে বেরিয়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","আর সদাপ্রভু মোশিকে বলেছিলেন, “ফরৌণ তোমাদের কথায় মনোযোগ দেবে না, আমি অনেক অদ্ভুত জিনিস মিশর দেশে করব।” ");
INSERT INTO benirv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","মোশি ও হারোণ ফরৌণের সামনে এই সব অদ্ভুত কাজ করেছিলেন; আর সদাপ্রভু ফরৌণের অন্তর কঠিন করলেন, আর তিনি তাঁর দেশ থেকে ইস্রায়েলের লোকদের ছাড়লেন না। ");
INSERT INTO benirv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","মিশর দেশে সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","তোমাদের জন্য এই মাস হবে মাসগুলির শুরু; আর মাসটি বছরের সব মাসের মধ্যে প্রথম হবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","সমস্ত ইস্রায়েল মণ্ডলীকে এই কথা বল, তোমরা এই মাসের দশম দিনের তোমাদের বাবার বংশ অনুসারে প্রত্যেক পরিবার এক এক বাড়ির জন্য এক একটি ভেড়ার বাচ্চা নেবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","আর ভেড়ার বাচ্চা খাওয়ার জন্য যদি কারও পরিজন কম হয়, তবে সে ও তার পাশের বাড়ির প্রতিবেশীর লোকসংখ্যা অনুসারে একটি ভেড়ার বাচ্চা নেবে। তোমরা এক এক জনের খাওয়ার ক্ষমতা অনুসারে ভেড়ার বাচ্চা নেবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","তোমাদের সেই ভেড়ার বাচ্চাটি নির্দোষ ও এক বছরের পুরুষ বাচ্চা শাবক হবে; তোমরা ভেড়ার পালের কিংবা ছাগপালের মধ্যে থেকে তা নেবে; ");
INSERT INTO benirv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","আর এই মাসের চৌদ্দ দিন পর্যন্ত রাখবে; পরে ইস্রায়েলের সমস্ত সমাজ সন্ধ্যাবেলায় সেই ভেড়ার বাচ্চাটি হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","আর তারা তার কিছুটা রক্ত নেবে এবং যে যে বাড়ির মধ্যে ভেড়ার বাচ্চা খাবে, সেই বাড়ির দরজার চৌকাঠে ও মাথার ওপর তা লাগিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","পরে সেই রাতে তার মাংস খাবে; আগুনে পুড়িয়ে খামির বিহীন রুটি ও তেতো শাকের সঙ্গে তা খাবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","তোমরা তার মাংস কাঁচা কিংবা জলে সেদ্ধ করে খেও না, কিন্তু তার মাথা, পা ও ভিতরের অংশ আগুনে পুড়িও। ");
INSERT INTO benirv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","আর সকাল পর্যন্ত তার কিছুই রেখো না; কিন্তু সকাল পর্যন্ত যা বাকি থাকে, তা আগুনে পুড়িয়ে ফেলো। ");
INSERT INTO benirv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","আর তোমরা এই ভাবে তা খাবে; কোমর বাঁধবে, পায়ে জুতো পড়বে, হাতে লাঠি নেবে ও তাড়াতাড়ি খেয়ে নেবে; এটা সদাপ্রভুর নিস্তারপর্ব। ");
INSERT INTO benirv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","কারণ সেই রাতে আমি মিশর দেশের মধ্য দিয়ে যাব এবং মিশর দেশের মানুষের ও পশুর যাবতীয় প্রথমজাতকে আঘাত করব এবং মিশরের সমস্ত দেবতাদের উপরে শাস্তি নিয়ে আসব; আমিই সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","সুতরাং তোমরা যে যে বাড়িতে থাক, তোমাদের পক্ষে ঐ রক্ত চিহ্ন হিসাবে সেই সেই বাড়ির উপরে থাকবে; তাতে আমি যখন মিশর দেশকে আঘাত করব, তখন সেই রক্ত দেখলে তোমাদেরকে ছেড়ে এগিয়ে যাব, মহামারীর আঘাত তোমাদের উপরে পড়বে না। ");
INSERT INTO benirv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","আর এই দিন তোমাদের স্মরণীয় হবে এবং তোমরা এই দিন কে সদাপ্রভুর উৎসব বলে পালন করবে; বংশপরম্পরার চিরকালীন নিয়ম অনুসারে এই উৎসব পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","তোমরা সাত দিন খামির বিহীন রুটি খাবে; প্রথম দিনের ই নিজের নিজের বাড়ি থেকে খামির দূর করবে, কারণ যে কেউ প্রথম দিন থেকে সপ্তম দিন পর্যন্ত খামিরযুক্ত খাবার খাবে, সেই প্রাণী ইস্রায়েল থেকে বিচ্ছিন্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","আর প্রথম দিনের তোমাদের পবিত্র সভা হবে এবং সপ্তম দিনের ও তোমাদের পবিত্র সভা হবে; সেই দুই দিন প্রত্যেক প্রাণীর খাদ্য তৈরী ছাড়া অন্য কোন কাজ করবে না, শুধুমাত্র সেই কাজ করতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","এই ভাবে তোমরা খামির বিহীন রুটির পর্ব পালন করবে, কারণ এই দিনের আমি তোমাদের বাহিনীদেরকে মিশর দেশ থেকে বের করে আনলাম; তাই তোমরা বংশপরম্পরার চিরস্থায়ী বিধি অনুসারে এই দিন পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","তোমরা প্রথম মাসের চৌদ্দতম দিনের র সন্ধ্যাবেলা থেকে একুশতম দিনের র সন্ধ্যাবেলা পর্যন্ত খামির বিহীন রুটি খেও। ");
INSERT INTO benirv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","সাত দিন তোমাদের বাড়িতে যেন খামির না থাকে; কারণ কি প্রবাসী কি দেশের, যে কোন প্রাণী খামির মেশানো দ্রব্য খাবে, সে ইস্রায়েল মণ্ডলী থেকে বিচ্ছিন্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","তোমরা খামিরযুক্ত কোনো জিনিস খেও না; তোমরা তোমাদের সমস্ত বাসস্থানে খামির বিহীন রুটি খেও। ");
INSERT INTO benirv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","তখন মোশি ইস্রায়েলের সমস্ত প্রাচীনদেরকে ডেকে বললেন, তোমরা নিজেদের গোষ্ঠী অনুসারে এক একটি ভেড়ার বাচ্চা বের করে নাও, নিস্তারপর্ব্বের বলি হত্যা কর। ");
INSERT INTO benirv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","আর এক গুচ্ছ এসোব নিয়ে গামলায় থাকা রক্তে ডুবিয়ে দরজার মাথায় ও দুই চৌকাঠে গামলায় থাকা রক্তের কিছুটা লাগিয়ে দেবে এবং সকাল পর্যন্ত তোমরা কেউই বাড়ির দরজার বাইরে যাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","কারণ সদাপ্রভু মিশরীয়দেরকে আঘাত করার জন্য তোমাদের কাছ দিয়ে যাবেন, তাতে দরজার মাথায় ও দুই চৌকাঠে সেই রক্ত দেখলে সদাপ্রভু সেই দরজা ছেড়ে আগে যাবেন, তোমাদের বাড়িতে বিনাশকারীকে প্রবেশ করে আঘাত করতে দেবেন না। ");
INSERT INTO benirv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","আর তোমরা ও যুগ যুগ ধরে তোমাদের সন্তানেরা নিয়ম হিসাবে এই রীতি পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","আর সদাপ্রভু তাঁর প্রতিজ্ঞা অনুসারে তোমাদেরকে যে দেশ দেবেন, সেই দেশে যখন প্রবেশ করবে, তখনও এই আরাধনার আয়োজন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","আর তোমাদের সন্তানরা যখন তোমাদেরকে বলবে, তোমাদের এই আরাধনার অর্থ কি? ");
INSERT INTO benirv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","তোমরা বলবে, এটা সদাপ্রভুর উদ্দেশ্যে নিস্তারপর্ব্বের যজ্ঞ, কারণ মিশরীয়দেরকে আঘাত করার দিনের তিনি মিশরে ইস্রায়েল সন্তানদের সমস্ত বাড়ি ছেড়ে এগিয়ে গিয়েছিলেন, আমাদের বাড়ি রক্ষা করেছিলেন। তখন লোকেরা মাথা নিচু করে আরাধনা করল। ");
INSERT INTO benirv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","পরে ইস্রায়েল সন্তানেরা গিয়ে, সদাপ্রভু মোশি ও হারোণকে যেরকম আদেশ দিয়েছিলেন, সেই রকম করল। ");
INSERT INTO benirv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","পরে মাঝরাতে এই ঘটনা ঘটল, সদাপ্রভু সিংহাসনে বসা ফরৌণের প্রথমজাত সন্তান থেকে কারাগারে থাকা বন্দির প্রথমজাত সন্তান পর্যন্ত মিশর দেশের সমস্ত প্রথমজাত সন্তানকে ও পশুদের প্রথমজাত শাবকদেরকে আঘাত করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","তাতে ফরৌণ ও তাঁর দাসেরা এবং সমস্ত মিশরীয় লোক রাতে উঠল এবং মিশরে মহাকোলাহল হল; কারণ যে ঘরে কেউ মরে নি, এমন ঘরই ছিল না। ");
INSERT INTO benirv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","তখন রাতের বেলায় ফরৌণ মোশি ও হারোণকে ডেকে বললেন, “তোমরা ওঠ, ইস্রায়েল সন্তানদের নিয়ে আমার প্রজাদের মধ্যে থেকে বের হও, তোমরা যাও, তোমাদের কথা অনুসারে গিয়ে সদাপ্রভুর সেবা কর। ");
INSERT INTO benirv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","তোমাদের কথা অনুসারে ভেড়ার পাল ও গরুর পাল সব সঙ্গে নিয়ে চলে যাও এবং আমাকেও আশীর্বাদ কর।” ");
INSERT INTO benirv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","তখন লোকদেরকে তাড়াতাড়ি দেশ থেকে বিদায় করার জন্য মিশরীয়েরা ব্যাকুল হয়ে পড়ল; কারণ তারা বলল, “আমরা সকলে মারা পড়লাম।” ");
INSERT INTO benirv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","তাতে ময়দার তালে খামির মেশাবার আগে লোকেরা তা নিয়ে পেষাই করার পাত্র নিজেদের বস্ত্রে বেঁধে কাঁধে নিল। ");
INSERT INTO benirv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","আর ইস্রায়েল সন্তানেরা মোশির বাক্য অনুসারে কাজ করল; ফলে তারা মিশরীয়দের কাছে রূপা, সোনার গয়না ও পোশাক চাইল; ");
INSERT INTO benirv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","আর সদাপ্রভু মিশরীয়দের চোখে তাদেরকে অনুগ্রহপাত্র করলেন, তাই তারা যা চাইল, মিশরীয়েরা তাদেরকে তাই দিল। এই ভাবে তারা মিশরীয়দের ধনসম্পদ লুট করল। ");
INSERT INTO benirv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","তখন ইস্রায়েল সন্তানেরা বালক ছাড়া কমবেশি পায়ে হাঁটা ছয় লক্ষ পুরুষ রামিষেষ থেকে সুক্কোতে যাত্রা করল। ");
INSERT INTO benirv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","আর তাঁদের সঙ্গে মিশে থাকা সমস্ত লোকেরা এবং ভেড়া ও গরু, প্রচুর সংখ্যক পশু চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","পরে তারা মিশর থেকে আনা ময়দার তাল দিয়ে খামির বিহীন রুটি তৈরী করল, তাতে খামির মেশান হয়নি, কারণ তারা মিশর থেকে বেরিয়ে এসেছিল, সুতরাং দেরী করতে না চাওয়াতে নিজেদের জন্য খাদ্য দ্রব্য তৈরী করে নি। ");
INSERT INTO benirv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ইস্রায়েল সন্তানেরা চারশো ত্রিশ বছর মিশরে বসবাস করেছিল। ");
INSERT INTO benirv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","সেই চারশো ত্রিশ বছরের শেষে, ঐ দিনের, সদাপ্রভুর সমস্ত বাহিনী মিশর দেশ থেকে বের হল। ");
INSERT INTO benirv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","মিশর দেশ থেকে তাদেরকে বের করে আনার জন্য এটি ছিল সদাপ্রভুর উদ্দেশ্যে জেগে থাকার রাত, সেজন্য সমস্ত ইস্রায়েল সন্তানদের বংশ ধরে এই রাত ছিল সদাপ্রভুর উদ্দেশ্যে পালন করা অত্যন্ত পালনীয়। ");
INSERT INTO benirv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","আর সদাপ্রভু মোশি ও হারোণকে বললেন, “নিস্তারপর্ব্বের বলির নিয়ম এই; অন্য জাতীয় কোনো লোক তা খাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","কিন্তু কোন ব্যক্তির যে দাসকে রূপা দিয়ে কেনা হয়েছে, সে যদি ছিন্নত্বক হয়, তবে খেতে পাবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","বিদেশী কিংবা বেতনজীবী তা খেতে পাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","তোমরা এক বাড়ির মধ্যে তা খাবে; সেই মাংসের কিছুই বাড়ির বাইরে নিয়ে যেও না এবং তার একটি হাড়ও ভেঙ্গ না। ");
INSERT INTO benirv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","সমস্ত ইস্রায়েল মণ্ডলী এটা পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","আর তোমার সঙ্গে বসবাসকারী কোনো বিদেশী লোক যদি সদাপ্রভুর উদ্দেশ্যে নিস্তারপর্ব্ব পালন করতে চায়, তবে সে নিজে পুরুষ পরিবারের সঙ্গে ছিন্নত্বক হয়ে এটা পালন করতে আসুক, সে দেশের মধ্যে জন্মানো লোকের মত হবে; কিন্তু অচ্ছিন্নত্বক কোন লোক তা খাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","দেশে জন্মানো লোকের জন্য ও তোমাদের মধ্যে বসবাসকারী বিদেশী লোকের জন্য একই নিয়ম হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","সমস্ত ইস্রায়েল সন্তান সেই রকম করল, সদাপ্রভু মোশি ও হারোণকে যে আদেশ দিয়েছিলেন, সেই অনুসারেই করল। ");
INSERT INTO benirv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","এই ভাবে সদাপ্রভু সেই দিন ইস্রায়েল সন্তানদের দলে দলে মিশর দেশ থেকে বের করে আনলেন। ");
INSERT INTO benirv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ইস্রায়েল সন্তানদের মধ্যে উভয়ই মানুষ হোক কিংবা পশু হোক, গর্ভে জন্মানো গর্ভজাত সব প্রথম ফল আমার উদ্দেশ্যে পবিত্র কর; তা সব আমারই।” ");
INSERT INTO benirv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","আর মোশি তাদেরকে বললেন, এই দিন মনে রেখো, যে দিনের তোমরা মিশরের দাসত্বের ঘর থেকে বের হয়ে এসেছিলে, কারণ সদাপ্রভু শক্তিশালী হাত দিয়ে সেখান থেকে তোমাদের বের করে আনলেন; কোনো খামিরযুক্ত খাবার খাওয়া হবে না। ");
INSERT INTO benirv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","আবীব মাসের এই দিনের তোমরা বের হলে। ");
INSERT INTO benirv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","আর কনানীয়, হিত্তীয়, ইমোরীয়, হিব্বীয় ও যিবূষীয়ের যে দেশ তোমাকে দিতে সদাপ্রভু তোমার পূর্বপুরুষদের কাছে প্রতিজ্ঞা করেছেন, সেই দুধ ও মধু প্রবাহিত দেশে যখন তিনি তোমাকে নিয়ে যাবেন, তখন তুমি এই মাসে এই সেবার অনুষ্ঠান করবে। ");
INSERT INTO benirv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","সাত দিন খামির বিহীন রুটি খেও ও সপ্তম দিনের সদাপ্রভুর উদ্দেশ্যে উৎসব কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","সেই সাত দিন খামির বিহীন রুটি খেতে হবে, তোমার কাছে খামিরযুক্ত খাবার দেখা না যাক, তোমার সমস্ত সীমানার মধ্যে খামির দেখা না যাক। ");
INSERT INTO benirv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","সেই দিনের তুমি তোমার ছেলেকে এটা জানিও, মিশর থেকে আমার বেরিয়ে আসার দিনের সদাপ্রভু আমার প্রতি যা করলেন, এটা সেই জন্য। ");
INSERT INTO benirv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","আর এটা চিহ্নের জন্য তোমার হাতে ও স্মরণের জন্য তোমার কপালে থাকবে; যেন সদাপ্রভুর ব্যবস্থা তোমার মুখে থাকে, কারণ সদাপ্রভু শক্তিশালী হাত দিয়ে মিশর থেকে তোমাকে বের করেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","সুতরাং তুমি প্রত্যেক বছর এইদিনের এই নিয়ম পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","সদাপ্রভু তোমার কাছে ও তোমার পূর্বপুরুষদের কাছে যে প্রতিজ্ঞা করেছেন, সেই অনুসারে যখন কনানীয়দের দেশে প্রবেশ করিয়ে তোমাকে সেই দেশ দেবেন, ");
INSERT INTO benirv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","তখন তুমি গর্ভজাত সমস্ত প্রথম ফল সদাপ্রভুর কাছে উপস্থিত করবে এবং তোমার পশুদেরও সকল প্রথমজাতদের মধ্যে পুরুষ সন্তান সদাপ্রভুর হবে। ");
INSERT INTO benirv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","আর গাধার প্রত্যেক প্রথমজাতের মুক্তির জন্য তার পরিবর্তে ভেড়ার বাচ্চা দেবে; যদি মুক্ত না কর, তবে তার গলা ভাঙ্গবে; তোমার ছেলেদের মধ্যে মানুষের প্রথমজাত সবাইকে মুক্ত করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","আর তোমার ছেলে আগামীকালে যখন তোমাকে জিজ্ঞাসা করবে, এ কি? তুমি বলবে, সদাপ্রভু শক্তিশালী হাত দিয়ে আমাদেরকে মিশর থেকে, দাসত্বের ঘর থেকে, বের করেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","তখন ফরৌণ আমাদেরকে ছেড়ে দেবার বিষয়ে নিষ্ঠুর হলে সদাপ্রভু মিশর দেশের সমস্ত প্রথমজাত ফলকে, মানুষের প্রথমজাত ও পশুর প্রথমজাত ফল সব কিছুকে হত্যা করলেন, এই জন্য আমি গর্ভে জন্মানো পুরুষসন্তান গুলিকে সদাপ্রভুর উদ্দেশ্যে বলিদান করি, কিন্তু আমার প্রথমজাত সব সন্তানকে মুক্ত করি। ");
INSERT INTO benirv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","এটি চিহ্ন হিসাবে তোমার হাতে ও স্মৃতিচিহ্ন হিসাবে তোমার কপালে থাকবে, কারণ সদাপ্রভু শক্তিশালী হাত দিয়ে আমাদেরকে মিশর দেশ থেকে বের করে এনেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","আর ফরৌণ লোকদের ছেড়ে দিলে, পলেষ্টীয়দের দেশ দিয়ে সোজা পথ থাকলেও ঈশ্বর সেই পথে তাদেরকে যেতে দিলেন না, কারণ ঈশ্বর বললেন, “যুদ্ধ দেখলে হয়তো লোকেরা অনুতাপ করে মিশরে ফিরে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","সুতরাং ঈশ্বর লোকেদেরকে সূফসাগরের মরুপ্রান্তের পথ দিয়ে নিয়ে গেলেন; আর ইস্রায়েল সন্তানরা যুদ্ধ সজ্জায় সজ্জিত হয়ে মিশর দেশ থেকে চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","আর মোশি যোষেফের হাড় নিজের সঙ্গে নিলেন, কারণ তিনি ইস্রায়েল সন্তানদের কঠিন শপথ করিয়ে বলেছিলেন, “ঈশ্বর অবশ্যই তোমাদের দেখাশোনা করবেন, আর তোমরা তোমাদের সঙ্গে আমার হাড় এই জায়গা থেকে নিয়ে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","পরে তারা সুক্কোৎ থেকে চলে গিয়ে মরুপ্রান্তের প্রান্তে থাকা এথমে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","আর সদাপ্রভু দিনের র বেলা পথ দেখার জন্য মেঘস্তম্ভ থেকে এবং রাতে আলো দেবার জন্য অগ্নিস্তম্ভ থেকে তাঁদের আগে আগে যেতেন, যেন তারা দিন রাত চলতে পারে। ");
INSERT INTO benirv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","লোকেদের সামনে থেকে দিনের রবেলায় মেঘস্তম্ভ ও রাতে অগ্নিস্তম্ভ দূরে সরত না। ");
INSERT INTO benirv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“তুমি ইস্রায়েল সন্তানদের বল, তারা যেন ফেরে এবং পী-হহীরোতের আগে মিগ্‌দোলের ও সমুদ্রের মাঝখানে বাল্‌সফোনের আগে শিবির স্থাপন করে। ");
INSERT INTO benirv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","তাতে ফরৌণ ইস্রায়েল সন্তানদের সম্বন্ধে বলবে, তারা দেশের মধ্যে ঘুরে বেড়াল, মরুভূমি তাঁদের পথ বন্ধ করল। ");
INSERT INTO benirv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","আর আমি ফরৌণের মন কঠিন করব এবং সে তোমাদের পিছনে দৌড়াবে। আমি ফরৌণ ও তার সমস্ত সৈন্যদের মাধ্যমে গৌরবান্বিত হব; আর মিশরীয়েরা জানতে পারবে যে, আমিই সদাপ্রভু।” তখন তারা সেই রকম করল। ");
INSERT INTO benirv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","যখন মিশরের রাজাকে এই খবর দেওয়া হল যে, ইস্রায়েলের লোকেরা পালিয়েছে, ফরৌণ ও তার দাসেদের অন্তর লোকেদের বিরুদ্ধে হল; তাঁরা বললেন, “আমরা এ কি করলাম? আমাদের দাসত্ব থেকে ইস্রায়েলকে কেন ছেড়ে দিলাম?” ");
INSERT INTO benirv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","তখন তিনি তাঁর রথ প্রস্তুত করালেন ও তাঁর লোকেদের সঙ্গে নিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","আর মনোনীত ছয়শো রথ এবং মিশরের সমস্ত রথ ও সেই সমস্ত কিছুর উপরে নিযুক্ত সেনাপতিকে নিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","আর সদাপ্রভু মিশরের রাজা ফরৌণের অন্তর কঠিন করলেন, তাতে তিনি ইস্রায়েল সন্তানদের পিছু পিছু তাড়া করলেন; তখন ইস্রায়েল সন্তানেরা জয়জয়কার করতে করতে চলে যাচ্ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","আর মিশরীয়রা, ফরৌণের সকল ঘোড়া ও রথ এবং তার ঘোড়াচালক ও সৈন্যরা তাদের পিছু পিছু তাড়া করল; আর তারা বাল্ সফোনের সামনে পী-হহীরোতের কাছে সমুদ্রের তীরে শিবির স্থাপন করলে তাদের কাছে উপস্থিত হল। ");
INSERT INTO benirv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ফরৌণ যখন কাছাকাছি চলে এলেন, তখন ইস্রায়েলের সন্তানেরা চোখ তুলে দেখল, তাদের পিছু পিছু মিশরীয়েরা আসছে; তাই তাঁরা খুব ভয় পেল, আর ইস্রায়েল সন্তানেরা সদাপ্রভুর উদ্দেশ্যে চিত্কার করে কাঁদতে লাগলো। ");
INSERT INTO benirv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","আর তাঁরা মোশিকে বলল, “মিশরে কবর নেই বলে তুমি কি আমাদেরকে নিয়ে আসলে, যেন আমরা মরুপ্রান্তে মারা যাই? তুমি আমাদের সঙ্গে এ কেমন ব্যবহার করলে? কেন আমাদেরকে মিশর থেকে বের করলে? ");
INSERT INTO benirv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","আমরা কি মিশর দেশে তোমাকে এই কথা বলি নি, আমাদেরকে থাকতে দাও, আমরা মিশরীয়দের দাসত্ব করি? কারণ মরুপ্রান্তে মারা যাবার থেকে মিশরীয়দের দাসত্ব করা আমাদের ভালো।” ");
INSERT INTO benirv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","তখন মোশি তাদেরকে বললেন, “ভয় কোরো না, সবাই স্থির হয়ে দাঁড়াও। সদাপ্রভু আজ তোমাদের যে উদ্ধার করেন, তা দেখ; কারণ এই যে মিশরীয়দেরকে আজ দেখছ, এদেরকে আর কখনই দেখবে না। ");
INSERT INTO benirv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","সদাপ্রভু তোমাদের পক্ষ নিয়ে যুদ্ধ করবেন, তোমরা শান্ত থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","পরে সদাপ্রভু মোশিকে বললেন, “তুমি কেন আমার কাছে চিত্কার করে কাঁদছ? ইস্রায়েল সন্তানদের এগিয়ে যেতে বল। ");
INSERT INTO benirv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","আর তুমি তোমার লাঠি তুলে সমুদ্রের উপরে হাত বাড়াও, সমুদ্রকে দুই ভাগ কর; তাতে ইস্রায়েল সন্তানেরা শুকনো পথ দিয়ে সমুদ্রের মধ্যে প্রবেশ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","আর দেখ, আমিই মিশরীয়দের অন্তর কঠিন করব, তাতে তারা তাদের পিছু পিছু প্রবেশ করবে এবং আমি ফরৌণের, তার সব সৈন্যের, তার রথগুলির ও তার ঘোড়াচালকদের মাধ্যমে গৌরবান্বিত হব। ");
INSERT INTO benirv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","আর ফরৌণ ও তার রথগুলি ও তার ঘোড়াচালকদের মাধ্যমে আমার গৌরবলাভ হলে মিশরীয়েরা জানতে পারবে যে, আমিই সদাপ্রভু।” ");
INSERT INTO benirv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","তখন ইস্রায়েলীয় সৈন্যের আগে আগে যাওয়া ঈশ্বরের দূত সরে গিয়ে তাদের পিছু পিছু গেলেন এবং মেঘস্তম্ভ তাদের সামনে থেকে সরে গিয়ে তাদের পিছনে গিয়ে দাঁড়াল; ");
INSERT INTO benirv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","তা মিশরের শিবির ও ইস্রায়েলের শিবির, এই দুইয়ের মধ্যে আসল; আর সেই মেঘ ও অন্ধকার থাকল, কিন্তু সেটা রাতে আলো দিল এবং সমস্ত রাত একদল অন্য দলের কাছে আসল না। ");
INSERT INTO benirv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","মোশি সমুদ্রের উপরে তাঁর হাত বাড়ালেন, তাতে সদাপ্রভু সেই সমস্ত রাতে শক্তিশালী পূর্ব দিকের বায়ু দিয়ে সমুদ্রকে সরিয়ে দিলেন ও তা শুকনো জমিতে পরিণত করলেন, তাতে জল দুই ভাগ হল। ");
INSERT INTO benirv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","আর ইস্রায়েল সন্তানেরা শুকনো পথে সমুদ্রের মধ্যে প্রবেশ করল এবং তাদের ডান ও বাম দিকের জল দেওয়ালের মত হল। ");
INSERT INTO benirv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","পরে মিশরীয়েরা, ফরৌণের সব ঘোড়া ও রথ এবং ঘোড়াচালকরা তাড়া করে তাদের পিছু পিছু সমুদ্রের মধ্যে প্রবেশ করল। ");
INSERT INTO benirv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","কিন্তু রাতের শেষ দিনের সদাপ্রভু অগ্নি ও মেঘস্তম্ভ থেকে মিশরীয় সৈন্যদের উপরে নজর রাখলেন ও মিশরীয়দের সৈন্যকে ব্যাকুল করে তুললেন। ");
INSERT INTO benirv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","আর তিনি তাদের রথের চাকার গতিরোধ করলেন, তাতে তারা খুব কষ্ট করে রথ চালাল; তখন মিশরীয়েরা বলল, “চল, আমরা ইস্রায়েলের সামনে থেকে পালিয়ে যাই, কারণ সদাপ্রভু তাদের হয়ে মিশরীয়দের বিপক্ষে যুদ্ধ করছেন।” ");
INSERT INTO benirv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","পরে সদাপ্রভু মোশিকে বললেন, “তুমি সমুদ্রের উপরে হাত বাড়াও; তাতে জল ফিরে মিশরীয়দের উপরে, তাদের রথের উপরে ও ঘোড়াচালকদের উপরে আসবে।” ");
INSERT INTO benirv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","তখন মোশি সমুদ্রের উপরে হাত বাড়ালেন, আর সকাল হতে না হতেই সমুদ্র আগের মত সমান হয়ে গেল; তাতে মিশরীয়েরা সমুদ্রের দিকেই পালিয়ে গেল; আর সদাপ্রভু সমুদ্রের মধ্যে মিশরীয়দেরকে ঠেলে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","জল ফিরে এল ও তাদের রথ ও ঘোড়াচালকদেরকে ঢেকে দিল, তাতে ফরৌণের যে সব সৈন্য তাদের পিছনে সমুদ্রে প্রবেশ করেছিল, তাদের একজনও বেঁচে থাকল না। ");
INSERT INTO benirv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","যদিও ইস্রায়েল সন্তানেরা শুকনো পথে সমুদ্রের মধ্যে দিয়ে গিয়েছিল এবং তাদের ডানে ও বামে জল একটি দেওয়ালের মত হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","এই ভাবে সেদিন সদাপ্রভু মিশরীয়দের হাত থেকে ইস্রায়েলকে উদ্ধার করলেন ও ইস্রায়েল মিশরীয়দেরকে সমুদ্রের ধারে মৃত দেখল। ");
INSERT INTO benirv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","আর ইস্রায়েল মিশরীয়দের প্রতি করা সদাপ্রভুর আশ্চর্য্য কাজ দেখল; তাতে লোকেরা সদাপ্রভুকে ভয় করল এবং সদাপ্রভুতে ও তাঁর দাস মোশিতে বিশ্বাস করল। ");
INSERT INTO benirv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","তখন মোশি ও ইস্রায়েল সন্তানেরা সদাপ্রভুর উদ্দেশ্যে এই গীত গান করলেন; তাঁরা বলল “আমি সদাপ্রভুর উদ্দেশ্যে গান করব; কারণ তিনি বিজয়ের সঙ্গে মহিমান্বিত হলেন, তিনি ঘোড়া ও ঘোড়াচালকদের সমুদ্রে ছুঁড়ে ফেললেন। ");
INSERT INTO benirv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","সদাপ্রভু আমার শক্তি ও গান, তিনি আমার পরিত্রান হলেন; এই আমার ঈশ্বর, আমি তাঁর প্রশংসা করব; আমার পিতার ঈশ্বর, আমি তাঁকে মহিমান্বিত করব। ");
INSERT INTO benirv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","সদাপ্রভু যোদ্ধা; সদাপ্রভু তাঁর নাম। ");
INSERT INTO benirv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","তিনি ফরৌণের রথগুলি ও সৈন্যদলকে সমুদ্রে ছুঁড়ে ফেললেন; তাঁর মনোনীত সেনাপতিরা সুফসাগরে ডুবে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","জলরাশি তাদেরকে ঢেকে দিল; তারা অগাধ জলে পাথরের মত তলিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","হে সদাপ্রভু, তোমার ডান হাত শক্তিতে মহিমান্বিত; হে সদাপ্রভু, তোমার ডান হাত শত্রু ধ্বংসকারী। ");
INSERT INTO benirv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","তুমি নিজের মহিমার প্রতাপে, যাঁরা তোমার বিরুদ্ধে উঠে, তাদেরকে ধ্বংস করে থাক; তোমার পাঠানো ক্রোধ খরকুটোর মত তাদেরকে গ্রাস করে। ");
INSERT INTO benirv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","তোমার নাকের নিঃশ্বাসে জল এক সাথে জড়ো হল; স্রোতগুলি স্তূপের মত দাঁড়িয়ে গেল; সমুদ্রগর্ভে জলরাশি জমাট বাঁধলো। ");
INSERT INTO benirv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","শত্রু বলেছিল, ‘আমি পিছনে তাড়া করব, তাদের নাগালে পাব, লুট করা জিনিস ভাগ করে নেব; তাদের উপর আমার অভিলাষ পূর্ণ হবে; আমি তরোয়াল টেনে খুলবো, আমার হাত তাদেরকে ধ্বংস করবে।’ ");
INSERT INTO benirv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","কিন্তু তুমি তোমার বাতাস দিয়ে ফুঁ দিলে, সমুদ্র তাদেরকে ঢেকে দিল; তারা প্রবল জলে সীসার মত তলিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","হে সদাপ্রভু, দেবতাদের মধ্যে কে তোমার মত? কে তোমার মত পবিত্রতায় মহিমান্বিত, প্রশংসাতে সম্মানিত, অলৌকিক কার্যকারী? ");
INSERT INTO benirv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","তুমি তোমার ডান হাত বাড়ালে, পৃথিবী তাদেরকে গ্রাস করল। ");
INSERT INTO benirv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","তুমি যে লোকদেরকে মুক্ত করেছ, তাদেরকে নিজের দয়াতে চালাচ্ছ, তুমি নিজের শক্তিতে তাদেরকে পবিত্র স্থানে চালনা করছ, যেখানে তুমি বাস কর। ");
INSERT INTO benirv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","লোকেরা এটা শুনল এবং তারা ভয় পেল, পলেষ্টীয়বাসীরা ব্যথাগ্রস্ত হয়ে পড়ল। ");
INSERT INTO benirv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","তখন ইদোমের প্রধানেরা ভয় পেল; মোয়াবের সৈন্যরা কাঁপতে লাগল; কনানের অধিবাসীরা গলে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","আতঙ্ক ও ভয় তাঁদের উপরে পড়ছে; তোমার বাহুবলে তারা এখনো পাথরের মত হয়ে আছে; যতক্ষণ, হে সদাপ্রভু, তোমার প্রজারা উত্তীর্ন না হয়। ");
INSERT INTO benirv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","তুমি তাদেরকে নিয়ে যাবে, তোমার অধিকার পর্বতে তাদের রোপণ করবে; হে সদাপ্রভু, সেখানে তুমি তোমার বাসস্থান প্রস্তুত করেছ; হে প্রভু, সেখানে তোমার হাত পবিত্রস্থান স্থাপন করেছ। ");
INSERT INTO benirv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","সদাপ্রভু যুগে যুগে অনন্তকাল রাজত্ব করবেন।” ");
INSERT INTO benirv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","কারণ ফরৌণের ঘোড়ারা তাঁর রথগুলি ও ঘোড়াচালকরা সমেত সমুদ্রের মধ্যে প্রবেশ করল, আর সদাপ্রভু সমুদ্রের জল তাঁদের উপরে ফিরিয়ে আনলেন; কিন্তু ইস্রায়েল সন্তানেরা শুকনো পথে সমুদ্রের মধ্যে দিয়ে চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","পরে হারোণের বোন মরিয়ম ভাববাদিনীর হাতে খঞ্জনি নিলেন এবং তাঁর পিছু পিছু অন্য স্ত্রীলোকেরা সবাই খঞ্জনি নিয়ে নাচতে নাচতে বেরোলো। ");
INSERT INTO benirv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","তখন মরিয়ম লোকেদের কাছে এই গান গাইলেন, “তোমরা সদাপ্রভুর উদ্দেশ্যে গান কর; কারণ তিনি বিজয়ের সঙ্গে মহিমান্বিত হলেন, তিনি ঘোড়া ও ঘোড়াচালকদের সমুদ্রে ছুঁড়ে ফেললেন।” ");
INSERT INTO benirv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","আর মোশি ইস্রায়েলকে সূফসাগর থেকে এগিয়ে শূর মরুপ্রান্তে নিয়ে গেল; আর তারা তিনদিন মরুপ্রান্তে যেতে যেতে জল পেল না। ");
INSERT INTO benirv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","পরে তারা মারাতে উপস্থিত হল, কিন্তু মারার জল পান করতে পারল না, কারণ সেই জল তেতো; এই জন্য তাঁর নাম মারা তিক্ততা রাখা হল। ");
INSERT INTO benirv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","তখন লোকেরা মোশির বিরুদ্ধে অভিযোগ করে বলল, “আমরা কি পান করব?” ");
INSERT INTO benirv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","তাতে তিনি সদাপ্রভুর উদ্দেশ্যে কাঁদতে লাগলেন, আর সদাপ্রভু তাঁকে একটা গাছ দেখালেন; তিনি তা নিয়ে জলে ছুঁড়ে ফেললে জল মিষ্টি হল। সেখানে সদাপ্রভু ইস্রায়েলের জন্য নিয়ম ও শাসন নির্ধারণ করলেন এবং তার পরীক্ষা নিলেন, ");
INSERT INTO benirv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","আর বললেন, “তুমি যদি তোমার ঈশ্বর সদাপ্রভুর রবে মনোযোগ কর, তাঁর চোখে যা ঠিক তাই কর, তাঁর আদেশ শোনো ও তাঁর নিয়মগুলি পালন কর, তবে আমি মিশরীয়দেরকে যে সব রোগে আক্রান্ত করলাম, সেই সবেতে তোমাকে আক্রমণ করতে দেব না; কারণ আমি সদাপ্রভু, তোমার আরোগ্যকারী।” ");
INSERT INTO benirv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","পরে তারা এলীমে উপস্থিত হল। সেখানে জলের বারোটি উনুই ও সত্তরটি খেজুরগাছ ছিল; তারা সেখানে জলের কাছে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","পরে তারা এলীম থেকে যাত্রা করল। আর মিশর দেশ থেকে চলে যাবার পর দ্বিতীয় মাসের পনেরোতম দিনের ইস্রায়েল সন্তানদের সমস্ত মণ্ডলী সীন মরুপ্রান্তে উপস্থিত হল, তা এলীমের ও সীনয়ের মাঝখানে। ");
INSERT INTO benirv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","তখন ইস্রায়েল সন্তানদের সমস্ত মণ্ডলী মোশির ও হারোণের বিরুদ্ধে মরুপ্রান্তে অভিযোগ করল; ");
INSERT INTO benirv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","আর ইস্রায়েল সন্তানেরা তাঁদেরকে বলল, “হায়, হায়, আমরা মিশর দেশে সদাপ্রভুর হাতে কেন মারা যাই নি? তখন মাংসের হাঁড়ীর কাছে বসতাম, রুটি খেয়ে সন্তুষ্ট হতাম, তোমরা তো আমাদের সমস্ত গোষ্ঠীকে না খাইয়ে মারার জন্য বের করে এই মরুপ্রান্তে এনেছ।” ");
INSERT INTO benirv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","তখন সদাপ্রভু মোশিকে বললেন, “দেখ, আমি তোমাদের জন্য স্বর্গ থেকে খাদ্য দ্রব্য বর্ষণ করব; লোকেরা বাইরে গিয়ে প্রতিদিন সেইদিনের র জন্য খাদ্য কুড়োবে; যেন আমি তাদের এই পরীক্ষা নিই যে, তারা আমার ব্যবস্থাতে চলবে কি না। ");
INSERT INTO benirv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ষষ্ঠ দিনের তারা যা আনবে, সেটা রান্না করলে প্রতিদিন যা কুড়ায়, তার দ্বিগুন হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","পরে মোশি ও হারোণ সমস্ত ইস্রায়েল সন্তানকে বললেন, “সন্ধ্যাবেলায় তোমরা জানবে যে, সদাপ্রভু তোমাদেরকে মিশর দেশ থেকে বের করে এনেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","আর সকালে তোমরা সদাপ্রভুর প্রতাপ দেখতে পাবে, কারণ সদাপ্রভুর বিরুদ্ধে যে অভিযোগ, তা তিনি শুনেছেন। আমরা কে যে, তোমরা আমাদের বিরুদ্ধে অভিযোগ কর?” ");
INSERT INTO benirv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","পরে মোশি বললেন, “সদাপ্রভু সন্ধ্যাবেলা খাওয়ার জন্য তোমাদেরকে মাংস দেবেন ও সকালে তৃপ্তি সহকারে রুটি দেবেন; সদাপ্রভুর বিরুদ্ধে তোমরা যে অভিযোগ করছ, তা তিনি শুনেছেন; আমরা কে? তোমরা যে অভিযোগ করছ, সেটা আমাদের বিরুদ্ধে নয়, সদাপ্রভুরই বিরুদ্ধে করছ।” ");
INSERT INTO benirv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","পরে মোশি হারোণকে বললেন, “তুমি ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে বলো, ‘তোমরা সদাপ্রভুর সামনে এস; কারণ তিনি তোমাদের অভিযোগ শুনেছেন’।” ");
INSERT INTO benirv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","পরে হারোণ যখন ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে এটা বলছিলেন, তখন তারা মরুপ্রান্তের দিকে মুখ ফেরাল; আর দেখ, মেঘস্তম্ভের মধ্যে সদাপ্রভুর প্রতাপ দেখা গেল। ");
INSERT INTO benirv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“আমি ইস্রায়েল সন্তানদের অভিযোগ শুনেছি; তুমি তাদেরকে বলো, সন্ধ্যাবেলায় তোমরা মাংস খাবে ও সকালে রুটি খেয়ে তৃপ্ত হবে; তখন জানতে পারবে যে, আমি সদাপ্রভু, তোমাদের ঈশ্বর।” ");
INSERT INTO benirv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","পরে সন্ধ্যাকালে তিতির পাখি উড়ে এসে শিবির ঢেকে দিল এবং সকালে শিবিরের চারিদিকে শিশির পড়ল। ");
INSERT INTO benirv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","যখন শিশির শুকিয়ে গেল, দেখ, মাটিতে তুষারের মত সরু বীজের মত বস্তু মরুপ্রান্তের উপরে পড়ে আছে। ");
INSERT INTO benirv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","আর সেটা দেখে ইস্রায়েল সন্তানরা একে অপরকে বলল, “এটা কি?” কারণ সেটা কি, তারা জানত না। তখন মোশি বললেন, “এটা সেই রুটি, যা সদাপ্রভু তোমাদেরকে খাবার জন্য দিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","এর বিষয়ে সদাপ্রভু এই আদেশ দিয়েছেন, তোমরা প্রত্যেক জন নিজেদের প্রয়োজন মত তা কুড়াও; তোমরা প্রত্যেকে নিজেদের তাঁবুতে থাকা লোকেদের সংখ্যা অনুসারে এক এক জনের জন্য এক এক ওমর পরিমাপে তা কুড়াও।” ");
INSERT INTO benirv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","তাতে ইস্রায়েল সন্তানেরা সেই রকম করল; কেউ বেশি, কেউ কম কুড়ালো। ");
INSERT INTO benirv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","পরে ওমরে তা মেপে দেখলে, যে বেশি সংগ্রহ করেছিল, তার অভাব হল না; তারা প্রত্যেকে নিজের নিজের প্রয়োজন অনুযায়ী কুড়িয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","আর মোশি বললেন, “তোমরা কেউ সকালের জন্য এর কিছু রেখো না।” ");
INSERT INTO benirv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","তবুও কেউ কেউ মোশির কথা না মেনে সকালের জন্য কিছু কিছু রাখল, তখন তাতে পোকা জন্মালো ও দুর্গন্ধ হল; আর মোশি তাঁদের উপরে খুব রাগ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","আর প্রত্যেকদিন সকালে তারা নিজের নিজের প্রয়োজন অনুযায়ী কুড়াত, কিন্তু খুব রোদ হলে তা গলে যেত। ");
INSERT INTO benirv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","পরে ছয় দিনের র দিন তারা দ্বিগুন খাদ্য সংগ্রহ করত, প্রত্যেক জন দুই ওমর করে কুড়াল, আর মণ্ডলীর অধ্যক্ষেরা সবাই এসে মোশিকে জানালেন। ");
INSERT INTO benirv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","তখন তিনি তাঁদেরকে বললেন, সদাপ্রভু তাই বলেছেন; কাল বিশ্রামপর্ব, সদাপ্রভুর উদ্দেশ্যে পবিত্র বিশ্রামবার; তোমাদের যা ভাজবার আছে তা ভাজ ও যা রান্না করবার আছে পাক কর এবং যা অতিরিক্তও, তা সকালের জন্য তুলে রাখ। ");
INSERT INTO benirv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","তাতে তারা মোশির আজ্ঞানুযায়ী সকাল পর্যন্ত তা রাখল, তখন তাতে দুর্গন্ধ হল না, পোকাও জন্মালো না। ");
INSERT INTO benirv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","পরে মোশি বললেন, আজ তোমরা এটা ভোজন কর, কারণ আজ সদাপ্রভুর বিশ্রামবার; আজ মাঠে এটা পাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","তোমরা ছয় দিন তা কুড়াবে; কিন্তু সাত দিনের র দিন বিশ্রামবার, সে দিন তা পাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","তা সত্বেও সাত দিনের র দিনের লোকদের মধ্যে কেউ কেউ তা কুড়াবার জন্য বের হল; কিন্তু কিছুই পেল না। ");
INSERT INTO benirv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","তখন সদাপ্রভু মোশিকে বললেন, তোমরা আমার আদেশ ও ব্যবস্থা পালন করতে কতকাল অস্বীকার করতে থাকবে? ");
INSERT INTO benirv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","দেখ, সদাপ্রভুই তোমাদেরকে বিশ্রামবার দিয়েছেন, তাই তিনি ছয় দিনের র দিন দুই দিনের র খাদ্য তোমাদেরকে দিয়ে থাকেন; তোমরা প্রত্যেকে নিজ নিজ জায়গায় থাক; সাত দিনের র দিন কেউ নিজের জায়গা থেকে বাইরে যাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","তাতে লোকেরা সাত দিনের র দিন বিশ্রাম করল। ");
INSERT INTO benirv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","আর ইস্রায়েলের বংশ ঐ খাদ্যের নাম মান্না রাখল; তা ধনে বীজের মত সাদা এবং তাঁর স্বাদ মধুমেশানো বিস্কুটের মত ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","পরে মোশি বললেন, “সদাপ্রভু এই আদেশ করেছেন, ‘তোমরা বংশপরম্পরা অনুসারে ওর এক ওমর পরিমাণ তুলে রেখো, যেন আমি তোমাদেরকে মিশর দেশ থেকে আনার দিনের দূরের নির্জন জায়গায় যে খাবার খেতে দিতাম, তারা তা দেখতে পায়’।” ");
INSERT INTO benirv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","তখন মোশি হারোণকে বললেন, “তুমি একটা পাত্র নিয়ে পূর্ণ এক ওমর পরিমাপের সমান মান্না সদাপ্রভুর সামনে রাখ; তা তোমাদের পূর্বপুরুষদের নিয়মের জন্য রাখা যাবে।” ");
INSERT INTO benirv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","তখন, সদাপ্রভু মোশিকে যেমন আদেশ করেছিলেন, সেইভাবে হারোণ সাক্ষ্য সিন্দুকের কাছে থাকবার জন্য তা তুলে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ইস্রায়েল সন্তানেরা চল্লিশ বছর, যতক্ষণ না বসবাসকারী দেশে উপস্থিত হল, ততক্ষণ সেই মান্না খেল; কনান দেশের সীমাতে উপস্থিত না হওয়া পর্যন্ত তারা মান্না খেত। ");
INSERT INTO benirv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","এখন এক ওমর সমান হলো ঐফার দশমাংশ। ");
INSERT INTO benirv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","পরে ইস্রায়েল সন্তানদের সমস্ত মণ্ডলী সীন মরুভূমি থেকে যাত্রা শুরু করে সদাপ্রভুর আদেশ অনুসারে নির্ধারিত সমস্ত স্থান দিয়ে যাত্রা করে রফীদীমে গিয়ে শিবির স্থাপন করল; আর সেখানে লোকেদের পান করার জন্য জল ছিল না। ");
INSERT INTO benirv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","এই জন্য লোকেরা মোশিকে দোষ দিয়ে বলল, “আমাদেরকে জল দাও, আমরা পান করব।” মোশি তাদেরকে বললেন, “কেন আমার সঙ্গে ঝগড়া করছ? কেন সদাপ্রভুর পরীক্ষা করছ?” ");
INSERT INTO benirv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","তখন লোকেরা সেখানে জল পিপাসায় ব্যাকুল হল, আর মোশির বিরুদ্ধে অভিযোগ করে বলল, “তুমি আমাদেরকে এবং আমাদের সন্তানদের ও পশুদেরকে পিপাসিত করে হত্যা করতে মিশর থেকে কেন আনলে?” ");
INSERT INTO benirv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","আর মোশি সদাপ্রভুর কাছে কেঁদে বললেন, “আমি এই লোকদের জন্য কি করব? কিছুক্ষণের মধ্যে এরা আমাকে পাথরের আঘাতে হত্যা করবে।” ");
INSERT INTO benirv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","তখন সদাপ্রভু মোশিকে বললেন, “তুমি লোকদের আগে যাও, ইস্রায়েলের কয়েক জন প্রাচীনকে সঙ্গে নিয়ে, আর যেটা দিয়ে নদীতে আঘাত করেছিলে, সেই লাঠি হাতে নিয়ে যাও। ");
INSERT INTO benirv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","দেখ, আমি হোরেবে সেই শিলার উপরে তোমার সামনে দাঁড়াবো; তুমি শিলাতে আঘাত করবে, তাতে সেটা থেকে জল বের হবে, আর লোকেরা পান করবে।” তখন মোশি ইস্রায়েলের প্রাচীনদের চোখের সামনে সেই রকম করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","তিনি সেই স্থানের নাম মঃসা ও মরীবা পরীক্ষা ও বিবাদ রাখলেন, কারণ ইস্রায়েল সন্তানরা অভিযোগ করেছিল এবং সদাপ্রভুর পরীক্ষা করে বলেছিল, সদাপ্রভু আমাদের মধ্যে আছেন কি না? ");
INSERT INTO benirv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ঐ দিনের অমালেক এসে রফীদীমে ইস্রায়েলের সঙ্গে যুদ্ধ করতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","তাতে মোশি যিহোশূয়কে বললেন, “তুমি আমাদের জন্য লোক বেছে নাও, যাও, অমালেকের সঙ্গে যুদ্ধ করো; কাল আমি ঈশ্বরের লাঠি হাতে নিয়ে পর্বতে চূড়ায় দাঁড়াব।” ");
INSERT INTO benirv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","পরে যিহোশূয় মোশির আদেশ অনুসারে কাজ করলেন; অমালেকের সঙ্গে যুদ্ধ করলেন এবং মোশি, হারোণ ও হূর পর্বতের শৃঙ্গে উঠলেন। ");
INSERT INTO benirv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","আর এইরকম হল, মোশি যখন তাঁর হাত তুলে ধরেন, তখন ইস্রায়েল জয়ী হয়, কিন্তু মোশি তাঁর হাত নামালে অমালেক জয়ী হয়। ");
INSERT INTO benirv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","আর মোশির হাত ভারী হতে লাগল, তখন তাঁরা একটি পাথর এনে তাঁর নিচে রাখলেন, আর তিনি তাঁর উপরে বসলেন এবং হারোণ ও হূর একজন একদিকে ও অন্যজন অন্য দিকে তাঁর হাত ধরে রাখলেন, তাতে সূর্য্য না ডোবা পর্যন্ত তাঁর হাত স্থির থাকল। ");
INSERT INTO benirv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","আর যিহোশূয় অমালেককে ও তাঁর লোকেদেরকে তরোয়াল দিয়ে পরাজয় করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","পরে সদাপ্রভু মোশিকে বললেন, “এই কথা স্মরণে রাখার জন্য বইয়ে লেখ এবং যিহোশূয়ের কানের কাছে পড়ে শুনাও; কারণ আমি আকাশের নীচে থেকে অমালেকের স্মৃতি পুরোপুরি লোপ করব।” ");
INSERT INTO benirv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","পরে মোশি এক বেদি তৈরী করে তাঁর নাম যিহোবা-নিঃষি সদাপ্রভু আমার পতাকা রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","আর তিনি বললেন, “সদাপ্রভুর সিংহাসনের উপরে হাত উত্তোলিত হয়েছে; অমালোকির হস্ত সদাপ্রভুর উত্থানের বিরুদ্ধে উত্থিত হয়েছে।” ");
INSERT INTO benirv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","আর ঈশ্বর মোশির পক্ষে ও তাঁর প্রজা ইস্রায়েলের পক্ষে যে সমস্ত কাজ করেছেন, সদাপ্রভু ইস্রায়েলকে মিশর থেকে বের করে এনেছেন, এই সব কথা মোশির শ্বশুর মিদিয়নীয় যাজক যিথ্রো শুনতে পেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","তখন মোশির শ্বশুর যিথ্রো মোশির স্ত্রীকে, তার বাড়িতে পাঠানো সিপ্‌পোরাকে ও তাঁর দুই ছেলেকে সঙ্গে নিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ঐ দুই ছেলের মধ্যে এক জনের নাম গের্শোম তত্রপ্রবাসী, কারণ তিনি বলেছিলেন, আমি বিদেশের নিবাসী হয়েছি। ");
INSERT INTO benirv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","আর এক জনের নাম ইলীয়েষর ঈশ্বর-সহকারী, কারণ তিনি বলেছিলেন, আমার পিতার ঈশ্বর আমার সহকারী হয়ে ফরৌণের তরোয়াল থেকে আমাকে উদ্ধার করেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","মোশির শ্বশুর যিথ্রো তাঁর দুই ছেলে ও তার স্ত্রীকে সঙ্গে নিয়ে দূরে নির্জন জায়গায় মোশির কাছে, ঈশ্বরের পর্বতে যে জায়গায় তিনি শিবির স্থাপন করেছিলেন, সেই জায়গায় আসলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","আর তিনি মোশিকে বললেন, তোমার শ্বশুর যিথ্রো আমি এবং তোমার স্ত্রী ও তাঁর সঙ্গে তাঁর দুই ছেলে, আমরা তোমার কাছে এসেছি। ");
INSERT INTO benirv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","তখন মোশি নিজের শ্বশুরের সঙ্গে দেখা করতে বাইরে গেলেন ও প্রণাম করলেন ও তাঁকে চুম্বন করলেন এবং একে অপরের মঙ্গল জিজ্ঞাসা করলেন, পরে তারা তাঁবুর মধ্যে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","আর সদাপ্রভু ইস্রায়েলের জন্য ফরৌণের উপর ও মিশরীয়দের উপর যা যা করেছিলেন এবং পথে তাঁদের যে যে কষ্টের ঘটনা ঘটেছিল ও সদাপ্রভু যে ভাবে তাঁদেরকে উদ্ধার করেছিলেন, সেই সব ঘটনা মোশি নিজের শ্বশুরকে বললেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","তাতে সদাপ্রভু মিশরীয়দের হাত থেকে ইস্রায়েলকে উদ্ধার করে তাঁদের যে সব মঙ্গল করেছিলেন, তার জন্য যিথ্রো আনন্দিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","আর যিথ্রো বললেন, “ধন্য সদাপ্রভু, যিনি মিশরীয়দের হাত থেকে ও ফরৌণের হাত থেকে তোমাদেরকে উদ্ধার করেছেন, যিনি মিশরিয়দের হাতের নিয়ন্ত্রণ থেকে এই লোকদেরকে উদ্ধার করেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","এখন আমি জানি, সব দেবতা থেকে সদাপ্রভু মহান্‌; সেই বিষয়ে মহান্‌, যে বিষয়ে ওরা এদের বিরুদ্ধে গর্ব করত।” ");
INSERT INTO benirv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","পরে মোশির শ্বশুর যিথ্রো ঈশ্বরের উদ্দেশ্যে হোম উত্সর্গ ও বলি উপস্থিত করলেন এবং হারোণ ও ইস্রায়েলের সমস্ত প্রাচীনরা এসে ঈশ্বরের সামনে মোশির শ্বশুরের সঙ্গে খাবার খেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","পরদিন মোশি লোকদের বিচার করতে বসলেন, আর সকাল থেকে সন্ধ্যা পর্যন্ত লোকেরা মোশির চারিদিকে দাঁড়িয়ে থাকলো। ");
INSERT INTO benirv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","তখন লোকদেরকে মোশি যা যা করছেন, তাঁর শ্বশুর তা দেখে বললেন, “তুমি লোকদের উপর এ কেমন ব্যবহার করছ? কেন তুমি একা বসে থাক, আর সমস্ত লোক সকাল থেকে সন্ধ্যা পর্যন্ত তোমার কাছে দাঁড়িয়ে থাকে?” ");
INSERT INTO benirv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","মোশি নিজের শ্বশুরকে বললেন, “লোকেরা ঈশ্বরের নির্দেশ বিষয়ে জিজ্ঞাসা করতে আমার কাছে আসে; ");
INSERT INTO benirv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","যখন তাঁদের মধ্যে কোন তর্ক বিতর্ক হয় তখন তারা আমার কাছে আসে; আমি একজন এবং অন্য জনের মধ্যে বিচার করি এবং ঈশ্বরের নিয়ম ও ব্যবস্থা সম্পর্কে তাঁদেরকে শিক্ষা দিই।” ");
INSERT INTO benirv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","তখন মোশির শ্বশুর তাঁকে বললেন, “তুমি যে কাজ করছ তা ভাল নয়। ");
INSERT INTO benirv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","এতে তুমি এবং তোমার সঙ্গী এই লোকেরাও দুর্বল হবে, কারণ এ কাজ তোমার জন্য খুবই ভারী এবং গুরুতর; তুমি একা নিজে এই কাজ সম্পন্ন করতে পারবে না। ");
INSERT INTO benirv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","এখন আমার কথা শোন; আমি তোমাকে পরামর্শ দিই, আর ঈশ্বর তোমার সহবর্ত্তী হোন; তুমি ঈশ্বরের সামনে লোকদের প্রতিনিধি হও এবং তাঁদের বিচার ঈশ্বরের কাছে নিয়ে আস, ");
INSERT INTO benirv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","আর তুমি অবশ্যই তাঁদেরকে নিয়ম ও ব্যবস্থার শিক্ষা দেবে এবং তাঁদের যাওয়ার পথ ও কি কাজ করতে হবে তা অবশ্যই দেখাবে। ");
INSERT INTO benirv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","এছাড়া তুমি এই লোকদের মধ্য থেকে কাজে দক্ষ লোকদের, যারা ঈশ্বরকে ভয় পায়, সত্যবাদী লোক যারা অন্যায় উপায়ে লাভকে ঘৃণা করে এমন লোকদের মনোনীত করে লোকদের ওপরে সহস্রপতি, শতপতি, পঞ্চাশৎপতি ও দশপতি করে অবশ্যই নিযুক্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","তারা সব দিন লোকদের বিচার করবেন; বড় বড় বিচারগুলি তোমার কাছে নিয়ে আসবেন, কিন্তু ছোট বিচারগুলি তাঁরাই করবেন; তাতে তোমার কাজ সহজ হবে, আর তাঁরা তোমরা সঙ্গে ভার বইবেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","যদি তুমি এরকম কর এবং ঈশ্বর যদি তোমাকে এইরকম আজ্ঞা দেন, তবে তুমি সহ্য করতে পারবে এবং এই সব লোকেরাও শান্তিতে নিজেদের জায়গায় যেতে পারবে।” ");
INSERT INTO benirv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","তাতে মোশি নিজের শ্বশুরের কথা শুনলেন এবং তিনি যা কিছু বললেন, সেই অনুসারে সব কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","কাজেই মোশি সমস্ত ইস্রায়েল থেকে কাজে দক্ষ এমন পুরুষদের মনোনীত করে লোকদের ওপরে প্রধান, অর্থাৎ সহস্রপতি, শতপতি, পঞ্চাশৎপতি ও দশপতি করে নিযুক্ত করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","তারা সব দিন লোকদের সাধারণ বিচারগুলি করতেন; আর কঠিন বিচারগুলি মোশির কাছে নিয়ে আসতেন, কিন্তু ক্ষুদ্র বিচারগুলি নিজেরাই করতেন। ");
INSERT INTO benirv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","পরে মোশি নিজের শ্বশুরকে বিদায় করলে তিনি নিজের দেশে ফিরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","তৃতীয় মাসে মিশর দেশ থেকে ইস্রায়েল সন্তানরা বের হয়ে যাবার পর, সেই প্রথম দিনের ই তারা সীনয়ের মরুপ্রান্তে উপস্থিত হল। ");
INSERT INTO benirv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","তাঁরা রফীদীম থেকে যাত্রা করে সীনয়ের নির্জন মরুঅঞ্চলে উপস্থিত হলে সেই জায়গায় তারা শিবির তৈরী করল। ");
INSERT INTO benirv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","পরে মোশি ঈশ্বরের কাছে গেলেন, আর সদাপ্রভু পর্বত থেকে তাঁকে ডেকে বললেন, “তুমি যাকোবের বংশকে এবং ইস্রায়েল সন্তানদের এই কথা জানাও, ");
INSERT INTO benirv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘আমি মিশরীয়দের প্রতি যা করেছি এবং যেমন ভাবে ঈগল পাখীর ডানা দিয়ে বহন করেছি এবং আমার কাছে নিয়ে এসেছি, তা তোমরা দেখেছ। ");
INSERT INTO benirv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","এখন যদি তোমরা আমার রব শোন এবং আমার নিয়মগুলি মেনে চলো, তবে তোমরা সব জাতির থেকে আমার নিজস্ব অধিকার হবে, কারণ পৃথিবীর সব কিছুই আমার; ");
INSERT INTO benirv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","আর আমার জন্য তোমরা যাজকদের এক রাজ্য এবং এক পবিত্র জাতি হবে।’ এই সব কথা গুলি তুমি অবশ্যই ইস্রায়েল সন্তানদের বলবে।” ");
INSERT INTO benirv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","তখন মোশি আসলেন এবং লোকদের প্রাচীনদেরকে ডাকলেন ও সদাপ্রভু তাঁকে যা যা আদেশ করলেন, সেই সব কথা তাঁদের সামনে উপস্থিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","তাতে লোকেরা সবাই একত্রে উত্তর দিয়ে বলল, সদাপ্রভু যা কিছু বলেছেন, আমরা সবই করব। তখন মোশি সদাপ্রভুর কাছে লোকদের বিষয়ে আবেদন করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","সদাপ্রভু মোশিকে বললেন, “দেখ, আমি ঘন মেঘে তোমার কাছে আসব, যখন তোমার সঙ্গে আমি কথা বলব লোকেরা যেন শুনতে পায় এবং তোমাতেও সর্বদা বিশ্বাস করে।” তখন মোশি লোকদের কথা সদাপ্রভুকে বললেন। ");
INSERT INTO benirv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","সদাপ্রভু মোশিকে বললেন, তুমি লোকদের কাছে গিয়ে আজ ও কাল তাঁদেরকে পবিত্র কর, (আমার আসার জন্য তাদের তৈরী কর) এবং তাঁরা নিজের নিজের কাপড় পরিষ্কার করুক, ");
INSERT INTO benirv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","আর তৃতীয় দিনের র জন্য সবাই তৈরী থাকুক; কারণ তিন দিনের র দিনের আমি সদাপ্রভু, সব লোকের সামনে সীনয় পর্বতের উপরে নেমে আসবেন। ");
INSERT INTO benirv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","আর তুমি লোকদের জন্য চারদিকে সীমানা তৈরী করে তাদের এই কথা বলো, “তোমরা সাবধান থাক যে, তোমরা পর্বতে যাবে না এবং তাঁর সীমানা স্পর্শ করো না; যে কেউ পর্বত স্পর্শ করবে তাঁর মৃত্যুদণ্ড অবশ্যই হবে। ");
INSERT INTO benirv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","কারও হাত তাকে স্পর্শ করবে না, কিন্তু সে অবশ্য পাথরের আঘাতে মারা যাবে, কিংবা তীর দিয়ে বিদ্ধ হবে; পশু হোক বা মানুষ হোক, সে বাঁচবে না। যখন বেশীক্ষণ তূরীবাদ্য হবে তাঁরা হয়তো পায়ে হেঁটে পর্বতে উঠবে।” ");
INSERT INTO benirv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","পরে মোশি পর্বত থেকে নেমে লোকদের কাছে এসে লোকদেরকে পবিত্র করলেন এবং তাঁরা নিজের নিজের কাপড় পরিষ্কার করল। ");
INSERT INTO benirv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","পরে তিনি লোকদেরকে বললেন, “তোমরা তৃতীয় দিনের র জন্য তৈরী হও; তোমার স্ত্রীর কাছে যেও না।” ");
INSERT INTO benirv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","পরে তৃতীয় দিনের সকাল হলে মেঘগর্জন ও বিদ্যুৎ এবং পর্বতের উপরে ঘন মেঘ জমলো, আর খুব জোরে তূরীধ্বনি হতে লাগল; তাতে শিবিরের সমস্ত লোক কাঁপতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","পরে মোশি ঈশ্বরের সঙ্গে দেখা করার জন্য লোকদেরকে শিবির থেকে বের করে দিলেন, আর তারা পর্বতের নিচে দাঁড়িয়ে থাকলো। ");
INSERT INTO benirv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","সীনয় পর্বত সম্পূর্ণ ভাবে ধোঁয়ায় ঢেকে গেল, কারণ সদাপ্রভু আগুন এবং ধোঁয়ার সঙ্গে তার উপরে নেমে আসলেন, আর ভাঁটার ধোঁয়ার মত তা থেকে ধোঁয়া উঠতে লাগল এবং সমস্ত পর্বত খুব কাঁপতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","আর তূরীর শব্দ ক্রমাগত খুব বাড়তে লাগল; তখন মোশি কথা বললেন এবং ঈশ্বর বাণীর মাধ্যমে তাঁকে উত্তর দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","আর সদাপ্রভু সীনয় পর্বতে, পর্বতের চূড়ায়, নেমে আসলেন এবং সদাপ্রভু মোশিকে সেই পর্বতের চূড়ায় ডাকলেন; তাতে মোশি উঠে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","তখন সদাপ্রভু মোশিকে বললেন, “তুমি নেমে গিয়ে লোকেদেরকে সতর্ক কর, পাছে তারা দেখার জন্য সীমানা লঙ্ঘন করে সদাপ্রভুর দিকে যায় ও তাদের অনেকে বিনষ্ট হয়। ");
INSERT INTO benirv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","আর যাজকরা, যারা সদাপ্রভুর কাছাকাছি থাকে, তারাও নিজেদেরকে পবিত্র করুক, না হলে সদাপ্রভু তাদেরকে আঘাত করেন।” ");
INSERT INTO benirv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","তখন মোশি সদাপ্রভুকে বললেন, “লোকেরা সীনয় পর্বতে উঠে আসতে পারে না, কারণ তুমি দৃঢ় ভাবে আদেশ দিয়ে তাদেরকে বলেছ, পর্বতের সীমানা নির্ধারণ কর ও তা পবিত্র কর।” ");
INSERT INTO benirv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","আর সদাপ্রভু তাঁকে বললেন, “যাও, পর্বত থেকে নেমে যাও; পরে হারোণকে সঙ্গে নিয়ে তুমি উঠে এসো, কিন্তু যাজকরা ও লোকেরা সদাপ্রভুর কাছে উঠে আসার জন্য সীমানা লঙ্ঘন না করুক, না হলে তিনি তাদেরকে আঘাত করেন।” ");
INSERT INTO benirv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","তখন মোশি লোকেদের কাছে নেমে গিয়ে তাদেরকে এই সব কথা বললেন। ");
INSERT INTO benirv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ঈশ্বর এই সব কথা বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","আমি তোমার ঈশ্বর সদাপ্রভু, যিনি মিশর দেশ থেকে, দাসত্বের ঘর থেকে তোমাকে বের করে আনলেন। ");
INSERT INTO benirv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","আমার সাক্ষাৎে তোমার অন্য দেবতা না থাকুক। ");
INSERT INTO benirv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","তুমি আমার জন্য ক্ষোদিত প্রতিমা তৈরী কোরো না; উপরের স্বর্গে, নীচের পৃথিবীতে ও পৃথিবীর নীচে জলের মধ্যে যা যা আছে, তাদের কোনো মূর্ত্তি তৈরী কোরো না, ");
INSERT INTO benirv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","তুমি তাদের কাছে প্রণাম কোরো না এবং তাদের সেবা কোরো না; কারণ আমি সদাপ্রভু তোমার ঈশ্বর, আমি ঈর্ষাপরায়ণ ঈশ্বর; আমি পূর্বপুরুষদের অপরাধের শাস্তি সন্তানদের উপরে দিই, যারা আমাকে ঘৃণা করে, তাদের তৃতীয় চতুর্থ পুরুষ পর্যন্ত দিই; ");
INSERT INTO benirv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","কিন্তু যারা আমাকে ভালবাসে ও আমার সমস্ত আদেশ পালন করে, আমি তাদের হাজার পুরুষ পর্যন্ত দয়া করি। ");
INSERT INTO benirv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","তোমার ঈশ্বর সদাপ্রভুর নাম বিনা কারণে নিও না, কারণ যে তাঁর নাম বিনা কারণে নেবে, সদাপ্রভু তাঁকে নির্দোষ হিসাবে ধরবেন না। ");
INSERT INTO benirv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","তুমি আমার জন্য বিশ্রামবার পবিত্র রাখতে তা স্মরণ কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ছদিন কাজ কোরো, নিজের সমস্ত কাজ কোরো; ");
INSERT INTO benirv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","কিন্তু সপ্তম দিন তোমার ঈশ্বর সদাপ্রভুর উদ্দেশ্যে বিশ্রামদিন; সে দিন তুমি কি তোমার ছেলে কি মেয়ে, কি তোমার দাস কি দাসী, কি তোমার পশু, কি তোমার ফটকের কাছে থাকা বিদেশী, কেউ কোনো কাজ কোরো না; ");
INSERT INTO benirv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","কারণ আমি, সদাপ্রভু, আকাশমণ্ডল ও পৃথিবী, সমুদ্র ও সেই সবের মধ্যে সব জিনিস ছয় দিনের তৈরী করে সপ্তম দিনের বিশ্রাম করেছি; সেইজন্য আমি, সদাপ্রভু, বিশ্রামদিন কে আশীর্বাদ করলাম এবং পবিত্র করে নিজের জন্য সংরক্ষণ করলাম। ");
INSERT INTO benirv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","তোমার বাবাকে ও তোমার মাকে সম্মান কোরো, যেন তোমার ঈশ্বর সদাপ্রভু তোমাকে যে দেশ দেবেন, সেই দেশে তুমি দীর্ঘদিন বাস করতে পারো। ");
INSERT INTO benirv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","তোমরা নরহত্যা করো না। ");
INSERT INTO benirv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","তোমরা কারও সঙ্গে ব্যভিচার কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","তোমরা কারও থেকে কিছু চুরি কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","তোমরা তোমার প্রতিবেশীর বিরুদ্ধে মিথ্যা সাক্ষ্য দিও না। ");
INSERT INTO benirv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","তোমার প্রতিবেশীর বাড়িতে তোমরা লোভ কোরো না; প্রতিবেশীর স্ত্রীতে, কিম্বা তার দাসে কি দাসীতে, অথবা তাঁর গরুতে কি গাধাতে, প্রতিবেশীর কোনো জিনিসেই লোভ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","তখন সব লোক মেঘগর্জ্জন, বিদ্যুৎ, তূরীধ্বনি ও ধোঁয়ায় পরিপূর্ণ পর্বত দেখল; যখন লোকেরা সেটি দেখল, তারা ভীত হল এবং দূরে দাঁড়িয়ে থাকলো। ");
INSERT INTO benirv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","আর তারা মোশিকে বলল, “তুমিই আমাদের সঙ্গে কথা বল, আমরা শুনব; কিন্তু ঈশ্বর আমাদের সঙ্গে যেন কথা না বলেন, না হলে আমরা মারা যাবো।” ");
INSERT INTO benirv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","মোশি লোকদেরকে বললেন, “ভয় কোরো না; কারণ তোমাদের পরীক্ষার জন্য এবং তোমরা যেন পাপ না কর, এই জন্য নিজের ভয়ানকতা তোমাদের চক্ষুগোচর করার জন্য ঈশ্বর এসেছেন।” ");
INSERT INTO benirv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","তখন লোকেরা দূরে দাঁড়িয়ে থাকলো; আর মোশি ঘন অন্ধকারের কাছে চলে গেলেন, যেখানে ঈশ্বর ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","পরে সদাপ্রভু মোশিকে বললেন, “তুমি ইস্রায়েল সন্তানদের এই কথা গুলি অবশ্যই বলবে, তোমরা নিজেরাই দেখলে যে, আমি স্বর্গ থেকে তোমাদের সঙ্গে কথা বললাম। ");
INSERT INTO benirv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","তোমরা আমার পাশাপাশি অন্য দেবতা তৈরী কর না; নিজেদের জন্য রূপার দেবতা কি সোনা দিয়ে দেবতা তৈরী কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","তুমি আমার জন্যে মাটি দিয়ে এক বেদি তৈরী করবে এবং তার উপরে তোমার হোমবলি ও মঙ্গলের জন্য বলি, তোমার ভেড়া ও তোমার গরু উৎসর্গ করবে। আমি যে যে জায়গায় আমার নাম মনে করাব, সে জায়গায় তোমার কাছে এসে তোমাকে আশীর্বাদ করব। ");
INSERT INTO benirv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","তুমি যদি আমার জন্য পাথর দিয়ে বেদি তৈরী কর, তবে খোদাই করা পাথরে তা তৈরী কোরো না, কারণ তার উপরে অস্ত্র তুললে তুমি তা অপবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","আর আমার বেদির উপরে সিঁড়ি দিয়ে উঠ না, না হলে তার উপরে তোমার উলঙ্গতা অনাবৃত হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","এখন তুমি এই সব শাসন তাদের সামনে অবশ্যই রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","তুমি ইব্রীয় দাস কেন, সে ছয় বছর দাসত্ব করবে এবং পরে সপ্তম বছরে মূল্য ছাড়াই মুক্ত হয়ে চলে যাবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","যদি সে নিজে নিজেই আসে, তবে সে অবশ্যই নিজে মুক্ত হয়ে যাবে; যদি সে স্ত্রীর সঙ্গে আসে, তবে তার স্ত্রীও তার সঙ্গে মুক্ত হয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","যদি তার প্রভু তাহার বিয়ে দেয় এবং সেই স্ত্রী তার জন্য ছেলে কি কন্যা জন্ম দেয়, তবে সেই স্ত্রীতে ও তার সন্তানদের মধ্যে তার প্রভুর স্বত্ব থাকবে এবং সে নিজে নিজেই চলে যাবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","কিন্তু ঐ দাস যদি স্পষ্টরূপে বলে, “আমি আমার প্রভুকে এবং নিজের স্ত্রী ও সন্তানদের ভালবাসি, মুক্ত হয়ে চলে যাব না,” ");
INSERT INTO benirv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","তাহলে তার প্রভু অবশ্যই তাকে ঈশ্বরের কাছে নিয়ে যাবে এবং সে তাকে দরজার কিম্বা দরজার চৌকাঠের কাছে উপস্থিত করবে, সেখানে তার প্রভু পেরেক মাধ্যমে তার কান বিদ্ধ করবে; তখন সে জীবনের বাকি দিন গুলিতে সেই প্রভুর দাস থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","আর যদি কেউ নিজের মেয়েকে দাসীরূপে বিক্রি করে, তবে দাসেরা যেমন যায়, সে সেরকম যাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","তার প্রভু তাকে নিজের জন্য নিরূপণ করলেও যদি তার প্রতি অসন্তুষ্ট হয়, তবে সে তাকে মুক্ত হতে দেবে; তার সঙ্গে প্রবঞ্চনা করাতে অন্য বিদেশী লোকের কাছে তাকে বিক্রি করবার অধিকার তার হবে না। ");
INSERT INTO benirv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","আর যদি সে নিজের ছেলের জন্য তাকে নিরূপণ করে, তবে সে তার প্রতি মেয়েদের সম্পর্কে নিয়ম অনুযায়ী ব্যবহার করবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","যদি সে অন্য স্ত্রীর সঙ্গে তার বিয়ে দেয়, তবে তার খাবারের ও পোশাকের এবং তার বিয়ের অধিকারের বিষয়ে ত্রুটি করতে পারবে না। ");
INSERT INTO benirv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","আর যদি সে তার প্রতি এই তিনটি কর্তব্য না করে, তবে সেই স্ত্রী অমনি মুক্ত হয়ে চলে যাবে; রূপা লাগবে না। ");
INSERT INTO benirv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","কেউ যদি কোনো মানুষকে এমন আঘাত করে যে, তার মৃত্যু হয়, তবে অবশ্যই তার মৃত্যুদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","কিন্তু যদি কেউ আগে থেকে সিদ্ধান্ত না নিয়ে হত্যা করে থাকে, অথচ দুর্ঘটনাবশতঃ তাই ঘটে, তাহলে আমি তার জন্য একটি স্থান নির্ধারণ করব, যেখানে সে পালিয়ে যেতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","কিন্তু যদি কেউ ইচ্ছাকৃত ভাবে ছলনা করে তার প্রতিবেশীকে হত্যা করার জন্য তাকে আক্রমণ করে, তবে সে ব্যক্তির মৃত্যুদণ্ড দেবার জন্য তাকে আমার বেদির কাছ থেকেও নিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","আর যে কেউ তার বাবাকে কি তার মাকে আঘাত করে, তার মৃত্যুদণ্ড অবশ্যই হবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","আর কেউ যদি মানুষকে চুরি করে বিক্রি করে দেয়, কিংবা তার হাতে যদি তাকে পাওয়া যায়, তবে তার মৃত্যুদণ্ড অবশ্যই হবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","আর কেউ যদি তার বাবাকে কি তার মাকে শাপ দেয়, তার মৃত্যুদণ্ড অবশ্যই হবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","আর মানুষেরা বিবাদ করে একজন অন্যকে পাথরের আঘাত কিংবা হাত দিয়ে আঘাত করলে সে যদি মারা না গিয়ে শয্যাশায়ী হয়, ");
INSERT INTO benirv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","তখন যদি সে পরে উঠে হাঁটতে পারে এবং লাঠি নিয়ে ব্যবহার করতে পারে, তবে সেই ব্যক্তি যে তাকে মেরেছে সে তার ক্ষতি শোধ করবে। সেই ব্যক্তি অবশ্যই তার চিকিৎসার সব ব্যয় পরিশোধ করবে। কিন্তু সেই ব্যক্তি হত্যার জন্য অপরাধী হবে না। ");
INSERT INTO benirv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","আর যদি কেউ নিজের দাসকে অথবা দাসীকে লাঠি দিয়ে আঘাত করে এবং দাসেরা যদি তার আঘাতে মরে, তবে সে অবশ্যই শাস্তি পাবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","কিন্তু সেই দাস যদি দুই এক দিন বাঁচে, তবে তার মালিক শাস্তি পাবে না, তার দাসকে হারানোর জন্য কষ্ট পেতে হবে। কারণ সে তার রূপার সমান। ");
INSERT INTO benirv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","আর পুরুষেরা লড়াই করে কোনো গর্ভবতী স্ত্রীকে আঘাত করলে যদি তার গর্ভপাত হয়, কিন্তু পরে তার আর কোন বিপদ না ঘটে, তবে ঐ স্ত্রীর স্বামীর দাবী অনুযায়ী তার অর্থদণ্ড অবশ্যই হবে ও সে বিচারকর্তাদের বিচার অনুযায়ী টাকা দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","কিন্তু যদি কোন গুরুতর বিপদ ঘটে, তবে তোমাকে সেই জীবনের জন্য জীবন প্রতিশোধ দিতে হবে; ");
INSERT INTO benirv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","চোখের বদলে চোখ, দাঁতের বদলে দাঁত, হাতের বদলে হাত, পায়ের বদলে পা, ");
INSERT INTO benirv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","পোড়ার বদলে পোড়ানো, আঘাতের বদলে আঘাত, কালশিরার বদলে কালশিরা। ");
INSERT INTO benirv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","আর কেউ নিজের দাস কি দাসীর চোখে আঘাত করলে যদি তা নষ্ট হয়ে যায়, তবে তার চোখ নষ্ট হবার জন্য সে তাকে স্বাধীন করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","আর যদি আঘাত দিয়ে নিজের দাস অথবা দাসীর দাঁত ভেঙে ফেলে, তবে ঐ দাঁতের জন্য সে তাকে স্বাধীন করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","আর গরু কোনো পুরুষ কি স্ত্রীকে শিং দিয়ে আঘাত করলে সে যদি মরে, তবে ঐ গরু অবশ্যই পাথরের আঘাতে হত্যা হবে এবং তার মাংস খাওয়া হবে না; কিন্তু গরুর মালিক শাস্তি পাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","কিন্তু ঐ গরু যদি আগে শিং দিয়ে আঘাত করত, তার প্রমাণ পেলেও তার মালিক তাকে সাবধানে না রাখে এবং যদি সে কোনো পুরুষকে অথবা কোনো স্ত্রীকে হত্যা করে, তবে সে গরু পাথরের আঘাতে হত্যা হবে এবং তার মালিকেরও মৃত্যুদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","যদি তার জন্যে তাকে মূল্য দেওয়ার ধার্য্য হয়, তবে সে মুক্তির জন্য অবশ্যই সমস্ত মূল্য দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","তার গরু যদি কোনো ব্যক্তির ছেলেকে বা মেয়েকে শিং দিয়ে আঘাত করে, তবে ঐ একই বিচারনুযায়ী তার প্রতি করা যাবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","আর তার গরু যদি কোনো ব্যক্তির দাস বা দাসীকে শিং দিয়ে আঘাত করে, তবে গরুর মালিক তাদের মালিককে ত্রিশ শেকল রূপা দেবে এবং গরুটিকে পাথরের আঘাতে হত্যা করা হবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","আর কেউ যদি কোনো গর্ত খুলে রাখে, অথবা একজন ব্যক্তি কূপ খুঁড়ে তা না ঢেকে রাখে, তবে তার মধ্যে কোন গরু অথবা গাধা পড়লে, ");
INSERT INTO benirv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","সেই কূপের মালিক ক্ষতিপূরণ দেবে, সে পশুর মালিককে মূল্য হিসাবে রূপা দেবে, কিন্তু ঐ মৃত পশু তারই হবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","যদি এক জন লোকের গরু অন্য জন লোকের গরুকে শিং দিয়ে আঘাত করে এবং সেটা যদি মরে, তবে তারা জীবিত গরু বিক্রি করে তার মূল্য দুই ভাগ করবে এবং ঐ মৃত গরুটিও দুই ভাগ করে নেবে। ");
INSERT INTO benirv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","কিন্তু এটা যদি জানা যায় যে, সেই গরুটি আগে থেকে শিং দিয়ে আঘাত করত এবং তার মালিক তাকে সাবধানে রাখেনি, তবে সে গরুর পরিবর্ত্তে অন্য গরু দেবে, কিন্তু মৃত গরুটি তারই হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","যে কেউ গরু অথবা ভেড়া চুরি করে এবং হত্যা করে অথবা বিক্রি করে, সে একটি গরুর পরিবর্তে পাঁচটি গরু, ও একটি ভেড়ার পরিবর্তে চারটি ভেড়া দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","আর একটি চোর যদি সিঁধ কাটবার দিন ধরা পড়ে এবং যদি আহত হয় ও মরে যায়, তবে তার হত্যার জন্য কোনো দোষ হবে না। ");
INSERT INTO benirv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","কিন্তু যদি তার উপরে সূর্য্য উদয় হয়, তবে হত্যার দোষ তার হবে; ক্ষতিপূরণ করা চোরের কর্তব্য; যদি তার কিছু না থাকে, তবে চুরি করার কারণে সে বিক্রীত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","গরু, গাধা বা ভেড়া, চুরির কোনো পশু যদি চোরের হাতে জীবিত অবস্থায় পাওয়া যায়, তবে তাকে তার দ্বিগুন দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","কেউ যদি শস্যক্ষেত্রে অথবা আঙ্গুরক্ষেত্রে পশু চরায়, আর নিজের পশু ছেড়ে দিলে যদি তা অন্য লোকের ক্ষেত্রে চরে, তবে সেই ব্যক্তি নিজের ক্ষেত্রের ভালো শস্য অথবা নিজের আঙ্গুরক্ষেত্রের ভালো ফল দিয়ে ক্ষতিপূরণ দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","আগুন কাঁটাবনে লাগলে যদি কারও শস্যরাশি অথবা শস্যের ঝাড় অথবা বাগান পুড়ে যায়, তবে সেই যে আগুন লাগায় অবশ্য ক্ষতিপূরণ দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","কোনো ব্যক্তি টাকা অথবা জিনিসপত্র নিজের প্রতিবেশীর কাছে গচ্ছিত রাখলে যদি তার ঘর থেকে কেউ সেটা চুরি করে এবং সেই চোরটি ধরা পড়ে, তবে সেই চোরকে তার দ্বিগুন দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","কিন্তু যদি চোরটি না ধরা পড়ে, তবে সেই বাড়ির মালিক প্রতিবেশীর সম্পত্তিতে হাত দিয়েছে কিনা, তা জানবার জন্য তাকে বিচারকের সামনে বিচারের জন্য আসতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","সব প্রকার অপরাধের জন্য, অর্থাৎ গরু বা গাধা, ভেড়া, কাপড়, বা কোনো হারিয়ে যাওয়া জিনিসের বিষয়ে যদি কেউ বলে, এটি আমার জিনিস, তবে উভয় পক্ষের কথা বিচারকের কাছে নিয়ে আসতে হবে; বিচারক যাকে দোষী করবেন, তাকে নিজের প্রতিবেশীকে তার দ্বিগুন দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","যদি একজন ব্যক্তি নিজের গাধা, গরু, ভেড়া অথবা কোন পশু প্রতিবেশীর কাছে পালন করার জন্য রাখে এবং লোকের অজানায় সেই পশু মরে যায়, বা কোনো অঙ্গ ভেঙে যায় অথবা দূরে কোথাও নিয়ে যাওয়া হয়, ");
INSERT INTO benirv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","তবে আমি প্রতিবেশীর জিনিসে হাত দেয়নি, এই কথা বলে একজন অন্য জনের কাছে সদাপ্রভুর নামে শপথ করবে; আর পশুর মালিক সেই জিনিস গ্রহণ করবে এবং ঐ ব্যক্তিকে ক্ষতিপূরণ দিতে হবে না। ");
INSERT INTO benirv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","কিন্তু যদি তার কাছ থেকে সেটি চুরি হয়ে যায়, তবে সে তার মালিককে অবশ্যই ক্ষতিপূরণ দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","যদি একটি পশুকে টুকরো করা হয়, তবে সে প্রমাণের জন্য তা উপস্থিত করুক; সেই টুকরো করা পশুর জন্য সে ক্ষতিপূরণ দেবে না। ");
INSERT INTO benirv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","আর কেউ যদি নিজের প্রতিবেশীর পশু চেয়ে নেয়, ও তার মালিক তার সঙ্গে না থাকার দিনের পশুটির কোনো অঙ্গ ভেঙে যায় অথবা মরে যায়, তবে সেই অন্য ব্যক্তিকে অবশ্যই ক্ষতিপূরণ দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","যদি তার মালিক তার সঙ্গে থাকে, তবে তাকে ক্ষতিপূরণ দিতে হবে না; যদি তা ভাড়া করা পশু হয়, তবে তার ভাড়াতেই শোধ হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","আর যদি কেউ বাগদত্তা নয় এমন কুমারীকে ভুলিয়ে তার সঙ্গে শয়ন করে, তবে সে অবশ্যই মেয়েকে পণ দিয়ে তাকে বিয়ে করবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","যদি সেই ব্যক্তির সঙ্গে নিজের মেয়ের বিয়ে দিতে বাবা নিতান্তই রাজি না হয়, তবে কন্যার পণের ব্যবস্থানুযায়ী তাকে টাকা দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","তুমি জাদুকারীকে জীবিত রেখো না। ");
INSERT INTO benirv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","পশুর সঙ্গে যে যৌনকর্মে লিপ্ত সেই ব্যক্তিকে অবশ্যই মৃত্যুদণ্ড দেওয়া হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","যে ব্যক্তি সদাপ্রভুর ছাড়া অন্য কোনো দেবতার কাছে বলিদান করে, সে সম্পূর্ণভাবে বিনষ্ট হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","তুমি বিদেশীদের উপর কোনো অন্যায় কোরো না অথবা তার উপর নির্যাতন কোরো না, কারণ তোমরাও মিশর দেশে বিদেশী হয়ে ছিলে। ");
INSERT INTO benirv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","তোমরা কোন বিধবাকে অথবা বাবা নেই এমন শিশুকে দুঃখ দিও না। ");
INSERT INTO benirv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","তাদেরকে কোন ভাবে দুঃখ দিলে যদি তারা আমার কাছে কাঁদে, তবে আমি সদাপ্রভু অবশ্যই তাদের কান্না শুনব; ");
INSERT INTO benirv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","আর আমার ক্রোধ জ্বলে উঠবে এবং আমি তোমাদেরকে তরোয়াল দিয়ে হত্যা করব, তাতে তোমাদের স্ত্রীরা বিধবা হবে এবং তোমাদের সন্তানেরা পিতাহীন হবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","যদি তুমি আমার লোকদের মধ্যে তোমাদের নিজের জাতির মধ্যে এমন কাউকে টাকা ধার দাও, তবে তার কাছে তোমরা সুদ গ্রহীতার মতো হয়ো না অথবা তোমরা তার উপরে সুদ চাপিয়ে দিয়ো না। ");
INSERT INTO benirv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","যদি তুমি নিজের প্রতিবেশীর পোষাক বন্ধক রাখ, তবে সুর্য্য অস্ত যাওয়ার আগে তা ফিরিয়ে দিও; কারণ তা তার একমাত্র আচ্ছাদন, ");
INSERT INTO benirv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","এটা তার গায়ের একমাত্র পোষাক; সে আর কিসের উপর শোবে? আর যখন সে আমার কাছে কাঁদবে, আমি তার কান্না শুনব, কারণ আমি দয়ালু। ");
INSERT INTO benirv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","তুমি আমাকে অর্থাৎ ঈশ্বরকে ধিক্কার দেবে না এবং তোমার লোকদের অধ্যক্ষকে অভিশাপ দিও না। ");
INSERT INTO benirv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","তোমার পাকা ফসল ও দ্রাক্ষারস অর্পণ করতে দেরী কোরো না। তোমার প্রথমজাত পুত্রদের অবশ্যই আমাকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","তোমার গরু ও ভেড়া সমন্ধেও সেইরূপ কোরো; কারণ তা সাত দিন নিজের মায়ের সঙ্গে থাকবে, কিন্তু আট দিনের র দিন তুমি তা আমাকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","আর তোমরা আমার জন্য পবিত্র লোক হবে; সুতরাং ক্ষেত্রে পড়ে থাকা কোনো বিদীর্ণ মাংস খাবে না; পরিবর্তে তা কুকুরের কাছে ছুঁড়ে ফেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","তুমি কারও বিরুদ্ধে মিথ্যা সাক্ষী দিও না; অসৎ সাক্ষী হয়ে দুষ্টু লোকের সাহায্য কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","তুমি খারাপ কাজ করতে জনতার অনুসরণকারী হয়ো না এবং বিচারে অন্যায় করার জন্য জনতার পক্ষ হয়ে প্রতিবাদ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","তুমি গরিবদের বিচারের দিনের তার পক্ষপাত করিও না। ");
INSERT INTO benirv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","যদি তোমার শত্রুর গরু অথবা গাধাকে অন্য পথে যেতে দেখ তবে তুমি অবশ্যই তার কাছে তাকে নিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","যদি তুমি যে তোমাকে ঘৃণা করে তার গাধাকে ভারের নীচে পড়ে যেতে দেখ, তাকে ভার মুক্ত করতে ইচ্ছা না হয়, তা সত্বেও তুমি অবশ্যই তার গাধার সঙ্গে তাকে সাহায্য করবে। ");
INSERT INTO benirv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","গরিব প্রতিবেশীর বিচারে তার প্রতি অন্যায় কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","মিথ্যা বিষয়ে দোষারোপ করতে অন্যদের সঙ্গে যোগ দিও না এবং নির্দোষ অথবা ধার্ম্মিককে হত্যা কোরো না, কারণ আমি দুষ্ট লোককে নির্দোষ করব না। ");
INSERT INTO benirv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","আর তুমি ঘুষ নিও না, কারণ ঘুষ যারা দেখতে পায় তাদের অন্ধ করে দেয় এবং ধার্মিক লোকদের কথা গুলি বিপথে নিয়ে যায়। ");
INSERT INTO benirv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","আর তুমি বিদেশীদের উপর নির্যাতন কোরো না; যেহেতু তোমরা বিদেশীদের হৃদয় জান, কারণ তোমরাও মিশর দেশে বিদেশী হয়ে ছিলে। ");
INSERT INTO benirv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","তুমি নিজের মাটিতে ছয় বছর ধরে বীজ বপন কোরো এবং উৎপন্ন শস্য সংগ্রহ কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","কিন্তু সপ্তম বছরে তাকে বিশ্রাম দিও, ফেলে রেখো; তাতে তোমাদের মধ্যে দরিদ্ররা খেতে পাবে, আর তারা যা অবশিষ্ট রাখে, তা বনের পশুরা খাবে এবং তোমার আঙ্গুর ক্ষেতের ও জিতগাছের বিষয়েও সেইরূপ কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","তুমি ছয় দিন ধরে নিজের কাজ কোরো, কিন্তু সপ্তম দিনের তুমি অবশ্যই বিশ্রাম কোরো; যেন তোমার গরু ও গাধা বিশ্রাম পায় এবং তোমার দাসীর ছেলে ও বিদেশীরা বিশ্রাম নিতে পারে ও প্রাণ জুড়াতে পারে। ");
INSERT INTO benirv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","আমি তোমাদেরকে যা যা বললাম তার সকল বিষয়ে সাবধান থেকো; অন্য দেবতাদের নাম উল্লেখ কোরো না, তোমাদের মুখ থেকে যেন তাদের নাম শোনা না যায়। ");
INSERT INTO benirv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","তুমি বছরে তিন বার আমার জন্য উৎসব করার উদ্দেশ্যে যাত্রা কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","তুমি খামির বিহীন রুটির উৎসব পালন কোরো; যেমন আমি তোমাকে আজ্ঞা দিয়েছি, সাত দিন খামির বিহীন রুটি ভোজন কোরো, সেই নির্ধারিত দিনের, আবীব মাসে তুমি আমার সামনে উপস্থিত হবে, কারণ এই মাসে তুমি মিশর দেশ থেকে বের হয়ে এসেছিলে। কিন্তু তুমি খালি হাতে আমার কাছে আসবে না। ");
INSERT INTO benirv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","আর তুমি শস্য ছেদনের উৎসব, অর্থাৎ তোমার পরিশ্রমে ক্ষেত্রে যা যা বুনেছ, তার প্রথম ফলের উৎসব পালন কোরো। আর বৎসরের শেষে ক্ষেত্র থেকে ফল সংগ্রহ করার দিনের ফল সঞ্চয়ের উৎসব পালন কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","বছরে তিন বার তোমার সব পুরুষেরা প্রভু সদাপ্রভুর সামনে অবশ্যই উপস্থিত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","তুমি বলির রক্ত খামিরযুক্ত জিনিসের সঙ্গে আমাকে উত্সর্গ কোরো না; আর আমার উৎসব সম্পর্কীয় মেদ সমস্ত রাত্রি থেকে সকাল পর্যন্ত না থাকুক। ");
INSERT INTO benirv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","তোমার জমির প্রথম ফলের অগ্রিমাংশ তোমার ঈশ্বর সদাপ্রভুর ঘরে এনো। আর তোমরা ছাগল ছানাকে তার মায়ের দুধের সঙ্গে রান্না কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","দেখ, পথের মধ্যে তোমাকে রক্ষা করতে এবং আমি যে জায়গা প্রস্তুত করেছি, সেই জায়গায় তোমাকে নিয়ে যেতে তোমার আগে আগে এক দূত আমি পাঠিয়ে দিয়েছি। ");
INSERT INTO benirv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","তাঁর প্রতি সাবধান থেকো এবং তাঁর রবে মান্য কোরো, তাঁর অসন্তোষ জন্মাইও না; কারণ তিনি তোমাদের অধর্ম্ম সকল ক্ষমা করবেন না; কারণ তাঁর হৃদয়ে আমার নাম রয়েছে। ");
INSERT INTO benirv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","কিন্তু যদি তুমি নিশ্চই তাঁর রবে মান্য কর এবং আমি যা যা বলি সে সমস্ত কর, তবে আমি তোমার শত্রুদের শত্রু হব এবং তোমার প্রতিদ্বন্দীদের প্রতিদ্বন্দী হব। ");
INSERT INTO benirv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","কারণ আমার দূত তোমার আগে আগে যাবেন এবং ইমোরীয়, হিত্তীয়, পরিষীয়, কনানীয়, হিব্বীয় ও যিবূষীয়ের দেশে তোমাকে নিয়ে যাবেন; আর আমি তাদেরকে ধ্বংস করব। ");
INSERT INTO benirv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","তুমি তাদের দেবতাদের কাছে মাথা নিচু করে প্রণাম কোরো না ও তারা যা করে তা কোরো না; কিন্তু তাদেরকে পুরোপুরিভাবে ছুঁড়ে ফেলে দিও এবং তাদের পাথরের স্তম্ভগুলি ভেঙে ফেলো। ");
INSERT INTO benirv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","তোমরা নিজেদের ঈশ্বর সদাপ্রভুর অর্থাৎ আমাকে সেবা কোরো; যদি তোমরা তা কর, তাতে আমি তোমার রুটি ও জলে আশীর্বাদ করব এবং আমি তোমার মধ্য থেকে রোগ দূর করব। ");
INSERT INTO benirv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","তোমার দেশে কারও গর্ভপাত হবে না এবং কেউ বন্ধ্যা হবে না; আমি তোমার আয়ূর পরিমাণ বেশী করব। ");
INSERT INTO benirv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","আমি তোমার আগে আগে আমার বিষয়ে ভয় দেব এবং তুমি যে সব জাতির কাছে যাবে তাদেরকে আঘাত করব ও তোমার শত্রুদেরকে তোমার থেকে ফিরিয়ে দেব। ");
INSERT INTO benirv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","আর আমি তোমার আগে আগে ভীমরুল পাঠাব; যারা হিব্বীয়, কনানীয় ও হিত্তীয়কে তোমার সামনে থেকে বের করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","কিন্তু দেশ যেন ধ্বংসের জায়গা না হয় ও তোমার বিরুদ্ধে বন্য পশুর সংখ্যা যেন বেশী না হয়, এই জন্য আমি এক বৎসরে তোমার সামনে থেকে তাদেরকে তাড়িয়ে দেব না। ");
INSERT INTO benirv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","পরিবর্তে, তুমি যে পর্যন্ত এগিয়ে গিয়ে দেশ অধিকার না কর, ততক্ষণ তোমার সামনে থেকে তাদেরকে আস্তে আস্তে তাড়িয়ে দেব। ");
INSERT INTO benirv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","আর সূফসাগর থেকে ফরাৎ নদী পর্যন্ত এবং মরুভূমি থেকে ইউফ্রেটিস নদী পর্যন্ত তোমার সীমানা নির্ধারণ করব; কারণ আমি সেই দেশের বসবাসকারীদের তোমার হাতে সমর্পণ করব এবং তুমি তোমার সামনে থেকে তাদেরকে তাড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","তাদের সঙ্গে অথবা তাদের দেবতাদের সঙ্গে কোনো নিয়ম ঠিক করবে না। ");
INSERT INTO benirv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","তারা তোমার দেশে বাস করবে না, না হলে তারা আমার বিরুদ্ধে তোমাকে পাপ করাবে; কারণ যদি তুমি তাদের দেবতাদের সেবা কর, তবে তা অবশ্য তোমার জন্য ফাঁদের মত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","তখন সদাপ্রভু মোশিকে বললেন, তুমি, হারোণ, নাদব, অবীহূ এবং ইস্রায়েলের প্রাচীনবর্গের সত্তর জন, “তোমরা আমার কাছে এসো এবং দূর থেকে আমাকে প্রণাম কর। ");
INSERT INTO benirv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","কেবল মোশি সদাপ্রভুর কাছে আসতে পারে, কিন্তু অন্যরা কাছে আসবে না; আর লোকেরা তার সঙ্গে উপরে উঠবে না।” ");
INSERT INTO benirv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","তখন মোশি এসে লোকদেরকে সদাপ্রভুর সব বাক্য ও সব শাসনের কথা বললেন, তাতে সব লোক একসঙ্গে উত্তর দিয়ে বলল, “সদাপ্রভু যে যে কথা বললেন, আমরা সবই পালন করব।” ");
INSERT INTO benirv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","পরে মোশি সদাপ্রভুর সব বাক্য লিখলেন এবং সকালে উঠে পর্বতের তলে এক যজ্ঞবেদি ও ইস্রায়েলের বারোটি বংশানুসারে বারোটি স্তম্ভ তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","আর তিনি ইস্রায়েল সন্তানদের যুবকদেরকে পাঠালেন তারা সদাপ্রভুর উদ্দেশ্যে হোমের জন্য ও মঙ্গলের জন্য বলিরূপে ষাঁড়দেরকে বলিদান করল। ");
INSERT INTO benirv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","তখন মোশি তার অর্ধেক রক্ত নিয়ে থালায় রাখলেন এবং অর্ধেক রক্ত বেদির উপরে ছিটিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","আর তিনি নিয়ম বইটি নিয়ে লোকদের কাছে উচ্চস্বরে পড়লেন; তাতে তারা বলল, “সদাপ্রভু যা যা বললেন, আমরা সবই পালন করব ও বাধ্য হব।” ");
INSERT INTO benirv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","পরে মোশি সেই রক্ত নিয়ে লোকদের উপরে ছিটিয়ে দিয়ে বললেন, দেখ, এই হলো নিয়মের রক্ত, যা সদাপ্রভু তোমাদের সঙ্গে এই সব বাক্য সম্বন্ধে স্থির করেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","তখন মোশি ও হারোণ, নাদব, ও অবীহূ এবং ইস্রায়েলের প্রাচীনদের মধ্য থেকে সত্তর জন পর্বতে চলে গেলেন; ");
INSERT INTO benirv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","আর তারা ইস্রায়েলের ঈশ্বরকে দেখলেন; তাঁর চরণতলের জায়গা নীলকান্তমণি দিয়ে তৈরী শিলাস্তরের কার্য্য এবং আকাশের মতই নির্মল ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","আর ঈশ্বর রাগে ইস্রায়েলের অধ্যক্ষদের উপরে হাত রাখলেন না, বরং তারা ঈশ্বরকে দর্শন করলেন এবং তারা খেলেন ও পান করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","আর সদাপ্রভু মোশিকে বললেন, “তুমি পর্বতে আমার কাছে উঠে এসো এবং এই জায়গায় থাক, তাতে আমি দুটি পাথরের ফলক এবং আমার লেখা ব্যবস্থা ও আদেশ তোমাকে দেব, যেন তুমি লোকদের শিক্ষা দিতে পার।” ");
INSERT INTO benirv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","পরে মোশি ও তাঁর পরিচারক যিহোশূয় উঠলেন এবং মোশি ঈশ্বরের পর্বতে উঠলেন। ");
INSERT INTO benirv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","আর তিনি প্রাচীনদের বললেন, “আমরা যতক্ষণ না তোমাদের কাছে ফিরে না আসি, ততক্ষণ তোমরা আমাদের অপেক্ষায় এই জায়গায় থাক; আর দেখ, হারোণ ও হূর তোমাদের কাছে থাকলেন; যদি কারও কোন বিবাদ থাকে তবে সে তাদের কাছে যাক।” ");
INSERT INTO benirv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","সুতরাং মোশি যখন পর্বতে উঠলেন তখন পর্বত মেঘে ঢাকা ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","আর সীনয় পর্বতের উপরে সদাপ্রভুর প্রতাপ অবস্থিতি করছিল এবং ওটা ছয় দিন মেঘে ঢাকা ছিল; পরে সপ্তম দিনের তিনি মেঘের মধ্য থেকে মোশিকে ডাকলেন। ");
INSERT INTO benirv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","আর ইস্রায়েলীয়দের চোখে সদাপ্রভুর প্রতাপ পর্বতশৃঙ্গে গ্রাসকারী আগুনের মত প্রকাশিত হল। ");
INSERT INTO benirv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","আর মোশি মেঘের মধ্যে প্রবেশ করে পর্বতে উঠলেন। মোশি চল্লিশ দিন ও চল্লিশ রাত সেই পর্বতে ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","তুমি ইস্রায়েলদেরকে আমার জন্য উপহার সংগ্রহ করতে বল; হৃদয়ের ইচ্ছা থেকে যে নিবেদন করে, তার থেকে তোমরা আমার জন্য সেই উপহার গ্রহণ কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","এই সব উপহার তাদের থেকে গ্রহণ করবে; সোনা, রূপা, ব্রোঞ্জ; নীল, ");
INSERT INTO benirv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","বেগুনে ও লাল এবং সাদা মসীনা সূত্র ও ছাগলের লোম ");
INSERT INTO benirv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ও রক্তের রঙের ভেড়ার চামড়া, শুশুকের চামড়া ও শিটীম কাঠ; ");
INSERT INTO benirv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","দীপের জন্য তেল এবং অভিষেকের জন্য তেলের ও সুগন্ধ ধূপের জন্য গন্ধদ্রব্য; ");
INSERT INTO benirv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","এবং এফোদের ও বুকপাটার জন্য গোমেদ মণি এবং প্রভৃতি মূল্যবান পাথর লাগানো হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","আর তারা আমার জন্য এক ধর্ম্মধাম তৈরী করুক, তাতে আমি তাদের মধ্যে বাস করব। ");
INSERT INTO benirv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","আবাসের ও তার সব জিনিসের যে আদর্শ আমি তোমাকে দেখাই, সেই অনুসারে তোমরা সবই করবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","তারা শিটীম কাঠের এক সিন্দুক তৈরী করবে; তা আড়াই হাত দৈর্ঘ্য, দেড় হাত প্রস্থ ও দেড় হাত উঁচু হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","পরে তুমি খাঁটি সোনা দিয়ে তা মুড়ে দেবে; তার ভিতর ও বাইরে সোনা দিয়ে মুড়বে এবং তার উপরে চারদিকে সোনার পাত দিয়ে কিনারা গড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","আর তার জন্য সোনার চারটি কড়া ছাঁচে ঢেলে তার চার পায়াতে লাগাবে; তার এক পাশে দুটি কড়া ও অন্য পাশে দুই কড়া থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","আর তুমি শিটীম কাঠের দুটি বহন দণ্ড করে সোনা দিয়ে মুড়বে। ");
INSERT INTO benirv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","আর সিন্দুক বয়ে নিয়ে যাবার জন্য ঐ বহন দণ্ড সিন্দুকের দুই পাশে কড়াতে লাগবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","সেই বহন দণ্ড সিন্দুকের কড়াতে থাকবে, তা থেকে বের করা হবে না। ");
INSERT INTO benirv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","আর আমি তোমাকে যে সাক্ষ্যপত্র দেব, তা ঐ সিন্দুকে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","পরে তুমি খাঁটি সোনা দিয়ে আড়াই হাত দৈর্ঘ্য ও দেড় হাত প্রস্থ পাপাবরণ তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","আর তুমি সোনার দুটি করূব তৈরী করবে; পাপাবরণের দুটি মুড়াতে পিটান কাজ দিয়ে তাদের তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","এক মুড়াতে একটি করূব ও অন্য মুড়াতে অন্য করূব, পাপাবরণের দুটি মুড়াতে তার সঙ্গে অখণ্ড দুই করূব করবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","আর সেই দুটি করূব উর্ধে পাখনা বিস্তার করে ঐ পাখনা দিয়ে পাপাবরণকে আচ্ছাদন করবে এবং তাদের মুখ একে অপরের দিকে থাকবে, করূবদের দৃষ্টি পাপাবরণের দিকে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","তুমি অবশ্যই এই পাপাবরণ সেই সিন্দুকের উপরে রাখবে এবং আমি যে সাক্ষ্যপত্র তোমাকে দেব তা তুমি অবশ্যই ঐ সিন্দুকের মধ্যে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","আর আমি সেই জায়গায় তোমার সঙ্গে দেখা করব এবং পাপাবরণের উপরের অংশ থেকে, সাক্ষ্য সিন্দুকের উপরে স্থিত দুই করূবের মধ্য থেকে তোমার সঙ্গে কথা বলে ইস্রায়েল সন্তানদের প্রতি আমার সব আজ্ঞা তোমাকে জানাব। ");
INSERT INTO benirv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","আর তুমি শিটীম কাঠের এক মেজ তৈরী করবে; তা দুই হাত লম্বা, এক হাত প্রস্থ ও দেড় হাত উঁচু হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","আর খাঁটি সোনায় তা মুড়ে দেবে এবং তার চারদিকে সোনার পাত দিয়ে তৈরী করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","আর তার চারদিকে চার আঙ্গুল পরিমাণে একটি কাঠের কাঠামো করবে এবং পাশের কাঠামোর চারদিকে সোনার পাত দিয়ে তৈরী করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","আর সোনার চারটি কড়া করে চারটি পায়ার চার কোণে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","টেবিল বয়ে নিয়ে যাবার জন্য বহন দণ্ডের ঘর হবার জন্য ঐ কড়া পাশের কাঠামোর কাছে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","আর ঐ টেবিল বহন করার জন্য শিটীম কাঠের দুটি বহন দণ্ড করে তা সোনা দিয়ে মুড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","আর টেবিলের থালা, চামচ, কলসী ও ঢালার জন্য বাটি তৈরী করবে; এই সব খাঁটি সোনা দিয়ে তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","আর তুমি সেই টেবিলের উপরে আমার সামনে নিয়মিতভাবে দর্শন রুটি রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","আর তুমি খাঁটি সোনার একটি বাতিস্তম্ভ তৈরী করবে; পেটান কাজের সেই বাতিস্তম্ভ তৈরী করা হবে; তার গুড়ি, শাখা, গোলাধার, কলকা ও ফুল তার সঙ্গে অখণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","বাতিস্তম্ভের এক পাশ থেকে তিনটি শাখা ও বাতিস্তম্ভের অন্য পাশ থেকে তিনটি শাখা, এই ছয়টি শাখা তার পাশ থেকে নির্গত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","একটি শাখায় বাদামফুলের মতো তিনটি গোলাধার, এক কলকা ও একটি ফুল থাকবে এবং অন্য শাখায় বাদামফুলের মতো তিন গোলাধার, এক কলকা ও একটি ফুল থাকবে; বাতিস্তম্ভ থেকে নির্গত ছয়টি শাখায় এইরকম হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","বাতিস্তম্ভে বাদামফুলের মতো চার গোলাধার, ও তাদের কলকা ও ফুল থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","আর বাতিস্তম্ভের যে ছয়টি শাখা নির্গত হবে, তাদের একটি শাখা দুটির নীচে তার সঙ্গে অখণ্ড এক কলকা ও অপর শাখা দুটির নীচে তার সঙ্গে অখণ্ড এক কলকা থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","কলকা ও শাখা সবই তার সঙ্গে অখণ্ড হবে; সবই পেটানো খাঁটি সোনার একই জিনিস হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","আর তুমি বাতিস্তম্ভ এবং সাতটি প্রদীপ তৈরী করবে এবং লোকেরা সেই সব প্রদীপ জ্বালালে তার সামনে আলো হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","আর তার চিমটি ও ট্রে গুলি খাঁটি সোনা দিয়ে তৈরী করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","এই বাতিস্তম্ভ এবং ঐ সব জিনিসপত্র এক তালন্ত (35 কিলোগ্রাম) পরিমাণে খাঁটি সোনা দিয়ে তৈরী করা হবে। ");
INSERT INTO benirv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","দেখো, পর্বতে তোমাকে এই সবের যেরকম আদর্শ দেখান হয়েছিল, সেই রকম সবই কোরো। ");
INSERT INTO benirv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","আর তুমি দশটি পর্দা দিয়ে একটি পবিত্র সমাগম তাঁবু তৈরী করবে; সেগুলি পাকান সাদা মসীনা এবং নীল, বেগুনে ও লাল সুতো দিয়ে তৈরী করবে; সেই পর্দাগুলি সুনিপুণ করূবদের আকৃতি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","প্রতিটি পর্দার দৈর্ঘ্য আটাশ হাত ও প্রতিটি পর্দা প্রস্থে চার হাত হবে; সব পর্দার পরিমাণ সমান হবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","আর পাঁচটি পর্দার পরস্পর যুক্ত থাকবে এবং অন্য পাঁচটি পর্দা পরস্পর যুক্ত থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","আর জোড়ার জায়গায় প্রথমটির শেষে পর্দার মুড়াতে নীলসূতোর হূকের ঘর তৈরী করে দেবে এবং জোড়ার জায়গার দ্বিতীয়টির শেষে পর্দার মুড়াতেও সেরকম করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","প্রথম পর্দাতে পঞ্চাশ হূকের ঘর তৈরী করে দেবে এবং জোড়ার জায়গায় দ্বিতীয় পর্দার মুড়াতেও পঞ্চাশ হূকের ঘর তৈরী করে দেবে; সেই দুটি হূকের ঘর একে অন্যের সম্মুখীন হবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","আর পঞ্চাশ সোনার হূক তৈরী করে হূকের ঘরে পর্দাগুলি পরস্পর যুক্ত; তাতে তা একই সমাগম তাঁবু হবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","আর তুমি সমাগম তাঁবুর উপরে ঢাকার জন্য ছাগলের লোম দিয়ে পর্দাগুলি তৈরী করবে, এগারটি পর্দা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","প্রত্যেকটি পর্দার দৈর্ঘ্য ত্রিশ হাত ও প্রত্যেকটি পর্দা প্রস্থে চার হাত হবে; এই এগারতম পর্দাও একই পরিমাণের হবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","পরে পাঁচটি পর্দা একে অপরের সঙ্গে জোড়া দিয়ে আলাদা করে রাখবে, অন্য ছয়টি পর্দাও আলাদা করে রাখবে এবং এদের ছয়তম পর্দা দ্বিগুন করে সমাগম তাঁবুর সামনে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","আর জোড় জায়গায় প্রথম পর্দার শেষ মুড়াতে পঞ্চাশ হূকের ঘর তৈরী করে দেবে এবং সংযুক্তব্য দ্বিতীয় পর্দার মুড়াতেও পঞ্চাশ হূকের ঘর তৈরী করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","পরে পিতলের পঞ্চাশটি হূক তৈরী করে হূকের ঘরে তা ঢুকিয়ে তাঁবু সংযুক্ত করবে; তাতে তা একই তাঁবু হবে; ");
INSERT INTO benirv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","সমাগম তাঁবুর পর্দার বেশী অংশ, অর্থাৎ যে অর্ধেক পর্দার বেশী অংশ থাকবে, তা সমাগম তাঁবুর পিছন দিকে ঝুলে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","আর সমাগম তাঁবুর পর্দার দৈর্ঘ্য যে অংশ তার একপাশে এক হাত, ও অন্য পাশে এক হাত বেশী থাকবে, তা ঢেকে রাখার জন্য সমাগম তাঁবুর উপরে উভয় পাশে ঝুলে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","পরে তুমি তাঁবুর জন্য রক্ত বর্ণের ভেড়ার চামড়ার এবং অন্য একটি সুন্দর চামড়ার ছাদ তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","পরে তুমি সমাগম তাঁবুর জন্য শিটীম কাঠের দাঁড় করানো তক্তা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","প্রত্যেক তক্তার দৈর্ঘ্য দশ হাত ও প্রস্থে দেড় হাত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","প্রত্যেক তক্তার একে অপরের সংযুক্ত দুটি করে পায়া থাকবে; এই ভাবে সমাগম তাঁবুর সব তক্তাগুলি তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","সমাগম তাঁবুর জন্য তক্তা তৈরী করবে, দক্ষিণদিকের দক্ষিণ পাশের জন্য কুড়িটি তক্তা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","আর সেই কুড়িতম তক্তার নীচে চল্লিশটি রূপার ভিত্তি তৈরী করে দেবে; এক তক্তার নীচে তার দুই পায়ার জন্য দুটি ভিত্তি এবং অন্য অন্য তক্তার নীচেও তাদের দুটি করে পায়ার জন্য দুটি করে ভিত্তি হবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","আবার সমাগম তাঁবুর দ্বিতীয় পাশের জন্য উত্তরদিকে কুড়িটি তক্তা তৈরী করবে; ");
INSERT INTO benirv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","আর সেইগুলির জন্য রূপার চল্লিশটি ভিত্তি; এক তক্তার নীচে দুটি ভিত্তি ও অন্য তক্তাগুলির নীচেও দুটি করে ভিত্তি; ");
INSERT INTO benirv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","আর সমাগম তাঁবুর পিছনের অংশের পশ্চিম দিকের জন্য ছয়টি তক্তা করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","আর তাঁবুর সেই পিছনের অংশের দুটি কোণের জন্য দুটি তক্তা করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","সেই দুটি তক্তার নীচে জোড়া হবে এবং সেইভাবে উপরের অংশেও প্রথম কড়ার কাছে জোড় হবে; এই ভাবে পিছনের উভয় কোণেই হবে; তা দুটি কোণের জন্য হবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","সেখানে অবশ্যই আটটি তক্তা থাকবে এবং সেগুলি রূপার ভিত্তি ষোলটী হবে; এক তক্তার নীচে দুটি ভিত্তি, ও অন্য তক্তার নীচে দুটি ভিত্তি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","আর তুমি শিটীম কাঠের খিল তৈরী করবে, ");
INSERT INTO benirv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","সমাগম তাঁবুর এক পাশের তক্তাতে পাঁচটি খিল ও সমাগম তাঁবুর অন্য পাশের তক্তাতে পাঁচটি খিল এবং সমাগম তাঁবুর পশ্চিম দিকের পিছনের দিকের তক্তাতে পাঁচটি খিল দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","এবং মাঝখানের খিল তক্তাগুলির মাঝখান দিয়ে এক প্রান্ত থেকে অন্য প্রান্ত পর্যন্ত যাবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","আর ঐ তক্তাগুলি সোনা দিয়ে মুড়ে দেবে এবং খিলের ঘর হবার জন্য সোনার কড়া গড়বে এবং খিলগুলি সোনা দিয়ে মুড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","সমাগম তাঁবুর জন্য যে পরিকল্পনা পর্বতে তোমাকে দেখান হয়েছিল, সেই অনুসারে তা স্থাপন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","আর তুমি নীল, বেগুনে ও লাল এবং পাকান সাদা মসীনা সূতো দিয়ে এক পর্দা তৈরী করবে; তা শিল্পের কাজ হবে, তাতে করুবদের আকৃতি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","তুমি তা সোনায় মুড়ান শিটীম কাঠের চার স্তম্ভের উপরে খাটাবে; সেগুলির আঁকড়া সোনা দিয়ে হবে এবং সেগুলি রূপার চারটি ভিত্তির উপরে বসবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","আর হূকগুলির নীচে পর্দা খাটিয়ে দেবে এবং সেখানে পর্দার ভিতরে সাক্ষ্য সিন্দুক আনবে এবং সেই পর্দা ও অতি পবিত্র স্থান থেকে পবিত্র স্থানকে আলাদা করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","আর অতি পবিত্র জায়গায় সাক্ষ্য-সিন্দুকের উপরে পাপাবরণ রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","আর পর্দার বাইরে মেজ রাখবে ও টেবিলের সামনে সমাগম তাঁবুর পাশে, দক্ষিণদিকে বাতিদানি রাখবে এবং উত্তরদিকে টেবিল রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","আর সমাগম তাঁবুর ফটকের জন্য নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সুতো তৈরী শিল্পীদের করা একটি পর্দা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","আর সেই পর্দার জন্য শিটীম কাঠের পাঁচটি স্তম্ভ তৈরী করে সোনায় মুড়ে দেবে, ও সোনা দিয়ে তার আঁকড়া তৈরী করবে এবং তার জন্য পিতলের পাঁচ ভিত্তি ঢালবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","আর তুমি শিটীম কাঠ দিয়ে দৈর্ঘ্যে পাঁচ হাত ও প্রস্থে পাঁচ হাত বেদি তৈরী করবে। সেই বেদি চারকোণা এবং তিন হাত উঁচু হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","আর তার চার কোণের উপরে শিং তৈরী করবে, সেই বেদির শিংগুলি একসঙ্গেই থাকবে এবং তুমি সেটা ব্রোঞ্জ দিয়ে মুড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","আর তার ছাই নেবার জন্য হাঁড়ী তৈরী করবে এবং তার হাতা, বাটি, ত্রিশূল ও আগুন রাখার পাত্র তৈরী করবে; তার সব পাত্র ব্রোঞ্জ দিয়ে তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","আর বেদির জন্য জালের মত ব্রোঞ্জের এক ঝাঁঝরী তৈরী করবে এবং সেই ঝাঁঝরীর উপরে চার কোণে ব্রোঞ্জের চারটি বালা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","এই ঝাঁঝরীটি বেদির বেড়ের নীচের দিকে রাখবে এবং ঝাঁঝরী বেদির মাঝখান পর্যন্ত থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","আর বেদির জন্য শিটীম কাঠের বহন দণ্ড তৈরী করবে ও তা ব্রোঞ্জ দিয়ে মুড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","আর বালার মধ্যে ঐ বহন-দণ্ড দেবে এবং বেদিটি বহনের দিন তার দুই পাশে সেই বহন-দণ্ড অবশ্যই থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","তুমি অবশ্যই বেদিটি ফাঁপা করবে ও তক্তা দিয়ে তৈরী করবে; পর্বতে তোমাকে যেরকম দেখান হয়েছিল, তুমি সেই রকম ভাবে তা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","আর তুমি সমাগম তাঁবুর জন্য ওঠান তৈরী করবে; দক্ষিণ পাশের দক্ষিণদিকে পাকান সাদা মসীনা সুতোর তৈরী পর্দা থাকবে; তার এক পাশের দৈর্ঘ্য এক শত হাত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","তার কুড়িটি স্তম্ভ ও কুড়িটি ভিত্তি ব্রোঞ্জের হবে এবং স্তম্ভের আঁকড়া ও শলাকা গুলি রূপার হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","সেইরূপ উত্তর পাশে একশ হাত লম্বা পর্দা হবে, আর তার কুড়িটি স্তম্ভ ও কুড়িটি ব্রোঞ্জের ভিত্তি হবে এবং স্তম্ভের আঁকড়া ও শলাকা গুলি রূপার হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","আর উঠানের প্রস্থের জন্যে পশ্চিমদিকে পঞ্চাশ হাত পর্দা ও তার দশটি স্তম্ভ ও দশটি ভিত্তি হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","আর উঠানটি অবশ্যই লম্বায় পূর্ব্ব পাশের পূর্ব্বদিকে পঞ্চাশ হাত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ফটকের এক পাশের জন্য লম্বায় পনের হাত পর্দা, তিনটি স্তম্ভ ও তিনটি ভিত্তি হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","আর অন্য পাশের জন্যও পনের হাত লম্বা পর্দা হবে। আর তাদের অবশ্যই তিনটি স্তম্ভ ও তিনটি ভিত্তি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","আর উঠানের ফটকের জন্য নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সূতো দিয়ে শিল্পীর হাতে করা কুড়ি হাত একটি পর্দা হবে। তাতে অবশ্যই চারটি স্তম্ভ ও চারটি ভিত্তি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","উঠানের চারিদিকের স্তম্ভ গুলি রূপার শলাকাতে বদ্ধ হবে ও সেগুলির আঁকড়া রূপার ও ব্রোঞ্জের ভিত্তি হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","উঠানের দৈর্ঘ্য একশো হাত, প্রস্থ সব জায়গায় পঞ্চাশ হাত এবং উচ্চতায় পাঁচ হাত হবে, সবগুলি পাকান সাদা মসীনা সুতো দিয়ে করা হবে ও তাতে ব্রোঞ্জের ভিত্তি হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","সমাগম তাঁবুর ভিতরে ব্যবহৃত সব জিনিসগুলি ও তাঁবুর সমস্ত গোঁজ এবং উঠানের সমস্ত গোঁজ ব্রোঞ্জের হবে। ");
INSERT INTO benirv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","আর তুমি অবশ্যই ইস্রায়েলের সন্তানদের এই আদেশ করবে, যেন তারা আলোর জন্য পেশাই করা জিততেল তোমার কাছে আনে, যাতে সবদিন প্রদীপ জ্বালান থাকে। ");
INSERT INTO benirv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","আর সমাগম তাঁবুতে সাক্ষ্য সিন্দুকের সামনের পর্দার বাইরে হারোণ ও তার ছেলে সন্ধ্যা থেকে সকাল পর্যন্ত সদাপ্রভুর সামনে তা তৈরী রাখবে; এটা ইস্রায়েলের সন্তানদের বংশপরম্পরায় পালনের চিরকালীন ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","আর তুমি আমার যাজক হিসাবে ইস্রায়েলের সন্তানদের মধ্যে থেকে তোমার ভাই হারোণকে ও তার সঙ্গে তার ছেলেদের নিজের কাছে উপস্থিত করবে; হারোণ এবং হারোণের ছেলে নাদব, অবীহূ, ইলীয়াসর ও ঈথামরকে উপস্থিত করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","আর তোমার ভাই হারোণের জন্য, আমার উদ্দেশ্যে গৌরব ও শোভার জন্য তুমি পবিত্র পোশাক তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","আর আমি যাদেরকে জ্ঞানের আত্মায় পূর্ণ করেছি, সেই সমস্ত জ্ঞানী লোকেদেরকে বল, যেন আমার সেবা করার জন্য যাজক হিসাবে হারোণকে পবিত্র করতে তারা তার পোশাক তৈরী করে। ");
INSERT INTO benirv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","এই সব পোশাক তারা তৈরী করবে; বুকপাটা, এফোদ, পরিচ্ছদ, বোনা পোশাক, পাগড়ি ও কোমরবন্ধনী; আমার যাজক হিসাবে সেবা করার উদ্দেশ্যে তারা তোমার ভাই হারোণের ও তার ছেলেদের জন্য পবিত্র পোশাক তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","তারা সোনা এবং নীল, বেগুনে ও লাল এবং সাদা মসীনা সুতো নেবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","আর তারা সোনা এবং নীল, বেগুনে ও লাল এবং পাকান সাদা মসীনা সুতোয় দক্ষ কারিগর দিয়ে এফোদ তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","তার দুই কাঁধে একে অপরের সাথে যুক্ত দুটি ফিতা থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","তা বাঁধবার জন্য সুক্ষ্মভাবে বোনা কোমরবন্ধনী এফোদের মত হতে হবে, তা তার সঙ্গে অখণ্ড এবং সেই পোশাকের সমান হবে; অর্থাৎ স্বর্ণ, নীল, বেগুনে ও লাল এবং পাকান সাদা মসীনা সূতো দিয়ে তৈরী হবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","পরে তুমি দুই গোমেদক মণি নিয়ে তার উপরে ইস্রায়েলীয়দের নাম খোদাই করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","তাদের জন্ম অনুযায়ী নাম অনুসারে ছয়টি নাম একটি পাথরের উপরে অবশ্যই থাকবে, ও অবশিষ্ট ছয়টি নাম অন্য পাথরের উপরে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","শিল্পকাজ ও মুদ্রা খোদাইয়ের মত সেই দুটি পাথরের উপরে ইস্রায়েলের বারোটির ছেলের নাম খোদাই করা হবে। তোমরা অবশ্যই পাথরগুলি সোনার বিনুনি করা শিকল দিয়ে আঁটকিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","আর ইস্রায়েলীয়দের সদাপ্রভুকে স্মরণ করার জন্য মণিরূপে তুমি সেই দুটি পাথর এফোদের দুই কাঁধের ফিতাতে দেবে; তাতে হারোণ স্মরণ করবার জন্য সদাপ্রভুর সামনে নিজের দুটি কাঁধে তাদের নাম বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","আর তুমি অবশ্যই সোনার কাজ করবে, ");
INSERT INTO benirv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","এবং খাঁটি সোনা দিয়ে পাকান দুটি পাতা-কাটা মালার মত শিকল করবে এবং সেই পাকান শিকল দুটি অবশ্যই যুক্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","আর শিল্পীর দ্বারা কার্য্যে বিচার করার জন্য বুকপাটা তৈরী করবে; এফোদের মত কায়দায় করবে; সোনা, নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সুতো দিয়ে তা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","এটা চারকোণ ও দুইভাগ বিশিষ্ট হবে; এটার দৈর্ঘ্য এক বিঘত ও প্রস্থ এক বিঘত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","আর এটির ওপরে চার সারি মূল্যবান মণি লাগিয়ে তৈরী করবে; তার প্রথম সারিতে অবশ্যই চুণী, পীতমণি ও মরকত; ");
INSERT INTO benirv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","দ্বিতীয় সারিতে অবশ্যই পদ্মরাগ, নীলকান্ত ও হীরক; ");
INSERT INTO benirv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","তৃতীয় সারিতে অবশ্যই পেরোজ, যিস্ম ও কটাহেলা; ");
INSERT INTO benirv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","এবং চতুর্থ সারিতে বৈদূর্ষ্য, গোমেদক ও সূর্য্যকান্ত মণি; এই গুলি নিজের নিজের সারিতে সোনা দিয়ে লাগানো হবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","এই পাথরগুলি ইস্রায়েলীয়দের বারোটি নামানুযায়ী সাজানো হবে; এই গুলি একটি আংটির উপর খোদাই করা প্রত্যেক পাথরে ঐ বারো বংশের জন্য এক এক ছেলের নাম থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","আর তুমি খাঁটি সোনা দিয়ে বুকপাটার উপরে পাতার আকৃতি মালার মত পাকান দুটি শিকল তৈরী করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","আর বুকপাটার ওপরে সোনার দুটি বালা তৈরী করে দেবে এবং অবশ্যই বুকপাটার দুই মাথায় ঐ দুটি বালা বেঁধে বাঁধে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","আর বুকপাটার দুই প্রান্তে অবস্থিত দুটি বালার মধ্যে পাকান সোনার ঐ দুটি শিকল রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","আর পাকান শিকলের দুটি শেষ প্রান্ত সেই দুটি পাতা কাটা শিকলে বেঁধে দেবে। তারপর এফোদের সামনে দুটি কাঁধের ফিতার উপরে ঐগুলি লাগিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","তুমি অবশ্যই সোনার দুটি বালা তৈরী করে বুকপাটার দুই মাথায় এফোদের সামনের দিকে ভিতরের অংশে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","তুমি আরও দুটি সোনার বলা তৈরী করবে এবং এফোদের দুই কাঁধের ফিতের নীচে এফোদের সামনের অংশে সুক্ষ্মভাবে বোনা কোমরবন্ধনীর উপরে তা লাগিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","তাতে বুকপাটা যেন এফোদের সুক্ষ্মভাবে বোনা কোমরবন্ধনীর উপরে থাকে, এফোদ থেকে যেন খসে না পড়ে, এই জন্য তারা সেই বালাতে নীলসুতো দিয়ে এফোদের বালার সঙ্গে বুকপাটা বেঁধে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","যখন হারোণ পবিত্র জায়গায় যাবে, তখন তিনি সদাপ্রভুর সামনে সব দিন মনে করে দেবার জন্য সে বিচারের জন্য বুকপাটাতে ইস্রায়েলের বারোটি ছেলের নাম নিজের হৃদয়ের উপরে বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","আর বিচারের জন্য সেই বুকপাটায় তুমি ঊরীম ও তুম্মীম দীপ্তি ও সিদ্ধতা দেবে; তাতে হারোণ যখন সদাপ্রভুর সামনে যাবে, তখন হারোণের হৃদয়ের উপরে সেই বিচারের জন্য বুকপাটা থাকবে এবং হারোণ সদাপ্রভুর সামনে ইস্রায়েলীয়দের বিচারের বুকপাটাটি সবদিন নিজের হৃদয়ের উপরে বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","আর তুমি এফোদের সব পরিচ্ছদ নীল রঙের করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","তার মাঝখানে মাথায় পরার জন্য একটি জায়গা থাকবে; গলার সেই জায়গার চারদিকে তন্তু দিয়ে শিল্পীর কাজ করা পাড় থাকবে, যাতে এটি না ছেঁড়ে। ");
INSERT INTO benirv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","আর তুমি তার আঁচলের চারধারে নীল, বেগুনে ও লাল ডালিম করবে এবং তার চারদিকে মধ্যে মধ্যে সোনার ঘন্টা থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ঐ পোশাকের আঁচলের চারধারে এক সোনার ঘন্টা ও একটি ডালিম এবং এক সোনার ঘন্টা ও একটি ডালিম থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","আর হারোণ পরিচর্য্যা করার জন্য সেই পোশাক পরবে; তাতে সে যখন সদাপ্রভুর সামনে পবিত্র জায়গায় প্রবেশ করবে, ও সেখান থেকে যখন বের হবে, তখন সেই ঘন্টার শব্দ শোনা যাবে; এটি হলো যাতে সে না মরে। ");
INSERT INTO benirv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","আর তুমি অবশ্যই খাঁটি সোনা দিয়ে একটি পাত তৈরী করবে এবং মুদ্রার মত তার ওপরে “সদাপ্রভুর উদেশ্যে পবিত্র” এই কথা খোদাই করে লিখবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","তুমি ওই পাতটি নীলসুতো দিয়ে বেঁধে রাখবে; তা উষ্ণীষের উপরের দিকে এবং সামনের দিকে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","আর এটি অবশ্যই হারোণের কপালের উপরে থাকবে, তাতে ইস্রায়েলীয়রা নিজেদের সব পবিত্র দানে যে সকল জিনিসগুলি পবিত্র করবে, হারোণ সেই সব পবিত্র জিনিসের অপরাধ সব দিন বহন করবে। আর তাদের উপহার যাতে সদাপ্রভু গ্রহণ করে, সেই জন্য এটি সব দিন তার কপালের উপরে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","আর তুমি চিত্রিত সাদা মসীনা সুতো দিয়ে অঙ্গরক্ষিণী বুনবে এবং তুমি সাদা মসীনা সুতো দিয়ে উষ্ণীষ তৈরী করবে; তুমি কোমরবন্ধনীর মত একই জিনিস দিয়ে শিল্প কাজ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","আর হারোণের ছেলেদের জন্য অঙ্গ রক্ষার পোশাক ও কোমরবন্ধনী তৈরী করবে এবং চমত্কার ও সম্মানের জন্য শিরোভূষণ করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","আর তুমি তোমার ভাই হারোণ ও তার সঙ্গে তার ছেলেদের গায়ে সেই সব পোশাক পরাবে। তুমি তাদের অভিষেক করবে এবং তাদেরকে পবিত্র করে আমার জন্য সংরক্ষণ করবে, যাতে তারা যাজকের কাজ করে আমাকে সেবা করে। ");
INSERT INTO benirv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","তুমি তাদের উলঙ্গতা আচ্ছাদন করার জন্য কোমর থেকে উরু পর্যন্ত মসীনা সুতোর জাঙ্গিয়া তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","আর যখন হারোণ ও তার ছেলেরা সমাগম তাঁবুতে ঢুকবে অথবা পবিত্র স্থানে সেবা কাজ করার জন্য বেদির কাছে যাবে তখন তারা এই পোশাক অবশ্যই পরবে, যাতে তারা কোনো অপরাধ বয়ে না মরে যায়। এটা একটা হারোণ ও তার পরবর্তী বংশের জন্য চিরকালের ব্যবস্থা হবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","আর তুমি এই সব কাজগুলি তাদেরকে পবিত্র করার জন্য তাদের প্রতি করবে; যাতে তারা যাজক হয়ে আমাকে সেবা করে। নির্দোষ একটি পুরুষ গরু এবং দুটি ভেড়া নাও; ");
INSERT INTO benirv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","আর খামির বিহীন রুটি, তেল মেশানো খামির বিহীন পিঠে ও তেল মাখানো খামির বিহীন সরুচাকলী। এই সবগুলি গমের ময়দা দিয়ে তৈরী করবে; ");
INSERT INTO benirv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","তুমি সেগুলি একটি ডালিতে রাখবে, আর সেইগুলি ডালিতে করে আনবে এবং সেই গরু ও দুটি ভেড়ার সঙ্গে উপহার দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","আর তুমি হারোণ ও তার ছেলেদেরকে সমাগম তাঁবুর ফটকের কাছে আনবে এবং জল দিয়ে হারোণ ও তার ছেলেদেরকে স্নান করাবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","আর সেই সব পোশাক নিয়ে হারোণকে পরাবে, এফোদের রাজবেশ, এফোদ ও বুকপাটা পরাবে এবং তার চারদিকে এফোদের বুননি করা কোমরবন্ধনী দিয়ে বাঁধবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","আর তার মাথায় পাগড়ি দেবে, ও পাগড়ির উপরে পবিত্র মুকুট দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","পরে অভিষেকের জন্য যে তেল সেই তেল নিয়ে তার মাথার উপরে ঢেলে দেবে এবং এই ভাবে তাকে অভিষিক্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","আর তুমি তার ছেলেদেরকে অবশ্যই আনবে এবং তাদেরকে অঙ্গরক্ষক পোশাক পরাবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","আর তুমি হারোণকে ও তার ছেলেদেরকে কোমরবন্ধন পরাবে এবং তাদের মাথায় শিরোভূষণ বেঁধে দেবে; তাতে যাজকের কাজ তাদের জন্য চিরকাল ব্যবস্থা হয়ে থাকবে। আর এই ভাবে তুমি আমাকে সেবা করার জন্য হারোণ ও তার ছেলেদের পবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","পরে তোমরা সকলে অবশ্যই সমাগম তাঁবুর সামনে সেই গরুটি আনবে এবং হারোণ ও তার ছেলেরা সেই গরুটির মাথায় হস্তার্পণ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","তখন তুমি সমাগম তাঁবুর ফটকের সামনে ও সদাপ্রভুর সামনে ঐ গরুটি হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","পরে গরুটির রক্ত কিছুটা নিয়ে আঙুল দিয়ে বেদির শিঙের উপরে দেবে এবং বেদির নিচের অংশে বাকি সব রক্ত ঢেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","আর তার অন্ত্রের উপরে থাকা সব মেদ ও যকৃতের উপরের অন্ত্রাপ্লাবক ও দুটি মেটে ও তার অপরের সব মেদ নিয়ে বেদিতে পোড়াবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","কিন্তু গরুর মাংস ও তার চামড়া ও গোবর তুমি শিবিরের বাইরে আগুনে পুড়িয়ে দেবে; এটাই হবে পাপের জন্য বলি। ");
INSERT INTO benirv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","পরে তুমি একটি ভেড়া আনবে এবং হারোণ ও তার ছেলেরা সেই ভেড়ার মাথায় হস্তার্পণ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","তুমি সেই ভেড়া হত্যা করবে। পরে তার রক্ত নিয়ে বেদির উপরে এবং তার চারদিকে ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","পরে তুমি ভেড়াটি খণ্ড খণ্ড করে কাটবে এবং তার অন্ত্র ও পা ধোবে এবং ঐ অন্ত্রগুলি খণ্ড মাংস ও মাথার সঙ্গে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","পরে সমস্ত ভেড়াটি বেদির ওপরে পোড়াবে; এটাই হবে আমার অর্থাৎ সদাপ্রভুর উদ্দেশ্যে হোমবলি, এটাই হবে আমার উদ্দেশ্যে সৌরভের জন্য এবং আমার জন্য আগুন দিয়ে উপহার। ");
INSERT INTO benirv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","পরে তুমি অন্য ভেড়াটি নেবে এবং হারোণ ও তার ছেলেরা অবশ্যই ঐ ভেড়ার মাথায় হস্তার্পণ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","পরে তুমি সেই ভেড়া হত্যা করবে এবং তার থেকে কিছু রক্ত নেবে। এই রক্ত দিয়ে হারোণের ডান কানে ও তার ছেলেদের ডান কানে ও তাদের ডান হাতের বুড়ো আঙ্গুলের উপরে দেবে এবং তাদের মহান ডান পায়ের পাতার উপরে দেবে। তার পরে বেদির উপরে চারিদিকে রক্ত ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","পরে বেদির উপরে থাকা রক্ত ও অভিষেকের জন্য যে তেল তার থেকে কিছুটা নিয়ে হারোণের ওপরে ও তার পোশাকের ওপরে এবং তার সঙ্গে তার ছেলেদের ওপরে ও তাদের পোশাকের ওপরে ছিটিয়ে দেবে। তখন হারোণ ও তার পোশাক এবং ঠিক তার মতোই তার ছেলেরা ও তাদের পোশাক পবিত্র হবে এবং আমার জন্য সংরক্ষিত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","পরে তুমি সেই ভেড়ার মেদ, মোটা লেজ ও অন্ত্রের উপরের মেদ যেটি অন্তরকে ঢেকে রাখে এবং দুটি মেটিয়া ও তার উপরের মেদ, দুটি বৃক্ক ও তার উপরের মেদ এবং ডান উরু নেবে, কারণ সেই ভেড়াটি হলো আমার উদ্দেশ্যে যাজককে পবিত্র করার জন্য। ");
INSERT INTO benirv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","পরে তুমি সদাপ্রভুর সামনে থাকা খামির বিহীন রুটির ডালি থেকে একটি রুটি ও তেল দিয়ে তৈরী একটি পিঠে ও একটি বিস্কুট নেবে; ");
INSERT INTO benirv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","তুমি হারোণের হাতে ও তার ছেলেদের হাতে সেই গুলি দেবে। তারা সেগুলি আমার সামনে অর্থাৎ সদাপ্রভুর সামনে দোলাবে এবং অবশ্যই আমাকে উপহার দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","পরে তুমি তাদের হাত থেকে সেই খাবার নিয়ে সদাপ্রভুর সামনে হোম বলির জন্য বেদির উপরে দগ্ধ করবে; এটি একটি মিষ্টি সৌরভ আমার জন্য উত্পন্ন করবে। এগুলি হবে সদাপ্রভুর উদ্দেশ্যে আগুন দ্বারা উপহার। ");
INSERT INTO benirv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","পরে তুমি হারোণের হাতে পবিত্র করা ভেড়ার বুকের অংশ নেবে এবং সদাপ্রভুর সামনে দোলাবে এবং আমাকে উপহার দেবে; তখন এটি তোমার খাবার জন্য অংশ হবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","তুমি অবশ্যই উপহারের সেই উচ্চিকৃত বুকের অংশ এবং উপহারের সেই ভেড়ার উরু আমার জন্য পবিত্র করবে, হারোণ ও তার ছেলেদের হাতে পবিত্র করা ভেড়ার যে দোলায়িত বুকের অংশ ও যে উরু উপহার দেওয়া হয়েছে, তা তুমি পবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","মাংসের এই অংশ ইস্রায়েলীয়দের থেকে দেওয়া হয়েছে, তা হারোণ ও তার বংশের জন্য চিরকাল অধিকারী হয়ে থাকবে। কারণ এটাই হলো ব্যবস্থার দ্বারা সহভাগীতার উপহার; এটাই সদাপ্রভুর উদ্দেশ্যে যাজকদের জন্য ইস্রায়েলীয়দের থেকে উপহার। ");
INSERT INTO benirv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","আর হারোণের পরে তার পবিত্র পোশাক গুলি তার ছেলেরা গ্রহণ করবে; আমার জন্য অভিষেক ও পবিত্র করার দিন তারা সেগুলি পরিধান করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","তার ছেলেদের মধ্যে যে তার পদে যাজক হবে, যে পবিত্র জায়গায় সেবা করতে সমাগম তাঁবুতে প্রবেশ করবে, সে সেই বস্ত্র সাত দিন পরবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","পরে তুমি সেই যাজক দিয়ে আমার জন্য পবিত্র করা ভেড়ার মাংস নিয়ে কোন পবিত্র স্থানে সিদ্ধ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","হারোণ ও তার ছেলেরা সমাগম তাঁবুর দরজার কাছে সেই ভেড়ার মাংস এবং ডালিতে থাকা সেই রুটি খাবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","আর আমার জন্য তাদেরকে পবিত্র করার জন্য যে সব মাংস এবং রুটি দিয়ে প্রায়শ্চিত্ত করা হল, তা তারা খাবে; কিন্তু অন্য কোন লোক তা খাবে না, কারণ তার অবশ্যই সেগুলি পবিত্র বস্তু মান্য করবে ও আমার জন্য সংরক্ষিত করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","আর আমার জন্য ঐ পবিত্র করা সেই মাংস ও সেই রুটি থেকে যদি সকাল পর্যন্ত কিছু অবশিষ্ট থাকে, তবে সেইগুলি অবশ্যই আগুনে পুড়িয়ে দেবে; কেউ সেগুলি খাবে না, কারণ তা পবিত্র বস্তু ও আমার জন্য সংরক্ষিত। ");
INSERT INTO benirv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","এই ভাবে আমি যে তোমাকে এই সব আজ্ঞা করলাম, সেই অনুসারে হারোণ ও তার ছেলেদের প্রতি তুমি করবে; তুমি সাত দিনের তাদেরকে আমার জন্য পবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","আর তুমি প্রতিদিন প্রায়শ্চিত্তের জন্য পাপের বলিরূপে একটি করে পুরুষ গরু উৎসর্গ করবে এবং তুমি প্রায়শ্চিত্ত করে বেদিকে পাপ মুক্ত করবে এবং পবিত্র করার জন্য তা অভিষেক করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","তুমি সাত দিনের বেদিটিকে প্রায়শ্চিত্ত করবে এবং তা পবিত্র করবে। তখন বেদিটি অতি পবিত্র হবে, আমার জন্য সংরক্ষিত হবে। যা কিছু বেদি স্পর্শ করবে সেটি একইরকম পবিত্র হতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","তুমি সেই বেদির উপরে প্রতিদিন একবছর বয়সী ভেড়ার বাচ্চা দুটি করে বলি উৎসর্গ করবে; ");
INSERT INTO benirv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","একটি ভেড়ার বাচ্চা সকালে উৎসর্গ করবে এবং অন্য বাচ্চাটি সন্ধ্যার দিন উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","আর প্রথম ভেড়া বাচ্চাটির সঙ্গে হিনের এক চতুর্থাংশ পেষাই করা জিত (অলিভ) তেল মেশানো ঐফা পাত্রের দশ ভাগের এক ভাগ ময়দা এবং পানীয় নৈবেদ্যের কারণ হিনের চতুর্থাংশ দ্রাক্ষারস দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","পরে দ্বিতীয় ভেড়া বাচ্চাটি সন্ধ্যার দিন উৎসর্গ করবে এবং সকালের মত শষ্য এবং পানীয় নৈবেদ্যের সঙ্গে উত্সর্গ করবে। এগুলি সদাপ্রভুর উদ্দেশ্যে এক মিষ্টি সুবাস উত্পন্ন করবে এবং এটি আমার জন্য আগুনের নৈবেদ্য বলে উৎসর্গ হবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","এইগুলি তোমাদের বংশানুক্রমে নিয়মিত হোমবলি। তুমি এগুলি সমাগম তাঁবুর দরজার কাছে আমার অর্থাৎ সদাপ্রভুর সামনে যে জায়গায় আমি তোমার সঙ্গে কথা বলতে তোমাদের কাছে দেখা দেব, সেই জায়গায় করবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","সেখানেই আমি ইস্রায়েলীয়দের কাছে দেখা দেব এবং আমার প্রতাপে তাঁবু পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","আর আমি সমাগম তাঁবু এবং বেদি পবিত্র করব কারণ এগুলি শুধু আমারই। আমি যাজকের কাজ করার জন্য ও আমাকে সেবা করার জন্য হারোণ ও তার ছেলেদের পবিত্র করব। ");
INSERT INTO benirv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","আমি ইস্রায়েলীয়দের মধ্যে বাস করব, ও তাদের ঈশ্বর হব। ");
INSERT INTO benirv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","তারা জানতে পারবে যে আমিই সদাপ্রভু, তাদের ঈশ্বর, যে মিশর দেশ থেকে তাদেরকে বের করে এনেছে, সেই আমি, যেন তাদের মধ্যে বাস করতে পারি; আমিই সদাপ্রভু, তাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","আর তুমি ধূপ দেবার জন্য একটি বেদি তৈরী করবে; শিটীম কাঠ দিয়ে তা তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","এটির দৈর্ঘ্য এক হাত ও প্রস্থ এক হাত হবে। এটির চারকোন হবে এবং উচ্চতা দুই হাত হবে। এর শিং গুলি তার সঙ্গে এক খণ্ডে তৈরী করা হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","আর তুমি অবশ্যই সেই ধূপবেদিটির উপরে, চার পাশে এবং এর শিংগুলি খাঁটি সোনা দিয়ে মুড়ে দেবে। তুমি তার চারদিকে সোনার পাত তৈরী করে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","আর সেই সোনার পাতের নীচে দুই বিপরীত ধারে কোণের কাছে দুটি করে সোনার বালা তৈরী করবে; বালাগুলি বেদি বয়ে নিয়ে যাওয়ার জন্য বহন দণ্ডের ঘর হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","আর ঐ বহন-দণ্ড শিটীম কাঠ দিয়ে তৈরী করে সোনা দিয়ে মুড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","আর সাক্ষ্য সিন্দুকের পাশের পর্দার সামনের দিকে ধূপ বেদিটি রাখবে। এটি সাক্ষ্য সিন্দুকের উপরের পাপাবরণের সামনে থাকবে, যেখানে আমি তোমার সঙ্গে দেখা করব। ");
INSERT INTO benirv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","হারোণ অবশ্যই প্রতিদিন সকালে সুগন্ধি ধূপ জ্বালাবে; তিনি প্রদীপ পরিষ্কার করবার দিন ঐ ধূপ জ্বালাবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","যখন হারোণ সন্ধ্যার দিন আবার প্রদীপ জ্বালাবে, তিনি সেই ধূপবেদিতে ধূপ জ্বালাবে। এটি তোমার লোকদের বংশানুক্রমে আমার অর্থাৎ সদাপ্রভুর সামনে প্রতি নিয়ত ধূপদাহ হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","কিন্তু তোমরা এর উপরে সুগন্ধি ধূপ অথবা হোমবলি অথবা শস্য নৈবেদ্য উৎসর্গ করো না। তোমরা এর উপরে পানীয় নৈবেদ্য ঢেলো না। ");
INSERT INTO benirv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","আর বছরে একবার হারোণ তার ধুপবেদির শিঙের ওপরে প্রায়শ্চিত্ত করবে; তিনি অবশ্যই প্রায়শ্চিত্তের জন্য পাপবলির রক্ত ব্যবহার করে এটি করবে। মহা যাজক তোমার লোকদের বংশানুক্রমে এটি করবে। এই উপহার হবে মহা পবিত্র, আমার অর্থাৎ সদাপ্রভুর জন্য সংরক্ষিত। ");
INSERT INTO benirv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“তুমি যখন ইস্রায়েলীয়দের সংখ্যা গণনা করবে, তখন তারা প্রত্যেকে গণনার দিন সদাপ্রভুর কাছে নিজের নিজের প্রাণের জন্য খেসারৎ দেবে। তাদের গণনা করার পর তুমি এটি অবশ্যই করবে, সুতরাং তোমার গণনা করার দিন যেন তাদের মধ্যে আঘাত না হয়। ");
INSERT INTO benirv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","গণনায় যাদের গণনা করা হয়েছে তাদের প্রত্যেককে রূপার অর্ধেক শেকল করে দিতে হবে; বিংশতিতে এক শেকলে ওজন হলো কুড়িটি গেরার সমান; এই অর্দ্ধশেকল আমার অর্থাৎ সদাপ্রভুর উদ্দেশ্যে উপহার হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","গণনার মধ্যে যারা কুড়ি বছর বয়ষ্ক অথবা তার বেশি বয়ষ্ক তারা সবাই সদাপ্রভুকে এই উপহার দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","যখন লোকেরা প্রাণের জন্য প্রায়শ্চিত্ত করতে সদাপ্রভুকে সেই উপহার দেবে সেই দিন ধনীরা অর্দ্ধ শেকলের বেশি দেবে না এবং গরিবরা তার কম দেবে না। ");
INSERT INTO benirv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","তুমি ইস্রায়েলীয়দের থেকে সেই প্রায়শ্চিত্তের রূপা নিয়ে সমাগম তাঁবুর কাজের জন্য দেবে। এটি তোমাদের প্রাণের প্রায়শ্চিত্তের জন্য ইস্রায়েলীয়দের স্মরণ করার জন্য আমার অর্থাৎ সদাপ্রভুর সামনে থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“তুমি ধোয়ার কাজের জন্য ব্রোঞ্জের একটি গামলার মত ধোয়ার পাত্র ও তার জন্য ব্রোঞ্জের একটি দানি তৈরী করবে; তুমি এটি সমাগম তাঁবুর ও বেদির মাঝখানে রাখবে এবং তার মধ্যে জল দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","হারোণ ও তার ছেলেরা অবশ্যই তাদের হাত এবং পা এই জল দিয়ে ধোবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","যখন তারা সমাগম তাঁবুতে প্রবেশ করবে, অথবা আমার সেবা করার জন্য যখন তারা বেদির নিকটে আসবে এবং হোম উপহার দেবে তখন তারা নিজেদেরকে জলে পরিষ্কার করবে, যেন তারা না মরে। ");
INSERT INTO benirv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","তারা অবশ্যই তাদের হাত ও পা পরিষ্কার করবে, যেন তারা না মরে। এটি হারোণ ও তার বংশধরদের জন্য বংশ পরম্পরায় চিরকালের ব্যবস্থা হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“তুমি এই ভালো ভালো সুগন্ধ মশলাগুলি নাও, পবিত্র জায়গার শেকল অনুযায়ী পাঁচ শত শেকল খাঁটি গন্ধরস, দুশো পঞ্চাশ শেকল সুগন্ধি দারুচিনি, ");
INSERT INTO benirv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","দুশো পঞ্চাশ শেকল সুগন্ধি বচ, পাঁচ শত শেকল সূক্ষ্ম দারুচিনি এবং এক হিন জিত তেল। ");
INSERT INTO benirv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","এই সবগুলি দিয়ে তুমি অভিষেক করার জন্য পবিত্র তৈল তৈরী করবে, গন্ধবণিকের প্রক্রিয়া মতই এই তৈল তৈরী করবে, আর এটি অভিষেকের জন্য এবং আমার জন্য সংরক্ষিত পবিত্র তেল হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","আর তুমি এই তেল দিয়ে সমাগম তাঁবু, সাক্ষ্য সিন্দুক, ");
INSERT INTO benirv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","টেবিল এবং তার সব পাত্র, দীপদানি ও তার সব জিনিসপাত্র, ");
INSERT INTO benirv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ধূপবেদি, হোমবেদি ও তার সব পাত্রগুলি এবং হাত ধোয়ার জন্য গামলার মত পাত্র ও সেটি রাখবার জন্য দানি অভিষেক করবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","আর এই সব জিনিসপত্র গুলি পবিত্র করবে, যাতে সেগুলি অতি পবিত্র হবে এবং আমার জন্য সংরক্ষিত হবে। যে কেউ সেগুলি স্পর্শ করবে, তাকে অবশ্যই পবিত্র হতে হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","আর তুমি হারোণকে ও তার ছেলেদেরকে আমার যাজকের কাজ ও সেবা কাজ করার জন্য অভিষেক করে পবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","আর তুমি ইস্রায়েলীয়দেরকে বলবে, তোমাদের লোকদের বংশানুক্রমে আমার থেকে এটি পবিত্র অভিষেকের জন্য তেল হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","এটি মানুষের গায়ে লাগানো যাবে না; আর না তোমরা সেই জিনিসের পরিমাণ অনুসারে সেরকম অন্য কোন তেল তৈরী করবে; কারণ এটি পবিত্র এবং আমার অর্থাৎ সদাপ্রভুর জন্য সংরক্ষিত। ");
INSERT INTO benirv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","যে কেউ এই তেলের মত সুগন্ধি তেল তৈরী করে ও যে কেউ অন্য কারুর গায়ে কিছুটা লাগিয়ে দেয়, সে নিজের লোকজনের মধ্য থেকে বিচ্ছিন্ন হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","সদাপ্রভু মোশিকে বললেন, “তুমি নিজের কাছে সুগন্ধি মশালা নেবে, গুগ্গুলু, নখী, কুন্দুরু; এই সব সুগন্ধি মশালার ও খাঁটি লবানের প্রত্যেকটি সমান ভাগে ভাগ করে নেবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","এইগুলি দিয়ে গন্ধবণিকের প্রক্রিয়া মতো তৈরী এবং লবণ মিশিয়ে এক খাঁটি ও পবিত্র এবং আমার জন্য সংরক্ষিত সুগন্ধ ধূপ তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","তুমি এইগুলি একটি ভালো চূর্ণ যন্ত্রে চূর্ণ করবে। এর কিছুটা নিয়ে যে সমাগম তাঁবুতে আমি তোমার সঙ্গে দেখা করব তার মধ্যে সাক্ষ্য সিন্দুকের সামনে সেগুলি রাখবে; আর তোমরা এটিকে অতি পবিত্র বলে মনে করবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","আর যেমন তোমরা সুগন্ধি ধূপ তৈরী করবে, তোমরা সেই জিনিসের পরিমাণ অনুসারে নিজেদের জন্য তা কোরো না। এটি তোমার কাছে মহা পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","যে কেউ সুগন্ধির জন্য তার মত ধূপ তৈরী করবে, সে নিজের লোকদের থেকে বিচ্ছিন্ন হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“দেখ, আমি যিহূদা বংশের হূরের নাতি ঊরির ছেলে বৎসলেলের নাম ধরে ডাকলাম। ");
INSERT INTO benirv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","আর আমি তাকে ঈশ্বরের আত্মায়, জ্ঞানে, বুদ্ধিতে, বিদ্যায় ও সব রকম শিল্প কৌশলে পরিপূর্ণ করলাম; ");
INSERT INTO benirv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","যাতে সে শিল্পের নকশা করতে পারে, সোনা, রূপা ও পিতলের কাজ করতে পারে, ");
INSERT INTO benirv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","পাথর কেটে আকার দিতে, কাঠ খোদাই করতে ও সব রকম কারিগরী শিল্প করতে পারে। ");
INSERT INTO benirv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","আর দেখ, আমি দান বংশের অহীষামকের ছেলে অহলীয়াবকে তার সহকারী করে দিলাম এবং সমস্ত জ্ঞানী লোকের অন্তরে জ্ঞান দিলাম; সুতরাং আমি তোমাকে যা যা আদেশ করেছি, সে সমস্ত তারা তৈরী করবে; ");
INSERT INTO benirv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","সমাগম তাঁবু, সাক্ষ্য সিন্দুক ও সাক্ষ্য সিন্দুকের উপরের প্রতিবিধান এবং তাঁবুর সমস্ত পাত্র; ");
INSERT INTO benirv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","আর টেবিল ও তার সব পাত্র, পরিষ্কার বাতিদান ও তার সব পাত্র এবং ধূপবেদি; ");
INSERT INTO benirv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","আর হোমবেদি ও তার সব পাত্র এবং তলদেশ সহ বড় গামলা। ");
INSERT INTO benirv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","এবং সূক্ষ্মশিল্পিত বস্ত্র, যাজকের কাজ করার জন্য হারোণ যাজকের পবিত্র পোশাক, তার ছেলেদের পোশাক ");
INSERT INTO benirv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","এবং অভিষেকের তেল ও পবিত্র স্থানের জন্য সুগন্ধি ধূপ; আমি তোমাকে যেমন আদেশ দিয়েছি, সেই অনুসারে তারা সমস্তই করবে।” ");
INSERT INTO benirv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","আর সদাপ্রভু মোশিকে বললেন, “তুমি ইস্রায়েল সন্তানদের আরও এই কথা বলো, ");
INSERT INTO benirv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","‘তোমরা অবশ্যই আমার বিশ্রামদিন পালন করবে; কারণ তোমাদের বংশপরম্পরা অনুসারে আমার ও তোমাদের মধ্যে এটা এক চিহ্ন হয়ে থাকলো, যেন তোমরা জানতে পারো যে, আমিই তোমাদের পবিত্র করার সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","সুতরাং তোমরা বিশ্রামদিন পালন করবে, কারণ তোমাদের জন্য সেই দিন পবিত্র; যে কেউ সেই দিন অপবিত্র করবে, তার অবশ্যই প্রাণদণ্ড হবে; কারণ যে কেউ ঐ দিনের কাজ করবে, সে তার লোকদের মধ্যে থেকে উচ্ছিন্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ছদিন কাজ করবে, কিন্তু সপ্তম দিন সদাপ্রভুর উদ্দেশ্যে বিশ্রামের জন্য পবিত্র বিশ্রামদিন, সেই বিশ্রামদিনের যে কেউ কাজ করবে, তার অবশ্যই প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","অতএব ইস্রায়েল সন্তানরা চিরদিনের ব্যবস্থা হিসাবে বংশের পরম্পরা অনুসারে বিশ্রামদিন রক্ষা করার জন্য বিশ্রামদিন পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","আমার ও ইস্রায়েল সন্তানদের মধ্যে এটা চিরকালীন চিহ্ন; কারণ সদাপ্রভু ছদিনের আকাশমণ্ডল ও পৃথিবী সৃষ্টি করেছিলেন, আর সপ্তম দিনের বিশ্রাম করেছিলেন এবং ঝালিয়ে নিয়েছিলেন’।” ");
INSERT INTO benirv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","পরে তিনি সীনয় পর্বতে মোশির সঙ্গে কথা শেষ করে সাক্ষ্যের দুটি ফলক, ঈশ্বরের আঙ্গুল দিয়ে লেখা দুটি পাথরের ফলক, তাঁকে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","পর্বত থেকে নামতে মোশির দেরী হচ্ছে দেখে লোকেরা হারোণের কাছে জড়ো হয়ে তাঁকে বলল, “উঠুন, আমাদের এগিয়ে যাবার জন্য আমাদের দেবতা তৈরী করুন, কারণ যে মোশি মিশর দেশ থেকে আমাদেরকে বের করে এনেছেন, তাঁর কি হল, তা আমরা জানি না।” ");
INSERT INTO benirv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","তখন হারোণ তাদেরকে বললেন, “তোমরা তোমাদের স্ত্রী ও ছেলে মেয়েদের কানের সোনা খুলে আমার কাছে আনো”। ");
INSERT INTO benirv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","তাতে সমস্ত লোক তাদের কান থেকে সোনা খুলে হারোণের কাছে আনল। ");
INSERT INTO benirv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","তখন তিনি তাদের হাত থেকে সোনা গ্রহণ করে কারুকার্য করলেন এবং একটি ছাঁচে ঢালা বাছুর তৈরী করলেন; তখন লোকেরা বলতে লাগল, “হে ইস্রায়েল, এই তোমার দেবতা, যিনি মিশর দেশ থেকে তোমাকে বের করে এনেছেন”। ");
INSERT INTO benirv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","আর হারোণ তা দেখে তার সামনে একটি বেদি তৈরী করলেন এবং হারোণ ঘোষণা করে বললেন, “কাল সদাপ্রভুর উদ্দেশ্যে উৎসব হবে।” ");
INSERT INTO benirv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","আর লোকেরা পরদিন ভোরে উঠে হোমবলি উৎসর্গ করল এবং মঙ্গলার্থক নৈবেদ্য আনল; আর লোকেরা ভোজন পান করতে বসল, পরে উল্লাস করতে উঠল। ");
INSERT INTO benirv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","তখন সদাপ্রভু মোশিকে বললেন, “তুমি নেমে যাও, কারণ তোমার যে লোকদেরকে তুমি মিশর থেকে বের করে এনেছ, তারা নষ্ট হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","আমি তাদেরকে যে পথে চলার আদেশ দিয়েছি তারা শীঘ্রই সেই পথ থেকে ফিরেছে; তারা তাদের জন্য এক ছাঁচে ঢালা বাছুর তৈরী করে তার কাছে প্রণাম করেছে এবং তার উদ্দেশ্যে বলিদান করেছে ও বলেছে, ‘হে ইস্রায়েল, এই তোমার দেবতা, যিনি মিশর দেশ থেকে তোমাকে বের করে এনেছেন’।” ");
INSERT INTO benirv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","সদাপ্রভু মোশিকে আরও বললেন, “আমি সেই লোকেদেরকে দেখলাম; দেখ, তারা একগুঁয়ে জাতি। ");
INSERT INTO benirv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","এখন তুমি আমাকে থামাতে চেষ্টা কর না, তাদের বিরুদ্ধে আমার ক্রোধ প্রকট হোক, আমি তাদেরকে হত্যা করব, তখন আমি তোমার থেকে এক বড় জাতি তৈরী করব।” ");
INSERT INTO benirv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","কিন্তু মোশি তাঁর ঈশ্বর সদাপ্রভুকে অনুরোধ করে বললেন, “হে সদাপ্রভু, তোমার যে প্রজাদেরকে তুমি ক্ষমতাবান ও শক্তিশালী হাত দিয়ে মিশর দেশ থেকে বের করে এনেছ, তাদের বিরুদ্ধে তোমার ক্রোধ কেন প্রকট হবে? ");
INSERT INTO benirv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","মিশরীয়েরা কেন বলবে, ক্ষতি করার জন্য, পার্বত্য অঞ্চলে তাদেরকে নষ্ট করতে ও পৃথিবী থেকে লোপ করতে, তিনি তাদেরকে বের করে এনেছেন? তুমি নিজের প্রচণ্ড ক্রোধ থামাও ও তোমার প্রজাদের শাস্তির বিষয়ে ক্ষান্ত হও। ");
INSERT INTO benirv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","তুমি নিজের দাস অব্রাহাম, ইস্‌হাক ও যাকোবকে স্মরণ কর, যাদের কাছে তুমি নিজের নামের শপথ করে বলেছিলে, ‘আমি আকাশের তারাদের মত তোমাদের বংশ বৃদ্ধি করব এবং এই যে সমস্ত দেশের কথা বললাম এগুলি তোমাদের বংশকে দেব, তারা চিরকালের জন্য এটা অধিকার করবে’।” ");
INSERT INTO benirv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","তখন সদাপ্রভু তাঁর প্রজাদের যে অনিষ্ট করার কথা বলেছিলেন, তা আর করলেন না। ");
INSERT INTO benirv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","পরে মোশি মুখ ফেরালেন, সাক্ষ্যের সেই দুই পাথরের ফলক হাতে নিয়ে পর্বত থেকে নামলেন; সেই পাথরের ফলকের এপিঠ ওপিঠ দুপিঠেই লেখা ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","সেই পাথরের ফলক ঈশ্বরের তৈরী এবং সেই লেখা ঈশ্বরের লেখা, ফলকে খোদাই করা। ");
INSERT INTO benirv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","পরে যিহোশূয় কোলাহলকারী লোকেদের রব শুনে মোশিকে বললেন, “শিবিরে যুদ্ধের শব্দ হচ্ছে”। ");
INSERT INTO benirv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","তিনি বললেন, “ওটা তো জয়ধ্বনির শব্দ নয়, পরাজয়ধ্বনিরও শব্দ নয়; আমি গানের শব্দ শুনতে পাচ্ছি।” ");
INSERT INTO benirv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","পরে তিনি শিবিরের কাছাকাছি এলে ঐ বাছুর এবং নাচ দেখতে পেলেন; তাতে মোশি ক্রোধে জ্বলে উঠে পর্বতের নিচে তাঁর হাত থেকে সেই দুটি পাথরের ফলক ছুঁড়ে ভেঙে ফেললেন। ");
INSERT INTO benirv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","আর তাদের তৈরী বাছুর নিয়ে আগুনে পুড়িয়ে দিলেন এবং তা ধূলোর মত পিষে জলের উপরে ছড়িয়ে ইস্রায়েল সন্তানদের পান করালেন। ");
INSERT INTO benirv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","পরে মোশি হারোণকে বললেন, “ঐ লোকেরা তোমার কি করেছিল যে, তুমি তাদের দিয়ে এত বড় পাপ করালে?” ");
INSERT INTO benirv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","হারোণ বললেন, “আমার প্রভুর ক্রোধ প্রকট না হোক। আপনি লোকেদেরকে জানেন যে, তারা দুষ্টতায় পূর্ণ। ");
INSERT INTO benirv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","তারা আমাকে বলল, ‘আমাদের এগিয়ে নিয়ে যাবার জন্য আমাদের দেবতা তৈরী করুন, কারণ যে মোশি মিশর দেশ থেকে আমাদেরকে বের করে এনেছিল, তাঁর কি হল, তা আমরা জানি না’।” ");
INSERT INTO benirv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","তখন আমি বললাম, “তোমাদের মধ্যে যার যে সোনা আছে, সে তা খুলে দিক; তারা আমাকে দিল; পরে আমি তা আগুনে ছুঁড়ে ফেললে ঐ বাছুরটি বেরিয়ে এল।” ");
INSERT INTO benirv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","পরে মোশি দেখলেন, লোকেরা স্বেচ্ছাচারী হয়েছে, কারণ হারোণ শত্রুদের মধ্যে বিদ্রূপের জন্য তাদেরকে স্বেচ্ছাচারী হতে দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","তখন মোশি শিবিরের দরজায় দাঁড়িয়ে বললেন, “সদাপ্রভুর পক্ষে কে? সে আমার কাছে আসুক।” তাতে লেবির সন্তানেরা সবাই তাঁর কাছে জড়ো হল। ");
INSERT INTO benirv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","তিনি তাদের বললেন, “সদাপ্রভু, ইস্রায়েলের ঈশ্বর, এই কথা বলেন, ‘তোমরা প্রত্যেক জন নিজেদের ঊরুতে তরোয়াল বাঁধ, শিবিরের মধ্যে দিয়ে এক দরজা থেকে অন্য দরজা পর্যন্ত যাতায়াত করো এবং প্রতিজন নিজের নিজের ভাই, বন্ধু ও প্রতিবেশীকে হত্যা কর’।” ");
INSERT INTO benirv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","তাতে লেবির সন্তানেরা মোশির বাক্য অনুসারে সেই রকম করল, আর সেই দিন লোকদের মধ্যে কমপক্ষে তিন হাজার লোক মারা পড়ল। ");
INSERT INTO benirv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","কারণ মোশি বলেছিলেন, “আজ তোমরা প্রত্যেক জন নিজেদের ছেলে ও ভাইয়ের বিপক্ষ হয়ে সদাপ্রভুর উদ্দেশ্যে নিজেদের হস্তপূরণ কর, তাতে তিনি এই দিনের তোমাদেরকে আশীর্বাদ করবেন।” ");
INSERT INTO benirv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","পরদিন মোশি লোকদেরকে বললেন, “তোমরা খুব বড় পাপ করলে, এখন আমি সদাপ্রভুর কাছে উঠে যাচ্ছি; যদি সম্ভব হয়, তোমাদের পাপের প্রায়শ্চিত্ত করব।” ");
INSERT INTO benirv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","পরে মোশি সদাপ্রভুর কাছে ফিরে গিয়ে বললেন, “হায় হায়, এই লোকেরা খুব পাপ করেছে, নিজেদের জন্য সোনার দেবতা তৈরী করেছে। ");
INSERT INTO benirv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","আহা। এখন এদের পাপ ক্ষমা কর; আর যদি না কর, তবে আমি অনুরোধ করছি, তোমার লেখা বই থেকে আমার নাম কেটে ফেল।” ");
INSERT INTO benirv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","তখন সদাপ্রভু মোশিকে বললেন, “যে ব্যক্তি আমার বিরুদ্ধে পাপ করেছে, তারই নাম আমি নিজের বই থেকে কেটে ফেলব। ");
INSERT INTO benirv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","এখন যাও, আমি যে দেশের বিষয়ে তোমাকে বলেছি, সেই দেশে লোকেদের নিয়ে যাও; দেখ, আমার দূত তোমার আগে আগে যাবেন, কিন্তু যেদিন আমি তাদের শাস্তি দেব, আমি তাদের পাপের জন্য শাস্তি দেব।” ");
INSERT INTO benirv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","সদাপ্রভু লোকেদেরকে আঘাত করলেন, কারণ লোকেরা হারোণকে দিয়ে সেই বাছুর তৈরী করিয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","আর সদাপ্রভু মোশিকে বললেন, “আমি অব্রাহামের, ইসহাকের ও যাকোবের কাছে দিব্যি করে যে দেশ তাদের বংশকে দিতে প্রতিজ্ঞা করেছিলাম, সেই দেশে যাও, তুমি মিশর থেকে যে লোকেদেরকে বের করে এনেছ, তাদের সঙ্গে এখান থেকে চলে যাও। ");
INSERT INTO benirv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","আমি তোমার আগে আগে এক দূত পাঠিয়ে দেবো এবং কনানীয়, ইমোরীয়, হিত্তীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়কে দূর করে দেব। ");
INSERT INTO benirv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","যে দেশে দুধ ও মধু প্রবাহিত হয়, সেই দেশে যাও; কিন্তু আমি তোমার সাথে যাব না, কারণ তুমি একগুঁয়ে জাতি; হয়তো পথের মধ্যেই তোমাকে হত্যা করি।” ");
INSERT INTO benirv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","এই অশুভ বাক্য শুনে লোকেরা শোক করল, কেউ গায়ে কোনো গয়না পরল না। ");
INSERT INTO benirv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","সদাপ্রভু মোশিকে বলেছিলেন, “তুমি ইস্রায়েল সন্তানদের এই কথা বল, ‘তোমরা একগুঁয়ে জাতি, এক নিমেষের জন্য তোমাদের মধ্যে গেলে আমি তোমাদেরকে হত্যা করতে পারি; তোমরা এখন নিজেদের গা থেই কে গয়না দূর কর, তাতে জানতে পারব, তোমাদের জন্য আমার কি করা কর্তব্য’।” ");
INSERT INTO benirv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","তখন ইস্রায়েল সন্তানরা হোরেব পর্বত থেকে যাত্রাপথে নিজেদের সমস্ত গয়না দূর করল। ");
INSERT INTO benirv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","আর মোশি তাঁবু নিয়ে শিবিরের বাইরে ও শিবির থেকে দূরে স্থাপন করলেন এবং সেই তাঁবুর নাম সমাগম তাঁবু রাখলেন; আর সদাপ্রভুর খোঁজকারী প্রত্যেক জন শিবিরের বাইরে থাকা সেই সমাগম তাঁবুর কাছে যেত। ");
INSERT INTO benirv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","আর মোশি যখন বের হয়ে সেই তাঁবুর কাছে যেতেন, তখন সমস্ত লোক উঠে প্রত্যেকে নিজেদের তাঁবুর দরজায় দাঁড়াত এবং যতক্ষণ মোশি ঐ তাঁবুতে প্রবেশ না করতেন, ততক্ষণ তাঁর পিছনের দিকে তাকিয়ে থাকত। ");
INSERT INTO benirv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","আর মোশি তাঁবুতে প্রবেশ করার পর মেঘস্তম্ভ নেমে তাঁবুর দরজায় অবস্থান করত এবং সদাপ্রভু মোশির সঙ্গে আলাপ করতেন। ");
INSERT INTO benirv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","সমস্ত লোক তাঁবুর দরজায় অবস্থিত মেঘস্তম্ভ দেখত ও সমস্ত লোক উঠে প্রত্যেকে নিজেদের তাঁবুর দরজায় থেকে প্রণাম করত। ");
INSERT INTO benirv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","আর মানুষ যেমন বন্ধুর সঙ্গে আলাপ করে, সেইভাবে সদাপ্রভু মোশির সঙ্গে সামনা সামনি হয়ে আলাপ করতেন। পরে মোশি শিবিরে ফিরে আসতেন, কিন্তু নূনের ছেলে যিহোশূয় নামে তাঁর যুবক পরিচারক তাঁবুর মধ্যে থেকে বাইরে যেতেন না। ");
INSERT INTO benirv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","আর মোশি সদাপ্রভুকে বললেন, “দেখ, তুমি আমাকে বলছ, ‘এই লোকেদেরকে নিয়ে যাও’, কিন্তু আমার সঙ্গী করে যাকে পাঠাবে, তাঁর পরিচয় আমাকে দাও নি; তুমি বলেছ, ‘আমি তোমাকে নামে জানি এবং তুমি আমার কাছে অনুগ্রহ পেয়েছ।’ ");
INSERT INTO benirv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ভাল, আমি যদি তোমার কাছে অনুগ্রহ পেয়ে থাকি, তবে অনুরোধ করি, আমি যেন তোমাকে জেনে তোমার কাছে অনুগ্রহ পাই, এই জন্য আমাকে তোমার সমস্ত পথ জানাও এবং এই জাতি যে তোমার প্রজা, এটা বিবেচনা কর।” ");
INSERT INTO benirv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","তখন তিনি তাঁকে বললেন, “আমার উপস্থিতি তোমার সঙ্গে থাকবে এবং আমি তোমাকে বিশ্রাম দেবো।” ");
INSERT INTO benirv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","তাতে তিনি তাঁকে বললেন, “তোমার উপস্থিতি যদি সঙ্গে না থাকে, তবে এখান থেকে আমাদেরকে নিয়ে যেও না। ");
INSERT INTO benirv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","কারণ আমি ও তোমার এই প্রজারা যে তোমার কাছে অনুগ্রহ পেয়েছি, এটা কিভাবে জানা যাবে? আমাদের সঙ্গে তোমার যাওয়ার মাধ্যমে কি নয়? তার মাধ্যমেই আমি ও তোমার প্রজারা পৃথিবীর অন্য সমস্ত জাতি থেকে আলাদা।” ");
INSERT INTO benirv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","পরে সদাপ্রভু মোশিকে বললেন, “এই যে কথা তুমি বললে, সেটাও আমি করব, কারণ তুমি আমার চোখে অনুগ্রহ পেয়েছ এবং আমি তোমার নামে তোমাকে জানি।” ");
INSERT INTO benirv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","তখন তিনি বললেন, “অনুরোধ করি, তুমি আমাকে তোমার মহিমা দেখতে দাও।” ");
INSERT INTO benirv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ঈশ্বর বললেন, “আমি তোমার সামনে দিয়ে আমার সমস্ত ভালো বিষয় গমন করাবো ও তোমার সামনে সদাপ্রভুর নাম ঘোষণা করব; আর আমি যাকে দয়া করি, তাকে দয়া করব ও যার প্রতি করুণা করি, তার প্রতি করুণা করব।” ");
INSERT INTO benirv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","আরও বললেন, “তুমি আমার মুখ দেখতে পাবে না, কারণ মানুষ আমাকে দেখলে বাঁচতে পারে না।” ");
INSERT INTO benirv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","সদাপ্রভু বললেন, “দেখ, আমার কাছে একটি জায়গা আছে; তুমি ঐ পাথরের উপরে দাঁড়াবে। ");
INSERT INTO benirv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","তাতে তোমার কাছ দিয়ে আমার মহিমা যাওয়ার দিনের আমি তোমাকে শিলার এক ফাটলের মধ্যে রাখব ও আমার যাওয়ার শেষ পর্যন্ত হাত দিয়ে তোমাকে ঢেকে রাখব; ");
INSERT INTO benirv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","পরে আমি হাত তুললে তুমি আমার পিছন দিক দেখতে পাবে, কিন্তু আমার মুখ দেখতে পাওয়া যাবে না।” ");
INSERT INTO benirv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","পরে সদাপ্রভু মোশিকে বললেন, “তুমি প্রথম ফলকের মত দুটি পাথরের ফলক কাটো; প্রথম যে দুটি ফলক তুমি ভেঙে ফেলেছ, তাতে যা যা লেখা ছিল, সেই সব কথা আমি এই দুটি ফলকে লিখব। ");
INSERT INTO benirv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","আর তুমি সকালে প্রস্তুত হও, সকালে সীনয় পর্বতে উঠে আসবে ও সেখানে পর্বতের চূড়ায় আমার কাছে উপস্থিত হও। ");
INSERT INTO benirv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","কিন্তু তোমার সঙ্গে কোনো মানুষ উপরে না আসুক এবং এই পর্বতে কোথাও কোন মানুষ দেখা না যাক, আর পশুপালও এই পর্বতের সামনে না চরুক।” ");
INSERT INTO benirv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","পরে মোশি প্রথম পাথরের মত দুটি পাথরের ফলক কাটলেন এবং সদাপ্রভুর আদেশ অনুসারে সকালে উঠে সীনয় পর্বতের উপরে গেলেন ও সেই দুটি পাথরের ফলক হাতে করে নিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","তখন সদাপ্রভু মেঘে নেমে এসে সেখানে তাঁর সঙ্গে দাঁড়িয়ে সদাপ্রভুর নাম ঘোষণা করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","সদাপ্রভু তাঁর সামনে দিয়ে গেলেন ও এই ঘোষণা করলেন, “সদাপ্রভু, সদাপ্রভু, করুণাময় ও কৃপাবান ঈশ্বর, ক্রোধে ধীর এবং দয়াতে ও সত্যে মহান; ");
INSERT INTO benirv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","হাজার হাজার পুরুষ পর্যন্ত অনুগ্রহদানকারী, অপরাধের, খারাপ কাজের ও পাপের ক্ষমাকারী; তবুও তিনি অবশ্যই পাপের শাস্তি দেন; ছেলে নাতিদের উপরে, তৃতীয় ও চতুর্থ পুরুষ পর্যন্ত, তিনি বাবাদের অপরাধের শাস্তি দেন।” ");
INSERT INTO benirv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","তখন মোশি তাড়াতাড়ি মাটিতে মাথা নত করলেন এবং আরাধনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","তখন তিনি বললেন, “হে প্রভু, যদি এখন আমি আপনার কাছে অনুগ্রহ পেয়ে থাকি, তবে আমাদের মধ্যে দিয়ে যান, কারণ এই জাতি একগুঁয়ে। আমাদের অপরাধ ও পাপ সকল ক্ষমা করুন এবং আমাদের আপনার উত্তরাধিকারী হিসাবে গ্রহণ করুন।” ");
INSERT INTO benirv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","তখন তিনি বললেন, “দেখ, আমি এক চুক্তি করি; সমস্ত পৃথিবীতে ও যাবতীয় জাতির মধ্যে যা কখনও করা হয়নি, এমন আশ্চর্য্য কাজ আমি তোমার সমস্ত লোকের সামনে করব; তাতে যে সব লোকের মধ্যে তুমি আছ, তারা সদাপ্রভুর কাজ দেখবে, কারণ তোমার কাছে যা করব, তা ভয়ঙ্কর। ");
INSERT INTO benirv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","আজ আমি তোমাকে যা আদেশ করি, তা মান্য কর; দেখ, আমি ইমোরীয়, কনানীয়, হিত্তীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়কে তোমার সামনে থেকে দূর করে দেব। ");
INSERT INTO benirv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","সাবধান, যে দেশে তুমি যাচ্ছ, সেই দেশবাসীদের সঙ্গে নিয়ম স্থির কোরো না, পাছে তা তোমার কাছে ফাঁদের মত হয়। ");
INSERT INTO benirv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","কিন্তু তোমরা তাদের বেদিগুলি ভেঙে ফেলবে, তাদের থামগুলি ভেঙে চূর্ণবিচূর্ণ করবে ও সেখানকার আশেরা মূর্তিগুলি কেটে ফেলবে। ");
INSERT INTO benirv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","তুমি অন্য দেবতার আরাধনা কোরো না, কারণ সদাপ্রভু নিজের গৌরব রক্ষণে উদ্যোগী নাম ধারন করেন; তিনি নিজের গৌরব রক্ষণে উদ্যোগী ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","তুমি সেখানকার অধিবাসীদের সঙ্গে নিয়ম করবে না; তারা ব্যভিচার করে এবং তারা নিজেদের দেবতাদের অনুগামী হয়ে নিজের দেবতাদের কাছে বলিদান করে এবং তারা তোমাকে বলির দ্রব্য খাওয়াবার জন্য তোমাকে আমন্ত্রণ জানাবে; ");
INSERT INTO benirv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","কিংবা তুমি তোমার ছেলেদের জন্য তাদের মেয়েদের গ্রহণ করবে এবং তাদের মেয়েরা ব্যভিচার করবে ও তোমার ছেলেদের নিজের দেবতাদের উপাসনা করিয়ে অবিশ্বস্ত করাবে। ");
INSERT INTO benirv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","তুমি তোমার জন্য ছাঁচে ঢালা কোন দেবতা তৈরী কোরো না। ");
INSERT INTO benirv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","তুমি খামির বিহীন রুটির উৎসব পালন করবে। আবীব মাসের যে নির্ধারিত দিনের যেরকম করতে আদেশ করেছি, সেই রকম তুমি সেই সাত দিন খামির বিহীন রুটি খাবে, কারণ সেই আবীব মাসে তুমি মিশর দেশ থেকে বের হয়ে এসেছিলে। ");
INSERT INTO benirv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","প্রথমজাত সবাই এবং গরু, ভেড়ার পালের মধ্যে প্রথমজাত পুরুষ পশু সমস্তই আমার। ");
INSERT INTO benirv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","প্রথমজাত গাধার পরিবর্তে তুমি ভেড়ার বাচ্চা দিয়ে তাকে মুক্ত করবে; যদি মুক্ত না কর, তবে তার ঘাড় ভাঙ্গবে। তোমার প্রথমজাত সব ছেলেগুলিকে তুমি মুক্ত করবে। আর কেউ খালি হাতে আমার সামনে আসবে না। ");
INSERT INTO benirv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","তুমি ছয়দিন পরিশ্রম করবে, কিন্তু সপ্তম দিনের বিশ্রাম করবে; চাষের ও ফসল কাটার দিনের ও বিশ্রাম করবে। ");
INSERT INTO benirv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","তুমি সাত সপ্তাহের উৎসব, অর্থাৎ কাটা গমের প্রথম ফলের উৎসব এবং বছরের শেষভাগে ফল সংগ্রহের উৎসব পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","বছরের মধ্যে তিনবার তোমাদের সমস্ত পুরুষ ইস্রায়েলের ঈশ্বর প্রভু সদাপ্রভুর সামনে উপস্থিত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","কারণ আমি তোমার সামনে থেকে জাতিদেরকে দূর করে দেব ও তোমার সীমানা বিস্তার করব এবং তুমি বছরের মধ্যে তিন বার তোমার ঈশ্বর সদাপ্রভুর সামনে উপস্থিত হবার জন্য গেলে তোমার জমিতে কেউ লোভ করবে না। ");
INSERT INTO benirv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","তুমি আমার বলির রক্ত খামিরযুক্ত খাদ্যের সঙ্গে উৎসর্গ করবে না ও নিস্তারপর্ব্বের উৎসবের বলিদ্রব্য সকাল পর্যন্ত রাখা যাবে না। ");
INSERT INTO benirv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","তুমি নিজের জমির প্রথম ফলের অগ্রিমাংশ তোমার ঈশ্বর সদাপ্রভুর গৃহে আনবে। তুমি ছাগলছানাকে তার মায়ের দুধে সিদ্ধ করবে না।” ");
INSERT INTO benirv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","আর সদাপ্রভু মোশিকে বললেন, “তুমি এই সব বাক্য লিপিবদ্ধ কর, কারণ আমি এই সব বাক্য অনুসারে তোমার ও ইস্রায়েলের সঙ্গে চুক্তি স্থির করলাম।” ");
INSERT INTO benirv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","সেই দিনের মোশি চল্লিশ দিন রাত সেখানে সদাপ্রভুর সঙ্গে থাকলেন, খাবার খেলেন না ও জল পান করলেন না। আর তিনি সেই দুটি পাথরে নিয়মের বাক্যগুলি অর্থাৎ দশ আজ্ঞা লিখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","পরে মোশি দুটি সাক্ষ্যপাথর হাতে নিয়ে সীনয় পর্বত থেকে নামলেন; যখন পর্বত থেকে নামলেন, তখন, সদাপ্রভুর সঙ্গে আলাপের দিন তার মুখের চামড়া যে উজ্জ্বল হয়েছিল, তা মোশি জানতে পারলেন না। ");
INSERT INTO benirv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","পরে যখন হারোণ ও সমস্ত ইস্রায়েল সন্তান মোশিকে দেখতে পেল, তখন দেখ, তার মুখের চামড়া উজ্জ্বল, আর তারা তাঁর কাছে আসতে ভয় পেল। ");
INSERT INTO benirv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","কিন্তু মোশি তাদেরকে ডাকলে হারোণ ও মণ্ডলীর শাসনকর্ত্তা সবাই তাঁর কাছে ফিরে আসলেন, আর মোশি তাদের সঙ্গে আলাপ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","তারপরে ইস্রায়েল সন্তানরা সবাই তাঁর কাছে আসল; তাতে তিনি সীনয় পর্বতে বলা সদাপ্রভুর আজ্ঞাগুলি সব তাদেরকে জানালেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","পরে তাদের সঙ্গে কথাবার্তা শেষ হলে মোশি তাঁর মুখে ঢাকা দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","কিন্তু মোশি যখন সদাপ্রভুর সঙ্গে কথা বলতে ভিতরে তাঁর সামনে যেতেন ও যখন বাইরে আসতেন, তখন সেই আবরণ খুলে রাখতেন; পরে যে সব আজ্ঞা পেতেন, বের হয়ে ইস্রায়েল সন্তানদের তা বলতেন। ");
INSERT INTO benirv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","মোশির মুখের চামড়া উজ্জ্বল, এটা ইস্রায়েল সন্তানরা তাঁর মুখের দিকে তাকিয়ে দেখত; কিন্তু পরে মোশি সদাপ্রভুর সঙ্গে কথা বলতে যে পর্যন্ত আবার না যেতেন, ততক্ষণ তাঁর মুখে আবার ঢাকা দিয়ে রাখতেন। ");
INSERT INTO benirv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","মোশি ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে জড়ো করে তাদেরকে বললেন, “সদাপ্রভু তোমাদেরকে এই সব বাক্য পালন করতে আদেশ দিয়েছেন, ");
INSERT INTO benirv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ছয় দিন কাজ করা যাবে, কিন্তু সপ্তম দিন তোমাদের জন্য পবিত্র দিন হবে; সেটা সদাপ্রভুর উদ্দেশ্যে সম্পূর্ণ বিশ্রামের জন্য বিশ্রামদিন হবে; যে কেউ সেই দিনের কাজ করবে, তার প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","তোমরা বিশ্রামদিনের তোমাদের কোন বাড়িতে আগুন জ্বালাবে না।” ");
INSERT INTO benirv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","মোশি ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","সদাপ্রভু এই আদেশ দিয়েছেন; তোমরা সদাপ্রভুর জন্য তোমাদের কাছ থেকে উপহার নাও; যার মনে ইচ্ছা হবে, সে সদাপ্রভুর উপহার হিসাবে এই সব দ্রব্য আনবে; ");
INSERT INTO benirv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","সোনা, রূপা ও পিতল এবং নীল, বেগুনে, লাল ও সাদা মসীনা সুতো ও ছাগলের লোম ");
INSERT INTO benirv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","এবং লাল রঙের ভেড়ার চামড়া ও শীলের চামড়া, শিটীম কাঠ ");
INSERT INTO benirv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","এবং প্রদীপের জন্য তেল, আর অভিষেকের তেল ও সুগন্ধি ধূপের জন্য সুগন্ধি ");
INSERT INTO benirv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","এবং এফোদের ও বুকপাটার জন্য গোমেদক মণি এবং আরও দামী পাথর। ");
INSERT INTO benirv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","আর তোমাদের প্রত্যেক জ্ঞানী লোকেরা এসে সদাপ্রভুর আদেশ মত সমস্ত বস্তু তৈরী করুক; ");
INSERT INTO benirv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","সমাগম তাঁবু, তাঁবু, তার ঢাকনা, হুক, তক্তা, খিল, স্তম্ভ ও ভিত্তি, ");
INSERT INTO benirv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","আর সিন্দুক ও তার বহন দণ্ড, পাপাবরণ ও আড়াল রাখার পর্দা। ");
INSERT INTO benirv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","টেবিল ও তার বহন দণ্ড ও সমস্ত পাত্র, দর্শন রুটি ");
INSERT INTO benirv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","এবং আলোর জন্য বাতিদানী ও তার পাত্রগুলি, প্রদীপ ও প্রদীপের জন্য তেল ");
INSERT INTO benirv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","এবং ধূপবেদি ও তার বহন দণ্ড এবং অভিষেকের তেল ও সুগন্ধি ধূপ, সমাগম তাঁবুর মধ্যে প্রবেশ দরজার পর্দা, ");
INSERT INTO benirv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","হোমবেদি, তার পিতলের জাল, বহন দণ্ড ও সমস্ত পাত্র এবং ধোয়ার পাত্র ও তার পায়া। ");
INSERT INTO benirv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","তারা উঠানের পর্দার সঙ্গে আনল তার স্তম্ভ ও ভিত্তি এবং উঠানের ফটকের পর্দা ");
INSERT INTO benirv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","এবং সমাগম তাঁবুর খুঁটি, উঠানের খুঁটি ও তাদের দড়ি। ");
INSERT INTO benirv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","তারা পবিত্র স্থানে পরিচর্য্যা করার জন্য সূক্ষ্ম বোনা পোশাক আনল, অর্থাৎ হারোণ যাজকের জন্য পবিত্র পোশাক ও যাজকের কাজ করার জন্য তার ছেলেদের পোশাক। ");
INSERT INTO benirv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","পরে ইস্রায়েল সন্তানদের সমস্ত মণ্ডলী মোশির সামনে থেকে চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","আর যাদের হৃদয়ে প্রবৃত্তি ও মনে ইচ্ছা হল, তারা সবাই সমাগম তাঁবু তৈরীর জন্য এবং সেই বিষয়ে সমস্ত কাজের ও পবিত্র পোশাকের জন্য সদাপ্রভুর উদ্দেশ্যে উপহার আনল। ");
INSERT INTO benirv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","পুরুষ ও স্ত্রী যত লোক মনে ইচ্ছা করল, তারা সবাই এসে বলয়, কানবালা, অঙ্গুরীয় ও হার, সোনার সব রকম গয়না আনল। যে কেউ সদাপ্রভুর উদ্দেশ্যে সোনার উপহার আনতে চাইল, সে আনল। ");
INSERT INTO benirv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","আর যাদের কাছে নীল, বেগুনে, লাল ও সাদা মসীনা সুতো, ছাগলের লোম, লাল রঙের ভেড়ার চামড়া ও দামী চামড়া ছিল, তারা সবাই তা আনল। ");
INSERT INTO benirv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","যে কেউ রূপা ও পিতলের উপহার উপস্থিত করল, সে সদাপ্রভুর উদ্দেশ্যে সেই উপহার আনল এবং যার কাছে কোন কাজে লাগানোর জন্য শিটীম কাঠ ছিল, সে তাই আনল। ");
INSERT INTO benirv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","আর দক্ষ স্ত্রীলোকেরা তাদের হাতে সুতো কেটে, তাদের কাটা নীল, বেগুনে, লাল ও সাদা মসীনা সুতো আনল। ");
INSERT INTO benirv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","সমস্ত স্ত্রীলোক যাদের হৃদয় তাদেরকে আলোড়িত করল এবং যারা দক্ষতায় পরিপূর্ণ তারা ছাগলের লোমের সুতো কাটল। ");
INSERT INTO benirv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","আর অধ্যক্ষরা এফোদের ও বুকপাটার জন্য গোমেদক মণি ");
INSERT INTO benirv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","এবং দীপের, অভিষেকের তেলের ও সুগন্ধি ধূপের জন্য গন্ধদ্রব্য ও তেল আনলেন। ");
INSERT INTO benirv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ইস্রায়েল সন্তানরা ইচ্ছাকৃত সদাপ্রভুর উদ্দেশ্যে উপহার আনল, সদাপ্রভু মোশিকে দিয়ে যা যা করতে আদেশ করেছিলেন, তার কোন রকম কাজ করার জন্য যে পুরুষ ও স্ত্রীলোকদের হৃদয়ের ইচ্ছা হল, তারা সবাই উপহার আনল। ");
INSERT INTO benirv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","পরে মোশি ইস্রায়েল সন্তানদের বললেন, “দেখ, সদাপ্রভু যিহূদা বংশীয় হূরের নাতি ঊরির ছেলে বৎসলেলের নাম ধরে ডাকলেন; ");
INSERT INTO benirv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","আর তিনি তাকে ঈশ্বরের আত্মায়, জ্ঞানে, বুদ্ধিতে, বিদ্যায় ও সর্বপ্রকার শিল্প কৌশলে পরিপূর্ণ করলেন, ");
INSERT INTO benirv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","যাতে তিনি কৌশলের কাজ কল্পনা করতে, সোনা, রূপা ও পিতলের কাজ করতে, ");
INSERT INTO benirv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","খোচিত মণি কাটতে, কাঠ খোদাই করতে ও সব রকম কৌশলযুক্ত শিল্প কাজ করতে পারেন। ");
INSERT INTO benirv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","এই সকলের শিক্ষা দিতে তার ও দান-বংশীয় অহীষামকের ছেলে অহলীয়াবের হৃদয়ে বাসনা দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","তিনি খোদাই করতে ও শিল্প কাজ করতে এবং নীল, বেগুনে, লাল ও সাদা মসীনা সুতোয় খোদাই কাজ করতে এবং তাঁতির কাজ করতে, অর্থাৎ যাবতীয় শিল্প কাজ ও চিত্রের কাজ করতে তাঁদের হৃদয় অভিজ্ঞতায় পরিপূর্ণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“সুতরাং সদাপ্রভুর সমস্ত আদেশ অনুসারে পবিত্র স্থানের সমস্ত কাজ কিভাবে করতে হবে, তা জানতে সদাপ্রভু বৎসলেল ও অহলীয়াব এবং আর যাদেরকে জ্ঞান ও বুদ্ধি দিয়েছেন, সেই সব জ্ঞানী লোকেরা কাজ করবেন।” ");
INSERT INTO benirv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","মোশি বৎসলেল ও অহলীয়াবকে এবং সদাপ্রভু যাঁদের হৃদয়ে জ্ঞান দিয়েছিলেন, সেই অন্য সমস্ত জ্ঞানী লোককে ডাকলেন, অর্থাৎ সেই সব কাজ করার জন্য উপস্থিত হতে যাদের মনে বাসনা হল, তাঁদেরকে ডাকলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","তাতে তাঁরা পবিত্র স্থানের সমস্ত কাজ সম্পন্ন করার জন্য ইস্রায়েল সন্তানদের আনা সমস্ত উপহার মোশির কাছ থেকে গ্রহণ করলেন। আর লোকেরা তখনও প্রতি সকালে তাঁর কাছে ইচ্ছাদত্ত উপহার আনছিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","তখন পবিত্র স্থানের সমস্ত কাজে নিযুক্ত থাকা সমস্ত বিজ্ঞ লোকেরা নিজেদের কাজ থেকে এসে মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“সদাপ্রভু কাজের জন্য যা যা করতে নির্দেশ করেছিলেন লোকেরা অনেক বেশি জিনিস আনছে।” ");
INSERT INTO benirv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","তাতে মোশি আদেশ দিয়ে শিবিরের সব জায়গায় এই ঘোষণা করলেন যে, “কেউ পবিত্র স্থানের জন্য আর উপহার প্রস্তুত না করুক।” তাতে লোকেরা উপহার আনা বন্ধ করে দিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","কারণ সমস্ত কাজ করার জন্য তাদের যথেষ্ট, এমন কি, প্রয়োজনের থেকে বেশি জিনিস ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","পরে সমস্ত দক্ষ কারিগর পাকানো সাদা মসীনা সুতো, নীল, বেগুনে ও লাল সুতো দিয়ে তৈরী দশটি পর্দার সমাগম তাঁবু তৈরী করলেন এবং সেই পর্দাগুলিতে দক্ষ শিল্পীর দিয়ে তৈরী করূবের আকৃতি ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","সব পর্দা দৈর্ঘ্যে আটাশ হাত ও সব পর্দা প্রস্থে চার হাত, সমস্ত পর্দা একই মাপের ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","তিনি তার পাঁচটি পর্দা একসাথে যোগ করলেন এবং অন্য পাঁচটি পর্দাও একসাথে যোগ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","তিনি জোড়ার জায়গায় প্রথম প্রান্তে পর্দার বালাতে নীল রঙের হূক করলেন এবং জোড়ার জায়গায় দ্বিতীয় প্রান্তে পর্দার বালাতেও সেই রকম করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","তিনি প্রথম পর্দাতে পঞ্চাশটি হূক লাগালেন এবং দ্বিতীয় পর্দার জোড়ার জায়গায় বালাতে পঞ্চাশটি হূক লাগালেন; সেই দুটি হূক একে অপরের মুখোমুখি হল। ");
INSERT INTO benirv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","পরে তিনি সোনার পঞ্চাশটি হূক তৈরী করে সেই হূকে সমস্ত পর্দা একে অপরের সঙ্গে জোড়া দিলেন; তাতে সমাগম তাঁবুটি এক হল। ");
INSERT INTO benirv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","পরে তিনি সমাগম তাঁবুর উপরের ঢাকনা হিসাবে তাঁবুর জন্য ছাগলের লোম দিয়ে পর্দাগুলি তৈরী করলেন; তিনি এগারোটি পর্দা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","তার প্রত্যেকটি পর্দা দৈঘ্যে ত্রিশ হাত ও প্রত্যেকটি পর্দা প্রস্থে চার হাত; এগারোটি পর্দা একই মাপের ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","পরে তিনি পাঁচটি পর্দা আলাদা জুড়লেন ও ছয়টি পর্দা আলাদা জুড়লেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","আর জোড়ার জায়গায় মাথায় পর্দার বালাতে পঞ্চাশটি হূক লাগালেন এবং দ্বিতীয় জোড়ার জায়গায় মাথায় পর্দার বালাতেও পঞ্চাশটি হূক লাগালেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","একসাথে জুড়ে একটিই তাঁবু করার জন্য পিতলের পঞ্চাশটি হূক তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","তিনি লাল রঙের ভেড়ার চামড়া দিয়ে তাঁবুর একটি ঢাকনা, আবার তার উপরে দামী চামড়ার অন্য একটি ঢাকনা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","তিনি সমাগম তাঁবুর জন্য শিটীম কাঠের লম্বা তক্তা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","এক একটি তক্তা দৈর্ঘ্যে দশ হাত ও প্রত্যেকটি তক্তা প্রস্থে দেড় হাত। ");
INSERT INTO benirv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","প্রত্যেকটি তক্তা একে অন্যের সঙ্গে যুক্ত থাকার জন্য দুটি করে পায়া ছিল; এই ভাবে তিনি সমাগম তাঁবুর সমস্ত তক্তা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","তিনি সমাগম তাঁবুর জন্য তক্তা তৈরী করলেন। তিনি দক্ষিণদিকের জন্য কুড়িটি তক্তা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","তিনি সেই কুড়িটি তক্তার নীচের জন্য রূপার চল্লিশটি ভিত্তি তৈরী করলেন, একটি তক্তার নীচে তার দুই পায়ার জন্য দুটি ভিত্তি এবং অন্য অন্য তক্তার নীচেও তাদের দুটি করে পায়ার জন্য দুটি করে ভিত্তি তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","তিনি সমাগম তাঁবুর দ্বিতীয় পাশের জন্য উত্তরদিকে কুড়িটি তক্তা করলেন ");
INSERT INTO benirv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ও সেইগুলির জন্য চল্লিশটি রূপার ভিত্তি তৈরী করলেন; এক তক্তার নীচে দুটি করে ভিত্তি ও অন্য অন্য তক্তার নীচেও দুটি করে ভিত্তি হল। ");
INSERT INTO benirv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","আর পশ্চিমদিকে সমাগম তাঁবুর পিছনের কোনের জন্য ছটি তক্তা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","তিনি সমাগম তাঁবুর সেই পিছনের কোনে দুটি তক্তা রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","সেই দুটি তক্তার নীচে যুক্ত ছিল, কিন্তু সেইভাবে ওপরের একই বালার সঙ্গে যুক্ত ছিল; এই একই ভাবে পিছনের উভয় কোনগুলি যুক্ত করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","তাতে আটটি তক্তা এবং রূপার ভিত্তি ছিল। সেখানে মোট ষোলটি ভিত্তি ছিল, প্রথম তক্তার নিচে দুটি ভিত্তি, পরের তক্তার নিচে দুটি ভিত্তি, সবগুলি এইভাবেই ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","তিনি শিটীম কাঠের খিল তৈরী করলেন-সমাগম তাঁবুর এক পাশের তক্তার জন্য পাঁচটি খিল, ");
INSERT INTO benirv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","সমাগম তাঁবুর অন্য পাশের তক্তার জন্য পাঁচটি খিল এবং পশ্চিমদিকে সমাগম তাঁবুর পিছন পাশের তক্তার জন্য পাঁচটি খিল। ");
INSERT INTO benirv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","আর মাঝখানের খিলটিকে তক্তাগুলির মধ্যে দিয়ে এক প্রান্ত থেকে অন্য প্রান্ত পর্যন্ত প্রসারিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","তিনি তক্তাগুলি সোনা দিয়ে মুড়ে দিলেন। তিনি তাদের বালাগুলি সোনা দিয়ে তৈরী করলেন এবং সোনার বালাগুলি খিলের ঘর হবার জন্য খিলগুলিও সোনা দিয়ে মুড়লেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","তিনি নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সুতো দিয়ে পর্দা তৈরী করলেন, তাতে দক্ষ কারিগর দিয়ে করূব আঁকলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","তিনি পর্দার জন্য শিটীম কাঠের চারটি স্তম্ভ তৈরী করলেন এবং সেগুলি সোনা দিয়ে মুড়ে দিলেন। তিনি স্তম্ভের জন্য সোনার হূক তৈরী করলেন এবং তার জন্য রূপার চারটি ভিত্তি ছাঁচে গড়লেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","তিনি তাঁবুর ফটকের জন্য নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সুতোর মাধ্যমে সূচির কাজ করা একটি পর্দা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","তিনি তার পাঁচটি স্তম্ভ ও সেগুলির হূক তৈরী করলেন। তিনি তাদের মাথা ও দন্ডগুলি সোনায় মুড়ে দিলেন। সেগুলির মধ্যে পাঁচটি ভিত্তি ব্রোঞ্জের তৈরী। ");
INSERT INTO benirv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","বৎসলেল শিটীম কাঠ দিয়ে সিন্দুক তৈরী করলেন। সেটা দৈর্ঘ্যে আড়াই হাত, প্রস্থে দেড় হাত ও উচ্চতায় দেড় হাত করা হল। ");
INSERT INTO benirv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","তিনি ভিতর দিক ও বাইরের দিক বিশুদ্ধ সোনা দিয়ে মুড়ে দিলেন এবং তার চারিদিকে সোনার পাত দিয়ে মুড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","তার চারটি পায়ার জন্য সোনার চারটি বালা ছাঁচে গড়লেন; তার এক পাশে দুটি বালা ও অন্য পাশে দুটি বালা লাগালেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","তিনি শিটীম কাঠের দুটি বহন-দণ্ড তৈরী করে সোনা দিয়ে মুড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","তিনি সিন্দুক বয়ে নিয়ে যাওয়ার জন্য ঐ বহন-দণ্ডগুলি সিন্দুকের দুই পাশের বালাতে প্রবেশ করালেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","তিনি খাঁটি সোনা দিয়ে পাপাবরণ তৈরী করলেন; যেটা দৈর্ঘ্যে আড়াই হাত ও প্রস্থে দেড় হাত হল। ");
INSERT INTO benirv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","তিনি পেটাই করা সোনা দিয়ে দুটি করূব তৈরী করে পাপাবরণের শেষ দুই প্রান্তে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","তার এক প্রান্তে একটি করূব ও অন্য প্রান্তে অন্য করূব, তাদেরকে পাপাবরণের দুই প্রান্তে অবিচ্ছিন্ন করে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","সেই দুই করূব উপরের দিকে ডানা মেলে থাকল এবং তাদের দিয়ে পাপাবরণ ঢেকে রাখল। তাদের মুখ একে অপরের দিকে থাকল; করূবগুলি পাপাবরণের দিকে চেয়ে থাকলো। ");
INSERT INTO benirv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","তিনি শিটীম কাঠ দিয়ে টেবিল তৈরী করলেন; যেটা দৈর্ঘ্যে দুই হাত, প্রস্থে এক হাত ও উচ্চতায় দেড় হাত করা হল। ");
INSERT INTO benirv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","তিনি বিশুদ্ধ সোনা দিয়ে এটা মুড়ে দিলেন ও তার চারদিকে বিশুদ্ধ সোনার পাত দিয়ে মুড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","তিনি তার জন্য চারদিকে চার আঙ্গুলের মাপের একটি কাঠামো তৈরী করলেন ও কাঠামোর চারিদিকে বিশুদ্ধ সোনার পাত দিয়ে মুড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","তার জন্য সোনার চারটি বালা ছাঁচে তৈরী করে তার চারটি পায়ার চারটি কোণে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","সেই বালা কাঠামোর কাছে ছিল এবং টেবিল বয়ে নিয়ে যাওয়ার বহন-দণ্ডের ঘর হল। ");
INSERT INTO benirv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","তিনি টেবিল বয়ে নিয়ে যাবার জন্য শিটীম কাঠ দিয়ে দুটি বহন-দণ্ড তৈরী করে সোনা দিয়ে মুড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","টেবিলের উপরে থাকা সমস্ত পাত্র তৈরী করলেন-থালা, চামচ, বাটি ও কলসি উপহার ঢেলে রাখার জন্য। এইসব বিশুদ্ধ সোনা দিয়ে তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","তিনি খাঁটি পেটাই করা সোনা দিয়ে বাতিদানী তৈরী করলেন; তিনি যে বাতিদানিটি তৈরী করেছিলেন যার কাণ্ড, শাখা, পেয়ালা, কুঁড়ি ও ফুল তার সঙ্গে অবিচ্ছিন্ন ভাবে ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ছয়টি শাখা তার পাশ থেকে বেরিয়ে ছিল-এক পাশ থেকে তিনটি শাখা ও অন্য পাশ থেকে তিনটি শাখা। ");
INSERT INTO benirv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","প্রথম শাখায় বাদাম ফুলের একটি কুঁড়ি ও একটি ফুলের মত তিনটি পেয়ালা এবং অন্য শাখায় বাদাম ফুলের একটি কুঁড়ি ও একটি ফুলের মত তিনটি পেয়ালা। বাতিদানী থেকে এই ভাবে ছয়টি শাখা বেরিয়ে এল। ");
INSERT INTO benirv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","বাতিদানীতে বাদাম ফুলের কুঁড়ি ও ফুলের মত চারটি পেয়ালা ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","বাতিদানীর যে ছয়টি শাখা বেরিয়ে এল, সেগুলির প্রথম শাখা দুটির নীচে একটি অবিচ্ছিন্ন কুঁড়ি, অন্য শাখা দুটির নীচে একটি অবিচ্ছিন্ন কুঁড়ি ও অপর শাখা দুটির নীচে একটি কুঁড়ি ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","এই কুঁড়ি ও শাখা তার সঙ্গে অবিচ্ছিন্ন অবস্থায় ছিল এবং সমস্তই পেটাই করা বিশুদ্ধ সোনার তৈরী ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","তিনি বাতিদানী তৈরী করলেন এবং তার সাতটি প্রদীপ এবং তার চিমটা ও ট্রে খাঁটি সোনা দিয়ে তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","তিনি ঐ বাতিদানী এবং ঐ সমস্ত জিনিসপত্র এক তালন্ত পরিমাণের খাঁটি সোনা দিয়ে তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","তিনি শিটীম কাঠ দিয়ে ধূপবেদি তৈরী করলেন; সেটা দৈর্ঘ্যে এক হাত, প্রস্থে এক হাত ও চারকোনের উচ্চতা দুই হাত; তার শিংগুলি তার সঙ্গে অবিচ্ছিন্ন অবস্থায় ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","সেই ধূপবেদি, তার ওপরের ভাগ, তার চারপাশ ও তার শিংগুলি খাঁটি সোনা দিয়ে মুড়ে দিলেন এবং তার চারদিকে সোনার পাত লাগালেন। ");
INSERT INTO benirv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","তিনি পাতের নিচের দুই বিপরীত পাশে তার সঙ্গে যুক্ত দুটি সোনার বালা তৈরী করলেন। বালাগুলি ছিল বেদিটি বয়ে নিয়ে যাবার জন্য বহন দণ্ডের ধারক। ");
INSERT INTO benirv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","তিনি শিটীম কাঠ দিয়ে বহন দণ্ড তৈরী করলেন ও তাদের সোনা দিয়ে মুড়ে দিলেন। তেল ও ধুপের নির্মাণ (যাত্রা পুস্তক 13:22, 38) ");
INSERT INTO benirv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","তিনি সুগন্ধ জিনিসের ব্যবসায়ীর প্রক্রিয়া অনুযায়ী অভিষেকের পবিত্র তেল ও সুগন্ধি জিনিসের খাঁটি ধূপ তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","বত্সলেল শিটীম কাঠ দিয়ে হোমবেদি তৈরী করলেন; সেটা দৈর্ঘ্যে পাঁচ হাত, প্রস্থে পাঁচ হাত ও চারকোনের উচ্চতা তিন হাত করা হল। ");
INSERT INTO benirv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","তিনি তার চার কোণের উপরে কতকগুলি শিং তৈরী করলেন; সেই শিংগুলি বেদির সঙ্গে অবিচ্ছিন্ন অবস্থায় ছিল এবং তিনি সেগুলি ব্রোঞ্জ দিয়ে মুড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","তিনি বেদির সমস্ত পাত্র, অর্থাৎ হাঁড়ী, হাতা, বাটি, তিনটি কাঁটাযুক্ত দন্ড ও আগুন রাখা পাত্র, এই সমস্ত পাত্র ব্রোঞ্জ দিয়ে তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","বেদির জন্য বেড়ের নীচের অর্ধেক অংশ থেকে জালের কাজ করা ব্রোঞ্জের ঝাঁঝরী তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","তিনি সেই ব্রোঞ্জের ঝাঁঝরীর চার কোণের জন্য বহন-দণ্ডের ধারক হিসাবে চারটি বালা ছাঁচে গড়লেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","তিনি শিটীম কাঠ দিয়ে বহন দণ্ড তৈরী করে ব্রোঞ্জ দিয়ে মুড়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","তিনি বেদি বয়ে নিয়ে যাবার জন্য তার পাশের বালাগুলিতে ঐ বহন-দণ্ড পরালেন। তিনি তক্তা ছাড়াই বেদিটি ফাঁপা ভাবে তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","তিনি একটি ব্রোঞ্জের গামলার মত বড় পাত্র তার সঙ্গে ব্রোঞ্জের দানি তৈরী করলেন। তিনি সমাগম তাঁবুতে যে স্ত্রীলোকরা সেবার কাজে নিযুক্ত ছিল তাদের জন্য আয়না সেই পাত্রের বাইরের দিকে লাগালেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","তিনি ওঠান প্রস্তুত করলেন। উঠানের দক্ষিণদিকে পাকান সাদা মসীনা সুতোর একশো হাত পরিমাপের পর্দা ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","তার কুড়িটি স্তম্ভ ও কুড়িটি তলদেশের অংশ ব্রোঞ্জের ছিল। সেই স্তম্ভের হূক ও দন্ডগুলি ছিল রূপার। ");
INSERT INTO benirv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","উত্তর দিকের পর্দা একশো হাত ও তার কুড়িটি স্তম্ভ ও কুড়িটি তলদেশ ব্রোঞ্জের এবং স্তম্ভের হূক ও দন্ডগুলি রূপার ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","পশ্চিম দিকের পর্দা পঞ্চাশ হাত ও তার দশটি স্তম্ভ ও দশটি ভিত্তি এবং স্তম্ভের হূক ও দন্ডগুলি রূপার ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","উঠানটির পূর্বদিকের দৈর্ঘ্য ছিল পঞ্চাশ হাত। ");
INSERT INTO benirv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","প্রবেশপথের একদিকের জন্য পনেরো হাত পর্দা ছিল, তার তিনটি স্তম্ভ ও তিনটি ভিত্তি ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","উঠানের অন্য পাশের প্রবেশপথের জন্যও পনেরো হাত পর্দা ও তার তিনটি স্তম্ভ ও তিনটি ভিত্তি ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","উঠানের চারদিকের সমস্ত পর্দা পাকান সাদা মসীনা সুতোয় তৈরী। ");
INSERT INTO benirv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","স্তম্ভের ভিত্তিগুলি ব্রোঞ্জ দিয়ে তৈরী। স্তম্ভের হূক ও দন্ডগুলি রূপার ও তার ওপরের অংশও রূপা দিয়ে মোড়া এবং উঠানের সমস্ত স্তম্ভগুলি ছিল রূপার তৈরী। ");
INSERT INTO benirv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","উঠানের ফটকের পর্দা ছিল কুড়ি হাত। পর্দাটি নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সুতোয় সূচির কাজে তৈরী এবং তার দৈর্ঘ্য কুড়ি হাত, আর উঠানের পর্দার মত উচ্চতা ছিল পাঁচ হাত। ");
INSERT INTO benirv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","তার চারটি ব্রোঞ্জের ভিত্তি ও রূপার হূক ছিল। তাদের ওপরের অংশ ও দন্ড রূপা দিয়ে মোড়ানো ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","সমাগম তাঁবুর উঠানের চারিদিকের খুঁটিগুলি ছিল ব্রোঞ্জের। ");
INSERT INTO benirv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","সমাগম তাঁবুর, সাক্ষ্যের সমাগম তাঁবুর, দ্রব্য-সংখ্যার বিবরণ এই। মোশির আদেশ অনুসারে সেই সমস্ত করা হল। এটা লেবীয়দের কাজ হিসাবে হারোণ যাজকের ছেলে ঈথামরের নির্দেশ অনুযায়ী করা হল। ");
INSERT INTO benirv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","সদাপ্রভু মোশিকে যে আদেশ দিয়েছিলেন, সেই অনুসারে যিহূদা বংশের হূরের নাতি ঊরির ছেলে বৎসলেল সমস্তই তৈরী করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","দান বংশের অহীষামকের ছেলে অহলীয়াব তাঁর সহকারী ছিলেন; তিনি দক্ষ ও শিল্পকুশলী এবং নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সুতোর শিল্পকার ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","পবিত্র সমাগম তাঁবু তৈরীর সমস্ত কাজে এইসব সোনা লাগল, উপহারের সমস্ত সোনা পবিত্র স্থানের শেকল অনুসারে ঊনত্রিশ তালন্ত সাতশো ত্রিশ শেকল ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","মণ্ডলীর লোকদের রূপা পবিত্র জায়গার শেকল পরিমাপের অনুযায়ী একশো তালন্ত এবং এক হাজার সাতশো পঁচাত্তর শেকল ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","প্রত্যেক লোকের জন্য, অর্থাৎ যারা কুড়ি বছর বয়সী কিংবা তার থেকে বেশি বয়সী ছিল, সেই ছয় লক্ষ তিন হাজার সাড়ে পাঁচশো লোকের মধ্যে প্রত্যেক জনের জন্য এক এক বেকা, অর্থাৎ পবিত্র স্থানের শেকল অনুসারে অর্ধেক শেকল দিতে হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","সেই একশো তালন্ত রূপার পবিত্র স্থানের ভিত্তি ও পর্দার ভিত্তি ছাঁচে করা হয়েছিল; একশোটি ভিত্তি, প্রত্যেক ভিত্তির জন্য এক তালন্ত করে ব্যয় হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ঐ এক হাজার সাতশো পঁচাত্তর শেকলে তিনি সমস্ত স্তম্ভের জন্য হূক তৈরী করেছেন ও তাদের ওপরের অংশ মুড়েছেন ও তাদের জন্য দন্ড তৈরী করেছেন। ");
INSERT INTO benirv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","উপহারের ব্রোঞ্জ সত্তর তালন্ত দুই হাজার চারশো শেকল ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","সেটা দিয়ে তিনি সমাগম তাঁবুর প্রবেশপথের ভিত্তি, ব্রোঞ্জের বেদি ও ব্রোঞ্জের ঝাঁঝরী ও বেদির সমস্ত পাত্র ");
INSERT INTO benirv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","এবং উঠানের চারদিকের তলদেশ ও উঠানের প্রবেশপথের তলদেশ ও সমাগম তাঁবুর সমস্ত খুঁটি ও উঠানের চারদিকের খুঁটি তৈরী করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","তারা শেষ পর্যন্ত নীল, বেগুনে ও লাল সুতো দিয়ে পবিত্র জায়গায় পরিচর্য্যা করার জন্য সূক্ষ্ম শিল্পের কাজে পোশাক তৈরী করলেন। আর যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন, তারা হারোণের জন্য পবিত্র পোশাক তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","বত্সলেল সোনা দিয়ে এবং নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সূতো দিয়ে এফোদ তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","সাধারণত তাঁরা সোনা পিটিয়ে পাত তৈরী করে শিল্প কাজের মধ্য দিয়ে নীল, বেগুনে, লাল ও সাদা মসীনা সূতোর মধ্যে বুনবার জন্য তা কেটে তার তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","আর তাঁরা এফোদের জন্য দুটি পট্টি তৈরী করলেন এবং ঘাড়ের উপরে দুই কোনায় এটি জুড়ে দিলেন; ");
INSERT INTO benirv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","আর তা বন্ধ করবার জন্য শিল্প কার্যে বোনা কোমরবন্ধনী তার উপরে ছিল, এটি এফোদের সঙ্গে একত্রে তৈরী করা হয়েছে এবং সেই পোশাকের সমান ছিল, সেটি সোনা, নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সূতো দিয়ে তৈরী করা হয়েছিল; ঠিক যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","পরে তাঁরা খোদাই করা মুদ্রার মত ইস্রায়েলের বারোজন ছেলের নামে নকশা করা সোনা দিয়ে বাঁধিয়ে দুটি গোমেদক মণি আঁটকিয়ে ভিতরে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","আর এফোদের দুটি ঘাড়ের ফিতের উপরে ইস্রায়েলের বারোজন ছেলেদের স্মরণ করার জন্য মণিহিসাবে সেগুলি লাগালেন, যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","তিনি এফোদের কায়দায় সোনা দিয়ে এবং নীল, বেগুনে, লাল ও পাকান সাদা মসীনা সূতো দিয়ে দক্ষ্ শিল্পকারের মাধ্যমে একটি বুকপাটা তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","এটি চার কোণা ছিল; তাঁরা সেই বুকপাটাটি দুই ভাঁজ করে গুটিয়ে রাখলেন। এটি এক বিঘত লম্বা এবং এক বিঘত প্রস্থ করে ভাঁজ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","তা চার সারি মণি লাগিয়ে তৈরী করলেন। তার প্রথম সারিতে চুণী, পীতমণি ও মরকত ছিল, ");
INSERT INTO benirv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","দ্বিতীয় সারিতে পদ্মরাগ, নীলকান্ত ও হীরক ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","তৃতীয় সারিতে পেরোজ, যিস্ম এবং কটাহেলা ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","চতুর্থ সারিতে বৈদূর্য্য, গোমেদক ও সূর্য্যকান্ত মণি ছিল; এই মণিগুলি সোনা দিয়ে বাঁধানো হলো। ");
INSERT INTO benirv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","এই সকল মণি ইস্রায়েলের বারোজন ছেলের নাম অনুযায়ী হলো, প্রতিটি তাদের নামানুসারেই হল; মুদ্রার মত খোদাই করা প্রত্যেক মণিতে বারোটি বংশের জন্য এক একটি ছেলের নাম হল। ");
INSERT INTO benirv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","পরে তাঁরা বুকপাটার উপর খাঁটি সোনা দিয়ে মালার মত পাকান দুটি শিকল তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","তারা সোনার দুটি বিনুনি করা শিকল ও সোনার দুটি বালা তৈরী করলেন এবং বুকপাটার দুই ধারে সেই দুটি বালা লাগিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","তারা বুকপাটার দুটি কোনে দুটি বালার মধ্যে বিনুনি করা সোনার দুটি শিকল লাগালেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","পাকান শিকলের অন্য দুই মাথা দুই বিনুনির মত দুই শিকলের সঙ্গে বেঁধে এফোদের সামনের দিকে দুটি কাঁধের ফিতের উপরে লাগালেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","আর সোনার দুটি বালা তৈরী করে বুকপাটার দুই মাথায় ভিতরের অংশে এফোদের সামনের দিকে শেষ অংশে লাগালেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","পরে তারা সোনার দুটি বালা তৈরী করে এফোদের দুটি ঘাড়ের ফিতের নীচে তার সামনের অংশে তার জোড়ের জায়গায় এফোদের বিনুনি করা কোমরবন্ধনীর উপরে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","তারা বুকপাটা যেন এফোদের কোমরবন্ধনীর উপরে থাকে এবং এফোদ থেকে যেন খুলে না যায় সেই জন্য তাঁরা বালাতে নীল সূতো দিয়ে এফোদের বলার সঙ্গে বুকপাটা বেঁধে রাখলেন; ঠিক যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন তেমন এইগুলি করা হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","বত্সলেল এফোদের পোশাক সম্পূর্ণভাবে বুনে তৈরী করলেন, এটি তন্তু দিয়ে তৈরী ও সম্পূর্ণ নীল রঙের। ");
INSERT INTO benirv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","এটির মাঝখানে মাথার জন্য খোলা গলা ছিল। সেই খোলা জায়গাটি যাতে ছিঁড়ে না যায় সেই জন্য গলার চারদিকে বিনুনি করা ছিল। ");
INSERT INTO benirv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","আর তাঁরা সেই পোশাকের আঁচলে নীল, বেগুনে, ও লাল পাকান সূতোর ডালিম তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","পরে তাঁরা খাঁটি সোনার ঘন্টা তৈরী করলেন এবং সেই ঘন্টাগুলি ডালিমের মাঝখনে ও পোশাকের আঁচলের চারদিকে ডালিমের মাঝখানে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","সেবা করার পোশাকের আঁচলে চারদিকে একটি ঘন্টা ও একটি ডালিম, একটি ঘন্টা ও একটি ডালিম, এইরূপ করলেন; ঠিক যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","পরে তাঁরা হারোণ ও তাঁর ছেলেদের জন্য সাদা মসীনা সুতো দিয়ে গায়ের পোশাক তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","তারা সাদা মসীনা সুতো দিয়ে তৈরী উষ্ণীয় ও সাদা মসীনা সুতো দিয়ে তৈরী শিরোভূষন ও পাকান সাদা মসীনা সুতো দিয়ে তৈরী শুল্ক জাঙ্গিয়া তৈরী করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","এবং পাকান সাদা মসীনা সুতো দিয়ে এবং নীল, বেগুনে, ও লাল সূতো দিয়ে সূচের কাজ দ্বারা এক কোমরবন্ধন তৈরী করলেন। এইগুলি ঠিক যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন তেমন করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","পরে তাঁরা খাঁটি সোনা দিয়ে পবিত্র মুকুটের জন্য পাত তৈরী করলেন এবং খোদাই করা মুদ্রার মত তার উপরে লিখলেন, “সদাপ্রভুর উদ্দেশ্যে পবিত্র।” ");
INSERT INTO benirv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","পরে তারা পাগড়ির উপরে নীল সূতো দিয়ে সেটি বাঁধলেন; এটি করেছিলেন যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","সুতরাং এই ভাবে সমাগম তাঁবুর কাজ অর্থাৎ পবিত্র জায়গার কাজ গুলি শেষ হয়েছিল; ইস্রায়েলের লোকেরা সবই করেছিল। তারা মোশির প্রতি দেওয়া সদাপ্রভুর সব আদেশ মেনে কাজ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","পরে তারা মোশির কাছে তাঁবুটি এনেছিল এবং তারা তাঁবু এবং তাঁবু সংক্রান্ত সব জিনিস, এর ঘন্টা, তক্তা, খিল, স্তম্ভ ও ভিত্তি এনেছিল ");
INSERT INTO benirv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","রক্তের মত লাল রঙের ভেড়ার চামড়ার তৈরী ছাদ, শীলের চামড়ার তৈরী ছাদ এবং গোপন করার জন্য পর্দা, ");
INSERT INTO benirv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","এবং সাক্ষ্য সিন্দুক ও তা বহন করার জন্য দণ্ড এবং পাপাবরণ। ");
INSERT INTO benirv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","তারা টেবিল ও তার সব পাত্রগুলি এবং দর্শন রুটি আনলো, ");
INSERT INTO benirv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","খাঁটি সোনার তৈরী দীপদানি এবং সারিতে তার প্রদীপগুলি, এর সঙ্গে তার সব পাত্রগুলি এবং দীপের জন্য তেল; ");
INSERT INTO benirv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","সোনার বেদি, অভিষেকের তেল এবং সুগন্ধি ধূপ ও তাঁবুর দরজার জন্য পর্দা; ");
INSERT INTO benirv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ব্রোঞ্জের বেদি ও তার সঙ্গে ব্রোঞ্জের ঝাঁঝরী এবং তা বয়ে নিয়ে যাওয়ার জন্য দণ্ড ও সব পাত্রগুলি; বড় গামলার মত পাত্র ও তার জন্য দানি। ");
INSERT INTO benirv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","তারা উঠানের জন্য পর্দা ও তার সঙ্গে স্তম্ভ ও ভিত্তি আনলো এবং উঠানের দরজার জন্য পর্দা ও তার দড়ি, গোঁজ ও সমাগম তাঁবুর সেবা কাজের জন্য সব পাত্র আনলো। ");
INSERT INTO benirv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","তারা পবিত্র জায়গায় পরিচর্য্যা করার জন্য সূক্ষ্ম ভাবে কাজ করা পোশাক আনলো, হারোণ যাজক ও তাঁর ছেলেদের জন্য পবিত্র পোশাক, তাদের যাজক কাজের জন্য এই পোশাক। ");
INSERT INTO benirv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","যদিও সদাপ্রভু মোশিকে যেমন আদেশ করেছিলেন সেই অনুযায়ী ইস্রায়েলের লোকেরা সব কাজই করেছিল। ");
INSERT INTO benirv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","মোশি ঐ সব কাজের প্রতি পরীক্ষামূলক ভাবে লক্ষ্য করলেন, আর দেখ, তারা সেগুলি করেছে। যেমন ভাবে সদাপ্রভুর আদেশ করেছিলেন সেই ভাবেই তারা করেছে। তখন মোশি তাদেরকে আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","তখন সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","তুমি নতুন বছরের প্রথম মাসের প্রথম দিনের পবিত্র জায়গা অর্থাৎ সমাগম তাঁবু স্থাপন করবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","আর তুমি তার মধ্যে সাক্ষ্য সিন্দুক রাখবে এবং তুমি অবশ্যই পর্দা টাঙ্গিয়ে সেই সিন্দুকটি সুরক্ষা করবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","পরে তুমি টেবিল ভিতরে আনবে এবং তার উপরে সাজাবার জিনিসগুলি সাজিয়ে রাখবে। তখন তুমি দীপদানি ভিতরে এনে তার উপর প্রদীপ গুলি জ্বেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","তুমি সোনার ধূপবেদিটি সাক্ষ্য সিন্দুকের সামনে রাখবে এবং তাঁবুর দরজায় পর্দা টাঙ্গিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","তুমি হোমবেদিটি অবশ্যই সমাগম তাঁবুর দরজার সামনে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","আর তুমি সমাগম তাঁবু ও বেদির মাঝখানে বড় গামলা পাত্রটি রাখবে এবং তার মধ্যে জল দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","আর তার চারদিকে উঠান তৈরী করবে এবং উঠানের প্রবেশ দরজায় পর্দা টাঙ্গিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","তুমি পরে অভিষেকের তেল নিয়ে তাঁবু এবং তার মধ্যে সব জিনিসগুলি অভিষেক করবে। তুমি অবশ্যই এটি পবিত্র করবে এবং সাজাবে; তখন এটি পবিত্র হবে এবং আমার জন্য সংরক্ষিত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","তুমি হোমবেদি ও সেই বিষয়ে সব পাত্রগুলি অভিষেক করবে। তুমি হোমবেদি পবিত্র করবে; আমার সেবার জন্য তা প্রস্তুত করবে এবং সেই বেদি অতি পবিত্র হবে ও আমার জন্য সংরক্ষিত হবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","তুমি আমার সেবা কাজের জন্য গামলার মত পাত্রটি ও তার দানি অভিষেক করবে ও পবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","তুমি হারোণ ও তার ছেলেদেরকে সমাগম তাঁবুর প্রবেশ দরজার কাছে আনবে এবং জলে স্নান করাবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","আর তুমি হারোণকে পবিত্র পোশাক গুলি পরাবে, অভিষেক করবে এবং একমাত্র আমার জন্য পবিত্র করবে, তাতে সে আমার যাজক হয়ে কাজ করবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","আর তার ছেলেদেরকেও আনবে এবং তাদের গায়ে পোশাক পরাবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","আর তুমি তাদেরকেও অভিষেক করবে যেমন ভাবে তাদের পিতাকে অভিষেক করেছ; যাতে তারা যাজক হয়ে আমার সেবা কাজ করে। তাদের সেই অভিষেক বংশ পরম্পরায় তাদের চিরস্থায়ী যাজকত্ব তৈরী করবে। ");
INSERT INTO benirv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","আর মোশি এইরূপ করলেন; সদাপ্রভু তাঁকে যা আদেশ করেছিলেন তিনি সব কিছুই অনুসরণ করে কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","সুতরাং দ্বিতীয় বছরে প্রথম মাসের প্রথম দিনের তাঁবু স্থাপিত হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","মোশি তাঁবুটি স্থাপন করলেন, তার তলদেশ জায়গায় রাখলেন, তক্তা বসালেন, খিল ভিতরে দিলেন ও তার থাম গুলি বসালেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","তিনি সেই সমাগম তাঁবুর উপরে ঢাকা দিলেন এবং তার উপরে তাঁবুর মত ঢাকা লাগিয়ে দিলেন; যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","তিনি সাক্ষ্যলিপি নিলেন এবং সিন্দুকের মধ্যে রাখলেন। তিনি সিন্দুকের উপর বহন দণ্ড রাখলেন এবং তার উপরে পাপাবরণ রাখলেন, ");
INSERT INTO benirv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","তিনি তাঁবুর মধ্যে সিন্দুক আনলেন। যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন, তিনি সাক্ষ্য সিন্দুকটির সুরক্ষার জন্য সেখানে পর্দা টাঙ্গিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","তিনি তাঁবুর উত্তর পাশে পর্দার বাইরে সমাগম তাঁবুর ভিতরে টেবিল রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","যেমন সদাপ্রভু তাঁকে আদেশ দিয়েছিলেন, তিনি টেবিলের উপর সদাপ্রভুর সামনে রুটি সাজিয়ে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","আর তিনি তাঁবুর দক্ষিণ দিকে সমাগম তাঁবুর ভিতরে টেবিলের সামনে দীপদানি রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","সদাপ্রভু যেমন মোশিকে আদেশ দিয়েছিলেন, তিনি সদাপ্রভুর সামনে প্রদীপ জ্বালালেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","তিনি সমাগম তাঁবুর ভিতরে পর্দার সামনে সোনার বেদী রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","সদাপ্রভু যেমন মোশিকে আদেশ দিয়েছিলেন, তিনি তার উপরে সুগন্ধি ধূপ জ্বালালেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","তিনি তাঁবুর প্রবেশ দরজায় পর্দা টাঙ্গিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","তিনি সমাগম তাঁবুর প্রবেশ দরজার সামনে হোমবেদি রাখলেন। সদাপ্রভু যেমন মোশিকে আদেশ দিয়েছিলেন, তিনি তার উপরে হোমবলি ও শস্য নৈবেদ্য উৎসর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","তিনি সমাগম তাঁবু এবং বেদির মাঝখানে ধোয়ার জন্য গামলা রাখলেন এবং তার মধ্যে ধোয়ার জন্য জল দিলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","মোশি, হারোণ ও তার ছেলেরা নিজের নিজের হাত ও পা সেই গামলা থেকে ধুতেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","যখন তাঁরা সমাগম তাঁবুর ভিতরে যেতেন এবং বেদির কাছে যেতেন। সদাপ্রভু যেমন মোশিকে আদেশ দিয়েছিলেন, তাঁরা তাঁদের নিজেদের ধুতেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","মোশি তাঁবুর এবং বেদির চারদিকে উঠান তৈরী করলেন। তিনি উঠানের প্রবেশ দরজায় পর্দা লাগালেন। এই ভাবে মোশি কাজ শেষ করলেন। ");
INSERT INTO benirv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","তখন সমাগম তাঁবুটি মেঘে ঢেকে গেল এবং সদাপ্রভুর মহিমায় তাঁবু পরিপূর্ণ হলো। ");
INSERT INTO benirv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","তাতে মোশি সমাগম তাঁবুর মধ্যে ঢুকতে পারলেন না, কারণ মেঘ তার উপরে ছিল এবং সদাপ্রভুর মহিমা তাঁবুটি পরিপূর্ণ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","আর যখন তাঁবুর উপর থেকে মেঘ সরিয়ে নেওয়া হত, তখন ইস্রায়েলের লোকেরা তাদের নিজেদের যাত্রায় এগিয়ে যেত। ");
INSERT INTO benirv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","কিন্তু যদি মেঘ তাঁবুর উপর থেকে উপরের দিকে না উঠত, তবে সে দিন লোকেরা বাইরে যাত্রা করত না। মেঘ উপরে উঠার দিন পর্যন্ত তারা অপেক্ষা করত। ");
INSERT INTO benirv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","কারণ সব ইস্রায়েলের লোকদের সাধারণ দৃষ্টিতে তাদের সব যাত্রার দিনের দিনের সদাপ্রভুর মেঘ এবং রাতে আগুন তাঁবুর উপরে ছিল।");
INSERT INTO benirv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","সদাপ্রভু মোশিকে ডেকে সমাগম তাঁবু থেকে এই কথা বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“তুমি ইস্রায়েলের লোকদেরকে বল, তাদেরকে বল, ‘তোমাদের কেউ যদি সদাপ্রভুর উদ্দেশ্যে উপহার আনে, তবে সে গরুর পাল থেকে কিংবা ভেড়ার পাল থেকে একটি পশু উত্সর্গ করতে নিয়ে আসুক। ");
INSERT INTO benirv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","সে যদি গরুর পাল থেকে হোমবলির উপহার দেয়, তবে সে নির্দোষ এক পুরুষ পশু আনবে, সদাপ্রভুর সামনে গ্রহণযোগ্য হবার জন্য সমাগম তাঁবুর প্রবেশ দরজার সামনে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","পরে হোমবলির মাথার ওপরে হাত বাড়িয়ে দেবে; আর তা তার প্রায়শ্চিত্তের জন্যে তার পক্ষে গ্রহণ করা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","পরে সে সদাপ্রভুর সামনে সেই ষাঁড়টি হত্যা করবে, যাজকেরা অর্থাৎ হারোণের ছেলেরা তার রক্ত কাছে আনবে এবং সমাগম তাঁবুর প্রবেশ দরজায় অবস্থিত বেদির ওপরে সেই রক্ত চারিদিকে ছিঁটাবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","আর সে ঐ হোমবলির চামড়া খুলে তাকে টুকরো টুকরো করবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","পরে হারোণ যাজকের ছেলেরা বেদির ওপরে আগুন রাখবে ও আগুনের ওপরে কাঠ সাজাবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","আর হারোণের ছেলে যাজকেরা সেই বেদির উপরে অবস্থিত আগুনের ও কাঠের ওপরে তার সব টুকরো এবং মাথা ও মেদ রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","কিন্তু তার অন্ত্র ও পা জলে ধোবে; পরে যাজক বেদির ওপরে সে সব হোমবলি হিসাবে পোড়াবে, যা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধ স্বরূপ আগুনে উত্সর্গ করা উপহার। ");
INSERT INTO benirv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","আর যদি সে ভেড়ার অথবা ছাগলের পাল থেকে ভেড়া কিংবা ছাগল হোমবলি হিসাবে উপহার দেয়, তবে সে নির্দোষ এক পুরুষ পশু আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","সে অবশ্যই বেদির পাশে উত্তরদিকে সদাপ্রভুর সামনে তা হত্যা করবে এবং হারোণের ছেলে যাজকেরা বেদির ওপরে চারিদিকে তার রক্ত ছিঁটাবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","পরে সে তা টুকরো টুকরো করবে, আর যাজক মাথা ও মেদের সঙ্গে সেটি বেদির ওপরে অবস্থিত আগুনের ও কাঠের ওপরে সাজাবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","কিন্তু তার অন্ত্র ও পা জলে ধোবে; পরে যাজক সম্পূর্ণটিই উৎসর্গ করবে এবং বেদির ওপরে পোড়াবে; তা হোমবলি এবং সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধস্বরূপ আগুনে উত্সর্গ করা উপহার। ");
INSERT INTO benirv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","যদি সে সদাপ্রভুর উদ্দেশ্যে পাখিদের থেকে হোমবলির উপহার দেয়, তবে সে অবশ্যই ঘুঘু কিংবা বাচ্চা পায়রার মধ্য থেকে নিজের উপহার দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","পরে যাজক তা বেদির কাছে এনে তার মাথা মোচড় দিয়ে তাকে বেদিতে পোড়াবে এবং তার রক্ত বেদির পাশে ঢেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","পরে সে তার মলের সঙ্গে পালক নিয়ে বেদির পূর্ব দিকে ছাইয়ের জায়গায় ফেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","সে অবশ্যই সেটির ডানা ধরে টেনে ছিঁড়বে কিন্তু সেটিকে সম্পূর্ণরূপে দুই ভাগে ভাগ করবে না এবং যাজক বেদির ওপরে, আগুনের ওপরে অবস্থিত কাঠের ওপরে তাকে পোড়াবে; তা হোমবলি হবে এবং সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধ স্বরূপ আগুনে উত্সর্গ করা উপহার’।” ");
INSERT INTO benirv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","আর কেউ যখন সদাপ্রভুর উদ্দেশ্যে শস্য নৈবেদ্য উপহার দেয়, তখন সূক্ষ্ম সূজি তার উপহার হবে এবং সে তার উপরে তেল ঢালবে ও ধুনো দেবে; ");
INSERT INTO benirv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","আর হারোণের ছেলে, যাজকদের কাছে সে তা আনবে এবং সে তা থেকে এক মুঠো সূক্ষ্ম সূজি ও তেল এবং তার উপরে ধুনো নেবে; পরে যাজক সেই নৈবেদ্যের স্মারক অংশ বলে তা বেদির ওপরে পোড়াবে; তা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধ স্বরূপ আগুনে উত্সর্গ করা উপহার। ");
INSERT INTO benirv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","এই শস্য নৈবেদ্যের বাকি অংশ হারোণের ও তার ছেলেদের হবে; সদাপ্রভুর আগুনে তৈরী উপহার বলে এটা খুব পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","আর যদি তুমি উনানে সেঁকা খামিহীন শস্য নৈবেদ্যে উপহার দাও, তবে তেল মেশানো খামিহীন সূক্ষ্ম সূজির পাপড় বা তৈলাক্ত খামিহীন শক্ত পাপড় দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","আর যদি তুমি সমান লোহার চাটুতে সেঁকা শস্য নৈবেদ্য উপহার দাও, তবে তেল মেশানো খামিহীন সূক্ষ্ম সূজি দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","তুমি তা টুকরো টুকরো করে তার ওপরে তেল ঢালবে; এটা শস্য নৈবেদ্য। ");
INSERT INTO benirv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","আর যদি চাটুতে রান্না করা শস্য নৈবেদ্য উপহার দাও, তবে তেল ও সূক্ষ্ম সূজি দিয়ে তৈরী করে দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","এই সব জিনিসের যে শস্য নৈবেদ্য তুমি সদাপ্রভুর উদ্দেশ্যে দেবে; তা এনে যাজককে দিও, সে তা বেদির কাছে আনবে ");
INSERT INTO benirv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","এবং যাজক সেই শস্য নৈবেদ্যের স্মারক অংশ নিয়ে বেদিতে পোড়াবে; তা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধ স্বরূপ আগুনে উত্সর্গ করা উপহার। ");
INSERT INTO benirv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","আর সেই শস্য নৈবেদ্যের বাকি অংশ হারোণের ও তার ছেলেদের হবে; সদাপ্রভুর আগুনে তৈরী উপহার বলে তা খুব পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","তোমরা সদাপ্রভুর উদ্দেশ্যে যে কোনো শস্য নৈবেদ্য আনবে, তা খামিতে তৈরী হবে না, কারণ তোমরা খামির কিংবা মধু, এর কিছুই সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার বলে পোড়াবে না। ");
INSERT INTO benirv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","তোমরা প্রথমাংশের উপহার বলে তা সদাপ্রভুর উদ্দেশ্যে উত্সর্গ করতে পার, কিন্তু সুগন্ধের জন্যে বেদির ওপরে তা ব্যবহার করা যাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","আর তুমি নিজের শস্য নৈবেদ্যের প্রত্যেক উপহার লবণাক্ত করবে; তুমি নিজের শস্য নৈবেদ্যে নিজের ঈশ্বরের নিয়মের লবণ দানে ত্রুটি করবে না; তোমার সমস্ত উপহারের সঙ্গে লবণ দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","আর যদি তুমি সদাপ্রভুর উদ্দেশ্যে প্রথম শস্যের ভক্ষ্য নৈবেদ্য উত্সর্গ কর, তবে তোমার প্রথম ফসলের তাজা শীষ পেষাই করে আগুনে ঝলসে উপহার উত্সর্গ করবে ");
INSERT INTO benirv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","এবং তার ওপরে তেল দেবে ও ধুনো রাখবে; এটা শস্য নৈবেদ্য। ");
INSERT INTO benirv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","পরে যাজক তার স্মারক অংশ রূপে কিছু পেষাই করা শস্য, কিছু তেল ও সমস্ত ধুনো পোড়াবে; এটা সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার। ");
INSERT INTO benirv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","কারো উপহার যদি মঙ্গলের জন্য বলিদান হয় এবং সে গরুর পাল থেকে পুরুষ কিংবা স্ত্রী গরু দেয়, তবে সে সদাপ্রভুর সামনে নির্দোষ পশু আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","সে নিজের উপহারের মাথায় হাত রেখে সমাগম তাঁবুর দরজার সামনে তাকে হত্যা করবে; পরে হারোণের ছেলে অর্থাৎ যাজকরা তার রক্ত বেদির চারিদিকে ছড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","পরে সে সদাপ্রভুর উদ্দেশ্যে সেই মঙ্গলের জন্য বলি বিষয়ক আগুনের তৈরী উপহার উৎসর্গ করবে, তার ঢাকা মেদ ও অন্ত্রের সঙ্গে সংযুক্ত ");
INSERT INTO benirv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","এবং দুই কিডনি, কোমরের কাছের মেদ ও যকৃতে ওপরে অবস্থিত ফুসফুস কিডনির সঙ্গে ছাড়িয়ে নেবে। ");
INSERT INTO benirv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","পরে হারোণের ছেলেরা বেদির ওপরে অবস্থিত আগুনের, কাঠের ওপরে তা পোড়াবে; তা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধ স্বরূপ আগুনে উত্সর্গ করা উপহার। ");
INSERT INTO benirv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","আর যদি সে সদাপ্রভুর উদ্দেশ্যে মঙ্গলার্থক বলিদানের উপহার পশুর পাল থেকে দেয়, তবে সে নির্দোষ পুরুষ কিংবা স্ত্রী পশু উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","কেউ যদি উপহারের জন্যে ভেড়ার বাচ্চা দেয়, তবে সে সদাপ্রভুর সামনে তা আনবে; ");
INSERT INTO benirv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","আর নিজের উপহারের মাথায় হাত দিয়ে সমাগম তাঁবুর সামনে তাকে হত্যা করবে এবং হারোণের ছেলেরা বেদির চারদিকে রক্ত ছেঁটাবে। ");
INSERT INTO benirv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","আর মঙ্গলার্থক বলি থেকে কিছু নিয়ে সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার উৎসর্গ করবে; ফলে তার মেদ ও সম্পূর্ণ লেজটি মেরুদণ্ডের কাছ থেকে কেটে নেবে, আর ঢাকা মেদ ও অন্ত্রের কাছের সব মেদ, ");
INSERT INTO benirv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","কোমরের কাছে দুইটি কিডনিতে অবস্থিত যে মেদ এবং যকৃতের উপরে অবস্থিত ফুসফুস কিডনির সঙ্গে সে সমস্ত বাদ দেবে ");
INSERT INTO benirv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","এবং যাজক তা বেদির ওপরে খাদ্য হিসাবে পোড়াবে, সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার। ");
INSERT INTO benirv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","আর যদি সে উপহারের জন্যে ছাগল দেয়, তবে সে তা সদাপ্রভুর সামনে আনবে; ");
INSERT INTO benirv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","তার মাথায় হাত দিয়ে সমাগম তাঁবুর সামনে তাকে হত্যা করবে এবং হারোণের ছেলেরা বেদির চারিদিকে তার রক্ত ছড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","পরে সে তা থেকে নিজের উপহার, সদাপ্রভুর উদ্দেশ্যে আগুনের তৈরী উপহার উৎসর্গ করবে, অর্থাৎ ঢাকা মেদ ও ভিতরের অংশের কাছের সমস্ত মেদ এবং দুইটি কিডনি, ");
INSERT INTO benirv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","তার সঙ্গে অবস্থিত পার্শ্বস্থ মেদ ও যকৃতের উপরে অবস্থিত ফুসফুস কিডনির সঙ্গে বাদ দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","যাজক তা বেদির ওপরে খাদ্য হিসাবে পোড়াবে; তা সুগন্ধের জন্য আগুনে তৈরী উপহার; সমস্ত মেদ সদাপ্রভুর। ");
INSERT INTO benirv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","তোমাদের সমস্ত বাস করার জায়গায় চিরদিনের র জন্য এই নিয়ম পালন করতে হবে, তোমরা মেদ ও রক্ত খাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","তুমি ইস্রায়েল সন্তানদের বল, কেউ যদি ভুলবশতঃ পাপ করে, অর্থাৎ সদাপ্রভুর আজ্ঞানিষিদ্ধ কাজের কোনো এক কাজ যদি করে; ");
INSERT INTO benirv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","বিশেষত অভিষিক্ত যাজক যদি এমন পাপ করে, যাতে লোকদের ওপরে দোষ হয়, তবে সে নিজের পাপের জন্য সদাপ্রভুর উদ্দেশ্যে নির্দোষ এক ছোট বলদ আনবে পাপের জন্য বলিরূপে উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","পরে সমাগম তাঁবুর দরজার মুখে সদাপ্রভুর সামনে সেই বলদ আনবে; তার মাথার ওপর হাত রেখে সদাপ্রভুর সামনে তাকে হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","আর অভিষিক্ত যাজক সেই গোবৎসের কিছু রক্ত নিয়ে সমাগম তাঁবুর মধ্যে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","আর যাজক সেই রক্তে নিজের আঙুল ডুবিয়ে পবিত্র জায়গায় পর্দার সামনের অংশে সদাপ্রভুর সামনে সাত বার তার কিছু রক্ত ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","পরে যাজক সেই রক্তের কিছুটা নিয়ে সমাগম তাঁবুর ভেতর সদাপ্রভুর সামনে রাখা সুগন্ধি ধূপের বেদির শিঙে দেবে, পরে গোবৎসের সব রক্ত নিয়ে সমাগম তাঁবুর দরজায় রাখা হোমবেদির মূলে ঢালবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","আর পাপের জন্য বলির বলদের সব মেদ, অর্থাৎ ভেতরের অংশে ঢাকা মেদ, অন্ত্রের ওপরের সব মেদ ");
INSERT INTO benirv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","এবং দুটো কিডনি ও তার ওপরে থাকা মেদ ও যকৃতের ওপরে থাকা ফুসফুস কিডনির সঙ্গে ছাড়িয়ে নেবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","মঙ্গলের জন্য বলির বলদের থেকে যেমন নিতে হয়, সেই রকম নেবে এবং যাজক হোমবেদির ওপরে তা পোড়াবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","পরে ঐ গোবৎসের চামড়া সব মাংস, মাথা ও পা, অন্ত্র ও গোবর ");
INSERT INTO benirv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","সবশুদ্ধ বলদটি নিয়ে শিবিরের বাইরে কোন শুচি জায়গায়, ছাই ফেলে দেবার জায়গায়, এনে কাঠের ওপরে আগুনে পুড়িয়ে দেবে; ছাই ফেলে দেবার জায়গায় তা পোড়াতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","আর ইস্রায়েলের সব মণ্ডলী যদি প্রমাদবশতঃ পাপ করে এবং তা সমাজের চোখের আড়ালে থাকে এবং সদাপ্রভুর আজ্ঞানিষিদ্ধ কোনো কাজ করে যদি দোষী হয়, ");
INSERT INTO benirv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","তবে তাদের করা সেই পাপ যখন জানা যাবে সেই দিনের সমাজ পাপের জন্য বলিরূপে এক ছোট গোবৎস উৎসর্গ করবে; লোকেরা সমাগম তাঁবুর সামনে তাকে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","পরে মণ্ডলীর প্রাচীনরা সদাপ্রভুর সামনে সেই গোবৎসের মাথায় হাত রাখবে এবং সদাপ্রভুর সামনে তাকে হত্যা করা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","পরে অভিষিক্ত যাজক সেই বলদের কিছু রক্ত সমাগম তাঁবুর মধ্যে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","আর যাজক সেই রক্তে নিজের আঙুল ডুবিয়ে তার কিছুটা পর্দার আগে, সদাপ্রভুর সামনে সাত বার ছিটাবে ");
INSERT INTO benirv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","এবং সেই রক্তের কিছুটা নিয়ে সদাপ্রভুর সামনে সমাগম তাঁবুর মধ্যে রাখা বেদির শিঙের ওপরে দেবে; পরে সমাগম তাঁবুর দরজার সামনে হোমবেদির মূলে অন্য সব রক্ত ঢেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","আর বলি থেকে তার সব মেদ নিয়ে বেদির ওপরে পোড়াবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","সে ঐ পাপের জন্য বলির বলদকে যেরকম করে, একেও সেরকম করবে; এভাবে যাজক তাদের জন্য প্রায়শ্চিত্ত করবে, তাতে তাদের পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","পরে সে বলদকে শিবিরের বাইরে নিয়ে গিয়ে প্রথম বলদটি যেমন পুড়িয়েছিলে, তেমনি তাকেও পুড়িয়ে দেবে; এটা সমাজের পাপের জন্য বলিদান। ");
INSERT INTO benirv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","আর যদি কোনো অধ্যক্ষ পাপ করে, অর্থাৎ প্রমাদবশতঃ নিজের ঈশ্বর সদাপ্রভুর আজ্ঞানিষিদ্ধ কোনো কাজ করে দোষী হয়, ");
INSERT INTO benirv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","তবে তার করা সেই পাপ যখন জানা যাবে, সেদিনের নিজের উপহার বলে এক নির্দোষ পুরুষ ছাগল আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","পরে ঐ ছাগলের মাথায় হাত দিয়ে হোমবলি হত্যার জায়গায় সদাপ্রভুর সামনে তাকে হত্যা করবে; এটা পাপের জন্য বলিদান। ");
INSERT INTO benirv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","পরে যাজক নিজের আঙুল দিয়ে সেই পাপের জন্য বলির কিছুটা রক্ত নিয়ে হোমবেদির শিঙের ওপরে দেবে এবং তার রক্ত হোমবেদির মূলে ঢেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","আর মঙ্গলের জন্য বলিদানের মেদের মত তার সব মেদ নিয়ে বেদিতে পোড়াবে এভাবে যাজক পাপমোচনের জন্য প্রায়শ্চিত্ত করবে, তাতে তার পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","আর সাধারণ লোকদের মধ্যে যদি কেউ প্রমাদবশতঃ সদাপ্রভুর কোনো আজ্ঞানিষিদ্ধ কাজের জন্য পাপ করে দোষী হয়, ");
INSERT INTO benirv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","তবে সে যখন নিজের করা পাপ জানবে তখন নিজের করা সেই পাপের জন্য নিজের উপহার বলে পালের ভেতর থেকে এক নির্দোষ ছাগী আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","পরে ঐ পাপের জন্যে বলির মাথায় হাত রেখে হোমবলির জায়গায় সেই পাপের জন্য বলি হত্যা করবে ");
INSERT INTO benirv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","পরে যাজক আঙুল দিয়ে তার কিছুটা রক্ত নিয়ে হোমবেদির শিঙের ওপরে দেবে এবং তার সব রক্ত বেদির মূলে ঢেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","আর মঙ্গলের জন্য বলি থেকে নেওয়া মেদের মত তার সব মেদ ছাড়িয়ে নেবে; পরে যাজক সদাপ্রভুর উদ্দেশ্যে সুগন্ধের জন্য বেদির ওপরে তা পুড়িয়ে দেবে; এভাবে যাজক তার জন্য প্রায়শ্চিত্ত করবে, তাতে তার পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","যদি সে পাপের জন্য বলির উপহারের জন্য ভেড়ার বাচ্চা আনে, তবে একটা নির্দোষ মেয়ে ভেড়ার বাচ্চা আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","আর সেই পাপের জন্য বলির মাথায় হাত দিয়ে হোমবলি হত্যার জায়গায় সেই পাপের জন্য বলি হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","পরে যাজক আঙুল দিয়ে সেই পাপের জন্য বলির কিছুটা রক্ত নিয়ে হোমবেদির শিংগুলোর ওপরে দেবে ও সব রক্ত বেদির মূলে ঢালবে। ");
INSERT INTO benirv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","পরে মঙ্গলের বলির ভেড়ার বাচ্চার মেদ যেমন ছাড়ান যায়, তেমনি যাজক এর সব মেদ ছাড়িয়ে নেবে এবং সদাপ্রভুর জন্য আগুনে তৈরী উপহারের রীতি অনুসারে তা বেদিতে পোড়াবে; এভাবে যাজক তার করা পাপের প্রায়শ্চিত্ত করবে; তাতে তার পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","আর যদি কেউ এভাবে পাপ করে, সাক্ষী হয়ে দিব্যি করবার কথা শুনলেও, যা দেখেছে কিংবা জানে, তা সে প্রকাশ না করে, তবে সে নিজের অপরাধ বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","কিংবা যদি কেউ কোনো অশুচি জিনিস স্পর্শ করে, অশুচি জন্তুর মৃতদেহ হোক, কিংবা অশুচি পশুর মৃতদেহ হোক, কিংবা অশুচি সরীসৃপের মৃতদেহ হোক; যদি সে তা জানতে না পায় ও অশুচি হয়, তবে সে দোষী হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","কিংবা মানুষের কোনো অশৌচ, অর্থাৎ যা দিয়ে মানুষ অশুচি হয়, এমন কিছু যদি কেউ ছোঁয় ও তা জানতে না পায়, তবে সে তা জানলে দোষী হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","আর কেউ বিবেচনা না করে যে কোনো বিষয়ে শপথ করুক না কেন, যদি কেউ নিজের ওষ্ঠে বিবেচনা না করে ভাল বা মন্দ কাজ করব বলে শপথ করে ও তা জানতে না পায়, তবে সে তা জানলে সেই বিষয়ে দোষী হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","আর কোনো বিষয়ে দোষী হলে সে নিজের করা পাপ স্বীকার করবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","পরে সে পাপের জন্য বলির কারণে পাল থেকে ভেড়ীর মেয়ে বাচ্চা কিংবা ছাগলের মেয়ে বাচ্চা নিয়ে সদাপ্রভুর উদ্দেশ্যে নিজের করা পাপের উপযুক্ত দোষের জন্য বলি উৎসর্গ করবে; তাতে যাজক তার পাপমোচনের জন্য প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","আর সে যদি ভেড়ীর মেয়ে বাচ্চা আনতে না পারে তবে নিজের করা পাপের জন্য দুটো ঘুঘু কিংবা দুটো পায়রার বাচ্চা, এই দোষের জন্য বলিস্বরূপ সদাপ্রভুর কাছে আনবে; তার একটা পাপের জন্য, অন্যটি হোমের জন্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","সে তাদের কে যাজকের কাছে আনবে ও যাজক আগে পাপের জন্য বলি উৎসর্গ করে তার গলা মুচড়াবে, কিন্তু ছিঁড়ে ফেলবে না। ");
INSERT INTO benirv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","পরে পাপের জন্য বলির কিছু রক্ত নিয়ে বেদির গায়ে ছিটাবে এবং বাকি রক্ত বেদির মূলে ঢেলে দেওয়া যাবে; এটা পাপের জন্য বলি। ");
INSERT INTO benirv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","পরে সে বিধিমতে দ্বিতীয়টি হোমের জন্য উৎসর্গ করবে; এই ভাবে যাজক তার করা পাপের জন্য প্রায়শ্চিত্ত করবে, তাতে তার পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","আর সে যদি দুই ঘুঘু কিংবা দুই পায়রার বাচ্চা আনতেও না পারে, তবে তার করা পাপের জন্য তার উপহার বলে ঐফার দশমাংশ সূজি পাপের জন্য বলিরূপে আনবে; তার ওপরে তেল দেবে না ও ধুনো রাখবে না, কারণ তা পাপের জন্য বলি। ");
INSERT INTO benirv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","পরে সে তা যাজকের কাছে আনলে যাজক তার মনে রাখার জন্য অংশ বলে তা থেকে এক মুঠো নিয়ে সদাপ্রভুর জন্য আগুনের তৈরী উপহারের রীতি অনুসারে বেদিতে পোড়াবে; এটা পাপের জন্য বলি। ");
INSERT INTO benirv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","যাজক এই সকলের মধ্যে তার করা কোনো পাপের জন্য প্রায়শ্চিত্ত করবে, তাতে তার পাপের ক্ষমা হবে এবং অবশিষ্ট দ্রব্য ভক্ষ্য নৈবেদ্যের মত যাজকের হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","পরে সদাপ্রভু মোশিকে বললেন, “যদি কেও সদাপ্রভুর পবিত্র জিনিসের বিষয়ে প্রমোদবশতঃ সত্য লঙ্ঘন করে পাপ করে, ");
INSERT INTO benirv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","তবে সে সদাপ্রভুর কাছে দোষের জন্য বলি আনবে, পবিত্র জায়গার শেকল অনুসারে তোমার নিরূপিত পরিমাণে রূপা দিয়ে পাল থেকে এক নির্দোষ মেষ এনে দোষের জন্য বলি উপস্থিত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","আর সে পবিত্র জিনিস বিষয়ে যে পাপ করেছে, তার পরিশোধ করবে, তাছাড়া পাঁচ অংশের এক অংশও দেবে এবং যাজকের কাছে তা আনবে; পরে যাজক সেই দোষের জন্য মেষ বলি দিয়ে তার জন্য প্রায়শ্চিত্ত করবে, তাতে তার পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","আর যদি কেও সদাপ্রভুর আজ্ঞানিষিদ্ধ কোনোকাজ করে পাপ করে, তবে সে তা না জানলেও দোষী, সে নিজের অপরাধ বয়ে বেড়াবে ");
INSERT INTO benirv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","সে তোমার নিরূপিত মূল্য দিয়ে পাল থেকে এক নির্দোষ মেষ এনে দোষ করার জন্য বলিরূপে যাজকের কাছে উপস্থিত করবে এবং সে প্রমোদবশতঃ অজান্তে যে দোষ করেছে, যাজক তার জন্য প্রায়শ্চিত্ত করবে, তাতে তার পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","এটাই দোষের জন্য বলি, সে অবশ্য সদাপ্রভুর কাছে দোষী।” ");
INSERT INTO benirv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","আর সদাপ্রভু মোশিকে বললেন, কেউ যদি পাপ করে সদাপ্রভুর বিরুদ্ধে সত্য লঙ্ঘন করে, ");
INSERT INTO benirv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“যদি গচ্ছিত অথবা বন্ধকরূপে দেওয়া কিংবা অপহরণ করে নেওয়া বিষয়ে প্রতিবেশীদের কাছে মিথ্যা কথা বলে, ");
INSERT INTO benirv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","কিংবা প্রতিবেশীদের প্রতি অন্যায় করে, কিংবা হারানো জিনিস পেয়ে সেই বিষয়ে মিথ্যা কথা বলে ও মিথ্যা দিব্যি করে, এটার যে কোনো কাজ দ্বারা কোনো লোক সে বিষয়ে পাপ করে, ");
INSERT INTO benirv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","যদি সে এভাবে পাপ করে দোষী হয়ে থাকে, তবে সে যা গায়ের জোরে কেড়ে নিয়েছে, অথবা অন্যায়ভাবে পেয়েছে, কিংবা যে গচ্ছিত জিনিস তার কাছে দেওয়া হয়েছে, কিংবা সে যে হারানো জিনিস পেয়ে রেখেছে, ");
INSERT INTO benirv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","কিংবা যে কোনো বিষয়ে সে মিথ্যা দিব্যি করেছে, সেই জিনিস সম্পূর্ণ ফিরিয়ে দেবে এবং তার পাঁচ অংশের এক অংশ বেশি ফিরিয়ে দেবে; তার দোষ প্রকাশের দিনের সে জিনিসের মালিককে তা দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","আর সে সদাপ্রভুর কাছে নিজের দোষের জন্য বলি উপস্থিত করবে, ফলে তোমার নির্ধারিত দাম দিয়ে পাল থেকে এক নির্দোষ মেষবলি দোষের জন্য যাজকের কাছে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","পরে যাজক সদাপ্রভুর সামনে তার জন্যে প্রায়শ্চিত্ত করবে; তাতে যে কোনো কাজের জন্য সে দোষী হয়েছে, তার ক্ষমা পাবে।” ");
INSERT INTO benirv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","তুমি হারোণ ও তার ছেলেদেরকে এই আদেশ কর। হোমের ব্যবস্থা; হোমবলি সকাল পর্যন্ত সমস্ত রাত্রি বেদির অগ্নিকুণ্ডের উপরে থাকবে এবং বেদির আগুন জালানো থাকবে ");
INSERT INTO benirv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","আর যাজক নিজের গায়ের মসীনা-বস্ত্র পরবে ও মসীনা-বস্ত্রের জাঙ্গিয়া শরীরে পরিধান করবে এবং বেদির ওপরে আগুনের পুড়ে যাওয়া যে ছাই আছে, তা তুলে বেদির পাশে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","পরে সে নিজের বস্ত্র ত্যাগ করে অন্য বস্ত্র পরে শিবিরের বাইরে কোনো পরিষ্কার জায়গায় ছাই নিয়ে যাবে ");
INSERT INTO benirv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","আর বেদির ওপরে আগুন জ্বালানো থাকবে, নিভবে না; যাজক প্রতিদিন সকালে তার ওপরে কাঠ দিয়ে জ্বালবে এবং তার ওপরে হোমবলি সাজিয়ে দেবেও মঙ্গলের জন্য বলির মেদ তাতে পোড়াবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","বেদির উপরে আগুন সব জ্বালিয়ে রাখতে হবে; নেভানো হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","আর শস্য-নৈবেদ্যের এই ব্যবস্থা; হারোণের ছেলেরা বেদির সামনে সদাপ্রভুর সামনে তা আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","পরে যাজক তা থেকে নিজের মুঠোভর্তি করে নৈবেদ্যের কিছু সূজি ও কিছু তেল এবং নৈবেদ্যের ওপরে সব ধুনো নিয়ে তার মনে করার অংশ হিসাবে সদাপ্রভুর উদ্দেশ্যে সুগন্ধের জন্য বেদিতে পোড়াবে ");
INSERT INTO benirv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","আর হারোণ ও তার ছেলেরা তার বাকি অংশ খাবে; বিনা তাড়ীতে কোন পবিত্র স্থানে তা ভোজন করতে হবে; তারা সমাগম-তাঁবু প্রাঙ্গণে তা খাবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","তাড়ীর সঙ্গে তা রান্না করা হবে না। আমি নিজের আগুনের করা উপহার থেকে তাদের প্রাপ্য অংশ বলে তা দিলাম; পাপের জন্য বলির ও দোষের জন্য বলির মত তা অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","হারোণের ছেলেদের মধ্যে সব পুরুষ তা খাবে; সদাপ্রভুর আগুনের করা উপহার থেকে এটা পুরুষানুক্রমে চিরকাল তোমাদের অধিকার; যে কেউ তা স্পর্শ করবে, সে পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","অভিষেক দিনের হারোণ ও তার ছেলেরা সদাপ্রভুর উদ্দেশ্যে এই উপহার উৎসর্গ করবে, প্রতিদিন ভক্ষ্য-নৈবেদ্যের জন্য ঐফার দশমাংশ (1 কিলোর ওপরে) সূক্ষ্ম সূজি, সকালে অর্ধেক ও সন্ধ্যাবেলায় অর্ধেক। ");
INSERT INTO benirv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","তারা ভোজন-পাত্রে তেল দিয়ে তা ভাজবে; ওটা তেলে ভিজলে তুমি তা এনে ঐ ভক্ষ্য-নৈবেদ্যের টুকরো টুকরো রান্না করা সব সদাপ্রভুর উদ্দেশ্যে সুগন্ধের জন্য উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","পরে হারোণের ছেলেদের মধ্যে যে তার পদে অভিষিক্ত যাজক হবে, সে তা উৎসর্গ করবে; চিরস্থায়ী বিধিমতে তা সদাপ্রভুর উদ্দেশ্যে সম্পূর্ণভাবে পোড়ানো হবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","আর যাজকের প্রত্যেক ভক্ষ্য-নৈবেদ্য সম্পূর্ণভাবে পোড়ানো হবে; তার কিছু খেতে হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","তুমি হারোণ ও তার ছেলেদেরকে বল, পাপের জন্য বলির এই ব্যবস্থা; যে জায়গায় হোমবলির জন্য হত্যা করা হয়, সে জায়গায় সদাপ্রভুর সামনে পাপের জন্য বলিরও হত্যা হবে; তা অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","যে যাজক পাপের জন্য তা উৎসর্গ করে, সে তা খাবে; সমাগম-তাঁবু প্রাঙ্গণে কোন পবিত্র জায়গায় তা খেতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","যে কেউ তার মাংস ছোবে তার পবিত্র হওয়া চাই এবং তার রক্তের ছিটে যদি কোনো কাপড়ে লাগে, তবে তুমি, যাতে ঐ রক্তের ছিটে লাগে, তা পবিত্র জায়গায় ধোবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","আর যে মাটির পাত্রে তা রান্না করা হয়, তা ভেঙে ফেলতে হবে; যদি পিতলের পাত্রে তা রান্না করা যায়, তবে তা জলে মেজে পরিষ্কার করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","যাজকদের মধ্যে সব পুরুষ তা খেতে পারবে; তা অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","কিন্তু পবিত্র জায়গায় প্রায়শ্চিত্ত করতে যে কোনো পাপের জন্য বলির রক্ত সমাগম-তাঁবু ভেতরে আনা হবে, তা খেতে হবে না, আগুনে পুড়িয়ে দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","অপরাধের বলির এই ব্যবস্থা; তা অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","যে জায়গায় লোকেরা হোমবলি হত্যা করে, সেই জায়গায় অপরাধের বলি হত্যা করবে এবং যাজক বেদির ওপরে চারিদিকে তার রক্ত ছড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","আর বলির সমস্ত মেদ উৎসর্গ করবে, লেজ ও ঢাকা মেদ ");
INSERT INTO benirv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","এবং দুটি কিডনি ও তার পরে অবস্থিত পার্শ্বস্থ মেদ, দুটি কিডনির সঙ্গে যকৃতের ওপরে অবস্থিত ঢেকে রাখা জিনিস বাদ দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","আর যাজক সদাপ্রভুর উদ্দেশ্যে আগুনের তৈরী উপহারের জন্যে বেদির ওপরে এই সব পোড়াবে; এটি অপরাধের বলি। ");
INSERT INTO benirv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","যাজকদের মধ্যে সমস্ত পুরুষ তা খাবে, কোনো পবিত্র জায়গায় তা খেতে হবে; কারণ এটি অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","পাপের বলি যেমন, অপরাধের বলিও সেরকম; উভয়েরই এক ব্যবস্থা; যে যাজক তার মাধ্যমে প্রায়শ্চিত্ত করে, তা তারই হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","আর যে যাজক কারো হোমবলি উৎসর্গ করে, সেই যাজক তার উত্সর্গ করা হোমবলির চামড়া পাবে ");
INSERT INTO benirv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","এবং উনানে কিংবা চাটুতে কিম্বা লোহার চাটুতে সেঁকা সব শস্য নৈবেদ্য, সে সব উৎসর্গকারী যাজকের হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","তেল মেশানো কিংবা শুকনো শস্য নৈবেদ্য সব সমানভাবে হারোণের সব বংশের হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","আর সদাপ্রভুর উদ্দেশ্যে উত্সর্গ করা মঙ্গালার্থক বলির এই ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","কেউ যদি ধন্যবাদের বলি আনে, তবে সে তার সঙ্গে তেল মেশানো খামিহীন রুটি, তৈলাক্ত খামিহীন শক্ত রুটি, তৈলসিক্ত সূক্ষ্ম সূজি ও তৈলাক্ত পিঠে উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","সে মঙ্গলার্থক স্তববলির সঙ্গে তাড়ীযুক্ত রুটি নিয়ে উপহার দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","আর সে তা থেকে, অর্থাৎ প্রত্যেক উপহার থেকে, প্রত্যেকটি থেকে এক একটি টুকরো নিয়ে উত্সর্গ করা উপহাররূপে সদাপ্রভুর উদ্দেশ্যে উত্সর্গ করবে; যে যাজক মঙ্গলের জন্য বলির রক্ত ছিঁটাবে, সে তা পাবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","আর মঙ্গলের জন্য স্তববলির মাংস উৎসর্গের দিনেই খেতে হবে; তার কিছুই সকাল পর্যন্ত রাখতে হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","কিন্তু তার উপহারের বলি যদি মানত অথবা স্বেচ্ছায় দেওয়া উপহার হয়, তবে বলি উৎসর্গের দিনের তা খেতে হবে এবং পরদিনের ও তার বাকি অংশ খাওয়া যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","কিন্তু তৃতীয় দিনের বলির বাকি মাংস আগুনে পুড়িয়ে দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","যদি তৃতীয় দিনের তার মঙ্গলের জন্য বলির অল্প মাংস খাওয়া যায়, তবে সেই বলি গ্রাহ্য হবে না এবং সেই বলি উৎসর্গকারীর পক্ষে গ্রহণ করা হবে না, তা ঘৃণার জিনিস হবে এবং যে তা খায়, সে নিজের অপরাধ বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","আর কোনো অশুচি জিনিসে যে মাংস স্পর্শ হয়, তা খাওয়া হবে না, আগুনে পুড়িয়ে দিতে হবে। অন্য মাংস প্রত্যেক শুচি লোকের খাবার। ");
INSERT INTO benirv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","কিন্তু যে কেউ অশুচি থেকে সদাপ্রভুর উদ্দেশ্যে উত্সর্গ করা মঙ্গলের জন্য বলির মাংস খায়, সে লোক নিজের লোকদের মধ্যে থেকে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","আর যদি কেউ কোনো অশুচি বস্তু, অর্থাৎ মানুষের অশুচি জিনিস কিংবা অশুচি পশু কিংবা কোনো অশুচি ঘৃণার জিনিস স্পর্শ করে সদাপ্রভু বিষয়ে মঙ্গলের জন্য বলির মাংস খায়, তবে সেই লোক নিজের লোকদের মধ্যে থেকে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“তুমি ইস্রায়েল সন্তানদের বল, ‘তোমরা ষাঁড় অথবা ভেড়া অথবা ছাগলের মেদ খেও না ");
INSERT INTO benirv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","এবং নিজে থেকে মারা যাওয়া কিংবা পশুর মাধ্যমে ছিন্নভিন্ন হওয়া পশুর মেদ অন্য কাজে ব্যবহার করবে; কিন্তু কোনোভাবে তা খাবে না; ");
INSERT INTO benirv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","কারণ যে কোনো পশু থেকে সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার উৎসর্গ করা যায়, সেই পশুর মেদ যে কেউ খাবে, সেই লোক নিজের লোকদের মধ্যে থেকে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","আর তোমাদের কোনো বসবাসের জায়গায় তোমরা কোনো পশুর কিংবা পাখির রক্ত খেও না। ");
INSERT INTO benirv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","যে কেউ কোনো রক্ত খায়, সেই লোক নিজের লোকদের মধ্যে থেকে উচ্ছেদ হবে।’” ");
INSERT INTO benirv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“তুমি ইস্রায়েল সন্তানদের বল, ‘যে ব্যক্তি সদাপ্রভুর উদ্দেশ্যে মঙ্গলের জন্য বলি উৎসর্গ করে, সেই ব্যক্তি তার বলি থেকে সদাপ্রভুর উদ্দেশ্যে নিজ উপহার আনিবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ফলে সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার অর্থাৎ বক্ষের সঙ্গে মেদ নিজের হাতে আনবে; তাতে সেই বক্ষের নৈবেদ্যের জন্যে সদাপ্রভুর সামনে তুলবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","আর যাজক বেদির ওপরে সেই মেদ পোড়াবে, কিন্তু বক্ষ হারোণের ও তার ছেলেদের হবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","আর তোমরা নিজেদের মঙ্গলের জন্য বলির ডান জঙ্ঘা উত্তোলনীয় উপহার হিসাবে যাজককে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","হারোণের ছেলেদের মধ্যে যে কেউ মঙ্গলের জন্য বলির রক্ত ও মেদ উৎসর্গ করে, সে নিজের অংশ হিসাবে তার ডান জঙ্ঘা পাবে। ");
INSERT INTO benirv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","কারণ ইস্রায়েল সন্তানদের থেকে আমি মঙ্গলের জন্য বলির নৈবেদ্যের জন্যে বক্ষ ও উত্তোলনীয় নৈবেদ্যের জন্যে জঙ্ঘা নিয়ে ইস্রায়েল সন্তানদের দেওয়া বলে সবদিনের অধিকার হিসাবে তা হারোণ যাজক ও তার ছেলেদেরকে দিলাম। ");
INSERT INTO benirv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","যে দিনের তারা সদাপ্রভুর যাজকের কাজ করতে নিযুক্ত হয়, সেই দিন থেকে সদাপ্রভুর আগুনের তৈরী উপহার থেকে এটাই হারোণের ও তার ছেলেদের জন্য অংশ। ");
INSERT INTO benirv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","সদাপ্রভু তাদের অভিষেক দিনের বংশানুক্রমে ইস্রায়েল সন্তানদের দেওয়া বলে সবদিনের র অধিকার হিসাবে এটা তাদেরকে দিতে আদেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","হোমের, শস্য নৈবেদ্যের, পাপের বলির, অপরাধের বলির, অভিষেকের ও মঙ্গলের জন্য বলির এই ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","সদাপ্রভু যে দিন সীনয় মরুপ্রান্তে ইস্রায়েল সন্তানদের সদাপ্রভুর উদ্দেশ্যে নিজেদের উপহার উৎসর্গ করতে আদেশ দিলেন, সেই দিন সীনয় পর্বতে মোশিকে এই বিষয়ের আদেশ দিলেন’।” ");
INSERT INTO benirv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“তুমি হারোণকে ও তার সঙ্গে তার ছেলেদেরকে এবং পোশাক সব, অভিষেকের জন্য তেল ও পাপের বলির গোবত্স, দুটি মেষ ও খামি ছাড়া রুটির ডালি সঙ্গে নাও, ");
INSERT INTO benirv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","আর সমাগম তাঁবুর প্রবেশ দরজার সামনে সমস্ত মণ্ডলীকে জড়ো কর।” ");
INSERT INTO benirv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","তাতে মোশি সদাপ্রভুর আদেশ অনুসারে সেরকম করলেন এবং সমাগম তাঁবুর প্রবেশ দরজার সামনে মণ্ডলী জড়ো হল। ");
INSERT INTO benirv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","তখন মোশি মণ্ডলীকে বললেন, “সদাপ্রভু এই কাজ করতে আদেশ দিলেন।” ");
INSERT INTO benirv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","পরে মোশি হারোণ ও তাঁর ছেলেদেরকে কাছে এনে জলে স্নান করালেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","আর হারোণকে পরিচ্ছদ পরালেন, কোমরবন্ধনে বাঁধলেন, তাঁর গায়ে পরিচ্ছদ ও তাঁর ওপরে এফোদ দিলেন এবং এফোদের বিনুনি করা কোমরবন্ধনে আবদ্ধ করে তার সঙ্গে এফোদখানি বাঁধলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","আর তাঁর বক্ষে বুকপাটা দিলেন এবং বুকপাটায় ঊরীম ও তুম্মীম বাঁধলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","আর তাঁর মাথায় পাগড়ি দিলেন ও তাঁর কপালে পাগড়ির ওপরে সোনার পাতের পবিত্র মুকুট দিলেন; যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","পরে মোশি অভিষেকের জন্য তেল নিয়ে আবাস ও তার মধ্যে অবস্থিত সব জিনিস অভিষেক করে পবিত্র করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","আর তার কিছু নিয়ে বেদির ওপরে সাত বার ছিঁটিয়ে দিলেন এবং বেদি ও সেই সম্মন্ধীয় সব পাত্র, পরিষ্কার করার পাত্র ও তার ভিত্তি পবিত্র করার জন্যে অভিষেক করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","পরে অভিষেকের জন্য তেলের কিছুটা হারোণের মাথায় ঢেলে তাঁকে পবিত্র করার জন্যে অভিষেক করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","মোশি হারোণের ছেলেদেরকে কাছে এনে তাদেরকেও পরিচ্ছদ পরালেন, কোমরবন্ধনে বাঁধলেন ও তাদের মাথায় মাথার আবরণ বেঁধে দিলেন; যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","মোশি পাপের বলির ষাঁড় জন্য আনলেন এবং হারোণ ও তাঁর ছেলেরা সেই পাপের বলির জন্য ষাঁড়ের মাথায় হাত বাড়িয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","তখন তিনি তা হত্যা করলেন এবং মোশি তার রক্ত নিয়ে, আঙ্গুলের মাধ্যমে বেদির চারদিকে শৃঙ্গে দিয়ে বেদিকে শুদ্ধ করলেন এবং বেদির ভিত্তিতে রক্ত ঢেলে দিলেন ও তার জন্য প্রায়শ্চিত্ত করার জন্যে তা পবিত্র করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","পরে তিনি অন্ত্রের উপরে অবস্থিত সমস্ত মেদ ও যকৃতের ফুসফুস এবং দুটি কিডনি ও তার মেদ নিলেন ও মোশি তা বেদির ওপরে পোড়ালেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","আর তিনি চামড়া, মাংস ও গোবর শুদ্ধ ষাঁড়টি নিয়ে গিয়ে শিবিরের বাইরে আগুনে পুড়িয়ে দিলেন; যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","পরে তিনি হোমবলির জন্য মেষটি আনলেন; আর হারোণ ও তাঁর ছেলেরা সেই মেষের মাথায় হাত বাড়িয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","আর তিনি তা হত্যা করলেন এবং মোশি বেদির ওপরে চারদিকে তার রক্ত ছিঁটালেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","আর তিনি মেষটি টুকরো টুকরো করলেন এবং মোশি তার মাথা, টুকরোগুলি ও মেদ পোড়ালেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","পরে তিনি তার অন্ত্র ও পা জলে ধুলেন এবং মোশি পুরো মেষটি বেদির ওপরে পোড়ালেন; এটা সুগন্ধের হোমবলি; এটা সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার; যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","পরে তিনি দ্বিতীয় মেষ অর্থাৎ উত্সর্গ করার জন্য মেষটি আনলেন এবং হারোণ ও তাঁর ছেলেরা ঐ মেষের মাথায় হাত বাড়িয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","আর তিনি তাকে হত্যা করলেন এবং মোশি তাঁর কিছুটা রক্ত নিয়ে হারোণের ডান কানের প্রান্তে ও ডান হাতের বুড়ো আঙ্গুলের ওপরে এবং তার ডান পায়ের বুড়ো আঙ্গুলের ওপরে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","তিনি হারোণের ছেলেদেরকে কাছে আনলেন ও মোশি সেই রক্তের কিছুটা নিয়ে তাদের ডান কানের প্রান্তে, ডান হাতের বুড়ো আঙ্গুলের ওপরে ও ডান পায়ের বুড়ো আঙ্গুলের ওপরে দিলেন এবং পরে মোশি বাকি রক্ত বেদির ওপরে চারদিকে ছিঁটালেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","তিনি মেদ ও লেজ এবং অন্ত্রের ওপরে অবস্থিত সমস্ত মেদ ও যকৃতের ওপরে অবস্থিত ফুসফুস এবং দুটি কিডনি, তার মেদ ও ডান জঙ্ঘা নিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","পরে সদাপ্রভুর সামনে অবস্থিত খামি ছাড়া রুটির ঝুড়ি থেকে একটি খামি ছাড়া পিষ্টক, তৈলাক্ত রুটির একটি পিষ্টক ও একটি সরুচাকলী নিয়ে ঐ মেদের ও ডান জঙ্ঘার ওপরে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","হারোণের ও তাঁর ছেলেদের হাতে সে সব দিয়ে সদাপ্রভুর সামনে দোলনীয় নৈবেদ্যের জন্য দোলালেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","পরে মোশি তাদের হাত থেকে সে সব নিয়ে বেদিতে হোমবলির ওপরে পোড়ালেন; এই সব সুগন্ধের, উত্সর্গের নৈবেদ্য, এটা সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার হল। ");
INSERT INTO benirv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","মোশি বক্ষ নিয়ে সদাপ্রভুর সামনে দোলনীয় নৈবেদ্যের জন্য দোলালেন; এটা উত্সর্গের মেষ থেকে মোশির অংশ হল; যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","পরে মোশি অভিষেকের জন্য তেল থেকে ও বেদির ওপরে অবস্থিত রক্ত থেকে কিছুটা নিয়ে হারোণের উপরে, তাঁর পোশাকের ওপরে এবং সেই সঙ্গে তাঁর ছেলেদের ওপরে ও তাদের পোশাকের ওপরে ছিঁটিয়ে দিয়ে হারোণকে ও তাঁর পোশাক সব এবং সেই সঙ্গে তাঁর ছেলেদেরকেও তাদের পোশাক সব পবিত্র করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","পরে মোশি হারোণ ও তাঁর ছেলেদেরকে বললেন, “তোমরা সমাগম তাঁবুর প্রবেশ দরজায় মাংস সিদ্ধ কর এবং হারোণ ও তাঁর ছেলেরা তা খাবেন, আমার এই আদেশ অনুসারে তোমরা সেই জায়গায় তা এবং উত্সর্গের ঝুড়িতে অবস্থিত রুটি খাও। ");
INSERT INTO benirv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","পরে বাকি মাংস ও রুটি নিয়ে আগুনে পুড়িয়ে দাও। ");
INSERT INTO benirv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","আর তোমরা সাত দিন, অর্থাৎ তোমাদের উত্সর্গের শেষ দিন পর্যন্ত, সমাগম তাঁবুর দরজা থেকে বের হয়ো না; কারণ তিনি সাত দিন তোমাদের পবিত্র করবেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","আজ যেমন করা গিয়েছে, তোমাদের জন্যে প্রায়শ্চিত্ত করার জন্যে সেরকম করার আদেশ সদাপ্রভু দিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","তোমরা যেন মারা না পড়, এই জন্য সাত দিন পর্যন্ত সমাগম তাঁবুর দরজায় দিন রাত থাকবে এবং সদাপ্রভুর রক্ষণীয় রক্ষা করবে; কারণ আমি এরকম আদেশ পেয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","সদাপ্রভু মোশির মাধ্যমে যেমন আদেশ করেছিলেন, হারোণ ও তাঁর ছেলেরা সে সবই পালন করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","পরে অষ্টম দিনের মোশি হারোণ ও তাঁর ছেলেদেরকে এবং ইস্রায়েলের প্রাচীনদেরকে ডাকলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","তখন তিনি হারোণকে বললেন, তুমি পাপের বলির জন্য নির্দোষ এক পুরুষ গরুর বাচ্চা ও হোমবলির জন্য নির্দোষ এক ভেড়া নিয়ে সদাপ্রভুর সামনে উপস্থিত কর। ");
INSERT INTO benirv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","আর ইস্রায়েল-সন্তানদেরকে বল, তোমরা সদাপ্রভুর সামনে বলি দেওয়ার জন্য পাপের বলির জন্য এক ছাগল, হোমবলির জন্য এক বছরের নির্দোষ এক গরুর বাছুর ও এক ভেড়ার বাচ্চা ");
INSERT INTO benirv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","এবং মঙ্গলের বলির জন্য এক ষাঁড় ও এক ভেড়া এবং তেল মেশানো ভক্ষ্য-নৈবেদ্য নেবে; কারণ আজ সদাপ্রভু তোমাদেরকে দর্শন দেবেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","তখন তারা মোশির আজ্ঞানুসারে এই সব সমাগম-তাঁবুর সামনে আনল, আর সব মণ্ডলী নিকটবর্ত্তী হয়ে সদাপ্রভুর সামনে দাঁড়াল। ");
INSERT INTO benirv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","পরে মোশি বললেন, সদাপ্রভু তোমাদেরকে এই কাজ করতে আজ্ঞা করেছেন, এটা করলে তোমাদের প্রতি সদাপ্রভু প্রতাপ প্রকাশ পাবে। ");
INSERT INTO benirv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","তখন মোশি হারোণকে বললেন, তুমি বেদির কাছে যাও, তোমার পাপের জন্য বলি ও হোমবলি উৎসর্গ কর, নিজের ও লোকদের জন্য প্রায়শ্চিত্ত কর; আর লোকদের উপহার উত্সর্গ করে তাদের জন্য প্রায়শ্চিত্ত কর; যেমন সদাপ্রভু আজ্ঞা দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","তাতে হারোণ বেদির কাছে গিয়ে নিজের জন্য পাপের বলির জন্য গরুর বাচ্চা হত্যা করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","পরে হারোণের ছেলেরা তাঁর কাছে তার রক্ত আনলেন ও তিনি নিজের আঙুল রক্তে ডুবিয়ে বেদির শিংএর ওপরে দিলেন এবং বাকি রক্ত বেদির মূলে ঢাললেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","আর পাপের জন্য বলির মেদ, মেটিয়া ও যকৃতের ওপরের অংশ ফুসফুস বেদির উপরে পোড়ালেন; যেমন সদাপ্রভু মোশিকে আজ্ঞা দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","কিন্তু তার মাংস ও চর্ম্ম শিবিরের বাইরে আগুনে পুড়িয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","পরে তিনি হোমের জন্য বলি হত্যা করলেন এবং হারোণের ছেলেরা তাঁর কাছে তার রক্ত আনলে তিনি বেদির চারিদিকে তা ছিটিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","পরে তারা হোমবলির মাংসের টুকরো ও মাথা সব তাঁর কাছে আনলেন; তিনি সেই সব বেদির ওপরে পোড়ালেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","পরে তার অন্ত্র ও পা ধুয়ে বেদিতে হোমবলির ওপরে পোড়ালেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","পরে তিনি লোকদের উপহার কাছে আনলেন এবং লোকদের জন্য পাপের বলির ছাগল নিয়ে প্রথমটার মত হত্যা করে পাপের জন্য উৎসর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","পরে তিনি হোমবলি এনে বিধিমতে উৎসর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","আর ভক্ষ্য-নৈবেদ্য এনে তার এক মুঠো নিয়ে বেদির ওপরে পোড়ালেন। এছাড়া তিনি সকালের হোমবলি দান করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","পরে তিনি লোকদের মঙ্গলের জন্য বলি ঐ ষাঁড় ও ভেড়া হত্যা করলেন এবং হারোণের ছেলেরা তাঁর কাছে তার রক্ত আনলে তিনি বেদির ওপরে চারিদিকে তা ছিটিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","পরে ষাঁড়ের মেদ ও ভেড়ার লাঙ্গূল এবং অন্ত্রের ও মেটিয়ার উপরিস্থ মেদ ও যকৃতের ওপরের ভাগ ফুসফুস, ");
INSERT INTO benirv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","এই সব মেদ নিয়ে দুই বুকের ওপরে রাখলেন ও বেদির ওপরে সেই মেদ পোড়ালেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","আর হারোণ সদাপ্রভুর সামনে দুই বুক ও ডানদিকের উরু দোলনীয় নৈবেদ্যরূপে দোলালেন; যেমন মোশি আজ্ঞা দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","পরে হারোণ লোকদের দিকে নিজের হাত বাড়িয়ে তাদেরকে আশীর্বাদ করলেন; আর তিনি পাপের জন্য বলি, হোমবলি ও মঙ্গলের জন্য বলি উৎসর্গ করে নেমে এলেন। ");
INSERT INTO benirv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","পরে মোশি ও হারোণ সমাগম তাঁবুতে প্রবেশ করলেন, পরে বাইরে এসে লোকদেরকে আশীর্বাদ করলেন; তখন সব লোকের কাছে সদাপ্রভুর প্রতাপ প্রকাশ পেল। ");
INSERT INTO benirv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","আর সদাপ্রভুর সামনে থেকে আগুন বেরিয়ে বেদির ওপরের হোমবলি ও মেদ ছাই করল; তা দেখে সব লোক আনন্দের চিত্কার করে উপুড় হয়ে পড়ল। ");
INSERT INTO benirv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","আর হারোণের ছেলে নাদব ও অবীহূ নিজের নিজের ধুনুচি নিয়ে তাতে আগুন রাখল ও তার ওপরে ধূপ দিয়ে সদাপ্রভুর সামনে তাঁর আজ্ঞার বিপরীতে অদ্ভুত আগুন যা সদাপ্রভুর আজ্ঞা বহির্ভূত, তা উৎসর্গ করল। ");
INSERT INTO benirv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","তাতে সদাপ্রভুর সামনে থেকে আগুন বেরিয়ে তাদেরকে গ্রাস করল, তারা সদাপ্রভুর সামনে প্রাণত্যাগ করল। ");
INSERT INTO benirv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","তখন মোশি হারোণকে বললেন, সদাপ্রভু তো এটাই বলেছিলেন, তিনি বলেছিলেন, যারা আমার কাছে আসে, তাদের মধ্যে আমি অবশ্য পবিত্রভাবে মান্য হব ও সব লোকের সামনে গৌরবান্বিত হব। তখন হারোণ চুপ করে থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","পরে মোশি হারোণের বাবার মত উষীয়েলের ছেলে মীশায়েল ও ইলীষাফণকে ডেকে বললেন, কাছে এসে তোমাদের ঐ দুই জন ভাইকে তুলে পবিত্র জায়গার সামনে থেকে শিবিরের বাইরে নিয়ে যাও। ");
INSERT INTO benirv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","তাতে তারা কাছে গিয়ে জামা শুদ্ধ তাদেরকে তুলে শিবিরের বাইরে নিয়ে গেল; যেমন মোশি বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","পরে মোশি হারোণকে ও তাঁর দুই ছেলে ইলীয়াসর ও ঈথামরকে বললেন, তোমরা যেন মারা না পড় ও সব মণ্ডলীর প্রতি যেন রাগ না হয়, এই জন্য তোমরা নিজের নিজের মাথা ন্যাড়া কোরো না ও নিজের নিজের কাপড় ছিঁড় না; কিন্তু তোমাদের ভাইয়েরা, অর্থাৎ সমস্ত ইস্রায়েল-কুল, সদাপ্রভুর করা আগুনে শোক করুক। ");
INSERT INTO benirv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","আর তোমরা যেন মারা না পড়, এই জন্য সমাগম-তাঁবুর দরজার বাইরে যেও না, কারণ তোমাদের গায়ে সদাপ্রভুর অভিষেক-তেল আছে। তাতে তাঁরা মোশির বাক্য অনুসারে সে রকম করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","পরে সদাপ্রভু হারোণকে বললেন, তোমরা যেন মারা না পড়, ");
INSERT INTO benirv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","এই জন্য যে দিনের তুমি কিংবা তোমার ছেলেরা সমাগম-তাঁবুতে ঢুকবে, সে দিনের আঙ্গুর রস কি মদ পান কোরো না; এটা পুরুষানুক্রমে তোমাদের পালনীয় চিরস্থায়ী বিধি। ");
INSERT INTO benirv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","তাতে তোমরা পবিত্র ও সামান্য বিষয়ের এবং শুচি ও অশুচি বিষয়ের তফাৎ করতে ");
INSERT INTO benirv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","এবং সদাপ্রভু মোশির মাধ্যমে ইস্রায়েল-সন্তানদেরকে যে সব বিধি দিয়েছেন, তাদেরকে শিক্ষা দিতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","পরে মোশি হারোণকে ও তাঁর অবশিষ্ট দুই ছেলে ইলীয়াসর ও ঈথামরকে বললেন, সদাপ্রভুর উদ্দেশ্যে আগুনের তৈরী উপহারের অবশিষ্ট যে খাওয়ার নৈবেদ্য আছে, তা নিয়ে গিয়ে তোমরা বেদির পাশে বিনা তাড়ীতে খাও, কারণ তা অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","কোন পবিত্র জায়গায় তা খাবে; কারণ সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহারের মধ্যে তাই তোমার ও তোমার ছেলেদের পাওনা অংশ; কারণ আমি এই আজ্ঞা পেয়েছি। ");
INSERT INTO benirv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","আর উন্নীত বুক ও উরু তুমি ও তোমার ছেলে মেয়েরা কোনো শুচি জায়গায় খাবে, কারণ ইস্রায়েল-সন্তানদের মঙ্গলের জন্য বলিদান থেকে তা তোমার ও তোমার ছেলেদের পাওনা অংশ বলে দেওয়া হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","তারা হবনীয় মেদের সঙ্গে উন্নত উরু ও বুক নৈবেদ্য বলে সদাপ্রভুর সামনে দোলাবার জন্য আনবে; তা তোমার ও তোমার ছেলেদের চিরস্থায়ী অধিকার হবে; যেমন সদাপ্রভু আজ্ঞা করেছেন। ");
INSERT INTO benirv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","পরে মোশি যত্নপূর্ব্বক পাপের জন্য ছাগলের খোঁজ করলেন, আর দেখ, তা পুড়িয়ে দেওয়া হয়েছিল; সেই জন্য তিনি হারোণের বাকি দুই ছেলে ইলীয়াসর ও ঈথামরের ওপর রেগে গিয়ে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","সেই পাপের জন্য দেওয়া বলি তোমরা পবিত্র জায়গায় খাওনি কেন? তা তো অতি পবিত্র এবং মণ্ডলীর অপরাধ বহন করে সদাপ্রভুর সামনে প্রায়শ্চিত্ত করার জন্য তা তিনি তোমাদেরকে দিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","দেখ, ভিতরে পবিত্র জায়গায় তাঁর রক্ত আনা হয়নি; আমার আজ্ঞানুসারে পবিত্র জায়গায় তা খাওয়া তোমাদের কর্তব্য ছিল। ");
INSERT INTO benirv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","তখন হারোণ মোশিকে বললেন, দেখ, ওরা আজ সদাপ্রভুর উদ্দেশ্যে নিজের নিজের পাপের জন্য বলি ও নিজের নিজের হোমবলি উৎসর্গ করেছে, আর আমার ওপর এ রকম হল; যদি আমি আজ পাপের জন্য দেওয়া বলি খেতাম, তবে সদাপ্রভুর চোখে তা কি ভাল বোধ হত? ");
INSERT INTO benirv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","মোশি যখন এটা শুনলেন, তাঁর চোখে ভাল বোধ হল। ");
INSERT INTO benirv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","আর সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“তোমরা ইস্রায়েল সন্তানদের বল, ভূচর সমস্ত পশুর মধ্যে এই সব জীব তোমাদের খাদ্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","পশুদের মধ্যে যে কোনো পশু সম্পূর্ণ দুই টুকরো খুরবিশিষ্ট ও জাবর কাটে, তা তোমরা খেতে পার। ");
INSERT INTO benirv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","কিন্তু যারা জাবর কাটে, কিংবা দুই টুকরো খুরবিশিষ্ট, তাদের মধ্যে তোমরা এই এই পশু খাবে না। উট তোমাদের পক্ষে অশুচি, কারণ সে জাবর কাটে বটে, কিন্তু দুই টুকরো খুরবিশিষ্ট নয়। ");
INSERT INTO benirv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","আর শাফন তোমাদের পক্ষে অশুচি, কারণ সে জাবর কাটে, কিন্তু দুই টুকরো খুরবিশিষ্ট নয় ");
INSERT INTO benirv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","এবং খরগোশ তোমাদের পক্ষে অশুচি, কারণ সে জাবর কাটে, কিন্তু দুই টুকরো খুরবিশিষ্ট নয়। ");
INSERT INTO benirv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","আর শূকর তোমাদের পক্ষে অশুচি, কারণ সে সম্পূর্ণরূপে দুই টুকরো খুরবিশিষ্ট বটে, কিন্তু জাবর কাটে না। ");
INSERT INTO benirv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","তোমরা তাদের মাংস খেও না এবং তাদের মৃতদেহও স্পর্শ কোরো না; তারা তোমাদের পক্ষে অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","জলে বাস করা জন্তুদের মধ্যে তোমরা এই সব খেতে পার; সমুদ্রে কি নদীতে অবস্থিত জন্তুর মধ্যে ডানা ও আঁশবিশিষ্ট জন্তু তোমাদের খাদ্য। ");
INSERT INTO benirv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","কিন্তু সমুদ্রে কি নদীতে অবস্থিত জলচরদের মধ্যে, জলে অবস্থিত যাবতীয় প্রাণীর মধ্যে যারা ডানা ও আঁশবিশিষ্ট নয়, তারা তোমাদের পক্ষে ঘৃণিত। ");
INSERT INTO benirv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","তারা তোমাদের জন্যে ঘৃণিত হবে; তোমরা তাদের মাংস খাবে না, তাদের মৃতদেহও ঘৃণা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","জলজ জন্তুর মধ্যে যাদের ডানা ও আঁশ নাই, সে সবই তোমাদের জন্যে ঘৃণিত। ");
INSERT INTO benirv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","আর পাখিদের মধ্যে এই সব তোমাদের জন্যে ঘৃণিত হবে; এ সব অখাদ্য, এ সব ঘৃণিত; ঈগল, শকুন, ");
INSERT INTO benirv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","চিল ও যে কোনো বাজপাখি ");
INSERT INTO benirv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","এবং বিভিন্ন ধরনের কাক, ");
INSERT INTO benirv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","উটপাখি, রাত্রিশ্যেন ও গাংচিল এবং নিজেদের জাতি অনুসারে শ্যেন, ");
INSERT INTO benirv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","পেঁচা, মাছরাঙ্গা ও মহাপেঁচা, ");
INSERT INTO benirv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","দীর্ঘগল হাঁস, পানিভেলা ও শকুনী, ");
INSERT INTO benirv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","সারস এবং নিজেদের জাতি অনুসারে বক, টিট্টিভ ও বাদুড়। ");
INSERT INTO benirv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","চার পায়ে চলা পতঙ্গ সব তোমাদের জন্য ঘৃণিত। ");
INSERT INTO benirv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","তাছাড়া চার পায়ে চলা পাখনাবিশিষ্ট জন্তুর মধ্যে মাটিতে লাফানোর জন্যে যাদের পায়ের নলী দীর্ঘ, তারা তোমাদের খাদ্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ফলে নিজেদের জাতি অনুসারে পঙ্গপাল, নিজেদের জাতি অনুসারে বিধ্বংসী পঙ্গপাল, নিজেদের জাতি অনুসারে ঝিঁঝিঁ এবং নিজেদের জাতি অনুসারে অন্য ফড়িঙ্গ, এই সব তোমাদের খাদ্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","কিন্তু আর সমস্ত চার পায়ে উড়ে বেড়ানো পতঙ্গ তোমাদের জন্য ঘৃণিত। ");
INSERT INTO benirv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","এই সবের মাধ্যমে তোমরা অশুচি হবে; যে কেউ তাদের মৃতদেহ স্পর্শ করবে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","আর যে কেউ তাদের মৃতদেহের কোনো অংশ বয়ে নিয়ে যাবে, সে নিজের পোশাক ধোবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","যে সব পশু সম্পূর্ণভাবে দুই টুকরো খুরবিশিষ্ট না এবং জাবর কাটে না, তারা তোমাদের জন্যে অশুচি; যে কেউ তাদেরকে স্পর্শ করে, সে অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","আর সমস্ত চার পায়ে চলা জন্তুর মধ্যে যে যে জন্তু থাবার মাধ্যমে চলে, তারা তোমাদের জন্যে অশুচি; যে কেউ তাদের শব স্পর্শ করবে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","যে কেউ তাদের মৃতদেহ বয়ে নিয়ে যাবে, সে নিজের পোশাক ধোবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে; তারা তোমাদের জন্যে অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","আর বুকে হেঁটে চলা সরীসৃপের মধ্যে এই সব তোমাদের জন্যে অশুচি; নিজেদের জাতি অনুসারে বেজি, ইঁদুর ও টিকটিকি, ");
INSERT INTO benirv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","গোসাপ, নীল টিকটিকি, মেটে গিরগিটি, হরিৎ টিকটিকি ও বহুরূপী। ");
INSERT INTO benirv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","সরীসৃপের এই সব তোমাদের জন্যে অশুচি; এই সব মারা গেলে যে কেউ তাদেরকে স্পর্শ করবে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","আর তাদের মধ্যে কারো মৃতদেহ যে জিনিসের ওপরে পড়বে, সেটাও অশুচি হবে; কাঠের পাত্র কিংবা পোশাক কিংবা চামড়া কিংবা চট, যে কোনো কাজের যোগ্য পাত্র হোক, তা জলে ডোবাতে হবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে; পরে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","কোনো মাটির পাত্রের মধ্যে তাদের মৃতদেহ পড়লে তার মধ্যে অবস্থিত সব জিনিস অশুচি হবে ও তোমরা তা ভেঙে ফেলবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","তার মধ্যে অবস্থিত যে কোনো খাদ্য সামগ্রীর ওপরে জল দেওয়া যায়, তা অশুচি হবে এবং এই ধরনের সব পাত্রে সব প্রকার পানীয় জিনিস অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","যে কোনো জিনিসের ওপরে তাদের মৃতদেহের কিছু অংশ পড়ে, তা অশুচি হবে এবং যদি উনানে কিংবা রান্নার পাত্রে পড়ে, তবে তা ভেঙে ফেলতে হবে; তা অশুচি, তোমাদের জন্যে অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ঝরনা কিংবা যে কুয়োতে অনেক জল থাকে, তা শুচি হবে; কিন্তু যাতে তাদের মৃতদেহ স্পৃষ্ট হবে, তাই অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","আর তাদের মৃতদেহের কোনো অংশ যদি কোনো বপন করা বীজে পড়ে, তবে তা শুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","কিন্তু বীজের ওপরে জল থাকলে যদি তাদের মৃতদেহের কোনো অংশ তার ওপরে পড়ে, তবে তা তোমাদের জন্যে অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","আর তোমাদের খাবার কোনো পশু মরলে, যে কেউ তার মৃতদেহ স্পর্শ করবে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","আর যে কেউ তার মৃতদেহের মাংস খাবে, সে নিজের পোশাক ধোবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। আর যে কেউ সেই শব বহন করবে, সেও নিজের বস্ত্র ধোবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে ");
INSERT INTO benirv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","আর বুকে হেঁটে চলা প্রত্যেক কীট ঘৃণিত; তা অখাদ্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","বুকে হেঁটে চলা হোক কিংবা চার পায়ে কিংবা অনেক পায়ে হেঁটে চলা হোক, যে কোনো বুকে হেঁটে চলা কীট হোক, তোমরা তা খেও না, তা ঘৃণিত। ");
INSERT INTO benirv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","কোনো বুকে হেঁটে চলা কীটের মাধ্যমে তোমরা নিজেদেরকে ঘৃণিত কোরো না ও সেই সবের মাধ্যমে নিজেদেরকে অশুচি কোরো না, পাছে তার মাধ্যমে অশুচি হও। ");
INSERT INTO benirv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","কারণ আমি সদাপ্রভু তোমাদের ঈশ্বর; অতএব তোমরা নিজেদেরকে পবিত্র কর; পবিত্র হও, কারণ আমি পবিত্র; তোমরা মাটির ওপরে চলা কোনো ধরনের বুকে হেঁটে চলা জীবের মাধ্যমে নিজেদেরকে অপবিত্র কোরো না। ");
INSERT INTO benirv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","কারণ আমি সদাপ্রভু তোমাদের ঈশ্বর হবার জন্য মিশর দেশ থেকে তোমাদেরকে এনেছি; অতএব তোমরা পবিত্র হবে, কারণ আমি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","পশু, পাখি, জলচর সমস্ত প্রাণীর ও মাটিতে বুকে হেঁটে চলা সমস্ত প্রাণীর বিষয়ে এই ব্যবস্থা; ");
INSERT INTO benirv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","এতে শুচি অশুচি জিনিসের ও খাদ্য অখাদ্য প্রাণীর পার্থক্য জানা যায়।” ");
INSERT INTO benirv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“তুমি ইস্রায়েল সন্তানদের বল, যে স্ত্রী গর্ভধারণ করে ছেলের জন্ম দেয়, সে সাত দিন অশুচি থাকবে, যেমন মাসিক দিন কালের অশৌচের দিনের, তেমনি সে অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","পরে অষ্টম দিনের বালকটির পুরুষাঙ্গের ত্বকছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","আর সে স্ত্রী তেত্রিশ দিন পর্যন্ত নিজে শুদ্ধকরণ রক্তস্রাব অবস্থায় থাকবে; যতক্ষণ শুদ্ধিকরণের দিন পূর্ণ না হয়, ততক্ষণ সে কোনো পবিত্র পোশাক স্পর্শ করবে না এবং পবিত্র জায়গায় প্রবেশ করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","আর যদি সে মেয়ের জন্ম দেয়, তবে যেমন অশৌচের দিনের, তেমনি দুই সপ্তাহ অশুচি থাকবে; পরে সে ছেষট্টি দিন নিজের শুদ্ধকরণ রক্তস্রাব অবস্থায় থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","পরে ছেলে কিংবা মেয়ের জন্মের শুদ্ধিকরণের দিন সম্পূর্ণ হলে সে হোমবলির জন্য এক বছরের একটি মেষ এবং পাপের বলির জন্য একটি পায়রার শাবক কিংবা একটি ঘুঘু সমাগম তাঁবুর প্রবেশ দরজায় যাজকের কাছে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","আর যাজক সদাপ্রভুর সামনে তা উৎসর্গ করে সে স্ত্রীর জন্যে প্রায়শ্চিত্ত করবে, তাতে সে নিজের রক্তস্রাব থেকে শুচি হবে। ছেলে কিংবা মেয়ের জন্মদাত্রীর জন্য এই ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","যদি সে মেষ আনতে অক্ষম হয়, তবে দুটি ঘুঘু কিংবা দুটি পায়রার শাবক নিয়ে তার একটি হোমের জন্যে, অন্যটি পাপের জন্যে দেবে; আর যাজক তার জন্যে প্রায়শ্চিত্ত করবে, তাতে সে শুচি হবে।” ");
INSERT INTO benirv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","আর সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","যদি কোনো মানুষের শরীরের চামড়ায় শোথ কিংবা খোস কিংবা উজ্জ্বল দাগ হয়, আর তা শরীরের গুরুতর চরম রোগের ঘায়ের মতো হয়, তবে সে হারোণ যাজকের কাছে কিংবা তার ছেলে যাজকদের মধ্যে কারো কাছে আনা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","পরে যাজক তার শরীরের চামড়ায় অবস্থিত ঘা দেখবে; যদি ঘায়ের লোম সাদা হয়ে থাকে এবং ঘা যদি দেখতে শরীরের চামড়ার থেকে নিম্ন মনে হয়, তবে তা কুষ্ঠরোগের ঘা, তা দেখে যাজক তাকে অশুচি বলবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","আর উজ্জ্বল দাগ যদি তার শরীরের চামড়া সাদা হয়, কিন্তু দেখতে চামড়ার থেকে নিম্ন না হয় এবং তার লোম সাদা না হয়ে থাকে, তবে যার ঘা হয়েছে, যাজক তাকে সাত দিন আলাদা করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","পরে সপ্তম দিনের যাজক তাকে দেখবে; আর দেখ, যদি তার দৃষ্টিতে ঘা সেরকম থাকে, চামড়ায় ঘা ছড়িয়ে না থাকে, তবে যাজক তাকে আরও সাত দিন আলাদা করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","আর সপ্তম দিনের যাজক তাকে আবার দেখবে; আর দেখ, যদি ঘা ভালো হয়ে থাকে ও চামড়ায় ছড়িয়ে না থাকে, তবে যাজক তাকে শুচি বলবে; এটি ফুসকুড়ি; পরে সে নিজের পোশাকে ধুয়ে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","কিন্তু তার পরিষ্কারের জন্যে যাজককে দেখান হলে পর যদি তার ফুসকুড়ি চামড়ায় ছড়িয়ে থাকে, তবে আবার যাজককে দেখাতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","তাতে যাজক দেখবে, আর দেখ, যদি তার ফুসকুড়ি চামড়ায় ছড়িয়ে থাকে, তবে যাজক তাকে অশুচি বলবে; তা কুষ্ঠরোগ। ");
INSERT INTO benirv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","কারোর কুষ্ঠরোগের ঘা হলে সে যাজকের কাছে আসবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","পরে যাজক দেখবে; যদি তার চামড়ায় সাদা শোথ থাকে এবং তার লোম সাদা হয়ে থাকে ও শোথে কাঁচা মাংস থাকে, ");
INSERT INTO benirv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","তবে তা তার শরীরের চামড়ার পুরানো কুষ্ঠ, আর যাজক তাকে অশুচি বলবে; আলাদা করবে না; কারণ সে অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","আর চামড়ার সর্বত্র কুষ্ঠরোগ ছড়িয়ে গেলে যদি যাজকের দৃষ্টিতে ঘা বিশিষ্ট ব্যক্তির মাথা থেকে পা পর্যন্ত সমস্ত চামড়া কুষ্ঠরোগে আচ্ছন্ন হয়ে থাকে, ");
INSERT INTO benirv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","তবে যাজক তা দেখবে; আর দেখ, যদি তার সমস্ত শরীর কুষ্ঠরোগে আচ্ছন্ন হয়ে থাকে, তবে সে, যার ঘা হয়েছে, তাকে শুচি বলবে; তার সর্বাঙ্গই শুল্ক হল, সে শুচী। ");
INSERT INTO benirv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","কিন্তু যখন তার শরীরে কাঁচা মাংস প্রকাশ পায়, তখন সে অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","যাজক তার কাঁচা মাংস দেখে তাকে অশুচি বলবে; সেই কাঁচা মাংস অশুচি; তা কুষ্ঠ। ");
INSERT INTO benirv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","আর সে কাঁচা মাংস যদি আবার সাদা হয়, তবে সে যাজকের কাছে যাবে, আর যাজক তাকে দেখবে; ");
INSERT INTO benirv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","আর দেখ, যদি তার ঘা সাদা হয়ে থাকে, তবে যাজক, যার ঘা হয়েছে, তাকে, শুচি বলবে; সে শুচী। ");
INSERT INTO benirv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","আর শরীরের চামড়ায় ঘা হয়ে ভাল হলে পর, ");
INSERT INTO benirv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","যদি সেই ঘায়ের জায়গায় সাদা শোথ কিংবা সাদা ও ঈষৎ রক্তবর্ণ চিক্কণ চিহ্ন হয়, তবে যাজকের কাছে তা দেখাতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","আর যাজক তা দেখবে, আর দেখ, যদি তার দৃষ্টিতে তা চামড়ার থেকে নিম্ন বোধ হয় ও তার লোম সাদা হয়ে থাকে, তবে যাজক তাকে অশুচি বলবে; তা স্ফোটকে উৎপন্ন কুষ্ঠরোগের ঘা। ");
INSERT INTO benirv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","কিন্তু যদি যাজক তাতে সাদা লোম না দেখে এবং তা চামড়ার থেকে নিম্ন বোধ না হয় ও মলিন হয়, তবে যাজক তাকে সাত দিন আবদ্ধ করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","পরে তা যদি চামড়ায় ছড়িয়ে যায়, তবে যাজক তাকে অশুচি বলবে; ওটা ঘা। ");
INSERT INTO benirv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","কিন্তু যদি চিক্কণ চিহ্ন নিজের জায়গায় ও না বাড়ে, তবে তা স্ফোটকের দাগ; যাজক তাকে শুচি বলবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","আর যদি শরীরের চামড়া আগুনে পুড়ে যায় ও সেই পুড়ে যাওয়া জায়গায় ঈষৎ লালচে সাদা কিংবা কেবল সাদা দাগ হয়, তবে যাজক তা দেখবে; ");
INSERT INTO benirv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","আর দেখ, দাগে অবস্থিত লোম যদি সাদা হয় ও দেখতে চামড়ার থেকে নিম্ন বোধ হয়, তবে তা আগুনে পুড়ে উৎপন্ন কুষ্ঠরোগ; অতএব যাজক তাকে অশুচি বলবে, তা কুষ্ঠরোগের ঘা। ");
INSERT INTO benirv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","কিন্তু যদি যাজক দেখে, দাগে অবস্থিত লোম সাদা নয় ও চিহ্ন চামড়ার থেকে নিম্ন নয়, কিন্তু মলিন, তবে যাজক তাকে সাত দিন আবদ্ধ করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","পরে সপ্তম দিনের যাজক তাকে দেখবে; যদি চামড়ায় ঐ রোগ ছড়িয়ে থাকে, তবে যাজক তাকে অশুচি বলবে; তা কুষ্ঠরোগের ঘা। ");
INSERT INTO benirv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","আর যদি দাগ নিজের জায়গায় থাকে, চামড়ায় বৃদ্ধি না পায়, কিন্তু মলিন হয়, তবে তা পুড়ে যাওয়া জায়গার শোথ; যাজক তাকে শুচি বলবে, কারণ তা আগুনে পোড়া ক্ষতের চিহ্ন। ");
INSERT INTO benirv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","আর পুরুষের কিংবা স্ত্রীর মাথায় বা দাড়িতে ঘা হলে যাজক সেই ঘা দেখবে; ");
INSERT INTO benirv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","আর দেখ যদি তা দেখতে চামড়ার থেকে নিম্ন বোধ হয় ও হলুদ রঙের সূক্ষ্ম লোম থাকে, তবে যাজক তাকে অশুচি বলবে; ওটা ছুলি, ওটা মাথার বা দাড়ির কুষ্ঠ। ");
INSERT INTO benirv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","আর যাজক যদি ছুলির ঘা দেখে, আর দেখ, তার দৃষ্টিতে তা চামড়ার থেকে নিম্ন না হয় ও তাতে কালো লোম নাই, তবে যাজক সেই ছুলির ঘা বিশিষ্ট ব্যক্তিকে সাত দিন আবদ্ধ করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","পরে সপ্তম দিনের যাজক ঘা দেখবে; আর দেখ, যদি সেই ছুলি বেড়ে না থাকে ও তাতে হলুদ রঙের লোম না হয়ে থাকে এবং দেখতে চামড়ার থেকে ছুলি নিম্ন বোধ না হয়, ");
INSERT INTO benirv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","তবে সে ন্যাড়া হবে, কিন্তু ছুলির জায়গা ন্যাড়া করা যাবে না; পরে যাজক ঐ ছুলি বিশিষ্ট ব্যক্তিকে আর সাত দিন আবদ্ধ করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","আর সাত দিনের যাজক সেই ছুলি দেখবে; আর দেখ, যদি সেই ছুলি চামড়ায় বেড়ে না থাকে ও দেখতে চামড়ার থেকে নিম্ন না হয়ে থাকে, তবে যাজক তাকে শুচি বলবে; পরে সে নিজের পোশাক ধুয়ে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","আর শুচি হলে পর যদি তার চামড়ায় সেই ছুলি ছড়িয়ে যায়, তবে যাজক তাকে দেখবে; ");
INSERT INTO benirv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","আর দেখ, যদি তার চামড়ায় ছুলি বেড়ে থাকে, তবে যাজক হলুদ রঙের লোমের খোঁজ করবে না; সে অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","কিন্তু তার দৃষ্টিতে যদি ছুলি না বেড়ে থাকে ও তাতে কালো লোম উঠে থাকে, তবে সেই ছুলির উপশম হয়েছে, সে শুচী; যাজক তাকে শুচি বলবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","আর যদি কোনো পুরুষের কিংবা স্ত্রীর শরীরের চামড়ার জায়গায় দাগ অর্থাৎ সাদা দাগ হয়, তবে যাজক তা দেখবে; ");
INSERT INTO benirv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","আর দেখ, যদি তার চামড়া থেকে বের হওয়া দাগ মলিন সাদা হয়, তবে তা চামড়ায় উৎপন্ন নির্দোষ স্ফোটক; সে শুচী। ");
INSERT INTO benirv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","আর যে মানুষের চুল মাথা থেকে ঝরে পড়ে, সে নেড়া, সে শুচী। ");
INSERT INTO benirv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","আর যার চুল মাথার শেষ থেকে ঝরে পড়ে, সে কপালে নেড়া, সে শুচী। ");
INSERT INTO benirv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","কিন্তু যদি নেড়া মাথায় কি নেড়া কপালে ঈষৎ রক্তমিশ্রিত সাদা ঘা হয়, তবে তা তার নেড়া মাথায় কিংবা নেড়া কপালে বের হওয়া কুষ্ঠ। ");
INSERT INTO benirv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","যাজক তাকে দেখবে; আর দেখ, যদি শরীরের চামড়ায় অবস্থিত কুষ্ঠের মতো নেড়া মাথায় কিংবা নেড়া কপালে ঈষৎ রক্তমিশ্রিত সাদা ঘা হয়ে থাকে, তবে সে কুষ্ঠী, সে অশুচি; ");
INSERT INTO benirv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","যাজক তাকে অবশ্য অশুচি বলবে; তার তার মাথায় ঘায়ের কারণে। ");
INSERT INTO benirv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","আর যে কুষ্ঠীর ঘা হয়েছে, তার পোশাক চেরা যাবে ও তার মাথা চুল ছাড়া থাকবে ও সে নিজের ঠোঁট পোশাক দিয়ে ঢেকে “অশুচি, অশুচি” এই শব্দ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","যত দিন তার গায়ে ঘা থাকবে, তত দিন সে অশুচি থাকবে; সে অশুচি; সে একা বাস করবে, শিবিরের বাইরে তার বাসস্থান হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","আর লোমের পোশাকে কিংবা মসীনার পোশাকে যদি কুষ্ঠরোগের কলঙ্ক হয়, ");
INSERT INTO benirv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","লোমের কিম্বা মসীনার বোনাতে বা সংযুক্ত করাতে যদি হয়, কিংবা চামড়া কি চামড়ার তৈরী কোনো জিনিসে যদি হয় ");
INSERT INTO benirv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","এবং পোশাকে কিংবা চামড়ায় বোনাতে বা সংযুক্ত করাতে কিম্বা চামড়ার তৈরী কোনো জিনিসে যদি ঈষৎ শ্যামবর্ণ কিংবা লাল রঙয়ের কলঙ্ক হয়, তবে তা কুষ্ঠরোগের কলঙ্ক; তা যাজককে দেখাতে হবে; ");
INSERT INTO benirv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","পরে যাজক ঐ কলঙ্ক দেখে কলঙ্কযুক্ত জিনিস সাত দিন আবদ্ধ করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","পরে সপ্তম দিনের যাজক ঐ কলঙ্ক দেখবে, যদি পোশাকে কিংবা বোনাতে বা সংযুক্ত করাতে কিংবা চামড়া কিংবা চামড়ার তৈরী জিনিসে সেই কলঙ্ক বেড়ে থাকে, তবে তা সংহারক কুষ্ঠ; তা অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","অতএব পোশাক কিংবা লোমকৃত কি মসীনাকৃত বোনা বা সংযুক্ত করা কিংবা চামড়ার তৈরী জিনিস, যে কিছুতে সেই কলঙ্ক হয়, তা সে পুড়িয়ে দেবে; কারণ তা ক্ষতিকর কুষ্ঠ, তা আগুনে পুড়িয়ে দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","কিন্তু যাজক দেখবে; আর দেখ, যদি সেই কলঙ্ক পোশাকে কিংবা বোনা বা সংযুক্ত করাতে কিংবা চামড়ার তৈরী জিনিসে বেড়ে না ওঠে, ");
INSERT INTO benirv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","তবে যাজক সেই কলঙ্কবিশিষ্ট জিনিস ধুতে আদেশ দেবে এবং আর সাত দিন তা আবদ্ধ করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ধোয়া হলে পর যাজক সে কলঙ্ক দেখবে; আর দেখ, সেই কলঙ্ক যদি অন্য রঙের না হয়ে থাকে ও সে কলঙ্ক যদি বেড়ে না থাকে, তবে তা অশুচি, তুমি তা আগুনে পুড়িয়ে দেবে; ওটা ভিতরে কিংবা বাইরে উৎপন্ন ক্ষত। ");
INSERT INTO benirv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","কিন্তু যদি যাজক দেখে, আর দেখ, ধোয়ার পরে যাজকের দৃষ্টিতে যদি সেই কলঙ্ক মলিন হয়, তবে সে ঐ পোশাক থেকে কিংবা চামড়া থেকে কিংবা বোনা বা সংযুক্ত করা থেকে তা ছিঁড়ে ফেলবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","তাছাড়া যদি সেই পোশাকে কিংবা বোনা বা সংযুক্ত করাতে কিংবা চামড়ার তৈরী কোনো জিনিসে তা আবার দেখা যায়, তবে তা ব্যাপক কুষ্ঠ; যাতে সেই কলঙ্ক থাকে, তা তুমি আগুনে পুড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","আর যে পোশাক কিংবা পোশাকের বোনা বা সংযুক্ত করা কিংবা চামড়ার যে কোনো জিনিসে ধোবে, তা থেকে যদি সেই কলঙ্ক দূর হয়, তবে দ্বিতীয় বার ধোবে; তাতে তা শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","লোমের কিংবা মসীনাকৃত পোশাকের কিংবা বোনা বা সংযুক্ত করার কিংবা চামড়ার তৈরী কোনো পাত্রের শুচি বা অশুচির বিষয়ে কুষ্ঠ জন্য কলঙ্কের এই ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“কুষ্ঠরোগীর শুচি হবার দিনের তার পক্ষে এই ব্যবস্থা হবে, তাকে যাজকের কাছে নিয়ে আসা হবে ");
INSERT INTO benirv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","যাজক শিবিরের বাইরে গিয়ে দেখবে; আরে দেখ, যদি কুষ্ঠীর কুষ্ঠরোগের ঘায়ের উপশম হয়ে থাকে, ");
INSERT INTO benirv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","তবে যাজক সেই শুচি ব্যক্তির জন্যে দুটি জীবন্ত শুচি পাখি, এরস কাঠ, লাল রঙের লোম ও এসোব, এই সব নিতে আজ্ঞা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","আর যাজক মাটির পাত্রে বিশুদ্ধ জলের ওপরে একটি পাখি হত্যা করতে আজ্ঞা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","পরে সে ঐ জীবিত পাখি, এরস কাঠ, লাল রঙের লোম ও এসোব নিয়ে ঐ বিশুদ্ধ জলের ওপরে নিহত পাখির রক্তে জীবিত পাখির সঙ্গে সে সব ডুবাবে ");
INSERT INTO benirv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","এবং কুষ্ঠ থেকে শুচি ব্যক্তির ওপরে সাত বার ছিটিয়ে তাকে শুচি বলবে এবং ঐ জীবিত পাখিকে মাঠের দিকে ছেড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","তখন সেই শুচি ব্যক্তি নিজের পোশাক ধুয়ে ও সমস্ত চুল ন্যাড়া করে জলে স্নান করবে, তাতে সে শুচি হবে; তারপরে সে শিবিরে প্রবেশ করতে পারবে, কিন্তু সাত দিন নিজের তাঁবুর বাইরে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","পরে সপ্তম দিনের সে নিজের মাথার চুল, দাড়ি, ভ্রূ ও সর্বাঙ্গের লোম ন্যাড়া করবে এবং নিজের পোশাক ধুয়ে নিজে জলে স্নান করে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","পরে অষ্টম দিনের সে নির্দোষ দুটি মেষশাবক, এক বছরের নির্দোষ একটি মেষবত্সা ও ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো এক ঐফা সূজির দশ অংশের তিন অংশ ও এক লোগ তেল নেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","পরে শুচীকারী যাজক ঐ শুচি লোকটিকে এবং ঐ সব জিনিস নিয়ে সমাগম তাঁবুর দরজার সামনে সদাপ্রভুর সামনে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","পরে যাজক একটি মেষশাবক নিয়ে অপরাধের বলিরূপে উৎসর্গ করবে এবং তা ও সেই এক লোগ তেল দোলনীয় নৈবেদ্যরূপে সদাপ্রভুর সামনে দোলাবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","যে জায়গায় পাপের বলি ও হোমবলি হত্যা করা যায়, সেই পবিত্র জায়গায় ঐ মেষশাবকটিকে হত্যা করবে, কারণ অপরাধের বলি পাপের বলির মতো যাজকের অংশ; তা অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","আর যাজক ঐ অপরাধের বলি নিয়ে বলির কিছুটা রক্ত নিয়ে ঐ শুচি ব্যক্তির ডান কানের শেষে, ডান হাতের বুড়ো আঙ্গুলে ও ডান পায়ের বুড়ো আঙ্গুলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","আর যাজক সেই এক লোগ তেলের কিছুটা নিজের বাম হাতের তালুতে ঢালবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","পরে যাজক সেই বাম হাতে অবস্থিত তেলে নিজের ডান হাতের আঙ্গুল ডুবিয়ে আঙ্গুলের দ্বারা সেই তেল থেকে কিছু কিছু করে সাত বার সদাপ্রভুর সামনে ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","আর নিজের হাতে অবস্থিত বাকি তেলের কিছুটা নিয়ে যাজক শুচি ব্যক্তির ডান কানের শেষে, ডান হাতের বুড়ো আঙ্গুলে ও ডান পায়ে বুড়ো আঙ্গুলে ঐ অপরাধের বলির রক্তের ওপরে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","পরে যাজক নিজের হাতে অবস্থিত বাকি তেল নিয়ে ঐ শুচি ব্যক্তির মাথায় দেবে এবং যাজক সদাপ্রভুর সামনে তার জন্যে প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","আর যাজক পাপের বলিদান করবে এবং সেই শুচি ব্যক্তির অশৌচের জন্য প্রায়শ্চিত্ত করবে, তারপরে হোমবলি হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","আর যাজক হোমবলি ও ভক্ষ্য নৈবেদ্য বেদিতে উৎসর্গ করবে এবং যাজক তার জন্য প্রায়শ্চিত্ত করবে; তাতে সে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","আর সে ব্যক্তি যদি গরিব হয়, এত আনতে তার সামর্থ্য না থাকে, তবে সে নিজের জন্য প্রায়শ্চিত্ত করার জন্যে দোলনীয় অপরাধের বলির জন্যে একটি মেষশাবক ও ভক্ষ্য নৈবেদ্য, তেল মেশানো এক ঐফা সূজির দশ অংশের এক অংশ ও এক লোগ তেল ");
INSERT INTO benirv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","এবং নিজের সামর্থ্য অনুসারে দুটি ঘুঘু কিংবা দুটি পায়রার শাবক আনবে; তার একটি পাপের বলি, অন্যটি হোমবলি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","পরে অষ্টম দিনের সে নিজের শুচি করার জন্যে সমাগম তাঁবুর দরজার সামনে সদাপ্রভুর সামনে যাজকের কাছে তাদেরকে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","পরে যাজক অপরাধের বলির মেষশাবক ও উক্ত এক লোগ তেল নিয়ে সদাপ্রভুর সামনে দোলনীয় নৈবেদ্যের জন্যে তা দোলাবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","পরে সে অপরাধের বলির মেষশাবক হত্যা করবে এবং যাজক অপরাধের বলির কিছু রক্ত নিয়ে শুচি ব্যক্তির ডান কানের শেষে ও তার ডান হাতের বুড়ো আঙ্গুলে ও ডান পায়ের বুড়ো আঙ্গুলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","পরে যাজক সেই তেল থেকে কিছুটা নিয়ে নিজের বাম হাতের তালুতে ঢালবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","আর যাজক ডান হাতের আঙ্গুল দিয়ে বাম হাতে অবস্থিত তেল থেকে কিছু কিছু করে সাত বার সদাপ্রভুর সামনে ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","আর যাজক নিজের হাতে অবস্থিত তেল থেকে কিছুটা নিয়ে শুচি ব্যক্তির ডান কানের শেষে, ডান হাতের বুড়ো আঙ্গুলে ও ডান পায়ের বুড়ো আঙ্গুলে অপরাধের বলির রক্তের জায়গার ওপরে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","আর যাজক ব্যক্তির জন্যে সদাপ্রভুর সামনে প্রায়শ্চিত্ত করার জন্য নিজের হাতে অবস্থিত বাকি তেল তার মাথায় দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","পরে সে সামর্থ্য অনুসারে দেওয়া দুটি ঘুঘুর কিংবা পায়রাশাবকের মধ্যে একটি উৎসর্গ করবে; ");
INSERT INTO benirv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","অর্থাৎ সামর্থ্য অনুসারে ভক্ষ্য নৈবেদ্যের সঙ্গে একটি পাপের বলি, অন্যটি হোমবলি রূপে উৎসর্গ করবে এবং যাজক শুচি ব্যক্তির জন্যে সদাপ্রভুর সামনে প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","কুষ্ঠরোগের ঘা বিশিষ্ট যে ব্যক্তি নিজের শুদ্ধতার বিষয়ে সামর্থ্যহীন, তার জন্য এই ব্যবস্থা।” ");
INSERT INTO benirv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","পরে সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“আমি যে দেশ অধিকারের জন্যে তোমাদেরকে দেব, সেই কনান দেশে তোমাদের প্রবেশের পর যদি আমি তোমাদের অধিকার করা দেশের কোনো গৃহে কুষ্ঠরোগের কলঙ্ক বিস্তার করি, ");
INSERT INTO benirv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","তবে সে গৃহের স্বামী এসে যাজককে এই সংবাদ দেবে, আমার দৃষ্টিতে গৃহে কলঙ্কের মত দেখা দিচ্ছে। ");
INSERT INTO benirv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","তারপরে গৃহের সব জিনিস যেন অশুচি না হয়, এই জন্যে ঐ কলঙ্ক দেখার জন্য যাজকের প্রবেশের পুর্বে গৃহ শূন্য করতে যাজক আজ্ঞা করবে; পরে যাজক দেখতে প্রবেশ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","আর সে সেই কলঙ্ক দেখবে; আর দেখ, যদি গৃহের ভিত্তিতে কলঙ্ক নিম্ন ও ঈষৎ হলুদ কিংবা লাল হয় এবং তার দৃষ্টি থেকে নিম্ন বোধ হয়, ");
INSERT INTO benirv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","তবে যাজক গৃহ থেকে বের হয়ে গৃহের দরজায় গিয়ে সাত দিন ঐ গৃহ আবদ্ধ করে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","সপ্তম দিনের যাজক আবার এসে দেখবে; আর দেখ, গৃহের দেওয়ালে সেই কলঙ্ক যদি বেড়ে থাকে, ");
INSERT INTO benirv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","তবে যাজক আজ্ঞা করবে, যেন কলঙ্কবিশিষ্ট পাথর সব তুলে দিয়ে লোকেরা শহরের বাইরে অশুচি জায়গায় ফেলে দেয়। ");
INSERT INTO benirv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","পরে সে গৃহের ভিতরের চারিদিক ঘর্ষণ করাবে ও তারা সেই ঘর্ষণের ধূলা শহরের বাইরে অশুচি জায়গায় ফেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","আর তারা অন্য পাথর নিয়ে সেই পাথরের জায়গায় বসাবে ও অন্য প্রলেপ দিয়ে গৃহ লেপন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","এই ভাবে পাথর তুলে ফেললে এবং গৃহ ঘর্ষণ ও লেপন করলে পর যদি আবার কলঙ্ক জন্মে গৃহে ছড়িয়ে যায়, তবে যাজক এসে দেখবে; ");
INSERT INTO benirv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","আর দেখ, যদি ঐ গৃহে কলঙ্ক বেড়ে থাকে, তবে সেই গৃহে ক্ষতিকারক কুষ্ঠ আছে, সেই গৃহ অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","লোকেরা ঐ গৃহ ভেঙে ফেলবে এবং গৃহের পাথর, কাঠ ও প্রলেপ সকল শহরের বাইরে অশুচি জায়গায় নিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","আর ঐ গৃহ যতক্ষণ আবদ্ধ থাকে, ততক্ষণ যে কেউ তার ভিতরে যায়, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","আর যে কেউ সেই গৃহে শোয়, সে নিজের পোশাক ধোবে এবং যে কেউ সেই গৃহে খায়, সেও নিজের পোশাক ধোবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","আর যদি যাজক প্রবেশ করে দেখে, আর দেখ, সেই গৃহ লেপনের পর আর বাড়েনি, তবে যাজক সেই গৃহকে শুচি বলবে; কারণ কলঙ্কের উপশম হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","পরে সে ঐ গৃহ শুচি করার জন্যে দুটি পাখি, এরসকাঠ, লাল রঙয়ের লোম ও এসোব নেবে ");
INSERT INTO benirv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","এবং মাটির পাত্রে বিশুদ্ধ জলের ওপরে একটি পাখি হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","পরে সে ঐ এরসকাঠ, এসোব, লাল রঙয়ের লোম ও জীবিত পাখি, এই সব নিয়ে নিহত পাখির রক্তে ও বিশুদ্ধ জলে ডুবিয়ে সাত বার গৃহে ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","এইরূপে পাখির রক্ত, বিশুদ্ধ জল, জীবিত পাখি, এরসকাঠ, এসোব ও লাল রঙয়ের লোম, এই সবের দ্বারা সেই গৃহ শুচি করবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","পরে ঐ জীবিত পাখিকে শহরের বাইরে মাঠের দিকে ছেড়ে দেবে এবং গৃহের জন্য প্রায়শ্চিত্ত করবে; তাতে তা শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","এই ব্যবস্থা সর্বপ্রকার কুষ্ঠরোগের, ");
INSERT INTO benirv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","শ্বিত্ররোগের, পোশাকে অবস্থিত কুষ্ঠের ও গৃহের ");
INSERT INTO benirv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","এবং শোথ, ফুসকুড়ি ও স্বেতির দাগের; ");
INSERT INTO benirv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","এই সব কোন দিনের অশুচি ও কোন্ দিনের শুচী, তা জানাবার জন্য; কুষ্ঠরোগের এই ব্যবস্থা।” ");
INSERT INTO benirv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","আর সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“তোমরা ইস্রায়েল সন্তানদের বল, তাদেরকে এই কথা বল, পুরুষের শরীরে সংক্রামক তরল বের হলে তাতে সে অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","তার সংক্রামক তরলের জন্য অশুচির বিধি এই; তার শরীর থেকে প্রমেহ বের হোক, কিংবা শরীরে বন্ধ হোক, এ তার অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","সেই লোক যে কোনো শয্যায় শয়ন করে, তা অশুচি ও যা কিছুর ওপরে বসে, তা অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","আর যে কেউ তার শয্যা স্পর্শ করে, সে নিজের পোশাক ধোবে, জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","আর যে কোনো বস্তুর ওপরে প্রমেহী বসে, তার ওপরে যদি কেউ বসে, তবে সে নিজের পোশাক ধোবে, জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","আর যে কেউ প্রমেহীর গা স্পর্শ করে, সে নিজের পোশাক ধোবে, জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","আর প্রমেহী যদি শুচি ব্যক্তির গায়ে থুথু ফেলে, তবে সে নিজের পোশাক ধোবে, জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","আর প্রমেহী যে কোনো বাহনের ওপরে আরোহণ করে, তা অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","আর কেউ তার নীচে অবস্থিত কোনো জিনিস স্পর্শ করে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে এবং যে কেউ তা তুলে, সে নিজের পোশাক ধোবে, জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","আর প্রমেহী নিজের হাত জলে না ধুয়ে যাকে স্পর্শ করে, সে নিজের পোশাক ধোবে, জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","আর প্রমেহী যে কোনো মাটির পাত্র স্পর্শ করে, তা ভেঙে ফেলতে হবে ও সব কাঠের পাত্র জলে ধোবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","আর প্রমেহী যখন নিজের প্রমেহ থেকে শুচি হয়, তখন সে নিজের শুচীত্বের জন্যে সাত দিন গুণবে এবং সে নিজের পোশাক ধোবে ও বিশুদ্ধ জলে স্নান করবে; পরে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","আর অষ্টম দিনের সে নিজের জন্যে দুটি ঘুঘু কিংবা দুটি পায়রারশাবক নিয়ে সমাগম তাঁবুর দরজায় সদাপ্রভুর সামনে এসে তাদেরকে যাজকের হাতে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","যাজক তার একটি পাপের বলি, অন্যটি হোমবলিরূপে উৎসর্গ করবে, এইরূপে যাজক তার প্রমেহ হেতু তার জন্য সদাপ্রভুর সামনে প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","আর যদি কোনো পুরুষের রেতঃপাত হয়, তবে সে নিজের সমস্ত শরীর জলে ধোবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","আর যে কোনো পোশাকে কি চামড়ায় রেতঃপাত হয়, তা জলে ধুতে হবে এবং তা সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","আর স্ত্রীর সঙ্গে পুরুষ রেতঃশুদ্ধ শয়ন করলে তারা উভয়ে জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","আর যে স্ত্রীর ঋতুস্রাব হয়, তার শরীরে রক্ত বের হলে সাত দিন তার অশুচি থাকবে এবং যে কেউ তাকে স্পর্শ করে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","আর অশুচির দিনের সে যে কোনো শয্যায় শয়ন করবে, তা অশুচি হবে ও যার ওপরে বসবে, তা অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","আর যে কেউ তার শয্যা স্পর্শ করবে, সে নিজের পোশাক ধোবে ও জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","আর যে কেউ তার বসার কোনো আসন স্পর্শ করে, সে নিজের পোশাক ধোবে ও জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","আর তার শয্যা কিংবা আসনের ওপরে কোনো কিছু থাকলে যে কেউ তা স্পর্শ করে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","আর অশুচির দিনের যে পুরুষ তার সঙ্গে শয়ন করে ও তার রজঃ তার গায়ে লাগে, সে সাত দিন অশুচি থাকবে এবং যে কোনো শয্যায় সে শয়ন করবে, সেটাও অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","আর অশুচির দিনের ছাড়া যদি কোনো স্ত্রীলোকের বহুদিন পর্যন্ত রক্তস্রাব হয়, কিংবা অশুচির দিনের পর যদি রক্ত ক্ষরে, তবে সেই অশুচি রক্তস্রাবের সকল দিন সে অশুচির দিনের র মতো থাকবে, সে অশুচি। ");
INSERT INTO benirv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","সেই রক্তস্রাবের সমস্ত দিন যে কোনো শয্যায় সে শয়ন করবে, তা তার পক্ষে অশুচির দিনের শয্যার মতো হবে এবং যে কোনো আসনের ওপরে বসবে, তা অশুচির দিনের মত অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","আর যে কেউ সেই সব স্পর্শ করবে, সে অশুচি হবে, পোশাক ধুয়ে জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","আর সেই স্ত্রীর রক্তস্রাব রহিত হলে সে নিজের জন্যে সাত দিন গুণবে, তারপরে সে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","পরে অষ্টম দিনের সে নিজের জন্য দুটি ঘুঘু কিংবা দুটি পায়রারশাবক নিয়ে সমাগম তাঁবুর দরজায় যাজকের কাছে আসবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","যাজক তার একটি পাপের বলি ও অন্যটি হোমবলিরূপে উৎসর্গ করবে, তার রক্তস্রাবের অশুচির জন্য যাজক সদাপ্রভুর সামনে তার জন্য প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","এই প্রকারে তোমরা ইস্রায়েল সন্তানদের তাদের অশুচি থেকে আলাদা করবে, পাছে তাদের মধ্যবর্ত্তী আমার আবাস অশুচি করলে তারা নিজেদের অশুচির জন্য মারা পড়ে। ");
INSERT INTO benirv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","প্রমেহী ও রেতঃপাতে অশুচি ব্যক্তি এবং অশৌচার্ত্তা স্ত্রী, ");
INSERT INTO benirv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","প্রমেহবিশিষ্ট পুরুষ ও স্ত্রী এবং অশুচি স্ত্রীর সঙ্গে সংসর্গকারী পুরুষ, এই সবের জন্য এই ব্যবস্থা।” ");
INSERT INTO benirv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","হারোণের দুই ছেলে সদাপ্রভুর কাছে উপস্থিত হয়ে মারা গেলে পর, সদাপ্রভু মোশির সঙ্গে আলাপ করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","সদাপ্রভু মোশিকে এই কথা বললেন, “তুমি নিজের ভাই হারোণকে বল, যেন সে অতি পবিত্র জায়গায় পর্দার ভিতরে, সিন্দুকের ওপরে অবস্থিত পাপাবরণের সামনে সব দিনের প্রবেশ না করে, পাছে তার মৃত্যু হয়; কারণ আমি পাপাবরণের ওপরে মেঘে দেখা দেব। ");
INSERT INTO benirv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","হারোণ পাপের জন্যে একটি গোবত্স ও হোমের জন্যে একটি মেষ সঙ্গে নিয়ে, এইরূপে অতি পবিত্র জায়গায় প্রবেশ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","সে মসীনার পবিত্র অঙ্গরক্ষিণী পরবে, মসীনার অন্তর্বাস পরবে, মসীনার কোমরবন্ধন এবং মসীনার উষ্ণীষে বিভূষিত হবে; এ সব পবিত্র বস্ত্র; সে জলে নিজের শরীর ধুয়ে এই সব পরবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","পরে সে ইস্রায়েল সন্তানদের মণ্ডলীর কাছে পাপের বলিরূপে দুটি ছাগল ও হোমের একটি মেষ নেবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","আর হারোণ নিজের জন্য পাপের বলির ষাঁড় এনে নিজের ও নিজ বংশের জন্য প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","পরে সেই দুটি ছাগল নিয়ে সমাগম তাঁবুর দরজার সামনে সদাপ্রভুর সামনে উপস্থিত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","পরে হারোণ ঐ দুটি ছাগলের বিষয়ে গুলিবাট করবে; এক গুলি সদাপ্রভুর জন্যে ও অন্য গুলি ত্যাগের জন্যে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","গুলিবাট দ্বারা যে ছাগল সদাপ্রভুর জন্যে হয়, হারোণ তাকে নিয়ে পাপের বলিদান করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","কিন্তু গুলিবাট দ্বারা যে ছাগল ত্যাগের জন্যে হয়, সে যেন ত্যাগের জন্যে মরুপ্রান্তে, তার জন্য তার জন্য প্রায়শ্চিত্ত করার জন্য সদাপ্রভুর সামনে তাকে জীবিত উপস্থিত করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","পরে হারোণ নিজের পাপের বলির ষাঁড় এনে নিজের ও নিজ বংশের জন্যে প্রায়শ্চিত্ত করবে, ফলে সে নিজের পাপের বলি সেই ষাঁড়কে হত্যা করবে; ");
INSERT INTO benirv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","আর সদাপ্রভুর সামনে থেকে, বেদির ওপর থেকে, প্রজ্বলিত অঙ্গারে পূর্ণ ধুনুচি ও এক মুঠো চূর্ণীকৃত সুগন্ধি ধূপ নিয়ে পর্দার ভিতরে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","আর ঐ ধূপ সদাপ্রভুর সামনে আগুনে দেবে; তাতে সাক্ষ্য সিন্দুকের ওপরে অবস্থিত পাপাবরণ ধূপের ধোঁয়ার মেঘে আচ্ছন্ন হলে সে মরবে না। ");
INSERT INTO benirv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","পরে সে ঐ গোবৎসের কিছু রক্ত নিয়ে পাপাবরণের পূর্বপার্শ্বে আঙ্গুলের দ্বারা ছিটিয়ে দেবে এবং আঙ্গুলের মাধ্যমে পাপাবরণের সামনে ঐ রক্ত সাত বার ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","পরে সে লোকদের পাপের বলির ছাগলটি হত্যা করে তার রক্ত পর্দার ভিতরে এনে যেমন গোবৎসের রক্ত ছিটিয়ে দিয়েছিল, সেইরূপ তারও রক্ত নিয়ে করবে, পাপাবরণের ওপরে ও পাপাবরণের সামনে ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","আর ইস্রায়েল সন্তানদের নানা ধরনের অশুচিতা ও অধর্ম্ম, অর্থাৎ সবধরনের পাপের জন্য সে পবিত্র জায়গার জন্য প্রায়শ্চিত্ত করবে এবং যে সমাগম তাঁবু তাদের সঙ্গে, তাদের নানা ধরনের অশুচির মধ্যে বাস করে, তার জন্যে সে সেরকম করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","আর প্রায়শ্চিত্ত করার জন্য পবিত্র জায়গায় প্রবেশ করা থেকে যে পর্যন্ত সে বের না হয় এবং নিজের ও নিজ বংশের এবং সমস্ত ইস্রায়েল সমাজের জন্যে প্রায়শ্চিত্ত শেষ না করে, সেই পর্যন্ত সমাগম তাঁবুতে কোনো মানুষ থাকবে না। ");
INSERT INTO benirv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","সে বের হয়ে সদাপ্রভুর সামনে বেদির কাছে গিয়ে তার জন্য প্রায়শ্চিত্ত করবে এবং সেই ষাঁড়ের কিছু রক্ত ও ছাগলের কিছু রক্ত নিয়ে বেদির চারিদিকে শিংয়ের ওপরে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","আর সে রক্তের কিছু নিয়ে নিজের আঙ্গুল দ্বারা তার ওপরে সাত বার ছিটিয়ে দিয়ে তা শুচি করবে ও ইস্রায়েল সন্তানদের অশুচি থেকে তা পবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","এই ভাবে সে পবিত্র জায়গার, সমাগম তাঁবুর ও বেদির জন্য প্রায়শ্চিত্ত কাজ শেষ করলে পর সেই জীবিত ছাগলটি আনবে; ");
INSERT INTO benirv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","পরে হারোণ সেই জীবিত ছাগলের মাথায় নিজের দুই হাত বাড়িয়ে দেবে এবং ইস্রায়েল সন্তানদের সমস্ত অপরাধ ও তাদের সমস্ত অধর্ম্ম অর্থাৎ তাদের সবধরনের পাপ তার ওপরে স্বীকার করে সে সমস্ত ঐ ছাগলের মাথায় দেবে; পরে যে প্রস্তুত হয়েছে, এমন লোকের হাত দ্বারা তাকে মরুপ্রান্তে পাঠিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","আর ঐ ছাগল নিজের ওপরে তাদের সমস্ত অপরাধ বিচ্ছিন্ন ভূমিতে বয়ে নিয়ে যাবে; আর সেই ব্যক্তি ছাগলটিকে মরুপ্রান্তে ছেড়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","আর হারোণ সমাগম তাঁবুতে প্রবেশ করবে এবং পবিত্র জায়গায় প্রবেশ করার দিনের যে সব মসীনা পোশাক পরেছিল, তা ত্যাগ করে সেই জায়গায় রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","পরে সে কোনো পবিত্র জায়গায় নিজের শরীর জলে ধুয়ে নিজের পোশাক পরে বাইরে আসবে এবং নিজের হোমবলি ও লোকদের হোমবলি উৎসর্গ করে নিজের জন্যে ও লোকদের জন্যে প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","আর সে পাপের বলির মেদ বেদিতে পোড়াবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","আর যে ব্যক্তি ত্যাগের ছাগলটি ছেড়ে দিয়েছিল, সে নিজের পোশাক ধোবে ও নিজের গা জলে ধোবে, তারপরে শিবিরে আসবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","আর পাপের বলির গোবৎস ও পাপের বলির ছাগল, যাদের রক্ত প্রায়শ্চিত্ত করার জন্যে পবিত্র জায়গায় আনা হয়েছিল, লোকেরা তাদেরকে শিবিরের বাইরে নিয়ে গিয়ে তাদের চামড়া, মাংস ও মল আগুনে পুড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","আর যে লোক তা পুড়িয়ে দেবে, সে নিজের পোশাক ধোবে ও নিজের গা জলে ধোবে, তারপরে শিবিরে আসবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","তোমাদের জন্যে এটা চিরস্থায়ী বিধি হবে; সপ্তম মাসের দশম দিনের স্বদেশী কিংবা তোমাদের মধ্যে প্রবাসকারী বিদেশী, তোমরা নিজেদের প্রাণকে দুঃখ দেবে ও কোনো ব্যবসায় কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","কারণ সেই দিন তোমাদেরকে শুচি করার জন্যে তোমাদের জন্য প্রায়শ্চিত্ত করা যাবে; তোমরা সদাপ্রভুর সামনে নিজেদের সব পাপ থেকে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","তা তোমাদের বিশ্রামের জন্যে বিশ্রামদিন এবং তোমরা নিজেদের প্রাণকে দুঃখ দেবে; এটা চিরস্থায়ী বিধি। ");
INSERT INTO benirv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","বাবার জায়গায় যাজকের কাজ করতে যাকে অভিষেক ও উত্সর্গের দ্বারা নিযুক্ত করা যাবে, সেই যাজক প্রায়শ্চিত্ত করবে এবং মসীনা পোশাক অর্থাৎ পবিত্র পোশাক সব পরবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","আর সে পবিত্র ধর্ম্মধামের জন্য প্রায়শ্চিত্ত করবে এবং সমাগম তাঁবুর ও বেদির জন্য প্রায়শ্চিত্ত করবে এবং যাজকদের ও সমাজের সমস্ত লোকের জন্য প্রায়শ্চিত্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ইস্রায়েল সন্তানদের জন্য তাদের সমস্ত পাপের জন্য বছরের মধ্যে এক বার প্রায়শ্চিত্ত করা তোমাদের জন্যে চিরস্থায়ী বিধি হবে।” তখন হারোণ মোশির প্রতি সদাপ্রভুর আদেশ অনুসারে কাজ করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“তুমি হারোণ ও তার ছেলেদেরকে এবং সমস্ত ইস্রায়েল সন্তানকে বল, তাদেরকে এই কথা বল, সদাপ্রভু এই আজ্ঞা করেন; ");
INSERT INTO benirv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ইস্রায়েল বংশের যে কেউ শিবিরের মধ্যে কিংবা শিবিরের বাইরে গরু কিংবা মেষ কিংবা ছাগল হত্যা করে, ");
INSERT INTO benirv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","কিন্তু সদাপ্রভুর আবাসের সামনে সদাপ্রভুর উদ্দেশ্যে উপহার উৎসর্গ করতে সমাগম তাঁবুর দরজার সামনে তা না আনে, তার ওপর রক্তপাতের পাপ গণ্য হবে; সে রক্তপাত করেছে, সে ব্যক্তি নিজের লোকদের মধ্য থেকে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","কারণ ইস্রায়েল সন্তানরা নিজেদের যে যে যজ্ঞের পশু মাঠে নিয়ে গিয়ে বলিদান করে, সে সমস্ত সদাপ্রভুর উদ্দেশ্যে সমাগম তাঁবুর দরজায় যাজকের কাছে এনে সদাপ্রভুর উদ্দেশ্যে মঙ্গলের বলি বলে বলিদান করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","আর যাজক সমাগম তাঁবুর দরজার সামনে সদাপ্রভুর বেদির ওপরে তাদের রক্ত ছিটাবে এবং মেদ সদাপ্রভুর উদ্দেশ্যে সুগন্ধের জন্য পোড়াবে। ");
INSERT INTO benirv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","তাতে তারা যে ছাগলদের অনুগমনে ব্যভিচার আসছে, তাদের উদ্দেশ্যে আর বলিদান করবে না। এটা তাদের পুরুষানুক্রমে পালনীয় চিরস্থায়ী বিধি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","আর তুমি তাদেরকে বল, ইস্রায়েল বংশের কোনো ব্যক্তি কিংবা তাদের মধ্যে প্রবাসকারী কোনো বিদেশী লোক যদি হোম কিংবা বলিদান করে, ");
INSERT INTO benirv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","কিন্তু সদাপ্রভুর উদ্দেশ্যে উৎসর্গ করার জন্য তা সমাগম তাঁবুর দরজার সামনে না আনে, তবে সে নিজের লোকদের মধ্য থেকে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","আর ইস্রায়েল বংশের কোনো ব্যক্তি, কিংবা তাদের মধ্যে প্রবাসকারী কোনো বিদেশী লোক যদি কোনো প্রকার রক্ত খায়, তবে আমি সেই লোকের প্রতি বিমুখ হব ও তার লোকদের মধ্য থেকে তাকে উচ্ছেদ করব। ");
INSERT INTO benirv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","কারণ রক্তের মধ্যেই শরীরের প্রাণ থাকে এবং তোমাদের প্রাণের জন্য প্রায়শ্চিত্ত করার জন্য আমি তা বেদির ওপরে তোমাদেরকে দিয়েছি; কারণ প্রাণের গুণে রক্তই প্রায়শ্চিত্ত-সাধক। ");
INSERT INTO benirv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","এই জন্য আমি ইস্রায়েল সন্তানদের বললাম, তোমাদের মধ্যে কেউ রক্ত খাবে না ও তোমাদের মধ্যে প্রবাসকারী কোনো বিদেশীও রক্ত খাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","আর ইস্রায়েল সন্তানদের মধ্যে কোনো ব্যক্তি কিংবা তাদের মধ্যে প্রবাসকারী কোনো বিদেশী লোক যদি শিকারে কোনো খাদ্য পশু কিংবা পাখি হত্যা করে, তবে সে তার রক্ত ঢেলে দিয়ে ধূলাতে আচ্ছাদন করবে।” ");
INSERT INTO benirv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","কারণ প্রত্যেক প্রাণীর রক্তই প্রাণ, তাই তার প্রাণ স্বরূপ; এই জন্য আমি ইস্রায়েল সন্তানদের বললাম, “তোমরা কোনো প্রাণীর রক্ত খাবে না, কারণ প্রত্যেক প্রাণীর রক্তই তার প্রাণ; যে কেউ তা খাবে, সে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","আর স্বদেশী কি বিদেশির মধ্যে যে কেউ নিজে থেকে মারা যাওয়া কিংবা ছিন্ন ভিন্ন পশু খায়, সে নিজের পোশাক ধোবে, জলে স্নান করবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে; পরে শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","কিন্তু যদি পোশাক না ধোয় ও স্নান না করে, তবে সে নিজের অপরাধ বহন করবে।” ");
INSERT INTO benirv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“তুমি ইস্রায়েল সন্তানদের বল, তাদেরকে এই কথা বল, আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","তোমরা যেখানে বাস করেছ, সেই মিশর দেশের ব্যবহার অনুযায়ী আচরণ করো না এবং যে কনান দেশে আমি তোমাদেরকে নিয়ে যাচ্ছি, সেখানকারও ব্যবহার অনুযায়ী আচরণ করো না ও তাদের নিয়ম অনুসারে চল না। ");
INSERT INTO benirv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","তোমরা আমারই শাসন সকল পালন কর এবং সেই পথে চল; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","অতএব তোমরা আমার নিয়ম সব ও আমার শাসন সব পালন করবে; যে কেউ এই সব পালন না করে, সে এই সবের দ্বারা বাঁচবে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","তোমরা কেউ আত্মীয় কোনো ব্যক্তির আবরণীয় অনাবৃত করার জন্য তার কাছে যেও না; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","তুমি নিজের বাবার আবরণীয় অর্থাৎ নিজের মায়ের আবরণীয় অনাবৃত কর না; সে তোমার মা; তার আবরণীয় অনাবৃত কর না। ");
INSERT INTO benirv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","তোমার বাবার স্ত্রীর আবরণীয় অনাবৃত কর না, তা তোমার বাবার আবরণীয়। ");
INSERT INTO benirv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","তোমার বোন, তোমার বাবার মেয়ে কিংবা তোমার মায়ের মেয়ে, বাড়িতে জন্মানো হোক কিংবা অন্য জায়গায় জন্মানো হোক, তাদের আবরণীয় অনাবৃত কর না। ");
INSERT INTO benirv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","তোমাদের ছেলের মেয়ের কিংবা মেয়ের আবরণীয় অনাবৃত কর না; কারণ তা তোমারই আবরণীয়। ");
INSERT INTO benirv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","তোমার বাবার স্ত্রীর মেয়ের আবরণীয়, যে তোমার বাবা থেকে জন্মেছে, যে তোমার বোন, তার আবরণীয় অনাবৃত কর না। ");
INSERT INTO benirv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","তোমার বাবার বোনের আবরণীয় অনাবৃত কর না, সে তোমরা বাবার আত্মীয়া। ");
INSERT INTO benirv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","তোমার মায়ের বোনের আবরণীয় অনাবৃত কর না, সে তোমার মায়ের আত্মীয়া। ");
INSERT INTO benirv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","তোমার বাবার ভাইয়ের আবরণীয় অনাবৃত কর না, তার স্ত্রীর কাছে যেও না, সে তোমার কাকিমা। ");
INSERT INTO benirv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","তোমার পুত্রবধূর আবরণীয় অনাবৃত কর না, সে তোমার ছেলের স্ত্রী, তার আবরণীয় অনাবৃত কর না। ");
INSERT INTO benirv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","তোমরা ভাইয়ের স্ত্রীর আবরণীয় অনাবৃত কর না; তা তোমার ভাইয়ের আবরণীয়। ");
INSERT INTO benirv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","কোনো স্ত্রীর ও মেয়ের আবরণীয় অনাবৃত কর না এবং আবরণীয় অনাবৃত করার জন্য তার ছেলের মেয়েকে বা মেয়ের মেয়েকে নিও না; তারা একে অপরের আত্মীয়া; এ খারাপ কাজ। ");
INSERT INTO benirv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","আর স্ত্রীর সপত্নী হবার জন্য তার বেঁচে থাকার দিনের আবরণীয় অনাবৃত করার জন্যে তার বোনকে বিয়ে কর না ");
INSERT INTO benirv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","এবং কোনো স্ত্রীর অশুচির দিনের তার আবরণীয় অনাবৃত করতে তার কাছে যেও না। ");
INSERT INTO benirv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","আর তুমি নিজের প্রতিবেশীর স্ত্রীর কাছে গিয়ে নিজেকে অশুচি কর না। ");
INSERT INTO benirv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","আর তোমার বংশের কাউকেও মোলক দেবের উদ্দেশ্যে আগুনের মধ্যে দিয়ে নিয়ে যেও না এবং তোমার ঈশ্বরের নাম অপবিত্র কর না; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","স্ত্রীর মতো পুরুষের সঙ্গে সংসর্গ করও না, তা ঘৃণিত কাজ। ");
INSERT INTO benirv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","আর তুমি কোনো পশুর সঙ্গে শুয়ে নিজেকে অশুচি কর না এবং কোনো স্ত্রী কোনো পশুর সঙ্গে শুতে তার সামনে দাঁড়াবে না; এ বিপরীত কাজ। ");
INSERT INTO benirv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","তোমরা এ সবের দ্বারা নিজেদেরকে অশুচি কর না; কারণ যে যে জাতিকে আমি তোমাদের সামনে থেকে দূর করব, তারা এই সবের দ্বারা অশুচি হয়েছে এবং দেশও অশুচি হয়েছে; ");
INSERT INTO benirv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","অতএব আমি ওর অপরাধ ওকে ভোগ করাব এবং দেশ নিজের নিবাসীদেরকে উদগীরণ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","অতএব তোমরা আমার বিধি ও আমার শাসন সব পালন কর; নিজের দেশের কিংবা তোমাদের মধ্যে প্রবেশকারী বিদেশীয় হোক, তোমরা ঐ সব ঘৃণিত কাজের মধ্যে কোনো কাজ কর না। ");
INSERT INTO benirv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","কারণ তোমাদের আগে যারা ছিল, ঐ দেশের সেই লোকেরা এরকম ঘৃণিত কাজ করাতে দেশ অশুচি হয়েছে ");
INSERT INTO benirv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","সেই দেশ যেমন তোমাদের আগে ঐ জাতিকে উদগীরণ করল, সেরকম যেন তোমাদের দ্বারা অশুচি হয়ে তোমাদেরকেও উদগীরণ না করে। ");
INSERT INTO benirv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","কারণ যে কেউ ঐ সবের মধ্যে কোনো ঘৃণিত কাজ করে, সেই প্রাণী নিজের লোকদের মধ্য থেকে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","অতএব তোমরা আমার আদেশ পালন কর; তোমাদের আগে যে সব ঘৃণিত কাজ প্রচলিত ছিল, তার কিছুই তোমরা কর না এবং তার মাধ্যমে নিজেদেরকে অশুচি কর না; আমি সদাপ্রভু তোমাদের ঈশ্বর।” ");
INSERT INTO benirv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“তুমি ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে বল, তাদেরকে বল, ‘তোমরা পবিত্র হও, কারণ আমি সদাপ্রভু তোমাদের ঈশ্বর পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","তোমরা প্রত্যেকে নিজেদের মাকে ও নিজেদের বাবাকে ভয় কর এবং আমার বিশ্রামদিন সব পালন কর; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","তোমরা অযোগ্য প্রতিমাদের দিকে ফের না ও নিজেদের জন্যে ছাঁচে ঢালা দেবতা তৈরী কর না; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","আর যখন তোমরা সদাপ্রভুর উদ্দেশ্যে মঙ্গলের বলিদান কর, তখন গ্রাহ্য হবার জন্যে বলিদান কর। ");
INSERT INTO benirv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","তোমাদের বলিদানের দিনের ও তার পর দিনের তা খেতে হবে; তৃতীয় দিন পর্যন্ত যা বাকি থাকে, তা আগুনে পোড়াতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","তৃতীয় দিনের যদি কেউ তার কিছুটা খায়, তবে তা ঘৃণিত; তা অগ্রাহ্য হবে ");
INSERT INTO benirv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","এবং যে তা খায়, তাকে নিজের অপরাধ বহন করতে হবে; কারণ সে সদাপ্রভুর পবিত্র বস্তু অপবিত্র করেছে; সেই প্রাণী নিজের লোকদের মধ্য থেকে উচ্ছেদ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","আর তোমরা যখন নিজেদের ভূমির শস্য কাট, তখন তুমি ক্ষেত্রের কোণে অবস্থিত শস্য সম্পূর্ণ কেটো না এবং তোমার ক্ষেতে পড়ে থাকা শস্য কুড়িও না। ");
INSERT INTO benirv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","আর তুমি নিজের আঙ্গুরক্ষেতের পড়ে থাকা আঙ্গুরফল জড়ো কর না এবং আঙ্গুরক্ষেতে পড়ে থাকা আঙ্গুরফল কুড়িও না, তুমি দুঃখী ও বিদেশীদের জন্য তা ত্যাগ কর; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","তোমরা চুরি কর না এবং একে অপরকে বঞ্চনা কর না ও মিথ্যা কথা বল না। ");
INSERT INTO benirv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","আর আমার নাম নিয়ে মিথ্যা শপথ কর না, করলে তোমার ঈশ্বরের নাম অপবিত্র করা হয়; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","তুমি নিজের প্রতিবেশীর ওপর অত্যাচার কর না এবং তার জিনিস অপহরণ কর না। বেতনজীবীর বেতন সকাল পর্যন্ত সমস্ত রাত্রি রেখো না। ");
INSERT INTO benirv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","তুমি বধিরকে শাপ দিও না ও অন্ধের সামনে বাধাজনক জিনিস রেখো না, কিন্তু তোমার ঈশ্বরকে ভয় কর; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","তোমার বিচারে অন্যায় কর না। তুমি গরিবের পক্ষপাত কর না ও ধনবানের সম্মান কর না; তুমি ধার্ম্মিকতায় প্রতিবেশীর বিচার নিষ্পন্ন কর। ");
INSERT INTO benirv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","তুমি মিথ্যা পরচর্চা নিজের লোকদের মধ্যে চারিদিকে ভ্রমণ কর না এবং তোমার প্রতিবেশীর রক্তপাতের জন্য উঠে দাঁড়িও না; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","তুমি হৃদয়ের মধ্যে নিজের ভাইকে ঘৃণা কর না; তুমি অবশ্য নিজের প্রতিবেশীকে অনুযোগ করবে, তাতে তার জন্য পাপ বহন করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","তুমি নিজের জাতির সন্তানদের ওপরে প্রতিহিংসা কি ঘৃণা কর না, বরং নিজের প্রতিবেশীকে নিজের মত ভালবাসবে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","তোমরা আমার নিয়ম সব পালন কর। তুমি ভিন্ন ভিন্ন প্রকার পশুর সঙ্গে নিজের পশুদেরকে সংসর্গ করতে দিও না; তোমার এক ক্ষেতে দুই প্রকার বীজ বুন না এবং দুই প্রকার সুতোয় মেশানো পোশাক গায়ে দিও না। ");
INSERT INTO benirv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","আর মূল্য দ্বারা কিংবা অন্যভাবে মুক্ত হয়নি, এমন যে বাগদত্তা দাসী, তার সঙ্গে যদি কেউ সংসর্গ করে, তবে তারা দণ্ডনীয় হবে; তাদের প্রাণদণ্ড হবে না, কারণ সে মুক্ত নয়। ");
INSERT INTO benirv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","আর সেই পুরুষ সমাগম তাঁবুর দরজায় সদাপ্রভুর উদ্দেশ্যে নিজের দোষের বলি অর্থাৎ দোষার্থক বলির জন্য মেষ আনবে; ");
INSERT INTO benirv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","আর যাজক সদাপ্রভুর সামনে সেই দোষের বলির মেষের দ্বারা তার করা পাপের প্রায়শ্চিত্ত করবে; তাতে পাপের ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","আর তোমরা দেশে প্রবেশ করলে যখন ফল খাওয়ার জন্য সব প্রকার বৃক্ষ রোপণ করবে, তখন তার ফল নিষিদ্ধ বলে গণ্য করবে, তিন বছর দিন তা তোমাদের জন্যে নিষিদ্ধ থাকবে, তা খেও না। ");
INSERT INTO benirv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","পরে চতুর্থ বছরে তার সমস্ত ফল সদাপ্রভুর ধন্যবাদের উপহাররূপে পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","আর পঞ্চম বছরে তোমরা তার ফল খাবে; তাতে তোমাদের জন্যে প্রচুর ফল উৎপন্ন হবে; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","তোমরা রক্তের সঙ্গে কোনো জিনিস খেও না; অবিদ্যা কিম্বা গণকের বিদ্যা ব্যবহার কর না। ");
INSERT INTO benirv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","তোমরা নিজেদের মাথার শেষের চুল মন্ডলাকার কর না ও নিজেদের দাড়ির কোণ কেটো না। ");
INSERT INTO benirv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","মৃত লোকের জন্য নিজেদের অঙ্গে কেটো না ও শরীরে উলকি চিহ্ন দিও না; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","তুমি নিজের মেয়েকে বেশ্যা হতে দিয়ে অপবিত্র কর না, পাছে দেশ ব্যভিচারী হয়ে পড়ে ও দেশ খারাপ কাজে পূর্ণ হয়। ");
INSERT INTO benirv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","তোমরা অবশ্যই আমার বিশ্রামদিন পালন কোরো এবং আমার সমাগম তাঁবুর পবিত্র স্থান সম্মান কোরো; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","তোমরা ভূতড়িয়াদের ও গুণীদের অভিমুখ হয়ো না, তাদের কাছে খোঁজ কর না, করলে নিজেদেরকে অশুচি করবে; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","তুমি ধূসর রঙের চুলের প্রাচীনের সামনে উঠে দাঁড়াবে, বৃদ্ধ লোককে সম্মান করবে ও নিজের ঈশ্বরের প্রতি ভয় রাখবে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","আর কোনো বিদেশী লোক যদি তোমাদের দেশে তোমাদের সঙ্গে বাস করে, তোমরা তার প্রতি উপদ্রব কর না। ");
INSERT INTO benirv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","তোমাদের কাছে তোমাদের স্বদেশীয় লোক যেমন তোমাদের সঙ্গে বসবাসকারী বিদেশী লোকও তেমনি হবে; তুমি তাকে নিজের মত ভালবাসবে; কারণ মিশর দেশে তোমরাও বিদেশী ছিলে; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","তোমরা বিচার কিংবা পরিমাণ কিংবা বাটখারা কিংবা পরিমাপের বিষয়ে অন্যায় কর না। ");
INSERT INTO benirv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","তোমরা সঠিক দাঁড়ি, সঠিক বাটখারা, সঠিক ঐফা ও সঠিক হিন রাখবে; আমি সদাপ্রভু তোমাদের ঈশ্বর, যিনি মিশর দেশ থেকে তোমাদেরকে এনেছেন। ");
INSERT INTO benirv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","আর তোমরা আমার সমস্ত নিয়ম ও আমার সমস্ত শাসন মেনে চল, পালন কর; আমি সদাপ্রভু’।” ");
INSERT INTO benirv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","আর সদাপ্রভু মোশিকে বললেন, তুমি ইস্রায়েল-সন্তানদেরকে আরও বল, ");
INSERT INTO benirv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ইস্রায়েল-সন্তানদের, ‘কোনো ব্যক্তি কিংবা ইস্রায়েলের মধ্যে বসবাসকারী কোনো বিদেশী লোক যদি নিজের বংশের কাউকেও মোলক দেবের উদ্দেশ্যে উৎসর্গ করে, তবে তার প্রাণদণ্ড অবশ্য হবে, দেশের লোকেরা তাকে পাথরের আঘাতে হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","আর আমিও সেই ব্যক্তির প্রতি বিমুখ হয়ে তার লোকদের মধ্য থেকে তাকে আলাদা করব; কারণ মোলক দেবের উদ্দেশ্যে নিজের বংশজাতকে দেওয়াতে সে আমার ধর্ম্মধাম অশুচি করে ও আমার পবিত্র নাম অপবিত্র করে। ");
INSERT INTO benirv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","আর যে দিনের সেই ব্যক্তি নিজের বংশের কাউকে মোলক দেবের উদ্দেশ্যে উৎসর্গ করে, সেই দিনের যদি দেশীয় লোকেরা চোখ বুজে থাকে তাকে বধ না করে, ");
INSERT INTO benirv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","তবে আমি সেই ব্যক্তির ওপর ও তার গোষ্ঠীর ওপর বিমুখ হয়ে তাকে ও মোলক দেবের সঙ্গে ব্যভিচার করার জন্য তার অনুগামী ব্যভিচারী সকলকে তাদের লোকদের মধ্য থেকে আলাদা করব। ");
INSERT INTO benirv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","আর যে কোনো প্রাণী মৃতদের কিংবা গুণীদের অনুগমনে ব্যভিচার করবার জন্য তাদের দিকে ফেরে, আমি সেই প্রাণীর প্রতি বিমুখ হয়ে তার লোকদের মধ্য থেকে তাকে আলাদা করব। ");
INSERT INTO benirv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","তোমরা নিজেদেরকে পবিত্র কর, পবিত্র হও; কারণ আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","আর তোমরা আমার বিধি মান্য কোরো, পালন কোরো; আমি সদাপ্রভু তোমাদের পবিত্রকারী। ");
INSERT INTO benirv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","যে কেউ নিজের বাবাকে কিংবা মাকে শাপ দেয়, তার প্রাণদণ্ড অবশ্য হবে; বাবা মা কে শাপ দেওয়াতে তার রক্ত তারই ওপরে পড়বে। ");
INSERT INTO benirv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","আর যে কেউ পরের স্ত্রীর সঙ্গে ব্যভিচার করে, যে ব্যক্তি প্রতিবেশীর স্ত্রীর সঙ্গে ব্যভিচার করে, সেই ব্যভিচারী ও সেই ব্যভিচারিণী, উভয়ের প্রাণদণ্ড অবশ্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","আর যে কেউ নিজের বাবার স্ত্রীর সঙ্গে শয়ন করে, সে নিজের বাবার আবরণীয় খুলে দেয়; তাদের দুই জনেরই প্রাণদণ্ড অবশ্য হবে, তাদের রক্ত তাদের উপরে পড়বে ");
INSERT INTO benirv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","এবং যদি কেউ নিজের ছেলের স্ত্রীর সঙ্গে শয়ন করে, তবে তাদের দুই জনের প্রাণদণ্ড অবশ্য হবে; তারা বিপরীত কাজ করেছে; তাদের রক্ত তাদের উপরে পড়বে। ");
INSERT INTO benirv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","আর যেমন স্ত্রীর সঙ্গে, তেমনি পুরুষ যদি পুরুষের সঙ্গে শয়ন করে, তবে তারা দুই জনে ঘৃণার কাজ করে; তাদের প্রাণদণ্ড অবশ্য হবে; তাদের রক্ত তাদের উপরে পড়বে ");
INSERT INTO benirv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","আর যদি কেউ কোনো স্ত্রীকে ও তার মাকে বিয়ে করে, তবে তা খারাপ; তাদেরকে আগুনে পুড়িয়ে দিতে হবে, তাকে ও তাদের দুজনকে পুড়িয়ে দিতে হবে; যেন তোমাদের মধ্যে খারাপ কাজ না হয়। ");
INSERT INTO benirv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","আর যে কেউ যদি কোন পশুর সঙ্গে শয়ন করে, তার প্রাণদণ্ড অবশ্য হবে এবং তোমরা সেই পশুকেও হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","আর কোন স্ত্রী যদি পশুর কাছে গিয়ে তার সঙ্গে শয়ন করে, তবে তুমি সেই স্ত্রীকে ও সেই পশুকে হত্যা করবে; তাদের প্রাণদণ্ড অবশ্য হবে, তাদের রক্ত তাদের উপরে পড়বে। ");
INSERT INTO benirv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","আর যদি কেউ নিজের বোনকে, বাবার মেয়ে কে কিংবা মায়ের মেয়ের সঙ্গে ব্যভিচার করে ও উভয়ে উভয়ের আবরণীয় দেখে, তবে তা লজ্জাকর বিষয়; তারা নিজের জাতির ছেলেদের সামনে আলাদা হবে; নিজের বোনের আবরণীয় খোলে সে নিজের অপরাধ বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","আর যদি কেউ রজস্বলা স্ত্রীর সঙ্গে শয়ন করে ও তার আবরণীয় খোলে তবে সেই পুরুষ তার রক্তাকর প্রকাশ করাতে ও সেই স্ত্রী নিজের রক্তাকর খোলাতে তারা উভয়ে নিজের লোকদের মধ্য থেকে আলাদা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","আর তুমি নিজের মাসীর কিংবা পিসীর আবরণীয় খুলো না; তা করলে নিজের ঘনিষ্ঠ আত্মীয়দের আবরণীয় খোলা হয়, তারা উভয়েই নিজের নিজের অপরাধ বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","আর যদি কেউ নিজের কাকার স্ত্রীর সঙ্গে শোয় তবে নিজের কাকার স্ত্রীর আবরণীয় খোলে; তারা নিজের নিজের পাপ বহন করবে, নিঃসন্তান হয়ে মরিবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","আর যদি কেউ নিজের ভাইয়ের স্ত্রীর সঙ্গে বিয়ে করে, তা অশুচি কাজ; নিজের ভাইয়ের স্ত্রীর আবরণীয় খোলাতে তারা নিঃসন্তান থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","তোমরা আমার সমস্ত বিধি ও আমার সমস্ত শাসন মান্য কোরো, পালন কোরো; যেন আমি তোমাদের থাকার জন্য তোমাদেরকে যে দেশে নিয়ে যাচ্ছি, সেই দেশ তোমাদের কে উগরিয়ে না ফেলে। ");
INSERT INTO benirv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","আর আমি তোমাদের সামনে থেকে যে জাতিকে দূর করতে উদ্যত, তার আচার আচরন অনুযায়ী আচরণ করিও না; কারণ তারা ঐ সব কাজ করত, এই জন্য আমি তাদেরকে ঘৃণা করলাম। ");
INSERT INTO benirv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","কিন্তু আমি তোমাদেরকে অধিকার করার জন্য সেই দুগ্ধমধুপ্রবাহী দেশ দেব; আমি সদাপ্রভু তোমাদের ঈশ্বর; আমি অন্য জাতি সব থেকে তোমাদেরকে আলাদা করেছি। ");
INSERT INTO benirv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","অতএব তোমরা শুচি অশুচি পশুর ও শুচি অশুচি পাখীর তফাৎ করবে; আমি যে যে পশু, পাখী ও ভূচর কীটা সব জন্তুকে অশুচি বলে তোমাদের থেকে আলাদা করলাম, সে সকলের দ্বারা তোমরা নিজেদের প্রাণকে ঘৃণার্হ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","আর তোমরা আমার উদ্দেশ্যে পবিত্র হও, কারণ আমি সদাপ্রভু পবিত্র এবং আমি তোমাদেরকে জাতিদের থেকে আলাদা করেছি, যেন তোমরা আমারই হও। ");
INSERT INTO benirv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","আর পুরুষের কিম্বা স্ত্রীর মধ্যে যে কেউ ভূতড়িয়া কিম্বা গুণী হয়, তার প্রাণদণ্ড অবশ্য হবে; লোকে তাদেরকে পাথরের আঘাতে হত্যা করবে; তাদের রক্ত তাদের উপর পড়বে’।” ");
INSERT INTO benirv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","আর সদাপ্রভু মোশিকে বললেন, তুমি হারোণের ছেলে যাজকদের কে বল, তাদেরকে বল, স্বজাতীয় মৃতের জন্য তারা কেউ অশুচি হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","কেবল নিজের ঘনিষ্ট আত্মীয় অর্থাৎ নিজের মা, কি বাবা, কি ছেলে, কি মেয়ে, কি ভাই মরলে অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","আর কাছের যে কুমারী বোনের স্বামী হয়নি, এরকম বোন মরলে সে অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","নিজের লোকদের মধ্যে প্রধান বলে সে নিজেকে অপবিত্র করার জন্য অশুচি হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","তারা নিজের নিজের মাথা মুণ্ডন করবে না ও নিজের নিজের শরীরে অস্ত্রাঘাত করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","তারা নিজের ঈশ্বরের উদ্দেশ্যে পবিত্র হবে ও নিজের ঈশ্বরের নাম অপবিত্র করবে না; কারণ তারা সদাপ্রভুর আগুনের করা উপহার, নিজেদের ঈশ্বরের খাদ্য উৎসর্গ করে; অতএব তারা পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","তারা বেশ্যা কিংবা ভ্রষ্টা স্ত্রীকে বিয়ে করবে না এবং স্বামী পরিত্যক্ত স্ত্রীকে বিয়ে করবে না, কারণ যাজক নিজের ঈশ্বরের উদ্দেশ্যে পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","অতএব তুমি তাকে পবিত্র রাখবে; কারণ সে তোমার ঈশ্বরের খাদ্য উৎসর্গ করে; সে তোমার কাছে পবিত্র হবে; কারণ তোমাদের পবিত্রকারী সদাপ্রভু আমি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","আর কোনো যাজকের মেয়ে যদি ব্যভিচার কাজ দ্বারা নিজেকে অপবিত্র করে, তবে সে নিজের বাবাকে অপবিত্র করে; তাকে আগুনে পুড়িয়ে দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","আর নিজের ভাইদের মধ্যে প্রধান যাজক, যার মাথাতে অভিষেক-তেল ঢালা হয়েছে, যে ব্যক্তি হস্তপূরণ দ্বারা পবিত্র বস্ত্র পরার অধিকারী হয়েছে, সে নিজের মাথা ন্যাড়া করবে না ও নিজের কাপড় ছিঁড়বে না। ");
INSERT INTO benirv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","আর সে কোনো মৃত দেহের কাছে যাবে না, নিজের বাবার কি নিজের মায়ের জন্যও সে নিজেকে অশুচি করবে না ");
INSERT INTO benirv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","এবং ধর্ম্মধাম থেকে বাহরে যাবে না এবং নিজের ঈশ্বরের ধর্ম্মধাম অপবিত্র করবে না, কারণ তার ঈশ্বরের অভিষেক-তেলের সংস্কার তার ওপরে আছে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","আর সে কেবল কুমারীকে বিয়ে করবে। ");
INSERT INTO benirv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","বিধবা, কি পরিত্যক্তা, কি ভ্রষ্টা স্ত্রী, কি বেশ্যা, এদের মধ্যে এক কুমারীকে বিয়ে করবে। ");
INSERT INTO benirv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","সে নিজের লোকদের মধ্যে নিজের বংশ অপবিত্র করবে না, কারণ আমি সদাপ্রভু তার পবিত্রকারী। ");
INSERT INTO benirv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","তুমি হারোণকে বল, পুরুষানুক্রমে তোমার বংশের মধ্যে যার গায়ে দোষ থাকে, সে নিজের ঈশ্বরের খাদ্য উৎসর্গ করতে কাছাকাছি না হোক। ");
INSERT INTO benirv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","যে কোন ব্যক্তির দোষ আছে, সে কাছে যাবে না; অন্ধ, কি খোঁড়া, ");
INSERT INTO benirv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","কি খাঁদা, কি বিকলাঙ্গ, কি পা ভাঙা, কি হাত ভাঙা, কি কুঁজো, কি বামন, ");
INSERT INTO benirv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","কি ছানিপড়া, কি কালসিটে, কি খোস, কি ক্ষতিগ্রস্ত অন্ডকোষ; ");
INSERT INTO benirv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","কোনো দোষ বিশিষ্ট কোনো পুরুষ হারোণ যাজকের বংশের মধ্যে আছে, সে সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহার উৎসর্গ করতে কাছে যাবে না; তার দোষ আছে, সে নিজের ঈশ্বরের খাদ্য উৎসর্গ করতে কাছে যাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","সে নিজের ঈশ্বরের খাদ্য, অতি পবিত্র বস্তু ও পবিত্র বস্তু ভোজন করতে পারবে; ");
INSERT INTO benirv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","কিন্তু পর্দার ভেতরে প্রবেশ করবে না ও বেদির কাছে যাবে না, কারণ তার দোষ আছে; সে আমার পবিত্র জায়গা সব অপবিত্র করবে না, কারণ আমি সদাপ্রভু সে সকলের পবিত্রকারী। ");
INSERT INTO benirv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","মোশি হারোণকে, তাঁর ছেলেদেরকে ও সমস্ত ইস্রায়েলদের কে এই কথা বললেন। ");
INSERT INTO benirv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“তুমি হারোণ ও তাঁর ছেলেদেরকে বল, ইস্রায়েল-সন্তানদের আমার উদ্দেশ্যে যা পবিত্র করে, তাদের সেই পবিত্র বস্তু সব থেকে যেন ওরা আলাদা থাকে এবং যেন আমার পবিত্র নাম অপবিত্র না করে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","তুমি ওকে বল, পুরুষানুক্রমে তোমাদের বংশের মধ্যে যে কেউ অশুচি হয়ে পবিত্র বস্তুর কাছে, অর্থাৎ ইস্রায়েল-সন্তানদের দ্বারা সদাপ্রভুর উদ্দেশ্যে পবিত্রকরা বস্তুর কাছে যাবে, সেই প্রাণী আমার সামনে থেকে বিচ্ছিন্ন হবে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","হারোণ বংশের যে কেউ কুষ্ঠ কিংবা প্রমেহ হয়, সে শুচি না হওয়া পর্যন্ত সদাপ্রভুর প্রতি উৎসর্গীকৃত পবিত্র কোনো বস্তু খাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","আর যে কেউ মৃতদেহ ঘটিত অশুচি বস্তু, কিংবা যার রেতঃপাত হয় তাকে, স্পর্শ করে, কিংবা যে ব্যক্তি অশৌচজনক কীটাদি জন্তুকে কিংবা কোনো প্রকার অশৌচবিশিষ্ট মানুষকে স্পর্শ করে, ");
INSERT INTO benirv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","সেই স্পর্শকারী ব্যক্তি সন্ধ্যা পর্যন্ত অশুচি থাকবে এবং জলে নিজের শরীর না পরিষ্কার করলে পবিত্র বস্তু খাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","সূর্য্য অস্ত গেলে সে শুচি হবে; পরে পবিত্র বস্তু খাবে, কারণ তা তার খাবার জিনিস। ");
INSERT INTO benirv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","যাজক নিজে থেকে মরা কিংবা বন্য পশুর দ্বারা মৃত পশুর মাংস খাবে না; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","অতএব তারা আমার আদেশ পালন করুক; অথবা তা অপবিত্র করলে তারা তার জন্য পাপ বহন করে ও মারা পড়ে; আমি সদাপ্রভু তাদের পবিত্রকারী। ");
INSERT INTO benirv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","অন্য বংশীয় কোন লোক পবিত্র বস্তু খাবে না; যাজকের ঘরের অতিথিরা কিংবা বেতনজীবী কেউ পবিত্র বস্তু খাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","কিন্তু যাজক নিজে রূপা দিয়ে যে কোন ব্যক্তিকে কেনে সে তা খাবে এবং তার ঘরের লোকেরাও তার অন্ন খাবে। ");
INSERT INTO benirv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","আর যাজকের মেয়ের যদি অন্য বংশীয় লোকের সঙ্গে বিয়ে হয়, তবে সে পবিত্র বস্তুর উত্তোলনীয় উপহার খাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","কিন্তু যাজকের মেয়ে যদি বিধবা কিংবা পরিত্যক্তা হয়, আর তার সন্তান না থাকে এবং সে আবার এসে ছোটবেলার মত বাবার ঘরে বাস করে, তবে সে বাবার অন্ন খাবে, কিন্তু অন্য বংশীয় কোন লোক তা খাবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","আর যদি কেউ না জেনে পবিত্র বস্তু খায়, তবে সে সেভাবে পবিত্র বস্তু ও তার পঞ্চমাংশ বেশী করে যাজককে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","আর ইস্রায়েল-সন্তানেরা নিজেদের যে যে পবিত্র বস্তু সদাপ্রভুর উদ্দেশ্যে উত্সর্গ করে, যাজকেরা তা অপবিত্র করবে না,” ");
INSERT INTO benirv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","এবং তাদেরকে ওদের পবিত্র বস্তু খাওয়ার জন্য দোষজনক অপরাধ স্বরূপ ভারগ্রস্ত করবে না; কারণ আমি সদাপ্রভু তাদের পবিত্রকারী। ");
INSERT INTO benirv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","তুমি হারোণকে, তার ছেলেদেরকে ও সমস্ত ইস্রায়েল-সন্তানদেরকে, তাদেরকে বল, ইস্রায়েল-জাত কিংবা ইস্রায়েলের মধ্যে বসবাসকারী যে কেউ নিজের উপহার উৎসর্গ করে, তাদের কোনো মানতের বলি হোক, বা নিজের ইচ্ছায় দত্ত বলি হোক, যা সদাপ্রভুর উদ্দেশ্যে হোমবলিরূপে উৎসর্গ করে; ");
INSERT INTO benirv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","যেন তোমরা গ্রাহ্য হতে পার, তাই গরুর কিংবা মেষের কিংবা ছাগলের মধ্য থেকে নির্দোষ পুরুষ পশু উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","তোমরা দোষী কিছু উৎসর্গ কোরো না, কারণ তা তোমাদের পক্ষে গ্রাহ্য হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","আর কোনো লোক যদি মানত পূর্ণ করবার জন্য কিংবা নিজের ইচ্ছায় দেওয়া উপহারের জন্য গরু ভেড়ার পাল থেকে মঙ্গলের জন্য বলি উৎসর্গ করে, তবে গ্রাহ্য হবার জন্য তা নির্দোষ হবে; তাতে কোনো দোষ থাকবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","অন্ধ, কি খোঁড়া, কি ক্ষতবিক্ষত, কি আলসার, কি চর্মরোগ, কি ফোঁড়া হলে তোমরা সদাপ্রভুর উদ্দেশ্যে তা উৎসর্গ কোরো না এবং তার কিছুই সদাপ্রভুর উদ্দেশ্যে অগ্নিকৃত উপহার বলে বেদির উপরে স্থাপন করিও না। ");
INSERT INTO benirv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","আর তুমি অধিকাংশ কি হীনাঙ্গ গরু কিম্বা মেষ স্ব-ইচ্ছায় দত্ত উপহাররূপে উৎসর্গ করিতে পার, কিন্তু মানতের কারণ তা গ্রাহ্য হইবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","আর থেঁতলানো কিম্বা নিষ্পিষ্ট কিম্বা ভাঙ্গা কিম্বা বিদীর্ণ হওয়া কিছুই সদাপ্রভুর উদ্দেশ্যে উৎসর্গ করিও না; তোমাদের দেশে এইরূপ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","আর বিদেশীর হাত থেকেও এ সকলের মধ্যে কিছু নিয়ে ঈশ্বরের নৈবেদ্যরূপে উৎসর্গ করিও না, কারণ তাদের অঙ্গগের দোষ আছে, সুতরাং তাদের মধ্যে দোষ আছে; তারা তোমাদের পক্ষে গ্রাহ্য হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","গরু, কি মেষ, কি ছাগল জন্মিলে পর সাত দিন পর্যন্ত মায়ের সঙ্গে থাকবে; পরে অষ্টম দিন থেকে তা সদাপ্রভুর উদ্দেশ্যে অগ্নিকৃত উপহারের জন্যে গ্রাহ্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","গরু কিংবা ভেড়া হোক, তাকে ও তার বাচ্চাকে এক দিনের হত্যা কোরো না। ");
INSERT INTO benirv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","আর যে দিনের তোমরা সদাপ্রভুর উদ্দেশ্যে স্তবার্থক বলি উৎসর্গ করবে, সেইদিনের গ্রাহ্য হবার জন্যই তা উৎসর্গ কোরো। ");
INSERT INTO benirv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","সেই দিনের তা খেতে হবে; তোমরা সকাল পর্যন্ত তার কিছু বাকি রেখো না; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","অতএব তোমরা আমার আদেশ সব মান্য করবে, পালন করবে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","আর তোমরা আমার পবিত্র নাম অপবিত্র কোরো না; কিন্তু আমি ইস্রায়েল-সন্তানদের মধ্যে পবিত্ররূপে মান্য হব; আমি সদাপ্রভু তোমাদের পবিত্রকারী; ");
INSERT INTO benirv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","আমি তোমাদের ঈশ্বর হবার জন্য মিশর দেশ থেকে তোমাদেরকে বের করে এনেছি; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","আর সদাপ্রভু মোশিকে বললেন, তুমি ইস্রায়েল-সন্তানদেরকে বল, তাদেরকে বল, ");
INSERT INTO benirv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","তোমরা সদাপ্রভুর যে সব পর্ব পবিত্র সভা বলে ঘোষণা করবে, আমার সেই সব পর্ব এই। ");
INSERT INTO benirv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ছয় দিন কাজ করতে হবে, কিন্তু সপ্তম দিনের বিশ্রামের জন্য বিশ্রামপর্ব, পবিত্র সভা হবে, তোমরা কোন কাজ করবে না; সে দিন তোমাদের সব গৃহে সদাপ্রভুর উদ্দেশ্যে বিশ্রামদিন। ");
INSERT INTO benirv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","তোমরা নির্দিষ্ট দিনের যে সব পবিত্র সভা ঘোষণা করবে, সদাপ্রভুর সেই সব পর্ব এই। ");
INSERT INTO benirv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","প্রথম মাসে, মাসের চোদ্দ দিনের সন্ধ্যাবেলায় সদাপ্রভুর উদ্দেশ্যে নিস্তার পর্ব হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","এবং সেই মাসের পনেরো দিনের সদাপ্রভুর উদ্দেশ্যে খামি ছাড়া রুটির উৎসব হবে; তোমরা সাত দিন খামি ছাড়া রুটি খাবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","প্রথম দিনের তোমাদের পবিত্র সভা হবে; তোমরা কোনো সাধারন কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","কিন্তু সাত দিন সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহার উত্সর্গ করবে; সপ্তম দিনের পবিত্র সভা হবে; তোমরা কোন সাধারন কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","তুমি ইস্রায়েল-সন্তানদেরকে বল, তাদেরকে বল, আমি তোমাদেরকে যে দেশ দেব, সেই দেশে থেকে তোমরা যখন সেখানে উত্পন্ন শস্য কাটবে, তখন তোমাদের কাটা শস্যের অগ্রিমাংশ বলে এক আঁটি যাজকের কাছে আনবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","সে সদাপ্রভুর সামনে ঐ আঁটি দোলাবে, যেন তোমাদের জন্য তা গ্রহণযোগ্য হয়; বিশ্রামবারের পরদিন যাজক তা দোলাবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","আর যে দিন তোমরা ঐ আঁটি দোলাবে, সে দিন সদাপ্রভুর উদ্দেশ্যে হোমের জন্য একবছরের নির্দোষ এক ভেড়ার বাচ্চা উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","তার ভক্ষ্য-নৈবেদ্য এক ঐফার দুই দশমাংশ তেল মেশানো সূক্ষ্ম সূজি; তা সদাপ্রভুর উদ্দেশ্যে সুগন্ধের জন্য আগুনে করা উপহার হবে ও তার পানীয় নৈবেদ্য এক হিন আঙ্গুর রসের চতুর্থাংশ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","আর তোমরা যতক্ষণ নিজের ঈশ্বরের উদ্দেশ্যে এই উপহার না আন, সে দিন পর্যন্ত রুটি কি ভাজা শস্য কি তাজা শীষ খাবে না; তোমাদের সব গৃহে এটি পুরুষানুক্রমে পালনীয় চিরস্থায়ী ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","আর সেই বিশ্রামবারের পরদিন থেকে, দোলনীয় নৈবেদ্যরূপ আঁটি আনবার দিন থেকে, তোমরা পূর্ণ সাত বিশ্রামবার গণনা করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","এভাবে সপ্তম বিশ্রামবারের পরদিন পর্যন্ত তোমরা পঞ্চাশ দিন গণনা করে সদাপ্রভুর উদ্দেশ্যে নূতন খাবারের উপহার উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","তোমরা নিজ নিজগৃহ থেকে দোলনীয় নৈবেদ্যের জন্য এক ঐফার দুই দশমাংশের দুই খান রুটি আনবে; সূক্ষ্ম সূজি দিয়ে তা তৈরী কোরো ও খামি দিয়ে তৈরী কোরো; তা সদাপ্রভুর উদ্দেশ্যে আশুপক্কাংশ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","আর তোমরা সেই রুটির সঙ্গে একবছরের নির্দোষ সাতটি ভেড়ার বাচ্চা, এক যুব বৃষ ও দুটি ভেড়া উৎসর্গ করবে; তা সদাপ্রভুর উদ্দেশ্যে হোমবলি হবে এবং সেইসম্বন্ধীয় ভক্ষ্য-নৈবেদ্যের ও পানীয় নৈবেদ্যের সঙ্গে সদাপ্রভুর উদ্দেশ্যে সুগন্ধের জন্য আগুনে করা উপহার হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","পরে তোমরা পাপের বলির জন্য এক ছাগলের বাচ্চা ও মঙ্গলের বলির জন্য এক বছরের দুটি ভেড়ার বাচ্চা বলিদান করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","আর যাজক ঐ আশুপক্কাংশের রুটির সঙ্গে ও দুটি ভেড়ার বাচ্চার সঙ্গে সদাপ্রভুর উদ্দেশ্যে দোলনীয় নৈবেদ্যরূপে তাদেরকে দোলাবে; সে সব যাজকের জন্য সদাপ্রভুর উদ্দেশ্যে পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","আর সেই দিনের ই তোমরা ঘোষণা করবে; তোমাদের পবিত্র সভা হবে; তোমরা কোনো সাধারন কাজ করবে না; এটা তোমাদের সব গৃহে পুরুষানুক্রমে পালনীয় চিরস্থায়ী ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","আর তোমাদের ভূমির শস্য কাটার দিন তোমরা কেউ নিজের ক্ষেতের কোণের দিকে শস্য নিঃশেষে কাটবে না ও নিজের শস্য কাটার পরে পড়ে যাওয়া শস্য সংগ্রহ করবে না; তা দুঃখী ও বিদেশীর জন্য ত্যাগ করবে; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","তুমি ইস্রায়েল-সন্তানদেরকে বল, সপ্তম মাসে, সেই মাসে প্রথম দিনের তোমাদের বিশ্রামপর্ব এবং তূরীধ্বনিসহযোগে স্মরণ করার জন্য পবিত্র সভা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","তোমরা কোন সাধারন কাজ করবে না, কিন্তু সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহার উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","আবার ঐ সপ্তম মাসের দশম দিনের প্রায়শ্চিত্তদিন; সে দিন তোমাদের পবিত্র সভা হবে ও তোমরা নিজের নিজের প্রাণকে দুঃখ দেবে এবং সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহার উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","আর সেই দিন তোমরা কোন কাজ করবে না; কারণ তোমাদের ঈশ্বর সদাপ্রভুর সামনে তোমাদের জন্য প্রায়শ্চিত্ত করার জন্য তা প্রায়শ্চিত্তদিন হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","সে দিন যে কেউ নিজের প্রাণকে দুঃখ না দেয়, সে নিজের লোকদের মধ্য থেকে বিচ্ছিন্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","আর সেই দিন যে কোনো প্রাণী কোনো কাজ করে, তাকে আমি তার লোকদের মধ্য থেকে বিচ্ছিন্ন করবো। ");
INSERT INTO benirv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","তোমরা কোনো কাজ কোরো না; এটা তোমাদের সব গৃহে পুরুষানুক্রমে পালনীয় চিরস্থায়ী ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","সেই দিন তোমাদের বিশ্রামের জন্য বিশ্রামদিন হবে, আর তোমরা নিজের নিজের প্রাণকে দুঃখ দেবে; মাসের নবম দিনের সন্ধ্যাবেলায়, এক সন্ধ্যা থেকে অন্য সন্ধ্যা পর্যন্ত, নিজেদের বিশ্রামদিন পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","তুমি ইস্রায়েল-সন্তানদেরকে বল, ঐ সপ্তম মাসের পনেরো দিন থেকে সাত দিন পর্যন্ত সদাপ্রভুর উদ্দেশ্যে গৃহ উৎসব হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","প্রথম দিনের পবিত্র সভা হবে; তোমরা কোনো সাধারন কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","সাত দিন তোমরা সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহার উৎসর্গ করবে; পরে অষ্টম দিনের তোমাদের পবিত্র সভা হবে; আর তোমরা সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহার উৎসর্গ করবে; এটি পর্বসভা; তোমরা কোনো সাধারন কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","এই সব সদাপ্রভুর পর্ব। এই সব পর্ব তোমরা পবিত্র সভা বলে ঘোষণা করবে এবং প্রতিদিন যেমন কাজ, সেই অনুসারে সদাপ্রভুর উদ্দেশ্যে আগুনের করা উপহার, হোমবলি, ভক্ষ্য-নৈবেদ্য এবং বলি ও পানীয় নৈবেদ্য উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","সদাপ্রভুর বিশ্রামদিন থেকে, সদাপ্রভুর উদ্দেশ্যে দাতব্য তোমাদের দান থেকে, তোমাদের সব মানত থেকে ও তোমাদের নিজের ইচ্ছায় দেওয়া সব নৈবেদ্য থেকে এই সব আলাদা। ");
INSERT INTO benirv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","আবার সপ্তম মাসের পনেরো দিনের ভূমির ফল সংগ্রহ করলে পর তোমরা সাত দিন সদাপ্রভুর উৎসব পালন করবে; প্রথম দিন বিশ্রামপর্ব ও অষ্টম দিন বিশ্রামপর্ব হবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","আর প্রথম দিনের তোমরা শোভাদায়ক বৃক্ষের ফল, খেজুর-পাতা, জড়ান গাছের শাখা এবং নদীর ধারে বাইসী-বৃক্ষ নিয়ে তোমাদের ঈশ্বর সদাপ্রভুর সামনে সাত দিন আনন্দ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","আর তোমরা বৎসরের মধ্যে সাত দিন সদাপ্রভুর উদ্দেশ্যে সেই উৎসব পালন করবে; এটা তোমারদের পুরুষানুক্রমে পালনীয় চিরস্থায়ী ব্যবস্থা; সপ্তম মাসে তোমরা সেই উৎসব পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","তোমরা সাত দিন কুটির বাস কোরো; ইস্রায়েল-বংশজাত সকলে কুটিরে বাস করবে। ");
INSERT INTO benirv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","এতে তোমাদের ভাবী বংশ জানতে পারবে যে, আমি ইস্রায়েল-সন্তানদেরকে মিশর দেশ থেকে বের করে এনে কুটিরে বাস করিয়েছিলাম; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","তখন মোশি ইস্রায়েল-সন্তানদের কাছে সদাপ্রভুর পর্বগুলির কথা বললেন। ");
INSERT INTO benirv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","তুমি ইস্রায়েল-সন্তানদেরকে এই আদেশ কর; তারা আলোর জন্য তোমার কাছে আলোর বাতিতে প্রস্তুত শুদ্ধ জিত-তেল আনবে, তাই দিয়ে সব দিন প্রদীপ জ্বালানো থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","হারোণ সমাগম-তাঁবুর মধ্যে নিয়ম-সিন্দুকের পর্দার বাইরে সন্ধ্যা থেকে সকাল পর্যন্ত সদাপ্রভুর সামনে সব দিন তা সাজিয়ে রাখবে; এটা তোমাদের পুরুষানুক্রমে পালনীয় চিরস্থায়ী ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","সে নির্ম্মল দীপবৃক্ষের উপরে সদাপ্রভুর সামনে নিয়ত ঐ প্রদীপ সব সাজিয়ে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","আর তুমি সূক্ষ্ম সূজি নিয়ে বারটি পিষ্টক পাক করবে; তার প্রত্যেক পিষ্ট এক ঐফার দশ ভাগের দুই ভাগ হবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","পরে তুমি এক এক পংত্তিতে ছয় ছয়টি, এই রূপে দুই পংত্তি করে সদাপ্রভুর সামনে বিশুদ্ধ সোনার মেজের ওপরে তা রাখবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","প্রত্যেক পংত্তির উপরে বিশুদ্ধ ধুনো দেবে; তা সেই রুটির স্মরণ করার জন্য অংশ বলে সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহার হবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","যাজক নিয়মিত ভাবে প্রতি বিশ্রামবারে সদাপ্রভুর সামনে তা সাজিয়ে রাখবে, তা ইস্রায়েল-সন্তানদের পক্ষে চিরস্থায়ী ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","আর তা হারোণের ও তার ছেলেদের হবে; তারা কোন পবিত্র জায়গায় তা খাবে; কারণ সদাপ্রভুর উদ্দেশ্যে আগুনে করা উপহারের মধ্যে তা তার জন্য অতি পবিত্র; এ চিরস্থায়ী ব্যবস্থা। ");
INSERT INTO benirv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","আর ইস্রায়েলীয়া স্ত্রীর, কিন্তু মিশরীয় পুরুষের এক ছেলে বের হয়ে ইস্রায়েল-সন্তানদের মধ্যে গেল এবং শিবিরের মধ্যে সেই ইস্রায়েলীয়া স্ত্রীর ছেলে ও ইস্রায়েলের কোন পুরুষ বিবাদ করল। ");
INSERT INTO benirv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","তখন সেই ইস্রায়েলীয়া স্ত্রীর ছেলের সদাপ্রভুর নামে নিন্দা করে শাপ দিল, তাতে লোকেরা তাকে মোশির কাছে নিয়ে গেল। তার মায়ের নাম শলোমীৎ, সে দানবংশীয় দেব্রির মেয়ে। ");
INSERT INTO benirv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","লোকেরা সদাপ্রভুর মুখে স্পষ্ট আদেশ পাবার অপেক্ষায় তাকে আটকে রাখল। ");
INSERT INTO benirv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","তুমি ঐ শাপদায়ীকে শিবিরের বাইরে নিয়ে যাও; পরে যারা তার কথা শুনেছে, তারা সকলে তার মাথায় হাত রাখুক এবং সব মণ্ডলী পাথরের আঘাতে তাকে হত্যা করুক। ");
INSERT INTO benirv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","আর তুমি ইস্রায়েল-সন্তানদেরকে বল, যে কেউ নিজের ঈশ্বরকে শাপ দেয়, সে নিজের পাপ বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","আর যে সদাপ্রভুর নামে নিন্দা করে, তার প্রাণদণ্ড অবশ্য হবে; সমস্ত মণ্ডলী তাকে পাথরের আঘাতে হত্যা করবে; বিদেশী হোক বা স্বদেশী হোক, সেই নামের নিন্দা করলে তার প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","আর যে কেউ কোন মানুষকে হত্যা করে, তার প্রাণদণ্ড অবশ্য হবে; ");
INSERT INTO benirv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","আর যে কেউ পশু হত্যা করে, সে তার শোধ দেবে; প্রাণের পরিশোধে প্রাণ। ");
INSERT INTO benirv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","যদি কেউ স্বজাতীয়ের গায়ে ক্ষত করে, তবে সে যেমন করেছে, তার প্রতি তেমনি করা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ভাঙার পরিশোধে ভাঙা, চোখের পরিশোধে চোখ, দাঁতের পরিশোধে দাঁত; মানুষের যে যেমন ক্ষত করে, তার প্রতি তেমনি করা যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","যে জন পশুর হত্যা করে, সে তা শোধ দেবে; কিন্তু যে জন মানুষকে হত্যা করে, তার প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","তোমাদের স্বদেশীয় ও বিদেশীয় উভয়েরই জন্য এরকম শাসন হবে; কারণ আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","পরে মোশি ইস্রায়েল-সন্তানদেরকে এই কথা বললেন, তাতে তারা সেই শাপদায়ীকে শিবিরের বাইরে নিয়ে গিয়ে পাথরের আঘাতে হত্যা করল; মোশিকে সদাপ্রভু যেমন আদেশ দিয়েছিলেন, ইস্রায়েল-সন্তানদের সেই রকম করল। ");
INSERT INTO benirv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","আর সদাপ্রভু সীনয় পর্বতে মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","তুমি ইস্রায়েল-সন্তানদেরকে বল, তাদেরকে বল, আমি তোমাদিগকে যে দেশ দেব, তোমরা সেই দেশে প্রবেশ করলে সদাপ্রভুর উদ্দেশ্যে জমি বিশ্রাম ভোগ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ছয় বছর তুমি নিজের জমিতে বীজ বপন করবে, ছয় বছর নিজের আঙ্গুরফল পাড়বে ও তার ফল সংগ্রহ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","কিন্তু সপ্তম বছরে জমির বিশ্রামের জন্য বিশ্রামকাল, সদাপ্রভুর উদ্দেশ্যে বিশ্রামকাল হবে; তুমি নিজের জমিতে বীজ বপন কোরো না ও নিজের আঙ্গুরফল পেড়ো না; ");
INSERT INTO benirv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","তুমি জমির নিজে থেকে উৎপন্ন শস্য কাটবে না ও না পাড়া আঙ্গুরফল ফল সংগ্রহ করবে না; ওটা জমির বিশ্রামের জন্য বছর হবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","আর জমির বিশ্রাম তোমাদের খাবারের জন্য হবে; জমির সব জিনিসই তোমার, তোমার দাসের ও দাসীর, তোমার বেতনভোগী ভৃত্যের ও তোমার সহবাসী বিদেশীর ");
INSERT INTO benirv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","এবং তোমার পশুর ও তোমার দেশের বনপশুর খাবারের জন্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","আর তুমি নিজের জন্য সাত বিশ্রামবছর, সাত গুণ সাত বছর, গণনা করবে; তাতে তোমার গণিত সেই সাত গুণ সাত বিশ্রামবছরে ঊনপঞ্চাশ বছর হবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","তখন সপ্তম মাসের দশম দিনের তুমি জয়ধ্বনির তূরী বাজাবে; প্রায়শ্চিত্তদিনের তোমাদের সব দেশে তূরী বাজাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","আর তোমরা পঞ্চাশতম বছরকে পবিত্র করবে এবং সব দেশে সেখানকার সব অধিবাসীর কাছে মুক্তি ঘোষণা করবে; ওটি তোমাদের জন্য যোবেল তূরীধ্বনির মহোৎসব হবে এবং তোমরা প্রত্যেকে নিজের নিজের অধিকারে ফিরে যাবে ও প্রত্যেকে নিজের নিজের বংশের কাছে ফিরে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","তোমাদের জন্য পঞ্চাশত্তম বছর যোবেল হবে; তোমরা বীজ বুনো না, নিজে থেকে উৎপন্ন শস্য কেটো না এবং ঝোড়ে না পড়া আঙ্গুরফলের ফল সংগ্রহ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","কারণ ওটাই যোবেল, ওটা তোমাদের পক্ষে পবিত্র হবে; তোমরা জমিতে উৎপন্ন শস্য গুলো খেতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ঐ যোবেল বছরে তোমরা প্রতিদিন নিজের নিজের অধিকারে ফিরে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","তুমি যদি প্রতিবেশীর কাছে কোনো কিছু বিক্রয় কর, কিংবা নিজের প্রতিবেশীর হাত থেকে কেনো; তবে তোমরা পরস্পর অন্যায় কোরো না। ");
INSERT INTO benirv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","তুমি যোবেলের পরের বছর-সংখ্যানুসারে প্রতিবেশীর কাছ থেকে কিনবে এবং ফল উৎপত্তির বছর-সংখ্যা অনুসারে তোমার কাছে সে বিক্রি করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","তুমি বছরের বেশী অনুসারে মূল্যবেশী করবে ও বছরের কম অনুসারে মূল্য কম করবে; কারণ সে তোমার কাছে ফল উৎপত্তির দিনের সংখ্যা অনুসারে বিক্রি করে। ");
INSERT INTO benirv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","তোমরা তোমাদের প্রতিবেশীর প্রতি অন্যায় কোরো না, কিন্তু নিজের ঈশ্বরকে ভয় কোরো, কারণ আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","আর তোমরা আমার ব্যবস্থা অনুসারে আচরণ করবে, আমার শাসন সব মানবে ও তা পালন করবে; তাতে দেশে নির্ভয়ে বাস করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","আর জমি নিজে ফল উৎপন্ন করবে, তাতে তোমরা তৃপ্তি পর্যন্ত খাবে ও দেশে নির্ভয়ে বাস করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","আর যদি তোমরা বল, দেখ, আমরা সপ্তম বছরে কি খাব? দেখ, আমরা ত জমিতে বপন করব না ও উৎপন্ন ফল সংগ্রহ করব না; ");
INSERT INTO benirv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","তবে আমি ষষ্ট বছরে তোমাদেরকে আশীর্বাদ করব; তাতে তিন বছরের জন্য শস্য উৎপন্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","পরে অষ্টম বছরে তোমরা বপন করবে ও নবম বছর পর্যন্ত পুরানো শস্য খাবে; যতক্ষণ ফল না হয়, ততক্ষণ পুরানো শস্য খাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","আর জমি চিরদিনের র জন্য বিক্রি হবে না, কারণ জমি আমারই; তোমরা ত আমার সঙ্গে বিদেশী ও প্রবাসী। ");
INSERT INTO benirv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","আর তোমরা নিজেদের অধিকার করা দেশের সব জমি মুক্ত করতে দিও। ");
INSERT INTO benirv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","তোমার ভাই যদি গরিব হয়ে নিজের অধিকারের কিছু বিক্রি করে, তবে তার মুক্তিকর্তার কাছে আত্মীয় এসে নিজের ভাইয়ের বিক্রি করা জমি মুক্ত করে নেবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","যার মুক্তিকর্তা নেই, সে যদি ধনবান্ হয়ে নিজে তা মুক্ত করতে সমর্থ হয়, ");
INSERT INTO benirv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","তবে সে তার বিক্রির বছরে গণনা করে সেই অনুসারে অতিরিক্ত মূল্য ক্রেতাকে ফিরিয়ে দেবে; এভাবে সে নিজের অধিকারে ফিরে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","কিন্তু যদি সে তা ফিরিয়ে নিতে অসমর্থ হয়, তবে সেই বিক্রীত অধিকার যোবেল বছর পর্যন্ত ক্রেতার হাতে থাকবে; যোবেলে তা মুক্ত হবে এবং সে নিজের অধিকারে ফিরে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","আর যদি কেউ প্রাচীরে ঘেরা নগরের মাঝখানে বাসগৃহ বিক্রয় করে, তবে সে বিক্রয়-বছরের শেষ পর্যন্ত তা মুক্ত করতে পারবে, পূর্ণ এক বছরের মধ্যে তা মুক্ত করবার অধিকারী থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","কিন্তু যদি সম্পূর্ণ এক বছর দিনের র মধ্যে তা মুক্ত না হয়, তবে প্রাচীরে ঘেরা নগরের মধ্যে সেই গৃহ পুরুষপরম্পরায় ক্রয়কর্তার চিরস্থায়ী অধিকার হবে; তা যোবেলে মুক্ত হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","কিন্তু প্রাচীরছাড়া গ্রামে অবস্থিত গৃহ দেশের জমির মধ্যে গণনা হবে; তা মুক্ত করা যেতে পারে এবং যোবেলে তা মুক্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","কিন্তু লেবীয়দের নগর সব, তাদের অধিকারে নগরের গৃহ সব মুক্ত করবার অধিকার লেবীয়দের সব দিন ই থাকবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","যদি লেবীয়দের কেউ মুক্ত করে, তবে সেই বিক্রীত গৃহ এবং তার অধিকারের নগর যোবেলে মুক্ত হবে; কারণ ইস্রায়েল-সন্তানদের মধ্যে লেবীয়দের নগরের গৃহ সব তাদের অধিকার। ");
INSERT INTO benirv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","আর তাদের নগরের চরাণিভূমি বিক্রীত হবে না; কারণ তাই তাদের চিরস্থায়ী অধিকার। ");
INSERT INTO benirv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","আর তোমার ভাই যদি গরিব হয় ও তোমার কাছে শূন্যহাত হয়, তবে তুমি তার উপকার করবে; সে বিদেশী ও প্রবাসীর মত তোমার সঙ্গে জীবন ধারণ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","তুমি তা থেকে সুদ কিংবা বৃদ্ধি নেবে না, কিন্তু নিজের ঈশ্বরকে ভয় করবে, তোমার ভাইকে তোমার সঙ্গে জীবন ধারণ করতে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","তুমি সুদের জন্য তাকে টাকা দেবে না ও বৃদ্ধির জন্য তাকে অন্ন দেবে না। ");
INSERT INTO benirv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","আমি সদাপ্রভু তোমাদের সেই ঈশ্বর, যিনি তোমাদেরকে কনান দেশ দেবার জন্য ও তোমাদের ঈশ্বর হবার জন্য তোমাদেরকে মিশর দেশ থেকে বের করে এনেছেন। ");
INSERT INTO benirv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","আর তোমার ভাই যদি গরিব হয়ে তোমার কাছে নিজেকে বিক্রয় করে, তবে তুমি তাকে দাসের মত কাজ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","সে বেতনজীবী মজুরের মত কিংবা প্রবাসীর মত তোমার সঙ্গে থাকবে, যোবেল বছর পর্যন্ত তোমার দাস্যকর্ম্ম করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","পরে সে নিজের সন্তানদের সঙ্গে তোমার কাছ থেকে মুক্ত হয়ে নিজের বংশের কাছে ফিরে যাবে ও নিজের পৈতৃক অধিকারে ফিরে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","কারণ তারা আমারই দাস, যাদেরকে আমি মিশর দেশ থেকে বের করে এনেছি; তাদের দাসের মত বিক্রি করা হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","তুমি তার উপরে কঠিন কর্তৃত্ব কোরো না, কিন্তু নিজের ঈশ্বরকে ভয় কোরো। ");
INSERT INTO benirv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","তোমাদের চারদিকে জাতিগণের মধ্য থেকে তোমরা দাস ও দাসী রাখতে পারবে; তাদের থেকেই তোমরা দাস ও দাসী ক্রয় কোরো। ");
INSERT INTO benirv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","আর তোমাদের মধ্য প্রবাসী বিদেশীদের সন্তানদের থেকে এবং তোমাদের দেশে তাদের উৎপন্ন তাদের যে যে বংশ তোমাদের সঙ্গে আছে, তাদের থেকেও ক্রয় কোরো; তারা তোমাদের অধিকার হবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","আর তোমরা নিজের নিজের ভাবী সন্তানদের অধিকারের জন্য দায়ভাগ দ্বারা তাদেরকে দিতে পার এবং নিত্য নিজেদের দাস্যকর্ম তাদেরকে দিয়ে করাতে পার; কিন্তু তোমাদের ভাই ইস্রায়েল-সন্তানদের মধ্যে তোমরা কেউ কারও কঠিন কর্তৃত্ব করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","আর যদি তোমাদের মধ্যে কোন বিদেশী কিংবা প্রবাসী ধনবান হয় এবং তার কাছাকাছি তোমার ভাই গরিব হয়ে যদি তোমার কাছাকাছি প্রবাসী, বিদেশী কিংবা বিদেশীয় গোত্রের কোনো লোকের কাছে নিজেকে বিক্রয় করে, ");
INSERT INTO benirv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","তবে সে বিক্রীত হবার পরে মুক্ত হতে পারবে; তার আত্মীয়ের মধ্যে কেউ তাকে মুক্ত করতে পারবে; ");
INSERT INTO benirv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","তার কাকা কিংবা কাকার ছেলে তাকে মুক্ত করবে, কিংবা তার বংশের কাছের কোন আত্মীয় তাকে মুক্ত করবে; কিংবা যদি সে ধনবান্‌ হয়ে উঠে, তবে নিজেকে মুক্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","তাতে তার বিক্রয় বছর থেকে যোবেল বছর পর্যন্ত ক্রেতার সঙ্গে হিসাব হলে বছরের সংখ্যা অনুসারে তার মূল্য হবে; ওর কাছে তার থাকবার দিন বেতনজীবী দিনের র মত হবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","যদি অনেক বছর বাকি থাকে, তবে সেই অনুসারে সে ক্রয়-মূল্য থেকে নিজের মুক্তির মূল্য ফিরিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","যদি যোবেল বৎসরের অল্প বৎসর বাকি থাকে, তবে সে তার সঙ্গে হিসাব করে সেই কয়েক বছর অনুসারে নিজের মুক্তির মূল্য ফিরিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","বছরের পর বছর ভাড়া করা মজুরের মত সে তার সঙ্গে থাকবে; তোমার সাক্ষাৎে সে তার উপরে কঠিন কর্তৃত্ব করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","আর যদি সে ঐ সব বছরে মুক্ত না হয়, তবে যোবেল বছরে নিজের সন্তানদের সঙ্গে মুক্ত হয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","কারণ ইস্রায়েল-সন্তানরা আমারই দাস; তারা আমার দাস, যাদেরকে আমি মিশর দেশ থেকে বের করে এনেছি; আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","তোমরা নিজেদের জন্য প্রতিমা তৈরী কোরো না এবং স্বর্ণ প্রতিমা কিংবা স্তম্ভ স্থাপন কোরো না ও তার কাছে প্রণাম করবার জন্য তোমাদের দেশে কোন ক্ষোদিত প্রস্তর রেখো না; কারণ আমি সদাপ্রভু তোমাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","তোমরা আমার বিশ্রামবার সব পালন কোরো ও আমার ধর্ম্মধামের সমাদর কোরো; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","যদি তোমরা আমার ব্যবস্থা মত চল, আমার আদেশ সব মান ও সে সব পালন কর, ");
INSERT INTO benirv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","তবে আমি ঠিক দিনের তোমাদেরকে বৃষ্টি দান করব; তাতে জমি শস্য উৎপন্ন করবে ও ক্ষেত্রের বৃক্ষ সব নিজের নিজের ফল দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","তোমাদের শস্য মাড়াইয়ের দিন আঙ্গুর তোলার দিন পর্যন্ত থাকবে ও আঙ্গুর তোলার দিন থেকে বীজবপনের দিন পর্যন্ত থাকবে এবং তোমরা তৃপ্তি পর্যন্ত অন্ন খাবে ও নিরাপদে নিজের দেশে বাস করবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","আর আমি দেশে শান্তি প্রদান করব; তোমরা শয়ন করলে কেউ তোমাদেরকে ভয় দেখাবে না এবং আমি তোমাদের দেশ থেকে হিংস্র জন্তুদেরকে দূর করে দেব ও তোমাদের দেশে খড়গ নিয়ে ভ্রমণ করবে না। ");
INSERT INTO benirv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","আর তোমরা নিজেদের শত্রুদেরকে তাড়িয়ে দেবে ও তারা তোমাদের সামনেই তলোয়ারের সামনে পড়বে ");
INSERT INTO benirv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","আর তোমাদের পাঁচ জন তাদের একশো জনকে তাড়িয়ে দেবে, তোমাদের একশো জন দশ হাজার লোককে তাড়িয়ে দেবে এবং তোমাদের শত্রুরা তোমাদের সামনেই তলোয়ারের সামনে পড়বে ");
INSERT INTO benirv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","আর আমি তোমাদের উপর খুশি হব তোমাদেরকে ফলবন্ত ও বহুবংশ করব ও তোমাদের সঙ্গে আমার নিয়ম স্থির করব। ");
INSERT INTO benirv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","আর তোমরা জমানো পুরানো শস্য খাবে ও নূতনের সামনে থেকে পুরানো শস্য বের করবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","আর আমি তোমাদের মধ্যে আমার পবিত্র তাঁবু রাখব, আমি তোমাদেরকে ঘৃণা করবো না। ");
INSERT INTO benirv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","আর আমি তোমাদের মধ্যে গমনাগমন করব ও তোমাদের ঈশ্বর হব এবং তোমরা আমার প্রজা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","আমি সদাপ্রভু তোমাদের ঈশ্বর; আমি মিশর দেশ থেকে তোমাদেরকে বের করে এনেছি, তাদের দাস থাকতে দিইনি; আমি তোমাদের যোয়ালির-কাঠ ভেঙে সোজাভাবে তোমাদেরকে গমন করিয়েছি। ");
INSERT INTO benirv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","কিন্তু যদি তোমরা আমার কথা না শুন ও আমার এ সব আদেশ পালন না কর, ");
INSERT INTO benirv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","যদি আমার ব্যবস্থা অগ্রাহ্য কর ও তোমাদের প্রাণ আমার শাসন সকল ঘৃণা করে, এভাবে তোমরা আমার আদেশ পালন না করে আমার নিয়ম ভঙ্গ কর, তবে আমিও তোমাদের প্রতি এই ব্যবহার করব; ");
INSERT INTO benirv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","তোমাদের জন্য আতঙ্ক, যক্ষ্মা ও কম্পজ্বর নিরূপণ করব, যাতে তোমাদের চক্ষু ক্ষীণ হয়ে পড়বে ও প্রাণে ব্যথা পাবে এবং তোমাদের বীজ বপন বৃথা হবে, কারণ তোমাদের শত্রুরা তা খাবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","আর আমি তোমাদের প্রতি বিমুখ হব; তাতে তোমরা নিজের শত্রুদের সামনে আহত হবে; যারা তোমাদেরকে ঘৃণা করে, তারা তোমাদের ওপরে কর্তৃত্ব করবে এবং কেউ তোমাদেরকে না তাড়ালেও তোমরা পালিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","আর যদি তোমরা এতেও আমার বাক্যে মনোযোগ না কর, তবে আমি তোমাদের পাপযুক্ত তোমাদেরকে সাত গুন বেশী শাস্তি দেব। ");
INSERT INTO benirv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","আমি তোমাদের শক্তির গর্ব চূর্ণ করব ও তোমাদের আকাশ লোহার মত ও তোমাদের জমি পিতলের মত করব। ");
INSERT INTO benirv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","তাতে তোমাদের শক্তি অকারণে শেষ হবে, কারণ তোমাদের জমি শস্য উৎপন্ন করবে না ও দেশের গাছপালা সব নিজ নিজ ফল দেবে না। ");
INSERT INTO benirv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","আর যদি তোমরা আমার বিপরীত আচরণ কর ও আমার কথা শুনতে না চাও, তবে আমি তোমাদের পাপ অনুসারে তোমাদেরকে আর সাত গুন আঘাত করব। ");
INSERT INTO benirv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","আর তোমাদের মধ্যে বন্য পশু পাঠাব; তারা তোমাদের সন্তান হরণ করবে, তোমাদের পশুপাল নষ্ট করবে, তোমাদেরকে সংখ্যায় অল্প করব; আর তোমাদের রাজপথ সব ধ্বংস হবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","এতে যদি আমার উদ্দেশ্যে শাসিত না হও, কিন্তু আমার বিপরীত আচরণ কর, ");
INSERT INTO benirv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","তবে আমিও তোমাদের বিপরীত আচরণ করব ও তোমাদের পাপযুক্ত আমিই তোমাদেরকে সাত বার আঘাত করব। ");
INSERT INTO benirv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","আমি অমান্যের প্রতিফল দেবার জন্য তোমাদের উপরে তলোয়ার আনব, তোমরা নিজ নিজ নগরমধ্যে একত্রীভূত হবে, আমি তোমাদের মধ্যে মহামারী পাঠাব এবং তোমরা শত্রুদের হাতে সমর্পিত হবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","আমি তোমাদের খাদ্য সরবরাহ বন্ধ করব, দশ জন স্ত্রীলোক এক উনানে তোমাদের রুটি পাক করবে ও তোমাদের রুটি মেপে তোমাদেরকে দেবে, কিন্তু তোমরা তা খেয়ে তৃপ্ত হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","আর এসবেতেও যদি তোমরা আমার কথা না শোন, আমার বিপরীত আচরণ কর, ");
INSERT INTO benirv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","তবে আমি ক্রোধে তোমাদের বিপরীত আচরণ করব এবং আমিই তোমাদের পাপযুক্ত তোমাদেরকে সাত গুন শাস্তি দেব। ");
INSERT INTO benirv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","আর তোমরা নিজের নিজের ছেলেদের মাংস খাবে ও নিজের নিজের মেয়েদের মাংস খাবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","আর আমি তোমাদের উচ্চ জায়গা সব ভেঙে দেব, তোমাদের সূর্য্যপ্রতিমা সকল নষ্ট করব ও তোমাদের মূর্তিদের মৃত দেহের উপরে তোমাদের মৃতদেহ ফেলে দেব এবং আমি তোমাদেরকে ঘৃণা করব। ");
INSERT INTO benirv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","আর আমি তোমাদের নগর সব ধ্বংস করব, তোমাদের ধর্ম্মধাম সব ধ্বংস করব ও তোমাদের উত্সর্গের গন্ধ গ্রহণ করব না। ");
INSERT INTO benirv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","আর আমি দেশ ধ্বংস করব ও সেখানে বসবাসকারী তোমাদের শত্রুরা সেই বিষয়ে চমৎকৃত হবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","আর আমি তোমাদেরকে জাতিদের মধ্যে ছিন্নভিন্ন করব ও তলোয়ার বের করে তোমাদের অনুসরণ করব, তাতে তোমাদের দেশ পরিত্যক্ত ও তোমাদের নগর সব ধ্বংস হবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","তখন যত দিন দেশ ধ্বংসস্থান থাকবে ও তোমরা শত্রুগণের দেশে বাস করবে, ততদিন জমি নিজ বিশ্রামকাল ভোগ করবে; সেই জমি বিশ্রাম পাবে ও নিজের বিশ্রামকাল ভোগ করবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","যতদিন দেশ ধ্বংসস্থান হয়ে থাকবে, তত দিন বিশ্রাম করবে, কারণ যখন তোমরা দেশে বাস করতে, তখন দেশ তোমাদের বিশ্রামকালে বিশ্রাম ভোগ করত না। ");
INSERT INTO benirv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","আর তোমাদের মধ্যে যারা অবশিষ্ট থাকবে, আমি শত্রুদেশে তাদের হৃদয়ে বিষণ্নতা পাঠাব এবং চালিত পাতার শব্দ তাদেরকে তাড়িয়ে নিয়ে যাবে; লোকে যেমন তলোয়ারের মুখ থেকে পালায়, তারা সেরকম পালাবে এবং কেউ না তাড়ালেও পড়বে। ");
INSERT INTO benirv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","কেউ না তাড়ালেও তারা যেমন তলোয়ারের সামনে, তেমনি এক জন অন্যের উপরে পড়বে এবং শত্রুদের সামনে দাঁড়াতে তোমাদের ক্ষমতা হবে না। ");
INSERT INTO benirv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","আর তোমরা জাতিদের মধ্যে বিনষ্ট হবে ও তোমাদের শত্রুদের দেশে তোমাদেরকে গ্রাস করবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","আর তোমাদের মধ্যে যারা অবশিষ্ট থাকবে, তারা নিজের নিজের অপরাধে শত্রুদেশে ক্ষয় হবে। ");
INSERT INTO benirv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","আর নিজেদের পিতৃপুরুষদেরও অপরাধে তাদের সঙ্গে ক্ষয় হবে। আর তাদেরকে স্বীকার করতে হবে যে, আমার বিরুদ্ধে সত্য অমান্য ও আমার বিপরীত আচরণ করার জন্য তাদের অপরাধ ও তাদের পিতৃপুরুষদের অপরাধ হয়েছে, ");
INSERT INTO benirv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","আমিও তাদের বিপরীত আচরন করেছি, আর তাদেরকে শত্রুদের দেশে এনেছি। তখন যদি তাদের অচ্ছিন্নত্বক হৃদয় নম্র হয় ও তারা নিজের নিজের অপরাধের শাস্তি মেনে নেয়, ");
INSERT INTO benirv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","তবে আমি যাকোবের সঙ্গে করা আমার নিয়ম মনে করবো ও ইসহাকের সঙ্গে করা আমার নিয়ম ও অব্রাহামের সঙ্গে করা আমার নিয়মও মনে করব, আর দেশকেও মনে করব। ");
INSERT INTO benirv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","দেশও তাদের দ্বারা পরিত্যক্ত হবে ও তাদের অবর্তমানে ধর্মস্থান হয়ে নিজে বিশ্রাম ভোগ করবে, ও তারা নিজেদের অপরাধের শাস্তি মেনে নেবে; কারণ তারা আমার শাসন মানত না ও তাদের প্রাণ আমার নিয়ম ঘৃণা করত। ");
INSERT INTO benirv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","তাছাড়া যখন তারা শত্রুদের দেশে থাকবে, তখন আমি নিঃশেষে ধ্বংসের জন্য কিংবা তাদের সঙ্গে আমার নিয়ম ভাঙার জন্য তাদেরকে অগ্রাহ্য করব না, ঘৃণাও করব না; কারণ আমি সদাপ্রভু তাদের ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","আর আমি তাদের ঈশ্বর হবার জন্য যাদেরকে জাতি সামনে মিশর দেশ থেকে বের করে এনেছি, তাদের সেই পিতৃপুরুষদের সঙ্গে করা আমার নিয়ম তাদের জন্য মনে রাখবো; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","সীনয় পাহাড়ে সদাপ্রভু মোশির হাত দিয়ে নিজের ও ইস্রায়েল সন্তানদের এই সব নিয়ম শাসন ও ব্যবস্থা স্থির করলেন। ");
INSERT INTO benirv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","আর সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“তুমি ইস্রায়েল-সন্তানদেরকে বল, তাদেরকে বল, ‘যদি কেউ বিশেষ মানত করে, তবে তোমার নির্ধারিত মূল্য অনুসারে প্রাণী সব সদাপ্রভুর হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","তোমার নির্ধারিত মূল্য এই; কুড়ি বছর বয়স থেকে ষাট বছর বয়স পর্যন্ত পুরুষ হলে তোমার নির্ধারিত মূল্য পবিত্র জায়গায় শেকল অনুসারে পঞ্চাশ শেকল রৌপ্য। ");
INSERT INTO benirv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","কিন্তু যদি স্ত্রীলোক হয়, তবে তোমার নির্ধারিত মূল্য ত্রিশ শেকল হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","যদি পাঁচ বছর বয়স থেকে কুড়ি বছর বয়স পর্যন্ত হয়, তবে তোমার নির্ধারিত মূল্য পুরুষের পক্ষে কুড়ি শেকল ও স্ত্রীর পক্ষে দশ শেকল হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","যদি এক মাস বয়স থেকে পাঁচ বৎসর বয়স পর্যন্ত হয়, তবে তোমার নির্ধারিত মূল্য পুরুষের পক্ষে পাঁচ শেকল রূপা ও তোমার নির্ধারিত মূল্য স্ত্রীর পক্ষে তিন শেকল রূপা হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","যদি ষাট বছর কিংবা তার বেশী বয়স হয়, তবে তোমার নির্ধারিত মূল্য পুরুষের পক্ষে পনের শেকল ও স্ত্রীর পক্ষে দশ শেকল হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","কিন্তু যদি গরিব হওয়ার জন্য তোমার নির্ধারিত মূল্য দিতে সে না পারে, তবে যাজকের কাছে আনতে হবে এবং যাজক তার মূল্য নির্ধারন করবে; মানতকারী ব্যক্তির ক্ষমতা অনুসারে যাজক তার মূল্য নির্ধারন করবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","আর যদি কেউ সদাপ্রভুর কাছে উৎসর্গের জন্য পশু দান করে, তবে সদাপ্রভুর উদ্দেশ্যে দেওয়া সেরকম সব পশু পবিত্র বস্তু হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","সে তার অন্যথা কি পরিবর্তন করবে না, খারাপের বদলে ভাল, কিংবা ভালর বদলে খারাপ দেবে না; যদি সে কোন প্রকারে পশুর সঙ্গে পশুর বদল করে, তবে তা এবং তার বদলে দুটোই পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","আর যা সদাপ্রভুর উদ্দেশ্যে উপহার হিসাবে উৎসর্গ করা যায় না, এমন কোন অশুচি পশু যদি কেউ দান করে, তবে সে ঐ পশুকে যাজকের সামনে উপস্থিত করবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ঐ পশু ভাল কিংবা খারাপ হোক, যাজক তার মূল্য নির্ধারন করবে; তোমার অর্থাৎ যাজকের নির্ধারন অনুসারেই মূল্য হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","কিন্তু যদি সে কোনো প্রকারে তা মুক্ত করতে চায়, তবে সে তোমার নির্ধারিত মূল্যের পঞ্চমাংশ বেশী দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","আর যদি কোনো ব্যক্তি সদাপ্রভুর উদ্দেশ্যে নিজের গৃহ পবিত্র করে, তবে তা ভাল কিম্বা খারাপ হোক, যাজক তার মূল্য নির্ধারন করবে; যাজক তার যে মূল্য নিরধারণ করবে, তাই ঠিক হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","আর যে তা অর্পণ করেছে, সে যদি নিজের গৃহ মুক্ত করতে চায়, তবে সে তোমার নির্ধারিত মূল্যের পঞ্চমাংশ বেশী দেবে; তা করলে গৃহ তার হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","আর যদি কেউ নিজের অধিকার করা জমির কোন অংশ সদাপ্রভুর উদ্দেশ্যে পবিত্র করে, তবে তার বোনা বীজ অনুসারে তার মূল্য তোমার নির্ধারিত হবে; এক এক হোমর পরিমিত যবের বীজের প্রতি পঞ্চাশ পঞ্চাশ শেকল করে রূপা। ");
INSERT INTO benirv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","যদি সে যোবেল বছর পর্যন্ত নিজের জমি পবিত্র করে, তবে তোমার নির্ধারিত সেই মূল্য অনুসারে তা ঠিক হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","কিন্তু যদি সে যোবেলের পরে নিজের জমি পবিত্র করে, তবে যাজক আগামী যোবেল পর্যন্ত অবশিষ্ট বছরের সংখ্যা অনুসারে তার দেওয়া রূপা গণনা করবে এবং সেই অনুসারে তোমার নির্ধারিত মূল্য কম করা যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","আর যে তা পবিত্র করেছে, সে যদি কোনো প্রকারে নিজের জমি মুক্ত করতে চায়, তবে সে তোমার নির্ধারিত রূপার পঞ্চমাংশ বেশী দিলে তা তারই হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","কিন্তু যদি সে সেই জমি মুক্ত না করে, কিংবা যদি অন্য কারও কাছে সেই জমি বিক্রয় করে, তবে তা আর কখনও মুক্ত হবে না; ");
INSERT INTO benirv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","সেই জমি যোবেল বছরে ক্রেতার হাত থেকে গিয়ে বর্জিত জমির মত সদাপ্রভুর উদ্দেশ্যে পবিত্র হবে, তাতে যাজকেরই অধিকার হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","আর যদি কেউ নিজের পৈতৃক জমি ছেড়ে নিজের কেনা জমি সদাপ্রভুর উদ্দেশ্যে পবিত্র করে, ");
INSERT INTO benirv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","তবে যাজক তোমার নির্ধারিত মূল্য অনুসারে যোবেল বছর পর্যন্ত তার দেওয়া রূপা গণনা করবে, আর সেই দিনের সে তোমার নির্ধারিত মূল্য দেবে; তা সদাপ্রভুর উদ্দেশ্যে পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","যোবেল বছরে সেই জমি বিক্রেতার হাতে, অর্থাৎ সেই জমি যার পৈতৃক অধিকার, তার হাতে ফিরে আসবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","আর তোমার নির্ধারিত সব মূল্য পবিত্র জায়গার শেকল অনুসারে হবে; কুড়ি গেরাতে এক শেকল হয়। ");
INSERT INTO benirv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","কেবল প্রথমজাত পশুর বাচ্চা সব সদাপ্রভুর উদ্দেশ্যে প্রথমজাত হওয়ার জন্য কেউ তা পবিত্র করতে পারবে না; গরু হোক, মেষ হোক, তা সদাপ্রভুর। ");
INSERT INTO benirv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","যদি সেই পশু অশুচি হয়, তবে সে তোমার নির্ধারিত মূল্যের পঞ্চমাংশ বেশী দিয়ে তা মুক্ত করতে পারে, মুক্ত না হলে তা তোমার নির্ধারিত মুল্যে বিক্রি করা যাবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","আর কোনো ব্যক্তি নিজের সর্বস্ব হতে, মানুষ কি পশু কি অধিকার করা জমি হতে, যে কিছু সদাপ্রভুর উদ্দেশ্যে অর্পণ করে, তা বিক্রি করা বা মুক্ত করা যাবে না; সব অর্পিত বস্তু সদাপ্রভুর উদ্দেশ্যে অতি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","মানুষদের মধ্যে যে কেউ বর্জিত হয়, তাকে মুক্ত করা যাবে না; সে অবশ্যই মরবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","জমির শস্য কিংবা গাছের ফল হোক, জমির উত্পন্ন সব জিনিসের দশমাংশ সদাপ্রভুর; তা সদাপ্রভুর উদ্দেশ্যে পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","আর যদি কেউ নিজের দশমাংশ থেকে কিছু মুক্ত করতে চায়, তবে সে তার পাঁচ অংশ বেশী দেবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","আর গরু মেষ পালের দশমাংশ, পাঁচনির নিচ দিয়ে যা কিছু যায়, তার মধ্যে প্রত্যেক দশম পশু সদাপ্রভুর উদ্দেশ্যে পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","তা ভালো কি খারাপ, এর খোঁজ সে করবে না ও তার পরিবর্তন করবে না; কিন্তু যদি সে কোনো প্রকারে তার পরিবর্তন করে, তবে তা ও তার বিনিময়ে দুটোই পবিত্র হবে; তা মুক্ত করা যাবে না।’” ");
INSERT INTO benirv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","সদাপ্রভু সীনয় পাহাড়ে ইস্রায়েল সন্তানদের জন্য মোশিকে এই সব আদেশ করেছিলেন।");
INSERT INTO benirv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","মিশর দেশ থেকে লোকেদের বের হয়ে আসার পর দ্বিতীয় বছরের দ্বিতীয় মাসের প্রথম দিনের সদাপ্রভু সীনয় মরুপ্রান্তে সমাগম তাঁবুতে মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“তোমরা লোকেদের গোষ্ঠী অনুসারে, বংশ অনুসারে, নাম সংখ্যা অনুসারে ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীর, প্রত্যেক পুরুষ, প্রত্যেক লোককে গোন। ");
INSERT INTO benirv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","কুড়ি বছর ও তার বেশি বয়সী যত পুরুষ ইস্রায়েলের মধ্যে যুদ্ধে যাবার যোগ্য, তাদের সৈন্য অনুসারে তুমি ও হারোণ তাদেরকে গণনা কর। ");
INSERT INTO benirv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","আর প্রত্যেক বংশ থেকে একজন করে, একজন গোষ্ঠী প্রধান, তোমাদের সহকারী হবে। ");
INSERT INTO benirv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","আর যে ব্যক্তিরা তোমাদের সহকারী হবে, তাদের নাম হল রূবেণের পক্ষে শদেয়ূরের ছেলে ইলীষূর। ");
INSERT INTO benirv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","শিমিয়োনের পক্ষে সূরীশদ্দয়ের ছেলে শলুমীয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","যিহূদার পক্ষে অম্মীনাদবের ছেলে নহশোন। ");
INSERT INTO benirv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ইষাখরের পক্ষে সূয়ারের ছেলে নথনেল। ");
INSERT INTO benirv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","সবূলূনের পক্ষে হেলোনের ছেলে ইলীয়াব। ");
INSERT INTO benirv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","যোষেফের ছেলেদের মধ্যে ইফ্রয়িমের পক্ষে অম্মীহূদের ছেলে ইলীশামা, মনঃশির পক্ষে পদাহসূরের ছেলে গমলীয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","বিন্যামীনের পক্ষে গিদিয়োনির ছেলে অবীদান। ");
INSERT INTO benirv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","দানের পক্ষে অম্মীশদ্দয়ের ছেলে অহীয়েষর। ");
INSERT INTO benirv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","আশেরের পক্ষে অক্রণের ছেলে পগীয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","গাদের পক্ষে দ্যূয়েলের ছেলে ইলীয়াসফ। ");
INSERT INTO benirv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","নপ্তালির পক্ষে ঐননের ছেলে অহীরঃ।” ");
INSERT INTO benirv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","এরা মণ্ডলীর মনোনীত লোক, তারা তাদের পূর্বপুরুষদের বংশের শাসনকর্ত্তা; তারা ইস্রায়েলের হাজারপতি ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","তখন মোশি ও হারোণ নথিভুক্ত ব্যক্তিদেরকে সঙ্গে নিলেন ");
INSERT INTO benirv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","এবং দ্বিতীয় মাসের প্রথম দিনের সমস্ত মণ্ডলীকে জড়ো করলেন। কুড়ি বছর ও তার থেকে বেশি বয়সী লোকেদের নাম পূর্বপুরুষরা সনাক্ত করেছেন। তাঁকে পূর্বপুরুষের নাম অনুসারে তাদের গোত্র ও পরিবারের নাম ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","এই ভাবে মোশি সদাপ্রভুর আদেশ অনুসারে সীনয় মরুপ্রান্তে তাদেরকে গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ইস্রায়েলের প্রথমজাত যে রূবেণ, তার সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","তাঁরা রূবেণ বংশ থেকে ছেচল্লিশ হাজার পাঁচশো লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","শিমিয়োন সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","তাঁরা শিমিয়োন বংশ থেকে ঊনষষ্টি হাজার তিনশো লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","গাদ সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","তাঁরা গাদ বংশ থেকে পঁয়তাল্লিশ হাজার ছয়শো পঞ্চাশজন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","যিহূদা সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","তাঁরা যিহূদা বংশ থেকে চুয়াত্তর হাজার ছয়শো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ইষাখর সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","তাঁরা ইষাখর বংশ থেকে চুয়ান্ন হাজার চারশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","সবূলূন সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","তাঁরা সবূলূন বংশ থেকে সাতান্ন হাজার চারশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","যোষেফ সন্তানদের মধ্যে ইফ্রয়িম সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ইফ্রয়িম বংশ থেকে চল্লিশ হাজার পাঁচশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","মনঃশি সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","তাঁরা মনঃশি বংশ থেকে বত্রিশ হাজার দুশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","বিন্যামীন সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","তাঁরা বিন্যামীন বংশ থেকে পঁয়ত্রিশ হাজার চারশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","দান সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","তাঁরা দান বংশ থেকে বাষট্টি হাজার সাতশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","আশের সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","তাঁরা আশের বংশ থেকে একচল্লিশ হাজার পাঁচশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","নপ্তালি সন্তানদের গোষ্ঠী ও পরিবার অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের নাম সংখ্যা গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","তাঁরা নপ্তালি বংশ থেকে তিপ্পান্ন হাজার চারশো জন লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","এইসব লোকেদের মোশি ও হারোণের মাধ্যমে এবং ইস্রায়েলের বারোজন শাসনকর্ত্তা অর্থাৎ পরিবারের এক একজন শাসনকর্ত্তার মাধ্যমে গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","সুতরাং কুড়ি বছর ও তার থেকে বেশি বয়সী ইস্রায়েলের মধ্যে থেকে যুদ্ধে যাবার যোগ্য সমস্ত পুরুষের সংখ্যা পরিবার অনুসারে গণনা করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","তাঁরা ছয় লক্ষ তিন হাজার পাঁচশো পঞ্চাশ জন লোকসংখ্যা গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","কিন্তু যে লোকেরা লেবির বংশধর তাদের গণনা করা হল না। ");
INSERT INTO benirv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","কারণ সদাপ্রভু মোশিকে বলেছিলেন, ");
INSERT INTO benirv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“তুমি শুধু লেবি বংশের গণনা কোরো না এবং ইস্রায়েল সন্তানদের মধ্যে তাদের সংখ্যা গ্রহণ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","পরিবর্তে, সাক্ষ্যের সমাগম তাঁবুর দেখাশোনা ও সমাগম তাঁবুর সব দ্রব্য ও তার সমস্ত বিষয়ের দেখাশোনা করার জন্য লেবীয়দেরকে নিযুক্ত কর; অবশ্যই তারা সমাগম তাঁবু বহন করবে ও তারা সমাগম তাঁবুর সমস্ত জিনিসপত্র বহন করবে। তারা অবশ্যই সমাগম তাঁবুর যত্ন নেবে ও তার চারপাশে তাদের শিবির গড়বে। ");
INSERT INTO benirv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","যখন সমাগম তাঁবু অন্য জায়গায় নিয়ে যাবে, অবশ্যই লেবীয়েরা তা ভাঁজ করে নিয়ে যাবে। যখন সমাগম তাঁবু স্থাপন করা হবে, অবশ্যই লেবীয়েরা তা স্থাপন করবে। অন্য কোন লোক সমাগম তাঁবুর কাছে গেলে তার প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","যখন ইস্রায়েল সন্তানেরা তাদের তাঁবু স্থাপন করবে, প্রত্যেক ব্যক্তি তার শিবিরের পতাকার সামনে আসবে। ");
INSERT INTO benirv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","কিন্তু ইস্রায়েল সন্তানদের মণ্ডলীর ওপর যাতে আমার রাগ না হয়, এর জন্য লেবীয়েরা অবশ্যই সাক্ষ্যের সমাগম তাঁবু ঘিরে তাদের তাঁবু স্থাপন করবে। লেবিয়েরা অবশ্যই সাক্ষ্যের সমাগম তাঁবুর দেখাশোনা করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ইস্রায়েল সন্তানরা সেই রকম করল। সদাপ্রভু মোশিকে যা যা আদেশ করেছিলেন, সেই অনুসারে তারা সবই করল। ");
INSERT INTO benirv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ইস্রায়েল সন্তানরা প্রত্যেকে তাদের বংশধরদের চিহ্নের সঙ্গে পতাকার কাছে শিবির করবে; তারা একটু দূরত্ব বজায় রেখে সমাগম তাঁবুর চারদিকে শিবির স্থাপন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","পূর্ব দিকে সূর্য্য উদয়ের দিকে, নিজেদের সৈন্য অনুসারে যিহূদার লোকেরা তাদের শিবিরের পতাকার কাছে একত্রিত হবে এবং অম্মীনাদবের ছেলে নহশোন যিহূদা সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","যিহূদার সৈন্যসংখ্যা চুয়াত্তর হাজার ছয়শো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","তার পাশে ইষাখর বংশ শিবির গড়বে এবং সূয়ারের ছেলে নথনেল ইষাখর সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","নথনেলের সৈন্য সংখ্যা চুয়ান্ন হাজার চারশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","আর সবূলূন বংশ ইষাখরের পাশে শিবির করবে, হেলোনের ছেলে ইলীয়াব সবূলূন সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","সবূলূনের সৈন্য সংখ্যা সাতান্ন হাজার চারশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","যিহূদার শিবিরের মোট গণনা করা সৈন্য সংখ্যা এক লক্ষ ছেয়াশী হাজার চারশো জন। তারা প্রথমে শিবির থেকে এগিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","দক্ষিণ দিকের সৈন্যরা রূবেণের শিবিরের পতাকা ঘিরে থাকবে। শদেয়ূরের ছেলে ইলীষূর রূবেণ সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","রূবেণের সৈন্য সংখ্যা ছেচল্লিশ হাজার পাঁচশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","তার পাশে শিমিয়োন বংশ শিবির গড়বে। সূরীশদ্দয়ের ছেলে শলুমীয়েল শিমিয়োনের সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","শিমিয়োনের সৈন্য সংখ্যা ঊনষষ্টি হাজার তিনশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","গাদ বংশও তার পাশে থাকবে। দ্যুয়েলের ছেলে ইলীয়াসফ গাদ সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","গাদের সৈন্য সংখ্যা পঁয়তাল্লিশ হাজার ছয়শো পঞ্চাশ জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","রূবেণের শিবিরের গণনা করা মোট সৈন্য সংখ্যা এক লক্ষ একান্ন হাজার চারশো পঞ্চাশ জন। তারা শিবির থেকে দ্বিতীয় বারে এগিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","তারপরে সমাগম তাঁবু লেবীয়দের শিবিরের সঙ্গে সমস্ত শিবিরের মধ্যবর্ত্তী হয়ে এগিয়ে যাবে। যারা যেমন শিবিরে জড়ো হয়, তারা তেমন ভাবে নিজের জায়গায় নিজের পতাকার পাশে পাশে চলবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ইফ্রয়িমের সৈন্যরা পশ্চিম পাশে শিবির গড়বে। অম্মীহূদের ছেলে ইলীশামা ইফ্রয়িম সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ইফ্রয়িমের সৈন্য সংখ্যা চল্লিশ হাজার পাঁচশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","তাদের পাশে মনঃশি বংশ থাকবে। পদাহসূরের ছেলে গমলীয়েল মনঃশি সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","মনঃশির সৈন্য সংখ্যা বত্রিশ হাজার দুশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","আর বিন্যামীন বংশ তার পাশে থাকবে। গিদিয়োনির ছেলে অবীদান বিন্যামীন সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","বিন্যামীনের সৈন্য সংখ্যা পঁয়ত্রিশ হাজার চারশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ইফ্রয়িমের শিবিরের মোট গণনা করা সৈন্য সংখ্যা এক লক্ষ আট হাজার একশো জন। তারা তৃতীয় বারে এগিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","দানের সৈন্যদের সমাগম তাঁবুর উত্তর পাশে শিবিরের পতাকা থাকবে। অম্মীশদ্দয়ের ছেলে অহীয়েষর দান সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","দানের সৈন্য সংখ্যা বাষট্টি হাজার সাতশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","তাদের পাশে আশের বংশ শিবির গড়বে। অক্রণের ছেলে পগীয়েল আশের সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","আশেরের সৈন্য সংখ্যা একচল্লিশ হাজার পাঁচশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","নপ্তালি বংশ তার পাশে থাকবে। ঐননের ছেলে অহীরঃ নপ্তালি সন্তানদের নেতা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","নপ্তালির সৈন্য সংখ্যা তিপ্পান্ন হাজার চারশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","দানের শিবিরের মোট লোক সংখ্যা এক লক্ষ সাতান্ন হাজার ছয়শো জন। তারা তাদের পতাকা নিয়ে শিবির থেকে শেষে এগিয়ে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","মোশি ও হারোণ ইস্রায়েল সন্তানদের পিতৃকুল অনুসারে ছয় লক্ষ তিন হাজার সাড়ে পাঁচশো জন সৈন্য সংখ্যা গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","কিন্তু মোশি ও হারোণ লেবীয়দের ইস্রায়েল সন্তানদের মধ্যে গণনা করলেন না। যেমন সদাপ্রভু মোশিকে আদেশ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ইস্রায়েল সন্তানরা মোশিকে দেওয়া সদাপ্রভুর সমস্ত আদেশ অনুসারে কাজ করত। তারা পতাকার কাছে শিবির গড়তো। তারা তাদের বংশ অনুসারে শিবির থেকে গোষ্ঠী ও পরিবার অনুসারে শিবিরের কাছে একত্রিত হত ও যাত্রা করত। ");
INSERT INTO benirv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","সীনয় পর্বতে যে দিন সদাপ্রভু মোশির সঙ্গে কথা বললেন, এটা সেই দিন হারোণের ও মোশির বংশাবলির ইতিহাস। ");
INSERT INTO benirv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","হারোণের ছেলেদের নাম ছিল; প্রথমজাত নাদব, অবীহূ, ইলীয়াসর ও ঈথামর। ");
INSERT INTO benirv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","এই হল হারোণের ছেলেদের নাম, অভিষিক্ত যাজক, যাজক হিসাবে সেবা করার জন্য যাদেরকে নিযুক্ত করা হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","কিন্তু নাদব ও অবীহূ সীনয় মরুপ্রান্তে সদাপ্রভুর উদ্দেশ্যে ইতর আগুন নিবেদন করার জন্য সদাপ্রভুর সামনে প্রাণত্যাগ করেছিল; তাদের সন্তান ছিল না; আর ইলীয়াসর ও ঈথামর তাদের বাবা হারোণের সাক্ষাৎে যাজকের কাজ করত। ");
INSERT INTO benirv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“তুমি লেবি বংশকে এনে হারোণ যাজকের সামনে উপস্থিত কর; তারা তাকে সাহায্য করবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","তারা সমাগম তাঁবুর সামনে হারোণের ও সমস্ত মণ্ডলীর হয়ে কাজ করবে। তারা সমাগম তাঁবুর দেখাশোনা করবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","তারা সমাগম তাঁবুর সব জিনিস পত্রের দেখাশোনা করবে এবং সমাগম তাঁবুর সমস্ত দ্রব্য বহনের কাজে ইস্রায়েল সন্তানদের সাহায্য করবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","তুমি লেবীয়দেরকে হারোণের ও তার ছেলেদের হাতে দান করবে; তারা তাকে ইস্রায়েল সন্তানদের পরিচর্য্যা করতে সাহায্য করবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","তুমি হারোণ ও তার ছেলেদেরকে নিযুক্ত করবে এবং তারা তাদের যাজকের পদ রক্ষা করবে, অন্য গোষ্ঠীর যে কেউ কাছাকাছি আসবে, তার প্রাণদণ্ড হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“দেখ, ইস্রায়েল সন্তানদের মধ্যে গর্ভজাত সমস্ত প্রথমজাতের পরিবর্তে আমি ইস্রায়েল সন্তানদের মধ্যে থেকে লেবীয়দেরকে গ্রহণ করলাম; অতএব লেবীয়েরা আমারই হবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","প্রথমজাত সবাই আমার; যে দিন আমি মিশর দেশে সমস্ত প্রথমজাতকে আঘাত করি, সেই দিন মানুষ থেকে পশু পর্যন্ত ইস্রায়েলের সমস্ত প্রথমজাতকে আমার উদ্দেশ্যে পবিত্র করেছি; তারা আমারই হবে; আমি সদাপ্রভু।” ");
INSERT INTO benirv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","আর সীনয় মরুপ্রান্তে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“তুমি লেবির সন্তানদের তাদের পিতৃকুল অনুসারে ও গোষ্ঠী অনুসারে গণনা কর; এক মাস ও তার থেকে বেশি বয়সী সমস্ত পুরুষকেই গণনা কর।” ");
INSERT INTO benirv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","তখন মোশি যেমন আদেশ পেলেন, তেমনি সদাপ্রভুর আদেশ অনুসারে তাদেরকে গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","লেবির সন্তানদের নাম গের্শোন, কহাৎ ও মরারি। ");
INSERT INTO benirv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","গের্শোনের সন্তানদের তাদের নাম লিব্‌নি ও শিমিয়ি। ");
INSERT INTO benirv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","কহাতের সন্তানদের নাম অম্রাম, যিষ্‌হর, হিব্রোণ ও উষীয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","মরারির সন্তানদের নাম মহলি ও মূশি। এরা সবাই পিতৃকুল অনুসারে লেবীয়দের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","গের্শোন থেকে লিব্‌নি-গোষ্ঠী ও শিমিয়ি-গোষ্ঠী উৎপন্ন হল; এরা গের্শোনীয়দের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","একমাস ও তার থেকে বেশি বয়সী সমস্ত পুরুষকে গণনা করলে এদের লোক সংখ্যা সাত হাজার পাঁচশো জন হল। ");
INSERT INTO benirv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","গের্শোনীয়দের গোষ্ঠীর সবাই পশ্চিমদিকে সমাগম তাঁবুর পিছনের দিকে শিবির করত। ");
INSERT INTO benirv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","লায়েলের ছেলে ইলীয়াসফ গের্শোনীয়দের পিতৃকুলের শাসনকর্ত্তা ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","গের্শোনের সন্তানরা সমাগম তাঁবুর পর্দার বাইরের আবরণের যত্ন নেবে। তারা অবশ্যই তাঁবু, তাঁবুর আবরণ, সমাগম তাঁবুর প্রবেশপথের পর্দার যত্ন নেবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","তারা অবশ্যই উঠানের পর্দা, উঠানের প্রবেশপথের পর্দার যত্ন নেবে-বেদি ও পবিত্রস্থানের চারদিকে যে উঠান। তারা সমাগম তাঁবুর দড়ি এবং তার সমস্ত জিনিসের যত্ন নেবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","কহাৎ থেকে অম্রামীয় গোষ্ঠী, যিষ্‌হরীয় গোষ্ঠী, হিব্রোণীয় গোষ্ঠী ও উষীয়েলীর গোষ্ঠী উৎপন্ন হল; এরা কহাতীয়দের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","একমাস ও তার থেকে বেশি বয়সী সমস্ত পুরুষের সংখ্যা অনুসারে এরা আট হাজার ছয়শো জন, এরা পবিত্র স্থানের রক্ষাকারী। ");
INSERT INTO benirv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","কহাতের সন্তানদের গোষ্ঠীর সবাই সমাগম তাঁবুর দক্ষিণদিকে শিবির করত। ");
INSERT INTO benirv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","উষীয়েলের ছেলে ইলীষাফণ কহাতীয় গোষ্ঠীর সবার পিতৃকুলের শাসনকর্ত্তা ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","তারা সিন্দুক, টেবিল, বাতিদানী, দুটি বেদি, পবিত্র স্থানের পরিচর্য্যার সমস্ত পাত্রের যত্ন নিত। তারা অবশ্যই পবিত্রস্থান, পবিত্রস্থানের পর্দা এবং পবিত্রস্থানের সমস্ত কিছুর যত্ন নিত। ");
INSERT INTO benirv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","হারোণ যাজকের ছেলে ইলীয়াসর লেবীয়দের শাসনকর্ত্তাদের অধ্যক্ষ ছিলেন। তিনি পবিত্রস্থানের রক্ষাকারীদের উপরে তদারকি করতেন। ");
INSERT INTO benirv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","মরারি থেকে মহলীয় গোষ্ঠী ও মূশীয় গোষ্ঠী উৎপন্ন হল; এরা মরারীয়দের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","একমাস ও তার থেকে বেশি বয়সী সমস্ত পুরুষ গণনা করলে এদের লোক সংখ্যা ছয় হাজার দুশো জন হল। ");
INSERT INTO benirv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","অবীহয়িলের ছেলে সূরীয়েল মরারি গোষ্ঠীর সবার পিতৃকুলের শাসনকর্ত্তা ছিলেন; তারা সমাগম তাঁবুর উত্তরদিকে শিবির করত। ");
INSERT INTO benirv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","মরারির সন্তানরা সমাগম তাঁবুর তক্তা, অর্গল, স্তম্ভ, ভিত্তি ও তার সমস্ত দ্রব্য এবং তার সঙ্গে যুক্ত সমস্ত কাজে ");
INSERT INTO benirv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","উঠানের চারিদিকের স্তম্ভ ও তাদের ভিত্তি, গোঁজ ও দড়ির দেখাশোনা করত। ");
INSERT INTO benirv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","সমাগম তাঁবুর সামনে, পূর্ব দিকে, সূর্য্যোদয়ের দিকে, মোশি, হারোণ ও তার ছেলেরা অবশ্যই শিবির স্থাপন করবে, ইস্রায়েল সন্তানদের পক্ষ থেকে মহাপবিত্র স্থানের বিষয়ে তারা দায়ী থাকবে। কোনো বিদেশী তার কাছাকাছি এলে, তার মৃত্যুদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","মোশি ও হারোণ সদাপ্রভুর আদেশ অনুসারে লেবীয়দিগকে নিজেদের গোষ্ঠী অনুসারে গণনা করলে তাদের সংখ্যা একমাস ও তার থেকে বেশি বয়সী পুরুষ মোট বাইশ হাজার জন হল। ");
INSERT INTO benirv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","সদাপ্রভু মোশিকে বললেন, “তুমি ইস্রায়েল সন্তানদের মধ্যে একমাস ও তার থেকে বেশি বয়সী প্রথমজাত সমস্ত পুরুষকে গণনা কর ও তাদের নামের সংখ্যা গ্রহণ কর। ");
INSERT INTO benirv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","আমি সদাপ্রভু, আমারই অধিকারে তুমি ইস্রায়েল সন্তানদের সমস্ত প্রথমজাতের পরিবর্তে লেবীয়দেরকে এবং ইস্রায়েল সন্তানদের সমস্ত প্রথমজাত পশুর পরিবর্তে লেবীয়দের পশুধন গ্রহণ কর।” ");
INSERT INTO benirv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","তাতে মোশি সদাপ্রভুর আদেশ অনুসারে ইস্রায়েল সন্তানদের সমস্ত প্রথমজাতকে গণনা করলেন; ");
INSERT INTO benirv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","তাদের একমাস ও তার থেকে বেশি বয়সী সমস্ত প্রথমজাত পুরুষ নাম সংখ্যা অনুসারে বাইশ হাজার দুশো তিয়াত্তর জন হল। ");
INSERT INTO benirv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“তুমি ইস্রায়েল সন্তানদের সমস্ত প্রথমজাতের পরিবর্তে লেবীয়দেরকে ও তাদের পশুধনের পরিবর্তে লেবীয়দের পশুধন গ্রহণ কর; লেবীয়েরা আমারই হবে; আমি সদাপ্রভু। ");
INSERT INTO benirv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ইস্রায়েল সন্তানদের মধ্যে লেবীয়দের সংখ্যার যে অতিরিক্ত দুইশো তিয়াত্তর জন প্রথমজাত লোক, ");
INSERT INTO benirv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","তাদের এক এক জনের জন্য পবিত্রস্থানের শেকল অনুসারে পাঁচ শেকল করে নেবে; কুড়ি গেরাতে এক শেকল হয়। ");
INSERT INTO benirv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","তাদের সংখ্যা অতিরিক্ত সেই প্রথমজাত লোকদের রূপার মূল্য তুমি হারোণ ও তার ছেলেদেরকে দেবে।” ");
INSERT INTO benirv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","তাতে লেবীয়দের মাধ্যমে মুক্ত লোক ছাড়া যারা অবশিষ্ট থাকল, তাদের মুক্তির মূল্য মোশি নিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","তিনি ইস্রায়েল সন্তানদের প্রথমজাত লোক থেকে পবিত্রস্থানের শেকলের পরিমাণে এক হাজার তিনশো পঁয়ষট্টি শেকল রূপা নিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","সদাপ্রভুর বাক্য অনুসারে মোশি সেই মুক্ত লোকেদের রূপা নিয়ে হারোণ ও তাঁর ছেলেদেরকে দিলেন; যেমন সদাপ্রভু মোশিকে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“তোমরা লেবির সন্তানদের মধ্যে নিজেদের গোষ্ঠী ও পিতৃকুল অনুসারে কহাতের সন্তানদের জনগণনার পরিচালনা করবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ত্রিশ বছর বয়সী থেকে পঞ্চাশ বছর বয়সী পর্যন্ত যত লোক সমাগম তাঁবুতে কর্মচারীদের শ্রেণীভুক্ত হয়, তাদেরকে গণনা কর। ");
INSERT INTO benirv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","সমাগম তাঁবুতে কহাতের সন্তানদের সেবা কাজ অতি পবিত্রস্থান সংক্রান্ত। ");
INSERT INTO benirv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","যখন শিবির এগিয়ে যাবে, তখন হারোণ ও তার ছেলেরা ভিতরে যাবে এবং পর্দা নামিয়ে সেটা দিয়ে পবিত্রস্থান থেকে মহাপবিত্রস্থানকে আলাদা করবে এবং সাক্ষ্য সিন্দুক ঢাকা দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","তার উপরে শীলের চামড়ায় ঢেকে দেবে ও তার উপরে সম্পূর্ণ নীল রঙের একটি বস্ত্র পাতবে এবং তার বহন-দন্ড পরাবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","তারা দর্শন-রুটির টেবিলের উপরে একটি নীল রঙের বস্ত্র পাতবে ও তার উপরে থালা, চামচ, সেকপাত্র ও ঢালবার জন্য পাত্রগুলি রাখবে এবং টেবিলের উপর সর্বদা রুটি রাখবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","তারা সব কিছুর উপরে একটি লাল রঙের বস্ত্র এবং শুশুকের চামড়া দিয়ে ঢেকে দেবে। তারা টেবিলে বহন-দন্ড পরাবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","তারা একটি নীল রঙের বস্ত্র নিয়ে বাতিদানী, তার বাতিগুলি, চিমটি এবং ট্রে ও সমস্ত তেলের পাত্র ঢেকে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","তারা বাতিদান এবং তার সমস্ত পাত্র শীলের চামড়ায় ঢেকে দিয়ে বয়ে নিয়ে যাবার পাটাতনের উপরে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","তারা সোনার বেদির উপরে নীল রঙের বস্ত্র পেতে তার উপরে শুশুকের চামড়ায় ঢেকে দেবে এবং তার বহন-দন্ড পরাবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","তারা পবিত্রস্থানের পরিচর্য্যার জন্য সমস্ত পাত্র নিয়ে নীল রঙের বস্ত্রের মধ্যে রাখবে এবং শুশুকের চামড়া দিয়ে তা ঢেকে দন্ডের উপরে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","তারা বেদি থেকে ছাই ফেলে তার উপরে বেগুনী রঙের বস্ত্র পাতবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","তারা পাটাতনের উপরে বেদির পরিচর্য্যার জন্য সমস্ত পাত্র, আগুন রাখার পাত্র, তিনটি কাঁটাযুক্ত দন্ড, হাতা ও বাটি, বেদির সমস্ত পাত্র রাখবে; আর তারা তার উপরে শুশুকের চামড়া দিয়ে ঢেকে দেবে এবং তার বহন দণ্ড পরাবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","এই ভাবে শিবিরের এগিয়ে যাবার দিনের হারোণ ও তার ছেলেরা পবিত্রস্থান ও পবিত্রস্থানের সমস্ত পাত্রে ঢাকা দেওয়া শেষ করার পর কহাতের সন্তানরা তা বহন করতে আসবে; কিন্তু তারা পবিত্র বস্তু স্পর্শ করবে না, পাছে তাদের মৃত্যু হয়। সমাগম তাঁবুতে এইসব কিছু বয়ে নিয়ে যাওয়াই কহাতের সন্তানদের কাজ হবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","দীপের তেল ও ধূপের জন্য সুগন্ধি দ্রব্য, নিত্য ভক্ষ্য নৈবেদ্য ও অভিষেকের তেলের দেখাশোনা করা, সমস্ত সমাগম তাঁবু এবং যা কিছু তার মধ্যে আছে, পবিত্রস্থান ও তার সমস্ত দ্রব্যের দেখাশোনা করা হারোণের ছেলে ইলীয়াসর যাজকের কাজ হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“তোমরা লেবীয়দের মধ্যে থেকে কহাতীয় সমস্ত গোষ্ঠীর বংশকে উচ্ছেদ কোরো না। ");
INSERT INTO benirv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","কিন্তু যখন তারা অতি পবিত্র বস্তুর কাছাকাছি আসে, তখন যেন তারা বেঁচে থাকে, মারা না যায়, এই জন্য তোমরা তাদের প্রতি এইরকম কোরো; হারোণ ও তার ছেলেরা ভিতরে যাবে এবং তাদের প্রত্যেক জনকে নিজেদের সেবা কাজ ও ভার বহনে নিযুক্ত করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","কিন্তু তারা এক বারের জন্যও পবিত্র বস্তু দেখতে ভিতরে যাবে না, না হলে তারা মারা পড়ে। ");
INSERT INTO benirv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","তুমি গের্শোন সন্তানদের পিতৃকুল ও গোষ্ঠী অনুসারে তাদেরও সংখ্যা গ্রহণ কর। ");
INSERT INTO benirv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ত্রিশ বছর বয়সী থেকে পঞ্চাশ বছর বয়সী পর্যন্ত যারা সমাগম তাঁবুতে সেবা কাজ করার শ্রেণীভুক্ত হয়, তাদেরকে গণনা কর। ");
INSERT INTO benirv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","সেবা কাজের ও ভার বহনের মধ্যে গের্শোনীয় গোষ্ঠীদের সেবা কাজ এইগুলি। ");
INSERT INTO benirv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","তারা সমাগম তাঁবুর পর্দা, সমাগম তাঁবু, তাঁবুর আবরণ, তার উপরের শীলের চামড়ার আচ্ছাদন, সমাগম তাঁবুর ফটকের আচ্ছাদন বস্ত্র বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","তারা উঠানের সমস্ত পর্দা, উঠানের দরজার পর্দা, যেটা সমাগম তাঁবু ও বেদির কাছাকাছি, তার রশি ও সেবার জন্য সমস্ত জিনিস পত্র বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","হারোণের ও তার ছেলেদের আদেশ অনুসারে গের্শোন সন্তানরা নিজেদের ভার বহন ও সমস্ত সেবা কাজ করবে। তোমরা সমস্ত ভার বহন করার কাজে তাদের নিযুক্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","সমাগম তাঁবুতে এটাই গের্শোন গোষ্ঠীর সন্তানদের সেবা কাজ। হারোণ যাজকের ছেলে ঈথামর তাদের কাজে নেতৃত্ব দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","তুমি মরারি সন্তানদের গোষ্ঠী ও পিতৃকুল অনুসারে তাদেরকে গণনা কর। ");
INSERT INTO benirv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ত্রিশ বছর বয়সী থেকে পঞ্চাশ বছর বয়সী পর্যন্ত যারা সমাগম তাঁবুতে সেবা কাজ করার জন্য শ্রেণীভুক্ত হয়, তাদেরকে গণনা কর। ");
INSERT INTO benirv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","সমাগম তাঁবুতে এই সমস্ত ভার বহন করাই তাদের সেবা কাজ হবে। সমাগম তাঁবুর পাটাতন, তক্তা, স্তম্ভ, ভিত্তি, ");
INSERT INTO benirv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","সমাগম তাঁবু ঘেরা উঠানের স্তম্ভ, সে সকলের অর্গল, স্তম্ভ ও চূঙ্গি এবং প্রাঙ্গণের চতুর্দ্দিক্‌স্থিত স্তম্ভ সকল, সে সকলের ভিত্তি, গোঁজ, রশি, তার সঙ্গে তাদের হাতের কাজ। বয়ে নিয়ে যাওয়া সমস্ত দ্রব্য তাদের নামে গণনা করবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","এগুলি মরারি গোষ্ঠীর সন্তানদের সেবা কাজ; সমাগম তাঁবুতে তারা যা কাজ করবে সেগুলি হারোণ যাজকের ছেলে ঈথামরের নির্দেশ অনুযায়ী হবে। ");
INSERT INTO benirv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","মোশি, হারোণ ও মণ্ডলীর শাসনকর্তারা, গোষ্ঠী ও পিতৃকুল অনুসারে কহাতীয় সন্তানদের গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","তাঁরা ত্রিশ বছর বয়সী থেকে পঞ্চাশ বছর বয়সী পর্যন্ত যারা সমাগম তাঁবুতে সেবা কাজ করার জন্য শ্রেণীভুক্ত হল, তাদেরকে গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","তারা তাদের গোষ্ঠী অনুসারে দুই হাজার সাতশো পঞ্চাশ জন লোক গণনা করল। ");
INSERT INTO benirv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","মোশিকে দেওয়া সদাপ্রভুর আদেশ অনুসারে মোশি ও হারোণ কহাতীয় গোষ্ঠী অনুসারে সমাগম তাঁবুতে সেবা কাজে নিযুক্ত লোক গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","আর গের্শোন সন্তানদের মধ্যে যাদেরকে তাদের গোষ্ঠী ও পিতৃকুল অনুসারে গণনা করা হল, ");
INSERT INTO benirv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ত্রিশ বছর বয়সী থেকে পঞ্চাশ বছর বয়সী পর্যন্ত যারা সমাগম তাঁবুতে সেবা কাজ করার জন্য শ্রেণীভুক্ত হল। ");
INSERT INTO benirv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","তাদের গোষ্ঠী ও পিতৃকুল অনুসারে গণনা করলে দুই হাজার ছয়শো ত্রিশ জন হল। ");
INSERT INTO benirv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","মোশি ও হারোণ সদাপ্রভুর আদেশ অনুসারে সমাগম তাঁবুতে সেবা কাজে নিযুক্ত গের্শোন গোষ্ঠীর সন্তানদের গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","মরারি গোষ্ঠীর সন্তানদের মধ্যে যাদের গোষ্ঠী ও পিতৃকুল অনুসারে গণনা করা হল, ");
INSERT INTO benirv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ত্রিশ বছর বয়সী থেকে পঞ্চাশ বছর বয়সী পর্যন্ত যারা সমাগম তাঁবুতে সেবা কাজের জন্য শ্রেণীভুক্ত হল, ");
INSERT INTO benirv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","তাদের গোষ্ঠী ও পিতৃকুল অনুসারে গণনা করলে তিন হাজার দুশো জন হল। ");
INSERT INTO benirv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","মোশিকে দেওয়া সদাপ্রভুর আদেশ অনুসারে মোশি ও হারোণ মরারি গোষ্ঠীর সন্তানদের গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","এই ভাবে মোশি, হারোণ ও ইস্রায়েলের শাসনকর্ত্তাদের নেতৃত্বে যে লেবীয়দের নিজেদের গোষ্ঠী ও পিতৃকুল অনুসারে গণনা করা হল, ");
INSERT INTO benirv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ত্রিশ বছর বয়সী থেকে পঞ্চাশ বছর বয়সী পর্যন্ত যারা সমাগম তাঁবুতে সেবা কাজের ও ভার বয়ে নিয়ে যাবার কাজ করতে প্রবেশ করত, ");
INSERT INTO benirv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","তারা আট হাজার পাঁচশো আশী জন হল। ");
INSERT INTO benirv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","সদাপ্রভুর আদেশ অনুসারেই তাদের সবাইকে মোশির মাধ্যমে নিজেদের সেবা কাজ ও ভার বয়ে নিয়ে যাবার জন্য গণনা করা হল; এই ভাবে মোশিকে দেওয়া সদাপ্রভুর আদেশ অনুসারে তাদের তাঁর মাধ্যমে গণনা হল। ");
INSERT INTO benirv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“তুমি ইস্রায়েল সন্তানদের আদেশ কর, যেন তারা প্রত্যেক কুষ্ঠীকে, প্রত্যেক প্রমেহীকে ও মৃত ব্যক্তির মাধ্যমে অশুচি প্রত্যেক জনকে শিবির থেকে বের করে দেয়। ");
INSERT INTO benirv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","তোমরা পুরুষ ও স্ত্রীলোককে বের কর, তাদেরকে শিবির থেকে বের কর। তাদের যে শিবিরের মধ্যে আমি বাস করি, তারা তা অশুচি না করুক।” ");
INSERT INTO benirv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","তখন ইস্রায়েল সন্তানরা সেই রকম কাজ করল, তাদেরকে শিবির থেকে বের করে দিল; সদাপ্রভু মোশিকে যেমন বলেছিলেন, ইস্রায়েল সন্তানরা সেই রকম করল। ");
INSERT INTO benirv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“তুমি ইস্রায়েল সন্তানদের বল, ‘পুরুষ কিংবা স্ত্রী হোক, একজন আর একজন মানুষের সাথে যেভাবে পাপ করে যখন কেউ সেরকম করে সদাপ্রভুর আদেশ অমান্য করে, আর সেই ব্যক্তি দণ্ডনীয় হয়, তখন সে যে পাপ করেছে, ");
INSERT INTO benirv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","সেটা স্বীকার করবে ও নিজের দোষের জন্য মূল্য ও তার পঞ্চমাংশের এক অংশের বেশি, যার বিরুদ্ধে দোষ করেছে, তাকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","কিন্তু যাকে দোষের পরিশোধ দেওয়া হবে, এমন মুক্তিকর্তা জ্ঞাতি যদি তার না থাকে, তবে দোষের পরিশোধ সদাপ্রভুর উদ্দেশ্যে যাজককে দিতে হবে; তাছাড়া যার মাধ্যমে তার প্রায়শ্চিত্ত হয়, সেই প্রায়শ্চিত্তের ভেড়াও দিতে হবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ইস্রায়েল সন্তানরা তাদের পবিত্র বস্তুর মধ্যে যত উপহার যাজকের কাছে আনে, সেই সব কিছু তার হবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","যে কেউ পবিত্র বস্তু দেয়, তা তারই হবে; কোন ব্যক্তি যে কোন বস্তু যাজককে দেয়, তা তার হবে’।” ");
INSERT INTO benirv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","আর আবার সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“তুমি ইস্রায়েল সন্তানদের বল, তাদেরকে বল, কোন ব্যক্তির স্ত্রী যদি বিপথগামিনী হয়ে তার বিরুদ্ধে পাপ করে, ");
INSERT INTO benirv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","সে যদি স্বামীর চোখের আড়ালে কোন পুরুষের সঙ্গে সম্পর্ক করে গোপনে অশুচি হয় ও তার বিপক্ষে কোন সাক্ষী না থাকে ও সে ধরা না পড়ে ");
INSERT INTO benirv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","এবং স্ত্রী অশুচি হলে স্বামী যদি ঈর্ষান্বিত হয়; অথবা স্ত্রী অশুচি না হলেও যদি সে মিথ্যা ভাবে ঈর্ষান্বিত হয়; ");
INSERT INTO benirv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","তবে সেই স্বামী তার স্ত্রীকে যাজকের কাছে আনবে এবং তার জন্য উপহার, অর্থাৎ এক ঐফার দশমাংশ যবের সূজি আনবে, কিন্তু তার উপরে তেল ঢালবে না ও কুন্দুরু দেবে না; কারণ তা ঈর্ষান্বিতর ভক্ষ্য নৈবেদ্য, স্মরণের ভক্ষ্য নৈবেদ্য, যার মাধ্যমে অপরাধ স্মরণ হয়। ");
INSERT INTO benirv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","যাজক সেই স্ত্রীকে নিয়ে সদাপ্রভুর সামনে উপস্থিত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","যাজক মাটির পাত্রে পবিত্র জল রেখে সমাগম তাঁবুর মেঝের কিছুটা ধূলো নিয়ে সেই জলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","যাজক সেই স্ত্রীকে সদাপ্রভুর সামনে উপস্থিত করবে ও তার মাথার চুল খুলে দিয়ে ঐ স্মরণের ভক্ষ্য নৈবেদ্য, অর্থাৎ ঈর্ষান্বিতর, তার হাতে দেবে এবং যাজকের হাতে অভিশাপজনক তেতো জল থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","যাজক ঐ স্ত্রীকে শপথ করে বলবে, কোন পুরুষ যদি তোমার সঙ্গে না শুয়ে থাকে এবং তুমি নিজের স্বামীর অধীনে থাক ও যদি বিপথগামী কোন অশুচি কাজ না করে থাক, তবে এই অভিশাপজনক তেতো জল তোমার ওপর না কাজ করুক। ");
INSERT INTO benirv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","কিন্তু তুমি নিজের স্বামীর অধীনে হয়েও যদি বিপথগামী হয়ে থাক, যদি অশুচি কাজ করে থাক ও তোমার স্বামী ছাড়া অন্য কোন পুরুষ যদি তোমার সঙ্গে শুয়ে থাকে,” ");
INSERT INTO benirv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","তবে যাজক সেই স্ত্রীকে অভিশাপজনক শপথ করাবে ও যাজক সেই স্ত্রীকে বলবে, সদাপ্রভু তোমার ঊরু অবশ ও তোমার পেট বড় করে তোমার লোকেদের মধ্যে তোমাকে শাপের ও অপবাদের পাত্রী করবেন; ");
INSERT INTO benirv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","এই অভিশাপজনক জল তোমার পেটের মধ্যে গিয়ে তোমার পেট বড় ও ঊরু অবশ করবে। তখন সেই স্ত্রী বলবে, আমেন, আমেন। ");
INSERT INTO benirv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","যাজক সেই অভিশাপের কথা বইয়ে লিখে ঐ তেতো জলে মুছে ফেলবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","সেই অভিশাপজনক তেতো জল ঐ স্ত্রীকে পান করাবে; তাতে সেই অভিশাপজনক তেতো জল পান করাবে যেটা তার অভিশাপ স্বরূপ হবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","যাজক ঐ স্ত্রীর হাত থেকে সে ঈর্ষান্বিতর ভক্ষ্য নৈবেদ্য নেবে এবং সেই ভক্ষ্য নৈবেদ্য সদাপ্রভুর সামনে দেখিয়ে বেদির উপরে উপস্থিত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","যাজক সেটার স্মরণে সেই ভক্ষ্য নৈবেদ্যের এক মুঠো নিয়ে বেদির উপরে পোড়াবে, তারপরে ঐ স্ত্রীকে সেই জল পান করাবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","যখন সেই স্ত্রীকে জল পান করাবে, সে যদি তার স্বামীর বিরুদ্ধে পাপ করে অশুচি হয়ে থাকে, তবে সেই অভিশাপজনক জল তার মধ্যে তেতো হয়ে প্রবেশ করবে এবং তার পেট বড় ও ঊরু অবশ হয়ে পড়বে; এই ভাবে সেই স্ত্রী তার লোকেদের মধ্যে অভিশপ্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","কিন্তু যদি সেই স্ত্রী অশুচি না হয়ে শুচি থাকে, তবে সে মুক্ত হবে ও সন্তানের জন্ম দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","এটা ঈর্ষান্বিত বিষয়ের ব্যবস্থা; স্ত্রীলোক স্বামীর অধীনা থেকেও বিপথে গিয়ে অশুচি হলে, ");
INSERT INTO benirv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","কিংবা স্বামী ঈর্ষান্বিত আত্মার মাধ্যমে তার স্ত্রীর প্রতি ঈর্ষান্বিত হলে সে সেই স্ত্রীকে সদাপ্রভুর সামনে উপস্থিত করবে এবং যাজক সেই বিষয়ে এই সমস্ত ব্যবস্থা পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","তাতে স্বামী যাজকের কাছে তার স্ত্রীকে এনে অপরাধ থেকে মুক্ত হবে এবং সেই স্ত্রী তার অপরাধ বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“তুমি ইস্রায়েল সন্তানদের বল, তাদেরকে বল, ‘কোন পুরুষ কিংবা স্ত্রীলোক সদাপ্রভুর উদ্দেশ্যে আলাদা হবার জন্য যখন বিশেষ ব্রত, নাসরীয় ব্রত, করবে, ");
INSERT INTO benirv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","তখন সে আঙ্গুর রস ও সুরা থেকে নিজেকে আলাদা রাখবে, আঙ্গুর রসের সিরকা বা সুরার সিরকা পান করবে না এবং আঙ্গুর ফল থেকে উৎপন্ন কোন পানীয় পান করবে না, আর কাঁচা কিংবা শুকনো আঙ্গুর ফল খাবে না। ");
INSERT INTO benirv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","যতদিন সে আমার উদ্দেশ্যে আলাদা থাকবে, সে বীজ থেকে ত্বক পর্যন্ত আঙ্গুর ফল দিয়ে তৈরী কিছুই খাবে না। ");
INSERT INTO benirv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","তার আলাদা থাকার ব্রতের সমস্ত কাল তার মাথায় ক্ষুর স্পর্শ করবে না; সদাপ্রভুর উদ্দেশ্যে তার আলাদা থাকার দিন সংখ্যা যতদিন না সম্পূর্ণ হয়, ততদিন সে পবিত্র থাকবে, সে তার মাথার চুল বড় করবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","সে যতদিন সদাপ্রভুর উদ্দেশ্যে আলাদা থাকে, ততদিন কোন মৃতদেহের কাছে যাবে না। ");
INSERT INTO benirv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","যদিও তার বাবা, মা, ভাই, বোন মারা যায়, তবুও সে তাদের জন্য নিজেকে অশুচি করবে না; প্রত্যেকে তার লন্বা চুল দেখতে পাবে, কারণ সে ঈশ্বরের উদ্দেশ্যে আলাদা হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","তার আলাদা থাকার সমস্ত কাল সে সদাপ্রভুর উদ্দেশ্যে পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","আর যদি কোন মানুষ হঠাৎ তার কাছাকাছি মারা যায় তবে সেই আলাদা থাকা ব্যক্তি অশুচি হয়, তাই সে শুচি হবার দিনের তার মাথা কামাবে, সপ্তম দিনের তা মুড়িয়ে ফেলবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","আর অষ্টম দিনের সে দুটি ঘুঘু কিংবা দুটি কপোত শাবক সমাগম তাঁবুর প্রবেশপথে যাজকের কাছে আনবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","যাজক একটি পাখি উত্সর্গ করবে পাপার্থক বলি হিসাবে, অন্যটি হোমার্থক বলি হিসাবে। এটা তার জন্য প্রায়শ্চিত্তস্বরূপ হবে, কারণ মৃতদেহের কাছাকাছি থেকে সে পাপ করেছে। আর সেই দিনের সে নিজেকে পবিত্র করবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","সে নিজে আলাদা থাকার দিন সদাপ্রভুর উদ্দেশ্যে পুনরায় নিজেকে উত্সর্গ করবে এবং দোষার্থক বলি হিসাবে এক বছরের একটি ভেড়ার বাচ্চা আনবে। আর তার আলাদা থাকার দিন অশুচি হওয়ার জন্য তার আগের দিন গুলি গণ্য হবে না। ");
INSERT INTO benirv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","তার আলাদা থাকার ব্রত শেষ হলে নাসরীয়ের জন্য এই ব্যবস্থা হবে। সে সমাগম তাঁবুর প্রবেশপথে আসবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","সে সদাপ্রভুর উদ্দেশ্যে তার উপহার উৎসর্গ করবে। সে হোমবলি হিসাবে এক বছরের নির্দোষ একটি ভেড়ার বাচ্চা উত্সর্গ করবে। সে পাপার্থক বলি হিসাবে এক বছরের নির্দোষ একটি ভেড়ার মেয়ে বাচ্চা আনবে। মঙ্গলার্থক বলি হিসাবে নির্দোষ এক মেষ আনবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","সে আরও এক ঝুড়ি তাড়ীশূন্য রুটি, তেল মেশানো সূক্ষ্ম সূজির পিঠে, তাড়ীশূন্য তেল মেশানো সরুচাকলী ও তার উপযুক্ত ভক্ষ্য এবং পেয় নৈবেদ্য, এইসব কিছু আনবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","যাজক সদাপ্রভুর সামনে এইসব কিছু উপস্থিত করবে। সে পাপার্থক বলি ও হোমবলি উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","পরে তাড়ীশূন্য রুটির ঝুড়ির সঙ্গে মঙ্গলার্থক মেষবলি সদাপ্রভুর উদ্দেশ্যে উৎসর্গ করবে এবং যাজক আরও ভক্ষ্য ও পেয় নৈবেদ্য নিবেদন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","নাসরীয় সমাগম তাঁবুর প্রবেশপথে তার আলাদা থাকার চিহ্ন হিসাবে মাথা কামাবে। সে তার মাথার চুল নিয়ে আগুনের মধ্যে মঙ্গলার্থক বলি হিসাবে উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","যাজক সেই ভেড়ার সেদ্ধ করা কাঁধ, ঝুড়ি থেকে তাড়ীশূন্য একটি পিঠে এবং একটি তাড়ীশূন্য সরুচাকলী নিয়ে নাসরীয়ের আলাদা থেকে মাথা কামানোর পর তার হাতে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","যাজক সেই সব সদাপ্রভুর সামনে ধরবে এবং সেগুলি উত্সর্গ করবে। তাতে নিবেদিত পাঁজর ও উরু সমেত তা যাজকের জন্য পবিত্র হবে। তারপরে নাসরীয় ব্যক্তি আঙ্গুর রস পান করতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","এটি হল ব্রতকারী নাসরীয়ের আলাদা থাকার জন্য সদাপ্রভুকে উত্সর্গ করা উপহারের ব্যবস্থা। এটা ছাড়া সে তার বাধ্যতা অনুসারে দেবে; যা কিছু দিতে প্রতিজ্ঞা করেছে নাসরীয়ের আলাদা থাকার ব্যবস্থা অনুসারে তা দেবে’।” ");
INSERT INTO benirv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","সদাপ্রভু মোশিকে আবার বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“তুমি হারোণ ও তার ছেলেদেরকে বল; তোমরা ইস্রায়েল সন্তানদের এই ভাবে আশীর্বাদ করবে; তাদেরকে বলবে, ");
INSERT INTO benirv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘সদাপ্রভু তোমাকে আশীর্বাদ করুন ও তোমাকে রক্ষা করুন। ");
INSERT INTO benirv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","সদাপ্রভু তোমার প্রতি তাঁর মুখ উজ্জ্বল করুন ও তোমাকে অনুগ্রহ করুন। ");
INSERT INTO benirv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","সদাপ্রভু তোমার প্রতি অনুগ্রহ করুন ও তোমাকে শান্তি দান করুন’। ");
INSERT INTO benirv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","এই ভাবে তারা ইস্রায়েল সন্তানদের উপরে আমার নাম স্থাপন করবে; আর আমি তাদেরকে আশীর্বাদ করব।” ");
INSERT INTO benirv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","যে দিন মোশি সমাগম তাঁবু স্থাপন শেষ করলেন, সেটা অভিষেক ও পবিত্র করলেন, আর তার সমস্ত জিনিস এবং বেদি ও তার সমস্ত পাত্র অভিষেক ও পবিত্র করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","সেই দিন ইস্রায়েলের শাসনকর্তারা, পরিবারের নেতারা তাদের নৈবেদ্য উত্সর্গ করলেন। এই ব্যক্তিরা সমস্ত বংশের শাসনকর্ত্তা ছিলেন, তাঁরা গণনা করা লোকেদের উপরে নিযুক্ত ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","তাঁরা সদাপ্রভুর উদ্দেশ্যে উপহারের জন্য ছয়টি ঢাকা দেওয়া গরুর গাড়ি ও বারটি বলদ, দুটি শাসনকর্ত্তার জন্য একটি করে গরুর গাড়ি ও এক একজন এক একটি করে বলদ এনে সমাগম তাঁবুর সামনে উপস্থিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","তখন সদাপ্রভু মোশিকে বললেন, তিনি বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“তাদের থেকে নৈবেদ্য গ্রহণ কর এবং সেগুলি সমাগম তাঁবুর কাজে ব্যবহার করবে। তুমি সেগুলি লেবীয়দেরকে দেবে; এক এক জনকে তার কাজের প্রয়োজন অনুসারে দেবে।” ");
INSERT INTO benirv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","মোশি সেই সমস্ত গরুর গাড়ি ও বলদ গ্রহণ করে লেবীয়দেরকে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","তিনি গের্শোনের সন্তানদের দুই গরুর গাড়ি ও চারটি বলদ দিলেন, কারণ সেগুলি তাদের কাজে প্রয়োজন। ");
INSERT INTO benirv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","তিনি মরারির সন্তানদের চারটি গরুর গাড়ি ও আটটি বলদ হারোণ যাজকের ছেলে ঈথামরের তত্বাবধানে দিলেন। তিনি দিলেন কারণ তাদের কাজে সেগুলি প্রয়োজন ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","কিন্তু কহাতের সন্তানদের কিছুই দিলেন না, কারণ সমাগম তাঁবুর অন্তর্ভুক্ত সমস্ত জিনিসপত্রের ভার তাদের উপরে ছিল; তারা কাঁধে করে ভার বহন করত। ");
INSERT INTO benirv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","মোশি যেদিন বেদি অভিষেক করেছিলেন, সেদিনের নেতারা বেদি প্রতিষ্ঠার উপহার উত্সর্গ করলেন। সেই নেতারা বেদির সামনে নিজেদের উপহারও উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","সদাপ্রভু মোশিকে বললেন, “এক এক জন নেতা এক এক দিন বেদি প্রতিষ্ঠার জন্য নিজেদের উপহার উত্সর্গ করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","প্রথম দিন, যিহূদা বংশের অম্মীনাদবের ছেলে নহশোন তাঁর উপহার আনলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","তিনি আরও ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি থালা দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","তিনি হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি পুরুষ ভেড়া দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","তিনি পাপার্থক বলির জন্য এক ছাগ দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","তিনি মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া দিলেন। এগুলি অম্মীনাদবের ছেলে নহশোনের উপহার ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","দ্বিতীয় দিনের, ইষাখরের শাসনকর্ত্তা সূয়ারের ছেলে নথনেল উপহার আনলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","তিনি তাঁর উপহার হিসাবে পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি পুরুষ ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","পাপার্থক বলির জন্য একটি পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি ছাগল, এক বছরের পাঁচটি ভেড়া দিলেন। এটা সূয়ারের ছেলে নথনেলের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","তৃতীয় দিনের, সবূলূন সন্তানদের শাসনকর্ত্তা হেলোনের ছেলে ইলীয়াব তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি পুরুষ ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","পাপার্থক বলির জন্য একটি পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি পুরুষ ভেড়া; এগুলি হেলোনের ছেলে ইলীয়াবের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","চতুর্থ দিনের রূবেণ সন্তানদের শাসনকর্ত্তা শদেয়ুরের ছেলে ইলীষূর তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি পুরুষ ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","পাপার্থক বলির জন্য একটি পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি শদেয়ুরের ছেলে ইলীষূরের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","পঞ্চম দিনের শিমিয়োন সন্তানদের শাসনকর্ত্তা সূরীশদ্দয়ের ছেলে শলুমীয়েল তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","পাপার্থক বলিদানের জন্য এক পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি সূরীশদ্দয়ের ছেলে শলুমীয়েলের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ষষ্ট দিনের গাদ সন্তানদের শাসনকর্ত্তা দ্যূয়েলের ছেলে ইলীয়াসফ তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি পুরুষ ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","পাপার্থক বলিদানের জন্য একটি পুরুষ ছাগলের শাবক ");
INSERT INTO benirv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি দ্যূয়েলের ছেলে ইলীয়াসফের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","সপ্তম দিনের ইফ্রয়িম সন্তানদের শাসনকর্ত্তা অম্মীহূদের ছেলে ইলীশামা তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাণের রূপার একটি থালা ও সত্তর শেকল পরিমাণের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","পাপার্থক বলিদানের জন্য এক পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি অম্মীহূদের ছেলে ইলীশামার উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","অষ্টম দিনের মনঃশি সন্তানদের শাসনকর্ত্তা পদাহসূরের ছেলে গমলীয়েল তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ ");
INSERT INTO benirv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","পাপার্থক বলিদানের জন্য একটি পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি পদাহসূরের ছেলে গমলীয়েলের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","নবম দিনের বিন্যামীন সন্তানদের শাসনকর্ত্তা গিদিয়োনির ছেলে অবীদান তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","হোমবলির জন্য এক বলদ শাবক, একটি ভেড়া, এক বছরের একটি ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","পাপার্থক বলিদানের জন্য এক পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি গিদিয়োনির ছেলে অবীদানের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","দশম দিনের দান সন্তানদের শাসনকর্ত্তা অম্মীশদ্দয়ের ছেলে অহীয়েষর তাঁর উপহার উত্সর্গ। ");
INSERT INTO benirv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি পুরুষ ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","পাপার্থক বলিদানের জন্য একটি পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি অম্মীশদ্দয়ের ছেলে অহীয়েষরের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","এগারো দিনের আশেরের লোকদের শাসনকর্ত্তা অক্রণের ছেলে পগীয়েল তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","পাপার্থক বলিদানের জন্য একটি পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ও মঙ্গলার্থক বলির জন্য দুই ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি অক্রণের ছেলে পগীয়েলের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","বারো দিনের নপ্তালি সন্তানদের শাসনকর্ত্তা ঐননের ছেলে অহীরঃ তাঁর উপহার উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","তাঁর উপহার পবিত্র স্থানের শেকল অনুসারে একশো ত্রিশ শেকল পরিমাপের রূপার একটি থালা ও সত্তর শেকল পরিমাপের রূপার একটি বাটি, এই দুটি পাত্র ভক্ষ্য নৈবেদ্যের জন্য তেল মেশানো সূক্ষ্ম সূজিতে পূর্ণ; ");
INSERT INTO benirv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ধূপে পরিপূর্ণ দশ শেকল পরিমাপের সোনার একটি চামচ; ");
INSERT INTO benirv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","হোমবলির জন্য একটি বলদ শাবক, একটি ভেড়া, এক বছরের একটি ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","পাপার্থক বলিদানের জন্য একটি পুরুষ ছাগল ");
INSERT INTO benirv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ও মঙ্গলার্থক বলির জন্য দুটি ষাঁড়, পাঁচটি ভেড়া, পাঁচটি পুরুষ ছাগল, এক বছরের পাঁচটি ভেড়া; এগুলি ঐননের ছেলে অহীরের উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","মোশি যেদিন বেদিটি অভিষেক করলেন সেদিন ইস্রায়েলের সমস্ত শাসনকর্তারা সমস্ত জিনিস উত্সর্গ করলেন। তাঁরা রূপার বারোটি থালা, রূপার বারোটি বাটি, সোনার বারোটি চামচ উত্সর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","তার প্রত্যেক থালা একশো ত্রিশ শেকল এবং প্রত্যেকটি বাটি সত্তর শেকল; মোট পাত্রের রূপার পরিমাণ পবিত্র স্থানের শেকল অনুসারে দুই হাজার চারশো শেকল। ");
INSERT INTO benirv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ধূপে পরিপূর্ণ সোনার বারোটি চামচের পরিমাণ পবিত্র স্থানের শেকল অনুসারে দশ শেকল; মোট এইসব চামচের সোনার একশো কুড়ি শেকল। ");
INSERT INTO benirv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","তাঁরা হোমবলির জন্য বারোটি বলদ, বারোটি ভেড়া, এক বছরের বারোটি পুরুষ ভেড়া উত্সর্গ করলেন। তাঁরা ভক্ষ্য নৈবেদ্য দিলেন। পাপার্থক বলিদান হিসাবে বারোটি পুরুষ ছাগল দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","মঙ্গলার্থক বলির জন্য মোট চব্বিশটি ষাঁড়, ষাটটি ভেড়া, ষাটটি পুরুষ ছাগল, এক বছরের ষাটটি পুরুষ ভেড়া। এগুলি বেদির অভিষেকের পরে বেদি প্রতিষ্ঠার উপহার। ");
INSERT INTO benirv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","মোশি যখন ঈশ্বরের সঙ্গে কথা বলতে সমাগম তাঁবুতে প্রবেশ করতেন, তখন তিনি ঈশ্বরের কথা শুনতেন। ঈশ্বর তাঁর সাথে কথা বলতেন সাক্ষ্য সিন্দুকের উপরের পাপাবরণ থেকে, সেই দুই করূবের মধ্যে থেকে। সদাপ্রভু তাঁর সাথে কথা বলতেন। ");
INSERT INTO benirv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“তুমি হারোণকে বল, তাকে বল, ‘তুমি প্রদীপগুলি জ্বালালে সেই সাতটি প্রদীপ যেন বাতিদানীর সামনের দিকে আলো দেয়’।” ");
INSERT INTO benirv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","তাতে হারোণ সেই রকম করলেন, বাতিদানীর সামনের দিকে আলো দেবার জন্য সেই সব প্রদীপ জ্বালালেন, যেমন সদাপ্রভু মোশিকে আদেশ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ঐ বাতিদানী এই ভাবে তৈরী হয়েছিল, সদাপ্রভু মোশিকে দেখিয়েছিলেন কিভাবে পেটানো সোনা দিয়ে সেটা তৈরী করবে, তার কান্ড থেকে ফুলেতেও পেটান কাজ ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","পুনরায় সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“তুমি ইস্রায়েল সন্তানদের মধ্যে থেকে লেবীয়দেরকে নিয়ে শুচি কর। ");
INSERT INTO benirv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","তাদেরকে শুচি করার জন্য এইরকম কর, তাদের উপরে পাপমোচনের জল ছিটিয়ে দাও। তারা নিজেদের সমস্ত গায়ে ক্ষুর বুলিয়ে পোশাক ধুয়ে নিজেদেরকে শুচি করুক। ");
INSERT INTO benirv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","তারপর তারা একটি বলদ শাবক ও তেল মেশানো সূক্ষ্ম সূজির ভক্ষ্য নৈবেদ্য আনুক এবং তুমি পাপার্থক বলিদানী জন্য আর একটি বলদ শাবক গ্রহণ কর। ");
INSERT INTO benirv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","লেবীয়দেরকে সমাগম তাঁবুর সামনে আন ও ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে জড়ো কর। ");
INSERT INTO benirv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","তুমি লেবীয়দেরকে সদাপ্রভুর সামনে আনলে ইস্রায়েল সন্তানরা তাদের গায়ে হাত রাখুক। ");
INSERT INTO benirv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","হারোণ ইস্রায়েল সন্তানদের উত্সর্গ করা নৈবেদ্য হিসাবে লেবীয়দেরকে সদাপ্রভুর সামনে নিবেদন করবে; তাতে তারা সদাপ্রভুর কাজে নিযুক্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","পরে লেবীয়েরা ঐ দুটি বলদের মাথায় হাত রাখবে, আর তুমি লেবীয়দের জন্য প্রায়শ্চিত্ত করার জন্য আমার উদ্দেশ্যে একটি বলদ পাপার্থক বলি হিসাবে এবং অন্য বলদটি হোমার্থক বলি হিসাবে উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","হারোণের ও তাঁর ছেলেদের সামনে লেবীয়দেরকে উপস্থিত করে আমার উদ্দেশ্যে একটি দোলনীয় নৈবেদ্য হিসাবে তাদেরকে নিবেদন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","এই ভাবে তুমি ইস্রায়েল সন্তানদের থেকে লেবীয়দেরকে আলাদা কোরো; তাতে লেবীয়েরা আমারই হবে। ");
INSERT INTO benirv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","তারপরে লেবীয়েরা সমাগম তাঁবুর কাজ করতে প্রবেশ করবে। এই ভাবে তুমি তাদেরকে শুচি করে দোলনীয় নৈবেদ্য হিসাবে নিবেদন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","কারণ ইস্রায়েল সন্তানদের মধ্যে থেকে তারা সম্পূর্ণ ভাবে আমার; আমি সমস্ত গর্ভজাত, সমস্ত ইস্রায়েল সন্তানদের প্রথমজাতদের পরিবর্তে তাদেরকে নিজের জন্য গ্রহণ করেছি। ");
INSERT INTO benirv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","মানুষ কিংবা পশু উভয়েই, ইস্রায়েল সন্তানদের সমস্ত প্রথমজাত আমার; যে দিনের আমি মিশর দেশের সমস্ত প্রথমজাতকে আঘাত করেছিলাম, সেই দিনের নিজের জন্য তাদেরকে পবিত্র করেছিলাম। ");
INSERT INTO benirv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","আমি ইস্রায়েল সন্তানদের সমস্ত প্রথমজাতের পরিবর্তে লেবীয়দেরকে গ্রহণ করেছি। ");
INSERT INTO benirv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","আমি লেবীয়দের হারোণ ও তার ছেলেদেরকে উপহার হিসাবে দিয়েছি। আমি সমস্ত ইস্রায়েল সন্তানদের মধ্যে থেকে সমাগম তাঁবুতে কাজ করার জন্য তাদের গ্রহণ করেছি। ইস্রায়েল সন্তানদের জন্য প্রায়শ্চিত্ত করতে লেবীয়দেরকে ইস্রায়েল সন্তানদের মধ্যে থেকে দিয়েছি; যেন ইস্রায়েল সন্তানরা পবিত্র স্থানের কাছাকাছি আসার জন্য ইস্রায়েল সন্তানদের মধ্যে না মহামারী হয়।” ");
INSERT INTO benirv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","মোশি, হারোণ ও ইস্রায়েল সন্তানদের সমস্ত মণ্ডলী লেবীয়দের প্রতি সেই রকম করল; সদাপ্রভু লেবীয়দের বিষয়ে মোশিকে যেমন আদেশ করেছিলেন, তেমন ইস্রায়েল সন্তানরা তাদের প্রতি করল। ");
INSERT INTO benirv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","তাই লেবীয়রা নিজেদের পাপমুক্ত করল ও নিজেদের পোশাক ধুয়ে নিল। হারোণ তাদেরকে সদাপ্রভুর সাক্ষাৎে দোলনীয় নৈবেদ্য হিসাবে উপস্থিত করলেন, আর হারোণ তাদেরকে শুচি করে তাদের জন্য প্রায়শ্চিত্ত করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","তারপর লেবীয়েরা হারোণের সামনে ও তাঁর ছেলেদের সামনে নিজেদের কাজ করার জন্য সমাগম তাঁবুতে প্রবেশ করতে লাগল। লেবীয়দের বিষয়ে সদাপ্রভু মোশিকে যেমন আদেশ দিয়েছিলেন, সেই অনুসারে তাদের প্রতি করা হল। ");
INSERT INTO benirv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","আবার সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“পঁচিশ বছর ও তার থেকে বয়সী লেবীয়দের জন্য এই রকম হবে। তারা সমাগম তাঁবুতে কাজ করার জন্য শ্রেণীভুক্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","পঞ্চাশ বছর বয়সী হওয়ার পর সে সেবাকারীদের দল থেকে ফিরে আসবে, সে তার কাজ বন্ধ করে না। ");
INSERT INTO benirv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","তারা তাদের ভাইদের সাহায্য করবে যারা সমাগম তাঁবুতে নিয়মিত কাজ করে, কিন্তু তারা আর সেবা করতে পারবে না। লেবীয়দের সমস্ত বিষয়ে তুমি পরিচালনা করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ইস্রায়েল মিশর দেশ থেকে বেরিয়ে আসার পর দ্বিতীয় বছরের প্রথম মাসে সীনয় মরুপ্রান্তে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ইস্রায়েল সন্তানরা সঠিক দিনের নিস্তারপর্ব্ব পালন করুক। ");
INSERT INTO benirv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","এই মাসের চৌদ্দতম দিনের সন্ধ্যাবেলায় সঠিক দিনের তোমরা তা পালন কোরো, পর্বের সমস্ত নিয়ম ও সমস্ত শাসন অনুসারে তা পালন করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","তখন মোশি ইস্রায়েল সন্তানদের নিস্তারপর্ব্ব পালন করতে আদেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","তাতে তারা প্রথম মাসের চৌদ্দতম দিনের সন্ধ্যাবেলায় সীনয় মরুপ্রান্তে নিস্তারপর্ব্ব পালন করল; সদাপ্রভু মোশিকে যে আদেশ করেছিলেন, সেই অনুসারেই ইস্রায়েল সন্তানরা সমস্তকিছু করল। ");
INSERT INTO benirv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","কয়েক জন লোক একটি মানুষের মৃতদেহ স্পর্শ করে অশুচি হওয়ার জন্য সেই দিন নিস্তারপর্ব্ব পালন করতে পারল না; অতএব তারা সেদিন মোশির ও হারোণের সামনে উপস্থিত হল। ");
INSERT INTO benirv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","সেই লোকগুলি তাকে বলল, “আমরা একটি মানুষের মৃতদেহ স্পর্শ করে অশুচি হয়েছি, তার জন্য কেন ইস্রায়েল সন্তানদের মধ্যে নির্দিষ্ট দিনের সদাপ্রভুর উদ্দেশ্যে উপহার উত্সর্গ করা থেকে আলাদা রেখেছেন?” ");
INSERT INTO benirv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","মোশি তাদেরকে বললেন, “তোমরা দাঁড়াও, তোমাদের বিষয়ে সদাপ্রভু কি আদেশ দেন, তা শুনি।” ");
INSERT INTO benirv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","সদাপ্রভু মোশিকে বললেন, “তুমি ইস্রায়েল সন্তানদের বল, ");
INSERT INTO benirv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","‘তোমাদের কিংবা তোমাদের হবু সন্তানদের মধ্যে যখন কেউ মৃতদেহ স্পর্শ করে অশুচি হয়, কিংবা দূর কোন পথে থাকে, তখন সে সদাপ্রভুর উদ্দেশ্যে নিস্তারপর্ব্ব পালন করবে।’ ");
INSERT INTO benirv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","দ্বিতীয় মাসে চৌদ্দতম দিনের সন্ধ্যাবেলায় তারা তা পালন করবে; তারা তাড়ীশূন্য রুটি ও তেতো শাকের সঙ্গে খাবে। ");
INSERT INTO benirv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","তারা সকাল পর্যন্ত তার কিছুই অবশিষ্ট রাখবে না ও পশুটির কোন হাড় ভাঙ্গবে না; নিস্তারপর্ব্বের সমস্ত নিয়ম অনুসারে তারা তা পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","কিন্তু যে কেউ শুচি থাকে ও পথিক না হয়, সে যদি নিস্তারপর্ব্ব পালন না করে, তবে সেই প্রাণী তার লোকেদের মধ্যে থেকে উচ্ছেদ হবে; কারণ সঠিক দিনের সদাপ্রভুর উদ্দেশ্যে উপহার না আনাতে সে নিজের পাপ নিজে বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","যদি কোন বিদেশীয় লোক তোমাদের মধ্যে বসবাস করে, আর সদাপ্রভুর উদ্দেশ্যে নিস্তারপর্ব্ব পালন করে; তবে সে নিস্তারপর্ব্বের নিয়ম হিসাবে ও পর্বের ব্যবস্থা অনুসারে তা পালন করবে; বিদেশী কি স্বদেশী উভয়ের জন্যই তোমাদের পক্ষে একমাত্র ব্যবস্থা হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","যে দিন সমাগম তাঁবু স্থাপিত হল, সেই দিন মেঘ সমাগম তাঁবু অর্থাৎ সাক্ষ্য তাঁবু ঢেকে দিল। সন্ধ্যাবেলায় মেঘ সমাগম তাঁবুর উপরে সকাল পর্যন্ত আগুনের আকার ধারণ করলো। ");
INSERT INTO benirv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","এইরকম রোজ হত; মেঘ সমাগম তাঁবু ঢেকে দিত, আর রাত্রিতে আগুনের আকার দেখা যেত। ");
INSERT INTO benirv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","আর যে কোন দিনের তাঁবুর উপর থেকে মেঘ উপরের দিকে উঠে যায়, তখন ইস্রায়েল সন্তানরা যাত্রা করত এবং মেঘ যেখানে অবস্থান করত, ইস্রায়েল সন্তানরা সেইখানে শিবির স্থাপন করত। ");
INSERT INTO benirv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","সদাপ্রভুর আদেশ অনুসারেই ইস্রায়েল সন্তানরা যাত্রা করত, সদাপ্রভুর আদেশ অনুসারেই শিবির স্থাপন করত, তারা তাদের শিবিরে থাকত। ");
INSERT INTO benirv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","আর মেঘ যখন সমাগম তাঁবুর সমাগম তাঁবুর উপরে অনেক দিন অবস্থান করত, তখন ইস্রায়েল সন্তানরা সদাপ্রভুর আদেশ পালন করত; যাত্রা করত না। ");
INSERT INTO benirv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","আর মেঘ কখন কখন সমাগম তাঁবুর উপরে অল্প দিন থাকত, সদাপ্রভুর আদেশে তারা শিবিরে থাকত, আর সদাপ্রভুর আদেশেই যাত্রা করত। ");
INSERT INTO benirv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","কখন কখন মেঘ সন্ধ্যাবেলা থেকে সকাল পর্যন্ত থাকত; আর মেঘ সকালে উপরের দিকে উঠে গেলে তারা যাত্রা করত; অথবা দিন কি রাত্রি হোক, মেঘ উপরে গেলেই তারা যাত্রা করত। ");
INSERT INTO benirv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","দুই দিন কিংবা একমাস কিংবা এক বছর হোক, সমাগম তাঁবুর উপরে মেঘ যতদিন থাকত, ইস্রায়েল সন্তানরাও ততদিন শিবিরে বাস করত; যাত্রা করত না; কিন্তু মেঘ উপরে উঠে গেলেই তারা যাত্রা করত। ");
INSERT INTO benirv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","সদাপ্রভুর আদেশেই তারা শিবিরে থাকত, সদাপ্রভুর আদেশেই যাত্রা করত; তারা মোশির মাধ্যমে দেওয়া সদাপ্রভুর আদেশ অনুসারে সদাপ্রভুর নির্দেশ পালন করত। ");
INSERT INTO benirv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“তুমি দুইটি রূপার শিঙ্গা তৈরী কর; পেটান রূপা দিয়ে তা তৈরী কর; তুমি তা মণ্ডলীকে ডাকার জন্য ও শিবিরগুলির যাত্রার জন্য ব্যবহার করবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","সেই দুটি শিঙ্গা বাজলে সমস্ত মণ্ডলী সমাগম তাঁবুর প্রবেশপথে তোমার কাছে জড়ো হবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","কিন্তু একটি শিঙ্গা বাজালে শাসনকর্তারা, ইস্রায়েলের সহস্রপতিরা, তোমার কাছে জড়ো হবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","তোমরা যুদ্ধের শিঙ্গা বাজালে পূর্বদিকের শিবিরের লোকেরা শিবির উঠাবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","তোমরা দ্বিতীয় বার যুদ্ধের শিঙ্গা বাজালে দক্ষিণ দিকের শিবিরের লোকেরা শিবির উঠাবে; তাদের যাবার জন্য যুদ্ধের শিঙ্গা বাজাতে হবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","কিন্তু সমাজের মিলিত হওয়ার জন্য শিঙ্গা বাজাবার দিনের তোমরা যুদ্ধের শিঙ্গা বাজিও না। ");
INSERT INTO benirv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","হারোণের সন্তান যাজকেরা সেই শিঙ্গা বাজাবে, তোমাদের বংশ পরম্পরা অনুসারে চিরস্থায়ী নিয়মের জন্য তোমরা তা রাখবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","যে দিনের তোমরা নিজেদের দেশে বিপক্ষের বিরুদ্ধে যুদ্ধ করতে যাবে যারা তোমাদের জন্য দুঃখদায়ক, তখন তুমি যুদ্ধের শিঙ্গার সতর্ক ধ্বনি বাজাবে; তাতে তোমাদের ঈশ্বর সদাপ্রভুর সামনে তোমাদেরকে স্মরণ করবেন ও তোমরা নিজেদের শত্রুদের থেকে রক্ষা পাবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","তোমাদের আনন্দের দিনের, পর্বের দিনের ও মাসের শুরুতে হোমবলির ও তোমাদের মঙ্গলার্থক বলিদান উপলক্ষে তোমরা সেই তূরী বাজাবে; এটা আমাকে, তোমাদের ঈশ্বরকে স্মরণ করিয়ে দেবে। আমি সদাপ্রভু, তোমাদের ঈশ্বর।” ");
INSERT INTO benirv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","দ্বিতীয় বছর দ্বিতীয় মাসের কুড়িতম দিনের সেই মেঘ সাক্ষ্যের সমাগম তাঁবুর উপর থেকে উঁচুতে উঠল। ");
INSERT INTO benirv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","তাতে ইস্রায়েল সন্তানরা নিজেদের যাত্রার নিয়ম অনুসারে সীনয় মরুভূমি থেকে যাত্রা করল, পরে সেই মেঘ পারণ মরুপ্রান্তে অবস্থান করল। ");
INSERT INTO benirv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","মোশির মাধ্যমে দেওয়া সদাপ্রভুর আদেশ অনুসারে তারা এই প্রথম বার যাত্রা করল। ");
INSERT INTO benirv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","প্রথমে তাদের সৈন্যদের সঙ্গে যিহূদা সন্তানদের শিবিরের পতাকা চলল; অম্মীনাদবের ছেলে নহশোন তাদের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","সূয়ারের ছেলে নথনেল ইষাখর সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","হেলোনের ছেলে ইলীয়াব সবূলূন সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","সমাগম তাঁবু তোলা হলে গের্শোনের সন্তানরা ও মরারির সন্তানরা সেই সমাগম তাঁবু বহন করার জন্য এগিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","তারপরে নিজের সৈন্যদের সঙ্গে রূবেণের শিবিরের পতাকা চলল; শদেয়ূরের ছেলে ইলীষূর তাদের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","সূরীশদ্দয়ের ছেলে শলুমীয়েল শিমিয়োন সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","দ্যূয়েলের ছেলে ইলীয়াসফ গাদ সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","কহাতীয়েরা পবিত্র স্থানের উপকরণ বহন করে যাত্রা করল। অন্য লোকেরা কহাতীয়দের পরের শিবিরে পৌঁছানোর আগে সমাগম তাঁবু স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","নিজের সৈন্যদের সঙ্গে ইফ্রয়িম সন্তানদের শিবিরের পতাকা চলল। অম্মীহূদের ছেলে ইলীশামা তাদের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","পদাহসূরের ছেলে গমলীয়েল মনঃশি সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","গিদিয়োনির ছেলে অবীদান বিন্যামীন সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","সমস্ত শিবিরের পিছু পিছু নিজের সৈন্যের সঙ্গে দান সন্তানদের শিবিরের পতাকা চলল। অম্মীশদ্দয়ের ছেলে অহীয়েষর তাদের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","অক্রণের ছেলে পগীয়েল আশের সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ঐননের ছেলে অহীরঃ নপ্তালি সন্তানদের বংশের সেনাপতি ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ইস্রায়েল সন্তানরা এই ভাবে যাত্রা করত। ");
INSERT INTO benirv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","মোশি তাঁর শ্বশুর মিদিয়োনীয় রূয়েলের ছেলে হোববকে বললেন, “সদাপ্রভু আমাদেরকে যে স্থান দিতে প্রতিজ্ঞা করেছেন, আমরা সে স্থানে যাত্রা করছি, তুমিও আমাদের সঙ্গে এস, আমরা তোমার মঙ্গল করব, কারণ সদাপ্রভু ইস্রায়েলের মঙ্গল করার প্রতিজ্ঞা করেছেন।” ");
INSERT INTO benirv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","তিনি তাকে বললেন, “আমি যাব না, আমি নিজের দেশে ও নিজের আত্মীয়দের কাছে যাব।” ");
INSERT INTO benirv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","মোশি বললেন, “দয়া করে আমাদেরকে ত্যাগ কোরো না, কারণ মরুপ্রান্তের মধ্যে আমাদের শিবির স্থাপনের বিষয়ে তুমি জান, আর তুমি আমাদের পথপ্রদর্শক হবে। ");
INSERT INTO benirv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","যদি তুমি আমাদের সঙ্গে যাও, সদাপ্রভু আমাদের প্রতি যে মঙ্গল করবেন, আমরা তোমার প্রতি তাই করব।” ");
INSERT INTO benirv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","তারা সদাপ্রভুর পর্বত থেকে তিন দিনের র পথ চলে গেল। তাদের বিশ্রাম স্থান খোঁজার জন্য সদাপ্রভুর নিয়ম সিন্দুক তিন দিনের র পথ তাদের থেকে এগিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","শিবির থেকে অন্য জায়গায় যাবার দিনের সদাপ্রভুর মেঘ দিনের রবেলায় তাদের উপরে থাকত। ");
INSERT INTO benirv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","আর সিন্দুকের এগিয়ে যাবার দিনের মোশি বলতেন, “হে সদাপ্রভু, ওঠ, তোমার শত্রুরা বিচ্ছিন্ন হোক, যারা তোমাকে ঘৃণা করে তারা তোমার সামনে থেকে পালিয়ে যাক।” ");
INSERT INTO benirv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","যখন নিয়মের সিন্দুক থামতো, মোশি বলতেন, “হে সদাপ্রভু, ইস্রায়েলের হাজার হাজারের কাছে ফিরে এস।” ");
INSERT INTO benirv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","এখন (ইস্রায়েলী) লোকেরা অভিযোগকারীদের মত সদাপ্রভুর কানের কাছে খারাপ কথা বলতে লাগল; আর সদাপ্রভু তা শুনলেন ও প্রচণ্ড রেগে গেলেন; তাতে তাদের মধ্যে সদাপ্রভুর আগুন জ্বলে উঠে শিবিরের শেষের অংশ গিলে ফেলতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","তখন লোকেরা মোশির কাছে কাঁদতে লাগলেন; তাতে মোশি সদাপ্রভুর কাছে প্রার্থনা করলে সেই আগুন থেমে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","তখন তিনি ঐ স্থানের নাম তবেরা জ্বলন রাখলেন, কারণ সদাপ্রভুর আগুন তাদের মধ্যে জ্বলেছিল। ");
INSERT INTO benirv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","তাদের মধ্যে থাকা কিছু বিদেশী লোকেরা ইস্রায়েলের সন্তানদের সাথে শিবির করলো। তারা ভালো খাবার খেতে চাইল। তখন ইস্রায়েল সন্তানরা আবার অভিযোগ করে কাঁদতে লাগলো এবং বলল, “কে আমাদেরকে খাওয়ার জন্য মাংস দেবে? ");
INSERT INTO benirv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","আমরা মিশর দেশে বিনা পয়সায় যে যে মাছ খেতাম, সেগুলো এবং শশা, খরমুজ, পেঁয়াজ জাতীয় সব্জি, পেঁয়াজ ও রসুনের কথা মনে পড়ছে। ");
INSERT INTO benirv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","এখন আমরা দুর্বল; আমাদের কাছে এই মান্না ছাড়া আর কিছু নেই।” ");
INSERT INTO benirv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ঐ মান্না ধনিয়া বীজের মত ও সেটা দেখতে ধুনার মত ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","লোকেরা ঘুরে ঘুরে করে তা কুড়িয়ে জড়ো করত এবং যাঁতায় পিষে কিংবা হামালদিস্তায় ভেঙে পানপাত্রে সিদ্ধ করত ও সেটা দিয়ে পিঠে তৈরী করত। এটার স্বাদ ছিল অলিভ তেলের মত। ");
INSERT INTO benirv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","রাত্রিতে শিবিরের উপরে শিশির পড়লে ঐ মান্না তার উপরে পড়ে থাকত। ");
INSERT INTO benirv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","মোশি লোকেদের কান্না শুনলেন, তারা সমস্ত গোষ্ঠীর মধ্যে নিজেদের তাঁবুর প্রবেশপথে কাঁদছিল। সদাপ্রভুর খুব রেগে গেলেন এবং মোশির কাছেও তাদের অভিযোগ ভুল ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","মোশি সদাপ্রভুকে বললেন, “তুমি কি জন্য তোমার দাসকে এত কষ্ট দিয়েছ? কি জন্যই বা আমি তোমার কাছে অনুগ্রহ পাই নি যে, তুমি এইসব লোকের ভার আমার উপরে দিচ্ছ? ");
INSERT INTO benirv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","আমি কি এই সমস্ত লোককে গর্ভে ধারণ করেছি? আমি কি এদেরকে জন্ম দিয়েছি? সেই জন্য তুমি এদের পূর্বপুরুষদের কাছে যে দেশের বিষয়ে শপথ করেছিলে, সেই দেশ পর্যন্ত আমাকে কি ‘দুধ পান করা শিশু বহনকারী বাবার মত এদেরকে বুকে করে বহন করতে বলছ?’ ");
INSERT INTO benirv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","এই সমস্ত লোককে দেবার জন্য আমি কোথায় মাংস পাব? এরা তো আমার কাছে কেঁদে কেঁদে বলছে, ‘আমাদেরকে মাংস দাও, আমরা খাব’। ");
INSERT INTO benirv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","এতো লোকের ভার একা সহ্য করা আমার অসম্ভব; কারণ সেটা আমার জন্য অতিরিক্ত। ");
INSERT INTO benirv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","তুমি যদি আমার প্রতি এরকম ব্যবহার কর, তবে অনুরোধ করি, আমি তোমার কাছে যদি অনুগ্রহ পেয়ে থাকি, তবে আমাকে মেরে ফেল এবং আমার দুর্দশা সরিয়ে নাও।” ");
INSERT INTO benirv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","তখন সদাপ্রভু মোশিকে বললেন, “তুমি যাদেরকে লোকেদের প্রাচীন ও শাসনকর্ত্তা বলে জান, ইস্রায়েলের এমন সত্তর জন প্রাচীন লোককে আমার কাছে নিয়ে এস; তাদেরকে সমাগম তাঁবুর কাছে আন; তারা তোমার সঙ্গে সেখানে দাঁড়াবে। ");
INSERT INTO benirv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","পরে আমি সেখানে নেমে তোমার সঙ্গে কথা বলব এবং তোমার উপরে যে আত্মা অধিষ্ঠান করেন, তার কিছুটা অংশ নিয়ে তাদের উপরে দেব, তাতে তুমি যেন একা লোকদের ভার বহন না কর, এই জন্য তারাও তোমার সঙ্গে লোকদের ভার বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","আর তুমি লোকদেরকে বল, ‘তোমরা কালকের জন্য নিজেদের পবিত্র কর,’ মাংস খেতে পাবে; কারণ তোমরা সদাপ্রভুর কাছে কেঁদে বলেছ, ‘আমাদেরকে মাংস খেতে কে দেবে? বরং মিশর দেশই আমাদের ভালো ছিল’।” অতএব সদাপ্রভু তোমাদেরকে মাংস দেবেন, তোমরা খাবে। ");
INSERT INTO benirv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","একদিন কি দুদিন কি পাঁচদিন কি দশদিন কি কুড়িদিন তা খাবে, ");
INSERT INTO benirv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","এমন নয়; সম্পূর্ণ এক মাস পর্যন্ত, যতদিন তা তোমাদের নাক থেকে বের না হয় ও তোমরা সেটা ঘৃণা না কর, ততদিন খাবে; কারণ তোমরা তোমাদের মধ্যে থাকা সদাপ্রভুকে অগ্রাহ্য করেছ এবং তাঁর কাছে কেঁদে কেঁদে এই কথা বলেছ, আমরা কেন মিশর থেকে বেরিয়ে এসেছি? ");
INSERT INTO benirv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","তখন মোশি বললেন, “আমি যে লোকেদের মধ্যে আছি, তারা ছয় লক্ষ জন; আর তুমি বলছ, ‘আমি সম্পূর্ণ একমাস তাদেরকে খাবার মাংস দেব’। ");
INSERT INTO benirv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","তাদের সন্তুষ্ট করার জন্য কি ভেড়ার পাল ও গরুর পাল মারতে হবে? না তাদের সন্তুষ্ট করার জন্য সমুদ্রের সমস্ত মাছ ধরতে হবে?” ");
INSERT INTO benirv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","সদাপ্রভু মোশিকে বললেন, “আমার হাত কি ছোট? আমার বাক্য সত্যি হয় কি না, তা তুমি এখন দেখবে।” ");
INSERT INTO benirv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","মোশি বাইরে গিয়ে সদাপ্রভুর বাক্য লোকেদেরকে বললেন এবং লোকেদের প্রাচীনদের মধ্যে থেকে সত্তর জনকে জড়ো করে তাঁবুর চারপাশে উপস্থিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","সদাপ্রভু মেঘে নেমে এসে তাঁর সঙ্গে কথা বললেন এবং যে আত্মা তাঁর উপরে ছিলেন, তাঁর কিছুটা অংশ নিয়ে সেই সত্তর জন প্রাচীনের উপরে দিলেন; তাতে আত্মা তাঁদের উপরে অধিষ্ঠান করলে তাঁরা ভাববাণী প্রচার করলেন, কিন্তু সেই দিন ছাড়া পরে আর করলেন না। ");
INSERT INTO benirv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","কিন্তু শিবিরের মধ্যে দুইটি লোক বাকি ছিলেন, এক জনের নাম ইলদদ, আর এক জনের নাম মেদদ। আত্মা তাদের উপরে এলেন। তাঁদের নাম ঐ লেখা লোকেদের মধ্যে ছিল, কিন্তু বাইরে তাঁবুর কাছে যান নি। তবুও তাঁরা শিবিরের মধ্যে ভাববাণী প্রচার করতে লাগলেন। ");
INSERT INTO benirv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","তাতে এক যুবক দৌড়ে গিয়ে মোশিকে বলল, “ইলদদ ও মেদদ শিবিরে ভাববাণী প্রচার করছে।” ");
INSERT INTO benirv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","তখন নূনের ছেলে যিহোশূয়, মোশির পরিচারক, যিনি তাঁর একজন মনোনীত লোক, তিনি বললেন, “হে আমার প্রভু মোশি, তাদেরকে বারণ করুন।” ");
INSERT INTO benirv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","মোশি তাদেরকে বললেন, “তুমি কি আমার ওপর ঈর্ষা করছ? সদাপ্রভুর যাবতীয় প্রজা ভাববাদী হোক ও সদাপ্রভু তাদের উপরে তাঁর আত্মা দিন।” ");
INSERT INTO benirv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","পরে মোশি ও ইস্রায়েলের প্রাচীনেরা শিবিরে ফিরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","তখন সদাপ্রভুর কাছ থেকে বায়ু এসে সমুদ্র থেকে ভারুই পাখি এনে শিবিরের উপরে ফেলল; শিবিরের চারিদিকে একপাশে এক দিনের র পথ, ওপাশে এক দিনের র পথ পর্যন্ত ফেলল, সেগুলি ভূমির উপরে দুহাত উঁচু হয়ে রইল। ");
INSERT INTO benirv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","আর লোকেরা সেই সমস্ত দিন রাত ও পরের দিন সমস্ত দিন উঠে ভারুই পাখি সংগ্রহ করল; তাদের মধ্যে কেউ দশ হোমরের কম জড়ো করল না; পরে নিজেদের জন্য শিবিরের চারিদিকে তা ছড়িয়ে রাখল। ");
INSERT INTO benirv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","যখন মাংস তাদের দাঁতের মধ্যে ছিল, যখন তারা এটা চিবাচ্ছিল, সদাপ্রভু তাদের উপর খুব রেগে গেলেন। তিনি লোকেদেরকে ভারী মহামারী দিয়ে আঘাত করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","আর সেই স্থান কিব্রোৎ-হত্তাবা লোভের কবর নামে পরিচিত হল, কারণ সেই স্থানে তারা লোভীদেরকে কবর দিল। ");
INSERT INTO benirv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","কিব্রোৎ-হত্তাবা থেকে লোকেরা হৎসেরোতে যাত্রা করল এবং তারা হৎসেরোতে থাকলো। ");
INSERT INTO benirv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","মোশি যে কূশীয়া স্ত্রীকে বিয়ে করেছিলেন, তাঁর জন্য মরিয়ম ও হারোণ মোশির বিপরীতে কথা বলতে লাগলেন, কারণ তিনি এক কূশীয়া স্ত্রীকে বিয়ে করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","তাঁরা বললেন, “সদাপ্রভু কি শুধু মোশির সঙ্গে কথা বলেছেন? আমাদের সঙ্গে কি বলেন নি?” আর এ কথা সদাপ্রভু শুনলেন। ");
INSERT INTO benirv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","পৃথিবীর সমস্ত মানুষদের মধ্যে থেকে মোশি লোকটি অনেক বেশি নম্র ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","সদাপ্রভু হঠাৎ মোশি, হারোণ ও মরিয়মকে বললেন, “তোমরা তিনজন বেরিয়ে সমাগম তাঁবুর কাছে এস।” তাঁরা তিনজন বেরিয়ে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","তখন প্রভু মেঘস্তম্ভে নেমে তাঁবুর প্রবেশপথে দাঁড়ালেন এবং হারোণ ও মরিয়মকে ডাকলেন; তাতে তাঁরা উভয়ে বেরিয়ে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","তিনি বললেন, “তোমরা আমার কথা শোনো; তোমাদের মধ্যে যদি কেউ ভাববাদী হয়, তবে আমি সদাপ্রভু তার কাছে কোন দর্শনের মাধ্যমে নিজের পরিচয় দেব, স্বপ্নে তার সঙ্গে কথা বলব। ");
INSERT INTO benirv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","আমার দাস মোশি সেরকম নয়, সে আমার সমস্ত গৃহের মধ্যে বিশ্বস্ত। ");
INSERT INTO benirv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","তার সঙ্গে আমি মুখোমুখি হয়ে কথা বলি, দর্শন কিংবা রহস্যের মাধ্যমে নয়, সে আমার আকার দেখে। অতএব আমার দাসের বিরুদ্ধে, মোশির বিরুদ্ধে, কথা বলতে তোমরা কেন ভয় পেলে না?” ");
INSERT INTO benirv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ফলে তাদের প্রতি সদাপ্রভু প্রচণ্ড রেগে গেলেন ও তিনি তাদের ছেড়ে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","তাঁবুর উপর থেকে মেঘ সরে গেল; মরিয়মের হিমের মত কুষ্ঠ হয়েছে। যখন হারোণ মরিয়মের দিকে মুখ ফেরালেন, দেখলেন, তিনি কুষ্ঠগ্রস্তা। ");
INSERT INTO benirv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","হারোণ মোশিকে বললেন, “হায়, আমার প্রভু, অনুরোধ করি, পাপের ফল আমাদেরকে দেবেন না, এই বিষয়ে আমরা বোকার মত কাজ করেছি এবং আমরা পাপ করেছি। ");
INSERT INTO benirv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","মায়ের গর্ভ থেকে বেরোনোর দিন যার মাংস অর্ধেক নষ্ট, সেই রকম মৃতের মত এ যেন না হয়।” ");
INSERT INTO benirv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","সুতরাং, মোশি সদাপ্রভুর কাছে কেঁদে বললেন, “হে ঈশ্বর, অনুরোধ করি, একে সুস্থ কর।” ");
INSERT INTO benirv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","সদাপ্রভু মোশিকে বললেন, “যদি এর বাবা এর মুখে থুথু দিত, তাহলে এ কি সাত দিন লজ্জিত থাকত না? এ সাত দিন পর্যন্ত শিবিরের বাইরে আটকে থাকুক; তারপরে পুনরায় তাকে ভিতরে আনা হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","তাতে মরিয়ম সাত দিন শিবিরের বাইরে আটকে থাকলেন এবং যতদিন মরিয়ম ভিতরে না আসলেন, ততদিন লোকেরা যাত্রা করল না। ");
INSERT INTO benirv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","পরে লোকেরা হৎসেরোৎ থেকে যাত্রা করে পারণ মরুপ্রান্তে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","তখন সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“আমি ইস্রায়েল সন্তানদের যে কনান দেশ দেব, তুমি সেটা পরীক্ষা করার জন্য কয়েক জন ব্যক্তিকে পাঠাও। তাদের পূর্বপুরুষদের প্রত্যেক বংশের মধ্যে থেকে একজন করে লোক পাঠাও। প্রত্যেক ব্যক্তি তাদের মধ্যে শাসনকর্ত্তা হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","সদাপ্রভুর আদেশ অনুসারে মোশি পারণ মরুভূমি থেকে তাদেরকে পাঠালেন। তাঁরা সবাই ইস্রায়েল সন্তানদের শাসনকর্ত্তা ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","তাদের নাম হল: রূবেণ বংশের মধ্যে সক্কূরের ছেলে শম্মূয়; ");
INSERT INTO benirv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","শিমিয়োন বংশের মধ্যে হোরির ছেলে শাফট; ");
INSERT INTO benirv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","যিহূদা বংশের মধ্যে যিফুন্নির ছেলে কালেব; ");
INSERT INTO benirv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ইষাখর বংশের মধ্যে যোষেফের ছেলে যিগাল; ");
INSERT INTO benirv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ইফ্রয়িম বংশের মধ্যে নূনের ছেলে হোশেয়; ");
INSERT INTO benirv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","বিন্যামীন বংশের মধ্যে রাফূর ছেলে পল্টি; ");
INSERT INTO benirv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","সবূলূন বংশের মধ্যে সোদির ছেলে গদ্দীয়েল; ");
INSERT INTO benirv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","যোষেফ বংশের অর্থাৎ মনঃশি বংশের মধ্যে সূষির ছেলে গদ্দি; ");
INSERT INTO benirv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","দান বংশের মধ্যে গমল্লির ছেলে অম্মীয়েল; ");
INSERT INTO benirv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","আশের বংশের মধ্যে মীখায়েলের ছেলে সথুর; ");
INSERT INTO benirv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","নপ্তালি বংশের মধ্যে বপ্সির ছেলে নহ্বি; ");
INSERT INTO benirv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","গাদ বংশের মধ্যে মাখির ছেলে গ্যূয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","মোশি যাদেরকে দেশ পরীক্ষা করতে পাঠালেন, এইগুলি সেই লোকেদের নাম। আর মোশি নূনের ছেলে হোশেয়ের নাম যিহোশূয় রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","কনান দেশ পরীক্ষা করতে পাঠাবার দিনের মোশি তাদেরকে বললেন, নেগেভ থেকে চলে যাও এবং পাহাড়ী অঞ্চলে গিয়ে ওঠ। ");
INSERT INTO benirv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","গিয়ে দেখ, সে দেশ কেমন ও সেখানে বসবাসকারী লোকেরা বলবান কি দুর্বল, অল্প কি অনেক ");
INSERT INTO benirv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","এবং তারা যে দেশে বাস করে সে দেশ কেমন, ভাল কি মন্দ? যে সব শহরে বাস করে, সেগুলি কি রকম? তারা কি শিবির পছন্দ করে নাকি শক্তিশালী শহর? ");
INSERT INTO benirv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","সেখানকার জমি কেমন দেখ, ফসল চাষের জন্য উর্বর কিনা এবং সেখানে গাছ আছে কি না। আর তোমরা সাহসী হও এবং সেই দেশের কিছু ফল সঙ্গে করে এনো। তখন প্রথম আঙ্গুর পাকার দিন ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","তাঁরা যাত্রা করে সীন মরুভূমি থেকে লেব-হমাতের কাছে রহোব পর্যন্ত সমস্ত দেশ পরীক্ষা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","তাঁরা নেগেভ থেকে চলে গিয়ে হিব্রোণে উপস্থিত হলেন। সেখানে অহীমান, শেশয় ও তল্ময়, অনাকের এই তিন সন্তান ছিল। মিশরের সোয়নের গড়ে উঠার সাত বছর আগে হিব্রোণ গড়ে ওঠে। ");
INSERT INTO benirv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","যখন তাঁরা ইষ্কোল উপত্যকাতে পৌঁছালেন, তাঁরা সেখানে এক গোছা আঙ্গুরের একটি শাখা কাটলেন। তাঁরা সেটা একটি লাঠিতে করে দুজন বহন করলেন। তাঁরা কতকগুলি ডালিম ও ডুমুরফলও সঙ্গে করে আনলেন। ");
INSERT INTO benirv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ইস্রায়েল সন্তানেরা ঐখানে সেই আঙ্গুরের গোছা কেটেছিলেন, তাই সেই উপত্যকা ইষ্কোল থলুয়া নামে পরিচিত হল। ");
INSERT INTO benirv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","তাঁরা দেশ পরীক্ষা করে চল্লিশ দিনের র পর ফিরে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","পরে তাঁরা এসে পারণ মরুপ্রান্তের কাদেশ নামক স্থানে মোশির ও হারোণের এবং ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীর কাছে উপস্থিত হয়ে তাদেরকে ও সমস্ত মণ্ডলীকে সংবাদ দিলেন এবং সেই দেশের ফল তাদেরকে দেখালেন। ");
INSERT INTO benirv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","তাঁরা মোশিকে বললেন, “আপনি আমাদেরকে যে দেশে পাঠিয়ে ছিলেন, আমরা সেখানে গিয়েছিলাম; দেশটিতে সত্যিই দুধ ও মধু প্রবাহিত হয়; আর এই দেখুন, তার ফল। ");
INSERT INTO benirv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","যাই হোক, সেখানকার লোকেরা যারা তাদের বাড়ি তৈরী করে, তারা বলবান ও সেখানকার শহরগুলি দেওয়ালে ঘেরা ও খুব বড়। সেখানে আমরা অনাকের সন্তানদেরকেও দেখেছি। ");
INSERT INTO benirv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","নেগেভে অমালেকরা বাস করে। পাহাড়ী অঞ্চলে হিত্তীয়, যিবূষীয় ও ইমোরীয়েরা বাস করে। মহা সমুদ্রের কাছে ও যর্দ্দনের তীরে কনানীয়েরা বাস করে।” ");
INSERT INTO benirv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","তখন কালেব মোশির সাক্ষাৎে লোকদেরকে উত্সাহ করার জন্য বললেন, “এস, আমরা একেবারে উঠে গিয়ে দেশ অধিকার করি; কারণ আমরা সেটা জয় করতে সমর্থ।” ");
INSERT INTO benirv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","কিন্তু যে ব্যক্তিরা তাঁর সঙ্গে গিয়েছিলেন, তাঁরা বললেন, “আমরা সেই লোকদের বিরুদ্ধে যেতে সমর্থ নই, কারণ আমাদের থেকে তারা বলবান।” ");
INSERT INTO benirv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","এই ভাবে তারা যে দেশ পরীক্ষা করতে গিয়েছিলেন, ইস্রায়েল সন্তানদের সাক্ষাৎে সেই দেশের সম্মন্ধে নিরুত্সাহ করে বললেন, “আমরা যে দেশ পরীক্ষা করতে স্থানে স্থানে গিয়েছিলাম, সে দেশ তার অধিবাসীদেরকে গ্রাস করে এবং তার মধ্যে আমরা যত লোককে দেখেছি, তারা সবাই অনেক বেশি উচ্চতার। ");
INSERT INTO benirv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","সেখানে আমরা নেফিলিমকে দেখলাম-অনাকের সন্তান নেফিলিমের থেকে এসেছে। তাদেরকে দেখে আমরা নিজেদের চোখে ফড়িঙ্গের মত এবং তাদের চোখেও সেই রকম হলাম।” ");
INSERT INTO benirv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","সেই রাত্রিতে সমস্ত মণ্ডলী খুব চিত্কার করল এবং কাঁদলো। ");
INSERT INTO benirv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ইস্রায়েল সন্তানরা সবাই মোশি ও হারোণের বিপরীতে সমালোচনা করল। সমস্ত মণ্ডলী তাদেরকে বলল, “হায় হায়, আমরা কেন এই মরুপ্রান্তের চেয়ে মিশর দেশে মারা যাই নি? ");
INSERT INTO benirv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","সদাপ্রভু আমাদেরকে তরোয়াল দিয়ে হত্যা করতে এ দেশে কেন আনলেন? আমাদের স্ত্রী ও বালকরা তো বিনষ্ট হবে। মিশরে ফিরে যাওয়া কি আমাদের জন্য ভাল নয়?” ");
INSERT INTO benirv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","তারা পরস্পর বলাবলি করল, “এস, আমরা অন্য এক জনকে শাসনকর্ত্তা করে মিশরে ফিরে যাই।” ");
INSERT INTO benirv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","তাতে মোশি ও হারোণ ইস্রায়েল সন্তানদের মণ্ডলীর সমস্ত সমাজের সামনে উপুড় হয়ে পড়লেন। ");
INSERT INTO benirv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","যারা দেশ পরীক্ষা করে এসেছিলেন, তাদের মধ্যে নূনের ছেলে যিহোশূয় ও যিফূন্নির ছেলে কালেব নিজেদের পোশাক ছিঁড়লেন। ");
INSERT INTO benirv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","তাঁরা ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে বললেন, “আমরা যে দেশ পরীক্ষা করতে গিয়েছিলাম, সেটি খুব ভালো দেশ। ");
INSERT INTO benirv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","সদাপ্রভু যদি আমাদের প্রতি সন্তুষ্ট হন, তবে তিনি আমাদেরকে সেই দেশে প্রবেশ করাবেন ও সেই দুধ ও মধু প্রবাহিত দেশ আমাদেরকে দেবেন। ");
INSERT INTO benirv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","কিন্তু তোমরা সদাপ্রভুর বিরুদ্ধে যেও না ও সে দেশের লোকেদেরকে ভয় কোরো না। কারণ তাদের খাবারের মতই সহজে গ্রাস করব। তাদের আশ্রয় তাদের উপর থেকে সরিয়ে নেওয়া হবে, কারণ সদাপ্রভু আমাদের সঙ্গে সঙ্গে আছেন। তাদেরকে ভয় কোরো না।” ");
INSERT INTO benirv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","কিন্তু সমস্ত মণ্ডলী সেই দুজনকে পাথরের আঘাতে হত্যা করতে বলল। তখন সমাগম তাঁবুতে সমস্ত ইস্রায়েলের লোকেদের মধ্যে সদাপ্রভুর মহিমা প্রকাশিত হল। ");
INSERT INTO benirv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","সদাপ্রভু মোশিকে বললেন, “এই লোকেরা আর কতকাল আমাকে অবজ্ঞা করবে? আমি এদের মধ্যে যেসব চিহ্ন কাজ করেছি, তা দেখেও এরা কতকাল আমার প্রতি বিশ্বাস করতে ব্যর্থ থাকবে? ");
INSERT INTO benirv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","আমি মহামারী দিয়ে এদেরকে আঘাত করব, এদেরকে অধিকার থেকে বঞ্চিত করব এবং তোমাকেই এদের থেকে বড় ও শক্তিশালী জাতি করব।” ");
INSERT INTO benirv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","তাতে মোশি সদাপ্রভুকে বললেন, “সেটা করলে মিশরীয়েরা তা শুনবে, কারণ তাদেরই মধ্যে থেকে তুমি নিজের শক্তি দিয়ে এই লোকেদেরকে এনেছ। ");
INSERT INTO benirv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","তারা এই দেশবাসী লোকেদেরও এটা বলবে। তারা শুনেছে যে, তুমি, সদাপ্রভু এই লোকেদের সঙ্গে থাক, কারণ তুমি, সদাপ্রভু মুখোমুখী দর্শন দাও, আর তোমার মেঘ এদের উপরে অবস্থান করছে এবং তুমি দিনের র বেলা মেঘস্তম্ভে ও রাতে অগ্নিস্তম্ভে থেকে এদের আগে আগে যাচ্ছ। ");
INSERT INTO benirv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","এখন যদি তুমি এই লোকেদেরকে একটি ব্যক্তির মত হত্যা কর, তবে ঐ যে জাতিরা তোমার সুনাম শুনেছে, তারা বলবে, ");
INSERT INTO benirv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘সদাপ্রভু এই লোকেদেরকে যে দেশ দিতে শপথ করেছিলেন, সেই দেশে তাদেরকে দিতে পারেননি; এই জন্য মরুপ্রান্তে তাদেরকে হত্যা করলেন’। ");
INSERT INTO benirv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","এখন, আমি তোমার কাছে অনুরোধ করি, তোমার মহান শক্তি ব্যবহার কর। যেমন তুমি বলেছ, ");
INSERT INTO benirv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘সদাপ্রভু ক্রোধে ধীর ও দয়াতে মহান এবং অধর্ম্মের ও অপরাধের ক্ষমাকারী, তবুও অবশ্যই পাপের শাস্তি দেন, তিনি তৃতীয় ও চতুর্থ পুরুষ পর্যন্ত সন্তানদের উপরে পূর্বপুরুষের অপরাধের শাস্তি দেন’। ");
INSERT INTO benirv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","অনুরোধ করি, তোমার দয়ার মহত্ত্ব অনুসারে এবং মিশর দেশ থেকে এ পর্যন্ত এই লোকেদেরকে যেমন ক্ষমা কর, সেইমত এই লোকেদের অপরাধ ক্ষমা কর।” ");
INSERT INTO benirv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","তখন সদাপ্রভু বললেন, “তোমার বাক্য অনুসারে আমি ক্ষমা করলাম। ");
INSERT INTO benirv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","সত্যিই আমি জীবন্ত এবং সমস্ত পৃথিবী সদাপ্রভুর মহিমায় পরিপূর্ণ হবে, ");
INSERT INTO benirv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","তাই যত লোক আমার মহিমা এবং মিশরে ও মরুপ্রান্তে করা আমার সমস্ত চিহ্ন কাজ দেখেছে, তবুও এই দশ বার আমার পরীক্ষা করেছে ও আমার কথা শোনেনি; ");
INSERT INTO benirv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","আমি তাদের পূর্বপুরুষদের কাছে যে দেশের বিষয়ে শপথ করেছি, তারা সেই দেশ দেখতে পাবে না; যারা আমাকে অবজ্ঞা করেছে, তাদের মধ্যে কেউই তা দেখতে পাবে না। ");
INSERT INTO benirv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","কিন্তু আমার দাস কালেবের অন্তরে অন্য আত্মা ছিল এবং সে সম্পূর্ণভাবে আমার অনুগত হয়ে চলেছে, এই জন্য সে যে দেশে গিয়েছিল, সে দেশে আমি তাকে প্রবেশ করাব ও তার বংশ সেটা অধিকার করবে। ");
INSERT INTO benirv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(অমালেকীয়েরা ও কনানীয়েরা উপত্যকায় বাস করছে।) কাল তোমরা ফিরে সূফসাগরের পথ দিয়ে মরুপ্রান্তে যাও।” ");
INSERT INTO benirv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“আমার বিরুদ্ধে মন্দ মণ্ডলীর আমি আর কতকাল সহ্য করব যারা আমার সমালোচনা করে? ইস্রায়েল সন্তানরা আমার বিরুদ্ধে যে যে অভিযোগ করে, তা আমি শুনেছি। ");
INSERT INTO benirv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","তুমি তাদেরকে বল, ‘সদাপ্রভু বলেন, আমি জীবন্ত, আমার কানের কাছে তোমরা যা বলেছ, তাই আমি তোমাদের প্রতি করব; ");
INSERT INTO benirv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","এই মরুপ্রান্তে তোমাদের মৃতদেহ পড়ে থাকবে; তোমাদের সম্পূর্ণ সংখ্যা অনুসারে গণনা করা কুড়ি বছর ও তার থেকে বয়সী তোমরা যে সমস্ত লোক আমার বিপরীতে বচসা করেছ, ");
INSERT INTO benirv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","আমি তোমাদেরকে যে দেশে বাস করাব বলে হাত তুলেছিলাম, সেই দেশে তোমরা প্রবেশ করবে না, শুধু যিফূন্নির ছেলে কালেব ও নূনের ছেলে যিহোশূয় প্রবেশ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","কিন্তু তোমরা তোমাদের যে বালকদের বিষয়ে বলেছিলে, তারা বিনষ্ট হবে, তাদেরকে আমি সেখানে প্রবেশ করাব ও তোমরা যে দেশ অগ্রাহ্য করেছ, তারা তার পরিচয় পাবে। ");
INSERT INTO benirv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","কিন্তু তোমাদের মৃতদেহ এই মরুপ্রান্তে পড়ে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","তোমাদের সন্তানরা চল্লিশ বছর এই মরুপ্রান্তে পশু চরাবে এবং এই মরুপ্রান্তে তোমাদের মৃতদেহের সংখ্যা যে পর্যন্ত সম্পূর্ণ না হয়, সে পর্যন্ত তারা তোমাদের ব্যভিচারের ফল ভোগ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","তোমরা যে চল্লিশ দিন দেশ পরীক্ষা করেছ, সেই দিনের র সংখ্যা অনুসারে চল্লিশ বছর, এক এক দিনের র জন্য এক এক বছর, তোমরা তোমাদের অপরাধ বহন করবে, আর আমার শত্রুতা কেমন, তা তোমরা জানবে’। ");
INSERT INTO benirv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","আমি, সদাপ্রভু, বলেছি, আমার বিপরীতে চক্রান্তকারী এই সমস্ত মন্দ মণ্ডলীর প্রতি আমি এইসব অবশ্যই করব; এই মরুপ্রান্তে তারা শেষ হবে, এখানেই তারা মারা যাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","আর দেশ পরীক্ষা করতে মোশি যে লোকেদেরকে পাঠিয়েছিলেন, যারা ফিরে এসে ঐ দেশের বদনাম করে তার বিরুদ্ধে সমস্ত মণ্ডলীকে দিয়ে অভিযোগ করিয়েছিল, ");
INSERT INTO benirv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","দেশের বদনামকারী সেই ব্যক্তিরা সদাপ্রভুর সামনে মহামারীতে মারা গেল। ");
INSERT INTO benirv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","যে ব্যক্তিরা পরীক্ষা করতে গিয়েছিল, তাদের মধ্যে শুধু নূনের ছেলে যিহোশূয় ও যিফূন্নির ছেলে কালেব জীবিত থাকলেন। ");
INSERT INTO benirv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","যখন মোশি সমস্ত ইস্রায়েল সন্তানকে সেই কথা বললেন, লোকেরা খুব শোক করল। ");
INSERT INTO benirv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","তারা ভোরে উঠে পর্বতের চূড়ায় উঠতে উদ্যত হয়ে বলল, “দেখ, আমরা এখানে, সদাপ্রভু যে স্থানের কথা বলেছেন, আমরা সেই স্থানে যাই, কারণ আমরা পাপ করেছি।” ");
INSERT INTO benirv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","কিন্তু মোশি বললেন, “এখন সদাপ্রভুর আদেশ কেন অমান্য করছ? তোমরা সফল হবে না। ");
INSERT INTO benirv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","তোমরা যেও না, কারণ সদাপ্রভু তোমাদের মধ্যে নেই, তাই গেলে তোমরা শত্রুদের কাছে পরাজিত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","কারণ অমালেকীয়েরা ও কনানীয়েরা সে স্থানে তোমাদের সামনে আছে; তোমরা তরোয়ালের আঘাতে মারা যাবে, কারণ তোমরা সদাপ্রভুর অনুসরণ করা থেকে পিছু ফিরেছ, তাই সদাপ্রভু তোমাদের সঙ্গে থাকবেন না।” ");
INSERT INTO benirv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","কিন্তু তারা দুঃসাহসী হয়ে পর্বতের চূড়ায় উঠতে লাগল; কিন্তু সদাপ্রভুর সাক্ষ্য-সিন্দুক ও মোশি শিবির ত্যাগ করলেন না। ");
INSERT INTO benirv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","তখন ঐ পর্বতবাসী অমালেকীয়েরা ও কনানীয়েরা নেমে এসে তাদেরকে আঘাত করল ও হর্মা পর্যন্ত তাদেরকে তাড়িয়ে দিল। ");
INSERT INTO benirv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","আর সদাপ্রভু মোশিকে বললেন, “তুমি ইস্রায়েল সন্তানদের বল, ");
INSERT INTO benirv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","তাদেরকে বল, ‘আমি তোমাদেরকে যে দেশ দেব, তোমাদের সেই দেশে প্রবেশ করার পর ");
INSERT INTO benirv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","যখন হয়তো হোমবলী কিংবা মানত পূর্ণ করার জন্য কিংবা ইচ্ছাদত্ত নৈবেদ্যের জন্য কিংবা তোমাদের নির্ধারিত পর্বে গরু ভেড়ার পাল থেকে সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য তোমরা আগুনে কোনো নৈবেদ্য তৈরী কর; ");
INSERT INTO benirv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","তখন উপহার উৎসর্গকারী ব্যক্তি সদাপ্রভুর উদ্দেশ্যে এক হিনের চার ভাগের এক অংশ তেলে মেশানো সূজির এক ঐফার দশ ভাগের এক অংশ ভক্ষ্য নৈবেদ্য আনবে এবং তুমি হোমবলির সঙ্গে, প্রত্যেকটি ভেড়ার বাচ্চার জন্য, ");
INSERT INTO benirv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","পেয় নৈবেদ্য হিসাবে এক হিনের চার ভাগের এক অংশ আঙ্গুর রস প্রস্তুত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","যদি তুমি একটি ভেড়া উত্সর্গ কর, তুমি অবশ্যই ভক্ষ্য নৈবেদ্য হিসাবে এক হিনের তিন ভাগের এক ভাগের সঙ্গে তেল মেশানো সূক্ষ্ম সূজির এক ঐফার দুই দশ ভাগের এক ভাগ প্রস্তুত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","পেয় নৈবেদ্যের জন্য আঙ্গুর রসের এক হিনের তিন ভাগের এক ভাগ উৎসর্গ করবে। এটা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধ দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","যখন তুমি সদাপ্রভুর উদ্দেশ্যে হোমবলির জন্য বা মানত পূরণের বলিদানের জন্য, কিংবা মঙ্গলার্থক বলির জন্য ষাঁড় উৎসর্গ করবে, ");
INSERT INTO benirv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","তখন ষাঁড়ের সঙ্গে অর্ধেক হিন তেলে মেশানো এক ঐফার তিনটি ভক্ষ্য নৈবেদ্য হিসাবে দশ ভাগের এক ভাগ করে সূজি আনবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","পেয় নৈবেদ্যের জন্য সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে উত্সর্গ করা উপহারের জন্য অর্ধেক হিন পরিমাপের আঙ্গুর রস আনবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","এক একটি ষাঁড়, ভেড়া, ভেড়ার বাচ্চা ও ছাগলের বাচ্চার জন্য এইরকম করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","তোমরা যত পশু উৎসর্গ করবে, তাদের সংখ্যা অনুসারে প্রত্যেকের জন্য এইরকম করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ইস্রায়েলে জন্মানো সমস্ত লোক যখন সদাপ্রভুর উদ্দেশ্যে সুগন্ধিযুক্ত আগুনে উত্সর্গ করা উপহার নিবেদন করার দিনের এই নিয়ম অনুসারে এইসব কিছু প্রস্তুত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","যদি তোমাদের মধ্যে বসবাসকারী কোন বিদেশী কিংবা তোমাদের মধ্যে তোমাদের বংশপরম্পরা অনুসারে বাসকারী কোন ব্যক্তি যদি সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধযুক্ত আগুনে উত্সর্গ উপহার নিবেদন করতে চায়, তবে তোমরা যেরকম, সেও সে রকম করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","সমস্ত গোষ্ঠী এবং তোমাদের মধ্যে বসবাসকারী বিদেশী লোক, উভয়ের জন্য তোমাদের বংশপরম্পরা অনুসারে একই রকম চিরস্থায়ী ব্যবস্থা হবে। সদাপ্রভুর কাছে তোমরা ও তোমাদের মধ্যে বসবাসকারী বিদেশীয়েরা, উভয়েই সমান। ");
INSERT INTO benirv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","তোমাদের ও তোমাদের মধ্যে বসবাসকারী বিদেশীয়দের জন্য একই ব্যবস্থা ও আদেশ হবে’।” ");
INSERT INTO benirv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","আবার সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","তুমি ইস্রায়েল সন্তানদের বল, তাদেরকে বল, আমি তোমাদেরকে যে দেশে নিয়ে যাচ্ছি, সে দেশে প্রবেশ করার পর ");
INSERT INTO benirv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","তোমরা সেই দেশের খাদ্য খাবার দিন সদাপ্রভুর উদ্দেশ্যে উপহার উত্সর্গ করবে এবং আমার সামনে উপস্থিত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","তোমরা উত্তোলনীয় উপহারের জন্য তোমাদের ছানা ময়দার প্রথম অংশ হিসাবে একটি পিঠে নিবেদন করবে; যেমন খামারের উত্তোলনীয় উপহার উত্তোলন করে থাক, এটাও সেই রকম করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","তোমরা বংশপরম্পরা অনুসারে তোমাদের ছানা ময়দার প্রথম অংশ থেকে সদাপ্রভুর উদ্দেশ্যে উত্তোলনীয় উপহার নিবেদন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","আর তোমরা যদি অনিচ্ছাকৃতভাবে পাপ কর, মোশির কাছে আমি যেসব আদেশ দিয়েছি, সেই সব যদি পালন না কর, ");
INSERT INTO benirv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","আমি যে দিনের তোমাদেরকে আদেশ দিয়েছি, তখন থেকে তোমাদের বংশপরম্পরার জন্য আমি মোশির হাতে তোমাদেরকে আদেশ দেওয়া শুরু করেছি। ");
INSERT INTO benirv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","যদি মণ্ডলীর অজান্তে অনিচ্ছাকৃতভাবে পাপ হয়ে থাকে, তবে সমস্ত মণ্ডলী সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধযুক্ত হোমবলির জন্য একটি ষাঁড় উত্সর্গ করবে। নিয়ম অনুসারে তার সঙ্গে ভক্ষ্য ও পেয় নৈবেদ্য এবং পাপার্থক বলির জন্য একটি পুরুষ ছাগল উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","যাজক ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীর জন্য প্রায়শ্চিত্ত করবে। তাতে তাদেরকে ক্ষমা করা হবে, কারণ তাদের পাপ অনিচ্ছাকৃতভাবে হয়েছে। তারা সেই তাদের সেই আগুনে উত্সর্গ করা উপহার আমার কাছে আনল। তারা আমার সামনে পাপার্থক বলি আনল। ");
INSERT INTO benirv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","তাতে ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীকে ও তাদের মধ্যে বসবাসী বিদেশীদেরকে ক্ষমা করা হবে; কারণ সব লোক অনিচ্ছাকৃতভাবে ঐ কাজ করল। ");
INSERT INTO benirv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","যদি কোন ব্যক্তি অনিচ্ছাকৃতভাবে পাপ করে, তবে সে পাপার্থক বলি হিসাবে এক বছরের একটি মেয়ে ছাগল আনবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","যাজক সদাপ্রভুর সামনে ওই ব্যক্তির জন্য প্রায়শ্চিত্ত করবে যে অনিচ্ছাকৃতভাবে পাপ করেছে। তার প্রায়শ্চিত্ত হলে তার পাপ ক্ষমা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ইস্রায়েল সন্তানরা হোক, কিংবা তাদের মধ্যে বসবাসী বিদেশী হোক, তোমাদের জন্য অনিচ্ছাকৃত পাপের একই ব্যবস্থা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","কিন্তু যে ব্যক্তি কোনো রকম পাপ করে, স্বদেশী বা বিদেশী, সে আমার নিন্দা করে; সেই ব্যক্তি নিজের লোকেদের মধ্যে থেকে উচ্ছিন্ন হবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","কারণ সে আমার বাক্য অবজ্ঞা করল ও আমার আদেশ অমান্য করল; সেই ব্যক্তি পুরোপুরি উচ্ছিন্ন হবে, তার অপরাধ তারই উপরে পড়বে। ");
INSERT INTO benirv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ইস্রায়েল সন্তানরা যখন মরুপ্রান্তে ছিল, তখন বিশ্রামদিনের এক জনকে কাঠ কুড়োতে দেখল। ");
INSERT INTO benirv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","যারা তাকে কাঠ কুড়োতে দেখেছিল, তারা মোশি, হারোণ ও সমস্ত মণ্ডলীর কাছে তাকে আনল। ");
INSERT INTO benirv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","তারা তাকে আটকে রাখল; কারণ তার প্রতি কি করা উচিত, সেটা বলা হয়নি। ");
INSERT INTO benirv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","তখন সদাপ্রভু মোশিকে বললেন, “সেই ব্যক্তির অবশ্যই প্রাণদণ্ড হবে; সমস্ত মণ্ডলী তাকে শিবিরের বাইরে পাথর দিয়ে আঘাত করে হত্যা করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","সুতরাং মোশির প্রতি সদাপ্রভুর আদেশ অনুসারে সমস্ত মণ্ডলী তাকে শিবিরের বাইরে নিয়ে গিয়ে পাথর দিয়ে আঘাত করল; তাতে সে মারা গেল। ");
INSERT INTO benirv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","সদাপ্রভু মোশিকে আবার বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“তুমি ইস্রায়েল সন্তানদের বল, তাদেরকে বল, ‘তারা বংশপরম্পরা অনুসারে তাদের পোশাকের কিনারায় আঁচল রাখবে ও কিনারার আঁচলে নীল সুতো ঝুলিয়ে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","তোমাদের জন্য সেই আঁচল থাকবে, যেন তা দেখে তোমরা সদাপ্রভুর সমস্ত আদেশ স্মরণ করে পালন কর এবং নিজেদের যে হৃদয় ও চোখের অনুকরণে তোমরা ব্যভিচারী হয়, তেমন আর না করো; ");
INSERT INTO benirv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","যেন আমার সমস্ত আদেশ মনে কর ও পালন কর এবং তোমার ঈশ্বরের উদ্দেশ্যে পবিত্র হও। ");
INSERT INTO benirv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","আমি সদাপ্রভু তোমাদের ঈশ্বর; আমি তোমাদের ঈশ্বর হবার জন্য তোমাদেরকে মিশর দেশ থেকে বের করে এনেছি; আমি সদাপ্রভু তোমাদের ঈশ্বর’।” ");
INSERT INTO benirv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","লেবির সন্তান কহাৎ, তাঁর সন্তান যিষ্‌হর, সেই যিষ্‌হরের সন্তান যে কোরহ, সে এবং রূবেণ সন্তানদের মধ্যে ইলীয়াবের ছেলে দাথন ও অবীরাম এবং পেলতের ছেলে ওন দল বাঁধলো; ");
INSERT INTO benirv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","আর ইস্রায়েল সন্তানদের দুশো পঞ্চাশ জনের সঙ্গে মোশির সামনে উঠল; এরা মণ্ডলীর শাসনকর্ত্তা, সমাজে ভালো ভাবে পরিচিত ও বিখ্যাত লোক ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","তারা মোশি ও হারোণের বিরুদ্ধে জড়ো হয়ে তাঁদেরকে বলল, “তোমরা বড়ই অভিমানী; কারণ সমস্ত মণ্ডলীর প্রত্যেক জনই পবিত্র এবং সদাপ্রভু তাহাদের মধ্যে আছেন; তবে তোমরা কেন সদাপ্রভুর সমাজের উপরে নিজেদেরকে উন্নত করছ?” ");
INSERT INTO benirv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","তখন মোশি তা শুনে উপুড় হয়ে পড়লেন। ");
INSERT INTO benirv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","তিনি কোরহকে ও তার দলের সবাইকে বললেন, “কে সদাপ্রভুর লোক ও কে পবিত্র, কাকে তিনি নিজের কাছাকাছি রাখেন, তা সদাপ্রভু সকালে জানাবেন; তিনি যাকে মনোনীত করবেন, তাকেই নিজের কাছাকাছি রাখবেন। ");
INSERT INTO benirv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","হে কোরহ ও কোরহের দলের সকলে, এক কাজ কর; তোমরা ধুনুচি নাও ");
INSERT INTO benirv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","এবং তাতে আগুন দিয়ে কাল সদাপ্রভুর সামনে তার উপরে ধূপ দাও; তাতে সদাপ্রভু যাকে মনোনীত করবেন, সেই ব্যক্তি পবিত্র হবে; হে লেবির সন্তানরা, তোমরা বড়ই অভিমানী।” ");
INSERT INTO benirv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","মোশি কোরহকে আবার বললেন, “হে লেবির সন্তানরা, অনুরোধ করি, আমার কথা শোনো। ");
INSERT INTO benirv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","এটা কি তোমাদের কাছে খুব ছোট বিষয় যে, ইস্রায়েলের ঈশ্বর তোমাদেরকে ইস্রায়েল মণ্ডলী থেকে আলাদা করে সদাপ্রভুর সমাগম তাঁবুর সেবা কাজ করার জন্য ও মণ্ডলীর সামনে দাঁড়িয়ে তাঁর পরিচর্য্যা করার জন্য নিজের কাছাকাছি এনেছেন? ");
INSERT INTO benirv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","তিনি তোমাকে ও তোমার সঙ্গে তোমার সমস্ত ভাইকে অর্থাৎ লেবির সন্তানদের নিজের কাছাকাছি এনেছেন, তোমরা কি যাজক হওয়ারও চেষ্টা করছ? ");
INSERT INTO benirv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","তার জন্য তুমি ও তোমার সমস্ত দল সদাপ্রভুরই বিরুদ্ধে জড়ো হয়েছ; আর হারোণ কে যে, তোমরা তার বিরুদ্ধে অভিযোগ কর?” ");
INSERT INTO benirv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","তখন মোশি ইলীয়াবের ছেলে দাথন ও অবীরামকে ডাকতে লোক পাঠালেন, কিন্তু তারা বলল, “আমরা যাব না। ");
INSERT INTO benirv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","এটা কি খুব ছোট বিষয় যে, তুমি আমাদেরকে মরুপ্রান্তে মারবার জন্য দুধ মধু প্রবাহিত দেশ থেকে এনেছ? তুমি কি আমাদের উপরে কর্তৃত্বও করবে? ");
INSERT INTO benirv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","আর, তুমি তো আমাদেরকে দুধ মধু প্রবাহিত দেশে আন নি, ভূমি ও আঙ্গুর ক্ষেতের অধিকারও দাও নি। তুমি কি মিথ্যা প্রতিজ্ঞা করে আমাদের অন্ধ করতে চাও? আমরা যাব না।” ");
INSERT INTO benirv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","মোশি খুব রেগে গিয়ে সদাপ্রভুকে বললেন, “ওদের নৈবেদ্য গ্রহণ কোরো না; আমি ওদের থেকে একটি গাধাও নিই নি এবং আমি তাদের হিংসা করি নি।” ");
INSERT INTO benirv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","তখন মোশি কোরহকে বললেন, “তুমি ও তোমার দলের সবাই, তোমরা কাল হারোণের সঙ্গে সদাপ্রভুর সামনে উপস্থিত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","প্রত্যেক জন ধুনুচি নিয়ে তার উপরে ধূপ দিয়ে সদাপ্রভুর সামনে নিজেদের ধুনুচি আনবে; দুশো পঞ্চাশটি ধুনুচি নিয়ে আসবে। তুমি ও হারোণ নিজেদের ধুনুচি আনবে।” ");
INSERT INTO benirv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","সুতরাং তারা প্রত্যেকে নিজেদের ধুনুচি নিয়ে তার মধ্যে আগুন রেখে ধূপ দিয়ে মোশি ও হারোণের সঙ্গে সমাগম তাঁবুর প্রবেশপথে দাঁড়াল। ");
INSERT INTO benirv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","কোরহ সমাগম তাঁবুর প্রবেশপথে মোশি ও হারোণের বিরুদ্ধে সমস্ত মণ্ডলীকে জড়ো করল। তখন সদাপ্রভুর মহিমা সমস্ত মণ্ডলীতে প্রকাশিত হল। ");
INSERT INTO benirv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","তখন সদাপ্রভু মোশি ও হারোণকে বললেন, “তোমরা এই মণ্ডলীর মধ্যে থেকে আলাদা হও; ");
INSERT INTO benirv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","আমি এক্ষুনি এদেরকে হত্যা করি।” ");
INSERT INTO benirv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","মোশি ও হারোণ উপুড় হয়ে পড়লেন ও বললেন, “হে ঈশ্বর, সমস্ত মানুষ জাতির আত্মার ঈশ্বর, একজন পাপ করলে তুমি কি সমস্ত মণ্ডলীর উপরে প্রচণ্ড রাগ দেখাবে?” ");
INSERT INTO benirv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“তুমি মণ্ডলীকে বল, ‘তোমরা কোরহের, দাথনের ও অবীরামের তাঁবুর চারদিক থেকে উঠে যাও’।” ");
INSERT INTO benirv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","তখন মোশি উঠে দাথনের ও অবীরামের কাছে গেলেন এবং ইস্রায়েলের প্রাচীনেরা তাঁর পিছু পিছু গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","তিনি মণ্ডলীকে বললেন, “অনুরোধ করি, তোমরা এই দুষ্টু লোকেদের তাঁবুর কাছ থেকে উঠে যাও, এদের কিছুই স্পর্শ কোরো না, না হলে এদের সমস্ত পাপে বিনষ্ট হও।” ");
INSERT INTO benirv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","তাতে তারা কোরহের, দাথনের ও অবীরামের তাঁবুর চারদিক থেকে উঠে গেল, আর দাথন ও অবীরাম বের হয়ে নিজের স্ত্রী, ছেলে ও শিশুদের সঙ্গে তাদের তাঁবুর প্রবেশপথে দাঁড়িয়ে থাকল। ");
INSERT INTO benirv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","পরে মোশি বললেন, সদাপ্রভু আমাকে এই সমস্ত কাজ করতে পাঠিয়েছেন, আমি নিজের ইচ্ছায় করি নি, সেটা তোমরা এতেই জানতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","সাধারণ লোকেদের মারা যাবার মত যদি এই মানুষরা মারা যায়, কিংবা সাধারণ লোকেদের শাস্তির মত যদি এদের শাস্তি হয়, তবে সদাপ্রভু আমাকে পাঠান নি। ");
INSERT INTO benirv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","কিন্তু সদাপ্রভু যদি খারাপ কিছু ঘটান এবং ভূমিতার মুখ খুলে এদেরকে ও এদের সবকিছু গিলে ফেলে, আর এরা জীবন্ত অবস্থায় পাতালে নামে, তবে এরা যে সদাপ্রভুকে অবজ্ঞা করেছে, তা তোমরা জানতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","খুব তাড়াতাড়ি মোশি তাঁর সমস্ত কথা শেষ করলেন, তাদের নিচের ভূমি খুলে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","পৃথিবী তার মুখ খুলে তাদেরকে, তাদের আত্মীয়দেরকে ও কোরহের পক্ষের সমস্ত লোককে এবং তাদের সমস্ত সম্পত্তি গিলে ফেলল। ");
INSERT INTO benirv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","তাতে তারা ও তাদের সমস্ত আত্মীয় জীবন্ত অবস্থায় পাতালে নেমে গেল এবং পৃথিবী তাদের উপরে চেপে পড়ল এবং এই ভাবে তারা সমাজের মধ্যে থেকে লুপ্ত হল। ");
INSERT INTO benirv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","তাদের চিত্কারে চারদিকের সমস্ত ইস্রায়েল পালিয়ে গেল, কারণ তারা বলল, “না হলে পৃথিবী আমাদেরকে গিলে ফেলে।” ");
INSERT INTO benirv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","তখন সদাপ্রভুর থেকে আগুন বেরিয়ে যারা ধূপ নিবেদন করেছিল, সেই দুশো পঞ্চাশ জন লোককে গিলে ফেলল। ");
INSERT INTO benirv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“তুমি হারোণ যাজকের ছেলে ইলীয়াসরকে বল, সেই পোড়ানো স্থান থেকে ঐ সমস্ত ধুনুচি উঠিয়ে নিক এবং তার আগুন দূরে ঝেড়ে ফেলুক, কারণ সেই সব ধুনুচি পবিত্র। ");
INSERT INTO benirv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ঐ যে পাপীরা নিজেদের প্রাণের বিরুদ্ধে পাপ করেছিল, তাদের ধুনুচিগুলি পিটিয়ে যজ্ঞবেদির ঢাকা দেবার পাত তৈরী করা হোক, কারণ তারা সদাপ্রভুর সামনে সে সমস্ত নিবেদন করেছিল, সুতরাং সেই সমস্ত পবিত্র। আর সেই সব ইস্রায়েল সন্তানদের পক্ষে চিহ্ন হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","তাতে যারা পুড়ে মারা গেল, তারা পিতলের যে যে ধুনুচি নিবেদন করেছিল, ইলীয়াসর যাজক সে সব গ্রহণ করলেন এবং তা পিটিয়ে যজ্ঞবেদির ঢাকা দেবার জন্য পাত প্রস্তুত করা হল; ");
INSERT INTO benirv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ওটা ইস্রায়েল সন্তানদের স্মরণের জন্য হল, যেন হারোণ বংশ ছাড়া অন্য গোষ্ঠীর কোন মানুষ সদাপ্রভুর সামনে ধূপ উৎসর্গ করতে কাছে না যায় এবং কোরহের ও তার দলের মত না হয়; সদাপ্রভু মোশির মাধ্যমে তাকে এইরকম আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","কিন্তু তারপরের দিনের ইস্রায়েল সন্তানদের সমস্ত মণ্ডলী মোশির ও হারোণের বিরুদ্ধে অভিযোগ করে বলল, “তোমরাই সদাপ্রভুর প্রজাদেরকে হত্যা করলে।” ");
INSERT INTO benirv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","তখন এটা হল, মণ্ডলী মোশির হারোণের বিরুদ্ধে জড়ো হলে তারা সমাগম তাঁবুর দিকে মুখ ফেরাল, আর তারা দেখল, মেঘ সমাগম তাঁবু ঢেকে দিয়েছে এবং সদাপ্রভুর মহিমা প্রকাশিত হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","তখন মোশি ও হারোণ সমাগম তাঁবুর সামনে উপস্থিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“তোমরা এই মণ্ডলীর মধ্যে থেকে উঠে যাও, আমি এক্ষুনি এদেরকে হত্যা করব।” তখন মোশি ও হারোণ উপুড় হয়ে পড়লেন। ");
INSERT INTO benirv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","মোশি হারোণকে বললেন, “তোমার ধুনুচি নাও ও যজ্ঞবেদির উপর থেকে আগুন নিয়ে তার মধ্যে দাও এবং তাতে ধূপ দিয়ে তাড়াতাড়ি মণ্ডলীর কাছে গিয়ে তাদের জন্য প্রায়শ্চিত্ত কর; কারণ সদাপ্রভুর সামনে থেকে রোষ নির্গত হল, মহামারী আরম্ভ হল।” ");
INSERT INTO benirv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","সুতরাং মোশি যেমন বললেন, তেমনি হারোণ ধুনুচি নিয়ে সমাজের মধ্যে দৌড়ে গেলেন; আর দেখ, লোকেদের মধ্যে মহামারী আরম্ভ হয়েছিল, কিন্তু তিনি ধূপ দিয়ে লোকেদের জন্য প্রায়শ্চিত্ত করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","তিনি মৃত ও জীবিত লোকেদের মধ্যে দাঁড়ালেন; তাতে মহামারী থেমে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","যারা কোরহের ব্যাপারে মারা গেছে, তারা ছাড়া আর চৌদ্দ হাজার সাতশো লোক ঐ মহামারীতে মারা গেল। ");
INSERT INTO benirv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","হারোণ সমাগম তাঁবুর প্রবেশপথে মোশির কাছে ফিরে আসলেন। এই ভাবে মহামারী শেষ হল। ");
INSERT INTO benirv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“তুমি ইস্রায়েল সন্তানদের বলে তাদের পূর্বপুরুষ অনুসারে সমস্ত নেতার থেকে এক একটি গোষ্ঠীর জন্য এক একটি লাঠি, এই ভাবে বারোটি লাঠি গ্রহণ কর; প্রত্যেকের লাঠিতে তার নাম লেখ। ");
INSERT INTO benirv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","লেবির লাঠিতে হারোণের নাম লেখ; কারণ তাদের এক একটি পূর্বপুরুষের জন্য এক একটি লাঠি হবে। ");
INSERT INTO benirv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","সমাগম তাঁবুতে যে স্থানে আমি তোমাদের সঙ্গে দেখা করি, সেই স্থানে সাক্ষ্য সিন্দুকের সামনে সেগুলি রাখবে। ");
INSERT INTO benirv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","এইরকম হবে, যে ব্যক্তি আমার মনোনীত, তার লাঠিতে কুঁড়ি হবে, তাতে ইস্রায়েল সন্তানরা তোমাদের বিরুদ্ধে যে যে অভিযোগ করে, সেটা আমি নিজের কাছ থেকে বন্ধ করব।” ");
INSERT INTO benirv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","সুতরাং মোশি ইস্রায়েল সন্তানদের এইসব বললে তাদের বংশের নেতারা তাদের পূর্বপুরুষ অনুসারে এক একটি নেতার জন্য এক একটি লাঠি, এই ভাবে বারোটি লাঠি, তাকে দিলেন এবং হারোণের লাঠি তাদের লাঠিগুলির মধ্যে ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","তখন মোশি ঐ সমস্ত যষ্টি নিয়ে সাক্ষ্য তাঁবুতে সদাপ্রভুর সামনে রাখলেন। ");
INSERT INTO benirv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","পরের দিন মোশি সাক্ষ্য তাঁবুতে প্রবেশ করলেন, আর দেখ, লেবি বংশের জন্য হারোণের লাঠি অঙ্কুর বের হয়ে, কুঁড়ি ধরে ও ফুল হয়ে বাদাম ফল ধরেছে। ");
INSERT INTO benirv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","তখন মোশি সদাপ্রভুর সামনে থেকে ঐ সব লাঠি বের করে সমস্ত ইস্রায়েল সন্তানের সাক্ষাৎে আনলেন এবং তারা সেটা দেখে প্রত্যেকে নিজেদের লাঠি গ্রহণ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","সদাপ্রভু মোশিকে বললেন, “তুমি হারোণের লাঠি আবার সাক্ষ্য সিন্দুকের সামনে রাখ, এটা লোকেদের অপরাধের বিরুদ্ধে একটি চিহ্ন হিসাবে রাখ যারা বিদ্রোহ করেছে, সুতরাং অভিযোগ শেষ কর, যেন এরা না মরে।” ");
INSERT INTO benirv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","মোশি তাই করলেন; সদাপ্রভু তাঁকে যেরকম আদেশ দিয়েছিলেন, তিনি সেই রকম করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ইস্রায়েল সন্তানরা মোশিকে বলল, “দেখ, আমরা এখানে মারা যাব। আমরা সবাই বিনষ্ট হব! ");
INSERT INTO benirv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","যে কেউ কাছে যায়, সদাপ্রভুর সমাগম তাঁবুর কাছে যায়, সেই মারা যাবে। আমরা কি সবাই মারা পড়ব?” ");
INSERT INTO benirv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","সদাপ্রভু হারোণকে বললেন, “তুমি ও তোমার সঙ্গে তোমার ছেলেরা ও তোমার পূর্বপুরুষ, তোমরা পবিত্র স্থানের বিরুদ্ধে সমস্ত অপরাধ বহন করবে। কিন্তু কেবল তুমি ও তোমার সঙ্গে তোমার ছেলেরা তোমাদের যাজক পদের অপরাধ বহন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","তোমার ভাইয়েরা, যে লেবি বংশ তোমার পূর্বপুরুষ, তাদেরকেও সঙ্গে আনবে, তারা তোমার সঙ্গে যোগ দেবে ও সাহায্য করবে এবং তোমার ছেলেরা, তোমরা সাক্ষ্য তাঁবুর সামনে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","তারা তোমার ও সমস্ত তাঁবুর সেবা করবে। কিন্তু তারা পবিত্র স্থানের পাত্রের ও বেদির কাছে যাবে না, নাহলে তাদের সাথে তোমরাও মারা যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","তারা তোমরা সঙ্গে যোগ দিয়ে তাঁবুর সমস্ত কাজের সঙ্গে যুক্ত সমাগম তাঁবুর দেখাশোনা করবে। কোনো বিদেশী তোমাদের কাছে যাবে না। ");
INSERT INTO benirv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ইস্রায়েল সন্তানদের উপর যেন আর রাগ উপস্থিত না হয়, এই জন্য তোমরা পবিত্রস্থান ও বেদি রক্ষার দায়িত্ব নেবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","আর দেখ, ইস্রায়েল সন্তানদের মধ্যে থেকে আমি তোমাদের ভাই লেবীয়দেরকে মনোনীত করলাম। তারা তোমাদের জন্য উপহার হিসাবে সমাগম তাঁবুর কাজ করতে আমাকে দেওয়া হয়েছে। ");
INSERT INTO benirv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","কিন্তু কেবল তুমি ও তোমার ছেলেরা বেদির সমস্ত বিষয়ে ও পর্দার ভিতরের বিষয়ে নিয়ে যাজকত্ব পালন করবে ও তুমি নিজে সেই দায়িত্ব পূর্ণ করবে। আমি উপহার হিসাবে যাজকত্বপদ তোমাদেরকে দিলাম। কিন্তু কোনো বিদেশী কাছাকাছি হলে, তার প্রাণদণ্ড হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","তখন সদাপ্রভু হারোণকে বললেন, “দেখ, আমার সামনে তোলা উপহারের, এমন কি, ইস্রায়েল সন্তানদের সমস্ত পবিত্র করা দ্রব্যের ভার আমি তোমাকে দিলাম; অভিষিক্ত করে তোমাকে ও তোমার সন্তানদের চিরস্থায়ী অধিকার হিসাবে সে সমস্ত দিলাম। ");
INSERT INTO benirv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","আগুনের দ্বারা অতি পবিত্র উপহারের মধ্যে এইসব কিছু তোমার হবে। আমার উদ্দেশ্যে তাদের আনা প্রত্যেক ভক্ষ্য নৈবেদ্য, প্রত্যেক পাপার্থক বলি ও দোষার্থক বলি সব কিছু তোমার ও তোমার ছেলেদের পক্ষে অতি পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","তুমি তা অতি পবিত্র বস্তু হিসাবে খাবে, প্রত্যেক পুরুষ তা খাবে, তা তোমার পক্ষে পবিত্র হবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","এই সমস্ত নৈবেদ্যও তোমার হবে; ইস্রায়েল সন্তানদের উপহার হিসাবে উত্তোলনীয় নৈবেদ্য, তাদের আমার কাছে উপস্থিত করা সমস্ত উপহার। আমি চিরস্থায়ী অধিকারের জন্য সে সমস্ত তোমাকে ও তোমার ছেলেদেরকে ও তোমার মেয়েদেরকে দিলাম; তোমার কুলের সব শুচি ব্যক্তি তা খাবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","তারা সদাপ্রভুর উদ্দেশ্যে নিজেদের সমস্ত উত্তম তেল, আঙ্গুর রস ও গম প্রভৃতি যে যে প্রথম অংশ উৎসর্গ করে, তা আমি তোমাকে দিলাম। ");
INSERT INTO benirv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","তাদের দেশে উৎপন্ন যে সমস্ত প্রথম পাকা ফল আমার কাছে উপস্থিত করে, সে সমস্ত তোমার হবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ইস্রায়েলের মধ্যে সমস্ত উত্সর্গ করা বস্তু তোমার হবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","মানুষ হোক কিংবা পশু, সমস্ত প্রাণীর মধ্যে প্রথমজাত যা কিছু তারা সদাপ্রভুর উদ্দেশ্যে নিবেদন করবে, সে সবই তোমার হবে। কিন্তু মানুষের প্রথমজাতকে তুমি অবশ্যই মুক্ত করবে এবং অশুচি পশুর প্রথমজাতকেও মুক্ত করবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","তুমি এক মাস বয়সী মোচনীয় সবাইকে মুক্ত করবে, তোমার নির্ধারিত মূল্যে পবিত্র স্থানের কুড়ি গেরা পরিমাপের শেকল অনুসারে পাঁচ শেকল রূপা দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","কিন্তু গরুর প্রথমজাতকে কিংবা ভেড়ার প্রথমজাতকে কিংবা ছাগলের প্রথমজাতকে তুমি মুক্ত করবে না, তারা পবিত্র; তুমি বেদির উপরে তাদের রক্ত ছিটাবে এবং আমার উদ্দেশ্যে মিষ্টি সুগন্ধযুক্ত আগুনে তৈরী উপহারের জন্য তাদের মেদ পোড়াবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","তাদের মাংস তোমার। যেমন দোলনীয় বক্ষঃ ও ডানদিকের থাই, তাদের মাংসও তোমার হবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ইস্রায়েল সন্তানরা যে সমস্ত পবিত্র বস্তু উত্তোলনীয় উপহার হিসাবে সদাপ্রভুর উদ্দেশ্যে নিবেদন করে, সেই সব আমি চিরস্থায়ী অধিকারের জন্য তোমাকে ও তোমার ছেলেদেরকে ও তোমার মেয়েদেরকে দিলাম; তোমার ও তোমার বংশের পক্ষে এটা আমার সাক্ষাৎে চিরস্থায়ী লবণের নিয়ম।” ");
INSERT INTO benirv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","সদাপ্রভু হারোণকে বললেন, “তাদের ভূমিতে তোমার কোন অধিকার থাকবে না ও তাদের মধ্যে তোমার কোন অংশ থাকবে না; ইস্রায়েল সন্তানদের মধ্যে আমিই তোমার অংশ ও অধিকার। ");
INSERT INTO benirv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","আর দেখ, লেবির সন্তানরা যে সেবা কাজ করছে, সমাগম তাঁবুতে তাদের সেই সেবা কাজের বেতন হিসাবে আমি তাদের অধিকারের জন্য ইস্রায়েলের মধ্যে সমস্ত দশমাংশ দিলাম। ");
INSERT INTO benirv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","আর ইস্রায়েল সন্তানরা পাপ বহন করে যাতে না মরে, এই জন্য তারা আর সমাগম তাঁবুর কাছে আসবে না। ");
INSERT INTO benirv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","কিন্তু লেবীয়েরাই সমাগম তাঁবুর সেবা কাজ করবে এবং তারা নিজের পাপ বহন করবে, এটা তোমাদের বংশ পরম্পরা অনুসারে চিরস্থায়ী বিধি; ইস্রায়েল সন্তানদের মধ্যে তারা কোন অধিকার পাবে না। ");
INSERT INTO benirv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","কারণ ইস্রায়েল সন্তানরা সদাপ্রভুর উদ্দেশ্যে উত্তোলনীয় উপহার হিসাবে যে দশমাংশ উৎসর্গ করে, তা আমি লেবীয়দের অধিকারে দিলাম; এই জন্য তাদের উদ্দেশ্যে বললাম, ইস্রায়েল সন্তানদের মধ্যে তারা কোন অধিকার পাবে না।” ");
INSERT INTO benirv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“আবার তুমি লেবীয়দেরকে বলবে, তাদেরকে বলবে, ‘আমি তোমাদের অধিকারের জন্য ইস্রায়েল সন্তানদের থেকে যে দশমাংশ তোমাদেরকে দিলাম, তা যখন তোমরা তাদের থেকে গ্রহণ করবে, তখন তোমরা সদাপ্রভুর জন্য উত্তোলনীয় উপহার হিসাবে সেই দশমাংশের দশমাংশ নিবেদন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","তোমাদের উত্তোলনীয় উপহার খামারের শস্যের মত ও আঙ্গুর কুণ্ডের পূর্ণতার মত তোমাদের পক্ষে গণনা করা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","এই ভাবে, তোমরা ইস্রায়েল সন্তানদের থেকে যে সমস্ত দশমাংশ গ্রহণ করবে, তা থেকে তোমরাও সদাপ্রভুর উদ্দেশ্যে উত্তোলনীয় উপহার নিবেদন করবে এবং তা থেকে সদাপ্রভুর সেই উত্তোলনীয় উপহার হারোণ যাজককে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","তোমাদের পাওয়া সমস্ত দান থেকে তোমরা সদাপ্রভুর সেই উত্তোলনীয় উপহার, তার সমস্ত উত্তম বস্তু থেকে তার পবিত্র অংশ, নিবেদন করবে’। ");
INSERT INTO benirv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","অতএব তুমি তাদেরকে বলবে, তোমরা যখন তার থেকে উত্তম বস্তু উত্তোলনীয় উপহার হিসাবে নিবেদন করবে, সেই দিনের তা লেবীয়দের পক্ষে খামারের উৎপন্ন দ্রব্য ও আঙ্গুর কুণ্ডের উৎপন্ন দ্রব্য হিসাবে গণনা করা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","তোমরা তোমাদের আত্মীয়রা যে কোনো জায়গায় তা খাবে; কারণ তা সমাগম তাঁবুতে করা কাজের জন্য তোমাদের বেতন স্বরূপ। ");
INSERT INTO benirv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","এগুলি খাওয়া ও পান করার জন্য তোমরা কোনো পাপ বহন করবে না, যদি সেই উত্তম বস্তু উপহার হিসাবে সদাপ্রভুকে নিবেদন কর। ইস্রায়েল সন্তানদের পবিত্র বস্তু অপবিত্র করবে না ও মারা পড়বে না।” ");
INSERT INTO benirv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“এটি একটি বিধি, একটি ব্যবস্থা, যেটা আমি আদেশ করছি: তা এই ইস্রায়েল সন্তানদের বল, তারা নির্দোষ ও কলঙ্ক বিহীন, যোয়ালি বহন করে নি, এমন একটি লাল গাভী তোমার কাছে আনুক। ");
INSERT INTO benirv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","তোমরা ইলীয়াসর যাজককে সেই গাভী দেবে এবং সে তাকে শিবিরের বাইরে নিয়ে যাবে এবং তার সামনে তাকে হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","পরে ইলীয়াসর যাজক তার আঙ্গুল দিয়ে তার কিছুটা রক্ত নিয়ে সমাগম তাঁবুর সামনে সাত বার সেই রক্ত ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","তার চোখের সামনে সেই গাভী পোড়ানো হবে; তার গোবরের সঙ্গে চামড়া, মাংস ও রক্ত পোড়ানো হবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","যাজক এরসকাঠ, এসোব ও লাল রঙের লোম নিয়ে ঐ গরু পোড়ানো আগুনের মধ্যে ফেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","তখন যাজক তার পোশাক ধোবে ও শরীর জলে ধোবে। পরে শিবিরে প্রবেশ করতে পারবে, যদিও যাজক সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","আর যে ব্যক্তি সেই গাভী পোড়াবে, সেও তার পোশাক জলে ধোবে ও শরীর জলে ধোবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","কোন শুচি ব্যক্তি ঐ গাভীর ছাই সংগ্রহ করে শিবিরের বাইরে কোন শুচি স্থানে রাখবে; তা ইস্রায়েল সন্তানদের মণ্ডলীর বিশুদ্ধ জলের জন্য রাখা যাবে; এটি পাপার্থক বলি। ");
INSERT INTO benirv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","যে ব্যক্তি ঐ গাভীর ভস্ম জড়ো করবে, সে তার পোশাক ধোবে এবং সন্ধ্যা পর্যন্ত অশুচি থাকবে; এটা ইস্রায়েল সন্তানদের এবং তাদের মধ্যে বসবাসকারী বিদেশীর পালন করার জন্য চিরস্থায়ী নিয়ম হবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","যে কেউ কোন মানুষের মৃত দেহ স্পর্শ করে, সে সাত দিন অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","সে তৃতীয় দিনের ও সপ্তম দিনের ঐ জল দিয়ে নিজেকে পাপমুক্ত করবে, পরে শুচি হবে; কিন্তু যদি তৃতীয় দিনের ও সপ্তম দিনের নিজেকে পাপমুক্ত না করে, তবে শুচি হবে না। ");
INSERT INTO benirv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","যে কেউ কোন মানুষের মৃত দেহ স্পর্শ করে নিজেকে পাপমুক্ত না করে, সে সদাপ্রভুর সমাগম তাঁবু অশুচি করে। সেই প্রাণী ইস্রায়েলের মধ্যে থেকে উচ্ছিন্ন হবে; কারণ তার উপরে বিশুদ্ধ জল সেচন হয়নি, এই জন্য সে অশুচি হবে; তার অশুচিতা তাতে অবস্থান করছে। ");
INSERT INTO benirv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","কোন মানুষ যখন তাঁবুর মধ্যে মারা যায় এটা সেই ব্যবস্থা। সেই তাঁবুতে প্রবেশকারী সমস্ত লোক এবং সেই তাঁবুর মধ্যে অবস্থিত সমস্ত লোক সাত দিন অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","সমস্ত খোলা পাত্র, ঢাকনা ছাড়া পাত্র, অশুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","একইভাবে, যে কেউ তাঁবুর বাইরে এমন কাউকে স্পর্শ করে, যে তরোয়াল দিয়ে হত্যা হয়েছে কিংবা কোনো মৃতদেহ বা মানুষের হাড় অথবা কবর স্পর্শ করে, সে সাত দিন অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","সেই অশুচি ব্যক্তির এটা করবে: পাপার্থক বলিদানের কিছুটা ভস্ম নেবে এবং স্রোতের জলের সঙ্গে একটি পাত্রে সেগুলি মেশাবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","পরে কোন শুচি ব্যক্তি এসোব নিয়ে সেই জলে ডুবিয়ে ঐ তাঁবুর উপরে ও সেই স্থানের সমস্ত জিনিসের ও সমস্ত প্রাণীর উপরে এবং হাড়ের কিংবা নিহত বা মৃতদেহে অথবা কবর স্পর্শকারী ব্যক্তির উপরে সেটা ছিটিয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ঐ শুচি ব্যক্তি তৃতীয় দিনের ও সপ্তম দিনের অশুচির উপরে সেই জল ছিটিয়ে দেবে; পরে সপ্তম দিনের সে তাকে পাপমুক্ত করবে এবং ঐ ব্যক্তি তার পোশাক ধোবে এবং জলে স্নান করবে; পরে সন্ধ্যাবেলায় শুচি হবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","কিন্তু যে ব্যক্তি অশুচি হয়ে নিজেকে পাপমুক্ত না করে, সে সমাজের মধ্যে থেকে উচ্ছিন্ন হবে, কারণ সদাপ্রভুর পবিত্র স্থান অশুচি করেছে; তার উপরে বিশুদ্ধ জল ছেটানো হয়নি, সে অশুচি। ");
INSERT INTO benirv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","এটা তাদের পালন করার চিরস্থায়ী নিয়ম হবে এবং যে কেউ সেই বিশুদ্ধ জল ছিটিয়ে দেয়, সে তার পোশাক ধোবে এবং যে কেউ সেই বিশুদ্ধ জল স্পর্শ করে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","সেই অশুচি ব্যক্তি যা কিছু স্পর্শ করে, তা অশুচি হবে এবং যে প্রাণী তা স্পর্শ করে, সে সন্ধ্যা পর্যন্ত অশুচি থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ইস্রায়েল সন্তানরা, অর্থাৎ সমস্ত মণ্ডলী প্রথম মাসে সীন মরুপ্রান্তে উপস্থিত হল এবং লোকেরা কাদেশে বাস করল; আর সেখানে মরিয়মের মৃত্যু হল ও কবর দেওয়া হল। ");
INSERT INTO benirv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","সেখানে মণ্ডলীর জন্য জল ছিল না; তাতে লোকেরা মোশির ও হারোণের বিরুদ্ধে জড়ো হল। ");
INSERT INTO benirv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","তারা মোশির সঙ্গে ঝগড়া করে বলল, “হায়, আমাদের ভাইয়েরা যখন সদাপ্রভুর সামনে মারা গেল, তখন কেন আমাদের মৃত্যু হল না? ");
INSERT INTO benirv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","তোমরা আমাদের ও আমাদের পশুদের মৃত্যুর জন্য সদাপ্রভুর মণ্ডলীকে কেন এই মরুপ্রান্তে আনলে? ");
INSERT INTO benirv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","এই ভয়ঙ্কর জায়গায় আনার জন্য আমাদেরকে মিশর থেকে কেন বের করে নিয়ে আসলে? এখানে চাষ কিংবা ডুমুর কিংবা আঙ্গুর কিংবা ডুমুর হয় না এবং পান করার জলও নেই।” ");
INSERT INTO benirv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","তখন মোশি ও হারোণ সমাজের সামনে থেকে সমাগম তাঁবুর প্রবেশপথে গিয়ে উপুড় হয়ে পড়লেন। সদাপ্রভুর মহিমা তাদের কাছে প্রকাশিত হল। ");
INSERT INTO benirv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“তুমি লাঠি নাও এবং তুমি ও তোমার ভাই হারোণ মণ্ডলীকে জড়ো করে তাদের সাক্ষাৎে ঐ শিলাকে বল, তাতে সে নিজে জল দেবে; এই ভাবে তুমি তাদের জন্য শিলা থেকে জল বের করে মণ্ডলীকে ও তাদের পশুদেরকে পান করাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","তখন মোশি সদাপ্রভুর আদেশ অনুসারে তাঁর সামনে থেকে ঐ লাঠি নিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","তখন মোশি ও হারোণ সেই শিলার সামনে সমাজকে জড়ো করে তাদেরকে বললেন, “হে বিদ্রোহীরা, এখন শোনো; আমরা তোমাদের জন্য কি এই শিলা থেকে জল বের করব?” ");
INSERT INTO benirv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","তখন মোশি তাঁর হাত তুলে ঐ লাঠি দিয়ে শিলায় দুবার আঘাত করলেন, তাতে প্রচুর জল বের হল এবং মণ্ডলী ও তাদের পশুরা পান করল। ");
INSERT INTO benirv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","তখন সদাপ্রভু মোশি ও হারোণকে বললেন, “তোমরা ইস্রায়েল সন্তানদের সাক্ষাৎে আমাকে পবিত্র বলে মান্য করতে আমার কথায় বিশ্বাস করলে না, তাই আমি তাদেরকে যে দেশ দিয়েছি, সেই দেশে তোমরা এই মণ্ডলীকে প্রবেশ করাবে না।” ");
INSERT INTO benirv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","সেই জলের নাম মরীবা বিবাদ; যেহেতু ইস্রায়েল সন্তানরা সদাপ্রভুর সঙ্গে ঝগড়া করল, আর তিনি তাদের মধ্যে পবিত্র হিসাবে মান্য হলেন। ");
INSERT INTO benirv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","মোশি কাদেশ থেকে ইদোমীয় রাজার কাছে দূতের মাধ্যমে বলে পাঠালেন, “তোমার ভাই ইস্রায়েল বলছে, ‘আমাদের যত কষ্ট হয়েছে, তা তুমি জানো। ");
INSERT INTO benirv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","আমাদের পূর্বপুরুষরা মিশরে নেমে গিয়েছিলেন, সেই মিশরে আমরা অনেক দিন বাস করছিলাম। পরে মিশরীয়েরা আমাদের প্রতি ও আমাদের পূর্বপুরুষদের প্রতি খারাপ ব্যবহার করতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","যখন আমরা সদাপ্রভুর উদ্দেশ্যে কাঁদলাম, তিনি আমাদের রব শুনলেন এবং দূত পাঠিয়ে আমাদেরকে মিশর থেকে বের করে আনলেন। দেখ, আমরা তোমার দেশের শেষে অবস্থিত কাদেশ শহরে আছি। ");
INSERT INTO benirv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","আমি অনুরোধ করি, তুমি তোমার দেশের মধ্যে দিয়ে আমাদেরকে যেতে দাও। আমরা শস্যক্ষেত দিয়ে যাব না, কুয়োর জলও পান করব না; শুধুমাত্র রাজপথ দিয়ে যাব; যে পর্যন্ত তোমার সীমানা পার না হই, ততক্ষণ ডানে কিংবা বামে ফিরব না’।” ");
INSERT INTO benirv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ইদোমের রাজা তাঁকে বলল, “তুমি আমার দেশের মধ্যে দিয়ে যেতে পাবে না, গেলে আমি তরোয়াল নিয়ে তোমাকে আক্রমণ করব।” ");
INSERT INTO benirv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","তখন ইস্রায়েল সন্তানরা তাকে বলল, “আমরা রাজপথ দিয়েই যাব। আমরা কিংবা আমাদের পশুরা যদি তোমার জল পান করি, তবে আমরা তার দাম দেব। আর কিছু নয়, শুধুমাত্র আমাদের পায়ে হেঁটে যেতে দাও।” ");
INSERT INTO benirv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","কিন্তু ইদোমের রাজা উত্তর দিল, “তুমি যেতে পাবে না।” সুতরাং ইদোমের রাজা অনেক লোক সঙ্গে নিয়ে শক্তিশালী হয়ে ইস্রায়েলের বিরুদ্ধে এল। ");
INSERT INTO benirv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ইদোমের রাজা ইস্রায়েলকে তার সীমানা অতিক্রম করা অনুমতি প্রত্যাখান করল। তার জন্য ইস্রায়েল তার কাছ থেকে অন্য পথ দিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","সুতরাং ইস্রায়েল সন্তানরা, সমস্ত মণ্ডলী কাদেশ থেকে চলে গিয়ে হোর পর্বতে উপস্থিত হল। ");
INSERT INTO benirv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ইদোম দেশের সীমানার কাছাকাছি হোর পর্বতে সদাপ্রভু মোশি ও হারোণকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“হারোণ তার লোকেদের কাছে জড়ো হবে, আমি ইস্রায়েল সন্তানকে যে দেশ দিয়েছি, সেই দেশে সে প্রবেশ করবে না। কারণ তোমরা উভয়েই মরীবা জলের কাছে আমার কথার বিরুদ্ধে বিদ্রোহ করেছিলে। ");
INSERT INTO benirv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","তুমি হারোণকে ও তার ছেলে ইলীয়াসরকে হোর পর্বতের উপরে নিয়ে যাও। ");
INSERT INTO benirv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","হারোণের থেকে তার যাজকের পোশাক নিয়ে তার ছেলে ইলীয়াসরকে তা পরাও। হারোণ তার লোকেদের কাছে জড়ো হবে এবং সেখানে মারা যাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","মোশি সদাপ্রভুর আদেশ অনুযায়ী কাজ করলেন। তাঁরা সমস্ত মণ্ডলীর সাক্ষাৎে হোর পর্বতে উঠলেন। ");
INSERT INTO benirv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","মোশি হারোণের যাজকের পোশাক নিয়ে তাঁর ছেলে ইলীয়াসরকে তা পড়ালেন। হারোণ সেই পর্বতের চূড়ায় মারা গেলেন। তখন মোশি ও ইলীয়াসর পর্বত থেকে নেমে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","যখন সমস্ত মণ্ডলী দেখল যে, হারোণ মারা গেছেন, তখন সমস্ত ইস্রায়েল কুল হারোণের জন্য ত্রিশ দিন পর্যন্ত কাঁদল। ");
INSERT INTO benirv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","যখন নেগেভ প্রদেশে বসবাসী কনান বংশের অরাদের রাজা শুনতে পেলেন যে, ইস্রায়েল অথারীমের পথ দিয়ে আসছে; তখন তিনি ইস্রায়েলের সঙ্গে যুদ্ধ করলেন ও তাদের কতকগুলি লোকেকে ধরে বন্দি করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","তাতে ইস্রায়েল সদাপ্রভুর উদ্দেশ্যে মানত করে বলল, “যদি তুমি এই লোকেদের উপর আমাদের জয়ী কর, তবে আমরা তাদের শহরগুলি সম্পূর্ণরূপে বিনষ্ট করব।” ");
INSERT INTO benirv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","তখন সদাপ্রভু ইস্রায়েলের কথা শুনলেন এবং তিনি কনানীয়দের উপর তাদের বিজয়ী করলেন। তারা সম্পূর্ণভাবে তাদেরকে ও তাদের সমস্ত শহর বিনষ্ট করল এবং সেই জায়গার নাম হর্মা বিনষ্ট রাখল। ");
INSERT INTO benirv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","তারা হোর পর্বত থেকে চলে গিয়ে ইদোম দেশ পাশ দিয়ে ঘোরার জন্য লাল সাগরের দিকে যাত্রা করল। পথের মধ্যে লোকেদের প্রাণ বিরক্ত হয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","লোকেরা ঈশ্বরের ও মোশির বিরুদ্ধে বলতে লাগল, “তোমরা কি আমাদেরকে মিশর থেকে বের করে আনলে, যেন আমরা মরুপ্রান্তে মারা যাই? রুটিও নেই, জলও নেই এবং আমরা এই হালকা খাবার ঘৃণা করি।” ");
INSERT INTO benirv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","তখন সদাপ্রভু লোকেদের মধ্যে বিষাক্ত সাপ পাঠালেন। তারা লোকেদেরকে কামড়ালে ইস্রায়েলের অনেক লোক মারা গেল। ");
INSERT INTO benirv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","লোকেরা মোশির কাছে এসে বলল, “সদাপ্রভুর ও তোমার বিরুদ্ধে কথা বলে আমরা পাপ করেছি। তুমি সদাপ্রভুর কাছে প্রার্থনা কর, যেন তিনি আমাদের কাছ থেকে এইসব সাপ দূর করেন।” ");
INSERT INTO benirv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","সদাপ্রভু মোশিকে বললেন, “তুমি একটি বিষাক্ত সাপ তৈরী করে পতাকার উপরে রাখ, সাপে কামড়ানো যে কোন ব্যক্তি তার দিকে দেখবে, সে বাঁচবে।” ");
INSERT INTO benirv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","তখন মোশি পিতলের একটি সাপ তৈরী করে পতাকার উপরে রাখলেন; তাতে এইরকম হল, সাপ কোন মানুষকে কামড়ালে করলে যখন সে ঐ পিতলের সাপের দিকে তাকালো, তখন বাঁচল। ");
INSERT INTO benirv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","তারপরে ইস্রায়েল সন্তানরা যাত্রা করে ওবোতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ওবোৎ থেকে যাত্রা করে সূর্য্যোদয়ের দিকে মোয়াবের সামনের অবস্থিত মরুপ্রান্তে ইয়ী-অবারীমে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","সেখান থেকে যাত্রা করে সেরদ উপত্যকাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","সেখান থেকে যাত্রা করে ইমোরীয়দের সীমানা থেকে প্রসারিত অর্ণোনের অন্য পারের মরুপ্রান্তে শিবির স্থাপন করল। কারণ মোয়াবের ও ইমোরীয়দের মাঝে অর্ণোন মোয়াবের সীমানা। ");
INSERT INTO benirv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","এই জন্য সদাপ্রভুর যুদ্ধের বইয়ে বলা আছে, শূফাতে বাহেব, আর অর্ণোনের উপত্যকাগুলি ");
INSERT INTO benirv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","এবং উপত্যকাগুলির পাশের ভূমি, যেটা আর্‌ নামক লোকালয়ের দিকে এবং মোয়াবের সীমানার পাশে অবস্থিত। ");
INSERT INTO benirv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","সেখান থেকে তারা বের কূপ নামক স্থানে আসল। এ সেই কুয়ো, যার বিষয়ে সদাপ্রভু মোশিকে বললেন, “তুমি লোকদেরকে জড়ো কর, আমি তাদেরকে জল দেব।” ");
INSERT INTO benirv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","তখন ইস্রায়েল এই গীত গান করল, “হে কুয়ো, জেগে ওঠো; তোমরা এর উদ্দেশ্যে গান কর; ");
INSERT INTO benirv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","এ শাসনকর্ত্তাদের খনন করা কুয়ো, রাজদণ্ড ও নিজেদের লাঠি দিয়ে লোকেদের অভিজাতরা এটা খনন করেছেন।” পরে তারা মরুভূমি থেকে মত্তানায় ও ");
INSERT INTO benirv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","মত্তানা থেকে নহলীয়েলে ও নহলীয়েল থেকে বামোতে ");
INSERT INTO benirv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ও বামোৎ থেকে মোয়াব ক্ষেতের উপত্যকা দিয়ে মরুপ্রান্তের দিকে পিস্‌গা চূড়ায় চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","আর ইস্রায়েল দূত পাঠিয়ে ইমোরীয়দের রাজা সীহোনকে বলল, ");
INSERT INTO benirv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“তোমার দেশের মধ্যে দিয়ে আমাকে যেতে দাও; আমরা পথ ছেড়ে শস্যক্ষেতে কিংবা আঙ্গুরক্ষেতে ঢুকবো না, কুয়োর জলও পান করব না; যতদিন তোমার সীমানা পার না হই, ততদিন রাজপথ দিয়ে যাব।” ");
INSERT INTO benirv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","কিন্তু সীহোনের রাজা তার সীমানা দিয়ে ইস্রায়েলকে যেতে দিল না; পরিবর্তে সীহোনের রাজা তার সমস্ত প্রজাকে জড়ো করে ইস্রায়েলের বিরুদ্ধে মরুপ্রান্তে বের হল এবং যহসে উপস্থিত হয়ে ইস্রায়েলের সঙ্গে যুদ্ধ করল। ");
INSERT INTO benirv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","তাতে ইস্রায়েল তরোয়াল দিয়ে তাকে আঘাত করে অর্ণোন থেকে যব্বোক পর্যন্ত অর্থাৎ অম্মোন সন্তানদের কাছ পর্যন্ত তার দেশ অধিকার করল; কারণ অম্মোন সন্তানদের সীমানা সুরক্ষিত ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ইস্রায়েল ঐ সমস্ত শহর দখল করল এবং ইস্রায়েল ইমোরীয়দের সমস্ত শহরে, হিষ্‌বোনে ও সেখানকার সমস্ত গ্রামে, বাস করতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","কারণ হিষ্‌বোন ইমোরীয়দের রাজা সীহোনের শহর ছিল; তিনি মোয়াবের আগের রাজার বিরুদ্ধে যুদ্ধ করে তার হাত থেকে অর্ণোন পর্যন্ত তার সমস্ত দেশ নিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","এই জন্য কবিরা বলেন, “তোমরা হিষ্‌বোনে এস, সীহোনের শহর তৈরী ও সুরক্ষিত হোক; ");
INSERT INTO benirv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","কারণ হিষ্‌বোন থেকে আগুন, সীহোনের শহর থেকে আগুনের শিখা বের হয়েছে; তা মোয়াবের আর্‌ শহরকে, অর্ণোনের অধিপতি নাথদেরকে গিলে ফেলেছে। ");
INSERT INTO benirv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","হে মোয়াব, ধিক্‌ তোমাকে! হে কমোশের প্রজারা, তোমরা বিনষ্ট হলে! সে তার ছেলেদেরকে পলাতক হিসাবে, তার মেয়েদেরকে বন্দি হিসাবে তুলে দিল, ইমোরীয়দের রাজা সীহোনের হাতে। ");
INSERT INTO benirv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","আমরা তাদেরকে বাণ মেরেছি; হিষ্‌বোন দীবোন পর্যন্ত বিনষ্ট হয়েছি; আর আমরা নোফঃ পর্যন্ত ধ্বংস করেছি, যেটা মেদবা পর্যন্ত বিস্তৃত।” ");
INSERT INTO benirv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","এই ভাবে ইস্রায়েল ইমোরীয়দের দেশে বাস করতে লাগল। ");
INSERT INTO benirv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","তখন মোশি যাসের অনুসন্ধান করতে লোক পাঠালেন, আর তারা সেখানকার গ্রামগুলি দখল করল এবং সেখানে যে ইমোরীয়েরা ছিল, তাদেরকে অধিকারচ্যুত করল। ");
INSERT INTO benirv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","তখন তারা ফিরে বাশনের পথ দিয়ে উঠে গেল; তাতে বাশনের রাজা ওগ ও তার সমস্ত প্রজা বের হয়ে তাদের সঙ্গে ইদ্রিয়ীতে যুদ্ধ করতে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","তখন সদাপ্রভু মোশিকে বললেন, “তুমি এদের থেকে ভয় পেয় না, কারণ আমি এর উপর তোমাকে জয়ী করেছি, এর সমস্ত প্রজা ও এর দেশকে। তুমি হিষ্‌বোন-বাসী ইমোরীয়দের রাজা সীহোনের প্রতি যেমন করলে, এদের প্রতি সেই রকম করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","সুতরাং তারা তাকে, তার ছেলেদেরকে, তার সৈন্যদেরকে হত্যা করল, তাদের কেউ জীবিত ছিল না। তখন তার দেশ অধিকার করে নিল। ");
INSERT INTO benirv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ইস্রায়েল সন্তানরা যাত্রা করে যিরীহোর কাছে অবস্থিত যর্দ্দনের পরপারে মোয়াবের তলভূমিতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ইস্রায়েল ইমোরীয়দের প্রতি যা যা করেছিল, সে সমস্ত সিপ্পোরের ছেলে বালাক দেখেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","মোয়াব তাদেরকে খুব ভয় পেল কারণ ইস্রায়েল সন্তানদের জন্য মোয়াব আতঙ্কিত ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","মোয়াবের রাজা মিদিয়নের প্রাচীনদেরকে বলল, “গরু যেমন মাঠের কচি ঘাস চেঁটে খায়, তেমনি এই লোকজন আমাদের চারদিকের সব কিছুই চেঁটে খাবে।” সেই দিন সিপ্পোরের ছেলে বালাক মোয়াবের রাজা ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","তিনি বিয়োরের ছেলে বিলিয়মকে ডেকে আনতে তার জাতির লোকেদের দেশে ফরাৎ নদীর তীরে অবস্থিত পথোর শহরে দূত পাঠিয়ে তাকে বললেন, “দেখুন, মিশর থেকে একটি জাতি বের হয়ে এসেছে, দেখুন, তারা পৃথিবী ঢেকে আমার সামনে অবস্থান করছে। ");
INSERT INTO benirv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","এখন নিবেদন করি, আপনি এসে আমার জন্য সেই লোকেদেরকে অভিশাপ দিন; কারণ আমার থেকে তারা বলবান। হয় তো আমি তাদেরকে আঘাত করে দেশ থেকে তাড়িয়ে দিতে পারব। আমি জানি যে, আপনি যাকে আশীর্বাদ করেন, সে আশীর্বাদ পায় ও যাকে অভিশাপ দেন, সে অভিশপ্ত হয়।” ");
INSERT INTO benirv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","সুতরাং মোয়াবের প্রাচীনেরা ও মিদিয়নের প্রাচীনেরা মন্ত্রণার পুরষ্কার হাতে নিয়ে চলে গেল এবং বিলিয়মের কাছে উপস্থিত হয়ে বালাকের কথা তাকে বলল। ");
INSERT INTO benirv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","সে তাদেরকে বলল, “তোমরা এখানে রাত কাটাও; পরে সদাপ্রভু আমাকে যা বলবেন, সেই অনুযায়ী কথা আমি তোমাদেরকে বলব।” তাতে মোয়াবের শাসনকর্তারা বিলিয়মের সঙ্গে রাত কাটাল। ");
INSERT INTO benirv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ঈশ্বর বিলিয়মের কাছে উপস্থিত হয়ে বললেন, “তোমার সঙ্গে এই লোকেরা কে?” ");
INSERT INTO benirv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","তাতে বিলিয়ম ঈশ্বরকে বলল, “মোয়াবের রাজা সিপ্পোরের ছেলে বালাক আমার কাছে বলে পাঠিয়েছেন; ");
INSERT INTO benirv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","দেখ, মিশর থেকে বাইরের ঐ জাতি পৃথিবী ঢেকে আছে। এখন তুমি এসে আমার জন্য তাদের অভিশাপ দাও, হয় তো আমি তাদের সঙ্গে যুদ্ধ করে তাদেরকে তাড়িয়ে দিতে পারব।” ");
INSERT INTO benirv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","তাতে ঈশ্বর বিলিয়মকে বললেন, “তুমি তাদের সঙ্গে যেও না, সেই জাতিকে অভিশাপ দিও না, কারণ তারা আশীর্বাদযুক্ত।” ");
INSERT INTO benirv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","বিলিয়ম সকালে উঠে বালাকের শাসনকর্তাদেরকে বলল, “তোমরা নিজেদের দেশে চলে যাও, কারণ তোমাদের সঙ্গে আমার যাওয়ায় অনুমতি দিতে সদাপ্রভু অস্বীকার করলেন।” ");
INSERT INTO benirv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","তাতে মোয়াবের শাসনকর্তারা উঠে বালাকের কাছে গিয়ে বলল, “আমাদের সঙ্গে আসতে বিলিয়ম অস্বীকার করলেন।” ");
INSERT INTO benirv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","বালাক আবার তাদের থেকে বেশি সংখ্যক ও সম্মানীয় অন্য শাসনকর্তাদেরকে পাঠালেন। ");
INSERT INTO benirv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","তারা বিলিয়মের কাছে এসে তাকে বলল, “সিপ্পোরের ছেলে বালাক এই কথা বলেন, ‘অনুরোধ করি, আমার কাছে আসা আপনি কিছুতেই বন্ধ করবেন না। ");
INSERT INTO benirv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","কারণ আমি আপনাকে খুব সম্মানিত করব; আপনি আমাকে যা যা বলবেন, আমি সব কিছুই করব। অতএব বিনয় করি, আপনি এসে আমার জন্য সেই লোকেদেরকে অভিশাপ দিন।’” ");
INSERT INTO benirv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","তখন বিলিয়ম বালাকের দাসেদেরকে উত্তর দিল, “যদি বালাক রূপা ও সোনার ভর্তি নিজের বাড়িও আমাকে দেন, তবুও আমি কম কি বেশি কোনকিছুর করার জন্য আমার ঈশ্বর সদাপ্রভুর আদেশ অমান্য করতে পারব না। ");
INSERT INTO benirv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","এখন অনুরোধ করি, তোমরাও এখানে রাত কাটাও, সদাপ্রভু আমাকে আবার যা বলবেন, তা আমি জানাব।” ");
INSERT INTO benirv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ঈশ্বর রাতের বেলা বিলিয়মের কাছে এসে তাকে বললেন, “ঐ লোকেরা যদি তোমাকে ডাকতে এসে থাকে, তুমি ওঠ, তাদের সঙ্গে যাও; কিন্তু আমি তোমাকে যা বলব, তুমি শুধু তাই করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","বিলিয়ম সকালে উঠে তার গাধী সাজিয়ে মোয়াবের শাসনকর্ত্তাদের সঙ্গে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","তার যাওয়ায় ঈশ্বরের রাগ জ্বলে উঠল এবং সদাপ্রভুর দূত তার বিপক্ষে পথের মধ্যে দাঁড়ালেন। সে তার গাধীতে চড়ে যাচ্ছিল এবং তার দুই দাস তার সঙ্গে ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","সেই গাধী দেখলে যে, সদাপ্রভুর দূত খোলা তরোয়াল হাতে নিয়ে পথের মধ্যে দাঁড়িয়ে আছেন। তাই গাধী পথ ছেড়ে ক্ষেতের দিকে চলে গেল। তাতে বিলিয়ম গাধীকে পথে আনার জন্য আঘাত করল। ");
INSERT INTO benirv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","তখন সদাপ্রভুর দূত দুই আঙ্গুর ক্ষেতের গলির পথে দাঁড়ালেন, এ পাশে দেয়াল ওপাশে দেয়াল ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","তখন গাধী সদাপ্রভুর দূতকে দেখে দেয়ালের গা ঘেঁষে গেল, আর দেয়ালে বিলিয়মের পায়ে ঘষে গেল; তাতে সে আবার তাকে আঘাত করল। ");
INSERT INTO benirv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","পরে সদাপ্রভুর দূত আরও কিছুটা এগিয়ে গেল, ডানে কি বামে ফেরার পথ নেই, এমন একটি সরু জায়গায় দাঁড়ালেন। ");
INSERT INTO benirv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","তখন গাধী সদাপ্রভুর দূতকে দেখে বিলিয়মের নীচে ভূমিতে বসে পড়ল; তাতে বিলিয়ম রাগে জ্বলে উঠলো, সে গাধীকে লাঠি দিয়ে আঘাত করল। ");
INSERT INTO benirv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","তখন সদাপ্রভু গাধীর মুখ খুলে দিলেন এবং সে বিলিয়মকে বলল, “আমি তোমার কি করলাম যে তুমি এই তিনবার আমাকে আঘাত করলে?” ");
INSERT INTO benirv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","বিলিয়ম গাধীকে বলল, “তুমি আমাকে বিদ্রূপ করেছ; আমার হাতে যদি তরোয়াল থাকত, তবে আমি এখনই তোমাকে হত্যা করতাম।” ");
INSERT INTO benirv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","পরে গাধী বিলিয়মকে বলল, “তুমি জন্ম থেকে আজ পর্যন্ত যার উপরে চড়ে থাক, আমি কি তোমার সেই গাধী নই? আমি কি তোমার প্রতি এমন ব্যবহার করে থাকি?” সে বলল, “না।” ");
INSERT INTO benirv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","তখন সদাপ্রভু বিলিয়মের চোখ খুলে দিলেন, তাতে সে দেখল, সদাপ্রভুর দূত খোলা তরোয়াল হাতে পথের মধ্যে দাঁড়িয়ে আছেন; তখন সে মাথা নিচু করে উপুড় হয়ে পড়ল। ");
INSERT INTO benirv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","তখন সদাপ্রভুর দূত তাকে বললেন, “তুমি এই তিন বার তোমার গাধীকে কেন আঘাত করলে? দেখ, আমি তোমার বিপক্ষে বের হয়েছি, কারণ আমার সাক্ষাৎে তুমি বিপথে যাচ্ছ। ");
INSERT INTO benirv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","গাধী আমাকে দেখে এই তিনবার আমার সামনে থেকে চলে গেল। সে যদি আমার সামনে থেকে চলে না যেত, তবে আমি নিশ্চয়ই তোমাকে হত্যা করতাম, আর ওটাকে জীবিত রাখতাম।” ");
INSERT INTO benirv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","তাতে বিলিয়ম সদাপ্রভুর দূতকে বলল, “আমি পাপ করেছি; কারণ আপনি যে আমার বিপরীতে পথে দাঁড়িয়ে আছেন, তা আমি জানি না; কিন্তু এখন যদি এটাতে আপনি বিরক্ত হন, তবে আমি ফিরে যাই।” ");
INSERT INTO benirv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","তাতে সদাপ্রভুর দূত বিলিয়মকে বললেন, “ঐ লোকদের সঙ্গে যাও, কিন্তু আমি যে কথা তোমাকে বলব, তুমি শুধু সেই কথাই বলবে।” পরে বিলিয়ম বালাকের শাসনকর্ত্তাদের সঙ্গে চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","বিলিয়ম এসেছে শুনে বালাক তার সঙ্গে দেখা করতে মোয়াবের শহরে গেলেন। সেটা দেশের সীমানার শেষে অবস্থিত অর্ণোনের সীমানায় অবস্থিত। ");
INSERT INTO benirv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","বালাক বিলিয়মকে বললেন, “আমি আপনাকে ডেকে আনতে কি অনেক যত্ন করে লোক পাঠাইনি? আপনি আমার কাছে কেন আসেন নি? আপনাকে সম্মানিত করতে আমি কি সত্যিই ব্যর্থ?” ");
INSERT INTO benirv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","তখন বিলিয়ম বালাককে বলল, “দেখুন, আমি আপনার কাছে এলাম, কিন্তু এখনও কোন কথা বলতে কি আমার ক্ষমতা আছে? ঈশ্বর আমার মুখে যে কথা দেন, আমি সেটাই বলতে পারি।” ");
INSERT INTO benirv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","বিলিয়ম বালাকের সঙ্গে গেল এবং তাঁরা কিরিয়ৎ হুষোতে উপস্থিত হলেন। ");
INSERT INTO benirv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","তখন বালাক কতকগুলি গরু ও ভেড়া বলিদান করে বিলিয়মের ও তার সঙ্গী শাসনকর্ত্তাদের কাছে পাঠিয়ে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","সকাল বেলায়, বালাক বিলিয়মকে বামোৎ বাল দেবতার উঁচুস্থানে নিয়ে গেল৷ সেই জায়গা থেকে বিলিয়ম ইস্রায়েলীয়দের শিবিরের একটি অংশ দেখতে পেলেন৷ ");
INSERT INTO benirv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","বিলিয়ম বালাককে বলল, “আপনি এখানে আমার জন্য সাতটি বেদি তৈরী করুন এবং এখানে আমার জন্য সাতটি ষাঁড় ও সাতটি ভেড়ার আয়োজন করুন।” ");
INSERT INTO benirv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","তাতে বালাক বিলিয়মের অনুরোধে সেই রকম করলেন। তখন বালাক ও বিলিয়ম এক একটি বেদিতে এক একটি ষাঁড় ও এক একটি ভেড়া উৎসর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","তখন বিলিয়ম বালাককে বলল, “আপনি আপনার হোমবলির কাছে দাঁড়িয়ে থাকুন এবং আমি যাই, হয় তো সদাপ্রভু আমার কাছে দেখা দেবেন। তাহলে তিনি আমাকে যা জানাবেন, আমি তা আপনাকে বলব।” পরে সে পর্বতের ওপরে চলে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ঈশ্বর বিলিয়মের কাছে দেখা দিলেন, আর সে তাঁকে বলল, “আমি সাতটি বেদি তৈরী করেছি; আর এক একটি বেদিতে এক একটি ষাঁড় ও এক একটি ভেড়া উৎসর্গ করেছি।” ");
INSERT INTO benirv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","তখন সদাপ্রভু বিলিয়মের মুখে এক বাক্য দিলেন, আর বললেন, “তুমি বালাকের কাছে ফিরে গিয়ে এইরকম কথা বল।” ");
INSERT INTO benirv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","তাতে সে তার কাছে ফিরে গেল, আর দেখ, মোয়াবের শাসনকর্ত্তাদের সঙ্গে বালাক তাঁর হোমের কাছে দাঁড়িয়ে ছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","তখন বিলিয়ম তার ভাববাণী করে বলল, বালাক অরাম থেকে আমাকে আনালেন, “মোয়াবের রাজা পূর্বদিকের পর্বতমালা থেকে আনলেন, ‘এস, আমার জন্য যাকোবকে অভিশাপ দাও, এস, ইস্রায়েলকে উপর তুচ্ছ কর।’ ");
INSERT INTO benirv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ঈশ্বর যাকে অভিশাপ দেন নি, আমি কিভাবে তাকে অভিশাপ দেব? সদাপ্রভু যাকে তুচ্ছ করেন নি, আমি কিভাবে তাকে তুচ্ছ করব? ");
INSERT INTO benirv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","আমি শিলার চূড়া থেকে তাকে দেখেছি, গিরিমালা থেকে তাকে দর্শন করছি; দেখ, ঐ লোকেরা স্বাধীনভাবে বাস করে, তাদের জাতিদের মধ্যে গণনা করা হবে না। ");
INSERT INTO benirv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","যাকোবের ধূলো কে গণনা করতে পারে? ইস্রায়েলের চার ভাগের এক ভাগ সংখ্যা কে করতে পারে? ধার্ম্মিকের মৃত্যের মত আমার মৃত্যু হোক, তার শেষ গতির মত আমার শেষ গতি হোক।” ");
INSERT INTO benirv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","তখন বালাক বিলিয়মকে বললেন, “আপনি আমার প্রতি এ কি করলেন? আমার শত্রুদেরকে অভিশাপ দিতে আপনাকে আনালাম, কিন্তু দেখুন, আপনি তাদেরকে আশীর্বাদ করলেন।” ");
INSERT INTO benirv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","সে উত্তর দিল, “সদাপ্রভু আমার মুখে যে কথা দেন, সাবধান হয়ে তাই বলা কি আমার উচিত নয়?” ");
INSERT INTO benirv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","বালাক বললেন, “বিনয় করি, অন্য জায়গায় আমার সঙ্গে আসুন, আপনি সেখান থেকে তাদেরকে দেখতে পাবেন। আপনি তাদের শেষভাগ কেবলমাত্র দেখতে পাবেন, সবকিছু দেখতে পাবেন না। ওখানে থেকে আমার জন্য তাদেরকে অভিশাপ দিন।” ");
INSERT INTO benirv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","তখন বালাক তাকে পিস্‌গার চূড়ায় অবস্থিত সোফীম ক্ষেতে নিয়ে গিয়ে সেখানে সাতটি বেদি তৈরী করলেন, আর প্রত্যেক বেদিতে এক একটি ষাঁড় ও এক একটি ভেড়া উৎসর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","তখন সে বালাককে বলল, “আমি যতক্ষণ ওখানে সদাপ্রভুর সঙ্গে সাক্ষাৎ করি, ততক্ষণ আপনি এখানে আপনকার হোমবলির কাছে দাঁড়িয়ে থাকুন।” ");
INSERT INTO benirv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","সুতরাং সদাপ্রভু বিলিয়মের কাছে দেখা দিয়ে তার মুখে এক বাক্য দিলেন এবং বললেন, “তুমি বালাকের কাছে ফিরে গিয়ে এইরকম কথা বল।” ");
INSERT INTO benirv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","তাতে সে তাঁর কাছে উপস্থিত হল; আর দেখ, মোয়াবের শাসনকর্ত্তাদের সঙ্গে বালাক তাঁর হোমবলির কাছে দাঁড়িয়ে ছিলেন। আর বালাক তাকে জিজ্ঞাসা করলেন, “সদাপ্রভু কি বললেন?” ");
INSERT INTO benirv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","তখন সে তার ভাববাণী করে বলল, “ওঠ, বালাক, শোন; হে সিপ্পোরের ছেলে, আমার কথায় কান দাও। ");
INSERT INTO benirv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ঈশ্বর মানুষ নন যে মিথ্যা বলবেন, তিনি মানুষের সন্তান নন যে অনুশোচনা করবেন। তিনি কি কাজ না করেই প্রতিশ্রুতি করেন? তিনি কি সম্পন্ন না করার জন্য কোন কিছু বলেন? ");
INSERT INTO benirv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","দেখ, আমি আশীর্বাদ করার আদেশ পেলাম, তিনি আশীর্বাদ করেছেন, আমি বিপরীতে যেতে পারি না। ");
INSERT INTO benirv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","তিনি যাকোবের মধ্যে অস্বচ্ছলতা দেখতে পাননি, ইস্রায়েলের উপদ্রব দেখেন নি, তার ঈশ্বর সদাপ্রভু তার সঙ্গে সঙ্গে থাকেন, রাজার জয়ধ্বনি তাদের মধ্যে আছে। ");
INSERT INTO benirv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ঈশ্বর মিশর থেকে তাদেরকে এনেছেন, সে বন্য ষাঁড়ের মত শক্তিশালী। ");
INSERT INTO benirv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","কোনো মায়াশক্তি নেই যা যাকোবের বিরুদ্ধে কাজ করে এবং ইস্রায়েলের বিরুদ্ধে কোনো মন্দ পূর্বাভাস নেই। পরিবর্তে যাকোবের ও ইস্রায়েলের বিষয় অবশ্যই বলা হবে, ‘দেখ ঈশ্বর কি করেছেন!’ ");
INSERT INTO benirv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","দেখ, ঐ জাতি সিংহীর মত উঠছে, যেমন একটি সিংহ উত্থিত হয় ও আক্রমণ করে। সে শুয়ে পড়বে না যতক্ষণ না সে তার শিকার না খায় এবং যতক্ষণ না সে যাকে হত্যা করেছে তার রক্ত পান করে।” ");
INSERT INTO benirv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","তখন বালাক বিলিয়মকে বললেন, “আপনি তাদেরকে অভিশাপও দেবেন না, আশীর্বাদও করবেন না।” ");
INSERT INTO benirv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","কিন্তু বিলিয়ম উত্তর দিয়ে বালাককে বলল, “সদাপ্রভু আমাকে যা কিছু বলতে বলবেন, তাই বলব, এ কথা কি আপনাকে বলি নি?” ");
INSERT INTO benirv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","তাই বালাক বিলিয়মকে বললেন, “বিনয় করি, আসুন, আমি আপনাকে অন্য জায়গায় নিয়ে যাই, হয় তো সেখান থেকে আমার জন্য তাদেরকে আপনার অভিশাপ দেওয়া ঈশ্বরের দৃষ্টিতে সন্তুষ্টজনক হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","তাই বালাক মরুপ্রান্তের দিকে পিয়োর চূড়ায় বিলিয়মকে নিয়ে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","বিলিয়ম বালাককে বলল, “এখানে আমার জন্য সাতটি বেদি তৈরী করুন এবং এখানে আমার জন্য সাতটি ষাঁড় ও সাতটি ভেড়ার আয়োজন করুন।” ");
INSERT INTO benirv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","তখন বালাক বিলিয়মের কথা অনুযায়ী কাজ করলেন এবং প্রত্যেক বেদিতে এক একটি ষাঁড় ও এক একটি ভেড়া উৎসর্গ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","বিলিয়ম যখন দেখল, ইস্রায়েলকে আশীর্বাদ করতে সদাপ্রভু আনন্দিত, তখন আর আগের মত জাদুবিদ্যা ব্যবহার করার জন্য গেল না, কিন্তু মরুপ্রান্তের দিকে তাকিয়ে রইল। ");
INSERT INTO benirv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","আর বিলিয়ম চোখ তুলে দেখল, ইস্রায়েল তাদের বংশ অনুসারে শিবির করেছে এবং ঈশ্বরের আত্মা তাঁর উপরে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","সে তাঁর ভাববাণী গ্রহণ করে বলল, “বিয়োরের ছেলে বিলিয়ম বলছে, যার চোখ ভালোভাবে খোলা ছিল, সেই পুরুষ বলছে, ");
INSERT INTO benirv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","যে ঈশ্বরের বাক্যগুলি শোনে, সে সর্বশক্তিমানের দর্শন পায়, সে নত ও খোলা চোখে বলছে। ");
INSERT INTO benirv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","যাকোব, তোমার তাঁবুগুলি কত সুন্দর, হে ইস্রায়েল, যেখানে তুমি বাস কর! ");
INSERT INTO benirv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","সেগুলি উপত্যকার মত বিস্তারিত, নদীর তীরের বাগানের মত, সদাপ্রভুর রোপণ করা জোলাপের মত, জলের ধারের এরস গাছের মত। ");
INSERT INTO benirv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","তাদের কলসী থেকে জল উথলে উঠবে, তার বীজ গভীর জলে পরিপূর্ণ হবে, তাদের রাজা অগাগের থেকেও মহত্তম হবে, তার রাজ্য উন্নত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ঈশ্বর মিশর থেকে তাকে এনেছেন, সে বন্য ষাঁড়ের মত শক্তিশালী। সে তার বিপক্ষ জাতিদেরকে গিলে খাবে, তাদের হাড় চূরমার করে দেবে, নিজের বাণ দিয়ে তাদেরকে ভেদ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","সে গুঁড়িসুটি মারল, সিংহের মত ও সিংহীর মত। কার তাকে বিরক্ত করার সাহস আছে? যে তাকে আশীর্বাদ করে, সে আশীর্বাদ প্রাপ্ত হয়, যে তাকে অভিশাপ দেয়, সে অভিশপ্ত হয়।” ");
INSERT INTO benirv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","তখন বিলিয়মের প্রতি বালাক রাগে জ্বলে উঠলে তিনি নিজের হাতে আঘাত করলেন। বালাক বিলিয়মকে বললেন, “আমার শত্রুদেরকে অভিশাপ দিতে আমি আপনাকে এনেছিলাম, আর দেখুন, এই তিনবার আপনি তাদেরকে আশীর্বাদ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","এখন নিজের জায়গায় পালিয়ে যান। আমি বলেছিলাম, আপনাকে ভালো পুরষ্কার দেব, কিন্তু দেখুন, সদাপ্রভু আপনাকে পুরষ্কার বিহীন করলেন।” ");
INSERT INTO benirv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","তাতে বিলিয়ম বালাককে বলল, “আমি কি আপনার পাঠানো দূতেদের সাক্ষাৎেই বলিনি, ");
INSERT INTO benirv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","যতই বালাক সোনা ও রূপাই ভর্তি নিজের বাড়ি আমাকে দেন, তবুও আমি নিজের ইচ্ছায় ভাল কি মন্দ করার জন্য সদাপ্রভুর আদেশ অমান্য করতে পারব না। সদাপ্রভু যা বলবেন, আমি তাই বলতে পারব? ");
INSERT INTO benirv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","এখন দেখুন, আমি নিজের লোকেদের কাছে ফিরে যাই। আসুন, এই জাতি আগামী দিনের আপনার জাতির সঙ্গে কি করবে, তা আপনাকে জানাই।” ");
INSERT INTO benirv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","পরে সে তার ভাববাণী গ্রহণ করে বলল, “বিয়োরের ছেলে বিলিয়ম বলছে, যার চোখ ভালোভাবে খোলা ছিল, সেই পুরুষ বলছে। ");
INSERT INTO benirv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","যে ঈশ্বরের বাক্যগুলি শোনে, যে পরাৎপরের প্রজ্ঞা জানে, যে সর্বশক্তিমানের দর্শন পায়, সে নত ও খোলা চোখে বলছে। ");
INSERT INTO benirv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","আমি তাকে দেখব, কিন্তু এখন নয়, তাঁকে দর্শন করব, কিন্তু কাছাকাছি নয়। যাকোবের থেকে একটি তারা উঠবে, ইস্রায়েল থেকে একটি রাজদণ্ড উঠবে, তা মোয়াবের নেতাদের ধ্বংস করবে, সেথের সমস্ত সন্তানদের হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","তখন ইদোম ইস্রায়েলের অধিকারে হবে, তার শত্রু সেয়ীরও তাদের অধিকারে হবে, আর ইস্রায়েল বীরের কাজ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","যাকোব থেকে একজন রাজা আসবেন যে কর্তৃত্ব করবেন এবং শহরের অবশিষ্ট লোকদেরকে বিনষ্ট করবেন।” ");
INSERT INTO benirv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","তখন বিলিয়ম অমালেকের দিকে তাকিয়ে তার ভাববাণী শুরু করল। সে বলল, “অমালেক জাতিদের মধ্যে প্রথম ছিল, কিন্তু বিনাশ এর শেষ দশা হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","তখন বিলিয়ম কেনীয়দের দিকে তাকিয়ে তার ভাববাণী শুরু করল। সে বলল, “যেখানে তুমি বসবাস কর সেটা মজবুত, তোমার বাসা শিলাতে স্থাপিত। ");
INSERT INTO benirv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","তবুও কেন ক্ষয় পাবে, শেষে অশূর তোমাকে বন্দি করে নিয়ে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","তখন বিলিয়ম তার সর্বশেষ ভাববাণী শুরু করল। সে বলল, “হায়! যখন ঈশ্বর এইসব করবেন, তখন কে বাঁচবে? ");
INSERT INTO benirv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","কিত্তীমের তীর থেকে জাহাজ আসবে; তারা অশূরকে দুঃখ দেবে, এবরকে দুঃখ দেবে, কিন্তু তাদেরও বিনাশ ঘটবে।” ");
INSERT INTO benirv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","তখন বিলিয়ম উঠে তার বাড়ি ফিরে গেল এবং বালাকও নিজের পথে চলে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ইস্রায়েল শিটীমে বাস করল এবং লোকেরা মোয়াবের মেয়েদের সঙ্গে ব্যভিচার করতে শুরু করল। ");
INSERT INTO benirv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","সেই মেয়েরা তাদেরকে নিজেদের দেবতার উদ্দেশ্যে উত্সর্গ করা বলি খাওয়ার জন্য নিমন্ত্রণ করল এবং লোকেরা খেয়ে তাদের দেবতাদের কাছে প্রণাম করল। ");
INSERT INTO benirv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ইস্রায়েলের লোকেরা বাল্‌ পিয়োর দেবতার প্রতি আসক্ত হতে লাগল এবং ইস্রায়েলের বিরুদ্ধে সদাপ্রভু রাগে জ্বলে উঠলেন। ");
INSERT INTO benirv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","সদাপ্রভু মোশিকে বললেন, “তুমি লোকেদের সমস্ত নেতাকে হত্যা করে লোকেদের দ্বারা দেখার জন্য আমার উদ্দেশ্যে সূর্য্যের সামনে টাঙ্গিয়ে দাও, তাতে ইস্রায়েলের থেকে আমার প্রচণ্ড রাগ কমবে।” ");
INSERT INTO benirv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","তখন মোশি ইস্রায়েলের নেতাদেরকে বললেন, “তোমরা প্রত্যেকে বাল্‌ পিয়োরের প্রতি আসক্ত লোকেদেরকে হত্যা কর।” ");
INSERT INTO benirv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","তখন ইস্রায়েল সন্তানদের মধ্যে এক পুরুষ তার আত্মীয়দের মধ্যে একজন মিদিয়নীয়া স্ত্রীকে আনল। এইসব মোশির ও ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীর সাক্ষাৎে ঘটল, যখন লোকেরা সমাগম তাঁবুর প্রবেশপথে কাঁদছিল। ");
INSERT INTO benirv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","যখন পীনহস, ইলীয়াসরের ছেলে, হারোণ যাজকের নাতি এইসব দেখে মণ্ডলীর মধ্যে থেকে উঠে হাতে বর্শা নিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","তিনি সেই ইস্রায়েলীয় পুরুষের পিছু পিছু তাঁবুতে প্রবেশ করে ওই দুই জনকে, সেই ইস্রায়েলীয় পুরুষকে এবং সেই স্ত্রীকে, তাদের শরীরে বিদ্ধ করলেন। তাতে ঈশ্বর ইস্রায়েল সন্তানদের মধ্যে যে মহামারী পাঠিয়েছিলেন তা থেমে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","যারা ঐ মহামারীতে মারা গিয়েছিল, তাদের সংখ্যা চব্বিশ হাজার। ");
INSERT INTO benirv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“লোকদের মধ্যে আমার পক্ষে অন্তরের জ্বালা প্রকাশ করাতে পীনহস, ইলীয়াসরের ছেলে, হারোণ যাজকের নাতি ইস্রায়েল সন্তানদের থেকে আমার রাগ থামাল। তাই জন্য আমি প্রচণ্ড রাগে ইস্রায়েল সন্তানদের হত্যা করলাম না। ");
INSERT INTO benirv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","অতএব তুমি এই কথা বল, ‘দেখ, আমি তাকে আমার শান্তির নিয়ম দিয়েছি। ");
INSERT INTO benirv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","তা তার পক্ষে ও তার ভাবী বংশের পক্ষে চিরস্থায়ী যাজকত্বের নিয়ম হবে, কারণ সে আমাকে, তার ঈশ্বরের অন্তরের জ্বালা প্রকাশ করেছে। সে ইস্রায়েল সন্তানদের জন্য প্রায়শ্চিত্ত করেছে’।” ");
INSERT INTO benirv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ইস্রায়েলীয় যে পুরুষ ঐ মিদিয়নীয়া স্ত্রীর সঙ্গে হত হয়েছিল, তার নাম সিম্রি, সে সালূর ছেলে; সে শিমিয়োনীয়দের একজন পূর্বপুরুষের নেতা ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","মিদিয়নীয়া স্ত্রীর নাম কস্‌বী, সে সূরের মেয়ে, ঐ সূর মিদিয়নের মধ্যে এক গোষ্ঠীর প্রধান ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","তাই সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“তুমি মিদিয়নীয়দের শত্রুদের মত আচরণ কর ও আঘাত কর। ");
INSERT INTO benirv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","কারণ তারা যেমন তোমার সঙ্গে তাদের কুটিলতায় শত্রুর মত আচরণ করেছিল। তারা পিয়োর বিষয়ক মন্দতায় এবং সেই পিয়োর জন্য মহামারীর দিনের হতা তাদের আত্মীয়া কস্‌বী নামী মিদিয়নীয়া নেতার মেয়ে বিষয়ক মন্দতায় তোমাদেরকে পরিচালিত করেছিল।” ");
INSERT INTO benirv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","মহামারীর পরে সদাপ্রভু মোশিকে ও হারোণের ছেলে ইলীয়াসর যাজককে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“তোমরা ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীর মধ্যে নিজের পূর্বপুরুষ অনুসারে কুড়ি বছর ও তার থেকে বেশি বয়সী লোকেদেরকে, ইস্রায়েলের যুদ্ধে যাবার যোগ্য সমস্ত লোককে, গণনা কর।” ");
INSERT INTO benirv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","তাতে মোশি ও ইলীয়াসর যাজক যিরীহোর কাছে অবস্থিত যর্দ্দনের পাশে মোয়াবের সমভূমিতে তাদেরকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“কুড়ি বছর ও তার থেকে বয়সী লোকেদেরকে গণনা কর, যেমন সদাপ্রভু মোশিকে ও মিশর দেশ থেকে আসা ইস্রায়েল সন্তানদের আদেশ দিয়েছিলেন।” ");
INSERT INTO benirv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","রূবেণ ইস্রায়েলের প্রথমজাত। রূবেণের সন্তানরা; হনোক থেকে হনোকীয় গোষ্ঠী; পল্লূ থেকে পল্লূয়ীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","হিষ্রোণ থেকে হিষ্রোণীয় গোষ্ঠী; কর্ম্মি থেকে কর্ম্মীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","এরা রূবেণীয় গোষ্ঠী; এদের মধ্যে গণনা করা লোক তেতাল্লিশ হাজার সাতশো ত্রিশ জন। ");
INSERT INTO benirv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","পল্লূর সন্তান ইলীয়াব। ");
INSERT INTO benirv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ইলীয়াবের সন্তান নমূয়েল, দাথন ও অবীরাম। এরাই সেই দাথন ও অবীরাম যারা কোরহের দলকে অনুসরণ করেছিল যখন তারা মোশির ও হারোণের বিরুদ্ধে অভিযোগ করেছিল এবং সদাপ্রভুর বিরুদ্ধে বিদ্রোহ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","সেই দিনের পৃথিবী মুখ খুলে তাদেরকে ও কোরহকে গিলে ফেলেছিল, তাতে সেই দল মারা গেল এবং আগুন দুশো পঞ্চাশ জনকে গিলে ফেলল, আর তারা নিদর্শন স্বরূপ হল। ");
INSERT INTO benirv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","কিন্তু কোরহের সন্তানেরা মারা যায় নি। ");
INSERT INTO benirv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","নিজেদের গোষ্ঠী অনুসারে শিমিয়োনের সন্তানরা; নমূয়েল থেকে নমূয়েলীয় গোষ্ঠী; যামীন থেকে যামীনীয় গোষ্ঠী; যাখীন থেকে যাখীনীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","সেরহ থেকে সেরহীয় গোষ্ঠী; শৌল থেকে শৌলীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","শিমিয়োনীয়দের এইসব গোষ্ঠীতে বাইশ হাজার দুশো লোক ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","নিজেদের গোষ্ঠী অনুসারে গাদের সন্তানরা; সিফোন থেকে সিফোনীয় গোষ্ঠী; হগি থেকে হগীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","শূনি থেকে শূনীয় গোষ্ঠী; ওষ্ণি থেকে ওষ্ণীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","এরি থেকে এরীয় গোষ্ঠী; অরোদ থেকে অরোদীয় গোষ্ঠী; অরেলি থেকে অরেলীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","গাদের সন্তানদের এইসব গোষ্ঠী গণনা করা হলে চল্লিশ হাজার পাঁচশো লোক হল। ");
INSERT INTO benirv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","যিহূদার ছেলে এর ও ওনন; এর ও ওনন কনান দেশে মারা গিয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","নিজেদের গোষ্ঠী অনুসারে যিহূদার সন্তানরা; শেলা থেকে শেলায়ীয় গোষ্ঠী; পেরস থেকে পেরসীয় গোষ্ঠী; সেরহ থেকে সেরহীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","আর পেরসের এই সকল সন্তান; হিষ্রোণ থেকে হিষ্রোণীয় গোষ্ঠী; হামূল থেকে হামূলীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","যিহূদার এইসব গোষ্ঠী গণনা করা হলে ছেয়াত্তর হাজার পাঁচশো লোক হল। ");
INSERT INTO benirv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","নিজেদের গোষ্ঠী অনুসারে ইষাখরের সন্তানরা; তোলয় থেকে তোলয়ীয় গোষ্ঠী; পূয় থেকে পূনীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","যাশূব থেকে যাশূবীয় গোষ্ঠী; শিম্রোণ থেকে শিম্রোণীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ইষাখরের এইসব গোষ্ঠী গণনা করা হলে চৌষট্টি হাজার তিনশো লোক হল। ");
INSERT INTO benirv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","নিজেদের গোষ্ঠী অনুসারে সবূলূনের সন্তানরা; সেরদ থেকে সেরদীয় গোষ্ঠী; এলোন থেকে এলোনীয় গোষ্ঠী; যহলেল থেকে যহলেলীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","সবূলূনীয়দের এইসব গোষ্ঠী গণনা করা হলে ষাট হাজার পাঁচশো লোক হল। ");
INSERT INTO benirv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","নিজেদের গোষ্ঠী অনুসারে যোষেফের ছেলে, মনঃশি ও ইফ্রয়িম। ");
INSERT INTO benirv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","মনঃশির সন্তানরা; মাখীর থেকে মাখীরীয় গোষ্ঠী; মাখীরের ছেলে গিলিয়দ; গিলিয়দ থেকে গিলিয়দীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","গিলিয়দের সন্তানরা; ঈয়েষর থেকে ঈয়েষরীয় গোষ্ঠী; হেলক থেকে হেলকীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","অস্রীয়েল থেকে অস্রীয়েলীয় গোষ্ঠী; শেখম থেকে শেখমীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","শিমীদা থেকে শিমীদায়ীয় গোষ্ঠী; হেফর থেকে হেফরীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","হেফরের ছেলে যে সলফাদ, তার ছেলে ছিল না, শুধু মেয়ে ছিল; সেই সলফাদের মেয়েদের নাম মহলা, নোয়া, হগ্‌লা, মিল্‌কা ও তির্সা। ");
INSERT INTO benirv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","এরা মনঃশির গোষ্ঠী; এদের গণনা করা লোক বাহান্ন হাজার সাতশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","নিজেদের গোষ্ঠী অনুসারে ইফ্রয়িমের সন্তানরা এই; শূথলহ থেকে শূথলহীয় গোষ্ঠী; বেখর থেকে বেখরীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","তহন থেকে তহনীয় গোষ্ঠী। আর এরা শূথলহের সন্তান; এরণ থেকে এরণীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ইফ্রয়িমের সন্তানদের এইসব গোষ্ঠী গণনা করা হলে বত্রিশ হাজার পাঁচশো লোক হল; নিজেদের গোষ্ঠী অনুসারে এরা যোষেফের সন্তান। ");
INSERT INTO benirv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","নিজেদের গোষ্ঠী অনুসারে বিন্যামীনের সন্তানরা; বেলা থেকে বেলায়ীয় গোষ্ঠী; অসবেল থেকে অসবেলীয় গোষ্ঠী; অহীরাম থেকে অহীরামীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","শূফম থেকে শূফমীয় গোষ্ঠী; হূফম থেকে হূফমীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","আর বেলার সন্তান অর্দ ও নামান; অর্দ থেকে অর্দীয় গোষ্ঠী; নামান থেকে নামানীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","নিজেদের গোষ্ঠী অনুসারে এরা বিন্যামীনের সন্তান। এদের গণনা করা লোক পঁয়তাল্লিশ হাজার ছয়শো জন। ");
INSERT INTO benirv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","নিজেদের গোষ্ঠী অনুসারে দানের এইসব সন্তান; শূহম থেকে শূহমীয় গোষ্ঠী; নিজেদের গোষ্ঠী অনুসারে দানের গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","শূহমীয় সমস্ত গোষ্ঠী গণনা করা হলে চৌষট্টি হাজার চারশো লোক হল। ");
INSERT INTO benirv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","নিজেদের গোষ্ঠী অনুসারে আশেরের সন্তানরা; যিম্ন থেকে যিম্নীয় গোষ্ঠী; যিস্‌বি থেকে যিস্‌বীয় গোষ্ঠী; বরিয় থেকে বরিয়ীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","এরা বরিয়ের সন্তান; হেবর থেকে হেবরীয় গোষ্ঠী; মল্কীয়েল থেকে মল্কীয়েলীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","আশেরের মেয়ের নাম সারহ। ");
INSERT INTO benirv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","আশেরের সন্তানদের এইসব গোষ্ঠী গণনা করা হলে তিপ্পান্ন হাজার চারশো লোক হল। ");
INSERT INTO benirv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","নিজেদের গোষ্ঠী অনুসারে নপ্তালির সন্তানরা; যহসীয়েল থেকে যহসীয়েলীয় গোষ্ঠী; গূনি থেকে গূনীয় গোষ্ঠী; ");
INSERT INTO benirv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","যেৎসর থেকে যেৎসরীয় গোষ্ঠী; শিল্লেম থেকে শিল্লেমীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","নিজেদের গোষ্ঠী অনুসারে এই সকল নপ্তালির গোষ্ঠী। এদের গণনা করা লোক পঁয়তাল্লিশ হাজার চারশো জন। ");
INSERT INTO benirv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ইস্রায়েল সন্তানের মধ্যে গণনা করা এইসব লোকের সংখ্যা ছয় লক্ষ এক হাজার সাতশো ত্রিশ জন। ");
INSERT INTO benirv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“নাম সংখ্যা অনুসারে অধিকারের জন্য এদের মধ্যে দেশ বিভক্ত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","যার লোক বেশি, তুমি তাকে বেশি অধিকার দেবে ও যার লোক অল্প, তাকে অল্প অধিকার দেবে; যার যত গণনা করা লোক, তাকে তত অধিকার দেওয়া যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","তবে দেশ গুলিবাঁটের মাধ্যমে বিভক্ত হবে; তারা নিজেদের পূর্বপুরুষের বংশ অনুসারে অধিকার পাবে। ");
INSERT INTO benirv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","অধিকার বেশি কি অল্প হোক, গুলিবাঁটের মাধ্যমেই বিভক্ত হবে।” ");
INSERT INTO benirv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","নিজেদের গোষ্ঠী অনুসারে লেবীয়দের মধ্যে এইসব লোক গণনা করা হল; গের্শোন থেকে গের্শোনীয় গোষ্ঠী, কহাৎ থেকে কহাতীয় গোষ্ঠী, মরারি থেকে মরারীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","লেবীয় গোষ্ঠী এই গুলি; লিবনীয় গোষ্ঠী, হিব্রোণীয় গোষ্ঠী, মহলীয় গোষ্ঠী, মূশীয় গোষ্ঠী, কোরহীয় গোষ্ঠী। ");
INSERT INTO benirv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ঐ কহাতের ছেলে অম্রাম। অম্রামের স্ত্রীর নাম যোকেবদ, তিনি লেবির মেয়ে, মিশরে লেবির ঔরসে তাঁর জন্ম হয়। তিনি অম্রামের জন্য হারোণ, মোশি ও তাদের বোন মরিয়মকে প্রসব করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","হারোণ থেকে নাদব ও অবীহূ এবং ইলীয়াসর ও ঈথামর জন্মেছিল। ");
INSERT INTO benirv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","কিন্তু সদাপ্রভুর সামনে ইতর আগুন নিবেদন করার জন্য নাদব ও অবীহূ মারা পড়ে। ");
INSERT INTO benirv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","এই সবার মধ্যে এক মাস ও তার থেকে বেশি বয়সী পুরুষ গণনা করা হলে তেইশ হাজার জন হল; ইস্রায়েল সন্তানের মধ্যে তাদেরকে কোন অধিকার না দেওয়াতে তাদের ইস্রায়েল সন্তানের মধ্যে গণনা করা হয়নি। ");
INSERT INTO benirv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","এইসব লোক মোশি ও ইলীয়াসর যাজকের কর্তৃত্বে গণনা করা হল। তাঁরা যিরীহোর কাছে অবস্থিত যর্দ্দনের পাশের মোয়াবের উপভূমিতে ইস্রায়েল সন্তানদের গণনা করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","কিন্তু মোশি ও হারোণ যাজক যখন সীনয় মরুপ্রান্তে ইস্রায়েল সন্তানদের গণনা করেছিলেন, তখন যাদের তাঁদের কর্তৃত্বে গণনা করা হয়েছিল, তাঁদের একজনও এদের মধ্যে ছিল না। ");
INSERT INTO benirv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","কারণ সদাপ্রভু তাদের বিষয়ে বলেছিলেন, তারা মরুপ্রান্তে মারা যাবেই; আর তাদের মধ্যে যিফূন্নির ছেলে কালেব ও নূনের ছেলে যিহোশূয় ছাড়া একজনও অবশিষ্ট থাকল না। ");
INSERT INTO benirv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","তখন যোষেফের ছেলে মনঃশির গোষ্ঠীর অন্তর্ভুক্ত সলফাদের মেয়েরা আসল। সলফাদ হেফরের সন্তান, হেফর গিলিয়দের সন্তান, গিলিয়দ মাখীরের সন্তান, মাখীর মনঃশির সন্তান। সেই মেয়েদের নাম এই, মহলা, নোয়া, হগ্‌লা, মিল্কা ও তির্সা। ");
INSERT INTO benirv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","তারা মোশির সামনে ও ইলীয়াসর যাজকের সামনে এবং নেতাদের ও সমস্ত মণ্ডলীর সামনে সমাগম তাঁবুর প্রবেশপথে দাঁড়িয়ে এই কথা বলল, ");
INSERT INTO benirv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“আমাদের বাবা মরুপ্রান্তে মারা গেছেন, তিনি কোরহের দলের মধ্যে, সদাপ্রভুর বিরুদ্ধে চক্রান্তকারীদের দলের মধ্যে ছিলেন না; কিন্তু তিনি নিজের পাপে মারা গেছেন এবং তাঁর কোন ছেলে নেই। ");
INSERT INTO benirv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","আমাদের বাবার ছেলে হয়নি বলে তাঁর গোষ্ঠী থেকে তাঁর নাম কেন লোপ পাবে? আমাদের বাবার বংশের ভাইদের মধ্যে আমাদেরকে অধিকার দিন।” ");
INSERT INTO benirv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","তখন মোশি সদাপ্রভুর সামনে তাদের বিচার উপস্থিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“সলফাদের মেয়েরা ঠিকই বলছে; তুমি তাদের বাবার বংশের ভাইদের মধ্যে অবশ্যই তাদেরকে নিজের অধিকার দেবে ও তাদের বাবার অধিকার তাদেরকে সমর্পণ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ইস্রায়েল সন্তানদের বল, ‘কোন ব্যক্তি যদি মারা যায় এবং তার ছেলে না থাকে, তবে তোমরা তার অধিকার তার মেয়েকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","যদি মেয়ে না থাকে, তবে তার ভাইদেরকে তার অধিকার দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","যদি তার ভাই না থাকে, তবে তার বাবার ভাইদেরকে তার অধিকার দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","যদি তার বাবার ভাই না থাকে, তবে তার গোষ্ঠীর মধ্যে কাছের কোন আত্মীয়কে তার অধিকার দেবে, সে তা অধিকার করবে; সদাপ্রভু মোশিকে যেমন আদেশ দিয়েছিলেন, সেই অনুসারে এটা ইস্রায়েল সন্তানদের পক্ষে বিচারের নিয়ম হবে’।” ");
INSERT INTO benirv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","সদাপ্রভু মোশিকে বললেন, “তুমি এই অবারীম পর্বতে ওঠ, আর যে দেশ আমি ইস্রায়েল সন্তানকে দিয়েছি, তা দেখ। ");
INSERT INTO benirv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","দেখার পর তোমার ভাই হারোণের মত তুমিও তোমার লোকেদের সঙ্গে জড়ো হবে। ");
INSERT INTO benirv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","এটা ঘটবে কারণ তোমরা দুজনে সীন মরুপ্রান্তে আমার আদেশের বিরুদ্ধে বিদ্রোহ করেছিলে। সেখানে, যখন জল শিলার মধ্যে থেকে প্রবাহিত হয়েছে, তুমি রাগে পুরো মণ্ডলীর চোখে আমাকে পবিত্র রূপে মান্য করতে ব্যর্থ হয়েছ।” এ সীন প্রান্তরের কাদেসে অবস্থিত মরীবার জল। ");
INSERT INTO benirv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","তখন মোশি সদাপ্রভুকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“সমস্ত মানুষের আত্মাদের ঈশ্বর সদাপ্রভু মণ্ডলীর উপরে এমন একজন ব্যক্তিকে নিযুক্ত করুন, ");
INSERT INTO benirv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","যে তাদের সামনে বাইরে যায় ও তাদের সামনে ভিতরে আসে এবং তাদেরকে বাইরে পরিচালিত করে ও ভিতরে নিয়ে আসে; যেন সদাপ্রভুর মণ্ডলী মেষপালকহীন ভেড়ার পালের মত না হয়।” ");
INSERT INTO benirv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","সদাপ্রভু মোশিকে বললেন, “নূনের ছেলে যিহোশূয়, যার মধ্যে আমার আত্মা বসবাস করে এবং তুমি তাকে নিয়ে তার মাথায় হাত রাখো। ");
INSERT INTO benirv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ইলীয়াসর যাজকের ও সমস্ত মণ্ডলীর সামনে তাকে উপস্থিত কর এবং তাদের সাক্ষাৎে তাকে পরিচালনা করতে আদেশ দাও। ");
INSERT INTO benirv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","তাকে তোমার ক্ষমতা তার ওপর দাও, তার ফলে ইস্রায়েল সন্তানদের সমস্ত মণ্ডলী তাকে মেনে চলে। ");
INSERT INTO benirv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","সে ইলীয়াসর যাজকের সামনে দাঁড়াবে এবং ইলীয়াসর তার জন্য ঊরীমের বিচারের মাধ্যমে দ্বারা আমার ইচ্ছা জিজ্ঞাসা করবে। সে ও তার সঙ্গে সমস্ত ইস্রায়েল সন্তান, অর্থাৎ সমস্ত মণ্ডলী তার আদেশে বাইরে যাবে ও তার আদেশে ভিতরে আসবে।” ");
INSERT INTO benirv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","তাই মোশি সদাপ্রভুর আদেশ মত কাজ করলেন। তিনি যিহোশূয়কে নিয়ে ইলীয়াসর যাজকের সামনে ও সমস্ত মণ্ডলীর সামনে উপস্থিত করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","তিনি তাঁর মাথায় হাত রাখলেন এবং পরিচালনা করতে আদেশ দিলেন, যেমন সদাপ্রভু তাঁকে করতে বলেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","তুমি ইস্রায়েল সন্তানদের আদেশ কর, তাদেরকে বল, আমার উপহার, আমার উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে তৈরী ভক্ষ্য নৈবেদ্য, সঠিক দিনের আমার উদ্দেশ্যে নিবেদন করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","তুমি তাদেরকে এই কথা বল, তোমরা সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার হিসাবে এইসব নিবেদন করবে প্রতিদিন, নিত্য হোমাবলির জন্য এক বছরের নির্দোষ দুইটি পুরুষ ভেড়া। ");
INSERT INTO benirv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","তোমরা একটি ভেড়ার বাচ্চা সকালে উৎসর্গ করবে, আর একটি ভেড়ার বাচ্চা সন্ধ্যাবেলায় উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","তোমরা ভক্ষ্য নৈবেদ্যের জন্য হিনের চার ভাগের এক ভাগ উখলিতে তৈরী তেলে মেশানো ঐফার দশ ভাগের এক ভাগ সূজি দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","এটা প্রতিদিনের র হোমবলি যেটা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে তৈরী উপহার হিসাবে সীনয় পর্বতে নির্ধারিত হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","একটি ভেড়ার বাচ্চার জন্য হিনের চার ভাগের এক ভাগ পেয় নৈবেদ্য হবে। তুমি পবিত্র স্থানে সদাপ্রভুর উদ্দেশ্যে মদিরার পেয় নৈবেদ্য ঢেলে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","একটি ভেড়ার বাচ্চা সন্ধ্যাবেলায় উৎসর্গ করবে, সকালের ভক্ষ্য ও পেয় নৈবেদ্যের মত তাও সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে তৈরী উপহার হিসাবে উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","বিশ্রামবারে এক বছরের নির্দোষ দুইটি পুরুষ ভেড়া ও তেল মেশানো এক ঐফার দুয়ের দশ ভাগের এক ভাগ সূজির ভক্ষ্য নৈবেদ্য ও তার সঙ্গে পেয় নৈবেদ্য নিবেদন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","এইগুলি প্রতিদিনের র হোমবলি ও তার সঙ্গে পেয় নৈবেদ্য ছাড়া প্রতি বিশ্রামবারের হোমবলি। ");
INSERT INTO benirv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","প্রতি মাসের শুরুতে তোমরা সদাপ্রভুর উদ্দেশ্যে হোমবলির জন্য নির্দোষ দুইটি ষাঁড়ের বাচ্চা, একটি ভেড়া ও এক বছরের সাতটি পুরুষ ভেড়া উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","তোমরা এক একটি ষাঁড়ের জন্য তিনের দশ ভাগের এক ভাগ তেল মেশানো সূজির ভক্ষ্য নৈবেদ্য এবং সেই ভেড়ার জন্য দুয়ের দশ ভাগের এক ভাগ তেল মেশানো সূজির ভক্ষ্য নৈবেদ্য উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","তোমরা এক একটি ভেড়ার বাচ্চার জন্য এক এক দশ ভাগের এক ভাগ তেল মেশানো সূজির ভক্ষ্য নৈবেদ্য। তাতে সেই হোমবলি সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে তৈরী উপহার হবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","এক একটি ষাঁড়ের জন্য হিনের অর্ধেক, সেই ভেড়ার জন্য হিনের তিন ভাগের এক ভাগ ও এক একটি ভেড়ার বাচ্চার জন্য হিনের চার ভাগের এক ভাগ আঙ্গুর রস তার পেয় নৈবেদ্য হবে। এটা বছরের প্রতি মাসের মাসিক হোমবলি। ");
INSERT INTO benirv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","পাপার্থক বলির জন্য সদাপ্রভুর উদ্দেশ্যে একটি পুরুষ ছাগল। প্রতিদিনের র হোমবলি ও তার পেয় নৈবেদ্য ছাড়াও এটা উৎসর্গ করতে হবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","প্রথম মাসের চৌদ্দতম দিনের সদাপ্রভুর নিস্তারপর্ব্ব। ");
INSERT INTO benirv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","এই মাসের পনেরোতম দিনের উৎসব হবে; সাত দিন তাড়ীশূন্য রুটি খেতে হবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","প্রথম দিনের পবিত্র সভা হবে; তোমরা কোন রকম কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","কিন্তু সদাপ্রভুর উদ্দেশ্যে আগুনে তৈরী উপহার হিসাবে হোমবলির দোষমুক্ত দুইটি ষাঁড়ের বাচ্চা, একটি ভেড়া ও এক বছরের সাতটি পুরুষ ভেড়া উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ভক্ষ্য নৈবেদ্য হিসাবে এক একটি ষাঁড়ের জন্য তিন দশ ভাগের এক ভাগ ও সেই ভেড়ার জন্য দুয়ের দশ ভাগের এক ভাগ। ");
INSERT INTO benirv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","তার সঙ্গে সাতটি ভেড়ার বাচ্চার মধ্যে এক এক বছরের জন্য একের দশ ভাগের এক ভাগ তেল মেশানো সূজি ");
INSERT INTO benirv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","এবং তোমাদের প্রায়শ্চিত্ত করার জন্য পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল। ");
INSERT INTO benirv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","এই সমস্ত তোমরা প্রতিদিনের র হোমবলির জন্য সকালের হোমবলি ছাড়াও নিবেদন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","এই নিয়ম অনুসারে তোমরা সাত দিন ধরে প্রতিদিন সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে তৈরী উপহার হিসাবে ভক্ষ্য নিবেদন করবে; প্রতিদিনের র হোমবলি ও তার পেয় নৈবেদ্য ছাড়াও এটা নিবেদিত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","সপ্তম দিনের তোমাদের পবিত্র সভা হবে; তোমরা কোনো রকম কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","আবার প্রথমজাতের দিনের, যখন তোমরা নিজেদের সাত সপ্তাহের উৎসবে সদাপ্রভুর উদ্দেশ্যে নূতন ভক্ষ্য নৈবেদ্য আনবে, তখন তোমাদের পবিত্র সভা হবে; তোমরা কোন রকম কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","কিন্তু সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য হোমবলি হিসাবে দুইটি ষাঁড়ের বাচ্চা, একটি ভেড়া ও এক বছরের সাতটি পুরুষ ভেড়া উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","তাদের ভক্ষ্য নৈবেদ্য হিসাবে এক একটি ষাঁড়ের জন্য তিনের দশ ভাগের এক ভাগ, একটি ভেড়ার জন্য দুয়ের দশ ভাগের এক ভাগ উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","সাতটি ভেড়ার বাচ্চার মধ্যে এক এক বছরের জন্য একের দশ ভাগের এক ভাগ তেল মেশানো সূজি ");
INSERT INTO benirv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","এবং তোমাদের প্রায়শ্চিত্ত করার জন্য একটি পুরুষ ছাগল উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","যখন এই সমস্ত দোষমুক্ত পশুর সঙ্গে পেয় নৈবেদ্য উত্সর্গ করবে, এটা প্রতিদিনের র হোমবলি এবং তার ভক্ষ্য নৈবেদ্য নৈবেদ্যের সঙ্গে যুক্ত হওয়া চাই। ");
INSERT INTO benirv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","সপ্তম মাসে, মাসের প্রথম দিনের সদাপ্রভুর সম্মানে তোমাদের পবিত্র সভা হবে। তোমরা কোন রকম কাজ করবে না। সেই দিন তোমাদের তূরী ধ্বনির দিন হবে। ");
INSERT INTO benirv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","তোমরা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য হোমবলি হিসাবে নির্দোষ একটি ষাঁড়ের বাচ্চা, একটি ভেড়ার বাচ্চা ও এক বছরের সাতটি ভেড়া উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","তোমরা তাদের ভক্ষ্য নৈবেদ্য হিসাবে তেল মেশানো সূজি, সেই ষাঁড়ের জন্য তিনের দশ ভাগের এক ভাগ, ভেড়ার জন্য দুয়ের দশ ভাগের এক ভাগ ");
INSERT INTO benirv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ও সাতটি ভেড়ার মধ্যে এক এক বছরের জন্য একের দশ ভাগের এক ভাগ উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","তোমরা তোমাদের জন্য প্রায়শ্চিত্ত করার জন্য পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল উত্সর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","অমাবস্যার হোম ও তার ভক্ষ্য নৈবেদ্য এবং প্রতিদিনের র হোমবলি ও তার ভক্ষ্য নৈবেদ্য এবং নিয়ম মতে উভয়ের পেয় নৈবেদ্য ছাড়াও তোমরা সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে তৈরী উপহার হিসাবে এই সমস্ত উৎসর্গ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","সেই সপ্তম মাসের দশম দিনের তোমাদের পবিত্র সভা হবে; আর তোমরা নিজেদের প্রাণকে নম্র দুঃখ দেবে এবং কোন কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","কিন্তু সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের হোমবলি হিসাবে তোমরা একটি ষাঁড়, একটি ভেড়া ও এক বছরের সাতটি ভেড়া উৎসর্গ করবে; তোমাদের জন্য এইসব নির্দোষ হওয়া চাই। ");
INSERT INTO benirv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","তাদের ভক্ষ্য নৈবেদ্য হিসাবে সেই ষাঁড়ের জন্য তিনের দশ ভাগের এক ভাগ, সেই ভেড়ার জন্য দুয়ের দশ ভাগের এক ভাগ ");
INSERT INTO benirv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ও সাতটি ভেড়ার বাচাগুলির জন্য এক এক বছরের একের দশ ভাগের এক ভাগ তেল মেশানো সূজি, ");
INSERT INTO benirv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","এবং পাপার্থক বলি হিসাবে এক পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। পাপার্থক প্রায়শ্চিত্ত বলি, প্রতিদিনের র হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","সপ্তম মাসের পনেরোতম দিনের তোমাদের পবিত্র সভা হবে; তোমরা কোন রকম কাজ করবে না এবং সাত দিন সদাপ্রভুর উদ্দেশ্যে উৎসব পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","আর সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য আগুনে তৈরী হোমবলি হিসাবে তেরটি ষাঁড়ের বাচ্চা, দুইটি ভেড়া ও এক বছরের চৌদ্দটি ভেড়া উৎসর্গ করবে। এইসব নির্দোষ হওয়া চাই। ");
INSERT INTO benirv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","তাদের ভক্ষ্য নৈবেদ্য হিসাবে তেরটি ষাঁড়ের বাচ্চার মধ্যে প্রত্যেক বছরের জন্য তিনের দশ ভাগের এক ভাগ, দুইটি ভেড়ার মধ্যে এক একটি ভেড়ার জন্য দুয়ের দশ ভাগের এক ভাগ ");
INSERT INTO benirv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","এবং চৌদ্দটি ভেড়ার বাচ্চার মধ্যে এক এক বছরের জন্য একের দশ ভাগের এক ভাগ তেল মেশানো সূজি ");
INSERT INTO benirv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের র হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","দ্বিতীয় দিনের তোমরা নির্দোষ বারোটি ষাঁড়, দুইটি ভেড়া ও এক বছরের চৌদ্দটি পুরুষ ভেড়া ");
INSERT INTO benirv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","এবং ষাঁড়ের, ভেড়ার ও ভেড়ার বাচ্চার জন্য তাদের সংখ্যা অনুসারে নিয়ম মতে তাদের ভক্ষ্য ও পেয় নৈবেদ্য ");
INSERT INTO benirv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","আর তৃতীয় দিনের তোমরা নির্দোষ এগারটি ষাঁড়, দুইটি ভেড়া ও এক বছরের চৌদ্দটি ভেড়া ");
INSERT INTO benirv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","এবং ষাঁড়ের, ভেড়ার ও ভেড়ার বাচ্চার জন্য তাদের সংখ্যা অনুসারে নিয়ম মতে তাদের ভক্ষ্য ও পেয় নৈবেদ্য ");
INSERT INTO benirv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","চতুর্থ দিনের তোমরা নির্দোষ দশটি ষাঁড়, দুইটি ভেড়া ও এক বছরের চৌদ্দটি ভেড়া ");
INSERT INTO benirv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","এবং ষাঁড়ের, ভেড়ার ও ভেড়ার বাচ্চার জন্য তাদের সংখ্যা অনুসারে নিয়ম মতে তাদের ভক্ষ্য ও পেয় নৈবেদ্য ");
INSERT INTO benirv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের র হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","পঞ্চমতম দিনের তোমরা নির্দোষ নয়টি ষাঁড়, দুইটি ভেড়া ও এক বছরের চৌদ্দটি ভেড়া ");
INSERT INTO benirv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","এবং ষাঁড়ের বাচ্চা, ভেড়ার ও ভেড়ার বাচ্চার জন্য তাদের সংখ্যা অনুসারে নিয়ম মতে তাদের ভক্ষ্য ও পেয় নৈবেদ্য ");
INSERT INTO benirv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","আর ষষ্টতম দিনের তোমরা নির্দোষ আটটি ষাঁড়, দুইটি ভেড়া ও এক বছরের চৌদ্দটি ভেড়ার বাচ্চা ");
INSERT INTO benirv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","এবং ষাঁড়ের, ভেড়ার ও ভেড়ার বাচ্চার জন্য তাদের সংখ্যা অনুসারে নিয়ম মতে তাদের ভক্ষ্য ও পেয় নৈবেদ্য ");
INSERT INTO benirv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","সপ্তম দিনের তোমরা নির্দোষ সাতটি ষাঁড়, দুইটি ভেড়া ও এক বছরের চৌদ্দটি ভেড়া ");
INSERT INTO benirv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","এবং ষাঁড়ের, ভেড়ার ও ভেড়ার বাচ্চার জন্য তাদের সংখ্যা অনুসারে নিয়ম মতে তাদের ভক্ষ্য ও পেয় নৈবেদ্য ");
INSERT INTO benirv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের র হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","আর অষ্টম দিনের তোমাদের উৎসব হবে; তোমরা কোন রকম কাজ করবে না। ");
INSERT INTO benirv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","কিন্তু সদাপ্রভুর উদ্দেশ্যে মিষ্টি সুগন্ধের জন্য হোমবলি হিসাবে নির্দোষ একটি ষাঁড়, একটি ভেড়া ও এক বছরের সাতটি ভেড়া ");
INSERT INTO benirv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","এবং ষাঁড়ের, ভেড়ার ও ভেড়ার বাচ্চার জন্য তাদের সংখ্যা অনুসারে নিয়ম মতে তাদের ভক্ষ্য ও পেয় নৈবেদ্য ");
INSERT INTO benirv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","এবং পাপার্থক বলি হিসাবে একটি পুরুষ ছাগল, এই সমস্ত উৎসর্গ করবে। প্রতিদিনের হোমবলি এবং তার ভক্ষ্য ও পেয় নৈবেদ্য থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","এই সমস্ত তোমরা নিজেদের নির্ধারিত পর্বগুলিতে সদাপ্রভুর উদ্দেশ্যে উৎসর্গ করবে। তোমাদের হোমবলি, ভক্ষ্য ও পেয় নৈবেদ্য এবং মঙ্গলার্থক বলিদানের সঙ্গে যুক্ত যে মানত ও নিজের ইচ্ছাদত্ত উপহার, সেটা থেকে এটা আলাদা। ");
INSERT INTO benirv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","মোশি ইস্রায়েল সন্তানদের সবকিছু বললেন সদাপ্রভু তাঁকে যা যা করতে আদেশ দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","মোশি ইস্রায়েল সন্তানের বংশের নেতাদের বললেন, “সদাপ্রভু এই বিষয় আদেশ করেছেন। ");
INSERT INTO benirv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","কোন পুরুষ যদি সদাপ্রভুর উদ্দেশ্যে মানত করে, কিংবা ব্রত করতে নিজের প্রাণকে প্রতিজ্ঞার সঙ্গে বাঁধার জন্য দিব্যি করে, তবে সে নিজের কথা ব্যর্থ না করুক, তার মুখ থেকে বের হওয়া সমস্ত কথা অনুসারে কাজ করুক। ");
INSERT INTO benirv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","যখন কোন স্ত্রীলোক যৌবনকালে তার বাবার বাড়িতে বাস করার দিনের সদাপ্রভুর উদ্দেশ্যে মানত করে ও ব্রত করতে নিজেকে প্রতিজ্ঞার সঙ্গে বাঁধে ");
INSERT INTO benirv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","এবং তার বাবা যদি তার মানত ও যা দিয়ে সে তার প্রাণকে বেঁধেছে, সেই ব্রতের কথা শুনে তাকে কিছু না বলে, তবে তার সব মানত স্থির থাকবে এবং যা দিয়ে সে তার প্রাণকে বেঁধেছে, সেই ব্রতও স্থির থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","কিন্তু শোনার দিনের যদি তার বাবা তাকে বারণ করে, তবে তার কোন মানত ও যা দিয়ে সে তার প্রাণকে বেঁধেছে, সেই ব্রত স্থির থাকবে না। তার বাবার বারণ করার জন্য সদাপ্রভু তাকে মুক্ত করবেন। ");
INSERT INTO benirv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","আর যদি সে বিবাহিত হয়ে মানত করে, কিংবা যা দিয়ে সে তার প্রাণকে বেঁধেছে, তার ঠোঁট থেকে বেরোনো তাড়াহুড়ো করে বলা কোন কথা বলে ফেলে ");
INSERT INTO benirv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","এবং যদি তার স্বামী তা শুনলেও সেদিন তাকে কিছু না বলে, তবে তার মানত স্থির থাকবে এবং যা দিয়ে সে তার প্রাণকে বেঁধেছে, সেই ব্রত স্থির থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","কিন্তু শোনার দিনের যদি তার স্বামী তাকে বারণ করে, তবে সে যে মানত করেছে ও তার ঠোঁট থেকে বেরোনো সেই তাড়াহুড়োর কথার মাধ্যমে তার প্রাণকে বেঁধেছে, স্বামী তা ব্যর্থ করবে, আর সদাপ্রভু তাকে মুক্ত করবেন। ");
INSERT INTO benirv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","কিন্তু বিধবা কিংবা স্বামী পরিত্যক্তা স্ত্রী যা দিয়ে তার প্রাণকে বেঁধেছে, সেই ব্রতের সমস্ত কথা তার জন্য স্থির থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","আর সে যদি স্বামীর বাড়ি থাকার দিনের মানত করে থাকে, কিংবা শপথের মাধ্যমে নিজের প্রাণকে ব্রতে বেঁধে থাকে ");
INSERT INTO benirv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","এবং তার স্বামী তা শুনে তাকে বারণ না করে চুপ হয়ে থাকে, তবে তার সমস্ত মানত স্থির থাকবে এবং সে যা দিয়ে তার প্রাণকে বেঁধেছে, সেই সমস্ত ব্রত স্থির থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","কিন্তু তার স্বামী যদি শোনার দিনের সে সব ব্যর্থ করে থাকে, তবে তার মানতের বিষয়ে ও তার ব্রতের বিষয়ে তার ঠোঁট থেকে যে কথা বের হয়েছিল, তা স্থির থাকবে না। তার স্বামী তা ব্যর্থ করেছে। সদাপ্রভু সেই স্ত্রীকে মুক্ত করবেন। ");
INSERT INTO benirv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","স্ত্রীর প্রত্যেক মানত ও প্রাণকে দুঃখ দেবার প্রতিজ্ঞাযুক্ত প্রত্যেক শপথ তার স্বামী স্থির করতেও পারে, তার স্বামী ব্যর্থ করতেও পারে। ");
INSERT INTO benirv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","তার স্বামী যদি অনেক দিন পর্যন্ত তার প্রতি সব দিন চুপ থাকে, তবে সে তার সমস্ত মানত কিংবা সমস্ত ব্রত স্থির করে; শোনার দিনের চুপ থাকাতেই সে তা স্থির করেছে। ");
INSERT INTO benirv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","কিন্তু তা শোনার পর যদি কোন ভাবে স্বামী তা ব্যর্থ করে, তবে স্ত্রীর অপরাধ বহন করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","পুরুষ ও স্ত্রীর বিষয়ে এবং বাবা ও যৌবনকালে বাবার বাড়িতে থাকা মেয়ের বিষয়ে সদাপ্রভু মোশিকে এইসব আদেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“তুমি ইস্রায়েল সন্তানদের জন্য মিদিয়নীয়দেরকে প্রতিশোধ দাও। তারপর তুমি মারা যাবে এবং নিজের লোকেদের কাছে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","তখন মোশি লোকেদেরকে বললেন, “তোমাদের কিছু লোক যুদ্ধের জন্য সজ্জিত হোক, সদাপ্রভুর জন্য মিদিয়নকে প্রতিশোধ দিতে মিদিয়নের বিরুদ্ধে যাত্রা করুক। ");
INSERT INTO benirv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ইস্রায়েলের প্রত্যেক বংশ এক হাজার করে লোক যুদ্ধে পাঠাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","তাতে ইস্রায়েলের হাজার হাজারের মধ্যে এক একটি বংশ থেকে এক এক হাজার মনোনীত হলে যুদ্ধের জন্য বারো হাজার লোক সজ্জিত হল। ");
INSERT INTO benirv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","এই ভাবে মোশি এক একটি বংশের এক এক হাজার লোককে এবং ইলীয়াসর যাজকের ছেলে পীনহসকে যুদ্ধে পাঠালেন এবং পবিত্র স্থানের পাত্রগুলি ও রণবাদ্যের তূরীগুলি তাঁর অধিকারে ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","সদাপ্রভু যেভাবে মোশিকে আদেশ দিয়েছিলেন, তারা মিদিয়নের সঙ্গে যুদ্ধ করল। তারা সমস্ত পুরুষকে হত্যা করল। ");
INSERT INTO benirv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","তারা মিদিয়নের রাজাদের তাদের অন্য নিহত লোকদের সঙ্গে হত্যা করল; ইবি, রেকম, সূর, হূর ও রেবা, মিদিয়নের এই পাঁচ রাজাকে হত্যা করল; বিয়োরের ছেলে বিলিয়মকেও তরোয়াল দিয়ে হত্যা করল। ");
INSERT INTO benirv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ইস্রায়েল সন্তানরা মিদিয়নের সমস্ত স্ত্রীলোক ও বালক বালিকাদেরকে বন্দি করে নিয়ে গেল এবং তাদের সমস্ত পশু, সমস্ত ভেড়ার পাল ও সমস্ত সম্পত্তি লুট করল। ");
INSERT INTO benirv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","তাদের সমস্ত বসবাসকারী শহর ও সমস্ত শিবির পুড়িয়ে দিল। ");
INSERT INTO benirv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","তারা লুটে নেওয়া দ্রব্য এবং মানুষ কিংবা পশু, সমস্ত ধৃত জীব সঙ্গে নিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","তারা যিরীহোর কাছাকাছি যর্দ্দনের তীরে অবস্থিত মোয়াবের উপভূমিতে মোশির, ইলীয়াসর যাজকের ও ইস্রায়েল সন্তানদের সমস্ত মণ্ডলীর কাছে বন্দিদেরকে ও যুদ্ধে ধৃত জীবদেরকে এবং লুটিত দ্রব্যগুলি শিবিরে নিয়ে গেল। ");
INSERT INTO benirv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","মোশি, ইলীয়াসর যাজক ও মণ্ডলীর সমস্ত শাসনকর্ত্তা তাদের সঙ্গে সাক্ষাৎ করতে শিবিরের বাইরে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","কিন্তু যুদ্ধ থেকে ফিরে আসা সেনাপতিদের, অর্থাৎ সহস্রপতিদের ও শতপতিদের উপরে মোশি প্রচণ্ড রেগে গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","মোশি তাদেরকে বললেন, “তোমরা কি সমস্ত স্ত্রীলোককে জীবিত রেখেছ? ");
INSERT INTO benirv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","দেখ, বিলিয়মের পরামর্শে তারাই পিয়োর দেবতার বিষয়ে ইস্রায়েল সন্তানদের সদাপ্রভুর বিরুদ্ধে পাপ করিয়েছিল, তার জন্যই সদাপ্রভুর মণ্ডলীতে মহামারী হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","অতএব তোমরা এখন বালক বালিকাদের মধ্যে সমস্ত বালককে হত্যা কর এবং পুরুষের সঙ্গে শোয়া সমস্ত স্ত্রীলোককেও হত্যা কর। ");
INSERT INTO benirv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","কিন্তু যে বালিকারা কোনো পুরুষের সঙ্গে শোয় নি, তাদেরকে নিজেদের জন্য জীবিত রাখ। ");
INSERT INTO benirv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","তোমরা সাত দিন শিবিরের বাইরে শিবির করে থাক; তোমরা যত লোক মানুষ হত্যা করেছ ও মৃত লোককে স্পর্শ করেছ, সবাই তৃতীয় দিনের ও সপ্তম দিনের নিজেদেরকে ও নিজেদের বন্দিদেরকে শুচি কর; ");
INSERT INTO benirv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","আর সমস্ত পোশাক, চামড়ার তৈরী সমস্ত জিনিস, ছাগলের লোমের তৈরী সমস্ত জিনিস ও কাঠের তৈরী সমস্ত জিনিসের জন্য নিজেদেরকে শুচি কর।” ");
INSERT INTO benirv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","আর যারা যুদ্ধে গিয়েছিল, ইলীয়াসর যাজক সেই যোদ্ধাদেরকে বললেন, “মোশিকে দেওয়া সদাপ্রভুর ব্যবস্থার নিয়মগুলি এই: ");
INSERT INTO benirv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","শুধু সোনা, রূপা, পিতল, লোহা, টিন ও সীসা ");
INSERT INTO benirv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","এবং যে সমস্ত দ্রব্য আগুনে নষ্ট হয় না, সেই সব আগুনের মধ্যে দিয়ে নিয়ে যাবে, তাতে তা শুচি হবে। তারপর তা বিশুদ্ধ জলে পাপমুক্ত করতে হবে; কিন্তু যে যে জিনিস আগুনে নষ্ট হয়, তা তোমরা জলের মধ্যে দিয়ে নিয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","আর সপ্তম দিনের তোমরা নিজেদের পোশাক ধোবে; তাতে শুচি হবে; পরে শিবিরে প্রবেশ করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","পরে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“তুমি ও ইলীয়াসর যাজক এবং মণ্ডলীর পূর্বপুরুষদের গোষ্ঠীর নেতা যুদ্ধে অপহৃত জীবদের, অর্থাৎ বন্দি মানুষদের ও পশুদের সংখ্যা গণনা কর। ");
INSERT INTO benirv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","আর যুদ্ধে অপহৃত সেই জীবদেরকে দুই অংশ করে, যে যোদ্ধারা যুদ্ধে গিয়েছিল, তাদের ও সমস্ত মণ্ডলীর মধ্যে ভাগ কর। ");
INSERT INTO benirv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","তখন যুদ্ধে গমনকারী যোদ্ধাদের কাছ থেকে সদাপ্রভুর জন্য কর নাও; পাঁচশো জীবের মধ্যে প্রতিটি মানুষ, গরু, গাধা ও ভেড়া। ");
INSERT INTO benirv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","তাদের অর্ধেক অংশ থেকে নিয়ে সদাপ্রভুর উদ্দেশ্যে উপস্থিত করা উপহার হিসাবে ইলীয়াসর যাজককেও দাও। ");
INSERT INTO benirv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","তুমি ইস্রায়েল সন্তানদের অর্ধেক অংশের মধ্যে মানুষ, গরু, গাধা, ভেড়া ও ছাগল প্রভৃতি সমস্ত পশুর মধ্যে থেকে পঞ্চাশটি জীবের মধ্যে থেকে একটি জীব নাও এবং সদাপ্রভুর সমাগম তাঁবুর রক্ষাকারী লেবীয়দেরকে দাও।” ");
INSERT INTO benirv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","মোশিকে সদাপ্রভু যেমন আদেশ করলেন, মোশি ও ইলীয়াসর যাজক সেই রকম করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","যোদ্ধাদের মাধ্যমে লুট করা জিনিসগুলি ছাড়া ঐ অপহৃত জীবগুলি ছয় লক্ষ পঁচাত্তর হাজার ভেড়া, ");
INSERT INTO benirv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","বাহাত্তর হাজার গরু, ");
INSERT INTO benirv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","একষট্টি হাজার গাধা, ");
INSERT INTO benirv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","আর বত্রিশ হাজার স্ত্রীলোক, অর্থাৎ যারা কখনো কোনো পুরুষের সঙ্গে শোয় নি। ");
INSERT INTO benirv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","তাতে যারা যুদ্ধে গিয়েছিল, তাদের প্রাপ্য অর্ধেক অংশের সংখ্যা হল তিন লক্ষ সাঁইত্রিশ হাজার পাঁচশো ভেড়া; ");
INSERT INTO benirv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","সেই ভেড়া থেকে সদাপ্রভুর অংশ হল ছয়শো পঁচাত্তরটি ভেড়া। ");
INSERT INTO benirv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ষাঁড় ছিল ছত্রিশ হাজার, তাদের মধ্যে বাহাত্তরটি হল সদাপ্রভুর কর। ");
INSERT INTO benirv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","গাধা ছিল ত্রিশ হাজার পাঁচশো, তাদের মধ্যে সদাপ্রভুর কর হল একষট্টিটি। ");
INSERT INTO benirv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","স্ত্রীলোক ছিল ষোল হাজার, তাদের মধ্যে সদাপ্রভুর কর হল বত্রিশ জন। ");
INSERT INTO benirv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","মোশি সেই কর সদাপ্রভুর কাছে উপহার হিসাবে উপস্থিত করলেন। সদাপ্রভু মোশিকে যেমন আদেশ দিলেন, সেই অনুসারে তিনি এগুলি ইলীয়াসর যাজককে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","মোশি যে অর্ধেক অংশ যোদ্ধাদের কাছ থেকে নিয়ে ইস্রায়েল সন্তানদের দিয়েছিলেন, ");
INSERT INTO benirv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","মণ্ডলীর সেই অর্ধেক অংশতে তিন লক্ষ সাঁইত্রিশ হাজার পাঁচশো ভেড়া, ");
INSERT INTO benirv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ছত্রিশ হাজার ষাঁড়, ");
INSERT INTO benirv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ত্রিশ হাজার পাঁচশো গাধা ");
INSERT INTO benirv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ও ষোল হাজার মানুষ ছিল। ");
INSERT INTO benirv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","মোশি ইস্রায়েল সন্তানদের সেই অর্ধেক অংশ থেকে মানুষের ও পশুর মধ্যে পঞ্চাশটি জীবের মধ্যে থেকে একটি করে জীব নিয়ে সদাপ্রভুর সমাগম তাঁবুর রক্ষাকারী লেবীয়দেরকে দিলেন, যেমন সদাপ্রভু মোশিকে আদেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","সৈন্য সামন্তের উপরে কর্তৃত্বকারী সহস্রপতিরা ও শতপতিরা মোশির কাছে আসলেন; ");
INSERT INTO benirv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","তাঁরা মোশিকে বললেন, “আপনার এই দাসেরা আমাদের অধীনে থাকা যোদ্ধাদের সংখ্যা গণনা করেছে, আমাদের মধ্যে একজনও কমে নি। ");
INSERT INTO benirv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","আমরা সবাই সোনার জিনিস, তাগা, বালা, আংটি, কানবালা ও হার, এই যা কিছু জিনিস পেয়েছি, তা থেকে সদাপ্রভুর সামনে আমাদের প্রাণের জন্য প্রায়শ্চিত্ত করতে সদাপ্রভুর উদ্দেশ্যে উপহার এনেছি।” ");
INSERT INTO benirv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","মোশি ও ইলীয়াসর যাজক তাঁদের থেকে সেই সোনা, কারিগরী সমস্ত জিনিস নিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","উত্সর্গের সমস্ত সোনা যা তাঁরা সদাপ্রভুকে দিয়েছিলেন-সহস্রপতিদের ও শতপতিদের উপহার ষোল হাজার সাতশো পঞ্চাশ শেকল পরিমাপের হল। ");
INSERT INTO benirv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","যোদ্ধারা প্রত্যেকে নিজেদের জন্য লুট করা দ্রব্য নিয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","মোশি ও ইলীয়াসর যাজক সহস্রপতিদের ও শতপতিদের কাছ থেকে সেই সোনা গ্রহণ করলেন এবং সদাপ্রভুর সামনে ইস্রায়েল সন্তানদের স্মরণের চিহ্ন হিসাবে তা সমাগম তাঁবুতে আনলেন। ");
INSERT INTO benirv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","রূবেণ সন্তানদের ও গাদ সন্তানদের অনেক পশুধন ছিল; তারা যাসের দেশ ও গিলিয়দ দেশ পর্যবেক্ষণ করল, আর দেখ, সে স্থান পশুপালনের স্থান। ");
INSERT INTO benirv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","পরে গাদ সন্তানরা ও রূবেণ সন্তানরা এসে মোশিকে, ইলীয়াসর যাজককে ও মণ্ডলীর শাসনকর্তাদেরকে বলল, ");
INSERT INTO benirv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“অটারোৎ, দীবোন, যাসের নিম্রা, হিষ্বোন, ইলিয়ালী, সেবাম, নবো ও বিয়োন, ");
INSERT INTO benirv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","এই যে দেশকে সদাপ্রভু ইস্রায়েল মণ্ডলীর সামনে আঘাত করেছেন, এটা পশুপালনের উপযুক্ত দেশ, আর আপনার এই দাসেদের পশু আছে।” ");
INSERT INTO benirv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","তারা আরও বলল, “আমরা যদি আপনার দৃষ্টিতে অনুগ্রহ পেয়ে থাকি, তবে আপনার দাসেদের অধিকারের জন্য এই দেশ দিতে আদেশ করুন, আমাদেরকে যর্দ্দনের পারে নিয়ে যাবেন না।” ");
INSERT INTO benirv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","তখন মোশি গাদ সন্তানদের ও রূবেণ সন্তানদের বললেন, “তোমাদের ভাইয়েরা যুদ্ধ করতে যাবে, আর তোমরা কি এই স্থানে বসে থাকবে? ");
INSERT INTO benirv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","সদাপ্রভুর দেওয়া দেশ পার হয়ে যেতে ইস্রায়েল সন্তানদের মন কেন নিরাশ করছ? ");
INSERT INTO benirv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","তোমাদের বাবারা, যখন আমি দেশ দেখতে কাদেশ বর্ণেয় থেকে তাদেরকে পাঠিয়েছিলাম, তখন তাই করেছিল; ");
INSERT INTO benirv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","তারা ইষ্কোলের উপত্যকা পর্যন্ত গমন করে দেশ দেখে সদাপ্রভুর দেওয়া দেশে যেতে ইস্রায়েল সন্তানদের মন নিরাশ করেছিল। ");
INSERT INTO benirv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","সেই দিন সদাপ্রভু প্রচণ্ড রেগে গিয়ে শপথ করে বলেছিলেন, ");
INSERT INTO benirv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘আমি অব্রাহামকে, ইসহাককে ও যাকোবকে যে দেশ দিতে দিব্যি করেছি, মিশর থেকে আসা পুরুষদের মধ্যে কুড়ি বছর ও তার থেকে বয়সী কেউই সেই দেশ দেখতে পাবে না; কারণ তারা সম্পূর্ণ ভাবে আমাকে মেনে চলে নি; ");
INSERT INTO benirv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","শুধু কনিসীয় যিফুন্নির ছেলে কালেব ও নূনের ছেলে যিহোশূয় তা দেখবে, কারণ তারাই সম্পূর্ণ ভাবে সদাপ্রভুর অনুগত হয়েছে’। ");
INSERT INTO benirv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","তখন ইস্রায়েলের প্রতি সদাপ্রভুর রাগ জ্বলে উঠলো, আর তিনি চল্লিশ বছর পর্যন্ত, সদাপ্রভুর দৃষ্টিতে খারাপ কাজ করা সমস্ত লোকের শেষ না হওয়া পর্যন্ত, তাদেরকে মরুপ্রান্তে ভ্রমণ করালেন। ");
INSERT INTO benirv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","আর দেখ, ইস্রায়েলের বিরুদ্ধে সদাপ্রভুর ভয়ানক রাগ আরও বেড়ে যাওয়ার জন্য, পাপী লোকেদের বংশ যে তোমরা, তোমরা তোমাদের বাবার জায়গায় উঠেছ। ");
INSERT INTO benirv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","কারণ যদি তোমরা তাঁর অনুসরণ না করে ফিরে যাও, তবে তিনি পুনরায় ইস্রায়েলকে মরুপ্রান্তে পরিত্যাগ করবেন, তাতে তোমরা এইসব লোককে বিনষ্ট করবে।” ");
INSERT INTO benirv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","তখন তারা তাঁর কাছে এসে বলল, “আমরা এই স্থানে আমাদের পশুদের জন্য মেষবাথান ও আমাদের বালকবালিকাদের জন্য শহর তৈরী করব। ");
INSERT INTO benirv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","আমরা যতদিন ইস্রায়েল সন্তানদের নিজের তৈরী না করি, ততদিন সজ্জিত হয়ে তাদের আগে আগে গমন করব; শুধু আমাদের বালকবালিকারা দেশে বসবাসীদের ভয়ে সুরক্ষিত শহরে বাস করবে। ");
INSERT INTO benirv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ইস্রায়েল সন্তানরা প্রত্যেকে যতক্ষণ নিজেদের অধিকার না পায়, ততক্ষণ আমরা নিজেদের পরিবারের কাছে ফিরে আসব না। ");
INSERT INTO benirv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","কিন্তু আমরা যর্দ্দনের অন্য পারে তাদের সঙ্গে অধিকার নেব না, কারণ যর্দ্দনের এই পূর্বপারে আমরা অধিকার পেয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","মোশি তাদেরকে বললেন, “তোমরা যদি এই কাজ কর, যদি সজ্জিত হয়ে সদাপ্রভুর সামনে যুদ্ধ করতে যাও ");
INSERT INTO benirv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","এবং তিনি যতদিন তাঁর শত্রুদেরকে নিজের কাছ থেকে অধিকারচ্যুত না করেন, ততদিন যদি তোমরা প্রত্যেকে সজ্জিত হয়ে সদাপ্রভুর সামনে যর্দ্দন পার হও ");
INSERT INTO benirv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","এবং দেশ সদাপ্রভুর বশীভূত হয়, তখন তোমরা ফিরে আসবে এবং সদাপ্রভুর ও ইস্রায়েলের কাছে নির্দোষ হবে, আর সদাপ্রভুর সামনে তোমরা এই দেশের অধিকারী হবে। ");
INSERT INTO benirv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","কিন্তু যদি তেমন না কর, তবে দেখ, তোমরা সদাপ্রভুর কাছে পাপ করলে এবং নিশ্চয় জেনো, তোমাদের পাপ তোমাদেরকে ধরবে। ");
INSERT INTO benirv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","তোমরা নিজেদের বালকবালিকাদের জন্য শহর ও ভেড়াদের জন্য বাথান তৈরী কর এবং নিজেদের কথামত কাজ কর।” ");
INSERT INTO benirv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","তখন গাদ সন্তানরা ও রূবেণ সন্তানরা মোশিকে বলল, “আমাদের প্রভু যে আদেশ করলেন, আপনার দাস আমরা তাই করব। ");
INSERT INTO benirv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","আমাদের বালকবালিকারা, আমাদের স্ত্রীলোকেরা, আমাদের পালগুলি ও আমাদের সমস্ত পশুধন এখানে গিলিয়দের শহরগুলিতে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","আর আমাদের প্রভুর বাক্য অনুসারে আপনার এই দাসেরা, সজ্জিত প্রত্যেক জন যুদ্ধ করতে সদাপ্রভুকে পার হয়ে যাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","তখন মোশি তাদের বিষয়ে ইলীয়াসর যাজককে, নূনের ছেলে যিহোশূয়কে ও ইস্রায়েল সন্তানদের বংশগুলির পূর্বপুরুষদের নেতাকে আদেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","মোশি তাদেরকে বললেন, “গাদ সন্তানরা ও রূবেণ সন্তানরা, যুদ্ধের জন্য সজ্জিত প্রত্যেক জন যদি তোমাদের সঙ্গে সদাপ্রভুর সামনে যর্দ্দন পার হয়, তবে তোমাদের সামনে দেশ বশীভূত হওয়ার পর তোমরা অধিকারের জন্য তাদেরকে গিলিয়দ দেশ দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","কিন্তু যদি তারা সজ্জিত হয়ে তোমাদের সঙ্গে পার না হয়, তবে তারা তোমাদের মধ্যে কনান দেশের অধিকার পাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","পরে গাদ সন্তানরা ও রূবেণ সন্তানরা উত্তর দিল, “সদাপ্রভু আপনার এই দাসদেরকে যা বলেছেন, আমরা তাই করব। ");
INSERT INTO benirv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","আমরা সজ্জিত হয়ে সদাপ্রভুর সামনে পার হয়ে কনান দেশে যাব; আর যর্দ্দনের পূর্বপারে আমাদের অধিকার নির্দিষ্ট হয়ে রইল।” ");
INSERT INTO benirv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","পরে মোশি তাদেরকে, অর্থাৎ গাদ সন্তানদের, রূবেণ সন্তানদের ও যোষেফের ছেলে মনঃশির অর্ধেক বংশকে ইমোরীয়দের রাজা সীহোনের রাজ্য ও বাশনের রাজা ওগের রাজ্য, সেই দেশ, পরিসীমা সমেত সেখানকার শহরগুলি অর্থাৎ দেশের চারদিকের শহরগুলি দিলেন। ");
INSERT INTO benirv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","গাদ সন্তানরা দীবোন, অটারোৎ, অরোয়ের, ");
INSERT INTO benirv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","অটরোত শোফন, যাসের, যগবিহ, ");
INSERT INTO benirv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","বৈৎ-নিম্রা ও বৈৎ-হারণ, এইসব দেওয়ালে ঘেরা শহর ও মেষবাথান তৈরী করল। ");
INSERT INTO benirv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","রূবেন সন্তানরা হিষবোন, ইলিয়ালী ও কিরিয়াথয়িম ");
INSERT INTO benirv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","নবো ও বাল্-মিয়োন (তাদের নাম পরে পরিবর্তন হয়েছে) এবং সিবমা এইসব শহর তৈরী করে অন্য নাম রাখল। ");
INSERT INTO benirv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","মনঃশির ছেলে মাখীরের সন্তানরা গিলিয়দে গিয়ে তা দখল করল এবং সেই স্থানে বসবাসকারী ইমোরীয়দেরকে অধিকারচ্যুত করল। ");
INSERT INTO benirv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","তখন মোশি মনঃশির ছেলে মাখীরকে গিলিয়দ দিলেন এবং সে সেখানে বাস করল। ");
INSERT INTO benirv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","মনঃশির সন্তান যায়ীর গিয়ে সেখানকার গ্রামগুলি দখল করল এবং তাদের নাম হব্বোৎ-যায়ীর যায়ীরের গ্রামগুলি রাখল। ");
INSERT INTO benirv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","নোবহ গিয়ে কনাৎ ও তার গ্রামগুলি দখল করল এবং নিজের নাম অনুসারে তার নাম নোবহ রাখল। ");
INSERT INTO benirv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ইস্রায়েল সন্তানরা মোশির ও হারোণের অধীনে নিজেদের সৈন্যশ্রেণী অনুসারে মিশর দেশ থেকে বের হয়ে আসল, তাদের উত্তরণ স্থানগুলির বিবরণ এই। ");
INSERT INTO benirv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","মোশি সদাপ্রভুর আদেশে তাদের যাত্রা অনুসারে সেই উত্তরণ স্থানগুলির বর্ণনা এই। ");
INSERT INTO benirv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","প্রথম মাসে, প্রথম মাসের পনেরো দিনের তারা রামিষেষ থেকে চলে গেল; নিস্তারপর্ব্বের পরের দিন ইস্রায়েল সন্তানরা মিশরীয় সমস্ত লোকের সাক্ষাৎে প্রকাশ্যে বের হল। ");
INSERT INTO benirv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","সেই দিনের মিশরীয়েরা, তাদের মধ্যে যাদেরকে সদাপ্রভু আঘাত করেছিলেন, সেই সমস্ত প্রথমজাতকে কবর দিচ্ছিল; আর সদাপ্রভু তাদের দেবতাদেরকেও (শাস্তি দিয়েছিলেন)। ");
INSERT INTO benirv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","রামিষেষ থেকে যাত্রা করে ইস্রায়েল সন্তানরা সুক্কোতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","সুক্কোৎ থেকে যাত্রা করে মরুপ্রান্তের সীমানায় অবস্থিত এথমে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","এথম থেকে যাত্রা করে বাল-সফোনের সামনে অবস্থিত পী-হহীরোতে ফিরে মিগদোলের সামনে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","হহীরোতের সামনে থেকে যাত্রা করে সমুদ্রের মধ্যে দিয়ে মরুপ্রান্তে প্রবেশ করল এবং এথম মরুপ্রান্তে তিন দিনের পথ গিয়ে মারাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","মারা থেকে যাত্রা করে এলীমে উপস্থিত হল; এলীমে জলের বারোটি উনুই ও সত্তরটি খেজুর গাছ ছিল; তারা সেখানে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","এলীম থেকে যাত্রা করে সূফসাগরের কাছে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","সূফসাগর থেকে যাত্রা করে সীন মরুপ্রান্তে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","সীন মরুভূমি থেকে যাত্রা করে দপ্কাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","দপকা থেকে যাত্রা করে আলূশে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","আলূশ থেকে যাত্রা করে রফীদীমে শিবির স্থাপন করল; সেখানে লোকেদের পান করার জল ছিল না। ");
INSERT INTO benirv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","তারা রফীদীম থেকে যাত্রা করে সীনয় মরুপ্রান্তে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","সীনয় মরুভূমি থেকে যাত্রা করে কিব্রোৎ হত্তাবাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","কিব্রোৎ হত্তাবা থেকে যাত্রা করে হৎসেরোতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","হৎসেরোৎ থেকে যাত্রা করে রিৎমাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","রিৎমা থেকে যাত্রা করে রিম্মোণ পেরসে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","রিম্মোণ পেরস থেকে যাত্রা করে লিব্‌নাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","লিব্‌না থেকে যাত্রা করে রিস্সাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","রিস্সা থেকে যাত্রা করে কহেলাথায় শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","কহেলাথা থেকে যাত্রা করে শেফর পর্বতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","শেফর পর্বত থেকে যাত্রা করে হরাদাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","হরাদা থেকে যাত্রা করে মখেলোতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","মখেলোৎ থেকে যাত্রা করে তহতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","তহৎ থেকে যাত্রা করে তেরহে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","তেরহ থেকে যাত্রা করে মিৎকাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","মিৎকা থেকে যাত্রা করে হশ্মোনাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","হশ্মোনা থেকে যাত্রা করে মোষেরোতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","মোষেরোৎ থেকে যাত্রা করে বনে-য়াকনে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","বনে-য়াকন থেকে যাত্রা করে হোর্-হগিদ্গদে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","হোর্-হগিদ্গদ থেকে যাত্রা করে যট্ বাথাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","যট-বাথা থেকে যাত্রা করে অব্রোণাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","অব্রোণা থেকে যাত্রা করে ইৎসিয়োন গেবরে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ইৎসিয়োন গেবর থেকে যাত্রা করে সিন মরুপ্রান্তে অর্থাৎ কাদেশে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","কাদেশ থেকে যাত্রা করে ইদোম দেশের শেষে অবস্থিত হোর পর্বতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","হারোণ যাজক সদাপ্রভুর আদেশ অনুসারে হোর পর্বতে উঠে মিশর থেকে ইস্রায়েল সন্তানদের বের হবার চল্লিশ বছরের পঞ্চম মাসে, সেই মাসের প্রথম দিনের সেখানে মারা গেলেন। ");
INSERT INTO benirv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","হোর পর্বতে হারোণের মৃত্যুর দিন তাঁর একশো তেইশ বছর বয়স হয়েছিল। ");
INSERT INTO benirv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","কনান দেশের দক্ষিণ অঞ্চলে বসবাসকারী কনানীয় অরাদের রাজা ইস্রায়েল সন্তানদের আসার খবর শুনলেন। ");
INSERT INTO benirv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","তারা হোর পর্বত থেকে যাত্রা করে সল্মোনাতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","সলমোনা থেকে যাত্রা করে পূনোনে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","পূনোন থেকে যাত্রা করে ওবোতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ওবোৎ থেকে যাত্রা করে মোয়াবের প্রান্তস্থিত ইয়ী-অবারীমে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ইয়ীম থেকে যাত্রা করে দীবোন-গাদে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","দীবোন-গাদ থেকে যাত্রা করে অলমোন-দিব্লাথয়িমে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","অলমোন-দিব্লাথয়িম থেকে যাত্রা করে নবোর সামনে অবস্থিত পর্বতময় অবারীম অঞ্চলে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","পর্বতময় অবারীম অঞ্চল থেকে যাত্রা করে যিরীহোর পাশে যর্দ্দনের কাছে অবস্থিত মোয়াবের উপভূমিতে শিবির স্থাপন করল। ");
INSERT INTO benirv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","সেখানে যর্দ্দনের কাছে বৈৎ-যিশীমোৎ থেকে আবেল-শিটীম পর্যন্ত মোয়াবের উপভূমিতে শিবির স্থাপন করে থাকল। ");
INSERT INTO benirv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","তখন যিরীহোর কাছাকাছি যর্দ্দনের পাশে অবস্থিত মোয়াবের উপভূমিতে সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“তুমি ইস্রায়েল সন্তানদের বল, তাদেরকে বল, ‘তোমরা যখন যর্দ্দন পার হয়ে কনান দেশে উপস্থিত হবে, ");
INSERT INTO benirv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","তখন তোমাদের সামনে থেকে সেই দেশে বসবাসকারী সবাইকে অধিকারচ্যুত করবে এবং তাদের সমস্ত প্রতিমা ভেঙে দেবে, সমস্ত ছাঁচে ঢালা মূর্ত্তি নষ্ট করবে ও সমস্ত উঁচু জায়গাগুলি উচ্ছেদ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","তোমরা সেই দেশ অধিকার করে তার মধ্যে বাস করবে; কারণ আমি অধিকারের জন্য সেই দেশ তোমাদেরকে দিয়েছি। ");
INSERT INTO benirv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","তোমরা গুলিবাঁটের মাধ্যমে নিজেদের গোষ্ঠী অনুসারে দেশ অধিকার ভাগ করে নেবে; বেশি লোককে বেশি অংশ ও অল্প লোককে অল্প অংশ দেবে; যার অংশ যেখানে পড়ে, তার অংশ সেইখানে হবে; তোমরা নিজেদের পূর্বপুরুষদের বংশ অনুসারে অধিকার পাবে। ");
INSERT INTO benirv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","কিন্তু যদি তোমরা নিজেদের সামনে থেকে সেই দেশে বসবাসকারীদেরকে অধিকারচ্যুত না কর, তবে যাদেরকে অবশিষ্ট রাখবে, তারা তোমাদের চোখে আপত্তিকর এবং তোমাদের পাশে কাঁটার মত হবে। তোমরা যে ভূমিতে বাস কর সেখানে তাদের জীবনযাত্রাকে কষ্টকর করবে। ");
INSERT INTO benirv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","তখন আমি তাদের প্রতি যা করব ভেবেছিলাম, তা তোমাদের প্রতি করব’।” ");
INSERT INTO benirv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“তুমি ইস্রায়েল সন্তানদের আদেশ দাও, তাদেরকে বল, ‘যখন তোমরা কনান দেশে প্রবেশ করবে, তোমরা অধিকারের জন্য যে দেশ পাবে, চারদিকের সীমানা অনুসারে সেই কনান দেশ। ");
INSERT INTO benirv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ইদোমের কাছে অবস্থিত সিন মরুভূমি থেকে তোমাদের দক্ষিণ অঞ্চল হবে ও পূর্বদিকে লবণ সমুদ্রের শেষভাগ থেকে তোমাদের দক্ষিণ সীমানা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","তোমাদের সীমানা অক্রব্বীম আরোহণ পথের দক্ষিণ দিকে ফিরে সিন পর্যন্ত যাবে এবং কাদেশ বার্নিয়ার দক্ষিণ প্রান্ত দিয়ে গিয়ে হৎসর-অদরে এসে অস্মোন পর্যন্ত যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","পরে ঐ সীমানা অস্মোন থেকে মিশরের নদী পর্যন্ত বেড়িয়ে আসবে এবং মহাসমুদ্র পর্যন্ত এই সীমানার শেষ হবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","পশ্চিম সীমানার জন্য মহাসমুদ্র তোমাদের পক্ষে থাকল, এটাই তোমাদের পশ্চিম সীমানা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","তোমাদের উত্তর সীমানা এটা; তোমরা মহাসমুদ্র থেকে নিজেদের জন্য হোর পর্বত লক্ষ্য করবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","হোর পর্বত থেকে হমাতের প্রবেশস্থান লক্ষ্য করবে। সেখান থেকে সেই সীমানা সদাদ পর্যন্ত ছড়িয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","তখন সেই সীমানা সিফ্রোণ পর্যন্ত যাবে ও হৎসর-ঐনন পর্যন্ত ছড়িয়ে যাবে; এটাই তোমাদের উত্তর সীমানা হবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","তখন পূর্ব সীমানার জন্য তোমরা হৎসর ঐনন থেকে শফাম লক্ষ্য করবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","তখন সেই সীমানা শফাম থেকে ঐনের পূর্ব দিক হয়ে রিব্লা পর্যন্ত নেমে যাবে; সে সীমানা নেমে পূর্বদিকে কিন্নেরৎ হ্রদের তট পর্যন্ত যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","তখন সেই সীমানা যর্দ্দন দিয়ে যাবে এবং লবণ সমুদ্র পর্যন্ত ছড়িয়ে যাবে; চারদিকের সীমানা অনুসারে এই তোমাদের দেশ হবে’।” ");
INSERT INTO benirv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","তখন মোশি ইস্রায়েল সন্তানদের এই আদেশ দিলেন, “যে দেশ তোমরা গুলিবাঁটের মাধ্যমে অধিকার করবে, সদাপ্রভু সাড়ে নয় বংশকে যে দেশ দিতে আদেশ করেছেন এই সেই দেশ। ");
INSERT INTO benirv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","কারণ নিজেদের পূর্বপুরুষদের বংশ অনুসারে রূবেণ সন্তানদের বংশ, নিজেদের পূর্বপুরুষদের বংশ অনুসারে গাদ সন্তানদের বংশ নিজের অধিকার পেয়েছে ও মনঃশির অর্ধেক বংশও পেয়েছে। ");
INSERT INTO benirv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","যিরীহোর কাছে অবস্থিত যর্দ্দনের পূর্বপারে সূর্য্যোদয়ের দিকে সেই আড়াই বংশ নিজেদের অধিকার পেয়েছে।” ");
INSERT INTO benirv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“যারা তোমাদের অধিকারের জন্য দেশ ভাগ করে দেবে, তাদের নাম এই; ইলীয়াসর যাজক ও নূনের ছেলে যিহোশূয়। ");
INSERT INTO benirv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","তোমরা প্রত্যেক বংশ থেকে একজন করে নেতাকে দেশ ভাগ করার জন্য গ্রহণ করবে। ");
INSERT INTO benirv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","সেই ব্যক্তিদের নাম এই, যিহূদা বংশের যিফূন্নির ছেলে কালেব। ");
INSERT INTO benirv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","শিমিয়োন সন্তানদের বংশের অম্মীহূদের ছেলে শমূয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","বিন্যামীন বংশের কিশ্লোনের ছেলে ইলীদদ। ");
INSERT INTO benirv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","দান সন্তানদের বংশশের নেতা যগ্লির ছেলে বুক্কি। ");
INSERT INTO benirv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","যোষেফের ছেলেদের মধ্যে মনঃশি সন্তানদের বংশের নেতা এফোদের ছেলে হন্নীয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ইফ্রয়িম সন্তানদের বংশের নেতা শিপ্তনের ছেলে কমূয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","সবূলূন সন্তানদের বংশের নেতা পর্ণকের ছেলে ইলীষাফণ। ");
INSERT INTO benirv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ইষাখর সন্তানদের বংশের নেতা অসসনের ছেলে পল্টিয়েল। ");
INSERT INTO benirv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","আশের সন্তানদের বংশের নেতা শলোমির ছেলে অহীহূদ। ");
INSERT INTO benirv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","নপ্তালি সন্তানদের বংশের নেতা অম্মীহূদের ছেলে পদহেল।” ");
INSERT INTO benirv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","কনান দেশে ইস্রায়েল সন্তানদের জন্য অধিকার ভাগ করে দিতে সদাপ্রভু এইসব লোককে আদেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","সদাপ্রভু মোয়াবের উপভূমিতে যিরীহোর কাছে অবস্থিত যর্দনে মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","তুমি ইস্রায়েল সন্তানদের আদেশ কর, যেন তারা নিজেদের অধিকারের অংশ থেকে বাস করার জন্য কতকগুলি শহর লেবীয়দেরকে দেয়; তোমরা সেই সব শহরের সঙ্গে চারদিকের পশু চড়ানোর মাঠও লেবীয়দেরকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","লেবীয়েরা সেই শহরগুলিতে বসবাস করবে। সেই পশু চড়ানোর মাঠ তাদের গবাদি পশু, পশুপাল ও তাদের সমস্ত জীবের জন্য। ");
INSERT INTO benirv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","তোমরা শহরগুলির যেসব পশু চড়ানোর মাঠ লেবীয়দেরকে দেবে, তার পরিমাণ শহরের দেওয়ালের বাইরে চারদিকে হাজার হাত হবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","তোমরা শহরের বাইরে তার পূর্বে সীমানা দুই হাজার হাত, দক্ষিণ সীমানা দুই হাজার হাত, পশ্চিম সীমানা দুই হাজার হাত ও উত্তর সীমানা দুই হাজার হাত পরিমাপ করবে; শহরটি মাঝখানে থাকবে। তাদের জন্য ওটা শহরের পশু চড়ানোর মাঠ হবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","হত্যাকারীদের পালানোর জন্য যে ছয়টি আশ্রয় শহর তোমরা দেবে, সেই সব এবং সেটা ছাড়া আরও বিয়াল্লিশটি শহর তোমরা লেবীয়দেরকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","মোট আটচল্লিশটি শহর ও সেইগুলির পশু চড়ানোর মাঠ লেবীয়দেরকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ইস্রায়েল সন্তানদের অধিকার থেকে সেই সমস্ত শহর দেবার দিনের তোমরা বেশি থেকে বেশি ও অল্প থেকে অল্প নেবে; প্রত্যেক বংশ নিজের পাওয়া অধিকার অনুসারে কতকগুলি শহর লেবীয়দেরকে দেবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","সদাপ্রভু মোশিকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“তুমি ইস্রায়েল সন্তানদের বল, তাদেরকে বল, ‘যখন তোমরা যর্দ্দন পার হয়ে কনান দেশে উপস্থিত হবে, ");
INSERT INTO benirv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","তখন তোমাদের আশ্রয় শহর হবার জন্য কতকগুলি শহর নির্ধারণ করবে; যে জন অনিচ্ছাকৃতভাবে কারও প্রাণ নষ্ট করে, এমন হত্যাকারী যেন সেখানে পালিয়ে যেতে পারে। ");
INSERT INTO benirv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","তার ফলে সেই সব শহর প্রতিশোধ দাতার হাত থেকে তোমাদের আশ্রয়স্থান হবে; যেন হত্যাকারী বিচারের জন্য মণ্ডলীর সামনে উপস্থিত হবার আগে মারা না যায়। ");
INSERT INTO benirv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","তোমরা যে সব শহর দেবে, তার মধ্যে ছয়টি আশ্রয় শহর হবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","তোমরা যর্দ্দনের পূর্ব দিকে তিনটি শহর ও কনান দেশে তিনটি শহর দেবে; সেগুলি আশ্রয় শহর হবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ইস্রায়েল সন্তানদের জন্য এবং তাদের মধ্যে বসবাসীকারী ও বিদেশীর জন্য এই ছয়টি শহর আশ্রয়স্থান হবে; যেন কেউ অনিচ্ছাকৃতভাবে মানুষকে হত্যা করলে সেখানে পালাতে পারে। ");
INSERT INTO benirv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","কিন্তু যদি কেউ লোহার অস্ত্র দিয়ে কাউকেও এমন আঘাত করে যে, তাতে সে মারা যায়, তবে সেই ব্যক্তি নরহত্যাকারী; সেই নরহত্যাকারীর অবশ্যই প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","যদি কোন অভিযুক্ত ব্যক্তি কাউকে এমন পাথর হাতে নিয়ে আঘাত করে ও তাতে সে মারা যায়, তবে সে নরহত্যাকারী, সেই নরহত্যাকারীর অবশ্যই প্রাণদণ্ড হইবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","কিংবা যদি অভিযুক্ত ব্যক্তি এমন কোন কাঠের বস্তু হাতে নিয়ে কাউকেও আঘাত করে, আর তাতে সে মারা যায়, তবে সে নরহত্যাকারী; সেই নরহত্যাকারীর অবশ্যই প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","রক্তের প্রতিশোধদাতা নিজে নরহত্যাকারীকে হত্যা করবে; তার দেখা পেলেই তাকে হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","আর যদি কোনো অভিযুক্ত ব্যক্তি ঘৃণা করে কাউকে আঘাত করে, কিংবা লক্ষ্য করে তার উপরে অস্ত্র ছোঁড়ে ও তাতে সে মারা যায়; ");
INSERT INTO benirv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","কিংবা শত্রুতা করে যদি কেউ কাউকেও নিজের হাতে আঘাত করে ও তাতে সে মারা যায়; তবে যে তাকে আঘাত করেছে, তার অবশ্যই প্রাণদণ্ড হবে; সে নরহত্যাকারী; রক্তের প্রতিশোধদাতা তার দেখা পেলেই সেই নরহত্যাকারীকে হত্যা করবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","কিন্তু যদি শত্রুতা ছাড়া হঠাৎ কেউ কাউকেও আঘাত করে, কিংবা লক্ষ্য না করে তার গায়ে অস্ত্র ছোঁড়ে, ");
INSERT INTO benirv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","কিংবা যেটা দিয়ে মারা যেতে পারে, এমন পাথর কারও উপরে না দেখে ফেলে, আর তাতেই সে মারা যায়, অথচ সে তার শত্রু বা ক্ষতি চাওয়ার লোক ছিল না; ");
INSERT INTO benirv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","তবে মণ্ডলী সেই নরহত্যাকারীর এবং রক্তের প্রতিশোধ দাতার বিষয়ে এইসব বিচারমতে বিচার করবে; ");
INSERT INTO benirv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","আর মণ্ডলী রক্তের প্রতিশোধদাতার হাত থেকে সেই নরহত্যাকারীকে উদ্ধার করবে এবং সে যেখানে পালিয়েছিল, তাদের সেই আশ্রয় শহরে মণ্ডলী তাকে পুনরায় পৌঁছে দেবে; আর যে পর্যন্ত পবিত্র তেলে অভিষিক্ত মহাযাজকের মৃত্যু না হয়, ততদিন সে সেই শহরে থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","কিন্তু সেই নরহত্যাকারী যে আশ্রয় শহরে পালিয়ে গেছে, কোন দিনের যদি তার সীমানার বাইরে আসে ");
INSERT INTO benirv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","এবং রক্তের প্রতিশোধদাতা আশ্রয় শহরের সীমানার বাইরে তাকে পায়, তবে সেই রক্তে প্রতিশোধদাতা তাকে হত্যা করলেও রক্তপাতের অপরাধী হবে না। ");
INSERT INTO benirv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","কারণ মহাযাজকের মৃত্যু পর্যন্ত তার আশ্রয় শহরে থাকা উচিত ছিল; কিন্তু মহাযাজকের মৃত্যু হওয়ার পর সেই নরহত্যাকারী তার অধিকার ভূমিতে ফিরে যেতে পারবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","তোমাদের বংশপরম্পরা অনুসারে এই সমস্ত তোমাদের পক্ষে বিচারের নিয়ম সেই সমস্ত জায়গায় যেখানে তোমরা বসবাস কর। ");
INSERT INTO benirv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","যে ব্যক্তি কোন লোককে হত্যা করে, সেই নরহত্যাকারী সাক্ষীদের কথায় হত হবে; কিন্তু কোন লোকের বিরুদ্ধে একমাত্র সাক্ষীর সাক্ষ্য প্রাণদণ্ডের জন্য গ্রহণ করা হবে না। ");
INSERT INTO benirv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","আর প্রাণদণ্ডের অপরাধী নরহত্যাকারীর প্রাণের জন্য তোমরা কোন প্রায়শ্চিত্ত গ্রহণ করবে না; তার অবশ্যই প্রাণদণ্ড হবে। ");
INSERT INTO benirv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","যে কেউ তার আশ্রয় শহরে পালিয়ে গেছে, সে যেন যাজকের মৃত্যুর আগে পুনরায় দেশে এসে বাস করতে পায়, এই জন্য তার থেকে কোন প্রায়শ্চিত্ত গ্রহণ করবে না। ");
INSERT INTO benirv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","এই ভাবে তোমরা নিজেদের বসবাসকারী দেশ অপবিত্র করবে না; কারণ রক্ত দেশকে অপবিত্র করে এবং সেখানে যে রক্তপাত হয়, তার জন্য রক্তপাতীর রক্তপাত ছাড়া দেশের প্রায়শ্চিত্ত হতে পারে না। ");
INSERT INTO benirv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","তোমরা যে দেশ অধিকার করবে ও যার মধ্যে আমি বাস করি, তুমি তা অশুচি করবে না; কারণ আমি সদাপ্রভু ইস্রায়েল সন্তানদের মধ্যে বাস করি’।” ");
INSERT INTO benirv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","তখন যোষেফ সন্তানদের গোষ্ঠীগুলির মধ্যে মনঃশির নাতি মাখীরের ছেলে গিলিয়দের সন্তানদের গোষ্ঠীর বংশধরদের নেতারা এসে মোশির ও নেতাদের সামনে, ইস্রায়েল সন্তানদের পূর্বপুরুষের নেতাদের সামনে, কথা বললেন। ");
INSERT INTO benirv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","তাঁরা বললেন, “সদাপ্রভু গুলিবাঁটের মাধ্যমে অধিকারের জন্য ইস্রায়েল সন্তানদের দেশ দিতে আমার প্রভুকে আদেশ করেছেন এবং আপনি আমাদের ভাই সলফাদের অধিকার তাঁর মেয়েদেরকে দেবার আদেশ সদাপ্রভুর থেকে পেয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","কিন্তু ইস্রায়েল সন্তানদের অন্য কোন বংশের সন্তানদের মধ্যে কারও সঙ্গে যদি তাদের বিয়ে হয়, তবে আমাদের বাবার অধিকার থেকে তাদের অধিকার কাটা যাবে ও তারা যে বংশে যাবে, সেই বংশের অধিকারে তা যুক্ত হবে। এই ভাবে তা আমাদের অধিকারের অংশ থেকে কাটা যাবে। ");
INSERT INTO benirv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","আর যখন ইস্রায়েল সন্তানের জয়ন্তী বছর উপস্থিত হবে, তখন তারা যাদের সঙ্গে যুক্ত হয়েছে, সেই বংশের অধিকারে তাদের অধিকার যুক্ত হবে। এই ভাবে আমাদের বাবার বংশের অধিকার থেকে তাদের অধিকার কাটা যাবে।” ");
INSERT INTO benirv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","তখন মোশি সদাপ্রভুর বাক্য অনুসারে ইস্রায়েল সন্তানদের আদেশ করলেন, বললেন, “যোষেফের সন্তানদের বংশ ঠিকই বলছে। ");
INSERT INTO benirv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","সদাপ্রভু সলফাদের মেয়েদের বিষয়ে এই আদেশ করছেন, তারা যাকে মনোনীত করবে, তাকে বিয়ে করতে পারবে; কিন্তু শুধু নিজেদের বাবার বংশের কোন গোষ্ঠীর মধ্যে বিয়ে করবে। ");
INSERT INTO benirv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","এই ভাবে ইস্রায়েল সন্তানের অধিকার এক বংশ থেকে অন্য বংশে যাবে না। ইস্রায়েল সন্তানরা প্রত্যেকে নিজেদের বাবার বংশের অধিকারে অন্তর্ভুক্ত থাকবে। ");
INSERT INTO benirv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ইস্রায়েল সন্তানদের প্রত্যেক মেয়ে যে তার বংশের অধিকার পেয়েছে সে অবশ্যই তার বাবার বংশের কাউকে বিয়ে করবে। এর জন্য প্রত্যেক ইস্রায়েল সন্তান নিজেদের পূর্বপুরুষের অধিকার ভোগ করে। ");
INSERT INTO benirv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","এই ভাবে এক বংশ থেকে অন্য বংশে অধিকার পরিবর্তন হবে না, কারণ ইস্রায়েল সন্তানের প্রত্যেক বংশ নিজেদের অধিকারে অন্তর্ভুক্ত থাকবে।” ");
INSERT INTO benirv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","মোশিকে সদাপ্রভু যেমন আদেশ দিলেন, সলফাদের মেয়েরা তেমন কাজ করল। ");
INSERT INTO benirv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","তার ফলে মহলা, তির্সা, হগ্লা, মিল্কা ও নোয়া, সলফাদের এই মেয়েরা মনঃশির সন্তানদের বিয়ে করল। ");
INSERT INTO benirv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","যোষেফের ছেলে মনঃশির সন্তানদের গোষ্ঠীর মধ্যে তাদের বিয়ে হল; তাতে তাদের অধিকার তাদের বাবার গোষ্ঠীর সম্পর্কীয় বংশেই থাকল। ");
INSERT INTO benirv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","সদাপ্রভু যিরীহোর কাছে অবস্থিত যর্দ্দনের পাশে মোয়াবের উপভূমিতে মোশির মাধ্যমে ইস্রায়েল সন্তানদের এই সমস্ত আদেশ ও বিচারের আজ্ঞা দিলেন।");
INSERT INTO benirv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","যর্দ্দন নদীর পূর্ব পারে অবস্থিত মরুপ্রান্তে, সূফের বিপরীতে অরাবা উপত্যকায়, পারণ, তোফল, লাবন, হৎসেরোৎ ও দীষাহবের মাঝখানে মোশি সমস্ত ইস্রায়েলকে এই সব কথা গুলি বললেন। ");
INSERT INTO benirv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","সেয়ীর পর্বত দিয়ে হোরেব থেকে কাদেশ বর্ণেয় পর্যন্ত যেতে এগারো দিন লাগে। ");
INSERT INTO benirv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","সদাপ্রভু যে সব কথা ইস্রায়েলের লোকদেরকে বলতে মোশিকে আদেশ দিয়েছিলেন, সেই অনুযায়ী মোশি (মিশর ছেড়ে আসার) চল্লিশ বছরের এগারো মাসের প্রথম দিনের তাদেরকে বললেন। ");
INSERT INTO benirv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","পরে তিনি ইমোরীয়দের রাজা সীহোনকে, যিনি হিষ্‌বোনে বাস করতেন এবং বাশনের রাজা ওগকে, যিনি ইদ্রিয়ীর অষ্টারোতে বাস করতেন তাদেরকে আঘাত করলেন। ");
INSERT INTO benirv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","যর্দ্দনের পূর্ব পারে মোয়াব দেশে মোশি এই ব্যবস্থা ব্যাখ্যা করতে লাগলেন; তিনি বললেন, ");
INSERT INTO benirv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“আমাদের ঈশ্বর সদাপ্রভু হোরেবে আমাদেরকে বলেছিলেন, ‘তোমরা এই পর্বতে অনেক দিন বাস করেছ; ");
INSERT INTO benirv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","তোমাদের যাত্রা শুরু কর, ইমোরীয়দের পার্বত্য অঞ্চলে এবং তার কাছাকাছি সব জায়গায়, অরাবা উপত্যকায়, পাহাড় অঞ্চলে, নীচু জায়গায়, দক্ষিণ প্রদেশে ও মহাসমুদ্রতীরে, মহানদী ফরাৎ পর্যন্ত কনানীয়দের দেশে ও লিবানোনে প্রবেশ কর। ");
INSERT INTO benirv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","দেখ, আমি সেই দেশ তোমাদের সামনে দিয়েছি; তোমাদের পূর্বপুরুষ অব্রাহাম, ইস্‌হাক ও যাকোবকে এবং তাদের পরবর্তী বংশকে যে দেশ দিতে সদাপ্রভু দিব্যি করেছিলেন, তোমরা সেই দেশে গিয়ে তা অধিকার কর।’” ");
INSERT INTO benirv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","সেই দিনের আমি তোমাদেরকে এই কথা বলেছিলাম, “তোমাদের ভার বহন করা আমার একার পক্ষে সম্ভব নয়। ");
INSERT INTO benirv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","তোমাদের ঈশ্বর সদাপ্রভু তোমাদের বৃদ্ধি করেছেন, আর দেখ, তোমরা আজ আকাশের তারার মত বহুসংখ্যক হয়েছ; ");
INSERT INTO benirv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","তোমরা যেমন আছ, তোমাদের পূর্বপুরুষ ঈশ্বর সদাপ্রভু তা থেকে তোমাদের আরও হাজার গুণ বৃদ্ধি করুন, আর তোমাদেরকে যেমন বলেছেন, সেরকম আশীর্বাদ করুন। ");
INSERT INTO benirv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","কেমন করে আমি একা তোমাদের বোঝা, তোমাদের ভার ও তোমাদের বিবাদ সহ্য করতে পারি? ");
INSERT INTO benirv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","তোমরা নিজেদের বংশের মধ্যে জ্ঞানবান, বুদ্ধিমান্‌ ও পরিচিত লোকদেরকে মনোনীত কর, আমি তাদেরকে তোমাদের প্রধান হিসাবে নিযুক্ত করব।” ");
INSERT INTO benirv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","তোমরা আমাকে উত্তর দিয়ে বললে, “তুমি যা বলছ, তাই করা ভাল।” ");
INSERT INTO benirv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","তাই আমি তোমাদের বংশগুলির প্রধান, জ্ঞানবান ও পরিচিত লোকদেরকে গ্রহণ করে এবং তোমাদের উপরে প্রধান, তোমাদের বংশ অনুযায়ী সহস্রপতি, শতপতি, পঞ্চাশৎপতি, দশপতি ও কর্ম্মচারী করে নিযুক্ত করলাম। ");
INSERT INTO benirv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","আর সেইদিনের তোমাদের বিচারকর্তাদেরকে আমি এই আদেশ করলাম, “তোমরা তোমাদের ভাইদের বিবাদের কথা শোন এবং একজন লোক ও তার ভাই এবং তার সঙ্গী বিদেশীর মধ্যে ন্যায় বিচার করো। ");
INSERT INTO benirv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","তোমরা বিচারে কারও পক্ষপাত করবে না; সমানভাবে ছোট ও মহান উভয়ের কথা শুনবে; মানুষের মুখ দেখে ভয় করবে না, কারণ বিচার ঈশ্বরের এবং যে ঘটনা তোমাদের পক্ষে কঠিন, তা আমার কাছে আনবে, আমি তা শুনব।” ");
INSERT INTO benirv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","সেই দিনের আমি তোমাদেরকে যে সব কাজ করতে হবে সেই বিষয়ে আদেশ দিয়েছিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","পরে আমরা আমাদের ঈশ্বর সদাপ্রভুর আদেশ অনুসারে হোরেব থেকে চলে গেলাম এবং ইমোরীয়দের পাহাড়ি দেশে যাবার পথে তোমরা সেই যে বিশাল ও ভয়ঙ্কর মরুভূমি দেখেছ, তার মধ্যে দিয়ে যাত্রা করে কাদেশ বর্ণেয়ে পৌঁছালাম। ");
INSERT INTO benirv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","পরে আমি তোমাদেরকে বললাম, “আমাদের ঈশ্বর সদাপ্রভু আমাদেরকে যে দেশ দিচ্ছেন, ইমোরীয়দের সেই পাহাড়ি দেশে তোমরা পৌঁছালে। ");
INSERT INTO benirv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","দেখ, তোমার ঈশ্বর সদাপ্রভু সেই দেশ তোমার সামনে দিয়েছেন; তুমি নিজের পূর্বপুরুষদের ঈশ্বর সদাপ্রভুর কথা অনুসারে উঠে ওটা অধিকার কর; ভয় পেয় না ও নিরাশ হয়ো না।” ");
INSERT INTO benirv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","তখন তোমরা সবাই আমার কাছে এসে বললে, “আগে আমরা সে জায়গায় লোক পাঠাই; তারা আমাদের জন্য দেশ খুঁজে বের করুক এবং আমাদেরকে কোন্‌ পথ দিয়ে উঠে যেতে হবে ও কোন্‌ কোন্‌ শহরে আসতে হবে, তার খবর নিয়ে আসুক।” ");
INSERT INTO benirv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","তখন আমি সে কথায় সন্তুষ্ট হয়ে তোমাদের প্রত্যেক বংশ থেকে এক জন করে বার জনকে নিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","পরে তারা পার্বত্য অঞ্চলে গিয়ে উঠল এবং ইষ্কোল উপত্যকায় এসে সেই দেশের খোঁজ করল। ");
INSERT INTO benirv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","আর সেই দেশের কতগুলো ফল হাতে নিয়ে আমাদের কাছে এসে খবর দিল, বলল, “আমাদের ঈশ্বর সদাপ্রভু আমাদেরকে যে দেশ দিচ্ছেন, সেটা ভালো।” ");
INSERT INTO benirv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","তবুও তোমরা সেই জায়গায় যেতে রাজি হলে না; কিন্তু তোমাদের ঈশ্বর সদাপ্রভুর আদেশের বিরোধিতা করলে; ");
INSERT INTO benirv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","নিজেদের তাঁবুতে অভিযোগ করে বললে, “সদাপ্রভু আমাদেরকে ঘৃণা করলেন বলেই তিনি আমাদেরকে মিশর দেশ থেকে বের করে আনলেন যেন আমরা ইমোরীয়দের হাতে পরাজিত হই। ");
INSERT INTO benirv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","আমরা কোথায় যেতে পারি? আমাদের ভাইয়েরা আমাদের মন গলিয়ে দিল, বলল, ‘আমাদের থেকে সে জাতি মহৎ ও উচ্চ এবং শহরগুলো অনেক বড় ও আকাশ পর্যন্ত দেওয়ালে ঘেরা; আরও সে জায়গায় আমরা অনাকীয়দের ছেলেদেরকেও দেখেছি।’” ");
INSERT INTO benirv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","তখন আমি তোমাদেরকে বললাম, “ভয় কর না, তাদের থেকে ভীত হয়ো না। ");
INSERT INTO benirv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","তোমাদের ঈশ্বর সদাপ্রভু যিনি তোমাদের আগে আগে যান, তিনি মিশর দেশে তোমাদের চোখের সামনে তোমাদের জন্য যে সব কাজ করেছিলেন, সেই অনুযায়ী তোমাদের জন্য যুদ্ধ করবেন। ");
INSERT INTO benirv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","এই মরুভূমিতেও তুমি সেরকম দেখেছ; যেমন বাবা নিজের ছেলেকে বহন করে, তেমনি এই জায়গায় তোমাদের আসা পর্যন্ত যে রাস্তায় তোমরা এসেছ, সেই সব রাস্তায় তোমার ঈশ্বর সদাপ্রভু তোমাকে বহন করেছেন।” ");
INSERT INTO benirv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","কিন্তু এই কথায় তোমরা নিজেদের ঈশ্বর সদাপ্রভুতে বিশ্বাস করলে না, ");
INSERT INTO benirv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","যিনি তোমাদের তাঁবু রাখার জায়গা খোঁজ করতে যাওয়ার দিন তোমাদের আগে আগে গিয়ে রাতে আগুনের মাধ্যমে ও দিনের মেঘের মাধ্যমে তোমরা কোন পথে যাবে সেই রাস্তা দেখাতেন। ");
INSERT INTO benirv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","সদাপ্রভু তোমাদের কথার আওয়াজ শুনে রেগে গেলেন ও এই দিব্যি করলেন, ");
INSERT INTO benirv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“আমি তোমাদের পূর্বপুরুষদেরকে যে দেশ দিতে শপথ করেছি, এই দুষ্ট বংশীয় মানুষদের মধ্যে কেউই সেই ভালো দেশ দেখতে পাবে না, ");
INSERT INTO benirv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","কেবল যিফূন্নির ছেলে কালেব তা দেখবে এবং সে যে জায়গায় পা দিয়েছে; সেই ভূমি আমি তাকে ও তার ছেলেমেয়েকে দেব; কারণ সে পুরোপুরিভাবে সদাপ্রভুর অনুসরণ করেছে।” ");
INSERT INTO benirv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","সদাপ্রভু তোমাদের জন্যে আমার প্রতিও রেগে গেলেন, তিনি আমাকে এই কথা বললেন, “তুমিও সে জায়গায় যেও না। ");
INSERT INTO benirv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","তোমার সামনে দাঁড়িয়ে থাকা নূনের ছেলে যিহোশূয় সেই দেশে যাবে; তুমি তাকেই আশ্বাস দাও, কারণ সে ইস্রায়েলকে তা অধিকারের জন্য নেতৃত্ব দেবে। ");
INSERT INTO benirv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","আর এরা শিকার হবে, এই কথা তোমরা নিজেদের যে ছেলেদের বিষয়ে বললে এবং তোমাদের যে ছেলে মেয়েদের ভাল মন্দ জ্ঞান আজ পর্যন্ত হয়নি, তারাই সেই জায়গায় যাবে; তাদেরকেই আমি সেই দেশ দেব এবং তারাই তা অধিকার করবে। ");
INSERT INTO benirv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","কিন্তু তোমরা ফের, সূফসাগরের পথ দিয়ে মরুপ্রান্তে যাও।” ");
INSERT INTO benirv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","তখন তোমরা উত্তর করে আমাকে বললে, “আমরা সদাপ্রভুর বিরুদ্ধে পাপ করেছি; আমরা আমাদের ঈশ্বর সদাপ্রভুর সমস্ত আদেশ অনুসারে উঠে গিয়ে যুদ্ধ করব।” পরে তোমরা প্রত্যেক জন যুদ্ধের অস্ত্রে সজ্জিত হলে এবং পার্বত্য অঞ্চলে আক্রমণ করার জন্য প্রস্তুত হলে। ");
INSERT INTO benirv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","তখন সদাপ্রভু আমাকে বললেন, “তুমি তাদেরকে বল, তোমরা যুদ্ধ করতে যেও না, কারণ আমি তোমাদের মাঝখানে নেই; যদি শত্রুদের সামনে আহত হও।” ");
INSERT INTO benirv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","আমি তোমাদেরকে সেই কথা বললাম, কিন্তু তোমরা সে কথায় কান দিলে না; বরং সদাপ্রভুর আদেশের বিরুদ্ধাচারণ করে ও দুঃসাহসী হয়ে পর্বতে উঠছিলে। ");
INSERT INTO benirv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","আর সেই পাহাড় নিবাসী ইমোরীয়েরা তোমাদের বিরুদ্ধে বের হয়ে, মৌমাছি যেমন করে, তেমনি তোমাদেরকে তাড়া করল এবং সেয়ীরে হর্মা পর্যন্ত আঘাত করল। ");
INSERT INTO benirv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","তখন তোমরা ফিরে আসলে ও সদাপ্রভুর কাছে কাঁদলে; কিন্তু সদাপ্রভু তোমাদের আওয়াজে কান দিলেন না, তোমাদের কথায় মনোযোগ দিলেন না। ");
INSERT INTO benirv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","সুতরাং তোমাদের বসবাসের দিন অনুসারে কাদেশে অনেক দিন থাকলে। ");
INSERT INTO benirv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","তখন (মশি আরও বললেন) সদাপ্রভু আমাকে যেমন বলেছিলেন, সেই অনুযায়ী আমরা ফিরে সূফসাগরের পথে মরুপ্রান্তের মধ্যে দিয়ে গেলাম এবং অনেক দিন ধরে সেয়ীর পর্বতের চারিদিকে ঘুরলাম। ");
INSERT INTO benirv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","পরে সদাপ্রভু আমাকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“তোমরা অনেক দিন এই পর্বতের চারিদিকে ঘুরছ; এখন উত্তরদিকে যাও। ");
INSERT INTO benirv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","আর তুমি লোকদেরকে এই আদেশ দাও, ‘সেয়ীরে বসবাসকারী তোমাদের ভাইদের অর্থাৎ এষৌ বংশধরদের সীমার কাছ দিয়ে তোমাদেরকে যেতে হবে, আর তারা তোমাদের থেকে ভয় পাবে; অতএব তোমরা খুব সাবধান হও। ");
INSERT INTO benirv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","তাদের সঙ্গে লড়াই কোরো না, কারণ আমি তোমাদেরকে তাদের দেশের অংশ দেব না, একটা পা রাখার জমিও দেব না; কারণ সেয়ীর পর্বত অধিকারের জন্য আমি এষৌকে দিয়েছি। ");
INSERT INTO benirv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","তোমরা তাদের কাছে টাকা দিয়ে খাবার কিনে খাবে ও টাকা দিয়ে জলও কিনে পান করবে। ");
INSERT INTO benirv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","কারণ তোমার ঈশ্বর সদাপ্রভু তোমার হাতের সব কাজে তোমাকে আশীর্বাদ করেছেন; এই বিশাল মরুপ্রান্তে তোমার যাত্রাপথ তিনি জানেন; এই চল্লিশ বছর তোমার ঈশ্বর সদাপ্রভু তোমার সঙ্গে আছেন; তোমার কিছুরই অভাব হয়নি।’” ");
INSERT INTO benirv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","তাই আমরা অরাবা রাস্তা থেকে, এলৎ ও ইৎসিয়োন গেবর থেকে, সেয়ীরে বসবাসীকারী আমাদের ভাই, এষৌ বংশধরদের সামনে দিয়ে গেলাম। আর আমরা মোয়াবের মরুপ্রান্তের রাস্তা দিয়ে গেলাম। ");
INSERT INTO benirv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","আর সদাপ্রভু আমাকে বললেন, “তুমি মোয়াবীয়দেরকে কষ্ট দিও না এবং যুদ্ধের মাধ্যমে তাদের সঙ্গে লড়াই কর না; আমি অধিকারের জন্য তাদের দেশের কোনো অংশ তোমাকে দেব না; কারণ আমি লোটের বংশধরদেরকে আর্‌ শহর অধিকার করতে দিয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(আগে ঐ জায়গায় এমীয়েরা বাস করত, তারা অনাকীয়দের মত মহৎ, অসংখ্য ও দীর্ঘকায় জাতি। ");
INSERT INTO benirv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","অনাকীয়দের মত তারাও রফায়ীয়দের মধ্যে গণ্য, কিন্তু মোয়াবীয়েরা তাদেরকে এমীয় বলে। ");
INSERT INTO benirv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","আর আগে হোরীয়েরাও সেয়ীরে বাস করত, কিন্তু এষৌর বংশধরেরা তাদেরকে তাড়িয়ে দিল। তাদের সামনে থেকে ধ্বংস করে তাদের জায়গায় বাস করল; যেমন ইস্রায়েল সদাপ্রভুর দেওয়া নিজের অধিকারের জায়গায় করল।) ");
INSERT INTO benirv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“এখন তোমরা ওঠ, সেরদ নদী পার হও।” তখন আমরা সেরদ নদী পার হলাম। ");
INSERT INTO benirv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","কাদেশ বর্ণেয় থেকে সেরদ নদী পার হওয়া পর্যন্ত আমাদের যাওয়ার দিন আটত্রিশ বছর লেগেছিল; সেই দিনের মধ্যে বংশের মধ্য থেকে তখনকার যোদ্ধারা সবাই ধ্বংস হল, যেমন সদাপ্রভু তাদের বিষয়ে শপথ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","আবার বংশের মধ্যে থেকে তাদেরকে ধ্বংস করার জন্য সদাপ্রভুর হাত তাদের বিরুদ্ধে ছিল। ");
INSERT INTO benirv_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","সেই সমস্ত যোদ্ধা মৃত লোকদের মধ্য থেকে ধ্বংস হলে পর ");
INSERT INTO benirv_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","সদাপ্রভু আমাকে বললেন, ");
INSERT INTO benirv_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“আজ তুমি মোয়াবের সীমা অর্থাৎ আর পার হবে; ");
INSERT INTO benirv_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","যখন তুমি অম্মোনের লোকদের সামনে আসো, তখন তাদেরকে কষ্ট দিও না, তাদের সঙ্গে লড়াই কর না; কারণ আমি তোমাকে অধিকার করার জন্য অম্মোনের লোকদের দেশের অংশ দেব না, কারণ আমি লোটের বংশধরদেরকে তা অধিকার করতে দিয়েছি।” ");
INSERT INTO benirv_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","সেই দেশও রফায়ীয়দের দেশ বলে গণ্য; রফায়ীয়েরা আগে সে জায়গায় বাস করত; কিন্তু অম্মোনীয়েরা তাদেরকে সম্‌সুস্মীয় বলে। ");
INSERT INTO benirv_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","তারা অনাকীয়দের মত মহৎ, অসংখ্য ও লম্বা এক জাতি ছিল, কিন্তু সদাপ্রভু ওদের সামনে থেকে তাদেরকে ধ্বংস করলেন; আর ওরা তাদেরকে তাড়িয়ে দিয়ে তাদের জায়গায় বাস করল। ");
INSERT INTO benirv_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","তিনি সেয়ীর নিবাসী এষৌর লোকদের জন্যও সেরকম কাজ করলেন, ফলে তাদের সামনে থেকে হোরীয়দেরকে ধ্বংস করলেন, তাতে ওরা তাদেরকে তাড়িয়ে দিয়ে এমন কি আজ পর্যন্ত তাদের জায়গায় বাস করছে। ");
INSERT INTO benirv_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","আর অব্বীয়রা, যারা ঘসা পর্যন্ত গ্রামগুলোতে বাস করত, তাদেরকে কপ্তোর থেকে আসা কপ্তোরীয়েরা ধ্বংস করে তাদের জায়গায় বাস করল। ");
INSERT INTO benirv_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“তোমরা ওঠ, যাও, অর্ণোন উপত্যকা পার হও; দেখ, আমি হিষবোনের রাজা ইমোরীয় সীহোনকে ও তার দেশ তোমার হাতে দিলাম; তুমি ওটা অধিকার করতে শুরু কর ও যুদ্ধে তার সঙ্গে লড়াই কর। ");
INSERT INTO benirv_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","আজ থেকে আমি সমস্ত আকাশমণ্ডলের নীচে অবস্থিত মানুষের উপরে তোমার প্রতি আশঙ্কা ও ভয় স্থাপন করতে শুরু করব; তারা তোমার বিষয়ে শুনে ও তোমার ভয়ে কাঁপবে ও ব্যথা পাবে।” ");
INSERT INTO benirv_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","পরে আমি কদেমোৎ মরুভূমি থেকে হিষবোনের রাজা সীহোনের কাছে দূতের মাধ্যমে এই শান্তির বাক্য বলে পাঠালাম, ");
INSERT INTO benirv_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“তুমি নিজের দেশের মধ্য দিয়ে আমাকে যেতে দাও, আমি রাজপথ ধরেই যাব, ডান দিকে কি বাম দিকে ফিরব না। ");
INSERT INTO benirv_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","তুমি টাকার বিনিময়ে আমার কাছে খাবার বিক্রি করবে, যাতে আমি খেতে পারি; টাকার বিনিময়ে আমাকে জল দেবে, যেন আমি পান করতে পারি; শুধুমাত্র আমাকে পায়ে হেঁটে পার হতে দাও; ");
INSERT INTO benirv_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","সেয়ীর নিবাসী এষৌ বংশধরেরা ও আর্‌ নিবাসী মোয়াবীয়েরাও আমার প্রতি সেরকম করেছে। যতক্ষণ না আমি যর্দ্দনের ওপর দিয়ে সেই দেশে গেলাম যা সদাপ্রভু আমাদেরকে দিচ্ছেন।” ");
INSERT INTO benirv_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","কিন্তু হিষ্‌বোনের রাজা সীহোন তাঁর কাছ দিয়ে আমাদের যেতে দেননি, কারণ তোমার ঈশ্বর সদাপ্রভু তাঁর মন কঠিন করলেন ও তাঁর হৃদয় শক্ত করলেন, যেন তোমার হাতে তাঁকে পরাজিত করেন, যেটি তিনি আজ করেছেন। ");
INSERT INTO benirv_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","আর সদাপ্রভু আমাকে বললেন, “দেখ, আমি সীহোনকে ও তাঁর দেশকে তোমার সামনে দিতে শুরু করলাম; তুমিও তার দেশ অধিকার করতে শুরু কর।” ");
INSERT INTO benirv_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","তখন সীহোন ও তাঁর সমস্ত লোক আমাদের বিরুদ্ধে বের হয়ে যহসে যুদ্ধ করতে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","আর আমাদের ঈশ্বর সদাপ্রভু আমাদের সামনে তাঁকে দিলেন এবং আমরা তাকে পরাজিত করলাম, আমরা তাঁকে, তাঁর ছেলেদেরকে ও তাঁর লোকদেরকে আঘাত করে মেরে ফেললাম। ");
INSERT INTO benirv_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","আর সেই দিনের তাঁর সব শহর নিয়ে নিলাম এবং স্ত্রীলোক ও বালকবালিকা সমেত সব বসতি শহর সম্পূর্ণ ধ্বংস করলাম; কাউকেও বাকি রাখলাম না; ");
INSERT INTO benirv_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","শুধু পশুদেরকে ও যে যে শহর নিয়ে নিয়েছিলাম, তার লুটপাট করা জিনিস সব আমরা নিজেদের জন্য নিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","অর্ণোন উপত্যকার সীমাতে অবস্থিত অরোয়ের থেকে ও উপত্যকার মাঝখানের শহর থেকে গিলিয়দ পর্যন্ত সব শহর আমরা জয় করলাম; আমাদের ঈশ্বর সদাপ্রভু সমস্ত শত্রুকে জয় করে আমাদের সামনে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","শুধু অম্মোন বংশধরদের দেশ, যব্বোক নদীর পাশে অবস্থিত সব অঞ্চল ও পর্বতময় দেশের শহর সব এবং যে সব জায়গায় যেতে আমাদের ঈশ্বর সদাপ্রভু নিষেধ করেছিলেন, সেই সবের কাছে তুমি গেলে না। ");
INSERT INTO benirv_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","পরে আমরা ফিরে বাশনের রাস্তার দিকে গেলাম; তাতে বাশনের রাজা ওগ আসলেন তিনি ও তাঁর সমস্ত লোক আক্রমণ করলেন, আমাদের সঙ্গে যুদ্ধ করার জন্য ইদ্রিয়ীতে আসলেন। ");
INSERT INTO benirv_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","তখন সদাপ্রভু আমাকে বললেন, “তুমি ওকে ভয় কর না, কারণ আমি ওকে, ওর সমস্ত লোককে ও ওর দেশ তোমার হাতে সমর্পণ করলাম; তুমি যেমন হিষবোন নিবাসী ইমোরীয়দের রাজা সীহোনের প্রতি করেছ, তেমনি ওর প্রতিও করবে।” ");
INSERT INTO benirv_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","এভাবে আমাদের ঈশ্বর সদাপ্রভু বাশনের রাজা ওগকে ও তাঁর সব লোককে আমাদের হাতে সমর্পণ করলেন এবং আমরা তাঁকে আঘাত করে মেরে ফেললাম, তাঁর কেউ অবশিষ্ট থাকলো না। ");
INSERT INTO benirv_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","সেই দিনের আমরা তাঁর সব শহর নিয়ে নিলাম; এমন এক শহরও থাকল না, যা তাদের থেকে নেয়নি; ষাটটি শহর, অর্গোবের সব অঞ্চল, বাশনে অবস্থিত ওগের রাজ্য নিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","সেই সব শহর উঁচু দেওয়াল, দরজা ও খিলের মাধ্যমে সুরক্ষিত ছিল; আর দেওয়াল ছাড়া অনেক শহরও ছিল। ");
INSERT INTO benirv_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","আমরা হিষবোনের রাজা সীহোনের প্রতি যেমন করেছিলাম, সেরকম তাদেরকে পুরোপুরি ধ্বংস করলাম, স্ত্রীলোক ও বালকবালিকা সমেত তাদের সব বসবাসের শহর সম্পূর্ণ বিনাশ করলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","কিন্তু তাদের সমস্ত পশু ও শহরের জিনিসপত্র লুট করে নিজেদের জন্য নিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","সেই দিনের আমরা যর্দ্দনের পারে অবস্থিত ইমোরীয়দের দুই রাজার কাছ থেকে অর্ণোন উপত্যকা থেকে হর্মোণ পর্বত পর্যন্ত সব দেশ নিয়ে নিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(সীদোনীয়েরা ঐ হর্মোণকে সিরিয়োণ বলে এবং ইমোরীয়েরা তাঁকে সনীর বলে।) ");
INSERT INTO benirv_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","আমরা সমভূমির সব শহর, সল্‌খা ও ইদ্রিয়ী পর্যন্ত সব গিলিয়দ এবং পুরো বাশন, বাশনে অবস্থিত ওগ রাজ্যের শহরগুলি নিয়ে নিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(ফলে বাকি রফায়ীয়দের মধ্যে শুধু বাশনের রাজা ওগ বাকি ছিলেন; দেখ, তাঁর বিছানা লোহার; তা কি অম্মোন বংশধরদের রব্বা শহরে নেই? মানুষের হাতের পরিমাণ অনুসারে তা লম্বায় নয় হাত ও চওড়ায় চার হাত ছিল।) ");
INSERT INTO benirv_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","সেই দিনের আমরা এই দেশ অধিকার করলাম; অর্ণোন উপত্যকায় অবস্থিত অরোয়ের শহর থেকে এবং পর্বতময় গিলিয়দ দেশের অর্ধেক ও সেখানকার শহর সব রূবেণীয় ও গাদীয়দেরকে দিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","আর গিলিয়দের বাকি অংশ ও পুরো বাশন অর্থাৎ ওগের রাজ্য, পুরো বাশনের সঙ্গে অর্গোবের সমস্ত অঞ্চল আমি মনঃশির অর্ধেক বংশকে দিলাম। (সেটাই রফায়ীয় দেশ বলে বিখ্যাত। ");
INSERT INTO benirv_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","মনঃশির একজন বংশধর যায়ীর গশূরীয়দের ও মাখাথীয়দের সীমা পর্যন্ত অর্গোবের সব অঞ্চল নিয়ে নিজের নাম অনুসারে বাশন দেশের সেই সব জায়গার নাম হব্বোৎ যায়ীর রাখল; আজও সেই নাম প্রচলিত আছে।) ");
INSERT INTO benirv_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","আমি মাখীরকে গিলিয়দ দিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","আর গিলিয়দ থেকে অর্ণোন উপত্যকা পর্যন্ত, উপত্যকার মাঝখান ও তার সীমানা এবং অম্মোন বংশধরদের সীমা যব্বোক নদী পর্যন্ত; ");
INSERT INTO benirv_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","আর অরাবা উপত্যকা, যর্দ্দন ও তার সীমানা, কিন্নেরৎ থেকে অরাবার সমুদ্র, অর্থাৎ পূর্বদিকে পিস্‌গা ঢালু জায়গার দিকে লবণসমুদ্র পর্যন্ত রূবেণীয় ও গাদীয়দেরকে দিলাম। ");
INSERT INTO benirv_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","আর আমি সেই দিনের তোমাদেরকে এই আদেশ করলাম, “তোমাদের ঈশ্বর সদাপ্রভু অধিকারের জন্য এই দেশ তোমাদেরকে দিয়েছেন। তোমাদের সব যোদ্ধা সজ্জিত হয়ে তোমাদের ভাইদের অর্থাৎ ইস্রায়েলের লোকদের সামনে পার হয়ে যাবে। ");
INSERT INTO benirv_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","আমি তোমাদেরকে যে সব শহর দিলাম, তোমাদের সেই সব শহরে তোমাদের স্ত্রীলোক, বালক বালিকা ও পশুরা বাস করবে; আমি জানি যে, তোমাদের অনেক পশু আছে। ");
INSERT INTO benirv_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","পরে সদাপ্রভু তোমাদের ভাইদেরকে তোমাদের মতো বিশ্রাম দিলে, যর্দ্দনের ওপারে যে দেশ তোমাদের ঈশ্বর সদাপ্রভু তাদেরকে দিচ্ছেন, তারাও সেই দেশ অধিকার করবে, তখন তোমরা প্রত্যেকে আমার দেওয়া নিজেদের অধিকারে ফিরে আসবে।” ");
INSERT INTO benirv_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","আর সেই দিনের আমি যিহোশূয়কে আদেশ করলাম, “তোমাদের ঈশ্বর সদাপ্রভু সেই দুই রাজার প্রতি যা করেছেন, তা তুমি নিজের চোখে দেখেছ; তুমি পার হয়ে যে যে রাজ্যের বিরুদ্ধে যাবে, সে সব রাজ্যের প্রতি সদাপ্রভু সেরকম করবেন। ");
INSERT INTO benirv_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","তোমরা তাদেরকে ভয় কর না; কারণ তোমাদের ঈশ্বর সদাপ্রভু নিজে তোমাদের জন্য যুদ্ধ করবেন।” ");
INSERT INTO benirv_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","সেই দিনের আমি সদাপ্রভুকে অনুরোধ করে বললাম, ");
INSERT INTO benirv_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“হে প্রভু সদাপ্রভু, তুমি নিজের দাসের কাছে নিজের মহিমা ও শক্তিশালী হাত দেখাতে শুরু করলে; তোমার কাজের মত কাজ ও তোমার পরাক্রমী কাজের মত কাজ করতে পারে, স্বর্গে কি পৃথিবীতে এমন ঈশ্বর কে আছে? ");
INSERT INTO benirv_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","অনুরোধ করি, আমাকে ওপারে গিয়ে যর্দনপারে অবস্থিত সেই ভালো দেশ, সেই ভালো পাহাড়ি দেশ ও লিবানোন দেখতে দাও।” ");
INSERT INTO benirv_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","কিন্তু সদাপ্রভু তোমাদের জন্য আমার বিরুদ্ধে রেগে যাওয়াতে আমার কথা শুনলেন না; সদাপ্রভু আমাকে বললেন, “এটাই তোমার জন্য যথেষ্ট হোক, এ বিষয়ে আমাকে আর বল না। ");
INSERT INTO benirv_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","পিস্‌গার শৃঙ্গে ওঠ এবং পশ্চিম, উত্তর, দক্ষিণ ও পূর্ব দিকে দেখ; তোমার চোখ দিয়ে দেখো, কারণ তুমি এই যর্দ্দন পার হতে পারবে না। ");
INSERT INTO benirv_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","তার পরিবর্তে তুমি যিহোশূয়কে আদেশ দাও, তাকে উত্সাহ দাও এবং তাকে শক্তিশালী কর, কারণ সে এই লোকদের আগে গিয়ে পার হবে, আর যে দেশ তুমি দেখবে, সেই দেশ সে তাদেরকে অধিকার করাবে।” ");
INSERT INTO benirv_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","সুতরাং এই ভাবে আমরা বৈৎ-পিয়োরের বিপরীতে অবস্থিত উপত্যকায় বাস করলাম। ");
INSERT INTO benirv_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","এখন, হে ইস্রায়েল, আমি যে যে নিয়ম ও আদেশ পালন করতে তোমাদেরকে শিক্ষা দিই, তা শোন; যেন তোমরা বেঁচে থাকতে পার এবং তোমাদের পূর্বপুরুষদের ঈশ্বর সদাপ্রভু তোমাদেরকে যে দেশ দিচ্ছেন, তার মধ্যে গিয়ে তা অধিকার করতে পার। ");
INSERT INTO benirv_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","আমি তোমাদেরকে যা আদেশ করি, সেই কথায় তোমরা আর কিছু যোগ করবে না এবং তার কিছু কমাবে না। আমি তোমাদেরকে যা যা আদেশ করছি, তোমাদের ঈশ্বর সদাপ্রভুর সেই সব আদেশ পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","বাল পিয়োরের বিষয়ে সদাপ্রভু যা করেছিলেন, তা তোমরা নিজের চোখে দেখেছ; ফলে তোমার ঈশ্বর সদাপ্রভু বাল পিয়োরের অনুসারী প্রত্যেক জনকে তোমার মধ্যে থেকে ধ্বংস করেছিলেন; ");
INSERT INTO benirv_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","কিন্তু তোমরা যত লোক তোমাদের ঈশ্বর সদাপ্রভুতে যুক্ত ছিলে, সবাই আজ জীবিত আছ। ");
INSERT INTO benirv_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","দেখ, আমার ঈশ্বর সদাপ্রভু আমাকে যেমন আদেশ করেছিলেন, আমি তোমাদেরকে সেরকম নিয়ম ও আদেশ শিক্ষা দিয়েছি; যেন, তোমরা যে দেশ অধিকার করতে যাচ্ছ, সেই দেশের মধ্যে সেই অনুযায়ী ব্যবহার কর। ");
INSERT INTO benirv_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","অতএব তোমরা সে সব মেনে চল ও পালন কোরো; কারণ জাতি সকলের সামনে সেটাই তোমাদের প্রজ্ঞা ও বুদ্ধিমত্তার পরিচয় হবে; এই সব বিধি শুনে তারা বলবে, “সত্যই, এই মহাজাতি জ্ঞানবান ও বুদ্ধিমান লোক।” ");
INSERT INTO benirv_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","কারণ কোন্‌ বড় জাতির কাছে এমন ঈশ্বর আছেন, যেমন আমাদের ঈশ্বর সদাপ্রভু? যখনই আমরা তাঁকে ডাকি, তিনি আমাদের সঙ্গে থাকেন। ");
INSERT INTO benirv_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","আর আমি আজ তোমাদের সামনে যে সব ব্যবস্থা দিচ্ছি, তার মত সঠিক নিয়ম ও আদেশ কোন্‌ বড় জাতির আছে? ");
INSERT INTO benirv_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","কিন্তু তুমি নিজের বিষয়ে মনোযোগ দাও, তোমার প্রাণের বিষয়ে খুব সাবধান থাক; অতএব তুমি যে সব বিষয় নিজের চোখে দেখেছ, তা ভুলে যাও; অতএব জীবন থাকতে তোমার হৃদয় থেকে তা মুছে যাক; তুমি নিজের ছেলে নাতিদেরকে তা জানাও। ");
INSERT INTO benirv_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","সেই দিন, তুমি হোরেবে নিজের ঈশ্বর সদাপ্রভুর সামনে দাঁড়িয়েছিলে, যখন সদাপ্রভু আমাকে বললেন, “তুমি আমার কাছে লোকদেরকে জড়ো কর, আমি আমার কথা সব তাদেরকে শোনাব; তারা পৃথিবীতে যতদিন বেঁচে থাকে, ততদিন যেন আমাকে ভয় করে, এই বিষয় তারা শিখবে এবং নিজের ছেলেমেয়েদেরকেও শেখাবে।” ");
INSERT INTO benirv_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","তাতে তোমরা কাছে এসে পর্বতের পাদদেশে দাঁড়িয়েছিলে এবং আকাশের ভিতর পর্যন্ত সেই পর্বত আগুনে জ্বলছিল, অন্ধকার, মেঘ ও ঘন অন্ধকার ছড়িয়ে ছিল। ");
INSERT INTO benirv_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","তখন আগুনের মধ্যে থেকে সদাপ্রভু তোমাদের সঙ্গে কথা বললেন; তোমরা কথার স্বর শুনছিলে, কিন্তু কোনো মূর্ত্তি দেখতে পেলে না, তোমরা শুধু রব শুনতে পেলে। ");
INSERT INTO benirv_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","আর তিনি নিজের যে নিয়ম পালন করতে তোমাদেরকে আজ্ঞা করলেন, সেই নিয়ম অর্থাৎ দশ আজ্ঞা তোমাদেরকে আদেশ করলেন এবং দুটি পাথরের ফলকে লিখলেন। ");
INSERT INTO benirv_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","তোমরা যে দেশ অধিকার করতে যাচ্ছ, সেই দেশে তোমাদের পালন করা নিয়ম ও আদেশ সব তোমাদেরকে শিক্ষা দিতে সদাপ্রভু সেই দিনের আমাকে আদেশ করলেন। ");
INSERT INTO benirv_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","যে দিন সদাপ্রভু হোরেবে আগুনের মধ্যে থেকে তোমাদের সঙ্গে কথা বলছিলেন, সেই দিন তোমরা কোনো মূর্ত্তি দেখনি; অতএব নিজের নিজের প্রাণের বিষয়ে খুব সাবধান হও; ");
INSERT INTO benirv_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","যদি তোমরা নষ্ট হয়ে নিজেদের জন্য কোনো আকারের মূর্তিতে খোদাই প্রতিমা তৈরী কর; ");
INSERT INTO benirv_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","যদি পুরুষের বা স্ত্রীর প্রতিমূর্ত্তি, পৃথিবীতে অবস্থিত কোনো পশুর প্রতিমূর্ত্তি, আকাশে উড়া কোনো পাখির প্রতিমূর্ত্তি, ");
INSERT INTO benirv_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","মাটিতে বুকে হেঁটে চলা কোনো প্রাণীর প্রতিমূর্ত্তি, অথবা মাটির নীচে জলের মধ্যে কোনো মাছের প্রতিমূর্ত্তি তৈরী কর; ");
INSERT INTO benirv_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","আর আকাশের প্রতি চোখ তুলে সূর্য্য, চাঁদ ও তারা, আকাশের সমস্ত বাহিনী দেখলে, তোমার ঈশ্বর সদাপ্রভু যাদেরকে সমস্ত আকাশমণ্ডলের নীচে অবস্থিত সমস্ত জাতির জন্য ভাগ করেছেন, যদি আকৃষ্ট হয়ে তাদের কাছে আরাধনা কর ও তাদের সেবা কর। ");
INSERT INTO benirv_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","কিন্তু সদাপ্রভু তোমাদেরকে গ্রহণ করেছেন, (লোহা গলাবার হাফর) থেকে, মিশর থেকে তোমাদেরকে বের করে এনেছেন, যেন তোমরা তাঁর উত্তরাধিকারী লোক হও, যেমন আজ আছ। ");
INSERT INTO benirv_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","আর তোমাদের জন্য সদাপ্রভু আমার প্রতিও রেগে গিয়ে এই শপথ করেছেন যে, তিনি আমাকে যর্দ্দন পার হতে দেবেন না এবং তোমার ঈশ্বর সদাপ্রভু তোমাকে যে দেশ অধিকারের জন্য দিচ্ছেন, সেই উত্তম দেশে আমাকে যেতে দেবেন না। ");
INSERT INTO benirv_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","প্রকৃত পক্ষে এই দেশেই আমাকে মারা যেতে হবে; আমি যর্দ্দন পার হয়ে যাব না; কিন্তু তোমরা পার হয়ে সেই উত্তম দেশ অধিকার করবে। ");
INSERT INTO benirv_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","তোমরা নিজেদের বিষয়ে সাবধান থেকো, তোমাদের ঈশ্বর সদাপ্রভু তোমাদের সঙ্গে যে নিয়ম স্থির করেছেন, তা ভুলে যেও না, কোনো বস্তুর মূর্তিবিশিষ্ট খোদাই করা প্রতিমা তৈরী কোরো না; ওটা তোমার ঈশ্বর সদাপ্রভুর নিষিদ্ধ। ");
INSERT INTO benirv_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","কারণ তোমার ঈশ্বর সদাপ্রভু গ্রাসকারী আগুনের মতো; তিনি স্বগৌরব রক্ষণে উদ্যোগী ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","সেই দেশে ছেলে নাতিদের জন্ম দিয়ে বহু দিন বাস করার পর যদি তোমরা ভ্রষ্ট হও ও কোনো বস্তুর মূর্তিবিশিষ্ট ক্ষোদিত প্রতিমা তৈরী কর এবং তোমার ঈশ্বর সদাপ্রভুর দৃষ্টিতে যা খারাপ, তা করে তাঁকে অসন্তুষ্ট কর; ");
INSERT INTO benirv_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","তবে আমি আজ তোমাদের বিরুদ্ধে স্বর্গ পৃথিবীকে সাক্ষী মেনে বলছি, তোমরা যে দেশ অধিকার করতে যর্দ্দন পার হয়ে যাচ্ছ, সেই দেশ থেকে তাড়াতাড়ি বিনষ্ট হবে, সেখানে বহু দিন থাকবে না, কিন্তু সম্পূর্ণ ধ্বংস হবে। ");
INSERT INTO benirv_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","আর সদাপ্রভু জাতিদের মধ্যে তোমাদেরকে ছিন্ন ভিন্ন করবেন; যেখানে সদাপ্রভু তোমাদেরকে নিয়ে যাবেন, সেই জাতিদের মধ্যে তোমরা অল্পসংখ্যক হয়ে অবশিষ্ট থাকবে। ");
INSERT INTO benirv_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","আর তোমরা সেখানে মানুষের হাতে তৈরী দেবতাদের দেখা, শোনা, খাওয়ায় ও ঘ্রাণে অসমর্থ কাঠ ও পাথরের সেবা করবে। ");
INSERT INTO benirv_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","কিন্তু সেখানে থেকে যদি তোমরা তোমাদের ঈশ্বর সদাপ্রভুর খোঁজ কর, তবে তাঁর খোঁজ পাবে; সমস্ত হৃদয়ের সঙ্গে ও সমস্ত প্রাণের সঙ্গে তাঁর খোঁজ করলেই পাবে। ");
INSERT INTO benirv_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","যখন তুমি সঙ্কটে পড় এবং এই সব তোমার প্রতি ঘটে, তখন ভবিষ্যতে তুমি তোমার ঈশ্বর সদাপ্রভুর দিকে ফিরবে ও তাঁর স্বর শুনবে। ");
INSERT INTO benirv_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","কারণ তোমার ঈশ্বর সদাপ্রভু কৃপাময় ঈশ্বর; তিনি তোমাকে ত্যাগ করবেন না, তোমাকে ধ্বংস করবেন না এবং শপথের মাধ্যমে তোমার পূর্বপুরুষদের কাছে যে নিয়ম করেছেন, তা ভুলে যাবেন না। ");
INSERT INTO benirv_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","কারণ পৃথিবীতে ঈশ্বরের মাধ্যমে মানুষের সৃষ্টির দিন থেকে তোমার আগে যে দিন গিয়েছে, সেই পুরোনো দিন কে এবং আকাশমণ্ডলের এক প্রান্ত থেকে অন্য প্রান্তকে জিজ্ঞাসা কর, এই মহৎ কাজের মত কাজ কি আর কখনও হয়েছে? অথবা এমন কি শোনা গিয়েছে? ");
INSERT INTO benirv_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","তোমার মত কি আর কোনো জাতি আগুনের মধ্যে থেকে ঈশ্বরের স্বর শুনে বেঁচেছে? ");
INSERT INTO benirv_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","অথবা তোমাদের ঈশ্বর সদাপ্রভু মিশরে তোমাদের সামনে যে সব কাজ করেছেন, ঈশ্বর কি সেই অনুযায়ী গিয়ে পরীক্ষা, চিহ্ন, বিস্ময়, যুদ্ধ, শক্তিশালী হাত, বিশাল ক্ষমতা প্রদর্শন এবং মহা ভয়ঙ্কর কাজের মাধ্যমে অন্য জাতির মধ্যে থেকে নিজের জন্য এক জাতি গ্রহণ করতে চেষ্টা করেছেন? ");
INSERT INTO benirv_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","সদাপ্রভুই ঈশ্বর, তিনি ছাড়া আর কেউ নেই, এটা যেন তুমি জানো, তার জন্য ঐ সব তোমাকেই দেখানো হল। ");
INSERT INTO benirv_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","নির্দেশ দেবার জন্য তিনি স্বর্গ থেকে তোমাকে নিজের স্বর শোনালেন ও পৃথিবীতে তোমাকে নিজের বিশাল আগুন দেখালেন এবং তুমি আগুনের মধ্যে থেকে তাঁর কথা শুনতে পেলে। ");
INSERT INTO benirv_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","তিনি তোমরা পূর্বপুরুষদেরকে ভালবাসতেন, তাই তাঁদের পরে তাঁদের বংশকেও বেছে নিলেন এবং নিজের অস্তিত্ব ও বিশাল ক্ষমতার মাধ্যমে তোমাকে মিশর দেশ থেকে বের করে আনলেন; ");
INSERT INTO benirv_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","যেন তোমার থেকে মহান ও শক্তিশালী জাতিদেরকে তোমার সামনে থেকে তাড়িয়ে দিয়ে তাদের দেশে তোমাকে প্রবেশ করান ও অধিকারের জন্য তোমাকে সে দেশ দেন, যেমন আজ দেখছ। ");
INSERT INTO benirv_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","অতএব আজ জানো, মনে রাখ যে, উপরে অবস্থিত স্বর্গে ও নীচে অবস্থিত পৃথিবীতে সদাপ্রভুই ঈশ্বর, অন্য কেউ নেই। ");
INSERT INTO benirv_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","আর তোমার মঙ্গল ও তোমার পরে যে সন্তানরা আসতে চলেছে তাদের যেন মঙ্গল হয় এবং তোমার ঈশ্বর সদাপ্রভু তোমাকে যে ভূমি চিরকালের জন্য দিচ্ছেন, তার উপরে যেন তুমি দীর্ঘদিন বেঁচে থাক, এই জন্য আমি তাঁর যে সব বিধি ও আজ্ঞা আজ তোমাকে আদেশ করলাম, তা পালন কোরো। ");
INSERT INTO benirv_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","তারপর মোশি যর্দ্দন নদীর পূর্ব দিকে তিনটি শহর আলাদা করলেন; ");
INSERT INTO benirv_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","যেন হত্যাকারী সেখানে পালাতে পারে; যে কেউ নিজের প্রতিবেশীকে আগে শত্রুতা না করে অনিচ্ছাকৃতভাবে হত্যা করে, সে যেন এই সকলের মধ্যে কোনো এক শহরে পালিয়ে গিয়ে বাঁচতে পারে; ");
INSERT INTO benirv_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","তিনটি শহর হল, রূবেণীয়দের জন্য সমভূমি, মরুপ্রান্তের বেৎসর, গাদীয়দের জন্য গিলিয়দে অবস্থিত রামোৎ এবং মনঃশীয়দের জন্য বাশনে অবস্থিত গোলন। ");
INSERT INTO benirv_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","মোশি ইস্রায়েলের লোকদের সামনে এই ব্যবস্থা স্থাপন করেছিলেন; ");
INSERT INTO benirv_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","যখন মিশর থেকে তারা বের হয়ে এসেছিলেন তখন মোশি ইস্রায়েলের লোকদের এই সমস্ত নিয়মের বিধি, ব্যবস্থা এবং অন্যান্য নিয়মের কথা বলেছিলেন, ");
INSERT INTO benirv_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","যর্দ্দনের পূর্বপারে, বৈৎ-পিয়োরের সামনে অবস্থিত উপত্যকাতে, হিষবোন নিবাসী ইমোরীয় রাজা সীহোনের দেশে ইস্রায়েলের লোকদের কাছে এই সব সাক্ষ্য, বিধি ও শাসনের কথা বলেছিলেন। মিশর থেকে বের হয়ে আসলে মোশি ও ইস্রায়েলের লোকেরা সেই রাজাকে আঘাত করেছিলেন ");
INSERT INTO benirv_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","এবং তাঁর ও বাশনের রাজা ওগের দেশ, যর্দ্দনের পূর্ব পারে ইমোরীয়দের এই দুই রাজার দেশ, ");
INSERT INTO benirv_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","অর্ণোন উপত্যকার সীমাতে অবস্থিত অরোয়ের থেকে সীওন পর্বত অর্থাৎ হর্মোণ পর্যন্ত সমস্ত দেশ ");
INSERT INTO benirv_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","এবং পিস্‌গা পর্বতের নীচে অবস্থিত অরাবা উপত্যকার সমুদ্র পর্যন্ত যর্দ্দনের পূর্বদিকে অবস্থিত সমস্ত অরাবা উপত্যকা অধিকার করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","তখন মোশি সমস্ত ইস্রায়েলকে ডাকলেন ও তাদেরকে বললেন, “শোনো, হে ইস্রায়েল, আমি তোমাদের কানে আজ যে সব বিধি ও শাসন বলি, সে সব শোনো, তোমরা তা শেখ ও যত্নসহকারে পালন কর। ");
INSERT INTO benirv_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","আমাদের ঈশ্বর সদাপ্রভু হোরেবে আমাদের সঙ্গে এক নিয়ম করেছেন। ");
INSERT INTO benirv_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","সদাপ্রভু আমাদের পূর্বপুরুষদের সঙ্গে সেই নিয়ম করেননি, কিন্তু আজ এই জায়গায় যারা বেঁচে আছি যে আমরা, আমাদেরই সঙ্গে করেছেন। ");
INSERT INTO benirv_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","সদাপ্রভু পর্বতে আগুনের মধ্যে থেকে তোমাদের সঙ্গে মুখোমুখি হয়ে কথা বললেন। ");
INSERT INTO benirv_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","সেই দিনের আমিই তোমাদেরকে সদাপ্রভুর কথা জানানোর জন্য সদাপ্রভু ও তোমাদের মধ্যে দাঁড়িয়ে ছিলাম; কারণ তোমরা আগুনকে ভয় পেয়েছিলে এবং তোমরা পর্বতে ওঠনি। তিনি বললেন, ");
INSERT INTO benirv_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘আমি তোমার ঈশ্বর সদাপ্রভু, যিনি মিশর দেশ থেকে, দাসত্বের ঘর থেকে, তোমাদের বের করে এনেছেন। ");
INSERT INTO benirv_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","আমার সামনে তোমার অন্য দেবতা না থাকুক। ");
INSERT INTO benirv_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","তুমি তোমার জন্য খোদাই করা প্রতিমা তৈরী কর না; উপরে অবস্থিত স্বর্গে, নীচে অবস্থিত পৃথিবীতে ও পৃথিবীর নীচে অবস্থিত জলে যা যা আছে, তাদের কোনো মূর্ত্তি তৈরী কর না; ");
INSERT INTO benirv_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","তুমি তাদের কাছে নত হয়ো না এবং তাদের সেবা কর না; কারণ তোমার ঈশ্বর সদাপ্রভু আমি ঈর্ষাপরায়ণ ঈশ্বর; আমি পূর্বপুরুষদের অপরাধের শাস্তি ছেলে মেয়েদের ওপরে দিই, যারা আমাকে ঘৃণা করে, তাদের তৃতীয় চতুর্থ প্রজন্ম পর্যন্ত দিই; ");
INSERT INTO benirv_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","কিন্তু যারা আমাকে ভালবাসে ও আমার আজ্ঞা সব পালন করে, আমি তাদের হাজার পুরুষ পর্যন্ত দয়া করি। ");
INSERT INTO benirv_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","তোমার ঈশ্বর সদাপ্রভুর নাম অনর্থক নিয় না, কারণ যে কেউ তাঁর নাম অনর্থক নেয়, সদাপ্রভু তাকে নির্দোষ করবেন না। ");
INSERT INTO benirv_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","তোমার ঈশ্বর সদাপ্রভু আদেশ করেছেন তেমন বিশ্রামদিন পালন করে পবিত্র কোরো। ");
INSERT INTO benirv_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","কারণ ছয় দিন পরিশ্রম কোরো এবং নিজের সব কাজ কোরো; ");
INSERT INTO benirv_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","কিন্তু সপ্তম দিন তোমার ঈশ্বর সদাপ্রভুর জন্য বিশ্রামদিন; এই দিনের তুমি কোনো কাজ কর না, না তুমি, না তোমার ছেলে, না তোমার মেয়ে, না তোমার দাস দাসী, না তোমার গরু, না গাধা, না অন্য কোনো পশু, না তোমার ফটকের মাঝখানের বিদেশী, কেউ কোনো কাজ কর না; তোমার দাস ও তোমার দাসী যেন তোমার মতো বিশ্রাম পায়। ");
INSERT INTO benirv_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","মনে রেখো, মিশর দেশে তুমি দাস ছিলে এবং তোমার ঈশ্বর সদাপ্রভু শক্তিশালী হাত ও ক্ষমতা প্রদর্শনের মাধ্যমে সেখান থেকে তোমাকে বের করে এনেছেন; এই জন্য তোমার ঈশ্বর সদাপ্রভু বিশ্রামদিন পালন করতে তোমাকে আদেশ দিয়েছেন। ");
INSERT INTO benirv_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","তোমার ঈশ্বর সদাপ্রভু যেমন আদেশ করেছেন তোমার বাবাকে ও তোমার মাকে সম্মান কোরো; যেন তোমার ঈশ্বর সদাপ্রভু তোমাকে যে দেশ দেন, সেই দেশে তুমি দীর্ঘদিন বেঁচে থাক ও তোমার সঙ্গে যেন ভালো হয়। ");
INSERT INTO benirv_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","তোমরা নরহত্যা কোরো না। ");
INSERT INTO benirv_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","তোমরা ব্যভিচার কোরো না। ");
INSERT INTO benirv_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","তোমরা চুরি কোরো না। ");
INSERT INTO benirv_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","তোমরা প্রতিবেশীর বিরুদ্ধে মিথ্যা সাক্ষ্য দিও না। ");
INSERT INTO benirv_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","তোমরা প্রতিবেশীর স্ত্রীতে লোভ কোরো না; প্রতিবেশীর বাড়িতে কি ক্ষেতে, কিংবা তার দাসে কি দাসীতে, কিংবা তার গরুতে কি গাধাতে, প্রতিবেশীর কোনো জিনিসেই লোভ কোরো না।’ ");
INSERT INTO benirv_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","সদাপ্রভু পর্বতে আগুনের, মেঘের ও ঘন অন্ধকারের মধ্যে থেকে তোমাদের সমস্ত সমাজের কাছে এই সমস্ত কথা উচ্চ স্বরে বলেছিলেন, তিনি আর কোনো কথা যোগ করেননি। পরে তিনি এই সমস্ত কথা দুটি পাথরের ফলকে লিখে আমাকে দিয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","যখন তোমরা অন্ধকারের মধ্যে থেকে সেই রব শুনতে পেলে এবং আগুনে পর্বত জ্বলছিল, তখন তোমরা, তোমাদের বংশের প্রধানরা ও প্রাচীনরা সবাই আমার কাছে এসে বলল। ");
INSERT INTO benirv_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","তুমি বললে, ‘দেখ, আমাদের ঈশ্বর সদাপ্রভু আমাদের কাছে নিজের প্রতাপ ও মহিমা দেখালেন এবং আমরা আগুনের মধ্যে থেকে তাঁর রব শুনতে পেলাম; আজ আমরা দেখেছি যে যখন ঈশ্বর মানুষের সঙ্গে কথা বলেন, তারা বাঁচতে পারে। ");
INSERT INTO benirv_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","কিন্তু আমরা এখন কেন মারা যাব? ঐ বিশাল আগুন তো আমাদেরকে গ্রাস করবে; আমরা যদি আমাদের ঈশ্বর সদাপ্রভুর রব আবার শুনি, তবে মারা যাব। ");
INSERT INTO benirv_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","কারণ মানুষের মধ্যে এমন কে আছে যে, আমরা যেমন করেছি আমাদের মতো আগুনের মধ্যে থেকে জীবন্ত ঈশ্বরের রব শুনে বেঁচেছে? ");
INSERT INTO benirv_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","তোমার জন্য, তুমি যাও এবং আমাদের ঈশ্বর সদাপ্রভু যে সব কথা বলেন, তা শোনো; আমাদের ঈশ্বর সদাপ্রভু তোমাকে যা যা বলবেন, সেই সব কথা তুমি আমাদেরকে বল; আমরা তা শুনে পালন করব।’ ");
INSERT INTO benirv_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","তোমরা যখন আমাকে এই কথা বললে, তখন সদাপ্রভু তোমাদের সেই কথার রব শুনলেন; তিনি আমাকে বললেন, আমি এই সব লোকদের কথা শুনেছি, তারা যা তোমাকে বলেছে; তারা যা বলেছে তা ভালই বলেছে। ");
INSERT INTO benirv_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","আহা, সবদিন আমাকে ভয় করতে ও আমার আদেশ সব পালন করতে যদি ওদের এরকম মন থাকে, তবে ওদের ও তাদের ছেলে মেয়েদের চিরকাল ভালো হবে।” ");
INSERT INTO benirv_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","যাও তাদেরকে বল, “তোমাদের তাঁবুতে ফিরে যাও।” ");
INSERT INTO benirv_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","কিন্তু তুমি আমার কাছে এই জায়গায় দাঁড়াও, তুমি ওদেরকে যা যা শেখাবে, আমি তোমাকে সেই সমস্ত আজ্ঞা, বিধি ও শাসন শেখাবো; যেন আমি যে দেশ অধিকারের জন্য ওদেরকে দিচ্ছি, সেই দেশে ওরা তা পালন করে। ");
INSERT INTO benirv_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","অতএব তোমাদের ঈশ্বর সদাপ্রভু তোমাদেরকে যেমন আদেশ দিলেন, তা পালন করবে, তুমি ডান দিকে কি বাম দিকে ঘুরবে না। ");
INSERT INTO benirv_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","তোমাদের ঈশ্বর সদাপ্রভু তোমাদেরকে যে আদেশ দিলেন, সেই সব পথে চলবে; যেন তোমরা বাঁচতে পার ও তোমাদের ভালো হয় এবং যে দেশ তোমরা অধিকার করবে, সেখানে তোমাদের দীর্ঘায়ু হয়। ");
INSERT INTO benirv_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","তোমাদেরকে শিক্ষা দেবার জন্যে তোমাদের ঈশ্বর সদাপ্রভু আমাকে এই আজ্ঞা, বিধি ও শাসন আদেশ করেছেন; যেন তোমরা যে দেশ অধিকার করতে যর্দ্দন পার হয়ে যাচ্ছ, সেই দেশে সে সব পালন কর; ");
INSERT INTO benirv_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","যেন তোমার ঈশ্বর সদাপ্রভুকে তুমি ভয় কর, তোমার ছেলে ও তোমার নাতিরা সারাজীবন আমার দেওয়া আদেশ সব পালন কর, এই ভাবে যেন তোমাদের দীর্ঘায়ু হয়। ");
INSERT INTO benirv_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","অতএব হে ইস্রায়েল, শোনো, এ সব পালন কর, তাতে তোমার পূর্বপুরুষদের ঈশ্বর সদাপ্রভু তোমাকে যেমন বলেছেন, সেই অনুসারে দুধ ও মধু প্রবাহী দেশে তোমার ভালো হবে ও তোমরা বহুগুণ বৃদ্ধি পাবে। ");
INSERT INTO benirv_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","হে ইস্রায়েল, শোনো; আমাদের ঈশ্বর সদাপ্রভু এক; ");
INSERT INTO benirv_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","আর তুমি তোমার সমস্ত হৃদয়, তোমার সমস্ত প্রাণ ও তোমার সমস্ত শক্তি দিয়ে তোমার ঈশ্বর সদাপ্রভুকে ভালবাসবে। ");
INSERT INTO benirv_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","আর এই যে সব কথা আমি আজ তোমাকে আদেশ করছি, তা তোমার হৃদয়ে থাকবে ");
INSERT INTO benirv_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","এবং তোমরা তোমাদের ছেলেময়েদেরকে যত্ন সহকারে শিক্ষা দেবে এবং বাড়িতে বসার কিংবা রাস্তায় চলার দিনের এবং শোয়ার দিন কিংবা ঘুম থেকে ওঠার দিনের ঐ সব বিষয়ে কথাবার্তা বলবে। ");
INSERT INTO benirv_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","আর তোমার হাতে চিহ্নের মতো সে সব বেঁধে রাখবে ও সে সব তোমার দুই চোখের মাঝে বেঁধে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","আর তোমার ঘরের দরজার কবাটে ও তোমার ফটকে তা লিখে রাখবে। ");
INSERT INTO benirv_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","তোমার পূর্বপুরুষ অব্রাহামের, ইস্‌হাকের ও যাকোবের কাছে তোমার ঈশ্বর সদাপ্রভু তোমাকে যে দেশ দিতে শপথ করেছেন, সে দেশে তিনি তোমাকে নিয়ে গেলে পর তুমি যা নির্মাণ করনি, এমন বিশাল ও সুন্দর শহর ");
INSERT INTO benirv_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","এবং যাতে কিছুই সঞ্চয় করনি, ভালো ভালো জিনিসে পরিপূর্ণ এমন সব বাড়ি যা তৈরী করনি, এমন সব কুয়ো যা খনন করনি, এমন সব আঙ্গুরক্ষেত ও জিত গাছ যা রোপণ করনি, তুমি খাবে এবং সন্তুষ্ট হবে, ");
INSERT INTO benirv_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","তারপর সাবধান থেকো যেন তুমি সদাপ্রভুকে ভুলে না যাও, যিনি মিশর দেশ থেকে, দাসত্বের বাড়ি থেকে, তোমাকে বের করে এনেছেন। ");
INSERT INTO benirv_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","তুমি তোমার ঈশ্বর সদাপ্রভুকেই সম্মান করবে, তাঁরই উপাসনা করবে ও তাঁরই নামে শপথ করবে। ");
INSERT INTO benirv_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","তোমরা অন্য দেবতাদের, চারদিকের জাতিদের দেবতাদের অনুসারী হয়ো না; ");
INSERT INTO benirv_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","কারণ তোমার মাঝে তোমার ঈশ্বর সদাপ্রভু স্ব গৌরব রক্ষণশীল ঈশ্বর পাছে তোমার ঈশ্বর সদাপ্রভুর রাগ তোমার বিরুদ্ধে জ্বলে ওঠে, আর তিনি পৃথিবী থেকে তোমাকে ধ্বংস করেন। ");
INSERT INTO benirv_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","তোমরা মঃসাতে যেমন করেছিলে, তেমনি তোমাদের ঈশ্বর সদাপ্রভুর পরীক্ষা কর না। ");
INSERT INTO benirv_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","তোমরা তোমাদের ঈশ্বর সদাপ্রভুর আজ্ঞা, সাক্ষ্য ও বিধি সকল যত্ন সহকারে পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","আর সদাপ্রভুর দৃষ্টিতে যা সঠিক ও ভালো, তাই করবে, যেন তোমার ভালো হয়; এবং সদাপ্রভু যে দেশের বিষয়ে তোমার পূর্বপুরুষদের কাছে এই শপথ করেছেন যে, তিনি তোমার সামনে থেকে তোমার সমস্ত শত্রুকে তাড়িয়ে দেবেন, ");
INSERT INTO benirv_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","যেন তুমি সদাপ্রভুর কথা অনুসারে সেই উত্তম দেশে প্রবেশ করে তা অধিকার করতে পার। ");
INSERT INTO benirv_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","আগামী দিনের যখন তোমার ছেলে জিজ্ঞাসা করবে, “আমাদের ঈশ্বর সদাপ্রভু তোমাদেরকে যে সব সাক্ষ্য, বিধি ও শাসন আদেশ করেছেন, সে সবের অর্থ কি?” ");
INSERT INTO benirv_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","তখন তুমি তোমার ছেলেকে বলবে, “আমরা মিশর দেশে ফরৌণের দাস ছিলাম, আর সদাপ্রভু শক্তিশালী হাতে মিশর থেকে আমাদের বের করে এনেছেন ");
INSERT INTO benirv_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","এবং আমাদের সামনে সদাপ্রভু মিশরে, ফরৌণে ও তাঁর সমস্ত বংশে মহৎ ও কষ্টকর নানা চিহ্ন ও অদ্ভুত লক্ষণ দেখালেন ");
INSERT INTO benirv_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","এবং তিনি আমাদেরকে সেখান থেকে বের করে এনেছেন, যেন তিনি আমাদেরকে নিয়ে আসেন, যেন আমাদের পূর্বপুরুষদের কাছে যে দেশ দেবার জন্য শপথ করেছিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","আর সদাপ্রভু আমাদেরকে এই সমস্ত বিধি পালন করতে, আমাদের ঈশ্বর সদাপ্রভুকে ভয় করতে আজ্ঞা করলেন, যেন সারাজীবন আমাদের ভালো হয়, আর তিনি আজকের মত যেন আমাদেরকে জীবন্ত রাখেন। ");
INSERT INTO benirv_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","যদি আমরা আমাদের ঈশ্বর সদাপ্রভুর আদেশ অনুসারে তাঁর সামনে এই সমস্ত বিধি পালন করলে আমাদের ধার্ম্মিকতা হবে।” ");
INSERT INTO benirv_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","তুমি যে দেশ অধিকার করতে যাচ্ছ, সেই দেশে যখন তোমরা ঈশ্বর সদাপ্রভু তোমাকে নিয়ে যাবেন ও তোমার সামনে থেকে অনেক জাতিকে, হিত্তীয়, গির্গাশীয়, ইমোরীয়, কনানীয়, পরিষীয়, হিব্বীয় ও যিবূষীয়, তোমার থেকে বড় ও শক্তিশালী এই সাত জাতিকে, তাড়িয়ে দেবেন; ");
INSERT INTO benirv_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","এবং সদাপ্রভু তোমার ঈশ্বর যখন তোমাকে তাদের থেকে জয়ী করবেন যখন তুমি যুদ্ধে তাদের সম্মুখীন হবে এবং তুমি তাদেরকে আঘাত করবে, তখন তাদেরকে সম্পূর্ণভাবে ধ্বংস করবে; তাদের সঙ্গে কোনো চুক্তি করবে না বা তাদের প্রতি দয়া করবে না। ");
INSERT INTO benirv_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","আর তাদের সঙ্গে বিয়ের সম্বন্ধ করবে না; তুমি তাদের ছেলেকে তোমার মেয়ে দেবে না ও আপন ছেলের জন্য তাদের মেয়েকে গ্রহণ করবে না। ");
INSERT INTO benirv_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","কারণ সে তোমার ছেলেকে আমার অনুসরণ থেকে ফেরাবে, আর তারা অন্য দেবতাদের সেবা করবে; তাই তোমাদের প্রতি সদাপ্রভুর রাগ জ্বলে উঠবে এবং তিনি তোমাকে তাড়াতাড়ি ধ্বংস করবেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","তোমরা তাদের প্রতি এরকম ব্যবহার করবে; তাদের যজ্ঞবেদি সব ভেঙে ফেলবে, তাদের থাম সব ভেঙে ফেলবে, তাদের আশেরা মূর্ত্তি সব কেটে ফেলবে এবং তাদের খোদাই করা প্রতিমা সব আগুনে পুড়িয়ে দেবে। ");
INSERT INTO benirv_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","কারণ তুমি তোমার ঈশ্বর সদাপ্রভুর পবিত্র লোক; পৃথিবীতে যত লোক আছে, সে সবের মধ্যে তার নিজস্ব লোক করার জন্য তোমার ঈশ্বর সদাপ্রভু তোমাকেই বেছেছেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","অন্য সব লোকের থেকে তোমরা সংখ্যায় বেশি, এই জন্য যে সদাপ্রভু তোমাদেরকে ভালবেসেছেন ও বেছে নিয়েছেন, তা না; কারণ সব লোকের মধ্যে তোমরা কয়েকজন ছিলে। ");
INSERT INTO benirv_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","কিন্তু সদাপ্রভু তোমাদেরকে ভালবাসেন এবং তোমাদের পূর্বপুরুষদের কাছে যে শপথ করেছেন, তা রক্ষা করেন, তার জন্যে সদাপ্রভু শক্তিশালী হাতের মাধ্যমে তোমাদেরকে বের করে এনেছেন এবং দাসের বাড়ি থেকে, মিশরের রাজা ফরৌণের হাত থেকে, তোমাদেরকে উদ্ধার করেছেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","অতএব তুমি জানো যে, সদাপ্রভুই তোমার ঈশ্বর, তিনিই ঈশ্বর, তিনি বিশ্বস্ত ঈশ্বর, যারা তাঁকে ভালবাসে ও তাঁর আদেশ পালন করে, তাদের জন্য হাজার প্রজন্ম পর্যন্ত দয়া ও নিয়ম রক্ষা করেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","কিন্তু যারা তাঁকে ঘৃণা করে, তাদেরকে ধ্বংস করে তাদের সামনে প্রতিশোধ দেন; তিনি তাঁর বিদ্বেষীর ওপরে ক্ষমাশীল হন না, তাঁর সামনেই তাকে প্রতিশোধ দেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","অতএব আমি আজ তোমাকে যে আদেশ ও যে সব বিধি ও ব্যবস্থা বলি, সে সব পালন করবে। ");
INSERT INTO benirv_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","তোমরা যদি এই সব আদেশ শোনো এবং সব রক্ষা ও পালন কর, তবে তোমার ঈশ্বর সদাপ্রভু তোমার পূর্বপুরুষদের কাছে যে নিয়ম ও দয়ার বিষয়ে শপথ করেছেন, তোমার পক্ষে তা রক্ষা করবেন ");
INSERT INTO benirv_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","তিনি তোমাকে ভালবাসবেন, আশীর্বাদ করবেন ও বহুগুণ করবেন; আর তিনি যে দেশ তোমাকে দিতে তোমার পূর্বপুরুষদের কাছে শপথ করেছেন, সেই দেশে তোমার গর্ভের ফল, তোমার মাটির ফল, তোমার শস্য, তোমার আঙ্গুর রস, তোমার তেল, তোমার গরুদের শাবক ও তোমার মেষদের পাল, এই সব কিছুতে আশীর্বাদ করবেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","সব লোকেদের থেকে তুমি আশীর্বাদযুক্ত হবে, তোমার মধ্যে কি তোমার পশুদের মধ্যে কোনো পুরুষ কিম্বা কোনো স্ত্রী নিঃসন্তান হবে না। ");
INSERT INTO benirv_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","আর সদাপ্রভু তোমার থেকে সব রোগ দূর করবেন; এবং মিশরীয়দের যে সকল খারাপ রোগ তুমি জানো, তা তোমাকে দেবেন না, কিন্তু তোমার সব ঘৃণাকারীকে দেবেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","আর তোমার ঈশ্বর সদাপ্রভু তোমার হাতে যে সব লোকদেরকে সমর্পণ করবেন, তুমি তাদেরকে গ্রাস করবে; তোমার চোখ তাদের প্রতি দয়া না করুক এবং তুমি তাদের দেবতাদের সেবা কর না, কারণ তা তোমার জন্য একটি ফাঁদ হবে। ");
INSERT INTO benirv_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","যদি তুমি মনে মনে বল, “এই জাতিরা আমার থেকেও বহুসংখ্যক, আমি কেমন করে এদেরকে অধিকারহীন করব?” ");
INSERT INTO benirv_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","তুমি তাদেরকে ভয় পেও না; তোমার ঈশ্বর সদাপ্রভু ফরৌণের ও সমস্ত মিশরের প্রতি যা করেছেন, ");
INSERT INTO benirv_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","আর মহা কষ্টভোগ যে সব তুমি নিজের চোখে দেখেছ এবং যে সব চিহ্ন, অদ্ভুত লক্ষণ এবং যে শক্তিশালী হাত ও ক্ষমতা প্রদর্শনের মাধ্যমে তোমার ঈশ্বর সদাপ্রভু তোমাকে বের করে এনেছেন, সেই সব নিশ্চয়ই মনে রাখবে; তুমি যাদেরকে ভয় করছ, সেই সব লোকের প্রতি তোমার ঈশ্বর সদাপ্রভু সেরকম করবেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","তাছাড়া যারা অবশিষ্ট থেকে তোমার অস্তিত্ব থেকে নিজেদেরকে লুকাবে, যতক্ষণ তাদের বিনাশ না হয়, ততক্ষণ পর্যন্ত তোমার ঈশ্বর সদাপ্রভু তাদের মধ্যে ভীমরুল পাঠাবেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","তুমি তাদের থেকে ভীত হয়ো না, কারণ তোমার ঈশ্বর সদাপ্রভু তোমার সঙ্গে, তিনি মহান ও ভয়ঙ্কর ঈশ্বর। ");
INSERT INTO benirv_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","আর তোমার ঈশ্বর সদাপ্রভু তোমার সামনে থেকে ঐ জাতিদেরকে কিছু কিছু করে তাড়িয়ে দেবেন; তুমি তাদেরকে একসঙ্গে ধ্বংস করতে পারবে না পাছে তোমার চারপাশে বন্যপশুরা বেড়ে ওঠে। ");
INSERT INTO benirv_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","কিন্তু তোমার ঈশ্বর সদাপ্রভু তোমার সামনে তাদেরকে সমর্পণ করবেন এবং যে পর্যন্ত তারা ধ্বংস না হয়, ততক্ষণ মহাভ্রান্তিতে তাদেরকে ভ্রান্ত করবেন। ");
INSERT INTO benirv_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","আর তিনি তাদের রাজাদের তোমার অধিকারে দেবেন এবং তুমি আকাশমণ্ডলের নীচে থেকে তাদের নাম ধ্বংস করবে; যে পর্যন্ত তাদেরকে ধ্বংস না করবে, ততক্ষণ তোমার সামনে কেউ দাঁড়াতে পারবে না। ");
INSERT INTO benirv_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","তোমরা তাদের খোদাই করা প্রতিমা সব আগুনে পুড়িয়ে দেবে; তুমি যেন ফাঁদে না পড়, এই জন্য তাদের গায়ের রূপা কি সোনা লোভ করবে না ও নিজের জন্য তা গ্রহণ করবে না, কারণ তা তোমার ঈশ্বর সদাপ্রভুর ঘৃণ্য বস্তু; ");
INSERT INTO benirv_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","আর তুমি ঘৃণ্য বস্তু নিজের গৃহে আনবে না এবং পূজা করবে না, ফলে তার মত বর্জিত হও; কিন্তু তা একদম ঘৃণা করবে ও অবজ্ঞা করবে, যেহেতু তা বাদ দেওয়া জিনিস। ");
INSERT INTO benirv_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","আজ আমি তোমাদেরকে যে সব আদেশ দিচ্ছি, তোমরা সে সব পালন করবে, যেন বাঁচতে পার ও বহুগুণ হও এবং সদাপ্রভু যে দেশের বিষয়ে তোমাদের পূর্বপুরুষদের কাছে শপথ করেছেন, সেই দেশে প্রবেশ কর এবং অধিকার কর। ");
INSERT INTO benirv_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","আর তুমি সে সব পথ মনে রাখবে, যে পথে তোমার ঈশ্বর সদাপ্রভু তোমাকে এই চল্লিশ বছর মরুপ্রান্তে নেতৃত্ব দিয়েছেন, যেন তোমার পরীক্ষা করার জন্যে, অর্থাৎ তুমি তাঁর আদেশ পালন করবে কি না, এই বিষয়ে তোমার মনে কি আছে তা জানবার জন্যে তোমাকে নম্র করেন। ");
INSERT INTO benirv_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","তিনি তোমাকে নম্র করলেন ও তোমাকে ক্ষুধিত করে তোমার অজানা ও তোমার পূর্বপুরুষদের অজানা মান্না দিয়ে প্রতিপালন করলেন; যেন তিনি তোমাকে জানাতে পারেন যে, মানুষ শুধু রুটিতে বাঁচে না, কিন্তু সদাপ্রভুর মুখ থেকে যা যা বের হয়, তাতেই মানুষ বাঁচে। ");
INSERT INTO benirv_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","এই চল্লিশ বছর তোমার গায়ে তোমার পোশাক পুরোনো হয়নি ও সেই চল্লিশ বছরে তোমার পা ফুলে যায়নি। ");
INSERT INTO benirv_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","তোমার হৃদয়ে চিন্তা করে দেখো, মানুষ যেমন নিজের ছেলেকে শাসন করে, তোমার ঈশ্বর সদাপ্রভু তোমাকে সেরকম শাসন করেন। ");
INSERT INTO benirv_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","আর তুমি নিজের ঈশ্বর সদাপ্রভুর আদেশ সব পালন করবে যাতে তাঁর পথে চলতে পারো ও তাঁকে ভয় করো। ");
INSERT INTO benirv_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","কারণ তোমার ঈশ্বর সদাপ্রভু তোমাকে এক উত্তম দেশে নিয়ে যাচ্ছেন; সে দেশে উপত্যকা ও পর্বত থেকে বের হয়ে আসা জলস্রোত, ঝরনা ও গভীর জলাশয় আছে; ");
INSERT INTO benirv_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","সেই দেশে গম, যব, আঙ্গুর গাছ, ডুমুর গাছ ও ডালিম এবং জিতগাছ ও মধু হয়; ");
INSERT INTO benirv_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","সেই দেশে খাওয়ার বিষয়ে খরচ করতে হবে না, তোমার কোনো জিনিসের অভাব হবে না; সেই দেশের লোহার পাথর ও সেখানকার পর্বত থেকে তুমি তামা খুঁড়বে। ");
INSERT INTO benirv_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","আর তুমি খেয়ে তৃপ্তি পাবে এবং তোমার ঈশ্বর সদাপ্রভুর দেওয়া সেই ভালো দেশের জন্য তাঁর ধন্যবাদ করবে। ");
INSERT INTO benirv_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","সাবধান, তোমার ঈশ্বর সদাপ্রভুকে ভুলে যেও না; আমি আজ তাঁর যে সব আদেশ, শাসন ও বিধি তোমাকে দিচ্ছি, সে সব পালন করতে ভুল কর না। ");
INSERT INTO benirv_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","তুমি খেয়ে তৃপ্তি পেলে, ভালো বাড়ি তৈরী করে বাস করলে, ");
INSERT INTO benirv_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","তোমার গরু মোষের পাল বহুগুণ হলে, তোমার সোনা ও রূপা বাড়লে এবং তোমার সব সম্পত্তি বহুগুণ হলে ");
INSERT INTO benirv_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","তোমার হৃদয়কে গর্বিত হতে দিও না এবং তোমার ঈশ্বর সদাপ্রভুকে ভুলে যেও না, যিনি মিশর দেশ থেকে, দাসের বাড়ি থেকে, তোমাকে বের করে এনেছেন; ");
INSERT INTO benirv_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","যিনি সেই ভয়ানক বিশাল মরুভূমি দিয়ে, জ্বালাদায়ী বিষধর ও কাঁকড়া বিছায় ভর্তি জলশূন্য মরুভূমি দিয়ে, তোমাকে নেতৃত্ব দিলেন এবং চক্‌মকি পাথর থেকে তোমার জন্যে জল বের করলেন; ");
INSERT INTO benirv_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","যিনি তোমার পূর্বপুরুষদের অজানা মান্নার মাধ্যমে মরুপ্রান্তে তোমাকে প্রতিপালন করলেন; যেন তিনি তোমার ভবিষ্যতের মঙ্গলের জন্যে তোমাকে নম্র করতে ও তোমার পরীক্ষা করতে পারেন। ");
INSERT INTO benirv_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","আর মনে মনে বল না যে, “আমারই শক্তিতে ও হাতের জোরে আমি এই সব ঐশ্বর্য্য পেয়েছে।” ");
INSERT INTO benirv_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","কিন্তু তোমার ঈশ্বর সদাপ্রভুকে মনে রাখবে, কারণ তিনি তোমার পূর্বপুরুষদের কাছে নিজের যে নিয়মের বিষয়ে শপথ করেছেন, তা আজকের মত স্থির করার জন্যে তিনিই তোমাকে ঐশ্বর্য্য লাভের ক্ষমতা দিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","আর যদি তুমি কোনো ভাবে নিজের ঈশ্বর সদাপ্রভুকে ভুলে যাও, অন্য দেবতাদের অনুগামী হও, তাদের সেবা কর ও তাদেরকে সম্মান জানাও, তবে আমি তোমাদের বিরুদ্ধে আজ এই সাক্ষ্য দিচ্ছি, তোমরা অবশ্যই ধ্বংস হবে। ");
INSERT INTO benirv_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","তোমাদের ঈশ্বর সদাপ্রভুর কন্ঠস্বরে কান না দিলে, তোমাদের সামনে সদাপ্রভু যে জাতিদেরকে ধ্বংস করছেন, তাদেরই মতো তোমরা ধ্বংস হবে। ");
INSERT INTO benirv_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","হে ইস্রায়েল, শোনো, তুমি নিজের থেকে মহান ও শক্তিশালী জাতিদেরকে, আকাশ পর্যন্ত দেওয়ালে ঘেরা বিশাল শহরগুলিকে, অধিকারচ্যুত করতে আজ যর্দ্দন (নদী) পার হয়ে যাচ্ছ; ");
INSERT INTO benirv_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","সেই জাতি বিশাল ও লম্বা, তারা অনাকীয়দের সন্তান; তুমি তাদেরকে জান, আর তাদের বিষয়ে তুমি তো এ কথা শুনেছ যে, “অনাক সন্তানদের সামনে কে দাঁড়াতে পারে?” ");
INSERT INTO benirv_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","কিন্তু আজ তুমি এটা জানো যে, তোমার ঈশ্বর সদাপ্রভু নিজে গ্রাসকারী আগুনের মতো তোমার আগে আগে যাচ্ছেন; তিনি তাদেরকে ধ্বংস করবেন, তাদেরকে তোমার সামনে নীচু করবেন; তাতে সদাপ্রভু তোমাকে যেমন বলেছেন, তেমনি তুমি তাদেরকে তাড়িয়ে দেবে ও তাড়াতাড়ি ধ্বংস করবে। ");
INSERT INTO benirv_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","তোমার ঈশ্বর সদাপ্রভু যখন তোমার সামনে থেকে তাদেরকে তাড়িয়ে দেবেন, তখন মনে মনে এমন ভেবো না যে, “আমার ধার্মিকতার জন্য সদাপ্রভু আমাকে এই দেশ অধিকার করাতে এনেছেন।” কারণ জাতিদের দুষ্টতার জন্যই সদাপ্রভু তাদেরকে তোমার সামনে থেকে তাড়িয়ে দেবেন। ");
INSERT INTO benirv_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","তোমার ধার্ম্মিকতা কিংবা হৃদয়ের সরলতার জন্য তুমি যে তাদের দেশ অধিকার করতে যাচ্ছ, তা না; কিন্তু সেই জাতিদের দুষ্টতার জন্য এবং তোমার পূর্বপুরুষ অব্রাহাম, ইস্‌হাক ও যাকোবের কাছে শপথের মাধ্যমে দেওয়া আপনার বাক্য সফল করার জন্যে তোমার ঈশ্বর সদাপ্রভু তোমার সামনে তাদেরকে তাড়িয়ে দেবেন। ");
INSERT INTO benirv_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","অতএব জেনো যে তোমার ঈশ্বর সদাপ্রভু যে তোমার ধার্মিকতার জন্য অধিকার করার জন্য তোমাকে এই উত্তম দেশ দেবেন, তা না; কারণ তুমি একগুঁয়ে জাতি। ");
INSERT INTO benirv_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","তুমি মরুপ্রান্তের মধ্যে নিজের ঈশ্বর সদাপ্রভুকে যেমন অসন্তুষ্ট করেছিলে, তা মনে রেখো, ভুলে যেও না; মিশর দেশ থেকে বের হয়ে আসার দিন থেকে এই জায়গায় আসা পর্যন্ত তোমরা সদাপ্রভুর বিরুদ্ধাচারী হয়ে আসছ। ");
INSERT INTO benirv_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","তোমরা হোরেবেও সদাপ্রভুকে অসন্তুষ্ট করেছিলে এবং সদাপ্রভু যথেষ্ট রেগে গিয়ে তোমাদেরকে ধ্বংস করতে চেয়েছিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","যখন আমি সেই দুটি পাথরের ফলক নেবার জন্যে পর্বতে উঠেছিলাম, তখন চল্লিশ দিন রাত পর্বতে থেকেছিলাম, খাবার খাওয়া কি জল পান করিনি। ");
INSERT INTO benirv_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","আর সদাপ্রভু আমাকে ঈশ্বরের নিজের আঙ্গুল দিয়ে লেখা সেই দুটি পাথরের ফলক দিয়েছিলেন; পর্বতে সমাজের দিনের আগুনের মধ্যে থেকে সদাপ্রভু তোমাদেরকে যা যা বলেছিলেন, সেই সব কথা ঐ দুটি পাথরে লেখা ছিল। ");
INSERT INTO benirv_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","সেই চল্লিশ দিন রাতের শেষে সদাপ্রভু ওই দুটি পাথরের ফলক অর্থাৎ নিয়মের পাথরের ফলক আমাকে দিলেন। ");
INSERT INTO benirv_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","আর সদাপ্রভু আমাকে বললেন, “ওঠ, এ জায়গা থেকে তাড়াতাড়ি যাও; কারণ তোমার যে লোকদেরকে তুমি মিশর থেকে বের করে এনেছ, তারা নিজেদেরকে ভ্রষ্ট করেছে; আমি যে আদেশ তাদেরকে করেছিলাম তা থেকে তারা তাড়াতাড়ি বিপথে চলে গেছে, তারা নিজেদের জন্য ছাঁচে ঢালা প্রতিমা তৈরী করেছে।” ");
INSERT INTO benirv_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","সদাপ্রভু আমাকে আরও বললেন, “আমি এই লোকদেরকে দেখেছি, আর দেখ, তারা খুবই একগুঁয়ে লোক; ");
INSERT INTO benirv_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","তুমি আমার কাছ থেকে সরে যাও, আমি এদেরকে ধ্বংস করে আকাশমণ্ডলের নীচে থেকে এদের নাম মুছে ফেলি; আর আমি তোমাকে এদের থেকে শক্তিশালী ও মহান জাতি করব।” ");
INSERT INTO benirv_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","তখন আমি ফিরে পর্বত থেকে নেমে আসলাম, পর্বত আগুনে জ্বলছিল। তখন আমার দুই হাতে নিয়মের দুটি পাথরের ফলক ছিল। ");
INSERT INTO benirv_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","আমি দেখলাম, আর দেখ, তোমরা নিজেদের ঈশ্বর সদাপ্রভুর বিরুদ্ধে পাপ করেছিলে, নিজেদের জন্য ছাঁচে ঢালা এক বাছুর তৈরী করেছিলে; সদাপ্রভুর আদেশ দেওয়া রাস্তা থেকে তাড়াতাড়ি বিপথে চলে গিয়েছিলে। ");
INSERT INTO benirv_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","তাতে আমি সেই দুটি পাথরের ফলক ধরে নিজের দুই হাত থেকে ফেলে তোমাদের সামনে ভাঙলাম। ");
INSERT INTO benirv_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","আর তোমরা সদাপ্রভুর চোখে যা খারাপ, তা করে যে পাপ করেছিলে, তাঁর অসন্তোষজনক তোমাদের সেই সব পাপের জন্য আমি আগের মতো চল্লিশ দিন ও চল্লিশ রাত সদাপ্রভুর সামনে উপুড় হয়ে থাকলাম, আমি খাবার খায়নি বা জলও পান করে নি। ");
INSERT INTO benirv_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","কারণ সদাপ্রভু তোমাদেরকে ধ্বংস করতে রেগে যাওয়াতে আমি তাঁর রাগ ও অসন্তুষ্টতার জন্য ভয় পেয়েছিলাম; কিন্তু সেই বারেও সদাপ্রভু আমার নিবেদন শুনলেন। ");
INSERT INTO benirv_vpl VALU